﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcdNT_vpl;
CREATE TABLE mcdNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcdNT_vpl WRITE;
INSERT INTO mcdNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Un mato Jesucristohuunoa tsain shara tapimai. Ahuun shunifoan aton anufo un mato yoiqui tau huai. Ahuun shuni David yafi Abraham. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham facu Isaac ini. Isaac facu Jacob ini. Jacob facu Judá yafi ahuun yorafo ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judápan facu Fares yafi Zara ini. Aton ahuari Tamar ini. Fares facu Esrom ini. Esrom facu Aram ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram facu Aminadab ini. Aminadab facu Naasón ini. Naasón facu Salmón ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón facu Booz ini. Ahuun ahuari Rahab ini. Boozpan facu Obed ini. Ahuun ahuari Rut. Obed facu Isaí ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí facu David ini. Nan David Israelifoan aton niaifocoin ipaoni. David facu Salomón ini. Salomón ahuafin Uriaspan ahuin ipaoniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón facu Roboam ini. Roboam facu Abías ini. Abías facu Asa ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa facu Josafat ini. Josafat facu Joram ini. Joram facu Uzías ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías facu Jotam ini. Jotam facu Acaz ini. Acaz facu Ezequías ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías facu Manasés ini. Manasés facu Amón ini. Amón facu Josías ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías facu Jeconías yafi ahuun yorafo ini. Nantianri Babilonia anoa niaifoan ahuun ranushumuafo nichini Israelifo rutushon atirifi ahuun mai ano ihuushonafoanno ahuun oinmatifo huanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chipofin Babilonia anoashu futsafori cainni. Jeconías facu Salatiel ini. Salatiel facu Zorobabel ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel facu Abiud ini. Abiud facu Eliaquim ini. Eliaquim facu Azor ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor facu Sadoc ini. Sadoc facu Aquim ini. Aquim facu Eliud ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud facu Eleazar ini. Eleazar facu Matán ini. Matán facu Jacob ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob facu José ini. José ahuin María nan Jesús ahua ini. Jesús Upa Diosin catonni nocon Numamisi inon. Nan non Cristoran huamisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham ahuun funafo catorce ahuun unutani David ini. David ahuun funafori catorce ahuun unutani Babilonia anoshon ato achinifo ato mai ano inonfo. Nanfoan ahuun funafori catorce ahuun unutani Cristo cainni. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo cainfin iscaniquin. José María yoini, —Non fiananon, —ishon. Ascafia fiananfotaima María man facu nanua ini. José ayamafian Diosin Yoshin Sharapan nanumana. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ascashon José Dios tanasharacoinshon ahuun chain ahuin rafini huacasmaquin yorafoan ointaifi yoicasmani. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nanscara ahuun nomuranshon shinanfiaino ahuun namapan Diosin ahuun oinmatinin afu nai muran imisi aqui oshon yoiquin isca huani, —José minfin David funaquin. Ascacun shinanchacaquima María fihuu. Nan facu nanuafin Diosin Yoshin Sharapan nanumanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ascan nan caianofin anuqui Jesusran min huashquicain. Nantonmain ahuun yorafo chaca soashofain ato numashquiamaiton, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Diosinhuunshon inon pacoai yoimisifoan cununifo cuscan man aaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nanfoan cunuquin isca huani, “Nicapon. Ainfo funuoma tsoa afu iyamafiamisi facu nanushquin. Caianno furonanfacu iishquin. Ahuun anufin Emanuel (Onicoinnin tsainman Diosin nofu icaran) ishquiquin,” ishon Dioshuunshon inon pacoai yoimisi cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ascaino José moinacahuatan nan Diosin oinmatinin afu nai muran imisi yoia cuscan María fiini. ");
INSERT INTO mcdNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fiifiashocai afu ipaonima furun caiyain chain. Ascashu furun caincun José anuqui Jesusran huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ascano Herodes niaifoaitian Jesús Belén anoashu cainni. Nan Belén Judea muran ini. Nantianri fishifohuunoa tapicoianfo fari oaiquirinoashu fucani Jerusalén ano noconifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ascano nococashon ato yocanifo, —Raniashumun a facu caianquin Judiofoan aton niaifo ishquiai. Non fishi oianhuunshon non tapia facu caincun. Man nonfin ahuun fishi fari oai aria oianquin. Ascacufin non aqui unimai oaquin. Min nocon niaiforan ishon oinpai non oaran, —ishon ato yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ascaifoan nicai Herodes ahuun ointi fucashriscatani. Jerusalén anoa yoraforifi Herodes icai cuscan arifi muunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ascacun ahuun yorafohuunshon Diosin cufimisifoan niaifofo yafi Moisés cununi cuscan tapimamisifo Herodes ato yoimaquin isca huani, —Uqui fucahuun, —ishon ato yoimanano aqui fuaifoan ato yocaquin —¿Raniashumun Cristo cainshquiquin? —ishon Herodes ato yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ascaiton cumacaquin, —Belén Judea murannoashu cainshquin, —nannori Diosinhuushon inon pacoai yoimisifoan cunuquin isca huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belén anoafoan ua nicasharacahuun. Maton mai Judea muran. Maton pushu ichapayamafiano nannoashu niaifo uhuapacoin cainshquin. Uhuun yora Israelifoan aton cushumisi iishquiran,” icashu cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ascacun Herodes a fishifohuunoa tapicoianfo tsoa yoitama tsain ato fomaquin isca huani, —Fucahuun. Un matofu tsainon, —ishon ato yoimani. Ascano nocotoshiaifoan ato yocaquin, —¿Ahuutianmun man fishi oinquin tau huaquin? —ishon ato yocaiton. Tapimanifo ahuutianmain oinqui tau huafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ascashon aton yoini, —Belén ano focashon facu funatacahuun. Fuchicashon nasofuratan ua yoi fuushcaquin. Urifi un ahuun noicanon, —ishon Herodes ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ascano niaifoan ato yonoa cuscan nicatan fishifohuunoa tapicoianfo fonifo. Focaquin oianfo fishi fari oaiquirinoashu oaiton oincani unimacoinnifo. Ascatan muufocaquin oianfo facu raca manaon nituni. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ascaiton oincani pushu muran iquifainshon facu yafi ahua María fuchinifo. Ascashon ratoconun mai chachishon facu yoinifo isca huaquin, —Minfin fasi sharashtacoinquin. Min nocon Ifo, —ishon yoinifo. Ascacatan aton mao fupucashon ahuara chicoin inancoinnifo. Oro inanfain ahuun ininti shara inanfain ininti sharacapa futsa ahuun anu mirra nanri inannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ascashu nanno oshayoafoan aton namapan Diosin ato yoiquin isca huani, —Afanan Herodes ari foyamacahuun. Fai futsan mato mai ari fotacahuun, —ishon Diosin ato yoini. Ascacucai Jerusalén ano fonifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Man fishihuunoa tapicoianfo atomaquinoashu foafono Diospan oinmatinin afu nai muran imisi José ahuun namapan yoiquin isca huani, —Funinaca huahuun. Nan facu yafi ahua Egipto ano iyoriscatahuun. Ascashu nanri iyohuu nan un mia afanan yoiaitian. Nan Herodes facu funaiqui rutushquin, —ishon Diospan oinmatinin José yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Asca huaino moinacahuatan facu ahua futan yamu Egipto ano ichoquinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ascashu nanno iyopaonifo nan Herodes naitian. Ascacun Diosihuunshon inonpacoai yoimisiton cunushoni isca huaquin, “Unfin uhuun facu Egipto anoa afanan yoimanicain,” ishon yoini cuscacoin man aaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ascano fishihuunoa tapicoianfo fai futsan foafo nicai, —Ua paraforan, —icashu Herodes fasi sinacoinni. Nan fishifohuunoa tapicoianfoan yoiafo man fari rafu caano fishi oinquin tau huafo. Ascacun Herodes ranushumuafo yononi, —Belén anoafo yafi a chaima icafoan aton furonanfacufo fari rafu yafo non yomumishti rutuqui cuyotacahuun, —ishon ato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ascano “Ato nicafo Ramá anoashu uaicani aton facuhuunoashu uaiyanan shorarascaifoan nicacaquin. Aton ointi main huamapaicaquin, ‘Uaiyamacahuun,’ ato huafiainfono aton facu manocani unupainifomaran,” ishon Jeremías Diosihuunshon inonpacoai yoishomisiton cununi cuscacoin man aaqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ascashu man Herodes naano Diosin oinmatinin afu nai muran icaton José ahuun namapan yoiqui isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Moinacahuahuu. Facu yafi ahua afanan Israelifo muran ato nasoquishquin. A facu rutupaimisifo man naafoquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ascaino moinacahuatan José ahua yafi furun Israeli mai ano afanan ato iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Caaquin nica Herodes man naano ahuun facu Arquelao Judea murannoa niaifo nicai José musuni. Ascaiton Diosin oinmati afu nai muran imisiton afanan ahuun namapan yoini, —Judea muran caquima futsanori catahuun, —huani. Ascano Judea muran catama Galilea anori fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ascashu Nazaret pushurasi muran fonifo. Diosihuunshon inon pacoai yoimisiton nannori cunuquin isca huani, “Cristofin Nazarenon ishquiquin,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ascatan man fari ichapa finoanno nan Juan yorafo unu muran iquimamisi tsoa istaipama Judea ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ascano nannoshon ato yoiquin isca huani, —Nantifi yorafoan ua nicacahuun. Maton chaca shatucoincashon Diosin tsain nicacoincahuun. Samamashta Diosin mato yonoshqui oiquin, —ishon Juanpan oi ashcafinin ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nan Isaías Diosihuunshon inon pacoai cuscan yoimisi ipaoni. Nanton Juanhuunoa yoini isca huaquin, “Tsoan istaipamashon Diosin yonoa cuscan oi ashcafinin yoiquin isca huanonpacoin, ‘Nocon Ifo nocoqui ooshquin. Ascacun itisharacahuun. Maton chaca shatucoincahuun,’ ” ishon Isaías Juanhuunoa cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ascano camello inapan ahuun rani sahuuti huashon Juanpan sahuua ini. Ascashon yoina fichin aqui nanushumuni. Ascatan ocutsuru pifain afuchi fona ayani. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ascano Jerusalén anoafo yafi unu Jordán ano icafo non Judea muran icafori ahuun tsain nicapaicani aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ascashon aton chaca shatupaicaquin yoiaifoan Juanpan unu Jordán muran ato iquimapacuni afanan ipaoni cuscan huatama ismanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ascaino Fariseofo yafi Saduceofo Juanqui funifo yorafo ato unu muran iquimanaiton oin fucani. Nanfori Israelifo ini. Ascaiton oinquin Juanpan ato yoini isca huaquin, —Manfin rono paupaton facu cuscaracoinfoquin. Icoinra huayamaifoan Diosin atoqui sinaquin ato omitsiscapanonfo. Ascan manfin omitsiscapanacafo muran focasmafiaqui maton chaca man shatupaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ascacun chaca shatucoincashon Diosin mato yoia cuscan nicacoincahuun. Man ipaoni cuscari afanan ayamacahuun. Man ascaiton yorafoan ointirofo man afanan chaca huapaitama Dios fusti man tanasharaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ascashon maton nomuran shinanquin isca huayamacahuun, “Nonfin Abraham funafo non ahuun caiforiquin. Diosin Abraham yoiyotiani cuscan nocorifi ashotiro. Ascan Diosin noco onaintimashquimaran,” ishon anori shinanyamacahuun. Diosin onihuapaiquifin na unu cusumunnoa toquirifo Abraham ahuun funafo oni huatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Fana fimi sharayamaiton ifoan ahuun tapo nantifi ruratinin shatuquin cuyoshon chi muran potatiro coi futsunon. Nanscarifiai natianri Diosin man itishara chaca shatutama man isharayamacaiyaiton mato omitsiscamapacushquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ascacun un mato unu muran iquimapacua maton chaca shatucoinshon natian Diosin tanasharashon man ismanon. Ascafia futsa matoqui chipo oi. Naantofin ua fasi finoncoianquin. Ahuamamishti huatiro. Nantorifi ahuun Yoshin Shara mato ya rafumapacunaca. Ascano ahuunshon maton nomuran man shinansharanon. Matofu rafuano nantifi ahuara chacafo ahuunshon shatuashu a cuscara shara man inon. Ascan uncai a cuscarama. Un ahuara shara huahuu rafanancai un ahuun oinmatima. Ascatama uhuun ramapaiyamainoricai un ahuun oinmati icuanama. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ascano naantorifi chipo a icoinra huafo yafi a nicacasmaifo ato pashcanan huaashquin. Nan icoinra huafosi a icari ato ihuicoinshquin afu isharapacushanonfo. Ascan nan nicacasmamisifo chi urumanhuan muran ato potai anoashu omitsiscai unupacunacafomaran, —ishon Juanpan nan Fariseofo yafi Saduceofo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ascaino Jesús Galilea anoashu unu Jordán ano cani. Nan Juanpan ato unu muran iquimana nanno cani naanrifi iquimanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ascashu aqui nocoaiton Juanpan Jesús yoini, —Uacaiarocon mian acafin shara icuanaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús cumani, —Upa Diosin noco yonoa cuscan fusti nantifi non aca shara itiro. Ascan natian ua iquimahuu, —huaiton. —Ascan min ua yoiai cuscan un mia unu muran iquimairan, —ishon Juanpan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Asca huatan Jesús unu muran iquimana cainna cahuan mapuinifoanni. Ascatapaiyaino Dios ica ariashu nai fupuini. Nai fupuicaino Diospan Yoshin Shara ruhui cuscara Jesusqui fotopacu cahuani. ");
INSERT INTO mcdNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ascano nanno niafoan nai murannoa Upa Diosin ahuun oi nicanifo yoiquin isca huaiton, —Nan uhuun Facu un catoan. Un fasi ahuun noi. Un fasi aqui unimacoinran, —ishon Apa Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ascano Jesús Diosin Yoshin Sharapan tsoa istaipama ano iyoni. Nannoshon nan yoshin chaca Satanás cuarenta oshatan chaca huamapaifafainni. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nan cuarenta oshatan piqui tununi. Ascashu fasi fonaincoinni. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ascaino nan yora chaca huamapaimisi aqui nocoshon yoini isca huaquin, —Min Diospan facumainquin na toquirifo misi onihuahuu, —ishon Satanás yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús cumani, —Noncai misi fustihuunoashu ipatiroma. Diosin tsain fusti non yopacoin. Nan noco yoia cuscan fustihuunoashu non isharatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nicaquin Satanás Jesús Jerusalén pushurasi shara Diosin ahuun yorafofu imisi ano iyoni. Nan Israelifoan aton Diosfu tsainti pushu pumancaya cuyacoin iyoshon yoiquin, ");
INSERT INTO mcdNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Minmain Diospan facuquin nuriashu pacucaintahuun. Diosin tsain mihuunoa cununi isca huaquin, “Diosifin ahuun oinmatifo afu nai muran icafo yonoiquin min pacuaiton mia cushunonfo. Min tauri toquirifoquin rutunonma mia achinonfo,” nannorifi Diosin tsain mihuunoa cununiquin, —ishon Satanás yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Afanan Jesús cumani, —Ascafia Diospan tsain cununiri isca huaquin, Ahuara musunicoin huaquin shinanyamacahuun uatsi Diosin cushuiquin ishon. Ascacun asca huayamahuu ishon cununiran, —Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ascaiton afanan Satanás Jesús machi cuyamamaquin iyoshon nan manifoti sharashtacoin oinmani. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ascashon yoini, —Oinpon Mian ratoconun mai chachishon ua yoiquin, “Minfin uhuun Ifoquin,” mian huaitofin nan na maitio un mia inantiroquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Afanan Jesús cumaqui, —Diospan tsain cununiri “Nan nocon Ifo Diosin fustifin non ratoconun mai chachishotiroquin. Nan fustimain nocon Ifocun,” ishon cununi. Ascan umaquinoashu cariscatahuun Satanás, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Asca huaino Satanás Jesusmaquinoashu caino Diosin ahuun oinmatifo afu nai muran icafo aqui fotonifo pimashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ascashu nan Juan ranushumuafoan cunu muran iquimanafo nicatan Jesús Galilea ano nasoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nan Nazaret anoashu pushconi. Nannoashu Capernaum ano cani atofu iyoicai. Nan Galilea ian cusumunri Capernaum ini. Nannori mani rafutan ato mai Zabulonfo yafi Neftalifo icafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Jesús nanno inon pacoai cuscan nan Isaías inon pacoai yoimisiton ahuunoa cunuquin isca huani, “Zabulonfo yafi Neftalifo Galilea ian ano icafo. Nanno aton mai. Unu Jordán ocuma futsa. Nannori Dios icoinra huamafo atofu icafo. Ascashu nanfo faquish muran ica shinantsafo. Ascafia samamashta oianfo shafariscatani cafiscashqui. Nanscarifiai numamisimaisi omitsiscapanacafo muran focuanafo. Ascacun Cristo atoqui nocorisca ato numashquiran,” icashu atohuunoa cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nannoshon Jesús ato yosiquin tau huaquin isca huani, —Nocon Ifo Diosin matoqui samamashta nocoyoi. Ascacun maton chaca shatucahuun. Chaca huatamarocon Diosin tsain nicacoincahuun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ascano ato yoitan Jesús ianmanhuan cusumun cani. Caquin Simón chipocu Andrés futan nushutinin nushuaifoan ato ointoshini. Nan Simón ahuun anu futsa Pedro. Nan rafutafin nushumisicoin inifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ascaiton ato yoiquin, —Ufu fucahuun. Manfin nushumisicoinquin. Man shiman ichaparasi nushutinin fia cuscan natian man uqui yora ichapa ihuushqui un aton Ifo inon, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ascaino nushuti huafaicani afu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ascashu chaimashta catan Zebedeo facu rafuri fuchini. Nan rafuri nanu rafu Santiago yafi Juan. Nan rafutan apa futan shasho naquishon nushuti icushaifoan atori yoini, —Ufu fucahuun, —ato huaino. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Samamashta apa shasho naqui nichifainifocani afu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ascatan afu foafoanno nantishon Galilea ano cahuancacaiquin. Judiofoan ichananti pushu muranshon Jesús ato Apa Diosin tsain shara yoiquin isca huafoanfafaini, —Itisharacahuun. Upa Diosin mato iquishquin oiran, —ishon ato yoifoafafaini. Ascashon pau futsa futsatapafoan icaifoan ato caya huamani. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ascaiton Siria mai anoafoanri ahuunoa nicacashon isinincaifo aqui ihuunifo ato cayahuamapacunon. Ascashon isipaunun icaiton caya huamafain yoshin chaca atomaquinoa potafain nisofori caya huamafain yoratisho charishi futsuari caya huamapaoni. Nantifi ato caya huamapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ascaiton yorafoan mufainifo. Atirifi Galilea anoashu fuaino atirifi Decápolis anoashu fuaino atirifi Jerusalén anoashu fuaino atirifi Judea anoashu fuaino atirifiri unu Jordán oquirinoashu fucatan Jesús mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yorahuanrasi aqui fuaifoan oin Jesús mapufaintan machi pochinin tsaoni. Nanno tsaoano ahuunshon tapiafo a shinain caiton noco yosiquin isca huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Tsoa futsan aton nomuran shinanquin isca huai, “Uficai un isharatiroma. Un Dios yopacoinran,” icaiton Diosin ato unimamashquin. Ascashu uhuun Upa Diosin niaifo ano afu ipatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ascan tsoara futsa uaiquin omitsiscafiashu chipo unimatiro. Diosin atohuun ramapaiquin aton ointi main huamatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cacapaimisi itamarocon futsa ahua huamisima. Mato ahuun nomuran shinanquin isca huai, “Ufi apaiyai cuscan atama Diosin ua amapaiyai cuscan fusti un atiroran,” ishon shinanfafainaiton Diosin ato unimamatiro. Nan cuscarafo Diosin yoiyotiani cuscan ato inanshquin. Diosin icano arifi afu inonfo. Ascashu nantifi ahuunari atonari iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ascan nan ratoranfo Diosifu ipaiquin ahuun tsain tapipaiquin finaifo a cuscara shara iishcaquin. Nan cuscarafoan fuchipaiyaifo cuscan Dios ato imatiro a cuscara shara inonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ascan nan futsafohuun ramapaiquin ato shara huaiton Diosin man tapia. Ascacun nanrifi ahuun ramapaiqui a shara huashopacunaca arifi unimanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ascan nan Dios fusti tanasharashu ahuun nomuran shinansharamisi. Nan cuscarafoan chipo Dios ointirofo. Ascaiton Diosin ato ointi unimamashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ascan tsoan nan noicasmatanainfoan ato raunan huaino afanan rau huantananfo. Nan cuscarafo Diosin yoiquin, isca huaqui, “Min uhuun facuran,” ishon ato yoiaino fasi unimacoinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tsoa Diosin yonoa cuscan aiton futsafoan omitsisca huafiainfoan tunua. Nan cuscarafo Diosin ato unimamashquin. Ascashon nan Diosin niaifo icariafo nanfori atona iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Ascan futsafoan uhuunshon mato roaquin omitsiscamafain matohuunoa chani futsa futsatapafo yoifiaifoanno shinanchacayamacahuun. Mato omitsisca huaifo cuscan mato shunifori nan Diosin tsain yoimisifo omitsisca huapaonifo. Ascan man uhuunoashu omitsiscafiashu Upa Diosiqui man nocoaitian fasi sharacoin mato imashquin man afu ipashanon. Ascacun unimacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ascan manfin nan nuno mai anoa sao cuscaraquin. Nami saomua shara payocotiroma. Nanscarifiai yora chacafo muran ishon marifi man ato shinanmasharatiro chaca huanonfoma. Ascan nami saomuamacai shara itiroma. Paismacoin itiro. Ascafia afanan nami shara iyamainoricai saori shara itiroma. Afanancai ahuashta itiroma. Nanscara non potatiro puamanonfo. Nanscarifiai afanan man ua tanasharayamainocai matohuunshon tsoan ato chaca shatutiroma isharashquin. Man ua tanasharayamashu man funocointiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ascafia manfin nan manifoti ato chasha cuscaraquin. Machi cuya mamaquinoa pushurasi fasi chaicushon shafacafi ointirofo. Onucai atiroma. Nanscarifi aquin man ua tanasharaino mato oinquin matohuunshon ua icoinra huatirofo shafacafi iishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nanscarifi aquin tsoancai faquishiano oinpaifiaquin lamparina tapa camaqui otashon cutipan fupomisima. Ascatamarocon otashon tapa camaqui huatiro shafacafi tsaocun pushu muran iquicaquin oinsharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ascacun nantifi yorafo shara huacoincahuun. Man ato shara huai cuscan oinquin shinantirofo isca huaquin, “Diospan yorafoan fasi noco shara huafafaincani. Apa Diosin ato yosisharamisi. Asca aton Upa Dios fasi sharacoinran,” ishon shinantirofo. Anori shinancaquin maton Upa Dios nai muran ica yoitirofo isca huaquin, “¡Aicho! Upa Diosin tsoa futsacai mia cuscara sharama. Min nantifi finoncoianran,” ishon yoishquicani. Afanan yoitiro isca huaquin, “Dioshuunshon noco shara huashomisifo. Ascan aton Dios sharacoinran,” ishon yoishquicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Isca huaquin man shinan raca, “Moisés Diosin yononi cuscan cunushoni yafi Diosin tsain yoimisi futsafoan cununi cuscari nanfo Jesús noco nicamapaima. Nanfo noco potamapairan,” ishon raca man shinan. Anori shinanyamacahuun. Uncai Moisés yafi Diosin tsain yoimisi futsafoan cununi cuscan potapaiquimarocon man cununifo cuscan un huamashquin un oa. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Un mato shafacafi yoi. Diospan tsain cunushoni cuscan nannorifi Diosin yonoi. Ato yonoquin cunushopaoni cuscan nan fustishtacai funopacunacama. Nai yafi maitio cuyoyamainon nanscasi apanaca ahuun tsainri inonpacoai cununshoni cuscan nantifi fustishtacai cuyopacunacama aqui tau huani cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ascan tsoa Diosin yononi cuscan fustishta potashu non futsafori potamashu Dios icano aacai ahuama itiro. Ascafiaquin tsoan Diosin tsain nicasharafafainquin futsafori Diosin tsain shafacafi yosicun nan Upa Diosin icano niaifo patashari itirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ascano nan Fariseofo non Judiofo aton niaifofo futsafoanri, “Nonfin fasi shara imisiran,” ifianmisishacaquin Diosin yononi cuscan tanacoianfoma. Diosin yononi cuscan huacoinmisifoma. Mancai ato finoanshuma Diosin yononi cuscan man huashuma Upa Diosin icano man nocopacunacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Moisés nocon shunifo yononi cuscan man nicamisi isca huaquin, “Tsoa rutuyamacahuun. Man futsa rutucun niaifofo ano mato iyotiro matori copiquiri namatirofo,” ishon Moisés nocon shunifo yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Cayacafi anori yonofianicun un mato tsain futsa cayacafiri yoinon. Oinfain. Tsoa futsaqui sinaiton a niaifo ari iyotiro a onaintimanon. Ascan tsoan futsaqui tsain chaca huaiton isca huaquin, “Mincai ahuama. Min ahua tapiamaran,” ishon yoiaiton niaifofo ari iyotiro a onaintimanonfo. Ascafia tsoan futsa chaca huai isca huaquin, “Minfin mapo chacaquin. Min nisoncoinran,” huaiton Diosin a omitsiscapanacafo muran nan chi muran potatiro anoashu capashononma. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ascacufin man Dios cufiaitian nantianri man shinanquin isca huaquin, “¡Ohua! Un futsa chaca huaran,” ishon shinancun. Afanan Dios cufitamarocon iquisi nan futsa min chaca huaa ano catahuun. Aqui nocoshon yoisharahuu mia rauhuanon. Asca huano afanan min nasotiro Upa Dios cufishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Man futsa nifishon matoqui nocoaiton isca huaquin, “Min ua nifian cuscacai mian inanma. Natian un mia niaifo ano iyoiran,” ishon mia yoicun. Afu caquin niaifo ano nocoataima rufofo aroshararisca huahuun. Asca huaiyamaiton mato niaifo ano iyotiro. Nocoshon niaifoan ranushumua yoitiro, “Na nocofunun futsa nifian cuscan inanma. Ascan cunu muran iquimatahuun,” huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Un mato icon yoicoin. Mato iquimanano man cainritiroma nifian cuscan atifi inanshuma. Nanscarifi aqui man Dios chaca huamisiquin. Oataima arorisca huahuu mato omitsiscahuapanonma. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Moisés nocon shunifo yononi cuscan man nicamisi isca huaquin, “Maton ahuinma chotayamacahuun. Ainfofoan maton funuma chotamayamacahuun,” ishon yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aafin iconquin. Ascarifi un mato yoirifi huai. Tsoa ainfo ahuun ahuinma oinquin ahuun nomuran shinain, “Un nan ainfo chotapainonran,” ishon nannori shinanquin a chotacoin shinantsai. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ascan man oinquin man chaca huapaiquin maton furon ocuma futsa shara tsucashon potahuu afanan chacanonma. Man mumafiacun omitsiscapanacafo muran mia potacun nancai sharamafinquin. Ascaquimarocon man mumamafiashu Dios icari nocoshon nanno afu ipashanon nan sharacoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nanscarifiai min mumiorishon min mucuman min ahuara min chaca huaiton, min mushtua shara icuana. Man mumafiashu omitsiscapanacafo muran mia potacun nancai sharamafinquin. Ascaquimarocon man mumamafiashu Dios icari nocoshon nanno afu ipashanon nan sharacoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nocon shuni Moisés nocon shunifo yonoqui isca huani, “Tsoan ahuun ahuin unushquin iquisi cunushotiro isca huaquin, ‘Un afanan mia fipaima. Un natian mia unuiran,’ ishon cunushotiro.” ");
INSERT INTO mcdNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nannori Moisés yonofianicun un mato tsain futsa yoinon. Ratoran futsan ahuun ahuin nocofunu futsa fu iyamafiaiton unuquin chaca huaino. Nan ainfoan nocofunu futsa fu fiananquin fasi chaca huai. Asca huaquin nan funu fu iqui shinantsai. Funumain afi unucun. Ascafia nan funun ahuin unua nan ainfo nocofunun fiiquin aarifi chaca huai. Asca huaquin nan ahuun ahuinma fu iqui shinantsa huai. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nocon shuni Moisés afanan tsain futsa nocon shunifo yoini. Nanri man nicamisi isca huaquin, “Man Diosin yoitiani cuscan acahuun. Man Diosin yoitiani cuscan ayamashu nancai sharamafinquin,” ishon Moisés nocon shunifo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mato anori yoini. Un afanan mato yosinon nicacahuun. Yora futsafona yopaquin ato yoiquin, “Un mia yoia cuscan un acunma Upa Diosin ua onaintimatiroran,” ishon afanan anori yoiyamacahuun. “Un mia yoia cuscan un acunma nantifi nai muranshon ua nicatiro Upa Diosin ua onaintimatiroran,” ishon afanan anori yoiyamacahuun. Diosin nai muran ica. Ascan anori yoiyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Un mia yoia cuscan un acunma nuno mai anoa ua onaintimatiroran,” ishon afanan anori yoiyamacahuun. Nantishon mai Upa Diosinna. Ascan anori yoiyamafain, “Un mia acunma nocon pushurasi Jerusalén ano ua copitiroran,” ishon afanan anori yoiyamacahuun. Nan pushurasi Jerusalén nocon niaifocoin Diosina. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Uhuun mapon un shinain cuscan un mia acunma ua onaintimatiroran,” ishon yoiyamacahuun. Maton shinanhuunshon maton fo fiso iyamarai osho imatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ascan maton yora ahuara yoipai ato yoihuu isca huaquin, “Un mia yoia cuscan iconcoin,” iyamarai “Nan iconmaran,” ishon ato yoicahuun. “Un mia acunma ahuara ua onaintimatiroran,” ishon anori yoiyamacahuun. Na yoshin chaca Satanasfin chanimisicoinquin. Ahuunshon yora anori yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ascan nocon shuni Moisés afanan tsain futsa nocon shunifo yononi cuscari man man nicamisi yoiquin isca huanicun, “Futsa mia asca huaiton niaifo ano min iyotiro mia copishonon. Min furo ocuma futsa mia tsucacun copiquiri niaifoan ahuun furo tsucamatiro. Ascan mia sutuquin min shuta fusti tucucun niaifoan copiquiri ahuun shuta fusti tucuntiroran,” ishon Moisés yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nocon shunifo nannori yonofianicun un mato tsain futsa yoiaiton ua nicacahuun. Tsoan mato chaca huafia ato copiyamacahuun. Mato tapasaiton ato copitamarocon nanno nishohuun mia ocuma futsari afiaiton tunuhuu. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Futsan mia niaifo ano iyocun min camisa mia fiainton min sahuuti cushtopari inanhuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ascano ranushumuaton iyamarai futsan mato yonoquin isca huai, “Uhuun forusa kilometro fusti ua foshoicahuun,” ishon mato yonoaiton shinantaquima kilometro rafu foshohuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tsoanran mato ahuara yocaiton ayashon ato inancahuun. Futsan mato yoiquin isca huai, “Ua inanyopun,” mato huaiton inanriscayocahuun. Fishcotama. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ascashon naan maton yorafohuun noicoincahuun. Ascan a mato noicasmaifori copiquirifi ato noicasmacahuun,” ishon nocon shunifoan yoinifo cuscan man man nicamisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nannori yoifianifo un mato yoiquin isca huai, Naan mato noicasmafiaifoan atohuun noicoincahuun. Tsoan mato omitsisca huairi Dios cufishocahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Diosin fari onihuani yora sharafo yafi chacafori chashashonon. Nanscarifi huaquin Diosin oirifi onihuani nan yora sharafo yafi chacafori ato onihuashoni. Diosifin nan tanaifo yafi a chaca huaiforifi ato shara huamisi. Ascacun marifi nanscarifi huacahuun a mato shara huaifo yafi mato chaca huaifori shara huacahuun. Asca huaifin marifi man Diospan facucoinfoshon futsafori man ato ismatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A matohuun noiaifosi copiquirifi man atohuun noiainocai aacai ahuama. Yora chacaforifi ascarifiaifoanno. Man ascainocai Dios mato yoima man shara huaran ishon. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Maton yorafo fustisi man tsain shara yoiaino aacai ahuama. Yora Dios icoinra huaamafori nanscarifiaifoanno. Man ascainocai Diosin mato yoima “Man shara huaran,” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ascano maton Upa Diosin nai muranshon nantifi yorafo noia cuscan marifi nansca huacahuun. Upa Diosin shinansharamisi cuscan marifi shinansharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Oinfain. Man futsafo shara huaino maton nomuran man shinain isca huaquin, “¡Aicho! Un ato shara huacun futsafo ua oincani uqui shinansharanonforan,” ishon anori man shinancai Upa Diosin matoqui unimaima. Mato ahua inainma. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","4","Nan paramisifo cuscara iyamacahuun. Nanfoan atohuunoa yorafo shinansharamacani isca huaquin, “Nan yora fasi sharacoin. Futsafo shara huashoanran,” ishon nannori futsafo atohuunoa shinanmapai. Nantifi ato ointaifi yora shara huapai ato oinonfo. Ascara chaca. Upa Diosin atoqui unimaima. Futsafoan ato, “Min shararan,” huatirofiaino Upa Diosincai atohuunoa tsain shara yoishquima. Atoqui unimaima. Ascan marifi ato cuscara iyamacahuun. Futsafo ato ointaifi ahuuoma inanpaicahuun mato oinonfo. Ascaquimarocon tsoa futsa oinyamaino man ahuuoma inanquin Upa Diosin oin matoqui unimai mato ashosharatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Man Upa Dios cufiaitian nan paramisifoan cufimisifo cuscan huayamacahuun. Nanfoanfin nishon yora ichananfo anoshon yafi ichananti pushu muranshonri ato ointaifi Upa Dios cufipaicani ato nicanonfo. Upa Dios shinancointamarocon nannoafo atohuunoa shinansharamapaicani. Ascaifoan oinquin futsafoan atohuunoa shinansharatirofia Diosincai atohuunoa shinansharatiroma. Ascashocai ato ahuashta inansharashquima. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ascacun marifi ato cuscara iyamacahuun. Man Dios cufiaitian tsoa yamaino Upa cuficahuun. Ascafiacun Upa fustiton mato ointiro. Ascashu matoqui unimacoinquin man yopai cuscan mato inansharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Man cufiaitianri nan tsain fustisi yoiriamacahuun. Nan icoinra huamafoan cashmancoin cufimisifo cuscan. Ascashon yoimisifo. “Un nan tsain nannorisi yoiriaiton ua Upa Diosin nicatiroran,” ishon shinanmisifo. Asca huafiainfoancai Diosin ascaran tsain nicapaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ascacun marifi ato cuscara iyamacahuun. Man Upa Dios yocataima man yopai cuscan man tapiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ascashon cufinquin isca huacahuun, “Nocon Upa nai murannoaton min fasi sharacoin. Nantififain mihuunoa yoisharapainon. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Min apaiyai cuscan min ica nai muranshon samamashta arisca huamisifo. Nanscarifi nuno manifoti anaoafoan huanonfo cuscan nanscacoinrifi nuno mai ano anonfo. Manifotiton aton niaifo iishquin mia ifoannonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Shafatifi nocon tushu non yopai cuscan noco inanhuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nan noco chaca huaifoan non ato rauhua cuscan huafain nocon chacafori noco rauhuashohuun, Upan. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanás yoshin chacapan noco chaca huamapaifiaiton nocoqui cumatima huahuu. Nansca huaquin,” ishon cuficahuun ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ascacun futsafoan mato chaca huafiacun ato rauhuacahuun. Ascacufin maton Upa Diosin nai muranshon man aqui chaca huaa cuscari rau huatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ascafia futsafoan mato chaca huaa cuscan man ato rau huayamaiton manrifi chaca huacun Uparicai mato rauhuashoima. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ascano tsain futsari un mato yoi man tapinon. Man piqui tunuaitian nan paramisifoan amisifo cuscan huayamacahuun. Nanfoan aton fuso chocayamafain puusimisifoma piqui tunucani. Dioshuunoa shinantama atohuunoarocon yorafo shinanmapaicani. Yorafoan atohuunoa shinanqui isca huanonfo, “¡Oincapon! Naton fuso Dios shinanquin piqui tunui puusiquimaran,” ishon. Ascashon atohuunoa shinansharafoanno unimacani. Ascafiafoanno Dioscai atoqui unimaqui ato ahuara inainma. Ascacun marifi ato cuscara iyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ascatamarocon man piqui tunuaitian fuchoquimucain foshti isharashon Dios shinancahuun. Man ascaitocai futsafoan mato oinfiaquin tsoan tapitiroma man piqui tunufiaiton. Ascafia Diosin fustichifin tapitiroquin. Ascashon nan icari man nocoaitian mato ahuara sharashta inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ascan nuno mai ano niyoshon mafo ichapa mucuyamacahuun. Nanfo chacanai futsuaino man funotiro. Yomutsori maton pushu muran iquishon nantifi maton mafo onuntiro. Ascaino marifi man funocoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ascatamarocon Dios fu rafufafaincahuun mato amapaiyai cuscan ashquin. Man asca huaiton Dios nan icanoshon mato ahuara sharacoinfo mucushoni. Nanfocai chacanapacunacama. Tsitsa iquiyamacai yomutsoricai iquitiroma maton onunshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ascan man mafo fusti shinanfafainquifin nan fusti man noicain. Ascan man Diosihuunoa fustisi shinanfafainquin nanrifi man yonoshosharatiro ahuun noicoinquin. Ascashu man afu isharapacusharatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Afanan tsain futsa un mato yoi man tapinon. Nocon furo rafu nocon cayan lamparina cuscara. Nan rafu shara non oinsharatiro. Ascashon nocon caya cushusharatiro non ahuuscanonma. Nanscarifiai mato nomuranshon man shinansharai man isharacointiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ascafia nocon furo chacanocai non oinsharatiroma. Faquishcoin itiro. Nanscarifiai nocon nomuranshon non shinanchacaicain non isharatiroma. Ascacun oinfain. Man Dios shinain isharafiashu chipo Upa Diosin ahuun tsain man cachiquiri huashucai afanan man isharacointiroma. Ascashu nan faquish muran ica shinantsain man funocointiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ascan oinmatinincai ahuun ifo nanno rafu nantian yonoshotiroma. Futsa noifain futsa noicasmatiro iyamarai futsa nan yoia cuscacoin huashotiro. Ascashon futsa, “Nacai ahuamaran,” ishon shinantiro. Tapicai huatiroma ratocaimain nicasharaiquin. Nanscarifiai Dios yonoshopaiquicai man pui noitiroma maton ifo inon. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Afanan un mato yoisharanon. Isca huaqui shinanyamacahuun, “Non ahua pitama nonricai ahua ayaimaran,” ishon shinanchacayamacahuun. Ahuaricai non sahuuimaran iyamacahuun. Non ahuara pifain non sahuuatocai noco imasharatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Shinancapon. Nan puiyafoancai ahua fanayamafain ahua chintumisifoma ahuaricai fotsuyamafain ahuamafofiacun Diosin ato pimamisi. Nanscarifi aquin Diosin matohuun noiquin nan puiyafo aca finonmafain mato cushushara. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ascacun shinanchacayamacahuun. Non shinanchacatocai shafa fusti noco nimayotiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ascashon shinanquiri isca huayamacahuun, “¡Ohuashta! Raniamun un sahuuti fii nan sahuushqui,” ishon shinanyamacahuun. ¡Shinancapon! Charofocai yonoyamafain sahuuti icushumisifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ascatama sharamishticoin foaicafo. Nocon shuni niaifo Salomón sahuuti sharashtacoin sahuufiapaonicai nan charo sharashtacoinfo cuscarama. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosin charo sharashtacoinfo onihua. Foai sharafia supashon samamashta tsasicun coatirofo. Nanfo finonmafain mato noiquin mato camisa sahuumashquin. Ascafia mancai icoinra huasharacoinnama. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ascacun shinanquin isca huayamacahuun, “¡Ohuashta! Unmun ahua piquin uhuun tushuyamaino. ¿Unmun ahua ayaicai? Unricai ahua sahuuimaran,” ishon shinanchacayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ascan nannori nan icoinra huamafoan shinanchacamisifo. Ahuara pifain sahuupaiyaifo fustisi shinanmisifo. Ascan maton Upa Diosifin tapiaquin man yopai cuscan. Ascacun mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ascacun Diosicairocon shinancahuun. Mato yonomapaiyai cuscan nan fusti shinanfafaicahuun. A cuscara shara ipaicahuun. Nancai shinanquin tau huafafaincahuun. Man ascaiton ahuara futsa man yopai cuscan Upa Diosin mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ascacun shinanchacaqui isca huayamacahuun. “¡Ohuashta! Uncai tapiama funamanri ahuara chaca finoainno raca un tunuima,” ishon anori shinantama shinanquirocon isca huafafaincahuun, “Upa Diosin shafatifi ua cushusharamisi cuscan funamanriri ua cushusharairan,” ishon shinanfafaicahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Futsafohuun shinanchacaqui yoiquin isca huayamacahuun. “Nanton chaca huai cuscan onaintimapainonran,” ishon futsafohuunoa yoiyamacahuun. Man ascara yoiaiton Diosin mato onaintimai. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ascacun ahuuscai yora ahuara pasnanshta fuostamua man futsupaiyain marifi sapa uhuapa fuostamufiashocai man muima? Nanscarifiai min chaca huairan futsa huafiaquin mancaifin fasi finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Ascashon man yoiqui isca huai, “Uhuun yorashtan, un min furo murannoa ahuara pasnanshta un mia futsunon,” man huamisi. Ascafiashocai man tapiama man sapa fuostamufafainna. Man fuparamitsapaimisi. Ascacun sapa futsucumucahuun. Asca huashon oinsharafain marifi man futsa pasnanshta futsutiro. Nanscarifi aqui futsafoan ato chaca man shatumapaifiaquin marifi man chaca huaa. Man fasi paran. Ascacun iquisi maton chaca shatucahuun. Ascashon marifi man futsafo chaca shatumatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tsain futsari un mato yoi man tapinon. Pashna pofu iyamarai yahua pofu non tushu inansharatiroma. Non mucuman tushu inansharapaifiaiton nan pitama nocorocon mocotiro. Nanscarifi aquin ratoranfoan man ato tsain shara Dioshuunoa yoipaifiaiton nicacasmacaquin mato chaca huatirofo. Ascacun ascarafo ato yoiyamacahuun. Man yoisharapaifiaiton Diosin tsain potatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Afanan ahuara futsa un mato yoiai cuscan nicacahuun. Ahuara yopaquin Upa Dios yocacahuun mato ashonon. Man yocain cuscan funaquima manasharacahuun nan Diosin mato ashoaitian. Ascacun Upa Diosin cufifafaincahuun man cufiai cuscan mato inanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tsoan Upa Dios yocariai fiishquin. Ascan tsoan ahuara shara fasi fuchipaiyai cuscan Diosin ato fuchimatiro. Ascan tsoan Upa Dios cufiriaiton ashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Ascan maton facun mato yoa yocaiton man toquiri inantiromun? Ma. Mancai maton facu asca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Maton facuri mato shiman yocaiton man rono inantiromun? Ma. Mancai maton facu asca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ascacun tapicahuun. Man chaca huamisifiashon maton facufo man inansharamisi. Man ascaiton maton Upa Diosin nai murannoaton man yocai cuscan finacaia mato inansharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Man futsafo matohuunoa shara huamapaiyai cuscan nanscarifi huaqui futsafori shara huashofafaincahuun. Moisés cununi cuscan yafi Diosin tsain yoimisifoanri nannori cununifo man shara huashofafainon. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ascashon tsain futsari un mato yoinon. Nannofin fai rafuquin. Nan fai tohuaica uhuapaton yorahuanrasi ahuunsi fomisifo. Ascafia nan mau fai tanashu ahuun unutaqui omitsiscapanacafo muran iquishcani. Ascacun mau fai uhuapaton catama fai atsoshta tanacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nan fai tohuaica uhuapama atsoshtacoin. Ascan nanfin fustirasiton fuchitirofo. Nan atsoshta tanafainashu omitsiscatirofofia ahuun unutaqui Dios ari nocoshcani nipasharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Oinfain. Paramisifo matoqui fucashon mato yoiqui isca huacani, “Nonfin Diosin tsain yoimisifoquin,” ishon yoifiacani afoancai Diosin tsain yoimisifoma. Ascan nanfofin nan chashoan cuscarafofiashu ato nomuran nan masharo pofu cuscarafoquin. Ascacun ato nicayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Un mato tapimaquin isca huai. Fanafoti ahuun fimifohuunshon non onantiro ahuu cuscarafomainquin. Ihui moshayafohuuncai uva foaicun non tuscutiroma. Nanhuafaquisihuunricai shopa foaicun non tuscutiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ascafia ihui sharano ahuun fimiri shara itiro. Ihui chacano ahuun fimiri chaca itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nanscarifiai ihui sharacai ahuun fimi chaca itiroma. Ihui chacanocai ahuun fimi shara itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ascacun ihuin ahuun fimi sharamacun ifoan rurashon coatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ascacun fimi chaca iyamarai sharacun onantirofo ahuu cuscaramain ihuiquin. Nanscarifiai nan tapimamisifoan amisifo cuscan man onantiro yora sharafo iyamaraimain chacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ascano atirifiton ua Ifo huafiashucai uhuun Upa Diosin ato amapaiyai cuscan amisifoma. Nan cuscarafo Upa icari nocotirofoma. Nan uhuun Upa nai ari icaton afi ato amapaiyai cuscan huamisifo nanfo fusti uhuun Upa ari nocotirofo afu nipashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ascacun Upa Diosin nantifi icoinra huamafo onaintimaitian nantianri yora ichapaton ua yoiqui isca huashcani, “Ifoshta, shinanhuun. Non min anuhuunshon non yorafo mihuunoa tapimamisi. Min anuhuunshonri yoshin chacafo non futsafomaquinoa potamisi. Min anuhuunshonri tsoan atiroma cuscan non huapaoni. ¿Iconmamun, Ifon?” ishon yoishquicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ascaifoan un ato cayacafi cumaqui isca huashquin, “Mancai uhuun yorafo imisima. Manfin paramisifoquin. Chaca fustisi man huamisi. Ascacun umaquinoashu fotacahuun,” un ato huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ascacun un mato tapimai un mato yoimisi cuscacoin aashucai man funopacunacama. Nanscarafo nan pushu mutsisipa huamua cuscarafo. Pushu huaquin ahuun quishi mai tuiqui nocoa. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ascano fasi oi ichapa fucain faitahuan pushu naman foannaino fuhuanri nocofiaquicai pushu mutsisipa paon huaquima. Nanscarifiai nan uhuun tsain nicacoianfo nan un yoia cuscan acani. Ascashu ahuara ahuuscarafiainocai umaqui itirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Ascafia pushu futsa mai puhuuqui fuquinishta huaa ahuun quishi mai tuiqui nocoama. Ascano fasi oi ichapa fucain faitahuan pushu naman foannaino fuuhuanquiri pushu mutsisipama paon huaqui chacana huatiro. Nanscarifi aqui tsoan uhuun tsain nicafiaquin un ato tapimana cuscacoin aima. Aatocai shinansharama. Ascashu ahuun unutaqui arifi nantifi funoshqui omitsiscairan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jesús tsainqui anaitiano yorahuanrasi anoshon nicacanashu yoinannifo, —¡Aira! ¡Nicacapon! Ahuun tsain sharacoin. ¿Ahuuscashon anori noco yositiromun? Ahuun tsain shara iquina. Nocon tapimamisifoan Moisés cununi cuscan noco yosimisi cuscan aacai anori noco yositamarocon niaifo tapia cuscan noco yosiaran, —ishon yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ascatan Jesús ato yoiquin anaititan machi tunanmanri tusuriqui cainaiton yorafoan mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jesús caino nocofunun ahuun yoratishon ranimamishti rashquishi futsua Jesusqui nocoshon ratoconun mai chachipacufoan yoini isca huaquin, —Ifon, ua caya huapaiquifin mian cayahuatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús aqui mupishon yoini, —Icon un mia caya huai. Ascan natianfin min cayaiquin, —huaino a rashquishi futsua cayariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cayacun Jesús yoini isca huaquin, —Un mia caya huaa cuscan tsoa yoiyamahuu. Nocon caifohuunshon Dios cufimisi ismatahuun. Ascashon Moisés noco yononi cuscan chashoanun facu a inantahuun mia rutushonon. Min chaca soafain min caya cuscan ato ismashquin. Ascano tapitirofo Moisés noco yononi cuscacoin min aiton, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Asca huafaini Capernaum ano cani. Ascaino nanno ranushumua niaifo noconi ahuunshon ahuun oinmati caya huamapai. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aqui nocoshon yoiqui isca huani, —Ifon, uhuun oinmati isininqui. Uhuun pushu ano furoiquima raca. Fasi omitsiscairan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús cumani, —Un canonqui cayahuashquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Ifon, uncai ahuama. Min nocofunu tsoa cuscaramacoin. Uhuun pushu muran capaiyamaquin. Min tsainmansi uhuun oinmati ua cayahuashohuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ascan uarifi uhuun niaifoan ua yonomisi. Ascacun urifi ranushumuafo un yonotiro. Ascan un futsa, “Catahuun,” huaino cariscatiro. Un futsa, “Ohuu,” huaino uqui oriscatiro. Uhuun oinmatiri, “Ua ashohuun,” un huaiton ua ashoriscatiro. Ascan minfin ahuamamishti huatiroquin. Ascacun min tsainmansi yoihuu uhuun oinmati cayanon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ascaiton nicai Jesús afu foaifo yoini, —¡Aira! Nicacapon. Israelimafiashon naton ua yoiai cuscacai tsoa futsan ua icoinra huacoinmisima. Israeli anoafoanricai ua icoinra huacoinmisifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ascacun un mato shafacafi yoi. Mani futsafori anoshon nan Dios icoinra huafoti nocon shunifo Abraham yafi Isaac non Jacobori Dios icano nai murannoashu atofu ichananshcani Diosin yorafo iishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ascafia atirifi nocon caifon Israelifo Diosin ahuun yorafo ato imapaifiacai tsoan icoinra huafoma. Ascacanashucai Dios icano nocotirofoma. Ascacun Diosin ato faquish muran potashquin. Nannoashu uaiqui omitsiscapanacaforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ascashon Jesús Romanon ranushumua niaifo yoini, —Min ua icoinra huaino min oinmati man caya. Ascan natian min pushu ano catahuun, —ishon yoini. Jesús yoiaitian ahuun oinmati cayariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Asca huatan Jesús Pedro pushu ano cani. Nanno caquin oian Pedronun ahuun raisi yoshafo fasi yonacoin oshati camaqui raca ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ascaiton Jesús yoshafoan ahuun mucuqui mupiaino ahuun yona matsiriscatanaino funinaca huan nan isinincama ointsacai Jesús pimashquin tushu huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ascaino man fari caino isinincai futsa futsatapafo yorafo aqui ihuunifo ato cayahuamapacunon. Atirifi yoshin chacafo atohuun nuufafaina Jesús ahuun tsainmansi atomaquinoa potano caya sharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesús nantifi ato caya huani cuscan nannori ahuunoa Diosin tsain yoimisi Isaías inon pacoai cuscan cunuqui isca huani, —Cristofin ahuara isin futsafoan noco isininmai cuscan noco caya huaquin. Nocon isinfori nocomaquinoa potaran, —ishon Isaías cununi cuscan Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ascashon Jesús oian yorahuanrasi aqui fuaifoan afu rafuafo yoini, —Non ian ocuma futsa fonon focahuun, —ato huaino. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nantianri Moisés yononi cuscan tapimamisi aqui cashon yoiquin isca huani, —Tapimamisiton, min raquira caino urifi un mifu cahuacacainon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús cumaquin, —Marifi quiniyaquin. Puiyafori naayafofiano uncai pushu yama, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ascaiton a tanamisi nocofunu futsan Jesús yoiquin isca huani, —Ifon, natian un mifu capaifiai uhuun pushu ano un cayotanon ua nichiyopun. Nan uhuun upa naitian un mai huayotan un mia tanasharashquinon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Ascaquima ua tanahuun. Ua ifoamafofin nan yora naa cuscarafoquin. Ascashon nanfoan ato yora naacun mai huatirofo. Ascan minfin natian ua tanaicain, —ishon Jesús cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Asca huatan Jesús shasho naqui nanuano norifi afu rafuafo non afu nanucaini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ascashu ianmanhuan non pocuaino fuuhuan nocoqui noconi. Nantian Jesús shasho murannoashu osha ini. Ascano ian fuchomanhuanquin shasho muran unu iquimani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ascaiton non moinni. —Moihuu, Ifon, noco numashqui. Man non asai futsuicai, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ascaino moinacahuan noco yoini —¿Ahuuscai man ratuain? Man ua icoinra huasharashucai man ratucuanama, —ishon noco yoini. Ascatan fuuhuan yafi ian fuchomanhuan yoiqui isca huani, —Fuun nishmahuu, —huafain, —Fuchomanhuan nishmahuu —huaino fuu yafi ian fuchoai nishmafaini. Asacatan ianmanhuan pusiquima racani. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ascaiton oin non yoinanni, —Ahuu cuscara nocofunushonmun nocon Ifoan isca huaiquin. Fuuhuan yafi ian nan yoiai cuscan man nishma huaquin, —icashu non yoinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ascatan ianmanhuan pocufaini Gadara mai ano non nocotan Jesús no fu caino nocofunu rafu yoshin chacafo atohuun nuumisi aqui funifo. Nan rafu fasi musucoin ini. Nantifi yorafo atoqui musumisifo. Ascan nan rafu icafoanno cai tsoan ato finontiro imisima. Ascacun atoqui turocomumisifo. Nan mahua quini muran naafo mai huamisifo ano nan rafu inifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesús fuchicatan oi ashcafinin yoinifo, —Minfin Diospan facuquin. ¿Min noco ahuusca huapai oamun? Min noco omitsisca huaitian icataiyamafiano min noco omitsisca huai oamun, —ishon Jesús yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ascaino nantianri ato chaimashon yahua inafoan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ascashon yoshin chacafoan Jesús yoicaquin, —Min na nocofunu rafumaquinoa noco potaimancai yahuarasihuun noco nichipun, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ascaiton —Yahuafohuun fotacahuun, —Jesús ato huaino. Nan nocofunu rafumaquinoashu yoshin chacafo yahuafo muran fonifo. Ascaino yahuahuanrasi ian muran maocofainni asai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ascaifoan oinfaincani yahua cushumisifo ichonifo pushufoti anoafo ato chani huai focani. Ascatan nococashon Jesús nocofunu rafumaquinoa yoshin chacafo potaiton oianfo cuscan futsafo yoifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nicacani nantifi nan pushufoti ano icafo Jesusqui funifo. Ascashon yoinifo, —Nuno noco mai anoashu catapun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ascatan Jesús shasho naqui nanucaini ian mahuan pocufaini ahuun pushurasi ano noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Asca caini pushu muran iquicun rafu non rafuri nocofunufoan aton caifo isinincai afi raqui caiyamacai afiri ahua huatiroma Jesús shinanmaqui shuhua naratashon ihuunifo a cayahuamanon. Ascaiton Jesús oian nan nocofunu isinincaiton ahuun yorafoan fasi icoinra huaifoan oinquin isinincai yoiqui isca huani, —Uhuun yorashta, ratuyamahuu. Natian mun mia chaca soashona, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nicacani Moisés cununi cuscan tapimamisifoan aton nomuranshon shinanquin isca huanifo, —Ajaa. Natocai chaca soatiroma. Fasi Dios chaca huai. Diosin fustitofin chaca soatiroquin. Asca noco paraquin. “Un Diosiran,” noco huamapai, —ishon aton nomuranshon shinanchacanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ascaifoan onanshon Jesús ato yoiquin isca huani, —¿Ahuuscai maton nomuranshon man amaquiri shinanchacaimun? ");
INSERT INTO mcdNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Unfi Cristoquin yorafoan aton chaca un soashotiro. ¿Ascan ahuuscacaimun un huaicai? Un chaca soashoyamaraquin un cayahuai. Ascacun un mato ismai Upa Diosin ua catoan. Ahuunshofin un chaca soafain un yorafo caya huacointiroquin, —ishon ato yoini. Ascatan Jesús nan nocofunu afi raqui cayamacai afiri ahua huatiroma yoini, —Min pushu ano min shuhua ya funicaitahuun, —ishon Jesús yoiaino. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Funinaca huatan ahuun pushu ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ascaiton oincani nantifi mustaiaricatan yoinifo, —Ahuuscashomun Diosin isca huaiquin. Diosin fasi sharacoin tsoa cuscarama. Ahuun yonohuunshon na nocofunu isinincai Jesús ahuun tsainmansi caya huafain ahuun chacari soashonaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nanscacaini caaquin Jesús ua oinni. Unfin noco niaifo pui fishofafainmisi iniquin. Ascan uhuun anufin Mateoquin. A muranshon aton pui fianti pushun facu muran un tsaoa ini. Ascaiton Jesús ua yoini, —Un fu cahuun ua tanamisi iishquin, —Jesús ua catonquin huani. Ua asca huaino un afu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ascashon Jesús uhuun pushu muranshon un pimani. Yorafori no fu cani. Niaifo pui fishomisi futsafo non icoinra huamafo futsafoan atohuunoa shinanchacamisifo yafi non afu rafuafori cani. Ascashon nanfoan no futan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ascaiton oincaquin Fariseofoan Jesús fu rafumisifo yoini, —¿Ahuuscai maton tapimamisi Jesús nan niaifo pui fishomisifo non chaca futsafo futan piimun? —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Ascaifoan nicaquin Jesús ato cumani, —A isinincaifoma cayahuamamitsamisi yopacanima. Ascan nan isinincaifoti fasi cayahuamamitsamisi yopacani. Ascarifi aquin, “Uncai ahua chaca huamisima. Un Numamisi yopaimaran,” icaifocai un aton chaca soashotiroma. Ascan tsoan yoiqui isca huai, “Un fasi chaca huamisi. Un numamisi yopacoinran,” icaifoan un ato chaca soashotiro. Ascacun Diosin tsain cununi cuscan tapitacahuun. Cunuqui isca huani, “Ua man ina fushomisi un mato chaca soashonon. Nan fusticai un fuchipaima. Ascatamarocon man futsafohuun ramapaiyai nancaifin un fasi fuchipaiquin,” ishon Diospan tsain cununi. —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ascashon ato yoiaino Juan fu rafumisifo aqui fucashon yocanifo. —¿Ahuuscai Fariseofo futan non piqui tunumisifiano mifu rafuafoan piqui tunumisimamun? —ishon Jesús yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ato cumani, —Nocofunu fu ainfo fianainnoricai unimai fusicaquin tsoan piqui tunutiroma. Nanno funu anocai ahuun yorafoan piqui tunutirofoma. Ascafia funu amaqui rutuafono shinancaquin piqui tunutirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sahuuti shunicoin fashnucun poto funapan icushumufia ustuashu fasi chacanai finatiro. Tsoancai afanan ascara icushpaitiroma. Nanscarifiai un mato tsain funa shara yosia cuscan nicacoinshocai man apaoni cuscan afanan man huatiroma. Tsoan ua tanacoianshu ipaoni cuscan cachiquiri huacointiro. Ascashu funa cuscara shara iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nanscarifiai tsoancai fichi tutso shuni muran vino funa nanutiroma. Fichi tutso toshacainaino vino funa chacanai cuyofotiro. Nanscarifiai maton shunicaifoan mato yosimisi cuscan yafi un mato yosiai cuscacai nan rafu ositirofoma. Un mato yosiain cuscacoin nannori Diosin tsain shara. Ascafia mato shunifoan mato yosimisifo cuscacai anorima. Nan tanashocai Diosin mato amapaiyai cuscan man huatiroma. Nan rafu osishon nicapaiquicai man shinansharatiroma. Fichi tutso funa muran vino funa nanua sharacoin itiro. Nanscarifiai ratoranfoan apaoni cuscan unucatan un ato tsain funa shara yosiain nan fusti tanasharacun Diosin ato funa shara imai, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ascashu Jesús tsaincai muran Israelifoan ichananti pushu anoa aton niaifo Jesusqui noconi. Nocoshon ratoconun mai chachishon yoiqui isca huani, —Uhuun shotocofacushta man naaquin. Un fu capun. Min mucupan uhuun facu mui caashquin cayatan ninon, —ishon niaifoan Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Asca huaino Jesús niaifo fu caino non acho non afu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nannori ainfon imi imitiani doce fari man aqui cafiano nusu yamacai. Jesús caiton nan ainfoan acachorishori ahuun sahuuti muunni. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mun ataima ahuun nomuran shinanqui isca huani, —Un ahuun sahuuti muuanshu un cayatiroati, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ascashon muuaiton Jesús ifiacucahuatan ainfo fuchishon yoini —Achishtan, ratuyamahuu. Min ua icoinra huashufin min caya sharaquin, —ishon yoiaino ahuun imi nusuriscatani. Ascaiton mua man caya sharacoian ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Asca huatan Jesús niaifoan pushu muran iquicaiquin nica yorafoan aton shainti manuaifoanno futsafo shorarascacani. Fasi achacoin uaicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ascaifoan Jesús ato yoini, —Chifi caintacahuun. Na facucai naama. Oshafinquin, —ato huaiton osanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ato caimatan shotocofacu mutsoinifoannaino samamashta funinaca huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ascano Jesús shotocofacu man naafiacun funia nicacani pushufoti chanifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ascano Jesús niaifo pushu anoashu caiton fusho rafutan mufainifo. —Min nocon niaifo ipaoni nan David ahuun funa. Nocohuun ramapaihuu, —oi ashcafinin cunarianifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Asca huaifono Jesús pushu futsan muran iquicun fusho rafuri afu iquinifo. Iquiafoan Jesús ato yocani, —¿Un mato caya huanon man icoinra huaimun? —huaiton. —Ai, Ifon, non mia icoinra huai, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aton furo munquin yoini, —Ua icoinra huashufin man cayaquin, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Asca huaino oinsharariscatani. Oinsharaifoan Jesús ato yoisharaquin —Ua nicacaquin. Un mato cayahua tsoa yoiyamacahuun, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anori yoifiacun nan rafutan nantifi nanno icafo atoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nan rafu pushu murannoashu foaifono futsafoan nocofunu yoshin chaca ahuun nua ascacai tsaintiroma Jesusqui ihuunifo cayahuamanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús yoshin chaca amaquinoa potano nocofunu tsainon. Nanno icafo mustairitan yoinannifo, —¡Aira! ¡Oincapon! Nocon mai nan Israeli anoshon Jesús rama aca cuscan tsoa oinmisimaran, —icanashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Asca huafiainfoan Fariseofoan yoinifo, —Nanton yoshin chacafo aton niaifohuunshon yoshin chacafo potatiroran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ascaiton Jesús pushurasifoti nanno Judiofo icano cahuacacaini. Judiofoan ichananti pushu muranshonfin Jesús ato Diosin tsain shara yoiquin isca huani, —Itisharacahuun. Diosin nuno maton niaifo ipairan, —ishon ato yoifoanfafaini. Pau futsa futsatapafo caya huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yorahuanrasi aqui fuainfoan oin atohuun ramapaini. Aton nomuran omitsiscaifoan. Ascan Jesús shinanquin isca huani, —Chashohuan cushumisioma nanscarifiai na yorafo cushumisiomaforan, —ishon shinanniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Ascashon non afu rafuafo noco yoini, —Yora ichapafoan uhuunoa nicayamafiano ichapamaton ua yonoshocani uhuunoa ato yoishcaquin nanfu nipashquin. Ascashon fasi Upa Dios cuficahuun ahuun yonoshomisifo catonquin uhuunoa ato yoinonforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ascatan afu rafuafo noco cunani, —Uqui fucahuun, —noco huaino. Aqui fuaifoan noco yononi ahuuscashomain yorafo ahuunshon cayahuamafain yorafohuun yoshin chaca nuucun atomaquinoa potatiroquin. Ascashon pau isi futsa futsatapaforimain ahuuscashon caya huatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Nonfin doce iniquin. Nocon anufo un mato yoi. Futsa Simonfiacun ahuun anu futsa Jesús tuqui huani Pedro. Nanton chipocu Andrés. Futsafoan aton anu Santiago non Juan. Nan rafu Zebedeopan facu. Futsafoan Felipe non Bartolomé un Mateo non Tomás non Santiago Alfeopan facu non Simón futsari nanton ahuun caifo futsafo futan Romanonfo potapai afanan Israelifo yonononfoma. Futsan ahuun anu Judas Santiago facu futsarifi Judas Iscariote nanton Jesús potashon ato achimani. Nocofosi Jesús noco catonni non ahuun rafumisi inon non ahuunshon tsain tapishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Noco catonshon Jesús noco yonoquin isca huani, —Nan noco caifomafoan aton mai ano foyamacain Samaritanon icafo anorifi foyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ari fotamarocon nocon caifo Israelifo muransi fotacahuun. Nanfofin chashoan funoa cuscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ascano focashon ato yoiqui isca huacahuun, “Nocon Ifo Dios samamashta nocoyoshquin noco niaifo iishqui,” ishon ato yoitacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ascashon isinincaifori uhuun curushhuunshon ato cayahuamafain man yora nafiacun funimafain yora nami rashquishi futsuafo ato cayahuamafain yoshin chacafo yorafohuun nuucun nanfori uhuunshon atomaquinoa potacahuun. Diosin mato cashman ahuun curush inan cusca huafain futsaforifi caya huasho ato ahua yocayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ascashon focaquin mato ahua foyamacahuun. Pui foyamafain mato sahuuti yafi sapatori foyamafain forusa yafi poquitiri foyamacahuun. Nan man nuta fustiya fotacahuun. Man uhuunshon uhuun tsain shara ato tapimanaiton arifi man yopai cuscan mato inantirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ascan nan man pushurasi ano nocoaitian nocofunun Dios tanasharacoian funacahuun nan fuchiashu ahuun pushu muran iyoshon ato yoifoanfafaincahuun nan man caitian. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ascatan ahuun pushu muran icaquin nan pushu ano icafo ato yoiquin isca huacahuun, “¡Aicho! Min pushu muran non oiran,” huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ascasho nan pushu ifo futan ahuun yorafoanari mato shara huano ato yoihuu isca huaqui, “Dios mato ointi shinanshara huamashquiran,” ishon. Ascafia mato tanasharayamaifoancai Diosin aton ointi shinanshara huamashquima. Ascano Diosicai mato ointi shinanshara huamaqui unuima. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ascan rato pushu futsa iyamarai pushurasi anoafoanari mato nicacasmaifoan atomaquinoashu focaquin maton sapato tatashacahuun. Ascaquifin man ato ismatiroquin mato nicacasmafain Diosirifi nicacasmaifo cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Un mato icon yoi. Diosin nantifi nan chaca huamisifo ato yoipacuaitian nan Sodoma yafi Gomorra ano ipaonifori ato onaintimashqui. Ascashon nan mato nicacasmafori natian ato onaintimaquin finacoinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Chashoanfo masharonun pipaitiro. Nanscarifiai nan icoinra huamafoan mato chaca huapaitirofo. Ascafia nanfo muran un mato nichi. Ascacun nan rono onanya cuscara marifi icahuun. Ruhuincai ahua shinanchacamisima cuscan marifi nanscarifi isharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ascacun oinfain. Nan yora chacafo masharo pofu cuscarafo mato achimatirofo. Ascano achicashon aton niaifofo ano mato iyotirofo. Asca huashon aton ichananti pushu muranshon mato ihuin futsa coshamatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ascashori niaifofo ano mato iyocani uhuunshon mato nansca huacani. Ascafia nanfo yafi caifo futsafori nan tsain shara uhuunoa man ato yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ascatan mato achifiafo shinanchacayamacahuun ahuuscashomain man ato cumasharaicai. Ascashon niaifofoan ointaifi mato yocaifoanno nantianri Upa Diosin mato shinanmani man ato cumasharanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man ato yoiaitiancai mafi man ato yoima. Maton Upa Diosifin aficoin yoi cafisca huaiquin ahuun Yoshin Sharapan man ato yoipai cuscan mato huashoi. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ascano nantianri nocofunufoan ahuun yora afu nanuafo achimacani niaifofoan ato rutumanon. Apafoanri aton facufo achimacani ato rutunonfo. Nanscarifi huaquin facufoan aton apa yafi ahua nicacasmacaquin ato achimani niaifofoan ato rutunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ascasho nantifi yorafoan man ua icoinra huacun uhuunshon mato noicasmacani. Ascan omitsiscafiaquin man ua potama nan man naitian uhuun tsain tanasharashu Upa Dios fu man ipasharaiqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ascan pushurasi futsa anoshon mato omitsisca huaifoanno pushurasi futsa ano ichotacahuun. Ascacun un mato cayacafi yoi. Ua nicasharacahuun. Israel pushurasifo atirifi ari man cataima un afanan matoqui nasoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Ascano ahuunshon tapiafoancai ato tapimamisi finontiroma. Oinmatifoanricai ato ifo finontirofoma. Ascashu marifi man ua cuscara iishqui. Ua chaca huamisifo cuscan matorifi nansca huashcani. Nanfoan ua noicasmacaquin ua yoimisifo isca huaquin, “Minfin yoshin chacafoan ato niaifoquin,” ishon ua yoimisifo. Un mato ifofiacun ua asca huamisifo. Ascan matocaifin asca huaquin finacaicaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ascacun mato omitsisca huafiaifoanno atoqui ratuyamacahuun. Nanfoan ahuarashta onupaifiamisi nantifi Diosin ato puashoshquin. Ahuarari fomanpaimisifo nanfori ato puashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ahuara un mato fusti yoimisi nanfo nantifi yorafo cayacafi ato yoisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ascasho mato rutupaifiaifoanno ratuyamacahuun. Mato rutufiatirofocai maton yoshin tsoan ahuusca huatiroma. Ascacun atoqui ratucaquimarocon Dios fustiqui musucahuun. Nantofin noco rutufain nocon yoshin omitsiscapanacafo muran potatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ascano tsitsipio rafu inanmitsashon toro fustishtaraca fitiro. Ascafia mato Upa Diosin asca huapaiyamaquicai fustishta namatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Diosin nantifi tapicoian. Nocon foori tanan huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ascashon Upa Diosin tsitsipiofo shinanmisi cuscan fasi mimacai mato shinanfafainiquin. Ascacun ratuyamacahuun. Matocaifin tsitsipio aca finonmafain Diosin matohuun noiquin. Cushushon mima huaquin mato cushusharamisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ascano yorafoan ointaifi, “Jesús uhuun Iforan,” ishon ato yoiafin uhuun Upa Dios nai muran icanoshori ahuun ointaifi, “Naafin uhuun yoraquin,” ishon un yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ascafia tsoan yorafoan ointaifi, “Jesús uhuun Ifomaran,” ishon yoia. Nantocai ua icoinra huamisima. Nanscarifi huaquin uhuun Upa Diosin nai muranshon ahuun ointaifiri “Nacai uhuun yoramaran,” ishon un yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man shinanmun nantifi manifoti anoafo uhuunoashu unimanonfo un oni. Ma. Ascaramafiqui. Un mato yoiai cuscacai tsoan nannorifosi shinancanima. Asca nan ua icoinra huafoan sharafosi shinainfoanno nan ua icoinra huamafoan ahuara chaca futsafosi shinancani. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ascashon apa ua icoinra huaino furumun ua icoinra huashuma apaqui sinatiro. Ahuanri ua icoinra huaino ainfacun ua icoinra huashuma ahuaqui sinatiro. Ahuun yayan ua icoinra huaino ahuun raru ua icoinra huashuma ahuun yayaqui sinatiro. Un nai murannoashu matoqui oyamanicai tsoa ascacuanafoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nanscarifi aquicai tsoan nannorifosi uhuunoa shinancanima. Ascano tsoan ua icoinra huacun ahuun yoracoinfoan nan noicasmatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ascan tsoan ua finonmafain apa yafi ahua noiashucai uhuun yora itiroma. Nanscarifiai tsoan furu yafi ainfacu ua finonmafain noiashucai uhuun yora itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ascan unfin mato ihui coyan iquinanquin nashoshquicain. Ascafia tsoan yoiqui isca huaima, “Natian un Jesús tana. Ascacun nai omitsiscafiaquicai un shinanchacaimaran,” ishon tsoan anori yoicasmaicai uhuun yora itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ascashon tsoan shinanqui isca huai, “Un Jesús tanaiton raca ua omitsisca huacanicati,” ishon shinanqui uhuun tsain cachiquiri huashu nanscara yorafo naashu omitsiscapanacafo. Asca tsoa uhuunoashu omitsiscafiaqui ua potama nanscara yorafori naashu ufu isharapacunacafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ascano ratoranfoan mato nicafain mato shara huaifo. Nanfoanfin nan uacoin shara huai cafisca mato huacaniquin. Nanscarifi aquin tsoan nan un yoiai cuscan nicacoin yafi nan ua nichini uhuun Upa Dios nicacoin cafisca huaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ascashon tsoanri Diosin tsain yoimisi ahuun tsain nicacoinfain shara huacun Diosin nanrifi nan ahuun tsain yoimisi inanshara cuscan huaquin nan shara huari inansharashquin. Ascashon nan Dios tanamisi yora shara futsan ahuun tsain nicasharafain shara huacun, Diosin nan a tanamisi inanshara cuscan huaqui nan shara huarifi inansharashqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ascano tsoan ua rama icoinra huashon ua tanaiton futsan a shara huaqui unu matsi ayamacun. Ascacun Diosin arifi a futsa shara huaa. Ahuara shara inanshquiain cuscacai funotiromaran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ascatan non afu rafumisifo doce noco yoiqui anaititan pushurasi futsafo ano Jesús noco iyoni. Nannoafori ato yosifain ato tapimaicai ahuuscashumain non Dios fu ipatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Ascano nantianri Juanpan nan unu muran ato iquimapacuni ranushumuafoan cunu muran iquimanifo. Nan muranshon Jesús acai cuscan nicaquin ahuunoa fasi tapisharapaiqui. Nan cunu muranshon a tanamisifo nichini Jesús yocanonfo. Ascano nan Juanpan ato yonoa cuscan focashon Jesús yocaquin isca huanifo, —¿Iconmun nan minmun nan non manamisi iyamarai futsa raca non manaicai? —ishon Jesús yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ascaiton Jesús ato cumaquin isca huani, —Nan man nica cuscan yafi man oian cuscari Juan tapimatacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yora fushocoinfo un ato cayahua afanan oinsharanonfo. Nipaiqui ranainfori un ato cayahua nisharanonfo. Ato yoratisho coyo cuscara tocoi futsuafori un ato caya huaa afanan imisi cuscan ato nami shara inonfo. Pastocoinfori un ato cayahua nicasharanonfo. Man yora naacoinnafori un afanan ato funimana. Ascashon ahuuomafori tsain shara un ato yoifafainmisi ahuuscashumain Dios fu ipatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ascan tsoan ua icoinra huacoinshon ahuara futsa shinainma. Nan cuscara yorafofin unimacointiroquin. Nannori ua Juan yoishotacahuun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ascatan man foafono Juanhuunoa Jesús nanno niafo ato yoini, —¿Ahuuscai tsoa istaipama ano Juan oin focani fonifomun? Juancai nan faca tahua pui ninhuun focufocu acai cuscarama. Nanscarifiai man man tapia Juancai nocofunu ointi ranainyama. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ascacun ahuuscai Juan oinpai man fonimun? ¿Man shinanmun a nocofunun sahuuti sharacapa sahuucun oin foi man foni? Ma. Juanpacai sahuuti sharacapacoin sahuumisima. Niaifofoanfin aton pushu muranshon sahuuti sharashtacoin sahuutirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ascan ahuuscai oinpai man fonimun? Man shinanraca Diosin tsain yoimisi Juan oincai man cani. Ascafia nan icon. Juanpan Diosin tsain yoimisifia nanton yoimisi cuscacai tsoa futsafoan anori yoimisima. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ascacun nanhuunoa Diosin tsain cununi isca huaquin, “Min nai ariashu mai ano fotoataima iquisi uhuun tsain yoimisi un nichiqui tau huai. Mihuunoa ato yoiaino itisharashon mia nicanonfo,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Un mato icon yoi. Tsoashtacai Juan finoanma. Ascashon Juanpan tsain yoimisi cuscaricai tsoan ascara yoiyomisima. Ascafia Dios niaifo icanoafoan yoisharatirofo cuscacai Juanpan nicayamafain nanfoan oianfo cuscaricai Juanpan oinyomisima. Ascashon nantifi Dios icanoafoan Juan finoanfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nan Juanpan ato unu muran iquimapacunitian natianri yorafo Dios icano fasi iquipaicoincani. Ascashon shinanqui isca huafo, “Diosin niaifoan ahuun yora urifi un ipai afu nipashquin. Ascacucai ahuashtaton ua nitun huatiroma un ahuun yora icaiton,” ishon shinancani. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Diosin tsain yoishomisifo futan Moisés cununi cuscan yoiquin isca huanifo, “Nan nocon numamisi noco niaifo oshquiran,” ishon yoinifo. Ascan natian Juanrifi man matoqui nocoa ahuunoari mato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nanfoan cununifo cuscan icoinra huashon man tapitiro Juan arifi Diosin tsain yoimisi nan Elías cuscara. Ascacun Diosin tsain yoimisifoan cunuqui isca huanifo, “Un matoqui Elías nichishquiran,” ishon Diosin yoini. Ascan nanfin Juanquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Manmain ua nicatiroquin ua nicacahuun. Uhuun tsain maton nomuran nanushcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ascashon natian niyoafo ahuu cuscarafomainquin un mato yoi man tapinon. Nanfofin nan facu cashumisifo cuscarafoquin. Facufo cashucaquin afu facu futsafo oi ashcafinin cunatirofo. Nanscarifiai nanfofin nanscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nan facu cashumisifoan yoitirofo isca huaquin, “Man non shainti manufiainocai monopaicanima. Fanainca omitsiscati cuscara non fanaifiainocai man uaipaimaran,” ishon nan facu cashumisifoan yoitirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","Nanscarifi aquin nanfoanri Juan yafi uqui tsain chipufafaini. Ascafia Juanpacai piqui tunufain fimi unu pau ayamisima. Ascacun ahuunoa yoiqui man isca huamisi, “Juan nisocoin. Yoshin chaca ahuun nuaran,” ishon yoimisifo. Asca unfin pii sharafain un aya sharamisiquin. Ascafia uhuunoari yoiqui isca huamisifo, “¡Cuu! Jesús pitsicoin fasi ichapari ayatiroran huafain Roma anoa niaifo puifishomisifo yafi yora chacafo furi rafuiran,” ishon uhuunoa chaca yoimisifo. Ascafia nanfoanri yoiqui isca huamisifo, “Tsoamain shinansharafain icaquin non onantiro. Nan yorafin isharacoianquin shinansharamain huaifin,” ishon nannori yoimisifo. Nannori yoifiaquicai uhuunoa ascara yoipaimisifoma. Ascatamarocon uqui tsain chaca fusti huamisiforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Ascano ato yoiqui anaititan Jesús nan pushurasi anoafo ato yoiqui isca huani, —¡Ohua! Man Corazín anoafo yafi Betsaida anoafoan man chipo fasi omitsiscai. Tsoan oinyomisima cuscara shara un mato ismafiano mancai chaca shatupaima. Ascan nan Tiro anoafo yafi Sidón anofori un mato isma cuscan un ato ismaiton nanfoan aton chaca shatucuanafo. Ascasho yoicuanafo isca huaqui “¡Ohua! Non fasi chaca huamisi. Ascacun natian Diosiqui nasoshon non nicasharanoncahuun,” ishon yoicuanafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ascafia Diosin nantifi icoinra huamafo onaintimaitian nan Tiro anoafo yafi Sidón anoafori onaintimafiaquicai mato onaintimaquin finai cuscan ato huaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¿Ascan man Capernaum anoafoan man shinanmun man nai muran Dios ari foicai? Ma. Omitsiscapanacafo muranrocon mato potai. Tsoan oiyomisima cuscara shara un mato ismafiaitocai maton chaca man shatupaima. Ascan nan un mato isma cuscan Sodoma anoafo un ato ismaiton aton chaca shatu cuanifo. Tsoaricai cuyocuanama. Nantianri aton pushurasi icuana. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Un mato yoi. Diosin nantifi icoinra huamafo onaintimaitian nan Sodoma anoafori onaintimaifiaquicai mato onaintimaquin finai cuscan, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ascano ato yoiqui asca huatan Jesús apa cufini, —Upa Diosin, min fasi sharacoin. Nantifi nai murannoafo futan mai anoafoan aton Ifofin minquin. Ascano nan mapo sharayafo yafi cunu tapiafocai min tsain shara min ato tapimanama. Ascafia nan cunu tapiamafiashon un ato isma cuscan un ato yoiai cuscan ua icoinra huafo. Nanfofin min ato tapimanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Icon, Upan, minfin nanscara fuchipaiaqui, —ishon apa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ascashon Jesús afanan ato yoiquin isca huani, —Upa Diosin tapia cuscan uarifi nantifi tapimani. Unfin Diospan facuquin. Diosin fustitofin ua onancoianquin. Nanscarifi aqui urus fusti Upa Diosin un onancoian. Nanscarifi aqui urifi un futsafo Upa Diosihuunoa onanmanai cuscan nanfoanri Upa Diosin onantirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","29","Ascacun uqui fucahuun ua tapishashcaquin. Unmain ahuu cuscaraquin un mato tapimai. Unfin yorafohuun ramapaimisiquin. Uhuun nomuranricai un ahuashta shinanchacayamafain un isharacoin fustimisi. Ascashon un mato yonomapaiyai cuscacai curushma. Nanricai ahua ihuuma. Ascacun maton nomuran ihuucoin mui uqui fucahuun un maton ointi fiananan huashonon man afanan shinanchacanonma. ");
INSERT INTO mcdNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ascano uqui oshon man mutiro un mato curush yonomaima. Ascatamarocon ua tanasharacoinyashu mato ointi fiananan huashon man isharacointiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ascatan Israelifoan aton tunutitian Jesús yafi afu rafumisifo mau mamaqui focaquin trigo mutuscashon fonaincoincaquin piyaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Oincaquin Fariseofoan Jesús yoinifo, —¿Ahuuscai nocon shuni Moisés yononi cuscacai minhuunshon tapimisifoan nicapaicanimamun? Tunutitian trigo mutuscaniran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús ato cumaquin isca huani, —¿Davidhuunoa cununi cuscan man man oinmisimun? ¿Fonainquin nocon shuni David ahuun yorafo futan ani cuscan man man nicamisimun? ");
INSERT INTO mcdNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dios fu tsainti pushu muran iquicaishon amurannoa misifo ato piquini fasi fonicoinquin. Ano tushu futsa yamaino. A misifofin nan Diosin tsain yoimisinafosi iniquin. Tsoa futsacai a misi pitiro inima. Nannori yonofianifo fasi fonicoinquin David afu rafuafo futan pini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ascashon Moisés cununi cuscari man man oinmisimun? Cunuqui isca huani, “Dios fu tsainti pushu muranshon tunutitian ahuun tsain yoimisifoan yonotirofo. Nanfoan yonofiaquicai ahua chaca huacanimaran,” ishon Moisés cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ascatan un mato yoi. Dios fu tsainti pushu fasi sharashtafia uncaifin fasi shara finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Upa Diosin yoini cuscan cununi isca huaquin, “Man ua inafo rutushomisi un maton chaca soashonon. Nan sharafia man futsafohuun ramapaiquin man ato shara huai. Nancaifin fasi shara finacaiaquin. Nan fusti un fasi fuchipairan,” ishon yoini. Ascacun nan tapicoinshocai man ufu rafumisifohuunoa yoicuanama, “Nanfoan chaca huaforan,” ishon. Afoantsi ahua chaca huacun. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Uafin uhuun Upa Diosin catonniquin. Ascacufin urusu fusti un yoitiro ahuamain tunutitian man huatiroquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Ascatan Jesús Israelifoan aton ichananti pushu muran iquini. Nanno iquishon ato yosiaino nantianri nocofunu musufiquiaton arifi nicani. Ascano nan Fariseofoan Jesushuunoa ahuara chaca yoipaicaquin nan yocanifo. —¿Nocon shuni Moisés yononi cuscamun tunutitian non yora caya huatiro iyamarai non caya huamatiromanmun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús ato cumani, —¿Man chashoan ayano tunutitian quini muran pacucun man ihuiriscatiromamun? Ma. Ascatama manrocon ihuiriscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nanscarifi huaquin fasi noicoinquin nocofunuhuunoa tunutitianfiacun non shinantiro. Moiséscai noco yononima tunutitian non yora cayahuanonma, —ishon ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ascashon nan nocofunu musufiquia yoiqui isca huani, —Mushahuun, —huaino. Mushatanaino nantian ahuun mucu muma sharacoin iriscatani. Nan ahuun mucu ocuma futsa cuscara shara ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ascaiton oincanashu Fariseofo focashon shinannifo —¿Ahuuscashomun non Jesús achitiroquin rutushquin? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús tapitan a rutupaiyaifoanno anoashu cani. Yorahuanrasiton mufainifo. Ratomain isinincai nanfo cayahuamani. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ato cayahuatan ato yoini, —Uhuunoa tsoa yoiyamahuu, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nannori ato yoi Isaías cununi cuscan icocoin inon. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Isaiasin Diosin tsain cununi isca huaquin, “¡Oincapon! Naquian uhuun oinmati cuscara un catonni. Un fasi ahuun noi. Un aqui unimacoin. Uhuun Yoshin Shara un afu rafumamisi. Nan manifoti uhuun tsain nicasharacun atorifi aton chaca yama huashotiro uhuun yora inonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Acai yora futsa fu fochishmanantanainma. Tsain isininpaton yoishquima. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nan yora omitsiscai afanan tunutirofoma ato potaima ato cushusharai tunumashquin. Tsoan icoinra huapai ato yoisharashquin icoinra huacoinonfo. Ascan huaino afanan mai ano oaitian nantifi chacafoti unumashquin ahuunshon nantifi ishara fustisinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nantifi manifoti ahuunoa nicaquin isca huacani shinanshcaquin, ‘Nan fustiton noco numatiro non ahuunoashu Upa Dios fu nipanon,’ ishon yoishquicaniran,” Isaías cununiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ascatan nocofunu fusho icain tsaintiroma. Ahuun nuushon yoshin chacanun tsainmapaonima nan Jesusqui ihuunifo caya huanon. Ascacun Jesús nan nocofunu afanan oinmasharafain tsainmani. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ascaiton oincani mustaiaricatan afiranan yoinancaquin yoinifo, —Jesús ahuamamishti shara huatiro. Asca nan naraca David ahuun funa. Nan Upa Diosin catonni, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ascaifoan nicaquin Fariseofoan yoinifo, —Ma. Atocai Upa Dioshuunshon yoshin chaca potama. Yoshin chacafoan aton niaifo Satanashuunshon yoshin chaca yorafohuunoa potatiroran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ascano nan shinainfo cuscan onanshon Jesús ato yoini, —Mani futsafo afi ranan rutunain cuyotirofo. Nanscarifiai pushurasi anoa icafo iyamarai pushu fusti muran icafo afi ranan chaca huatananfafaincani pashcanantirofo afanancai tsoa anosi itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nanscarifiai Satanás niaifoan afu yoshin chacafo potaquin ahuun yono chacana huatiro. Asca huaquin ahuun yono cuyocointiro afu yoshinfocai afanan afu itirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ascafia manfin yoimisiqui Satanás curushhuunshon yoshin chaca potaran ishon man yoimisiquin. ¿Un asca huaino tsohuunshon mato yorafoan yoshin chacafo atomaquinoari potafomun? Ascacun nanfohuunshon man tapitiro man uhuunoa amaquiri shinanchacai cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Un Diospan Yoshin Sharahuunshon yoshin chacafo atomaquinoa potaino maton Numamisi Diosin catonni cuscan matoqui nocoa. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Afanan mato yoi nicasharacahuun. Ahuuscashomain yorafoan nocofunu mutsisipaton ahuun pushu cushu ano ahuun mafo onutiroma. Ascafiaino finoncaia aqui nocoshon achifain munushquin ahuun mafofo cuyonfiaitocai ahuusca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tsoan unfu rafupaiquima ua nicacasmai. Tsoan uhuun tsain nicacasmaifin ua noicasmaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ascano un mato icon yoiquin. Ratoran ahuara chaca huai Diosquiri Upa Diosin rau huashotiro. Ascanfia ratoranton yoia isca huaquin, “Nanton aca cuscan Satanashuunshon acaran,” huafiashu Diospan Yoshin Sharahuunshon aca. Nanton Diospan Yoshin Sharahuunoa tsain chaca huaa. Asca huacun Upa Diosin ahuun chaca rau huanacama. Ahuun chaca ahuun nuupacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tsoan ua chaca huafin un ahuun chaca rau huashotiroquin. Ascan tsoan Upa Diospan Yoshin Sharaqui tsain chaca huacai Upa Diosin rauhuanacama. Ahuun chaca ahuun nuupacunaca. Natian naitianri ahuun chaca ahuun nuupacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ascano shinancapon. Fimi fana naman non orosharaino fana foaisharatiro. Ascashu ahuun fimirifi sharacoin itiro. Ascan non fana naman oroamacai fana foaisharatiroma. Ascashu ahuun fimiri chacacoin itiro. Fimi fana ahuun fimihuunshon non onantiro ahuu cuscaramainquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Nanscarifiai nocofunu sharapan ahuun nomuranshon ahuara sharafosi shinain cuscan ahuun tsainrifi sharacoin itiro. Nanscarifiai nocofunu chacapan ahuun nomuranshon ahuara chacafosi shinain cuscan ahuun tsainri chacacoin itiro. Ascano nocon ointi muranshon non shinain cuscan nannoricoin non yoitiro. Ascan manfin nan rono paupaton facu cuscarafoquin. Ascacun ahuuscashotsi chacacoinfiashon man ahuara shara yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ascacun un mato yoi. Ratoran shafatan Diosin nantifi yorafo ichanan huaitian ato yoipacushqui ratotonmain icoinra huamisi iyamarai icoinra huamisimaquin. Nantianri ahuashta shinantama yoimisifo cuscan ato puashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ascashon man niyoano nantifi man yoimisi cuscan Upa Diosin mato nicamashquin. Ascan mato tsainhuunshon man afu ipatiro iyamarai mato omitsiscapanacafo muran mato potairan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ascaiton Fariseofo futan Moisés cununi cuscan tapimamisifoan yoinifo, —Tapimamisiton, tsoan atiroma cuscan noco ismahuu min Dios ariashu oa non mia icoinra huanon, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús ato cumani, —Manfin chaca shinanfain Dios cachiquiri huamisiquin. Ascacun tsoan atiroma cuscan noco ismahuu ishon man ua yoia. Ascafia nan Diosin tsain yoimisi mato shuni Jonás ani cuscacoin un chipo mato ismaiton nan fusti man oinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás shimanoan shaqui muran osha rafu non fusti iyoni cuscan. Nanscarifiai un Diospan Facu mai muran osha rafu non fusti un iyoshqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ratoran shafatan Diosin nantifi yorafo ichanan huaitian ato yoipacushquin ratotonmain icoinra huamisi iyamarai icoinra huamisimaquin. Ascaino nantianri Nínive ano ipaonifoan matohuunoa yoishcani isca huacaquin, “Jonás noco Diosin tsain yoini cuscan non nicacoinshon nocon chaca shatucoinshon non Dios icoinra huani. Asca man manfin Diospan furucoin nicafiashocai maton chaca man shatumisimaran,” ishon mato yoishquin. Nan icon un Jonás finonfiacucai man ua nicapaimisima. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nanscarifiai Diosin nantifi yorafo ichanan huaitian ato yoipacushquin ratofomain afu ipatiro iyamarai omitsiscapanacafo muran foshquicaniqui. Ascaino nantianri nan ainfo Sabafoan ato niaifo ipaoniton matohuunoa yoiquin isca huashquin, “Salomón tapicoian cuscacai tsoan futsan tapipaonima. Ascacun ahuun tsain nicapaicoin un aqui chaicunoashu cani. Ascan mancai nan Diospan Furun nicapaima. Ascatamarocon man nicacasmapaoniran,” ishon matohuunoa yoishquin. Nan icon Salomón tapicoian ipaonifia uncaifin fasi Salomón finoncoinfiacun mancai ua nicapaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Yoshin chaca nocofunumaquinoashu cai tsoan istaipama ano cani shara futsa funai cai anoshon tunushquin. Ascafia fuchiamacaiqui yoshin chacanun afanan shinanqui isca huani, “Unfin nan nocofunuhuun ipaoniquin. Ascacun un afanan aqui nasoiran,” ishon shinanni. Ascatan aqui nocoshon oian tsoa futsacai afu rafua inima. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ascacun nan yoshin chacanun afu yoshin chacafo siete ato ihuuni nan fasi chaca finacaiafo. Ascashon ato yoiqui isca huani, “Nocofunu un mato ismai non ahuun nomuran iquitiroran,” ishon ato yoini. Ascatan aqui focanashu iquicainaifoanno nan nocofunu fasi mimacai chacacoin ini. Manmain aqui rananri focun. Nanscarifiai maton shunifoan chaca huafiapaonifo mancaifin fasi chaca huaquin finacoianquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ascatan Jesús yorahuanrasi yoi tsaincai muran ahua yafi chipocufo noconi. Ascano aqui iquishon ahuara yoipaifiacaquin chifishon mananifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ascaiton futsan yoini, —Min uhua futan ushto rananun chifi nishon mia ahuara yoipai fuaforan, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús cumani, —Un mato tapimai ratofomain uhuun uhuafo yafi uhuun ushtofoquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A tanamisifo oinyacuquin ato yoini, —Nafofin uhuun uhua cuscarafo yafi uhuun ushto cuscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nan uhuun Upa Dios nai ari icaton ato amapaiyai cuscan huaifo nanfofin uhuun ushtofo yafi uhuun chicofo non uhuun uhuafoquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ascatan nan shafatari Jesús pushu murannoashu cai ian cusumun tsaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ascaino aqui yorahuanrasi funifo ahuun tsain nicapai cani. Ascaino shasho muran nanuinacahuan ahuun cusha camaqui tsaoshon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ascashon ahuara futsahuunoa cuscara ato yoini ato tapimashquin. Yoini isca huani, —Nocofunun ahuun noshati murannoa fimi ushu fishon ahuun mau mamaqui saani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Saacano ushufo fai nushmancayan pacua puiyafoan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ascano ushu ranan toquiri camaqui pacua mai ichapamashta anoashu samamashta ushu foaica. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Fari tsacaqui yositimahuaino man naa. Ahuun taporicai chai foama ini. Ascashu fanafo nai cuyoa. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ascaino ushu rananri tasha murannoashu foaifiashucai ushu futsa foaisharanima. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ushu rananri mai shara ano saaca nan mai sharanoashu nantifi foaisharashu fimi ichapayacoin ini. Futsa cien fimiya icaino futsa sesenta aya icaino futsari treinta fimiya ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ascan manmain ua nicatiroquin ua nicacahuun uhuun tsainri maton nomuran nanucoincahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ascaino non afu rafua aqui fucashon yocanon, —¿Ahuuscai shafacafi ato yoitama ahuahuunoa cuscara min yorafo ato tapimashquinmun? —ishon non yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús ato cumani, —Ahuuscashomain Upa Diosin ahuun yorafo iquiniquin mato fusti tapimai. Ascan nafocai ato tapimaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ascan tsoan Diosin tsain nicasharafain ahuun nomuran nanucoian naanfin Upa Diosin paratamari tapimashquin. Ascafia tsoan ichapama tapifiashon Diosin nicasharayamafain nan yoia cuscan aima nanfin funoshquiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ascacun nan yorafo un ahuara futsahuunoa cuscara un ato tapimashquin oinfiacashon tapinonfoma. Nicafiaquiri tapinonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nannori Isaías nan Diosin tsain yoimisi ipaoniton atohuunoa inon pacoai yoiqui isca huani, “Man nicafafaifiaquicai Diosin ato yoiai cuscan tapinacafoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nan yorafoan aton ointi curushcoinyashu nicayosmashunifo. Diosin tsain man nicamisifiashu nan nicama cuscarafo. Uhuun yonoshara oinfiacani nan futsoi cafiscaafo. Ascashon un ato isma cuscan oianfoma. Ascayamacanashu uqui fucuanafo un ato chaca soashonon uhuun yora sharafo iishcaqui,” ishon Diosin yoini cuscan Isaiasin cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ascafia nannori Isaías cunufiani mancai ascarama. Ascatamarocon un mato oinmana cuscan man icoinra huafain un mato yoia cuscan man nicacoinmisi. Ascashu maton nomuran man unimacoinna. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Un mato icon yoi. Man oian cuscacai uhuun Upa Diosin ahuun tsain yoimisifo futan a tanamisi futsafoanri fasi oinpaifiaquicai tsoan oinpaonima. Un mato yoimisi cuscan fasi nicapaifiacaquin tsoan nicapaonima. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nan fimi ushu saamisihuunoa un ato yoia cuscan natian shafacafi un mato tapimai. Ascacun ua nicasharacahuun tapisharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ascan nan Dios ahuun yorafo iquinai cuscan nicafiashon tapiama. Nanfofin nan ushufo fai ano pacua cuscarafoquin. Diosin tsain ato nomuran man nanufiafo nan yoshin chaca Satanás atoqui oshon nicafo cuscan ato fiantiro afanan afohuunoa shinanonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ascano futsafoanri Diosin tsain nicaquin tau huai unimacoinyofiashu samamashta ahuun tsain cachiquiri huaa. Ascan nanfofin nan ushufo toquiri camaqui pacua cuscarafoquin. Nanfori nan ushufo toquiri camaquinoashu foaifia ahuun tapo chai foama. Samamashta nai cuyotiro. Nanscarifiai nanfoancai Diospan tsain aton nomuran nanu sharafoma. Ascashon ahuara chaca finonyamarai futsafoan ato omitsisca huaino samamashta Dios cachiquiri huatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ascan ushu futsafo moshafo muran pacuashu foaisharatiroma. Nanscarifiai futsafoan Diospan tsain nicafiashon ahuara nan acai cuscan fustisi shinain. Ascashon pui ichapa yafi mafo ichapa noi afi paramuquicai afanan Dioshuunoa shinantiroma. Ascaquicai Diosin ato amapaiyai cuscan futsafo shara huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ascafiaquin ushu futsa mai shara ano saacano foaiquin yosiashu fimi ya itiro. Nanscarifiai futsafo Diospan tsain nicafain tapicanashu nan yoia cuscan aafo. Ascashon nanfoanfin futsafori Diospan tsain yoiquin icoinra huamatirofoquin. Futsan treinta iyamarai sesenta iyamarai cien yorafo icoinra huamatiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Afanan Jesús ato tsain futsa yoini tapinonfo. Isca huaqui, —Diosin nantifi iquinano nanscarifi aquin nocofunun ushu sharafo fana. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fana sharafiashu ahuun noicasmamisiton yamu ahuun mau ano caa. Mau ifo ahuun oinmatifo oshano noicasmamisiton tashafori mau ano fana. Fanatan mau anoashu caa. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chipofin nan ushu shara foaicaino tashafori foaini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ascano aqui fucashon mau ifo ahuun oinmatifoan yoinifo, “¿Ifon, min ushu shara min mau ano fanamamun? ¿Ahuuscaimun natian tashafori foaicaquin?” ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Noco noicasmamisiton acaran,” huaiton. “¿Ascan nan tashafo non tsucai fotiromun?” huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ma. Man tasha tsucaino nan fana sharafori tsucapaiyamafiaquin man afori tsucatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nanscanonquin. Chitunmisitian tashafo yafi fana sharafori foaitiro. Nantian un mau yonomisifo yoishquin isca huaquin, ‘Iquisi nan tashafo tsucacahuun. Nantifi nushasharahuu coashquinon. Asca huatanfin nan fanasharafori uhuun tapasi muran ua fushotacahuun,’ ” mau ifoan yoiaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ascasho Jesús mostaza ushuhuunoa ato yoini ahuara futsa ato tapimashquin. Ato yoiqui isca huani, —Nocofunun ahuun mau ano mostaza ushu fanani. Rato fimi ushu futsacai mostaza ahuun ushu uhuapamashtatioma. Ascafia foaica fasi cuya itiro. Rato pushu umainti fimi charo fanacai mostazatioma. Ihui noconan rafutiro. Ascatan yosiano puiyafo ahuun tushpahuu tsaotiro. Nanscarifiai Diosin ahuun yorafo iquisi fustirasi ifiashu chipo paratama caitioran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ascan Jesús ahuara futsa ato yoini Diosin nantifi yora iquinai cuscan tapinonfo. Afanan ato yoiqui isca huani, —Diosinmain ahuun yorafo ahuusca huatiroquin un mato tapimai. Diosin ahuun yorafo nantifi ato iquifain ato yonotiro. Ainfoan farashati ichapamashta harinaya osishon camisconano farashinitiro. Nanscarifiai Diospan yorafoan nan icoinra huamafo muranshon nantifi ato shara huatiro, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ascatan ahuarahuunoa yoiqui Jesús ato yoini tapinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nannori Diosin tsain yoimisiton nan Jesús yoinon pacoai cuscan cunuqui isca huani, “Un ato ahuara futsahuunoa ato yoi ato tapimashquin. Upa Diosin nantifi onihuani chain tsoan ascara nicayomisima cuscarafo un ato yoishquiran,” ishon yoini cuscacoin man aa. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ascatan yorahuanrasi anoashu cai pushu muran iquini. Ascano non afu rafuafo aqui caashon non yocani, —Ifon, min trigo muran faasi foaitirohuunoa yoia cuscacai non tapiama. Shafacafi noco yoihuu non tapisharanon, —ishon non yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ascaiton noco cumani, —Diosifi ua nichiniquin. Un nan ushu fanamisi shara cuscara inon. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nan maufin nantifi manifotihuunoaqui. Ascan nan ushu sharafofin Diospan yorafohuunoaquin. Ascan faasifin icoinra huamafona nan yoshin chaca ahuun yorafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ascan nan mau ifo noicasmamisi nanfin Satanasquin. Ascan nan fana fiaifotianhuunoafi nan manifoti cuyotirohuunoaquin. Nan fana fimisfofin Diospan oinmatifo afu nai muran icafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nan faasi mushashon coafo cuscan huaquin. Nan manifoti cuyoaitian. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Uhuun oinmatifo ufu nai muran icafo un nichishquin nantifi futsa chaca huamamisifo yafi nan chaca huafafainaifo uhuun yorafomaqui ato pashcashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ascashon nan omitsiscapanacafo chi urumanhuan muran ato potano nannoashu fasi uaicani omitsiscacoinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ascaino nantianri Diospan yora shara icoinra huafoti aton Upa Dios icanoashu fari chasha cuscarafo. Ascacun manmain ua nicatiroquin ua nicacahuun. Uhuun tsain maton nomuran nanucoincahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nocofunu mai futsa ano caa. Nannoa ahuara sharashta paratama ahuun pui nuua fuchia. Ascan fuchishon nannori afanan onua. Ascashu fasi unimacoinquin nan aya cuscati inanmitsashon nannoa mai fia nan ahuarashta paratama ahuun pui nuuari ahuuna inon. Nanscarifiai Diospan yorafo nantifi aya cuscan afiri inanmutiro Dios fu ipashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Diosin ahuun yorafo ahuu cuscaramainquin afanan un mato yoiqui isca huai. Mafo inanmitsamisi cahuancacaini macush cuscara perla oshopa sharashtafo funafoanfafainni. Ascashon man futsa anoa fuchia ahuun pui paratama nuua fuchishon nan aya cuscati inanmitsashon ahuun rafanan nan perla fii ahuunacoin inon. Nanscarifiai Diospan yorafo nantifi aya cuscan afiri inanmutiro Dios fu ipashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Ascano nushumisiton ahuun nushuti uhuapa pochishon shiman futsa futsatapafo fiini. Ahuun nushutininhuan shiman fospiano unuhuan cusumun cashon nini funi. Ascashon nan shiman chacafo nushuti murannoa tsucashon potani. Ascanshon nan piti sharafosi shihuati muran nanuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nanscarifiai manifoti cuyoaitian Diospan oinmatifo afu nai muran icafo nococashon nan chacafo yafi sharafo pashcanan huashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ascashon nan chacafoti chi urumanhuan muran ato potashquin nannoashu uaiqui fasi omitsiscapashanonfo, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ascatan afu rafuafonon Jesús noco yocaiton, —¿Un mato yoia cuscan nantifi man man tapiamun? —ishon noco yocaiton. —Ai. Min noco yoiai cuscan nantifi man non tapiaran, —non huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—Ratoran futsafoan Moisés yononi cuscan tapimamisifo nan Diosin ahuun yorafo iquinai cuscan tapiafo. Ascan nanfofin nan mafo inanmitsamisi cuscarafoquin. Mafo inanmitsamisiton yorafo nan yopaifo cuscan inantiro. Ahuara shunifo iyamarai funa ato inantiro. Nanscarifiai tsoan Moisés cununi cuscan yafi un mato rama Diospan yorafohuunoa tapimanai cuscan huafain marifi man futsafo tapimatiroran, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Ascano noco yoia cuscan ahuara futsa tapinonfo anaititan Jesús nan pushconi pushurasi ano nasoni. Ascatan Israelifoan aton ichananti pushu muran iquishon ato yoiaiton ahuun tsain nicacani mustairicatan yoinifo, —¿Ahuuscai na nocofunun fasi tapi sharacoianmun? Tsoan atiroma cuscan huapaiquifin atiroquin. ¿Tsoanco Jesús ascara tapimanamun? ");
INSERT INTO mcdNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nanfin ihui sapa yonomisiton ahuun facuquin. Ahuun ahuan Maria. Ahuun ushtofori Santiago yafi José non Simón non Judas. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ahuun poifori no fu imisifo. Man nonfin Jesús onanquin. Aacai ahuama. ¿Ascan ahuuscashomun ahuamamishti huatiroquin? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ascashon nannori ahuunoa shinanchacaquicai tsoan icoinra huapainima. Ascaiton Jesús ato yoiqui isca huani, —Nantifi mai anoshon Diosin tsain yoimisiton yoiai cuscan nicapaitirofo. Ascafia nan cainni anoshon fusticai tsoan nicapaitiromaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ascano nannoshon icoinra huaiyamaifoan tsoan atiroma cuscan fustirasi huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Ascano nantian Herodes nan Galilea mai anoa ato niaifoan Jesushuunoa nicaquin ahuun oinmatifo yoini isca huaquin, —Nanfin Juanqui. Un tushtumayamua afanan man funia. Ascashofin Diospan curushuunshon tsoan atiroma cuscan huafafainiquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodes Juan rutumanataima yoiqui isca huani, —Niaifo Herodes, min ushto Felipe ahuun ahuin min fia. Ascaquicai min shara huama. Nocon shuni Moisés Diosin tsain cunuqui isca huani, “Futsan ahuin min fitiromaran,” ishon Moisés cununiran, —ishon Juanpan Herodes yoini. Ascaiton nicai Herodes fasi sinacoinquin ahuun ranushumuafo yononi Juan achishon cunu muran iquimanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ascashon Herodes Juan ruturiscapaifiaquicai funa rutunima yorafoanmain Juan fuchipaiyaifoanfin. Ascashon nanfoanri yoinifo, —Juanfin Diospan tsain yoimisiquin, —ishon ahuunoa yoinifo. Ascacun Herodes shinanquin isca huani, —Un Juan rutucun ua yorafoan asca huatiroran, —ishon shinanni. Yorafoqui ratuquin Herodes Juan cunu muran iquimafiashocai funa rutunima. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Ascano Herodes cainnitian yorafo ichananni fuusishcaquin. Ascashu ichananfoanno Herodías ahuun facu shomaya arusu aton ointaifi mononi. Nan Herodías Herodes ahuun ushto ahuin ini. Ascashu shomaya monoaino Herodes fasi unimacoinquin yoini, —¡Aicho! Min monoai cuscan un fasi miqui unimai. Ahuarashta fipaiquin ua yoihuu un mia inanon. Diosin tapia un mia icon yoiaiton min fipaiyai cuscan un mia inantiroran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ascashon cashon shomayaton ahua yoini. Ascacun nan ahuan yoia cuscan nasocura niaifo Herodes yoini, —Juan nan yorafo unu muran iquimapacumisi tushtuhuu. Purato naratashon ahuun mapo ua inanhuun, —huaino. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Niaifon Herodes puusinima. Puusitama ahuun nomuran shinanqui isca huani, —¡Ohua! Un Juan tushtumapaima. Ascafia yorafoan un shomaya yoia cuscan man nicafo. Ascacun un asca huapaiyamafiaqui un aquicairan, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ascashon niaifoan ahuun ranushumua yononi, —Juan tushtushon ahuun mapo ua fushotahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ascaino cashon ranushumuaton Juan tushtushon ahuun mapo purato naratashon funi. Fushon niaifo inancun nan niaifoanri shomaya inanni. Ascano shomayaton arifi ahua inanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ascashon afu rafumisifoan Juan nicacani focashon ahuun caya mai huanifo. Ascatan focanashu Jesusqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ascashon Herodes Juan tushtuma nicai Jesús shashon tsoa icama ano cani. Jesús caa nicacani pushufoti anoashu yorahuanrasiton naman mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ascashu nocoquin Jesús oian yorahuanrasi oin atohuun ramapaini. Nannoshori isinincai futsafo ato cayahuapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ascano man fari caino non afu rafuafo aqui cashon non yoini, —Yorafo nichihuun. Man fari caiquin. Fonaincaniquin. Pushurasi ano yafi a chaima icafoanno ato nichihuun anoshon tushu huanonfo, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ascaiton noco cumani, —Ma. Noncai ato nichima. Mafirocon ato piimacahuun, —noco huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Nonfin nuno misi siete yafi shiman rafu ayaquin, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ascaiton, —Ua fishotacahuun, —noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ascashon yorahuanrasi yoini, —Nanno faasi camaqui tsaocahuun, —ato huani. Ascatan shiman rafu yafi misi mucu fustiti tsomashon nai ari foisinifoantan Apa Dios cufinquin, —¡Aicho! Upan, mihuunshon un ato pimai. Min fasi sharacoincun, —huatan. Misi torupacutan shiman rafu ya osishon noco inanni non ato pashcanan huapanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ascashon picani mayancoinnifo. A picaquin tushu huafo non afu rafumisifoan doce shihuati fospi huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nan piaifo cinco mil nocofunufoosi ini. Ainfofo yafi facufocai non tanan huanima. Asca nanfoanri ato futan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ascashon ato pimaquin anaititan Jesús noco yoiquin isca huani, —Shashon rufofo oquiri pocui focahuun. Un na yorafo ato nichiyonon, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ascashon man ato nichiqui anaititan arus fusti machi ano caashon Apa Dios fu tsainni. Man fari caino arus fusti ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ascatan afu rafuafo shasho caino ian nushmancayan nocoqui fuuhuan noconi. Ascashu ian fuchoquin noco catima huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ascashu man faquishiaino non oian Jesús ian fumancayan nocoqui ofiaitocai non onannima. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Onanshma ratucoin non fiisini. “Yoshiran,” icashu non fiisicaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—Unqui. Ratuyamacahuun, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ascaiton Pedronun yoini, —Ifon, minmainquin uarifi mia ano cunahuu. Urifi un ian fumancayan canon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","—Ohuu, —Jesús huaino Pedro shasho naquinoashu fotopacucahuan ian fumancayan Jesús ari caafiain oian fuunhuaquin ian fuchoaiton oin ratui iquipacucahuanqui yoini, —Ifon, ua ari mutsoinifoanhuun, —Pedronun huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ascaiton Jesús samamashta mutsoinifoanquin yoini, —Miancai ua icoinra huacoinnama. Ahuuscaquimun mian icoinra huamaquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ascantan nan rafu shasho muran nanuinifoanafono fuu nishmapacufoanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ascano non shasho murannoafo fasi aqui unimacoinquin non yoini, —Iconfinquin min Diospan Facu, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ascatan ian pocufaini Genesaret ano non noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ascashu non nocoaiton nannoafoan samamashta Jesús onancashon a chaima icafori ato tapimanaino nicafuracani fucaquin aton yora isinincaifo Jesusqui ihuunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ascano fucashon Jesús yoinifo, —Noco yora isinincaifo min sahuuti cupanan fusti ato muumahuu cayanonfo, —ishon yoinifo. Ascatan ahuu sahuuti muuncanashu cayapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ascano Fariseofo yafi Moisés cununi cuscan tapimamisifori Jerusalén anoashu Jesusqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Fucashon yoinifo, —¿Ahuuscaimun nocon shunifoan piataifoma muchoquimupaonifo cuscacai mifu rafuafoan asca huapaicanimaran? —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús arifi ato yocani, —Ascan ahuuscai marifi maton fuyamisi fustisi man tanapaiyain. Ascashofin Diosin yononi cuscan huatamarocon nan maton shunifoan amaquiri yosimisifo cuscan marifi man nansca huamisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ascacun Upa Diosin yonoqui isca huani, “Maton upa yafi uhua nicasharafain ato shara huacahuun. Ascan tsoan apa iyamarai ahuaqui tsain chaca huacun ato rutumacahuun,” ishon yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Nannori yononifianicun manfin noco yorafo yoiquin isca huamisiquin, “Maton upa iyamarai mato uhua man yoiqui isca huatiro, ‘Nantifi uhuun pui un aya cuscan mun Dios inan. Ascacun un mia ahuara inanpaifiaquicai un mia inainmaran,’ ” ishon yoiquicai mato upa yafi uhua man afanan ahua inantiromaran, ishon man fasi ato amaquiri yoimisi. Anori yoiquicai Diosin yononi cuscacoin man aima. Ascaquifin nan mato fuyamisi fusti man tanaqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ascashufin man paramitsamisifoquin. Nan Diosin tsain yoimisi Isaías inon pacoai cuscan icocoinquin matohuunoa yoiqui isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nan yorafoan uhuunoa yoisharamisifiashocai aton nomuranshon ua shinancoianfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ipaitsi ichananshu fanaincai ua cuficani. Yorafo tapimamisifo cuscacai Diosin tsaincoinma. Nanfoan aton nomuran shinainfo cuscan futsafori yosimisiforan,” —ishon Isaías cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ascashon nannori Fariseofo yafi Moisés cununi cuscan tapimamisifo ato yoitan Jesús yorahuanrasi cunaquin isca huani, —Uqui fucahuun un mato yoinon. Ua nicafain un mato yoiai cuscan tapisharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ahuarafo non piatocai noco ointi chaca huatiroma. Nocofununfin ahuun nomuranshon nan shinain cuscan yafi nan yoia cuscan chaca huatiroquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ascaino non afu rafuafo aqui cashon non yocani; —¿Ifon, man min tapiamun nan rama min Fariseofo yoiai cuscan nicacani sinacaniran? —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ascaiton noco yoiqui isca huani, —Mau ifoancai ahuara chacafo fanatiroma. Ascatama afin foaicun tsucashon potatiro. Nanscarifi aqui uhuun Upa Dios nai muran icatocai nan Fariseofo yonoama futsafo ahuun tsain tapimanon. Ascacun nanfo chipo omitsiscapanacafo muran ato potashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ascacun nanfo shinanyamacahuun. Fushocai afu fusho raqui iyotiroma. Iyopai afu shato muran pacutiro. Nanscarifiai Fariseofoancai Diosin tsain tapishoma futsafo yositiroma atofu funotiro. Ascashu Dios ari tsoa nocopacunacafomaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ascaiton Pedronun yoini, —Min ato yoia cuscan shafacafi noco tapimahuun, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ascaiton Jesús noco yoiqui isca huani, —¿Ascan marifimun man nicasharama? ");
INSERT INTO mcdNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man tapiamamun ahuara man piacai mato shaqui muran nituima? Ascatama manrocon aya poitiro. Ascan nantocai mato chaca huamatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ascashon mato nomuran man shinanchacai cuscan huafain yoiashuri man chacacoin itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ascano aton nomuranshon ahuara chaca shinanfo cuscan nanscacoin huatirofo. Shinanchacafain rutumitsamisi icain aton ahuinma fu nocofunufo icaifoanno ainfofori nanscarifiaifoanno. Ascashon ahuarari onufain futsahuunoa ahuara chaca yoiqui parafain roanmitsamisi itirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nan chacafoanfin yorafo chaca imatiroquin. Ascan nan noco shunifoan apaonifo cuscan muchoquimushoma non piatocai nocon nomuran noco shinanchacamatiromaran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ascacaini Jesús nocofu anoashu cai nan pushurasi Tiro ano yafi Sidón ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nannoashu Cananea anoa ainfo Jesusqui noconi. Nocoshon yoini, —Ifon, minfin David ahuun funaquin. Uhuun ramapaihuu. Uhuun facu ainfoshta fasi omitsiscai. Yoshin chaca ahuun nuushon omitsisca huamisi. Uhuun facu ua caya huashopun, —ishon yoiriani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ascaiton nicafiaquicai Jesús cumanima. Ascaiton non afu rafuafoan yoini, —Ifon, na ainfoan mia yocariaquin noco fucash huaiquin nichihuun, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ascashon Jesús ainfo yoini, —Uhuun Upa Diosin ua Israel ano fusti nichini. Nanfomain nan chashoanun facu funoa cuscarafocun. Ascan uacai caifo futsa ano nichinima, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nicaiyainfo Jesús naman ratoconun mai chachipacufoan yoini, —Ifon, uhuun facushta ua cayahuashopun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ascaiton Jesús afanan cumani, —Apacai ahuun facufoan tushu pashnafo inantiroma. Ascaracai sharama. Nanscarifi aqui Upa Diosin ua yonoa cuscan un Israelifo fusti un shara huashonon. Ascacucai un caifo futsa ano catiroma ato shara huashoshquin. Un asca huaino nan Israelifo funotiro, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ainfoanri yoini. —Icon, Ifon. Ascafia ahuara piqui tushu huafo sapa camaquinoashu potomishti pacuaiton pashnafoan pitirofo. Nanscarifi aquin Upa Diosin mia Israelifo ano nichini min ato shara huashonon. Ascafia mani futsafori miqui nocoaifoan nanfori min ato caya huatiro. Ascashon min ato shara huashoainocai Israelifori funotiromaran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Min ua fasi icoinra huacoinna. Ascacun min ua yoca cuscan un mia ashoiran, —ishon Jesús nan ainfo yoini. Asca huatanaino ainfo ahuun facu cayariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Asca huatan anoashu Jesús no fu cai Galilea ian cusumunri cani. Nannoashu cai machi ano inashu tsaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ascano yorahuanrasi aqui funifo. Fucaquin isinincaifo ihuunifo Jesús ato caya huanon. Isinincai futsa futsatapafo. Futsafo nipaiqui ranainfo ihuufain fushofo ihuufain ahuun caya mumamafo ihuufain tsaintiromafo ihuufain isinincai futsafori Jesusqui ihuunifo. Ascacun nantifi Jesús ato cayapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ascashon ato caya huaa oincani mustairicatan yorafo afi ranan yoinancaquin yoinifo, —Noncai iscara oinyomisima. Tsaintiromafo natian tsaincani. Ahuun caya mumamafori natian man niisharafo. Nipaiqui ranainfori natian niisharatirofo. Jesusfin ahuamamishti huatiroquin. Israelifoan nocon Dios fasi sharacoinran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ascatan non afu rafuafo noco cunashon Jesús noco yoiqui isca huani, —Un na yorafohuun ramapai. Ufu rafu non fusti oshatan icafo. Afanan tsoa tushu ayama. Ahuashtacai picanima. Ascacun uncai ato tushuoma nichipaima. Fasi fonaincani shaca fuatiroforan, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ascaiton non cumani, —Nuno tsoa icamanocai non tushu fuchitiroma na yorahuanrasi pimashquin, —ishon non yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Noco yocani, —¿Ahuuti misi man ayamun? —noco huaiton. —Siete non shiman ranananri non ayaran, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ascaiton Jesús yorafo yoiqui isca huani, —Nanno tsaocahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ascatan ato yoia cuscan tsaoafoanno Jesús misi siete non shiman rananri finifoantan Apa Dios cufini, —¡Aicho! Upan, mihuunshon un ato pimai. Min fasi sharacoinquin, —huatan. Misi yafi shiman torupacutan non afu rafuafo noco inanni. Ascacun yorahuanrasi norifi non ato pashcashopacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ascashon nantifiton picani mayancoinnifo. Ascano man piqui tushu huafo siete shihuati non fospi huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ascan nan piaifo cuatro mil nocofunufoosi ini. Ainfofo yafi facufocai non tanan huanima. Ascafia nanfoanri ato futan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ascatan Jesús nantifi yorahuanrasi nichitan. Noco nanuquifaini cai mai futsa ahuun anu Magadán ano no cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ascashu Magadán ano man non nocoano Fariseofo yafi Saduceofori Jesusqui funifo. Ascano fucashon yocanifo. —Minmain Diospan facucoinquin nan Diosin nai aria icahuunshon tsoa atiroma cuscan noco ismahuu non mia icoinra huanon, —ishon yoinifo. Ahuunoa ahuara chaca ato niaifofo yoipaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ascaifoan Jesús ato cumani, —Manfin yoiquin isca huamisiquin, “Man fari caino imi poshnan. Ascan funamanrifi nai shara itiroquin,” ishon man yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ascashon shafaino nai choshtacun man yoimisi, “Nai choshtapan fupoa. Ascan natian oi fuiran,” man huamisi. Ascashon nai foisquin man tapitiro oi fuyamaraimain ahuuscaiquin. Ascan ahuuscaquitsi Diosin mato yoiai cuscan man icoinra huapaima. Natian ahuara ahuuscarai cuscacai man tapiama. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Man ua icoinra huayamafain chacafiashon man ua yocai. Ascafia tsoan atiroma cuscan un Diosihuunshon huatirofiacai un mato ismaima. Man oinpaifiaiton. Nan Diosin Jonás ani cuscan nan fusti man chipo oinshquiran, —ishon Jesús ato yoini. Ascatan atomaquinoashu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ascano man ian pocufaini cashon non shinanni, —Non tushu ointiaquimacuranaran, —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Non ascaiton onanshon Jesús noco yoini, —Oinfain. Fariseofo futan Saduceofoan aton misi farashati cuscara fiyamacahuun, —ishon noco yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nicai nofi ranan non yoinanni, —¿Ahuuscaimun Jesús noco yoiqui isca huaiquin, “Fariseofo futan Saduceofoan aton misi farashati fiyamacahuun,” noco huai? Non tushu fucuma racan noco isca huaiquin, —icashu non yoinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ascano nan non yoiai cuscan onanshon Jesús noco yoini, —¿Ahuuscaquimun tushuhuunoasi man yoicai? Mancai ua icoinra huaa sharacoiantaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ascashon mancai tapisharataima. ¿Un mucu fustiti misihuunshon cinco mil nocofunufo un pimaita nan man shinainmamun? ¿Ahuuti shihuati fospia tushuita man ointiaquimamun? ");
INSERT INTO mcdNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nan siete misihuunshori un cuatro mil yorafo pimaita nanri man man ointiaquimanamun? ¿Ahuuti shihuati fospia tushuitamun man ointiaquimamun? ");
INSERT INTO mcdNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ascan ahuuscai un mato tushucoinhuunoa yoiyamafiaiton man tapimamun? Unfi tushuhuunoa yoi cafisca huaquin nan Fariseofo futan Saduceofoan yosiaifo cuscahuunoa un mato yoiqui, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ascashon Jesús noco yoiai cuscan nicaquin non tapini tushucoinhuunoa yoitama naan Fariseofo futan Saduceofoan noco amaquiri tapimapaiyai cuscan Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ascatan Jesús no fu mai futsari cani. Nan mai ahuun anu Cesarea Filipo. Nanno nocoshon Jesús noco yoini, —Unfin Diospan Facufiashu un nocofunucoinquin, —ishon yoitan afanan noco yocani, —¿Yorafoan shinanmun un tsoaquin? —ishon noco yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Non cumaquin isca huani, —Futsafoan yoiafin min Juanquin. Nan yorafo unu muran iquimapacumisi, ishon yoiaifoanno futsafoanri yoiquifin min Eliasquin. Ascano futsafoanri yoiafo minfin Jeremiasqui. Ascan futsafoanri yoiafo minfin nocon shunicaifo Diosin tsain yoimisi futsa afanan funiaquin, —ishon noco yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Afanan noco yocani, —¿Asca marifi man shinanmun un tsoaquin? —noco huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ascaiton Pedronun cumani, —Minfin Cristoquin. Nan Diosin nipanacaton mia catonni min ahuun facuran, —ishon yoaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ascaiton Jesús cumani, —Simón, minfin Jonás ahuun facuquin. Diosin mia noiquin mia shara huaa. Rato nocofununcai mia tapimanama un Diospan facu. Uhuun Upa Diosin nan nai muran icaton mia tapimana. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Un mia afanan yoi. Minfin Pedroquin, —ishon Jesús yoini. Ascan Pedrofin Israeli tsainman toquirininhuan. Tsoan putsiquitiroma. Ascasho Jesús afanan yoiqui isca huani, —Min yoia cuscahuunshon futsafoan aarifi icoinra huashquicani. Ascaifoan uhuun yorafo un ato imashquin. Yoshin chacafoan aaton curush huahuunshon ato namapaifiaquicai ato shatuyamafain aato finontiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tsoan shafi ya fupoti fuputiro yorafo pushu muran iquimashquin. Nanscarifi aquin un mia yonoi uhuunshon min yorafo uhuunoa yoitiro uhuun yorafo inonfo. Ascashu uhuun Upa icano iquitirofo. Min yorafo yosiai cuscan tsoa nicacasmai uhuun yora itiroma Upa Dios fu ipashcaquin. Nannori Diosin yoini. Ascan min yorafo yosiai cuscan tsoa icoinra huai uhuun yora itiro Upa Dios fu ipashquin. Nannori Upa Diosin yoini. Ascacun un mia yonoi min futsafo tapimatiro Upa Dios icano iquinonfo. Un mia shafi inain cafisca huai min ato fupushotiro iquiashu afu ipanonfo. Ascashon tsoan min yoiai cuscan icoinra huayamashocai iquitiroma afu ipashquin. Ascan tsoan min yoiai cuscan icoinra huacoinnashu afu ipashquin, —ishon Jesús Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ascatan non afu rafuafo futsafori noco yoiqui isca huani, —Unfin Cristoquin tsoa yoiyamacahuun, —noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ascatan nantian yafi nan achiaifotian Jesús noco shafacafi yoiqui isca huayofafainpaoni, —Un Jerusalén ano cai. Nannoshon nocon niaifofoan ua omitsisca huafain ua ato rutumafiafo osha rafu non fustitan un afanan funishquiran, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ascaiton Pedronun Jesús mutsofaitan yoini, —Ifon, ascayamahuu. Miacai tsoan rutupacunacama, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús ifiacucahuan Pedro yoini, —Satanás catahuun. Min ua amaquiri shinanchacamapai. Upa Diosin shinain cuscacai shinantama nan nocofunufoan shinainfo cuscan min shinanran, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ascatan non afu rafua futsafori noco yoiqui isca huani, —Tsoan ua tanapaisharaquicai afi apaiyai cuscan huatiroma. Ascatama nan un yoiai cuscacoin huatiro. Ascashon shinanqui isca huatiro, “Ua omitsisca huafiaifoanno uncai uhuun Ifo potapacunacama. Ahuunshon ua rutufiaifoanno un tanaqui unupacunacamaran,” ishon man shinantiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ascan tsoan shinanqui isca huai, “¡Ohua! Un Jesús tanaiton raca ua omitsisca huacanicati,” ishon shinanquin uhuun tsain cachiquiri huaa. Nanscara yorafo naashu omitsiscapanacafo. Ascan tsoa uhuunoashu omitsiscacai naa. Nanscara yorafofin nacanashu ufu isharapacunacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ascan ratoran futsa nantifi manifoti anoafo ahuara fia ahuunacoin ifiashu amaqui naino nantifi ahuunafo funotiro. Ascashu nantifi ahuuna iyopaonifia omitsiscapanacafo muran cainocai afanan ahuashta itiroma. Ahuaracai Dios inantiroma afu ipashqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ascatan un chipo nai murannoashu mai ano fotoaino nan uhuun Upa cuscaracoin iishqui. Ascashu un chasha curanaino uhuun oinmatifo ufu nai muran icafo ufu fotoshcani. Nantianri un nantifi yorafoan aton niaifocoin iishquin. Ascashu nan yorafoan acafo cuscan un ato inanpacushquin. Nan shara huamisifo un ato inansharafain un ato unimamashquin. Ascan nan chaca huamisiforicai un ato ahua inansharashquima. ");
INSERT INTO mcdNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ascacun icon un mato yoi. Man futsa nuno ufu niaton naataishoma un maton niaifo Upa Dios cuscaracoin un icaiton man oinshquiran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ascano man seis osha finontan Jesús Pedro non Juan non Santiagori machi cuya pochininshon ato iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ascan nannoashu aton ointaifi Jesús ahuun yora mumacoin fianananriscatanaino ahuun fusori fasi chashacointani. Nan fari chashai ointsa. Ahuun sahuutiri oshopacoin nan yoa rama furoa ointsa ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ascaino nantianri Moisés yafi Elías aqui niriscatanifo. Ascashu nan rafu Jesús fu tsaincaiton oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ascaiton Pedronun yoini, —Ifon, nuno non icashara itiro. Man ascapaiyaiton un mato tapasi rafu non fusti huashotiro. Mina futsa non Moisésna futsa non Eliasna futsa un mato ashotiroran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ascashu Jesús fu tsaincaino coin osho sharacoin atoqui cuyopacuni. Ascaino coin murannoa oi nicanifo yoiqui isca huaiton, —Nanfin uhuun Facuquin. Un fasi ahuun noi. Nanfin un catoanquin. Un aqui unimacoin. Ascacun a nicacoincahuun, —ishon Upa Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ascaiton nicacani fasi ratucoincani fuopacufoannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ascaifoan Jesús ato pumanqui yoini, —Funicahuun. Ratucaquima, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ascaiton foisinifoanquin oianfo Jesús fusti nia ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ascatan machi pochininnoashu fotoshon Jesús ato yoiqui isca huani, —Nan man rama oian cuscan tsoashta yoiyoyamacahuun. Nan un naashu afanan funiano man rama oian cuscan man yorafo yoitiroran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ascaiton nicacaquin afu rafuafo yocanifo, —¿Ascan ahuuscaquimun Moisés cununi cuscan tapimamisifoan noco yoimisifo isca huaquin, “Nocon Numamisi Cristo nan Diosin catoan nocoqui oataima rufofo Elías oshquiran,” ishon noco yoimisiforan? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús ato yoini, —Icon. Elías rucun oitautiro. Oshon nantifi ato imasharapai aton chaca shatunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ascan man ofiacucai tsoan onannima. Nan chaca huapaiyaifo cuscan fusti nan chaca huanifo. Nanscarifi aquin ua omitsisca huashcaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ascaiton nicacani afu rafuafoan shinantani nan Juan yorafo unu muran iquimapacumisihuunoa ato yoiai cuscan tapinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ascatan machi anoashu fotocuranaino yorahuanrasi aqui noconifo. Ascaino nannoshon nocofunun ratoconun mai chachipacufoan Jesús yoini, ");
INSERT INTO mcdNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ifon, uhuun facuhuun ramapaihuu. Yoshin chaca ahuun nuushon fasi omitsiscamai. Chii muran potafain unu muranri potatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Uhuun facu mifu rafuafo ano un iyofiacai tsoan caya huama, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ascaiton Jesús non afu rafuafo noco yoini, —¡Ohua! Mancai ua icoinra huacoinnama. Man fasi amaquiri shinanmisi. ¿Ahuutia un matofu icamun man ua nicayamacaiyai? —ishon noco yoini. Ascatan facun ahuun apa yoini, —Min facu ua ihuushonhuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ascaiton furun ihuushocun Jesús yoini, —Minfin yoshin fasi chacacoinquin. Na facumaquinoashu catahuun, —ishon Jesús curushcain yoiaino cayariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ascatan non afu rafuafosi Jesús fu tsaintan non yocani, —¿Ahuuscaimun norifi non yoshin chaca facumaquinoa potamaquin? —ishon non yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Noco afanan yoini. —Manfin ichapama ua icoinra huaaquin. Ascacun un mato icon yoinon. Nan mostaza ushu uhuapamashtacoinfia foaicashu yosia uhuapacoin itiro. Nanscarifiai man ua ichapama icoinra huaquin tau huatiro. Ascan chipo uhuun tsain maton nomuran nanucoinshon man ua fasi icoinra huaqui finacointiro. Ascashon man machi yoitiro shucucaitahuun man huaino shucucaini futsa ano catio. Ascaino ua icoinra huacoinshon nan man apaiyai cuscacoin man huatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ascan man Upa Dios cufiyanan piqui tunuyamashocai nan na cuscara yoshin chaca man potatiromaran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Ascatan Galilea ano nocofu caquin afanan Jesús noco yoiquin isca huani, —Un mato yoimisi cuscan afanan un mato yoi. Futsan ua ato achimashquin ua rutunonfo. Ascafia osha rafu non fustitan un afanan mai murannoashu funishquiran, —ishon Jesús noco yoini. Ascaiton nicaquin non fasi shinancoinni nocon nomuran noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ascatan nannoashu non cai Capernaum pushurasi ano non noconi. Nanno non nococun nan Dios fu tsainti pushu murannoa pui fimisifoan Pedro yocanifo. —Man min tapia nocon caifoan faritifi pui inanfo Dios fu tsainti pushu muran yonoafoan nan yopaifo cuscan ahuun finonfo. ¿Ascan mato Ifo Jesús arifi man inanmisimun? —ishon Pedro yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedronun ato cumani, —Aifain. Naanfin inanmisiquin, —ishon ato yoini. Ascashu Jesús man pushu muran iquiano Pedro arifi iquini. Ascaiton Jesús Pedro yoini. —¿Maifoti anoa niaifofoanmun ahuun caifocoin pui fiapai iyamarai mai futsa ariafo yocaiqui? ¿Pedro, asca min raquiri shinainmun? —ishon Jesús Pedro yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Mai futsa ariafo fiantiroran, —ishon Pedronun cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ascaiton yoini, —Min ua cuma cuscan iconfia non na pui fimisifo nocoqui shinanchacamapaima. Ascacun ian ano catahuun shuamaquin shiman fiishquin. Ascashon ahuun shaqui murannoa toro fuchishon min fitiro uhuuna yafi mina nan Dios fu tsainti pushu murannoa pui fimisifo nocohuunshon ato inanshquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ascaiton non Jesús yocani. —¿Ifon, ratotocaimun Dios icari fasi finoncoianquin? —ishon non yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús facu cunani, —Facushta, nuri ohuu, —huaino ocun ato nastui nimani. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ascashon ato yoini, —Un mato icon yoi. Man shinan futsayamashu nan facu cuscara man iqui. Man ascayamacai Dios icari man noconacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ascacun na facu apa yafi ahua nicafain icoinra huatiro cuscan ratoran futsan ua icoinra huacoinnashu nanfin uhuun Upa Dios icariashu fasi finoncoian iishquiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Asca ratoran futsan uhuunshon facufo shara huafin nan uari shara huai cafisca huai. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ascafia ratoranfoan ua icoinra huafuna futsan chaca huamai nancaifin fasi onaintimaquin finacoinquin. Chaca huamataima toquiriya tunushushon unu noacoin muran potafin shara icuanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ascano nan icoinra huamafoan futsafo chaca huamamisi. Ascafia nanfocaifin fasi omitsiscacoinshcaniquin. Ascashon mato chaca huamapaifafaincani. Ascafia nan futsa chaca huamafocaifin fasi omitsiscai finacoinshcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ascano mato mucuman man chaca huacun mushatumushon potacahuun afanan chaca huashquima. Man raquira caquin chaca huashon mato tau shatuhuu potashquin afanan chaca huashquima. Man mumamafiashu Dios icano caafin sharacaiqui. Mumafiashu man omitsiscapanacafo muran cacuana. Nanno chii urumanhuan matsinacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nanscarifiai ahuara oinquin chaca huashon mato furo tsucahuu potashcaquin afanan chaca huashquima. Niyoashu furo fustiya man Dios icano caafin sharacaiqui. Ascan niyoashu furo rafuya man omitsiscapanacafo muran cacai sharama. Nanno chii urumanhuan matsinacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Facufohuunoa isca huaqui shinanyamacahuun, “Na facucai ahuamaran,” ishon atohuunoa shinanyamacahuun. Un mato cayacafi yoi Upa Diosin ahuun oinmatifoan facufo cushusharafafainmisifo. Nan oinmatifori Upa Dios fu ifafaincani. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ascacun nantifi yora funoafo numayoifin un oaquin. Ascashon un aton chaca soashona isharapacushanonfo un oni. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ascano un mato yoinon. Ratoran futsa cien chashoan ayafiano fustishta amaqui funoano atirifi nan noventa y nueve faasi fununun potayofaintio a fusti funoa funayoicaquin nan fuchiaitian. ¿Ascan man ahuu cuscara shinantiromun? ");
INSERT INTO mcdNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ascashu noventa y nueve ahuun chashoanfoqui unimafiaicai nan funoa fusti fuchiaquicaifin fasi unimai finacoinquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nanscarifiai maton Upa Dios nan nai muran icatocai nan ua rama icoinra huafo fustishta funopaima. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ascacun tsain futsari un mato yoi. Ua icoinra huaa futsan mia chaca huacun aqui cashon mia chaca huaa cuscan nan fusti yoihuu. Min yoiai cuscan nicashquin yoinon, “Ai. Mian yoia cuscan icon. Un mia chaca huaa. Ascacun ua rau huapun,” ishon yoitiro. Ascaquifin mihuunoashu afanan Diosqui nasoaquin afanan mifu rafushquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Asca min yoiai cuscan mia nicacasmaiton icoinra huaa fusti iyamarai rafu iyohuu nan nocofunun yoiai cuscan nicaquin arifi icoinra huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ascafia nan rafuri nicapaiyamaiton icoinra huafo ichanainfotian nannoshon nantifi tapimahuu. Asca nan ichananfori nicacasmaiton nanfoan yoitirofo, “Aacai afanan Diospan yoracoin cuscaramaran,” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ascacun un mato icon yoi. Ahuara man nunoshon yoia cuscan arifi Dios nan icanoshon nannori yoi. Nanscarifiai man ahuara nunoshon yoiyamaino arifi Dios nan icarishon yoitiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Afanan un mato yoi. Man rafu nuno mai ano ichananshon nannori rafu shinanqui man ahuara yocaiton nan uhuun Upa Dios nai muran icaton mato ashoshqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ascashu rafu iyamarai rafu non fusti yora ua icoinra huashu ichanainfoanno urifi un atofu ichanainran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ascaiton Pedronun yocani —¿Ifon, futsan ua chaca huafafainaitomun un rau huaquin ahuuti huatiroquin? ¿Siete un rau huaquin huatiromun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús cumani, —Ma. Siete huaquima. Nan mia chaca huafafainaiti min rau huatiroran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Ascacun un mato yoiai cuscan nanfohuunshon man tapitiro ahuu cuscaramain Diosin ahuun yorafo iquifain ato yonotiroquin. Isca huaquin mato tapimai. Niaifoan ahuun oinmatifo cunani nan nifiafo cuscan inanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ascano nan oinmati futsan ahuun niaifo fasi ichapacoin millones nificun aqui ihuunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nan nifian cuscacai ahua inantiro inima. Ascacun ahuun niaifoan yoiqui isca huani, “Min ua ahua inantiroma. Ascacun un mia niaifo futsa inain min ahuun yonomati inon. Nanton mihuun rafanan ua pui inanon. Ascacun un mia inanfain min ahuin yafi min facufo non min mafofori nantifi min aya cuscan un inanmitsai ahuun rafanan min ua nifian cuscan fiishquin,” ishon niaifoan yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nicaquin oinmatinin ahuun ratoconun mai chachishon yoiqui isca huani, “Ifon, uhuun ramapaihuu. Funayamapun. Un mia nifian cuscafin un mia chipo nantifi inainqui,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Asca huaiton nicai niaifo ahuun ramapaiquin yoini, “Afanan ratuyamahuu. Natian min ua nifian cuscan un afanan shinainma. Min ua inanyamafiaiton nantifi un soai min ua afanan nifinonma. Ascacun casharatahuun,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","29","Ascano niaifoan ahuun pushu murannoashu caqui afu oinmati futsa fuchini. Nantori nan ichapamashta nifian ini. Shafa fusti yonona nifian ini. Ascafiacun aqui nocoshon tumosfain achishon yoini. “Mian nifian cuscan ua inanriscahuu,” huaiton ratoconun mai chachishon yoini, “Funayamapun. Un mia inanon,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Asca huafiaitocai futsa manapainima. Ascatama futsanrocon cunu muran iquimani nan nifian cuscan inaintian amuran iyonon. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ascaiton oincani oinmati futsafo fasi ahuun ramapaicoinnifo. Ascano focashon nan acaiton oian cuscan niaifoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ascano focashon yoiaifoan nicaquin niaifoan ahuun oinmati cunashon yoini, “Minfin fasi chacacoinquin. Mian fasi ichapacoin nififiashon min yoiqui isca huaa, ‘Ifon, manayopun. Un mia nifian cuscan un mia inanon,’ ishon mian yoiaiton un mia nantifi soashona. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ascacun un mihuun ramapaia cuscan nanscarifi aqui mifu oinmati futsa min ahuun ramapaia shara icuana. Ascatamarocon min ahuun ramapaiamaran,” ishon niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ascashu fasi sinacoinquin niaifoan oinmati cunu muran iquimafain fasi onaintimashqui. Ascashon ahuun oinmatifo yonoqui isca huani, “Nan ua nifian cuscan nantifi ua inanyamaiton cunu muranshon cainmayamacahuun,” ishon nan yora omitsisca huamisifo ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nanscarifi huaquin ratoran futsan mato chaca huafiacun man ato rau huayamaino niaifoan ahuun oinmati chaca onaintimana cuscan huafain nanscarifi aquin nan uhuun Upa Diosin nai muran icaton matori onaintimashquiran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ascano tsainqui anaititan Jesús nocofu Galilea anoashu Judea mai unu Jordán ocuma futsa cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ascaiton yorahuanrasiton mufaincun nannoshon nan isinincaifoti ato caya huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ascaino Fariseofo Jesusqui funifo. Amaquiri cumamapai fucani. Ascacun yocanifo, —¿Moisés cununi cuscan nocofunun ahuin unupaiquin unutiromun? ¿Nocofunun ahuin ahuuscarashta aiton unutiromun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús ato cumani, —¿Man Moisés cununi cuscan oinmisimamun? Diosin nantifi onihuani. Tau huaquin nocofunu yafi ainfo onihuani. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Ascano Diosin yoiqui isca huani, “Ascacun nocofunun ainfo fiaino apa yafi ahuamaqui pashcashu ahuin fu itiro. Ascashu nan fusti shinantsa ashcaquin,” ishon cununiquin. Ascacun Diosin ato fianan huaa cuscan afanan tsoa pashcanantiromaran, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yocanifo, —¿Nan iconfiacun asca ahuuscaquimun Moisés yonoquin isca huaniquin? “Tsoan ahuin unupaiquin iquisi cunushoquin isca huatiro, ‘Un afanan mia fipaima. Mun mia unuiran,’ ” ishon Moisés cununiran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Afanan ato cumani, —Manfin nan maton shunifo cuscaraquin. Nanfoanri Dios nicacasmapaonifo. Nanscarifi huaqui marifi man nicacasmai. Ascacun rama man yoia cuscan nannori Moisés cununi. Ascafiacai Diosin tau huaqui anori yononima. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ascacun un mato cayacafi yoi. Ratoran futsan ahuun ahuin nocofunu futsa fu iyamafiacun ahuin unui futsa fiishquin. Asca huaquifin nanton chaca huaiquin. Nan ahuun ahuinma fu iquin cafiscairan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ascaiton nicaquin non afu rafuafoan yoini, —Nanscaracun nocofunu yafi ahuin fiananfoma shara icuanaran, —non huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús noco cumani, —Un yoiai cuscacai atirifi yorafoan tapitirofoma. Nan Diosin ato shinanmanafoansifin tapitirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ascano atirifi nocofunufocaiyainfo fu fianantirofoma. Atirifi nan cainni cuscan ainfo fu itiroma. Ascan futsafoan atirifi chaca huatiro ainfo fu inonfoma. Ascaino atirificaiyainfo fu fiananfoma Dios yonosharashoshcaquin. Ascacun tsoa ahuionma itiromainquin nan un mato yoiai cuscan nicacahuun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ascaino yorafoan aton facumishti Jesusqui ihuunifo ato manmanpacuquin Apa Dios cufishonon. Asca huafiaifoan non afu rafuafoan ato yoini, —Maton facufo ihuutan nocon Ifo fucash huayamacahuun, —ishon non ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús noco yoini, —Ato nitun huayamacahuun uqui funonofo. Uhuun Upa Dios niaifo icariafofin nan facumishti cuscaraforiquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ascashon facufo manmanpacutan Jesús cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ascano pushcohuai Jesusqui caashon yocani, —Tapimamisiton minfin sharacoinquin, ¿Unmun ahua shara huatiroquin Dios fu ipashashquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús cumani, —¿Ahuuscaquimun mian yocaiquin ahuara sharahuunoa? Nannofin fustiquin shara. Naanfin Diosiquin. Ascan min Dios fu ipapaiquin nan noco yononi cuscan nicacoinfain nan yoia cuscacoin min huatiroran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Rato noco yononicaimun un nicacoinfain nan yoia cuscan un huaiiqui? —ishon yocaiton. Jesús yoini, —Futsa rutuyamahuu. Min ahuinma fu iyamahuu. Ahuara onuyamahuu. Chaniri yoiyamahuu. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Upa yafi uhua nicasharafain ato shara huahuu. Nan mifiri min noiai cuscan futsafohuunri noihuu, —ishon yoaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Nantifi min ua yoiai cuscan mun nanscacoin huaa. ¿Ascan ahua futsamun un ahuusca huatiroquin ahuunoashu isharashquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Afanan yoini, —Min Dios cuscara shara ipaiqui nantifi min aya cuscan inanmitsashon ahuun rafanan pui fiihuu ahuuomafo ato inanshquin. Min ascaitofin Upa Diosin nai muranshon mia ahuara sharacoin mucushoniquin. Asca huatan ua tanasharahuu, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Asca huaiton nicai nan pushcohuai puusinima. Mafo ichapayashu ahuun mafofo inanmitsacasmai. Ascatan Jesusmaquinoashu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ascashu man caano Jesús noco yoiqui isca huani, —Un mato icon yoi. Yora mafo ichapaya fustirasi uhuun Upa Dios niaifo ari nocopaifiacani nocotirofoma. Nanfoan aton mafo ichapa shinanquicai tsoan Dios shinantiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ascacun afanan un mato yoi. Nan ina camellocai acoya shoi muran finontiroma. Mimacaifi nocofunu mafo ichapaya Diosin niaifo ari nocotiromaquin, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ascaiton nicacaquin non afu rafuafo mustairitan non yoini. —¿Ascan tsoa Dios fu nipatiromun? —ishon non yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús nocoqui fusoacucahuan noco cumani, —Nocofunucai afiri numatiroma. Diosin fustitofin yorafo numatiroquin. Nantofin ahuamamishti huatiroquin. Nocofunufoan atiroma cuscan nan Diosin huatiroran, —ishon noco yoaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedronun yoini, —Ifon, nonfin nocon ahuarafo nantifi yafi nocon yorafo non pota furani mifu oaquin. ¿Ascan Diosimun noco ahua inainquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Afanan Jesús noco yoiqui isca huani, —Un mato icon yoi. Un chipo nantifi manifoti iquinaitian nantifiton ua oinshquicani uhuun Upa Dios cuscara sharacoin icaiton. Nantianri marifi nan ua tanamisi nocon caifo doce shoco Israelifo marifi man ato iquishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ascatari tsoan uhuunshon ahuun pushu yafi ahuun yorafo potafain apa potafain ahuari potafain ahuun facufo yafi ahuun mairi potashon ua tanapaisharai. Nanscara yorafin uqui nocoaitian fasi paratama fiishquiquin. Ascashu ufu ipanaca. ");
INSERT INTO mcdNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ascafia yora ichaparasi niyoashu nan niaifo cuscarafo. Ascan naashucai afanan tsoa ahua ishquima. Nanscarifiai atirifi niyoashu nan ahuama shinantsafo. Ascafia naashu u futan futsafori iquishcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ascano ahuu cuscaramain Upa Diosin ahuun yorafo iquinai cuscaraquin afanan un mato tapimai isca huai. Mau ifoan funamanrishta nocofunufo funai cani ahuun mau uhuapa ano yonoi fononfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ascano ato fuchishon yoiqui isca huani, “Uhuun mau ano yonoi focahuun. Nan man shafa fusti yonoa cuscan un mato inain. ¿Ascan sharamun?” ato huaiton. “Ai. Sharafinquin,” huanifo. Ascashon ahuun mau ari ato nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ascatan man fari cuyainano mau ifoan caaquin oian plaza ano nocofunufo nia ini tsoa yonoima. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ascaiton mau ifoan ato yoini, “Uhuun mau ano yonotacahuun un mato ahuun rafan inansharanon,” ato huaiton. Nicacani fonifo yonoi focani. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ascano mau ifo afanan fari masafinin racano caaquin oian atirifi nocofunufoan ahuushta huatama niafo oinquin. Ato yoini, “Uhuun mau ari fotacahuun,” ato huaino man foafono. Afanan man fari cushca cainnaino macushcamuano atirifi fuchishon nanscarifi huaquin ato nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ascatan man yatai fari nii manaon caano mau ifoan afanan caaquin atirifi fuchini yonocanima niafoan. Ascaiton ato yocani, “¿Ahuuscaimun nan shafatisho yonotama man niaquin?” ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Cumanifo, “Tsoan ahuashta noco yonoamaran,” huaifoan. “Ascacun marifi uhuun mau ari ua yonoshotacahuun,” ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ascashon man yamuaino mau ifoan yonona niaifo patashari yononi, “Ua yonoshonaifo cunahuu nan yonoafo rafanan ato inanshquin. Ascashu ato inanqui tau huahuu nan ahuun unutaqui foafo yafi nan foi tauafo,” ishon yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ascaino man fari nii manaon caano foafo. Nanfo ato inanni naan shafa fusti yonoa shinantsa huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ascano nan funamanrishta yonoi tauafoan oincaquin yoinifo, “Mau ifoan ato inanshara. Ascan nonfin paratama yonoaquin. Ascacun noco fasi paratamacoin inainran,” ishon shinannifo. Ascafia nan chipo iquiafo ato inan cuscari ato inanqui huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ascashon ato yonohuunshon ato inainton fiicani mau ifoqui tsain chaca huacani afi ranan yoinancaquin yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ascan nonfin nan shafatishon yonoaquin. Fari isicoin muran. Ascan man fari caino chipo fuafo min ato inan cuscan huaquin nocorifi min inainran,” ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mau ifoan futsa cumaqui isca huani, “Uhuun yorashta. Uncai mia inanqui chaca huama. ¿Ascan manmun u futan shara huama man shafa fusti yonoaihuunoa? Man manfin ‘Shararan’ huaaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ascan naquian min pui fiihuu min pushu ano catashquin. Ascan nan fari man nii manaon caano yonoafo nan un mia inain cuscan nanfori un ato inansharapai. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nan un ato inanpaiyai cuscan un ato inantiro. Nanmain uhuun puicufin. ¿Ascan ahuuscaquin nan faricaino yonoafo yafi man uqui shinain chacaimun? Unfin futsafori shara huapaiquin,” ishon mau ifoan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ascan nanscarifiai Upa Diosin nan icoinra huaqui tau huafo ato shara huaa cuscan huaquin nan chipo icoinra huafori nanscarifi ato shara huairan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ascashu Jesús Jerusalén ano caquin doce non afu rafuafo noco fusti futsano iyoni nannonshon noco yoiquin isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Non Jerusalén ano canon. Nannoshon futsan ua ato achimai nan nocon niaifofo futan Moisés tsain tapimamisifoanri ua chaca huacaquin yoicani isca huacaquin, “Jesús rutucahuun,” ishon yoifocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ascashon caifo futsafori ua inancani nanfoan ua cashu mutsama huafain fichi cunoqui tuchiaton ua coshacani. Ascatan ihui coyan iquinanqui ua mastacani un nanon. Ua asca huafiafo osha rafu non fustitan Upa Diosin afanan ua funimairan, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ascano Zebedeo ahuun facu rafu Juan yafi Santiago ahuan ato Jesusqui iyoni. Ascatan aqui nocoshon ahuan Jesús ratoconun mai chachishoni. Ahuara futsa yocapaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ascaiton Jesús yocani, —¿Min ahua yoipaimun un mia ashonon? —huaiton. —Ifon, Upa Dios icari nantififain min aton niaifo icaitian uhuun facu rafu mifu niaifo patashari ato imahuu. Ascatan niaifoan ahuun tsaoti ano min tsaoaitian uhuun facu rafutan mia naqui huashu tsaononfo, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Man ua yocai cuscacai man tapiama. ¿Un omitsiscashquiain cuscan man ufu omitsiscatiromun? —ishon Jesús ato yocaiton. Cumanifo, —Ai. Non mifu itiroran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ato cumani, —Icon marifi man omitsiscai. Ascafia uncai yoitiroma tsoanmain ua naqui huashu tsaoicai. Uhuun Upa Diosin fustitofin tapiaquin. Nan catoanfosi ufu nanno tsaotiroran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ascaiton nicai non afu rafuafo atirifi mucu rafuti nan nanu rafuqui non fasi sinacoinni Jesús naqui huashu tsaopaiyaifoan nicai. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Non ascaiton tapishon Jesús noco cunashon yoiqui isca huani, —Uqui fucahuun un mato yoinon. Nan icoinra huafoma niaifofoan ato curushcain yonofafainmisifo. Aton niaifo patasharifoanri ato yoiqui isca huamisifo, “Nonfin mato ifoquin. Ascacun non mato yoia cuscan man noco ashorisca huatiroran,” ishon curushcai ato yoimisifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ascafiaifoanno ato cuscara iyamacahuun. Man ratoran futsan niaifo ipaiqui maton oinmati man shara huafafainmisi itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ascatan man futsan futsafori finonpaiyaino ahuun yonomati man itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nanscarifiai futsa ua ashononcai un oama. Ascatamarocon un futsafo ashoyoi ua oa. Ascatari un atohuunoashu naashquin un oni afanan Satanás ato ifon inonma, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ascatan non Jericó anoashu caiton yorahuanrasifain noco mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ascaino nannori fai cusumun fusho rafu tsaoafo ini. Jesús fain caiton nicaquin nan rafutan cunanifo isca huaquin, —Ifon, minfin David ahuun funaquin. Nocohuun ramapaipun, —ishon cunanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ascaifoan yorahuanrasifain ato asca huanifo afanan tsainonfoma. Ato asca huafiainfoanno oi ashcafinin afanan cunanifo, —Ifon, minfin David ahuun funaquin. Nocohuun ramapaipun, —huariaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús nituacucahuan ato cunashon yocani, —¿Un mato ahua ahuusca huashotiromun? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Ifon, non fasi oinpaicoin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús atohuun ramapaiquin aton furo muainno cayariscatan oinsharanifo. Ascashon nan rafutari Jesús mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ascatan non Jesús fu cai Jerusalén chaima non noconi. Nan chaimari pushurasi futsa ahuun anu Betfagé machi Olivo tunanman ini. Nanno nocoti chaima Jesús afu rafuafo rafu pushurasi Betfagé ano ato nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ato nichiataima ato yoiqui isca huani, —Nan pushurasi ano fotacahuun. Nanno nocoshon man oian burro facuya nushua man fuchicai. Nan tupushon nuri ua ihuushotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Futsan mato yocaiton ato yoicahuun, “Nocon Ifo yopaiton non iyoshoni cai. Ascafia non mato nasorisca huairan,” ishon ato yoitacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jesús acai cuscan huaquin nannori ahuunoa Diosin tsain yoimisiton cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ascano cunuquin isca huani, “Jerusalén anoafo yoihuu isca huaquin, ‘Oincapon. Mato niaifocoin matoqui oi. Nan burropan facu camaqui tsaoashu matoqui oi. Nancai nocofunu ahuaton curafiapaitama shara fustisi oitsii huafain fusti yoitiroran,’ ” ishon Diosin tsain yoimisiton ahuunoa cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ascatan nan rafutan Jesús ato yoia cuscacoin huashonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ascashon burro yafi ahuun facu Jesús iyoshonifo. Iyoshocata burropan facu camaqui ato camisa fucashonafoanno acamaqui Jesús tsaoinacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ascatan caiton yorahuanrasifoan fai naman cayan afufori aton camisafo fucashonifo. Ascaino atirifiton shupa shatushon nan caifufori nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ascano nan yorahuanrasi afufori foaifo futan acachori foaifoan nantififain oi ashcafinin yoinifo. ¡Aicho! David nocon niaifo ipaoniton ahuun funa nocoqui oi. Nanfin Dioshuunoashu nocoqui oiquin. Ascacun Upa Diosin nan shara huahuu, ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ascashu Jesús Jerusalén ano caiton nicacani nantifi yorafo mustairicatan afi ranan yocanonannifo, —¿Tsoamun naaquin? —icashu. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ascaifoan nan Jesús fu foafoan yoinifo, —Nanfin Jesusquin. Diosin tsain yoimisi. Nanrifi pushurasi Nazaret nan Galilea anoaquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Asca huatan Jesús Israelifoan Dios fu tsainti pushu muran iquitoshiquin oian amurannoashu ahuara inanmitsashon pui fiaifoan oinqui nan sapa acamaquishon pui fiaifo finifoan arasaquin futsani. Ascashon nan ruhui inanmitsaifoan aton tsaotiri finifoan potaquin futsani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ascashon Jesús ato yoini, —Diospan tsain cunuquin isca huani, “U fu tsainti pushu muranshon man ua fusti cufitiroran,” ishon cunufiani nan yomutsofoan ichananti cuscara man huapairan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ascaino fushofo yafi nipaiqui ranainfo Dios fu tsainti pushu muran Jesusqui funifo. Ascacun ato caya huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ascaiton nan Dios fu tsainti pushu muranshon unimacaquin facufoan oi ashcafinin yoinifo, —¡Aicho! Nan David ahuun funa Jesús fasi shara. Ascacun nan shara huahuun, Upa Diosin, —ishon yoinifo. Tsoan atiroma cuscan huaquin Jesús ato shara huashomisi ascaifoan nicai Israelifoan niaifofo yafi Moisés tsain tapimamisifo sinacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ascashon nanfoan Jesús yoinifo, —¿Nan facufoan yoiaifo cuscan min nicaimamun? —ishon yocaifoan ato cumani, —Aifain. Munfin nicaiquin. ¿Ascan marifi nan Diosin tsain cununi cuscan man man nicamisimun? Cunuqui isca huani, “Mihuunshon facufoan mihuunoa tsain shara yoicaniran,” —ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anori ato yoitan atomaquinoashu no fu cai pushurasi ahuun anu Betania ano cani. Nanno osha fustiyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iyoconaino Jesús Jerusalén ano cai fonaincoinni. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ascashu caquin oian fai cusumunri fana higuera fuchini. Ahuun fimi pipaifia ahuun puifosi ini. Ascacun nan fana Jesús yoiqui isca huani, —Afanancai min fiminacamaran, —ishon yoini. Yoiquin asca huaino fana tsasisiriscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ascaiton oin non afu rafuafo non mustairini. Ascashon non yoini, —¿Ahuuscashumun nan fana tsasiriscaaquin? —ishon non Jesús yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Noco yoini, —Un mato icon yoinon. “Un icoinra huai iyamarai un icoinra huaimaran,” ishon shinantama man icoinra huacoinshon un fana tsasi huaa cuscan marifi man nanscarifi huatiro. Ascashon machiri man yoitiro, “Tsucucai. Unuhuan muran pacuhuu,” man huaino unuhuan muran pacuriscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ascacun man icoinra huacoinshon ahuarashta man Upa Dios yocaiton mato ashotiroran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Asca huatan Jesús Israelifoan aton Dios fu tsainti pushu muran iquishon ato yoiaino Israelifoan aton niaifofo aqui funifo. Aqui fucashon yocanifo, —¿Min acai cuscan tsoan mia yonoamun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesús ato cumani, —Urifi un mato yocai. ¿Juanpan yorafo unu muran iquimapacuni tsoan yonoa asca huanimun? ¿Diosin iyamarai nocofunufoan yononifomun? Man ua cumasharaiton urifi un mato cumatiroran, —ishon ato yoiaiton. Nicacani afiranan yoinannifo —Diosin Juan nichiniran non huaiton Jesús noco yoitiro, “¿Ascan ahuuscaquin man Juan icoinra huamamun?” noco huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ascan Juan nocofunufoan nichiniran non huaino yorafo nocoqui sinatirofo. Nantifi yorafoanmain yoimisifo “Juanpan Diosin tsain yoimisiran,” ishon. Ascacun noco asca huatiroforan, —icashu niaifofo yoinannifo atoqui musucani. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ascashon Jesús yoinifo, —Noncai tapiama tsoanmain Juan yonoaquin, —ishon yoiaifoan. Jesús afiri ato yoini, —Urificai un mato yoima tsoanmain ua yonoa un ahuarafo huaiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Asca huatan ato yocani, —¿Man raquiri shinainmun? Nocofunu facu pushcohuai rafuya ini. Ascashon furu iyoa apan yoini, “Upashta, nocon mau ano yonotahuun,” huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Furumun cumani, “Ma, upa, un yonoicaimara,” huafiashu chipo shinan futsashu cani. Ascashon furu chipocuri yoini, “Upashtan, nocon mau ano yonotahuun,” huaiton. “Ai, upa. Mun yonoicairan,” huafiashucai canima. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ascan rato ahuun facu rafu nan apa yoia cuscacoin animun? —ishon Jesús ato yocaiton. —Nan iyoaran, —ishon cumaifoan. Afanan ato yoini, —Un mato icon yoi. Nan yora chacafo niaifo pui fishomisifo yafi ainfo furomafoanri ua icoinra huacanashu nanfo Diosin nantifi iquinai ano iqui tautirofo. Ascan mancai ari iquitiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juanpan mato yoisharapaoni isca huaquin, “Man chaca huamisi cuscan shatufain natian Dios shinancahuun,” ishon mato yoipaoni. Ascafiacai man icoinra huanima. Nan niaifo pui fishomisifo futan ainfo furomafoanri icoinra huaifoan oinfiaquicai maton chaca shatuyamafain man icoinra huamisimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Nicacahuun un afanan ahuara futsahuunoa un mato yoi mato tapimashquin. Mau ifoan ahuun mau ano fimi ahuun anu uva fanani. Ascashon ahuun fimi ica cuscan toquiri cunuacuni ahuun fimi fana ahuaton chaca huanonma. Asca huatan mai quini huashon amuran uva huashon ahuun tau puama puama anifo ahuun fimi unu fiishcaquin. Ascashon toquiri cuyacoin masoni anoshon ahuun yonomatinin cushushonon. Asca huaquin anaitishon futsafo yoini ahuun mau cushushononfo. Asca huafaini mau ifo mai futsa ano cayoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ascashu man fimi ano mau ifoan ahuun oinmati futsafo mau ano nichini ahuun fimi fishononfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ascano nocoafoan fimi cushumisifoan ato achicashon futsa sutufain futsa rutucoinfain futsari toquirinin tsacaqui futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ascano mau ifoan ahuun oinmati ichapama nichiqui tau huani. Ascashon afanan acachori fasi paratama nichini. Ascafia nanfori ato chaca huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ascashon mau ifoan shinanni, “Uhuun facucoin un nichicuraca nicatirofoati,” ishon ahuun unutaqui furucoin nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ascashon apa nichian caiton oincani nan fimi cushumisifo ahuun yoinancaquin yoinifo, “¡Oincapon! Mau ifoan ahuun facu oi. Na maufin apanaquin. Ascafia apa chipo ahuun facu inanshquin. Ascacun non rutunoncahuun nocona mau inon,” icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ascatan furu iquicuranaiton achicashon mau tsisumun sharafoshon rutunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Ascan mau ifo oshon nan fimi cushumisifo ato ahuusca huashquimun? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Cumanifo, —Nan yora chacafo rutui atohuun ramapaitama nanonfo. Ascashon ahuun mau futsafo cushumani cushusharashononfo. Nanfoan man fimicun cashcu futsa mau ifo inanonfo, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús afanan ato yoiqui isca huani, —¿Diosin tsain cununi cuscan man man oinmisimamun? Isca huaquin cununi, “Pushu yonomisifoan pushu quishi shara potanifo. ‘Nan sharamaran’ ishon potafiafo pushu ifoan afanan fiini nanhuunoashu pushu mutsisipa inon.” Nanscarifiai niaifofoan Diospan facuhuunoa isca huaqui yoishquicani, “Nacai ahuama. Sharamaran,” ishon yoiqui potashcani. Ascafia Upa Diosin ahuun facu catoan ahuunoashu nantifi ahuun yorafo nipanonfo. Ascacun non yoitiro “Diosin Furunhuunshon aca cuscan fasi shararan,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ascacun Diosin maton niaifocoin ipai ahuun yorafo ato iquifai ato iquipacushquin. Ascafia man Dios nicacasmaiton futsafo catonshquin a fu ipanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Unfin nan pushu quishi cuscaraqui. Futsafoan uhuunoa cayacafi tapimana cuscan icoinra huayamashu funocoinshcani. Un atoqui sinaqui omitsiscapanacafo muran un ato potashquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ascaiton nicacani Israelifoan aton niaifofo futan Fariseofoan tapinifo atohuunoa Jesús yoiaiton. Nanfoan icoinra huafomahuunoa ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ascano ahuun yoinannifo, —¿Ahuuscashomain non Jesús ato achimanan ranushumuaton rutunon? —ishon shafatifi shinannifo. Ascafiaifoanno yorafoan yoinifo Jesús Diospan tsain yoimisiran ishon ahuunoa yoinifo. Ascacun na yorafoan yoiaifo cuscan tapinifo niaifofo yafi Fariseofoan yorafoqui musucaquin Jesús achimatai inifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Afanan Jesús ato yoiqui ahuara futsa ato tapimanon isca huani, —Upa Diosin niaifoan ahuun yorafo iquinaimain ahuu cuscaraquin un mato yoinon. Ua nicacahuun. Niaifoan ahuun facu ainfo fiaino ato chanihuani ichananshon ato futan pifain atofu fasi unimashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ascano man itisharashon ahuun oinmatifo nichini nan ato chani huaifo ato ihuitanonfo. Ascafiacai tsoan opainima. Fucasmarocon anifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ascatan afanan oinmati futsafori nichiqui yoini, “Ato yoitacahuun. ‘Uhuun facu ainfo fiaino mun tushu itishara huaaquin. Moi rafu rutufain yoina shoa sharari un rutuaqui pii funonfo.’ Nannori ato yoitacahuun,” ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ascano focashon ato yoifiafo afanan fucasmanifo. Atirifi aton mau ari fonifo, pashaifocani. Atirifiri ato inanmitsati ari fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ascan atiri nanno nituafoan niaifoan ahuun oinmatifo achicashon ato sutufain atirifi ato rutucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ascano ahuun oinmatifohuunoa nicai niaifo fasi sinacoinquin ahuun ranushumuafo nichini a rutumitsamisifo ato rutuqui cuyofain aton pushufo coanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Asca huatan niaifoan ahuun oinmati futsafo yoini, “Uhuun facu ainfo fiaino un tushu ichapa itishara huaa ato futan piishquin. Ascafia futamarocon fasi chaca huafo. Asca huashucai afanan futirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ascacun nan fai uhuapafo nanno nan yora ichapa fotirofo ano fotacahuun. Ratoran futsafo fuchicashon ato yoicahuun Funonfo,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ato asca huaino focashon nan fai uhuapafo anoa ratoran futsafo fuchicashon ato ihuunifo. Yora sharafo ihuufain yora chacafori ihuunifo. Ascano nan niaifoan ahuun facun ainfo fiai pushu muran yorahuanrasi fospicoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ascatan niaifo pushu muran iquini nantifi fuafo ato oinpai. Ascashon oian nantififain sahuuti shara sahuuafo ini. Niaifoan ahuun facu ainfo fiaino sahuuti funa sharacoin ato sahuumani. Ascafiaquin oian nocofunu futsan sahuuti shuni sahuua niaifoan fuchini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Fuchishon yoiqui isca huani, “Ahuuscai sahuuti sharacoin un ato sahuumana cuscan min sahuuamamun. ¿Ahuuscai ascara min iquiamun?” ishon yocafiainocai nan nocofunu pusinima. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ascaiton niaifoan ahuun oinmatifo yononi, “Nan nocofunu munushfain onushushon faquish muran potacahuun. Nannoashu uaicaifoanno omitsiscapashanon,” ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nanscarifiai Upa Diosin yora ichapa cuna a icano funonfo. Nan ahuun facu noiaifosi afu ipanacafo. Ascafia Upa Diosin fustirasi ato catoin nan icoinra huafosi afu ipashanonfo, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ascatan Jesús ato yoiai cuscan nicacani Fariseofo Dios fu tsainti pushu murannoashu chifi focanashu yoinannifo, —Non Jesús ahuara yocanon. Noco amaquiri cumaquin chaca huaiton non cunu muran iquimanon, —icashu ahuun yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ascashon Herodes ahuun tanamisifo yafi atohuunshon tapimisifori Jesusqui nichinifo cucun huaquin yocatanonfo. Ascano focashon yocaqui isca huanifo, —Tapimamisiton, man non tapian min icocoin fusti noco yoifafainmisi. Upa Diosin noco amapaiyai cuscan nannoricoin min noco cayacafi yoimisi. Mincai ahuara yoipai ranomisimari. Nan min noco yoiai cuscan cayacafi min yoimisi. Ahuaricai min fomamisima. Yora ahuaton cunama min yoimisi cuscan huaquin niaifofori min yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ascacufin min shinain cuscari noco tapimahuu. ¿Nan Romanonfoan aton niaifo Cesari pui inanfo cuscan norifi non inantiromun? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nan fuparamitsamisifoan cucun huaquin yoiaifo cuscan onanshon Jesús ato yoini, —Fuparamitsamisifoan manfin ua amaquiri cumamapaiquin ranushumuafoan ua achicashon ua cunu muran iquimanonfo, —ishon ato yoitan. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Toro ua ismacahuun. Nan man ahuunshon niaifo inanmisi, —ato huaiton. Toro fushonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ascashon Jesús ato yocani, —¿Tsoa ointsa torohuun nuamun? ¿Tsoan ahuun anuri nuamun? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Niaifo Cesarinnaran, —huaifoan. —Ascan Cesarinacun nan inancahuun. Ascan Diosinacun Diosiri inancahuun, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nicacani fasi mustairicatan yoinifo, —Jesús yoiai cuscacai tsoan tafitiromaran, —icashu afi ranan yoinannifo. Ascatan amaquinoashu pashcafaini fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ascano nan shafatari Saduceofo Jesusqui funifo. Nanfoan shinanquin isca huamisifo, —Yora naashucai afanan funinacamaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ascan nanfo Jesusqui fucashon yocanifo, —Tapimamisiton, noco shuni Moisés noco cunushoqui isca huani, “Nan ratoran futsa ahuin futan facu acashma naano afu nanua futsan ahuun facahua fitiro a futan facu aashqui,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Un mia yoinon. Siete nanupacuafohuunoa. Nanfo nocofu iyopaonifo. Aton iyoacoin ahuinyain tauni. Ascafiashon a futan facu acashma nani. Ascano chipocuton ahuun facahua fiini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ascashu arifi a futan facu acashma naani. Ascano chipocu futsari fiini. Arifi a futan facu acashma naani. Nanscasiai. Ascapacutan amaqui nai cuyonifo. Aqui facu ayamacaicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ascatan ahuun unutani ainfori naani. Facu nanuyamacai. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Ascan ratotocaimun nai muranshon nan yorafo naashu funiaifotian fiishquiquin nan fusti fipashquin amaqui nai cuyoafo? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús ato cumani, —Man man funoa. Mancai Diosin tsain tapiamafain ahuun yonoricai man tapiama. Ascashofin amaquiri man ua yoiiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Naacanashu funiafocai Dios icari nocotan afanan fianannacafoma. Nantifi Diospan oinmatifo afu nai muran icafo cuscara iishquicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Ascacun yora naashu funishquiaifohuunoa Diosicoinin mato cunushoni cuscan man man oinmisimun? ");
INSERT INTO mcdNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Isca huaquin Diosin yoini, “Unfin Abraham non Isaac non Jacob afoan aton Diosiquin,” ishon yoini. ¿Yora naashu afanan funiyamaino ahuuscashumun Dios fu itiroquin? Ascafia ascarama. Yora man naafianishaquin afanan nia nanfofin Dios fu itirofoquin. Ascacun Upa Diosifin aton Diosiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús Saduceofo yoiai cuscan nicacani mustairicatan yoinifo, —¿Ahuuscashomun iscara tsain noco yoiquin? Tsain sharacoin iquinaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ascano Jesús Saduceofo tsain shatumana nicacani Fariseofo afanan aqui funifo yocai fucani. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ascacun Moisés yononi cuscan tapicoian futsan Jesús amaquiri cumamapaiquin yocani, ");
INSERT INTO mcdNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—¿Tapimamisiton, Moisés Diosin yonoa cuscan cununi. Ascan nan ratocaimun fasi shara finacaiaquin? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús cumaqui isca huani, “Nocon Ifo Dios noiqui fasi mato ointi muranshon noifain fasi mato nomuranshori noifain mato shinanfo yashon fasi noihuu,” ishon Moisés cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Nan yononicaifi fasi shara finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Futsari nanscaracuana yonoqui isca huani, “Nan mifiri min musu huamuai cuscarifi aquin mia chaima icafori noihuu.” ");
INSERT INTO mcdNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nantifi Moisés yononi cuscan yafi Diosin tsain yoimisifoan yosipaonifo nan Diosin yononi rafuhuunoa cununifo. Dios yafi futsafo noicoinquifin nantifi Diosin yononi cuscacoin man aiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ascashu Fariseofo afu ichananfoan Jesús ato yocani, ");
INSERT INTO mcdNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Nan Diosin catonni Cristohuunoa ahuu cuscara man shinanmun? ¿Tsoan funacaimun? —ishon ato yocaiton. —David ahuun funaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ato yoini —¿Asca ahuuscai David Diospan Yoshin Sharahuunshon nan Diosin catonni yoiqui isca huanimun? ");
INSERT INTO mcdNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Upa Diosin uhuun Ifo Cristo yoini isca huaquin, ‘Minfin ufu niaifocoinquin. Mia noicasmaifoan min ato finoncoian. Un ato shatumashquin mia afanan ahuusca huatiroma. Min ato iquiniran,’ ” ishon Diosin yoini cuscan David cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Criston David Ifono ahuuscashucon ahuun funa itiromun? —ishon Jesús ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nicaquicai tsoan ahuashta cumatiro inima. Ascashu nantifi puusinifoma. Ascan anantiancai tsoan afanan Jesús ahuashta yocanima. Ato cayacafi cumaiton nicacanashu aqui ranonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Asca huatan Jesús afu rafuafo yafi nanno niafo yoini, ");
INSERT INTO mcdNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés cununi cuscan tapimamisifo futan Fariseofoan Moisés yononi cuscan mato tapimacani. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ascan mato tapimanaifo cuscan huacahuun. Ascafiashon nanfoan acai cuscan huayamacahuun. Nanfoan Moisés cununi cuscan mato tapimafiaquicai Moisés yononi cuscacoin acanima. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mato ahuara ihuucoin papimafiashocai aton mucuman ahuashta mupaicanima. Nanscarifiai Moisés yononi cuscan nantifi huacahuun. “Fustishta finonmayamacahuun,” ishon mato yonoafo. Moisés yononi cuscan fasi finonmafain mato huamacani. Ascano marifi apaifiaquicai man atiroma. Ascashu maton nomuran man omitsiscafiaitocai matohuun ramapaicanima. Mato yonomisifo cuscacai aafi acanima. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ascashon nanfoan acaifo cuscan futsafoan yoiqui isca huacani, “Nanfofin sharaquin,” ato huamapaicani. Diosin tsain fichiqui cunushon fumananqui nutafain ato sahuuti poyan ocuma rafu nutafain sahuuti chainipari sahuuafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ascatan picani ichananshu nan niaifoan ahuun tsaoti ano tsaoafo nantififain ato oinonfo. Nanscarifiai aton ichananti pushu anori shafacafi tsaotiofo. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ascashu nan yora ichaparasi anori fopaicani atohuunoa yoisharanonfo. Nanscafin apaicaniqui. “Tapimamisiton,” ato huaifoan nicapaicani. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ascacun “Tapimamisiton,” ato huayamacahuun. Nocon tapimamisifin fustiquin. Naan nocon Ifo Dios. Ascashufin man nantifi yorahuantananquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ascashori tsoa nuno mai anoa Upa huayamacahuun. Nan nocon Upacoinfi nai ari icaquin. Nan fusti non upa huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ascatan “Iforan” ato huayamacahuun. Nocon ifofin fustiquin. Nan nocon Upa Dios. Nan man Iforan huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ascatari nan man ratoran futsa niaifo ipaiyaifi nantifiton ato oinmati itiroquin ");
INSERT INTO mcdNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsoan nantifi finonpaifafaini naanfin Diosin ismashquiquin aacai ahuama. Ascan tsoa futsafoan aton oinmati cuscarashon ato shara huafafainai nanfin Upa Diosin chipo niaifocoin imashquiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ato asca huatan Jesús Moisés cununi cuscan tapimamisifo yafi Fariseofori yoiqui isca huani, —¡Ohua! Moisés cununi cuscan tapimamisifo futan Fariseofoan ua nicasharacahuun. Manfin fuparamitamisicoinfoquin. Upa Dios icano man yorafo iquimapaifiaquicai man ato iquimatiroma. Ascashu marificai man iquitiroma. Iquipaifiaifoan man ato catima huaa. Ascacun Diosin mato fasi onaintimaquin finacoinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ascashon man futsafo matohuunoa shinansharamapaifiai man fasi chacacoinfo. Ainfo tatuomafori parashon man pushu ato fian. Ascatan fasi chaicoinri man cufiriatiro matohuunoa shinansharanonfo. Ascafia manfin fasi fuparamitsamisicoinfoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ascashu man foanfafaitsia man shinain cuscan yorafori shinanmashquin. Ascaqui fusti fuchishon man icoinra huaa cuscan nanrifi man icoinra huama mato cuscara inon. Ascashon man futsa mato cuscara imano fasi chaca finacaia iiquin. Manfin fasi chacacoinfoquin. ¡Ohuashta! Nanrifi matofu omitsiscapanacafo muran cai. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ohua! Ascacun Diosin mato fasi onaintimai. Manfin nan fusho cuscarafofiashon man futsafo tapimapaiqui ahuuscashomain Dios tanatirofoquin. Ascan ato tapimapaifiaquicai marifi man tapiama. Ascashon futsafo man yoiqui isca huamisi, “Tsoan yoiqui isca huai, ‘Dios fu tsainti pushu ahuun anuhuunshon un mia yoia cuscan un mia ashonon,’ huafiashon chipo man shinan futsashon man yoi ‘Nanscanonquin,’ ishon. Ascafia nan Dios fu tsainti pushu murannoa orohuunshon un mia ashoiran futsa huashon. Nanscacoin huashohuun. Ascan nan non yoia cuscan huashoyamaino ahuara chaca finontiroran,” ishon man yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Asca nan icon. Manfin nan fushon futsa iyopaiyai cuscarafoquin. Maton mapo curushcoin. Mancai ahua tapiama. ¿Ascan rato shara finacaiamun Dios fu tsainti pushu murannoa oro iyamarai Dios fu tsainti pushucoin? Nan Dios fu tsainti pushuanofin Dios itiroquin. Ascan nancaifin shara finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ascashon marifi man yoiqui isca huamisi, “Tsoan yoiqui isca huai, ‘Nan cufiti camaqui ahuara coamisifohuunshon un mia yoia cuscan un mia ashonon,’ huafiashon chipo man shinan futsashon man yoi nanscanonquin ishon. Ascafia, ‘Nan cufiti camaqui un Dios ahuara inanhuunshon un mia yoia cuscan un mia ashoiran,’ futsa huashon nanscacoin huashocahuun. Ascan nan min yoia cuscan huashoyamaino ahuara chaca finontiroran,” ishon man yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Manfin nan fusho cuscarafoquin. Mancai cayacafi shinantiroma. ¿Ascan ratocaimun shara finacaiaquin? Nan cufiti camaqui ahuara man inan iyamarai nan cufiticoin. Man cufiahuunshon ina man coashonaino Diosin matoqui unimatiro. Ascafia nan cufiticaifin fasi shara finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ascashon Dios fu tsainti pushu murannoa cufitihuunshon futsa man yoiquifin nan cufiti camaqui ahuara man inan nancoin yoi cafisca man huaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nanscarafi aqui tsoan Dios fu tsainti pushuhuushon futsa ahuara yoiquifin nan Diosicoin yoi cafisca huaiquin. Nan muranmain Diosicun. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nanscarifi aqui tsoan Dios ica muranhuunshon futsa ahuara yoiquifin nan Diospan tsaotihuunshon yafi nan Dioscoinhuunshon man yoi cafisca huaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ohua! Moisés yononi cuscan tapimamisifo futan Fariseofoan manfin fuparamitsamisicoinfoquin. Ascacun Upa Diosin mato fasi onaintimashqui. Moisés yononi cuscan nantifi mato fanafo atirifi man Dios inanmisi. Man asca huafiaquicai ahuara shara finacaia man huamisima. Ascashucai man futsafohuun ramapaiyamacain atori man shara huacoianmisima. Mato yorafoan ahuara chaca finonfiacun man ato shara huatamarocon man ato potamisi. Ascan man futsafohuun ramapaicai ato shara huafain ahuara ahuuscarafiaino man ato potayamaino Diosin matoqui unimatiro. Ahuara futsafo Moisés yononi cuscan man huamisi cuscan man shara. Ascafia ahuara shara finacaiarocon huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ascafia manfin nan fusho cuscarafoquin. Fushocai oinsharatiroma yora iyoshqui. Nanscarifiai marificai man cayacafi shinantiroma yorafo tapimashquin. Motsa muran napun pacucun man nushfitiro aya shuashquima. Ascafia man nan ina uhuapa camello shuai cafisca huai. Asca huaquifin ahuarafoan yora imasharatiroma man shinanfafainiquin. Ascafiashon yorafo ahuara yopacoiainfo cuscacai man ato ashomisima. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ohua! Ascashufin man fuparamitsamisicoinfoquin. Maton cucho yafi purato fumancayan choca sharafiaquicai ocumuran man chocamisima fasi choshtacoin. Nanscarifiai man yorafo shinanmapai yorasharaforan mato huanonfo. Ascafia maton nomuranshocai man shinansharamisima. Man shinanchaca fustimisi. Ahuara fipaiqui futsa chaca huashon man fianmisi. Futsafo yopai cuscan atohuunoa shinantamarocon mafi man fipaiyai cuscan fusti man shinanfafaini. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseofoan mancai cayacafi shinansharamisima. Ascacun iquisi mato nomuran cayacafi shinansharacahuun isharashcaquin. Man ascaiton nantifiton ointirofo man yora sharacun. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ohuashta! Ascashufin man fuparamitsamisicoinfoquin. Mahua quini muran yorafo nacun mai huamisifo. Amuran yorafoan shao suyacoinfo. Nan ahuun fupoti toquirininhuan raishamisifo oshopa sharashta inon. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nanscarifiai futsafoan mato oinqui shinantirofo man yora shara ointsa man sharayamafiacun. Manfin fuparamitsamisicoinfoquin. Mato nomuranshon ahuara chacacoinfo man shinanmisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ohua! Moisés yononi cuscan tapimamisifo futan Fariseofoan. Manfin fasi fuparamitsamisicoinquin. Ascacufin Diosin mato onaintimaquin finacoinquin. Ascashon manfin mato shuni Dios tsain yoimisifo mai huanifo ano man ahuara toquiri onihuamisiqui ato shinanshquin. Ascashori maiafo manaon man charofo huamisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ascashon man yoimisi isca huaquin, “Nocon shunifoan Diosin tsain yoimisifo rutunifo cuscan nantian norifi niyoshocai non ato rutu cuanimaran,” ishon man yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ascan nan man yoia cuscan icon. Maton shunifo rutumistsamisifoan. Marifi man ato cuscaracoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nanfoan ato chaca huafafainqui ato rutunifo. Ascan marifi man ato cuscaraquin na Diosin matoqui nichiarifi man rutushquiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ascashu manfin rono cuscarafoquin. Rono paupaton facu cuscarafo. Diosin yoini cuscan nan omitsiscapanacafo muran marifi man iquishcani. Tsoancai mato nitun huatiroma. Marifi nanno man catio. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ascacun un afanan Diosin tsain yoimisifo yafi Diosin tsainhuunshon cayacafi shinansharamisifo non ahuun tsain tapimamisifori un matoqui nichishqui. Nanforifi man ato rutushquin. Futsan ihui coyan iquinanqui man mastashquin nanon. Ascashon atirifi maton ichananti pushu muranshon man fichi cunoqui tuchiaton man coshashquin. Ascaquin man ato omitsisca huai nan pushufoti cafoquin man ato omitsisca huafoicaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ascashofin nantifi Dios icoinra huafo rutunifoqui. Nan Abel shara rutuqui tau huafain ahuun unutaqui nan Zacarías Berequiaspan facu rutunifo. Nanfin Dios fu tsainti pushu muranshon. Anoshon cufiti chaimashon man rutunifo. Ascan manfin nantifi nan rutunifo cuscan marifi man rutui cafisca huaiquin. Ascacun Diosin atohuunshon mato omitsisca huaqui finacoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ascacun un mato icon yoi. Nantifi Diospan yorafo chaca huapaonifo cuscan natian man niyoano atohuunshon mato omitsisca huaqui finacoin. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ohua! Jerusalén ano icafoan. Manfin Diosin tsain yoimisifo rutufain nan Diosin matoqui nichian futsafori man toquirinin ato tsacaqui nanonfo. ¡Ohua! Tacaranun ahuun facufo ahuun pui naman onutiro cuscan huaquin un mato yorafoya cushupaifia mancaifin ua nicacasmamisiquin. Manricai uqui fumisima un mato cushunon. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ascan natiancai tsoan mato cushuima. Diosiricai afanan mato cushuima. ");
INSERT INTO mcdNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ascacucai man ua afanan oinnacama nan Diosin matoqui nichian un nai murannoashu oaitian. Man yoiqui isca huaino, “Dios nocoqui nichian fasi shara finacaia. Upa Diosin a shara huapanacaran,” ishon man uhuunoa yoishquin, —ishon Jesús ato yoini ahuunoa. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ascatan Jesús Dios fu tsainti pushu murannoashu caiton non afu rafuafoan yoini, —Ifon, oinpon. Nocon Dios fu tsainti pushu fasi sharashtacoinran, —non huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Noco cumani, —Ai. Nan icon. Natian Dios fu tsainti pushu toquiri putsamuashu cunuacua sharashtacoin. Ascafiashu nan man oiain chipo paoincanocai afanan rato toquirishta tushushquima, putsamushquima. Nantifi paoinquin cuyocoinshquiran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ascatan machi Olivo ano mapufaintan Jesús tsaoni tsoa futsa anomano non afu rafuafoan yocaqui isca huani, —¿Nan min yoiai cuscan ahuutian ishquimun? ¿Ahuuscashomun non tapitiroquin nantifi cuyoaitian min afanan oshquiai? Noco yoihuu, —non huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús noco cumani, —Oinfain mato paranonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yora ichapafoan “Un Cristoran,” ishon mato parapaishcani. Ascashon yora ichapafori parashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ascaino mani futsafo ya futsafo rutunainfoan man nicashquin. Ascara nicacani ratuyamacahuun. Un mato yoimisi cuscan nanscacoin aiquin. Ascafia nantifi cuyoaitian icataima. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mai futsa ariafo fu futsafo ya rutunainfoanno mani futsafori mani futsafo ya rutunanshquicani. Ascaino mai futsafoanri yora tushuomafo icaifoanno. Mai futsafo ari fasi mai nayanaiyaishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nanscaifin omitsiscai taushcaniquin. Ascafia chipo fasi finacai omitsiscashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ascano mato achicashon omitsisca huaquin mato rutushcani. Uhuunshon manifotiton mato noicasmashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ascaino nantianri atirifi yorafoan ua cachiquiri huashquicani afanancai tsoan ua icoinra huashquicanima. Nanfo afiranan achinantananshcani noincasmatanancani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ascaino nan fuparamitsamisifoan yoiqui isca huashcani, “Unfin Diospan tsain yoimisiquin,” ishon mato yoishcani. Afocai Diosin tsain yoimisiyamafiashon yora ichapafo ato icoinra huamashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ascaifoanno fasi yora chaca huaquin finacoinshcani. Ascashocai afanan atirifi yorafoan Diosi noishcanima. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ascafia nan omitsisca huafiaifoan tsoan ua cachiquiri huatama tunufain uhuun tsain tanasharacun un cushusharatiro Uhuun Upa Diosin icano afu ipasharanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ascano nan tsain shara Diosin nantifi yorafo iquinai cuscan manifoti uhuun tsain yoimisifoan yoiaitian un afanan oshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Ascacun Daniel nan Diosin tsain yoimisiton inon pacoai cuscan cunuqui isca huani, “Dios fu tsainti pushu muran ahuara fasi chacacoinfo futsafoan huanonpacoinran,” ishon cununi. Ascacun nan tapicahuun. Daniel cununi cuscacoin aiton oin nan Judea ano icafoan machi ari ichoriscatacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ascan tsoa pushu fomancayan niashucai afanan ahuun pushu muran iquitiroma ahuara fiishquin. Ascatama ichoriscatahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nanscarifiai tsoacai mau ano yonofiai afanan ahuun pushu ano nasotiroma ahuun sahuuti fiishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ascacun ohua ainfo nan facu nanuafo yafi aton facu yomumishti chocho acaifo omitsiscaashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ascacun Upa Dios cuficahuun nan omitsiscaitian oipacutian yafi tunutitianri ascanonma. Ascan nantian ascayamaino man ichoima. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nan omitsiscaitiancai tsoan ascara oinyomisima cuscara fasi yorafo omitsiscai finacoinshcani. Diosin yora onihuaquin tau huani chaincai tsoa omitsiscai ascayomisima. Ascashucai tsoari afanan omitsiscai ascanacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ascashu nan omitsiscaifotian nantifi yorafo cuyocuashquin. Diosin ahuun yorafo nan catoanfo atohuun ramapaiqui omitsiscaifotian ato shatumariscashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","25","Ascacun ua nicasharacahuun. Omitsiscaifotiancai icataima iquisi un mato yoiyoi. Nan omitsiscaifotianri nan fuparamitsamisifo fucani. Fucashon yoiqui isca huacani, “Un Cristoran,” ishon yoi yamarai “Un Diospan tsain yoimisiran,” ishon nanfoan yoishcani. Ascashon nanfoanri Satanashuunshon tsoan atiroma cuscara mato ismaquin mato parapaishcani. Ascan Diosin nan catoanfo ato cushuyamaino nanfoanri nan fuparamitsamisifo icoinra huaacuana. Ascaino nantian mato yoishcani, “¡Oincapon! Nanfin nocon Cristoqui,” ishon yoi iyamarai, “Nanno chaimashta Cristo nocoqui oaran,” ishon yoiaifoan ato icoinra huayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ascashon nanfoanri yoicani, “Cristo tsoan istaipama ano nocoaran,” ishon mato yoiaifoanno ari foyamacahuun. Nanscarifi aquin mato yoishcani, “Criston nan pushu cunu muran iquiaran,” ishon mato yoiaifoan ato icoinra huayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Uficoin un oaiton man ua shafacafi oinshquin. Canan facaicaiton shafacafi nantio non oinriscatatiro. Nanscarifiai unfin Diospan Facuquin un afanan oaiton nantifi yorafoan ua shafacafi oinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ahuara naa nanno cotocotofo nocoriscatiro. Nanscarifiai un nocoaitian ua tanamisifo uqui furiscashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ascashu nan omitsiscaifo cuscan anaitiano fari afanan chashayamafain oshuricai afanan chashashquima faquishicoin iishquin. Ascaino fishifori nai ariashu pacui futsushquin. Nantifi nai murannoafori nayanaiyaishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ascashon ahuarafo nai arishon un ismai cuscacoin aiton tapitirofo un afanan mai ano nasoai cuscan nantifi yorafoan tapinonfo. Un Diospan facushon un nantifi iquinai cuscan. Un nai murannoashu coin camaqui fotoaiton oincani manifoti nan icoinra huamafo fasi ratucani uaishcani. Uhuun curushhuunoashu un fotoaiton oincani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ascaino nantianri uhuun oinmatifo ufu nai muran icafo un nichishquin aton manuti fasi curushcai chaan chaan acaino uhuun yorafo manifoti anoafo yafi nai murannoafori uqui fushcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ascacun un mato fana huiguerahuunoa ahuara futsa yoinon. Ua nicasharacahuun. Huiguera pui risquisi futsuaiton man tapitiro faritian itiro cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nanscarifiai nan un mato yoiai cuscacoin aiton tapicahuun mun oti chaima nanscacoin aiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ascacun un mato icon yoi. Ahuarafo un mato yoiai cuscacoin aiton nataishoma oinyocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ascaino nai yafi mai cuyoshquin. Uhuun tsain cayacafi iconcoin fiananancai apanacama. Un mato yoiai cuscacoin aashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ascafia ahuutiaran un nai ariashu afanan fotoainocai tsoan tapiama. Diosin oinmati afu icafoanricai tapiafoma. Urifi uhuun Upa Diosin facufiashocai un tapiama. Nan uhuun Upa Diosin fustitofin tapiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noco shuni Noé niyoano inifo cuscacoinrifiai afanan un oaitian nanscarifi ashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ascano nantian tsoan Dios shinantama pii sharafain ayafain fianansharacainaifoanno. Fai tahuan noconi. Nanscasi ariaifoanno Noé ahuun shashohuan muran iquini. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ascashu iquifiaitocai tsoan tapinima fai tahuan nocoai. Ascashu nantifi yorafo asai futsunifo. Nanscacoinrifi aashcani un afanan oaitian. Ua shinantama afi apaiyaifo cuscasi huariaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ascaino nantianri nocofunu rafu mau ano yonocani futsa uari cai yamariscatanaino. Futsa nitushquin omitsiscapanacafo muran caashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nanscarifiaiyainfon rafu nanincani. Futsa uari cai yamariscatanaino futsa nitushquin omitsiscapashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ascacun itisharacahuun. Un maton ifofiacucai marifi man tapiama ahuutiamain un afanan matoqui oshquicain. Un mato yoimisi cuscan nanscacoin acahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ua nicasharacahuun tapishcaquin. Pushu ifoan iquisi itisharashon yomutso yamu ahuuscaraino ahuun pushu muran iquiai tapishocai iquimatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nanscarifiai marifi itisharacahuun. “Iscaino nocon Ifo oimaran,” ishon shinanyamacahuun. Ahuuscara atanaino un matoqui nocoriscaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Man tapinon un mato yoi ahuu cuscaramain oinmati shara itiroquin. Niaifocoin mai futsa ari caquin niaifo patashari yoitiro isca huaquin, “Uhuun oinmati futsafo ato tushu shafatifi inanhuun. Nanticoin rafu ato pashcananshara huahuun. Ascashon ua ato cushusharashohuun,” huafaini catiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ascatan niaifocoin afanan nocoshon oian ahuun niaifo patashari nan yoia cuscacoin aano fasi aqui unimacointiro. Ascashon naan shara huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ascacun un mato icon yoi. Nan niaifoan ahuun oinmati yoi, “¡Aicho! Natian nantifi uhuunafo mian cushusharashotiroran,” ishon yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ascafia niaifo patashari chacapan ahuun nomuran shinanquin isca huatiro, “Uhuun ifo funa nasoimaran,” ishon shinanquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oinmati futsafo nantifi sutuqui futsatiro. Ascashon shafatifi nan paunmisifo ya pauncain monocai. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ascashon shinantiro isca huaquin, “Natiancai uhuun niaifo oimaran,” ifiaino samamashta nocoriscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ascashon niaifoan nan niaifo patashari fasi onaintimai. Asca huatan ahuun oinmati futsafo yonoqui isca huai, “Nan omitsiscapanacafo muran fuparamitsamisifo ano nan chaca potacahuun,” ishon ato yoishquin. Ascan nannoashu uaiqui omitsiscapanaca. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ascatan diez shomayafohuunoa un mato yoi un oaitian ahuu cuscaramainquin un mato tapimashquin. Ascatan nan diez nan nocofunun rama ainfo fiai manafo atofu fuusishcaquin. Ascafia nan nocofunun ahuun ahuin fiicashu nasoataimacai tsoa afi ranan fuusi tauafoma. Nan diez shomayafoan iquisi lamparina foafo. Nocofunu manai focani. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nan mucu fustiti shomayafain tsoancai cayacafi shinansharayamafain itisharafoma. Asca nan mucu fustiti futsafoan shinansharafain iquisi itisharafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nan shinansharaimafoancai aton lamparina fofiaquin tsoan kerosene foama. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ascafia nan shinansharafain itisharafoan aton lamparina fofain iquisi keroseneri foafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ascafia nan nocofunun ahuun ahuin fiaicai funa nocoyamaino nan shomayafoan manariacani fasi oshapaicoincani oshafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ascashu oshafoanno futsan yamu nacucahuanaino oi ashcafinin ato cuna, “Nan ainfo fiicaitan man oiquin. Moinifoancahuun. Non ihui sharanon,” ato huaa. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ascaino shomayafo moinifoan aton lamparinafo otaqui futsafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ascashon nan mucu fustiti shinansharaimafoan nan itisharafo yocani “Maton kerosene ichapamashta noco inancahuun. Man nocon lamparina nocaiquin,” ishon ato yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nan itisharafoan ato cumani, “Ma. Noconariraca itiroma. Ascan kerosene inanmitsafo ari fotacahuun fiishcaquin,” ato huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ascaino kerosene fii focani foaifoanno nan ahuun ahuin fiai nocotan iquicainaino nan shomaya itisharafo afu pushu muran iquiafo fuusishcaquin. Ascashon caincaiti fupoafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ascaino chipo shomaya futsafo nococashon yoiafo, “Ifon. Noco fupushohuun non iquinon,” huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Un mato fupushotiroma. Icon un mato yoi. Uncai mato oinmisima,” ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nanscarifiai ahuutiaran un afanan matoqui oshquicain tsoan tapiama. Ascacun itisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Afanan un mato ahuara futsahuunoa yoi. Nocofunu ahuun pushu anoashu chai caquin ahuun oinmatifo cunashon yoiquin isca huani, “Uhuun pui ua cushusharashocahuun,” ato huafaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ascashon ahuun oinmati rafu non fusti ato pui inanni. Futsa cinco mil pui inanfain futsa dos mil pui inanfain futsari mil inanni. Nan tapiafo cuscan ato inanpacua. Ascan ato inantan mai futsari cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Niaifoan caquin nan cinco mil inan cuscahuunshon samamashta ahuarafo fiashu afanan inanmitsashon ahuun rafanan cinco mil fia. Asca huaquin diez mil man fia. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nanscarifi aqui nan pui dos mil fiaton afanan dos mil fia. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ascan nan oinmati mil pui fusti fiaton funocasmaquin mai poquishon amuran ahuun niaifo pui huashoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ascashu fari ranan finontan afanan niaifo ahuun pushu ano nasoni. Nasoshon nan rafu non fusti ahuun oinmati ato cuna ahuutimain fishoafoquin ato yocashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ascano nan cinco mil pui inanniton yoiqui isca huani, “Niaifon, mian cinco mil pui inanni. Ascafia mun mia natian afanan cinco mil fishoan. Ascan oinpon. Naquian,” ishon inanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ascaiton ahuun niaifoan yoini, “¡Aicho! Mian fasi shara huaa. Un mia yoia cuscacoin min huaa. Un mia ichapama inanfia ahuunshon min yonocoin shara. Ascacun nan un aya cuscan mian cushusharashotiro. Un unimai cuscan mirifi nanscarifiai min ufu unimatiro. Ascacun iquiyohuu,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ascano nan dos mil pui inanniton arifi yoiqui isca huani, “Niaifon, Mian dos mil pui inanni. Ascafia mun mia natian afanan dos mil fishoan. Ascan oinpon. Naquian,” ishon inanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ascaiton nanrifi ahuun niaifoan yoini, “¡Aicho! Mian fasi shara huaa. Un mia yoia cuscacoin min huaa. Un mia ichapama inanfia ahuunshon min yonocoin shara. Ascacun nan un aya cuscan mian cushusharashotiro. Un unimai cuscan mirifi nanscarifiai min ufu unimatiro. Ascacun iquiyohuu,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ascan nan mil pui inanniton arifi yoiqui isca huani, “Niaifo, mun tapian mincai tsoa shinainma. Minricai nocohuun ramapaima. Non mia yonoshofiaitocai min noco ahua inantiroma. Mina fusti itiroran. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ascacun un ratuqui min ua inan cuscahuunshon ahuarafo fipaifiai un funotiroracati, ishon un shinan. Ascacun nan mian inan cuscan un mai muran onua. Ascan natian mun mia fishoan. Oinpon. Naquian,” huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ahuun niaifoan cumani, “Min fasi chacacoin. Minfin oinmati shanishuniquin. ¿Min shinanmun un futsafo shinainmaquin? ¿Uaraca futsafoan yonoshonaiton un ato ahua inanma? ");
INSERT INTO mcdNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Ascan nannori shinanfiaquin ahuuscaquin mai muran min pui huamun? Asca huatamarocon nan pui huamisifoanno min huacun un nocoshon paratamari un fiicuanaran,” ishon niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ascashon ahuun niaifo patashari yononi, “Nan oinmati shanishuni ahuun pui fianhuun futsa nan cinco mil aya inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ascano nan ua icoinra huacoinnafin un fasi paratamacoin inainquin. Ascan nan ua icoinra huama ichapama aya cuscan futsan fiain. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ascacun nan oinmati ahua tapiama chaca faquish muran potacahuun. Nannoashu fasi omitsiscai fasi uainon,” ishon niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ascacun un mato afanan yoi. Unfi Dios ariashu mai ano fotoniquin. Ascashu un afanan oaitian nantififain aton niaifocoin un iishqui. Un Diospan Facucoincun nantififain ua oinshcani. Uhuun oinmatifo ufu nai muran icafoya un oaiton. Nantianri un ato yoishquin ratofomain Diospan yorafo iyamarai ahuun yorafomaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ascashu nantifi manifotifi uqui fushcani. Chashoan cushumisiton ahuun chashoanfo yafi nan chashoan ointsafo aton anu cabra aton ichanan huai. Nan chashoanfosi tiri futsa huafain nan cabrafori tiri futsa huai. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ascashon ahuun mumihuuri chashoanfo huafain ahuun mushquihuuri cabrafo huai. Nanscarifiai ua tanamisifo un tiri futsa huafain nan ua icoinra huamafo un tiri futsa huai. Ua tanamisifo uhuun mumihuuri huafain uhuun mushquihuuri nan ua icoinra huamafo ato huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ascatan un Niaifoshon nan ua tanamisifo un yoiqui isca huashquin, “Uqui fucahuun. Uhuun Upa Diosin mato unimamanon. Nan mai onihuaitian matohuunoa shinanquin isca huani, ‘Un icano un ato iquimanonpacoi uhuun yorafo inonfo. Uhuunafori atona inonpacoiran,’ ishon Upa Diosin shinanyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Man ua shara huamisi. Ascacun uhuun Upa Diosiri mato shara huashquin. Un fonaicaiton man ua pimamisi. Un nomiaiton man ua ayamamisi. Un matoqui nocoaiton ua oinyamafiamisishaquin man ua yoiqui isca huamisi, ‘Uhuun pushu muran iquiyohuu. Un mia pimafain min nuno uhuun pushu muran oshatiro.’ ");
INSERT INTO mcdNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Un sahuutiromacuri man ua sahuuti sahuumani. Un isinincaitori man ua cushusharamisi. Ua cunu muran iquimanafoanno man ua oin camisiran,” ishon ua tanamisifo un yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ascacun ua tanamisisharafo uhuun Upa Diosin aton chaca soashona. Nanfoan ua cumacaquin isca huashcani, “¿Ifon, ahuutian non mia oinmisimun min fonaincaiton non mia pimafain min nomiaitori non mia ayamamisi? ");
INSERT INTO mcdNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ahuutianritsi min nocoqui nocoaiton non mia oinyamafiamisishaquin non mia nocon pushu muran iquimafain min sahuutiromacuri non mia sahuuti sahuumamisi? ");
INSERT INTO mcdNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ascan ahuutianritsi mia cunu muran iquimanafoan non mia oincani?” ishon ua yoishcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ascaifoan un aton niaifoan un ato yoiqui isca huashquin, “Uhuun yorafo nan ua icoinra huafo futsafoan atohuunoa yoiqui isca huamisi ‘Nancai ahuamaran,’ ishon man yoimisi. Asca nan uhuun yora ahuamafiashu man ato shara huamisi cuscafin nan uari shara huai cafisca man ato huamisiquin,” ishon un ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Ascashon nan ua icoinra huamafo tiri futsa niafoan un ato yoiqui isca huashquin, “Manfin ua chaca huamisiquin. Un fonainfiaitocai man ua pimamisima. Un nomiaitoricai man ua ahuara ayamamisima. Un matoqui nocofiaitocai ua oinyamafiamisishaquin man ua pimayamafain un sahuutiromafiacuri man ua sahuumamisima. Un isinincaitoricai man ua cushumisima. Ua cunu muran iquimanafoanno cai man ua oincamisima. Ascacun umaquinoashu fotacahuun. Nan yoshin chaca Satanás yafi afu yoshin chaca futsafo Upa Diosin ato chi urumanhuan itishara huashoan nannori mato potai. Nannoashu nanfoya man omitsiscapashquin,” ishon un ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nan ua icoinra huamafoan ua cumaquin isca huashcani, “¿Ifon, ahuutiamun non mia oinmisiquin min fonaincaiton non mia pimayamafain min nomiaiton non mia ayamamisima? ¿Ahuutianmun min nocoqui nocofiaiton oinyamafiamisishaquin non mia cushusharayamafain min sahuutiromacun non mia sahuumamisima? ¿Ahuutianritsi min isinincaiton mia cushuyamafain mia cunu muran iquimafiafo non mia oin camisimamun?” ishon ua yocashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ascaiton un ato cumaquin isca huashquin, “Un mato icon yoinon. Nan ua icoinra hua futsafo man yoimisi isca huaquin, ‘Nancai ahuamaran,’ ishon atohuunoa man yoimisi. Ato asca huaquifin nan ua shara huaima cafisca man huamisiquin,” ishon un ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Un ato nannori yoiaino umaquinoashu omitsiscapanacafo muran foshcani. Ascaino nan ua icoinra huafo uhuun Upa Diosin aton chaca soashonafo un icano ufu foshcani ufu ipashcaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ascano noco yoiqui anaititan Jesús afanan afu rafuafosi tsain futsa noco yoiqui isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Man man tapian nocon fusiti shafa man nococuana. Diosin ahuun oinmati nan afu ica yonoa Egipciofoan aton furun iyoafofosi rutuqui futsani. Ascafiaquicai nocon shunifoan aton furun iyoafofo finonmani ato rutuquima. Nan non shinanmisi nocon fusiti osha rafutan iqui. Ascan nantianri ua ato achimacani ua mastanonfo, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ascan nantianri nocon yorafohuunshon Dios cufimisi niaifofo futan Moisés cununi cuscan tapimamisifo non Dios fu tsainti pushu cushumisifo Caifás pushu ano ichanancani. Nan Caifás nocon yorafohuunshon Dios cufimisi niaifocoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ascashu ichanancashon shinannifo, —¿Ahuuscashomain non Jesús achinoanti rutushquin? —ishon ahuara chanishtahuunshon rutupaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ascacun yoinifo, —Fusititiancai non achitiroma yorafo fasi mucacani nocoqui sinatiroforan, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ascatan non Jesús fu Betania ano cani. Caashu Simón pushu muran non iquini. Nan Simón nami tocoi futsua ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús nannoshon noco futan piaino ainfo ininti tsomashu oni aqui ocashquin. Nan moticanun ahuun anu alabastro. Amuran ahuun ininti fasi paratamacoin ahuun pui nuua. Ascashon ainfoan Jesús ahuun mapoqui ininti ocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ocaiton oin non afu rafuafo ainfoqui non sinacoinqui yoini, —¿Ahuuscaimun nan ininti fasi paratamacoin ahuun pui nuua na ainfoan ocaiqui? ");
INSERT INTO mcdNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nan ininti ocatama inanmitsashon ahuun rafanan pui fishon nan yora ahuuomafo inanshara icuanaran, —icashu non yoinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ascaiton non yoiai cuscan Jesús onanshon noco yoini, —¿Ahuuscaimun na ainfoqui man tsain chipuicain? Uafin nanton fasi shara huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Manfin yora ahuuomafo fu ipanacaquin. Ratoran shafatan man ato ahuara shara huashotiro. Ascafia uncai nuno mai ano matofu ipanacama. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ascan nan ainfoanfin uqui ininti ocaquin. Nan yora maiamamaquin ininti ocamisifo cuscan un nataiyamafiaiton na ainfoan ua shinanquin uqui ininti oca. Uhuun caya iquisi itishara huapai ua mai huashquiaifo cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ascacun un mato icon yoi. Nan tsain shara uhuunoa manifotiton yoishcani. Nan ainfoan ua rama aca cuscari yoishcani. Ascashon ua shara huaa cuscan ahuunoa shinanpacushcaniran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Noco nannori Jesús yoaino non afu rafuafo doce futsan ahuun anu Judas Iscariote nocon yorafohuunshon Dios cufimisi niaifofo ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ascacaini cashon ato yoiqui isca huani, —¿Un mato Jesús achimacun ahuuti pui man ua inantiromun? —ishon ato yocaiton. Cumanifo, —Non mia treinta toro oshopafo inantiroran, —ishon yoinifo. Asca huatan inannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ascano nantian Judaspan ahuun nomuran shinanqui tau huani, —¿Ahuuscashomain un ato Jesús achimanoanti? —ishon shinanriani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ascano noco fusiti shafan man nocoano nan shafa misi farashati maisi non pimisi. Nantian non afu rafuafo Jesusqui cashon non yocani, —Ifo, na shafan nocon fuusititian. Nan nocon shunifoan ato facu iyoafofo Diospan nai oinmati finonmani ato rutuquima nan non shinanmisi. ¿Ascan rani min noco nichipaimun non mia itishara huashonon no futan anoshon piishquin? —ishon non yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús noco cumani, —Jerusalén ano fotacahuun. Nanno nocofunu futsaqui nocoshon yoiqui isca huacahuun. “Nocon tapimamisiton mia tsain fomaqui isca huaa, ‘Un naitian man nocoti chaimashtaqui. Nocon fusititian non min pushu muranshon piiran,’ ishon noco Jesús yoiaran,” —ishon yoitacahuun noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ascashu nan noco yoia cuscacoin huaquin cunu muran non itishara huani. Nannoshori chashoanun facu non pichani piishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Man fari caino non afu rafuafoya Jesús sapa ano tsaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nannoshon non piaiton Jesús noco yoini, —Un mato icon yoi. Nan ratoran futsan man ua ato achimairan, —noco huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nicai non pusinima. Ascashon non yocani, —¿Umun, Ifon? —ishon nantifiton non yocapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ascaiton noco yoini, —Nan man ufutan taso murannoa misi pocotan piaitofin man ua ato achimaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ascan Upa Diosin tsain inon pacoai uhuunoa cununi cuscacoinfin un naicain. Ascafia nan nocofunun ua ato achimanai cainyamanifin shara icuanaquin, —ishon Jesús noco yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nicaquin Judas, nan ato achimaiton Jesús yocani, —¿Umun, Ifon? —huaiton. —Aifain. Minfiqui, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ascashon piaifoanno Jesús misi finifoantan iquisi apa Diosin cufiyoni —¡Aicho! Upa, min noco cushusharafafainiran, —huatan noco yoini, —Na uhuun caya cuscara. Picahuun, —ishon torupacushon nocoti inanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ascashon cucho finifoan afanan Apa cufini, —¡Aicho! Upa, min noco cushushararan, —huatan cuchoqui fimi unu manuta noco inanqui yoini. —Nantififain na ayacucahuun, —noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Asca huatan noco yoini, —Naafin uhuun imi cuscaraquin. Uhuun imi focain un nai. Nantifi yorafoan chaca huamisihuunoashu un nai aton chaca soashonon. Un ascano yora ichapafo Diosin potapacunonma. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ascacun un mato icon yoi. Uncai funa afanan mato futan ayaima. Nan uhuun Upa Diosin niaifoan nantifi iquinaitian un afanan maton futan ayashquin, —noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ascano man ahuun tsain yoiqui anaititan Diosin tsain non fanainni. Ascatan machi ahuun anu Olivo ano non cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ascashon afanan noco yoini, —Na yamutafin nantififain man ua potafaini ichoi caiquin. Diosin tsain cununi isca huaquin, “Unfi chashoanfo cushumisi rutuicain. Ascaino chashoanfo ichoi futsucaniran,” icashu cununi. Nanscarifiai ua rutuaifoanno na yamutan man uhuunoashu ratufaini ichoicai. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ascafia un funiashu Galilea ano un cai tauicai. Ascano man uqui chipo nocoicashquiran, —ishon Jesús noco yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedronun Jesús cumani, —Nantifiton mia potafiaifoannocai un mia potaimaran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús Pedro yoini, —Un mia icon yoi Pedro. Tacara cuoataima min ato yoiqui “Uncai Jesús oinmisimaran,” ishon min ato yoiqui rafunon fusti huairan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Ma, Ifo. Un mifu nafiaquicai un ato yoinacama un mia oinmisimaran, —ishon Pedronun yoini. Ascaiton norifi nantifiton non nannori yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ascatan ihuifo mapoano ahuun anu Getsemaní nanno Jesús no fu cashon noco yoini, —Nuno tsaocahuun. Uhuun Upa un cufiyotanon, —noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ascatan Pedro yafi Zebedeo ahuun facu rafu Santiago yafi Juan nan rafu non fusti ato iyoni. Nan fasi omitsiscai tauai cuscan shinain fasi ahuun nomuran isicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ascashon ato yoini, —Un fasi omitsiscai cuscan uhuun nomuranshon shinain mun naacuana. Ascacun nunoshon oinyocahuun. Oshacaquima, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ato asca huatan chaimashta caashu fuopacucahuan Apa Dios cufini, —Upa un omitsiscai cuscan mian numatiromainquin ua numahuu. Ascafiashon un apaiyai cuscan huaquima nan min apaiyai cuscan fusti ua huahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ascashon apa cufinquin anaititan afanan atoqui oquin oian man oshafo ini. Ascaiton Jesús Pedro yoini, —¿Man u futan Diosin cufiyotiomamun? ");
INSERT INTO mcdNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Oshacaquima. Dios cuficahuun Satanás mato chaca huamapaiyai cuscan huashcaquima. Ascashon Diosin mato amapaiyai cuscan marifi huapaifiaquicai Diospan curushyamainocai man atiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ato asca huatan afanan apa Dios cuficaicani. Cashon apa yoini, —Upa, min ahuara futsa yorafo numashqui atiromamainquin nan min apaiyai cuscan huahuu. Unfi man itisharaqui atohuunoashu omitsiscacaini naashqui, —ishon Jesús apa cufini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ascashu afanan atoqui oquin oian afu rafuafo afi oshafo ini. Fasi osha murancoianfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ascaino afanan ato anoashu cashon apa Dios cufini. Nan cufia cuscacoin afanan nannori cufini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ascatan afanan oquin oian afi oshafo ini. Ascaiton ato yoini, —¿Manmun afi moiama? Natianfin nan chaca huamisifoan ua ato achimai fucaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Funicahuun. Non canon. Nan nocofunun ua ato achimai man oiquin, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ascaino nan Judas Jesús fu rafumisi futsan oaino a yorahuanrasi nopu yafi coshatifo tsomacanashu funifo. Nocon yorafohuunshon Dios cufimisi niaifofoan futan Dios fu tsainti pushu niaifo patasharifoan ato yonoa funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nan Judaspan yorafo iquisi yoiqui isca huani, —Un Jesús tamoqui tsoacaiton tapicahuun nanfin Jesusquin achicahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ato yoiqui asca huatan samamashta Judas Jesusqui nocoshon ahuun tamo tsoacatan yoini, —Tapimamisiton, man yamuaran —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús cumani, —Uhuun yoran, nan mian apaiyai cuscan ua huahuu. Nanscayoi min oaquin, —huani. Ascaiton nan Judas fu fuafoan Jesús achinifo niaifofo ano iyoshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ascaiton Jesús fu rafua futsan nopu fitan nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun oinmati pashtufain rurani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ascaiton Jesús yoini, —Unuhuu. Min nopu ahuun ona muran huahuun. Nan nopun yora rutuafin arifi nopun natiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Uhuun Upa Dios un yocaitofin ahuun oinmatifo afu icafo 72,000 ua nichishotiroquin ua cushui funonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ascan uafin uhuun Upa Diosin ahuun nai oinmatifo ua nichishotiroquin ua cushui funonfo. ¿Ascafia ahuuscashumun Diosin tsain uhuunoa cununi cuscan un yorafohuunoashu natiromaquin? Ascan uncai Upa Dios cufima ua ahuun oinmatifo afu icafo ua cushunon, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ascaino nantianri Jesús achipaiyaifoan ato yoini, —¿Unmun yora pofu cuscaracun man ua nopu yafi coshatifo yashon achi fua? Shafatifi un Dios fu tsainti pushu muranshon un mato yoifiaitocai man ua achipaiti huama. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ascafia nan man ua acai cuscan Diosin tsain yoimisifoan uhuunoa cununifo cuscan nanscacoin man ua huairan, —ishon Jesús ato yoini. Ascaino non afu rafuafo nantifi non amaqui ichoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ascano achicashon nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun pushu ano iyonifo. Nan niaifoan ahuun anu Caifás. Nannori niaifofo ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ascaino Pedro acachori cani. Acachori cafiai fishtatama cani. Dios fu tsainti pushu cushumisifoya Pedro niaifoan umainti ano tsaoni Jesusmain ahuusca huacaniquin ishon oinpai. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nannoshon niaifofoan shinanpainifo, —¿Nonmun raquiri huatiroquin Jesús ahuara chaca huaran ishon rutushquin? Ahuacai ahuusca huaiton non nicayomisima non rutuai, —icananshu nocon niaifofo afi ranan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Yora ichapafoan, —Jesús ahuara chaca huaran, —ishon ahuunoa tsain chaca yoinifo. Paracaquin. Ascafia niaifofoancai Jesushuunoa ahuara chaca iconcoin nicanifoma rutushcaquin. Ascashon futsafoan Jesushuunoa tsain chaca huaquin anaitiafoanno chipo nocofunu rafutan niaifofoan ointaifi Jesusqui tsain chaca huanifo. —Man non nicaitan na nocofunun isca huaquin yoia, “Nocon Dios fu tsainti pushu yorafoan aca cuscan unfi choquiatiroquin. Ascashon osha rafu non fusti finontan un afanan futsa huatiro. Uncai tsofutan atiroma. Urus fustifin un atiroquin,” Jesús iquitaran, —ishon nan rafutan yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ascano yorafohuunshon Dios cufimisifo aton niaifocoin nan Caifás Jesús yocani, —¿Miqui tsain chaca huafo cuscan icon iyamarai iconmamun? —ishon yocaino. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús puusinima. Ascaiton afanan yoini, —Diosin nan nipamisi ahuun anuhuunshon ua yoihuu. ¿Minmain Diospan Furunquin nan Diosin mia catonnimainquin? Ascan natian nannori un mia yonoi. Ua icon yoihuu, —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús cumani, —Nan mian yoiai cuscafin unquin. Un mato yoinon. Upa Diosin ahuamamishti huatiro cuscan chipo man ua oinshquin. Uhuun Upa Diosin niaifo fu un icun. Urifimain un afu niaifocoianshu. Ascacun un nai ariashu coinfo camaqui oaiton man ua oinshquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ascaiton nicai nocon yorafohuunshon Dios cufimisi niaifocoin, —Un Diospan Fururan, —Jesús icaiton nicai fasi sinacoinni. Ascacun ahuun sahuuti fashnuqui yoini, —Noncai afanan yorafoan Jesusqui tsain chaca huai yopaima. Manmain noficoin ahuun tsain chaca nicayamaifin, “Un Diospan fururan,” iquifin Dios chaca huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ascacun man ahuusca Jesús huapaimun? —ishon aton niaifocoinin ato yocaiton. Nantififain, —A rutucahuun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Asca huatan ahuun fusoqui cumo michofain sutufain futsan tapasni. Ascashon cashu mutsama huacaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Yoinifo, —Min Cristomainquin min nantifi tapicoian. Asca tsoan mia acamainquin noco yoihuu, —ishon cashu mutsama huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ascaino Pedro pushu umainti caashu tsaoni. Ascano nocohuunshon Dios cufimisi niaifoan ahuun oinmati shomayaton Pedro fuchishon yoini, —Jesús Nazaret anoa fu mirifi min afu oaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Ma. Mian yoiai cuscacai un tapiamafinquin, —Pedronun aton ointaifi huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Asca huafaini caincaiti ano caacun nannoshori shomaya futsanri Pedro fuchishon ato yoini, —Na nocofunufin Jesús Nazaret anoa fu imisiquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Afanan Pedronun yoini, —Ma. Min yoiai cuscafin Diosin tapiaquin uncai na nocofunu oinmisimaran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sama racatan afu niafoan Pedro yoinifo, —Icon. Minfin mirifi Galilea anoaquin. Min tsainhuunshon non mia onanran, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Afanan ato yoini, —Uncai mato paratiroma. Diosin ua oin. Un chanicun Diosin ua chii uru muran potatiro. Nantonfin tapiaquin un mato icocoin yoiaiton. Ascan uncai na nocofunu Jesús oinmisimaran, —ishon Pedronun afanan ato yoini. Ascaino samamashta tacara cuoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tacara cuoaino Jesús yoia cuscan Pedronun shinantani. —Pedron un mia yoi. Na yamutan tacara cuoataima min ato yoiqui rafu non fusti huai, “Un Jesús oinmisimaran,” —ishon Jesús yoia cuscan shinantani chifi caashu Pedro fasi uaini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ascaino funamanrishta nocon niaifofoan shinanpainifo, —Ahuuscashomain non Jesús rutumatiroquin, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ascatan munushcashon nan Romanon niaifoan ahuun anu Pilato ano Jesús iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Asca huashon Judaspan Jesús rutuaifoan nicaquin fasi shinanni. —¡Ohua! Un Jesús ato achimanama shara icuanaran, —ishon shinanni. Ascashu nocon yorafohuunshon Dios cufimisi niaifofo yafi Dios fu tsainti pushu niaifofo ano cani treinta toro paratamacoin ahuun pui nuua ato nasoin cai. Ascacainicashon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Unfin chaca huaquin. Jesuscai ahua chaca huayamafiamisicun un ato parashon achimanaran, —ishon ato yoiaiton. Cumanifo, —Ahuuscaquitsi min noco anori yoiyoa. Noncai ascara tapipaima. Mififin min shinanquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nicaquin nan Dios fu tsainti pushu muranshon ato naman torofo saafaini caashu afiri rusfipan tunushumuacucahuatan nani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Asca huatan Judas cai cachiori niaifofoan nan torofo topinifo. Ascashu niaifofo afi ranan yoinannifo, —Nocon shunifoan yononi cuscan non ahuun rafanan yora rutumana nan puicai non Dios fu tsainti pushu muran huatiroma. Nan pui huati murancai non huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na torofohuunshon nan cuti huamisi ahuun mai non finon. Nanno yora futsafo non mai huanon, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ascasho nan mai anunifo —Imi maiiran, —huanifo. Natianri nannori yoiafo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ascano nan Diosin tsain yoimisi Jeremías inon pacoai cununi cuscan natian man nanscacoin huaafo. Isca huaquin cununi, “Israelifoan yoinifo, ‘Non treinta toro inantiro nan nocofunun noco achimashocun,’ ishon yoiafo. Nan torofohuunshon cuti huamisiton ahuun mai fiafo. Uhuun Ifoan ua yononi cuscan un cuti huamisiton ahuun mai fia. Nanscarifi aqui nanfoanrifi aton torofohuunshon cuti huamisiton ahuun mai fiaforan,” ishon Jeremías cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ascashu Romanon niaifoan ahuun anu Pilato fu Jesús nia ini. Nan niaifoan Jesús yocani, —¿Minmun Judiofoan niaifocoin? —ishon yocaiton. —Nan min ua yoiai cuscafin unquin, —Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ascashon nocon yorafohuunshon Dios cufimisi niaifofo yafi Dios fu tsainti pushu niaifofoanri Jesús ahuara chaca huamisiran huafiaifoannocai puusinima. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ascaiton Pilato yoini, —¿Yorafoan mia chaca huaifo cuscan min nicaimamun? ¿Min ato cumapaimamun? —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Asca huafiaitocai Jesús cumanima. Tsain ichapa aqui chaca huafiaifoanricai fustishta ato cumanima. Ascaiton Pilaton ahuun nomuran shinanni, —¡Aira! ¿Ahuuscai ato cumapaimamun? —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nan fusititian faritifi a cunu muran iquiafo fusti caimaquin Pilato ato yocapaoni. —¿Ratocai man caimapaimun? —ishon yorafo yocapaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nantianri cunu muran iquia nocofunu fasi pofu rutumitsamisi. Ahuun anu Barrabás ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Jesús ahua chaca huaiyamafiacun. A icai cuscan apaicaquin nocon niaifofo Jesusqui sinacaquin Pilato ano iyonifo. Nan acaifo cuscan Pilato man tapian ini. Ascacun Pilato nanno yora ichananfo yocani, —¿Ratocaimun un mato cainmashotioquin? ¿Barrabás iyamarai Jesús nan Cristo Diosin catoanran man huamisi? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ato yocatan tsaoshon manani cumaifoan nicapaiquin. Ascaino ahuinin cunu fuma aqui noconi. Cunun yoiqui isca huani, —Nan nocofunu Jesús shara. Ahua chaca huamaquin. Ahuusca huayamahuu. Uhuun namapan un oian ahua chaca huayamafiashu omitsiscaiton oin urifi uhuun nomuran ahuunoashu un omitsiscacoinna. Ascacun ahuusca huayamahuu, —ishon Pilato ahuinin cunushoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ascafiacun nocon yorafohuunshon Dios cufimisi niaifofo yafi Dios fu tsainti pushu cushumisifoan nanno ichananfo ato yosiquin isca huanifo, —Jesús noco cainmashotamarocon Barrabás noco cainmashohuun. Ascashon Jesús rutuhuu ishon Pilato yoicahuun, —ishon ato yononifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ascacun Pilato ato yocani, —¿Nan rafu ratocaimun man fuchipaiquin un mato caimashonon? —ishon ato yocaiton. “Barrabasquian,” huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Un Barrabás caimashomun un Jesús nan Cristo Diosin catoan un ahuusca huaicai? —ishon ato yocaiton. Afanan nantifiton yoinifo, —Mastahuun, nanon, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ascaifoan Pilato ato cumani, —¿Ahuuscacufin? ¿Ahuamun chaca huaquin? —ishon ato yoiaiton. Ascafia fasi curushcain yoirianifo, —Mastahuun, nariscanon, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ascaiton Pilato oian tsoan nicapaitama fasirocon mucai finaifoan. Masu fitan aton ointaifi muchoquimuni. Muchoquimutan ato yoini, —¡Oincapon! Uhuun nuama. Un Jesús cainmapaifiainocai man cainmapaima. Manrocon fasi rutupai. Ascan matohuunfi nuuaquin, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nantififain cumanifo, —Nanscanon. A nai nocohuun nuunonquin. Nocon facufohuunri nuunon, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ascaifoan nicaquin Pilato Barrabás ato cainmashoni. Ascashon ahuun ranushumuafo yononcun fichi cunoqui tuchiaton Jesús coshaqui futsanifo. Asca huashon mastanonfo iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nan ranushumuafoan Jesús iyoafo anofin niaifoan ahuun pushu iniquin. Ascano nan niaifo cushumisifoan ranushumuafo chifinoafo cunani Jesús oin funonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ascashon ahuun sahuuti shorifain futsa shonan sahuumanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ascatan mosha chainipafo maiti huashon maimafain poquiti ahuun mumihuuri tsomamashon ratoconun mai chachishon yoinifo, —¡Aicho! Minfin Judiofoan aton niaifoquin, —ishon cashu mutsama huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ascashon aqui cumo michofain ahuun poquiti fiantan ahuun coshapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ascashofin cashu mutsama huacatan nan sahuuti shonan pucashon ahuun sahuuticoin afanan sahuumanifo. Asca huatan mastai focaquin iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Focani nan nocofunu Simonqui noconifo. Nan Simonfin Cirene anoashu cainniquin. Ascan nan ranushumuaton yononi. —Ihui coyan iquinan noco foshoicahuun, —ishon iyamafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota ano fonifo. Gólgota yoia mapo shao. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nanno nococashon Jesús fimi unu pau tashipia osia ayamapaiyaifoan muutacai Jesús apainima. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Asca huatan Jesús iyocashon mastanifo. Mastacatan ahuun sahuuti fianpacunifo. Toquiri tocoro rafuya cashuqui nan finonmanaton ahuun sahuuti fiqui tau huani. Ascashon cuyonfianifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Asca huatan tsaocashon a Jesús mastafo foisnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ascano man ihui coyan iquinanqui mastacashon amanaonri cununifo isca huaquin, NAN JESUSFIN ISRAELIFOAN ATON NIAIFOCOINQUIN ishon cununifo. Nannori Jesús icaran ishon mastanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ascashon yomutso rafuri mastanifo. Ocuma futsa futsafain ocuma futsa futsa anifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Ascashon camacaquin isca huanifo, —¡Cuu! Minfin yoimisiquin nocon Dios fu tsainti pushu min choquiacai. Ascatan osha rafu non fustitan min afanan futsa huairan min imisi. Mifin numatan ihui coyan iquinanmaquinoashu fotohuu. Min Diospan facumainquin, —ishon roanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nannori nocon yorafohuunshon Dios cufimisi niaifofo yafi Dios fu tsainti pushu cushumisifo futan Moisés cununi cuscan tapimamisifoan Jesusqui cashumutsamanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ascashon yoinifo, —Nanton futsafo numafiatiroshaquin aficai numatiroma. Ascan minmain Israelifoan aton niaifoquin ihui coyan iquinanmaquinoashu fotohuu. Min ascaiton oinquifin non mia icoinra huaicain, —ishon roanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ascasho niaifofoan nanno niafo ato yoinifo isca huaquin, —Jesús noco yoimisi, “Unfin Diospan facuqui,” ishon noco yoimisi. Nantofin Dios icoinra huamisiquin. Ascan Upa Diosin a fuchipaiquifin numatiroquin, —ishon aqui tsain chaca huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ascano afu masta rafutan aqui tsain chaca huacaqui roanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ascano fari masafinin racafiashu nan maitio faquishpacucahuani. Ascashu man fari caino afanan shafani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ascaino nantianri Jesús fasi oi ashcafinin apa cunani, —¿Elí, Elí lema sabactani? —nan yoipai, —¿Uhuun Diosin, Uhuun Diosin, ahuuscai mian potamun? —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jesús ascaiton yorafoan mapo cashon nicacaquin yoinifo, —Nicacapon. Elías cunaiton, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ascaino futsa ichoni fimi unu focash muran mishan nanupacufoantan faca tahua shatun mishan tunhuuinifoan Jesús inanpaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Inanpaiyaiton atirifoan yoinifo, —Unuhuu. Elías oshomain fotomaicai non oinon, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ascano Jesús fasi fiisinacahuani. Fiisinacahuatan naani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ascashu Jesús natapaiyaino a Judiofoan Dios fu tsainti pushu murannoa pano puta pochimua aficoin fashnupacucahuani. Nanscatapaiyaino mai nayanaiyainquin. Toquirininhuanfo torufafaini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Ascaino nan Diospan yorafo naacun mahua quini muran mai huanifo. Nan toquirinin huafo fupucui futsuaino Diosin afanan ato nimani. Ascashu Jesús funiaitian nanfori nan mahua quini murannoashu Jerusalén muran iquinifo. Ascaiton nanoa yora ichapafoan oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ascaino ranushumua niaifo yafi a futan Jesús cushuafoan mai naiyanaiyaicaino ahuara futsafori ahuascaraiton oincani fasi ratucoincaquin yoinifo, —Iconfinquin. Nanfin Diospan facuquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Ascaiton nannoshon ainfo ichapafoan chaicushon oinnifo. Nan María Magdalena non María futsa nan Santiago futan José ahua non Zebedeo facufoan aton ahuari. Nantifi nan ainfofo Galilea anoashu Jesús fu foanfafainmisifoan nan apaiyaifo cuscan ato huashomisifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ascatan man fari caino nocofunu ahuashta yopatanaima ahuun anu José nan Arimatea anoashu cainni. Nantorifi Jesús tanamisi sharacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nan José niaifo Pilato ano cashon yoiquin isca huani, —Niaifon, un Jesús toquirininhuan quini muran mai huapai. Un mia yocayoaran, —ishon yoini. Ascaiton, —Jesús ahuun caya José inancahuun, —ishon Pilato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ascaiton José Jesús ahuun caya pano oshopa sharacoinchi raconi. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Racoshon toquirininhuan quini muran Jesús mai huani. A murancai tsoa maiyomisima muran mai huani. Ascashon toquirininhuanun fupofaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nannoshori María Magdalena futan María futsan tsaoshon oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iyoconaino tunutitian yorafohuunshon Dios cufimisi niaifofo yafi Fariseofo Pilatoqui fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Focashon yoinifo, —Niashu nan Jesús chanishunin yoimisi, “Un naashu osha rafu non fustitan un afanan funitiroran,” imisi. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ascacun min ranushumuafo a maia toquirininhuan quini ano ato nichihuun cushunonfo. Min asca huaiyamaitofin afu rafuafoan ahuun caya onui futirofoquin. “Man funiaran,” icashu chanishcaquin. Jesús chani tauyomisi. Ascan chipocaifin fasi chani finacointirofoquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ato yoini, —Manfin mato Dios fu tsainti pushu murannoa maton ranushumuafo a toquirininhuan quini ano ato nichicahuun cushutanonfo, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ascaiton a toquirininhuan quini ano ranushumuafo nichinifo. Nanfoan toquirininhuan sapa tocoro fuposhon ahuara tuipaton tanyacunifo. Ranushumuafo nanno nichifurani funifo nannoshon cushunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ascano Israelifoan noco tunutitian nan Domingo anaitia iyoconaino nan maia ano oin focani fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ascaino nantianri mai fasi curushcain nayanaiyaicaino nocon Ifo Diosin ahuun oinmati afu icafo nai ariashu fotoni. Fototan toquirininhuan fuputan acamaqui tsaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ascaino ahuun fuso fasi chashacoinni. Naan canan facaica ointsa. Ahuun sahuutiri fasi oshopa yoa rama furoa ointsa. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ascaiton oincani ranushumuafo fasi ratui tari taricani aton ratupasi nayonifo. Nan naa shinantsa anifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","6","Ascaiton Diospan oinmatinin afu nai muran icaton María rafu yoini, —Ratuyamacahuun. Mun tapia man Jesús funai yoa. Jesús man mastafiaitafo natian nunoma. Mato yoimisi cuscan man funia. Oin fucapon quini muran. Nan racaitano. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ascashon afu rafuafo ato yoiriscatacahuun, “Jesús naafiaitashaqui man funiaquin. Galilea ano cai tauicai anoshon mato manashqui. Nannoshon man ointiro.” Un mato yoiai cuscan ato yoiriscatacahuun, —ishon Diosin nai oinmatinin ainfo rafu yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ascaiton nicatan nan ainfo rafu toquirininhuan quini anoashu ichonifo. Ratufiacani aton nomuran fasi unimacoincaquin afu rafuafo yoi focani ichonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ichoaifoanno Jesús atoqui niriscatani. Ascashon, —Mun moiyaran, —ishon ato yoini. Ascaiton nan ainfo rafutan taicopacufoantan, —Min nocon Iforan —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Ratuyamacahuun. Ascatamarocon uhuun ushtofo ua yoishotacahuun Galilea ano fononfo. Nannoshon ua oinshcaquin, —ishon ato Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ascatan ainfofo Jesús anoashu foaifoanno ranushumuafori yorafohuunshon Dios cufimisi niaifofoqui nan oianfo cuscan atoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ascaiton nicacani niaifofo ichanancashon shinannifo, —Nonmun ahuusca huaicai, —ishon. Ascashon ranushumuafo yoinifo, —Non mato yoiai cuscan nannoricoinrifi futsafo yoicahuun non mato pui ichapa inanon. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ascacun ato yoiqui isca huatacahuun, “Jesús fu rafumisifoan non oshano fucashon Jesús ahuun caya man onuaforan,” ato huatacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ascaiton niaifocoinin nicaquin Jesús ahuun caya anoma nicai raquirira icaiton non yoisharaicanon mato ahuusca huanonma, —ishon niaifofoan ranushumuafo yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ascashon ato pui inanfoanno focashon nan niaifofoan ato yoiafo cuscan nannoricoin ato yoinifo. Ascaiton nan maifoti anoafo futan Israelifoan nicanifo. Ascano nantian icoinra huanifo ranushumuafoan ato yoiaifo cuscan nicacaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ascashu non afu rafuafo once nan Jesús noco yoia cuscan machi Galilea ano non cani. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ascashon oinquin non yoini, —¡Aicho! Min nocon Ifo Jesús. Non mia fasi noiran, —ishon non yoini. Ascafiaitocai futsafoan icoinra huacuanima. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ascano nocoqui chaimashta oshon noco yoini, —Uhuun Upa ua yonoa nantifi nai ariafo yafi mai anoafori un yononon. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ascacun manifoti anoafo yoifoanfafaitacahuun ua icoinra huafain ua tanasharanonfo. Uhuun Upa Diosin ahuun anuhuunshon yafi uhuun anuhuunshon non Diospan Yoshin Sharahuunshonri yorafo unu muran iquimashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ascashon nantifi un mato yonoa cuscan huafain yorafori yosicahuun icoinra huafain ua nicasharanonfo. Unfin matofu iquicai. Ascashu nan un afanan oaitian un mato furi ipanacaran, —ishon noco Jesús yoini. Nanti.");
INSERT INTO mcdNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Natian tsain shara Jesucristo Diospan Furunhuunoa un mato cunushoni man tapinon. Nuno mai ano niyoashu ini cuscan un mato tapimai. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cainyataima fari ichapa inonpacoai cuscan ahuunoa nocon shuni Isaías cununi. Chipo inaca cuscan yoiyomisi. Upa Diosin Furun yoiyoni cuscan Isaías aqui cununi isca huaquin, “Upashtan, min yorafoan mia onantaima uhuun tsain yoimisi un atoqui nichicain mihuunoa ato yoinon. Itisharanonfo mia nicashquin,” ishon Upa Diosin Furun yoini cuscan aqui cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Diosin tsain yoimisihuunoari cununi. “Tsoan istaipamashon ahuun yorafo yoishquin isca huaquin, ‘Nocon Ifo oshquiquin. Itisharacahuun. Maton chaca shatucoincahuun isharashcaquin,’ atofin ato yoishquiquin,” ishon Juan cainyataima fari ichapa inaca cuscan Isaías ahuunoa cunushoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ascan cununi cuscacoin aa. Tsoan istaipamanoashu Judea mai ano Juan oni. Ascano aqui furifurinifo. Furifuriaifoan ato yoiquin isca huani, —Maton chaca shatucoincahuun. Man ascaiton Upa Diosin maton chaca rau huanon afanan shinanshquinma. Asca huatan maton chaca shatucoinshon futsafori ismashcaquin un mato unu muran iquimanon, —ishon Juanpan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ascano Jerusalén anoafo yafi Judea anoashuri aqui funifo. Ahuun tsain nicapai funifo. Fucashon atirififoan aton chaca yoiaiton Juanpan ato unu Jordán naquishon iquimatan cainmapacuniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Camello inapan rani ahuun camisa huashon Juanpan sahuua ini. Ascashon yoinaton fichi aqui nanushumuni. Ascashori ocutsuru pifain afuchi fona ayani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ascano isca huaquin yoini, —Nocofunu futsan samamashta mato tapimai oshquin. Ua fasi finoncaia. Ahuamamishti huatiro. Uncai asca huatiroma. Un ahuara shara huahuu rafanancai un ahuun oinmatima. Uhuun ramapaiyamainocai un ahuun oinmati icuanama. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Un mato unu muran iquimatan cainmanaquin maton chaca shatushon man Dios tanasharanon ascashon man ato oinmanon. Atofin ahuun Yoshin Shara matoya rafumapacuiquin, —ishon Juanpan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ascano Jesús Galilea anoashu unu Jordán ano cani. Nannoshon Juanpan unu muran iquimatan cainmani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ascatapaiyaino naicoin finoinnifoantan Upa Dios icariashu nai fupuini. Nai fupuicaino Diospan Yoshin Shara ruhuin cuscara Jesusqui fotopacucahuanaiton oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Fotoaino nai murannoa Upan Diosin ahuun oi nicanifo isca huaiton, —Minfin uhuun Facuquin. Un mihuun fasi noicoin. Un miqui fasi unimacoinran, —ishon Apa Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ascano tsoan istaipamashon ano Diosin Yoshin Sharapan Jesús iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anocai tsoa icai inima. Yoinafosi nanno icai ini. Nannoshon Satanás cuarenta oshatan chaca huamapairiani. Ascatan amaquinoashu caino Upa Diosin ahuun oinmatifo afu icafo Jesusqui fotonifo cushushcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ascano Juan ranushumuafoan cunu muran iquimanano Jesús Galilea ano nasocaini Diospan tsain shara yorafo yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ato yoiqui isca huani, —Nocon Ifo Diosin matoqui oshquiquin. Maton chaca shatucahuun. Chaca huaquima Diosin tsain shara icoinra huacahuun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ato yoitan ianmanhuan Galilea cusumun cani. Caquin Simón chipocun Andrés futan nushutinin nushuaifoan ointoshini. Nan rafutanfin nushumisi inifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ascaiton, —U fu fucahuun. Manfin nushumisicoinquin. Man shiman ichaparasi nushutinin fia cuscan natian uhuunshon man uquin yora ichapa ihuushqui aton Ifo un inon, —ishon Jesús ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ascaino nushuti huafaini afu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús chaimashta catan Zebedeo facu rafu fuchini. Nan nanu rafutan Santiago futan Juanpan shasho naquishon nushuti icushnifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ato fuchishon, —Un fu fucahuun, —ato huani. Ascaino samamashta apa yafi ahuun oinmatifo shasho naqui nichifaini focani afu fonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ascano Capernaum mai ano fonifo. Judiofoan aton tunutitian ichananti pushu muran atofu ichanannifo. Ichananfoan Jesús ato yosiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ascaiton nicacani —¡Aira! Nicacapon. Tsoancai anori noco yosimisima. ¿Ahuuscashon nunori noco yosisharaimun? Ahuun tsain sharacoin nanua. Moisés cununi cuscan nocon tapimamisifoan anori noco yositamarocon niaifoan tapicoian cuscara noco yosiaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ascano nannoa ichananti pushu murannoa nocofunu yoshin chacanun ahuun nuushon fiisimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Fiisimaino, Jesús fuchini. Fuchishon yoiquin, —¿Ahuuscain min noco fucash huai oamun, Jesús Nazaret anoaton? ¿Min noco omitsiscapanacafo muran min noco potai oamun? Man non mia onan. Diosin mia catonni. Mincai chaca huamisima, —ishon yoshin chacapan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ascaiton, —Tsainyamahuu. Amaquinoashu catahuun, —ishon Jesús yoshin chaca curushcain nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ascainofin yoshin chacapan nocofunu fasi musta mustaimatan amaquinoashu fiisicaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ascaiton oincani, —¡Aira! Jesús fasi ahuamamishti huacointiro. Iscaracai ahuashta non oinyomisima. ¿Ahuuscashomun ahuun tsainman yoshin chacapan nicacasmafiaiton nan yoia cuscacoin huaaquin? —icashu yoinannifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ascatan chanifoanfafainifo Jesús aca cuscan ahuunoa Galilea anoafo yoifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ascacaini Judiofoan ichananti pushu murannoashu Santiago yafi Juan fu focani Simón futan Andrés pushu ano noconifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nanno Simón ahuun raisi yoshafo fasi yonaiton Jesús tapimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ascano Jesús mutsoinifoannaino funinaca huani. Funinaca huatan yona matsiriscatan nan yoshafoan ato pimashquin pichacufaini. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ascatan man fari caino isinincai futsa futsatapafo yafi yoshin chacafo atohuun nuufafaina yorafoan Jesusqui ihuunifo ato cayahuamapacunon. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nan pushurasi anoashu Jesusqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isinincai futsa futsatapafo ato cayahuamapacuano. A yoshin chacafo atohuun nuufafaina atomaquinoa potani. Jesús Diospan facun yoshin chacafoan onainfoan —Tsainyamacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ascatan shafacuaino pushu murannoashu Apa Dios cuficai tsoan istaipama cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Caano Simón non afu rafuafoan Jesús funai focani fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Fuchicashon, —Nantifi yorafoan mia funairan, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Pushurasi futsafo ano non canon un atori Upa Diosin tsain yoinon. Ascacun uhuun Upa Dios ariashu nuno un oaquin, —Jesús ato huaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ascashu nantishon Galilea ano cahuacacaini Israelifoan aton ichananti pushu muranshon Diosin tsain ato yoini. Nan yoshin chaca atohuun nuuafo atomaquinoa potaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ascatan nocofunu futsa yoratishon ranimamishti rashquishi futsua Jesusqui nocoshon. Ratoconun mai chachishon yoini, —Ua caya huapaiquifin mian caya huatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ahuun ramapaiquifin ahuun mucuman ramanni, —Ai Un mia caya huai. Ascan natianfin min caiyaicain, —huainofin. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A rashquishi futsua cayariscani. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Cayacun yoini, —Un mia caya huaa tsoa yoiyoyamahuu. Nocon caifohuunshon Dios cufimisi a ismatahuun. Moisés mato yononi cuscan chashoanun facu a inanhuun mia rutushonon. Min chaca soafain min caya ato oinmashquin. Ascano tapinonfo Moisés noco yononi cuscan min aiton, —ishon Jesús yoifia. ");
INSERT INTO mcdNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nicatamarocon samamashta ato yoifoanfafaini, —¡Oincapon! Jesús ua caya huashara, —ishon ato yoifoanfafaini. Ascaiton nicacani yorahuanrasi Jesusqui fupaifiacani Jesús iquitiroma ini. Ascano tsoan istaipama caano pushurasiti aqui cuyo funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ascano osha ranantan afanan funifo. Capernaum ano nasofuracani. Nanno pushu muran iquicun nicanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nicacani yorahuanrasi aqui funifo ato Diosin tsain yoinon. Pushu fospicoianno tsoa futsa afanan iquitiroma ini. Umaintiri yora ichapacoin yuruicafono afanan tsoa iquitiroma ini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ascano nocofunu rafu non rafuriton aton yora charishi futsua shuhua naratashon ihuunifo Jesús caya huamanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Iquimapaifiacaquin yorahuanrasi pushu fospiano iquimanifoma. Ascashon pushu fomancayan tapa tsucashon Jesús nia naman fotomapacufoannifo. Nanno yorahuanrasi nastui shuhua ya ratapacufoannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús oian nan nocofunu yoratishon charishi futsua ahuun yorafoan fasi icoinra huaifoan. Oinquin a yoratishon charishi futsua yoini, —Uhuun yorashta, mun mia chaca soashona, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ascano Moisés cununi cuscan tapimamisifo nanno tsaoafo ini. Aton nomuran shinancani, ");
INSERT INTO mcdNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¡Ajaa! ¿Ahuuscain na nocofunun anori yoimun? Diosin fustitofin chaca soatiroquin. Nocofin fuparaniquin. “Un Diosiran,” ishon. Anori yoiquifin “Upa Diosin chaca huaiquin,” —ishon aton nomuran shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ascaifoan shinainfo cuscan Jesús onanshon ato isca huani, —¿Ahuuscaquimun maton nomuran amaquiri man shinaincain? ");
INSERT INTO mcdNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Unfin Cristoquin un yorafo aton chaca soashotiroquin. Un chaca soafain un ahuamamishti huatiro un mato oinmanicain. Upa Diosin ua catoan. Ahuunshonfin un yorafo aton chaca soashotiroquin, —ishon ato yoini. Asca huatan nocofunu yoratishon charishi futsua yoini, ");
INSERT INTO mcdNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Min pushu ano min shuhua ya funicaitahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Asca huatanaino nanno icafoti aton ointaifi funinaca huantan ahuun shuhua chishtofaini cani. Ascacainaiton oincani nantifi yoinain futsunifo, —¡Aira! Diosin ahuamamishti huatiroquin. Noncai iscara oinyomisima. Diosin sharaquin, —icashu yoinannifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús nanscacaini afanan ian cusumunri caino yorahuanrasi afanan aqui funifo. Ascano ato yosini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ian cusumun cahuanquin Alfeopan facu ahuun anu Mateo Jesús oinni. Nanton niaifo pui fishofafainmisi. Pushu facu muran tsaoa ini. Ascaiton Jesús a yoiquin, —Uqui ohuu. Ua tanamisi ishquin, —huani. Asca huaino funinaca huatan afu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ascaino Mateon Jesús yafi afu rafumisifo ya ahuun pushu ano iyoni ato pimashquin. Niaifo pui fishofafainmisifo non Moisés cununi cuscan tapifiacashon tanapainifoma Jesús fu foanfafainmisifo ahuun tsain nicapaicani. Afori Mateon pushu muran iquinifo ato futan pishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ascano Moisés cununi cuscan tapimamisifo nanfofin Fariseofo iniquin. Oincaquin Jesús tanamisifo yoini, —¿Ahuuscain Jesús na niaifo pui fishomisifo yafi Moisés tsain tapimafiacashon tanapainifoma futan piimun? —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ascaifoan nicaquin Jesús ato cumani, —A isinincaifoma caya huamamitsamisi yopacanima. Ascan nan isinincaifoti fasi caya huamamitsamisi yopacoincani. Ascarifi aquin, “Uncai ahua chaca huamisimaran,” icaifoan un aton chaca soashotiroma. Ascan, “Unfin fasi chaca huamisiquin. Un imisi cuscan un afanan apaimaran,” icaiton un ato yoitiro, “Uqui fucahuun. Un maton chaca soashotiroran,” —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ascano iyoco futsaino nan Juanhuunshon tanamisifo non Fariseofoan piqui tununifoquin. Ascaiton futsafoan Jesús yocanifo, —¿Ahuuscain Juanhuunshon tapimisifo futan Fariseofoanri piqui tunufiaino minhuunshon tapimisifoancai piqui tunucanimamun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús ato cumani, —Yora unimaifoancai chaca shinancanima. Ascacucai piqui tunutirofoma. Funun ato chani huafoanricai piqui tunutirofoma. Fununmain ato fucunfin. Ascaino unimacaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ascafiaino funu chipo atomaqui cano shinancaquin piqui tunutiroforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsain futsari ato yoini isca huaquin, —Camisa shunishta fashnucun funa potonun icushumua poto funa chopi futsuashu camisa fasi uhuai finacointiro. Tsoancai afanan ascara icushpaitiroma. Nanscarifi aqui un mato tsain funa yosian cuscan nicacoinshon man apaoni cuscan man afanan apaitiroma. Tsoan ua tanacoinshocai apaoni cuscan huatiroma. Ascashu funa cuscara shara itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nanscarifi aqui tsoancai fichi tutso shuni muran vino funa a muran manutiroma. Toshacainaino fichi tutso chacanatiro. Vinori cuyofotiro. Nanscarifi aquin maton shunicaifoan mato yosimisi cuscan yafi un mato yoiai cuscan nan rafucai ositiroma. Un mato yosiain cuscacoin nannori. Diosin tsain shara. Ascan maton shunicaifoan yosia cuscacai anorima. Anori tanashucai Diosin mato imapaiyai cuscan man atiroma. Nan rafu osishon nicapaiquicai man shinansharatiroma. Vino funa fichi tutso funa muran manua shara itiro. Nanscarifi aquin ratoranfoan apaoni cuscan unutan un ato tsain funa yosiain cuscan fusti tanacointirofo Diosin ato funa shara imatiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ascatan Israelifoan aton tunutitian Jesús yafi ahuunshon tapimisifo mau mapai fucaquin trigo mutuscashon fonicoincaquin piainfoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseofoan oincaquin Jesús yoinifo, —¡Oincapon! ¿Ahuuscain nocon shuni Moisés yononi cuscacai man aima? Tunutitian trigo man mutuscaniran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ascaiton Jesús ato cumaquin, —¿Davidhuunoa cununi cuscan man oinmisimamun? ¿Fonainquin nocon shuni David afu rafuafo futan ani cuscan man nicamisimamun? Nicacapon un mato yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar nocon yorafohuunshon Dios cufimisi niaifocoin ini. Nantianri David yafi afu rafuafo Diosin tsain cufiti pushu muran iquinifo. Iquicatan amurannoa misifo ato piquini fasi fonicoinquin. Tushu futsa yamaino, misifofin nan nocon yorafohuunshon Dios cufimisi niaifocoinnaasi ini. Tsoa futsan pitiroma. Nannori yonofiani fasi fonicoinquin David pini. Ascashon afu rafuafori pimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ascan un mato yoinon. Upa Diosincai nunori shinannima. Isca huaquin, “Un tunutitian yonoyonon. Chipo un yorafo onihuai tunutitian yonononfomaran,” ishon anori shinannima. Ascatama Upa Diosin yorafo shara huapaiquin Moisés yoini isca huaquin, “Ato yonohuun semanantifi shafa fusti yonononfoma. Tunuyononfo ua shinancaquin,” ishon Upa Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ascacun un yoitiro ahuuscamain tunutitian man atiroquin. Uafin Upa Diosin catonniquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Ascatan tunuti futsaino Jesús Israelifoan aton ichananti pushu muran iquini. Iquicun Fariseofo yafi Moisés cunu tapimamisifoanri Jesús aasi oinnifo ahuuscashomain nocofunu musufimua tunutitian caya huaicain. Ahuunoa ahuara chaca yoipaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ascan Jesús a nocofunu musufimua yoini. —Aton ointaifi nuno nihuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ascaino nocofunun ato nishoni, —Un mato yocain man ua cumatiromainquin. ¿Raquiri Moisés tsain noco yonoamun? ¿Tunutitian non ahuara huatiromun? ¿Nonraca sharatiro? ¿Nonraca chacatiro? ¿Tunutitian non yora cayahuatiromun? ¿Yora isinin icai oamun non cayahuaimun? Non caya huamama natiro. Nocohuun nutiro. ¿Non rutua shinantsain? ¿Ascamun shara? —ishon ato yocani. Ascafiaino puusinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ascatan sinaquin ato oiancutan ahuun nomuran fasi shinain, —¡Ohuashta! ¿Ahuuscashon aton nomuran shinanchacamisifomun? Ua icoinra huacatama, —ishon shinanni. Ascashon a nocofunu musufimua yoini, —Min mucu mushan huahuun, —huaino. Yonoa cuscan mushaniquin. Ascashu ahuun mucu muma sharacoin iriscatani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ascaino Fariseofo amaquinoashu Herodes ahuun yorafo ano fonifo, —¿Ahuuscashomain non Jesús achimanain rutunonfo? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ascatan Jesús yafi afu rafumisifori nannoashu ianmanhuan Galilea ano fonifo. Foaifoanno yorahuanrasi Jesusqui funifo. Galilea anoashu fuaifo Judea anoashu fuaino Jerusalén anoashu fuaino Idumea anoashu fuaino unu Jordán chaimashta icafori fuaino Tiro yafi Sidón anoashuri aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yora ichapa caya huamamisi tapicanashu isinincaifo ichaparasi aqui funifo. —Norifi non Jesusqui mupiashu non cayatiroran, —icashon shinannifo. Jesús oinquin afu rafuafo yoini, —Ua shasho fushocahuun. Ipaishoma un yopaicai. Yorahuanrasiton ua yuruatiroquin, —Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yora yoshin chacafo atohuun nuafo Jesús fuchicatan fuopacufoannifo. Ascashon yoinifo, —Minfin Diospan facuquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","—Tsainyamacahuun. Un Diospan facuqui tsoa yoiyamacahuun, —ato curushcai huaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ascatan Jesús machi mapufaitan afu rafuafo cunani, —Uqui fucahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aqui fuafoan doce catonshon ato yoini, —Man uhuun yonomisifo itiro ufu rafufafaincahuun. Un mato nichicai man yorafo Upa Diosin tsain ato yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Un mato yonoshqui uhuunshon yoshin chacafo futsafohuun nuucun atomaquinoa man potatiroran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nan doce Jesús catonni afoan aton anufo un mato tapimanon. Futsan Simonfiacun ahuun anu futsan Jesús tuqui huani Perdo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Futsafo Zebedeo facu rafu Santiago yafi Juan. Aton anu tuqui huani Moanurquisi, onicoinnin tsainmanfin nocofunufo curushcoin nan turuica cuscara. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Futsanfoan aton anu Andrés non Felipe non Bartolomé non Mateo non Tomás non Alfeopan facu Santiago non Tadeo non Simón futsan nanton fasi Diosin tsain tanasharacoinpaiyaino. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Futsan ahuun anu Judas Iscariote nanton Jesús potashon ato achimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ascatan Jesús yafi afu rafuafo pushu muran iquinifo. Iquiano yorahuanrasi a nicapaicani aqui funifo. Ascano ato yosiaino a futan afu rafuafoan ahua piinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ascano ato yosifaiquin, yosifaiquin huaiton. —¡Uru! Jesusfin nison cuscaracoinquin, —icashu ahuun yoinannifo. Acaifoan nicai ahuun yorafo funifo. Ihuipaicani. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Asca Moisés tsain tapimamisifori Jerusalén anoashu nicapai aqui funifo, Ascashon yoicaquin —Jesusfin Satanashuunshon ahuarafo huaiquin. Satanás yoshin chacafoan aton niaifo. Ahuunshon nocofunumaquinoa yoshin chacafo potairan, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ascano Jesús ato cunani. Ato ahuara futsafohuunoa yoishquin ato tapimanon. Yoini isca huaquin, —¿Ahuuscashumain Satanás afiri potatiroquin? ");
INSERT INTO mcdNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Caifofo afi ranan rutunain cuyotirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yorafori afi ranan rutunain cuyotirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nanscarifi aqui Satanás afin ahuun yoshin chacafo potaino arifi funotiro. Asca huaino ahuun yono chacanatiro arifi cuyotiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Shinancapon. Nocofunu mutsisipacoinin ahuun pushu cushuanocai tsoa iquitiroma ahuun mafo onunshquin. Ascafiaino rufofo achifain munushushon ahuun mafo onutiro, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","—Jesuscai Diospan Yoshin Sharahuunshon yorafo caya huamama yoshin chacahuunshon ato caya huamaran, —ishon yoinifo. Ascafiaifoan Jesús ato yoini, —Icon un mato yoinon. Ua nicacahuun. Ratoran futsan futsafo tsain chaca huafain Diosquiri chaca huacun Upa Diosin nantifi chaca huaa cuscan rau huashotiro. Ascafia tsoan Dios nicacasmaiton yoiquin isca huatiro, “Naton aca cuscan Satanashuunshon acaran,” huafiaino Diospan Yoshin Sharahuunshon atiro. Nanton Diospan Yoshin Sharahuunoa tsain chaca huacun Upa Diosin ahuun chaca rau huanacama. Chaca huaa cuscan ahuun nuupacunacaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ascano Jesús icano ahua yafi chipocufo noconifo. Pushu fospiaifono chifishon niafo futsa amuran nichini a yoinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yorahuanrasiton cufuacunifo. Ascano futsan yoini, —Min uhuan futan ushto rananun chifi nishon mia ahuara yoipai fuaforan, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—Un mato tapimai ratofomain uhuun uhua yafi uhuun ushtofoquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ascano cufuacufoannaifoan ato oiancufainquin, —Nafo uhuun uhua cuscarafo yafi uhuun ushto cuscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uhuun Upa Diosin ato amapaiyai cuscan afofin uhuun ushtofo cuscara non uhuun chicofo cuscarafo non uhuun uhua cuscarafoquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ascano iyoco futsaino ian cusumunshon Jesús ato yosiaiton nicacani yorahuanrasi funifo. Fuaifono shashon naqui nanupacucahuan cushan camaqui tsaoshon ato yoini. Ascaino ian cusumun maponifo ahuun tsain nicacani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ahuun tsainman ato ichapa yosini isca huaquin, ");
INSERT INTO mcdNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Uhuun yoramishtichin ua nicasharacahuun un mato yoinon. Nocofunun ahuun noshati murannoa fimi ushu fishon ahuun mau mamaqui. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Saacano ushufo fai nushmancayan pacua puiyafoan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ushu rananri toquiri camaqui pacua maima ano pacuni. Samamashta ushu foaicano ");
INSERT INTO mcdNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","farin tsacaqui yositima huani. Ascano nani. Ahuun tapo chaimashta foanno fanafo nai cuyoni. Tsasi futsuni. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ushu rananri tasha murannoashu foaisharanima. Ascatari fiminima. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ascan ushu rananri mai shara ano saaca. Foaisharashu fimini. Futsa foasharashu treinta ahuun fimi icaino ushu futsa sesenta ahuun fimi icaino futsa cien ahuun fimi ini, —ishon yosini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ascano Jesús ato yoiquin, —Man pafiqui yaquin ua nicasharacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ascano chipo yorafo amaquinoashu fonifo. Foafono afu rafuafo doce fucashon yocanifo, —Ifon, min rama fimi ushu saamisihuunoa ahuara noco tapimashquin non tapisharamaquin. Noco shafacafi yosihuu, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Asca huaifoan Jesús ato cumani, —Upa Diosin a icanoshon ahuun yorafo iquinai cuscan un mato fusti shafacafi tapimai. Ascashon futsafo ahuarafo cuscarahuunshon fustisi un ato yoiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nicasharaifoan Upa Diosin aton chaca soashocuana ato rau huashquin. Ascan oinfiaquicai tapitirofoma. Nicafiaquicai tapitirofoma. Tapicashon aton chaca shatucuanafo Diosin tsain icoinra huashquin. Ascaiton un aton chaca soashocuana, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—¿Nanfo un saamisihuunoa ahuara futsa ato tapima cuscan man nicayamaiton ahuuscashomun man tsain futsafori nicatiroquin? ");
INSERT INTO mcdNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nicasharacahuun un mato tapimanon. Nan ushu saamisi Diosin tsain yoimisi cuscara. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ushufo fai nushmancayan pacua puiyafoan samamashta piinifo. Nanscarifiai Diosin tsain yoimisiton aton nomuran nanupaifiai aton nomuran fai curush cuscaracoin. Ascan Satanás ato tsain futsa yoiquin afanan Diosin tsain nicanonfoma ahuun ointi muran funomana. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Ascan futsafoan aton ointi toquiri cuscara. Ushu toquiri camaqui pacuni anoashu ahuun tapo chaimashta foanno samamashta fanafo nai cuyoni. Tsasi futsuni. Nanscarifiai futsafoan Diosin tsain tau huaquin nicaiyoi unimacoinfiashon samamashta ahuun tsain cachiquiri huatirofo. Diosin tsain nicafiacatan aton nomuran nanucoianfoma. Ascan ahuara chaca finonshon iyamarai omitsiscaifoanno afanan Diosin tsain nicapaitirofoma. Dios afanan tanapaitirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ascan un mato yoiai cuscan ushu futsa tasha muran foaicashu foaisharanima. Nanscarifiai futsafoan Diosin tsain nicafiai chipo ahuara futsa chaca shinanquin. Shinanchacafain pui ichapa noifain, “Un pui ichapayashuraca un isharatiroatin,” ishon amaquiri shinanquin. Diosin tsain afanan shinainma. Ascano Diosin tsain nicafiaquin ahuara futsa shinaintocai ahua Dios ashotiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ascanfiaquin ushu futsafoan mai shara ano saacano foaiquin yosiashu man fimi ichapa ya. Nanscarifiai futsafoan Diosin tsain nicacoinpaiquin ahuun tsain aton nomuran nanucointiro. Futsan ahuun tsain nanusharaino Diosin yoini cuscacoin atiro. Futsanri ahuun tsain nicacoinquin finacointiro. Futsanri fasi mima huacointiroran, —ishon Jesús ato yosiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ascano afanan ahuara futsan ato yosiquin isca huani, —Tsoancai faquishiaino oinpaiquin lamparina otashon cutipan fupotiroma. Tsoanricai oshati nanman huatiroma. Ascatama tapa camaqui huatirofo shafacafi oinsharanonfo. Nanscarifiai Diosin nocon imapaiyai cuscan apaiquicai non ahuun tsain casho muran iyamarai raniran futsa non onutiroma. Ascatama shafacafi oinsharatiro Diosin yoia cuscan huafain. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ascashon non shinanmisi cuscan noco nantifi Diosin puashoshquin. Tsoancai afanan ahuarashta fomantiroma. Diosin nantifi yorafoti aton ointaifi puashoyoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Man pafiqui yaquin ua nicasharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ascacun oinfain. Uhuun tsain nicasharacahuun. Amaquiri nicayamacahuun. Un mato yoia cuscan aashquin. Ascaquin man fasi uhuun tsain tapicointiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Asca tsoan uhuun tsain nicasharai ahuun nomuran nanucoiainno Upa Diosin mima huacoinquin tapimashquin. Ascan tsoan uhuun tsain nicafiai un yoia cuscan aiyamashu nan cuscarafo nantifi funocani. Upa Diosin funomanano ahuashtayacanimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ascatan afanan ahuara futsan ato yosini. —Ahuu cuscaramain Upa Diosin nantifi iquinnaquin un mato yoicain. Nocofunun ahuun mau ano ushufo fana. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Shafatifi non yamutifiri nan ushufo foaicaino yosishara. Ascan mau ifoancai nan ushufo foaimatiroma shafatan yafi yamuri afi yositiroquin. Ahuuscashumain afin foaitiroquin non tapiama. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mai muran ushu foanno iquisi ahuun tapo foaitiro. Ascashu chipo shuqui fimi ya itiro. Ahuun unutani shuqui choshitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ascan shuqui choshiano mau ifoan shuqui samamashta chituntiro. Nanscarifiai tsoa icoinra huamafoan icoinra huacani itisharacani samamashta Diosin mai ano nocotiro nantifi iquishquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ascatan afanan Jesús ato yoiquin isca huani, —¿Ahuuscashomain un mato yositiroquin Diosin ahuun yorafoti yonofain iquinaquin? ¿Rato tsain futsacaimun un mato yosicain man tapinon ahuu cuscaramain Upa Diosin nantifi iquinaquin? Ua nicacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza ushu uhuapamashta. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ascafia yosiashu fasi uhuapacoin itiro. Rato ihuicai mostazatioma. Ahuun tushpafori fasi uhuapacoin. Ahuun tushpahuu puiya futsa futsatapafo tsaotiro. Nanno mostaza ahuun puifoan ahuun tushpafo ihuaquin futsa fari tsacanonma. Nanscarifiai Diosin icoinra huaafo tau huaquin ichapamaton nicayotirofo. Chipo fasi ichapafain tanacointirofo Diosqui nocosharashcaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ascatari tsain futsahuunoa ichapa ato yoini ato tapimanon. Afohuunshon ato Diosin tsain tapimani. Tapitirofo cuscan ato tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ahuarafo ato yosipaini tsain futsahuunoa nanfotisi ato yoini. Ascafia chipo afu rafumisifo atotisi tsain futsahuunoa shafacafi ato yosini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ascatan man fari caino Jesús afu rafuafo yoini, —Ianmanhuan oquiri non fonon, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ascaino yorafomaquishon afu rafumisifoan Jesús ianmanhuan oquiri iyonifo. Chipo atirifiton mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Shashon pocuaifono atoqui fuuhuan noconi. Fuchomanhuaino unu fospini. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ascaino Jesús shasho tsispacamaquinoashu oshano afu rafumisifoan moinnifo. —Nocon tapimamisiton moihuu. ¿Min noco shinainmamun? Man non asai futsuicai, —ishon moinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Asca huaifoanno moinacahuatan ninacahuan fuu nishma huani. —Fuun nishmahuu. Fuchomanhuan pusiyamahuu, —Jesús huani. Asca huaino fuun nishmafainaino ian pusiquima racani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Afu rafuafo yoiquin isca huani, —¿Ahuuscain man ratu ain? Un ahuamamishti huatiro mancai icoinra huataimacai, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ascaino aton nomuran fasi shinancani, —¡Aira! ¿Ahuu cuscara nocofunushonmun nocon Ifon? Na fuuhuan yafi ian fuchomanhuan nan yoiai cuscan huaaquin. Man nishma hua, —icashu afu rafuafo yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ascano ianmanhuan pocufainifo. Gerasafoan aton mai ano fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nocotan Jesús mapufaini. Ascaino nocofunu yoshin chaca ahuun nua aqui noconi. Mahua quini muran naafo mai huapaonifo murannoashu aqui noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Nan nocofunu mahua quini muran ipaoni. Yorafoan cunopan munushfain onushfain huafiafo cuno tusaqui futsani. Tsoan afanan achitiroma munushfain onushushquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yamutifi yafi shafatifiri mahua quinifo muran icain machi ano cahuacacaipaoni. Nannoashu toquirinin afiri tsacai futsuni fiisiyanan. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesús chaicunoa fuchitan aqui ichoni. Ichotan fuopacucahuatan. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ascano Jesús yoini, —Minfin yoshin chacacoinquin. Na nocofunumaquinoashu catahuun, —huaiton. —¿Mian ahuusca huapaimun, Jesús? Diosin nai muran icaton ahuun Facufin minquin. Diosinhuunshon yoihuu min ua omitsisca huamashquima. Yoipun, —nocofunun yoshin chaca ahuun nuaton yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ascaino amaquinoashu cataima Jesús yocani, —¿Min ahuunumun? —ishon yocaiton. Yoshin chacanun cumani, —Uhuun anufin ichapaquin. Urus fusticai na nocofunu muran un icama. Un fu yoshin chaca ichaparasi amuran ica. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mai futsa ano noco nichiyamapun, —huariani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Na machi mananunshon yahua inafoan picaniquin. —Ato muran noco nichipun, —yoshin chacafoan huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Yahuafo muran fotacahuun, —Jesús ato huani. Asca huatanaino nocofunumaquinoashu dos mil yahuafo muran fonifo. Yahuafohuun nuui focani. Ascaino nantifi yahuahuanfo ian muran maocofainni. Ascashu asai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ascaifoan oinfaincani yahuahuanfo cushumisifo ichonifo. Pushurasi ari chani focani. Pasohuatofori chaninifo. Ascaiton nicacani yorahuanrasi yahua asai futsua oinpaicani funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Fucaquin oianfo Jesús yafi nocofunu ahuun yoshin chacafo a muran imisi tsaoa ini man amaquinoa Jesús yoshin chacafo potano. Afanan imisi cuscan chitoria inima. Man sahuuti sahuua. Afananricai nison inima. Shinansharacoinni. Ascaiton oincani ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ascashon atirifoqui chaninifo nan oianfo cuscan huafain chaniaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nicacaquin Jesús isca huanifo, —Nocon mai anoashu catapun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Asca huaifono Jesús shashon nanucaini cani. Nanuataima, —Uari iyoicapun. Un mifu capaicai, —a yoshin chaca amaquinoa potaton huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Ma. Min pushu ano cashon min yorafo yoitahuun. Upa Diosin mia ashoan cuscan huafain minhuun ramapaia cuscan ato yoitahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Asca huaino cashon Jesús aca cuscan mucu rafuti pushurasi ano yoifoanfafaini. Ascaiton nicacani, —¡Aira! ¡Nicacapon! Tsoan anori nicayomisimaran, —icanashu nantifi yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ascatan Jesús fu afu rafuafo afanan ian mahuan pocufurannaino yorahuanrasi cusumun aqui noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ascaifono Judiofoan ichananti pushu anoa aton niaifo ahuun anu Jairo Jesús fuchitan fuoshopacucahuaquin yoini, ");
INSERT INTO mcdNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Uhuun facushta isinin ishoinquin. Uhuun pushu ano ufu capun. Uhuun facushta ua maiatashoshquin cayanon, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ascatan cani. Ascaino yorahuanrasi afu fonifo. Focani fasi yuruinfainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nannori ainfo imi imitiani atofu cani. Doce fari man aqui caano nusuyamacai. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doctor rasi ano cata cataquin nantifi ahuun pui ato inanquin anaitini. Ascafiashu cayatamarocon finacoinni. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ascano Jesushuunoa yoiaifoan nicaquin ainfoan acachorishon ahuun sahuuti muunniquin cayashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Un ahuun sahuuti muuanshuraca un cayatiroati, —ishon ahuun nomuran shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ascatan aqui mupiashu imi shatariscatani. Afanan isinin inima. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ascano Jesús ahuunoashu ainfo cayano yorahuanrasi muran ifiacucahuan ato yocani, —¿Tsoan ua muamun? —ishon ato yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ascaiton cumanifo, —¿Min oianmamun yorahuanrasiton mia yuruacafo? ¿Ahuuscaquimun min noco yocaicain? —a fu rafumisifoan huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ascaifoan Jesús ato oiancuni, —¿Tsoan ua muamun? —ini tapipai. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ascaino ainfo man caya huaa tapiashu ratui fuopacucahuaquin. Nantifi ahuunoa imisi cuscan yafi ramashta acai cuscari yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nicaquin yoini, —Achishtan, mian icoinra huashu min cayaquin. Ratuyamahuu. Min ointi muran unimahuu. Min afanan omitsiscaimacai. Min pushu ano casharatahuun, —ishon Jesús ainfo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús tsaincaino Jairo pushu anoashu futsanfo aqui fucashon yoinifo, —Min facu man naaquin. Non ahuusca huatiromaquin. Nocon tapimamisi afanan catima huayamahuu, —ishon futsanfoan Jairo yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús Jairo yoini, —Aton tsain nicayamahuu. Ratuquima. Ua fusti icoinra huahuu, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ascano Jesús yorahuanrasi nichitan, —Pedro non Juan non Santiago non atiri ufu fucahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ascatan Jairo pushu ano nocoquin nica amurannoashu uaicani shorarascanifo manocani. Ascaiton Jesús oinni. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ointan pushu muran iquicaitan, —¿Ahuuscain man shorarascaimun? Na facucai naamafinquin. Oshafinquin, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ascaiton osanifo. Osaifoan ato chifi caimatan apa yafi ahua non afu rafuafo rafu non fusti cunu futsa muran ato iyoni. Nanno shotocofacu doce fari aqui caa. Raca ini. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús shotocofacu mutsoinifoan yoiquin, “Talita, cum:” Onicoinnin tsainmanfin “Facushtan, funinaca huanhuun,” huaino. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Samamashta funinaca huanaino apa yafi ahua mustairinifo. Ascatan, —¡Aira! Nocon facushta afanan man funia. Oianmaquicai non icoinra huacuanamaran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","—Maton facu man naacoinfiacun un funimana tsoan yoitama piimacahuun, —Jesús apa yafi ahua yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ascatan Jesús afu rafumisifo ya anoashu pushurasi ano nasonifo. Nannoashu Jesús pushconi. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ascano Israelifoan aton tunutitian Jesús aton ichananti pushu muran iquishon ato yosiaiton. Nicacani, —¡Aira! ¡Nicacapon! ¿Ahuuscain na nocofunun fasi tapicoin sharamun? Tsoan oinyomisima cuscara huapaiquifin ahuamamishti huatiroquin. ¿Tsoancon Jesús ascara yosiamun? ");
INSERT INTO mcdNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nanfin ihui yonomisiquin. María facu. Chipocufo Santiago non José non Judas non Simón. Ahuun poifori nuno no fu imisifo. Nonfin Jesús onanquin. Aacai ahuama. ¿Ahuuscashomun ahuamamishti huatiroquin? —icashu yoinannifo. Nannori shinancashon aqui shinanchacanifo. Acai cuscarocon huacani. Afanan Jesús nicapainifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ascano Jesús ato yoini isca huaquin, —Nan maitio Diosin tsain yoimisi nicatirofo. Ahuunoa yoisharamisifo. Nan cainni anoafo non ahuun yorafoancai nanfoansicai nicapaicanimaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ascano isinin icaifo fustirasi manmanshon ato cayahuamani. Futsafori cayahuamapaifiaquin icoinra huayamaifoan anima. Diosihuunshon tsoa futsan atiroma cuscan ato ashopaifiaquin anima. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","—¡Aira! Ahuunscain ua oinfiamisishaquin ua icoinra huapaicanimaran, —ishon Jesús shinanni. Ascaiton pushurasiti Israelifo icano cahuancacaini ato Diosin tsain shara yosin. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ascatan afu rafuafo doce cunani, —Uqui fucahuun, —ato huaino. Aqui fuafoan ahuunshon yoshin chacafo yorafohuun nuucun atomaquinoa potanon. Ascashon ato rafurasisi nichini yorafo caya huamanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ato nichiataima ato yonoquin isca huani, —Maton tushu foyamafain maton forusari foyamafain puin foyamafain maton sapato nan man sahuua fusti fofain maton sahuuti nan man tsahuua fusti ya fotacahuun. Poquiti fusti ya fotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pushurasi muran nocotan nan pushu fusti muransi oshacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pushu futsan icanoafoan yafi pushurasi muran icanoafori mato iquimapaiyamaino iquiyamacahuun. Mato nicacasmaifoan maton sapato potapota sacaquin. Asca huaquin man oinmatiro mato nicacasmaifo. Ascan Diosin tsainri nicacasmacaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ascano ato yoiquin anaitiano pushurasiti anoafo ato yoifoanfafainifo. —Maton chaca shatucahuun Diosin tsain nicasharacahuun, —ato huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yoshin chacafo yorafohuun nuucun atomaquinoa potanifo. Isinincaifori shuniyashon fumanfain Upa Dios cufishonifo Jesushuunshon caya huafoanfainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Ascatan Jesús ahuamamishti atiro cuscan nantifi yora nicacani. Ahuunoa yoifoanfafaini. Atirififoan yoinifo, —Jesusfin Juanquin nan ato unu muran iquimamisiquin. Afanan man funia. Ascacufin tsoan atiroma cuscan Jesús Diosinhuunshon ahuamamishti huatiroran, —icashon atirifiton yoinifo. Atirifoanri yoiquin, —Jesusfin Eliasquin, —huanifo. Atirifiton yoini, —Jesús Diosin tsain yoimisiquin. Nocon caifo Diosin tsain nocon shunifoan yoini cuscan Jesusri nanscacoin huaquin yoiaran, —ishon yoinifo. Ascano niaifon Herodes afo nicashon yoini, —Naanfin Juanquin. Mun tushtufiati afanan funiaran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Juan Herodes rutuataima yoini, —Niaifon Herodes, min ushto Felipe ahuin, Herodiasi, min fian. Ascan mincai shara huama. Nocon shuni Moisés noco Diosin tsain cunushoni cuscan isca huani, “Futsan ahuin min fitiromaran,” ishon Moisés cununiran, —ishon Juanpan Herodes yoini. Anori nicacasmaquin ahuun ranushumuafo yononi Juan achishon cunu muran iquimanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodespan ahuin Herodiasin nicani Juanpan ahuunoa yoiaiton nicai aqui fasi sinai. Rutumariscapaifiaquicai ahuun funu Herodes, —Ma. Mincai Juan rutumatiromaran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juan nocofunu shara Dios tanasharamisi niaifon Herodes tapishon cushusharani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Funun cushusharafiaino ahuinin ahuuscashoma Juan rutupaini. Funun cainnitian Juan rututiro punin shararan. Isca huaquin. Cainnitian ahuun niaifofo patashari non ranushumua niaifofo non niaifofo Galilea mai anoafori ichanannifo fuusishoshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Piainfono Herodes ahuin Herodiaspan facu shomaya arusu mononi. Herodes yafi a futan piaifoan oincani fasi unimanifo. Ascano niaifoan yoini, —¡Aicho! Min monoaiton oin un fasi unimai. Ahuarashta fipaiquin ua yoihuu un mia inanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Diosin tapia un mia icon yoiaiton min fipaiyai cuscan ua yoihuu un mia inanon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nicatan shomayaton ahua yoini. —¿Un niaifo ahua yocaimun? —ahua huaiton, —“Juan tushtumahuu. Ahuun mapo ua inanshquin,” niaifon yoitahuun, —ishon yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ascano shomaya niaifoqui nasoni. —Juan tushtuhuu. Purato naratashon ahuun mapo ua inanshquin. Natian ua ashoriscahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nicai niaifon puusinima. Juan fasi shinain. Ahuun nomuran shinanquin isca huani, —¡Ohua! Un asca huapaima. Ascafia yorafoan un shomaya yoia cuscan nicacashon un asca huapaiyamafiaqui un aqui cairan, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ascaiton futsa yononi, —Juan tushtushon ahuun mapo ua fishotahuun, —niaifoan ranushumua yononi. Ascano cai cunu muran iquishon Juan tushtushoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tushtushon purato naratashon funi. Fushon shomaya inanni. Ascano shomayaton ahua inanni. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Asca huano Juanhuunshon tanamisifoan nicacatan focashon ahuun caya mai huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ascano Jesusqui afu rafuafo afanan naso furanifo. Acafo cuscan yafi ato yosia cuscari Jesús tapimashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ascaifono yorahuanrasi Jesusqui furi furinifo. Ascaquin ato pitimacoin huanifo. Afu rafumisifo yafi ato yoini, —Tsoa icama ano non fonon focahuun. Anoshon non tunuyonon, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ascano shashohuanun tsoa icama ano fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","34","Ascaiton yorafoan ato oinnifo. Ascatan Jesús yafi afu rafuafo nocoataima ian cusumunri yorahuanrasi atoqui fuainfoan oin Jesús atohuun ramapaini. Ascashon Jesús shinanquin isca huani, —Chashohuanfo cushumisioma nanscarifiai na yorafo cushumisiomaforan, —ishon shinanniquin. Ascashon ato ichapa yosini. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ascano man fari caino afu rafuafoan yoinifo, —Nuno pushu yafi tushu yamai. Na yorafo nichihuun. Man fari caiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Fonaincaniquin pushurasi ari yafi pushu patashari ato nichihuun anoshon tushu huanonfo, —ishon Jesús yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Mafin ato piimacahuun, —ato huaiton. —Noncai ahua ato pimatiroma. Nocofunun oshu ranan yonoahuunshon ahuun rafanan fishon nan yorafo pimashquin. ¿Nantimun non atohuunshon potaicai? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Ahuuti misi man ayamun? Oinyocahuun, —Jesús ato huaino. Oinshon yoinifo, —Misi mucu fustiti yafi shiman rafusi non ayaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Nicatan Jesús ato yononi isca huaquin, —Ato yoicahuun futsano cincuenta tsaohuaifono futsa anori cien tsaononfo, —ato huani. Ascano yorafo faasi camaqui tsaoacunifo. Ato yonoa cuscan tsaoshoacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ascaino nan shiman rafu yafi misi mucu fustiti tsomashon nai ari foisinifoantan Apa Dios cufini, —¡Aicho! Upan, mihuunshon un ato pimaicain. Min fasi sharacoincun, —huatan. Misi torupacutan shiman rafu ya osishon ahuunshon tapimisifo ato pashcanan huapani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ascaino picani mayacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A misi yafi shiman tushu huafo afu rafuafoan doce shihuati fospi huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ascano cinco mil nocofunufoan piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ascano ato pimaquin anaititan Jesús afu rafuafo yoini, —Shashon rufofo oquiri pushurasi Betsaida ano pocui focahuun. Un na yorafo nichiyonon, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ato nichitan arus fusti machi mamaqui caashu Apa Dios fu tsainni. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Man fari caino afu rafuafo ian nushmancayan shashon nocoaifono arusu ian cusumunshon Apa cufiyoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Ato oian ian nushmancayashon fuun huaquin ato catima huani. Man faquishiaino Jesús ian fumancayan atoqui cani. Ato finonquin rashquini. Ascaitocai onannifoma. Onanshma ratucani. —Yoshin shafain, —fiisinifo. Ascaiton —Unquin. Ratuyamacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ascatan shasho muran atoqui nanuinacahuani. Nanuano fuu nishmapacufoanni. Ascaiton afu rafuafoan, —¡Aira! ¿Ahuuscashocon Jesús isca huaimun? —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tapiyonifoma Jesús Diospan facu ahuamamishti huatirofiacun cinco mil nocofunufo piimaiton oinfiaitashacaquin Jesús onanyonifoma. Diospan facufiacun aton nomuran tapiyonifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ascatan ian pocufainifo Genesaret cusumunri nocoshon. Nanno shasho nushanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ascatan mapuinifoannaifoan nannoafoan samamashta Jesús onannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Onantan ichonifo pushurasifo patashari chani focani. Isinin imisifo shuhua naratashon Jesusqui ihuunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nantiocushon isinin icaifo aqui ihuunifo. —Uhuun yora isinin icaiton min sahuuti cupanan mia munpaicani. Ato yoipun anonfo cayashcaquiran, —ishon yoinifo. Ahuun sahuuti muuncanashu cayapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ascano Fariseofo yafi Moisés tsain tapimamisifori Jerusalén anoashu Jesusqui fucashon. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Oianfo Jesús fu rafumisifo piataifoma muchoquimupaonifiacashon aton shunifoan yononi cuscacai anifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Israelifo aton shunifoan piataifoma aton fuuyamisi cuscan muchoquimupaoni. Ascan aton shunifoan apaonifo cuscan Fariseofo yafi nantifi Israelifoan nansca huamisifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tushu inanmistsamisifo anoashu aton pushu ano nococashon aton shunifoan apaoni cuscan atorifi piataifoma muchoquimunifo. Aton shunifoan ahuarafo futsa fuuyamisi cuscan nanfoanri nanscari apaonifo. Aton shunifoan cuchofo non aqui unu manutifo non paninrafori chocamisi cuscan nanscara fuuya huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ascano nanfoan Jesús yocani, —Ahuuscaquimun nocon shunifoan piataifoma muchocomushoma pipaonifo cuscacai mifu rafuafoan asca huacanima, —ishon yocainfoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ato cumani, —Isaías nan Diosin tsain yoimisiton iconcoin inaca cuscan matohuunoa yoini. Manfin fuparapaimisifoquin. Matohuunoa yoini isca huaquin, “Nan yorafoan uhuunoa yoisharafiacaquin aton nomuran ua shinancoianfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ipaitsi ichananshu fanaincani ua cufiyanan. A yorafo tapimapaiyai cuscacai uhuun tsainma. Nanfoan aton nomuran afi shinain cuscan aton yorafo yoicaniran,” ishon Isaías Diosin tsain cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Diosin yononi cuscan atama maton shunifoan amaquiri shinanmisifo cuscan marifi man ascamisi. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maton fuyamisi fusti man tanapai. Ascacucai Diosin mato yononi cuscan afanan man shinainma. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nocon shuni Moisés yononi isca huaquin, “Maton upa yafi uhua nicasharafain ato shara huacahuun. Tsoan apa iyamarai ahua tsain chaca huai ato rutumacahuun,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anori cunufiani man ato yoiquin, “Maton upa yafi uhua man yoitiro isca huaquin, ‘Upa futan uhuashtan un mato inanpaisharafiaqui un Dios inainran,’ ” man imisi. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Anori yoitacai Diosin yononi cuscan man ato yosima. “Maton upa yafi uhua cushusharacahuun,” mato huafiani mancai anori ato shinanmapaima. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ascashon Diosin tsain man ato tapimatamarocon maton shunifoan yonopaoni cuscan nan fusti man ato tapimapai. Asca huaquin Diosin tsainmaquin man ato imai. Nanscara chaca futsafori man huamisiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ato yoitan afanan Jesús yorahuanrasi cunani ato ahuara futsa yoishquin. —Uqui fucahuun un mato yoinon. Ua nicasharafain tapisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ahuarafo non piatocai nocon nomuran chaca huatiroma. Ascatama maton nomuran shinansharashoma ahuara man chaca huatiroquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ascatan yorahuanrasi anoashu cai pushu muran iquiano a rafuafo aqui funifo yocain fucani, —Min yorafo min tapima cuscan nocori shafacafi yoihuu non tapinon, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Ahuuscaquimun marifi man tapisharataimacain? ¿Man tapiamamun ahuara non piatocai nocon nomuran noco shinanchacamatiroma? ");
INSERT INTO mcdNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maton nomurancai tushu nitutiroma. Maton shaqui muranfin itiroquin. Chipo man aya poitiroran. Nantifi tushu sharafin non pisharatiroquin, —ishon ato tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Maton nomuran man shinanchaca cuscan man yoitiro. Nanfohuunoa shinanquin man chaca huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yorafoan aton nomuran ahuara shinanchaca cuscan huatirofo. Isca huaquin, shinanchacafain nocofunu yafi ainfo chaca huatanantirofoquin yomutso icain rutumitsapaimisi icain aton ahuinma chotafain aton funumari chotamafain ");
INSERT INTO mcdNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Futsana fianpaifain chaca futsa futsatapafo huafain paramitsamisi icain rafipaitama ahuara chacafo huafain man ahuarayafiashu ahuun unimatama futsa fuchipaifain futsaqui tsain chaca huafain cacapaimisi icain Diosin tsain nicacasmamisi. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Na chacafo aton nomuranshon shinainfo cuscan ato chaca huamashquiran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ascatan Jesús nannoashu pushurasi ahuun anu Tiro chaimashta caani. Caashu pushu futsa muran iquini tsoa tapimapaima. Ascafiaiton samamashta nanno icafoan nicanifo pushu muran icun. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ascano ainfocai Israeli anoa shafo inima Sirofenicia anoa ini. Nan ainfoan nicani Jesús oaiton. Ascatan aqui iquicaini nan yoshin chaca ainfacuhuun nuucun. Jesús cufini, —Ifon, uhuun facu shotocofacushta fasi omitsiscai. Yoshin chaca ahuun nuua. Na yoshin chaca amaquinoa ua potashohuun. Uhuun facushta ua cayahuashopun, —ishon yoiriani. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ascaino Jesús yoini, —Uhuun yorafo un ato tau huamanon. Tsoancai facufo aton tushu fiantan pashnafo potatiroma, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Ai, Ifon. Mian yoia cuscan icon. Ascafia facufoan piqui tushu huafo sapa camaquinoashu potomishti pacuaiton pashnafoan pitirofo. Nanscarifi huaquin min yorafo min caya huamayotirofiashon nocori min caya huamatiro. Min nocori caya huainocai min caifori funotiromaran, —ishon cumaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—¡Aicho! Mian cumasharaquin. Natian min pushu ano min catiro. Yoshin chaca min facumaquinoashu man caaquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ascano ahuun pushu ano nocoshon oian ahuun facu shara racaini man amaqui yoshin chaca caano. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ascano Jesús Tiro anoashu cai Sidón finonfaini ianmanhuan Galilea cusumunri cani. Cai pushurasi anoafo aton anu Decápolis ano noconi. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nannoa yorafoan nocofunu tsaintiroma icain nicatiroma aqui ihuunifo. —Nocon yoran nicatiromacoin noco manmanshohuun, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ascaiton Jesús nocofunu nicatiroma atomaqui chaimashta iyoni. Iyoshon ahuun mutotinin ahuun pacho rafu munni. Ascashon cumo michotan ahuun mutotinin ana munni. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ascashon nai ari foisinifoantan fasi shacaitan yoini, “Efata,” Onicoinnin tsainmanfin: “Cayasharahuu,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ascano nocofunun nicasharariscani. Tsain cayacafi shara ato yoini. Afanan ahuun ana curushma. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ascano Jesús yorahuanrasi yoini, —Un nocofunu nicatiroma caya huama cuscan tsoa yoiyamacahuun, —ato huafia nantifiton yorafo chanifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","—¡Aira! Jesús acai cuscacai tsoan oinyomisima. Ahuamamishti huatiroquin. Nantifi yoinifo cuscan fasi sharacoinquin. Yoran nicatiroma caya huamafain tsaintiromafori caya huamaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ascatan nantianri afanan yorahuanrasi Jesusqui funifo. Ahuun tsain nicacaquin ahua piinifoma. Ascano afu rafuafo cunani ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Un nan yorafohuun ramapai. U fu rafu non fusti oshatan nuno icafo. Natian aton tushu man cuyoa. Ahuashta pitirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Atirifi chaicunoashu nuno fuafo. Ascacun un aton pushu ano nichicain fasi fonaincani napuitirofo tacayomancani, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Nuno tsoa icamano non tushu fuchitiroma nan yorahuanrasi pimashquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Ahuuti misi man ayamun? —ishon yocaiton. —Siete non ayaran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anori yoiaifoan Jesús nan yorahuanrasi yoini, —Nuno tsaocahuun, —ato huani. Tsaoafono Jesús misi siete tsomashon Apa Dios cufiyoni, —¡Aicho! Upan, minhuunshon un ato pimaicain. Min fasi sharacoincun, —huatan. Misi torupacutan afu rafuafo inanni. Inanno yorahuanrasi pashcananpacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Shiman uhuapamamishti fuchishon Jesús inanfoanno Apa Dios afanan aicho huatan shimanri torupacutan afu rafuafo inanni. Inanno yorahuanrasi pashcananpacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ascashon picani mayacoinnifo. Ascashon a tushu huaafo siete shihuati fospicoian ini. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cuatro mil yora icuanafo nanno inifo. Piafono Jesús aton pushu ari ato nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nanucainicai a fu rafuafo fu mai futsa ahuun anu Dalmanuta ari cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nocoafono Fariseofo Jesusqui funifo yocain fucani. Fochishmanantananpai funifo. —Minmain Diospan facucoinquin Diosin nai ariashu icahuunshon tsoan atiroma cuscan noco ismahuu non mia icoinra huanon, —ishon yocacaquin chaca huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ascaino Jesús fasi shacaini. Ascashon ato yoini, —Ahuuscain tsoa futsan atiroma cuscara man oinpaifafainiquin. Un mato icon yoi. Diosin fustiton atiro cuscacai un mato ismaimaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Asca huatan ato anoashu afanan shasho nanucaiquin ian pocufaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ascano ian pocufain cashon afu rafuafoan yoini, —¡Ohua! Non ointiaquima. Non tushu fuamaran, —huanifo. Ascashon misi fustishta shasho murannoa fuchinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","—Oinfain Fariseofo yafi niaifo Herodes aton misi faranshati piyamacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nicacani yoinannifo, —Ahuuscain Jesús noco yoiai Fariseofo non Herodes aton misi faranshati piyamacahuun. Non tushu fucunma anori noco yoiran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yoiaifo cuscan Jesús onanshon ato yoini, —¿Ahuuscaquimun tushuhuunoa man yoinaincain? Mancai ua tapisharataima. Maton ointi muran curushcoin uacai man icoinra huataima. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Man oinfiaquin man tapiama. Nicafiaquicai man nicacoianma. ¿Un mucu fustiti misihuunshon cinco mil nocofunufo pimaita ahuuti shihuati misi fospicoinyamain tushuitaquin? —ishon ato yocani. —Ascano doceran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Un siete misifo un cuatro mil yora pimaita. ¿Ahuuti shihuati misi fospicoinyamain tushuitaquin? —ishon ato yocaiton. —Sieteran —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Ascan ahuuscain man tapiataimamun? —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ascano Betsaida ano noconifo. Nannoafo nocofunu fushocoin Jesusqui ihuunifo. Ihuunshon yoinifo, —Ifon, nocon yora fushocoin noco caya huashopun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ascano Jesús fusho mutsoinifoantan pushurasi pasoato iyoni. Nannoshon ahuun furoqui cumo michotan ayashon furo muunni. Ascashon yocani, —¿Min oinsharaimun? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Foisinifoantan, —Ai. Un yorafo oin. Matacoin. Ihui foro cahuanai ointsa, —ishon cumaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Afanan furo munni. Ascano oinsharacoinni. Man cayahuamacoian. Shafacaficoin nantifi oinsharani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","—Pushufo ari cayamahuu. Min pushu ano cayacafi catahuun, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ascatan Jesús yafi afu rafuafo anoashu focani Cesarea de Filipo pasoato pushurasifo ano fonifo. Foaifoan Jesús ato yocani, —¿Yorafoan man shinanmun un tsoaquin? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Cumanifo, —Futsafoan yoiafin min Juanquin. Nan ato unu muran iquimapacumisi. Asca futsafoanri yoiafofin minfin Eliasquin. Asca futsafoanri yoiafin minfin nocon shunicaifoan Diosin tsain yoimisiquin. Man min afanan funiaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Anori uhuunoa shinanfiafonomun manri shinanmun un tsoaquin? —huaiton. Ascaiton Pedronun cumaquin, —Minfin Cristoquin. Upa Diosin mia catonni nocoqui nichishquiran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Un Cristoqui tsoa yoiyamacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ascatan ato yoiquin tau huani, —Nocon caifoan Dios fu tsainti pushu cushumisifo non Moisés cununi cuscan tapimamisifo non yorafohuunshon Dios cufimisi niaifofoan ua omitsisca huashcaniquin. Nan nocon niaifofoan ua nicacasmacaquin ua rutumashcani. Ua rutumafiafo osha rafu non fusti finontan un afanan funishquiran, —ishon ato tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anori shafacafi icaiton Pedronun Jesús pashaquifain yoini, —Ifon, ascaiyamahuu. Miacai rutupacunacafoma, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús tapacucahuan afu rafuafo oinyoni. Ascatan afanan ifiacucahuan, —Satanás uhuunoashu catahuun. Upa Diosin ahuun nomuran shinain cuscacai min shinainmacai. Anori min shinantama nocofunufoan shinain cuscan nannori min shinainran, —ishon Jesús Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Asca huatan yorahuanrasi yafi afu rafuafori cunani, —Uqui fucahuun un mato yoinon. Tsoan ua tanapaisharaquicai afin apaiyai cuscan huatiroma. Un yoiai cuscafin nicatiroquin. Tsoan ua tanapaiquin isca huatiro, “Ua rutufianfoannocai un uhuun Ifo potapacunacama. Ahuunshon ua rutufiainfoanno un tanapacunacaran,” ishon yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ascan tsoan yoiquin isca huai, “¡Ohua! Un Jesús tanaino uaraca rutucaniquin,” ishon yoitan. Ascashon uhuun tsain cachiquiri nan cuscara yora naashu omitsiscapanaca. Ascan tsoan uhuun tsain futsafo yoiaifin uhuunoashu rutushquiquin. Nan cuscara yora uhuunoashu naashu unfu isharapacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ratoranfo manifoannati ahuunacoinfiano naanocai afanan ahuunacoin itiroma. Nantifi funocointiro. Niyoshon Diosin tsain tanatama imisishaquin. Ahuun nomuran omitsiscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ahuun yoshin nipanoncai ahuara inantiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yorafoan fasi chaca huamisifo. Upa Diosin tsain cachiquiri huaafo. Tsoan uhuun rafipaiquin uhuunoa yoicasmai uhuun tsainhuunoari yoicasmaiquin. Chipo un uhuun Upa Diosinhuunoashu un nai murannoashu mai ano un fotoaino uhuun Upa cuscaracoin un chasha curannaino uhuun Upan oinmati afu ica sharafori ufu fotoshcaniquin. Fotoshon nan uhuun rafiaifofin ua Ifo huapaicanima. Uhuun tsainri yoicasmacani unrifi un atohuun rafitiro. Afocai “Uhuun yoraran,” un huanacama —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Afanan ato yoiquin isca huani, —Icon un mato yoinon. Man futsan nuno ufu niaton nayoshoma Diosin ahuamamishti atiro cuscan man oincain. A icano ahuu cuscaramainquin man oincain, —ishon ato Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Asca huatan seis osha finontan Jesús Pedro non Santiago non Juanri machi cuya pochinin iyoni. Nanfo fusti nanno ini. Nannoashu aton ointaifi Jesús ahuun caya mumacoin sahuutifoya fianananriscatanaino ahuun sahuuti oshopacoin chashacoinni yoa rama furoamua ointsa iriscatani. Tsoacai sahuuti ya ascatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ascaino Moisés yafi Elías nitariscatan Jesús fu tsainnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ascaiton Pedron yoini, —Tapimamisiton, nuno non isharatiro. Non pushu facu rafu non fusti mato huashotiro. Mina futsa non Moisésna futsa non Elisna futsa. Santiago futan Juanpan non mato ashotiroran, —ishon Pedron yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Raquirira huapaifiacani ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ascatanaino naicoin atoqui cuyopacuni. Naicoin murannoa ahuun oi nicanifo, —Nanfin uhuun Facuquin. Un ahuun noi. A nicacoincahuun, —Upa Diosin huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Asca huatan nan rafu non fusti samamashta oinnifo Moisés yafi Elías yamariscatani Jesús fusti atofu nia ini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ascano machi cuya pochininnoashu fotoshon Jesús ato yoini, —Man rama oian cuscan tsoashta yoiyoyamacahuun. Nan naashu un afanan funiano rama man oian cuscan man yorafo yoitiroquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ato yoia cuscan tsoa futsa yoiyonifoma. Tapiamafiashu yoinannifo, —Ahuacon Jesús noco yoiamun naashu afanan funishquiran. Noco huaa cuscan non tapiamaran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ascatan Jesús yocanifo, —¿Ahuuscaquimun Moisés tsain tapimamisifoan yoimisiquin isca huaquin? “Nocon Numamisi Cristo Diosin catonni nocoqui oataima Elías rufofo nocoqui oshquiran,” —ishon noco yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","—Icon. Elías rucun oitautiro. Oshon nantifi isharamapai aton chaca shatunonfo. Ascafia tsoan onannima. Juanfiacun tsoan onannima. Nan chaca huapaiyai cuscan chaca huanifo. Nannori ahuunoa cununi cuscan. Nanscarifi aquin unfin Dios ariashu un nocofunucoin cainfianicun ua omitsiscamacani. Nannori Diosin tsain yoimisifoan uhuunoa cununiforan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ascatan machi tununman fotocatan yorahuanrasi nastui Jesús fu rafumisifo yafi Moisés tsain tapimamisifo fu fochishmanantanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ascano yorafoan Jesús fuchishon, —¡Oincapon! Jesús afanan oi. Tsoa futsacai a cuscarama. Ahuamamishti huatiroran, —icashu yoinannifo. Yoitan aqui ichonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—¿Ahuuscain Moisés tsain tapimamisifo fu man fochishmanantanainmun? —ishon ato yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ato yocaiton nocofunu futsa cumani, —Tapimamisiton, uhuun furonanfacushta un mia ihuushona. Yoshin chaca ahuun nuucun tsaintiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Achitan mipuani ahuun ashfapan facoshurasi atsispomumisi. Shucurushui futsutan charishi futsua. Uhuun facushta mifu rafuafo ano un ihuufia ua tsoa caya huamashotiromaran, —ishon nocofunun Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ascaiton Jesús, —¡Ohua! Mancai ua icoinra huaima. Man fasi amaquiri shinanmisi. ¿Ahuutia un matofu ipamun ua man nicayamacaiquin? —Jesús ato huani. —Min facu ua ihuushonhuun, —Jesús apa huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ihuuafono yoshin chacanun furonanfacu musta mustaimani. Ascatan taramuacucaini facosh atsispomutan pacuni. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ascashon Jesús apa yocani, —¿Ahuutiamun iscamisiquin? —ishon yocaiton. —Nan facuaitian tauniran, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Yoshin chacanun uhuun facu chi muran potafain unu muran man potamisi rutupaiquin. Min uhuun facu ua caya huashotiromainquin nocohuun ramapaihuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¿Ahuuscain mian anori huaimun? Tsoan ua icoinra huacoian un ato ahuamamishti ashotiro, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—Un mia icoinra huai. Ua paratama icoinra huamahuu, —ishon apa yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ascano yorahuanrasi oinpai atoqui ichonifo Jesús yoshin chaca curushcain yoini, —Minfin yoshin chacaquin. Nan facu min pastomafain tsaintiroma. Amaquinoashu catahuun. Mincai afanan a muran ipanacamaran, —ishon Jesús yoshin chaca curushcain yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Asca huaino yoshin fiisicaini cani. Facu musta mustaimafaini amurannoashu cani. Ascaino oianfo furonanfacu naa shinantsacun yoinifo, —Man facu naaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ascafia Jesús furonanfacu mutsoinifoannaino funininacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ascashu Jesús pushu muran iquini. Iquiano afu rafuafo aqui funifo. Ascashon yocanifo, —¿Ahuuscashomun nofi non yoshin chaca facumaquinoa potatiromaquin? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Na cuscara yoshin chaca man Upa Diosin cufinyamaquicai man potatiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ascatan anoashu Jesús yafi afu rafuafo Galilea mai finonfaini. Nantian afu rafuafosi tapimani. Ascashon tsoa futsan tapimayopainima. Ato yoini, —Un mato yoimisi cuscan un Dios ariashu mai ano fotoni nocofunucoin cainshquin. Ascafiacun futsan ua achimashquin ua rutunonfo. Ua rutufiafo osha rafu non fusti finontan un afanan mai murannoashu funishquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ato yoifiaiton tapinifoma. Ratucaquin tsoancai afanan yocanima. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ascatan Capernaum ano noconifo. Pushu muran iquicashon Jesús afu rafumisifo yocani, —¿Ahuuscai fai anoashu man fochishmanantanainmun? —ishon ato yocaino. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Fuaifoan yocani, Ratocaimun fasi shara finacaiaquin fochishmanantanancanashu rafinifo tsoancai Jesús cumanima. Puusinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Puusiyamaifoan Jesús ato onanni. Ascashon tsaoshon ato yoini, —Nicasharacahuun un mato cayacafi yoinon. Tsoan ahuun yorafo fasi finonpaiquin nantifi yorafo aton oinmati itiroran, —ishon ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ascatan aton ointaifi ato nushmancayan facu nichipacufoanni. Ascatan chishto inifoantan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Tsoan uhuunshon facu cushusharaifin nanscarifi ua huaiquin. Nanscarifiai tsoan ua shara huaquin uhuun Upa Diosiri nanscari huairan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ascano Juanpan Jesús yoini, —Tapimamisiton, non oian nocofunun min anuhuunshon yoshin chacafo atomaquinoa potaiton. Nancai no fu rafumisima. Ascacun non yoiquin isca huai, “Mincai no fu rafumisima. Asca min yoshin chaca yorafomaquinoa potatiromaran,” ishon non yoiaran, —ishon Juanpan Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ascaiton Jesús cumani, —Na nocofunu shutiyamacahuun. Tsoancai uhuun anuhuunshon ahuamamishti yorafoan atiroma cuscan huaitocai uhuunoari tsain chaca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsoan noco nicacasmaquima noco futan aqui. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Un mato icon yoi. Tsoan ahuun nomuran matohuunoa shinanquin isca huaiquin, “Afin Cristo ahuun yoraquin. Ascacun un shara huairan,” ishon yoitirofo man nomiaiton mato unu ayamatiro. Mato ascara shara huacun Diosin inanpaiyai cuscan funotiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ua rama futsa icoinra huafiacun futsan chaca huamaiton nancairocofin toquiri uhuapa tuhuumashon unuhuan noa muran potanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Asca huatan min mucuman ahuara chaca huai mifiri min mushatumua shara icuana. Mucu rafuya omitsiscapanacafo muran catama mucu fusti ya Upa ari min nocotiro nipashquin. Nan shara. Omitsiscapanacafo muran a chicai nocanacama. Nanscasi apanaca. Acai sharama. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nanscarifi aquin min tau rafu yashon min raquira capai ahuara chaca huapai mifiri oshatumua shara icuana. Min tau rafu ya omitsiscapanacafo muran catama min tau fusti ya Upa ari nocotiro nipashquin. Nanscara shara itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Nanscarifi aquin ahuara chaca oinquin min ahuara chaca huaiton mifiri min futsucumua shara icuana. Min furo rafu ya omitsiscapanacafo muran catama min furo fusti ya Upa ari min nocotiro nipashquin. Nanscarafin shara itiro. Nan chi uru muran caashu fasi min omitsiscacointiroquin. Nanscasi apanaca. Nan chiicai nocanacama. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tsoancai anori capanacama. ");
INSERT INTO mcdNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ascan sao fasi shara itiro. Nami saomua funa payocotiroma. Ascan saomui chacano nami payocotiro. Nanscarifiai tsoa ufu rafushocai chaca huatiroma. Futsafori ua icoinra huamatiro. Ascafiaino tsoa ufu rafuyamaino afanan chacacoin itiro. Ua futsafori afanan icoinra huamatiroma. Ascacun ufu rafupacucahuun. Fochishmanantanacaquima. Isharacahuun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ascatan anoashu a rafuafo afu Judea mai nan unu Jordán ocuma futsa fonifo. Ascano afanan yorahuanrasi aqui funifo. Amisi cuscan afanan Jesús ato yosinon. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ascano Fariseofo Jesusqui funifo. Aqui fucashon amaquiri cumamapainifo. Fuparapaicaquin. Ascashon yocacaquin, —¿Nocon shunifoan Diosin tsain cununi cuscan nocofunun ahuin unupaiquin unutiromun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Moisés ato yononi cuscan raquiri yoiamun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisés cunuquin isca huani, “Tsoan ahuin unupaiquin acataima cunushotiro isca huaquin, ‘Un afanan mia fipaima. Munfin mia unuicain,’ ishon yoitiro.” Anori Moisés ato yononiran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Maton shunifo mato cuscarari. Nanfo Diosin yonoquin tau huani cuscan nicacasmacani. Ascashon Moisés tsain futsan yononi cuscan maton shunifo cunushoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ascafiaino Diosin nocofunu yafi ainfon onihuashocai anori shinannima. Ato onihuaquin tau huani funu yafi ahuin potananonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ascano Diosin yoini isca huaquin, “Ascan nocofunun ainfo fiashu apa yafi ahuamaqui pashcatiro. Oshati fusti muran afu iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ascashu ano rafu niishcaquin. Fusti ica shinantsa aashquin. Afanan rafuma.” ");
INSERT INTO mcdNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ascacufin Diosin ato cumanan huaa afanan tsoa pashcanantiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ascano afanan pushu muran iquiano a rafuafoan Jesús yocani —Min rama yorafo yosia cuscan nocori yoihuu, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ascaiton ato cumani isca huaquin, —Ratoran futsan ahuin unuquin futsa fiishquin chaca huai ahuun ahuinma fu iquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nanscarifi aquin ainfoan funu unutan futsa fiishquin arifi chaca huaiquin funuma fu iquin, —ishon Jesús ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ascano yorafoan aton facumishti Jesusqui ihuunifo ato manmanpacuquin Upa Dios cufinon. Ascaifoan oinquin Jesús fu rafuafoan yoinifo isca huaquin, —Maton facufo ihuutan nocon Ifo fucash huayamacahuun, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Anori huafiaifono nicatama Jesús atoqui unimatama yoini, —Asca huayamacahuun. Facufo uqui funonfo. Ato nitun huayamacahuun. Uhuun Upa Diosin niaifo icanori facumishti cuscaraforiquin. Facufoan ua icoinra huacoinnafo. Nai muran Uhuun Upa icano nanscarifi aafoquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Un mato icon yoiquin. Facufoan ua icoinra huamisi cuscan tsoan nanscarifi aquin ua icoinra huashuma uhuun Upa niaifo icano afu ipanacamaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ato yoiquin facufo shatsaomushon manmanpacuquin, —Upa Diosin, na facumishti shara huahuu, —ato huapani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ascano nocofunu aqui ichotoshini. Ichotoshitan ratoconun mai chachishon yoini, —Tapimamisiton, minfin sharacoinquin. ¿Unmun ahuuscatiroquin Dios fu ipashquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—Ahuuscaquimun mian “sharacoinran” huaicai. Fusticoinfin sharaquin. Nanfin a Diosiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Diosin yononi cuscan min tapian. Isca huaquin noco yoini, “Futsa rutuyamacahuun. Maton ahuinma fu iyamacahuun. Ascanori maton funumafuri iyamacahuun. Ahuara onuyamacahuun. Chaniri yoiyamacahuun. Fuparayamacahuun. Maton upa yafi uhua nicasharafain ato shara huacahuun,” —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ascaiton cumani, —Tapimamisiton. Nantifi nan Diosin yononi cuscan facushon un nicainifoanna, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús oianan noiquin. Yoini isca huaquin, —Fustiricai min nicataima. Nantifi min ahuara ya cuscan inanmitsatahuun ahuun rafanan pui fiishon ahuuomafo inanshquin. Min asca huaiton Upa Diosin nai muranshon mia ahuara sharacoin mucushoshquin. Asca huatan ua tanahuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nicai nocofunu puusinima. Mafo ichapayashu ahuun mafofo inamitsacasmai puusinima. Ascatan Jesusmaquinoashu cani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Caiton oinquin tanatan ifiacucahuun afu rafuafo yoini, —Yora mafo ichapaya Uhuun Upa Dios niaifo ari atirifi nocotiroma. Aton mafo ichapa potacasmacaquin Diosiquiri shinanpaicanimaran, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nicacani afu rafumisifoan ahuun tsain tapipainifo. Ascano Jesús afanan ato yoini, —Uhuun facumishtichin, iconcoin mafo ichapayafo Dios icano fustirasi nocotirofo. Dios shinantama aton mafo fusti shinanfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ina uhuapa camellocai acoya shoi muran finontiroma. Mimacaifin nocofunu mafo ichapa ya Diosin niaifo ari fustirasi nocotiro, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nicacani ahuun tsain fasi tapipaicani yoinannifo, —¡Aira! ¿Mafo ichapa ya Dios fu ipatiromainquin tsoa futsamun Dios fu ipatiroquin? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús atoqui fusoacucahuan yoini, —Nocofunufocai afinri numatiroma. Diosin fustitofin yorafo numatiroquin. Diosifin ahuamamishti huatiroquin. Nocofunufoan atiroma cuscan Diosin huatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nicaquin Pedro yoini, —Ifon, nonfin nocon mafo yafi nocon yorafo nantifi nocona non pota furanaquin mia tanayoquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Un mato iconquin yoi. Tsoan ahuun pushu potafain ahuun ochifo potafain ahuun ushtofo potafain ahuun poifo potafain ahua potafain apa potafain ahuun facufo potafain ahuun mauri potafurashon ua tanapaisharatiro uhuun tsain shara futsafo yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nanscarafoan niyocashon Diosin ato fumimacoin inain. Pushufo non ochifo non poifo non ahuafo non facufo non maufori ato inain. Ato inansharafiaino ahuunoashu nantianri omitsiscashquin. Ascatan chipo Upa Dios fu ipasharashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ascafia yora ichapa natian isharacoinfiashu naashu funocoincani. Nanscarifiai atirifi natian ahuama shinantsa. Afo naashu Upa Dios fu ipasharashcaniran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ascano Jerusalén ano fonifo Jesús rucun caiton afu rafumisifoan mufainifo. —¡Ohuashta! Ahuuscain nocon Ifo Jesús Jerusalén ano caimun. Nanno musucoinran, —icashu yoinannifo. Futsafoanri mufainifo. Nanfori ratucoinnifo. Ascano Jesús fu rafumisifo doce futsa chaimashta ano atotisi iyoni atofu tsainshquin. Ahuara ahuuscarashquin fiaiton ato yoini isca huaquin, ");
INSERT INTO mcdNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Ua nicacahuun. Non Jerusalén ano canon. Nannoa futsan ua achimashquin nocon yorafohuunshon Dios cufimisi niaifofo yashon Moisés tsain tapimamisifoan ua tsain chaca huashcani. “Jesús ato fasi chaca huamisi. A rutucahuun,” icashu uhuun yoinanshon. Mani futsafoan ua iyoshcani ua rutunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nanfo uqui cashupaicain uqui paran nashquicani uqui cumo michofain ua fichi cunoquin tuchiaton ua coshashcani. Ua asca huacatan ua ihui coyan iquinanqui mastashcani un nanon. Ascafia osha rafu non fusti finontan Upa Diosin ua afanan funimashquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ascano Zebedeo facu rafutan Santiago futan Juanpan oinomashta Jesús yoinifo, —Tapimamisiton, non mia yocain cuscan noco ashopun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ahua man ua yocapaimun un mato ashonon? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Nantifiton niaifo min iqui nocori min icano niaifo patashari noco imahuu. Min yorafo yonoaitian min tsaoano non mifu tsaonon. Nocori catonhuun, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Ua man yocan cuscacai man tapiama. ¿Un omitsiscashquiain cuscan manrifi man omitsiscatiromun? —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ascaiton cumanifo, —Ai. Nonfin itiroquin, —huaifoan. —Icon. Un omitsiscai cuscan marifi man omitsiscaicain. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ascafia tsoanmain ua naqui huashu tsaotirofoqui uncai tsoa yoitiroma. Uhuun Upa Diosin fustiton tapia. Nan Upa Diosin catoan fosi nanno tsaotiroforan, —ishon ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiago futan Juanpan ato finonpaiyaiton Jesús naqui huashu tsaopainifo afu rafumisi diez futsafoan nicacanashu atoqui sinanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ascano Jesús ato yoini, —Uqui fucahuun un mato yoinon. Yora futsafo nocon caifoma aton niaifofoan ato curushcain yonofafainmisifo. Aton niaifo patasharifoanri ato yoimisi isca huaquin, “Nonfin mato ifoquin. Non mato yoiai cuscan man noco ashorisca huatiroran,” ishon yoimisifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Asca huafiamisifo mancai ato cuscara itiroma. Nan man ratoran futsa niaifo ipai maton oinmati itiro. Maton shara huafafainmisi itiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ascatari nan man futsan finonpai maton oinmati itiro. Shinanqui isca huamisitiro, “Un futsafo shara huapai. Man yopa cuscan un ato ashopairan,” ishon anori yoitirofo. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Urifi anori shinan. Un Upa Diosin ariashu mai ano fotoni urifi nocofunucoin cainshquin. Un Diospan facufiacun ua man amanon un oama. Ascatamarocon un futsafo ato ashomisi. Un yora ichapari un atohuunoashu nashoshquin Satanás afanan aton ifon inonma un oaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ascatan Jericó pushurasi ano noconifo. Nannoashu Jesús fu rafuafo non yorahuanrasi fonifo. Timeopan facu fushon ahuun anu Bartimeo fai cusumunri tsaoa ini ahuara ato yocashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús nan pushurasi Nazaret pushconi fain caiton nicai oi ashcafinin cunani, —Jesús, minfin David funaquin. Uhuun ramapaihuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ascaiton yora ichapafoan yoinifo, —Tsainyamahuu, —curushcain huanifo. Anori huafiainfono fasi curushcain oi ashcafinin afanan cunani, —Minfin David funaquin. Uhuun ramapaihuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nicai Jesús nituacucahuani. Nituacucahuan, —Yoihuu uqui onon, —ato huani. Yorafoan yoinifo, —Natian min unimatiro. Funihuu. Jesús mia cunaquin, —ishon yoiaifono. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nicaquin ahuun camisa potatan funiriscatan Jesusqui oni. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—Un mia ahua ahuusca huashotiromun ua yoipaiquin ua yoihuu, —Jesús huani. Ascaiton cumani, —Tapimamisiton, un oinpai. Afanan un fusho ipaima, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Mian icoinra huashu min cayaquin. Casharatahuun, —Jesús huani. Catan oinsharani. Ascashon fai Jesús mufaini. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ascatan Jesús fu focani Jerusalén chaima noconifo. Nannori chaima pushurasi futsan ahuun anu Betfagé. Nan pushurasi rafu machi cuya ahuun anu Olivo ano inifo. Noco cuatan Jesús afu rafuafo rafu ano ato nichini. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ato yoini, —Nan pushurasi chaima sharaqui fotacahuun. Nocoshon man inapan facu nushua man oincai. Tsoacai na burro camaqui caiyomisima. Tupushon nuri ua ihuunshotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ascan ratoran futsan mato yocaiton, “¿Ahuuscaquin man muropan facu man iyoimun?” ishon mato yocaiton. “Nocon Ifo yopaiton non iyoshoni cairan,” ishon ato yoicahuun, —Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Ato nichian focatan pushu caicainti ano muropan facu nushua fuchitoshinifo. Man tupuaifoan nannoa niafoan ato yocani, —¿Ahuuscaquin man burro cahuashara tupuimun? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús ato yoia cuscan cumacaquin, —Nocon Ifo yopaiton non tupuyoaran, —huanifo. Ascaiton, —Iyotacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ascano Jesús ano ihuushontan camisa muropan catu camaqui fucashonifo. Fucashonafoanno acamaqui Jesús tsaoinacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jerusalén ano caino yorahuanrasifoan fai naman cayan afoforin aton camisafo fucanifo. Futsafoan shupa shatushon nan cai fufori nichiacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Ascan nan yorahuanrasi afofori yafi acachori foaifoan nantififain oi ashcafinin curushcai yoinifo, ¡Aicho! Noco numai oiquin. Upa Diosin Jesusqui unimai. Ascan nocon Ifon Dioshuunoashu nocoqui oa. Nocon shuni David nantifi yorafoan aton niaifo cuscara. Arifi nocon niaifo ishquin oa. ¡Aicho! Nocon niaifo shara nantifi iquinaran ishon oi ashcafinin yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ascatan Jesús Jerusalén ano nocotan Dios fu tsainti pushu muran iquitoshini. Amuran nantifi ato oian. Man yataino. Afu rafumisifo doce fu Betania ano fonifo nanno oshashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iyoconaino Betania anoashu Jerusalén ano fonainquin naso curanquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Oian chaima fana ahuun anu higuera nia fuchini. Fuchishon ahuun fimi apaiquin oian ahuun puifosi. Fimiama ini. Fimitiataima. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ascaiton yoini, —Afanan min fimimaran, —ishon Jesús yoini. Yoiai cuscan a rafuafoan nicanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ascano afanan Jerusalén anoashu cai Jesús Israelifoan Dios fu tsainti pushu muran iquitoshini. Iquitoshiquin oian ahuarafo a murannoashu inanmitsaifoan. Fuchitan ato chifi cainmaquin futsani. Pui fiainfoan aton acamaquishon pui fitiri finifoan arasacaquin futsani. A ruhui inanmitsaifori aton tsaotiri finifoan arasacaquin futsani. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","—Na Dios fu tsainti pushu murannoashucai non ahuara inanmitsatiromaran, —ishon tsain curushcain ato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ato tapimaquin yoini, —Diospan tsainhuunoa isca huaquin cununi. “Uhuun tsainti pushu muranshon nantifi manifoti iquitiro ua cufishcaquin,” ishon cunufianicun yomutsofoan ichananti cuscara man huapairan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ascan Israelifoan aton yorafohuunshon Dios cufimisi niaifofo non Moisés cununi cuscan tapimamisifo Jesús yoiaiton nicacaquin rutupainifo. Ascaiton futsafoan Jesús yoiai cuscan nicapaicoinnifo. Ahuun tsain nicai, —¡Aira! Ascaran tsain shara tsoan nicayomisimaran, —icashu yoinannifo. Ascano aton niaifofo Jesusqui ratunifo. Rutupaifiaquicai tapinifoma ahuuscashomain rututirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ascatan man fari caino Jesús yafi a rafuafo Jerusalén murannoashu patashari fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ascano iyoco futsaino afanan nasoquin fana higuera fuchitoshinifo. Man tsasi futsua. Ahuun tapofori man naa. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Oinquin Jesús higuera yoita cuscan Pedronun shinanquin yoini, —Tapimamisiton, oinpon. Na fana higuera min yoitan cuscan man tsasiaran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Upa Dios icoinra huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Un mato icon yoinon. Maton nomuran man icoinra huacoinshon na machi man isca huatiro, “Tsucucain. Unuhuan muran pacuhuu,” man huaino man yoia cuscan asca huariscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ascacun un afanan mato yoinon. Man icoinra huacoinshon ahuarashta man yocaiton Upa Diosin mato inantiro. Matonna inon. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ascano man Upa Dios cufipaiquin iquisi futsan mia chaca huaa cuscan rau huayohuun. Man ascaiton Upa Diosiri maton chaca rauhuatiro. Ascan man Upa Dios nai murannoa man cufiai cuscan mato ashotiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ascano afanan Jerusalén ano nococatan Jesús Israelifoan aton Dios fu tsainti pushu muran caino. Yorahuunshon Dios cufimisi yafi Moisés cununi cuscan tapimamisifo fu Dios fu tsainti pushu cushumisifo aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aqui fucashon yocanifo, —¿Min acai cuscan tsoan mia yonoamun? Min inanmitsamisifo nocon ichananti pushu muranshon min ato pota. ¿Tsoan mia yonoamun min ato asca huaa? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","—Urifi un mato ahuara yocain. ¿Juanpan yorafo unu muran iquimapacuniquin tsoan yonocumun? ¿Diosin yonoyamaraquin nocofunufoan yonoafomun huani? Man ua cumasharaiton urifi un mato cumasharatiroquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jesús yoia cuscan nicacani yoinanannifo. —Diosin Juan nichiaran non huaiton Jesús noco yoishquin, “¿Ascan ahuuscaquin man Juan icoinra huamamun?” ishon noco yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ascafia Juan nocofunufoan nichini Diosincai nichinima ishon yoiaiton yorafo nocoqui sinatirofo. “Juanpan Diosin tsain yoimisiran,” ishon yoiaiton noco asca huatiroran, —icashu niaifofo yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ascashon yoinifo, —Tsoanmain Juan yonoaquin noncai tapiama. Non mia yoipanan, —ishon Jesús huaifoan. —Ascarifiatan un acai cuscamain tsoan ua yonoaquin uncai mato yoima, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ascano nantianri Jesús ahuarafo cuscarahuunoa ato yosini. Isca huaquin, —Nocofunu futsan ahuun mau ano fimi ahuun anu uva fanani. Ascashon fimicun aqui toquiri cunuacuni ahuaton chaca huanonma. Mai quini huashon prensa mafishtamani. Ascashonri toquiri cushuti cuscara cuya masoa anoshon cushusharashquin. Anaitishon mau yonomisifo ifoan ato inanyoa ahuun mau cushusharanonfo. Ato inanyotan mai futsa ano cayoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Fimiatian ahuun oinmati futsan ahuun mau ano nichini fimi atirifi fishonon. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nocoaiton mau cushuafoan achinifo. Achicashon sutunifo. Ascanshon fimi inanyamaifoanno oinmati ahuun ifo ano nasoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ascano mau ifoan ahuun oinmati futsa atoqui nichifain arifi mapo sutunifo. Fasi chaca huacaquin namaquirashquinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ascano mau ifoan ahuun oinmati futsa atoqui nichini. A rutunifo. Ichapa nichian futsa sutufain futsa rutucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ahuun unutani Furun fusti tushuni. Nan Furun fasi noifiaquin ahuun unutaquin atoqui nichini. “Uhuun facucoinfin nicacoinshcaniquin,” ishon mau ifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ascashori shinanfiaquin ahuun facucoin nichini. Ascano caiton mau cushumisifoan fuchinifo. Fuchishon yoinifo, “¡Oincapon! Mau ifoan ahuun furun oi. Apana na mau. Ascan ahuun facuna chipo iishquin. Ascacun non rutunoncahuun nocona mau inon,” ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ascatan furun iqui curannaiton achicashon rutunifo. Rutushon mau tsisumun sharafoshon ratanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Ahuamun man shinaincain? Mau ifoanfin tapiaquin ato rutumaquin cuyoai. Futsafo inanshquin cushunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Diosin tsain yoini cuscan man oinmisimamun? Ascashon yoiquin isca huani, “Pushu yonomisifoan toquiri quishi shara oincaquin yoinifo, ‘Nacai sharamafinquin,’ ishon potafo. Man potafiafoan pushu ifoan catonni nan toquiri quishihuunoashu pushu nisharanon. Nanscarifi aquin Diospan Furunhuunoa niaifofoan yoimisifo, ‘Nancai ahuamaran,’ ishon man potafo. Ascafiacun Upa Diosin catonni ahuun yorafoti ahuunoashu nipanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ascan Diosin aca cuscan oinshon non yoitiro, ‘¡Aicho! ¡Diosin ahuun Furunhuunshon aca cuscan fasi sharacoinran!’ ishon non yoitiroran,” —ishon Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nicacani Israelifoan aton niaifofo fasi sinanifo. Jesús atohuunoa yoiai tapicanashu Jesús achipaifiacani yorafoqui ratunifo achinifoma. Asca huatan amaquinoashu fonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ascatan chipo ichanancashon yoinifo, —Non Jesús ahuara yocanon noco amaquiri cumaimancai. Noco cumaquin chaca huaiton non cunu muran iquimanon, —ishon yoinifo. Asca huacatan Herodes niaifo ahuun tanamisifo non Fariseofo aton tanamisifori Jesusqui nichinifo a yocanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aquin nococashon yocanifo, —Tapimamisiton, man non tapian min iconcoin fusti min noco yoifafainmisi. Upa Diosin noco amapaiyai cuscan nannori min noco cayacafi yosimisiquin. Min ahuara yoipaicain min ranoima. Nan min noco yoiai min cayacafi yoi. Ahuashta min fomainma. Min yora ahuuoma yoia cuscan nanscarifi huaquin min niaifofo yoitiro. Nan rafu min ato Diosin tsain iconcoin yoi. Ascacufin noco tapimasharahuu. ¿Romanonfoan aton niaifo Cesari nocon pui noco yoca cuscan non inantiro iyamarai non inantiromamun? Noco tapimahuu, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ascashon Jesús onanni nan fuparamitsapaimisifo. —¿Ahuuscain ua amaquiri cumamapaicanimun? Uhuunoa ahuara chaca niaifofo man yoipaicain ua cunu muran iquimanonfo. Man toro inanmisi ahuunshon ahuara finon. Futsan ua fishoriscahuun un oinon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Toro fushoan. —¿Tsoa ointsamain torohuun nuaquin? Tsoan ahuun anu nutamun, —ishon ato yocaiton. “Niaifon Cesarinnaran,” huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Ascan Cesarina inancahuun. Diosinna Dios inancahuun, —ishon ato yoini. Nicacani mustairinifo, —¡Aira! Ahuun tsain tsoancai tafitiromaran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ascatan nan shafatari Saduceofo aqui funifo. Nanfori Israelifo. Shinanquin isca huanifo, —Yora naashu afanan funipacunacamaran, —ishon yoinifo. Nanfoan yocapaicani Jesusqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tapimamisiton, Moisés noco cunushoni isca huaquin, “Nan ratoran iyoa naano ahuun ahuin facuoma imisino chipocuton fishon a futan facu ashquin,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ascano siete nanupacuafohuunoa non mia yoinon. No fu iyopaonifo. Aton iyoacai ahuinyain tauni. Ascafiashon a futan facu acashma nani. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ascano chipocu futsan arifi ahuun ochin ahuin fini. Ascashu arifi a futan facu acashma naani. Ascaino chipocuton futsan arifi ahuun ochin ahuin fini. Arifi a futan facu acashma nani. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ascapacutan amaquisi nai cuyonifo. Aqui facu ayamacai. Ascatari ahuun unutani ainfo nani facu nanuyamacain. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Funiaitian nai arishon rato futsacaimun fiicaiquin? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ascan Jesús ato cumani, —Mancai Diosin tsain tapiama. Ahuun yonori man tapiama. Ascashofin man ua amaquiri yoiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yora naashucai funiafo Dios ari nocotan afanan fiananpacunacafoma. Nantifi Diospan oinmatifo afu icafo cuscarafosi iishcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ascan yora naashu funishquiaifohuunoa Diosin mato yoini. ¿Yoiai cuscan Moisés mato cunushoni man oinmisimamun? Diosin fana urumanhuan muranshon ahuun oi nica cuscan mato cunushoni isca huaquin, “Upa Diosin chofo urumanhuan muran ua yoiquin, ‘Unfi Abraham non Isaac non Jacob afoan un aton Diosiquin,’ ” ishon Moisés yoini. Nan rafu non fusti yamashtafiacanashu natian Dios fu niafo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nayofianishaquin natian niafo. Diosin noco tapima nantifi niafo. Nocon yoshin cuyopacunacama. Ascan manfin amaquiri shinanmisiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ascatan Jesús fu Saduceofo yoinanannifo cuscan Moisés tsain tapimamisiton nicani. Nicaquin ahuun nomuran shinanni, —Jesús ato cayacafi shara cumaran, —ishon shinanni. Ascashon arifi Jesús yocani, —¿Diosin yononi cuscan aafo Moisés cunushoni ratofomain fasi shara finacaiaquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Israelifoan, nicasharacahuun. “Nocon Ifo Diosin fusti nocon Ifoquin. Futsan yamai. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nocon Ifo Dios maton ointi muranshon noifain maton nomuranshonri noifain man shinansharai cuscan ahuun noifain fasi mutsiscain maton Ifon Dios noicahuun,” ishon Moisés cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Futsari nannoricoin yononi isca huaquin, “Nan mifiri min musu huamuai cuscarifi aquin mia chaima icafori noihuu.” Nan rafu Diosin mato yononi cuscan fasi shara finacaianran, —ishon Jesús ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Tapimamisiton, mian cayacafi shara cuma. Icon min yoia Dios fusti. Tsoa futsacai Diosima. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Noncai Dios ahuashta inantiroma ahuun rafanan nocohuun noinon. Min yoia cuscan fusti shara. Ascacun non nocon Ifo Dios nocon ointi muranshon noifain nocon shinansharayashon noifain non fasi mutsiscain nocon Ifo Dios noi nofiri non musu huamuai cuscarifi aquin non nocon chaima ica noiaino. Ascaran fasi shara finacaianran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús nicashon cumasharani. Ascashon yoini, —Natian Upa Diosin ahuun yorafo imapaiyai cuscan mirifi min tapicuana afu nipashquin, —ishon Jesús yoini. Ascaiton nicacani puusinifoma. Afanancai tsoanshta Jesús ahua yocanima. Nantian yafi nan Jesús naitian afanan tsoan ahuashta yocanima. Ato cayacafi cumaiton nicacani tsoan cumanima aqui ranonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ascatan Jesús Israelifoan aton Dios fu tsainti pushu muranshon ato yosianan yocani, —¿Ahuuscain Moisés tsain tapimamisifoan yoimisi isca huaquin? “Criston David ahuun funaran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Diospan Yoshin Sharanun David ahuun nomuran shinanmana cuscan yoini, “Upa Diosin uhuun Ifo Cristo yoini isca huaquin, ‘Minfin ufu niaifocoinquin. Mia noicasmaifoan min ato finoncoian. Un ato shatumashquin mia afanan ahuusca huatiroma. Min ato iquiniran,’ ” ishon Diosin yoini cuscan David cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Criston David Ifono ahuuscashucon ahuun funa itiromun? —Jesús ato huani. Yorahuanrasi Jesús yoiai cuscan nicacani fasi unimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ascano nicatoshinifo Jesús ato yoiaiton, —¡Oinfain! A Moisés cununi cuscan tapimamisifoan saya chainipafo sahuushon ato oinmafoanfafaincani. Fasi tapicoianforan ato huamapaicani. Yora ichaparasi ano foanscanifo “Sharacoinforan,” ato huamapaicani. Fasi cacapaimisifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ichananti pushu muran iquitan shafacafi tsaonifo. “Noco oinonfo, non tsaotiroran,” ishon shinannifo. Ichananshon piyainfoannori shafacafi tsaopainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ainfo funuomafo, “Non mia shara huairan,” huafiashon paranifo. Aton ahuarafo onushcaquin. Fuparacaquin. Fasi chaicoin cufirianifo atoqui oinanpaiquin. Dioshuunshoncai cuficoinnifoma. Nanscarafo Upa Diosin ato fasi onaintimacoinquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yoitan fuhuunina cahua Jesús oinni Dios fu tsainti pushu muranshon yorahuanrasiton pui nanuti muran nanuiniyaifoanno. Yora mafo ichapayaton atirifoan paratama pui nanuti muran nanunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ascano ainfomaqui funu naano ahuuomashtaton toro chimashta rafusi pui nanuti muran nanuni. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oinquin Jesús fu rafumisifo cunashon yoini. —¡Oincapon! Un mato iconquin yoinon. Na ainfo funuoma ahuuomashtafiashon yora futsan inan cuscan aafin paratama nanua cuscara. ");
INSERT INTO mcdNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ascano mafo ichapayafoan inanfiacaquin ichapa tushu huanifo. Ascafia nan ainfoan nantifi ahuun pui nanuqui cuyoni. Inanqui anaititan. Afanancai ahuahuunshon ahuun tushu fitiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ascano Jesús Dios fu tsainti pushu murannoashu caiton afu rafumisifo futsan yoini, —Ifon, oinpon. Nocon Dios fu tsainti pushu fasi sharashtacoin. Toquiri cunu putsamuashu cunuacua uhuapacoin fasi sharashtaran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—¡Ai! ¡Oincapon! Natian Dios fu tsainti pushu toquiri putsamuashu cunuacua sharashtacoin. Ascafiashu na man oiain chipo paon ishquin. Afanancai toquirifo putsamua ishquima. Ratoshtacain putsamua tushuimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ascano machi ahuun anu Olivo ano mapufaintan Jesús tsaoni nanno ishon Dios fu tsainti pushu ointiro ini. Tsoa futsacai ano inima Pedro non Santiago non Juan non Andrés non afo aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Nan min yoiai cuscan ahuutian ishquimun? ¿Ahuuscashomun non tapitiroquin? ¿Icataima non ahua ointiromun tapishquin? Noco tapimahuu, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Oinfain mato paranonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yora ichapafoan. “Un Cristoran,” ishon mato parapaishcani. Ascashon ichapafori parashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mani futsafo ya futsafo rutunainfoan man nicashquin. Icataimari anori man nicaiyoicai. Anori nicai ratuyamacahuun. Un mato yoimisi cuscan nanscacoin aiquin. Ascafia Jerusalén cuyoataima. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mai futsan fu yorafo mai futsari ya rutunainfono mai futsafo anori fasi mai naiyanaiyaishqui icaifono mai futsanoafori yora tushuomafo icaino. Nanscai taushcani. Ascafiashu chipo omitsiscai finacaishcani. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ascan itisharacahuun. Mato achishon mato niaifofoan maton ichananti pushu muranshon mato fasi coshashcaniquin. Niaifofoan aton ointaifi mato iquimashcani. Mato asca huacani. Uhuunshon man ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ahuun unutani nan omitsiscacoinshquiai cuscan icataima uhuun tsain shara uhuunoa atirifiton nicataicanima. Uhuun tsain shara manifotiton nicacoiainfono un afanan ooshquin. Nantianri ua icoinra huaafo afanan omitsiscashquima. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ascano chipo mato achimashquin matohuunoa tsain chaca yoishcaquin. Nantianri, “¿Raquiri non huaimun?” ishon shinanyamacahuun. Nan nocoaiton un mato tapimashquin man cumasharanon. Mafincai man cumaima. Diospan Yoshin Sharahuunshon ahuun tsain maton nomuran nanumashquin man niaifofo cayacafi cumasharanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nantianri iyoaton chipocuqui tsain chaca huashquin achinonfo rutushcaquin. Nanscarifi aqui chipocuton ahuun ochiqui tsain chaca huashquin achinonfo rutushcaquin. Nanscarifiai facufoan aton apa yafi ahua afanan nicacasmashcani niaifofo yoishcani ato rutunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Uhuunshon mato noicasmacani man ua tanasharaiton, manifotifoan mato noicasmashcani. Ascashon mato omitsiscahuafiainfoanno tsoan uhuunoashu omitsiscafiaquin tunucoin uhuun tsain tanasharaqui unupacunacama. Nanfo un cushusharatiro uhuun Upa Dios icano nipasharanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ascacun Diosin ahuun yorafo fu imisi ano futsafoan ahuara fasi chaca huai. Nan un mato yoiai cuscan tapicahuun. Nanfo oin man ratoran futsa Judea mai anoashu machi ano ichotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tsoan pushu osa futsa niashu afanan pushu muran iquiyotiroma ahuara fipai. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tsoan aton mau ano yonoi afanan pushu ano nasoyotiroma ahuun sahuuti fipai. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ohua! Ainfon facu nanuafo yafi aton facu yomumishtifo omitsiscaashcani. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Natian yorafo omitsiscai cuscan tsoan ascara oinyomisima. Fasi finacaia yora omitsiscaiquin. Diosin yora tau huaquin onihuani chain cai tsoan ascaran omitsiscai oinyomisima. Tsoaricai afanan ascai omitsiscanacama. Ascan Upa Dios cuficahuun oipacutian ascanonma. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nan omitsiscaifotian yorafoti cuyocuancani. Diosin yonoyamaino nan yorafoti cuyocuanafo. Ahuun yorafo nan catoanfo atohuun ramapaiqui omitsiscaitian shaturiscamashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","23","Ua nicasharacahuun. Omitsiscashquiaitian nocoataima un mato yoiyoi. Man omitsiscaitian fuparapaimitsamisifocoin matoqui oshon. Mato yoitiro isca huaquin, “Unfin Cristoquin,” ishon yoiyamaraquin, “Unfin Diospan tsain yoimisiquin,” ishon mato yoishcani. Satanashuunshon yora atiroma cuscan mato ismai. Mato parapaishcaquin. Diosin nan catoanfo cushuyamaino atorifi nan fuparapaimitsamisifo icoinra huacuana. Ascano nantian tsoan mato yoiquin isca huai, “¡Oincapon! Naafin nocon Cristoquin. Cristo nocoqui oaran,” ishon yoiaifoan ato icoinra huayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Ascan nan omitsiscai cuyocoiainno fari faquishcoin ishquin oshuri faquishcoin icaino fishifo nai ariashu pacui futsushquin. Nantifi nai murannoafo naiyanaiyainqui futsushquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nantianri un nai ariashu fuufoya camaqui mai ano fotoaino uhuun Upa Diosin ahuun yonohuunoashu un afanan matoqui fotoshquin. Nantififain ua oinshcani unfin Diospan facuquin. Un oaino fasi chashapacucahuanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nantianri uhuun oinmatifo ufu nai muran icafo un nichishquin uhuun yorafo manifoti uqui ihuunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ascatan nii ohuamisifohuunoa ahuara un mato tapimanon. Ua nicasharacahuun. Casho pui risquisi futsuaiton man tapitiro faritian. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nanscarifiai nanfo un mato yoiai cuscain futsuaiton man onantiro mun oti chaima nuno mai anoa niaifocoin iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Un mato icon yoi. Ahuarafo un mato yoia cuscan a mai anoafoan naiyocashoma oinshcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nocon nai yafi mai cuyoai cuscan fianananain futsuin. Uhuun tsain ascatamarocon cayacaficoin. Iconcoin. Uhuun tsain un mato yoiai cuscan nanscacoin aiquin. Fianannanpacunacama. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ascafia ahuutiaran un nai murannoashu afanan fotoicain tsoancai tapiama. Diosin oinmati afu nai muran icafoanricai tapiafoma. Urifi un Upa Diosin facufiashocai un tapiama. Nan uhuun Upa Diosin fustitofin tapiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Un afanan oaitian tsoan tapiama. Ascacufin oinfain. Itisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Shinancapon. Nocofunu mai futsa ari caquin iquisi ahuun oinmatifo yoitiro, “Un mato yoiai cuscan uhuun pushu cushusharacahuun. Yonosharacahuun. Futsan uhuun pushu anoshon cushutiro un afanan nasoaitian un oinnon,” ishon ato yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nanscarifiai marifi itisharacahuun. Ahuutiaran un afanan matoqui nasoshquin tsoan tapiama. Fari caino iyamarai yamu nacucahuanaino iyamarai tacaranun acaino iyamarai shafaino un nocoriscatiro. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Oinfain. Un nocoaitian oshacaquima ua yonosharashocahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Un mato yoiai cuscan un nantifi yorafo yoi, “Itisharacahuun,” —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Ascano Jesús ato yoini natianri fusiti shafa nococuanaino. Nannoshon misi farashati maisi piinifo. Nan fusiti Israelifoan Egipto mai anoashu fonifo shinantacani. Nantianri Egipciofoan aton facu furonanfacu iyoafofosi Diosin namaquin cuyoiquin. Israelifo ato muran ipaonifiacanashu Egipciofoan aton facufo namafiaquin Israelifoan aton facufo finonmani. Ascan faritifi ichanancashon Upa Diosin aton shunifoan aton facufo finonmani nanonfoma shinantacani. Ascan nan fuusiti anumisifo nocon shunifoan aton facufo finonmaniran. Nantianri nocon yorafohuunshon Dios cufimisi niaifofoan Moisés cununi cuscan tapimamisifo futan ichanancashon isca huaquin yoinifo, —¿Ahuuscashomun non Jesús rutumatiroquin? ¿Ahua chacamain ahuunoa non yoiqui rutumashquin? Natian fusimuainocai non achimatiroma. Yorafo fasi sinacani mucatirofo, —icashu yoinannifo. Jesús onushta rutumapaicani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ascano Jesús Betania ano cani. Cai Simón pushu muran iquini. Nan Simón nami rashquishi futsua ini. Nannoshon Jesús Simón acamaquishon piti ano tsaocun ainfoan toquiri moti tsomashu otan aqui ocashquin. Nan toquiri ahuun anu alabastro moti huamua. A muran ininti fospi huani. Ininti ahuun anu nardo fasi pui nua. Ascano ainfoan motica fuputan Jesús ahuun mapoqui ininti ocani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Atirifoan oincani sinanifo, —¿Ahuuscaimun na ainfoan ininti paratamacoin ahuun pui nuua potaquin? ");
INSERT INTO mcdNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nan ininti inanmitsashon ahuun rafanan pui ichapa fishon yora ahuuomafo inanshara icuanaran, —ishon yoinifo. Yoicatan ainfoqui curushcain tsainnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","—¿Ahuuscain na ainfoqui man tsain chipuain? Fucash huayamacahuun. Ua fasi shara huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yora ahuuomafo matofu ipanacafo. Ratoran shafatan man ato shara huashotiro. Ascafia un nuno matofu ipanacama man ua shara huanon. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na ainfoan nan oiainshta ua shara huaa. Yora maiaquin ininti ocamisifo cuscan un nataiyamafiaiton na ainfoan ua shinanquin uqui ininti ocayoa. Ua ashquiai cuscan uqui ocaquin tau huaa. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Un mato icon yoinon. Na tsain shara uhuunoa manifoti yoishcaquin. Nantianri na ainfoan ua aca cuscari ato yoishcaquin. Ascatan ua shara huaa cuscan ahuunoari shinanpacushcaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ascano Jesús ato yoiquin afu rafumisifo doce futsan nan Judas Iscariote nocon yorahuunshon Dios cufimisi niaifofo ano cani Jesús ato achimashquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nicacani niaifofo fasi unimanifo. —¡Aicho! Min noco Jesús achimaicai. Ascacun ahuun rafanan non mia pui inainran, —huanifo. Asca huaifono nannoshon Judaspan shinanquin tau huainifoanni, —¿Ahuuscashomain un Jesús ato achimanoain? —ishon shinainyofafaini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ascano shinantani Israelifoan aton fuusititian nocoaino misi farashati maisi pimisifotian. Nantianri chashoanun facu piinifo. Nan chashoan facu faritifi rutupaonifo Diosin aton shunifo cushuni shinanonfo. Ascano Jesús fu rafumisifo aqui fucashon yocanifo, —Ifon, Diosin nai oinmati nan afu imisiton nocon shunifoan aton facu iyoafofosi finonmani aton rutuquima. Non faritifi ichananmisi anori shinanshquin. Afanan natian non atiroquin. ¿Ascan rato pushu muran non mia itishara huashoimun nannoshon mi futan chashoanun facu piishquin? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","—Pushurasi ano fotacahuun. Nannoa nocofunun unu tutsaomushon fuaiton fuchishcaquin. Aqui nocoashu afu fotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nan iquiai ano afu iquifainshon pushu ifo yocacaquin, “Nocon tapimamisiton mia yocan, ‘¿Rato cunu muranshon ufu rafumisifo futan non chashoanun facu piimun?’ ” ");
INSERT INTO mcdNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Man yocaiton mato cunu uhuapa fomancayan ismaiquin. Nan cunu muranfin nan non yopaiti mato ismaiqui. Nannoshon noco ati shara huashotacahuun, —Jesús afu rafumisi rafu yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ascano nan rafu pushurasi ano fonifoquin. Pushurasi ano focashon Jesús ato yoia cuscan nanscacoiainton oinnifo. Ascashon chashoanun facu pichanshonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Man fari caino Jesús yafi afu rafuafo doce pushu ano noconifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Fomancayan focashon acamaquishon piti ano tsaoshon piaifoan Jesús ato yoini, —Icon un mato yoinon. Nuno u futan piai futsan ua achimaiquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nicacaquin aton ointi noconifo. Fasi shinannifo. Ascashu puusinifoma. —Ifon, uncai mia ashquimaran, —ishon nantififain yocapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Nan man nocofunu doce u futan piai futsan uqui yonoafin ua achishcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Unfin Diosin ariashu nuno mai ano fotoniquin. Un nocofunucoin cainshquin. Diosin tsain uhuunoa inon pacoai cununi cuscan un nai cai. Ascafia na nocofunun ua ato achimashufin arifi omitsiscapanacaquin. Caianmafin shara icuanaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Piainfoanno Jesús misi finifoantan iquisi apa Dios cufiyoni, —Upan, aicho, min noco shara huafafaini, —huani. Apa asca huatan afu rafumisifo yoiqui isca huani, —Na uhuun cayan cuscara. Picahuun, —ishon. Misi torupacushon atoti inancuniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ascatan Apa Dios afanan cufinquin, —¡Aicho! Upan, min noco shara huaquin, —huani. Cuchori finifoantan aqui fimi unu fuatan ato inancuniquin. Ascaiton nantififain ayapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ascashon ato yoiquin, —Naafin uhuun imi cuscaraquin. Uhuun imi foiquin mun nai. Nantifi yorafoan chaca huamisifoanno un atohuunoashu nai cai. Un ascaino yora ichapafo Diosin ato potapacunacama. Un ato nashoincai aton chaca soashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Un mato icon yoi. Un nunoshon afanan mato futan un ayaima. Mun nai ari cai. Nan uhuun Upa Dios niaifocoin ica anoshon un afanan ayashquinran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ascano ahuun tsain yoiqui anaititan Diosin tsain fanainnifo. Anaititan machi Olivos ano fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ascatan Jesús tsain futsan ato yoini, —Nantififain man ua potafainicaiquin. Diosin tsain cununi isca huaquin, “Unfin chashoanfo cushumisi un rutuicai. Ascano chashoanfo ichoi futsuiqui,” ishon cununi. Nanscarifiai ua rutuaifoanno man uhuunoashu ratufaini foi ichoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ascan un funiano Galilea ano man uqui nocoi foshquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ascaiton Pedronun Jesús cumani, —Nantifiton mia potafiaifoannocai un mia potanacamaran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Pedron, un mia icon yoicain. Na yamutan tacara cuoi rafuamano min ato yoiqui rafu non fusti huaicai, “Un Jesús oinmisimaran,” —ishon min ato yoicain. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Ma, Ifon. Un mifu natirocai un ato yoinacama un mia oinmisimaran, —ishon Pedronun yoini. Nantifiton afu rafumisifoan nannori yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ascano nanno ihuifo mapoa ano ahuun anu Getsemaní ano Jesús afu rafumisifo ya cani. Jesús ato yoiquin, —Nuno tsaoshon ua manacahuun. Uhuun Upa fu un tsainyotanon, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ascano Pedro non Santiago non Juan non afo ato iyoni. Fasi shinanquin ahuun nomuran omitsiscai tauai. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ato yoiquin, —Unfin fasi oimitsiscai. Uhuun nomuran un fasi shinain. Mun muucoin un nai cuscan. Nunoshon ua manayocahuun. Un futan oinyocahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ato yoitan chaimashta catan fuopacucahuan Apa Dios fu tsainni. —Uhuun Upashtan, ua rutushcani. Un omitsiscai cuscan mian numatiromainquin ua numahuu. Ascafiashon un apaiyai cuscan huaquima. Min apaiyai cuscan ua huahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ascatan Apa fu tsainqui anaititan afanan atoqui oni. Oquin ato oian man oshafo ini, —¿Pedron, min oshamun? ¿Min u futan Dios cufimamun? ");
INSERT INTO mcdNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oshaquima. Dios fu tsainhuun Satanás mato chaca huamapaiyai cuscan anonma. Maton nomuran Diosin mato imapaiyai cuscan marifi nanscasi huapaifiaquicai mafin man atiromaquin, —ishon Jesús Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ascashu afanan Apa fu tsainqui cai chaimashta cani. Apa cufian cuscan nannori afanan cufini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ascashon afanan atoqui nasoquin oian afanan afu rafuafo oshafo ini. Fasi oshapan noicani moipaiquin ranannifo. Raquirimain Jesús ato yoicai tapinifoma. Ascan puusinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ascaino afanan atomaqui chaimashta cashon Apa Dios cufitani nasoquin oian afanan man oshafo ini. Ascaiton ato yoini, —¿Man man afanan oshamun? Nanscanon. Man oshatiro. Ascafiashu man afanan natian oshatiroma. Natianfin man ua achi fucaniquin. Na nocofunun ua yora chacafo achimani oiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Funicahuun. Non canon. Na nocofunun ua noicasmaifo ua ato achimani oiquin, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ascano Judas nan Jesús fu rafumisi futsan aqui oni. Yorarasi Judas fu nopu yafi coshati tsomacanashu funifo. Israelifoan aton yorafohuunshon Dios cufimisi niaifofo non Moisés tsain tapimamisifo ato yonoa funifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judaspan yorafo Jesús achimashquin yoini, —Un Jesús tsoacaiton tapicahuun nanfin Jesusquin. Achiti sharaqui. Achicatan niaifofo ano iyocahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Asca huatan samamashta nocoshon tsoaqui. Tsoatan, “Tapimamisiton,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ascano nan Judas fu fuafoan Jesús achinifo. Achicashon niaifofo ano iyoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ascaino Jesús chaimashta futsan nicun. Nopu fitan nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun oinmati pashtufain rurani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ascaiton Jesús ato yoini, —¿Man shinan un yomutsocunmun coshatifo ya nopu ya man ua achipai fua? ");
INSERT INTO mcdNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Shafatifi un Dios fu tsainti pushu muranshon un mato yosifiaitocai man ua achiyoti huama. Natian man ua acai cuscan Diosin tsain uhuunoa cununi cuscacoin man ua huairan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ascaino afu rafumisifoan potafaini amaqui ichonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ascano pushcoai man Jesús mufainaiton achiaifoanno ahuun piracomua shorifaini chitoria ichoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ascano achicashon Israelifoan yorafohuunshon Dios cufimisi aton niaifocoinin pushu ano Jesús iyonifo. Nanno nan niaifofo non Moisés cununi cuscan tapimamisifo ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ascaino Pedro ato cachiori chaima cani. Nocon yorafohuunshon Dios cufimisi niaifocoin ahuun pushu unmainti ranushumuafo yooaino Pedrori atofu yooni. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","—¿Nonmun raquiri huatiroquin Jesús ahuara chaca huaran ishon rutushquin? Ahuacai ahuusca huaa non nicayomisima non rutuai, —icashu Israelifoan aton niaifo yoinannifo. Nanno pushu muran nantifi Israelifoan aton niaifofo ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yora ichapafoan, —Jesús chaca huaran, —ishon yoifiacaquin nannorisi shinannifoma. Paracaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yoiti huaquin anaitiafono nocofunu futsafoan niaifofoan aton ointaifi Jesusqui tsain chaca huanifo. Chanicani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Non nicaino na nocofunu iscaita, “Nocon Dios fu tsainti pushu yorafoan acafo. Un choqui ashquin. Ascashofin osha rafu non fusti finontan un afanan futsa huashquicain. Unfin un atiroquin. Tsoan nocofunun u futan aquima. Urus fustifin un ashquicai,” ishon Jesús yoitaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yoifiacaquin tsoan anorisi yoinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ascano nocon yorafohuunshon Dios cufimisi niaifocoinin aton ointaifi Jesús yocani, —¿Miqui tsain chaca huaafo cuscan icon iyamarai iconmamun? ¿Min ato cumaimamun? —ishon yocaino. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús puusinima. Ascaiton afanan yoini, —¿Diosin sharapan mia catonnimun min ahuun facu inon? ¿Icon min ahuun facucoinmun? —ishon niaifocoinin yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Mian yoiai cuscafin unquin. Upa Diosin ahuamamishti huatiro. Chipo man ua oinshquicai uhuun Upa niaifo fu un icaiton. Urifimain afu niaifocoianshufin. Un nai ariashu nai coin camaqui un oaiton man ua oinshquicai. Un mai ano fotoshquinran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Nicatan Israelifoan aton niaifocoin Jesusqui fasi sinaquin. —Man man nica Jesús fasi chaca huaa. “Un Diospan facuran,” icaiton man man nica. Ascano non tsain futsa yopaima a onaintimashqui. ¿Na nocofunun non ahuusca huaimun? —ishon niaifoan ato yoini. Ascashon nantififain, —Diosquiri chaca huaquin nanonquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Asca huatan ahuun fusoqui cumo michofain funushfain sutunifo. Sutucashon cashu huanifo, —Min Cristomainquin min nantifi tapicoian. Ascan tsoan mia sutuamainquin noco yoihuu, —ishon cashu mutsama huanifo. Ascatan ranushumuafoanri Jesús fasi coshanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ascainofin Pedron nocon yorafohuunshon Dios cufimisi niaifocoinin pushu umaiti ano atofu yooaiton niaifoan ahuun oinmati shomayaton Pedro fuchiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Fuchishon yoini, —Na nocofunufin Jesús Nazaret anoa min afu rafumisiquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Ma. Mian yoiai cuscacai un tapiamaquin, —Pedronun shomaya huani. Yoiqui asca huatan shoi caincaiti ano caani. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ascashon nan oinmati shomayaton Pedro fuchia afu niafo yoini, —Na nocofununfin arifi Jesús fu rafumisiquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Ma. Uncai Jesús fu rafumisimaran, —ishon Pedronun yoini. Samaracatan Pedron fu niafoan yoinifo, —Icon. Mirifi min Galilea mai anoashu oa. Ascan minfin Jesús fu rafumisiquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—Un mato paratiroma. Un chanicun ua Diosin chii uru muran potatiroquin. Diosin tapiafin un mato iconcoin yoiaquin. Uncai na nocofunu Jesús oinmisimaran, —ishon Pedro ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ascaino samamashta afanan tacara cuoni. Cuoaino Jesús yoia cuscacoin Pedronun shinantani. —Pedro, un mia yoi. Na yamutan tacara cuoi rafuamano min ato yoiqui rafu non fusti huaicain, “Un Jesús oinmisimaquin,” —ishon Jesús yoia cuscan Pedronun shinantani. Ascashu fasi uaini. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ascano shafa acuaino nocon yorahuunshon Dios cufimisi niaifofo yafi Moisés cununi cuscan tapimamisifo Dios fu tsainti pushu cushumisifo fu ichanancashon shinanpainifo, —¿Ahuuscashomain non Jesús rutumaicai? Nan Pilato Romanonfoan aton niaifon ahuun mai arishon nocoqui nichini nocon niaifo inon. Non Pilato ano Jesús iyoicanon, —icashu yoinannifo. Ascatan munushcashon Pilato ano iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—¿Minmain Israelifoan aton niaifocoinquin? —ishon Pilaton Jesús yocani. —Aifain. Nan min ua yocain cuscafin unquin, —Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ascano nocon yorahuunshon Dios cufimisi niaifofoan Jesusqui tsain chaca huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ascashon Pilaton yoini, —¿Yorafoan mia chaca huaifo cuscan min nicaimamun? ¿Min ato cumapaimamun? —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Asca huaino puusinima. Aqui tsain chaca huafiaifono puusinima. Ascaino Pilaton ahuun nomuran shinanquin, —¡Aira! ¿Ahuuscain ato cumapaimamun? —ishon shinanniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ascatan aton fuusititian faritifi cunu muran iquiafo fusti ato caimapaoni. —¿Ratocai man caimapaimun? —ishon Pilato fuusititian ato faritifi yocapaoni. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nantianri nocofunu Barrabás cunu muran ini. Nanton yorafo shinanchacamani. —Romanonfoan aton niaifofo non potanon, —ato huani. Fasi ato mucumati huapaoni. Asca yora ichapafoan Romanon niaifo potapainifo. Nantianri Barrabás yora rutuni. Ascaiton ranushumuafoan cunu muran iquimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ascatan man Jesús achiafono Israelifoan Pilato yoicaquin, —Min noco faritifi fuusititian ashopaoni cuscan afanan noco huashohuun. Afanan cunu muran iquia futsan noco caimashohuun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","—Jesuscai ahua chaca huamisima. Ato ashoan cuscacai Israelifo aton niaifofoan atiroma. Ascacufin Israeli niaifofo Jesusqui sinacaniran, —ishon Pilato ahuun nomuran shinanniquin. Ascashon ato yoini, —¿Maton niaifo Jesús man caimapaimun? Un mato caimashonon, —ishon ato yocafiashon. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Israelifoan aton niaifofo nannosi ichanannifo ato shinanchacamapaicani. —“Jesús noco caimashotama Barrabás noco caimashohuun,” ishon Pilato yoicahuun, —ishon niaifofoan yorafo yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nannori, —Israelifoan, man yoimisi Jesús maton niaifo. ¿Ascacufin un Barrabás caimashomun un Jesús ahuusca huaicai? —ishon ato yocani. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nantifishon, —Ihui coyan iquinanqui mastahuun, —ishon oi ashcafinin yononifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Ahuuscacufin. ¿Ahuamun chaca huaquin? —ishon yocani. Ato yocafiaiton fasi curushcain, —Ihui coyan iquinanqui mastahuun nariscanon, —huarianifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Sinaifoan oinquin Pilato ato rau huapaiquin Barrabás caimaniquin. Ascashon ato yonoa fichi cunoqui tuchiaton Jesús coshaquin futsanifo. Ascatan mastashcaquin iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ranushumua Romanonfoanfin Jesús iyonifoquin. Niaifoan ahuun pushu chaimashta. Nannofin ranushumuafoan aton pushurasi iniquin. Nanno iyonifo. Ascashon niaifo cushumisifo ranushumuafoan ato chifi cunanifo oin funonfo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ascashon ahuun sahuuti pucanifo. Pucatan futsa shonan sahuumanifo. Ascatari mosha chainipafo maiti huashon maimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Ascashon yoicaquin, —¡Aicho! Minfin Israelifoan aton niaifoquin, —icashu aqui cashupainifo. Asca huacatan ratoconun mai chachishonifo. Aqui cashupaiqui poquiti ahuun mapo cosharianifo. Ascatan aqui cumo michonifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ascashon aqui paranaquin cashushonifo. Cashushoncatanfin sahuuti shonan pucashon ahuun sahuuticoin afanan sahuumanifo. Ascashon ihui coyan iquinanqui mastai focaquin iyonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesús iyocaquin oianfo pushurasi patasharifo nocofunu Simón oaiton fuchishon ato finonfoanpaiyaiton ranushumuafoan achishon yoini, —Minfin ahuun ihui coyan iquinan foicaicain —ishon ranushumuafoan iyamafaini. Nan Simón Cirene mai anoashu oa iniquin. Ahuun facu rafu Alejandro yafi Rufo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota ano Jesús iyonifo. Gólgota onicoinnin tsainmanfin mapo shao. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nanno nococashon fimi unu paun tashipia osia Jesús ayamapaiyaifoan ayanima. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ascatan Jesús ihui coyan iquinanqui mastanifo. Mastacatan ahuun sahuuti fianshcaquin. Toquiri tocoro rafu ya cashuqui potapacunifo. Nan finonmanaton ahuun sahuuti fiqui tau huani. Asca huapatan cuyonfianifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Man fari nai pochinin racano mastanifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Man mastacashon amanaonri ihui coyan iquinanqui cununifo isca huaquin, ISRAELIFOAN ATON NIAIFOCOINQUIN ishon amanaonri cununi. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ascashon yomutso rafuri mastanifo. Ocuma futsa futsafain ocuma futsa anifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nannori ahuunoa cunuyoni cuscan, —Shinanfo arifi chaca shafai, —ishon Diosin tsain inonpacoai cuscacoin aquin cununiquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Ascashon camacaquin, —¡Cuu! Minfin yoimisiquin nocon Dios fu tsainti pushu min choquiacai. Ascatanfi osha rafu non fusti finontan min afanan futsa huairan min ica. Iconmainquin mifiri numatan fotohuu. Ihui coyan iquinanmaquinoashu fotohuu, —ishon roanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ascano nanscarifiai nocon yorafohuunshon Dios cufimisi niaifofo yafi Moisés cununi cuscan tapimamisifoan aqui cashupai yoinannifo, —Nanton futsafosi numafiatiroshaquicai aficai numatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iconmainquin aafin Criston Diospan Furun Israelifoan nocon niaifoashu ihui coyan iquinanhuunoashu fotoaiton non oinquifin non icoinra huaicai, —icashu yoinannifo. Ascashon afu ihui coyan iquinanqui masta rafutari aqui tsain chaca huaquin roanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ascatan fari masafinin racano nan maitio faquishpacucahuani. Ascashu man fari caino afanan shafani. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nantianri Jesús oi ashcafinin apa cunani, —Eloi, Eloi, ¿lema sabactani? —oinicoinin tsain manfin, —¿Uhuun Diosin, uhuun Diosin, ahuuscain mian potamun? —huani. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yorafoan mapo casho Jesús nicacaquin, —Nicacapon. Elías cunaiton, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ascainofin nocofunu futsan ichoniquin. Fimi unu focash muran nashan nanushon fiicai ichotan fitani oshon faca tahua shatun tuhuunifoantan Jesús inanpaiyaiton yoini, —Non oinyonon. Elías oshomain fotomaicai. Non oinyonon, —ishon cashu mutsama huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ascainofin Jesús fasi fiisinacahuaniquin. Fiisina cahuatanfin naaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nanscatapaiyaino Israelifoan aton Dios fu tsainti pushu murannoa pano putan pochimua afincoin fashnupacu cahuaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ascaiton, —Iconfinquin na nocofunufin Diospan Furunquin, —ishon ranushumua niaifoan Jesús naa cuscan oinshon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nannoshori ainfofoan chai mapo casho oinnifo. Futsan María Magdalena non María futsan Santiago non José aton ahua non Salomé. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nan rafu non fusti ainfofo futsafoanri chai mapo casho oinnifo. Galilea anoashu Jesús fu foanfafainmisifo cushusharashcaquin. Ainfofo futsafoanri Jerusalén ano afu funifo. Ato furi nanno nia ini. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ascatan sabado fainaca shafatan Israelifoan nan shafan anunifo, —Itisharati shafaran, —ishon anunifo. Nan itisharati shafatan man fari caino nocofunu José ratutama Pilato niaifo ano cani. Nan José arifi Israelifoan aton niaifo futsan. Arimatea mai anoa ini. Nanton manamisi Cristo Diosin catoanton aton niaifo inon. Nanscacaini cashon Josén Pilato yoini, —Niaifon, un Jesús ahuun caya ihui coyan iquinanmaquinoa fotomapai mahua quini muran mai huai cashquin. Un mia yocai oa, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaton nicatan, —¡Aira! ¿Ahuuscai Jesús samamashta naamun? —ishon shinanni. Ascashon ranushumua cunani yocashquin, —¿Iconmun man Jesús naamun? —ishon yocaiton. —Ai, man naaran, —ishon ranushumuaton cumani. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ascaiton nicaquin, —Jesús ahuun caya Josén fotomatiro mahua quini muran mai huashquin, —ishon Pilaton ranushumua yononi. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ascatan José pano oshopa sharacoin fiini. Fiitan a mastafo ihui coyan iquinanmaquinoa Jesús ahuun caya fotomapacufoan ahuun yoratishon nan pano oshopa sharacoinchi raconi. Racoshon toquiri mahua quini muran mai huani. Mai huashon toquirininhuanun fuponifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mai huaifono María Magdalena futan María futsan José futsan ahuan nannoshon oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ascano Israelifoan aton tunutitian cuyoano María Magdalena non María futsan Santiago ahuan non Salomé non afoan ininti sharashta finifo Jesús ahuun cayaqui ocashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Ascano iyoconaino nan Domingoai shafatan funamarishta ainfo rafu non fusti Jesús mai ano fonifo yoinanfonifo, —¿Nocomain tsoa toquirininhuan quini fupushonan? —icashu ainfo rafu non fusti yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nococaquin oianfo quini ahuun fupoita toquirininhuan toromahuan man fupucuaini. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ascaino iquifainpaiquin oianfo nocon mumicayahuuri man ointiaca quini muran tsaoan ini. Sahuuti osho sharashta sahuuashu. Fuchitan mustai irinifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ascaiton ato yoini, —Ratuyamacahuun. Man Jesús funicainaquin. Man funai Jesuscai nunoma. Mastafiaitafo man funiaquin. Na quini muran raca iquitano. Oin fucapon. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Afu rafumisifo yoitacahuun. Pedrori yoifain. “Jesús Galilea ano caiyoi tauicaiquin. Anoshon mato manai. Mato yoimisi cuscan nannoa man ointiroran,” ishon man ointiaca Upa Diosin atoqui nichiaton, —ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nicafaini nan ainfo rafu non fusti mahua quini murannoashu ichonifo. Ichoainfoancai icoinra huaquin rashquinifoma. Ratufaini focaquin rama oianfo cuscan tsoa yoinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ascano Jesús Domingo funamanrishta funini. Funiashu María Magdalenaqui nocoi tauni. Jesús naataima Mariamaquinoa yoshin chaca siete potani. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesús oian cuscan afu rafuafo ano cani ato tapimashquin. Atoqui nocoshon oian Jesús shinancani uainifo. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Un rama Jesús oian. Man funiaran, —ishon María ato yoifiaiton nicacaquin tsoan icoinra huanima. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ascano ahuun tanamisi rafu fai foaifoanno Jesús atoqui niriscatani. Ascaitocai onannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Onancanashu afu rafumisi futsafo ano fonifo ato tapimashquin. —Non Jesús oianran, —ishon ato yoifiaifoan tsoan atori icoinra huanima. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ascatan chipo piyainfoanno Jesús atoqui nocoriscatani. Ascashon ato yoini, —¿Ahuuscain un afanan funia man icoinra huamamun? Futsanfoan ua oinshon mato yoifiaiton man ato icoinra huamaran, —ishon afu rafumisifo once yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ascano ato yoiquin, —Mun funia. Atohuunoashu naiyofiashu un afanan funia aton chaca soashoshquin ufu nipanonfo. Manifoti ato yoitacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ratoran futsanfoan uhuun tsain shara icoinra huatan unu muran iquimamuashu ufu Upa Dios icano nipatiroquin. Ascafia ratoran futsafoan nan tsain shara uhuunoa icoinra huayamashu ahuun chaca ahuun nupacunaca. Ascashufin omitsiscapanaca muran fotirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ascano ratoran ua icoinra huashon uhuunshon yoshin chaca futsamaquinoa potafain tsain shara tsoan nicayomisima cuscara yoifain ");
INSERT INTO mcdNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","rono paupan tsomashu yotucuyamarain rao paupan ayashu ahuuscayamacain isinin imisifo manmanshon caya huamashquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ato yoitan Upa Diosin atomaquishon nocon Ifo Jesús nai muran ihuini afu niaifocoin inon. ");
INSERT INTO mcdNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ascatan afu rafumisifo maitio foanfafaincaquin Jesushuunoa ato yoiaifono, nocon Ifon atofu yononi ahuamamishti ahuunshon huanonfo. Ascano nocon Ifoan tsainhuunoa ato yoini cuscan icoinra huanifo. Nanti.");
INSERT INTO mcdNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teófilo un mia cunu fomai futsafoan Jesucristohuunoa cunuafo cuscan mirifi min icoinra huacoinnon. Jesús acaiton oinmisifo cuscan yafi ahuun tsain yoimisifoan noco yoinifo cuscan nannori futsafoan aqui cununifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ascano urifi un nantifi yocapacuni Jesushuunoa aqui cunushquin. Nan caini cuscan huafain nan ahuamamishti huayopaonishaquin apa ari nai muran naso caini cani. Ascacun afu rafuafo un ato yoca urifi tapisharashqui. Ascashon cayacafi cunushon mia fomashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ascacun uhuun cunuhuunshon mia futsafoan yosiainfo cuscan min icoinra huacointiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ascacun natian un nica cuscan un mia yoinon. Herodes Judea anoa niaifoatian nantianri Zacarías nocofunu shara nanno ini. Naanfin Aarón ahuun funaquin. Ascashu nannoa ahuun caifohuunshon Dios cufimisi ipaoni. Aarón ahuun funafo shoco ranan. Nan shoco futsafoan aton niaifo Abías. Nanrifi Zacarías ahuun niaifo ini. Nan Zacarías ahuin Isabel arifi Aarón funa. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ascashon nan rafutan Diosin tsain cununi cuscan nicasharacoinpaonifo. Nantifi Diosin yononi cuscan tanasharamisifo. Nan rafutan tanasharaifoan Diosin oinpaoni. Ascacucai tsoan ato ahuashta rafatiro ipaonima. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ascafiashu facuoma rafu. Zacarías anifo icaino ahuinri yoshafo toosma ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ascano Abías ahuun shocofo nan ahuun yorafohuunshon Dios cufimisifo ato yoini isca huaquin, —Manfin natian siete oshatan Dios cufiti pushu muranshon man yonoshonicai, —ishon ato yoini. Ascano nannori Zacarías atofu ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nantianri Zacarías catonni Dios fu tsainti pushu muran iquishon ininti shara coanon. Nan ininti ahuun anu incienso. Nanscara cufimisifoan aton fuyamisi ipaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nan incienso fiin cuscara coaino yora ichapafo cufiti pushu umainti ano nishon Dios cufishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ascashon Dios cufiti camaqui incienso coa ahuun mumihuuri Diospan oinmati afu nai muran ica Zacariasqui niriscatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ascaino Zacarías mustairitan fasi ratucoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ascafiaiton Diosin oinmatinin afu nai muran icaton yoini isca huaquin, —Ratuyamahuu, Zacarías. Min cufiainton Diosin man mia nica. Min ahuin Isabel chipo furonanfacu nanushquin. Ascan caincun min anuquin Juanran min huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ascashu min fasi aqui unimasharacoinshquin. Ascaino yorafori fasi aqui unimacoinshquin caiano. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ascano Upa Diosirifi aqui unimashquin. Nocofunu fasi sharacoin iishquin. Ascashocai ahuara pau ayapacunacama. Fimi unu pau ayayamafain ayati futsa pauri ayashquima. Caiyaintian Diosin Yoshin sharapan nan iquishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nan nocofunuaitian ahuun caifo Israelifo Diosin tsain shara ato yoishquin ato chaca shatunonfo. Ascano aton Ifo Diosiqui nasononfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ascashu nan Juan Elías ipaoni cuscara arifi iishquin. Elías Dioshuunshon ahuun yorafo cayacafi icocoin tapimapaoni cuscan nanscarifi aqui Juanpan ahuun yorafo arifi ato tapimashquin. Ascano ahuun tsainhuunoashu ato apafo yafi aton facufo afanan noinanshcani. Ascashu nan Diosin tsain nicacasmamisifoan arifi aton chaca shatucashon Dios icoinra huafain shinansharashcani. Ascacun Juanhuunoashu ahuun caifofo itisharashcani Diospan furun atoqui nocoaitian a nicasharashcaniran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nicaquin Zacarías cumani, —¿Ahuuscashomun min yoiai cuscan un icoinra huatiroquin? Unfi anifocoinquin. Uhuun ahuinrifi yoshafoquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Afanan cumaquin, —Unfi Gabrielquin. Un Dios fu imisi. Ascacun nanton ua nichian un ahuun tsain shara mia yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ascan un mia yoiai cuscacai mian icoinra huaima. Ascan natiancai min afanan tsainyoima nan min facu caiyaintian. Un mia yoiai cuscafin nan apaiyaitian Diosin huaashquiquin, —ishon Diosin nai oinmatinin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ascaino yorafoan Dios fu tsainti pushu umaintishon cufinquin anaiticatan Zacarías mananifo. Ascafiaino Zacarías atoqui funa caiamaino yoinifo, —¿Ahuuscain Dios cufiti pushu murannoashu Zacarías saman huaimun? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ascariaifoanno atoqui cainfiashocai ato tsainquinima. A pucutiroma muuquin ahuun mucupan ato yoi fustini. Ascaiton onannifo Dios fu tsainti pushu muranshon Zacarías namapan cuscara oianran, icashu ahuun yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ascashu yorafohuunshon Dios cufimisifo ato yono anaiticatan Dios cufiti pushu murannoashu fonifo. Ascaino Zacarías arifi ahuun pushu ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ascashon chipo ahuinin facu nanuni. Ascashucai ahuun pushu murannoashu mucu fustiti oshu raqui caipainima. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ascashon Isabel shinanquin isca huani, —¡Aicho! Diosihuunshon uhuun funun ua facu nanumana. Diosin ua ashoan. Afin ua nanumapaiyaitian ua facu nanumana. Uhuun ramapaiquin. Asca natiancai afanan uhuunoa yorafoan yoitiroma isca huaquin, “Nacai facuyanacamaran,” ishocai yoitirofomaran, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Ascano seis oshu Isabelqui man caano Diosin nai oinmati Gabriel Mariaqui niriscatani. Nan María funuoma ini. José fu fiananfotaima afu iyopaonima. Tsoaricai afu imisima. Ascan José ahuun shunifin David iniquin. Nan Israelifoan ato niaifo ipaoni. Ascacun Diosin ahuun oinmati afu nai muran icaton yoini isca huaquin, —Galilea mai Nazaret pushurasi muran Mariaqui catahuun, —ishon ahuun oinmati Gabriel nichini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ascano aqui nocoshon yoini, —Un miqui oa. Diosin oian min fasi sharacoincun. Mia fasi noicoin. Nocon Ifo mifu icaran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ascaiton nicaquin María ahuun nomuran shinanpaini, —¿Raquiri ua yoipaimun? —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ascaiton afanan cumani, —Maria, ratuyamahuu. Diosin mihuun noifain miqui unimasharai. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ascan minfin natian furonanfacu nanuicai. Ascashu caincun min anuquin Jesusran, huaashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ascano caianshu niaifocoin iishquin. Diosin nai murannoaton ahuun shuni David niaifo ipaoni cuscan arifi apahuunoashu niaifocoin iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ascashu naanfin Israelifoan aton niaifo unupacunacamaran, —ishon Gabriel yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Afanan María cumani, —Uncai funuyamafinquin. Uacai tsoan tanamisima. ¿Ascan ahuuscashomun un facu nanutiroquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Diosin oinmatinin afu nai muran icaton afanan María cumani, —Diosin ahuun Yoshin Sharapan miqui oshon mia facu nanumashquin. Nanto ahuun curushhuunshon ahuamamishti huatiro. Nanhuunshon mia facu nanumashquin. Ascan nan facu cainshquiaifin shara fustisi imisiquin. Ahuashtacai chaca huamisima. Naanfi Diospan facuquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Min yaya yoshafoancai facu nanumisima. Ascan toosmaran huafiamisifo natian man facu nanua seis oshu man aqui caa. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","“Ascacun ahuacai Diosin aquimaracai,” non huatiroma. Nantofi ahuamamishti huatiroquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ascaiton afanan María cumani, —Unfin uhuun Ifoan oinmatiquin. Afifin nan apaiyai cuscan ua huatiroquin. Nan mian yoiai cuscan ua huanonquin, —ishon María yoiaino amaquinoashu yamariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ascano man shafa ranan finontan María ahuun yaya ano cai fasi coshi cani nocoriscapai. Nan Judea muran pushurasi ano machihuanrasifo ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nocotan Zacarías ahuun pushu muran iquitoshiquin ahuun yayan Isabel yoini, —Yayan, un mia oinyoiran, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ascaiton nicai Isabel ahuun shaqui muranshon ahuun facun potapotani. Asca huaino Diosin Yoshin Sharapan ahuun nomuran shinansharamani. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ascaino oi ashcafinin Isabel ahuun raru María yoini isca huaquin, —¡Aicho! Rato ainfo futsacai mia acai cuscan Diosin catoanma. Fasi mia shara huacoinna. Min facu chipo cainyano Apa Diosin aqui unimacoinqui a cushusharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ascan un ahuara shara huaa rafanancai Diosin ua shara huama. Ascashon uhuun Ifoan ahuun ahua uqui nichian ua oinyonon. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ascano min tsain nicai unimaqui uhuun shaqui muranshon uhuun facun ua potapotaca. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Upa Diosin nan min ishquiai cuscan mia iquisi tapimanaiton nantifi ahuun tsain min icoinra huaa. Ascacun Diosin mia unimamaran, —ishon Isabel ahuun raru María yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ascaiton María arifi ahuun yayan yoini, “Uhuun nomuranshon un shinanqui isca huaa, ‘Ifon min sharacoin. Tsoa futsacai mia cuscara sharama. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Min uhuun Numamisi Diosiran icashu uhuun nomuran un fasi unimacoinna. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ascashu un ahuun oinmati. Un ahuamafiacun uhuun ramapaiquin ua oinfafainni. Ascacun ua Diosin shara huaa cuscan yorafoan uhuunoa yoipacunacafo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diosin ahuamamishti huamisiton ua ahuara sharashtacoin ashoan. Aafin shara fustisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ascan ratoran futsan Dioshuunoa nicaquin ahuunoa shinansharafafainai. Nan cuscara yorafohuun Diosin ramapaipacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Diosin ahuun shinanpan ahuamamishti huamisi. Ascashon nan cacapaimisifoan aton nomuran shinanchacamisifo cuscan Diosin ato shatumafain atori onaintimai. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ascatan niaifofori Diosin ato shatumana afanan niaifo inonfoma. Ascashon nan ahuamafo ato shinansharamana nanfoan tapinonfo ahuun facufocashon. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ratoran futsa ahuuomafo foni cuscarafo fasi Diosihuunoa tapipai tanasharashcaquin. Nanscarafo Diosin ato cushusharatiro. Ascashon ahuara yopai cuscan ato inansharafain a tanasharaifoanri ato unimamashquin. Ascashon ahuara ichapa ayafofiashu Diosihuunoa shinanyamaifo copiquirifi ato ahuara inainma. Man mafo ichapayafiashu ato nomuran shinansharayamafain tsoa unimamisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ascafiaifoanno nocon caifofo Israelifofin Diospan oinmatifoquin. Ascashon non ahuara acai cuscan noco ashomisi. Nonfin noco shuni Abraham ahuun funafoquin. Ascacun nocohuun ramapaipacunaca. Nannori Upa Diosin nocon shunifo yoiyotianiran,’ ” ishon María yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ascashu oshu rafu non fusti ahuun yayan Isabel fu iyoni. Ascatan María ahuun pushu ano nasoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ascashu Isabel ahuun facu caiyaintian furonanfacu cainni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ascaiton a chaima icafo futan ahuun yorafoan nicanifo nocon Ifo Isabelhuun ramapaiqui facu cainmashara. Ascashu afu unimacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Ascatan ocho osha finontan Zacarías pushu ano ahuun yorafo funifo facushta ahuun foshqui rupa shatuni fucani. Ascashon apa anuquiri Zacariasran huapaifiaifoan ahua Isabel yoini, —Ma. Anoricai ahuun anu iquima. Juan ishquiran, —ishon ahuan yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cumanifo, —Ma. Rato min yorafoan ahuun anucai Juanmaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ascashon Zacariasrifi yocanifo ato mucumansi raquinimain ahuun facun anuicai. Ascafiaifoan tsaintiroma muuqui ahuun mucumansi mutoacufaini ahuun anu tapipaifiainfoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ato papio yocain mucu mushan mushainni. Ascaiton inanfo cunutan ato ismaiton oianfo Juan ini. Ascara oincani mustairitan, —Icon ahuun anu Juan ishquiran, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ascano ahuun facun anu cunutapai Zacarías afanan tsainnacahuani. Ascashon Dioshuunoa shara yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A chaima icafo futan Judea muran machi ichapa ano icafoan nicacaquin Diosin aca cuscan fasi sharacoin. —Noncai ascara nicayomisimaran, —icashon Zacarías yafi ahuin Isabel non aton facu Juanhuunoa yoiquin futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ascashon nan nicafoan yoinifo, —¿Ahuu cuscaramun nan facu iishquiquin? Man non oian facufiacun Diosin Yoshin Sharapan iquinaiton, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ascano facu ahuun apa Zacarías Diosin Yoshin Sharapan iquinaiton inon pacoai cuscan yoini isca huaquin, ");
INSERT INTO mcdNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Uhuun caifo Israelifoan nocon Diosin fasi sharacoin. Nocoqui oa noco numashqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Diosin nocon Numamisi nan ahuamamishti huamisi nocoqui nichian. Noco shunifoan aton niaifo David ipaoni. Nanton ahuun funa nocoqui nichian noco niaifocoin ipashanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nannori ahuun tsain inon pacoai yoimisisharafohuunshon Diosin yoiyoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ascashon yoiquin isca huani, ‘Un mato cushui. Nan mato noicasmamisifoan afanan mato ahuusca huanonfoma. Ascacun un mato Numamisi matoqui nichiran,’ ishon Diosin inon pacoai yoimisifohuunshon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","Ascashu noco shunifohuun Diosin ramapaipaoni. Abraham yoiyoni cuscacai Diosin ointi aquimanama. Yoiquin isca huani, ‘Un min funafo numashqui ato noicasmaifoan ato ahuusca huanonma. Ascano ratutama ua yonoshopacutirofoquin,’ ishon Diosin yoiyoni. Nocon Ifoan yoiyotiani cuscacoin man noco ashoin non isharacoincain non ahuun tsain tanapacushanon,” ishon Zacarías yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ascashon ahuun facu yomushtafiacun pushcoashu ishquiai cuscan yoiqui isca huani, “Uhuun facushtan, ‘Mirifi min Diosin tsain yoishomisiran,’ mia huaashquicani. Diosin nai murannoaton ahuun Yoshin Sharahuunshon ishquiai cuscan min ato yoifoanfafainquin isca huashquin. ‘Nocon Ifo oshquiquin itisharacahuun. Maton chacari shatucahuun a nocoaiton nicasharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","79","Diosin fasi nocohuun ramapaiqui nocon Ifohuunshon noco chaca soashona non afu ipashanon,’ ishon noco caifo min ato yoishquin. Nii muran faquishiainocai non oinsharatiroma. Chashamatimaisicai non fai tanasharatiroma nocosharapaiquin. Nanscarifiai nocon Ifo oataimano tsoan Diosin fai tapiataima. Shafaino fari otiro afanan faquish inonma. Nanscarifiai nocon Ifo nai murannoashu oataima nan faquish cuscara. Ascafia nan nocoqui oaitian nan chashamati cuscara shara iishquin. Ascashon Diospan fai noco oinmashquin ahuunoashu non Dios fu rafunon. Nonricai nai afanan ratutiroma. Naashumain non Upa Dios fu ipasharatiro. Non nicuri noco cushusharafain nocon ointi fucash huanonma non isharashquin,” ishon Diosin Yoshin Sharahuunshon Zacarías yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ascashu nan Juan facu pushcocoin sharani. Ascashon shara fustisi tanapaiquin ahuun nomuran Diosin tsain shara nanucoinni. Tsoa istaipama anori iyopaoni ahuun caifo nan Israelifo Diosin tsain yoiquin tau huaitian. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nan Juan caiyaintianri Romanonfoan aton niaifoan ahuun anu Cesar Augusto. Nanton ahuun yorafo yononi maitio ato tanan huashon aton anufo cununonfo ahuuti yoramainquin tapipaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nantianri Siria anoafoan ato niaifo ahuun anu Cirenio ini. Ascan nan Cirenio niaifoaitian ato tanan huaquin tau huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ascano nantifi focanashu aton mai anoashu cununifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ascacun José yafi María Nazaret pushurasi Galilea murannoashu focani Belén pushurasi Judea mai ano noconifo. Nan Belén David ahuun mai ini. José David ahuun funa. Ascacun arifi Belén ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María fu aton anu cunui focani fonifo. Ascashu man yoinanfo ini afu fiananshquin. Ascafia nantianri man facu nanua ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén ano nocoaitian facu cainti sunuin ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nannoashu furonanfacu caianshu facuyai tauni. Nantifi pushu fospifafainano tsoan ato iquimapaiyamaino inafoan pimisifo pushu facushta murannoashu furun cainni. Caincun ahuun rashutinin rashuni. Ascashon inafoan piafo muran furun ratani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nan Belén chaimashon chashohuan cushumisifoan nan yamutari aton inafo faasi funununshon cushushinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ascaino atoqui nocon Ifoan ahuun oinmati afu nai muran icafo fotoi chashapacucahuani. Faasi funununnoafo Diosihuunshon ato chashariscatani. Ascaino nan chashoanfo cushumisifo fasi ratui futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ascaifoan ato yoini, —Ratuyamacahuun. Un mato tsain fasi sharacoin yoiyoaquin. Nicai man unimaino manifoti anoafori unimanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na yamutafin Belén nan mato shuni David cainni anoashuri maton Numamisi cain huanquin. Naanfin Upa Diosin matoqui nichiaquin. Nan maton caifoan manamisifo. Nanrifi maton Ifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ascacun un mato yoi ahuuscashomain man fuchitiroquin. Nan facu ahuun rashutinin rashucai inafoan pimisifo muran racacun man fuchitiroquin, —ishon Diosin nai oinmatinin ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ato yoiqui unutapaiyaino samamashta atirifi Diosin oinmati afu nai muran ica atoqui cuyopacunifo. Ascashon Diosihuunoa yoisharacaquin isca huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Diosin fasi shara. Nai murancoin ica. Atirifoqui Diosin unimai. Nafo aton nomuran unimasharacaniran,” icashon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ato yoiqui anaiticatan atomaquinoashu Diosin oinmatifo nai muran fonifo. Ascaino nan chashoan cushumisifoan yoinifo, —Non Belén ano canon. Nocon Ifoan noco yoia cuscan non oin fonon, —icanashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ascashu ichocaquin María yafi José fuchitoshiquin oianfo facu inapan pimisifo muran fasi toca racai ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ascatan nan facu oianfo cuscan huafain ato yoifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ascan nan chashohuan cushumisifoan ato yoiaifoan nicacaquin yoinifo, —¡Aira! ¿Ahuuscashomun ascara shara noco yoiafoquin? —inifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ascacun María ahuun nomuran fasi shinanpaoni nan nicafain oian cuscan. Ascashori, —¡Aicho! Diosin noco shara huashoanran, —ishon shinanpaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ascashu nan chashohuan cushumisifo ato yoifoanfafaintacani aton inafo ano naso furacashon yoinifo isca huaquin, —¡Aicho! Dios fasi shara. Nan noco yoia cuscan huafain nanscaracoin man non oianran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesús cainta ocho oshatan nan facun ahuun foshqui rupa shatuni. Nantianri anuquin Jesusran huani. Nannori María facu nanuataima Diospan oinmatinin afu nai muran icaton yoiquin tau huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés Israelifo yononi isca huaquin, —Maton ahuin facu caianshu cuarenta oshatan Dios fu tsainti pushu muran iquiyotiromaran, —ishon ato yononi. Ascacun María futan José aton facu man cuarenta oshatan Jerusalén ano iyonifo. Dios fu tsainti pushu muranshon apa Dios inanshcaquin. Ascano Dios fu tsainti pushu muran iquicashon yoinifo isca huaquin, —Upa Diosin nocon facu non mia ihuushona mia inainyoshquin mia yonoshopacushanon, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ascacun nannori nocon Ifoan yononi isca huaquin, —Nan furonanfacu cain tauafo nocon Ifo Diosina. Ascashon afi amapaiyai cuscan ato huapashanon, —ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nantianri José yafi María Diosin yononi cuscain ruhui rafu iyamarai ruhui cuscara rafu foni nan ahuun caifohuunshon Dios cufimisi María inanni a rutushonon. Ahuun chaca soapaiyaiton Diosin ashonon. Ascashon a tanasharafain ismanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ascan nantianri Jerusalén anoa nocofunun shara ahuun anu Simeón. Diosin Yoshin Sharapan iquina. Nanton Dios tanasharashon cufifafainpaoni. Ascashon nan Diosin catoan Israelifoan aton Numamisi manafafainpaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ascacun Diosin Yoshin Sharapan ahuun nomuran yoini, —Min naataishoma nan Diosin catoan maton Ifo Cristo min oinshquiran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ascashon Diosin Yoshin Sharapan shinanmani cuscan Israelifoan Dios fu tsainti pushu muran iquini. Ascaino José yafi María arifi aton facuya iquifainnifo. Diospan tsain yononi cuscan aton facu huashoshcaquin iquinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ascano Simeón atoqui otan yoini, —¡Aicho! —ianan facu chishtoinifoanni. Ascatan Dios yoisharaquin isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ifon, min nantifi tapicoian. Mian yoiyotiani cuscan mun oian. ¡Aicho! Natian unimacaini un nai manmain min facu nan nocon Numamisi mun oianmashu. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nantifi manifotiton aton Numamisi min nocoqui nichian. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ascacun nocon caifomafoan mia onanyamafiamisishaquin min facuhuunshon mia onanshquicani. Ascafia nonfin min yora Israelifoquin non tapicoinshquin na facuhuunoashu Diosin nocohuun ramapaiyaiton. Ascano ahuunshon min noco yoiyoatiani cuscan noco huashoshquiran,” ishon Simeón yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ascaiton nicacaquin José futan Marían aton nomuranshon shinanquin isca huanifo, —¡Aira! Noncai iscara nicayomisimaran, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ascashon Simeón Diospan Yoshin Sharahuunshon ahua María yoisharaquin isca huani, —Min facu nan nocon caifo Israelifo atirifoan nicacasmacanashu omitsiscapanacafo. Ascan min facu nicacasmaifoanno min fasi shinanshquin. Ascafia nocon caifo atirifoan min facu icoinra huacanashu fasi unimacoinshcani. Ahuunshon yora ichapafain aton nomuranshon shinainfo cuscan puashcaniran, —ishon Simeón yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nannori ainfoan ahuun anu Ana, Fanuel facu. Nanton arifi Dioshuunshon inon pacoai cuscan yoipaoni. Nanrifi Aser ahuun caifo ini. Siete fari funun fipaoni. Ascafiashu amaqui funu naniano man Ana yoshafoshta ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ascashucai ochenta cuatro fari funuya. Nantianri Dios fu tsainti pushu muranshon Dios cufinquin piqui tunufafainpaoni. Nan muransi ipaoni ahuun Ifoan amapaiyai cuscan aashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ascano José yafi María Simeón fu tsaincaifoanno nantianari atoqui Ana oni. Oshon facu fuchitoshiquin yoini, —¡Aichoran! Upa Diosin, natian min facu min nocoqui nichian nocon Numamisi ipashanon, —ishon yoini. Ascashon nan facu oian cuscan Jerusalén anoafo nan manamisifo Anapan yoiqui isca huani, —Mun nocon Numamisi oincoian. Man nocoaran, —ishon ato yoipacuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ascano José fu María Diosin tsain yononi cuscain aton mai Nazaret ano nasonifo. Nan Nazaret Galilea muran. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nannoashu facu mutsisipacoin yosini. Shafatifi ahuamamishti tapicoinfafaini. Diosin ahuun noiquin shara fusti huamafafainni. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ascano nan faritifi Jesús apa yafi ahua Jerusalén ano fopaonifo. Diosin nai oinmatinin aton shunifoan furonanfacu iyoafosi ato finonmashoni shinantacani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús man doce fari aqui caano apa futan ahuan nan imisifo cuscan fuusin focaquin iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ascashu man fuusi anaiticatan María yafi José aton pushu ano naso furanaifoanno. Jerusalén ano nan facu Jesús atomaqui nitufiaitocai apa futan ahuan tapinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ascano atofu cai shafain icashon. Man shafa fusti fofaicatan ifiacucahua oian yamaiton. Funacufaincaquin ahua futan apa ahuun yorafo yafi afu rafuafo yocanifo, —¿Man Jesús oianmamun? —ato huaifoan. —Ma. Noncai oianmafinquin, —huaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Afanan nasofaincani fonifo Jerusalén ano funai focani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ascano focashon rafu non fusti oshatan funacaquin Israelifoan Dios fu tsainti pushu muranshon. Moisés cununi cuscan tapimamisifo ya tsaoshon yoiaifo cuscan nicaquin ato yocariaiton apa futan ahuan fuchinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ascaiton nicacaquin yoinifo, —Nicacapon. ¿Ahuuscashomun na furonanfacu ato cayacafi cumasharaiquin? Fasi tapisharacoian, —ishon nan nicafo cuscan afi ranan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ascano ahua futan apan fuchicashon yoinifo, —Oinpon. Nocon facu iyoafofo nastui tsaoa. ¿Ahuuscaimun noco facu icuscaiquin? —huanifo. Ascashon ahuan cunani, —Cocan, ¿Ahuuscai upa yafi min noco funamanain? ¿Min tapiamamun upa futan un mia funai? Non fasi ratua, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús ahua cumani, —¿Uhuan, ahuusca huaashquin man ua funaiquin? Man tapiamamun nuno uhuun Upa cufiti pushu muran un iquia ahuun tsain nicasharashquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Furumun yoiai cuscacai ahua futan apa tapinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ascashu ahua yafi apa fu Nazaret ano nasoni. Ascashon nantifi apa futan ahuan yonoaifo cuscan yafi yoiaifo cuscan nicacoinni. Ascatan furunmun yoia cuscan ahuan ahuun nomuran shinanfafaini. ");
INSERT INTO mcdNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ascashu Jesús pushcosharacoinni. Diosin ahuun shinanpan shinanmasharamanaino mapo sharayacoin ini. Ascacun Apa Diosin ahuunoa shinansharaquin yoini isca huaquin, —Uhuun facun Jesús fasi sharacoin. Un ahuun noicoinran, —ishon yoini. Yorafoan arifi Jesushuunoa nannorisi shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nantianri Tiberio Romanonfoan aton niaifocoin ini. Quince fari niaifoyoni. Nantifiton aton niaifocoin. Ascano rafu non rafuri niaifo patasharinoa nannori afu ipaonifo. Futsan ahuun anu Poncio Pilato nan Judea mai anoafoan aton niaifo. Galilea mai anoafoan aton niaifo Herodes ipaoni. Chipocu Felipe Iturea yafi Traconite anoafoan aton niaifo ipaoni. Abilinia anoafoan aton niaifo Lisanias ipaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","3","Nantianri Anás yafi Caifás ahuun caifohuunshon Israelifo Dios cufimisi aton niaifo rafu ipaonifo. Ascaifono Juan tsoa istapamashon icamanoshon Diosin yononi. —Min caifo yoitahuun isca huaquin, “Maton chaca shatucahuun. Man chaca shinain cuscan afanan shinanyamacahuun. Diosin mato yoia cuscan nicacahuun. Man ascaiton Diosin mato chaca rau huashotiro. Ascacun un mato unu muran iquimapacutiro maton chaca shatushon man ismanon.” Anori ato yoitahuun, —ishon Diosin Juan yononi. Ascacun Diosin yoini cuscan Juanpan unu Jordán cusumunshon ato yoiriani. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nannori Juanhuunoa Isaías inon pacoai cuscan yoimisiton cunuquin isca huani, “Tsoashta icamanoshon Diosin yononi cuscan oi ashcafinin yoiquin isca huanonpacoi, ‘Nocon Ifo nocoqui samamashta ooshqui. Ascacun itisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Un tsoa cuscaramaran iyamacahuun. Ascatamarocon uncai ahuama. Uhuun numamisi un yopacoinran,’ icahuun. Ahuara onushon afanan nasocahuun. Cayacafi isharashcaquin. Man ipaoni cuscan afanan ayamacahuun. Nantifi mato chaca potacahuun nocon Ifo fusti tanasharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nan Diosin catoan nocon Numamisi oaiton nantifiton oinshquicaniran,” ishon Isaías cununi. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ascano yorahuanrasi Juanqui funifo ato unu muran iquimapacunon. Ascashon ato yoiquin isca huani, —Manfin rono paupaton facu cuscaracoinfoquin. Icoinra huayamaifoan Diosin atoqui sinaqui amaquishon ato potano omitsiscapanacafo. Ascan manfin nanscarafoquin. Omitsiscapanacafo muran focasmafiaquicai maton chaca man shatupaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ascafia chaca shatucoincashon Diosin mato yoia cuscan nicacoincahuun. Man ipaoni cuscari afanan ayamacahuun. Man ascaiton yorafoan ointirofo afanan chaca huapaitama Dios fusti man tanasharaiton. Maton nomuran shinanquin isca huayamacahuun, “Nonfin Abraham funafo non ahuun caiforiquin iyamacahuun. Diosin Abraham yoiyotiani cuscan nocorifi ashotiro. Ascan Diosin noco onaintimashquimaran,” ishon anori shinanyamacahuun. Diosin onihuapaiquifin na unu cusumunnoa toquirifo Abraham ahuun funafo oni huatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Fana fimi sharayamaiton ifoan ahuun tapo nantifi ruratinin shatuquin cuyoshon chii muran potatiro coi futsunon. Nanscarifiai natianri Diosin man itishara chaca shatutama man isharayamacaiyaiton mato omitsiscamapacushquiran, —ishon Juanpan ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nicacaquin cumanifo, —¡Ohua! ¿Nonmun ahuuscaicain? —huaiton ");
INSERT INTO mcdNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ascan Juanpan yoiquin isca huani, —Nan sahuuti rafuyaton futsa ahuuomacoincun inancahuun. Nanscarifi aquin nan tushuyaton a futsa tushuomacun inancahuun, —icaiton nicacani. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niaifo pui fishomisifori aqui fucashon yocanifo, —¿Tapimamisiton, nonmun ahuuscatiroquin unu muran iquimamushquin? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ato cumani, —Afanan maton niaifoan yonoamati finonmafain pui fiyamacahuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ascaino atirifi ranushumuafoanri yocanifo, —¿Ascan nonmun norifi ahuuscatiroquin? —huaifoan atori yoiquin isca huani, —Pui fianpaiquin ato asca huayamacahuun. Pofuyamacahuun. Man tapifiashon yora futsan ayamafiacun, “Nanto acaran,” ishon maton niaifo yoiyamacahuun. Nan mato niaifoan mato inantisiya unimacahuun. Tsain chipuyamacahuun, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ascaiton nan Cristo manamisifoan Juan nicacani ato nomuranshon shinannifo, —Nanracafin Cristoquin. Nan Diosin catonni, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ascaifoan Juanpan ato cumani, —Uncai Cristoma. Unfin mato unu muran iquimapacuaquin. Ascan nantofin ahuun Yoshin Shara matoya rafumapacui oiquin. Ahuun shinansharapan maton nomuran shinanmanon. Ascashu matofu rafuano nantifi ahuara chacafo ahuunshon shatuashu a cuscara shara ishcaquin. Naanfin Diosin catoanquin. Nantofin ua fasi finoncoian. Ahuamamishti huatiro. Ahuashta chaca huayomisima. Uncai ascarama. Un ahuara shara huahuu rafanancai un ahuun oinmatima. Uhuun ramapaiyamainoricai un ahuun oinmati icuanama. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ascan natian man itishara a icoinra huafo yafi a nicacasmamisifo ato pashcanan huashquin. Ascashon nan icari nan icoinra huafosi ihuicoinshquin afu isharapacunonfo. Asca nan nicacasmamisifo chii urumanhuan muran ato potai anoashu omitsiscai unupacunacafomaran, —ishon Juanpan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ascashon tsain futsafori ato yoiriani aton nomuran nanumapaiquin chaca shatunonfo. —Nocon Ifo Cristo nocoqui oi noco numashqui, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Ascashon Juanpan nan niaifo Herodes yoiqui isca huani, —Ushto ahuin fianfain ahuara chacafori min huaran, —ishon yoini. Asca huaiton nicaquin Herodes Juan cunu muran iquimani. Ahuara chacafo huafiamisishaquin Juan iquimaquicaifin fasi chaca huaquin finacoinniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Juan cunu muran iquiataima yorafo unu muran iquimapacuni nantianri Juanpan Jesusrifi unu muran iquimani. Asca huatan cainmainifoannaino Jesús Apa Dios cufini. Ascaino nai murannoashu ruhui cuscara Diospan Yoshin Shara nai ariashu aqui fotopacucahuani. Fotoaino nai murannoa oi nicani yoiquin isca huaiton, —Min uhuun Facucun fasi un mihuu noicoin. Un miqui unimacoinran, —ishon Apa Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta fariatian tau huaquin yorafo yosini. Ascano yorafoan shinancaquin Jesús José ahuun facuran, huafiainfonocai ahuun facucoin inima. José ahuun apa Elí ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ahuun apa Matat. Matat ahuun apa Leví. Leví ahuun apa Melqui. Melqui ahuun apa Jana. Jana apa José. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ahuun apa Matat. Matat ahuun apa Amós. Amós ahuun apa Nahúm. Nahúm ahuun apa Esli. Esli ahuun apa Nagai. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ahuun apa Maat. Maat ahuun apa Matatías. Matatías ahuun apa Semei. Semei ahuun apa Josec. Josec ahuun apa Judá. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ahuun apa Joanán. Joanán ahuun apa Resa. Resa ahuun apa Zorobabel. Zorobabel ahuun apa Salatiel. Salatiel ahuun apa Neri. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ahuun apa Melqui. Melqui ahuun apa Adi. Adi ahuun apa Cosam. Cosam ahuun apa Elmadam. Elmadam ahuun apa Er. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ahuun apa Josué. Josué ahuun apa Eliezer. Eliezer ahuun apa Jorim. Jorim ahuun apa Matat. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ahuun apa Leví. Leví ahuun apa Simeón. Simeón ahuun apa Judá. Judá ahuun apa José. José ahuun apa Jonam. Jonam ahuun apa Eliaquim. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ahuun apa Melea. Melea ahuun apa Mena. Mena ahuun apa Matata. Matata ahuun apa Natán. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ahuun apa David. David ahuun apa Isaí. Isaí ahuun apa Obed. Obed ahuun apa Booz. Booz ahuun apa Sala. Sala ahuun apa Naasón. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ahuun apa Aminadab. Aminadab ahuun apa Admin. Admin ahuun apa Arni. Arni ahuun apa Esrom. Esrom ahuun apa Fares. Fares ahuun apa Judá. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ahuun apa Jacob. Jacob ahuun apa Isaac. Isaac ahuun apa Abraham. Abraham ahuun apa Taré. Taré ahuun apa Nacor. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ahuun apa Serug. Serug ahuun apa Ragau. Ragau ahuun apa Peleg. Peleg ahuun apa Heber. Heber ahuun apa Sala. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ahuun apa Cainán. Cainán ahuun apa Arfaxad. Arfaxad ahuun apa Sem. Sem ahuun apa Noé. Noé ahuun apa Lamec. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ahuun apa Matusalén. Matusalén ahuun apa Enoc. Enoc ahuun apa Jared. Jared ahuun apa Mahalaleel. Mahalaleel ahuun apa Cainán. ");
INSERT INTO mcdNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ahuun apa Enós. Enós ahuun apa Set. Set ahuun apa Adan. Nan Adán ahuun apa Dios. Nan Adán Diosin onihuani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ascano Jesús unu Jordán anoashu nasoni. Ascashon Diosin Yoshin Sharapan iquinaino tsoanshta icamano cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nannoashu cuarenta oshatan nannoshon Satanás nan yoshin chacapan chaca huamapaipaoni. Ascano nantianri ahuashta pia inima. Ascashu fasi fonicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ascaiton Satanás yoini, —Min Diospan Facumainquin na toquirifo misi onihuahuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús cumaquin, —Uhuun Upa Diosin tsainhuunoa cununi isca huaquin, “Noncai misi fustihuunoashu ipatiroma. Diosin noco yoiai cuscan nan fusti non fasi yopacoinran,” —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satanás Jesús nai sumunmun iyoshon arishon manifoti ismariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","—Oinpon. Ua ifoafain mian yonoshonaitofin nan min oiainfo un mia inantiroquin. Ascashu nantifi manifoti sharashtacoinfoan aton niaifo min itiro. Nantifi na maifotifi uhuuna. Ascacufin un tsoara inanpaiquin un inantiroquin ahuuna inon, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús cumani, —Ascafia Diosin tsainhuunoa cununi isca huaquin, “Maton Ifo Dios fustifin man ratoconun mai chachishotiroquin. Nan fustimain noco ifocun. Ascashon non yoitirori ‘Min uhuun Ifocun. Un mia fasi noicoinran,’ ishon non yoitiroran,” —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jerusalén ano Jesús iyoni. Nannoshon Dios fu tsainti pushu pumancaya cuyacoin iyoshon yoiquin isca huani, —Minmain Diospan facuquin nuriashu pacucaintahuun. Diosin tsain mihuunoa cunushoni cuscan aquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Nantofin ahuun oinmatifo afu nai muran icafo yonoaino mia cushuiquin min ahuuscanonma. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Min pacuaiton mia achicani. Min toquirifoqui pacui rutunonma. Ahuuscatama,” nannorifi Diospan tsain cununiquin, —ishon Satanás yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Afanan Jesús cumani, —Ascafia Diospan tsain cununiri isca huaquin, “Ahuara musunicoinquin shinanyamahuu uatsi Diosin cushuiquin,” cununiran, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesús chaca huamapairiashu caaquin Satanás shinanni, —Un chipo afanan Jesús chaca huamayoshquiran, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ascatan Jesús Galilea ano nasoni. Diosin Yoshin Sharapan a iquinaino ahuunoa nicanifo. Galilea ano icafoan nicaifoanno a chaima icafoanri nicanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Israelifoan aton ichananti pushufo muranshon ato yosifoanfainaiton oincani fasi aqui unimacoinnifo, Ascashon, —Na nocofunun sharacoinran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ascacaini cai nan pushconi Nazaret ano cani. Nannoashu Israelifoan aton tunutitian nan imisi cuscan ato ichananti pushu muran iquishon ninacahuan Diosin tsain Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nan Isaías Diosin tsain yoimisiton cununi cuscan Jesús inainfoan fupoacufoan nan yoipaiyaino fuchitan ato yoiqui isca huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Diospan Yoshin Shara ufu ishon ua catoan. Ascashon ua nichian un ahuuomafo tsain shara yoifain nan cunu muran iqui cafiscaafo un ato caimanon. Ascashon fushofori un caya huai oinsharanonfo. Omitsiscaifori un numai afanan omitsiscatama isharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A mia nicasharaifo ato yoihuu isca huaquin, Natian Upa Diosin unimayanan mato shara huafain mato numashquiran,” ua huaran ishon Isaías cununi cuscan Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ascashon ato Diosin tsain yoiqui anaititan ahuun libro fupoacufoan nocofunu futsa inantan tsaopacucahuani. Ascaiton nantifiton oinquin futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ascaiton ato yoiqui isca huani, —Na rama un mato yoiai cuscan uhuunoa Isaías cununi cuscacoin natian man aaran —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ascaiton nicacani mustairicatan yoinifo, —Ahuun tsain fasi sharacoin. ¿Nocofunu sharacoinfiashon ahuuscashon iscara tsain shara noco yoimun ahuamafiashon? Naanmun José ahuun facu, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ascaifoan Jesús ato yoini, —Noco shunifoan yoini cuscan marifi raca man ua yoiqui isca huapai, “Min caya huamitsamisimainqui min futsafo caya huaa cuscan mifiri caya huamuhuu,” ishon raca man ua yoipai. Ascashon man raca ua yoipai isca huaquin, “Man non nica min Capernaum anoshon tsoan atiroma cuscan min ato huashoan. Ascan nuno min pushconi anoshori noco nanscarifi huashohuun,” ishon raca man ua yoipaiqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ascacun un mato icon yoi. Diosin tsain yoimisiton cainni anoshon tsoancai nicapaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Un mato cayacafi yoi. Nocon shuni Elías niyopaonitian nocon mai Israeli ano ainfon funu amaqui naa funuomafo ichapa ini. Nantianri fari rafu non fusti nushmancayan oi funima. Ascano tushu yamacoin ipaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ascafia Upa Diosicai noco shuni Elías nocon caifo funuomafo ano nichinima. Ascatamarocon Sarepta mai anoa funuomaqui nichini pimanon. Nan pushurasi Sidón chaimashta. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nan Israel anori yora ichapa isinincani cooyo cuscara tocoi futsuafiafocai nocon shuni Diosin tsain yoimisi Eliseocai nocon caifofo caya huatama. Nan Siria mai anoa fusticoin caya huani. Nancai Israeli inimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ascano ato caifo caya huatama caifo futsa fusti caya huani nicacani fasi Jesusqui sinacoincaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Achicashon Nazaret pasoato iyonifo. Nanno mahua cuyacoin anoshon potapaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ascafia potapaifiaquicai tsoan anima. Jesusrocon ato rahuin yocofaini atomaquinoashu cafiaitocai tsoan puusanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ascashu Jesús Capernaum mai ano cani. Nan Capernaum Galilea muran ini. Nannoshon Israelifo tunutitian ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ascaiton nicacani, —Nicacapon. Ahuun tsain sharacoin. ¿Ahuuscashucon iscara tsain noco yoimun? Ahuun tsain niaifoan tsain cuscararan, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ascaino Judiofoan ichananti pushu muranshon nocofunu yoshin chacanun ahuun nuushon fiisimani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Asca huatan nan yoshin chacanun Jesús yoini, —Minfin Jesús Nazaret anoaquin. ¿Min noco fucash huai oamun? Noncai mi futan ahua huatiroma. ¿Omitsiscapanacafo muranri min noco potai oamun? Unfin mia onanquin. ¡Ohua! Noncai mia ahuusca huatiroma. Miamain Diosin catoancun, —ishon yoshin chacanun yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ascaiton, —Tsainyamahuu. Nocofunumaquinoashu catahuun, —ishon yoshin chaca Jesús curushcain nichini. Asca huaiton nan yoshin chacapan nocofunu mipuafain potafaini amaquinoashu yoshin chaca cafiaquicai ahuusca huanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ascaiton oincani mustairicatan afi ranan yoinancaquin yoinifo, —Jesús fasi ahuamamishti huatiro. Iscaracai ahuashta non oinyomisima. ¿Ahuuscashomun ahuun tsainmansi curushcai yoshin chacafo atomaquinoa potaquin? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ascatan nan Jesús aca cuscahuunoa yorafo yoifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ascacaini Israelifoan ichananti pushu murannoashu cai Pedro pushu muran noconi. Nanno Pedro ahuun raisi yoshafo fasi yonai omitsiscacoinnaiton Jesús yoishonifo, —Na isinincai cayahuapun, —huaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Amanaon ota catipacucahuan yoini, —Ahuun yona matsiriscahuun, —huaino samamashtacoin a yonai matsiriscatani. Ascano funinacahuan nan isinincama ointsa sharacain ato pimashquin pichacufaini. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ascano man fari caino isinincai futsa futsatapafo yorafoan aqui ihuunifo ato cayahuamapacunon. Ascacun ahuun mucuman ato ramanpacuaino cayai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Atirifi yoshin chacafo atohuun nuufafaina Jesús atomaquinoa potaino fiisifainfainquin yoinifo, —Minfin Diospan Facuquin, —ishon yoshin chacafoan Jesús yoinifo. Ascaiton Jesús curushcain ato asca huani, —Tsainyamacahuun. Uarifi anuyamacahuun, —ato huaino manmain tapiafoanfin a Diosin catonnicun. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ascashu shafacuaino Jesús Apa Dios cuficai tsoan istaipama ano cani. Ascacun yorafoan funaquin fuchicashon yoinifo, —Nocomaquinoashu afanan cayamapun. Nuno no fu ipun, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús ato cumani, —Un nan pushurasi futsafo muranri uhuun Upa Diosin tsain shara un ato yoifoanfafainon ua nichini. Ahuu cuscaramain uhuun Upa Diosin niaifoan ahuun yorafo iquinai cuscaraqui. Un nanscanon ua nichini un ato tapimanon, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ascashon Judea maitio Israelifoan ichananti pushu muranshon ato Diosin tsain yoiriani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Shafa futsaino Jesús ianmanhuan Genesaret cusumun ini. Ascaino yorahuanrasi aqui funifo. Diospan tsain nicai fucani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nan chaimanoa shasho rafu rutica Jesús fuchini. Ifofoan aton nushuti chocaifono. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ascatan nan futsa muran Jesús nanuinacahuani. Nan shasho Simonna ini. Ascashon nan yoini, —Ua onanshta shasho putsiquishohuun. Un anoshon ato yosinon, —ishon yoini. Ascatan shasho cusha camaqui tsaoinacahuan ato yosini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ato yoiquin anaititan Jesús Simón yoini, —Simón, noa ano focashon mato nushuti potacahuun shimanfo fiishcaquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ascaiton Simón cumani, —Tapimamisiton, non nushushifiaquicai shiman fustishta non fiishiama. Non fasi yonoshina. Ascafia min noco yoiai cuscan natian non huaicai, —ishon Simón yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ascashon aton nushutininhuan pochinifo. Pochishon muafo shimanfoan nushutininhuan fospicoinshon fashnuqui rashquini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ascaiton a shasho futsa murannoafo atirifo cunaquin ato mushananni ato futan inamashcaquin. Ascaino furiscatan ato muran nanuinifoan rananfaitan shasho muran nanunifo. Ascashon shimanrasi shashohuan rafu fospicoinni. Unu cufirisicoinni shashohuan rafu shimanfoya iqui cuani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Nan Simón Pedro futan nushumisi rafu Santiago yafi Juan Zebedeo facu rafu inifo. Nan rafu non fustifain nushumisicoinfo. Ascaiton ato futan nushumisi futsafoanri shasho rafu fospicoian oincani mustairicatan yoinifo. —¡Oincapon! ¿Ahuuscashomun shiman ichaparasi fiafoquin? —icashu atoqui yoinannifo. Ascaiton oin Pedronun shasho naquishon Jesús ratoconun mai chachishon yoini, —¡Ohua! Ifon ufin nocofunu chacaquin. Asca minfin sharacoinquin. Chaca yafi sharacai ositiroma. Ascacun umaquinoashu catapun, —Pedronun huaiton. Jesús cumaquin, —Ratuyamahuu. Min shafatifi nushumisifiashon natian min uhuun Yoshin Sharahuunshon uqui yorafo ihuushqui ua icoinra huanonfo, —ishon Jesús Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nicacatan aton shasho rafu cusumun corafainnifo. Ascashon nantifi aton ahuarafoya ato yorafori potafaini Jesús fu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Shafa futsaino Jesús pushurasi ano ini. Nannoshon nocofunu ahuun yoratishon ranimamishti rashquishi futsuaton cahuanquin Jesús fuchitan fuopacucahuan yoini, —Ifon, ua caya huapaiquifin mian caya huatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús aqui mupishon yoini, —Icon un mia caya huapai. Asca natianfin min cayaicain, —huaino. A rashquishi futsua cayariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cayacun Jesús yoini isca huaquin, —Un mia cayahua cuscan tsoa yoiyamahuu. Noco caifo ahuunshon Dios cufimisi ismatahuun. Ascashon Moisés noco yononi cuscan chashoanun facu a inantahuun mia rutushonon. Min chaca soafain min caya cuscan ato ismashquin. Ascano tapitirofo Moisés noco yononi cuscan min aiton, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Asca huafiaino ahuunoa nantifi yoifoanfaini. Ascaiton nicacanashu Jesusqui funifo ato caya huamapacunon. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ascacaini cashon tsoan icamanoshon Apa Dios cufin capaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Shafa futsaino Jesús ato yosini Fariseofo yafi Moisés yononi cuscan tapimamisifori nanno tsaoacunifo. Ascaino pushurasiti Galilea anoafo yafi Judea mai anoafo non Jerusalén anoashuri aqui funifo. Diosin curushhuunshon Jesús isinincaifo nannoshon ato caya huapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Ascaino nocofunu afi raqui cayamacai afiri ahua huatiroma ahuun yorafoan Jesús shinanmaqui shuhua naratashon iquimapaifiafo yorahuanrasi fospicoian ini. Ascano foman caya ina cashon tapa tsucashon Jesús nia naman yora huanrasi nastui shuhua ya ratapacufoannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ascaiton Jesús oian ahuun yorafoan fasi icoinra huaifoan oinquin Jesús a isinincai yoiquin isca huani, —Uhuun yorashtan, natian mun mia chaca soashona, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nicacani Fariseofo yafi Moisés yononi cuscan tapimamisifoan yoinifo, —¡Ajaa! ¿Na nocofunumun tsoaquin? Fasi Dios chaca huai. Natocai chaca soatiroma. Diosin fustitofin chaca soatiroquin. Ascan naton noco parapai. “Un Diosiran” noco huamapai, —ishon aton nomuranshon shinanchacanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ascaifoan onanshon Jesús ato yoiquin isca huani, —¿Ahuuscaquimun mato nomuranshon man amaquiri shinanchacaiquin? ");
INSERT INTO mcdNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Unfin Cristoquin yorafoan aton chaca un soashotiro. ¿Ascan ahuuscacaimun un huaicai? Un chaca soashoyamaraquimun un caya huaiquin. Ascacun un mato ismai Upa Diosin ua catoan. Ahuunshofin un chaca soafain yorafo un caya huacointiroquin, —ishon ato yoini. Ascatan a nocofunu afi raqui cayamacai afiri ahua huatiroma yoini, —Min pushu ano min shuhua ya funicaitahuun, —ishon Jesús yoiaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Funinaca huantan ahuun shuhua papifaiquin yoifoni, —¡Aicho! Min ua caya huaa sharaquin. Fasi Dios sharacoin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ascaiton oincani nantifi mustairicatan yoiquin isca huanifo, —Dios tsoa cuscarama. Fasi sharacoin. Non oinyomisima cuscara non oianran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nanscacaini caaquin Jesús oian Roma anoa niaifo pui fishomisi tsaoa ini. Nan nocofunun ahuun anu Leví. Ascaiton Jesús yoini, —U fu cahuun, —huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Funina cahuatan nantifi potafaini afu cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ascashu afu cai ahuun pushu ano nocoquin Leví Jesús yoini, —Nuno uhuun pushu muran iqui ohuu. Uhuun yorafo yoimanashu un ato futan mia fuusishonon, —huani. Ascaino yorahuanrasi aqui funifo. Roma anoa niaifo pui fishomisifo yafi futsaforifi aqui funifo ato futan pishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ascaifoan Fariseofo futan Moisés yononi cuscan tapimamisifoan Jesús fu rafumisifo yoini, —¿Ahuuscain man pui fiimisifo yafi yora chacafo futan man piiyain? —ato huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ascaifoan nicaquin Jesús ato cumani, —A isinincaifomacai caya huamitsamisi yopacanima. Asca nan isinincaifofin fasi caya huamamitsamisi yopacaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nanscarifi aquin, “Uncai ahua chaca huamisimaran,” icaifocai un ato chaca soashotiroma. Asca tsoan yoiqui isca huai, “Unfin fasi chaca huamisiquin. Un Numamisi yopacoinran,” icaifofin un ato chaca soashotiroquin, —ishon Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ascaiton futsan Jesús yocani, —¿Ahuuscai mifu rafuafoan piqui tunumisimamun? Juan fu rafumisifoan piqui tunufain Dios cufimisifo. Nanscarifi Fariseofo yafi afu fomisifoan huamisifo. Ascan manfin pifain ayafain huamisiquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ato cumani, —Nocofunu fu ainfo fianainnoricai unimai fusicaquin tsoan piqui tunutiroma. Nanno funu anocai ato chani huaifoan piqui tunutirofoma unimamain acaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ascafiaino funu amaqui rutuafono shinancaquin piqui tunutiroforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ascashon afanan Jesús ato yoiquin isca huani, —Tsoancai sahuuti shuni fashnucun poto funapan icushtiroma. Asca huashon poto funapan icushuano ustui futsuashu chacanai finatiro. Aquirifi sahuuti shuni anaitiriscatiro. Afanancai funa cuscara itiroma. Nanscarifiai un mato yosiai cuscan nicacoinshocai man apaoni cuscan afanan man huatiroma. Tsoan ua tanacoinshon ipaoni cuscan cachiquiri huacointiro. Ascashu funa cuscara shara iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ascashon tsoancai fichi tutso shuni muran vino funa nanutiroma. Fichi tutso toshacainaino vino funa cuyofoi chacanai futsutiro. Nanscarifiai maton shunifoan mato yosimisi cuscan yafi un mato yoiai cuscacai nan rafu ositiroma. Un mato yosiain cuscacoin nannori Diospan tsain shara. Ascafia mato shunifoan mato yosimisifo cuscacai anorima. Nan tanashucai man isharatiroma. Nan rafu osishon nicapaiquicai man shinansharatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ascacun vino funa fichi tutso funa muranri nanua sharacoin itiro. Nanscarifiai ratoranfoan ipaonifo cuscan unucatan un ato yosiain nan fusti tanashu isharacointirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tsoan puti pau ayatiashocai afanan fata ayapaitiroma. Nanscarifi aquin yorafoan yoiqui isca huatirofo, “Un ipaoni cuscan un afanan apai. Uhuun shunifoan ua yosia cuscan shara. Nan fusti un tanapai. Ascacun tsain futsan un yopaimaran,” —ishon shinantirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ascatan Israelifoan tunutitian Jesús yafi afu rafuafo mau mapai focaquin trigo mutuscashon rashoquiri ashon piyaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oinquin Fariseofoan ato yoinifo —¿Ahuuscai Moisés noco yononi cuscan tunutitian trigo man mutusimun? —ato huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nicaquin Jesús ato cumaquin isca huani, —¿Davidhuunoa cununi cuscan man man oinmisimun? ¿Fonainquin nocon shuni David ahuun yorafo futan ani cuscan man man nicamisimun? ");
INSERT INTO mcdNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dios fu tsainti pushu iquicaishon a murannoa misifo ato piquini fasi fonicoinquin. Ano tushu futsa yamaino. A misifofin nan Diosin tsain yoimisifo naasi iniquin. Tsoa futsacai a misi pitiro inima. Nannori yoifianifo fasi fonicoinquin David pini. Ascashon afu rafuafori pimani. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ascan uafin uhuun Upa Diosin catonniquin. Ascacun urusu fusti un yoitiro ahuamain tunutitian man huatiroquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ascatan tunuti futsaino Jesús Israelifoan aton ichananti pushu muran iquini. Nanno iquishon ato yosiaino nantianri nocofunun ahuun mucu mumiori musufimuaton arifi nicani. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ascaino Fariseofo futan Moisés cunu tapimamisifoanri nannoshon oincaquin shinannifo, —Non tapinon Jesusmain tunutitian nocofunu caya huai iyamarai Moisés noco yononi cuscacoinmain aiquin, —ishon Jesushuunoa shinannifo. Ato niaifofoqui chanipaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ascashon a shinainfo cuscan onanshon Jesús a nocofunun musufimua yoini, —Funinaca huahuun. Mia oinonfo, —ishon yoiaino nan yoiai cuscacoin ani. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ascaiton Jesús ato yoini, —Un mato yocain. ¿Moisés yononi cuscan tunutitian non shara huatiro iyamarai non chaca huatiromun? ¿Ascayamarai non futsafo nimatiro iyamarai non namatiromun? —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ascashon ato oiancutan a nocofunu musufimua yoini, —Mushahuun, —huaino. Nan yoia cuscan huatanaiton oianfo ahuun mucu muma sharacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ascaiton oincani Fariseofo yafi Moisés cunu tapimamisifo fasi aqui sinacoincaquin yoinifo —¿Nonmun ahuuscashon Jesús shatumatiroquin afanan isca huanonma? —icashu ahuun yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Shafa futsaino Jesús machi ano mapuni Apa Dios cufishquin. Ascano nannoshon yamutishon apa cufishini. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ascashu iyoconaino a tanamisifo yoini, —Uqui fucahuun, —ato huaino aqui fuafoan doce ato catonni afu rafunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nan docefain ato anufo. Futsa Simonfiacun Jesús ahuun anu tuquihuashoqui, Pedroran, huani. Nanton chipocu Andrés. Futsafoan ato anu Santiago non Juan non Felipe non Bartolomé non ");
INSERT INTO mcdNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo non Tomás non Santiago Alfeopan facu Simón futsari nanton ahuun caifo futsafo futan Romanonfo potapai afanan Israelifo yonononfoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Futsan ahuun anuri Judas, Santiago ahuun facu. Futsarifi Judas Iscariote nanton Jesús potashon ato achimani. Nanfosi Jesús ato catonni. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Machi tununman fotoaino aqui yorahuanrasi funifo. Ascaino a tanamisifo yafi Judea anoafo atirifi fuaino Jerusalén anoafori fuaino ianmanhuan cusumunnoa Sidón yafi Tiro pushurasi anoafori funifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ahuun tsain nicashcaquin fuafoan atirifi a isinincaifo ato cayahuafain a yoshin chacapan ato fucash huaifori Jesús atomaquinoa potapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ascashon nan isinincaifo futan nan yoshin chaca atohuun nuafoan shinannifo, —Non ahuunoashu cayanonmun Jesús noco ramanmapainon, —ishon shinannifo. Nanfoan tapinifo Diosin ahuun curushhuunshon Jesús ato caya huapacua. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ascatan Jesús afu rafumisifo oinquin ato yoini isca huaquin, —Man ahuuomafiashu chipo Dios niaifo icari matonari iishquin. Ascacun ahuuomafiashu unimacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Man natian Dios fu rafupaicain ahuun tsainri man tapipaiquin finai a cuscara shara iishcaquin. Man ascafia Diosin chipo mato imasharai a cuscaracoin man inon. Natianri man uaifiashu chipo man shuchitiro. Ascacun unimacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Futsafoan uhuunshon mato noicasmaquin mato potafain mato roafain matohuunoa tsain chaca yoicani. Nanscarifi nan Diosin tsain yoimisifo mato shunifo omitsisca huapaonifo. Ascan matori omitsisca huafiaifoanno chipo man Upa Diosqui nocoaitian fasi sharacoin mato inanshquin man afu ipanon. Ascacun unimacoincahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ascacun futsafo Jesús yoiqui isca huani, —¡Ohua! Manfin natian mafo ichapayashu unimaicain. Ascafia naashu man chipo omitsiscapanaca. Mancai afanan unimanacama. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Ohua! Natian man shinanquin isca huaa, “Un ahuara yopaima. Un ica cuscan shara. Uncai ahua futsa shinanpaimaran,” ishon man shinan. Ascafia ohua. Man chipo mato nomuran shinansharapaifiashu man omitsiscapanaca. Man fasi numamisi yopapacunaca. Natian man shuchisharai. Dios shinantama. Ascafiashu chipo uaiqui man omitsiscapanaca. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nantifi yorafoan mato yoiqui isca huacani, “Na nocofunu fasi ishara. Ahuacai yopaimaran,” ishon matohuunoa yoiafo. Ascafia ¡Ohua! Nanscarifi aquin Diosin tsain yoifiaquin afi shinainfo cuscan yoimisifo. Nanfo mato shunifoan nannori atohuunoa yoipaonifo. Ascan manfin atofu omitsiscapanacaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Ascan nan man ua nicaifo un mato yoi. Mato noicasmaifo atohuun noicoincahuun. Tsoan mato noicasmai ato shara huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tsoan mato chaca huai copitama rau huafain ato yoisharacahuun. Tsoan mato roafiacun ato Dios cufishocahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tsoan mato tapasiai ato copitamarocon nanno nishohuun mato ocuma futsari afiaiton tunucahuun. Futsan mato niaifo ano iyocun mato sahuuti mato fiainton mato sahuuti custopari inancahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tsoanran mato ahuara yocaiton ayashon ato inancahuun. Futsan mato ahuara fiano shinanchacayamacahuun matori nasoyamafiaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Man futsafo shara huamapaiyai cuscan marifi futsaforifi shara huashocahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","A matohuun noiaifosi copiquirifi man atohuun noiainocai acai ahuama. Yora chacafori nanscarifiaifoanno. Man ascainocai Diosin mato yoima, “Man shara huaran,” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A mato shara huaifosi copiquirifi man ato shara huaino acai ahuama. Yora chacafori nanscarifiaifoanno. Man ascainocai Diosin mato yoima, “Man shara huaran,” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ascashon man yora ahuara inanyopaiquin shinanqui isca huai. “Un inanyocun ua nasotiro. Ascan nanscara yorafo fusti un inanyotiroran,” ishon man shinain. Aacai ahuama. Yora chacafoanri nannorifi shinantirofo cuscan. Marifi man anori shinainnocai Diosin mato yoima, “Man shara huaran,” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ascacun un mato yoi. Mato noicasmaifo atohuun noicaquin ato shara huacahuun. “Ato ahuara inanyoshon ua nasoimaran,” ishon shinanchacayamacahuun. Mato nasoyamafia, “Nanscanonran,” ishon yoicahuun. Man ascacoinnashu Upa Dios ari man nocoaiton matoqui unimaqui ahuara fasi sharacoin mato inanshquin. Diosi nai muran isharacointsia. Diosin nantifi yorafo shara huaa. Tsoan “¡Aicho! Upa Diosin,” huayamafiaifoan nanfohuunri fasi noi. Yora chacafohuuri noi. Marifi nanscarifi aquin man futsafo ismatiro man Diospan facufo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maton Upa Diosin nantifihuun ramapaia cuscan marifi nanscarifi acahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Futsafohuunoa shinanchacaqui futsafori yoiyamacahuun. Man futsafohuunoa yoisharayamaino Diosiricai matohuunoa yoisharashquima. Ascashon yoiquin isca huayamacahuun, “Nanton chaca huaa. Ascacun Diosin iconquin onaintimairan,” ishon yoiyamacahuun. Nan onaintimapainonran, ishon man futsahuunoa shinanyamaino Diosiricai mato onaintimaima. Man futsafo rau huacuri Diosirifi mato rau huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ascacun yorafo shara huacahuun. Man yorafo shara huacun Diosin matorifi shara huai. Ascacun futsafo inansharaqui finacoincahuun. Matsiquimacoinquin. Maniriqui futsunon. Man futsafo asca huacun Diosin arifi mato nanscacoin huaashquin, —Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ahuarafo yoiai cuscarahuunshon ato yosini, —Fushocai afu fusho raqui iyotiroma. Iyopai afu shato muran pacutiro. Nanscarifi aqui futsan Diosin tsain tapishomacai mato tapimatiroma. Matofu afiri funotiro. Mato amaquiri yoitirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ahuunshon tapiainfoancai tapimamisiton tapian cuscan tapiafoma. Ascafia nan ahuunshon tapiainfoan chipo tapiaino nan tapimamisi cuscara itirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Ascan ahuuscai yora ahuara pasnanshta fuostamua man futsupaiyain marifi sapa uhuapa fuostamufiashon? Ascashon min chaca huairan futsa huafiaquin mancaifin fasi finacaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ascashon man yoiqui isca huai, “Uhuun yorashtan, un min furo murannoa ahuara pasnanshta un mia futsunon,” man huamisi. Ascafiashocai man tapiama man sapa fuostamufafainna. Man fuparamitsapaimisi. Ascacun sapa futsucumuhuun. Asca huashon oinsharafain marifi man futsa pasnanshta futsutiro. Nanscarifi aquin futsafoan ato chaca shatumapaifiaquin marifi man chaca hua. Man fasi paran. Ascacun iquisi mato chaca shatucahuun. Ascashon marifi man futsafo chaca shatumatiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ihui sharafoan ahuun fimicai chaca itiroma. Ihui chacafoan ahuun fimicai shara itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ascano ihuifoti ahuun fimifohuunshon non onantiro ahuu cuscarafomainquin. Ihui moshayafohuunoacai shopa foaicun non tuscutiroma. Nanhuafaquisihuunricai uva foaicun non tuscutiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nanscarifiai nocofunun sharapan ahuun nomuranshon ahuara sharafosi shinain cuscan ahuun tsainrifi sharacoin itiro. Nanscarifiai nocofunun chacapan ahuun nomuranshon ahuara chacafosi shinain cuscan ahuun tsainri chacacoin itiro. Ascashon nocon ointi muranshon non shinain cuscan nannoricoin non yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Ahuuscai Ifo ua huafiamisishaquin un mato yoia cuscan man aimamun? ");
INSERT INTO mcdNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ascacun un mato yoi ahuu cuscaramain tsoan ua nicasharashu nan un yoia cuscacoin aaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tsoan pushu huaquin ahuun quishi nichishquin iquisi mai puhuuqui mai tuiqui nocoa. Ascashon pushu anaitiano ananmanri unu foanfiaquicai pacutiroma. Fasi pushu mutsisipacoin. Nanscarifiai nan uhuun tsain nicacoianfo nan un yoia cuscacoin acani. Ascashu ahuara ahuuscarafiainocai umaqui itirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ascan un yoiai cuscan nicafiashu tsoa ascaima ahuuscamain acanicain un mato yoi. Yoran pushu huaqui ahuun quishi nichifiaquin mai puhuuqui tuiqui nocoama. Fuquinishtacoin huaa. Ascashon pushu anaitiano ananmanri unu fai foanquin pushu paoanquin chacana huatiro. Nanscarifiai tsoan uhuun tsain nicafiai ascashuma ahuun unutani nantifi funocani. Omitsiscashcaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yorafo yoiquin anaititan Jesús Capernaum ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nannoa ranushumua niaifoan ahuun oinmati nan ahuun noicoian fasi isininqui finacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ascacun Jesús ahuamamishti huatiro nicaquin ranushumua niaifoan shinanquin isca huani, —Uncai Israelima. Ascacun un niaifofo ato yoi ua Jesús yoishonafo oshon uhuun oinmati ua caya huashoyoi onon, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ascano ato yonoa focani Jesusqui nocoshon yoinifo isca huaquin, —Ranushumua niaifoan noco yonoa non mia yoi onon. Nan nocofunu shara. Nocon caifohuuri fasi noimisi. Nanton nocon ichananti pushu huamashona. Noco shara huashomisi. Ascacun mirifi asharashoicapun ahuun oinmati caya huashoshquin, —ishon Israeli niaifofoan yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Ascano Jesús atofu cani. Ranushumua niaifoan ahuun pushu chaimashta man fuaifoan afanan ahuun yorahuafo Jesusqui nichini yoiqui isca huanonfo, —Ifon, un mia fucash huapaima. Un cai ahuama. Min nocofunu tsoa cuscaramacoin. Uhuun pushu ari capaiyamaquin. Min tsainmansi uhuun oinmati ua caya huashohuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ascan uafin uhuun niaifoan ua yonomisiquin. Urifi ranushumuafo un yonotiro. Unmain ato yonoainofin un futsa, “Catahuun,” huaino cariscatiro. Un futsa, “Ohuu,” huaino uqui oriscatiro. Uhuun oinmatiri, “Ua ashoriscahuun,” un huacun ua ashoriscatiro. Asca minfin ahuamamishti huatiroquin. Ascacun min tsainmansi yoihuu uhuun oinmati cayanon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ascaiton nicaquin Jesús a mufaina yorafo yoiqui isca huani, —¡Aira! ¡Nicacapon! Tsoa futsacai naton acai cuscan ua icoinra huacoinmisima. Israeli anoafoanricai ua isca huaqui icoinra huacoinmisifoma, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ascano a ranushumua niaifoan ato nichiafo Jesús tsainqui anaitiano afanan naso furan oianfo ahuun oinmati man cayasharacoian ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ascano chipo shafa futsa Jesús pushurasi Naín ano caino afu rafuafo yafi yorahuanrasi afu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ascashu Naín ano nocoti chaima oian pushcohuai naa mai huai focani ahua fu yora ichapa fonifo. Nan pushcohuai ahuan ahuun facu fusticoin. Nan ahuanmaqui funu naani ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ascashu uaicaiton oin Jesús ahuun ramapaicoinquin yoini, —Uaiyamahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Asca huatan pushcohuai ahuun ihuaifo aqui racati muuainno nitunifo. Ascaiton Jesús yoini, —Pushcoshtan. Un mia yoi. Funihuu, —huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pushcohuai tsaoinacahuan tsainni. Ascaiton ahuun ahua Jesús yoini, —Naquian. Min facu afanan man nia. Iyosharatahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ascaiton oincani yorafo fasi ratucoinnifo. Ratu nishmapacuquin Dios yoisharaqui isca huanifo, —Diosin tsain yoimisi noco muran Diosin nichian. Diosin ahuun yorafo ashoin oaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ascashon nan Jesús aca cuscan yoifoanfafainfo. Judea anoafo futan mai futsa ariafoan ahuunoa nicaquin futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Juanpan tanamisifoan Jesús ahuarafo huaiton oianfo cuscan Juan yoi focani cunu muran iquinifo. Ascaiton nicaquin Juanpan a tanamisifo rafu yoini, —Nanmain Diosin catonniquin ointacahuun. Ascashon yocaquin isca huatacahuun, “Nan miamun Diosin catonni nocoqui nichishquin. Ascayamarai futsa raca non manaicai noco Numamisi inon,” ishon ua yocashotacahuun, —Juanpan ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ascano nan rafutan focashon Jesús yoinifo, —Nan yora unu muran iquimamisi Juanpan noco nichian non mia yocayonon. Ascacun non mia yocai. Nan miamun Diosin catonni nocoqui nichishquin. Ascayamarai futsaraca non manaicain nocon Numamisi inon, —ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ascaino nantianri Jesús nan isininqui omitsiscaifo caya huafain yoshin chacafo atohuun nuuafo atomaquinoa potafain fushoforifi oinmasharapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ascashon nan Juanpan ato nichian rafu Jesús yoini, —Un acaiton man oian cuscan uhuunoa man nicai cuscan Juan yoitacahuun. Ascashon fushofo un caya huaa oinsharaifo cuscan yoifain pastocoinfori un caya huaa nicasharanonfo nanrifi yoifain ato yoratisho coyo cuscara tocoi futsuafori caya huafain yora nipaiqui ranainfori un ato caya huaa yoifain man nacoinnafori un ato funimana. Ascashon yora ahuuomafori tsain shara un ato yoifafainmisi ahuuscashumain Diosin niaifo fu ipatirofoquin, ishon un ato yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ascan nanfo un mato yoiai cuscan Juan yoitacahuun tsoan ua icoinra huacoinshocai afanan ahuara futsa shinainma. Nan cuscara yorafofin fasi unimacointirofoquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ascatan man foafoanno Juanhuunoa Jesús nanno niafo yora huarasi yoini, —¿Ahuuscai istaipama ano Juan oin focani fonifomun? Juancai nan facatahua pui ninhuun focu focu acai cuscarama. Nanscarifiai man man tapia Juancai ointi rananyama. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ascan ahuuscai Juan oinpai man fonimun? Itsairaca nan nocofunun sahuuti sharacapacoin sahuucun oincai man foni. Ma. Juanpacai sahuuti shara sahuumisima. Niaifofoanfin ato pushu muranshon sahuuti sharacapacoin sahuutirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nan Diosin tsain yoimisiraca oincai man foni. Ascafia nan icon Juanpan Diosin tsain yoimisifia nanton yoimisi cuscacai tsoa futsan anori yoimisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ascacun nanhuunoa Diosin tsain cununi isca huaquin, “Min nai ariashu mai ano fotoataima iquisi uhuun tsain yoimisi nichiqui tau huai mihuunoa ato yoiaino itisharashon mia nicanonfo,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Un mato icon yoi. Tsoashtacai Juan finoanma. Ascashon Juanpan tsain yoimisi cuscaricai tsoan ascara tsain yoiyomisima. Ascafia Dios niaifo icanoafoan yoisharatirofo cuscacai Juanpan nicayamafain nanfoan oianfo cuscaricai oinyomisima. Ascashon nantifi Dios icanoafoan Juan finoanfo, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ascashon nan Jesús nicaifo futan Roma anoa niaifo pui fishomisifo Juanpan ato unu muran iquimapacuni aton chaca shatunonfo. Ascano nanfoan Jesús yoiaiton nicaquin yoinifo, —Jesús noco cayacaficoin yoi. Diosin noco yonoa cuscan nan iconran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Asca huafiaifoan Fariseofo futan Moisés cununi cuscan tapimamisifoancai Diosin ato amapaiyai cuscan nicapainifoma. Ascasho nanfoanri yoinifo, —Juanpan noco yoiai cuscacai anorima. Nocoricai unu muran iquimatiromaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Ascashon afanan un mato tapimai. Natian niyoafo ahuu cuscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nanfofin nan facu cashumisi cuscarafoquin. Facufo cashucaquin afu facu futsafo oi ashcafinin cunatirofo. Nanscarifiai nanfofin nanscarafoquin. Ascan nan facu cashumisifoan yoitirofo isca huaquin, “Man non shainti manufiainocai monopaicanimaran,” ishon yoifain “fanainca omitsiscati cuscara non fanaifiainocai man uaipaimaran,” ishon nan facu cashumisifoan yoitirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","34","Nanscarifi aqui nanfoanrifi Juan yafi uqui tsain chipufafainmisi. Ascafia Juanpacai piqui tunufain fimi unu pau ayamisima. Ascacun ahuunoa yoiqui isca huamisifo, “Juan nisocoin. Yoshin chaca ahuun nuaran,” ishon yoimisifo. Asca unfin piisharafain un ayasharamisiquin. Ascafia uhuunoari yoiqui isca huamisifo, “¡Cuu! Jesús pitsicoin fasi ichapari ayatiroran huafain Roma anoa niaifo puifishomisifo yafi yora chacafo furi rafuiran,” ishon uhuunoa chaca yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nanscarifi aquin nanfoanri yoiqui isca huamisifo, “Tsoanmain shinansharafain icaquin non onantiro. Nan yorafin isharacoianquin shinansharamain huaifin,” ishon nanori yoimisifo. Nannori yoifiaquicai uhuunoa ascara yoipaimisifoma. Ascatamarocon uqui tsain chaca fusti huamisiforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ascano Fariseo futsan Jesús yoini, —Tapimamisiton, uhuun pushu ano cahuun un mia pimanon, —huani. Ascaino ahuun pushu ano cashon a futan pini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nan pushurasi anori ainfo furomacoin ica ini. Ascashon Fariseo pushu muranshon Jesús piaiton nicai arifi nan pushu muran iqui caini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ininti motica tsomashu Jesús cachiori nitishoni. Nan moticanun ahuun anu alabastro a muran ahuun ininti fasi paratamacoin ahuun pui nua ini. Ascatan amanaon niashu uaiqui ahuun fuonpan Jesús tau muchana huani. Ascashon ahuun foo chainipaton otucuruaqui shara huatan ahuun tau tsoatan ininti ahuun tauqui ocani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Asca huaiton nan Fariseo Jesús piimaiton shinanquin isca huani, —Na nocofunu Diosin tsain yoimisicoinshon na ainfoan muai cuscan onancuana na ainfomain ahuu cuscaraquin, —ishon ahuun nomuran shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ascaiton onanshon Jesús Fariseo yoini, —Simón, un mia ahuara futsa yoiran, —huaiton. Simón cumani, —Tapimamisiton, ua yoihuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ascaiton Jesús yoini. —Ato pui inanyomisiton nocofunu rafu pui inancun nan rafutan ahuun rafanan nifinifo. Futsan quinientos denario nifiaino futsan ichapama nifini cincuenta denario. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ascafia nan rafutan nan nifian cuscan nasopaifiacai tsoa puiya inima. Ascacun nan ato pui inanyomisiton ato yoisharani afanan tsoan a nifinonma. Ascan nan rato futsacaimun fasi ahuun noiqui finacaiquin, —ishon Jesús yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón cumani, —Nan paratama nifiatocairaca fasi noiqui finaiquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Afanan Jesús cumaqui isca huani, —Min cayacafi yoiaran, —huatan ifiacucahuan yoini, —Oinpon. Na ainfoan fasi ua noicoin. Min pushu muran un iquifiaitocai mian ochoama. Asca na ainfoanfin fasi uhuun noiquin ahuun fuonpan uhuun tau muchana huafain ahuun foon ua otucuruacaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nocon fuyamisi cuscaricai mian uhuun tamo tsoama. Asca na ainfoanfin min pushu muran un iquiaitian uhuun tauqui ua tsoariaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ascan mianricai uhuun mapoqui shuni ocama. Asca na ainfoanfin uhuun tauqui ininti ocaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ascacun un mia yoi. Na ainfoan ahuara ichapa chaca huafiamisicun natian ahuun chaca mun soashona. Ascashori mun rau huacoinna uhuun fasi noiaiton. Asca tsoan shinanquin isca huai, “Uncai ichapa chaca huamisima. Ascacun uari uhuun chaca ichapama ua rau huashotiroran,” ishon shinaintocain ua ichapa noimaran, —ishon Jesús Fariseo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ascashon ainfo Jesús yoini, —Natian mun mia chaca rau huashoanran, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ascaino Fariseo pushu murannoafo afi ranan yoinannifo, —¿Tsoamun na nocofunuquin? Fasi chaca huamisifo ato chaca soashofain ato rau huatiroran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ascashon Jesús afanan ainfo yoiqui isca huani, —Mian icoinra huaitofin un mia numaquin. Caasharatahuun, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Asca huatan chipo Jesús pushurasiti ato yoifoanfafaini ahuu cuscaramain Upa Diosin niaifoan ahuun yorafo iquinai cuscaraquin. Ascaino doce afu rafuafori afu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ascaino ainfofori afu fonifo. Nanfo isinincai yoshin chaca atohuun nuucun Jesús ato caya huapaoni. Nan futsan ahuun anu María Magdalena. Nanhuun siete yoshin chacafo ahuun nuucun Jesús amaquinoa potani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Futsan ahuun anu Juana nan Cuzapan ahuin ini. Nan Cuza niaifo Herodes ahuun niaifo patashari ini. Ainfon futsan ahuun anu Susana. Ascashu ainfo futsaforifi Jesús yafi afu rafuafo fu fonifo. Nan ainfofoan Jesús yafi afu rafuafo pui inannifo ahuun rafanan tushu finonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pushurasifoti anoashu ahuun tsain nicapaicani yorahuanrasi aqui fuaifoan ahuarafo yoiai cuscarahuunshon ato tapimani isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Nocofunun ahuun noshati murannoa fimi ushu fishon ahuun mau mamaqui saaca ushufo fai nushmancayan pacucun puamanafoanno puiyafoanri piinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ushu rananri toquiri camaqui pacua mai ichapamashta anoashu foaifia fari tsasi huani unun muchana huaiyamaino nai cuyoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ascaino ushu rananri tasha murannoashu foaifiashucai ushu futsa foaisharanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ushu rananri mai shara ano pacuafo foaisharashu fimi ichapayacoin iniran, —ishon Jesús ato yoitan oi ashcafinin ato yoiqui isca huani, —Manmain ua nicatiroquin ua nicafain uhuun tsainri maton nomuran nanucoincahuun, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","—Min ato saamisihuunoa ahuara futsa tapima ato yoia cuscan noco shafacafi tapimahuu, —ishon afu rafuafoan Jesús yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús ato cumani, —Upa Dios a icanoshon ahuun yorafo iquinai cuscan un mato fusti shafacafi tapimai. Ascan nanfofin ahuarafo cuscarahuunshon fustisi un ato yoiaquin. Ascashon nanfoancai un ato oinmana cuscan oinfiaquicai tapiafoma. Nicafiaquiricai tapisharafoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Un saamisihuunoa ahuara futsa un ato yoia cuscan un mato shafacafi tapimai. Nan ushufo Diospan tsain cuscara. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nan fai curushu yorafoan aton ointi cuscara. Ascashon nanfoan Diospan tsain nicafain ato nomuran nanufiafo nan yoshin chaca Satanás atoqui oshon nan nicafo cuscan ato fiantiro icoinra huayamafain Dios fu ipanonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ascan nan toquiri camaqui mai ichapama cuscan nanscarifiai yorafoan Diosin tsain nicaquin tau huai unimacoinyofiashu ahuara ahuuscaraino samamashta cachiquiri huatiro. Nanfoan Diospan tsain icoinra huaqui chai huashoma ahuara chaca finonquin samamashta Dios cachiquiri huatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ascan nan ushu futsafo moshafo muran pacuashu foai sharatiroma. Nanscarifiai futsafoan Diospan tsain nicafiashon ahuara nan acai cuscan fustisi shinanfain pui ichapa yafi mafo ichapa noiqui itiashmashtafi Dios cachiquiri huai. Ascaquicai Diosin ato amapaiyai cuscan huacanima. Ahuarafo futsafohuunshosi ato nomuran afi unimamapaicani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ascafia ushu futsafo mai shara ano pacuashu foaiquin yosiashu fimi ya itiro. Nanscarifiai futsafoan Diospan tsain nica cuscan icoinra huashu ahuun nomuran sharacoin. Ascaquicai Diospan tsain nicafo cuscan cachiquiri huacanima. Ascashon nanfoanri futsafo icoinra huamatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tsoancai tapa camaqui lamparina otashon paninranun fupomisima. Asca huatama otashon tapa camaqui huaa pushu muran iquiafoan oinsharatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nanscarifiai man shinanmisi cuscan ahuara huafiashon man fomanmisi cuscari nantifi mato puashoshquin. Anoshocai ahuashta afanan man fomantiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ascacun oinfain. Uhuun tsain nicasharacahuun. Tsoan uhuun tsain nicasharacoian paratamari Dioshuunoa tapisharatiro. Ascan tsoan uhuun tsain nicafiashu ascacoianma ascashu nan nicamisi cuscari funoshqui, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ascatan Jesús ahua yafi chipocufo aqui iquipai oianfo yorahuanrasi fasi fospiafono iquinifoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ascaiton futsan yoini, —Min uhua futan ushto rananun mia oinpai fuafo chifi niaforan, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús cumani, —Nan uhuun Upa Diosin yoiai cuscacoin aafofin uhuun uhuafo yafi uhuun ushtofoquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Shafa futsa Jesús afu rafuafo yoini, —Non ianmanhuan oquiri fonon focahuun, —ato huaino afu nanufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ascashu foaifono atoqui fuuhuan noconi. Nantian Jesús shasho tsispa camaquinoashu osha ini. Ascano fuuhuanquin ianmanhuan fuchoquin unu shasho muran iquimani. Fasi musucoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ascaiton afu rafuafoan moinnifo, —Moihuu, Ifon, man non asai futsuicai, —ishon yoiaifoanno moinacahuatan ninacahuani. Ascashon yoini isca huaquin, —Fuun nishmahuu huafain fuchomanhuanun nishmahuu, —Jesús huani. Ascaino ian fuchoi nishmafaini. Man asca huano ian pusiquima racani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ascaiton ato yoini, —¿Ahuuscai un nunofiano ua icoinra huatama man ratuai? —ishon Jesús ato yoini. Ascaino fasi ratucani mustairicatan afi ranan yocanonannifo. —¿Noco ifomun tsoaquin? Fuuhuan yafi ian nan yoiai cuscan man nishma hua, —icashu afu rafuafo yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ascatan ianmanhuan pocufaini Galilea ocuma futsa Gerasa mai ano noconifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ascashu shasho murannoashu Jesús fotocainaino nocofunu yoshin chaca ahuun nuua aqui noconi. Sahuuti sahuu sahuutianima. Pushu muranricai imisima. Mahua quini muransi iitiani. Nan mahua quini muranri naafo mai huamisifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesús fuchitan ratoconun mai chachipacufoan oi ashcafinin yoiquin isca huani, —¿Mian ahuusca huapaimun, Jesús? Diosin nai muran ica nantifi finoncoianton ahuun Facufin minquin. Ua omitsisca huayamapun, —ishon yoshin chacahuunshon nocofunun Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nannori yoini Jesusmain yoshin chaca amaquinoa potayamaiton. Asca aqui Jesús nocoataima yoshin chacapan nocofunu achiriapaoni. Ascaiton yorafoan cadenanun munushfain onushushon cushufiafo nanfo tusaqui futsafaini ichopaoni. Ascashon yoshin chacanun tsoan istaipama iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ascaiton Jesús yocani, —¿Min ahuanumun? —ishon yocaiton. Yoshin cumani, —Nocon anufin ichapaquin. —Anori yoini yoshin chacafomain ichapa ahuun nuucun. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ascashon yoshin chacafoan Jesús yoinifo, —Omitsiscapanacafo quininhuan muran noco potayamapun, —huarianifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ascaino nantianari machi mananunshon yahua inafoan piinifo. Ascacun yoshin chacafoan Jesús yoicaquin isca huanifo, —Noco yahuarasihuun nichipun, —huaifoan. —Ascaiton yahuafohuun fotacahuun, —Jesús ato huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nocofunuhuunoashu yoshin chacafo yahuafohuun fonifo. Ascaino yahuahuanrasi ian muran maocofainni asai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ascaifoan oinfaincani yahua cushumisifo ichonifo pushurasi ano chani focani. Pushu patashari icafo yafi chaima icafoquiri chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ascaiton nicacani yorahuanrasi yahua asai futsuaiton oinpaicani funifo. Fucaquin oianfo Jesús naman nocofunu ahuun yoshin chacafo nuumisi tsaoa ini. Man amaquinoa Jesús yoshin chacafo potano. Afananricai imisi cuscan chitoria iyamacain nison inima. Shinansharacoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Atirifi atoqui nocoaifoan Jesús amaquinoa yoshin chaca potaiton oianfo cuscan futsafoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ascaino Gerasa anoafoan nicacani ratucoincaquin yoinifo, —Nocomaquinoashu catapun, —huaifoanno Jesús shashon nanucaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jesús cataima a yoshin chaca amaquinoa potaton yoini, —Uari iyoicapun. Un mifu capaicai, —huafiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Jesús yoiquin, —Ma. Min pushu ano cashon min yorafo mia Diosin ashoan cuscan huafain yoitahuun, —huani. Asca huaino cashon Jesús ashoan cuscan yoifoanfafaini. Pushurasi muran yafi patashari icafo chaima icafori yoifoanfafaini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asca huatan ianmanhuan pocufurannaiton yorahuanrasiton cusumunshon Jesús mananifo. Fasi aqui unimacaquin —Nocoqui ohuu, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Nannori nocofunun ahuun anu Jairo. Israelifoan ichananti pushu anoa aton niaifo ini. Nanton ahuun shotocofacu fustishtacoin doce fari aya ini. Ascano Jesús shasho murannoashu foto curanaiton Jairo fuoshopacucahuan yoini, —Uhuun facushta isininqui man naiquin uhuun pushu ano ufu capun. Uhuun facushta ua caya huashoshquin, —ishon Jairo yoiaino Jesús afu caino yorahuanrasi atofu focaquin fasi yuruanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nannori ainfo atofu cani. Nan ainfo imi imitiani doce fari man aqui caafiano nusuyamacai. Cayapaiqui nan aya cuscan doctorfo ato inanfiacucai tsoanshta caya huamamisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ascashu Jesús caiton ainfoan acachorishori ahuun sahuuti cupanan muunni. Muuanshu imi shaturiscatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ascaiton Jesús ato yocani, —¿Tsoan ua muamun? —ato huaiton. Nantifiton yoinifo, —Non mia muamaran, —ishon futsan yoicun futsan yoicun huanifo. Ascaiton Pedronun yoini, —Tapimamisiton, yorahuanrasiton mia yuruafain mia putsiquinaforan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Afanan ato yoini, —Ratoran futsan man ua mua. Uhuun curushhuunoashu nan ratoran man cayaran, —ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jesús yoiaino ainfoan tapini Jesús man onan. Ascacun raquicai onutiroma oin ratui taritari iyanan yora huanrasiton ointaifi Jesús nia naman ratoconun mai chachishon nan ica cuscan yoini, —Un imi imitiani doce fari man uqui caa. Tsoancai ua caya huamamisima. Ascacun min sahuuti muuashu un imi shaturiscaran, —ishon ainfoan Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ascaiton, —Achishtan, ua icoinra huashufin min cayaquin. Caasharatahuun, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ascashu Jesús tsaincai muran niaifoan pushu anoashu aqui oshon futsan yoini, —Min facu man naaqui. Natian nocon tapimamisi afanan fucash huayamacahuun, —ishon futsan niaifo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ascaiton nicaquin Jesús yoini, —Ratuyamahuu. Min ua icoinra huaino min facu cayaiquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ascatan pushu ano nocoshon Jesús yoini, —Pedro yafi Juan non Santiago non facun ahuun apa non ahuari marusu ufu pushu muran iquicahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ato asca huaino iquifainquin oianfo uaicani shorarascanifo. Manocani. Ascaifoan Jesús ato yoini, —Uayamacahuun. Na facucai naama. Oshafinquin, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jesús osanifo. Man facu naacoina oinfiainfoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ascashon Jesús shotocofacu mutsoinifoanquin oi ashcafinin yoiquin isca huani, —Facushtan, funinaca huanhuun, —huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Afanan funinaca huatan shotocofacushta nini. Ascaiton, —Piimacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Apa yafi ahua aton facu funia oincani fasi unimacoinnaifoan ato yoini, —Maton facu naacoinfiacun un funimana cuscan tsoa yoiyamacahuun, —ishon Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Shafa futsaino Jesús doce afu rafuafo cunaino aqui funifo. Ascano aqui fuafoan ato yoiqui isca huani, —Uhuun curushhuunshon yoshin chacafo yorafohuun nuucun atomaquinoa potafain pau futsa futsatapafori uhuunshon man ato caya huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ascashon uhuun Upa Dios niaifohuunoari ato yoifain isinincaifori ato caya huatacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ascacun mato ahuara foyamacahuun. Mato poquiti non forusa non tushu non puiri foyamafain mato sahuuti futsafori foyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ascan ratoran pushurasi ano man nocoano tsoa aton pushu muran mato iquimai nan fusti muran iyocahuun nan man caitian. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Asca rato pushu futsa iyamarai pushurasi anoafoanri mato nicacasmaifoanno atomaquinoashu focaquin maton sapato tatashacahuun. Ascaquifin man ato ismatiroquin mato nicacasmafain Diosirifi nicacasmaifo cuscan. Diosin tsain icoinra huamaforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ascashon ato yoiquin anaitiano pushurasifoti ano Upa Dios niaifohuunoa yoifain isinincaifori Jesushuunshon ato caya huafoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ascano nan niaifo Herodes a Jesús aca cuscan nicashu, —¿Tsoamun na nocofunuquin? —ishon shinanni. Atirifoan yoinifo, —Nanfin Juanqui man afanan funia, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Futsafoanri yoicaquin, —Naanfin Eliasquin, —huaino. Futsafoan yoicaquin, —Ma. Nantofin noco shuni caifo Diosin tsain yoimisi ipaoniquin man afanan funiaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ascafiaifoan Herodes yoini, —Ma. Nancai Juanma. Munfin Juan tushtumayamuaquin. ¿Asca nan nocofununmun tsoaquin? —ishon yoini. Asca nan niaifoanri fasi Jesús oinpaicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ascashu chipo afu rafuafo Jesusqui naso cashon nan acafo cuscan Jesús yoinifo. Ascaiton nicaquin Jesús ato yoini, —Pushurasi Betsaida ano nocotisi non fononfocahuun, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ascafia yorahuanrasi Jesús yafi afu rafuafo nan foafo ano tapicanashu atoqui funifo. Ascashu nocoaifoan Jesús ato yoini, —¡Aicho! Man uqui fui. Uhuun Upa Dios niaifo icanomain ahuu cuscaraqui un mato yoinon, —ishon ato yoini. Nannoshori ratoran futsa isinincai fuafo ato caya huapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ascashu man fari caino afu rafuafo doce aqui fucashon yoinifo, —Yorafo nichihuun. Pushurasi ano yafi a chaima icafoanno fotanonfo. Fonaincaniquin. Anoshon tushu fifain ranimain oshacanicain shara futsa fuchinonfo. Nuno tsoa yamaiquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ascaiton ato cumani, —Ato piimacahuun, —ishon a rafuafo yoiaiton. —Nonfin misi mucu fustiti yafi shiman rafusi ayaquin. Min shinanmun na yorafo pimashquin non tushu ichapa fiicaiquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nanno cinco mil nocofunufosi ini. Ainfofo yafi facufocai tanan huamunima. Ascaiton ato yoiqui isca huani, —Ato yoicahuun futsano cincuenta tsaohuaifono futsa anori cincuenta tsaononfo. Nanscasi anonfo, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nan ato yoiai cuscan tsaoacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ascaino shiman rafu yafi misi mucu fustiti tsomashon nai ari foisinifoantan apa Dios cufinquin isca huani, —¡Aicho! Upan, mihuunshon un ato pimai. Min fasi sharacoincun, —huatan. Misi torupacutan shiman rafu ya osishon afu rafuafo ato inanni ato pashcanan huapanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ascashon picani mayancoinnifo. A picaquin tushu huafo afu rafuafoan doce shihuati fospi huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ascatan shafa futsa Jesús afu rafuafo ointaifi apa Dios cufini. Cufinquin anaititan ato yocani, —¿Yorafoan shinanmun un tsoaquin? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Cumanifo, —Futsafoan yoiafin min Juanquin. Nan yorafo unu muran iquimapacumisi. Asca futsafoanri yoiafofin min Eliasquin. Asca futsafoanri yoiafofin min noco shuni nan Diosin tsain yoimisi ipaoniquin man min afanan funiaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—¿Asca marifi man shinanmun un tsoaquin? —ishon ato yocaiton. Pedronun cumani, —Minfin Cristoquin. Nan Diosin mia catonniran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Ascacun tsoashta yoiyamacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ascatan afu rafuafo yoiqui isca huani, —Un chipo fasi omitsiscashquin. Nocon yorafohuunshon Dios cufimisi niaifofo non Dios fu tsainti pushu cushumisifo Moisés cununi cuscan tapimamisifoan futan ua icoinra huashquicanima. Ascashon ua ato rutumafiafo osha rafu non fusti finontan un afanan funishquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ascashon nantifi yorafo yoiqui isca huani, —Tsoan ua tanapai sharaquicai afin apaiyai cuscan huatiroma. Ascatama nan un yoiai cuscacoin huatiro. Ascashon shafatifiri shinanqui isca huatiro, “Ua omitsisca huafiaifoanno uncai uhuun Ifo potapacunacama. Ahuunshon ua rutufiainfoanno un tanaqui unupacunacamaran,” ishon shinantiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ascan tsoan shinanquin isca huai, “¡Ohua! Un Jesús tanaitonraca ua omitsisca huacanicati,” ishon shinanquin uhuun tsain cachiquiri huaa. Nanscara yorafo naashu omitsiscapanacafo. Ascan tsoan uhuunoashu omitsiscai naa. Nanscara yorafofin nacanashu ufu isharapacunacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ascan ratoran futsan nantifi manifoti anoafo ahuara fia ahuunacoin ifiashu amaqui naino nantifi ahuunafo funotiro. Ascashu nantifi ahuuna iyopaonifia omitsiscapanacafo muran cainocai ahuashta itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ascan tsoa uhuun rafipaiquin uhuun tsainri uhuunoa yoicasmaifo. Nanscarafohuun urifi un chipo uhuun Upa Dios cuscaracoin iicaino uhuun Upa Diospan oinmati afu nai muran ica sharafoya chasha curani un fotoaitian un nanscara yorafohuunri un rafipaishqui. “Nacai uhuun yoramaran,” ishon un yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ascacun icon un mato yoi. Man futsa nuno ufu niaton naataishoma Upa Dios niaifo icano cuscara man oinyoshquiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ascashu ocho osha finontan Jesús Pedro non Juan non Santiago nan rafu non fusti ato machi ano iyoni. Apa Dios cufi caquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ascashon Apa Dios cufiaino ahuun fuso fianananriscatani. Ahuun sahuutiri chashariscatani nan yoa rama furoa ointsa. Fasi osho sharacoin facafacai ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ascaino nocofunu rafu aqui niriscatan afu tsainnifo. Nan rafu Moisés yafi Elías ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ascashu nan rafuri chashariscatishotan nan Jesús Jerusalén anoashu omitsiscacai naashquiai cuscan afi ranan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ascaiton oincani Pedro yafi afu rafua rafutari oshapaifiacaquin osha tunucoinnifo. Jesús chashariscatanaiton nan rafutari oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ascashu nan rafu man Jesusmaqui caino Pedronun yoini, —Ifon, nuno non ica shara itiro. Non mia tapasi rafu non fusti huashonon. Mina futsa non Moisésna futsa non Eliasna futsari non huashonon, —ishon yoifiashocai Pedronun tapinima raquirimain huaaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ascashu nan tsaincai muran atoqui coin manipacufoannaino coin muran nii futsuashu ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ascashon nan coin murannoari oi nicanifo yoiqui isca huaiton, —Naanfin uhuun facuquin. Nan un catonni. Ascacun a nicacoincahuun, —Upa Diosin ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Diosin tsainqui anaititanaino oianfo arus fusti Jesús nia ini. Ascafiashocai tsoashta yoinifoma arus fusti aton nomuranshon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ascatan iyoco futsaino machi anoashu fotocaini Jesús caino aqui yorahuanrasi funifo oinpai fucani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nanno yorahuanrasi muranshon futsan Jesús cunani. —Tapimamisiton, uhuun facu fusti ua oinshoniyopun. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yoshin chaca ahuun nuushon. Uhuun facu fasi musta musta imayanan fiisimafain ahuun ashfapan facoshurasi atsispomamisi. Yoshin chacacai uhuun facumaquinoashu capaima. Nanscaquisi man rutui. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Un mifu rafuafo yoia isca huaqui, “Na yoshin chaca uhuun facumaquinoa ua potashocapun,” un ato huafiacai tsoan atiro icamaran, —ishon nocofunun Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ascaiton Jesús afu rafuafo yoini. —¡Ohua! Mancai ua icoinra huacoinnama. Man fasi amaquiri shinanmisi. ¿Ahuutia un matofu icamun man ua nicayamacaiyai? —ishon ato yoini. Ascan facun ahuun apa yoini, —Min facu ua ihuushohuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ascashon furun ihuushonaino yoshin chacanun afanan musta mustaimainifoanaino pacuni. Ascaiton Jesús yoini, —Minfin yoshin fasi chacacoinquin. Na facumaquinoashu catahuun, —ishon Jesús curushcai yoiaino facu cayani. Ascaiton Jesús apa yoini, —Naquian min facu. Iyosharatahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ascaino oincani mustairicatan, —Diosin ahuamamishti huatiroran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Nan acaiton oian cuscan shinansharaifoan Jesús afu rafuafo yoiqui isca huani, —Un mato yoiai cuscan nicacoincahuun. Futsafin ua ato achimashquiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ascashon ato yoiai cuscacai tsoan tapinima. Diosin ato nomuran ato shinantima huaino. Ascacucai yocapaifia ratucaqui yocanifoma shafacafi ato tapimanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ascashu chipo afu rafuafo afi ranan fochishmanantanannifo. Ascan non rato futsacaimun non fasi shara finacaiaqui ishon yoipacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ascashon nan shinainfo cuscan onanshon Jesús facu mutsofuran yoiqui isca huani, —Facushtan, nuno ufu niiyohuu, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Asca huatan afu rafuafo yoiqui isca huani, —Tsoan uhuunshon na facu shara huaifin nan uari shara huai cafisca huaiquin. Nanscarifiai tsoan ua shara huaquifin nan ua nichini uhuun Upa Diosiri shara huaqui. Ascan ratoran man futsa oinmati cuscara ahuuamafiasho man yora shara huamisi nanfin fasi shara finacaiaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ascaiton Juanpan yoini, —Tapimamisiton, non oian nocofunun min anuhuunshon yoshin chacafo atomaquinoa potaiton. Nancai no fu rafumisima. Ascacun nan non yoiquin isca huaa, “Asca huayamahuu. Min no fu rafumisimaquin. Asca yoshin chaca yorafomaquinoa min potatiromaran,” ishon non yoiaran, —Juanpan huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ascaiton Jesús cumani, —Asca huayamahuu. Tsoan noco chaca huapaitama noco shara huaifin sharaquin, —ishon Jesús Juan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Afanan Apa Dios icari cati chaima Jesús Jerusalén ano cayoni. Ascaitocai tsoashta nitun huatiro inima. Manmain tapicufin a Jerusalén anoashu noco nashoyoai Apa Diosin yonoa cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ascacun a rafuafo rafu rucun nichini. Nan pushurasi Samaria ano focashon itishara huashononfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ascafia nannoafoan ato yoiquin isca huani, —Nuno iquiyamacahuun. Non mato oinpaimaquin, —ishon ato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ato asca huaifoan nicashon afu rafuafo rafu Santiago futan Juanpan Jesús yoinifo, —¿Ifon, min noco yonopaimun atohuunshon non Upa Diosin cufinon nan pushurasi nai muranshon chii atoqui pota nai cuyononfo? —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús ato cumani, —Asca huayamacahuun. Man shinain cuscacai un shinanpaima, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Asca huatan pushurasi futsa ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A fu caquin nocofunu futsan Jesús yoini, —Ifon, min raquira caino urifi un mifu cahuacacainon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús cumaquin, —Marifi quiniyaquin puiyafori naa yafofiano uncai pushu yama, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ascashon nocofunu futsa Jesús yoiquin isca huani, —U fu cahuun, —huaiton. Cumaquin, —Ifon, ua manayohuu. Nan uhuun upa naitian iquisi mai huayotan un mia tanasharashquinon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Ascaquima ua tanafafainhuun. Ua ifoamafofin nan yora naa cuscarafoquin. Ascashon nanfoan ato yora naacun mai huatirofo. Ascan minfin uhuun Upa Dios niaifohuunoa ato yoifafainicain, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Futsan yoini, —Ifon, un mia tanapai. Ascafia iquisi uhuun pushu ano un cayotanon uhuun yorafo ato yoiyoicai, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús cumaquin, —Tsoan ua yonoshofiaquin apaoni cuscan afanan huapai, nanscara yorafocai itisharafoma uhuun Upa Dios niaifo ano iquishcaquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ascatan Jesús setenta y dos nocofunufo catonni. Ascashon rafurasi ato nichipacuni. Nan pushurasi patasharifo ato rufofo nichini nanno chipo arifi atoqui caashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ascashon Jesús ato yononi isca huaquin, —Yora ichapafoan uhuunoa nicataiyamafiashon ichapamaton ua yonoshocani uhuunoa ato yoishcaquin. Ascacun fasi Upa Dios cuficahuun ahuun yonoshomisifo catonon uhuunoa ato yoinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ascacun fotacahuun. Un mato yonoa cuscan chashoanfo masharonun pipaitiro cuscan nanscarifi huaquin uhuunoashu man isharafiacun yora chacafoan mato chaca huapaicaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ascashori a muran pui huati yafi forusa non mato sapatori foyamacahuun. Focaquin yorafo finonfaincahuun. A fu tsainyoashu man funa nocotiromaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pushu futsa muran iquishon ato yoicahuun, “Diosin mato shara huacoinnon. Isharacahuun,” ishon ato yoicahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Asca nan pushu muran ica futsa isharacoincun naanfin “Diosin shara” huacoinnaquin nan man yoia cuscan. Asca man yoiai cuscan a pushu muran icafoan mato nicacasmaifocai Diosin ato ointi unimamatiroma. Ascashu funocani. Ascafia man ato yoiai cuscacairocofin Diosin matoqui unimaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ascatan pushurasi muran nocoashu pushu fusti muransi oshacahuun. Nannoshon mato pimafain mato ayamanaifoan acahuun. Diosinhuunoashu yonomisifo nan yopaifo cuscan nan nicamisifoan ato inantirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ascashu man pushurasi muran man nocoaiton mato ihui sharafain mato pimafain mato ayamanaiton acahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nannoshon isinincaifo uhuunshon ato cayahuamacahuun. Ascashon ato yoicahuun isca huaquin, “Natian Diosin niaifoan ahuun yorafo iquinai cuscan chaimashtaran,” ishon ato yoicahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ascan mato nicacasmaifoanno ato fai ano fotacahuun nannoshon ato yoicahuun isca huaquin, ");
INSERT INTO mcdNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Maton chaca nocohuun nuama. Matohuunfin nuaquin. Ascafiaino Diosin maton Ifo ipairan,” ishon ato yoicahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Un mato yoinon. Diosin Sodoma anoafo ato namaqui cuyoni. Ascan nan mato nicacasmaifofin ahuutiaran nan Sodoma anoafo ani finonmacaifain ato omitsisca huaquin finacoinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Ohua! Man Corazín anoafo yafi Betsaida anoafoan man chipo fasi omitsiscai. Tsoan oinyomisima cuscara shara un mato ismafiano mancai chaca shatupaima. Ascan nan Tiro anoafo yafi Sidón anoafo un mato isma cuscan un ato ismaiton nanfoan ato chaca shatucuanafo. Ascashon yoicuanafo isca huaquin “¡Ohua! Non fasi chaca huamisi. Ascacun natian Diosiqui nasoshon non nicasharanoncahuun,” ishon yoicuanafo. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ascafia Diosin nantifi icoinra huamafo onaintimaitian nan Tiro anoafo yafi Sidón anoafori onaintimafiaquicai mato onaintimaquin finacoinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ascan man Capernaum anoafoan man shinanmun man nai muran Dios ari foicai. Ma. Omitsiscapanacafo muranrocon mato potai, —Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Asca huatan Jesús ahuun tanamisifo afanan ato yoiqui isca huani, —Tsoan man yoiai cuscacoin mato nicaquifin nan uacoin nicai cafisca huaiquin. Ascan tsoan mato nicacasmaquifin uarifi nicacasmaiquin. Ascan tsoan ua nicacasmaquifin nan ua nichini uhuun Upan Diosiri nicacasmaiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ascano chipo nan setenta y dos ahuun tanamisifo afanan aqui naso furacani fasi unimacoincani fucashon yoinifo isca huaquin, —Ifon, yoshin chacafoanfin min anuhuunshon noco nicacointirofoquin. Ascacun yorafomaquinoa non mihuunshon potaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ato cumani, —Aifain. Dios icanoashu nan cana piishicai cafiscai Satanás mai ano pacutanaiton un oian. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ascano un mato yonoainocai uhuunshon mato ahuaraton ahuusca huatiroma. Rono paupan futan inapapiaton mato ahuusca huanonma un mato cushutiro. Ascashon nan Satanás noco noicasmamisi uhuunshon man finoncointiro mato ahuusca huanonma. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ascacun nan man yoshin chaca potahuunoashu unimayamacahuun Diosifin nai muranshon mato anu ahuun libro muran cunuaquin man ahuun facufocun ato ismashquin. Nan shinainfin man unimatiroquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ascano ato yoiqui anaititan Diosin Yoshin Sharahuunoashu unimacoinquin Apa Dios yoiquin isca huani, —Upa Diosin, min fasi sharacoin. Nantifi nai murannoafo futan mai anoafoan aton Ifofin minquin. Ascano nan mapo sharayafo yafi cunu tapiafocai min tsain shara min ato tapimanama. Ascafia nan cunu tapisharafoma nan facu cuscarafoqui. Ascashon nanfoan un ato isma cuscan yafi un ato yoiai cuscan ua icoinra huafo. Nanfofin min ato tapimanaquin. Icon, Upan, minfin nanscara fuchipaiquin, —ishon apa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ascashon cufinquin anaititan Jesús nantifi yoini, —Uhuun Upa Diosin tapia cuscan uarifi nantifi tapimani. Unfin Diospan facuquin. Diosin fustitofin ua onancoianquin. Nanscarifi aquin urus fusti Upa Diosin un onancoian. Nanscarifi huaquin urifi un futsafo Upa Diosihuunoa tapimanai cuscan nanfoanri Upa Dios tapitirofoquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ascashon ifiacucahuan ahuun tananmisifo fusti yoini, —Diosin matohuun noiquin ahuun yono mato isma. Ascacun mato shara huacoinna. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Man oiain cuscan Diosin tsain yoimisifo futsafo futan niaifofoanri oinpaifiaquicai oinpaonifoma. Man nicai cuscari nicapaifiacaquin tsoan nicapaonimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ascano nocofunu futsa Moisés cununi cuscan tapicoian Jesusqui oni yocayoi. Tapipaiquin Jesusmain cayacafi cumaiquin ishon. Ascashon yocani, —¿Tapimamisiton, unmun ahuuscatiroquin Dios fu ipashquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús cumani, —¿Raquiri Moisés cununimun? —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Cumani, —“Nocon Ifo Dios nocon ointi muranshon fasi noifain, nocon nomuranshori fasi noifain, fasi curushcai Dios noifain nocon shinanfoyashori Dios noihuu. Ascatan nan mifiri min noiai cuscan aquin mia chaima icafori noicoinhuun,” ishon Moisés cununiran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ascaiton Jesús yoini, —Min ua cayacafi cumashara. Nanscacoin atahuun. Ascashufin min Dios fu ipatiroquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","30","Asca huaiton cumani, —¿Ascan tsoafomun ua chaima icafoquin afohuun un noiai? —ishon yocani. Ascan nantocai atifihuun noinima. Ascacun Jesús a nocofunun shinain cuscan onanshon cumaquin isca huani, —Nocofunu Jerusalén anoashu Jericó ano caiton. Yomutsofoan achicashon sahuuti shoriquin futsatan sutuquin futsacaquin nama cuanifo. Ascashon fai cusumun ratafaini yomutso ranan ichonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ascano ahuun caifohuunshon Dios cufimisi oquin oian fai cusumun racacun oinfiaquin fai ocuma futsa caquin tanafainima. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ascano nocofunu futsa Levita arifi oquin oian racacun nantorifi rahuinfainni. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ascaino nan fainri chipo Samaritanon oquin fuchitan ahuun ramapaitoshini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ascashu chipacopacucahuatan ahuun yoratishon shuni ya cayati futsa osishon ahuun ratucuraquin futsatan. Ahuun ina camaqui ratainifoantan iyoshon pushu muranshon cushushoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ascatan iyoconaino ahuun rafanan toro paratamacoin ahuun pui nua rafu inanni. Ascashon pushu ifo yoiquin isca huani, “Na nocofunu ua cushusharashohuun. Afanan oshon un mia rafuri inanyoshquinon. Min cushusharaiton finonmafaintan afanan oshon un mia pui inanyoshquinon,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Ascan rato nocofunu rafu non fusti caimun a chaima icafo cuscaracaquin a nocofunu omitsiscapishtai? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nan Moisés tsain tapimamisiton cumani, —Ahuun ramapaiyaifin a chaima ica cuscaraquin, —ishon yoiaiton. Jesús yoini, —Caashon mirifi nanscarifi huatahuun, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ascatan Jesús cai pushurasi muran noconi. Nanno ainfoan ahuun anu Marta ica ini. Nanton ahuun pushu muran Jesús iquimasharani. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ascano nan Marta chipocufin María iniquin. Nanton Jesús tsain yoiaiton nicashquin icashu Jesús naman tsaotoshini nicasharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ascafiaitocai Marta nicanima nan tushu huaisi shinanni Jesús pimashquin. Ascacun nan Martan Jesús yoini, —¿Ifon, mian shinainmamun? Urusu fusti un tushu huai. Uhuun chicocai u futan apaima. Ua yoishohuun u futan aquiyonon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Martashtan, minfin tushu fusti shinanquin. Ahuarafo futsa huaquicai mian nicaima. Nan uhuun tsain sharafin María catoanquin. Ua nicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Uhuun tsain fusti shinanquin. Nan fusti yopaiquin. María ahuun nomuran uhuun tsain nanushon aquimashquimaran, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ascano shafa futsa Apa cufiqui anaitiano afu rafua futsan yocani, —Ifon, raquirimun non Upa cufiqui huatiroquin. Noco tapimahuun. Juanpan afu rafuafo tapimani cuscan nocorifi tapimahuun, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—Isca huacahuun, —ishon Jesús ato yosini, “Nocon Upan nai murannoaton min fasi sharacoin. Manifotiton aton niaifo iishquin mia ifoannonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Shafatifi nocon tushu non yopai cuscan noco inanhuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nan noco chaca huaifoan non ato rau huaa cuscan huafain nocon chacafori noco rau huashohuun, Upan. Satanás yoshin chacapan noco chaca huamapaifiaiton nocoqui cumatima huahuu. Nansca huaquiquian,” ishon Jesús ato yosini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ascatan afanan ato yoiquin isca huani, —Manmun mato yorahua yamunacucahuanaino mato ano nococun maton yora futsa yoa yocashoquin isca huaquin, ");
INSERT INTO mcdNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Ua yoa rafu non fusti inanpun. Un mia nasonon. Un natian yopaicai uhuun yorafo chaicunoashu uqui nocoano un ahuashta pimaimacain,” ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Ascaiton cumaquimun isca huatiro, “Mun uhuun facufo ya iquia caincaitiri man fupoa. Asca ua fucash huayamahuu,” ishomun anori cumatiro? ");
INSERT INTO mcdNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma. Ascacai huatiroma. ¿Raquiri huatiromun? Un mato yoi. Ahuun yorahuaton inanyamai shafai fasi manariaiton inanyamacuatan inantiro. Funinaca huatan nan yoca cuscan inantiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Afanan ahuara futsa un mato yoiai cuscan nicacahuun. Ahuara yopaquin Upa Dios yocacahuun mato ashonon. Man yocain cuscan funaquima manasharacahuun nan Diosin mato ashoaitian. Ascacun Upa Dios cufifafaincahuun man cufiai cuscan mato inanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsoan Upa Dios yocariai fiishquin. Ascan tsoan ahuara shara fasi fuchipaiyai cuscan Diosin ato fuchimatiro. Ascan tsoanri Upa Dios cufiriaiton ashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Ascan maton facun mato shiman yocaiton man rono inantiromun? Ma. Mancai maton facu asca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Maton facuri mato tacara to yocaiton man inapapia inantiromun? Ma. Mancai maton facu asca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ascacun tapicahuun. Man chaca huamisifiashon maton facufo man inansharamisi. Man ascaiton finacaiya maton Upa Diosin nai murannoaton man yocai cuscan ahuun Yoshin Shara mato inanshquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ascano yoshin chaca nocofunuhuun nuushon tsainmatiroma Jesusqui ocun. Amaquinoa yoshin chaca potano tsaiinnaca huanaiton oincani mustairinifo. Ascashon atirifiton, —¡Aicho shararan! —huaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Futsafoan yoinifo, —Satanás curushhuunshon Jesús yoshin chacafo yorafomaquinoa potatiroran, —ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Futsafoan Jesús yoiquin isca huani, —Dioshuunshon nai murannoa noco ahuara futsan ismahuu non mia icoinra huanon Diosin mia catoanquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ascano nan shinainfo cuscan onanshon Jesús ato yoini, —Mani futsafo afi ranan rutunain cuyotirofo. Nanscarifiai pushu fusti muran icafori afi ranan chaca huatananfafaincani pashcanantirofo afanancai tsoa anosi itiroma. Ascashuricai afanan tsoa yorahuatanantirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nanscarifiai Satanás niaifoan afu yoshin chacafo potaquin ahuun yono chacana huatiro. Asca huaquin ahuun yono cuyocointiro afu yoshinfocai afanan afu itiroma. Un nannori yoia manmain yoiquin isca huayamacun, “Satanashuunshon yoshin chacafo potaran,” ishon man uhuunoa yoia. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ascafia manfin uhuunoa yoimisiquin. “Satanás curushhuunshon yoshin chacafo potaran,” ishon man yoimisi. ¿Un asca huaino tsonhuunshon mato yorafoanri yoshin chacafo atomaquinoa potafomun? Ascacun nanfohuunshon man tapitiro man uhuunoa amaquiri shinanchacai cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ascafia Diospan Yoshin Sharahuunshon un yoshin chacafo atomaquinoa potaiton man tapitiro maton Numamisi Diosin catonni man matoqui nocoa. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ascan nocofunu mutsisipacoinin tucuti yashon ahuun pushu cushuanocai tsoan ahuun ahuashta muntiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ascafia nan finoncaia fasi mutsisipacoin aqui nocoshon achifain ahuun cunoti mufishon ahuun ahuarafo cuyonfiaitocai ahuusca huatiroma. Ascashu ahuun ahuarafo pashcanain futsutirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tsoa ufu rafucasmaquifin uhuun tsain nicacasmacaniquin. Nanfoan futsafo ua icoinra huamapaicanima. Ascaquifin Diosimaqui ato imacaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yoshin chaca nocofunumaquinoashu cai tsoa istaipama ano cani shara futsa funai cai anoshon tunushquin. Ascafia fuchiamacaiqui yoshin chacanun afanan shinanqui isca huani, “Unfin nan nocofunuhuun ipaoniquin. Ascacun un afanan aqui nasoiran,” ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aqui nocoshon oian tsoa futsacai afu rafua inima. Nan pushu matsomua shara ointsa. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ascacun nan yoshin chacanun afu yoshin chacafo siete ato ihuuni nan fasi chaca finacaiafo. Ascashon ato yoiqui isca huani, “Nocofunun un mato ismaicai non ahuun nuifonon,” ishon ato yoini. Ascatan aqui foshon iquinaifoanno nan nocofunu fasi mimacai chacacoin ini. Manmain aqui rananri focun, —ishon Jesús ato yoini. —Asca huaifoanno nan nocofunu afanan finacaipacucahuani. Mimacai fasi omitsiscai finacoincun, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ascaiton ato yoiaino ainfoan nan yorahuanrasi muranshon oi ashcafinin Jesús yoiqui isca huani, —Min uhua mia cainshon mia shoma amani. Ascacun min uhuaquimun Upa Diosin unimasharapainon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ascatan Jesús cumani, —Ai, nan min yoiai cuscan iconfiashu tsoan Diosin tsain nan nica cuscacoin Diosin nan unimamatiro finacoian, —ishon cumani. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ascatan fasi paratama yorahuanrasi Jesusqui fuaifoan. Ascaiton ato yoini, —Natian niafo fasi chacacoinfo. Ascashon ua yoimisifo isca huacaquin, “Tsoan atiroma cuscan noco ismahuu min Dios ariashu oa non mia icoinra huanon,” ishon ua yoimisifo. Ascafia nan Diosin tsain yoimisi Jonás ani cuscacoin un chipo mato ismaiton nan fusti man oinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ascan Jonás tsainhuunshon Nínive anoafoan Dios icoinra huanifo cuscan nanscarifi huaquin natian niafo un mato yoi marifi man icoinra huanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ascashon Diosin nantifi yorafo ichanan huaitian ato yoipacushquin ratofomain afu ipatiro iyamarai omitsiscapanacafo muran foshcaniquin. Nantianri nan ainfo Sabafoan ato niaifo ipaoniton matohuunoa yoiquin isca huashquin, “Salomón tapicoian cuscacai tsoa futsan tapipaonifoma. Ascacun ahuun tsain nicapaicoin un aqui chaicunoashu cani cuscan mancai nan Diospan Fururi asca huapaipaonima. Ascatamarocon man nicacasmapaoniran,” ishon matohuunoa yoishquin. Nan icon Salomón tapicoian ipaonifia uncaifin fasi Salomón finoncoinfiacun mancai ua nicapaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nanscarifi huaquin Diosin nantifi yorafo ichanan huaitian ato yoi pacushquin ratofomain afu ipatiro iyamarai omitsiscapanacafo muran foshcaniquin. Nantian Nínive ano ipaonifoan matohuunoa yoishcani isca huaquin, “Jonás noco Diosin tsain yoiai cuscan nicacoinshon non nocon chaca shatucoinfain non Dios icoinra huani. Asca man manfin Diospan furucoin nicafiashocai maton chaca man shatupainimaran,” ishon mato yoishcani. Nan icon un Jonás finonfiacucai man ua nicapaimisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Asca huatan afanan ato yoiquin isca huani, Tsoancai lamparina ihuashon otayamafain paninaranunri fupoima. Asca huatamarocon shafacafi tsaoi nan iquiaifoan oinsharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nanscarifiai nocon furo rafu noco cayan lamparina cuscara. Nan rafu sharano non oinsharatiro. Ascashon nocon caya cushusharatiro non ahuuscanonma. Nanscarifiai mato nomuranshon man shinansharai man isharacointiro. Ascafia maton furo chacanocai man oinsharatiroma. Ascashu nan faquish muran ica shinantsain. Nanscarifiai maton nomuranshon man shinanchacaicain man isharatiroma. Man funocointiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ascacun oinfain. Tapicahuun mato nomuranshon man shinansharai cuscan chaca shinantama. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ascashu shafacafi man icafin nan chashamatinin mato chashama cuscaraquin. Nanscara ano man icacai faquish itiroma. Nanscarifiai maton nomuranshon man Dioshuunoa fusti shinansharaino man ahuara chaca shinantiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ato yoiqui anaitiano Fariseonun Jesús yoimani pimashquin. Ascano ahuun pushu muran oashu tsaoni. Ascaino pishcaquin Fariseofo ato shunifoan ato tapimani cuscan ahuun mucu chocayoni. Asca Jesuscai Fariseo imisifo cuscan anima. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ascaiton oinquin Fariseon ahuun nomuran shinanni, —¡Ajaa! Nocon shunifoan noco tapimani cuscacai Jesús aimaran, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ascaiton Jesús ahuun nomuran onanshon yoiqui isca huani, —Ua nicahuu. Man Fariseofoancai maton mucu chocafiaquicai man maton nomuran ahuara shara shinainma. Yora futsafohuunoa shinantama. Man ahuara futsa futsa tapasi noicoin. Maton nomuran chaca futsa futsatapafo fospicoianran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","—Manfin fasi amaquiri shinanmisiquin. ¿Man tapiamamun tsoan noco caya fumancayan onihuafain noco nomuranri onihua? ");
INSERT INTO mcdNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ascacun ahuuomafohuun ramapaicain ato inansharacahuun. Man ascaiton tapitirofo Diosin maton chaca mato soashotiro man sharacoin inon. Ascashu man shinain cuscan shara fustisi iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ohuashta! Fariseofoan mato Diosifin onaintimashquiquin. Mato fanafo atirifi man Dios inanmisi. Man asca huafiaquicai man futsafo shara huamisima. Ascaquifin man Diosiri noicoianmaquin. Man mato fanafo atirifi Dios inanmisi cuscan sharafia futsafo shara huafain Diosiri noicoincahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ohua! Fariseofoan Diosin mato onaintimai. Ichananti pushu muran iquitan shafacafi man tsaofafaini mato oinquin, “Sharacoinforan,” mato huanonfo. Yorafoan mato finonfoancaquin, “Noco tapimamisiton,” mato huaifoanno man unimanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ohua! Ascafia Diosin mato onaintimai. Manfin naan yora naa cuscarafoquin. Yora mai huafo manaon cahuaqui futsafoan tapishoma puamafoantirofo. Nanscarifiai yorafo matoqui nocofiashocai tapiafoma maton nomuran man chacacoinfiacun, —ishon Jesús Fariseofo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ascaiton nicacaquin Moisés cununi cuscan tapimamisi futsan cumani, —Tapimamisiton, min anori yoiquifin nocori min roaiquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús cumani, —¡Ohua! Moisés cununi cuscan tapimamisifoan matori Diosin onaintimai. Man maton caifo yoiqui isca huamisi, “Moisés cununi cuscan nantifi huacahuun. Fustishta finonmayamacahuun,” ishon man ato yonofiashucai marifi man ascacoinyama. Ascatamarocon Moisés yononi cuscan finonmafain man ato huama. Ascano apaifiaquicai tsoan atiroma. Ascafiaifoancai maton mucuman ahuashta ato futan man huapaiyama. Ascashu aton nomuran omitsiscafiaifoancai man atohuun ramapaiyama. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ohua! Diosin mato onaintimacoin. Man mato shunifo nan Diosin tsain yoimisifo maiafo ano man ahuara toquiri onihuamisi ato shinanshquin. Man asca huafia mato shunifoan ato rutupaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mato shunifo Diosin tsain yoimisifo rutunifo. Man amisi cuscan huaquin man yorafo ismai nan maton shunifoan apaonifo cuscan huaquin marifi atofu niyoshon man asca huacuana. Ascashufin marifi man rutumitsamisi cuscaraquin. Diosin tsain yoimisifo maton shunifoan rutunifo. Ascacun maiafo ano man toquiri onanti huaquin fufoa. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ascacun Diosin onancoinshon matohuunoa yoiqui isca huani, “Uhuun tsain yoimisifo yafi uhuun facu fu rafuafo ato yoisharanonfo un ato nichishqui. Ascafia atirifi ato rutufain atirifi ato omitsisca huashcaniran,” ishon Diosin matohuunoa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ascan nan icon un mato yoi. Nantifi Diosin tsain yoimisifo ato rutupaonifo nan Diosin ato onihuaqui tau huanitian yafi natian. Ascacun atohuunshon Diosin matoqui nutashquin. Nan Abel rutuqui tau huafain ahuun unutaqui Zacarías nan Dios fu tsainti pushu muranshon cufiti chaimashon man rutunifo. Ascashon nantifi Diospan yorafo chaca huapaonifo cuscan natian man niyoano matoqui nutashon mato omitsisca huaqui finacoinshqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ohua! Moisés yononi cuscan tapimamisifoan Diosin tsain cununi cuscan onui cafisca man huaa futsafoanri tapisharanonfoma. Mancai Diospan tsain icoinra huacoinnama. Ascashon futsafoanri tapipaifiaiton man ato shutia icoinra huanonfoma. Ascacufin Diosin fasi mato onaintimaquin finacoinquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Nicacanashu Fariseofo yafi Moisés cunu tapimamisifori fasi aqui sinacoincaquin aqui tsain chipunifo. Fasi ichapafain yocanifo. Ahuarashta amaquiri ato cumaiton nicapaicaquin. Amaquiri ato yoitanaino niaifofoquin chanipaicaquin Jesús cunu muran iquimanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ascaino yorahuanrasi aqui fucani yurui furanifo. Ascaifoan Jesús afu rafuafo yoiqui isca huani, —Oinfain. Fariseofoan, “Sharaforan,” mato huamapaicani. Sharafomafinquin. Sharafo shafain man ica sharafoyamafiacun. Nanfo fuparamitsamisifo. Ascacun ato cuscara iyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ascafia ahuarashta onupaifiamisifo nantifi Diosin ato puashoshquin. Ahuarari fomanpaimisifo nanfori ato puashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Futsafo fomanfain arusu fusti shinanfiamisifo nanfori Diosin ato puashoshquin. Cunu muranshon onushta yoifiafo nanfori ato puashoshquin nantififain tapinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Uhuun yorafoan un mato yoi. Mato rutupaiyaifoanno ratuyamacahuun. Mato caya fusti rutucaniquin. Asca maton yoshinfocai tsoan ahuusca huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ascacun atoqui ratuquimarocon Diosiqui ratucahuun. Nantofi mato rutufain maton yoshinfori omitsiscapanacafo muran potatiroquin. Nanno chi urumanhuan matsinacama. Naan icon un mato yoi. Dios fustiquifin man ratutiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ascano tsitsipio mucu fustiti inanmitsashonraca toro rafu fitirofo. Ascafia Diosicai fustishtahuun ointiaquimanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nan icon un mato yoi. Diosin nantifi tapicoian. Mato foori man tanan huani. Ascasho Upa Diosin tsitsipiofo shinanmisi cuscan fasi mimacaia matohuunoa shinanfafaini. Ascacun ratuyamacahuun. Matocaifin tsitsipio aca finonmacaifain Diosin matohuun noiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ascano tsoan yorafoan ointaifi, “Jesús uhuun iforan,” ishon ato yoiafin uhuun Upa Diosin ahuun oinmatifoan afu nai muran icafoan ointaifi, “Naanfin uhuun yoraquin,” ishon un yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Asca tsoa yorafoan ointaifi, “Jesús uhuun ifomaran,” ishon yoia nantocai ua icoinra huamisima. Nanscarifi huaquin Diospan oinmati afu nai muran icafo ointaifi, “Naancai uhuun yoramaran” un yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tsoan ua chaca huafin Upa Diosin rau huashotiroquin. Asca tsoan Diospan Yoshin Sharaqui tsain chaca huacai rauhuanacama. Aton chaca atohuun nuupacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ascano ichananti pushu muran mato iyocashon niaifofoan ahuun ointaifi raquirira mato huafiaifoan shinanchacayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nantianfin Diosin ahuun Yoshin Sharapan mato shinanmatanaino mato tsain chaca huaifo Diospan Yoshin Sharahuunshon man ato cumasharanon, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nannoa nia futsan Jesús yoini, —Tapimamisiton, uhuun yora ua yoishohuun nocon upan noco inan cuscan uari pashcashonon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús cumani, —Uhuun yoran. Uncai tsoa yoimisima futsa pashcashonon. Tsoanricai ua catoanma un ato pashcanan huanon, —ishon yoitan. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Afanan ato yoiqui isca huani, —Ua nicacahuun. Matonama fuchipaiyamacahuun. Ahuara ayafiashon afanan finonmafain fipairiyamacahuun. Mafo ichapayahuunoashucai non unimatiroma. Nocon mafocai nocon ointi unimamatiroma. Nocon mafohuunoashucai non isharatiromaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ascashon nocofunun ichapayahuunshon Jesús ato ahuara yosini isca huani, —Nocofunu futsa mafo ichapaya ahuun mau ano ahuun yono sharafori ichapaya ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ascacun nan nocofunu mafo ichapayaton shinanqui isca huani, “¿Umun uhuun yonofo ahuusca huaiquin? Uhuun tasha pushufo murancai uhuun yonofo icoinama. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ascacun uhuun tasha pushufo pucashon un afanan uhuapacoin huai. A muran uhuun yonofo yafi uhuun mafofo icoinon. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Uhuun nomuran un shinanqui isca huaa, ‘Uhuun ahuara ichapa iquisi mucushon chipo un tunusharafain ayafain aqui pifain monocain un unimasharacoinniran,’ ” ishon ahuun nomuran shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ascashon anori shinanfiaiton Diosin yoini, “Mincai ahua tapiama. Na yamutafin min naicain. ¿Min naanomun na min mucuafo ahuuscaiquin?” ");
INSERT INTO mcdNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nanscafin yora ahuara ichapayashon Diosin shinantama imisishaquin. Naashucai afanan ahuaya iquima. Nan ahuuoma cuscara iishquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ascaino Jesús afu rafumisifo yoiquin isca huani, —Afanan un mato yoisharanon. Ua nicasharacahuun. Isca huaqui shinanyamacahuun, “Non ahua pimara,” ishon shinanchacayamacahuun. Ahuaricai non sahuuimaran iyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Non ahuara pifain non sahuuatocai noco imasharatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shinancapon. Nan puiyafoancai ahua fanayamafain ahua chitunmisifoma ahuaricai fotsuyamafain ahuamafofiacun Diosin ato pimamisi. Nanscarifi aquin Diosin matohuun noiquin nan puiyafo aca finonmafain mato cushushara. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ascacun shinanchacayamacahuun. ¿Non shinanchacatocai shafa fusti noco nimayotiromun? ");
INSERT INTO mcdNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Asca shinanchacahuunshoncai ahuaton noco nimayotiroma. Asca ahuara futsari shinanchacahuunshon noco imatiroma. Asca ahua shinanchacayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ascashon shinanquiri isca huayamacahuun, “¡Ohuashta! Raniamun un sahuuti finanti sahuushqui,” ishon shinanyamacahuun. ¡Shinancapon! Salomón sahuuti sharashtacoin sahuufiapaonicai nan charo sharashtacoinfo cuscarama. Charofoancai yonoyamafain sahuuti icushuima. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosin charo sharashatacoinfo onihua. Foaisharafia supashon samamashta tsasicun coatirofo. Nanfo finonmacaifain mato noiquin mato sahuuti sahuumashquin. Ascafia mancai icoinra huasharacoinnama. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ascacun shinanquin isca huayamacahuun, “¡Ohuashta! Unmun ahua piishquin uhuun tushuyamaino. Unricai ahua sahuuimaran,” ishon shinanchacayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ascan nannori nan icoinra huamafoan shinanchacamisifo. Ahuara pifain sahuupaiyaifo fustisi shinanmisifo. Ascan maton Upa Diosifin tapiaquin man yopai cuscan. Ascacun mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ascacun Diosicairocon shinancahuun. Mato yonomapaiyai cuscan nan fusti shinanfafaicahuun. A cuscara shara ipaicahuun. Nancai shinanquin tau huafafaincahuun. Man ascaiton ahuara futsa man yopai cuscan Upa Diosin mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ascano uhuun yorafoan ratuyamacahuun. Maton Upa Diosin mato cushushara. Nantifi ahuuna matori inain. Unimacai mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Maton mafo inanmitsacahuun ahuun rafanan pui fishon yora ahuuomafo inanshcaquin. Man ascaiton Diosin nan icanoshon mato ahuara sharacoinfo mucushoni. Nanfocai cuyopacunacama. Coroisin nanfo piquin chacana huayamainocai yomutsori ano iquitiroma ahuara mato fianshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Asca man mafo fusti shinanfafainquifin nan fusti man noicain. Ascan man Dioshuunoa fustisi shinanfafainquin nanrifi man yonoshosharafafaintiro ahuun noicoinquin. Ascashu man afu isharapacupaitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ascacun itisharacahuun. Un mato anoashu un chipo nai muran caiquin. Ascafiashu ratoran shafatan iyamarai yamu un matoqui afanan nasoshquin. Yamu yora futsa nocoaiton manaquin lamparina otatiro itisharashon. Asca nanscarifiai itisharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Oinmatifoan aton ifo fusititian mai futsa ari cano futsafoan a pushu anoshon manasharatirofo. Ascano ifoan nocoshon ato cunaiton yoitirofo, “¡Aicho! Iquiyohuu,” huatirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ascaino Ifoan nocoshon oian ahuun oinmatifo itisharafoanno unimacointiro. Nanforifi a unimatirofo. Ascan un mato icon yoi, Nan ifoan atoqui nocoshon ato pimaquin yoiqui isca huai, “¡Aicho! Fucahuun. Un mato pimapaiquin,” ishon ato yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ascashu man rama osha pacuaino iyamarai yamunacucahuanaino iyamarai shafa matsi matsicaino ifo nocoaiton oin ahuun oinmatifo itisharashu fasi aqui unimacointirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ua nicasharacahuun tapishcaquin. Pushu ifoan iquisi itisharashon yomutso yamu ahuuscaraino ahuun pushu muran iquiai tapishocai iquimatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nanscarifiai marifi itisharacahuun. “Iscaino nocon ifo oimaran,” ishon shinanyamacahuun. Ahuuscara atanaino un matoqui nocoriscaiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ascaiton Pedronun yocani, —¿Ifon, min ahuarafo yoiai cuscan noco fusti min tapimapai iyamaraimun nantifi yorafori min tapimapaiquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús cumani, —Man tapinon un mato yoi ahuu cuscaramain oinmati shara itiroquin. Niaifocoin mai futsa ari caquin niaifo patasharinoaton yoitiro isca huaquin, “Uhuun oinmati futsafo ato tushu shafatifi inanhuun. Nanticoin rafu aton pashcanan huahuun,” huafaini catiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ascatan niaifocoin afanan nocoshon oinquin ahuun niaifo patasharinoa nan yoia cuscacoin aano fasi aqui unimacointiro. Ascashon nan shara huacointirori. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ascacun un mato icon yoi. Nan niaifoan ahuun oinmati yoi, “¡Aicho! Natian nantifi uhuunafo min ua cushusharashotiroran,” ishon yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ascafia nan niaifo patashari chacapan ahuun nomuran shinanqui isca huatiro, “Uhuun niaifo funa nasoimaran,” ishon shinanquin oinmatifo futsafo nocofunufo yafi ainfofori ato chaca huaqui futsani. Ascashu shafatifi pauncain monoi. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ascaino ahuun niaifocoin samamashta nocoriscatiro. Nan oinmati chaca itisharamano ahuun niaifo nocoshon a onaintimai. Ascashon niaifoan oinmati futsafo yonoqui isca huai, “Nan oinmati chaca icoinra huamafoanno potacahuun omitsiscapashanon,” ishon yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ascan nan oinmati ahuun niaifoan yoia cuscan man tapifiashu ascayamacai itisharayamacun ahuun niaifoan nocoshon a fasi curushcain coshaquin futsai. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Asca nan oinmati futsa ahuun niaifoan yoia cuscan tapishoma chaca huacun nan icoquin ahuun niaifoan ichapama coshashquin. Nanscarifiai tsoa Diosin ichapa tapimana aqui nococun yocaqui isca huai, “¿Un mia ichapa tapimana cuscan man mian nanscacoin aamun? ¿Ascashon futsafori un mia yoia cuscacoin min huashoamun?” ishon yocashquin. Ascacoin huaiyamashu funotiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Un nantifi manifotifi chaca shatumani yoi un oa. Atirififoan ua icoinra huaifoanno futsafoan ua icoinra huacanima. Nan icoinra huamafo Diosin ato onaintimai. Uhuun Upa Diosin ua mai ano yonomai cuscan natian cuyoa shara icuana. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ascafiacun matohuunoashu naashqui un oni. Un nataima iquisi un omitsiscacoinshquin. Ascashu u omitsiscacaini naashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ascan man shinanmun nantifi manifoti anoafo uhuunoashu unimanonfo un oni. Ma. Ascaramafiqui. Un mato yoiai cuscacai tsoan nannorifosi shinancanima. Asca nan ua icoinra huafoan sharafosi shinainfoanno nan ua icoinra huamafoan ahuara chaca futsafosi shinancani. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ascashu pushu fusti muran mucu fustiti icafoan rafutasi ua icoinra huaifoannocai nannorisi atirifiton tsoan shinantiroma. Nanscarifiai rafutan iyamarai rafu non fustifain ua icoinra huaifoannocai nannorifosi atirifiton tsoan shinantiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apa ua icoinra huaino furumun ua icoinra huashma apaqui sinatiro. Ahuan ua icoinra huaino ainfacu ua icoinra huashma ahuaqui sinatiro. Ahuun yayan ua icoinra huaino ahuun raru ua icoinra huashma ahuun yayaqui sinatiroran, —ishon Jesús afu rafuafo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ascaino nannori yorahuanrasi mapoafoan afanan ato yoiquin isca huani, —Fari iquiai anori nai choshtacoin foancuaiton oinquin, “Oi fuiran,” man huano. Oi futiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ascasho manri yoimisi, “Fuu fari cai istafari fasi shana iishquiran,” man huamisi. Ascan nan icon fasi shanacoin itiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ascafia mancai man yoia cuscacoin amisima. Nai foisquin man tapitiro oi fui iyamaraimain fuimacai. Ascafia mancai Diosin mato yoia cuscan icoinra huapaima. Natian ahuara ahuuscarai cuscacai man tapiama. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Ahuuscain mafiri man cayacafi shinansharaimamun? ");
INSERT INTO mcdNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tsoara futsan mato yoiqui isca huai, “Min ua chaca huaa cuscan. Un miqui niaifo yoicairan,” ishon mia yoicun. Niaifo ari cataima rufofo shara huacahuun. Man asca huayamacun niaifoan mato cunu muran iquimatiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mato iquimananocai man cainritiroma nifian cuscan nantifi inanshu man caintiro. Nanscarifiai man Dios chaca huamisiquin. Oataima iquisi mato yoia cuscan acahuun mato omitsiscahuanonma, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nantianri futsafo Jesusqui fucashon yoiqui isca huafo, —¿Tapimamisiton, man min tapiamun Pilatonun Galilea anoafo rafu rutua? Ascashon Dios fu tsainti pushu muran aton imi yafi inafoan ahuun imi osia Dios cufiti camaqui huaran, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ato cumani, —¿Man shinanmun nan Galilea anoa rafutan chaca huaqui fina ahuun caifofoan acama cuscan huaquin? ");
INSERT INTO mcdNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma. Ascaramafinquin. Marifi maton chaca shatutama nan man shinanpaoni cuscasi shinanriaqui Dios icoinra huashuma marifi man omitsiscapanaca. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Man shinanrimun nan dieciocho yorafoqui pushu cuyacoin ahuun anu Siloé atoqui paoinquin atoti rutuni. Nanfoanmun fasi chaca huaquin finacaimisifo nan Jerusalén anoafoan acama cuscan finonmafain. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma. Ascaramafinquin. Marifi maton chaca shatutama nan man shinanpaoni cuscasi shinanriaqui Dios icoinra huashuma marifi man omitsiscapanacaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ascashon ahuara futsahuunoa ato yoiquin ato tapimanon isca huani, —Nocofunun ahuun mau mamaqui fimi fanani ahuun anu huiguera. Ascan chipo fimimisitian fii capaiquin oian fimiama ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ascacun nan mau ifoan ahuun mau cushumisi yoini, “Rafu non fusti fari na huiguera fimiataima. Un ahuun fimi fipaifiaino fimiama. Ascan natian rurahuu. Non ahuara futsa nanno fananon,” ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nan mau cushumisiton yoini, “Ifon un afanan mana futsayononhuun. Afanan na fari fusti non manayonon. Un natian cushusharafain ahuun tapo ano un ahuara futsafo huayonon fimisharanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nan un asca huainomain fimiqui non oinon. Ipaishoma na fari anaitiano man fimi ya shara itiroquin. Ascan fimiyamaiton min ua ruramatiroran,” ishon mau cushumisiton yoiniran, —Jesús ato yoini ");
INSERT INTO mcdNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ascano chipo Israelifoan ichananti pushu muranshon tunutitian ato Diosin tsain yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ascashon ato yoiaino nannori ainfo putoco dieciocho fari isinintiani atofu nanno ini. Yoshin chacanun nan ainfo nansca huaa. Cayacaficai nimisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nannoa fuchishon Jesús yoini, —Ainfoshtan, natianfin min cayaiquin, —ishon yoitan. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ahuun mucuman manmainno samamashta cayacafi ninacahuani. Ascatan, —¡Aicho! Diosin ua cayahuaquin. Dios fasi shararan, —ainfoan huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ascafiaino ichananti pushu murannoa niaifo fasi sinaquin ato yoini, —Seis shafatan non yonotiro. Ascan na shafata tunutitiancai tsoa cayayotiroma. Cayapai shafa futsan otiro cayashquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ascaiton nocon Ifo Jesús a cumaquin isca huani, —Manfin fuparamitsamisifoquin ¿Asca manmun tunutitianfiacun maton moi iyamarai burro man tuputiro unu ano iyoquin ayanonfo? ");
INSERT INTO mcdNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ascano na ainfofin nocon caifoquin. Abraham ahuun funa. Satanashuunoashu dieciocho fari putocoa. Cayacafi niisharamisima. ¿Asca ahuuscaimun un tunutitian na ainfo cayahuatiromaquin? —ishon Jesús yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nicacani Jesús noicasmaifo fasi rafipaicaquin tsoan cumanima. Jesús ahuara sharafo huaiton oincani atirifo aqui unimacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ascaifoan Jesús ato yocani, —¿Ahuu cuscaramun Diosin ahuun yorafo nantifi ato iquifain ato yonotiroquin? ¿Ascan ahua futsarimain Diosin ahuun yorafo cuscaraquin? Un mato tapimai. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nocofunun ahuun pushu umainti mostaza ushu fanani. Asca foaica ihui tio ica. Puiyafo ahuun tushpahuu tsaoafo. Nanscarifiai Diosin ahuun yorafo taui fustirasi ifiashu chipo paratama caitioran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Afanan Jesús ato yocaquin, —¿Ahua futsamun Diosin nantifi iquina cuscaraquin? Un mato tapimai. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Diosin ahuun yorafo nantifi ato iquifain ato yonotiro cuscan un mato tapimai. Ainfoan farashati ichapamashtaya harina osishon camisconano farashuinitiro. Nanscarifiai Diospan yorafo taucani fustirasi ifiashu paratama itirofo. Ascashu icoinra huamafo muran ishon ato shara huaino atirifiton ahuunshori icoinra huatiroforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ascashon Jesús pushurasiti ano yoifoni Jerusalén ano nocopaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ascaiton futsan yocani, —¿Ifon, fustirasitomun aton chaca soacaniquin Upa Dios fu nipashcaquin? —ishon yocani. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ascaiton Jesús ato cumaquin isca huani, —Uhuun Upa icanocai atirifi iquitirofoma. Ascacun nan un mato yoiai cuscacoin nantifi huacahuun. Nan fai atsoshta tanashcaquin. Ascashon marifi Diosin tsain tanasharacoincahuun iquisharashcaquin. Yora ichapafo iquipaifiacanicai iquitirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nan pushu Ifo Diosin ahuun cunu fupoti fupoanocai tsoashta afanan iquitiroma. Ascacun chifi nishon yoiqui isca huatirofo, “Ifon, noco cunu fupushohuun. Min icano non canon,” huariacani. Tuyuyun ifiaifoancai ato fupushotiroma. Fuputama ato yoiqui isca huatiro, “Mancai uhuun yorafoma,” ato huafiaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yoicaquin “Non mi futan pifain ayafain huamisi. Min noco yosiaino,” ishon yoishquicani. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ascafiaifoan afanan ato cumaquin isca huashquin, “Mancai uhuun yorafoma. Uncai matofu rafumisima. Manfin chaca huamisifoquin. Ascacun umaquinoashu fotacahuun,” ishon ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ato asca huaino nannoashu uaicani omitsiscai futsushcani. Dios fu rafuafo Abraham non Isaac non Jacob non nantifi Diosin tsain yoimisifo Dios fu icafo oin atoqui capai man fasi uaiqui. Yoishquin isca huaquin, “Ahuuscashucai non catioma. ¡Ohua! Ahuuscain un Dios nicacasmamisishaquin. Un omitsiscapanacaran,” ishon man yoishquin. Man ascafiaiton Diosimaquishon mato potashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ascaino manifoti anoashu Diosin niaifoan ahuun yorafo iquina ano nococanashu afu unimashcani. Ascaifoan Diosin ato yoiquin isca huashquin, “Uqui fucahuun. U fu ipasharashcaquin,” ishon Diosin ato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Shinancapon. Futsafocai natian Diosin ahuun yorafoma. Chipo icoinra huacanashu ahuun yora ishquicani. Futsafoan man Diosin tsain nicafiamisishaquin tsoa ascacoinyafoma. Afocai afu itirofomaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nantianri Fariseofo Jesusqui fucashon yoinifo, —Nunoashu mai futsa ari cariscatahuun. Nan niaifo Herodes mia ato rutumapai oiquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús ato cumani, —Nan onanya yoitacahuun. “Uncai nunoashu funa caima. Na shafata yafi shafa futsa un yorafo yoshin chaca atohuun nua un ato caya huafain isinincaifori un ato cayahuayoi. Uhuun yonofo anaititan nan un nocopai ari un nocoicai. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Un natian uhuun Upa ua yonoa cuscan nan fusti un yonoyoi nan un naitian. Man man tapia Diosin tsain yoimisifo Jerusalén anoshon fusti ato rututirofo.” ");
INSERT INTO mcdNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ohua! Jerusalén ano icafoan. Manfin Diosin tsain yoimisifo rutufain nan Diosin matoqui nichian futsafori man toquirinin ato tsacaqui nanonfo. ¡Ohua! Tacaranun ahuun facufo ahuun pui naman onutiro cuscan huaquin un mato yafi mato yorafo cushupaifia mancai ua nicapaimisima. Manricai uqui fumisima un mato cushunon. ");
INSERT INTO mcdNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ascan natiancai tsoan mato cushuima. Diosiricai afanan mato cushuima. Ascacucai man ua afanan oinnacama Diosin matoqui nichian un nai murannoashu oaitian. Man yoiqui isca huaino, “Diosin nocoqui nichian fasi shara finacaia. Upa Diosin a shara huapanacaran,” ishon man uhuunoa yoishquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Man ascano chipo Fariseo niaifoan ahuun pushu muranshon Jesús tunutitian pimani. Ascaino yora futsafori afu pushu muran iquinifo. —Jesusmain ahua huaicain non oinnon, —icanashu. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ascaino nannori nocofunu poyan rafu farashicain quishi rafuri farashiqui futsua. Ato fu iquia oincaquin atirifoan shinannifo, —Jesusmain cayahuaicain non oinnon, —ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ascaiton Fariseofo yafi Moisés cunu tapimamisifo Jesús ato yocani, —¿Tunutitianmun non ahua ahuusca huatiroma? ¿Moisés cununi cuscan tunutitian non yora caya huatiromanmun? —ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ato yocafiainocai tsoa puusinima. Ato asca huatan a isinincai Jesús mutsoano cayariscani. Ascacun Jesús a nichini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ascashon Jesús ato yocani, —¿Rato man futsamun tunutitian maton facu futsa iyamarai maton moi mai quini muran pacucun man ihuirisca huatiromaquin? —ishon ato yocaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tsoa puusinima. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ascashon Jesús oinni shafacafi tsaopaiyaifoan —Noco oinsharanonfo, —icanashu. Ascaifoan oinquin Jesús ato yoini, —Ua nicasharacahuun un ahuara futsa mato yoi man tapinon. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tsoan mato piimaino pushu ifo tsaoano tsaoyamacahuun. Un tsoa cuscaramaran ato huamapaiyamacahuun. Min pushu ifo fu tsaoaiton mia yoitiro, “Nuno min tsaotioma yora futsa nuno tsaoyoi. Nan mia finoncoian. Ascan minfin futsano tsaotiroquin.” ");
INSERT INTO mcdNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aton ointaifi pushu ifoan mia anori acaino min fasi rafipaicai. Shararocoai min pasotain tsaotiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ascan ifoan mia tsaopaiquin a chaima mia cunatiro. Mia asca huaiton oinonfo a mia shara huai cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ascan tsoa oinanpaimisi chipo Diosin ismashquin acai ahuacuma. Ascan tsoa oinanpaimisima naanfin yorafoan ointaifi Diosin yoitiro isca huaquin, “Ua chaima tsaoyohuu. Ufu nipashquin,” ishon yoishquiran, —Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ato asca huatan nan pimai Jesús yoiqui isca huani, —Min yorafosi yafi yora mafo ichapayafo pimapaiquin nanfosi cunayamahuu. Nanfoanri mia copiquiri aton pushu anoshon mia piimacani. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ascatamarocon man yorafo man pimapaiyai cuscan a yora ahuuomafo yafi yora nipaiqui ranainfo non a fushofori piimacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nanfoan mato copiquiri shara huapaifiaquicai atirofoma. Ascashu man Dios icari nococun man ato shara huaiton oian cuscan Diosin nantian mia shara huacoinshquiran, —ishon Jesús Fariseo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Futsan sapa ano tsaoshon Jesús yoini, —Ifon, Upa Diosin nantifi yorafo iquinai ano atofu iquiashu fasi ipasharashquiran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús cumani, —Nocofunu futsan tushu ichapa itishara huashon yora ichapafo chani huani a futan piishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ascano man itishara huashon ahuun oinmati nichini ato yoitanon. Yoiqui isca huani. “Nan un chani huafo ato yoi foanfafaintahuun isca huaquin, ‘Man nantifi itishara huaqui. Fucahuun,’ ishon ato yoitahuun,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Asca huano caashon ato yoiaiton, “Un cayotiromaran,” ishon yoipacunifo. Futsan yoiquin isca huani, “Un rama mau fia. Natian un mau ari capai oincai. Ascacun un mia yoi un ari cayotiromaran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Futsanri yoiqui isca huani, “Un rama moi rafurasi nushua mucu fustiti un fia. Un natian ato yonomapai yonosharacanimainquin un ato oinpai. Ascacun un ari cayotiroma mi futan piishquin,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ascano futsan yoiquiri isca huani, “Un rama ainfo fia. Ascacun un ari cayotiroma mi futan piishquin,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Asca huaifoanno oinmati ahuun ifo ano nasoshon nan yoiafo cuscari yoini. Ascaiton nicai pushu ifo atoqui sinacoinni. Afanan ahuun oinmati nichiqui yoini, “Natian pushurasi anoa faifoti ano cariscatahuun yora ahuuomafo yoifain nipaiqui ranainfo yoifain fushofori yoiriscatahuun un ato pimanon,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Asca huano afanan cashon nan yoia cuscacoin ahuun oinmatinin huashotani oi. Naso cura ahuun ifoqui oshon yoini. “Ifon, mian yoia cuscan mun ato yoia. Ascan natian man fucani. Ascafia min pushu fospicanima. Tushufori tushuiran,” huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pushu ifoan afanan yoini, “Afanan fai futsafo ari cariscatahuun ua ato yoishoshquin funonfo. Ato yoihuu isca huaquin, ‘Uhuun ifoan pushu ano nitutama furiscacahuun mato pimapaiquin,’ ishon ato yoitahuun uhuun pushu fospi funonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nan yorafo un tau huaqui ato pimapaiyafoancai u futan pinacafoma,” ishon pushu ifoan yoiniran, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yorahuanrasi afu foaifoan. Ifiacucahuan ato yoini, ");
INSERT INTO mcdNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tsoan ua finonmacaifain apa yafi ahua non ahuin non ahuun facufo non ahuun yorafo non poifo afiri noiashucai ua tanamisi itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ascan unfin mato ihui coyan iquinanqui nashoshquicain. Ascafia tsoan yoiqui isca huaima, “Natian un Jesús tana. Ascacun nai omitsiscafiaquicai un shinanchacaimaran,” ishon tsoan anori yoicasmai acai ua tanamisi itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nanscarifiai tsoan pushu huapaiquin iquisi shinanyotiro ahuun pui itiromainquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ascano pui iyamaitocai pushu huatiroma. Quishifo fusti nichiano yorafo aqui cashutiofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“¡Cuu! ¡Oincapon! Na nocofunun ahua huatiroma. Ahuun quishifo fusti nichian. Pushu anaitima. Ascaracai sharamaran,” icashu aqui cashutiofo. Nanscarifiai nan man naitian ua tanacahuun. Nan man naitian ua tanapaiyamaquin “Un Jesús tananon,” iyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nanscarifiai niaifo rafu noconain aton ranushumuafo rutunanonfo. Futsa diez mil ranushumuafo aya icaino futsa veinte mil ahuun ranushumuafo ya. Ascacun nan diez mil ranushumua ayaton iquisi fasi shinainyotiro ahuuscamain acanicain. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ascacun afu niaifo tsain fomayotiro isca huaqui, “Non rutunainmaquin. Nanscanon. Min noco rutuyamacun min fipaiyai cuscan mia inantiroran,” icashu raunantirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nanscarifiai ratoranfoan uhuunshon nantifi ahuunafo potayamashucai ua tanamisi itiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ascacun shinancahuun. Sao sharacun non tototiro. Asca sao sharamacai non tototiroma. Chacacun. ");
INSERT INTO mcdNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nanscaracai tsoanshta yopaima. Potacani. Nanscarifi aquin tsoan uhuunshon ua tanasharayamacai uhuun nuusharaima. Chacacoin iqui. Tsoanmain man pafiqui sharayaquin ua nicasharacahuun, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Asca nantiantanri niaifo puifishomisifo yafi yora chaca huamisifo aqui funifo ahuun tsain nicai fucani. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ascaino Fariseofo yafi Moisés cunu tapimamisifo Jesusqui tsain chaca huaquin yoinifo isca huaquin, —¡Oincapon! Jesús yora chacafo fu rafutiro ato futan piaiton, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ascaifoan onanshon Jesús ato yoiqui isca huani ahuara futsa ato tapimanon, ");
INSERT INTO mcdNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ratoran man futsa cien chashoan ayafiano fustishta amaqui funoano atirifi nan noventa y nueve fasi fununun man potayofaintio. A fusti funoa funaiyoicaqui nan man fuchiaitian. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ascano fuchishon unimacain chishtoinifoan man iyafaintiro ahuun pushu ano foi caquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Asca huatan ahuun pushuano nocoshon man atoti chanihuai a chaima icafo yafi afu rafuafo ato cunaqui isca huatiro, “U fu unimai fucahuun. Uhuun chashoan funoa mun fuchiaquin,” ishon man ato yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ascacun un mato yoi nanscarifiai futsan ahuun chaca shatucoianshu afanan ipaoni cuscan atama Dios ifoacoinna oincani nantifi Dios icanoafo fasi unimacoincani. Noventa y nueve yora sharafo nanfocai tsoa Diosqui nasoima manmain tanasharacanashufin. Ascan nanfoqui unimafiacani nan chaca huamisiton Diosin icoinra huanocaifin fasi aqui unimai finacoincaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nanscarifiaiyainfo futsa mucu rafuti toro paratamacoin ahuun pui nuua aya ini. Pushu muran fusti funoni. Ascano lamparina otani ahuun tapa ano matsoyanan funashquin. Ascashon funariaquin fuchini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Fuchishon ahuun yorahuafo yafi a chaima icafo cunashon ato yoiqui isca huani, “Uhuun yorafoan ufu unimacahuun. Uhuun toroshta mun funofiashon natian mun fuchiaran,” ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nanscarifiai tsoan ahuun chaca shatuashma man funoa. Ascafiashon Diosin icoinra huaino Diospan oinmatifo nai murannoashu fasi aqui unimacoincaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Afanan Jesús ato yoiqui ahuara futsa ato tapimaquin isca huani, —Nocofunu futsa facu rafu ya ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ascano chipocuton apa yoini, “Upan, nan naaquin mian inanfainonpacoai natian iquisi ua inanhuun,” huani. Ascaiton apan ahuun pui cashcu futsa ahuun facu chipocu inanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ascano shafa ranan finontan ahuun facu chipocuton nan apa inan cuscan nantifi ahuun rafanan pui fiananan huani. Asca huatan mai futsa chaicoin ari cani. Nanrishon ahuun pui shafatifi potani monocain pauncaiyainfo furomafo fu icai. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Asca huaqui nantifi ahuun pui potaquin anaitini. Ascashon nantianri a mai ano tushu yamacoin ini. Ascashu arifi chipo tushu yamaino fasi fonicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ascano nan mai ariashu nocofunu futsa ano cashon yono yocaqui isca huani, “Un mia yonoshopairan,” ishon yocani. Ascaiton pushu ifoan nichini yahuarasi faasi funununshon pimanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ascashon yahuarasi maropa ahuun shacafo pimani. Ascaino nantian fasi fonicoinquin arifi piqui rashquini. Tsoancai a pimanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ascaquicai nan chaca shinanpaoni cuscan afanan shinanpainima. Nantian cayacafi shinanquin isca huani, “¡Ohua! Uhuun upa ahuun oinmatifoan natian man piisharafo. Aton tushufori man tushu huafo. Asca unfin nunoashu fonicoin naicain. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Asca natian un afanan uhuun Upa ari cai. Nocoshon uhuun upa un yoitiro isca huaquin, ‘Upan, un Dios chaca huafain miari chaca huamisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ascan uncai natian min facu cuscara itiroma. Natian min yonoshomisi cuscara un itiroran,’ ishon uhuun upa un yoishquin.” ");
INSERT INTO mcdNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nannori shinantan apa ari cani. Ascashu caiton chai cunoa apan ahuun facu fuchini. Fuchitan fasi ahuun ramapaicoin aqui ichoni. Aqui nocoshon icoacufoan tsoatoshini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ascaiton apa yoiqui isca huani, “Upan, un Dios chaca huafain miari un chaca huamisi. Asca un afanan natian min facu cuscara itiromaran,” ishon yoifiaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Apan ahuun oinmati yoini, “Ichoriscatahuun. Sahuuti sharacapacoin yafi anio fifain sapatori firiscatahuun. Uhuun facu ua sahuumashoshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ascashon moipan facu shoa sharari ua rutushocahuun uhuun facu un pimanon. Noco sharano non fasi aqui unimanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uhuun facu man naa shinantsa amisishaquin afanan man nasoaquin. Natian afanan ufu nuno nia. Man funofiani natian afanan man non fuchiaquin. Non ichananon nantifi aqui unimaquin pifain non mononon. Noco manutifo non manunon,” ishon apan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ascaino iyoa mau ano yonofaiashu nasoqui pushu chaimashon nicani fasi manuti manuaino monoaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ascaiton nicaquin ahuun oinmati cunashon yocani, “¿Uhuun upa pushu anoshon ahua huacanimun?” ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ahuun oinmatinin yoini, “Min ushto rama nocoano min upa fasi unimacoinquin ato ichanan huaa moipan facu shoa shara ato pimafain manuti manufain ushto ahuuscatama noco sharano unimaquin upa aquiran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ascaiton nicai iyoa fasi sinacoin pushu muran iquinima. Ascaino chifi catan apa ahuun facu iyoa yoini, “Upashtan, pushu muran iquiyopun. Min ushto rama noco sharaquin,” ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cumatama apa yoini, “Shinanpon. Un fari ichapa min oinmati cuscara un mia yonoshomisi. Ascashu min ua yoiai cuscacoin un huamisi. Uncai yoitimamisima. Ascafiacucai mian chashoanun facu rutushomisima uhuun yorafo fu un ichananshon unimaqui un pinon. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Asca min facu chipocu min inan cuscan nantifi man pota. Ainfo furomafo fu iqui. Ascafiashu afanan miqui nocoaino unimaqui min a moipan facu rutushonaran,” apa huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Apan yoini, “Upashtan, miancai potamisima. Min ufu iitiani. Nan uhuunafofin minariquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ascafia min ushto man naa shinantsa amisishaquin natian man noco shara. Man funofiani man non afanan fuchia. ¿Asca ahuuscacumun non ichanainmacain aqui unimashquin?” ishon apan furu iyoa yoini, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ascatan Jesús afu rafuafo yoiquin isca huani, —Nocofunun futsa mafo ichapayaton ahuun oinmati futsa niaifo patashari huani. Ascashon chipo nica ahuun oinmatinin ahuunafo cushusharashocuma. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nicaquin cunashon yocani, “¿Ahuuscai uhuunafo min cushusharamisimamun? Natian min afanan uhuun niaifo patashari iquima. Asca nantifi uhuun cunufo ua nifiafo ati shara huashohuun. Ahuutimain ua nifiafoquin ua ismashquin,” ishon ahuun niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Asca huaiton nicaquin ahuun oinmatinin shinanni, “¡Ai timafin! ¿Unmun natian ahuuscaiquin? Uhuun niaifoan ua pota. Uncai afanan a yonoshonima. Unfin nan papio fusti yonoqui fuya huamisiquin. Uncai curushcain yonotiroma un mau huapanan. Unricai yocacamisi ipaima. Un fasi rafipaitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aira! Natian mun shinanshara. Ratoran futsafoan uhuun niaifo ichapa nifiafo un aton shucashopacufoanni ichapama nifinonfo. Un ascaino uqui unimanonfo. Uhuun niaifoan ua potafiaino nan futsafoan ua shara huatiroforan,” ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ascatan nan niaifo nifiafoti cunani. Ascaino futsa taui aqui ocun yocani, “¿Uhuun niaifo ahuuti min nifiamun?” ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ocho cientos galones de shuni un nifiaran,” huaiton. “Min papio futsaqui ahuu. Cuatro cientos galones de shuni cunuhuu,” ishon niaifoan ahuun oinmatinin futsa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ascaino nan nifian futsari aqui ocun yocani, “¿Uhuun niaifo ahuuti min nifiamun?” ishon yocaiton. “Cien forusa trigo un nifiaran,” huaiton. “Min papio futsaqui ahuu. Ochenta forusa un nifiaran, ishon cunuhuu,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ascano niaifoan ahuun oinmatinin acai cuscan oinquin yoini, “Minfin fasi onaiancoianquin. Min aca cuscan futsafoan mia shara huacaniran,” ishon yoini. Ascan nan icon nan icoinra huamafoan fasi tapicoianfo yorafo parashcaquin. Nanfoan tapia cuscacai nan ua icoinra huafoan tapiafoma. Ascafia nan icoinra huafoancai tsoa parapaitirofoma icocoin fusti yoitirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Un mato yoinon isca huaquin. Man pui ayashon nan Diosin tanamisifo yopaifoan ato inancahuun. Man ato shara huacun mato noinonfo. Ascafia naashucai afanan man pui yopaima man Dios ari nocoaiton nan man pui inannifoan mato yoiqui isca huatirofo, “¡Aicho! Min ua shara huamisi. Natian min nocofu Dios ari nocoa. Noco fu ipahuun,” ishon mato yoitirofo. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ratoran futsa ichapama ayafiashon nanshtahuunshon nan icaiti ahuunshon fisharashori ichapayashon nanscarifi huatiro ahuun fisharaquin. Parashquima. Ascan ichapamayafiashon ahuun rafanan fisharashoma parain. Nanscarifi huaqui ichapayafiashon fasi finacaiqui ahuun rafanan fisharashoma paratiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ascacun nuno mai anoashu man aya cuscan afohuunshon man shara huamaqui man pota. Diosiri mato inanpaiyai cuscacai mato inantiroma. Matoricai icoinra huatiroma. Mato inanpaiyai cuscan nanfori man potatiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nanscarifiai futsana man cushusharayamaiton. Tsoan mato inancointiromun matonacoin inon. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ascano oinmatinincai ahuun ifo nanno rafu nantian yonoshotiroma. Futsa noifain futsa noicasmatiro iyamarai futsa nan yoia cuscacoin huashotiro. Ascashon futsa, “Nacai ahuamaran,” ishon shinantiro. Tapicai huatiroma ratocaimain nicasharaiquin. Nanscarifiai Diosin yonoshopaiquicai man pui noitiroma maton ifo inon, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nan Fariseofoan pui noiaifohuunoa Jesús ato yoiaiton nicacani aqui cashupaiqui yoinifo. —¡Cuu! Ahuuomafiashon noco yoiran, —icaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Onanshon Jesús ato yoini, —“Nafofin sharafoquin” man yorafo huamapaifiaiton Diosin man mato onan. Manfin yorafo paratiroquin “Nafoanfin shara huacaniquin,” ishon yorafo man shinanmapaifiaiton Diosin man mato onancoinshon ahuun nomuran shinain, “Nafoan fasi chaca huacaniran,” ishon Diosin matohuunoa shinain, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Moisés Dioshuunshon cununi cuscan yafi Diosin tsain yoimisifoan cununifo cuscacoin Juan nocoaitian futsafoan mato yoimisi. Juanpan tsain shara futsa noco yoiquin tau huaquin isca huani, “Diospan Furun matoqui chipo oi. Ascacun maton chaca shatucahuun. Man ipaoni cuscan afanan ascayamacahuun. Natian Dios fusti shinancahuun,” mato huamisi. Urifi un mato nannori yoimisi. Asca tsoan ascaran shinancanashu Dios niaifo ari iquitirofo. Nan fusti shinanshu Diospan yora itirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Diosin yonoa Moisés cununi cuscacoinashu non icoinsharanon. Noco yononi cuscaricai non unutiroma ahuara sharafo huaquin. Mai yafi nai cuyotirofiashucai Diospan tsain cuyopacunacama. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ratoran futsan ahuun ahuin unuquin futsan fiishquin man chaca huai ahuun ahuincoinmafu icaino. Ainfon ahuun funu man unuquin futsan fiishquin arifi man chaca huai ahuun funucoinmafu icaiton, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ascashon afanan Jesús ato yoiqui isca huani, —Nocofunu futsa mafo ichapayaton sahuuti mapash sharacoin sahuufain tushu sharacapafo shafatifi pisharamisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Asca futsan ahuun anu Lázaro nocofunu mafo ichapayaton ahuun cunu caincaiti ano tsaoni. Yoratishon coyoashu tsaocun pashnan aqui oshon ahuun coyo ano tashoni. Ascaino Lázaro ahuuomaton shinanni, “Na nocofunu mafo ichapayatomain nan tushu huaa ua inanpainonrati,” ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ascashu Lázaro naani. Naacun Diosin oinmati afu nai muran icafoan ahuun yoshin Dios icari iyonifo. Nannori Abraham ica ini. Ascashu nan mafo ichapayari arifi naacun mai huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ascano omitsiscapanacafo muran cashon nan mafo ichapayaton Abraham yafi Lázaro foisquin oian icafo ini. Arishon chii isin tunuyamacaiquin cunani. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Uhuun Upan, Abraham, uhuun ramapaihuu. Ua Lázaro nichishohuun. Ahuun mutotinin ua ana muchana huanyonon. Un nunoshon chii isin tunuimaquin,” ishon cunaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham cumani, “Upan, min shinainmamun min mai anoashu isharapaoni. Asca Lázarofin omitsiscapaoniquin. Asca natianfin Lázaro man isharaquin fasi unimasharacoinquin. Asca minfin natian fasi omitsiscaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mia ari capaifiaicai non ahuuscashu catiroma. Mirificai min ahuuscashu nuno nocoqui otiroma. Manhuanhuan rafutan noco naquihua. Tsoan finontiromaran,” ishon Abraham yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Afanan cumani, “Upa Abraham, unfin mucu fustiti yora yaquin. Asca Lázaro ato ano nichihuun ato Diosin tsain yoiaiton nicacoinonfo nuriashu omitsiscai futirofoquin,” ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nanfofin man ayafoquin Moisés futan Diosin tsain yoimisifoan cununifo cuscan huafaifin afi ointirofoquin,” Abraham huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ma. Upan, yora naashu funiaton uhuun yorafo yoiaitofin nicatirofoquin. Ahuara chaca huamisifo cuscan shatutiro Dios icoinra huashcaquin,” ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ascan nan Moisés cununi cuscan nicayamafain Diosin tsain yoimisifoan yoiaiton nicayamashomun nan ratoran futsa naashu funiaricai icoinra huatirofomaran,” ishon Abraham yoiniran, —ishon Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Asca huatan Jesús afu rafuafo yoini isca huaquin, —Ahuarafoan mato chaca huamapaifafainshcani. Ascafia nan futsa chaca huamafocaifin fasi omitsiscai finacoinshcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ascashon ua icoinra huafuna futsan chaca huamai nancaifin fasi onaintimaquin finacoinquin. Ascacun chaca huamataima toquiri ya tunushushon noacoin muran potafin shara icuanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Asca oinfain. Tsoan futsa chaca huamaino fasi musucoin. Mi futan tanamisi futsan mia chaca huaiton rauhuahuu afanan mia asca huanonma. Ascashon min yoiaiton nicaquin yoinon isca huaquin, “¡Ohua! Ua rauhuahuu. Un afanan ascaran chaca huanonma,” ishon mia yoiaiton a rauhuahuu. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nan shafata fusti mia chaca huaquin ichapa huafiashon nan chaca huati mia rauhuapairiaiton rau huafafaincahuun, —Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Asca huatan afu rafuafoan Jesús yoinifo, —Ifon, non mia fasi icoinra huapaiquin noco finonmafain icoinra huamahuu, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús ato cumani, —Nan mostaza ushu uhuapamashtacoinfiashu foaicano uhuapacoin yositiro. Nanscarifiai taui man ua icoinra huashon uhuun tsain man tapisharayotiroma. Chipo uhuun tsain maton nomuran man nanucoinshon ihui uhuapa ahuun tapofoya tsucucain “Ununhuan muran pacuhuu,” man huaino a muran afanan fanainacahuan man yoia cuscan atiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ascacun tsain futsa un mato yoinon. ¿Man oinmati yashomun mato maumamaqui oro yamaraquin chashoanfo cushuashu yatashta pushu ano nasoaitomun ahuun ifoan yoitiromun? “Piyohuu,” huatiromun. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma. Ascarama. Asacatamarocon man yoitiro isca huaqui, “Ua pichashoniyohuu. Ascan man icun mian yoitiro un picanon. Mun piqui anaitiano min chipo pitiroran,” ishon man oinmati yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Asca ahuun oinmati nan yoia cuscacoin aino ahuun niaifoan yoitiro “¡Aichoran! Min fasi shara huaran,” ishon yoitiromun? Ma. Afi tau huafaincai acama. Ahuun ifoan yonoa cuscan huaa. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nanscarifiai Diosin mato yonoa cuscacoin aquin marifi yoicahuun isca huaquin, “Noncai ahuama. Nofi tau huafaincai non acama. Nocon Ifoan noco yonoa cuscan non acaran,” ishon yoicahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén ano caaquin Jesús nan fai Samaria yafi Galilea shatsocamun rafu finonfaini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ascashu pushurasi ano nocoano mucu rafuti nocofunufo aton nami tocoi futsuafo aqui noconifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ascatan ato chaima caiton oi ashcafinin cunanifo, —Nocon Ifo Jesús, nocohuun ramapaihuu, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ato oinquin Jesús ato yoini, —Diosin yoimisifo ano fotacahuun. A man cayashara ato ismashcaquin, —ato huaino focani cayariscatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ascaino fustiton mua man caya sharashu afanan Jesusqui naso curan oi ashcafinin yoini, —¡Aicho! Dios shara. Ua cayahua shararan, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ascatan Jesús naman fuopacucahuan, —¡Aicho! Jesús, min ua cayahua. Min fasi sharacoinran, —ishon yoini. Naanfin Samaritanon iniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ascaiton Jesús yoini, —Un mucu rafuti nocofunufo cayahuafia na fustiton ua shinanquin ua yoishara yoa. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ahuuscaimun na nocofunu uhuun caifomafiashu nan fusti uqui nasoa Dios shara huapai futsafo uqui nasoyamafiaino? —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Asca huatan a Jesús yoini, —Funicaitahuun. Min ua icoinra huashufin min cayasharaquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ascano Fariseofoan Jesús yocanifo. —¿Ahuutianmun manifotiton ato niaifo Dios iishquiquin? —ishon yocaifoan. Jesús ato cumaqui isca huani, —Ahuuscashocai Diosin yorafo iquinai cuscan man ointiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ascashu Upa Diosin mato nomuran mato niaifo itiro mato yonoshquin. Ascacucai tsoan yoitiroma isca huaquin, “Diosin niaifo nuno noco mai ano icaraca,” tsoan huatiroma. Futsaricai yoitiroma isca huaquin, “Diosin mai futsaria niaifo icaran,” ishoncai tsoan yoitiroma, —ato yoitan. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A fu rafuafori yoiqui isca huani, —Chipo un mato anoashu matomaqui caano fasi man ua shinancoinquin yoishquin isca huaquin, “Nocon Ifo no fu ipainon. Fasi non oinpaicoinran,” ishon yoifiaquicai man ua oinshquima. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ascano futsafoanri mato yoishqui isca huaquin, “Nanfin Cristoquin. Oa ono icaran,” ishon futsafoan yoiaino futsafoanri, “Nuno icaran,” ishon yoiaifoanno. Ari foyamacain atori tanayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Uficoin un oaiton man ua oinshquin. Caná facaicaiton shafacafi non oinriscatatiro. Nanscarifiai un oaiton shafacafi man oinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ascafiashu taui un fasi omitsiscacoinshquin. Natian nia yorafoancai ua niaifo huapaicanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé niyoano inifo cuscacoinrifiai un afanan oaitian nanscarifi ashcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ascan nantian Dios shinantama pisharafain ayafain fianansharacainaifoanno faitahuan noconi. Nanscasi ariaifoanno. Noé ahuun shashohuan muran iquitapaiyaino oinhuanrasi furiai unuyamacaiyaino faitahuanun nantio manifoti unuhuan marafumuni. Ascaino asai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nanscacoinrifi nan nocofunu Lot niyoano nanscacoinnifo. Dios shinantama pisharafain ayafain inanmitsashon ahuarafo fifain mau fanafain pushu huapaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nanscarifi ariaifoanno Lot Sodoma anoashu caani. Diosin yonoa cuscan. Nantianri Diosin yononi nai murannoashu chihuan atoqui pacunon. Ascaino Sodoma anoafo cuyocoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nanscacoinrifi aashqui un afanan oaitian. Ua shinantama afi apaiyaifo cuscasi huariaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ascan tsoa pushu fomancayan niashucai afanan ahuun pushu muran iquitiroma ahuun ahuara fiishquin. Ascatama ichoriscatahuun. Nanscarifiai tsoacai mau yonofiai afanan pushu ano nasotiroma ahuun sahuuti fiishquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ascacun Lotpan ahuinhuunoa shinancahuun. Naanton ahuun ahuarafosi shinain ifiacucahuan oinpai nariscani cuscan marifi ascayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ascan tsoan shinanqui isca huai, “¡Ohua! Un Jesús tanaiton raca ua omitsisca huacanicati,” ishon shinanquin uhuun tsain cachiquiri huaa. Nanscara yorafo naashu omitsiscapanacafo. Ascan tsoa uhuunoashu omitsiscacai naa. Nanscara yorafofin nacanashu ufu isharapacunacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ascacun un mato yoinon un oaitian yora rafu mosquitero muranfiashu fusti ufu cariscatanaino futsa nitushquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nanscarifiaiyainfo rafu nanincani futsa ufu uari cai yamariscatanaino futsa nituashu omitsiscashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ascaino nantianri nocofunu rafu mau ano yonocani futsa uari cai yamariscatanaino futsa nitushquin omitsiscapanacafo muran caashquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—¿Ifon, raqui focanimun? —ishon yocaifoan. Jesús ato cumaqui isca huani, —Ahuara naa nanno cotocotofo nocoriscatiro. Nanscarifiai un nocoaitian ua tanamisifo uqui furiscatashcaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Afanan Jesús ahuara futsahuunoa ato yoini ato tapimashquin, —Upa Dios unutama cufiriai atsananonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pushurasi futsa aria niaifo ini. Nan niaifo Diosqui ratutama yorafohuunri noinima. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ascafiaino ainfomaqui funu naa aqui oshon yoiriapaoni, “Ua noicasmamisiton ua chaca huaiquin ua yoishohuun ua afanan asca huanonma,” ishon yoifiaino ");
INSERT INTO mcdNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","niaifo ahuun ramapaitama. Puusinima. Asca huafiaino aqui ihuan ihuanpaoni. Ascaiton niaifoan yoini isca huaquin, “¡Cuu! Na ainfo funuoma fasi ua fucash huariai. Uncai Diosqui ratuima. Na ainfohuuricai un ramapaiyamafiaino ");
INSERT INTO mcdNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","fasi ua fucash huariai. Ascacun afanan ua fucash huanonma un aroshoniran,” ishon niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ascano a niaifo chacapan yoini cuscan nicacahuun. Chacafiashon nan ainfo funuoma yoiriaiton man aroshoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Asca Diosicai a niaifo chaca cuscarama. Ascatamarocon fasi noco nicapai. Noco nicaicain atsanatiroma. A catoanfoan shafatishon yafi yamutishon cufiaifo cuscan ato nicacasmaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ascacun un mato yoi nan manamisifo mato aroshoriscatashquin. Ascan nan mato noicasmamisifo onaintimashqui. Ascafia un chipo afanan uhuun Upa Dios icariashu mai ano oaino fustirasiton ua icoinra huacaniraca, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ascan afanan ato ahuara futsa yoini ato tapimashquin, —Unfin sharaquin. Uncai chaca huamisima. Yora futsafo ua cuscaramaran, —ishon shinanmisifohuunoa Jesús ato yoiquin isca huani, ");
INSERT INTO mcdNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Nocofunu rafu Israelifoan Dios fu tsainti pushu muran iquinifo Dios cufishcaquin. Futsan Fariseo icaino futsan niafo pui fishomisi ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nan Fariseo ninacahuan cufiqui isca huani, “Uncai tsoa cuscarama. Unfin nocofunu sharaquin. ¡Aichoran! Upa Diosin, uncai na nocofunu niaifo pui fishomisi cuscarama. Uncai yora chacafo cuscarama. Unricai yomutsoma. Uncai tsoa paratiroma. Unfin yora futsa shara huatiroquin. Uncai uhuun ahuinma furi imisima. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nan semanantifi un piqui tunuquin rafu huafafaini. Nan un fiaishtafin un mia pashcashofafainiquin, Upa Diosin,” ishon Fariseo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ascafiainocai nan niaifo pui fishomisiton anori yoitama. Mananquiri foistamari. Tutipacutsishon shochi sutu sutuaquin yoini, “¡Ohua! Diosin, un mia fasi chaca huamisi. Uhuun ramapaihuu. Un chacaquin,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Un mato cayacafi yoi. Nan pui fishomisi Diosin ahuun chaca soashofain ahuun yora ima. Ascafiaquicai nan Fariseo ahuun chaca soashonima. Ascan tsoan ahuunoa yoiqui isca huai, “Un shararan,” ishon futsafo shinanmapai nanscara yorafo chipo Dios ismashquin arifi chaca huamisicun. Ascan tsoan yoiqui isca huaa, “Unfin chaca huamisiquin,” ishon yoicun nanscara yorafofin Diosin aton chaca soashotiroqui afu ipanonfo, —ishon Jesús huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ascaino yorafoan aton facumishti Jesusqui ihuunifo ato manmanpacuquin Apa Dios cufishonon. Asca huafiaifoan afu rafuafoan ato yoini, —Maton facufo ihuutan nocon Ifo fucash huayamacahuun, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Asca huafiaifoan Jesús facufo cunani, —Uqui fucahuun, —ato huatan afu rafuafo yoini, —Unucahuun uqui funonfo. Ato nitun huayamacahuun. Uhuun Upa Dios niaifo icariafofin nan facumishti cuscaraforiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ascacun un mato icon yoi. Nan facumishtifoan Dios icoinra huacoinnafo cuscan tsoan icoinra huashmacai Dios icari iquinacafomaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ascaino Israelifoan aton niaifo futsa Jesusqui oshon yocaquin isca huani, —Tapimamisiton, minfin sharacoinquin. Ua tapimahuu. ¿Unmun ahuuscatiroquin Dios fu ipashquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús cumani, —¿Ahuuscaquin mian “shararan,” huaimun? Dios fusti sharaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Diosin yononi cuscan man min tapian. Yonoqui isca huani, “Min ahuinma fu iyamahuu. Futsa rutuyamahuu. Ahuara onuyamahuu. Chaniri yoiyamahuu. Ascashon upa yafi uhuari nicasharafain ato shara huahuu,” —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Nantifi mian yoiai cuscan facushon un nicainifoannaran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Afanan Jesús cumaquin, —Fustiricai min nicataima. Nan yoiqui isca huaa. Ahuarafo inanmitsashon ahuun rafanan pui fihuu ahuuomafo inanshquin. Min ascaitofin Upa Diosin nai muranshon mia ahuara sharacoin mucushoniquin. Asca huatan ua tanasharahuu, —ishon Jesús yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nicai puusinima. Mafo ichapayacoinshon ahuun mafofo potacasmai. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ascaiton oinquin Jesús ato yoini, —Yora mafo ichapaya Uhuun Upa Dios niaifo ari nocopaifiacani nocotirofoma. Fustirasifin nocotirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nan ina camellocai acoya shoi muran finontiroma. Mimacaifi nocofunu mafo ichapaya Diosin niaifo ari iquitiromaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ascaiton nicacaquin —¿Ascan tsoa Dios fu nipatiromun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Nocofunucai afinri numamutiroma. Diosin fustitofin yorafo numatiroquin. Diosinfin ahuamamishti huatiroquin. Nocofunufoancai asca huatiroma cuscan Diosin huatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedronun yoini, —Ifon, nonfin nocon ahuarafo nantifi nocon yorafo potafurani mifu non oaquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús afu rafuafo yoiqui isca huani, —Un mato icon yoi. Tsoan Dioshuunshon ahuun pushu yafi ahuin non ahuun yorafo non apa yafi ahua non ahuun facufori potashon ua tanapaisharai. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nanscara yorafofin Upa Diosin finacaiqui ato shara huaiquin. Ascano naashu Dios fu ipasharashcani, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A fu rafuafo doce futsano atotisi iyoni nannoashu atofu tsainquin iscani, —Ua nicacahuun uhuun yoramishtichin. Non Jerusalén ano fononfocahuun. Nan Diosin tsain yoimisifoan uhuunoa cununifo cuscan nanscacoin aiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nannoshon nocon caifoan futsafo ua ato inancani. Nanfoan ua cashu mutsama huafain fasi ua chaca huacani. Uqui cumo michofain fichi cunoqui tuchiaton ua coshacani. Ascatan ua rutucani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ua asca huafiafo osha rafu non fustitan un afanan funiran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ato asca huafiaitocai tsoa tapinima ato yoiai cuscan. Man nicafiaquiricai tapisharanifoma. Diosin ato tapimanataima. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ascaino Jesús Jericó ano nocoataima fusho fai cusumun tsaoa ini. Nannoashu pui yocacamisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ascano nan fai cusumun tsaoshon yorahuanrasi foannaiton nicaquin ato yocani, —¿Tsoafo na iscai foancanimun? ¿Ahua huacanimun? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yoinifo, —Jesús Nazaret anoa cahuaniran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ascaiton nicaquin yoini, —Jesús, minfin David ahuun funaquin. Uhuun ramapaipun, —ishon cunani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ascano Jesús fu foaifoan asca huanifo afanan tsainonma. Asca huafiaifoanno fasi oi ashcafinin yoiriani, —Minfin David ahuun funaquin. Uhuun ramapaipun, —huariaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús nituacucahuan ato yoini, —Nuri ua ihuushocahuun, —ato huaiton aqui ihuunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ascaiton Jesús yocani, —¿Un mia ahua ahuusca huashotiromun? —ishon yocaiton. Cumani, —Ifon, un fasi oinpaicoinran, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ascaiton afanan Jesús cumani, —Ua icoinra huashon natian min oinsharairan, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ascaino nantian oinsharariscatan yoini, —¡Aicho! Man mian caya huaa shara. Dios shararan, —icashu afu caiton oincaquin futsafoan arifi, —¡Aicho! Dios fasi sharacoinran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Asca huatan Jesús Jericó anoashu cahuanaino nanno nocofunu ahuun anu Zaqueo ini. Nantofin ahuun niaifo pui fishomisi iniquin. Pui fishomisi futsafoan aton niaifo ini. Nanrifi ahua yopatanaimacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús yorafoan naqui huano cahuannaiton ahuuscashoma oinpaiquin fuai mishtoshtacoianshu, —¿Ranishomain un oinnanti? —ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ahuuscashoma oinpaiquin ranain. Ascacun rusoatori ichoni finoantaima. Ichotan fai cusumun ihui niahuun ichoinacahuani. Inainacahuatan ahuunshon Jesús cahuanaiton oinshquin icashu inacun. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nan ihui nia naman finonfainquin foisinifoantan fuchishon, Jesús yoini —Zaqueo, fotoriscahuu. Un min pushu ano osha fusti yoi canon, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nicai Zaqueo fotoriscani. Fasi unimasharacoinquin ahuun pushu ano iyoni. —¡Aichoran! Min uhuun pushu ano oiquin. Iquiyohuu, —Zaqueo huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ascaiton oincaquin yorahuanrasiton yoinifo, —¡Ajaa! ¡Oincapon! ¿Ahuuscaimun Jesús yora chacapan ahuun pushu ano caiquin? —icashu afi ranan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ascafiaifoanno Zaqueo Jesús yoini, —Ifon, natiantafin un yora ahuuomafo cashcu futsa un ato inanpacuicain. Nan un finonmafaintan fia cuscan onushori un ato finonmafaintan ato inanpacuiquin. Un diez soles fianshonfin cuarenta soles un ato inainquin. Ascan veinte soles ato fianshonfin ochenta soles un ato inaincain. Un ato onuyofiamisishaquifin un ato asca huapaiquin, —ishon Zaqueo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ascaiton Jesús Zaqueo yoiqui isca huani, —Zaqueo, na shafata min chaca un mia soashona min Diospan facu ica afu nipanonran, —ishon yoini. Ascan nannoa pushu murannoafori ato yoini, —Na nocofunu Zaqueo arifi Abraham ahuun funa. Abraham Dios icoinra huaa cuscan arifi natian icoinra huaa. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ascan tsoa funoa un ato fai shara ismayoi uhuun Upa Dios anoashu un oni nanfo Dios fu ipasharanonforan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nan nicatan focani Jerusalén chaima nocoshon shinanfo, —Nan Diosin niaifo ahuun yorafo iquinai cuscan nocoti chaimaran, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ascaifoan Jesús ahuara futsahuunoa ato yoiqui ato tapimaquin isca huani. —Nocofunu niaifo cuscara ini. Nan nocofunu mai futsa ari caani niaifo huashu afanan naso curashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cataima ahuun oinmatifo mucu rafuti cunashon yoiqui isca huani, “Un mato pui paratamacoin inanfainicai. Nan puihuushon ahuara fiashu inanmitsashon finonmainifoan ahuun rafanan man finon nan un nasoaitian,” ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ascaiton ahuun caifo futsafoan nan noicasmacoinnifo. Ascashu caiton yorafo achon nichinifo. Nan niaifocoin yoiqui isca huanonfo, “Nan nocofunu non niaifo huapaimaran,” huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Asca huafiaifoanno niaifocoinin catoan niaifotan afanan ahuun mai ano naso curani. Ascashu nocotan ahuun oinmatifo cunatoshini ahuuti pui man fiafomainquin tapipaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ascaino futsan aqui oi taushon yoiqui isca huani, “Ifon, mian inan cuscan mucu rafuti finonmainifoan un mia fishoaran,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ascaiton niaifoan yoini, “¡Aicho! Minfin oinmati sharaquin. Mian yonoshon shara. Un mia ichapama inanfia finonmafain mian fishoano un miqui fasi unimai. Un mia yoia cuscacoin min aano. Ascacun pushurasifo mucu rafuti anoafoan ato niaifo min iquiran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ascaino futsanri aqui oshon yoini, “Ifon, mian pui inan cuscan mucu fustiti finonmainifoan un mia fishoaran,” ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nicaquin nanrifi yoini, “Mirifi mucu fustiti pushurasi anoafoan ato niaifo min iquiran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ascaino oinmati futsari aqui oshon arifi yoini, “Ifon, naquian min pui. Un mia rashushon huashoan. Min ua inan cuscan finonmafain fiamafiashucai un funoama. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Un miqui ratuqui un mia mucushona. Mun tapia mincai tsoa shinainma. Minricai nocohuun ramapaima. Non mia yonoshofiaitocai min noco ahua inantiroma. Mina fusti itiroran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ascaiton nicaquin ahuun ifoan yoini, “Min fasi chacacoin. Minfin shanishuniquin. Min tsainhuunshon un mia onaintimai. ¿Min shinanmun un futsafo shinainmaquin? ¿Uaraca futsafoan yonoshofiaiton un ato ahua inanma? Un fimisi ua mian huaa. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ascan nannori shinanfiaquin ahuuscaquin min rashushon huamun? Asca huatamarocon nan pui huamisifoanno min huaa shara icuana paratama finonmainifoan fiishquin,” ishon niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Asca huatan nanno niafo niaifoan ato yoiqui isca huani, “Nan oinmati chaca ahuun pui fiashon nan mucu rafuti finonmainifoan fiarocon inancahuun,” ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Cumanifo “Ifon, nanfin ichapayacaiquin,” huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Afanan niaifoan ato cumani, “Un mato icon yoi. Nan ratoran futsan ua icoinra huacoinafin un fasi paratamacoinri inainqui. Ascan nan ua icoinra huamafin nan ichapama aya cuscan futsa fiainquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ascashon nanfoanfin ua noicasmacaquin yoiafoquin, ‘Noncai mia niaifo huapaimaran,’ ishon uhuunoa yoiafo. Ascacun ato ihuucahuun uhuun ointaifi ato rutushcaquin,” ishon yoiniran, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Asca huatan Jesús Jerusalén ano caino. Achon ahuun tapimisifo fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Machi ahuun anu Olivo tunanman pushurasi rafu Betfagé yafi Betania ini. Nanno chaima noconifo. Nocoshon afu rafua rafu nichini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Pushurasi ano fotacahuun. Nocoshon man burro cahuashara nushucun man fuchicaicain. Tsoacai na burro camaqui cayomisima. Tupushon nuri ua ihuushotacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Futsan mato yocaiton, “¿Ahuuscaquin man burro cahuashara tupuimun?” yocaifoan ato yoiquin. “Nocon Ifo yopaiton non tupuyoaran,” ishon ato yoitacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ato nichiafocatan nococashon Jesús ato yoia cuscan nanscacoin huaquin fuchitoshinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Man tupuafoanno muropan ifofoan ato yocani, —¿Ahuusca huashquimun man nocon burro cahuashara tupuaquin? —anoa ifofoan ato yocani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ascaiton cumacaquin, —Nocon Ifo yopaiton non tupuyoaran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nan burro cahuashara Jesús ihuushonifo. A fu rafuafoan aton sahuuti muropan catu camaqui fucashonafoanno acamaqui Jesús tsaoinifoannifo. Ascaino cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cahuanaiton fai naman cayan afofori sahuuti fucashonifo. Niaifo cahuanaiton apaonifo cuscan Jesusrifi cahuanaiton afofori sahuuti fucashonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Machi Olivo tusirimucaitan ahuunshon tapimisifo aqui noconifo. Unimacaquin oi ashcafinin Jesús yoinifo, —¡Aicho! ¡Diosin shararan! Dioshuunshon ahuamamishti min huaiton non oian. ¡Aicho! Nocon niaifo nocoqui oaquin. Diosin shara huamafafainni. Diosin yononi Jesús nocon Niaifocoin inon. Ahuunshon Diosin nantifi shara huanon. Ascarifiatan ahuun nai oinmatifoan nai muranshon yoicani, “Diosifin sharacoinshon yorafoqui ahuun Furun nichiniquin ato numanon,” man huaicain —ishon oi ashcafinin yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Asca huacatan Fariseofoan yorahuanrasi muranshon Jesús yoini, —Tapimamisiton, minhuunshon tapimisifo yoihuu ascanonfoma, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Un mato yoinon. Ua yoisharayamaifoan na toquirifoan ua oi ashcafinin tsain shara ua yoicuanaforan, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Machi tusirimupacuquin nan pushurasi Jerusalén anoa icafo oin atohuun ramapai Jesús uaini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ascashon yoiquin isca huani, —¡Ohua, Jerusalén icanoafoan! Ua icoinra huashufin man isharapacucuanaquin. Mancai tapiama natian Diospan Facu nocoa. Mancai ua niaifo huapaima. Un mato numapaifiaiton man ua tanacasmai. Natiancai un afanan mato numatiroma. Man fasi finoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Mancai tapiama un mato cushunon Diosin ua catonfiacun, tsoancai mato noicasmamisifoan mato ahuuscara huaiton mato numatiroma. Mato chituacuafo nantia iqui furancatan mato rutuquin anaitishocani. Matofo yafi maton facufo rutuqui cuyoshcani. Maton pushufo paoinquin futsui. Diosin ua matoqui nichifiacun man ua nicacasmaiton mato asca huashcaniran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Asca huatan Jesús Israelifoan Dios fu tsainti pushu muran iquitoshiquin oian a murannoashu ahuarafo inanmitsaifoan fuchitan ato chifi cainmaqui futsani. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ascashon ato yoiqui isca huani, —Diospan tsain cunuquin isca huani, “U fu tsainti pushu muranshon man ua fusti cufitiroran,” ishon cunufianicun nan yomutsofoan ichananti cuscara man huapairan, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Asca huatan shafatifi Israelifoan Dios fu tsainti pushu muranshon Jesús ato yoini. Ascafiaiton nocon yorahuunshon Dios cufimisi niaifofo futan Moisés cununi cuscan tapimamisifo non Israeli niaifo futsafoanri Jesús rutupainifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Asca huafiaifoan ato caifo futsafoan nan Jesús yoiai cuscan nicapaicoinnifo. Ascacucai a rutupaifiaquin tsoan tapinima ahuuscashomain rututirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ascatan shafa futsaino Jesús Israelifoan Dios fu tsainti pushu muranshon ahuun tsain shara ato yoifain ahuuscashumain Dios fu ipatirofoquin ato yoiaino nocon yorafohuunshon Dios cufimisi niaifofo Moisés cununi cuscan tapimamisifo non Dios fu tsainti pushu cushumisifoan Jesús yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Tsoan mia yonoamun min isca huanon? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús ato cumani, —Urifi un mato yocai. ¿Juanpan yorafo unu muran iquimapacuni tsoan yonoa asca huanimun? ");
INSERT INTO mcdNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Diosin iyamarai nocofunufoan yononifomun? —ishon ato yocaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Afi ranan yocanonannifo. —“Diosin Juan nichiniran,” non huaiton Jesús noco yoitiro. “¿Ascan ahuuscaquin man Juan icoinra huamamun?” —noco huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ascan —“Juan nocofunufoan nichiniran,” non huaino yorafo nocoqui sinatirofo. Nantifi yorafoanmain yoimisifocun “Juanpan Diosin tsain yoimisiran,” ishon yoiafo. Ascan “Juan Diospan yonoamaran,” non icaiton toquirifoan noco rututiroforan, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ascashon Jesús yoinifo, —Noncai tapiama tsoanmain Juan yonoaquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús ato yoini, —Urificai un mato yoima tsoanmain ua yonoa un ahuarafo huaiquin —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ascashon Jesús ato ahuara futsan tapimani isca huaquin, —Nocofunu futsan ahuun mau fanafaini mai futsa ari caano. Futsafoan cushushonifo. Nasoshon ahuun fana atirifi pashcashoshquinon. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Fimimisitian mau ifoan ahuun oinmati nichini ahuun fana fimifo fishotanon. Mau cushumisifoan a oinmati sutucashon ahuuoma nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ascashon futsari nichian nanrifi sutunifo. Sutuafono maisi cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ascashon afanan futsari nichini. Nanri nanscari huacashon. Maumamaquishon potanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ascashon mau ifoan shinan futsani, “¿Un ahuusca huaimun? Uhuun facucoin nan un ahuun noiai un nichicai. Nanraca nicacointirofo,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ascano ahuun facucoin mau ano oaiton fuchinifo, “Ahuun facucoin oiquin. Non rutucoinon. Apa naano naafo ahuun facu ifoaiquin. Non rutunoncahuun. Afin aton apa fiama noncairocon non fianon,” ishon yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Asca ocun achicashon mau pasotain iyoshon rutucoinnifo. ¿Asca a mau ifoan nicatamun ahuun facu rutuafo ato ahuusca huaiquin? ");
INSERT INTO mcdNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Oshon mau cushumisifo ato rutuquin anaitishon futsafoan ahuun mau cushumaniran, —ishon Jesús ato yoini. Nicacatan, —Ascanacama ipainonran, —inifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ascaifoan Jesús atosi oinquin ato yocani. —¿Asca ahuuscaquimun Diosin tsain nunori yoiquin? “Pushu yonomisifoan, ‘Ahuun quishi chacaran,’ ishon potafiacun ifoan afanan shara catonshon nichiano pushu onitiro.” Nanscarifiai man Diospan Furun pota. “A chacaran,” huafo. Ascafiacun Diosin man catoan ahuunoashu fustisi yorafo Upa Diosin fu nipatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ratoran futsa a nicacasmaifo omitsiscatiro. Asca ratoran futsanfoan nicacasmariamisicun naitian a omitsiscapanacafo muran potashquinran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nicacanashu Moisés tsain tapimamisifo yafi nocon yorafohuunshon Dios cufimisi niaifofoan Jesús achipainifo cunu muran iquimashcaquin. Atohuunoa yoiaiton nicacani aqui sinanifo. Ascafiashocai a nicapaiyaifoqui musucaquin tsoan achinima. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ascacun nan fuparamitsamisifo Jesús fu foanfafainmisifo ahuun tsain nicapaicani ahuarashta amaquiri yoiaiton ato niaifoqui chanishcaquin Jesús achinonfo. Asca nanfo Jesusqui nichinifo cuncun huaqui yocatanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ascano nanfoan focashon Jesús icon tsainman yocanifo, —Tapimamisiton, ahuara icocoin fusti min noco yoifafainmisi. Nan atirifi min yoiai cuscan nannoricoinrifi min noco yoifafainmisi. Ascashon icon fustisi min nantifi yorafo Diospan tsain yoifafaini. Minricai ahuara yoipai ranomisima. Nantifi min ato cayacafi yoia. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Asca sharamainquin noco yoihuu. ¿Norifimun non Romanonfoan aton niaifo Cesari non pui inainquin? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nan fuparamitsamisifoan yoiaifo cuscan onanshon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ua mato toro fusti ismacahuun, —ato huaiton. Ismaifoan ato yocani, —¿Tsoa ointsa torohuun nuuamun? ¿Tsoan ahuun anuri nuuamun ua yoicahuun? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Niaifo Cesarnaran, —huaifoan. —Ascan Cesarnacun nan inancahuun. Ascan Diosinacuri Dios inancahuun, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nicacani fasi mustairicatan yoinifo, —Nan yoiai cuscacai tsoan tafitiroma. Fasi tapisharacoianran, —icashu ahuun yoinannifo. Ascacucai yorafoan ointaifi, —Jesús amaquiri noco cumaran, —ishon tsoan yoitiroma. Ascashu afanan tsoa puusinima. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ascano nannori Saduceofo ini. Nanfoan shinanquin isca huamisifo, —Yora naashucai afanan funinacamaran, —ishon yoimisifo. Ascan nanfo Jesusqui fucashon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tapimamisiton, Noco shuni Moisés noco cunushoqui isca huani, “Ratoran futsan ahuin futan facu acashma naano afu nanua futsan ahuun facahua fitiro a futan facu aashquin,” ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ascacun un mia yoinon. Siete nanupacuafo ini. Nan iyoacoinnin iyoacaichin ainfo fiqui tau huani. Ascafiashon a futan facu acashma naani. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ascano chipocu futsan arifi ahuun facahua fini. Arifi aqui facu acashma naani. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ascano chipocu futsanri arifi fiini. Nanrifi afutan facu acashma naani. Nanscasiai amaqui nai cuyonifo. Aqui facu acashma. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ascatan ahuun unutani arifi ainfo naani. Facu nanuashma. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ascan ratotocaimun nai muranshon nan yorafo naashu funiaifotian fiishquiquin nan fusti fipashu amaqui nai cuyoafo? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ato cumani, —Yorafo nuno mai ano niyoashu nocofunufo yafi ainfofo fiananmisifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Asca ratoranfoan Diosin tsain icoinra huacun Diosin ato imasharatiro afu ipanonfo. Asca nanfo naashu afanan funiashu Dios icari nocotan afanan fianantirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Afananricai tsoa natiroma. Nanfo Diospan oinmati afu nai muran ica cuscarafo. Ascashu Diospan facufo. Naashu funicatan Dios fu nipanacafo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ascan Moisésirifi noco yoini yora naashu afanan funitiro nipashashquin. Ascashon noco yoiquin isca huani, “Chofo uru manhuain murannoa Diosin oi un nicani. Ua yoiqui isca huaiton, ‘Unfin Abraham non Isaac non Jacob non afoan aton Diosiquin natian ufu niafo,’ ” ishon Moisés yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yora naashu afanan funiyamaino ahuuscashumun Dios fu itirofoquin. Ascafia ascarama. Yora man naafianishaquin afanan nanfofin Dios fu ipatirofoquin. Ascacun Upa Diosifin ato Diosiquin. Diosinafin nantifi niafoquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ascaiton nicacani Moisés cununi cuscan tapimamisifoan yoinifo. —Tapimamisiton, min ato cayacafi yoiran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ascashocai afanan tsoan yocapainima. Ato cumasharaino aqui ranonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ascatan Jesús ato yocani, —Asca ahuuscaimun “Cristo David ahuun funaran,” huamisifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nan Davidcoinin fanainti cunuqui isca huani, “Upa Diosin uhuun Ifo Cristo yoini isca huaquin, ‘Minfin ufu niaifocoinquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mia noicasmaifoan min ato finoncoian. Un ato shatumashquin mia afanan ahuusca huatiroma. Min ato iquiniran,’ ” ishon Diosin yoini cuscan David cununi. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Criston David Ifono ahuuscashucon ahuun funa itiromun? —Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ato asca huatan afu rafuafori ato yoiaiton yora huarasifain arifi nicanifo ato yoiqui isca huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Oinfain. Moisés cununi cuscan tapimamisifoan sahuuti chainipafo sahuusho ato oinmafoanfafaicani fasi tapicoianforan ato huamapaicani. Yora ichaparasi ano foanscacani “Sharacoinforan” ato huamapaicani. “Nanfoan fasi Diosin tsain tapicoianran” ato huanonfo. Ichananti pushu muran iquitan shafacafi tsaotiofo ato oinonfo. Ichananshon piyainfoannori shafacafi tsaopaicani. ");
INSERT INTO mcdNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ascasho ainfomaqui funu naafo parashon pushu ato fiancani. Ascatan fasi chaicoinri cufiriatirofo atohuunoa shinansharanonfo. Ascafia nanfo fasi fuparamitsamisicoinfo. Nanfocaifin Dios ato onaintimaquin finacoinshquiquin, —ishon Jesús afu rafuafo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ato yoitan fuhuunina cahuan Jesús oinni yora mafo ichapayafoan pui ichapa nanuti muran nanuiniyaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Asca huaifoanno ainfo funuoma otan arifi nanuni. Toroshta rafusi a muran nanuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ascashu oiainfoan Jesús ato yoini, —Un mato icon yoi. Na ainfo funuoma ahuuomashtafiashon inancoian. Ahuun toroshta rafu cuyoina. Ascacun na ainfo funuomashta fasi Dioshuun noicoinquin inanshara. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Asca ichapayafoancai Dios inanfiacaquin atirifi tsoan inanqui cuyoafoma tushu huafo. Na ainfoan Dios inain cuscacai ichapa yafoan inansharacoianfoma. Ascafia na ainfo funuoma ahuuomafiashon nantifi ahuun pui man inanquin cuyoina. Man inanqui anaitia afanancai ahuahuunshon ahuun tushu fitiromaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ascano afu rafuafo afiranan yoinancaqui yoinifo, —Nocon Dios fu tsainti pushu toquiri putsamuashu cunuacua fasi sharashtacoin. Yorafoan ahuara sharashta Dios inancoianfo cuscan nutamuacua, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ascaifoan Jesús ato yoini, —Nan man oiain toquiri putsamuashu cunua Dios fu tsainti pushu chipo paoinshquin. Afanancai toquirifo putsamushquimaran, —ishon ato Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ascaiton cumanifo, —Tapimamisiton, ¿Nan min yoiai cuscamun ahuutian iishquiquin? ¿Ahuuscashomun non tapitiroquin a ishquiai cuscan? ¿Diosimun noco ahua futsa ismaiquin non tapinon? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús ato cumani, —Oinfain. Mato parapaicaniqui. Yora ichapafoan, “Un Cristoran,” ishon mato parapaishcani. Ascashon nanfoanri yoishcani, “Un mato yoia cuscan Cristo samamashtacoin oiran,” ishon mato yoiaifoan ato tanayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A man nica yorafo rutunainfoanno ratuyamacahuun. Man nica futsafoan aton niaifo potashu arifi niaifo ipaiyaiton nicai ratuyamacahuun. Nan un yoiaifin nanscacoin aashquiquin. Ascafia nantifi cuyoaitian nocoataima. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iquisi mai futsa fu yorafo rutunainfoanno mani futsafori mani ya futsafori rutunainfoanno. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ascaino mai futsafoari fasi mai nayanaiyaicaino mai futsafoariri yora tushuomafo icaifoanno. Mai futsafoariri pau isininpacoinfoan ishquicani. Ahuara chaca futsa futsatapafo icaino yorafo fasi ratucoinshcani. Nai ari tsoan oinyomisima cuscara oincani fasi ratucoinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ascataima achicashon mato ichananti pushu muran iyoshcani niaifofoan mato yocanon. Ascashon chipo mato cunu muran iquimashcani. Asca huatan niaifo futsafoan ointaifiri afanan mato asca huashcani. Uhuunshofin mato asca huashquicani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mato asca huafiaifoan man ato uhuunoa yoitiro. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ascan man niaifofo ano cataima shinanchacayamacahuun nanfoan matohuunoa tsain chaca yoishcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ascafia unfi mato cayacafi yoimamaicain man ato cumasharanon. Uhuun tsain shara un mato nomuran nanumashquin. Ascano nan mato noicasmaifoan tsoan mato cumayamafain matori tafitirofoma. Ascashori tsoancai anorimaran mato huaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ascashon mato upafo futan uhuafo non mato yoracoinfo non man yorahuan futsafoanri mato achimashon atirifi mato rutumashcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","18","Ascano uhuunshon nantifi yorafoan mato noicasmafiaifoan Upa Diosin mato cushusharafafainshquin. Ascashon mato rutufiafocai ahuashta man funotiroma. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ascan omitsiscafiaquin man ua potama nan man naitian uhuun tsain tanasharashu Upa Dios fu man ipasharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mato noicasmaifo aton ranushumuafoan Jerusalén chituacuaifoan oinquin man tapitiro man samamashta Jerusalén cuyoi. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nanscara oincani Judea mai anoafoan machi ari ichotacahuun Jerusalén anoafomaqui. Patashari icafo Jerusalén muran fuyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nantifi Diosin tsain cununi cuscan Jerusalenhuunoa nanscacoin aiquin. Nantian Jerusalén anoafo Diosin ato onaintimai. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ascacun ohua. Ainfo facu nanuafo yafi aton facu yomumishti shoma acaifoya nantifi Israel anoafo fasi omitsiscaashcani. Yora futsafo fasi atoqui sinacoincaquin ato asca huashcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ato rutufain atirifi achicashon mai futsafoari ato nichishcani. Ato asca huatan a Israelifoma Jerusalén ano iyoshcani. Nan Diosin ato nasopaiyaitian Israelifo afanan Jerusalén ano fushcani. Yora futsafo afanan aton niaifo inonma. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ascaino nantianri fari yafi oshu non fishifo nan imisima cuscain futsushcani. Ascaiton nuno mai anoafoan oincani fasi ratucoincaquin yoishcani, “¿Ahuuscaimun unuhuan fasi fuchoaino ahuun oi achacoinquin? Noncai iscara oinyomisimaran,” icashu ratucani afiranan yocanonanshcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ascaiton oincani yorafo ato ratupan naiyoshcani. Nai ari yafi mai ano ahuara chacafo tsoan oinyomisima cuscarafo oincani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ascaifoanno nantianri un nai ariashu coin camaqui mai ano fotoshquin. Ascaiton nantifiton ua oinshcani. Un Diospan facuashu uhuun curushhuunoashu un fotoaiton ua oinshcani. Un nantifi iquinai cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ascacun nan un mato yoiai cuscacoin tau aino nan ua icoinra huafo unimacain ua manasharayanan itisharacahuun. Nanscacoin aino un matoqui oti chaimaquin mato numayoi, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ascashon afanan ato yoiqui isca huani, —Nan fana higuera yafi nii futsafohuunoari shinancahuun. Nanhuunshon mato ahuara futsa tapimanon. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nan nii pui risquisi futsuaiton man tapitiro manmain fariaitonfin. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nanscarifiai nan un mato yoiai cuscacoin aiton tapicahuun Diosin niaifoan ahuun yorafo iquinai cuscan man nocoti chaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ascacun un mato icon yoi. Ahuarafo un mato yoiai cuscacoin aiton nataishoma oinyoshcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ascaino nai yafi mai cuyoshqui. Uhuun tsain cayacafi iconcoin. Fiananancai apanacama. Un mato yoiai cuscacoin aashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ascacun oinfain. Un matoqui nocoriscatashquin. Man itisharayamano ahuarafo ahuuscarai futsui. Ascacun ahuara chaca huayamacahuun. Paunyanan monofafainyamacahuun. “¡Ohua! Un ahuuscarairan,” ishon shinanfafaiyamacahuun. Nanscafin nan ua icoinra huamafofo aaquin. Afo itisharafomano un nocoriscatashquin. Afo icai cuscan ayamacahuun. Oinfain. Masharo nicatsashu cunu muran iquitiro cuscan ayamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ahuarafo ahuuscarai futsuaino nan maitio omitsiscai futsushcani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ascacun itisharayanan Upa Dios cufifafaincahuun omitsiscaitian ahuun curushhuunshon mato amapaiyai cuscacoin huashcaquin. Ascashu man chipo uqui nocoaitian un matoqui unimatiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ascatan shafatifi Israelifoan Dios fu tsainti pushu muranshon ato yoini. Yamutifi machi ahuun anu Olivo ano oshani. ");
INSERT INTO mcdNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Funamanritifi aqui fupaonifo Dios fu tsainti pushu muranshon nicashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nan noco caifo Israelifoan ato fusititian shinanpaonifo Diosin nai oinmati ato facu iyoafofosi finonmani rutuquima. Ascan nan fusiti shafa anunifo pan farashati maisiran ishon anunifo man nocoti chaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ascan nantianri nocon yorafohuunshon Dios cufimisi niaifofo yafi Moisés cununi cuscan tapimamisifo ichanancashon shinanqui isca huanifo, —¿Ahuuscashomun non Jesús ato rutumatiroquin? ¿Ahuara chaca ahuunoa non yoitiro ato rutumashquin? Non cashman rutuaino yorafo fasi mucacani noco raca asca huatirofo, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ascaino nantianri Judaspan ahuun nomuran Satanás shinanchacamariscatani. Nan Judaspan ahuun anu futsa Iscariote nanrifi Jesús fu rafua futsa ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ascashu niaifofo ano cani atofu tsainquicai. Ascano cashon ato yoini, —Unmun ahuuscashon Jesús ato achimatiroquin matoqui ihuunonfo, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nicacani fasi unimacoincaqui yoinifo, —¡Aicho! Non mia pui inain min noco Jesús ato achimashocun, —ishon Judas yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ato cumani, —Ai. Man ua yoia cuscan un mato Jesús achishotiroran, —ishon yoini. Ascacun nantian Judaspan shinanni ahuuscashomain un Jesús ato achishotiroquin. Yorahuanrasi yamaino achimapai. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Asca noco fusititian non misi farashati maisi pimisi. Diospan nai oinmatinin nocon shunifoan ato facufo rututamarocon Diosin ato yononi cuscan chashoanun facufo rutunifo. Ascacun nocon fusititian norifi chashoanun facu rutumisi nocon shunifoan ani cuscan shinanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ascacun Jesús Pedro yafi Juan nichiqui ato yoini isca huaquin, —Itishara huatacahuun. Non chashoanun facu picanon, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Cumanifo, —¿Rato pushu muran caashon non ati shara huaicaimun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ato cumani, —Jerusalén ano nocoshon man oian nocofunun unu tutsaomushon foaiton nan mufaitacahuun. Ascashu nan iquiaino afu iquifainshon pushu ifo man yoiqui isca huatiro, ");
INSERT INTO mcdNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“Nocon tapimamisiton mia yocaqui isca huaa, ‘¿Rato cunu muranshon ufu rafuafo futan non chashoanun facu picaimun?’ ” ishon man yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mato cunu uhuapa fomancayan ismai. Nan cunu muranfin nan non yopaiti mato ismaiquin. Nannoshon atishara huacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ascaino nan rafu Jerusalén ano focashon nan Jesús ato yoia cuscacoin oinnifo. Nannoshon chashoanun facu pichashonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ascashon man itishara huashoafono Jesús yafi afu rafuafo ari fonifo. Nococatan nantifi sapa ano tsaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ascashu tsaoafoan Jesús ato yoini, —Un matomaqui nataima un fasi mato futan chashoanun facu piiyopaimisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ascacun un mato iquisi icon yoiyoi uncai afanan mato futan piiyoima. Nan man Upa Dios niaifoan nantifi iquina ano nocoaitian yafi natian un acai cuscan ahuu cuscaramainquin man tapishquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ascatan cucho finifoan Apa Dios cufiyoni, —¡Aicho! Upan —huatan. Ato cucho inanqui yoini, —Ayapacucahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Un afanan mato futan na fimi unu ayaima nan un nasoaitian uhuun Upa Dios fu nantifiton niaifo un iishquiran, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Asca huatan Jesús misi finifoan afanan Apa cufiyoni, —¡Aicho! Upan, —huatan. Torupacushon atoti inanqui afanan ato yoini, —Naafin uhuun caya cuscaraquin. Un nantifi yorafohuunoashu nai. Ascacun nan man piaitian ua shinanfafaicahuun, —ishon ato yoitan. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nanscarifi huaquin cucho finifoantan ato ayamapacuquin yoini, —Na ayatihuunshon un mato ahuara funa shara yoi isca huaquin, “Uhuun imi foaino un matohuunoashu nai man ufu uhuun Upa Dios ari ipanon,” —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ascashon Jesús afu rafuafo yoiqui isca huani, —Nuno ufu sapa ano tsaoan futsan ua ato achimai. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ascan Upa Diosin tsain inon pacoai uhuunoa cununi cuscacoinfin un naicain. Ascafia nan nocofunun ua ato achimanai cainyamanifin shara icuanaquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ascaiton nicacani afu rafuafo yocanonannifo, —¿Rato futsacaimun non achimaiquin? —icashu afi ranan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ascatan rato futsacaimun fasi finoinnifoan niaifocoin ishquiquin icashu fochishmanantanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ascaifoan Jesús ato yoini, —Nan icoinra huama niaifofoan ato curushcain yonofafainmisifo. Ato asca huafiacaquin yoimisifo, “ ‘Noco shara huashofafainmisiforan,’ ishon nocohuunoa yoicahuun,” ato huamisifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Asca huafiamisifo marifi ato cuscara iyamacahuun. Ascatamarocon facu pushco cuscara icahuun. Nanfo nan iyofofoan ato yonoafo cuscan ato ashotirofo. Ascatari niaifopaicaquin futsafo shara huacahuun. Asca nan mato shara huafafainmisi nanfin niaifo iishquiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ascan ratotocaimun futsafo finoanquin? ¿Futsafo yonomafafainmisi iyamarai ato yonoshomisi? Nan icoinra huamafoan yoimisifo nan yonomitsamisitocaifin futsafo finoanquin ishon yoimisifo. Anori yoifiafo uncaifin mato yonoshomisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ascafia ahuara chacafo finonfiaqui man ua potama. Man uhuun nuua. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ascacun uhuun Upa Diosin ua catoan un afu niaifo inon. Nanscarifi aquin un mato catoan man ufu niaifo inon. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ascano un mato yoiai cuscan un niaifoanno marifi man ufu niaifofo iishqui. Nocon Upa Dios ari man ichanaintian marifi man ufu tsaoshquin. U futan pifain man ufutan ayashquin. Ascashu nocon caifo Israelifoan aton niaifofo man iishquin. Nan doce shoco noco caifofoan ato niaifo man ishquiran, —ishon Jesús afu rafuafo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Asca huatan Jesús Pedro nan ahuun anu futsa Simón yoini, —Simón, Satanás Dios yocashon mia chaca huamapai. Umaqui mia imapaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ascafia un mia Upa Dios cufishona min ua icoinra huafain afanan ua tanasharanon. Ascan min afanan uqui nasoaino ufu rafua futsafori min ato yoisharatiro ua tanasharanonfo, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedronun cumani, —Ifon, mia cunu muran iquimanaifoanno urifi un mifu iquitiro. Ascashon mia rutuaifoannori urifi un mifu natiroran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Afanan yoini, —Pedro, un mia yoi. Tacara cuoataima min ato yoiquin, “Un Jesús oimisimaran,” ishon min ato yoiqui rafu non fusti huairan, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Asca huatan Jesús ato yocani, —¿Un mato nichiyamuatian pui non forusa non sapato futsan maisi nichiano man ahuara futsari yopaiyamuamun? —ishon ato yocaiton. Cumanifo, —Noncai ahuara futsa afanan yopayamuama, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Asca natian pui ayashon mato pui fofain maton forusari fotacahuun. Asca nopu yopaquin maton sahuuti shochiquirinoa futsahuunshon nopu ficahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ascacun uhuunoa cununifo isca huaquin, “Arifi yoicaquin ‘man chaca huamisiran,’ huashquicani,” ishon uhuunoa cununi. Uhuunoa icon yoiamafiaquin nan icocoin yoi cafisca huaafo. Ascano uquin cununi cuscan samamashtacoin aiquin, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A fu rafuafoan yoinifo, —Oinpon. Na nopu rafu, Ifon, —huaifoan. —Un mato yoipaiyai cuscacai man tapiama. Ascacun non afanan aya tsainquimaquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nan camisi cuscan machi Olivo ano caino afu rafuafo achon fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nanno nocoshon ato yoini, —Upa cuficahuun Satanás mato chaca huamapaiyai cuscan huashcaquima. Ascacun ua potashcaquima cuficahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ato asca huatan chaimashta atomaqui caashon Apa cufinquin isca huani ahuun ratoconun mai chachipacufoan Apa cufini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Upan, min ahuara futsa yorafo numashqui atiromamainquin nan min apaiyai cuscan huahuu. Unfi mun itisharaquin atohuunoashu omitsiscacai naashquin, —Apa huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ahuun oinmati afu nai muran ica aqui niriscatan mutsismainifoanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Asca huaino fasi curushcain Jesús Apa cufini fasi ahuun nomuran nan omitsiscai cuscan shinanquin. Ascaino imi foya niscan maiiqui futosomuni. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ascacaini afanan afu rafuafo ano caaquin oian man oshafo ini. Fasi aton Ifon omitsiscaiton shinancani oshafainnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Atoqui nocoshon oian oshafoan ato yoini, —Ahuuscain Upa cufitama man oshariai. Ascaquima Upa cuficahuun yoshin chacapan mato chaca huamapaiyai cuscan huashcaquima. Ua potashquimari cuficahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nan ato yoiai muran yorahuanrasi nocotoshinifo. Nan afu rafumisi futsa Judascaifin rufofo oaino acho yora huanrasi funiquin. Nocotan Judaspan tamo tsoacatoshini. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ascaiton Jesús Judas yoini, —¿Judas, nan Diosin ua catoancaimun ua tamoqui tsoacaihuunshon mian ato achimaicai? —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Asca huaiton oincaquin afu rafuafoan Jesús yocanifo, —¿Ifon, non ato nopu rurapacutiromun? —ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Asca huatan futsan nopu fifaitan nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun oinmati pashtufain rurani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ascaiton Jesús yoini, —Unuhuu, —huatan afanan ahuun pafiqui funa futsa panichirishcatani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ascashon Jesús nocon yorafohuunshon Dios cufimisi niaifofo yafi ranushumuafo yafi Dios fu tsainti pushu cushumisifo yocani, —¿Ahuuscai nopu yafi coshatifo ya man uqui fuamun? ");
INSERT INTO mcdNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Shafatifi Dios fu tsainti pushu muran un matofu icanocai man ua achipaiti huama. Asca na yamu man uqui fua Satanás maton ifoanno, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ascafiaiton achicashon nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun pushu ano iyonifo. Ascaino chipo achon Pedro cafiaquin fishtanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Umainti chii cutuhuashu yooaifoanno Pedrori atofu yooni. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ascaiton niaifoan ahuun oinmati shomayaton Pedro fuchini. Chii uruquin fuchashaiton ahuun fuso onanshon yoini, —Naafin nan Jesús fu imisiquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedronun cumani, —Ma, ainfon. Uncai Jesús oinmisima, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Man ascano futsanri afanan onanshon yoini, —Minfin nan Jesús fu imisi futsaquin, —huaiton. —Ma. Unmafinquin, —Pedronun huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Man ascano chipo afanan futsanri onanshon yoini, —Nancoinfinquin. Jesús fu cahuacacaimisi. Nanrifi Galilea anoaran, —ishon nocofunu futsan yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—Min yoiai cuscacai un tapiama. Uncai Jesús oinmisimaran, —itapaiyaino tacara cuoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nanscatanaino ifiacucahuan Jesús Pedro fuistani. Fuistanaiton nan Ifoan yoia cuscan shinanriscatani, —Tacara cuoataima min yoiquin rafu non fusti huai, “Un Jesús oinmisimaran,” —Jesús huacun Pedro shinantani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Umaintinoashu chifi caicaintan fasi uaicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ascaino nan cushuafo Jesusqui cashu mutsamai taunifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ascano fufoposhon sutucashon yocanifo, —¿Mia tsoan acamainquin? Oinyamafiashon noco yoihuu, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Asca huashon roaqui futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Shafatapaiyaino Israelifoan niaifofosi nan yorafohuunshon Dios cufimisi niaifofo non Moisés cununi cuscan tapimamisifoan ichanannifo atoqui Jesús iyoafoan yocashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ascashon atoqui iyoafoan yocanifo, —¿Minmun Criston? ¿Diosin mia catonni? Noco yoihuu, —ishon niaifofoan yocaiton. Jesús ato cumani —Un mato, “Ai,” huaitocai man ua icoinra huaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ascashon un mato yocaitoricai man ua cumaima. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ascacun natian yafi nantishon tapiquin uhuun Upa Diosin ahuamamishti huatiro futan un nantifi ato iquipacunacaran, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Afanan yocanifo, —¿Ascan minmun Diospan facu? —ishon yocaifoan. —Nan man yocain cuscafin unquin, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ascaiton nicacaquin yoinifo, —Nicacapon. Afanancai ahuunoa tsain chaca huaifoan non yopaima. Naan yoiai cuscan noficoin man non nicairan, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ascatan Israeli niaifofoan Jesús aton niaifocoin shinanmaqui iyonifo. Nan Pilato niaifofin Romanonfoan ato niaifo iniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ascano niaifofoan Jesús tsain paranacaquin yoinifo, —Na nocofunun fasi noco yorafo fucash huaquin ato yoia, “Romanon niaifoan mato pui yocaiton inanyamacahuun,” ishon yoifain “Un Diospan facu un mato niaiforan,” noco huaran, —ishon Pilato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ascaiton Pilatonun yocani, —¿Minmun Israelifoan niaifo? —ishon yocaiton. Jesús cumani, —Nan mian yoiai cuscafin unquin, —huani ");
INSERT INTO mcdNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ascaino Pilato nocon yorafohuunshon Dios cufimisi niaifofo yafi nanno nia futsafo ato yoini, —Na nocofununcai ahuara chaca yoima. Ahuashtacai ahuun nuama non iquimanai, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ascafiaiton fasi curushcain cumanifo, —Na nocofununfin ato yoiquin Judea maitio fasi ato fucash huafoanfafaini. “Romanonfoan niaifo non potanon,” ishon yoiaquin. Tau huaqui Galilea anoafo yoiqui fucash huatan nunorifi man oaran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ascaifoan nicaquin Pilato afanan ato yocani, —¿Na nocofunumun Galilea anoa? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Aifain, —huaifoan. —Asca un Herodesqui Jesús nichinonquin. Nan Galilea anoa niaifoquin. Ahuuscamain huaicai afi noco yoinon, —ishon Pilato yoini. Nantianri Herodes arifi Jerusalén ano oni. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesús aqui nocoaiton fuchitan Herodes unimacoinni. Fasi oinpaimisishaquin. —Ahuamamishti noco ismapainonran, —ishon ahuun nomuran shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ascashon fasi ahuarafo Jesús yocapaifiaitocai cumanima. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ascaino nocon yorafohuunshon Dios cufimisi niaifofo yafi Moisés cununi cuscan tapimamisifo Herodesqui fasi chanirianifo chaca huacaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ascaino Herodes futan ahuun ranushumuafoanri fasi cashumutsama huaquin roarianifo. Niaifoan sahuuti sahuumatan Pilato ano afanan nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato fu Herodes shara huantananyamafiamisishaquin nantian shara huantanannifo. Jesús achicanisi raunannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ascacun Pilato afanan ato cunani. Nocon yorafohuunshon Dios cufimisi niaifofo yafi niaifofo futsafori ichanan huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ascano ato ichanan huashon ato yoini, —Man uqui na nocofunu ihuua. Man ua yoia naton yorafo tsain chaca yosian Romanonfoan aton niaifo non potanon, icaran ishon man ua yoia. Ascafiacai ascarama. Maton ointaifi un yocafiaitocai man ua yoiai cuscan ua cumaqui chaca huama. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesricai ahuunoa ahua chaca nicama nan man yoiai cuscan. Ascacun Herodes nocoqui afanan Jesús nichian. Na nocofununcai ahua chaca huamafinquin naashquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ascacun un onaintimaiyoi catanon, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Ascaino mucainifoannifo. —Na nocofunu rutuhuu. Barrabás noco cainmashohuun, —huaifoan. Fuusititiansi Pilato a cunu muran iquiafo fusti ato caimapaoni. Faritifi nan yorafoan cainmapaiyaifo Pilaton ato cainmashopaoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nan Barrabasfin yora rutumisi iniquin. Nantori yoini, —Romanonfoan niaifo non potanon, —ishon yorafo yoini. Ascaiton cunu muran iquimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ascaifoan afanan Pilatonun ato yoini Jesús nichipaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ascafiaino afanan mucainifoan yoinifo, —Mastahuun, —huarianifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ascaifoan afanan Pilato ato yoini, —Ahuuscacufin. Ahuacai chaca huamafinquin. Ahuashtacai chaca huatananma napanan. Unfin onaintimashon nichiqui catanon, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ascafiaino oi ashcafinin, —Mastahuun, —huarianifo. Yoiquin unuyamacaiyaifoan Pilato shinantani ascaiton, —Mafin acahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Man fasi yoiriaicai asca nan man apaiyai cuscan huacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nan Barrabás yora rutufain niaifo potapaifiamisicun nancai cunu murannoa cainmafain Jesusrocon ato inanni nan apaiyaifo cuscan huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesús iyocaquin oianfo Simón pushurasi patasharinoashu oaiton fuchitan Simón Cirene anoa yononifo, —Ihui coyan iquinan noco foshoicahuun, —ishon iyamafainifo. Jesús rucucaino achon iyashon foni. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ascaino yorahuanrasifo ya ainfofori achon fonifo. Nan ainfofo uaifonifo aton Ifo manocani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ascaifoan ifiacucahuan Jesús ato yoini, —Jerusalén anoa ainfofoan, uhuunoashu uaiyamacahuun. Mafiri uaicain maton facufohuunoashu uaicahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Manfin chipo omitsiscaquin yoishquiquin isca huaquin, “Non facuomafofi shara icuanaquin no fu omitsiscanonfomaran,” ishon man yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Machi nocoqui maocoano non nai futsuafin shara itiroquin. Omitsiscashquima,” ishon nannori man yoishqui. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Un ahua chaca huayamafiamisicun ua isca huacani. Ascan tsoan ahuara chaca huaquin unuyamacaiyaifofin fasi finacaicani omitsiscamashcaniquin, —ishon Jesús ato yoini. Ascashon Jesús iyonifo mastaifocaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ascashon yomutso rafuri iyonifo Jesús ya mastaifocaquin ");
INSERT INTO mcdNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ascatan anoshon mastaifoanno noconifo. Nanno ahuun anu mapo shao ini. Nannoshon Jesús mastanifo. Ascashon nocofunu chaca rafuri ocuma futsa futsafain ocuma futsari futsa mastanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ascashon mastaifoan Jesús Apa cufini, —Upan, ato rau huahuu. Ua isca huaifo cuscan tsoan tapiamaquin. Un min facufiacun tapiafoma, —ishon Jesús apa cufini. Mastacatan ahuun sahuuti pashcananshcaquin. Aya cashuti ya cashunifo nan finonmanaton ahuun sahuuti fiqui tau huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nanno yorahuanrasi mapo cashon oinnifo. Ascashon niaifofoanri roaqui futsacaquin yonifo, —Non oinon. Futsafo numamisi cuscamain afiri numaiquin nan Diosin catonni Cristo huashuforan afiri numaicain futsafo numamisi cuscan, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ascaino ranushumuafo aqui cashupainifo. Fimi unu focashcoin muran mishan pocotan inanpaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ranushumuafoan yoinifo, —Minmain Israelifoan niaifoquin mifiri numahuu, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ascashon ahuun mapo manaonri aqui cununifo. ISRAELIFOAN NIAIFORAN ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ascaino afu masta futsan Jesusqui tsain chaca huani. —Minmain Cristoqui mifiri numacain nocori numahuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A fu masta futsan yoini, —Asca huayamahuu. ¿Minmun Diosqui ratuimacai? ");
INSERT INTO mcdNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Non chaca huamisicufin noco mastafoquin. Asca Jesuscai ahua chaca huayamafiamisicun mastaforan, —ishon futsan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ascashon nantori yoini, —Ifon, Dios niaifo ari nocoshon ua shinanhuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús cumani, —Icon un mia yoi. Na shafatan min ufu ari iquicaiquin. Nanno fasi sharacoin. Min ufu unimacoin sharapacunacaran, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Asca huatanaino fari masafinin racafiashu nan maitio faquishpacucahuani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ascainocai fari chashayonima. Ascashu man fari caino afanan shafani. Ascaino nantianri Dios fu tsainti pushu murannoa Dioshuunoashu panomanhuan pochimua aficoin nushmancayan fashnupacucahuani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ascaino Jesús Apa cunainifoanni oi ashcafinin, —Upan, miari ua ihuicoinhuun, —huatan shacaica unufaini naani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ascaiton ranushumua niaifoan yoiquin. —Icocoinfinquin na nocofununcai ahua chaca huayomisima. Fasi sharacoin. Nan non oian cuscan nantifi Diosin acaran, —ishon ranushumua niaifoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ascaiton oincani fasi manocoincani fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ascaiton ahuun yorahuafo yafi nan ainfofo Galilea anoashu afu foafoan chai nishon oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nannori nocofunun ahuun anu José Israelifoan aton niaifo ini. Nan nocofununfin Dios tanasharapaicoinniquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nantoricai niaifo futsafoan shinainfo cuscan shinannima. A niaifofin Arimatea mai anoa iniquin. Arimatea nan pushurasi Judea muran ini. Nantorifi Cristo nan Diosin catoan manapaoni aton niaifo inon. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ascashu cashon José Pilato yocani. —Un Jesús ahuun caya toquirininhuan quini muran mai huapairan, —ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ascano yocafaini cashon a ihui coyan iquinanqui mastafo fotomapacufoan ahuun yoratishon racoshon toquirininhuan quini muran mai huani. Jesús naataima quini puhuunifo nan murancai tsoa maiyomisima muran Jesús mai huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tunutitian man nococuanaino Jesús mai huani. Nan shafatan itishara huamisifotian ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ascaino nan Galilea anoashu ainfofo Jesús fu fuitafoan José Jesús mai huaiton oinshcaquin mufainifo. Ahuuscashomain rataicain oinsharanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ascashu nan ainfofo afanan aton pushu ano nasofainifo. Ininti shara itishara huai focani. Unupa yafi mutopa inin shara fii focani fonifo. Jesús ahuun caya camaqui ocashcaquin. Ascafiaino tunutitian nasoyonifoma. Finonyocani. Israelifoan yononi cuscan tunutitian tsoa raqui cayotiroma ini. Ascacun nan nicacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Israelifoan tunutitian iyoco futsaino funamanrishta aton ininti rafu ya Jesús maia ano fonifo. Iquisi ininti ati shara huafaincani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nococaquin oianfo quini ahuun fupoita toquirininhuan tocoro man fupucua ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ascaino iquifainpaiquin oianfo aton Ifo Jesús ahuun cayacai ano inima. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ascaiton oinquin aton nomuran shinannifo, —¿Raquimun ahuun caya foafoquin? —ishon shinanpaiyaifoanno nocofunu rafu ato sahuutifoya chashatanaino atoqui niriscatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ascaino ainfofo fasi ratucoincani fuoi futsunifo. Ascaifoan Diospan oinmati rafutan ato yoini, —¿Ahuuscaquimun yora nia man funaicain nan yora naacun mai huamisifo murannoa? ");
INSERT INTO mcdNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Afanancai nunomafinquin. Manfin funiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","¿Galilea ano matofu iyoshon mato yoimisimun man shinainmacai? Mato yoimisi isca huaquin, “Chacafoan ua achishon ua mastafo un naafiashu osha rafu non fusti finontan un afanan funishquiran,” mato huamisi nanmun man shinainmacai, —ishon ato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ascaiton nan Jesús ato yoimisi cuscan shinanriscatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ascatan ainfofo nasofaincani nan once nocofunufo Jesús fu rafumisifoquin chanitoshinifo. Nannoa futsaforifi nan rama oinfainafo cuscacoin ato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nanfofin María Magdalena non Juana non Santiago ahua María non ainfo futsafori nanfo atoqui chanitoshinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ascafiaifoancai ato icoinra huanifoma. —Icon yoicanimaran, —ato huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ascaiton nicafaini Pedro ichoni toquirinin huaa quini muran oincai. Nocotan tucupacucahuan quini naisquin oian ahuun racoita fusti nanno mania ini. Ascaino Pedro —¿Ahuuscamun aaquin? —icaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nan shafatanri Jesús tanamisi rafu pushurasi Emaús ano fonifo. Emaús Jerusalén chaima ini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nan rafu focaquin Jesús aquitafo cuscan afi rafu yoinanfonifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ascaifoanno Jesuscoin afanan atoqui nocotan. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ato fu cafiaitocai tsoan onannima. Diosin ato onantima huaino. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ascaiton Jesús afincoin ato yocani, —¿Nocofunu rafutan, raquiri man yoinanfoi caimun? —ato huaino. Pusitama nituriscatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ascaiton naan Cleofas fustiton cumani, —Mirus fusti Jerusalén ano min icatoracafin min tapiamaquin na rama iquitan cuscan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Ahua ahuuscaitamun? —ishon ato yocaiton. —Jesús Nazaret anoaya non tsainquin. Nanfin Diosin tsain yoimisiquin. Diosin ahuun curushhuunshon noco yoimisi. Dioshuunshon ahuamamishti noco huashomisi. Ahuun tsainman yora caya huafain ahuara sharafo noco huashomisi. Nan acai cuscan nantifi man non oian. Diosin yafi nantifi man non oian. Nocofunu sharacoinfin non oinmisi. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ascafiaiton nocon yorafohuunshon Dios cufimisi niaifofo non nocon niaifofoan achicashon mastaitafo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Nancairocon nocon caifo Israelifo nocon Numamisi ipainonran,” non huamisi. Asca natian man naita shafa rafu non fusti man finoan. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na funamanri ainfofoan no fu focashon man funatanafo ahuun caya quini muran yamaiton. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ascashon naso furan noco yoiafo ahuun caya anocuma. “Ahuun oinmati afu nai muran ica rafutan yoiafo Jesús man afanan niaran,” noco huafo. Ascacun non shinan “¿Ahuuscamun aaquin?” ishon. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ascaino nocomaquinoashu rafu ichocashon oiancai ano Jesús ahuun caya icama. Naan ainfofoan yoiafo cuscan iconcoinran, —ishon non yoia. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ascaifoan ato yoiqui isca huani, —¡Ohua! Manfin tatimacoinfoquin. Diosin tsain yoimisifoan yoinifo cuscan mancai icoinra huacuanama. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Man cununi isca huaquin, “Diosin yonoa nan catoan Cristo omitsiscayotan. Apa Dios fu niaifocoin iishquiran,” icashon ahuunoa cununiran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ascacun tau huaquin ahuunoa Moisés cununi cuscan yoifain Diosin tsain yoimisifoanri ahuunoa cununifo yoifain nantifi Diosin tsain ahuunoa cununi cuscan atofu cafoquin shafacafi ato yoifoni. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ascano Emaús ano man nocoti chaima nan rafutan shinannifo, —Noco finonfaini cairan, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ascatan nan rafutan yoinifo —Cayamahuu. Man fari caiquin. No fu iyopun, —huariaifoanno atofu caani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ascatan piaifoanno Jesús misi finifoantan Apa Dios yoiqui isca huani, —¡Aicho! Upan, non yopai cuscan min noco inanmisiran, —huatan. Misi torupacushon aton inanni. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ato inainton Dioshuunshon Jesús onanriscatanifo. Onantapaiyaifoanno atomaquinoashu yamariscatani. Afanancai tsoan oinnima. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ascano afi rafu yoinannifo, —Noco fu fain oquin Diosin tsainhuunoa cununi cuscan noco yoi fuaino non mua nocon ointi fupuisharatanaiton. Ahuun tsain sharacoinran, —icashu yoinancatan. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Ascashu Jerusalén ano nasoriscafuranifo nan Jesús fu rafuafo once funashcaquin. Ascashon ato fuchinifo ichananshu nan once yoinainfoanno, —Icon, nocon Ifo funia. Pedro man oinmanaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ascaifoanno nan rafu Emaús anoashu fua rafutari yoinifo, —Noficoinri Jesús man non oian Emaús fain non caino noco ahuunoa Diosin tsain yoia. Ascatan noco misi torupacushonaiton man non onanriscatanaran, —ishon nan rafutari ato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nan yoiriaifo muran Jesús afanan atoqui niriscatani. Ascashon ato yoini, —Maton ointi unimacain isharacoincahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ascaino —Yoshiran, —icashon shinannifo. Fasi mustairitan ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ascaifoan Jesús ato yoini, —¿Ahuuscai man ratuain? ¿Ahuuscai maton nomuran man icoinra huaimamun? ");
INSERT INTO mcdNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Ua oincahuun. Uhuun mucun yafi uhuun tau oincoincahuun. Pirico tohua. Nan uncoinfinquin. Yoshincai ua cuscara namiyacain shaoyamafinquin. Man manfin oincain shao yacain un nami yaran, —ishon ato yoini. Ato yoiquin asca huatan ahuun mucun tohua yafi ahuun tau ato ismani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ascaiton oincaquin ato nomuran shinannifo, —Namaparaca non oincatin, —ishon shinannifo. Icoinra huacuatama fasi aqui unimacoinnifo. Ascaiton nan iconcainran huacaicainonfo ato tushu yocani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ascaiton shiman shoi inannifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ascano aton ointaifi pini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ascashon afanan ato yoini, —Munfin mato yoiyomisiquin. Uhuunoa Moisés non Diosin tsain yoimisifoan non fanainti uhuunoa cununifo cuscan nanscacoinfin un aiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ahuun shinanpan aton nomuran nanumana aqui cununifo cuscan tapisharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","Ato yoini, —Diospan tsain cununi isca huaquin, “Cristo nan Diosin catoan naafiashu afanan osha rafu non fusti finontan funishquin.” Ascacun uhuunshon ato yoifoanfafaintacahuun aton chaca shatucashon shinansharaifoan un ato chaca soashonon. Jerusalén ano ato yoiqui tau huatacahuun. Ascashon nan manifoati ato yoifoanfafaishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ascashon un mato yoiaiton man oian cuscan yafi man nica cuscan futsafori yoipacushacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ascafia nuno Jerusalén ano oinyocaquin. Upa Diosin yoiyotiani cuscan un ahuun Yoshin Shara matoqui nichishqui. Ascano matoqui nocoshon ahuun curush mato inain. Nantian un mato yonoa cuscan man futsafo uhuunoa ato yoitiro, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ascashon Jesús Jerusalén anoshon Betania pasoato ato iyoni. Betania pasoato nococashon Jesús mushainacahuan yoini, —Upa Diosin, fasi uhuunshon tapimisifo cushusharapacuhuun, ");
INSERT INTO mcdNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","—huatan atomaquinoashu Jesús nuinacahuan Apa Dios icano ari cani. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ascaino nanno amaquinoashu naso furanifo. Yoinifo, —Jesús, min nocon Ifo fasi sharacoin. Non minhuun noiran, —ishon yoinifo. Yoicatan Jerusalén ano naso furancatan fasi unimacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dios fu tsainti pushu muranshon Dios yoisharariapaonifo. Nanti.");
INSERT INTO mcdNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Natian Jesucristohuunoa un mato yoicain man tapinon. Ahuashta oniataima Cristo Apa Dios fu iyopaoni. Arifi Diosin. Apa Diosin shinain cuscari arifi shinanmisiquin. Nannori fusti ahuun tsain. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ahuunshon Upa Diosin nantifi onihuaniquin. Cristohuunoamacai ahuashta onihuanima. Arusu fusti Apa futan nantifi onihuaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ahuunoashu fusti yora nitirofoquin. Aafin chashamati cuscaraquin. Upa Diosin ahuu cuscaramainquin arus fusti yorafo oinmatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Faquish muran chashamatinin noco oinmasharatiro. Nanscarifiai yora chacafo murannoari Cristo noco oinmatiro non Dios tanasharanon. Nan chacafoancai Cristo unumatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ascano Upa Diosin Juan nichini Jesucristohuunoa yorafo yoinon. —Jesushuunoashu yorafo Dios fu ipatiro. Upa Diosin mato tapimapaiyai cuscan Jesushuunshon mato tapimatiroran, —ishon Juanpan ato yoini. Nannori ato yoini icoinra huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanpacai yorafo Dios ya imapacutiroma. Diosifin man Juan nichiniquin ato yoinon. —Jesucristo fustichifin noco Dios ya imapacutiroquin, —ishon ato yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yoiyoni cuscan atoqui noconi. Criston iconquin Dioshuunoa tapimatiro. Diosin nantifi yorafoti imapaiyai cuscan ato tapimamisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nanton mai yafi yorafoti onihuafianicucai atoqui nocoaiton tsoan onannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ahuun mai ano nocofiaitocai ahuun yora Israelifoan oinpainifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Asca huafiainfoanno, nan noiaifoan icoinra huanifo. Ascaiton ato yoini isca huaquin, —Man ua icoinra huaashu Upa Diosin Facu man itiroran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yorafoancai Diosin Facu huatirofoma Diospan Facu inon. Ascashon tsoancai yoiqui isca huatiroma, —Uhuun ahuin un facu nanumatiro. Caianshu Diospan Facu inon, —ishoncai tsoan anori yoitiroma. Diosin fustiton ahuun facufo cainmatiro. Noncai asca huatiroma. Upan Diosin apaiyai cuscan Jesús icoinra huafoti aton nomuran fiananantiro ahuun facufo ishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ascan Criston Apa Dios icanoashu mai ano oni yoracoin ishquin. Nocoashu no fu iyopaoni. Nantifi yorafo noimisi. Nocohuun ramapaicoin. Ahuun tsain iconcoin. Arusu fustifin Upa Diosin facucoinquin. Apa Dios shara imisi cuscan arifi nanscacoinmisiquin. Man non oinpaoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ahuunoa Juanpan yoini isca huani, —Ua nicacahuun. Nanhuunoa un mato yoimisiquin. Un mato Diospan tsainhuunoa yoiyofiamisi natian aficoin man matoqui nocoa. Un mato yoimisi cuscan nanfin Diospan facu oinquin. Unmaquian. Un caiantaima Apa Dios fu iyopaoniquin. Ascan ua fasi finoncoian, —ishon Juanpan ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesús nantifi noco shara huamisiquin. Nocohuun noiquin noco shara huafafaini. Nantififain man non mumisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Upa Diosin noco yonopaiyai cuscan Moisés nocon shunifo yoiniquin. Ascaiton ahuunshon norifi non tapitiroquin. Moisés nanfo noco tapimafiaino Jesucristo nocoqui oni nocohuun ramapaicain aafin iconmisicoinquin noco ismapaoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tsoancai Upa Dios oinmisima. Ascafia ahuun Facu fu rafumisiton ahuunoa noco yoimisiquin. Ahuunshon non tapitiro ahuu cuscaramain Upa Diosiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ascano nocon caifo Israeli niaifofoan Jerusalén anoshon nan nocon yorafohuunshon Dios cufimisifo non ato fu niaifo patasharinoafo Juan icano nichinifo. —Juan yocatacahuun, “¿Min tsoamun?” ishon yocatacahuun, —ato huaafo focashon. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan yocaifoanno pusitama shafacafi ato cumani, —Uncai Diospan Furunma. Unricai Cristoma, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—¿Ascan min tsoamun? ¿Minmun Elías? —huaifoan. —Ma. Uncai Eliasma, —huaiton. —¿Ascan minmun Diosin tsain yoimisi nan nocoqui oiran Moisés noco huamisi? ¿Nan non manamisi minmun? —huaifoan. —Ma. Unmafinquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Ascan min tsoamun? Noco yoihuu noco nichiafo non ato tapimanon. Mihuunoa noco tapimahuun, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Isaías cununi cuscan nannoricoin Juanpan ato yoini isca huaquin, —Diosin mato yoipaiyai cuscan ua tapimana un mato yoinon. Tsoan istaipamashon un oi ashcafinin yoimisi isca huaquin, “Nocon Ifo nocoqui oshquiquin. Nocoataima itisharacahuun. Man ipaoni cuscan afanan ayamacahuun. Nantifi maton chaca potacahuun. Cayacafi isharashcaquin,” —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Nicacashon nocon caifo Fariseofoan ato Juanqui nichinifo yocanonfo, —¿Min Cristo iyamacain, min Elías iyamacain nan non manamisi Diosin tsain yoimisicai min ahuuscashocon min yorafo unu muran iquimapacuamun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ascaiton Juanpan ato cumaquin, —Unfin ato unu muran iquimapacuaquin. Ascafiano nuno noco muran futsan nocoa. Mancai onanma. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Un natian mato Diosin tsain yoifafaini. Ascafia afincoin chipo mato yoishquin. Fasi ua finoncoian. Un ahuara shara huaa rafanancai un ahuun oinmatima. Uhuun ramapaiyamainocai un ahuun oinmati icuanamaran, —ishon Juanpan ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nan pushurasi Betania unu Jordán oquirishtashon Juanpan nannoshon ato unu muran iquimapacuni. Nannoashuri atofu tsainni. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ascatan iyoconaino Juanpan Jesús aqui oaiton oinni. Ascanshon yorafo yoini isca huaquin, —¡Oincapon! Nan Diospan Chashoan Cahuashara cuscaracoin oi. Nanton nantifi yorafo nan icoinra huafotisi aton chaca soashonpacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Un mato ahuunoa yoimisi cuscan, un mato yoiqui anaitiano nocofunu shara matoqui nocoi. Un caiantaima iyomisi. Ascan ua fasi finoncoian. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Unrifi un onansharayamafiashon un yorafo unu muran iquimapacuaquin a nocon caifo Israelifoan a onanonfo, —ishon Juanpan ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jesushuunoa Juanpan ato yoini isca huaquin, —Diospan Yoshin Shara nai murannoashu ruhui cuscara Jesusqui fotopacucahuanaiton. Uficoin un oian. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Un onantaima Upa Diosin ua yoia isca huaquin, “Tsoan ua icoinra huaifo min unu muran iquimapacutiro. Futsa miqui oaino uhuun Yoshin Shara nan nocofunuhuun nuupacucahuashquin. A fu nitushquin. Nan oinquin min tapitiro uhuun Yoshin Shara matoya rafumashquin ahuun shinanshara maton nomuran shinanmaniran,” ishon ua yoia. Upa Diosin ua anori yoiyamacucai Jesús nan Diospan Furun urifi un onancuanama. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ascafiashon mun oian. Ascan un mato iconcoin yoiquin nancaifin Diospan Furunquin, —ishon Juanpan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iyoconaino afanan nanno Juan yafi ahuun tananmisifo rafu. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niafoanno Jesús ato finonfainaiton Juanpan oinquin ato yoini, —¡Oincapon! Nan Diospan Facu Chashoan Facu cuscara, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nicacatan nan rafutan Jesús mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ascaiton Jesús ifiacucahuan ato oinquin yoini. —¿Ahua man funaimun? —ishon ato yocaiton. —¿Tapimamisiton, rani min iquimun? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Fucahuun un mato ismanon, —ishon ato yoini. Ascatan afu focaquin oianfo ica ini. Nanno afu yatapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nan rafu Juanpan ato yoia cuscan nicacatan Jesús mufainifo futsan ahuun anu Andrés. Nan Andrés ahuun ochi Simón Pedro. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesús icano nococatan Andrés samamashta ahuun ochi Simón funai cani. Aqui nocoshon yoini, —Upa Diosin noco yoiyoni, “Un maton Numamisi matoqui nichishquiran,” ishon noco yoiyoni. Nan man non fuchia. Nanfin Cristoquin. Oinyohuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ascantan foaifoanno Andrés Simón Jesusqui iyoni. Aqui nocoshon Jesús Simón oinquin yoini, —Minfin Simonquin Juanpan facu. Natian un mia anu futsa tuquihuanon. Non mia Cefas huairan, —ishon yoini. Cefas nahua tsainmanfin Pedro. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ascan iyoconaino Jesús shinanni isca huaquin, —Un Galilea ano cairan, —ishon shinanni. Caquin Felipe fuchitan yoini, —U fu cahuun, —huani. Nicatan afu cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe non Andrés non Pedrori pushurasi ahuun anu Betsaida ano inifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ascatan Felipen Natanael fuchishon yoini, —Moisés Diosin yononi cuscan cununi isca huaquin, “Un Numamisi matoqui nichishquiran,” ishon Diosin yoini cuscan Moisés aqui cununiquin. Nannorifi Diosin tsain yoimisi futsafoan yoinifo. Nancai man non fuchiaran. Jesusfin José ahuun facu Nazaret anoaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Ahuatomun noco Nazaret ano shara huashotiroquin? —Natanael huaiton. —Ohuu, Oinshquin, —Felipe huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael aqui nocoaiton Jesús ahuunoa yoini, —Naafin Israelicoinquin. Diospan yora ipaicoin. Nantofin iconcoin shinanfafaimisiquin. Paracai huamisimaran, —ishon Jesús ahuunoa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nicatan Natanael cumani, —¿Ahuuscashomun ua oinyamafiamisishaquin min ua onantiroquin? —ishon yocaiton. —Felipe mia cunataima un anoyamafiashon ihui huiguera namannoa un mia oian, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ascaiton, —Tapimamisiton. Felipe ua yoia cuscan iconcoin. Minfin Diospan Furunquin. Nocon caifo Israelifo min nocon niaifoquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús cumani, —Min fimi huiguera ihui naman raca. Un ano yamafiashon un mia oian. Un anori mia yoiaiton mian icoinra huaa. Min ahuara shara finacaia min oinshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iconcoin un mia yoinon. Min Upa Diosin nai muran icano oinshquin. Uhuunoashu Upa Diosin ahuun oinmati afu nai muran icafo mai arishon nai muran Diosin icano funishquin. Ascaiton min oinshquin. Upa Diosin icanoashuri mai ano fotoaino min ato oinshquiran, —ishon Jesús Natanael yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Man osha rafu ano Caná ano Galilea muranshon nocofunun ainfo fiaino yorafo anosi ichanannifo. Jesús non ahua non norifi afu rafumisifori noco yoimanifo. Ascano non cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fimi unu man nutsoafono Jesús ahuan yoiquin, —Na focai afanan fimi unu yamafinquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ascaiton, —Uhuashtan, funayamahuun. Uhuun yono un ato ismataimacai, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ascaiton ahuan oinmatifo yoiquin, —Nan mato yonoai cuscan huashocaquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nanno mai cutimahuan seis funupafo chaimashta tsaonifo. Fasi funupafo bidóntirofo. Treinta galones a muran iquitiro. Nocon caifo Israelifoan aton muchoquimuti anoashu muchoquimui futsunifo. Shinanpaoni, —Non iscain muchoquimuaino Upa Dios nocoqui unimatiroran, —ishon shinanpaonifo. Nocon shunifoan nannori noco yonopaoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ascashon Jesús oinmatifo yonoqui, —Na cutimahuanfo muran unu fospi huacahuun, —huaiton. Fospi huacaquin cufirisacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ascantan Jesús yononi, —Ichananfo cushumisi fuafaintan mumatahuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nicaquin oinmatinin ichananfo cushumisi fuashon inainton muacai unuma. Fimi unucoin ini. Ichananfoan cushumisitocai Jesús aca cuscan onannima. Oinmatifoansi Jesús aca cuscan huaquin onannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ichananfoan cushumisiton Jesús fimi unu onihua onanshoma nan rama ainfo fian cunashon yocani, —Na fimi unufin sharacoinquin. Nan ichananfoti aquifin rufofo shara nutsocashon chipo onanshta ichapama shara amisifo. Ascan huafiainfoan minfin nan sharacai ahuun unutaquin fasi sharacapacoin noco amaiquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ahuamamishti yora atiroma cuscan huatiroshaquin Jesús nanno nan pushurasi Caná ano tau huaquin noco ismaniquin. Ato ismani aamain Diospan Facucoinshofin ahuunshon ahuamamishti tsoan oinmisima cuscara huatiroquin. Ascano oincashon non afu rafumisifoan man non icoinra huani. —Icoinfin Jesús Diospan Facucoinran, —ishon non shinanniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ascatan Jesús ahua non ahuun ushtofo norifi afu rafumisifo nan pushurasi ahuun anu Capernaum ano non cani. Nanno osha rananyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Diosin ahuun oinmati afu imisiton nocon shunifoan aton furun iyoafofosi finonmani rutunonma. Faritifi nanfohuunoa shinanpaonifo. Israelifoan noco fusititian. Nan fusiti nocoti chaima Jesús nan pushurasi Jerusalén ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nannoashu Dios fu tsainti pushu murannoashu moifo non chashoanfo non ruhuinfo ya inanmitsacashon ahuun rafanan pui fishcaquin. Nannori pui fiananan huamisifo tsaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ascaiton Jesús ato fuchitan fichi coshatiqui tuchia atoqui sannaino. Chashoanfo non moifo non aton ichonquin futsani. Sapa camaqui aton pui machiafori arasaquin futsani. Sapari cushca huaiacufoan potani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nan ruhui inanmitsamisifo potashon ato yoini, —Nafo ya Uhuun Upa Diosin pushu murannoashu fotacahuun. Ahuuscaimun uhuun Upa pushu murannoashu man ahuarafo inanmitsaicain ahuun rafanan pui fiishcaquin. Afanan uhuun Upa pushu murannoashu ahuarafo inanmitsayamacahuun. Uhuun Upa Diosin ahuun pushucai a murannoashu inanmitsati pushumafinquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Oincatan non afu rafumisifoan non shinanni isca huaquin, —Icon Diosin tsain nannori ahuunoa cununiquin isca huaquin, “Upa Diosin un min pushu cushusharapai a muranshon mia fusti shinanonfo. Ahua futsa a muranshon anonfoma. Ahuara futsacai min pushu murannoa un oinpaimaran,” —ishon cununiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesús ascaiton Israelifoan nocon niaifofoan a yocanifo, —¿Ahuuscain Dios fu tsainti pushu muranshon min ato potamun? Diosin mia yonoaiton ahuara tsoan atiroma cuscan noco ismahuu non mia icoinra huanon, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Man na pushu paonhuaca afanan osha rafu non fusti finontan un afanan mapoinnifoanshquin. Ufin ashquin, —ishon Jesús ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—¡Cuu! Nocon shunifoan cuarenta seis fari afianifo. ¿Ahuuscashocon osha rafu non fustisi min aquimun? —ishon cumanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ascafiaitocai tapinifoma Jesús Dios fu tsainti pushuhuunoacai yoinima. Ahuun cayahuunoa afiri yoimuni. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ascan chipo Jesús naafiashu osha rafu non fustitan funiano noco yoiyoni cuscan non shinanni, —Icon Jesús yoini, “Nan pushu paonhuaca unfin shafa rafu non fusti un afanan funimashquicain,” ishon yoini. Nantian man non tapia ahuun cayahuunoa yoiran, —ishon non shinanni. Ascano Diosin tsain cununi cuscan huafain Jesús yoini cuscari non icoinra huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ascan tsoanshta atirofoma cuscan huaquin Jerusalén anoshon Jesús ani. Ascan nanfo oincatan yorahuanrasifoan, —Nan Diospan Facucoinran, —ishon icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ascanfiashon afoan shinainfo cuscan Jesús ato onancoinni. Icoinra huaiyamaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yorafoan aton nomuran shinainfo cuscacai tsoan Jesús yoitiroma. Afincoinmain nantifi onancoiainton. Aton nomuran shinainfo cuscan onancoinni. Icoinra huayofianishaquin tapini samamashta shinan futsaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nan nocofunufin Fariseo iniquin ahuun anu Nicodemo. Nanrifi Israelifoan aton niaifo patashari. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nantori Jesusqui yamu oshon yoini, —Tapimamisiton, non tapiafin Upa Diosin mia nichiniquin min noco tapimanon. Man nonfin tapiaquin tsoan atiroma cuscan min huaiton Dios fu rafuamatocai asca huatiroma cuscafin min huaaquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ascaiton cumani, —Unfin iconquin mia yoicain. Nocofunu afanan cain futsanyamacai Diosin niaifo ano nocotiromafinquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ascaiton afanan yocaquin, —¿Ahuuscashumun afanan nocofunun cain futsantiroquin? ¿Man anifofiashu ahuuscashucon ahuan shaqui muran afanan nanutiromun cain futsashquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ascaiton afanan Jesús cumani, —Unfin iconquin mia yoicain. Yora unu muran iquimamutama ahuun chaca shatutama afanan Diospan Yoshin Sharahuunoashuri cain futsanyamashuricai Dios niaifo ari nocotiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Futsafin futsa cainmatiroquin ahuunfin canon. Nanscarifi aquin Diospan Yoshin Shara fustiton nocon cainma futsatiroquin. Norifi non ahuufin canon. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Un mia yoiai cuscarifi, cain futsatiroquin, huaiton. “¡Aira! ¿Ahuuscashucon non cain futsatiromun?” iyamahuu. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fuufin nan fopaiyaiquiri fotiroquin. Fuun nicafiaquicai man tapitiroma raquiriashu futanmain raquiri foicain. Nanscarifiai yorafo Diospan Yoshin Sharapan ato cainma futsatiro. Ahuuscashomain cainma futsatiroquin tsoancai tapitiroma. Manricai tapitiroma ahuutianmain cainma futsaicain, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Ahuuscashucon ascatiromun? —Nicodemo huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—¿Min Israelifoan tapimamisifiashomun na un mia yoiai min tapimacain? ");
INSERT INTO mcdNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Un mia iconquin yoi. Nan un nica cuscan huafain un oian cuscan un mia yoi. Ascafiacai un mato yoia cuscan man icoinra huama. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","¿Nuno mai anoa ahuarafo icai cuscan un mia yoiai icoinra huayamashu ahuuscashon Diosin nai muran icariafo un mia yoiaiton min icoinra huatiromun? ");
INSERT INTO mcdNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tsoacai nai muran camisima. Urus fustifin un nai murannoashu fotoaquin nocofunucoin iquiyoi. Un afanan chipo nasocainicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Nocon caifo Israelifoan tsoan istaipamashon chaca huapaonifo. Ascaiton oinquin Diosin rono paupan atoqui nichini ato nasanon. Ascanori Moisés Diosin yononi ihuiqui rono ointsa huashon yayomashon nimainifoanni a oincanashu cayanonfo. Nanscarifi aquin uarifi ihui coyan iquinanqui nimainifoanshcaniquin nan ua icoinra huafo uhuunoashu Dios fu isharapacunonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Unfin Upa Diosin Facu fustiquin. Ascafiashu nantifi yorafohuun fasi noiquin ua nichini atohuunoashu un nanon. Nan ua icoinra huafoti omitsiscapatamarocon Upa Dios fu ipasharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ua mai ano nichini un ato onaintimatama un aton chaca soashonon uhuunoashu nipanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ua icoinra huafocai Upa Diosin ato omitsiscamapacunacama. Ascan tsoan ua icoinra huayamacun Upa Diosin ato onaintimai yoiyoni cuscan. Unfin Upa Diospan Facu fustiquin. Tsoan ua icoinra huayamashucai omitsiscai unupacunacama. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Isca huaquin mato tapimai. Shafa yafi faquishcai ositiroma. Nanscarifiai unfin Diospan Facu sharaquin. Ahua chacacai ufu itiroma. Upa Diosin ua nichini nan maitio shafa cuscara un imanon chaca shatunonfo. Ascafiacai yorafoan aton chaca potacasmacanifin uqui fucasmacani isharashcaquin. Ascacun Upa Diosin ato onaintimai. Aton chaca noicanicai uqui fupaicanima chaca shatucanashu isharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Faquish noiquicai tsoa shafa oinpaitiroma. Nanscarifi aquin chaca noicanicai uqui fupaicanima. Uqui ranocani uqui oshon chaca huaifo cuscan tapicasmacani. Chaca huaifo cuscan ato oinmacasmacani. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tsoa icoinsharapaiyaifofin uqui fucaniquin Upa Diosin ato amapaiyai cuscan aquifin futsafoti oinmacaniquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ascatan chipofin Jesús yafi afu rafumisifo Judea mai ano non cani. Nanno atofu iyoni. Nannori aton chaca shatupaiyaifoan non ato unu muran iquimapacuniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan cunu muran iquimanataifoma arifi futsafo unu muran iquimapacuniquin. Nan Enón pushurasi chaimashtari Salim ini. Ano unu noa sharacoin. Anoshon ato unu muran iquimapacuni. Nanno furi furiaifoan ato unu muran iquimapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nantianri Juanpan tanamisifo ya nocofunu nocon caifo futsa fu fochishmanantanannifo. Ahuuscashucaimun unu muran iquimamutiroquin icashu fochishmanantanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ascatan Juan ano fonifo. Nococashon yoinifo, —Tapimamisiton, non mia tapimapai. Unu Jordán oquirishon min na nocofunu Jesusqui nocotan, “Nan Diospan Facu. Nocoqui nocoaran,” ishon min yoita. Arifi natian yorafo unu muran iquimapacui. Nantifi yora aqui focaniran, —inifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nicaquin Juanpan ato cumani isca huaquin, —Diosin fustitofin catontiroquin ahuuscamain huaicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Uncai Cristoma. Upa Diosin ua yonoa un Cristohuunoa yorafo tapimanon aton chaca shatunonfo Cristo nocoaiton icoinra huashquin. Nannori un mato yoiaiton man nicamisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Afanan un mato yoi ua nicacahuun. Man man tapia nocofunun afu rafua yoitiro isca huaquin, “¡Aicho! Na ainfo min ua fuchimana natian un rama fia uhuun ahuin inon. Un aqui unimacoinran,” ishon funun yoiaino afu rafuan aqui unimatiro. Nanscarifiai un Cristo yamafiacun futsafoan nan Cristo Jesús nicacoiainfoanno un fasi unimacointiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aafin Cristocoinquin. Uncai Cristoma. Ascan afanan un yoiqui chaihuaima ua tanatama Cristo fusti shinancoinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Criston Dios icariashu mai ano fotoni. Nantonfin tsoamamishti finoanquin. Un na mai anoashu caiantonfin na mai anoa ahuu cuscaramainquin un tapiaquin. Nan fustihuunoasi un yoitiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ascafia Jesús oinmisi cuscan nicamisi cuscan noco yoifiaiton fustirasiton icoinra huaafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ascafia tsoan ahuun tsain icoinra huacashofin nanfoanfin tapitirofoquin Diosin tsain fasi iconcoin. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Upa Diosin ahuun Yoshin Shara Jesusqui nichini afu rafupacunon. Nantifi ahuun curushu inanni. Diosin yoia cuscan nantifi nocori tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Upa Diosin ahuun Furun fasi noicoinquin. Yonoa nantifi nai murannoa yafi mai anoafoan aton ifo inon. ");
INSERT INTO mcdNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ascan tsoan Diospan Facu icoinra huashu afu ipatiro. Ascantarifi tsoan Diospan Facu icoinra huayamashu Diosin aqui sinaquin omitsiscamapacunaca. Ascan nan Jesús icoinra huafoma naacanashu afu ipatamarocon faquish muran omitsiscapanacaforan, —ishon Juanpan ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ascano isca huaquin yoinonannifo, —Nan Jesús yorahuanrasifoan icoinra huaifoan ato unu muran iquimapacui. Juanpan aca finonmafain iquimapacuiran, —icashu yoinannifo. Nan yorafoan Jesushuunoa yoini cuscan Fariseofoan nicafiacaquin aririma. Jesuscai afincoin ato unu muran iquimapacunima. Nonfin afu rafumisifoquin non ato iquimapacuni. Nan yorafoan ahuunoa yoini cuscan tapiashu no fu Judea anoashu Galilea ano nasoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea anoashu Samaria mapaicaini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ascatan Samaria ano mapaicaini nanno pushurasi ahuun anu Sicar ano non noconi. Nanno chaimashta nan mai nocon shuni Jacob ahuun facu José inanni. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nannori Jacob mai poquini a murannoa unu fishqui. Ascaino fari masafinin racano Jesús arusu nanno noconi. Fasi chai cunoashu oashu atsanacoin. Ascashu nanno tsaoyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Non afu rafumisifo nantianri pushurasi ano cashon non tushu fini. Jesús nomifiaquicai ahuaqui unu fitiro inima. Ascaino nantianri ainfon Samaritanon shafo nan pozo ano noconi ahuun cuti muran unu fiishquin. Ascan Jesús yocani, —Ua unu inanpun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nocon caifo Samaritanon oincasmanifo. Ato futancai piinifoma. Ascan nan ainfoan cumani, —Minfin Israelifoquin. Unfin Samaritanonquin. ¿Ascano ahuuscain mian unu yocaimun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—Diosin mia inanpaiyai cuscan onanfain tapishonfin min ua unu yocacuanaquin. Na unun mia nimapacutiro, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Min cuti yafi rusfi yamai. Na pozo fasi noacoin. ¿Ascaiton ahuuscashomun min na unun yora nimapacutiro min fitiroquin? ");
INSERT INTO mcdNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nocon shuni Jacob pozo non a murannoa unu finon. Arifi nan unu ayani. Ascaino ahuun facufoanri ayanifo. Ahuun inafori ayamani. ¿Min nocon shuni Jacob finoanmun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Tsoan na pozo murannoa unu ayafiashu chipo afanan nomitiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ascafia tsoan na unu un ato ayamacai afanan nomipacunacama. Iconcoin na unu un inanquin a muran unu tsosi shara fuchoi cafiscai. Ayashu nan unuhuunoashu ipasharacointiro, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Min nocofunu shara. Na unu shara ua inanhuun un afanan nomipacunonma un afanan nuno unu fiiyononma —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Min funu ihuitahuun afanan nasoshquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Uncai funuyamafinquin, —huaiton. —Icon mincai funu fustiyama. Minfin funu rananyaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Min funu mucu fustiti mia fimisifo. Natian min futsa fu ica. Min funucoinma fu. Icon min ua yoia, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Natian un tapia min Diosin tsain yoimisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nocon shunifoan nuno machi anoshon Dios cufimisi inifo. Ascafiano min caifo Israelifoan yoimisi isca huaquin, “Jerusalén anoshon non Dios cufitiroran,” ishon yoimisifo, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Un mia yoinon ua icoinra huahuu. Chipo ahuutiaran tsoan afanan shinainma isca huaquin, “¿Ranishomun un Upa Dios cufitiroquin na machi anoshon iyamarai Jerusalén anoshon?” ishon afanan anori shinanshcaquima. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Non ranishora cufiainocai non chipo ascaran shinainma. Na machi ano iyamarai Jerusalén anocai non ascainocai ahuama. Ahuuscashomain non Dios cuficain, nan Diosin tapipai. ¿Nocon nomuran non Dios cuficoinmun? ¿Ahuun Yoshin Sharahuunshon non Dios cuficoinmun? Nan Diosin nicacoinpai. Aafin Yoshin Sharaquin. Non Dios cuficoiainton ahuun Yoshin Shara fustiton noco tapimatiro non cufisharanon. Ahuun Yoshin Sharahuunshon non Upa Dios cufiaiton nanscara Upa Diosin fuchipai. Ascafiashu manfin Samaritanonfoquin cufipaifiaquicai nocon Upa Dios man tapisharafoma. Asca nonfin Israelifoquin non nocon Upa Dios tapicoian. Man non tapiari nan Numamisi arifi Israeli iishquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Mun tapia Upa Diosin chipo nocofunu nocoqui nichishquin. Aafin chipo nocoquin ooshquin. Ahuun anu futsa Cristo. Afin nocoshon noco nantifi shafacafi tapimashquin, —afanan ainfoan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Unfin Cristoquin, —ishon Jesús cumani. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ascan Jesús ainfo fu tsaincaino non afu rafumisi aqui noconi. Jesús ainfo fu tsaincaiton oin non mustairini. Ascafiashon non yocanima, —¿Ahuuscain min ainfo fu tsainquinmun? —ishoncai non yocanima. —Min ainfo yoia cuscan noco tapimahuu, —ishoncai non anori yoinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ascantan nan ainfo ahuun cuti potafainicai ahuun pushurasi ano cani. Nocoshon ahuun yorafoti yoini, —Nocofunun uqui nocoshon un amisi cuscan nantifi ua yoiaquin. Nanraca Cristo. Oin fucapon, —ishon ato yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nicacatan nan pushurasi anoashu Jesusqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nantianri non afu rafumisifoan non yoini, —Tapimamisiton, piyohuu, —non huaino. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Unfin tushuyaquin. Un tushu ya cuscacai man ahuunoa tapiama, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ascaiton nicai non yocanonanni, —¡Aira! ¿Tsoancainco tushu fishoamun? —ishon non yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Uhuun Upa Diosin ua nichini un ahuun yono ashonon. Afin ua amapaiyai cuscan nantifi un ashoin. Nanfofin uhuun tushu cuscarafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Man yoimisi isca huaquin, “Yono noco mau ano fanafo cuscara oshu rafu non rafuri finontan non chitutiroran,” ishon man yoimisi. Nanscarifiai man shinan raca chipo non yora Dioshuunoa yoitiro a Ifo huaa afu ipashcaquin. Oinyocahuun. Yora ichaparasi natian itisharacani Diosin icoinra huashcani. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Futsan yonoshotanfin chitushotiroquin. Nancai mau ifoan inansharatiro. Nanscarifi aquin futsan Diosin tsain icoinra huamano Upa Dios fu ipasharatiro. Nancaifin ahuun ointi muran unimasharatiroquin. Upa Diosin a inansharacoinshquin. Icoinra huataima futsan yosiyomisi. Nan yosimisiri ahuun ointi muran unimashquin. Upa Diosin arifi inansharashquin. Ascaiton Diosin tsain yosimisifo yafi icoinra huamamamisifo nanscaracoin rafu. Upa Diosin ato inansharashquin aton ointi muran unimanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ascano iconcoin yoimisifo isca huaquin, “Futsan fanano chipo futsan nan yono chitutiroran,” ishon yoimisifo. Nanscarifiai futsan Diosin tsain yoiquin tau huano futsanri chipo yoiaino nantocaifin icoinra huamacointiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mancai mai futsa ano yosiamafiaiton un mato nichian nannoa man ato icoinra huamanon. Futsafoan nannoshon fasi curushcain yonoa Diosin tsain ato yosicaquin. Mancai nanno yonoama. Ato yosiqui chai huayamafiashon man ato icoinra huama. Futsafoan aton yonohuunshon man ato icoinra huamaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ascaino nan ainfon Samaritanon ahuun caifoan pushurasi ano nocoshon ato yoini, —Un imisi cuscan nantifi ua puashoan. Ua oinyamafiamisishaquin ua onancoianran, —ishon ato yoiaiton Jesús icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ascano nan ainfoan ato yoiaiton nicacani Jesusqui funifo ahuun tsain nicai fucani. Aqui nocoshon, —No fu nuno iyopun, —huanifo. Ascaiton nicai Jesús atofu osha rafuyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ahuun tsain nicacaquin futsafoan icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ascano icoinra huacashon ainfo isca huanifo, —Min noco yoifiaitocai non icoinra huama. Noficoin non ahuun tsain nicashon non icoinra huai nanton nantifi yorafo manifoti nocon Numamisiran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ascano nan osha rafu yotan Jesús no fu nan Samaritanonfoan pushurasi anoashu Galilea ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús arifi Galilea anoashu pushconi. Nannoashuri yonopaoni. Ahuun yoraforifi nanno inifo. Ascano Jesús yoini, —Diosin tsain yoimisiton ahuun pushurasi ano ahuunoa isca huaquin shinanfo, “Acai tsoamaran,” —ishon shinanfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ascatan Galilea ano noconi. Atirifi Galilea ano Jerusalén ano fusititian fonifo. Nannoshon tsoan atiroma cuscan Jesús Diosihuunshon huani. Nantifi Jesús acai cuscan oinnifo. Ascan atoqui nocoano aqui unimanifo. —¡Aicho! Man min oaquin, —ishon Galilea anoafoan yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ascano pushurasi ahuun anu Caná Galilea ano Jesús nasoni. Nanno fari futsan Jesús ahuun tsainmansi unucoinfiacun fimi unu onihuani. Nantianri afanan nanno noconi. Nanno niaifon futsa ica ini. Pushurasi futsan ahuun anu Capernaum ano furun isininni. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ascaiton niaifoan nica Jesús Judea anoashu Galilea muran Caná ano oaiton nicai aqui oshon yoini, —Ifon, uhuun facu isininqui man nai. Uhuun facushta ua oinshoyopun ua cayahuashoshquin, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—¡Ohuashta! ¿Ahuuscain yoran atiroma cuscan un huaiton man oinfiacaquicai man ua icoinra huaima? —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ascan afanan nan niaifoan Jesús yoini, —Ifon, U fu cayoicapun uhuun facu nanonma, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ascaiton Jesús cumani, —Min facu ano catahuu. Min facucai naima. Niifinquin, —ishon Jesús yoini. Jesús yoia cuscan icoinra huafaini cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nanscatan caino ahuun oinmatifo aqui nococashon yoinifo, —Min facu man caya. Naima man niaran, —ishon niaifo yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ascaiton ato yocani, —¿Ahuutia farimun uhuun facu cayafaitaquin? —ishon ato yocaiton. —Fari masafinin racano ahuun yona matsifaitanran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yoiaifoan nicatan apan shinanni, —Icon Jesús fari masafinin racano ua yoita, “Min facucai naimafinquin. Niifinquin,” ua huaitaran, —ishon shinanni. Ascano ahuun yorafo yashon nantifiton Jesús icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ascano Jesús Judea anoashu Galilea ano nocoshon afanan tsoan atiroma cuscan ato oinmaniquin. Ato oinmaquin rafu huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ascano chipo Jesús Galilea anoashu Jerusalén ano no fu cani nocon caifo Israelifo fu fuusicai. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nanno chashoanfoan aton iquiti cunu ini. Nanno chaimashta ianman facushta ini. Cusumun pushu cahuan sharamishti mucu fustiti tsaoacuafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Nannori isinin imisifo ichaparasi racanifo. Fushofo non chatofo non yoratisho quicurushui futsuafori racanifo. Ascaino Diospan oinmati afu nai muran icaton nanno ian man facushta ano oi fustirasi ipaoni. Nanno nocoshon Diospan oinmatinin ianman facu fuchomapaoni. Nan ianman facushta fuchoai muran isinin icai futsa iqui tauashu cayapaoni. Ascan nantifi isinin imisifoan manaifono Diospan oinmatinin ian fuchomanaino ian muran iquitaunon. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ascano Jesús nanno nocotoshiqui oian nocofunu treinta ocho fari isinin itianiquin noconi. Yoratisho quicurushui futsua nipaiqui ranainton fuchini. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Futsan Jesús yoishoni na nocofunu treintiocho fari isinin imisiran. Huaiton yocani, —¿Min cayapaimun? —ishon Jesús yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nicaquin cumani, —Tsoancai ua ianman facushta muran iquimamisima Diosin nai oinmatinin ian fuchoaino. Un iqui taupaiyaiton ua shutimisiforan, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ascaiton Jesús cumani, —Funinaca huahuun. Min oshati ya catashquin, —ishon yononi. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ascaiton nicai funinaca huan ahuun oshati ya cani. Nan sabadoai shafatan yoratishon quicurushui futsua Jesús caya huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ascano nocon caifo niaifofoan oian nan nocofunun ahuun oshati foaiton oincaquin yoinifo, —¿Ahuuscain min oshati Sabadoaino min foain? ¿Min tapiamamun nocon shuni Moisés noco yononi non Sabadoaino ahuashta huatiroma? Ascan min oshaticai na Sabadoaino min fotiromaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ascaiton ato cumani, —Na nocofunun ua caya huamashon. Ua isca huaa “Min oshati fotahuun,” ishon ua yonoaran, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Tsoamun na nocofunuquin anori mia yonoa? —ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yoratisho quicurushui futsuatocain tapinima tsoanmain caya huamaquin. Asca huafainicai Jesús samamashta amaquinoashu yorahuanrasi muran cani. Ascaitocai afanan tsoan oinnima. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Man ascano chipo Jesús nan nocofunu caya huama Dios fu tsainti pushu anoa fuchishon yoini, —Shinanhuun. Min afanan isinin iquimaquin. Man min cayasharaquin. Ascan min chaca huamisi cuscan afanan ayamahuu. Min chaca nantifi shatuhuu. Min chaca shatuyamashu ahuara chaca finacaia min ahuuscaratiroquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ascaiton nicafainicai nan nocofunu Jesusmaquinoashu cani. Caya huamano nocon caifo Israelifoqui chanicai cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ascano Jesús sabadoaino yora caya huamana nicacani nocon niaifofo Jesusqui sinanifo. Sinaquin Jesús fucash huanifo. Aqui tsain chaca huarianifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ascaiton Jesús ato yoini. —Uhuun Upa Diosin shafatifi yora shara huafafainmisi. Nanscarifi aqui urifi uhuun Upan acai cuscan un huafafainiran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ascano amaquiri shinannifo. Shinancaquin Jesús yoiti huanifo. —Nocon shuni Moisés yononi cuscan non Sabado ahua huatiroma. Jesús Moisés yononi cuscan aquima. Yoiari Dios ahuun Upacoin. ¡Cuu! Jesús shinanmun afi Upa Dios cuscaracoin. Ascan ahuuscashomain non Jesús ato rutumatiroquin. Non shinanoncahuun, —icashu nocon niaifofoan ahuun yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nan shinainfo cuscan Jesús onanniquin. Onanshon ato yoini isca huaquin, —Un mato icon yoinon. Ua nicacahuun. Uficai un ahuashta huaima. Uhuun Upa Diosin acai cuscan mun oinmisi. Nanscacoin urifi un huai. Ahuunshon fusti un aquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Unfin Diospan Facuquin. Ua noicoian. Afin acai cuscan ua oinmai urifi un anon. Ahuara futsa fasi finacaia chipo ua ismashquin. Ascaiton man oin man mustairishquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Upa Diosin yora naacoinfiacun funimapaiquifin afanan nimasharatiroquin. Un ahuun Facu. Nanton acai cuscanrifi un huatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Upa Diosin uhuunoa nan yorafoti shinansharamapai unfin ahuun Facuquin. Nanhuunoa yorafoan shinansharamisifo cuscarifi uhuunoari ato shinansharamapai. Ascan Upa Diosin afincai yoima ratocaimain afu ipatiro iyamarai ratofomain faquish muran omitsiscapanacaquin. Ua yononi. “Min yorafoti yoitiro ratofomain ufu nipayamarai faquish muran omitsiscapanacaquin,” ishon ua yononi. Nannori ua yononi. Upa Diosin nicapai uhuunoa shara yoiaifoan. Ua nichini. Ascan tsoan “Min Diospan Facu Shararan,” ishon ua yoicasmaiton Upa Diosihuunoari yoisharama. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Un mato iconcoin yoinon. Tsoan uhuun tsain nicasharafain Upa Diosin ua nichini icoinra huafin Upa Dios fu ipasharapacunacaquin. Un nan cuscara yora onaintimaima. Afanancai Satanás ahuun yora itiroma. Omitsiscapatamarocon natian afi Upa Diosin ahuun yoracoinquin afu ipashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Un ahuara futsa iconcoin mato yoinon. Natian nan naa shinantsain uhuun tsain nicacoianshu ufi Diospan Facu icoinra huashu afanan Diosimaquin itamarocon afu nipasharatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tsoan futsacai Upa Dios nimama. Afi nipamisi. Nanscarifiai Upa Diosin un ahuun Facucun ua yononi cuscan ufin nipamisiquin. Tsoa futsacai ua nimama. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Unfin Diospan Facuquin. Ascan ua yoiqui isca huani, “Min yorafoti yoitiro ratofomain ufu nipatiro iyamarai aton chaca shatuashma omitsiscapanacafoquin,” ishon ua yononi. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Un mato yoia cuscan mustairiyamacahuun. Chipo nafoan uhuun oi nicashcani. Nicacani funishquicani. Ratoranfo niyoashu isharamisifo funiashu nipasharashcani. Ascanrifiai ratoranfoan niyocashon chaca huamisifo funiashuri omitsiscapashcani. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Urus fusticai un apaiyai cuscan un shinainma. Upa Diosin nanton ua nichini. Ascan afi ua amapaiyai cuscan un huapai. Ascafiacai ucai urus fusti un ahuara huatiroma. Upan Diosin ua tapimana cuscan un nicaquin un yorafo yoitiro. Nantifi onancoianquin. Ascan ua tapimana cuscan un cayacaficoin yorafoti yoitiro ahuu cuscarafomainquin. Urus fusticai un apaiyai cuscan un shinainma. Uhuun Upa Diosin ua nichini afi amapaiyai cuscan ua huamashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","33","Uficoin uhuunoa un yoisharaitocai tsoan nicasharapaima. Ascafiacai aririma. Urus fusticai uhuunoa un yoimisima. Juanpan arifi uhuunoa yoisharamisiquin. Manfin Juanqui yorafo nichiaquin. Nanton uhuunoa icon fusti yoisharamisi. Un Cristocun nanton mato tapimana. Futsanrifi uhuunoa yoisharamisi. Nan Upa Diosiri uhuunoa yoisharamisi. Nan uhuunoa yoimisi cuscan iconcoin mun tapia. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","36","Juanpan uhuunoa iconcoin yoifiamisi unfin tsoan atiroma cuscan un huaiton man man oinmisiquin. Tsoan uhuunoa yoiamaiton oinquin nanfohuunoa man tapitiro un mato iconcoin yoimisi. Ascafia Juanpan uhuunoa yoimisi cuscan un afanan mato shinanmai maton chaca man shatunon omitsiscapatamarocon Upa Dios fu ipasharashquin. Juan nocofunu fasi sharacoin. Ahuunshon Diosin mato yoipaiyai cuscan nanton mato tapimayoni. Chashamatinin man chashashon man faquish muran fai ointiro casharashquin. Nanscarifiaquin Juanpan mato tapimana ahuuscashomain man chaca shatuashu Dios fu ipatiroquin. Mato yoimisi cuscan man shinanquin isca huai, “¡Aicho! Juanpan noco cayacafi Diosin tsain yoiaiton. Non nicasharanon,” ishon man anori shinanyomisi. Juanpan uhuunoa yoimisi iconfiashu uhuun Upa Diosin Juan finoncoian. Afincoin ua yonoa. Uhuun Upa ua nichini ua amapaiyai cuscan un anon. Ua amapaiyai cuscan cuyocointan un unutiro. Natianri ua yonoa cuscan un aaquin. Ascan un acai cuscan oinquin man tapitiro Upa Diosin ua nichini ahuunshon un yononon. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Upa Diosin matoqui ua nichini arifi uhuunoa yoimisi. Mancai Upa Diosin ahuun oi nicayamafain man oinmisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Diosin ua nichifianicucai man ua icoinra huaima. Ascan ahuun tsaincai maton nomuran man nanumisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Man Diosin tsain fasi oinfafainmisishaquin man Dios fu nipatiroran ishon man shinanmisiquin. Anori man shinanfiaquicai Diospan tsain uhuunoa cunufiacashon mancai uqui fupaicanima un mato nimapacunon. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Un mato onancoian. Mancai maton nomuran man Upa Dios noima. Ascacun man uhuunoa shinansharai iyamarai man uhuunoa shinain chacafiainocai un shinainma. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Uhuun Upa Diosin ua matoqui nichini ahuu cuscaramainquin uhuun Upa uhuunshon man onancoinon. Ua matoqui nichifiani mancai ua icoinra huatamarocon ua oincasmacani. Uacairocon icoinra huatama futsan matoqui oshon mato parapaifiaiton nancaifin man icoinra huashquiquin, “Unfin Cristoquin,” icaiton nancai man icoinra huai. Upa Diosin nichiamafiacun nancaifin man icoinra huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mafi ranan futsan tsain sharasi man nicapai. Asca Upa Diosin matohuunoa yoipaiyai cuscacai man shinainma. Ascacufin Upa Diosin ua nichini mancai icoinra huamisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Man ua icoinra huayamafiacun uhuun Upa Dios ointaifi un mato puashoshquin. Man shinanmisi isca huaquin, “Moisés tsain nicashu non Upa Dios fu nipatiroran,” ishon. Man anori yoifiaino Moisés aficoin matohuunoa Upa Dios yoishquin isca huaquin, “Nafoan uhuun tsain icoinra huamisifomaran,” ishon matohuunoa yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés uhuunoa cununi cuscan icoinra huashon ahuun tsainri man icoinra huacuanaquin. Uarifi man icoinra huacuanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ascafiashocai Moisés cununi cuscan man icoinra huama. Asca un mato yoia cuscaricai man icoinra huamaran, —ishon Jesús nocon niaifofo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Ascano ato yoiquin anaititan Jesús afanan no fu ian ahuun anu Galilea pocufaini cani. Ahuun anu futsa Tiberias. No fu cusumunri noco ano yorahuanrasi aqui funifo. Isinin imisifo aqui fuafoan ahuun tsainmansi ato caya huani. Ato caya huaiton oincani aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Nocon caifo Israelifoan nocon fusititian Diosin ahuun nai oinmatinin nocon shunifo aton furu iyoafofosi finonmani nanonfoma. Nan shafan nocoti chaima. Nantianri Jesús cusumunri nocoshon nonfin afu rafumisifori machi ano caashu nanno non tsaoyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Nanno non tsaoano yorahuanrasi funifo. Aqui fuaifoan atoquiri fusoshon Jesús oinni. Ato oinquin shinantani nan yorafo fonicoincani. Ahuuscashomain ato pimaicain afifin tapiniquin. Ascashon Feliperifi icoinra huamapaini ahuuscashomain ato pimaicain. Ahuun tsainmansi ahuamamishti atiro tapimapaini. Ascano Jesús Felipe yocani, —¿Raniamun non tushu fiicai na yorahuanrasi pimashquin? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nicaquin Felipe cumani, —Ifon, non siete oshu yonoshon pui fiiyonon. Aticai itiromaquin na yorahuanrasi non piimaino, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Ascano non Jesús fu rafumisifo futsan Andrés nan Pedronun ushton yoini, —Ifon, oinpon. Nuno furonanfacu misi uhuapamashta mucu fustiti yafi shiman rafuri uhuapamashta. Ascafia nuno yora ichaparasi. Ahuun tushu itiromaran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ascaino Jesús noco yononi isca huaquin, —Ato yoihuu tsaononfo, —ishon yoini. Nannorifi faasifo ini. Ascaino Jesús ato yoia cuscan faasi camaqui tsaohuacunifo. Cinco mil nocofunufocuana tsaohuacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ascano tsaoafono Jesús mucu fustiti misi fitan Apa Dios yoiquin isca huani, —¡Aicho! Upan, min ua nicaran, —ishon Apa Diosin yoini. Yoitan misi yafi shiman rafu tucupacutan noco inanni. Anoshon non ato pashcashonpacunon. Ficashon picani maiancoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ascano nantifi yorafo maiancoianfono Jesús noco yononi, —Nan misi yafi shiman tushu huafo fiitacahuun. Shihuati muran nanutacahuun ahuashta funononma, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ascaiton nicashon misi yafi shiman tushuafo non fini. Doce shihuati non fospi huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ascan Jesús ahuun tsainmansi shiman rafu non mucu fustiti misi nantifi cinco mil nocofunufo piimaiton oincashon yoinifo, —Iconcoin Jesús Diosin ahuun tsain yoimisi. Nanton Upa Diosin noco yoiyotiani cuscan nancoin nocoqui nichiaran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ascaiton Jesús nan shinainfo cuscan onanshon ahuun nomuran shinanniquin isca huani, —Na yorafoan ua curushcain aton niaifocoin ua imashcaniran, —ishon onanni. Ascatan atomaquinoashu arusu machi ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ascano man fari caino non afu rafumisifo non afu shashon nanufaini ian pocufaini foi. Pushurasi Capernaum ano non nocopaini. Faquishiaino Jesús nocoqui nocoataima. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Fuuhuan nocoano ian fuchoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ian mahuan naisti chainhuan nushmancayashon fuchomanhuaquin oquiri cusha futsan noco catima huani. Jesús ian fuman cayan ofiaintocai non onannima. Onantama non mustairicoinni. Ascashu non fasi ratucoinni. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ascaiton, —Unquin. Ratuyamacahuun, —Jesús noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ascaiton nicaquin, —¡Aicho! Shasho muran nanuyohuun, —non huani. Jesús nanuano samamashta nan non nocopaiyaiquiri ian cusumunri non noconi. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ascano iyoconaino yorahuanrasifoan nan Jesús ato pimaitafoan shinannifo Jesús arus fusti nituaiton. Oinnifo Jesús no fu shasho muran nanuyamaiton. Tapinifoma arifi chipo yamu nocoqui noconi. Nantianri shasho fustiton non afu rafumisifo non foni. Ahuuscashucon Jesús caimun ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nantianri Tiberias chaimanoashu shashorasi muran fuafo. Nan Jesús yorahuanrasi pimaita anoashu funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ascan nan yorahuanrasifoan Jesús norifi non afu rafumisi anoma tapicanashu shasho muran nanuinifoancatan Capernaum ano Jesús funai fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Fuchicashon yoinifo, —¿Tapimamisiton, ahuutiancon min nuno nocoamun? —ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ascaiton ato cumani, —Iconcoin un mato yoi. Tsoan atiroma cuscan un mato ismafiaiton mancai afohuunoa shinainma. Ascacucai man ua funaima. Uaricai man icoinra huataima. Nan un mato tushu pimafaita nantifi man mayancointan. Ascano man afanan ua funai fua un mato pimanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Shinancapon. Manfin tushuhuunoasi shinanfafainicain. Nan tushu chacanatiro manmain cuyoifin. Ascan nan cuscara tushu fusti fuchipaiquimarocon nan cuscara futsafin unquin. Unfin Diospan Facuquin, un mato inantiro nancai fuchipaicahuun. Nan cuscara cuyopacunacama. Nan piashu man nipasharatiro. Uhuun Upa Diosin ua catoanshu uqui unimamisi. Matoquirifi ua nichini na tushu cuscara un mato inanon, —ishon ato yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nicacaquin yoinifo, —¿Ahuuscashomain norifi non yonoshotiroquin Upa Diosin nocoqui unimanon? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Upa Diosin ua matoqui nichini. Ascan man Upa Diosin unimamapaiquin ua icoinra huacahuun, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Diosin tsain cununi isca huaquin, —Tsoa futsan atiroma cuscan huafain Moisés ato tushu fariña cuscara fatan shara ato pimani. Nan tushu shafatifi nai murannoashu pacupaoni. Nan tushu ahuun anu nocon tsainman manán. Nanfo nocon shunifoan tsoa istaipamashon piinifo. Ascan mirifi tsoan atiroma cuscan noco ahuamamishti ismahuu Upa Diosin mia nichini non mia icoinra huanon, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Un mato iconquin yoi man tapinon. Moiséscai nan tushu ahuun anu manán nocon shunifo inannima. Upa Diosin nai muranshon tushu ato niriashoni picanashu niisharanonfo. Ascan natian Upa Diosin ahuun tushucoin nai muranshon mato inanpai. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nocofunu Upa Diosin nai muranshon mai ano nichini manifotifi ato nimapacunon. Nanfin tushucoinquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Ifon, nan tushu noco inanfafainpun, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ascaiton Jesús ato cumaquin, —Unfin nan tushucoinquin. Tsoan fonicoin cafiscai ua onancoinpaiquin ua tanaino aton nomuran fucashtamarocon isharapacunaca. Nanscarifiai tsoan nomicoin cuscara ua fasi fuchipaitan ua icoinra huacun un ato nimapacunaca. Acai afanan funopacunacama. Isharapacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ascafia un mato yoia cuscan ua oinfiashocai man ua icoinra huaima. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nan ratoranfo uhuun Upa Diosin uqui nichiafin uqui fucaniquin. Ascan nanfofin un ato cushusharapacunacaquin. Un ato potapacunacama. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","39","Uhuun Upa Diosin ua isca huaniquin, “Tsoan un mia ya imapaiyai mifu ishqui funopacunacama. Nan mia icoinra huafo namisifo min afanan nai ariashu mai ano fotoaino funishcani no fu ipashquin. Nanscara un fuchipairan,” ishon Upan Diosin ua yoini. Ascan uficai un apaiyai cuscan un huaima. Un mai ano fotoni Upa Diosin ua amapaiyai cuscan huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nan ratoranfoan un Diospan facun ua icoinra huaashufin no fu Upa Dios icari ipasharatiroquin. Un afanan mai ano oaitian a namisifo un ato funimashquin ufu nipasharanonfo. Ascarafin uhuun Upa Dios fuchipaiquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","—Unfin tushu cuscara un nai murannoashu oniquin. Un yora imapacushquin, —ishon yoini. Ascaiton nocon caifo Israelifoan nicafiacashocai icoinra huanifoma. Jesusqui tsain chipunifo. —¡Cuu! ¡Nicacapon! Aafin Jesusquin. Apa José ahuari non oinmisi. Ascan aacai ahuama. Galilea anoashufin cainniquin. Ascanfiashon, “Un nai murannoashu Diosin icariashu fotoaran,” noco huaiquin. Tsoancai na tsain icoinra huatiroma, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ascaifoan Jesús aton nomuran shinainfo cuscan onanshon ato yoini, —Uqui tsain chipuyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Icon Upan Diosin ua nichini. Ascanfiacai tsoan Upa Diosin aton nomuran shinanmayamainocai ua icoinra huatirofoma. Ascan un afanan nai murannoashu mai ano nasoaitian ua icoinra huafoti un funimashquin Upa Dios fu ipanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diospan tsain yoimisiton ahuun tsain cununi isca huaquin, “Upa Diosin afincoin yorafo ato tapimashquiran,” ishon cununi. Ratoranfoan Upa Dios nicaifoanfin ahuunshon tapicaniquin. Upa Dios nicacashonri uarifi icoinra huashcaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tsoancai Upa Dios oinmisima. Urus fustifin un Upa Dios oinmisiquin. Nanton ua nichini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Unfin mato iconcoin yoicain. Tsoan ua icoinra huai Upa Dios fu nipashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Unfin nan tushu cuscara. Ua icoinra huafoti un ato nimapacushquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nocon shunifo Moisés fu tsoan istaipama ipaonifo. Nan tushu ahuun anu manán fipaonifo pishcaquin. Pifiapaonishacaquin fari futsa nai cuyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Ascafia un nai murannoashu Uhuun Upa Diosin icariashu un oni. Unfin na tushucoinquin. Tsoan ua icoinra huashu nipanaca. Nan tushu ahuun anu manán nai murannoashu pacua nocon shunifoan pifianicai ato nimapacumisima. Nantian Upa Diosin afanan tushu nai muranshon mai ano fotomani. Nan tushu piashu yora nipatiro. Unfin nan tushuquin. Un nantifi yora manifoti ano ato nashoshquin nipasharanonfo, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ascaiton nicacani nocon caifo Israelifo fochishmanantanannifo. —¿Ahuuscashomun na nocofunun ahuun nami noco inantiroquin non pinon? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús ato yoini, —Iconcoin un mato yoi. Unfin Diospan facuquin. Man uhuun nami piyamafain uhuun imi ayayamashu man nipatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ratoranfoan uhuun nami pifain uhuun imi ayafain ufu nipashcaniquin. Ascan un afanan nai murannoashu oaitian un ato funimashquin Upa Dios icari nipasharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Uhuun nami tushucoin yafi uhuun imi ayaticoin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ratoranfoan uhuun nami pifain uhuun imi ayai ufu rafupacunaca. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nan uhuun Upa nipanacaton ua nichini. Urifi ahuunoashu un nipanon. Ascano tsoaran ufu rafucacaini uhuunoashu ipasharatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Afanan un mato yoi. Nocon shunifoan nan tushu ahuun anu manán piinifo. Nan pifiapaonishacaquin nai cuyonifo. Ascan Upa Dios ariashu un matoqui oni. Unfin ahuun tushucoinquin. Tsoan ua piashucai nanacama. Uhuunoashu nipasharatiroquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nocon caifo Israelifoan nocon ichananti pushu muranshon ahuun anu Capernaum anoshon nan tsain noco yosini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Atirifi tanamisifoan yoini, —¡Ohua! Jesús noco yoia cuscacai tsoan tapitiroma. Noncai na cuscara tsain nicapaitiromaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","62","Ascaiton Jesús onanni rama noco yoia cuscan atirifi a tanamisifo nicacasmaiton. Ascan noco yoini, —¿Un rama mato yoia cuscan man nicapaimamun? ¿Afanan man ua icoinra huaimamun? ¿Nan nicai man umaqui ipaiquin raquiri man shinanshquimun ua afanan oinquin un nai muran Upa Dios icari un funicainaiton? ");
INSERT INTO mcdNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospan Yoshin Shara fustiton yora nimapacutiro. Mafiricai man nimapacutiroma. Uhuun tsainri Diospan Yoshin Sharahuunshon un mato yoimisi. Ascacufin uhuun tsain icoinra huashu man ufu nipatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ascafia man futsacai ua icoinra huaimaran, —ishon Jesús noco yoini. Noco catoaintian afincoin tapiyoni ratotomain achimanicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ascan afanan noco yoini, —Ascacun un mato yoiqui isca huai, “Upa Diosin tsoan ahuun nomuran shinanmayamaitocai ua icoinra huatiromaran,” —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ascano Jesús noco yoiai cuscan nicatan a tananmisi futsafoan potacashon afanan tanannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ascano Jesús nocori doce catonni non afu foanfafainnon noco yocani, —¿Marifi man umaqui capaimun? ¿Man ua potapaimun? —noco huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pedronun cumani, —Ifon, non rato futsacai non catiroma. Mirus fusti min noco yoitiro ahuuscashumain non nipasharatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Minfin Dios ariashu nocoqui oniquin. Min Dios cuscara shara. Nan non icoinra huairan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Un mato doce catonni. Un mato catonfiani matofu rafumisi futsan Satanás yoshin chaca ahuun nuumisiton, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nan Simón Iscariote ahuun facu Judashuunoa noco yoini. Jesús noco doce catonni. Judasrifi catonfianicun Jesús ato achimaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ascashu chipo Jesús Galilea maitio cahuancacaini ato tapimafoanfafaini. Norifi non afu cani. Judea ano non cayonima. Nocon caifo Israeli nocon niaifofoan Jesús rutupaiyaifono. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","5","Nocon caifoan fusititian tapaspaonifo. Nan fusiti nocoti chaima Jesús Judea ano catama Galilea ano nituni. Ahuun ushtofori nanno Galilea ano afu ini. Ahuun ushtocoinfofiacashon Jesucristofiacuncai tsoan icoinra huanifoma. Ascanshon yoinifo isca huaquin, —Nunoashu Judea ano catahuun. Nantifi minhuunshon tanamisifo min ato ashomisi cuscan oinonfo. Min acai cuscan min ato oinmayamaino atirifoancai minhuunoa tapitirofoma. Min ahuamamishti atiro nantifi yorafoti ismafotahuun —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Uncai ari cayoataima. Uhuun Upa ua nichiataima. Ascafia ahuutianran man capaiyaitian man catiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nan icoinra huafoma nan ua noicasmai. “Manfin chaca huamisiran,” un ato huamisiquin. Ascacun ua noicasmacani. Ua noicasmafiacaquicai mato noicasmatirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ascacun natian fusitacahuun Jerusalén ano fotacahuun. Ucai cayoataima. Uhuun Upa Diosin ua nichiataimaran, —ishon Jesús ahuun ushtofo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ato yoitan Galilea ano nituyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ascafiaino ahuun ushtofo nan fusi ishcaquin Jerusalén ano foaifoanno. Ascaino arifi chipo caani. Tsoa yoiashuma Jerusalén ano nocoaitocai tsoashta tapinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nanno nocon caifo Israelifo niaifofoan Jesús funacaquin yoinifo, —¿Ranimun na nocofunu? —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nannori yorahuanrasi. Atirifoan isca huanifo, —Jesús nocofunu sharacoinran, —ishon yoinifo. Ascafiainfoan atirifoan yoiquin isca huani, —Ma. Na nocofunucai sharama. Yorafo paramisiran, —icashon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ahuunoacai aton ointaifi yorafoan yoisharanifoma. Nocon niaifofoqui musucaquin oinomashta yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fusiti anaitiataimano Jesús Dios fu tsainti pushu muran iquini a muranshon ato yosicai. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nocon caifo niaifofoan nicashon yoinifo, —¡Aira! ¡Nicacapon! ¿Ahuuscaimun na nocofunun cunu tapicoianmafiashon tsain fasi tapicoianquin? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yoiaifo cuscan onanshon Jesús ato yoini, —Un mato yosiain cuscan uhuun nomuranshoncai un mato yoima. Ascatamarocon Upa Diosin ua nichini, nanton ua shinanmana cuscan nannoricoin un mato yosiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tsoan Diosin yoia cuscan apaiquin afi tapitiroquin ufi shinain cuscan un mato yosi iyamarai Upa Diosin afi ua shinanmanaino un mato yosia. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tsoan ahuun nomuran shinain cuscan yosiquin nanton yorafo ahuunoa shinanmapai isca huaquin, “Na nocofunun fasi tapicoian. Afin fasi sharacoinquin,” ishon ahuunoa ato shinanmapai. Ascanfiatan uncai ascarama. Un mato yoiqui isca huai. “Nan uhuun Upa Dios ua nichini. Nancaifin fasi sharacaiquin.” Anori un mato yoimisi ahuunoa man shinansharanon. Nanscacufin man icoinra huatiroquin un mato iconcoin yoi un yorafocai paramisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nocon shuni Moisés mato Diosin tsain yonofiani tsoashtacai nicasharamisima. Ascacufin ahuuscain man ua rutupaiyain un nocofunu tunutitian cayahuafiacun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—¡Cuu! ¿Tsoantsi mia rutupaiquin? Minhuunfin yoshin chaca nuuaquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Un nocofunu tunutitian caya huaiton man oinquin. Ascan “¡Ajaa! Ahuuscain Jesús tunutitian nocofunu caya huamamun,” ishon uhuunoa man yoia. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Un tunutitianfiacun ahuara shara huaa cuscan marifi tunutitian ahuara man huamisi. Moisés noco yononi cuscan manfin maton furonanfacufo rama caian ocho osha finoanno maton furonanfacufo man ato foshqui rupa shatumisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ascan tunutitianfiacun maton furonanfacufo man ato foshqui rupa shatumisi. Ascafia Moisés yononi cuscan man aima. ¿Ascacufin ahuuscain man uqui sinai tunutitianmain un nocofunu caya huasharacunfin? ");
INSERT INTO mcdNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Afanan un ahuara shara huaiton oincaquin, “Chaca huaran,” ua huayamacahuun. Cayacafi shinansharacahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ascatan atirifi Jerusalén anoashu yoinannifo, —¿Naamun nocon niaifofoan rutupaiafo? ");
INSERT INTO mcdNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ascanfiacanashu yorahuanrasi aton ointaifi ato yoifiaquicai tsoan ahuun tsain shatumanama. Ascacuri natian niaifofoan man shinanraca aafin nocon Numamisi Cristoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ascafiancai Jesús nocon Numamisi itiroma. Nocon Numamisicoin oaiton non tapitiroma raniashumain oicain. Ascan nan nocofunu Jesús raniashu oamainquin man non tapiaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús Dios fu tsainti pushu muranshon ato yosifiatan ahuunoa yoiafo cuscan onancoinshon ato cumani isca huaquin, —¿Iconmun man ua onan? ¿Un raniashu oamainquin man tapiamun? Ufi shinanfaincai un oama. Ascafia uhuun Upan ua yonoa un oa. Nantofin ua nichiniquin. Nanfin iconcoinquin. Mancai uhuun Upa onanmisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Un ahuunoashu oni. Ua nichini. Ascan un Dios onancoianran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nicacani aqui sinanifo. Ascashon achipainifo cunu muran iquimashquin. Ascafiaquicai tsoan ahuusca huayonima. Nantiancai achiaifotian nocoatai inima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nan yorahuanrasi Jerusalén anoafoan yoinifo, —Tsoa futsan atiroma cuscan Jesús Diosinhuunshon ahuamamishti shara noco isma. Nan nocofunun tsoan asca huatiroma cuscan huatiro. ¿Nocon Numamisi oshon finonmafain ashquimun? —ishon yoinifo. Ascan anori yoiaifoan icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nan yorahuanrasiton Jesushuunoa tsain shara yoiaifoan Fariseofoan nicanifo. Ascan nocon caifohuunshon Dios cufimisi niaifofoan futan ranushumuafo nichinifo Jesús achicashon cunu muran iquimanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ascan Jesús ato yoini, —Un matofu ichaipacuima, Un samamashta uhuun Upa Dios ari cai. Nantofin ua nichiniquin. Un samamashta aqui cai. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Un mato anoashu caitocai man ua funafiaquin ua fuchishquima. Un cai aricai man catiromaran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ascaiton nicacani nocon caifo Israeli niaifofo yoinannifo, —¿Ranimun na nocofunu caiquin noncai fuchitiroma? ¿Nocon yorafo Grecia pushurasi ano pashcafainnifo ano caimun? ¿Nanno Greciafo tapimaicairaca? ");
INSERT INTO mcdNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Raquiri noco yoimun isca huaquin? “Man ua funafiaquicai man ua fuchishquima. Uncai aricai man catiromaran,” ishon noco yoia. ¿Raquiri noco yoipaimun? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","39","Ascano fusitin ahuun unutaquin Jesús yorahuanrasi muran ninacahuan oi ashcafinin ato yoiquin isca huani, —Nicacapon. Un mato yoinon. Diosin mato yonomapaiyai cuscan man huashopai uqui fucahuun. Ua icoinra man huacun un mato Diospan Yoshin Shara mato ya rafumapacunaca. Tsoan ua icoinra huaiton Diospan tsain cununi cuscan ahuun shaqui muran unu tsosia shara cuscara a muran foiran, —ishon Jesús ato yoini. Unucoinhuunoacai yoinima Diospan Yoshin Sharahuunshon ato tapimani isca huaquin, —Tsoan ua icoinra huaiton Upa Diospan Yoshin Shara afu rafupacunaca. Ascan Diospan Yoshin Sharahuunshon ahuun nomuranshon yorafo yoishquin afoanrifi icoinra huacanashu nipasharanonfo, —ishon ato tapimani. Jesús apa Dios ari nasoataima yorafoan aton niaifo inon. Ascan nan icoinra huafoti Diospan Yoshin Shara atoqui nichiataima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nicacashon atirifoan yoinifo, —Iconcoin na nocofunu Diospan tsain yoimisiran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Atirifoanri yoinifo, —Naanfin Cristoquin, —ishon yoinifo. Ascafiaino futsafoan yoini, —Ma. Nacai Cristoma. Cristocai Galilea anoashu cainshquima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diospan tsain cununi cuscan, “Cristo David funa inon. David ipaoni nannoashuri Cristo cainshquiran,” ishon Diospan tsain cunushoni. Ascan Cristocai Galilea anoashu caintiromaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nanscafiacun nan yorafoan Jesushuunoa nicafiacashocai anorifosi shinannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Atirifoan Jesús achipainifo cunu muran iquimashcaquin. Asca huapaifiacaquicai tsoan Jesús ahuusca huaiyonima. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ascatan ranushumuafoan aton niaifofo yafi Fariseofoqui nasocashon ato yoinifo. Nocoafono nanfoan ranushumuafo yocani, —¿Ahuuscaquimun man Jesús achiamaquin noco ihuushoshquin? —ishon ato yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Cumacaquin, —Na nocofunun ahuun tsain shara cuscara tsoancai anori yoiyomisimaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","49","Ascaiton ato nicacashon niaifofoan ato yoini, —¡Cuu! Ascan Jesús matori paramisi. Shinancapon. Nonfofin Fariseofo yafi maton niaifofoanri Moisés cununi cuscan fasi non tapicoianquin. Nonfoancai tsoashtan Jesús icoinra huamisima. Na yorafoan man rama Jesús nica nanfoan Moisés Diospan tsain cunushoni cuscan tapiafoma. Diosin ato onaintimapainonran, —ishon ato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Asca huafiaifoanno Nicodemon nan shafa futsa Jesús ano cani ahuara yocaicain. Arifi Fariseonfiashon afu Fariseofo yoini, —Uhuun yorafoan, nocon shuni niaifoan yononi cuscan non ratoran nocofunun nicasharayoataima non yoitiroma isca huaquin, “Naton chaca huaa. Non onaintimanonran,” ishoncai non ascatiroma, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—Min tsain Galilea anoafoan tsain cuscarari. Shinanhuun. Tsoashtacai Galilea anoashu Diosin tsain yoimisi fuafoma. Nannoricoin Diosin tsain noco yoicoinni. Oinyotahuun tapinon, —ishon Nicodemo cumanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Anori yoicatan aton pushufoanri fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Asca huafaini Jesús machi ahuun anu Olivo ano cani. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Shafaino Dios fu tsainti pushu muran Jerusalén ano nasoni. Nanno yorahuanrasi afanan aqui funifo. Nicai fucani. Ascatan tsaoshon ato yosini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","5","Ato yosiaino Moisés cununi cuscan tapimamisifo yafi Fariseofoanri ainfo ahuun funuma fu icaiton fuchicashon Jesusqui ihuutan yorahuanrasifain ointaifi ainfo nimainifoannifo nantififain oinonfo. Asca huacashon Jesús yoinifo, —Tapimamisiton, na ainfoan fasi chaca huaa. Ahuun funuma fu icaiton fuchiafo. Moisés isca huaquin noco yononi, “Ainfo ahuun funuma fu icaiton fuchicashon toquirinin a tsacacahuun nanon,” ishon Moisés noco yononi. ¿Mirifi min nannori noco yonopaimun? —Jesús cuparananshon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Raquirirashta icaiton ahuun chaca inifoan niaifofo ano iyopaicaquin. A yocaifoanno Jesús tutishon ahuun mutotinin mai cununi. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yocariaifoanno Jesús atoqui fuhuuni inacahua yoini isca huaquin, —Man ratotonmain man ahuara chaca huamisimaquin na ainfo toquirinin tsacaqui tau huahuun, —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ascan ato yoitan afanan ahuun mutotinin mai cununi. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ascano ato yoia cuscan nicacatan nantifi nan ainfoqui tsain chaca huafo fustirasi foriforinifo. Nan iyoafofo fosi rufofo foriforinifo. Chipo atirifi cuyo fonifo. Jesús fusti nanno ainfo aqui nituano. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ascan Jesús afanan fuhuuninacahuan ainfo yocani, —Uhuun shafoshta. ¿Na nocofunufoan mia chaca huaa man foafomun? ¿Tsoa fusti nituamamun afanan mia tsain chaca huai? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Ifon. Fustishtacai nituamaran, —ishon yoiaiton. —Unricai mia tsain chaca huaima. Natian min catiro. Ascafiashu min chaca huamisi cuscan afanan asca huayamahuu, —ishon Jesús ainfo yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ascatan ainfomaqui caashon Jesús afanan yorahuanrasi yosini isca huaquin, —Unfin chashamati cuscaraquin. Un manifoti anoafo un ismasharatiro nipasharanonfo. Tsoan ua tanamisi icashucai funotiroma. Uhuunshon fai oinsharatiro Upa Dios ari noco sharashquin. Faquish muran ipashquima, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ascaiton nicacaquin Fariseofoan yocanifo, —Min noco yoiai cuscacai tsoa futsan mihuunoa noco anori yoimisima. Mirus fusti minhuunoa min noco yoiai cuscacai tsoa icoinra huatiroma, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ato cumani, —Un tapian raquiashumain un oaquin ascatari raquimain un caicain. Ascacun uhuunoa un yoitiro uhuun tsain iconcoin. Ascafia mancai tapiama raquiashu oashumain raquiriri un caicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tapishoma un yosiaiton man icoinra huama. Uncai tsoaquin shinanchacaima tsain chaca huashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ascafiacun uhuun Upan shinain cuscan nannoricoinrifi un mato yoi. Ascan un iconcoin yoimisiquin. Uhuun Upan ua nichini. Un futsahuunoa yoiquicai unrusu un yoima. Uhuun Upan ua tapimana cuscan un yoi. Ascan un futsahuunoa yoia cuscan iconcoin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés mato yononi cuscan isca huaquin cununi. “Nocofunu rafutan nannorisi yoiaiton man icoinra huatiroran,” ishon mato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ascan uficoin uhuunoa un mato yoimisi. Ascafiacun uhuun Upan ua nichini nanton uhuunoa nannorisi yoimisi, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nicacashon yocanifo, —¿Ranimun min Upa? —huaifoan. —Mancai ua yafi uhuun Upa man onanmisima. Ua onanshon uhuun Upari man onancuana, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús Dios fu tsainti pushu muranshon yorafo yosini. Nan cunu muranri nocon pui nanuti. Diosin tsain yonomisifo inanonfo. Nanno ato yoifiani tsoancai Jesús achinima cunu muran iquimashcaquin. Jesús rutuafotaima. Ascan rutushquiaifon shafan nocoataima tsoan ahuusca huayonima. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ascan tsoancai achinifoma Jesús afanan nocon caifo aton niaifofo yoini. —Un chipo chai cai. Un caino man ua funafiaquicai man ua fuchishquima. Maton chaca potayamashu nanscasiai man nai. Ascaiton un cai anori cai man catiroma, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nicacani yoinannifo, —¿Afirimun rutushquiquin? Ascashori noco yoi, “Un cai anoricai man catiromaran,” noco huaiquin, —icashu nocon niaifofoan yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ascaiton Jesús ato cumani, —Manfin na mai ano iitianiquin. Ucai mai ano ipaonima. Ufin nai muran iitianiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Un mato yoiai cuscan maton chaca potayamashu nanscasiai man nai. Un mato uhuunoa yoia cuscan icoinra huayamashu maton chaca ya man nai. Man naino maton chaca mato ya ipanaca, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Ascan minmun tsoaquin? —ishon yocaifoan. —Nan un mato yoimisi cuscafin unquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Matohuunoa un ichapa yoitiro. Man chaca huaa cuscan huafain un mato yoifiatiro nan ua nichinicai man icoinra huatiro. Afi ua yoimisi cuscan un nantio maifoti un ato yoifoanfafainon, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","28","Apa Dioshuunoa ato yoifiaitocai tsoan tapinifoma. Ascan Jesús ato yoini, —Man ua ihui coyan iquinanqui funinifoanshquiaitian man ua tapishquin umain tsoaquin. Nantianri man tapitiro uhuunoa fusticai un mato yoimisima Upa Diosin ua yoimisi cuscan nan fusti un mato yoi. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nan ua nichini ufu imisi. Uacai potamisima. Afi ua amapaiyai cuscan un amisiquin. Ascacun uqui unimacoin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yoiai cuscan nicacashon atirifoan a icoinra huancoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ascano Jesús nocon caifo nan icoinra huafo yoini, —Un mato yoiai cuscan nicacoianshufin uhuun tanamisicoin man itiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Uhuun tsain nicashon iconcoin tapishon maton nomuran man isharacointiro. Ahuara iconma afanan maton ifo inonma, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ascan Jesús icoinra huamisifoan ato yoiaiton niaifofoan nicacashon yoinifo, —Nonfin Abraham ahuun funafoquin. Tsoa futsacai nocon ifo imisima. Noncai tsoan oinmati imisima. Ascacufin ahuuscain, “Ahuara iconma maton ifo itiroma man icoinsharanon,” noco huaran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Iconcoin un mato yoinon. Tsoan chaca huamisifin ahuara chacafoan aton ifo iishquiquin. Nanrifi chacafoan aton yonoshomisi iishquiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Man man tapia ahuun yonoshomisicai ifoan pushu muran ipanacama. Pushu ifoan ahuun facu pushu muran ipatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ascan unfin Diospan Furunquin maton chaca soashonano afanan ahua chaca futsa maton ifo itiroma. Man Dios fu isharapashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mun tapia maton shuni Abraham. Man ahuun funafofiashon uhuun tsain man nicacasmai. Ascashon man ua rutupai. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Uhuun Upan amisi cuscan mun oinmisi. Nanfohuunoa un mato yoimisi. Ascan marifi maton upa mato yoimisi cuscan nannori man huamisi, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Nocon shunifin Abrahamquin, —huaifoan. —Man Abraham funafoshofin nanton apaoni cuscan marifi nanscarifi man huacuanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Upa Diosin ua yoimisi cuscan un mato icon yoifiaino man ua rutupai. Abrahamcai ascapaonima. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Maton upa acai cuscan marifi man amisiquin, —ato huaiton. —Noncai upa ichapayama. Nocon upacoin fustifin Diosiquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Unfin Upa Dios fu imisiquin. Un Dios icanoashu un oni. Ufi shinanfaincai un mai ano onima. Uhuun Upan ua nichiano. Ascan maton upacoin Diosicunfin man uarifi noicuanaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ahuuscain uhuun tsain man shafacafifiacucai man tapiama. Futsanfin mato nicatima huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nanfin maton upa Satanasquin. Ascan maton upan apaiyai cuscan marifi man huapaiquin. Aafin taui rutumitsamisi ipaoniquin. Iconcai yoimisima. Atocai ahuara icon yoimisima. Ahuun nomuran chani fusti shinantiro. Nanscashori chani fusti yoitiro. Afin chanimisicoinquin. Chanimisifoan aton apacoin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Uncai a cuscarama. Un mato iconcoin yoifiaiton mancai ua icoinra huaima. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ratoran futsamain un chaca huaa yoitiroquin? Uncai chaca huamisima. ¿Un mato icon yoifiaitocai ahuuscaquin man ua icoinra huaimacain? ");
INSERT INTO mcdNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ratoranfoan Diosin ahuun yoracoin ahuun tsain nicatiro. Mancai Diosin ahuun yorama. Ascan uhuun tsain man nicaimaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nicacashon nocon caifo Israelifoan cumanifo, —Icon man non yoimisi. Minfin Samaritanonquin. Yoshin chaca mihuun nuumisi, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Yoshin chaca uhuun nuumisima. Un uhuun Upa Diosihuunoa tsain shara fusti yoimisifin unquin. Manfin uhuunoa tsain chaca yoimisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ascanfiatan mancai uhuunoa yorafo tsain shara yoipaimisima. Upa Diosin fusti iconcoin yorafohuunoa tsain shara yoitiro. Uhuunoa yorafo yoisharamapai. Nantonri yoitiro ratofomain shara iyamarai chacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iconcoin un mato yoinon. Tsoan uhuun tsain nicacoianfin nacointamarocon nipanacaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Natian man non tapicoin minfin yoshin chacayaquin. Abraham non Diosin tsain yoimisifori man naafianicun min noco yoia, isca huaquin, “Tsoan uhuun tsain nicacoianshu nacointamarocon nisharapacunacaran,” ishon min noco yoia. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nocon shuni Abraham non Diosin tsain yoimisifori man nani. ¿Ascan min Abraham finoncoianmun? ¿Min shinanmun min nantifi finoan? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Unfincoin un uhuunoa yoisharainocai ahuama. Upa Diosin fustitofin uhuunoa yoisharamisiquin, “Nanfin nocon Uparan,” man huamisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mancai uhuun Upa Dios onanmisima. Ascafiacun unfin uhuun Upa onancoianquin. Uhuun Uparan un iyamafin Un mato cuscara chanimisiri icuanaquin. Ascatamarocon un Upa Diosin onancoian. Ua yoiai cuscan un huamisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Maton shuni Abraham, yoini, “Un chipo Cristo ointiro. Oianshu un fasi unimashquinran,” ishon yoini. Ua oinni ascan fasi unimani, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—Mincai cincuenta fari icataima. ¿Ascan ahuuscashomun min Abraham oinmisiquin? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Iconcoin un mato yoinon. Abraham caiantaima unfin iyopaoniquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ascaiton nicacani nocon niaifofo fasi sinacoincaquin toquiri ficatan Jesús tsacapainifo rutupaicaquin. Ascan huapaiyaifono Jesús ato murannoashu cani. Dios fu tsainti pushu murannoashu atomaqui cafiaitocai tsoan oinnifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús caaquin oian nocofunu fusho nanscarapan caini oinni. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ascaiton non afu rafumisifoan yocatoshini. —Tapimamisiton, ¿Ahuuscaimun na nocofunu fushoquin nanscarapan caini? Ahuara chaca huamisishaquinraca fusho cainni. ¿Ascayamarai apa futan ahuan chaca huamisianoraca fusho cainimun? —ishon non Jesús yocani. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ascaiton Jesús noco yoiquin isca huani, —Ahua chaca huayamafiamisishaqui afincoin fusho cainni. Apa futan ahuan chaca huanocai fusho cainnima. Nanscarapan cainnicun chipo Diosin ahuamamishti huatiro cuscan ahuunoa ismashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Diospan ua nichiniquin non yonoshononcahuun. Non shafata fusti yonoshotiroquin. Yamucai non yonoshotiroma. Nanscarifiai ratoran shafatan nocoqui nocoano afanancai tsoanshtan na mai anoshon Dios yonoshotirofoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Un na mai ano iyoashufin un shafa cuscaraquin. Un ato oinmani ahuuscashumain isharatirofoquin, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Asca huatan maiquin cumo michotan. Miscoacufoantan ayashon futucurani. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Asca huatan, —Siloé carayanun nashitahuun, —huani. Carayan ahuun anu futsa —Nichiaran —yoimisifo. Asca huaa caashu nashianan fuchocomutan oinsharacufainiquin. Ascatan naso curani. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nan oinmisifoan isca huanifo, —¿Nan fusho tsaoashu ahuara yocacaiton non oinmisimun? ¿Na nancaimun? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ainfain. Nanfinquin, —atirifiton huanifo. Atirifiton yoicaquifin, —Aamafinquin. Nan ointsacoinfinquin, —huanifo. Afiri ato yoini, —Unfinquin. Unfin fusho imisiquin. Ascafiashofin natiantan un oinsharaiquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Ahuuscashomun min natian oincain? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Na nocofunu Jesusran huaafoanfin ua maiqui cumo michotan a yashon ahuun mucuman ua futucuracaquin. Ascashufin “Siloé naquinoashu nashitahuun,” ua huaano. Siloé carayanun nashianan un fuchoquimushofin un oinshara acufainnaquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ascaiton, —¿Ranimun na nocofunu Jesusquin? —ishon yocaifoan. —Un tapiama. Raquiran man caaran, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ascano Fariseofo icano nan nocofunu iyonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús nan nocofunu tunutitian cayahuano. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseofoan nan nocofunu yocacaquin, —¿Ahuuscacai ashumun min furo cayaquin? —huaifoan. —Ua maiquin cumo michotan ayashon ua futucuraca. Nashianan fuchoquimushofin un oinshara acufainnaquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nicacaquin Fariseo atirifoan isca huanifo —Acaico Dios ariashu ocufin tunutitian yora cayahuama, —huanifo. Ascaiton atirifiton yoiquin isca huani —Yora chacapancai naton acai cuscan huacuanamaran, —ishon atirifiton yoinifo. Ascaiton atirifoan shinancaquin, —Jesuscai sharama, —huaifono. Atirififain, —Jesusfin sharaquin, —huanifo. Jesushuunoacai nannorisi shinannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ascaiton afanan a nocofunu fusho cainni yocacaquin. —¿Minmun ahuuscacai aaqui na nocofunun mia cayahua? ¿A mia furo cayahuamamun tsoanquin? —huaifoan. —Naantofin inon pacoai cuscan huafain Diosin tsain yoimisiquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ascaitoncai nocon niaifofoan icoinra huanifoma nan fusho nanscarapan cainni. Ascaiton fushon apa yafi ahua cunashon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Nan na aamun min facu fusho caini? ¿Ascafiashomun ahuuscashon natian oinquin? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Nanfin nocon facuquin. Nanscarapan cainni. Nan non tapiafin nocon facuquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ahuuscashomun oinquin noncai tapiamafinquin. Ahuuscashumain cayaquin. Facumafinquin. Manfin nocofunuaquin. Afifin mato yoitiroquin ahuuscashumain cayaquin. Nan yocacahuun, —ahua futan apan ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nocon niaifofoquin musucaquin anori yoinifo. —Tsoan “Diosin Jesús catonniran,” huacai nocon ichananti pushu muran afanan iquitirofomafinquin, —niaifofo icaiton nicai ahua yafi apa atoqui musunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","—Afanan facumaquin, Nancoin yocacahuun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ascano afanan a nocofunu fusho ipaoni yoimashon yoini, —Yoihuu. “Diosin ua cayahuaran,” ihuu. Jesuscaicon sharacufin. Chacafinquin. “Diosinfin sharaquin,” huahuu. “Jesús shararan,” huayamahuu. Non tapiafin Jesús chacaquin, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Utsan. Uncain tapiama chaca iyamarai sharamainquin. Un tapia fustifin un fusho iyofiamisishaquin natian un oinsharaicain, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Ahuusca huafainmun mia cayahuaquin? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Munfin mato yoifiashucai mato yoia cuscan man nicapaima. ¿Ahuuscaquin man afanan ua yocainmun? ¿Marifimun ahuun tanamisi man ipaicain? —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Fasi roaquin futsanifo. —Minfin ahuun tanamisiquin. Nonfofin Moisés tsain tanamisifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Non tapiafin Diosin Moisés fu tsainpaoniquin. Noncai a Jesús tapiamafinquin. Tii ahuu cuscararanfinquin a nocofunucai non tapiama, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Choon. Mancai tapiamafinquin raniashumain Jesús oshon. Un fushofiacun ua cayahuamaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Non tapiafin yoran chaca huamisicai Diospan nicapaitiroma. Ratoran Diosin tanasharafain yoia cuscan aitonfin nanscarafo Diosin nicatiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nan Diospan mai onihuani chaincai ascaran nocofunun fusho caya huaa non nicaiyomisimafinquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Upa Diosin na nocofunu Jesús nichiyamanicai ahua ahuusca huacuanama, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nicacani fasi aqui sinanifo, —Minfin chacacoin cainiquin. ¿Ascan ahuuscaquimun min noco tapimapaicain? Min chacashunifiashon. Nocon ichananti pushu muran min afanan iquitiroma. Nunoashu cariscatahuun. Noncaicon mia afanan oinpaiyaintonfin. Afanan nuno iquicuranyamahuun, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ascaiton fusho ipaoni aton ichananti pushu muranshon potaifoan Jesús nicani. Ascashon funaquin fuchini. Fuchishon yoini, —¿Minmun na nocofunu Dios ariashu oni icoinra huaicai? —ishon Jesús yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Tsoanmun na nocofunuquin? Ua yoihuu urifi un icoinra huanon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Nan min ufu tsaincaifin unquin, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nicatan, —Ifon, unfin mia icoinra huaicain. Min fasi sharacoin. Un mia noi. Un mia Ifoai. Min Diospan Facuran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ascano nanno niafo Jesús ato yoini, —Uhuun Upa Dios icariashu un nuno mai ano oni ratofoanmain ua icoinra huayamaino ua icoinra huacanicain un puashoshquin. Ascan tsoa Upa Dios fu ipaifiaquin tapiama ahuuscamain atiroquin nanfo fusho cuscarafiashon ua icoinra huaashucai afanan fusho cuscara itirofoma oinsharatiro Upa Dios fu ipashcaquin. Futsafoan shinancaquin tapisharafiashocai tapisharafoma. Ua icoinra huayamaifo. Nanfo fusho cuscaracoin. Funoshcaquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nanno Fariseofo Jesús yoiai cuscan nicacashon a yocanifo, —¡Cuu! ¿Min noco yoimun non fushocun? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ato yoiquin, —“Nonfin fusho cuscarafoquin. Man non funoa. Non chaca huamisiran,” ishon man yoiaiton un maton chaca soashocuana. Mancai ascatamarocon, “Nonfin oinsharatiroquin. Noncai funoama. Nonfin sharaquin. Noncai chacamaran,” man imisi. Ascan maton chaca soatama man funocoianshu Upa Dios icano nocopacunacamaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ascatan Jesús ato tapimani nanmain aton cushumisicoinshofin. Chashoan cushumisiton ahuun chashoanfo cushutiro. Nanscarifi aquin Jesús ahuunshon icoinra huafo cushucointiro. Nannori Jesús ato yoini isca huaquin, —Iconcoin un mato yoinon. Pasoatoshon yoran chashoanfo cunushotiro iquimashquin raqui fononfoma. Nan cunu caincaiti ya. Ascan tsoa caincaiti murannoashu iquitama pochininnoashu iquiafin nan yomutsoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ascan nan tsoa caincaiti cunu muran iquimamisifin nancaifin ato cushumisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Caincaiti ano nocoaiton nan nocofunun caincaiti cushumisiton fupushotiro chashoan cushumisiton iquimapacunon. Ascan chashoan cushumisi iquiaiton ahuun chashoanfoan ahuun oi onanti huanifo. Nantifi ahuun chashoanfo anu futsapacuni. Aton anun cunapacuaino chashoanfoan mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aton cushumisi rucun caino chashoanfoan cunu muranshon mufainifo. Ahuun oi onancoincashon mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Futsan cunafiaitocai chashoanfoan ahuun oi onannifoma. Ahuun oi onainyamacani amaqui ichotiroran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús ahuunoa ato yoifiaiton tsoan tapinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ascano Jesús afanan ato shafacafi yoini, —Un mato iconcoin yoinon. Nan chashoanfo cunu muran iquipaicani shoi fusti muran iquitirofo. Unfin nan shoi cuscaraquin. Tsoa Upa Dios icano iquipai uhuunoashu fusti ari iquitirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Un matoqui nocoataima futsafoanri yoia isca huaquin, “Un mato tapimatiro ahuuscashumain Upa Diosqui man nocotiro afu nipashquin,” ishon yoifiamisishacaquin afoancaifin paramisifoquin. Yomutso cuscarafo. Diospan yora parapaicani ato yonomapai. Asca huapaifiainfoan Diospan yorafoancai na cuscarafo nicapaicanima. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Unfin na shoi caincaiti cuscaraquin. Tsoa Upa Dios icano ipapaiquin uhuunoashu fusti ari iquitiro afu ipashquin. Natianri uhuunoashu isharatirofo ahuatocai aton nomuran fucash huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Futsafoan uhuun yorafo parapaicani. “Ua tanacahuun. Un mato tapimasharanon,” ishon ato yoifiaquicai nanfoanfin uhuun yorafo umaqui imapaicani. Yomutso cuscarafo. Ua icoinra huafo shara huapaicanima. Ato shara huatamarocon ato chaca huapaifain ato rutupaicani. Asca ato huafiainfonocai un ascarama. Ua tanamisifo un ato imasharafain un ato unimamashquin. Nanscaifin un oniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","13","Ua icoinra huafo chashoan cuscarafo. Cushumisi yopacani. Unfin nan chashoanfo cushumisi shara cuscaraquin. Ascan na nocofununcai chashoanfo ifoshomacai ato cushusharama. Chashoanfo futsan cushumashofin ifoan aton pui inantiroquin. Ascan chashoanfohuunoa shinantamarocon pui fusti shinain. Ascaino masharo chashoanfoqui nocoaino nan cushumisi futsan ato cushusharatama ato potafaini ichotiro. Shinanquin isca huatiro, “Na masharo fasi musucoin. Nan chashoanfocai uhuunacoinmafinquin. Ascan na masharonun ato piquin nanscanon. Uncai ahuusca huatiroma un ato numapanan. Unfin atomaqui ichoicaicain masharonun ua ahuusca huanonma,” ishon shinantiro. Chashoanfoan aton ifocoincai ascatiroma. Afifin ahuun chashoanfo cushusharatiroquin masharonun ato pinonma. Shinantiro isca huaquin, “Uhuun chashoanfohuunoashucaifin un natiroquin. Nanfocairocon ahuuscanonma,” ishon shinantiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Unfin na chashoanfo cushumisi shara cuscaraquin. Cushumisinin ahuun chashoanfo onancoin ato cushusharamisi. Urifi ua icoinra huafo un ato cushusharamisi. Uhuun Upa Diosin ua onancoin. Urifi uhuun Upa un onancoian. Nanscarifiai ua icoinra huafo un ato onancoin. Nanfoanrifi ua onancoincaniquin. Un atohuunoashu naashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yora futsafoanri ua icoinra huashquicani. Afocai Israelifoma. Nanforifi un uhuun Upa icano iyotiroquin. Nanfoanri mai ano niyocashon ua nicasharayoshcani. Ascan Israelifo yafi mani futsafoanri ua icoinra huacanashu fusti cuscaracoin iishcaniquin. Nantifi nan icoinra huafoti Upa Diosin yorafo iishcaniquin. Urusu fusti un aton cushumisi un iishquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Un ato cushusharashu un atohuunoashu naashquin. Ascan uhuun Upa Diosin ua noiaino naashu un afanan funishquin nipashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ua icoinra huafohuunoashu napaiyamainocai tsoan ua namatiroma. Uhuun Upa ua yononi cuscan un atohuunoashu naicain. Uhuun Upa Diosin ua yononi cuscan un atohuunoashu nayofiashu un afanan funitiro nipashquin, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nicacashon atirifi nocon caifoan icoinra huaifoanno atirifoancai tsoan icoinra huanima. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Atirifoan yoiquin isca huanifo, —Aafin nisocoinquin. Yoshin chaca ahuun nua. ¿Ahuuscaquitsi non na nocofunu nicatiro? —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Atirifoanri yoini, —Aacai yoshin chaca ahuun nuama. Yoshin chacanuncai nocofunu fusho afanan oinmatiromaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","24","Ascano Jesús nocon caifo Dios fu tsainti pushu Jerusalén ano non cani. Oi pacutian non cani. Nanno tapasi uhuaparasi muran fonifo. Nantianri nocon caifo Israelifoan nocon fusitin ahuun anu tuqui huani isca huaquin, —Dios fu tsainti pushu onihuashararan, —ishon anuni. Nanno pushun facu ahuun anurifi tuquihuani, —Salomonran, —huanifo. Nannori Jesús ini. Nocon caifo niaifofo aqui funifo a yocacani. —Minmain Cristoquin nocon shafacafi yoihuu. ¿Ahuuscaimun min noco shafacafi yoiyamacaiquin? ¿Ahuutiatsi min noco shafacafi yoicain? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Un mato yoifiamisicun man ua icoinra huaama. Uhuun Upahuunshon un yorafo tsoan atiroma cuscan un huafafaini. Nanfo un mato isma unmain Diospan Facushofin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ascafia mancai Upan Diosin ahuun yorama. Man ua icoinra huama. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ua icoinra huafoan ua nicasharatiro. Un ato onancoianno ua tanafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","30","Omitsiscapanacafo muran focanima. Ua tanaifocai ari fonacafoma. Ascatamarocon un ato Upa Dios ya imapacunaca. Upa Diosin ato ua inan. Upan nantifi finoncoian. Upa Dios fu un fusti cuscaracoin. Ascancunfin tsoancai ua tanamisifo unmaqui yafi Upamaquiri imapacunacamaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nicacani afanan Israeli niaifofoan toquiri uhuapa ficatan Jesús tsacapainifo rutupaicaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Asca huafiaifoan Jesús ato yoini, —Upa Diosihuunshon tsoa futsan atiroma cuscan un mato ismafiamisi. ¿Ascan ahuanhuunshocaimun man ua toquirinin tsacaicain? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Nanfohuunshocai non mia toquirinin tsacaima. “Tsoa futsacai Diosima,” anori Diosin tsain cununi. Minrifi nocon cuscara nocofunuquin. Ascanfiashu mian yoia mirifi Diosiran min icaquin. Ascan min Dios chaca huai. Ascacufin non mia toquirinin tsacaicain, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","—Diospan tsain mato cunushoni isca huaquin, “Un mato yoi manfin Dios cuscaracoinfoquin,” ishon ato yoini. Diosin yoini cuscacai tsoan, “Chaniran,” huatiroma. Ascan nan Diosin anori yoiaino ahuuscain man yoiai “Un Dios chaca huaran,” ishon. Nantofin ua catonshon nai arishon nuno mai ano ua nichiniquin. Ascancunfin un icon yoitiro unfin Diospan Facuquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Mancai ua icoinra huaima. Uhuun Upan Diosin aca cuscan un huayamaiton ua icoinra huayamacahuun. Ascafiaquin uhuun Upa acai cuscan urifi nanscasi huaiton ua icoinra huacahuun. Uhuun Upan acai cuscan urifi nanscasi un huaiton man tapitiro Uhuun Upa ufu ica. Unrifi uhuun Upa fu un icaran, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nicacashon afanan Jesús achipaifiainfoanno atomaquinnoashu caitocai tsoan achinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Atomaquinoashu cai unu Jordán ari cani. Nannoshon Juanpan tau huaquin yorafo unu muran iquimapacuni. Nanno chaimashta Jesús iyoni. Unu cusumunri iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ascaino yorafo aqui fucashon. Yoinifo isca huaquin, —Jesús Diosihuunshon ahuamamishti noco isma. Juanpacai asca huamisima. Ascafiashon Juanpan Jesushuunoa iconcoin. Yoia cuscan nanscacoin huamisiran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Asca huacanashu nanno yora ichaparasiton, —Icon Jesusfin Diospan Facuquin, —icashon icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ascatan nocofunu Lázaro isinin icai. Ahuun pushu Betania ano ini. Nan Lázaro isinin icaiton ahuun poi rafu María yafi iyoa Marta nannori inifo. Nan María Jesusqui motica murannoa ininti sharacapa Jesús tau pumancayan ocatan ahuun foon otucuru aniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nan poi rafutan Jesús tsain fomaquifin, —Ifon, nan min ahuun noiaifin isinin iquiquin, —ishon yoimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús nicatan yoiquifin, —Nan Lázaro isinincaicain naimafinquin. Isinin icaifin yorafoan oicaniquin Dios sharacun. Unmain Diospan Facuquin un ahuamamishti huaiton tapicashon icoinra huanonfo, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús Lázaro yafi poi rafu atohuun noicoinni. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro isinincaiton nicafiai nanno osha rafuyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ascaiton —Non Judea ano afanan nasononcahuun, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ascaiton non cumaquin, —Tapimamisiton, nocon niaifofo Judea anoshon ramashta mia rutucuanafo. ¿Ascan ahuuscain min afanan ano capaimun? —ishon non yocainton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Shafatan non oinsharatiro. Farin chashaino non oinsharatiro pacushquima. Nanscarifiai shafatifi uhuun Upa Diosin ua amapaiyai cuscan ua tapimamisi. Ua cushuano un funotiromaquin. Uricai un musutiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ascafia faquishiano chashamatiyamaino yora pacutiro. Nanscarifiai tsoan Dios fu rafuyamatocai tapisharatiroma ahuuscashumain isharatiroquin. Ascai funotiro, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nannori noco yoitan Jesús afanan yoini isca huaquin, —Nocon yorahuan Lázaro oshafiacun un moimanicain, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Non afu rafumisifoan nicashon non yoiniquin, —Ifon, oshacoianfinquin naama. Chipo cayasharatiroran, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Man nacoinfiacun, —Osharan, —ato huaiton. Chipo moiran ishon shinannifo. Jesús man arusu onanfiashon ato yoicoinnima. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Ascan noco shafacafi yoini, —Lázaro man nacoinfiano un unimai naino un ano icama. Ascan man chipo oinquin man fasi ua icoinra huashquin. Ascafia natian non Lázaro ano fononfocahuun, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ascan nicatan Tomás nan rafanacani Jesús fu rafumisi futsan noco yoini, —Non canon. Norifi afu non nannon, —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ascatan Betania ano nococashon Jesús nica man Lázaro naita. Osha rafu non rafuri finoan ini mai huaitafo. Mahua quini muran mai huaitafo ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania Jerusalén chaima ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nocon caifo Israelifo ichapa María yafi Marta icano funifo aton ointi shinanmasharashopai poi naano. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martan Jesús oaiton nicai aqui nocoicai cani. María pushu muran nichifaini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesusqui nocotan yoini, —Ifon, min nuno anocai uhuun ushton ua nashocuanitamafinquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Un tapiafin natianri min ahuara futsa Dios yocaitofin mia ashonrisca huatiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ushtofin afanan funiquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Un tapiafi ahuun unutani nan naafo funiaifoannorifi funitiroquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ascaiton Jesús cumaquin, —Unfinquin uhuunoashu naafoti funicani. Uhuunoashufin nantifi niafoquin. Nan ua icoinra huaafin nafiashu afanan funiashu ahuuscanacamaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Niyoshon ua icoinra huashucai nanacama. ¿Nan mianmun icoinra huaicai? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Ai, Ifon, unfin mia icoinra huaicai. Minmain Cristocufin Diospan Facu. Nocon caifoan mia manamisi. Nocon shunicaifoanrifi mia manapaonifoquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yoitan Martan chipocun María yoicai cani. Nocoquin oian afu rafuafo María fu uaicaifoan oinquin Marta chipocun fusti mushannantan yoiquin, —Nocon tapimamisifin oaquin. Mia yoimana, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María nicatan funinaca huantan cai aqui nocoriscani. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuscai pushurasi muran nocoatai inima. Nan Marta fu tsaincanoashu oataima ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María fu uaicaifoan oin atofu uaifiain funinaca huatan caiton oincaquin María poi maia anoashu uaiqui cairafain nocon yora Israelifo mufainifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesusqui nocotan tauicopacufoan yoini, —Ifon, min nuno anocai uhuun ushto ua nashocuanitamafinquin. Iscainofin uhuun ushto ua nishoan icuanaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús María oian uaicaiton nocon caiforifi María fu fucanashu afu uaicaifoan ato oinfin Jesús arifi atohuun ramapaitan ato shinantaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ato yocani, —¿Ranimun man mai huaitanquin? —ato huaiton. Cumacaquin, —Ifon, oinyopon, —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Oinyopon huaifono, Jesús uaini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Uaicaiton oincaquin nocon caifoan, —¡Oincapon! Lázaro fasi noi ahuunoashu uaiquin, ");
INSERT INTO mcdNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","¿Nan fusho cayahuani cuscarifi huaquimun nunoshon Lázaro cayahuacuanitan? —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ascatan afanan Jesús ahuun ointi muran fasi shinancoinquin maia ano nocotan. Maiano toquirininhuan quini ano nocoshon yoiquin, ");
INSERT INTO mcdNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Toquiri fupucahuun, —huaiton. Nicaquin poi Marta yoiquin, —Ma, Ifon, manfin osha rafu non rafuri finoanquin a naita. Natianfin man pisiaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nicaquin Jesús yoiquin, —¿Un mia yoiaiton min nicamamun? Mian icoinra huafin Diosin ahuara shara tsoan atiroma cuscan huaiton min ointiroquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ascaiton nicacaquin fupunshonifo. Fupushonafoanno nai foisinifoantan, —Upan, un mia cufia cuscan mian nicai. Un mia aicho huai. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Un tapiafin mian nicafafainmisiquin. Ascan nuno niafoan mia icoinra huacashofin un mia cufiai cuscan mia huacaniquin, —Jesús apa cufini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Asca huatan Jesús yoiquin oi ashcafinin, —Lázaro, quini murannoashu funicurahuun, —huaino. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Funicurani, —Ahuun rashuafo pucacahuun cainshara curanon —Jesús ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ascaiton a nocon caifo María fu rafuafoan oincaquifin Jesús icoinra huanifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ascaiton oincanifin atirifi Fariseoqui chani focani fonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ascaiton nicacanashufin Fariseofo yafi nocon yorafohuunshon Dios cufimisi niaifofo ichanannifoquin. Ichanancashon yoicaquifin, —¿Nonmun ahuusca huaicai? Jesús tsoan atiroma cuscara ahuarafo huaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Non ahuuscara huaiyamafin nantififain icoinra huacaniquin. Ascano Romanonfoan noco asca huatirofo. “Mancai afanan niaifofoya itiromaran,” ishon noco yoitiro. Nocon ichananti pushuri paon huatiro, —nocon caifo Israelifo niaifo inifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ascaiton nocon yorafohuunshon Dios cufimisi niaifocoinchi Caifás ato yoiquin, —Mancai ahua tapiamafinquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Man tapiamamun na nocofunu fusti nocon yorafohuunoashu naashquin? Nancaifin sharaquin. Arus fusti nashquin tsoashtamaquian, —ishon yoini. Ascacufin Caifás inon pacoai cuscan yoiniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás yoiquicai afin shinanfain yoinima. Diosin ahuun shinanpan shinanmanainofin yoiniquin. Nocon yorafohuunshon Dios cufimisi niaifocoinchi Diosin ahuun shinanpan shinanmana Jesús nantifi ahuun caifohuunoashu nanonpacoiran, ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesuscai nocon caifo fustihuunoashu naimafinquin. Nantifi manifotichin icoinra huafohuunoashufin noco naashoshquiquin. Ascano nantifi Diosin facu inonfo. Noinancoincani. Nan yora fusti cuscara ishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nan Lázaro funiatianfin shinanquin tau huanifoquin, —¿Ahuuscashomain non Jesús rututiroquin? —icashon nanscasi huaquin shinanriapaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rutupaiyaifoan tapiashu Jesús afanan nocon caifo ichapafo icano cayonima. Yorahuanrasi ano catamarocon pushu fustirasi ano cani. Nan pushu fustirasi Jerusalén chaimashta ahuun anu Efraín. Nanno non afu rafumisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nocon caifo Israelifo nocon fusitin shafatan Diospan oinmati nan afu nai muran imisiton nocon shunifoan aton furonanfacufo iyoafofosi finonmani shinanshcaquin nocoti chaima. Nantianri yora ichapafo pushurasi ano chai icanashu Jerusalén ano funifo. Jerusalén anoafo Moisés aton shunifo yononi cuscan atorifi huamapai aton chaca soamapai ichananti pushu muran iquinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ascaifoanno nocon caifo niaifofoan Jesús funanifo. Dios fu tsainti pushu ano chifi niafo yocananannifo, —¿Ranimun Jesús? ¿Man shinanmun nocon fusitin Jerusalén ano oimamun? —ishon yocanonannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Asca huacanashu nocon yorafohuunshon Dios cufimisi niaifofo yafi Fariseofoanri ato yononi isca huaquin, —Jesús fuchishon noco tapimacahuun non achinon cunu muran iquimashquin, —ishon ato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ascano seis osha fusitin nocoti chaima Jesús no fu Betania ano cayoni. Nanno Lázaro ica ini. Nan Lázaro naacun Jesús funimani. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Naannoshon Jesús pimapaiquin tushu pichashonifo. Ascan Lázarorifi nanno atofu ini. Marta ato pimani. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Piaifono María Jesusqui oano ahuun ininti shara moticaquinoa Jesús ahuun tau pumancaya ocani. Ocashon ahuun foon otucurani. Asca huaiton nan pushu murannoafoan nan ininti sharacoin shutunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ascan Jesús afu rafumisi futsan nan Judas Iscariote nan Simonpan facu nanton chipo Jesús achimashquin yoini, ");
INSERT INTO mcdNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¡Cuu! ¿Ahuuscaquimun na ainfoan ininti shara potaquin? Ahuun rafanan pui ichapa fishon noco inancun ahuuomafo non inancuana. Ascan shara icuanaran, —ishon Judaspan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anori shinanfiaquicai ahuuomafo shinancoinnima. Afi yomutso iniquin. Nocon pui nanuti cushupaoni. Cushucoinpaonima. Ahuara fipaiquin nannoa pui onupaoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ascano Jesús Judas yoini, —María fucash huayamahuu. Un samamashta nai tapishon uqui ininti ocaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nan yora ahuuomafo matofu ipanaca. Ascacufin ato afanan inansharatiroquin. Ucai matofu nuno mai ano ipanacama. Ascaiton María natian ua shara huaran, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ascano Jesús nicafuracani nocon caifo Israelifo ichapa aqui funifo. Lázaro funia nicacani yora ichapa aqui funifo. Jesús fusti oinpaicanimaquian Lázaro nacoinfiacun Jesús funimana oinpaicani funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lázarohuunoa nicacaquin nocon caifo ichapafoan afanan nocon yorafohuunshon Dios cufimisi niaifofo tanatama Jesús fusti icoinra huanifo. Ascaino nocon niaifofo yoinannifo, —Nan rafu non rutunon. Jesús fustimaquian. Lázarori non rutunon, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Man ascano iyoconaino nocon caifofo nocon fusititian yorahuanrasi Jerusalén ano inifo. Jesusrifi nocoaiton nicacani aqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Upufo ya aqui fucaquin oi ashcafinin isca huanifo, ¡Aicho! Nocon Numamisi oiquin. Nonfin Israelifoquin. Minfin nocon niaifoquin. Nocon Ifo Diosin mia nocoqui nichini. Min fasi sharacoin. Upa Diosin mia shara huapapainonran ishon yoinifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Nannori yoiaifono Jesús burro cahuashara camaqui tsaoinacahuatan cani. Diosin tsain yoini cuscain iscani, “Jerusalén ano icafoan ratuyamacahuun. Maton Niaifo matoqui oshquiquin. Burro cahuashara camaqui matoqui oshquiran,” ishon cunuyoni cuscan. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nantian nanfohuunoa oinfiaquicai icai cuscan non tapiyonima. Chipo Jesús afanan Apa ari nai muran cani afu niaifocoin iquicai non shinanni isca huaquin, —Jesús mai anoshon amisi cuscan nannoricoin Diosin tsain ahuunoa cunuyonifo. Nocon shunifoan Jesús caiantaima inonpacoai cuscan aqui cunuyoniforan, —ishon nocon nomuran non Jesús shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús Jerusalén ano nocoaiton nicacaquin nantianri yorahuanrasifoan a mananifo oinpaicaquin. Atirifoan Jesús Lázaro naafiacun funimanaiton oinnifo. Oincanifin futsafoqui chaninifoquin arifi oinnonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nocofunu man nacoinfiacun funimana nicacaquin nanfoanri oinpainifo. Ascashon fai anoshon Jesús mananifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ascano Fariseofo aqui yoinannifo, —¡Cuu! ¡Shinancapon! Noncai ahuusca huatiroma Jesús isca huanonma. Tsoancai noco nicapaicanima. Nantifi yorafoan Jesús nicapaicaniran, —icanashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nantianri Jerusalén ano yorahuanrasi muran nocon caifomafori nocon yora futsafo fusitin ano funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nococatan Felipe ano fonifo yocain focani. Nan Felipe Galilea mai ano nan pushurasi ahuun anu Betsaida anoashu cainni. —Non Jesús fu tsainpai. Noco ihuushohuun non afu tsainon, —ishon Felipe yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nicashon yoiafo cuscan Andrés tapimani. Ascan nan rafutan Jesús yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","24","Nicaquin Jesús ato yoini, —Unfin samamashta uhuun Upa Diosin nai muran icano un caicain afu niaifo iqui cai. Ascanfia uhuun Upa ari cataima un yorafotihuunoashu un nayoshqui. Isca huaquin un mato tapimashquin man tapinon. Shuqui furo fusti non fanayamacai foatiroma. Ascatamarocon nan shuqui furo fusti fanano ahuunoashu furo shara ranan caintiro. Nanscarifiai un matohuunoashu nayamacai tsoa futsa un nimapacutiroma. Urus fusti un nipatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tsoan iscatiro “Diosin ua imapaiyai cuscacai un apaima. Ufi apaiyai cuscan fustifin un shinaincani,” ishon anori shinanshu funocointiro. Ascafia tsoan isca huaquin shinain, “Un nuno mai ano niyoshon ufi apaiyai cuscan un shinanpaitamarocon Diosin ua imapaiyai cuscan fusti un shinanpairan,” ishon yoitan Upa Dios fu ipasharatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ascan tsoa uhuunoa yonomisi ipaiqui uhuun tsain nicacointan un yoia cuscan huatiro. Ua tanashu un icano arifi nannori ufu ipatiroquin. Uhuun yonomisi un yonoa cuscan ua ashoinquin Uhuun Upa Diosin futsafo aton ointaifi ahuunoa yoishquin isca huaquin, “¡Aicho! Min uhuun Facu Jesús nicamisi sharacoin. Min shara huamisiran,” ishon Upa Diosin ahuunoa yoisharatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","¡Ohua! Natian uhuun nomuran un fasi omitsiscai. ¿Un raquiri huatiromun? Ucai yoitiroma isca huaquin, “Upan, ua numahuu un natian omitsiscanonma,” ishoncai un anori yoitiroma. Upa Diosin ua nichini un natian ato omitsiscashonon. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Upan, Uhuunshon ato oinmahuu min fasi shara, —ishon Jesús yoini. Yoiaiton nai muranshon oi ashcafinin Apa Diosin cumani, —Un minhuunshon un ato ismafafaini un shara. Nanscarifi un afanan huai, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nan yorahuanrasi nannoshon nicacani atirifoan yoinifo, —Man turuicaran, —inifo. Atirifoanri yoinifo, —Upan Diosin ahuun oinmati afu nai muran icaton Jesús yoiaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ascan Jesús ato yoini, —Nan oi nai murannoa man rama nicaicain ua tapimanama matofin nicamapaiaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Natian nan icoinra huamafoti Diosin ato onaintimaicoinni. Aton ifonri nan yoshin chaca Satanás arifi nantiantari Diosin potashquin afanan aton niaifo inonma. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ascafiatan ihui coyan iquinanqui ua mastashon uaya finifoanshcani. Nanhuunshon un nantifi yorafo uqui omashquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nannori ato yoini ahuuscashumain nashquicai tapinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nicacashon yorahuanrasifoan nanno nishon yoinifo, —Diosin tsain cununi cuscan noco yoimisi isca huaquin, “Cristo, nan Diosin catoanfin nipanacaquin. Nanacamaran. Ascacufin ahuuscashomain, Diospan Facu ihui coyan iquinanqui uaya finifoanshcanicain,” min noco huaran. Tsohuunnoamun min yoicain, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús ato yoiquin, —Uncai mato chashamashoriaima. Un mato yoia cuscan nicasharacahuun funoshcaquima. Chashamati yamaino faquish itiro yora funonon. Tsoa faquish muran caquin fai funomatiro. Rani caimancai tapitiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Un matofu icano ua icoinra huacahuun funoshcaquima. Man ua icoinra huacun un mato chashamashotiro man shafacafi inon. Unfin chashamati cuscaraquin. Ua tanashon manrifi futsafo chashamashotiro matohuunshon uari tananonfo, —ishon Jesús ato yoini. Ahuun tsain yoiqui anaititan atomaquinoashu cani. Ascaitocai afanan oinnifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús aton ointaifi yoran atiroma cuscan ato oinmafiacun tsoan icoinra huanifoma nan Diospan Facucoinfiacun. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nannori Isaías atohuunoa inonpacoai cuscan yoiyoni isca huaquin, “Ifon, non min tsain ato yoifiainocai tsoan noco icoinra huama. Yoran atiroma cuscan min ato ismafiacun tsoamun mia icoinra huaiquin,” ishon Isaías inonpacoai cuscan cunuyoniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Diosin ato yoipaoni cuscan nicacasmanifo. Ascashon icoinra huapainifoma. Ascacufin afanan atohuunoa inonpacoai cuscan cunuyoni isca huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Icoinra huayamaifoan Upa Diosin fusho ointsa ato imapacushquin. Diosin tsain iconcoin oinfiacashon icoinra huaiyamaifoan Diosin aton shinantimahuatani shinansharanonfoma. Diosin tsain oinfiacaquin oianma shinantsacani. Nicafiacanashon shinansharatirofoma tapishcaquin. ‘Muafo aton chaca shatucasmacani uqui funonfo un ato cainmasharanon,’ ishon Diosin yoini.” Nannori Jesushuunoa Isaías inaca cuscan cunushoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesús fasi sharacoin inon pacoai cuscan Isaías oinquin tau huani. Ascacufin nannori ahuunoa yoiyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Nocon caifo Israeli niaifofo atirifoan Jesús icoinra huayamafiaino atirifoan icoinra huanifo. Icoinra huafiacani Fariseofoqui musunifo. Fariseofoan yoinifo, —Tsoan Jesús icoinra huaicai nocon ichananti pushu muran afanan iquitiromaran, —ishon yoinifo. —¡Ohua! Jesús icoinra huaran non icaiton nocon ichananti pushu muranshon noco potashcani afanan atofu non ichanannonma, —ishon yoinifo. Ratucoinnifo. Ascacuncai non Jesús icoinra huaran inifoma. Upa Dios ato yoishara icai fuchipaitama atohuunoasi fuchipainifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ascatan Jesús oi ashcafinin ato yoiquin isca huani, —Tsoan ua icoinra huaquin nan ua nichiniri man icoinra huatiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nanscarifi aquin ua oinfain nan ua nichiniri man oian. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuno mai ano faquishihuan cuscara. Ascacufin Uhuun Upa Dios icanoashu un nuno mai ano oniquin chashamati cuscara iquiyoi. Ascan un mai ano oni afanan yorafoan chaca huafafaintamarocon ua icoinra huashon Upa Dios tanasharanonfo shafacafi icoinsharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tsoan uhuun tsain nicafiaquicai un yoia cuscan aima uncai ato onaintimaima. Un mai ano oni yorafo onaintimatamarocon ato numaiyoi un oni. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ascafiacai tsoan ua ifo huapaimisima uhuun tsainri nicacasmacaquin nanscarafo onaintimaitian Upa Diosin ato yoipacushquin isca huaquin, “Min niyoshon uhuun Facun ahuun tsain min nicacasmamisi. Min omitsiscapanacafo muran ipanacaquin,” ishon yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uhuun Upa Diosin ua yonoa cuscan nannoricoin un mato yoimisiquin. Ufi shinanfaincai un mato yoima uhuun Upa Diosin ua shinanmanai cuscan un mato yoimisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mun tapian Upa Diosin yonoa cuscan icoinra huashu man nipatiro. Ascacufin un mato yoimisi cuscan uhuun Upa Diosin, “Nannori ato yoihuu,” ua huamisi, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Diosin oinmati nan afu nai muran icaton nocon shunifoan aton facu iyoafofosi finonmani ato rutunonma nan fusitin chaima. Jesús onanni iyoconaino rutuaifo. Mai anoashu Apa ari caanon. Non afu rafumisifo nuno mai ano niyoshon noco noiyopaoni cuscan natian noco isma nocohuun noi finacoinquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús futan non afu rafumisifoan fari caino non pini. Non piataima Satanás yoshin chaca Simón futsan ahuun facu Judas Iscariote ahuun nomuran yoini isca huaquin, —Ato tapimahuu ahuuscashomain Jesús achitirofoquin, —ishon ahuun nomuran yononi. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ascatan Upa Diosin ahuun Furun yoini, —Nantio nai murannoa non mai anoafori min ato yonotiro. Min ato iforan, —ishon Upa Diosin yoini cuscan Jesús tapiyoni. Upa Dios ariashu oni afananri aqui nasoshquin nanri tapiyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ascacufin piquin anaititan Jesús funinaca huan ahuun sahuuti pucatan ahuun turuitinin piracomuni. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ascatan unu tasoqui manushon non afu rafumisifo noco ochonpacushquin. Ochontan ahuun turuiti piracomuaton noco otucuruapani. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ascatan Pedrori apaiyaiton, —¿Ifon, ahuuscain min uhuun Ifofiashon mian ochonpaiyain? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Un mato acai cuscan natian min tapiama. Ascafia min chipo tapishquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Ma, Ifon. Miancai ochonpacunacama, —huaiton. —Un mia ochonyamainocai min ufu rafutiroma, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Ascaiton, Ifon tauquisimaquian ua muchofain ua machonhuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Rama yora nashia ahuun tau fusti non ochotiro. Mantsi chostanayamacun. Ahuun caya afanan chostanama. Nantificai man choshtama. Ascafiashu atifincoinmaquian, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Mantsi tapiamashon ratotomain achi mashquicain. Ascacun nannori noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Man noco ochopacutan nasocain ahuun sahuuti sahuuni. Sahuutan afanan tsaoti camaqui tsaoni. Ascashon noco yoini, —¿Man man tapiamun un mato ashoan cuscan? ");
INSERT INTO mcdNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Tapimamisiton,” huafain “Uhuun Ifon man ua huaaquin.” Iconquiquian. Unmainquifin. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ascatan unmain maton Ifocain maton tapimamisishofin unmain mato iquinshofin. Ascashon un mato ochopacua maton oinmati cuscara iishquin. Ascan un mato ochonpacua cuscari mafi ranan oinmati cuscara huaa tananshu ochononancahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Un mato oinmana un aca cuscari marifi man anon. Ua cuscara icahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Un mato icon yoi. Yonomisitocai ahuun ifo finontiroma. Nanscarifiai futsan futsa nichian ahuun tsain ato tapimashonon. Nan tsain fomisitoncai nichimisi finontiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Un aca cuscan man man tapia. Ascan man man tapia cuscan aaquin unimacointiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Uncai nantifi matohuunoa yoima. Un tapian ahuutimain un catoanquin. Ascafiacun Diosin tsain yoia cuscacoin non icoinra huatiro. “Nuno u futan piyai futsan ua chaca huaashquin.” ");
INSERT INTO mcdNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Icataima un mato yoiyomisi. Ahuutiaran icai cuscan un mato yoiyomisi. Chipo icai cuscan un Cristo Diospan Facu man icoinra huanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Un mato icon yoi. Nan un nichian uhuun tsain ato yoinon. Nanrifi icoinra huashofin uarifi man icoinra huatiroquin. Ascatari ua icoinra huashofin un nichiari man icoinra huaicai, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","22","Yoiquin anaititan Jesús fasi afiri shinanmucoinni. Ascashon fasi shafacafi nichifain noco yoini, —Un mato iconcoin yoi. Ratoran man futsafin ua ato achimashquiquin, —icaiton nicaquin non oiancufainni nofi ranan fuuisinan acufainni. Tapitsi non huaashu. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Unquian afu potasinanshu tsaoan. Fasi uhuun noicoian. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ascaiton Pedronun oi nomashta ua yoini. —Tsoanmain achimashquicain yocahuun, —ua huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ascaiton aqui tasicain un yocani, —¿Ifon, tsohuunoa min yoimun? —ishon un yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús ua cumani, —Nan misi torushtan pocotan un futsa inaintonfin man tapicain nantofin ua ato achimashquiquin, —ishon ua yoini. Ascano nanscacoin huaquin Simón futsan ahuun facu Judas Iscariote inanni. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Inantanaino Judashuun yoshin chaca Satanás nuuriscatani. Ascaiton Jesús Judas yoini, —Nan min acai cuscan ariscahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Non tsaoshon piairananuncai non tapinima ahuuscamain huacanicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ascaiton atirifoan shinannifo Jesús Judas nichian shafain fusititian non yopai cuscan fiicaishafain. Atirifoanri shinannifo Jesús ahuuomafo yopai cuscan ato inantahuun huaashafain non ini. Nan Judasfin pui cushumisi iniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nan Jesús misi pocotan Judas inantapaiyaino funinaca huan caicainni. Man yamuaino. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Ascatan nomaquinoashu man caano Jesús noco yoini, —Un naitian Upa Diosin mato ismai unmain ahuun Facu sharacun. Un acaiton man oian cuscan Upa Dios fasi shararan huashcani. Samamashta Upanri ato tapimai unmain ahuun Facu sharacufin. Unmain a cuscaracoincunfin. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Uhuun facufoan uncai nuno matofu iqui chaima. Man ua funashquin. Un nocon caifo Israelifo yoia cuscan natian un matori yoi un cai aricai man catiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tsain funa futsa un mato yoicain, “Noinancahuun. Nan un matohuun noiai cuscari huafain marifi noinancahuun.” ");
INSERT INTO mcdNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Man noinainno nantifi yorafoan tapitiro man ufu rafuaiton man uhuunshon tapishara, —Jesús noco huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ascaiton Pedronun yocani, —¿Ifon, raqui min caimun? —yocaiton. Yoiquin, —Uncai aricai natian min ufu cayotiroma. Chipo min ua mufaintiro, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—¿Ahuuscain natian un mifu catiromamun, Ifon? Natianfin mun itisharaquin mihuunoashu naashquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Iconmun min itishara uhuunoashu naashquin? Iconquin un mia yoi. Na yamu tacaranun acataima, “Uncai Jesús oinmisimaran,” ishon min ato yoiquin rafu non fusti huairan, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—Maton ointi fucashniyamacahuun. Upa Dios icoinra huafain uarifi icoinra huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Uhuun Upa icanofin cunu ichaparasiquin. Un mato itishara huashoin caicain. Ascarayamacucain un mato yoicuanama. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cayoshon un mato itishara huashoicaicain. Itishara huatani un afanan matoqui nasoshquin un icano mato ihuiyoi. Ari ufu man ipanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Man manfin un cai ari fai tapiaquin, —ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ascaiton Tomás cumani, —Ifon, noncai a min cai ari fai tapiamafinquin. ¿Ahuuscashomun non tapitiroquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ascaiton Jesús cumani, —Unfin na faiquin. Unfin iconmisiquin. Uhuunoashufin yorafo nipatirofoquin. Tsoacai afi uhuun Upa icano nocotiroma. Uhuunoashu fustifin uhuun Upa ari nocotirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ua onancoinshofin uhuun Upari man onantiroquin. Natian non chipori man uhuun Upa onancoin cai. Nan ua oinquifin man uhuun Upa oianri man huaicain, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ascaiton Felipe cumani, —Ifon, noco Upan Dios ismapun. Min noco Upa Dios ismaino non unimacointiro, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ascaiton Jesús cumani, —Felipen, Un fasi matofu ipaifiamisicun. ¿Ahuuscain mian onanyomisimamun? Nan tsoan ua oinquifin uhuun Upari oinquin. ¿Ahuuscain ua “Upa oinmahuu” mian huaimun? ");
INSERT INTO mcdNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Un uhuun Upa fu imisi. Non fusti cuscaracoinquin. ¿Nan min icoinra huaimamun? Un mato yoiai cuscacai uhuunoacoin un mato yoima. Uhuun Upahuunoafin un mato yoicain. Nai arishon Upa Diosin mai ano apaiyai cuscafin ua huamaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Un mato yoi uhuun Upa fu rafuaino urifi uhuun Upa fu un rafumisiquin. Ua icoinra huacahuun. Uhuun tsaincoin icoinra huayamaquima. Un acaiton man oian cuscan ua icoinra huacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iconquin un mato yoi. Tsoan ua icoinra huashon un acai cuscan arifi huashquin. Uhuun Upa ari un caiyoano. Ascacufin un aca cuscan finonmacaifain ashquicani. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ahuara uhuun anuhuunshon Uhuun Upa man yocaiton un mato ashotiro. Ascaiton yorafoan “Upa Dios shararan,” huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ahuara futsa uhuun anuhuunshon man yocaiton un mato ashotiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ua noifin un mato yonoai cuscan man aicai ");
INSERT INTO mcdNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Un Upa Dios yocain mato futsan nichishonon maton ointi fucash huanonma man isharanon. Maton tapimamisi inon. Amain Diosin Yoshin Sharashofin. Aafin iconmisiquin. Mato fu ipashquin. Icoinra huafoanmacai a onantirofoma. Ascarifi atacai ahuamain huaincai tapitirofoma. Ascan manfin onanmisiquin mato fumain icufin. Ascatari maton nomuran matofu rafui. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Uncai matomaqui iquima. Un mato potacoinma. Un matoqui afanan nasoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Un nuno iqui chaima. Ua icoinra huafoma ua oinyoshcanima. Ascan manfin ua oinshquicai. Nan un nipaino marifi man nipanaca. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Un funiaiton man tapitiro unmain Upa Dios fu ipanacacufin. Ascarifi atan marifi man ufu icaquin. Urifi un matofu icaino. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Un mato yonoa cuscan ua nicacoinshonfin ua fasi noicoinquin. Ua noicoiainton uhuun Upari ahuun noi. Ascaino urifi un ahuun noi. Un shinain cuscan u ato tapimairan, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ascaiton Judas futsan Iscariotemaquian yoini, —¿Ifon, ahuuscain mia icoinra huafoma min shinain cuscan yoitama noco fusti min tapimai? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús cumani, —Tsoan ua noi un mato yosiain cuscan ua nicacointiro. Uhuun Upa ahuun noiaino urifi un ahuun noi. Non afu rafupacushquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ua noiamacai un yosian cuscan ua nicaima. Na tsainfo man nicaicain uhuunacoinma. Uhuun Upan tsain un mato yoi. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Un matomaqui cataima un mato yoiyofafaini. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ascan Upan Diosin ahuun Yoshin Shara uhuunshon matoqui nichi mato futan afain maton ointi fucash huanonma man ishara. Nantifi un mato tapimafain un mato yoiai cuscan un mato shinanmai man ointiaquimanonma. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Un matomaquinoashu cafiaquin un maton ointi mato unimamashquin man isharanon. Icoinra huafoanmacai maton ointi mato unimamatiroma mato imasharanon. Mato anori yoifiaquin ipaitsi mato yoi. Uncai ato cuscarama un mato icon yoi. Ascacun shinanchacayamafain ratuyamacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Un mato yoia cuscan man man nica, “Un matomaquinoashu caicain. Ascafiashu un afanan matoqui ooshquin.” Ua noicoianshu man uqui unimatiro umain Upa ari caiton. Upanmain ua fasi finoncoincufin. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nan un mato rama yoia cuscacoin aiton man icoinra huatiro. Ascacun un mato yoiyomisi. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yoshin chacafoan aton niaifo Satanás uqui oi. Ofiashocai ua iquintiroma. Ascacun un matomaquinoashu cai. Afanan un mato yoiquin chai huaima. ");
INSERT INTO mcdNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Un Upa Diosin fasi noicoin ascacun nan ua yoia cuscan un acoinmisi. Ascaiton nantififain tapicani un fasi ahuun noiaiton. Funicahuun. Nunoashu non canon, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Unfin fana uva ahuun caya cuscaracoinquin. Uhuun Upafin uva fana ahuun Ifo cuscaracoinquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Manfin uva ahuun poyan futsan cuscarafoquin. Rato poya futsanmain fimiomafoquin Uhuun Upa nanfo poshtushon potashquin. Ascafia poyan futsa fimiafo aton tushpa futsafo chacamishti poshtutiro poyan sharafo mutininon fimi sharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nanscarifi aquin manfin uhuun tsain nicaquin maton chaca potaquin isharashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Umaquin pashcayamacahuun. Nan un matofu ica cuscariai. Poyan fustisicai fimitiroma ahuun cayamaisi. Nanscarifiai umaqui icashucai un mato imapaiyai cuscan man atiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Unfin nan fana ahuun caya cuscaraquin. Ascan manfin ahuun poyanfo cuscarafoquin. Tsoa ufu rafucoincacainaino urifi un afu rafucoiaino ua cuscaracoinri itiro. Ua maisicai marusu man ahuuscatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ahuun poyan futsa chaca fimioma poshtushon potashquin tsasinon. Tsasicun poyafo icha huatiro coashquin. Nanscarifiai tsoa ufu rafutama umaquin icun nanscarafo chipo icha huashon chi urumanhuan muran ato potashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Man ufu rafucoinshon uhuun tsain maton nomuran shinanfafainquin man ahuarashta cufia cuscan Upa Diosin mato ashotiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Un mato imapaiyai cuscan man afafainnifin man ufu rafumisi itiroquin. Man ascaitonfin mato ointirofoquin Upa Diosimain sharacoincunfin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","Uhuun Upa Diosin ua noicoian cuscan nanscarifi huaquin un matohuun noi. Nan shinanfafaicahuun. Unuyamacahuun. Uhuun Upa Diosin ua yonoa cuscan un amisi. Ascan ua noia cuscan un shinanfafaini. Nanscarifiai un mato yonoa cuscan man aiquin un mato noiaiton man shinanfafaitiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Un mato yoia cuscan man aino un matoqui unimatiro. Marifi fasi man unimacointiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Isca huaquin un mato yonoi, “Un matohuun noiai cuscan noinancahuun.” ");
INSERT INTO mcdNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tsoan afu rafua futsan noicoinfin ahuunoashu natiroquin. A noiai cuscacai tsoan finontiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Un mato yonoai cuscan man aifin ufu rafumisi man itiroquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nan ufu rafuafosi un shinain cuscan un ato tapimatiro. Manfin ufu rafumisiquin. Ascan nantifi uhuun Upan ua yoimisi cuscan un matori tapimana. Ascacucai man afanan uhuun oinmatiforan un mato huaima. Man ufu rafumisiran un mato huashquicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Man ua catonyamafiaiton ufi un mato catoan ua cuscara man inon matohuunshon futsafoanri ua icoinra huanonfo. Nanfoan ua tanapacunacafo ufu ipashcaquin. Asca huaino man ahuarashta Upa Dios uhuun anuhuunshon yocaiton mato ashotiro. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Afanan un mato yononon. Noinancahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Icoinra huamafoan mato noicasmaifoan shinancahuun. Uacaifin noicasmaquin tau huanifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Marifi man ua icoinra huayamaiton matori noicuanafo. Afi ranan noinanfo cuscan matori noicuanafo. Ascafiacai man ato cuscarama. Un mato catonni icoinra huama cuscarafo man inonma. Ascacun icoinra huamafoan mato noicasmacani. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Un mato yoia cuscan shinancahuun. Un mato yoia isca huaquin, “Yonomisitocai ahuun ifo finonmatiroma.” Ua omitsiscamacaquin matori omitsisca huashquicani. Un ato yosian cuscan acashon marifi man ato yosiaiton matori nicacoincani. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Man ua tanaiton ua amisifo cuscan matorifi huashcani. Upa Diosin ua nichifianicai tsoan onancoinmisima. Ascan matori asca huashcani. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Un atoqui oyamani Diosin tsain un ato yoiamaino tapicuanafoma. Ascan chaca huafiaquicai tapicuanafoma. Tapiyamaifoannocai atohuun nuama. Ascafiacun un oni un ato Diosin tsain yoishquin. Ascacucai natian tsoan yoitiroma isca huaquin, “Uncai nicataima. Ascacun un chaca huama,” ishoncai anori icon yoitirofoma. Man nicafiamisishaquin aton chaca shatuafoma. Ascan aton chaca atohuun nua. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tsoan ua noicasmai uhuun Upari noicasmai. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Diosihuunshon tsoa futsan atiroma cuscan un ato ismamisi. Ascafiacai aton chaca shatuafoma. Un ato ismayamaino aton chaca atohuun nuucuanama. Tsoa futsan atiroma cuscan un ato ismafafaini. Man oinfiacashon ua noicasmafain uhuun Upari noicasmafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Diosin tsain cununi cuscan mun acoinna. Diosin tsain uhuunoa cununi isca huaquin, “Un ahua chaca huayamafiacun ua noicasmacaniran,” ishon uhuunoa cununi. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Matori noicasmafiaifoan uhuun Upa Diosin arishon ahuun Yoshin Shara matoqui nichishquin. Nanton maton ointi unimamatiro isharashcaquin. Afin iconmisiquin. Uhuunoa mato yoishquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Un aton Diosin tsain yoiqui tau huanitian marifi man ufu imisiquin. Ascashonfin marifi uhuunoa nantishon tapiquin man ato yoitiroquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ascano Jesús noco yoini isca huaquin, —Man omitsiscataima un mato yoiyoa man nunori shinanonma. “¿Ahuuscaimun Jesús uhuun Numamisifiano un omitsiscai?” ishon man anori shinanquin man ua potapaishquin afanancai man ua icoinra huashquima. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tapicahuun. Maton caifo nan ua icoinra huamafoan chipo yonoi man nocon ichananti pushu muran afanan iquinonma. Un mato icon yoinon. Chipo amaquiri shinancani isca huaquin, “Diosin apaiyai cuscan non huashonon. Non Jesús icoinra huafo rutunon,” ishon anori shinancani. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uhuun Upa onanyamafain uarifi onancoianfoma. Ascacun mato asca huashcani. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Man ua tanaquin tau huanitiancai man chipo omitsiscashquiran un mato huanima. Un matofu iyofiashocai un mato yoiyonima. Natian un matomaqui caiyoicai. Ascan man omitsiscaitian un mato yoiyomisi cuscan huaquin man shinantaniran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Afanan Jesús noco yoini isca huaquin, —Uhuun Upan ua nichini. Natian un afanan aqui caicain. Ascafiacai man ratoran futsan ua yocama, “¿Min raqui caimun?” man huama. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Un mato yoia cuscan maton ointi muran man fasi nocoi. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Un mato icon yoinon. Un mato shara huahuunshon matomaqui caiyoicai. Un cayamainocai Diospan Yoshin Shara matoqui otiroma mato cushusharafain mato ashoshquin. Ascafia matomaquinoashu caquin uhuun Yoshin Shara un matoqui nichifainicai. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Afi oshon a icoinra huamafoan chaca huamisifo ato tapimai oshquin Diosin amapaiyai cuscan huafain tapimai oshquin. Diosin icoinra huafoma ato onaintimai cuscan ato tapimai oshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ua icoinra huatama chaca huafo cuscan ato tapimai oshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Unfin uhuun Upan ua amapaiyai cuscan un huamisiquin. Ascan uhuun Upa icano un caicain ua afanan man oinonfoma. Nanri Diospan Yoshin Sharapan ato tapimai oshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nantianri icoinra huafoma aton niaifo Satanás Diosin man onaintima afanan ahua yoinonma. Nanri Diosin Yoshin Sharapan ato tapimai oshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Un mato fasi paratama tapimapaifiaintocai man natian tapitiroma. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ascafiatan Diospan Yoshin Shara matoqui oshon mato ahuarashta Diosin tsainhuunoa mato tapimashquin. Aafin iconmisicoinquin. Ahuunshon mato yoitama uhuun Upan yoia cuscan nannoricoin mato tapimai. Inonpacoai cuscari mato tapimai. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Un yoiai cuscan Diospan Yoshin Shara mato tapimai uhuunshon man uhuunoa shinansharanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nan uhuun Upanaforifi uhuunariquin. Un mato yoimisi cuscan uhuun Upa Diosin ahuun Yoshin Sharapan mato tapimashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ascan uncain matofu iyoima. Uacai man oinyoshquima. Ascafia ahuutishomatan man afanan ua oinshquiran, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Nicacatan atirifi non yoinanni, —Ahuuscain noco isca huaimun, “Uhuun Upa ari un cai. Ascan uncai matofu iyoima. Uacai man oinyoshquima. Ascafia ahuutishotama man afanan ua oinshquiran,” ishon noco yoi. Noco yoiai cuscacai non tapiamaran, —icashu non yoinanni. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nanfohuunoa non yocapaiyainton Jesús onanni. Ascanshon noco yoini, —¿Un mato yoiai cuscan man tapiashma man yocanonaincain? ");
INSERT INTO mcdNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Un mato shafacafi yoinon. Un omitsiscaino ua icoinra huamafo fasi unimashcani. Mancai ascashquima man ua manoshquin uaiquin. Uaifiashu chipo fasi man unimashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ainfon facu cainti chaima tau isin huaino isinyotiro. Chipo ahuun facu cainshon afanan ahuun isin shinantiroma. Unimacointiro ahuun facu cainsharashu. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nanscarifiai un matomaquinoashu caitian maton ointi muran man omitsiscaiyofiashu un afanan matoqui oano ua oin man fasi unimashquin. Man unimaitocai tsoan mato umaqui imatiroma man unimanonma. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Un funiaitian un afanan matofu iyamano man afanan ahuara ua yocaima. Un mato icon yoinon. Uhuun anuhuunshon man Upa Diosin yocatiro. Ahuarashta uhuun anuhuunshon man Upa yocaiton mato inanshquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Uhuun anuhuunshoncai man Upa yocayomisima. Ascan uhuun anuhuunshon Upa yocacahuun. Man yocaiton Upan mato inanshquin. Mato inainno man fasi unimashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Un mato yoiyaifo tapifiashocai atirifi man tapiataima. Un mato shafacafi yoicoiantaima. Ascafia un chipo mato yoicoin Upa Diosihuunoa shafacafi man tapinon. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Man ua noi. Un Diosin ariashu matoqui oni man ua icoinra huamisi. Ascan Upa Diosin matori noicoin. Ascacufin un matomaquinoashu caitian un matohuunshon Upa yocainmacai mafincoin uhuun anuhuunshon Upa yocashquincahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Un Upa ariashu oni nocofunucoin mai anoashu cainshquin. Natian un mai anoashu afanan Upa ari caicain, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yoiaiton non afu rafumisifoan non cumaniquin, —¡Aicho! Natian min noco afanan fomainma. Natian min noco fasi shafacafi puashoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Natian man non tapia min nantifi tapicoian. Mia yocataima min rufofo onanyoi mia yocapaiyai cuscan. Ascacun min Dios ariashu onicun non mia icoinra huai, —ishon non yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—Inoncai man ua icoinra huai. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ascafia chipo umaquinoashu man pashcafainicai. Maton pushu ano man cai. Icon natian man ua potafainicai. Tsoacai ufu nituima. Man ascafiainocai urusu un nituima. Man umaqui cuyofofiaino uhuun Upa fu un patanain. ");
INSERT INTO mcdNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Un mato yoiafo uhuunshon maton ointi man unimamafain man isharanon. Nuno icoinra huafoma murannoashu omitsiscafiacaquin shinanchacayamacahuun. Un Satanás yafi icoinra huafomati finoncoianquin. Ascan un mato cushuicai, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Asca huatan Jesús nai foisinifoantan yoini, “Upan, natian un nanon ato tapimahuun un min Facu sharacoinquin. Min uqui unimai ato tapimahuun. Min anori ato tapimanaino urifi un ato tapimatiro min fasi sharacoincun. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mian yonoa un atoti yonopacunon. Mian inanti un ato nimapacunon. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mirus fusti min Diosincoin. Unfin Jesucristoquin nan mian nichini. Tsoan noco onancoianfin nipanacafoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Min ahuu cuscara sharamainquin nuno mai ano niyoshon un ato puashoan. Nan mian yonoa cuscan mun aca. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ascan Upan, un mifu iyopaoni cuscan afanan ua imahuu. Non mai oni huataima u mifu niaifo shara iyopaoni. Afanan nanscara mia ya ua imahuu un min Facu shara nantififain ua tapinonfo.” ");
INSERT INTO mcdNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nuno mai anoa ufu rafumisifo mian inanni un ato ismanon min ahuu cuscara sharamainquin. Na ufu rafumisifo minafofiacun mian ato inanni. Min tsain mia nicacacoianfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mian yoia cuscan nantifi un ato yoimisi. Nanfo tapicoianfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mian yoia cuscan un ato yoiaiton ua icoinra huacoinnafo. Un miariashu fotoniri tapicoianfo. Mian nichinicun icoinra huacoinnafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Un mia ato cufishofafaini. Uncai a icoinra huafoma ato cufishonima. Nan mian inannifosihuunshon un mia cufifafaini. Un mia ato cufishofafaini nanfomain minafocufin. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nan uhuunaforifi minaquin. Ascan nan minaforifi uhuunaquin. Ua icoinra huafohuunshon onantirofo unmain ahuu cuscara sharaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Uncai afanan na mai ano iyoima. Unfin miqui caicain. Afofin na mai ano nitucaniquin. Upan, min fasi sharaquin ato cushusharahuu. Min curushhuunshon ato cushusharahuu. Mian inanfoti ato cushusharahuu. Nonfin nan fusti cuscaracoinquin. Nanfori no fu nan fusti cuscararifi ato imahuu. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Un atofu iyoshon un ato cushushara. Minhuunshon un ato cushushara. Un tsoanshta funoama. Nan Satanás ahuun facu fusti funoa. Min tsain yoiyoni cuscan nan fusti funoa.” ");
INSERT INTO mcdNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Natian un mi ari caicain. Un cataima un yoiyoi nan un icai cuscari unimacoinnonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mian yoia cuscan un ato tapimamisi. A icoinra huafoanma ato noicasmaifo. Ato cuscarafocutsi ascacun ato noicasmafo. Ascarifi atan unricai ato cuscarama. Ascan uarifi noicasmafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Uncai mia yocama mai anoshon min icari min ato ihuinon. Ascatamarocon un mia yocain nuno mai anoshon min ato cushushara nan yoshin chaca Satanás ato ahuusca huanonma. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nanfoancai icoinra huafoma aton yorama. Unrificai un aton yorama. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Min tsain iconcoin. Min tsainman ato shara huamahuu mia cuscara shara inonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mian yorafoqui nichini cuscan nanscarifi aquin un ato yorafoqui nichicain. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mian yoia cuscan mun atohuunshon aca afoanri ascarifi huanonfo.” ");
INSERT INTO mcdNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","“Uncai ato fustihuunshon cufifafainima. Nantifi aton tsainhuunshon ua icoinra huanonfo un ato cufishofafaini nan non shinain cuscarafosi arifi shinanonfo. Min ufu icacainai cuscan aforifi no fu ifafaincani mian nichini icoinra huamafoan icoinra huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Min ufu imisi cuscan urifi un atofu imisi. Ascan non shinain cuscarafosi arifi shinannonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Min ufu icacainai cuscan urifi atofu icacaini. Ascan min ipaiyai cuscan nanscarafosi non shinantiro. Min ointi cuscarafosi non itiro. Nan oincaquin icoinra huamafoan tapitirofo mian nichinicun mian noia cuscarifi ua icoinra huafohuunri min fasi noicoin.” ");
INSERT INTO mcdNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Upan, nan mian inanfo un mifu icano un atorifi iquinpai un mifu ishara cuscan oinonfo. Non nan mai oni huataima min ua noicoinyopaoni. Ascan min yononi cuscan un mifu imisi nantifi min iquinon.” ");
INSERT INTO mcdNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Upan, min shara fustisi imisi. Icoinra huamafoancai mia onanfoma. Ascan un mia onancoin. Min ua nichini ufu rafumisifoan tapiafo. ");
INSERT INTO mcdNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Min ahuu cuscaramainquin un ato ismamisi. Nanscasi aqui un ato ismafafaini min ua fasi noimisi cuscan afoanrifi munonfo un atofu icacainaiton,” ishon Jesús Apa cufini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ascatan Apa cufinquin anaitiano non afu rafumisifo shushan Cedrón yamu pocufainiquin. Nanno fanafoan ahuun anu olivo. Nan fanafo muran non iquitoshini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nannorimain Jesús noco iyomisicunfin. Ascano Judas nanton Jesús ato achimaniton tapini raquimain non foaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nannori Judaspan ranushumuafo non nocon yorafohuunshon Dios cufimisi niaifofoan futsafo afu nichini non Fariseofo iyoni Jesús achimaicaquin. Chiifo ya nopu non coshatifo non ashifo yari funifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ascaiton Jesús onanni ahuuscamain huacanicain. Onanshon ato yocani, —¿Man tsoa funaimun? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazaret anoa non funairan, —huaifoan. —Unfinquin, —ato huaiton. Nan ato achimaicai Judas nanno atofu ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","—Unfinquin —Jesús ato huatanaino chitucuri ifainpai cani pacui fustunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ascashon Jesús afanan ato yoca futsani, —¿Tsoan man funaimun? —huaiton. —Jesús Nazaret anoa non funairan, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Munfin mato yoiaquin. Unfinquin. Ua funacaquin na ufu icafo ato nichicahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inonpacoai cuscan Jesushuunoa cunuyoni isca huaquin, —Uncai mian inan un fustishta funoamaran, —ishon cununi. Nan cununi cuscan Jesús rama Apa Dios cufini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ascaino Pedronun ahuun nopu chinushumua ahuun ona murannoa tsucainifoantan nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun oinmati pashtufain rurani. Nan oinmati ahuun anu Malco ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ascaiton, —Min nopu ahuun ona muran huahuu. Upa Diosin ua amapaiyai cuscan un aicai, —Jesús Pedro huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","Ranushumuafo aton niaifofoya nocon caifo Israelifo niaifofoyashon osicashon Jesús munushnifo. Munushushon Anaspan pushu ano iyonifo. Nan Anás Caifás ahuun raisi anifo ini. Caifás nantian nocon yorafohuunshon Dios cufimisi niaifocoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nanton nocon caifo Israelifo yoini, —Nocofunu fusti nantifi yorafohuunoashu naafin shara itiroquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús iyoaifono Pedro yafi afu rafumisifo futsanri acachori fonifo. Pushu ano unmainti nocotan afu iquifainnifo. A fu rafua futsa niaifoan onanshon iquimani Jesús iquicainaino. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedron shoi caicainti ano nituni. Ascano nan niaifoan oinmisishaqui nasocura shomayaton caincaiti cushua yoini, —Pedrori iquimahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","—¿Mirifi min Jesús fu rafuamun? —ishon shomayaton Pedro yocaiton. —Ma. Uncai afu rafumisimafinquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Matsinacoincani nantifi chiin yoonifo. Niaifofo yafi oinmatifori yoonifo. Pedrorifi ato fu yooni. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ascatan nocon yorafohuunshon Dios cufimisi niaifocoinin Jesús yocani. —Mi fu rafumisifohuunoa ua tapimahuu. ¿Ahua min ato yosiamun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","—Uncai onuyoiama. Nantififain ua nicanonfo un yoimisi. Un nocon ichananti pushu murannoafo yafi nocon Dios fu tsainti pushu murannoari un nocon caifo yosimisi. Uncai uhuun tsain fustishta un fomanmisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ahuuscain mian yocain. Ua nicamisifo yocahuun. Un yoimisi cuscan nanfoan tapicoianfoquin, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ascaiton ranushumua afu niaton tapastan. —¿Ahuuscain nocon niaifo min anori aquimun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Ahua un amaquiri yoiamainquin ua yoihuu. Ascan uhuun tsain iconfiacun ahuuscain mian tapasain, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anori icaiton nicaquin Anás ahuun raisi Caifás ano Jesús nichini. Caifás nocon niaifocoin ini. Ahuun munushumua ya nichini. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ascaino afianoashu Pedro atofu yooriani. Ascaiton afanan Pedro yocanifo, —Mirififin min afu rafumisi futsaquin, —ishon yocaiton. —Unmafinquin. Uncai afu rafuamaquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","—¿Un mia oianmamun? Nan miafin un oianquin. Fanafo mapoa murannoa Jesús yafi un mia oian. Min racafinquin, —nan nocon yorafohuunshon Dios cufimisi niaifocoinin ahuun oinmati pashtuaton ahuun yoran Pedro huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Ma. Unmafinquin, —Pedron huaino tacara cuoinacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ascano funamanrishta Caifás ahuun pushu anoshon Pilato niaifo ano Jesús iyonifo. Nanfin Romanon iniquin. Ascafiashcai Pilato ahuun pushu muran iquinifoma aatsi Israelicun. Shinanpaonifo, —Non a muran iquiashu non chaca itiroran, —icashu ascashu iquicasmanifo. Afocai Israelifomaran icashu. Diosin oinmati nan afu imisiton nocon shuninfoan facu iyoafofo ato finonmani nan fusitin icaitian shinantacani. Nanscacun Pilato ahuun pushu muran iquicasmanifo. A muran iquiashu non chacacoin itiroran fusi muaimuran non iquitiroma. —A muran iquishocai nocon caifo futan non chashoanun facu pitiromaran, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ascaino chifi cainacahuan Pilato ato yocani, —¿Ahua chaca huacunmun na nocofunu uano man ihuuaquin? —ishon ato yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Ahua chaca huayamacucai non miqui ihuucuanamaran, —ishon huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Mafi iyotacahuun. Maton shunifoan yononi cuscamain chaca Israelifoan huaquin. Nanfin maton fuyamisiquin. Ahuamain chaca huaquin mafi ahuuscara huacahuun, —huaiton. —Maton yorafoan yononifo cuscacai non tsoa mastatiroma naanon —icashon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús yoiyoni cuscan nanscacoin huaquin. Mastashquicani naanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ascano Pilaton ahuun pushu muran Jesús iyoni yocanon. —¿Minmun Israelifoan aton niaifon? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—Mifimun min anori shinaincai. Futsanfoanraca mia uhuunoa yoiafo, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¿Min shinanmun urifi un Israeli? Min yorafo futan maton yorafohuunshon Dios cufimisi niaifofoan mia uqui ihuuafo. ¿Min ahua chaca huacunmun mia uqui ihuuafoquin? Ua yoihuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Uhuun yorafocai na mai anoafoma. Un nuno mai anoa niaifocun ua numacuanafo Israelifo ua achinonfoma. Uhuun yorafo futsa ari icafo —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ascaiton Pilato cumani, —¿Iconmun min niaifo? —ishon yocaiton. —Mian yocain cuscafin unquin. Niaifo icain iconcoin yoipacushaquin un cainni. Tsoan iconcoin nicapaiquin ua nicamisifo, —Jesús huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Ahuamun iconquin? —Pilato cumani. Asca huatan chifi cainacahuani Israelifo yoishquin, —Un na nocofunu yocafiacai un ahuunoa ahua chaca nicama. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Natian maton fuyamisi nocoano man imisi cuscan maton caifo cunu murannoa iquiafo fusti cainmafafainmisi. Maton shunifoan aton facu iyoafofo finonmani shinantaquin nantianri fusti mato cainmafafainni. ¿Ascan Israelifoan, maton niaifo Jesús un mato cainmashotiromun? Casharanon, —Pilaton ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oi ashcafinin cumanifo, —Ma. A caimatama Barrabás caimahuun, —huanifo. Nan Barrabás nocon caifo shinanchacamanaino mucai futsucashon futsa rutunifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ascashon Pilaton ato yonoa Jesús iyonifo fichiqui cuno tuchiaton coshanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ascano ranushumuafoan mosha chainipafo maiti huacashon maimanifo. Aqui cashupaiqui sahuuti nanhuainqui pocoa ointsa sahuumanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ascashon aqui cashucaquin. —¡Aicho! Minfin Israelifoan aton niaifoquin. Min chai niyopacupainon, —huatan fupasiriani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","5","Ascano Pilato Jesús chifi cainquifainni oinonfo. Jesús sahuuti nanhuainqui pocoa ointsa sahuumatan mosha chainipafo maiti huashotan sahuumanifo. Ascashon Pilato, —Oicapon na nocofunu. Ucai ahuunoa ahuashta nicayomisima un chaca huapanan, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ascafiaiton nocon yorafohuunshon Dios cufimisi non niaifo futsafoanri oinquin Jesusqui tsain chipunifo. Ascashon oi ashcafinin —¡Mastahuun! —huarianifo. —Ascaiton mafi iyoshon mastatacahuun. Uncai ahuunoa ahuashta nicayomisimafinquin un chaca huapanan, —Pilaton ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ascaiton nocon caifoan cumanifo, —Ma. “Unfin Diospan Facuquin,” Jesús noco huamisi. Ascacun nocon niaifofoan yonoa, “Tsoa anori icafin naiquin. Nayamacaiyaima,” —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ascaifoan nicai Pilaton fasi ratui finacoinni. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ascashon Jesús ahuun pushu muran afanan iyoni. Iyoshon yocani, —¿Raniamun minquin? —ishon yocani. Yocafiainocai Jesús pusinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—¿Mian cumaimamun? ¿Min tapiamamun un mia caimaiyamaraquin un mia mastamatiro? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Diosin mia yonoyamainocai mian ahuusca huacuanama. Ascacun nan mian chaca huanon mi ano ihuuafo nanfoancaifin ua chaca huaquin finacaniquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ascaiton nicaquin Pilatonun Jesús caimapairiani. Ascafiaino nocon caifo Israelifoan tsain isininpaton yoinifo, —Tsoa, “Unfin niaifoquin,” icafin Romanonfoan niaifocoin Cesari chaca huaiquin. Ascan min na nocofunu Jesús caimanacai nocon niaifocoin Cesari min ahuun yorahuancoinma, —icashon oi ashcafinin yoirianifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Nicatan afanan Pilatonun Jesús chifi cainmani. Nantianri nocon caifo Israelifo fusiti iyocoshquin icaino. Nan Diosin oinmati nan afu imisiton aton shunifoan facu iyoafofo finonmani shinantanfafainpaonnifo. Fari masafinin racano Pilatonun Jesús iyoni anoshon aton shara aroshofafainmisi. Ano tsaoshon yocanshquin chaca huayamaraquin shara huacun. Nannoshon ato yonotiro onaintimaiyamaraquin nichimisi. Nanno anuni —Toquiri saparan, —huapaonifo. Nocon caifo Israelifoan ahuun tsainman, “Gabataran,” huanifo. Pilaton tsaoshon aton ointaifi Jesús cainmani. Cainmashon, —¡Oincapon! Naafin maton niaifoquin, —Pilaton ato huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ascafiaiton, —Iyoshon mastatahuun nanon. Ihui coyan iquinanquin mastahuun, —oi ashcafinin huaifoan. —¿Iconmun unmun maton niaifo mastaicai? ¿Manmun mastanpaicai? —Pilaton ato huaiton. —Cesari fustifin nocon niaifoquin. Nocon niaifo futsa yamai, —ishon nocon yorafohuunshon Dios cufimisi niaifofoan yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Asca huatan inoncai Pilaton atoqui Jesús caimani. Ranushumuafoan iyocashon ihui coyan iquinanquin mastai focaquin iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ascano iyoaifoanno afincoin ihui coyan iquinan iyashon foni. Anoshon mastaifoanno noconi. Nanno ahuun anu mapo shaoran huanifo. Israelifoan tsainmanfin Gólgotaran huapaonifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jesús yomutso rafu yafi mastanifo. Yomutso rafutan naquihuano Jesús mastanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ascan mastacashon Pilaton yonocun Jesús ahuun mapo manaonrishta aqui cununifo. JESÚS NAZARET ANOA ISRAELIFOAN ATON NIAIFOCOINRAN ishon Pilato ato cunumani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jerusalén anoashu mani futsafo ya osiafo ichapacoin inifo. Jesús nanno chaimashtashon mastanifo. Ascanofin Pilatonun aton tsain futsa futsatapafo ato cunumani isca huaquin, —Jesús Israelifoan aton niaiforan —ishon tapinonfo. Nocon tsain cunufain Griegofoan aton tsainri cunufain Romanonfoan aton tsainri cununi. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nan oincatan nocon yorafohuunshon Dios cufimisi niaifofo Pilato ano fonifo. Yoifocani, —“Jesús nocon niaifocoinran,” huacaquima “Unfin Israelifoan un mato niaiforan, Jesús icaran,” ishon cunuhuu, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Un cunumana cuscan nannoricoin un cunua. Uncai ahua futsan afanan tuqui huaimaran, —ishon Pilaton ato cumani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ranushumuafoan Jesús mastaifono ahuun sahuuti fianpacunifo. Pashcananpacushon mani rafu non rafuri machinifo. Ascano ahuun sahuuti chainipa ashcapari chichia tushu huayonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Fashnuyamacahuun. Nanscara muma shara non finon. Non aya cashutihuun aqui numero nuupacua potashon futsa shuhuianton ahuun sahuuti ashcapari chichia fitiroran, —icashu yoinannifo. Nannori Diosin tsain Jesushuunoa inonpacoai cuscan aqui cunuyoni isca huani, “Uhuun sahuutifo aya cashutihuun aqui numero nuupacua potashon futsa shuhuianton uhuun sahuuti finonran,” ishon inon pacoai cununi. Ascano ranushumuafoan nanscacoin huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús mastafo chaimashta ahua non ahuun achin nan Cleofaspan ahuin non María Magdalena non afo nanno chaimashta ninifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Un non Jesús ahuari chaimashta non nia ini. Jesús noco oinquin yoini, —Uhuashtan, natian Juan min facu iquiran, —ishon yoini. Ua noiquifin anori huaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Asca huatan —Naafin min uhuaquin, —ishon ua yoiaiton nicaquin uhuun pushu ano un iyoni cushusharashquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesushuunoa Diosin tsain cunuyonifo cuscacoin acoincun onanshon Jesús yoini, —Un nomicoinran, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ascano fimi unu focash muran nanupacufoantan faca tahua shatun finifoantan Jesús inanpaini. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús muushon yoini, —Natian uhuun Upan ua yonoa cuscan mun acoinna, —huani. Ascatan nai fupopacucahuani. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iyoco futsaino nan fusititian Diosin oinmati nan afu imisiton nocon caifo Israelifo aton shunifoan facu iyoafofo finonmani shinantanfafainpaonifo ini. Ascano Jesús yafi yomutso rafu ihui coyan iquinanqui nanno mastaifoanno nocon niaifofoancai fusititian oinpainifoma. Ascanofin Pilato ano fonifoquin, —Funamanri nocon fusititian. Jesús yafi yomutso rafu ato fitucucahuun nariscanon. Mai huariscanonfo nocon fusititian mastafo ano ninonma, —ishon nocon niaifofoan Pilato yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ascan Pilato ato yonocun ranushumuafoan yomutso rafu aton fitash shao tucunifo nariscanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ascano Jesusqui fucaquin oianfo man naacoinna ini. Ascaitocai fitucunifoma. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ascaiton man naa oinquin ranushumuaton ahuun ashin pishi chachiaino imi focain unu foni. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Unfin nan oinni cuscan un mato yoiaiton marifi man icoinra huanon. Unfin icon yoiquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Diosin tsain yoimisiton inonpacoai cuscan cunuyoni isca huaquin, —Ahuun shaocai tucushquimafinquin, —ishon cununi. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","—Pishi chachiaitonfin oinshcaniquin, —Diosin yoimisi futsan inonpacoai cuscan Jesús naiyoataima cunuyoni. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","39","Ascano José Arimatea anoashu cainni nan Pilato ano cani, —Jesús ihui coyan iquinanmaquinoa un fotomapai mai huashquin —ishon Pilato yocani. Ascaiton, —Ahuu, —Pilato huani. Nan José Jesús icoinra huatanafiashocai tsoashta yoinima. Nocon caifo niaifofoqui musuquin ato yoipainima. Nan Nicodemo futan Josén Jesús ihui coyan iquinanmaquinoa fotomani mai huashcaquin. Nan Nicodemo arifi Jesusqui yamu oni yocaicain. Afi ininti shara ichapa treinta kilo cuana funi Jesús ahuun caya raishashquin funa payocononma. Nan ininti rafu osinan huani tuipa yafi ofucoin. Nan ininti ahuun anu rafu mirra yafi aloes. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ascano José yafi Nicodemo inintinin pano osho shara ahuun raishashon ahuun raconifo. Nocon caifo Israelifoan nocon yora mai huaquin amisifo cuscan huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nii funuamamishti mapoa anoshon afi ano chaimashtashon Jesús mastanifo. Nannori mahua quini funa tsoacai a muran maiyomisima. ");
INSERT INTO mcdNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nocon caifo nan Israelifo nocon tunutitian iyocoshquin icaino fari iquiataima Jesús mai huariscapainifo. Ascan nan mahua quini chaimashtacun a muran Jesús mai huariscanifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ascano Domingoaino shafataimashta María Magdalena Jesús maia mahua quini ano cani. Caquin oian mahua quini ahuun fupoitan man fupucua ini. Nan toquirininhuan man fupucua ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ascaiton oinfainnicai María ichoni Pedro yafi ua chanihuaicai, Jesús uhuun noimisi noco chani huaicai ichoni, —Nocon Ifoan ahuun caya quini murannoa man raquiran onuafo noncai tapiama, —icaiton nicai. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro fu non maia ano ichoni. Mahua quini muran oincai. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Un Pedro shononfaini un rufofo noconi. Chipo Pedro nocotoshini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rufofo nocotan mahua quini tucupacucahuatan un naistoshini. Naistoshiquin oian ahuun racoitan pano mania ini. Ascafiancai iquitoshinima. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ascaino Pedro ucachiori nocotoshitan mahua quini muran iquicaintan oinquin oian ahuun rashuitafo mania ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ahuun foraconitafo fosoitaquiri mania ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ascaino unfincoin quini muran iquicaini. Iquicaiquin oinquin un icoinra huani Jesús funia. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Oinyoshomacai Diosin tsain yoia cuscan, —Jesús funishqui ain, —non tapiyonima. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ascaiton ointan nocon pushu ano non nasocurani. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Non cafiainocai María canima. Mahua quini cachiori niashu uaiqui arifi quini tucucain naisquin oian. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Diosin oinmati rafu afu ica sahuuti oshopa sahuucanashu tsaoafo ini Jesús rataintanfoanno futsan fosoitaquiri icaino futsan ahuun tau iquitaquiri tsaoafo inifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—¿Ahuuscain min uaicain? —oinmati Dios fu imisiton rafutan huaifoan. —Uhuun Ifo man ahuun caya raquira onuafo uncai tapiama ahuuscara huaforan, —huatan. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ifiacucahuaquin oian Jesús acachori nifiacucai onannima. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús arifi yocaquin, —¿Ahuuscain min uaicain? ¿Min tsoa funaimun? —huaiton. Afía fasi oromisi shafain, —Minmain uhuun Ifoan ahuun caya rani huaquin ua yoihuu. Un afanan nuno mai huanon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús, —Maria, —yoini. Ascaiton foisini foanquin oian nan Jesús ahuun fusocoincun. Israeli tsainman, —Rabuni, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Ua muyamaquin. Uhuun Upari un cataimacai. Ascan ua muquima. Uhuun yorafo ua ato yoishotacahuun isca huaquin, “Uhuun Upa ari un caicain. Nan uhuun Uparifi maton Upaquin. Nan uhuun Diosifin mato Diosiquin,” ato huatahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ascashu cai María nocoshon yoiquin, —Munfin nocon Ifo un oianquin, —ishon. Noco yoini nan Ifoan yoia cuscan huafain noco yoipacuniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Asca huatan tunutitian iyoconaino man fari caino non afu rafumisifoan nocon niaifofoqui musuquin non cunu fupoti futaonshacanashu non ichanan ano noco nushmancayan Jesús niriscatani. Ascaiton noco yoiquin, —Maton ointi fucashcaquima isharacahuun —ishon noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yoitan noco ismaquin a piriconun mastaitafo tsuhuu ismaquin mushanshotan ashin pishi chachitan noco ismaniquin. Noco ismaiton non oinni fasi nocon Ifoqui unimacoinni. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Afanan Jesús noco yoiquin, —Maton ointi fucashcaquima isharacahuun. Nan uhuun Upan ua nichini cuscan huafain natian un matorifi nichiran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ascashon nocoqui ashaintaquin, —Uhuun Upa ahuun Yoshin Shara ficahuun. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ratoran futsan man aton chaca rauhuacufin Diosin aton chaca soashoshquin. Man aton chaca rau huamafin atohuun nuaquin, —ishon Jesús noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ascashon noco yoiainocai Tomás fusti ano inima. Nan Tomás arifi Jesús fu rafumisi futsa ini. Ahuun anu futsa Gemelo huapaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ascanshon Tomás Jesús oinshoma yoini, —Un ahuun mucu natan pirico tsuhuu uhuun mutotinin muifain ahuun pishi tsuhuu pimuishofin un icoinra huatiroquin. Un asca huayamashocai man Jesús oincoian un icoinra huashquimaran, —ishon Tomás noco yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Asca huatan ocho osha finontan non afanan cunu muran ichananfono Tomasrifi nanno no fu ini. Cunu fupoti futaonshacafono afanan Jesús nocoqui niriscatani. Ascashon afanan noco yoiquin, —Maton ointi fucashcaquima isharacahuun, —huatan. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesús Tomás isca huani, —Ua min mutotinin uhuun mucu natan muifain ua piiimuihuu. Afanan ua icoinmaran huaquima. Ua icoinra huahuu, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ascaiton Tomás cumaquin, —Minfin uhuun Ifoquin. Minfin uhuun Diosiquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Ua oinquisifin mian icoinra huaicai. Ascan ua oianmafianquin ua icoinra huafofin fasi unimashcaniquin, —ishon Jesús yoini. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ascatan ahuamamishti tsoa futsan atiroma cuscan ahuara futsafo Jesús noco oinmani. Afohuunoacai un mato cunushonama. ");
INSERT INTO mcdNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Upan Diosin Jesús catonni. Afin Diospan Facuquin. Un mato cunushona cuscan nan man icoinra huanon. Icoinra huaashu man Dios fu ipanon. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ascano Jesús afanan nocoquin noconiquin. Ianmanhuan Galilea cusumun noconi. Un mato yoinon ahuuscashumain Jesús nocoqui oniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pedron yafi Tomás nan ahuun anu futsan Gemelo non Natanael nan Canan murannoa Galilea anoa non Zebedeo facufo nonri afu rafumisi non ichananni. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Unfin nushuicaicain, —Pedro icaiton. —Non mifu cairan, —non huani. Ascashu focani shasho nanufain nushushifiaquin non shiman fustishta finima. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Shafa cuaino ian cusumun Jesús nia ini. Nifiacun non onannima. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","—Uhuun facufoan man shiman achiamamun, —noco huaiton. —Ahuashta non fiamaran, —non huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ascaiton noco yoiquin, —Shashon rushti cayacafi potacahuun. Ascashonfin man fitiroquin, —noco huaiton nicacaquin. Nan noco yoia cuscan non potani shashon rushti cayacafi potashon non mua fospicoian ini. Shimanoanfo ihuucoincun shasho muran nanupaiquin non rananni. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Unfinquin ua Jesús noicoinmisi. Ascacun un Pedro yoini, —Nanfin nocon Ifoquin, —un huani. Ascaiton nicaquin Pedron samamashta ahuun sahuuti sahuacufoantan shasho naquinoashu ian muran fotocaini ahuun Ifoqui nocoriscapai. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ascaiton atirifiton non shashon mufaini. Nocon nushuti fospicun shashoqui nushashon non aya tohuufoni. Ian cushan chaima shara. Cien metrocuana. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Non cusumun nocoquin oian chi cutuai ini shiman shoi yafi yoa chi cusumun raca ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ascatan Jesús noco yoiquin, —A man rama shiman fia futsan fucahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ascaino Pedro shasho naqui nanupacucahuan noco nushuti cusumun sharashon. Non oian shimanoanfo nushuti fospicoian. Ciento cincuenta tres shimanoanfo fospicoinfiashocai nushuti fashnunima. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ascaiton Jesús noco yoiquin, —Piyoi fucahuun, —noco huaiton. Nicacaquin. —¿Min tsoamuncai? —non huanima. Man nonmain tapishofin nocon Ifocun. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ascanshon Jesús noco pimaquin noco nantifi yoa yafi shiman inanni. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Man funitashaquin nocoqui oi rafu non fusti ya ini. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Piquin anaititan Jesús Pedro yocani, —Pedron minfin Juanpan facuquin. ¿A mifu rafuafoan ua noicoiainfo finonmafain mian noicoianmun? —huaiton. —Aifain Ifon. Man minfin tapiaquin un minhuun noicoiain, —huaiton. —Ua noisharashon ua rama icoinra huafori ato cushusharahuu ua tanasharanonfo, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Afanan Jesús Pedro yoini, —Pedron, minfin Juanpan facuquin. ¿Iconmun mian fasi noicoiain? —huaiton. —Aifain Ifon. Man minfin tapiaquin un mihuun noicoiain, —huaiton. —A ua noisharashon ua tanamisifori ato cushusharahuu ua tanasharanonfo, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ascaiton afanan yoca futsani, —Pedron, minfin Juanpan facuquin. ¿Mianmun noiquin? —huaiton. Yocariaiton Pedronun fasi ointi noconi. Ascashon afanan cumani, —Ifon, minfin ahuamamishti tapiaquin. Man min tapiari un mia fasi noicoin, —huaiton. —Ascan ua tanamisifo cushusharahuu ua tanasharanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pedron, iconcoin un mia yoinon. Pushcoshon nan min apaiyai cuscan min huaa. Ascatari nan min capaiyaiquiri min camisi. Ascan min anifo ano futsafoan mia yonoshquicani. Min capaiyamaiquiri mia iyoshquicani, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús Pedro tapimayoni ahuuscamain naiyaicain. Pedro ahuun Ifohuunoashu naicain tapishquin, —Upa Dios shararan, —huashquicaniquin. Ascano Jesús Pedro yoini —Ua tanasharahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Asca huaino Pedron ifiacucahuan ua oinni un ato mufainaiton. Ua fasi Jesús noimisi, Jesús nataima no futan yamu piyoaquin un Jesús yocani, —¿Ifon, tsoancai mia achimashquimun? —ishon un yocani. Nan ucaifin yocaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ascaiton Pedron ua oinquin yocani, —¿Ifon ahuuscamain Juan naiyaicain? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Un nimapaiyaino niyoi nan un nasoaitianri. Inon. Shinanyamahuu. Ascatama ua tanacoinfafainhuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ascano afu rafumisifo yoinannifo, —Juancai nayoimafinquin, —uhuunoa huanifo. Ascafiacai Jesús anori yoinima. Yoini isca huaquin, —Un Juan nimapaiyaino niyoi nan un nasoaitianri. Inonpun shinanyamahuu, —ishon nan fusti Jesús anori ani. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Unfin Jesushuunoa yoimisiquin. Jesús ahuarafo huai cuscan mun oinmisiquin. Nanfo un mato cunushoni. Ascacun uhuun tsain man icoinra huatiro. Nantififain man man tapia un ahuunoa yoiaiton nan iconcoin. ");
INSERT INTO mcdNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ahuarafo Jesús ani cuscacai non afoqui cunuqui nocotiroma. Unquian Juan un mato cunushoni. Nanti.");
INSERT INTO mcdNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Unquian, Lucas, un afanan mia cunu fomai min tapinon. Uhuun yora Teófilo, Jesús mai ano iyoshon ani cuscan huafain yosini cuscari Apa Dios ari cainitian nanfohuunoa un mia cunushoni min tapinon. A fu rafuafo catonni ato Diospan Yoshin Sharahuunshon tapimashquin. Apa Dios ari caiyoataima ato tapimaiyofafainpaoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Atohuunoashu nayoaitian cuarenta oshatan Apa ari cani. Cayoataima atofu iyopaoni. Ato ahuamamishti oinmayoni afanan funia cuscan icoinra huanonfo. Nantianri Diosin nantifi ato iquinai cuscan ato tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ichanancashon piyaifoan ato yoini, —Un mato yoimisi cuscan uhuun Upa Diosin mato tapimayoni ahuun Yoshin Shara matoqui nichishquin. Nocoataima Jerusalén anoashu foriyamacahuun. Manayocahuun. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juanpan ato unu muran iquimapacuni aton chaca shatushon oinmanonfo. Ascano samamashta Upa Diosin ahuun Yoshin Shara mato ya imapacunon, —ishon Jesús ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ascatan chipo afanan afu ichanancashon yocanifo, —¿Ifon, min natian yonoimamun nocon caifo Israelifo nocon niaifo fusti inon Romanofoan aton niaifoan afanan noco yonononma? —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ahuutian iquimancai mancai tapitiroma. Nocon Upa Diosin fustiton yonotiro ahuutianmain ishquicain. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ascafia Diospan Yoshin Shara matoqui oshon ahuun curushu mato inanshquin. Ahuun shinanhuunshon uhuunoa man ato yoifoanfafainon. Un amisi cuscan huafain un yoimisi cuscari man man oinmisi man nicamisi cuscan nantifi uhuunoa man ato yoitiro. Nuno Jerusalén anoa yoifain nantio Judea muran yoifain Samaria ano yoifain nantifi manifotiton uhuunoa man yoifoanfafainon, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yoiquin anaititan aton ointaifi nuinacahuani. Oiainfono nai coin muran ihuacainaiton afanan oinnifoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Foiscaquin oianfo nocofunu sahuuti oshopacoin sahuua rafu atoqui niriscatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ascashon ato yoini, —Galilea anoafoan, ahuuscain man nai ari foisain. Jesús man nai muran caa nanscacoin acurani afanan oshquiquin, —ishon Diosin oinmati afu imisiton rafutan Jesús fu rafuafo yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ascatan machi Olivo anoashu Jerusalén ano nasofainifo. Nan machi Olivo Jerusalén chaimashta ini. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Nococatan pushu osa futsa fomancayan inacashon Upa Dios cufinifo. Nanno Pedro non Jacob non Juan non Andrés non Felipe non Tomás non Bartolomé non Mateo non Jacob futsa Alfeopan facu non Simón nanton ahuun caifo futan Romanonfo cachiquiri huapainifo, non Judas Santiagon facu non Jesús chipocufo non ahua María non ainfo futsafori nanno inifo. Ichanancashon shafa rananun Dios cufinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cufiaifono nanno ciento veinte yorafo atofu ichanannifo. Ichananfono Pedronun ato nastui nishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Isca huaquin, —Uhuun yoramishtichin ua nicacahuun. Judaspan ato tapimaita ahuuscashomain nocon Ifo Jesús achicanicain. Nocon shuni David Diospan Yoshin Sharahuunshon inonpacoai cunuyoni cuscan Judaspan man aca. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","No fu rafupaoni. Nocon Ifoan noco yonoai cuscarifi huaquin nan Judasri yonopaoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nocon Ifo tanayopaonifiashon fasi chaca huani. Nocon Ifo ato achimacun ahuun rafanan pui inannifo. Nan puihuushon mai fitan nanno fomancayan inashu aficoin tunushumutan pacucuranpai ari rononi. Chipo ahuun posto farashutan musiriquicahuan pacuni. Pacuaino ahuun posto toshatani. Ascaino ahuun poco arasiquifutsuni. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nantififain Jerusalén anoshon nicafo. Ahuun imi focun nanno anunifo, “Imi mairan,” huani. Yora futsan aton tsainman Acéldama. Nocon tsainman imi mai. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nocon shuni David Judashuunoa inaca cuscan aquin cunuquin isca huani, “Ahuun mai ano tsoa afanan ano inonma, Ahuun yono nocofunu futsan finon cushumisi inon,” ishon David ahuunoa inonpacoai cuscan cununi. Ahuun cunu anunifo Salmos, huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ascacun non futsa catononcahuun. Judaspan ahuun yono finon. Nan Juanpan yorafo unu muran iquimapacunitian non Jesús nomaqui Apa ari canitian no fu itiani non catononcahuun. Nan no fu cahuascapaoni non catontiro. Non Jesús nican cuscan huafain non oinyomisi cuscan arifi huamisi ahuunoari yoinon. No futan yorafo yoinon, “Jesús funia mun oincoianran,” ishon ato yoinon, —Pedro huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nicacashon nocofunu rafu catonnifo. Nan fusti anu rafu non fusti ya ini. José Barsabás ahuun anu futsa Justoran huashon anunifo. Nocofunu futsa catonnifo ahuun anu Matías. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Aton catoncashon Upa Dios cufinifo, —Ifon, nantifi nocon nomuran non shinain cuscan min tapicoian. Noco tapimahuun ratocaimain nan nocofunu rafu min catonpaicain mifu rafumisi no fu inon. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas min yononi cuscan man pota faquishihuan muran canon. Nanno ipanon. Ascan futsan ahuun yono fianon mifu rafua inon, —ishon cufishonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Cuficatan toquiri tocoro rafuhuun anu nutanifo. Ascashon motica muran nanushon napacufoanni. Ascashon oianfo ratocaimain Jesús fu rafumisi iquicain. Ascashon oianfo. Matías ahuun anu nuucun. Nan catonnifo Jesús fu rafumisi atofu inon. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ascano Israelifoan aton fusititian ahuun anu Pentecostés ini. Nantianri Jesús tanamisifo pushu fusti muran ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ichanancatan pushu muran tsaocashon nicafo samamashta nai ariashu fuhuan nicatsain nicanifo. Pushu muran fuhuan rupifurannaiton nicanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nocotoshiaino ana ointsa chi rucun maratamufafainafo oinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ascaino Diospan Yoshin Shara aton nomuran nanutanaino nantifi tsain futsanman ipaitama inifoannifo. Nantifi ascai futsunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ascaino nantianri Israelifoan Dios tanasharapaicani manifoti anoashu Jerusalén ano funifo. Fusititian Jerusalén ano funifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ascan fuuhuanun oi cuscara nicafuracani Jesús tanamisifo ichananfo ano ichotoshinifo. Yorahuanrasi nocotoshinifo. Nococatan yoinannifo, —¡Aira! ¿Ahuuscashucon iscaimun? ¿Ahuuscain na yorafo nocon tsainman icanimun? ");
INSERT INTO mcdNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Na yorafo Galilea anoafofiacashon nocon tsainman noco shafacafi yoi. Nan noco tsainman noco yoicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nonfin tsain futsa futsatapa yafo. Atirifi Partia anoashu caiyainfono, atirifi Media anoashu caiyainfono, atirifi Elam anoashu caiyainfono, atirifi Mesopotamia anoashu caiyainfono, atirifi Judea anoashu caiyainfono, atirifi Capadocia nan Ponto muran anoashu caiyainfono, atirifi Asia anoashu caiyainfono. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Atirifi Frigia anoashu caiyainfono, atirifi Panfilia anoashu caiyainfono, atirifi Egipto anoashu caiyainfono, atirifi Africa nan Cirene orima futsa anoashu caiyainfono, atirifi Roma anoashu caiyainfono, atirifi Israelifo yafi mani futsafoan Diosin tanapainifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Atirifi Creta anoashu caiyainfono, atirifi Arabia anoashu caiyainfono. Nonfin manifoti anoashu nuno ichanain fuaquin nan Galileafoan nocon tsainman noco yoicani. Ahuara sharafo Diospan huaa noco yoiafo, man non nicai. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","¿Ahuuscai na yorafoan nocon tsain tapiamafiashon noco tsainman noco yoicanimun? —inifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ascano futsanfoan ato cashu mutsama huaifoan, —Na yorafo pauncaniran, —ato huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ascan Jesús fu rafuafo once ato nastui nishon Pedronun oi ashcafinin isca huaniquin. —Uhuun yoramishtichin Israelifoan nunoa Jerusalén anoafo futan ua nicasharacahuun. Un mato cayacafi yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Atirifiton man shinan raca non pauin. Ma. Noncai pauinma. Man shuni cuyainano nocon yorafo paunmisima. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Non pauntamarocon man oiain cuscan nocon shuni Joel inonpacoai cuscan yoiniquin. Diosinhuushon isca huaquin yoini, ");
INSERT INTO mcdNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Upa Diosin noco yoi isca huaquin, “Uhuun facu oti chaima un manifoti anoafo uhuun Yoshin Shara atoqui nichishquin. Ahuunshon maton facufo nocofunufo non ainfofori inonpacoai yoishcaquin. Maton pushcoaifo namapan cuscara un ato ahuarafo ismai. Maton anifofoanri uhuunshon aton namapan cuscara ahuarafo shara oinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ua yonoshonafori nocofunufo yafi ainfofo uhuun Yoshin Shara un nantianri atoqui nichishquin inonpacoaifoanri uhuun tsain yoishcani. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ahuamamishti tsoan oinyomisima cuscara un nai aria yafi mai ano un ato ismai. Imi yafi chi urumanhuan non coinmahuan ishquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Uhuun facu nan maton Ifon fasi sharashtacoin matoqui oaiton man oinshquin. Oataima faquishihuancoin ishquin. Oshuri imi ointsa oshicoin ishquin. Afanan oaitian ahuamamishti tsoan oinmisima cuscara nantifiton oinshcani. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ascanfiashon ratoran futsan isca huaquin, ‘Ifon, Jesús, uhuun ramapaihuu. Ua numahuu,’ huaiton Diosin numaiquin,” ishon Joel Diospan tsain inonpacoai cuscan yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Uhuun yora Israelifoan ua nicasharacahuun. Jesús nan Nazaret anoaton Upa Diosin aqui unimani mato isma. Tsoan atiroma cuscan huafain tsoan oinyomisima cuscara huafain ahuamamishti futsafori ahuunshon Upa Diosin mato isma. Man man tapia non iconcoin. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ascafia Upa Diosin inon pacoai cuscan shinanni cuscan mato ahuun Furun inanni man rutunon. Manfin nocofunu chacafo futan ihui coyan iquinanqui mastaitaqui nanon. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Naafiacun Upa Diosin funimana afanan omitsiscacai nanonma. Jesuscai tsoan namapacutiroma. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nocon shuni David niaifoan Jesushuunoa yoini isca, “Mun tapian uhuun Ifo ufu ipanaca. Ua potapacunacama. Ua cushui. Ascan tsoancai ua ahuasca huatiroma ua ratupaiquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ascacufin uhuun nomuran un fasi unimacoin. Un nantifi ato yoitiro uhuun Ifoan ua cushuaino un unimai. Uhuun Ifo ua isca huaa, ‘Uhuun Ifon, Diosin, un nacuncai uhuun yoshin namisifo muran mian potaima. Mincai uhuun caya payocomaima. Ascan mun tapi un niyoano mian cushusharayoi’ ishon ua huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ahuuscashumain un nipasharatiroquin mian tapimana. Un miqui nocoano mian unimamacoinshquin,” ishon nocon shuni David cununi. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Uhuun yoramishtichin, un tapicoian cuscan mato yoi. Nocon shuni David nani. Man maifiani nanno natianri non ointiro. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ascafiano David inonpacoai cuscan Diosin tsain yoiyopaoni. A Diosin yoiyotiani cuscan tapia ini. Diosin yoiyoni chipo ahuun funari niaifocoin ishqui oi. Nocon caifo Israelifo a cuscarari nocon niaifo inon. “Un mia icon yoi min funa chipo mia cuscarari min caifoan aton niaifocoin inon,” ishon Upa Diosin David yoini. Diosicai tsoa paratiroma David tapini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ascano David chipo fari ichapa inaca cuscan yoini. Cristo funinonpacoai cuscari yoini. “Naacucai Apan naafo muran potanonpacoinma. Ahuun cayaricai payoconacamaran,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Icon, Upa Diosin Jesús funimaita nipanon. Nantififain man non oian. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Natian Apa Dios fu niaifocoin nantifi iquina. Apa yoiyotiani cuscan Jesús ahuun Yoshin Shara nocoqui nichian. Ascacufin natian man oian cuscan huafain man nica cuscan Diospan Yoshin Sharapan aca. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ascan nocon shuni Davidcai Dios ari ahuun cayafo ya nai muran canima. Ascashorifi yoini, “Ifon uhuun Ifo yoini isca huaquin, ‘Min ufu niaifo itiro nantifi iquinshquin. Mia noicasmaifori min ato finoncointiro afanan mia chaca huanonfoma. Atorifi min iquini. Un mia amashquinran,’ ” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ascacufin nantifi Israeli anoafoan maton nomuran tapisharacahuun. Jesús man ihui coyan iquinanqui mastaitafo Diosin yonoa nocon Ifo Cristo inon. Nan Apan catonni, —ishon Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nicaquin aton ointi noconifo, —¡Ohua! Non chaca huaita, —ishon shinannifo. Pedro non Jesús fu rafuafo futsanfo yocanifo, —Nocon yoramishtichin, non mato nica. ¿Non ahuuscatiromun? —ishon yocaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—Man chaca huamisi cuscan shatucahuun. Afanan chaca huatamarocon Dios shinancahuun. Jesucristo Ifo huacahuun. Man Ifo huaino mato unu muran iquimapacutiro maton chaca soafain Upa Diosin mato numanon. Asca huano Diosin ahuun Yoshin Shara matoqui nichishquin matofu rafucoinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jesús yoiquin isca huaita, “Ratoran futsan nuno nocon Ifo Diosin catoan ahuun Yoshin Shara mato ya rafumashquin. Maton facufo ya chai manifoannafori ato ya rafumashquin,” —ishon Pedronun ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yoitan afanan Pedronun ato tsain ichapa yoini. Ato yoiquin isca huani, —Maton chaca shatucahuun, uhuun yoramishtichin. Nocon caifo futan mani futsanfoanri man fasi chaca huamisifo. Ascarafo iyamacahuun. Jesús icoinra huacahuun mato numanon, —ishon Pedronun ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nicacaquin tres mil yorafoan icoinra huanifo. Ascano ato unu muran iquimapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ascatan Jesushuunoa tapipaiyaifoan Jesús fu rafuafo ya ichanancashon ato tapimafain ato futan pifain Upa Dios cufinifo. Asca huapaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nantififain Jesús shinancoinnifo. Ahuun tsain noiquicai ahua futsan shinanpainifoma. Nantianri Jesús fu rafuafoan atofu inifo. Doce Jesushuunshon afu rafuafoan tsoan atiroma cuscan huafain oinyomisifoma cuscarafo ato oinmanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ascatan Jesús icoinra huamisifo shafatifi ichanannifo. Nantifi aton ahuarafoya cuscan pashcananpacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aton mafo non ahuarafo inanmitsacashon ahuun rafanan pui ficashon yopaifo ato inanshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Shafatifiri Dios fu tsainti pushu muran ichanannifo Dios cufincani. Aton pushu muranri fasi unimacoinyanan ichananshon pishcaquin. Picaquin, —¡Aicho! Upa Diosin min noco shara huafafainiran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","—Upa Diosin min shararan, —ishon huapaonifo. Nantififain atohuunoa yoinifo, —Jesús icoinra huafoan shararan, —huanifo. Ascatari nocon Ifohuunshon shafatifi futsafoanri ato futan Jesús icoinra huanifo. Ato fu ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ascatan Dios fu tsainti pushu ano Pedro yafi Juan yatapacu Dios cufin focani fonifo. Yatatifi Dios cufi focani fopaonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nocofunu chato chatotiani nanscarapan cainni nan anosi shafatifi tsao tsaotiani. Atirifiton iyopaonifo anoashu pui yocacanon. Ascano Dios fu tsainti pushu shuinshcaian tsaoshon iquifurafafainaifoan ato pui yoca yocatiani. A caincaitinin ahuun anu sharashta. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro yafi Juan iquifainpaiyainfoan oinquin, —Ua pui inancapun, —ato huafiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro futan Juanpan fuuiscaquin Pedronun yoini. —Noco fuuisihuun, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","—¡Aicho! Ua pui inancaniran, —ishon ahuun nomuran shinanni. Ascanshon ato foisini. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—Uncai pui yamafinquin. Ascafiaquin un aya cuscan un mia inanon. Jesucristo nan Nazaret anoahuunshon funinaca huahuun. —Pedronun huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mananquiri mutsoinifoannaino funinaca huatan. Mua ahuun oposhco yafi ahuun tau muma curushu shara ini. Pedronun funaiquimashta mutsoinifoanpaiyaino afin fianshinacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","9","Ascatan man chaima catan. —¡Aichoran! —icashu, fia fiashuita unimani. Ichotiritiritan. Dios fu tsainti pushu muran atofu cani. Ato fu cashon, —¡Aichoran! Diosin muan caya huaquin. Dios shararan, —icashu ichotiritirini. Nantififain Israelifoan ichananti pushu anoshon oinquin futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Onancashon, —¡Aira! ¡Oincapon! Nan chato chatotiani caincaiti ahuun anu sharashtaran ano tsaoashu pui yocacamitsamisi. ¿Ahuuscashumun cahuacacainniquin? Noncai ascara oinyomisimaran, —icashu ahuun yoinnanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ascano nanno cunu futsan ahuun anu Salomón muranshon nocofunu chato chatotiani Pedro yafi Juan poyatani. Nantififain a oinpai atoqui ichonifo. Nocotoshiqui oianfo, —¡Aira! ¿Ahuuscaimun? —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Atoqui ichoaifoan Pedronun ato oinquin. Yoini, —Nocofunu Israelifoan ua nicacahuun. ¿Ahuuscain man mustairimun? ¿Ashuuscaquimun man noco shararan ishon oincain? Na nocofunu chato chatotiani caya huaran ishon. Non sharacucai nocohuunoashu cayama. Nocon curushhuunshocai cayama. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Noncai acama. Nocon Upa Diosin ahuun oinmati Jesushuunshon caya huaa. Nocon shunifo Abraham non Isaac non Jacobori Upa Dios aton Dios. Nan nocon Diosin mato oinmapai ahuun facu Jesús sharacoin ahuamamishti huatiro. Manfin Jesús achimanitaquin futsafoan rutunonfo. Niaifon Pilaton a nichisharapaifiaiton “Nacai nocon niaifomaran,” man Pilato huaita. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesuscai ahua chaca huamisima. Sharacoinfiacun mancai caimapaitama. “Jesuscai caimatamarocon rutumitsamisi Barrabás caimahuun,” man iquita. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jesús fustichin yora nimatirofiacun man rutuita. Man rutufiaita Upa Diosin funimanita. Non ointa Jesús funiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Man man tapia na nocofunu chato chatotiani imisi. Natian muma shara. Non Jesús icoinra huano ahuunoashu man caya. Man man oian. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Uhuun yoramishtichin, mun tapia man Jesús onanshoma rutua. Mato niaifofoanricai onanfoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Man aca cuscan tapiamafiaquin Upa Diosin nocon shunifo nan ahuun tsain yoishomisifoan inon pacoai yoiquin isca huanifo, “Cristo Diospan Furun omitsiscairan,” ishon inonpacoai cuscan yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ascacun man chaca huamisi cuscan shatucahuun. Chaca huatamarocon Upa Dios shinancahuun maton chaca soashonon. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Man ascaiton Upa Diosin mato unimamatiro. Ahuun Furun Jesús catonni maton numamisi Cristo inon. Matoqui afanan onon. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ahuun yonoshomisifoan nan inon pacoai Jesushuunoa yoinifo isca huaquin, “Upa Diosin yoiyotiani, ‘Un chipo nantifi funa shara imai. Afanan ahua chaca inonma. Un asca huayoai chain uhuun facu ufu nai muran iyoiran,’ ” inonpacoai cuscan Diospan tsain yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nocon shuni Moisés arifi yoini, “Nocon Ifon Diosin noco caifo futsa catonshquin noco inon pacoai yoimisi inon. Ua cuscara inon. Nantifi mato yoiai cuscan a nicasharacahuun. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tsoan a nicacasmai afo amaquishon potatiro ariashu omitsiscapanon,” yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel Diosin tsain yoiquin tau huani. Nan inonpacoai cuscan. Ascano chiporifi Diosin tsain yoimisifoan nannoricoinri yoinifo cuscacoin man aa. Nantififain Jesushuunoasi yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Manfin aton funafoquin. Ascan Diosin nocon shunifo yoiyotiani cuscan matori ashoshquin. “Min funahuunshon nantifi manifoti anoafo un ato shara huairan,” ishon Upa Diosin Abraham yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ascan ahuun Furun Jesús matoqui nichini ahuun oinmati inon. Matoqui nichiqui tau huani mato shara huanon maton chaca man cachiquiri huapanon, —ishon Pedronun ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ascatan Pedro futan Juanpan ato yoiaifoanno yorafohuunshon Dios cufimisifo Dios fu tsainti pushu cushumisifoanri aton niaifo non Saduceofori atoqui funifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Upa Diosin Jesús funimanaran ishon Juan futan Pedronun ato yoiaino aton nomuran shinanchacanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ascano man fari caino ato achinifo nan yamutan cunu muran ishinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ascafiashon ato Jesushuunoa yoiaifoan yorahuanrasifoan icoinra huanifo. Cinco mil nocofunufoan nantian icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iyoconaino Israelifoan aton niaifofo non Moisés cununi cuscan tapimamisifo Jerusalén ano ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nannori aton yorafohuunshon Dios cufimisi niaifocoin Anás yafi Caifás non Juan futsa non Alejandro non aton yorafori nanno inifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro yafi Juan caincurannaiton niaifofoan cusutumushon yocanifo. —¿Tsoan mato yonoamun man aca cuscan man huanon? ¿Tsohuunshon man acaya huamun? —ishon niaifofoan yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Asca huaifoan Pedronun Diospan Yoshin Sharahuunshon ato cumani, —Niaifofoan un mato yoisharanon. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Man noco yoca tsoa na chato chatotiani shara huamainquin. Man tapipai ahuuscashumain cayaqui. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Un mato cayacafi yoinon. Man nantififain uhuun caifo nan Israelifo yashon tapisharacahuun un mato yoinon. Jesucristo nan Nazaret anoahuunshon man caya muma shara inon. Manfin Jesucristo ihui coyan iquinanqui mastaitaquin. Man naafiacun Upa Diosin funimana. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Pushu yonomisifoan toquiri quishi shara potano pushu oni sharatiroma. Man potafiafo pushu ifoan catonni toquiri quishi shara nichishquin pushu mutsisipacoin inon,” ishon Diosin tsain cununi. Jesucristo nan toquiri quishi cuscara. Manfin pushu yonomisifo cuscara man man potafia Upa Diosin a catonni ahuunoashu man ahuun yorafo inon. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tsoa futsacai noco numatiroma. Manifotifoan tsoa futsahuunoashucai non ipatiroma. Jesucristo fustitofin nocon chaca soatiroquin non Upa Dios fu nipanon, —ishon Pedron ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ascan nicacani mustairinifo. Niaifofo yoinannifo, —¿Ahuuscaquimun na rafutan ahuamafiashon ranotama noco yoiquin? Cunu tapiamafiamisishaquin noco shafacafi yoi. Jesús fu rafumisishaqui noco anori yoiquin, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ascano chato chatotiani cayasharashu atofu nia ini. Ascaitocai niaifofoan, —Cayamaran, —ishon yoitiroma ini. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ascashonrifi Pedro yafi Juan cunu futsa muran nichinifo atohuunoa yoishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Non ahuusca huaimun na nocofunu rafu? Nantifi Jerusalén anoafoan tapiafo na rafuhuunoashu nocofunu chato chatotiani man caya. Ascara tsoan oinyomisima. ¿Nonmun ahuusca na nocofunu rafu huaicai? Noncai futsafo fomantiroma. Cayamarancai non huatiroma. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ascanshon non ato yoinon afanan Jesushuunoa tsoan yoiyamacahuun. Ascan futsafoanricai Jesushuunoa nicatirofomaran, —icashu yoinnanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ascatan ato cunu futsa murannoa cunani funonfo. Fuafoan ato yoinifo, —Afanan Jesushuunoa tsoan yoiyamacahuun. Ahuunoa yosiyamacahuun, —ato huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Asca huafiaifoan ato cumanifo, —¿Non mato nicayamaraquin Upa Diosin noco yonoa cuscan non nicatiromun? ¿Rato sharamun? Mafin shinancahuun. ¿Non mato nicaino Diosin nocoqui unimatiro iyamarai afin noco yonoa cuscan non yoiaino unimatiromainquin? ");
INSERT INTO mcdNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Non oinmisi cuscan huafain non nicamisi cuscari non mato yoitiroran, —ishon Pedro futan Juanpan cumanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Nicacani ato onaintimapaifiaquin nica nantifi yorafo, —¡Aicho! Upa Diosihuunshon chato chatotiani cuarenta fari aqui caa nanscarapan caini man cayahuamaforan, —ishon yoinifo. Ascan niaifofoan ato onaintimatamarocon ato yoinifo, —Man afanan Jesushuunoa yoiaiton non mato asca huatiroran, —ishon yoinifo. Yoicatan ato nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nocon yorafohuunshon Dios cufimisi niaifofo non Dios fu tsainti pushu cushumisifoan ato nichiano Pedron yafi Juan Jesús tanamisifo fu ichanannifo. Ichanancashon niaifofoan ato yoia cuscan chanipacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nicacaquin Dios cufinquin isca huanifo. —Nocon Ifon, min nantifi iquinaquin. Min nai onihuafain mai onihuafain ununhuan min onihuani. Nantio nai murannoa yafi mai anoa non unuhuan murannoa min onihuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","“¿Ahuuscaimun nan Israelifoma manifoti Diosqui fiishquicaniquin? Ipaitsi ichanancani chaca huapaicani. Manifoannati aton niaifofo ichanancani nocon Ifo Dios yafi Furun Cristo cuyopaicaniran,” ishon nocon shuni nan min oinmati David min Yoshin Sharahuunshon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nanscarifi atan nan niaifo rafu Herodes yafi Poncio Pilaton Israeliyamafiashu nocon caifo Israelifo fu ichanaintafo min Furun nan min oinmati Jesús min catonni chaca huashcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","“Uhuun facun nantifi yorafo omitsiscashoshquin ato nashonon,” ishon min shinanni. Min ahuamamishti huatiro. Ascan min shinanyoni cuscan huaitafo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ascan nocon Ifon, shinanhuun. Nonfin min oinmatifoquin. Noco ati ati huacaniquin. Min curushu noco inanhuun non min tsain ranotamacoin ato yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Min oinmati sharacoin nan Jesushuunshon tsoan atiroma cuscan huahuu. Ahuunshon isinin icaifo caya huafain tsoan oinyomisima cuscara sharafo ato oinmahuu, Upan, —ishon cufinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuficatan ichananfono mai naiyanaiyaini. Ascatan nantifi nanno Diospan Yoshin Sharapan ato iquini ahuun tsain cayacafi ranotama yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nantififain Jesús icoinra huamisifoan aton nomuran nannorisi shinannifo. Tsoan ahuara futsa shinantanima. —Nan uhuunarifi matonaquin. Un aya cuscan man yopaiton un mato inantiroran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ascatan nan doce Jesús fu rafumisifoan, —Nocon Ifon Jesús noco nashoashu funiaran, —ishon Diospan Yoshin Sharapan ahuun shinansharahuunshon aton caifo yoinifo. Ascatari nantifi nan icoinra huafo Upa Diosin ato shinanmashara unimacoinonfo. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Aton mai inanmitsafain aton pushu inanmitsanifo ahuun rafanan pui ficashon a Jesús fu rafumisifo doce pashcashoshcaquin. Yopaifoan pashcashonifo. Ascanrifi atan tsoa ahua yopatanima. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nantianri nanno nocofunu aton caifoan ahuun anu José. Nanton aton shuni Levipan funa. Unu nushmancayan rafu mai tomahuan ahuun anu Chipre anoashu cainni. Jesús fu rafumisifoan anu futsa tuqui huani Bernabé. Onicoinnin tsainman yorafo aton fupihuanmapaimisi shinansharamapaimisiran. ");
INSERT INTO mcdNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ahuun mau inanmitsashon pui fishon Jesús fu rafumisifo inan yopatanaifoan pashcashopacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ascano Ananías futan ahuin Safira mai inanmitsacashon ahuun rafanan pui finifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nanscatanfin atirifi pui tushu huafiashocai cuyoinanima. Atirifi Jesús fu rafumisifo foshoni. Ato fomani, —Nantifi pui un mato cuyoinaran, —ishon ato shinanmapaini. Aca cuscan ahuinin arusu tapini. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ascaiton Pedronun yoiquin isca huani, —¿Ananías, ahuuscaimun Satanás min nomuran yonoaino min Diospan Yoshin Shara paraincain? Min mai inanmitsashon pui fia atifincai min noco inanma. Atirifi min mucua mina inon. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Min inanmitsataima minacoin iyoa. Min atirifi mucupaiquin min noco yoia shara icuana. Ascatamarocon min noco fomanpai. Mincai noco fuparanima. Minfin Dios fuparanicai, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Asca huatapaiyaino Ananías nayacucahuani. Ascaino nantifi anoafo ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ascano pushcofoan rashunifo mai huai foshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Man ascano tapiamaino ahuinri nocotoshini. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nocotoshiaiton Pedronun yocani, —¿Man mai inanmitsashon rafanan pui fiamun? ¿Man man nantifi noco inanmun? —ishon yocaiton. —Ai. Mian yocai cuscafin iconquin, —ishon yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—¡Ohua! Ahuuscain min funu futan tsoan tapimaran ishon “Diospan Yoshin Shara man fomanpaiyain. Tsoan tapimaran,” ishon man shinan. Man shinan raca Diospan Yoshin Sharapan tapiama. ¡Oinpon! Na pushcohuaifoan min funu mai huatacani fucani miarifi mai huacaniran, —ishon Pedronun yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Asca huatapaiyaino Safira Pedro nia naman pacuriscatani. Ascatan charish acucahuani. Ascatapaiyaino iqui furapaiquin oianfo man naa fuchitoshitan ihuifainifo funu patashari mai huai foshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ascaiton nicacani Jesús icoinra huafo yafi futsafori ratucoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ascano ichananti pushu ahuun anu futsan Salomón Jesús icoinra huafo nantifi nanno ichanannifo. Nannori afu rafumisifo doceton Diospan Yoshin Sharahuunshon tsoan atiroma cuscan huanifo. Yorafoan aton ointaifi. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Icoinra huamafoan ato oinquin yoinifo, —Jesús icoinra huafo yora shararan, —ifiacatan Jesús icoinra huayamashu atofu rafunifoma. Musunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ascafiaino nocofunufo yashon ainfofoanri shafatifi icoinra huarianifo. Ascashu atofu ichanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ascano yora isinin icaifo ato shuhua naratashon ihuunifo. Ascashon nanfo fai cusumun ratani cahuaquin, —Pedron ahuun yora faquishi ihuafainaino raca cayatiroati, —ishon shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yorahuanrasi Jerusalén patashari icafo isinincaifo ato ihuunifo. Atirifi yoshin chaca atohuun nushon ato fucashni huaiton ihuunifo. Ascanshon nantifi ato caya huamapacunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jesús fu rafumisifoan acaifo cuscan huafain yoiaifo cuscan, —¡Aicho! Na yorafo shararan, —icashon yoinifo. Ascano Israelifoan aton yorafohuunshon Dios cufimisi niaifocoin yafi niaifo futsafoan nicacaquin shinannifo, —Atohuun noiai cuscacai nocohuun noima. Atohuunoa yoisharai cuscacai nocohuunoari yoimisimaran, —ishon shinannifo. Curafiamisifo Jesús fu rafumisifoqui fiishquinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ascano ato achimacashon cunu muran iquimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Iquifiafoan yamu nacucahuanaino Diospan oinmati afu nai muran icaton atoqui nocoshon ato yoini, —Dios fu tsainti pushu anoshon ato yoitacahuun. Ahuuscashomain nocon Ifo Jesús ato nimapacutiroquin ato yoitacahuun, —ato huani. Yoitan ato cunu fupotifo fupushoni. Fupushonano cain furanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Shafaino Dios fu tsainti pushu muran iquitoshicashon ato yosiacufainifoquin. Israelifoan aton niaifofo ichanancashon cunu cushumisifo aton niaifofo ato nichinifo Jesús fu rafumisifo doce ihuitanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ascano cushumisi niaifofo nococashon oian tsoa anoma oincani. Ascan naso furan niaifofoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Non ato matoqui ihuupaifia cunu fupotifo fupocoian. Nannoshon ranushumuafoan ato cushua. Non fupotifo fupushon cunu muran oian. Ano tsoa yamairan, —icashu cushumisi ranushumuafo aton niaifo uhuapafoqui chaninifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nicacani nocon yorafohuunshon Dios cufimisi niaifocoin non ranushumua aton niaifocoin non nocon yorafohuunshon Dios cufimisi naifofo futsafori mustairinifo, —¡Ohuashta! ¿Ahuuscain ascamun? ¿Ahua finoanmun? ¿Non ahuuscatiromun? —ishon fasi shinanchacatanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Shinainfoanno futsan atoqui nocoshon yoini, —¡Oincapon! Na nocofunufo man cunu muran iquimafia natian Dios fu tsainti pushu muranshon yorafo yosicaniran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nicacani ranushumua niaifon yafi niaifo patasharifo ato ihui focani. Fofiacashon curushcain ihuunifoma. —Non ato curushcai ihuuaiton yorafo sinatirofo noco toquirinin tsacatiroforan, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ato ihuunifo Israeli aton yorafohuunshon Dios cufimisi niaifocoin ato yocanonfo, ");
INSERT INTO mcdNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Non mato cayacafi yoita Jesushuunoa man yosinonma. Ascafia man Jerusalén anoafo atoti man yoiacufaina. Man ato shinanmapai nonmain na nocofunu Jesús rutumaitaquin. Noco rafancaniran, —huaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ascan Pedro futan Jesús fu rafumisi futsafoanri cumacaquin. —Nocofunun noco yonoa cuscan nicatamarocon Upa Diosin noco yonoai cuscan non nicacointiro. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Manfin Jesús ihui coyan iquinanqui mastaitaquin rutushquin. Man asca huafia nocon shunifoan aton Diosin Jesús funimaita. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Ua cuscara onihuafoti iquihuun aton Ifo inon,” ishon Apa Diosin Jesús yoini. Ascano Israelifo nocon Numamisi inon non chaca shatunon a ifo huashquin nocon chaca noco soashonon. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Non mato yoiai cuscan non afohuunoa yoimisi. Diospan Yoshin Sharapanri nannori yoimisi. Tsoan Dios nicacoianfin ahuun Yoshin Shara aqui nichishquin afu nipanon, —ishon yoiaifoan. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nicacani fasi atoqui fiishquinifo. Ato rutupaicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ato rutupaifiaifoan Fariseo ahuun anu Gamaliel ato nastui nishon ato yoini, —Oinfain. Ato chifi nichiyocahuun un mato yoinon, —ishon yoini. Nan Gamaliel Moisés cununi cuscan tapimamisi. Nantififain ahuunoa yoimisifo, —Gamaliel fasi nocofunu sharacoin. Fasi tapicoianran, —ishon ahuunoa yoinifo. Ascashu nanno ichanannifo a nicapaicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ato yoiquin isca huani, —Uhuun yoramishtichin Israelifoan ua nicasharacahuun un mato yoinon. Man nocofunufo rutupaicain. Oinfain. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Shinancapon. Fari futsan nocon caifo futsan ahuun anu Teudas, “Unfin mato niaifo itiroquinran,” ishon noco shinanmapaipaoni. Ascano cuatrocientos nocofunufoan a tanapaonifo. Ascafia futsafoan Teudas rutunifo. Ahuun tanamisifo pashcafainnifo. Ahua finontama. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chipo nocon caifo futsa Galilea anoashu noconi. Ahuun anu Judas. “Non niaifofo potanoncahuun,” noco caifo huani. Nanrifi rutunifo. Ascan nantifi ahuun tanamisifori pashcafainnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Ascacufin un mato yoicain ua nicasharacahuun. Jesús tanamisifoan apaiyai cuscan anaitiriscatiroquin. Diosin shinan cuscan yositamarocon nocofunun afi shinan cuscan yoiquin ipaitsi yositirofo. Ascaiyamaiton Diosin ato yonoaitocai tsoa ato shatumatiroma. Man ato shatumapaiquin Dios fu chaca huan tanain cafiscai man huaicain. Ascacufin ato ahuusca huayamacahuun. Ato nichicahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nicacani, —Ahuun tsain cayacafi. Noco yoia cuscan non anon, —huanifo. Ascano Jesús fu rafumisifo iquifuranifo. Iquifuranaifoan fichiqui tuchiaton ato fasi coshaqui futsanifo. Coshatan, —Afanan Jesushuunoa tsoa yoiyamacahuun, —ato huanifo. Yoitan ato nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Atomaqui focatan —¡Aicho! Upa Diosin nocoqui shinansharaquin non Jesushuunoashu non omitsisca. Ahuunshon niaifofoan nocohuunoa shinanchacaran, —icashu unimanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ascano shafatifi Dios fu tsainti pushu ano yafi pushufotirifi tsain shara yoinifo, —Nocon Ifo Jesusfin nocon Cristonquin. Diospan Furunmun, —ato yosiaino. Ato yoiquin unupaonifoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ato yosiainfoanno yora ichapafoan icoinra huacashon Jesús tanamisicoinfo inifo. Yora ichapafoan icoinra huariapaonifo. Nantianri nanno Israelifo Griego tsainman inifo. Shoco futsafo Israeli tsainmansi inifo. Nan Griego tsain yoimisifoan tsain chipunifo. —Nocon caifo aton tsain fusti yoimisifoan shafatifi tushu pashcanan huacashon aton ainfo funuomafo inain cuscacai nocon ainfo funuomafo atori ati inanmaran, —ishon tsain chipunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ato nicacani Jesús fu rafumisifo doce nantifi Jesús tanamisifo ichanancashon ato yoinonfo. —Non mato Diospan tsain yoifafaini. Noncai unutiroma mato tushu pashcashoshquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ascan nocon yoramishtichin, maton murannoa nocofunufo siete catoncahuun mato tushu pashcanan huanonfo. Man tapia ratofomain Diospan Yoshin Shara fu rafucain shinansharamisiquin. Nan cuscarafo catonhuun non ato yononon mato tushu pashcanan shara huanonfo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ascan nonfin shafatifi Upa Dios cufifafainicain ahuun tsainri yoishquin, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nicacani nantifi unimanifo. Ascashon Esteban catonnifo. Nanton fasi icoinra huamisi. Diospan Yoshin Sharapan a iquina ini. Felipe non Prócoro non Nicanor non Timón non Parmenas non Nicolás afo catonnifo. Nan Nicolás Israelifomafiashon nanfoan Diosin icoinra huaa cuscan arifi anorisi acaifo cuscan shinanni. Antioquía anoashu cainni. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aton catoncashon Jesús fu rafumisifo ano iyonifo. Ascan nan doce ato manmancashon Upa Dios cufishonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ascatan Diosin tsain mai futsafoanriri yoifoanfafainifo. Jerusalén anoshon samamashta icoinra huanifo Jesús tanamisifo ica ini. Israelifoan aton yorafohuunshon Dios cufimisifo ichapafoanri Jesús icoinra huacashon ahuun tsain nicacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Upa Diosin shinanmasharani ahuun curushu inanni. Ascan ahuunshon ahuamamishti yora atiroma cuscan ato ismani. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ascano Israelifoan aton ichananti pushu futsa nanno ichananshon ato anunifo. —Apaiyai cuscan huatiroforan, —ishon atohuunoa yoimisifo. Nanfocai afanan oinmatifoma. Nanfoan aton mai Cirene anoashu non Alejandría anoashu non Cilicia anoashu non Asia anoafori. Nanfo Esteban fu fochismanantanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Fochismanantanapaifiaifoan Diospan Yoshin Shara Esteban shinansharamani. Cayacaficoin ato yoiaino tsoan cumanima. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ascano fustirasi yoinanpacunifo. Tsoa futsa nicanonma. —Estebanhuunoa tsain chaca yoitacahuun. Nanton Moisés yafi Diosqui tsain chaca huaaran, —ishon ato yoitacahuun. Estebanhuunoa chani yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ascan ahuunoa chani nicacani yorahuanrasi Estebanqui fiishquinifoqui. Ascano niaifo patasharifo non Moisés tsain tapimamisifoanri Esteban achinifo niaifofo ano iyoshcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ahuunoa chani yoinifo, —Na nocofunun nocon Dios fu tsainti pushuhuunoa yafi Moisés noco yononi cuscahuunoari tsain chaca huariai. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Man non nicamisi yoiaiton, “Jesús Nazaret anoaton nocon Dios fu tsainti pushu paoanshquin. Moisés noco yononi cuscari fiananan huairan,” —ishon chani yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ahuunoa chani yoicashon niaifofoan fuiscaquin oianfo ahuun fuso. Diospan oinmati afu nai muran ica ointsa fupishtacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ascatan Israelifoan aton yorafohuunshon Dios cufimisi niaifocoin yocani, —¿Mihuunoa chaca huafo cuscan iconmun? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban cumaquin isca huani —Uhuun yorafoan ua nicacahuun. Nocon shuni Abraham Harán ano icataima Mesopotamia ano ini. Nantianri Upa Diosin fasi chashacoinshon oinmaquin yoini isca, ");
INSERT INTO mcdNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Min mai anoashu non min yorafo anoashuri catahuun. Un mai futsa ari mia ismaicai. Nanno un mia iyoiran,” ishon Upa Diosin Abraham yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ascatan Caldeamaquinoashu canishaquin Harán ano ini. Anoashu apa nani. Naacun non icano Upa Diosin nichini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nuno nichifiashocai maishta inantaima. “Chipo min non min funafori un na mai inain matona inon,” ishon Upa Diosin yoiyotiani. Anori yoiai cuscacai Abraham facu yatai inima. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yoiari “Min funafo yora futsafoan mai ano iishquicaniquin. Aton maima ano iishquicaniquin. Nanno cuatro ciento fari aton yonomisifo iishquicani. Ato fasi curushcai yonomashcaquin. Fasi omitsiscashcani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ascacufin un nan yora futsafo onaintimai. Ascatan chipo aton mai anoashu focani nuno nocoshon ichananfafainshcaquin ua cufishcaniran,” ishon Upa Diosin nocon shuni Abraham yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ascan Upa Diosin Abraham yononi isca huaquin “Min furonanfacufo ato foshqui rupa shatuhuu. Ascan huatanfin min tapitiroquin. Unfin maton Upa Dios ipanacaquin. Un mato cushufafaini min funafo ichaparasi inon.” Ascacufin Abraham ahuun facu Isaac caintan ocho osha finontan facu ahuun foshqui rupa shatuni. Ascan Isaac nocofunuaitian man facu yari anuni Jacob. Ascan Jacob nocofunuaitian ahuun facu furonanfacufo doce. Nanfo nocon shunifo. Afohuunshon nocon caifo anumisi. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nocon shunifoan aton ushto José noicasmacaquin yora futsa inannifo ahuun rafanan pui fishcaquin. Ascan José Egipto ano iyonifo nanno aton yonomisi inon. Asca huafiainfoan Upa Diosin José potanima. A fu imisi. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","José omitsiscafiaiton Upa Diosin numani ahuun nomuran shinansharamani. Ascano Egipcio niaifoan Faraón fasi José fuchipaipaoni. “Min niaifo patashari itiro. Nantifi uhuun yorafo non uhuun caifo min ato nantifi yonotiroran,” ishon Egipcio niaifoan José yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Asca huatan nantifi Egipto anoafo non Canaán anoafori fonicoin omitsiscapaonifo. Nocon shunifo tushuoma inifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nantianri nocon shuni anifoshta Jacob arifi tushu yamaino nica Egipto anoafo man shuqui ichapa ya inifo. Asca ahuun facufo nanfo nocon shunifo nichini Egipto ano shuqui finonfo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Asca huatan chipo afanan Egipto ano fonifo tushu ficani. Nantianri José ahuun ochifo futan chipocuton onannifoma. Onainyamafiaifoan “Uquian, José un maton ushto,” ishon ato yoini. Ascatan Egipciofo aton niaifo Faraón arifi José ahuun yorafohuunoa nicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chipo José apa tsain fomani, “Upashtan, uqui ohuu. Un nunoshon mia cushusharanon. Nocon yorafori uqui ihuuhuun. Nan setenta cinco yora uqui ihuuhuun, upashtan” ishon José yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ascatan Jacob yafi ahuun yorafori Egipto ano fonifo. Nannoashu nocon shunifo ya nai cuyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Naacun aton caya Siquem ano iyonifo mai huanonfo. Nocon shuni Abraham mai fiini. Nocofunu ahuun anu Hamor mai inanni pui finon. Nanno mahua quini muran nocon shunifo mai huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ascan Upa Diosin Abraham yoiyoni cuscan ato Egipto anoashu cainti chaima. Nantianri nocon shunifo Egipto ano fasin ichapacoin ini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nantianri Egipciofoan aton niaifo funapacai nocon shuni Joséhuunoa nicayomisima. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nanton nocon shunifo parafafaini. Ato omitsiscamani. Fasi curushcain ato yonomani. “Maton facufo rama caincun potacahuun nanonfo,” ishon ato yononi. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nantianri nocon shuni Moisés cainni. Caianshu rato facu futsacai a cuscarama. Upa Diosin aqui unimai. Oshu rafu non fusti apa yafi ahua pushu muran onunifo Egipciofoan fuchinonfoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Oshu rafu non fusti finontan facu chifi cainmafiashon shihuatinin fuposhon unu cusumun tsaoni a murannoashu uaicaiton niaifoan facu shomayaton fuchishon ihuini ahuun facucoin cuscara inon. Ascanshon pushconi. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ascatan Egipciofoan tapiafo cuscan Moisés yosinifo. Fasi ahuun mapo shara. Egipciofoan tapini cuscan arifi tapiniquin. Ahuun tsainri cayacafi shara. Niaifo sharapan atiro cuscan arifi asca huapaoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ascan Moisés cuarenta fari aqui caano ahuun nomuran shinanni isca huaquin, “Un natian uhuun caifo nan Israelifo ato oin cai atohuunoa tapishquin,” ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Atoqui nocoshon nocofunu Egipcion Israeli coshaiton oinni. Ahuun caifo numapaiquin curushcain Egipcio coshaquin namani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Asca huatan ahuun nomuran shinanni “¡Aicho! Un aca cuscan uhuun caifoan nicacanquin tapitiro Diosin ua yonoa un ato numanon,” ishon shinanni. Anori shinanfiaino ahuun caifoancai anori shinannifoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nan ifainaca shafatan oinpaiquin oian ahuun caifo rafu sutunainfoan oinquin. Ato numapaiquin, “Unucahuun. Manfin yorahuan tananquin. ¿Ahuuscaimun man sutunaincain?” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ato numapaifiaiton ahuun caifo futsan sutuaiton cumaquin chaca huani. “Mifin ihuu. Mincai ahuama. ¿Tsoan mia yonoamun min nocon niaifo inon min noco iquinon? ");
INSERT INTO mcdNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Min Egipcio nocofunu rutuita cuscan uarifi mian rutupaimun?” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nicatan Moisés mai futsari ichoni. Nan mai Madián ano ichoni ato muran iyoni. Nannoshon ahuun facu furonanfacu rafu ani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","31","Ascano cuarenta fari finoanno Diosin ahuun oinmati afu nai muran ica Moisésqui nichini. Nantianri Moisés machi ahuun anu Sinain chaimashta cani. Nanno pushu yamacain nii yamai. Fasi yafi chofo uhuapama fusti nanno. Nii cuyamamishti urufiainocai coonima. Moisés oinni. Oiainno mustairini. Ascan tapipai ahuuscain nii cuyamamishti urufiashucai nocaima chaimashta cashon. Oinni nii cuyamamishti uruai muran Upa Diosin ahuun oi nicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Unfin min shunicaifoan aton Diosiquin. Abraham non Isaac non Jacobori un aton Diosiran,” ishon yoini. Nicatan Moisés ratui taritarini. Afanan uru oinyamafiain aqui ratuni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Unquian un nuno ica. Ahuara chaca ufu itiroma. Ascan min sapato pucahuu un mia yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Uhuun yorafo Egipto ano omitsiscai cuscan mun oian. Man pashapaiyaifoan mun nica. Ascan un fotoa ato caimashquin. Natian un mia Egipto ano afanan nichicai.” ");
INSERT INTO mcdNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nan Moisés nocon shunifoan a nicacasmanifo. “¿Tsoan mia yonoamun min nocon niaifo inon noco iquinshquin?” ishon yoifiafo Upa Diosin Moisés catonni nocon shunifoan aton niaifo inon ato numanon. Nan nii cuyamamishti uruai anoshon Upa Diosin Moisés afanan Egipto ano nichini nocon shunifo numanon. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nanno Dioshuunshon ahuarashta tsoan oinyomisima shara ato ismani yoran atiroma cuscan ato ismani. Unuhuan ahuun anu oshin anori tsoan atiroma cuscan Dioshuunshon ato ismani. Tsoan istaipamashon nanscasi huapaoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nocon shunifo Israelifo yoini “Chipo Upa Diosin nocofunu ua cuscara matoqui nichishquin. Nocon caifo ishquiquin. Inon pacoai cuscan mato yoishquin a nicasharacahuun,” ishon Moisés ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés tsoan istaipama ano nocon shunifo fu ipaoni. Machi Sinain anoshon Diospan oinmati afu nai muran icaton a yoini cuscari nocon shunifo tapimani. Nan Diospan tsainman noco nimapacutiro ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yoifiaiton nocon shunifo Moisés nicacasmanifo. “Min nocon yonotiromaran,” ishon shinanni. Aton nomuran Egipto ano nasopaicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ahuun ochin Aarón yoinifo “Dios futsan cuscara noco rami huashohuun. Nanton noco tapimatiro non raqui caimancai. Moisés noco Egipto anoshon iyoafiacun ahua finoanmun noncai tapiama. Machi mamaqui inacun non afanan oianmaran,” ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nantian Aarón ato moipan facu cahua shara ointsa rami huashoni aton Dios inon. “¡Aicho! Nan moipan facu cahua shara ointsa non rami huaa. Nan nocon Dios. Non ichananshotiro moi futsa rutushoshquin a fufori ratashoshquin nocoquin unimanon. ¡Aicho! Non rami huaa cuscan shararan,” ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ascano Upa Diosin afanan atoqui unimanima. Ato potayoni “Ua afanan tanapaicanima. Ascacuncai un ato numaima. Aton diosicoinma ipaitsi aton nomuran shinantirofo. Fishifo ipaitsi shinantiro aton diosiran,” ishon Diosin yoini. Nocon shuni Amós inonpacoi cuscan Diosin tsain yoimisi ini. Diosin atohuunoa yoini cuscan cununi isca huaquin, “¿Man cuarenta fari pushu yamai ano cahuacacainnai ua yoina rutushon ua inanpaicani. Ahuara futsari ua inanpaicanimun? ");
INSERT INTO mcdNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma. Mancai maton nomuran ua shinancoianma. Man yoimisi isca huaquin, ‘Nocon dios Moloc yafi nan fishi Refán,’ man huamisi. Ahuara futsan man rami huashon. Noco diosiran man huamisi. Ascan un mato caifo futsa ano mato nichicai. Mato achinonfo aton yonomisifo man inon. Babilonia mai orima futsa ano fasi chai un mato nichicain.” ");
INSERT INTO mcdNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nocon shunifo tsoan icamano foanfafainpaonifo pano pushu fonifo a muranshon Dios cufinifo atofu inon. Ascan man isma Upa Dios aton Dios aforifi ahuun yoraquin. Upa Diosin nocon shuni Moisés oinmani cuscan pano pushu onihuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ascatan fari ichapa finontan nocon shunifoan nan pano pushu fonifo. Nantianri aton niaifo ahuun anu Josué ato iyoni mai futsa finonfo. Diosihuunshon caifo futsafo nan mai anoafo potanifo aton mai inon. Nan Josué niaifo taupaonino man fari ichapa finontan Davidrifi yositirofo pano pushu muran ichananpaonifo Upa Dios cufishcaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Upa Diosin David fasi noi aqui unimaicoinni. David Upa Dios cufinquin yoini, “Upa Diosin, min nocon shuni Jacob ahuun Dios nocon Diosiri, un mia pushu futsa shara huashoin. Ihui yafi toquiri pushu un mia onihuashopai a muran un non uhuun yorafo mifu inon mia cufishcaquin,” ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anori cufifiainton furun Salomón pushu huanshoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ascanfiacai Diosin yora pushu huaa muran itiroma. Diosin nai muran icanoshon nantifi finoncoian. Diosihuunshon nocon shunin inonpacoai cuscan yoini isca huaquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Nai muran un ica. Nannoshon un nantifi oni huati un iquini. Nan mairi un onihuani. Nai muranshon un mai oinfafainni. Nanri uhuuna. Nantifi onihuafoti nai murannoa yafi mai anoafoti uhuuna. ¿Ascan ahuuscashocon man ua pushu huashotiromun un a muran fusti inon futsa ano cayamashquin? ");
INSERT INTO mcdNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Un nantifi onihuanimamun?” ishon Diosin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Manfin maton shunifo cuscaracoinquin. Fasi nicayosmashunifo. Upa Diosin tsain nicapaicoincanima. Man icoinra huacoinmisima. Diospan Yoshin Shara mato yoimisi cuscacai man nicacoinmisima. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Maton shunifoan nantifi Diosihuunshon inon pacoai yoimisifo man ato omitsiscamapaoni. Inonpacoai yoimisi futsafoan yoinifo, “Nocon Numamisi isharamisi nocoqui oshquiquin,” ishon yoipaonnifo. Nanfoanri nocon shunifo man rutunifo. Man yoinifo cuscan nocon Numamisi shara nocofiacun nanrifi man rutuafo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Upa Diosin ahuun oinmati afu nai muran icafo nichini ahuun tsain mato inanfiafocai man nicapaimaran, —ishon Esteban ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nicacani fasi fiishquinifo. Aqui sinacoincani. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ascano Diospan Yoshin Shara Esteban rafuquinaino nai muran foisini Diosin chashamanaiton ointapaiquin oian Jesús Apa fu nia ini. Nan rafutan ahuamamishti huaifoan oinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Oinshon yoini, —¡Oincapon! Un nai muran oin. Nanno Jesucristo Diospan furun nocoqui nichini afu nia. Un oinran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nicacani aqui sinacoincani. Mucanifo. Ahuun tsain nicacasmacani pafopomunifo. Aqui ichonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Achicashon pushurasi pasotainri sharafonifo. Aton sahuuti pucashon ointiaca ahuun anu Saulo nia naman machinifo. Ascacatan toquirifoan Esteban tsacaquin futsanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Toquirinin tsacaifoanno Esteban iscani, —Ifo Jesús, uhuun yoshin mi ari ihuihuun, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yoitan ratoconun mai chachishon oi ashcafinin yoini, —Ifon, ua chaca huafiaifoan ato numahuu. Ato rau huahuun, —ishon yoini. Yoitan nani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naacun Saulo ato yoini, —Manfin shara huaqui rutuaquin, —ato huani. Nan shafatanri icoinra huamafoan Jesús icoinra huafo Jerusalén anoshon fasi ato omitsisca huanifo. Ascano Judea ari non Samaria mai ariri pashcafainnifo. Nan doce Jesús fu rafumisifocai atofu fonifoma. Jerusalén ano nitunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ascano nan Dios tanasharapaiyaifoan Esteban mai huanifo. Noicani fasi uainifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ascantan Saulon Jesús icoinra huafo fasi ato noicasmani. Ato cuyopaiquin. Fasi ato omitsisca huani. Pushuti iquicahuacacaini ato achishon cunu muran iquimashquin. Ainfofo yafi nocofunufori ato asca huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ascatan nan Jerusalén anoashu pashcafainnifo. Diosin tsain Jesucristohuunoa ato yoifoanfafaini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nocofunun ahuun anu Felipe Samaria mai ano cani. Nanno pushurasi futsan anoshon ato Cristohuunoa yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yorahuanrasifoan nicanifo. Dioshuunshon tsoan atiroma cuscan ato ismani. Ascaiton oincani fasi nicapaicani aqui taisinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yoshin chacafo yorafomaquinoa potani. Atomaqui potaino fiisifainifo. Yoratishon charishi futsuafo non chato chatotianifo Felipe Jesushuunshon ato caya huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Asca huano nantifi pushurasifoti unimacoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ascan nanno Samaria mai ano nocofunu ahuun anu Simón. Nanton yoshin chacahuunshon yoran atiroma cuscan huapaoni, —Tsoa futsacai ua cuscarama. Unfin fasi uhuapa sharaquin, —ishon cacapaimisiton yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ascano nantifi yorafoan nan niaifofo yafi yora ahuamafo a nicacoinnifoquin. —Nan nocofunu Simón fasi ahuamamishti huatiro. Diosihuunshon yora atiroma cuscan noco ismairan, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yoshin chacahuunshon yora atiroma cuscan huaiton oincaquin ahuamamishti acaiton nan fusti fari ranan tanannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ascafiainfoan Felipen ato tsain shara Jesucristohuunoa yoiaiton Upa Diosin yorafo iquinai cuscan a icoinra huanifo. Icoinra huaifoan ato unu muran iquimapacuni. Nocofunufo yafi ainfofori iquimapacuni. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nan Simón arifi icoinra huacun unu muran iquimani. Ascano Felipen Jesucristohuunshon ahuamamishti yoran atiroma cuscan huaiton oin fasi mustairini. Ascashon Simón Felipe mufoanfafainni acaiton oinquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ascano Jesús fu rafumisifo doce Jerusalén anoafoan Samaria anoafo Diospan tsain icoinra huaifoan nicacaquin Pedro yafi Juan ato ari nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Nococashon nan rafutan oian Samaria anoafoan nocon Ifo Jesús fusti icoinra huanifo. Ahuun Yoshin Sharahuunoa tapiataifoma. Ato iquinataima. Unu muran iquimapacuano Jesús fusti ifoancoinnifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ascano Pedro futan Juanpan manmanyanan Upa Dios cufishonifo ahuun Yoshin Shara ato iquinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Jesús fu rafumisifo rafu Pedro futan Juanpan ato manmanni Diospan Yoshin Shara ato iquinaiton Simón oinni. Oinshon yoini isca huaquin, —Uarifi tapimahuun man aca cuscan un ratoran yora mayatashon Diospan Yoshin Shara ya un ato imanon. Man ua tapimacun un mato pui inanon, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","—Ma. Min shinan raca non puihuushon Diosin noco inanpaiyai cuscan non fitiro. Anorimafinquin. Ascano minfin min pui ya min maicain. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Min nomuran min Diosihuunoa shinansharama. Ascacucain non Dios yonoshonai cuscan min no futan atiroma. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Min nomuran min shinanchaca cuscan mun onan. Mincai Diospan yonomisifoan atiro cuscan min atiroma. Ascan min chaca mimuran fospicoian. Chaca min ifo. Ascan nocon Ifo Jesús cufihuun min nomuran min shinanchaca cuscan rau huanon, —ishon Pedron yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","—Ua Ifo Jesús cufishohuun min ua yoia cuscan ua Diosin onaintimanonma, —ishon Simón cumani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ascatan Pedro futan Juanpan Samaria anoafo nocon Ifo Jesús tsain ato yoicatan Jerusalén ano nasofainifo. Focaquin pushurasifo ano ato tsain shara Jesushuunoa yoifonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nantianri nocon Ifo Jesús ahuun oinmati afu nai muran icaton Felipe yoini, —Na fai tapiaquiri nii yamai Jerusalén yafi Gaza nushmancayan catahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Caquin nocofunu Etiopía anoa oaiton oinni. Nan nocofunun ahuun caifo aton niaifo patashari. Ahuun niaifoncoin ainfoan. Ahuun caifo aton pui cushushomisi iniquin. Jerusalén anoshon catani Upa Dios cufitani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nasocurani oi ahuun inapan aya ninifoaino ahuun taramuti chinutamuashu cayacafi cani. Tsaoshon Diospan tsain Isaías cununi cuscan oinfoni aya caino. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Oinfoicai Felipe fu noconanni. Noconanshon Diospan Yoshin Shara Felipe yoini, —A taramutiyahuun aqui catanhuun —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aqui ichotan nicani Isaías nan inonpacoai Diosin tsain cununi cuscan anufoaiton. Nicaquin yocani, —¿Min oiain cuscan min tapiamun? —yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—Ma ¿Ahuuscashorocon un tapiafin? ¿Tsoan ua yosiamaiton? —huaiton. Ahuun iyomisi nitumatan. —Mapuinifoanhuun. U fu tsaoinacahuahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mapuinifoantan oinni Isaías cununi cuscan oinquin. Cunuquin isca huani, “Nan chashoan iyoshon rututirofo cuscan arifi iyonifo rutushcaquin. Chashoanun facu ahuun rani shatuainfoanno furoitiroma cuscarifiai arifi pusinima. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Rafini huanifo ahua chaca huaa nicayamafiacashon niaifofoan numapainifoma. Numatamarocon rutunifo. Chaca huacoinnifo cuscacai non cainmatiroma, tsoancai atirifi noco tapimatiromaran,” ishon Isaías cununi cuscan oinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ascashon Felipe yocani, —¿Isaías cununi cuscan ahuunoa cununi iyamaraimun futsahuunoa cununi? Ua yoipun, —ishon Etiopía niaifo patashari yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Cumaquin, —Isaías Jesushuunoa cununiran, —ishon cumani. Nan tau huaquin yoiaino Diospan tsain futsafori ismani a Jesushuunoa cununi. Diosin tsain shara ahuunoa oinmani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Caino atoqui unu noconi nocofunun etiope yoini, —Oinpon unu. ¿Mian na unu muran iquimatiromun un Jesús icoinra huacoinnai cuscan un ismanon? —ishon yocaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Jesucriston Diospan Furun min ointi muran min icoinra huacoinnaiton un mia iquimatiroran, —ishon Felipe yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Asca huatan ahuun iyomisi nitun huani. Nitun huano Felipe fu fotocani unu muran iquimanon. Ascano iquimapacufoantan cainmani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Unu cusumun nocoafono Diosin ahuun Yoshin Sharapan mai futsari Felipe iyoriscatani. Nocofunun oinni Felipe yamariscatanaiton afanan oinnima. Ascafiashu fasi unimai ahuun mai ari cani. ");
INSERT INTO mcdNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ascanrifiatan Felipe mai futsa ahuun anu Azoto ano nitariscani. Nanno yafi nantifi pushurasi Cesarea fai anori cashon tsain shara Jesushuunoa ato yoifoanfafaini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Nantianri Saulo nantifi Jesús icoinra huafo rutupaiyai. —Un nantifi Jesús tanamisifo un rutuicain, —ishon yoini. Ascan Israeli aton yorafohuunshon Dios cufimisi niaifocoin ano cashon yoini, —Ua cunushohuun un nantifi ichananti pushu Damasco ano ismanon min ua yonoa un Jesús icoinra huafo nocofunufo non ainfofori fuchishon Jerusalén ano un ato cunu muran iquimanon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ascanofin Jerusalén anoashu cai Damasco ano nocoti chaima samamashta nai arishon chashatanaino pacuni. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pacuquin ahuun oi nicani, —Saulo, Saulo, ¿Ahuuscaquimun mian omitsisca huaiquin? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Ifon, ¿Minmun tsoaquin? —ishon yocaiton. —Unquian Jesús. Mian omitsisca huai. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Funihuu. Pushurasi Damasco ano catashquin nannoshon min ahua huaimancain un mia yoinon, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yoiaino afu foafo puusinifoma. Ahuun oi nicafiaquin tsoan oinnifoma. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo funinaca huapai fushoacucahuanaiton mutsoinifoannifo. Ascashon Damasco ano iyonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nannoshon osha rafu non fustitan oinyamafain ayayamafain piqui tununi. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Asca huatan nanno Damasco ano Jesús tanamisi futsan ahuun anu Ananías namapan cuscara Jesús yoini, —Ananías, —huaiton —Unquian, Ifon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Fai Cayacafiran huamisifohuun catahuun. Ari cai Judaspan pushu ano catahuun. Nocoshon min ato yocatiro nocofunu Saulo Tarso anoashu cainni nanno pushu muranquin. Nannoshon Saulo ua cufinquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ahuun namapan cuscara mia oian min manmainno afanan oinsharanon, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","—Ifon, tsain ichapa ahuunoa mun nicamisi. Nantonfin mia icoinra huafo Jerusalén anoafo ato chaca huamisiquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Natianri mun nica Jerusalén anoashu nuno oi. Nocon yorahuunshon Dios cufimisi niaifofoan a yonoa nantifi mia icoinra huafo cunu muran iquimaniran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yoifiaiton, —Un mia yoia cuscan catahuun. Un na nocofunu catoan Israelifoma non aton niaifofo non Israeliforifi uhuunoa ato yoinon. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Uhuunoashu fasi omitsiscai un oinmacoinshquiran, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ascatan nicafainicai Ananías cani. Cai pushu muran iquini. Iquicain Saulo fuchitan manmantoshini. —Mun oa. Uhuun yorashtan, min fain oquin nocon Ifo Jesús oian. Nanton ua nichian min afanan oinsharafain ahuun Yoshin Sharapan mia iquinon, —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yoiaino ahuun furo murannoashu pusu cuscara fupacumuni. Ascashon oinsharacufaini. Ascatafin Jesús icoinra huashu unu muran iquitan funinaca huaniquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iquitan cainnacahuan pini. Pitan muacai afanan shaca fuanima. Ascatan mutsisinacahuani. Shafa ranan Jesús tanamisifo fu Damasco ano iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Anoashu ichananti pushu ano nocoshon ato yoini isca huaquin, —Jesús Diospan Furunquin, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nicacani mustairinifo. —Ahuuscaquitsi Jerusalén anoa Jesús tanamisifo ato chaca huafain. Nunoari ahuun tanamisifo munushushon nocon yorafohuunshon Dios cufimisi niaifofoqui ano iyonon natianrifi, “Jesús Diospan Furunquin” noco huaiquin, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ascano Saulo Jesushuunoa fasi tapiquin finacoinni. Ahuun curushu Jesús inanni ahuunoa ato yoinon. Ascan cayacaficoin ato yoini, —Jesús Diospan Furun nocoqui nichiniran, —ishon tsoa futsacai anori yoiaiton nicayomisifoma. Ascaiton shinancaquin, —¿Ahuuscashocaicon na nocofunun tapicoianmun? —ishon ahuun caifoan Israelifoan shinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ascano shafa rananun ichananshon Israelifoan shinanpainifo ahuuscashomain Saulo rutumatirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ascano futsan Saulo yoini, —Mia rutupaicaniran —ishon tapimani. Yonoafono shafatishon yafi yamutishon cushushinifo Saulo oaiton rutushcaquin. Pushurasi aton caincaiti anoshon cushunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Asca Saulo caicuranaiton rutupaifiaifoanno fomancayan pochinin tsuhuu anori futanmanhuan muran nanushon yamutan tanamisifoan fotomapacufoannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Fotomafo Jerusalén ano cani Jesús tanamisifo fu iquicai. Iquicafiaiton aqui musunifo. —Nacai Jesús tanamisicoinmaran, —icashu yoinannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ascafiaino Bernabé icoinra huacoinni Saulo tanasharacun. Ascashon Jesús fu rafumisifo doce ano iyoni ahuunoa shara ato tapimanon. —Damasco fain caquin Saulo ano caiton nocon Ifo Jesús oian. Ascano Damasco anoshon noco Ifohuunoa ranotama ato yoifafainiran, —ishon ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nicacaquin icoinra huanifo Saulo atofu Jesús tanamisi ica. Ascano atofu iyopaoni. Jerusalén anoafori ranotama nocon Ifo Jesushuunoa ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ahuun caifo Israelifofiashon Griego tsain tapinifo ato Jesushuunoa yoiaino fochishmanantanannifo. Ascashon a rutupainifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nannori Jesús icoinra huafoan nicacatan Cesarea ano iyonifo. Anoshon Tarso ano nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ascaino Jesús icoinra huafoan Judea anoafo non Galilea anoafo non Samaria anoafori isharanifo. Nantian tsoan ato omitsiscamanima. Diospan Yoshin Sharapan ato mutsismana Jesús tanasharashu aton nomuran fupi huamani. Nanscaino paratamafain Jesús icoinra huanifo. Icoinra huacashon Dios nicasharapainifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nantianri Pedronun ato yosifoanfafaini. Icoinra huafo Lida anori oinmitsai cani. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nannoa nocofunu ahuun anu Eneas fuchini. Charishi futsua ini. Ocho fari aqui caa funitiroma ini. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fuchishon Pedronun yoini, —Eneas, Jesucristo mia caya huamaquin. Funihuu min oshati shara huahuu, —ishon yoini. Asca huaino samamashta funina cahuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nantifi Lida anoafo non Sarón anoafoanri oincashon nocon Ifo Jesús icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ascatan Jope mai futsari ano ainfo ahuun anu Dorcas ica. Ahuun anu futsa Tabita. Nan ainfo Jesús tanasharamisi. Shara huamisi ahuomafori ashomisi. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nantianri isinin ipapacucahuanashu naani. Nacun rashucashon pushu fomancayan ratanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ascano Jesús tanamisifoan nicafo Pedro Lida chaimanoa. Nicacaquin yora rafu Pedroqui nichinifo yoinon, —Oinrisca huayonon, —Pedro huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nicatan atofu cani. Nococatan pushu fomancayan mapufainifo. Nanno ainfo funuomafo uainifo. —Oinpon. Nocon yora yamashtan nocon sahuutifo icushushomisi. Niyoshon noco shara huamisiran, —icashu uaiquin Pedro yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","—Chifi cainfaintacahuun, —Pedronun ato huani. Foainfono ratoconun mai chachipacufoantan Dios cufini. Ainfo yamashta oinquin yoini, —Tabitan, funinaca huahuun, —huaino. Fupuinacahuatan Pedro oinni. Ointan tsaoinacahuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ascaiton Pedronun mutsoinifoanni. Mutsoinifoantan Jesús tanamisifo yafi funuomafo cunani Tabita man funia ato oinmashquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Oincani nantifi yorafo Jope ano chanifoanfafainifo. Ascaiton nicacani yora ichapafoan nocon Ifo Jesús icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ascatan Pedro Jope pushurasi ano nituyoni. Nocofunun ahuun anu Simón nan fichi shinan huamisi ahuun pushu muran iyoni. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nantianri nocofunun ahuun anu Cornelio mai futsa Cesarea ano ini. Afin ranushumuafoan aton niaifo. Nan ranushumuafoan anumisi —Italianoran, —huamisifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A non ahuun yorafori Diosquiri shinansharamisifo. Nocofunu fasi shara. Ahuuomafo ato inanmisi. Dios cufifafainmisi. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ascan shafa futsan fari nai pochinin racano oshashoma namapan cuscara Diospan oinmati afu nai muran ica aqui oaiton oinni, —Cornelion, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Fasi ratucoinquin oinni, —¿Ahua min ua yoipaimun Ifon? —huaiton. —Diosin mia oian min shafatifi cufiainton min yora ahuuomafo pui inanmisi. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Ascan nocofunufo Jope ano nichihuun. Nanno nocofunu Simón ahuun anu futsa Pedro ihuinon. Nan fichi shinan huamisi ahuun anuri Simón ahuun pushu muran ica. Ahuun pushu unuhuan cusumunriran, —ishon Diosin nai oinmatinin yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yoitan amaquinoashu cani. Ascan Cornelio ahuun oinmati rafu non ranushumua ahuun cushumisi nanton Dios shinanmisi cunani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Diospan nai oinmatinin yoia cuscan nantifi ato tapimani. Tapimashon ato Jope ano nichini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ascan iyoconaino fari masafinin racano Jope chaimashta noconifo. Nantianri Pedron pushu manmancaya cashon Upa Dios cufi caicani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Fonaincaiton futsan pichashoni. Pichanqui anaitiataima Pedron oshashoma namapan cuscara ahuara futsa oinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nai fupuicano pano putanmanhuan cushtocoin nai murannoashu fotopacucahuani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A muran yoina futsa futsatapafo non ronofo non mai ano sharatirofo non puiyafori. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Oinquin ahuun oi nica isca huani, —Pedron, funihuu. Rutushon piishquin, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Ma, Ifon. Ascaracai un pimisima. Moisés noco yononi na cuscara non pitiroma. Suya chacaran, —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Afanan ahuun oi nica, —Diosin na cuscarafo imashara. Ascan afanan nan chacaran huayamahuu, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Rafu non fusti nanscaracoin oinni. Ahuun unutaqui afanan nan pano putanmanhuan nai muran cani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ascano Pedronun ahuun nomuran fasi shinanpaini, —¿Ahua ua Diosin yoipaimun? —ishon shinanni. Anori shinanquin nan nocofunufo Cornelio nichian Simón pushu caincaiti ano nococashon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","—¿Nocofunu Simón ahuun anu futsan Pedro nunomun? —ishon yocanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nantianri Pedro namapan cuscara shinainno Diospan Yoshinin yoini, —Nocofunu rafu non fustiton mia funai fuaforan. Un ato miqui nichian. Ascan shinanchacayamahuu. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fotopacucahuatan atofu catahuun, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ascaino Pedro atoqui fotoni. —¿Man ua funai fuamun? ¿Ahuuscaquimun man ua funaicai? —huaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Nocon niaifo ranushumuaton noco nichian non mia ihuunon. Nanton nocofunu shara. Diosquiri shinanfafaimisi. Cornelio nocofunu shararan min caifo Israelifoan huamisifo. Diospan oinmati sharapan afu nai muran icaton yonoa, “Pedro min pushu ano ihuitahuun mia yoisharanon,” ishon yoitan. Ascan “Ua ihuishotacahuun,” noco huaiton. Non mia ihui oaquin —huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nicaquin, —Iqui fucahuun. Non pinon. Nuno oshayoshcaquin, —ishon Pedro ato yoini. Iyoco futsaino atofu cani. Icoinra huafo Jope anoafori atofu fonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Focanashu iyocofutsaino Cesarea ano noconifo. Nannoshon Cornelio ato cunano ahuun yorafo ahuun pushu ano ichanannifo Pedro manacani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro pushu muran iquiano Cornelion fuopacucahuatan, —Min fasi shararan —ishon yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","—Funihuu. Uncai Diosimafinquin. Urifi un nocofunuquin. Min icai cuscarifiai un nocofunuquin, —huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A fu tsainquincai cunu futsan muran caashon yorafo ichanancashon manacaquin oinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ato yoini, —Man man tapian nocon shunifoan yonoa non Israelifoma fu rafutiroma. Non matofu oinmitsatiromaran, ishon noco yoini. Ascafiacun uhuun namapan cuscara Upa Diosin ua tapimaita un tsoahuunoa shinanchacatiroma. Atofin nantifi manifoannati noicoinquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Man ua iyopaiyainocai un cacasmama. Ascatamarocon un samamashta oa. Natian un tapipai ahuuscaquimain man ua ihuipaiaquin, —ishon Pedro yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelion cumani, —Osha rafu non rafuri finontan nantianri un Upa Dios cufiaino nocofunu ahuun sahuuti chashaino uqui niriscatana. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Cornelion, min cufiain cuscan Upa Dios nica. Min ahuuomafo inainton oian. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ascashon nocofunufo Jope ano nichihuun Simón miqui ihuunon. Ahuun anu futsa Pedro. Simón futsan nanton fichi shinan huamisi ahuun pushu muran ica. Ahuun pushu unuhuan cusumunri icaran” ishon ua yoita. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ascano un samamashta nocofunufo nichian mia ihuunonfo. ¡Aicho min noco shara huaa! Samamashta min nocoqui oa. Ascashon man non ichanan nocon Ifon minhuunshon noco yoipaiyai cuscan nantifi non nicanon, —ishon Cornelion yoiaiton. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ascaiton Pedronun nishon yoini, —Nantian mun tapia iconquin. Upa Diosin nantifi yorafo nan manifoti anoafo noicoian. Upa Diosincai toon huatan noima nanscasi huaquin noicoin. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Manifoti ahuun tsain nicapaicani shara huan tananmisifofin Upa Diosin ahuun facufo itirofoquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diospan Furun Jesucristo manifoti anoafoan aton Ifo. Ahuunshon Upa Diosin afanan noco onaintimaima. Man nicaino fasi unimacoincaquin. Nannori Upa Diosin uhuun caifo Israelifo tapimani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Judea mai anoa ica cuscan man man nicamisi Galilea ano ato yoiquin tauhuani. “Maton chaca shatucahuun Dios icoinra huacahuun un mato unu muran iquimanon,” ishon Juanpan ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ascan man man nicamisi Juan cachiori Jesús oni. Upa Diosin ahuun Furun Jesús ahuun Yoshin Shara nichian afu rafunon ahuunshon ahuamamishti yora atiroma cuscan anon. Ahuara sharafo huafoanfafaini. Upa Diosin afu imisi nantifi yora yoshin chaca ato yonoaiton atomaquinoa potani. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nantifi nan aca cuscan uhuun caifo Israelifo mai anoa yafi Jerusalén anori man non oinmisi. Ihui coyan iquinanqui mastayamuafo. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Asca huafiafo osha rafu non fustitan Upa Diosin mai murannoa funimaita noco oinmana. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Atirifoancai oinyamuama. Ratoranfo nan Upa Diosin catoanfoansi oinyamuafo. Mai murannoa funiano non a futan pifain ayayamua. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Manifoti anoafo uhuunoa ato yoitacahuun. Upa Diosin ua catonni nantifi yorafoti nan niafo nan naafori un ato yoitiro ratofomain un icano nipatiro iyamarai omitsiscapanaca muran focanicain. Ato yoifoanfafaincahuun,” Jesús noco huayamua. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Diosin tsain yoishomisifoan isca huani ahuunoa cununifo. “Tsoan a icoinra huacun ahuunshon Upa Diosin aton chaca soatiro rau huanon,” ishon cununifo. —Pedronun ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Yoiaifono nantifi ahuun tsain nicaimisifo Diosin ahuun Yoshin Sharapan ato muran nanucoinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Ascano anori tsain nicayamafiamisishacaquin Diosin Yoshin Sharahuunoashu tsain futsanman iqui futsunifo. Ascaifoan nicacani Israelifoan nan icoinra huafo nanno mustairinifo. —¡Aira! Nan yorafo nocon caifomafiashu Upa Diosin ahuun Yoshin Shara atoti nanumanaran, —ishon yoinifo. Ascano Pedron ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Non Diospan Yoshin Shara fia cuscan afoanrifi fiafo. ¿Ascan ahuuscaimun unu muran iquimamutiromaquin? —ishon Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ascano, —Jesucristo icoinra huafo ato unu muran iquimapacucahuun, —ato huani. Ascatan, —No fu iyopun, —Pedro huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ascano Jesús fu rafumisifo doce non icoinra huafo Judea anoafoanri nicanifo Israeli anoamafoanri Diospan tsain icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ascano Pedro Jerusalén ano noconi ahuun caifo nan Israelifoan aqui tsain curushu yoinifo, —Min mani futsa muran cashon aton pushu muran iquia ato futan min piaran, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ascan nantifi ahuara finoan cuscan ato shafacafi yoiquin isca huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Un Jope anoshon Dios cufiaino namapan cuscara un oian. Panomanhuan ronoashu nai murannoashu uqui fotoaiton un oian. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A muran yoina futsa futsatapafo non shafo cuscara mai ano sharatiofo non puiyafori mun oian. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Un oiainno un ahuun oi un nica ua yoia, “Funihuu. Rutushon piishquin,” ua huaa. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ma, Ifon. Uncai ahua chaca pitiroma. Moisés noco shunifo yononi cuscacai na cuscara non pitiroma. Ascan afocai un pimisima,” huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nai muranshon afanan ua yoia, “Nan Diosin shararan huaafin nan sharaquin. Acai sharamaran min huatiroma,” ua huaa. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nai murannoashu panomanhuan fotoi rafu non fustia. Ascatan afanan nai muran caa. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nantianri nocofunu rafu non fusti Cesarea anoashu pushu ano nocoafo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ascano Diospan Yoshin Sharapan, “Min caifoyamafiacun shinanchacayamahuu. Natian atofu catahuun,” ua huaa. No futan icoinra huafo seis ufu foafo. Non Cornelio pushu muran iquia. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Uhuun pushu muran Diospan oinmati afu nai muran ica uqui nocoita. ‘Min yorafo Jope ano nichihuun Simón ahuun anu futsan Pedro miqui ihuunon. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aafin mia tsain shara yoinon. Ahuun tsain nicaino min non min yorafori Dios fu nipatiroran,’ ishon ua huaitaran,” ishon Cornelio ua yoita. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Un ato yoiaino Diospan Yoshin Shara nocoqui nocoyamua cuscan atoquiri nocoa. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ascano nocon Ifo Jesús noco yoini cuscan un shinanpacutana, “Juanpan mato unu muran iquimapacuni maton chaca shatushon man oinmanon. Ascafia Upa Diosin ahuun Yoshin Shara matoqui nichishquin mato ya imapacunon,” ishon noco yoini cuscan uhuun nomuranshon un shinan. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Upa Diosin ahuun Yoshin Shara noco inanni cuscan atorifi inainta. Ascacuncain ahuuscaquin “Ato inainyamahuu” un Diosin huatiroma. Uncai anori yoitiroma, —ishon Pedron ato yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","A nicacashocai afanan tsoan —Min aca cuscan afanan huayamahuu, —huanifoma. Ascatamarocon, —¡Aicho Upa Dios shararan! Nocon caifomari ato shinan futsamana afu nipanonfo, —ishon yoinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ascano Esteban rutuaifotian ato omitsiscamaifoanno Jesús icoinra huaafo pashcafaifafainifo. Atirifi Fenicia ano foaino atirifi Chipre ano foaino atirifiri Antioquía ano fonifo. Nococashon aton caifo Israelifo fusti tsain shara Jesushuunoa yoifoanfafainifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ascafiacanashu atirifi Chipre yafi Cirene anoashu Antioquía ano fonifo. Tsain shara Jesucristohuunoa Israelifomari yoifocani. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Upa Diosin ahuun Yoshin Shara atofu ini. Aton tsainhuunshon Israelimafoan ichaparasiton nocon Ifo icoinra huanifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ascano Jesús icoinra huafo Jerusalén anoa nicacaquin Bernabé Antioquía anoshon nichinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nocoshon Diosin ato shara huaa cuscan atohuun ramapaiyaiton oinni. Oin ahuun nomuran fasi unimani. —¡Aicho! Natian man Jesús icoinra huaa. Ascan nocon Ifo tanasharacahuun. Maton nomuran ahua futsa shinanyamacahuun, —ato huani. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nan Bernabé nocofunu fasi shara. Diospan Yoshin Sharapan rafuquimisi. Fasi Jesús icoinra huani. Ascacufin ahuunshon yora ichapafoan nocon Ifo Jesús icoinra huanifoquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ascatan chipo Bernabé Antioquía anoashu Tarso ano cani Saulo funaicai. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aqui nocoshon Antioquía ano ihuuni. Ascano nanno fari fusti nan rafu Jesús icoinra huafo ichapa fu ichanannifo ato Diosin tsain tapimanifo. Antioquía ano Jesús tanamisifo ato anu futsaqui tau huanifo, —Cristoforan —ishon ato anunifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ascaino nantianri Diosin tsain inon pacoai cuscan yoimisifo Jerusalén anoashu Antioquía ano funifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ascan icoinra huafo ichanancanashu ato nicapai futsan ahuun anu Agabo Diospan Yoshin Sharahuunshon ato yoini isca huaquin, —Nantifi maitio Romanofoan ato yonoafo tushu cuyoiran, —ishon ato yoini. Icon nan Romano Claudio niaifotian tushu cuyocoinni. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nicacatan icoinra huafo Antioquía anoafoan pui ichanan huacashon icoinra huaafo Judea mai anoa yopaifoan fomanonfo. Nan inainton inannifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Asca huacatan Bernabé yafi Saulo inannifo Jerusalén ano fomanonfo. Nanno Jesús tanamisifo aton niaifofo inanno pashcananonfo. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ascatapaiyaino Herodes niaifoan atirifi Jesús icoinra huamisifo achimani cunu muran iquimashquin ato omitsiscamanon. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ascashon Juanpan iyoa Santiagori achimani nopun tushtunon. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tushtumana nicai Israelifo aqui unimanifo. Ascanori Israelifoan aton fuusititian ahuun anu misi farashati maisi pimisiforan huanifo nantianri Herodes yonocun Pedro achinifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Achimashon cunu muran iquimani. Ascashon ranushumua dieciseis cushuriapaonifo. Nantianri Israelifoan aton fuusititian Diosin nai oinmatinin aton shunifoan facu iyoafofosi finonmani shinanshcaquin. —Nan fuusititian cuyoano un Pedro cunu murannoa cainmayoshquin ahuun caifoan oinonfo. Ascano un yoishquin nanton chaca huaquin rutucahuun un ato huashquinran, —ishon Herodes shinanniquin. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ascano Pedro cunu muran iquimanaiton Jesús icoinra huafoan fasi Upa Dios cufishonifo. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes iyoco futsaino Pedro rutupai. Nan yamutan Pedro fasi osha murancoian ini. Cunopan munushushon ocuma rafutan ranushumu rafushon aton mucu rafuqui nushashon cushushinifo. Atiri ranushumuafo ahuun cunu caincaiti anoshon cushushinaifoanno. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ascantapaiyaino Diosin ahuun oinmati afu nai muran ica cunu muran niriscatani. Faquishfiashu punariscatani. Ascaino Pedro moinpaiquin pipasni, —Funiriscahuun, —huaino ahuun cuno mupucumuriscatani. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ascashon, —Min sahuuti yafi min sapato sahuufain min nanushumutinin nanushumuhuu ufu cashquin, —ishon Diosin oinmati afu nai muran icaton Pedro yoini. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ascaino cunu murannoashu afu caicainni. Caicainquin ahuun nomuran shinanni, —Uncai cacoinnima. Uhuun namapan raca un caicatin, —ishon shinanni. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ascanshu cunu rafu mapai cainni. Ranushumua cushuafo finonfaini. Ascatan ahuun cuno fupoti ano nococaquin oian man fupucua ini. Ascaino cainnacahuatan fai tanafainifo. Chaimashta afu catan Diosin oinmati afu nai muran ica amaqui yamariscatani. ");
INSERT INTO mcdNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ascaino Pedronun shinanni, —Iconfinquin. Uhuun Ifo Jesús ahuun oinmati nai muranshon u