﻿USE sofia;
DROP TABLE IF EXISTS sofia.mcbNT_vpl;
CREATE TABLE mcbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mcbNT_vpl WRITE;
INSERT INTO mcbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Maika nontsirinkakogetakero ivairopage pairaninirira yashikiiganakeririra Jesokirishito. Irirori inti iyashikiiganakerira Averan intiri Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Antari okyara yogari Averan itomintakari Isaako. Irirokya Isaako itomintakari Jakovo. Irirokya Jakovo itomintakari Jora intiegiri irirentiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Irirokya Jora itomintakari Parese intiri Sari. Ogari iriniro opaitaka Tamare. Impogini Parese itomintakari Eserome. Irirokya Eserome itomintakari Arame. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Irirokya Arame itomintakari Aminaravo. Irirokya Aminaravo itomintakari Naason. Irirokya Naason itomintakari Sarimon. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Irirokya Sarimon itomintakari Voose. Ogari iriniro opaitaka Iraava. Impogini Voose itomintakari Oveti. Ogari iriniro opaitaka Irote. Impogini Oveti itomintakari Isai. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Irirokya Isai itomintakari Iravi pegankicharira igoveenkariegite iseraereegi. Irirokya koveenkari Iravi itomintakari Saromon. Ogari iriniro Saromon onti yagavetarira Oriashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Impogini Saromon itomintakari Irovoame. Irirokya Irovoame itomintakari Aviashi. Irirokya Aviashi itomintakari Asa. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Irirokya Asa itomintakari Josapate. Irirokya Josapate itomintakari Jorame. Irirokya Jorame itomintakari Osuashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Irirokya Osuashi itomintakari Joatame. Irirokya Joatame itomintakari Akase. Irirokya Akase itomintakari Esekiashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Irirokya Esekiashi itomintakari Manaseshi. Irirokya Manaseshi itomintakari Amon. Irirokya Amon itomintakari Joseashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Irirokya Joseashi itomintaigakari Jekoniashi intiegiri irirentiegi impo yamaiganunkani maganiro iseraereegi Vavironiaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Impogini yogari Jekoniashi itomintakari Saratieri. Irirokya Saratieri itomintakari Sorovaveri. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Irirokya Sorovaveri itomintakari Aviote. Irirokya Aviote itomintakari Eriakime. Irirokya Eriakime itomintakari Asoro. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Irirokya Asoro itomintakari Saroko. Irirokya Saroko itomintakari Akimo. Irirokya Akimo itomintakari Eriote. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Irirokya Eriote itomintakari Ereasaro. Irirokya Ereasaro itomintakari Matan. Irirokya Matan itomintakari Jakovo. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Irirokya Jakovo itomintakari Jose. Ogari itsinanetsite Jose opaitaka Maria. Irorori onti iriniro Jeso ikantaganirira aikiro Kirishito. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Maganiro tsirinkakoigankicharira ivairopage aka ikaravageigake 14 itsititapanutara itimakera Averan ikaravagetake itimakera Iravi. Ario ikañoigaka aikiro maganiro tsirinkakoigankicharira ivairopage itsititapanutara itimakera Iravi ikaravagetake yamaiganunkanira Vavironiaku ikaravageigake 14. Impo ario ikañoigaka aikiro maganiro tsirinkakoigankicharira ivairopage itsititapanutara yamaiganunkanira Vavironiaku ikaravagetake itimakera Kirishito ikaravageigake 14. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maika nonkenkitsatakotakeri Jesokirishito tyara ikantaka ikyasanokyara ipokutira aka kipatsiku imechotakera. Pairani otimake tsinane opaitaka Maria. Inti kashigakaro surari ipaita Jose. Impo tekyara iragero itimake otyomiani, intitari timakagakeri Isure Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yogari Jose ikogavetaka irapakuanaeromera gara yagiro, intitari negintevagetacharira, kantankicha itsarogakagakaro nerotyo tera inkoge intsavetantakerora irogipashiventakerora, onti isurevetanaka irapakuanaeromera maireni gara ikanti tatoita yapakuavitanairo. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kantankicha iroro isurevetanakara inkañotakeromera maika ikoneatimotakeri isaankariite Tasorintsi igisanireku ikantiri: “Jose, virori vinti iyashikitanakerira Iravi. Maika onti nopokashitake nonkantakempira kametitake pagakerora Maria pamanakerora pivankoku. Yogari otomi intitari timakagakeri Isure Tasorintsi, irorotari itimantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Impogini omechotakerira pimpaitakeri Jeso, irirotari gavisaakoigakerine itovaireegi ganiri ikisaviigiri Tasorintsi ikañovageigara.” ");
INSERT INTO mcbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ario okañotaka maika kameti ontsatagakempaniri ikantakerira Atinkami Tasorintsi pairani iniakagakerira kamantantatsirira Isaiashi ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ogari terira ineimatero surari ankamonkitake intimake otomi. Irirori impaitakempa Imanoeri” (onkantakera: “Ikonoiigakai Tasorintsi”). ");
INSERT INTO mcbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Impo ikireanaira Jose ikematsatakeri isaankariite Tasorintsi ovashi iatake yagakitiro Maria yamanakerora ivankoku, ");
INSERT INTO mcbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kantankicha tera ineimatero kigonkero omechotakerira otomi. Antari imechotakera yogari Jose ipaitakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Antari imechotakera Jeso Verenku Joreaku aiño igoveenkariegite Joreakunirira paitacharira Erorishi. Impogini ipokaigake Jerosarenku pashini govageigatsirira iponiaigaka oatakara ikontetira poreatsiri. Iriroegi inti ipiriniventaigi impokiropage irogotantaigakemparira posante. Antari yogonkeigapaakara ");
INSERT INTO mcbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ikantaigapaakeri timaigatsirira kara: —¿Tyara inake kara igoveenkariegite jorioegi ikyaenkarira mechotankitsi?, noneaigakeritari impokiro ikontetapaakera yogaenokanakara nogotantaigakarira mechotake, nopokantaigakarira nonkamosoiguterira nontigeroaventaigakitemparira. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Irorompatyo ikemavakera koveenkari Erorishi ogatyo ikenake yovankinavagetanakatyo kara, ariotyo ikañoiganaka maganiro timaigatsirira Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Impogini irirori ikaemakagantaigakeri maganiro itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi ikogakotagantaigakeri tyara kara imechotakera Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iriroegi ikantaigiri: —Anta Verenku Joreaku, ariotari ikantakeri pairani kamantantatsirira itsirinkakotanakerora Veren ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Virori, Veren, nankitsirira Joraku, pairo pavisake inkemakoitakempira pavisakerora pashinipage apatogetara pankotsi itimantaigakarira tovaini Jorakunirira, imechotantakempitari Igoveenkariegite maganiro iseraereegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Impogini Erorishi maireni ikaemakagantaigakeri govageigatsirira teratyo tyani inkamante. Iroro yogonkeigapaakara ikantaigavakeri: —¿Tyati pineantaigakari ikontetapaakera impokiro? ");
INSERT INTO mcbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Impogini ikemakera ikamantaigakerira itigankaigakeri Verenku ikantaigavakeri: —Atsi piaige pinkogasanoigakiterira, impo pineaigakeririka pimpigaigae pinkamantaigakenara kameti noatakiteniri naro aikiro nontigeroaventakitemparira. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Iroro ikemaigakera ikantaigakerira iaiganake Verenku. Yogari impokiro ineaigakerira okyara anta itimaigira iivaiganakeri impo yaganakerora okatinkatakera pankotsi inantakarira Jeso ario ikusoenkatapaake kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Antari ineaigairira aikiro ogatyo ikenaigake ishinevageiganakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Impo yogonkeigapaakara pankotsiku ikiaiganake tsompogi ineaigapaakeri Jeso ontiri iriniro ovashi itigeroaventaigapaakari. Impo itsaakoigakero yamaigakeneririra ipaigakeri kori, kasankapaneri ontiri mira. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Impogini imagaigakera ikamantaigunkani igisanireku ganiri ipigaiganaa Erorishiku, nerotyo ikenapitsatantaiganaaririra parikoti iaigaira itimaigira. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Impogini iaigaira iriroegi yogari isaankariite Tasorintsi ikoneatimotairi Jose igisanireku ikantiri: “Tinaanake ganakero pitsinanetsite intiri otomi piate shiganake anta parikoti Ejipitoku, inkogakagantakeritari Erorishi irogakagantakerira. Pinkantakani pintimakera kara kigonkero nonkamantaempira kametitake pimpigaera.” ");
INSERT INTO mcbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Irorotyo ikemakera ikantakerira ogatyo ikenake itinaanaka yaganakero itsinanetsite intiri otomi ishiganinkaiganaka tsitenigetiku iaigakera Ejipitoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Itimuntevageigake anta asatyo ikamanaira Erorishi. Ario ikañoigaka maika kameti ontsatagakenkaniniri ikantakerira Tasorintsi pairani itsirinkakagakerira kamantantatsirira ikanti: “Itimavetaka Notomi Ejipitoku, impogini nokaemairi.” ");
INSERT INTO mcbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Impogini yogari Erorishi ineakera tera impigaigae govageigatsirira ikisamatanakatyo ovashi itigankaigakeri soraroegi irogaigakiterira maganiro ananekiegi timaigatsirira Verenku intiegiri aikiro timageigatsirira ochoenigetira impogereaigakerira maganiro ikyarira mechoigankitsi kigonkero inkaratagaigakeri shiriagakoigankicharira piteti. Irorotari ipampiatake ikantaigakeririra govageigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ario ikañotaka maika otsatagunkanira itsirinkakotanakerira pairani kamantantatsirira Jeremiashi ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Okemunkani anta Iramaku okaemavatunkanira, ontityo oyashikiiganakerira Irakere iragatsikanaiganakarira otomiegi teratyo onkaraigae. Tyampa onkantaigakenkani ogishineaigaenkanira, kamavioigaketari maganiro otomiegi.” ");
INSERT INTO mcbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Impogini ikamanakera Erorishi yogari isaankariite Tasorintsi ikoneatimotairi Jose igisanireku ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Maikari maika tinaanake ganaero pitsinanetsite intiri otomi piataera anta Iseraereku, kamaigaketari kogaigavetankicharira irogaigakerimera.” ");
INSERT INTO mcbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iroro ikemavakera ikaviritapanuta yaganairo itsinanetsite intiri otomi iataira Iseraereku, ");
INSERT INTO mcbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kantankicha antari ikemakotakerira Arekerao itomi Erorishi ipugairira iriri ipegakara koveenkari Joreaku ogatyo ikenake itsaroganake ovashi tera inkoge iriataera anta. Impogini ikamantunkani igisanireku ganiri iatai Joreaku, nerotyo iatantakarira Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yogonketapaakara anta itimapaake Nasareku. Ario okañotaka maika otsataganakara ikantaigakerira kamantantaigatsirira iniakoigakerira Jeso ikantaigakera onti inkantakenkani, “Inti Nasarekunirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aiñokyara itimaveta Jeso Nasareku iatake pashini matsigenka paitacharira Joan ikenkitsavagetanakera anta osarigagitetapaakera ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“¡Kantatigaiganakempa pampakuaiganakerora povetsikageigira terira onkametite, panikyatari aganakempa impegantakemparira Tasorintsi Igoveenkariegite maganiro kematsaigakerinerira!” ");
INSERT INTO mcbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yogari Joan irirotari ikamantakotakerira kamantantatsirira Isaiashi pairani ikantakera: “Iriatake pashini matsigenka anta osarigagitetapaakera inkenkitsatakera imaraenkarika kara inkante: ‘Pakuaiganakero povetsikageigira terira onkametite pinegintetashiigavakemparira Atinkamiegi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Irirori onti yogagutaka manchakintsi ovetsikantunkanirira iviti kameyo, aikiro isuntoratsatakari imeshina. Intagani yogaka tsinaro intiri pitsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Impogini iaigake inkamosoigakerira tovaini matsigenkaegi timaigatsirira Jerosarenku intiegiri pashiniegi Joreakunirira intiegiri aikiro choenitakoigakarorira nia paitacharira Jororan. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Antari ikemaigakerira ikenkitsavagetakera ovashi ikamantakoiganakero magatiro yovetsikageigirira terira onkametite impo yogiviaigakeri Jororanku. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kantankicha iatashiigakeri aikiro tovaini pariseoegi intiegiri saroseoegi ikantaigakerira irogiviaigakerira. Irirori ineaigavakerira ikantaigavakeri: “¡Viroegi kañoigakavi tsiroti! Ontitari pamatagaigaka tera arisano pinkematsatagantsiige. ¿Matsi tyanimpatyora kantaigakempira pimpokaigakera aka nogiviaigakempira ganiri ikisashiigimpi Tasorintsi impogini inkisashiigakemparira maganiro kañovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Atsi negintetasanoigempanityo kameti ineaigakempiniri maganiro arisano pikantatigaigaka papakuaigakerora povetsikageigira terira onkametite pikematsatasanoigakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Gara pikantaigi: ‘Gara ikisashiigana Tasorintsi, nantitari iyashikiegi Averan.’ Nonkamantasanoigakempi inkogakerika Tasorintsi iragaveaketyo inoshikagetakerora ogapage mapu impegakagagetakemparora iyashikiiganakerira Averan. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kantankicha maika panikya inkisashiigakempari Tasorintsi maganiro terira inkematsatasanoigeri inkañotagakemparora otogaganira inchato terira ontimumate okitsoki impo otagunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Narori onti nogiviaigakempi niaku oneakenkaniniri arisano pikantatigaigaka papakuaigakerora povetsikageigira terira onkametite, kantankicha panikya iripokake pashini tigankimoigakempineririra Isure Tasorintsi intimasurentagarantaigakempira, kantankicha pinkonogagarantaigakempa intigankagarantaigakempi morekariku. Irirori pairotyo yavisakena yagaveavagetakera. Narori garorokarityo nokañotumatari irirori, onti nagamaavagetakari, pairotari yavisavagetakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Antari iripokapaakera inkantapaake tyani kematsatasanoigakeri Tasorintsi, aikiro tyani terira inkematsaigeri. Yogari kematsatasanoigakeririra intentaiganakeri intimimoigakerira Tasorintsi. Yogari terira inkematsaigeri intigankaigakeri morekariku garira otsivakumati.” ");
INSERT INTO mcbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Impogini iponianaka Jeso Garireaku iatakera Jororanku ikantakerira Joan irogiviatakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kantankicha Joan ikantavakeri: —Narori garorokari nogiviatumatimpi narompatyo naro pogiviatake. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ikanti Jeso: —Ariotyo onkañotakempa maika kametitaketari antsatagaigakerora ikantakerira Tasorintsi. Impo ikantake Joan: —Je'ee. Ovashi yogiviatakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Impo irorotyo yaganairora Jeso otsapiaku ogatyo okenake ashirenakimatanakatyo inkite ineiri yapusatinkagutapaakari Isure Tasorintsi ikañotapaakari shiromega. ");
INSERT INTO mcbNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Impo inianake Tasorintsi enoku ikanti: “Yogari yoga inti Notomi, notasanovagetarityo kara noshineventakarityo.” ");
INSERT INTO mcbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iroro yagatakera iniakera Tasorintsi yogari Isure yamanakeri Jeso parikoti osarigagitetapaakera kameti ineasanotakerira kamagarini ariorika iragaveake irapakuakagakerira ganigera ikematsatairi Iriri. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ario inake kara 40 kutagiteri onti ipitashitakaro kogapage tera isekatumatempa niganki itaseganake. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Impo yaiñonitanakari kamagarini ikantakerira: —Irorotari vintira Itomi Tasorintsi atsi kanteronityo oga mapu ompeganakempara sekatsi pisekatakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kantankicha Jeso ikantiri: —Aityo otsirinkakotunkani Irinianeku Tasorintsi okanti: ‘Ogari sekatsi oshintsitagantavetaka kantankicha tera patiro onkogakotenkani irorori. Pairo avisake okogakotunkanira ogotasanotakenkanira magatiro ikantagetakerira Tasorintsi, irorotari shintsitagantatsi suretsiku.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Impo ariokya itentanakari Jerosarenku yaratinkaigapaakera ivankoku Tasorintsi otishitapankoku onavagetiratyo enoku kara ");
INSERT INTO mcbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ikantiri: —Irorotari vintira Itomi Tasorintsi atsi mitaanakenityo savi, okantaketari otsirinkakotunkanira okanti: ‘Intigankaigakeri Tasorintsi isaankariite irisentaigakempira. Iragaigavaempityo ganiri piparigi mapuseku.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iniitanaatyo Jeso ikantiri: —Kantankicha aityo pashini otsirinkakotunkani aikiro okanti: ‘Gara potsimajairi Pitinkami Tasorintsi pinkantanatakerira: Irorotari pagaveavagetira atsi nanityo maika neakagenaro pagaveane.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Impo ariokya itentanakari enoku ochovaankakera otishi yogikoneatimotutarityo magatirosanotyo kipatsi ontiri aikiro magatiropage timantagetakarorira. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Impo ikantiri: —Pintigeroaventakenarika maika pimpegakenara pitinkami, naro nompagetakempiro magatiro pineagetakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iniitanaatyo Jeso aikiro ikantiri: —Virori Satanashi, piataenityo parikoti, otsirinkakotunkanitari okanti: ‘Gara pipegumati pashini pitinkami. Panirosanotyo Tasorintsi pinkematsatasanotake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Impo ovashi iatai. Irirokya pokaigapaatsi isaankariite Tasorintsi yamaigakenerira iseka ishintsitagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Impogini yogari Jeso ikemakotakerira Joan yashitakotunkanira iatake Garireaku, ");
INSERT INTO mcbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","kantankicha tera intimae Nasareku, onti iatake itimakera Kaperenaoku. Ogari Kaperenao onti onake otsapiaku inkaare paitacharira Garirea ochoenitakotakarora kipatsipage itimantaigarira pairani iyashikiiganakerira Savoron intiri Nepetari. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ario ikañotaka maika kameti ontsataganakenkaniniri itsirinkakotanakerira kamantantatsirira Isaiashi pairani ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ogari kipatsi itimantaigarira iyashikiiganakerira Savoron intiri Nepetari, onti onake intati Jororanku okenantapinitaganira oatapinitaganira omaraaniku nia. Onti opaita aikiro Garirea; itimantaigaro tovaini terira iriroegi iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yogaegiri timaigatsirira kara yapavatsaakoigavetaka, kantankicha maika atake ikoneagitetakoiganake; panikya impogereaigakempa, kantankicha maika onti ipokashiigakeri Gavisaakotantatsirira irogavisaakoigakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Impo ikenkitsavagetanake Jeso ikanti: “Kantatigaiganakempa pampakuaiganakerora povetsikageigira terira onkametite, panikyatari aganakempa impegantakemparira Tasorintsi Igoveenkariegite maganiro kematsaigakerinerira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Impogini ikenanake Jeso kara ishitetanaka otsapiaku inkaare Garirea. Ineaigapaakeri Sumo intiri irirenti paitacharira Anturishi kitsavageigake, irorotari ipiriniventavageigi iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Impo ikantaigiri: —Maikari maika onti pipiriniventavageigi pikitsavageigira, kantankicha maika pakuaiganakero pikitsavageigira tsame pogiaiganakenara ariokya nagaveakagaigakempi irirokya pimpiriniventavageigae matsigenkaegi pinkematsatagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Impo iriroegi iokageigapanutiro igitsareegi yogiaiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iaigavetanaka antakona anta irirokya ineapaake Santiago intiri irirenti paitacharira Joan pirinitaigake pitotsiku shitikagisevageigake igitsareegi. Itentaigakari iriri paitacharira Severeo. Impo yogari Jeso ikantaigiri Santiago intiri Joan: —Tsame pogiaiganakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Iroro ikemaigavakerira ogatyo ikenaigake iokaiganakeri iriri pitotsiku yogiaiganakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Impogini iatanake Jeso itsotenkanakerotyo Garirea yogotagantavagetakera pankotsipageku yapatoitantaigarira jorioegi ikenkitsatimoigakerira ikantaigakerira tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi impegakempara Igoveenkariegite. Aikiro yovegagematityo tovaini oposantetashigeigakarira mantsigarintsipage, tenigetyo tyara inkatsitumageigae paa vegasanovageigaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Impo yogaegiri timageigatsirira parikotipageku Suriaku ikemakoiganakeri yovegantagetaira nerotyo yamageigapaakeneri maganiro mantsigaigankitsirira. Iriroegi iposanteivagetanakatyo kara ikonogaka yatsipereintevageigaketyo kara. Pashini onti ikamakamaigi, pashinikya ishinkogiseigaka, kantankicha irirori yovegageigairi maganiro. Aikiro yoneaganontaigakari itimaguigakerira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Impo yogiavageiganakerityo tovaini matsigenkaegi poniageigankicharira Garireaku, Tekaporishiku, Jerosarenku, Joreaku ontiri aikiro intati Jororanku, itovaigavagetiratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Impogini ineaigakerira Jeso maganiro patoventaigakaririra itovaigavagetityo kara itonkoanake otishiku ipirinitakera kara, impo yaiñoniigakari irogamereegi inkemisantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ovashi yogotagaigakeri ikantaigakerira: ");
INSERT INTO mcbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pairo okametitake pinkantaigakera: ‘Garika itsarogakagana Tasorintsi tyampa nonkantakempa, teranika tatakona nagaveimagete naro tsikyata.’ Antari pinkañoigakemparika maika ario pinkante pishinevageigakempa impegakempatari Tasorintsi Pigoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Pairotari irishinevageigakempa impogini maganiro onkenkisureakagaigakemparira maika tatapagerika oita terira onkametite, irogishineaigaeritari Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Pairotari irishinevageigakempa maganiro tsipereakoigankichanerira magatiro tatarikara oita pokashiigakerine, impoginitari ineaigakero magatiro ikashigakagaigakaririra Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pairotari irishinevageigakempa maganiro kogasanoigankitsinerira intsatagageigakerora magatiro ikogagetakerira Tasorintsi, iragaveakagaigakeritari irirori inkañoigakerora maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Pairotari irishinevageigakempa maganiro tsarogakagantaigankichanerira, intsarogakagaigakemparitari Tasorintsi iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Pairotari irishinevageigakempa maganiro suretasanoigakemparinerira Tasorintsi impanirotasanoiganakerira, impoginitari iriaigake itimira ineaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Pairotari irishinevageigakempa maganiro gametiaigaerinerira itovaireegi, impegakagaigakeritari Tasorintsi itomiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pairotari irishinevageigakempa maganiro iratsipereakagaigakenkanirira inkisaviigakenkanira ikematsaigakerira Tasorintsi itsatagageigakerora ikogagetakerira, matakatari pegaka Tasorintsi Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Maika atsi shinevageigempa viroegi pineaigakera irovosanteaigakempira pitovaireegi, inkisavintsavageigakempira, aikiro intsoeventavageigakempira ineaigakera pikematsaigakenara naro. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ariotari ikañoigunkaniri kamantantaigatsirira pairaninirira yatsipereakagaigunkanira ikisaigunkanira. Antari pineaigakera inkañoigakempira maika, pishinevageigakempatyo kara, pogoigaketari pairotyo irogishineavageigakempi Tasorintsi impogini anta enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Viroegi onti pikañoigakaro tivi. Pineirotari tivi opochatira pairo okogasanotagani, kantankicha antari omasankatera ganigera opochatai, ¿ario tatatyo onkogavitaenkani? ¿Matsi tyampatyo onkantaenkani kameti ompochatanaera? Ontityo ovuokakenkani parikoti okenapinitaganira agatitinatakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aikiro viroegi kañoigamatakavi tenenkakoigiririra maganiro matsigenkaegi. Pineirotari pankotsipage ovetsikagetunkanira otishiku apatotunkanira otovaigavagetityo kara, ¿matsi gara oneagani? Oneakenkanityo, koneataketari. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ario ikañotaka aikiro mechero yogimataganira tera ario intatakotenkani kovitiku, ontityo yovitakotunkani enoku kameti irontenenkakoigakeriniri maganiro naigankitsirira pankotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ario pinkañoigakempa viroegi pinegintevageigakempara povetsikaigakerora kametiripage kameti ineaigakempiniri maganiro, ovashi inkantaiganake pairo ikametiti Piri timatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gara pikantaigi: ‘Onti ipokashitake Jeso inkantakera ganigera otsatagaagani itsirinkakotanakerira Moiseshi ontiri aikiro itsirinkakoiganakerira kamantantaigatsirira’, teranika iroro nompokashite, ontityo nopokashitake nontsatagasanotakerora magatiro ikantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maika nonkamantasanoigakempi antari gatatara otsonkata inkite ontiri kipatsi ontsatagasanotakenkanityo magatiro ikantagetirira Tasorintsi itsirinkakagaigakeririra pairaninirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tyanirika gagakerone patiro ikantakerira, aikiro irogotagaigakeri pashini irimaigakempara iriroegi, garatyo ishineventumaigari maganiro pegaigakeririra Tasorintsi Igoveenkariegite. Kantankicha yogari tsatagasanotakeronerira, aikiro irogotagaigakeri pashini irimaigakempara irirori intsatagasanoigakerora, pairotyo irishineventavagetakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nonkantantaigakempirira maika garika pinegintetasanoiga pavisaigakerira gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi garatyo pitimimoigiri Tasorintsi impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Pogoigakerotari ikantaigunkanirira pairani yashikiiganakempirira ikantagani: ‘Gara poganti, inkisashitakenkanitari maganiro gantaigankitsinerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kantankicha naro nonkantaigakempi tyanirika kisakerine itovaire irimatakenkanityo irirori impogini inkisashitakenkanira. Aikiro tyanirika kantakerine: ‘Viro tera pogotumate’, iramanakenkanityo itinkamipageku inkisashitakenkanira, kantankicha yogari kantakerinerira: ‘¡Vinti ivegaga!’, intagakempatyo morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Irorotari nonkantantaigakempirira piaigakerika ivankoku Tasorintsi pamanakenerira pipira povetisakagantakenerira impo katsiketyo pisuretanakemparo pinkante: ‘Ariotari aityotari ikisavitakenarira notovaire’, gatatatyo povetisakagantiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Onti poganakeri pimpigapanaate pogametitapanuterira pitovaire. Impogini ario pinkante pimpigashitanaeri pipira povetisakagantakenerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Inkisakempirika pitovaire ineakera pipegakotakerira impo inkogavetakempa iramanakempira joeseku kameti inkantakera irirori tyara inkantaitakempi. Kantankicha viro pinianiatanakeri avotsiku pogishineaerira ganiri yamimpi. Antari iramanakempirika joeseku irirokya kaemakerine soraro, irirokya soraro onti iragapanutempi irashitakotakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nonkamantasanotakempityo garika pipunatasanotairi kisakempirira magatiro pipegakotakeririra garatyo yapakuaimpi shitakotakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Viroegi pogoigakerotari okantunkanirira pairani okantagani: ‘Gara piatashitiro tsinane.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kantankicha naro nonkantaigakempi tyanirika neavintsanatakerone tsinane kañomataka ontinirikatyo iatashitakero, isuretakarotari ineakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Irorotari nonkantantaigakempirira maika irorora kañovagetagakempine poki pakosanorirakutirira ariometyo pinkitsogitakerome, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aikiro pakosanorira irorora kañovagetagakempine ariometyo povatuakerome, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aikiro okantunkani pairani: ‘Tyanirika kogankitsine iokanaerora itsinanetsite kantetyo impakerora sankevanti onkantakera: Maika mataka nokanaimpi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kantankicha naro nonkantaigakempi ompanirotakempirika pitsinanetsite garatyo piokiro. Pokanakerorika impo agaerika pashini pimatakero pikañovagetagakaro, agaitari pashini. Ario pinkañotakempa viro pagakerika tsinane okunkanirira matakavi kañovagetakavi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Aikiro pogoigakerotari ikantaigunkanirira pairani yashikiiganakempirira ikantagani: ‘Tatarika pinkantake piniakotakeririka Tasorintsi pinkantakera: Ineakena Tasorintsi tera nontsoegumatempa, garatyo pikantatigumatiro impogini, ontityo pintsatagakero.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kantankicha naro nonkantaigakempi omirinkara pintsatagageigakero magatiro pikantaigakerira ganiri pikogakotumaiga pinkantaigera: ‘Ineakenatari Tasorintsi tera nontsoegumatempa.’ Gara piniakoigiro inkite pinkantaigakera: ‘Nontsoegakemparika kantakarikatyo opitankirika inkite’, intitari shintaro Tasorintsi Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ario okañotaka kipatsi irorori gara piniakoigiro pinkantaigakera: ‘Nontsoegakemparika kantakarikatyo onigirika kipatsi’, ontitari yashintagitearira, aikiro gara piniakotumaigiro Jerosaren pinkantaigakera: ‘Nontsoegakemparika asatyo ompegakempa Jerosaren’, intitari shintaro Koveenkari Gaveavagetatsirira terira intimumate viserinerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aikiro gara piniakoigiro pigishi pinkantaigakera: ‘Nontsoegakemparika ogatyo nonkenake nonkutyapaetanake’, teranika pagaveaige viroegi pinkutatagaigakerora ontirika pimpotsitatagaigakerora papeatiro pigishi. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gara tatoita piniakotumaigi, intagatityo pinkantaigake: ‘Jeeje, arisano’, ontirika pinkantaigake: ‘Teratyo.’ Antari ontirika piniakogeigake tatarika oita kameti inkematsaigakempiniri pashini, intityo suretagaigakempine kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Viroegi pogoigakerotari okantunkanirira pairani: ‘Tyanirika tisoreaatantakerone okitsi ariotyo inkañotagakenkani irirori intisoreaatakenkanityo iroki. Aikiro tyanirika tinkaraitantakerone aitsi, ariotyo inkañotagakenkani irirori intinkaraitakenkanityo irai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kantankicha naro nonkantaigakempi gara pipugaigari kisaigakempinerira. Kañotari intimera taakempinerira pivoroku garatyo pipugatari. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ontirika intimake kogankitsinerira iramanakempira joeseku iragutakempirora pogagutakarira savitankitsirira gara pitsaneanakaro pimanchaki enokutankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ario onkañotakempa aikiro ariorika intimake ganakempinerira iromperatakempira inkantakempira pogavokitakiterira choenikona anta, piatetyo pavisanakerotyo ikantakempirira pogavagetakiterityo antakona anta. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pintsarogakagakemparira nevitakempinerira tatarikara oita, pimpakerityo ikogakotakarira, aikiro tyanirika kogankitsine pampinatakerira tatarikara oita gara pitsaneapitsatari. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Pogoigakerotari okantunkanirira pairani: ‘Pintakemparira piamigote pinkavintsaakerira. Irirokya kisakempirira pimpugatanakemparityo pinkisakerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kantankicha naro nonkantaigakempi pinkavintsajaigakerityo iriroegi kisashiigakempirira, aikiro piniaventaigakerira maganiro tsipereakagaigimpirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pintsatagaigakerorika magatiro nokantaigakempirira maika onti pinkañoiganakempari Piri timatsirira enoku. Kañotari irirori iporeakagirira poreatsiri kameti imporeakoigakeriniri maganiro matsigenkaegi, irirorika kametiigatsirira intirika terira inkametiige. Ario okañotaka inkani irorori yogivariginirira maganiro kematsaigiririra intiegiri terira inkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nonkantaigakempi antari intaganirika pinkavintsajaigake kavintsajaigimpirira, ¿matsi tatatyo irishineviigakempi Tasorintsi? Ariotari ikañoigari maika kogantaigaririra itovaireegi koriki irashi koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ario okañotaka aikiro intaganirika piniaigavake pitovaireegi, ¿matsi ario pineaigake pairo pavisaigake pikematsaigakerira Tasorintsi? Ariotari ikañoigari maika yogaegi terira inkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Irorotari nonkantantaigakempirira maika pinkavintsaantavageigakera pinkañoigakemparira Piri timatsirira enoku ikavintsaantavagetira. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Gara intagati pikavintsaantaigi pineakagaigakemparira pitovaireegi. Pinkañoigakemparika maika garatyo ishineventaigimpi Piri timatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pintsarogakagaigakemparirika terira irashintumaigempa pimpaigakerira ikogakoigakarira gara pikamantaigiri pitovaireegi ganiri pikañoigari kematsatamampegaigacharira kogapage. Iriroegi ontitari ineakagantaigaka pankotsipageku yapatoitantaigarira ontiri aikiro kara avotsipageku kameti irishineventaigakempariniri itovaireegi, kantankicha maika nonkantaigakempi gatanika ishineventumaigari Tasorintsi kañoigirorira maika, intaganityo shineventaigakari itovaireegi neaigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Antari pipaigirira tyanirika kogakovageigankicharira garatyo tyani pikamantumati, ");
INSERT INTO mcbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","impogini yogari Piri neagetakerorira magatiro irishineventakempi ovashi inkavintsaakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Antari piniaigerira Tasorintsi gara pikañoigari kematsatamampegaigacharira kogapage iniamampegaigarira. Iriroegi ontitari ikogavintsaigi iraratinkaigakera pankotsipageku apatoitantaganirira ontiri aikiro avotsiku iniamampegaigakarira kameti ineaigakeriniri itovaireegi. Yogaegiri kañoigacharira maika garatyo ishineventumaigari Tasorintsi. Intagani shineventaigakari maganiro neaigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kantankicha viro pinierira Tasorintsi piatake pinkianake pivankoku pashitakotakempa paniro, impo piniakeri. Irirori ineakempi panirora papuntaka piniakerira inkemavakempi irishineventakempi ovashi irogishineakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nerotyo pinierira Tasorintsi gara piniavageti kogapage vero vero vero ganiri pikañoigari terira inkematsaigeri Tasorintsi. Onti ineaigiri ariori inkemaigakeri iniavageigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nonkantutaigaempityo aikiro garatyo pikañoigari iriroegi, yogotitari Tasorintsi tatarika pikogakoigaka tekyaenkara pineviigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Antari piniaigerira onti pinkañoigakero maika pinkantaigakerira: ‘Apa Tasorintsi timatsirira enoku, nokogaigake impinkatsatasanoigakempira maganiro matsigenkaegi ");
INSERT INTO mcbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","inkematsatasanoigakempira impegaigakempira Igoveenkariegite. Nokogaigake ontsatagakenkanira aka kipatsiku magatiro pikogakerira viro onkañotakempara otsatagaganira kara enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pimpaigakenara omirinka nogaigakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimagisantaerora novetsikaigakerira terira onkametite gara pikenkiagaiganaro. Ariotari nokañoigakari naroegi nomagisantaigakero yovetsikaigakerira tsipereakagaigakenarira tera nonkenkiagaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pimpampogiakoigakenara ganiri opokashigeigana garira noshintsitashigeigiro. Onti nokogaigake pishintsitagaigakenara ganiri yagaveaigaana kamagarini inkañovagetagaigaenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pimagisantaigaerorika yovetsikaigakerira tsipereakagaigakempirira ario inkañotakempa Piri timatsirira enoku imagisantaero magatiro povetsikaigakerira viroegi terira onkametite gara ikenkiagaimpiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kantankicha garika pimagisantaigiro yovetsikaigakerira tsipereakagaigakempirira garatyo imagisantairo Piri povetsikaigakerira viroegi terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ariorika pinkogaigake pimpitashiigakemparora kogapage gara pisekataiga kameti pimpiriniventaigakeroniri pisuretakoigakemparira Tasorintsi gara pikenkisureamampegaiga kogapage, garira onti pinkañoigakempari kematsatamampegaigacharira. Iriroegi ontitari ikenkisureamampegaiganaka kogapage kameti ineaigakenkaniniri. Kantankicha yogaegiri kañoigacharira maika garatyo ishineventumaigari Tasorintsi, intaganityo shineventaigakari maganiro neaigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kantankicha viroegi pimpitashiigemparora kogapage pinkishiigakempatyo, aikiro pinkivaiigakempa ");
INSERT INTO mcbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ganiri yogoigimpi pitovaireegi onti pipitashiigakarora kogapage. Intagani neaigakempine Piri Tasorintsi impo irirori irishineventaigakempi ovashi pineakoigakemparo impaigakempirora onkatinkageigakempirira impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gara onti pishineventavageiga pashintavageigakempara aka kipatsiku, onkonogagarantakempatari irogagetakemparo gagetarorira, pashinikya onkiterigetanake, pashinikya onkoshigetakenkani, ontsonkagetakenkani magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Onti pishineventavageigakempa magatiro ikogagetakerira Tasorintsi kameti inkavintsaavageigakempiniri irogishineaigakempira impogini anta enoku. Antari anta gara tatoita tsonkatumagetaacha. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Antari irororika pishineventavagetakempa timagetatsirira aka kipatsiku irorotyo pimpiriniventavagetake, intagatitari pisuretakotakempa. Antari irororika pishineventavagetakempa ikogagetirira Tasorintsi ario pinkante irorotyo pimpiriniventavagetake, irorotari pisuretakotakempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yogari suretakotasanovagetakemparonerira Iriniane Tasorintsi irogotasanotakero magatiro ikogagetirira irirori, onti inkañotakempari neatsirira tyarika iati ineasanotanake tera irontivatumatempa, okoneagitetimotakeritari magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kantankicha yogari terira isuretakotasanotemparo Iriniane Tasorintsi tera irogotero ikogagetirira, onti ikañotakari terira inee, tyampa inkantakempa iranuivagetakera, onti yontivativavagetaka, teranika onkoneagitetimoteri, onti ineakero pavatsaasemataka. Garika pisureigaro Iriniane Tasorintsi, intagatirika pisuretakovageigakempa timagetatsirira aka kipatsiku onti pamatavinaigaka tsikyata viroegi, kañoigamatakavi terira ineaigumate, ontitari apavatsaasetimoigakari. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Gara tyani gaveatsi intimakera piteni shintaririra inkematsatasanoigakerira piteniro. Panirotyo irishineventakempa inkematsatasanotakerira, yogari irapitene gara ikematsatiri, gatanika ishineventari. Ario ikañotaka tyanirika kogankitsine irashintaarantavagetakempara garatyo ikogumati inkematsatasanotakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nonkantantaigakempirira gara povankinaventaigaro pisekaegi pinkantaigakera: ‘Maikaniroro kamani ¿tatarikatyo nogaempa?’ Aikiro gara povankinaventaigaro pogaguigakemparira pinkantaigakera: ‘¿Tyarikatyo nagakero nogagutaemparira?’ Kañotari pisure paniantaigarira yagaveaketyo Tasorintsi itimakagakerora irorompari piseka pairo impaigakempiro. Ario okañotaka pogaguigakemparira, kañotari yagaveakera Tasorintsi itimakagakerora pivatsa irorompari pogaguigakemparira pairo impaigakempiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pineaigiritari aragetatsirira teratyo impankivageigavetempa, aikiro teratyo ontimavetempa irogantaigakemparorira iseka iriatapiniigakera iragapiniigakera isekataigakempara, kantankicha Piri timatsirira enoku ipaigirityo irogaigakemparira. ¡Viroegimparorokari pairo impaigakempi pisekaegi pogaigakemparira, pairotari pavisaigakeri aragetatsirira! ");
INSERT INTO mcbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Antari povankinaventaigemparora pinkimoiganakera ¿matsi ario pagaveaigake pinkimoiganakera? Garatyo pagaveimaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","“Iroroventi ¿tyara okantakara povankinaventaigakarora pogaguigakemparira? Pineaigironirorotyo oka otegapage tsikyata oshivokashiigaro irorori tera antumaigavetempa, aikiro tera onkirikaigavetempa akyari okametivageigi avisavagetaketyo kara okametitakera, avisagetakerotyo kamisa kametimagorisanorira pairanitirira yogagutarira koveenkari Saromon pairorira avisake okametimagotakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kañotari oka otegapage porenkamaivagetake ikametitagagetirora Tasorintsi, kantankicha kamani ovatuakenkani ontagakenkanira, ¡viroegimparorokari pairo impaigakempi pogaguigakemparira! Kantankicha viroegi tera pinkematsatasanoigeri onti povankinaventaiga posantepage. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nonkantantaigakempirira gara povankinavageiga pinkantaigakera: ‘¿Tatarika nogaempa? ¿Tatarika noviikaempa? ¿Tyarikatyo nagakero nogagutaemparira?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Intitari kañoigiro maika yogaegi terira inkematsaige yovankinaventaigarora posantepage, irorotari ipiriniventaigi iriroegi. Kantankicha viroegi gara pikañoigiro maika, aiñotari Piri timatsirira enoku. Irirori yogotake omirinka tatarika oita pikogakoigaka. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Irorompatyo pinkogasanoigake pimpiriniventaigakerora magatiro ikogagetirira Tasorintsi pintsatagaigakerora, impo irirori impaigakempiro magatiro pikogakogeigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gara povankinaventaigaro pinkantaigakera: ‘¿Tyarikatyo nonkantanakempa kamani?’ Omirinkatari kutagiteri aityo posantepage tsipereakagaigakempirira pisuretakoigakemparira. Onkutagitevetanaempa pashinikyatyo timaatsine osuretakotaenkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gara piniashinaigari pitovaireegi kogapage pinkantaigakera yovetsikaigake terira onkametite ganiri ikisashiigimpi Tasorintsi impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pinkantantavageigakerika kogapage pantsipereakagantaigakera ariotyo inkañotagaigakempi viroegi impogini inkisaigakempityo iratsipereakagaigakempira irirori. Tyarika pinkantaigakeri pashini ariotyo inkañotagaigakempi Tasorintsi irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tyara pikantakara pikanomajaigirira vetsikaigirorira terira onkametite? ¿Matsi tera pineero pashi virompatyo viro pairo pogagaka? ");
INSERT INTO mcbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kañomatakatyo ontinirika pikantanakeri pitovaire: ‘Atsi taina nogotagakempira ganigeniri pikañovagetaa’, tenirikatyo pineemparo viro tyarikaroro apatoventavagetakempityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ontityo pineakagantavintsatakara! Atsi negintetasanovagetempanityo viro kameti pagaveakeniri pinkanomaantakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gara pikenkitsatimoigiri Iriniane Tasorintsi samatsanaigirorira garira onti inkisaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Neviigeri Tasorintsi tatarika pikogakogeigaka impo irirori impaigakempirotyo. Pinkogasanoigakerorika pineakoigakemparotyo. Atanatsirika pinevinatakeri Tasorintsi inkemaigakempityo impaigakempirora. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yogari nevitantatsirira ipunkani. Yogari kogankitsirira ineakero. Aikiro yogari tyanirika atanatsirira inevitantira ikemunkani ipunkanityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Matsi pinkañoigera viroegi inevitempira pitomi pan pinoshike mapu pimperi? ");
INSERT INTO mcbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Intirika inevitakempi shima, ¿pinoshike pimperi maranke? ");
INSERT INTO mcbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kañotari viroegi pikañovageigavetari akyari pipaigiri pitomiegi tatarika oita kametiripage ineviigakempirira, ¡iriromparorokarityo Piri timatsirira enoku pairorokari impaigakempiro tatarika oita kametiripage pineviigakeririra! ");
INSERT INTO mcbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Irorotari nonkantantaigakempirira pikogaigakerika inegintevageitakempira iroroventi pinegintetantavageigaketyo viroegi aikiro. Ariotari okantiri itsirinkakotanakerira Moiseshi ontiri aikiro itsirinkakoiganakerira kamantantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pinkiantaiganakemparora sotsimoro maaniñakitirira, aityotari pashini sotsimoro omaranakini ontiri aikiro avotsi ariopokirikatyo onake atatsirira savi morekariku. Onti okenantavintsatantaganirira iatantaigaro tovaini matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kantankicha ogari apipokitene avotsi maanisano ochapavokivagetaka onti oavokitake enoku Tasorintsiku. Gara ineaigairo igamane maganiro kenantanakemparonerira. Ario okañotaka sotsimoro irorori maaniñakitisano okañovagetaka. Tesakona intovaige neaigakeronerira inkiantaiganakemparora ganiri ineaigairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tsikyanira yamataviigimpikari kenkitsatakotamampegaigaririra Tasorintsi inkañoigavetapaakempari ovisha terira tyara inkantantavagete, kantankicha onti ikañoigakari matsontsori pogereantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Viroegi onti pineantaigavakempari irororika yogotagantaigake Niagantsisanorira ontirika yogagaigakero iramatavinaigakempira. Pineaigironiroro ova tera oneenkani ontimantemparora kivitsa. Ario okañotaka igo tera oneenkani ontimantemparora tanko. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ario okañotaka inchatopage. Magatiro timatsirira oi ogaganirira gara agaveimati ontimera oi terira ogenkani. Intagatityo timankitsine oi ogaganirira. Ario okañotaka aikiro inchatopage timatsirira oi terira ogenkani gara agaveimati ontimera oi ogaganirira. Intagatityo timankitsine terira ogenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ogari timatsirira oi terira ogenkani onti otogagani impo otagunkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ario ikañoigaka matagavageigacharira iroro pineantaigavakempari tera inegintevageigempa, aikiro tera katinka irogaigero yogotagantaigira. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Antari impogini irapatoitaigakerira Apa maganiro kematsaigiririra impegakempara Igoveenkariegite, gara itimimoigiri yogaegi maganiro kantaigavetakenanerira: ‘Notinkami, Notinkami.’ Intaganityo timimoigakerine vetsikaigakeronerira ikogagetakerira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Antari aganakempara kutagiteri nonkisantaigakemparirira maganiro terira inkematsaigena tovainityo kantaiganakenane: ‘Notinkami, Notinkami, nokenkitsatakoigakempi, aikiro naventashiigakari pivairo noneaganontaigakarira itimaguigakerira kamagarini, aikiro novetsikaigakera terira oneimagetenkani nokantaigake vinti gaveakagakena.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kantankicha naro nonkantaigerityo: ‘Teratyo naro shintaigempine. ¡Piaigetyo parikoti maganiro viroegi vetsikagisevageigirorira terira onkametite!’ ");
INSERT INTO mcbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Maika nonkantaigakempi tyanirika kematsatakenane irovetsikagetakerora nokantagetakerira onti inkañotakempari govagetatsirira yovetsikakerora ivanko ikigantashitakero yogavagetakerotyo savi kameti onkusotasanotakeniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Impogini oparigavetanaka inkani okimoatanake nia, otampiavagetanaketyo jiriririri, kantankicha teratyo agaveero ontuanakerora, okusotasanotaketari. ");
INSERT INTO mcbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yogari kemisantavetakenarira kantankicha tera irovetsikero nokantakeririra onti ikañotakari terira irogote yovetsikakerora ivanko tera irogasanotero savi ");
INSERT INTO mcbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","impo opariganake inkani okimoatanake nia, otampiavagetanaketyo jiriririri ogatyo okenake otuanakero okantavageti togn, teranika onkusotasanote.” ");
INSERT INTO mcbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Impo yagatanaira Jeso ikenkitsavagetakera yogavageiganaketyo kavako maganiro kemisantaigakeririra, ");
INSERT INTO mcbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ineaigaketari yogotagaigakerira yogovagetiratyo kara, tera ario inkañoigempari gotagantaigirorira itsirinkakotanakerira Moiseshi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Impogini yanonkaara Jeso ipokaira, yogiaigapaakeri tovaini matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ikenapaake paniro vesegasenari itigeroaventapaakari ikantiri: —Notinkamii, nokogavetaka povegaenara, kantankicha impatyora viro tyarika pinkante. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yogari Jeso yakontsaanake itsagatakeri ikantiri: —Jeeje, nokogake, ¡maika veganaempa! Irorotyo ikantakerira ogatyo ikenake yoveganaa yovesegavetakara. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Impo ikantavakeri Jeso: —Gara tyani pikamantumati. Inti piatimotake saserorote pokotagakemparira ontiri aikiro pamagetanakenerira piratsipage pintsatagakerora ikantakerira Moiseshi kameti ineasanotakempiniri ovashi inkantakempi vegaavi irogoigakempiniri maganiro vegasanotaavi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Impogini iatanake Jeso Kaperenaoku. Iroro yogonketapaakara ineiri ikenapaake paniro iromano. Irirori inti itinkamiegi soraroegi. Impo ikantapaakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Notinkami, imantsigavagetanake nomperane aiño inoriaka anta novankoku. Ishinkogisevagetanaka yatsipereavagetaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ikantiri Jeso: —Iroroventi noatake novegaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Inianake itinkamiegi soraroegi ikanti: —Notinkami, garorokari pikiimatiro novanko, nogotaketari vinti gaveavagetatsirira. Piniimatakera intagatityo irovegantanaempa nomperane. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kañotari naro itimavetari peraiganarira, akyari itimi nashi nomperaneegi. Tyarikara nonintake nontigankakerira ikematsatakenatyo iatake. Pashinikya nokaemirira ipokake. Aikiro aiño pashini tatarika nomperatakari ikematsatakenatyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iroro ikemavakerira Jeso ikantakera maika yoganaketyo kavako ikantaigiri giaigapaakeririra: —Arisanotyo nonkantasanoigakempi teratyo noneimageteri paniro Iseraerekunirira inkañotakemparira yoka iromano yogotasanotakera nagaveavagetira. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite iripokaigake pashini tovaini terira iriroegi jorioegi imponiageigamatempatyo samani parikotipageku. Imponiageigamatempatyo oatakara ikontetira poreatsiri, pashini imponiageigamatempatyo iatira poreatsiri intentaigakemparira Averan, Isaako intiri Jakovo isekataigakempara, ");
INSERT INTO mcbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kantankicha yogaegiri jorioegi ikogavetakarira Tasorintsi intentaigakemparimera garatyo itentaigari, onti intigankaigakeri parikoti apavatsaasevagetara. Antari anta inkantakani iriraguntevageigakempa inkaemavavageigaketyo kara iratsikagisevageiganakerotyo irai. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Impo ishonkashitari itinkamiegi soraroegi ikantiri: —Maika piatae pivankoku, pogotaketari nagaveakera novegaerira pomperane, maika irovegaempatyo. Iroro iniakera Jeso ogatyo ikenake yoveganaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Impogini iatake Jeso ivankoku Perero ineapaakero yagashintotirira mantsigatake noriaka oanativagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Itsagatapaakero akoku ogatyo okenake opeganaka oanatire ovashi otinaanaa opakoigakeri isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Impogini ochapinitanakera yamaigapaakeneri Jeso tovaini itimaguigakerira kamagarini. Irorotyo iniakera Jeso oga ikenaigake kamagarinipage iokaiganairi itimaguigavetakarira iaigaira parikoti. Aikiro yamaigapaakeneri tovaini mantsigaigankitsirira, yovegageigairi maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ariotari ikantakeri pairani kamantantatsirira Isaiashi ikamantakotakerira ikantakera: “Yatsipereaventaigakaira akañovageigara, aikiro yovegaigakaira amantsigaigakera.” ");
INSERT INTO mcbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Antari ineaigakerira Jeso yapatoventaiganakarira tovaini matsigenkaegi ikantaigiri irogamereegi: —Tsame amonteaiganakera intati. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Impo ikenapaake gotagantirorira itsirinkakotanakerira Moiseshi ikantiri Jeso: —Gotagantatsirira, nokogake nonkantakanira nogiavagetakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ikanti Jeso: —Yogari etini aityo ikiantarira. Ario ikañoigaka tsimeripage irirori aityo imagantaigarira, kantankicha yogari Kañotasanotakaririra Matsigenka teratyo ontime ivanko irimagantakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Impogini inianake paniro irogamere ikanti: —Notinkami, nokogavetaka nogiatanakempimera, kantankicha aiñokyatari apa gatata nopoki. Antari inkamanaera nonkitatanaerira, ario pinkante nompokake nonkantakanira nogiavagetanakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ikanti Jeso: —Giavagetenatyo maika. Yogari igamagapage kantetyo inkitaigaerira terira inkematsaigeri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Impo yomatetanaka Jeso pitotsiku itentaiganaari irogamereegi iriaigaera intati. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Osamanitanakera otampiamatanaketyo omaranerikatyo tampia kara jiriririri ogatyo okenake ovoresekantanake inkaare osagusagutanakerotyo pitotsi. Yogari Jeso magasevagetake. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Itsarogaiganake irogamereegi yogireaigutarityo ikantaigiri: —¡Notinkamii, tainakario atake atsitigakoiganake! ");
INSERT INTO mcbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Irirori ikantaigiri: —¿Antari gara pitsarogaigi? ¡Tekya pogotasanoigero yagaveavagetira Tasorintsi! Itinaamatanakatyo inianakerora tampia ikantiro: —¡Peganaempa, intaga pitampiati! Iniiro aikiro inkaare ikantiro: —¡Maireatanae! Ogatyo okenake opeganaa tampia, ario okañotaka inkaare irorori omaireatanai. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iriroegi yogavageiganaketyo kavako ikantaiganakera: —¿Tyanimpatyora yoga, nerotyo okematsagematanakerira tampia irorori ontiri inkaare? ");
INSERT INTO mcbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Antari yogonketapaakara Jeso intati Gararaku ikenaigapaake piteni matsigenka itimaguigakerira kamagarini. Iriroegi onti iponiaigapaaka imperitanakiku yogantaganirira igamaga. Isurarivageigiratyo kara ipinkasanovageigunkani, teratyo tyani kenantumatemparone avotsi atacharira inaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Impo ineaigavakerira Jeso ikaemavaitanake ikantaigiri: —¡Eeee! ¡Jeso, Itomi Tasorintsi, arionena gara tyara pikantaigana! ¿Iroro pipokashitake pantsipereakagaigakenara maika tekyaenkara agumatempa nantsipereantaigakemparira? ");
INSERT INTO mcbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ario inaigake kara shintori isekatavageigakara itovaigavagetiratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Impogini yogari kamagarini timaguigakeririra inianiaiganakeri Jeso ikantaigiri: —Poneagaigakenarika onti pintigankaigakena nontimaguigakerira shintori. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ikanti Jeso: —Nanityo piaige. Igenanekyatyo ikonteigapanuti iokaiganairi itimaguigavetakarira irirokya iatashiigavetaka shintori. Iroro itimaguigavetapaakarira ogatyo ikenaigake ishigaiganaka otseraaku yanonkaiganaka iokaavioigaka pokorom pokorom pokorom, ipogereaigakatyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Iroro ineaigavakerira sentaigiririra itsarogavageiganaketyo kara ishigaiganaka iaigai itimaigira ikamantageigapaakeri itovaireegi iokajaigakara shintori. Aikiro ikamantaigapaakeri tyara ikantaiganaka itimaguigavetakarira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ikemaigutatyo iriroegi iaigake anta inakera Jeso ikantaigapaakeri: —Nokogaigavetaka piataera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Impogini yomatetanaa Jeso pitotsiku imonteanaa iataira itimira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Impo ipokaigapaake pashini matsigenkaegi ikompitakoigapaakeri paniro shinkogisenari yamaiganakenerira irovegaerira. Antari ineaigakerira Jeso arisano opaitaka yogoigakera iragaveakera irovegaerira ikantantakaririra shinkogisenari: —Notomi, shinetanakempa. Maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ario inaigake kara gotagantaigirorira itsirinkakotanakerira Moiseshi. Ikemaigavakerira ikantakera maika, iniasurentavageiganaka ikantaigi: “Antari gara ikañota maika, onti ikañotagumanatanakari Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kantankicha Jeso yogoigavakerityo iniasurentaigakara ikantaigutarityo: —¿Tyara pikantaigakara piniasurentaigakara pikañoigakerora maika? ");
INSERT INTO mcbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tyatimpatyo pairo avisake okomutakara? ¿Irororika nonkantakerira: ‘Maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi’, ontirika nonkantakerira: ‘Tinaanake nuitanake’? ");
INSERT INTO mcbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Maika noneakagaigakempi yagaveake Kañotasanotakaririra Matsigenka imagisantakoigaerira matsigenkaegi magatiro terira onkametite yovetsikageigirira. Impo ovashi ishonkatetanakari shinkogisenari ikantiri: —Tinaanake, ganaero pinoriantakarira, piatae pivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ogatyo ikenake itinaanaka iatai ivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Antari ineaigavairira maganiro patoitaigankicharira itsarogavageiganaketyo ovashi ishineventaiganakari Tasorintsi ineaigakera onti yagaveakagaigakeri matsigenkaegi irovetsikaigakera posante terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Impogini iatake Jeso ikenanakera kara ineapaakeri paniro surari ipaita Mateo. Irirori onti ipirinitake anta pankotsiku itimashiigavakerira visapiniigatsirira ikogantaigavakarira koriki maganiro maiganankitsirira iarakipage ontirika tatapagerika oita, intitari kogantiniririra koveenkari koriki. Impo yogari Jeso ikantapaakeri: —Tsame, pogiatanakenara. Irirori ikaviritapanuta iatanake yogiatanakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Impogini Jeso iatake ivankoku isekatavagetakara itentaigakari irogamereegi intiegiri aikiro pashini kogantaigaririra itovaireegi koriki irashi koveenkari intiegiri aikiro pashini kañovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yogari pariseoegi ineaigakerira Jeso itentaigakarira isekataigakara ikantaigiri irogamereegi: —¿Tyara ikantakara yoga gotagaigimpirira isekatakovageigakarira kogantaiginiririra koveenkari koriki intiegiri aikiro pashini kañovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Antari ikemavakera Jeso ikantaigiri: —Yogari terira imantsigaige tera inkogakoigempari gavintantatsirira. Intagani kogakoigari mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Piaigae pisuretakoigakemparora pogoigakeroniri ikantakerira Tasorintsi ikantakera: ‘Pairo avisake nokogakera pintsarogakagantaigakempara, avisakero povetisaigakenarira piratsipage pintagaigakenarira.’ Teranika iriro nompokashiige terira inkañovageigempa nonkantaigakerira inkantatigaiganakempara, intityo nopokashiigake kañovageigacharira kameti inkantatigaiganakempara irapakuaiganakerora yovetsikageigakera terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Impo ipokaigapaake irogamereegi Joan Giviatantatsirira ikantaigapaakeri Jeso: —Naroegi intiegiri pariseoegi napakuapiniigi tera nosekataigempa, kantankicha yogari pogamereegi tera ario inkañoigempa maika. ¿Tyara ikantaigakara? ");
INSERT INTO mcbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Impo irirori ikantaigiri: —Pine intimera pashini ikyarira gankitsi itsinanetsite inkaemaigakeri iamigoegite isekatagaigakemparira, ¿matsi gara isekataiga? Isekataigakempaniroro, itentaigakaritari kaemaigakeririra ishinevageigaka. Kantankicha antari aganakempara inkisakenkanira iramanakenkanira parikoti ario pinkante impitashiigakemparotyo kogapage gara isekataigaa, inkenkisureakoiganakemparitari. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tera onkametite pinkematsatagarantaigerora yogotagaigakempirira pariseoegi irorokya pimaigavake nogotagaigakempirira naro. Ontinirikatyo okañotakaro onkotatenkanira kamisa ogantagarira onkotatantakenkanira okyamagokyarira. Onkivavetanakempa oga onkenake ontsiomagotanakempa ariompa ontisaraanakerori. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aikiro ontinirikatyo okañotakaro ompiaatenkanira vino okyaakyarira tekyarira ompoite ompiaatantenkanira kaverameshina igantagarira atakerira yaratsimeshinatanake. Ompoivetanakempa aravonkanake oga onkenake ontimpoanakeri imeshina ovashi ontisaraanakeri osanakempa vino, aikiro iraparatakempa imeshina irisaraanakera. Nerotyo pairo okametitake ompiaatantenkanira ikyameshinakyarira kameti ganiri aparaata vino, aikiro ganiri yaparata imeshina.” ");
INSERT INTO mcbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aiñokyara iniavageti Jeso ikenapaake paniro itinkamiegi jorioegi ipaita Jairo itigeroaventapaakari ikantiri: —Okyaenka kamanankitsi noshinto. Tsame pimpatikaituterora ogitoku anianaeniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Impo ikaviritanaka Jeso yogiatanakeri ivankoku itentaiganaari irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ario onake aikiro kara paniro tsinane mantsigavagetankitsirira oseriintevagetanityo pairani ogatyo onakotanake 12 shiriagarini tera ogote ovegaempara, teranika onkaraagaenika oriraa. Irorori aiñonitanakari okenashitapaakeri itishitaku otsagatakotapaakeri okaratsaiku imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Oniasurentavagetakatari inkaara okanti: “Intagatityo nontsagavetakemparo imanchaki noveganaempatyo.” ");
INSERT INTO mcbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Impo ishonkanaka Jeso ineiro aratinkake ikantiro: —Noshinto, shinetanakempa. Maika pogotaketari nagaveakera novegaempira, nerotyo povegantaarira. Ovashi ovegasanovagetanaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Impo iroro yogonketapaakara ivankoku Jairo ineaigapaakeri kovuvageigatsirira kovuigamatake. Yogari iragatsikaigaririra igamaga iragaigamataka kaemavaimataketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ikantaigapaakeri: —Atsi mereaiganake konteiganake. Tera ario onkame, onti omagake. Ogatyo ikenaigake ikavakavaimatanaketyo ikaavintsanaiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iroro yogikonteigakerira ikianake tsompogi ikatsavakotapaakero. Ogatyo okenake otinaanaa okaviritanaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Impo ovashi maganiro timageigatsirira kara parikotipageku ikemakoigakeri yoganiairora irishinto Jairo. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Impogini iatanaira Jeso yogiaiganakeri piteni terira ineaige ikaemakonaigavakeri ikantaigiri: —¡Viro, Iyashikitanakerira Iravi, tsarogakagavageigenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Impo yogonketapaakara Jeso pankotsiku ikiapaake tsompogi. Yogaegiri terira ineaige giaigapaakeririra yaiñoniigapaakari. Inianake Jeso ikantaigiri: —¿Tyara pinkantaige viroegi? ¿Nagaveake noneakagaigakempira? Iniaiganake iriroegi ikantaigiri: —Jeeje, Notinkami, pagaveakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Impo itsagaigakeri irokiku ikantaigiri: —Iroroventi pogoigaketari nagaveakera noneakagaigakempira, maika neaigakevi. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ogatyo ikenaigake ineaiganake. Impo Jeso ikantaviigavakeri ikantaigiri: —Arisanora tsikyanira pikamantantaigirokari. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kantankicha teratyo inkematsaigeri. Irorotyo iaigaira ikamantantageiganakero tyara ikantaigakeri Jeso ineakagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Choeni osamanitanake ikenaigapaake pashini yamaigapaakeneri terira irinie, itimagutakeritari kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Irorotyo yoneaganontaarira Jeso ogatyo ikenake inianai. Yogavageiganaketyo kavako maganiro ikantaiganakera: —¡Teratyo oneimagetenkani kañopagerira oka! ");
INSERT INTO mcbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kantankicha yogaegiri pariseoegi ikantaiganaketyo: —Irirori arisano yagavei yoneagagetarira kamagarinipage timagugeigakeririra matsigenka, intitari gaveakagakeri itinkami kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Impogini iatake Jeso ikenanake kara itsotenkanakero apatogetakara pankotsipage yogotagantagematanake pankotsipageku yapatoitantaigarira jorioegi ikamantaigakerira maganiro tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi impegakempara Igoveenkariegite. Aikiro yovegagematityo tovaini oposantetashigeigakarira mantsigarintsipage, tenigetyo tyara inkatsitumageigae paa vegasanovageigaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Antari ineaigakerira maganiro yapatoventaigapaakarira itsarogakagaiganakarityo kara ineaigakeritari yatsipereavageigakera posantepage ikenkisureavageigakara, onti ikañoigakari ovisha terira intime sentiririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Impogini ikantaigiri irogamereegi: —Nonkantasanoigakempi aiño tovaini kogakoigankicharira irogoigakera tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi impegakempara Igoveenkariegite, kantankicha tesakona intovaige gotagaigakerineririra. Onti ikañoigakaro osampatira turigoki ogatuitakoni tesakonara intovaige gaigakeronerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Irorotari maika nonkantaigakempi piniaigakerira Tasorintsi pinkantaigakerira intigankaigakera gotagaigakerineririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Impo iroro yagatanakera Jeso iniavagetakera ikaemaigakeri irogamereegi naigatsirira 12 ovashi yagaveakagaigakeri ironeaganontaigakemparira itimaguigakerira kamagarinipage, aikiro irovegageigakerira oposantetashigeigakarira mantsigarintsipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iriroegi onti ikantaigunkani aikiro iritigankaneegi. Onti ipaiigaka: Sumo, ikantaganirira aikiro Perero; Anturishi, irirenti Perero; Santiago intiri Joan, itomiegi Severeo; ");
INSERT INTO mcbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jeripe, Varitorome, Tomashi, Mateo, kogantiniririra koveenkari koriki; Santiago, itomi Arejeo; Tareo, ");
INSERT INTO mcbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sumo komperagetatsirira, intiri Jorashi Ishikariote, gakagantakeririra Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Impogini itigankaigakeri ikamantaigavakeri ikanti: “Gara piatimoigiri terira iriroegi jorioegi pogotagaigakerira. Yogaegiri Samariakunirira garatyo pikamosotumaigiri anta itimageigira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Intagani piatimoigake maganiro iseraereegi, ontitari ikañoigakari ovisha timpinaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Maika piaige pinkenkitsatimoigakerira pinkantaigakerira panikya aganakempa impegantakemparira Tasorintsi Igoveenkariegite maganiro kematsaigakerinerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Povegaigaerira vesegasenari intiegiri aikiro pashini mantsigaigankitsirira. Poganiaigaerira kamaigankitsirira, aikiro poneaganontaigakemparira itimaguigakerira kamagarinipage, kantankicha garatyo pikogantaigari. Kañotari naro teratyo nonkogantaigempi nagaveakagaigakempira, ario pinkañoigake viroegi garatyo pikogantaigari yogaegi tyanirika povegaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Gara pamumaigi koriki. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gara pamaigi pitsagine. Intagatityo pamaiganake pamagotiro pimanchaki pogaguigakarira, aikiro pisapatote pisapatoigakarira. Gara pamaigi pigotikiiro. Maganirotari piriniventavageigirorira ikogagetirira Tasorintsi kametitaketyo impaigakenkanira iseka. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tyarika kara pogonkeigapaakempa aiñorika negintevageigacharira, iriro pimagimoiganake kigonkero piaiganaera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Piaigakerika ivankoku pinkiaigapaakera piniaigapaakerira pinkantaigeri: ‘Nokogake inkavintsajaigakempira Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Irishineventaigavakempirika inkemisantaigakempira pinkenkitsatimoigakerira irirokya shineventaigakemparine Tasorintsi inkavintsajaigakerira. Antari garikara ishineventaigavakempi garatyo ishineventaigari Tasorintsi inkavintsajaigakerira, panirotyo inkavintsajaigakempira viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Antari tyarika piaigake kara garikara ishineigavakempi piaigake parikoti, kantankicha oketyo pimpotevonkititasanoiganaemparo kipatsipane pagatikakoigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maika nonkamantasanoigakempi impogini aganakempara inkisashitantakempara Tasorintsi pairotyo inkisashiigakempari yogaegi terira irishineigavakempi avisagetakerotyo inkisashiigaemparira timaigavetankicharira pairani Soromaku ontiri Gomoraku. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Atsi gaige kavako! Naro nontigankaigakempi itimaigira kisantaigatsirira iratsipereakagaigavakempityo kara kañomataka intinirikatyo notigankake ovisha iriatakera yapatotara garirira ovisha. Onti pinkañoigakempari maranke yogovagetira, kantankicha gara pagashitantavageiga, aikiro gara pipugatsatantavageiga onti pinkañoigakempari shiromega. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tsikyanira ikisaigimpikari iramaiganakempira pitinkamiegiku inkisakagantaigakempira impasapasatagantaigakempira pankotsipageku yapatoitantaigarira pitovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gara intagati oka. Iramaiganakempityo aikiro koveenkaripageku inkisakagantaigakempira ovashi pimaiganakeri iriroegi pinkenkitsatimoiganakerira intiegiri aikiro maganiro terira iriroegi jorioegi pinkamantakoigakenara naro. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Antari iramaiganakempira koveenkaripageku gara pisureigaro tyarika pinkantaige. Gara pikantaigi: ‘¿Tyarika nonkantaigeri?’, isuretagaigakempitari Tasorintsi kameti pogoigakeniri tyara pinkantaige. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gatanika tsikyata piniaigi viroegi, intitari suretagaigakempine Isure Tasorintsi timasurentaigakempinerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Intimaiganake tovaini matsigenkaegi imparantaiganakempari irirentiegi irogakagantaigakerira, pashinikya gakagantaigakerine itomiegi. Ario inkañoigake pashini imparantaiganakempari iriri irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Maganirosanotyo inkisaviiganakempiro pikematsaigakenara, kantankicha yogari tyanirika tsipereakotanankichanerira garira yapakuimati ikematsatakenara ovashi inkamanake iriro pinkante irogavisaakotakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tyarika kara iratsipereakagaitakempira, piaigakera pishigaiganakera parikoti. Arisanotyo nonkantasanoigakempi tekyara pintsotenkaigero magatiro itimaigira iseraereegi pinkenkitsatimoigakerira, impigaate Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Yogari yogotagaganirira teratyo iravisumateri gotagiririra. Ario ikañotaka yonampitaganirira teratyo iravisumateri nampitaririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aikiro yogari yogotagaganirira ariotyo inkañotakempari gotagiririra. Ario ikañotaka yonampitaganirira ariotyo inkañotakempari nampitaririra. Kañotari naro Pitinkami akyari ikantaitana Veresevo viromparorokari pairo irogagaitakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Irorotari nonkantantaigakempirira gara tyani pipinkumaigi, magatirotari terira ogotenkani maika impoginityo ogotakenkani. Ario okañotaka magatiro omanagetunkanirira maika impoginityo ogikoneatakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Narori maireni nogotagaigakempi, kantankicha viroegikya gitivarokaigakerone pinkamantaigakerira maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gara pipinkaigiri gaveaigankitsinerira irogamagaigakempira. Iriroegi irogamagaigakempirika intagatitari kamankitsine pivatsa, kantankicha garatyo yagaveimaigi irogamagaigakerora pisure. Inti pimpinkaigake Tasorintsi, panirotari ikantara irirori yagaveira inkantakera tyani kamankitsine impo iragaveake intigankakerora isure morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Matsi tera pineaigeri tsimeripage intagatira ipunata piteni tsimeri pamentyakiniro koriki?, kantankicha teratyo inkamumate paniro terira iriro kogatsine Piri. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kañotari pigishiegi akyari yogotiro papeapagetiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Irorotari nonkantantaigakempirira gara pitsarogaigi, pairotari pavisavageigakeri tsimeripage. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Maika nonkantaigakempi tyanirika kantasanotankitsine ikematsatasanotakenara inkamantaigakerira itovaireegi, ariotyo nonkañotakempa naro impogini nonkantaketyo: ‘Nanti shintari’, inkemakenara Apa timatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kantankicha tyanirika kantankitsine: ‘Tera nonkematsateri Jeso, inkante’, ariotyo nonkañotakempa naro impogini nonkantaketyo: ‘Tera naro shintemparine’, inkemakenara Apa timatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Viroegi pineaigiri irorori nopokashitake irishinevakagaigakempara maganiro, kantankicha teratyo iroro nompokashite, ontityo nopokashitake onkenantanakemparora inkisavakagaiganakempara, ");
INSERT INTO mcbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘intimaketari surari inkisanakeri iriri. Ario onkañotanakempa tsinane onkisanakero iniro, aikiro gatomintantatsirira onkisanakero ovagirote. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yogaegiri garira ikematsaigana inkisashivageiganakemparitari iitaneegi kematsaigakenanerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nonkantaigakempi garatyo nopegumatiri nogamere tyanirika pairorira itasanotakari iriri ontirika iriniro, narokya ogakona intakena. Aikiro garatyo nopegumatiri nogamere tyanirika pairorira itasanotakari itomi ontirika irishinto, narokya ogakona intakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ario nonkañotakempa aikiro garatyo nopegumatiri nogamere tyanirika terira inkoge impiriniventavagetanakerora nokogagetirira naro iratsipereaventavagetakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tyanirika tsarogakagacha ikiiro tera inkoge iratsipereaventavagetakenara ikiirotyo kañotagantanankicha, intagatitari ikogake irovetsikagetakera tatarika ikogagetakerira irirori. Kantankicha yogari piriniventirorira nokogagetirira naro yatsipereaventakenara, iriro pinkante iriatake itimira Tasorintsi inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tyanirika gaigavakempine inkematsaigavakempira nanti ikematsatake, ario ikañotaka tyanirika kematsatakenane naro, inti ikematsatake aikiro tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tyanirika gavakerine kenkitsatakotiririra Tasorintsi inkematsatavakerira ineakera inti tigankakeri Tasorintsi, irirori irishineventakempari impo ovashi ineakotakemparo impakeririra impogini inkañotagakemparira impakerira yoga kenkitsatakotiririra. Ario inkañotagakenkani tyanirika gavakerine negintevagetacharira ineakerira inegintevagetakara, irishineventakempari Tasorintsi inkañotagakemparira yoga negintevagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ario inkañotakempa aikiro tyanirika kavintsaakerine irapigematsatene terira impaitumatempa ineakerira ikematsatakenara, irishineventakempari Tasorintsi impo ovashi ineakotakemparo impakerira onkatinkatakeririra impogini. Intagatityo impavetakempari imire irorotakenityo.” ");
INSERT INTO mcbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Impogini yagatanakera Jeso yogotagaigakerira irogamereegi iatanake parikotipage apatogetakara pankotsipage ikenkitsavagetakera, aikiro yogotagantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yogari Joan Giviatantatsirira aiñokya yashitakotaka. Impo ikemakotavakerira ikenkitsavagetakera, aikiro yovegageigakerira tovaini mantsigaigankitsirira, itigankaigake piteni irogamereegi inkogakotagantaigakiterira. Antari yogonkeigapaakara inakera ");
INSERT INTO mcbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ikantaigapaakeri: —¿Virorika nogiaigakerira ontirika atanatsi nogiaigera pashini iripokakera? ");
INSERT INTO mcbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yogari Jeso ikantaigiri: —Maika piaigae pinkamantaigapaakerira Joan magatiro pineageigutirira ontiri pikemageigutirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yogari terira ineaigavetempa ineaiganake. Yogari terira iranuitagantsiigavetempa yanuitagantsiiganake. Ario ikañoigaka vesegaigavetankicharira yovegaiganaa. Yogari terira inkemaigavetempa ikemaiganake. Aikiro yogari igamagapage yaniaiganai. Intiegiri aikiro terira irashintavageigempa ikenkitsatimoigunkani ikamantaigunkani tyara inkantaigakempa kameti irogavisaakoigakenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Irishinevagetakempa tyanirika kantakanirira inkematsatasanotakenara gara yapakuimatana! ");
INSERT INTO mcbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Impo iaiganaira iriroegi iniavagetanake Jeso iniakotakerira Joan ikantaigiri maganiro: “¿Tatoita piatashiigakiti anta osarigagitetapaakera? ¿Iriro piatashiigakiti pineaigakitirira matsigenka terira ishintsitashigetero magatiro matavitantagantsi, irorokya ikanti irorokya ikanti? ¿Ario ikañotakaro savoroshi amirora tampia akya otuiti akya otuiti? ");
INSERT INTO mcbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ario tatatyo piatashiigakiti? ¿Iriro piatashiigakiti pineaigakitirira matsigenka gagutacharira mechomagori kamisa? Pogoigaketari maganiro gaguigacharira mechomagori kamisa onti ipirinitaigi ivankoku koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Iroroventi ¿tatatyo piatashiigakitira? ¿Iriro piatashiigakiti pineaigakitirira kamantantatsirira? Jeeje, irironiroro, kantankicha pairo yavisavagetakeri kamantantatsirira, ");
INSERT INTO mcbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","irirotari itsirinkakotunkanirira pairani iniakerira Tasorintsi Itomi ikantiri: ‘Notomi, impogini nontigankake paniro ivatanakempinerira inkantaigakerira itovaireegi inegintetashiigavakempira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Maika nonkantaigakempi maganirosanotyo matsigenkaegi tera intimumate paniro visakerinerira Joan, kantankicha tyanirika yogavisaakotake Tasorintsi ipegakara Igoveenkarite, irirori pinkante yavisakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Pairani ikyasanokyara tsititanakero Joan ikenkitsavagetanakera ovashi maika yogari kisantaigatsirira tera inkogaigavetempa inkenkitsatakotakenkanira Tasorintsi tyara ikanta yogavisaakotantira ipegakara Igoveenkariegite maganiro kematsaigiririra, kantankicha ariompatyo ishineventasanoiganakarori tovaini matsigenkaegi ikematsaiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maganirotari kamantantaigatsirira ikamantakoigakero pairani ovashi ikenkitsatanakera Joan. Ario ikañotaka Moiseshi irirori itsirinkakotakero. Maganiro ikantaigaketari iripokake intigankakerira Tasorintsi irogavisaakotantakera ovashi impegakempa Igoveenkariegite maganiro kematsaigakerinerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yogari Joan irirotari kamantantatsirira Eriashi pikemakoigakerira iripokakera iivatakerira intigankakerira Tasorintsi. Pinkogaigakerika viroegi pinkematsaigakenara kematsaigenatyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Tatarikatyo nonkañotagaigakempi viroegi? ¿Tata pikañoigaka? Inti pikañoigaka ananekiegi impitaigera pampatuiku imagempivageigakera impo ovashi inkisavakagaiganakempa inkantaige: ");
INSERT INTO mcbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nokovutimoigavetakempi teratyo pintiontaigempa. Impo nomatikimoigavetakempi matikagantsi kenkisureaenkatavagetakatyo kara teratyo piragaigempa.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ariotari pikañoigakari viroegi. Ipokavetaka Joan tera isekatavagetempa, aikiro tera iroviikumatemparo poiri, onti pikantaigakeri itimagutakeri kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Impo maika ipokavetaka Kañotasanotakaririra Matsigenka isekata, aikiro yoviika ariokya pikantaigakeri: ‘Pairo isekaata aikiro pairo ishinkiseta, aikiro inti itsipaiga kañovageigacharira intiegiri kogantaiginiririra koveenkari koriki.’ Kantankicha ogotunkani tyani kematsatasanotiri Tasorintsi aikiro tyani terira inkematsateri, ontitari oneantunkani yovetsikagetakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Impogini Jeso ikanomajaigutarityo yovetsikimogeigakerira tovai terira oneimagetenkani, ineaigakeritari tera inkantatigaigempa inkematsaigakerira Tasorintsi, ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Maikaniroro pantsipereavageigake viroegi timantaigarorira Korasun! ¡Maikaniroro pantsipereavageigake viroegi timantaigarorira Vetsaira! Pineaigavetakarotyo novetsikimoigavetakempirira, kantankicha teratyo pinkogaige pinkantatigaiganakempara pampakuaiganakerora povetsikageigira terira onkametite. Yogari pinkante timaigavetacharira pairani Tiroku ontiri Suronku iriroegimetyo neaigakerome inkantatigaiganakempametyo irogaguiganakemparome tontaporokiri, aikiro intiaitaiganakempametyo samampopane iokotagantaigakempara ikenkisureaigakara ineaigakera yovetsikageigira terira onkametite inkantatigaiganakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kantankicha viroegi aganakempara inkisashitantakemparirira Tasorintsi maganiro terira inkematsaigeri, pairotyo irogagaigakempi kara avisavagetakerotyo inkisashiigakemparira Tirokunirira intiegiri Suronkunirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Viroegiri timaigatsirira Kaperenaoku paventakovageigaka. ¿Pineaigiri ariori piaigake enoku? ¡Garatyo! Ontityo piaigake morekariku. Ariome ovetsikakenkanime terira oneimagetenkani pairani anta Soromaku onkañotakemparora novetsikimogeigakempirira viroegi maika gamerorokari ipogereaiga maganiro, aiñokyametyo intimantaigemparo maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Irorotari nonkantantaigakempirira impogini aganakempara inkisashitantakempara Tasorintsi, pairotyo inkisashitasanoigakempi viroegi avisakero inkisashiigaemparira Soromakunirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Impogini Jeso inianakeri Tasorintsi ikanti: “Apa, vinti vetsikagetakerorira inkite ontiri kipatsi ontiri aikiro magatiro timantagetarorira. Noshineventakempityo kara, pomanapitsaigakeritari govageigatsirira tera pogotagaigeri tyara pikanta viro. Inti pogotagaigake terira irogovageige. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Arioniroro okañotaka maika, ariotari pikogakeri viro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Impo ikantaigiri maganiro: “Ipagetakenaro Apa magatiro, aikiro yagaveakagavagetakena posante. Tera tyani gotatsine tyara nokanta. Intagani gotankitsi Apa. Aikiro tera tyani gotatsine tyara ikanta irirori. Intagani naro gotankitsi intiegiri aikiro yogaegi nonkogakagaigakerira nogotagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maganiro viroegi tsipereaigankitsirira pipomirintsiigakarora pintsatagageigakerora magatiro ikogagetirira Tasorintsi, atsi tainaegi naroku paventaigakenara nampishigopireakagaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pinkematsaigakenara kameti nogotagaigakempira ovashi pampishigopireaigakempa pisureku, teranika naro kisantatsirira, aikiro nantitari tsipereakovagetacharira tera naventakotumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tera onkomutempa pintsatagaigakerora magatiro nogotagaigakempirira, nantitari shintsitagaigakempine nogishineasanoigakempira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Impogini aganakara kutagiteri apishigopireantaganirira iatake Jeso ikenanake turigoshiku itentaiganaari irogamereegi. Iriroegi itasegageiganake yagaigamatanaketyo turigoki yogaigakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Irorotyo ineaigakerira pariseoegi ikantaigutarityo Jeso: —¡Atsi gaigeri kavako pogamereegi! Yagaiganake turigoki maika kutagiteriku apishigopireantaganirira, okantavitantaganitari antavagetantenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kantankicha irirori ikantaigiri: —¿Matsi tera piniavantumaigero viroegi otsirinkakotunkanira yovetsikakerira Iravi pairani? Itaseganake irirori intiegiri itentaigakarira, mamerisanotyo tatampatyo irogaigakempa, ");
INSERT INTO mcbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","impo ikiamatanaketyo ivankoku Tasorintsi yogakarora pan okantavitantaganirira ogenkanira, ontitari irashi Tasorintsi. Intagani gaigaro saseroroteegi, ariotari ikantiri Tasorintsi, kantankicha yogari Iravi yogakarotyo, aikiro ipaigakeri itentaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Matsi tera piniavantumaigero aikiro itsirinkakotanakerira Moiseshi okantira yogari saseroroteegi tavageigatsirira ivankoku Tasorintsi yantavagetantaigakaro kutagiteri apishigopireantaganirira kantankicha teratyo iroro irovetsikaige terira onkametite? ");
INSERT INTO mcbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Maikari maika aikiro nonkamantaigakempi aiño aka pairorira yavisavagetakero ivanko Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Viroegi tera pinkemaigavakeronika Itsirinkakagantakerira Tasorintsi kantatsirira: ‘Pairo avisake nokogakera pintsarogakagantaigakempara, avisakero povetisaigakenarira piratsipage pintagaigakenarira.’ Pinkemaigavakeromera oka gamerorokari pineantavageigi yovetsikaigakera terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yogari Kañotasanotakaririra Matsigenka irirotari kantatsirira tyati okantavitantagani antantenkanira kutagiteriku apishigopireantaganirira, aikiro tyati terira onkantavitantenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Osamanitanakera iatake Jeso pankotsiku yapatoitantaigarira jorioegi ikianake tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ario inake kara paniro shinkovakotankicharira. Yogaegiri kisaigakeririra Jeso ikantaigiri: —¿Kametitake irovegantakenkanira mantsigatankitsirira kutagiteriku apishigopireantaganirira? ");
INSERT INTO mcbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ontityo ikantaigakeri maika ineaigakera tyarika inkante kameti intsavetantaigakerira inkisakagantaigakerira. Kantankicha irirori ikantaigiri: —Aiñorika shintacharira irovishate impogini irashiriantanakemparo paniro ovegantara kutagiteriku apishigopireantaganirira, ¿matsi gara iatashitiri inoshikaaterira? ");
INSERT INTO mcbNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iriromparorokari matsigenka pairo intsarogakagakenkani, pairotari yavisavagetakeri ovisha. Irorotari maika kametitake onkavintsaantakenkanira kutagiteriku apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nerotyo ishonkashitantanakaririra shinkovakotankicharira ikantiri: —Atsi kontsaanake. Irorotyo yakontsaanakera ogatyo okenake irako paa vegasanovagetaa kañotasanovagetaatyo apipakotene. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iroro ineaigavakerira pariseoegi yovegairira ikonteigapanuti ovashi isariaiganakari Jeso irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iroro yogotavakera Jeso isariaigakarira irogakagantaigakerira iatake parikoti ovashi yogiaiganakeri tovaini matsigenkaegi. Irirori yovegageigamatirityo maganiro mantsigaigankitsirira, ");
INSERT INTO mcbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kantankicha ikantaviigakeri ganiri itsavetantaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Antari ikañotakara maika itsatagakero ikantakerira kamantantatsirira Isaiashi pairani itsirinkakotakerora ikantakerira Tasorintsi ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Neri yoga nomperane nokogakagakerira nontigankakerira. Notasanovagetakari, aikiro noshineventakari. Nontigankimotakeri nosure intimasurentakerira. Irirori inkamantaigakeri maganiro matsigenkaegi tyati kametiripage, aikiro tyati terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gara ikisantumati, aikiro garatyo ikakitsatantumati irogemisantantakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Garatyo ikisumaigiri tyanirika tesakonarira ishintsitashiigero terira onkametite. Inkantakani inkavintsajaigakeri maganiro kigonkero aganakempara impegakempara Igoveenkariegite maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Maganiro matsigenkaegi timageigatsirira aka kipatsiku iraventaigakemparityo.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Impogini yamaiganakeneri Jeso paniro matsigenka terira inee, aikiro tera irinie, itimagutakeritari kamagarini. Impo irirori ineakagairi, aikiro iniakagairi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yogavageigaketyo kavako maganiro ikantaigi: “Irirorakarityo Iyashikitanakerira Iravi agiaigakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Iroro ikemaigakerira pariseoegi ikantaigakera, iriroegi ikantaigi: “Inti tinkamitakari Veresevo itinkami kamagarinipage. Irirotari gaveakagakeri yoneaganontantaigakaririra itimaguigakerira kamagarinipage.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kantankicha irirori yogotavakerotyo isureigakarira ikantaigiri: “Pine intimera matsigenka irapatoitakeri itovaire impegakempara itinkami impo intsitiiganakerorika inkisavakagaiganakempara ovashi irashirikovakagaiganakempa iokaiganakeri itinkami panivani irinae, mameri tyanimpatyo iromperataempa. Ario ikañoigaka tentaigaririra iitaneegi ikiirora parantavakagaiganaachane inkisavakagaiganakempara oga inkenaigake irashirikovakagaiganakempa ganige itsipavakagaigaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ario ikañotaka Satanashi irirori, ¿matsi tyara inkantakempara ikiirora neagaachane? Inkañotakemparika maika ikiirora parantaachane, ¿matsi iragaveake atanatsira impeganakempara itinkamiegi maganiro kamagarinipage? ");
INSERT INTO mcbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Viroegi onti pikantaigake inti tinkamitakena Veresevo nagaveantakarira noneaganontaigakarira itimaguigakerira kamagarinipage. Iriromera gaveakagakenane kamagarini, ¿ario tyaniratyo gaveakagaigakerira pitovaireegi yoneaganontaigakarira itimaguigakerira kamagarini? Irorotari ogotantunkani onti pikomuigakaro viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kantankicha intityo gaveakagakena Isure Tasorintsi noneaganontantaigakaririra itimaguigakerira kamagarinipage, iroro pogotantaigavakempa atake yogikoneatimoiganakempi Tasorintsi iragaveane. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maika nokogake nonkantaigakempira: ¿Tyara inkantakenkani inkiashitakenkanira pairorira isurariti inkoshigetakenkanira garira oketyo yogusotagani? Antari oketyorika irogusotakenkani ario pinkante inkoshiarantakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Maganiro terira irishinetena onti ikisashitakena, aikiro yogari terira intentena napatotantakera onti itivarokantake. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nonkamantasanoigakempi maika tatarika irovetsikaigake matsigenka terira onkametite ontirika isamatsanaigakeri Tasorintsi, irirori iragaveaketyo imagisantakoigaerira garatyo ikenkiimatairo, kantankicha yogari neavetakemparonerira iragaveane Isure Tasorintsi impo inkantake intityo gaveankitsi kamagarini, garatyo imagisantakotumatiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ario okañotaka aikiro tyanirika samatsanatakerine Kañotasanotakaririra Matsigenka iragaveake Tasorintsi imagisantakotaerira, kantankicha tyanirika samatsanatakerine Isure Tasorintsi, iriro pinkante garatyo imagisantakotumatairi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yogari matsigenka onti ineantunkani yovetsikagetirira ovashi yogotunkani tyara ikanta. Yogari terira inkametite onti yovetsikagetake terira onkametite. Yogari kametiri omirinka onti yovetsikagetake kametiripage. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Viroegi apaiventavageigakempi kañovagetagantsi! ¿Tyara pinkantaigakempa povetsikaigakera kametiripage?, vintiegitari kañovageigacharira. Magatirotari osuretakotunkanirira irorotari oniakotunkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ario ikañota matsigenka negintevagetacharira onti iniakogeti kametiripage, irorotari isuretakogeta. Yogari terira inegintevagetempa onti iniagisevageti posante, irorotari isuretakogeta irirori. Magatirotari osuretakotunkanirira irorotari oniakogetunkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naro kantaigakempine antari aganakempara inkisashitantaigakenkanirira kañovageigacharira inkenkiakagaigakenkani magatiro iniagisevageigakerira kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tatarika piniavageti irorotari inkantaviigakempi Tasorintsi kametitakevirika ontirika tera pinkametite. Pinegintetakerorika piniane irishineventakempi. Antari piniagisevagetakerika ineakempi tera pinkametite, inkisashitakempi intigankakempi morekariku.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Impogini ipokashiigapaakeri Jeso pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigiri: —Gotagantatsirira, atsi okotagaigenanityo terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ikantaigiri Jeso: —Viroegi apaiventavageigakempi kañovagetagantsi, pikogantaigavetakarira noneakagaigakempira terira oneimagetenkani, kantankicha garatyo noneakagumaigimpi. Intagatityo noneakagaigakempi pashini onkañotakemparo ikañotagunkanira kamantantatsirira Jonashi pairani. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pikemakoigakeritari irirori inigakerira omani imaranesanorikatyo kara impo yomavatakotanakara kutagiteri anta isegutoku. Ario inkañotakempa impogini Kañotasanotakaririra Matsigenka iromavatakotanakempa kutagiteri anta kipatsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Impogini aganakempara inkisashiigakemparira Tasorintsi maganiro terira inkematsaigeri inkantake yogari timaigavetacharira pairani Niniveku pairotyo yavisaigakempi viroegi, maganirotari Ninivekunirira ikematsaigakeri Jonashi ikenkitsatimoigakerira ikenkisureaiganaka ineaigaketari yovetsikagisevageigira terira onkametite ovashi ikantatigaiganaka. Kantankicha maika ipokavetaka pairorira yavisavagetakeri Jonashi teratyo pinkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ario onkañotakempa aikiro impogini inkantake Tasorintsi ogari igoveenkariegite Savakunirira pairotyo avisaigakempi viroegi, opokashitakeritari Saromon pairani oponiavagetakatyo samani kara onkemisantakerira irogotagagetakerora, kantankicha maika ipokavetaka pairorira yavisavagetakeri Saromon teratyo pinkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Antari itimagutirira matsigenka kamagarini impo iokanairi iatake anta osarigagitetapaakera yanuivagetakera. Impo ikogavetaka irapishigopireavagetakempamera, kantankicha teratyo iragavee ovashi ");
INSERT INTO mcbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","isurematanaatyo ikanti: ‘Irirompatyo nompigashitanae notimaguvetarira.’ Impo ipigavetaa ineapaakeri giakomatakatyo kañomataka pankotsi otarogaganira onegintetaganira saagitemataketyo kara mameritari timantemparonerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ovashi iatake yagakitira pashini 7 kamagarini pairorira yogagavageigaka. Impo itimaguigapaakeri yoga itimaguvetarira okyara ovashi irirori oga ikenake pairotyo yogagavagetanaka. Ario pinkañoigake viroegi apaiventavageigakarira kañovagetagantsi ariompatyo pogagavageiganakempari, tera pinkematsaigenika.” ");
INSERT INTO mcbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aiñokyara ikenkitsavageti Jeso opokapaake iriniro intiegiri irirentiegi ikogaigavetaka iriniaigakerira, kantankicha tyampa inkenaigake, itikaigakeritari maganiro patoitaigankicharira nerotyo onti inaigapaake sotsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Impo ikamantunkani Jeso ikantagani: —Pokake piniro intiegiri pirentiegi aiño inaigake kara sotsi ikogaigake iriniaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kantankicha irirori ikantiri kamantakeririra: —¿Tyanimpatyora ina? ¿Tyanimpatyora igeegi? ");
INSERT INTO mcbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Impo ishonkateiganakari irogamereegi iokoigakeri ikanti: —Neri yogaegi nopegaigakerira ina aikiro igeegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Imirinkatari tsatagagetirorira ikogagetirira Apa timatsirira enoku irirotyo nopegake ige ontiri incho ontiri aikiro ina. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Impogini ikontetanai Jeso iatake otsapiaku inkaare ipirinitapaake. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yapatovageiganakatyo tovaini matsigenkaegi inakera irirori, ovashi yomatetanaka pitotsiku ipirinitake ikenkitsaigakerira. Maganiro patoitaigankicharira ipitaigake otsapiaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Impo yogotagaigakeri ikantakogetakerora posante ikantaigiri: “Iatake paniro matsigenka impankivagetakera turigoki. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iokagisetanakero pakarara pakarara itsotenkavagetanakero. Okonogagarantaka oparigigetanake avotsiku, impo iparigashiigakero tsimeri yogaigakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pashinikya onti oparigigetanake mapuseku, shintsi oshivokavetanaka, tesakonatari ontimasanotenika kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Impogini iporeavetanaka poreatsiri itaganakero oshigirikanake okamanake, tetanika oatasanote oshitsaki savi, otikakerotari mapu. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Okonogaka pashini oparigigetanake okitagigetakara okitsoki tovaseri timatsirira otsei. Impo oshivokavetanaka turigo ogenanekyatyo oshivokutanaka tovaseri irorori asaganakero okamanai, tera ontime okitsoki. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pashini okonogaka oparigigetanake okametipatsatakera kipatsi. Irorori pinkante oshivokanake okimotanake otimanake tovaiti okitsoki, okonogaka otimake 100, pashini 60, pashini otimake 30. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Impogini yogaegiri irogamereegi yaiñoniiganakari ikantaigiri: —Antari pogotagaigakerira maganiro matsigenkaegi, ¿tyara okantakara pikañotakerora maika pikantakogetakerora magatiro? ");
INSERT INTO mcbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Irirori ikantaigiri: —Pairani tera ogovetenkani tyara inkantaigakeri Tasorintsi matsigenkaegi irogavisaakoigakerira kameti impegakempara Igoveenkariegite. Maikari maika ikogake pogoigakerora viroegi, kantankicha iriroegi gara yogoigiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nonkantasanoigakempi maika tyanirika kogankitsinerira inkemavakerora Iriniane Tasorintsi ariompatyo irogotasanovagetanakeri, kantankicha yogari terira inkoge inkemavakerora ontityo onkomutapitsatakempari, garatyo yogotumageti maani. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irorotari nokañotantaigakaririra maika. Iriroegi otimaigavetaka iroki, kantankicha kañomataka tenirikatyo ontime. Aikiro otimaigavetaka igempita kantankicha kañomataka tenirikatyo ontime, tera inkemaigavakeronika nokantaigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Okañotaka maika otsataganakerora ikantakerira Isaiashi pairani ikanti: ‘Viroegi pinkemaigavetakempatyo, kantankicha garatyo pikemumaigavakero. Aikiro pineaigavetakempatyo, kantankicha garatyo pogotumaigavakero. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tera pinkogaigenika pogoigakera, kañoigamatakavi tenirikatyo ontimaige pisure. Tera pinkemaige, kañomataka tenirikatyo ovegantaigempa pigempita. Aikiro tera pineaige, kañoigamatakavi tenirikatyo pogaige kavako. Onti pikañoigaka maika ganiri pineantaigaro poki, aikiro ganiri pikemantaigaro pigempita, aikiro ganiri pikemumaigi maani. Tera pinkogaigenika pinkematsatasanoigakenara kameti nogavisaakoigakempiniri.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kantankicha viroegi pairo ikavintsaavageigakempi Tasorintsi pineantaigakarorira magatiro pineageigakerira maika, aikiro pikemaigakena nogotagaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Arisanotyo nonkantasanoigakempi maika itimaigavetaka tovaini kamantantaigatsirira intiegiri negintevageigacharira ikogaigavetaka ineaigakeromera pineaiganakerira viroegi maika, kantankicha teratyo ineimaigero. Aikiro ikogaigavetaka inkemaigakeromera pikemaigakerira, kantankicha teratyo inkemumaigero. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Maika atsi kemisantaigena nonkamantaigakempira tatoita nokantakotake inkaara. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ogari turigoki parigigetankitsirira avotsiku inti nokantakoigake matsigenkaegi kemisantaigavetakarorira Iriniane Tasorintsi okenkitsatunkanira. Ikamantaigavetunkani tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite, kantankicha igenanekyatyo ipokashiigakeri kamagarini imagisantakagaigakeri magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ogari parigigetankitsirira mapuseku inti nokantakoigake kemisantaigavetakarorira Iriniane Tasorintsi ishineventaigavetavakaro, kantankicha tera inkematsatasanoigero, ");
INSERT INTO mcbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nerotyo imagisantaiganairo shintsi. Impogini opokashitakeri tsipereagantsi ontirika ikisaviigunkani Iriniane Tasorintsi oga ikenaigake yapakuaiganairo ikañoiganaara okyara tekyara inkematsatumaige. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ogari parigigetankitsirira okitagigetakara okitsoki tovaseri inti nokantakoigake kemisantaigakerorira Iriniane Tasorintsi ikemaigavetavakaro, kantankicha impogini irorokya imaigavai isureigavaarora magatiropage timagetatsirira kipatsiku. Impo iriroegi tenige isuretakoigaemparo Iriniane Tasorintsi, ontitari isureiganaka irashintavioigakempara koriki. Tyampa inkantaigakempa inkematsatasanoigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kantankicha ogari parigigetankitsirira okametipatsatakera kipatsi inti nokantakoigake kemisantaigavakerorira Iriniane Tasorintsi impo ikematsatasanoigakeri irirori. Ovashi itimaigake kameti ikañoigakaro turigo timankitsirira okitsoki 100, pashini ikañoigakaro timankitsirira 60, pashinikya ikañoigakaro timankitsirira 30.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Impo ikanti Jeso: “Maika irorokya nonkantakotake tyara onkantanakempa impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite. Iatake matsigenka ipankitakera turigoki itsamaireku. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Impogini imagavioiganaira maganiro ipokaninkuti pashini kisakeririra ipankitapanutiro tovaseri shigirorira turigo yapatuinkavagetakerotyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Impogini oshivokavetanaka turigo ogenanekyatyo oshivokutanaka tovaseri irorori otentaganakaro. Antari otimanakera okitsoki turigo oneinkani onti okonogakaro tovaseri. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yogari iromperaneegi pankitakerorira ineaigutarotyo ikantaigiri: ‘Kogapage noneaigake onti pipankitake turigokisanorira. ¿Maikari tyaratyo oponiakara tovaseri?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantaigiri irirori: ‘Impa irirorakari kañotakero kisakenarira.’ Iniaiganai iromperaneegi ikantaigiri: ‘¿Atsi noaige nashiaigakiterora?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ikanti irirori: ‘Gatata, pitentagantaigarokari turigosanorira. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Arionetata osampatanakera, impogini nontigankaigakeri gaigakeronerira ovashi irashiaigakero tovaseri irogusovatuigakerora intagaigakerora. Impo irorokya iragaigake turigokisanorira irontaikapiniigakerora pankotsiku ontaikantaganirira turigoki.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Impo inianai Jeso ikantakotakerora ipegakara Tasorintsi Igoveenkariegite matsigenkaegi ikañotagakaro okitsoki mosetasa ikanti: “Iatake paniro matsigenka ipankitakerora pakitsotiro mosetasa itsamaireku. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Irorori pairotyo avisavetaka otsirepekichotakera avisagetakerora pashinipage tsirepekichogetatsirira okitsoki, kantankicha oshivokumatanakera omaranevagetanaketyo kara okañotanaaro inchato otsegororoitanake avisagetanakero pashinipage pankirintsipage impo itimantaigaaro tsimeripage.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Impo ikantakotairo Jeso ipegakara Tasorintsi Igoveenkariegite matsigenkaegi ikañotagakaro opoegantarira pan ikanti: “Antari ovetsikira tsinane pan agavatake kimopane turigopane, impo okonogantakaro opoegantarira ogatyo okenake opoeganake magapatsatiro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ario ikañoigakeri Jeso maika maganiro yogotagaigakerira, onti ikantakogetakero magatiro. Tera irogotagaigeri kogapage, tatarika ikogake irogotagaigakerira ");
INSERT INTO mcbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","onti ikañotakero maika ovashi otsataganaka itsirinkakotanakerira kamantantatsirira pairani ikantakera: “Noniaigerira onti nonkantakogetake posantepage. Nonkenkitsatakogetakero posantepage ogantagarira omanakogetunkani pairani okyasanokyara ovetsikunkani kipatsi kigonkero maika.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Impogini iniaiganairi patoventaigakaririra iatai pankotsiku ikiapaake. Yogari irogamereegi yaiñoniiganakari ikantaigiri: —Nokogaigake pinkamantaigakenara tatoita pikantakotake inkaara piniakotakerora tovaseri shigirorira turigo. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ikanti Jeso: —Yogari pankitakerorira turigoki inti Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ogari tsamairintsi onti magatiro kipatsi itimantaigarira matsigenkaegi. Ogari turigoki intiegi matsigenkaegi pegaigakeririra Tasorintsi Igoveenkariegite. Ogari tovaseri intiegi yashintaigakarira kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yogari pankitakerorira tovaseri inti kamagarini. Antari nokantakera agakenkanira turigoki onti nokantakotake ontsonkatanaempara kipatsi. Yogaegiri gaigakeronerira intiegi isaankariite Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Antari nokantakera ashiakenkanira tovaseri ontagakenkanira, onti nokantakotake tyara onkantanakempa impogini ontsonkatanaempara kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Antari irapatoitaigakerira Kañotasanotakaririra Matsigenka maganiro kematsaigiririra impegakempara Igoveenkariegite, intigankaigakeri isaankariite irapatoitaigakerira kañovagetagaigakaririra itovaireegi intiegiri aikiro maganiro vetsikagisevageigirorira terira onkametite ");
INSERT INTO mcbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","iokaigakerira morekariku. Karari kara inkantakani iriragunteigakempa inkaemavavageigaketyo kara iratsikagisevageigakerotyo irai. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Impogini yogaegiri negintevageigacharira iriaigake intimimoigakerira Tasorintsi inkañoiganakemparira poreatsiri ishimpokirerenkira ikyaenkara kontetapaatsi. Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Antari ipegakara Tasorintsi Igoveenkariegite matsigenkaegi onti okañotaka maika: Yomanunkani kori ikitatunkani kipatsiku. Impogini itimake pashini neakeririra, kantankicha akiirotyo ikitatanairi. Ishinevagetakatyo kara ipimantagetakero magatiro yashintagetarira yagantakarora koriki ipunaventantakarora oga kipatsi inantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Antari ipegakara Tasorintsi Igoveenkariegite matsigenkaegi onti okañotaka maika: Iatake paniro pimantavagetatsirira ikogavagetakera perera pairorira okametitasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Impo ineake pakitsotiro pairorira avisavagetake okutamunkarekitasanovagetakera, opunavagetaratyo kara. Ipimantagetakero magatiro yashintagetarira yagantagetakarora koriki ipunaventantakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Maika nonkantakotaero tyara onkantanakempa impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite onti nonkañotagakemparo kitsari okitsataganira oaaku, ishatekanaka shima iposanteitanakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Impo yogaegiri kitsaigankitsirira inoshiatakoigakeri yamakoiganakerira imparagekiku ipirinitaigakera ikogaigakerira shima yogaganirira yoyagaigavakerira kantiriku. Yogari terira irogenkani onti iokajaigavairi. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ario onkañotanakempa impogini ontsonkatanaempara kipatsi iripokaigake isaankariite Apa Tasorintsi irapatoitaigakerira negintevageigacharira irashirikoigakerira maganiro terira inegintevageigempa ");
INSERT INTO mcbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","iokaigakerira morekariku. Antari anta inkantakani iriraguntevageiganakempa inkaemavavageigaketyo kara iratsikagisevageiganakerotyo irai.” ");
INSERT INTO mcbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Impogini ikantaigiri: —¿Pikemaigakena nokantaigakempirira? Iriroegi ikantaigiri: —Jeeje, nokemaigake. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ikantaigiri: —Pine intimera shintavagetacharira timankitsirira posantepage iarakipage pairorira okametigetake irompiogetakero ivankoku irovetsikagetakerora. Impo irirori iragaveake inoshikagetakerora tatarika ikogake irororika ogantagarira yashintaro pairani ontirika okyarira yagagetake. Ario ikañoigaka maganiro gotasanoigirorira Iriniane Tasorintsi Itsirinkakagantakerira pairani, aikiro yogotagasanoigunkani tyara ikanta Tasorintsi yogavisaakoigirira matsigenkaegi ipegakara Igoveenkariegite, yagaveasanoigaketari irogotagantaigakerora magatiro Iriniane Tasorintsi ogantagarira timankitsi ontiri aikiro okyaenkarira nogotagaigakempi maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Impogini yagatanakera Jeso yogotagageigakerira patoventaigakaririra iatai itimira. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yogotagantapaake anta pankotsiku yapatoitantaigarira jorioegi. Yogavageiganaketyo kavako maganiro kemisantaigavakeririra ikantaiganake: —¿Tyarikatyo kara yogotakerora magatiro oka? ¿Tyarikatyo ikantakara yagaveakera yovetsikagetakerora terira oneimagetenkani? ");
INSERT INTO mcbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Matsi tera iriro tomintemparine karipintero timatsirira atimaigira? Ogari iriniro ontitari Maria. Yogari irirentiegi iriroegitari Santiago, Jose, Sumo intiri Jorashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ario okañoigaka iritsiroegi iroroegi onti otimaigi aka, aneasanovageigirotari aroegi. ¿Tyarikatyo yogotakera kara? ");
INSERT INTO mcbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ovashi teratyo inkogaige inkematsaigakerira onti ikisaenkaigakeri ovashi ikantaigakeri irirori: —Yogari kamantantatsirira tyarika iatake parikoti ishineventavunkani, kantankicha antari inavetaka itimira teratyo irishineventenkani, ontityo ikisaenkatunkani, imaiganakatyo iitaneegi iriroegi aikiro tera irishineventaigempari. ");
INSERT INTO mcbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ovashi tesakona irovetsikagete kara terira oneimagetenkani, teranika inkematsatumaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Impogini yogari Erorishi neagetakeneririra Sesa magatiro Garireaku ikemakotakeri Jeso yovetsikagetakera terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Impo ikantaigakeri inampinaegi ikanti: “Inti nianaatsi Joan Giviatantatsirira nogakagantakerira karanki, nerotyo ikañotantakarorira maika yagaveavagetakera yovetsikagetakera terira oneimagetenkani.” ");
INSERT INTO mcbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Antari okyara irirotari Erorishi shitakotagantakeri Joan yogusotagantakerira karenatsaku ineakera ikantavitakerira Eroria yagapitsatakerira irirenti paitacharira Jeripe. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yogari Joan ikantakeritari Erorishi: “Tera onkametite pagapitsatakerira itsinanetsite pirenti.” ");
INSERT INTO mcbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Irorotari ikogantavetakarira Erorishi irogakagantakerimera, kantankicha ipinkaigairi maganiro timaigatsirira kara, ineaigakeritari Joan inti kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kantankicha impogini agamatatyo kutagiteri agakara igutagiterite Erorishi impo irirori ikaemaigakeri iamigoegite isekatimoigakemparira. Impo isekatavageigakara okiapaake oshinto Eroria otosotapaakera oshonkashonkavagetanakatyo kara. Ishineventamatanakarotyo Erorishi ");
INSERT INTO mcbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ikantiro: —Maika nonkantakempi arisanotyo nompakempiro tatarika pinevitakena, garatyo namatavitimpi. Namatavitakempirika nonkamaketyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iroro okemakerira oatake okantakitirora iniro okantiro: —Ina, ¿tatarikatyo nonevitakeri? Irorori okantiro: —Atsi irorompatyo pinevitakeri igito Joan Giviatantatsirira. Ovashi opiganaa okantapaakeri Erorishi: —Onti nokogake pintogitorenkakagantakerira Joan Giviatantatsirira oyagakenkanira igito peratoku pimpakotakenarora. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ogatyo ikenake irirori ikenkisureanaka, kantankicha matakatari ikantakero, aikiro ikemaigakeritari maganiro ikaemaigakerira, tyampatyo inkantakempa inkantatigaerora ovashi ikanti: —Iroroventi nanityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Itigankake soraro inakera Joan yashitakotakara intogitorenkakiterira iramakotakenerora igito. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Impo yamakotakenero ipakotapaakero, irorokya gishonkakotakenero iniro. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Impogini yogari irogamereegi Joan ipokashiigakeri yamaiganairira ikitaigairira. Impo iaigake ikamantaigakitirira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Impogini yogari Jeso ikemakotakerira Joan yogakagantunkanira iatake parikoti intagani itentaiganaa irogamereegi onti ikenaiganake pitotsiku, kantankicha ineaigavakerityo timaigatsirira kara yogiaiganakeri yanuiiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Impo yogonkeigapaaka yagatakoigapaakera. Iroro yaguivetanakara Jeso ineaigapaakeri patovageigamatakatyo matsigenkaegi kara itsarogakagaiganakari maganiro. Yovegaigakeri maganiro mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Impo inanaira poreatsiri shavini yogari irogamereegi ikantaigiri: —Atake ishavitanai poreatsiri. Akari aka tera tyani timatsine. Atsi pakuaigaeri maganiro yogaegi iriaigaera anta otimagetakera pankotsipage kameti impunaventavageigakeniri isekaegi isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kantankicha Jeso ikantaigiri: —Garatyo iaigi. Paigerityo viroegi isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iriroegi ikantaigiri: —Mameri tatampa nompaigakeri. Intaganivatisanotyo onai 5 pan, yogari shima pitenivani inai. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikanti Jeso: —Atsi maigakenaro. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Impo ikantaigakeri impirinitaigakera maganiro shimpenashiku. Iriroegi ipirinitaigake impo yogari Jeso inoshikakero pan intiri shima yapagotakeri ineventanaka enoku iniakerira Tasorintsi ikantiri: “Apa, noshinevagetakatyo maika pipakenara nogaigakemparira.” Impo ikotagakero pan ipaigakeri irogamereegi, iriroegikya paigakeri maganiro. Ario ikañotagakari shima irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Isekataigaka maganiro ikemaiganaka, impo yogari irogamereegi yapatoigairo aityokyarira onai yoyagaigairo tsivetaku shatekapagerikatyo kara onakotake 12. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Maganiro sekataigankicharira ikaravageigaketyo 5,000, kantankicha intagani yogotunkani surariegi antariniegi, tera ogotenkani tsinaneegi intiegiri ananekiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Impogini yogari Jeso ikantaigiri irogamereegi: —Mateiganaempa pitotsiku piivaiganaera pimonteaiganaempara intati. Narori gatata nopoki, tsikyata noneaigavaeri yogaegi iriaigaera. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Impo iaiganaira maganiro, irirori iatake otishiku iniakerira Iriri, paniro yapuntanaka. Ipitake anta ovashi ochapinitanake. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yogari irogamereegi atavageigake nigankia kara. Ogari inkaare ovoresekantamatanaketyo kara osagusagumatanakerotyo pitotsi pogn pogn, otampiavagetanaketari tampia jiriririri ogipigipitakoigavakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Impo osariagitetanaara kutagiteri ipokapaake Jeso yanuiatapaakero enokua nia. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yogari irogamereegi ineaigutarityo itsarogavageigamatanaketyo kara ikaemavaitaigamatanaketyo: —¡Inaa, inaa, neri yoga kasuvarerini! ");
INSERT INTO mcbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iniamatanaketyo Jeso ikantaigiri: —¡Nanti! ¡Gara pitsarogaigi, shineiganaempa! ");
INSERT INTO mcbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iniamatanaketyo Perero ikanti: —Notinkami, viroratyo, iroroventi kaemenanityo nompokakera kara viroku nanuiatanakerora enokua nia. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ikantiri Jeso: —Tainanityo. Yaguitanake Perero yanuiavetanaka iriatakemera inakera Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kantankicha ineakerora otampiavagetanakera itsarogamatanaketyo ogatyo ikenake itsitiganake ikaemamatanaketyo: —¡Notinkamii, gavaenaa! ");
INSERT INTO mcbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Igenanekyatyo yakontsaanake Jeso inoshiatavairi irakoku ikantiri: —¡Tesakona pogote arisano nagaveavageti! ¿Antari gara pitsarogi? ");
INSERT INTO mcbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iroro yomateiganaara pitotsiku asatyo opeganaa tampia. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Maganiro naigankitsirira pitotsiku itigeroaventaiganakari Jeso ikantaigiri: —¡Arisanoniroro vinti Itomi Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Impogini imonteaiganaka intati iaigake Jenesareku. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yogaegiri timaigatsirira kara ineaigavakerira inti Jeso ishigaigamatanakatyo ikamantavakagaiganakara itsotenkavageiganakerotyo itimageigira. Yamaigapaakeneri maganiro mantsigaigankitsirira irovegaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Impo iriroegi ikantaigiri: —Notinkamii, nokogake nontsagatumaigakerora okaratsaiku pimanchaki. Impo maganiro tsagatakoigakeririra yovegaiganaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Impogini ipokaigake pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi, iponiaigapaaka Jerosarenku, ikantaigakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tyara ikantaigakara pogamereegi tera intsatagaigero magatiro ikantageiganakerira yashikiiganakairira? Pine omirinka isekataigara tera inkivakoigempa inkañotagaigakerora ikantaiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yogari Jeso ikantaigiri: —¿Tyara pikantaigakara viroegi tera iroro pintsatagaige ikantagetakerira Tasorintsi, onti pikogaigake pintsatagaigakerora ikantaiganakerira yashikiiganakempirira pairani? ");
INSERT INTO mcbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ikantavetakatari Tasorintsi: ‘Pimpinkatsaigakerira piri ontiri piniro gara pipugatsanaigari.’ Aikiro ikanti: ‘Yogari kisashitakemparineririra iriri ontirika iriniro irogakenkanityo.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kantankicha viroegi onti pogagaigakero. Pine maika aiñoegi tomintaigacharira kogakovageigankicharira ikantaigavetakari itomi intsarogakagakemparira impaigakerira ikogakoigakarira, kantankicha viroegi onti pikantaigake kametitake inkantakerira: ‘Gara nagavei nopaigimpira pineviigakenarira, magatirotari nashintagetarira onti nashintakagakari Tasorintsi’, ");
INSERT INTO mcbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ovashi gara ipiri. Antari pikañoigakerora maika onti pokaiganakero ikantakerira Tasorintsi, irorokya pipampiatakoiganake ikantageigakerira yashikiiganakempirira pairani. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nokantantaigakempirira onti pikematsatamampegaigaka kogapage. Ikantasanotakeniroro kamantantatsirira Isaiashi itsirinkakoiganakempira pairani ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iriroegi ikantaigavetaka: Tasorintsi inti pairorira ikametivageti, kantankicha ontityo ikantamampegaigaka kogapage, teratyo arisano isuretakoigena. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aikiro ikantaigavetaka: Tasorintsi inti Atinkamiegi, kantankicha onti yogotagantaigi isureigakarira matsigenkaegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Impo ikaemaigakeri maganiro yapatoitaigakeri ikantaigiri: —Kemisantasanoigena maganiro viroegi pinkemasanoigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ogari ogagetaganirira tera iroro kitsitinkantatsine. Ogari pinkante oniagisevagetaganirira posantepage irorotari kitsitinkantagetatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Impo yagatanakera iniavagetakera yaiñoniiganakari irogamereegi ikantaigiri: —¿Pineaigakeri pariseoegi ikisaiganakara ikemaigakempira pikantaigakerira maika? ");
INSERT INTO mcbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ikanti Jeso: —Arione inkañoigake, magatirotari pankirintsi terira iriro pankiterone Apa timatsirira enoku ashiakenkanityo impogini. Iriroegi ontitari ikañoigari terira inee ikatsavakoiganakerira pashini terira inee. Antari inkañotakemparika maika piteni terira inee inkatsavakagaigempara iranuitaiganakera, pitenirotyo iranonkaiganakempa otseraaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iniamatanaketyo Perero ikantiri: —Atsi kamantaigena tatoita pikantakotake inkaara. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikanti Jeso: —¡Arioratyo pikañoigaka viroegi tera pinkemaige! ");
INSERT INTO mcbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Matsi tera pinkemaigero nokantaigakempirira? Nokanti magatiro ogagetaganirira onti oatake segutontsiku, impo oshitakotaagani. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kantankicha magatiro oniagisevagetaganirira onti oponiaka suretsiku, irorotari osuregisevagetantaganirira. Iroro pinkante okitsitinkantiniroro suretsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ariotari oponiagetari isureku matsigenka isuregisevageigarira posantepage, yogantaigira, inoshikaigirora tsinaneegi suraritakoigatsirira ontiri terira osuraritakoige, ikoshiigira, yamatavitantaigira, iniashivageigarora kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Magatiropage oka ovetsikagisetaganirira iroro pinkante okitsitinkantiniroro suretsiku, kantankicha ogari pisekataigempara garira pikivakoiga pinkañotagaigakerora ikantaiganakerira yashikiiganakempirira teratyo onkitsitinkante. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Impogini iatai Jeso Tiroku ontiri Suronku. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Impo okenapaake paniro tsinane kananea okanti: —¡Notinkamii, Iyashikitanakerira Iravi, kavintsaavagetenakario! Aiño noshinto itimagutakero kamagarini atsipereavagetaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kantankicha yogari Jeso teratyo irinie, onti ikemisantanake. Impo yaiñoniiganakari irogamereegi ikantaigakerira: —Atsi kematsatero kameti oataeniri, onti ogiaigapaakai okaemavatapaakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ikanti Jeso: —Intagani itigankavitakena Tasorintsi nompokashiigakerira nonkavintsajaigakerira iseraereegi, ontitari ikañoigakari ovisha timpinaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kantankicha irorori ariompatyo aiñonitanakariri otigeroaventanakarira okanti: —¡Notinkamii, kavintsaavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kantankicha Jeso ikantiro: —Tera onkametite iragapitsaigakenkanira iseka ananekiegi impakenkanira otsiti. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Irorori okanti: —Notinkami, arisanoniroro pikantasanotakeniroro, kantankicha otsiti ineakoigirira isekataigara shintaigaririra itimashitavake otapinaku mesa yogaverokitavakara ovoroki ashirianakara. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ikantutarotyo Jeso: —Iroroventi pogotakera nagaveakera novegaerora pishinto, maika nonkavintsaakempityo novegaerora. Iroro ikantakera maika ogatyo okenake oveganaa. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Impogini iatai Jeso ikenanake otsapiaku inkaare Garirea itonkoanake otishiku, ario ipirinitake kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Impo iatashiigakeri tovaini matsigenkaegi yamaiganakenerira terira iranuitagantsiige, terira ineaige, terira iriniaige, terira irakoige, aikiro iposantevagetanakatyo kara mantsigaigankitsirira. Irirori yovegaigairi maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yogari patoitaigankicharira yogavageiganaketyo kavako, ineaigakeritari ineaiganaira terira ineaigavetempa, yakoiganaira terira irakoigavetempa, yanuitagantsivageiganaira terira iranuitagantsiigavetempa, aikiro iniaiganaira terira iriniaigavetempa. Ogatyo ikenaigake ishineventaigamatanakarityo Tasorintsi kavintsajaigiririra iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Impogini ikaemaigakeri Jeso irogamereegi ikantaigiri: —Notsarogakagaiganakari yogaegi, noneaketari ipiriniventaigakena aka mavati kutagiteri niganki itsonkatakoiganaka isekaegi. Maikari maika mameri tatampa irogaigakempa. Tera nonkoge nontigankaigaerira iriaigaera ivankoku, ontirorokari agaiganakeri itasegane avotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Impo ikantaigiri irogamereegi: —¡Ojojoo itovaigavagetiratyo kara! ¿Ario tyara nagaigakero pan nompaigakerira isekataigakempara maganiro? Ontitari anaigake osarigagitetapaakera, tera tyani timatsine aka. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ikantaigiri irirori: —¿Akatovainivati onai pan pamaigakerira? Ikantaigi: —Intaganivati onai 7, impo aiño aikiro piteni shima. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yogari Jeso ikantaigakeri impirinitaigakera maganiro, ");
INSERT INTO mcbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","impo yagagetanakero pan intiri shima yapagogetanakeri inianakeri Tasorintsi ikantiri: “Apa, noshinevagetakatyo pipakenara oka noseka.” Impo ikotagakero pan intiri shima ipageigakeri irogamereegi, irirokyari pageigavakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Isekataigaka maganiro ikemaiganaka. Ogari aityokyarira onai, yoyagaigairo irogamereegi tsivetaku onakotai 7. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maganiro sekataigankicharira ikaravageigaketyo 4,000. Intaganisano yogoigunkani surariegi, tera ogoigenkani tsinaneegi intiegiri ananekiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Impo Jeso yapakuaigairi iriaigaera ivankoegiku. Irirori yomatetanaa pitotsiku itentaiganaarira irogamereegi iaigake pashiniku kipatsi paitacharira Magarara. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Impogini ipokashiigapaakeri Jeso pariseoegi intiegiri saroseoegi ikantaigapaakeri ineakagaigakerira terira oneimagetenkani onkoneatakera anta enoku inkiteku. Iriroegi onti ikogaigake ineaigakerira arisanorikara opaitaka yagaveavagetira, nerotyo ikañotantaigakarorira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kantankicha irirori ikantaigiri: “Viroegi pineaigirora okiraagitetira inanaira poreatsiri shavini onti pikantaigi: ‘Kamani onkametigitetake, kiraagitemataketari.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Antari ontirika okiraagitetake tsitekyamani onti pikantaigi: ‘Maika gara okametigiteti, kiraagitetamanaketari, aikiro amokake.’ Tyarikatyo pikantaigaka viroegi pogoigakerora ariorika onkametigitetake ontirika gara okametigiteti, kantankicha tera pogotumaige tyara okantaka okañotakara maika pineaigakerora posante terira oneimagetenkani pairani. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Viroegi apaiventavageigakempi kañovagetagantsi, pikogantaigakarira noneakagaigakempira terira oneimagetenkani, kantankicha garatyo noneakagaigimpi. Intagatityo noneakagaigakempi pashini onkañotakemparo ikañotagunkanira Jonashi pairani.” Ovashi iokaiganairi iatai. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Antari imonteaigakara irogamereegi Jeso intati imagisantaiganakero iramaiganakera pan isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Impo yogari Jeso ikantaigiri: —Viroegi, tsikyanira pogakoigarokari opoegantarira pan irashiegi pariseoegi intiegiri saroseoegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iroro ikemaigavakerira iniavakagaiganaka ikantaigi: —Onti ineakera tera amaige pan, nerotyo ikantantaigakairira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yogari Jeso ineaigavakerira iniavakagaiganakara ikantaigutarityo: —¡Tesakona pogotasanoige arisano nagaveavageti! ¿Tyara okantakara pikantaigakera: ‘Onti ineakera tera amaige pan’? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Matsi tekya pogoige? ¿Matsi tenige pisureigaemparo pan onavetakara 5 nokotagagetakerora nosekatagaigakarira 5,000 surariegi? Impo papatoigairora aityokyarira onai, ¿akatovaiti onakotai tsivetaku? ¿Matsi pimagisantaigairo? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aikiro ¿matsi tenige pisureigaemparo onavetakara pan 7 nokotagagetakerora nosekatagaigakarira 4,000 surariegi? Impo papatoigairora aityokyarira onai, ¿akatovaiti onakotai tsivetaku? ¿Matsi pimagisantaigairo? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Antari nokantaigakempira: ‘Tsikyanira pogakoigarokari opoegantarira pan irashiegi pariseoegi intiegiri saroseoegi’, ¿tyara okantaka tera pogoigavake tera iroro noniakote pan? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ovashi yogoigake irogamereegi tera iroro inkantasanote opoegantarira pan, ontityo ikantakotake yogotagantaigirira pariseoegi intiegiri saroseoegi ganiri ikemisantaigiri yogotagantavageigira. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Impogini iatake Jeso ikenanake kara ochoenitakara Sesarea Piripo. Impo ikantaigiri irogamereegi: —¿Tyara ikantaigi maganiro matsigenkaegi? ¿Tyani yoga Kañotasanotakaririra Matsigenka? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iriroegi ikantaigiri: —Ikonogagarantaigaka ikantaigake: ‘Inti Joan Giviatantatsirira.’ Pashini kantaigankitsi: ‘Inti Eriashi.’ Pashinikya kantaigankitsi: ‘Inti Jeremiashi, terika iriro, inti pashini kamantantatsirira pairaninirira yanianaira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Impo ikantaigiri: —Viroegiri, ¿tyara pikantaigana? ");
INSERT INTO mcbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Iniamatanaketyo Sumo Perero ikantiri: —Viro vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite, vinti Itomi Tasorintsi ikantakanirira itimi. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantiri Jeso: —Viro Sumo, itomi Jonashi, shinetempa, teranika iriro matsigenkaegi gotagaigempirone oka pikantakenarira maika. Intitari gotagakempiro Apa timatsirira enoku, ikavintsaakempitari. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Naro nonkantakempi viro vinti Perero. Impogini tyanirika kañotakempine viro pikantakera maika, naro nogavisaakotakeri kameti intentakemparira maganiro kematsaigakenanerira. Garatyo yagaveimaigiri kamagarini, ariompatyo inkematsatasanoiganakenari. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kantankicha viro nagaveakagakempi kameti pinkamantaigakerira pashinipage matsigenkaegi tyara inkantaigakempa kameti nogavisaakoigakerira iriroegi aikiro nompegakempara Igoveenkariegite. Tatarika oita pinkantavitantake aka kipatsiku, ariotyo inkañotakempa Tasorintsi timatsirira enoku inkantakera onkantavitantakenkanira, matakatari ikantavitantakero. Aikiro tatarika oita pinkantake kametitake, ariotyo inkañotakempa irirori inkantake kametitake. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Impo Jeso ikantaviigakeri irogamereegi ganiri ikamantakoigiri inkantaigakera inti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Impogini Jeso itsititanakero ikamantaiganakerira irogamereegi iriatakera Jerosarenku iratsipereakagavageigakerira itinkamiegi jorioegi intiegiri itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi impo ovashi irogakenkani, kantankicha omavatanakempara kutagiteri iranianae. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yogari Perero itentanakari antakona ikantavetanakarira ikantiri: —¡Notinkami, atsi garatyo pikañota maika! ¡Garatyo yogaitimpi! ");
INSERT INTO mcbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kantankicha Jeso ishonkatematanakarityo ikantutarityo: —¡Virori Satanashi, piataenityo parikoti, ontitari pikogavetaka pampakuakagakenamera ganigeniri notsatagagetairo itigankavitakenarira Tasorintsi, teranika iroro pisuretakogetempa ikogagetirira irirori, ontitari pisuretakogetaka ikogageigirira matsigenkaegi! ");
INSERT INTO mcbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Impo Jeso ikantaigiri irogamereegi: —Tyanirika kogankitsine inkantakanira inkematsatasanotakena garatyo ipiriniventiro ikogagetirira irirori, ontityo inkantakani impiriniventavagetanakero nokogagetirira naro, aikiro iratsipereaventavagetakenatyo ariorika inkamaventakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tyanirika tsarogakagacha ikiiro tera inkoge iratsipereaventavagetakenara ikiirotyo kañotagantanankicha, intagatitari ikogake irovetsikagetakera tatarika ikogagetakerira irirori. Kantankicha yogari piriniventirorira nokogagetirira naro yatsipereaventakenara, iriro pinkante iriatake itimira Tasorintsi inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Intimavetakempatyo gaveankitsinerira irashintakemparora magatiro kipatsipagekutirira kantankicha impoginityo inkamanae iriatake morekariku, ¿matsi ario agaveake oganiakerira iaraki? Garatyo agaveimati. Irashintagevetakemparotyo magatiro kantankicha garatyo yagaveimati impunaventakempara ganiri iati morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Antari nompigaatera impogini nonkoveenkavagetapaake nonkañotapaakempari Apa ikoveenkavagetira. Antari nompokaatera nontentaigapaakempari isaankariite nogishineaigapaakerira maganiro shineventaiganarira, iriroegikya pashiventagaiganarira onti nogipashiventaigapaakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Maika nonkamantasanoigakempi antari gatatara pikamaigi pinkonogagarantaigakempa pineaigakena nonkoveenkatanakera viroegiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Impogini avisanakera 6 kutagiteri yogari Jeso iatake anta otishiku itonkoavagetanake. Intagani itentaiganaka Perero, Santiago intiri irirenti Santiago paitacharira Joan. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Impogini inaigakera anta katsiketyo iriroegi ineaigiri ikantatigimoiganakari. Ogatyo ikenake ishimpokirerenkanake ivoroku kañomataka ishimpokirerenkira poreatsiri, aikiro imanchaki onkutamagovageteratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ineaigutarityo Moiseshi intiri Eriashi iniaigakerira Jeso ");
INSERT INTO mcbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","iniamatanaketyo Perero ikantiri Jeso: —Notinkami, ¡matsi ariokonatyo anaigake aka! Pikogakerika novashiigakera mavati pankotsi otyomiatirira, patiro pashi, patiro irashi Moiseshi, ogari omavatakemparira onti irashi Eriashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tekyaenkara iragatumate iniakera apamankakoigapaakeri menkori, impo ikemaigiri inianake Tasorintsi arionika apatosegakara ikanti: “Yokari yoka inti Notomi, notasanovagetarityo kara noshineventakarityo. Maika atsi kemisantasanoigeri viroegi.” ");
INSERT INTO mcbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Irorotyo ikemaigakerira ogatyo ikenaigake itsarogavageiganake yompatakaigamatanakatyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kantankicha Jeso yaiñoniiganakari itsagaigakeri ikanti: —Tinajaiganae gara pitsarogaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ikamaguigavetaa mameri iraratinkaigaera, panivani inai Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Impo ipigaigaara yanonkaiganaara yogari Jeso ikantaigiri: —Gatata tyani pikamantumaigi oga pineaigakerira maika. Antari inkitareanaera Kañotasanotakaririra Matsigenka inkitavetakenkanira, ario pinkante pinkamantantaigakero. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Impo iriroegi ikantaigiri: —¿Tyara ikantakara gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigakera iketyo pokankitsine Eriashi? ");
INSERT INTO mcbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Irirori ikantaigiri: —Arisanoniroro ogari Itsirinkakagantakerira Tasorintsi okantake iketyo pokankitsine Eriashi inkenkitsatimoigakerira jorioegi inkantaigakerira inkantatigaiganakempara inegintetashiigavakemparira impogitapaankitsinerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Maika nonkamantaigakempi mataka ipokuti Eriashi, kantankicha tera irogotavakenkani onti ikisavunkani yatsipereakagavagetunkanira ovashi yogunkani. Ariotyo inkañotagakenkani impogini Kañotasanotakaririra Matsigenka iratsipereakagavagetakenkanira ovashi irogakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iriroegi isureigamatanakarotyo ikantaigi: “Inti iniakotake Joan Giviatantatsirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Impogini yogonkeigapaakara inaigakera matsigenkaegi yapatoitaigakara, ipokashitapaakeri Jeso paniro surari itigeroaventapaakari ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Notinkamii, tsarogakagavagetemparikario notomi ikamakamavagetake yatsipereavagetaketyo kara. Iokavokigematatyo tsitsiku, aikiro iokaakaavagetaka oaaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namaigavetakeneri pogamereegi irovegaigaerira, kantankicha teratyo iragaveaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ikanti Jeso: —¡Ario pikantavageigaka viroegi tekyaenkatyo pogoigero iragaveane Tasorintsi, teranika pinkogaige pinkematsaigakerira! ¿Akasamaninivatirorokari nompiriniventaigakempi nantsipereakoigakempira? Iroroventi atsi maigakenarinityo aka. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Impo iniitarityo kamagarini ikantiri: —Maika piatae parikoti. Ogatyo ikenake ikontetapanuti iatai parikoti ovashi yovegasanovagetanaa ananeki itimaguvetakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yogari irogamereegi iniaigakeri Jeso parikoti ikantaigiri: —¿Tyarika okantakara naroegi tera nagaveaige noneagaigakemparira? ");
INSERT INTO mcbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikanti Jeso: —Ontitari kantankicha tera pisuretasanoigemparo nagaveane pinkantaigakera: ‘Arisanotari yagaveavageti Notinkami iragaveakagakenatyo.’ Antari pinkañoigakeromera maika pisuretasanotumaigakemparora maani, ario pinkante pagaveaigaketyo pinkantaigakerora oga otishi: ‘Gaganakempa piate parikoti’, ogaganakempatyo. Garatyo tatoita komutapitsatumaigimpi arisanorika opaitaka pisuretasanoigakarora nagaveavagetira. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kantankicha yogari kamagarini kañorira maika garira oketyo piniaigiri Tasorintsi, aikiro garira pipitashiigaro kogapage gara pisekataiga, garatyo pagaveimaigiri poneagaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Impogini Jeso itentaigakarira irogamereegi ikenaiganakera kara Garireaku, ikamantaigakeri ikanti: —Yogari Kañotasanotakaririra Matsigenka iragakagantakenkani ");
INSERT INTO mcbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","impo irogakagantakenkani, kantankicha omavatanakempara kutagiteri iranianae. Iroro ikemaigavakerira ikenkisureavageiganakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Impo yogonkeigapaakara Kaperenaoku, ipokashiigakeri Perero kogantaigaririra itovaireegi koriki ashi ivanko Tasorintsi ikantaigiri: —Yogari gotagaigimpirira ¿ipunatityo koriki ashi ivanko Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ikanti Perero: —Jeeje, ipunatinirorotyo. Iroro ikianakera tsompogi pankotsiku inakera Jeso iketyo niavakeri ikantiri: —Sumo, ¿tyara pinkante viro? ¿Tyani ikogantaiga koriki koveenkaripage timageigatsirira aka kipatsiku? ¿Iriro ikogantaiga itomiegi intirika ikogantaiga pashini? ");
INSERT INTO mcbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ikanti Perero: —Intagani ikogantaiga pashini. Ikanti Jeso: —Iroroventi tera iriro inkogantaigempa itomiegi, ");
INSERT INTO mcbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","kantankicha aroegi ganiri iniashinaigai, piate inkaareku pintsagaatakitera impo yogari iketyorira pagake pintinkirankakerira pinoshikakerira korikimenta nankitsirira ivaganteku pamaigakenerira kogantantaigacharira koriki ashi ivanko Tasorintsi pimpaigakerira. Irogonketakempa ampunaventaigakempara piteniro. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Impogini yaiñoniiganakari irogamereegi ikantaigiri: —¿Tyani visaigakerine itovaireegi impogini pimpegakempara Nogoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Irirori ikaemake paniro ananeki yogaratinkakeri niganki inaigakera ");
INSERT INTO mcbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ikantaigiri: —Nonkantasanoigakempi garira pikantatigaiga pisureku pinkañoigakemparira ananekiegi garatyo pitimimoigana impogini nampatoitaigakerira maganiro kematsaiganarira nompegakempara Igoveenkariegite, ");
INSERT INTO mcbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","kantankicha tyanirika kañotakemparine yoka ananeki terira isuretumatempa iravisumanatantakera, iriro pinkante pairotyo iravisantavagetake impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aikiro tyanirika kavintsaakerine ananeki kañorira yoka kañomataka nantinirikatyo ikavintsaake, nantitari ikematsatake. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kantankicha tyanirika kañovagetagakerine paniro kematsatakenarira terira impaitumatempa inkisashivagetakenkanityo kara. Irorotari nonkantantaigakempirira ganiri ikañotiri maika oketyome irogatsatakotantakenkani itsanoku omarane mapu otononkantaganirira iramanakenkanira iokaatakenkanira otsompogiatira omaraaniku nia. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Maikaniroro iratsipereavageigake maganiro timaigatsirira aka kipatsiku, intimaigaketari kogaigankitsinerira inkañovagetagantaigakera! Ariotyo onkañotakempa maika, kantankicha pairotyo iratsipereasanovageigake kañoigakeronerira maika inkisashitasanoigakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nonkantantaigakempirira irorora kañovagetagakempine pako ontirika pivonkiti, ariometyo povatuakerome povuokakerora parikoti, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku garira otsivakumati. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ontirika poki irorora kañovagetagakempine, ariometyo pinkitsogitakerome povuokakerora parikoti, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku garira otsivakumati. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nonkantaigakempi maika garatyo pikisaigiri yogaegi kematsaiganarira terira impaitumaigempa, aiñoegitari isaankariite Apa pampogiakoigiririra. Iriroegi ikantakani inaigake anta enoku inampinaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yogari Kañotasanotakaririra Matsigenka onti ipokashitake irogavisaakoigakerira pegaigankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Tyara pinkantaige viroegi? Pine intimera paniro matsigenka impiratakempa 100 irovishate impo impegakempa paniro, ¿matsi gara iokaiganakeri maganiro irovishate iriatakera inkogaaterira pegankicharira? ");
INSERT INTO mcbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Impo iragaeririka pairotyo irishineventakempari, iravisaketyo ishineventaigarira maganiro 99 terira impegavetempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ario ikañotaka Piri timatsirira enoku tera inkoge impegumatempara paniro yokaegi kematsaiganarira terira impaitumaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tyarika inkantakempi papigematsatene pintentanakeri parikoti piniakerira paniro pinkamantaerira tyarika ikantakempi. Irirori inkemakempirika mataka pogametiairi. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Antari garika ikemimpi pintentanake paniro, ontirika piteni papigematsaegine kameti inkemaigakeniri iriroegi, aikiro irogoigakeniri arisanorika pikogake pogametiaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kantankicha garika ikemi iroroventi piatetyo pintentanakerira yapatoitaigara kematsaigatsirira inkanomaakenkanira. Garika ikemaigiri iriroegi iroroventi inkañotagakenkanityo terira inkematsateri Tasorintsi intirika kogantaiginiririra koveenkari koriki. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Maika nonkantasanoigakempi tatarika oita pinkantavitantaigake aka kipatsiku, ariotyo inkañotakempa Tasorintsi timatsirira enoku inkantakera onkantavitantakenkanira, matakatari ikantavitantakero. Aikiro tatarika oita pinkantaigake kametitake, ariotyo inkañotakempa irirori inkantake kametitake. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aikiro nonkantaigakempi tatarika oita pikogaigake pineviigakerira Apa timatsirira enoku oketyo pinkemavakagasanoigakempa impo piniaigakeri. Irirori inkemaigakempi intsatagakero tatarika oita pikantakerira. Pinaigavetakempatyo piteni kantankicha pinkemavakagaigakemparika inkemaigakempityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Omirinkatari tyarika kara yapatoventaigakena iriniaigakenara pitenityo irinaigavetakempa ontirika irinaigavetakempa mavani, ariotyo nonimoigakeri naro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Impogini yaiñonitanakari Perero ikantiri: —Notinkami, ¿akatovaiti nomagisantaero tyarika inkantakena napigematsatene? ¿Ario onkaratanake 7? ");
INSERT INTO mcbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ikanti Jeso: —Garatyo ario okarati 7, ontityo pimagisantakotaeri magatiro tyarika inkantakempi, gara okaratumati. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iroroventi maika nokogake nonkamantaigakempira tyara onkantanakempa impegakempara Tasorintsi Igoveenkariegite matsigenkaegi onti nonkañotagakemparo koveenkari ikaemaigakerira inampinaegi inkantaigakerira impunaigaerira ipegakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iroro itsititanakera ikaemakagantaigakerira yamaigapaakeneri paniro pegakovagetiririra tovaini koriki kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kantankicha irirori mameri tatampa impunatantaempari nerotyo yomperaventantakaririra koveenkari impimantakenkanira intentagantakenkanira itsinanetsite intiegiri itomiegi ontiri magatiro yashintagetarira iragantageigakemparora koriki kameti impunataeriniri ipegakogetirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kantankicha irirori yompatakaventamatanakarityo ikantiri: ‘Tsarogakagavagetenakario, pogiakotakempara impoginityo nompunataempi maganiro koriki nopegakotimpirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yogari koveenkari itsarogakaganakari ikantiri: ‘Iroroventi arione, gara pipunataana’, ovashi yapakuairi. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kantankicha iroro iataira itonkivoakari itovaire pegakotiririra maani. Yagamatanakerityo ikatikanakerira ikantiri: ‘¡Punataena pipegakotanara!’ ");
INSERT INTO mcbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Irirori yompatakaventavetanakari ikantiri: ‘Tsarogakagavagetenakario, impogini nompunataempi,’ ");
INSERT INTO mcbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","kantankicha irirori teratyo intsarogakagempari, onti yamakagantakeri irashitakotakenkanira kigonkero impunataerira ipegakotirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Impogini ikemakoigakerira itovaireegi ikisaigamatanakatyo iaigake ikamantaigakitirira koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iroro ikemavakera ikaemakagantairi ikantiri: ‘¡Viro tera pinkametite, vinti pairorira pogagavageta pikisantira! Kogapage naro nokantakempi arione gara pipunataana, pikantakenatari nontsarogakagavagetakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ariometyo pinkañotagakerime pegakotakempirira viro pintsarogakagakemparimera irirori pinkañotakenara naro notsarogakagakempira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ikisamatanakatyo yomperaventakari iratsipereakagaigakemparira ovashi impunataeri magatiro ipegakogetirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yagatanakera Jeso ikenkitsatakera ikanti: —Ariotyo inkañotagaigakempi Apa timatsirira enoku garira pitsarogakagaigari pitovaireegi pimagisantaigaerora tyarikara inkantaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Impogini iponianaka Jeso Garireaku iatakera Joreaku intati Jororanku. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yogiaiganakeri tovaini matsigenkaegi. Antari anta yovegaigairi maganiro mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Impo ikonogagarantaigaka pariseoegi naigankitsirira kara ipokaigapaake inkogakotagantaigakerira ineaigakera tyarikara inkantaigeri irirori, ontitari ikogaigavetaka inkemaigakerira inkantakera tatarika oita terira onkatinkatero ikantaigirira iriroegi kameti intsavetantaigakeriniri inkisakagantaigakerira, nerotyo ikantaigapaakeri: —¿Okantavitantagani iokakerora surari itsinanetsite? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Irirori ikantaigiri: —¿Matsi tera piniavantaigero Itsirinkakagantakerira Tasorintsi okanti ikyasanokyara yovamparoatake Tasorintsi matsigenka ‘piteniro yovetsikaigakeri surari ontiri tsinane’? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Impo ikantake: ‘Nerotyo yogari surari gankitsinerira tsinane iokanakeri iriri ontiri iriniro iriatakera iragakerora inkantakani impanirotanakero. Antari okyara tekyara iragero piteni inaigavetaka, kantankicha antari yaganakerora oga ikenake itentaganakaro kañomataka panironirikatyo inai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nerotyo yogari surari gankitsirira tsinane garatyo iokumatiro, tenigetari irapiteigaempa, kañomatakatari panironirikatyo inai, ineaketari Tasorintsi yagakerora ikanti maika tera onkametite iokanaerora, kantakanityo iragakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iriroegi ikantaigiri: —Iroroventi, ¿tyara okantakara ikantakera Moiseshi iokanaerorika surari itsinanetsite impakero sankevanti onkantake: ‘Maika mataka nokanaimpi’, impo inkantakero oataera? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantaigiri Jeso: —Yogari Moiseshi ontitari ineakera tera pinkogaige pinkematsaigerira Tasorintsi, nerotyo ikañotantaigakempirorira maika itsirinkaiganakempira. Kantankicha antari ikyasanokyara yovamparoatake Tasorintsi matsigenka, tera ario inkañotero maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Narori nonkantaigakempi ompanirotakempirika pitsinanetsite garatyo piokiro. Pokanakerorika impogini pashinikya pagake onti pikañovagetaka. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yogari irogamereegi ikantaigi: —Iroroventi opomirintsivagetaratyo kara agenkanira tsinane. Onkanteroro tyampa ankantakero agakera tsinane. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yogari Jeso ikantaigiri: —Tera iragaveaigenika maganiro inkemaigakerora nokantaigakempirira maika, intaganitari kemaigakero yagaveakagaigakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aiñoegitari ikonogagarantaigaka tera iragaveaige intomintaigempara. Aikiro aiño pashini onti okitsogitunkani igatsareki. Aikiro aiñoegi pashini onti ishintsitashiigakero tera intsagaigero tsinane kameti impiriniventaigakeroniri magatiro ikogagetirira Tasorintsi. Tyanirikara gaveankitsine inkemakerora nokantaigakempirira maika kantetyo inkemakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Impogini ipokaigake pashini yamaigapaakenerira Jeso ananekiegi impatikaiigakerira igitoku aikiro iriniaventaigakerira. Yogari irogamereegi ineaigavakerira yamaigapaakerira ikantaviigavakeri ikantaigiri: —Maiganaeri parikoti, gara poverajaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kantankicha ikemaigakerira Jeso ikañoigakerora maika ikantaigiri: —Atsi arionenityo iripokaigakera naroku, ishineventaigaritari Tasorintsi impegakempara Igoveenkariegite kañoigaririra yogaegi ananekiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Impo ishonkateiganakari ipatikaiigakeri igitoku iniaventaigakerira. Impo irirori iatanai parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Antari ikenanakera Jeso kara ipokashitapaakeri paniro matsigenka ikantapaakeri: —Gotagantatsirira, atsi kamantena tyara nonkantakempa kameti nonkantakanira nontimake. ¿Tatoita novetsikakera? ¿Tatoita kametitankitsine? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ikantiri Jeso: —Tyara okantakara pikantakenara: ‘¿Tatoita kametitankitsine?’, mameritari pashini kametitasanotatsinerira, panirotari ikantara Tasorintsi ikametitira. Kantankicha pikogakerika pinkantakanira pintimake, tsatagageterotyo magatiro itsirinkakotanakerira Moiseshi pairani. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ikanti irirori: —¿Tyatityo? Ikanti Jeso: —Irorotari kantatsirira: ‘Gara poganti, gara piatashitiro tsinane, gara pikoshiti, gara pitsoeventari pitovaire. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pimpinkatsaigakerira piri ontiri piniro gara pipugatsanaigari, aikiro pintsarogakagavagetakemparira pitovaire pinkañotagasanotakempatyo pitsarogakagara vikiiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ikantutarityo irirori: —Arioniroro nokañotari maika notsititanakero notsatagasanotanakerora notyomiakyanira ovashi maika. ¿Maika aityokya pashini nontsatagakerira? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ikantiri Jeso: —Pikogakerika pairora pintsatagasanotakero ikogagetirira Tasorintsi, piate pimpimantagetakerora magatiropage pashintagetarira pagantakemparora koriki pimpaigakerira kogakoigankicharira impo pimpokake pogiavagetanakenara. Impogini ariokya inkavintsaavagetakempi Tasorintsi enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikemutatyo ikantakerira maika ikenkisureavagetanakatyo kara ovashi iatai ipiganaara, intitari shintavagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Impogini ishonkashiiganakari Jeso irogamereegi ikantaigiri: —Arisanotyo nonkantasanoigakempi okomuvagetaratyo kara irogavisaakotakenkanira shintavagetacharira impegakempara Tasorintsi Igoveenkarite. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nonkantutaigaempityo aikiro, ¿matsi ario iragaveake kameyo inkianakera otsempokiku kitsapi iravisakerora aikyara? Garatyo yagaveimati. Irirompasanotyo shintavagetacharira intasanotakemparorika yashintagetarira garatyo yogavisaakotagani. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ikemaigutatyo irogamereegi ariompatyo yogasanovageiganakeri kavako ikantaigiri: —Iroroventi ¿tyanimpatyora irogavisaakotakenkani? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ipampogiaiganakeri Jeso ikantaigiri: —Gara tyani gavisaakotumatacha tsikyata, intaganitari Tasorintsi gaveatsi yogavisaakotantira, teranika tatoita komutapitsatumatemparine irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Impo inianake Perero ikanti: —Notinkami, naroegi nokaiganakero magatiro nashintaigavetarira nogiavageiganakempira. Maikari ¿tatarika impaigakena Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ikantaigiri Jeso: —Arisanotyo nonkantasanoigakempi antari onkyatagagetaenkanira magatiro, nompegasanotakempa Igoveenkariegite maganiro. Viroegi giavageigakenarira maika pintentaigakena pimpegaigakempara aikiro koveenkariegi pinkantaigakera tyara inkantaigakenkani iyashikiiganakerira itomiegi Iseraere. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aikiro yogaegi maganiro okaiganakerorira ivankoegi intirika irirentiegi, iritsiroegi, iriniro, iriri, itomiegi, aikiro itsamaire, iriaigakera impiriniventaigakerora notigankaviigakeririra impaigakenkani pashini pairotyo avisagetakero yashintageigavetakarira ontovaigavagetakera, tatarika oita iokaiganake patiro impaigaenkani pashini 100. Aikiro inkantakani intimaigake gara ineimaigairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kantankicha ikonogagarantaigaka aiñoegi ineaigavetunkanirira maika yavisaigakerira itovaire, kantankicha iriroegikyatyo iravisaiganaenkani impogini. Iriroegikya ineaigavetunkanirira yavisaigunkanira maika, impogini iriroegikyatyo visantaiganaatsine. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Maika nokogake nonkantakotakerora tyara onkantanakempa impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite nonkañotagakerora shintankicharira itsamaire. Irirori onti iatamanakeni inkaara tsitekyamani inkogakitera tavageigatsirira intsamaitakoigakenerira iovashite. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iroro ineaigapaakerira kogaigankitsirira irantavageigakera ikantaigiri: ‘Pikogaigakerika pintsamaitakoigakerora ova, naro nompaigakempi paniro tenario.’ Iriroegi ikantaigake kametitake, nerotyo itigankaigakerira iriaigakera intsamaiigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Impo yogaenokanakara poreatsiri iatai opimantavagetantapinitaganira inkogaatera pashini tsamaiigankitsinerira. Iroro ineaigapaakerira pashini pitaigamatake kogapage tera tatoita irantumaige, ");
INSERT INTO mcbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ikantaigiri: ‘Piaige viroegi aikiro pantavageigakera notsamaireku, impogini nompunaigakempi’, ovashi iaigake. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Impo ikatinkatanakera poreatsiri ipigutanaatyo aikiro inkogaatera pashini tsamaiigankitsinerira. Impo ario ikañotagairo itsunkanaira yagaati pashini. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Impo panikyara irishonkanakempa poreatsiri ipigutanaa aikiro ineaigapaake pashini tera tatoita irantumaige ikantaigiri: ‘¿Tyara okantaka pirinitaigakevi kogapage tera tatoita pantumaige?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ikantaigi: ‘Teranika tyani kogakoigenane.’ Irirori ikantaigiri: ‘Iroroventi piaige viroegi pantavageigakera notsamaireku.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Impo ochapinienkatanakera ikantiri tsamaitagaigakeririra: ‘Maika kaemaigeri tsamaiigankitsirira pimpunaigakerira paniropage, pintsitigetanakeri impogigeiganankitsirira pinkaratagagetanakeri iketyorira pokaigankitsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Impo ipokaigapaake pokaigankitsirira panikyara irishonkanakempa poreatsiri. Imirinkaegi ipaigakeri paniro tenario. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Impo ipokaigapaake iketyorira tavageigamanankitsi. Iriroegi ineaigiri ariori irogavisaigakeri impunaigakerira, kantankicha ariotyo ikañotagaigakari itovaire ipaigakerira paniro tenario. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iroro ineaigakera tera irogavisaigeri impunaigakerira ogatyo ikenaigake iniashinaiganakari shintarorira itsamaire. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Impo ikantaigakeri: ‘Yogaegiri impogigeiganankitsirira maanisano yantavageigavetaka kantankicha viro pipunaigakerityo kañotaka pipunaigakenara naroegi tsipereaigankitsirira nantavageigakera poreatsiriku ovashi maika.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kantankicha yogari shintarorira ikantakeri paniro tavagetankitsirira: ‘Atsi shonkeratyo. Teratyo namatavitempi. ¿Matsi teratyo nonkantempi inkaara nompakempira paniro tenario? ");
INSERT INTO mcbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Piatae manakeri ipakempirira. Narotari kantakeri impunatakerira impogitanankitsirira yantavagetakera inkañotagakempira viro ipunatakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Matsi tera naro shintemparine nogorikite kameti ganiri novetsikageti tatarika nokogake? Impa ariorakari pitsimaventaka pineakera pashinira nokavintsaake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Irorotari nonkantantaigakempirira maika aiñoegi ineaigavetunkanirira maika yavisaigakerira itovaire, kantankicha iriroegikyatyo iravisaiganaenkani impogini. Iriroegikya ineaigavetunkanirira yavisaigunkanira maika, impogini iriroegikyatyo visantaiganaatsine.” ");
INSERT INTO mcbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Impogini iatanakera Jeso Jerosarenku ikenanakera avotsiku ikaemaigakeri irogamereegi iriroku ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Maikari onti atonkoaiganake aiganakera Jerosarenku. Antari anta agonkeigakemparika onti iragakagantakenkani Kañotasanotakaririra Matsigenka iramanakenkanira inaigakera itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi. Iriroegi inkantaigake: ‘Kante irogakenkanira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Impo iramanakenkani inaigira terira iriroegi jorioegi kameti isamatsanatakenkanira, aikiro impasapasatakenkanira, impo inkentakotakenkani, kantankicha omavatanakempara kutagiteri iranianaetyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Impogini okenapaake itsinanetsite Severeo otentaigapaakari otomiegi otigeroaventapaakari Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Irirori ikantiro: —¿Tatatyo pikogake? Irorori okanti: —Impogini pimpegakempara Igoveenkariegite maganiro nokogavetaka povirinitaigakerira yoka notomiegi pinampinaku, paniro pitankitsine pakosanoriraku, yogari irapitene impitake pampateku. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kantankicha Jeso ikanti: —Viroegi tera pogoigenika yogari pirinitankitsinerira nonampinaku pairotyo iratsipereavageigake aka kipatsiku, nerotyo pikantantaigakenarira maika. ¿Matsi pagaveaigake viroegi pantsipereaigakera pinkañoigakenara naro nantsipereakera? Iriroegi ikantaigiri: —Jeeje, nagaveaigakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ikantaigiri Jeso: —Pikantasanoigakeniroro pantsipereaigakera pinkañoigakenara naro nantsipereakera, kantankicha tera naro kantatsine tyani pitankitsine nonampinaku, intitari kantankitsi Apa pairani okyasanokyara. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Impogini yogari itovaireegi irogamereegi ikemaigavakera ikisaigamatanakerityo Santiago intiri Joan. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kantankicha Jeso ikaemaigakeri ikantaigiri: —Pogoigiritari viroegi yogari igoveenkariegite terira iriroegi jorioegi onti ipotetashivageigari itovaireegi. Ario ikañoigaka aikiro itinkamipage yomperaperaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kantankicha viroegi gara ario pikañoigiro maika. Tyanirika kogankitsine iravisaigakerira itovaireegi ontityo irimutakovageigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ario okañotaka tyanirika kogankitsine pairora iravisavageigakeri tsikyatatyo inkogake irirori irimutakovageigakerira kañomataka irironirikatyo ironampiriaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kañotari Kañotasanotakaririra Matsigenka tera iroro iripokashite irogiakovagetakempara, ontityo ipokashitake irimutakotantavagetakera, aikiro inkamaventaigakerira maganiro kameti irogavisaakoigakenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Impogini Jeso intiegiri irogamereegi iponiaiganaka Jerikoku iaiganakera Jerosarenku yogiaiganakeri tovaini matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ario kara ipitaigake onampinapokiku avotsi piteni terira ineaige. Iroro ikemakoigavakerira pokapaake Jeso ikaemavaitaigamatanaketyo ikantaigiri: —¡Notinkamii, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ikantanaigavetakarityo itovaire: —¡Atsi kemisantaigenityo! Kantankicha iriroegi ariompatyo ikaemasanoiganakeri: —¡Notinkamii, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yogari Jeso asatyo yaratinkapaake ikaemaigakeri ikantaigiri: —¿Tata pikogaigake? ");
INSERT INTO mcbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Iriroegi ikantaigiri: —Notinkami, onti nokogaigake noneaiganaera. ");
INSERT INTO mcbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Itsarogakagaigamatanakarityo Jeso itsagaigakeri irokiku. Ogatyo ikenaigake ineaiganai ovashi iaigake yogiaiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Impogini iaiganake yogonkeigapaaka Vetipajeku otishiku Orivoshi. Ogari Vetipaje onti ochoenitakotakaro Jerosaren. Impo yogari Jeso itigankaigake piteni irogamereegi ");
INSERT INTO mcbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantaigavakeri: —Piaige anta choeni itimageigira pineaigapaakero kara paniro ashina intiri otyomiani akamotiakyani tsatakoigaka. Pintsaakoiganakeri pamaigakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aiñorika kantaigakempinerira: ‘¿Matsi tyara pinkantaigakeri?’ viroegi pinkantaigakeri: ‘Inti kogakotakari Atinkami, kantankicha paita irogipigaigaempiri.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ario okañotaka maika otsataganakara ikantakerira kamantantatsirira pairani itsirinkanakera ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kantaigeri timaigatsirira Shionku: ‘Atsi shonke, pokapaake Pigoveenkariegite. Irirori inti pairorira ikemisantakovageta. Onti ishigakotantapaakari akamotiakyanirira ashino, otyomiani kiasevagetatsirira arakintsi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Impo iaigake irogamereegi itsaakoigapaakero ashina intiri otyomiani ");
INSERT INTO mcbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yamaiganakenerira Jeso. Ipashimititsaigakeneri imanchakiegiku, impo irirori ipirinitantakari ishigakotantanakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yogiaiganakeri tovaini matsigenkaegi. Ikonogagarantaigaka yovetsarankaashiigavakeri imanchaki avotsiku, pashinikya tovishiigavankitsi tsigaroshi ishitavokitashiigavakerira kameti inkenakotanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yogari ivaiganankitsirira intiegiri giaigapaakeririra ikaemageigamatityo kara ikantaigi: —¡Pairo ikametiti yogaa Iyashikitanakerira koveenkari Iravi! ¡Pairo ikavintsaavagetakeri Tasorintsi yoga itigankakerira impegakempara Agoveenkariegite! ¡Pairo ikametiti Tasorintsi timatsirira enoku! ");
INSERT INTO mcbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Impogini yogonketapaakara Jerosarenku ogatyo ikenaigake timaigatsirira kara ishigaviovageigapaakatyo ikantaigavakerira giaigapaakeririra: —¿Tyaniratyo yoga? ");
INSERT INTO mcbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iriroegiri ikantaigi: —Inti Jeso kamantantatsirira poniankicharira Nasareku Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Impo Jeso ikianake ivankoku Tasorintsi ineaigapaakeri pimantavageigatsirira intiegiri punaventavageigatsirira. Yoneagaigapaakari maganiro, aikiro itatsinkagetakero imesane yoginoriantaigarira igorikiegite kampiavageigiririra koriki yogishonkagetakero. Imatakero aikiro ipirinitantaigakarira pimantavageigatsirira shiromega. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikantaigiri: —Okantake Itsirinkakagantakerira Tasorintsi okanti: ‘Ogari novanko onti ashi iripokapiniigera iriniaigakenara’, kantankicha viroegi onti pipegakagaiganakaro ipimantapiniigira matavitantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Impo ipokashiigakeri terira ineaige intiegiri terira iranuitagantsiige. Irirori ineakagaigairi terira ineaigavetempa, aikiro yoganuitagantsiigairi terira iranuitagantsiigavetempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yogari itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ikisaigamatanakatyo ineaigavakerira yovetsikagetakera terira oneimagetenkani, aikiro ikemaigakerira ananekiegi ikaemavaitaigakera ikantaigakera: “¡Neri yogaa Iyashikitanakerira koveenkari Iravi pairorira ikametiti!” ");
INSERT INTO mcbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Impo ishonkateigamatanakarityo Jeso ikantaigutarityo: —¿Matsi tera pinkemaigeri yogaegi ananekiegi ikaemavaitaigakera? ¿Tera tyara pinkantumaigeri? Yogari Jeso ikantaigiri: —Jeeje, nokemaigakeriniroro, kantankicha ¿matsi tera piniavantumaigero viroegi Itsirinkakagantakerira Tasorintsi niakotakerorira oka? Okantaketari: ‘Yogari Tasorintsi yagaveakagaigakeri ananekiegi intiegiri aikiro aiñokyarira itsomiigi irishineventaigakemparira inkantaigakera: ¡Pairo ikametiti Tasorintsi!’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Impo ovashi iokaiganairi ipiganaa Vetaniaku, ario imaganake kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Impo okutagitetamanakera ipigaigamanaa Jerosarenku. Yogari Jeso itaseganake. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Impo ineventakotapaakaro igera onampinapokiku avotsi ovashi iatapanuti inkamosotapanuterora ineiri aityori oi, kantankicha yagavetapaakaro aiñoni mameri, onti gotankicha oshi. Ikantutarotyo: —¡Maikari maika gara otimumatai pii! Ogatyo okenake oshigirikanake okamanake. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iroro ineaigakerora irogamereegi yogaiganake kavako ikantaigiri: —¿Tyara okantakara iroro piniimatakera oga okenake okamanake? ");
INSERT INTO mcbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yogari Jeso ikantaigiri: —Arisanotyo nonkantasanoigakempi pogotasanoigakerika arisano yagaveavageti Tasorintsi magatiro, ario pinkante pagaveaigaketyo pinkañoigakenara naro nogishigirikakerora igera. Kantankicha gara patiro oka. Pinkantaigakerorika oga otishi: ‘Piate okaatempa omaraaniku nia’, oataketyo okaatakempara. Kantankicha gara piniasurentavagetumaigaa maani pinkantaigakera: ‘Ariorikatyo iragaveake Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tatarika oita pineviigakeri Tasorintsi piniaigerira pogotasanoigakerika arisano iragaveake impaigakempirora impaigakempirotyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Impo yogonketapaakara Jeso ikiake ivankoku Tasorintsi yogotagaigapaakerira. Osamanitanakera ipokashiigapaakeri itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi ikantaigiri: —¿Tyani kantakempira pinkañotakerora maika poneagaigaemparira pimantavageigatsirira? ¿Tyanimpatyora tigankakempira? ");
INSERT INTO mcbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yogari Jeso ikantaigiri: —Maikari maika narokya kogakotagantaigakempine, pinkamantaigakenarika viroegi ario nonkañotakempa naro nonkamantaigakempi tyani tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tyani kantakeri Joan irogiviatantavagetakera? Maika viroegi kantaigena tyani kantakeri. ¿Irirorika kantakeri Tasorintsi intirika kantaigakeri matsigenkaegi? Iroro ikemaigavakera iniavakagaigamatanakatyo ikantavakagaiganakara: “¿Tyarikatyo ankantaigeri? Ankantaigavetempari inti kantakeri Tasorintsi, irirori inkantaigakaetyo: ‘Iroroventi ¿tyara okantakara tera pinkematsaigeri?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ariokya ankantaigavetempari inti kantaigakeri matsigenkaegi, inkisaigakaetyo atovaireegi, maganirotari ikantaigake inti kantakeri Tasorintsi inkamantantavagetakera.” ");
INSERT INTO mcbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nerotyo ikantantaigakaririra: —Nirorotyo, tyanirorokari kantakeri. Impo irirori ikantaigiri: —Iroroventi ariotyo nonkañotakempa naro, garatyo nokamantaigimpi tyani tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Impogini Jeso ikantaigiri: —¿Tyarika pinkantaige nonkantaigakempira maika? Itimi pairani matsigenka aiño piteni itomi. Impogini ikantakeri itsitiki: ‘Notomi, piatakera pagavagetakera ova.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Irirori ikanti: ‘Garatyo noati’, kantankicha impogini isuretanaka iatake yagavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Impogini iatashitakeri irapitene itomi, ario ikañotagakari irirori yomperatakarira. Iriro pinkante ikantake: ‘Je'ee nonkañotakeniroro’, kantankicha tera iriate. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Maikari kantaigena, ¿tyani kematsatasanotakeri iriri? Iriroegi ikantaigi: —Inti itsitiki. Impo Jeso ikantaigiri: —Arisanotyo nonkantasanoigakempi ogaegiri tsinaneegi pogereantaigatsirira intiegiri kogantaigaririra itovaireegi koriki irashi koveenkari ataketyo yogoiganake tyara inkantaigakempa kameti impegakempara Tasorintsi Igoveenkariegite, kantankicha viroegi tekyatyo pogotumaige. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pine ipokashiigavetakempitari Joan Giviatantatsirira yogotagaigavetakempira tyara pinkantaigakempa pinegintevageigakempara, kantankicha viroegi tera pinkematsaigeri. Ogaegiri pogereantaigatsirira intiegiri kogantantaigacharira koriki irashi koveenkari iriroegi pinkante ikematsaigakeri. Viroegiri pineaigavetakarityo kantankicha teratyo pinkogaige pinkantatigaigakempara pampakuaigakerora povetsikageigira terira onkametite pinkematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Maika nokogake pinkemisantaigakenara nonkantakotaera pashini. Itimake paniro matsigenka yashintaka igipatsite. Impogini ipankishiatake ova itantakotakero. Impo yovetsikashitakero agaatantakenkanirira oani. Imatakero aikiro impirinitantakemparira enoku sentakeronerira kameti ineventakotasanotakemparoniri ganiri okoshitagani. Impo ikaemaigake pashini intsamaitakoigakenerira. Antari ontimanakerika impagarantaigaeri irirori. Impo iavagetake samani. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Impogini aganaara irakantarira ova itigankaigavetakari iromperaneegi ineviigaaterimera impagarantaigaerira irirori, ");
INSERT INTO mcbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kantankicha yogari tsamaitakoigakerorira onti ikisaigavakeri. Paniro onti ipasapasaigavakeri, yogari irapitene onti yogaigavakeri. Yogari yomavatakarira onti ipitankasenaigavakeri mapuku. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Impogini yogari shintarorira ova itigankaigavetaa pashini tovaini iromperaneegi yavisaigakeri iketyorira itigankaigavetaka, kantankicha yogari tavageigatsirira ario ikañotagaigaari iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Impogini ikantake: ‘Impa irirorakari nontigankake notomi, iriro pinkante impinkatsaigakerityo’, ovashi itigankakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kantankicha iriroegi irorotyo ineaigavakerira ikenapaakera iniavakagaigamatanakatyo ikantaiganakera: ‘Neri yonta shintakemparonerira magatiro impogini inkamanaera iriri. Tsamekario agaigakerira kameti aroeginiri shintasanoigakemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Impo iroro yogonketapaakara yagaigamatanakerityo yamaiganakerira antakona aikyara otantakotakara ova ario kara yogaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Antari impigaera shintasanotarorira ova ¿tyarika inkantaigakeri yogaegi tavageigatsirira? ¿Tyara pinkantaige viroegi?” ");
INSERT INTO mcbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iriroegi ikantaigiri: —Irogaigakerityo impogereaigakerira maganiro, gara itsarogakagumaigari. Impogini inkaemaigake pashini impugakagaigaerira. Impo ontimanaerika ova iriroegiri pinkante impagarantaigaeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ikantaigiri Jeso: —¿Matsi tera piniavantaigero Itsirinkakagantakerira Tasorintsi? Ariotari okantakeri maika: ‘Ogari mapu terira irishineventaigavetemparo vetsikaigakerorira pankotsi onti opegakagunkani okusotantakarira. Irirotari kañotagakero maika Atinkami, impo aneaigakerora aroegi ashinevageigaka.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Irorotari nokantantaigakempirira ganige pineaigai impegaempara Tasorintsi Pigoveenkariegite, pashinikya inkaemaigake kematsatasanoigakerineririra, iriroegi pinkante pegaigakerine Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nantitari mapu okusotantakarira pankotsi. Tyanirika kantankitsine tera iriro tigankenane Tasorintsi tyampatyo inkantakempa irogavisaakotakenkanira. Inkantakanirika inkañotake maika nonkisashitasanotakempari impogini inkisashiigakemparira Tasorintsi maganiro terira inkematsaigeri garatyo yogavisaakotumatagani. ");
INSERT INTO mcbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iroro ikemaigavakerira itinkamiegi saseroroteegi intiegiri pariseoegi yogoigake inti ikantakoigake, ");
INSERT INTO mcbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ovashi ikisaiganaka ikogaigavetakara iragakagantaigakerimera, kantankicha ipinkaigairi itovaireegi, iriroegi ineaigakeritari Jeso inti kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Impogini Jeso yogotagaiganairi aikiro ikantakogetakerora posante ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Maikari maika nonkamantaigakempi tyara ikanta Tasorintsi ikaemaigirira matsigenkaegi intimimoigakerira impogini irapatoitaigakerira maganiro kematsaigiririra impegakempara Igoveenkariegite. Onti ikañotakari koveenkari yonkotagantake posantepage sekatsi inkaemaigakerira itovaireegi isekatagaigakemparira intentaigakemparira itomi iragakera itsinanetsite. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Impo itigankaigakeri iromperaneegi inkantaigakiterira pokaigankitsinerira, kantankicha iriroegi tera inkogaige iripokaigera. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Impo itigankutaatyo pashini ikantaigavakeri: ‘Maika pinkantaigakiterira nokaemaigakerira mataka posatake sekatsi. Novetisakagantakeri novakane intiri ityomiani keitavagetankitsirira. Maika mataka vetsikagetaka magatiro. Kantaigakiteri iripokaigakera shintsi isekatakoigakitenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kantankicha yogari ikaemaigakerira teratyo inkogaige iriaigera. Paniro iatai itsamaireku, pashinikya iatai impimantavagetaera iaraki. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Impo yogari itovaire yagaigavakeri iromperaneegi koveenkari ipasapasaigavakeri yogaigavakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ikisamatanakatyo koveenkari itigankaigakeri isoraroegite irogaigakiterira gantaigankitsirira ovashi impoigutero ivankoegi irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Impogini ikantaigiri iromperaneegi: ‘Mataka vetsikagevetaka magatiro kameti iragakeniri notomi itsinanetsite, kantankicha iriroegi nokaemaigavetakarira tera inkametiige, teranika inkogaige iripokaigera, onti ipugatsaigakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Maikari maika ariokya piaigake avotsipageku pinkaemaiguterira maganiro tyanirika pineaigake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ovashi iaigake yapatoitaigakeri kametiigatsirira intiegiri terira inkametiige. Iriroegi ipokaigake ikiaigapaake ishatekaitaiganaka pankotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Impogini ikiapaake koveenkari inkamosoiguterira ikaemaigakerira. Ishonkavetanaka ineitarityo paniro terira irogagutempa kitsagarintsi kañorira yogaguigakarira itovaireegi ipaigunkanirira kameti intentaigakempariniri ikyaenkarira gankitsine itsinanetsite. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ikantiri: ‘¿Tyara pikantaka viro pikiakera kogapage tera pogagutempa kitsagarintsi pinkañoigakemparira pitovaireegi?’ Kantankicha irirori ikemisantaketyo. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Impo ishonkashiigari iromperaneegi ikantaigiri: ‘Gusoigeri itasagiiku ontiri irakoku maiganakeri okaigakiteri sotsi pavatsaariku intentaigakemparira kaemavaitaigatsirira tsikagisevageigatsirira irai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Itovaigavetakatyo ikaemaigunkanirira intimimoigakerira Tasorintsi impogini, kantankicha teratyo intovaige ikogakagaigunkanirira iriaigakera.” ");
INSERT INTO mcbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Impogini yogari pariseoegi iaigake ikemavakagaigakara iripokashiigakerira Jeso inkogakotagantaigakiterira ineaigakera tyarika inkante, ikogaigaketari inkemaigakerira inkantakera tatarika oita terira onkatinkatero ikantaigirira iriroegi kameti intsavetantaigakeriniri inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Impogini iriroegi itigankagarantaigakeri irogamereegi intiegiri tentaigaririra Erorishi iriaigakera inkogakotagantaigakiterira. Impo yogonkeigapaakara ikantaigiri: —Gotagantatsirira, nogoigake viro tera pamatagumatempa. Antari pogotagantavagetira katinka pogakero pikamantaigakerira maganiro tyara inkantaigakempa inkematsatasanoigakerira Tasorintsi. Tera tyani pagamaempa, aikiro tera pimpinkumateri matsigenka, pineaigakeritari maganiro ario ikañovakagaigaka. Viro pogotirotari ikantirira koveenkari Sesa ikantira: ‘Maganirosanotyo jorioegi impaigakena koriki.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maika ¿tyara pinkante viro? ¿Kametitake nompaigakerira ontirika tera onkametite? ¿Ario nompaigakeri ontirika gara nopaigiri? ");
INSERT INTO mcbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kantankicha Jeso yogotavaketyo tera kametikya inkantaigeri onti ishinetamampegaigakari kogapage, nerotyo ikantaigutarityo: —Viroegi ontityo pishinetamampegaigakena kogapage. ¿Tyara okantakara pikañovintsaigakenara maika? ");
INSERT INTO mcbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Atsi maigakenanityo pamentaniro koriki ipaganirira Sesa noneakerira. Iriroegi yamaigakeneri, ");
INSERT INTO mcbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","impo yagatakera ineagetakerira ikantaigiri: —¿Tyani yoka itsirinkakotunkanirira? ¿Tyani shintaro ivairo? ");
INSERT INTO mcbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ikantaigiri: —Inti koveenkari Sesa. Ikantaigutarityo: —Iroroventi intitari tsirinkakotankicha Sesa paigerityo irirori kameti pintsatagaigakeroniri magatiro ikantagetakerira, kantankicha ariotyo pinkañotagaigakempari Tasorintsi aikiro pinkematsatasanoigakerira pintsatagaigakerora magatiro ikantagetakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikemaigavakerira ikantaigakerira maika oga ikenaigake yogavageiganake kavako ovashi iaiganai. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Impo choeni osamanitanake irirokya aiganankitsi saroseoegi inkamosoiguterira Jeso. Iriroegi inti kantaigatsirira gara yaniaiganai igamaga. Ikantaigapaakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Gotagantatsirira, yogari Moiseshi itsirinkanake pairani ikanti: ‘Intimakerika matsigenka terira intomintempa impo inkamanakerika iokanakero itsinanetsite, aiñorika irirenti irirokya gaerone intomintagaemparoniri kañomataka irironirikatyo tomintari kamankitsirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Maika nokogaigavetaka nonkantaigakempira. Pairani itimake paniro notovaire itomintaka 7. Yogari itsitiki yagavetaka tsinane, kantankicha niganki ikamanake tera intomintaganakemparo. Impo irirokya gavetaaro irapitene giatiririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ario ikañotaka irirori ikamanake tera intomintaganakemparo. Ario ikañovetaka irapitene nigankinirira. Ariompa ipogereanakari maganiro yagaigavetakarora tera intomintagaiganakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Impo okamamatityo irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Maika atsi kantaigena, antari impogini iraniaiganaerika maganiro igamaga, ¿tyanirikatyo gasanotaerone?, maganirotari yagaigavetakaro. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Irirori ikantaigiri: —Viroegi onti pikomuigakaro, teranika pogoigero tyara okanti Itsirinkakagantakerira Tasorintsi, aikiro tera pogoige tyara ikanta yagaveavagetira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Impogini iraniaiganaerika maganiro igamaga gatanika tyani gumataatsi tsinane, aikiro tsinane garatyo opimantumataagani iragaigakerora surari, ontitari inkañoiganakempari isaankariite Tasorintsi timaigatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Maika viroegi onti pikantaigake gara yaniaiganai igamagapage. ¿Matsi tera piniavantaigero ikantakerira Tasorintsi pairani?, ikantaketari: ");
INSERT INTO mcbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nanti Tasorintsisanorira Itinkami Averan, Isaako intiri aikiro Jakovo.’ ¿Matsi iriro Tasorintsi Itinkami igamaga? Teratyo iriro, intitari Itinkami niaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iroro ikemaigavakerira maganiro ikantaigakerira maika yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Impogini yogari pariseoegi ikemakoigakerira Jeso yogemisantaigakerira saroseoegi iatashiigakeri iriroegi aikiro ");
INSERT INTO mcbNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","itentaiganakarira paniro gotagantirorira itsirinkakotanakerira Moiseshi inkogakotagantapaakerira ineaigakerira tyarikara inkante kameti ontimakeniri onkenantakemparira inkisakagantaigakerira. Impo ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Gotagantatsirira, pogotitari itsirinkakotanakero Moiseshi pairani magatiro ikantagetirira Tasorintsi. Maika nokogavetaka pinkamantaigakenara tyati pairo avisake okametitakera ontsatagasanotakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yogari Jeso ikantiri: —‘Pintasanovagetanakemparityo Pitinkami Tasorintsi pisuretasanotanakemparira, aikiro pimpanirotasanotanakerira irirori.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Pairo avisake okametitakera ontsatagasanotakenkanira oka, avisagetakero magatiro ikantagetakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ogari apitene onti kantatsirira: ‘Pintsarogakagavagetakemparira pitovaire pinkañotagasanotakempatyo pitsarogakagara vikiiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yogari tsatagasanotakeronerira oka mataka itsatagagetakero magatiro itsirinkakogetanakerira Moiseshi, ontiri aikiro magatiro yogotagantaigirira kamantantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aiñokyara inaigake pariseoegi ");
INSERT INTO mcbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","yogari Jeso ikantaigiri: —¿Tyara pikantaigi viroegi? ¿Tyani yashikitanakeri Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite? Iriroegi ikantaigiri: —Inti yashikitanakeri Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yogari Jeso ikantaigiri: —Iroroventi ¿tyara okantakara pairani iniakagakerira Isure Tasorintsi Iravi ipegakerira Itinkami?, ikantaketari maika: ");
INSERT INTO mcbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yogari Tasorintsi ikantakeri Notinkami: Pirinite nonampinaku nakosanoriraku pintentakenara kigonkero nagaveaigakerira maganiro kisashiigakempirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Irorotari ikantakerira: ‘Notinkami’, ¿tyara inkantakempara iyashikitakerira? ");
INSERT INTO mcbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Impogini tera intimumate paniro gaveankitsinerira irogipigakenerira nerotyo ovashi teratyo tyani kogakotumataerine. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Impogini Jeso iniaigakeri patoitaigankicharira intiegiri irogamereegi ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yogari gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi ineaigake paniro iriroegi yagaveaigiro yogotagantaigirora itsirinkakotanakerira Moiseshi. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nonkantaigakempi nanityo kematsaigerityo pintsatagaigakerora magatiro yogotagaigakempirira, kantankicha gara pikañoigari iriroegi. Ontitari yogotagantaigavetakaro kogapage, kantankicha tera intsatagasanoigero. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Onti yovashigakovageigakari matsigenkaegi yogotagaigakerira posante ikantaigakeri intsatagaigakerorika magatiro ario pinkante irishineventaigakempari Tasorintsi, kantankicha iriroegi tera intsatagumaigero. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ontityo ineakagantavintsaigakara, nerotyo antari yamatsaitakoigarora itsirinkakotanakerira Moiseshi yovashigageigamatarotyo yamatsaitakotantaigakarorira ariosarantapagerikatyo kara. Ario ikañotagaigakaro aikiro yomaretakoigarora irakoegiku. Antari iniaigirira Tasorintsi onti yogaguigaka imanchaki timankitsirira oshiroki ogatsantsapageni. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Antari ikaemaigaganira isekataigakempara tyarika kara yapatovageigara onti ikogaigi iroviriniigakenkanira intentagantaigakenkanira kaemantankitsirira. Ario okañotaka aikiro iaigira pankotsiku yapatoitantaigarira ikogaigi iroviriniigakenkanira ipiriniigira tinkamiigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aikiro iaigira opimantagetaganira arakintsipage ontiri ogagetaganirira ikogaigake iriniaigavakenkanira inkañotagaigakenkanira iniaganira itinkamipage ontiri aikiro inkantaigakenkanira gotagantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kantankicha viroegi gara pikogaigi inkantaitakempira gotagantatsirira, aiñotari paniro Gotagaigimpirira, narotari. Maganiro viroegi ario pikañovakagaigaka. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Akari aka kipatsiku gara itimumaigi pikantaigirira: ‘Apa’, aiñotari paniro Piri timatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aikiro gara pikogumaigi impegaitakempira itinkamiegi, aiñotari paniro Pitinkami, narotari. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yogari visavageigakeririra itovaireegi inti yoga tyanirika mutakotantavagetatsirira tsikyatatyo irirori ikañotagaka nampiriantsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Imirinkatari ventakovagetacharira impotetashivagetakempari Tasorintsi irogipashiventavagetakerira. Irirokya terira iraventakotempa irishineventakempari inkavintsaavagetakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi vintiegiri pariseoegi kametitamampegaigacharira! Tera pinkogaigenika pinkematsaigakerira Tasorintsi kameti pintimimoigakeriniri impogini irapatoitaigakerira maganiro kematsaigiririra impegakempara Igoveenkariegite, aikiro antari pogotagaigakerira kogaigavetankicharira inkematsaiganakerira ontityo povashigakovageigakari pikantaigakerira intsatagageigakerora posante nerotyo tyampa inkantaigakempa inkematsaigakera iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi kametitamampegaigacharira! Ontitari pamatavinaigakero ogamakotagapage pitsonkatapitsageiganakerora ashintageigarira. Aikiro pineakagantaigakara akaenkinityo piniaiganakeri Tasorintsi teratyo aiñokya pagataige. Nokantantaigakempirira viroegi pairo pavisaigake inkisashivageigakempira impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi kametitamampegaigacharira! Viroegi papagiteavageiganakaro kipatsi ontiri omaraani nia pinkematsatagaigakerira paniro matsigenka inkañoiganakempira viroegi. Antari ikematsaigakempira pairotyo yogagavagetanaka ikañovagetakara yavisavageiganakempityo viroegi. Irorotari iriatantakemparira morekariku intagakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Maikaniroro pantsipereavageigake viroegi, pogotagantaigavetakatari kantankicha teratyo pogotumaige! Onti pikantaigake: ‘Tatarika oita pinkantaigake irororika piniakoigake ivanko Tasorintsi pinkantaigakera: Nontsoegakemparika okyarikatyo tuanankitsi ivanko Tasorintsi, impo garika pitsatagiro pikantakerira kametitaketyo. Kantankicha irirorika piniakoigake kori nankitsirira ivankoku Tasorintsi ario pinkante pintsatagakeronirorotyo. Garatyo pikantatigumatiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Teratyo pogotumaige viroegi! ¿Matsi tyatimpatyora pairo avisake okoveenkatakera, irororikara ivanko Tasorintsi intirika kori nantakarorira? Gamera iroro ivanko gametyo ikametiti kori. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Impo pikantaigake aikiro: ‘Tatarika oita pinkantaigake irororika piniakoigake itagantaganirira piratsipage yamaganirira Tasorintsi pinkantaigakera: Nontsoegakemparika asatyo ompegakempa, impo garika pitsatagiro pikantakerira kametitaketyo. Kantankicha irirorika piniakoigake piratsi vanketankicharira itagantaganiriraku, ario pinkante pintsatagakeronirorotyo. Garatyo pikantatigumatiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Teratyo pogotumaige! ¿Matsi tyatimpatyora visankitsi ikoveenkatakera, irirorikara piratsi ontirika itagantaganirira? Gamera iroro itagantaganirira gametyo ikametiti irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yogari niakotirorira itagantaganirira piratsi yamaganirira Tasorintsi teranika patiro iriniakote irorori, iniakotakerityo aikiro piratsi vanketankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ario ikañotaka yoga niakotirorira ivanko Tasorintsi teratyo intagati iroro iriniakote ivanko, iniakotakerityo irirori aikiro Tasorintsi shintarorira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ario okañotaka aikiro tyanirika niakotiro inkite intityo iniakotake Tasorintsi Igoveenkariegite maganiro, irirotari shintaro. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi vintiegiri pariseoegi kametitamampegaigacharira! Tatarika oita pashintumaiga ontirika mentashi, anishi ontirika komino pipagarantaigiri Tasorintsi, kantankicha pimagisantavageigakero pairorira avisake yogotagaigakempirira ikantakera pintsatagageigakerora magatiro ikantagetirira, aikiro pintsarogakagaigakemparira pitovaire negintekyara pogaigakeri. Kametitaketyo pipagarantaigakerira Tasorintsi pashintageigarira, kantankicha gametyo pimagisantaigiro otovaire ikantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Pogotagantaigavetakaro Iriniane Tasorintsi, kantankicha teratyo pogotumaigero viroegi! Onti pogotagantavintsaigake intsatagaigakerora tesakonarira inkogero Tasorintsi, irorokya ikogasanotirira tera pogotagantaigero. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi kametitamampegaigacharira! Pikogaigaketari ineaigakempira maganiro arisano pikematsatasanoigakeri Tasorintsi, kantankicha intagati pipiriniventavageigi pamatavinaigakerira matsigenkaegi pagutageigakerira yashintageigarira. Kañomataka intagatira okivagani pamoko ontiri perato otishitaku antari oteniku pairatamatake potsitasematake. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Viroegi pariseoegi teratyo pogotumaige! Atsi negintetasanoigempanityo pisureku kameti ineasanoitakempiniri negintetasanoigamatakavi. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi vintiegiri pariseoegi kametitamampegaigacharira! Ontitari pikañoigakaro ikitatantaganirira igamaga. Onti otiritantunkani kutari kameti oneakenkaniniri onkametivagete, kantankicha antari tsompogi pairatamatake inti shatekankicha itonki kamatsirini yovesegakara. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ariotari pikañoigakari viroegi onti pikametitamampegaigaka kogapage pineakagantaigakara kameti ineaigakempiniri matsigenkaegi, kantankicha antari pisureku tera pinegintevageigempa onti pisuregisevageigaka terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi kametitamampegaigacharira! Ontitari povetsikashiigakeneri isuretakotantaigaenkanirira kamantantaigatsirira kamaigankitsirira pairani, aikiro pineginteigakeneri ikitatantaigarira negintetasanoigacharira kameti isuretakoigaenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Impogini pikantaigi: ‘Ariome nontimaigeme pairani itimaigira yashikiiganakenarira gametyo notentaigari yogaigakerira kamantantaigatsirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Antari pikañoigakerora maika vikiirotyo kañotagantaigankicha, pikantaigaketari vintiegi iyashikiiganakerira gaigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Maikari maika atanatsira pinkañoigakempari yashikiiganakempirira pairani! ");
INSERT INTO mcbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Vintiegi vetsikageigirorira posantepage terira onkametite! Maikari maika ¿tyanimpatyo gavisaakoigakempine ganiri pitagaiga morekariku? ");
INSERT INTO mcbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Irorotari nontigankimotantaigakempirira kamantantaigatsirira pairorira yogovageigi intiegiri gotagantaigatsirira, kantankicha impogini pogagarantaigavakeri pinkentakotagarantaigavakerira, pashinikya pimpasapasaigavakeri pankotsiku papatoitantapiniigarira, pinkisashivageiganakemparityo pimpatimavageiganakeri itimageigira. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Viroegitari kañotagantaigakeri yogantaigunkanirira kematsaigiririra Tasorintsi pairani, iketyo yogiivatunkani Averi terira inkañovagetempa ikarataganunkani Sakariashi itomi Verekiashi. Yogari Sakariashi onti yogunkani anta ivankoku Tasorintsi inavetakara aikyara itagantaganirira piratsipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Arisanotyo nonkantasanoigakempi maikaniroro inkisashiigempi Tasorintsi, vintiegitari gakagantaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerosarenkunirira, Jerosarenkunirira, pogaigirira kamantantaigatsirira, aikiro pipitankaigirira itigankimoigakempirira Tasorintsi inkenkitsatimoigakempirora Iriniane! Pineaigiro atava osavogaigirira otyomiani, nokoganagevetakatyo naro nonkañotagaigakempimera maganiro viroegi nampatoitaigakempimera pinkematsaigakenara, kantankicha viroegi teratyo pinkogumaige. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Maikari maika ganigetyo inimoigaimpi Tasorintsi panivani pampuntavageigaempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nonkantaigakempi maika gara pineaigaana kigonkero aganakempara pinkantaigavakenara: ‘¡Pairo ikametiti yoga itigankakerira Tasorintsi impegakempara Agoveenkariegite!’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iroro ikontetanaira Jeso ivankoku Tasorintsi iriatanaera parikoti yaiñoniiganakari irogamereegi ikantaigakerira: —Gotagantatsirira, atsi geroratyo kavako oga ivanko Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kantankicha yogari Jeso ikantaigiri: —¿Pineaigakero magatiro oka? Arisano nonkantaigakempi impogini gara otimumatai patiro mapu vikotaachanerira, magatirosanotyo ogashiriagetakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Impogini itonkoaiganake iaiganakera otishiku Orivoshi, ario ipirinitake Jeso kara. Impo yogari irogamereegi yaiñoniigapaakari ikantaigapaakeri: —Nokogaigake pinkamantaigakenara tyatirikara agantakempa ontsonkatantanaemparira inkaaratirira pikantakerira ogashiriagetakenkanira. ¿Tyatirikara nogotantaigavakempa pimpigantaemparira impogini ontsonkagetanaempara magatiro kipatsi? ");
INSERT INTO mcbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yogari Jeso ikantaigiri: —Tsikyanira yamatavinaitimpikari, ");
INSERT INTO mcbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","iripokaigaketari tovaini matsigenkaegi kantaigankitsinerira: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite’, impo inkematsaigakeri tovaini. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Impogini pinkemakoigavakeri pashini iromanatavakagaigakempara aiñoni, ontiri aikiro pashinipageku kipatsi, kantankicha viroegi gara pitsarogaigi. Arionirorotyo onkañotanakempari maika, kantankicha gatata aga ontsonkagetanaempara magatiro kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yogari timageigatsirira pashinipageku kipatsi iriatashiigakeri timageigatsirira parikotipageku iromanatavakagaigakempara. Ario inkañoigake koveenkariegi intimagarantaigake intigankaigakeri isoraroegite iriatashiigakerira pashini koveenkari iromanatavakagaigakempara irogavakagaigakempara. Aikiro ontimaenkagetanake tasegagantsi, ontiri aikiro ontininkagematanakempatyo kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Onkañogetanakemparika maika iroro ontsititantanakempa antsipereavagetanakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Impogini iragaiganakempi iramaiganakempira inkisakagantaigakempira irogakagantaigakempira. Maganirosanotyo inkisaviiganakempiro pikematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inkonogagarantaigakempa kematsaigavetanarira irapakuaiganakena ganige ikematsaigaana, onti inkisashivakagaiganakempa, aikiro intsoeventavakagaiganakempa iragakagantavakagaiganakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Inkoneagematanaketyo aikiro matavitantaigatsirira inkantaiganakera: ‘Onti nokenkitsatakoigi Iriniane Tasorintsi’, kantankicha iriroegi onti iramatavinaigakerira tovaini kematsaiganarira irapakuakagageiganakerira ganige ikematsaigaana. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Omposantegisevagetanakempatyo kara terira onkametite, ganige itavakagaigaa matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kantankicha yogari atanatsirira inkematsatasanotanakena iriro pinkante irogavisaakotakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Inkenkitsatimovageiganakenkanityo kara maganiro matsigenkaegi inkamantaigakenkanira tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi impegakempara Igoveenkariegite. Ario onkañotakempa maika kameti irogoigakeniri maganiro. Impogini ario ontsonkagetanaempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Yogari kamantantatsirira Iraniere pairani itsirinkakotanakerira samatsanatakeronerira ivanko Tasorintsi impogini. Maika viroegi pineaigakeririka ario irinake anta pinkatimaiganakempara pishigaiganakera otishipageku. Ario inkañoigakempa aikiro maganiro timaigatsirira Joreaku irishigaiganake. (Tyanirika niavantakotakerone oka isuretakotakemparo kameti inkemavakeroniri.) ");
INSERT INTO mcbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tyanirika pitankitsine otishitapankoku ivanko irishigapanute garatyo ikiapanaati iragagetapanutera tatapagerika oita. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tyanirika pitankitsine itsamaireku garatyo iatapanaati ivankoku iragapanaatera apitene imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Maikaniroro antsipereavageige tsinaneegi kamonkiigankitsinerira ontiri tsomitagaigankitsinerira, pairotari avisaigake antsipereasanovageigakera oshigaiganakera! ");
INSERT INTO mcbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Viroegi niaventaigempatyo ganiri okatinkatiro pishigaiganakera katsinkagiteriku ontiri aikiro kutagiteriku apishigopireantaganirira, ");
INSERT INTO mcbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","pairotari antsipereavagetakenkani avisavagetakerotyo magatiro atsipereagetunkanirira okyasanokyara yovetsikagetake Tasorintsi kipatsi ovashi maika. Aikiro gara oneimataagani impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kantankicha gasakona otovaigavageti kutagiteri iratsipereavageigakera ganiri ipogereaiga maganiro. Isuretakoigakemparitari Tasorintsi maganiro ikogakagaigakerira pairani okyasanokyara inkematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Impogini tyanirika kantaigakempine: ‘Neri yoka Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite’, garatyo pikematsaigiri. Ario onkañotakempa inkantaigakempirika: ‘Aiño inake anta’, garatyo pikematsaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iripokaigaketari kamantantaigatsirira matagavageigankicharira intiegiri aikiro pashini kantaigankitsinerira: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite.’ Aikiro irovetsikageigamate terira oneimagetenkani kameti iramatavinaiganakeriniri tovaini. Irimaigavetanakemparityo kematsaigiririra Tasorintsi, kantankicha garatyo yagaveimaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nokamantaigakempi magatiro maika tekyara agempa kameti pogoigakeniri ganiri yamatavitumaigimpi impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Inkantaigakempirika: ‘Neri yonta nankitsirira osarigagitetapaakera’, gara piaigi pinkamosoiguterira. Aikiro inkantaigakempirika: ‘Aiño kara tsompogi’, gara pikematsaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pineaigirotari kareti tyara okantaka okantira tsarere tsarere, tera ario maani onkoneagitete, magatirotyo ontenenkagiteapinitakaro. Ario inkañotapaempa Kañotasanotakaririra Matsigenka iripokaera, maganirotyo ineasanoigavakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Antari panikyara ontsonkatanakempa magatiro katsiketyotari iripokapaake inkomutagaigapaakerira kañovageigacharira, kañomataka igamaga tyarika kara inoriaka ineventumatakarira samponero katsiketyo iparigashitapaakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Iroro avisanakera tsipereagantsi ‘irirokya tsivakanankitsine poreatsiri intiri aikiro kashiri. Yogari impokiropage irashiriagetanakempa, ganigetari ikusotai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Impogini oneavakenkani anta inkiteku tyarika onkovoreavagetanake kara ovashi iroro ogotantakenkani panikyasano iripokapae Kañotasanotakaririra Matsigenka. Ogatyo inkenaigake iriragaiganakempa maganiro kipatsikunirira inkaemavaitaiganakera: ‘Inaa, inaa, maikaniroro nonkame.’ Impogini ineavakenkani Kañotasanotakaririra Matsigenka iripokapaakera inkenapaakera menkoriku inkoveenkavagetapaakera, aikiro iragaveavagetapaakera iravisaigakerityo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Impogini ontivotanakenkanira tivorintsi intigankaigakeri isaankariite iriaigakera intsotenkagiteaiganakemparora magatiro kipatsi irapatoitaigakerira irashiegi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Maika kemisantaigena nonkantaigakempira. Pineaigirora igera okyaenkara mechoshiatanaatsi oshi pogoigake panikya aganaempa osariganaera. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ariotyo onkañotakempa impogini pineaigavakerorika onkañotanakempara nokamantaigakempirira maika iroro pogotantaigavakempa panikyasano impigaate Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Arisanotyo nonkantaigakempi magatirotyo oka nokantaigakempirira maika ontsatagagetanakempatyo tekyaenkara pimpogereaigempa viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ogari inkite ontiri kipatsi ontsonkagetanaempa, kantankicha ogari nokantagetakerira garatyo okantatigumata, ontityo ontsatagagetanakempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tera tyani gotumatatsine tyati impigantaatempa Kañotasanotakaririra Matsigenka. Ario ikañotaka irirori tera irogote. Aikiro isaankariite Tasorintsi tera irogoige. Panirotyo ikantakara Tasorintsi irirori yogotakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Antari impigaera onti onkañotakemparo aiñokyara itimaveta Noe pairani ");
INSERT INTO mcbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","tekyaenkara irogivarigero Tasorintsi omarane inkani ampamankagiteanakerora magatiro kipatsi. Maganirosanotyo shinevageigamatakatyo, isekataigakara, yoviikaigakara, yagaigakera tsinane, ipavakagaigakara irishintoegi oimentaigakempara, ovashi aganaka kutagiteri ikiantanakarira Noe tsompogi yomatetakara ivitoku okantaganirira areka. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Impogini okomutagaigapaakeri inkani opogereasanoigakerityo kara. Ariotyo onkañotakempa impogini iripokaatera Kañotasanotakaririra Matsigenka ontityo inkomutagantapaakempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Antari iripokaatera irinaigake piteni matsigenka itsamaireku, paniro iraganakenkani, yogari irapitene iokanakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ario onkañoigake piteni tsinane ompitaigake ontononkavageigakera, paniro aganakenkani, ogari apitene okanakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Irorotari nokantantaigakempirira pinkantakanira pogiaigavaeri Pitinkami, tera pogoigenika tyati impigantaatempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Atsi sureigemparatyo, intimera pashini shintankicharira ivanko irogotemera tyatirikara iripokantakempa koshinti, ¿matsi ario irimagake? ¡Garatyo imagi! Ontityo inkireaventakero iaraki ganiri ikoshitagani. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Irorotari nokantantaigakempirira pinkantakanira pinegintevageigakempa pogiaigavaerira Kañotasanotakaririra Matsigenka impigaatera, gatanika pogoiginika tyati impigantaempa, ontitari katsiketyo inkomutagaigapaempi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Onti pinkañoigakempari nampiriantsi govagetatsirira kematsatasanotiririra shintaririra. Pine intimera shintacharira ironampiriaegi impo iriatakera parikoti inkantanaeri paniro ironampiria ineaigaerira maganiro irapinampiriantsiegitene impaigaeri omirinka isekaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Antari iripokaerika ineapaakeririka itsatagasanotakero ikantanakeririra, ariompatyo irishineventasanotanakempariri inkantanakerira: ‘Maika nokogake pineagetakenarora magatiro nashintagetarira.’ Impo irirori irishinevagetakempatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kantankicha antari intirika terira inkematsatante gara yogiavairi shintaririra onti inkantake: ‘Gatatarorokari ipokai’, ");
INSERT INTO mcbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ovashi intsititanakero inkisakisaiganakerira irapinampiriantsiegitene, aikiro inkonoivageiganakempari shinkisenari onti impiriniventuntetanake isekatavagetakempara, aikiro ishinkivagetakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Impo katsiketyo inkomutagapaakeri shintaririra ");
INSERT INTO mcbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","inkisashivagetapaakemparityo kara intentagantaigakemparira kematsatamampegaigacharira kogapage iokakerira parikoti inkaemavavagetake iratsikagisevagetakerora irai. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Maika nonkantakotakero tyara onkantanakempa impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite, onti nonkañotagakemparo 10 tsinaneegi okyaenkarira antaroiganankitsi. Iroroegi amakoiganake omecheroegite oaiganakera ontonkivoaigavakemparira gankitsinerira tsinane. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Onaigake 5 terira osuretasanovageigempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Iroroegi amaigavetanaka omecheroegite, kantankicha tera amakoiganake aseite ompiajaigavaera paita intsoatanakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ogari otovaireegi iroro pinkante amakoiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Impo tekyatanika aiñokya iripoke gankitsinerira tsinane opochokiigamatanaketyo ovashi omagaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Impo onigankigitetanakera okemaigutatyo okaemunkanira: ‘¡Pokapaake gankitsinerira tsinane! ¡Piaigekario pintonkivoaigavakemparira!’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ogatyo okenaigake otinajaiganaka maganiro onoshikakoiganakera omecheroegite. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ogari terira amakoige oaseitete okantaigiro shintakoigankicharira: ‘Pajaigenakario maani piaseitete panikya nontsivakakoiganake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kantankicha iroroegi okantaigiro: ‘Garorokari nopajaigimpi. Antari nompajaigavetempi onti nontsoatakoiganakempa shintsi maganiro. Piaigetyo pimpunaventaigakitera pashini.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kantankicha iroro oaigavetanakara ompunaventaigemera mataka gonketapaaka gankitsinerira tsinane. Ogari makoigankitsirira oaseitete okiaiganake tsompogi otentaigakarira, oga okenake ashitanunkani shitakomentontsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Impo opokaigavetapaaka otovaire oneaigapaakero shitaka okaemaigapaake okantaigi: ‘¡Shireakoigenakario!’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kantankicha irirori ikantaigavakero: ‘¿Matsi noneaigimpiratyo kameti nashireakoigakempiniri?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Irorotari maika nonkantantaigakempirira pinkantakanira pinegintevageigakempa, tera pogoigenika tyatirikara impigantaatempa Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maika nonkantakotaero tyara onkantanakempa impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite, onti nonkañotagakemparo matsigenka shintavagetacharira koriki. Panikyara iriatake pashiniku kipatsi ikaemakagantaiganakeri maganiro iromperaneegi ipaiganairi koriki irogitovaigaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yogari gotasanotankitsirira ipanakeri 5,000 korikimenta. Yogari irapitene intagani ipanakeri 2,000. Yogari yomavatakarira intagani ipanakeri 1,000. Impo iavagetake samani. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yogari ipanakerira 5,000 yagantaari pashini 5,000. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ario ikañotakari irapitene ipanakerira 2,000 yagantaari pashini 2,000. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kantankicha yogari ipanakerira 1,000 iatake ikigantashitakeri kipatsiku ikitatakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Impogini yavisavagetanakera tovaini kashiri ipigaa shintaigaririra ikantaigapaakeri: ‘Tsame aneaigakerira koriki akarikara pagaigake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yogari ipanakerira 5,000 yamakeneri pashini 5,000 yagantakaririra igorikite ikantiri: ‘Intagani pipanakena 5,000, neri yoga pashini nagantakaririra pigorikite.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yogari shintaririra ikantiri: ‘Kametitake, pitsatagakerotari nokantakempirira. Maikari maika pikematsatakenatari, nokogake pineagetakenarora pashini pairorira avisakeri yoga 5,000. Taina ashinevageigakempara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yogari irapitene ipanakerira 2,000 yamakeneri pashini 2,000 yagantakaririra igorikite ikantiri: ‘Intagani pipanakena 2,000, maika neri yoga pashini 2,000 nagantakaririra pigorikite.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yogari shintaririra ikantiri: ‘Kametitake, pitsatagakerotari nokantakempirira. Maikari maika pikematsatakenatari, nokogake pineagetakenarora pashini pairorira avisakeri yoga 2,000. Taina ashinevageigakempara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kantankicha yogari yomavatakarira ipanakerira 1,000 ikantiri shintaririra: ‘Noneimpitari vinti terira pintsarogakagantavagetempa, aikiro vinti pairorira patsipereakagantavageta pantavagetagantira pagakera tovaini koriki. Aikiro onti pagantakari koriki kogapage tera pantavagetumate. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Irorotari nopinkantakempirira noatantakarira nokitatutirira pigorikite. Maika neri yoga pipanakenarira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Yogari shintaririra igorikite ikantiri: ‘Virori vinti terira pinkametite, vinti peranti, iroroventira pogotaketari natsipereakagantavagetakera nantavagetagantira kogapage nagakera nogorikite, aikiro nagantarira koriki kogapage tera nantavagetumate, ¿tyara okantakara tera pimperi nogorikite pinatantavagetatsirira pagantaemparimera pashini, impo nopokavetaara maika pimpavaenarime?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ishonkashiigari naigankitsirira kara ikantaigiri: ‘Gapitsaigeri yoga 1,000 korikimenta nopavetakaririra pimpaigakerira gankitsirira 5,000. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pairotari impasanotakenkani tyanirika shintasanotankicharira, kantankicha yogari terira irashintavagetempa irogapuntarenkapitsatakenkanityo yashintagevetakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Maika yokari yoka nomperane terira inkematsatante maiganakeri pokaigakiterira sotsi pavatsaariku intentaigakemparira kaemavaitaigatsirira tsikagisevageigatsirira irai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Maika nonkantaigakempi impogini impigaera Kañotasanotakaririra Matsigenka inkoveenkavagetapaaketyo intentaigapaakemparira isaankariite impegakempara Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Irapatoventavageigapaakemparityo maganiro matsigenkaegi. Irirori irashirikoigavakeri inkañotagaigakemparira sentaigiririra ovisha yashirikoigirira irovishate ganiri ikonoitari igaverate. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yogaegiri kematsaigiririra irogaigavakeri irakosanoriraku. Yogaegiri terira inkematsaigeri irogaigavakeri irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Impogini inkantaigakeri naigankitsirira irakosanoriraku: ‘Tainaegi viroegi ikavintsajaigakerira Apa pashintaigakemparora magatiro yovetsikaigakempirira. Pairani okyasanokyara yovetsikagetake kipatsi viroegitari isariaigaka inkavintsajaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Natsipereavagetira notasegane viroegi pipaigakena nosekatakara. Nomirevagetira pipaigakena noviikakara. Tyarikara nanuivagetake pikaemaigakena pivankoku nomagimoigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Notsonkasetakovagetara viroegi pipatsaraigakena nogagutaara. Nomantsigavagetira viroegi pitsarogakagaigakena pipokaigake pikamosoigutanara. Aikiro yashitakoitanara pipokaigake pikamosoigutanara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Impo yogari kematsaigatsirira inkantaigakeri: ‘Notinkami, ¿tyara noneaigakempira kara pitasegakera nopaigakempi piseka? ¿Tyara kara noneaigakempira pimiretakera nopaigakempi pimire? ");
INSERT INTO mcbNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tyara kara noneaigakempira panuivagetakera nokaemaigakempi pimagimoigakenara? ¿Tyara kara noneaigakempira pitsonkasetakovagetanakara nopatsaraigakempi pogagutaara? ");
INSERT INTO mcbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tyara kara noneaigakempira pimantsigatakera, aikiro yashitakoitakempira noaigake nokamosoigutimpira?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kantankicha irirori inkantaigeri: ‘Arisanotyo nonkantaigakempi antari pitsarogakagumaigakarira paniro yoga kematsatanarira terira impaitumatempa, kañomataka nantinirikatyo pitsarogakagaigaka.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Impo inkantaigakeri yogaigavakerira irampateku: ‘Maika piaige viroegi parikoti anta morekariku garira otsivakumati yovetsikashitunkanirira kamagarini intiegiri itovaireegi, ikisashiigakempitari Apa. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Natsipereavagetira notasegane tera pimpaigena nosekatakempara. Nomirevagetira tera pimpaigena noviikakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nanuivagetira tera pinkaemaigena pivankoku nomagimoigakempira. Notsonkasetakovagetara tera pimpatsaraigena nogagutaempara. Nomantsigavagetira ontiri aikiro yashitakoitanara tera pintsarogakagumaigena pimpokaigakera pinkamosoigutenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iriroegi inkantaigeri: ‘Notinkami, ¿tyara kara noneaigakempira pitasegakera, panuivagetakera, pimiretakera, pitsonkasetakovagetakara, pimantsigatakera, aikiro yashitakoitakempira tera nontsarogakagaigempi?’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Irirori inkantaigeri: ‘Arisanotyo nonkantaigakempi, terika pintsarogakagaigempari yogaegi ikantaganirira tera impaitumaigempa, kañomataka nantinirikatyo pikisaigake tera pintsarogakagumaigena.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Maganiro yogaegi iriaigake inkantakanira intagaigakempa morekariku. Kantankicha yogari kematsaigakeririra Apa onti iriaigake enoku, inkantakani intimaigake gara ineimaigairo igamane.” ");
INSERT INTO mcbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yagatakera Jeso yogotagaigakerira irogamereegi ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Viroegi pogoigaketari pitenivati kutagiteri agantakemparira Pasekoa. Iroro iragakagantantakenkani Kañotasanotakaririra Matsigenka inkentakotagantakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Impo yapatoitaigaka ivampatuireku Kaipashi maganiro itinkamiegi saseroroteegi, gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri itinkamiegi jorioegi. Yogari Kaipashi inti itinkamisanorira saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ario kara ikemavakagaigaka iramatavinaigakerira Jeso iragakagantaigakerira irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kantankicha ikantaigake: —Antari avisanakera Pasekoa ario agakagantaigakeri. Maikari maika gatata agakagantaigiri ganiri ikisakoiganakari maganiro patoventaiganakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Impogini iatanake Jeso Vetaniaku inkamosoterira Sumo ikantaganirira Vesegavetankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Antari inakera ivankoku opokashitakeri tsinane amakotapaake kasankaari punatasanotacharira. Ogari opiaatantakarira onti ovetsikantunkani aravasetero, shatekaamatakatyo kara. Ipitaigakera Jeso isekatavageigakara irorori aiñonitapaakari otintsanorenkakotakero osagutantakarira igitoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yogari irogamereegi iroro ineaigavakerora ogatyo ikenaigake ikisaiganaka iniavakagaiganakara ikantaigi: —¿Antari gara aparaatagantiri? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¡Matsi tera ogote opunavagetaratyo tovai kara! Ariometyo ompimantakenkanime agantakenkanira koriki impaigakenkanira kogakovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kantankicha Jeso irorotyo ikemaigavakerira ikantaigutarityo: —Atsi arionenityo, gara pikisaigiro, pairotari okametitake okañotakenara maika osagutakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yogari kogakovageigacharira kantakatari pintentaigaemparira, kantankicha narori gatanika pikantakani pitentaigana. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ogari oga tsinane ontitari osaguvitakena kasankaari inkitaitaenara impogini nonkamakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Maika nonkamantasanoigakempi tyarika kara inkenkitsatakotakenkani Tasorintsi tyara ikanta yogavisaakotantira ario onkañotagakenkani oga tsinane onkenkitsatakotaenkani tyara okantakena osagutakenara kameti osuretakotaenkaniniri irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Impo yogari irogamere Jeso paitacharira Jorashi Ishikariote iatake ikamosoigutirira itinkamiegi saseroroteegi ");
INSERT INTO mcbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ikantaigapaakeri: —¿Aka tovaini koriki pimpunaigakena nagakagantaigakempirira Jeso? Iriroegi ipaigakeri koriki 30 imenta. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Impo iatai ovashi isuretanaka tyarikatyo inkantakeri iragakagantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Impo aganakara vieseta ogantaganirira pan terira onkonogempa opoegantarira yogari irogamereegi Jeso yaiñoniiganakari ikantaigiri: —¿Tyara kara pikogake novetsikaigakerora magatiro kameti asekataigakempara paita? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Irirori ikantaigiri: —Piaige Jerosarenku ivankoku pashini matsigenka pinkantaigapaakeri: ‘Yogari Gotagantatsirira ikanti: Ataketari omonkaratapaaka nopokashitakerira, irorotari nokogantakarira nosekatagavageiganakemparira nogamereegi pivankoku nosuretakoigaemparora Pasekoa.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ovashi iaigake yovetsikaigakerora magatiro itsatagageigakerora ikantaigavakeririra Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Impo ochapinienkatanakera yogari Jeso itentaigakari irogamereegi ipitaigakera mesaku ");
INSERT INTO mcbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","isekatavageigakara. Impo ikantaigiri: —Maika nonkamantasanoigakempi, paniro viroegi pagakagantakena paita. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yogari irogamereegi ogatyo ikenaigake ikenkisureaiganaka ikantaiganakera paniropage: —Notinkami, ¿naro gakagantakempine? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ikanti Jeso: —Inti gakagantakenane tsiantakotakenarira maika peratoku. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ontitari ontsataganakempara okantakerira Itsirinkakagantakerira Tasorintsi iniakotakerira Kañotasanotakaririra Matsigenka, kantankicha ¡maikaniroro iratsipereavagetake yoga gakagantakerinerira! Gamerakari itimi okyara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iniamatanaketyo Jorashi gakagantakerineririra ikanti: —Gotagantatsirira, ¿naro gakagantakempine? Ikantiri irirori: —Virotari kantankitsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Impo panikyara iragataiganae isekataigakara inoshikakero Jeso pan yapagotakero iniakeri Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka pan.” Impo ikotagakero ipaigakerira irogamereegi ikantaigiri: —Okari oka pan kañomataka ontinirikatyo novatsa. Nero gaigemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Impo osamanitanakera irorokya inoshikakotake vino, iniairi aikiro Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka vino.” Impo ipakoigakeri irogamereegi ikantaigiri: —Okari oka vino kañomataka ontinirikatyo noriraa. Nero viikaigemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Antari nonkamaventaigakerira maganiro ovoatanake noriraa. Irorotari maika irogavisaakotantaigakenkanirira maganiro kematsaigakenanerira ganiri ikenkiimatairo Tasorintsi ikañovageigara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Maika nonkamantasanoigakempi gara noviikumataaro vino. Antari impogini irapatoitaigakerira Apa maganiro kematsaigiririra impegakempara Igoveenkariegite, ario pinkante nontentaigakempi aviikaigakemparora vino okyaakyarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Impo yagataiganakera imatikaventaigakerira Tasorintsi ikonteiganake itonkoaiganakera iaigakera Orivoshiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Impo ikantaigiri Jeso: —Maika maganiro viroegi pintsarogaiganake paita pokaiganakena piaigakera parikoti. Ariotari okantakeri Itsirinkakagantakerira Tasorintsi okanti: ‘Impogini nogakeri sentiririra ovisha. Yogari ovisha ogatyo inkenaigake irishigaviovageiganake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kantankicha impogini nanianaera naketyo ivaiganakempine noatakera Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Inianake Perero ikantiri: —Intsarogaigavetanakempatyo maganiro iokaigavetanakempityo, kantankicha narori garatyo nokumatimpi. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kantankicha Jeso ikantiri: —Nonkamantasanotakempi, paita tekyara irinie atava pinteratakotakena mavati. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iniitanaatyo Perero ikanti: —Intagarora intentagantaitenara irogaitakenara irogaitenatatyo, kantankicha garatyo noteratakotumatimpi. Ario ikañoigakero maganiro ikantaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Impogini iaigake Jetsemaniku. Iroro yogonkeigapaakara yogari Jeso ikantaigiri irogamereegi: —Pitaigeta aka, narori noateta anta noniakerira Apa. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Intagani itentaiganaka Perero intiegiri itomiegi Severeo. Irirori ikenkisureavagetanakatyo kara yovankinavagetanaka. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Osamanitanakera ikantaigiri: —Nokenkisureavagetanakatyo kara panikya agavagetanakena. Pitaigeta viroegi aka pintentaigakenara pinkireaventaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Irirori iatake antakona anta yompatakasetapaaka inianakerira Iriri ikanti: “Apaa, nokogavetaka pogavisaakotaenara ganiri natsipereavageti, kantankicha impatyora viro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Impo yagatanakera iniakerira iatai inkaaraku inaigakera irogamereegi ineaigapaakeri magasevageigake. Ikantapaakeri Perero: —¿Matsi tera pagaveaigumate samanikonara pinkireaigake? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kireaige gara pimagaigi. Niaventaigempa ganiri pikañovageiga. Viroegi pikogaigavetakaniroro pinkematsatasanoigakerira Tasorintsi, kantankicha tera pishintsitashiigero posante terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Osamanitanaira ipiganaa aikiro iniairi Iriri ikantiri: “Apaa, gatanika pikantatigironika ganiri natsipereavageti, ariotyo onkañotakempa maika ontsatagakempara pikogakerira viro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Impo ipigavetaa ineaigapairi magasevageigaityo aikiro, avisaiganakeritari ivochokine tera ineakoigavakempa imagantaiganaarira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iokaiganairi ipigutanaara aikiro iniairira Iriri, okiiro ikantairi inkaaratirira ikantakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Impo yagatanakera iniairira ipiganaa inaigakera irogamereegi ikantaigapaakeri: —¿Ogaa, magaiganatsivi pishigopireaiganachavi? Gapaaka iragakagantakenkanira Kañotasanotakaririra Matsigenka irogaigakerira kañovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Maikari maika tinajaiganake, tsame, mataka pokapaake gakagantakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tekyara iragate Jeso iniavagetakera ipokapaake Jorashi itentaigapaakari tovaini matsigenkaegi yamashiigapaakeri savuri ontiri inchakii. Intiegi tigankaigakeri itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yogari Jorashi gakagantakerineririra Jeso yogotagaigakeri okyara ikantaigiri: “Agonkeigapaakemparika pineaige tyanirika noatashitake nasaraanatapaakemparira, irirotari pikogaigakerira, pagaiganakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Impo iroro yogonketapaakara inakera irirori ikantapaakeri: —¡Gotagantatsirira!, ¿aiñovi? Impo yasaraanatakari. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yogari Jeso ikantiri: —Jeeje, aiñona. Maika aityotari pipokashitakerira atsi nani kañotero. Impo yogari tentaigakaririra Jorashi yaiñoniigapaakari Jeso inoshikaigapaakeri yairikaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kantankicha aiño paniro itentakarira Jeso inoshikamatanaketyo isavurite iserogempitatutarityo ironampiria itinkamisanorira saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kantankicha Jeso ikantaigiri: —Atsi arionenityo, piataero pisavurite. Tyanirika ventarorira isavurite ontityo irogantakenkani savuri. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Matsi tera pogote narora kogankitsine nonkantakerityo Apa intigankakera isaankariite intovaigavagetaketyo kara impugamentaiganakenara? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kantankicha ariomera nonkañotagakerome maika, ¿ario tyara onkantakempara ontsataganakempara Itsirinkakagantakerira irirori pairani okamantakotakenara nantsipereavagetakera? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Impo ishonkashiigari ikantaigiri itentaigakarira Jorashi: —¿Matsi naro koshinti nerotyo pamashiigakenara savuri ontiri inchakii pagaiganakenara? Omirinkatari kutagiteri notentaigakempi viroegi anta ivankoku Tasorintsi nogotagantavagetakera tera ario pagaigena, ");
INSERT INTO mcbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kantankicha okañotantanakarira maika onti ontsatagagetanakerora ikamantakoigakenara pairani kamantantaigatsirira itsirinkakoigakenara okyara. Impo ishigavioigamatanakatyo maganiro irogamereegi iokaiganakeri Jeso paniro. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yogaegiri gaigakeririra Jeso yamaiganakeri ivankoku Kaipashi. Irirori inti itinkamisanorira saseroroteegi. Ario inaigake kara gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri aikiro itinkamiegi jorioegi yapatoitaigakara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Impo yogari Perero intaina inapaake yogiatapaakerira Jeso. Antari yagapaakerora pampatuiku ineaigapaakeri soraroegi pirinitaigake kara. Iriroegi intiegi sentaigirorira ivanko Tasorintsi. Ovashi ipirinitapaake irirori kameti ineakotakeriniri Jeso tyarikara inkantakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yogari itinkamiegi saseroroteegi itentaigakari itinkamiegi jorioegi ikaemakagantaigakeri pashini tsoeventaigakemparineririra kameti ontimakeniri onkenantakemparira irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ipokaigavetapaakatyo tovaini tsoeventaigakaririra, kantankicha irorokya ikantaigi irorokya ikantaigi, nerotyo tyampa inkantaigakeri. Impo ipokaigamatapaaketyo piteni kantaigankitsirira ");
INSERT INTO mcbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ikantaigi: —Naroegi nokemaigakeri ikantakera: ‘Naro nagaveake nogimamerinkakerora ivanko Tasorintsi impo novetsikaero, omavatakotanakempa kutagiteri nagataero.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Impo ikavirimatanakatyo Kaipashi ikantiri Jeso: —¿Tera tyara pinkantumate?, pikemaigakeritari ikantanaigakempira. Maika ¿tyara pinkantera viro? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kantankicha irirori ikemisantanaketyo, teratyo tyara inkantumate. Osamanitanakera imatutaarityo aikiro ikantiri: —Maika nonkantakempi kañomataka irironirika kantakempi Tasorintsi ikantakanirira itimi, atsi kamantena ¿arisanotyo vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite? ¿Viro Itomi Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iniamatanaketyo Jeso ikantiri: —Jeeje, naroniroro katinka pogakero, kantankicha maika nonkantaigakempi impogini pineaigakeri Kañotasanotakaririra Matsigenka impirinitakera inampinaku irakosanoriraku Tasorintsi Gaveavagetatsirira. Aikiro pineaigavakeri iripokaera inkenantapaemparora menkori. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ogatyo ikenake ikisamatanakatyo Kaipashi itisaraitarotyo imanchaki tseerererere ikanti: —¡Yokari yoka onti ikañotagumanatakari Tasorintsi! Iroroventi maika intagatityo akaemakagantaigi pashini iripokaigakera inkamantaigakaera ikañotakerora maika, matakaniroro pikemaigakeri tsikyata viroegi ikantakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Maika ¿tyara pinkantaige viroegi? Iriroegi ikantaigi: —Kantetyo inkamakera, tsikyatatari ikañotagantaka irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Impo itoanaigakeri ivoroku, itaataaigakeri togn togn, aikiro pashinikya patosanaigakeri ivoroku ");
INSERT INTO mcbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ikantaigakerira: —Irorotari vintira Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite jorioegi, ¡atsi gotenityo tyani taakempi! ");
INSERT INTO mcbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yogari Perero aiñokya inake anta parikoti pampatuiku. Impo okenapaake paniro nampiriantsi okantiri: —Viro aikiro pitentavagetari Jeso Garireakunirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kantankicha yogari Perero ikemamampeganakatyo ikantiro: —¿Jaa? ¿Tyara pikanti? Tera nonkeme tyarika pikanti. Ikemaigakeri maganiro naigankitsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Impo iavetakara anta sotsimoroku oneitaarityo aikiro pashini nampiriantsi okantaigiri naigankitsirira kara okanti: —Yogari yoga inti itentavagetarira Jeso Nasarekunirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kantankicha irirori ikantutaarotyo aikiro ikanti: —¡Teratyo noneimateri yoga piniakotakerira! Ineakenatari Tasorintsi tera ario nontsoegumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Choeni osamanitanakera yaiñoniigapaakari naigankitsirira kara ikantaigiri: —Arisanoniroro pitentavagetari nokemaigavaimpitari piniakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yogari Perero ikantutaatyo aikiro: —¡Nokantakeniroro teratyo noneimateri! Arisanotyo nokantake, ineakenatari Tasorintsi tera ario nontsoegumatempa. Antari ontirika notsoegaka inkisashitakenatyo, tera noneimaterinika piniakoigakerira maika. Irorotyo ikantakera maika, iniamatanaketyo atava ovashi ");
INSERT INTO mcbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","isurematanakarotyo Perero ikantakeririra Jeso inkaara ikantiri: “Paita tekyara iriniimate atava pinteratakotakena mavati.” Ikaviritapanuta iataira ogatyo ikenake iragamatanakatyo jiii jiii jiii, ikaemavavagetaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Impogini okutagitetanakera maganiro itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi ikemavakagaiganaka tyarika inkantaigakeri Jeso irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Impo yagaiganakeri yogusoiganakeri yamaiganakenerira Pirato. Irirori inti inampina Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Impogini yogari Jorashi gakagantakeririra Jeso yogotake arisano irogakagantakenkani ovashi isurematanakatyo ikanti: —¡Narotakaniroro! Ario nokantavagetaka naro gamerakari nagakagantiri okyara. Impo iatake inaigakera itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi irogipigaigaatenerimera yoga 30 korikimenta ipaigakeririra okyara iragakagantakerira Jeso ");
INSERT INTO mcbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ikantaigavetapaakari: —Narori onti novetsikake terira onkametite nagakagantakeritari terira tatakona irovetsikumate, maika irogakenkani. Kantankicha iriroegi ikantaigavakeri: —¿Ario tyara nonkantaige naroegi? Virompatyo, virotari kañotankicha okyara. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nerotyo yovuokagisetapanutiri koriki kara tsompogi ivankoku Tasorintsi iatakera ishitikakara. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Impo yogari itinkamiegi saseroroteegi yapatogiseigairi koriki ikantaigi: —Tera kameti agaigaerira ankonogiseigaerira yamaigirira pashini ipaigirira Tasorintsi. Ontitari ipunavitunkani iragakagantakerira irogakenkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Impogini ikemavakagaigaka impunaventantaigakemparora kipatsi paitacharira Igipatsite Vetsikirorira Koviti kameti ontimakeniri inkitatantaigemparira poniaigankicharira parikotipage. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Irorotari otantanakarira oga kipatsi opaitanakara Iraatsigiteri ovashi maika. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Okañotantakarira maika onti otsatagagetanakerora ikantakerira pairani kamantantatsirira Jeremiashi ikanti: “Yogaegiri iseraereegi yagaigakeri yoga 30 korikimenta ivunaro pairorira ikametiti ");
INSERT INTO mcbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ipunaventantaigakarora kipatsi paitacharira Igipatsite Vetsikirorira Koviti, ariotari ikantakenari Notinkami.” ");
INSERT INTO mcbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Impogini yogari Pirato ikogakotagantakeri Jeso ikantiri: —¿Arisano viro Igoveenkariegite jorioegi? Ikanti Jeso: —Jeeje, arisano pikantasanotakeniroro, naroniroro. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Antari itsoeventanaigakarira itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi tera tyara inkantumate Jeso onti ikemisantanake. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Irorotari ikantantakaririra Pirato: —¿Matsi tera pinkeme ikantanaiganakempira? ");
INSERT INTO mcbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kantankicha yogari Jeso teratyo iriniimate. Iroro ineavakerira Pirato ikañotakerora maika, yogavagetanaketyo kavako, tyampatyo inkantera. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Omirinkatyo agara iviesetaegite jorioegi okantaganirira Pasekoa yogari Pirato yapakui paniro yashitakovitunkanirira yovetsikakera terira onkametite, tyanirikara ikogaigakerira itovaireegi irapakuaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ario inake kara paniro shitakotankicharira ipaita Varavashi, yapagiteakovagetatyo kara ikemakotaganira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Impo Pirato ineaigakerira yapatoventaiganakarira maganiro ikantaigiri: —¿Tyani pikogaigake nampakuaerira? ¿Irirorika Varavashi intirika Jeso pikantaigirira inti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Irirori ineaketari onti ikisavitunkani ineinkanira intira yapatoventanunkani, irorotari yamantanunkanirira iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aiñokyara ipiriniti Pirato anta ikanomaantapinitira okantakagantakeri itsinanetsite okanti: “Gara pimavageta viro, tyampa ankantakeri yoga terira tatakona irovetsikumate. Nokisanigisevagetaketari inkaara posantegisematakatyo nogisanire. Irirorakari gimanatakena.” ");
INSERT INTO mcbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kantankicha yogari itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi yogotagaigakeri maganiro inkantaigakera: “Irirompatyo pampakuae Varavashi, yogari Jeso pinkentakotagantakerityo.” ");
INSERT INTO mcbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yogari Pirato iniitaigaarityo aikiro ikantaigiri: —¿Tyani pikogasanoigake nampakuaerira? ¿Iriro Varavashi intirika Jeso? Ikaemaigamatanaketyo: —¡Inti pampakuae Varavashi! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ikantaigiri Pirato: —Iroroventi, ¿tyaratyo nonkantakerira yoga Jeso pikantaigirira inti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite? Ikaemaigutanaatyo aikiro maganiro: —¡Kentakoteri! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ikantaigiri Pirato: —¿Matsi tyara ikantakara? ¿Tatampatyora yovetsikakera? Ikaemaigutanaatyo aikiro: —¡Nokantaigaketari kentakoteri! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Impo yogari Pirato ineavakera atanatsi ikaemavaitaiganakera tyampa inkantaigavakeri, ovashi ikaemakagantake nia inkivakotakempara kameti ineaigakeriniri maganiro impo ikanti: —Irogakenkanirika maika tera naro kañotachane. Virompaegityo, viroegitari kañoigankicha. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Maganirosanotyo ikaemaiganake: —¡Ariompa naroegityo kañoigankichane intiegiri aikiro notomiegi, naroegitari gakagantaigakerine! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iroro ikemaigakerira Pirato yapakuakagantairi Varavashi. Impo yomperaventakari Jeso impasatakenkanira iramanakenkanira inkentakotakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yogari soraroegi yamaiganakeri tsompogi impo ikaemakagantaigakeri maganiro irapisoraroegitene yapatoventaiganakari isamatsanaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Impo isapokaigakeri imanchaki yogagutantaigakari pashini kamisa kiraamagori. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yagaigake kivitsa yovetsikashiigakeri iramatsaire yamatsaitakerira. Aikiro yairikakagakeri inchakii irakosanoriraku, impo itigeroaventaigakari isamatsanaigakerira ikantaigakerira: —¡Ojojoo, neri yogaaa! ¡Atsi neaigerikario Igoveenkariegite jorioegi! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Itoatoaigakerityo kara impo yagapitsaigairi inchakii ipasatantaigakarira igitoku tagn tagn. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Impo yagataiganakera isamatsanaigakerira isapokaigairi irorokya yogagutantaigaari irashi imanchaki yamaiganakeri inkentakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Antari iaiganakera inkentakoigakerira itonkivoaigakari paniro Surenekunirira ipaita Sumo. Yogari soraroegi ikantaigavakeri inatanakenerira Jeso igoroshite. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Impo yogonkeigakara Gorogotaku, (onkantakera: “Ontaikara Itutai Kamatsirini”), ");
INSERT INTO mcbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ipaigavetakari vino okonoatunkani kepishiari, kantankicha irirori yoviikavetaka maani ovashi tera inkoge iroviikasanotemparora. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Impo yagataigakera ikentakoigakerira yogari soraroegi isokagiaigakero mapukicho ogotantaganirira kameti irogotantaigakemparora tyanirika shintakemparone imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Impo ovashi ipitaigake kara ikamaguigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Antari enoku oatakara igitoku ogunkani inchakota otsirinkunkani okanti: “Yokari yoka inti Jeso, Igoveenkariegite jorioegi.” ");
INSERT INTO mcbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aikiro itentagantunkani piteni koshinti ikentakotunkanira, paniro yogaratinkakotunkani irakosanoriraku, yogari irapitene onti yogaratinkakotunkani irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yogari visapiniigankitsirira kara ineaigakerira iokookonaigakerityo ");
INSERT INTO mcbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ikantaigakerira: —¡Eejee tyanirityo maika! Kogapage pikantira: ‘Nogimamerinkakero ivanko Tasorintsi impo novetsikaero, omavatakotanakempa kutagiteri nagataero.’ Maikari atsi pugamentanakempanityo. Irorotari vintira Itomi Tasorintsi kentakoreanaempanityo paguitanaera. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ario ikañoigaka itinkamiegi saseroroteegi itentaigakarira gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri itinkamiegi jorioegi isamatsanaigakerityo iniavakagaiganakara ikantaigakera: ");
INSERT INTO mcbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Kogapage ikantunkani yagaveavagetityo ikavintsaantavagetakera yogavisaakotakerira pashini matsigenka, tyara okantakara maika tera iragavee impugamentanakempara ikiiro iraguitanaera. Antari irirora Agoveenkariegite inkentakoreanaempametyo iraguitanaera koroshiku kameti ankematsaigakeriniri. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Irorotari ikematsavintsatakerira Tasorintsi kantetyo impugamentaerira maika arisanorikara itakari, irorotari ikantira: ‘Nanti Itomi Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Imaiganakatyo aikiro itentagantunkanirira ikentakotunkanira ikantanaigakerityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Impo ikatinkatanakera poreatsiri oga okenake apavatsaasetanaka magatiro ovashi itsunkavagetanake. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ogatyo ikenake ikaemamatanaketyo Jeso ikanti: “Eri, Eri, ¿irema savakatani?” (onkantakera: “Apa Tasorintsi, Apa Tasorintsi, ¿tyara okantakara povashigantakenara?”) ");
INSERT INTO mcbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ikonogagarantaigaka naigankitsirira kara iroro ikemaigavakerira ikantaiganake: —Atsi kemeri kanika ikaemakotakerira kamantantatsirira Eriashi. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ishigamatanakatyo paniro yaganakera chomiatirorira nia iokaatakerora kachoariku vino yogaenokakovetakenerira savorokiiku irachomiatagakerimera. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kantankicha yogari itovaireegi ikantaigiri: —Atsi pampogieri, aneaigakerira iripokashitakeririka Eriashi iroguitaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Impo yogari Jeso ikaemapanaati aikiro imaraenkarikatyo kara ovashi ikemisantanake ikamanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Irorotyo ikamanakera ogatyo okenake osaraamatanaketyo kamisa tsatamagotacharira ivankoku Tasorintsi okantanakera katinkasano niganki tseerererere oponianakara enoku oatakerora savi pairatamatake kotarenkasanotake. Ontininkamatanakatyo tinin tinin tinin otsiraagematanaketyo imperitapage, ");
INSERT INTO mcbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","oga okenagetake ashirenakigetanaka ikitatantagetaganirira igamagapage, yaniagematanaityo tovaini kematsaigiririra Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Impogini yanianaira Jeso iaigake iriroegi Jerosarenku ineaigavairi tovaini timaigatsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yogari itinkamiegi soraroegi intiegiri itentashiigakarira ipampogiaigakerira Jeso ineaigavakera ontininkanakara, aikiro pashinipage oposantetanakara itsarogavageiganaketyo kara ikantaigi: —¡Arisanoniroro inti Itomi Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ario onaigake kara tovaini tsinaneegi giaigakeririra Jeso iponianakara Garireaku, aikiro omutakovageigakeri. Iroroegi onti aratintiitaigake antakona anta opampogiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ario onaigake aikiro kara Maria Magarena ontiri Maria iriniro Santiago intiri Jose, ontiri aikiro iriniro itomiegi Severeo. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Impogini panikyara onchapinitanae ipokake paniro shintavagetacharira ipaita Jose. Irirori onti iponiaka Arimateaku. Ario ikañotaka aikiro inti irogamere Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Irirori iatashitakeri Pirato ikantakerira ikogakera iramanaerira Jeso inkitataerira. Yogari Pirato ikantakeri: —Iroroventi nanityo. Impo ikantaigakeri soraroegi: —Kametitake pimpakerira iramanaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ovashi yaganairi iponatantanakarira mechomagori kamisa okyamagokyarira ovetsikantunkanirira irino. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Impo yamanairi yogaatirira imperitanakiku okyaenkarira ikigakagantake irogantaenkanimera irirori inkamanaera. Impogini itikakotantanakari omarane mapu iatai. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ario onaigake kara Maria Magarena ontiri apitene Maria opirinitaigakera kara katinka yogaaganira. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Impo okutagitetanakera apishigopireantaganirira yogari itinkamiegi saseroroteegi intiegiri pariseoegi iaigake inkamosoiguterira Pirato ");
INSERT INTO mcbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ikantaigapaakeri: —Naroegi nosureiganakaro ikantakerira yoga tsoenti tekyara inkame ikantakera: ‘Nonkamakerika impo omavatanakempara kutagiteri nanianae.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maika kamani iroro iromavatakotantanakempa, irorotari nonkantantaigakempirira atsi tigankenityo soraroegi irisentasanoigakerora yogantunkanirira ganiri ipokashiigiri irogamereegi iragaigapanuterira impo inkantaigakeri maganiro atake yanianai. Intagarora inkañoigerora maika pairorokari avisavagetakero iramatagaigakempara avisakerorokari yamatagakoigakarira tekyara inkame. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yogari Pirato ikantaigiri: —Iroroventi nanityo, neri yogaegi soraroegi. Piaigetyo pisentaigakiterira, virompaegityo tyarika pinkantaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iriroegi iaigake yogunkanira Jeso yavitsajaigapaakerora mapu itikakotantunkanirira impo ikantaiganakeri soraroegi irisentasanoigakerora ganiri tyani pokashitumatiri. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Impo iroro okutagitetamanakera tominko, ogari Maria Magarena ontiri apitene Maria oaigamanake onkamosoigaaterira yogaaganira, ataketari avisanake kutagiteri apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Antari tekyara ogonkeigempa ontininkanaka kipatsi tinin, tinin, tinin, ipokapaaketari isaankariite Tasorintsi iponiapaaka enoku itiguronkapaakerora mapu tikakovetakaririra Jeso ipirinitantakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ikovoreavagetiratyo kara kañomataka kareti okantira tsaarere tsaarere. Ogari igitsagare onkutavageteratyo kañomatakatyo okutatira mampe. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yogaegiri soraroegi iroro ineaigavakerira ogatyo ikenaigake itsarogavageiganaketyo kara ishigekavageiganakera shige shige shige ituaigamatanaketyo ikamaigakitityo. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Impo iroro ogonkeigavetapaakara tsinaneegi yogari isaankariite Tasorintsi ikantaigiro: —Gara pitsarogaigi. Naro nogotake inti pikogaigake Jeso ikentakovetunkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kantankicha akari aka mameri, ataketari yoganiaagani, ariotari ikantakeri irirori tekyara inkame. Atsi tainaegi pineaigakerora yoginoriavetunkanira, ");
INSERT INTO mcbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","impo piaigepage pintsatimaiganakera pinkamantaigapaakerira irogamereegi pinkante: ‘Atake yanianai. Maika iketyo ivatanankitsine iriatakera Garireaku. Antari anta ario pineaigapaakeri.’ Irorotari nopokashitake nonkamantaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iroro okemaigavakera otsarogavageiganake, kantankicha oshinevageiganaka aikiro. Akyatyo otsatimavageiganake tsikyari onkamantaigapaakeri irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Impo itonkivoaigavakaro Jeso avotsiku iniaigavakero. Iroroegi aiñoniiganakari otigeroaventaiganakarira avinaigakerira itasagiiku. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Irirori ikantaigiro: —Gara pitsarogaigi. Piaige pinkamantaigakerira nogamereegi iriaigakera Garireaku. Antari anta ario ineaigapaakena. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iroro oaiganakera ikonogagarantaigaka soraroegi sentaigavetakaririra Jeso ario ikañoigaka iriroegi iaigake Jerosarenku ikamantaigakerira itinkamiegi saseroroteegi magatiro ineageigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iriroegi iniavakagaigaka itentaigakarira itinkamiegi jorioegi. Iroro ikemavakagaigakara ipaigakeri tovaini koriki ");
INSERT INTO mcbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ikantaigavakeri: —Viroegi onti pinkantaigake: ‘Antari apavatsaanakara naroegi nomagasevageigake impo ipokashitaninkaigakeri irogamereegi yagaigapanutiri.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Antari intagarora inkemera Pirato nonkamantagaigakeri nogishineaigaerira ganiri tyara ikantumaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yogari soraroegi yagaiganakerira koriki iaigake itsatagageigakerora ikantaigakeririra. Ario ikañoigakero maganiro jorioegi kantanakaniroro ovashi maika ikantaigira tera iranianae Jeso, onti yagaigapanutiri irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Impogini maganiro irogamereegi iaigake Garireaku iatantaigaka otishi ikantaigakeririra Jeso tekyara inkame. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iroro ineaigapaakerira ikantaigi: “¡Inti Atinkami!” Ovashi itigeroaventaigakari, kantankicha ikonogagarantaigaka iniasurentavageigaka ikantaigake: “Terorokari iriro.” ");
INSERT INTO mcbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kantankicha Jeso yaiñoniiganakari ikantaigiri: —Yogari Tasorintsi ikantakena: ‘Maika viro vinti gaveagetakerone enokupagekutirira ontiri kipatsipagekutirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irorotari maika nonkantantaigakempirira piaige pampagiteavageiganakemparora kipatsi pinkenkitsatimoigakerira maganiro matsigenkaegi pinkematsatagaigakerira kameti impegaigakempaniri nogamereegi. Impo pogiviaigakerira kameti iokotagantaigakempaniri arisano ikematsaigakeri Apa Tasorintsi intiri Itomi intiri aikiro Isure. ");
INSERT INTO mcbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pogotagaigakerira inkematsaigakenara intsatagaigakerora magatiro nokantaigakempirira. Narori nonkantakani nontentaigakempi omirinka kutagiteri ovashi ontsonkatanaempara kipatsi.");
INSERT INTO mcbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Maika nokogake nontsirinkakotakerira Jesokirishito Itomi Tasorintsi nonkamantakotakerira. Nontsititapanutero ikyara yogiviatake Joan nonkaratagavagetero iatanaira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yogari kamantantatsirira Isaiashi itsirinkakotakero pairani ikantakera Tasorintsi iniakerira Itomi ikantiri: “Notomi, impogini nontigankake paniro ivatanakempinerira inkantaigakerira itovaireegi inegintetashiigavakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Irirori iriatake anta osarigagitetapaakera inkenkitsatakera imaraenkarika kara inkante: ‘Pakuaiganakero povetsikageigira terira onkametite pinegintetashiigavakemparira Atinkamiegi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Impogini yogari Joan Giviatantatsirira iatake anta osarigagitetapaakera yogiviatantavagetakera, aikiro ikenkitsavagetakera ikanti: “Kantatigaiganakempa pampakuaiganakerora povetsikageigira terira onkametite pogiviaigakempara ganiri ikisaviigimpiro Tasorintsi magatiro pikañovageigara.” ");
INSERT INTO mcbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Maganiro timaigatsirira Joreaku intiegiri aikiro Jerosarenkunirira iaigake inkamosoigakerira. Antari ikemaigakerira ikenkitsavagetakera ovashi ikamantakoiganakero magatiro yovetsikageigirira terira onkametite impo yogiviaigakeri Jororanku. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Irirori onti yogagutaka manchakintsi ovetsikantunkanirira iviti kameyo, aikiro isuntoratsatakari imeshina. Intagani yogaka tsinaro intiri pitsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Impo ikenkitsaiganakeri ikantaigakerira: “Choenitapaake iripokakera impogitapaakenanerira. Irirori pairotyo yavisakena yagaveavagetakera. Narori garorokarityo nokañotumatari irirori, onti nagamaavagetakari, pairotari yavisavagetakena. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Narori onti nogiviaigakempi niaku, kantankicha panikya iripokake pashini tigankimoigakempineririra Isure Tasorintsi intimasurentagarantaigakempira.” ");
INSERT INTO mcbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Impogini iponianaka Jeso Nasareku iatakera inakera Joan ovashi yogiviatakeri Jororanku. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Impo irorotyo yaganairora Jeso otsapiaku ineiro ashirenakitanaka inkite yapusatinkagutapaakari Isure Tasorintsi ikañotapaakari shiromega. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Impo inianake Tasorintsi enoku ikanti: “Virori vinti Notomi, notasanovagetakempityo kara noshineventakempityo.” ");
INSERT INTO mcbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iroro yagatakera iniakera Tasorintsi yogari Isure yamanakeri Jeso parikoti osarigagitetapaakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ario inake kara 40 kutagiteri itentagaigakari kakintyokiripage gantagetatsirira. Yogari Satanashi ipokashitakeri ineasanotakerira ariorika iragaveake irapakuakagakerira ganigera ikematsatairi Iriri, kantankicha teratyo iragaveeri. Impogini irirokya pokaigapaatsi isaankariite Tasorintsi yamaigakenerira iseka ishintsitagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Impogini yashitakotunkanira Joan, iatake Jeso Garireaku ikenkitsavagetakera ikamantaigakerira maganiro tyara ikanta Tasorintsi yogavisaakotantira ");
INSERT INTO mcbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ikantaigakerira: “Maikari gaka intsatagantakemparorira Tasorintsi ikantakerira pairani, panikyatari aganakempa impegantakemparira Igoveenkariegite maganiro kematsaigakerinerira. Maika pakuaiganakero povetsikageigira terira onkametite pinkantatigaiganakempara, aikiro kematsaigena nokantaigakempira maika.” ");
INSERT INTO mcbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Impogini ikenanake Jeso kara ishitetanaka otsapiaku inkaare Garirea. Ineaigapaakeri Sumo intiri irirenti paitacharira Anturishi kitsavageigake, irorotari ipiriniventavageigi iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Impo ikantaigiri: —Maikari maika onti pipiriniventavageigi pikitsavageigira, kantankicha maika pakuaiganakero pikitsavageigira tsame pogiaiganakenara ariokya nagaveakagaigakempi irirokya pimpiriniventavageigae matsigenkaegi pinkematsatagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Impo iriroegi iokageigapanutiro igitsareegi yogiaiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iaigavetanaka antakona anta irirokya ineapaake Santiago intiri irirenti paitacharira Joan pirinitaigake pitotsiku shitikagisevageigake igitsareegi. Itentaigakari iriri paitacharira Severeo. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Impo yogari Jeso ikantaigiri Santiago intiri Joan: —Tsame pogiaiganakenara. Iriroegi yogiaiganakeri iokaiganakeri iriri paniro, intagani itentaigaari iromperaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Impogini yogonkeigapaaka Kaperenaoku. Antari aganakara kutagiteri apishigopireantaganirira iatake Jeso pankotsiku yapatoitantaigarira jorioegi yogotagantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ikemaigavakerira maganirotyo yogavageiganake kavako, ineaigaketari yogotagaigakerira yogovagetiratyo kara, tera ario inkañoigempari gotagantaigirorira itsirinkakotanakerira Moiseshi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ario inake kara paniro surari itimagutakerira kamagarini. Irirori ikaemanake ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Eeee! ¡Jeso Nasarekunirira! ¿Tyara pinkantaigakenara? ¿Iroro pipokashitake pimpogereaigakenara? Noneimpitari, nogotakempi vinti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Inianake Jeso ikantiri: —¡Kemisante! ¡Kontetanae, piatae parikoti! ");
INSERT INTO mcbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iroro ikemavakerira ogatyo ikenake yogituanakeri itimagutakerira ikantanake shige shige shige ikamakiti. Impo ikaemapanuti kamagarini ¡eee! ikontetanai iatai parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Maganiro yogavageiganaketyo kavako ikantavakagaiganaka: —¿Tatarikatyo oitara oka? Okantatigakatari yogotagantapaakerira yavisavagetakerityo pairorira yogovageti, nerotyo ikematsatantaiganakaririra kamagarini yoneagaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Impogini maganirotyo timaigatsirira Garireaku ikemakoigakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Impogini ikonteiganaira iatake Jeso ivankoku Sumo intiri Anturishi itentaiganakari Santiago intiri Joan. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ogari yagashintotirira Sumo oanativagetake onoriaka tsompogi. Irorotyo yogonketapaakara Jeso ikamantavunkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Irirori yaiñonitapaakaro ikatsavakotapaakero itinaakero. Ogenanekyatyo ovegapagenityo shintsi. Impo opakoigakeri isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Impo ishonkanaara poreatsiri ochapinitanaira yamaigapaakeneri Jeso maganiro mantsigaigankitsirira intiegiri aikiro itimaguigakerira kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Maganiro timaigatsirira kara Kaperenaoku yapatovageiganakatyo sotsimoroku. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yogari Jeso yovegageigakeri oposantetashigeigakarira mantsigarintsipage, aikiro yoneaganontaigakari itimaguigakerira kamagarinipage. Yogari kamagarinipage yogoigakeritari inti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite maganiro, nerotyo irirori ikantavitantaigavakaririra iriniaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Okutagitetamanakera aityokyara apavatsaaenkata itinaanaka Jeso iatake anta parikoti omamerigitetakera iriniakerira Iriri. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Osamanitanakera iatake Sumo inkogaerira itentaiganakari itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Impo ineaigapaakerira ikantaigapaakeri: —Maganiro ikogaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kantankicha irirori ikantaigiri: —Tsame anta ochoenitira itimageigakera nogotagaigakerira, irorotari nopokashitake. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iatake Jeso itsotenkanakero magatiro Garirea ikenkitsavagetakera pankotsipageku yapatoitantaigarira jorioegi, aikiro yoneaganontaigakari itimaguigakerira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Impogini ikenapaake paniro vesegasenari itigeroaventapaakari ikantiri: —Notinkamii, nokogavetaka povegaenara, kantankicha impatyora viro tyarika pinkante. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Itsarogakaganakari Jeso yakontsaanake itsagatakeri ikantiri: —Jeeje, nokogake, maika veganaempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Irorotyo ikantakerira ogatyo ikenake paa vegasanovagetaa. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Impo itigankairi Jeso kantankicha ikantavakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Gara tyani pikamantumati. Inti piatimotake saserorote pokotagakemparira ontiri aikiro pamagetanakenerira piratsipage pintsatagakerora ikantakerira Moiseshi kameti ineasanotakempiniri ovashi inkantakempi vegaavi irogoigakempiniri maganiro vegasanotaavi. ");
INSERT INTO mcbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kantankicha irirori teratyo inkeme. Iataketyo ikamantageigakerira maganiro yovegairira Jeso. Ovashi tenige iriatae Jeso anta itimageigira matsigenkaegi. Intagati yanuivagetake parikotipage terira intimaige, kantankicha iatashigeigamatirityo parikotipagekunirira ineaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Impogini otovaigagitetanaira iatai Jeso Kaperenaoku. Maganiro ikemakoigakeri ario inake kara pankotsiku imagapinitira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iroro ikemakoigakerira iatashiigakeri yapatoventaiganakarityo kara tsompogi ontiri aikiro sotsi. Tyampa inkantaigakempa inkiaigaera pashini, tikaviovageigakatari itovaireegi. Irirori yogotagaigakeri tyara inkantaigakempa irogavisaakoigakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Impo ipokaigake 4 surariegi ikompitakoigapaakeri shinkogisenari terira iranuite. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yogonkeigavetapaaka patovageigakatyo kara, tyampatyo inkenakagaiganakeri inkiakagaiganakerira tsompogi inakera Jeso. Yataguigamatanaketyo enoku sotsi otishitapankoku yovenakiigakero maani ikatinkatakotakera Jeso yoguitakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Antari ineaigakerira Jeso arisano opaitaka yogoigakera iragaveakera irovegaerira ikantantakaririra shinkogisenari: —Notomi, maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ario inaigake kara gotagantaigirorira itsirinkakotanakerira Moiseshi. Iriroegi iniasurentavageiganaka ikantaigi: ");
INSERT INTO mcbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tyarikatyo ikantakara ikantakera maika? ¡Onti ikañotagumanatanakari Tasorintsi! ¿Matsi aiño pashini gaveankitsinerira imagisantakotantaerora kañovagetagantsi?, panirotari yagaveira irirori.” ");
INSERT INTO mcbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kantankicha Jeso yogoigavakerityo iniasurentaigakara ikantaigutarityo: —¿Tyara pikantaigakara piniasurentaigakara pikañoigakerora maika? ");
INSERT INTO mcbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tyatimpatyo pairo avisake okomutakara? ¿Irororika nonkantakerira: ‘Maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi’, ontirika nonkantakerira: ‘Tinaanake, ganaero pinoriantakarira, piatae’? ");
INSERT INTO mcbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Maika noneakagaigakempi yagaveake Kañotasanotakaririra Matsigenka imagisantakoigaerira matsigenkaegi magatiro terira onkametite yovetsikageigirira. Impo ishonkatetanakari shinkogisenari ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Maikari maika viro nonkantakempi tinaanake, ganaero pinoriantakarira, piatae pivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Irorotyo iniakerira igenanekyatyo itinaapanuta yaganairo inoriantakarira ikontetanai iatai. Ineaigavakerira maganiro yogavageiganaketyo kavako ishineventaiganakarira Tasorintsi ikantaigi: —¡Ojojoo! Teratyo noneimaigero onkañotakera maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Impogini Jeso iatai aikiro otsapiaku inkaare. Iroro yapatoventavageiganakarira tovaini matsigenka yogotagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Impogini ipiganaara Kaperenaoku ineapaakeri itomi Arejeo paitacharira Irevi pirinitake anta pankotsiku itimashiigavakerira visapiniigatsirira ikogantaigavakarira koriki maganiro maiganankitsirira iarakipage ontirika tatapagerika oita, intitari kogantiniririra koveenkari koriki. Impo yogari Jeso ikantapaakeri: —Tsame, pogiatanakenara. Irirori ikaviritapanuta iatanake yogiatanakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Impogini Jeso iatake ivankoku isekatavagetakara itentaigakari irogamereegi intiegiri aikiro pashini kogantaigaririra itovaireegi koriki irashi koveenkari intiegiri aikiro pashini kañovageigacharira. Itovaigavagetityo kara giaiganakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yogari pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ineaigakerira Jeso itentaigakarira isekataigakara ikantaigiri irogamereegi: —¿Tyara ikantakara yoga gotagaigimpirira isekatakovageigakarira kogantaiginiririra koveenkari koriki intiegiri aikiro pashini kañovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Antari ikemavakera Jeso ikantaigiri: —Yogari terira imantsigaige tera inkogakoigempari gavintantatsirira. Intagani kogakoigari mantsigaigankitsirira. Ariotyo nokañotaka naro tera iriro nompokashiige terira inkañovageigempa nonkantaigakerira inkantatigaiganakempara, intityo nopokashiigake kañovageigacharira kameti inkantatigaiganakempara irapakuaiganakerora yovetsikageigakera terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Impogini yogari irogamereegi Joan intiegiri pariseoegi tera isekataigempa, onti ipitashiigakaro kogapage, impo ikonogagarantaigaka iaigake ikantaigakerira Jeso: —Yogaegiri irogamereegi Joan intiegiri irashiegi pariseoegi yapakuapiniigi tera isekataigempa, kantankicha yogari pashiegi pogamereegi tera ario inkañoigempa maika. ¿Tyara ikantaigakara? ");
INSERT INTO mcbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Impo ikantakotaka Jeso ikanti: —Pine intimera pashini ikyarira gankitsi itsinanetsite inkaemaigakeri iamigoegite isekatagaigakemparira, ¿matsi gara isekataiga? Isekataigakempaniroro, itentaigakaritari kaemaigakeririra ishinevageigaka. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kantankicha antari aganakempara inkisakenkanira iramanakenkanira parikoti ario pinkante impitashiigakemparotyo kogapage gara isekataigaa, inkenkisureakoiganakemparitari. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tera onkametite pinkematsatagarantaigerora yogotagaigakempirira pariseoegi irorokya pimaigavake nogotagaigakempirira naro. Ontinirikatyo okañotakaro onkotatenkanira kamisa ogantagarira onkotatantakenkanira okyamagokyarira. Onkivavetanakempa oga onkenake ontsiomagotanakempa ariompa ontisaraanakerori. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aikiro ontinirikatyo okañotakaro ompiaatenkanira vino okyaakyarira tekyarira ompoite ompiaatantenkanira kaverameshina igantagarira atakerira yaratsimeshinatanake. Ompoivetanakempa aravonkanake oga onkenake ontimpoanakeri imeshina ovashi ontisaraanakeri osanakempa vino, aikiro iraparatakempa imeshina irisaraanakera. Nerotyo pairo okametitake ompiaatantenkanira ikyameshinakyarira.” ");
INSERT INTO mcbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Impogini aganakara kutagiteri apishigopireantaganirira iatake Jeso ikenanake turigoshiku itentaiganaari irogamereegi. Iriroegi yagaigamatanaketyo turigoki. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ikantaigiri pariseoegi: —¿Tyarikatyo ikantaigakara pogamereegi?, yagaiganaketari turigoki maika kutagiteriku apishigopireantaganirira, okantavitantaganitari antavagetantenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Kantankicha irirori ikantaigiri: —¿Matsi tera piniavantumaigero viroegi otsirinkakotunkanira yovetsikakerira Iravi pairani ipegakara Aviatare itinkamisanorira saseroroteegi? Yogari Iravi intiegiri itentaigakarira itasegaiganake, mamerisanotyo tatampatyo irogaigakempa, impo ikiamatanaketyo ivankoku Tasorintsi yogakarora pan okantavitantaganirira ogenkanira, ontitari irashi Tasorintsi. Intagani gaigaro saseroroteegi, ariotari ikantiri Tasorintsi, kantankicha yogari Iravi yogakarotyo, aikiro ipaigakeri itentaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ikantutaigaarityo aikiro: —Ogari kutagiteri apishigopireantaganirira onti otimashitake irapishigopireantakemparora matsigenka. Yogari matsigenka tera iroro intimashite kutagiteri apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yogari Kañotasanotakaririra Matsigenka irirotari kantatsirira tyati okantavitantagani antantenkanira kutagiteriku apishigopireantaganirira, aikiro tyati terira onkantavitantenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Impogini iatai aikiro Jeso pankotsiku yapatoitantaigarira jorioegi ikiapaake tsompogi. Ario inake kara paniro shinkovakotankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Impo yogaegi patoitaigankicharira ikamagutasanoigakerityo Jeso ineaigakerira ariorika irovegaeri kutagiteriku apishigopireantaganirira kameti intsavetantaigakeriniri inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kantankicha Jeso ineapaakerira shinkovakotankicharira ikantiri: —Atsi aratinke ineaigakempira maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Impogini ikantaigiri maganiro: —Maika atsi pinkantaigakenara tyara ikanti Moiseshi pairani. ¿Tata ovetsikakenkani kutagiteriku apishigopireantaganirira? ¿Ario ikanti ovetsikakenkanira kametiri ontirika ovetsikakenkanira terira onkametite? ¿Ario ikanti aganiaigavaerira atovaire ontirika ikanti agamagaigakerira? Kantankicha iriroegi teratyo tyara inkantumaige, ikemisantaiganaketyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yogari Jeso ikamagugeigakeri maganiro ikisaagaigakeri, aikiro ikenkisureakoiganakarityo, ineaigakeritari kañoigamataka tenirikatyo ontimaige isure. Impo ishonkatetanakari shinkovakotankicharira ikantiri: —Atsi kontsaanake. Irorotyo yakontsaanakera ogatyo okenake irako paa vegasanovagetaa kañotasanovagetaatyo apipakotene. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Impo ikonteiganai pariseoegi iaigake inkamosoigakerira itentaigarira Erorishi. Iroro ineaigapaakerira yapatoitaigaka isariaiganakarira Jeso irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yogari Jeso iatake otsapiaku inkaare itentaiganakari irogamereegi. Yogiaiganakeri aikiro tovaini matsigenkaegi timaigatsirira Garireaku ontiri aikiro Joreaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ikemakoigakeritari yovetsikagetakera posantepage ipokaigake ineaigakiterira, iponiagarantaigaka Jerosarenku ontiri Iromeaku. Pashini iponiaigaka intati Jororanku oatakara ikontetira poreatsiri. Pashinikya poniaigankicha Tiroku ontiri Suronku. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yogari Jeso iroro ineavakera yapatoventaigapaakarira ikantaigakeri irogamereegi iramaigakenerira pitotsi irogaigakenerira aiñoni otsapiaku iromatetantaigakemparora ganiri itsitokaigiri patoventaigakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yapatoventaigapaakaritari tovaini mantsigaigankitsirira itatsinkavakagaiganakatyo kara ikogaigakera iraiñoniigakemparira intsagaigakerira, ineaigaketari yovegaigakerira tovaini pashini. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Impo yogaegiri kamagarinipage ineaigakerira Jeso yompatakaventaiganakari ikaemaiganake ikantaigi: —¡Viro vinti Itomi Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kantankicha Jeso ikantaviigakerityo iriniakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Impogini Jeso iatake otishiku ikaemaigakeri irogamereegi ikogaigakerira. Impo iaigakera iriroku ");
INSERT INTO mcbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","yagake 12 intentavageigakemparira, aikiro intigankaigakerira inkenkitsavageigakera, irorotari ikantantaigunkanirira iritigankaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Impo yagaveakagaigakeri ironeaganontaigakemparira itimaguigakerira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Maganiro yagaigakerira onti ipaiigaka: Sumo, ipaitairira aikiro Perero; ");
INSERT INTO mcbNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago intiri Joan, itomiegi Severeo, ipaiigairira Voaneregeshi (onkantakera: “Kañoigamataka Kareti”); ");
INSERT INTO mcbNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anturishi, Jeripe, Varitorome, Mateo, Tomashi, Santiago, itomi Arejeo; Tareo, Sumo komperagetatsirira, intiri ");
INSERT INTO mcbNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jorashi Ishikariote, gakagantakeririra Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Impogini iataira Jeso pankotsiku, yapatoventaiganaarityo tovaini matsigenkaegi, tyampa inkantakempa isekatakempara intentaigakemparira irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Impo ipokaigake iitaneegi iragaigaaterira, ikemakoigakeritari ikantunkanira atake ipigatanake. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ipokaigake aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi iponiaigakara Jerosarenku ineaigakerira Jeso. Iriroegi ikantaigake: “Inti tinkamitakari Veresevo itinkami kamagarinipage. Irirotari gaveakagakeri yoneaganontantaigakaririra itimaguigakerira kamagarinipage.” ");
INSERT INTO mcbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nerotyo ishonkatetantaiganakaririra Jeso ikantaigiri: “¿Matsi tyara inkantakempa Satanashi ikiirora neagaachane? ");
INSERT INTO mcbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ontinirikatyo inkañotakempari intimera matsigenka irapatoitakeri itovaire impegakempara itinkami. Impogini yogari irapatoire intsitiiganakero inkisavakagaiganakempara ganige itimagantsiigai. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ario ikañoigaka tentaigaririra iitaneegi ikiirora parantavakagaiganaachane inkisavakagaiganakempara oga inkenaigake irashirikovakagaiganakempa ganige itsipavakagaigaa. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ario ikañotaka Satanashi irirori, ¿matsi tyara inkantakempara ikiirora parantavakagaigaachane inkisavakagaigaempara intentaigaemparira itovaireegi kamagarinipage? Impogereakeririka itovaire panivani irinae, ¿ario tyanimpatyora iromperataempa? ");
INSERT INTO mcbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kañotari intimera pashini matsigenka inkogera inkiashitakerira ivankoku suraritatsirira inkoshiarantakerira, oketyo irogusotapaakeri kameti inkoshiarantakeriniri. Antari garira oketyo yogusotiri garatyo yagaveimatiri inkoshiaranterira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nonkamantasanoigakempi maika tatarika irovetsikaigake matsigenka terira onkametite ontirika isamatsanaigakeri Tasorintsi, irirori iragaveaketyo imagisantakoigaerira garatyo ikenkiimatairo, ");
INSERT INTO mcbNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kantankicha yogari neavetakemparonerira iragaveane Isure Tasorintsi impo inkantake intityo gaveankitsi kamagarini, garatyo imagisantakotumatairi.” ");
INSERT INTO mcbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ikantantaigakaririra maika, ineaketari ikantaigakerira inti tinkamitakari kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Impogini opokake iriniro Jeso intiegiri irirentiegi inaigapaake sotsi, impo ikaemakagantaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yogari aiñoniigakaririra ikantaigiri: —Pokake piniro intiegiri pirentiegi aiño inaigake kara sotsi ikogaigake ineaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Irirori ikantaigiri: —¿Tyanimpatyora ina intiri aikiro igeegi? ");
INSERT INTO mcbNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Impogini ipampogiaiganakeri maganiro patoitaigankicharira iriroku ikanti: —Viroegi maganiro nopegaigakempityo ina, aikiro nopegaigakempi igeegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Imirinkatari tsatagagetirorira ikogagetirira Tasorintsi irirotyo nopegake ige ontiri incho ontiri aikiro ina. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Impogini Jeso iatai aikiro otsapiaku inkaare yogotagantavagetaira. Yapatovageigapaakatyo tovaini matsigenkaegi inakera irirori, tyarika itovaigavagetityo kara. Irirori yomatetaka pitotsiku ipirinitake. Maganiro patoitaigankicharira ipitaigake otsapiaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Impo yogotagaigakeri ikantakogetakerora posante ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Atsi kemisantaigena nonkamantaigakempira. Iatake paniro matsigenka impankivagetakera turigoki. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iokagisetanakero pakarara pakarara itsotenkavagetanakero. Okonogagarantaka oparigigetanake avotsiku, impo iparigashiigakero tsimeri yogaigakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pashini okonogagarantaka oparigigetanake mapuseku, shintsi oshivokavetanaka, tesakonatari ontimasanotenika kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Impogini iporeavetanaka poreatsiri itaganakero oshigirikanake okamanake, tetanika oatasanote oshitsaki savi, otikakerotari mapu. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Okonogaka pashini oparigigetanake okitagigetakara okitsoki tovaseri timatsirira otsei. Impo oshivokavetanakara ogenanekyatyo oshivokutanaka tovaseri irorori asaganakero okamanai, tera ontime okitsoki. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pashini okonogaka oparigigetanake okametipatsatakera kipatsi. Irorori pinkante oshivokanake okimotanake otimanake tovaiti okitsoki, okonogaka otimake 30, pashini 60, pashini otimake 100.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Impo ikantaigiri: “Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Impogini iaiganaira maganiro, panivanira yapuntaa Jeso itentaigaarira irogamereegi, aikiro pashini giavageigakeririra. Iriroegi ikantaigiri: —¿Tatatyo oitara pikantakotake inkaara? ");
INSERT INTO mcbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Irirori ikantaigiri: —Pairani tera ogovetenkani tyara inkantaigakeri Tasorintsi matsigenkaegi irogavisaakoigakerira kameti impegakempara Igoveenkariegite. Maikari maika ikogake pogoigakerora viroegi. Antari nogotagaigirira pashinipage onti nokantakogetakero magatiro ");
INSERT INTO mcbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kametiniri ‘ineaigavetakempatyo kantankicha impegaiganakempa kañomataka tenirikatyo ineaige. Inkemaigavetakempa aikiro, kantankicha onti onkomutapitsaigakempari kameti ganiri yogavisaakoigagani.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Impo ikantaigiri: “¿Tera pinkemaigavakero oka nokantakotakerira inkaara? Iroroventi ¿tyampatyo pinkantaigakempa pinkemaigavakerora otovaire nonkantakogetakerira? ");
INSERT INTO mcbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maika nonkamantaigakempi. Yogari atankitsirira impankivagetakera inti nokantakotake kenkitsatirorira Iriniane Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ikonogagarantaigaka matsigenkaegi onti ikañoigakaro turigoki parigigetankitsirira avotsiku. Ikemisantaigavetakaro Iriniane Tasorintsi, kantankicha igenanekyatyo ipokashiigakeri Satanashi imagisantakagaigakeri magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ikonogagarantaigaka pashini onti ikañoigakaro okitsoki parigigetankitsirira mapuseku tesakonarira ontime kipatsi. Ikemaigavakerora Iriniane Tasorintsi ishineventaigavetavakaro, ");
INSERT INTO mcbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kantankicha tera inkematsatasanoigero, nerotyo imagisantaiganairo shintsi. Impogini opokashitakeri tsipereagantsi ontirika ikisaviigunkani Iriniane Tasorintsi oga ikenaigake yapakuaiganairo ikañoiganaara okyara tekyara inkematsatumaige. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pashini onti ikañoigakaro okitsoki parigigetankitsirira okitagigetakara okitsoki tovaseri. Ikemisantaigavetakaro Iriniane Tasorintsi, ");
INSERT INTO mcbNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kantankicha irorokya imaigavai isureigavaarora magatiropage timagetatsirira kipatsiku, aikiro ishineventaigavaari koriki ontiri aikiro posantepage arakintsipage. Tenige isuretakoigaemparo Iriniane Tasorintsi, ontitari isureiganaka irashintaarantaigakempara. Tyampa inkantaigakempa inkematsatasanoigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kantankicha aiño pashini ikonogagarantaigaka onti ikañoigakaro parigigetankitsirira okametipatsatakera kipatsi. Ikemisantaigakero Iriniane Tasorintsi ikematsatasanoigakero, impo ariompatyo ikematsatasanoiganakerori. Ikonogagarantaigaka itimaigake kameti ikañoigakaro turigo timankitsirira okitsoki 30. Pashini ikañoigakaro timankitsirira 60. Pashinikya pairotyo yavisaigake itimagantsivageigakera kameti ikañoigakaro timankitsirira okitsoki 100.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ikantaigakeri aikiro: “Antari yogimataganira mechero ¿matsi ario itatakotunkani kovitiku? ¿Matsi ario yovirinitakotunkani otapinaku menkotsi omagantaganirira? Teratyo. Ontityo yovitakotagani menkotsiku kameti inkoneagitetagakeroniri magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ario okañotaka tatarika oita managetankicharira maika impoginityo ogikoneatakenkani. Aikiro tatarika oita terira ogotenkani maika impoginityo ogotakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ikantaigakeri aikiro: “Kemisantasanoigena nonkantaigakempira maika. Garika pikemisantasanoigana garatyo pogotasanoigi. Yogari kemisantasanoigakenarira pairotyo irogotasanoigakero, aikiro irimutakoigakeri Tasorintsi atanatsiniri irogotasanoiganakero nonkantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yogari kemavakerorira Iriniane Tasorintsi irirori irogotagakeri ariompaniri inkemasanotanakerori. Irirokya terira inkoge inkemavakerora ariompatyo imagisantanaerori magatiro ikemavetakarira, tesakonatari irogotasanotenika.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ikantaigakeri aikiro: “Maika nonkamantaigaempi aikiro tyara onkantanakempa impegakempara Tasorintsi Igoveenkariegite matsigenkaegi. Iatake paniro matsigenka iokagisetakero turigoki pakarara pakarara itsotenkavagetanakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Antari yagatanaira iatai ivankoku. Impo otovaigagitetanakera tsikyatatyo otsorogagitanake irorori oshivokanakera. Irirori teratyo irogotavakero tyarikatyo okantanaka oshivokanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tsikyatatari oshivokake kipatsiku otimanake okii, impo okimotanake otimanake okitsoki. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Antari osampatanakera iatake yovatuakotakerora yamanakerora, sampataketari.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ikantaigiri aikiro: “¿Maika tatoita okañotakaro ipegakara Tasorintsi Igoveenkariegite matsigenkaegi? ¿Tatarikatyo nonkañotagakemparo? ");
INSERT INTO mcbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Onti nonkañotagakemparo okitsoki mosetasa. Ogari okitsoki mosetasa pairotyo avisavetaka otsirepekichotakera avisagetakerora pashinipage tsiripekichogetatsirira okitsoki, ");
INSERT INTO mcbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kantankicha opankitaganira oshivokanake okimovagetanake onanake omarane avisagetakero pashinipage pankirintsipage. Otsegororoitanake okañotanaaro inchato itimantaigaaro tsimeripage.” ");
INSERT INTO mcbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ario ikañoigakeri maika Jeso yogotagaigakerira Iriniane Tasorintsi ikantakogetakero posantepage, kantankicha tera pairo irovashigakoigempari kameti isureigaemparoniri tyatirika ikemaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tera irogotagaigeri kogapage, tatarika ikogake irogotagaigakerira onti ikantakogetakero. Kantankicha antari intaganira itentaigakari irogamereegi ario pinkante ikamantasanoigakeri magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Impogini ishonkanaara poreatsiri ikantaigiri irogamereegi: —Tsame intati. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iniaiganairi patoitaigankicharira ikantaiganairi: —Maika atakena. Ikomaatakoiganairi irogamereegi igantagatari yomatetakara. Pashinikya giatakoiganairi. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Osamanitanake otampiamatanaketyo tampia jiriririri ogatyo okenake ovoresekantanaketyo oshatekaatanaka nia pitotsiku panikyatyo ontsitiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yogari Jeso magasevagetake otsitiku inagitotakaro nagitorintsi. Yogireaigutarityo ikantaigakerira: —Gotagantatsirira, ¿matsi tera pogote panikya aokajaigakempa? ");
INSERT INTO mcbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Itinaamatanakatyo inianakerora tampia ikantiro: —¡Peganaempa, intaga pitampiati! Iniiro aikiro inkaare ikantiro: —¡Maireatanae! Ogatyo okenake opeganaa tampia, ario okañotaka inkaare irorori omaireatanai. ");
INSERT INTO mcbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Impo ikantaigiri irogamereegi: —¿Antari gara pitsarogaigi? ¿Matsi tekya pogotasanoigero yagaveavagetira Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ariompatyo itsarogasanoiganakeri ikantavakagaiganakara: —¿Tyanimpatyora yoga, nerotyo okematsagematanakerira tampia irorori ontiri inkaare? ");
INSERT INTO mcbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Impogini yogonkeigapaakara intati yagatakoigapaake Jerasaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iroro yaguivetanakara Jeso ineiri ikenapaake paniro matsigenka itimagutakerira kamagarini iponiapaaka imperitanakiku yogantaganirira igamaga, ");
INSERT INTO mcbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ariotari itimiri kara. Tera tyani gaveimaterine irogusotakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yogusotantavetunkani karenatsa igitiku ontiri irakoku itimpatuagematirotyo kara ipitankagematirotyo tikn tikn tikn opatupatuivagetanake akatsitichaeginivati. Teratyo tyani gaveimaterine. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ikantakani yanuivageti kutagiteriku ontiri tsitenigetiku. Ikenagematanaketyo otishipageku ontiri imperitanakiku yogantaganirira igamaga, ikaemagematanaketyo eeee. Yagakero mapu tsoyampiri yogaraantanakarora ikiiro sei sei sei. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Irorotyo ineventakotavakarira Jeso ishigatetanakari itigeroaventapaakari. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Impo irirori inianakeri kamagarini ikantiri: —¡Kontetanae, pakuanaeri yoga! Iniamatanaketyo irirori imaraenkarikatyo kara ikantiri: —¡Eeee! ¡Jeso, Itomi Tasorintsisanorira timatsirira enoku, arionena gara tyara pikantana! Atsi garatyo patsipereakagana. ¡Tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Impogini ikantiri Jeso: —¿Tyara pipaita? Ikanti irirori: —Onti nopaita Tovainirira, tovainitari nonaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kantankicha atsi gara pitigankaigana parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ario inaigake shintori kara otishiku isekatavageigakara, itovaigavagetiratyo kara maganiro inaigake 2,000. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iniitaiganaatyo kamagarini ikantaigi: —Atsi ario pintigankaigakena nontimaguigakerira shintori. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yogari Jeso ikantaigiri: —Nanityo piaige. Igenanekyatyo ikonteigapanuti iokaiganairi itimaguigavetakarira irirokya iatashiigavetaka shintori. Iroro itimaguigavetapaakarira ogatyo ikenaigake ishigaiganaka otseraaku yanonkaiganaka iokaavioigaka pokorom pokorom pokorom, ipogereaigakatyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iroro ineaigavakerira sentaigiririra itsarogavageiganaketyo kara ishigaiganaka iaigai ikamantantaigapaakera anta itimaigira itsotenkavageiganakerotyo, ikemakotantaigavakaririra timaigatsirira kara intiegiri aikiro timageigatsirira parikotipageku. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iaigake inakera Jeso impo yogonkeigapaakara ineaigapaakeri itimaguvetakarira kamagarini pirinitake gagutaka manchakintsi kañotasanovagetaatyo ikyara, ogatyo ikenaigake itsarogavageiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yogari neaigakerorira magatiro ikamantaigavakeri tyara ikantakeri okyara yoneagaigakarira timaguigavetakaririra matsigenka, impo aikiro tyara ikantakeri itigankaigakerira itimaguigavetakarira shintori ovashi iokajaigaka. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Irorompatyo ikemaigakera ikamantaigakerira, iriroegi ikantaigakeri Jeso: —Nokogaigavetaka piataera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iroro yomatetanaara Jeso pitotsiku iriataera yogari itimaguvetakarira kamagarini ikantiri: —Nompoke naro. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kantankicha irirori ikantiri: —Gara pipoki. Ariompa piatae pivankoku pineaigapaakerira pitovaireegi pinkamantaigapaakerira tyara ikantakempi Tasorintsi itsarogakagakempira yoneaganontaimpira itimaguigavetakempira kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Irirori ikanti: —Je'ee. Impo iatai yanuivagetake ikamantageigapaakeri maganiro timaigatsirira kara Tekaporishiku. Iriroegi yogavageiganake kavako. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Impo yogonketaara Jeso intati yapatoventaigapaakari tovaini matsigenkaegi ovashi ipirinitake kara otsapiaku inkaare. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Itimake paniro jorio ipaita Jairo. Irirori inti tinkamitatsirira pankotsiku yapatoitantaigarira jorioegi. Iatake inakera Jeso yompatakaventapaakari ");
INSERT INTO mcbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ikantapaakeri: —Panikya onkamanake noshinto. Tsame pimpatikaituterora ogitoku oveganaempaniri ganiri okami. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yogari Jeso iatake yogiatanakeri ovashi yogiaiganakeri tovaini matsigenkaegi itsaiseventanakarityo kara ikanaroaiganakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ario onake aikiro kara paniro tsinane mantsigavagetankitsirira oseriintevagetanityo pairani ogatyo onakotanake 12 shiriagarini tera ogote ovegaempara, teranika onkaraagaenika oriraa. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atsipereimataketyo tovai kara yogavintanaigavetakarotyo gavintantaigatsirira teratyo ovegaempa ariompatyo oatiri niganki otsonkatasanotanakeri ogorikite ogasanotakatyo noganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Okemakotakeritari Jeso oatantakarira anta inakera irirori okonoitanakari aiñoniigakaririra okenashitapaakeri itishitaku otsagatakotapaakeri imanchakiku. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Oniasurentavagetakatari inkaara okanti: “Intagatityo nontsagavetakemparo imanchaki noveganaempatyo.” ");
INSERT INTO mcbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Irorotyo otsagatakotakerira ogatyo okenake okaraagapagenityo oriraa, oneavakatyo irorori ovegasanovagetanaara. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yogari Jeso yogotavaketyo yovegantaarora iragaveane ishonkanaka aikyara ipampogiaigakerira patoventaigakaririra ikanti: —¿Tyani tsagatakotakena nomanchakiku? ");
INSERT INTO mcbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iniaiganake irogamereegi ikantaigiri: —Pineavetakarityo yavinaavioiganakempira atanatsi pikantakera: ‘¿Tyani tsagatakotakena nomanchakiku?’ ");
INSERT INTO mcbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Irirori ariompatyo yoganakeri kavako ipampogianakera ineakeniri tyanirikatyo tsagatakotakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Irorori oshigekavagetanaketyo otsarogavagetanakera, oneaketari iroro tsagatakotakeri. Ariompa oshintsitanakeri oamatityo iriroku ompatakaventapaakari okamantagetakerira magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Irirori ikantiro: —Noshinto, maika pogotaketari nagaveakera novegaempira, nerotyo povegantaarira. Maikari maika piatae, pishinetakempara gatanika omatumataimpi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Impo aiñokyara iniiro ikenaigapaake pashini iponiaigaka ivankoku Jairo ikantaigapaakeri: —Matakaniroro kamake pishinto atanatsi poverairira Gotagantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kantankicha Jeso teratyo inkematsaigeri. Ishonkatetanakari Jairo ikantiri: —Gara pitsarogi, nagaveaketari noganiaerora pishinto. Intagatityo pinkematsatakena nokantakempira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Impo ikantaiganairi maganiro: —Gara pipokaigi. Intagani itentaiganaka Perero, Santiago intiri irirenti paitacharira Joan. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Antari yogonkeigapaakara ivankoku Jairo ikemaigapaakeri tsigempitareimataketyo iragaigakara kaemavaimataketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ikianake tsompogi ikantaigapaakeri: —¿Antari gara piragaiga? Tera ario onkame, onti omagake. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ogatyo ikenaigake ikavakavaimatanaketyo ikaavintsanaiganakerira. Ovashi yogikonteigakeri maganiro sotsi, intaganivani itentaa Jairo ontiri itsinanetsite intiegiri aikiro itentaiganakarira inkaara, ikiaiganake onoriakara irishinto. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ikatsavakotapaakero ikantiro: —Tarita, komi (onkantakera: “Ananeki, maika nonkantakempi tinaanae.”) ");
INSERT INTO mcbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Irorotyo iniakera ogatyo okenake otinaanaa okaviritanaa anuivagetanai. Irorori onakotake 12 shiriagarini. Iriroegi yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kantankicha Jeso ikantaigakeri: —Arisanora gara tyani pikamantumaigi ganiri tyani gotumatatsi. Impo ikanti: —Paigero osekatakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Impogini Jeso iatai itimavetara pairani itentaiganaari irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aganakara kutagiteri apishigopireantaganirira iatake pankotsiku yapatoitantaigarira jorioegi itsititanakera yogotagantanakera. Yogari kemaigavakeririra yogavageiganaketyo kavako ikantaiganake: —¿Tyarikatyo kara yogotakerora magatiro oka? ¿Tyani gotagakerira ario okañota maika? ¿Tyarikatyo ikantakara yagaveakera yovetsikagetakerora terira oneimagetenkani? ");
INSERT INTO mcbNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Matsi tera iriro yoga karipintero otomintakarira Maria? Yogari irirentiegi intiegitari Santiago, Jose, Jorashi intiri Sumo. Ario okañoigaka iritsiroegi iroroegi onti otimaigi aka, aneasanovageigirotari aroegi. Ovashi teratyo inkogaige inkematsaigakerira onti ikisaenkaigakeri ");
INSERT INTO mcbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ovashi ikantaigakeri irirori: —Yogari kamantantatsirira tyarika iatake parikoti ishineventavunkani, kantankicha antari inavetaka itimira teratyo irishineventenkani, ontityo ikisaenkatunkani, imaiganakatyo iitaneegi iriroegi aikiro tera irishineventaigempari. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ovashi tesakona irovetsikagete terira oneimagetenkani kara itimavetara. Intagati ipatikaiigakeri igitoku mantsigaigankitsirira yovegaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yogavagetaketyo kavako ineakera tera inkematsatumaigeri. Impogini Jeso iagetake choeniku kara itimageigira yogotagantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ikaemaigakeri maganiro irogamereegi ikantaigavakeri: —Maika nontigankaigakempi pinkenkitsavageigakera, kantankicha garatyo nogapuntagaigimpi paniro. Onti pagavakagaiganakempa piteni piaigakera parikoti, pashinikya piteni atankitsine parikoti, ovashi pintsotenkagiteavageiganakemparo magatiro kipatsi. Nagaveakagaigakempi poneagaigakemparira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gara tatakona pamumaigi. Gara pamaigi pitsagine, piseka intirika pigorikite. Intagati pamaiganake pigotikiiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pisapatoiganakempara, kantankicha gara pamaigi piteti pigamisate, intagatityo pamaiganake pogaguigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tyarika kara piaigake inkaemaitavakempirika pimagaigakera ivankoku, piaigaketyo pimagaigakera. Kantakani pimagimoigakerira kigonkero piaiganaera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Antari tyarika piaigake kara garikara ishineventaigavakempi, piaigaketyo parikoti, kantankicha oketyo pimpotevonkititasanoiganaemparo kipatsipane pagatikakoigakeririra, iroroniri ineantaigakempa onti pokaiganakeri piaigakera parikoti yovetsikaigaketari terira onkametite teranika iragaigavakempi irishineventaigavakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iriroegi iaiganake ikenkitsaiganakera ikantaigakerira maganiro: “Pakuaiganakero magatiro povetsikageigirira terira onkametite pinkantatigaiganakempara.” ");
INSERT INTO mcbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yoneagageigakari kamagarinipage, aikiro itiritantaigakari aseite mantsigaripage yovegaiganaa. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Maganiro ikemakoigakeri, nerotyo ikemakotantakaririra koveenkari Erorishi irirori, impo ovashi ikantake: —Atake yanianai Joan Giviatantatsirira, nerotyo yagaveavagetantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pashinikya kantaigankitsi: —Inti pairaninirira kamantantatsirira paitacharira Eriashi. Pashinikyatyo kantaiganankitsi: —Inti kamantantatsirira kañorira yogaegi kamantantaigatsirira pairaninirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Antari ikemaigakerira Erorishi ikantaigakera maika ikantake irirori: —Inti Joan notogitorenkakagantakerira pairani. Maikari maika atake yanianai. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Antari okyara irirotari Erorishi shitakotagantakeri Joan yogusotagantakerira karenatsaku ineakera ikantavitakerira Eroria yagapitsatakerira irirenti paitacharira Jeripe. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yogari Joan ikantakeritari Erorishi ikantiri: “Tera onkametite pagapitsatakerira itsinanetsite pirenti.” ");
INSERT INTO mcbNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ogari Eroria ovashi okisanakeri Joan okogavetakatyo irogakenkanimera, kantankicha tyampatyo onkantakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ipinkatsatakeritari Erorishi ineakerira inti kametiri tera inkañovagetumatempa, nerotyo ineasanotantakaririra ganiri tyara ikantagani. Antari ikenkitsavagetira Joan ikemisantasanotiri ishinevagetakatyo, kantankicha okonogaka yovankinavagetakatyo, tyampatyo inkantakempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Impogini agamatakatyo kutagiteri ogakagantantakemparirira. Ontitari agakara igutagiterite Erorishi. Irirori yonkotagantake posantepage sekatsi, impo ikaemaigakeri maganiro inampinaegi, intiegiri itinkamiegi isoraroegite, intiegiri aikiro maganiro tinkamiigatsirira timaigatsirira kara Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Impo isekatavageigakara okiapaake oshinto Eroria otosotapaakera oshonkashonkavagetanakatyo kara. Iroro ineakerora Erorishi intiegiri maganiro itentaigakarira isekataigakara ishineventaiganakarotyo. Impo ikantiro: —Maika nevitena tatarika pikogake, naro nompakempirotyo. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ikantairo aikiro: —Maika nonkantakempi arisanotyo nompakempiro magatiro tatarika pinevitakena garatyo namatavitumatimpi. Kañotari pinevitenara nompagarantakempirora nashintagetarira nompagarantakempirotyo. Namatavitakempirika nonkamaketyo. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Irorotyo okemavakerira okontetapanuti oatake okantakerora iniro: —Ina, ¿tatarikatyo nonevitakeri? Irorori okantiro: —Atsi irorompatyo pinevitakeri igito Joan Giviatantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Irorori ogenanekyatyo okiitanaatyo aikiro inakera Erorishi okantiri: —Onti nokogake pintogitorenkakagantakerira Joan Giviatantatsirira oyagakenkanira igito peratoku pimpakotakenarora. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ogatyo ikenake irirori ikenkisureanaka, kantankicha matakatari ikantakero, aikiro ikemaigakeritari maganiro ikaemaigakerira, tyampatyo inkantakempa inkantatigaerora ");
INSERT INTO mcbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ovashi itigankake paniro soraro iriatakera anta yashitakotunkanira Joan intogitorenkakiterira iramakotakenerora igito peratoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Iatake itogitorenkakitiri impo yamakotakenero ipakotapaakero, irorokya gishonkakotakenero iniro. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Antari ikemakoigakerira irogamereegi iaigake yagaiganairi yamaiganairira ikitaigairira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Impogini ipigaigaa iritigankaneegi Jeso ikamantageigapaakeri magatiro yovetsikageigutirira anta ontiri magatiro yogotagantaigutirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yogari Jeso ikemaigavakerira ikantaigiri: —Tsame anta parikoti pampishigopireaigakempara. Intagani viroegi nontentaiganake, gara iaigi pashini. Ineaigaketari inaigavetakara kara tyarika, pokanatsityo pashini, teratyo irapakuimaigeri impitaigakera kogapage isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Impo Jeso itentaiganakari yomateiganakara pitotsiku iaiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kantankicha irorotyo iaigavetanakara ineaigavakeri pashini matsigenkaegi ikantaiganake: —Neri yonta, inti Jeso. Nerotyo iaiganake iriroegi aikiro yanuiiganake iketyo gonkeigankicha. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Impo yogonkeigapaaka yagatakoigapaakera. Iroro yaguivetanakara Jeso ineaigapaakeri patovageigamatakatyo matsigenkaegi kara itsarogakagaiganakari maganiro, ineaigakeritari paniro yapuntavageigaka yatsipereavageigake kañoigamatakatyo ovisha terira intime sentaigiririra, ovashi itsititanakero yogotagaigapaakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Impo inanaira poreatsiri shavini yogari irogamereegi ikantaigiri: —Atake ishavitanai poreatsiri. Akari aka tera tyani timatsine. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pakuaigaeri maganiro yogaegi iriaigakera anta otimagetakera pankotsipage kameti impunaventavageigakeniri isekaegi isekataigakempara. Akari aka mameritari tatampa irogaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kantankicha Jeso ikantaigiri: —Paigerityo viroegi isekataigakempara. Iriroegi ikantaigiri: —¿Matsi ario nagaveaigake noaigakera nompunaventaigakitera 10,000 pan nontsotenkaigakerira nompaigakerira isekataigakempara? ");
INSERT INTO mcbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Impo ikantaigiri Jeso: —¿Akatovainivati onake pan pashiegi? Atsi piaige kamosoigutero akatovainivatirika onake. Ovashi iaigake ikamosoigutirora impo ipigaigaa ikantaigapaakeri: —Aityo 5, intiri shima pitenivani. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Impo irirori ikantaigakeri maganiro impitaigakera shimpenashiku kantankicha onti irashirikogeigake impirinigeigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iriroegi ipirinitaigake ikonogaigaka ipitaigake inaigake 100, pashini inaigake 50. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Impo yogari Jeso inoshikakero pan intiri shima yapagotakeri ineventanaka enoku iniakerira Tasorintsi ikantiri: “Apa, noshinevagetakatyo maika pipakenara nogaigakemparira.” Impo ikotagakero pan ipaigakeri irogamereegi, iriroegikya paigakeri maganiro. Ario ikañotagakari shima irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Isekataigaka maganiro ikemaiganaka, ");
INSERT INTO mcbNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","impo yogari irogamereegi yapatoigairo aityokyarira onai yoyagaigairo tsivetaku shatekapagerikatyo kara onakotake 12. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Maganiro sekataigankicharira ikaravageigaketyo 5,000, kantankicha intagani yogotunkani surariegi antariniegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Impogini yogari Jeso ikantaigiri irogamereegi: —Mateiganaempa pitotsiku piivaiganaera pimonteaiganaempara intati Vetsairaku. Narori gatata nopoki, tsikyata noneaigavaeri yogaegi iriaigaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Impo iaiganaira maganiro, irirori iatake otishiku iniakerira Iriri, paniro yapuntanaka. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Antari ochapinitanakera yogari irogamereegi inakovageiganake nigankia kara. Yogari Jeso aiñokya otsapiaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Irirori ineventakoigakari ipomirintsinaigakarora ikomajaigakerora ishigopigeiganake, otampiavagetanaketari tampia jiriririri ogipigipitakoigavakerityo. Impo osariagitetanaara kutagiteri ipokapaake yanuiatapaakero enokua iravisaiganakerimera. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yogari irogamereegi ineaigutarityo yanuiatapaakerora enokua nia ikaemavaitaigamatanaketyo: —¡Inaa! ¡Inaa! ¡Neri yoga kasuvarerini! ");
INSERT INTO mcbNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maganirotari ineaigakeri itsarogavageiganaketyo kara, kantankicha irirori ikantaigiri: —¡Nanti! ¡Gara pitsarogaigi, shineiganaempa! ");
INSERT INTO mcbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Impogini ovashi yomatetanaa, ogatyo okenake tampia asatyo opeganaa. Iriroegi yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ineaigavetanakarityo inkaara yogitovaigakenerira pan tovaini matsigenkaegi, kantankicha tera irogoige tyara ikantakara irirori yagaveavagetakera magatiro, kañomataka tenirikatyo ontimaige isureegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Impogini imonteaiganaka intati iaigake Jenesareku. Irorotyo yagatakoigapaakera ");
INSERT INTO mcbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","yaguitaiganakera maganirotyo yogoigavairi inti Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nerotyo iatantaigakarira yapagiteavageiganakarora yagageigutirira mantsigaigankitsirira ikompitakoigapaakeri yamaigakenerira irovegaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tyarika kara iatakera Jeso itimageigira ineaigapaakeri mantsigaigankitsirira yovitunkani kara avotsiku. Ikantaigavakeri: —Notinkamii, nokogake nontsagatumaigakerora okaratsaiku pimanchaki. Impo maganiro tsagatakoigakeririra yovegaiganaa. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Impogini ipokaigake pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi, iponiaigapaaka Jerosarenku yapatoventaigapaakarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Impo ineaigapaakeri irogamereegi ikonogagarantaigaka isekataigaka kogapage tera inkivakoigempa inkañoigakerora ikantaiganakerira yashikiiganakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ikantaigaketari iriroegi pariseoegi intiegiri aikiro maganiro ishaninkaegi garika ikivakoiga irisaankaigakempara okitsitinkaigakerira tatapagerika oita gara isekataiga, yogiatakoigakeritari yashikiiganakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aikiro iaigira opimantagetaganira arakintsipage ontiri ogagetaganirira ipokaigai ikaataigapaake. Garira ikaataigi gara isekataiga. Aikiro posante yogiatakoigakeri yashikiiganakeririra pairani ikivaigirora yoviikantaigarira, koviti ontiri aikiro asuronakipage isekatantaigarira.) ");
INSERT INTO mcbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Impogini yogari pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigiri Jeso: —¿Tyara ikantaigakara pogamereegi tera intsatagaigero magatiro ikantageiganakerira yashikiiganakairira? Pine omirinka isekataigara tera inkivakoigempa inkañotagaigakerora ikantaiganakerira, onti isekatakoigakaro irako okitsitinkakerora tatapagerika oita. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Irirori ikantaigiri: —Viroegi onti pikematsatamampegaigaka kogapage. Ikantasanotakeniroro kamantantatsirira Isaiashi itsirinkakoiganakempira pairani ikanti: ‘Iriroegi ikantaigavetaka: Tasorintsi inti pairorira ikametivageti, kantankicha ontityo ikantamampegaigaka kogapage, teratyo arisano isuretakoigena. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aikiro ikantaigavetaka: Tasorintsi inti Atinkamiegi, kantankicha onti yogotagantaigi isureigakarira matsigenkaegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Viroegi ontitari tera pintsatagaigero ikantagetakerira Tasorintsi onti pogiatakovintsaigake yogotagantaigirira yashikiiganakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ikantaigiri aikiro: —Arioniroro pikañoigaka maika kameti pogiatakoigakeriniri yashikiiganakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pineaigavetakarotyo ikantakera Moiseshi: ‘Pimpinkatsaigakerira piri ontiri piniro gara pipugatsanaigari.’ Aikiro ikanti: ‘Yogari kisashitakemparineririra iriri ontirika iriniro irogakenkanityo.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kantankicha viroegi onti pogagaigakero. Pine maika aiñoegi tomintaigacharira kogakovageigankicharira ikantaigavetakari itomi intsarogakagakemparira impaigakerira ikogakoigakarira, kantankicha viroegi onti pikantaigake kametitake inkantakerira: ‘Gara nagavei nopaigimpira pineviigakenarira, magatirotari nashintagetarira onti korova.’ (Ogari korova onti onkantakera: “Nashintakagakarira Tasorintsi”.) ");
INSERT INTO mcbNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ikantakerika korova viroegi pikantaigake gara ipiri iriri ontirika iriniro. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pikañoigakerora maika onti pokaiganakero ikantakerira Tasorintsi, irorokya pipampiatakoiganake yogotagantaigirira yashikiiganakempirira pairani. Kantankicha tera patiro onake oka, piposanteiganakara aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Impo ikaemaigairi aikiro maganiro yapatoitaigairi ikantaigiri: —Kemisantasanoigena maganiro viroegi pinkemasanoigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tatarika oita ogakogetagani teratyo onkitsitinkante suretsiku. Ogari pinkante oniagisevagetaganirira posantepage irorotari kitsitinkantagetatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Impo iokaiganakeri maganiro ikianake pankotsiku. Yogari irogamereegi ikantaigiri: —¿Tata pikantakotake inkaara? ");
INSERT INTO mcbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Irirori ikantaigiri: —¿Teratyo pinkemaigena viroegi aikiro? ¿Matsi tera pinkemaigero nokantaigakempirira nokantakera tatarika yogageiga matsigenka garatyo okitsitinkiri isureku? ");
INSERT INTO mcbNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tera ario oatenika sekatsi suretsiku, ontitari oyagaka segutontsiku impogini oshitakotaagani. Onti ikantaigakeri maika kameti irogoigakeniri magatiropage ogagetaganirira tera onkitsitinkante. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ikantaigiri aikiro: —Ogari pinkante isuregisevageigarira posantepage irorotari okenantagetarira yovetsikagisevageigirira ontiri iniagisevageigirira, irorotari kitsitinkantatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Antari suretsiku ariotari oponiagetari posantepage, inoshikaigirora tsinane terira osuraritakoige, ikoshiigira, yogantaigira, inoshikaigirora tsinaneegi suraritakoigatsirira, ");
INSERT INTO mcbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","inintutaigirira yashintageigarira pashini, ipiriniventavageigirora terira onkametite, yamatavitantaigira, yovetsikageigamatityo posantepage ovegagapage, ikisaviigirira itovaire ineakera pairora yagaveavagetake, iniashinaigarira itovaire, yaventakovageigara, tera irogoige inegintevageigempara. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Magatiropage oka posantepage onti oponiaka suretsiku, irorotari kitsitinkantagetatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Impogini iatai Jeso Tiroku ario ipitapaake pankotsiku. Tera inkogavetempa ineavakenkanira, kantankicha teratyo, ineavunkanityo. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Impogini otimake paniro tsinane terira iroro joria, onti omechoti Suropenishiaku. Aiño oshinto tekya antarote, itimagutakero kamagarini. Irorompatyo okemakotavakerira Jeso oatake onkamosotakerira. Okenapaake ompatakaventapaakari okantiri: —Notinkamii, nokogavetaka poneaganontaemparora noshinto itimagutakerora kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kantankicha Jeso ikantiro: —Iketyo sekataigankichane ananekiegi, tera onkametitenika iragapitsaigakenkanira iseka iriroegi impakenkanira otsiti. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Irorori okantiri: —Notinkami, arisanoniroro pikantasanotakeniroro, kantankicha otsiti ineira isekataigara ananekiegi ishiganaka itimashitavakerora ashiriverokitanakara iseka yogaverokitavakarora. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Irirori ikantiro: —Pikantasanotakeniroro. Maika pikantaketari atsi piatae, mataka kontetanai kamagarini timaguvetakarorira pishinto. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Oatai ogonkevetapaaka ovankoku oneapaakero oshinto noriaka omagira, tenige intimagutaero kamagarini, atake ikontetanai. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iatanai Jeso iponianaa Tiroku ikenanaira Suronku ontiri aikiro Tekaporishiku, yogonkevagetaa inkaareku Garirea. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Impogini yamaiganakeneri pashini surari terira inkeme, aikiro tera iriniagantsite, ikantaigakeri impatikaitakerira igitoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yogari Jeso itentanakari parikoti ipatsogantakero igempita, aikiro yorevakotaka itsagatakerora inene. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Impo ineventanaka enoku yovesureanaka inianake ikanti: —“¡Epata!” (onkantakera: “¡Kemanake!”) ");
INSERT INTO mcbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Irorotyo ikantakerira ogatyo ikenake ikemanake, aikiro iniagantsitanake. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Impo ikantaigakeri Jeso maganiro: —Gara tyani pikamantumaigi. Kantankicha ariompatyo ineaigakera ikantaigakerira gara tyani ikamantumaigi ariompatyo ikamantantaiganakerori. ");
INSERT INTO mcbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yogavageiganaketyo kavako maganiro ikantaiganake: “¡Yogari yoga yovetsikagematityo posantepage kametiripage ikemakagagematirityo terira inkeme, aikiro iniakagagematirityo terira irinie!” ");
INSERT INTO mcbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Impogini yapatoventaigapaakari Jeso tovaini matsigenkaegi, ikantakani ipiriniventaigakeri niganki itsonkatakoiganaka isekaegi tatampatyo irogaigaempa. Impo ikaemaigakeri irogamereegi ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Notsarogakagaiganakari yogaegi, noneaketari ipiriniventaigakena aka mavati kutagiteri niganki itsonkatakoiganaka isekaegi. Maikari maika mameri tatampa irogaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Antari nontigankaigavetempari iriaigaera ivankoku ontirorokari agaiganakeri itasegane avotsiku, ikonogagarantaigakatari iponiageigamatakatyo samani. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Impo ikantaigiri irogamereegi: —Akari aka tera tyani timatsine. ¿Ario tyara agakenkanira kara pan impaigakenkanira isekataigakempara maganiro inkemaigakempara? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ikantaigiri irirori: —¿Akatovainivati onai pan pamaigakerira? Ikantaigi: —Intaganivati onai 7. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yogari Jeso ikantaigakeri impirinitaigakera maganiro, impo yagagetanakero pan yapagogetanakero inianakeri Tasorintsi ikantiri: “Apa, noshinevagetakatyo pipakenara oka noseka.” Impo ikotagakero ipaigakeri irogamereegi, irirokyari paigavakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Impo aiño aikiro piteni shima ityomiaegini. Yogari Jeso yapagogetakeri iniairi aikiro Tasorintsi, impo ikantaigakeri irogamereegi impageigakerira maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Isekataigaka maganiro ikemaiganaka. Ogari aityokyarira onai yoyagaigairo irogamereegi tsivetaku onakotai 7. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maganiro sekataigankicharira ikaravageigaketyo 4,000. Impo yapakuaigairi iriaigaera ivankoegiku. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Irirori yomatetanaa pitotsiku itentaiganaarira irogamereegi iaigake Tarimanotaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Impogini ipokashiigapaakeri Jeso pariseoegi ikantaigapaakeri ineakagaigakerira terira oneimagetenkani onkoneatakera anta enoku inkiteku. Iriroegi onti ikogaigake ineaigakerira arisanorikara opaitaka yagaveavagetira, nerotyo ikañotantaigakarorira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kantankicha irirori yovesureanaka ikanti: —Tyarikatyo ikantaigakara yogaegi maikanirira ikogaigakera ineakagakenkanira terira oneimagetenkani. Maika nonkantaigakempi garatyo noneakagumaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Impo yagatanakera iniaigakerira iokaiganairi yomatetanaa pitotsiku imonteaiganaara intati. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yogaegiri irogamereegi imagisantaiganakero pan iramaiganakera isekataigakempara, panivatisano onai pitotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yogari Jeso ikantakotakero yogotagantaigirira pariseoegi intiri Erorishi ikantaigiri: —Viroegi tsikyanira pogakoigarokari opoegantarira pan irashiegi pariseoegi intiri Erorishi. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iroro ikemaigavakerira iniavakagaiganaka ikantaigi: —Onti ineakera tera amaige pan, nerotyo ikantantaigakairira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yogari Jeso ineaigavakerira iniavakagaiganakara ikantaigutarityo: —¿Tyara okantakara pikantaigakera: ‘Onti ineakera tera amaige pan’? ¿Matsi tera pinkemaige? ¿Tekya pogoige? ¿Matsi tera ontimaige pisureegi? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Kogapage otimake pokiegi tera pineantaigemparo? Aikiro pigempitaegi, ¿kogapage otimake tera pinkemantaigemparo? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Matsi tenige pisureigaemparo pan onavetakara 5 nokotagagetakerora nopaigakerira 5,000 surariegi isekataigakempara? Impo papatoigairora aityokyarira onai, ¿akatovaiti onakotai tsivetaku? Iriroegi ikantaigiri: —Onakotai 12. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ontiri aikiro onavetakara pan 7 nogitovaigakero isekataigakara maganiro 4,000. Impo papatoigairora aityokyarira onai, ¿akatovaiti onakotai tsivetaku? Ikantaigiri: —Onakotai 7. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Impo Jeso ikantaigiri: —¿Matsi tekya pinkemaige? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Impogini yagatakoigapaakera iaiganakera Vetsairaku yamaigapaakeneri paniro terira inee ikantaigakeri intsagatakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yogari Jeso ikatsatanakeri itentanakari parikoti okaragetanakera pankotsipage. Yorenkantakari iava irokiku impo itsagatakeri ikantiri: —¿Oga pineake? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ipampogiageti ikanti: —Noneavetakari matsigenkaegi, kantankicha tera inkoneatasanoige onti ikañoigakaro inchato yanuitaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Imatairi aikiro itsagatairi irokiku impo ikamagutasanoti paa neagantsivagetake koneagitetasanovagetake magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Impo Jeso itigankairi ivankoku ikantavakeri: —Gara pikenanai Vetsairaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Impogini iatanake Jeso itimageigira pashinipage ochoenitakogetakarora apatotara pankotsi paitacharira Sesarea Piripo itentaiganaari irogamereegi. Antari avotsiku ikantaigiri: —¿Tyara ikantaigana maganiro matsigenkaegi? ");
INSERT INTO mcbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iriroegi ikantaigiri: —Ikonogagarantaigaka ikantaigake: ‘Inti Joan Giviatantatsirira.’ Pashini kantaigankitsi: ‘Inti Eriashi.’ Pashinikya kantaigankitsi: ‘Inti pashini kamantantatsirira pairaninirira yanianaira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Impo ikantaigiri: —Viroegiri, ¿tyara pikantaigana? Iniamatanaketyo Perero ikantiri: —Viro vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ikantaigiri: —Gara tyani pikamantumaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Impogini Jeso itsititanake yogotagaiganakerira irogamereegi ikantakotakara ikantaigiri: —Yogari Kañotasanotakaririra Matsigenka iratsipereavagetake. Yogari itinkamiegi jorioegi intiegiri itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi gara ikematsaigiri onti inkisashiigakempari. Impo ovashi irogakagantaigakeri, kantankicha omavatanakempara kutagiteri iranianae. Ikamantasanoigakeri kameti inkemaigavakeroniri. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iroro ikemavakerira Perero itentanakari antakona ikantavetanakarira gara ikañotiro maika, ");
INSERT INTO mcbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kantankicha Jeso ishonkatematanakarityo ikamaguiganakerira aikiro itovaireegi impo ikanomaakeri Perero ikantutarityo: —¡Virori Satanashi, piataenityo parikoti! Vintitakeni, teranika iroro pisuretakogetempa ikogagetirira Tasorintsi, ontitari pisuretakogetaka ikogageigirira matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Impogini ikaemaigairi irogamereegi intiegiri aikiro patoitaigankicharira kara ikantaigiri: —Tyanirika kogankitsine inkantakanira inkematsatasanotakena garatyo ipiriniventiro ikogagetirira irirori, ontityo inkantakani impiriniventavagetanakero nokogagetirira naro, aikiro iratsipereaventavagetakenatyo ontirika inkamaventakena. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tyanirika tsarogakagacha ikiiro tera inkoge iratsipereaventavagetakenara ikiirotyo kañotagantanankicha, intagatitari ikogake irovetsikagetakera tatarika ikogagetakerira irirori. Kantankicha yogari piriniventirorira nokogagetirira naro, aikiro inkamantaigakeri pashini tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi, iriro pinkante iriatake itimira Tasorintsi inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Intimavetakempatyo gaveankitsinerira irashintakemparora magatiro kipatsipagekutirira kantankicha impoginityo inkamanae iriatake morekariku, ¿matsi ario agaveake oganiakerira iaraki? Garatyo agaveimati. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Irashintagevetakemparotyo magatiro kantankicha garatyo yagaveimati impunaventakempara ganiri iati morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yogaegiri timaigankitsirira maika imagisantaigakeri Tasorintsisanorira pashinikya ipegageigake itasorintsite, aikiro ikañovageigaka, nerotyo tyanirika pashiventagakenane impinkaigakerira itovaire, aikiro ariorika inkañotagakero impashiventagakemparora nokantagetakerira ario inkañotakempa Kañotasanotakaririra Matsigenka impogini impigaatera impashiventagapaakemparityo irirori. Impigaetari impogini inkoveenkavagetapaakera inkañotapaakemparira Iriri ikoveenkavagetira intentaigapaakemparira isaankariite, ariotari ikañoigakari iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aikiro ikantaigiri: —Maika nonkamantasanoigakempi antari gatatara pikamaigi pinkonogagarantaigakempa pineaigakeri Tasorintsi inkoveenkatanakera viroegiku irogikoneatimoigakempirora iragaveane. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Impogini avisanakera 6 kutagiteri yogari Jeso iatake anta otishiku itonkoavagetanake. Intagani itentaiganaka Perero, Santiago intiri Joan. Impogini inaigakera anta katsiketyo iriroegi ineaigiri Jeso ikantatigimoiganakari. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ogatyo okenake imanchaki okovoreatanake okantanake porererere onkutavageteratyo kara, teratyo oneimagetenkani kamisa onkivenkanira onkutatakera onkañotakerora irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ineaigutarityo aratinkaigake Eriashi intiri Moiseshi itentaigakari Jeso iniavakagaigakara. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yogari Perero iniamatanaketyo ikantiri Jeso: —Gotagantatsirira, ¡matsi ariokonatyo anaigake aka! Atsi novashiigakera mavati pankotsi otyomiatirira, patiro pashi, patiro irashi Moiseshi, ogari omavatakemparira irashi Eriashi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kantankicha ontityo iniashitakaro kogapage, teranika irogote tyarika inkante, itsarogavageiganaketari iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Impo apamankakoigapaakeri menkori ikemaigiri inianake Tasorintsi arionika apatosegakara ikanti: “Yokari yoka inti Notomi, notasanovagetarityo kara. Maika atsi kemisantasanoigeri viroegi.” ");
INSERT INTO mcbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Impo ikamaguigavetaa mameri iraratinkaigaera, panivani inai Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Impo ipigaigaara yanonkaiganaara yogari Jeso ikantaigiri: —Gatata tyani pikamantumaigi oga pineaigakerira maika. Antari inkitareanaera Kañotasanotakaririra Matsigenka inkitavetakenkanira, ario pinkante pinkamantantaigakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iriroegi tera tyani inkamantaige, onti iniavakagaigaka ikantavakagaigakara: “Antari ikantakera inkitareanaera Kañotasanotakaririra Matsigenka inkitavetakenkanira, ¿tatarikatyo iniakotake? Teratyo nonkeme.” ");
INSERT INTO mcbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Impo ikantaigiri Jeso: —¿Tyara ikantakara gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigakera iketyo pokankitsine Eriashi? ");
INSERT INTO mcbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Irirori ikantaigiri: —Arisanoniroro ogari Itsirinkakagantakerira Tasorintsi okantake iketyo pokankitsine Eriashi inkenkitsatimoigakerira jorioegi inkantaigakerira inkantatigaiganakempara inegintetashiigavakemparira impogitapaankitsinerira, kantankicha antari itsirinkakotunkanira Kañotasanotakaririra Matsigenka, ¿tyara okantaka okantakera iratsipereavagetake, aikiro inkisakenkani? ");
INSERT INTO mcbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Maika nonkamantaigakempi mataka ipokuti Eriashi kantankicha iriroegi ikisaigavakeri iposantenaigakerira, ariotari okantakeri Itsirinkakagantakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Impogini yogonkeigaara inaigakera itovaireegi irogamereegi, ineimaigapaakerityo yapatoventaigakari tovaini matsigenkaegi, aikiro ario inaigake kara gotagantaigirorira itsirinkakotanakerira Moiseshi itentaigakarira iniavakagaigakara, irorokya ikantaigi irorokya ikantaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ineaigutarityo ikenapaakera Jeso ogatyo ikenaigake yogaiganake kavako. Maganirosanotyo ishigavioiganaka iriniaigavakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Irirori ikantaigiri: —¿Tatatyo piniaventaigakera? ");
INSERT INTO mcbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Inianake paniro ikantiri: —Gotagantatsirira, namavetakempiri notomi terira irinie itimagutakerira kamagarini ovashi ikañotagakari maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tyarika inake ipigatagairira ogatyo ikenake ituanai savi inorianaka ishimosegantanake, yatsikagisetanakero irai, impo yaratsikiigetanake. Nokantaigavetakari pogamereegi ironeagaigaemparira, kantankicha teratyo iragaveaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Inianake Jeso ikanti: —¡Ario pikantavageigaka viroegi tekyaenkatyo pogoigero iragaveane Tasorintsi, teranika pinkogaige pinkematsaigakerira! ¿Akasamaninivatirorokari nompiriniventaigakempi nantsipereakoigakempira? Iroroventi atsi maigakenarinityo aka. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yamaiganakeneri. Yogari kamagarini ineapaakerira Jeso ogatyo ikenake ishigekakaganakeri shige shige shige ovashi ituanake savi kipatsiku itiguronkasevagetanaka tigurori tigurori ishimosegantasetanake. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yogari Jeso ikantiri iriri: —¿Akatanake ishiriagakotaka itimagutakerira kamagarini? Irirori ikanti: —Atake itovaigakovagetanake, itimagutakeritari pairani ityomiakyanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Okonogaka onti yogituakeri tsitsipokiku isakasakavagetakeri, okonogaka ariokya yogituaatakeri oaaku iokaatakerimera. Maikari maika pagaveakerika viro atsi tsarogakagaigena poneaganontaemparira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ikantiri Jeso: —¿Tyara okantakara pikantakenara: ‘Pagaveakerika’? Yogari Tasorintsi pairo yagaveavageti. Tyanirika kematsatakerine inkantakera: ‘Jeeje, arisano yagaveavageti Tasorintsi’, irirori irogikoneatimotakeri iragaveane impakeri tatarika inevitakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Irorotyo ikantakerira Jeso iniamatanaketyo ikimoenkatanake ikanti: —¡Nokematsavetakatyo! Kantankicha maika nokogake pishintsitagakenara kameti nonkematsatasanotanakeniri. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Impo Jeso ineaigavakerira ishigateigapaakarira tovaini matsigenkaegi ikatimatutarityo kamagarini yoneagutarityo ikantiri: —Virotari kantakagakari, nerotyo tera inkeme aikiro tera irinie. Maika nonkantakempi piatae kontetanae, pakuanaeri yoka, garatyo pipigumataa pintimagutaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yogari kamagarini ogatyo ikenake ikaemanake eeee ishigekakaganakeri ikantanake shige shige shige ikontetapanuti iokanakeri noriaka kañomataka ontinirikatyo ikamake, nerotyo ikonogagarantaigaka ikantantaigakarira: —¡Ee kamake! ");
INSERT INTO mcbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kantankicha Jeso ikatsavakotakeri itinaakeri, ogatyo ikenake yaratinkanake. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Impo iatai Jeso pankotsiku itentaiganaari irogamereegi. Iriroegi ikantaigakeri: —¿Tyarika okantakara naroegi tera nagaveaige noneagaigakemparira? ");
INSERT INTO mcbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Irirori ikantaigiri: —Yogari kamagarini kañorira maika garira oketyo piniaigiri Tasorintsi garatyo pagaveimaigiri poneagaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Impogini iatai Jeso Kaperenaoku ikenanake Garireaku. Tera inkoge ineavakenkanira, ");
INSERT INTO mcbNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ikogaketari irogotagaigakerira irogamereegi impo yogotagaigakeri ikantaigakerira: —Yogari Kañotasanotakaririra Matsigenka iragakagantakenkani impo irogakagantakenkani, kantankicha omavatanakempara kutagiteri iranianae. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iriroegi tera inkemaigavakero ikantakerira, kantankicha teratyo tyara inkantumaigeri, yagamaavageiganakatari. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Antari yogonkeigapaakara Kaperenaoku iaigake pankotsiku impo yogari Jeso ikantaigiri irogamereegi: —¿Tatatyo oitara piniaventaigakera inkaara avotsiku? ");
INSERT INTO mcbNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kantankicha iriroegi ikemisantaiganake, ineaigaketari onti ikantavakagaigaka tyanirikatyo pairo yavisaigakeri itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yogari Jeso ipirinitanake ikaemaigakeri maganiro irogamereegi ikantaigiri: —Tyanirika kogankitsi pairora iravisavageigakeri itovaireegi tsikyatatyo inkogake irirori irimutakovageigakerira maganiro kañomataka irironirikatyo ironampiriaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Impo yagake paniro ananeki yogaratinkimoigakeri irogamereegi yavinatakeri ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Tyanirika kavintsaakerine ananeki kañorira yoka kañomataka nantinirikatyo ikavintsaake, nantitari ikematsatake. Kantankicha tera paniro naro inkematsate, inti ikematsatake aikiro tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Impo ikanti Joan: —Gotagantatsirira, chapi noneaigakeri paniro yoneagakari kamagarini, onti yaventashitakari pivairo. Kantankicha naroegi nokantaviigakeri, noneaigaketari tera intentaigae. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ikantiri Jeso: —Maika ganige pikantaviigairi. Tyanirika pineaigake ventakemparonerira novairo irovetsikakera terira oneimagetenkani, irirori gara ikenakagavakero iriniashitavaenara. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tyanirika terira inkisashiigajae onti ishineigakai. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maika nonkamantasanoigakempi tyanirika kavintsajaigakempine ineaigakempira vintiegi nogamereegi irishineventakempari Tasorintsi impo ovashi ineakotakemparo impakerira onkatinkatakeririra impogini. Intagatityo impaigavetakempi pimire irorotakenityo. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tyanirika kañovagetagakerine paniro yoka kematsatakenarira terira impaitumatempa inkisashivagetakenkanityo kara. Irorotari nonkantantaigakempirira ganiri ikañotiri maika oketyome irogatsatakotantakenkani itsanoku omarane mapu otononkantaganirira iramanakenkanira iokaatakenkanira otsompogiatira omaraaniku nia. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kañotari irorora kañovagetagakempine pako, ariometyo povatuakerome, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku garira otsivakumati. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aikiro kenitsi gara ikamumati ontiri tsitsi garatyo otsivakumati. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aikiro pivonkiti irorora kañovagetagakempine ariometyo povatuakerome, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku ");
INSERT INTO mcbNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","garira ikamumatai kenitsi ontiri tsitsi garatyo otsivakumati. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ontirika poki irorora kañovagetagakempine, ariometyo pinkitsogitakerome, pairotari okametitake pinegintetasanovagetakempara impo pinkamanakerika piatakera pintimimotakerira Tasorintsi, avisakero pinkañovagetakempara impo pinkamanakerika piatakera morekariku ");
INSERT INTO mcbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘garira ikamumatai kenitsi ontiri aikiro tsitsi garatyo otsivakumati.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kañotaka maika yamapiniiginirira piratsi intagaigakenerira Tasorintsi oketyo yovochaigakeri kameti ineakeriniri Tasorintsi kametitake, ompote irishineventakemparira. Ario ikañoigaka maganiro kematsaigiririra Tasorintsi iratsipereavageigake posante kameti irogoigakeniri intimagantsivageigakera kameti, impo Tasorintsi irishineventaigakempari. ");
INSERT INTO mcbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ogari tivi opochatira pairo okogasanotagani, kantankicha antari omasankatera ganigera opochatai, ¿matsi tyampatyo onkantaenkani kameti ompochatanaera? Maika viroegi pinkañoigakemparora tivi okantakanira opochati pinkantakanira pinkematsatasanoigakenara pantsipereaventaigakenara, aikiro kametikyara pagavakagaigakempa.” ");
INSERT INTO mcbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Impogini Jeso iponianaa Kaperenaoku iatanake Joreaku ontiri aikiro Pereaku intati Jororanku. Impo yogonketapaakara yapatoventaigutanaarityo aikiro tovaini matsigenkaegi ovashi yogotagaigairi. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Impo ikonogagarantaigaka pariseoegi naigankitsirira kara ipokaigapaake inkogakotagantaigakerira ineaigakera tyarikara inkantaigeri irirori, ontitari ikogaigavetaka inkemaigakerira inkantakera tatarika oita terira onkatinkatero ikantaigirira iriroegi kameti intsavetantaigakeriniri inkisakagantaigakerira, nerotyo ikantaigapaakeri: —¿Okantavitantagani iokakerora surari itsinanetsite? ");
INSERT INTO mcbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Irirori ikantaigiri: —¿Tyara ikanti Moiseshi itsirinkakotanakerora? ");
INSERT INTO mcbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iriroegi ikantaigiri: —Yogari Moiseshi ikanti yogari surari kogankitsinerira iokanaerora itsinanetsite impakero sankevanti onkantake: ‘Maika mataka nokanaimpi’, impo inkantakero oataera. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ikanti Jeso: —Yogari Moiseshi ontitari ineakera tera pinkogaige pinkematsaigerira Tasorintsi, nerotyo ikañotantaigakempirorira maika itsirinkaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kantankicha antari okyasanokyara yovetsikagetake Tasorintsi magatiro ‘yovetsikakeri surari ontiri tsinane.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nerotyo yogari surari gankitsinerira tsinane iokanakeri iriri ontiri iriniro iriatakera iragakerora inkantakani impanirotanakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Antari okyara tekyara iragero piteni inaigavetaka, kantankicha antari yaganakerora oga ikenake itentaganakaro kañomataka panironirikatyo inai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nerotyo yogari surari gankitsirira tsinane garatyo iokumatiro, tenigetari irapiteigaempa, kañomatakatari panironirikatyo inai, ineaketari Tasorintsi yagakerora ikanti maika tera onkametite iokanaerora, kantakanityo iragakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Impo iaigakera pankotsiku ikogakotagantasanoigakeri irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Irirori ikantaigiri: —Tyanirika okanakerone itsinanetsite pashinikya iragake onti ikañovagetaka, iokanakerotari oketyorira yagavetaka impo yagake pashini. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ontirika tsinane okanakerine ojime pashinikya agake, ario okañotaka irorori onti okañovagetaka. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Impogini ipokaigake pashini yamaigapaakenerira Jeso ananekiegi impatikaiigakerira igitoku. Yogari irogamereegi ineaigavakerira yamaigapaakerira ikantaviigavakeri ikantaigiri: —Maiganaeri parikoti, gara poverajaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kantankicha ineakera Jeso itigankaigairira ikisamatanakatyo ikantaigiri: —Atsi arionenityo iripokaigakera naroku, ishineventaigaritari Tasorintsi impegakempara Igoveenkariegite kañoigaririra yogaegi ananekiegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nonkamantasanoigakempi pinkematsatasanoigakerira Tasorintsi pogiakovageigakemparira pinkañoigakemparira ananekiegi ikematsavageigirira tomintaigaririra yogiakovageigarira. Antari garika pikañoigiro maika garatyo ipegumata Tasorintsi Pigoveenkariegite ovashi gara pineimaigi pintimimoigakerira impogini irapatoitaigakerira maganiro kematsaigiririra impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Impo yavinaigakeri ananekiegi ipatikaiigakeri igitoku iniaventaigakeri inkavintsajaigakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Antari iatanaira Jeso ineiri ikenapaake paniro matsigenka ishigatetapaakari itigeroaventapaakari ikantiri: —Gotagantatsirira, pairo pikametiti. Atsi kamantena tyara nonkantakempa kameti nonkantakanira nontimake. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ikantiri Jeso: —¿Tyara okantakara pikantakenara: ‘Pairo pikametiti’?, mameritari pashini kametitasanotatsinerira, panirotari ikantara Tasorintsi ikametitira. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pogotakerotari magatiro itsirinkakotanakerira Moiseshi okanti: ‘Gara poganti, gara piatashitiro tsinane, gara pikoshiti, gara pitsoeventari pitovaire, gara pamatavitanti, pimpinkatsaigakerira piri ontiri piniro gara pipugatsanaigari.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Irirori ikantiri: —Gotagantatsirira, arioniroro nokañotari maika notsititanakero notsatagasanotanakerora notyomiakyanira ovashi maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ipampogiamatanakerityo Jeso itsarogakaganakari ikantiri: —Maika ontivani piatakera pimpimantagetakerora magatiropage pashintagetarira pagantakemparora koriki pimpaigakerira kogakoigankicharira impo pimpokake pogiavagetanakenara. Impogini ariokya inkavintsaavagetakempi Tasorintsi enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ikemutatyo ikantakerira maika ikenkisureavagetanakatyo kara ovashi iatai ipiganaara, intitari shintavagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yogari Jeso ikamaguigakeri maganiro, impo ikantaigiri irogamereegi: —¡Okomuvagetaratyo kara irogavisaakotakenkanira shintavagetacharira impegakempara Tasorintsi Igoveenkarite! ");
INSERT INTO mcbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iroro ikemaigavakerira ikantakera yogavageiganaketyo kavako, impo ikantutaigaarityo aikiro: —Notomiegi, ¡okomuvagetaratyo kara irogavisaakoigakenkanira matsigenkaegi impegakempara Tasorintsi Igoveenkariegite! ");
INSERT INTO mcbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Matsi ario iragaveake kameyo inkianakera otsempokiku kitsapi iravisakerora aikyara? Garatyo yagaveimati. Irirompasanotyo shintavagetacharira intasanotakemparorika yashintagetarira garatyo yogavisaakotagani. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ikemaigutatyo irogamereegi ariompatyo yogasanovageiganakeri kavako ikantaigiri: —Iroroventi ¿tyanimpatyora irogavisaakotakenkani? ");
INSERT INTO mcbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ipampogiaiganakeri Jeso ikantaigiri: —Gara tyani gavisaakotumatacha tsikyata, intaganitari Tasorintsi gaveatsi yogavisaakotantira, teranika tatoita komutapitsatumatemparine irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Impo inianake Perero ikantiri: —Notinkami, naroegi nokaiganakero magatiro nashintaigavetarira nogiavageiganakempira. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ikanti Jeso: —Maika nonkamantasanoigakempi, tyanirika okanakerone ivanko intirika irirentiegi, iritsiroegi, iriniro, iriri, itomiegi, aikiro itsamaire, iriatakera impiriniventakerora notigankavitakeririra inkamantaigakerira pashini tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi ");
INSERT INTO mcbNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","impakenkani pashini ivanko aka kipatsiku ontovaigake ariorika onkaratake 100, aikiro intimaigae pashini irirentiegi, iritsiroegi, iriniro, iriri, itomiegi, itsamaire. Kantankicha inkisavitakenkani ineakenkanira ikematsatakenara. Impogini inkantakani intimake gara ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kantankicha ikonogagarantaigaka aiñoegi ineaigavetunkanirira maika yavisaigakerira itovaire, kantankicha iriroegikyatyo iravisaiganaenkani impogini. Iriroegikya ineaigavetunkanirira yavisaigunkanira maika, impogini iriroegikyatyo visantaiganaatsine. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Impogini iriroegi ikenaiganake avotsiku itonkoaiganake iriaigakera Jerosarenku. Iketyo ivatanankitsi Jeso, yogari irogamereegi yogiaigapaakeri yogavageiganaketyo kavako. Yogaegiri itovaireegi giaiganakeririra itsarogavageiganaketyo kara. Impo Jeso ikaemaigairi irogamereegi iriroku ovashi itsititanake ikamantageiganakerira tyarika inkantakenkani anta Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ikantaigiri: —Maikari onti atonkoaiganake aiganakera Jerosarenku. Antari anta agonkeigakemparika onti iragakagantakenkani Kañotasanotakaririra Matsigenka iramanakenkanira inaigakera itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi. Iriroegi inkantaigake: ‘Kante irogakenkanira.’ Impo iramanakenkani inaigira terira iriroegi jorioegi irogakagantakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iriroegi isamatsanaigakeri intoatoanaigakeri, aikiro impasapasaigakeri. Impo iragataiganakera ariokya inkentakoigakeri, kantankicha omavatanakempara kutagiteri iranianaetyo. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Impogini yaiñoniigapaakari Santiago intiri Joan, itomiegi Severeo, ikantaigiri: —Gotagantatsirira, nokogaigake pintsatagakerora nonkantaigakempirira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Irirori ikantaigiri: —¿Tatatyo oitara pikogaigakera pinkantaigakenara? ");
INSERT INTO mcbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ikantaigiri: —Onti nokogaigake nonkantaigakempira impogini pimpegakempara Igoveenkariegite maganiro nokogaigavetaka povirinitaigakenara pinampinaku, paniro pitankitsine pakosanoriraku, paniro pampateku. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kantankicha Jeso ikantaigiri: —Viroegi tera pogoigenika yogari pirinitankitsinerira nonampinaku pairotyo iratsipereavageigake aka kipatsiku, nerotyo pikantantaigakenarira maika. ¿Matsi pagaveaigake viroegi pantsipereaigakera pinkañoigakenara naro nantsipereakera? ");
INSERT INTO mcbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iriroegi ikantaigiri: —Jeeje, nagaveaigakeniroro. Ikantaigiri Jeso: —Pikantasanoigakeniroro pantsipereaigake pinkañoigakenara naro nantsipereakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kantankicha tera naro kantatsine tyani pitankitsine nonampinaku, intitari kantankitsi Apa pairani okyasanokyara. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Impogini yogari itovaireegi irogamereegi ikemaigavakera ikisaigamatanakerityo Santiago intiri Joan. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kantankicha Jeso ikaemaigakeri ikantaigiri: —Pogoigiritari viroegi yogari igoveenkariegite terira iriroegi jorioegi onti ipotetashivageigari itovaireegi. Ario ikañoigaka aikiro itinkamipage yomperaperaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kantankicha viroegi gara ario pikañoigiro maika. Tyanirika kogankitsine iravisaigakerira itovaireegi ontityo irimutakovageigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ario okañotaka tyanirika kogankitsine pairora iravisavageigakeri tsikyatatyo inkogake irirori irimutakovageigakerira kañomataka irironirikatyo ironampiriaegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kañotari Kañotasanotakaririra Matsigenka tera iroro iripokashite irogiakovagetakempara, ontityo ipokashitake irimutakotantavagetakera, aikiro inkamaventaigakerira maganiro kameti irogavisaakoigakenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Impogini yogonketapaaka Jeso Jerikoku itentaigapaakari irogamereegi. Antari iatanaira ariompatyo itovaiganakeri giaiganakeririra. Ario kara ipitake onampinapokiku avotsi paniro terira inee paitacharira Varitimeo, inti itomi Timeo. Irirori onti ipiriniventi inevitantavagetira koriki. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iroro ikemakotavakerira pokapaake Jeso Nasarekunirira ikaemamatanaketyo ikimoenkatanakera ikanti: —¡Jesoo, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ikantanaigavetakarityo itovaire: —¡Atsi kemisantenityo! Kantankicha irirori ariompatyo ikaemasanotanakeri: —¡Viro, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yogari Jeso asatyo yaratinkapaake ikanti: —Atsi kaemaigeri. Ikaemaigakeri ikantaigiri: —Nani, maika shinetanakempa, kaviritanake, ikaemakempitari. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ikavirimatanakatyo iokapanutiro iponaviotantakarira ishigatetanakarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Irirori ikantiri: —¿Tata pikogake? Ikanti: —Notinkami, onti nokogake noneanaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ikantiri Jeso: —Maika kametitake piataera, neaivitari, pogotaketari nagaveakera noneakagakempira. Ogatyo ikenake ineanai ovashi iatake yogiatanakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Impogini iaiganake ariompa ichoenitakoigapaakarori Jerosaren, kantankicha tekya irogonkeigempa, onti inaigapaake Vetaniaku. Ogari Vetania ontiri Vetipaje onti ochoenitakotakaro otishi Orivoshi. Impo yogari Jeso itigankaigake piteni irogamereegi ");
INSERT INTO mcbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ikantaigavakeri: —Piaige anta choeni itimageigira pineaigapaakeri kara paniro ashino akamotiakyanirira tsatakotaka, tekyaenka irishigakotantumatenkani. Pintsaakoiganakeri pamaigakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tyanirika kantaigakempine: ‘¿Antari gara pitsaakoigiri? ¿Matsi tyara pinkantaigakeri?’ viroegi pinkantaigeri: ‘Inti kogakotakari Atinkami, kantankicha paita irogipigaempiri.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ikantaigi: —Je'ee. Impo iaigake ineaigapaakeri tsatakotaka pankotsiku sotsimoroku onampinapokiku avotsi agavokiapaakara apipokitene ovashi itsaakoiganakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yogari pitaigankitsirira kara ikantaigiri: —¿Matsi tyara pinkantaigakeri? ¿Antari gara pitsaakoigiri? ");
INSERT INTO mcbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ikantaigi: —Intitari kogakotakari Atinkami, paita irogipigaempiri. Iriroegi ikantaigiri: —Nanityo, maiganakeneri. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Impo yagaiganakeri yamaiganakenerira Jeso ipashimititsaigakeneri imanchakiegiku ipaigapaakeri, impo irirori ipirinitantakari ishigakotantanakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yogaegiri giaiganakeririra ikonogagarantaigaka yovetsarankaashiigavakeri imanchaki avotsiku, pashinikya tovishiigavankitsi tsigaroshi ishitavokitashiigavakerira kameti inkenakotanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yogari ivaiganankitsirira intiegiri giaigapaakeririra ikaemageigamatityo kara ikantaigi: —¡Pairo ikametiti yogaa itigankakerira Tasorintsi impegakempara Agoveenkariegite! ¡Pairo ikavintsaavagetakeri Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Inkantakanityo inkavintsaavagetakeri yoga pegankichanerira Agoveenkariegite inkañotaerira Iravi ipegavetara pairani igoveenkariegite yashikiiganakairira! ¡Pairo ikametiti Tasorintsi timatsirira enoku! ");
INSERT INTO mcbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Impogini yogonketakara Jerosarenku ikiapaakera ivankoku Tasorintsi ipampogiagetakero itsotenkavagetanakero. Impo osamanitanake ikontetanai iatai Vetaniaku itentaiganaari irogamereegi, atanaitari poreatsiri shavini. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Impo okutagitetamanakera ipigaigamanaa Jerosarenku. Yogari Jeso itaseganake. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Impo ineventakotapaakaro igera timankitsirira oshi, irorotari iatantapanutarira inkamosotapanuterora ineiri aityori oi, kantankicha yagavetapaakaro aiñoni mameri, onti gotankicha oshi, tekyatanika agempanika otimantarira oi. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ikantutarotyo: —¡Maikari maika gara otimumatai pii! Ikemaigakeri irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Impo yogonkeigakara Jerosarenku ikiaigapaake ivankoku Tasorintsi ineaigapaakeri pimantavageigatsirira intiegiri punaventavageigatsirira. Yogari Jeso yoneagaigapaakari maganiro, aikiro itatsinkagetakero imesane yoginoriantaigakarira igorikiegite kampiavageigiririra koriki yogishonkagetakero. Imatakero aikiro ipirinitantaigakarira pimantavageigatsirira shiromega. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ikantaviigakeri gara yamumaigai tatarika oitapage tsompogi ivankoku Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Impo yogotagaigakeri ikantaigiri: —Okantake Itsirinkakagantakerira Tasorintsi okanti: ‘Ogari novanko onti ashi iripokapiniigera maganiro matsigenkaegi iriniaigakenara.’ Kantankicha viroegi onti pipegakagaiganakaro ipimantapiniigira matavitantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Impogini ikemakoigakerira itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ikogaigavetaka irogaigakerimera, kantankicha tyampa inkantaigakeri, ipinkaigakeritari ineaigakerira yapatoventaiganakarira maganiro yogavageiganakera kavako ishineventaigakarira yogotagantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Impo ochapinitanaira iatanai Jeso Vetaniaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Okutagitetamanaira tsitekyamani iaigaira Jerosarenku ineventakoiganaaro igera paa shigirikake kamasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yogari Perero isuretanaaro chapi ikantakerora Jeso gara otimumatai oi ikantiri: —Gotagantatsirira, atsi gero kavako onta igera pikantakerora chapi gara otimumatai oi, maikari kamake. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ikanti Jeso: —Jeeje, yagaveavagetitari Tasorintsi, kematsatasanoigeri viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Maika nonkamantasanoigakempi, tyanirika kantakerone oka otishi: ‘Piate okaatempa omaraaniku nia’, oataketyo okaatakempara. Kantankicha gara iniasurentavageta inkantakera: ‘Arisanorikatyo iragaveake Tasorintsi irogagakerora’, onti inkematsatasanotake inkantake: ‘Maika nogotake ikemakena Tasorintsi nokantakerorira otishi, maika oatake okaatakempara.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nerotyo maika nonkantaigakempi tatarika oita pineviigakeri Tasorintsi piniaigerira pogotasanoigakerika arisano impaigakempiro impaigakempirotyo. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Antari piniaigirira Tasorintsi aiñorika pikisaigakerira oketyo pimagisantakoigaeri tatarika oita yotsimaaviigakempi kameti irishineigaempiniri Piri timatsirira enoku imagisantaerora povetsikaigakerira viroegi terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kantankicha garika pimagisantaigiro yovetsikaigakerira tsipereakagaigakempirira, garatyo imagisantairo Piri timatsirira enoku povetsikaigakerira viroegi terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Impo yogonkeigakara Jerosarenku yogari Jeso ikianake ivankoku Tasorintsi yanuivagetake. Osamanitanakera ipokashiigapaakeri itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri aikiro itinkamiegi jorioegi ");
INSERT INTO mcbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ikantaigiri: —¿Tyani kantakempira pinkañotakerora maika poneagaigaemparira pimantavageigatsirira? ¿Tyanimpatyora tigankakempira? ");
INSERT INTO mcbNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yogari Jeso ikantaigiri: —Maikari maika narokya kogakotagantaigakempine, pinkamantaigakenarika viroegi ario nonkañotakempa naro nonkamantaigakempi tyani tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Tyani kantakeri Joan irogiviatantavagetakera? Maika viroegi kantaigena tyani kantakeri. ¿Irirorika kantakeri Tasorintsi intirika kantaigakeri matsigenkaegi? ");
INSERT INTO mcbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iroro ikemaigavakera iniavakagaigamatanakatyo ikantavakagaiganakara: “¿Tyarikatyo ankantaigeri? Ankantaigavetempari inti kantakeri Tasorintsi, irirori inkantaigakaetyo: ‘Iroroventi ¿tyara okantakara tera pinkematsaigeri?’ ");
INSERT INTO mcbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ariokya ankantaigavetempari inti kantaigakeri matsigenkaegi, inkisaigakaetyo atovaireegi.” Ineaigaketari maganiro matsigenkaegi ikantaigake inti kantakeri Tasorintsi inkamantantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nerotyo ikantantaigakaririra: —Nirorotyo, tyanirorokari kantakeri. Impo irirori ikantaigiri: —Iroroventi ariotyo nonkañotakempa naro, garatyo nokamantaigimpi tyani tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Impogini Jeso ikantakotantanake ikantaigiri: “Itimake paniro matsigenka yashintaka igipatsite. Impogini ipankishiatake ova itantakotakero. Impo yovetsikashitakero agaatantakenkanirira oani. Imatakero aikiro impirinitantakemparira enoku sentakeronerira kameti ineventakotasanotakemparoniri ganiri okoshitagani. Impo ikaemaigake pashini intsamaitakoigakenerira. Antari ontimanakerika impagarantaigaeri irirori. Impo iavagetake samani. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Impogini aganaara irakantarira ova itigankavetakari paniro iromperane ineviigaaterimera impagarantaigaerira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kantankicha yogari tsamaitakoigakerorira onti yagaigavakeri ipasapasaigakeri itigankaigairi kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Impo yogari shintarorira itigankai pashini. Irirori onti iposanteigavakeri ipasapasaigakeri igitoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Itigankavetaa pashini, ario ikañotagaigaari irirori ikisaigavakerira ovashi yogaigakeri. Impo itigankavetaa pashini tovaini, ario ikañotagaigaari iriroegi ikisaigavakerira. Ikonogagarantaigaka ipasapasaigakeri, pashini onti yogaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ipogereavageigutanakeri iromperaneegi panivani inai itomi, itasanovagetarityo kara. Impogini itigankamatirityo irirori ikanti: ‘Impa irirorakari nontigankake notomi, iriro pinkante impinkatsaigakerityo.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kantankicha iriroegi irorotyo ineaigavakerira ikenapaakera iniavakagaigamatanakatyo ikantaiganakera: ‘Neri yonta shintakemparonerira magatiro impogini inkamanaera iriri. Tsamekario agaigakerira kameti aroeginiri shintasanoigakemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Impo iroro yogonketapaakara yagaigavakeri yogaigakeri yovuokaigakeri antakona aikyara otantakotakara ova. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Maika ¿tyara pinkantaige viroegi? ¿Tyarika inkantaigakeri shintarorira igipatsite? Ontityo iriatashiigakiteri irogaigakiterira, pashinikyatyo inkaemaigae impugakagaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Matsi tera piniavantaigero Itsirinkakagantakerira Tasorintsi? Ariotari okantakeri maika: ‘Ogari mapu terira irishineventaigavetemparo vetsikaigakerorira pankotsi onti opegakagunkani okusotantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Irirotari kañotagakero maika Atinkami, impo aneaigakerora aroegi ashinevageigaka.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iriroegi ikogaigavetaka iragakagantaigakerimera, ikemaigavakeritari inti ikantakoigake, kantankicha ipinkaigairi patoigankicharira, nerotyo iatantaigaarira tera tyara inkantumaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Impogini yogari pariseoegi intiegiri tentaigaririra Erorishi itigankagarantaigake itovaireegi inakera Jeso inkogakotagantaigakiterira ineaigakera tyarika inkante, ikogaigaketari inkemaigakerira inkantakera tatarika oita terira onkatinkatero ikantaigirira iriroegi kameti intsavetantaigakeriniri inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iriroegi iaigake ikantaigapaakeri: —Gotagantatsirira, nogoigake viro tera pamatagumatempa, pogotagantavagetira tera tyani pagamaempa, tera pinkante: ‘Tsikyanira ikemaigikari pashini.’ Aikiro pineaigakeri matsigenka tera intimumate visakerineririra itovaire. Pineaigakeri imirinka ario ikañovakagaigaka maganiro. Pogotagantira katinka pogakero pikamantaigakerira tyara inkantaigakempa inkematsatasanoigakerira Tasorintsi. Viro pogotirotari ikantirira koveenkari Sesa ikantira: ‘Maganirosanotyo jorioegi impaigakena koriki.’ Maika ¿tyara pinkante viro? ¿Kametitake nompaigakerira ontirika tera onkametite? ¿Ario nompaigakeri ontirika gara nopaigiri? ");
INSERT INTO mcbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kantankicha Jeso yogotavaketyo tera kametikya inkantaigeri onti ishinetamampegaigakari kogapage, nerotyo ikantaigutarityo: —¿Tyara okantakara pikañovintsaigakenara maika? Atsi maigakenanityo pamentaniro koriki noneakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iriroegi yamaigakeneri, impo yagatakera ineagetakerira ikantaigiri: —¿Tyani yoka itsirinkakotunkanirira? Akari irapisotateneku, ¿tyani shintaro ivairo? Ikantaigiri: —Inti koveenkari Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ikantaigutarityo: —Iroroventi intitari tsirinkakotankicha Sesa paigerityo irirori kameti pintsatagaigakeroniri magatiro ikantagetakerira, kantankicha ariotyo pinkañotagaigakempari Tasorintsi aikiro pinkematsatasanoigakerira pintsatagaigakerora magatiro ikantagetakerira. Iroro ikemaigavakerira ikantaigakerira yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Impogini irirokya aigankitsi saroseoegi inkamosoiguterira Jeso. Iriroegi inti kantaigatsirira gara yaniaiganai igamaga. Ikantaigapaakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Gotagantatsirira, yogari Moiseshi itsirinkanake pairani ikanti: ‘Intimakerika matsigenka terira intomintempa impo inkamanakerika iokanakero itsinanetsite, aiñorika irirenti irirokya gaerone intomintagaemparoniri kañomataka irironirikatyo tomintari kamankitsirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maika nokogaigavetaka nonkantaigakempira. Pairani itimake paniro notovaire itomintaka 7. Yogari itsitiki yagavetaka tsinane, kantankicha niganki ikamanake tera intomintaganakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Impo irirokya gavetaaro irapitene giatiririra. Ario ikañotaka irirori ikamanake tera intomintaganakemparo. Ario ikañovetaka irapitene nigankinirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ariompa ipogereanakari maganiro yagaigavetakarora tera intomintagaigemparo. Impo okamamatityo irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Maika atsi kantaigena, antari impogini iraniaiganaerika maganiro igamaga, ¿tyanirikatyo gasanotaerone?, maganirotari yagaigavetakaro. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Irirori ikantaigiri: —Viroegi onti pikomuigakaro, teranika pogoigero tyara okanti Itsirinkakagantakerira Tasorintsi, aikiro tera pogoige tyara ikanta yagaveavagetira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Impogini iraniaiganaerika maganiro igamaga gatanika tyani gumataatsi tsinane, aikiro tsinane garatyo opimantumataagani iragaigakerora surari, ontitari inkañoiganakempari isaankariite Tasorintsi timaigatsirira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Maika viroegi onti pikantaigake gara yaniaiganai igamagapage. ¿Matsi tera piniavantakoigero itsirinkakotakerira Moiseshi pairani iniakerira Tasorintsi tankoku?, ikantaketari: ‘Nanti Tasorintsisanorira Itinkami Averan, Isaako intiri aikiro Jakovo.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¿Matsi tyara inkantakempara igamaga impegakerira Itinkami? ¡Garatyo yagaveimati! Intaganitari pegaigiri Itinkami niaigankitsirira. Viroegi onti pikomuigakaro. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ario inake aikiro kara paniro gotagantirorira itsirinkakotanakerira Moiseshi. Iroro ikemavakerira Jeso ikantaigakerira saroseoegi ineake onti ikantasanotake ovashi ikantiri irirori: —Ogari itsirinkakotanakerira Moiseshi ¿tyatityora pairo avisake okametitakera ontsatagasanotakenkanira? ");
INSERT INTO mcbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yogari Jeso ikantiri: —Ogari pairorira avisake okametitakera ontsatagakenkanira irorotari kantatsirira: ‘Atsi kemisantasanoigena viroegi iseraereegi. Yogari Atinkamiegi Tasorintsisanorira panirosanotyo inakera irirori, mameri pashini. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pintasanovagetanakemparityo pisuretasanotanakemparira, aikiro pimpanirotasanotanakerira irirori.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ogari apitene onti kantatsirira: ‘Pintsarogakagavagetakemparira pitovaire pinkañotagasanotakempatyo pitsarogakagara vikiiro.’ Mameritari pashini pairorira avisagetakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yogari gotagantirorira itsirinkakotanakerira Moiseshi ikanti: —Gotagantatsirira, arisanoniroro pikantasanotakeniroro, yogari Tasorintsisanorira inti panirorira inake, mameritari pashini. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Antasanovageigakemparira ampaniroiganakerira irirori, aikiro antsarogakagaigakemparira atovaire ankañotagasanoigakempara atsarogakagaigara aroegi, pairo avisake okametitakera oka, avisakero atagaiginirira Tasorintsi piratsi magamonkiniro ontiri aikiro apaigirira posantepage. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yogari Jeso ineakerira katinkara yogakero tera iriniashitemparo kogapage ikanti: —Irorotanaketyo irogavisaakotakempira Tasorintsi impegakempara Pigoveenkarite. Ovashi tenige tyani kogakotagantumataerine posante. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Antari yogotagantanaira Jeso ivankoku Tasorintsi ikanti: —Yogari gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigi: ‘Yogari Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite inti iyashikitanakerira Iravi.’ ¿Tyara okantakara ikantaigakera maika? ");
INSERT INTO mcbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yogari Iravi iniakagakeritari Isure Tasorintsi pairani ikanti: ‘Yogari Tasorintsi ikantakeri Notinkami: Pirinite nonampinaku nakosanoriraku pintentakenara kigonkero nagaveaigakerira maganiro kisashiigakempirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yogari Iravi irorotari ikantakerira: ‘Notinkami’, ¿tyara inkantakempara iyashikitakerira? Yogari patoventaigakaririra itovaigavagetityo kara. Antari ikemaigavakerira ishinevageiganakatyo. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Impo yogotagantanaira Jeso ikanti: “Tsikyanira pogiatakoigirikari gotagantaigirorira itsirinkakotanakerira Moiseshi, yogaguvintsaigarotari manchakintsi ariotsantsamagopagerikatyo kara kameti ineakagantaigakempaniri. Aikiro iaigira anta opimantagetaganira arakintsipage ontiri ogagetaganirira ikogaigake iriniaigavakenkanira inkañotagaigakenkanira iniaganira itinkamipage. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ario okañotaka aikiro iaigira pankotsiku yapatoitantaigarira ikogaigi iroviriniigakenkanira ipiriniigira tinkamiigatsirira. Ario ikañoigiro aikiro yapatovageigara isekataigakempara onti ikogaigi intentaigakemparira kaemantankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aikiro yamatavinaigakero ogamakotagapage itsonkatapitsageiganakerora ashintageigarira. Aikiro ineakagantaigakara akaenkinityo iniaiganakeri Tasorintsi teratyo aiñokya iragataige. Iriroegi pairotyo iravisaigake inkisashivageigakenkanira impogini.” ");
INSERT INTO mcbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Impo iatake Jeso ipirinitake katinka onakera yoyagantaganirira koriki ipunkanirira Tasorintsi. Ikamaguigakeri maganiro yoyagaigakera igorikite. Ikonogagarantaigaka shintavageigacharira yoyagageigamatityo tovaini. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Impo okenapaake paniro ogamakotaga terira ashintumagetempa oyagapaake pimentyakitenisano koriki. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ineakerora Jeso ikaemaigakeri irogamereegi ikantaigiri: —Maika nonkamantasanoigakempi ogari oga ogamakotaga terira ashintumagetempa ineakero Tasorintsi oyagake tovaini avisaigakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yogari iriroegi intitari yoyagaigake aiñokyarira inai, kantankicha irorori onti ogapuntareakeri maganiro ashintakarira agantaemparimera oseka. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Impogini ikontetanaira Jeso ivankoku Tasorintsi inianake paniro irogamere ikantiri: —Gotagantatsirira, atsi shonke. ¡Ojojoo tyarikarorokarityo, omarapagerikatyo mapu kara ontiri aikiro pankotsipage! ");
INSERT INTO mcbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kantankicha yogari Jeso ikantiri: —¿Pineakero magatiro oka? Arisano nonkantakempi impogini gara otimumatai patiro mapu vikotaachanerira, magatirosanotyo ogashiriagetakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Impogini itonkoaiganake iaiganakera otishiku Orivoshi okatinkatakotakero ivanko Tasorintsi, ario ipirinitake Jeso kara. Impo yogari Perero, Santiago, Joan intiri Anturishi yaiñoniigapaakari ikantaigapaakeri: ");
INSERT INTO mcbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Nokogaigake pinkamantaigakenara tyatirikara agantakempa ontsonkatantanaemparira inkaaratirira pikantakerira ogashiriagetakenkanira. ¿Tyatirikara nogotantaigavakempa ontsonkagetanaempara magatiro kipatsi? ");
INSERT INTO mcbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yogari Jeso ikantaigiri: —Tsikyanira yamatavinaitimpikari, ");
INSERT INTO mcbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","iripokaigaketari tovaini matsigenkaegi kantaigankitsinerira: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite’, impo inkematsaigakeri tovaini. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Pinkemakoigavakeririka pashini iromanatavakagaigakempara aiñoni, ontiri aikiro pashinipageku kipatsi gara pitsarogaigi. Arionirorotyo onkañotanakempari maika, kantankicha gatata aga ontsonkagetanaempara magatiro kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yogari timageigatsirira pashinipageku kipatsi iriatashiigakeri timageigatsirira parikotipageku iromanatavakagaigakempara. Ario inkañoigake koveenkariegi intimagarantaigake intigankaigakeri isoraroegite iriatashiigakerira pashini koveenkari iromanatavakagaigakempara irogavakagaigakempara. Aikiro ontininkagematanakempatyo kipatsi. Ontsonkagematanakempatyo sekatsipage antsipereavagetanakenkanityo tasegagantsi. Onkañogetanakemparika maika iroro ontsititantanakempa antsipereavagetanakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Tsikyanira papakuaiganaikari ganigera pikematsaigaana, iragaigakempitari iramaiganakempira pitinkamiegiku inkisakagantaigakempira impasapasatagantaigakempira pankotsipageku yapatoitantaigarira pitovaireegi. Aikiro iramaiganakempi inkisaigakempira koveenkaripage intiegiri inampinaegi Sesa. Impo viroegi pinkenkitsatimovageigakeri pinkamantakoigakenara naro. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oketyo inkenkitsatimovageiganakenkani maganiro matsigenkaegi inkamantaigakenkanira tyara inkantaigakempa kameti irogavisaakoigakenkaniniri, impogini ario pinkante ontsonkagetanaempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Antari iragaigakempira iramaiganakempira koveenkaripageku gara pisureigaro tyarika pinkantaige. Piaigakerika iriroegiku gatanika tsikyata piniashiigaro viroegi, intitari suretagaigakempine Isure Tasorintsi kameti pogoigakeniri tyara pinkantaige. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Inkonogagarantaigakempa intsoeventaigakempari irashisano irirentiegisano irogakagantaigakerira. Ario inkañoigakempa tomintaigacharira intsoeventaigakempari itomiegi. Pashinikyatyo inkisashiiganakempari iririegi irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maganirosanotyo inkisaviiganakempiro pikematsaigakenara, kantankicha yogari tyanirika tsipereakotanankichanerira garira yapakuimati ikematsatakenara ovashi inkamanake iriro pinkante irogavisaakotakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Antari pineaigakeririka yoga samatsanatakeronerira ivanko Tasorintsi ario irinake anta pinkatimaiganakempara pishigaiganakera otishipageku. Ario inkañoigakempa aikiro maganiro timaigatsirira Joreaku irishigaiganaketyo. (Tyanirika niavantakotakerone oka isuretakotakemparo kameti inkemavakeroniri.) ");
INSERT INTO mcbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tyanirika pitankitsine otishitapankoku ivanko irishigapanute garatyo ikiapanaati iragagetapanutera tatapagerika oita. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tyanirika pitankitsine itsamaireku garatyo iatapanaati ivankoku iragapanaatera apitene imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Maikaniroro antsipereavageige tsinaneegi kamonkiigankitsinerira ontiri tsomitagaigankitsinerira, pairotari avisaigake antsipereasanovageigakera oshigaiganakera! ");
INSERT INTO mcbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Viroegi niaventaigempatyo ganiri okatinkatiro katsinkagiteriku ompote pishigaiganakera ganiri patsipereavageigiro katsinkari, ");
INSERT INTO mcbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pairotari antsipereavagetakenkani avisavagetakerotyo magatiro atsipereagetunkanirira okyasanokyara yovetsikagetake Tasorintsi kipatsi ovashi maika. Aikiro gara oneimataagani impogini. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kantankicha Tasorintsi ikantake pairani: ‘Gasakona otovaigavageti kutagiteri iratsipereavageigakera ganiri ipogereaiga maganiro.’ Isuretakoigakaritari maganiro irashiegi kematsaigakerineririra itsarogakagaigakarira, yogotaketari pairani tyani kematsaigakerine ikantantakarira: ‘Inti nashiegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tyanirika kantaigakempine: ‘Neri yoka Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite’, garatyo pikematsaigiri. Ario onkañotakempa inkantaigakempirika: ‘Aiño inake anta’, garatyo pikematsaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iripokaigaketari kamantantaigatsirira matagavageigankicharira inkantaigakera: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite.’ Pashinikya kantaigankitsine: ‘Nanti kamantantatsirira.’ Aikiro irovetsikageigamate terira oneimagetenkani kameti iramatavinaiganakeriniri tovaini. Irimaigavetanakemparityo kematsaigiririra Tasorintsi, kantankicha garatyo yagaveimaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nokamantaigakempi magatiro maika tekyara agempa kameti pogoigakeniri ganiri yamatavitumaigimpi impogini. ¡Tsikyanira pamatavitagantaigakari vikiiro! ");
INSERT INTO mcbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Impogini avisanakera tsipereagantsi ‘irirokya tsivakanankitsine poreatsiri intiri aikiro kashiri. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yogari impokiropage irashiriagetanakempa, ganigetari ikusotai.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Impogini ineavakenkani Kañotasanotakaririra Matsigenka iripokapaakera inkenapaakera menkoriku inkoveenkavagetapaakera, aikiro iragaveavagetapaakera iravisaigakerityo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Impogini intigankaigakeri isaankariite iriaigakera intsotenkagiteaiganakemparora magatiro kipatsi irapatoitaigakerira irashiegi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Maika kemisantaigena nonkantaigakempira. Pineaigirora igera okyaenkara mechoshiatanaatsi oshi pogoigake panikya aganaempa osariganaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ariotyo onkañotakempa impogini pineaigavakerorika onkañotanakempara nokamantaigakempirira maika iroro pogotantaigavakempa panikyasano impigaate Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Arisanotyo nonkantaigakempi magatirotyo oka nokantaigakempirira maika ontsatagagetanakempatyo tekyaenkara pimpogereaigempa viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ogari inkite ontiri kipatsi ontsonkagetanaempa, kantankicha ogari nokantagetakerira garatyo okantatigumata, ontityo ontsatagagetanakempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tera tyani gotumatatsine tyati impigantaatempa Kañotasanotakaririra Matsigenka. Ario ikañotaka irirori tera irogote. Aikiro isaankariite Tasorintsi tera irogoige. Panirotyo ikantakara Tasorintsi irirori yogotakerora. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pinkantakanira pogiaigavaeri tera pogoigenika tyati impigantaatempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Onti inkañotapaakempari pashini matsigenka iatakera parikoti samani iokaiganairi irapatoire ikantaiganairi paniropage tatoita irantaigake. Ikantanairi inampina inkantakanira irisentaeneri ivanko irogiavaerira impigaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Maika ario pinkañoigakempa viroegi pinkantakanira pogiaigavaeri Pitinkami, tera pogoigenika tyati impigantaatempa. Aikiro tera pogoige ariorika iripokae onchapinienkatanakera, ontirika nigankigite, ontirika irinianaera atava, ontirika onkutagitetamanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Katsiketyotari inkomutagapaakempa, tsikyanira ineaigapaakempikari tera pogiaigavaeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Maika tera paniro nonkantaigempi viroegi, maganirotyo nokantaigakeri inkantakanira irogiaigavaena.” ");
INSERT INTO mcbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Impogini yogari itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ineaigavakera pitenivatira kutagiteri agakempara Pasekoa ontiri aikiro vieseta ogantaganirira pan terira onkonogempa opoegantarira isariaigakari Jeso iragakagantaigakerira irogakagantaigakerira, kantankicha tera inkoge inkemakoigakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ikantaigake: —Antari avisanakera Pasekoa, ario agakagantaigakeri. Maikari maika gatata agakagantaigiri ganiri ikisakoiganakari maganiro patoventaiganakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Impogini iatanake Jeso Vetaniaku inkamosoterira Sumo ikantaganirira Vesegavetankicharira. Ipitaigake isekatavageigakara impo okenapaake tsinane amakotapaake kasankaari ovetsikantunkanirira narero punatasanotacharira. Onti opiaatantunkani ovetsikashitunkanirira aravasetero. Iroro agapaakerora iriroku otintsanorenkakotakero osagutantakarira igitoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ikonogagarantaigaka pitaigankitsirira kara ikisaiganaka iniavakagaiganaka ikantaigi: —¿Antari gara aparaatagantiri? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Opunavagetatari 300 tenario. Ariometyo ompimantakenkanime agantakenkanira koriki impaigakenkanira kogakovageigacharira. Ovashi ikisaigakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kantankicha Jeso irorotyo ikemaigavakerira ikantaigutarityo: —Atsi arionenityo, gara pikisaigiro, pairotari okametitake okañotakenara maika osagutakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yogari kogakovageigacharira kantakatari pintentaigaemparira, pinkogaigera pinkavintsajaigerira pinkavintsajaigakerityo, kantankicha narori gatanika pikantakani pitentaigana. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Irorori ontitari osaguvitakena kasankaari inkitaitaenara impogini nonkamakera, irorotari agaveake ovetsikakera irorori maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Maika nonkamantasanoigakempi tyarika kara inkenkitsatakotakenkani Tasorintsi tyara ikanta yogavisaakotantira ario onkañotagakenkani oga tsinane onkenkitsatakotaenkani tyara okantakena osagutakenara kameti osuretakotaenkaniniri irorori. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Impo yogari irogamere Jeso paitacharira Jorashi Ishikariote iatake ikamosoigutirira itinkamiegi saseroroteegi ikantaigakerira ikogakera iragakagantaigakenerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iriroegi ishinevageigamatanakatyo ikantaigakeri impaigakerira koriki. Yogari Jorashi iatai, impo ovashi isuretanaka tyarikatyo inkantakeri iragakagantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Impo aganaka vieseta ogantaganirira pan terira onkonogempa opoegantarira, aikiro onti yovetisantaganirira ovisha yogaganira osuretakotaaganira Pasekoa. Yogari irogamereegi Jeso ikantaigiri: —¿Tyara kara pikogake novetsikaigakerora magatiro kameti asekataigakempara paita? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Impo irirori itigankaigake piteni irogamereegi ikantaigavakeri: —Piaige Jerosarenku pintonkivoaigakempari paniro surari iramakotapaake iniate, iriro pogiaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tyarika inkianake kara ario pinkiaiganake viroegi, pinkantaigapaakeri shintarorira ivanko: “Yogari Gotagantatsirira ikantake: ¿Tyara kara nosekataigakempa paita nontentaigakemparira nogamereegi nosuretakoigakemparora Pasekoa?” ");
INSERT INTO mcbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Irirori intentaiganakempi omenkotakara enoku iokotagaigakempiro otantakara arioegiterika, mataka vetsikagetaka magatiro. Ario kara povetsikageigakero magatiro asekataigakempara paita. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iriroegi iaigake yogonkeigaka Jerosarenku ineaigapaakero magatiro ikantaigavakeririra Jeso inkaara ario okañotaka maika. Ario kara yovetsikavageigake isekataigakempara paita. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Impo ochapinienkatanakera iatake Jeso Jerosarenku itentaiganakari irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iroro yogonkeigapaakara ipitaigapaake mesaku isekataigakara. Impo irirori ikantaigiri: —Maika nonkamantasanoigakempi, paniro viroegi sekatimoigakenarira maika iragakagantakena. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yogari irogamereegi ogatyo ikenaigake ikenkisureaiganaka ikantaiganakera paniropage: —¿Naro gakagantakempine? Inianake pashini ikanti: —¿Naaro? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yogari Jeso ikantaigiri: —Inti gakagantakenane tsiantakotakenarira maika peratoku. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ontitari ontsataganakempara okantakerira Itsirinkakagantakerira Tasorintsi iniakotakerira Kañotasanotakaririra Matsigenka, kantankicha ¡maikaniroro iratsipereavagetake yoga gakagantakerineririra! Gamerakari itimi okyara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Impo panikyara iragataiganae isekataigakara inoshikakero Jeso pan yapagotakero iniakeri Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka pan.” Impo ikotagakero ipaigakerira irogamereegi ikantaigiri: —Okari oka pan kañomataka ontinirikatyo novatsa. Nero gaigemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Impo osamanitanakera irorokya inoshikakotake vino, iniairi aikiro Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka vino.” Impo ipakoigakeri irogamereegi yoviikaigakara maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikantaigiri: —Antari nonkamaventaigakerira maganiro ovoatanake noriraa. Irorotari maika irogavisaakotantaigakenkanirira maganiro kematsaigakenanerira ganiri ikenkiimatairo Tasorintsi ikañovageigara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maika nonkamantasanoigakempi gara noviikumataaro vino. Antari impogini irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite, ario pinkante noviikakemparo vino okyaakyarira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Impo yagataiganakera imatikaventaigakerira Tasorintsi ikonteiganake itonkoaiganakera iaigakera otishiku Orivoshi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Impo ikantaigiri Jeso: —Maika maganiro viroegi pimpashiventagaiganakena paita pintsarogaiganakera pokaiganakena piaigakera parikoti. Ariotari okantakeri Itsirinkakagantakerira Tasorintsi okanti: ‘Impogini nogakeri sentiririra ovisha. Yogari ovisha ogatyo inkenaigake irishigaviovageiganake.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kantankicha impogini nanianaera naketyo ivaiganakempine noatakera Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Inianake Perero ikantiri: —Impashiventagaigavetanakempityo maganiro, kantankicha narori garatyo nopashiventagumatimpi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kantankicha Jeso ikantiri: —Nonkamantasanotakempi, paita tekyara ampitetempa iriniakera atava pinteratakotakena mavati. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kantankicha irirori ariompatyo ishintsitanakeri ikantanakera: —Intagarora intentagantaitenara irogaitakenara irogaitenatatyo, kantankicha garatyo noteratakotumatimpi. Ario ikañoigakero maganiro ikantaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Impogini iaigake Jetsemaniku. Iroro yogonkeigapaakara yogari Jeso ikantaigiri irogamereegi: —Pitaigeta aka, narori noateta anta noniakerira Apa. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Intagani itentaiganaka Perero, Santiago intiri Joan. Irirori ikenkisureavagetanakatyo kara yovankinavagetanaka. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Osamanitanakera ikantaigiri: —Nokenkisureavagetanakatyo kara panikya agavagetanakena. Pitaigeta viroegi aka pintentaigakenara pinkireaventaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Irirori iatake antakona anta yompatakasetapaaka inianakerira Iriri inkogakerikara irogavisaakotaerira magatiro iratsipereakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Antari iniakerira ikantiri: “Apaa, pagaveaketari magatiro. Maika nokogavetaka pogavisaakotaenara ganiri natsipereavageti, kantankicha impatyora viro tyarika pinkante.” ");
INSERT INTO mcbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Impo yagatanakera iniakerira iatai inkaaraku inaigakera irogamereegi ineaigapaakeri magasevageigake. Ikantapaakeri Perero: —Sumooo, ¿oga magakevi? ¿Matsi tera pagaveimate samanikonara pinkireake? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kireaige gara pimagaigi. Niaventaigempa ganiri pikañovageiga. Viroegi pikogaigavetakaniroro pinkematsatasanoigakerira Tasorintsi, kantankicha tera pishintsitashiigero posante terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Osamanitanaira ipiganaa aikiro iniairi Iriri okiiro ikantairi inkaaratirira ikantakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Impo ipigavetaa ineaigapairi magasevageigaityo aikiro, avisaiganakeritari ivochokine tera ineakoigavakempa imagantaiganaarira. Ikireaigavetanaka ineaigiri Jeso aratinkake ipashiventavageiganakatyo, kantankicha tyampatyo inkantaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ipiganaa aikiro, impo ipigavetaa ovashi ikantaigapaakeri: —¿Ogaa, magaiganatsivi pishigopireaiganachavi? Maika intaga, gapaakatari iragakagantakenkanira Kañotasanotakaririra Matsigenka irogaigakerira kañovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maikari maika tinajaiganake, tsame, mataka pokapaake gakagantakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tekyara iragate Jeso iniavagetakera ipokapaake Jorashi itentaigapaakari tovaini matsigenkaegi yamashiigapaakeri savuri ontiri inchakii. Intiegi tigankaigakeri itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri aikiro itinkamiegi jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yogari Jorashi gakagantakerinerira Jeso yogotagaigakeri okyara ikantaigiri: “Agonkeigapaakemparika pineaige tyanirika noatashitake nasaraanatapaakemparira, irirotari. Pagaiganakeri pamaiganakerira tsikyanira pogishigaigirikari.” ");
INSERT INTO mcbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Impo iroro yogonketapaakara inakera irirori itsatimatashitapaakeri yasaraanatapaakari ikantakerira: —¡Gotagantatsirira! ");
INSERT INTO mcbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Impo iriroegi inoshikaigapaakeri yairikaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kantankicha aiño paniro itentakarira Jeso inoshikamatanaketyo isavurite iserogempitatutarityo ironampiria itinkamisanorira saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Inianake Jeso ikantaigiri pokashiigakeririra: —¿Matsi naro koshinti nerotyo pamashiigakenara savuri ontiri inchakii pagaiganakenara? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Omirinkatari kutagiteri notentaigakempi viroegi anta ivankoku Tasorintsi nogotagantavagetakera tera ario pagaigena, kantankicha okañotantanakarira maika onti ontsatagagetanakerora ikamantakoigakenara pairani kamantantaigatsirira itsirinkakoigakenara okyara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Impo ishigavioigamatanakatyo maganiro irogamereegi iokaiganakeri Jeso paniro. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kantankicha aiño pashini tekyarira irantaritasanote yogiavagetakeri tera irogagutempa imanchaki, intagati iponaviotantaka kamisa ogamagoni. Yogari gaigakeririra Jeso ikogaigavetaka iragaigakerimera irirori aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Okya yairikakoigavetakarira igamisateku iponatantakarira iokamatanakatyo togn akya ishigapanuta nogatsantsaniro. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Impogini yamaiganakeri Jeso inakera itinkamisanorira saseroroteegi. Irirori onti ipaita Kaipashi. Impo ipokaigapaake yapatovageigapaaka itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri aikiro itinkamiegi jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Impo yogari Perero intaina inapaake yogiatapaakerira Jeso. Antari yagapaakerora pampatuiku ivankoku Kaipashi ineaigapaakeri soraroegi taenkavageigake. Ario ikañotapaaka irirori itaenkavagetapaake. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yogari maganiro itinkamipage jorioegi patoitaigankicharira ikaemakagantaigakeri pashini intsoeventaigakemparira Jeso kameti ontimakeniri onkenantakemparira irogakagantaigakerira, kantankicha tyampatyo inkantaige iriroegi teranika inkemavakagaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Itsoeventanaigakarityo kara, irorokya ikantaigi irorokya ikantaigi. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ikonogagarantaigaka pashini ikaviriiganaka itsoeventaigakarira ikantaigi: ");
INSERT INTO mcbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Naroegi nokemaigakeri ikantakera: ‘Naro nagaveake nogimamerinkakerora ivanko Tasorintsi yovetsikaigakerira matsigenka, impo novetsikae pashini, omavatakotanakempara kutagiteri nagataero. Gara iriro vetsikaigiro matsigenka.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ikantavetakatyo maika, kantankicha pashinikyatyo kantatigavakero. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Impo ikavirimatanakatyo Kaipashi ikantiri Jeso: —¿Tera tyara pinkantumate?, pikemaigakeritari ikantanaigakempira. Maika ¿tyara pinkantera viro? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kantankicha yogari Jeso ariompatyo ikemisantanakeri, teratyo tyara inkantumate. Osamanitanakera imatutaarityo aikiro ikantiri: —¿Arisanotyo vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite? ¿Viro Itomi Tasorintsisanorira? ");
INSERT INTO mcbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yogari Jeso ikanti: —Jeeje, naroniroro katinka pogakero, kantankicha impogini pineaigakeri Kañotasanotakaririra Matsigenka impirinitakera inampinaku irakosanoriraku Tasorintsi Gaveavagetatsirira. Aikiro pineaigavakeri iripokaera inkenantapaemparora menkori. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ogatyo ikenake ikisamatanakatyo Kaipashi itisaraitarotyo imanchaki tseerererere ikanti: —Intagatityo akaemakagantaigi pashini iripokaigakera inkamantaigakaera ikemaigakerira ikañotagumanatakarira Tasorintsi, ");
INSERT INTO mcbNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","matakaniroro pikemaigakeri tsikyata viroegi ikañotakera maika. Maika ¿tyara pinkantaige viroegi? Maganirotyo iniaiganake ikantaigi: —Kantetyo inkamakera, tsikyatatari ikañotagantaka irirori. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ikonogagarantaigaka itoanaiganakerityo. Ipashiokiigakeri itaataaigakerira togn togn ikantaigavakerira: —¡Atsi gotenityo tyani taakempi! Yogari soraroegi ipatosanaigakerityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yogari Perero yaratinkake kara savi pampatuiku. Impo okenapaake ironampiria Kaipashi ");
INSERT INTO mcbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","oneapaakeri taenkavagetake, okamagumatanakerityo sorererere impo okantiri: —Viro aikiro pitentavagetari Jeso Nasarekunirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kantankicha yogari Perero ikemamampeganakatyo ikantiro: —¿Jaa? ¿Tyara pikanti? Tera nonkeme tyarika pikanti. Ishiganaka iatake anta sotsimoroku okiapinitaganira oataganira pampatuiku. Ario kara yaratinkake, impo iniamatanaketyo atava. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Oneitaarityo aikiro nampiriantsi okantaigiri naigankitsirira kara okanti: —Yogari yoga inti itentavagetarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kantankicha irirori ikanti: —¡Teratyo! Choeni osamanitanakera ikantaigiri naigankitsirira kara: —Arisanoniroro pitentavagetari, vintitari Garireakunirira. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yogari Perero ikantutaatyo aikiro: —¡Nokantakeniroro teratyo noneimateri! Arisanotyo nokantake, ineakenatari Tasorintsi tera ario nontsoegumatempa. Antari ontirika notsoegaka inkisashitakenatyo, tera noneimaterinika piniakoigakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Irorotyo yagatanakera ikantakera maika, iniamatanaityo aikiro atava ovashi isurematanakarotyo Perero ikantakeririra Jeso inkaara ikantiri: “Paita tekyara ampitetempa iriniakera atava pinteratakotakena mavati.” Ogatyo ikenake iragamatanakatyo kara jiii jiii jiii. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Okutagitetamanakera yapatoitaigaka itinkamiegi saseroroteegi, intiegiri itinkamiegi jorioegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi, intiegitari maganiro itinkamipage jorioegi. Ikemavakagaigaka tyarika inkantaigakeri Jeso. Impo yagaiganakeri yogusoiganakeri yamaiganakeneri Pirato ikantaigapaakeri: —Neri yoka Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Irirori ikantiri: —¿Arisano viro Igoveenkariegite jorioegi? Ikanti Jeso: —Jeeje, arisano pikantasanotakeniroro, naroniroro. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kantankicha yogari itinkamiegi saseroroteegi ariompatyo itsoeventaiganakariri, ");
INSERT INTO mcbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","nerotyo yogari Pirato imatutaarityo aikiro ikantiri: —¿Tera tyara pinkantumate? ¿Matsi tera pinkeme ikantaigakerira? ");
INSERT INTO mcbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kantankicha yogari Jeso teratyo iriniimate. Iroro ineavakerira Pirato ikañotakerora maika, yogavagetanaketyo kavako, tyampatyo inkantera. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Omirinkatyo agara Pasekoa yogari Pirato yapakui paniro yashitakovitunkanirira yovetsikakera terira onkametite, tyanirikara ikogaigakerira itovaireegi irapakuaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Itimake paniro surari ipaita Varavashi, onti yashitakotunkani itentagantaigunkanira pashini itentashiigakarira ikisaigakerira soraroegi iromanoegi ovashi yogantaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yapatovageiganakatyo kara jorioegi impo ikonogagarantaigaka iaigake Piratoku ikantaigakerira irapakuaigaenerira paniro shitakotankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Irirori ikantaigiri: —¿Iriro pikogaigake nampakuaerira Pigoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Irirori ineaketari onti ikisaviigakeri itinkamiegi saseroroteegi ineaigakera intira yapatoventanunkani, irorotari yamantanunkanirira iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kantankicha yogari itinkamiegi saseroroteegi yogotagaigakeri patoitaigankicharira ikantaigakerira: “Atsi kantaige: ‘Irirompatyo pampakuae Varavashi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yogari Pirato ikantaigiri: —Iroroventi maika ¿tyaratyo nonkantakeri yoka pikantaigirira inti Pigoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iriroegi ikaemaigamatanaketyo: —¡Kentakoteri! ");
INSERT INTO mcbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ikantaigiri Pirato: —¿Matsi tyara ikantakara? ¿Tatampatyora yovetsikakera? Ikaemutaiganaatyo aikiro: —¡Nokantaigaketari kentakoteri! ");
INSERT INTO mcbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yogari Pirato ikogavintsataketari irogishineaigakerira patoitaigankicharira yapakuaigainiri Varavashi. Impo yomperaventakari Jeso impasatakenkanira iramanakenkanira inkentakotakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yogari soraroegi yamaiganakeri tsompogi impo ikaemakagantaigakeri maganiro irapisoraroegitene yapatoventaiganakari isamatsanaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Impo yogagutantaigakari pashini kamisa kiraamagori. Yagaigake kivitsa yovetsikashiigakeri iramatsaire yamatsaitakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Impo isamatsanaigakerityo kara ikantaigakerira: —¡Ojojoo, neri yogaaa! ¡Atsi neaigerikario Igoveenkariegite jorioegi! ");
INSERT INTO mcbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ipasapasaigakeri igitoku inchakiiku ton ton, itoatoaigakeri, impo itigeroaventaigakari kañomataka ishineventaganira koveenkari, ontitari isamatsavintsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Impo yagataiganakera isamatsanaigakerira isapokaigairi irorokya yogagutantaigaari irashi imanchaki yamaiganakeri inkentakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aiño paniro Surenekunirira ipaita Sumo. Yogari itomi ipaita Arijantero. Irirokya irapitene ipaita Iropo. Yogari Sumo ikyaenka pokapaatsi iponiapaaka anta parikoti. Ikantaigavakeri soraroegi inatanakenerira Jeso igoroshite. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Impo itentavageiganakari Jeso anta parikoti opaitara Gorogota (onkantakera: “Ontaikara Itutai Kamatsirini”). ");
INSERT INTO mcbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ipavetunkani vino okonoatunkani mira, kantankicha teratyo iroviikemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yogari soraroegi ikentakoigakeri impo isokagiaigakero mapukicho ogotantaganirira kameti irogotantaigakemparora tyanirika shintakemparone imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Antari ikentakotunkanira ikyaenka gaenokanankicha poreatsiri. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Antari enoku igoroshiteku ogunkani inchakota otsirinkunkani okantakera tatoita yogavitunkani okanti: “Inti Igoveenkariegite jorioegi.” ");
INSERT INTO mcbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Itentagantunkani piteni koshinti ikentakotunkanira, paniro yogaratinkakotunkani irakosanoriraku, yogari irapitene onti yogaratinkakotunkani irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Antari okañotakara maika onti otsatagunkani Itsirinkakagantakerira Tasorintsi okanti: “Itentagantunkani vetsikagisevageigatsirira terira onkametite.” ");
INSERT INTO mcbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yogari visapiniigankitsirira kara ineaigakerira iokookonaigakerityo ikantaigakerira: —¡Eejee tyanirityo maika! Kogapage pikantira: ‘Nogimamerinkakero ivanko Tasorintsi impo novetsikaero, omavatakotanakempa kutagiteri nagataero.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Atsi pugamentanakempanityo maika kentakoreanaempanityo paguitanaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ario ikañoigaka itinkamiegi saseroroteegi itentaigakarira gotagantaigirorira itsirinkakotanakerira Moiseshi isamatsanaigakerityo iniavakagaiganakara ikantaigakera: —Kogapage ikantunkani yagaveavagetityo ikavintsaantavagetakera yogavisaakotakerira pashini matsigenka, tyara okantakara maika tera iragavee impugamentanakempara ikiiro iraguitanaera. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ikaemakonaigakerityo: —Irorotari vintira Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite, atsi guitanaenityo kameti nonkematsaigakempiniri. ¡Vintitari Igoveenkariegite iseraereegi! Imaiganakatyo aikiro itentagantunkanirira ikentakotunkanira ikantanaigakerityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Impo ikatinkatanakera poreatsiri oga okenake apavatsaasetanaka magatiro ovashi itsunkavagetanake. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ogatyo ikenake ikaemamatanaketyo Jeso ikanti: “Eroi, Eroi, ¿irema savakatani?” (onkantakera: “Apa Tasorintsi, Apa Tasorintsi, ¿tyara okantakara povashigantakenara?”) ");
INSERT INTO mcbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ikonogagarantaigaka naigankitsirira kara iroro ikemaigavakerira ikantaiganake: —Atsi kemeri kanika ikaemakotakerira kamantantatsirira Eriashi. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ishigamatanakatyo paniro yaganakera chomiatirorira nia iokaatakerora kachoariku vino yogaenokakovetakenerira savorokiiku irachomiatagakerimera ikanti: —Atsi pampogieri, aneaigakerira iripokashitakeririka Eriashi iroguitaerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Impo yogari Jeso ikaemapanuti eeee ovashi ikemisantanake ikamanakera. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Irorotyo ikamanakera ogatyo okenake osaraamatanaketyo kamisa tsatamagotacharira ivankoku Tasorintsi okantanakera katinkasano niganki tseerererere oponianakara enoku oatakerora savi pairatamatake kotarenkasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aiño paniro iromano yaratinkake kara katinka ikentakotunkanira Jeso. Irirori inti itinkami soraroegi. Antari ineavakerira ikamanakera ikanti: —Arisanoniroro inti Itomi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aikiro ario onaigake kara Maria Magarena, ontiri Sarome ontiri aikiro Maria iriniroegi Jose intiri Santiago iyashiki. Aikiro otentaigakaro pashini tsinaneegi opitaigake antakona anta opampogiaigakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ontiegitari giavageigiririra yanuivagetira Garireaku omutakovageigirira. Aikiro ario onaigake kara pashini tovaini tsinaneegi tentaigakaririra ikyara pokankitsi Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ogari ikamantakarira Jeso onti kutagiteri yovetsikavagetantaiganakarira jorioegi magatiro inkogakoigakemparira onkutagitetanakera agantakemparira apishigopireantaganirira. Aiño paniro itinkami jorioegi poniacharira Arimateaku ipaita Jose. Irirori inti itentaigarira itinkamipage jorioegi yapatoitapiniigara, pairo ipinkatsatasanotagani. Igantaga pairani yogiakerira iripokakera Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi. Impo panikyara irishonkanae poreatsiri iatashitakeri Pirato ikantakerira ikogakera iramanaerira Jeso inkitataerira. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kantankicha Pirato ikemakera kamake Jeso yoganaketyo kavako. Ikaemakagantakeri itinkami soraroegi ikogakotagantakerira arisanorikara ikamake. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Irirori ikantiri: —Jeeje, arisano kamake. Yogari Pirato ishonkatetanakari Jose ikantiri: —Iroroventi nanityo. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ovashi iatake ipunaventutira mechomagori kamisa ovetsikantunkanirira irino. Impo iatake ikentakoreakerira Jeso iponaviotantakari yamanairi anta yogaatirira imperitanakiku ikigantashitunkanirira igamaga itikakotantanakari omarane mapu. ");
INSERT INTO mcbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ogari Maria Magarena ontiri Maria iriniro Jose oneakoigakeri yogaaganira. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Impo ochapinitanaira kutagiteriku apishigopireantaganirira ogari Maria Magarena otentanakaro Sarome ontiri aikiro Maria iriniro Santiago oaigake opunaventaigutira kasankaripage oaigamanakera amashiiganakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Impo okutagitetamanakera tominkoku tsitekyamanisano oaigamanake anta yogaaganira. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Antari oaiganakera avotsiku oniavageiganake okanti: —¿Tyanirikaratyo tatsinkaigakaerone mapu itikakotantunkanirira? ");
INSERT INTO mcbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Omaranetarityo kara, kantankicha ogonkeigavetapaaka oneaigapaakero paa mataka ogagunkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Okiaigapaake tsompogi oneaigapaakeri isaankariite Tasorintsi pirinitake, kañomataka matsigenka ikyaenkarira antaritanankitsi. Onti ipirinitake okatinkatakera akosanoriraku, kutasamatakomataketyo kara. Ogatyo okenaigake otsarogavageiganaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kantankicha irirori ikantaigiro: —Gara pitsarogaigi. Maika viroegi pikogaigavetakari Jeso Nasarekunirira ikentakovetunkanirira, kantankicha maika mataka yoganiaagani. Mameri aka. Atsi geroratyo kavako yoginoriavetunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maika piaigepage pinkamantaigapaakerira Perero intiegiri aikiro maganiro irogamereegi pinkantaigakerira: ‘Yogari Jeso iriatake Garireaku iketyo ivatanankitsine. Impogini piaigake viroegi ario pineaigaeri anta. Ariotari ikantaiganakempiri karanki.’ ");
INSERT INTO mcbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Okonteigapanuti oshigavageiganaka otsarogavageiganaketyo kara oshigekavageiganaketyo, nerotyo tera tyani onkamantumaige. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Antari yanianaira Jeso ikitareanaara tsitekyamani tominkoku oketyosano ikoneatimotake Maria Magarena yoneaganontakarira 7 kamagarini timaguigavetakarorira. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Irorori oatake okamantaigapaakeri itentavageigavetarira okantaigiri: —¡Atake yanianai Jeso! ¡Noneakeritari naro! Kantankicha iriroegi teratyo inkematsaigero, atanatsityo iragaiganakara ikenkisureavageiganakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Impogini Jeso irirokya ikoneatimoigake piteni irogamereegi iaigavetanakara ikenaigavetanakara avotsiku tsamairintsipageku, kantankicha onti ikantatigimoigakari. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Impo iriroegi ipigaiganaa Jerosarenku ikamantaigavetapaakari itovaireegi, kantankicha teratyo inkematsaigeri iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Impogini ikoneatimoigamatairityo irogamereegi itentasanoigarira ipitaigakera mesaku isekataigakara. Impo ikanomajaigakeri ineakera tera inkematsaige, teranika isureigaemparo magatiro ikantavetunkanirira, onti otimake isureegi kogapage, tera inkematsaigerinika kamantaigavetakaririra ineaigakerira yanianaira. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Impo ikantaigiri: —Piaige parikotipageku pinkenkitsatimoigakerira maganiro matsigenkaegi pintsotenkagiteavageiganakerotyo kara samani pinkantaigakerira tyara inkantaigakempa kameti irogavisaakoigakenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tyanirika kematsatakenane aikiro irogiviatakempa irogavisaakotakenkani, kantankicha tyanirika garira ikematsatana gara yogavisaakotagani, onti inkisashitakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yogari kematsatakenanerira onti ineantakenkani ironeagageigakemparira kamagarinipage timaguigakeririra matsigenka, iraventashitakemparira novairo, aikiro iriniantaiganakemparora pashinipage niagantsipage terira irogoigavetemparo. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iragaigavetakemparityo maranke, kantankicha garatyo itavatumaigiri. Aikiro impaigavetakenkanityo kepigari iroviikaigavetakemparo garatyo ovigaigiri. Aikiro impatikaiigakeri igitoku mantsigaigankitsirira ovashi irovegaiganaempa. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Impo yagatanakera iniaiganairira irogamereegi yogaenokanairi Tasorintsi iatanai enoku ipirinitapai inampinaku irakosanoriraku. ");
INSERT INTO mcbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iriroegi iaigake ikenkitsavageiganakera itsotenkagiteavageiganakerotyo kara ikamantakoiganakerira Tasorintsi tyara ikanta yogavisaakotantira. Yogari Atinkami Jeso imutakoigakeri yagaveakagaigakerira yovetsikaigakera posantepage terira oneimagetenkani kameti irogoigakeniri yogaegi ikenkitsatimoigakerira tera ario iramatavinaigeri.");
INSERT INTO mcbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Maika, Teopiro, nokogake nontsirinkakempira sankevanti nonkamantakempira magatiro yovetsikagetakitirira Jesokirishito pairani ipokutira aka savi kipatsiku. Nontsititapanutero panikyara iripokake nompigakemparo iatanaira enoku. Pairani itsititanakera ikenkitsatanakera aiñoegi pashini tentaigakaririra. Iriroegitari neasanoigakeri, aikiro ineageigakero magatiro yovetsikagetakerira. Impogini ovashi ikenkitsatakoiganakero iriroegi Niagantsi Kametiri. Aikiro ikamantakoigakeri irirori ontiri magatiro yovetsikagetakerira itimavetakitara aka kipatsiku itsotenkasanoigakerotyo kara. Impogini ovashi ikemaigavakera tovairi, irirokyari tsirinkakoigakero sankevantiku, ikemaigakeritari ikenkitsatimoigakerira. Naro noniavantakero notsotenkasanotakero magatiro, aikiro nokogakotagantasanoigakeri neaigakeririra Jeso. Maika noneakero kametitake nontsirinkakempira nonkamantasanotakempira magatiro kameti pogotakeniri tera iramatavitumaigempi gotagaigakempirorira Niagantsi Kametiri kamantaigakairira tyara ikanta Tasorintsi yogavisaakotantira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pairani aiñokyara ipegaka Erorishi igoveenkariegite timaigatsirira Joreaku, aiño paniro matsigenka ipaita Sakariashi. Irirori inti saserorote tavagetapinitatsirira ivankoku Tasorintsi itentaigarira iyashikiiganakerira tentaigakaririra Aviashi pairani. Irirori aiño itsinanetsite opaita Isavere. Irorori aikiro onti iyashikitanakerira Aaron. Yogari Aaron inti saserorote pairaninirira, aikiro maganiro iyashikiiganakerira intiegi saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yogari Tasorintsi ineakeri Sakariashi ontiri Isavere pairo ikematsaigakeri itsatagaigakerora magatiro ikantagetirira pairani ontsatagakenkanira. Tera tyani kantumatatsine tera inkematsatasanoigeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piteniro atake yagatavageiganaa kantankicha tera intime itomi teranika ontomintumatempa Isavere. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Impogini agaka kutagiteri okatinkaigairira Sakariashi intiegiri itentaigarira iriaigaera irantavageigaera ivankoku Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Antari yogonkeigapaakara isokagiaigapaakero mapukicho ogotantaganirira irogotantaigakemparora tatoita irantaigake paniropage, ariotari yogameigari iriroegi ikañoigirora maika. Antari isokagiaigakerora inti okatinkatake Sakariashi inkiakera tsompogi intagakenerira Tasorintsi kasankapaneri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Impo agapaakara panikyara intagakero ikianake tsompogi. Maganiro jorioegi yapatoitaigaka sotsi iniaigakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Antari yaratinkakera Sakariashi tsompogi itagavagetakera katsiketyo ineitarityo isaankariite Tasorintsi aratinkake onampinaku otagantaganirira kasankapaneri oatakara irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Irorotyo ineakerira ogatyo ikenake itsarogavagetanake yoganakera kavako. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Impo irirori ikantiri: —Gara pitsarogi, ikemakempitari Tasorintsi piniakerira. Maika ogari pitsinanetsite intimake otyomiani. Impogini imechotakera pimpaitakeri Joan. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Virori tovaiti pishineventakempari, aikiro irishineventaigakempari tovaini matsigenkaegi, ");
INSERT INTO mcbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","irishineventasanotakemparitari Atinkami Tasorintsi. Gara yoviikumataro vino ontirika pashini poiripage. Antari aiñokyara irine omotiaku iriniro intinkamitakempari Isure Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Impogini inkematsatagakeri tovaini ishaninkaegi iyashikigeiganakerira Iseraere kameti inkematsaigakeriniri Atinkami Tasorintsi. Irirori intitari Itinkamiegi maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yogari pitomi onti inkañotakempari yoga kamantantatsirira Eriashi, iragaveakagakeritari Isure Tasorintsi gaveakagakeririra irirori pairani. Irirori onti iriivatakerira yoga intigankakerira Tasorintsi irogavisaakotantakera. Irogotagaigakeri ishaninkaegi intasanoiganaemparira itomiegi ontiri aikiro inkematsaigakerira Tasorintsi kameti inegintetashiigavakemparira pokapaankitsinerira intigankakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ikanti Sakariashi: —¿Matsi tyara nonkantakempara naro nontomintakempara?, ataketari nagatavagetanaa, aikiro notsinanetsite atake agatavagetanaa. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Impo ikanti irirori: —Naro nanti Gavirieri. Nokantakani nantavagetimotiri Tasorintsi. Irirotari tigankakena nompokakera nonkamantakempira kameti pishinetakempaniri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kantankicha maika tera pinkematsatenanika pimakanatanake, gara piniai kigonkero imechotakera pitomi. Impogini ario pinianae. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Impogini irirori inake tsompogi anta tera inkontetae. Yogaegiri patoitaigankicharira sotsi ineaigakera tera aiñokya inkontetae ikantaigake: —¿Tatarikatyo gakeri? Oga ipegaka tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Impogini ikontevetanaa tera iragaveae iriniaera. Ineaigavakerira iriroegi ikantaigi: —¿Tatarikatyo ineake tsompogi? Irirori teratyo iriniae, onti yakokovagetake. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Impogini aganaara kutagiteri yagatantanaarira yantavagetakera iatai ivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Impo ogari itsinanetsite itimanake otyomiani kantankicha irorori onake ovankoku 5 kashiri tera oneimataenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Onti oniasurentavagetanaka okanta: “¡Pairo ikavintsaakena Notinkami! Itsarogakagavagetakena ganiri yogipashiventaigaana notovaireegi inkantaigaenara: ‘Ariorokari ikisakero Tasorintsi nerotyo tera ontomintumatempa.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Impogini onakotanakera Isavere 6 kashiri itimakera otyomiani yogari Tasorintsi ariokya itigankakeri Gavirieri iriatakera Nasareku Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ariotari otimiri kara paniro tsinane paitacharira Maria. Onti okyakona antarotankitsi tera ineimatero surari. Aiño ogashigane ipaita Jose panikya iragakero. Irirori inti iyashikitanakerira Koveenkari Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Impogini yogonketapaaka Gavirieri ovankoku ikiapaake ikantapaakero: —¡Viro Maria, shinetempa, ishineventasanotakempitari Tasorintsi, ikantakani itentakempi! ");
INSERT INTO mcbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Okemutarityo oga okenake otsaroganake oniasurentavagetanaka okanti: “¿Tyarikatyo ikanti?” ");
INSERT INTO mcbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Irirori ikantiro: —Gara pitsarogi, ishineventasanotakempitari Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maikari maika intimake pityomiani. Impogini imechotakera pimpaitakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pairo iravisake inkametitasanotakera iravisakeri maganiro. Inkantakenkani Itomi Tasorintsi timatsirira enoku. Yogari Atinkami Tasorintsi impegakagakeri koveenkari inkañotagakemparira Iravi pairani. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Inkantakani impegakempa Igoveenkariegite iseraereegi, gara itimumati pugaerinerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Impogini irirori okanti: —¿Tyarika nagakeri notyomiani? Tekyatanika intimenika nojime. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ikanti irirori: —Iripokaketari Isure Tasorintsi viroku. Yogari Tasorintsi timatsirira enoku iragaveakagakempi, nerotyo yoga pitomi mechotankitsinerira inkantakenkani yashintarira Tasorintsi, aikiro inkantakenkani Itomi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kañotari piitane Isavere atakeri agatavagevetanaa, aikiro okantavetaganiri terira ontomintumatempa, akyari itimi otyomiani, maika kamonkitake atake inakotanake 6 kashiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yagaveaketari Tasorintsi magatiro, teranika tatoita komutapitsatumatemparine. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Irorori okanti: —Iroroventi nanityo. Kantetyo inkañotagakenara Tasorintsi magatiro pikantakenarira maika, nantitari ironampiria. Impogini iatai Gavirieri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Impogini ovetsikanaka Maria oatakera Joreaku. Impo oatake otonkoanaka otishiku otsatimavagetanake tsikyari oneero Isavere. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ogonketapaaka otimira oneapaakero pirinitake ovankoku okantapaakero: —¿Oga aiñovi? ");
INSERT INTO mcbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Okemutarotyo Isavere ogatyo ikenake yoanaka otyomiani omotiaku, itinkamimatanakarotari Isure Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Oniamatanaketyo omaraenkarika okanti: —¡Vinti ikavintsaasanotake Tasorintsi! Maganiro tsinaneegi ikavintsaakero, kantankicha virori pairotyo yavisake itasanotakempira. Ario ikañotaka pityomiani irirori pairo ikavintsaasanotakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Matsi tyanimpatyora naro kameti ompokakera iriniro Notinkami oneenara! ");
INSERT INTO mcbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iroro nokemavakempira piniapaakenara ogatyo ikenake notyomiani ishinetanaka yoanaka nomotiaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Ikavintsaakempi Tasorintsi pikematsatakeritari, aikiro pogotaketari intsatagakero magatiro ikamantakagantakempirira! ");
INSERT INTO mcbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Impo okanti Maria: “Noniasurentaka nosureku nokanti: ‘Pairo ikametiti Notinkami Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Noshinetaka nosureku, noshineventakari Tasorintsi gavisaakotakenarira, ");
INSERT INTO mcbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ineakenatari nanti ironampiria tera nompaitumatempa, itsarogakagakena. Ovashi maika maganiro timaigankitsinerira aka kipatsiku inkantaigake: ‘Pairo ikavintsaavagetakero Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yogari Gaveavagetatsirira yovetsikimogetakena kametiripage. ¡Irirori ipaita Terira Inkañovagetumatempa! ");
INSERT INTO mcbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ikantakani itsarogakagaigakari maganiro shineventaigaririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yogikoneatakero iragaveane yovetsikagetakera posante kametiripage. Itivarokaigakeri ventakovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iokaigakeri koveenkariegi. Yogaegiri terira impaitumaigempa imutakoigakeri yagaveakagaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yogari kogakoigankacharira ipaigakeri posantepage kametiripage. Yogari shintavageigacharira itigankaigairi kogapage tera tatoita impumaigavaeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Imutakotasanoigakeri iseraereegi, intiegitari iromperane. Ikantakani itsarogakagaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ikantakeritari yashikiiganakairira pairani: ‘Nonkantakani nontsarogakagakempari Averan intiegiri aikiro maganiro iyashikiiganakerira.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ogari Maria otimake ovankoku Isavere mavani kashiri, impogini opiganaa oataira otimira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Impogini agaka omechotantakemparira Isavere, omechotake inti otomi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oshinevagetakatyo kara. Impo ikemakoigakerora maganiro choenitakotakarorira intiegiri aikiro oitaneegi pairora ikavintsaakero Tasorintsi ishineigamatanakatyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Impogini omonkaratapaakara 8 kutagiteri yogaratsaitunkani ichonkirimeshinate. Yogaegiri iitaneegi ikogaigavetaka impaiigakerimera Sakariashi iragakotaerimera iriri, ");
INSERT INTO mcbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kantankicha iriniro okanti: —Gara, onti impaitakempa Joan. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iriroegi ikantaiganake: —¿Matsi tyara okantakara? Mameritari piitane paitachanerira Joan. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Impo iokotunkani Sakariashi inkantakera tyara impaitakempa itomi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Impo irirori iokotakero inchakota intsirinkantakemparora ovashi ipunkani itsirinkake ikanti: “Impaitakempa Joan.” Yogaegi patoitaigankicharira ogatyo ikenaigake yogaiganake kavako, ");
INSERT INTO mcbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","aikiro irirori ogatyo ikenake inianai ikantake: “¡Pairo ikametiti Atinkami Tasorintsi!” ");
INSERT INTO mcbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Antari ikemakoigakerira yogaegi choenitakoigankicharira yogavageiganake kavako iriroegi aikiro. Ario ikañoigaka maganiro timageigatsirira otishipageku Joreaku ikemakogeigakero magatiro oka ");
INSERT INTO mcbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ovashi isurevageiganaka ikantaiganake: “¿Tyarikatyo inkantanakempara impogini yoga ananeki?” Ineaigaketari ikavintsaavagetakerira Atinkami Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yogari Sakariashi itinkamitakaritari Isure Tasorintsi iniamatanaketyo ikamantantanakera ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Pairo ikametiti Atinkami Tasorintsi shintaigakairira aroegi iyashikiiganakerira Iseraere! Tera imagisantaigajae irogavisaakoigakaera. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Maika itigankimoigakai gavisaakotantatsirira gaveavagetatsirira. Irirori inti iyashikitanakerira ironampiria Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ariotari ikantaigakeri kamantantaigatsirira pairani ikantaigi: ‘Ikantake Tasorintsi: Nontigankimoigakeri gaveavagetatsirira iyashikitanakerira nonampiria Iravi irogavisaakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Intimaigavetakempatyo tovaini kisashiigakemparinerira, kantankicha naro nompugamentaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nonkenkiaigakeri maganiro yashikiiganakeririra nontsarogakagaigakemparira, gara nomagisantiro magatiro nokantaigakeririra.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tasorintsi ikantakeritari Averan pairani: ");
INSERT INTO mcbNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Impogini intimaigavetakempatyo tovaini kisashiigakemparinerira piyashikiiganakerira, kantankicha naro nompugamentaigakeri ganiri itsarogaigai irantavagetimoigakenara ");
INSERT INTO mcbNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","intsatagaigakerora magatiro nokantagetirira kantani impampiatanakero asatyo inkamavagetanae.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aikiro viro, notomi, inkantaitakempi kamantakotakeririra Tasorintsi timatsirira enoku, viketyotari ivatanakerine intigankakerira irogavisaakoigakaera pinkantaigakerira iseraereegi irapakuaigakerora yovetsikaigira terira onkametite irogiaigavakerira iripokapaakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aikiro pogotagaigakerira irogoigakeniri tyara inkantaigakempa irogavisaakoigakenkaniniri ganiri ikenkiairo Tasorintsi magatiro ikañovageigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Itasanoigakaitari itsarogakagasanoigakai itigankantakaririra gavisaakoigakaenerira iponiakara enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Irogavisaakoigakeri terira inkemakoigavetempari Tasorintsi, pinkaigirorira igamane. Irogotagaigakae tyara ankantaigakempa antimagantsiigakera kameti.” ");
INSERT INTO mcbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yogari Joan ikimotanake ikematsatasanotanakeri Tasorintsi. Impogini yantaritanakera iatake itimuntetake parikoti osarigagitetapaakera kigonkero itsititanakera ikenkitsatanakera ikantaigakerira iseraereegi inegintetashiigavakemparira Gavisaakotantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Antari ityomiakyanira Joan ikantake koveenkari Sesa Aogoseto intsirinkakoigakempara maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Teratyo intsirinkakotumaigempa pairani. Ikyaenka komutagaigankicha intsirinkakoigakempara inakera inampina Sesa paitacharira Shirenio anta Suriaku ineagetakenerira magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Impogini iaigake maganiro tyarikara itimaigavetara yashikitakeririra pairani intsirinkakoigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yogari Jose onti itimake Nasareku Garireaku. Impo irirori iatake intsirinkakotempara Verenku Joreaku, ariotari imechotakeri Iravi yashikitanakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Itentanakaro itsinanetsite Maria ariomonkitake. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Impogini iatake yogonkevetapaaka pankotsiku omagantapinitaganirira ineaigapaakeri matsigenkaegi shatekaitavagetaka tyampatyo irimagaigapaake kara, nerotyo onti imagantaigapaaka pankotsi imagantaigarira piratsi. Impo aganakara omechotantakemparira Maria omechotake, inti otomi. Oponatakeri kamisaku oginoriantakari isekatantarira piratsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Antari anta ochoenitakara Veren otimakera shimpenashi, ario inaigake kara sentaigiririra ovisha ikireaventaigakerira irovishate. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Impo katsiketyo yontenenkakoigakeri Tasorintsi ineaigutarityo aratinkake isaankariite Tasorintsi, itsarogavageiganaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kantankicha irirori ikantaigiri: “Gara pitsarogaigi. Onti nopokashitake nonkamantaigakempira pishinevageigakempaniri viroegi intiegiri aikiro maganiro pitovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Antari anta Verenku itimavetara Iravi pairani mechotake gavisaakoigakempinerira, irirotari Kirishito itigankakerira Tasorintsi impegakempara Pigoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Maika piaigake pineaigapaakeri ponataka kamisaku noriaka isekatantarira piratsi. Iroro pogotantaigakempa tera namatavinaigempi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Irorompatyo yagatanakera iniavagetakera ineaigutarityo aratintiitaigake iriroku pashini isaankariite Tasorintsi intovaigavagetetyo kara iponiaigaka enoku. Iriroegi iniaiganake ikantaigi: ");
INSERT INTO mcbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Pairo ikametiti Tasorintsi timatsirira enoku! ¡Akari aka kipatsiku irishinevageigakempa maganiro inkavintsajaigakerira!” ");
INSERT INTO mcbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Impogini iaiganaira iriroegi enoku iniavakagaigaka sentaigiririra ovisha ikantaigi: —Tsamenityo aigakera Verenku ankamosoiguterira ikamantaigakairira. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iaigake itsatimavageiganake yogonkeigapaaka ineaigapaakeri Jose ontiri Maria intiri aikiro otomi noriaka, inoriantakaro isekatantarira piratsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iroro ineaigapaakerira ikamantakoiganakero magatiro ikantaigakeririra isaankariite Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Maganiro kemaigavakeririra ikamantaigakerira yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ogari Maria okantakani osuretakotakaro magatiro, tera omagisantero. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Impogini iaiganaira sentaigiririra ovisha ishineventaiganakari Tasorintsi ikantaigakera: “¡Pairo yagaveavageti Tasorintsi!”, ineaigaketari otsatagagetanakara magatiro ikantaigakeririra isaankariite. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Impogini omonkaratapaakara 8 kutagiteri, ogaratsaitunkani ichonkirimeshinate otomi Maria ipaitunkanira Jeso, ariotari ikantakeri isaankariite Tasorintsi okyara ikoneatimotakerora tekyaenkara intimumate. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Impogini omonkaratapaaka kutagiteri iriatantaigakemparira Jose ontiri Maria Jerosarenku intsatagagetakerora okantakerira itsirinkakotanakerira Moiseshi kameti inkantaigakerira saserorote tenige iromanonkantaigae, ovashi iaiganake yamaiganakerira aikiro Jeso irashintagakemparira Tasorintsi, ");
INSERT INTO mcbNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ariotari okantakeri Itsirinkakagantakerira Tasorintsi okanti: “Maganiro iketyorira irogiivatakenkani intomintakenkanira inti shintakemparine Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aikiro ipaigakeri saserorote piratsi intagakenerira Tasorintsi intsatagaigakerora pashini otsirinkakotunkanirira okantake: “Pamakeneri Tasorintsi piteni emori intirika piteni shiromega.” ");
INSERT INTO mcbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Antari anta Jerosarenku aiño paniro jorio ipaita Sumeon. Irirori pairotyo ipinkatsatasanovagetiri Tasorintsi ikematsavagetirira. Yogiintevagetakeri pairani iripokakera gishineaigaerineririra ikenkisureaigakara maganiro iseraereegi. Yogari Isure Tasorintsi inagutakeri, ");
INSERT INTO mcbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","irirotari kamantakeri gatatara ikami kigonkero ineakerira intigankakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Impogini aganakara kutagiteri iatantaigakarira Jose ontiri Maria ivankoku Tasorintsi ario inake kara Sumeon, inti tentanakari Isure Tasorintsi kameti ineakeriniri Jeso yamaigakerira intsatagaigakerora magatiro itsirinkakotanakerira Moiseshi pairani. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yogari Sumeon ineavakerira Jeso inoshikakeri itsomaakeri iniakeri Tasorintsi ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Notinkami, pairo pavisavageigakeri maganiro. Maikari maika virorika kogankitsi nonkamanaera kametitaketyo, matakatari noneakero pitsatagagetakerora magatiro pikantagetakerira pairani. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Maika noneamatirityo pitigankakerira irogavisaakoigakerira maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Irirori irogikoneatimoigakeri terira iriroegi iseraereegi tyara inkantaigakempa irogavisaakoigakenkanira, aikiro iriro irishineventaviigakenkani iseraereegi pashintaigakarira pairani kigonkero maika.” ");
INSERT INTO mcbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yogari Jose ontiri Maria ikemaigavakerira Sumeon iniakotakerira Jeso yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yogari Sumeon iniakeri Tasorintsi ikantakeri inkavintsajaigakerira Jose ontiri Maria intiri aikiro Jeso, impo ikantiro Maria: —Yokari yoka pitomi inti tigankakeri Tasorintsi irogavisaakoigakenkaniniri tovaini iseraereegi, kantankicha intimagarantaigake aikiro tovaini inkisashiigakenkani. Onti itigankavitakeri irogavisaakoigakerira maganiro, kantankicha inkonogagarantaigakempa inkisaigakeri ");
INSERT INTO mcbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ovashi ogotakenkani tatoita isureigaka maganiro. Magatiro oka onti onkenkisureakagavagetakempityo viro. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ario onake aikiro kara paniro tsinane kamantantatsirira opaita Ana. Onti irishinto Panoeri iyashikitanakerira Asere pairani. Irorori antarovagetini pairani. Antari okyaenkara antarotanankitsi agavetaka osuraritsite impo avisanake 7 shiriagarini ikamake. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Antari yamanunkanira Jeso ivankoku Tasorintsi onti onakotanake 84 shiriagarini otimaira kogapage. Okantakani opiriniti ivankoku Tasorintsi. Apakuapiniti tera osekatempa kameti ompiriniventakeriniri Tasorintsi oniakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aiñokyara iniakera Sumeon okenapaake irorori okanti: —Pairo ikavintsaantavageti Tasorintsi itigankakerira gavisaakoigakerinerira iseraereegi. Impo okamantaiganakeri maganiro timaigatsirira Jerosarenku giaigakeririra iripokakera gavisaakoigakerinerira iseraereegi okantaigiri: —¡Pokake agiaigakerira! ");
INSERT INTO mcbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Impogini ogari Maria intiri Jose yagataiganakera itsatagaigakerora magatiro okantakerira Itsirinkakagantakerira Tasorintsi ipigaiganaa Garireaku iaigai itimira Nasareku. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yogari Jeso ariompa ikimotanakeri ishintsitanakera, aikiro yogovagetanake isuretasanotanakara. Pairotyo ikavintsaavagetakeri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Impogini ishiriagakotanakara Jeso 12, yogiaiganakeri iriri ontiri iriniro iaiganakera Jerosarenku irogavisaigakerora Pasekoa, ariotari yogameigari iriroegi omirinka agara iatapiniigi yogavisapiniigirora. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Impogini avisanaira Pasekoa ipigaiganaa. Yogari Jeso tera iriatae, aiño anta Jerosarenku. Kantankicha yogari iriri ontiri iriniro tera irogoige, ");
INSERT INTO mcbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ineaigiri atakeri yogiaiganairi itovaireegi. Impo ochapinivetanaka ikogaigavetari mameri, itsotenkavageigakerityo kara ikogakotagantaigakerira iitanepage intiegiri aikiro itentagaigarira ");
INSERT INTO mcbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tera ineaigaeri, mameri. Okutagitetanakera ipigaigapanaata Jerosarenku inkogaigapanaaterira. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iroro omavatanakara kutagiteri ineaigapaakeri pirinitake ivankoku Tasorintsi itentaigakari gotagantaigirorira itsirinkakotanakerira Moiseshi ikemisantaigakerira ikogakotagantaigavakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Maganiro kemaigakeririra yogavageiganaketyo kavako, ineaigakeritari pairo yogovageti. Ikogakotagantageigamatirityo komuripage, kantankicha irirori yogipigaigavakenerityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Antari ineaigapaakerira iriri ontiri iriniro yogavageiganaketyo kavako. Impo okantiri iriniro: —Notomi, ¿antari gara pikañoigana maika? Nokogasanoigakempityo kara notsotenkavageiganakempityo, mamerivi, pomintsarogaigakena, noneaigiri ariori pipegaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yogari Jeso ikantiro: —¿Tyara okantakara pitsotenkavageiganakenara parikoti pikogaigakenara? ¿Matsi tera pogoige ontitari nompiriniventavagetanake irashipage Apa? ");
INSERT INTO mcbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kantankicha iriroegi tera irogoige tatoita ikantake. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Impo yagaiganairi itentaiganaari Nasareku. Irirori ikantakani ikematsavageigiri iriri ontiri iriniro. Irorori okantakani osuretakotakaro magatiro ikantakerira tera omagisantero. ");
INSERT INTO mcbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yogari Jeso ariompatyo ikimotanakeri aikiro yogotasanovagetanakeri. Yogari Tasorintsi ishineventakari intiegiri aikiro matsigenkaegi maganirosanotyo ishineventaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pairani ipegaka Tiverio Sesa igoveenkariegite maganiro iromanoegi. Impogini aganakara 15 shiriagarini itigankakeri inampina paitacharira Pontsio Pirato ineagetakenerira magatiro anta Joreaku. Yogari Erorishi inti neagetakeneririra magatiro Garireaku. Aiño irirenti ipaita Jeripe, irirori inti neagetatsirira Itoreaku ontiri Terakoniteku. Yogari neagetakeneririra magatiro anta Aviriniaku onti ipaita Irisaniashi. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yogari itinkamiegisanorira saseroroteegi onti ipaita Anashi, yogari irapitene ipaita Kaipashi. Yogari Joan, itomi Sakariashi, onti inake anta parikoti osarigagitetapaakera. Impo iniakeri Tasorintsi ikantakerira iriatakera inkenkitsatimoigakerira ishaninkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Impo ikemakerira Joan iatake ikenanake Jororanku itsotenkavageiganakeri timageigatsirira kara ikenkitsatimoiganakerira ikantaigakerira: “Kantatigaiganakempa pampakuaiganakerora povetsikageigira terira onkametite pogiviaigakempara ganiri ikisaviigimpiro Tasorintsi magatiro pikañovageigara.” ");
INSERT INTO mcbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ariotari okantakeri itsirinkakotanakerira kamantantatsirira Isaiashi pairani ikanti: “Iriatake pashini matsigenka anta osarigagitetapaakera inkenkitsatakera imaraenkarika kara inkante: ‘Pakuaiganakero povetsikageigira terira onkametite pinegintetashiigavakemparira Atinkamiegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pinegintevageigakempara pisureku kañomataka ontinirikatyo pavotashiigavakeri. Tyarika otsatenipatsagetakera ontiagetakenkani kameti aravonkavatsatanakeniri. Ogari otishi ontiri aikiro otonkoavatsagetara ompampatagagetakenkani. Irorokya avotsi tipuvokigetankicharira onkatinkapokitagagetakenkanira. Irorokya avotsi tsogurontevokitankicharira ontiavokigetakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ario onkañotakempa maika kameti ineaigakeriniri maganiro Gavisaakotantatsirira itigankakerira Tasorintsi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Antari iaigakera tovaini matsigenkaegi irogiviaigakerira Joan, irirori ikantaigavakeri: “¡Viroegi kañoigakavi tsiroti! Ontitari pamatagaigaka tera arisano pinkematsatagantsiige. ¿Matsi tyanimpatyora kantaigakempira pimpokaigakera aka nogiviaigakempira ganiri ikisashiigimpi Tasorintsi impogini inkisashiigakemparira maganiro kañovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Atsi negintetasanoigempanityo kameti ineaigakempiniri maganiro arisano pikantatigaigaka papakuaigakerora povetsikageigira terira onkametite pikematsatasanoigakerira Tasorintsi. Maika gara pikantaigi: ‘Gara ikisashiigana Tasorintsi, nantitari iyashikiegi Averan.’ Maika nokogake nonkantaigakempira, ¿pineaigakero ogapage mapu? Inkogakerika Tasorintsi iragaveaketyo impegakagagetakemparora iyashikiiganakerira Averan. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kantankicha maika panikya inkisashiigakempari Tasorintsi maganiro terira inkematsatasanoigeri, inkañotagakemparora otogaganira inchato terira ontimumate okitsoki impo otagunkanira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iriroegi ikantaigutarityo: —¿Tyaratyo nonkantaigakempara? ");
INSERT INTO mcbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ikantaigiri Joan: —Aiñorika shintakotankicharira piteti imanchaki impakerityo patiro tyanirika kogakotankicharira. Aikiro tyanirika timakotankitsi iseka impakeri terira intimakote. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ario inaigake kara kogantaigaririra itovaireegi koriki irashi koveenkari, onti ipokashiigake iriroegi aikiro inkantaigakerira Joan irogiviaigakerira. Ikemaigavakerira iniavagetakera Joan iniaigamatanaketyo iriroegi ikantaigiri: —Gotagantatsirira, naroegiri, ¿tyaratyo nonkantaigakempara? ");
INSERT INTO mcbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yogari Joan ikantaigiri: —Maika viroegi ganigetyo povashigaigaari pikogantaigaarira pitovaireegi, intagatityo pinkogantaigakempari ikantakerira koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Impo iriroegikya kantaigakeri soraroegi: —Naroegiri, ¿tyaratyo nonkantaigakempara? Ikantaigiri Joan: —Viroegi gara pagapitsanaigairi tatarika oita yashintaka pashini aikiro gara pikantaigiri: ‘Garika pipanaro nokogakerira nonkisakempi.’ Gara pinevitantavageigi koriki pinkantaigakera: ‘Garika pipana nontsoeventakempi inkisakempira koveenkari.’ Yogari koriki ipunaigakempirira koveenkari intaganityo, gara pikogaigi pashini. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yogaegiri maganiro patoitaigankicharira kara ogatyo ikenaigake ikogasanoiganake irogoigakera irirorikara Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kantankicha Joan ikantaigiri maganiro: “Narori onti nogiviaigakempi niaku, kantankicha panikya iripokake pashini tigankimoigakempineririra Isure Tasorintsi intimasurentagarantaigakempira, kantankicha pinkonogagarantaigakempa intigankagarantaigakempi morekariku. Irirori pairotyo yavisakena yagaveavagetakera. Narori garorokarityo nokañotumatari irirori, onti nagamaavagetakari, pairotari yavisavagetakena. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Antari iripokapaakera inkantapaake tyani kematsatasanoigakeri Tasorintsi, aikiro tyani terira inkematsaigeri. Yogari kematsatasanoigakeririra intentaiganakeri intimimoigakerira Tasorintsi. Yogari terira inkematsaigeri intigankaigakeri morekariku garira otsivakumati.” ");
INSERT INTO mcbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ario ikañotaka maika Joan ikenkitsatimovageigakerira maganiro. Yogotagaigakeri posantepage, aikiro ikamantageigakeri tyara ikanta Tasorintsi yogavisaakotantira. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aikiro ikanomaakeri Erorishi neagetakeneririra Sesa magatiro Garireaku, ineaketari yagapitsatakerira irirenti itsinanetsite paitacharira Eroria. Tera patiro onake oka. Ikanomaavigetakerityo aikiro posante yovetsikagetakerira terira onkametite, ");
INSERT INTO mcbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","nerotyo ikisantanakarira Erorishi ovashi yashitakotagantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Antari aiñokyara yogiviatantavageti Joan, imatakeri aikiro Jeso yogiviatakeri irirori. Impo yogari Jeso iniakeri Iriri. Iroro iniakerira ashirenakitanaka inkite ");
INSERT INTO mcbNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ineiri Isure Tasorintsi ikañotapaakari shiromega yapusatinkagutapaakari. Impo inianake Tasorintsi enoku ikanti: “Virori vinti Notomi, notasanovagetakempityo kara noshineventakempityo.” ");
INSERT INTO mcbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Antari itsititanakera Jeso yogotagantavagetanakera onti ishiriagakotanaka 30 shiriagarini. Kantankicha onti ikomutunkani ineaganiri irirori tomintasanotari Jose. Yogari Jose inti itomi Eri. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yogari Eri inti itomi Matate. Irirokya Matate inti itomi Irevi. Irirokya Irevi inti itomi Meriki. Irirokya Meriki inti itomi Janai. Irirokya Janai inti itomi Jose. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Irirokya Jose inti itomi Matatiashi. Irirokya Matatiashi inti itomi Amoshi. Irirokya Amoshi inti itomi Naomo. Irirokya Naomo inti itomi Eseri. Irirokya Eseri inti itomi Nagai. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Irirokya Nagai inti itomi Maati. Irirokya Maati inti itomi Matatiashi. Irirokya Matatiashi inti itomi Semei. Irirokya Semei inti itomi Jose. Irirokya Jose inti itomi Jora. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Irirokya Jora inti itomi Joanan. Irirokya Joanan inti itomi Iresa. Irirokya Iresa inti itomi Sorovaveri. Irirokya Sorovaveri inti itomi Saratieri. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Irirokya Saratieri inti itomi Neeri. Irirokya Neeri inti itomi Mereki. Irirokya Mereki inti itomi Ari. Irirokya Ari inti itomi Kosame. Irirokya Kosame inti itomi Erimarami. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Irirokya Erimarami inti itomi Eri. Irirokya Eri inti itomi Jeso. Irirokya Jeso inti itomi Eriesere. Irirokya Eriesere inti itomi Jorimo. Irirokya Jorimo inti itomi Matate. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Irirokya Matate inti itomi Irevi. Irirokya Irevi inti itomi Sumeon. Irirokya Sumeon inti itomi Jora. Irirokya Jora inti itomi Jose. Irirokya Jose inti itomi Joname. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Irirokya Joname inti itomi Eriakime. Irirokya Eriakime inti itomi Merea. Irirokya Merea inti itomi Mena. Irirokya Mena inti itomi Matata. Irirokya Matata inti itomi Natame. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Irirokya Natame inti itomi Iravi. Irirokya Iravi inti itomi Isai. Irirokya Isai inti itomi Oveti. Irirokya Oveti inti itomi Voose. Irirokya Voose inti itomi Sarimon. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Irirokya Sarimon inti itomi Naason. Irirokya Naason inti itomi Aminaravo. Irirokya Aminaravo inti itomi Arame. Irirokya Arame inti itomi Eserome. Irirokya Eserome inti itomi Parese. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Irirokya Parese inti itomi Jora. Irirokya Jora inti itomi Jakovo. Irirokya Jakovo inti itomi Isaako. Irirokya Isaako inti itomi Averan. Irirokya Averan inti itomi Tare. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Irirokya Tare inti itomi Nakori. Irirokya Nakori inti itomi Serogi. Irirokya Serogi inti itomi Iragao. Irirokya Iragao inti itomi Pareko. Irirokya Pareko inti itomi Evere. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Irirokya Evere inti itomi Sara. Irirokya Sara inti itomi Kainan. Irirokya Kainan inti itomi Aripasate. Irirokya Aripasate inti itomi Seme. Irirokya Seme inti itomi Noe. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Irirokya Noe inti itomi Irameko. Irirokya Irameko inti itomi Matosare. Irirokya Matosare inti itomi Enoko. Irirokya Enoko inti itomi Jarete. Irirokya Jarete inti itomi Marareri. ");
INSERT INTO mcbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Irirokya Marareri inti itomi Kainan. Irirokya Kainan inti itomi Enose. Irirokya Enose inti itomi Sete. Irirokya Sete inti itomi Aran. Yogari Aran inti vamparoatakeri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Antari ikyaenkara giviatankicha Jeso Jororanku itinkamitanakari Isure Tasorintsi yamanakeri anta osarigagitetapaakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yogari Jeso onti ipitashitakaro kogapage tera isekatumatempa, impo avisavagetanake 40 kutagiteri niganki itaseganake. Impo ipokashitakeri kamagarini ineasanotakerira ariorika iragaveake irapakuakagakerira ganigera ikematsatairi Iriri ");
INSERT INTO mcbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ikantiri: —Irorotari vintira Itomi Tasorintsi atsi kanteronityo oga mapu ompeganakempara sekatsi pisekatakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kantankicha Jeso ikantiri: —Aityo otsirinkakotunkani Irinianeku Tasorintsi okanti: ‘Ogari sekatsi oshintsitagantavetaka kantankicha tera patiro onkogakotenkani irorori. Pairo avisake okogakotunkanira ogotasanotakenkanira magatiro ikantagetakerira Tasorintsi, irorotari shintsitagantatsi suretsiku.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Impo ariokya itentanakari enoku ochovaankakera otishi yogikoneatimotutarityo magatirosanotyo kipatsi ontiri aikiro magatiropage timantagetakarorira. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Impo ikantiri: —Maika magatiro pineagetakerira onti nashi. Narori nagaveake nompakerira tyanirika nonintakagake, kantankicha viro pintigeroaventakenarika maika pimpegakenara pitinkami, naro nompagetakempiro pashintagetakemparora, aikiro nompegakagakempi igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iniitanaatyo Jeso aikiro ikantiri: —Aityo otsirinkakotunkani okanti: ‘Gara pipegumati pashini pitinkami. Panirosanotyo Tasorintsi pinkematsatasanotake.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Impo ariokya itentanakari Jerosarenku yaratinkaigapaakera ivankoku Tasorintsi otishitapankoku onavagetiratyo enoku kara ikantiri: —Irorotari vintira Itomi Tasorintsi atsi mitaanakenityo savi, ");
INSERT INTO mcbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","okantaketari otsirinkakotunkanira okanti: ‘Intigankaigakeri Tasorintsi isaankariite irisentaigakempira. Iragaigavaempityo ganiri piparigi mapuseku.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iniitanaatyo Jeso ikantiri: —Kantankicha aityo pashini otsirinkakotunkani aikiro okanti: ‘Gara potsimajairi Pitinkami Tasorintsi pinkantanatakerira: Irorotari pagaveavagetira atsi nanityo maika neakagenaro pagaveane.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Impo yogari kamagarini inei tera iragaveeri tyampatyo inkantera pashini ovashi yontainatanaari iataatira parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Impogini ipiganaa Jeso Garireaku. Aiño itinkamitari Isure Tasorintsi yagaveakagakeri posante ovashi ikemakoigakeri maganiro timageigatsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yogotagantavagetake pankotsipageku yapatoitantaigarira jorioegi, ishineventaiganakari maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Impogini iatake Jeso Nasareku ikimotakera pairani. Impo aganakara kutagiteri apishigopireantaganirira iatake pankotsiku yapatoitantaigarira jorioegi, kantakatari irirori iatapinitira kutagiteriku apishigopireantaganirira. Impo yaratinkake iriniavantakerora Itsirinkakagantakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ovashi ipunkani sankevanti itsirinkanakerira kamantantatsirira Isaiashi pairani. Inoshikakero yampigireanakerora iriniavantakerora ineiro otsirinkakara okanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Itinkamitakena Isure Tasorintsi, ikogakagakenatari nonkenkitsatimoigakerira maganiro terira irashintavageigempa nonkamantaigakerira tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi. Itigankakena nonkenkitsatimoigakerira maganiro yagaveaigunkanirira nonkamantaigakerira tyara inkantaigakempa kameti irapakuaigaenkaniniri. Noneakagaigaerira terira inee. Nompugamentaigaerira ikisavintsaigunkanirira ");
INSERT INTO mcbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nonkamantaigakerira nonkante: ‘Maika gaka inkavintsaantavageigakempirira Tasorintsi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Impogini yagatanakera iniavantakerora yampigikairo ipairi pakeririra inkaara ipirinitanake. Maganirotyo ipampogiaiganakeri sorererere. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Impo inianake ikanti: —Okari oka pikemaigakerira noniavantakerira mataka otsatagunkani maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Maganirotyo ishineventaiganakari yogaiganaketyo kavako, ineaigaketari kametimataketyo iniaigakerira, kantankicha ikantavakagaiganaka: —¿Matsi teratyo iriro yoga itomi Jose? ");
INSERT INTO mcbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ikantaigiri: —Pinkantaigakenarorokari: ‘Vintitari gavintantatsirira, atsi gavintaempatyo vikiiro.’ Aikiro pinkantaigakerorokari: ‘Magatiro nokemakoigakerira povetsikagetakerira Kaperenaoku atsi vetsikageteroratyo maika aka pitimira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iniitanaatyo aikiro ikanti: —Arisanotyo nonkantasanoigakempi yogari kamantantatsirira tyarika iatake parikoti ishineventavunkani, kantankicha antari inavetaka itimira teratyo irishineventenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pikemakoigakerotari pairani aiñokyara Eriashi tera omparigumatae inkani avisavagetanake mavati shiriagarini intiri aikiro 6 kashiri. Itasegavageiganaketyo maganiro. Otimaigavetakatyo tovaini ogamakotagapage Iseraereku, ");
INSERT INTO mcbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kantankicha Tasorintsi teratyo ario intigankeri Eriashi iriatimoigakerora iroroegi inkavintsajaigakerora ganiri agaigiro otasegane, ontityo itigankakeri iriatakera Sarepetaku inkavintsaakerora pashini ogamakotaga terira iroro iseraere. (Ogari Sarepeta ochoenitakotakaro Suron.) ");
INSERT INTO mcbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aikiro pairani aiñokyara kamantantatsirira Eriseo itimaigavetakatyo tovaini vesegasenari Iseraereku, kantankicha teratyo irovegumate paniro, intaganityo yovegai pashini terira iriro iseraere, irirotari Naaman timatsirira Suriaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Irorotyo ikemaigavakerira ikantaigakerira ikisaigamatanakatyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ikaviriigamatanakatyo yoneagaigakarira parikoti antakona anta okaratakera apatotakara pankotsi. Itikaigavetanakari yamavageigavetanakarira otseraaku intatsinkaigakerimera, ontitari apatotaka ivankoegi otishiku. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kantankicha irirori ikenaguiganakerityo niganki yapatoigakara ovashi iatai. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Impogini iatai Jeso Kaperenaoku. Antari aganakara kutagiteri apishigopireantaganirira iatake pankotsiku yapatoitantaigarira jorioegi yogotagantavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ikemaigavakerira maganirotyo yogavageiganake kavako, ineaigaketari yogotagaigakerira yogovagetiratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ario inake kara paniro surari itimagutakerira kamagarini. Irirori ikaemagematityo kara ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Eeee! ¡Jeso Nasarekunirira, arionena gara tyara pikantaigana! ¿Tyara pinkantaigakenara? ¿Iroro pipokashitake pimpogereaigakenara? Noneimpitari, nogotakempi vinti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Inianake Jeso ikantiri: —¡Kemisante! ¡Kontetanae, piatae parikoti! Iroro ikemavakerira ogatyo ikenake yogituanakeri itimagutakerira, igenanekyatyo ikontetapanuti iokanairi, tera tyara inkantumateri. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Maganiro yogavageiganaketyo kavako ikantavakagaiganaka: —¿Pineakeri? ¡Tyarikatyo ikantaka intagatityo iniimatakerira ikematsatakeri ikontetanai! ¡Pairotyo yagaveavageti! ¡Ikoveenkavagetiratyo kara! ");
INSERT INTO mcbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Impogini maganirotyo timageigatsirira kara ikemakoigakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Impogini ikontetanaira Jeso pankotsiku yapatoitaigakara iatake ivankoku Sumo. Ogari yagashintotirira omantsigatake oanativagetakera. Ikantavunkani Jeso irovegaerora. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iatake iroroku ikanaganaka iniakero anatiri yoneagakaro. Irorori oga okenake oshavogatanai, ovashi otinaanaa opakoigakeri isekataigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Antari ishonkanaara poreatsiri ipokaigake maganiro mantsigatakogeigankitsirira yamaiganakenerira Jeso tovaini oposantetashigeigakarira mantsigarintsipage irovegaigaerira. Irirori ipatikaiigakeri igitoku paniropage yovegageigairi. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ikonogagarantaigaka onti itimaguigakeri kamagarini. Antari yoneaganontaigakarira ikonteiganaira ikaemageigamatanaketyo ikantaigi: —¡Virori vinti Itomi Tasorintsi! Kantankicha Jeso ikantaviigakeri iriniaigaera, yogoigaketari inti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Okutagitetamanakera iatanake Jeso anta parikoti omamerigitetakera, kantankicha ikogunkanityo impo yogonketakoigakari inakera. Ikogaigavetaka iragaigavakerimera ganiri iatai. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kantankicha irirori ikantaigiri: —Noataketyo nonkenkitsatimoigakerira aikiro parikotipagekunirira nonkamantaigakerira tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi impegakempara Igoveenkariegite, irorotari itigankavitakena. ");
INSERT INTO mcbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Impo iatake Joreaku ikenkitsavagetanakera pankotsipageku yapatoitantaigarira jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Impogini iatake Jeso otsapiaku inkaare opaita Jenesare. Iatashiigakeri tovaini matsigenkaegi yapatosegavageiganakatyo kara yavinaavioiganakatyo yavinajaiganakerityo Jeso irirori, ikogaigaketari inkemisantaigakerira ikenkitsavagetakerora Iriniane Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Impo ishonkanaka Jeso ineiro piteti pitotsi gatagagetaka, yogatagageigakerotari shintaigarorira yaguitaiganakera ikivaigakerora igitsare. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yogari Jeso yomatetanaka ivitoku Sumo ikantakeri iramumatanakerora nigankiakona, ipirinitake yogotagaigakeri yogaegi patoitaigankicharira otsapiaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Impo yagatanakera iniavagetakera ikantiri Sumo: —Tsame anta otsompogiatakera pinkitsaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ikanti Sumo: —Gotagantatsirira, nokitsakitsaigavetaka inkaara tsitenigetiku nopiriniventaigakero niganki okutagitetanai teratyo nagumaige, kantankicha maika virotari kantankitsi nonkañotakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iroro yovuokajaigakerora inoshikakoigavetarityo tyarika ishatekavagetempatyo shima kara, nigankityo osaraanake igitsare ");
INSERT INTO mcbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ovashi yakotashiigakeri itovaireegi naigankitsirira apiteneku pitotsi kameti iriaigakeniri iriroegi irimutakoigakerira. Impo iaigake imutakoigakerira yagaigake ishatekavageigirityo kara pitetiro pitotsi tsitigaatakotavagetaketyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yogari Sumo Perero ineakerira Jeso pairora yagaveavagetake itigeroaventamatanakarityo ikantiri: —¡Notinkami, intainatanakena, nantitari kañovagetacharira, pairotari novetsikagisevageti terira onkametite! ");
INSERT INTO mcbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Itsarogavagetanaketari irirori intiegiri itentaigakarira ineaigaketari yagaigakera tovaini shima. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Inti itentaigaka itomiegi Severeo ipaita Santiago, yogari irapitene ipaita Joan. Itsarogavageiganaketyo iriroegi aikiro, kantankicha Jeso ikantiri Sumo: —Gara pitsarogi, ganigetari iroro pipiriniventavagetai pinkitsavagetaera, irirokyatari pimpiriniventavagetae matsigenkaegi pinkematsatagaigakerira, narotari gaveakagakempine. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Impo yagatakoiganaira iokaiganakero magatiro iaigake yogiaiganakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Impogini inakera Jeso apatotakara pankotsi ikenapaake paniro vesegasenari otsonkatakerityo kara teratyo choeni. Antari ineapaakerira Jeso yompatakaventapaakari ikantiri: —Notinkamii, nokogavetaka povegaenara kantankicha impatyora viro tyarika pinkante. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yogari Jeso yakontsaanake itsagatakeri ikantiri: —Jeeje, nokogake, maika veganaempa. Irorotyo ikantakerira ogatyo ikenake yoveganaa yovesegavetakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Impo ikantavakeri Jeso: —Gara tyani pikamantumati. Inti piatimotake saserorote pokotagakemparira ontiri aikiro pamagetanakenerira piratsipage pintsatagakerora ikantakerira Moiseshi kameti ineasanotakempiniri ovashi inkantakempi vegaavi irogoigakempiniri maganiro vegasanotaavi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kantankicha ariompatyo ikemakotasanotanunkaniri Jeso iatashigeigamatirityo tovaini inkemisantaigakerira ikenkitsavagetakera ontiri aikiro irovegaigaerira imantsiganeegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kantankicha Jeso iatapiniti parikoti terira intimaige matsigenka iniakerira Iriri. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Impogini yogotagantavagetakera Jeso ario inaigake kara pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi poniageigankicharira Garireaku, Joreaku ontiri aikiro Jerosarenku. Yogari Jeso yovegageigamatirityo mantsigaigankitsirira, intitari gaveakagakeri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Impo ipokaigapaake pashini matsigenkaegi ikompitakoigapaakeri shinkogisenari terira iranuite iramaiganakenerimera tsompogi inakera Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kantankicha tyampatyo inkenakagaiganakeri inkiakagaiganakerira, patovageigakatarityo kara matsigenkaegi. Yataguigamatanaketyo enoku sotsi otishitapankoku yovenakiigakero maani ikatinkatakotakera Jeso yoguitakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Antari ineaigakerira Jeso arisano opaitaka yogoigakera iragaveakera irovegaerira ikantantakaririra shinkogisenari: —Notomi, maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yogari gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi iniasurentavageiganaka ikantaiganake: “¿Tyanimpatyora yoga ikañotagumanatanakari Tasorintsi? ¿Matsi aiño pashini gaveankitsinerira imagisantakotantaerora kañovagetagantsi?, panirotari yagaveira irirori.” ");
INSERT INTO mcbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kantankicha Jeso yogoigavakerityo iniasurentaigakara ikantaigutarityo: ");
INSERT INTO mcbNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Tyara pikantaigakara piniasurentaigakara pikañoigakerora maika? ¿Tyatimpatyo pairo avisake okomutakara? ¿Irororika nonkantakerira: ‘Maikari mataka omagisantaagani magatiro povetsikagetakerira terira onkametite, garatyo ikenkiagaimpiro Tasorintsi’, ontirika nonkantakerira: ‘Tinaanake nuitanake’? ");
INSERT INTO mcbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Maika noneakagaigakempi yagaveake Kañotasanotakaririra Matsigenka imagisantakoigaerira matsigenkaegi magatiro terira onkametite yovetsikageigirira. Impo ishonkatetanakari shinkogisenari ikantiri: —Maikari maika viro nonkantakempi tinaanake, ganaero pinoriantakarira, piatae pivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Irorotyo iniakerira igenanekyatyo itinaapanuta, yaganairo inoriantakarira iatai ivankoku ishineventavagetanakarityo Tasorintsi ikantanake: “¡Pairo ikametiti Tasorintsi! ¡Pairo yagaveavageti!” Maganirosanotyo ineaigavairi, ");
INSERT INTO mcbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ovashi yogavageiganaketyo kavako ishineventaiganakarityo Tasorintsi iriroegi aikiro, impo itsarogavageiganaketyo kara ikantaigi: —Maika noneaigake posante gakagantagetatsirira kavako. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Impogini ikontetanai Jeso ikenanake kara ineapaakeri paniro surari ipaita Irevi. Irirori onti ipirinitake anta pankotsiku itimashiigavakerira visapiniigatsirira ikogantaigavakarira koriki maganiro maiganankitsirira iarakipage ontirika tatapagerika oita, intitari kogantiniririra koveenkari koriki. Impo yogari Jeso ikantapaakeri: —Tsame, pogiatanakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Irirori ikaviritapanuta iatanake yogiatanakerira. Magatirosanotyo iokagetanakero ipiriniventavagevetarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Impogini yonkotakagantake posante ikaemakerira Jeso isekatakara ivankoku. Ario inaigake aikiro kara pashini tovaini kogantaigaririra itovaireegi koriki irashi koveenkari intiegiri aikiro pashinipage matsigenkaegi itentaigakarira isekataigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kantankicha yogari pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ikantanaigakeri irogamereegi Jeso ikantaigiri: —¿Tyara pikantaigakara pisekataigakara pitentaigakarira kogantaiginiririra koveenkari koriki intiegiri aikiro pashini kañovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Inianaketyo Jeso ikanti: —Yogari terira imantsigaige tera inkogakoigempari gavintantatsirira. Intagani kogakoigari mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ariotyo nokañotaka naro tera iriro nompokashiige terira inkañovageigempa nonkantaigakerira inkantatigaiganakempara, intityo nopokashiigake kañovageigacharira kameti inkantatigaiganakempara irapakuaiganakerora yovetsikageigakera terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Impogini ikantaigiri Jeso: —Yogari irogamereegi Joan intiegiri irashiegi pariseoegi yapakuapiniigi tera isekataigempa kameti impiriniventaigakeroniri iriniaigakerira Tasorintsi. Kantankicha yogari pashiegi pogamereegi tyara ikantaigakara tera inkañoigempari iriroegi, onti omirinka isekataigaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Impo ikantakotaka Jeso ikanti: —Pine intimera pashini ikyarira gankitsi itsinanetsite inkaemaigakeri iamigoegite isekatagaigakemparira, ¿matsi gara isekataiga? Isekataigakempaniroro, itentaigakaritari kaemaigakeririra ishinevageigaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kantankicha antari aganakempara inkisakenkanira iramanakenkanira parikoti ario pinkante impitashiigakemparotyo kogapage gara isekataigaa, inkenkisureakoiganakemparitari. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Impo Jeso ikantaigairi aikiro ikanti: —Tera onkametite pinkematsatagarantaigerora yogotagaigakempirira pariseoegi irorokya pimaigavake nogotagaigakempirira naro. Ontinirikatyo okañotakaro pagagarantera maani okyarira kamisa voviri pinkotatantemparora ogantagarira. Pinkañoterora maika onti amparatakempa kamisa okyarira ario onkañotake okotatantunkanirira okyameshinarira gara okametitantaro ogantagarira kamisa. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aikiro ontinirikatyo okañotakaro ompiaatenkanira vino okyaakyarira tekyarira ompoite ompiaatantenkanira kaverameshina igantagarira atakerira yaratsimeshinatanake. Ompoivetanakempa aravonkanake oga onkenake ontimpoanakeri imeshina ovashi ontisaraanakeri osanakempa vino, aikiro iraparatakempa imeshina irisaraanakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nerotyo pairo okametitake ompiaatantenkanira ikyameshinakyarira kameti ganiri aparaata vino, aikiro ganiri yaparata imeshina. ");
INSERT INTO mcbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aikiro tyanirika viikarorira vino ogantagaari teratyo inkogumataero okyaakyarira, ontityo ikantake: ‘Ogari ogantagaari pairotyo avisake okametiatakera.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Impogini aganakara kutagiteri apishigopireantaganirira iatake Jeso ikenanake turigoshiku itentaiganaari irogamereegi. Iroro ikenaiganakera kara yagaiganake turigoki impo yamegikaigakero yogaigakarora. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Irorotyo ineaigakerira pariseoegi ikantaigutarityo: —¿Tyarikatyo pikantaigakara viroegi pagaiganakera turigoki? Maika ontitari kutagiteri apishigopireantaganirira, okantavitantaganitari antavagetantenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Inianake Jeso ikantaigiri: —¿Matsi tera piniavantumaigero viroegi otsirinkakotunkanira yovetsikakerira Iravi pairani? Itaseganake irirori intiegiri itentaigakarira, mamerisanotyo tatampatyo irogaigakempa, ");
INSERT INTO mcbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","impo ikiamatanaketyo ivankoku Tasorintsi yogakarora pan okantavitantaganirira ogenkanira, ontitari irashi Tasorintsi. Intagani gaigaro saseroroteegi, ariotari ikantiri Tasorintsi. Kantankicha yogari Iravi yogakarotyo, aikiro ipaigakeri itentaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ikantaigakeri aikiro: —Yogari Kañotasanotakaririra Matsigenka irirotari kantatsirira tyati okantavitantagani antantenkanira kutagiteriku apishigopireantaganirira, aikiro tyati terira onkantavitantenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Impogini agaara pashini kutagiteri apishigopireantaganirira iatake Jeso pankotsiku yapatoitantaigarira jorioegi yogotagantavagetakera. Ario inake kara paniro shinkovakori irakosanoriraku tera iragavee irakotumagetera. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yogari gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi ikamagutasanoigakerityo Jeso ineaigakerira ariorika irovegaeri kutagiteriku apishigopireantaganirira kameti intsavetantaigakeriniri inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kantankicha irirori yogotaketyo isureigakarira nerotyo ikantantakaririra shinkovakotankicharira: —Atsi aratinke ineaigakempira maganiro. Irirori ikaviritanaka yaratinkanake. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Impo Jeso ikantaigiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi: —Maika atsi nonkogakotagantaigakempira. ¿Tyara ikanti Moiseshi pairani? ¿Tata ovetsikakenkani kutagiteriku apishigopireantaganirira? ¿Ario ikanti ovetsikakenkanira kametiri ontirika ovetsikakenkanira terira onkametite? ¿Ario ikanti aganiaigavaerira atovaire ontirika ikanti agamagaigakerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Impo ipampogiaigakeri maganiro patoventaigakaririra ikantiri shinkovakotankicharira: —Atsi kontsaanake. Irorotyo yakontsaanakera ogatyo okenake irako paa vegasanovagetaa kañotasanovagetaatyo apipakotene. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kantankicha iriroegi ikisaigamatanakatyo kara ikantavakagaiganakara tyarika inkantaigakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Impogini iatake Jeso itonkoanake otishiku iriniakerira Tasorintsi. Iniakeri niganki okutagitetanai ");
INSERT INTO mcbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","impo ikaemaigakeri irogamereegi iriroku ovashi yagaigake 12 ipegakagaigakari iritigankaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Maganiro yagaigakerira onti ipaiigaka: Sumo, ipaitairira aikiro Perero; Anturishi, irirenti Sumo: Santiago, Joan, Jeripe, Varitorome, ");
INSERT INTO mcbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomashi, Santiago, itomi Arejeo; Sumo komperagetatsirira, ");
INSERT INTO mcbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jorashi, itomi Santiago, intiri aikiro Jorashi Ishikariote, gakagantakeririra Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Impo yanonkaa Jeso itentaigaari irogamereegi ipitaigapaake opampatakera. Yapatoventaiganakarityo pashini irogamereegi itovaigavagetityo kara intiegiri aikiro pashini poniageigankicharira parikoti Joreaku ontiri Jerosarenku intiegiri aikiro poniaigankicharira otsapiapageku Tiro ontiri Suron. Onti ipokashiigake inkemisantaigakerira Jeso inkenkitsavagetakera ontiri aikiro irovegaigaerira imantsiganeegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yogari itimagugeigakerira kamagarinipage yoneaganontaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Maganirotyo ikogaigake intsagaigakerira, ineaigakeritari yagaveavagetakera yovegageigamatirityo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Impogini ipampogiaigakeri Jeso irogamereegi ikantaigiri: “Pairo okametitake pinkantaigakera: ‘Garika itsarogakagana Tasorintsi tyampa nonkantakempa, teranika tatakona nagaveimageti naro tsikyata.’ Antari pinkañoigakemparika maika ario pinkante pishinevageigakempa impegakempatari Tasorintsi Pigoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Pairotari pishinevageigakempa maganiro viroegi kogasanoigankitsinerira pintsatagageigakerora magatiro ikogagetakerira Tasorintsi, iragaveakagaigakempitari irirori pinkañoigakerora maika. “Pairotari pishinevageigakempa impogini maganiro viroegi onkenkisureakagaigakemparira maika tatapagerika oita terira onkametite, irogishineaigaempitari Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Maika atsi shinevageigempa viroegi pineaigakera inkisaigakempira pitovaireegi ineaigakempitari pikematsaigakerira Kañotasanotakaririra Matsigenka. Ariorika gara ikogaigi pinkonoiigakemparira onti iriniashinaigakempi ontiri aikiro inkantaigakempi tera pinkametiige. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yogari yashikiiganakeririra ario ikañoigakeri kamantantaigatsirira pairaninirira ikisaigakerira. Antari pineaigakera inkañoigakempira maika, pishinevageigakempatyo kara pinkavakavavageigaketyo, pogoigaketari pairotyo irogishineavageigakempi Tasorintsi impogini anta enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Kantankicha maikaniroro pantsipereavageigake viroegi shintavageigacharira kantaigatsirira: ‘Tera nonkogakotempa intsarogakagakenara Tasorintsi, panirotyo naro nagaveake!’ Gatanika tyani gishineaigimpi impogini, matakatari pishinevageigaka maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Maikaniroro pantsipereavageigake viroegi terira pisuretakotumaigempa maika, onti pikantaigake: ‘Tera tatoita nonkogakotumaigempa!’ Impoginitari pisuretakoigavetanakempa pinkogaiganakera inkavintsajaigakempira Tasorintsi, kantankicha garatyo itimumati kavintsajaigakempinerira ontityo inkisashiitakempi. “¡Maikaniroro pantsipereavageigake viroegi shinevageigankicharira maika, pishineventaigakarora magatiro kipatsipagekutirira! Impoginitari pinkenkisureavageigakempa inkisashiitakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Maikaniroro pantsipereavageigake viroegi irishineigakempirika maganiro! Ariotari ikañoigakariri yashikiiganakeririra pairani ishineigakarira kamantantaigatsirira matagavageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Maika viroegi kemisantaigakenarira nonkantaigakempi aikiro. Pintsarogakagaigakemparira kisashiigakempirira, aikiro pinkavintsaavageigakerira kisaigimpirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yogari kantaigakempinerira: ‘Ineashitempatyo’, viroegi pinkantaigakeri: ‘Nokogake inkavintsaavagetakempira Tasorintsi.’ Piniaventaigakerira kisavintsaigimpirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ariorika intimake taakempinerira pivoroku gara pipugatari. Aikiro ariorika iragapitsaitakempiro pimanchaki enokutirira gara pitsaneanakaro savitirira irorori. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pintsarogakagakemparira nevitakempinerira tatarikara oita pimpakerityo ikogakotakarira, aikiro tyanirika gapitsatakempine pashintarira gara pikenkiakonatairo. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pikogaigakerika inegintevageitakempira iroroventi pinegintetantavageigaketyo viroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Antari intaganirika pinkavintsajaigake kavintsajaigimpirira, ¿matsi tatatayo irishineviigakempi Tasorintsi? Ariotari ikañoigari maika terira inkematsaigeri ikavintsajaigirira kavintsajaigiririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ontirika intagani pinegintevageigake negintevageigimpirira viroegi, ¿matsi tatatyo irishineviigakempi Tasorintsi? Ariotari ikañoigari maika terira inkematsaigeri iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ario okañotaka aikiro intaganirika pampinaigake gipigaigaempinerira, ¿matsi tatatyo irishineviigakempi Tasorintsi? Ariotari ikañoigari maika terira inkematsaigeri yampinavakagaigara, ineaigaketari irampinatantaigakerika irogipigaigaenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kantankicha viroegi nonkantaigakempi pintsarogakagaigakemparira kisashiigimpirira, pinkavintsaantavageigakera, aikiro pampinatantavageigakera kogapage gara onti pogiakoiga irogipigaigaempira. Pinkañoigakemparika maika inkavintsaavageigakempi Tasorintsi timatsirira enoku ovashi pinkañotasanoiganakempari irirori ikavintsaavageigirira terira isuretakotumaigempari onti ikiiro suretakoigaacha. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsarogakagantavageigempa pinkañoigakemparira Piri Tasorintsi itsarogakagantavagetara. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Viroegi gara piniashinaigari pitovaireegi kogapage pinkantaigakera yovetsikaigake terira onkametite ganiri ikisashiigimpi Tasorintsi impogini. Tatarika yovetsikake pashini terira onkametite gara pikogaigi inkisashiigakemparira Tasorintsi ganiri imaigimpi viroegi impogini inkisashiigakempira. Gara pikenkiagantavageigi ganiri ikenkiagaigimpiro Tasorintsi pikañovageigakara viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pinkavintsaantavageigakerika viroegi ario inkañotagaigakempi Tasorintsi irirori inkavintsaavageigakempi. Gara maani ikavintsajaigimpi Tasorintsi teranika imichatumagetempa irirori, inkavintsaasanovageigakempityo kara. Tyanirika pairorira iravisake inkavintsaantasanovagetakera pairotyo inkavintsaakenkani irirori, kantankicha yogari ogakonarira ikavintsaantake ariotyo inkañotagaenkani irirori ogatonatyo inkavintsaakenkani.” ");
INSERT INTO mcbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Impo inianai Jeso ikantakotakeri gotagantatsirira ikanti: “¿Matsi iragaveake inkatsatantanakera terira inee inkatsatanakerira irapitene terira inee? ¿Matsi gara yashiriaiganaka piteniro otseraaku? ");
INSERT INTO mcbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tyanirika yogotagunkani tera iravisumateri gotagiririra, kantankicha antari intsotenkakagakeririka irogotagakerira ario pinkante inkañotakempari irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Tyara pikantakara pikanomajaigirira pitovaire vetsikaigirorira terira onkametite? ¿Matsi tera pineero pashi virompatyo viro pairo pogagaka? ");
INSERT INTO mcbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kañomatakatyo ontinirika pikantanakeri: ‘Atsi taina nogotagakempira ganigeniri pikañovagetaa’, tenirikatyo pineemparo viro tyarikaroro apatoventavagetakempityo kara. ¡Ontityo pineakagantavintsatakara! Atsi negintetasanovagetempanityo viro kameti pagaveakeniri pinkanomaantakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ogari inchatopage timatsirira oi ogaganirira gara agaveimati ontimera oi terira ogenkani. Ario okañotaka inchatopage timatsirira oi terira ogenkani gara agaveimati ontimera oi ogaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Magatiro inchato onti oneantagani oi. Pine igo tera ario ontimantemparo kivitsa. Ario okañotaka ova tera ario ontimantemparo tanko. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ario ikañotaka matsigenka negintevagetacharira onti iniakogeti kametiripage, irorotari isuretakogetaka. Yogari terira inegintevagetempa onti iniagisevageti posante, irorotari isuretakogetaka irirori. Magatirotari osuretakotunkanirira irorotari oniakogetunkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Tyara pikantaigakara viroegi pikantaigakenara kogapage: ‘Notinkami, Notinkami’, kantankicha tera pintsatagaigero nokantaigakempirira? ");
INSERT INTO mcbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Maika nonkantaigakempi tyani ikañotaka yoga tyanirika pokashitakena ikemisantakenara impo ikematsatakena itsatagagetakerora nokantakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Onti ikañotakari matsigenka yovetsikake ivanko ikigantashitakero yogavagetakerotyo savi kameti onkusotasanotakeniri. Impogini okimoavetanaka nia apamankakotanakero oshintsiavagetityo kara, kantankicha teratyo agaveimatero oakerora, ovatikavagetakatari savi okusotantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yogari kemisantavetakenarira kantankicha tera irovetsikero nokantakeririra onti ikañotakari pashini yovetsikavetaka ivanko tera irogero savi, tatampa onkusotantakempa. Impo okimoatanake nia apamankakotanakero oshintsiatanake otuanakero akya amanakero otsonkatasanotakerotyo kara.” ");
INSERT INTO mcbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yagatanakera Jeso inianiaigakerira iatake Kaperenaoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ario kara itimi paniro iromano. Irirori inti itinkamiegi soraroegi. Imantsigavagetake iromperane pairorira itasanotari, panikyatyo inkamavagetanake. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Irorotyo ikemakotavakerira Jeso itigankaigakeri itinkamiegi jorioegi inkantaigakiterira irovegaatenerira iromperane. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Impo iaigake ikantaigapaakeri: —Notinkami, nokogasanoigaketyo piatakera povegaatenerira iromperane itinkamiegi soraroegi, pairotari ikametitake irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Itasanoigakari jorioegi yovetsikakagantaigakenaro pankotsi napatoitantaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Impo iatake Jeso yogiaiganakerira. Antari yagaigavetanakarora aiñoni pankotsiku itonkivoaigakari iamigoegite itinkamiegi soraroegi. Irirori onti itigankaigakeri intonkivoaigavakemparira inkantaigavakerira: —Maika ikantake: ‘Notinkami, gara patsipereaventana pimpokashivagetakitenara novankoku. Garorokari pikiimatiro, nogotaketari vinti gaveavagetatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nerotyo tera nagavee naro tsikyata noatakera nonkantakitempira. Piniimatakera intagatityo irovegantanaempa nomperane. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kañotari naro itimavetari peraiganarira, akyari itimi nashi nomperaneegi. Tyarikara nonintake nontigankakerira ikematsatakenatyo iatake. Pashinikya nokaemirira ipokake. Aikiro aiño pashini tatarika nomperatakari ikematsatakenatyo.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iroro ikemavakerira Jeso ikantakera maika yoganaketyo kavako ishonkateiganakari maganiro giaigapaakeririra ikantaigiri: —Arisanotyo nonkantasanoigakempi teratyo noneimageteri paniro Iseraerekunirira inkañotakemparira yoka iromano yogotasanotakera nagaveavagetira. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Impo yogari iritigankaneegi itinkamiegi soraroegi ipigaigavetanaa pankotsiku ineaigapaakeri vegasanotaa iromperane. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Impogini iatake Jeso Nainku yogiaiganairi irogamereegi intiegiri aikiro tovaini matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Impo yagapaakerora aiñoni itimaigira itonkivoaigavakari yamakoigapaakerira igamaga inkitaigaaterira. Inti otomi ogamakotaga, panirosanotyo ikantakara irirori otomintakarira. Itsaisevagetanakatyo matsigenkaegi kara giaiganakerorira tomintaririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Itsarogakaganakaro Atinkami ineakerora iragakara ikantiro: —Gara piraga. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ishigatetanakaro yoyagantakarira itsagatakero. Yogari natakoiganakeririra asatyo yaratintiitake. Impo ikantiri Jeso kamankitsirira: —Viro, nonkantakempi tinaanae. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Impo yogari kamavetankicharira itinaanaka ipirinitake inianai. Yogari Jeso ikantiro iriniro: —Neri yoga pitomi. Yogari otomi inti ikyaenka gaenokanankicha. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Irorotyo ineaigakera maganiro yoganiairira itsarogavageiganaketyo kara, aikiro ishineventaiganakari Tasorintsi ikantaigi: —Itigankimoigakai Tasorintsi kamantantatsirira gaveavagetatsirira. Tera imagisantaigajae ikavintsaavageigakai, antiegitari irashiegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Impo maganirotyo timaigatsirira Joreaku intiegiri aikiro choenitakogetankitsirira ikemakoigakeri Jeso yoganiairira igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Impogini yogari Joan ikemakotakeri Jeso yovetsikagetakera posantepage terira oneimagetenkani, intitari kamantaigakeri irogamereegi. Impo ikaemakagantaigake piteni itigankaigakeri inkantaigakiterira: “¿Virorika nogiaigakerira, ontirika atanatsi nogiaigera pashini iripokakera?” ");
INSERT INTO mcbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Impo iaigake yogonkeigapaaka inakera Jeso ikantaigapaakeri: —Notinkami, itigankaigakena Joan Giviatantatsirira nonkantaigakitempira, ¿virorika nogiaigakerira ontirika atanatsi nogiaigera pashini iripokakera? ");
INSERT INTO mcbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Antari yogonkeigapaakara ineakoigapaakeri yovegageigairira tovaini mantsigaigankitsirira ikonogagarantaigaka ogageigakeri mantsigarintsi koveenkatatsirira. Yogari itimagugeigakerira kamagarinipage yoneaganontaigakari. Aikiro ineakagageigairi teirra inee. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Impo ikantaigavakeri Jeso ikanti: —Maika piaigae pinkamantaigapaakerira Joan magatiro pineageigutirira ontiri pikemageigutirira. Yogari terira ineaigavetempa ineaiganake. Yogari terira iranuitagantsiigavetempa yanuitagantsiiganake. Ario ikañoigaka vesegaigavetankicharira yovegaiganaa. Yogari terira inkemaigavetempa ikemaiganake. Aikiro yogari igamagapage yaniaiganai. Intiegiri aikiro terira irashintavageigempa ikenkitsatimoigunkani ikamantaigunkani tyara inkantaigakempa kameti irogavisaakoigakenkaniniri. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Irishinevagetakempa tyanirika kantakanirira inkematsatasanotakenara gara yapakuimatana! ");
INSERT INTO mcbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Impo iaiganaira iriroegi, iniavagetanake Jeso iniakotakerira Joan ikantaigiri maganiro: “¿Tatoita piatashiigakiti anta osarigagitetapaakera? ¿Iriro piatashiigakiti pineaigakitirira matsigenka terira ishintsitashigetero magatiro matavitantagantsi, irorokya ikanti irorokya ikanti? ¿Ario ikañotakaro savoroshi amirora tampia akya otuiti akya otuiti? ");
INSERT INTO mcbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ario tatatyo piatashiigakiti? ¿Iriro piatashiigakiti pineaigakitirira matsigenka gagutacharira mechomagori kamisa? Pogoigaketari maganiro gaguigacharira mechomagori kamisa onti ipirinitaigi ivankoku koveenkari, omirinka ipiriniventaigi tatarika oita ishineventavageigakarira iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iroroventi ¿tatatyo piatashiigakitira? ¿Iriro piatashiigakiti pineaigakitirira kamantantatsirira? Jeeje, irironiroro, kantankicha pairo yavisavagetakeri kamantantatsirira, ");
INSERT INTO mcbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","irirotari itsirinkakotunkanirira pairani iniakerira Tasorintsi Itomi ikantiri: ‘Notomi, impogini nontigankake paniro ivatanakempinerira inkantaigakerira itovaireegi inegintetashiigavakempira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Maika nonkantaigakempi maganirosanotyo matsigenkaegi tera intimumate paniro visakerinerira Joan, kantankicha tyanirika yogavisaakotake Tasorintsi ipegakara Igoveenkarite, irirori pinkante yavisakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Maganiro kemaigavakeririra Joan ikenkitsavagetakera ikantaigakeri irogiviaigakerira, ineaigaketari ikantasanoti Tasorintsi ikantakera intiegi kañovageigacharira. Ario ikañoigaka yogaegi kogantaigaririra itovaireegi koriki irashi koveenkari yogiviatagantaigaka iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kantankicha yogari pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi teratyo irogiviatagantaigempa. Ikogavetaka Tasorintsi inkavintsajaigakerira kantankicha iriroegi tera inkogaige inkematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Tatarikatyo nonkañotagaigakempi viroegi? ¿Tata pikañoigaka? ");
INSERT INTO mcbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inti pikañoigaka ananekiegi impitaigera pampatuiku imagempivageigakera impo ovashi inkisavakagaiganakempa inkantaige: ‘Nokovutimoigavetakempi teratyo pintiontaigempa. Impo nomatikimoigavetakempi matikagantsi kenkisureaenkatavagetakatyo kara teratyo piragaigempa.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ariotari pikañoigakari viroegi. Ipokavetaka Joan tera isekatavagetempa, aikiro tera iroviikumatemparo poiri, onti pikantaigakeri itimagutakeri kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Impo maika ipokavetaka Kañotasanotakaririra Matsigenka isekata, aikiro yoviika ariokya pikantaigakeri: ‘Pairo isekaata aikiro pairo ishinkiseta, aikiro inti itsipaiga kogantaiginiririra koveenkari koriki intiegiri pashini kañovageigacharira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kantankicha ogotunkani tyani kematsatasanotiri Tasorintsi aikiro tyani terira inkematsateri, ontitari oneantunkani yovetsikagetakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Itimake paniro pariseo ikaemakeri Jeso isekatagakemparira ivankoku. Impo iatake Jeso ikiapaake isekatavagetaka mesaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Otimake paniro tsinane pogereantatsirira ario otimi kara. Impo okemakotakerira Jeso iatakera isekatakara ivankoku pariseo oatake amakotanake kasankaari opiaatantunkani ovetsikashitunkanirira aravasetero. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Impo ogonketapaakara inakera Jeso aratinkapaake igitiku iraganaka ashiriaatanaka oakia osagutanakeri ivonkitiku. Impo osevonkitiantaari ogishi asaraanavonkitinatakarityo, aikiro osaguvonkititantakari kasankaari. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Antari ineakerora pariseo kaemakeririra Jeso ivankoku iniasurentavagetanaka ikanti: “Arisanorika iriro yoka kamantantatsirira irogotaketyo tyani tsagatakeri, irogotakerotyo tyara okanta, ontitari pogereantatsirira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Impo inianake Jeso ikantiri: —Sumo, nokogake nonkantakempira. Ikantiri: —Je'ee, Gotagantatsirira, atsi nani, kantena. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ikantiri Jeso: —Itimake piteni surari ipegakoigakeri pinatantatsirira koriki. Paniro ipegakotakeri 500 tenario. Yogari irapitene intagani ipegakotakeri 50. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kantankicha iriroegi mameri igorikiegite tyampa iragaigakeri impunaigaerira. Impo ikantaigakeri pinaigakeririra: ‘Iroroventi ario inkañotake, mameritari.’ Maikari atsi kantena ¿tyanirorokari pairo shinetasanotakari? ");
INSERT INTO mcbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ikanti Sumo: —Impa irirorakari yoga pairorira yavisake ipegakotasanovetakarira. Ikantiri Jeso: —Pikantasanotakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Impo ikamagutanakero tsinane ikantiri Sumo: —Nokiavetapaaka pivankoku tera pimpakotavakena nia nonkivavonkititakempara. Maika ¿pineakero oga tsinane? Irorori okivavonkititantakenaro oakia, osevonkitiantaanaro ogishi. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aikiro tera pasaraanatavakena, kantankicha irorori asaraanavonkititanani inkaara ovashi maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tera pintiritavakena aseiteku nogitoku, kantankicha irorori osaguvonkititantakenaro kasankaari. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Irorotari maika nonkantakempi oshineventasanotakena oneaketari magisantakotaa magatiro ovetsikagisevagevetakarira terira onkametite. Kantankicha yogari neankicharira tesakona inkogakotempa imagisantakotakenkanira yovetsikagetakerira terira onkametite gasakonatyo ishineventasanotana. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Impo ishonkatetaro tsinane ikantiro: —Maikari mataka omagisantaagani magatiro povetsikagisevagetakerira, gara ikenkiagaimpiro Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Impo yogaegi ikaemunkanirira itentaigakarira isekataigakara ikantavakagaigamatanakatyo: —¿Matsi tyanimpatyora irirori kameti iragaveakera inkantakerora: ‘Maikari mataka omagisantaagani magatiro povetsikagisevagetakerira, gara ikenkiagaimpiro Tasorintsi’? ");
INSERT INTO mcbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kantankicha Jeso ikantutaaro aikiro: —Maika yogavisaakotakempi Tasorintsi, pineakenatari nagaveake nonkantakera omagisantaagani magatiro povetsikagisevagetakerira. Maika piatae pishinevagetakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Impogini iatake Jeso itimageigira matsigenkaegi yapatoitasanotara ontiri aikiro itimageigira terira intovaigasanoige, ikenkitsatimoigakeri maganiro ikamantaigakerira tyara inkantakempa Tasorintsi irogavisaakoigakerira maganiro kematsaigakerinerira impegakempara Igoveenkariegite. Itentaiganaari iritigankaneegi naigatsirira 12. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aikiro ogiaiganakeri tsinaneegi yoneaganontaigakarira itimaguigavetakarora kamagarini, ontiri aikiro yovegaigakerira omantsigaigakera. Ario onake Maria Magarena yoneaganontakarira itimaguigavetakarora 7 kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Otentaigakaro aikiro Sosana ontiri aikiro Joana, itsinanetsite Kosa inampina Erorishi neagetiniririra magatiro. Oaigake aikiro pashini tsinaneegi. Iroroegi onti mutakovageigiririra Jeso opaigirira koriki kameti impunaventaigakera tatarika ikogakogeigaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Impogini inakera Jeso kara parikoti iatashiigakeri tovaini matsigenkaegi yapatoventaiganakarityo. Impo irirori ikantakotantake ikantaigiri maganiro: ");
INSERT INTO mcbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iatake paniro matsigenka impankivagetakera turigoki. Iokagisetanakero pakarara pakarara itsotenkavagetanakero. Okonogagarantaka oparigigetanake avotsiku, impo agatitinatunkani. Impo iparigashiigakero tsimeri yogaigakarora. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pashini okonogagarantaka oparigigetanake mapuseku, shintsi oshivokavetanaka kantankicha oroganake okamai, orovatsataketari kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Okonogaka pashini oparigigetanake okitagigetakara okitsoki tovaseri timatsirira otsei. Impo oshivokavetanaka turigo ogenanekyatyo oshivokutanaka tovaseri irorori asaganakero okamai, tera ontime okitsoki. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pashini okonogaka oparigigetanake okametipatsatakera kipatsi. Irorori pinkante oshivokanake okimotanake otimanake tovaiti okitsoki, okonogaka otimake 100.” Iroro ikantakera Jeso maika inianake ikimoenkatanake ikanti: “¡Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira!” ");
INSERT INTO mcbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Impogini yogaegiri irogamereegi ikantaigiri: —¿Tatatyo oitara pikantakotake inkaara? ");
INSERT INTO mcbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Irirori ikantaigiri: —Pairani tera ogovetenkani tyara inkantaigakeri Tasorintsi matsigenkaegi irogavisaakoigakerira kameti impegakempara Igoveenkariegite. Maikari maika ikogake pogoigakerora viroegi. Antari nogotagaigirira pashinipage onti nokantakogetakero magatiro kametiniri ‘ineaigavetakempatyo kantankicha impegaiganakempa kañomataka tenirikatyo ineaige. Inkemaigavetakempa aikiro, kantankicha onti onkomutapitsaigakempari.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Maika nonkamantaigakempi tatoita nokantakotake inkaara. Ogari turigoki onti nokantakotake okenkitsataganira Iriniane Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ogari parigigetankitsirira avotsiku inti nokantakoigake matsigenka kemisantaigavetakarorira Iriniane Tasorintsi, kantankicha igenanekyatyo ipokashiigakeri kamagarini imagisantakagaigakeri magatiro ganiri ikematsaigi kameti ganiri yogavisaakotagani. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ogari parigigetankitsirira mapuseku inti nokantakoigake kemisantaigavetakarorira Iriniane Tasorintsi ishineventaigavetavakaro, kantankicha tera inkematsatasanoigero. Impogini opokashitakeri tsipereagantsi oga ikenaigake yapakuaiganairo ikañoiganaara okyara tekyara inkematsatumaige. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ogari parigigetankitsirira okitagigetakara okitsoki tovaseri inti nokantakoigake kemisantaigakerorira Iriniane Tasorintsi ikemaigavetavakaro, kantankicha impogini isuretakoiganakaro tatarika oita yovankinaventaiganakaro. Ishineventaiganakari koriki ontiri tatarika ikogageigakerira irirori ovashi tyampa inkantaigakempa inkematsatasanoigakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kantankicha ogari parigigetankitsirira okametipatsatakera kipatsi inti nokantakoigake suretakoigarorira kametiripage. Iriroegi ikemisantaigakero Iriniane Tasorintsi ikematsatasanoigakero impo ariompatyo ikematsatasanoiganakerori. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Antari yogimataganira mechero tera ario intatakotenkani kovitiku. Aikiro teratyo ario irovirinitakotenkani otapinaku menkotsi omagantaganirira. Ontityo yovitakotagani menkotsiku kameti inkoneagitetakoigakeniri maganiro pitaigankitsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ario okañotaka tatarika oita managetankicharira maika impoginityo ogikoneatakenkani. Aikiro tatarika oita terira ogotenkani maika impoginityo ogotakenkani, ganigetari omanumataa. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Irorotari maika kemisantasanoigena nonkantaigakempira. Yogari kemavakerorira Iriniane Tasorintsi irirori irogotagakeri ariompaniri inkemasanotanakerori. Irirokya terira inkoge inkemavakerora ariompatyo imagisantanaerori magatiro ikemavetakarira, tesakonatari irogotasanotenika.” ");
INSERT INTO mcbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Impogini opokake iriniro Jeso intiegiri irirentiegi pankotsiku inakera irirori, kantankicha tera inkiaige tsompogi onti inaigapaake sotsi, itikaigakeritari tovaini matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Impo ikamantunkani Jeso ikantagani: —Pokake piniro intiegiri pirentiegi aiño inaigake kara sotsi ikogaigake ineaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kantankicha irirori ikanti: —Yogari kemisantaigakerorira Iriniane Tasorintsi aikiro itsatagaigakero, iriroegi pinkante nopegaigake ina intiri aikiro igeegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Impogini itentaiganakari Jeso irogamereegi iaigakera inkaareku yomateiganaka pitotsiku ikantaigiri: —Tsame intati. Impo iaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Antari yamaatakoiganakera imaganake Jeso. Impo otampiamatanaketyo omaranerikatyo tampia kara jiriririri ogatyo okenake ovoresekantanake oshatekaatanaka nia pitotsiku panikyatyo ontsitiganake. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ishigateigamatanakarityo Jeso yogireaigutarityo ikantaigakerira: —¡Gotagantatsiriraa! ¡Gotagantatsiriraa! ¡Atake atsitigakoiganake! Itinaamatanakatyo Jeso inianakerora tampia ikantiro: —¡Peganaempa, intaga pitampiati! Iniiro aikiro inkaare ikantiro: —¡Maireatanae! Ogatyo okenake opeganaa tampia, ario okañotaka inkaare irorori omaireatanai. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Impo ikantaigutarityo irogamereegi: —¿Tyatirityo maika pikematsaigakenara pogoigakenara nagaveavagetira? Kantankicha iriroegi itsarogavageiganaketyo yogaiganakera kavako ikantavakagaiganakara: —¿Tyanimpatyora yoga, iniimatakerora tampia ontiri nia okematsatakeri? ");
INSERT INTO mcbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Impo yogonkeigamataka Jerasaku katinkasanotyo ontatikyatakera Garirea. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iroro yaguivetanakara Jeso ineiri ikenapaake paniro surari timatsirira kara. Itimagutakeri kamagarini yapatoventaigakarityo kara ishiriagakogematatyo. Tera irogagutempa, aikiro tera intime pankotsiku onti itimi imperitanakiku yogantaganirira igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Otimake kutagiteri ipigatagagematirityo kara. Yaganavetunkanityo yogusotantanavetunkani karenatsa irakoku ontiri igitiku ipampogiasanotunkani, kantankicha teratyo iragaveenkani, ontityo itimpatuagematirotyo kara, impo yogari kamagarini ishigakagagematanakarityo anta parikoti terira intime matsigenka. Irorotyo ineavakerira Jeso itigeroaventamatanakarityo ikaemanakera: —Virori vinti Jeso Itomi Tasorintsisanorira timatsirira enoku. ¿Tyara pinkantakenara? Atsi garatyo patsipereakagana. ¡Tsarogakagavagetenakario! Ikantantakaririra maika matakatari ikantakeri Jeso kamagarini inkontetanaera iokanaerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Impo ikantiri Jeso: —¿Tyara pipaita? Ikanti irirori: —Onti nopaita Tovainirira. Ikantantakarira maika, tovainitari inaigake timaguigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iriroegi ikantaigakeri Jeso ganiri itigankaigiri savipatsaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ario inaigake shintori kara otishiku isekatavageigakara itovaigavagetiratyo kara. Impo yogari kamagarini inianiaiganakeri Jeso ikantaigakerira intigankaigakerira intimaguigakerira shintori. Irirori ikantaigirityo: —Nanityo piaige. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Igenanekyatyo ikonteigapanuti iokaiganairi itimaguigavetakarira irirokya iatashiigavetaka shintori. Iroro itimaguigavetapaakarira ogatyo ikenaigake ishigaiganaka otseraaku yanonkaiganaka iokaavioigaka pokorom pokorom pokorom, ipogereaigakatyo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iroro ineaigavakerira sentaigiririra itsarogavageiganaketyo kara ishigaiganaka iaigai ikamantantaigapaakera anta itimaigira itsotenkavageiganakerotyo, ikemakotantaigavakaririra timaigatsirira kara intiegiri aikiro timageigatsirira parikotipageku. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ikemakoigakerira maganirotyo iaigake inkamosoiguterira. Impo yogonkeigapaakara inakera Jeso ineaigapaakeri itimaguvetakarira kamagarini pirinitake inampinaku ikemisantakerira. Gagutaka manchakintsi kañotasanovagetaatyo ikyara. Iroro ineaigakerira itsarogavageiganaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Maganiro neaigakeririra yoneaganontakarira ikamantageigavakeri tyara ikantakeri yoneagaigakarira timaguigavetakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Impo maganiro timaigatsirira Jerasaku ipinkaiganakerityo Jeso ikantantaigakaririra: —Nokogaigavetaka piataera parikoti. Ovashi yomatetanaa pitotsiku iriataera. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Impo yogari itimaguvetakarira kamagarini ineavakerira iatanaira ikogavetaka irogiatanakerimera ikantiri: —Nompoke naro. Kantankicha irirori ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Gara pipoki. Ariompa piatae pivankoku pinkamantantapaakera tyara ikantakempi Tasorintsi itsarogakagakempira. Irirori iatai ikamantageigapaakeri maganiro timaigatsirira kara itsarogakagakarira Jeso yoneagaigaarira kamagarini timaguigavetakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Impogini ipiganaa Jeso imonteanaa intati. Maganirotyo yagaigavairi ishineventaigavaarira, igantagatari yogiaigairira. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Impo ikenapaake paniro jorio ipaita Jairo. Irirori inti tinkamitatsirira pankotsiku yapatoitantaigarira jorioegi. Iroro ineapaakerira Jeso itsatimatashitapaakerityo yompatakaventapaakarira ikantakerira iriatakera ivankoku, ");
INSERT INTO mcbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","omantsigavagetanaketari panirosanorira irishinto panikya onkamanake. Antari iatanakera Jeso yogiaiganakerityo tovaini matsigenkaegi itsaiseventanakarityo kara panikyatyo inkanaroaiganakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ario onake aikiro kara paniro tsinane mantsigavagetankitsirira oseriintevagetanityo pairani ogatyo onakotanake 12 shiriagarini. Yogavintanaigavetakarotyo gavintantaigatsirira teratyo ovegaempa ariompatyo oatiri, niganki otsonkatasanotanakeri ogorikite ogasanotakatyo noganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Irorori opokake okenashitapaakeri Jeso itishitaku otsagatakotapaakeri okaratsaiku imanchaki. Irorotyo otsagatakotakerira ogatyo okenake okaraagapagenityo oriraa. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Inianake Jeso ikanti: —¿Tyani tsagatakotakena nomanchakiku? Ikantaiganaketyo maganiro: —Tera tyani tsagatakotempine. Kantankicha iniamatanaketyo Perero intiegiri itentaigarira ikantaigi: —Gotagantatsirira, pineavetakarityo yavinaavioiganakempira itatsinkanaiganakempira kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kantankicha Jeso ariompatyo inianakeri ikanti: —Aiño tsagatakotakenarira, noneakatari novegantaarora nagaveane. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Irorori oneakera yogotakerora okenamatapaaketyo iriroku oshigekanakera shige shige shige ompatakaventapaakarira okamantakerira tatoita otsagavitakeri, aikiro okamantakeri okanti: —Irorotyo notsagatakotakempira ogatyo okenake okaraagapagenityo noriraa. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Irirori ikantiro: —Noshinto, maika pogotaketari nagaveakera novegaempira, nerotyo povegantaarira. Maikari maika piatae pishinetakempara gara pikenkisureaa. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Impo aiñokyara iniiro ikenapaake pashini iponiaka ivankoku Jairo ikantiri: —Matakaniroro kamake pishinto, intagati poveraanatiri Gotagantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kantankicha Jeso ikantiri Jairo: —Gara pitsarogi, nagaveaketari noganiaerora pishinto. Pinkematsatakenarika nokantakempira maika anianaetyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Impo antari yogonketapaakara ivankoku Jairo ikanti gara tyani kiimatatsi pashini. Intagani itentaiganaka Perero, Joan, Santiago, Jairo ontiri itsinanetsite ikiaiganakera tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ineaigapaakeri maganiro iragatsikaigaririra igamaga iragaigamataka kaemavaimataketyo kara, kantankicha Jeso ikantaigapaakeri: —Gara piragaiga, tera ario onkame, onti omagake. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kantankicha iriroegi ogatyo ikenaigake ikavakavaimatanaketyo ikaavintsanaiganakerira, ineaigakerotari mataka kamasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Impo yogari Jeso ikatsavakotakero ikimoenkatanake ikantiro: —¡Ananeki, tinaanae! ");
INSERT INTO mcbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oga okenake anianai otinaanaa. Impo ikantake Jeso ompakenkanira osekatakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yogari iri ontiri iniro yogavageiganaketyo kavako, kantankicha Jeso ikantaigiri: —Gara tyani pikamantaigi noganiairora pishinto. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Impogini ikaemaigakeri Jeso irogamereegi yapatoitaigakerira yagaveakagaigakerira ironeagaigakemparira kamagarinipage ontiri aikiro irovegaigakerira mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Itigankaigakeri inkenkitsatimoigakerira maganiro inkamantaigakerira tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite. Ikantaigakeri aikiro irovegageigakerira mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ikantaigavakeri: —Gara tatakona pamumaigi. Gara pamaigi pigotikiiro. Gara pamaigi pitsagine, piseka, intirika pigorikite. Gara pamaigi piteti pigamisate, intagatityo oga pogagutakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tyarika kara piaigake inkaemaigavakempirika pimagaigakera ivankoku, piaigaketyo pimagaigakera. Kantakani pimagimoigakerira kigonkero piaiganaera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Antari garika tyani kaemaigavakempi piaigaketyo parikoti, kantankicha oketyo pimpotevonkititasanoiganaemparo kipatsipane pagatikakoigakeririra iroroniri ineantaigakempa onti pokaiganakeri piaigakera parikoti yovetsikaigaketari terira onkametite teranika iragaigavakempi irishineventaigavakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Impogini iaigake itsotenkavageiganakero tyarika kara itimageigakera matsigenkaegi, ikenkitsatimoigakerira ikamantaigakerira tyara ikanta Tasorintsi yogavisaakotantira. Aikiro yovegageigamatirityo mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Impogini yogari Erorishi neagetakeneririra Sesa magatiro Garireaku ikemakotakero magatiro yovetsikagetakerira Jeso, yogavagetanaketyo kavako tyampatyo inkante. Ikantaigaketari pashini inti kitareanaacha Joan kamankitsirira karanki. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pashinikya kantaigankitsi inti pokaatsi kamantantatsirira Eriashi pairaninirira. Pashinikyatyo kantaigankitsi atake yanianai pashini kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kantankicha Erorishi onti ikantake: —Narotarityo togitorenkakagantakeri Joan. ¿Tyanimpatyora yoga maika iniakonatunkanirira nokemakotirinityo chapi? Impo ikogavetakatyo ineakerimera. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Impogini ipokaigaira iritigankaneegi Jeso ikamantageigapaakeri magatiro yovetsikageigutirira. Ikemaigavakerira Jeso itentaiganakari parikoti ochoenitira Vetsaira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kantankicha iroro ikemakotunkanira iaigake tovaini matsigenkaegi yogiaiganakerira. Yogari Jeso ishineigakari ikenkitsatimoigakerira ikamantaigakerira tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite, aikiro yovegaigakeri mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Impo inanaira shavini poreatsiri yaiñoniiganakari iritigankaneegi ikantaigiri: —Pakuaigaeri maganiro yogaegi iriaigaera anta otimagetakera pankotsipage kameti irampishigopireaigakempaniri aikiro impunaventavageigakera isekaegi isekataigakempara. Akari aka mameritari tatampa irogaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kantankicha Jeso ikantaigiri: —Paigerityo viroegi isekataigakempara. Iriroegi ikantaigiri: —Mameri tatampa nompaigakeri. Intaganivatisanotyo onai 5 pan, yogari shima pitenivani inai. ¿Matsi ario nagaveaigake noaigakera nompunaventaigakitenerira irashiegi maganiro isekataigakempara? ");
INSERT INTO mcbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ikantaigake maika ineaigaketari itovaigavageti matsigenkaegi ikaravageigake ariorika 5,000 surariegi. Kantankicha Jeso ikantaigiri: —Kantaigeri maganiro impitaigakera kantankicha onti pashirikogeigakeri ariorika inkarageigake 50 impirinigeigakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ario ikañoigakero maika ovashi ipirinitaigake maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Impo yogari Jeso inoshikakero pan intiri shima yapagotakeri ineventanaka enoku iniakerira Tasorintsi ikantiri: “Apa, noshinevagetakatyo maika pipakenara nogaigakemparira.” Impo ikotagakero pan ipaigakeri irogamereegi iriroegikya paigakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Isekataigaka maganiro ikemaiganaka, impo yogari irogamereegi yapatoigairo aityokyarira onai yoyagaigairo tsivetaku shatekapagerikatyo kara onakotake 12. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Impogini inakera Jeso paniro iniakerira Iriri intagani itentaigaka irogamereegi. Impo ikantaigiri: —¿Tyara ikantaigana maganiro matsigenkaegi? ");
INSERT INTO mcbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iriroegi ikantaigiri: —Ikonogagarantaigaka ikantaigake: ‘Inti Joan Giviatantatsirira.’ Pashini kantaigankitsi: ‘Inti Eriashi.’ Pashinikya kantaigankitsi: ‘Inti pashini kamantantatsirira pairaninirira yanianaira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Impo ikantaigiri: —Viroegiri, ¿tyara pikantaigana? Iniamatanaketyo Perero ikantiri: —Viro vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ikantaigiri: —Gara tyani pikamantumaigi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Impo ikantakotaka Jeso ikantaigiri: —Yogari Kañotasanotakaririra Matsigenka iratsipereavagetake. Yogari itinkamiegi jorioegi intiegiri itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi gara ikematsaigiri onti inkisashiigakempari. Impo ovashi irogakagantaigakeri, kantankicha omavatanakempara kutagiteri iranianae. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Impo ikantaigiri maganiro: —Tyanirika kogankitsine inkantakanira inkematsatasanotakena garatyo ipiriniventiro ikogagetirira irirori, ontityo inkantakani impiriniventavagetanakero nokogagetirira naro, aikiro iratsipereaventavagetakenatyo ontirika inkamaventakena. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tyanirika tsarogakagacha ikiiro tera inkoge iratsipereaventavagetakenara ikiirotyo kañotagantanankicha, intagatitari ikogake irovetsikagetakera tatarika ikogagetakerira irirori. Kantankicha yogari piriniventirorira nokogagetirira naro yatsipereaventakenara, iriro pinkante iriatake itimira Tasorintsi inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Intimavetakempatyo gaveankitsinerira irashintakemparora magatiro kipatsipagekutirira kantankicha impoginityo inkamanae iriatake morekariku, ¿matsi ario agaveake oganiakerira iaraki? Garatyo agaveimati. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tyanirika pashiventagakenane naro ontiri aikiro nokantagetakerira ariotyo nonkañotagakempari naro impogini nompigaatera nompashiventagapaakemparityo irirori. Nompigaetari impogini nonkoveenkavagetapaakera nonkañotapaakemparira Apa ikoveenkavagetira intiegiri aikiro isaankariite, ariotari ikañoigakari iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nonkamantasanoigakempi antari gatatara pikamaigi pinkonogagarantaigakempa pineaigakeri Tasorintsi inkoveenkatanakera viroegiku. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Impogini avisanakera ariorika 8 kutagiteri iatake otishiku iriniaerira Iriri itentanakari Perero, Joan intiri Santiago. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Impo iniakerira Iriri katsiketyo ikantatigamatanakatyo ivoroku ogatyo okenake imanchaki okovoreatanake okantanake porererere onkutavageteratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Katsiketyo ikoneaiganake Moiseshi intiri Eriashi itentaigakari Jeso iniavakagaigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ikovoreaigamatanaketyo ikantaiganakera porererere. Onti iniaventaigake iratsipereavagetakera Jeso inkamakera Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kantankicha yogari Perero intiegiri itentaigakarira magasevageigaketyo kara, impo ikireaigamatanaketyo ineaigutarityo Jeso kovoreamatake kantamataketyo porererere itentaigakari Moiseshi intiri Eriashi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Impo ineaigavakerira yontainaiganaarira Jeso iniamatanaketyo Perero ikanti: —Gotagantatsirira, ¡matsi ariokonatyo anaigake aka! Atsi novashiigakera mavati pankotsi otyomiatirira, patiro pashi, patiro irashi Moiseshi, ogari omavatakemparira onti irashi Eriashi. Kantankicha ontityo iniashitakaro kogapage, teranika irogote tyarika inkante. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iroro iniavagetakera katsiketyo apamankakoigapaakeri menkori, itsarogaigamatanaketyo ineaigaketari apamankaiganakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Impo inianake Tasorintsi arionika apatosegakara ikanti: “Yokari yoka inti Notomi, tsikyatatari nokogakagakeri naro notigankakerira. Maika atsi kemisantasanoigeri viroegi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Impo opeganakara iniakera ineaigavetari Jeso panivani yapuntaa. Iriroegi ikemisantaigaketyo. Impo iaigaira teratyo tyani inkamantumaige okyara. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Okutagitetanaira ipokai Jeso intiegiri irogamereegi iponiaigaara otishiku. Impo iaigaketyo tovaini matsigenkaegi itonkivoaigavaarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Impogini inianake paniro imaraenkarikatyo kara ikantiri Jeso: —Gotagantatsirira, atsi shonke, geri kavako notomi, panirotari ikantavagetakara irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Itimagutakeri kamagarini ipigatagapinitakeri, ikaemakagagematirityo kara, aikiro ishigekakaganakeri shige shige shige, ishimosegantanaketyo kara. Teratyo irapakuimateri ikantakani yatsipereakagakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nokantaigavetakari pogamereegi ironeagaigaemparira kantankicha teratyo iragaveaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Inianake Jeso ikanti: —¡Ario pikantavageigaka viroegi tekyaenkatyo pogoigero iragaveane Tasorintsi! ¿Akasamaninivatirorokari nompiriniventaigakempi nantsipereakoigakempira? Ishonkatetanakari iriri ikantiri: —Makenarinityo aka pitomi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kantankicha iroro yamavetanakenerira yogari kamagarini yogituakeri savi kipatsiku ishigekakaganakeri shige shige shige. Impo yoneagakari Jeso, ogatyo ikenake ananeki paa vegasanotaa. Impo inianai Jeso ikantiri tomintaririra: —Neri pitomi yoga. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Maganirosanotyo yogavageiganake kavako, ineaigakeritari yagaveavagetakera Tasorintsi. Iroro yogavageigakera kavako isureigakarora yovetsikagetakerira Jeso inianake irirori ikantakotanakara ikantaigiri irogamereegi: ");
INSERT INTO mcbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Maika kemisantasanoigena, gara pimagisantaigiro nonkantaigakempirira. Yogari Kañotasanotakaririra Matsigenka iragakagantakenkani iramanakenkanira irogakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iriroegi teratyo inkemaigavakero ikantakerira, tekyatanika irogikoneatimoigeri Tasorintsi tatoita ikantakotake, kantankicha tera inkantumaigeri, “¿Tatatyo oitara piniakotake?”, yagamaavageiganakatari. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Impogini itsitiiganakero irogamereegi iniavakagaiganakara iniaventaigakerora tyanirikara visaigakeri itovaireegi, irorokyatyo ikantaigi, irorokyatyo ikantaigi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kantankicha Jeso yogotaketyo magatiro isureigakarira, nerotyo yagake paniro ananeki yogaratinkakeri inampinaku ");
INSERT INTO mcbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ikantaigiri: —Tyanirika kavintsaakerine ananeki kañorira yoka kañomataka nantinirikatyo ikavintsaake, nantitari ikematsatake. Ario ikañotaka tyanirika kematsatakenane naro, inti ikematsatake aikiro tigankakenarira. Irorotari nonkantantakempirira maika tyanirika terira iraventakotempa onti inkavintsaakeri terira impaitumatempa, iriro pinkante inti pairorira yavisantavagetake. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Impo ikanti Joan: —Gotagantatsirira, chapi noneaigakeri paniro yoneagakari kamagarini, onti yaventashitakari pivairo. Kantankicha naroegi nokantaviigakeri, noneaigaketari tera intentaigae. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ikantiri Jeso: —Maika ganige pikantaviigairi, maganirotari terira inkisashiigajae onti ishineigakai. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Antari ochoenitapaakara iriatantanaemparira Jeso enoku iatanake Jerosarenku ikantanake: —Noatetatyo Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Impo itigankaigakeri iritigankaneegi iriivaiganakera inkamantantaigakerora pokapaake Jeso. Iriroegi iaigake itimaigira samaritanoegi inkogaigakenerira pankotsi irimagantapanutemparira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kantankicha iriroegi teratyo inkogaige iragaigavakerira irogimagaigakerira iriroegiku, ineaigaketari onti iriate Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Impo yogari irogamereegi paitacharira Santiago intiri Joan ineaigakera tera inkogaige iragaigavakerira ikantaigiri Jeso: —Notinkami, ¿pikogake nonkantaigakera ashiriakempara tsitsi enoku ontagaigakerira ompogereaigakerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ishonkateigamatanakarityo Jeso ikanomajaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Impo iaigake parikoti itimaigira pashini. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Impogini ikenaiganakera avotsiku inianake paniro surari ikantiri Jeso: —Notinkami, nokogake nonkantakanira nogiavagetakempi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ikanti Jeso: —Yogari etini aityo ikiantarira. Ario ikañoigaka tsimeripage irirori aityo imagantaigarira, kantankicha yogari Kañotasanotakaririra Matsigenka teratyo ontime ivanko irimagantakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Impo ikantiri pashini: —Virori, tsame pogiavagetakenara. Kantankicha irirori ikanti: —Notinkami, nokogavetaka nogiatanakempimera, kantankicha aiñokyatari apa gatata nopoki. Antari inkamanaera nonkitatanaerira, ario pinkante nompokake nonkantakanira nogiavagetanakempi. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ikanti Jeso: —Yogari igamagapage kantetyo inkitaigaerira terira inkematsaigeri Tasorintsi. Virori piate pinkenkitsavagetakera pinkamantaigakerira pitovaireegi tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inianake pashini ikanti: —Notinkami, naro aikiro nokogake nogiavagetakempira, kantankicha oketyo noatapanaate novankoku noniantapanutera. ");
INSERT INTO mcbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kantankicha Jeso ikantiri: —Tyanirika kogavetankicha irogiavagetakenara, kantankicha aityorika itatsiventakarira ¿matsi tyara inkantakempa impegasanotakerira Tasorintsi Igoveenkarite impiriniventakerora ikogagetirira? Garatyo yagaveimati. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Impogini yogari Atinkami itigankaigake 72 irogamereegi iriivaiganakerira tyarikara iriatakera irirori. Ikantaigakeri: “Gara papuntaiga paniro. Onti pagavakagaiganakempa pitenipage pinaiganake, piteni atankitsine parikoti, piteni atankitsine parikoti, ariompa pintsotenkavageiganakempari.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Impo ikantaigavakeri: “Nonkantasanoigakempi aiño tovaini kogakoigankicharira irogoigakera tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite, kantankicha tesakona intovaige gotagaigakerineririra. Onti ikañoigakaro osampatira turigoki ogatuitakoni tesakonara intovaige gaigakeronerira. Irorotari maika nonkantaigakempi piniaigakerira Tasorintsi pinkantaigakerira intigankaigakera gotagaigakerineririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Piaige viroegi. Onti nontigankaigakempi itimaigira kisantaigatsirira iratsipereakagaigavakempityo kara kañomataka intinirikatyo notigankake ityomiani ovisha iriatakera yapatotara garirira ovisha. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gara pamaigi pitsagine, ontiri yoyagantaganirira koriki, aikiro gara pamaigi pashini pisapatote. Gara pipirinigeiganake avotsiku piniavakagaigakempara pintentaigakerira tyanirika pintonkivoaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Tyarika kara inkaemaigavakempi pimagaigakera ivankoku pinkiaiganakerika tsompogi oketyo pinkantaigapaakeri: ‘Nokogake inkavintsajaigakempira Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Irishinetanakemparika irirori inkogakera inkavintsaakerira Tasorintsi, ariotyo inkañotakempa Tasorintsi inkavintsaakerityo. Kantankicha garika ikogi garatyo ikavintsajairi Tasorintsi, panirotyo inkavintsajaigakempi viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Irishineventaigavakempirika pinkantakani pimagimoigakeri ovashi piaiganaera, gara pogagumaiga. Pogaigakemparora tatarika oita impaigakempi, aikiro poviikaigakemparora yoviikaigarira iriroegi. Okantaganitari kametitake impunaigakenkanira tavageigatsirira. Nerotyo kametitake impaigakempira magatiro pikogakogeigakarira piatimoigakeritari pikenkitsatimoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tyarika kara piaigake, inkaemaigavakempirika pisekataigakempara pogaigakemparora tatarika impakoigavakempi. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Povegaigaerira mantsigaigankitsirira, aikiro pinkantaigakerira maganiro: ‘Onti nopokashiigake nonkamantaigakempira tyara inkantakempa Tasorintsi irogavisaakoigakerira maganiro kematsaigakerinerira impegakempara Igoveenkariegite.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kantankicha tyarika piaigake garika yagaigavakempi inkemisantaigakempira pinkenaiganaketyo avotsiku yapatotasanoigakara matsigenkaegi pinkantaiganakera: ");
INSERT INTO mcbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Atsi shonkaige, nopotevonkititasanoiganaarotyo kipatsipane nagatikakoigakempira kameti pogoigakeniri onti nokasanoiganaempi noaigakera parikoti teranika pishineigavakena. Kantankicha nokogaigake pogoigakera onti nopokashiigavetaka nonkamantaigakempimera tyara pinkantaigakempa kameti irogavisaakoigakempira Tasorintsi impegakempara Pigoveenkariegite, kantankicha viroegi tera pinkogaige pinkemisantaigakenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Maika nonkantaigakempi aganakemparika inkisashitantaigakemparirira Tasorintsi maganiro terira inkematsaigeri pairotyo irogagaigakeri terira inkogaige inkemisantaigakempira. Yogaegiri timaigavetacharira pairani Soromaku ogakonatyo inkantaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Maikaniroro pantsipereavageigake viroegi timantaigarorira Korasun! ¡Maikaniroro pantsipereavageigake viroegi timantaigarorira Vetsaira! Pineaigavetakarotyo novetsikimoigavetakempirira, kantankicha teratyo pinkogaige pinkantatigaiganakempara pampakuaiganakerora povetsikageigira terira onkametite. Yogari pinkante timaigavetacharira pairani Tiroku ontiri Suronku iriroegimetyo neaigakerome inkantatigaiganakempametyo irogaguiganakemparome tontaporokiri, aikiro intiaitaiganakempametyo samampopane iokotagantaigakempara ikenkisureaigakara ineaigakera yovetsikageigira terira onkametite inkantatigaiganakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kantankicha viroegi aganakempara inkisashitantakemparirira Tasorintsi maganiro terira inkematsaigeri, pairotyo irogagaigakempi kara avisavagetakerotyo inkisashiigakemparira Tirokunirira intiegiri Suronkunirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Viroegiri timaigatsirira Kaperenaoku paventakovageigaka. ¿Pineaigiri ariori piaigake enoku? ¡Garatyo! Ontityo piaigake morekariku.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Impo ikantaigiri irogamereegi: “Tyanirika kemisantavintsaigakempine viro, nanti ikemisantavintsaigake. Yogari terira inkemisantavintsaigempi viro tera inkemisantavintsaigena naro, aikiro tera inkemisantavintsaigeri tigankakenarira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Impogini ipigaigaa yogaegi 72 itigankaigakerira ishinevageigapaakatyo ikantaigi: —Notinkami, ikematsageigamatanakenatyo kamagarinipage noneagaigakarira naventashiigakarira pivairo. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ikantaigiri Jeso: —Jeeje, arisanoniroro, naro noneakeri Satanashi yagaveinkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naro nagaveakagaigakempi pagatikaigakerira maranke intiri kitoniro gara tyara ikantumaigimpi. Ario inkañotake kamagarini kisashitantacharira gaveavagevetacharira garatyo yagaveimaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kantankicha nonkantaigakempi, gara iroro pishineventaiga pineaigakera pagaveaigakerira kamagarinipage, ontityo pishinevageigakempa pineaigakera piaigakera enoku pinkantakanira pintimaigake, tsirinkakoigakavitari enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Impo ogatyo ikenake Jeso ishinevagetanakatyo kara yogishineakerira Isure Tasorintsi inianakeri Iriri ikantiri: “Apa, vinti vetsikagetakerorira inkite ontiri kipatsi ontiri aikiro magatiro timantagetarorira. Noshineventakempityo kara, pomanapitsaigakeritari govageigatsirira tera pogotagaigeri tyara pikanta viro. Inti pogotagaigake terira irogovageige. Arioniroro okañotaka maika, ariotari pikogakeri viro.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Impo ikantaigiri maganiro: “Ipagetakenaro Apa magatiro, aikiro yagaveakagavagetakena posante. Tera tyani gotatsine tyara nokanta. Intagani gotankitsi Apa. Aikiro tera tyani gotatsine tyara ikanta irirori. Intagani naro gotankitsi intiegiri aikiro yogaegi nonkogakagaigakerira nogotagaigakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Impo ishonkateiganakari irogamereegi ikantaigiri iriroegi: “Ikavintsaavageigakempi Tasorintsi pineantaigakarorira magatiro pineageigakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nonkantaigakempi itimaigavetaka tovaini kamantantaigatsirira intiegiri koveenkariegi ikogaigavetaka ineaigakeromera pineaigakerira viroegi maika, kantankicha teratyo ineimaigero. Aikiro ikogaigavetaka inkemaigakeromera pikemaigakerira, kantankicha teratyo inkemumaigero.” ");
INSERT INTO mcbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Impogini ikavirimatanakatyo paniro gotagantirorira itsirinkakotanakerira Moiseshi ikogakotagantakerira Jeso ineakerira tyarikara inkante. Impo ikantiri: —Gotagantatsirira, ¿tyara nonkantakempa maika nogishineakerira Tasorintsi ganiri noneairo nogamane onti nonkantakani nontimake? ");
INSERT INTO mcbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ikantiri Jeso: —¿Tyara okantira itsirinkakotanakerira Moiseshi? Piniavantirora, ¿tyara okanti? ");
INSERT INTO mcbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Inianake irirori ikanti: —Onti okanti: ‘Aiño paniro Tasorintsisanorira, irirori inti Pitinkami. Pintasanovagetanakemparityo pisuretasanotanakemparira, aikiro pimpanirotasanotanakerira. Pintsarogakagavagetakemparira pitovaire pinkañotagasanotakempatyo pitsarogakagara vikiiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ikantiri Jeso: —Pikantasanotakeniroro. Pinkantakanirika pintsataganakero okantakerira ario pinkante inkavintsaavagetakempi Tasorintsi pintimagantsivagetake kameti. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kantankicha irirori isurematanakatyo ikanti ariorika inkantake Jeso: “Iroroventi tyara okantakara atanatsi pikogakotagantakenara, matakatari pogotakero.”, nerotyo ikantantakaririra: —¿Tyanimpatyora notovaire? ");
INSERT INTO mcbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ikantutarityo Jeso: —Paniro matsigenka iavetanakara Jerikoku iponianaka Jerosarenku. Kantankicha impogini yagavetanakaro nigankipoki yagaigavakeri koshintiegi ikoshiarantasanoigakerityo magatiro iaraki yogaigakerityo noganiro, ipasapasaiganakeri ton ton ton ineaigi panikya inkamanake iokaigapanutiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Impogini ikenanake kara paniro saserorote iponianaka irirori aikiro Jerosarenku, ineavetanakari ikenapitsatapanutirityo antakona anta yavisanake. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aikiro ario ikenanake kara paniro irevita, ario ikañotaka irirori ineavetanakari yavisanaketyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kantankicha ikenapaake paniro Samariakunirira ineitarityo itsarogakaganakarityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ishigatetanakari inoshikanake aseite ontiri vino yogavintagisetakeri iponagetakeri. Impo yogatsonkutakeri iashinoteku ikenantavetapaakarira irirori itentanakari pashiniku pankotsi imagantapiniigarira visapiniigatsirira kara. Isentakeri ipagetakeri ikogakogetakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Impo okutagitetanakera iatanake inoshikanake piteni tenario ipanakeri shintarorira ivanko ikantiri: ‘Neri yoka koriki nompunatanakempira pineasanotaerira yoga. Garika imonkarata nompunatapaempi impogini nompigaera.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Maikari maika atsi kantena ¿tyani pegakeri itovaire? ");
INSERT INTO mcbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ikanti irirori: —Inti yoga tsarogakagakaririra. Ikantiri Jeso: —Iroroventi maika ariotyo pinkañotakempari viro. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ariompa iatiri Jeso impo yogonkevagetaka itimaigira pashini. Ario otimi kara tsinane opaita Mareta, okaemavakeri ovankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aiño ovirentote opaita Maria. Irorori opiriniventavakeri Jeso okemisantakerira ikenkitsavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kantankicha ogari Mareta ovankinaventakarotyo antavagetakerira. Impo oshigatetanakari Jeso okantiri: —Notinkami, pineavetakaro novirentote tera omutakotena, paniro napuntashitakaro magatiro, tera tyara pinkantumatero. Atsi kanteronityo omutakotakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ikantutarotyo Jeso: —Mareta, onti pisuretakogetaka posante povankinaventakaro. ");
INSERT INTO mcbNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kantankicha aityo patiro pairorira avisake okogakotunkanira. Irorotari opiriniventake maika Maria. Gara tyani pakuakagumatiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Impogini iatake Jeso parikoti iniakerira Iriri. Impo yagatanakera inianake paniro irogamere ikanti: —Notinkami, yogari Joan yogotagaigiri irogamereegi iriniaigakerira Tasorintsi. Maika atsi gotagaigena viro noniaigakerira naroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ikantaigiri Jeso: —Antari piniaigerira Tasorintsi onti pinkañoigakero maika pinkantaigakerira: ‘Apa Tasorintsi, nokogaigake impinkatsatasanoigakempira maganiro matsigenkaegi inkematsatasanoigakempira impegaigakempira Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pimpaigakenara omirinka nogaigakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimagisantaerora novetsikaigakerira terira onkametite gara pikenkiagaiganaro. Ariotari nokañoigakari naroegi nomagisantaigakero yovetsikaigakerira tsipereakagaigakenarira tera nonkenkiagaigeri. Pimpampogiakoigakenara ganiri opokashigeigana garira noshintsitashigeigiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Impo ikantaigiri aikiro: —Pine viroegi intimera piamigote impogini piatake ivankoku nigankigite pinkaemapaake: ‘Amigoo, pinatena mavati pan, ");
INSERT INTO mcbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ikyaenkasano gonketapaacha noamigote, narori mamerisanotyo tatampa nompavakeri.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Impo inkaemanake irirori anta tsompogi inkantempi: ‘Gara poveraanatana, shitakotaanatari, magaiganaanatari maganiro. Gara nagavei nomputempira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Garatyo ipavetimpi, kantankicha atanatsirika pinevinatanakeri intinaanaketyo imputempira magatiro pikogakotakarira. Kantankicha gara iroro ipashitimpi ipegimpira iamigote, ontityo impashitakempi kameti ganiri atanatsi poveraanatirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Irorotari maika nonkantantaigakempirira neviigeri Tasorintsi tatarika pikogakogeigaka impo irirori impaigakempirotyo. Pinkogasanoigakerorika pineakoigakemparotyo. Atanatsirika pinevinatakeri Tasorintsi inkemaigakempityo impaigakempirora. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yogari nevitantatsirira ipunkani. Yogari kogankitsirira ineakero. Aikiro yogari tyanirika atanatsirira inevitantira ikemunkani ipunkanityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Matsi pinkañoigera viroegi inevitempira pitomi shima pinoshike maranke pimperi? ");
INSERT INTO mcbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Intirika inevitakempi igitsoki, ¿pinoshike pimperi kitoniro? ");
INSERT INTO mcbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kañotari viroegi pikañovageigavetari akyari pipaigiri pitomiegi tatarika oita kametiripage ineviigakempirira, iriromparorokarityo Piri timatsirira enoku pairorokari intigankimoigakeri Isure intimaguigakerira maganiro neviigakerineririra.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Impogini Jeso yoneagaari kamagarini itimagutakerira paniro surari imakanatagakeri, iroro ikontetanaira kamagarini oga ikenake inianai. Yogavageiganaketyo kavako maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kantankicha ikonogagarantaigaka onti ikantaiganake: “Inti tinkamitakari Veresevo itinkami kamagarinipage. Irirotari gaveakagakeri yoneaganontantaigakaririra itimaguigakerira kamagarinipage.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Impo ikonogagarantaigaka pashini ikogaigakera ineaigakerira tyarika inkante ikantaigakeri: —Atsi pineakagaigakenara pashini terira oneimagetenkani onkoneatakera kara inkiteku nogoigakeniri arisano piponiaka enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kantankicha irirori yogotavakerotyo isureigakarira ikantaigiri: —Pine intimera matsigenka irapatoitakeri itovaire impegakempara itinkami impo intsitiiganakerorika inkisavakagaiganakempara ovashi irashirikovakagaiganakempa iokaiganakeri itinkami panivani irinae, mameri tyanimpatyo iromperataempa. Ario ikañoigaka tentaigaririra iitaneegi ikiirora parantavakagaiganaachane inkisavakagaigakempara oga inkenaigake irashirikovakagaiganakempa ganige itsipavakagaigaa. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ario ikañotaka Satanashi irirori, ¿matsi tyara inkantakempara ikiirora parantavakagaigaachane inkisavakagaigaempara intentaigaemparira itovaireegi kamagarinipage? Impogereakeririka itovaire panivani irinae, ¿ario tyanimpatyora iromperataempa? Onti nokantaigakempi maika nogotaketari pikantaigakenara inti tinkamitakena Veresevo nagaveantakarira noneaganontaigakarira itimaguigakerira kamagarinipage. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iriromera gaveakagakenane kamagarini ¿ario tyaniratyo gaveakagaigakerira pitovaireegi yoneaganontaigakarira itimaguigakerira kamagarini? Irorotari ogotantunkani onti pikomuigakaro viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kantankicha intityo gaveakagakena Tasorintsi noneagantagetakaririra kamagarinipage, iroro pogotantaigavakempa atake ikoveenkatanake Tasorintsi aka viroegiku. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Yogari kamagarini onti ikañotakari pashini matsigenka suraritatsirira timatsirira iviane, ichakopite, magatiro yaventakarira. Isentasanovagetakerotyo ivanko teratyo tyani gaveimaterine inkoshiterira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kantankicha iripokera pashini pairorira yavisakeri, irirori pinkante iragaveakerityo iragapitsatakerira magatiro yaventagevetakarira, irashintutakempari magatiro impaigakeri tyanirika inkogakagake irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Maganiro terira irishinetena onti ikisashitakena, aikiro yogari terira intentena napatotantakera onti itivarokantake. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Antari itimagutirira matsigenka kamagarini impo iokanairi iatake anta osarigagitetapaakera yanuivagetakera. Impo ikogavetaka irapishigopireavagetakempamera, kantankicha teratyo iragavee ovashi isurematanaatyo ikanti: ‘Irirompatyo nompigashitanae notimaguvetarira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Impo ipigavetaa ineapaakeri giakomatakatyo kañomataka pankotsi otarogaganira onegintetaganira saagitemataketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ovashi iatake yagakitira pashini 7 kamagarini pairorira yogagavageigaka. Impo itimaguigapaakeri yoga itimaguvetarira okyara ovashi irirori oga ikenake pairotyo yogagavagetanaka.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Impogini aiñokyara iniavageti Jeso okaemamatanaketyo paniro tsinane tentaigakaririra patoigankicharira okanti: —¡Pairotyo oshinevagetaka piniro tomintakempirira tsomitagakempirira! ");
INSERT INTO mcbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kantankicha irirori ikanti: —Irirompasanotyo shinetasanoigankicha kemisantaigirorira Iriniane Tasorintsi isuretakoigakaro itsatagaigakero okantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Impogini ariompatyo yapatoventaiganakariri Jeso yonkuatakovageiganakarityo kara, impo yogotagaiganakeri ikanti: “Viroegi apaiventavageigakempi kañovagetagantsi, pikogantaigavetakarira noneakagaigakempira terira oneimagetenkani, kantankicha garatyo noneakagumaigimpi. Intagatityo noneakagaigakempi pashini onkañotakemparo ikañotagunkanira kamantantatsirira Jonashi pairani. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pikemakoigakeritari irirori tyara ikantakeri Tsorintsi kameti ineakagaigakeriniri Ninivekunirira irogoigakeniri arisano inti tigankakeri. Ario inkañotagakeri Kañotasanotakaririra Matsigenka impogini kameti pogoigakeniri viroegi inti tigankakeri irirori aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Impogini aganakempara inkisashiigakemparira Tasorintsi maganiro terira inkematsaigeri inkantake ogari igoveenkariegite Savakunirira pairotyo avisaigakempi viroegi, opokashitakeritari Saromon pairani oponiavagetakatyo samani kara onkemisantakerira irogotagagetakerora, kantankicha maika ipokavetaka pairorira yavisavagetakeri Saromon, teratyo pinkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ario inkañotagaigakeri aikiro timaigavetacharira pairani Niniveku inkantake pairotyo yavisaigakempi viroegi, maganirotari Ninivekunirira ikematsaigakeri Jonashi ikenkitsatimoigakerira ikenkisureaiganaka ineaigaketari yovetsikagisevageigira terira onkametite ovashi ikantatigaiganaka. Kantankicha maika ipokavetaka pairorira yavisavagetakeri Jonashi, teratyo pinkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Antari yogimataganira mechero tera ario iromanenkani, aikiro teratyo intatakotenkani kovitiku, ontityo yovitakotunkani enoku kameti inkoneagitetakoigakeniri maganiro pitaigankitsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yogari suretakotasanovagetakemparonerira Iriniane Tasorintsi irogotasanotakero magatiro ikogagetirira irirori, onti inkañotakempari neatsirira tyarika iati ineasanotanake tera irontivatumatempa, okoneagitetimotakeritari magatiro. Kantankicha yogari terira isuretakotasanotemparo Iriniane Tasorintsi tera irogotero ikogagetirira, onti ikañotakari terira inee, tyampa inkantakempa iranuivagetakera, onti yontivativavagetaka, teranika onkoneagitetimoteri, onti ineakero pavatsaasemataka. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kantankicha pisureigakemparorika Iriniane Tasorintsi tsikyanira pimaigavairokari oniashitaganirira kogapage pisureigavaemparora. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pinkañoiganakemparika maika gara pogoigiro ikogakerira Tasorintsi, kantankicha patirorika pintsatagaiganakero Iriniane ario pinkante pogotasanoigake. Onti onkañotakempa yovitakotaganira mechero enoku yontenenkakoigakeri maganiro pitaigankitsirira kara ikoneagitetakoigakeri.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Impogini yagatanakera iniavagetakera Jeso inianake paniro pariseo ikaemanakerira isekatimotakemparira. Impo iatake ikianake ipitapaake mesaku isekatavagetakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kantankicha yogamatanaketyo kavako kaemakeririra ineakerira isekatakara kogapage tera inkivakotempa inkañoigakemparira iriroegi ikivakoigara panikyara isekataigakempa irisaankaigakempara okitsitinkaigakerira tatapagerika oita. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kantankicha irirori ikantiri: —Viroegi pariseoegi intagati pipiriniventavageigi pamatavinaigakerira matsigenkaegi pagutageigakerira yashintageigarira. Kañomataka intagatira okivagani pamoko ontiri perato otishitaku, antari oteniku pairatamatake potsitasematake. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tera pogotumaige viroegi! ¿Matsi tera pogoige yogari vetsikakerorira ivatsa matsigenka iriro vetsikakero isure aikiro? ");
INSERT INTO mcbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kantankicha maika kantatigaiganakempa pakuaiganaero magatiro pisuregisevageigakarira, pintsarogakagantaiganakempara. Pinkañoigakemparika maika garatyo tatoita kitsitinkumaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Maikaniroro pantsipereavageigake viroegi pariseoegi! Tatarika oita pashintumaiga ontirika mentashi, sankonka ontirika pashini posantepage pipankigeigirira pikonogantaigarira piseka pipagarantaigiri Tasorintsi, kantankicha pimagisantavageigakero ikantaigakempirira pintasanoigakemparira irirori, aikiro pintsarogakagaigakemparira pitovaire negintekyara pogaigakeri. Kametitaketyo pipagarantaigakerira Tasorintsi pashintageigarira, kantankicha gametyo pimagisantaigiro otovaire ikantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Maikaniroro pantsipereavageigake viroegi pariseoegi! Omirinkatari piaigira pankotsiku papatoitantaigarira viroegi pikogaigake pimpitaigakera ipiriniigira tinkamiigatsirira. Ario okañotaka aikiro piaigira opimantagetaganira arakintsipage ontiri ogagetaganirira pikogaigake iriniaigavakempira inkañotagaigakempira iniaganira pitinkamipage. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi vintiegiri pariseoegi kametitamampegaigacharira! Ontitari pikañoigakaro ikitatantaganirira igamaga pairani impo tenige onkoneatae. Okenapinitunkani agatitinavagetunkani, tenigetari onkoneatae oneakenkanira. Ariotari pikañoigakari viroegi maika ineaigakempira yogaegi konoitaigimpirira ineaigiri ariori opaitaka pikematsatasanoigirira Tasorintsi, kantankicha teratyo, teranika irogoige onti pisuregisevageigaka posante terira onkametite.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Impo iniamatanaketyo paniro gotagantirorira itsirinkakotanakerira Moiseshi ikanti: —Gotagantatsirira, nokemaigakempira pikantakera maika potsimajaiganakenatyo naroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kantankicha Jeso ariompatyo inianakeri ikantiri: —¡Maikaniroro pantsipereavageigake viroegi aikiro, gotagantaigirorira itsirinkakotanakerira Moiseshi! Povashigakovageigakaritari matsigenkaegi pogotagaigakerira posante intsatagaigakerora irishineventaigakempariniri Tasorintsi, kantankicha viroegi teratyo pintsatagumaigero. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Maikaniroro pantsipereavageigake viroegi! Yogaegiri yashikiiganakempirira yogaigakeri kamantantaigatsirira pairaninirira, maikari maika viroegi povetsikashiigakeneri isuretakotantaigaenkanirira pogageigakerora kara ikitataigunkanira ganiri imagisantaigaagani. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Antari povetsikaigakenerira oganirikatyo pikantumaigake kametitaketyo yogaigakerira. Iriroegi yogaigakeri pairani, maika viroegikya vetsikashiigakeneri isuretakotantaigaenkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Yogotaketari Tasorintsi pairani ario onkañotakempa maika, nerotyo ikantantakarira: ‘Nontigankimoigavetakempari kamantantaigatsirira intiegiri pashini kenkitsatimoigakerinerira, kantankicha inkonogagarantaigakempa irogaigakeri, pashini onti iratsipereakagaigakeri.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Irorotari inkisantaigakempirira Tasorintsi viroegi timaigatsirira maika inkenkiagaviigakempirira kamantantaigatsirira yogaigunkanirira pairani okyasanokyara ovetsikunkanira kipatsi ovashi maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yogari iketyosanorira yogunkani inti Averi. Yogari impogitasanotanankitsirira inti Sakariashi yogunkanirira ivankoku Tasorintsi inavetakara aikyara itagantaganirira piratsipage. Irorotari nonkantantaigakempirira maika arisanotyo inkisaigakempi viroegi timaigatsirira maika inkenkiagaviigakempirira maganiro yogaigunkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Maikaniroro pantsipereavageigake viroegi gotagantaigirorira itsirinkakotanakerira Moiseshi! Pogoigavetakarotari Iriniane Tasorintsi, pinkogaigakeme pogoigakera tyara pinkantaigakempa irogavisaakoigakempira, irorometyo pogotantaigakempa. Kantankicha teranika pinkogaige pogoigakera viroegi, aikiro itimaigavetaka pashini kogaigavetankicharira irogoigakera teratyo iragaveaige irogoigakera, povashigakovageigakaritari pogotagaigakerira pikantaigakerira intsatagageigakerora posante nerotyo tyampa inkantaigakempa inkematsaigakera iriroegi aikiro.” ");
INSERT INTO mcbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Impo ikonteiganaira ikisaigamatanakatyo gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi ovashi ikogakotagantaiganakeri posante ");
INSERT INTO mcbNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ineaigakerira tyarika inkante kameti ontimakeniri onkenantakemparira inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Impogini yapatovageiganakatyo kara matsigenkaegi itovaigavagetityo kara yagatikavakagaiganakatyo. Yogari Jeso ikantaigiri irogamereegi: “Tsikyanira pikañoigarikari pariseoegi ineakagantaigara inkantaigakenkanira ikematsatasanoigiri Tasorintsi, kantankicha teratyo arisano inkematsatasanoige, ontityo ikematsatamampegaigaka kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kantankicha magatiro terira ogotenkani maika impoginityo ogotakenkani. Ario okañotaka magatiro omanagetunkanirira maika impoginityo ogikoneatakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Irorotari maika nonkantantaigakempirira ogari magatiro mairenirira pikantaigirira ganiri tyani gotumatatsi impoginityo ogotanakenkani, irogoiganakero maganiro. Ario okañotaka, magatiro pikantaigakerira parikoti pomanakotakerora ganiri tyani kemumaigimpi impoginityo onkemakotanakenkani ontsotenkakovagetanakempatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Maika nonkantaigakempi viroegi noamigoegite, gara pipinkaigiri kogaigankitsinerira irogamagaigakempira. Iriroegi irogamagaigakempirika intagatitari kamankitsine pivatsa, kantankicha garatyo yagaveimaigi irogamagaigakerora pisure. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kantankicha naro nonkamantaigakempi tyani pimpinkaigake. Irirotari pimpinkaigake Tasorintsi, panirotari ikantara irirori yagaveira inkantakera tyani kamankitsine impo iragaveake intigankakerora isure morekariku. Jeeje, arisanoniroro iriro pimpinkaigake. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Matsi tera pineaigeri tsimeripage intagatira ipunata 5 tsimeri pimentyakiteni koriki?, kantankicha yogari Tasorintsi teratyo imagisantumateri. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kañotari pigishiegi akyari yogotiro papeapagetiro. Irorotari nonkantantaigakempirira gara pitsarogaigi, pairotari pavisavageigakeri tsimeripage. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Maika nonkantaigakempi tyanirika kantasanotankitsine ikematsatasanotakenara inkamantaigakerira itovaireegi, ariotyo inkañotakempa Kañotasanotakaririra Matsigenka impogini inkantaketyo: ‘Nanti shintari’, inkemaigakerira maganiro isaankariite Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kantankicha tyanirika kantankitsine: ‘Tera nonkematsateri Jeso, inkante’, ariotyo inkañotakempa Kañotasanotakaririra Matsigenka impogini inkantaketyo: ‘Tera naro shintemparine’, inkemaigakerira maganiro isaankariite Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tyanirika samatsanatakerine Kañotasanotakaririra Matsigenka iragaveake Tasorintsi imagisantakotaerira, kantankicha yogari samatsanatakerine Isure Tasorintsi garatyo imagisantakotumatiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Antari ariorika iramaitanakempi pankotsiku yapatoitantaigarira ontirika inaigira joese intirika koveenkaripage, gara pisureigaro tyarika pinkantaige. Gara pikantaigi: ‘¿Tyarika nonkantaigeri?’, ");
INSERT INTO mcbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","isuretagaigakempitari Isure Tasorintsi kameti pogoigakeniri tyara pinkantaige.” ");
INSERT INTO mcbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Impo iniamatanaketyo paniro matsigenka tentaigakaririra patoitaigankicharira ikantiri Jeso: —Gotagantatsirira, atsi kanteri ige impagarantakenarora iokimoiganaanarira apa ikamanakera, itsaneapitsatakenarotari nashintakemparimera. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kantankicha Jeso ikantiri: —¿Matsi naro joese kameti nonkantakerira impagarantakempira? ");
INSERT INTO mcbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Impo ikantaigiri maganiro: —Tsikyanira pikogaigikari pashintavageigakempara. Pashintavageigavetakempatyo, ¿matsi iroro ganiaigakempine? ");
INSERT INTO mcbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ovashi ikantakotanakeri shintavagetacharira ikanti: “Itimake pashini matsigenka shintavagetacharira. Yashintagematatyo igipatsite ipankitagantagematityo turigoki impo otimanake ojojoo, tyarika, teratyo choeni. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Impogini avisavagetanakerotyo kara yogantarorira, tyampatyo irogakero, ikanti: ‘¿Tyarikatyo nonkantakero?, avisanakerotari nogantarorira. Maika ¿tyarika nogakero?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Impo isurematanakatyo ikanti: ‘Maika nogotake tyara nogakero. Nontireakagantakero nogantagevetarorira novetsikakagantagetakera pashini omarapageni kameti ogonketakempaniri magatiro nogantagetakemparora noturigokite ontiri aikiro magatiro noarakipage.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Impo ishinevagetanaka ikanti: ‘Maika timakotakenaniroro tovaiti, gatata otsonkageta ontovaigakovagetanake shiriagarini gara tatoita nokogakotumata. Maikari maika nampishigopireavagetakempa, nosekatavagetakempa, noviikavagetakempa, noshinevagetakempatyo kara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kantankicha Tasorintsi ikantiri: ‘Tera pogotumate viro, paitatyo pinkamake tsitenigetiku pokagetanakerora magatiro pashintagetakarira, tyanimpatyo shintagetaemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ario ikañota maika maganiro yoga kogatsirira intaganira irashintavagetakempa irirori, kantankicha tera irogote yogari Tasorintsi ineakeri kañomataka tera irashintumatempa maani.” ");
INSERT INTO mcbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Impogini Jeso ikantaigiri irogamereegi: “Maika nonkantaigakempi gara povankinaventaigaro pisekaegi pinkantaigakera: ‘Maikaniroro kamani ¿tatarikatyo nogaempa?’ Aikiro gara povankinaventaigaro pogaguigakemparira pinkantaigakera: ‘¿Tyarikatyo nagakero nogagutaemparira?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kañotari pisure paniantaigarira yagaveaketyo Tasorintsi itimakagakerora irorompari piseka pairo impaigakempiro. Ario okañotaka pogaguigakemparira, kañotari yagaveakera Tasorintsi itimakagakerora pivatsa irorompari pogaguigakemparira pairo impaigakempiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pineaigiritari kogonti teratyo impankivageigavetempa, aikiro teratyo ontimavetempa irogantaigakemparorira iseka iriatapiniigakera iragapiniigakera isekataigakempara, kantankicha Tasorintsi ipaigirityo irogaigakemparira. ¡Viroegimparorokari pairo impaigakempi pisekaegi pogaigakemparira, pairotari pavisaigakeri aragetatsirira! ");
INSERT INTO mcbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Antari povankinaventaigemparora pinkimoiganakera ¿matsi ario pagaveaigake pinkimoiganakera? Garatyo pagaveimaigi. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iroroventi tera pagaveaigenika tesanorira onkomutempa, ¿tyara okantaka povankinaventaigakarora pairorira avisake okomutapitsaigakempira? ");
INSERT INTO mcbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pineaigironirorotyo oka otegapage tsikyata oshivokashiigaro irorori tera antumaigavetempa, aikiro tera onkirikaigavetempa akyari okametivageigi avisavagetaketyo kara okametitakera, avisagetakerotyo kamisa kametimagorisanorira pairanitirira yogagutarira koveenkari Saromon pairorira avisake okametimagotakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kañotari oka otegapage porenkamaivagetake ikametitagagetirora Tasorintsi, kantankicha kamani ovatuakenkani ontagakenkanira, ¡viroegimparorokari pairo impaigakempi pogaguigakemparira! Kantankicha viroegi tera pinkematsatasanoigeri onti povankinaventaiga posantepage. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Irorotari maika nonkantaigakempi gara povankinaventaigaro pogaigakemparira ontiri poviikaigakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Intitari kañoigiro maika yogaegi terira inkematsaige yovankinaventaigarora posantepage, irorotari ipiriniventaigi iriroegi. Kantankicha viroegi gara pikañoigiro maika, aiñotari Piri timatsirira enoku. Irirori yogotake omirinka tatarika oita pikogakoigaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Irorompatyo pinkogasanoigake pimpiriniventaigakerora magatiro ikogagetirira Tasorintsi, impo irirori impaigakempiro magatiro pikogakogeigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Gara pitsarogaigi. Viroegi onti pikañoigakari ovisha, narori nanti sentaigimpirira. Teratyo pintovaigavetempa, kantankicha Piri timatsirira enoku ishineventaigakempityo irogavisaakoigakempira kameti pintimimoigakeriniri impogini impegakempara Igoveenkariegite maganiro kematsaigakerineririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pimpimantaigakerora pashintageigakarira pagaigakera koriki pimpaigakerira kogakoigankicharira. Magatiro pashintaigakarira aka kipatsiku ontsonkatanaempatyo, kantankicha pimpaigakeririka pashini ario pinkante Tasorintsi inkantakani inkavintsaavageigakempi impogini enoku. Akari aka pashintageigavetakempatyo posantepage, aiñotari koshintiegi inkoshinanaigakempityo. Aikiro aiñotari gagetarorira kamisa ontityo irogagetakemparo kamisapage pashintageigakemparira. Kantankicha antari anta enoku gara tyani pakuakagumatiri Tasorintsi inkavintsaakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Antari irororika pishineventavageigakempa timagetatsirira aka kipatsiku irorotyo pimpiriniventavageigake, intagatitari pisuretakoigakempa. Antari irororika pishineventavageigakempa ikogagetirira Tasorintsi ario pinkante irorotyo pimpiriniventavageigake, irorotari pisuretakoigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Viroegi pinkañoigakemparira nampiriantsiegi yogiaigavairira shintaigaririra iatakera ineerira pashini iamigote iragakera tsinane. Yovetsikashiigavaari iripokaera, yogimorekageigake mechero yogiaigakerira inkaemapaakera irashireakoigavaerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Nonkantasanoigakempi maika irishinevageigakempatyo yogaegi nampiriantsiegi kireaigankitsirira giaigavairirira shintaigaririra iripokaera. Iripokavetapaempatyo nigankigite ontirika onkutagitetamanakera kantankicha ineaigapaakeririka ironampiriaegi kireaiganatsi irovetsikashiigapaakemparityo irirori irovirinitaigapaakerira mesaku impakovageigapaakerira iseka. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Atsi sureigemparatyo, intimera pashini shintankicharira ivanko irogotemera tyatirikara iripokantakempa koshinti, ¿matsi ario irimagake? ¡Garatyo! Ontityo inkireaventakero iaraki ganiri ikiashitagani inkoshitakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Irorotari nonkantantaigakempirira pinkantakanira pinegintevageigakempa pogiaigavaerira Kañotasanotakaririra Matsigenka impigaatera, gatanika pogoiginika tyati impigantaempa, ontitari katsiketyo inkomutagaigapaempi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Impo iniamatanake Perero ikanti: —Notinkami, ¿tyani pikantakoigake? ¿Intagani naroegi pogamereegi ontirika maganiro pikantakoigakeri? ");
INSERT INTO mcbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ikanti Atinkami: “Pinkañoigakemparira nampiriantsi govagetatsirira kematsatasanotiririra shintaririra. Pine intimera shintacharira ironampiriaegi impo iriatakera parikoti inkantanaeri paniro ironampiria ineaigaerira maganiro irapinampiriantsiegitene impaigaerira omirinka isekaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Antari iripokaerika ineapaakeririka itsatagasanotakero ikantanakeririra, ariompatyo irishineventasanotanakempariri ");
INSERT INTO mcbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","inkantanakerira: ‘Maika nokogake pineagetakenarora magatiro nashintagetarira.’ Impo irirori irishinevagetakempatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kantankicha antari garika yogiavairi shintaririra onti inkantake: ‘Gatatarorokari ipokai,’ ovashi intsititanakero inkisakisaiganakerira irapinampiriantsiegitene, surariegi ontiri tsinaneegi. Onti impiriniventuntetanake isekatavagetakempara, aikiro inti inkonoivageiganakempa shinkisenari. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kantankicha katsiketyo inkomutagapaakeri shintaririra inkisashivagetapaakemparityo kara intentagantaigakemparira maganiro terira inkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yogari nampiriantsi govetacharira tatoita irantake ganiri ikishiri shintaririra, kantankicha tera inkematsateri, aikiro tera irovetsikashitempari iripokaera, impasapasatakenkanityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kantankicha yogari nampiriantsi terira irogote tatoita irantake, irovetsikagevetakempatyo terira inkogero shintaririra gasakonatyo ipasatagani, teranika irogote. Kantankicha tyanirika yogotagasanotunkani, okogunkanityo irimatakempara irirori inkañotagasanotakemparora tyarika ikantunkani okyara yogotagunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Naro nopokake aka kipatsiku kameti inkisaviitakenarora magatiro yovetsikageigakerira maganiro matsigenkaegi. ¡Intagame kantaka mataka visaakotaana! ");
INSERT INTO mcbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Maika nogotake nantsipereavagetaketyo kara nerotyo novankinavagetakatyo kara nokenkisureavagetanaka narokyatyo agavagetanake. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pineaigiri irorori nopokashitake irishinevakagaigakempara maganiro? Teratyo iroro nompokashite, ontityo nopokashitake onkenantanakemparora inkisavakagaiganakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nerotyo maika intimaigake matsigenkaegi pankotsiku 5 irinaigake. Kantankicha mavani gara ishineventaigana, piteni shineventaigakenane, nerotyo inkisavakagaigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yogari surari inkisanakeri itomi, irirokya itomi inkisanakeri iriri. Ogari itsinanetsite onkisanakero oshinto ontiri onevatyagete, irorokya oshinto onkisanakero iniro, ario onkañotake onevatyagete irorori onkisanakero ovagirote.” ");
INSERT INTO mcbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Impogini ikantaigiri maganiro: “Antari pineaigirora omenkorisekantira anta iatira poreatsiri pikantaigake: ‘Maika ompariganake inkani’, impo opaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aikiro otampiatira oponiaenkatara kamatikya pikantaigake: ‘Maika onkatsirinkagitetake’, impo okatsirinkagitetanake. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Pishineigakara ontityo pineakagantaigaka kameti inkantaigakempiniri pogovageigi! Viroegi pogoigavetaro pinegiteaigirora ariorika omparigake ontirika gara. Ontiri aikiro pogoigavetaro tyati onkatsirinkagitetantakempa, kantankicha teratyo pogotumaige tyara okantaka yogikoneatimoigakempirora Tasorintsi magatiro pineageigakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Tyara pikantaigakara viroegi tera pinkogaige pinkantaigakera tatoita kametitankitsi? ");
INSERT INTO mcbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Inkisakempirika pitovaire ineakera pipegakotakerira impo inkogavetakempa iramanakempira joeseku kameti inkantakeniri irirori tyara inkantaitakempi. Kantankicha viro pinianiatanakeri avotsiku pogishineaerira ganiri yamimpi. Antari iramanakempirika joeseku irirokya kaemakerine soraro, irirokya soraro onti iragapanutempi irashitakotakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nonkamantasanotakempityo garika pipunatasanotairi kisakempirira magatiro pipegakotakeririra garatyo yapakuaimpi shitakotakempirira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Impogini ipokaigapaake pashini ikamantaigapaakerira Jeso ikantaigiri: —¿Pikemakoigakeri Garireakunirira yogakagantaigakerira Pirato? Iaigavetakara ivankoku Tasorintsi yamaigavetanakenerira saserorote ipiraegi irovetisaigakenerira Tasorintsi. Impogini itigankaigakeri Pirato isoraroegite irogaigakiterira. Impo iaigake ineaigapaakeri anta tsompogi yovatuaigakeri ovoatanake iriraa okonoatanakarotyo iriraa ipiraegi yovetisaigakerira saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ikantaigirityo Jeso: —¿Ario pineaigiri pairori yavisaigake ikañovageigakara iriroegi Garireakunirira yavisaigakeri itovaireegi, nerotyo ikañotantaigunkanira maika? Teratyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naro nonkantaigakempi viroegi aikiro garika pikenkisureaiga pineaigakera povetsikageigira terira onkametite pinkantatigaiganakempara pimpogereaigakempatyo viroegi aikiro impogini pinkañoigakemparira iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Impo aikiro pikemakoigakerira Jerosarenkunirira oparigateigakerira pankotsi ochovaankunkanirira pairani anta Suroeku. Otsitokaigakeri ikamaigake 18. ¿Ario pineaigiri pairori yavisaigake ikañovageigakara iriroegi yavisaigakeri itovaireegi timaigatsirira Jerosarenku? Teratyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naro nonkantaigakempi viroegi aikiro garika pikantatigaiga pimpogereaigakempatyo pinkañoigakemparira iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Impo ikantakoigakeri Jeso iriroegi ikanti: “Itimake paniro matsigenka ipankitake patiro igera itsamaireku, impo iatapiniti ikamosotirora timakerikara oi, kantankicha iavetaka mamerityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iperamatanakarotyo ikantutarityo tsamaitakotirorira: ‘Atsi geka. Nopokashitironi pairani, maika ogatyo omavatakotanaka shiriagarini teratyo ontime oi. Maika togeronityo, onti tikankicha kara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kantankicha irirori ikantiri: ‘Atsi arionetata. Maikari maika nonkigavatakotakero otsitiku impo nontiantakemparo itiga piratsi ");
INSERT INTO mcbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","impa ariorakari ontimanake oi. Impo oshiriaganaerika aikiro, garika otimi ario pinkante pintogakagantakero.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Impogini aganakara kutagiteri apishigopireantaganirira yogotagantavagetake Jeso pankotsiku yapatoitantaigarira jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ario onake kara paniro tsinane omantsigantevagetakeni pairani niganki agavagetanaka 18 shiriagarini tera ovegaempa, itimagutakerotari kamagarini imiguchasetagakero, tyampa onkantaempa ovetinkajaempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Antari ineakerora Jeso ikaemakero ikantiro: —Maika mataavi vegaavi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Impo ipatikaitakero ogitoku oga okenake ovetinkaanaka ovashi oshineventanakari Tasorintsi okanti: —Pairo yavisavagetake Tasorintsi yagaveavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kantankicha yogari tinkamitatsirira pankotsiku yapatoitantaigarira ineakerira Jeso yovegakerora kutagiteriku apishigopireantaganirira ikisamatanakatyo ikantaigiri patoitaigankicharira: —Aityo 6 kutagiteri antavagetantaganirira, irorotyo pimpokantapiniigempa kameti irovegaigaempiniri. Gara iroro pipokantaiga kutagiteri apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iniamatanaketyo Jeso ikantiri: —¡Pishineigakara pineakagantaigakara inkantaigakempira pikematsatasanoigakera! Kañotari viroegi agara kutagiteri apishigopireantaganirira pitsaakoigirira pivakane intirika piashinote pamaiganakeri pipaigakerira nia yoviikaigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iroromparorokari oka tsinane iyashikitanakerira Averan pairo novegantaemparo kutagiteri apishigopireantaganirira, noneakerotari itimagutakerora kamagarini aganaka 18 shiriagarini tyampa onkantaempa ovetinkajaempara novegaironiroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ineaigakera ikantaigakerira ipashiventavageiganakatyo maganiro kisaigakeririra. Kantankicha yogari itovaire ishinevageiganakatyo kara ineaigakerira Jeso yovetsikagemati posante terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Impo ikanti Jeso: “¿Maika tatoita okañotakaro ipegakara Tasorintsi Igoveenkariegite matsigenkaegi? ¿Tatarikatyo nonkañotagakemparo? ");
INSERT INTO mcbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ariokya nonkañotagakemparo okitsoki mosetasa. Iatake paniro matsigenka ipankitakerora pakitsotiro mosetasa itsamaireku impo oshivokanake okimovagetanake otsegororoitanake okañotanaaro inchato itimantaigaaro tsimeripage.” ");
INSERT INTO mcbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Impo ikanti aikiro: “¿Tatarikatyo nonkañotagakemparo ipegakara Tasorintsi Igoveenkariegite matsigenkaegi? ");
INSERT INTO mcbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ariokya nonkañotagakemparo opoegantarira pan. Pineirotari tsinane ovetsikira pan agavatake kimopane turigopane, impo okonogantakaro opoegantarira ogatyo okenake opoeganake magapatsatiro.” ");
INSERT INTO mcbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Impogini ariompa iatanakeri Jeso Jerosarenku ikenagetanake itimageigira matsigenkaegi yogotagageiganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aiño pashini ikantiri: —Notinkami, ¿gara itovaigi gavisaakoiganankichanerira? Impo inianai Jeso ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Pimpomirintsiventaigakemparora pinkiantaigakemparora sotsimoro maaniñakitirira. Nonkantasanoigakempitari intimaigake tovaini kogaigavetankichanerira inkiantaigakemparora, kantankicha garatyo yagaveaigi ikiaigira. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Impoginitari inkaviritanake shintarorira ivanko irashitakero sotsimoro. Viroegi terira pinkiaige paratinkaigake sotsi poenenkaigavetakemparotyo shitakomentontsi pinkaemaiganakera: ‘Notinkamii, shireakoigena.’ Kantankicha irirori inkantaigempityo: ‘¿Tyampatyora piponiaigakara viroegi?, teranika naro shintaigempine.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pinkantaigavetanakempatyo: ‘Notentaigakempi nosekatavageigara, aikiro viro pogotagantavageti avotsiku napatotasanoigakara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kantankicha irirori ariompatyo inkantaiganakempiri: ‘Nokantaigakempitari tera naro shintaigempine. Piaigetyo parikoti maganiro viroegi vetsikagisevageigirorira terira onkametite.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ovashi piragaiganakempa pinkaemavavageigaketyo kara pantsikagiseiganakerora pai pineaigakerira Averan, Isaako, Jakovo intiegiri pashini kamantantaigatsirira itentaigakarira Tasorintsi, viroegi onti intigankaigakempi parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iripokaigapaaketari tovaini terira iriroegi jorioegi imponiageigamatempatyo samani kara pashinipageku kipatsi irishinevageigakempatyo intentaigakemparira Tasorintsi impegakempara Igoveenkariegite maganiro kematsaigiririra. Imponiageigamatempatyo oatakara ikontetira poreatsiri, pashini imponiageigamatempatyo iatira poreatsiri, pashini kamatikya, pashinikyatyo poniaigankichane katonko. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aiñoegitari ineaigavetunkanirira maika yavisaigakerira itovaire, kantankicha iriroegikyatyo iravisaiganaenkani impogini. Iriroegikya ineaigavetunkanirira yavisaigunkanira maika, impogini iriroegikyatyo visantaiganaatsine. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Impo osamanitanakera ikenaigapaake pariseoegi ikantaigapaakeri Jeso: —Maika piatae, yogukari Erorishi. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kantankicha irirori ikantaigiri: —Piaige pinkantaigapaakerira yoga matavitantatsirira pinkantaige: ‘Ikantake: Atsi geka, maikari maika aiñokya noneagempari kamagarinipage ontiri aikiro novegaigaerira mantsigaigankitsirira. Ario nonkañotake kamani, tenigetari ontovaige kutagiteri nagatagetanaerora nopokashitakerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kantankicha maika ariompatyo noatanakeri Jerosarenku. Ario nonkañotake maika ontiri kamani ontiri aikiro kamani pashini. ¿Matsi tyara onkantakempara irogakenkanira kamantantatsirira parikoti garira ario Jerosarenku? ");
INSERT INTO mcbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerosarenkunirira, Jerosarenkunirira, pogaigirira kamantantaigatsirira, aikiro pipitankaigirira itigankimoigakempirira Tasorintsi inkenkitsatimoigakempirora Iriniane! Pineaigiro atava osavogaigirira otyomiani, nokoganagevetakatyo naro nonkañotagaigakempimera maganiro viroegi nampatoitaigakempimera pinkematsaigakenara, kantankicha viroegi teratyo pinkogumaige. ");
INSERT INTO mcbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Maikari maika ganigetyo inimoigaimpi Tasorintsi panivani pampuntavageigaempa. Nonkantaigakempi maika gara pineaigaana kigonkero aganakempara pinkantaigavakenara: ‘¡Pairo ikametiti yoga itigankakerira Tasorintsi!’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Impogini agakara kutagiteri apishigopireantaganirira iatake Jeso isekatakara ivankoku itinkamiegi pariseoegi. Yogari itovaireegi pariseoegi ikamagutasanoigakerityo ineaigakerira tyarika inkantakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ario inake kara iriroku paniro nonasenari. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Impo yogari Jeso ikantaigiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi: —¿Kametitake povegerira mantsigari kutagiteriku apishigopireantaganirira, ontirika tera onkametite? ");
INSERT INTO mcbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kantankicha iriroegi ikemisantaiganaketyo. Impo Jeso itsagatakeri nonasenari yovegakeri ikantakeri iriataera. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Impo ikantutaigaarityo aikiro pariseoegi: —¿Matsi viroegi irashiriera otseraaku piashinote intirika pitorone kutagiteriku apishigopireantaganirira ario gara pinoshikaigaatiri? ¿Matsi ario pogiaigake avisanaera apishigopireantaganirira ario pinoshikaigaateri? ");
INSERT INTO mcbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tyampatyo inkantaigeri, teratyo iriniimaige maani. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Impo yogari Jeso ineaigakerira maganiro ikaemaigunkanirira isekataigakempara ontira ikogasanoigake impitaigakera intentaigakemparira kaemantankitsirira ovashi ikamantageigakeri ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Inkaemaigempirika ikyarira gankitsi tsinane pisekatimoigakemparira gara iroro pipirinitantapaaka impirinitantakemparira tentasanotakemparinerira kaemantankitsirira. Katinkariratyo iripokapaake pashini pairorira yavisake ishineventakarira kaemaigakempirira, ");
INSERT INTO mcbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","impo iripokapaake irirori inkantempi: ‘Atsi mereanakeri yoka.’ Ovashi pimpashiventanakempa akya pintsatake pimpirinitantakemparora panivatirira onai terira ompirinitantenkani, ontitari impirinitantakemparira terira irishineventasanotempari kaemantankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ariompa onti pimpirinitapaake anta kameti inkiapaakera kaemakempirira ineapaakempira inkantapaakempiniri: ‘Amigo, taina pimpirinitakera aka naroku.’ Impo inkemaigakera tentaigakempirira mesaku irogoigake viro ishineventasanotaka kaemakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Imirinkatari ventakovagetacharira impotetashivagetakempari Tasorintsi irogipashiventavagetakerira. Irirokya terira iraventakotempa irishineventakempari inkavintsaavagetakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Impo ikantakeri aikiro kaemakeririra ikantiri: —Ponkotakaganterika piseka pinkaemantakera gara intagani pikaemavintsaigi piamigoegite intirika pirentiegi, garira intirika pinkaemaigake piitanepage intirika shintavageigacharira timaigatsirira aiñoni pivankoku. Iriroegirika pinkaemaigake impugaigaempityo inkaemaigaempira viro pisekatimoigakemparira iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Irirompatyo pinkaemaigake terira irashintavageigempa intiegiri shinkogisenari intiegiri terira iranuitagantsiige intiegiri aikiro terira ineaige. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pishinevagetakempatyo kara gatanika yagaveaiginika impugaigaempira iriroegi, kantankicha inti pugaigaempine Tasorintsi impogini iraniaiganaera yogaegi ineaigakerira kañomataka tenirikatyo inkañovagetumaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aiño paniro pirinitankitsirira mesaku iroro ikemavakerira Jeso ikantakera iniamatanaketyo ikanti: —¡Irishinevageigakempa sekatimoigakemparineririra Tasorintsi impogini irapatoitaigakerira maganiro kematsaigiririra impegakempara Igoveenkariegite! ");
INSERT INTO mcbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Impo inianake Jeso ikanti: —Itimake pashini matsigenka ikogake inkaemantakera, impo ikamantakagantaigakeri maganiro inkaemaigakerira isekatimoigakitemparira intovaigavageteratyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Impogini yonkotakagantake posante iseka impo oposagetakera itigankake ironampiria inkantaigakiterira: ‘Tsame, mataka posatake magatiro.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Kantankicha maganirotyo ikantaiganake: ‘Gara nopoki.’ Paniro ikantake: ‘Nakyaenkasano punaventankitsi kipatsi, noataketari nonkamosotakiterora noneakiterora. Gamera onti nompokakemetyo.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pashinikya kantanankitsi: ‘Nakyaenkasano punaventankitsi 10 toro, noataketari noneakiterira nogoigakerira arisanorika yantavageigi. Gamera inti nompokakemetyo.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yogari irapitene ikanti: ‘Nakyaenkatari gankitsi nojina, gara noati.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Impo ipigaa ironampiria ikamantagetapaakeri shintaririra. Ikisamatanakatyo irirori ikanti: ‘Iroroventi piatetyo anta apatotakara pankotsi pintsotenkavagetanakerora magatiro avotsipage pintentaigakerira terira irashintavageigempa intiegiri shinkogisenari intiegiri terira iranuitagantsiige intiegiri aikiro terira ineaige iripokaigakera isekatakoigakenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Impogini osamanivagetanake ipokai ironampiria ikantapaakeri: ‘Mataka nagaigakitiri, kantankicha tekya intsotenkaigempa mesaku.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Inianake nampitaririra ikantiri: ‘Iroroventi piate piganake ariokya pinkenanake avotsipageku tekyarira pinkamosogetero pinkamosogetapanuterira maganiro timaigatsirira kara pintentaigakerira ishatekaitanakempara novankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Maika nonkamantaigakempi garatyo isekatumaiga iketyorira nokaemaigavetaka.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Impogini ikenanake Jeso avotsiku yogiaiganakerityo tovaini matsigenkaegi kara. Impo ishonkateiganakari ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tyanirika kogankitsine inkematsatasanotakenara impegasanotakempara nogamere garatyo pairo yavishi itasanoigarira tomintaigaririra, ontirika itsinanetsite, itomiegi, irishintoegi, irirentiegi, ontirika iritsiroegi, narokya ogakona intakena. Antari inkañotakemparika maika garatyo yagaveimati impegakempara nogamere. Ario okañotaka aikiro garika ikogi irapakuagetanakerora tatarikara oita ishineventagetakarira irirori garatyo ipegasanota nogamere. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ario ikañotaka aikiro tyanirika terira inkoge iratsipereaventavagetakenara irogiavagetakenara garatyo yagaveimati ipegasanotara nogamere. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tyanirika kogankitsine irovetsikakera pankotsi inchovaankakagakerora ¿matsi gara oketyo isuretaro akatirika ikogashitaka koriki kameti iragatakerora magatiro? ");
INSERT INTO mcbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Antari garira oketyo isuretaro ontirika irovetsikashitakemparo kogapage impo niganki ontsonkatakotanakempa ario tyara iragashitakero pashini kameti iragatakeroniri. Garatyo yagatiro ontirorokari isamatsanatakenkani ineakenkanira intagatira maani yogaratinkagetakero. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Inkantakenkani: ‘Irirori yovetsikavetanakaro tera iragaveero iragaterora.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ontirika intimake koveenkari shintankicharira 10,000 soraroegi iriatake iromanatavakemparira pashini koveenkari shintankicharira 20,000 isoraroegite, ¿matsi gara oketyo isureta ariorika iragaveakeri ontirika gara yagaveaigiri? Isuretakempanirorotyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Impo ineerika gara yagavei, intigankaketyo isoraroegite intonkivoaigavakemparira pairorira yavisaigakeri ineaigakerira ariorika iragaveaigake irogametiaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Arioniroro okañotaka maika tyanirika terira inkoge iokagetanakerora magatiro yashintagetakarira garatyo ipegasanota nogamere. ");
INSERT INTO mcbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ogari tivi opochatira pairo okogasanotagani, kantankicha antari omasankatera ganigera opochatai, ¿ario tatatyo onkogavitaenkani? ¿Matsi tyampatyo onkantaenkani kameti ompochatanaera? ");
INSERT INTO mcbNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ganigetyo tatoita okametitashitumatai. Gara okametiti ontiantakenkanira kipatsi kameti ontimasanotakeniri pankirintsi, aikiro gara okametiti onkonogantakenkanira kaara ontiakotantakenkanira pankirintsi. Ontityo ovuokakenkani parikoti. Pikemaigakenarika maika atsi suretasanoigemparotyo nokantaigakempirira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impogini yogaegiri maganiro kogantaigaririra itovaireegi koriki irashi koveenkari intiegiri kañovageigacharira yaiñoniiganakari Jeso inkemisantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Impo ineaigavakerira pariseoegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ovashi iniashinaigakari Jeso ikantaigi: —Atsi geka, ¿tyara ikantakara yonta itentavintsaigakarira kañovageigacharira isekatakoigakarira? ");
INSERT INTO mcbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Impo inianake Jeso ikantakotakara ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pine viroegi pashintaigempara 100 ovisha pamaiganakeri anta shimpenashiku isekataigakempara impo impegakempa paniro, ¿matsi gara pokaiganakeri itovaire piatakera pinkogaaterira kigonkero pagaerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Impo pagaeririka pintsomaanaeri pamanaeri pishinevagetakempatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Impo pogonketapaakempara pivankoku pinkaemaigapaakeri piamigoegite intiegiri choenitakoigimpirira pinkantaigakerira: ‘Tsame ashinevageigakempara, nagairitari novishate pegavetankicharira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Maika nonkantaigakempi ario okañota intimera paniro kañovagetacharira irapakuaerora yovetsikagisetakera terira onkametite ovashi inkantatiganakempa irishineventavagetakenkanityo kara anta enoku avisakerotyo ishineventaganira 99 matsigenka terira inkogakoigempa inkantatigaigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ontirika ashintakempa paniro tsinane 10 korikimenta impo impegakempa pamentaniro ¿matsi gara ogimoreki mechero ontarogakotakerira onkogasanotaerira agaerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Impo agaeririka onkaemaigakero oamigaegite ontiri choenitakoigarorira onkantaigakerora: ‘Tsame ashinevageigakempara, nagairitari nogorikite pegavetankicharira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Maika nonkantaigakempi ario ikañoigaka isaankariite Tasorintsi ishinevageigatyo kara ineaigira ikantatigara paniro kañovagetacharira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Impo ikantake Jeso aikiro: “Itimi paniro surari aiño itomi piteni. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Impo yogari iyashiki ikantakeri iriri: ‘Apaa, atsi penaronityo maika magatiro nashintakemparira naro impogini pinkamanaera.’ Yogari iriri ipaigakeri piteniro magatiro okatinkageigakeririra paniropage. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Impo omavagitetanakara kutagiteri yogari iyashiki yaganakeri maganiro igorikite iavagetaketyo samani kara pashiniku kipatsi, ario kara yovetsikagisevagetanake posante yaparatakeri igorikite itsonkatasanotakerityo kara yogakatyo noganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Impogini itsonkatasanotakerira maganiro igorikite otsonkamatanakatyo sekatsi apagiteanakarotyo kara, tyampatyo iragaero irogaemparira yatsipereavagetake itasegane. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Impogini iatake irantavagetimotakerira pashini timatsirira kara. Irirori itigankakeri irisentakenerira ishintorite. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tyarika, itasegagetanaketyo kara irorokyatyo iroganakempa otaki ipaganirira shintori inkemanakempara, teranika tatakona impumatenkani irogakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Impogini isurematanaatyo ikanti: ‘Yogari tavagetimoigiririra apa isekatavageigatyo kara, okonogaka ikemaiganaka tera intsonkatasanoigero. Narori aka panikya aganakena notasegane. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Atsi nompiganaeta apaku nonkantapaakeri: Apaa, ineakena Tasorintsi novetsikagisevagetakera terira onkametite, aikiro viro nogipashiventavagetakempityo notsonkatasanogetakerora magatiro pipagevetakenarira naparatakerora. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Maika ganigerorokari pikantaana: Notomi, onti pimpegaena tavagetimotimpirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Impogini iatanai yogonkevagetaa ivankoku iriri. “Irorotyo ineventakotavakarira ikenapaakera itsarogakaganakarityo kara ishiganakatyo itonkivoavakarira, yagavairi yavinatavakerityo yasaraanatavakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Impo inianake irirori ikantiri: ‘Apaa, ineakena Tasorintsi novetsikagisevagetakera terira onkametite, aikiro viro nogipashiventavagetakempityo notsonkatasanogetakerora magatiro pipagevetakenarira naparatakero. Maika ganigerorokari pikantaana: Notomi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kantankicha iriri ikantaigirityo ironampiriaegi: ‘Piaige gaigute kamisa pairorira avisake okametitasanotakera pogaguigakerira intiri aikiro aniyo pogakenerira ichapakiku, aikiro pisapatoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pagaiguterira toro akamotiakyanirira keitasanotankitsirira povetisaigakerira. ¡Tsame asekatavageigakempara ashinevageigakempara!, ");
INSERT INTO mcbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","pigaatari notomi, okyara noneiri ariori ikamake. Ipegasanovetakatari, maikari maika aneaigairi.’ Impo isekatavageiganaka ishinevageigaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yogari itsitiki onti inake tsamairintsiku. Impo ipokavetapaaka ikemisantumatapaakerotyo sonkarintsi tyarika, ontiri aikiro itosoigakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Impo ikaemake paniro nampiriantsi ikantiri: ‘¿Tatatyo oitara kara?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Irirori ikantiri: ‘Ontitari ipokaira pirenti. Maika yovetisakagantakeri piri akamotiakyanirira toro keitasanotankitsirira, kametikyatari yogonketaa.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ogatyo ikenake ikisamatanakatyo irirori teratyo inkoge inkiaera pankotsiku. Iroro ikemakotakerira iriri ikontetanake iatake ikantakerira inkianaera. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kantankicha irirori ogatyo ikantanakeri: ‘Atsi geka, pogotake viro naro omirinkatyo nantavagetimovagetimpi teratyo nompugatsatumatempi, tera ario pimpumagetena paniro kavera ityomiani nonkaemaigakerira noamigoegite nosekatagaigakemparira noshinevageigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kantankicha maika ipokaira pitomi tsonkatutakempiririra pigorikite yaparatagantakarora tsinaneegi pogereantaigatsirira, pinoshikityo povetisakagantiniri toro keitasanotankitsirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Inianaityo iriri ikantiri: ‘Notomi, virori ariotari piniri naroku. Magatiro nashintagetarira onti pashi viro aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kantankicha maika kametitake asekatavageigakempara ashinevageigakempara, pokaitari pirenti, okyara noneiri ariori ikamake, ipegasanovetakatari, maikari maika pokai aneaigairi.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Impogini Jeso ikantaigiri aikiro irogamereegi: “Itimake paniro shintavagetacharira aiño iromperane neagetiniririra magatiro yashintagetarira. Impogini ikamantunkani ikoshitagarantutanakerira yashintagetarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Impo ikaemakeri ikantiri: ‘¿Arisano pikoshitagarantanakena? Atsi makenaro pisankevantite pitsirinkakotantagetarorira magatiro noneakerora tyara pikantanakero, ganigetari pantimovagetaana.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Impo irirori isuretanaka ikanti: ‘¿Tyarikatyo nonkantakempara maika? Ganigetari nantimotairi, ¿tatarikatyo nantae? Teranika noshintsite, ¿tyara nonkantakempara nontsamaivagetakera? Nopashiventaka nonevitantavagetakera.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Impo ikanti: ‘Maika nogotake tyara nonkantakempa kameti intimakeniri pakenanerira noseka impogini intigankaenarika novaterote.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Impo iatake ikaemaigakeri pegakoigakeririra ivaterote, paniropagekya ikaemavake. Yogari iketyorira ikaemakeri ikantiri: ‘¿Akatovaiti pipegakotiri novaterote?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Inianake irirori ikanti: ‘Inti nagakotake aseite inakotake 100 irata.’ Impo ikantiri: ‘Nero oka pisankevantite pitsirinkakotakerira karanki pipegakotakeririra. Maika atsi tainapage shintsi tsirinkaero aka pinkantatigakerora intaganivati pogae 50.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Impogini ikaemake pashini imatakeri irirori ikantiri: ‘¿Akatovaiti pipegakotiri novaterote?’ Irirori ikanti: ‘Onti nagakotake turigoki onakotake 100 kantiri.’ Impo ikantiri: ‘Nero oka pisankevantite pitsirinkakotakerora karanki pipegakotakeririra. Maika atsi taina tsirinkaero aka pinkantatigaerora intaganivati pogae 80.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Impogini yogari ivaterote yogotakera ikañotakerora maika yogavagetanaketyo kavako ikanti: ‘¿Matsi pairo yogoti yoga matavitantatsirira?’ Irorotari maika nonkantantaigakempirira maganiro terira inkematsaigeri Tasorintsi yogovageigityo tyara inkantaigakeri itovaireegi kameti iragaveakoigakeroniri tatarika ikogaigake, yavisaigakerityo kematsaigiririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kantankicha maika naro nonkantaigakempi viroegi intimaigera pigorikite pinkavintsajaigakeri kogakoigankicharira pimpaigakerira tatarika oita ikogakoigaka kameti irishineigakempiniri, impo pinkamaiganaerika pokaiganaero magatiro pashintageigavetakarira iragaigavakempi iriroegi anta enoku pankotsiku garira otsonkatumata. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tyanirika negintetacha intagatityo ikantavetunkani maani intsatagakerora kantankicha inegintetakerotyo magatiro itsatagakerora. Impo ario ikañotagakaro aikiro tatarika pairorira avisake ikantunkanirira. Yogari terira inegintetempa teratyo inegintetero maanitirira ikantunkani intsatagakerora impo ariotyo ikañotagakaro aikiro pairorira avisake ikantunkanirira intsatagakerora. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nerotyo viroegi pamparaigakerorika timagetatsirira aka kipatsiku pegankichanerira impogini, ¿matsi ario impaitakempiro pairorira avisake okametitakera onkantakanirira ontimake? ");
INSERT INTO mcbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ario okañotaka aikiro garika pineasanotiro tatarika oita inkantakempirira shintarorira pineakenerira, ¿ario tyanityora paigakempirone pashintasanoigakemparora pairorira avisake okametitakera? ");
INSERT INTO mcbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gara tyani gaveatsi intimakera piteni shintaririra inkematsatasanoigakerira piteniro. Panirotyo irishineventakempa inkematsatasanotakerira, yogari irapitene gara ikematsatiri, gatanika ishineventari. Ario ikañotaka tyanirika kogankitsine irashintaarantavagetakempara garatyo ikogumati inkematsatasanotakerira Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Impogini yogaegiri pariseoegi naigankitsirira kara iroro ikemaigakerira Jeso ogatyo ikenaigake isamatsanaiganakeri, intiegitari kogasanoigiririra koriki. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ikantaigutarityo Jeso: “Viroegi vintiegi pegamampegaigacharira negintevageigacharira pineakagaigakerira matsigenkaegi, kantankicha Tasorintsi ineasurentaigakempityo. Irirori tera irishineventemparo ishineventaigarira matsigenkaegi, ontityo ikisashitasanotaro. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Pairani tekyara iripoke Joan inkenkitsatakera, ikantake Tasorintsi ontsatagagetakenkanira itsirinkakotanakerira Moiseshi ontiri aikiro itsirinkakoiganakerira kamantantaigatsirira, kantankicha impogini ipokakera Joan irorokya ikenkitsatakotake tyara inkantaigakempa matsigenkaegi kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite, impo maganirotyo kogasanoigankitsirira impegakempara Tasorintsi Igoveenkariegite yogavisaakotunkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ogari inkite ontiri kipatsi ontsonkagetanaempa, kantankicha ogari Itsirinkakagantakerira Tasorintsi garatyo okantatigumata, ontityo ontsatagagetanakempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Tyanirika okanakerone itsinanetsite pashinikya iragake onti ikañovagetaka. Ario ikañotaka gakeronerira tsinane okunkanirira onti ikañovagetaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Itimake paniro shintavagetacharira yogagugematatyo kamisa mechomagori ogametirepagetyo kara. Omirinkatyo kutagiteri isekatasanovagetaka posantepage kara tera tatoita inkogakotumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Itimake aikiro paniro terira tatakona irashintumatempa, ipaitaka Irasaro. ¡Ojojoo ontiratyo itere teratyo choeni! Omirinka yamapinitagani yoginoriapinitaganira sotsimoroku ivankoku shintavagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yatsipereavagetaketyo itasegane ikogavetakatyo intimashitavakerora ovoroki ashiriakara mesaku isekatara shintavagetacharira irogakemparora. Ipokashiigakeri otsiti inerogiseigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Impogini ikamake Irasaro. Yogari isaankariite Tasorintsi yamaiganairi inakera Averan intentaemparira anta okametigitetira. Impogini ikamanake shintavagetacharira irirori ikitataagani, ");
INSERT INTO mcbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","kantankicha yatsipereavagetaketyo kara morekariku Impo ineventakotakari Averan itentakari Irasaro. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ikaemakotutarityo ikantiri: ‘Apaa Averan, tsarogakagavagetenakario, tigankeri Irasaro iokaachapakitapanutempara niaku iripokakera irorenkakerora nonene, natsipereavagetaketyo aka tsitsiku, tyarika, onkatsirinkavageteratyo kara.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kantankicha Averan ikantiri: ‘Notomi, suretaemparotyo pairani tekyara pinkame, viro pishinevagetakatyo kara tera tatoita pinkogakotumatempa. Yogari Irasaro yatsipereavagetaketyo kara. Maikari maika irirokya shinevagetankicha aka, virokya tsipereavagetankitsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aikiro otsatenivagetitarityo kara viroku, tyanimpatyora gaveankitsine iriatakera kara. Ario ikañoigaka naigankitsirira kara garatyo yagaveimaigi iripokaigakera aka, ¿ario tyara inkenaigake?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Impo inianai aikiro shintavagevetacharira ikantiri: ‘Iroroventi maika nokogake pintigankakerira Irasaro ivankoku apa. ");
INSERT INTO mcbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aiñoegitari anta igeegi 5 inaigake. Inkamantaigakerira ganiri ipokaigi iriroegi aikiro aka iratsipereavageigakera.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ikantiri Averan: ‘Aityoniroro itsirinkakotanakerira Moiseshi intiegiri kamantantaigatsirira, irorotyo iriniavantaigake irogoigakera tyara inkantaigakempa kameti iripokaigakeniri aka naroku.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inianai irirori ikantiri: ‘Jeeje, apa, pikantasanotakeniroro, kantankicha iriatera paniro kamankitsirira inkamantaigerira, ario pinkante inkantatigaiganakempatyo.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kantankicha Averan ikanti: ‘Kañotari itsirinkakotanakerira Moiseshi intiegiri kamantantaigatsirira tera ario irishineventaigemparo, ariomparorokari iriatera kamankitsirira garorokarityo ikogumaigi inkemisantaigerira inkematsaigakerira.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Impogini ikantaigiri Jeso irogamereegi: “Omirinka itimaigi kogaigankitsirira inkañovagetagantaigakera, kantankicha ¡maikaniroro iratsipereavagetake tyanirika kañovagetagakerine pashini, pairotari inkisashitakenkani! ");
INSERT INTO mcbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tyanirika kañovagetagakerine paniro yoka kematsatakenarira terira impaitumatempa inkisashivagetakenkanityo kara. Irorotari nonkantantaigakempirira ganiri ikañotiri maika oketyome irogatsatakotantakenkani itsanoku omarane mapu otononkantaganirira iramanakenkanira iokaatakenkanira otsompogiatira omaraaniku nia. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Tsikyanira viroegi! “Tyarika inkantakempi pitovaire ontirika inkoshitakempi, ontirika inkisakempi, ontirika pashini tatarika oita, pinkanomaakerityo. Inkematsatakempirika pimagisantakotaero magatiro, gara pikenkiagiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ontirika patiro kutagiteri tyarika inkantakempi imuamuagevetakemparotyo kara okyatyo, okyatyo, okyatyo, kantankicha isuretanaemparo inkantaempirika: ‘Ario nokantavagetaka naro, maika gara nomatumatairo aikiro’, iroroventi viro pimagisantakotaerityo magatiro, gara pikenkiagairi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yogaegiri iritigankaneegi ikantaigiri Atinkami: —Nogoigavetakatyo yagaveavageti Tasorintsi kantankicha maika nokogaigake pogotagasanoigakenara tyara ikanta yagaveavagetira kameti ariompaniri nogotasanoiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Inianake irirori ikantaigiri: —Naro nonkantaigakempi pogotumaigakerika maani yagaveavagetira Tasorintsi ario pinkante pagaveaigaketyo pinkantaigerora oka inchato: ‘Atsi shianakempa, piate paratinkapaakera omaraaniku nia’, pagaveaigakerotyo oatakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pine viroegi intimera paniro ponampiria ikyaenkasano pokapaatsine itsamaivagetira tsamairintsiku ontirika isentakempirira pivakane, ¿matsi ario pinkantavakeri: ‘Taina, pimpirinitapaakera aka pisekatapaakempara?’ Garatyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ontityo pinkantavakeri: ‘Kotapaakena noseka, povetsikakempara pimpakovagetakenara nosekatakempara. Impo nagatanakera ario pisekatakempa viro.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Impo pagatanaera matsi ario pinkantakeri: ‘¡Tyarika noshinevagetakatyo noneakempitari pitsatagakerora nokantakempirira!’ Ganirorotyo pikantiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pinkañoigera viroegi pintsatagaigerora ikantaigakempirira Tasorintsi, garatyo pogiakoigari irishineventaigakempira. Ontityo pinkantaigake: ‘Narori tera tatakona nagaveimagete, kantankicha nantitari ironampiria notsatagantakarorira ikantakenarira.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Impogini Jeso ariompa iatanakeri Jerosarenku ikenanakera okaragetanakera Samaria ontiri Garirea. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Impo yogonketapaakara itimaigira pashini itonkivoaigavakari vesegasenari inaigake 10, kantankicha tera iraiñoniigempari onti inaigake antakona, ");
INSERT INTO mcbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ikaemavaitanaketyo: —¡Jesoo, Gotagantatsiriraa, tsarogakagavageigenakario! ");
INSERT INTO mcbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ikemaigavakerira Jeso ikantaigiri: —Piaige pokotagaigakemparira saseroroteegi. Iaiganaketyo, impo tekyaenkasano osamanitumate oga ikenaigake yovegaiganaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Impo aiño paniro ineakera yoveganaara inianake imaraenkarikatyo kara ikanti: —¡Pairo ikavintsaavagetakena Tasorintsi! ¡Mataka vegaana! Ipigaa inakera Jeso ");
INSERT INTO mcbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","yompatakaventapaakari ikantakerira: —¡Pairo pikavintsaavagetakena povegaanara! Irirori inti Samariakunirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ikanti Jeso: —¿Matsi tera irovegaigaempa maganiro? ¿Tyanityora maika itovaire? ");
INSERT INTO mcbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Panirosano ipigaara yoka terira iriro jorio inkantakerira Tasorintsi ishineventakari ikavintsaavagetakerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Impo ishonkatetanakari irirori ikantiri: —Tinaanae, piatae, pogotaketari nagaveakera novegaempira, nerotyo povegantaarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yogari pariseoegi ikantaigiri Jeso: —¿Tyatityora intsititantanakempara Tasorintsi irapatoitaigakaera impegakempara Agoveenkariegite aka kipatsiku? Ikanti irirori: —Gara tyani neimatiro maika, teranika oneenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aikiro gara tyani gaveimatatsi inkantakera: ‘Nero oka’, ontirika inkante: ‘Nero onta’, matakatari ipegaka Tasorintsi Igoveenkariegite maganiro kematsatasanoigakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Impo ishonkateiganakari irogamereegi ikantaigiri: —Impogini aganakempara pantsipereantavageigakemparira pinkogageiganaketyo iripokaera Kañotasanotakaririra Matsigenka pinkantaiganaketyo: ‘Intagametyo kantaka iripokutera’, kantankicha gatatatyo ipoki. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pashinikyatyo kantaigakempine: ‘Pokake’, ontirika inkantaigake: ‘Anta inake anta’, kantankicha garatyo piaigi pinkamosoiguterira. Inkantaigavetakempityo: ‘Tsame’, garatyo pogiaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pineaigirotari kareti tyara okantaka okantira tsarere tsarere, tera ario maani onkoneagitete, magatirotyo ontenenkagiteapinitakaro. Ario inkañotapaempa Kañotasanotakaririra Matsigenka iripokaera, maganirotyo ineasanoigavakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kantankicha oketyo iratsipereavagetake posante inkisakenkanira inkantakenkanira: ‘Tera iriro agiaigakerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ariotari okañotakari pairani aiñokyara itimaveta Noe ariotyo onkañotanakempa impogini iripokaera irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kañotari iriroegi tyarika, isekataigaka, yoviikaigaka, yagaigake tsinane, aikiro ipimantaigakero irishintoegi agunkanira, tera irogotumaige panikya impogereaigakempa. Impo niganki aganaka kutagiteri ikiantanakarira Noe tsompogi arekaku, impogini opariganake omarane inkani okimoatanake, apamankakoiganakeri maganirosanotyo ipogereaigaka ikamaigakera iokajaigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ario okañotaka aikiro pairani aiñokyara itimi Irote. Ario ikañoigaka iriroegi isekataigaka, yoviikaigaka, ipunaventavageigake posante, aikiro ipimantavageigake, ipankivageigake aikiro yovetsikavageigake pankotsi tera irogotumaige panikya impogereaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Impogini yamereanakara Irote iatakera parikoti yogivarigakero Tasorintsi tsitsi okonogakaro asopuri oponiaka enoku, otagavioigakeri maganiro Soromakunirira opogereaigakerityo kara, teratyo intimumaigae paniro. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ariotyo onkañotakempa impogini iripokaera Kañotasanotakaririra Matsigenka onti inkomutagantapaake. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tyanirika pitankitsine otishitapankoku ivanko irishigapanute garatyo ikiapanaati iragagetapanaaterora iaraki. Ontirika pashini irinake tsamairintsiku garatyo ipigapanaata ivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sureigaemparoratyo itsinanetsite Irote kameti pogoigakeniri ganiri pikañoigaro irorori. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tyanirika intagati ikogake irovetsikagetakera tatarika ikogagetakerira irirori ikiirotyo kañotagantanankicha, kantankicha yogari kogankitsirira irovetsikakerora ikogagetirira Tasorintsi, iriro pinkante inkavintsaavagetakeri, aikiro inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Maika nonkantaigakempi antari iripokaatera Kañotasanotakaririra Matsigenka, irimagaigake matsigenka piteni irinoriaigake, paniro iraganakenkani, yogari irapitene iokanakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ario onkañoigake piteni tsinane ompitaigake ontononkavageigakera, paniro aganakenkani, ogari apitene okanakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ario inkañoigake aikiro surari piteni irinaigake itsamaireku, paniro iraganakenkani, yogari irapitene iokanakenkani.” ");
INSERT INTO mcbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ikemaigavakera ikantakerira ikantaigiri: —Notinkami, ¿tyarikara kara? Ikantaigiri irirori: —Tyarika kara inoriaka igamaga ineventumatakarira samponero katsiketyo iparigashitapaakeri. Ario onkañotake impogini iripokaera Kañotasanotakaririra Matsigenka tyarika kara irinaigakera vetsikageigirorira terira onkametite katsiketyo inkomutagaigapaakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yogari Jeso ikogake irogotagaigakerira irogamereegi iriniaigakerira Tasorintsi omirinka gara iperaiga ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Itimake paniro joese teratyo impinkumateri Tasorintsi, aikiro tera tyani impinkumate. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ario otimi aikiro kara paniro ogamakotaga. Irorori omirinkatyo oatashitapinitiri joese okantakerira inkisakerira kisashitakarorira irorori. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Okyara teratyo inkogavetempa inkematsatakerora, kantankicha impogini isurematanakatyo ikanti: ‘Teratyo nompinkagevetempari Tasorintsi, aikiro teratyo tyani nompinkagevetempa, ");
INSERT INTO mcbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kantankicha atanatsitari opokashinatanara overaanatanakena, maikari maika nonkematsatakerotyo nompugamentakerora ganigeniri overaanataana nokishirokari.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Impo ikanti Atinkami: “Ariotari ikañotakerori maika yoga joese kisantatsirira, teratyo inkametivetempa, kantankicha ipugamentakerotyo ogamakotaga kameti ganiri atanatsi overaanatirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iriromparorokari Tasorintsi pairorokari impugamentaigakeri irashiegi irirori niaigiririra omirinka, ¿matsi ario gara imutakoigiri? Maikari maika tekya, ");
INSERT INTO mcbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","kantankicha nonkantaigakempi impogini iriroratyo kogumatanankitsine inkatimaterotyo shintsi impugamentaigakempira. Kantankicha antari iripokaera Kañotasanotakaririra Matsigenka, ¿ario intimaigake kematsatasanoigiririra?” ");
INSERT INTO mcbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Impogini Jeso ikantakoigakeri yogaegi ventakovageigankicharira neaigavetankicharira yavisaigakeri itovaireegi ikematsaigirira Tasorintsi ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Piteni surari iaigake ivankoku Tasorintsi iriniaigakerira. Paniro inti pariseo, yogari irapitene inti kogantaigaririra itovaireegi koriki irashi koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yogari pariseo yaratinkapaaketyo iniamampegakarira Tasorintsi ikanti: ‘Viro, Tasorintsi, noshineventakempityo kara pineakenatari tera nonkañoigempari pashini kañovageigacharira, irirompasanotyo yonta kogantiniririra koveenkari koriki. Tera nonkoshite, tera namatagumatempa, aikiro tera noneakotantavagete tsinane. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Omirinka avishira mava kutagiteri napakuaati tera nosekatumatempa intagani viro nosuretakotaka. Aikiro nopagarantimpi tatarika oita nashintaka okyapagerira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Kantankicha yogari kogantiniririra koveenkari koriki yaratinkapaaketyo anta panikyara sotsimoroku. Ipashiventaka teratyo ineventumatempa enoku, ontityo ipatosanegintavagetaka ikanti: ‘¡Viro Tasorintsi, tsarogakagena, nantitari kañovagetacharira!’ ");
INSERT INTO mcbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Maika nonkantaigakempi yogari kogantiniririra koveenkari koriki iriro pinkante ishineventaka Tasorintsi yogavisaakotakeri impo iatai ivankoku. Kantankicha yogari pariseo teratyo irogavisaakoteri, imirinkatari ventakovagetacharira impotetashivagetakempari Tasorintsi irogipashiventavagetakerira. Irirokya terira iraventakotempa irishineventakempari inkavintsaavagetakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Impogini ipokaigake pashini yamaigapaakenerira Jeso ananekiegi impatikaiigakerira igitoku. Yogari irogamereegi ineaigavakerira yamaigapaakerira ikantaviigavakeri ikantaigiri: —Maiganaeri parikoti, gara poverajaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kantankicha Jeso ikaemaigakeri ikanti: —Atsi arionenityo iripokaigakera naroku, ishineventaigaritari Tasorintsi impegakempara Igoveenkariegite kañoigaririra yogaegi ananekiegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nonkamantasanoigakempi pinkematsatasanoigakerira Tasorintsi pogiakovageigakemparira pinkañoigakemparira ananekiegi ikematsavageigirira tomintaigaririra yogiakovageigarira. Antari garika pikañoigiro maika garatyo ipegumata Tasorintsi Pigoveenkariegite ovashi gara pineimaigi pintimimoigakerira impogini irapatoitaigakerira maganiro kematsaigiririra impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Impogini ikenapaake paniro itinkami jorioegi ikantiri Jeso: —Gotagantatsirira, pairo pikametiti. Atsi kamantena tyara nonkantakempa kameti nonkantakanira nontimake. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ikantiri Jeso: —¿Tyara okantakara pikantakenara: ‘Pairo pikametiti’?, mameritari kametitasanotatsinerira, panirotari ikantara Tasorintsi ikametitira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pogotakerotari magatiro itsirinkakotanakerira Moiseshi okanti: ‘Gara piatashitiro tsinane, gara poganti, gara pikoshiti, gara pitsoeventari pitovaire, pimpinkatsaigakerira piri ontiri piniro gara pipugatsanaigari.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Irirori ikantiri: —Arioniroro nokañotari maika notsititanakero notsatagasanotanakerora notyomiakyanira ovashi maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ikemavakerira Jeso ikantiri: —Maika ontivani piatakera pimpimantagetakerora magatiropage pashintagetarira pagantakemparora koriki pimpaigakerira kogakoigankicharira, impo pimpokake pogiavagetanakenara. Impogini ariokya inkavintsaavagetakempi Tasorintsi enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kantankicha ikemutatyo ikantakerira ogatyo ikenake ikenkisureavagetanaka, intitari shintavagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yogari Jeso ineavakerira ikenkisureanakara ikanti: —¡Okomuvagetaratyo kara irogavisaakoigakenkanira shintavageigacharira impegakempara Tasorintsi Igoveenkariegite! ");
INSERT INTO mcbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¿Matsi ario iragaveake kameyo inkianakera otsempokiku kitsapi iravisakerora aikyara? Garatyo yagaveimati. Irirompasanotyo shintavagetacharira intasanotakemparorika yashintagetarira garatyo yogavisaakotagani. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ovashi ikantaigake kemaigakeririra ikantakera maika ikantaigiri: —Iroroventi ¿tyanimpatyora irogavisaakotakenkani? ");
INSERT INTO mcbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yogari Jeso ikantaigiri: —Gara tyani gavisaakotumatacha tsikyata, intaganitari Tasorintsi gaveatsi yogavisaakotantira, teranika tatoita komutapitsatumatemparine irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Impo inianake Perero ikantiri: —Notinkami, naroegi nokaiganakero magatiro nashintaigavetarira nogiavageiganakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ikanti Jeso: —Maika nonkamantasanoigakempi, tyanirika okanakerone ivanko ontirika itsinanetsite intirika irirentiegi, iritsiroegi, iriri, iriniro intirika itomiegi, iriatakera inkamantaigakerira pashini tyara inkantaigakempa kameti irogavisaakoigakerira Tasorintsi impegakempara Igoveenkariegite ");
INSERT INTO mcbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","impakenkani pashini aka kipatsiku pairotyo avisavagetakero yashintagevetakarira, impogini inkantakani intimake gara ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Impogini ikaemaigakeri irogamereegi iriroku ikantaigiri: —Maika aiganakai Jerosarenku ontsatagagetanakempara magatiro itsirinkaiganakerira kamantantaigatsirira pairani itsirinkakoigakerira Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iragakagantakenkanitari iramanakenkanira inaigakera terira iriroegi jorioegi isamatsanatakenkanira, intsoenkanatakenkanira, intoatoanatakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Impo impasapasatakenkani ovashi irogakenkani, kantankicha omavatanakempara kutagiteri iranianaetyo. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kantankicha iriroegi teratyo irogotumaige tatoita iniakotake teranika inkemaigavakerinika. Tyampatyo inkantaigakempa irogoigakera, okomutapitsaigakaritari. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Panikyara irogonketapaakempa Jeso Jerikoku, ario ipitake kara onampinapokiku paniro terira inee inevitantavagetakera koriki. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ikemaigavakerira yavisaiganakera tovaini matsigenkaegi ikanti: —¿Tatatyo oitara? ");
INSERT INTO mcbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ikamantunkani ikantagani inti pokapaatsi Jeso Nasarekunirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ikaemamatanaketyo: —¡Jesoo, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yogaegiri ivaigapaakeririra Jeso ikantaigiri: —¡Atsi kemisantenityo! Kantankicha irirori teratyo inkeme, ariompatyo ikaemasanotanakeri: —¡Viro, Iyashikitanakerira Iravi, tsarogakagavagetenakario! ");
INSERT INTO mcbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yogari Jeso asatyo yaratinkapaake ikantake iramakenkanira. Impo yamunkanira aiñoni ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tata pikogake? Inianake irirori ikanti: —Notinkami, onti nokogake noneanaera. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ikantiri Jeso: —¡Iroroventi maika neanake!, pogotaketari nagaveakera noneakagakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Irorotyo ikantakerira ogatyo ikenake ineanai ovashi iatake yogiatanakerira, ishineventakarityo Tasorintsi kara ikanti: —¡Pairo ikavintsaavagetakena Tasorintsi! Ario ikañoigaka maganiro neaigakeririra ishineventaiganakarityo Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Impogini yogonketaka Jeso Jerikoku ikenanake apatotakara pankotsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ario itimi kara paniro sintavagetacharira ipaita Sakeo. Inti itinkamiegi kogantaigaririra itovaireegi koriki irashi koveenkari. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Irirori ikemakotavakerira Jeso ikogaketyo ineakerira, kantankicha tyampa inkantakempa ineakerira, yapatoventaigakaritari pashini tovaini itikaigakeri, intitari icharianirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ishigamatanakatyo antakona anta tyarikara inkenanakera Jeso yatagumatanake inchatoku kameti ineavakeriniri. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Impo yagapaakerora Jeso inakera ineventa enoku ikantiri: —Sakeo, tainapagenityo guitanake, virotari nomagimotake. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yaguimatanaketyo ishinetanaka itentanakari Jeso ivankoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ineaigavakerira maganiro iatakera iniashinaiganakarityo ikantaigi: —Tyarikatyo ikantakara Jeso atake irimagakera ivankoku kañovagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Antari inaigakera ivankoku yaratinkanake Sakeo ikantiri Atinkami: —Atsi geka, Notinkami. Magatiro nashintagetakarira naro nompagarantaigakeri terira irashintumaigempa. Tyanirika namatavitake novashigakari nokogantakarira impo nagagarantavake naro, maikari maika nogipigaigaeneri, kantankicha pairo nogavisakero nompaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yogari Jeso ikantiri: —Maika yogavisaakoigunkani timantaigarorira oka pankotsi ikañotanakaritari Averan yashikitakeririra, ariotari ikañotari irirori ikematsatira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Irorotari ipokashitake Kañotasanotakaririra Matsigenka inkogaaterira pegaigankicharira irogavisaakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yogari patoventaigakaririra Jeso ikemisantaigakerira iniakerira Sakeo, yogotaketari onti iriatanakera Jerosarenku ineaigiri irorori iatashitanake impegakempara igoveenkariegite. Kantankicha irirori yogotaketyo, ");
INSERT INTO mcbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","impo ikantakotaka ikanti: “Itimake paniro shintavagetacharira impo iavagetake samani kara parikoti pashiniku kipatsi kameti impegakagakenkanira koveenkari, impogini impigaera itimira ovashi impegapaempa igoveenkariegite itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antari panikyara iriatanake ikaemaiganakeri 10 iromperaneegi ipageiganakeri paniropage paniro korikimenta yovetsikantunkanirira kori impo ikantaiganakeri: ‘Neri yoka koriki nompaiganakempirira pagantaigakemparira pashini, tsikyata pineaigake viroegi tyara pinkantaigakeri pogitovaigaigakerira, impo nompokaera noneaigapaakempi akatovainirika pagaigake paniropage.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kantankicha yogari itovaireegi teratyo inkogaigeri ikisaigakerityo kara itigankaigaketyo inkantaigakiterira pegakagakerinerira koveenkari inkanteri: ‘Tera nonkogaige impegakempara yoga nogoveenkariegite.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kantankicha ariompatyo ipegakaganunkaniri koveenkari, impo ipigaa itimira. Impogini yogonketaara ikaemakagantaigapaakeri iromperaneegi yogimoiganakerira koriki ineaigakerira akatovainirika yagageigake paniropage. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Impo ipokapaake paniro ikantiri: ‘Yogari pigorikite pipanakenarira paniro inavetaka, maika nagake pashini inake 10.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ikantiri irirori: ‘Kametitake, pitsatagakerotari nokantakempirira. Maika nompegakagakempi itinkamiegi timaigatsirira 10 apatogetara pankotsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Impo ikenapaake pashini ikantapaakeri: ‘Yogari pigorikite pipanakenarira paniro inavetaka, maika nagake pashini inake 5.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ario ikañotakeri irirori ikantiri: ‘Maika viro nompegakagakempi itinkamiegi timaigatsirira 5 apatogetara pankotsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kantankicha irapitene ikenavetapaaka ikantapairi: ‘Neri yoka pigorikite. Noponatairi pañoirontsiku nonegintetairi, ");
INSERT INTO mcbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","nopinkakempitari noneimpitari vinti kisantatsirira, pagashigematari koriki kogapage tera tatoita pantumate, aikiro pagutantagemati terira viro shintemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Inianake irirori ikantiri: ‘Virori, tera pinkametite. Tsikyatatyo pikañotagantaka viro pikantakera maika. Tyara okantakara tera ario pamanakeri nogorikite pimpakerira pinatantavagetatsirira irampinatantakerira iragantaemparira pashini, impo pimpavaenarira nopigaara maika. Irorotari pineanara nantira kisantatsirira, nagashigematarira koriki kogapage tera tatoita nantumate, aikiro nagutantagematira terira naro shintemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Impo ikantaigiri naigankitsirira anta: ‘Gapitsaigeri yoga nogorikite pimpaigakerira gankitsirira 10.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kantankicha iriroegi ikantaigiri: ‘Nogoveenkarite, aiñotari irashi 10.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Inianake irirori ikanti: ‘Maika nonkantasanoigakempi tyanirika shintasanotankicharira pairotyo impasanotakenkani, kantankicha yogari terira irashintavagetempa irogapuntarenkapitsatakenkanityo yashintagevetakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maikari maika yogaegiri kisaigakenarira terira inkogaige nompegakempara igoveenkariegite maigakeri aka pogaigakerira.’ ” ");
INSERT INTO mcbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Impogini yagatanakera Jeso iniavagetakera imatanairo aikiro iatanakera Jerosarenku, iketyo ivatanankitsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Impo panikyara irogonkeigapaempa Vetipajeku ontiri Vetaniaku choenitakotakarorira otishi Orivoshi, itigankaigake piteni irogamereegi ikantaigavakeri: ");
INSERT INTO mcbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Piaige anta choeni itimageigira pineaigapaakeri kara paniro ashino akamotiakyanirira tsatakotaka, tekyaenka irishigakotantumatenkani. Pintsaakoiganakeri pamaigakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tyanirika kantaigakempine: ‘¿Antari gara pitsaakoigiri? ¿Matsi tyara pinkantaigakeri?’ viroegi pinkantaigeri: ‘Inti kogakotakari Atinkami.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Impo iaigake ineaigapaakeri tsatakotaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iroro itsaakoigavetanakarira ikantaigiri shintaririra: —¿Antari gara pitsaakoigiri? ¿Matsi tyara pinkantaigakeri? ");
INSERT INTO mcbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iriroegi ikantaigi: —Intitari kogakotakari Atinkami. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Impo yagaiganakeri yamaiganakeneri Jeso ipashimititsaigakeneri imanchakiegiku kameti impitakeniri. Impo yogatsonkuigakeri yovirinitaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Impo ishigakotanaka iatanake. Yogaegiri giaiganakeririra ishitavokitashitantaigavakeneri imanchakiegi avotsiku ikenantanakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Antari ochoenitapaakara anonkakara otishiku Orivoshi maganirosanotyo giaiganakeririra ishinevageiganakatyo kara ikaemageigamatityo eee eee eee, ishineventaigakarira Tasorintsi ineaigakerira yovetsikagematityo Jeso posante terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ikantaigi: —¡Pairo ikavintsaavagetakeri Tasorintsi yoga itigankakerira impegakempara Agoveenkariegite! ¡Pairo ikametiti Tasorintsi timatsirira enoku, matakatari itigankakeri Gavisaakoigakaenerira! ");
INSERT INTO mcbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Impo ikonogagarantaigaka pariseoegi naigankitsirira kara ikantaigiri Jeso: —Gotagantatsirira, kantaigerinityo inkemisantaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kantankicha Jeso ikantaigiri: —Arionetyo inkañoigake. Nonkantaigakempi inkemisantaigera iriroegi irorokyatyo kaemavaitanankitsine mapu. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Impo yagavagetanakerora aiñoni ineventapaakarora Jerosaren iragatsikanaigamatanakarityo timantaigarorira ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“¡Maikari maika aiñokyanara nonake aka pogotumaigakemetyo tyara pinkantaigakempara kameti irishineigakempiniri Tasorintsi! Kantankicha maika garatyo pagaveimaigi pogotumaigera. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aganakempatari impogini pantsipereavageigakera, iripokashiigakempitari kisaigakempinerira ironkuatakoigapaakempi intantakoigapaakempira ");
INSERT INTO mcbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","irogaigakempira maganiro viroegi impogereaigakempira. Irogimamerinkasanoigakerotyo magatiro mapu ovetsikantunkanirira pitimantaigarira ontaikavagetanakempatyo savi, agavetakatari ipokantakitarira pogiaigavetakarira irogavisaakoigakempira, kantankicha viroegi tera pogoigavakeri.” ");
INSERT INTO mcbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Impogini iatake Jeso ivankoku Tasorintsi ikiavetapaaka ineaigapaakeri pimantavageigatsirira intiegiri punaventavageigatsirira, yoneagaigapaakari ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Okantake Itsirinkakagantakerira Tasorintsi okanti: ‘Ogari novanko onti ashi iripokapiniigera iriniaigakenara’, kantankicha viroegi onti pipegakagaiganakaro ipimantapiniigira matavitantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Impogini omirinkatyo kutagiteri yogotagantavageti Jeso ivankoku Tasorintsi. Kantankicha yogaegiri itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri aikiro itinkamiegi jorioegi ikogaigavetaka ineaigakera tyarika inkantaigakeri irogakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kantankicha teratyo iragaveaige tyampatyo inkantaigakeri, maganirotari ishineventaigakari ikemisantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Impogini yogotagantavagetake Jeso ivankoku Tasorintsi ikamantaigakerira maganiro tyara ikanta Tasorintsi yogavisaakotantira. Impo ikenaigapaake itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi itentaigapaakari itinkamiegi jorioegi ikantaigapaakeri: ");
INSERT INTO mcbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Atsi kamantaigena. ¿Tyani kantakempira pinkañotakerora maika poneagaigaemparira pimantavageigatsirira? ¿Tyanimpatyora tigankakempira? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yogari Jeso ikantaigiri: —Maikari maika narokya kogakotagantaigakempine. Atsi kamantaigena, ");
INSERT INTO mcbNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿tyani kantakeri Joan irogiviatantavagetakera? ¿Irirorika kantakeri Tasorintsi intirika kantaigakeri matsigenkaegi? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iroro ikemaigavakera iniavakagaigamatanakatyo ikantavakagaiganakara: “¿Tyarikatyo ankantaigakeri? Ankantaigavetempari inti kantakeri Tasorintsi, irirori inkantaigakaetyo: ‘Iroroventi ¿tyara okantakara tera pinkematsaigeri?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ariokya ankantaigavetempari inti kantaigakeri matsigenkaegi, impitankaigakaetyo maganiro patoigankicharira, maganirotari ikantaigake inti kantakeri Tasorintsi inkamantantavagetakera.” ");
INSERT INTO mcbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nerotyo ikantantaigakaririra: —Nirorotyo, tyanirorokari kantakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Impo irirori ikantaigiri: —Iroroventi ariotyo nonkañotakempa naro, garatyo nokamantaigimpi tyani tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ipogini itsititanakero Jeso iniaiganakerira maganiro, kantankicha onti ikantakotantake ikantaigiri: “Itimake paniro matsigenka ipankishiatake ova itsotenkantakaro patuitiro itsamaire, onti yogoshiatake. Impogini ikaemaigake pashini intsamaitakoigakenerira. Antari ontimanakerika impagarantaigaeri irirori. Impo iavagetake samani itimuntevagetakera anta. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Impogini aganaara irakantarira ova itigankavetakari paniro iromperane ineviigaaterimera impagarantaigaerira irirori, kantankicha iriroegi ipasapasaigavakeri itigankaigairi kogapage, tera impumaigavakeri maani. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Impo yogari shintarorira itigankai pashini iromperane. Ario ikañoigakeri irirori ipasapasaigavakeri iposanteigakeri itigankaigairi kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Impo itigankutaatyo aikiro pashini kantankicha ipasaigavakerityo igitoku itimporokaitakeri iokaigakitiri parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Impogini ikantutatyo shintarorira igipatsite ikanti: ‘¿Tyarikatyo nonkantaigakerira maika? Atsi impatyo iriro nontigankake notomi notasanotarira, irirorakari impinkatsaigake.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kantankicha iriroegi irorotyo ineaigavakerira ikenapaakera iniavakagaigamatanakatyo ikantaiganakera: ‘Neri yonta shintakemparonerira magatiro impogini inkamanaera iriri. Tsamekario agaigakerira kameti aroeginiri shintasanoigakemparone.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Impo yagaigamatanakerityo yamaiganakerira parikoti yogaigakerira. “Maika ¿tyara pinkantaige viroegi? ¿Tyarika inkantaigakeri shintarorira igipatsite? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ontityo iriatashiigakiteri irogaigakiterira, pashinikyatyo inkaemaigae impugakagaigaerira.” Ikemaigavakerira ikantakera ikantaigutarityo: —¡Ejee, garatyo! ");
INSERT INTO mcbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kantankicha Jeso ipampogiaigakeri ikanti: —Iroroventi, ¿tatatyo okantakotakera Itsirinkakagantakerira Tasorintsi okantakera?: ‘Ogari mapu terira irishineventaigavetemparo vetsikaigakerorira pankotsi yogari Tasorintsi ishineventakaro ipegakagakaro okusotantakarira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nantitari oka mapu. Tyanirika kantankitsine tera iriro tigankenane Tasorintsi tyampatyo inkantakempa irogavisaakotakenkanira. Inkantakanirika inkañotake maika nonkisashitasanotakempari impogini inkisashiigakemparira Tasorintsi maganiro terira inkematsaigeri garatyo yogavisaakotumatagani. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yogaegiri itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi irorotyo ikemaigavakerira ikantakera Jeso ikisaigamatanakatyo ikogaigavetakatyo iragakagantaigakerimera, ikemaigavakeritari inti ikantakoigake, kantankicha ipinkaigairi patoigankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Impogini itigankaigake pashini iriaigakera impegamampegaiganakempara arisanorika ikogaigake irogoigakera, inkogakotagantaigakiterira Jeso ineaigakerira tyarikara inkantera impo inkantumatakera tatarika oita iroroniri intamampegaigakempa iramaiganakenerira inampina Sesa inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Irorotari ikantantaigakaririra: —Gotagantatsirira, nogoigake viro tera pamatagumatempa, pogotagantavagetira tera tyani pagamaempa, tera pinkante: ‘Tsikyanira ikemaigikari pashini.’ Pogotagantira katinka pogagetiro pikamantaigakerira tyara inkantaigakempa inkematsatasanoigakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pogotirotari ikantirira koveenkari Sesa ikantira: ‘Maganirosanotyo jorioegi impaigakena koriki.’ Maika ¿tyara pinkante viro? ¿Kametitake nompaigakerira ontirika tera onkametite? ¿Ario nompaigakeri ontirika gara nopaigiri? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kantankicha Jeso yogotavaketyo tera kametikya inkantaigeri onti ishinetamampegaigakari kogapage, nerotyo ikantaigutarityo: —¿Tyara okantakara pikañovintsaigakenara maika? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Atsi maigakenanityo pamentaniro koriki noneakerira. Iriroegi yamaigakeneri, impo ikantaigiri: —¿Tyani yoka itsirinkakotunkanirira? ¿Tyani shintaro ivairo? Ikantaigiri: —Inti koveenkari Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Impo ikanti irirori: —Iroroventi intitari tsirinkakotankicha Sesa paigerityo irirori kameti pintsatagaigakeroniri magatiro ikantagetakerira, kantankicha ariotyo pinkañotagaigakempari Tasorintsi aikiro pinkematsatasanoigakerira pintsatagaigakerora magatiro ikantagetakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Teratyo iragaveimaige iriroegi iriniakagaigakerira terira onkatinkate inkemaigakerira maganiro patoventaigakaririra. Omirinka iniakera katinkatyo yogakero, nerotyo yogavageiganakera kavako kogakotagantaigakeririra ineaigakeritari yogovageti, ovashi ikemisantaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Impogini irirokya aigankitsi saroseoegi inkamosoiguterira Jeso. Iriroegi inti kantaigatsirira gara yaniaiganai igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ikantaigapaakeri: —Gotagantatsirira, yogari Moiseshi itsirinkanake pairani ikanti: ‘Intimakerika matsigenka terira intomintempa impo inkamanakerika iokanakero itsinanetsite, aiñorika irirenti irirokya gaerone intomintagaemparoniri kañomataka irironirikatyo tomintari kamankitsirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maika nokogaigavetaka nonkantaigakempira. Pairani itimake paniro notovaire itomintaka 7. Yogari itsitiki yagavetaka tsinane, kantankicha niganki ikamanake tera intomintaganakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Impo irirokya gavetaaro irapitene giatiririra. Ario ikañotaka irirori ikamanake tera intomintaganakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ario ikañovetaka irapitene nigankinirira. Ariompa ipogereanakari maganiro yagaigavetakarora tera intomintagaiganakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Impo okamamatityo irorori. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Maika atsi kantaigena, antari impogini iraniaiganaerika maganiro igamaga, ¿tyanirikatyo gasanotaerone?, maganirotari yagaigavetakaro. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Irirori ikantaigiri: —Maikari maika aka yagaigi tsinane, ario okañotaka tsinane agaigi surari. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kantankicha yogaegiri yogavisaakoigunkanirira iraniaiganaera impogini iriaigakera itimira Tasorintsi garatyo yagumaigai tsinane, aikiro tsinane garatyo opimantumataagani ojimentaigaempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gatanika ikamumaigai, ataketari yoganiaigaagani. Onti inkañoiganakempari isaankariite Tasorintsi, aikiro inkañoiganakempari Tasorintsi terira ineimagetero igamane, matakatari ipegaigakeri itomiegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kañotari itsirinkanakerira Moiseshi pairani itsirinkakotakerora iniakerira Tasorintsi tankoku opoamatakera ikanti: ‘Nanti Tasorintsisanorira Itinkami Averan, Isaako intiri aikiro Jakovo.’ Irorotari ogotantunkanirira iraniaiganaera igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¿Matsi tyara inkantakempara igamaga impegakerira Itinkami? Garatyo yagaveimati. Intaganitari pegaigiri Itinkami niaigankitsirira. Aroegi aneaigavetakari kamake, kantankicha Tasorintsi irirori ineakeri tera inkame. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Impogini ikantaigutarityo gotagantaigirorira itsirinkakotanakerira Moiseshi ikantaigiri: —Gotagantatsirira, pikantasanotakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ovashi yapakuaiganakeri tenige inkogakotagantanaigaeri pashini, ineaigakeritari tera iragaveaigeri irogemisantaigerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Impogini ikanti Jeso: —Viroegi pikantaigake yogari Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite inti iyashikitanakerira Iravi. ¿Tyara okantakara pikantaigakera maika? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Irirotari kantankitsi Iravi pairani itsirinkakera isankevantiteku paitacharira Saremo ikanti: ‘Yogari Tasorintsi ikantakeri Notinkami: Pirinite nonampinaku nakosanoriraku ");
INSERT INTO mcbNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pintentakenara kigonkero nagaveaigakerira maganiro kisashiigakempirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yogari Iravi irorotari ikantakerira: ‘Notinkami’, ¿tyara inkantakempara iyashikitakerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maganiro ikemisantaigakeri impo irirori ikantaigiri irogamereegi: ");
INSERT INTO mcbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tsikyanira pogiatakoigirikari gotagantaigirorira itsirinkakotanakerira Moiseshi, yogaguvintsaigarotari manchakintsi ariotsantsamagopagerikatyo kara kameti ineakagantaigakempaniri. Aikiro iatapiniigira anta opimantagetaganira arakintsipage ontiri ogagetaganirira ikogaigake iriniaigavakenkanira inkañotagaigakenkanira iniaganira itinkamipage. Ario okañotaka aikiro iaigira pankotsiku yapatoitantaigarira ikogaigi iroviriniigakenkanira ipiriniigira tinkamiigatsirira. Ario ikañoigiro aikiro yapatovageigara isekataigakempara onti ikogaigi intentaigakemparira kaemantankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aikiro yamatavinaigakero ogamakotagapage itsonkatapitsageiganakerora ashintageigarira. Aikiro ineakagantaigakara akaenkinityo iniaiganakeri Tasorintsi teratyo aiñokya iragataige. Iriroegi pairotyo iravisaigake inkisashivageigakenkanira impogini.” ");
INSERT INTO mcbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Antari inakera Jeso kara ivankoku Tasorintsi onti ipitake onakera yoyagantaganirira koriki ipunkanirira Tasorintsi. Irirori ipampogiaigakeri shintavageigacharira yoyagaigakera igorikite. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Impo ineiro paniro ogamakotaga terira ashintumagetempa oyagake irorori pimentyakitenisano koriki. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Impo inianake ikanti: —Maika nonkamantasanoigakempi ogari oga ogamakotaga terira ashintumagetempa ineakero Tasorintsi oyagake tovaini avisaigakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yogari iriroegi intitari yoyagaigake aiñokyarira inai, kantankicha irorori onti ogapuntareakeri maganiro ashintakarira agantaemparimera oseka. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ikonogagarantaigaka iniaventaigakero ivanko Tasorintsi ineaigakerotari onkametivageteratyo kara. Ovetsikantunkani mapu ogametirepagetyo, aikiro ogantagetunkani pashini posantepage ogametirepagetyo kara ipagetunkanirira Tasorintsi. Impo inianake Jeso ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Impoginityo aganakempa ogashiriagetakenkanira magatiro oga pineaiganakerira maika garatyo otimumatai patiro mapu vikotaachanerira, magatirosanotyo ogashiriagetakenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Impogini ikantaigiri: —Gotagantatsirira, ¿tyati ogashiriantagetakenkani? ¿Tatoita nogotantaigavakemparo? ");
INSERT INTO mcbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ikanti Jeso: “Tsikyanira yamatavinaigimpikari, iripokaigaketari tovaini matsigenkaegi kantaigankitsinerira: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite. Matakana pokakena.’ Kantankicha viroegi garatyo pikematsaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Impogini pinkemakoigakeri pashini iromanatavakagaigakempara. Pashinikya isariaiganakempari igoveenkariegite impugakagaigaerira pashini. Kantankicha gara pitsarogaigi. Ariotari onkañotanakempari maika, kantankicha gatatatyo aga ontsonkagetanaempara magatiro kipatsi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Impo ikantaigakeri aikiro: “Yogari timageigatsirira pashinipageku kipatsi iriatashiigakeri timageigatsirira parikotipageku iromanatavakagaigakempara. Ario inkañoigake koveenkariegi intimagarantaigake intigankaigakeri isoraroegite iriatashiigakerira pashini koveenkari iromanatavakagaigakempara irogavakagaigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ontininkagematanakempatyo kara tyarika. Ontsonkagematanakempatyo sekatsipage antsipereavagetanakenkanityo tasegagantsi. Onkoneaenkagematanaketyo mantsigarintsi omposanteenkagematanakempatyo kara ontsotenkagiteanakemparora magatiro. Antari enoku omposantegematanakempatyo kara ogoveenkarepagetyo onake ogotantavakenkanirira panikya ontsonkagetanaempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Kantankicha gatata okañota maika, viketyoegityo inkisaiganake iratsipereakagaigakempira. Iragaiganakempi iramaiganakempira pankotsipageku yapatoitantaigarira pitovaireegi inkisaigakempira irashitakotagantaigakempira. Aikiro iramaiganakempi inaigakera koveenkaripage intiegiri inampinaegi Sesa ineaigakempira pikematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inkañoigakempirika maika iramaiganakempira tyarika kara asatyo pinkenkitsatakovageigakena naro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kantankicha gara pisureigaro pinkantaigakera: ‘¿Tyarikatyo nonkante nompugamentanaempara impogini iramaiganakenarika inkisaigakenara?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Narotari suretagaigakempine kameti pogoigakeniri tyara pinkantaige ganiri yagaveaigimpi impugaiganakempira pikantaigakeririra, ontityo inkisashiigakempi kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kantankicha viroegi pinkonogagarantaigakempa intsoeventaiganakempityo kara, irimaiganakempatyo tomintaigimpirira, pirentiegi, piitaneegi intiegiri piamigoegite irogakagantaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Maganirosanotyo inkisaviiganakempiro pikematsaigakenara, ");
INSERT INTO mcbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kantankicha viroegi pimirinkaegityo piaigake itimira Tasorintsi pinkantakani pintimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pantsipereakovageigakemparika magatiro oka gara papakuimaigi pikematsaigakenara, ario pinkante piaigake enoku itimira Tasorintsi gara pineaigairo pigamane. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Impogini pineaigavakerorika Jerosaren ironkuatakoigapaakemparora soraroegi iroro pogotantaigavakempa panikya ontsonkagetanakempa magatiro pankotsipage irogashiriageigakerotari. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yogaegiri naigankitsinerira Joreaku irishigaiganaketyo otishipageku. Yogaegiri naigankitsinerira Jerosarenku irishigaigapanutetyo parikoti. Ario ikañoigake naigankitsinerira tsamairintsiku tsikyanira iaigapanaatikari ivankoku, patirotyo irogaiganakero irishigaiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aganakempatari inkisashitantaigakemparirira Tasorintsi ontsataganakempara Itsirinkakagantakerira pairani. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Maikaniroro antsipereavageige tsinaneegi kamonkiigankitsinerira ontiri tsomitagaigankitsinerira, pairotari avisaigake antsipereasanovageigakera oshigaiganakera, iratsipereavageigaketari maganiro timaigatsirira aka inkisashiigakenkanira, tyarika! ");
INSERT INTO mcbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Inkonogagarantaigakempa irogageigakenkani kara tyarikara yomanatavakagaigakara. Pashini iramageigamatanakenkanityo parikotipageku kara. Iriroegikya terira iriroegi jorioegi poniaigankichanerira parikoti imposantenaiganakerotyo Jerosaren kigonkero agavagetanakempara inkantaera Tasorintsi: ‘Maika intagati.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“Impogini panikyara iripokapae Kañotasanotakaririra Matsigenka, intsivakanake poreatsiri intiri aikiro kashiri. Yogari impokiropage irashiriagetanakempa, ganigetari ikusotai. Maganirosanotyo timaigatsirira aka kipatsiku ogatyo inkenaigake intsarogavageiganakera kara inkemaigavakerora ompoimaatanakera omaraani nia onkantagematetyo ovore jiriririri togn. Irovankinavageiganakempatyo kara inkantaiganakera: ‘¡Maikaniroro tyampatyo aigake!’ Pairotyo intsarogavageiganake agapiniigakerityo itsarone impegapiniigakempatyo kara isuretakoiganakemparora tyarika onkantanakempara impogini. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Impogini ineavakenkani Kañotasanotakaririra Matsigenka iripokapaakera inkenapaakera menkoriku inkoveenkavagetapaakera, aikiro iragaveavagetapaakera iravisaigakerityo maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Antari pineaigavakerora onkañogetanakempara maika pishineiganakempara, panikyatari irogavisaakoigakempi Tasorintsi patsipereavageigakera.” ");
INSERT INTO mcbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Impogini ikañotagakaro igera ikanti: “Pineaigirora igera ontirika pashini inchato ");
INSERT INTO mcbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","otimanaira oshi iroro pogotantaigavaaro panikya osariganae. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ariotyo onkañotakempa impogini pineaigavakerorika onkañotanakempara nokamantaigakempirira maika iroro pogotantaigavakempa panikyasano impegakempa Tasorintsi Igoveenkariegite maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Arisanotyo nonkantaigakempi magatirotyo oka nokantaigakempirira maika ontsatagagetanakempatyo tekyaenkara pimpogereaigempa viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ogari inkite ontiri kipatsi ontsonkagetanaempa, kantankicha ogari nokantagetakerira garatyo okantatigumata, ontityo ontsatagagetanakempa magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Viroegi tsikyanira pipiriniventaigirokari tatarika oita posantepage terira onkametite ontirika pishinkivageigakempa garira ontirika povankinaventavageigakempa posantepage. Pinkañoiganakemparika maika gara pagaveaigi pisuretakoigakemparira Kañotasanotakaririra Matsigenka iripokaera, impo onti inkomutagaigapaempi. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ontitari okañotakaro ogashivagetaganira pine yoga tatarika iita yogashitunkani tera ario irogote ariorakari onake anta. Onti ikenagevetaka kogapage impo katsiketyo ipaagi togn agiri oshitikiri tyampa inkantanaempa. Ariotari onkañotanakempari impogini iripokaera Kañotasanotakaririra Matsigenka, katsiketyotari iripokapaake garatyo yogotumaigi maganiro timaigatsirira aka kipatsiku, impo tyampatyo inkantaige. ");
INSERT INTO mcbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kantankicha viroegi pinkantakanira pogiaigavaeri, aikiro pinkantakanira piniaigakeri Tasorintsi kameti ganiri pineaigiro magatiro oka nokamantaiganakempirira maika, aikiro kametikyaniri ineaigapaakempi Kañotasanotakaririra Matsigenka iripokapaakera.” ");
INSERT INTO mcbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Ario ikañotakero Jeso maika omirinkatyo kutagiteri yogotagantavageti ivankoku Tasorintsi. Omirinka tsitekyamani ipokageigamatityo maganiro inkemisantaigakerira inkenkitsavagetakera. Antari tsitenigetiku irirori onti iatapiniti otishiku Orivoshi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Impogini panikyara aganakempa vieseta ogantaganirira pan terira onkonogempa opoegantarira okantaganirira Pasekoa, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","yogari itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi ariompatyo isariaigavetanakariri tyarika inkantaigakeri iragakagantaigakerira Jeso irogakagantaigakerira, kantankicha tyampatyo inkantaigakeri, ipinkaigakeritari maganiro patoventaigaririra. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Impogini yogari Satanashi ipokashimatapaakerityo itinkamitapaakarira paniro irogamere Jeso paitacharira Jorashi Ishikariote. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ovashi iatake inkamosoiguterira itinkamiegi saseroroteegi intiegiri itinkamiegi sentaigirorira ivanko Tasorintsi. Impo itentaigakari iniavakagaigakara iniaventaigakerira Jeso tyara inkantakerira Jorashi iragakagantaigakenerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ikemaigavakerira ishinevageigamatanakatyo kara ikantaigakeri impaigakerira koriki. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Irirori ishinetanaka ovashi ikoganake tyarika inkantakeri iragakagantaigakenerira panirora irapuntakempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Impo aganaka vieseta ogantaganirira pan terira onkonogempa opoegantarira, aikiro onti yovetisantaganirira ovisha yogaganira osuretakotaaganira Pasekoa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yogari Jeso itigankakeri Perero intiri Joan ikantaigavakeri: —Piaige povetsikaigavakera magatiro kameti asekataigakempaniri paita. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ikantaigiri iriroegi: —¿Tyara kara novetsikaigake? ");
INSERT INTO mcbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ikanti Jeso: —Piaige Jerosarenku impo pogonkeigapaakemparika pineaigapaake paniro surari iramakotapaake iniate, iriro pogiaiganake. Tyarika inkianake kara ario pinkiaiganake viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pinkantaigapaakeri shintarorira ivanko: ‘Yogari Gotagantatsirira ikantake: ¿Tyara kara nosekataigakempa paita nontentaigakemparira nogamereegi?’ ");
INSERT INTO mcbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Irirori intentaiganakempi omenkotakara enoku iokotagaigakempiro otantakara arioegiterika, mataka vetsikagetaka magatiro. Ario kara povetsikageigakero magatiro asekataigakempara paita. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Impo iaigake ineaigapaakero magatiro ikantaigavakeririra Jeso inkaara ario okañotaka maika. Ario kara yovetsikavageigake isekataigakempara paita. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Impo ochapinienkatanakera ipokake Jeso itentaigakari iritigankaneegi ipitaigapaake mesaku isekataigakara. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Impo ikanti Jeso: —Maika agamatatyo oka Pasekoa nokogasanotantakarira nontentaigakempira nosekatagaiganaempira tekyara agempa nantsipereavagetakera nonkamakera, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","gatanika noneimatairo nosekataempara aikiro Pasekoaku kigonkero irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite ovashi ontsataganakempa magatiro okantakotakerira Pasekoa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Impo osamanitanakera inoshikakotakero vino iniakeri Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka vino.” Impo ipakoigakeri irogamereegi ikantaigiri: —Nero oka paagavakagaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Maika nonkantaigakempi gara noviikumataaro vino kigonkero irapatoitaigakerira Tasorintsi maganiro kematsaigiririra impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Impo osamanitanaira inoshikakero pan irorori yapagotakero iniairi aikiro Tasorintsi ikanti: “Apa, noshineventakempi pipakenarora oka pan.” Impo ikotagakero ipaigakerira irogamereegi ikantaigiri: —Okari oka pan kañomataka ontinirikatyo novatsa, nonkamaventaigakempitari kameti pavisaakoigaeniri viroegi. Nero gaigemparo. Omirinkara pinkañoigempa maika pisekataigempara pisuretakoigaenara naro. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Impo ario ikañotakero apitakotene vino yagataiganakera isekataigakara inoshikakotakero ikantaigiri: —Okari oka vino kañomataka ontinirikatyo noriraa ovoatanakera nonkamaventaigakerira maganiro matsigenkaegi, ikantaketari Tasorintsi maika onti irogavisaakotantaigakempari noriraa maganiro kematsaigakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yogari gakagantakenanerira aiño maika aka itentakena mesaku isekatakotakena. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ontitari ontsataganakempara ikantakerira Tasorintsi pairani iniakotakerira Kañotasanotakaririra Matsigenka, kantankicha ¡maikaniroro iratsipereavagetake yoga gakagantakenanerira! ");
INSERT INTO mcbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nerotyo ikantavakagantaiganakarira maganiro: “¿Tyanirikatyo gakagantakerine?” ");
INSERT INTO mcbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Impo itsitiigamatanakerotyo iniavakagaiganakara ikantavakagaiganakara tyanirika pairorira yavisaigakeri itovaireegi irorokyatyo ikantaigi, irorokyatyo ikantaigi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kantankicha Jeso ikantaigiri: “Yogari igoveenkariegite terira iriroegi jorioegi onti ipotetashivageigari itovaireegi, kantankicha ikogaigake inkantaigakenkanira kavintsaantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kantankicha viroegi gara ario pikañoigiro maika. Yogari visaigakeririra itovaireegi tsikyatatyo inkañotagakempa terira iravisantumate. Ario inkañotake peratantacharira inkañotagakempatyo nampiriantsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Matsi ¿tyanimpatyora visantatsirira? ¿Iriro yonta pirinitatsirira mesaku isekatakempara intirika nampiriantsi pakovagetakeririra iseka? Intityo pirinitatsirira mesaku. Kantankicha naro maika nopokakera aka nokañovagetakarityo nampiriantsi, irorotari nopokashitake nonkavintsajaigutempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Maika viroegi pikantakani pitentavageigakena natsipereavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irorotari maika nonkantantaigakempirira kañotari naro ikantakenara Apa impogini impegakagakena Igoveenkariegite maganiro kematsaigakenanerira, ario nonkañotakempa naro maika nonkantaigakempi viroegi impogini nompegakagaigakempi koveenkariegi, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kameti pintentaigakenaniri nompegakempara Igoveenkariegite kematsaiganarira pimpirinitaigakera nomesaneku pisekatimovageigakenara, aikiro poviikavageigakempara. Aikiro nompegakagaigakempi ijoeseegite maganiro iseraereegi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Impogini ikanti Atinkami aikiro: —Sumo, Sumo, ikogake Satanashi iratsipereakagaigakempira viroegi maganiro ineaigakempira arisanorika pikematsatasanoigakena, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kantankicha naro noniaventakempi viro ganiri papakuasanotanakena pikematsatakenara. Intagati pampakuavetutena, kantankicha impo pimatanaerorika aikiro pinkematsatasanotanakenara nokogake pishintsitagaigaerira papigematsaegine. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ikanti Sumo: —Notinkami, noataketyo naro nogiatakotanaempira, irashitakoitakempirika irimaitakenatyo naro, garatyo nokumatimpi. Ontirika irogaitakempi irimaitakenatyo naro aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ikantiri Jeso: —Perero, nonkantasanotakempi paita tekyara irinie atava pinteratakotakena mavati. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Impogini ikantaigiri Jeso irogamereegi: —Antari notigankaigakempira pinkenkitsavageigutera nokantaigavakempira gara pamaigi pitsagine, poyagantarira pigorikite intiri pisapatote, ¿matsi ario patsipereavageigake pikogakovageigakara? Iriroegi ikantaigi: —Tera tatoita nonkogakotumaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Impo ikantaigiri: —Kantankicha maika ariokya tyanirika shintankichane itsagine iramanakerotyo ontiri yoyagantarira igorikite. Tyanirika terira ontime isavurite impimantakerotyo imanchaki iragantakemparora savuri kameti iroroniri impugamentantakempa, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ontsataganakenkanitari okantirira Itsirinkakagantakerira Tasorintsi oniakotakenara okantakera: ‘Itentagantunkani vetsikagisevageigatsirira terira onkametite.’ Magatirotari itsirinkakoitakenarira ontsataganakenkanityo. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ikantaigiri iriroegi: —Notinkami, akari aka aityo piteti savuri. Ikanti irirori: —Maika intagatiroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Impogini iatanai Jeso otishiku Orivoshi ariotari iatapinitiri kara. Yogari irogamereegi yogiaiganairi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Impo yogonkeigapaakara ikantaigiri: —Niaventaigempa ganiri papakuaiganai pikematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Impo iatanake antakona anta itigeroanaka inianakeri Iriri ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apa, pinintakerika pogavisaakotaenara ganiri natsipereavageti, kantankicha impatyora viro tyarika pinkante.” ");
INSERT INTO mcbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Impo ipokashitakeri isaankariite Tasorintsi iponiaka enoku ishintsitagakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ineavakara yatsipereasanotanakera ariompatyo iniaventanakari imasavitanaketyo kara ashiriaagematanakatyo arioaapagerikatyo iriraa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Impo yagatanakera iniaventakara ikaviritanaa iatake inkamosoiguterira irogamereegi, ineaigapaakeri magasevageigake ikenkisureavageigakatarityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ikantaigiri: —¿Antari gara pimagaigi? Tinajaiganake piniaventaigakempara ganiri papakuaiganai pikematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Impogini aiñokyara iniavageti Jeso ipokaigapaake tovaini matsigenkaegi itsaisevagetapaakatyo kara. Yogari irogamere paitacharira Jorashi ikenapaake iivatapaake. Iroro yagapaakerora aiñoni ishigatetapaakari Jeso yasaraanatapaakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Impo Jeso ikantiri: —Jorashi, ¿antari gara pikañota maika pasaraanatapaakarira Kañotasanotakaririra Matsigenka pagakagantakerira? ");
INSERT INTO mcbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yogaegiri irogamereegi ineaigavakerira maganiro pokashiigakeririra ikantaigiri: —Notinkami, ¿ario nompugamentaiganakempi nonkaratantaigavakemparira nosavurite? ");
INSERT INTO mcbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ishiganaka paniro iserogempitatutarityo ironampiria itinkamisanorira saseroroteegi, ");
INSERT INTO mcbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","kantankicha Jeso ikanti: —Arione, intagati. Inoshi itsagatiro igempita oga okenake paa shitikaa vegasanovagetaa. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Impo iniaigakeri itinkamiegi saseroroteegi intiegiri itinkamiegi soraroegi sentaigirorira ivanko Tasorintsi intiegiri itinkamiegi jorioegi ikantaigiri: —¿Matsi naro koshinti nerotyo pipokashiigapaakenara pamashiigapaakenara savuri ontiri inchakii? ");
INSERT INTO mcbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Antari nokonoivageigimpira omirinka anta ivankoku Tasorintsi tera tyara pinkantumaigena, kantankicha maika ontitari aganakara pagaveantaigakenarira ontiri aikiro iragaveantakemparira kamagarini, nerotyo pikañotantaigakarorira maika. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Impogini yagaiganakeri Jeso yamaiganakerira ivankoku itinkamisanorira saseroroteegi. Yogari Perero yogiatakotanakeri kantankicha intaina yaratinkagetapaake. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ario kara itagaigake tsitsi pampatuiku ipitaigake itaenkaigakera yonkuvokiigakaro. Yogari Perero iatake itentaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Impogini oneakerira paniro nampiriantsi itaenkavagetakera opampogiamatanakerityo sorerererere okanti: —Intitari aikiro yoga itentarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kantankicha Perero ikanti: —Ariorikaratyo, teranika noneimateri. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Impo osamanitanake pashinikyatyo neakeri ikantiri: —Vironirorotyo aikiro irogamere Jeso. Ikantutaatyo aikiro Perero: —¡Teratyo! ");
INSERT INTO mcbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Impo osamanitanaira aikiro ariompatyo ikantanakeriri pashini: —Arisanoniroro itentavagetariri, intitari Garireakunirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yogari Perero ikemamampeganakatyo ikanti: —¿Jaaa, tatoita? ¿Tyara pikanti? Irorotyo iniakera Perero iniamatanaketyo atava. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ishonkamatanaka Atinkami ikamagutiri Perero ogatyo ikenake irirori isurematanaarotyo ikantakeririra Jeso inkaara ikantiri: “Paita tekyara iriniimate atava pinteratakotakena mavati.” ");
INSERT INTO mcbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ikaviritapanuta iataira ogatyo ikenake iragamatanakatyo jiii jiii jiii, ikaemavavagetaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Impo maganiro soraroegi sentaigakeririra Jeso isamatsanaigakerityo kara ipasapasaigakerityo togn togn togn, tyarika. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ipashiokiigakeri itaataaigakerira ivoroku ikantaigavakerira: —Atsi gotenityo tyani taakempi, irorotari vintira kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iposantenaigakerityo kara isamatsanaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Impogini okutagitetanakera yapatoitaigaka itinkamiegi jorioegi intiegiri itinkamiegi saseroroteegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi, intiegitari maganiro itinkamipage jorioegi. Impo ikaemakagantaigakeri Jeso iramakenkanira inkogakotagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ikantaigiri: —Atsi kamantaigena, ¿arisanotyo vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite? Ikantaigiri irirori: —Nonkantaigavetakempi: ‘Jeeje, nanti’, garatyo pikematsaigana. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ariokya nonkogakotagantageigavetakempi garatyo piniaigi viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kantankicha maika iriatae Kañotasanotakaririra Matsigenka impirinitakera irakosanoriraku Tasorintsi gaveavagetatsirira, kantanakaniroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Impo ovashi ikantaigakeri maganiro: —Iroroventi ¿viro vinti Itomi Tasorintsi? Ikanti Jeso: —Jeeje, naroniroro, virotari kantaigankitsi. ");
INSERT INTO mcbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ovashi ikantaiganake iriroegi: —Iroroventi maika intagatityo akaemakagantaigi pashini iripokaigakera inkamantaigakaera ikemaigakerira ikañotagumanatakarira Tasorintsi, matakaniroro akemaigakeri tsikyata aroegi ikantakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nerotyo maganirosanotyo ikaviriiganaka iaigakera yamaiganakerira Jeso Piratoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Impo yogonkeigapaakara itsoeventaigapaakari ikantaigi: —Yokari yoka nokemaigakeri inianiaiganakerira notovaireegi ikantaiganakerira inkisaiganakerira koveenkari, ontiri aikiro ikantake: ‘Ganige pipaigairi koriki koveenkari Sesa.’ Aikiro onti ikantanake: ‘Nanti Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yogari Pirato ikantiri: —¿Arisano viro Igoveenkariegite jorioegi? Ikanti Jeso: —Jeeje, arisano pikantasanotakeniroro, naroniroro. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ikantutaigaarityo Pirato maganiro itinkamiegi saseroroteegi intiegiri maganiro matsigenkaegi ikantaigiri: —Yogari yoga naro noneakeri tera tatoita irovetsikumate kameti inkisakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kantankicha iriroegi ariompatyo ishintsiiganakeri ikantaiganakera: —Arisanotari yogotagantavagetanake inianiaiganakerira maganiro Joreakunirira ikantaigakerira inkisaiganakerira koveenkari Sesa impugaiganakemparira. Itsititapanutiro Garireaku maika atake ipokanakero aka. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Impo ikemavakera Pirato ikantaigutarityo: —¿Arisano iriro Garireakunirira? ");
INSERT INTO mcbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Iroro ikantaigakerira: “Jeeje, irironiroro”, itigankutarityo Erorishiku, pokaketari irirori Jerosarenku, kantankicha inti neagetakeneririra Sesa magatiro anta Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yogari Erorishi ineavakerira Jeso ishinevagetanakatyo kara ikogavetakatari ineakerimera karanki, ikemakotiritari iniakotaganira, nerotyo ikogantakarira ineakerira kameti ineakagakerira terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ikogakotagantagetakerityo posante kara, kantankicha Jeso ikemisantanake, teratyo iriniimate. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ario inaigake kara itinkamiegi saseroroteegi intiegiri gotagantaigirorira itsirinkakotanakerira Moiseshi. Iriroegi ariompatyo ishintsiiganakeri itsoeventaiganakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yogari Erorishi intiegiri isoraroegite iposantenaigakerityo Jeso kara, aikiro isamatsanaigakeri yogagutantaigakarira kamisa karenimagori kañorira yogagutarira koveenkari. Impo akiiro yamakagantairi Piratoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ovashi yogametiavakagaigaa Pirato itentaarira Erorishi, karanki ontitari ikisavakagaigavetaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Impo yogari Pirato yapatoitaigakeri itinkamiegi saseroroteegi intiegiri itinkamiegi jorioegi intiegiri aikiro maganiro matsigenkaegi ");
INSERT INTO mcbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ikantaigiri: —Viroegi pamaigavetakenari yoga pikantaigake inianiaiganakeri matsigenkaegi ikantaigakeri inkisaiganakerira koveenkari impugaiganakemparira, kantankicha naro noneakeri tera inkañogetero maika pikantaigakenarira, tsikyatatari pikemaigakeri viroegi iniakera nokogakotagantakerira inkaara. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ario ikañotaka Erorishi irirori ineakeri tera irovetsike terira onkametite, nerotyo yogipigantavaaririra. Maika pineaigake tera tatoita irovetsikumate kameti inkamakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nompasatagantavakeri impo nampakuaeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ikantakeri maika omirinkatari agara Pasekoa yogari Pirato yapakui paniro yashitakovitunkanirira yovetsikakera terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kantankicha ikemakera ikantakerira Pirato maganirosanotyo ikaemavaitaiganake ikantaigi: —¡Kentakoteri! ¡Irirompatyo pampakuae Varavashi! ");
INSERT INTO mcbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yogari Varavashi onti yashitakovitunkani itentashiigakarira pashini timaigatsirira kara Jerosarenku ikisaiganakerira soraroegi iromanoegi ontiri aikiro yogantakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yogari Pirato ikogavetakatyo irapakuaerimera Jeso iniitaigaarityo aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kantankicha iriroegi ariompatyo ikaemasanoiganakeri: —¡Kentakoteri! ¡Kentakoteri! ");
INSERT INTO mcbNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ikantutaigaarityo aikiro Pirato: —¿Matsi tyara ikantakara? ¿Tatampatyora yovetsikakera? Nokogakotagantavetakari noneakeri naro tera tatoita irovetsikumate kameti inkamakera. Nompasatagantavakeri impo nampakuaeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kantankicha iriroegi ariompatyo ishintsiiganakeri ikaemaiganakera: —¡Kentakoteri! ¡Kentakoteri! Pairotari ikaemageigamatake ovashi yagaveantaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Nerotyo Pirato ikematsaigakeri ikantaigiri: —Neri yoka Jeso tyarika pinkantaigakeri virompatyo viroegi. Impo yapakuairi Varavashi yashitakovitunkanirira itentaigakarira pashini ikisaiganakerira igoveenkarite ontiri aikiro yogantakera. Irirotari ikogaigake irapakuaenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Impo iaiganake yamaiganakerira Jeso inkentakoigakerira. Itonkivoaigakari paniro Surenekunirira paitacharira Sumo iponiapaaka anta parikoti. Iriroegi yagaigavakeri inatakagaigakerira igoroshite Jeso yogiataganakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yogiaiganakerityo tovaini matsigenkaegi ontiegiri aikiro tsinaneegi ontovaigavageteratyo kara iragatsikanaigakarira okenkisureakoigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kantankicha Jeso ipampogiaigakero ikantaigiro: —Viroegi tsinaneegi Jerosarenkunirira, gara piragatsikaigana naro, virompaegityo iragatsikaigaachane intiegiri pitomiegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aganakempatari kutagiteri onkantanakenkanira: ‘Ogari terira intimumaige otomi ikavintsaavagetakero Tasorintsi, teranika oneimaigerinika oananekite, tera ontsomitagumaige.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Impogini ‘maganiro inkantaiganakerotyo otishipage: ¡Tarankanake pintsitokaiganakenara!, inkantaiganakerotyo aikiro otonkoavatsagetakara: ¡Manakoigena, pintikakoigakenara!’ ");
INSERT INTO mcbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kañotari naro akyari ikañoitana maika iriromparorokari matsigenkaegi pairo irogagaigakenkani inkisashiigakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aikiro yamanunkani piteni vetsikaigankitsirira terira onkametite inkentakoigakenkanira intentagantaigakenkanira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Impo yogonkeigapaakara Karaveraku ario kara ikentakoigakeri Jeso itentagantaigakari yogaegi vetsikaigankitsirira terira onkametite, paniro yogaratinkakotunkani irakosanoriraku, yogari irapitene onti yogaratinkakotunkani irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Irorotyo ikentakotanunkanira Jeso ogatyo ikenake iniaventaiganakeri kentakoigakeririra ikanti: —Apa, gara pikisaviigiri ikañoigakenara maika, teranika irogoige. Impo yogari soraroegi isokagiaigakero mapukicho ogotantaganirira kameti irogotantaigakemparora tyanirika shintakemparone imanchaki. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ario inaigake kara tovaini matsigenkaegi ipampogiaigakerira. Yogari itinkamiegi isamatsanaigakerityo ikantaigakerira: —Kogapage ikantunkani yagaveavagetityo ikavintsaantavagetakera yogavisaakotakerira pashini matsigenka. Maikari maika atsi kantetyo impugamentanakempara irogavisaakotaempara ikiiro, irorotari intira Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ario ikañoigaka soraroegi irirori isamatsanaigakerityo yaiñoniiganakari ipaigakerira vino kachoari. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aikiro ikantaigakeri: —Irorotari vintira Igoveenkariegite jorioegi atsi pugamentanakempanityo pogavisaakotaempara. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Impo otsirinkunkani ogunkani igoroshiteku igitotakera okanti: “Yokari yoka inti Igoveenkariegite jorioegi.” ");
INSERT INTO mcbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Inianake paniro vetsikankitsirira terira onkametite itentagantaigakaririra ikaveganatakeri Jeso ikantiri: —Irorotari vintira Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite, atsi pugamentanakempanityo pogavisaakotaempara vikiiro ovashi pimaigaena naroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kantankicha ikisutarityo irapitene ikantiri: —¿Matsi tera pimpinkeri Tasorintsi? ¡Pineavetakatyo ikentakoitakempira itentagantaitakempirira, atanatsi pikañotakara maika! ");
INSERT INTO mcbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aroegi antsipereaigetatyo avetsikaigaketari terira onkametite ikañotantaigakairira maika, kantankicha irirori tera tatoita irovetsikumate, onti yatsipereakagunkani kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Impo ishonkatematanakarityo Jeso ikantiri: —Jeso, impogini aganakempara pimpokaera pimpegakempara Igoveenkariegite maganiro pisuretaenara naro gara pimagisantana. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Inianake Jeso ikantiri: —Nonkantasanotakempi maikatyo piatae okametigitetasanovagetira pintentakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Antari ikantakera maika atake ikatinkatanake poreatsiri. Apavatsaasematanakatyo magatiro apagiteanakarotyo kara ovashi itsunkavagetanake, ");
INSERT INTO mcbNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","teranika inkoneatumatae poreatsiri. Impo ogari kamisa tsatamagotacharira ivankoku Tasorintsi ogatyo okenake osaraamatanaketyo nigankisano okantanakera tseerererere pairatamatake kotarenkasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yogari Jeso ikaemapanuti imaraenkarikatyo kara ikanti: —¡Apaa, gavaero nosure! Iroro ikantakera maika oga ikenake ikemisantanake ikamanakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yogari itinkamiegi soraroegi iromanoegi ineavakerora okañogetakara maika ikanti: —¡Pairo yavisaenkavageti Tasorintsi! Arisanoniroro tera tatoita irovetsikumate irirori onti ikentakotunkani kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yogaegiri maganiro patoitaigankicharira inkaara impampogiaigakerira Jeso inkentakotakenkanira ikenkisureavageiganakatyo kara iaiganai ipatosanegintaiganakatyo ton ton ton, ");
INSERT INTO mcbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","kantankicha yogaegiri tentavageigaririra Jeso ontiegiri tsinaneegi giaigakeririra iponiakara Garireaku yaratinkaigake antakona anta ipampogiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Itimake paniro surari kavintsaantavagetatsirira kematsatasanotiririra Tasorintsi ipaita Jose, onti iponiaka Arimateaku. (Ogari Arimatea onti onake aikiro Joreaku.) Irirori inti itentaigarira itinkamipage jorioegi yapatoitapiniigara. Igantaga pairani yogiakerira iripokakera Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi, nerotyo ikantaigakera itovaireegi irogakenkanira Jeso, tera irimavagetempa irirori. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Impo ineakerira ikamakera iatake Piratoku ikantakerira ikogakera iramanaerira Jeso inkitataerira. Irirori ikantiri: —Nani, manaeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ovashi iatake ikentakoreakerira iponaviotantakari mechomagori kamisa ovetsikantunkanirira irino. Impo yamanairi yogantaatari imperitanaki okyaenkarira okigantunkani tekyaenka ogantumatenkani igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ogari ikamantakarira Jeso onti kutagiteri yovetsikavagetantaiganakarira jorioegi magatiro inkogakoigakemparira onkutagitetanakera agantakemparira apishigopireantaganirira, panikyatari aganakempa, ataketari inanai poreatsiri shavini. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ogari tsinaneegi poniaigankicharira Garireaku ogiaigakerira Jeso ipokakera oaigake oneaigakitirora yogunkanira, okiaigake tsompogi oneasanoigakeri tyara ikantunkani yoginoriinkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Impo opokaigaira pankotsiku ovetsikavageigapaakero kasankari ontiri kasankapatsari. Impo apishigopireaigaka kutagiteriku apishigopireantaganirira otsatagaigakero ikantakerira Moiseshi itsirinkakotanakerora. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Impogini okutagitetamanakera tominkoku tsitekyamanisano oaigamanake anta yogaaganira Jeso amaiganake kasankari ovetsikageigakerira chapi ikamantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Impo ogonkeigavetapaaka oneaigapaakero mapu itikakotantavetunkanirira paa gagaka shirenakitaka. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Okiaigavetanaka mameri irinoriaera Atinkami Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Otsarogavageiganaketyo kara tyampatyo onkantaige. Impo oneaigutarityo piteni isaankariite Tasorintsi kañoigamataka matsigenka kantakoigamataketyo imanchaki porerererere. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ogatyo okenaigake otsarogasanoiganakera ogivoiganakara. Iriroegi ikantaigiro: —¿Antari gara pipokaigi aka yogaganira igamaga pikogaigakerira atakerira yanianai? ");
INSERT INTO mcbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mameritari aka, ataketyo itinaanaa yanianaira. Atsi sureigaemparoratyo ikantaigakempirira aiñokyara anta Garireaku ikantakotakara ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Yogari Kañotasanotakaririra Matsigenka iragakagantakenkani iragaigakerira kañovageigacharira inkentakoigakeri impo omavatanakempara kutagiteri iranianae.’ ");
INSERT INTO mcbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Impo iroroegi osureigamatanaarotyo ikantakerira Jeso okyara iniavagetakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Impogini opokaigaira pankotsiku okamantageigapaakeri iritigankaneegi naigaatsirira 11, intiegiri aikiro pashini itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ogari kamantageigapaakeririra ontiegi Maria Magarena, Joana ontiri Maria iriniro Santiago ontiri aikiro pashini otentaiganakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kantankicha iriroegi teratyo inkematsaigero. Ineaigiri ontiri oniagisevageiganake kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kantankicha Perero ikaviritapanuta ishigavagetanakatyo yogunkanira Jeso ikamosogantavetapaaka tsompogi mameri, onti ineapaake kamisa iponatantavetunkanirira. Impo ipiganaa pankotsiku yogavagetaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Impogini paita osamanitanakera iaiganake piteni irogamereegi Emaoshiku choeni osamanitakotakaro Jerosaren, ariorika onake 11 kirometero. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Impo antari iaiganakera avotsiku iniavageiganake iniakoigakerira Jeso tyara ikantunkani yogunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iroro iniavageigakera irorokya ikantaigi irorokya ikantaigi, ikenapaake Jeso irirori itentaiganakari iaiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ineaigavetakarityo, kantankicha tyarika ikantakoigakeri Tasorintsi ganiri yogoigiri inti Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Impo ikantaigiri Jeso: —¿Tatatyo piniaventaiganakera maika? Iriroegi asatyo yaratinkaigake kenkisureaigamataka. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Paniro ipaita Kereopashi. Irirori inianake ikanti: —¿Matsi panirosanotyo pikantakara viro pinavetakara chapi Jerosarenku tera pinkemakotero iniakoigakerira maganiro? ");
INSERT INTO mcbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Irirori ikantaigutarityo: —¿Tatatyo oitara? Ikantaigiri: —Pine onti ikamakera Jeso Nasarekunirira. Irirori inti kamantantatsirira gaveavagetatsirira yovetsikagemati posante, aikiro yogovagetityo kara yogotagantavagetira, intitari gaveakagakeri Tasorintsi, nerotyo ishineventantaigakaririra maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Impogini yogari itinkamiegi saseroroteegi intiegiri notinkamiegi yamaiganakeri ipimantaigakerira iromperaventakenkanira inkamakera inkentakotakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Okyara noneaigiri ariori irirori pugamentaigakaene aroegi iseraereegi ganigera yashintaigajai pashini kameti antimaigaeniri kogapage. Maikari maika atake omavatanaka ikamakera. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kantankicha okonogagarantaigaka tsinaneegi notentaigakarira oaigamanake inkaara tsitekyamani onkamosoigerimera yogavetaaganira, ");
INSERT INTO mcbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kantankicha mameri. Impo opokaigai omintsarogaigakenatyo okamantaigapaakenara oneaigakerira isaankariite Tasorintsi ikantaigakerora atake yanianai. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Impo ikonogagarantaigaka notovaireegi iaigakiti iriroegi ineaigakitiro ikantaigake okantasanoigakeniroro mameri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Impo ikantaigiri Jeso: —¡Tekyaenkatyo pogotumaige! ¡Tyarikatyo pinkantaiganakempa pogotasanoiganakera arisano ikantasanoigake kamantantaigatsirira pairani! ");
INSERT INTO mcbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Matsi tera inkantaige yogari Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi oketyo iratsipereavagetake inkamakera impo iroganiaenkani iramanaenkanira enoku? ");
INSERT INTO mcbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Impo ovashi yogotagageiganakeri magatiro okantakogetakerira Itsirinkakagantakerira Tasorintsi oniakotakerira irirori itsititapanutiro itsirinkakogetakerira Moiseshi impo imagetanakero aikiro itsirinkakogeigakerira kamantantaigatsirira iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Impogini yogonkeigapaakara Emaoshiku ineaigiri Jeso ariompatyo iatanakeri, ");
INSERT INTO mcbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kantankicha yagaigavakeri ikantaigiri: —Atsi gatata piati. Nokogake pimagimoiganakenara naroegi, panikyatari onchapinitanae, ataketari ishonkanaa poreatsiri. Ovashi ikianake tsompogi itentaiganakarira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Impogini ipirinitaigake mesaku isekataigakempara. Irirori inoshikanakero pan iniakeri Iriri ikantakerira ishineventakaro, impo ikotagakero ipaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iroro ineaigakerira ikotagakerora pan yogotantaigavaaririra inti Jeso, kantankicha irirori asatyo ipegaenkataka. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ikantavakagaigamatanakatyo: —Iroroventi irirora inkaara anta avotsiku yogotagaigakairora Itsirinkakagantakerira Tasorintsi tyarikatyo okantaiganakai otsagasurentaiganakaira asureegiku ogishineaiganakaityo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Impo ovashi ikaviriigapanuta iaiganaira ipigaiganaara Jerosarenku. Ineaigapaakeri iritigankaneegi Jeso patoitaigaka itentaigakari pashini itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iriroegi ikantaigavakeri: —Arisanoniroro yanianai Atinkami, ineakeritari Sumo. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ovashi ikamantaiganakeri iriroegi aikiro tyara ikantaigakeri itentaiganakarira avotsiku tera irogoigeri, impogini ineaigakerira pankotsiku ikotagakerora pan ovashi yogotantaiganaaririra inti Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aiñokyara iniavakagaiga katsiketyo yaratinkimoigapaakeri iniaigapaakeri ikantaigiri: —Shineiganaempa. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iriroegi itsarogaiganaketyo kara ipinkaiganakerira ineaigiri irirori kasuvarerini. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kantankicha Jeso ikantaigiri: —¿Tatatyo pipinkaviiganakenara? ¿Tyara pikantaigakara pisureigakara maika? ");
INSERT INTO mcbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Atsi gaigero kavako nako ontiri nogiti ikentakoitakenara. Narotari. Tsagaigena pineasanoigakenara. Yogari kasuvarerini teranika ontime ivatsa ontiri itonki inkañotakenara naro maika pineaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iroro ikantaigakerira maika iokotagageigakeri irako ontiri ivonkiti ikentakotunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kantankicha ineaigakerira tenigera iragaveaigae isureigaempara, pairotari ishinevageiganaka yogavageiganakera kavako, ikantaigiri: —¿Aityo pisekaegi? ");
INSERT INTO mcbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iriroegi ikantaigiri: —Aiño shima tashiri. Ovashi ipaigakeri ");
INSERT INTO mcbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","yagakeri yogakari ineakoigakeri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Impo ikantaigiri: —Maikari maika magatiro pineageigakerira irorotari nokamantaigakempirira karanki aiñokyara notentavageigimpi, nokantakera ontsataganakempa magatiro itsirinkakotanakenara Moiseshi ontiri itsirinkakoiganakenara kamantantaigatsirira ontiri aikiro sankevantiku Saremo itsirinkakotakenara Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Impo irirori yagaveakagaigakeri irogotasanoiganakerora tatoita okantakotake Itsirinkakagantakerira Tasorintsi ");
INSERT INTO mcbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ikantaigiri: —Ario okañotaka maika otsirinkakotunkanirira oniakotakerira Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite israereegi. Onti okantake impogini iratsipereavagetake inkamakera kantankicha omavatanakempara kutagiteri iranianae. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Impogini intigankaigakeri kamantakoigakerinerira iriaigakera inkenkitsatimoigakerira maganiro matsigenkaegi intsitiiganakero Jerosarenku ovashi intsotenkagiteavageiganakero kara inkantaigakerira maganiro irapakuaiganakerora yovetsikageigakera terira onkametite inkantatigaiganakempara inkematsaiganakerira itigankakerira Tasorintsi irogavisaakotantakera kameti irogavisaakoigakeriniri Tasorintsi imagisantakoigakerira magatiro yovetsikageigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Viroegi mataka pineaigakero otsatagagetunkanira magatiro oka otsirinkakotunkanirira, maika viroegikya kenkitsatakoigakerone. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naro nontigankimoigakempiri ikantakerira Apa intigankimoigakempirira, kantankicha timaigetata aka Jerosarenku gatata piaigai parikoti. Giakoigempata aka intigankimoigakempirira Apa Isure iragaveakagaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Impogini Jeso itentaiganakari irogamereegi parikoti oatara Vetaniaku. Impo yogaenokanake irako iniaventaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iroro ikañotanakerora maika iniaventaigakerira ineaigiri yogaenokanaka ariompa, ariompa yogaenokavagetanaari, onti yamanaaganira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iriroegi ishineventaiganakari ikantaiganake: “Arisanoniroro inti Itomi Tasorintsi pairorira yagaveavageti.” Impo ipigaiganaa Jerosarenku ishinevageigakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Omirinkatyo iatapiniigi ivankoku Tasorintsi ikantaigakeri maganiro: “¡Pairo ikametiti Tasorintsi! ¡Pairo yagaveavageti!”");
INSERT INTO mcbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antari pairani tekyaenkara tatakona timumagetatsine igantaga itimakera Kirishito ikantaganirira Iriniane Tasorintsi. Irirori ikantakani itimakera itentakarira Tasorintsi, intitari Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Irirotari tentakari Tasorintsi okyasanokyara. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Irirotari vetsikagetakero magatiro tatarika oita timagetatsirira. Tera ontimumate pashini terira iriro vetsikerone, aikiro game inti game atimumaigi aroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Irirori inti ganiantatsirira, aikiro inti kutagitetakoigiririra maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ikutagitetakoigakeri pavatsaakoigankicharira. Iriroegi ikisaigavetakarityo kantankicha teratyo iragaveaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yogari Tasorintsi itigankakeri paniro matsigenka ipaita Joan. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Onti itigankavitakeri inkamantakotakerira yoga kutagitetakotantatsirira kameti inkematsaigakeriniri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yogari Joan tera iriro kutagitetakotantatsirira, intagati ipokashitake inkamantakotakerira, ");
INSERT INTO mcbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","panikyatari inkutagitetakotantanake yoga poniankicharira enoku kameti inkutagitetakoiganakeriniri maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Irirotyo vamparoaigavetakari matsigenka, kantankicha impogini ipokavetutara tera irogoigavakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ario ikañoigaka aikiro itovaireegi iseraereegi, iriroegityo ipokashiigavetaka, kantankicha tera irishineventaigavakempari. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kantankicha maganiro shineventaigavakaririra kematsaigavakeririra irirori ipegakagaigakari itomiegi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Antari ipegaigakerira Tasorintsi itomi tera ario onkañotemparo itomintaigara matsigenka, aikiro tera ario onkañotemparo ikogira matsigenka intomintakempara, intitari kogankitsi Tasorintsi intomintaigakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yogari Kirishito ipokuti aka kipatsiku imechotakera ikañotasanoigakai aroegi ikonoivageigakai. Aneaigakeri ikoveenkatakera, intitari Itomi Tasorintsi paniro ikantakara irirori. Pairo ikavintsaantavageti, aikiro yogikoneatimotasanoigakai tyara ikanta Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yogari Joan ikamantakotakerira imaraenkarika kara ikanti: “Irirotari yoga noniakotakerira okyara nokamantaigakempira nokantakera iripokake pashini pairorira yavisavagetakena, iketyotari timatsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Irirori pairotyo ikavintsaantavageti nerotyo ikantakanityo ikavintsaavageigakai. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pairani Moiseshi intagati itsirinkakogetakero ikantagetirira Tasorintsi ontsatagagetakenkanira, kantankicha antari ipokutira Jesokirishito onti ikavintsaavageigakai aikiro yogikoneatimotasanoigakai tyara ikanta Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tera tyani neimaterine Tasorintsi, kantankicha yogari Itomi panirorira tentasanotaririra yogikoneatimoigakai tyara ikanta irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yogari jorioegi Jerosarenkunirira itigankaigake saseroroteegi intiegiri iyashikiiganakerira Irevi inkogakotagantaigakiterira Joan tyanira irirori impo ikantaigiri: —¿Tyanimpatyora viro? ¿Viro nogiaigakerira impegakempara Nogoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Impo irirori tera iramatavinaigeri onti katinka yogakero ikamantasanoigakerira ikantaigiri: —Teratyo naro pikantaigakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Impo imatutaigaarityo aikiro ikantaigiri: —Iroroventi, ¿viro kamantantatsirira nogiaigakerira? Ikanti: —Teratyo naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Impo imatutaigaarityo aikiro ikantaigiri: —¿Tyanimpatyora viro? Atsi kamantaigena kameti nonkamantaigapaakeriniri tigankaigakenarira. ¿Tyara pinkante? ¿Tatoitatyo pipokashitake? ");
INSERT INTO mcbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Impo ikantaigiri Joan: —Nanti kenkitsatatsirira osarigagitetapaakera nomaraenkarika kara, narotari itsirinkakotanake pairani kamantantatsirira Isaiashi ikantakera impogini intimake paniro inkenkitsavagetake anta osarigagitetapaakera inkante: ‘Negintetashiigavakempari pokankitsinerira impegakempara Atinkamiegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yogaegiri kogakotagantaigakeririra Joan inti tigankaigakeri irapivariseoegitene. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Impo ikantaigiri: —Iroroventi teranika viro Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite, ¿tyara okantakara pogiviatantavagetakera? Pikantaketari tera viro Eriashi, aikiro tera viro kamantantatsirira nogiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ikanti Joan: —Narori intagati nogiviatanti niaku, kantankicha aiño paniro konoiigakempirira terira pogoigeri, ");
INSERT INTO mcbNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","irirotari pogitapaakenanerira. Narori garorokarityo nokañotumatari irirori, onti nagamaavagetakari, pairotari yavisavagetakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yogaegi kogakotagantaigakeririra onti iatashivageigakitiri Vetaniaku. Ogari Vetania onti onake intati Jororanku ariotari yogiviatantavagetakeri kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Impogini okutagitetanakera yogari Joan ineiri Jeso ikenapaake ikanti: “¡Neri yoga Ovisha itigankakerira Tasorintsi inkamaventaigakerira maganiro kañovageigacharira! ");
INSERT INTO mcbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Irirotari nokenkitsatakotakerira nokantakera: ‘Iripokake pashini impogitapaakenanerira pairorira yavisavagetakena, iketyotari timankitsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naro aikiro teratyo nogovetempa iriro agiaigakerira, kantankicha onti nogiviatantavagetake kameti irogoigakeniri maganiro iseraereegi iriro pokankitsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Impogini ikanti aikiro Joan: “Okyara tera nogovetempari, kantankicha yogari tigankakenarira nogiviatantavagetakera niaku ikantakena: ‘Tyanirika pineake iraguitashitapaakeri Nosure irapusatinkagutapaakempari irinagutapaakerira, irirotari tigankakerineririra Nosure intimasurentantakera.’ Impo noneakeri Isure Tasorintsi iponiapaaka enoku ikañotapaakari shiromega yapusatinkagutapaakari inagutapaakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Noneasanotakeri, irorotari nokantantakarira inti Itomi Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Impogini okutagitetamanakera yogari Joan aiño inake kara itentaigakari piteni irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Impo iroro ineavakerira Jeso ikenanakera kara ikamagutavakeri ikanti: —¡Neri yoga Ovisha itigankakerira Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Irorotyo ikemaigavakera irogamereegi oga ikenaigake yogiaiganakeri Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Irirori ishonkapanuta ineaigiri yogiaigapaakeri ikantaigiri: —¿Tata pikogaigake? Iriroegi ikantaigi: —Gotagantatsirira, ¿tyara pitimi? ");
INSERT INTO mcbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ikanti Jeso: —Atsi tsame pineaigakerora. Impo iaigake ineaigakerora imagakera ovashi imagimoigakeri, ataketari inanai shavini poreatsiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Paniro giatanakeririra Jeso inti irirenti Sumo Perero ipaitaka Anturishi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Irirori iatake ikogakerira irirenti impo ineakerira ikantiri: —Noneaigakeri Meshiashi (onkantakera: “Kirishito”). ");
INSERT INTO mcbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Impo itentanakari inakera Jeso. Iroro ineavakerira ikamagutavakeri ikantiri: —Vinti Sumo, itomi Joan. Maikari maika ariokya pimpaitaempa Sepashi (onkantakera: “Perero”). ");
INSERT INTO mcbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Impogini okutagitetamanaira iatake Jeso Garireaku. Impo ario kara ineakeri Jeripe ikantiri: —Tsame pogiatanakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yogari Jeripe onti itimi Vetsairaku itimira Anturishi intiri Perero. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Impogini iatake ikogakerira Natanaeri. Iroro ineapaakerira ikantiri: —Noneaigakeri yoga itsirinkakotanakerira Moiseshi pairani intiegiri aikiro pashini kamantantaigatsirira. Irirori inti Jeso Nasarekunirira, itomi Jose. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ikantiri Natanaeri: —¿Matsi ikametitumaigiratyo Nasarekunirira? Ikantiri Jeripe: —Atsi tsameratyo pineakiterira viro. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yogari Jeso iroro ineavakerira ikenapaakera Natanaeri ikanti: —Neri yoga iseraere kematsatasanotakeririra Tasorintsi. Irirori tera iramatagumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ikanti Natanaeri: —¿Matsi tyara pineakenara kara? Ikantutarityo Jeso: —Noneakempiniroro pinakera otapinaku igera tekyara inkantakitempi Jeripe. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ovashi ikantanake irirori: —Gotagantatsirira, vinti Itomi Tasorintsi, vinti Igoveenkariegite iseraereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ikantiri Jeso: —¿Iroro pikemakera nokantakempira noneakempi otapinaku igera pagapagero pogakero pikantakenara maika? Impogini pineagetanake pashini pairorira avisagetakero oka. ");
INSERT INTO mcbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Impo ikanti aikiro Jeso: —Maika nonkamantasanoigakempi, impogini pineaigakero inkite ashireanakempara. Yogari isaankariite Tasorintsi iraguitashitapiniigakeri Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Impogini avisanakera mavati kutagiteri yagake tsinane paniro surari timatsirira Kanaaku Garireaku. Ario onake kara iriniro Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ikaemunkani Jeso irirori intiegiri aikiro irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Impogini otsoamatanakatyo vino. Ogari iriniro Jeso oatake okamantakerira okantiri: —Notomi, tsoataka vino. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kantankicha irirori ikantiro: —Je'ario, ¿tyara okantakara pikamantakenara? Totatatyo, tekyatanika agempa nokotagantakerora nagaveane. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kantankicha irorori okantaigiri paatantaigankitsirira vino: —Pintsatagasanoigakerora tatarika inkantaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ario onake kara 6 omarapageni koviti ogatsantsanakini ovetsikantunkanirira mapu. Antari oshatekaatantarora nia patiropage omonkaratakaro ariorika 70 potiria. Okari oka nia onti yovitakoigakenerira jorioegi iragajaigakera inkivakoigakempara isekataigakempara intsatagaigakerora yogameigarira iriroegi. Ariotari ikantaigari maganiro jorioegi omirinka ikivakoiga tekyara isekataigempa irisaankaigakempara okitsitinkaigakerira tatapagerika oita. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Impo Jeso ikantaigiri paatantaigankitsirira vino: —Atsi shatekajaigaero nia kovitiku. Impo ishatekajaigairo okaraagetake otseraku. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Impo ikantaigiri: —Maikari maika pinkitajaiganakera maani pamakoiganakenerira negintegetakerorira vieseta ineakerora. Impo ikitajaiganake yamakoiganakeneri. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Iroro yoviikakarora ikaemakeri ikyarira gankitsi itsinanetsite ikantiri: —Imirinka atovaireegi oketyo ipimantaigi kametiarisanorira vino, impo yaravoaiganakera ikaemaigunkanirira irorokya ipimantaiganake tesakonarira onkametiate. ¿Tyara pikantakara viro tera ario pinkañotero maika?, onti oketyo pogiivatake tesakonarira onkametiate irorokya pitsoteataka kametiarisanorira. Ikantantakaririra maika teranika irogote tyara oponiaka vino, intagani goigankitsi paatantaigankitsirira, iriroegitari shatekajaigakero nia okyara. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ariotari kara Kanaaku Garireaku itsititanakero Jeso yovetsikakera terira oneimagetenkani ineakagaigakerira maganiro iragaveane, ovashi ikantaigake irogamereegi: “Arisanoniroro inti Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite.” ");
INSERT INTO mcbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Impogini iatake Kaperenaoku itentanakaro iriniro intiegiri irirentiegi intiegiri aikiro irogamereegi. Ario itimaigakiti kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Impogini ochoenitapaakara Pasekoa iatake Jeso Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Impo iavetapaakara ivankoku Tasorintsi inti ineaigapaake pimantavageigatsirira toro intiri ovisha intiri aikiro shiromega. Ario inaigake aikiro kampiavageigiririra koriki. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yogari Jeso yagamatanaketyo iviritsa yampityagitakero ipasatantaigakarira maganiro yoneagaigakarira yogikonteigairira itentagantaigaarira irovishate intiri itorone. Isokagisetutaigakeri igorikiegite kampiavageigiririra koriki yogishonkagetutaigakeri imesane. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Impo ikantaigiri pimantaigatsirira shiromega: —¡Maiganaeri pishiromegate parikoti! ¡Ogari ivanko Apa garatyo pipegakagaigaro opimantantapinitaganirira! ");
INSERT INTO mcbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yogari irogamereegi ovashi isureiganakaro okantakerira Itsirinkakagantakerira Tasorintsi okanti: “Nonkisakotakemparo pivanko osamatsanatakenkanira ovashi inkisashiitakena iratsipereakagasanoitakenara.” ");
INSERT INTO mcbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Impo yogari jorioegi ikantaigutarityo: —¿Tyani kantakempi pinkañotakempara maika? Irirorika kantakempi Tasorintsi atsi gikoneatimoigenanityo terira oneimagetenkani kameti nogoigakera irirorika tigankakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ikanti Jeso: —Nonkañotakeniroro. Atsi gimamerinkaigeroratyo oka ivanko Tasorintsi, impo omavatanakempara kutagiteri novetsikaero nonkañotagasanotaemparo. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ikantaigiri iriroegi: —Ariorikaratyo, ogari oga ivanko Tasorintsi tyarika ipomirintsiventavageigakaro kara yantunteigakerora 46 shiriagarini. ¿Tyara onkantakempara povetsikaerora viro mavati kutagiteri? ");
INSERT INTO mcbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kantankicha antari ikantakera ivanko Tasorintsi intityo kantakotankicha. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nerotyo impogini yanianaira yogaegiri irogamereegi isureiganaaro ikantakera okyara ovashi ikantaigake: “Arisanoniroro ikantasanotake”, ineaigaketari otsataganakara magatiro ikantaigakeririra, ontiri aikiro magatiro Itsirinkakagantakerira Tasorintsi niakotakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Impogini aganakara Pasekoa aiñokyara Jeso Jerosarenku, ario kara yovetsikagetake posante terira oneimagetenkani ovashi ikantaiganake tovaini: “Arisanoniroro inti Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite.” ");
INSERT INTO mcbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kantankicha Jeso yogotaketyo tera arisano inkematsatasanoigeri, yogoigiritari maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tera inkogakotempa inkamantakenkanira tyara ikantaiga, tsikyatatyo yogoti irirori, ineasurentaigiritari maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Itimake paniro pariseo ipaita Nikoremo, inti itinkami jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Irirori iatake tsitenigetiku inkamosotakiterira Jeso, impo ikantiri: —Gotagantatsirira, nogoigake inti tigankakempi Tasorintsi pogotagaigakenara, teranika tyani gaveatsine irovetsikagetera posantepage terira oneimagetenkani inkañotakempira viro garira iriro gaveakagiri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yogari Jeso ikantiri: —Maika nonkamantasanotakempi, tyanirika garira imechotai aikiro, gara ineimati impegakempara Tasorintsi Igoveenkarite. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ikanti Nikoremo: —¿Tyaratyo inkantakempara matsigenka imechotaera aikiro? ¿Matsi tyara inkantakempara antarini impiganaera omotiaku iriniro imechotaera? ");
INSERT INTO mcbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ikantiri Jeso: —Maika nonkamantasanotakempi tyanirika garira yogiviata niaku aikiro garira yoganiasurentairi Isure Tasorintsi gara ineimati impegakempara Tasorintsi Igoveenkarite. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yogari itomintarira matsigenka inkamake impogini, matsigenkatari inake, kantankicha antari iroganiasurentakerira Isure Tasorintsi ario pinkante inkantakani intimake gara ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gara poganake kavako pineakera nokantakempira tyanirika garira imechotai aikiro, gara ineimati impegakempara Tasorintsi Igoveenkarite. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Onti okañotakaro tampia, pine irorori otampiatira opoimaenkatanake, kantankicha tera ogotenkani tyara oponiaenkataka aikiro tyara oaenkatake. Ario ikañota Isure Tasorintsi yoganiasurentantira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ikantutaatyo aikiro Nikoremo: —¿Tyarikatyo okantakara oka? ");
INSERT INTO mcbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ikantutarityo Jeso: —Kogapage vinti gotagaigiririra pitovaire ¿tyara pikantakara tera pogotero oka? ");
INSERT INTO mcbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Maika nonkamantasanotakempi, naroegi onti nokamantaigavetakempi nogoigirira ontiri aikiro noneageigirira, kantankicha viroegi tera pinkematsaigena. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kañotari maika nokamantavetakempiro oneagetaganirira aka kipatsiku tera ario pinkematsatena ariomparorokari nonkamantagetempirora isariagetakarira Tasorintsi garorokarityo pikematsatumatana. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Tera tyani atumatatsine enoku itimira Tasorintsi ineagetakerora magatiro timagetatsirira anta. Panirosanotyo neasanogetakero Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pairani yogari Moiseshi yogaenokakotakeri maranke anta osarigagitetapaakera. Ario inkañotagakenkani Kañotasanotakaririra Matsigenka irogaenokakotakenkanira impogini, ");
INSERT INTO mcbNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ovashi tyanirika kematsatakerine gara ineairo igamane inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Yogari Tasorintsi pairotari yavisake itasanovageigakarira maganiro matsigenkaegi, nerotyo itigankantakaririra Itomi panirorira inkamaventaigakerira kameti ganiri ineaigairo igamane maganiro kematsaigakerinerira onti inkantakani intimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Teranika iroro intigankaviteri aka kipatsiku inkisakagantaigakerira matsigenkaegi, ontityo itigankavitakeri irogavisaakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Tyanirika kematsatakeri gara ikisashitagani, kantankicha yogari terira inkoge inkematsatakerira iriro pinkante mataka ikañotagantaka ikiiro inkisashitakenkanira, teranika inkematsateri. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maganiro terira inkogaige inkematsaigakerira inkisashiigakenkani. Kañomataka ontinirikatyo ipokashitake inkutagitetakoigapaakerira, kantankicha iriroegi pairo yavisaigake ishineventaigakarora pavatsaari, yovetsikagisevageigaketari terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maganirotari vetsikagisevageigatsirira terira onkametite tera inkogaige inkutagitetakoigakenkanira ganiri oneagani yovetsikaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kantankicha yogari negintevageigacharira ishinevageigaka ikutagitetakoigunkanira, ikogaigaketari oneakenkanira yovetsikageigakerira ogotakenkaniniri inti gaveakagaigakeri Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Impogini iatake Jeso Joreaku itentaiganaari irogamereegi. Ario inaigake kara tovaiti kutagiteri yogiviatantavageigakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ario ikañotaka Joan irirori aiño yogiviatantavagetake Enonku ochoenitira Sarime, ariotari apatoatakari okonteagetakera niateni. Ipokashitapiniigakeri tovaini matsigenkaegi yogiviaigakerira, ");
INSERT INTO mcbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tekyatanika irashitakotenkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Impo yogari irogamereegi Joan itentaigakari paniro jorio iniaventaigakerora tyatirikara pairo avisake osaankantira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Impogini iatashiigakeri Joan ikantaigiri: —Gotagantatsirira, yogari pitentakarira chapi anta intati Jororanku pikamantakotakerira, maika aiño yogiviatantavagetake. Iatashiiganakeri maganiro irogiviaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ikantaigiri Joan: —Tera intimumate gaveatsinerira tsikyata garira inti gaveakagiri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pisatyo pikemaigakena viroegi nokantakera tera naro Ikogakagakerira Tasorintsi impegakempara Pigoveenkariegite, onti itigankakena noivatakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pine yogari ikyaenkarira gankitsi itsinanetsite irirotari shintasanotakaro. Yogari mampiakeririra intagati yamampiakeri ikemisantakeri iniavagetakera, ishinevagetakatyo kara. Ario nokañotaka naro noshinevagetaka noneaigakerira iatimoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maika irirori ariompatyo iravisavagetanakeri irishineventanakenkanira, narokya ganige ishineventasanoitaana. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Yogari poniankicharira enoku pairotyo yavisageigakeri maganiro timaigatsirira aka kipatsiku. Yogari kipatsikunirira intagati ikenkitsatakogeti ineagetirira kipatsiku, kantankicha yogari poniankicharira enoku ");
INSERT INTO mcbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","onti ikenkitsatakogetake ineagetirira ontiri aikiro ikemagetirira irirori anta, kantankicha tera inkematsatenkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Antari ikematsataganira iroro ogotantunkani omirinka katinka yogagetakero Tasorintsi magatiro tera iramatagumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yogari itigankakerira Tasorintsi intagatitari ikenkitsavagetake ikantakeririra irirori, ikantakanitari itinkamitasanotakari Isure. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yogari Tasorintsi itasanovagetarityo Itomi ikantantakaririra irashintagetakemparora magatiro yovetsikagetakerira, aikiro ikantakeri iriro kantankitsine tyara inkantaigakenkani maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tyanirika kematsatakerine gara ineairo igamane, onti inkantakani intimake. Yogari garira ikematsatiri gara ikantakani itimi, ontityo inkisashivagetakempari Tasorintsi impogini.” ");
INSERT INTO mcbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Antari aiñokyara inake Jeso Joreaku yogari pariseoegi ikemakoigakeri ariompa itovaiganakeri irogamereegi, aikiro pairo yavisanake yogiviatantavagetanakera yavisanakeri Joan. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kantankicha teratyo arisano iriro giviatantavetachane Jeso, intityo giviatantavageigankitsi irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Impo yogari Jeso iroro ikemakotakara iniakotunkanira iatai Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Antari iatanaira onti ikenanai Samariaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Karari kara Samariaku yogonketapaaka apatotara pankotsi opaita Sukare ochoenitakotakaro kipatsi yashintavetarira Jakovo pairani impo ipakeri itomi paitacharira Jose. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ario onake kara omonkia okantaganirira imonkiatsite Jakovo. Ishigopitaketari Jeso yanuitakera ovashi ipirinitapaake kara. Katinkavagetake poreatsiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yogari irogamereegi iaigake apatotakara pankotsi impunaventaigera iseka. Impo yogari Jeso ineiro okenapai tsinane timatsirira kara agaatera nia. Ikantiro: —Atsi pimpakenara noviikakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Irorori okantiri: —¿Tyara okantakara pinevitakenara nia poviikakempara? Vintitari jorio, narori nanti samaritana. (Yogari jorioegi ikisumaigiritari samaritanoegi.) ");
INSERT INTO mcbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ikantutarotyo Jeso: —Pogotakeme tatoita inintakagakempi Tasorintsi, aikiro pogotakeme tyani nevitakempi nia, viro pinevitakerimetyo irirori, impo irirokyametyo pakempine nia ganiantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Irorori okantiri: —Mameritari pinkitaatantakemparira, aikiro ogari oga omonkia onaavagetitari savi, ¿ario tyara pagaatakerora kara nia ganiantatsirira pimpakenara? ");
INSERT INTO mcbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Matsi pairo pavisakeri Jakovo yashikiiganakenarira pairani vetsikanakerorira oka omonkia?, irorotari yoviikuntetanakarira irirori intiegiri itomiegi intiegiri aikiro ipirapage. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ikantiro Jeso: —Maganiro viikaigarorira oka nia imireigae aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kantankicha yogari viikakemparonerira nompakeririra naro garatyo imiretumatai. Ogari oga nia nompakeririra onkantakani ontimagutakeri isureku ovashi gara ineimatairo igamane inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okanti: —Atsi penaronityo oga nia noviikakempara kameti ganiri nomiretumatai, ganiri nopokumatai aka nagaataera. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Impo ikantiro Jeso: —Atsi kantakiteri pijime impo pimpigae. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Okantiri: —Mameritari nojime. Ikantutarotyo Jeso: —Pikantasanotakeniroro mameri pijime. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Itimavetaka pijime 5 pagavetakarira. Yogari pagairira maika tera iriro pijime. Arisanoniroro pikantasanotakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Irorotyo okemavakera ikantakerora okantutarityo: —Virorakarityo kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yogaegiri yashikiiganakenarira pairani onti iniapiniigiri Tasorintsi aka otishiku. Viroegiri jorioegi onti pikantaigi iriniakenkanira Tasorintsi Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ikantiro Jeso: —Maika nonkamantasanotakempi gapaaka kutagiteri ganigera iniaagani Tasorintsi aka otishiku ontirika Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Viroegi samaritanoegi tera pogoigeri piniaigirira, onti piniashiigari kogapage. Naroegiri jorioegi nogoigiri, ikantaketari Tasorintsi okyara yogari intigankakerira irogavisaakoigakerira maganiro matsigenkaegi jorio irinake. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kantankicha maika gapaaka kutagiteri iriniagantsiigakerira Tasorintsi gotasanoigakerinerira tyara ikanta, aikiro iragaveakagaigakeri Isure iriniaigakerira. Ariotari ikogakeri irirori inkañoigakempara maika niaigakerinerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yogari Tasorintsi suretsi inake. Tyanirika kogankitsi iriniagantsitakerira intagati kogakotankicha irogotasanotakerira tyara ikanta, aikiro iragaveakagakerira Isure. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Okantiri irorori: —Nogotake iripokake Meshiashi (irirotari ikantaganirira Kirishito). Antari iripokakera inkamantasanoigakae magatiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Impo ikantiro Jeso: —Oga irironiroro niakempi maika, narotari. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Impo ikenaigapai irogamereegi. Iroro ineaigapaakerira iniakerora tsinane yogavageiganaketyo kavako, kantankicha tera tyani kanterine, “¿Tyara pikantiro?”, ontirika inkantaigakeri, “¿Tyara okantakara piniakerora?” ");
INSERT INTO mcbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ogari irorori okapanutiro agaatantarira nia oatakera anta otimira okantaigapaakerira timaigatsirira kara: ");
INSERT INTO mcbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Tsame pineaigakerira yonta surari ikantakena magatiro novetsikagetirira. ¿Tyanirikatyo? ¿Terikara iriro kamantantatsirira agiaigakerira intigankakerira Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ovashi yogiaiganakero iaigakera inakera Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yogaegiri irogamereegi irorotyo ineaigavakerora oatanakera onkantaigakiterira ikantaigiri Jeso: —Gotagantatsirira, atsi sekatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ikanti irirori: —Naro aityo noseka terira pineaigero viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iriroegi ikantavakagaiganaka: —¿Ariorakari yamunkani iseka inkaara? ");
INSERT INTO mcbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kantankicha Jeso ikantaigiri: —Ogari noseka onti nompiriniventakerora ikogakagakenarira tigankakenarira kigonkero nontsotenkakerora nontsatagasanogetakerora magatiro ikantakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Viroegi pikantaigi: ‘Maika pitepagenivani kashiri osampatanakera turigo agakenkanira’, kantankicha naro nonkantaigakempi atsi gaigeratyo kavako neaigeroratyo turigoshi mataka sampatake. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yogari gakeronerira ineakotakempa impunatakenkanira, intitari kematsatagaigakerineririra pashini matsigenkaegi inkantakaniniri intimaigake. Impogini yogari pankitakerorira intentakemparira gakerorira irishinevageigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Arisanoniroro okantasanotunkani: ‘Paniro pankitakero, pashinikya gakerone.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naro notigankaigakempi pagaigakerora terira viro pankiigerone, pashini pankiigakero maika virokya gaigakerone. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Impogini tovaini timaigatsirira kara Sukareku ikantaigake: “Irironiroro pokankitsi agiaigakerira intigankakerira Tasorintsi.” Ikemaigakerotari okantaigakerira oga tsinane okantakera: “Ikantakena magatiro novetsikagetirira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iroro ipokaigakera ineaigakerira Jeso ikantaigakeri irimagimoiganakerira. Ovashi iatake imagimoigakerira piteti kutagiteri. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Impo ikantaigake pashini tovaini: “Arisanoniroro iriro agiaigakerira.” Ikemasanoigakeritari ikenkitsavagetakera irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Impo ikantaigiro oga tsinane: —Maika nogotasanoigake arisanoniroro inti gavisaakoigakerinerira maganiro matsigenkaegi, teranika patiro nonkemaige pikantaigakenarira viro chapi, tsikyatatari nokemasanoigakeri naroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Impogini iatanai Jeso Garireaku, ");
INSERT INTO mcbNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ikantaketari irirori yogari kamantantatsirira tera irishineventenkani itimira. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Antari yogonketapaakara Garireaku yagaigavakerityo timaigatsirira kara ishineventaigavakarira, iaigakititari iriroegi aikiro Jerosarenku yogavisaigutirora Pasekoa ovashi ineaigakeri yovetsikagetakera posante terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Impogini ipiganaa Jeso Kanaaku ariotari kara ipegakagakarora nia vino okyara. Aiño paniro inampina koveenkari itimake Kaperenaoku, imantsigavagetake itomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Impo irirori ikemakotavakerira Jeso ipokakera Garireaku iponiakara Joreaku iatake itonkivoavakarira ikantakerira iriatakera ivankoku irovegaaterira itomi, panikyatari inkamanake. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yogari Jeso ikanti: —Viroegi garira pineaigana novetsikagetakera terira oneimagetenkani ogakagaiganakempira kavako garatyo pikematsaigana. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ikanti irirori: —Tsamepage tekyara inkame notomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ikantiri Jeso: —Maika piatae vegaa pitomi. Irirori ikematsatakeri ovashi iatai. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iroro iataira panikyara irogonketaempa ivankoku itonkivoaigavakari ironampiria ikantaigavakeri: —Vegaa pitomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Irirori ikantaigiri: —¿Tyara inake poreatsiri yoveganaara? Ikantaigiri: —Chapi choekyanira itsunkatseitanake oga ikenake ishavogatanai yoveganaara. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ovashi isuretanakaro ariotari choekyanira itsunkatseitanake ikantakerira Jeso: “Vegaa pitomi.” Impo ovashi ikantake: “Arisanoniroro inti tigankakeri Tasrointsi.” Ario ikañoigaka aikiro maganiro magimoigiririra. ");
INSERT INTO mcbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pitetanaka yovetsiki Jeso terira oneimagetenkani iponiakara Joreaku iataira Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Impogini yogari jorioegi yapatoitaigaka Jerosarenku irogavisaigakerora iviesetaegite, ario iatake Jeso irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Karari kara Jerosarenku ochoenitakara sotsimoro okantaganirira Isotsimorote Ovisha ario onake omonkia onti okantagani irinianeku evereoegi Vetsata. Ario kara ovetsikunkani otsimampegantaganirira 5 onake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Irorotari inoriantaigaka tovaini mantsigaigankitsirira yogiaigakerora omareaatanakempara nia. Iposanteivagetanakatyo kara, pashini tera inee, pashini onti tera iranuitagantsite, pashinikya onti ishinkogisetaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ipokapinititari isaankariite Tasorintsi yomareaatapinitirora oga nia, impo tyanirika iketyo giaatankicha oga ikenake yoveganaa pa kañotasanotaa. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aiño paniro kara imantsigavagetini pairani tera irovegaempa ishiriagakogematatyo kara, ogatyo agavagetanaka 38 shiriagarini. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yogari Jeso ineapaakeri noriaka yogotapaakerityo akatovaitakoti ishiriagakotaka imantsigatakera, ikantantapaakaririra: —¿Pikogake povegaempara? ");
INSERT INTO mcbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Irirori ikantiri: —Nokogavetakatyo kantankicha omirinka omareaatara nia mameri tyanimpa giaatakenane. Nopankinanavetaka naro tsikyata teratyo nagavee, pashinikyatyo visaana. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ikantiri Jeso: —Atsi tinaanake ganaero pinoriantakarira piatae. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Irorotyo ikantakerira ogatyo ikenake yovegapagenityo yaganairo inoriantakarira akya yanuitanai. Kantankicha ontitari kutagiteri apishigopireantaganirira, ");
INSERT INTO mcbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ikantaigutarityo itinkamiegi jorioegi: —Maika ontitari kutagiteri apishigopireantaganirira tera kameti pamanakera pinoriantakarira, okantavitantaganitari. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Irirori ikantaigiri: —Yogari vegaanarira irirotari kantakena: ‘Ganaero pinoriantakarira piatae.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ovashi ikantaigakeri: —¿Tyanityora kantakempira? ");
INSERT INTO mcbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kantankicha irirori teratyo irogote tyani vegairi, yapatovageiganakatari kara, yogari Jeso paa atai. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Impogini Jeso ineairi ivankoku Tasorintsi ikantiri: —Maikari vegaavi, gara pimatairo aikiro pinkañovagetaempara. Pimataerorika aikiro omatashitanaempi pashini pairo ogagakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Irirori ishigamatanakatyo ikamantaigakerira itinkamiegi ikantaigakerira: —Iriroratyo vegaana Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ovashi ikisasanoiganakeri Jeso ikogaigavetaka irogaigakerimera ineaigakera yovegairira kutagiteriku apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kantankicha Jeso ikantaigiri: —Ariotari ikañotakari Apa irirori ikantakani yantavagetake, nokañotantakarorira naro aikiro omirinkara nantavagetake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ariompatyo ikisasanoiganakari itinkamiegi jorioegi ikogasanoiganakera irogaigakerimera, ineaigakeritari tera intagati irovegantemparo kutagiteri apishigopireantaganirira, ontityo aikiro ikañotagumanatanakari Tasorintsi ikantakera inti tomintari. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Impogini ikantaigiri Jeso: “Maika nonkamantasanoigakempi tatarika novetsiki tera tsikyata novetsikashitemparo naro, intagatityo novetsiki yovetsikagetirira Apa. Tatapagerika ipiriniventi irirori, irorotyo nopiriniventi naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yogari Apa itasanovagetakenatyo, nerotyo tera tatoita iromanapitsatumatena, kantankicha impogini iragaveakagakena novetsikakera pashini pairorira avisakero pineaigakerira maika ovashi pogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yogari Apa yogitinajaigiri kamageigavetankicharira yoganiaigairi. Ariotyo nokañotaka naro, tyanirika nokogake noganiaerira noganiaerityo kameti inkantakaniniri intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aikiro Apa tera iriro kantatsine tyara inkantakenkani paniropage matsigenka impogini, nanti ikantake nonkantakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ario ikañotakero maika kameti impinkatsaigakenaniri maganiro inkañotagaigakenara ipinkatsataganira irirori. Tyanirika terira impinkatsatena naro tera impinkatsateri aikiro Apa, irirotari tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Maika nonkamantasanoigakempi tyanirika kemakerone noniane ovashi inkematsatakeri tigankakenarira inkantakani intimake gara ikisashitumatagani. Antari tekyara inkematsate kañomataka ontinirikatyo ikamake kantankicha impo ikematsatakera onti yoganiaagani garatyo ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aikiro nonkamantasanoigakempi mataka gapaaka kutagiteri inkemantaigakemparorira noniane yogaegi tekyarira iroganiaigenkani, impo naro noganiaigakeri maganiro kematsaigakenanerira, nantitari Itomi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kañotari Apa yoganiantira, ario ikañotagakena naro aikiro kameti noganiantakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aikiro ikantakena naro kantankitsine tyara inkantakenkani paniropage matsigenka impogini, nantitari Kañotasanotakaririra Matsigenka. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Gara pogavageigi kavako, agakempatari kutagiteri nonkaemaigakerira maganiro kamageigavetankicharira. Iroro inkemaigakenara oga inkenaigake intinajaiganae. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yogari vetsikaigankitsirira kametiri intinajaiganae iriaigake enoku inkantakanira intimaigake. Irirokya vetsikaigankitsirira terira onkametite intinajaigavetanakempa kantankicha onti iriaigake morekariku inkantakanira iratsipereavageigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Tera tatoita novetsikumate tsikyata. Tatarika ikantake Apa, iroro nokantake naro, aikiro katinka nogagetiro magatiro nokantakerira, teranika iroro nompokashite novetsikakera tatarika oita nokogake naro, ontityo nopokashitake novetsikakera magatiro ikogakerira Apa tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Antari paniromera nonkamantakotakempa naro nonkantakera inti tigankakena Tasorintsi, ario pinkante kametitaketyo pinkantaigakera: ‘Garatyo nokematsaigiri, ikiirotari kamantakotaacha.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kantankicha aiño pashini kamantakotakenarira. Naro nogotake onti ikantasanotake ikamantakotakenara tera iramatagumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Antari pitigankaigakera inkogakotagantaigakiterira Joan, irirori katinka yogakero ikamantakotakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kantankicha tera ario nonkantaigempi maika noneakera nokogakotakara inkamantakoitakenara, teranika nonkogakotumatempanika. Ontityo nokantaigakempi kameti pinkematsaigakera irogavisaakoigakempiniri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yogari Joan onti ikañovetakari mechero tenenkakoigakeririra pavatsaakoigavetankicharira. Viroegi tainatyo pishineventasanoigavetakari impo papakuaiganairi. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kantankicha antari novetsikagetakerora magatiro ikantakenarira Apa novetsikagetakera iroro ogotantasanotunkani iriro tigankakena. Pairotyo avisakero ikamantakotakenara Joan. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ario ikañotaka Apa irirori ikamantakotakenatyo, irirotari tigankakena, kantankicha viroegi tera pinkemumaigeri iriniaigakempira, aikiro tera pineaigeri tyarika ikantaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ario okañotaka Iriniane irorori okamantakovetakena, pikemaigavetakaro kantankicha teratyo pagaigavakero pisureegiku, teranika pinkogaige pinkematsaigenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Viroegi pipiriniventaigavetarotyo Itsirinkakagantakerira Tasorintsi pineaigakera iroro ganiaigakempine, kantankicha teratyo pinkogaige pinkematsaigakerira oniakotakerira kameti iroganiaigakempiniri pinkantakanira pintimaigake, narotari oniakotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Garika ishineventaigana matsigenka garatyo tyara okantana. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aikiro nogoigimpitari tera pintumaigempari Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Narori inti tigankavetakena Apa, viroegi teratyo pinkematsaigena. Kantankicha antari iripokera pashini garira tyani tigankiri tsikyatara iripokashitakemparo irirori ario pinkante pinkematsaigakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Tyara pinkantaigakempara pinkematsaigakenara? Ontitari pisureigaka pishineventavakagaigakempara, tera iroro pisuretumaigempa irishineventaigakempira Tasorintsisanorira panirorira ikanta irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gara pisureiga pineaigiri ariori nonkamantakeri Apa viroegi tera pinkematsaigeri. Aiñotyo pashini kamantakerineririra, irirotari Moiseshi paventasanoigarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Antari pinkematsatasanoigakerome itsirinkakerira Moiseshi pairani, pinkematsaigakenametyo naro aikiro, narotari itsirinkakotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Teranika pinkematsaigero itsirinkakerira irirori, ario tyara pinkantaigakempara pinkematsaigakenara naro.” ");
INSERT INTO mcbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Impogini Jeso imonteanakaro inkaare Garirea okantagani aikiro Tiveriashi. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yogiaiganakeri tovaini matsigenkaegi, ineaigakeritari yovetsikagetakera posante terira oneimagetenkani yovegageigamatirityo mantsigaigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yogari Jeso iatake otishiku itentaiganakari irogamereegi ipitaigake anta. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Atake ochoenitapaaka agantakemparira iviesetaegite jorioegi okantaganirira Pasekoa. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Impo yogari Jeso ineaigavakerira yogiaigapaakerira tovaini matsigenkaegi ikantiri Jeripe: —¿Tyara ampunaventaigake pan ampaigakerira isekataigakempara maganiro yogaegi? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Onti ikantakeri maika ineakera tyarika inkante Jeripe, kantankicha irirori yogotaketyo tyara iragakero. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Yogari Jeripe ikanti: —Nirorotyo, kañotari ampunaventaigera pan 200 tenario garorokarityo ogonketumata irogaigakempara paniropage maani. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ario inake kara pashini irogamere Jeso paitacharira Anturishi. Inti irirenti Sumo Perero. Impo inianake irirori ikantiri: ");
INSERT INTO mcbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Inti shintankicha yoga ananeki 5 pan ovetsikantunkanirira sevara intiri aikiro piteni shima, kantankicha itovaigavageti matsigenkaegi kara, garorokarityo omonkaratumatari. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yogari Jeso ikanti: —Atsi kantaigeri maganiro impirinitaigakera. Impo ovashi ipirinitaigake maganiro. Yogari surariegi ikaravageigaketyo 5,000. Karari kara ipirinitaigakera ontiratyo shimpenashi. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Impo yogari Jeso inoshikakero pan yapagotakero iniakeri Tasorintsi ikanti: “Apa, noshinevagetakatyo maika pipakenara nogaigakemparira.” Impo ipaigakeri irogamereegi, iriroegikya paigakeri maganiro pirinitaigankitsirira. Ario ikañotagakari shima irirori ipaigakeri akarika ikogaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Impo ikemaiganakara ikantaigiri Jeso irogamereegi: —Maika atsi patoigaero oga pan aityokyarira onai ganiri aparatumata. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iriroegi ovashi yapatoigairo yoyagaigairora tsivetaku shatekapagerikatyo kara onakotake 12. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iroro ineaigakera maganiro yovetsikakera Jeso terira oneimagetenkani yogitovaigakerora pan ikantaigake: —Arisanoniroro inti kamantantatsirira agiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kantankicha Jeso ineakera ikogaigakera iragaigakerira impegaigakerira igoveenkariegite yamereanaa iatai parikoti otishiku paniro yapuntanaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Impogini ochapinitanaira yogari irogamereegi Jeso yagateaiganai inkaareku ");
INSERT INTO mcbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","impo yomateiganaa pitotsiku imonteaiganaera iriaigaera Kaperenaoku. Atake apavatsaanaka kantankicha yogari Jeso tekya iripoke. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Impo otampiamatanaketyo omarane tampia jiriririri ovoresekantamatanaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Impo iatakoiganakera nigankia ariorika 5 ontirika 6 kirometero ineventaigari Jeso ikenapaake yanuiatapaakero enokua nia ogatyo ikenaigake itsarogavageigamatanaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kantankicha irirori ikantaigiri: —Nanti, gara pitsarogaigi. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Impo iriroegi ishinevageiganaa ovashi ikantaigakeri iromatetaempara. Irorotyo yomatetakara ogatyo ikenaigake paa gonkeigaka Kaperenaoku. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Impo okutagitetanakera maganiro patoventaigakaririra Jeso chapi isureiganaaro ineaigavairira irogamereegi iaiganaira tera intentaiganaeri irirori. Aikiro mameri pashini pitotsi, patirotari onakera ikenantaiganaarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Impo opokapaake pashinipage pitotsi oponiagetaka apatotara pankotsi paitacharira aikiro Tiveriashi. Agatagetapaake ochoenitakara yogaigakarora pan yogitovaigakerira Atinkami, ");
INSERT INTO mcbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","nerotyo yomatetantaiganakarora iriaigakera Kaperenaoku inkogaigakerira, ineaigaketari mameri tyarika iatake. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Impogini yogonkeigapaakara ineaigapaakeri Jeso ikantaigiri: —Gotagantatsirira, ¿tyatake pogonketaa aka? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kantankicha Jeso ikantaigiri: —Maika nonkantasanoigakempi tera iroro pinkogaviigena pineaigakenara nagaveakera novetsikakera terira oneimagetenkani, ontityo pineaigakera nopaigakempira pan pisekataigakara pikemaiganakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gara patiro pisuretakoigaro pisekaegi tsonkatanaachanerira, pisuretakotasanoigakemparotyo aikiro pisekaegi garira otsonkatumata onti onkantakani oganiaigakempi, irorotari impaigakempirira Kañotasanotakaririra Matsigenka, yagaveakagakeritari Tasorintsi irovetsikagetakera posantepage terira oneimagetenkani kameti pogoigakeniri iriro tigankakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iriroegi ikantaigiri: —¿Tatoita nantaigake kameti irishineventaigakenaniri Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ikanti Jeso: —Onti pinkematsaigakeri itigankakerira, irorotari ikogake irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ikantaigi: —¿Tatatyo pineakagaigakenara kameti noneaigakerora nogotantaigakemparora inti tigankakempi Tasorintsi? Atsi vetsikenityo pashini pinkañotagakemparora ");
INSERT INTO mcbNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","pairani inaigakera yashikiiganakenarira anta osarigagitetapaakera yogaigakarora manaa, ariotari okantakeri Itsirinkakagantakerira Tasorintsi okanti: ‘Ipaigakeri pan poniankicharira enoku.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yogari Jeso ikantaigiri: —Maika nonkamantasanoigakempi, tera iriro paigerine Moiseshi, intityo paigakeri Apa. Maikari maika onti ipaiganakempi pan poniasanotankicharira enoku. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ogari oga pan ipaigakempirira Tasorintsi irorotari poniankicharira enoku oganiaigakerira maganiro matsigenkaegi inkantakanira intimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ovashi ikantaigakeri: —Iroroventi maika omirinkara pimpaigakenaro oga pan. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ikanti Jeso: —Narotari pan ganiantatsirira. Tyanirika ventakenane gara itasegumatai. Ario inkañotake tyanirika kematsatakenane gara imiretumatai. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kantankicha maika nonkantaigakempi pineaigavetakenatyo tera pinkematsaigena. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Maganiro ikogakagaigakerira Apa inkematsaigakenara inkematsaigakenatyo, aikiro maganiro kematsaigakenanerira nogavisaakoigakerityo gara nokisumaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Teranika iroro nompokashite aka kipatsiku novetsikakera tatarika nokogake naro, ontityo nopokashitake novetsikakera ikogakerira tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ontitari ikogake nogavisaakotasanoigakerira maganiro ikogatagaigakerira inkematsaigakenara ganiri ipegumata paniro, onti noganiaigaeri impogini intinajaiganaera kamageigavetankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ikogaketari Apa inkantakanira intimaigake maganiro kematsaigakenanerira kantaigankitsinerira: ‘Arisanoniroro inti Itomi Tasorintsi itigankakerira irogavisaakotantakera.’ Impo naro noganiaigaeri impogini intinajaiganaera kamageigavetankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Irorotyo ikemaigakerira jorioegi ikantakera maika ogatyo ikenaigake iniashinaiganakari ikemaigakeritari ikantakera: “Nanti pan poniankicharira enoku.” ");
INSERT INTO mcbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ikantaigi: —¿Matsi tera iriro Jeso itomi Jose? Aneaigiritari iriri ontiri iriniro. ¿Tyara ikantakara ikantakera onti iponiaka enoku? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ikantaigutarityo Jeso: —Atsi gara pikañoigana maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gara tyani kematsatumatana tsikyata garira iriro kematsatagiri Apa tigankakenarira. Impo naro noganiaeri impogini intinajaiganaera kamageigavetankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Okantaketari itsirinkaigakerira kamantantaigatsirira okanti: ‘Tasorintsi irogotagaigakeri maganiro.’ Nerotyo tyanirika kemisantaigakerine Apa aikiro inkematsaigakeri inkematsaigakenatyo naro aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Tera tyani neimatrine Apa. Panirosanotyo naro noneakerira ariotari noponiakari iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nonkamantasanoigakempi tyanirika yoga kematsatakenanerira inkantakani intimake gara ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nantitari pan ganiantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pairani inaigavetakara yashikiiganakempirira anta osarigagitetapaakera yogaigavetakarotyo manaa kantankicha ineaigairotyo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kantankicha naro maika onti noniakotake pan poniankicharira enoku. Tyanirika gakemparone garatyo ineimatairo igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Narotari oga pan poniankicharira enoku. Tyanirika gakemparone inkantakani intimake, ontitari noniakotake novatsa nompaigakerira maganiro matsigenkaegi kameti inkantakaniniri intimaigake.” ");
INSERT INTO mcbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ovashi ikantavakagaiganaka jorioegi: —¿Tyara inkantakempa yoga impaigakaerora ivatsa agaigakemparora? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ikantaigiri Jeso: —Maika nonkamantasanoigakempi garika pogaigaro ivatsa Kañotasanotakaririra Matsigenka, aikiro garika poviikaigaro iriraa garatyo pikantakani pitimaigi. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Maganirotari gaigakemparone novatsa aikiro iroviikaigakemparo noriraa inkantakani intimaigake, narotari ganiaigaerine impogini intinajaiganaera kamageigavetankicharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ogari novatsa irorotari sekatsisanorira. Ario okañotaka noriraa irorori onti miretsisanorira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tyanirika gakemparone novatsa, aikiro iroviikakemparo noriraa inkantakani intentasanotakena, narokya nonkantakani nontentasanotakempari. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yogari Apa tigankakenarira ikantakani itimi, nerotyo ario nokañota naro aikiro nokantakani notimi, irirotari ganiana. Ario inkañotakempa tyanirika gakemparone novatsa noganiakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Onti noniakotake pan poniankicharira enoku. Irorori tera ario onkañotemparo manaa yogaigakarira yashikiiganakempirira impo ikamaigai. Kantankicha tyanirika gakemparone oga pan noniakotakerira maika inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ario ikañotakero maika Jeso yogotagantavagetakera pankotsiku yapatoitantaigarira jorioegi anta Kaperenaoku. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iroro ikemaigavakerira Jeso ikantakera maika oga ikenaigake tovaini giaiganakeririra ikantaiganake: —¿Tyarika ikantakara irirori ikantakera maika?, niganki otsimajaiganakai. Garorokarityo akematsatumaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Impo yogari Jeso ineaigakerira ikantaigutarityo: —¿Ario otsimajaiganakempi nokantaigakempirira? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iroroventi, ¿tyarikarorokari pinkantaiganakempa pineaigerira impogini yoga Kañotasanotakaririra Matsigenka iriataera enoku inavetara tekyara iripoke aka kipatsiku? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","¿Matsi agaveake vatsatsi aniakera tsikyata garira iroro ganiiro suretsi? Garatyo agaveimati. Ario okañotaka nokantaigakempirira maika iroro ganiaigakerine kematsaigakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kantankicha aiño pikonogagarantaigaka tera pinkematsaigena. Yogari Jeso igantagatari yogotakera okyara tyani gara ikematsaigiri, aikiro tyani gakagantakerine. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Impo ikanti: —Irorotari nokantantaigakempirira gara tyani kematsatumatana tsikyata garira iriro kematsatagiri Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Impo ovashi ikonogagarantaigaka giavageigavetakaririra Jeso yapakuaiganai tenige irogiavageigaeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Impo Jeso ikantaigiri irogamereegi: —¿Pikogaigake piaigaera viroegi aikiro? ");
INSERT INTO mcbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kantankicha yogari Sumo Perero ikantiri: —¿Ario tyanityora noatimoigaera?, mameritari pashini. Panirotari pikantakara viro pogotagaiganara tyara nonkantaigakempa nonkantakanira nontimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Naroegi nokematsaigakempi, aikiro nogoigake vinti Itomi Tasorintsi, irirotari tigankakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ikantaigiri Jeso: —¿Matsi tera naro kogakagaigempine maganiro viroegi 12 pimpegaigakempara nogamereegi? Kantankicha aiño paniro inti shintakari kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Antari ikantakera Jeso maika intityo ikantake Jorashi itomi Sumo Ishikariote, irirotari gakagantakerine impogini. Irirotyo inavetakara irogamere kantankicha impogini iparantakarityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Impogini yogari Jeso tera inkoge iriatakera Joreaku, yogotaketari ikogaigakerira jorioegi irogaigakerira. Ovashi ikantakani inakera Garireaku yogotagantavagetakera kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kantankicha impogini ataketari ochoenitapaaka iviesetaegite jorioegi yovashitantavageigarira, ");
INSERT INTO mcbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","yogari irirentiegi Jeso ikantaigiri: —Atsi piate Joreaku pinkañotakempara maika povetsikakera posante terira oneimagetenkani kameti ineaigakempiniri pashini pogamereegi naigankitsirira anta. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Imirinkatari tyanirika kogankitsi ineakenkanira, ¿matsi ario yomanakotakero yovetsikagetirira? Maikari viro irorotari pagaveakera povetsikagetakera posante atsi piatenityo povetsikagetakerora anta kameti ineaigakempiniri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ariotari ikañoigakari irirentiegi aikiro tera inkematsaigeri nerotyo ikantantaigakaririra maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kantankicha Jeso ikantaigiri: —Tekyatanika agempa noatakera, kantankicha viroegi kametitaketyo piaigakera tyatirika kutagiteri pimpintsatantaigakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mameritari tatampa inkisaviigakempi iriroegi. Narori ontitari ikisaviigakena nokantakera onti yovetsikagisevageigake terira onkametite. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Piaigetyo viroegi. Narori gatatatyo noati, tekyatanika agempa noatantakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ikantaigakerira maika ovashi tera aiñokya iriate. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kantankicha antari iaigakera irirentiegi iatake irirori yompogitanake. Tera ario intentaiganakeri itovaire, teranika inkoge ineakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yogari itinkamiegi jorioegi patoitaigankicharira kara iviesetaegiteku ikogaigakerityo ikantaigi: —¿Tyarikatyo inake kara irirori? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iniakotunkanityo kara, pashini kantankitsi inti kameti inavageti, pashinikyatyo kantankitsi teratyo inkametite, yamatavinatantavagetaketari. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kantankicha tsikyani iniavakagaigaka tera inkemakagantaigempa, ipinkaigakeritari itinkamiegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Antari onigankitanakera iviesetaegite ario pinkante iatake Jeso ivankoku Tasorintsi yogotagantavagetakera kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ogatyo ikenaigake itinkamiegi jorioegi yogavageiganake kavako ikantaiganakera: —¿Tyarikatyo ikantakara yogotakera posante? Teranika irogotagasanotenkani Iriniane Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kantankicha Jeso ikanti: —Ogari nogotagantakerira maika tera tsikyata nagashitemparo naro. Intityo gotagakena tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tyanirika kogankitsine irovetsikakerora ikogakerira irirori irogotake irirorika gotagakena ontirika tsikyata nagashitakaro naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yogari tsikyatarira yagashitaro irirori onti ikogakera irishineventakenkanira, kantankicha yogari kogatsirira intaganira irishineventakenkani tigankakeririra onti katinka yogakero tatarika ikantake, tera iramatagumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Pairani Moiseshi itsirinkaigakempiro ikantagetakerira Tasorintsi kameti pintsatagaigakerora, kantankicha maika tera intimumate paniro tsatagagetakeronerira. ¿Tyara okantakara pikisaviigakenarora pikogaigakera pogaigakenara?” ");
INSERT INTO mcbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Impo iniaiganake maganiro ikantaigiri: —¡Virori inti tinkamitakempi kamagarini! ¿Matsi tyanityo kogankitsi irogakempira? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ikanti Jeso: —Arioniroro pineaigakera novetsikakera patiro terira oneimagetenkani kutagiteriku apishigopireantaganirira ovashi pogavageiganake kavako. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yogari Moiseshi ikantake ogaratsaitakenkanira ichonkirimeshinaegite ikyaenkarira mechoigankitsi aganakempara 8 kutagiteri, kantankicha tera paniro inkante irirori, igantagatari itsitiigakerora yashikiiganakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kañotari viroegi pineaigira okatinkatirira ananeki irogaratsaitenkanira kutagiteriku apishigopireantaganirira tera ario pogavisaigero, pogaratsaigirityo kameti pintsatagaigakerora ikantirira Moiseshi. Iroroventi, ¿tyara okantakara pikisaviigakenarora pineaigakera novegairira mantsigatankitsirira kutagiteriku apishigopireantaganirira? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gara pigenanekya pikisaiga pinkantaigakera ovetsikunkani terira onkametite. Oketyo pisuretasanoigakemparo irororika ovetsikunkani terira onkametite ontirika kametiri, impo katinka pogaigakero pinkantaigakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Impogini ikonogagarantaigaka timaigatsirira Jerosarenku ikantaiganake: —¿Matsi tera iriro yoga ikogunkanirira irogakenkanira? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Tyara okantakara maika yapatoventanunkanira ikenkitsavagetakera tera tyara inkantenkani? Impa ariorakari imaiganaka atinkamiegi iriroegi ikantaiganakera inti Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kantankicha aroegi agoigake tyara iponiaka yoga. Antari irirora pokankitsine pegankichanerira Agoveenkariegite garatyo yogotumatagani tyarika iponiaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yogari Jeso aiñokyara yogotagantavagetake ivankoku Tasorintsi ikimoenkamatanaketyo ikanti: —Arisanoniroro viroegi pogoigake tyara noponiaka, pineaiganatari. Kantankicha aiñotyo tigankakenarira, irirotari ikematsavintsataganirira terira pogoigeri viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Narori noneiri, ariotari noponiakari iriroku, irirotari tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Impo ovashi ikogaigavetaka inoshikaiganakerimera iramaiganakerira irogakagantaigakerira, kantankicha teratyo tyani noshikerine, tekyatanika agempa inkamantakemparira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kantankicha itimagarantaigake tovaini kantaigantitsirira: —Irironiroro Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite. ¿Matsi iripokera pashini ario iravisakeri yoga irovetsikakera posante terira oneimagetenkani? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Impo yogaegiri pariseoegi ikemaigakera iniakotunkanira Jeso ishineventunkanira ovashi itentaigakari itinkamiegi saseroroteegi itigankaigakera soraroegi sentaigirorira ivanko Tasorintsi iragaigakiterira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kantankicha Jeso ariompatyo iniavagetanakeri ikanti: —Gara samani notimimoigimpi aka. Shintsi nompiganae inakera tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Impogini pinkogaigavetaena gara pineaigaana, gatanika pagaveaigi piaigera viroegi tyarika noatake naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ogatyo ikenaigake itinkamiegi jorioegi ikantavakagaiganaka: —¿Tyarikatyo iriataera kara nerotyo gara aneaigairi? Impa ariorakari iriatake intimimoigakerira atovaireegi tivarokaiganankicharira konoiigakaririra guriegoegi irogotagaigakerira iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tatarikatyo ikantake inkaara ikantakera: ‘Impogini pinkogaigavetaena gara pineaigaana, gatanika pagaveaigi piaigera viroegi tyarika noatake naro’? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Impogini aganaa otsonkatantanaarira iviesetaegite. Okari oka kutagiteri pairotyo ishineventaigaro. Yogari Jeso yaratinkanake inianake imaraenkarika ikanti: —Tyanirika miretankitsi inevitakenatyo naro nompakeri iroviikakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Okantaketari Itsirinkakagantakerira Tasorintsi okanti: ‘Tyanirika kematsatakenane onkantakanityo onkonteagetake nia ganiantatsirira isureku.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Antari ikantakera Jeso maika inti iniakotake Isure Tasorintsi timasurentaigakerineririra maganiro kematsaigakerineririra, tekyatanika iripokenika intimasurentantakera, tekyatanika iriatae Jeso enoku. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Impo ikemaigakerira maganiro ikonogagarantaigaka ikantaiganake: —Arisanoniroro inti kamantantatsirira agiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pashinikya kantaigankitsi: —Inti Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite. Kantankicha pashinikyatyo kantaigankitsi: —¿Matsi ario imponiakempa pegankichanerira Agoveenkariegite Garireaku? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Okantaketari Itsirinkakagantakerira Tasorintsi okanti yogari Ikogakagakerira impegakempara Agoveenkariegite onti tomintakemparine iyashikitanakerira Iravi. Onti imechotake Verenku imechotira Iravi. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ovashi tera inkemavakagaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ikonogagarantaigaka ikogaigavetakatyo inoshikaiganakerimera iramaiganakerira irogakagantaigakerira, kantankicha teratyo tyani noshikerine. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Impo yogaegiri soraroegi aigavetankicharira iragaigakiterimera ipigaigaa kogapage inaigakera pariseoegi intiegiri itinkamiegi saseroroteegi. Iriroegi ikantaigavakeri: —¿Yoga? ¿Tyara okantakara tera pamaigakeri? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Iriroegi ikantaigi: —Nokemaigakeritari yogotagantakera tyarika yogovagetiratyo kara. Teratyo nonkemumaigeri pashini inkañotakemparira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yogari pariseoegi ikantaigiri: —¿Matsi mataka imaigakempi viroegi aikiro yamatavinaigakempira? ");
INSERT INTO mcbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yogari atinkamiegi teranika inkematsatumaigeri. Ario nokañoigaka naroegi pariseoegi teratyo nonkematsatumaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yogaegiri terira irogotumaigero itsirinkakotanakerira Moiseshi iriro pinkante ikañoigakaniroro ikematsaigakerira, kantankicha inkisashiigakemparityo Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ario inake kara Nikoremo ataninkutatsirira okyara ikamosotakitirira Jeso, intitari irirori pariseo. Iniamatanaketyo ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Okantavitantaganitari ankisashitantempara kogapage garira oketyo akemaigiri iriniakera kameti agotasanoigakera tatoita yovetsikake. Ariotari okantakeri otsirinkakotunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ikantaigutarityo iriroegi: —Vintikyataketyo viro, ariorokari piponiaka aikiro Garireaku. Atsi piriniventeronityo Itsirinkakagantakerira Tasorintsi pineakerora tera onkantumate imponiakempara kamantantatsirira Garireaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ovashi yapakuaiganai iageiganai ivankoegiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kantankicha yogari Jeso iatake otishiku Orivoshi, ");
INSERT INTO mcbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","impo okutagitetanaira iatamanai ivankoku Tasorintsi. Ogatyo ikenaigai yapatoventaiganaari tovaini matsigenkaegi ovashi ipirinitake yogotagaigairira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Impo yogaegiri gotagantaigirorira itsirinkakotanakerira Moiseshi intiegiri pariseoegi yamaigapaakero tsinane oneavitunkanirira surari yogaratinkaigapaakero niganki kara yapatoitaigakara ");
INSERT INTO mcbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ikantaigiri Jeso: —Gotagantatsirira, okari oka tsinane itimavetaka ojime kantankicha ovoteavitunkani pashini surari. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ogari itsirinkakotanakerira Moiseshi okantake maganiro tsinaneegi kañoigacharira maika ompitankakenkani ogakenkanira. Maikari maika viro, ¿tyara pinkante? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iriroegi ontityo ikantaigakeri maika ineaigakera tyarika inkante kameti intsavetantaigakerira inkisakagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kantankicha irirori teratyo tyara inkante, onti yogivotanaka itsirinkavatsatanakera ichapakiku. Impo ineakera atanatsira inianiaiganakeri yogivoreita ikantaigiri: —Tyanirika terira inkañovagetumatempa iketyo ivatashitakerone impitankakerora. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Impo akya yogivotanaa itsirinkavatsatanaira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iroro ikemaigakerira ikantakera ogatyo ikenaigake iageiganai. Iketyo ivaiganaatsi antariniegisanorira. Paniropagekya aiganaatsi ovashi itsonkaiganaa maganiro. Panivani inai Jeso itentaarora tsinane. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Impo yogivoreavetanaka mamerigitevagetake, panivani aratinkai irorori ovashi ikantiro: —¿Tyara iaigake maigakempirira inkaara? ¿Tera tyara inkantumaigempi? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Irorori okantiri: —Teratyo. Impo ikantiro: —Ariotyo nonkañotakempa naro garatyo tyara nokantimpi. Maika piatae gara pimatumatairo aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Impogini Jeso inianai aikiro ikanti: —Nanti kutagitetakotantatsirira. Tyanirika kematsatakenane garatyo yapavatsaakotumata, narotari kutagitetakotakerine kameti inkantakaniniri intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yogari pariseoegi ikantaigiri: —¿Matsi ario nonkematsaigakempi pikantakera inti tigankakempi Tasorintsi?, vikiirotari kamantakotaacha. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kantankicha Jeso ikantaigiri: —Nakiirotyo kamantakovetaacha, kantankicha arisanotyo nokantake tera namatagumatempa. Nogotaketari tyara noponiaka, aikiro tyara noatae, kantankicha viroegi teratyo pogotumaige tyara noponiaka, aikiro tyara noatae impogini. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Viroegi ontityo pikisashiiganakena kogapage, teratyo pineasanoigavetena. Narori maika tera tyani nonkisashitempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kantankicha nonkisashitantempara gara ario nokisashitanta kogapage, teranika tsikyata nogotagashitemparo naro, intitari kantakena Apa tigankakenarira, irirori ikantakani itentakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Otsirinkakotunkanitari okanti: ‘Intimakerika piteni matsigenka intsavetakoigakero tatarika ineaigake ario inkañovakagaigakempa gara ikantatigumatiro kametitake inkematsatakenkanira.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ariotyo nokañotaka naro nakiirotyo kamantakovetaacha, kantankicha tera paniro nonkamantakotempa naro, ikamantakotakenatyo aikiro Apa tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iriroegi ikantaigiri: —¿Tyara inakera Piri kara? Ikantaigiri Jeso: —Tera pogoigenanika naro teniroro pogoigeri Apa. Antari pogoigakename naro ario pinkante pogoigakerimetyo aikiro irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Magatiro oka ikantakerira Jeso onti yogotagantake ivankoku Tasorintsi ipirinitakera onakera yoyagantaganirira koriki ipapinitaganirira Tasorintsi. Kantankicha teratyo tyani noshikerine iramanakenkanira irogakagantakenkanira, tekyatanika agempa iragantakenkanirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Impo yogari Jeso ikantutaigaarityo aikiro: —Narori noatae. Viroegi pinkogaigavetaena garatyo pineaigaana, gatanika pagaveaigi piaigera tyarika noatae. Ariompatyo pinkañovageiganakempari kigonkero pinkamaiganakera piaigakera morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yogaegiri itinkamiegi jorioegi ikantaiganake: —¿Matsi ario tsikyata inkisashitakempa inkamakera nerotyo ikantantakarira gara agaveaigi aigakera tyarika iriatake? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kantankicha Jeso ikantaigiri: —Viroegi vintiegi kipatsikunirira, narori onti noponiaka enoku. Viroegi ariotari pitimasanoigiri aka, narori teratyo. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Irorotari nokantantaigakempirira ariompatyo pinkañovageiganakempari kigonkero pinkamaiganakera piaigakera morekariku. Garika pikematsaigana nokantakera inti tigankakena Tasorintsi piaigaketyo morekariku. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iriroegi ikantaigiri: —¿Tyanimpatyora viro? Ikanti Jeso: —Matakaniroro nokamantaigavetakempi tera pinkematsaigena. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aikiro aityokya tovaiti nonkantaigakempimera onkañotagantaigakempimera, kantankicha intagati nonkantake ikantakenarira tigankakenarira. Irirori katinka yogakero ikantakerira tera iramatagumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kantankicha iriroegi teratyo irogoige inti iniakotanake Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Irorotari ikantantakarira Jeso: —Antari pogaenokakoigakeririka Kañotasanotakaririra Matsigenka ario pinkante pogoigake arisano nokantasanotake nokantakera iriro tigankakena Tasorintsi. Aikiro pogoigake tera tatoita novetsikumate naro tsikyata. Intagatityo nokanti tatarika ikantakena Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Irirori ikantakanitari itentakena, irirotari tigankakena. Tera iokumatena paniro, omirinkatari nopiriniventiro ishineventakarira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Antari ikantakera maika oga ikenaigake ikematsatagarantaigakeri tovaini ikantaigakera: “Irironiroro tigankakeri Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Impogini Jeso ikantaigiri: —Viroegi pinkantakanirika pinkematsaigakena nokantaigakempira maika pimpegasanoigakempa nogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pinkañoigakemparika maika ario pinkante pogotasanoiganake arisano nokantasanoti tera namatagumatempa ovashi pintimashiigaemparo kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ikantaigutarityo iriroegi: —Nantiegitari iyashikiiganakerira Averan. Tera intimumate shintaiganarira. ¿Tyara okantakara pikantakera: ‘Pintimashiigaemparo kogapage’? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ikantaigiri Jeso: —Nonkantasanoigakempi, maganiro kañovageigacharira tera intimashiigemparo kogapage, agaveaigakeritari kañovagetagantsi tyampa inkantaigakempa ishintsitashiigakerora. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pine yoga nampiriantsi tera inkañotempari itomi shintakaririra, teranika iriro itomi. Inkogera impimanterira impimantakerityo, kantankicha yogari irashisano itomi garatyo ipimantumatiri parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pine naro maika nanti Itomi Tasorintsi, narora pakuakagaigempirone agaveaigakempira kañovagetagantsi ganigetyo agaveimaigaimpi, onti pintimashiiganaemparo kogapage. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nogotaketyo vintiegi pinaigavetaka iyashikiiganakerira Averan, kantankicha pikogaigaketyo pogakagantaigakenara, teranika pinkogaige pinkematsaigakenara nokantaigakempira maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Narori intagati nokantaigimpi tatarika ikantakena Apa. Ario pikañoigaka viroegi onti povetsikaigi tatarika ikantaigimpi piriegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iriroegi ikantaigiri: —¡Intityo yashikiiganakena Averan! Kantankicha Jeso ikantaigiri: —Irirome yashikiiganakempime Averan pinkañoigakemparimetyo irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kantankicha tera ario pinkañoigempa maika. Nokamantaigavetakempityo ikantakenarira Tasorintsi katinka nogakero, kantankicha viroegi onti pikogaigake pogakagantaigakenara. ¡Teranika ario inkañotero Averan maika! ");
INSERT INTO mcbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Viroegi onti pipiriniventaigi ipiriniventirira piriegi. Iriroegi ikantaigiri: —¿Matsi pashiniratyo tomintaigakena? Intityo tomintaigakena Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yogari Jeso ikantaigiri: —Irirora tomintaigakempime Tasorintsi pintaigakenamerorokari, ariotari noponiakari iriroku, teranika nompokashitemparo naro tsikyata, irirotyo tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tyara okantakara tera pinkemaigavakero nokantaigakempirira? Ontitari kantankicha tera pinkogumaige pinkematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yogari tomintaigimpirira inti kamagarini, irirotari shintaigimpi. Viroegi intagati pikogaigake povetsikaigakera ikogakerira irirori. Irirori inti gantatsirira igantaga ikañotakara pairani okyasanokyara ovashi maika Tera inkantumate arisanorira, teranika irishineventumatemparo. Omirinkatyo itsoegaka, irashitari yogakero okyara itsoegakara. Inti tsoenti, irirotari oponianta tsoegagantsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nerotyo pikañotantaigakarira maika tera pinkogaige pinkematsaigenara, ontitari nokantasanoti arisanorira tera nontsoegumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Matsi ario pineaigakena novetsikakera terira onkametite? Teratyo. Iroroventi ¿tyara okantakara tera pinkematsaigena?, omirinkatari nokantake arisanorira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yogari yashintarira Tasorintsi ikematsatakerotyo Iriniane. Kantankicha viroegi teranika iriro shintaigempine Tasorintsi teniroro pinkogaige pinkematsaigerora. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Impo yogaegiri jorioegi ikantaigutarityo: —Nokantasanoigakeniroro vinti samaritano, aikiro itimagutakempi kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yogari Jeso ikanti: —Teratyo intimagutumatena kamagarini. Narori onti nopinkatsavagetiri Apa noshineventakarira, kantankicha viroegi tera pinkogaige pimpinkatsaigakenara pishineventaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Narori tera tsikyata nonkoge impinkatsaitakenara irishineventaitakenara, kantankicha aiño paniro kogankitsirira inkañoitakenara maika. Irirori inkisashiigakempari maganiro kisaigakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Maika nonkamantasanoigakempi tyanirika kematsatakenane garatyo ineimatiro igamane. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ikantaigiri iriroegi: —Arisanoniroro itimagutakempi kamagarini, pikantaketari: ‘Tyanirika kematsatakenane garatyo ineimatiro igamane’, kantankicha Averan intiegiri maganiro kamantantaigatsirira ikamaiganaityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Matsi pairo pavisakeri Averan yashikiiganakenarira? Irirori ikamanaityo, ario ikañoiganaari kamantantaigatsirira iriroegi. ¿Matsi tyanimpatyora viro pikantakera maika? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ikantaigiri Jeso: —Antari nakiiromera kantaatsine nokantaigakempirira maika, ¿matsi tyara nonkantakero? Kantankicha inti kantankitsi Apa pikantaigakerira viroegi inti Tasorintsi pikematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kantankicha teratyo pogoigeri. Narori pinkante nogotiri. Antari nonkantera tera nogoteri ontirorokari nontsoegakempa nonkañoigakempira viroegi pitsoegaigara. Kantankicha naro arisanotari nogotiri, aikiro nokematsatiri tatarika ikantakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pairani yogari Averan yashikiiganakempirira ishinevagetakatyo ineakera agakempara kutagiteri nompokantakemparira, impo ineakenara nopokakera pairotyo ishinetasanovagetaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Impo ikantaigiri: —Tekyaenka pishiriagakotumatempa 50 shiriagarini pikantake pineakeri Averan. ¿Tyaratyo pikantakara? ");
INSERT INTO mcbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kantankicha irirori ikantaigiri: —Maika nonkamantasanoigakempi tekyaenkara intimumate Averan, narori nogantaga notimakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iroro ikemaigavakerira ogatyo ikenaiganake inoshikaiganake mapu impitankaigakerimera, kantankicha irirori asatyo ipegapitsaigakari ikontetanai iataira. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Impogini yogari Jeso ikenanake kara ineapaakeri surari terira inee, kantaka ikyara mechotankitsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yogari irogamereegi ikantaigiri: —Gotagantatsirira, ¿tyara ikantakara imechotakera kañotaka maika? Impa irororakari kantankicha ikañovageigakara tomintaigaririra, terika irirorakari kañovagetankicha. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ikantaigiri Jeso: —Teratyo iroro kañotagerine ikañovagetakara, aikiro teratyo iroro kañotagerine ikañovageigakara tomintaigakaririra. Ontityo ikañotaka maika kameti oneakenkanira iragaveane Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Antari kutagiteriku antavagetagani, impo ochapinitumatanaira tenige antavagetaenkani. Ario okañotaka maika aityokyara okutagiteti kametitake avetsikaigakerora ikantakenarira tigankakenarira, panikyatari onchapinitanae. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Maika aiñokyanara aka kipatsiku onti nokutagitetakoigakeri maganiro matsigenkaegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Impo iroro ikantakera maika itoatanake kipatsiku yovevitsaakero maani impo itiriokitantakari terira inee ");
INSERT INTO mcbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ikantiri: —Piate kivaatempa omonkiaku Suroe (onkantakera: “Itigankunkani”). Irirori iatake ikivaata impo ipokavetaa paa neasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yogaegiri itentagaigarira itimaigira intiegiri neaigiririra ipirinitira inevitantavagetira ikantaiganake: —¿Matsi tera iriro yoga nevitantavagetatsirira? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ikonogagarantaigaka ikantaigake: —Jeeje, irironiroro. Pashinikya kantaigankitsi: —Teratyo iriro, ontityo ishigakerira. Kantankicha irirori ikantaketyo: —Narotyo. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Impo ikantaigiri: —¿Tyara okantakara maika pineakera? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Irirori ikantaigiri: —Yogari paitacharira Jeso yovevitsaashitakena kipatsi itiriokitakena impo ikantakena: ‘Piate kivaatempa omonkiaku Suroe.’ Impo noatake nokivaata oga nokenake noneanake. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iriroegi ikantaigiri: —¿Tyara inakera irirori maika? Irirori ikanti: —Niroro. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Impogini iriroegi yamaiganakeri inaigakera pariseoegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Antari yovevitsaashitakerira Jeso kipatsi itiriokitakerira onti kutagiteri apishigopireantaganirira, ");
INSERT INTO mcbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","nerotyo ikogakotagantantaigakaririra pariseoegi tyara ikantanaka ineanakera. Irirori ikantaigiri: —Onti yovevitsaashitakena kipatsi itiriokitakena impo nokivaa ovashi noneanake. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Impo ikonogagarantaigaka ikantaigake: —Yogari kañotakerorira maika teratyo iriro tigankerine Tasorintsi, yantavagetantakarotari kutagiteri apishigopireantaganirira, teranika intsatagero itsirinkakotanakerira Moiseshi. Kantankicha pashinikyatyo kantaiganankitsi: —Irirora kañovagetacharira, ¿ario tyara inkantakempara iragaveakera irovetsikakera terira oneimagetenkani kañorira oka? Ovashi tera inkemavakagaigempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nerotyo ikogakotagantantaigaaririra aikiro terira ineavetempa ikantaigiri: —¿Virori tyara pinkante? ¿Iriro tigankakeri Tasorintsi ontirika tera? Irirori ikanti: —Naro nokanti inti kamantantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kantankicha yogaegiri jorioegi teratyo inkogaige inkematsaigakerira ikantakera ineakagunkani nerotyo ikaemakagantantaigakaririra tomintaigakaririra ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Iriro yoga pitomi pikantaigakerira imechotake tera inee? ¿Tyara ikantanakara maika ineanakera? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Iriroegi ikantaigiri: —Irironiroro notomi kantaka ikyara mechotankitsi tera inee. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kantankicha maika tera nogoige tyara ikantanaka ineanakera, aikiro tera nogoige tyani neakagakeri. Atsi kantaigerityo irirori, intitari antarini tsikyatatyo inkamantaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iriroegi onti ikantaigake maika ipinkaigakerira itinkamiegi jorioegi, ikantaigaketari tyanirika kantankitsine Jeso inti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi inkantavitakenkani ganiri ikiimatai pankotsiku yapatoitantaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Irorotari ikantantaigakarira: “Atsi kantaigerityo irirori, intitari antarini.” ");
INSERT INTO mcbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Impo yogaegiri jorioegi ikaemaigairi terira ineavetempa ikantaigakerira: —Maikari maika atsi kamantasanoigena gara pitsoega, ineakempitari Tasorintsi. Naroegi nogoigake yogari pikantakerira inkaara inti kañovagetacharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kantankicha irirori ikantaigiri: —Niroro, tera nogote irirorika kañovagetacharira ontirika tera, intagati nogotake okyara tera noneavetempa, maika neakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ikantutaigaarityo aikiro: —¿Tyara ikantakempi ineakagakempira? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ikantutaigaarityo irirori: —Nokamantaigavetakempiniroro inkaara tera pinkematsaigena. ¿Maika tyara okantakara pikogaigakera nomataerora aikiro nonkamantaigaempira? ¿Matsi ario pikogaigake pinkematsaigakerira viroegi aikiro? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ovashi ikisaiganakeri ikakitsaiganakerira impo ikantaigiri: —Virori vinti irogamere, naroegiri nantiegi irogamereegi Moiseshi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nogoigaketari yogari Tasorintsi iniakeri Moiseshi, kantankicha yogari yoga piniakotakerira maika tera nogotumaige tyara iponiaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Impo irirori ikantaigiri: —Je'ario. ¿Tyarikara pikantaigakara viroegi? Irirori ineakagavetakenatyo, kantankicha viroegi tera pogotumaige tyara iponiaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ogotasanotunkani yogari Tasorintsi tera inkemumaigeri kañovageigacharira iniaigirira. Intaganityo ikemaigi shineventaigaririra vetsikaigirorira ikogagetirira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tera inkemakotumatenkani pashini matsigenka iragaveakera ineakagakerira terira ineimate. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ario ikañotaka maika yoga noniakotakerira gamera iriro tigankiri Tasorintsi gamerorokari yagaveimati tatakona. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iriroegi ikantaigiri: —¿Tyara okantakara pikogakera pogotagaigakenara naroegi? Ariotyo pikañotaka viro pashi pogakero pikañovagetakara. Ovashi ikisasanoigakeri itigankaigairi parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Impogini yogari Jeso ikemakotakerira ikisunkanira itigankaaganira parikoti iatake ikogakerira. Impo itonkivoakari ikantiri: —¿Pikematsatakeri viro Kañotasanotakaririra Matsigenka? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Irirori ikantiri: —Atsi kamantena tyanityora Kañotasanotakaririra Matsigenka kameti nonkematsatakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ikantiri Jeso: —Pineakeriniroro, irirotari niakempi maika, narotari. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ogatyo ikenake itigeroaventanakari ikantiri: —Notinkami, maika nogotake iriro tigankakempi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Impo ikanti irirori: —Narori onti nopokashitake aka kipatsiku kameti ogotakenkanira tyanirika arisano opaitaka ikematsatakerira Tasorintsi, aikiro tyanirika tera inkematsateri kameti ineaiganakeniri terira ineaigavetempa, irirokya neaigavetacharira ganige ineimaigai. ");
INSERT INTO mcbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Impo yogaegiri pariseoegi naigankitsirira kara ikemaigakerira ikantakera maika ikonogagarantaigaka ikantaigakeri: —¿Matsi tera noneaige naroegi? ");
INSERT INTO mcbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ikantaigiri Jeso: —Gamera pineaigi gamerorokari pikañotagantaiga vikiiro, kantankicha maika pikantaigaketari pineaigake, mataka kañotagantaigakavi vikiiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Maika nonkamantasanoigakempi tyanirika tagutanakerone parikoti itantakotaganira ovisha gara ikeni sotsimoroku inti koshinti. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kantankicha yogari kenankitsirira sotsimoroku inti shintaririra. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yashireakotavakeri sentirorira sotsimoro. Yogari ovisha ikemaigavairi iniira. Impo ikaemaigakeri yogikonteigakerira, yogotirotari ivairo paniropage. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Impo itsonkatakerira yogikonteigakerira maganiro iatanake iivatanakera. Yogari ovisha yogiaiganakeri, ikemaigavakeritari iniira. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kantankicha garatyo yogiatumaigiri pashini terira iriro shintemparine, ontityo irishigapitsaiganakeri, gatanika ikemaigavairi iniira, teranika ineimaigeri.” ");
INSERT INTO mcbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yogari Jeso ikañoigakeri maika ikantakotantakera, kantankicha iriroegi teratyo irogoige tatoita ikantakotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Impo ikantaigairi aikiro: “Maika nonkamantasanoigakempi, nanti sotsimoro ikenantapiniigarira ovisha. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Maganiro iketyorira ivaigavetankicha tekyara nompoke naro intiegi koshintiegi, kantankicha yogari novishate teratyo inkematsaigeri ikaemaigavetakarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nanti sotsimoro ikiantarira ovisha. Tyanirika kematsatakenane irogavisaakotakenkani impo nosentasanoigakerityo kara nonkañotagaigakempari isentasanotaganira ovisha ikontetapiniigake isekatapiniigakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Yogari koshinti intagati ipokashitake inkoshitakerira ovisha irovetisakerira impogereakerira, kantankicha naro onti nopokashitake noganiaigakerira inkantakaniniri intimaigake, onti intimagantsivageigake kameti irishinevageigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nanti shintasanoigaririra kematsaiganarira nosentasanoigiri, kañotakana shintaririra ovisha isentasanotirira irovishate. Pine yoga shintasanotaririra irovishate inkamaventakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kantankicha irirorika sentakerine pashini terira iriro shintemparine intagati ipunatunkani irisentakerira garatyo ikamaventumatiri. Ineimatavakerira garirira ovisha iripokapaakera oga inkenake irishigapanute irovashigantapanutempari ovisha, teranika iriro shintemparine. Impo yogari garirira iragagarantake irogakemparira, yogari itovaire onti intivarokaigakeri parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yogari ipunatunkanirira irisentakerira ovisha ishiganaka, teranika iriro shintemparine, intagatitari ipunatunkani irisentakerira nerotyo tera intsarogakagempari. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nanti shintasanoigaririra novishate nokantakani nosentasanoigiri, aikiro noneasanoigiri. Ario ikañoigaka iriroegi ineaigana, ");
INSERT INTO mcbNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kañotaka Apa ineanara naro, impo ario nokañota naro noneiri. Aikiro nonkamaventakeri novishate. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Maika aiñokya pashini novishate inagetake parikotipageku, kantankicha naro namaigakerityo nontentagaigakerira itovaire, inkematsaigakenatari nonkaemaigakerira. Impo nampatoitakerira maganiro panirotyo naro nosentasanoigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Narori tsikyata nonkamaventakeri novishate kameti nanianaera, irorotari itasanotantanarira Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gara tyani gaveatsi irogamagakenara tsikyata, tsikyatatyo nonkantake naro tyati nonkamantakempa. Irirotari kantakena Apa nonkañotakempara maika, nerotyo maika nagaveaketyo nonkamanakera aikiro nanianaera.” ");
INSERT INTO mcbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Impo ikemaigavakerira jorioegi ikantakera maika ogatyo ikenaigake tenige inkemavakagaigaempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ikantaigaketari tovaini: —¿Tyara okantakara pikematsaigakerira?, ontitari itimagutakeri kamagarini, aikiro onti ipigatake. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kantankicha pashinikyatyo kantankitsi: —Tyanirika itimagutake kamagarini ¿matsi ario inkañotake iriniakera maika? ¿Matsi iragaveake kamagarini ineakagakerira terira inee? ");
INSERT INTO mcbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Antari okatsinkagitetanaira yogari jorioegi yapatoventaigaaro iviesetaegite Jerosarenku isureigaarora osaankantaaganirira ivanko Tasorintsi pairani ashirikotaaganira irashi irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yogari Jeso yanuivagetake kara sotsi ivankoku Tasorintsi ovetsaenkakara otinkamipoa okakaratsenkoatakera okantaganirira Irashi Saromon. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yogari jorioegi yapatoventaiganakari ikantaigiri: —Nogiaiginityo karanki tekyaenka pinkamantumaigena tyanimpatyora viro. Virorika ikogakagake Tasorintsi pimpegakempara Nogoveenkariegite atsi kamantasanoigenanityo maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Irirori ikantaigiri: —Matakaniroro nokamantaigavetakempi tera pinkematsaigena. Aikiro novetsikagevetakaro magatiro ikantakenarira Apa novetsikakerora kameti pogoigakenaniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kantankicha viroegi teratyo pinkematsaigena, teranika viroegi novishate. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yogari nashiegi novishate ikemaigana noniira, aikiro yogiaigana. Narokya noneasanoigiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Maika noganiaigakeri ganiri ineimaigairo igamane onti inkantakani intimaigake. Garatyo tyani gapitsatumaiganari. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Irirotari paigakenari Apa visaigiririra maganiro. Garatyo tyani gapitsatumaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ariotari notentakariri Apa paniro nonaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Impo iriroegi yagutaiganaatyo aikiro mapu impitankaigakerimera. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kantankicha Jeso ikantaigiri: —Narori yagaveakagakena Apa novetsikagetakera posantepage kametiripage pineaigakero viroegi. Maika ¿tyatityora pimpitankaviigakena? ");
INSERT INTO mcbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iriroegi ikantaigiri: —Garatyo iroro nopitankaviigimpi tatarika oita povetsikakerira kametiri, ontityo noneaigakera tera pimpinkatsateri Tasorintsi. Matsigenka pinavetaka kantankicha onti pikañotagumanatanakari irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ikantaigutarityo Jeso: —Ogari itsirinkakagantakempirira Tasorintsi pogiatakoigakerira viroegi oniakotakeri joeseegi pairaninirira. ¿Matsi tera onkante: ‘Naro nokantake vintiegi tasorintsi’? ");
INSERT INTO mcbNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ogotunkanitari magatiro Itsirinkakagantirira Tasorintsi gara tyani kantumatatsi tera iroro arisano, aikiro iriro kantankitsi yogaegi ipaigakeririra Iriniane intiegi tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Irirotari kogakagakena intigankakenara aka kipatsiku ¿tyara okantakara pikantaigakera tera nompinkatsateri Tasorintsi nokantakera nanti Itomi? ");
INSERT INTO mcbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Maika terika novetsikero kañorira yovetsikirira Apa garatyo pikematsaigana. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kantankicha maika novetsikakerotari, nerotyo garika pikematsaigavetana nokantaigakempira maika, pinkematsaigakenatyo pineaigakerotari novetsikagetakerira kameti pogotasanoigakeniri ikantakani itentasanotana Apa, ario nokañota naro nokantakani notentasanotari. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ikogaigavetaatyo aikiro iragaigakerimera iramaiganakerira irogakagantaigakerira kantankicha irirori asatyo ipegapitsaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Impogini Jeso ipiganaa intati Jororanku yogiviatantavagetakera Joan okyara, ario itimapaake kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iaigake tovaini matsigenkaegi ineaigakerira ikantaigake: —Yogari Joan teratyo irovetsikavetempa terira oneimagetenkani, kantankicha antari ikamantakotakerira yoga ikantasanotakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ovashi ikematsaigakeri kara tovaini. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Itimake paniro surari ipaita Irasaro. Onti itimi Vetaniaku itentaigarora iritsiroegi. Paniro opaita Maria, ogari apitene opaita Mareta. Irirori imantsigavagetake. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ogari Maria irorotari sagutantakaririra Atinkami kasankaari ivonkitiku impo osevonkitiantaari ogishi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Impo iroroegi okamantakagantaigakeri Jeso imantsigatakera iamigote. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yogari Jeso ikemakotakerira ikanti: —Ogari mantsigarintsi gakeririra tera ario ompokashiteri ogamagakerira, onti okañotaka maika kameti oneakenkaniniri pairo yagaveavageti Tasorintsi, aikiro ogotasanotakenkanira pairo nagaveavageti, nantitari Itomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yogari Jeso itasanovetarotyo Mareta ontiri ovirentote intiri aikiro Irasaro, ");
INSERT INTO mcbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","kantankicha ikemakovetakarityo imantsigatakera teratyo iriate, onti imaganai piteti kutagiteri anta inakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Impogini ikantaigiri irogamereegi: —Tsame aigaera Joreaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yogari irogamereegi ikantaigiri: —Gotagantatsirira, vikyaenkatari ikogaigavetaka jorioegi timaigatsirira kara impitankaigakempimera anta. ¿Matsi ario pimpiganae aikiro? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Irirori ikantaigiri: —Tekyara irishonke poreatsiri ¿matsi tera onkutagitete 12 ora? Tyanirika nuitatsi kutagiteriku tera irontivatumatempa, okoneagitetaketari. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kantankicha tyanirika nuitatsine tsitenigetiku irontivatakempa, teranika onkoneagitete onti apavatsaasetaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Impo ikanti: —Yogari amigoegite Irasaro magake, kantankicha noatake nogireaaterira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iriroegi ikantaigiri: —Notinkami, iroroventi irovegaemparorokari nerotyo imagantakarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Antari ikantakera Jeso: “Magake”, onti iniakotake igamane, kantankicha iriroegi teratyo inkemaigavakeri, onti ineaigiri arisanori imagake. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Impo ikamantasanoigakeri ikantaigiri: —Mataka kamake. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Matsi ariokonatyo okañotaka maika tera ario none naro anta kameti pinkematsaigakenaniri viroegi pineaigakerora novetsikakerira. Kantankicha maika tsame aigakera ankamosoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iniamatanaketyo Tomashi Piteanintacharira ikantaigiri itovaire irogamereegi Jeso: —Iroroventi tsamenityo aigakera antentagaiganaemparira Jeso ankamaigakera aroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Impo yogonketapaakara Jeso ikemakotapaakeri Irasaro atake imagakotanake 4 kutagiteri ikitatunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ogari Vetania ochoenitakotakaro Jerosaren ariorika onake 3 kirometero. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ario inaigake kara Vetaniaku tovaini jorioegi pokaigankitsirira irogishineaigakerora Mareta ontiri Maria okenkisureakoigakarira iariri. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ogari Mareta okemakotavakerira Jeso pokapaake oatake otonkivoavakarira, kantankicha ogari Maria tera oate, onti opitai pankotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Impo otonkivoavakarira Mareta okantavakeri: —Notinkami, ariome pinakeme aka gametyo ikami icha. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kantankicha maika nogotake tatarika pinkantakeri Tasorintsi inkemakempityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ikantiro Jeso: —Iranianae piariri. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Irorori okantiri: —Jeeje, nogotake iranianaeniroro impogini iraniaiganaera maganiro kamageigankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kantankicha irirori ikantiro: —Narotyo ganiaigaerine maganiro kamageigankitsirira, nantitari ganiantatsirira. Tyanirika kematsatakenane inkamavetakempatyo iranianaetyo. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maganiro kematsaiganarira noganiaigakeri inkantakani intimaigake, gara ineimaigairo igamane. ¿Pikematsatakena? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Okantiri: —Jeeje, nokematsatakempiniroro, nogotaketari vinti Ikogakagakerira Tasorintsi impegakempara Nogoveenkariegite. Vinti Itomi Tasorintsi nogiaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Impo oatake okantakitirora ovirentote, tsikyani oniagempitatapaakero okanti: —Ikantimpi Gotagantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Irorotyo okemavakera okantakerora okaviritapanuta oatakera inakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tekyatanika irogonketempa apatotakara pankotsi, onti inapaake anta okyara otonkivoavakarira Mareta. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yogaegiri jorioegi patoventaigakarorira Maria irogishineaigakerora iroro ineaigavakerora okaviritapanutara okontetanakera yogiaiganakero ineaigiri ariori oatake inaira iariri iragaempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kantankicha irorori onti oatake inakera Jeso otigeroaventapaakari okantiri: —Notinkami, ariome pinakeme aka gametyo ikami icha. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iroro ineavakerora iragakara intiegiri aikiro jorioegi oga ikenake yovankinavagetanakatyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Impo ikanti: —¿Tyara pogaigairi kara? Iriroegi ikantaigiri: —Notinkami, atsi tsame pinkamosotakiterira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Irirori oga ikenake iraganaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yogari jorioegi ikantaiganake: —¡Ojojoo, pairo itasanovagetari! ");
INSERT INTO mcbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kantankicha ikonogagarantaigaka onti ikantaigake: —Yagaveaketari ineakagakerira terira inee, ¿matsi tera iragavee irovegaerira Irasaro ganiri ikami? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ariompatyo yovankinavagetanakari Jeso. Impo yogonketapaaka imperitanakiku yogantunkanirira, onti itikakotantunkani omarane mapu. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Impo ikanti irirori: —Atsi tatsinkaigero mapu. Oniamatanaketyo Mareta okanti: —Notinkami, atakerorokari ishititanake, ataketari imagakotanake 4 kutagiteri. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kantankicha irirori ikantiro: —¿Matsi tera nonkantempi inkaara pinkematsatakenarika pineakero iragaveane Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Impo itatsinkaigakero mapu. Yogari Jeso ineventanaka enoku ikanti: —Apa, noshinevagetakatyo kara, pikemakenatari. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nogotake omirinka pikemana, kantankicha nokantakera maika onti kameti inkemaigakeniri maganiro yogaegi irogoigakeniri arisano vinti tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iroro ikantakera maika ikaemamatanaketyo ikanti: —¡Irasaroo, kontetanae! ");
INSERT INTO mcbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ogatyo ikenake ikontetanake vuataka maganiro kamisatsaku. Imatunkani aikiro irakopageku ontiri igitiku. Antari ivoroku ponataka pañoirontsiku. Ikanti Jeso: —Tsaakoigeri iriataera. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Impo yogaegi jorioegi giaiganakerorira Maria ineaigakerira Jeso yoganiairira Irasaro ikematsaigakeri tovaini ikantaigake: “Arisanoniroro inti Ikogakagakerira Tasorintsi impegakempara Agoveenkariegite.” ");
INSERT INTO mcbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kantankicha ikonogagarantaigaka onti iaigake ikamantaigakerira pariseoegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Impo iriroegi itentaigakari itinkamiegi saseroroteegi ikaemaigakeri maganiro itinkamipage jorioegi yapatoitaigakeri ikantaigiri: —¿Tyarikatyo ankantaigakerira?, yovetsikanaketari posante terira oneimagetenkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Garika tyara akantaigiri onti inkematsaiganakeri maganiro inkantaiganakera inti tigankakeri Tasorintsi impegakempara Agoveenkariegite ovashi iripokaiganake iromanoegi irogimamerinkutaigakaerora ivanko Tasorintsi iragutaigapaakaerora agipatsiegite intivarokaigakaera parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ario inake kara itinkamisanorira saseroroteegi ipaita Kaipashi. Impo irirori iniamatanaketyo ikanti: —Tera pogotumaige viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Matsi tera pogoige pairo avisake okametitakera inkamakera paniro ganiri apogereaiga aroegi maganiro? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Antari ikantakera maika teratyo tsikyata iragashitemparo irirori. Intitari itinkamisanorira saseroroteegi intityo niakagakeri Tasorintsi ikantakera inkamaventaigakerira Jeso maganiro jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kantankicha gara paniro ikamaventaigiri jorioegi. Inkamaventaigakerityo aikiro timageigatsirira parikotipageku terira iriroegi jorioegi, kantankicha ikogakagaigakeritari Tasorintsi impegaigakerira itomiegi kameti intentagavakagaigakempaniri inkematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ovashi isariaiganakari itinkamipage jorioegi irogakagantaigakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Impo irirori tenige iokotagantavagetaempa itimageigira jorioegi inkenkitsatimovageigaerira, onti iatake parikoti apatotara pankotsi opaita Eperain ochoenitakotakaro osarigagitetapaakera. Ario itimake kara itentaigakarira irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Atake ochoenitapaaka agakempara iviesetaegite jorioegi okantaganirira Pasekoa. Tovaini jorioegi timageigatsirira kara parikotipageku iaigake Jerosarenku irisaankaigakempara tekyara agempa ");
INSERT INTO mcbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ovashi ikogaigakeri Jeso kara. Antari inaigakera ivankoku Tasorintsi ikantavakagaigaka: —¿Tyara pinkantaige? ¿Iripokakerorokari ontirika gara ipoki? ");
INSERT INTO mcbNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yogaegiri pariseoegi intiegiri itinkamiegi saseroroteegi ikamantakagantaigakeri maganiro tyanirika neakerine Jeso inkamantaigakerira kameti iragakagantaigakeriniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Intaganivati 6 kutagiteri agakempara Pasekoa yogari Jeso iatai Vetaniaku itimira Irasaro yoganiairira ikamavetakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ario kara onkotunkani isekatakempara Jeso, impo ochapinienkatanakera isekataigaka. Yogari Irasaro ario inake kara mesaku itentaigakarira maganiro tentaigakaririra Jeso. Ogari Mareta iroro pakoigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Impo okenapaake Maria amakotapaake patakotiro kasankaari ovetsikantunkanirira narero punatasanotacharira. Osagutapaakeri igitiku Jeso ogatyo okenake okasankagitetanake, impo osevonkitiantaari ogishi. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ario inake kara Jorashi Ishikariote, irirotari irogamere Jeso gakagantakerineririra impogini. Irirori iniamatanaketyo ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Tyara okantakara tera ompimantenkani agantakenkanira koriki 300 tenario impaigakenkanira kogakovageigacharira? ");
INSERT INTO mcbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kantankicha teratyo arisano ompaitempa isuretakoigemparira kogakovageigacharira, ontityo ikantake maika ineaketari iriro pagotakoiginiri igorikiegite itovaireegi impo yagagarantutaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kantankicha Jeso ikantutarityo: —Atsi arionenityo, nantitari ogashitake osagutakenara maika, inkitaitakenatari impogini. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yogari kogakovageigacharira kantakatari pintentaigaemparira, kantankicha narori garatyo pikantakani pitentaigana. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Impogini ikemakoigakerira tovaini jorioegi inakera Jeso Vetaniaku iaigake ineaigakiterira, kantankicha tera paniro iriatashiigeri irirori. Iatashiigakerityo aikiro Irasaro yoganiairira Jeso ikamavetakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ovashi ikemavakagaigaka itinkamiegi saseroroteegi irogakagantaigakerira aikiro Irasaro, ");
INSERT INTO mcbNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ineaigaketari iriro ikemakoigake maganiro ovashi yapakuaiganake tenigera inkematsaigaeri iriroegi, irirokya ikematsaiganake Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Itovaigavageigityo jorioegi kara pokaigankitsirira Jerosarenku irogavisaigakerora Pasekoa. Impo okutagitetanakera ikemakoigavakeri Jeso pokapaake. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iriroegi itovishiiganake tsigaroshi iaigakera itonkivoaigavakarira ikaemageigamatityo kara ikantaigi: —¡Pairo ikametiti yogaa itigankakerira Tasorintsi impegakempara Igoveenkariegite iseraereegi! ¡Pairo ikavintsaavagetakeri Tasorintsi! ");
INSERT INTO mcbNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yogari Jeso yaganakeri akamotiakyanirira ashino ishigakotantanakari, ariotari okantakeri Itsirinkakagantakerira Tasorintsi okanti: ");
INSERT INTO mcbNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Gara pitsarogaigi viroegi Shionkunirira, pokapaaketari Pigoveenkariegite ishigakotantapaakari akamotiakyanirira ashino.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kantankicha yogaegiri irogamereegi tera irogoige iroro otsatagunkani otsirinkakotunkanirira, kantankicha impogini iataira Jeso enoku ario pinkante isureiganakaro magatiro ineaigakerira ovashi ikantaigake: “Arisanoniroro iriro oniakotake otsirinkakotunkanirira nerotyo ario ikañotagunkani maika.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yogaegiri neaigakeririra Jeso yoganiairira Irasaro ikaemakotairira ikitavetunkanira ikamantageigakeri maganiro, ");
INSERT INTO mcbNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","nerotyo iatantaigakarira itonkivoaigavakarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yogaegiri pariseoegi ikantavakagaiganaka: —Nero nokantira tyampa ankantaigakempara maika. ¡Pineaigakeriniroro maika maganirosanotyo ishineventaiganakari! ");
INSERT INTO mcbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iatagarantaigake aikiro guriegoegi Jerosarenku irogavisaigakiterora Pasekoa. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Iriroegi iaigake inakera Jeripe poniankicharira Vetsairaku Garireaku ikantaigiri: —Nokogaigake noneaigakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Impo yogari Jeripe iatake ikamantakerira Anturishi ovashi itentanakari iaigakera ikamantaigakerira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Impo irirori ikantaigiri: —Maika atake aganaka inkoveenkatagaerira Tasorintsi Kañotasanotakaririra Matsigenka, inkamaketari impo iranianaera iriataera iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Maika nonkamantasanoigakempi ario onkañotakempa maika, garika opankitagani turigoki garatyo otovaigi kantakanityo onkañotakempara pakitsotiro onake. Antari ompankitakenkanirika ompegavetakempatyo oga okitsoki, kantankicha ogatyo ontovaiganake onkitsokitanakera, oshivokanaketari oga okitsoki. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ario okañotaka maika tyanirika intagati ikogake irovetsikagetakera tatarika ikogagetakerira irirori ikiirotyo kañotagantanankicha, kantankicha yogari kogankitsirira irovetsikakerora nokogagetirira naro, iriro pinkante nonkavintsaavagetakeri, aikiro inkantakani intimake. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tyanirika kogankitsi irovetsikakera nokogagetirira naro irorotyo impiriniventake, impogini intimake naroku, imirinkatari vetsikatsirira nokogagetirira naro, irishineventakempari Apa inkantakerira: ‘Kametitake, maika taina naroku pishinevagetakempara.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Maikari maika novankinavagetakatyo kara, kantankicha ¿ario tyara nonkante? Garorokari nokantumati: ‘Apa, pogavisaakotaenara ganiri natsipereavageti nonkamakera’, irorotari nopokashitake. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Apa, neakagaigeri maganiro arisano pagaveavageti kameti irishineventaigakempiniri.” Impo inianake Tasorintsi enoku ikanti: “Matakaniroro noneakagaigakeri, kantankicha impo noneakagaigaeri aikiro.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iroro ikemaigakerira maganiro patoventaigakaririra Jeso ikonogagarantaigaka ikantaiganake: —Onti kareti. Kantankicha pashinikya kantaiganankitsi: —Inti niakeri isaankariite Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yogari Jeso ikantaigiri: —Tera ario onienkani nonkemakerora naro, ontityo oniinkani pinkemaigakerora viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maika gapaaka inkañotagantaigakenkanira maganiro kisaigakenarira, aikiro iragaveakenkanira shintaigaririra maganiro kañovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Antari irogaenokakoitakenara inkentakoitakenara ario pinkante nonkematsatagaigakeri maganiro ikogakagaigakerira Apa inkematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Antari ikantakera maika onti ikamantantakera tyara inkantakenkani irogamagakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yogaegiri patoventaigakaririra ikantaigiri: —Kogapage okantake itsirinkakagantaigakenarira Tasorintsi yogari intigankakerira impegakempara Agoveenkariegite gara ineimatiro igamane. Maika ¿tyara okantakara pikantakera irogaenokakotakenkani Kañotasanotakaririra Matsigenka inkentakotakenkanira? ¿Matsi tyanimpatyora yoga Kañotasanotakaririra Matsigenka? ");
INSERT INTO mcbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yogari Jeso ikantaigiri: —Maikari maika aiñokya pikutagitetakoigi, kantankicha gara samani okañota maika. Irorotari nonkantantaigakempirira kametitake panuivageigakera maika aityokyara okutagiteti ganiri okomutagaigimpi pavatsaari. Antari panuitera pavatsaariku gara pogoti tyara piatake. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Narotari kutagitetakoigakempi, maika pinkematsaigakenara aiñokyara notentaigimpi kameti pimpegaigakempara itomiegi Tasorintsi. Impo iroro ikantakera Jeso maika iatake yomanapitsaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yogari Jeso yovetsikagevetakatyo posantepage terira oneimagetenkani ineakagaigakerira maganiro, kantankicha iriroegi teratyo inkematsaigeri ikantakera: “Nanti Itomi Tasorintsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Onti okañotaka maika kameti ontsatagakenkanira itsirinkakerira kamantantatsirira Isaiashi okanti: “Notinkami, nokenkitsaigavetakaro piniane kantankicha teratyo tyani kematsatumaigenane. Pogikoneatimoigavetakari pagaveane kantankicha teratyo inkematsatumaigempi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Okañotantakarira maika tera iragaveaige inkematsaigakera, ariotari ikantakeri Isaiashi aikiro itsirinkakera ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yogari Tasorintsi tyarika ikantakoigakeri kameti ganiri yogoigi, kañomataka ontinirikatyo tenige ineaigae, aikiro kañomataka tenirikatyo ontimumate isureegi. Ikañoigakeri maika kameti ganiri ineantaigaro iroki, aikiro ganiri ikemaigavakero iriniane iragaigavakerora isureku, ontiri aikiro ganiri ikantatigaiga kameti nogavisaakoigakerira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yogari Isaiashi ikantake maika ineakeritari Jeso pairo ikoveenkavageti nerotyo ikamantakotantakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Okañovetakatyo maika kantankicha itimaigaketyo tovaini itinkamipage jorioegi kantaigankitsirira Jeso inti Ikogakagakerira Tasorintsi impegakempara Igoveenkariegite, kantankicha maireni ikantaigake maika ipinkaigakeritari pariseoegi ganiri ikantaviigiri inkiaigaera pankotsiku yapatoitantaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ontitari ikogasanoigake irishineventaigakemparira matsigenkaegi, avisakero ikogaigakera irishineventaigakemparira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Impogini inianake Jeso imaraenkarikatyo kara ikanti: “Tyanirika kematsatakena tera paniro inkematsatena naro, intityo ikematsatake aikiro tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ario ikañotaka neakenarira, kañomataka ontinirikatyo ineakeri aikiro tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Narori onti nopokashitake nogotagaigakerira maganiro tyara inkantaigakempa kameti irogavisaakoigakeriniri Tasorintsi, kañomataka ontinirikatyo nopokashitake nonkutagitetakoigakerira ganigeniri yapavatsaasetakoigaa maganiro kematsaigakenanerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kantankicha tyanirika kemisantavetakenane impo gara ikematsatana garatyo naro kisakagantiri, teranika iroro nompokashite nonkisakagantaigakerira matsigenkaegi, ontitari nopokashitake nogavisaakoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kantankicha maganiro garira ishineventaigana, aikiro gara ikogaigi inkematsaigakenara inkisashiigakenkani impogini inkantakera Tasorintsi tyara inkantaigakenkani maganiro matsigenkaegi, teranika inkematsaigeronika noniane. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Teranika tsikyata nagashitemparo naro magatiro tatarika oita nokantake nogotagantakera, intitari kantakena Apa tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naro nogotake magatiro ikantirira Apa onti oganiaigakeri maganiro kematsaigakeronerira, nerotyo omirinka nokantaigimpi tatarika oita ikantakena nonkantaigakempira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Impogini yogari Jeso ineavakera aganakara Pasekoa, irirori yogotake iroro inkamantakempa iriataera enoku Irirku. Kantankicha ariompatyo itasanoiganakariri irogamereegi isuretakotasanoiganakarira, igantagatari itasanoigakarira, iriroegitari itentavageigarira aka kipatsiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Yogari kamagarini mataka iniasurentakeri Jorashi, itomi Sumo Ishikariote, ikantakerira imparantakemparira Jeso iragakagantakerira. Kantankicha Jeso yogotake onti iponiaka Tasorintsiku impogini impiganae iriroku, irirotari tigankakeri ikantakerira iragaveavagetakerora magatiro. Nerotyo isekatavageigakara mesaku katsiketyo ikaviritanaka isapokanakaro imanchaki enokutirira yaganake osetantaganirira yavuatakaro itsakiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Impo isake nia okivantaganiriraku ikivavonkitiigakeri irogamereegi impo isevonkitiantaigaari osetantaganirira yavuatakarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Impo iroro inkivavonkititakerimera Sumo Perero irirori ikantiri: —Notinkami, ¿matsi ario pinkivavonkititanakenara naro aikiro? ");
INSERT INTO mcbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yogari Jeso ikantiri: —Maika tekyatanika pogotero tyara nokantakara nokañotakerora maika, kantankicha impoginityo pogotanakero. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kantankicha Perero ikantirityo: —¡Narori garatyo pikivavonkititumatana! Ikantiri Jeso: —Garika nokivavonkititimpi garatyo notentavagetaimpi. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Impo ovashi ikantake Sumo Perero: —Notinkami, ¡iroroventi garatyo intagati pikivavonkititana! ¡Pinkivakotakenatyo aikiro impo pimatakero nogito irorori! ");
INSERT INTO mcbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kantankicha Jeso ikantiri: —Yogari ikyaenkarira kaatankitsi tera inkogakotempa inkivaempara maganiro, matakatari saankake. Intagatityo inkivavonkititakempa. Maika viroegi saankaigavetakavi, kantankicha teratyo maganiro pisaankaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ikantake: “Teratyo maganiro pisaankaige”, yogotaketari tyani gakagantakerine. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Impo yagatakera ikivavonkitiigakerira yogagutanaa imanchaki iatai ipirinitaira mesaku impo ikantaigiri: —¿Maika viroegi pogoigake tyara okantaka nokañoigakempira maika? ");
INSERT INTO mcbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Viroegi onti pikantaigana: ‘Gotagantatsirira’, aikiro pikantaigana: ‘Notinkami.’ Pikantasanoigakeniroro. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kañotari maika nanti nonavetaka gotagaimpirira, aikiro nanti nonavetaka Pitinkamiegi, kantankicha nokivavonkitiigakempityo, virompaegirorokari pairo pinkivavonkitivakagaigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naro onti nokañotakero maika kameti pineakoigakenaniri pimaigakempara viroegi pinkañoigakenara naro maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Maika nonkamantasanoigakempi tera intimumate nampiriantsi iravisakerira nampitaririra. Ario ikañota itigankaganirira tera iravisumateri tigankakeririra. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Maika pogoigakerorika oka nokantaigakempirira, impo pimaiganakempa viroegi aikiro, ario pinkante pishinevageigakempatyo. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tera ario nonkantaigempi maganiro, nogotaketari tyani nokogakagaigake nompegasanoigakerira nogamereegi. Kantankicha ontsataganakempatyo okantakerira Itsirinkakagantakerira Tasorintsi okanti: ‘Yogari sekatakotakenarira iparantakena.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Onti nokamantaigakempi maika tekyara ontsatagempa kameti impogini ontsatagakempara pogoigakeniri inti tigankakena Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Maika nonkamantasanoigakempi tyanirika shineventakemparine nontigankakerira nanti irishineventakempa, aikiro tyanirika shineventakenane naro inti irishineventakempa tigankakenarira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Impo iroro ikantakera Jeso maika ogatyo ikenake ikenkisureavagetanaka ikamantasanoigakeri ikantaigiri: —Maika nonkamantasanoigakempi, paniro viroegi pagakagantakena paita. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ogatyo ikenaigake irogamereegi ikamaguvakagaiganaka, teranika irogoige tyani iniakotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yogari irogamere itasanotarira Jeso aiño ipirinitake inampinaku isekatavageigakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yogari Sumo Perero itimeroakitashitakari kameti inkantakerira Jeso tyanirika iniakotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Impo irirori yaiñonitasanotanakari Jeso ikantiri: —Notinkami, ¿tyani? ");
INSERT INTO mcbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ikanti Jeso: —Maika nontsiantakero oka pan impo tyanirika nompake irirotari. Impo ario ikañotakero itsiantakero ipakeri Jorashi, itomi Sumo Ishikariote. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Impo irorotyo yogakarora ogatyo ikenake itinkamitanakari Satanashi. Yogari Jeso ikantiri: —Tatarika povetsikake katimateronityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kantankicha yogari itovaireegi irogamereegi Jeso tentaigakaririra isekataigakara teratyo irogoige tyara okanta ikantakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ikonogagarantaigaka ineaigiri ariori ikantakeri iriatakera impunaventagetakitera irogaigakemparira, ontirika impaigakerira koriki kogakovageigacharira. Irirotari pagotakoiginiri igorikiegite itovaire. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Impo yagatanakera yogakarora pan itsiantakeneririra Jeso akya ikontetapanuti. Atake apavatsaanaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Impo iroro ikontetanakera Jorashi ikanti Jeso: —Maikari maika atake aganaka ineakenkanira Kañotasanotakaririra Matsigenka pairo yavisake yagaveavagetira ovashi iroro onkenantakempa ineakenkanira Tasorintsi irirori aikiro pairo yavisake yagaveavagetira. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Antari ineakenkanirika Tasorintsi yagaveavagetira, ario inkañotakempa irirori ineakagaigakerira maganiro arisano yagaveavagetira Kañotasanotakaririra Matsigenka, shintsityo ineakagaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Notomiegi, maika gara samani notentaigaimpi. Impogini pinkogaigavetaena, kantankicha gara pagaveaigi piaigera tyarika noatae naro. Ariotari nokantaigakeriri itinkamipage jorioegi iriroegi aikiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Maika nokogake nonkantaiganaempira pinkantakanira pintavakagasanoigaempa. Ariotari nokañotakari naro notasanoigimpira, ariotyo pinkañoigakempa viroegi aikiro pintavakagasanoigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pinkañoigakemparika maika pintavakagasanoigakempara ario pinkante irogoigake maganiro vintiegi nogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Impo yogari Sumo Perero ikantiri Jeso: —Notinkami, ¿tyara piatake? Irirori ikantiri: —Tyarika noatake naro, gatata pagavei piatera viro, kantankicha impogini ario pinkante piatake. ");
INSERT INTO mcbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Irirori ikantiri: —Notinkami, ¿tyara okantakara gara nagavei noatakera maika nogiatanakempira? ¡Narori nonkamaventakempityo! ");
INSERT INTO mcbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yogari Jeso ikantiri: —¿Arisano pinkamaventakena? Maika nonkamantasanotakempi, paita tekyara irinie atava pinteratakotakena mavati. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Maika gara pikenkisureavageiga. Kematsatasanoigeri Tasorintsi, aikiro kematsatasanoigena naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Antari itimira Apa otovaigavageti pankotsi. Antari gamera otimi gametyo nokanti aityo. Maika noatake novetsikaigakempirora kameti pintimantaigapaakemparora impogini. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Impogini noatakera novetsikaigutempirora nompigaate nagaigutempira kameti piaigakeniri pintimaigakera anta naroku. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Viroegi pogoigake tyara noatake, aikiro pineaigakero avotsi.” ");
INSERT INTO mcbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ikantiri Tomashi: —Notinkami, tera nogoigenika tyarika piatake, ¿ario tyara nonkantaigakempara noneaigakerora avotsi? ");
INSERT INTO mcbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yogari Jeso ikantiri: —Nantitari avotsi, aikiro nanti gotagaigakempirira arisanorira, aikiro nanti ganiantatsirira. Garatyo tyani gaveimatatsi iriatakera Apaku garira ikematsatana naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Viroegi pogoigakename naro pogoigakerimetyo Apa irirori, kantankicha mataka pogoigakeri, pineaigakeritari. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iniamatanaketyo Jeripe ikanti: —Notinkami, atsi okotagaigenari Piri kameti noshineigaempaniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ikantiri Jeso: —Jeripe, notentaigakempini karanki. ¿Tekya pineasanotena? Tyanirika neakena naro ineakerityo aikiro Apa. Maika ¿tyara okantakara pikantakenara nokotagaigakempirira Apa? ");
INSERT INTO mcbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Matsi tera pogote naro notentasanotari Apa, irirokya Apa itentasanotana? Magatiro nokantaigimpirira tera tsikyata nagashitemparo naro, itentasanotakenatari Apa nerotyo magatiro novetsikagetirira irirotyo vetsikagetakero. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Maika pinkematsaigakenara nokantaigakempira naro notentasanotari Apa, irirokya Apa itentasanotana naro. Garika pikogaigi pinkematsaigakenara pikemaigakera nokantaigakempirira maika, kematsaigenatyo pineaigakerotari magatiro novetsikagetakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Maika nonkamantasanoigakempi tyanirika kematsatakenane inkañotakena naro irovetsikagetakera posante kañorira novetsikagetirira, aikiro irovetsikagetaketyo pashini pairo avisagetakero novetsikagetakerira naro, noataetari Apaku. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Vintiegitari nashiegi tatarika oita pineviigakeri Apa, narori novetsikakerotyo kameti oneakenkaniniri pairora yagaveavageti irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Naro novetsikakerotyo tatarika pineviigakena, vintiegitari nashiegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Pitasanoigakenarika viroegi atsi tsatagaigerotyo nokantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Narori nonkantakeri Apa intigankakera pashini Mutakotantatsirira inkantakanira intimasurentaigakempi garatyo iokumaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Irirotari Isure Tasorintsi gotagaigakempironerira arisanorira. Yogaegiri terira inkematsaigeri Tasorintsi garatyo ikogumaigi inkematsaigakerira irirori aikiro, teranika ineaigeri aikiro tera irogoigeri, kantankicha viroegi pogoigiri, ariotari itentaigakempiri impo inkantakani intimasurentaigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Gara novashigantaigimpi nompigashiigaempityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gara samani ineaigaana terira inkematsaigena, kantankicha viroegi pineaigaenatyo. Narori nokantakanitari notimi, nerotyo ario pinkañoigake viroegi aikiro pinkantakanityo pintimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Antari nontigankakerira Isure Tasorintsi intimasurentaigakempira ario pogoiganake arisano naro notentasanotari Apa. Ario pikañoigaka viroegi pitentasanoigakena, narokya tentasanoigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yogari gotakerorira nokogagetirira naro impo itsatagakero iriro tasanotakena. Yogari Apa intasanotakempari tasanotanarira. Ario nonkañotakempa naro nontasanotakempari, aikiro nontentasanotakempari kameti irogotasanotakenaniri.” ");
INSERT INTO mcbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iniamatanaketyo irapitene Jorashi terira iriro Ishikariote ikantiri Jeso: —Notinkami, ¿tyara okantakara intagani naroegi pintentasanoigakempa nogotasanoigakempiniri, yogaegiri terira inkematsaigempi gara pitentasanoigari? ");
INSERT INTO mcbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ikantiri Jeso: —Tyanirika tasanotana itsatagiro nokantagetakerira. Yogari Apa intasanotakempari. Naro nontentakempari Apa nompokaigakera nontimasurentaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yogari terira intena tera intsatagero nokantagetakerira. Tera tsikyata nagashitemparo nokantaigakempirira maika, intityo kantakena Apa tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Onti nokantaiganakempi magatiro maika aiñokyanara notentaigimpi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kantankicha impogini yogari Apa intigankakeri Isure intimasurentaigakempira irimutakoigakempira, ineaigakempitari pikematsaiganara. Antari iripokakera irogotagaigakempi magatiro, aikiro isuretagaigakempiro nokantaigakempirira maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Maika nogishineaiganakempi kameti ganiri povankinavageiga onti pinkañoigakena naro tera tatoita novankinaventempa. Narori teranika ario nonkañoigempari yogishineantaigira matsigenkaegi. Gara pikenkisureavageiga, aikiro gara pitsarogaigi. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Maika pikemaigakena nokantakera noatake, kantankicha nompigashiigaempi. Arisanomera pintasanoigakena pishineiganakempamerorokari pikemaigakenara nokantakera noatae enoku Apaku, pairotari yavisakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Onti nokantaigakempi maika tekyara agempa noatantaemparira kameti impogini aganakempara pogoigakeniri arisano nokantasanotake. ");
INSERT INTO mcbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Maika gara samani nokenkitsavageigaimpi, pokapaaketari shintaigaririra terira inkematsaige. Teratyo iragaveavetena, ");
INSERT INTO mcbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kantankicha ariotyo onkañotakempa maika kameti irogoigakeniri maganiro naro notasanotari Apa, aikiro notsatagagetiro magatiro ikantakenarira. “Maika kaviriiganake tsame. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Narori kañomatakana otsitisanorira ova. Yogari Apa inti kañomataka tsamaitakotirorira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Irirori yovatutsagetakero kamatsagetankitsirira terira ontimantemparo okitsoki. Ogari otovaire timankitsirira onti ipireagetakero kameti ontimasanotakeniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Maika viroegi mataka saankaigakevi pikañovageigara, ontitari saankaigakempi noniane nogotagaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pinkantakanira pintentasanoigakena, impo ario nonkañotakempa naro nonkantakanityo nontentasanoigakempi. Pine oga otsegotsa ova garira oshitikaro otsiti garatyo otimi okitsoki, ario tyara onkantakempara ontimakera tsikyata. Ario pikañoigaka viroegi garika pitentasanoigana garatyo pagaveimaigi tsikyata pintimaigakera kameti povetsikaigakera ikogagetirira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Narori nanti otsiti, viroegiri vintiegi otsegotsa. Yogari ikantakanirira itentasanotana, ario nokañota naro nokantakani notentasanotari irirori ovashi itimake kameti yovetsikagetiro ikogagetirira Tasorintsi, gatanika tatoita pagaveimaigi viroegi tsikyata. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yogari garira itentasanotana onti inkañotakemparo otsegotsa ova ovatutsataganira okunkani parikoti impo oroganakera apatotunkani otagunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Maika viroegi pinkantakanirika pintentasanoigakena, aikiro garika pimagisantaigiro nogotagaigakempirira yogari Apa impaigakempityo tatarika oita pineviigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Antari pintimaigakerika kameti povetsikaigakera ikogagetirira Apa ario pinkante ineakenkani irirori pairo yagaveavageti ovashi irishineventakenkani. Ario pinkañoigakempa viroegi ineaigakempi maganiro arisano vintiegi nogamereegisanorira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naro notasanoigimpi viroegi nokañotakari Apa itasanotanara. Maika pinkantakanira pintsatagageigakero nokantaigakempirira kameti nonkantakaniniri nontasanoigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kañotari naro notsatagirora ikantagetanarira Apa impo irirori ikantakani itasanotana, ario pinkañoigake viroegi pintsatagaigakerorika nokantaigakempirira, naro nonkantakanityo nontasanoigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Onti nokantaigakempi maika kameti nogishineaigakempiniri pishinevageigakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Maika onti nokogake pinkantakanira pintavakagasanoigakempa pinkañoigakenara naro notasanoigimpira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tyanirika kamaventiri iamigote arisanotyo opaitaka itasanotakarira. Garatyo itimumati pashini visakerinerira irirori intasanotantakempara. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Antari pintsatagaigakerorika nokantaigakempirira vintiegi noamigoegite. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maika tenige nonkantaigaempi nonampiriaegi, yogari nampiriantsi teranika irogotero magatiro yantagetirira shintaririra, nerotyo viroegi onti nokantaigakempi noamigoegite, nogotagaigakempirotari magatiro ikantagetakenarira Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tera viroegi kogakagaigenane nompegakempara pitinkamiegi. Nantityo kogakagaigakempi pimpegaigakempara nogamereegi pintimaigakera kameti povetsikaigakera ikogagetirira Tasorintsi pinkantakanira pinkañoigakempa maika. Impo irirori impaigakempityo magatiro tatarika oita pineviigakeri vintiegitari nashiegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ogari nokogasanotakerira pintsatagaigakerora onti oka: Pinkantakanira pintavakagasanoigakempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pineaigavakeririka inkisaiganakempira terira inkematsaige atsi sureigaemparotyo naketyo ikisaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Antari gamera pikematsaigana viroegi yogaegiri terira inkematsaige irishineigakempimetyo inkañotagaigakempira ishinevakagaigara iriroegi. Kantankicha naro nokogakagaigakempi pinkematsaigakenara nerotyo ikisantaigakempirira, tenigetari pinkañoigaempari iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sureigaemparo nokantaigakempira nokanti: ‘Yogari nampiriantsi tera iravisumateri nampitaririra.’ Nerotyo maika yatsipereakagaigakenara naro ariotyo inkañoigakempi viroegi aikiro iratsipereakagaigakempira. Ontirika ikematsaigakena nogotagaigakerira ariotyo inkañoigakempi viroegi aikiro inkematsaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ariotyo inkañotagaigakempi maika inkisaviigakempirora pikematsaigakenara, teranika irogoigeri tigankakenarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Antari gamera nopoki nogotagaigakerira ario gametyo ikanti Apa inkisavitasanoigakerira ineakera tera inkematsaigena, kantankicha maika nopokaketari nogotagaigakerira nerotyo gara yagaveaigi inkantaigakera: ‘Tera nogoigenika tyani tigankakeri, nokañotantaigakarorira maika.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Maganirotari kisaiganarira naro ikisaigakeri aikiro Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ario okañotaka aikiro gamera noneakagaigiri posantepage terira ovetsikumagetenkani gametyo ikanti Apa inkisaviigakerira ineakera tera inkematsaigena, kantankicha maika inkisaigakenkanityo, ineaigavetakarotari novetsikagetakerira kantankicha atanatsityo ikisaiganakenara naro intiri Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ariotyo okañotaka maika kameti ontsatagakenkanira okantira itsirinkakagantaigakeneririra Tasorintsi okanti: ‘Onti ikisaigakena kogapage.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Impogini nonkantakeri Apa intigankakerira Isure intimasurentaigakempira, irirotari mutakoigakempine, aikiro iriro gotagaigakempirone arisanorira. Antari iripokakera inkamantakotakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ario pinkañoigake viroegi pinkamantakoigakena, pitentavageigakenatari nakyaenkara tsititanakero nokenkitsavagetanakera kigonkero maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Maika nokantaigakempi magatiro oka kameti ganiri papakuaiganai pikematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Inkantaviigakempirotari pinkiaigaera pankotsiku yapatoitantaigarira, aikiro aganakempa kutagiteri irogaigakempira ineaigiri irorori yovetsikaigake ikogakerira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inkañoigakerotyo maika teranika irogotumaigeri Apa, aikiro naro tera irogotumaigena. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Onti nokantaigakempi maika kameti pisureigaemparoniri impogini agakempara inkisaigakempira pinkantaigakera: ‘Irorotari ikantaiganakairira tekyara iriatae enoku.’ Karanki tera nonkantaigempi, nokantakanitari notentavageigakempi. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Maikari maika noatae inakera tigankakenarira, kantankicha viroegi tera pinkantumaigena: ‘¿Tyara piate?’ ");
INSERT INTO mcbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Onti okenkisureakagavageiganakempi nokantaigakempirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kantankicha maika nonkantasanoigakempi pairo avisake okametitakera noataera kameti nontigankimoigakempiriniri Mutakotantatsirira intentaigakempira. Antari garika noati garatyo ipoki. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Antari iripokakera iriniasurentaigakeri terira inkematsaige ineaigakempara onti ikañovageigaka, aikiro irogotagaigakeri tyara inkantaigakempa kameti ineaigakeriniri Tasorintsi kañomataka tenirikatyo inkañovagetumaigempa, ontiri aikiro irogoigakera impogini inkisashiigakempari Tasorintsi maganiro terira inkematsaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iriniasurentaigakeri kameti irogoigakeniri inti kañovageigacharira, teranika inkematsaigena. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Irogotagaigakeri tyara inkantaigakempa kameti ineaigakenkaniniri kañomataka tenirikatyo inkañovagetumaigempa, noataetari Apaku, viroegi gara pineaigaana. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Irogotagaigakeri kameti irogoigakera impogini inkisashiigakempari Tasorintsi maganiro terira inkematsaigeri, matakatari ikantake irirori inkisashitakenkanira impogini shintaigaririra terira inkematsaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Aityovetaka pashini tovaiti nonkantaigakempirira, kantankicha garorokari pagaveaigi pinkemaigavakerora maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Antari iripokakera Isure Tasorintsi gotagaigakempironerira arisanorira irogotagaigakempirotyo magatiro, gatanika tsikyata yagashitaro irirori, ontityo inkantaigakempi tatarika oita nonkantakeri naro ontiri aikiro magatiro inkantakeririra Apa. Aikiro irogotagageigakempi tyarika onkantanakempa impogini. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Irirori ineakagaigakempi pairora nagaveavageti kameti pishineventaigakenaniri, aikiro irogotagaigakempi magatiro tyarika nokanta naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tyarika ikanta Apa ariotyo nokañota naro aikiro, nokantantaigakempirira yogari Isure irogotagaigakempi magatiro tyarika nokanta naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Maika gara samani notentaigaimpi, kantankicha impogini shintsityo pineaigaena.” ");
INSERT INTO mcbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Impo ikonogagarantaigaka irogamereegi ikantavakagaiganaka: —¿Tyarikatyo okantakara ikantakera maika?, ikantaketari gara samani itentaigajai, kantankicha impogini shintsityo aneaigaeri, ontitari iriataera Iririku. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Antari ikantakera maika, ¿tatarikatyo iniakotake? Nirorotyo tatarikatyo ikantake. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yogari Jeso ineaigakerityo ikogaigakera inkogakotagantaigakerira ikantaigiri: —Nokantaigakempi gara samani notentaigaimpi, kantankicha impogini shintsityo pineaigaena. ¿Iroro piniaventaigake maika? ");
INSERT INTO mcbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Maika nonkamantasanoigakempi viroegi pinkenkisureavageiganakempa piragaiganakempara, iriroegikya terira inkematsaige irishinevageigakempatyo. Kantankicha viroegi pinkenkisureavageigavetakempatyo impoginityo pishineiganaempa. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pine tsinane okatsimonkitira ovankinavagetanaka okemavakerotari okatsitanakera, kantankicha antari omechotumataira tenigetyo osuretaemparo okatsivetakara ontityo oshinevagetaka oneaketari mataka mechotake otomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ario pikañoigaka viroegi maika pikenkisureaigavetakatyo kantankicha naro nompigashiigaempi ovashi pishinevageiganakempa, garatyo itimumati pashini gaveankitsinerira inkenkisureakagaigaempira. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Antari onkañotanakempara maika garatyo pikogakotagantumaigaana. Nonkamantasanoigakempi vintiegitari nashiegi, tatarika pineviigakeri Apa irirori impaigakempirotyo. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kantankicha maika tekya tatoita pinevitumaigeri pinkañoigakerora maika. Atsi neviigeriratyo, irirori impaigakempirotyo kameti pishinevageigakempaniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Antari nogotagaigimpira onti nokantakogetakero posante, kantankicha impogini ganige nokantakogetairo, onti nonkamantakotasanotakeri Apa nogikoneatasanoigakempirora viroegi kameti pogoigakeniri. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Impogini pineviiganakeri Apa tatarika oita pikogaigake, vintiegitari nashiegi, kantankicha tera ario nonkante naro neviigakempirone, ");
INSERT INTO mcbNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","itasanoigakempitari Apa irirori ineaigakempira pitasanoiganara naro, aikiro pikematsaigakenara nokantakera onti noponiaka iriroku. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Arioniroro noponiaka Apaku nopokakera aka kipatsiku, kantankicha maika ariokya nomponianaempa aka kipatsiku noataera anta iriroku.” ");
INSERT INTO mcbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Impo yogaegiri irogamereegi ikantaigiri: —Maika atake pikamantasanoiganakena tenige pinkantakogetaero. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Maika nogoigake pairo pogovagetiro magatiro nerotyo tera pinkogakotempa inkogakotagantaitakempira, tsikyatatari pogoti viro tatoita isureiga paniropage. Nogotantaigakarira onti piponiaka Tasorintsiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yogari Jeso ikantaigiri: —¿Iroroventi maika mataka kematsaigakevi? ");
INSERT INTO mcbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Maika mataka ganaka pintivarokaiganakempara piageigakera parikoti pokaiganakenara paniro, kantankicha garatyo paniro napunta, itentakenatari Apa. ");
INSERT INTO mcbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Maika nokantaigakempi magatiro oka kameti pinkematsaigakenaniri ovashi pishinevageigakempa. Yogari terira inkematsaige iratsipereakagavageigakempityo, kantankicha gara pitsarogaigi, nagaveaigakeritari naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Impogini yagatanakera Jeso iniaigakerira ineventanaka enoku ikanti: “Apa, maika mataka gaka pineakagantaigakemparirira maganiro pairora nagaveavageti kameti noneakagaigakeriniri naro pairora pagaveavageti viro, nantitari Pitomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Viro pikantakena naro kantankitsine tyara inkantaigakenkani maganiro matsigenkaegi kameti noganiaigakerira maganiro pikogakagaigakerira inkematsaigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Intaganitari noganiaigake yogaegi goigakempinerira viro, panirotari pikantakara viro pitasorintsitasanotakera. Ario inkañoigakena naro aikiro irogoigakenara, narotari Jesokirishito pitigankakerira aka. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Naro noneakagaigakeri maganiro pairora pagaveavageti notsatagakerora magatiro pikantakenarira novetsikakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maikari maika nompokaera kara viroku nokogake pinkoveenkatagasanotaenara pinkañotagasanotaenara notentimpira okyara tekyaenkara ontimumate kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Yogaegiri nogamereegi pikogakagaigakerira inkematsaigakenara nogotagaigakeri tyara pikanta viro. Pigantagatari pikogakagaigakerira pashintasanoigakemparira, impo pikantake nashintaigakemparira naro aikiro, impo iriroegi ikematsaigakero piniane. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Maika yogoigake magatiro novetsikagetakerira vinti gaveakagekena, ");
INSERT INTO mcbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","aikiro viro kantakena magatiro nokantaigakeririra, nokamantaigakeritari magatiro pikantakenarira ovashi ikematsaigakena. Yogoigake arisano noponiaka viroku, aikiro ikematsaigakena nokantaigakerira viro tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iriroegitari noniaventaigake maika. Tera iriro noniaventaige terira inkematsaige. Intiegityo noniaventaigake pikogakagaigakerira inkematsaigakenara kameti nashintaigakemparira, virotari shintaigari. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maganirotari nashintaigarira naro pashintaigakarityo viro aikiro. Ario okañotaka aikiro maganiro pashintaigarira viro nashintaigakarityo naro aikiro. Iriroegi neakagaigakerira maganiro pairo nagaveavageti. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Narori gara samani nonai aka kipatsiku, noataetari viroku, kantankicha iriroegi inkantakani irinaigaera aka. Virori pairo pavisaigakeri maganiro pagaveavagetira, aikiro pagaveakagakena naro nokañotakempira viro. Irorotari maika nonkantantakempirira pimpampogiakotasanoigaerira yogaegi kematsaiganarira ganiri yagaveimatagani inkañovagetagakenkanira, onti intentavakagasanoigakempa inkañoigakaera aroegi atentavakagasanoigara. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Antari notentavageigarira pagaveakagakena noneasanoigirira, teratyo impegumatempa paniro. Intagani pegankicha yoga atankitsinerira morekariku kameti ontsatagakenkanira pitsirinkakagantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Maika nompokae viroku, kantankicha maika aiñokyanara aka nokantakempi magatiro oka kameti irishinevageigakempaniri iriroegi inkañoigakenara naro noshinevagetakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nogotagaigakeri piniane, kantankicha yogaegiri terira inkematsaige onti ikisaiganakeri ineaigakerira tenigera inkañoigaempari iriroegi onti ikañoiganakena naro. Narori teranika ario nonkañoigempari terira inkematsaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tera ario nonkantempi pinkaemaigaerira viroku, ontityo nokantakempi pimpugamentaigakerira ganiri yagaveaigiri kamagarini. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Narori teranika nonkañoigempari terira inkematsaige ariotyo ikañoigaka iriroegi aikiro teratyo inkañoigempari. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ogari piniane onti arisanorira. Nokogake pogotagaigakerira inkematsatasanoigakerora kameti impiriniventaigakeroniri magatiro pikogagetirira viro. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kañotari naro pitigankakenara aka nogotagantakerora piniane ariotyo nonkañotakempa naro nontigankaigakeri iriroegi irogotagaigakerira terira inkematsaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Maikari maika naro ariompatyo nontsatagasanotanakerori pitigankavitakenarira kameti arioniri inkañoiganakempa iriroegi aikiro impiriniventaigakerora magatiro pikogagetirira viro impampiaiganakerora nogotagaigakerira nokantasanotakera katinka nogagetakero pikantakenarira viro. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kantankicha tera intagani noniaventaige yogaegi notentaigakarira maika. Noniaventaigakerityo aikiro kematsaigakenanerira impogini inkemaigakerira iriroegi inkenkitsatimoigakerira piniane. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Noniaventaigakeri inkantakanira intentavakagasanoigakempa, aikiro intentasanoigakaera aroegi kañotaka maika pitentasanotanara viro impo ario nokañota naro notentasanotimpi. Inkañoigakemparika maika inkantakanira intentavakagasanoigakempa, yogaegiri terira inkematsaige irogoiganake vinti tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nagaveakagaigakeri magatiro kañotaka pagaveakaganara naro kameti inkantakanira intentavakagasanoigakempa inkañoigakaera aroegi atentavakagasanoigara. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naro notentasanoigakari iriroegi, virokya tentasanotakena kameti inkantakanira intentavakagasanoigakempa. Inkañoigakemparika maika yogaegiri terira inkematsaige irogoiganake vinti tigankakena, aikiro irogoiganake pitasanoigakarira kematsaiganarira pikañotagaigakari pitasanotanara naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Yogaegi pikogakagaigakerira inkematsaigakenara kameti nashintaigakemparira nokogake iriaigakera intimaigakera anta naroku kameti ineaigakenara nonkoveenkavagetaera, virotari koveenkatagaenane, pitasanovagetakenatari okyara tekyaenkara ontimumagete kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Viro Apa, omirinka katinka pogagetakero magatiro. Yogaegiri terira inkematsaige tera irogotumaigempi, kantankicha naro nogotasanotimpi. Ario ikañoigaka yogaegi notentaigakarira maika yogoigake vinti tigankakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nogotagaigakeri tyara pikanta, kantankicha atanatsityo nogotagaigerira kameti irogotasanoigakeniri arisano pitasanoigakari pikañotagaigakarira pitasanotanara naro, aikiro naro nonkantakaniniri nontentasanoigakempari.” ");
INSERT INTO mcbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Impogini yagatanakera Jeso iniakerira Iriri itentaiganakari irogamereegi imonteaiganakarora osanteni paitacharira Sereron, iaigake pankirintsishiku nankitsirira kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yogari Jorashi gakagantakerineririra ineiro irirori aikiro, ariotari ipokapinitiri Jeso itentapiniigarira irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Impo osamanitanakera ikenapaake itentaigapaakari tovaini soraroegi iromanoegi intiegiri aikiro sentaigirorira ivanko Tasorintsi itigankaigakerira itinkamiegi saseroroteegi intiegiri aikiro itigankaigakerira pariseoegi. Yamaigapaake yomanatantaigarira intiri aikiro itsivotantaigarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kantankicha Jeso yogotaketari tyara inkantakenkani itonkivoaigavakari ikantaigiri: —¿Tyani pikogaigake? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Iriroegi ikantaigiri: —Inti nokogaigake Jeso Nasarekunirira. Irirori ikanti: —Narotari. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iroro ikantaigakerira Jeso: “Narotari”, ogatyo ikenaigake ipigavioiganaka asatyo ituaiganake. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Impo imaigairi aikiro ikantaigairi: —¿Tyani pikogaigake? Ikantaigi: —Jeso Nasarekunirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ovashi ikantaigakeri Jeso: —Nokantaigakempiniroro naro. Maika narorika pikogaigake, atsi kante iriaigaera yokaegi notentaigakarira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Onti okañotaka maika kameti ontsatagakempara ikantakerira inkaara iniakerira Iriri ikanti: “Apa, tera impegumatempa paniro pikogakagaigakerira inkematsaigakenara kameti nashintaigakemparira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Impogini yogari Sumo Perero inoshikamatanaketyo isavurite iserogempitatutarityo Mareko ironampiria itinkamisanorira saseroroteegi, onti iseronkutakeri igempita irakosanorirakutirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kantankicha Jeso ikantiri: —Atsi arionenityo, piataero pisavurite. ¿Matsi gara natsipereiro ikantakerira Apa nantsipereakerora? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Impogini yogari itinkamiegi soraroegi iromanoegi itentaigakari maganiro isoraroegite intiegiri aikiro sentaigirorira ivanko Tasorintsi inoshikaigakeri Jeso yogusoigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Impo yamaiganakeri ivankoku Anashi yagashintotirira Kaipashi itinkamisanorira saseroroteegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yogari Kaipashi irirotari kantankitsirira: “Pairo avisake okametitakera inkamakera paniro ganiri apogereaiga aroegi maganiro.” ");
INSERT INTO mcbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Impogini yogiatakotanakeri Sumo Perero itentanaka pashini irogamere Jeso. Yogari itinkamisanorira saseroroteegi ineiritari yoga itentanakarira nerotyo iroro yogiagunkanira Jeso tsompogi imatunkani irirori, ");
INSERT INTO mcbNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kantankicha yogari Perero tera inkie, onti yaratinkake kara sotsi shitakomentontsiku. Impo yogari irapitene iatake iniakerora sentirorira sotsimoro ovashi ogiagakeri tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Impo irorori okantiri Perero: —¿Viro irogamere Jeso? Irirori ikantiro: —Tera naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Okatsinkagitevagetaketari yogaegiri ironampiriaegi itinkamisanorira saseroroteegi intiegiri soraroegi itagaigake tsitsi itaenkavageigakera, nerotyo imatapaakara Perero irirori itentaigapaakarira itaenkavagetapaakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Impogini yogari itinkamisanorira saseroroteegi ikogakotagantakeri Jeso tyaniegi irogamereegi, aikiro tatoita yogotagantavageti. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yogari Jeso ikantiri: —Maganirotyo yogoigi tatoita nogotaganti, ikemaiganatari nokenkitsavagetira, nogotagantavagetitari pankotsipageku yapatoitantaigarira ontiri aikiro ivankoku Tasorintsi. Tera nomanakotumatero maani, ikemaigakenatari maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tyara okantakara pikogakotagantakenara naro tatoita nogotaganti? Kogakotagantaigerityo kemisantaiganarira inkantaigakempira iriroegi. Yogoigakerorokari tatoita nogotagaigiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yogari soraro sentirorira ivanko Tasorintsi aratinkankitsirira kara iroro ikemakerira ikantakera maika ipatosutarityo ikantiri: —¿Antari gara pikañotiri maika itinkamisanorira saseroroteegi? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Irirori ikantiri: —Pineakenarika tera onkatinkate nokantakerira atsi gotagenanityo. Antari terika ario nonkañotero maika, ¿tatatyo oitara pipatosavitakena? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Impo yogari Anashi itigankakagantakeri iriatakera inakera Kaipashi kantaka yogusotunkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Antari aiñokyara Jeso tsompogi ikogakotagantunkanira yogari Perero aiñokya yaratinki kara tsitsiku itaenkavagetakera. Impo ikantagani: —¿Viro aikiro irogamere yonta? Irirori ikanti: —Teratyo naro. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ario inake kara iitane iserogempitatakerira Perero. Inti ironampiria itinkamisanorira saseroroteegi. Ikantutarityo irirori aikiro: —¿Matsi tera noneempi inkaara pitentakarira anta pankirintsishiku? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Impo irirori ikantutaatyo aikiro: —¡Teratyo! Impo irorotyo ikantakera maika iniamatanaketyo atava. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Impogini panikyara onkutagitetanae yamanunkani Jeso ivankoku Pirato iponiakaganunkani ivankoku Kaipashi. Yogaegiri jorioegi tera inkiaige tsompogi ganiri ikitsitinkagani kameti iragaveaigakeniri isekataigakempara paita onchapinitanakera, ontitari Pasekoa. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nerotyo Pirato onti ikontetake sotsi iniaigakerira ikantaigakerira: —¿Tatatyo pikisaviigakerira? ¿Tatatyo yovetsikakera? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Iriroegi ikantaigiri: —Antari gamera yovetsiki terira onkametite gametyo namaigimpiri. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Impo ikantaigiri Pirato: —Iroroventi maiganaerityo, tsikyatatyo pinkisaigakeri viroegi, tyarika pinkantaigakeri virompaegityo tyarika okanti otsirinkakotunkanira pogiatakoigirira viroegi. Kantankicha iriroegi ikantaigiri: —Naroegi jorioegi teranika nagaveaige nogamagantaigera, ikantaviiganarotari Sesa. Intagani viroegi iromanoegi gaveaigankitsine. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Okañotakara maika otsataganaka ikantakerira Jeso ikamantaigakerira irogamereegi tyara inkantakenkani irogakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Impo ikianai Pirato ikaemairi Jeso ikantiri: —¿Arisano viro Igoveenkariegite jorioegi? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ikanti Jeso: —¿Tsikyata pogotashitakaro viro pikantakenara ‘Igoveenkariegite jorioegi’ ontirika pashini kamantaigakempi? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ikanti Pirato: —¿Matsi naro jorio? Yogaegiri pitovaire intiegiri itinkamiegi saseroroteegi iriroegitari maigakempi aka. ¿Tatatyo oitara povetsikakera? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Irirori ikanti: —Tera naro koveenkari kipatsikunirira. Antari naromera intimaigakeme napatoire pugamentaiganakenanerira ganiri yagaigana itinkamipage jorioegi, kantankicha tera ario onkañote maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Impo ikantiri Pirato: —Iroroventi ¿viro koveenkari? Yogari Jeso ikantiri: —Pikantasanotakeniroro naroniroro koveenkari. Irorotari nopokashitake aka kipatsiku nonkamantakotakerora arisanorira. Maganiro kogaigankitsirira irogoigakerora ikemisantavintsaigana. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ikantiri Pirato: —¿Tatatyo oitara arisanorira? Impogini iroro ikantakerira maika ikontetanai aikiro iniaigairira jorioegi ikantaigiri: —Naro noneakeri tera tatoita irovetsikumate kameti inkisakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kantankicha viroegi omirinka agara Pasekoa pameiga nampakuaigempirira paniro yashitakovitunkanirira yovetsikakera terira onkametite. ¿Iriro pikogaigake nampakuaigaempirira Pigoveenkariegite? ");
INSERT INTO mcbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iriroegi ikaemavaitaiganaityo aikiro: —¡Irirori garatyo! ¡Irirompatyo pampakuae Varavashi! Yogari Varavashi inti gantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Impogini Pirato yomperaventakari Jeso impasatakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yogaegiri soraroegi yovetsikashiigakeri kivitsa yamatsaitantaigakarira, aikiro yogagutantaigakari manchakintsi kiraamagori ");
INSERT INTO mcbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","isamatsanaigakerira. Impo yaiñoniigakari ikaemageigamatityo: —¡Ojojoo, neri yogaaa! ¡Atsi neaigerikario Igoveenkariegite jorioegi! Ipatosanaigakerityo. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Impo ikontetanai Pirato ikantaigiri jorioegi: —Atsi gaige kavako. Nogikontetaeri kameti pogoigakera naro noneakeri tera tatoita irovetsikumate kameti inkisakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Impo ikontetapaake Jeso yamatsaitapaakaro kivitsa, aikiro gagutaka manchakintsi kiraamagori. Impo ikanti Pirato: —Neri yoka. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iroro ineaigavakerira itinkamiegi saseroroteegi intiegiri soraroegi sentaigirorira ivanko Tasorintsi ikaemavaimatanaketyo: —¡Kentakoteri! ¡Kentakoteri! Ikantaigiri Pirato: —Iroroventi maiganakerityo pinkentakoigakerira viroegi, narori noneakeritari tera tatoita irovetsikumate kameti inkisakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kantankicha iriroegi ikantaigi: —Antari otsirinkakotunkanira nogiatakoigirira naroegi okanti kametitake inkamakera maganiro kañotagumanaigaririra Tasorintsi. Maika irirori ikantaketari: ‘Nanti Itomi Tasorintsi’, inkamaketyo maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Iroro ikemavakera Pirato ikantaigakera maika ariompatyo itsarogasanotanakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ikiitanaatyo aikiro tsompogi itentanakarira Jeso ikantiri: —¿Tyara piponiakara viro? Kantankicha irirori ikemisantaketyo, teratyo iriniimate. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nerotyo Pirato ikantiri: —¿Tyara pikantakara tera piniena? ¿Matsi tera pogote nagaveake nonkentakotagantakempira, aikiro nagaveake nampakuaempira?, nantitari inampina Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Irirori ikantiri: —Game inti Tasorintsi, gametyo tyara pikantumatana. Nerotyo yoga gakagantakenarira pairotyo yavisake yovetsikakera terira onkametite, yavisakempityo viro. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iroro ikemakera Pirato ikantakerira maika ovashi ikogasanovetanaka tyarika inkantakeri irapakuaerira, kantankicha yogaegiri jorioegi ariompatyo ikaemakonaiganakeriri ikantaigakerira: —Pampakuaeririka iroroventi teratyo viro iamigote koveenkari Sesa, maganirotari kantatsirira tsikyata: ‘Nanti koveenkari’, onti ikisumanatakeri Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Iroro ikemavakera Pirato ikaemakagantakeri Jeso impo ipirinitanake ikanomaantapinitira. Antari irinianeku evereoegi onti okantagani Gavata. Ogari Gavata onti onkantakera Oshitatantunkanirira Mapu. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Panikyara inkatinkatanake poreatsiri tekyara agempa Pasekoa yogari Pirato ikantaigiri jorioegi: —Neri yoka pigoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kantankicha iriroegi ikaemavaitaiganaketyo: —¡Inkante! ¡Kante inkamakera! ¡Kentakoterityo! Yogari Pirato ikantaigiri: —¿Matsi ario nonkentakotagantakeri pigoveenkariegite? Kantankicha yogaegiri itinkamiegi saseroroteegi ikantaigiri: —Mameritari pashini nogoveenkariegite. Panirosanotyo ikantakara koveenkari Sesa. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ovashi ikantaigakeri Pirato: —Iroroventi nani, maiganakeri inkentakotakenkanira. Impo yamaiganakeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Impogini itentanunkani Jeso inatanakero igoroshite iatanakera anta okantaganirira “Ontaikara Itutai Kamatsirini”. (Antari irinianeku evereoegi onti okantagani Gorogota.) ");
INSERT INTO mcbNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Impo ario kara ikentakotunkani, itentagantunkani pashini piteni matsigenka, paniro yogaratinkakotunkani irakosanoriraku, yogari irapitene onti yogaratinkakotunkani irampateku. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Impo yogari Pirato itsirinkake inchakotaku okanti: “Jeso Nasarekunirira, Igoveenkariegite jorioegi”, impo yogakagantakero igoroshiteku. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Onti otsirinkantunkani iriniane evereo ontiri iriniane guriego ontiri aikiro iriniane iromano. Ineaigakero tovaini jorioegi, ariotari ikentakotunkaniri Jeso kara ochoenitakara apatotakara pankotsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nerotyo yogaegi itinkamiegi isaseroroteegine jorioegi ikantantaigakaririra Pirato: —Game pitsirinkiro: ‘Inti Igoveenkariegite jorioegi’, ogame pintsirinkakeme onkantakera: ‘Kantatsirira nanti Igoveenkariegite jorioegi’. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kantankicha Pirato ikantaigiri: —Ogari notsirinkakerira mataka tsirinkaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Impogini yogaegiri 4 soraroegi kentakoigakeririra Jeso yagataiganakera ikentakoigakerira yagaigakero imanchaki iteavakagaigakara yagageigake paniropage. Panivati onai savitirira, irorori tera avovitempa onti osatyo oamagotake, ");
INSERT INTO mcbNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","nerotyo ikantantaigakarira: —Okari oka gara atisarajaigiro, onti asokagiashiigakero mapukicho ogotantaganirira kameti agotantaigakemparora tyanirika shintakemparone. Antari okañotakara maika onti otsatagunkani Itsirinkakagantakerira Tasorintsi okantira: “Yagaigakero nomanchaki ipavakagaigakara, aikiro isokagiaigakero mapukicho ogotantaganirira kameti irogotantaigakemparora tyanirika shintakemparone savitirira.” Ariotari ikañoigakerori maika soraroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Karari kara ikentakotunkanira Jeso aiño aratinkake iriniro ontiri ovirentote ontiri aikiro Maria itsinanetsite Kereopashi ontiri aikiro Maria Magarena. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yogari Jeso ineakerora iriniro aratinkakera otentakarira irogamere itasanotarira ikantiro: —Ina, neri yoga pitomi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Impo ikantiri aikiro irogamere: —Nero oga piniro. Ovashi itentanaaro ivankoku omagimotairira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Impogini yogari Jeso yogotaketari mataka otsatagunkani magatiro Itsirinkakagantakerira Tasorintsi ikanti: —Nomiregetanake. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ario onakotake kara patakotiro vino kachoari. Impo okaatunkani chomiatirorira nia ogaenokakotunkani isopokiiku irachomiatakera. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Impo yachomiatakerora ikanti: —Maika mataka tsatagasanotaka magatiro. Impo oga ikenake yogivotanaka ikamanake. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ogari ikamantakarira Jeso ontitari kutagiteri yovetsikavagetantaiganakarira jorioegi magatiro inkogakoigakemparira aganakempara apishigopireantaganirira. Yogaegiri jorioegi ikogaigake inkentakoreaigaenkanira kentakoigankicharira tekyara agempa. Ogari oga kutagiteri apishigopireantaganirira pairotari avisagetakero magatiro apishigopireantaganirira, ontitari Pasekoa, nerotyo ikantantaigakaririra Pirato intigankaigakerira isoraroegite intinkarajaigakiterira itasagiiku kameti tsikyari inkamaige inkentakoreaigaenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Impo iaigake itinkarajaigakerira nankitsirira irakosanoriraku Jeso, impo imaigakeri irapitene. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Impo irimaigakerimera Jeso irirori ineaigiri paa kamake ovashi tera intinkarajaigeri. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kantankicha paniro soraro imokoroakeri imeretaku ogatyo okenake ovoatanake iriraa sharararara omatanaka nia irorori. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nanti tsirinkakogetakero magatiro oka, narotari neagetakero nerotyo nogotake tera namatagempa katinkatyo nogakero notsirinkakotakerora kameti pinkematsaigakeniri viroegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ontitari okañotaka maika kameti ontsatagakempaniri Itsirinkakagantakerira Tasorintsi okantira: “Garatyo otinkaraimatagani patonkitiro itonki.” ");
INSERT INTO mcbNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aikiro okanti: “Inkamagutakenkani imokoroinkanirira.” ");
INSERT INTO mcbNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aiño paniro irogamere Jeso poniacharira Arimateaku ipaita Jose. Irirori ikematsavetakatyo kantankicha tera inkoge inkemaigakera itovaire, ipinkaigakeritari inkisaigakerira. Impogini ikamakera Jeso iatake ikantakerira Pirato ikogakera iramanaerira. Yogari Pirato ikantake: —Nani, manaeri. Ovashi iatake yamanairi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Impogini yogari Nikoremo atashitaninkutiririra Jeso inkogakotagantakiterira ipokake yamake kasankari mira okonogakaro pashini paitacharira aroe. Magatiro otenatake ariorika 30 kiro. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Impo iriroegi piteniro itiritsatashiigakeri kamisatsa kasankariku yamashitakeririra Nikoremo impo iponaigakeri ikañotagaigakari tyarika ikantaiga ikitatantaigira jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Karari kara ikentakotunkanira Jeso aityo pankirintsishi. Ario onake kara imperitanaki okyaenkarira okigantunkani tekyaenka ogantumatenkani igamaga. ");
INSERT INTO mcbNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ario kara yogaigairi Jeso, irorotari choenitakotankicha, aikiro panikyatari aganakempa apishigopireantaganirira. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Impogini okutagitetamanakera tominkaku aityokyara apavatsaaenkata ogari Maria Magarena oatamanake yogaaganira Jeso oneapaakero mapu itikakotantavetunkanirira paa gagaka. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oshigamatanakatyo inakera Sumo Perero intiri irapitene irogamere itasanotarira Jeso okantaigapaakerira: —Atake yamanunkani Atinkami parikoti tera nogoige tyarika yogunkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Impo yogari Perero itentanakari irapitene iaigakera yogaaganira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishigaigavetanaka piteniro kantankicha yogari irapitene pairotyo yavisake ishintsitakera nerotyo iketyo gonketankicha. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ikanagapaaka inetsagantapaakera, onti ineake kamisatsapage yavuatantavetunkanirira noriagetaka, kantankicha tera inkie. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Impogini yogonketapaaka Perero. Irirori pinkante ikiapaaketyo tsompogi. Ario ikañotaka irirori ineagetakero kamisatsapage yavuatantavetunkanirira noriagetaka kara. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Aikiro ineakero pañoirontsi iponatantavetunkanirira ivoroku tera ontentagemparo kamisatsapage onti apitivitaka onoriaka parikoti. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Impo ovashi ikianake irapitene iketyorira gonketankicha inkaara ineagetakero magatiro ovashi ikantake: —¡Atake yanianai! ");
INSERT INTO mcbNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Antari okyara teranika inkemaigavakero okantakerira Itsirinkakagantakerira Tasorintsi okanti inkamakera Jeso impo iranianae. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Impo ipigaiganaa pankotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kantankicha ogari Maria teratyo oatae onti onake sotsi kara yogavetunkanira Jeso iragakara. Impo okanaganaka onetsagantakera tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oneiri piteni isaankariite Tasorintsi kutasamatavagetake pirinitaigake yoginoriavetunkanira Jeso, paniro pirinitankitsi igitovetakara, yogari irapitene ipirinitake igitivetakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iriroegi ikantaigiro: —¿Tatoita piragatsikataka? Okantaigiri: —Onti yamanunkanira Notinkami. Tera nogote tyarika yogunkani. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Irorotyo okantakera oshonkavetanaka oneiri aratinkake Jeso, kantankicha irorori teratyo ogotavaeri, oneiri teri iriro Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Impo ikantiro: —¿Tatatyo piragatsikataka? ¿Tyani pikogake? Irorori oneiri irirori tsamaitakotirorira pankirintsishi okantutarityo: —Virorika manakeri atsi kamantena tyara pogakeri nagaaterira. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yogari Jeso ikantiro: —¡Maria! Oshonkamatanakatyo avinatutarityo itasagiiku oniantakarira iriniane evereoegi okantiri: —¡Iravoni! (onkantakera: “Gotagantatsirira”). ");
INSERT INTO mcbNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kantankicha Jeso ikantiro: —Pakuaena, gatatanika noatai enoku Apaku, kantankicha maika piate pinkamantaigakerira nogamereegi pinkante: ‘Ikantake: Noatae enoku inakera Apa, aikiro inti Piriegi viroegi. Irirotari Tasorintsisanorira nokematsatasanotirira naro, impo ario pikañoiga viroegi aikiro pikematsatasanoigiri.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Impo irorori oshigamatanakatyo okamantaigapaakerira irogamereegi okantaigiri: —Noneairi Atinkami. Impo okamantaigapaakeri aikiro magatiro ikantagetakerorira irirori. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Impo irorotyo ochapinitanakera yogaegiri irogamereegi Jeso aiño yapatoitaigaka yashitakoigakara ipinkaigakeritari itinkamipage jorioegi, impo katsiketyo ineaigutarityo Jeso yaratinkimoigapaakeri iniaigapaakerira ikantaigiri: —¡Shineiganaempa! ¡Gara pitsarogaigi! ");
INSERT INTO mcbNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iroro ikantaigakerira maika iokotagageigakeri irako ontiri imereta. Impo iriroegi ishinevageiganakatyo kara ineaigairira Atinkami. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Impo ikantutaigaarityo aikiro: —¡Shineiganaempa! ¡Gara pitsarogaigi! Kañotari naro itigankakenara Apa ariotyo nonkañotakempa naro maika nontigankaigakempi pinkenkitsatakovageigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Impo itasonkaigakeri ikantaigiri: —Maika intimasurentaigakempi Isure Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tyanirika pinkantaigake magisantakotaka magatiro yovetsikakerira, ariotyo inkañotakempa Tasorintsi irirori imagisantakotaerityo, garatyo ikenkiagiri impogini. Kantankicha tyanirika pinkantaigake tera imagisantakotenkani yovetsikakera terira onkametite, ariotyo inkañotakempa Tasorintsi irirori garatyo imagisantiro yovetsikakerira, inkenkiagavitakerityo impogini. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kantankicha yogari irogamere Jeso paitacharira Tomashi Piteanintacharira tera ario irine irirori ikoneatimoigakerira Jeso itovaireegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Impogini onti ikamantaigairi ikantaigiri: —Noneaigairi Atinkami. Kantankicha irirori ikanti: —Ariorikaratyo. Antari noneakerorika irako agaveakerira karavatonki ikentakotunkanira impo nompiatakero nochapaki ovegantakerira, ario pinkante nonkantake: ‘Arisanoniroro yanianai.’ Antari garika noneiro, aikiro garika nopatsogantiri imeretaku imokoroinkanira garatyo nokanti: ‘Arisanoniroro yanianai.’ ");
INSERT INTO mcbNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kantankicha impogini avisanakera 8 kutagiteri yogari irogamereegi Jeso yapatoitaigaa aikiro, maika ario inake Tomashi irirori. Yashitakoigavetakatyo kantankicha Jeso katsiketyo yaratinkimoigapaakeri iniaigapaakeri ikantaigiri: —¡Shineiganaempa! ¡Gara pitsarogaigi! ");
INSERT INTO mcbNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Impo ikantiri Tomashi: —Maika neero nako piatero pichapaki, aikiro patsogantena nomeretaku imokoroaitakenara. Gara pitsoenkana, onti pinkematsatakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Iniamatanaketyo Tomashi ikanti: —¡Notinkami! ¡Vinti Tasorintsisanorira! ");
INSERT INTO mcbNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ikantiri Jeso: —Maika akaenkiniroro pikematsatakena pineakenara. ¡Irishinevageigakempatyo yogaegi terira ineaigavetena kantankicha ikematsaigakena! ");
INSERT INTO mcbNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yogari Jeso yovetsikagetake posantepage terira oneimagetenkani ineakagaiganairira irogamereegi, kantankicha tera nontsirinkakogetero aka sankevantiku. ");
INSERT INTO mcbNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Okari oka notsirinkakogetakerira maika onti kameti pogoigakeniri Jeso inti Itomi Tasorintsi Ikogakagakerira irirori impegakempara Agoveenkariegite. Aikiro notsirinkakogetakero kameti pinkematsaigakeriniri ovashi pinkantakani pintimaigake. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Impogini Jeso ikoneatimoigutaarityo aikiro irogamereegi anta otsapiaku inkaare Tiveriashi. Onti okañotaka maika: ");
INSERT INTO mcbNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yapatoitaigaka irogamereegi Jeso. Ario inake Sumo Perero, Tomashi Piteanintacharira, Natanaeri poniankicharira Kanaaku Garireaku, intiegiri itomiegi Severeo intiegiri aikiro pashini piteni irogamereegi. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Impo ikanti Perero: —Nonkitsatakiteta. Iriroegi ikantaigiri: —Nompokaigaketyo naroegi aikiro. Ovashi iaiganake yomateiganaka pitotsiku, impo ikitsakitsageigavetaka teratyo iragumaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Iroro okutagitevetanakara ineaigiri Jeso aratinkake otsapiaku, kantankicha iriroegi teratyo irogoige inti Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Impo irirori ikantaigiri: —¿Yogaa? ¿Tera pagumaige? Ikantaigiri. —Mameri. Tera nagaige. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Impo ikantaigiri: —Atsi kitsaige apisotateneku pitotsi pakosanoriraku, ario pinkante pagaigake. Iriroegi ikitsaigake, impo iroro inoshiaigaeromera teratyo iragaveaigaero irogaenokaigaerora, ishatekantakarotari shima. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iniamatanaketyo irogamere Jeso itasanotarira ikantiri Perero: —¡Inti Atinkami! Irorotyo ikemavakera Sumo Perero ogatyo ikenake yogagumatanakatyo imanchaki isapokanakarira inkaara akya iokaataka oaaku pokoroogn. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yogari itovaire aiño yomateiga pitotsiku, onti inakoigake choeni nigankia ariorika onake 100 metero. Impo iriroegi yamaiganakero pitotsi otsapiaku inoshiatakoiganakerora kitsari, teranika iragaveaigaero irogaenokaigaerora. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Impo iroro yaguigavetanakara ineaigapaakero tagaka tsitsi tashitaka shima ontiri pan. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yogari Jeso ikantaigiri: —Atsi magarantaigake yoga pagaigakerira maika. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Impo yogari Sumo Perero yomatetanaa pitotsiku inoshiatakotanakeri shima shatekarikatyo kara imarapagerikatyo yamakovagetanakeri otsapiaku. Maganiro inake 153 shima. Itovaigavetakatyo kantankicha teratyo intisaraero kitsari. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Impo yogari Jeso ikantaigiri: —Tainaegi pisekataigakempara. Ikogaigavetaka inkantaigakerimera: “¿Tyani viro?”, kantankicha teratyo tyani kantumaterine, yogoigaketari inti Atinkami. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Impo irirori inoshikakero pan ipaigakerira, ario ikañotakeri aikiro shima. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Okari oka iroro omavatakarira ikoneatimoigairira Jeso irogamereegi ikitareanaara ikamavetakara. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Impo yagataiganakera isekataigakara yogari Jeso ikantiri Sumo Perero: —Sumo, itomi Joan, ¿pitasanotakena pavisaigakeri yogaegi pitovaire? Ikantiri Perero: —Jeeje, Notinkami. Viro pogotake notakempi. Ikantiri Jeso: —Iroroventi pimpaigaerira iseka novishate ityomiani. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Impo ikantairi aikiro: —Sumo, itomi Joan, ¿pitasanotakena? Ikantiri irirori: —Jeeje, Notinkami. Viro pogotake notakempi. Ikantiri Jeso: —Iroroventi pisentaigaenarira novishate. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Impo imatutaarityo aikiro ikantutaarityo: —Sumo, itomi Joan, ¿pitakena? Yogari Perero ogatyo ikenake ikenkisureanaka ineakera mavatanaka ikogakotagantiri ariorika itakari. Impo ikantiri: —Notinkami, viro pogotakero magatiro. Pogotake notakempi. Ikantairi Jeso: —Iroroventi pimpaigaerira iseka novishate. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Maika nonkamantasanotakempi, antari vikyaenkara antaritanankitsi tsikyata viro pogaguvageta pimanchaki, aikiro piavageti tyarika kara pipintsataka, kantankicha impogini pimpisaritanaera ganige pikañotaa maika. Onti inkantaitakempi pankontsaanakera ovashi irogusoitakempi iramaitanakempira tyarika kara garira pininti piatira. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Antari ikantakera Jeso maika onti ikamantakerira tyara inkantakenkani impogini inkisavitakenkanira ikematsatasanotirira Tasorintsi irogamagakenkanira. Impo ikantiri: —¡Pinkantakanira pinkematsatakena! ");
INSERT INTO mcbNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Impo ishonkavetanaka Perero ineavakeri yogiatapaakeri irogamere Jeso itasanotarira. Irirori inti pirinitankitsirira inampinaku Jeso itentaigakarira irogamereegi isekataigakara panikyara inkamake, impo irirotari kantakeririra: “¿Tyani gakagantakempine?” ");
INSERT INTO mcbNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Impo ineavakerira Perero ikantiri Jeso: —Notinkami, yogari yoga ¿tyara inkantakenkani? ");
INSERT INTO mcbNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ikantutarityo Jeso: —Nonkogera naro inkantakanira intimake kigonkero nompigaatera, ¿ario tyara pinkantera viro? Virori pinkantakanityo pinkematsatakena. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Impo ovashi ikantaiganake maganiro kematsaigiririra Jeso gara ikami irogamere itasanotarira, kantankicha Jeso teratyo ario inkante gara ikami. Ontityo ikantakeri Perero: “Nonkogera naro inkantakanira intimake kigonkero nompigaatera, ¿ario tyara pinkantera viro?” ");
INSERT INTO mcbNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Narotari irogamere itasanotarira. Narori noneagetakero magatiro notsirinkakogetakerira aka sankevantiku. Ogotunkani tera ario namatagempa onti nokantasanotake arisanorira. ");
INSERT INTO mcbNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Aikiro aityopage pashini posantepage yovetsikagetakerira Jeso tera ontsirinkakogetenkani. Antari ontsotenkenkanira ontsirinkakogetenkanira magatiro noneake naro ariorika avisanakero kipatsi.");
INSERT INTO mcbNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","¿Aiñovi Teopiro notasanotarira kametikyarika pinake? Narori aiñona aka kametikya nonake. Karanki notsirinkakempi nokamantakogetakero magatiro yovetsikagetakitirira Jeso, aikiro yogotagantagetutirira ");
INSERT INTO mcbNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","asatyo agavagetanaara iatanaira enoku. Yatsipereavagetaketari ikamakitira, kantankicha antari yanianaira tera aiñokya iriatae enoku onti inanai 40 kutagiteri ikoneatimogeigapanaatirira iritigankaneegi yagaigakerira okyara kameti ineasanoigaeriniri irogotasanoigakera arisano yanianai. Aikiro ikamantakogetanakerira Tasorintsi tyara ikantaka ikavintsaantavagetakera itigankantakaririra inkamaventaigakerira maganiro kameti irogavisaakoigakerira kematsaigakerineririra impegakempara Igoveenkariegite. Aikiro yogotagaiganakeri tyara inkantaigakempa iriaigakera inkenkitsaiganakerora Niagantsi Kametiri irapagiteavageiganakemparora magatiro kipatsi, intitari gotagakeri Isure Tasorintsi tyara inkantaigakerira. Impo aganakara 40 kutagiteri ario iatanai enoku. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Impogini itentaigakarira isekataigakara ikantaiganairi: —Karanki nokamantaigakempi ikantakera Apa intigankimoigakempira Isure. Maika gatata piaigai parikoti, pinaigaketa aka Jerosarenku pogiaigakera intsatagakerora ikantakerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yogari Joan onti yogiviatantavagetake niaku, kantankicha maika choenitapaake agakempara kutagiteri iripokantakemparira Isure Tasorintsi intimasurentaigapaakempira intinkamiigapaakempira. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Impogini yapatoitaigakara iriroegi ikantaigiri: —Notinkami, ¿ario maika pampatoitaigaena naroegi iseraereegi pimpegakempara Nogoveenkariegite pimpugamentaigakenara kameti nontimaigaeniri kogapage? ");
INSERT INTO mcbNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ikantaigiri Jeso: —Gara povankinaventaigaro pogoigakerora tyarika onkantagetanakempa impogini, panirotari Apa yogotakerora. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kantankicha antari iripokakera Isure intimasurentaigakempira ario pinkante iragaveakagaigakempi pinkamantakoiganakenara Jerosarenku. Ario pinkañotagaiganakero Joreaku ontiri aikiro Samariaku. Impogini pintsotenkagiteavageiganakero magatiro kipatsi pinkamantakoigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iroro yagatanakera iniaiganairira iriroegi ipampogiaigavakeri yogaenokanaara iatanaira enoku, impo omanakotanakeri menkori, asatyo ipegaka tenige inkoneatae. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Impo aiñokyara ineventaiga enoku, ineaigutarityo yaratinkaigapaake piteni surari kutasamatavagetake ");
INSERT INTO mcbNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ikantaigapaakeri: —Viroegi Garireakunirira, ¿tyara pikantaigakara atanatsira pineventaiganaka enoku? Maika pineaigavairi Jeso iatanaira enoku, ario inkañotapaempa impogini impigaatera. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iriroegi ovashi iaiganai Jerosarenku. Ogari Jerosaren tera osamanitakotero otishi paitacharira Orivoshi, intagati onake ariorika patiro kirometero. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iroro yogonkeigapaakara ikiaigapaake pankotsiku yagatsonkuiganake enoku. Ariotari kara imagaigakeri Perero, Joan, Santiago, Anturishi, Jeripe, Tomashi, Varitorome, Mateo, Santiago itomi Arejeo, Sumo Komperagetatsirira intiri Jorashi itomi Santiago. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maganiro iriroegi omirinka yapatoitaigaka ipiriniventavageigakerora iniaigakerira Tasorintsi itentaigakarira irirentiegi Jeso ontiri iriniro ontiri aikiro pashini tsinaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Impogini yapatoitaigakara tovaini kematsaigatsirira ariorika inaigake 120. Impo yaratinkanake Perero ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Napigematsaegine, maika onti otsatagunkani itsirinkakotanakerira Iravi pairani yogotagakerira Isure Tasorintsi nerotyo iniakotantakaririra Jorashi mampiaiganakeririra gaigakerineririra Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Irirotari atentaigavetakarira okyara ikañoigavetakai aroegi agiaigirira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","(Impogini iatake ishitikakara inchatoku yashirianaka itonkanake imotiaku tokn okonteviotanake iramporetsa. Iroro ikemakoigakerira Jerosarenkunirira ovashi ipaiigakero oga kipatsi ikamantakarira Asererama. Antari irinianeku onti onkantakera: ‘Iraatsigiteri.’ Impogini opunaventantunkani oga kipatsi koriki yagakerira Jorashi ipunatunkanira yagakagantakerira Jeso.) ");
INSERT INTO mcbNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Otsirinkakotunkanitari sankevantiku paitacharira Saremo okanti: ‘Ovashigantanakenkanira ivanko gara tyani timantumataaro.’ Aikiro okanti: ‘Pashinikya pugaerine irantavagetakenerira Atinkami.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Maikari maika aiñoegi aka atentavageigakarira karanki ikyara yogiviatake Joan Jeso kigonkero iatanaira enoku. Maika tsame agaigaera pashini pugaerineririra Jorashi kameti irironiri antentaigake ankamantakoigakerira Jeso yanianaira.” ");
INSERT INTO mcbNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Impogini ikaemaigake piteni. Paniro ipaita Jose ikantaganirira Varesava Goshito. Yogari irapitene ipaita Matiashi. ");
INSERT INTO mcbNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Impo iniaigakeri Tasorintsi ikantaigiri: “Notinkami, pineasurentaigiritari maganiro matsigenkaegi. Maika nokogaigake nogoigakera tyani pikogake impugaerira Jorashi ");
INSERT INTO mcbNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","impegaempara iritigankane Jeso intentaigaenara. Yogari Jorashi kamaketari iatakera tyarika kara okatinkatakerira pikantakerira iriatakera.” ");
INSERT INTO mcbNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Impogini isokagiaigakero mapukicho ogotantaganirira kameti irogotantaigakemparora tyanirikara onkatinkatake. Impo inti okatinkatake Matiashi irirokya pegaacha iritigankane Jeso ovashi itentaigaari itovaireegi iritigankaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Impogini agapaakara kutagiteri okantaganirira Pentekoshite ario inaigake maganiro kematsaigatsirira yapatoitaigakara pankotsiku. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Impo katsiketyo ikemaigutarotyo opoimaenkatapaake kañoenkamataka omarane tampia oponiaenkatapaaka enoku. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Impogini okoneagematapaake kañomataka omorekira tsitsi okatinkatagugeigapaakeri paniropage iriroegi ");
INSERT INTO mcbNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ovashi itimasurentaigapaakeri Isure Tasorintsi oga ikenaigake iniantaiganakaro pashinipage niagantsi terira inkemumaigero, intitari niakagaigakeri Isure Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ario inaigake kara Jerosarenku tovaini jorioegi tsatagageigirorira itsirinkakotanakerira Moiseshi, onti iponiageigaka pashinipage kipatsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iroro ikemaigavakerora opoimaenkatanakera ishigaigamatanakatyo yapatoventaiganakarira maganiro kematsaigatsirira ovashi ikemaigapaakeri iniantutaiganakarira irinianeegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Itsarogavageiganaketyo yogavageiganake kavako ikantavakagaiganakara: —¿Matsi teratyo iriroegi Garireakunirira maganiro yogaegi? ");
INSERT INTO mcbNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tyara okantakara akemaigakerira iniantaiganakarora niagantsipage?, akemaigakeritari maika iniantaiganakarora anianeegi ");
INSERT INTO mcbNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","aroegi poniageigankicharira parikotipageku Paretoku, Meroku, Irameku, Mesopotamiaku, Joreaku, Kaparoshiaku, Pontoku, Ashiaku, ");
INSERT INTO mcbNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirijiaku, Pampiriaku, Egipitoku, aikiro okaragetanakera Irivia oatakara Shireneku ontiri aikiro Iromaku. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aiñoegi jorioegisanorira intiegiri aikiro pashini giatakoigiririra. Aikiro aiñoegi poniaigankicharira Keretaku ontiri Araviaku. ¡Maganiro aroegi akemaigavakeri iniantaiganakarora anianeegi ikamantakoigakerora yovetsikagetakerira Tasorintsi yogikoneatakerora iragaveane! ");
INSERT INTO mcbNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Itsarogavageiganake yogavageiganake kavako ikantavakagantaigakarira: —¡Ejee! ¿Tatatyo oitara oka? ");
INSERT INTO mcbNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kantankicha ikonogagarantaigaka onti isamatsanaigakeri ikantaiganakera: —¡Onti niakagaigakeri ishinkiro! ");
INSERT INTO mcbNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yaratinkamatanaketyo Perero itentaiganakarira maganiro iritigankaneegi Jeso inianakera imaraenkarikatyo kara ikanti: “Atsi kemisantaigavakena nonkamantaigakempira maganiro viroegi Joreakunirira intiegiri timaigatsirira aka Jerosarenku. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Maika pineaigakena ontinirikatyo noshinkiigaka, kantankicha teratyo ario noshinkiigempa, ikyaenkatari gaenokapaacha poreatsiri. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ontityo otsataganakara ikamantakotanakerira pairani kamantantatsirira Joere ikantakera: ");
INSERT INTO mcbNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ikantake Tsorintsi: Impogini panikyara ontsatagagetanakempa magatiro nosariagetakarira pairani nontigankimoigakeri Nosure intimasurentaigakerira maganiro matsigenkaegi. Yogari ananekiegi noniakagaigakeri inkamantakoiganakenara. Yogari ikyaenkarira gaenokageiganankichane noneakagaigakeri posante, kantankicha onti onkañotimoigakempari igisanireku. Yogari gatavageiganaacharira onti noniaigakeri igisanireku. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ario nonkañotagaigakeri nomperaneegi, surariegi ontiri tsinaneegi, nontigankimoigakeri Nosure intimasurentaigakerira iriniakagaigakerira inkamantakoigakenara. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Antari enoku inkiteku nogikoneagematero terira oneimagetenkani, aikiro nogikoneagematerotyo nagaveane aka kipatsiku oneanakenkanira iraatsi, aikiro omorekagematanaketyo tsitsi, ontiri aikiro tsitsienka ontinkamisekantavagetanake. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Antari nontsatagagetanakerora magatiro nosariagetakarira pairani intsivakanake poreatsiri. Yogari kashiri inkiraamentatanake inkañotanakemparo iraatsi. Irorotari pairorira avisake onkoveenkatakera kutagiteri nogikoneatantakemparorira nagaveane. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kantankicha nogavisaakoigakeri maganiro kantaigakenanerira: Notinkami, gavisaakotena.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Maikari maika, viroegi iseraereegi, kemisantasanoigena nonkamantaigakempira. Inti nonkamantakotake Jeso Nasarekunirira. Yagaveakagagetakeri Tasorintsi yovetsikagetakerora terira oneimagetenkani, pogoigaketari yogikoneatimoigakempirora iragaveane. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kantankicha igantaga yogotakera Tasorintsi tyara inkantakenkani Jeso, irirotari kantankitsi okyasanokyara iragakagantakenkanira irogakagantakenkanira. Nerotyo pagakagantantaigakaririra pogakagantaigakerira pikantaigakera inkentakoigakerira kañovageigacharira terira iriroegi jorioegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kantankicha yoganiairi Tasorintsi ganiri ikonoitumatari igamaga, teranika agaveimateri kamagantsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yogari koveenkari Iravi ikamantakotanakerira Jeso ikanti: ‘Ikantakani itentakena Notinkami, omirinkatari inake nonampinaku kameti ishintsitagakenaniri ganiri tatoita nopinkumati, ");
INSERT INTO mcbNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","irorotari noshinevagetantanakarira nosureku, aikiro noniakerira nokantakeri: Noshineventavagetakempityo kara, nogotaketari nonkamakerika nontinaanae, ");
INSERT INTO mcbNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","gatanika povashigantaro nosure ontentakemparora isureegi kamaigankitsirira, teranika pinkoge oveseganakempara novatsa, nantitari pomperane terira inkañovagetumatempa. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pogotagakena tyara nonkantakempa nonkantakanira nontimake viroku. Pinkantakani pintentakena pogishineasanotakenara.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Maika, napigematsaegine, agotasanoigake tera ikiiro niakotachane Iravi yashikiiganakairira, ikamaketari pairani impo ikitataagani, ariotari onakeri ikitatantaarira aka. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Irirori inti kamantantatsirira. Yogari Tasorintsi iniakeri ikantiri: ‘Impogini intimake piyashikitanakerira pegankichanerira igoveenkariegite maganiro iseraereegi inkañotaempira viro. Garatyo namatavitimpi, nantitari Tasorintsi.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Irorotari yogotasanovagetantakarira Iravi pairani iranianaera Ikogakagakerira Tasorintsi intigankakerira impegakempara Igoveenkariegite iseraereegi, nerotyo ikamantakotantakaririra ikantakera gara ovashigantagani isure ontentakemparora isureegi kamaigankitsirira, ario onkañotake ivatsa irorori gara ovesegumata. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Irirotari yoga Jeso yoganiairira Tasorintsi, noneasanoigakeritari maganiro naroegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Impogini yovirinitairi inampinaku irakosanoriraku ovashi ipakeri Isure ikantakeririra pairani impakerira kameti intigankakeriniri aka kipatsiku intimasurentaigakerira maganiro kematsaigatsirira. Maikari maika pokake, nerotyo magatiro oka pineageiganakerira, aikiro pikemageiganakerira, irirotari kañotagagetakero maika. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yogari Iravi teratyo iriro kenkitsatakotaachane ikiiro, teranika iriro atatsine enoku, intityo ikantakotake Jeso ikantantakarira maika: ‘Yogari Tasorintsi iniakeri Notinkami ikantiri: Viro Notomi, piriniteta aka nonampinaku ");
INSERT INTO mcbNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kigonkero nagaveaigakerira maganiro kisashiigakempirira.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Maika nokogake pogotasanoigakera maganiro viroegi iseraereegi, yogari Jeso pikentakotagantaigakerira ipegakagakari Tasorintsi Itinkami maganiro kematsaigiririra, irirotari ikogakagake okyara intigankakerira irogavisaakoigakaera.” ");
INSERT INTO mcbNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iroro ikemaigavakerira ikenkisureavageiganaka ikantaigiri Perero intiegiri itovaireegi iritigankaneegi Jeso: —Maika, notovaireegi, ¿tyampa nonkantaigakempa? ");
INSERT INTO mcbNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ikantaigiri Perero: —Pakuaiganakero povetsikageigira terira onkametite pinkantatigaiganakempa pogiviatagantaigakempara pokotagantaigakempara arisano pikematsaigakeri Jesokirishito kameti imagisantaeroniri Tasorintsi pikañovageigara. Impogini intigankimoigakempiri Tasorintsi Isure intimasurentaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ario inkañotagaigakempi maganiro viroegi intiegiri maganiro piyashikiiganakerira, aikiro maganiro parikotipagekunirira. Arisanotyo intimasurentaigakeri maganiro inkematsatagaigakerira Atinkami Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yogari Perero ariompatyo iniaiganakeriri ikantaigiri: —Pakuaiganakero pikañovageigara pinkantaigakerira Tasorintsi irogavisaakoigakempira ganiri itentagantaigimpiri pitovaireegi vetsikaigankitsirira terira onkametite inkisashiigakemparira impogini. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iroro ikemaigavakerira ikenkitsavagetakera ishineventaiganakaro ikantakerira ovashi yogiviatagantaigaka. Itovaigavagetityo kara kematsaigankitsirira, ariorika inaigake 3,000. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Omirinka ipiriniventavageigakero ikemisantaigakerora yogotagaigakeririra iritigankaneegi Jeso, tera irapakuimaigero. Onti itentavakagaigaka ikemavakagaigakara, aikiro iniaigakerira Tasorintsi ontiri aikiro yogaigakarora pan isuretakoigaarira Kirishito ikamaventaigakaira. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Maganiro neaigakeririra iritigankaneegi Jeso yovetsikageigakera posante terira oneimagetenkani yogavageiganaketyo kavako. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kantankicha yogari kematsaigankitsirira itentavakagaigaka ikemavakagaigakara, tera intsaneapitsavakagaigempa tatarika oita yashintaigaka. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aikiro ipimantaigakero tatarika oita yashintaigaka yagantaigakarora koriki ipaigakerira maganiro kogakovageigacharira. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Omirinka kutagiteri yapatoitapiniigaka ivankoku Tasorintsi. Antari pankotsipageku itentavakagaigaka isekataigakara. Ishinevageigaka tera iraventakovageigempa. ");
INSERT INTO mcbNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ishineventavageigakari Tasorintsi ineaigaketari pairo ikavintsaavageigakeri. Maganiro matsigenkaegi timaigatsirira kara ineaigakerira ikañoigakara maika ishineventaiganakari. Omirinka kutagiteri yogari Atinkami atanatsityo ikematsatagaigirira pashini itentaigakarira kematsaigatsirira ariompatyo itovaiganakeri. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Impogini yogari Perero intiri Joan iaigake ivankoku Tasorintsi. Omirinkatari inanaira shavini poreatsiri iatapiniigi maganiro jorioegi iniaigirira Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ario ipirinitake kara sotsimoroku terira iranuitumate, kantaka ikyara mechotankitsi. Ariotari yamapiniigiriri yovirinitapiniigirira kameti inevivageigakeriniri igorikite kiapiniigatsirira. Ogari sotsimoro onti opaita Kametiri. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Irirori ineaigavakerira Perero intiri Joan yaiñoniigapaakara yakontsaanake ineviigavakerira igorikite. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iriroegi ipampogiaiganakeri, impo inianake Perero ikanti: —Atsi gaigena kavako. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Irirori yogaiganakeri kavako yogiakovetakara inei ariori impaigakeri koriki. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kantankicha Perero ikantiri: —Narori mameri tatampa nompakempi, tera intimenika nogorikite, kantankicha yagaveakagakena Jesokirishito Nasarekunirira novegaempira, nerotyo maika atsi kaviritanake nuitanake. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Impo ikatsatakeri irakosanoriraku yogaratinkakeri. Oga ikenake ishintsitanake igitiku ontiri aikiro igunkekiku. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yaratinkagantsimatanaketyo yanuitanakera ovashi yogiaiganakeri Perero intiri Joan ikiaiganakera tsompogi. Tyarikarorokari imitamitavagetaketyo ishineventanakarira Tasorintsi ikanti: “¡Pairo ikametiti Tasorintsi ikavintsaavagetakenatari!” ");
INSERT INTO mcbNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Antari ineaigavakerira maganiro ");
INSERT INTO mcbNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ogatyo ikenaigake yogavageiganaketyo kavako, yogoigaketari inti pirinitapinitatsirira ivankoku Tasorintsi inevitantavagetira koriki. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Impo irirori ikantakanityo ikatsatakovageigakeri imanchakiku Perero intiri Joan. Maganirotyo yogavageiganake kavako, ishigaigamatanakatyo iaigakera inaigakera iriroegi anta ovetsaenkakara otinkamipoa okakaratsenkoatakera okantaganirira Irashi Saromon. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ineaigavakerira Perero ikanti: “Viroegi iseraereegi, ¿tyara okantakara pogaiganakera kavako? Pipampogiaiganakenara kañomataka nantieginirikatyo kametiri, kañomataka tsikyatanirikatyo noganuitakeri yoka. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kantankicha teratyo tsikyata naroegi gaveaigatsine, intityo gaveakagakena Tasorintsisanorira ikematsatasanoigirira yashikiiganakairira Averan, Isaako intiri Jakovo. Irirotari ganiairi Jesokirishito itigankakerira inkamaventaigakaera impo yovirinitairi inampinaku irakosanoriraku. Yogari Jesokirishito irirotari pagakagantaigakerira viroegi pikantaigakerira Pirato irogakagantakerira. Yogari Pirato ikogavetakaniroro irapakuaerimera, kantankicha viroegi tenirorotyo pinkogaige. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tera pinkogumaige irapakuaenkanira yoga Pairorira Ikametiti terira inkañovagetumatempa. Inti pikogaigake irapakuaenkanira gantatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ariotari pikañoigakeri maika pogakagantaigavetakarira yoga ganiantatsirira, kantankicha yoganiairi Tasorintsi, noneasanoigakeritari yanianaira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Irirotari nokematsatasanoigakerira nogotasanoigaketyo arisano yagaveavagetake magatiro nerotyo pineantaigakaririra maika yanuitanakera yoka terira iranuitumate. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Maika, notovaireegi, naro nogotake tera pogoigenika pikañotantaigakarorira maika. Ario ikañoigaka pitinkamiegi tera irogoige. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kantankicha antari ikañotakara maika onti itsatagagetakero Tasorintsi ikantakerira pairani iniakagaigakerira kamantantaigatsirira ikamantakoigakerira Ikogakagakerira impegakempara Igoveenkariegite iseraereegi ikantaigakera iratsipereavagetakera inkamakera. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Irorotari maika nonkantantaigakempirira pakuaiganakero povetsikageigira terira onkametite pinkematsatasanoigakerira Tasorintsi kameti irisaankakeroniri pikañovageigara ovashi aganakempa ishintsitagaigakempira pisureku irogishineaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Impogini intigankimoigaempiri Jeso, irirotari ikogakagake okyara intigankakerira irogavisaakoigakempira impegakempara Pigoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kantankicha irirori maika kantaka irinakera anta enoku kigonkero inegintetaerora Tasorintsi magatiro intsatagagetakerora ikantakerira pairani iniakagaigakerira kamantantaigatsirira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ikantaketari Moiseshi: ‘Impogini intimake paniro pitovaire kamantaigakempinerira tatarika oita inkantake Tasorintsi, irirotari kogakagakerine inkamantantakera inkañotakenara naro ikogakagakenara nokamantantira. Tatarika oita inkantaigakempi pinkematsaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tyanirika garira ikematsatiri nonkisashitakempari ganige itentaigaari itovaireegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Maganiro kamantantaigatsirira ikamantakogeiganakero magatiro pineaiganakerira maika. Iketyo ivatakero kamantantatsirira Samoiri, impogini imaiganakero impogiiganankitsirira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Maikari maika viroegi pineaigakero itsatagagetakerora Tasorintsi magatiro ikamantakogeiganakerira iriroegi pairani. Aikiro itsatagakero ikantaigakeririra yashikiiganakempirira, ikantakeritari Averan: ‘Impogini intimake piyashikitanakerira kavintsajaigakerinerira maganiro matsigenkaegi.’ Antari ikantakerira maika, vintiegityo isureigaka inkavintsajaigakempira. ");
INSERT INTO mcbNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iroro yoganiairira Tasorintsi Itomi viketyo itigankimoigake inkavintsajaigakempira kameti pampakuageiganakeroniri pikañovageigara.” ");
INSERT INTO mcbNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aiñokyara ikenkitsavageigi Perero intiri Joan ipokaigapaake saseroroteegi itentaigakari itinkamiegi sentaigirorira ivanko Tasorintsi intiegiri saroseoegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ikisaigapaakeri ineaigakera yogotagaiganakerira maganiro ikamantaigakerira iraniaiganaera impogini kamaigankitsirira inkañoigakerira Jeso yanianaira. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ovashi yagaiganakeri yamaiganakerira, kantankicha tera tyara inkantumaigeri, onti yashitakoiganakeri, ataketari ochapinienkatanake. Antari onkutagitetanaera ario pinkante inkogakotagantaigakeri. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kantankicha ikonogagarantaigaka kemaigakerorira ikantaigakerira ikematsaigake, ariorika inaigake 5,000 surariegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Impo okutagitetanaira yapatoitaigaka itinkamiegi saseroroteegi itentaigakarira itinkamiegi jorioegi intiegiri aikiro gotagantaigirorira itsirinkakotanakerira Moiseshi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ario inake itinkamisanorira saseroroteegi paitacharira Anashi itentaigakarira Kaipashi, Joan, Arijantero intiegiri aikiro maganiro iitanepageegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Impo itigankaigake iragaigakitenkanira Perero intiri Joan inkogakotagantaigakerira. Impo yamaiganunkanira ikantaigiri: —¿Tyanimpatyo gaveakagaigakempi? ¿Tyanimpatyo kantaigakempira poganuitakerira yoga terira iranuite? ");
INSERT INTO mcbNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yogari Perero itinkamitakaritari Isure Tasorintsi iniamatanaketyo iniaiganakerira patoitaigankicharira ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Iroroventi pikogakotagantavintsaigakenara tyara nokantaigakeri noganuitaigakerira yoga terira iranuite ");
INSERT INTO mcbNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","maika nonkamantaigakempi kameti pogoigakeniri viroegi intiegiri aikiro maganiro iseraereegi inti gaveakagaigakena Jesokirishito Nasarekunirira noganuitantaigakaririra. Yogari Jeso irirotari pikentakoigavetakarira, impogini yoganiairi Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Viroegi onti pikañoigakari ‘vetsikaigakerorira pankotsi terira irishineventaigavetemparo mapu pairorira okametitake, kantankicha yogari Tasorintsi ishineventakaro ipegakagakaro okusotantakarira pankotsi.’ Tera pinkematsaigerinika Jeso, kantankicha Tasorintsi ipegakagakari Itinkami maganiro kematsaigiririra. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Irirotari itigankake inkamaventantakera irogavisaakotantakera. Teratyo intimumate pashini gaveatsinerira irogavisaakotantera, panirotyo ikantakara irirori yagaveakera. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Antari ineaigakerira maganiro tera intsarogumaige, yogavageiganaketyo kavako, ineaigiritari onti yantaigaveta ikitsavageigira, aikiro tera irogotagasanoigenkani sankevanti ovashi ikantaiganake impa irororakari itentavageigarira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ariotari itentaigakariri terira iranuivetempa, ¡tyampatyo inkantaige iriroegi! ");
INSERT INTO mcbNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ovashi yogikontetagantaigakeri sotsi kameti iriniavakagaigakempaniri iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Impo ikantaigi: —¿Tyara ankantaigakeri maika? Maganirotari timaigatsirira aka ikemakoigakeri yovetsikaigakera terira oneimagetenkani. ¿Matsi tyampa ankantaigero amanakoigakerora? ");
INSERT INTO mcbNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kantankicha maika tsame ankantaviigakerira kameti ganiri ikenkitsatakotumaigairi Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Impo ikaemakagantaigairi ikantaigakerira: —Maikari maika gara pikenkitsatakotumaigairi Jeso, aikiro gara piniakotumaigairi pinkantaigakera yagaveavageti. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Impo iriroegi ikantaigi: —Atsi neaigerotyo viroegi. ¿Tyati pairo avisake okametitakera, irororika nonkematsaigakempira viroegi ontirika nonkematsaigakerira Tasorintsi? ");
INSERT INTO mcbNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Naroegi garatyo napakuimaigiro nonkamantakoigakerora noneaigakerira, aikiro nokemaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ikantutaigaarityo aikiro: —Gara pikenkitsatakotumaigairi Jeso, nokisaigimpikari. Impogini yapakuaigairi, ineaigaketari tyampa inkantaigakeri inkisaigakerira, maganirotari ikantaiganake: “Pairo yagaveavageti Tasorintsi”, ineaigaketari yoganuitakerira terira iranuite. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Irirori onti ishiriagakotaka 40 shiriagarini. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iroro yapakuaigairira iaigai inaigakera irapigematsaegine ikamantaigapaakeri magatiro ikantaigakeririra itinkamipage. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iroro ikemaigavakera maganiro iniaigakeri Tasorintsi ikantaigiri: “Notinkami, pairo pavisavageigakeri maganiro, virotari vetsikagetakerorira inkite, kipatsi, omaraani nia intiri maganiro timantagetarorira ontiri aikiro magatiro timantagetarorira. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aikiro viro niakagakeri pomperane Iravi yashikiiganakenarira ikantakera: ‘¿Tatatyo oitara tsimajaigakeri maganiro matsigenkaegi terira iriroegi jorioegi ikisantaigakaririra Tasorintsi? ¿Tyara ikantaigakara isuregeigavetakarora posantepage terira onkametite garira yagaveaigi ineaigakerora? ");
INSERT INTO mcbNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Maganiro koveenkariegi kipatsikunirira intiegiri itinkamiegi matsigenkaegi yapatoventaiganakari ikisashiiganakarira Tasorintsi intiri Ikogakagakerira intigankakerira impegakempara Igoveenkariegite iseraereegi.’ ");
INSERT INTO mcbNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Otsataganakatari pikantakerira yapatoitantaigakaririra Erorishi intiri Pontsio Pirato itentaigakarira terira iriroegi jorioegi intiegiri iseraereegi ikemavakagaigakara irogaigakerira pomperane Jeso terira inkañovagetumatempa, irirotari pikogakagakerira impegakempara Nogoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Virotari kantankitsi okyara ikañotantaigakarorira maika. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Notinkami, pikemavakero magatiro ikantaigakenarira ikisaigakenara. Maika nokogaigake pishintsitagaigakenara naroegi pomperaneegi ganiri notsarogumaigi nonkenkitsaigakerora piniane. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pagaveakagaigakenara kameti novegaigakeriniri mantsigaigankitsirira. Aikiro nokogaigake iragaveakagaigakenara pomperane Jeso terira inkañovagetumatempa kameti novetsikageigakeniri posante terira oneimagetenkani.” ");
INSERT INTO mcbNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Iroro yagataiganakera iniaigakerira Tasorintsi ogatyo okenake oshigekanake pankotsi inantaigakarira okantanakera shige shige shige, itinkamitasanotutaiganaarityo aikiro Isure Tasorintsi. Impo iriroegi ovashi ikenkitsaiganakero Iriniane Tasorintsi teratyo intsarogumaige. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Maganiro kematsaigatsirira itentavakagaigaka ikemavakagaigakara. Tatarika yashintageigaka tera paniro irashintaigemparo, ontityo yashintaigakaro maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yogari Tasorintsi ikavintsaavageiganakeri, aikiro yagaveakagavageiganakeri iritigankaneegi Jeso, nerotyo yagaveasanotantaiganakarira atanatsira ikamantakoiganakeri yanianaira. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maganiro tyanirika timaigatsirira igipatsiegite aikiro ivankopage ipimantaigakero yagantaigakarora koriki. Impogini yamaiganakeneri ");
INSERT INTO mcbNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","iritigankaneegi Jeso kameti impageigakeriniri maganiro kogakogeigacharira, paniropage onti ipageigakeri akarika ikogakoigaka, nerotyo tenige intimae kogakovageigankichanerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Itimake pashini Tsiperekunirira iyashikitanakerira Irevi paitacharira Jose, kantankicha yogari iritigankaneegi Jeso ariokya ipaiigairi Verenave (onkantakera: “Gishineantatsirira”). ");
INSERT INTO mcbNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Irirori ipimantakero igipatsite yagantakaro koriki. Impogini yamaigakeneri iritigankaneegi Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kantankicha itimake pashini paitacharira Ananiashi itentakaro itsinanetsite opaita Sajira, ipimantaigakero igipatsite ");
INSERT INTO mcbNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","yagantaigakarora koriki, kantankicha yagagarantavakeri. Yogari aiñokyarira inai yamaiganakeneri iritigankaneegi Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kantankicha Perero ikantavakeri: —Ananiashi, ¿tyara okantakara pikematsatakerira Satanashi pikogantavetakarira pamatavinatakerimera Isure Tasorintsi pagagarantantavaarira koriki ipunaitakempirira pigipatsite? ");
INSERT INTO mcbNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Matsi tera viro shintasanotemparone okyara? Ario okañotaka maika pipimantakerora, ¿matsi tera viro shintemparine koriki? ¿Antari gara pikañotiro maika? Pikañotakerora maika pamatagakara pineiri ariori naroegiri pikañoigake maika, teratyo intityo pikañoigake Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iroro ikemavakerira ogatyo ikenake ituanake ikamanake. Maganiro kemakoigakeririra itsarogavageiganaketyo kara. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Impo ikiaigapaake ikyaenkarira gaenokaiganankicha yagaiganakeri iponaiganakeri yamaiganakerira inkitaigaerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Impo osamanivagetanakera okenapaake itsinanetsite okiapaake, tera ogovagetumatenika ikamakera ojime. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yogari Perero ikantavakero: —Atsi kamantena, ¿arisano ipakenari pijime maganiro koriki pagantaigakarorira pigipatsiegite? Irorori okanti: —Jeeje, arisanoniroro ipakempiri maganiro. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ikantutarotyo: —¿Tyara okantakara pikemavakagaigakara pamatavinaigakerimera Isure Tasorintsi? ¿Matsi pineaigiri gari ikisaviigimpiro? Neriegi yonta kitaigaatiririra pijime, maika virokya inkitaigaate. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Iroro ikantakerora oga okenake otuimotanakeri okamanake. Impo ikiaigavetapaaka ineaigapaakero irorori kamake. Irorokya yagaigapanuti inkitaigaaterora inaira ojime. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Antari ineaigavakerora okañotanakara maika ogatyo ikenaigake itsarogavageiganake maganiro kematsaigatsirira naigankitsirira kara. Ario ikañoiga aikiro maganiro kemakoigavakerorira. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yogari Tasorintsi yagaveakagaigakeri iritigankaneegi Jeso yovetsikimotantaiganakaririra matsigenka terira oneimagetenkani. Maganiro kematsaigatsirira yapatoitapiniigaka ivankoku Tasorintsi ovetsaenkakara otinkamipoa okakaratsenkoatakera okantaganirira Irashi Saromon. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yogari itovaireegi itsarogaigake inkonoiigakemparira, kantankicha ishineventaigakari. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ariompatyo itovaiganakeri kematsaigakeririra Atinkami, surariegi ontiri tsinaneegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ineaigavakeritari yovetsikageigamati posantepage yamantaiganakaririra mantsigaigankitsirira yoginoriaigakerira avotsiku ishitaigakerira shitatsiku itimashitagaigakerira Perero kameti ontsimankumaigaerira ivamparokite irovegaiganaempaniri. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ario ikañoigaka poniageigankicharira ochoenitira Jerosaren yamaigapaakeneri mantsigaigankitsirira intiegiri yatsipereakagageigakarira kamagarini, maganiro yovegaiganaa. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kantankicha yogari itinkamisanorira saseroroteegi intiegiri saroseoegi tsipatasanoigaririra ariompatyo ikisaiganakeriri ineaigakera intiegira ishineventasanoiganunkani. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yagaigamatanakerityo yamaiganakerira yashitakotagantaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kantankicha impogini onigankigitetanakera ipokashiigakeri isaankariite Tasorintsi yashireakoigapaakeri yogikonteigairira ikantaigiri: ");
INSERT INTO mcbNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Piaigae ivankoku Tasorintsi pinkenkitsatimoigaerira maganiro pinkamantaigakerira tyara inkantaigakempa kameti irogavisaakoigakenkaniniri.” ");
INSERT INTO mcbNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Impo ario ikañoigakero maika okutagitetanaira iaigamanake ivankoku Tasorintsi itsitiiganairora yogotagantaiganaira. Aiñokyara yogotagantaigi yogari itinkamisanorira saseroroteegi intiegiri itentaigakarira ikaemaigakeri maganiro itinkamipage iseraereegi yapatoitaigakeri. Iriroegi itigankaigake soraroegi iragaigakiterimera anta yashitakoigavetakarira iramaiganakerimera iriroegiku. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kantankicha iaigavetaka mameri. Ipigaiganaa ");
INSERT INTO mcbNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ikantaigapaake: —Noaigavetaka noneaigapaakero shitasanomataka yashitakotantaigakarira. Yogari kamaguigakeririra timashiigamatake sotsimoroku ganiri ikonteiganai, kantankicha nashireaigavetaro mamerigitematake tsompogi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iroro ikemaigavakera itinkamiegi soraroegi sentaigirorira ivanko Tasorintsi intiegiri itinkamiegi saseroroteegi yogaiganake kavako ikantaigi: —¿Tyarikatyo ikantaigakara? ");
INSERT INTO mcbNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ikenamatapaaketyo paniro ikantapaakera: —Yogari pashitakotagantaigavetakarira chapi akya kogapage aiño yogotagantavageigai ivankoku Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Impo ikemaigavakera itinkamiegi soraroegi iaigake kametikya yagaigakitiri, itsarogaigaketari impitankaigakenkanira. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yamaigapaakeri yogaratinkaigapaakeri yapatoitaigakara. Impogini inianake itinkamisanorira saseroroteegi ikanti: ");
INSERT INTO mcbNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nokantasanoigavetakempi pampakuaiganakerora ganigera pikenkitsatakotumaigairo yovetsikagetanakerira Jeso. Kantankicha viroegi tera pinkematsaigena, onti pikamantageiganakeri maganiro Jerosarenkunirira. Ontitari pikogaigake pinkantakagantaigakenara ikentakotunkanira Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Inianake Perero intiegiri itovaire iritigankaneegi Jeso ikantaigiri: —Irirompatyo nonkematsaigake Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Arisanotari pogamagaigavetakari Jeso pikentakotagantaigavetakarira koroshiku, kantankicha yoganiairi Tasorintsisanorira ikematsaigirira yashikiiganakairira pairani. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yovirinitakeri inampinaku ipegakagakari Atinkami, aikiro ipegakagakari Gavisaakotantatsirira kameti iragaveaigakeniri iseraereegi inkantatigaiganakempara irapakuaiganakerora yovetsikageigira terira onkametite imagisantaeroniri Tasorintsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noneasanoigakeritari nokamantakotantaigakaririra. Ario ikañotaka Isure Tasorintsi ikamantakotakeri. Irirori inti itigankakerira Tasorintsi intimasurentaigakerira maganiro kematsatasanoigiririra. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iroro ikemaigavakera ikisasanoigamatanakatyo tyarikarorokari, ikogaigavetakatyo irogakagantaigakerimera. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kantankicha ario inake kara paniro pariseo paitacharira Gamariere. Maganiro itovaireegi itasanoigakari. Irirori inti gotagantirorira itsirinkakotanakerira Moiseshi. Impo yaratinkamatanaketyo ikanti: —Maiganakerita sotsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Impo ikantaigiri maganiro patoitaigankicharira: —Viroegi notovaireegi, tsikyanira pikisaigirikari kogapage, oketyo pisuretakotasanoigakemparo. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kañotari pairani itimavetakara Teorashi ikogavetakara iravisumatantakemera yogiaigavetanakari tovaini matsigenka, ariorika inaigake 400. Kantankicha teratyo iragavee, ontityo yogunkani. Yogari giaigavetanakaririra oga ikenaigake iparikotigeiganai tenige intentavakagaigaempa. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ario okañotaka aikiro pairani itsirinkakotagantaigakerira koveenkari irapatoire irogotakera akatovainirika inaigake maganiro. Itimake pashini Garireakunirira paitacharira Jorashi. Irirori ikogavetaka iravisumatantakemera inkañotakemparimera Teorashi. Ario ikañotaka irirori yogiaigavetakarityo tovaini matsigenka, kantankicha iroro yogunkanira oga ikenaigake iparikotigeiganai giaigavetanakaririra. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Irorotari nonkantantaigakempirira maika arione yogaegi, pakuaigaeri gara tyara pikantaigiri. Magatiro oka yogotagantaigakerira tsikyatarika yagashiigakaro iriroegi tsikyatatyo ompeganaempa. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kantankicha intirika tigankaigakeri Tasorintsi irogotagantavageigakera tyampatyo pinkantaigakeri. Intagarogiteni intirika pagashiventaiga Tasorintsi. Iroro ikemaigavakerira ikantaigake: —Iroroventi kametitake. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Impo ikaemakagantaigairi aikiro, ipasatagantaigakerira, impo yapakuaigairi ikantaigavakeri: —Maika nonkantaigavakempi, gara pikenkitsatakotumaigairi Jeso. ");
INSERT INTO mcbNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Impogini ikonteiganai iaiganai ishinevageiganaa, ineaigaketari inti yatsipereaventaigake Jeso, ");
INSERT INTO mcbNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","nerotyo teratyo irapakuimaigero, onti yogotagantavageigake omirinka kutagiteri anta ivankoku Tasorintsi ontiri pashini pankotsipageku ikamantakoiganakerira Jeso ikantaigakera inti itigankake Tasorintsi irogavisaakoigakerira maganiro kematsaigakerinerira impegakempara Igoveenkariegite. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Impogini itovaiganakera kematsaigatsirira ovashi itsitiiganakero jorioegi niantaigarorira guriego iniashinaiganakarira itovaire jorioegi niantaigarorira evereo ikantaigakera tera impasanoigero osekaegi ogamakotagapage niantaigarorira guriego. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yogari iritigankaneegi Jeso yapatoitaigakeri maganiro kematsaigatsirira ikantaigiri: —Tera onkametite nampakuaiganakerora nokenkitsavageigirora Iriniane Tasorintsi irorokyara nompiriniventavageiganake nompimantavageigakera sekatsi. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irorotari nonkantantaigakempirira maika pinkogaigakera 7 govageigatsirira pairorira inegintetasanovageiga itinkamiigakarira Isure Tasorintsi kameti iriroeginiri piriniventaigakerone impimantavageigakera. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naroegi onti nompiriniventavageigake noniaigakerira Tasorintsi, aikiro nonkenkitsavageigakerora Iriniane nogotagantaigakerora. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iroro ikemaigavakerira maganirosanotyo ishineiganaka ikantaiganake: —Kametitake. Yagantaigakaririra Ishitivano, ineaigakeritari ikematsatasanovagetakera, aikiro itinkamitasanotakarira Isure Tasorintsi. Impogini imaigakeri Jeripe, Porokoro, Nikanoro, Timo, Parimanashi intiri aikiro Nikorashi. Yogari Nikorashi onti iponiaka Antiokiaku. Tera iriro jorio kantankicha pairani onti yogiatakoigavetari ikematsaigirira iriroegi. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Impogini ikantaigi iritigankaneegi Jeso: —Neri yogaegi. Impo iriroegi ipatikaiigakeri igitoku iniaventaigakerira. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ariompatyo apagiteakovagetanakari Iriniane Tasorintsi Jerosarenku, itovaigavagetanaketyo kematsaigatsirira. Imaigamatanakatyo saseroroteegi iriroegi ikematsatagarantaiganakera. ");
INSERT INTO mcbNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yogari Ishitivano