﻿USE sofia;
DROP TABLE IF EXISTS sofia.mca_vpl;
CREATE TABLE mca_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mca_vpl WRITE;
INSERT INTO mca_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Enewe'en ƚiyits pe' ƚawa'mhitsik'i pe' ta'ƚets ha' Jesucristo, hikha' ta'ƚets pa' David'ik'i, ta'ƚets pa' Abraham'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pa' Abraham'ik'i qa pa' ƚa's qa ƚii Isaac, pa' Isaac'ik'i qa pa' ƚa's qa ƚii Jacob. Pa' Jacob'ik'i qa ƚa'sek pa' Judá qa pe' ƚamatsits qa pe' ƚek'injats. ");
INSERT INTO mca_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pa' Juda'ak'i qa pa' ƚa's qa ƚii Fares qa pa' ƚek'inij Zara, qa pe' ƚenene qa ƚii Tamar. Pa' Fares'ik'i qa pa' ƚa's qa ƚii Esrom. Pa' Esrom'ik'i qa pa' ƚa's qa ƚii Aram. ");
INSERT INTO mca_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Pa' Aram'ik'i qa pa' ƚa's qa ƚii Aminadab. Pa' Aminadab'ik'i qa pa' ƚa's qa ƚii Naasón. Pa' Naason'ik'i qa pa' ƚa's qa ƚii Salmón. ");
INSERT INTO mca_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Pa' Salmón'ik'i qa pa' ƚa's qa ƚii Booz qa pe' ƚenene'ek'i qa ƚii Rahab. Pa' Booz'ik'i qa pa' ƚa's qa ƚii Obed qa pe' ƚenene'ek'i qa ƚii Rut. Pa' Obed'ik'i qa pa' ƚa's qa ƚii Isaí. ");
INSERT INTO mca_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Pa' Isai'ik'i qa pa' ƚa's qa ƚii David, hikpa' qi wittata'aj pa'aj. Pa' wittata'ik'i David qa pa' ƚa's qa ƚii Salomón. Pekhe' ƚenene'ek'i hikpe' ƚewhe'ye'tax pa'aj pakha' ƚii Urias. ");
INSERT INTO mca_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Pa' Salomon'ik'i qa pa' ƚa's qa ƚii Roboam. Pa' Roboam'ik'i qa pa' ƚa's qa ƚii Abías. Pa' Abias'ik'i qa pa' ƚa's qa ƚii Asa. ");
INSERT INTO mca_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Pa' Asa'ak'i qa pa' ƚa's qa ƚii Josafat. Pa' Josafat'ik'i qa pa' ƚa's qa ƚii Joram. Pa' Joram'ik'i qa pa' ƚa's qa ƚii Uzías. ");
INSERT INTO mca_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Pa' Uzías'ik'i qa pa' ƚa's qa ƚii Jotam. Pa' Jotam'ik'i qa pa' ƚa's qa ƚii Acaz. Pa' Acaz'ik'i qa pa' ƚa's qa ƚii Ezequías. ");
INSERT INTO mca_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Pa' Ezequias'ik'i qa pa' ƚa's qa ƚii Manasés. Pa' Manases'ik'i qa pa' ƚa's qa ƚii Amón. Pa' Amon'ik'i qa pa' ƚa's ƚii Josías. ");
INSERT INTO mca_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Pa' Josias'ik'i qa pa' ƚa's qa ƚii Jeconías, qa pe' ƚamatsits qa pe' ƚek'injats. Hik pakha'aj pa' ƚahats'ij pe' Israel qa t'opheƚitiiju' qa wetka'xii pa'aj pa' witset Babilonia. ");
INSERT INTO mca_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","In mexe i'ni'kii pa'aj pa' Babilonia pa' Jeconias'ik'i qa nekfik'i pa' ƚa's qa' ƚii Salatiel. Pa' Salatiel'ik'i qa pa' ƚa's qa ƚii Zorobabel. ");
INSERT INTO mca_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Pa' Zorobabel'ik'i qa pa' ƚa's qa ƚii Abiud. Pa' Abiud'ik'i qa pa' ƚa's qa ƚii Eliaquim. Pa' Eliaquim'ik'i qa pa' ƚa's qa ƚii Azor. ");
INSERT INTO mca_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Pa' Azor'ik'i qa pa' ƚa's qa ƚii Sadoc. Pa' Sadoc'ik'i qa pa' ƚa's qa ƚii Aquim. Pa' Aquim'ik'i qa pa' ƚa's qa ƚii Eliud. ");
INSERT INTO mca_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Pa' Eliud'ik'i qa pa' ƚa's qa ƚii Eleazar. Pa' Eleazar'ik'i qa pa' ƚa's qa ƚii Matán. Pa' Matan'ik'i qa pa' ƚa's qa ƚii Jacob. ");
INSERT INTO mca_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Pa' Jacob'ik'i qa ƚa's pa' José, ƚewhe'ye' ke' María, hikke' ƚenene ha' Jesús, hikha' ƚenqii iye Cristo. ");
INSERT INTO mca_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pa' Abraham'ik'i uja'x yamets pe' ta'ƚets catorce (14) ma' qa hats yametsji' pa' David'ik'i, qa pa' David'ik'i uja'x yametsji' iye catorce (14) iye pe' ta'ƚets, qa hik pa'aj t'opheƚitiiju' qa wetka'xii pa'aj pa' witset Babilonia. Qa catorce (14) iye yametsji' pekhewep iye ta'ƚets, ma' qa hikpe' qa ta'ƚji'ju' ha' Cristo. ");
INSERT INTO mca_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aka'an ƚunye'jkii pa'aj in i'nk'a nekfik'i pakha'aj ha' Jesucristo. Ke' ƚenene ƚii María jutsiqetsi'ƚ wetju'ƚ pa'aj qu' ƚewhe'ye'yi'ij pa' José. In mexente' i'ntaxijupha' pa'aj qa yiwkajitsheninƚe pa' ƚet'unha'x pa' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pa' José, María ƚewhe'ye', yatsathen. Nite' yisu'un qu' pekhel ƚ'anye'ji'ijkii pa'aj ke' María, qa yisu'un qu' niliƚi'ij qa'nte' nenikfe'le'ets pekhewep. ");
INSERT INTO mca_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","In mexe yijamtitaxijupkii pa'aj aka'an, qa in ima' qa itsowoƚ'axij pa'aj pa' ewi'ƚ ángel ta'ƚii pa' Yatsat'ax'inij, qa yit'ijets pa'aj: —José, ta'ƚets ka' David'ik'i, hasu'uj e'nijiwei qu' ni'ijup ne' María qu' ewhe'ye'yi'ij qe pa' ƚa's qu' nenektaxfik'i ta'ƚets na' ƚet'unha'x na' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne' María qu' nenektaxfik'i pa' ƚa's qa eqiyi'ij hatse' Jesús. Ƚii aka'an qe qa' naqsi'jij pe' ƚewuƚ'ets ene' jukhew qa efuts ha'ne ƚetset.— ");
INSERT INTO mca_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Week aka'an in ƚunye'jkii qe qa' nafits aka' yit'ij pa'aj pa' Yatsat'ax'inij in i'nijji' pa' ewi'ƚ profeta qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Pekhe' mexe ham yawitjiye' qa' niwkajitshen, qa' nana'l pa' ƚa's qa' ƚeqiyi'ij Emanuel.— Qa aka'an qa ikji' —Dios in initji'ju'.— ");
INSERT INTO mca_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma' qa in nompha'm pa' José qa tek'eenik'iha pa' yit'ijets pa' Yatsat'ax'inij ƚaqa ángel qa i'nijup pa'aj ke' María. ");
INSERT INTO mca_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Qa nite'ƚe ewi'ƚ i'wi'ƚi' nite' t'eku'mets iye, pekhe'en qa nekfik'i pa' ƚa's, qa pa' José qa ƚeqiyij Jesús. ");
INSERT INTO mca_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","In hats neki'fik'i pa'aj ha' Jesús ha' witset'ii Belén, hikha' witset yatsat'axij ha' sehe' Judea, hik pakha'aj mexe tenek'enhei pa' Herodes. Qa namets pa'aj ha' witset Jerusalén pe' jukhew ta'ƚii pa' neƚu'uju'ƚ. Pekhewe'en nikfe'lets qa yejeƚijupkiiha iye ne' footekii, ");
INSERT INTO mca_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","qa inaqfaakaniikii pa'aj: —¿Pa'n i'ni' pa' ƚatata ene' judío pa' hane'ej nekfik'i? Qe hi'weni'ƚii ke' ƚoqo footeki' in nekpha'm na' neƚu'uju'ƚ qa heneki'ƚii qu' nek'iyini'ƚii pakha'an.— ");
INSERT INTO mca_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pa' wittata Herodes in yepi'ye' ek'i aka'an ma' qa qi in yitawje'meten pa'aj qa week iye pe' tetseti'yi' ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma' qa iyinii qa no'thet wetju'ƚ pe' week tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei, qa nifaakanij pa'aj pa'n neki'fik'i hatse' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pekhewe'en qa yit'ijju' pa'aj: —Na' Belenii na' sehe' ƚii Judea qe hik aka' yika'ajji' pa'aj pa' ewi'ƚ profeta in yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Akha' witset Belén, yatsat'axij na' sehe' Judá, nite' t'an epji' qu' nite' eqiye' pe' week witsetits na' sehe' Judá, qe akha' qu' nat'atsji'ƚ e'pha'm hatse' pa' ewi'ƚ qi qu' netnek'enhei qa' nejeƚets na' yitset Israel.”— ");
INSERT INTO mca_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pa' Herodes qa wanat'inij in iyinii iye pa'aj pe' jukhew pe' nikfe'lets pe' footekii. Ma' qa nifaakanijha pa'aj, qa yit'ijets: —¿Pa'n uja'xik'i juwelits in ƚi'weni'ƚii pe' footeki'?— ");
INSERT INTO mca_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma' qa yukinii ha' Belén qa yit'ijets pa'aj: —Ma'aƚii qa' anfaakani'ƚiikiiha pa' iini'ha pa' omeƚa's. Qu' i'weni'ƚ qa' enfeli'ƚ ye'm ma' qa' hakjiiyek qa' nek'iyinjiiyek.— ");
INSERT INTO mca_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ekewe'en ƚ'anye'jets pa'aj pa' Herodes pe' jukhew ma' qa ikkii pa'aj. Qa pe' footeki' pe' hayiits yi'wenii pa'aj na' neƚu'uju'ƚ qa yi'wen iye qa ikik'ui yojo'ok'oi pa'aj pe' jukhew qa yamii pa' i'ni' pa' omeƚa's. Ma' qa amani' pe' footeki' qa i'nipji' pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pe' jukhew in yi'wenii iye pe' footeki' ma' qa qi in ƚe'sitsi'mkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ma' qa uyifi pe' ƚetsi' qa yi'wen pa'aj pa' omeƚa's qa pe' ƚenene María. Ma' qa wonokok'enijupju'kii qa iyinii pa' omeƚa's. Qa sujƚe qa nit'osƚe' pe' ƚeqeti'najkii qa tisij pe' oro qa na'aj tene'ƚju' ewjisii incienso qa' pakhap ewjisii qa ƚii mirra. ");
INSERT INTO mca_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma' qa in ima'ju' pa'aj pe' jukhew qa itsowoƚ'etsij pa' Intata qa yit'ijets pa'aj: —Hasu'uj mapiliƚii iye ha' Herodes na' i'ni'. Tujtseika' ma'aƚji' qu' mapiliƚii iye na' etset'iƚ.— Qa ikkii pa'aj qa wapilii pa' ƚetset ikik'i pakhap wit'ikheyi'j. ");
INSERT INTO mca_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","In ikkii pa'aj pe' jukhew qa neketsju' pa'aj pa' ewi'ƚ ƚaqa ángel pa' Yatsat'ax'inij itsowoƚ'axij pa' José qa yit'ijets pa'aj: —Eniipha'm. Ku'mi' na' omeƚa's qa ne' ƚenene iye qa' ilati'ƚetsfik'i na' Egipto ƚeqe sehe' qa' hikna' qu' ni'eku'niƚi' teek jutsitax qu' hit'iƚij ewets iye qa' etpili'ƚets. Qe niwoyo'oikii na' Herodes qu' nilan ha'ne omeƚa's.— ");
INSERT INTO mca_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma' qa niipha'm pa' José qa yeka'x pa'aj pa' omeƚa's qa ke' ƚenene iye naja'xij pa'aj. Ma' qa ikkii qa yamii pa' Egipto. ");
INSERT INTO mca_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Qa hik pakha' qa i'ni' ipƚu'ui in wa'm pa' Herodes'ik'i. Hik aka' ƚunye'j qe qa' nasinik'i pa' ƚ'anye'j pa'aj pa' Yatsat'ax'inij in i'nijji' pa'aj pa' ewi'ƚ profeta qa yit'ij: —Na' Egipto ƚeqe sehe' hikna' i'ntaxi' in haiya'yii na' ya's.— ");
INSERT INTO mca_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma' qa in nikfe'lets pa' Herodes in yaqankii pe' jukhew qa qi in nayu'kii. Qa inoqwoninii pe' week omehets qu' nanlanju' week pe' wetsjuk ƚeqe'ninqapits yamijiiju' na'aj i'nk'a nekfik'i. Qa' nanlanju' pe' week omehets pa' Belén qa pe' ipƚuletskii iye witsetits pakha' hats yumti qu' ƚuk'eye' pa' omeƚa's. Qe yijamti'ik'i pa' ipƚu'uk'i pa' yit'ijju' pe' jukhew in i'nk'a yi'wenii pe' footeki'. ");
INSERT INTO mca_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma' qa yasiinik'iha iye pa'aj pa' tooxik'i nifel pa' ewi'ƚ profeta'ik'i ƚii Jeremías in yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—Tepiikaxtii pe' qi in ip efu Ramá ƚeiƚeki'. Ip qa qi in yejtsi'le'kii pe' Raquel yayintaxik'i pe' ƚelitsik'i. Nite' ƚeke' qu' namehet pe'ye', qe hats naxju' pe' ƚelitsik'i.— ");
INSERT INTO mca_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma' qa in hats wa'm pa'aj pa' Herodes'ik'i, qa pa' Yatsat'ax'inij ƚaqa ángel qa te'nilit'etsju' iye pa' José in mexe amaneyi' pa'aj pa' Egipto. Ƚots'owoƚ'axƚe iye qa yit'ijets pa'aj: ");
INSERT INTO mca_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Eniipha'm qa' ku'mi' na' omeƚa's qa ne' ƚenene iye qa' mapiliƚetsji' iye na' Israel ƚeqe sehe' qe hats naxju' ke' neqek'uyu'taxij na' omeƚa's.— ");
INSERT INTO mca_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma' qa niipha'm pa'aj qa t'eku'mi' pa' omeƚa's qa ke' ƚenene iye qa wapilii iye na' Israel ƚeqe sehe'. ");
INSERT INTO mca_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma' qa pa' José qa nijiwei qu' amani'i' pa' Judea ƚeqe sehe' in i'ye'ej pa' Arquelao, Herodes'ik'i ƚa's in yaya'xi' in tenek'enhe'yi' ha' Judea. Qa itsowoƚ'axij iye pa' Intata qa nite' amaneyi' ha' Judea. Ma' qa ikkii iye qa yamii ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","In yamets pa'aj ha' Galilea ma' qa i'ni'kii ha' witset ƚii Nazaret. Ma' qa hats yasiinik'iha pa' ƚ'anye'j iye pa'aj tooxik'i pa' ewi'ƚ profeta yika'ajji' pa'aj ke' Intata ƚe'lijei: —Pakha'an qa' ƚenqiyi'ij hatse' Nazaret ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Qa hik pakha'aj pe' neƚutsji' qa hats yamets ƚahats'ij ka' Juan Bautista in we'nethinkii qa te'wenheti'yi' in i'nq'ijatsheni' ha' ham i'ni'i' hakha' sehe' Judea, qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Ili'iƚij pe' uƚ'ets in ƚaqsiiƚijkii qe pa' tenek'enheiji' pa' Dios hats met ma' qa' hats na'nju'.— ");
INSERT INTO mca_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ha'ne Juan hik ha'ne pa' toxik'i nifel pa'aj pa' profeta'ik'i Isaías in yit'ij: —Tepiikaxtii pa' ƚ'a'x pa' taya'yi'kii pa' ham i'ni'i' in yit'ij: “Aqsi'ji'ƚik'i pa'qu' ƚikheyije' pa' Yatsat'ax'inij, qa' natsathen iye hasu'uj q'if'imme' pe'qu' ƚ'ikheijeye'.”— ");
INSERT INTO mca_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pe' ƚeqhinatai pa' Juan taqsijkitiyijkii ne'ej ats'etets ƚ'ewkujits qa pa' ƚeqelutsax qa inqa'met ƚ'aj qa pe' ƚaqats qa efenheyik'i qa na'aj ƚene'ji' witaq. ");
INSERT INTO mca_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Olots pe' nekii nexpiikeyu'uj pa' Juan uja'x pe' ta'ƚii ha' Jerusalén qa pe' week pe' witsetits ƚelits Judea ƚeiƚets qa pe' ta'ƚiyek pe' metitsi'm pa' qi haqqi' Jordán. ");
INSERT INTO mca_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pe' tetfeljiiji'm pe' ƚewuƚ'ets, ma' qa' ka' Juan qa nimpuujinji'ijji'ju' ha' haqqi' Jordán. ");
INSERT INTO mca_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Qa in yi'wen pa' Juan in olots pe' fariseol qa pe' saduceol iye in nektaxii qu' nenimpuujinju' iye qa yit'ijets pa'aj: —Hik ejunyejeyi'ƚ q'oiq'oyits ƚelits. ¿Ƚekpa' nifeli'ƚ e'm qu' ƚeke'ye' qu' ilati'ƚik'ui hatse' pa' qi iftsax ƚawak pa' Dios? ");
INSERT INTO mca_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Manaqsiji'ƚju'ha yijat'ij pa'qu' ejunyejeyi'iƚ qu' yijaayi'ija qu' menink'aihiti'ƚ hats'inha qa' ne'twenhetii. ");
INSERT INTO mca_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hasu'uj umti'iƚ qu' nelithiniƚik'ui hatse' pa' qi ƚawak hatse' pa' Intata qu' it'iƚij: “Yekheweli'ƚ hata'ƚi'ƚets pa' Abraham'ik'i”. Qe yijaa'ija qu' hit'iƚij ewets pa' Dios in ƚeke' qu' naqsiijkii ene' utel qu' ƚelitsi'ij pa' Abraham'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Qa pe' witfejinetki' qa hats we'nenijupju' pa' ƚefitets pe' najkakui. Qa hik ta'ƚijupi', week pe'qu' najkak'e qu' nite' ƚe'sitse' pe'qu' ƚeye' qa' newetfekinifi qa' netwumhitiiji'ju' pa' fe't. ");
INSERT INTO mca_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yakha' yijaa'ija in k'empuujini'ƚji' ha'ne iweli'ƚe qa ikji' qu' hats ili'iƚij pe' uƚ'ets in ƚaqsiiƚijkii, qa hakha'ƚe teke'lenju' qu' nanam hatse' qa' nempuujini'ƚji' pa' Espíritu Santo qa pa' fe't iye. Hakha'an les t'un. T'anyipji'. Yakha' nite' ye'weju'ƚij qu' henit'ijji' pe' ƚ'otshilaxtii. ");
INSERT INTO mca_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hats t'eku'mi'kii pe' ƚeqe tseyem qa' niwu'mpha'mkii qu' naqsi'jji' pe' trigo hats'inha pa' t'unik'i qa' niwu'mkii pe' ƚ'ajits. Qa pe' ƚoi qa' naqsi'j qa' nenifi pe' ƚextsi'ij, qa pekhewe'ƚe ƚ'ajits qa' niwu'mji'ju'kii pa' fe't nite' yom.— ");
INSERT INTO mca_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ha' Jesús ta'ƚii pa'aj ha' Galilea qa nametsju' ha' haqqi' Jordán, hikha' i'ni' pa'aj pa' Juan qe qa nimpuujin iye. ");
INSERT INTO mca_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","In i'nk'a pa'aj, pa' Juan nite' yisu'untax qu' nimpuujin ha' Jesús qa yittaxijets: —Yakha'tax yijat'ij qu' etsimpuujin. ¿Qa inhats'ek in ƚanamyii qu' k'empulijin?— ");
INSERT INTO mca_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Qa yit'ij pa'aj ha' Jesús: —Inye'jƚu' qu' etsimpuujin qe les ƚe'wis qu' jintaqsiijkii week pa'qu' nisu'un na' Dios.— Ma' qa tek'eniju'ƚ pa'aj pa' Juan. ");
INSERT INTO mca_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","In yili'ij in yimpuujin qa ikik'uipha'm pa'aj ha' iweli', qa hik pa'aj qa qhofii na' wa'sji' qa yi'wen pa' Intata ƚeqe Espíritu hik ƚunye'jtax ofo' in te'nilit'etsju' qa i'nipji' pa'aj ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma' qa yepi'ye' pa' ewi'ƚ wit'ax nokesiipha'm na' wa's qa yit'ij pa'aj: —Hane'en hik ha'ne yaa'sija qi in hisu'un qi in tsi'sinheti'mkii.— ");
INSERT INTO mca_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Qa aje'eƚ pa' Espíritu Santo qa yeka'xii ha' Jesús pa' ham i'ni'i' qu' nijaajin pa' inwo'met. ");
INSERT INTO mca_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ham tuje' pa'aj yamijets cuarenta (40) neƚuts qa cuarenta (40) najai iye. Ma' qa i'nk'aƚe yoksi'wen in iyipkun pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pa' inwo'met qa nekets pa'aj qu' nijaajin, qa yit'ijets pa'aj: —Qu' yijaayi'ija qu' o' Dios ƚa'se' qa' it'ijets ene' utel qu' pani'ij.— ");
INSERT INTO mca_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Qa yeku'ƚ pa'aj ha' Jesús: —Ke' we'nika'ajji' yit'ij: “Nite' ewi'ƚƚe pa'qu' pane qu' niƚin pa'qu' jukhewe', qe ke' week ƚe'lijei na' Dios yiƚin iye pa'qu' jukhewe'.”— ");
INSERT INTO mca_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ma' qa pa' inwo'met qa yeka'xii pa'aj na' witset Jerusalén. Qa yeka'xiipha'm pa'aj ƚesinje'eipha'm ne' qi witlijtsitjii, qa yit'ijets pa'aj: ");
INSERT INTO mca_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Qu' yijaayi'ija qu' o' Dios ƚa'se', ilit'iiju' qe ke' we'nika'ajji' yit'ij iye: “Qa' nenukinju' ne' ƚaqa angelits qa' nejeƚ ewets. Qa pe' ƚokoyei qa' net'eku'm e' hats'inha qa'nte' neqfe'metene' ne' utel ne' ef'iyei.”— ");
INSERT INTO mca_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Qa yeku'ƚ iye pa'aj ha' Jesús qa' yit'ij: —Yit'ij iye ke' Dios ƚe'lijei: “Hasu'uj ijaajin pa' Yatsat'ax'inij eqe Dios.”— ");
INSERT INTO mca_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Qa ewi'ƚij iye pa'aj pa' inwo'met qa yeka'xii iye pe' ewi'ƚ qipha'm utek ma' qa yethinij pe' week witsetits in week yiwq'axin pe' ƚewekwekits. ");
INSERT INTO mca_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Qa yit'ijets: —Week qu' k'eƚisij enewe'en qu' monokok'enyifi qa' iyinyii.— ");
INSERT INTO mca_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma' qa ha' Jesús qa yit'ij pa'aj: —Yape iƚun inwo'met. Qe ke' we'nika'ajji' Dios ƚe'lijei yit'ij: “Iyinii pa' Yatsat'ax'inij eqe Dios. Ewi'ƚƚe qu' aqsiijkii pa'qu' nit'ij.”— ");
INSERT INTO mca_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma' qa pa' inwo'met qa ikik'ui pa'aj ha' Jesús. Qa namets pe' angelits qa t'ifti'ts'ets pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","In i'ye'ej pa'aj ha' Jesús in i'nifi pe' witq'opheƚitjii pa' Juan, qa ik pa'aj qa yamii ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Qa nite'ƚe amani' ha' witset Nazaret qa ikii qu' na'ni' ha' witset Capernaum meti'm ha' ƚotkoyek ke' kaƚi' te'weyij hekhewe' sehel Zabulón qa Neftalí. ");
INSERT INTO mca_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aka'an in ƚunye'jkii qe qa' nasiinik'iha pa' ƚ'anye'j pa'aj pa' profeta'ik'i Isaías in yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Sehe' Zabulón qa sehe' Neftalí, ikji'teje'm na' wit'ikheyi'j yamiiju' na' qi iweli' neƚu'uju'ƚ te'weyi'mii na' haqqi' Jordán. Sehe' Galilea i'ni' ne' olots nite' Judiol. ");
INSERT INTO mca_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ne' tetseti'yi' i'ntaxji'teje'm na' qi nookii hane'ej qa yi'wen na' qi na'lkii. Qa nekhewe' i'ntaxji'teje'm na' ƚeq'eneƚeya'x na' witwamhi' qa naliti'pji' pa' qi na'lkii.— ");
INSERT INTO mca_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Qa hik pa'aj i'nk'aƚe we'nq'ijatshen ha' Jesús qa yit'ij pa'aj: —Ili'iƚij pe' uƚ'ets in ƚaqsi'ji'ƚijkii qe na' tenek'enheiji' na' Dios hats met ma' qa' hats na'nju'.— ");
INSERT INTO mca_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ha' Jesús qa ikik'iju' pa'aj ha' ƚotkoyek ke' kaƚi' Galilea qa yi'wen pa'aj he' wetsjuk witjefeye'k. Ewi'ƚ ha' ƚii Simón, qa ƚii iye Pedro qa hakhap iye qa ƚii Andrés. Enewe'en mexe teq'ehemkiiju' pa'aj qe hik aka' ƚ'ithayijkit ek. ");
INSERT INTO mca_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma' qa ha' Jesús qa yit'ijets pa'aj: —Atsjayani'ƚ, qa k'eƚisiƚij qu' mowo'oƚii ene' jukhew qu' hik ƚunye'je' in ƚeq'ehemkiyiƚju'.— ");
INSERT INTO mca_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Qa aje'eƚ nejet pa'aj pe' ƚeq'ehemkil qa yijayan pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Qa pa' ha'niiji'in qa yi'wen iye pa'aj hekhewep witjefeye'k iye ƚelits ha' Zebedeo ƚiyits, Jacobo (Santiago) qa ha' Juan. I'nji' pa'aj pe' ƚenhitjii tokoyei ƚasi' weeki'ƚ ha' ƚatata, yitiƚ pa'aj pe' ƚeq'ehemkil. Ha' Jesús qa taya'yiiji' iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hekhewe'en qa aje'eƚ yiwejini' pa'aj pe' ƚenhitjii tokoyei ƚasi' qa yiwejini' iye ha' ƚatata, ma' qa yijayan iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ha' Jesús qa week yijalki'sik'i pa'aj ha' Galilea. Week pe' witlijtsitjiyits yamji'jets qa yijatshenji'ij qa nifelji'ij iye eke' ƚe'sits wi'tlijei t'ejuyets pa' tenek'enheiji' pa' Dios, qa niƚinju'kii iye pe' pekhel ƚunyejeikii pe' ƚaja'metets qa pe' pekhel yaats'e'eju'kii. ");
INSERT INTO mca_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma' qa pa' ƚeniihe't pa'aj ha' Jesús qa weekij pa'aj ha' sehe' Siria, qa neka'xii week pe' pekhel ƚaatshenye'jeikii. Uja'x pe' qi wanqaats'eju', qa pe' i'nji' pe' inwo'metets, qa pe' akathenhets, qa pe' onqokits iye, qa week yaqsi'jju' niƚinju' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Olootsija pa'aj pe' yijayan ha' Jesús pe' ta'ƚii ha' sehe' Galilea qa pe' ta'ƚii he' witsetits Decápolis qa na' Jerusalén qa pe' ta'ƚii iye ha' sehe' Judea qa pe' neƚu'uju'ƚ te'weyii na' ƚajaika' ai na' haqqi' Jordán. ");
INSERT INTO mca_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","In yi'wen pa'aj ha' Jesús in olots pe' jukhew qa efuts iye, qa ikik'ipha'm ke' utek qa hikha' qa i'niju'. Pe' yijatshen qa nekets pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma' qa i'nq'ijatshen qa yit'ij pa'aj in iyet: ");
INSERT INTO mca_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ƚe'sitsi'mkii pe'qu' nit'ij ƚetets qu' ham ne'weju'ƚi'ij qu' hamitsi'im na' Intata, qe na' tenek'enheiji' na' Dios hats i'nji'teje'm. ");
INSERT INTO mca_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ƚe'sitsi'mkii pe'qu' nikametetskii qa na' Dios qa' ne'nq'eletij qa' ni'sinheti'mkii iye. ");
INSERT INTO mca_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ƚe'sitsi'mkii pe'qu' netf'iljetsin nite' watpatunen iye qe ƚekhewel tisij hatse' na' sehe' na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ƚe'sitsi'mkii pekhewe' qu' nisu'unija qu' naqsiijkii pa' yatsathen qa na' Dios qa' ni'fenij. ");
INSERT INTO mca_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ƚe'sitsi'mkii pe'qu' ne'nq'eletij pekhewepe' iye qa na' Intata qa' nenq'eletjiijek. ");
INSERT INTO mca_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ƚe'sitsi'mkii pe'qu' hats hamitse'ji' pe' ƚatawjets pe' ƚewuƚ'ets qe hats tetlijijju', qa' ni'wen hatse' na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ƚe'sitsi'mkii pe'qu' ni'sinhet wetju'ƚ pe'qu' na'nayu' wetju'ƚ qa' netitijiti'yijets qu' ƚelitse' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ƚe'sitsi'mkii pe'qu' natawitjaxtii qe ta'ƚets in yatsathen qa tek'eenetsha na' Intata, qe ƚekhewel i'nji'teje'm nakha' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ƚe'sitsi'iƚ e'mkii qu' nit'iƚij ewets uƚ'axe' qa wekwek wi'tlijei uƚ'etsik'i qa nawitji'iƚ iye qa wotk'oniƚ'ejkii yit'ijets qu' uƚ'axe' pa'qu' aqsiiƚijkii, qe ta'ƚijupi' in ƚ'ek'eni'ƚ yiwetsha. ");
INSERT INTO mca_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","E'ƚe'sitsi'iƚi'mkiiha qa' ƚe'sitsi'imkiiha iye pe' atawjetsi'ƚ qe na'l hatse' pa' qi ƚe'wis enisit'iƚ qu' amtaxi'ƚii na' wa's. Qe hik ƚunyejei iye ke' yojo profeta'ik'i in tawitjaxtii.— ");
INSERT INTO mca_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Ekheweli'ƚ hik ejunyejeyi'ƚ witlepinek ha'ne sehe' ipji'. Pa' witlepinek qu'nte' ek'eme'ye'ji' ¿pa'n ƚunye'j qu' ƚeke'ye' iye qu' ek'eme'ye'ji' iye? Ham ƚeke'ye'. Qa' netwumhitiiƚe' qa' not'otsipji'kii ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ekheweli'ƚ hik ejunyejeyi'ƚ fetitjii nalitipji' ha'ne sehe' ipji'. Pa'qu' ewi'ƚƚe witset'e i'nipji' ƚesinje' pe'qu' qiye'pha'm utek qa nite' ƚeke' qu' nanat'inkii. ");
INSERT INTO mca_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ham pa'qu' ƚeqfenye'ji'ij qu' nene'ƚji' fetitjiye' qa' niyinji'ju' pe'qu' ti'najki'ye'. Les ƚeke' yijat'ij qe we'nenpha'm hats'inha qa week nalitipji' ne'ej i'ni' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Qa ekheweli'ƚ aqsiiƚijkii hik ejunyejeyi'iƚ ne'ej fetitjii qe nalitipji' qa' nana'lkii qa' ni'wen ene' jukhew pa' ƚaqsiiƚijkii in ƚe'wis qa' nit'ijets: “Maa hayits qa ƚe'wisija pa' Ƚatata Dios i'ni' na' wa's.”— ");
INSERT INTO mca_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Hasu'uj umti'iƚ qu' natsamijetsju' qu' hiwu'm ke' ƚe'lijei na' Tata yika' ka' Moises'ik'i qa kekhewep iye yika' ke' profeta'ik'i. Nite' tsamijetsju' qu' hiwu'm, qe tsamijetsju' yijat'ij qe qa' nafits pa' yit'ij ekewe'en. ");
INSERT INTO mca_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Qe yijaa'ija aka' qu' hit'iƚij ewets in mexe na'l na' wa's qa ha'ne sehe' qa nite' ƚeke' qu' ƚammise' pa'qu' hame' ekewe'en. Nite' ewiiƚe' pe'qu' witq'ikati'ye' qu' nawa'mik'i, ipƚu'ui qu' week nafits ekewe'en. ");
INSERT INTO mca_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Qa hik ta'ƚijupi' pakha' qu'nte' nisu'une' pa'qu' ewi'ƚe' yemjeetax pakha' les in nite' qitax ekewe' wenit'ij qu' jintaqsiijkii qa t'otsipji'kii, ma' qa hik aka' yijatshenij iye pekhewep, pakha'an qa' netitijitiyijets hatse' qu' les nite' qiye' qu' namtaxii na' tenek'enheiji' na' Intata na' wa'sji'. Qa pakha'ƚe qu' netk'enik'i qa yijatshenij iye pekhewep, ma' qa pakha'an qa' netitijitiyijets hatse' qu' les qiye' qu' namtaxii na' tenek'enheiji' na' Intata wa'sji'. ");
INSERT INTO mca_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Qa hik ta'ƚijupi' qu' hit'iƚij ewets in nite' ƚeke' qu' uyi'ƚ ji'teje'm na' tenek'enheiji' na' Intata qu' nite' les ani'iƚipji' qu' atsatheni'ƚ ne' i'nq'ijatshenij ke' Moisés ƚe'lijei qa ne' fariseol iye.— ");
INSERT INTO mca_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Ekheweli'ƚ hats ƚ'impi'ye'eƚij ke' aqa'jteyi'ƚik'i in yit'ijets: “Hasu'uj eqek'ui, qe pa'qu' netqek'ui qa' newetka'xetsji' pekhewe' qu' nejeƚik'ui pa'qu' ƚunye'je'kii (tribunal) ma' qa' natfaakanhetiikii.” ");
INSERT INTO mca_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Qa Yakha'ƚe qa' hit'ijek, pakha' qu' na'nayu'um pa'qu' ƚejefeye' qa hats iftsaxets qu' newetka'xetsji' pekhewe' qu' nejeƚik'ui pa'qu' ƚunye'je'kii (tribunal) ma' qa' natfaakanhetiikii. Qa pa'qu' nit'ijets pa'qu' ƚejefeye': “Ham e'wejuƚi'ij” qa hats iftsaxets qu' newetka'xetsji' pekhewe' qu' les qitse'ji' qu' nejeƚik'ui pa'qu' ƚunye'je'kii (tribunal superior) ma' qa' natfaakanhetiikii. Qa pa'qu' nit'ijets ƚejefeye', “ƚujtsek na' qhuf” ma' qa hats iftsaxets qu' namii pa' fe't qi iftsax. ");
INSERT INTO mca_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Qa hik ta'ƚijupi' qu' enqistineyutaxij pe'ye' na' Intata in hats ƚamii pa' ts'eewe'epji' t'ejuyets qu' ƚisij ma' qa' lemme' atawe'j in mexe uƚ'etsi'ƚ wetju'ƚ pa'qu' ejefeye' qa' hasu'uj ƚis eku'nij pa' ƚenqistineyutaxij na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ma' qa hik pakha'ƚe enejet eku'ni', qa' ma'aku'nii pa' ejefe. Qa qu' hats e'ƚe'sitsi'iƚ wetju'ƚ iye, ma' qa hayitse' yijat'ij qu' ƚeke'ye' qu' ƚisij na' Intata pa' eqisit'ij. ");
INSERT INTO mca_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Qu' nana'l pa'qu' nenektax ei qu' nonq'opheƚineyu'tax ej qa' ijayan qa' afaakate'yi'ƚ aje'eƚ qu' mexente' ami'iƚii pa'qu' jueze' ma' qa' e'ƚe'sitsi'ƚ wetju'ƚ hats'inha qa'nte' ami'iƚii pa' juez. Qe qu' ami'ƚii, qa pa' juez qa' neka'xiyek pa'qu' witq'opheƚitjii ƚeiƚe'ye' ma' qa' nophee'ƚija. ");
INSERT INTO mca_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yijaa'ija aka' hit'ij ewets, in nite' ƚ'atsji'ƚfik'i aje'eƚ ipƚu'ui qu' week ijanin.— ");
INSERT INTO mca_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Ekheweli'ƚ hats ƚ'impi'ye'eƚij in wenit'ijets iye: “Hasu'uj ejtenij qu' a'qapi'i pekhepe' efuye' qu' hats ewhe'yei. Hasu'uj iye ejtenij qu' a'qapi'i pe'qu' hats nana'l ƚewhe'ye'ye'.” ");
INSERT INTO mca_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Qa yakha' qa hit'iƚij ewetsek pa'qu' nejeƚju' efuye' qa yisu'untax qu' qapi'i' qu' nawitji, ma' qa hats hik ƚunye'j qu' nawitji qa ƚatawe'jƚeji' i'nji'. ");
INSERT INTO mca_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne' yiyayik'i oto' qu' nata'ƚets in ƚaqsiijkii pa' uƚ'ax qa' les ƚe'wis qu' enit'ijpha'm qa' iwu'm, itonii, qe les ƚe'wis qu' ewi'ƚe' pa'qu' hame' na' ese'n hats'inha qa'nte' week netwumhitiyeji'ju' pa' fe't qi iftsax. ");
INSERT INTO mca_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na' yiya'yik'i okoi qu' hikna' nata'ƚets in ƚaqsiijkii pa' uƚ'ax qa' isa'xji' qa' iwu'm, itonii, qe les ƚe'wis qu' ewi'ƚe' pa'qu' hame' na' ese'n hats'inha qa'nte' week netwumhitiyeji'ju' pa' fe't qi iftsax.— ");
INSERT INTO mca_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Ƚ'impi'ye'eƚij iye in wenit'ij: “Pa'qu' neweqle qa' netisij pa'qu' ƚanfaakanek'e t'ejuyets qu' neweqle.” ");
INSERT INTO mca_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Qa yakha' qa hit'iƚij ewetsek pa'qu' jukhewe' qu' niliƚi'ij pe'qu' ƚewhe'ye'ye' hamtax ta'ƚi'ijupi' nite' wo'taxiikii jukhewe' qa niweqleyu'ƚe. Ma' qa pa' jukhew qa hats hikpa' ta'ƚets in yaqsiijkii aka' witwuƚ'ax pe' efu, in wo'oikii iye pakhape' jukhewe'. Qa pa'qu' ƚewhe'ye'yi'ij pe'qu' iwhe'yele'ye' ma' qa hats yaqsiijkii iye aka' witwuƚ'ax (adulterio).— ");
INSERT INTO mca_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Hats ƚ'impi'ye'eƚij iye in wenit'ij: “Hasu'uj aqanƚekii qu' meniwjutsiqen, aqsiijkii yijat'ij pe' hats ƚeniwjutsiqeniji'm pa' Yatsat'ax'inij.” ");
INSERT INTO mca_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Qa yakha' qa' hit'iƚij ewetsek iye. Hasu'uj meniwjutsiqeniji'm ene' wekwek qu' meniwjutsiqenij pe'ye', hasu'uj iye meniwjutsiqeniji'm na' wa's qe hik nakha' i'ni' na' ƚots'oji'la'x na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hasu'uj iye ha'ne sehe' qe hik ha'ne ƚ'otshi'la'x. Hasu'uj iye na' Jerusalén qe hikna' ƚetset na' qi Wittata. ");
INSERT INTO mca_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hasu'uj iye amets na' eiƚa' qe nite' ƚeke' qu' aqsiijkii qu' fo'yi'ik'i qa i'nƚi'i qu' no'yi'ik'i iye ewi'ƚe' ne' ewkujits. ");
INSERT INTO mca_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Natsatheenija yijat'ij qu' iyet. It'ij, “ehe”, i'nƚi'i qu' it'ij “nite'”. Qa qu' i'tƚetaxij pekhewepe' iye, ma' qa hats ta'ƚets pa' uƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Ƚ'impi'ye'eƚij iye in wenit'ij: “Pa'qu' nalan qu' nasinji' oto' qa' ilanji'ijji'ek ƚotoye'. Qa qu' nepƚetii ek'unheti'ye' qa' epƚetjiiyek ƚek'unheti'ye'.” ");
INSERT INTO mca_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Qa yakha' qa hit'iƚij ewetsek qu' hasu'uj atja'yi'ƚiju'ƚ pa'qu' na'nayu'kii. Pa'qu' ƚunye'je' qu' nilanje'm ekuki' ne' yiya'yik'i qa' eq'eheyijets iye ni'khep. ");
INSERT INTO mca_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Qu' nana'l pa'qu' nanqawitjineyutax'ej qa wo'tk'oni'mkii pe'qu' wit'alheyeji' pa'qu' witset'e, qa neqitkamhiyu' ej pa'qu' uihitjiye' qa' ƚisij iye pa'qu' aqa sakuye'. ");
INSERT INTO mca_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Qu' nana'l iye pa'qu' nekekinenijii ewi'ƚ kilometroye' pe'qu' ƚaqataye' qa' it'ij ju'f qu' wetsjuk kilometroye' pa'qu' ipƚu'yi'ijik'i. ");
INSERT INTO mca_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pa'qu' jukhewe' qu' niyinij ewets pe'ye' qa' ƚisij. Qa pa'qu' nanatkinheyu'uj ewets iye pe'ye' hasu'uj iyejini'm.— ");
INSERT INTO mca_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Hats ƚ'impi'ye'eƚij iye in wenit'ij iye: “Isu'un pe' ejuwaikalija qa pe'qu' ejuihifetse' qa' utenija.” ");
INSERT INTO mca_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Qa yakha' qa' hit'iƚij ewetsek, isu'uni'ƚ pe'qu' ejuihifetsi'iƚ. Iyini'ƚipji'kii yijat'ij pe'qu' uƚ'etsetaxik'ikii ƚe'lijeyi'iƚ ewetskii qa qi iye in nawitjitaxi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Qu' aqsiiƚijkii aka'an qa' hik ejunyejeyi'iƚ na' Atata'aƚ i'ni' na' wa's qe ƚakha' yaqsiijkii ne' junu' qa nekpha'm qa weekƚi'ij in nalitipji' pe' uƚ'ets qa pe' teik'unei iye. Qa nukinju' iye na'aj piƚei qa weekij iye pe' yatsathen qa pe' nite' yatsathen iye. ");
INSERT INTO mca_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Qu' uja'xe'ƚetax qu' isu'uni'ƚ pekhewe' qu' nesu'uni'ƚ ¿pa'n ƚii pa'qu' enisit'i'iƚipji'? Ham enisit'i'iƚipji'. ¿Me nite' hik aka' ƚunyejei ne' wo'ƚi'ii ƚ'astai yijaninkii wekwek in uja'xƚe in yisu'un pe' ƚejuwaikal? ");
INSERT INTO mca_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Qu' uja'xe'ƚe qu' mewetfeliƚi'm pe'qu' ejefetsi'iƚipji' na' Intata, ¿me qa hats tujtseika' pa'qu' aqsiiƚijkii qu' ejunyejeyi'iƚ aka'an? ¿Me nite' hik aka' yaqsiijkii iye ne' nite' yijayan na' Dios? ");
INSERT INTO mca_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","E'ƚe'sitsi'iƚha qa' hik ejunyejeyi'iƚ na' Atata'aƚ i'ni' na' wa's in ƚe'wiisija.— ");
INSERT INTO mca_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Hasu'uj qu' me'nethiniƚi'iƚijets pe'qu' jukhewe' qu' iftits'iƚijets pe'ye'. Qu' aqsiiƚijkii aka'an qa na' Atata'aƚ i'ni' na' wa's qa' ham neƚisi'iƚij. ");
INSERT INTO mca_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Qa hik ta'ƚijupi' qu' ƚisi'ƚij pe'ye' pe'qu' ham niwq'axine' hasu'uj pekhel enfeli'ƚji'kii qa' ifuyu'uƚik'i iye ne'ej foj qu' metetjunuti'ƚijkii, in ƚunyejeyek nekhewe' hik ƚunyejei qu' wetsjuk'e ƚejusitse' qa i'njiijifi ne' witlijtsitjiyifi qa ne' wit'ikheijeiji' iye, qe nekhewe'en yisu'unƚe qu' ni'wenij pe'qu' jukhewe' ma' qa ƚe'wis na'aj wenit'ijets. Yijaa'ija aka' hit'iƚij ewets, aka'an in hik aka'ƚe pa' ƚenisit'ij nekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Qu' ƚisi'ƚij pe'ye' pe'qu' ham niwq'axine' hasu'uj ne'weni'ƚij pe'ye', hasu'uj iye ne'weni'ƚij pa'qu' qi ejuwaika'ye'taxi'ƚ, hik ƚunye'je' yijat'ij qu' nite' nenikfe'le'ets na' efeyi'j okoi pa' yaqsiijkii na' yiya'yik'i okoi, ");
INSERT INTO mca_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","hats'inha qa' ham nenikfe'le'ets, qa na' Atata in hikna' week yi'wen qa nikfe'lets iye na'aj tat'inhetiitaxkii qa' neƚisjiijek pe'ye'.— ");
INSERT INTO mca_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ha' Jesús mexe iyet qa yit'ij iye: —Qu' iyini'ƚ hasu'uj ejunyejeyi'iƚiju'ƚ nekhewe' hik ƚunyejei qu' wetsjuk'e ƚejusitse', qe nekhewe'en yisu'un qu' ts'ap'ayi'ijifi qu' niyin ne' witlijtsitjiyitsifi qa hik ƚunyejei iye in yamii ne'ej ƚekfi'ii ne' wit'ikheijei qa iyin qe yisu'unƚe qu' ni'wenij ne'ej jukhew. Yijaa'ija aka' hit'iƚij ewets, aka'an in hik aka'ƚe pa' ƚenisit'ij nekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Qa akha'ƚe, qu' iyin uyifi pe'qu' etsi'ye' qa' it'onji' pa'qu' eqeji'ye'. Ma' qa' iyinii na' Atata ham ne'weni'ij qa ham nikfe'le'ets iye. Ma' qa na' Atata in hikna' week yi'wen qa nikfe'lets iye na'aj tat'inhetiitaxkii qa' neƚisjiijek pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Qu' iyin hasu'uj qu' iyeketijipji'kii e'lijei ham wejuƚi'ij, in ƚunyejeyek ne' nite' nikfe'lets na' Intata qe ƚekhewel yumtitax qu' net'eku'miju'ƚ na' Intata in olotsij in iyetƚe. ");
INSERT INTO mca_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Qa hik ta'ƚijupi' hasu'uj ejunyejeyi'iƚiju'ƚ nekhewe'en, qe na' Atata'aƚ hayiits nikfe'lets in mexe nite' ƚ'iyintaxi'ƚijets pa'qu' hamitsi'iƚ e'm. ");
INSERT INTO mca_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aka' eqfenyejeyi'ƚij yijat'ij qu' iyini'ƚ: “Intata i'ni' na' wa's, neniwqinhetji'ha aka' qiji' ii. ");
INSERT INTO mca_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yape enekju' qa enek'enhe'yipji' ha'ne sehe'. Yape aqsi'jijkii pa' ƚisu'un ma' qa hik ƚunye'je' na' wa'sji'. ");
INSERT INTO mca_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Esƚisi'ƚij ha'ne neƚuji' pa'qu' hetuji'ƚ in ƚunye'jek week neƚuts. ");
INSERT INTO mca_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iwu'mi'ƚyik'ui pe' uƚ'ets haqsi'ji'ƚijkii in yijunyejeyi'ƚek in hiwejinƚi'iƚ qa hats ye'ƚe'sitsi'ƚ wetju'ƚ iye week nekhewe' uƚ'ax yaqsi'jtaxi'ƚ ye'mijkii. ");
INSERT INTO mca_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hasu'uj etswejinƚi'iƚij qu' netswumi'ƚju' pa' witaqjaajinkeye'j, itoni'ƚ ye'mii yijat'ij pa' inwo'met. Qe akha' ƚantsat'etsij pa' witnek'enheye'j, pa' witt'unha'x qa pa' witisa'x, qa nite' yili'ij qu' antsat'etsij ene' week ƚahatsiyij. Amén.” ");
INSERT INTO mca_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Qe qu' iwejinƚi'iƚ pekhewe qu' uƚ'ax pa'qu' naqsi'jtaxi'ƚ e'mijkii, qa na' Atata'aƚ i'ni' na' wa's qa' ham jeek ƚeqfenyejeyi'iƚ ej. ");
INSERT INTO mca_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Qa qu' ku'mƚi'iƚiju'ƚ ma' qa' aqatja'yi'ƚij pekhewepe', qa na' Atata'aƚ qa' nana'l jeek pa'qu' ƚeqfenyejeyi'iƚ ej.— ");
INSERT INTO mca_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Ekheweli'ƚ qu' aqsiiƚijkii qu'nte' eki'iƚ qe ƚowo'iƚii na' Intata. Na'ltax pa'qu' aqi'iƚ, nite'ƚe ƚetuji'ƚ. Hasu'uj mujumme'pha'm ne' ejusitsi'ƚ in ƚunye'jek kakha' yaqsiijkii nekhewe' hik ƚunyejei qu' wetsjuk'e ƚejusits, qe ƚekhewel watanalitij in nite' tek qa mujumpha'm ƚejusits qe yisu'unƚe qu' ni'wenij pekhewepe' jukhew in nite' tek. Yijaa'ija aka' hit'iƚij ewets aka'an qa hik aka' ƚenisit'ij. ");
INSERT INTO mca_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Qa akha' qu'nte' eke' manaqsi'j metenelisju' iye qa' matanaxtapulij iye. ");
INSERT INTO mca_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hats'inha qa'nte' nenikfe'le'ets pekhewepe' in nite' ƚ'ek. Ewi'ƚƚe na' Atata qu' nenikfe'lets hik nakha' ham yi'wene'. Qa na' Atata in hikna' week yi'wen na'aj tat'inhetiitaxkii qa' neƚisjiijek pe'ye'.— ");
INSERT INTO mca_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Hasu'uj olotsinipji' ewekwekitse' qa aq'astaye' iye ha'ne sehe' ipji' qe tuj ƚeiƚets qa ƚawa'mhits iye. Qa hik ha'ne iye ha'ne sehe' ipji' pe' ejtenhetsilets uyetsji'kii qa t'ejtenijkii. ");
INSERT INTO mca_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Les ƚe'wis yijat'ij qu' olotsini' ewekwekitse' na' wa'sji'. Nite' tuj yijat'ij ƚeiƚets. Nite' ƚawa'mhits iye. Nite' ƚeke' iye qu' nuyetsji' pe'qu' ejtenhetsiletse' qa' net'ejtenijkii. ");
INSERT INTO mca_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Qe pa'qu' eni'ƚi' pe'qu' ewekwekitsi'iƚ qa' hik pakha' jeek qu' na'ni' pe' aqjamtikineyejeyi'ƚkii.— ");
INSERT INTO mca_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Ne' otoi hik ƚunyejei qu' ƚefetitjiye' na' ese'n, qa hik ta'ƚijupi', ne' otoi qu' ƚe'sitse' qa' nana'ljiim kiyek na' ese'n. ");
INSERT INTO mca_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Qa qu' uƚ'etse'ƚe ne' otoi qa' nooyejiimkiyek na' ese'n, qa hik ta'ƚijupi', pe' fetitjii i'ntax etji' qu' nite' netuje'ji', ¡maa hayits qa qi'ija qu' noo'ye'kii!— ");
INSERT INTO mca_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Nite' ƚeke' qu' wetsjuk'e pe'qu' patunitse' qu' net'ithayi'yi'm pa'qu' ewi'ƚ jukhewe'. Qe ewi'ƚ pa'qu' netk'enik'i ƚe'lijei qe yisu'un qa pakhap iye qa' nite' netk'enik'i ƚe'lijei qe yuten. Nite' ƚeke' qu' week aqa patunitsi'ij na' Dios qa eke' ƚ'astai.— ");
INSERT INTO mca_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Qa hik ta'ƚijupi' hane'ej qu' hit'iƚij ewets hasu'uj natawje'meteni'ƚ qu' ham aqi'iƚ i'nƚi'i pa'qu' iya'aƚji' qa i'nƚi'i iye qu' ham eqhinatayi'iƚ. ¿Me nite' les t'anipji' in mexe i'ƚiyi'ƚ pa'qu' aqi'iƚ? ¿Qa me nite' les t'anipji' iye ne' esenitsi'ƚ pe'qu' eqhinatayi'iƚ? ");
INSERT INTO mca_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jeƚ qeku'ni'ƚju' ne' na'ya'kii junatai. Nite' we'nq'en. Nite' nifte'ji' pe'qu' ƚeqeye'. Nite' yaqsi'j iye pe'qu' nenifte'ji' ƚeqei. Qa na' Atata'aƚ i'ni' na' wa's hikna' tisijkii pe' ƚaqats. ¿Me nite' ekheweli'ƚ les ƚ'ani'ƚi'pji' ne' junatai? ");
INSERT INTO mca_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ƚekpa' ekheweli'ƚ qu' nata'ƚets in yitawje'meten pa'qu' ƚiƚa'xe' ma' qa' ƚeke'ye' qu' naqsiijkii qu' les nijetin eku'nij iye? ");
INSERT INTO mca_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Qa inhats'ek in natawje'meteni'ƚ qu' ham eqhinatayi'iƚ? Jeƚi'ƚju' ne' ƚop'om ta'ƚi' na' ƚ'ejinqa'wet in nite' t'ithayiitax qa nite' taftiƚintax iye. ");
INSERT INTO mca_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Qa hit'iƚij ewets ka' wittata'ak'i Salomón in qitax in yiwq'axin ke' wekwek in wanaqsi'jtaxija nite' ƚunye'jiju'ƚ ne' ƚop'om. Qe ne' ƚop'om les qi in ƚe'sits wikfi'. ");
INSERT INTO mca_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Qa na' Dios in qi in ƚe'wis pa' ƚeqjunyejeyij enewe' uje' qu' nonoxp'onhetji qa' lomomeji' hane'ej na'l jup'elket ta'ƚi' na' ƚ'ejinqa'wet, ¿me qa nite' les qi qu' ne'feni'ƚ? Hayits qa ƚeqekuteetsi'ƚkii jukhew, efuts na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Qa hik ta'ƚijupi' qu' hasu'uj natawje'meteni'ƚ qu' it'iƚij: “Peijat'ij, ¿ƚekpa' qu' jinteƚuj?” I'nƚi'i qu' it'iƚij: “¿Ƚekpa' qu' ji'niyaji'?” Qa i'nƚi'i qu' it'iƚij: “¿ƚekpa' qu' jiteqhinataji'?” ");
INSERT INTO mca_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Week ekewe'en qi yitawje'meten ne' nite' nikfe'lets na' Intata, qa ekheweli'ƚ na' Atata'aƚ i'ni' na' wa's, ƚakha' hats nikfe'lets in nite' ƚisu'untaxi'ƚ qu' hamitsi'iƚ ejup week ekewe'en. ");
INSERT INTO mca_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Qa lesƚe ƚe'wis qu' nojo qu' mowo'oi na' tenek'enheiji' na' Dios qa qu' aqsiijkii iye pa' yatsathen in ƚunye'jek pa' yisu'un qu' eqfenyejeyi'iƚ ewek. Ma' qa' hayitse' qa' esti'yij week ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Qa hik ta'ƚijupi' hasu'uj natawje'meten pakhap neƚuiyeji', qe pakhape' neƚu na'l iye pe'qu' natawje'meten. Week ene' neƚutsji' yeqet'etsij wetju'ƚkii pe' wekwek qu' natawje'meten.— ");
INSERT INTO mca_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Hasu'uj ejefitkii pe'ye' hats'inha qa' ham jeek nenit'i'ij ewets. ");
INSERT INTO mca_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Qe qu' ejefitkii pe'ye' qa hik ƚunye'je' iye qu' nejefitji'ijkiyek pakhape'. Qa pa' equk'e'ejji' pa' ejifeta'x qa' hik pakha' jeek iye qu' ƚuk'eyeji' pa'qu' netpil epji'. ");
INSERT INTO mca_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Qa inhats'ek in ƚejeƚju' na' jup'el ƚa's i'nji' ne' ƚoto' na' ejefe qa akha' qa nite' ƚewetjeƚ in i'nji' ne' oto' na' qi'ik'i najak? ");
INSERT INTO mca_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Pa'n ƚunye'j qu' it'ijets pa'qu' ejefeye': “Etswejinij qu' hiwu'm ek'ui na' i'nji' ne' oto' jup'el ƚa's,” in akha' iye les qi'ik'i na' najak i'nji' ne' oto'? ");
INSERT INTO mca_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡E'jtitsax hik ejunye'j qu' wetsjuk'e ejusitse'! Ojo'oj yijat'ij qu' iwu'm na' qi'ik'i najak i'nji' ne' oto'. Hats'inha qa' i'wenetsju' yijat'ij qu' iwu'mik'ui na' jup'el ƚa's i'nji' ne' ƚoto' na' ejefe. ");
INSERT INTO mca_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Hasu'uj ƚisi'ƚij eke' ta'ƚets na' Dios nekhewe' jukhew hik ƚunyejei nunajits. Hasu'uj iye ƚisi'ƚij eke' qi ƚe'sits hik ƚunyejei ute na'lje'mkii (perlas) nekhewe' jukhew hik ƚunyejei tafitets, qe i'nƚi'i qu' not'otsƚi'ipji'kii ma' qa nente'nilit ewets qa' newu'mju'.— ");
INSERT INTO mca_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Iyini'ƚets qa neƚisi'ƚij na' Dios. Mowo'oƚiikii qa' i'weni'ƚ. Ilani'ƚetskii na' ƚeji' qa' nenit'iƚij e'mii qhof. ");
INSERT INTO mca_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Qe na'aj iyinkii qa testii. Qa na'aj wo'oikii qa yi'wen. Qa na'aj yilanetskii na'aj ƚeji' qa wenit'iji'mii qhof. ");
INSERT INTO mca_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Pa'n ƚii ekheweli'ƚ pa'qu' netisij pe'qu' uteye' pa'qu' ƚa'se' in iyintaxijets pane'? ");
INSERT INTO mca_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Qa qu' niyintaxijets sehetse', ¿me qa' netisij pa'qu' q'oiq'oye'? ");
INSERT INTO mca_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","In ekheweli'ƚ in qitax pe' ewuƚ'etsi'ƚ, ƚa'mek qa ƚe'niyayi'ƚij in ƚetisi'ƚijkii pe' ƚe'sits pe' elitsi'iƚ, qa na' Atata'aƚ i'ni' na' wa's qa' les qu' qiye' qu' niya'yij qu' neƚisi'ƚij pe' ƚe'sits wekwek qu' iyini'ƚijetskii. ");
INSERT INTO mca_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Qa hik ta'ƚijupi' week pa'qu' isu'uni'ƚ qu' naqsi'ji'ƚ e'mijkii pekhewepe', qa' hik pakha' qu' aqsi'ji'ƚi'mijkii, qe hik aka' yit'ij ke' yika'ajji' ka' Moises'ik'i qa kekhewe' iye profetas.— ");
INSERT INTO mca_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Uyi'ƚii na' ƚeji' epk'iyit, qe na' epk'etsaxii ƚeji' qa epk'etsaxik'i iye na' wit'ikheyi'j yamii na' fe't qi iftsax qa olots ne' ikik'i nakha'an, ");
INSERT INTO mca_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","qa nakha' ƚeji' epk'iyit'ii qa epk'iyit'ik'i iye na' wit'ikheyi'j yamii na' witiƚa'x, qa nite' olots ne' yi'wen qa uyii.— ");
INSERT INTO mca_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Jeƚi'ƚiju'ƚ pe' ejtitsits yit'ijets qu' profetaye'. Pekhewe'en in nami'ƚ ei wotjonketik'i kots'etets, qa pakha'ƚe te'weiju' qa wowolija qa qi in nowe'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pe'qu' ƚeye' hikpe' qu' nata'ƚets qu' enikfe'li'ƚij. ¿Me ƚeke' qu' nata'ƚets pe'qu' uwaye' ne'ej tii, i'nƚi'i ne'ej higo qu' nata'ƚets ne'ej extuweƚku'k? ");
INSERT INTO mca_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Qa hik ƚunye'j ne' week najkakui ƚe'sits qa ƚe'sitsjeek ƚei, qa ne' uƚ'ets najkakui qa uƚ'etsjeek ƚei. ");
INSERT INTO mca_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ne'ej najkak ƚe'wis nite' ƚeke' qu' uƚ'etse' pe'qu' ƚeye', qa nite' ƚeke' iye ne' najkak uƚ'ax qu' ƚe'sitse' pe'qu' ƚeye'. ");
INSERT INTO mca_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Week ne'ej najkakui uƚ'ets ƚei qa wetfekinik'i qa tewumhitiiji'ju'kii na'aj fe't. ");
INSERT INTO mca_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aka'an hik aka' qu' menikfeliti'ƚets qa' enikfe'li'ƚij pa'n ƚunyejei pekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Nite' week pe'qu' ni'ttaxij yiwets: “Yatsat'axyij, Yatsat'axyij” qu' nuiji'teje'm na' tenek'enheiji' na' Tata wa'sji', qe uja'xƚe yijat'ij pe'qu' naqsi'jijkiiha pa'qu' nisu'un na' Tata wa'sji' qa' hikpe' qu' namiipha'm. ");
INSERT INTO mca_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Qu' namtaxets hatse' pa' neƚuji' olots pe'qu' ni'ttaxij yiwets: “Yatsat'axyij, Yatsat'axyij, yekheweli'ƚ hit'iƚij ka' ii, qa hik kakha' iye hit'iƚiji' in hukini'ƚfik'ikii pe' inwo'metets. Qa hik kakha' iye ka' ii hit'iƚij qa' haqsiiƚijkii ke' ham ƚunyejeyi'iju'ƚ.” ");
INSERT INTO mca_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma' qa' hit'ijets hatse': “Nite' hayiits qu' netsikfe'li'ƚ ewets. ¡Me'nitoni'ƚ ye'mii ekheweli'ƚ qi in ƚaqsiiƚijkii pa' uƚ'ax!”— ");
INSERT INTO mca_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Pa'qu' nespi'ye' qa' naqsiijkii ekewe' hit'ij qa' hik ƚunye'je' pa'qu' ewi'ƚ jukhewe' yiyaiƚewek in yitsupinju' pe'qu' ƚetsi'ye' qa yenipji' ne'ej qi ute. ");
INSERT INTO mca_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Qa in namtax pa'qu' qi piƚeye' qa mulpha'mkii iye pe' lejtits qa t'unijik'i iye qa yeqsilanje'mkii pe' wititsi', qa nite'ƚe niwu'mju' qe wetsupini'ju' pe' ute ipji'. ");
INSERT INTO mca_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Qa week pakha' qu' hats nespi'ye'tax qa nite'ƚe tek'enik'i ekewe' hit'ij qa hik ƚunye'j pa'qu' ewi'ƚe' jukhewe' nite' yiyaiƚewek, walxa'l iye, yaqsi'jtaxijkii pe'qu' ƚetsi'ye' qa yenƚi'i na'aj isa'xipji'. ");
INSERT INTO mca_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma' qa in nam pa'qu' qi piƚeye' qa mulpha'mkii iye pe' lejtits qa t'unijik'i iye qa yeqsilanje'mkii pe' wititsi', ma' qa nopƚetju', qa haamija pa'qu' amane'.— ");
INSERT INTO mca_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ha' Jesús in yili'ij pa'aj in iyet, qa pe' jukhew qa qi in yitjuƚaxijpha'mkii, ");
INSERT INTO mca_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","qe in i'nq'ijatshen hik ƚunye'j pa'qu' qi qu' netnek'enhei, qa nite' ƚunyejei he' i'nq'ijatshentaxij ke' Moisés ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","In tepilik'uiju' pa'aj ha' Jesús ke' utek qa olootsija pa'aj pe' nijayan. ");
INSERT INTO mca_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Qa nekets pa'aj pa' ewi'ƚ qi wanqaats'e' i'nij kakha' witja'me't ƚii lepra, ƚoq'oqkii pa' ƚ'ajik'i, qa wonokok'eni'ju' pa'aj ƚ'ejuyi'jii ha' Jesús, qa yit'ij: —Yatsat'axyij, qu' isu'un qa' ƚeke'ye' qu' etsiƚin wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Qa ha' Jesús qa t'eku'mets pa'aj, qa yit'ijets: —Ehe, hisu'un qa' k'eƚin hane'ej.— In yit'ijets aka'an pa' wanqaats'e' qa aje'eƚ naxpa'lij pa' ƚaja'me'ttax. ");
INSERT INTO mca_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ha' Jesús qa yit'ijets iye pa'aj: —Menikfelitetsha aka' qu' hit'ij ewets, hasu'uj enfel eku'ni'm pe'ye' in hats ƚanaxpa'l. Maƚe qa' me'nethinii hakha' pa'i ne' witlijtsitjii qa' eyijii pa'qu' eqisit'i'ij na' Dios (ofrenda), in ƚ'anye'jek ka' inaqyaji'ij ka' Moises'ik'i, hats'inha qu' week nenikfe'lets in hats ƚanaxpa'lij ka' aja'me'ttax.— ");
INSERT INTO mca_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","In uiji'teje'm pa'aj ha' Jesús ha' witset Capernaum qa pa' ewi'ƚ centurión qa nekets pa'aj qa iyinijets, ");
INSERT INTO mca_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","qa yit'ijets: —Yatsat'axyij, ha' yeqejkunene'k ke' yitsi'ii qi in wanqaats'e', nite' p'e's iye.— ");
INSERT INTO mca_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ha' Jesús qa yit'ijets pa'aj: —Tsamƚi'iyek qa' hiƚin.— ");
INSERT INTO mca_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Qa pa' centurión qa yeku'ƚ: —Yatsat'axyij, nite' ye'weju'ƚ eju'ƚ qu' uyifi ke' yitsi' qe ewi'ƚƚe yijat'ij pa'qu' it'ij ma' qa' hats nit'unhet ha' yeqejkunenek. ");
INSERT INTO mca_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Qe yakha' iye na'l pe' te'weiyik'uipha'm qa yakha' iye na'l ye'm iye ne' oq'opheƚinetsilets in heinek'enhe'yipji'. Qe hiyaji'ets na'aj ewi'ƚ nekhewe'en qu' nak, qa ik. Qa nikhapij qe hiyaji'ets qu' nenekmet, qa nekmet. Qa ha' yeqejkunene'k qe hiyaji'ijets na'aj wekwek qu' nithayiki qa yithayiki.— ");
INSERT INTO mca_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","In yepi'ye' ek'i pa'aj aka'an ha' Jesús qa qi in yitjuƚaxijpha'm pa'aj. Qa yit'ijji'ju' pekhewe' yijayanik'ikii: —Yijaa'ija aka' hit'iƚij ewets, week enewe' Israel ƚeiƚets ham pa'qu' hi'wen qu' hik ƚunye'je' in nite' inqeku' ha'ne jukhew. ");
INSERT INTO mca_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yakha' hit'iƚij ewets in olots hatse' pe'qu' nata'ƚji' na' neƚu'uju'ƚ qa pe'qu' tefe nata'ƚji' iye qa' na'nijupju'kii qa' ƚekufeye ka' Abraham'ik'i qa ka' Isaac'ik'i qa ka' Jacob'ik'i iye ha'ne wa'sji'pha'm tenek'enheiji' na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Qa nekhewe'ƚe te'nekumhiitaxiiji' qu' nuiji'teje'm na' tenek'enheiji' na' Intata qa' netwu'mhitii ji'teje'mkii na' i'nfik'i qi in noo'kiiha qa' hikna' qu' qi qu' napi'ju'kii qa' qi qu' nat'aiji' ƚek'unhetii.— ");
INSERT INTO mca_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma' qa ha' Jesús qa yit'ijets pa'aj pa' centurión: —Yape mapilii pe' etsi', qa aka' hats ƚunye'j in nite' ƚeqeku'uk'i qa' hik aka' qu' ƚunye'je'.— Qa pa' witqejkunenek qa hik pakhaa'ijha in hamiikii pa' ƚaatshektax. ");
INSERT INTO mca_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ha' Jesús qa yamii pa'aj ke' ƚetsi' ha' Pedro qa yi'wen pa'aj ke' ƚeqewketi' in nite' niipha'm qe qi in iwilhan. ");
INSERT INTO mca_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Qa t'eku'mi' pa'aj pa' ƚokoi qa hik pakhaa'ijha pa'aj qa ikik'uifik'i pa' witwilhat. Ma' qa niipha'm qa t'unkii, ma' qa yejeƚets qa yithayiki'im iye pe' wekwek. ");
INSERT INTO mca_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Qa in hats uiju' pa'aj pe' junu' ha' Jesús qa tetka'xii pe' olots jukhew qa efutsji'kii i'nji' pe' inwo'metets. Ma' qa ƚe'lijeiƚe pe' yitjiijets in yukinfik'ikii pe' inwo'metets. Qa niƚinju' iye pe' week wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aka'an in hats yaqsiijkii pa'aj, qe qa' nasiinik'iha pa' hats nifel pa'aj tooxik'i pa' profeta'ik'i Isaías in yit'ij: —Ƚakha' t'eku'mi' pe' inawtshei qa yeka'x iye pe' inja'metets.— ");
INSERT INTO mca_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ha' Jesús in yi'wen pa'aj in olots pe' namii yeqewuk'un, qa yiyaji'ijets pa'aj he' ƚ'ijatshenhei qu' naki'ƚii ƚajaika' ke' kaƚi'. ");
INSERT INTO mca_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Qa ewi'ƚ pa'aj pa' i'nq'ijatshenij ke' Moisés ƚe'lijei qa nekets ha' Jesús qa yit'ijets: —Maestro, tsaqjayankeyu'tax ej week pa'qu' maji'ijji'.— ");
INSERT INTO mca_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ha' Jesús qa yit'ijets: —Ne' ejenelits na'l ne' ƚewjets qa ne' junatai qa na'l iye ne' ƚupits, qa ha'neƚe Ƚa's na' Jukhew qa ham pa'qu' na'wi'ju' ha'ne ƚeiƚa'.— ");
INSERT INTO mca_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Qa pakhap iye pe' yijayanik'i qa yit'ijets iye: —Yatsat'axyij, ¿me ƚeke' qu' etswejinƚe eku'n qu' natsamii ha' tata qa heti'j eku'uk'ui hatse'?— ");
INSERT INTO mca_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Qa yeku'ƚ pa'aj ha' Jesús qa yit'ij: —Atsjayan yijat'ij. Iwejinƚi'ij pekhewe' hik ƚunyejei qu' nawa'm qu' netijik'ui pe' naxju'.— ");
INSERT INTO mca_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma' qa ha' Jesús qa he' ƚ'ijatshenhei iye qa t'ilitji'ju'kii pa'aj pe' qi'ik'i witinhitjii qa ikijteje'mkii. ");
INSERT INTO mca_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Qa yamji'ju' pa'aj ƚeqewuk'u ke' kaƚi' qa aje'eƚ nam pa' qi t'unik'i iftsaxji' qa qitsik'i iye pe' ƚeqe t'uyuyuyits qa tsxiƚtsxiƚji'ju'kii pe' witinhitjii. Qa hakha'ƚe Jesús qa ima' pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Qa he' ƚ'ijatshenhei qa nijt'otshenii pa'aj, qa yit'ijets: —Yatsat'axyij, ¡etsi'fen qeku'ni'ƚ wat'ij! ¡Hats ji'nuihiyu'!— ");
INSERT INTO mca_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Qa yeku'ƚ pa'aj: —¿Inhats'ek in qi in ƚe'nijiwe'yi'ƚ? Hayits qa'nte' qitsi'ƚ e'm pa'nte' witqekuye'j.— In yit'ij aka'an ma' qa niipha'm pa'aj qa yaq'ayinij pa' t'unik'i qa pa' iweli' iye, ma' qa yili'ij aje'eƚ qa week ikesimen iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Qa he' ƚ'ijatshenhei qa qi in yitjuƚaxijpha'mkii pa'aj, qa yit'ijju': —¿Pa'n qu' ƚunyeeji'ija ha'ne jukhew in tek'enets iye aka' t'unik'i qa ha'ne iweli' iye?— ");
INSERT INTO mca_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","In yamiiteje'm pa'aj ha' Jesús ha' ƚajaika' ke' kaƚi' ha' sehe' ƚii Gadara, ma' qa te'nilitfik'ikii pa'aj pe' wetsjuk jukhew i'nji' pe' inwo'metets ta'ƚets pa' nimeƚkuket qa nekets pa'aj pa' i'ni'. Pekhewe'en qi in iftsitsiju'ƚha pa'aj pa' ƚunyejei, ma' qa ham pa'qu' neneki'kii pakha' i'ni' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Qa tayai wetju'ƚ pa'aj: —¿Inhats'ek in ƚanami'ƚyii Ƚaa'sija pa' Dios? ¿Me ƚanami'ƚyii qu' atsawtsheteni'ƚ in mexente' yamtaxets pa' ƚahats'ij?— ");
INSERT INTO mca_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ipƚulii pa'aj pa' i'ni' pe' olots tafitets taqakiyi'ju' pa' jup'elket. ");
INSERT INTO mca_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Qa pe' inwo'metets qa iyinijets pa'aj ha' Jesús: —Qu' etswu'mi'ƚfik'i, qa etswejinƚi'iƚij qu' nek'uyiƚik'i ne' tafitets.— ");
INSERT INTO mca_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ha' Jesús qa yit'ijiju'ƚ pa'aj: —¡Ma'aƚfik'ikii!— Qa pe' inwo'metets qa ikik'uifik'ikii pa'aj pe' jukhew qa uijiteje'mkii pe' tafitets. Qa aje'eƚ pe' tafitetsik'i qa week wekuma'xik'iju'kii pa' koomojo' qa t'ilitji'ju'kii pa' iweli' qa naq'axijju'. ");
INSERT INTO mca_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pekhewe' yejeƚtax pa'aj pe' tafitetsik'i qa wekuma'xii pa'aj pa' witset qa nifelkii week pakha' ƚunye'jkii. Qa pa' ƚunyejeikii iye pekhewe' jukhew i'ntaxji' pe' inwo'metets. ");
INSERT INTO mca_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma' qa week pa' witset qa nekii pa'aj pa' i'ni' ha' Jesús. Qa in yi'wen pa'aj qa iyinijets qu' nakik'ui iye pa' ƚeqe sehe' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ma' qa ha' Jesús qa t'ilitji'ju' iye pa'aj pe' witinhitjii qa yijawe'jiiteje'm pa' ƚajaika' qa yametsteje'm iye pa'aj ha' ƚetseet'ija. ");
INSERT INTO mca_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Qa tetka'xii pa'aj pa' ewi'ƚ jukhew qi wanqaats'e', nite' p'e's, tetkaxij pa' witiwhi'la'x. Ha' Jesús in yi'wen pa'aj pekhewe'en in nite' yeqeku', qa yiyaji'etsju' pa'aj pa' wanqaats'e: —Ment'unhet ya's, ne' ewuƚ'ets hats wetwu'm ek'ui.— ");
INSERT INTO mca_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma' qa pe' uja'x hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa yumti': —Ha'ne jukhew yiwakaninkii pa' Dios. Uƚ'etsik'i ke' ƚe'lijeyets.— ");
INSERT INTO mca_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ha' Jesús qa hatsƚe nikfe'lets pa'aj pakha' yumti pekhewe'en, qa yit'ijets: —¿Inhats'ek in uƚ'ax aka' aqjamtikineyejeyi'ƚij aka'an? ");
INSERT INTO mca_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Pa'n ƚunye'j pa'qu' les nite' jutsitaxe' qu' jintit'ij: “Me pe' ewuƚ'ets hats wetwu'm ek'ui” in nite' ƚeke' qu' i'weni'ƚ? ¿Me i'nƚi'i qu' jintit'ij: “Eniipha'm qa' ma” qe ƚi'weni'ƚ yijat'ij? ");
INSERT INTO mca_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hane'ej qa' nethiniƚij ha'ne Ƚa's na' Jukhew in na'li'm pa' ƚet'unha'xijup ha'ne sehe' ipji' qu' niwu'mkii pe' witwuƚ'ets.— Ma' qa yiyaji'etsju' pa'aj pa' wanqaats'e' nite' p'e's: —Eniipha'm, it'ij jof na' ewhi'la'x qa' mapilii pe' etsi'.— ");
INSERT INTO mca_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pa' wanqaats'etax qa niipha'm pa'aj qa ik qa wapilii pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","He' jukhew qa efuts iye in yi'wen pa'aj aka'an qa qi in yitjuƚaxijpha'mkii, ma' qa qi in yiwqinhetji' pa' Dios qe aka' witt'unha'x tisij ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ha' Jesús in hats ikik'ui iye hakha' i'ntaxi', qa yi'wen ha' ewi'ƚ jukhew ƚii Mateo, i'niju' ha' yijanini'kii ke' wekwek t'ejuyets na' witset. Qa yiyaji'ets: —¡Atsjayan!— Ma' qa niipha'm qa yijayan. ");
INSERT INTO mca_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ha' Jesús qa i'nijupju' ha' mesa in teki'ju' ke' ƚetsi'ii ha' Mateo. Qa olots iye hekhewep yijaninkii wekwek qa hekhewep iye jukhew qi iye pe' ƚewuƚ'ets, nekii iye qa week ewi'ƚ ƚekulaxi'ƚ qa hekhewe' iye ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Qa in yi'wenij he' fariseol qa nifaakan he' ƚ'ijatshenhei: —¿Inhats'ek na' aqa maestro'oƚ in ƚekufets ne' qi uƚ'ets wekwek yijanin qa ne' qi pe' ƚewuƚ'ets iye?— ");
INSERT INTO mca_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ha' Jesús qa yepi'ye' ej aka' yit'ijju' ma' qa yit'ijji'ju': —Nekhewe' ham yaats'eyi'iju' nite' wo'oikii weihetaxe' witeqjunhetits ƚeiƚe', qe uja'xƚe yijat'ij nekhewe' wanqaats'eju'. ");
INSERT INTO mca_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma'aƚkii qa' jeƚi'ƚijupkiiha aka' yit'ij pa'aj eke' wi'tlijei in yit'ij: “Yakha' les hisu'un qu' e'nq'eleti'ƚ wetju'ƚ qa nite' pa'qu' ilantaxi'ƚyifi ene' inqa'metets.” Yakha' nite' tsamijju' qu' haiya'yii pe' yatsathen, qe uja'xƚe yijat'ij ne' qi pe' ƚewuƚ'ets qe qa' nijayan na' Dios.— ");
INSERT INTO mca_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ma' qa he' ƚ'ijatshenhei ka' Juan Bautista qa nekets ha' Jesús qa nifaakan: —¿Inhats'ek yekheweli'ƚ qa ne' fariseol iye in olotsij in nite' heyekji'ji'ƚ qa ne' ijatshenhei qa nite' yaqsiijkii aka'an?— ");
INSERT INTO mca_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Qa yeku'ƚ ha' Jesús: —¿Me ƚeke' qu' nika'metets wetju'ƚ pekhewe' te'niyinhe'yij pa' witiwhe'yejii in mexe i'nji'teje'm pakha' niwhe'yeyu'? Yamets hatse' pa'qu' ƚahats'i'ij qu' ne'tnekumhi'yi' qa' netwumhitiifik'i pakha' niwhe'yeyu'. Ma' qa hayitse' yijat'ij qu'nte' neteke'ju'. ");
INSERT INTO mca_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ham witqhinawat'e qu' nowotk'oyinij pa'qu' ƚepk'eye'en penyiloye' qu' ink'ayik'e, qe na'aj ink'ayik wapilje'm qe wempuli'j qa' niwjafitik'i pa'qu' ƚawa'ma'xe' ma' qa' les e'pk'etsaxje'm pa'qu' ƚawjaf'iye'. ");
INSERT INTO mca_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nite' ƚeke' iye qu' na'natsi'yik'iju' pa'qu' ink'ayik winoye' ne' ƚawa'mhii ƚ'ajits eƚi'nilij, qe qu' nanaqsiijkii aka'an qa ne' ƚ'ajits eƚi'nil qa' netikeƚijje'm ma' qa' week hamitse' winolik'i qa eƚi'nilik'i iye. Qa hik ta'ƚijupi' qu' atsi'yi'ƚik'iju' yijat'ij na' ink'ayik wino ne' ink'aihits ƚ'ajits eƚi'nilij ma' qa' week ƚe'sitse'.— ");
INSERT INTO mca_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","In mexe iyetij ha' Jesús ekewe'en qa namets ha' ewi'ƚ tenek'enhe'yij iye pe' ewi'ƚ hekhewe' ƚe'lijtsitjiyits ne' judiol. In namets qa wonokok'eni'ju' ha' ƚ'ejuyi'jii qa yit'ijets: —Ke' yasiik'i i'nk'aa'ija wa'm, qa qu' enekik'i' qa' ku'mipji' ma' qa' iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ha' Jesús qa niipha'm qa yijayan qa week iye he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma' qa ewi'ƚ ke' efu qi in wanqaats'e' nite' hamitsik'ui pe' ƚ'athits qa hats yamijets doce (12) ƚeqe'ninqapitsij. Qa nijayanpha'm ha' Jesús qa t'eku'mets pa'aj ha' te'weiju' ha' ƚ'uihitjii. ");
INSERT INTO mca_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Qe yumti'ija qu' ƚunye'je' qa yit'ij: —Qu' nakha'yeƚe ƚ'uihitjii qu' he'yeku'mets qa' natsaxpa'lij ha'ne yaatshe'k.— ");
INSERT INTO mca_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Qa ha' Jesús qa tetwek'elaxiju'ƚ qa yi'wen ke' efu qa yit'ijets: —Ment'unhet, yasi'. Hats ƚanaxpa'lij na' aatshek qe nite' ƚ'inqeku'.— Qa hik akaa'ijha qa naxpa'lij pa' ƚaatshektax. ");
INSERT INTO mca_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","In hats uyifi ha' Jesús ke' ƚetsi' ha' witlijtsitjii tenek'enhe'yij qa yi'wen hekhewe' tofojiyijup qa hekhewe' iye t'aiji' in yejtsi'le' wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Qa yit'ijji'ju': —Ma'aƚik'uifik'i ene' wititsi'. Ne' ome'ƚaski' nite' wa'm. Ima'ƚe.— Ma' qa talakaxtiiju' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ha' Jesús in hats week yuki'nfik'ikii he' week. Ma' qa uyetsji' qa t'eku'mi' ha' ƚokoi, ma' qa ke' wa'mtax ome'ƚaski' qa niipha'm. ");
INSERT INTO mca_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Qa weekij ha' sehe' in i'ye'ej iye aka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","In ikik'ui iye ha' Jesús hakha' i'ntaxi', qa wetsjuk he' puk'alets nijayanpha'm qa taya'yik'ikii, qa yit'ijju': —Ƚa's pa' David'ik'i, e'nq'elet qeku'ni'ƚyij wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Qa ha' Jesús in uyifi ke' wititsi' qa nekets iye he' puk'alets. Ma' qa ha' Jesús qa nifaakan hekhewe'en: —¿Me nite' ƚeqeku'uƚik'i qu' ƚeke'ye' qu' haqsiijkii aka'an?— Qa yit'ijju' in yeku'ƚ: —Nite' heqeku'uƚik'i, Yatsat'axyij.— ");
INSERT INTO mca_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma' qa ha' Jesús qa t'eku'mipji' he' ƚotoi qa yit'ijets: —Aka' hats ƚunye'j in nite' ƚ'inqeku'uƚ qa' nanaqsi'jjiiƚ e'mijkiyek.— ");
INSERT INTO mca_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma' qa yi'wen wetju'ƚ hekhewe' puk'aletstax. Ma' qa ha' Jesús qa qi in yiyajitaxetskiiha qa yittaxijets: —Mowo'oƚiiha qu'nte' nenikfe'le'ets pe'ye' aka'an.— ");
INSERT INTO mca_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Qa in i'nk'a ikik'uikii qa aje'eƚ nifelkii, ma' qa weekij aje'eƚ ha' sehe' in nikfe'lets ka' yaqsiijkii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","In i'nk'a ikik'uifik'ikii he' puk'aletstax, qa aje'eƚ namets iye he' uja'x jukhew ha' Jesús, neka'xii ha' ewi'ƚ jukhew ham ƚe'lijeye' qe i'nji' pa' ewi'ƚ inwo'met. ");
INSERT INTO mca_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ha' Jesús in yukinik'uifik'i pa' i'ntaxji' inwo'met ha' jukhew ma' qa iyet ha' hamtax ƚe'lijeye'. He' jukhew qa efuts iye qi in yitjuƚaxijpha'mkii qa yit'ijju': —Nite' pakhaa'ij qu' ƚunye'je' pa'qu' ne'twenhetiiji'teje'm ha'ne Israel qu' ƚunye'je' ka' ƚunye'j ha'ne jukhew.— ");
INSERT INTO mca_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Qa hekhewe'ƚe fariseol qa yit'ijju'ek: —Ha'ne jukhew in yuki'nfik'ikii pekhewe' inwo'metets yit'iji' pa' ƚet'unha'x pa' qi ƚatata pe' inwo'metets.— ");
INSERT INTO mca_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ha' Jesús qa week ikik'i he' witsetits qa he' witsetits ƚelits iye qa i'nq'ijatshenifikii he' ƚe'lijtsitjiyits ne' judiol week he' witsetitsji'. Qa nifelji'ij iye ke' ƚe'sits wi'tlijei t'ejuyets pakha' tenek'enheiji' pa' Dios qa niƚinju'kii iye he' pekhel ƚunyejeikii pe' ƚaja'metets qa he' pekhel yaats'e'eju'kii iye. ");
INSERT INTO mca_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","In yi'wen he' olots jukhew qa efuts iye qa qi in neq'eletij, qe itawje'metets qa nite' yimaamkii qe ham pa'qu' ni'fenkii qu' nejeƚets hik ƚunyejei ne'ej kots'etets qe ham na'aj ƚenilayets in yejeeƚija. ");
INSERT INTO mca_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Qa yit'ijji'ju' he' ƚ'ijatshenhei: —Hats olotstax ne' yuji' na' wit'enekju' qa nite'ƚe olots ne' yithayikitax. ");
INSERT INTO mca_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Qa hik ta'ƚijupi' qu' iyini'ƚijets na' Yatsat'axij na' wit'enekju' qu' nenukin iye pe'qu' nithayiki.— ");
INSERT INTO mca_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ma' qa taya'yets ha' Jesús he' doce (12) ƚ'ijatshenhei qa' tisij pa' ƚet'unhaxitsijup qu' nukinfik'ikii pe' inwo'metets qa qu' nenƚinju'kii iye pe' pekhel ƚunyejeikii pe' ƚaja'metets qa pe' pekhel yaats'e'eju'kii iye. ");
INSERT INTO mca_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Enewe'en ƚiyits he' doce (12) ƚ'ijatshenhei ha' Jesús. Yojo ha' Simón, ƚii iye Pedro qa ha' ƚek'inij Andrés. Qa ha' Jacobo (Santiago) qa ha' ƚek'inij Juan, enewe' wetsjuk ƚelits ha' Zebedeo, ");
INSERT INTO mca_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe qa ha' Bartolomé, Tomás qa ha' Mateo, hik ha'ne yijaninkii wekwek t'ejuyets pa' witset Roma, qa ha' Jacobo (Santiago) ƚa's ha' Alfeo, qa ha' Tadeo, ");
INSERT INTO mca_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","qa hakhap iye Simón, i'nji'teje'mek pa'aj pekhewe' ƚiyinyejei cananitas qa ka' Judas Iscariote, hikka' wotk'onijkii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ha' Jesús qa yukinkii ene' doce (12) ƚ'ijatshenhei qa nifeli'm pa'qu' ƚeqfenyejeye' ƚewek qa yit'ijets: —Hasu'uj ami'ƚets ne' ƚeqe sehel ne' nite' judiol. Qa hasu'uj iye uyi'ƚ ji'teje'm ne' Samaria ƚetsetitits. ");
INSERT INTO mca_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma'aƚii yijat'ij nekhewe' i'ni'kii ne' kots'etets hamitstaxiikii ene' ƚetsi' ka' Israel'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","In ƚaki'ƚkii qu' enfeli'ƚ qa' it'iƚij: “Pa' tenek'enheiji' pa' Dios hats met ma' qa' hats na'nju'.” ");
INSERT INTO mca_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iƚini'ƚ pe' wanqaats'eju', iƚini'ƚ pa'qu' hats nawa'mji'ijtax. Iƚini'ƚ pakha' qu' na'ntaxij kakha' witaja'me't lepra. Iwu'mjiiƚfik'ikii pekhewe' inwo'metets. Aka'an in ƚ'estiyi'ƚij ham ƚaja'ye', qa hik ta'ƚijupi' qu' hasu'uj ji'jek ijanini'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hasu'uj iye eka'xi'ƚ aq'astayi'iƚ nijketits oro qa ke' plata qa ke' cobre iye. ");
INSERT INTO mca_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hasu'uj iye eka'xi'ƚ pa'qu' ti'naje' in ƚaki'ƚkii. Ewi'ƚe'ƚe iye pa'qu' uihitjiyi'iƚ, hasu'uj wetsjuk'e iye otshilaxtiyi'iƚ qa hasu'uj iye eka'xi'ƚ awaikajit'i'iƚ, qe na'aj t'ithayii weju'ƚij in testi'yij na'aj ƚaq. ");
INSERT INTO mca_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Qu' ami'ƚets pa'qu' witset'e i'nƚi'i qu' witset ƚa'se' qa' aje'eƚ mowo'oƚiikii pakha' qu' ninikfe'l qu' natsathen pa'qu' ƚunye'je', qa' hikpa' ni'iƚijup pe'qu' ƚetsi'ye' qa' ami'ƚijii qu' ma'aƚik'ui iye pa'qu' witset'e. ");
INSERT INTO mca_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Qu' ami'ƚets pe'qu' wititsi'ye' ma' qa' it'iƚijets qu' mewetfeliƚi'm pekhewe' tetsii: “Pa' wit'ikesimeya'xƚekii qu' na'ni'ƚ ejupkii.” ");
INSERT INTO mca_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Qa pekhewe' tetsii pe' wititsi' qu' ni'wejuƚenij qu' netesti'yij aka'an, ma' qa aka' ƚewetfeliƚiji'm wit'ikesimeya'xƚekii qa' amaneye' jiijupkiyek. Qa qu' nite'ƚe ni'wejuƚeni'ij qu' netesti'yij, ma' qa' eka'xi'ƚik'ui iye qu' ma'aƚik'ui. ");
INSERT INTO mca_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Qa qu' nite'ƚe lesitsi'ƚ eju'ƚ axe'm qu' nite' nenexpiikeyu'yi'iƚ ej, ma' qa' ma'aƚik'ui pe' wititsi' axe'm qu' witset'e, qa' enfuluti'ƚju' pa'qu' sehe'ye' qu' namtaxij ne' ef'iyeyi'ƚ qa' jutsiqetsi'im in uƚ'ets. ");
INSERT INTO mca_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yijaa'ija aka' hit'iƚij ewets, qu' namtaxets pa' neƚu qu' newetjeyumtshentax ene' week qa pa' ƚantanithenkeye'j hatse' ha'ne witset in nite' nexpiikeyu'uƚ ej les qi qu' iftsaxe' hatse' qa tees qu' ƚunye'ji'iju'ƚ na' ƚantanithenkeye'j hatse' kekhewe' witsetitsik'i Sodoma qa ka' Gomorra.— ");
INSERT INTO mca_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Ek'en qeku'ni'ƚek, yakha' in k'ukini'ƚkii hik ejunyejeyi'ƚ kots'etets qu' na'nji'ju' ƚeqewuk'u ne'ej wowol. Qa hik ta'ƚijupi' matjanitheni'ƚkiiha hik ejunyejeyi'ƚ na'aj q'oiq'oi, qa hikƚe ejunyejeyi'iƚ ne'ej ofol in ham yumtiyi'iikii. ");
INSERT INTO mca_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jeƚi'ƚiju'ƚha ene' jukhew, qe na'l pekhewe' qu' neka'xi'ƚii hatse' pekhewe' qu' nejeƚik'ui pa'qu' ƚunye'je'kii (tribunal), qa' neqsilani'ƚje'mkii iye pekhewe' ƚe'lijtsitjiyitsifi. ");
INSERT INTO mca_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Qa' neka'xi'ƚii iye pekhewe' wit'alheiji' pe' witsetits (gobernadores) qa pe' qitsji' wittatal (reyes), qe ta'ƚ yiwets in ƚatsjayani'ƚha, hats'inha qu' iwq'axini'ƚij qu' enfeli'ƚi'mha pekhewe'en aka' yijunye'j qa pekhewe' iye nite' judiol. ");
INSERT INTO mca_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Qa qu' neka'xiƚetsji' pekhewe' wit'alhei hasu'uj natawje'meteni'ƚ qu'nte' e'niya'yi'iƚiju'ƚ pa'qu' it'iƚijiju'ƚ, qe qu' namets qu' iyet qa na' Dios qa' neƚisi'ƚij pa'qu' it'iƚijiju'ƚ, ");
INSERT INTO mca_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","qe nite' ekheweli'ƚ qu' iyeti'ƚ, nakha' ƚeqe Espíritu na' Atata'aƚ qu' hikna' niyetiƚ'epji'. ");
INSERT INTO mca_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ma' qa ene' jukhew qa' ninaqyaji'ij qu' natlanhetii pa'qu' ƚek'inije' i'nƚi'i pa'qu' ƚamats'e. Qa pa' ƚatata qa ninaqyaji'ij qu' natlanhetii pa' ƚa's qa i'nƚi'i pe'qu' ƚasi'ye', qa pe' witlitstax qa' ƚ'ejuihifetsi'ij pe'qu' ƚ'alheye' qa' ninaqyaji'ij qu' natlanhetiiju'. ");
INSERT INTO mca_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Week ha'ne sehe' epji' qi qu' nuteni'ƚ qe ta'ƚ yiwets in ƚatsjayani'ƚha, qa pa' qu'nte' niliye'yij qu' namijii pa' ƚ'aka'the' qa' hikpa' qu' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Qu' nanqawitjineyu'uƚ'ej pa'qu' witset'e qa' aje'eƚ ilati'ƚii iye pakhape' witset'e iye. Qe yijaa'ija aka' qu' hit'iƚij ewets in tees qu' week anq'axiƚijpha'm qu' ma'aƚik'i ene' witsetits ha'ne Israel qu' hats nanam ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ham wit'ijatshenek'e qu' nat'anipji' pa'qu' ƚaqa maestroye' qa ham iye pa'qu' witqejkunenek'e qu' netweyik'uipha'm pa'qu' ƚaqa patune'. ");
INSERT INTO mca_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na'aj wit'ijatshenek les ƚe'wis qu' ni'wejuƚenij in hats hik ƚunye'j na'aj ƚaqa maestro, qa na'aj witqejkunenek iye in hik ƚunye'jek na'aj ƚunye'j na'aj ƚaqa patun. Ene' jukhew qu' ƚeqiyi'ij Beelzebú (ƚatata pe' inwo'metets) na' yatsat'axij ne' wititsi', qa ¿me nite' les uƚ'etsi'ik'i pe'qu' ƚeqiyitsi'ij ene' ƚelits na' yatsat'axij ne' wititsi'?— ");
INSERT INTO mca_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Qa hik ta'ƚijupi' qu' hasu'uj e'nijiwe'yi'ƚiju'ƚ ene' jukhew qa efuts iye, qe ham pa'qu' natat'inhetiikii qu'nte' ne'twenheti'ye' qa qu'nte' ninikfe'le' iye. ");
INSERT INTO mca_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pa'qu' uja'xe'ƚi'iƚijkii qu' hit'iƚij ewets in nookii qa' enfeli'ƚ qu' ne'neƚukii. Qa pa' ujaxƚi'iƚijki in k'efeli'ƚi'm qa' meweƚiƚiji'pji' ne' wititsil qa' it'unheti'ƚik'iha' qu' enfeli'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hasu'uj e'nijiwe'yi'ƚiju'ƚ enewe' yilanƚe ne' esenitsi'ƚ qa pakha'ƚe neƚini'ƚ (alma) qa' nite' yaq'alij. Les ƚe'wis yijat'ij qu' e'nijiwe'yiju'ƚha nakha' ƚeke' qu' naqsiijkii yijat'ij qu' week niwuƚ'enhetju' ene' wit'esenits qa pa' yiƚin (alma) ene' wit'esenits, qa' niwu'mji'ju'kii pa' fe't qi iftsax. ");
INSERT INTO mca_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Me nite' te'ninei ne'ej wetsjuk papaye'mtsil in ƚaja'aju'ƚ ne'ej ewi'ƚ ƚ'astaki' nijket ƚasi'? Enewe'en nite' ewii'ƚe' pe'qu' nanami'ju' na' sehe' qu'nte' ƚexke'yi'ij na' Atata'aƚ. ");
INSERT INTO mca_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Qa ekheweli'ƚ ne' ewkujitsi'ƚ hats week wetjeyumtshen, hats jutsiqax iye pa' uja'x. ");
INSERT INTO mca_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Qa hik ta'ƚijupi' hasu'uj e'nijiwe'yi'ƚ, qe ekheweli'ƚ les e'weju'ƚi'ƚij yijat'ij nite' ejunyejeyi'ƚiju'ƚ pe'qu' olootse'tax papaye'mtsile'.— ");
INSERT INTO mca_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Qa hik ta'ƚijupi' week pakha' qu' netetfelyijha nite' welku't'ijetskii ene' jukhew in tsijayan, ma' qa' yakhap ji'jek iye qu' hetetfeljiiji'mha ek nite' hewelkut'ijetskii na' Tata i'ni' na' wa's. ");
INSERT INTO mca_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Qa pakha'ƚe qu' newelku'tyijkii qu' natfaakanhetiitaxyij, ma' qa' yakhap ji'jek iye qu' hewelkutjiijetskiyek na' Tata i'ni' na' wa's.— ");
INSERT INTO mca_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Hasu'uj umti'iƚ yakha' in tsam qu' henka'x pa'qu' ƚesaxitse'wetju'ƚkii ha'ne week sehe' epji'. Nite' tsamijetsju' qu' henka'x pa'qu' ƚesaxitse'wetju'ƚkii ha'ne week sehe' epji'. Tsamijetsju' yijat'ij qe qa' nawatk'esa'xju'kii. ");
INSERT INTO mca_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tsametsju' ha'ne sehe' qe qa' nuten pa'qu' jukhewe' qa' ƚ'ejuihifeyi'ij pa'qu' ƚatataaye'taxija. Qa pe'qu' witasiye' qa' nutenek qa' ƚ'ejuihifeki'ij pe'qu' ƚeneneye'taxija qa pe'qu' witfelits'etax qa' nutenek qa' ƚ'ejuihifekiyi'ij pe'qu' ƚeqewketi'ye'. ");
INSERT INTO mca_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Qa pekhewe' ƚ'ejuihifets pakha' jukhew i'nƚi'i efu qa hik pekhewe' pe' ƚejefeetstaxija. ");
INSERT INTO mca_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pa'qu' les qi qu' namitfik'i qu' nisu'un pa'qu' ƚatataye' i'nƚi'i pe'qu' ƚeneneye' qa yakha'ƚe qa nite' tsisu'unija qa nite' weju'ƚij qu' nastsat'axij. Qa pakha' qu' les namitfik'i qu' qi qu' nisu'unija pa'qu' ƚa'se' i'nƚi'i qu' ƚasi'ye' qa yakha'ƚe qa' nite' tsisu'unija iye qa nite' weju'ƚij iye qu' nastsat'axij. ");
INSERT INTO mca_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Qa pa'qu' nite' net'ekumi'i pe'qu' ƚeqe cruze' qa' natsjayantax nite' weju'ƚij qu' nastsat'axij iye. ");
INSERT INTO mca_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pakha' qu' namitfik'i in yisu'un pakha' ƚunye'j in mexe iƚa'x, qa hikpa' qa' nanqamij pa' witiƚa'x. Qa pakha'ƚe qu' naqamij pakha' qu' ƚunye'je'tax in mexe iƚ'ax qe ta'ƚ yiwets qa' hikpa' qu' iƚa'xe' hatse'.— ");
INSERT INTO mca_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Pa'qu' qi qu' neneqjunu'uƚ'ej, yakha'ƚe iye in neqjunu'yij. Pa' neqjunu'yij qa neqjunu'uj iye na' ts'ukinju', ");
INSERT INTO mca_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","pa'qu' neneqjunu'uju'ƚ pa'qu' ewi'ƚ profetaye' qe ta'ƚets in profeta qa neqjunu'uju'ƚ, ma' qa' netesti'yij pa'qu' ƚenisit'e' in ƚunye'jek pa' ƚenisit pa' profeta. Pa'qu' neneqjunu'uju'ƚ qa t'eku'miju'ƚ pa'qu' natsathen jukhewe' qe ta'ƚets in yatsathen qa neqjunu'uju'ƚ, ma' qa' netesti'yij pa'qu' ƚenisit'e' in ƚunye'jek pa' ƚenisit pa' yatsathen. ");
INSERT INTO mca_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pa'qu' ƚunye'je' pa'qu' jukhewe' qu' netisij yemjeetax qu' ewi'ƚ tok'o ƚa'se' iweli'ye' eneƚeiji' enewe' nite' weniwqinhetji' qe tsijayanija. Ma' qa' hik pakha' hatse' qu' yijaayi'ija qu' nana'l pa'qu' ƚenisit'e'.— ");
INSERT INTO mca_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ma' qa in hats naq'axijik'i in yijatshen ha' Jesús he' doce (12) ƚ'ijatshenhei, ma' qa ik qu' nakik'i he' metits witsetits i'ni' hakha' sehe' Galilea qa' ni'nq'ijatshen qa qu' nenfel iye ke' ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","In impi'ye'ej pa'aj pa' Juan pe' witq'opheƚitjiyifi ke' yaqsiijkii ha' Cristo, ma' qa yukinii pa'aj pe' ƚ'ijatshenhei ");
INSERT INTO mca_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","qu' nanfaakankii ha' Jesús, ma' qa hekhewe'en qa yit'ijets: —¿Me hik akha' pakha' hats jutsiqaxik'ui qu' nanam? ¿Me i'nƚi'i qu' honotki'iƚik'ui iye pakhape'?— ");
INSERT INTO mca_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ha' Jesús qa yeku'ƚ: —Mapili'ƚii ha' Juan qa' enfeli'ƚi'm aka' ƚi'weni'ƚ qa aka' ƚ'impi'ye'eƚij iye, ");
INSERT INTO mca_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ne' puk'aletstax qa hats yi'wenkii, ne' onqokitstax qa hats t'otsjo' iye qa ene' otshimetetstaxju' qa hats otshimetsitsju' iye, ne' ƚoq'oqtaxkii ƚ'ajits (lepra) qa hats hamitsiikii iye ke' ƚajametetstax, ne' nite' yepi'ye'tax wetju'ƚ qa hats yepi'ye'kii iye, hekhewe' hats naxtaxju' qa iƚii iye, qa ene' if'iljetsits qa tefelhiti'yi'm eke' wi'tlijei t'ejuyets na' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Qa ƚe'wisi'mkii pakha' qu'nte' na'nayu'ye' yi'ij ye'm pe'ye'.— ");
INSERT INTO mca_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","In hats ikkii iye pekhewe'en qu' napilkii, ma' qa ha' Jesús qa iyetik'ui hekhewe' jukhew nifeli'm pa'n ƚunye'j pa' Juan, qa yit'ij: —¿Ƚekpa' ƚejeƚiƚii pa'aj in ƚami'ƚii na' ham i'ni'i'? ¿Me ewi'ƚ pe' fapu' yiwu'mkii pa' t'unik'i? ");
INSERT INTO mca_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Qa qu' nite' hik aka'ye', ¿qa pa'n ƚunye'jek pa' ƚenjusi'ƚii pa'aj? ¿Me ewi'ƚ pa'qu' jukhewe' qi in ƚe'sits pe'qu' ƚeqhinataye'? Ekheweli'ƚ ƚenikfe'li'ƚets nekhewe' natkin kekhewe' ƚe'sits witqhinatai in i'nifi ne' ƚetsil ne' qitsji' wit'alhei. ");
INSERT INTO mca_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Qa ¿ƚekpa' ek ƚami'ƚii qu' i'weni'ƚ? ¿Ye' me ewi'ƚ pa'qu' profetaye'? Ehe, hik aka' yijat'ij in ƚunye'j, qa hiwjutsiqeni'ƚ e'mha in hik hakha' les in qi in profeta. ");
INSERT INTO mca_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hik hakha' Juan, hikha' t'ejuyets aka' we'nika'ajji' pa'aj Intata ƚe'lijei in yit'ij: “Jeƚ qeku'nek, yakha' hukin hatse' na' yukinek qu' nathayin ek'ui, qa' hik nakha' qu' naqsi'jik'i pa'qu' ikheyi'je'.” ");
INSERT INTO mca_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yijaa'ija aka' qu' hit'iƚij ewets in week ene' jukhew ha'ne sehe' epji' ham pa'qu' nat'anipji' qu' ƚuk'eyeji' ha' Juan Bautista, qa pakha'ƚe qu' les nite' qiye'ji' pe' i'nji'teje'm na' tenek'enheiji' na' Dios, qa t'anipji' ha' Juan. ");
INSERT INTO mca_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","In ipƚu'uk'i ek in i'nk'aa nam ha' Juan Bautista qa yamijii hane'ej ene' jukhew in watkatitij wetepji' in yisu'un qu' na'n ji'teje'm nakha' tenek'enheiji' na' Intata. ");
INSERT INTO mca_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Qe week ke' profeta'ik'i qa ke' ƚe'lijei iye ka' Moises'ik'i in nifel na' tenek'enheiji' na' Intata wa'sji', kekhewe'en yamijii in hats nam ha' Juan. ");
INSERT INTO mca_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ekheweli'ƚ qu' isu'uni'ƚ qa' ku'mi'ƚiju'ƚ aka'an, hakha' Juan in hik hakha' profeta ƚii Elías, hayiits jutsiqaxik'ui pa'aj qu' nanam. ");
INSERT INTO mca_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pekhewe' qu' nana'l ƚekfiye' qa nepiye'ek'i aka'an. ");
INSERT INTO mca_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Pa'n ƚii pa'qu' hejeyumtshenijupi' ene' jukhew qa' efuts iye hane'ej ha'ne ƚahats'ij? Hik ƚunyejei ne'ej omehets qe t'oto'yi'ju' na'aj joofji'ju' qa taya'yiikii ne'ej ƚ'otoihifets, ");
INSERT INTO mca_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","qa yit'ijiikii: “In hifuyutaxi'ƚ e'mik'i ne' foj, ekheweli'ƚ qa nite'ƚe ƚ'otoyi'ƚ. Hijitaxi'ƚ e'mik'i ke' witlijtsinel if'iljetsitsik'i qa nite'ƚe ƚapi'ƚju'” ");
INSERT INTO mca_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Qe in namtax ha' Juan qa nite' tuj ke' week qa nite' iya' iye, qa titijiti'yijets in i'nji' pa' ewi'ƚ inwo'met. ");
INSERT INTO mca_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Qa in namtax iye ha'ne Ƚa's na' Jukhew qa tek qa iya' iye, qa titijiti'yijets in iƚinkeyax qa iyana'x iye, ƚejuwaika'aj nekhewe' wekwek yijanin qa ƚejuwaika' iye ne' uƚ'ets jukhew. Qa jutsiqaxƚi'ij pa'qu' i'nithayijkit'e qu' jinenikfe'lkii.— ");
INSERT INTO mca_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma' qa yapeƚek ha' Jesús qa yit'ijets pa' uƚ'ax ƚunyejei hekhewe' witsetits hekhewe' qi in yaqsi'jtaxiji'kii kekhewe' ham ƚunyejeyi'iju'ƚ. Yi'wentaxij yemjee qa nite'ƚe yili'ij in yaqsiijkii pe' uƚ'ets. Ma' qa yit'ij ha' Jesús: ");
INSERT INTO mca_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Peijaat'ij hiyee' a'ha'nus ha'ne witset Corazín! ¡Peijaat'ij hiyee' a'ha'nus iye ha'ne witset Betsaida! Qa qu' hakha'ye' Tiro qa ha' Sidón qu' nanaqsi'jiji'kii kekhewe' ham ƚunyejeyi'iju'ƚ wanaqsi'jtaxi'ƚ e'mijkii ha'ne ƚa'ni'ƚi'. Qekha hayiits nilitaxij in yaqsiijkii pe' uƚ'ets qekha nijayantax pa' Dios, ma' qekha ninq'ethintaxij in yijaa'ija qu' netf'iljetsin ƚeqhinatai qekha uƚ'etse'tax qa ƚeiƚa' qekha nilintaxij na'aj lo. ");
INSERT INTO mca_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Qa hik ta'ƚijupi' qu' hit'iƚij ewets ekheweli'ƚ, qu' namtaxets pa' neƚuji' qu' newetjeyumtshentax ene' week, qa ekheweli'ƚ les qi qu' iftsaxe' hatse' qu' atanithenheti'yi'ƚ qa tees qu' ƚunye'ji'iju'ƚ na' ƚantanithenkeye'j hatse' ne' tetseti'yi' na' Tiro qa na' Sidón. ");
INSERT INTO mca_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Qa akha' witset Capernaum, ¿me ƚumti qu' ekekiti'yetspha'm na' wa's? Akha' ƚ'ewumhiti'yiiju' hatse' na' fe't ƚe'nq'itset'ij ne' naxju' (Hades). Qe qek nanaqsi'jiji'kii ka' witset'ik'i Sodoma kekhewe' ham ƚunyejeyi'iju'ƚ wanaqsi'jtaxij e'mijkii, ka' Sodoma'ak'i qekha hane'ej mexe nana'ltax. ");
INSERT INTO mca_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Qa hik ta'ƚijupi' qu' hit'ij ewets iye witset Capernaum, qu' namtaxets pa' neƚuji' qu' newetjeyumtshentax ene' week, qa ekheweli'ƚ les qi qu' iftsaxe' qu' atanithenheti'yi'ƚ qa tees qu' ƚunye'ji'iju'ƚ na' ƚantanithenkeye'j hatse' ke' tetseti'yi' ka' witset'ik'i Sodoma'ak'i.— ");
INSERT INTO mca_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hik aka'aj ka' ƚahats'ij ha' Jesús qa yit'ij pa'aj: —Qi in ƚe'wisij, Tata, Yatsat'axij na' wa's qa ha'ne sehe' iye qe hats ƚ'ethinij ene' nite' weniwqinhetji' eke' ham nikfe'le'ets t'ejuyets na' witiƚa'x, qa' nite' ƚ'ethinij pekhewe' wekwek nikfe'lets qa pekhewe' iye wekwek yiya'yij. ");
INSERT INTO mca_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ehe, Tata qe hik aka' ƚisu'un qu' ƚunye'je'.— ");
INSERT INTO mca_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Qa yit'ijets iye he' jukhew: —Na' Tata hats week tseƚisij qu' heinek'enhe'yipji' ene' wekwek. Ham pa'qu' ewi'ƚe' qu' nenikfee'letsha ha'ne Ƚa's. Ewi'ƚƚe na' Ƚatata in nikfe'letsha. Qa ham iye pa'qu' ewi'ƚe' qu' nenikfe'letsha na' Ƚatata, ewi'ƚe' ha'ne Ƚa's in nikfe'lets qa nekhewe' iye yisu'un ha'ne Ƚa's qu' nikfelitets qa yikfelitets. ");
INSERT INTO mca_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Eneki'ƚ yiwets week ekheweli'ƚ pe'qu' hats qi qu' niwefju' qa qi iye in neq'iihetij pe' wekwek qa yakha' qu' k'awapiihiti'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ku'mi'ƚi' qa' je'wetsjuk'eji' nakha' wakka ƚo'siyit (yugo) heni' yi'wonje' qa yakha' qu' k'ijatsheniƚij, qe yakha' nite' yeq'itaqsuna'x qa nite' iye heniwqinhetji' ma' qa qi qu' nawapii ne' atawjetsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Qe nakha' wakka ƚ'osiyit (yugo) heni' yi'wonje' nite' jutsutax qa ne' yaqatai qa af'ayaiji'.— ");
INSERT INTO mca_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hik aka'aj ka' ƚahats'ij ha' Jesús qa ikji'teje'm ha' wit'enekju' ka' ewi'ƚ neƚuji' witwapiihijii (sábado) nite' ƚeke' pa'qu' net'ithayiiji'. He' ƚ'ijatshenhei hats iyipkunju' qa nit'ijji' ke' ƚei trigo qa tuj. ");
INSERT INTO mca_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Qa he' fariseol in yi'wenij, ma' qa yiyaji'ets ha' Jesús qa yit'ijets: —Jeƚ qeku'nijju' ek ne' ijatshenhei ka' yaqsiijkii nite' ƚenexke'ej qu' naqsiijkii pe'ye' in yamets ha'ne neƚuji' witwapiihijii ham t'ithayiye'ji'.— ");
INSERT INTO mca_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma' qa yeku'ƚ ha' Jesús qa yit'ijiju'ƚ: —¿Me nite' ƚejeƚi'ƚ ne' witfaakanhei in nifel pa' yaqsiijkii pa'aj ka' David'ik'i pa' ewi'ƚ neƚuji' pa'aj in qi in iyipkuni'ƚju' pekhewe' ƚijts'eyek? ");
INSERT INTO mca_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Qa uyifi pa'aj pe' witlijtsitjii qa tuj pa'aj pe' pan t'ejutshenheti'yets na' Dios. Ekewe'en nite' ƚenexke'ej qu' netnekui. Uja'xƚi'ijkii pekhewe' pa'il in ƚeke' qu' netuj. ");
INSERT INTO mca_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Me nite' ƚejeƚi'ƚ iye ke' Moisés ƚe'lijei ne' pa'ilipji' ne' witlijtsitjii qu' net'ithayiiji' na'aj witwapiihijii (sábado), qa nite' uƚ'ax in yaqsiijkii? ");
INSERT INTO mca_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hit'iƚij ewets hane'ej in na'l na' les t'anipji' ne' witlijtsitjii hats ha'ne i'ni'in. ");
INSERT INTO mca_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ekheweli'ƚ qek enikfe'li'ƚik'i kakha' ikji'ha aka' wi'tlijei in yit'ij: “Yakha' les hisu'un qu' eq'iltinhetsi'iƚ qa nite' hisu'un pa'qu' ilantaxi'ƚyifi ene' inqa'metets” ma' qekha nite' it'etaxi'ƚijets qu' uƚ'etse' enewe' ham yaqsi'ji'ijkii pa'qu' uƚ'axe'. ");
INSERT INTO mca_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Qe ha'ne Ƚa's na' Jukhew Yatsat'axij tenek'enhe'yipji' ha'ne witwapiihijiiji' (sábado).— ");
INSERT INTO mca_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ha' Jesús in hats t'atsji'ƚik'uifik'i ha' wit'enekju' qa ikii qa uyifi ke' judiol ƚe'lijtsitjii. ");
INSERT INTO mca_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Qa hikha' i'ni' ha' ewi'ƚ jukhew yisƚax ka' ƚokoyik'i. Qa in ƚunye'jek hekhewe'en in wo'taxii pa'qu' nit'ijets qu' uƚ'axe' qu' naqsiijkii ha' Jesús, ma' qa nifaakan: —¿Me ƚeke' qu' jintiƚin pa'qu' nanqaats'etax in mexe witwapiihijiiji' (sábado)?— ");
INSERT INTO mca_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ha' Jesús qa yeku'ƚ qa yit'ijiju'ƚ: —¿Pa'n ƚii ekheweli'ƚ qu' nanamik'iju' pe'qu' witijkiye' pe'qu' ƚeƚinkiye' kots'etax in sabadoji'? ¿Me nite' nit'ijpha'm pekhe'en? ");
INSERT INTO mca_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Qa na'aj jukhew in les weju'ƚij yijat'ij nite' ƚunye'jiju'ƚ pe'qu' kots'etaxe', qa hik ta'ƚijupi' in ƚeke' qu' jintaqsiijkii pa'qu' ƚe'wise' pa'qu' sabadoye'ji'.— ");
INSERT INTO mca_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma' qa yiyaji'ets ha' jukhew qa yit'ijets: —¡Ijin na' okoi!— Ha' jukhew qa yijin ha' ƚokoi qa aje'eƚ hamiikii ka' ƚunye'jtax ha' ƚokoi, ma' qa week ƚunyejei iye he' ƚokoyei. ");
INSERT INTO mca_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma' qa ikfik'ikii he' fariseol qa yifaakateji' pa'qu' ƚeqfenyejeyi'ij qu' ƚeke'ye' qu' nilan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ha' Jesús in nikfe'lets aka'an, ma' qa ikik'ui hakha' i'ni' qa olots he' yijayanik'i. Ha' Jesús qa niƚinju' week hekhewe' wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Qa yiyaji'ijets qu' hasu'uj nenfeli'm pe'ye' kakha' yijaa'ija in ƚunye'j ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hats'inha qu' nafits kakha' yit'ij pa'aj pa' Intata in i'nijji' pa' profeta'ik'i Isaías, in yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—Jeƚi'ƚju', hane'en hik ha'ne yeqejkunene'k. Hik ha'ne he'yeku'miiji'. Qi in hisu'un qa qi iye in tsi'sinheti'mkii. Hetisij nakha'an na' yeqe Espíritu. Ƚakha' qa' nenfeli'm nakha' yatsathen nekhewe' witsetiikal nite' judiol. ");
INSERT INTO mca_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ƚakha' tees qu' netk'eƚei, tees qu' natyaiƚekii. Nite' ƚeke' qu' netpiikaxtii pa'qu' ƚ'axe' pe'qu' wit'ikheijeye'ji'. ");
INSERT INTO mca_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nite' yepƚet pe' fapu' in hats qaƚiyuje'm. Nite' yomhet iye in hats yomiyu'tax qa hats p'ulƚetax na'aj witfetitjiyij penyilo i'nji' ne'ej eƚi'ni. Hik aka' qu' ƚunye'je' qa' naamƚi'ijii qu' naxinentaxij pa' yatsathen. ");
INSERT INTO mca_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Qa aka' ƚiiji' qu' netjumti'ets week pe' witsetits pekhewe' qu' netk'enets.— ");
INSERT INTO mca_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ma' qa tetka'xii ha' Jesús ha' ewi'ƚ jukhew puk'al qa ham iye ƚe'lijeye' qe ta'ƚets pa' inwo'met. Qa ha' Jesús qa yiƚin, ma' qa yi'wenkitkii qa iyet iye. ");
INSERT INTO mca_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Week hekhewe' yi'wenij qi in yitjuƚaxijpha'mkii qa yifaakateji' iye: —¿Ma hik hane'ek pa' Ƚa's pa' David'ik'i?— ");
INSERT INTO mca_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","In yepi'ye' ek'i aka'an he' fariseol qa yit'ijju': —Pakha'ƚe Beelzebú, ƚatata pe' inwo'metets, tisij hane'en pa' ƚet'unha'xijup qa ƚeke' in yuki'nfik'ikii pekhewe' inwo'metets.— ");
INSERT INTO mca_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ha' Jesús nikfe'lets hekhewe'en ka' yumtitax qu' ƚunye'je' qa yit'ijji'ju': —Na'aj qi witset qu' nawatlanju'kii ma' qa ƚakha'ƚe ƚete'm qu' netwuƚ'enhetju' qa hik ƚunye'j iye na'aj witset ƚa's. Qa hik ƚunye'j iye na'aj ewi'ƚ jukhew qa ƚelits qa ƚewhe'ye' iye in watlanju'kii qa ƚekhewelƚe ƚete'm iye in wetwuƚ'enhetju'. ");
INSERT INTO mca_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma' qa hik ƚunye'j na' Satanás in ƚakha'ƚe ƚete'm qu' ne'nukinfik'i in Satanás, ma' qa ƚakha' ye'ƚe ƚete'm qu' newetqethenju'kii. ¿Qa pa'n ƚunye'j qu'nte' niliyi'ij na' tenek'enheiji' nakha'an? ");
INSERT INTO mca_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ekheweli'ƚ in ƚit'iƚijets in hukinfik'ikii pe' inwo'metets qa ta'ƚets pa' ƚet'unha'x na' Beelzebú qa qu' yijaayi'ija aka'an, ¿qa ƚek ƚet'unha'xek pa'qu' nata'ƚijets ne' ijatshenheyi'ƚ in yiwu'mfik'i pe' inwo'metets? Qa hik ta'ƚijupi' nekhewe'en qu' hik nekhewe'ye' qu' nit'iƚij ewets qu' ijaniƚik'i. ");
INSERT INTO mca_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Qa qu' nata'ƚƚe'ets na' ƚeqe Espíritu na' Dios in hukinfik'ikii ne' inwo'metets, ma' qa hats jutsiqax in hats nami'ƚ ewetsju' na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Pa'n ƚeqfenye'j ƚewek pa'qu' nuyetsji' pe'qu' ƚetsi'ye' pa'qu' net'un jukhew qa' nenitka'mij pekhewe' ƚewekwekits qu'nte' nojoye' qu' nophe'ƚ? Qu' nophe'ƚ yijat'ij ma' qa ƚeke'ye' yijat'ij qu' nenitka'mij pe'qu' ƚewekwekitse'. ");
INSERT INTO mca_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pakha' qu' nite' yi'feyi'ij pakha'an yejuihife'ej. Qa pakha' nite' tsi'fenij in haqsi'jje'mkii qa yak'esa'xƚekii. ");
INSERT INTO mca_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Qa hik ta'ƚijupi' qu' hit'iƚij ewets, in week pakha' qu' naqsiijkii pakha' qu' ƚunye'je'ƚe pa' uƚ'ax qa pakha' iye qu' uƚ'etsik'i ƚe'lijeyi'ij pa'qu' ƚunye'je'ƚe, qa ƚeke'ƚe qu' netwumhiti'yik'ui pe' ƚewuƚ'ets. Qa pakha'ƚe qu' uƚ'ax ƚ'anye'je'ets nakha' Espíritu Santo qa' nite' ƚeke'ye' qu' netwumhiti'yik'ui pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pa'qu' ƚunye'je' qu' nit'ij pa'qu' ewi'ƚ wi'tlijeye' t'ejuyiju'ƚ ha'ne Ƚa's na' Jukhew, qa ƚeke'ƚe qu' netwumhiti'yik'ui aka'an. Qa pakha'ƚe qu' nit'ij pekhewe' qu' net'ejuyiju'ƚ nakha' Espíritu Santo qa nite' ƚeke' qu' netwumhiti'yik'ui pekhewe'en, nite' hane'ej ha'ne ƚahats'ij qa nite' iye pakha' mexe hamik'ui.— ");
INSERT INTO mca_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ha' Jesús qa yit'ijets iye he' fariseol: —Jeƚi'ƚji' pa'qu' it'iƚijju'ha ekewe'en in t'ejuyets ka' haqsiijkii, ne' najkak ƚe'wis qa ƚe'sitsjijek ƚei, ne' najkak uƚ'ax qa uƚ'etsjeek ƚei, qe ne'ej ƚei hik ne'ej jutsiqetsij ne'ej najkak. ");
INSERT INTO mca_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Q'oiq'oyits ƚelits! ¿Pa'n ƚunye'j qu' it'iƚij pa'qu' ƚe'wise' in ekheweli'ƚ qi in uƚ'etsi'ƚ? Qe pakha' topo'oj ha'ne intawe'j qa hik pakha' t'atsji'ƚii ha'ne ineji'. ");
INSERT INTO mca_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pakha' jukhew ƚe'wis qe ta'ƚets pe' ƚe'sits yenji'ju'kii pa' ƚatawe'j ma' qa t'atsji'ƚfik'i pa' ƚe'wis, qa pakha'ƚe qu' uƚ'ax jukhewe' qe ta'ƚets pe' uƚ'ets yenji'ju'kii pa' ƚatawe'j ma' qa t'atsji'ƚfik'i pa' uƚ'ax. ");
INSERT INTO mca_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Qa yakha' qa hit'iƚij ewets qu' namtaxets pa' neƚuji' qu' week newetjeyutshentax, ma' qa' nenfeelija ƚekpa' ta'ƚijupi' in yit'ij pe' ham weju'ƚi'ij wi'tlijei nite' ƚeke'tax qu' nit'ij. ");
INSERT INTO mca_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Qe pe' e'lijei hik pekhewe' qu' nata'ƚets qu' nenit'ij ewets hatse' yatsathen, qa pe' e'lijei iye qu' nata'ƚets qu' nenit'ij ewets hatse' qu' uƚ'axe' qa' atanithenhetii.— ");
INSERT INTO mca_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ma' qa he' uja'x he' fariseol qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei qa yit'ijets ha' Jesús: —Maestro, hisu'untaxi'ƚ qu' k'eweniƚijha qu' aqsiijkii pa'qu' ham ƚunye'ji'iju'ƚ hats'inha qu' jutsiqetsi'iƚ ye'mha qu' neƚisij pa' et'unha'x pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ha' Jesús qa yeku'ƚ: —Enewe' hane'ej jukhew qi in uƚ'ets qa nite' ewi'ƚƚi'i' iye nakha' yijayantax, iyintaxets qu' net'ethinheti'yij pa'qu' ham ƚunye'ji'iju'ƚ, qa hatsƚe nite' ƚeke' qu' net'ethinheti'yij pa'qu' ham ƚunye'ji'iju'ƚ. Ewi'ƚƚe hatse' qu' net'ethinheti'yij qu' hik ƚunye'je' ka' ƚunye'jkii ka' profeta'ik'i Jonás. ");
INSERT INTO mca_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Qe in ƚunye'jek in i'nji' ka' Jonás pe' ƚekutjii pa' qi ƚejits wetshetk'ewi'ƚ neƚuts qa wetshetk'ewi'ƚ najai qa' hik aka' qu' ƚunye'je' ha'ne Ƚa's na' Jukhew wetshetk'ewi'ƚ neƚuts qa wetshetk'ewi'ƚ najai iye qu' na'nji'ju' ha'ne sehe'. ");
INSERT INTO mca_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kekhewe' Nínive ƚeiƚetsik'i niipha'mkii hatse' qu' neniitaxpha'mkii enewe' hane'ej na'l ha'ne ƚahats'ij pa' neƚuji' qu' newetjeyumtshentax ene' week, kekhewe'en qa' nit'ijets qu' les uƚ'etse' wiikfik'i enewe' hane'ej na'l ha'ne ƚahats'ij. Qe ke' Nínive ƚeiƚetsik'i yili'ij in yaqsiijkii pe' uƚ'ets in yepi'ye' ek'i ke' nifeli'm ka' Jonas'ik'i, qa hane'ej nakha' les in t'anipji' ka' Jonas'ik'i qa hats ha'ne i'ntaxi'in. ");
INSERT INTO mca_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ke' ewi'ƚ efu'uk'i qi tenek'enhei ta'ƚii na' i'wk'uyi'lii qa' neniipha'm hatse' qu' neniitaxpha'mkii enewe' hane'ej na'l ha'ne ƚahats'ij pa' neƚuji' qu' newetjeyumtshentax ene' week, kekhe'en qa' nit'ijets qu' les uƚ'etse' wiikfik'i enewe' hane'ej na'l ha'ne ƚahats'ij. Qe ƚakha' ke' efu'uk'i in toxtaxii yemjee na' ta'ƚji' nakhap seheika' qa namii qu' nepiye' ka' qi ƚikfeliya'xkii ka' wittata'ak'i Salomón, qa hane'ej nakha' les in t'anipji' ka' Salomon'ik'i qa hats ha'ne i'ntaxi'in.— ");
INSERT INTO mca_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ha' Jesús qa yit'ij iye: —Pa'qu' ewi'ƚ inwo'met'e in ikik'uifik'i na'aj jukhew qa nekƚi'ikii pe' yisƚaxkii sehel, wo'taxiikii ƚawapiihiwet'e qa nite'ƚe yi'wen, ");
INSERT INTO mca_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ma' qa yit'ij: “Qa' hapilii iye ke' yitsi' ke' hata'ƚifi.” Qa in tepilii qa yi'wen in ham i'ni'ifi. Hats wetp'ilastaxifi qa hats wanaqsi'jtaxifi iye. ");
INSERT INTO mca_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ma' qa ik iye qa ikii pekhewep iye wetsjuk tatsai (7) inwo'metets les qi in uƚ'ets wiikfik'i qa t'eqe'mets qa week enewe'en qa uiji'teje'm iye qa i'nji' iye pakha' jukhew. Ma' qa les qi'ija in uƚ'ax nite' hik ƚunye'j pa' yojoo in ƚunye'jtax. Aka'an hik aka' qu' ƚunyejeye' hatse' enewe' uƚ'ets jukhew ha'ne hane'ej ƚahats'ij.— ");
INSERT INTO mca_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ha' Jesús in mexe iyetik'ui hekhewe' olots jukhew qa' efuts iye, qa namtaxets ke' ƚenene qa he' ƚek'injats iye qe nifaakateyutaxets qa amaneiƚefik'i. ");
INSERT INTO mca_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Qa ewi'ƚ ha' yit'ijets ha' Jesús: —Ke' enene qa he' ek'injats ha'niite' amaneyi'fik'i, nifaakateyutax ewets.— ");
INSERT INTO mca_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Qa yeku'ƚ ha' Jesús hakha'an, qa yit'ijets: —¿Ƚek pekhe' nene qa ƚek pekhewe' iye k'injats?— ");
INSERT INTO mca_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma' qa t'apsiiji'teje'm he' ƚ'ijatshenhei qa yit'ij: —Enewe'en k'injats qa nene iye. ");
INSERT INTO mca_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Qe pa'qu' ƚunye'je' qu' naqsiijkii pa' yisu'un na' Tata i'ni' na' wa's, qa hik ha'ne k'inij qa k'inja' iye qa nene iye.— ");
INSERT INTO mca_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hik kakha' ka' neƚuji' qa ikik'uifik'i ke' wititsi' ha' Jesús qa i'niju' ha' ƚotkoyek ke' kaƚi'. ");
INSERT INTO mca_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Qa olootsija he' nekii, qa hik ta'ƚijupi' ha' Jesús in t'ilitji'ju' ke' qi'ik'i witinhitjii qa i'nji'ju' qa hekhewe'ƚe jukhew qa efuts iye qa amaneyi' ha' ƚotkoyek ke' kaƚi'. ");
INSERT INTO mca_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma' qa iyetik'ui qa olots ke' wekwek in yejeyumtshenijupi', qa yit'ij: —Ewi'ƚ pa' jukhew iwenq'enhena'x ikii pa' ƚewenq'enhe'wet. ");
INSERT INTO mca_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","In we'nq'en qa namji'ju'kii pe' uja'x ƚoqoƚoi pa' wit'ikheyi'j, qa namii pe' junatai qa tuj. ");
INSERT INTO mca_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Qa pekhewep qa namji'ju'kiyek pa' t'un sehe' qe uteket, qa nite' qi pa'qu' seheeyi'ija. Enewe' ƚoi qa aje'eƚ ta'ƚ qe nite' akaptaxju' pa' sehee'ija. ");
INSERT INTO mca_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Qa in nekpha'm ne' junu' qa yaq'alij aje'eƚ, qe nite' ijetits pe'qu' ƚefitetsiye' qa yisƚax aje'eƚ. ");
INSERT INTO mca_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Qa pekhewep iye ƚoi qa namji'ju'kiyek pa' tiiket, qa pa' tiiket in qitspha'm qa tik'eyijju' qa yitaƚi'meten. ");
INSERT INTO mca_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Qa pekhewep iye ƚoi qa namji'ju'kiyek pa' ƚe'wisji' sehe' qa itaƚimetsits qa na'l iye pe' ƚei. Uja'x pe' yamets cien (100) pe' ta'ƚ in ewi'ƚtax pe' ƚo' qa uja'x pe' sesenta (60) yamets in ewi'ƚtax pe' ƚo' qa uja'x iye pe' treinta (30) in ewi'ƚtax pe' ƚo'. ");
INSERT INTO mca_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pa'qu' nana'l ƚekfiiye' qa nepiye'ek'iha aka'an.— ");
INSERT INTO mca_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","He' ƚ'ijatshenhei qa ikets qa we'tmetinheti'm ha' Jesús qa nifaakanij: —¿Inhats'ek in ƚit'iji' in ƚ'iyetik'ui hekhewe' jukhew qa efuts iye kekhewe' wekwek in ƚejeyumtshenijupi'?— ");
INSERT INTO mca_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ha' Jesús qa yeku'ƚ: —Qe ekheweli'ƚ ƚexke'ej na' Dios qu' enikfe'li'ƚets ekewe' nite' hayiits qu' nana'l pa'qu' nenikfe'lets t'ejuyets na' tenek'enheiji' na' Dios. Qa nekhewe'ƚe'en qa nite' ƚexke'ej na' Dios qu' nenikfe'lets. ");
INSERT INTO mca_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Qe pa'qu' hats nana'li'm, qa' les netesti'yij iye, ma' qa' les qiyi'ija pa'qu' nana'li'm. Qa pakha'ƚe hami'm, qa' netitkamhiti'yij iye pa' ƚammi's in na'ltaxi'm. ");
INSERT INTO mca_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Qa hik ta'ƚijupi' in hit'iƚij'e' in k'iyeti'ƚ ek'ui ke' wekwek hejeyumtshenijupi'. Qe ƚekhewel yejeƚƚeju' qa nite'ƚe yi'weenija. Tek'entaxik'i qa nite'ƚe yepi'ye' ek'i, nite' nikfe'lik'i iye. ");
INSERT INTO mca_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aka'an in ƚunyejei nekhewe'en ma' qa hats yafits kakha' yit'ij ka' profeta'ik'i Isaías in yit'ij: “Yepi'ye'tax qa nite'ƚe nikfe'lik'i. Yejeƚtaxju' qa nite'ƚe yi'wen. ");
INSERT INTO mca_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Qe pe' ƚaqjamtikineyejeikii ha'ne witset tit'oyik'i. Yit'onik'i ƚekfii qa yit'onik'i iye ƚotoi. Qa qu' nite' hik aka' ƚunyejeye', in yejeƚju' qekha ni'wentax, in yepi'ye' ek'i qekha netk'entaxik'iha, qekha nenikfe'ltaxik'i iye pe' ƚaqjamtikineyejeikii ma' qekha nink'aihittax qa yakha' qekha henƚintaxju'.” ");
INSERT INTO mca_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Qa ekheweli'ƚ qa' e'ƚe'sitsi'ƚi'mkii qe na'l ne' otoyi'ƚ qa ƚi'weniƚkii qa ne' ekfiyi'ƚ iye qa ƚepiye'eƚkii. ");
INSERT INTO mca_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yijaa'ija aka' hit'iƚij ewets in olotstax ke' profeta'ik'i qa ke' yatsathen jukhewik'i yisu'untax qu' ni'wen ha'ne hane'ej ƚi'weni'ƚ qa nite'ƚe yi'wen. Yisu'untax qu' nepiye' ha'ne hane'ej ƚepi'ye'eƚ qa nite'ƚe yepi'ye'.— ");
INSERT INTO mca_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ha' Jesús qa yit'ij iye: —Ek'eni'ƚ, hane'ej qu' henfel ka' ikji'ha pa' ewi'ƚ iwenq'enhena'x. ");
INSERT INTO mca_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Week pa'qu' nepi'ye'taxik'i eke' wi'tlijei t'ejuyets na' tenek'enheiji' na' Dios, qa nite'ƚe nikfe'lik'i, qa hik ƚunyejei pekhewe' ƚoi namji'ju'kii pa' wit'ikheyi'j. Qa nam na' inwo'met qa nitka'mij eke' wi'tlijei we'nentaxji'ju' ƚatawe'j. ");
INSERT INTO mca_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Qa pe' ƚoi namji'ju'kiyek pa' uteket qa hik ƚunyejei pe' yepi'ye' ek'i ke' wi'tlijei qa t'eku'mi' aje'eƚ qa ƚesitsi'mik'iha. ");
INSERT INTO mca_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Qa in nite'ƚe ijetits pe'qu' ƚefitetsiye' qa nite' t'unitsji'. In tajaajinhetii qa wenit'ijetskii pe' uƚ'ets ma' qa yo'qmositij qa yili'ij aje'eƚ. ");
INSERT INTO mca_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Qa pekhewe' ƚoi namji'ju'kiyek pa' tiiket qa hik ƚunyejei pekhewe' qu' nepiye'ek'i ekewe' wi'tlijei, qa lesƚe in yamitfik'i in yitawje'meten ekewe' wekwek, qa pa' ƚeqsu'unka'xij ekewe' wekwek qa qi in yawitji. Qa week ekewe'en tit'oyijju' kekhewe' wi'tlijei, ma' qa ham ƚeye'. ");
INSERT INTO mca_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Qa pekhewe' ƚoi namji'ju'kiyek pa' ƚe'wisji' sehe' qa hik ƚunyejei pekhewe' qu' nepiye'ek'i eke' wi'tlijei qa nikfe'lik'i. Ma' qa hik pekhewe' qa na'l yijat'ij pe' ƚei, ewi'ƚtax pe' ƚo' qa yamets cien (100) pe' ƚei, qa pekhewep qa yametsek sesenta (60) qa pekhewep iye qa yametsek treinta (30) pe' ƚei.— ");
INSERT INTO mca_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ha' Jesús nifeli'm iye kakhap iye wekwek yejeyumtshenijupi': —Na' tenek'enheiji' na' Dios hik ƚunye'j na'aj ewi'ƚ jukhew in yeni'ju' ne'ej ƚe'sits ƚoqoƚoi na'aj ƚewenq'enhe'wet. ");
INSERT INTO mca_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Qa in hats week ima'ju' qa namii pa' ewi'ƚ ƚ'ejuihife qa yenji'ju' ek pe' ƚoqoƚoi ne'ej cizaña hik ƚunyejeitax trigo pa' witwenq'enhe'wet'ij pe' trigo, ma' qa ik iye pakha'an. ");
INSERT INTO mca_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Qa in hats qhufje'm pe' trigo ma' qa hats laxaji' pe' ƚei, qa ƚunyejeijijek iye pe' cizaña we'nenji'ju' in teiji'jek. ");
INSERT INTO mca_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma' qa pe' yithayiki qa nifelii pa' yatsat'axij pa' wit'enekju': “Yaqa patun, in ƚe'sitstax ke' ƚoi ƚ'eniju' na' ewenq'enhe'wet ¿qa pa'n qu' nata'ƚji' ne' cizaña in ƚataƚifetsij?” ");
INSERT INTO mca_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Qa yit'ij pa' patun: “Na'l na' i'nejuihife t'ejtenijji'ju' pa'aj in yenji'ju'.” Pekhewe' t'ithayii qa nifaakanij iye: “¿Me ƚisu'un qu' haki'ƚii qa' henit'iƚijik'i?” ");
INSERT INTO mca_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Qa pakha'an qa yit'ij: “Nite', qe qu' enit'iƚijpha'm ne' cizaña qa i'nƚi'i qu' enit'iƚijpha'm iye ne' trigo. ");
INSERT INTO mca_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iwejinƚe eku'ni'ƚij qu' week nata'ƚi'ƚ ipƚu'ui qu' netenittaxijji' ne' trigo. Qa qu' namtaxets qu' netenit'ijji' ma' qa' hit'ijets nekhewe' qu' nenit'ijji': ‘Ojohoni'ƚ qu' ant'a'aƚiiji' ne' cizaña qa isifini'ƚ je'mkii hats'inha qa' netene'ƚju', qa nekhewe'ƚe trigo qa' eni'ƚifi ne' yextsi'ij.’”— ");
INSERT INTO mca_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ha' Jesús nifeli'm iye kakhap iye yejeyumtshenijupi': —Na' tenek'enheiji' na' Dios hik ƚunye'j iye ne'ej mostaza ƚo' na'aj jukhew in yeni'ju' pa'qu' ƚeq'ejinqa'wet'e. ");
INSERT INTO mca_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yijaa'ija pe' ƚo' in hik pekhe' les in nite' qi pe' week ƚoi. Qa in ta'ƚ qa les qipha'm, nite' ƚuk'elpha'm pekhewep wit'enheiju' ne'ej ƚesejets (hortalizas) qe qipha'mha ma' qa najkak'ij. Ma' qa namii ne'ej junatai qa tupiiji' ne'ej ƚakjil.— ");
INSERT INTO mca_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ha' Jesús qa nifeli'm iye kakhap iye yejeyumtshenijupi': —Na' tenek'enheiji' na' Dios hik ƚunye'j iye ne'ej levadura, ne'ej ewi'ƚ efu in yetsjiƚkinij na'aj fo'ji' qitaxji' qa ƚammistax levadura. Ma' qa in hats yamje'mha qa yiju'fjufinhetik'i ma' qa les in qi'ija na'aj fo'ji'.— ");
INSERT INTO mca_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Week qa iyetjiik'ui ha' Jesús he' jukhew qa efuts iye qa uja'xƚe qa yitjiiji' ne'ej yejeyumtshenijupi', qa ham pa' qu'nte' nejeyumtsheni'ijupi' qa iyetjiik'ui, ");
INSERT INTO mca_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","qe qa' nasinik'iha kakha' hayiits yit'ij pa'aj pa' ewi'ƚ profeta'ik'i in yit'ij: —Hit'iji' hatse' pe'qu' newetjeyumtshenƚi ijupi' qu' nek'iyetik'ui. Hit'ij hatse' kekhewe' wekwek nite' hayiits qu' nana'l pa'qu' nenikfe'lets in ipƚu'uk'i ek in i'nk'a wanaqsiijkii ha'ne week sehe'.— ");
INSERT INTO mca_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ha' Jesús qa wetfeli'm hekhewe' jukhew qa efuts ma' qa uyifi ke' wititsi'. Qa hik hakha'a' he' ƚ'ijatshenhei qa nekets qa yit'ijets: —Enfeli'ƚ ye'mha pakha' ikji'ha pekhewe' cizaña we'nenji'ju' pa' wit'enekju'.— ");
INSERT INTO mca_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ha' Jesús qa yeku'ƚ qa yit'ij: —Pakha' yenju' pe' ƚe'sits ƚoi hik ha'ne ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Qa pa' witwenq'enhe'wet qa hik ha'ne ha'ne week sehe' ipji'. Pe' ƚe'sits ƚoi qa hik pekhewe' pe' ƚelits na' tenek'enheiji' na' Dios. Qa pekhewe'ƚe cizaña hik pekhewe' pe' ƚelits nakha' uƚ'ax. ");
INSERT INTO mca_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Qa pakha' ƚ'ejuihife in yenju' qa hik nakha' na' inwo'met. Qa in tenit'ijji' pe' ƚei qa hik ƚunye'j qu' namtaxets pa' ƚahats'ij qu' hame' ha'ne week sehe'. Qa pekhewe' nit'ijji' pe' ƚei qa hik nekhewe' ne' angelits. ");
INSERT INTO mca_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Qa hik ƚunye'j iye in ewi'ƚ we'neni' pe' cizaña, qe qa' netene'ƚju', qa' hik ƚunye'je' iye hatse' qu' namtaxets pa' ƚahats'ij qu' hame' ha'ne week sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ha'ne Ƚa's na' Jukhew yukinii hatse' ne' ƚaqa angelits nakha' tenek'enheiji', qa' nant'a'aiji' week nekhewe' inqaqsijkinenjiijkii na' uƚ'ax qa nekhewe' iye yaqsiijkii na' uƚ'ax in i'ntaxji'teje'm. ");
INSERT INTO mca_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Qa' niwumik'iteje'mkii ne' noxp'onhetjii qi in tujje'mha. Qa hikna' qi qu' nejtsi'le'e' wetju'ƚ, qa qi iye qu' nat'aiji' ƚek'unhetii. ");
INSERT INTO mca_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma' qa pekhewe' yatsathen qa' netujjiha hatse' in ƚunye'jek ne' junu' qu' hats nantaxji'teje'mha na' tenek'enheiji' na' Ƚatata. Pa'qu' nana'l ƚekfiiye' qa' nepiye'ek'i aka'an.— ");
INSERT INTO mca_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Na' tenek'enheiji' na' Dios hik ƚunye'j iye ne'ej ewi'ƚ qi inyetax wekwek in tat'inheti'yi'kii pa' ewi'ƚ ƚ'ejinqa'wet. Qa ewi'ƚ pa' jukhew yi'wen qa yayaxkit iye in yat'inkii iye, qa qi in ƚe'wisi'mkii qa wapilii pe' ƚetsi' qa week t'ihinij pekhewe' ƚewekwekits ma' qa taqha'yets pa' ƚ'ejinqa'wet yat'inikii pe' ewi'ƚ wekwek qi inyetax.— ");
INSERT INTO mca_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Na' tenek'enheiji' na' Dios hik ƚunye'j iye aka'an, na'aj ewi'ƚ t'ihinij wekwek, in wo'oi ne'ej inyetets ƚe'sits utel ƚelits perlas. ");
INSERT INTO mca_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Qa in yi'wen pekhe' les in ƚe'wis perla, qa wapilii pe' ƚetsi'. Ma' qa week t'ihinijkii pe' ƚewekwekits ma' qa' taqha'yets pekhe'en.— ");
INSERT INTO mca_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ha' Jesús qa yit'ij iye: —Na' tenek'enheiji' na' Dios hik ƚunye'j iye ne'ej ewi'ƚ witq'ehemki' tewumhitiiji'ju' na'aj iweli' qa olotsji' ƚunyejeiƚe wetju'ƚ ƚejits witq'ehemkinel. ");
INSERT INTO mca_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","In topo'oj pe' witq'ehemki' qa pekhewe' teq'ehemkii qa yetsinijetspha'm pa' ƚ'isƚa'wet qa i'nijupju'kii qa yejeƚji' pe' ƚe'sits qa yenji' pe' canastul qa pekhewe'ƚe uƚ'ets qa yiwu'mƚekii. ");
INSERT INTO mca_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hik qu' ƚunye'je' hatse' qu' nanaxtaxijik'i pa' ƚahats'ij. Qa' nak ne' angelits qu' nant'a'aiji' ne' uƚ'ets in wenetsji'ƚtaxi'ƚ ne' yatsathen, ");
INSERT INTO mca_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ma' qa niwu'mik'iteje'mkii ne' noxp'onhetjii qi in tujje'mha. Qa' hik nakha'a' qu' qi qu' nejtsi'le'e' wetju'ƚ qa' qi iye qu' nat'aiji' ƚek'unhetii. ");
INSERT INTO mca_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Me week qu' enikfe'li'ƚik'i ekewe'en?— Hekhewe'en qa yeku'ƚ: —Ehe, Yatsat'axyij.— ");
INSERT INTO mca_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma' qa ha' Jesús qa yit'ijji'ju' iye: —Qa hik ta'ƚijupi' na'aj ewi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei (ley) in tetwek'ela'xets qa i'nji'teje'm na' tenek'enheiji' na' Intata, ma' qa hik ƚunye'j na'aj ewi'ƚ jukhew yatsat'axij ne'ej wititsi' in nikfe'lets qu' ni'nq'ethinij pe' ƚewekwekits pe' ink'aihits qa pe' ƚawa'mhits iye.— ");
INSERT INTO mca_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","In yili'ij ha' Jesús in nifel eke' wekwek yejeyumtshenijupi' pa' ƚunye'jkii, ma' qa ikik'ui ha' witset. ");
INSERT INTO mca_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Qa yamii ha' ƚetseet'ija qa hik hakha'a' qa i'nq'ijatshenifi ke' judiol ƚe'lijtsitjii. Qa he' jukhew qa qi in yitjuƚaxijpha'mkii, qa yit'ijju': —¿Pa'n ta'ƚiji' hane'en week ekewe' nikfe'lets? ¿Qa pa'n ta'ƚiji' iye pa' ƚet'unha'x in yaqsiijkii eke' ham ƚunyejeyi'iju'ƚ? ");
INSERT INTO mca_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Me nite' hik ha'ne ƚa's ka' ewi'ƚ carpintero'ik'i? ¿Me nite' ƚii ke' ƚenene María, qa he' ƚek'injats qa Jacobo (Santiago), qa ha' José, qa ha' Simón qa ha' Judas iye? ");
INSERT INTO mca_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Me nite' hik ha'ne iye i'ni' he' ƚek'injai? ¿Qa pa'n ta'ƚiji' hane'en week ekewe' wekwek?— ");
INSERT INTO mca_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Qa aka'an in ta'ƚijupi' qa nite' nek'enheyu'ets. Qa ha' Jesús qa yit'ij: —Ham pa'qu' profetaye' qu' nite' nineqjunu'ye', qa ni'kha'ƚi'ij ƚetsetitstaxija' qa ƚetsi'taxija iye qa hik ne'ej qa nite' neqjunu'uj.— ");
INSERT INTO mca_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Qa hik ta'ƚijupi' in nite' olots ke' yaqsiiji'kii wekwek ham ƚunye'ji'iju'ƚ hakha' witset qe he' tetseti'yi' qi in yeqeku'. ");
INSERT INTO mca_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hik akaa'ijha ka' ƚahats'ij, ha' Herodes tenek'enhe'yi' ha' Galilea qa i'ye'ej ke' yaqsiijkii ha' Jesús in ham ƚunyejeyi'iju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Qa yit'ijets pekhewe' ƚeqejkunenhei: —Hik kakha' Juan Bautista'ik'i. Hats iƚa'x iye. Qa hik ta'ƚijupi' in na'li'm pa' qi ƚet'unha'x qa ƚeke' in yaqsiijkii pekhewe' ham ƚunyejeyi'iju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Qe ha' Herodes t'eku'mi' pa'aj ka' Juan'ik'i qa yophe'ƚ ƚokoyei qa yenifi iye pe' witq'opheƚitjii, qe ta'ƚets pa'aj pe' ewi'ƚ efu ƚii Herodías ƚewhe'ye'tax pa' ƚek'inij ƚii Felipe. ");
INSERT INTO mca_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Qe ka' Juan'ik'i yittaxijets pa'aj: —Nite' inek ƚenexke'ej kakha'an qu' ewhe'ye'yi'ij nekhe' efeli'tstax.— ");
INSERT INTO mca_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Qa ha' Herodes in neqek'uyu'taxij pa'aj ka' Juan, qa nijiweiƚi'iju'ƚ iye pa' witset, qe titijiti'yijetsha ka' Juan'ik'i in ewi'ƚ profeta. ");
INSERT INTO mca_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Qa in ink'ayik ƚeqe'ninqa'p ha' Herodes, qa ke' ƚasi' ke' Herodías qa t'otoyijup pekhewe' namii in ƚeqe ƚe'wis neƚu pa'aj. Ha' Herodes qa qi in yisu'unijji' pa'aj ke' inanyi' in t'otoyijup. ");
INSERT INTO mca_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Qa hik ta'ƚijupi' in weniwjutsiqeniji'mha qu' yijaayi'ija qu' netisij pa'qu' niyinijets. ");
INSERT INTO mca_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ke' inanyi' in tayajaxti'yetskii pa'aj yiyaji'etskii pa'aj ke' ƚenene, ma' qa yit'ij: —Hisu'un qu' entshen hane'ejija ha' ƚeiƚa' ha' Juan Bautista. Enji' tok'oye'.— ");
INSERT INTO mca_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aka'an qa qi in nite' yi'sinhettaxi'mkii pa'aj ha' Herodes, qa hatsƚe tetfelijha in weniwjutsiqen qa week iye yepi'ye' ej pe' namii pa' ƚeqe ƚe'wis neƚu. Ma' qa inaqyaji'ij qu' netetka'xii qa' netesti'yij. ");
INSERT INTO mca_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma' qa inq'ukinii qu' ne'nisa'xii ka' ƚeiƚa' ka' Juan'ik'i pe' witq'opheƚitjiyii. ");
INSERT INTO mca_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma' qa tetka'x pa'aj ka' ƚeiƚa' ka' Juan'ik'i i'nji' pa' tok'o qa testi'yij pe' inanyi' qa yeka'xiiji' pe' ƚenene qa tisij pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Qa namii pa'aj he' ƚ'ijatshenhei ka' Juan'ik'i qa yeka'x pa'aj qu' netijik'ui. Hekhewe'en qa nifelii ha' Jesús ka' ƚenifenye'j ka' Juan'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","In i'ye'ej ha' Jesús ka' Juan'ik'i in talanhetii pa'aj, ma' qa ikkii uja'xƚekii qa i'nji' ke' witinhitjii qu' namijiiteje'm ha' ham i'ni'i'. Ma' qa in nikfe'lets he' week witsetits hekhewe' jukhew qa efuts iye pa' t'ejuiji', qa yijayanpha'm qa t'otsƚeju' in yamik'ui ha' t'ejuiji'. ");
INSERT INTO mca_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Qa in t'ilittaxpha'm ha' Jesús qa yi'wen in olootsija he' nijayan. Qa qi in neq'eletij qa niƚinju' iye he' wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","In hats metju' junu', he' ƚ'ijatshenhei qa ikets qa yit'ijets: —Hats metiyu'ju' ne' junu' qa ha'ne ju'uni' ham pa'qu' na'ni'. Yape it'ijets ene' jukhew qa efuts iye qu' napilii he' witsetits ƚelits hats'inha qu' nataqha'yets ƚaqatse'.— ");
INSERT INTO mca_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Qa yeku'ƚ ha' Jesús: —Inye'jƚu' qu'nte' napile'kii. Ekheweli'ƚ qu' ƚisi'ƚij pa'qu' netuj enewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Qa yeku'ƚ iye he' ƚ'ijatshenhei: —Uja'xƚe inek ene' na'l ine'm lee'fij (5) ene' pan, qa wetsjuk ene' sehets, qa uja'xƚe.— ");
INSERT INTO mca_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ha' Jesús qa yit'ijets: —Enka'xi'ƚ met pekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma' qa yiyaji'ijets qu' nanaqsijju' qu' na'ni'ju'kii ha' jup'elket week hekhewe' jukhew qa efuts iye. Ma' qa t'eku'mi' ke' lee'fij (5) pan qa ke' wetsjuk sehets qa yejeƚetspha'm na' wa's qa yit'ijetspha'm ƚe'wisij pa' Dios. Ma' qa napk'asitju' ke' pan qa tisij he' ƚ'ijatshenhei qa hikhe' qa netisijju' he' week jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Qa weekij in tuj qa hats iƚinijju'. Qa he' ƚ'ijatshenhei qa nat'a'ak'i ke' ƚapk'asil ke' amaneifik'i qa yenji'ju'kii he' doce (12) canastul qa topolij. ");
INSERT INTO mca_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inƚi'i qu' leefij mil (5.000) uja'x namets he' jukhew tuj ke' pa'n. Qa hekhewe'ƚe efuts qa omehets iye qa nite' wetjeyumtshen. ");
INSERT INTO mca_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","In naxijik'i aka'an, ma' qa ha' Jesús qa aje'eƚ yiyaji'ets he' ƚ'ijatshenhei qu' aje'eƚ nathayinijiiteje'm ke' witinhitjii ha' ƚajaika' ai, qa ƚakha'ƚe qa' mexe newetfeli'm he' jukhew hats'inha qu' napilkii. ");
INSERT INTO mca_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Qa in hats yili'ij in wetfeli'm he' olots, ma' qa ikik'ipha'm ke' utek ewi'ƚƚekii qe qa' niyin. Ma' qa in hats najaleikii qa menjiit amani' ewi'ƚƚekii. ");
INSERT INTO mca_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qa kikhe'ƚe witinhitjii qa hats toxik'iteje'mha, qa ke' ƚeqe t'uyuyuyits ha' iweli' qitsik'i qa yiwu'miju'ƚkii ke' witinhitjii qa nite' ju'f qe t'ejuyiju'ƚ ka' t'unik'i. ");
INSERT INTO mca_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma' qa in hats ipƚu'uikii pa' neƚu ha' Jesús qa yijayanpha'm hekhewe'en t'otsipji' ha' iweli'. ");
INSERT INTO mca_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","He' ƚ'ijatshenhei in yi'weniju'ƚ in t'otsipji' ha' iweli' qa qi in nijiwei, qa yit'ijju': —¡Peyijat'ij, ma wit-si'nq'alek hane'en!— Ma' qa yeqejtsi'le'ej wetju'ƚ qe qi in nijiweitax. ");
INSERT INTO mca_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Qa aje'eƚ yit'ijets ha' Jesús: —¡Ikesimeni'ƚ! Yakha'ƚe, e'nijiweikitek'iƚ.— ");
INSERT INTO mca_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Qa ha' Pedro qa yeku'ƚ qa yit'ij: —Yatsat'axyij, qu' hik akhaayi'ija qa it'ij yiwets qu' henek ei na' ƚa'ni' na' iweli'ipji'.— ");
INSERT INTO mca_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Qa yit'ij ha' Jesús: —¡Te'ƚun!— Qa ha' Pedro qa t'ilit'ik'uiju' ke' witinhitjii qa t'otsipji' ha' iweli' qa ikii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ha' Pedro in yi'wen in t'unik'i qa nijiwei, ma' qa nikheyu'ju' qa tayai, qa yit'ij: —¡Etsi'fen wat'ij, Yatsat'axyij!— ");
INSERT INTO mca_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ha' Jesús qa aje'eƚ yijin ha' ƚokoi qa t'eku'mi', qa yit'ijets: —Hayits qa nite' qi pa'nte' eqekuye'jtax. ¿Inhats'ek in ƚ'inqekutaaxkii?— ");
INSERT INTO mca_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","In t'ilitji'ju'kii ke' witinhitjii, ma' qa qeesik'ui ka' t'unik'i. ");
INSERT INTO mca_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma' qa hekhewe' i'nji' ke' witinhitjii qa wonokok'enijupju'kii ha' Jesús qa yit'ijets: —¡Qete'e' yijaa'ija in akha' pa' Ƚaa'sija pa' Dios!— ");
INSERT INTO mca_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Qa yamiiteje'm ha' ƚajaika', qa t'ilit'ipha'mkii ha' sehe' Genesaret. ");
INSERT INTO mca_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","He' tetseti'yi' qa nikfe'lij ha' Jesús ma' qa aje'eƚ yamipji' ƚeniihe't week ha' sehe' qa tetka'xiikii he' wanqaats'eju'. ");
INSERT INTO mca_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Qa iyinijets qu' niwejinƚi'ij qu' net'eku'metskii ha' ƚ'aka'the' eiju' ha' ƚ'uihitjii he' wanqaats'eju'. Qa week he' hats t'eku'mets qa naxpa'lij pe' ƚaatsheitax. ");
INSERT INTO mca_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ma' qa nekets ha' Jesús he' uja'x fariseol qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei ta'ƚii ha' Jerusalén qa nifaakan qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Inhats'ek ne' ijatshenhei in nite' tek'enik'i kekhewe' yittaxij inwets pe' inaqwa'mhitsik'i qu' jintaqsiijkii? Enewe'en nite' wa'nqa' eku'nju' qa tekji'ijju'.— ");
INSERT INTO mca_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Qa nifaakanijek ha' Jesús qa yit'ij: —¿Inhats'ekek ekheweli'ƚ in nite' ƚ'ek'eni'ƚik'i ka' yit'ij na' Dios qa e'mehe'eƚij in ƚ'ek'eni'ƚik'i ke' ƚe'lijeiƚe ke' ƚawa'mhitsik'i? ");
INSERT INTO mca_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Qe na' Dios yit'ij: “Ek'eenetsha qa iwqinhet iye atata qa eneneye' iye” qa “pa'qu' nit'ijets uƚ'ets ƚe'lijei pa'qu' ƚatataye' qa ƚenene iye qa' hikpa' qa' hats jutsiqaxe' qu' nawa'm.” ");
INSERT INTO mca_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Qa ekhewelƚi'iƚ qa ƚit'iƚijets pa'qu' jukhewe' in ƚeke' qu' nit'ijets pa'qu' ƚatataye' qa ƚenene iye: “Nite' ƚeke' qu' he'yifti'ts ewets qe week ke' na'lji'ijtax ye'm qa hetisji'jij pa' Dios.” ");
INSERT INTO mca_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pakha' qu' nit'ij aka'an ma' qa hats nite' yiwqinhet pa'qu' ƚatataye' qa ƚeneneye' iye. Ekheweli'ƚ ƚiwu'miƚfik'i qa ƚili'iƚij iye ka' yittaxijha na' Dios, ma' qa ƚijayani'ƚ hane'ej pe' e'lijeiƚi'iƚ. ");
INSERT INTO mca_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ekheweli'ƚ e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e pe'qu' ejusitsi'iƚ! Yasinik'iha ka' yit'iƚij ewets ka' profeta'ik'i Isaías in yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ha'ne witset ƚe'lijeiƚe tsiwqinhettax qa nekhewe'ƚe ƚatawjets qa tots ye'miiha. ");
INSERT INTO mca_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nite' weju'ƚij in tsijayantax, ke' i'nq'ijatshenij ƚe'lijeiƚe ene' jukhewƚe.”— ");
INSERT INTO mca_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma' qa ha' Jesús qa taya'yets he' week jukhew qa efuts iye qa yit'ijets: —Ek'eni'ƚha qa' menikfelitiƚik'iha iye. ");
INSERT INTO mca_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na'aj timju' na'aj jukhew qa efu iye nite' hik ha'ne qu' niwuƚ'enhet, qe pa' yiwuƚ'enhet yijat'ij pa'qu' jukhewe' qa efu iye, ta'ƚii ƚeji'.— ");
INSERT INTO mca_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ma' qa he' ƚ'ijatshenhei qa we'tmetinheti'm qa yit'ijets: —¿Me nite' ƚenikfe'lets nekhewe' fariseol in nayu'kii in nepi'ye'ej kakha' ƚit'ij?— ");
INSERT INTO mca_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Qa yeku'ƚ ha' Jesús qa yit'ij: —Week pe'qu' wit'enkiye'ju' in nite' yenju' na' Tata i'ni' na' wa's, qa' netenit'ijpha'm weekij ƚefitetsii. ");
INSERT INTO mca_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iwejinƚi'iƚ nekhewe'en ek'enƚi'iƚets, qe nekhewe'en puk'alets yojo'ok'oi pekhewep iye puk'alets. Qu' puk'ale' pa'qu' nojo'ok'oi pakhape' iye puk'al, ma' qa' week nanamik'iju'kii pe'qu' koomojiju'ye'.— ");
INSERT INTO mca_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ha' Pedro qa yit'ijets ha' Jesús: —Etsfeliƚi'mha pa' ikji'ha kakha' ƚejeyumtshenijupi'.— ");
INSERT INTO mca_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Qa yeku'ƚ ha' Jesús: —¿Me ekhewepi'ƚ iye qu' mexe nite' enikfe'li'iƚik'i? ");
INSERT INTO mca_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Me nite' ƚenikfe'li'ƚik'i in week na'aj uyii pa'qu' witeji'ye' qa yamiiju' ƚekutjii ma' qa i'nk'aƚe qa ikfik'i iye? ");
INSERT INTO mca_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Qa pakha'ƚe t'atsji'ƚii witeji' qa ta'ƚiiju' wittawe'j, qa hik ha'ne yijat'ij in yiwuƚ'enhet pa'qu' jukhewe'. ");
INSERT INTO mca_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Qe wittawe'j ta'ƚiiju' ekewe'en: uƚ'ets witaqjamtikineyejeikii, teqek'ui, wanawitji'iƚ pakhape' i'nƚi'i pekhepe' in hats tewhe'yeitax, wanawitjiƚi'iƚ pakhape' i'nƚi'i pekhepe' in mexe hamtax ƚewhe'ye'ye', t'ejtenkii, ejtitsits wotk'onƚi'imkii pe'qu' netnek'enhei qa wotk'onƚi'ijkii iye pa'qu' hamtax ƚeq'inye'je'. ");
INSERT INTO mca_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ekewe' wekwek hik ekewe' yijat'ij in yiwuƚ'enhet pa'qu' jukhewe' qa efu iye. Qa qu' jintekƚe in mente' jiwanqa'tax qa nite' jiyiwuƚ'enhet.— ");
INSERT INTO mca_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ma' qa ha' Jesús qa ikik'ui iye ha' i'ntaxi' qa yamii hakha' sehe' te'weyij he' witsetits Tiro qa ha' Sidón. ");
INSERT INTO mca_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ewi'ƚ ke' efu canaán ƚeiƚeki' i'ni'kii hakha' sehe' qa nekets ha' Jesús yit'unhetik'i in iyet qa yit'ij: —Yatsat'axyij, Ƚa's pa' David'ik'i, enq'eletyij wat'ij. Ke' yasi' i'nji' pa' ewi'ƚ inwo'met qi in yawtsheten.— ");
INSERT INTO mca_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Qa nite' yeku'ƚ ha' Jesús. Qa he' ƚ'ijatshenhei qa nekets qa yit'ijets: —Iyaji'ets ne' efu qu' nak. Jiyijayanijpha'mkii in iyet. Nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús qa yit'ij: —Na' Dios ts'ukinijetsju' qu' howo'oikii hekhewe' hamitstaxiikii kots'etets Israel ƚeiƚets.— ");
INSERT INTO mca_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Qa ke' efu qa wonokok'eni'ju' ƚ'ejuyi'jii ha' Jesús, qa yit'ijets: —Yatsat'axyij, ifti'ts qeku'n yiwets wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Qa ha' Jesús qa yeku'ƚ: —Nite' ƚe'wisijupi' qu' netitkamhiti'yij na' pan enewe' omehets ma' qa' netesti'yij ne' nunajits ƚelits.— ");
INSERT INTO mca_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Qa ke' efu qa inku'ƚ qa yit'ij: —Ehe, Yatsat'axyij, qa tujƚe iye ene' nunajits ƚelits ne'ej ƚaqamhiliiju' na'aj ƚenilayets namifikii na'aj mesa.— ");
INSERT INTO mca_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma' qa yit'ij ha' Jesús: —Efu, hayits qa qi in nite' ƚesqeku'. Hane'ej qa' ƚunye'je' pakha' hats ƚisu'un qu' ƚunye'je'.— Qa hik akaa'ijha pa'aj qa ƚe'wisju' pe' ƚasi'. ");
INSERT INTO mca_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ma' qa ha' Jesús qa ikik'ui hakha' i'ntaxi' qa yamiiju' ha' ƚotkoyek ke' kaƚi' Galilea. Ma' qa' ikik'ipha'm ke' utek qa i'niju'. ");
INSERT INTO mca_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Olootsija he' jukhew qa efuts iye nekii ha' i'ni'. Neka'xii he' uƚ'ets ƚewek f'oyoq f'oyoq, qa he' onqokits, qa he' puk'alets, qa he' ham ƚe'lijeye', qa olots iye hekhewep iye wanqaats'eju', we'nenifikii ha' Jesús ma' qa week niƚinju'. ");
INSERT INTO mca_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma' qa hik ta'ƚijupi' in qi in yitjuƚaxijpha'mkii he' jukhew qa efuts iye in yi'wen in iyet he' hamtax ƚe'lijeye', qa otshimetsitsju' iye he' f'oyoq f'oyoqtax, qa he' onqokitstax qa hats t'otsjo' iye, he' puk'alets qa yi'wenkii iye. Ma' qa hik ta'ƚijupi' qa yit'ijets: —¡Maa! hayits qa ƚe'wisija pa' Israel ƚeqe Dios.— ");
INSERT INTO mca_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ha' Jesús qa taya'yets he' ƚ'ijatshenhei qa yit'ijets: —Hats tseq'eletij enewe' jukhew qa efuts iye qe hats wetshetk'ewi'ƚ ke' neƚuts in i'nyijup qa hats ham ƚaqe'. Nite' hisu'un qu' hipilheninkii in mexe ham pa'qu' netuj qe i'nƚi'i qu' nanajkat'axijju' ƚeyipkul na' wit'ikheyi'jik'i.— ");
INSERT INTO mca_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Qa yit'ijiju'ƚ he' ƚ'ijatshenhei: —¿Qa pa'n qu' jintaƚi'iji' pa'qu' netuj enewe'en in olots wikfi' in hami' hane'e'in pa'qu' nata'ƚets pa'qu' ƚaqe' qe ham i'ni'i'?— ");
INSERT INTO mca_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Qa nifaakan ha' Jesús: —¿Pa'n uja'x pe' aqatsi'ƚ pan?— Hekhewe'en qa yit'ijiju'ƚ: —Wetsjuk tatsaiƚe (7) ne' pan qa uja'x ne' sehets ƚelits iye.— ");
INSERT INTO mca_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma' qa inaqyaji'ij ha' Jesús qu' week na'ni'ju'kii ha' sehe'. ");
INSERT INTO mca_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Qa t'eku'mi' ke' siete (7) pan qa ke' sehets ƚelits iye qa yit'ijetspha'm ƚe'wisij pa' Dios. Qa napk'asitju' qa netisijju' he' ƚ'ijatshenhei qa hik hekhewe' qa netisijju' hekhewe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Week he' tuj, qa iƚinijju'. Qa he' ƚ'ijatshenhei qa nat'a'ak'i ke' ƚapk'asil ke' amaneifik'i qa yenji'ju'kii he' wetsjuk tatsai (7) qits canastul qa topolij. ");
INSERT INTO mca_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hekhewe' tuj ke' pan yamets ikwetju'ƚ mil (4.000) he' jukhew, hekhewe'ƚe efuts qa nite' wetjeyumtshen, qa he' omehets iye. ");
INSERT INTO mca_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma' qa in hats wetfeli'm ha' Jesús hekhewe' jukhew, qa t'ilitji'ju'kii iye ke' witinhitjii qa ikkii iye qa yamii ha' sehe' Magadán. ");
INSERT INTO mca_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hekhewe' fariseol qa he' saduceol iye qa namii ha' Jesús qu' nijaajin, qa iyintaxijets qu' nethinij pa'qu' pakha' ƚunye'je' na' wa'sji'. ");
INSERT INTO mca_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Qa ha' Jesús qa yeku'ƚ qa yit'ijiju'ƚ: —In metiyu'ju' ne' junu' ekheweli'ƚ ƚit'iƚijets in qi qu' ƚe'wise'kii qe na'l pa'qu' s'eye' na' wa'sji'. ");
INSERT INTO mca_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Qa in leefiju' ekheweli'ƚ qa ƚit'iƚijets qu' uƚ'axekii qe na'l na'aj s'e' qe i'ni' na' wa's qa a'taxiju'ƚ iye. Ehe, ekheweli'ƚ in ƚenikfe'li'ƚets pa' ƚunye'j ha'ne wa'sji' qa ¿inhats'ek in nite' ƚenikfe'li'ƚets ekewe' jutsiqetstaxij ha'ne ƚahats'ij? ");
INSERT INTO mca_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Enewe' hane'ej jukhew qi in uƚ'ets qa nite' ewi'ƚƚi'i' iye nakha' yijayantax iyintaxets qu' net'ethinheti'yij pa'qu' ham ƚunye'ji'iju'ƚ, qa nite'ƚe ƚeke' qu' net'ethinheti'yij pa'qu' ham ƚunye'ji'iju'ƚ. Ewi'ƚƚe hatse' qu' net'ethinheti'yij qu' hik ƚunye'je' ka' ƚunye'jkii ka' profeta'ik'i Jonás.— Ma' qa' ha' Jesús in yili'ij qa' ikik'ui. ");
INSERT INTO mca_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","In yijawe'jiiteje'm iye he' ƚ'ijatshenhei ha' ƚajaika' ke' kaƚi' qa nitapi'ii qu' neka'x ƚaqatse' pane'. ");
INSERT INTO mca_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma' qa yit'ijets ha' Jesús: —Qeku'nek, jeƚi'ƚiju'ƚ ne' ƚeqe levadura nekhewe' fariseol qa nekhewe' iye saduceol.— ");
INSERT INTO mca_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Qa he' ƚ'ijatshenhei qa yifaakateji' aka'an qa yit'ijju': —Ma in nite'ek jiteka'x pane'.— ");
INSERT INTO mca_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Qa ha' Jesús qa hatsƚe nikfe'lets, qa yit'ijji'ju': —Ekheweli'ƚ hayits qa ƚesqeku'uƚ, ¿inhats'ek in ƚit'iƚijets qu' hamitse' ine'm inqatse' pane? ");
INSERT INTO mca_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Me nite' ƚenikfe'lik'i in hentisijju' ke' lee'fij (5) pan he' lee'fij mil (5.000) yamets he' jukhew? ¿Qa pa'n uja'x ke' ƚaqaxpalii topolij he' canastul? ");
INSERT INTO mca_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Me hats ƚantapi'iƚik'i iye in hentisijju' ke' wetsjuk tatsai (7) pan he' ikwetju'ƚ mil (4.000) yamets he' jukhew? ¿Qa pa'n uja'x iye ke' ƚaqaxpalii topolij he' canastul? ");
INSERT INTO mca_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Inhats'ek in nite' ƚenikfe'li'ƚets yakha' in nite' k'iyetij pa'qu' pane', qe k'iyetij yijat'ij qu' jeƚi'ƚiju'ƚ ne' ƚeqe levadura nekhewe' fariseol qa ne' saduceol iye?— ");
INSERT INTO mca_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma' qa nikfe'lik'iha hekhewe'en ha' Jesús in nite' iyetij ne'ej levadura yetsji'ƚ ne'ej pan, qete'e' kekhewe' i'nq'ijatshenij he' fariseol qa he' saduceol iye. ");
INSERT INTO mca_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ha' Jesús in hats yamets ha' sehe' te'weyij ha' witset Cesarea de Filipo, qa nifaakanji'ju' he' ƚ'ijatshenhei: —¿Pa'n ƚ'anyejeyij ene' jukhew ha'ne Ƚa's na' Jukhew?— ");
INSERT INTO mca_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Qa yeku'ƚ he' ƚ'ijatshenhei: —Uja'x he' yit'ijets in akha'te' ka' Juan Bautista'ik'i, qa uja'x he' yit'ijetsek in akha'te' pa' Elias'ik'i, qa hekhewep qa yit'ijetsek in akha'te' pa' Jeremiasik'i qa yumtitax iye pekhewep profeta'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Qa ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —Qa ekheweli'ƚ, ¿ƚekpa' ƚetsumti'iƚiikiyek qu' yakha'ye'?— ");
INSERT INTO mca_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Qa ha' Simón Pedro qa yeku'ƚ qa yit'ijets: —Akha' pa' Cristo, Ƚaa'sija pakha' nite' wa'm Dios.— ");
INSERT INTO mca_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ha' Jesús qa yit'ijets: —Qi qu' e'ƚe'wisi'imkii, Simón, ƚa's ha' Jonás, qe nite' pa'qu' jukhewe'ƚe qu' nethinij in ƚenikfe'lets aka'an, qe ewi'ƚƚe na' Tata i'ni' na' wa's in nethinij qa ƚenikfe'lets aka'an. ");
INSERT INTO mca_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yakha' hit'ij ewets, in akha' e' Pedro, ute ƚasi', qa ene' qi ute qa' hik ene' haqsi'jipji' ne' yi'lijtsitjii. Qi qu' net'un, qa nite' yeqenijanij hatse' na' ƚe'nq'itset'ij ne' naxju' (Hades). ");
INSERT INTO mca_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","K'eƚisij ne' ƚejinjei na' tenek'enheiji' na' Dios. Qa pa'qu' ophe'ƚ ha'ne sehe' ipji' qa' hik ƚunye'je'jeek na' wa'sji' qu' not'opheƚitii, qa pa'qu' iwejin ha'ne sehe' ipji' qa ƚunye'je'jeek qu' netwejinhetii iye na' wa'sji'.— ");
INSERT INTO mca_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma' qa ha' Jesús qa yit'ijets he' ƚ'ijatshenhei qu' hasu'uj nenfel'ekuni'm pe'ye' in ƚakha'ija pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Qa hik aka'aj ha' Jesús qa nifeeli'mha he' ƚ'ijatshenhei in ƚakha' qu' namii hatse' ha' Jerusalén qa he' tenek'enhe'yij ha' witset qa hekhewe' iye tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij iye ke' Moisés ƚe'lijei qu' qi qu' naatsheten hatse'. Qa yit'ijets qu' nilan qa' iƚa'xe'ƚe iye qu' namets wetshetk'ewi'ƚ neƚuts. ");
INSERT INTO mca_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ha' Pedro qa ikijfik'i ha' Jesús qe qa' naq'ayinij aka' yit'ij, ma' qa yit'ijets: —¡Nite' hisu'un qu' ƚexke'yi'ij kakha'an pa' Dios, Yatsat'axyij! ¡Aka'an nite' ƚeke' qu' ejunye'je'kii!— ");
INSERT INTO mca_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Qa ha' Jesús qa tetwek'ela'xets, qa yit'ijets ha' Pedro: —Me'niton ye'mii, Satanás, hik ejunye'j ne'ej ute qu' hilanifi qa' natsamju', qe akha' nite' ƚijamti'ets pa'qu' nisu'un na' Dios, qe uja'xƚe eke' yisu'un ene' jukhewƚe.— ");
INSERT INTO mca_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ma' qa ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —Qu' nana'l pa'qu' nisu'un qu' natsjayanija, qa' nili'ij pa'qu' ƚakhayeƚetax qu' nisu'un, net'eku'mi' yijat'ij pe'qu' ƚeqe cruze' qa' natsjayan. ");
INSERT INTO mca_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Qe pa'qu' nisu'un pa' witiƚa'x ha'ne sehe' ipji', qa qu' nawa'm qa' hami'im hatse'. Qa pakha'ƚe qu' nite' nana'yi'ij pa' witiƚa'x ha'ne sehe' ipji' qe ta'ƚ yiwets, qa qu' nawa'm qa' nana'li'm pa' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Qe, ¿ƚek pakha' qu' ne'weju'ƚij pa'qu' jukhewe' qu' natsat'axtaxij ha'ne week sehe' ipji' qa ham ƚi'im na' witiƚa'x na' wa'sji'? ¿Qa ƚekpa' iye qu' niƚeyijkitiju'ƚ pa'qu' jukhewe' qu' nataqha'yets pa'qu' ƚiƚa'xe' na' wa'sji'? ");
INSERT INTO mca_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Qe ha'ne Ƚa's na' Jukhew te'nilit'ijju' hatse' na' qi ƚesa'x na' Ƚatata qa ne' ƚaqa angelits iye. Ma' qa' ha'ne Ƚa's na' Jukhew qa' nijaninij week ewiƚei in ƚunyejeyek pe'qu' naqsiijkii. ");
INSERT INTO mca_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yijaa'ija aka' hit'iƚij ewets, enewe' uja'x hane'e'in mente' naxju' hatse' qa' ni'wen ha'ne Ƚa's na' Jukhew namijju' qu' netnek'enhei.— ");
INSERT INTO mca_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","In naxijik'i ke' ewi'ƚ tatsai (6) neƚutsik'i ha' Jesús qa ikijfik'i ha' Pedro qa ha' Jacobo (Santiago) qa hakha' iye ƚejefeƚe ha' Jacobo, Juan. Qa uja'xƚi'iƚkii in iki'ƚik'ipha'm ke' qipha'm utek. ");
INSERT INTO mca_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Qa hik hakha'a' pa'aj qa we'nethinets ha' Jesús in tanalit pa' ƚunye'j. Ma' qa pa' ƚeju's leppepep hik ƚunye'j ne' junu' qa pe' ƚeqhinatai qa tujji'ha in foo'ija. ");
INSERT INTO mca_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Qa laxa iye pa'aj pa' Moises'ik'i qa pa' Elias'ik'i tafaakate'yi'ƚju' pa'aj ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ha' Pedro qa yit'ijets pa'aj ha' Jesús: —Yatsat'axyij, hayits qa ƚe'wisi' ha'ne ju'uni'. Qu' isu'un qa haqsiiƚijkii wetshetk'ewi'ƚe' wititsil ƚelitse', ewi'ƚ pe'qu' etsi'yi'ij qa ewi'ƚ pe'qu' Moisés ƚetsi'yi'ijek qa pekhep iye qa' ƚetsi'yi'ijek na' Elías.— ");
INSERT INTO mca_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","In mexe iyet pa'aj ha' Pedro qa nametsju' pa'aj pe' tujji'ha wasi' qa tit'oyijju' pa'aj qa hikpe' nokes ji'teje'm pa' iyet qa yit'ij pa'aj: —Hane'en hik ha'ne Ya's qi in hisu'un, hik ha'ne qi in tsi'sinheti'mkii. Qa hik ha'ne ek'eni'ƚik'iha pa'qu' nit'ij.— ");
INSERT INTO mca_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","In yepi'ye' ek'i pa'aj aka'an he' ƚ'ijatshenhei qa namju'kii, weniipinju'kii pa'aj qa qi in nijiwei. ");
INSERT INTO mca_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ha' Jesús qa ikets pa'aj qa t'eku'metsju'kii qa yit'ijets pa'aj: —Eniyi'ƚpha'mkii. Hasu'uj e'nijiwe'yi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Qa yejeƚtaxik'ipha'm pa'aj qa hats hamits pekhewep hats ewi'ƚƚekii pa'aj ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","In tepilik'uiju'kii iye ke' utek, ha' Jesús qa yiyaji'ijets pa'aj qu' hasu'uj nenfel, qa yit'ijets: —Hasu'uj enfeli'ƚi'm pe'ye' aka' ƚi'weni'ƚ. Hatse'ƚu' qu' iƚa'xe'tax iye ha'ne Ƚa's na' Jukhew qa' enfeli'ƚkii yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma' qa he' ƚ'ijatshenhei qa nifaakanij ha' Jesús qa yit'ijets: —¿Inhats'ek ne' i'nq'ijatshenij ke' Moisés ƚe'lijei in yit'ijets qu' nonjo qu' nanam pa' Elias'ik'i qa ink'aye'ƚe pa' Cristo?— ");
INSERT INTO mca_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ha' Jesús qa yeku'ƚ: —Yijaa'ija qu' nanam hatse' pa' Elías, qa' hikpa' week naqsi'jju' hatse' ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Qa yakha'ƚe qa hit'iƚij ewets ka' Elías in hats namtax qa nite'ƚe nikfe'lij, qe ƚeqfenyejeyij yijat'ij kakha' ƚekhewelƚe in yisu'un qu' ƚeqfenyejeyi'ij. Qa hik qu' ƚeqfenyejeyi'ij iye hatse' ha'ne Ƚa's na' Jukhew qu' naatsheten iye nekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ma' qa he' ƚ'ijatshenhei qa nikfe'lik'i in kakha'ƚe Juan Bautista'ik'i in iyetij. ");
INSERT INTO mca_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","In yamii iye ha' i'ni' he' olots jukhew qa efuts iye, ma' qa nekets ha' ewi'ƚ jukhew qa wonokok'enijupju' qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Yatsat'axyij, enq'eletij wat'ij ha' ya's, qe qi qa iftsaxji'ijji' qa nekji'jets pa' ƚaja'me't, ma' qa yik'elelinhetji'ijkii qa hats qi in wanqaats'e', qe olotsij in namijji'ju' na'aj fe't qa olotsij iye in namijji'ju' na'aj iweli'. ");
INSERT INTO mca_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Hats henka'xtaxets ene' ijatshenhei qa nite'ƚe ƚeke' qu' niƚin.— ");
INSERT INTO mca_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ha' Jesús qa yeku'ƚ qa' yit'ij: —Peijaat'ij, enewe' hane'ej namji'ju' ha'ne ƚahats'ij hayits qa qi in inqeku' qa uƚ'ets iye. ¿Pa'n ipƚu'uk'ui qu' mexe ha'ni'ƚ etji'teje'mkii? ¿Pa'n ƚahats'ij qu' mexe ye'weju'ƚi'iƚ eju'ƚ? Enka'xi'ƚ met hane'e'in pa' omeƚa's.— ");
INSERT INTO mca_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ha' Jesús qa yaq'ayinij qa pa' inwo'met qa ikik'uifik'i hakha'an. Ma' qa hik akaa'ijha ha' omeƚa's qa hamiikii pa' ƚunye'jtax. ");
INSERT INTO mca_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma' qa he' ƚ'ijatshenhei qa uja'xƚi'iƚkii in tafaakate'yi'ƚ ha' Jesús, qa nifaakanij: —¿Inhats'ek yekheweli'ƚ in nite' ƚeke' qu' hiwutsheni'ƚfik'i pa' inwo'met?— ");
INSERT INTO mca_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ha' Jesús qa yit'ijiju'ƚ: —Qe ƚammi'sƚe in nite' ƚ'inqekutaxi'ƚ, qe yijaa'ija aka' qu' hit'iƚij ewets, qu' hik ƚuk'eye' ne'ej mostaza ƚo' pa'qu' nite' eqekuyejeyi'iƚ qekha ƚeke'ye'tax qu' it'iƚijets ene' utek: “Ijayik'ui ha'ne ƚa'ni' qa' tujtseika'ye' pa'qu' ni'i'.” Ene' utek qekha net'ijaitax. Hamtax pa' qek nite' ƚeke'ye'tax qu' aqsiiƚijkii. ");
INSERT INTO mca_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aka'an in ƚunye'j pa'qu' inwo'met'e nite' ikfik'i, qe ewi'ƚƚe yijat'ij qu' nukinfik'i pa'qu' niyiinija qa nite' tek iye.— ");
INSERT INTO mca_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","In mexe i'ni' wete'm ha' Galilea ƚeqe sehe', ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —Ha'ne Ƚa's na' Jukhew testi'yij hatse' nekhewe' jukhew. ");
INSERT INTO mca_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ma' qa' nilan, qa qu' namets wetshetk'ewi'ƚ neƚuts qa iƚa'xe' iye.— Hekhewe'en qa qi in ika'metetskii in yepi'ye' ej aka'an. ");
INSERT INTO mca_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ha' Jesús qa he' ƚ'ijatshenhei in yamets ha' witset Capernaum qa hekhewe' yijanin wo'oi ƚ'astai qu' net'ejuyets ke' witlijtsitjii qa nekii ha' Pedro qa nifaakan: —Na' aqa maestro'oƚ ¿me nite' yijaninji'ij ke' qi witlijtsitjii?— ");
INSERT INTO mca_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Qa yeku'ƚ ha' Pedro: —Hats yijaninji'ij.— Ma' qa in uyifi ke' wititsi' ha' Pedro, qa ha' Jesús qa aje'eƚ nojo'ojpha'm in nifaakanij aka'an ha' Pedro in mexe ham yit'etaxij, qa yit'ijets: —¿Pa'n ƚumti'ek Simón qu' ƚunye'je' aka'an? Week pekhewe' tenek'enhe'yipji' ha'ne sehe', ¿pa'n ƚii pe' iyinijets qu' nijaninji'ij pe' wekwek? ¿Me pekhewe' ƚelitsƚe? ¿Me i'nƚi'i pekhewe' tujtseikal?— ");
INSERT INTO mca_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Qa yeku'ƚ ha' Pedro: —Pekhewe' tujtseikal.— Ha' Jesús qa yit'ijets: —Ye'ehe, qa pe' ƚelits qa' hik pekhewe' qu' nite' nijanine'. ");
INSERT INTO mca_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Qa qu' hasu'uj na'nayu' ine'm pe'ye', ma'aiju' ne' kaƚi' qa' aqaqanhen, qa pa'qu' nojo qu' aqaqanhene'ye' qa' hikpa' i'wenji' ƚeji' pe'qu' ƚ'astaki'ye' qa hik pekhe'ye' qa' hijaninij qa' akhap iye qu' ijaninij iye. Qa' eka'xii qa' ƚisij.— ");
INSERT INTO mca_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Qa hik pakha'aj he' ƚ'ijatshenhei qa nekets ha' Jesús, qa nifaakan: —¿Ƚek pakha' les qu' qiye'ji' hatse' pa' tenek'enheiji' pa' Dios?— ");
INSERT INTO mca_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ha' Jesús qa taya'yii ha' ewi'ƚ omeƚa's. Ma' qa yinhinji'ju ƚeqewuk'u, ");
INSERT INTO mca_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","qa yit'ijji'ju': —Yijaa'ija aka' hit'iƚij ewets, ekheweli'ƚ qu' nite' meni'nk'aihiti'iƚ qa qu' nite' ejunyejeyi'iƚ ne'ej omehets, qa' nite' niyi'iƚ ji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Qa hik ta'ƚijupi', pa'qu' ƚunye'je' in nite' weniwqinhet in ƚunye'jek ha'ne omeƚa's, qa' hik pakha'ye' qu' les qiye'ji' in i'nji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Qa pa'qu' neneqjunu'uj pa'qu' ewi'ƚ omeƚa'se' hik ƚunye'j hane'en qu' nata'ƚets ka' yii, qa yakha'ƚe in neqjunu'yij. ");
INSERT INTO mca_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Qa pakha'ƚe qu' naqsijkinenijkii pa' uƚ'ax enewe' tek'en yiwets mente' qits, qa les ƚe'wis qu' not'opheƚiti'yijifi ƚaqawe'j ewi'ƚ qi ute qa' netwumhitiiji'ju' pa'qu' qi lejtaxe'. ");
INSERT INTO mca_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Peijaat'ij hatse' ha'ne sehe' ipji' qe ta'ƚets pekhewe' yatsat'etsipji' hane'en in inqaqsijkinenijkii pa' uƚ'ax! Qe ham niyejini'ik'ui qu' ƚunye'je'kii aka'an. ¡Qa hiye' ha'nus pa'qu' jukhewe' i'nƚi'i efu qu' nata'ƚets in yaqsijinenijkii pa' uƚ'ax pakhape' iye! ");
INSERT INTO mca_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Qa qu' nakha'ye' okoi, i'nƚi'i qu' nakha'ye' ef'i' qu' nata'ƚets in ƚaqsiijkii pa' uƚ'ax, qa' isa'xii qa' iton e'mii pa'qu' iwu'mji'. Les qu' ƚe'wise' qu' ewi'ƚe'ƚe okoi i'nƚi'i qu' ewi'ƚe'ƚe ef'iye' qu' niji'teje'm na' witiƚa'x, qa nite' hik ƚunye'j qu' ewumhitiiji'ju' pa' fe't nite' yili'ij qu' weeke' wetets ne' okoyei i'nƚi'i ne' ef'iyei. ");
INSERT INTO mca_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Qa qu' nekhe'ye' oto' qu' naqsijinenijkii pa' uƚ'ax, qa' enit'ijpha'm qa' iton e'mii pa'qu' iwu'mji'. Les qu' ƚe'wise' qu' ewi'ƚe'ƚe otoye' qu' niji'teje'm na' witiƚa'x, qa nite' hik ƚunye'j qu' ewumhitiiji'ju' pa' fe't nite' yili'ij qu' weeke' wetets ne' otoi.— ");
INSERT INTO mca_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Hasu'uj uteni'ƚ pa'qu' ewi'ƚe' enewe' mente' qits, qe yakha' hit'iƚij ewets in na'l nekhewe' ƚaqa angelits enewe'en i'nji' ene' wasits, qa nekhewe'en qa week ƚahatsiyij ikji'jets na' Tata i'ni' na' wa's. ");
INSERT INTO mca_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Qe ha'ne Ƚa's na' Jukhew nam qe qa' nowo'oikii qu' niƚin pakha' qu' hame'taxiikii.) ");
INSERT INTO mca_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Pa'n ƚumti'iƚ qu' ƚunye'je'? Pa'qu' jukhewe' qu' nana'li'm pe'qu' cien (100) ƚeƚinheye' kots'etets qa ewi'ƚ pe'qu' hami'iikii, ¿me nite' yiwejinƚe eku'ni' pa' tseenepha'm pe' noventa y nueve (99) qa' mexe nowo'oikii pe' kots'etax hamiikii? ");
INSERT INTO mca_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yijaa'ija in ƚe'wisi'mkii in na'l pe' noventa y nueve (99), qa in yi'wen pe' ewi'ƚ hamtaxiikii qa les qi'ija in ƚe'wisi'mkii. ");
INSERT INTO mca_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hik aka' ƚunye'j na' Atata'aƚ i'ni' na' wa's, nite' yisu'un qu' ewi'ƚe' pa'qu' hami'iikii ene' mente' qits.— ");
INSERT INTO mca_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Qa pa'qu' ejefeye' qu' naqsi'j e'mijkii pa' uƚ'ax, ma'ai qa' ujaxeƚi'iƚ wetju'ƚ qu' afaakate'yi'ƚju', qa' enfeeli'mha pa' uƚ'ax yaqsi'j e'mijkii. Qa qu' netk'en'eju'ƚ, ma' qa' e'ƚe'sitsi'iƚ wetju'ƚ iye. ");
INSERT INTO mca_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Qa qu' nite'ƚe netk'eni'ik'i pa'qu' ittaxijets ma' qa' eqe'mets iye ewi'ƚe' i'nƚi'i qu' wetsjuk'e pe'qu' ijts'eyek'i'ii, hats'inha pe'qu' nit'ij qa' week jutsiqetsi'ija qu' nata'ƚets pekhewe' qu' wetsjuk'e i'nƚi'i qu' wetshetk'ewi'ƚe' in ijts'eyek. ");
INSERT INTO mca_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Qa qu' nite' netk'eni'iƚ eju'ƚ iye qa' enfeli'ƚi'm pe' witlijtsitjii. Qa qu' nite' netk'eni' iju'ƚ iye pe' witlijtsitjii, ma' qa' hik eqjunyejeyi'iƚij pekhewe' yeqeku' na' Dios qa pe' yijaninkii wekwek judioltax qu' net'ejuyets pa' witset Roma. ");
INSERT INTO mca_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yijaa'ija aka' hit'iƚij ewets, pa'qu' ophe'ƚi'ƚ ha'ne sehe' ipji', qa' hik ƚunye'je'jeek qu' not'opheƚitii na' wa'sji'pha'm. Qa pa'qu' iwejini'ƚ ha'ne sehe' ipji' qa' ƚunye'je'jeek iye qu' netwejinhetii iye na' wa'sji'pha'm. ");
INSERT INTO mca_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Qa hit'iƚij ewets iye aka'an, qu' wetsjuk'e ekheweli'ƚ pe'qu' net'ekumij wetjuƚha pa'qu' nisu'un qu' niyinets ha'ne sehe' ipji', qa na' Tata i'ni' na' wa's qa' naqsiimijkii. ");
INSERT INTO mca_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Qe pa'qu' na'ni' pe'qu' wetsjuk'e i'nƚi'i qu' wetshetk'ewi'ƚe' qu' nonot'axij wetju'ƚ ka' yii qa yakha' qu' ha'nji'ju' ƚeqewuk'u pekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ma' ha' Pedro qa ikets, qa nifaakan: —Yatsat'axyij, ¿pa'n uja'xij qu' naqsi'j ye'mijkii pa'qu' uƚ'axe' pa'qu' yejefeye' qa yakha' qa' hisu'unji'ij qu' ye'ƚe'sitsi'iƚ wetju'ƚ? ¿Me siete'ej (7)?— ");
INSERT INTO mca_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ha' Jesús qa yit'ijets: —Nite' hit'ij ewets qu' sieteye'ƚi'ij (7), les ƚe'wis yijat'ij qu' hit'ij ewets qu' setentayi'ij (70) qu' sieteyi'ij (7). ");
INSERT INTO mca_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Qa hik ta'ƚijupi', na' tenek'enheiji' na' Dios qu' jintejeyumtshenijupi' in hik ƚunye'j pa'qu' ewi'ƚ qi wittataye' in yisu'un qu' nenikfe'lets pe' ƚ'ekumhifkinel pe' ƚeqejkunenhei. ");
INSERT INTO mca_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","In i'nk'a yejeƚ qa tetka'xii pa' ewi'ƚ olots pe' ƚ'ekumhifkinel olots millonits yamets. ");
INSERT INTO mca_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pakha' witqejkunenek in ham pa'qu' nijaninij pe' ƚ'ekumhifkinel, ma' qa pa' wittata qa inaqyaji'ij qu' ne'tninei qu' hik ƚunye'je' qu' witƚinek'e weeki'ƚ pe' ƚewhe'ye' qa' pe' ƚelits iye, qa week iye pe' na'ltaxi'm in yatsat'etstaxij qa' ƚaja'yi'ij pe' ƚ'ekumhifkinel. ");
INSERT INTO mca_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ma' qa pa' witqejkunenek qa wonokok'enifi pa' ƚaqa patun, qa yit'ijets pa'aj: “Patun, enq'eletyij. Hasu'uj itaqsunijup wat'ij. Week ƚek hijanin hatse'.” ");
INSERT INTO mca_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pa' patun qa qi in neq'eletij qa week yiwu'm pe' ƚ'ekumhifkineltax qa yiwamhitik'i. Ma' qa yuki'nfik'i qa yiwejinƚe. ");
INSERT INTO mca_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","In ikfik'i pa'aj pa' witqejkunenek qa we'tweni'ƚ pa'aj pakhap witqejkunenek iye ƚ'ithayife'ej pa'aj pa' yithayiki. Pakha'an t'eku'mi' pa'aj pe' ƚaq'astai, nite'ƚe olotstax. Qa t'ilit'ets pa'aj qa yeqes'ulkatifi ƚaqawe'j pa'aj qa yit'ijets: “¡Yape atsjanin ke' ƚ'eku'mi' yaq'astaiyik'i!” ");
INSERT INTO mca_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pakha'an qa wonokok'entaxifi qa yittaxijets pa'aj: “Enq'eletyij, hasu'uj itaqsunijup wat'ij. Week ƚek hijanin hatse'.” ");
INSERT INTO mca_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Qa pakha'an qa nite'ƚe neq'eletij qa yeka'xii pe' witq'opheƚitjii qa yuihinifi qa yophe'ƚ pa'aj qa' i'nk'aƚe niwejin qu' week nijanin pe' ƚ'ekumhifkinel. ");
INSERT INTO mca_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","In yi'wenij pekhewep iye witqejkunenhei pakha'an aka' ƚeqfenye'j ƚewek qa qi in yaats'e'ej pa'aj pekhewe'en, ma' qa nifeli'm pakha' ƚaqa patun wete'm pa' ƚeqfenye'j ƚewek pa' ewi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pa' patun qa inq'ukinii qu' netetka'xii qa yit'ijets pa'aj: “Witqejkunenek, akha' qi in uƚ'ax. Yakha' k'ewejinƚe. Hiwu'm ek'ui qa hiwamhitik'i iye ke' ekumhifkinel qe ƚ'iyinij yiwets qu' ne'sq'elet'ej. ");
INSERT INTO mca_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Qa akhaptax iye qek enq'eletij iye na' ithayife in yijunye'jek in tseq'elet ej.” ");
INSERT INTO mca_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pa' patun qi in nayu'um pakha'an qa inaqyaji'ij qu' not'opheƚitii qa' nattanithenhetii iye ipƚu'ui qu' week nijanin pekhewe' ƚ'ekumhifkinel qa' netwejinhetii. ");
INSERT INTO mca_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aka'an hik aka' qu' ƚeqfenyejeyi'iƚ ej na' Tata wa'sji' qu' nite' weeki'ijha pe' atawjetsi'ƚ qu' e'ƚe'sitsi'iƚ wetju'ƚ pa'qu' ejefeyi'iƚ.— ");
INSERT INTO mca_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ha' Jesús in yili'ij in nifel ekewe'en, qa ikik'ui ha' Galilea qa yamii ha' ƚeqe sehe'ek ha' Judea neƚu'uju'ƚ te'weyii ha' ƚajaika' ai ha' haqqi' Jordán. ");
INSERT INTO mca_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma' qa olootsija iye he' yijayaniiteje'm, qa hik hakha'a' qa niƚiniju' he' wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Uja'x he' fariseol qa nekets qu' nijaajin, ma' qa nifaakan: —¿Me ƚenexke'ej pa'qu' jukhewe' qu' neweqle'eƚ pe'qu' ƚewhe'ye'ye' in na'l pa'qu' nata'ƚijupi'?— ");
INSERT INTO mca_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ha' Jesús qa yeku'ƚ: —¿Me nite' ƚejeƚi'ƚ ke' we'nika'ajji', nakha' naqsi'jju' in i'nk'aa'ija ha'ne week yaqsiijkii pa' jukhew qa pe' efu? ");
INSERT INTO mca_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Qa yit'ij iye ke' we'nika'ajji': “Qa hik ta'ƚijupi' pa'qu' jukhewe' qu' nak'esik'ui ƚ'alhei, ma' qa' ewi'ƚ na'ni'ƚi' pe'qu' ƚewhe'ye'ye', qa in wetsjuktax qa hats ewi'ƚƚe pa' wit'ese'n.” ");
INSERT INTO mca_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma' qa hats nite' wetsjuk, hats ewi'ƚ pa' wit'ese'n. Qa hik ta'ƚijupi' hasu'uj pa'qu' nak'esinhetje'm pekhewe' hats ewi'ƚ yeni' pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pekhewe'en qa yit'ijets iye pa'aj: —¿Qa inhats'ek pa' Moises'ik'i in inaqyaji'ij pa'aj pe'qu' efuye' qu' netesti'yij pa'qu' witfaakanek'e t'ejuyets qu' neweqle ma' qa nakik'ui pa'qu' ƚewhe'ye'ye'?— ");
INSERT INTO mca_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Qa yit'ijiju'ƚ ha' Jesús: —Qe t'units pe' atawjetsi'ƚ, ham eq'iltaxitsi'iƚ. Qa ka' Moises'ik'i qa ƚexkeliƚij e'm qu' meweqle'eƚju' pe' ewhe'yetsi'ƚ. Qa nite'ƚe hik aka' qu' ƚunye'je' in yojo. ");
INSERT INTO mca_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yakha'ƚe qa hit'iƚij ewetsek pakha' qu' nili'ij pe'qu' ƚewhe'ye'ye' ma' qa ƚewhe'ye'yi'ij iye pekhepe' efu ma' qa hats yaqsiijkii iye aka' witwuƚ'ax (adulterio). Qa qu' nata'ƚƚe'ets pe'qu' efuye' in wanawitji'iƚ pakhape', ma' qa pa' jukhew qa hats nite' yaqsiijkii aka' witwuƚ'ax (adulterio) qu' ƚewhe'ye'yi'ij pekhepe'.— ");
INSERT INTO mca_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Qa he' ƚ'ijatshenhei qa yit'ijju': —Ye'ehe, qu' hik aka' ƚunye'je' in t'ejuyets na'aj jukhew qa ne'ej ƚewhe'ye', qete'e' les ƚe'wistax pa'qu' jukhewe' qu' hasu'uj netewhe'yei.— ");
INSERT INTO mca_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Qa yeku'ƚ ha' Jesús: —Nite' week qu' ƚeke'ye' qu' net'eku'mi' qu' ƚunyejeye' aka' ƚit'iƚijets. Uja'xƚe pe'qu' netisij na' Dios qa' net'eku'mi' qu' ƚunyejeye' aka'an. ");
INSERT INTO mca_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Qe na'l pe' ta'ƚij ji'teje'm wittawe'j in uƚ'ets pe'qu' ƚeqeƚeye' qa nite' ƚeke' qu' netewhe'yei. Qa na'l iye pe' wetwu'mƚe pe' ƚeqeƚei yiwu'mik'ui ene' jukhew. Qa pekhewepƚe qa ƚekhewelƚe in wanaqsi'jƚetijkii in hik ƚunyejei qu' newetwu'm ƚeqeƚei, qe ta'ƚets pa' tenek'enheiji' pa' Dios. Pakha' qu' ƚeke'ye' qu' net'eku'mi' aka'an, qa' net'eku'mi'.— ");
INSERT INTO mca_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma' qa tetka'xii ha' Jesús he' uja'x omehets qe qa' net'eku'mipji' ƚesinjel qu' niyinipji'. Qa he' ƚ'ijatshenhei qa yaq'ayintaxij hekhewe' neka'x he' omehets. ");
INSERT INTO mca_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma' qa ha' Jesús qa yit'ij: —Enwejini'ƚ met ne' omehets, hasu'uj aq'ayini'ƚij qu' nenek yiwets, qe nekhewe' i'nji'teje'm na' tenek'enheiji' na' Dios hik ƚunyejei nekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma' qa in hats yili'ij in t'eku'mipji'kii ƚesinjel he' omehets, qa ikik'ui iye hakha' i'ntaxi'. ");
INSERT INTO mca_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ewi'ƚ ha' jutjana'x namii ha' Jesús qa nifaakan: —Maestro, ¿pa'n ƚunye'j pa'qu' ƚe'wise' qu' haqsiijkii hats'inha qu' nana'l ye'm pa' witiƚa'x nite' yili'ij?— ");
INSERT INTO mca_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ha' Jesús qa yeku'ƚ: —¿Inhats'ek in ƚatsfaakanij pakha' t'ejuyets pa' ƚe'wis? Ewi'ƚƚe nakha' ƚe'wis. Qa qu' isu'un qu' nana'l e'm na' witiƚa'x qa' ek'enik'iha ke' yit'ij nakha'an tisij ka' Moises'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Qa yit'ij ha' jutjana'x: —¿Qa pa'n ikji' pakha'an kekhewe'en?— Qa ha' Jesús qa yeku'ƚ iye: —Hasu'uj eqek'ui. Hasu'uj ejtenij qu' a'qapi'i pekhepe' iye efuye' qu' hats ewhe'yei. Hasu'uj ejtenkii. Hasu'uj mowotk'onƚi'imkii pa'qu' netnek'enhei. ");
INSERT INTO mca_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Iwqinhetji' qa ek'eenetsha iye pa'qu' atataye' qa enene iye. Isu'un week pa'qu' mete' e'm jukhew qa efuts in ejunye'jek in ƚewetsu'unƚe.— ");
INSERT INTO mca_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Qa ha' jutjana'x qa yit'ij: —Week ekewe'en yakha' qi in heik'enik'i qa haqsiijkii iye. ¿Qa pa'n ƚunye'j pa'qu' mexe hami'ik'ui qu' haqsiijkii?— ");
INSERT INTO mca_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ha' Jesús qa yeku'ƚ: —Qu' isu'un qu' atsathenija, yape ma hane'ej, qa' ihinijkii week pekhewe' na'l e'm. Qa pe'qu' ƚajale' qa' week ƚisij nekhewe' if'iljetsits ham yiwq'axine', qu' hik aka' eqfenye'ji'ij ma' qa' nana'l e'm yijat'ij nekhewe' ƚe'sits t'ejuyets na' wa'sji'. Ma' qa' i'nk'aƚe etpil qa' enek qu' atsjayan.— ");
INSERT INTO mca_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ha' jutjana'x in yepi'ye' ek'i aka'an, qa ik qi in uƚ'axi'mkii, qe ƚakha' qi in yiwq'axin wekwek. ");
INSERT INTO mca_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ha' Jesús qa yit'ijji'ju' he' ƚ'ijatshenhei: —Yijaa'ija aka' hit'iƚij ewets in jutsitaxija pa'qu' qi wekwek niwq'axin qu' nuiji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hit'iƚij ewets iye in les qu' nite' jutsitaxe' pa'qu' ats'etaxe' qu' nuyii ne'ej tawjena'x ƚoto', qa nite' hik ƚunye'j pa'qu' qi qu' niwq'axin wekwek in jutsitaxija qu' nuiji'teje'm na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","In yepi'ye' ej aka'an he' ƚ'ijatshenhei, qa qi in yitjuƚaxijpha'mkii, qa yit'ijju': —Maa, ¿qa pa'n ƚii pa'qu' ƚeke'ye' qu' nuiji'teje'm pa' tenek'enheiji' pa' Dios?— ");
INSERT INTO mca_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Qa ha' Jesús qa yejeƚ ji'teje'm qa yit'ijji'ju': —Ene' jukhewƚe jutsitax qu' naqsi'jƚetaxijkii aka'an. Ewi'ƚƚe pa' Dios in nite' jutsitaxi'm.— ");
INSERT INTO mca_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ha' Pedro qa yit'ij: —Yekheweli'ƚ week henejeti'ƚ he' week yiwekwekitsi'ƚ ma' qa k'ajayani'ƚ. ¿Qa ƚekpa' qu' heyesti'yi'ƚij hatse'?— ");
INSERT INTO mca_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ha' Jesús qa yeku'ƚ: —Yijaa'ija aka' hit'iƚij ewets qu' namtaxets hatse' pa' ƚahats'ij, qa ha'ne Ƚa's na' Jukhew qa' na'nipji' na' qi ƚe'wis ƚots'oji'la'x, ekheweli'ƚ in ƚatsjayani'ƚ qa' ni'iƚipji' ek ne' doce (12) wits'ojilaxits. Qa ekheweli'ƚ qu' enek'enhe'yi'ƚij ene' doce (12) witsetits Israel ƚelits. ");
INSERT INTO mca_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Week pekhewe' qu' nenejet ƚetsil, i'nƚi'i ƚamatsits qa ƚek'injats, i'nƚi'i ƚekutii qa ƚek'injai, i'nƚi'i ƚatata, i'nƚi'i ƚenene, i'nƚi'i ƚelits qa i'nƚi'i ƚeq'ejinqa'wetitse' qe ta'ƚets aka' yii, ma' qa les olotsii'ija pe'qu' netesti'yij qa' netesti'yij iye na' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Qa olotsƚe nekhewe' hane'ej yojo, qa' hik nekhewe'ye' hatse' qu' netke'lenju'. Qa olots iye nekhewe' hane'ej teke'lenju' qa' hik nekhewe'ye' hatse' qu' nojo.— ");
INSERT INTO mca_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ha' Jesús mexente' naq'axijik'i aka' yit'ij, qa yit'ij iye: —Qe na' tenek'enheiji' na' Dios hik ƚunye'j pa'qu' ewi'ƚ jukhewe' yatsat'axij pa'qu' uwakete', qa wekiya'ffik'i in ik qe qa' nakii pe'qu' nithayinenij pa' ƚeqe uwaket. ");
INSERT INTO mca_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Qa mexe tafaakate'yi'ƚijju' pa'qu' ƚaqjanye'ji'ij qu' ewi'ƚ neƚuye', ewi'ƚ denario, qa in hats ƚe'sitsijju' pa' ƚaqjanye'jij ma' qa yukinii pa' uwaket qu' nithayiki. ");
INSERT INTO mca_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ma' qa in hats juufik'ipha'm ne' junu' qa ikfik'i iye pa' yatsat'axij pa' uwaket. Qa yi'wen iye pekhewep ts'ap'a'aju' iye pakha' joofji'ju' ham yithayikiye'. ");
INSERT INTO mca_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Qa yit'ijets: “Ma'aƚii qu' ithayiki'iƚ ha' yeqe uwaket, k'ajametsinƚi'iƚek.” Ma' qa ikkii pekhewe'en qu' net'ithayii. ");
INSERT INTO mca_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pa' yatsat'axij pa' uwaket qa ikfik'i iye in hats natsathenju' junu' qa yi'wen iye pekhewep iye ts'ap'a'aju' iye pakha'a', qa yit'ijets iye: “Ma'aƚii qu' ithayiki'iƚ ha' yeqe uwaket.” Qa ewi'ƚij in ikfik'i iye pa'aj in hats jelji' junu' qa yi'weni' iye pekhewep iye, qa yit'ijets iye: “Ma'aƚii qu' ithayiki'iƚ ha' yeqe uwaket.” ");
INSERT INTO mca_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma' qa in hats metju'ha pa'aj pe' junu' qa ikii iye pa' joofji'ju' qa yi'weni' iye pekhewep iye ts'ap'a'aju' iye pakha' joofji'ju', qa nifaakan: “¿Inhats'ek in miitsju' ƚa'ni'ƚi' hane'e'in nite' ƚ'ithayi'yi'ƚ?” ");
INSERT INTO mca_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Qa yeku'ƚ pa'aj pekhewe'en: “Qe ham pa'qu' nets'ithayineni'ƚ.” Qa yit'ij pakha'an: “Ma'aƚii iye ha' yeqe uwaket qu' ithayiki'iƚ.” ");
INSERT INTO mca_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ma' qa in hats lef'ekii pa'aj, pa' yatsat'axij pa' uwaket qa yiyaji'ets pa' ƚeqjeƚinenek'ipji' pe' t'ithayii: “Onothet wetju'ƚ he' t'ithayii qa' natjai, yojo qu' natjai he' teke'lenijju' in t'ithayii qa he' yojo'oj in t'ithayii qa' netkelenijju' qu' natjai.” ");
INSERT INTO mca_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ma' qa nekets pe' hats metju'ha pa'aj junu' in t'ithayii qa week pekhewe'en in tajai ewi'ƚ denario. ");
INSERT INTO mca_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma' qa in yamets pe' miitsju' t'ithayii qa yumtitax pekhewe'en qu' les qiyi'ija qu' natjai qe miitsju' t'ithayii. Qete'e' hik uja'x iye pe' ƚajal pe' i'nk'aƚe t'ithayiitax ewi'ƚ denario. ");
INSERT INTO mca_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","In yi'wen pe' ƚajaltax pekhewe'en ma' qa qi in uƚ'etsik'i ƚe'lijeyets pa' yatsat'axij pa' uwaket. ");
INSERT INTO mca_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Qa yit'ijju' pa'aj pekhewe'en: “Enewe' i'nk'aƚe t'ithayiitax in hats metju' ke' junu' qa hik aqjanyejeyi'ƚyij yekheweli'ƚ in miitsju' haki'ƚifi in he'yithayi'yi'ƚji' ka' ƚ'elej ke' junu' aka' neƚu'ik'i.” ");
INSERT INTO mca_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Qa yeku'ƚ pa' yatsat'axij pa' uwaket pa' ewi'ƚ pekhewe'en: “Waika', nite' k'awitji'. ¿Me nite' hayiits jitafaakate'yijju' ka' yaqjanyej'ej qu' ewi'ƚ neƚuye' qu' ithayii ewi'ƚ denario? ");
INSERT INTO mca_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ehe, enewe'en aja', yape ma'aj. Qa yakha'ƚe qa hisu'un qu' hetisij qu' hik uja'xe' ke' k'eƚisij ha'ne teke'leenijju' in t'ithayii. ");
INSERT INTO mca_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ye' me nite' ƚenexke'ej pa'qu' hisu'un qu' yeqfenye'ji'ij pe'qu' nastsat'etsƚetaxij? ¿Ye' me natawje'meten in yeq'iltina'x?” ");
INSERT INTO mca_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Qa aka'an hik aka' ƚunye'j pekhewe' hane'ej teke'lenju' qa hik pekhewe' qu' nojo hatse', qa pe' hane'ej yojotax qa' hik pekhewe' qu' netkelenju' hatse'.— ");
INSERT INTO mca_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ha' Jesús in mexe ikik'ipha'm ha' wit'ikheyi'j hikha' teyii ha' Jerusalén, qa taya'yets qu' neqet'etsi'ƚju' he' doce (12) ƚ'ijatshenhei, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ek'en qeku'ni'ƚek qu' k'efeli'ƚi'm, hane'ej in jiyamiipha'm na' witset Jerusalén, qa' hik nakha'yi'i' hatse' ha'ne Ƚa's na' Jukhew qa' netesti'yij ne' tenek'enhe'yij ne' pa'il qa ne' i'nq'ijatshenij ke' Moisés ƚe'lijei qa' ninaqyaji'ij qu' natlanhetii, ");
INSERT INTO mca_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","qa' netisij nekhewe' jukhewiikal nite' judiol qe qa' nawitji'iji' pe'qu' ƚe'lijeye', qa' neqsilanje'mkii iye ma' qa' nenji'pha'm pe'qu' cruze'. Qa qu' namets wetshetk'ewi'ƚ neƚuts qa' iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ke' ƚenene he' ƚelits ha' Zebedeo, qa ƚijts'eyek in nekets ha' Jesús, qa wonokok'enijupju' qe niyinheyu'ujets pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ha' Jesús qa nifaakan: —¿Ƚekpa' ƚisu'un?— Kikhe'en qa yeku'ƚ qa yit'ij: —Inaqyaji'ij hatse' wat'ij qu' enek'enheitax enewe' wetsjuk yilits qu' na'n ejupha, ewi'ƚ pa'qu' netweiji' ƚeniyayik'i qa nakhap qa' efeyi'j ne'tweyijek.— ");
INSERT INTO mca_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ha' Jesús qa yit'ijiju'ƚ hekhewe'en: —Nite' ƚenikfe'li'ƚets aka' ƚ'iyintaxi'ƚets. Pakha' haats'e'ej hatse' qi qu' a'taxe' hik ƚunye'j qu' nek'iyaji' pa'qu' ek'imiye'ji', ¿me ƚeke' qu' iya'aƚji' pakha' ek'imiiji' k'iya'ji' hatse'?— Qa yit'ijju' hekhewe'en: —Ehe, ƚeke'.— ");
INSERT INTO mca_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Qa yeku'ƚ iye ha' Jesús: —Yijaa'ija qu' iya'aƚji' hatse' pa' qi ek'imiiji', qa pakha'ƚe qu' na'ni'ju' ha'ne ts'iyayik'i qa ha'ne yifeyi'j qa nite' yakha' qu' nata'ƚ yiwets qu' hetisij. Uja'xƚe hatse' qu' netesti'yij pekhewe' hats yaji'let qu' netisij na' Tata.— ");
INSERT INTO mca_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Qa hekhewe' diez (10) ƚ'ijatshenhei in yepi'ye' ek'i aka'an, ma' qa nayu'um he' wetsjuk witjefeye'k ƚelits ha' Zebedeo. ");
INSERT INTO mca_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Qa ha' Jesús qa taya'yets week hekhewe'en qa yit'ijji'ju': —Ekheweli'ƚ ƚenikfe'li'ƚets nekhewe' tenek'enhe'yipji' ne' nite' judiol in ewi'ƚƚe in yisu'un qu' nenethinijkii pe' ƚet'unhaxits in tenek'enhei. Qa nekhewe' te'weyik'uiju' nekhewe'en qa yisu'unek in inaqyaji'ij pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Qa ekhewelƚi'iƚ qa' hasu'uj ejunyejeyi'iƚ aka'an, qe pakha' qu' nisu'un qu' neniwqinhetji' qa' les ƚe'wis qu' hik ƚunye'je' qu' witqejkunenek'e qu' nithayiki pekhewepe'. ");
INSERT INTO mca_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Qa ekheweli'ƚ pakha' qu' nisu'un qu' nojo qa' les ƚe'wis qu' hik ƚunye'je' qu' witƚinek'e qu' eqejkunenek'i'iƚij. ");
INSERT INTO mca_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Qe ha'ne iye Ƚa's na' Jukhew nite' nam ma' qa' neteniftitshiyets, qe nam yijat'ij qe qa' net'iftits qa net'ihinij iye na' ƚiƚa'x, hats'inha qu' nilithinik'ui pa' witaxtanithenkeye'j pe'qu' olotse'.— ");
INSERT INTO mca_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","In hats ikik'ui iye ha' witset Jericó, qa olotsija iye he' yijayanpha'm. ");
INSERT INTO mca_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wetsjuk he' puk'alets i'niju'kii ƚekuwe' ha' wit'ikheyi'j. Hekhewe'en in yepi'ye' in nekijup ha' Jesús, qa taya'yik'ikii: —Yatsat'axyij, David Ƚa's, e'nq'elet qeku'ni'ƚyij wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Olots he' yaq'ayintaxij in tayaikii. Qa yape'enhaƚe les in yit'unhetik'ikii in taya'yik'ikii: —Yatsat'axyij, David Ƚa's, e'nq'elet qeku'ni'ƚyij wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ha' Jesús qa teke'lenju' qa taya'yii he' puk'alets, qa nifaakan: —¿Ƚekpa' ƚisu'uni'ƚ qu' haqsi'ji'ƚ e'mijkii?— ");
INSERT INTO mca_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Qa yeku'ƚ hekhewe'en: —Yatsat'axyij, hisu'untaxi'ƚ qu' hi'weni'ƚkii wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ha' Jesús qi in neq'eletij hekhewe'en qa t'eku'mipji' he' ƚotoi. Ma' qa aje'eƚ yi'wen wetju'ƚ he' puk'aletstax, qa yijayanpha'm ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","In hats metitsi'm ha' Jerusalén, hats yamets ha' witset ƚa's ƚii Betfagé, qa ke' utek ƚii Olivos. Ha' Jesús qa yukin he' wetsjuk ƚ'ijatshenhei, ");
INSERT INTO mca_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","qa yit'ijets: —Ma'aƚetsteje'm na' witset ƚa's. Qa' hikna' i'weni'ƚi' pe'qu' matikkatekiye' wo'nophe'ƚ qa ewi'ƚ wo'nopheƚiƚiju' pa'qu' ƚa'se'. Qa' enit'iƚijii pe' wetsjuk qa enka'xi'ƚyii. ");
INSERT INTO mca_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Qa qu' nana'l pa'qu' nayajitaxiƚijets, qa' it'iƚijiju'ƚ: “Ha' Yatsat'axi'ƚyij yisu'un. Aje'eƚƚete' ek nepilet hatse'.”— ");
INSERT INTO mca_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aka'an in ƚunye'j ma' qa hats yasiinik'iha pa' nifel pa'aj pa' profeta in yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Enfeli'ƚi'm na' witset Sión, qa' it'iƚijets: “Jeƚju', hats nam ei ha'ne qiji' wittata. Nite' weniwqinhetji', i'nipji' na' ewi'ƚ matikkatax, ewi'ƚ matikkatax ƚa's.”— ");
INSERT INTO mca_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","He' wetsjuk ƚ'ijatshenhei qa ikkii qa yaqsiijkii ka' hats yit'ijets ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Qa neka'x ke' matikkateki' qa ha' ƚa's iye, qa yipk'eni'pji' he' ƚe'ntaafitits ƚaqlatiyij, qa i'nipji' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Olootsija he' jukhew qa efuts iye, yipk'enik'uijiju'kii ha' wit'ikheyi'j ke' ƚe'ntaafitits qa hekhewep qa yifekinik'i ek ke' najkakui ƚesejets qa yenik'uiji' ha' wit'ikheyi'j. ");
INSERT INTO mca_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","He' yojo'ok'oi ha' Jesús qa he' teke'lenijupju' iye qa week ewi'ƚ ka' ƚ'anyejei in taya'yijipji'kii: —¡Qi in ƚe'wis ha'ne Ƚa's pa' David'ik'i! ¡Qi in ƚe'wis ha'ne namij ka' ƚii pa' Yatsat'ax'inij! ¡Qi in ƚe'wis pa' Intata wa'sji'!— ");
INSERT INTO mca_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ha' Jesús in hats yamji'teje'mha ha' Jerusalén, qa week ha' witset in yeƚ'ilax wetju'ƚ qa yit'ijju': —¿Pa'n ƚunye'j ha'ne nam inwets?— ");
INSERT INTO mca_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Qa yeku'ƚji'ij hekhewe' yojo'ok'oi: —Hik ha'ne Jesús, profeta, ta'ƚii na' witset Nazaret Galilea ƚeqe sehe'.— ");
INSERT INTO mca_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ha' Jesús qa uyifi ke' qi witlijtsitjii qa yiwutshenfik'ikii week hekhewe' taqha'yets qa he' t'ihinij iye ke' wekwek. Qa yiwu'mkii iye ke' ƚeqe mesal he' yepiletets ƚ'astai qa yiwu'mkii iye ke' ƚots'oji'laxits he' ofol t'ihinij. ");
INSERT INTO mca_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Qa yit'ijets: —Ke' we'nika'ajji' yit'ij: “Ene' yitsi' qu' ƚenqiyi'ij wit'iyinhetjii,” qa ekhewelƚi'iƚ qa ƚaqsiiƚijkii in “ƚewejij ne' ejtenhetsits.”— ");
INSERT INTO mca_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","He' puk'alets qa he' onqokits qa he' otshimetetsju' iye qa nekets ha' Jesús ke' witlijtsitjiyifi, qa niƚinju'. ");
INSERT INTO mca_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Qa he' tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij iye ke' Moisés ƚe'lijei in yi'wenij ke' yaqsiijkii in ham ƚunyejeyi'iju'ƚ qa in yepi'ye' iye he' omehets in taya'yijipji'kii ke' witlijtsitjiiyifi in yit'ijju': —Qi in ƚe'wis ha'ne Ƚa's pa' David'ik'i,— ma' qa qi in nayutaxkii hekhewe'en, ");
INSERT INTO mca_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","qa yiyajitaxets ha' Jesús: —¿Me nite' ƚepiye' enewe'en aka' yit'ijju'?— Ha' Jesús qa yeku'ƚ: —Ehe, hepi'ye'. Qa ekheweli'ƚ ¿me nite' les qu' ejeƚi'ƚ kekhewe' we'nika'ajji' in iyetij aka'an, qa yit'ij: “Ene' omehets qa ene' mexe tu'f, hats watji'let e'm qu' netlijtsii ei qa' newqinhetija iye”?— ");
INSERT INTO mca_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma' qa ha' Jesús qa yiwejinƚe hekhewe'en, qa ikik'uifik'i iye ha' witset qa wapilii ha' witset ƚa's ƚii Betania qa hikha' i'wi' wete'm. ");
INSERT INTO mca_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Qa neƚukii leefiju' qa wapilii iye ha' witset, ha' Jesús qa yoksi'wentax in iyipkun. ");
INSERT INTO mca_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Qa yi'wen ke' ewi'ƚ higokuk metetsju' ha' wit'ikheyi'j qa iktaxets wo'taxiikii ƚeye' qa hamƚe, uja'xƚe kekhewe' ƚesejets. Ma' qa yit'ijets: —Nite' ƚ'anuyi' hane'ej qu' nana'l pe'qu' eye'.— Ma' qa aje'eƚ wa'mji' ke' higokuk'ik'i qa yisƚax. ");
INSERT INTO mca_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","In yi'wen aka'an hekhewe' ƚ'ijatshenhei qa yitjuƚaxijpha'mkii, qa nifaakan ha' Jesús: —¿Pa'n ƚunye'j eke' higokuk'ik'i in aje'eƚ yisƚax?— ");
INSERT INTO mca_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Qa yeku'ƚ ha' Jesús: —Yijaa'ija aka' hit'iƚij ewets qu' nana'liƚ'em pa' nite' witqekuye'j qa' qu' nite' eqeku'yi'iƚik'i iye, nite' ewi'ƚƚe qu' ƚeke'ye' qu' aqsiiƚijkii aka' yeqfenye'jij ke' higokuk'ik'i, qe ƚeke' iye qu' it'ijets ne' utek: “Ma'ak'ui na' ƚa'ni' qa' anamji'ju' na' qi lejtax,” qa' hik aka' qu' ƚunye'je'. ");
INSERT INTO mca_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Week pa'qu' iyini'ƚets qu' iyini'ƚ, qu' nite' eqeku'yi'iƚik'i pa'qu' iyinheyejeyi'iƚ ma' qa' yijayejek qu' esti'yi'ƚij.— ");
INSERT INTO mca_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","In hats yamii iye ha' Jesús ke' witlijtsitjii, qa he' tenek'enhe'yij he' pa'il qa hekhewe' iye tenek'enheiji' ha' witset qa nekets ha' Jesús in mexe i'nq'ijatshen, qa yit'ijets: —¿Pa'n ƚii pa' tenek'enhei neƚisij qu' aqsiijkii ekewe' wekwek in ƚaqsiijkii? ¿Ƚekpa' neƚisij in ƚaqsiijkii?— ");
INSERT INTO mca_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ha' Jesús qa yeku'ƚ: —Yakhap ji'jek iye qu' k'afaakani'ƚ. Qu' enfeli'ƚ ye'm pa'qu' k'afaakani'ƚij, qa' henfeljii'ƚ e'mek nakha' ta'ƚets in haqsiijkii ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ƚekpa' ta'ƚijets in inqimpuujin ka' Juan'ik'i? ¿Me ta'ƚijets na' Dios? ¿Me i'nƚi'i ene' jukhewƚe?— Ma' qa wapilij wetju'ƚ in iyetijju', qa yit'ijju': —Qu' jintit'ijets ta'ƚijets pa' Dios, ma' qa nit'ij inwets: “¿Qa inhats'ek in nite' ƚ'ek'eni'ƚets?” ");
INSERT INTO mca_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Qa nite' ƚeke' iye qu' jintittaxijets qu' nata'ƚets ene' jukhew, qe ji'nijiweyiju'ƚ ene' jukhew qe week yit'ijets ka' Juan'ik'i in profeta.— ");
INSERT INTO mca_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma' qa hekhewe'en in yeku'ƚ ha' Jesús qa yit'ijju': —Nite' tsikfe'li'ƚets.— Ha' Jesús qa yit'ijiju'ƚek: —Qa' yakhape' ji'jek qu'nte' k'efeli'iƚi'm ƚekpa' tenek'enhei tseƚisij qa haqsiijkii ekewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ha' Jesús qa nifaakan iye hekhewe'en: —¿Pa'n qu' eqjunyejeyi'iƚij aka'an? Pa' jukhew wetsjuk pe' ƚelits. Qa yit'ijets pa' ewi'ƚ pekhewe'en: “Ya's, hane'ej qu' ma'aiju' qu' ithayiki na' yeqe uwaket.” ");
INSERT INTO mca_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pa' wita's qa inku'ƚ: “Nite' ts'ikheyu'uiju'.” Ma' qa i'nk'aƚe qa yijamtikii, ma' qa ikiiju'. ");
INSERT INTO mca_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma' qa pa' ƚatata qa yiyaji'ets iye pakhap iye ƚa's, qa aka' hats ƚ'anye'jets iye pa'aj. Qa pakha'an qa yeku'ƚ qa yittaxijets yijat'ij: “Ehe tata, hakiiju' hane'ej.” Qa nite'ƚe ikiiju'. ");
INSERT INTO mca_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ƚek pakha' enewe' wetsjuk yaqsiijkii pa' yisu'un pa' ƚatata?— Hekhewe'en qa yeku'ƚ: —Pa' yojo in nifaakan.— Qa yit'ij ha' Jesús: —Yijaa'ija aka' hit'iƚij ewets nekhewe' yijaninkii wekwek t'ejuyets pa' Roma ƚatata qa nekhewe' iye efuts natkinkii ene' jukhew, enewe'en yojo'oƚ ek'ui qu' nuiji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Qe in namtaxi'ƚ ei ka' Juan Bautista'ik'i qa nijatshentaxiƚij pa' yatsathen qu' ejunyejeyi'iƚ yijat'ij, qa nite'ƚe ƚ'ek'eni'ƚets. Qa enewe'ƚe yijaninkii wekwek t'ejuyets pa' Roma ƚatata qa nekhewe' iye efuts natkinkii ene' jukhew qa qi in tek'enets yijat'ij. Qa ekheweli'ƚ qa hats ƚi'wentaxi'ƚha aka'an, qa ƚunye'j ji'ij in nite' ƚitujtseikanini'ƚ pa'qu' ejunyejeyi'iƚ hats'inha qu' ek'eni'ƚets.— ");
INSERT INTO mca_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Qa yit'ijets ha' Jesús hekhewe'en: —Ek'eni'ƚik'i iye aka' qu' hejeyumtshenijupi' iye. Ewi'ƚ pa' jukhew yeni'ju' pa' ƚeq'ejinqa'wet pa' uwaket qa yeqetsitenijijup pe' utel. Qa tijju' iye pa' ewi'ƚ ƚeq'itset'ij qu' nenq'umutju' pe'qu' ƚeye'. Qa yaqsiijkii iye pe' ewi'ƚ qipha'm t'ejuyets qu' nejeƚipji'kii pa' uwaket. Ma' qa i'nk'aƚe qa yatkinhenets pe' jukhew pa' uwaket, ma' qa ik inji'witshen. ");
INSERT INTO mca_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","In hats k'esiyu'ets ƚahats'ij qu' netenifte'ji' pe' ƚei, qa nukintaxii pe' ƚeqejkunenhei pekhewe' natkin pa' uwaket, hats'inha qu' netisij qa neka'xii pe'qu' natsat'etsijek ƚeqei pa' yatsat'axij pa' uwaket. ");
INSERT INTO mca_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Qa pe' amaneyij in natkin pa' uwaket, qa t'eku'mi' pe' wit'ukinheitax, qa ewi'ƚ pa' yilanje'mkii, qa pakhap qa yilaanija qa pakhap iye qa nijele'ejkii pe' utel. ");
INSERT INTO mca_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pa' yatsat'axij pa' uwaket qa ewi'ƚij iye in yukin pekhewep iye ƚeqejkunenhei, qa hats les in olotstax. Qa pekhewe'en qa hik ƚeqfenyejeyij iye pa' hats ƚeqfenyejeyij pe' yojo. ");
INSERT INTO mca_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma' qa teke'lenju' in yukintax pa' ƚaa'sija, qa yit'ij: “Tees qu' ƚeqfenyejeyi'ij pe'ye' ha'ne ya's.” ");
INSERT INTO mca_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Qa in yi'weniju'ƚ pekhewe'en qa yit'ijju' pa'aj: “Hik ha'ne ha' ƚaa'sija. Hik ha'ne qu' naya'xtaxij ha'ne ƚetset ha' ƚatata. Jitalan hats'inha qa' jinatsat'etsij ha'ne sehe' yatsat'axij ha' ƚatata.” ");
INSERT INTO mca_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma' qa t'eku'mi' qa yeka'xik'uifik'i pa' uwaket qa yilan. ");
INSERT INTO mca_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Qa hane'ej, qu' nanamtax pa' yatsat'axij pa' uwaket, ¿pa'n ƚumti'iƚ qu' ƚeqfenyejeyi'ij pekhewe' nejettaxij yatkinhenintaxets pa' ƚeq'ejinqa'wet?— ");
INSERT INTO mca_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Qa yeku'ƚ hekhewe'en: —Nilanju' tees qu' ne'nq'eletij ene' uƚ'ets natkintax pa' uwaket. Qa' ni'nk'aihit iye pe'qu' nejeƚinenij qu' nanatkin iye pa' ƚeqe uwaket qa' hik pekhewe'ye' yijat'ij qu' netisji'jij pa' uja'x pe'qu' netisji'jij pa' yatsat'axij pa' uwaket qa yamji'jets ƚahats'ij qu' netenifte'ji'.— ");
INSERT INTO mca_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Qa ha' Jesús qa yit'ij: —¿Me nite' les qu' ejeƚi'ƚ ke' we'nika'ajji' in yit'ij: “Ne' ute yuten qa yiwu'mfik'i ne' niihinpha'm ne' wititsi', hane'ej qa ewi'ƚƚe in les weju'ƚij in teniihinijpha'm ne' wititsi'. Qa pa' Yatsat'ax'inij hikpa' yaqsiijkii aka'an qa in jitejeƚju' qa qi in ƚe'sits ine'm”? ");
INSERT INTO mca_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Qa hik ta'ƚijupi' in hit'iƚij ewets qu' itkamhiti'yi'ƚij na' tenek'enheiji' na' Dios qa' netesti'yij pakhap witset'e, qa hik pakha'ye' yijat'ij qu' olotse' pe'qu' ƚeqeye'. ");
INSERT INTO mca_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yakha' hik ƚunye'j ute, pakha' qu' nanamipji' ene' ute, qa' qaƚaƚe'ju'. Qa ene'ƚe ute pa'qu' nanamipji' qa' netweyik'uiju', ma' qa' ƚipipeju'.— ");
INSERT INTO mca_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hekhewe' tenek'enhe'yij he' pa'il qa he' fariseol iye in yepi'ye' ek'i ekewe' yejeyumtshenijupi' ha' Jesús, ma' qa nikfe'lik'i in ƚekhewelƚe in t'ejuyets. ");
INSERT INTO mca_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Qa in yisu'untax qu' nophe'ƚ qa nijiweiƚi'iju'ƚ he' olots jukhew qa efuts, qe enewe'en nikfe'lets ha' Jesús in profeta. ");
INSERT INTO mca_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ma' qa iyetik'ui iye ha' Jesús he' jukhew qa efuts, qa ewi'ƚij iye in yit'iji' ke' yejeyumtshenijupi', qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Na' tenek'enheiji' na' Dios hik ƚunye'j iye na'aj ewi'ƚ ƚe'wis neƚu yaqsiijkii na'aj ewi'ƚ qi wittata t'ejuyets in tewhe'yei pa' ƚa's. ");
INSERT INTO mca_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Qa yukin pe' ƚeqejkunenhei yiihettaxii pe' hats jutsiqets qu' nanamii pa' ƚe'wis neƚu witiwhe'yejii. Enewe'en qa nite'ƚe namiyu'ui pa' ƚe'wis neƚu. ");
INSERT INTO mca_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Qa ewi'ƚij in yukintaxii iye pekhewep iye ƚeqejkunenhei, qa yit'ijets: “Aka' it'iƚijets hekhewe' hats jutsiqetstax qu' nanamii: ‘Hats hajilettaxi'ƚ ek'ui na' qi aqi'ƚ. Hats talanhetiiju' ke' wakka'ik'i qa kekhewe' iye wakka ƚelitsik'i ne'ej we'nujenin, qa week hats yijat'etsju', te'ƚuniƚii qu' eneki'ƚets nakha' ƚe'wis neƚu witiwhe'yejii.’” ");
INSERT INTO mca_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pekhewe' wit'eqemhiitax qa nite' tek'en iye. Pekhewe'en ewi'ƚ pakha' ik yamii pa' ƚeq'ejinqa'wet qa pakhap iye qa yamiyek pe' ƚaqhatjii. ");
INSERT INTO mca_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Qa pekhewep iye wit'eqemhii qa t'eku'mi' pe' ƚ'ukinheitax pa' wittata qa yilanje'mkii qa pekhewep qa nilaanju'ha. ");
INSERT INTO mca_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma' qa qi in nayu'kii pa' wittata qa yiyaji'ets pe' ƚelits oq'opheƚinetsilets, qa ikii qa nilanju' pekhewe' eqek'unhets qa ne'ƚijju' iye pa' ƚetsetik'i. ");
INSERT INTO mca_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ma' qa i'nk'aƚe qa yit'ijets iye pa' wittata pe' ƚeqejkunenhei: “Na' witiwhe'yejii hats week yijat'axju', qa kekhewe'ƚe yojotax in wit'eqemhiitax qa nite'ƚe weju'ƚtaxij qek nanamii. ");
INSERT INTO mca_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Qa hik ta'ƚijupi', yape ma'aƚetsfik'i ne' les qits wit'ikheijei, qa' eqe'mi'ƚets week pa'qu' i'weni'ƚji' hats'inha qu' nanamii ha'ne ƚe'wis neƚu witiwhe'yejii.” ");
INSERT INTO mca_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pe' witqejkunenhei qa iketsfik'i pe' wit'ikheijei. Qa no'thet wetju'ƚ week pekhewe' yi'wen, pe' uƚ'etstax qa pe' ƚe'sits. Ma' qa hats topo'oj pe' wititsi' pe' wit'eqemhinel. ");
INSERT INTO mca_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ma' qa in uyetsji' pa' wittata qu' ni'wen pe' namii pa' ƚe'wis neƚu, qa yi'wen pa' ewi'ƚ jukhew in nite' yeqhinataji' pe' witqhinatai t'ejuyets na'aj tewhe'yei. ");
INSERT INTO mca_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pa' wittata qa yit'ijets: “Waika', ¿pa'n ƚunye'j in ƚentenuyetsji' ha'ne ƚe'wis neƚu in nite' ƚeqhinataji ke' t'ejuyets na'aj tewhe'yei?” Pakha'an qa ham pa'qu' nit'ij. ");
INSERT INTO mca_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ma' qa pa' wittata qa yit'ijets pe' ƚeqejkunenhei: “Ophe'ƚi'ƚ ne' ƚokoyei qa ne' ƚef'iyei iye qa' iwu'mi'ƚiifik'i na' i'nfik'i qi nookii qa' hik nakha'a' qu' qi qu' napi' qa' nat'aitaxji' iye ƚek'unhetii.” ");
INSERT INTO mca_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Qe olots nekhewe' teniyaitaxets, qa nite'ƚe olots ne' te'nekumhi'yiiji' ujaa'xkii.— ");
INSERT INTO mca_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","In yili'ij ha' Jesús ekewe'en, qa he' fariseol qa ikkii qa iyetijju' pa'n ƚunye'j qu' net'eku'mi' ha' Jesús qu' nata'ƚets pa'qu' nit'ij hakha'an. ");
INSERT INTO mca_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hekhewe'en qa nukinii he' ƚ'ijatshenheiƚe qa ƚijts'eyek hekhewe' yijayanek ha' Herodes, ma' qa yit'ijets: —Maestro, tsikfe'li'ƚetsha in akha' yijaa'ija na'aj ƚit'ij qa yijaa'ija iye in ƚi'nq'ijatshenij pa' yisu'un pa' Dios, ma' qa nite' ƚenwu'mpha'm qu' ink'aihitik'ui pakha' hats ƚisu'un qu' ƚunye'je' qu' nata'ƚets pa'qu' ƚunye'je'ƚe ene' jukhew, qe akha' week eqjunyejeyij. ");
INSERT INTO mca_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Qa hik ta'ƚijupi', enfeli'ƚ ye'm pa'qu' umti'ek. ¿Me ƚe'wisijupi' in jitajaninkii ekewe' wekwek qu' net'ejuyets pa' César, Roma ƚatata? ¿Me nite'?— ");
INSERT INTO mca_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ha' Jesús qa hatsƚe nikfe'lets in nite' ƚe'wis pa' neqfenyejeyutaxij hekhewe'en, qa yit'ijets: —Ejtitsits, hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ. ¿Inhats'ek in ƚ'ewqeleitaxi'ƚ yik'ui? ");
INSERT INTO mca_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ets'ethini'ƚij ewi'ƚe' ƚ'astaki'ye' nijket pekhewe' t'ejuyets in tajaikii eke' wekwek.— Hekhewe'en qa yethinij ke' ewi'ƚ denario. ");
INSERT INTO mca_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ha' Jesús qa yit'ijets hekhewe'en: —¿Ƚek ƚeju's ha'ne witeqsi'nq'al i'nji' qa ƚek ƚii iye ha'ne i'nji'?— ");
INSERT INTO mca_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Qa yeku'ƚ hekhewe'en: —Pa' César, Roma ƚatata ƚesi'nq'al.— Ha' Jesús qa yit'ijets: —Ye'ehe, qa' ƚisi'ƚij pa' Roma ƚatata (César) pekhewe' yatsat'etsƚi'ijek in Roma ƚatata (César), qa na' Dios pekhewe' yatsat'etsƚi'ijek in Dios.— ");
INSERT INTO mca_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","In yepi'ye' ek'i aka'an hekhewe'en, qa qi in yitjuƚaxijpha'mkii, ma' qa ikik'uikii. ");
INSERT INTO mca_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Qa hik kakha' iye ka' neƚuji', he' uja'x hekhewe' saduceol qa nekii iye ha' i'ni' ha' Jesús qe naqfaakanheyu'uj pe'ye'. He saduceol yit'ijets in nite'te' iƚii iye hatse' pe' naxju'. ");
INSERT INTO mca_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma' qa yit'ijets ha' Jesús: —Maestro, pa' Moises'ik'i yit'ij pa'aj: “Pa'qu' nawa'm in mexe hamtax ƚelitsi'iƚ pe'qu' ƚewhe'ye'ye', ma' qa pa' ƚek'inij i'nƚi'i qu' ƚamats'e qa' hik pakha' qu' ƚewhe'ye'yi'ij pe' ƚewju'lelax. Ma' qa qu' nataltsa'yi'ƚ qa' hikpa' qu' ƚa'si'ij pa' wa'm ƚewhe'ye'ek'i.” ");
INSERT INTO mca_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ha'ne ha'ni'ƚi' na'l ka' ewi'ƚ hik ƚunye'j aka'an wetsjuk tatsai (7) pe' witjefeye'k. Pa' yojo in tewhe'yeitax qa wa'm, qa mexeƚe hamtax ƚa'si'iƚ pe' ƚewhe'ye'tax. Qa nejettaxij qu' ƚewhe'ye'yi'ij pa' ƚek'inij, ");
INSERT INTO mca_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","qa wa'mifi iye. Qa hik ƚunyejei iye pekhewep iye ma' qa week naxju' pe' wetsjuk tatsai (7) witjefeye'k. ");
INSERT INTO mca_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","In hats week naxju' qa wa'm iye pe' efu'uk'i. ");
INSERT INTO mca_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Qa hane'ej qu' iƚiye'tax iye pe' hats nanaxtaxju' ¿qa pa'n ƚunye'j pa'qu' ƚewhe'ye'yi'ij pekhewe' wetsjuk tatsai (7) pe' efu'uk'i? Qe hats week ƚewhe'yetstaxij pekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Qa yeku'ƚ ha' Jesús qa yit'ijiju'ƚ: —Ekheweli'ƚ qi in ƚijaniƚik'i qe nite' ƚenikfe'li'ƚik'i ke' Intata ƚe'lijei, qa nite' ƚenikfe'li'ƚetsha iye na' qi ƚet'unha'x na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Qe qu' iƚiye'tax pe' naxju', pe' jukhew qa efuts nite' tewhe'yeiju' hatse', qe hik qu' ƚunyejeye' yijat'ij ne' angelits wa's ƚeiƚets. ");
INSERT INTO mca_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ye'ehe, in t'ejuyets qu' iƚiye'tax pe' naxju', ¿me nite' ƚiyineniƚik'i na' Dios in yit'iƚij ewets: ");
INSERT INTO mca_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yakha' ƚeqe Dios ka' Abraham qa ka' Isaac qa ka' Jacob”? Na' Dios ƚeqe Dios ne' iƚii. Qa nite' ƚeqe Dios pe' naxju'.— ");
INSERT INTO mca_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hekhewe' olots jukhew qa efuts, in yepi'ye' ek'i ekewe' i'nq'ijatshenij ha' Jesús qa qi in yitjuƚaxijpha'mkii aka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Qa hekhewe'ƚe fariseol in impi'ye'ej he' saduceol in ham pa'qu' nit'ijiju'ƚ ha' Jesús, qa ewi'ƚ we'neni'. ");
INSERT INTO mca_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Qa ha' ewi'ƚ hekhewe' fariseol hakha' i'nq'ijatshenij ke' Moisés ƚe'lijei qa yijaajintax iye, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ¿pa'n ƚunye'j pa'qu' les qiye'ji'ha kekhewe' ƚe'lijei pa' Dios tisij pa'aj pa' Moises'ik'i (mandamientos)?— ");
INSERT INTO mca_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Qa ha' Jesús qa yeku'ƚ qa yit'ij: —Isu'unija pa' Yatsat'ax'inij eqe Dios weekij pa' atawe'j, qa weekij iye pa' iƚa'x, qa weekij iye pa' aqjamtikineye'jkii. ");
INSERT INTO mca_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aka'an hik aka' ka' les in qiji' qa hik aka' iye yojo'ok'oi kekhewe' wenit'ij qu' nanaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Qa ka' yojo'opji' qa hik ƚunye'j iye aka'an in yit'ij: “Isu'un week pa'qu' mete' e'm jukhew qa efuts in ejunye'jek in ƚewetsu'unƚe.” ");
INSERT INTO mca_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ekewe' wetsjuk wi'tlijei hik ekewe' ƚetkui ke' week testi'yij ka' Moises'ik'i qa ke' i'nq'ijatshenij iye ke' profeta'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Qa in mexe ewi'ƚ i'ni' he' fariseol, qa ha' Jesús qa nifaakanji'ju', ");
INSERT INTO mca_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","qa yit'ij: —¿Pa'n ƚumti'iƚ qu' ƚunye'je' pa' Cristo? ¿Pa'n ƚii pa'qu' nata'ƚets?— Qa yeku'ƚ hekhewe'en: —Ta'ƚte'ets hatse' pa' David'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma' qa yit'ijets ha' Jesús: —Ye'ehe, ¿qa inhats'ekek ka' David'ik'i pa' Espíritu Santo in ta'ƚets, qa yit'ijets: “Yatsat'axyij?” Qe ka' David'ik'i yit'ij: ");
INSERT INTO mca_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Pa' Intata qa yit'ijets pa' Yatsat'axyij: ‘Niju' ni'iju' ha'ne ts'iyayik'i ipƚu'ui qu' hentaxiiju' ne' ef'iyei qa' otsi'pji'kii ne' ejuihifets.’” ");
INSERT INTO mca_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pa' David'ik'i in yit'ijets, “Yatsat'axyij.” ¿Qa pa'n ƚunye'j iye qu' nit'ijets qu' ƚa'se'?— ");
INSERT INTO mca_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hekhewe'en qa ham pa'qu' neku'ƚijiju'ƚ pe'qu' ƚe'lijeye', ma' qa hik aka'aj ka' neƚuji' qa ta'ƚi' in hats ham pa'qu' nanfaakanij pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ma' qa hik aka'aj ha' Jesús qa hats iyetik'uiha he' jukhew qa efuts qa week iye he' ƚ'ijatshenhei, ");
INSERT INTO mca_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","qa yit'ijji'ju': —Nekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa nekhewe' iye fariseol, hik nekhewe' wetƚisij qu' net'ekuumi'ha qu' ninq'ijatshenij kekhewe' wenit'ij qu' nanaqsiijkii yika'ajji' ka' Moises'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Qa hik ta'ƚijupi' qu' ek'eeni'ƚik'iha qa' week aqsiiƚijkii iye pa'qu' nit'iƚij ewets, qa hasu'ujƚe ijayani'ƚij ka' ƚunyejei nekhewe'en, qe ƚekhewel nite' yaqsiijkii kekhewe' i'nq'ijatshentaxij. ");
INSERT INTO mca_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ƚekhewel hik ƚunyejei aka'an: yophe'ƚ je'mkii pe' witqatai qi niihetits, jutsitets qu' jinteka'xtax. Ma' qa yiƚkoninij enewe' jukhew qa efuts iye, qa ƚekhewelƚe qa nite' ewii'ƚe' pe'qu' ƚayaqsi'ye' qu' nekumhini' qu' neka'x. ");
INSERT INTO mca_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Week na'aj yaqsi'jtaxijkii ewi'ƚƚe in yisu'un qu' netwenheti'yij. Yisu'un in yeni' ne'ej ƚ'iwatai qa ƚokoyei iye ne'ej nite' qitax ƚasimmi'tax qa lesƚe in yiwqinhet iye ne'ej yaqsiijkii ti'najki' ƚasi' i'nji' ne'ej uja'x kekhewe' Intata ƚe'lijei, qa ne'ej yit'onijju' ƚeiƚal iye qa les in yijetinijju' iye ne'ej jipimju'. ");
INSERT INTO mca_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yisu'un iye qu' na'nipji' ne'ej ƚots'oji'laxits ne'ej qitsji' qe tekju' na'aj ewi'ƚ ƚe'wis neƚu qa ne'ej witlijtsitjiyifi iye ne'ej wits'ojilaxits, ƚots'oji'laxits pe' qitsji'. ");
INSERT INTO mca_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yisu'un iye qu' netniwetfelhei qe yijalki'sji'kii na'aj ƚaqhawet qa yisu'un iye qu' netiyi'yij in maestro. ");
INSERT INTO mca_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Qa ekhewelƚi'iƚ qa' hasu'uj iwejini'ƚi'm aq'ayini'ƚij pakha' qu' ni'ttaxi'ƚij ewets maestro, qe ewi'ƚƚe na' aqa Maestro'oƚ qa ekheweli'ƚ qa week e'witjefeyek'iƚipji'. ");
INSERT INTO mca_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hasu'uj iye it'iƚijets pe'ye' ha'ne sehe' epji' tata, qe ewi'ƚƚe na' Atata'aƚ hik nakha' i'ni' na' wa's. ");
INSERT INTO mca_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hasu'uj iye iwejini'ƚi'm pe'qu' ni'ttaxi'ƚij ewets qu' e'qitsi'iƚji', qe ewi'ƚƚe na' Cristo in qiji'ha. ");
INSERT INTO mca_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Qa pakha'ƚe les in qiji' ekheweli'ƚ, pakha'an, pakha' hik ƚunye'j qu' eqejkunenek'i'iƚ. ");
INSERT INTO mca_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Qe pakha' qu' ƚakha' ye'ƚetax ƚete'm qu' neniwqinhetji', qa' hik pakha'ye' qu' netwepinhetkii. Qa pakha'ƚe qu' nite' neniwqinhete'ji' qa' hik ha'neye' qa' neniwqinhetji'. ");
INSERT INTO mca_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa nekhewe' iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ƚit'oniƚik'uiji' ene' jukhew qa efuts iye na' ƚeji' na' tenek'enheiji' na' Dios. Qa ekheweli'ƚ iye nite' ƚe'nuihiyu'uƚii iye. Nite' ƚiwejiniƚi'm iye nekhewe' nuihiyu'taxii. ");
INSERT INTO mca_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa nekhewe' iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ƚenitka'miƚijkii pe' ƚetsiltax pe' wikiihalei. Ƚa'napetaxi'ƚijets qe ƚ'iyini'ƚ qa nite'ƚe yijaa'ija qu' iyini'ƚ qe ƚisu'unƚi'iƚ qu' me'nethiniƚijkii. Qa hik ta'ƚijupi' qu' les qu' qiye' pa'qu' atanithenheti'yi'ƚij. ");
INSERT INTO mca_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa nekhewe' iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ƚijawe'jiƚij ji'teje'mkii na' qi iweli' qa pekhel ƚenekiƚiji'kii iye ha'ne sehe' in ƚowo'oƚiikii pa'qu' amiti'ƚijju' kakha' ejunyejeyi'ƚ. Ma' qa in hats ƚamitiƚijju', qa hats ƚaqsiiƚijkii qu' wetsjuk'i'ij qu' nat'ani'ƚ epji' qu' les ne'weju'ƚij wiikfik'i qu' namii pa' fe't. ");
INSERT INTO mca_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hiyee' e'newusitsi'ƚ, puk'alets yojotaxik'ui pekhewep, qe ekheweli'ƚ ƚit'iƚij: “Ham weju'ƚi'ij pakha' qu' neniwjutsiqentaxiji'm ne' witlijtsitjii pa'qu' nit'ij, qa hasu'uj naqsiijkii. Pakha' yijat'ij qu' neniwjutsiqeniji'm pa'qu' nit'ij ne' ƚeqe oro ne' qi witlijtsitjii, qa weju'ƚij yijat'ij, ma' qa' naqsiijkii pa' weniwjutsiqenij.” ");
INSERT INTO mca_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nite' ƚ'eqeneƚuyi'ƚ wetju'ƚ qa puk'alets iye, qe ¿pa'n ƚunye'j pa'qu' les qiye'ji'? ¿Me na' oro? ¿Me i'nƚi'i ne' witlijtsitjii in hik nekhe' ta'ƚets in we'nenifi ne' oro ma' qa yatsat'etsij na' Dios? ");
INSERT INTO mca_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Qa ƚit'iƚijju' iye: “Nite' weju'ƚij pakha' qu' neniwjutsiqentaxiji'm na' ts'eewe'epji' (altar) t'ejuyets na'aj witqisit'ij na' Intata (ofrenda) pa'qu' nit'ij, qa' hasu'uj naqsiijkii. Pakha' yijat'ij qu' neniwjutsiqeniji'm na'aj witqisit'ij pa' Intata (ofrenda) pa'qu' nit'ij, qa weju'ƚij yijat'ij, ma' qa' naqsiijkii pa' weniwjutsiqenij.” ");
INSERT INTO mca_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Puk'alets! ¿Ƚekpa' qu' les qiye'ji'? ¿Me pa' witqisit (ofrenda)? ¿Me i'nƚi'i pa' ƚe'nenhe'wet'ipji' (altar), in hikpa' ta'ƚets in we'nenipji' pa' witqisit (ofrenda) qa yijaa qa yatsat'axij pa' Dios? ");
INSERT INTO mca_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Qa hik ta'ƚijupi', pakha' qu' netetfeliji'm pa' ts'eewe'epji' (altar) pa'qu' nit'ij, ma' qa hats week tetfeliji'm pa' ts'eewe'epji' (altar) qa pe' i'nipji' iye (ofrenda). ");
INSERT INTO mca_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Qa pakha' qu' netetfeliji'm ne' qi witlijtsitjii pa'qu' nit'ij, qa tetfeliji'm ne' witlijtsitjii qa nakha' iye i'nifi ne' witlijtsitjii. ");
INSERT INTO mca_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Qa pakha' qu' netetfeliji'm pa'qu' nit'ij na' wa's, qa hats tetfeliji'm na' ƚots'oji'la'x na' Dios qa nakha' iye i'nipji' nakha'an. ");
INSERT INTO mca_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Hiyee' e'newusitsi'ƚ, i'nq'ijatshenij ke' Moisés ƚe'lijei qa ekheweli'ƚ iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe in ƚeqethentaxi'ƚfik'i ne'ej menta ƚesejets qa ne'ej anis iye qa comino iye in cien (100) yamets qa diez (10) ƚeqetheni'ƚfik'i qu' net'ejuyets na' Dios. Qa nite'ƚe ƚaqsiiƚijkii kekhewe' les in qitstaxji' wi'tlijei wenittaxij qu' nanaqsiijkii, kekhewe'en: yatsathen, eq'iltina'x, yaqsi'jijkii pa'qu' hats nit'ij hik ekewe'tax qek aqsiiƚijkii, qa hasu'ujƚe qek ili'iƚij qu' aqsiiƚijkii kekhewe' hats ƚ'asiniƚik'i in ƚaqsiiƚijkii. ");
INSERT INTO mca_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ekheweli'ƚ hik ejunyejeyi'ƚ qu' e'puk'aletsi'iƚ in ƚojotaxiƚik'ui pekhewepe'! Qe hik ƚunye'j qu' uketi'ƚ na'aj iweli' qe qa' nite' etimi'ƚ ne'ej iye, qa ni'kha'ƚi'ij ats'etax in qitax qa hik na'aj ƚetimi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa ekheweli'ƚ iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ekheweli'ƚ ƚimpulijini'ƚ na' ƚ'anu'ui nakha' hik ƚunye'j wasu qa hik ƚunye'j iye tok'o, qa ƚatawejƚe qa topo'oj pakha' wit'ejtenheye'j qa pa' wit'ekuyi' iye. ");
INSERT INTO mca_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo puk'al! Yojo yijat'ij qu' nempulijik'iju' na' ƚatawe'j nakha' hik ƚunye'j wasu qa hik ƚunye'j iye tok'o, hats'inha qu' ƚe'wise' ji'jek ham ƚejili'ye' nakha' i'nfik'i. ");
INSERT INTO mca_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa ekheweli'ƚ iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ekheweli'ƚ hik ejunyejeyi'ƚ ne'ej nimeƚkui qe hats wetlinij na'aj fo' i'm qa ƚe'sits in jite'wen, qa ƚatawjetsƚe qa topolij witinutsik'i qa in hats ƚipipji' iye. ");
INSERT INTO mca_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aka'an hik aka' ejunyejeyi'ƚ iye, e'ƚe'sitsi'ƚ in ne'weni'ƚ ene' jukhew, qa pekhewe'ƚe atawjetsi'ƚ qa qi in topolij in hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ, qa topoli'ƚ ej iye in nite' ƚisu'uni'ƚ qu' aqsiiƚijkii pa' yisu'un na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Hiyee' e'newusitsi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qa ekheweli'ƚ iye fariseol, e'jtitsitsi'ƚ hik ejunyejeyi'ƚ qu' wetsjuk'e ejusitsi'iƚ! Qe ekheweli'ƚ ƚeniihini'ƚpha'm ne' ƚenimeƚkui kekhewe' profeta'ik'i qa ƚi'sinheti'ƚ iye wekwek ƚ'eniƚi' ne' ƚenimeƚkui ke' jukhew'ik'i yatsathen. ");
INSERT INTO mca_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma' qa ƚit'iƚijju': “Qek hats jinana'l pakha'aj pa' ƚahats'ij pekhewe' inqa'jteyik'i qekha nite' jina'ne'taxij ji'teje'm in nilanju' pekhewe' profeta'ik'i.” ");
INSERT INTO mca_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ye'ehe, qa aka'an in ƚit'iƚijju', ma' qa hats ƚanalitƚi'iƚik'i in ekheweli'ƚ ƚata'ƚiƚets kekhewe' nilanju'kii ke' profeta'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yape oponheti'ƚij pakha' uƚ'ax mente' yoxpo'taxij ke' aqa'jteyi'ƚik'i.— ");
INSERT INTO mca_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—¡Q'oiq'oyits! ¡Q'oiq'oyits ƚelits! ¿Pa'n qu' ilithinyejeye'taxiƚik'ui hatse' qu' atanithenhetiitaxi'ƚij pa' fe't qi iftsax? ");
INSERT INTO mca_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Qa hik ta'ƚijupi', Jeƚ qeku'ni'ƚek qu' he'nukini'ƚ ei iye pe'qu' profetaye', qa pe'qu' qi nikfe'lets wekwek in t'ejuyets na' Dios qa pe'qu' ninq'ijatshenij iye ke' ƚe'lijei na' Dios. Ma' qa ekheweli'ƚ qa' anlani'ƚju' iye pe'qu' uja'xe', qa pekhewep qa' eni'ƚji'pha'm pe'qu' cruzitse', qa pekhewep iye qa' eqsilani'ƚ je'mkii ne' witlijtsitjiyitsifi qa' ijayani'ƚiikii pekhewep witsetiikal, ");
INSERT INTO mca_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","hats'inha qu' nanami'ƚ epji' iye na' witaxtanithenkeye'j ta'ƚets ke' ƚ'athits ke' week yatsathen in talanhetiiju', qa in ta'ƚi' ek ka' yatsathen Abel'ik'i qa yamijii ka' Zacarias'ik'i ƚa's ka' Berequias'ik'i. Hik kakha' Zacarias'ik'i ƚilaniƚi' na' ƚeqewuk'uji' ne' witlijtsitjiyii qa na' ts'eewe'epji' ƚe'nenhe'wet'ipji' na'aj witqisit'ij na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yijaa'ija aka' qu' hit'iƚij ewets in week ekewe'en qu' na'nipji' hatse' enewe' na'l hane'ej ha'ne ƚahats'ij.— ");
INSERT INTO mca_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—¡Jerusalén, Jerusalén, ƚanlani'ƚju'kii kekhewe' profetas'ik'i, ƚenjele'eƚijkii utel kekhewe' nukintax ei na' Dios qu' nenfel e'm ke' ƚe'lijei! Pa'n uja'xij in hisu'untax qu' ewi'ƚ heni' ne' elits, in ƚunye'jek ne'ej ta'a'a' qe ewi'ƚ yeni' ne'ej ƚelits uyifi ƚefets, qa nite'ƚe ƚisu'un. ");
INSERT INTO mca_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jeƚ qeku'ni'ƚju' ek na' etset'iƚ qu' hats ham na'ni'i hatse'. ");
INSERT INTO mca_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Qe hane'ej qu' nata'ƚi' qu' hit'ij ewets in hats nite' ƚ'anuuyi'i qu' e'tswen iye, ipƚu'ui qu' ittaxij: “Qi in ƚe'wis ha'ne namij ka' ƚii pa' Yatsat'ax'inij.”— ");
INSERT INTO mca_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ha' Jesús in hats ikik'uifik'i ke' witlijtsitjii, qa hats iktax, qa he' ƚ'ijatshenhei qa we'tmetinheti'm qa yit'ijets: —Jeƚ qeku'nju' ene' witlijtsitjii, ¡hayits qa ƚe'wis!— ");
INSERT INTO mca_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ha' Jesús qa yeku'ƚ qa yit'ijets: —¿Me hats ƚi'weni'ƚ ene'en? Yijaa'ija aka' hit'iƚij ewets in ham pe'qu' ewii'ƚe' qu' amane'pha'm hatse' ene' utel ene' witlijtsitjii. Week qu' jaƚaq'eju'kii hatse'.— ");
INSERT INTO mca_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Qa ha' Jesús qa i'niju' ke' utek ƚii Olivos, ma' qa nekets he' ƚ'ijatshenhei qa uja'xƚi'iƚkii, qa nifaakan: —Hisu'untaxi'ƚ qu' enfeli'ƚ ye'm ¿pa'n ipƚu'uk'ui qu' namets qu' ƚunye'je' kakha' ƚit'ij qu' jaƚaq'eju' ne' witlijtsitjii? ¿Qa pa'n ƚunye'j iye pa'qu' jutsiqaxi'ij qu' etpiltaxju' iye, qa pa'qu' jutsiqaxi'ij iye qu' nanaxtaxijik'i hatse' pakha' hane'ej ƚahats'ij?— ");
INSERT INTO mca_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ha' Jesús qa yeku'ƚ, qa yit'ij: —Jeƚi'ƚiju'ƚha, hasu'uj pa'qu' nawitji'iƚ ma' qa' naqani'ƚkii. ");
INSERT INTO mca_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Qe olots hatse' pe'qu' nanam qa' netyinenyij qa' nit'ij: “Yakha' ye' Cristo.” Ma' qa' olots pe'qu' naqankii. ");
INSERT INTO mca_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ekheweli'ƚ qa' impi'ye'jiiƚij pe'qu' hats nawatlaanija, qa' impi'ye'jiiƚij iye pe'qu' nanwatlanheyu'ji'ijtax. Qa hasu'ujƚe e'nijiwe'yi'ƚ, qe les ƚe'wis qu' ƚunyejeye'kii week ekewe'en, qa mexeƚe nite' yamets pa' ƚ'aka'the'ju' hatse'. ");
INSERT INTO mca_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Qe ewi'ƚ pa'qu' witset'e qa' nawatlani'ƚ pakhape' iye witsetiika'ye', qa ewi'ƚ pa'qu' wittataye' qa' nawatlani'ƚ pakhape' iye wittataye'. Qa' nana'l iye pe'qu' witsetitse' qu' qi qu' niyipkunju', qa pe'qu' me'le'le' iye sehel. ");
INSERT INTO mca_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Qa hikƚe ƚunyejei ekewe'en ne'ej iwkajitshen in i'nk'a yoksi'wen pa'qu' ƚaqati'yi'ij hatse'. ");
INSERT INTO mca_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ma' qa' yapeye'ƚek qu' namets qu' ekekiti'yi'ƚiikii qu' awitjaxti'yi'ƚju', qa qu' alanheti'yi'ƚju'ha iye qa' qi iye qu' na'napjaxi'ƚ e'm ene' week witsetits qe ta'ƚets qu' atsjayani'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","—Ma' qa olots pe'qu' niliyij hatse', pekhewe'en qa' nowotk'onijkii qa qi iye qu' na'napjaxi'm pekhewep. ");
INSERT INTO mca_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Qa olots iye hatse' pe'qu' nanam ejtitsits qu' nit'ij ƚetets qu' profetaye', ma' qa olots iye pe'qu' naqankii. ");
INSERT INTO mca_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Qa qu' hats qi qu' net'ijayijfik'i hatse' pa' uƚ'ax, ma' qa pa' ƚeqsu'unka'xtaxyij pe'qu' olootse' qa' net'ijayik'iju'. ");
INSERT INTO mca_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Qa pa' qu'nte' niliye'yij qu' namijii pa' ƚ'aka'the'ju' pa' ƚahats'ij qa hikpa' qu' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Qa eke' ƚe'sits wi'tlijei nifel pa' ƚunye'j qu' jina'nji'teje'm na' tenek'enheiji' na' Dios, qa week netfelhitiyi'pji' pe' week witsetits ha'ne sehe' epji'. Ma' qa qu' hats week nepiye'ek'i qa' hayitse' qa' hats nanam pa' ƚ'aka'the'ju'.— ");
INSERT INTO mca_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Qa hik ta'ƚijupi', qu' i'weni'ƚ pakha' qi uƚ'ax yeq'ilatkii hatse', pakha' hayiits nifel ka' profeta'ik'i Daniel, qa' nawatts'ap'anhetifi nakha' qi ƚe'wis ƚetsettax na' Dios nekhe' witlijtsitjiiyifi (pakha' qu' niyinenik'i aka'an qa' nenikfe'lik'i). ");
INSERT INTO mca_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ma' qa pekhewe' qu' na'ni' na' Judea, qa' nilatii ne' utekui. ");
INSERT INTO mca_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Qa pa'qu' na'nipji' pe'qu' ƚetsi'ye' na'aj k'eewe'epji' qu' namtaxets pakha'an, hasu'uj nenuihiyu'ufi pe'qu' ƚetsi'ye' qu' net'ilitju' qa' neka'xfik'ikii pe'qu' ƚewekwekitse'. Aje'eƚ nilat yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Qa pa'qu' na'nji' na' ƚ'ejinqa'wet, hasu'uj netpilii iye pe'qu' ƚeqhinataye'. Aje'eƚ nilat yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Qa ¡hiye' enewusits pe'qu' efutse' pekhewe' qu' niwkajitshenju' qa pekhewe' qu' mexe nifunen iye pe'qu' ƚelitse' qu' namtaxets hatse' nekhewe' neƚutsji'! ");
INSERT INTO mca_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Iyini'ƚijets na' Dios qu' hasu'uj qu' lop'e qu' ilati'ƚkii, qa qu' hasu'uje' iye pa'qu' witwapiihijiye'ji' (sábado). ");
INSERT INTO mca_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Qe pe' neƚutsji' hatse' qii'ija pa'qu' a'taxe' qa iftsitsji'ha iye, qa ham pa'qu' hayiits ƚunye'ji'iju'ƚ in ipƚu'uk'i ek in i'nk'a wanaqsiijkii ha'ne sehe' qa yamijii hane'ej, qa nite' ƚ'anuuyi'i iye qu' ƚunye'je'kii iye hatse'. ");
INSERT INTO mca_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Qa qu' nite' neniwk'itsini'iju'ƚ pekhewe' neƚutsji' hatse', qa' ham pa'qu' iƚa'xe'. Qa in ta'ƚƚe'ets pekhewe' hats te'nekumhi'yiiji', ma' qa' neniwk'itsiniju'ƚ hatse'. ");
INSERT INTO mca_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Qa qu' nana'l pa'qu' ni'ttaxi'ƚij ewets hatse' pekhewe' neƚutsji': “Ek'en qeku'ni'ƚek, hik ha'nete' i'ni' pa' Cristo,” i'nƚi'i qu' nit'ij “hatsiite' pa' i'ni'”. Qa' hasu'ujƚe umti'iƚ qu' yijaayi'ija. ");
INSERT INTO mca_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Qe nam hatse' pe'qu' nit'ij ƚetets qu' Cristoye' qa pe'qu' nit'ij ƚetets qu' profetaye'. Qa' ni'nq'ethinij pe'qu' qits ham ƚunyejeyi'iju'ƚ qa pe'qu' qi qu' nitjuƚaxijpha'mkii iye, qe qa' naqankii ene' week, qa qu' ƚeke'ye', qa' naqankii iye nekhewe' hats t'eku'miiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jeƚ qeku'ni'ƚek, hats week henfeli'ƚ e'm aje'eƚ ekewe'en in mente' yamets qu' nana'l. ");
INSERT INTO mca_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Qa hik ta'ƚijupi', pa'qu' ni'ttaxi'ƚij ewets: “Jeƚ qeku'ni'ƚii i'nti'i' pa' ham i'ni'i',” qa hasu'uj jeƚi'ƚii, qa i'nƚi'i qu' ni'ttaxi'ƚij ewets: “I'nifi ke' wititsi',” qa hasu'uj iye qu' umti'iƚ qu' yija'ye'. ");
INSERT INTO mca_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Qe hik qu' ƚunye'je' na'aj etheluna'x in nite' wanat'in qe tethelun qa na'lji' na' neƚu'uju'ƚ qa i'nƚi'i qe na'lji' iye na' tefeji', qa' hik aka' qu' ƚunye'je' hatse' na' Ƚa's na' Jukhew qu' netpiltaxju' iye. ");
INSERT INTO mca_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na'aj i'ni' na'aj iwamhi'l qa hik na'aj i'njii ek ne'ej o'powil.— ");
INSERT INTO mca_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Qu' nanaxijik'i hatse' pekhewe' neƚutsji' qi iftsitsji' qa a'tits iye, ma' qa ne' junu' qa' aje'eƚ nom, qa juwel iye qa'nte' nana'leji' iye, qa ne' footekii qa' nanamiiju'kii iye qa pa' qi ƚet'unha'x ne' wasits qa' nawapja'. ");
INSERT INTO mca_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ma' qa' hayitse' qa' ne'twenhetii na' wa'sji'pha'm pa'qu' jutsiqaxi'ij na' Ƚa's na' Jukhew, qa qi qu' ne'nijiwei week pe' witsetits ha'ne sehe' ipji'. Ma' qa' ne'twenhetii ha'ne Ƚa's na' Jukhew qu' netpiltaxju' iye i'nji' pe' wasi' in ta'ƚiipha'm na' wa's, qi pa'qu' ƚet'unha'xe' qa qi iye pa'qu' ƚesa'xe'. ");
INSERT INTO mca_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma' qa' nukinkii ne' ƚaqa angelits qu' hats nat'ai pe' qi foj, qa' nonothet wetju'ƚ week pe' hats t'eku'miiji' na' ima'xii, i'wk'uyi'lii, neƚu'uju'ƚ qa pe' tefeji' iye, in uja'xek pe' week te'weyik'uiju' ha'ne wa's. ");
INSERT INTO mca_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Maxtayit qekuni'ƚijupi' ek ne'ej ewi'ƚ higokuk aka' jiyijatshenij, in hats esufui iye ne'ej ƚenuts ma' qa ta'ƚji' iye ne'ej ƚesejets, qa hats ƚenikfe'li'ƚets in hats k'esets na'aj jinawa'p. ");
INSERT INTO mca_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Qa hik ƚunye'j, ekheweli'ƚ qu' i'weni'ƚ week ekewe' wekwek tefelhitii, qa' menikfeliti'ƚets na' Ƚa's na' Jukhew in hats metifikii na' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yijaa'ija aka' hit'iƚij ewets in nite' hamits hatse' pekhewe' qu' nanamji'ju' pakha' ƚahats'ij hatse', qa namƚi'ii qu' week ƚunye'je'kii ekewe' hats hit'ij. ");
INSERT INTO mca_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na' wa's qa ha'ne sehe' hamits hatse', qa ekewe'ƚe hats hit'ij qa yijaa'ija, nite' ƚeke' qu' hamitse'. ");
INSERT INTO mca_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Qa hamƚe nikfe'le'ets pa' neƚuji' qa pa' i'ni' iye junu' hatse'. Nite' nikfe'lets iye ne' angelits na' wa'sji'. Nite' nikfe'lets iye na' Ƚa's. Qe ewi'ƚƚe in nikfe'lets na' Ƚatata.— ");
INSERT INTO mca_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Qe in ƚunyejeyek ke' ƚeqe neƚutsji' ka' Noe'ik'i, qa hik aka' qu' ƚunye'je' iye hatse' qu' netpiltaxju' iye ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Qe in ƚunyejeyek kekhewe' neƚutsji' in mexente' nam ka' qi piƚei qa iwelitax iye, ke' jukhew'ik'i tek, iya', tewhe'yeiju'kii qa ke' ƚelits qa yiwhe'yeyinju'kii, qa yamƚi'ijii ka' neƚuji' ka' Noe'ik'i in t'ilitji'ju' ke' qi tokoyei. ");
INSERT INTO mca_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Qa nite' yumti qu' yijayi'ija yamijii in hats nam ka' qi piƚei qa iwelitax iye, ma' qa week yeka'x ka' iweli'. Hik aka' qu' ƚunye'je' hatse' qu' netpiltaxju' iye na' Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wetsjuk pe'qu' na'ni' pa'qu' ƚ'ejinqa'wet'e, ewi'ƚ pa'qu' neka'x qa ewi'ƚ pa'qu' nenejet. ");
INSERT INTO mca_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wetsjuk pe'qu' efutse' taqfijinju'. Ewi'ƚ iye pe'qu' neka'x qa ewi'ƚ iye pe'qu' nenejet. ");
INSERT INTO mca_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Qa hik ta'ƚijupi', matjanitheni'ƚkii qe nite' ƚenikfe'li'ƚets pa' neƚu ƚamijiiju' na' Yatsat'etsi'ƚ ej. ");
INSERT INTO mca_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Menikfeliti'ƚets aka'an, pa'qu' ewi'ƚ natsat'axij pe'qu' wititsi'ye' qu' nenikfe'lets pa'n uja'x hora qu' na'naja'xij qu' nanamets pa'qu' ejtenhetsi'le', ma' qa' qi qu' natjanithenik'ui hats'inha qu' nite' name'etsji' qu' nuyifi pe'qu' ƚetsi'ye'. ");
INSERT INTO mca_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Qa hik ta'ƚijupi' ekheweli'ƚ qu' matjanitheni'ƚkiiha qe ha'ne Ƚa's na' Jukhew i'nƚi'i qu' nanamji' pakha' qu'nte' umtiyetaxi'ƚ qu' nanamji'.— ");
INSERT INTO mca_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—¿Ƚekpa' witqejkunenek tek'en qa nikfe'lkiiha iye? Pakha'an pa' ƚaqa patun qa nejetij qu' week nejeƚ pe' ƚetsi' qa' nenkunhenji'ijju' iye qa yamji'jets ƚekujii pekhewe' i'ni' pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ƚe'wisi'mkii pa' witqejkunenek, pakha'an in nam pa' ƚaqa patun, qa yi'wen in yaqsiijkii aka'an. ");
INSERT INTO mca_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yijaa'ija aka' hit'iƚij ewets, pakha' patun qa' netisij qu' week netnek'enhe'yipji' pe' ƚewekwekits. ");
INSERT INTO mca_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Qa pakha'ƚe qu' witqejkunenek'e in uƚ'ax, qa yit'ij pa'qu' ƚatawe'je': “tees qu' nanam aje'eƚ ha' yaqa patun,” ");
INSERT INTO mca_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma' qa' yapeye'ƚek qu' nilanji'ij je'mkii pakhape' iye pekhewep ƚ'ithayifetstax, qa tek qa iya' iye, i'nji'teje'mkii iye pekhewe' yek'uwetju'kii. ");
INSERT INTO mca_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma' qa pa' ƚaqa patun pa' witqejkunenek qa' nanamji' pa' neƚuji' nite' yumtitaxji' qa pe' hora iye nite' yumtitaxji' iye. ");
INSERT INTO mca_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma' qa qi qu' nitanithen qa' nuihinetsji' iye pakha' ewi'ƚ ƚeq'itset'ij pekhewe' hik ƚunyejei qu' wetsjuk'e ƚejusitse'. Ma' qa' hikpa' qu' qi qu' napi' qa' tx'ak'ak'etaxkii iye ƚek'unhetii.— ");
INSERT INTO mca_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Pa' ƚahats'ij hatse' na' tenek'enheiji' na' Dios hik qu' ƚunye'je' ne'ej diez (10) inanyii qe nenjelu'uk'ui na'aj niwhe'yeyu' qa week t'eku'mi' ne'ej ƚefetitjiyits ƚeq'ilij na'aj aceite. ");
INSERT INTO mca_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco (5) pekhewe' nite' watji'let qa cinco (5) iye pe' watji'let yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Qe pekhewe' nite' watji'let, in yeka'xtax pe' ƚefetitjiyits qa nite'ƚe yeka'x pe'qu' ƚeq'ili'ij iye hatse'. ");
INSERT INTO mca_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Qa pekhewe' watji'let yijat'ij qa yeka'x pe'qu' ƚeq'ili'ij iye hatse' qu' nimtaxji' pe' ƚefetitjiyits. ");
INSERT INTO mca_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","In nite' namets aje'eƚ pa' niwhe'yeyu' pa' notkitaxik'ui, qa hats week nijatiyu'ju'. Ma' qa imaa'ju'ha. ");
INSERT INTO mca_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Qa in hats natsathenju' pa' naja'x ma' qa tepiikaxtii pa' taya'yijipji': “¡Hats nam na' tewhe'yei! ¡Yape eneki'ƚiju'ƚ qa ijts'eyi'iƚkii!” ");
INSERT INTO mca_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ma' qa pe' inanyii qa week niipha'mkii qa mexe yaqsi'jju' iye qu' nene'ƚji' pe' ƚefetitjiyits. ");
INSERT INTO mca_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pekhewe' cinco (5) inanyii pe' nite' watjanithen qa iyintaxijets ƚeq'ile': “Esƚis qeku'niƚij ƚammi'se'ƚeji yeq'ili'iƚ, hats yomiyu' ene' yifetitjiyitsi'ƚ.” ");
INSERT INTO mca_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Qa inku'ƚ pekhewe' inanyii pe' watjanithen yijat'ij: “Ham, hats weju'ƚji' ene' yifetitjiyitsi'ƚ. Les ƚe'wis yijat'ij qu' aqhai eku'ni'ƚii pe'qu' eq'ili'iƚ.” ");
INSERT INTO mca_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pekhewe' nite' watjanithen, in mexe taqhaitaxii pe'qu' ƚeq'ile', qa naamƚek pa' tewhe'yei. Qa pekhewep cinco (5) watjanithen yijat'ij qa hikpe' qa ƚijts'eye'kteje'm in uyi'ƚetsji' pakha' qi qu' netekifi witiwhe'yejii. Qa week yot'axteje'm, ma' qa tit'oiji' pa' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma' qa i'nk'aƚe qa namtaxkii pe' taqhaitaxii ƚeq'ile', qa yiyajitaxetsji'kii: “Yatsat'axyij, yatsat'axyij, i'tqeku'ni'ƚij ye'mii qhof na' ƚeji'.” ");
INSERT INTO mca_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Qa yeku'ƚ pakha'an, qa yit'ij: “Yijaa'ija aka' qu' hit'iƚij ewets, nite' tsikfe'li'ƚ ej.” ");
INSERT INTO mca_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Matjanitheni'ƚkiiha, qe nite' ƚenikfe'li'ƚets pa' neƚuji' qu' namets, qa nite' ƚenikfe'li'ƚets iye pa'qu' uja'xe' horaye'.— ");
INSERT INTO mca_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Qe na' tenek'enheiji' na' Dios hik ƚunye'j iye pa'qu' ewi'ƚ jukhewe' in hats nikheyu' qa' namii pakhape' iye witsetiika'. Ma' qa taya'yii pe' ƚeqejkunenhei qa nejetij pe' ƚaq'astai qu' net'ithayi'yij. ");
INSERT INTO mca_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa' ewi'ƚ pekhewe'en qa tisij pe' cinco mil (5.000) nijketits inyetets, qa pakhap qa wetsjuk mil (2.000) nijketits inyetets, qa pakhap iye qa ewi'ƚ mil (1.000) pe' tisijek nijketits inyetets. Qa week ewiƚei netisijju' pakha' qu' ne'weju'ƚij qe nikfe'lets. Ma' qa ik pakha' jukhew. ");
INSERT INTO mca_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pakha' witqejkunenek testi'yij pe' cinco mil (5.000) nijketits inyetets, qa aje'eƚ ik qa taqhayijets pe' testi'yij pa'qu' net'ihinij, ma' qa cinco mil (5.000) iye nijketits pe' ƚaxifkinel. ");
INSERT INTO mca_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Qa hik ƚunye'j iye pa' testi'yij pe' wetsjuk mil (2.000) nijketits qa na'l iye pe' t'anij iye wetsjuk iye mil (2.000) nijketits. ");
INSERT INTO mca_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Qa pakha'ƚe testiitaxij pe' ewi'ƚ mil (1.000) nijketits, qa ik qa ti'jik'ui yat'inkii pe' ƚaq'astai pa' ƚaqa patun. ");
INSERT INTO mca_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ma' qa in hats yape'eikiiha pa'aj pa' ƚaqa patun pekhewe'en qa nam, qa yejeyumtshen pe' ƚaq'astai netisijju' pa'aj pe' ƚeqejkunenhei. ");
INSERT INTO mca_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yojo in nekets pa' testi'yij pe' cinco mil (5.000) nijketits inyetets, qa neka'xets pekhewe' cinco mil (5.000) ƚaxifkinelij qa yit'ijets pa'aj: “Yaqa patun, ƚesƚisij ene' cinco mil (5.000) qa hane'ej qa cinco mil (5.000) iye ene' yaxifkinelij.” ");
INSERT INTO mca_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Qa yit'ijets pa' ƚaqa patun: “Hats weju'ƚij. Akha' qi in ƚeik'unei. Akha' in nite' ƚono'qmositij pa'qu' ƚammi'se'tax. Qa hik ta'ƚijupi' qa les olotse' pe'qu' k'ejeƚinenij. Ente'nuiteje'm qa' week je'ƚe'sitsi'imkii.” ");
INSERT INTO mca_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Qa nekets iye pa' testi'yij pe' wetsjuk mil (2.000) nijketits inyetets, qa yit'ijets: “Yaqa patun, ƚesƚisij ene' wetsjuk mil (2.000) qa hane'ej qa wetsjuk mil (2.000) iye ene' yaxifkinelij.” ");
INSERT INTO mca_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Qa yit'ijets iye pa' ƚaqa patun: “Hats weju'ƚij. Akha' qi in ƚeik'unei. Akha' in nite' ƚono'qmositij pa'qu' ƚammi'se'tax. Qa hik ta'ƚijupi' qa' les olotse' pe'qu' k'ejeƚinenij. Ente'nuiteje'm qa' week je'ƚe'sitsi'imkii.” ");
INSERT INTO mca_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Qa nekets iye pa' testi'yij pe' ewi'ƚ mil (1.000) nijketits inyetets, qa yit'ijets: “Yaqa patun, tsikfe'l ewets in its'iyoptox qe hik ejunye'j qu' enitƚi'ijji' ne'ej ƚei ne'ej nite' akha' qu' enju' qa ƚ'eku'mi' iye ƚei ne'ej nite' akha' qu' iwu'mkii qe we'nenju'. ");
INSERT INTO mca_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Qa hik ta'ƚijupi' in ts'ijiwei eju'ƚ qa hetijik'ui ne' aq'astaki'. Ene'en ke' ƚantsat'axij in aq'astaki'.” ");
INSERT INTO mca_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pa' ƚaqa patun qa yeku'ƚ: “Akha' qi in uƚ'ax qa a'walxa'l iye. In ƚenikfe'lets in hik yijunye'j qu' henitƚi'ijji' ne'ej nite' yakha' qu' henju', qa he'yeku'mi' ne'ej ƚei ne'ej nite' yakha' qu' hiwu'mkii qe we'nenju', ");
INSERT INTO mca_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","les ƚe'wistax qek enifi ne' banco ne' yaq'astaki' qa in tsam qekha hats nana'ltax pe' qek nat'antaxfik'i. ");
INSERT INTO mca_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Qa hik ta'ƚijupi', enitka'mi'ƚij ne' mil (1.000) qa' ƚisi'ƚij nakha' na'li'm ne' diez (10).” ");
INSERT INTO mca_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Qe week pakha' qu' hats nana'li'm, qa' les netesti'yij, ma' qa' olootsi'ija. Qa pakha'ƚe qu' ham nana'li'im qa' netitkamhiti'yij pe'qu' ujaxe'tax qu' nana'li'm ma' qa' hamija amani'ij. ");
INSERT INTO mca_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Qa ha'ne ham weju'ƚi'ij witqejkunenek, iwu'mi'ƚetsfik'i nakha' i'nik'uifik'i na' nookii, hik nakha'a' hatse' nekhewe' qu' qi qu' napi'ju' qa' qi iye qu' nat'aiji' ƚek'unhetii.— ");
INSERT INTO mca_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Qu' netpiltaxju' iye ha'ne Ƚa's na' Jukhew qi pa'qu' ƚesa'xe' qa week ne' ƚaqa angelits qu' nanjayanju', ma' qa' na'nipji' na' ƚots'oji'la'x t'ejuyets pa' qi ƚet'unha'x in tenek'enhei, ");
INSERT INTO mca_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ma' qa' nonot'axets nakha'an week pe' witsetiikal, qa' neqethenwetju'ƚkii, in ƚunye'jek na'aj kots'etets ƚenilayets qe yeqethen wetju'ƚ ne'ej kots'etets qa kots'eteikal. ");
INSERT INTO mca_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pe' kots'etets qa' ni'wetshenji' pa' yiya'yik'i, qa' pekhewe'ƚe kots'eteikal qa' ƚefeyi'j ni'wetshenji'. ");
INSERT INTO mca_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ma' qa ha'ne Wittata qa' nit'ijets pekhewe' qu' ne'tweyij pa' yiyayik'i: “Te'ƚuni'ƚ ekheweli'ƚ, nekhewe' hats qi in yi'fen na' Tata. Ni'iƚi' nakha' qu' neƚisi'ƚij tenek'enhe'yi', hik nakha' hayiits tooxik'i in watji'leti'ƚ ek'ui in mexente' wanaqsiijkii ha'ne week sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Qe in k'iyipkun qa ekheweli'ƚ qa ƚesƚisi'ƚij pa'qu' hetuj, in ts'iyayu' qa ekheweli'ƚ iye qe ƚesƚisi'ƚij na'aj ya't. In ƚetsweni'ƚik'ui nite' ƚenikfeltaxiƚyij qa ƚesƚisƚi'iƚij pa'qu' yiwhi'wet'e. ");
INSERT INTO mca_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hamtax pe'qu' yeqhinataye' qa ekheweli'ƚ qa ƚesƚisi'ƚij ne'ej yeqhinatai. In hanqaats'e' qa ekheweli'ƚ qe ƚanami'ƚ yiikii qu' e'tsweni'ƚ. Hoyopheƚitiitax qa ƚanami'ƚ yiiji'kii iye qu' e'tsweni'ƚ.” ");
INSERT INTO mca_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ma' qa pekhewe' yatsathen pa' ƚunyejei qa' neku'ƚ, qa' nit'ijiju'ƚ: “Yatsat'axyij, ¿pa'n ipƚu'uk'i qu' k'eweni'ƚ qu' iyipkun qa k'eƚisiƚij pa'qu' aqe'? ¿Qa pa'n ipƚu'uk'i iye qu' k'eweni'ƚ qu' e'niyayu' qa k'iyahani'ƚ iye? ");
INSERT INTO mca_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Qa pa'n ipƚu'uk'i iye pa'aj qu' k'eweni'ƚ in nite' tsikfe'ltaxi'ƚ ej qa tseqjunuƚi'iƚ ej qa k'eƚisiƚij pa'qu' ewhi'wet'e', qa in hamtax eqhinataye' qa k'eƚisiƚij iye? ");
INSERT INTO mca_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Qa pa'n ipƚu'uk'i iye pa'aj qu' manqaats'e i'nƚi'i qu' opheƚitii qa tsamjii'ƚ eiji' qu' k'eweni'ƚ?” ");
INSERT INTO mca_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Qa na' Wittata qa' neku'ƚ, qa' nit'ijiju'ƚ: “Yijaa'ija aka' hit'iƚij ewets, ekewe'en in ƚaqsi'ji'ƚi'mijkii pa'qu' ewi'ƚe' ene' k'injats yemjeetax nekhewe' hik ƚunyejei ne'ej mexeelija, qa yakha'ƚe in ƚaqsi'ji'ƚ ye'mijkii.” ");
INSERT INTO mca_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na' Wittata qa' nit'ijets iye pekhewe' te'weyij ƚefeyi'j: “Me'nitoni'ƚ ye'mii, ekheweli'ƚ nekhewe' ewi'ƚƚe in weju'ƚij nakha' qi witaxtanithenkeye'j, yape ma'aƚetsju' na' qi fe't nite' yili'ij hayiits watjiletijup qu' netwumhitiiji'ju' na' inwo'met qa ne' ƚaqa angelits iye. ");
INSERT INTO mca_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Qe in k'iyipkuntax qa nite' ƚesƚisi'ƚij pa'qu' hetuj. Ts'iyayutax qa nite' ƚesƚisi'ƚij iye pa'qu' yat'e'. ");
INSERT INTO mca_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","In ƚetswentaxi'ƚ qa in nite' ƚenikfe'li'ƚyij, qa nite' ƚeneqjunu'uƚyij qu' esƚisi'ƚij pa'qu' yiwhi'wet'e. Hamtax yeqhinataye' qa nite' ƚesƚisi'ƚij iye pe'qu' yeqhinataye'. Qa in hanqaats'e' qa' i'nƚi'i iye qe hoyopheƚitii qa nite' ƚanami'ƚ yiiji' qu' e'tsweni'ƚ.” ");
INSERT INTO mca_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pekhewe'en qa' neku'ƚtax iye, qa nittaxijiju'ƚ: “Yatsat'axyij, ¿pa'n ipƚu'uk'i qu' k'eweni'ƚ qu' iyipkun i'nƚi'i qu' e'niyayu', i'nƚi'i qu' nite' netsikfe'li'iƚ ej, i'nƚi'i qu' ham eqhinataye', i'nƚi'i qu' manqaats'e, i'nƚi'i qu' opheƚitii qa qu' nite' k'efeni'iƚ iye?” ");
INSERT INTO mca_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma' qa pakha'an qa' neku'ƚ iye, qa nit'ijets: “Yijaa'ija aka' hit'iƚij ewets, ekheweli'ƚ in nite' ƚaqsi'ji'ƚi'mijkii ekewe'en nekhewe' hik ƚunyejei ne'ej mexeelija nekhewe' k'injats, qa yakha'ƚe in nite' ƚaqsi'ji'ƚ ye'mijkii ekewe'en.” ");
INSERT INTO mca_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Enewe'en qa' namii na' qi witaxtanithenkeye'j nite' yili'ij, qa pekhewe'ƚe yatsathen qa' namiyek na' qi ƚe'wis witiƚa'x nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ha' Jesús in yili'ij in nifel week ekewe'en, ma' qa yit'ijets he' ƚ'ijatshenhei: ");
INSERT INTO mca_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ekheweli'ƚ hats ƚenikfe'li'ƚets in wetsjuk neƚuts pe' hamitsik'ui qa' namets pa' qiji' ƚe'wis neƚu Pascua, ma' qa ha'ne Ƚa's na' Jukhew qa' ne'tnineiji' qe qa' net'enhetii'ji'pha'm pe'qu' cruze'.— ");
INSERT INTO mca_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hik pakha'aj hekhewe' tenek'enhe'yipji' he' pa'il qa hekhewe' iye tenek'enheiji' ha' witset, qa ewi'ƚ we'neni' pa'aj qa not'axi' wetju'ƚ ke' ƚaqa palacio'oi ha' qiji' ƚatata he' pa'il ƚii Caifás. ");
INSERT INTO mca_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma' qa iyetijju' in yijamtitaxets qu' nanat'inij qu' net'eku'mi' ha' Jesús qa' nilan. ");
INSERT INTO mca_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hekhewe'en qa yi'tƚi'ijju' iye: —Qa hasu'ujƚe jit'eku'm eku'ni' qu' jintalan enewe' ƚe'sits neƚutsji', hats'inha qa' nite' nat'ayeji' qu' na'nayu'kii ene' jukhew.— ");
INSERT INTO mca_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ha' Jesús i'nii ha' witset Betania, ke' ƚetsi'ii ha' Simón, hikha' ƚenqii iye leproso. ");
INSERT INTO mca_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Qa hik hakha'a' qa nekets ke' efu, neka'xets ke' ewi'ƚ qi ƚe'wis ute ƚii alabastro eƚi'ni'ij topo'oj ka' ewjisii inyetax, ma' qa yatsi'yipji' ƚeiƚa' ha' Jesús in mexe i'nijup ha' mesa. ");
INSERT INTO mca_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","He' ƚ'ijatshenhei in yi'wenij qa nayutaxkii, qa yit'ijju': —¿Inhats'ek in yaq'ayinƚekii kakha'an? ");
INSERT INTO mca_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Qe aka' ewjisiyik'i olotstax pe' qek ƚaja'ye'tax ƚ'astai qek ne'tninei, ma' qekha netestiitaxij ne' if'iljetsits.— ");
INSERT INTO mca_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ha' Jesús in yepi'ye' ej hekhewe'en aka' yit'ijju', ma' qa yit'ijji'ju': —¿Inhats'ek in pekhel anyejeyi'ƚijkii ene' efu? Aka' ƚeqfenye'jyij qi in ƚe'wis. ");
INSERT INTO mca_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Qe ene' ham yiwq'axine' nite' yili'ij week ƚahatsiyij qu' nana'li'ƚ ejup. Qa yakha'ƚe qa nite' week ƚahatsiyij qu' ha'ni'ƚ ejup. ");
INSERT INTO mca_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aka' ƚeqfenye'jij ene' efu in yatsi'yipji' aka' ewjisii qa yewjisit ha'ne yaj, qe qa' najilet qu' nets'ewjisit aje'eƚ in mente' hayajkati'yik'ui qu' hawa'm. ");
INSERT INTO mca_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yijaa'ija aka' hit'iƚij ewets, pa'qu' na'ne'ƚi'i qu' netfelhitii hatse' eke' ƚe'sits wi'tlijei ha'ne week sehe' epji', qa' netfelhitii iye aka' ƚeqfenye'jyij ene' efu, ma' qa' natjamtaxti'yik'ikii nekhe'en.— ");
INSERT INTO mca_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma' qa hik aka'aj ka' ewi'ƚ he' doce (12) ƚ'ijatshenhei ƚii, Judas Iscariote, qa ikii pa'aj hekhewe' tenek'enhe'yij he' pa'il, ");
INSERT INTO mca_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","qa yit'ijets: —¿Pa'n uja'x pe'qu' isu'uni'ƚ qu' esƚisi'ƚij hats'inha qu' k'eƚisiƚij ha' Jesús?— Ma' qa he' pa'il qa yijaninij pe' treinta (30) nijketits ƚiyits plata. ");
INSERT INTO mca_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ma' qa hik aka'aj pa'aj ka' Judas qa wo'oikiiha pa'aj pa'qu' iwemetsaxe' qu' ƚeke'ye' qu' net'ihinij ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka' yojo neƚuji' kakha' qi ƚe'wis neƚu witkujiiji' ne'ej pan nite' yetsji'ƚ pe'qu' levaduraye', he' ƚ'ijatshenhei ha' Jesús qa nekets qa nifaakan: —¿Pa'n i'ni' pa'qu' isu'un qu' jinaniji' qa' haqsiiƚiji'kii pa'qu' jinteƚuj qu' net'ejuyets ha'ne qi ƚe'wis neƚu Pascua?— ");
INSERT INTO mca_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Qa yeku'ƚ qa yit'ij: —Ma'aƚiiteje'm na' witset qa' i'weni'ƚi' pa'qu' jukhewe' qa' it'iƚijets: “Ha' Maestro yit'ij: Hats k'esets qu' namets yeqe hora, hik ta'ƚijupi' qu' henekii ne' etsi' qu' ha'ni'ƚiji' ene' yijatshenhei qu' heyeki'ƚji' pa' qi ƚe'wis neƚu Pascua.”— ");
INSERT INTO mca_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma' qa hekhewe' yukin ƚ'ijatshenhei, qa week yaqsiijkii aka' hats yit'ijets ha' Jesús. Qa yaji'let week ke' ƚaqats t'ejuyets ka' qi ƚe'wis neƚu Pascua. ");
INSERT INTO mca_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Qa in hats najaleikii, ha' Jesús qa hats i'nijupju' ha' mesa qa week iye he' doce (12) ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","In mexe tekju', ha' Jesús qa yit'ijji'ju': —Yijaa'ija aka' hit'iƚij ewets, ekheweli'ƚ na'l nakha' ewi'ƚ qu' net'ihinyij hatse'.— ");
INSERT INTO mca_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Qa hekhewe'en qa qi in yitawje'meten qa week nifaakantax: —Yatsat'axyij, ¿me yakha'?— ");
INSERT INTO mca_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Qa ha' Jesús qa yeku'ƚ, qa yit'ij: —Nakha' ewi'ƚ na' yoqotok'o'oƚ in hilke'eƚijetsju'kii ne' pan, hik nakha' pa' t'ihinyij hatse'. ");
INSERT INTO mca_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ha'ne Ƚa's na' Jukhew hats ikƚi'ij, in ƚ'anyejeyek kekhewe' hats we'nika'ajji' in t'ejuyets nakha'an. Qa ¡hiye' ha'nus nakha' t'ihinij hatse' ha'ne Ƚa's na' Jukhew! Les ƚe'wistax nakha' jukhew qek hasu'uj nenekfik'i pa'aj.— ");
INSERT INTO mca_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma' qa ha' Judas hik hakha' t'ihinij, qa nifaakan: —Maestro, ¿me yakha'?— Ha' Jesús qa yeku'ƚ: —Akha' hats ƚit'ij aka'an.— ");
INSERT INTO mca_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","In mexe tekju', ha' Jesús qa t'eku'mi' ka' pan qa yit'ijetspha'm ƚe'wisij pa' Dios, qa netisijju' he' ƚ'ijatshenhei qa yit'ijets: —Ku'mi'ƚiju'ƚ qa' ƚuji'ƚ, hane'en hik ha'ne yese'n.— ");
INSERT INTO mca_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma' qa t'eku'mi' iye ha' tok'o qa in hats yit'ijetspha'm iye ƚe'wisij pa' Dios qa tisijik'i iye he' ƚ'ijatshenhei, qa yit'ijets iye: —E'weeki'iƚij qu' iya'aƚij ha'ne tok'o, ");
INSERT INTO mca_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","qe ha'ne i'nji' hane'en hik enewe' yathits, hik enewe' qu' nata'ƚets pakha' ink'ayik wenit'ij, ma' qa' nawantsiifik'i qe ta'ƚets pekhewe' olots hats'inha qu' netwumhiti'yik'ui pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Qa hit'iƚij ewets in hats nite' k'iya'ji' iye ni'khap iye uwa ƚ'i', ipƚu'ui qu' namtaxets pa' neƚuji' qu' ji'niyataxji' iye na' ink'ayik uwa ƚ'i' na' tenek'enhe'yi' na' Tata.— ");
INSERT INTO mca_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","In yili'ijju' kakha' ewi'ƚ in yiji'ik'i, ma' qa ikkii qu' nakiiteje'm ke' utek Olivos. ");
INSERT INTO mca_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma' qa ha' Jesús qa yit'ijji'ju': —Hane'ejija ha'ne naja'xji', week ekheweli'ƚ qu' me'nitoniƚets hatse' qe yakha' qu' nata'ƚ yiwets, qe kekhewe' we'nika'ajji' Intata ƚe'lijei yit'ij: “Hilan hatse' na' kots'etets ƚenilayets, qa ne' kots'etets qa' nak'eskii.” ");
INSERT INTO mca_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Qa qu' yi'ƚa'xe'tax iye qa' hathayini'ƚ ek'uyii ha' Galilea.— ");
INSERT INTO mca_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma' qa ha' Pedro qa yeku'ƚ, qa yit'ijets: —Yemjeetax qu' week ne'nitontax e'mets hatse' qe akha' qu' nata'ƚ ewets, qa yakha'ƚe qa' nite' ƚ'anuuyi'i qu' he'niton e'mets.— ");
INSERT INTO mca_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ha' Jesús qa yit'ijets: —Yijaa'ija aka' hit'ij ewets ha'ne naja'xji' qu' mente' nape' pa'qu' ta'a'aye' qa hats wetshetk'ewi'ƚij qu' mewelku'tyijkii.— ");
INSERT INTO mca_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ha' Pedro qa yit'ijets iye: —Ƚunye'jij qu' week jinanaxju', nite' hewelku't ejkii.— Qa week ƚ'anyejeitax aka'an he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ma' qa hats namets ha' Jesús qa he' ƚ'ijatshenhei ha' najkaket ƚii Getsemaní, qa yit'ijji'ju' he' ƚ'ijatshenhei: —Hik ha'ne ni'ekuni'ƚi'ju'kii qa yakha'ƚe qa' mexe ha'nii hakijji' qu' nek'iyin.— ");
INSERT INTO mca_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Qa t'eqe'mets ha' Pedro qa he' wetsjuk ƚelits ha' Zebedeo. Ma' qa yapeƚek ha' Jesús in yoksi'wen in qi in ika'metkii qa qi iye in itawje'met. ");
INSERT INTO mca_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma' qa yit'ijets: —Qi in hoksi'wen in naq'aliyuyij pa' yikameta'xkii. Ha'ne a'maneyi'iƚi'. Hasu'uj mama'aƚ yijup.— ");
INSERT INTO mca_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma' qa ikfik'i pa' ha'niiji'in, qa wonokok'enju' qa yamitetsju' sehe' ƚotkoyek, qa iyin qa yit'ij: —Tata qu' ƚeke'ye', qa' hasu'uj anamit yiwets wat'ij ha'ne qi ek'imiiji', qa hasu'ujƚe pa'qu' yakha' ye'ƚe qu' hisu'un, akha' yijat'ij pa'qu' isu'un.— ");
INSERT INTO mca_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma' qa tepilii iye pa' i'ni' he' ƚ'ijatshenhei qa yi'wen in imaa'ju'ha pa'aj. Ha' Jesús qa yit'ijets ha' Pedro: —¿Me nite' ƚeke' qu' ewi'ƚ horaye' qu'nte' ama'ye' eku'ni'ƚ yijup? ");
INSERT INTO mca_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hasu'uj mama' a'ƚju'. Iyini'ƚ hats'inha qa' nite' nanami'iƚ ewets na' witaqjaajinkeye'j. Pe' atawjetsi'ƚ hats qi in yisu'untaxija qu' naqsiijkii aka'an, qa nite'ƚe t'units ne' esenitsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Qa ewi'ƚij iye in ikfik'i iye pa'aj, qa iyin iye, ma' qa hats wetsjuk'ij, qa yit'ij iye pa'aj: —Tata, qu' nite' ƚeke'ye' qu'nte' anamite' yiwets qa'nte' nek'iya'ye'ji' pa' qi ek'imiiji', qa' aqsiijkii pakha' ƚisu'un.— ");
INSERT INTO mca_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Qa tepiltaxii iye qa yi'wen iye in ima'ju' iye he' ƚ'ijatshenhei, qe nite' ƚekheweliju'ƚ pa' nijati'. ");
INSERT INTO mca_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Qa ikfik'i iye, qa iyin iye ma' qa hats wetshetk'ewi'ƚij, qa yiyeketij kakha' hats yit'ij. ");
INSERT INTO mca_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Qa tepilii iye pa' i'ni' he' ƚ'ijatshenhei qa yit'ijets pa'aj: —¿Me menjiit ƚama'aƚju' qa ƚawapiyi'ƚju' iye? Hats yamets ne' hora, qa ha'ne Ƚa's na' Jukhew qa' netesti'yij nekhewe' uƚ'ets jukhew. ");
INSERT INTO mca_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Eniyi'ƚpha'mkii qa' jinakkii. Jeƚ qeku'ni'ƚiju'ƚ, hats met nakha' t'ihinyij.— ");
INSERT INTO mca_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","In mexe iyet ha' Jesús qa namets ka' Judas. Hikka' i'ntaxji'teje'm he' doce (12) ƚ'ijatshenhei. Olots he' ƚijts'eyek taqatsjikinetii qa uja'x he' najak he' t'eku'mi'. Ƚ'ukinhei he' tenek'enhe'yij he' pa'il qa he' tenek'enheiji' ha' witset. ");
INSERT INTO mca_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ka' Judas in t'ihinij qa hayiits na'l pa'aj pa'qu' niwjutsiqenij, qa yit'ij pa'aj: —Hakha' qu' hetu'je'm, qa' hik hakha'ye', qa' ku'mi'ƚi'.— ");
INSERT INTO mca_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Qa in hats namets qa aje'eƚ nekets ha' Jesús, qa yit'ijets: —Ƚanam, Maestro.— Ma' qa tu'je'm. ");
INSERT INTO mca_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ha' Jesús qa yit'ijets: —Waika', aqsiijkii pakha' ƚanamij met qu' aqsiijkii.— Ma' qa hekhewe' ƚijts'eyek qa nekets ha' Jesús qa t'eku'mi' qa niyejinju'ha. ");
INSERT INTO mca_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma' qa hakha' ewi'ƚ hekhewe' ƚ'ijatshenhei qa t'eku'metsju' ha' ƚaqa'tsjikinet qa' weqfekin je'm qa yasinii ke' ƚekfi'ik'i ha' ƚeqejkunenek hakha' qiji' ƚatata he' pa'il. ");
INSERT INTO mca_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ha' Jesús qa yit'ij: —Ukinik'iju' iye na' ƚejii na' aqa'tsjikinet. Qe week pe'qu' nawatlanij na'aj witqatsjikinet, qa' hik na'aj iye qu' naq'alij. ");
INSERT INTO mca_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ye' me ƚumti qu' nite' ƚeke'ye' qu' nek'iyinets na' Tata, qa ƚakha' qa' aje'eƚ nenukinju' pe'qu' nat'ani' doce (12) legión angelitse'? ");
INSERT INTO mca_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Qa qu' hik aka' ƚunye'je'kii, ¿qa pa'n ƚunye'j qu' nafits kekhewe' we'nika'ajji' in hayiits yit'ij qu' hik aka' ƚunye'je'kii?— ");
INSERT INTO mca_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Qa hik aka'aj qa yit'ijji'ju' ha' Jesús hekhewe'en: —¿Inhats'ek in ƚ'aqatsjikineti'yi'ƚyii qa ƚenka'xi'ƚ iye ne' ek'uli'ƚ najak qu' ots'opheƚi'ƚ? ¿Me hik yijunye'j na'aj ejtenhetsax? Week neƚuts yakha' ha'nifi ne' witlijtsitjii he'nq'ijatshenifi qa ham ts'opheƚe'. ");
INSERT INTO mca_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Qa hatsƚe week qu' ƚunyejeye'kii hane'ej ekewe'en, qe qa' nasinik'i kekhewe' yika'ajji' ke' profeta'ik'i.— Ma' qa hik aka'aj he' ƚ'ijatshenhei qa week yak'esik'uikii qa ilatkii. ");
INSERT INTO mca_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hekhewe' t'eku'mi' ha' Jesús qa yeka'xii ke' ƚetsi' ha' Caifás, hikha' qiji' ƚatata he' pa'il, qe hik hakha' not'axi' wetju'ƚ hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa he' tenek'enheiji' ha' witset. ");
INSERT INTO mca_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ha' Pedro qa yijayanpha'mkii pa'aj qa toxƚi'imii, yamƚi'ijiiji'ha pa'aj ha' jofji'ju' ke' ƚetsi' ha' pa'il ƚatata. Qa uiteje'm qa i'nijupju' pa'aj hekhewe' witeqjeƚinenheyipji' ke' witlijtsitjii qe qa' niweenijha week pa'qu' ƚeqfenyejeyi'ij. ");
INSERT INTO mca_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hekhewe' tenek'enhe'yij he' pa'il qa week pekhewe' Junta Suprema wo'oikii pa'qu' witwotk'onhet'eƚe qu' net'ejuyiju'ƚ ha' Jesús, hats'inha qu' ƚeke'ye' qu' natlanhetii. ");
INSERT INTO mca_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Qa nite'ƚe yi'wen, yemjeetax in olotstax pe' jukhew in wotk'onƚetaxiikii pa'qu' ƚunye'je' ha' Jesús. Qa i'nk'aƚe pa'aj qa na'l pe' wetsjuk jukhew qu' nowotk'onijkii iye. ");
INSERT INTO mca_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Enewe'en qa yit'iju' pa'aj: —Ha'ne jukhew hik ha'ne yit'ijets: “Yakha' ƚeke' qu' hiwuƚ'enhetijkii ene' qi witlijtsitjii, qa' wetshetk'ewi'ƚ neƚuts qu' heniihinpha'm iye.”— ");
INSERT INTO mca_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma' qa ha' pa'il ƚatata qa ts'ap'a, qa yit'ijets ha' Jesús: —¿Me nite' ƚ'inku'ƚ? ¿Pa'n qu' it'ij qu' eku'ƚik'i aka' wenit'ij ewets?— ");
INSERT INTO mca_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Qa ha' Jesús qa nite'ƚe inku'ƚ. Qa ha' pa'il ƚatata qa yit'ijets iye pa'aj: —Aka' ƚiiji' pa' nite' wa'm Dios qu' hit'ij ewets yape enfeli'ƚ ye'mha, ¿me hik akha'ija pa' Cristo, Ƚaa'sija pa' Dios?— ");
INSERT INTO mca_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ha' Jesús qa yeku'ƚ: —I'woyaxijik'iha ka' ƚit'ij in hik yakha'. Qa hit'iƚij ewets iye ekheweli'ƚ in ƚi'weni'ƚ hatse' ha'ne Ƚa's na' Jukhew qu' na'ni'ju' na' yiya'yik'i nakha' Ham Ƚet'unhenye'ji'iju'ƚ in T'un, qa qu' nenekijju' iye ne' wasil ha'ne wa'sji'.— ");
INSERT INTO mca_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma' qa ha' pa'il ƚatata qa yiwjaf'itik'i pa' ƚ'uihitjiiƚe, qa yit'ij: —Eke' yit'ij ha'ne jukhew qi in uƚ'etsik'i ƚe'lijeyets pa' Dios. ¿Ƚekpa' qu' hami'ik'ui qu' nenfel iye pakhape' iye ƚunye'je'kii hane'en? Ekheweli'ƚ ƚepi'ye'eƚik'i ke' yit'ij in uƚ'etsik'i. ");
INSERT INTO mca_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pa'n ƚumti'iƚ qu' ƚenifenye'je' hane'en?— Qa yeku'ƚ pekhewe'en: —Ewi'ƚƚe in weju'ƚij qu' nawa'm.— ");
INSERT INTO mca_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma' qa tek'iije'mkii ƚeju's qa yi'wiƚtenji'ijje'm iye. Qa pekhewep qa yeqsilanje'm ƚeju's, ");
INSERT INTO mca_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","qa yitjiijets: —Akha', in hik akha' pa' Cristo ¿ƚekte'ek pa' nalan?— ");
INSERT INTO mca_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ha' Pedro i'niju' hakha' joofji'ju' ke' wititsi'ii. Ma' qa nekets pa'aj ke' ewi'ƚ witqejkunenki', qa yit'ijets: —Qete'e' hik akha' iye hekhewe' ƚijts'eyekji'ijkii ha' Jesús Galilea ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Qa hakha'ƚe'en qa welkut'ijkii qa week yepiikinij hekhewe'en in yit'ij: —Axe'm, nite' tsikfe'lets kakha' ƚit'ij.— ");
INSERT INTO mca_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma' qa ikii pa'aj qa i'ntaxi' pa'aj ha' ƚeji'ii, qa hik hakha'a' qa yi'weni' iye pekhep iye, pekhe'en qa yit'ijji'ju' pekhewep iye: —Hik ha'ne ha' ƚijts'eji'ijkii ha' Jesús Nazaret ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma' qa ewi'ƚij iye in welkut'ijkii, qa hats les in yatinhettaxik'i in welkut'ijkii: —Axe'm, yakha' nite' tsikfe'lets hakha' jukhew.— ");
INSERT INTO mca_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Qa sujƚe iye pa'aj pekhewe' i'ni' pakha'an qa nekets iye ha' Pedro qa yit'ijets iye pa'aj: —Yijaa'ija in hik akhap iye hekhewe' ƚijts'eyekkii. Hik anyejei qe iyetju'.— ");
INSERT INTO mca_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma' qa yapeƚek ha' Pedro in uƚ'axik'i ƚ'anye'j qa weniwjutsiqentaxijha iye in yit'ij: —Qu'nte' yijaayi'ija aka' hit'ij qa les ƚe'wis qek nastanithen pa' Dios. ¡Nite' tsikfe'lets hakha' jukhew!— Ma' qa hik pakha'aj qa ip pa' ta'a'a'. ");
INSERT INTO mca_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Qa ha' Pedro qa yijamti'ik'i pa'aj in hayiits yit'ijets ha' Jesús: —Qu' mente' nape' pa'qu' ta'a'aye' qa hats wetshetk'ewi'ƚij qu' newelku'tyijkii.— Ma' qa ikfik'i pa'aj ha' Pedro qa qi in ip pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ma' qa in hats leefiju' iye, qa week pa'aj hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye tenek'enheiji' ha' witset, qa not'axij wetju'ƚ iye qe qa' nilan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ma' qa in hats yophe'ƚ qa yeka'xii qu' netisij ha' Pilato, hikha' romano gobernador ipji' ne' judiol. ");
INSERT INTO mca_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ka' Judas hik kakha' t'ihinij ha' Jesús. In yi'wen in hats yijaa'ija qu' natlanhetii hatse' ha' Jesús qa qi in itawje'met qa yepilettaxets pa'aj pe' treinta (30) nijketits ne'ej plata hekhewe' tenek'enhe'yij he' pa'il qa he' tenek'enheiji' na' witset. ");
INSERT INTO mca_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Qa yit'ijets: —Qi in yuƚ'ax qe he'yihinij ma' qa' nawa'm nakha' jukhew ham uƚ'axe' qu' naqsiijkii.— Qa hekhewe'en qa yit'ijiju'ƚ pa'aj: —¡Nite' tsatsat'etsi'ƚij pa'qu' natawje'meten! ¡Akha'ƚe in ƚantsat'axij!— ");
INSERT INTO mca_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma' qa ka' Judas qa nijele'ejifi pe' ƚ'astayik'i ke' witlijtsitjii, qa ikfik'i pa'aj qa wetsifinpha'm. ");
INSERT INTO mca_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qa hekhewe' tenek'enhe'yij he' pa'il qa nat'a'ak'i pa'aj pe' ƚ'astayik'i, qa yit'ijju': —Ene' ƚ'astai hats nite' ƚeke' qu' netenenik'iju' nekhe' ti'najki' t'ejuyets ne' witlijtsitjii, qe enewe'en hats tajayij pe' wit'athits.— ");
INSERT INTO mca_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma' qa in hats week ƚexkelij iye, qa pe' ƚ'astai qa taqhayijets pa' ewi'ƚ sehe' ƚii Campo del Alfarero, hats'inha qa' hik pakha'ye' qu' ƚenimeƚku'wet'i'ij pe'qu' jukhewiikali'ik'i. ");
INSERT INTO mca_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Qa hik ta'ƚijupi' ha'ne sehe' in ƚenqiyij “Wit'athits Ƚetset.” Qa yamijii hane'ej in ƚenqiyij. ");
INSERT INTO mca_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma' qa hats yafits kakha' yit'ij pa'aj pa' Dios in i'nijji' pa' profeta'ik'i Jeremías qa yit'ij pa'aj: —Pekhewe'en qa t'eku'mi' pe' treinta (30) ƚ'astai nijketits plata, hik aka' ƚajanye'j pa' ewi'ƚ jukhew ƚaqjanyejeyij nekhewe' Israel ƚeiƚets. ");
INSERT INTO mca_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma' qa pe' ƚ'astai qa taqhayijets pa' sehe' ƚii Campo del Alfarero. Hik aka' yit'ij yiwets pa' Yatsat'axyij.— ");
INSERT INTO mca_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ha' Jesús qa wattsap'anhetijup pa'aj hakha' gobernador, qa hane'en qa nifaakan, qa yit'ijets: —¿Me akha' pakha' qi ƚatata ene' judío?— Qa yeku'ƚ pa'aj ha' Jesús: —I'woyaxijik'iha ka' ƚit'ij.— ");
INSERT INTO mca_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Qa hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye tenek'enheiji' hakha' witset in yittaxijetskii kekhewe' wekwek uƚ'ets yit'ijets in yaqsiijkii ha' Jesús, qa hakha'ƚe Jesús qa nite' yeku'ƚik'i. ");
INSERT INTO mca_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Qa hik ta'ƚijupi' pa'aj ha' Pilato in yit'ijets: —¿Me nite' ƚepiye' kekhewe' wekwek uƚ'ets wenit'ij ewetskii qu' aqsiijkii?— ");
INSERT INTO mca_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Qa ha' Jesús qa nite' yeku'ƚ. Qa nite' ewii'ƚe' iye pa'qu' nekuƚik'i pe' uƚ'etsik'i wenit'ijets in yaqsiijkii. Qa hik ta'ƚijupi' hakha' gobernador in qi in yitjuƚaxijpha'm. ");
INSERT INTO mca_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hakha' gobernador ha' witset, in hayiits ƚeqfenye'jji'jij qa yamji'jets ekewe' ƚe'sits neƚuts Pascua qu' niwejin pa'qu' ewi'ƚ wit'opheƚik'e' pakha' qu' niyinen pekhewe' jukhew. ");
INSERT INTO mca_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Qa na'l pa'aj hakha' ewi'ƚ qi in yinikfe'l wit'opheƚik ƚii Barrabás. ");
INSERT INTO mca_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Qa in hats ewi'ƚ i'ni' pa'aj pekhewe' olots, ha' Pilato qa nifaakanji'ju': —¿Ƚekpa' ƚisu'uni'ƚ qu' netwejinhetii ne' wit'opheƚii, me hakha' Barrabás, me i'nƚi'i nakha' Jesús, ƚenqii iye Cristo?— ");
INSERT INTO mca_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Qe ha' Pilato nikfe'lets hekhewe'en in tisij qe ta'ƚets in teqemtshenƚe'etskii. ");
INSERT INTO mca_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ha' Pilato in mexe i'nipji' pa'aj ha' ƚots'oji'la'x t'ejuyets in yejeƚik'ui pa'qu' ƚunye'je'kii (juez), pe' ƚewhe'ye' qa inqekenijii pe' ƚe'lijei, qa yit'ij pe' ƚe'lijei pe' efu: —Hasu'uj ma'ajets pa' ƚenifenye'j nakha' jukhew yatsathen, qe juka'x qi in uƚ'axik'i ka' yitsowoƚ'ax ta'ƚets nakha'an.— ");
INSERT INTO mca_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Qa hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye tenek'enheiji' ha' witset qa yaqsiijijetskii in yiyaji'etskii hekhewe' olots jukhew, ma' qa week iyinets qu' netwejinhetii ha' Barrabás qa hakha'ƚe Jesús qa' natlanhetii. ");
INSERT INTO mca_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ha' gobernador qa ewi'ƚij iye in nifaakanji'ju' iye: —¿Pa'n ƚunye'j pa'qu' netwejinhetii ene' wetsjuk wit'opheƚii?— Pekhewe'en qa yeku'ƚ: —¡Barrabás qu' netwejinhetii!— ");
INSERT INTO mca_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Qa ha' Pilato qa nifaakanji'ju' iye: —¿Qa pa'n qu' yeqfenyeji'ijek ha'ne Jesús ƚii iye Cristo?— Qa week yeku'ƚ pa'aj pe' jukhew qa yit'ijju': —¡Ne'nenji'pha'm pe'qu' cruze'!— ");
INSERT INTO mca_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ha' Pilato qa yittaxij iye pa'aj: —¿Inhats'ek? ¿Ƚekpa' uƚ'ax yaqsiijkii hane'en?— Pe' jukhew qa les yit'unhetik'i in taya'yijipji'kii, qa yit'ijju' iye: —¡Eni'ƚji'pha'm cruze'!— ");
INSERT INTO mca_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ha' Pilato in yi'wen in hats ham ƚeqfenye'ji'ij, qe ewi'ƚƚe in hats les yiwakanintaxkii hekhewe' jukhew, ma' qa inq'ukinii pa'aj pa'qu' iweli'ye' qa tetka'xii, qa yethinij he' week in wa'nqa', qa yit'ij: —Yakha' nite' ta'ƚ yiwets qu' nawa'm ha'ne jukhew yatsathen. Ekhewele'ƚi'iƚij.— ");
INSERT INTO mca_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Qa yeku'ƚ pa'aj pekhewe' week jukhew: —Ehe, yekheweli'ƚ qa enewe' yilitsi'ƚ, he'yeku'mi'ƚiju'ƚ qu' he'yenheti'yi'ƚi' qu' nata'ƚi'ƚ yiwets qu' nawa'm nakha'an.— ");
INSERT INTO mca_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma' qa ha' Pilato qa yiwejin pa'aj ha' Barrabás. Qa hakha'ƚe Jesús in hats yili'ij in yeqsilankii, ma' qa tisij pa'aj he' oq'opheƚinetsilets qe qa' ne'nenji'pha'm pe' cruz. ");
INSERT INTO mca_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma' qa pe' oq'opheƚinetsilets ƚelits pa' gobernador qa yeka'xifi pa'aj ha' Jesús ke' palacio, ma' qa he' oq'opheƚinetsilets qa week not'axij wetju'ƚ pa'aj hakha'an. ");
INSERT INTO mca_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Qa nit'ijji' pa'aj ke' ƚeqhinatai ma' qa yi'ntaafinij pa'aj pa' s'e' ƚeqi'ntaafit'ij. ");
INSERT INTO mca_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Qa yuihinji'ju' iye pa'aj pekhe' yifti'yik'i tii, qa pa' yiya'yik'i ƚokoi qa yekumhini' pa' tutsi'latax. Ma' qa wonokok'enifikii yawitjiƚe, qa yi'tjiijets: —E'ƚe'wisi'imkii, qi ƚatata ene' judiol.— ");
INSERT INTO mca_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Qa tek'iyi'kii iye qa t'eku'mijets iye pa' tutsi'latax ma' qa yilanijkii ƚeiƚa'. ");
INSERT INTO mca_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","In hats yili'ijju' in qi in yawitji pa'aj hakha'an, qa nifte'ji' iye pa' yi'ntaafinij s'e' qa yuihinik'ipha'm iye pa'aj ke' ƚeqhinataayija. Ma' qa yeka'xfik'i qe qa' nenji'pha'm pe' cruz. ");
INSERT INTO mca_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","In hats k'esitsiyu'uk'uifik'i ha' witset, qa weikutiju'ƚ ha' ewi'ƚ jukhew Cirene ƚeiƚe' ƚii Simón. Qa he' oq'opheƚinetsilets qa yiyaji'ijets qu' neka'xi'm ke' ƚeqe cruz ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Qa in hats yamijets hakha' ƚenqii Gólgota, ikji' aka'an, witjiƚa'ak'i ƚetset. ");
INSERT INTO mca_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Qa t'iyahanhetiitaxji' pa'aj pa' wino yetsji'ƚ pe' ewi'ƚ ne'ej inqa'metets ƚ'aftuk, ma' qa in hats yijaajintax pa'aj, qa yili'ij qa nite' niyayu'ji' qa t'oqowe'yiju'ƚ pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Qa in hats yenji'pha'm ke' cruz, qa ke' ƚeqhinatai qa watk'esaxijju', ikij wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ma' qa i'nijupju'kii qe qa' nejeƚets. ");
INSERT INTO mca_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qa ka' wankaaju'ƚetsju' ƚejiƚa' we'nika'ajji', hik kakha' ka' ta'ƚijupi' in talanhetii, qa yit'ij ka' we'nika'ajji': —Hane'en Jesús, hik ha'ne qi ƚatata ene' judiol.— ");
INSERT INTO mca_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Qa ƚe'nenhifetsji'pha'm iye ke' cruzits ke' wetsjuk ejtenhetsits. Ewi'ƚ ka' te'weyij yiya'yik'i qa kakhap qa ƚefeyi'j te'weyijek. ");
INSERT INTO mca_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hekhewe' nekjiijup qa yawitjijeetspha'mkii, qa yitjiij iye qhet tetet ƚeiƚal, ");
INSERT INTO mca_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ma' qa yitjiijetspha'm: —Akha' in ƚonopƚetju' hatse' ne' witlijtsitjii qa' wetshetk'ewi'ƚ neƚuts qu' eniihinpha'm iye, meteƚinƚe. Qu' yijaa'ija qu' Ƚa'se'ejha pa' Dios qa' ilit'ik'uiju' ne' cruz.— ");
INSERT INTO mca_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Qa hik ƚunyejei iye hekhewe' tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei qa hekhewe' iye tenek'enheiji' ha' witset in yawitji'etspha'mkii iye qa yit'ijju': ");
INSERT INTO mca_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Niƚinji'ijju' pekhewep qa ƚakha'ƚe qa nite' ƚeke' qu' neteƚinƚe. Hik ha'ne pa' ƚatata ne' Israel, ye'ehe, qa' net'ilitju' in we'nenji'pha'm ne' cruz, ma' qa hayitse' yijat'ij qu'nte' jinteqekuye'. ");
INSERT INTO mca_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","In nite' yeqeku' pa' Dios, ye'ehe qa' hik pakha'ye' qu' niƚin hane'ej qu' yijaa'ija pa' Dios qu' nisu'un nakha'an, qe nakha'an yit'ij: “Yakha' Ƚaa'sija pa' Dios.”— ");
INSERT INTO mca_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Qa hik ƚunyejei iye ke' ejtenhetsits ƚenenhefetsji'pha'm ke' cruzits uƚ'etsik'i iye ƚe'lijeyetskii. ");
INSERT INTO mca_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","In hats natsathenju' junu' qa weekij ha' sehe' in nookii yamijii in las tres metju' junu'. ");
INSERT INTO mca_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hik pakha'aj ha' Jesús qa t'unik'i in tayaikii: —Elí, Elí, ¿lema sabactani?— Ikji' aka'an: —Dios Yatsat'axyij, Dios Yatsat'axyij, ¿inhats'ek in ƚetswu'm?— ");
INSERT INTO mca_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Qa hekhewe' i'nijup, hekhewe' uja'x in yepi'ye', qa yit'ijju': —Hats taya'yiikii pa' profeta'ik'i Elías.— ");
INSERT INTO mca_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Qa aje'eƚ hakha' ewi'ƚ hekhewe'en qa wekuma'xii ka' ewi'ƚ jupayek (esponja) qa yuihinji'ju' ka' wino na'aj ewtsik'iiji' yilke'ej ji'teje'm ka' tutsi'latax ma' qa iktaxijets qu' nifunenij qe qa' niyahan. ");
INSERT INTO mca_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Qa hekhewepƚe qa yit'ijju': —Iwejinƚe, qa' jintejeƚijju' pa' Elias'ik'i qu' nanamii qa' niƚin.— ");
INSERT INTO mca_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma' qa ha' Jesús, qa ewi'ƚij iye in t'unik'i in tayai iye, ma' qa wa'm. ");
INSERT INTO mca_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Qa hik pakha'aj kakha' ƚenjilafi' hakha' yeqet'axetsji' ke' witlijtsitjii qa ja'fik'iju' ƚeqewuk'u ta'ƚijiipha'm in ja'fik'iju' ka' te'weipha'm qa yamijiiju' ka' sehe' eju'. Qa ha' sehe' qa me'le'le'l iye qa ke' utel qa jaf'afju' iye. ");
INSERT INTO mca_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Qa pe' nimeƚkui qa qhofik'i iye pa'aj qa olots pe' jukhew'ik'i, efuts'ik'i yatsathen ma' qa' iƚii iye. ");
INSERT INTO mca_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Qa ikik'uifik'ikii pe' ƚenimeƚkui in hats iƚa'x iye pa'aj ha' Jesús, pekhewe'en qa ikji'teje'm iye na' qi ƚe'wis witset Jerusalén qa olots he' yi'wen pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hakha' centurión qa hekhewe' iye i'nijup yejeƚets ha' Jesús, in yi'wen in wapja' ha' sehe' qa kekhewe' iye wekwek ƚunyejeikii qa qi in nijiwei wetju'ƚ, ma' qa yit'ijju': —Yijaa'ija aka'an in hik aka' pa' Ƚaa'staxija pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Olots he' efuts nejeƚi'iikii totsi'mii ha' i'ni', hik hekhewe' ƚijts'eyekkii ha' Jesús in ta'ƚiji' ek ha' Galilea'ai in t'ifti'ts'etskii. ");
INSERT INTO mca_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Hekhewe'en i'nji'teje'm ke' María Magdalena qa ke' María ƚenene ha' Jacobo (Santiago) qa ha' José qa ke' ƚenene he' ƚelits ha' Zebedeo. ");
INSERT INTO mca_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","In hats metiyu'ju' junu' qa namets pa'aj ha' ewi'ƚ jukhew yiwq'axin wekwek, ƚii José Arimatea ƚeiƚe', ƚakha' iye hats yijayan qa tek'enets iye ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ha' José qa mexe yamii pa'aj ha' Pilato qu' niyinijets ka' Jesus'ik'i qu' neka'x. Ha' Pilato qa inaqyaji'ij qu' netesti'yij. ");
INSERT INTO mca_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ha' José qa t'eku'mi'fi pa'aj ka' Jesús ma' qa yijuphe'ƚji' ka' penyilo ƚe'wis. ");
INSERT INTO mca_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma' qa yenifi ke' yatsat'axij in ƚenimeƚuktax ink'aiki' inqajkaninijju' pa'aj ke' utekji'teje'm. Ma' qa in hats yikoyoyinhetets in yit'onijji' ke' qi ute ha' ƚenuihiyi'jteje'm ke' nimeƚuk, ma' qa ik. ");
INSERT INTO mca_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Qa ke' María Magdalena qa kikhep iye María iye, qa ipƚu' pa' i'nijupi'ju'kii pa'aj ke' nimeƚuk. ");
INSERT INTO mca_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ka' neƚuji' watji'letji' pe' witqats qa kakhap neƚuji', qa hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye fariseol qa yamii pa'aj ha' Pilato, ");
INSERT INTO mca_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","qa yit'ijets pa'aj: —Yatsat'axyij, hijamti'iƚik'i ka' yit'ij ka' ejtitsi'l jukhew'ik'i in mexe iƚa'x, qa yit'ij: “Qu' namets wetshetk'ewi'ƚ neƚuts qa' yi'ƚa'xe' iye.” ");
INSERT INTO mca_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Qa hik ta'ƚijupi', akha' qu' inaqyaji'ij qu' netjeƚitiyetsha ke' ƚenimeƚuk namijii qu' wetshetk'ewi'ƚe' neƚutse', hats'inha qu' nite' neneki'ii he' ƚ'ijatshenhei ma' qa' net'ejtenij, ma' qa' i'nk'aƚe nit'ijets ha'ne witset: “Hats iƚa'x iye.” Qa pakha' teke'lenju' qu' ƚe'wejtitsiye' qa' les qu' qi qu' uƚ'axe' wiikfik'i, qa' nite' hik ƚunye'je' ka' yojo.— ");
INSERT INTO mca_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Qa yit'ijiju'ƚ ha' Pilato: —Enewe'en oq'opheƚinetsilets eka'xi'ƚ, qa' ejeƚineni'ƚij pe' ƚesehek qa aqsiiƚijkii pakha' hats ƚenikfe'li'ƚets qu' aqsiiƚijkii.— ");
INSERT INTO mca_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma' qa ikkii qa yijanithen pe' nimeƚuk, qa yeni' pa' ƚeji' pe' ƚeq'ikati' qa' jutsiqaxi'ij qu' ham nit'i'ij qhof. Ma' qa amaneyijup he' oq'opheƚinetsilets qa yejeƚ. ");
INSERT INTO mca_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","In hats t'anji' kakha' neƚuji' sabadoji', in i'nk'a nekiyupha'm pa'aj ne' junu' ka' yojo neƚuji' (domingo), ke' María Magdalena qa kikhep iye María ikii pa'aj ke' nimeƚuk qu' ni'wen. ");
INSERT INTO mca_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","In mente' yamets pa'aj qa t'unik'i in me'le'l pa'aj ha' sehe' qe te'nilitju' pa' ƚaqa ángel ha' Yatsat'ax'inij qa ikets ke' nimeƚuk qa yit'ij qhof ke' ute ƚit'otax qa i'nipji'. ");
INSERT INTO mca_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pa' ángel leppepep pa'aj hik ƚunye'j na'aj etheluna'x, qa pe' ƚeqhinatai qa fo' hik ƚunyejei ƚ'ifiwa'x. ");
INSERT INTO mca_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pe' oq'opheƚinetsilets in yi'wen pa'aj qa yitsalalinhet wetju'ƚ qe qi in nijiwei. Ma' qa week namju'kii hik ƚunyejei qu' nanaxju'. ");
INSERT INTO mca_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pa' ángel qa yit'ijets pa'aj he' efuts: —Ekheweli'ƚ, e'nijiweikitek'iƚ, qe yakha' tsikfe'lets in ƚowotaxiƚiikii ha' Jesús hikha' we'nentaxji'pha'm ke' cruz. ");
INSERT INTO mca_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hats nite' i'ni' hane'e'in. Hats iƚa'x iye ka' hats yit'iƚij ewets. Te'ƚuni'ƚ qa' jeƚi'ƚ ha'ne we'nentaxi'. ");
INSERT INTO mca_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Qa' if'elitiƚik'i qu' enfeli'ƚii he' ƚ'ijatshenhei in hats iƚa'x iye. Ƚakha' wathayinti'iƚ ek'uyii ha' sehe' ei Galilea, qa' hikha' tit i'weni'ƚi'. Hik ekewe' tit k'efeli'ƚi'm.— ");
INSERT INTO mca_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma' qa he' efuts qa yapeƚek pa'aj qa ikik'ui ke' nimeƚuk itaqsunkiiha. Qi in nijiweitax qa qiiƚe iye in ƚe'sitsi'mkii, wekuma'xijii pa'aj qu' nenfeli'm he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Qa hik pakha'aj, ha' Jesús qa we'nethinets pa'aj hekhewe' efuts qa wetfeli'm. He' efuts qa ikets pa'aj qa wonokok'enifikii qa tik'eyijup ƚef'iyeyiiju' qa iyinets. ");
INSERT INTO mca_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma' qa ha' Jesús qa yit'ijets pa'aj: —E'nijiweikitek'iƚ. Yape ma'aƚkii qa' enfeli'ƚi'm he' yejefets qu' nakkii namii ha' sehe' Galilea qa' hikha' netsweni' hatse'.— ");
INSERT INTO mca_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","In hats ikkii pa'aj he' efuts, ma' qa pe' uja'x pekhewe' oq'opheƚinetsilets qa ikii pa'aj ha' witset qu' nenfelimik'i pekhewe' tenek'enhe'yij pe' pa'il week aka' ƚunye'jkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pe' tenek'enhe'yij pe' pa'il qa ikii qu' nonot'axi'ƚ wetju'ƚ pekhewe' tenek'enheiji' pa' witset, qa tafaakate'yijju' pa'qu' ƚeqfenyejeyi'ij ƚewek. Ma' qa tisij pe' olots ƚ'astai pe' oq'opheƚinetsilets. ");
INSERT INTO mca_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Qa yit'ijets pa'aj: —Aka' it'iƚij: “He' ƚ'ijatshenhei namii pa'aj aka' najaxik'i qa t'ejtenij pa'aj ka' Jesus'ik'i yekheweli'ƚ in qi in hama'aƚju'.” ");
INSERT INTO mca_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Qa qu' nenikfe'ltaxets nakha' gobernador, qa' yekheweli'ƚ qu' haifaakateyi'ƚju' qa' ham peyi'ijkii qa ekhewelƚi'iƚ qa' ikesimen ƚi'iƚkii.— ");
INSERT INTO mca_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pe' oq'opheƚinetsilets qa t'eku'miju'ƚ pe' ƚ'astai ma' qa week yaqsiijkii aka' hats wenit'ijets pa'aj. Qa aka' wit'anye'j qa hik aka' week i'ye'ej wetju'ƚ ne' judío qa yamijii hane'ej. ");
INSERT INTO mca_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Qa hekhewe'ƚe once (11) ƚ'ijatshenhei ha' Jesús qa ikkii qu' namii ha' sehe' Galilea, ke' utek'ii hats yiwjutsiqenik'uyii ha' Jesús qu' newe'tweniƚi'. ");
INSERT INTO mca_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Qa in yi'wen hekhewe'en ha' Jesús qa week wonokok'enju'kii. Qa uja'x hekhewe' nite' tu'u numtiye'taxija qu' hik hakhaayi'ija. ");
INSERT INTO mca_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma' qa ha' Jesús qa ikets, qa yit'ijets: —Na' Dios hats week tseƚisij qu' heinek'enhe'yij na' wa'sji' qa ha'ne sehe' ipji' iye. ");
INSERT INTO mca_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yape ma'aƚik'i week ene' witsetits qa' ijatsheni'ƚij qu' natsjayan iye qa' impulijini'ƚji' ka' ƚii na' Tata qa ha'ne Ƚa's qa na' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Qa' ijatsheni'ƚij hats'inha qu' netk'enik'i ke' week hats k'ijatsheniƚij. Menikfelitiƚetsha in Yakha' nite' k'itoni'ƚ week neƚuts ha'ni'ƚ ejupkii yamijii qu' hame'tax ha'ne sehe'.—");
INSERT INTO mca_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hane'ej in i'nk'aa i'nju' eke' ƚe'sits wi'tlijei t'ejuyets ha' Jesucristo, hikha' Ƚa's pa' Dios. ");
INSERT INTO mca_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Qa in ƚ'anye'jek kakha' yika'ajji' pa'aj pa' profeta Isaías, in yit'ij: —Jeƚ qeku'nek, hukin hatse' na' yukine'k qu' nathayin ek'ui, qa' hikna' naqsi'jik'i pa'qu' ikheyi'je'. ");
INSERT INTO mca_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tepiikaxtii pa' ƚ'a'x pa' taya'yi'kii pa' ham i'ni'i' in yit'ij: “Aqsi'ji'ƚik'i pa'qu' ƚikheyije' pa' Yatsat'ax'inij, qa' natsathen iye hasu'uj q'if'imme' pe'qu' ƚ'ikheijeye'.”— ");
INSERT INTO mca_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ka' Juan Bautista qa te'wenheti'yi' ha' ham i'ni'i', qa nifel in wenqinpuujin t'ejuyets pa'qu' nili'ij pa' uƚ'ax qa' netwumhiti'yik'ui pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Qa week namii hekhewe' witsetits ha' sehe' Judea, qa week iye hekhewe' jukhew qa efuts ta'ƚii ha' Jerusalén. Ma' qa in tetfelji'jij pe' ƚewuƚ'ets qa ka' Juan qa nimpuujinji'ju' ha' haqqi' ƚii Jordán. ");
INSERT INTO mca_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ke' ƚeqhinatai ka' Juan ats'etets ƚ'ewkujits qa ka' ƚeqelutsax qa inqa'met ƚ'aj. Qa ka' ƚaq qa efenheyik'i qa na'aj ƚene'ji' witaq. ");
INSERT INTO mca_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Qa yit'ij in i'nq'ijatshen: —Teke'lenju' hatse' qu' nanam ha' ewi'ƚ les t'anyipji'. Yakha' nite' ye'weju'ƚij qu' he'yupi'yetsju' qu' henit'ijji' pe' ƚeqniihayij pe' ƚ'otshilaxtii. ");
INSERT INTO mca_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yakha' iweli'ƚe ha'ne k'empuujini'ƚji'. Qa hakha'ƚe'en hatse' qa' nempuujini'ƚji' pa' Espíritu Santo.— ");
INSERT INTO mca_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hik aka'aj kekhewe' neƚutsji', ha' Jesús ta'ƚii ha' witset Nazaret ha' sehe' Galilea, ka' Juan qa yimpuujinji' ha' haqqi' Jordán. ");
INSERT INTO mca_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Qa aje'eƚ, in hats nekik'uipha'm ha' iweli', qa yi'weniipha'm na' wa's in qhofij, qa pa' Espíritu Santo qa te'nilitju' hik ƚunye'jtax ofo' qa i'nipji' hakha'an. ");
INSERT INTO mca_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Qa nokesji'pha'm na' wa's pa' wit'ax in yit'ij: —Akha' K'ayaasija qi in k'esu'un. Akha' qi in ƚets-sinheti'mkii.— ");
INSERT INTO mca_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Qa aje'eƚ pa' Espíritu Santo qa yeka'xii ha' Jesús pa' ham i'ni'i'. ");
INSERT INTO mca_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Qa i'ni'kii pa' ham i'ni'i' yamijets cuarenta (40) neƚuts, pa' inwo'met qa yijaajinji'ijtax pa'aj. Qa ewi'ƚ i'ni'ƚi' iye pe' inqa'metets, qa pe' angelits qa t'ifti'ts'etskii pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka' Juan in hats wenuihinifi ke' witq'opheƚitjii, ha' Jesús qa yamii ha' Galilea qa nifel ke' ƚe'sits ƚe'lijei pa' Dios, ");
INSERT INTO mca_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","qa yit'ij: —Ha'ne hane'ej ƚahats'ij hats yafits qa' hats ƚ'aka'the' ye'ƚe qa na' tenek'enheiji' na' Dios qa hats met. Yape ili'iƚij in ƚaqsi'ji'ƚijkii pa' uƚ'ax qa' hasu'uj eqeku'uƚik'i iye eke' ƚe'sits wi'tlijei.— ");
INSERT INTO mca_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ha' Jesús in ikik'ipha'm ha' ƚotkoyek ke' kaƚi' Galilea, qa yi'wen pa'aj ha' Simón qa ha' ƚek'inij Andrés in yiwu'mji'ijji'ju' ke' ƚeq'ehemki' ha' iweli' in teq'ehemkiiju' qe hik aka' ƚ'ithayijkit ek. ");
INSERT INTO mca_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ha' Jesús qa yit'ijets hekhewe'en: —Atsjayani'ƚ qa yakha'ye' qu' haqsiijkii qu' eq'ehemki'yi'ƚii ene' jukhew.— ");
INSERT INTO mca_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma' qa aje'eƚ yili'ij he' ƚeq'ehemkil qa yijayan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Qa ik iye qa ha'nii yamji' iye qa yi'wen iye ha' Jacobo (Santiago) ƚa's ha' Zebedeo qa ha' ƚek'inij Juan i'ni'ƚji' ke' ƚenhitjii yitiƚ ke' ƚeq'ehemkil. ");
INSERT INTO mca_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Qa aje'eƚ taya'yiiji', hekhewe'en qa yiwejinƚi'i ha' ƚatata Zebedeo ke' ƚenhitjiiji' qa hekhewep iye ƚeq'ithayinenhei, ma' qa yijayan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hekhewe'en qa uiji'teje'm ha' witset Capernaum. Qa in yamets ka' neƚuji' witwapiihijii (sábado) ha' Jesús qa aje'eƚ yamii qa uyifi ke' witlijtsitjii, ma' qa hik aka'aj qa i'nq'ijatshen. ");
INSERT INTO mca_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","He' jukhew qa efuts qi in yitjuƚaxijpha'mkii qa yisu'unik'i iye, qe in i'nq'ijatshen hik ƚunye'j na'aj ewi'ƚ qe qi qe tenek'enhei, qa nite' ƚunyejei he' i'nq'ijatshenij ke' Moisés ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hik aka'aj ke' ƚe'lijtsitjiyifi hekhewe'en, ewi'ƚ ha' jukhew i'nji' pa' ewi'ƚ espíritu uƚ'ax, hakha'an qa yapeƚek qa tayai, ");
INSERT INTO mca_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","qa yit'ij: —¿Ƚekpa' ƚanami'ƚ yijii, Jesús Nazaret ƚeiƚe'? ¿Ye' me hats ƚanami'ƚyii qu' etswuƚ'enheti'ƚju'? Yakha' tsikfe'l ewets pa'n ejunye'j, akha' eƚ'ewi'ƚƚe in ƚataƚiiha pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ha' Jesús qa yaq'ayinij, qa yit'ijets: —¡Ewuikitek, qa' ma'ak'uifik'i nakha' jukhew!— ");
INSERT INTO mca_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Qa pa' espíritu uƚ'ax qa yitsalalinhetkii ha' jukhew, qa yit'unhetik'i in tayai, ma' qa ikik'uifik'i ha' jukhew. ");
INSERT INTO mca_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Week qi in yitjuƚaxijpha'mkii aka'an qa watfaakanji'ijju': —¿Inhats'ek, pa'n ƚunye'jkii? ¡Kakha' ƚeq'ijatshenkenye'j i'nk'aƚe jitepi'ye'ek'i, qa hik ƚunye'j na'aj qi qe tenek'enhei! ¡Nakha'an yiyaji'ets iye pe' inwo'metets qa tek'eniju'ƚ!— ");
INSERT INTO mca_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma' qa pa' ƚeniihe't qa aje'eƚ weekij he' pekhelji'kii witsetits qa he' ƚekuweliikii ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","In hats ikik'uifik'ikii ke' witlijtsitjii, hekhewe'en qa aje'eƚ ƚeyijii ke' ƚetsi' ha' Simón qa ha' Andrés, qa ƚijts'eyek ha' Jacobo (Santiago) qa ha' Juan. ");
INSERT INTO mca_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ke' ƚeqewketi' ha' Simón i'wju' qe qi in iwilhan, qa aje'eƚ tefelhiti'yi'm ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ha' Jesús qa ikets qa t'eku'mi' ha' ƚokoi qa niihinpha'm, qa hik akaa'ijha in hamiikii in iwilhantax, kikhe'en qa yithayiki'iji' ka' ƚaq wete'm. ");
INSERT INTO mca_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","In hats lef'eyu'kii in hats uiju' junu', qa yapeƚek qa tetka'xii ha' Jesús he' week he' wanqaats'eju' qa hekhewe' iye i'nji' pe' inwo'metets. ");
INSERT INTO mca_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Qa weekij ha' witset in k'aƚaƚij ha' ƚeji' ke' wititsi'. ");
INSERT INTO mca_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Qa olots he' niƚinju' hekhewe' pekhel ƚawtshenyejeitaxkii qa olots iye he' yukinik'uifik'ikii pe' inwo'metets, qa nite' ƚexke'eji'm iye qu' niyet pe' inwo'metets qe ƚekhewel nikfe'lets pa'n ƚunyee'jija hakha'an. ");
INSERT INTO mca_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","In mexe ipƚu'uikii pa' neƚu, ha' Jesús qa niipha'm pa'aj qa ikfik'i, qa ikii pa'aj ha' ham i'ni'i' qa hikha' qa iyini'. ");
INSERT INTO mca_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ha' Simón qa hekhewep iye qa wo'taxiikii. ");
INSERT INTO mca_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma' qa in hats yi'wen, qa yit'ijets: —Week wotax'eikii.— ");
INSERT INTO mca_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ha' Jesús qa yit'ijets: —Yape jiyamii pakhape' iye witset'e, nekhewe' metits witsetits, hats'inha qu' nek'inq'ijatsheni' iye nekhewe'en, qe hik aka' ta'ƚijupi' in tsam.— ");
INSERT INTO mca_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma' qa hik aka' ƚunye'j ha' Jesús in ikik'i ne' week witsetits na' sehe' Galilea qa i'nq'ijatshenjiifi he' ƚe'lijtsitjiyits he' witsetits qa yukinjiik'uifik'ikii iye pe' inwo'metets pe' i'ntaxji'. ");
INSERT INTO mca_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ewi'ƚ ha' jukhew i'nij ka' witaja'me't lepra nekets qu' niyinets ha' Jesús, qa wonokok'enifi, qa yit'ijets: —Qu' isu'un, qa' ƚeke'ye' qu' etsiƚin wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ha' Jesús qa qi in neq'eletij qa t'eku'mets, qa yit'ijets: —Hisu'un qu' k'eƚin, qa hane'ejija qu' anaxpa'l.— ");
INSERT INTO mca_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Qa aje'eƚ hamiikii ka' ƚaatshektax, ma' qa naxpa'lij. ");
INSERT INTO mca_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma' qa ha' Jesús qa aje'eƚ wetfeli'm qa qi in yiyajitaxetskii, ");
INSERT INTO mca_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","qa yit'ijets: —Jeƚiju'ƚ, hasu'uj enfeli'm pe'ye'. Maƚe qa' me'nethinii hakha' pa'i qa' eyijii pa'qu' eqisit'e (ofrenda) qu' net'ejuyets in hats ƚanaxpa'lij ka' awtshektax qe hik ƚ'anye'j ka' Moises'ik'i, hats'inha qu' week nenikfe'lets in hats ƚanaxpa'lij ka' aja'me'ttax.— ");
INSERT INTO mca_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Qa hakha'ƚe jukhew, in hats ik qa yapeƚek qa yit'unhetik'i in nifelkii ma' qa week i'ye'ej wetju'ƚ aka' ƚunye'jkii. Qa aka'an in ta'ƚijupi', ha' Jesús qa hats nite' ƚexke'ej qu' ninikfe'l qu' nuiji'teje'm pa'qu' witset'e. Ma' qa i'ni'kii he' ham i'ni'i' pe'qu' jukhewe', qa weekƚe namii he' pekhelji'kii witsetits qe neqwenkeyu'uj. ");
INSERT INTO mca_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Qa in hats teƚuyik'i, ha' Jesús qa wapilii iye ha' witset Capernaum, qa yinikfe'l in hats i'ni' iye ke' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma' qa aje'eƚ namii he' olots jukhew qa efuts, qa hats topo'oj ke' wititsi' qa uja'x he' i'nfik'i hats ham ƚetset'e. Ham ƚ'uihiyije' qe hats topo'oj ha' ƚeji' ke' wititsi'. Ha' Jesús qa yijatshenij ke' ƚe'lijei pa' Intata. ");
INSERT INTO mca_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Qa namkii he' ikwetju'ƚ (4) jukhew neka'x ha' ewi'ƚ onqok. ");
INSERT INTO mca_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Qa in ƚunye'jek in nite' ƚeke' qu' nametsji' qe olots he' jukhew qa efuts qa ham ƚ'uihiyije', ma' qa weƚijipji' ke' wititsi' qa yitju'etsju' ha' wankaajuƚetsju' ha' Jesús. Qa in hats yitju'etsju' ma' qa yatsjiƚinijetsju' ha' witiwhi'la'x hikha' i'wji'ju' ha' onqok ha' wankaajuƚetsju' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ha' Jesús in yi'wen hekhewe'en in nite' yeqeku', qa yit'ijets ha' onqok: —Ya's, ke' ewuƚ'ets hats wetwu'm ek'ui.— ");
INSERT INTO mca_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","He' i'nq'ijatshenij ke' Moisés ƚe'lijei ipƚulets ha' i'niju'kii, ƚatawjetsƚeji' aka' yit'ijju' in yijamti'ets: ");
INSERT INTO mca_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Maa, ¿pa'n ƚahats hape in ƚ'anye'j ha'ne jukhew aka'an? Yiwakaninƚekii pa' Dios, ewi'ƚƚe inek pa' Dios qu' niwu'm i'nk'ui pe' inwuƚ'ets.— ");
INSERT INTO mca_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ha' Jesús qa hatsƚe aje'eƚ nikfe'lets aka' yijamti'ets hekhewe'en, qa yit'ijji'ju': —¿Inhats'ek in ƚumti'iƚ kakha'an? ");
INSERT INTO mca_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Pa'n ikji' pa'qu' les nite' juutsitaxe' qu' jintit'ijets ha'ne onqok: “Me pe' ewuƚ'ets hats wetwu'm ek'ui,” me i'nƚi'i qu' jintit'ijets: “Eniipha'm ku'mi' na' ewhi'la'x qa' ma”? ");
INSERT INTO mca_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ye'ehe, qa qu' enikfe'li'ƚets hane'ej ha'ne Ƚa's na' Jukhew in na'li'm pa' ƚet'unha'xijup ha'ne sehe' ipji' qu' niwu'm pe' witwuƚ'ets.— Ma' qa yit'ijets ha' onqok: ");
INSERT INTO mca_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Akha' hit'ij ewets: “Eniipha'm, ku'mi' na' ewhi'la'x qa mapilii pe' etsi'.”— ");
INSERT INTO mca_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Qa hakha'an qa aje'eƚ niipha'm, qa t'eku'mi' ha' ƚewhi'la'x qa ikfik'i, qa week yi'wen. Ma' qa qi in yitjuƚaxijpha'mkii he' week qa qi iye in yiwqinhetji' pa' Intata, qa yit'ijju': —Nite' hayiits qu' ƚunye'je' pa'qu' jinte'wen aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ma' qa i'nk'aƚe qa ik iye ha' Jesús qa wapiliiju' iye ha' ƚotkoyek ke' kaƚi', ma' qa nekets iye he' olots jukhew qa efuts, ma' qa yijatshen. ");
INSERT INTO mca_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","In ikkii iye qa yi'wen ha' Leví, ƚa's ha' Alfeo, i'niju' ha' taja'yikii ne'ej wekwek. Ha' Jesús qa yit'ijets: —Atsjayan.— Ma' qa niipha'm qa yijayan. ");
INSERT INTO mca_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma' qa i'nk'aƚe ha' Jesús qa he' ƚ'ijatshenhei qa teki'ju' ke' ƚetsi'ii ha' Leví. Qa olots he' yijaninkii ke' wekwek qa hekhewe' iye uƚ'ets jukhew in ƚekufetsij, qe olots he' nijayanik'i hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Qa he' fariseol hik hekhewe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei, in yi'wenij in ƚekufets ha' Jesús hekhewe' uƚ'ets jukhew qa hekhewe' iye yijaninkii wekwek, qa yit'ijets he' ƚ'ijatshenhei: —¿Inhats'ek nakha'an in ƚekufets ne' yijaninkii ke' wekwek qa ne' uƚ'ets jukhew?— ");
INSERT INTO mca_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ha' Jesús in yepi'ye' ek'i aka'an, qa yit'ij: —Nite' wo'oikii weihetaxe' witeqjunhetits ƚeiƚe'ye' nekhewe' ham yaats'eyi'iju', ni'kha'ƚi'ij wanqaats'e' hik na'aj wo'oikii yijat'ij weihetaxe' witeqjunhetits ƚeiƚe'ye'. Nite' tsam ma' qa' haiya'yii nekhewe' yatsathen, qe uja'xƚe yijat'ij nekhewe' uƚ'ets.— ");
INSERT INTO mca_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hekhewe' ƚ'ijatshenhei ka' Juan qa hekhewe' fariseol, yaqsi'j jiijkii qa nite' tekji'ijju'. Qa nekets ha' Jesús, qa nifaakan, qa yit'ijets: —¿Inhats'ek hekhewe' ƚ'ijatshenhei ka' Juan qa hekhewe' iye ƚ'ijatshenhei he' fariseol in yaqsi'j jiijkii qa nite' tekji'ijju', qa enewe'ƚe ijatshenhei qa nite' hik ƚeqfenyejeyij?— ");
INSERT INTO mca_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ha' Jesús qa yit'ijiju'ƚ: —¿Me ƚeke' pekhewe' ƚejuwaikal pa' niwhe'yeyu' qu' naqsiijkii qu' nite' neteke'ju' in mexe i'nji'teje'm pa' niwhe'yeyu'? Qa nite' ƚeke' qu' naqsiijkii qu'nte' neteke'ju' qe mexe i'nji'teje'm nakha'an. ");
INSERT INTO mca_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nam hatse' na' neƚuji' na' niwhe'yeyu' qa' newetkax, qa hik nakha' na' neƚuji' qu' nite' neteke'ji'. ");
INSERT INTO mca_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ham yok'oyini'ij na'aj ewi'ƚ witqhinawat ƚawa'ma'x pa'qu' ƚepk'eye'en ink'ayik'e qe na'aj ink'ayik wapilje'm qa nite' qi, qa' niwjafitik'i pa'qu' ƚawa'ma'xe' ma' qa' les net'ijaifik'i pa'qu' ƚawjaf'iye'. ");
INSERT INTO mca_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Qa nite' ƚeke' iye qu' na'natsi'yik'iju' ink'ayik'e winoye' ne' ƚ'ajits eƚi'nilij ƚawa'mhii. Qe na'aj ink'ayik wino in ju'fju'fik'i qa tike'ƚijje'm ne' eƚi'nil ƚawa'mhii qa' week hame' pa' wino'ok'i qa pe' eƚi'ni'ik'i iye. Ma' qa hik ta'ƚijupi' qu' eni'ƚji' yijat'ij pa'qu' ink'ayik'e winoye' pe'qu' ink'aiki'ye' ƚ'aje' eƚi'niye' hats'inha qa' week ƚunyejeyi'iƚ yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","In yamets ka' witwapiihijii (sábado) ha' Jesús in ik qa nekik'iju' ha' wit'enekju', qa he' ƚ'ijatshenhei qa teiƚi'ijkii in nit'ijji' ke' ƚei trigo qa tuj. ");
INSERT INTO mca_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma' qa he' fariseol qa yit'ijets ha' Jesús: —Jeƚ qeku'nek, ¿inhats'ek in yaqsiijkii aka' nite' ƚenexke'ej in mexe witwapiihijii (sábado)?— ");
INSERT INTO mca_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ha' Jesús qa yit'ijiju'ƚ hekhewe'en: —¿Me nite' les qu' ejeƚi'ƚ na' witfaakanek kakha' yaqsiijkii ka' David'ik'i qa ke' ƚijts'eyek haamija pa'qu' ƚaqe' qa qi in iyipkunju'? ");
INSERT INTO mca_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ka' David'ik'i qa uyetsji' ke' t'ejutshenheti'yets na' Dios, ka' ƚahats'ij mexe qiji' in pa'i ipji' kakha' Abiatar'ik'i, ka' David'ik'i qa tuj ke' pan qa weeki'ƚij ke' ƚijts'eyek. Ke' pan nite' ƚenexke'ej qu' netujƚe pe'ye', uja'xƚe ne'ej pa'il in ƚenexke'ej qu' netuj.— ");
INSERT INTO mca_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Qa yit'ij iye: —Ha'ne neƚu witwapiihijii (sábado) in wanaqsi'jijkii qe qa ni'fen ene' jukhew, qa nite' wanaqsiijkii qu' natsat'etsipji' ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Qa hik ta'ƚijupi' ha'ne Ƚa's na' Jukhew in hik ha'ne tenek'enhe'yij na' neƚu witwapiihijii.— ");
INSERT INTO mca_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ha' Jesús qa uyifi iye ke' witlijtsitjii, qa hik hakha'a' ha' ewi'ƚ jukhew yisƚax ka' ƚokoyik'i. ");
INSERT INTO mca_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","He' jukhew yejeƚijju' qe qa' ni'wenij qu' niƚinji' in mexe witwapiihijiitax (sábado), hats'inha qu' ƚeke'ye' qu' nit'ijets qu' uƚ'axe' qu' naqsiijkii aka'an. ");
INSERT INTO mca_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma' qa ha' Jesús qa yit'ijets ha' jukhew yisƚax ka' ƚokoyik'i: —Eniipha'm. Ats'ap'ayi'i' hane'e'in ha'ne ƚeqewuk'uji'.— ");
INSERT INTO mca_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Qa ha' Jesús qa nifaakanji'ju' hekhewe'en: —¿Ƚekpa' ƚeke' qu' jintaqsiijkii ha'ne witwapiihijiiji' (sábado)? ¿Me pa' ƚe'wis, me i'nƚi'i pa' uƚ'ax? ¿Me jitiƚin pa'qu' ewi'ƚe', me i'nƚi'i qu' jintalan?— Qa hamƚe yeku'ƚe' hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ha' Jesús qa yeeƚji'teje'm hekhewe'en lesƚe in nayu'kii qa ika'metkii iye qe ta'ƚijupi' hekhewe'en in t'units pe' ƚatawjets qa nite' nek'enheyu'ets. Ma' qa yit'ijets ha' jukhew: —Ijin na' okoi.— Qa yijin ha' ƚokoi qa aje'eƚ naxpa'l. ");
INSERT INTO mca_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma' qa ikfik'ikii he' fariseol qa aje'eƚ tafaakate'yi'ƚijju' he' tek'enetsek ha' Herodes pa'qu' ƚeqfenyejeyi'ij qu' nilan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ha' Jesús qa ikik'ui iye hakha' i'ntaxi', qa ƚijts'eyek he' ƚ'ijatshenhei in ikiiju' ke' qi kaƚi'. Qa' olootsija iye he' nijayanik'i he' ta'ƚi' ha' sehe' Galilea qa he' ta'ƚiyek ha' sehe' Judea ");
INSERT INTO mca_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","qa he' ta'ƚii ha' Jerusalén, qa he' ta'ƚiyek ha' sehe' Idumea, qa he' neƚu'uju'ƚ ta'ƚii hakha' ƚajaika' ai ha' haqqi' Jordán, qa hekhewe' ta'ƚiyek he' metitsi'm he' witsetits Tiro qa ha' ha' Sidón, qe in i'ye'ej wetju'ƚ week ke' yaqsiijkii ha' Jesús, ma' qa namii. ");
INSERT INTO mca_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ha' Jesús qa yiyaji'ijets he' ƚ'ijatshenhei qu' nimetinheti'm ewi'ƚe' witinhitjiye' hats'inha qa'nte' puk'uyi'ik'ui he' namii, ");
INSERT INTO mca_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","qe in hats olots he' niƚinju', ma' qa he' week wanqaats'eju' hats watkatitij wetepji' in yisu'un qu' net'eku'mets. ");
INSERT INTO mca_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Qa week pe' i'nji' pe' inwo'metets in yi'wenji'ij ha' Jesús qa wonokok'enjiiju' ƚ'ejuyi'jii, qa tayaiji'ij, qa yitji'jij: —¡Akha' Ƚaa'sija pa' Dios!— ");
INSERT INTO mca_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Qa ha' Jesús qa yaq'ayinji'jij qa yitjiijets qu' hasu'uj nenfel pekhewe'en pakha' ƚunyee'jija hakha'an. ");
INSERT INTO mca_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ha' Jesús qa ikik'ipha'm ke' utek, qa hik hakha'a' qa yejeƚiiji' qa taya'yiiji'kii he' yisu'un qa ikji'jetspha'm ha' i'ni' qa ewi'ƚ i'ni'ƚi'. ");
INSERT INTO mca_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma' qa t'eku'miiji'kii he' doce (12) jukhew, hats'inha qu' hik hekhewe'ye' qu' ƚijts'eyek'ekii qa hik hekhewe'ye' iye qu' nukinkii qa' nenfel ke' ƚe'lijei, ");
INSERT INTO mca_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","qa qu' netisij iye pa'qu' ƚet'unhaxitsijup qu' nukinfik'ikii pe' inwo'metets. ");
INSERT INTO mca_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Enewe'en ƚiyits hekhewe' doce (12) t'eku'miiji'kii: Hakha' Simón (hikha' ƚenqii iye Pedro), ");
INSERT INTO mca_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ha' Jacobo (Santiago) ƚa's ha' Zebedeo qa ha' ƚek'inij Juan, (hik hekhewe' ha' Jesús ƚeqiyitsij Boanerges, ikji': “ƚelits na'aj tejen”), ");
INSERT INTO mca_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","qa ha' Andrés, ha' Felipe, ha' Bartolomé, ha' Mateo, ha' Tomás, ha' Jacobo (Santiago) ƚa's ha' Alfeo, ha' Tadeo, ha' Simón hikha' i'nji'teje'm pa'aj pe' ƚiyits cananita neqwumhiyu'taxij pa'aj pe' Roma ƚeiƚets ");
INSERT INTO mca_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","qa kakha' iye Judas Iscariote. Hikka' t'ihinij ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma' qa i'nk'aƚe ha' Jesús qa uyifi ke' wititsi', qa hik hakha'a' iye qa k'aƚaƚij iye he' olots jukhew qa efuts, ma' qa nite' ƚeke' qu' netek ha' Jesús qa he' ƚ'ijatshenhei iye. ");
INSERT INTO mca_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","He' ƚejefets in nikfe'lets aka'an in ƚunye'jkii ha' Jesús, qa nektaxii qu' neka'x, qe titijiti'yijets in hats nite' teik'uneikii. ");
INSERT INTO mca_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Qa hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei ta'ƚii ha' Jerusalén qa yit'ijju'ek: —¡Nakha'an i'nji' pa' Beelzebú! hikpa' ƚatata pe' inwo'metets qa hikpa' ta'ƚijets pa' ƚet'unha'x in yukinik'uifik'ikii pe' inwo'metets.— ");
INSERT INTO mca_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma' qa ha' Jesús qa taya'yii hekhewe'en, qa nifeli'm ka' yejeyumtshenijupi', qa yit'ij: —¿Pa'n ƚunye'j na' Satanás qu' ƚakha' ye'ƚe ƚete'm qu' ne'nukinƚefik'i? ");
INSERT INTO mca_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pa'qu' ewi'ƚe' witset qu' nawatk'esa'xju' qa' napilƚe wetju'ƚkii, pakha'an qa nite' ƚeke' qu' nape. ");
INSERT INTO mca_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pe'qu' ewi'ƚe' wititsi'ye' in watk'esa'xju' qa wapilƚe wetju'ƚkii, nite' ƚeke' iye qu' pakhaayi'ij qu' ewi'ƚ na'ni'. ");
INSERT INTO mca_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Qa na' Satanás qu' neqet'ets wetju'ƚkii qa qu' napilƚe wetju'ƚkii iye, nite' ƚeke' qu' pakhaayi'ij qu' na'ni', ma' qa' aje'eƚ hame'. ");
INSERT INTO mca_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Qa hamƚe pa'qu' ewi'ƚe' qu' nuyetsji' pe'qu' ƚetsi'ye' pa'qu' ewi'ƚe' jukhewe' t'un ma' qa' nenitka'mij pe'qu' ƚewekwekitse' qu' nite' nojoye' qu' nophe'ƚ, nophe'ƚ yijat'ij ma' qa' hayitse' qa' ƚeke'ye' qu' neka'xik'ui pe'qu' ƚewekwekitse'. ");
INSERT INTO mca_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yijaa'ija aka' hit'iƚij ewets, in week pa'qu' ƚunye'je'ƚe qu' ƚewuƚ'axe' ene' jukhew qa efuts iye in ƚeke' qu' netwumhiti'yik'ui, qa week iye pe'qu' ƚe'lijeye' in uƚ'etstaxik'i qa ƚeke' iye qu' netwumhiti'yik'ui. ");
INSERT INTO mca_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Qa pakha'ƚe qu' uƚ'axi'ik'i pa'qu' ƚ'anye'ji'ij na' Espíritu Santo qa' nite' ƚeke'ye' qu' niwu'mik'ui aka'an, ma' qa' hik aka'ƚe qu' ƚunye'je' qa' amane'ƚi'ij week ƚahatsiyij.— ");
INSERT INTO mca_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ha' Jesús in yit'ijets aka'an hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei, qe hekhewe'en yit'ijju': —Nakha'an i'nji' pa' ewi'ƚ espíritu uƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma' qa namii ke' ƚenene qa he' ƚek'injats iye ha' Jesús, qa amaneiƚefik'i, qa iyintaxii qu' nak'ekuniifik'i. ");
INSERT INTO mca_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Qa hekhewe' i'nijup k'ooyijji' ha' Jesús, qa nifeli'm, qa yit'ijets: —Ke' enene qa he' ek'injats amaneifik'i, qa iyintax ei.— ");
INSERT INTO mca_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ha' Jesús qa yit'ij: —¿Ƚek pekhe' nene qa ƚek pekhewe' k'injats iye?— ");
INSERT INTO mca_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Qa yeeƚipji' he' k'ooyijji' in i'nijup, qa yit'ij: —Enewe'en hik enewe' nene qa k'injats iye. ");
INSERT INTO mca_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Qe pa'qu' ƚunye'je' qu' naqsiijkii pa'qu' nisu'un na' Dios, pakha'an k'inij qa k'inja' iye qa nene iye.— ");
INSERT INTO mca_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ha' Jesús qa ewi'ƚij iye in i'nq'ijatsheni' ha' ƚotkoyek'i ke' qi kaƚi'. Ma' qa not'axii he' olootsija jukhew qa efuts iye, ma' qa t'ilitji'ju' ke' witinhitjii qa i'nju', qa hekhewe'ƚe olots jukhew qa efuts iye qa i'ni' ha' sehe' ƚotkoyek'i ha' iweli'. ");
INSERT INTO mca_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma' qa yijatshenij ke' olots wekwek yejeyumtshenijupi', qa yit'ij ka' i'nq'ijatshenij: ");
INSERT INTO mca_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Ek'en qeku'ni'ƚik'i ek aka'an, ewi'ƚ pa' iwenq'enhena'x ikfik'i qu' newenq'en. ");
INSERT INTO mca_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma' qa in we'nq'en, qa na'l pe' ƚoqoƚoi namji'ju'kii pa' wit'ikheyi'j qa namii pe' junatai qa tuj. ");
INSERT INTO mca_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Qa pekhewep iye qa namji'ju'kiyek pa' uteket qa nite' qi pa'qu' seheeyi'ija, ma' qa aje'eƚ qhufje'm qa ta'ƚ qe nite' akaptitsik'ui. ");
INSERT INTO mca_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Qa nekpha'm ne' junu' qa yaq'alij, qe nite' ijetits pe' ƚefitetsii, ma' qa yisƚax aje'eƚ. ");
INSERT INTO mca_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Qa pekhewep iye qa namji'ju'kiyek pa' tiiket. Qa pe' tii in ta'ƚ qa tik'eyijju', ma' qa ham iye ƚeye'. ");
INSERT INTO mca_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Qa pekhewep iye qa namijukiyek pa' ƚe'wisji' sehe', qa ta'ƚ qa qitspha'm, ma' qa na'l pe' ƚei, uja'x pe' yamets treinta (30) pe' ƚei, qa pekhewep qa sesenta (60) pe' ƚei, qa pekhewep iye qa cien (100) yametsek pe' ƚei.— ");
INSERT INTO mca_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ha' Jesús qa yit'ij iye: —Pakha' qu' nana'li'm ƚekfiiye' qa' nepiye'ek'iha aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ma' qa in hats uja'xƚi'iƚkii he' doce (12) ƚ'ijatshenhei qa hekhewep iye, hekhewe'en qa nifaakanijha pa' ikji'ha kekhewe' yejeyumtshenijupi'. ");
INSERT INTO mca_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Qa yit'ijiju'ƚ: —Ehe, ekheweli'ƚ ƚenexke'ej qu' enikfe'li'ƚets ekewe' nite' hayiits qu' nana'l pa'qu' nenikfe'lets t'ejuyets na' tenek'enheiji' na' Dios. Qa nekhewe'ƚe i'nfik'i, qa wekwekƚe wetjeyumtshenimijupi' in tefelhiti'yi'm. ");
INSERT INTO mca_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hats'inha in yejeƚtaxju', yi'wentax qa nite'ƚe nikfe'lij, in tek'entaxets, yepi'ye'tax qa nite'ƚe nikfe'lik'i. Qa qu' nepiyetax iye qa hik ƚunye'j qu'nte' nepiyeye'. Qe nite' wenink'aihit ma' qekha netwumhitiitaxik'ui pe' ƚewuƚ'ets.— ");
INSERT INTO mca_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Qa yit'ijets iye he' ƚ'ijatshenhei: —¿Me nite' ƚenikfe'li'ƚik'i aka' ewi'ƚ wetjeyumtshenijupi'? ¿Qa pa'n qu' ƚunyeje'ek qu' enikfe'li'ƚets week kekhewep iye wetjeyumtshenijupi'? ");
INSERT INTO mca_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pa' iwenq'enhena'x yenju' eke' wi'tlijei. ");
INSERT INTO mca_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Enewe' jukhew qa efuts hik ƚunyejei aka'an, pe' ƚoi namji'ju'kii pa' wit'ikheyi'j. Enewe'en in yepi'ye'taxik'i eke' wi'tlijei, ma' qa aje'eƚ namii na' inwo'met qa nitka'mij eke' wi'tlijei we'nentaxji'ju' ƚatawe'j. ");
INSERT INTO mca_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pekhewep iye qa hik ƚunyejeyek aka'an, pe' ƚoi namji'ju'kii pa' uteket. In yepi'ye' ek'i eke' wi'tlijei qa yisu'unik'iha' qa aje'eƚ t'eku'mi'. ");
INSERT INTO mca_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Qa in nite'ƚe ijetits pe'qu' ƚefitetsiye' qa nite' ƚeke' qu' nape. Ma' qa qu' natjaajinhetii qa' netitijiti'yijetskii pe' wekwek i'nƚi'i qu' natawitjaxtii qe ta'ƚets ekewe' wi'tlijei, ma' qa aje'eƚ yili'ijju'. ");
INSERT INTO mca_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Qa pekhewep iye qa hik ƚunyejeyek iye aka'an, pe' ƚoi namiju'kii pa' tiiket. Pekhewe'en in yepi'ye' ek'i eke' wi'tlijei, ");
INSERT INTO mca_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","qa in ta'ƚƚe'ets pakha' wittawje'mete'ej pe' wekwek ƚunyejeikii ha'ne sehe' ipji' qa pakha' iye jiyaqanijkii eke' wekwek qu' qi qu' jitawq'axintax, qa week iye pakhape' iye wekweke' qu' qi qu' nisu'untax, ekewe'en in uiji'teje'm ma' qa tik'eyijju' eke' wi'tlijei qa ham ƚeye'. ");
INSERT INTO mca_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Qa pekhewep iye qa hik ƚunyejeyek aka'an, pe' ƚoi namji'ju'kii pa' ƚe'wisji' sehe'. Pekhewe'en in yepi'ye' ek'i eke' wi'tlijei, ma' qa t'eku'miju'ƚha qa na'l pe' ƚei, na'l pe' yamets treinta (30) pe' ƚei, qa pekhewep qa sesenta (60) yamets pe' ƚei, qa pekhewep iye qa yametsek cien (100) pe' ƚei in ewi'ƚtax pe'qu' ƚo'ye'.— ");
INSERT INTO mca_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ha' Jesús qa yit'ijji'ju' iye: —¿Me tetka'x pe'qu' fetitjiye' ma' qa' ne'nenifi ƚatawe'j pa'qu' witiwhi'la'xe' i'nƚi'i qu' ti'najki'ye'? Nite'. Nite' ƚe'wisijupi'. ¿Me nite' we'nenpha'm yijat'ij ma' qa week nalitipji'? ");
INSERT INTO mca_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Qe ham pa'qu' natat'inhetiitaxkii qu'nte' ne'twenheti'ye' hatse'. Week qu' ne'twenhetii week pe' ham nikfeletaxets qa' netfelhitii hatse'. ");
INSERT INTO mca_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pakha' qu' nana'li'm ƚekfiye' qa' nepiye'ek'i aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Qa yit'ij iye: —Maxtayitiƚik'iha week ekewe' ƚespi'ye'eƚij. Qe pa'qu' equk'eyi'iƚij pa'qu' isu'uni'ƚ qu' enikfe'li'ƚets, qa' hik ƚuk'eyejeek pa'qu' esti'yi'ƚij, qa' ewi'ƚij iye qu' les esti'yi'ƚij. ");
INSERT INTO mca_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Qe pa'qu' hats nana'li'm qa' ewi'ƚij iye qu' netesti'yij, qa pa'qu' hami'im qa' netitkamhiti'yij iye pe'qu' nana'ltaxi'm.— ");
INSERT INTO mca_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús qa yit'ij iye: —Na' tenek'enhe'yi' na' Dios hik ƚunye'j iye aka'an, na'aj jukhew in yenju' ne'ej ƚoqoƚoi ha'ne sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma' qa yili'ij qa ima' qa nompha'm, qa week neƚuts ƚunye'j aka'an, qa pe' ƚ'enheiju' qa ta'ƚ qa t'ijaipha'm qa nite'ƚe nikfe'lets pa' ƚunye'jija in ta'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ha'ne sehe' hik ha'ne yitaƚit qa tei. Nojopha'm ne'ej ƚesejets qa i'nk'aƚe nekpha'm na'aj ƚenu. Ma' qa hik na'aj i'ni' ne'ej ƚei. ");
INSERT INTO mca_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma' qa in hats yuji' pe' ƚei, qa aje'eƚ yisa'xifi, qe hats yamets ƚahats'ij qu' netenit'ijji'.— ");
INSERT INTO mca_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ha' Jesús qa yit'ij iye: —¿Pa'n ƚunye'j pa'qu' jinta'wapjuƚeniju'ƚ na' tenek'enheiji' na' Dios, axe'm pa'qu' jintejeyumtshenijupi' qu' hik ƚunye'je'? ");
INSERT INTO mca_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hik ƚunye'j ne'ej ewi'ƚ mostaza ƚo' in we'nenju'. Ewi'ƚƚe in les nite' qi wiikfik'i ne'ej week ƚoi qe we'neniju' ha'ne sehe'. ");
INSERT INTO mca_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ƚa'mek, in we'nenju' qa ta'ƚ qa qipha'm, qa hik ne'ej qa les in qipha'm ne'ej week ƚesejets wit'enheiju' (hortalizas), qa ne'ej ƚakjil qa ijetits, ma' qa namii ne'ej junatai qa tupiyifi na'aj ƚeq'eneƚeya'x.— ");
INSERT INTO mca_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Qa olots kekhewep iye yejeyumtshenijupi' in ƚunyejeyek ekewe'en in nifeli'm he' jukhew qa efuts iye eke' wi'tlijei, in ƚaq'ajijek pakha' ƚuk'e' qu' ƚeke'ye' qu' nenikfe'lik'i, ");
INSERT INTO mca_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","qa nite' iyet qu' ham nejeyumtsheni'ijupi', qa nifelƚeji'ji'mha he' ƚ'ijatshenhei qa hats uja'xƚejiiƚkii. ");
INSERT INTO mca_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hik kakha' ka' neƚuji' in hats metju' junu', qa yit'ijets he' ƚ'ijatshenhei: —Yape jitajawe'jiiteje'm na' ƚajaika' ene' kaƚi'.— ");
INSERT INTO mca_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Qa wetfeli'm hekhewe' olots jukhew qa efuts iye, ma' qa he' ƚ'ijatshenhei qa t'ilitji'ju'kii ke' witinhitjii, hikke' hayiits i'nji'ju' ha' Jesús, ma' qa yijawejiƚteje'm. Qa na'l iye hekhewep iye witinhitjiyits ƚijts'eyek. ");
INSERT INTO mca_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Qa nam ka' qi t'unik'i qa ke' ƚeqe t'uyuyuyits qa tsxiƚtsxiƚji'ju'kii ke' witinhitjii. Ma' qa hats qiyu'ji'ha ka' iweli' ke' witinhitjii. ");
INSERT INTO mca_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Qa hakha'ƚe Jesús qa i'ni' ke' ƚetsi'jii ke' witinhitjii, ima'apji' ha' wit'osiyit, ma' qa tijt'otshenheti'yii, qa titijiti'yijets: —Maestro, ¿me nite' ƚenƚ'ilax in hats ji'nuihiyu' qa' nanq'ax'inijju'?— ");
INSERT INTO mca_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma' qa niipha'm ha' Jesús qa yaq'ayinij ka' t'unik'i, qa yit'ijets iye ha' iweli': —¡Ikesimen! ¡Mawapjakitek!— Ma' qa aje'eƚ yili'ij ka' t'unik'i qa ikesimenija iye ha' iweli'. ");
INSERT INTO mca_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —¿Inhats'ek in qi in ƚe'nijiwe'yi'ƚ? ¿Ye' me mexe hamitsi'ƚ e'm pa'qu' nite' eqekuyejeyi'iƚyij?— ");
INSERT INTO mca_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","He' ƚ'ijatshenhei qa qi in yitjuƚaxijpha'mkii, qa watfaakateji'ijju', qa yit'ijju': —¿Pa'n ƚunye'jija hane'en, in tek'enets iye ka' t'unik'i qa ha'ne qi iweli' iye qa week ikesimen?— ");
INSERT INTO mca_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ma' qa yametsteje'm ha' ƚajaika', ha' sehe' ƚii Gadara. ");
INSERT INTO mca_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Qa in t'ilitju' ha' Jesús qa aje'eƚ namets ha' ewi'ƚ jukhew ta'ƚets ha' nimeƚkuket i'nji' pa' ewi'ƚ espíritu uƚ'ax ");
INSERT INTO mca_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","qa i'nji'kii ha' nimeƚkuket. Qa ham pa'qu' ƚeke'ye' qu' nonophe'ƚtaxij, foƚoƚik'itax yemjee, ");
INSERT INTO mca_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","qe olotsij in we'nuihintaxik'i ƚef'iyei ne'ej nijketits (grillos) qa pe' foƚoƚik'il qa ƚokoyei wo'nopheƚtaxijek, qa niwk'itsinƚeji'ijju' qa ƚaq'ajaiji'ijju' pe' foƚoƚik'ilik'i qa pe' nijketits (grillos) qa niwqaƚitji'ijju' iye. Qa ham pa'qu' jukhewe' qu' hik ƚet'unhenye'je' qa' nenyejinju'. ");
INSERT INTO mca_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Qa week neƚuts qa najai iye yijalki'sƚeji'kii ha' nimeƚkuketii qa ha' uteket iye, qa tayaiƚekii qa wenisa'xjiijje'mkii iye pe' utel. ");
INSERT INTO mca_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Qa in yi'weniju'ƚ ha' Jesús mexe toxtaxii, qa tekumaxiju'ƚ qa wonokok'eni'ju' ƚ'ejuyi'jii. ");
INSERT INTO mca_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Qa yit'unhetik'i in tayai, qa yit'ij: —¿Inhats'ek in ƚanamyii, Jesús, Ƚa's pa' qiji'ha in Dios? Aka' ƚiiji' pa' Dios qu' nek'iyinij ewets qu' hasu'uj atsawtsheten wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hik aka' yit'ij qe ha' Jesús yit'ijets: —¡Ma'ak'uifik'i na' jukhew, espíritu uƚ'ax!— ");
INSERT INTO mca_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ha' Jesús qa nifaakan: —¿Pa'n ii?— Hakha'an qa yeku'ƚ: —Aka'an yii legión, qe yo'lotsi'ƚha.— ");
INSERT INTO mca_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pe' inwo'metets olotsij in iyinijetskii ha' Jesús qu' hasu'uj nukinik'ui ha' sehe' ƚetset'ijkii. ");
INSERT INTO mca_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ha' sehe' na'li' ke' olots tafitets taqakiyi'ju' ke' utek ipji'. ");
INSERT INTO mca_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pe' inwo'metets qa yit'ijju' in iyinijets iye: —Ets'ukini'ƚii ne' tafitets qa' etswejini'ƚij qu' nek'uyiƚik'i.— ");
INSERT INTO mca_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Qa ha' Jesús qa ƚexke'ej. Ma' qa ikik'uifik'i ha' jukhew pe' espíritu uƚ'ets, qa uijiteje'mkii ke' tafitets. Ke' tafitets uja'x yamets wetsjuk mil (2.000), ma' qa wekuma'xijiiju'kii ha' koomo'oijo' i'ni' ha' iweli', qa hikha' qa naxiju' in uikii ke' tafitetsik'i. ");
INSERT INTO mca_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma' qa he' yejeƚtax ke' tafitets qa wekuma'xkii qa nifelii ha' witset qa he' i'ni' ha' ƚ'ejinqa'wet iye. Ma' qa namii qu' ni'wen kakha' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Qa in namii ha' i'ni' ha' Jesús qa yi'wen ha' jukhew i'ntaxji' pe' inwo'metets, in i'nju' qa ikesimen, qa hats teqhinatai iye qa hats teik'unei iye, qa hik hakhaa'ija iye hakha' i'ntaxji' pe' milits inwo'metets. Ma' qa nijiwei hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hekhewe' yi'wenijha qa nifelimik'i kakha' ƚunye'jkiiha hakha' i'ntaxji' pe' inwo'metets, qa kekhewe' iye tafitetsik'i ka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma' qa hik pa'aj qa iyinijetskii ha' Jesús qu' nakik'ui iye ha' ƚeqe sehe' hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ha' Jesús in hats i'nji'ju' iye ke' witinhitjii, qa hakha' i'ntaxji' pe' inwo'metets qa iyintaxijets qu' nijayan. ");
INSERT INTO mca_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ha' Jesús qa nite'ƚe ƚexke'ej, qa yit'ijets: —Mapilii yijat'ij pe' etsi', pe' etsetifets, qa' enfeli'mik'i week ekewe' wekwek yaqsi'j e'mijkii na' Yatsat'ax'inij, qa pa'n ƚunye'j iye in qi in neq'elet'ej.— ");
INSERT INTO mca_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma' qa ik, qa yapeƚek qa nifelji'ju' he' witsetits Decápolis pa'n ƚuk'el kekhewe' wekwek in qitsija in yaqsiimijkii ha' Jesús hakha'an. Ma' qa week qi in yitjuƚaxijpha'mkii. ");
INSERT INTO mca_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","In hats yamijiiteje'm iye ke' witinhitjii ha' ƚajaika', qa not'axii iye he' olootsija jukhew qa efuts yeqewuk'un ha' Jesús. Ma' qa hik ta'ƚijupi' ha' Jesús in hik hakha'ƚe amani' ke' qi kaƚi'iiju'. ");
INSERT INTO mca_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma' qa namii ha' ewi'ƚ hekhewe' witlijtsitjii tenek'enhe'yij (oficiales), ƚii Jairo, qa in yi'wen qa wonokok'enetsju' ƚef'iyeyiiju' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Qa qi in iyinets, qa yit'ij: —Ke' yasi' hats k'esik'i qu' nawa'm. Te'ƚun eku'n wat'ij qu' ku'mipji' qa' net'un qa' iƚa'xe' iye ke' yasi'.— ");
INSERT INTO mca_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma' qa ha' Jesús qa yijayan. Qa ƚatsiyik'i iye he' olootsija jukhew qa efuts qa watkatitij wetepji'. ");
INSERT INTO mca_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Qa ewi'ƚ ke' efu i'nji'teje'm he' watkatit wetepji', hats tooxik'i pa'aj in wanqaats'e' nite' hamitsik'ui pe' ƚ'athits qa hats yamijets doce (12) ƚeqe'ninqapitsij. ");
INSERT INTO mca_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Qa olotsij in yawtshetenji'ij in yeqjunhetinentaxkii pe' olots weihetets witeqjunhetits ƚeiƚets, qa hats naq'axiji' week pekhewe' na'ltaxi'm ƚaq'astayik'i qa ham pa'qu' napaliti'm, yape'enha les in qi'ij. ");
INSERT INTO mca_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ke' efu in tek'enjiijkii qa tenifaakateijiiju' ke' yaqsiijkii ha' Jesús, kikhe'en qa ta'ƚii ƚ'anu in wetjuk'etetsji', qa t'eku'mets pa'aj ha' ƚ'uihitjii. ");
INSERT INTO mca_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Qe pa' ƚaqjamtikineye'jkii in yumti'ija qa yit'ij: —Qu' he'yeku'mets na' ƚ'uihitjiiƚe ma' qa hats natsaxpa'lij pa' yaatshe'k.— ");
INSERT INTO mca_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Qa hik pakhaa'ijha pe' ƚ'athits qa hamitsik'ui, qa wonoksi'wen in hats hamiikii pa' ƚaatshektax. ");
INSERT INTO mca_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma' qa ha' Jesús qa' hatsƚe yoksi'wen pa'aj pa' ƚet'unha'x in ikfik'i. Qa tetwek'elaxiju'ƚ hekhewe' nijayanik'i, qa yit'ij: —¿Ƚekpa' t'eku'mets ha'ne yuihitjii?— ");
INSERT INTO mca_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Qa he' ƚ'ijatshenhei qa yit'ijiju'ƚ: —Hats inek ƚi'wen ene' watkatit wetepji', qa ƚit'ij: ¿Ƚekpa' t'eku'm yiwets?— ");
INSERT INTO mca_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Qa hakha'ƚe Jesús qa yape'enha yejeƚ ji'teje'mkii hekhewe' yeqewuk'un qe qa' ni'wen kikhe' efu t'eku'mets pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma' qa ke' efu qa nikfe'lik'i in hats naxpa'l qa tsalalkii qe nijiwei, qa ikets qa wonokok'enifi ƚef'iyeyiiju' ha' Jesús. Qa tetfeliji'm week pa' ƚunyeejkiiha. ");
INSERT INTO mca_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ha' Jesús qa yit'ijets: —Yasi', pa' nite' eqekuye'j hikpa' ta'ƚets in hats ƚanaxpa'l. Yape ma, hasu'uj e'nijiwei. Pa' qi awtshektax hats ƚanaxpa'lijha.— ");
INSERT INTO mca_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","In mexe iyet ha' Jesús qa namets he' jukhew ta'ƚii ke' ƚetsi' hakha' witlijtsitjii tenek'enhe'yij (Jairo), qa nifeli'm, qa yit'ijets: —Ke' oqwomeki'ik'i hats wa'm. Yape iwejinƚe na' maestro.— ");
INSERT INTO mca_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Qa ha' Jesús in yepi'ye' hekhewe'en aka' yit'ijju', qa yit'ijets hakha' witlijtsitjii tenek'enhe'yij (Jairo): —Hasu'uj e'nijiwei, ewi'ƚƚe qu' hasu'uj inqeku'.— ");
INSERT INTO mca_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Qa nite' ƚexke'ej pakhape' iye qu' nijayan, qe uja'xƚe ha' Pedro qa ha' Jacobo (Santiago) qa ha' Juan, Jacobo (Santiago) ƚek'inij. ");
INSERT INTO mca_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","In yamets ke' ƚetsi' hakha' witlijtsitjii tenek'enhe'yij (Jairo), ha' Jesús qa yi'wen hekhewe' t'aiji' qa hekhewe' iye ipju' qa qi in yejtsi'le' wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Qa uyifi ke' wititsi', qa yit'ijji'ju': —¿Inhats'ek in ƚenejtsile'eƚ wetju'ƚ qa ƚapi'ƚju' iye? Nekhe' ome'ƚaski' nite' wa'm, ima'ƚe.— ");
INSERT INTO mca_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma' qa talakaxtiiju' ha' Jesús. Qa ha' Jesús qa yuki'nfik'ikii he' weekji' qa uja'xƚe in t'eqe'mets ha' ƚatata qa ke' ƚenene iye qa he' hats ƚijts'eyek, ma' qa uyetsjikii ha' i'ni' ke' ome'ƚaski'. ");
INSERT INTO mca_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Qa t'eku'mi' ha' ƚokoi ke' ome'ƚaski', qa yit'ijets: —¡Talita cumi!— Ikji': —Ome'ƚaski', akha' hit'ij ewets, ¡eniipha'm!— ");
INSERT INTO mca_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Qa hik akaa'ijha ke' ome'ƚaski' qa niipha'm qa aje'eƚ t'otsjo' iye. Ke' ome'ƚaski' doce (12) ƚeqe'ninqapits. Qa hekhewe' ƚ'alhei qa qi in yitjuƚaxijpha'mkii. ");
INSERT INTO mca_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ha' Jesús qa yiyajitaxetskiiha, qa yittaxijets qu' hasu'uj nenfeli'ƚi'm pe'ye'. Qa yit'ijets iye qu' netisij pa'qu' ƚaqe' qu' netuj ke' ome'ƚaski'. ");
INSERT INTO mca_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ha' Jesús qa ikik'ui iye hakha' i'ntaxi' ma' qa yamii hakha' ƚetset'ija (Nazaret), qa ƚijts'eyek iye he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Qa in yamets ka' witwapiihijii (sábado), qa i'nq'ijatshen ke' witlijtsitjiyifi. Qa olots hekhewe' yepi'ye' qa yitjuƚaxijpha'mkii, qa yit'ijju': —¿Pa'n ta'ƚiji' eke' wekwek in nikfe'lets hane'en? ¿Pa'n ta'ƚiji' aka' witikfeliya'xkii? ¿Qa pa'n ta'ƚiji' iye in ƚeke' in yaqsiijkii kekhewe' ham ƚunyejeyi'iju'ƚ? ");
INSERT INTO mca_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Me nite' hik ha'neƚe ha' carpintero? ¿Me nite' hik ha'neƚe iye ha' ƚa's ke' María, ƚejefe hekhewe' Jacobo (Santiago), José, Judas qa ha' Simón? ¿Qa me nite' ewi'ƚ ha'ne ju'uni'ƚi' iye hekhewe' ƚek'injai?— Ma' qa yiwakaninkii qa hik ta'ƚijupi' in nite' tek'enets. ");
INSERT INTO mca_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ha' Jesús qa yit'ijets: —Ham pa'qu' profetaye' qu' ham niwqinhete'ji', qa ni'kha'ƚi'ij ƚetsetitstaxija qa ƚetsetifetstaxija iye qa ƚetsi'taxija iye qa hik ne'ej qa nite' yiwqinhetji'.— ");
INSERT INTO mca_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma' qa' nite' ƚeke' in naqaqsijkineyutaxiji'kii pa'qu' ham ƚunye'ji'iju'ƚ, uja'xƚe in niƚinju' he' nekets ujaa'x wanqaats'eju', qa hikhe' qa t'eku'mipji'kii. ");
INSERT INTO mca_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ha' Jesús qa qi in yitjuƚaxijpha'm pakha' ƚeqekuyejeyij hekhewe'en. Ma' qa ik qa ikik'i hekhewe' pumumpha'mkii witsetits ƚelits, qa yijatshen. ");
INSERT INTO mca_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ha' Jesús ma' qa taya'yets he' doce (12) ƚ'ijatshenhei hik pakha'aj qa yukinkii wetsjukkii, qa netisijju' pa'qu' ƚet'unhaxitsi'ipji' pe' espíritu uƚ'ets (inwo'metets). ");
INSERT INTO mca_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Qa yiyaji'ijets iye qu' hasu'uj neka'x pe'ye' qu' nakkii, uja'xƚe pe'qu' najak'e ƚawaikajitits. Qa' hasu'uj iye qu' neka'x pane', hasu'uj iye pa'qu' ti'naje', hasu'uj iye pe'qu' ƚ'astaye' qu' nijutsjayik'iju' ƚeqelutsits, ");
INSERT INTO mca_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","qe uja'xƚe yijat'ij qu' not'otsji' he' ƚ'otshilaxtii (sandalias). —Qa' ewi'ƚe'ƚe iye pa'qu' hats uyi'ƚik'ipha'm uihitjiyi'iƚ, hasu'uj eka'xi'ƚ pakhape' iye.— ");
INSERT INTO mca_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Qa yit'ijets iye: —Pe'qu' uyi'ƚifi wititsi'ye', qa' hik pakha'ƚe a'maneyi'iƚi' qa' ami'ƚijii qu' mataxiƚik'ui iye pa'qu' witset'e. ");
INSERT INTO mca_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Qu' ami'ƚets pa'qu' witset'e qu' nite' neneqjunuyi'iƚ ej qa nite' nexpiikeyu'uƚ ej iye, qa qu' hats ma'aƚik'uifik'i qa' it'iƚij ful ful pa'qu' sehe'ye' qu' net'unitstaxijji' ne' ef'iyeyi'ƚ, hats'inha qu' jutsiqetsi'im in uƚ'ax in yaqsiijkii aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma' qa ikkii he' ƚ'ijatshenhei, qa nifeli'm pe' week qu' nili'ij in yaqsiijkii pa' uƚ'ax qa ni'nk'aihit iye pa'qu' ƚunyejeye' pe' ƚatawjets. ");
INSERT INTO mca_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Qa olots pe' yuki'nfik'ikii inwo'metets, qa yilinjijij iye na'aj aceite ta'ƚets ne'ej olivo pe' olots wanqaats'eju' qa yiƚinji'ij. ");
INSERT INTO mca_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ka' wittata Herodes i'ye'ej pa'aj aka'an, qe ka' ƚii ha' Jesús hats qi'ija pa' ƚeniihe't, qa in yit'ijju' iye pa'aj ene' jukhew qa efuts: —Qete'e' hats iƚa'x iye ka' Juan Bautista'ik'i, qe ke'ek in na'li'm pa' qi ƚet'unha'xijup in yaqsiijkii pe' ham ƚunyejeyi'iju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Qa pekhewep iye qa yit'ijju'ek: —Hik hakha' pa' Elias'ik'i.— Qa pekhewep iye qa yit'ijju'ek iye: —Hakha'an profeta, hik ƚunyejei pe' hayiits profetalik'i.— ");
INSERT INTO mca_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ka' Herodes in impi'ye'ej aka'an, qa yit'ij: —Hik kakha' Juan Bautista'ik'i k'inaqyaji'ij qa we'nisa'xii ka' ƚeiƚa', qa hane'ej qa hats iƚa'x iye.— ");
INSERT INTO mca_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Qe ka' Herodes hik kakha' inq'ukinii pa'aj ka' Juan qu' netnekumhi'yi', ma' qa yophe'ƚij pa'aj pe' foƚoƚik'il pe' witq'opheƚitjiyifi qe ta'ƚets pe' efu ƚii Herodías, ƚewhe'ye'tax pa'aj pa' ƚek'inij Felipe, qe ka' Herodes hats ƚewhe'ye'ej pa'aj pekhe'en. ");
INSERT INTO mca_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Qe ka' Juan Bautista yittaxijets pa'aj ka' Herodes: —Nite' inek ƚenexke'ej kakha'an qu' ewhe'ye'yi'ij ne' ƚewhe'ye' pa' ek'ini'j.— ");
INSERT INTO mca_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Qa pe' Herodías qa qi in napjaxi'm pa'aj qa yisu'untax qu' nilan, qa nite'ƚe ƚeke'. ");
INSERT INTO mca_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Qe ka' Herodes nijiweyiju'ƚ ka' Juan qe nikfe'lets in ewi'ƚ jukhew yatsathen qa yijayaanija iye pa' Intata. Qa hik ta'ƚijupi' in nite' yiwejini'm qu' nilan. Ka' Herodes qi qa yitawje'metenji'ij qa yepi'ye'ji'ij ka' Juan, qa yape'enhaƚe les yisu'unji'ij qu' nepiye'ji'ij. ");
INSERT INTO mca_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Qa yamƚe'ets pa'aj pa' neƚuji' qu' niwq'axinij pe' Herodías qu' nilan ka' Juan, hik pakha'aj ka' Herodes ink'ayik pa' ƚeqe'ninqa'p, qa qi pa' ƚaxqaqij pekhewe' tenek'enhei te'weyik'uiju' kakha'an qa pe' qits oq'opheƚinetsilets ƚ'alhei qa pekhewe' iye qits in patunits na' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Qa pe' ƚasi' pe' Herodías in uyetsji' pa'aj pa' i'niji' in tekju' qa t'otoyijup, qa yisu'unijji' pa'aj ka' Herodes qa weekji' pe' ƚekufets in yisu'unijji' iye. Qa ka' Herodes qa yit'ijets pa'aj pe' inanyi': —Iyinij yiwets pa'qu' isu'un qa' k'eƚisij.— ");
INSERT INTO mca_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Qa les iye in weniwjutsiqeni'mha, qa yit'ijets iye: —Yijaa'ija qu' k'eƚisij pa'qu' ƚunye'je'ƚe qu' iyinij yiwets, ƚunye'j ji'ij qu' ƚapk'ase' ha'ne heinek'enheiji'.— ");
INSERT INTO mca_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pe' inanyi' qa ikfik'i pa'aj qa yamii pe' ƚenene, qa yit'ijets: —¿Ƚekpa' qu' nek'iyinijets?— Pe' ƚenene qa yeku'ƚ: —Iyinijets ha' ƚeiƚa' ha' Juan Bautista.— ");
INSERT INTO mca_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Qa pe' inanyi' qa itaqsunetsji' in uyetsji' iye pa'aj pa' i'ni' ka' Herodes, qa yit'ijets: —Hisu'un hane'ej qu' esƚisij ha' ƚeiƚa' ha' Juan Bautista hane'ejija na'nji' tok'oye'.— ");
INSERT INTO mca_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma' qa ka' Herodes qa qi in ika'metaxkii pa'aj, qa in ƚunye'jek in hats weniwjutsiqen pa'aj qa hats week yepi'ye' pa'aj pe' namii, ma' qa nite' yisu'un qu' not'oqowe'yiju'ƚ pa' iyinijets pe' inanyi'. ");
INSERT INTO mca_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma' qa aje'eƚ yukinii pa'aj pa' ewi'ƚ oq'opheƚinetsi'l qa yiyaji'ijets qu' nenka'xii ka' ƚeiƚa' ka' Juan Bautista. Pa' oq'opheƚinetsi'l qa ikii pa'aj pe' witq'opheƚitjii, qa yamets pa'aj qa yisa'xii ka' ƚeiƚa' ka' Juan'ik'i. ");
INSERT INTO mca_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Qa neka'xii pa'aj yenji' pa' tok'o, ma' qa tisij pa'aj pe' inanyi', qa pe' inanyi' qa yeka'xii pe' ƚenene qa tisijek. ");
INSERT INTO mca_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","He' ƚ'ijatshenheitax ka' Juan Bautista'ik'i in nikfe'lets pa'aj qa ikii qa yeka'x qa ti'jik'ui pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","In hats tepilkii iye he' apóstoles qa hats ewi'ƚ i'ni'ƚi' iye ha' Jesús, qa nifeli'm week pe' yaqsiijkii qa' pe' inq'ijatshenij iye. ");
INSERT INTO mca_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Qa ha' Jesús qa yit'ijets: —Te'ƚuni'ƚ, qu' jinak eku'nii pa'qu' ham na'ni'i hats'inha qu' mawapii eku'ni'ƚju'.— Qe olots he' jukhew qa efuts iye uyij wetfi in namiikii qa ham pa'qu' ƚawapiihijiye' qa nite' ƚeke' iye qu' netekju'. ");
INSERT INTO mca_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma' qa i'nji' ke' witinhitjii qa ikkii qe qa' nakiiteje'm ha' ham i'ni'i'. ");
INSERT INTO mca_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Qa olotsƚe he' yi'wenik'i in ikkii, qa nikfe'lij, ma' qa week hekhewe' ta'ƚiikii he' week witsetits ƚelits in wekuma'xiikii qu' namik'uyii hakha' t'ejuiji', qa aje'eƚ yamii in mexe nite' t'atsji'ƚpha'mkii hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Qa in hats te'nilit'ik'uipha'mkii ke' witinhitjii, ha' Jesús qa yi'wen in olootsija hekhewe' jukhew qa efuts iye qa qi in neq'eletij qe hik ƚunyejei kots'etets ham ƚenilayets'e. Ma' qa yijatshenij ke' olots wekwek. ");
INSERT INTO mca_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Qa in hats metju' ke' junu' qa nekets he' ƚ'ijatshenhei, qa yit'ijets: —Hats metju' ene' junu' qa hane'e'in qa ham i'ni'i'. ");
INSERT INTO mca_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yape ukinkii enewe'en hats'inha qu' nakiikii ne' les metits witsetits qa' nataqha'yets ƚaqe' qe ham pa'qu' netuj hane'e'in.— ");
INSERT INTO mca_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Qa ha' Jesús qa yeku'ƚ: —Ekheweli'ƚ qu' ƚisi'ƚij pa'qu' netuj.— Qa yit'ijju' in yeku'ƚ hekhewe'en: —¿Ye' me ƚisu'un qu' hayaqhayi'ƚijii pe'qu' doscientos (200) denariose' pe'qu' pane' qa' hetisi'ƚij qu' netuj enewe'en?— ");
INSERT INTO mca_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ha' Jesús qa yit'ijets: —¿Pa'n uja'x pe' na'li'ƚ e'm pan? Ma'aƚiiju' qa' jeƚi'ƚ.— Qa in hats nikfe'lets ka' uja'x, qa yit'ijets: —Cinco (5) he' pan qa wetsjuk he' sehets.— ");
INSERT INTO mca_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma' qa inaqyaji'ij qu' ewi'ƚ na'ni'kii qa' pumummepha'mkii qu' na'ni'ju'kii ha' jup'elket. ");
INSERT INTO mca_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","In pumumpha'mkii uja'x he' yamets cien (100) qa' he' cincuenta (50). ");
INSERT INTO mca_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma' qa t'eku'mi' ha' Jesús ke' leefij (5) pan qa ke' wetsjuk sehets, qa yejeƚetspha'm na' wa's, qa yit'ij: —Ƚe'wisij.— Ma' qa napk'asitju' ke' pan qa tisij he' ƚ'ijatshenhei qa t'ihinijkii. Qa ke' wetsjuk sehets qa napk'asitju' iye qa weekij iye. ");
INSERT INTO mca_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Qa week tuj qa iƚinijju'. ");
INSERT INTO mca_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Qa he' ƚ'ijatshenhei qa ewi'ƚ yeni' ke' doce (12) canastul topolij ke' amaneifik'i pan ƚapk'asil qa ke' sehets iye, ƚaqaxpalii. ");
INSERT INTO mca_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","He' tuj ke' pan yamets leefij mil (5.000) he' jukhew in uja'xƚe. ");
INSERT INTO mca_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma' qa aje'eƚ ha' Jesús qa yiyaji'ets he' ƚ'ijatshenhei qu' net'ilitjiju'kii ke' witinhitjii qa' nathayinik'uyiiteje'm ha' ƚajaika', qa' namiiteje'm ha' witset Betsaida. Qa hakha'ƚe Jesús qa mexe wetfeli'm hekhewe' jukhew. ");
INSERT INTO mca_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma' qa in hats wetfeli'm hekhewe'en, qa ikik'ipha'm ke' utek qe qa' niyin. ");
INSERT INTO mca_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma' qa in hats najaleikii, qa ke' witinhitjii qa hats yamiiji' ha' ƚeqewuk'u ha' qi iweli'. Qa hakha'ƚe Jesús qa ewi'ƚƚekii in amani' ha' sehe'. ");
INSERT INTO mca_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Qa in yi'wenijik'i in hats yeqiwefijju' in ti'jifi ke' witinhitjii, qe t'ejuyiju'ƚ ka' t'unik'i, qa hats ipƚu'uikii pa' neƚu. Ma' qa yijayanpha'm t'otsipji' ha' iweli', qa yisu'untax qu' nat'anipji'. ");
INSERT INTO mca_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Qa hekhewe'ƚe'en in yi'wen in t'otsipji' ha' iweli', qa yumtitax qu' wit-si'nq'ale' qa qi in yeqejtsi'le'ej wetju'ƚ, ");
INSERT INTO mca_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","qe week yi'wen qa qi in nijiwe'yi'm. Qa Jesús qa aje'eƚƚe yithinii hekhewe'en, qa yit'ijii: —¡Ment'unheti'ƚ! Yakha'ƚe. Hasu'uj e'nijiwe'yi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Qa t'ilitji'ju' kikhe' witinhitjii i'nji' hekhewe'en, ma' qa ka' t'unik'i qa yili'ij. Qa hekhewe'en qa qi in yitjuƚaxijpha'mkii, ");
INSERT INTO mca_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","qe nite' nikfe'lik'uyi' kekhewe' pan, qe pakha' ƚikfeliyaxitstaxkii mexe hik ƚunye'j qu' noo'ye'kii. ");
INSERT INTO mca_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Qa in hats t'atsji'ƚik'uipha'mkii ke' qi kaƚi', qa yamets hakha' sehe' Genesaret, qa hikha' yopheƚi' ke' witinhitjii. ");
INSERT INTO mca_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","In hats te'nilit'ik'uipha'mkii ke' witinhitjii, qa aje'eƚ yinikfe'l in hik hakha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma' qa wekuma'xiikii in yiihetik'i he' week hekhewe' metitsi'm hakha' neki', ma' qa yapeƚek qa neka'xiikii he' wanqaats'eju' yenji'kii hekhewe' ƚalatits na'aj impi'yelij qu' na'ni' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Qa week na'aj ikji'ijji'teje'm hekhewe' pumumpha'mkii witsetits ƚelits qa he' qitspha'm iye witsetits qa hekhewe' iye ƚ'ejinqa'wetits, qa yenjiik'uiji' he' wit'ikheijei he' wanqaats'eju', qa iyinjiijets qu' niwejinij qu' net'eku'mƚe'ets hakha' ƚ'aka'the' eiju' ha' ƚ'uihitjii. Qa week hekhewe' hats t'eku'mets qa t'unitsji'ij qa iƚiiji'ij. ");
INSERT INTO mca_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","He' fariseol qa he' uja'x iye hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei ta'ƚii ha' Jerusalén in nekets ha' Jesús qa k'ooyijji'. ");
INSERT INTO mca_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Qa hekhewe'en in yi'wenij he' uja'x hekhewe' Jesús ƚ'ijatshenhei in mexe yamij pa' uƚ'ax pe' ƚokoyei in tekju', ikji', nite' wa'nqa'ju'. ");
INSERT INTO mca_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Qe hekhewe' fariseol qa week iye ene' judío in nite' tekju' qu' nite' nojoye' qu' nasinketik'iha kakha' ƚeqfenyejeyij in wa'nqa'ju', qe qa' nijayanij kakha' ƚunyejei pekhewe' ƚawa'mhitsik'i. ");
INSERT INTO mca_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","In tepilik'ui na'aj witaqhawet, nite' tekju' qu' nite' nojoye' qu' nimpulijin ne'ej ƚokoyei. Qa olots iye kekhewep iye wekwek, tisij pe' ƚawa'mhitsik'i qu' naqsiijkii, axe'm ne'ej iya'aj tok'ol pa'n ƚeqfenyejeyij qu' nenimpulijinju', qa ne'ej eƚi'nil iye qa ne'ej atjatei iye. ");
INSERT INTO mca_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma' qa he' fariseol qa hekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei, qa nifaakan ha' Jesús: —¿Inhats'ek ne' ijatshenhei in nite' yijayanij aka' ƚunyejei eke' ƚawa'mhitsik'i, qe nekhewe'en in tekju' qa mexe yamij pa' uƚ'ax ne' ƚokoyei?— ");
INSERT INTO mca_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ha' Jesús qa yeku'ƚ: —Wetsjuk ƚejusits, yasiinik'iha kakha' nifel qu' ejunyejeyi'iƚ ka' profeta'ik'i Isaías, qa yit'ij in yika'ajji': “Enewe' jukhew ƚejilƚe yittaxij yiwets qu' netsiwqinhet, qa nekhewe'ƚe ƚatawjets qa tots ye'miiha. ");
INSERT INTO mca_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nite' weju'ƚij qu' naqsi'jtaxijkii qu' netsiwqinhetji', ke' i'nq'ijatshenij ƚe'lijeiƚe ene' jukhewƚe.” ");
INSERT INTO mca_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Qe ekheweli'ƚ ƚili'iƚij kekhewe' yittaxijha na' Dios, qa ƚijayani'ƚ ke' ƚe'lijeiƚe ene' jukhewƚe.— ");
INSERT INTO mca_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Qa yit'ijets iye: —Ekheweli'ƚ ƚe'niyayi'ƚij ewek in ƚiwu'miƚfik'i kekhewe' yittaxijha na' Dios qe qa' ijayani'ƚ ke' ƚe'lijeiƚe ke' aqwa'mhitsik'i. ");
INSERT INTO mca_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Qe ka' Moises'ik'i in yit'ij: “Ek'enets qa iwqinhet iye atata qa enene iye,” qa yit'ij iye: “Pa'qu' uƚ'etsi'ik'i ƚe'lijeye'ets pa'qu' ƚatataye' i'nƚi'i pe'qu' ƚeneneye', les ƚe'wis qu' nattanithenhetiyij pa' witwamhi'.” ");
INSERT INTO mca_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma' qa ekheweli'ƚ qa ƚit'iƚij: “Pa'qu' ewi'ƚe' jukhewe' qu' nit'ijets pa'qu' ƚatataye' i'nƚi'i pe'qu' ƚeneneye': ‘Week na'aj wekwek qek k'eƚistaxij hats hetisij na' Dios.’” ");
INSERT INTO mca_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Qa aka'an in ƚit'iƚij, ma' hats nite' ƚiwejiniƚi'm qu' net'iftits'ets pa'qu' ƚatataye' i'nƚi'i qu' ƚeneneye'. ");
INSERT INTO mca_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Qa aka'an in ƚunye'jkii, ma' qa hats ekheweli'ƚ in ƚaqsiiƚijkii in nite' weju'ƚij kekhewe' ƚe'lijei na' Dios qe ta'ƚets kakha' ejunyejeyi'ƚ ta'ƚets ke' aqa'jteyi'ƚik'i, qa olots iye kekhewep iye ke' wekwek ƚaqsiiƚijkii hik ƚunyejei aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ha' Jesús qa taya'yii iye qu' nente'nijayets iye hekhewe' olots jukhew qa efuts iye, qa yit'ijets: —Ek'eni'ƚ yiwets e'weeki'ƚ qa' menikfelitiƚik'iha iye: ");
INSERT INTO mca_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ham pa'qu' na'nfik'i qu' nuiji'teje'm pa'qu' jukhewe' ma' qa' niwuƚ'enhet, qe pakha' yijat'ij t'atsji'ƚik'uifik'i pa'qu' jukhewe' hik pakha' yijat'ij in yiwuƚ'enhet pa'qu' jukhewe'. ");
INSERT INTO mca_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pekhewe' qu' nana'l ƚekfiiye' qa' nepiye'ek'iha aka'an.— ");
INSERT INTO mca_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ha' Jesús qa ikik'ui he' olots jukhew qa efuts qa uyifi ke' wititsi', he' ƚ'ijatshenhei qa nifaakanij pa' iikji'ha aka' yejeyumtshenijupi'. ");
INSERT INTO mca_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ha' Jesús qa yit'ijiju'ƚ: —¿Me ekheweli'ƚ iye nite' ƚenikfe'li'ƚik'i? ¿Me nite' ƚenikfe'li'ƚik'i in week pa'qu' nuiji'teje'm pa'qu' jukhewe' in nite' yiwuƚ'enhet, ");
INSERT INTO mca_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","qe nite' uiji'teje'm pakha' ƚatawe'j, qa ƚekutjiiƚe uiji'teje'm, qa i'nk'aƚe qa ikik'uifik'i iye?— Ha' Jesús in yit'ij aka'an qe qa' niwjutsiqenija in week ƚe'wis pa'qu' ƚunye'je'ƚe qu' netnekui. ");
INSERT INTO mca_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Qa yit'ij iye: —Pakha' yijat'ij t'atsji'ƚik'uifik'i pa'qu' jukhewe', qa hikpa' yijat'ij in yiwuƚ'enhet pa'qu' jukhewe'. ");
INSERT INTO mca_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Qe pakha' te'weiju', ikji', pakha' ƚatawejija ene' jukhew, hik pakha' ta'ƚiiju' pe' uƚ'ets ƚaqjamtikineyejeikii, qa ta'ƚets iye in wanawitjiƚi'ijju'kii ƚ'esenits, in t'ejtenkii, in teqek'ui, in hats tewhe'yeitax qa wo'oikii pekhepe' iye i'nƚi'i pakhape' iye qu' nanawitji'iƚ. ");
INSERT INTO mca_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Qa hik pakha' iye ta'ƚiiju' in iftsaxijji' qu' les olotse' wiikfik'i pe'qu' nana'li'm wekwek, qa in yaqsiijkii iye pe' wekwek uƚ'ets, qa in inqawitji iye, qa in nite' wepinij iye in yisu'un qu' nanawitji'iƚ pakhape' i'nƚi'i pekhepe', qa in teqemtshenijkii na'aj wekwek, qa in uƚ'etsik'i ƚ'anye'jijkii nikhapij, qa yumti iye qu' les nat'anipji' pekhewepe' qu' qiye'ji', qa in hik ƚunyejei iye ne'ej nite' teik'unei wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Week ekewe' uƚ'ets ta'ƚiiju' pa' te'weiteje'm, qa hik ekewe' yiwuƚ'enhet pa'qu' jukhewe' qa hik ƚunye'j iye pe'qu' efuye'.— ");
INSERT INTO mca_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ha' Jesús qa ik iye qa yamii hakha' sehe' te'weyij ha' witset Tiro. Ma' qa uyifi ke' ewi'ƚ wititsi', nite' yisu'untax qu' ninikfe'l qa nite'ƚe ƚeke' qu' nanat'inkii. ");
INSERT INTO mca_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma' qa aje'eƚ, in impi'ye'ej in tenifaakateyijju' hakha'an, ke' ewi'ƚ efu i'nji' pa' ewi'ƚ inwo'met pe' ƚasi', qa namii ha' i'ni' ha' Jesús qa wonokok'enifi. ");
INSERT INTO mca_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ke' efu nite' judioki', qe sirofeniciaki'ƚe, qa qi in iyinijetskii ha' Jesús qu' nukinik'uifik'i pa' inwo'met in i'nji' pe' ƚasi'. ");
INSERT INTO mca_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ha' Jesús qa yit'ijets: —Iwejinƚe eku'nij ne' witlits qu' nojo'oj qu' netekju', qe nite' ƚe'wisijupi' ne' witlits qu' netitkamhiti'yij na' ƚaq ma' qa' netesti'yij ne' nunajits ƚelits.— ");
INSERT INTO mca_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Qa kikhe'en qa yeku'ƚƚe, qa yit'ijets: —Yijaa'ija, ha'ne jukhew, qa ƚeke'ƚe iye ne'ej nunajits ƚelits in i'nifi ƚatawe'j na'aj witkula'x qa ne'ej ƚaqamhiltiijukii ne'ej witlits qa hik ne'ej qe tuj.— ");
INSERT INTO mca_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ha' Jesús qa yit'ijets: —In ta'ƚets aka' ƚit'ij in ƚesku'ƚ, yape ma, na' inwo'met hats ikik'uifik'i ne' oqwomeki'.— ");
INSERT INTO mca_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma' qa ke' efu in yamii pe' ƚetsi' qa yi'wen pe' ome'ƚaski' in i'wipji' pa' witiwhi'la'x, qa pa' inwo'met qa hats ikik'uifik'i. ");
INSERT INTO mca_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ha' Jesús qa ikik'ui iye ha' sehe' te'weyij ha' witset Tiro qa nekik'iju' iye hakha' sehe' te'weyijek ha' witset ƚii Sidón, ma' qa nametsju' ke' qi kaƚi' Galilea in namets hakha' sehe' ƚenqii Decápolis. ");
INSERT INTO mca_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Qa hik hakha'a' qa tetka'xii ha' ewi'ƚ jukhew nite' yepi'ye'kii qa yaqaamij iye qu' ham ƚe'lijeye'. Ha' Jesús qa te'niyinhe'yijets qu' net'eku'mipji' hakha'an. ");
INSERT INTO mca_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma' qa ha' Jesús qa t'eku'mi' qa yeka'xik'uifik'i hekhewe' olots jukhew, qa uja'xƚi'iƚkii. Ma' qa t'eku'mik'iju' ƚekfii qa tek'iyi' iye he' ƚayaqsii qa t'eku'mijipji' ha' ƚelepep. ");
INSERT INTO mca_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Qa yejeƚpha'm qa s'uuf yit'ij. Ma' qa yit'ij: —¡Effatá!— Ikji': “It'ij qhof.” ");
INSERT INTO mca_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Qa hik akaa'ijha qa qhofik'i pe' ƚekfii, qa hats q'ul iye ha' ƚelepep, ma' qa hats yeqet'axik'iha in iyet. ");
INSERT INTO mca_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ha' Jesús qa yitji'ijtaxijets hekhewe'en qu' hasu'uj nenfeli'm pe'ye'. Qa in ƚunye'jek, na'aj yiyajiji'ijtaxetskii qa lesji'ij qa nifelji'ijkii. ");
INSERT INTO mca_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma' qa qi in yitjuƚaxijpha'mkii hekhewe'en, qa yit'ijju': —Week yi'sinhetju' nakha'an. Yepiikitkii iye ne' nite' yepi'ye'tax wetju'ƚ qa yithinen iye ne' hamtax ƚe'lijeyitse'.— ");
INSERT INTO mca_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hik aka'aj iye kekhewe' neƚutsji', in ewi'ƚij iye hekhewe' olots jukhew in ham yeeƚi'ijji' pa'qu' netuj. Ha' Jesús qa taya'yii he' ƚ'ijatshenhei, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Hats tseq'eletij ene' jukhew qe hats wetshetk'ewi'ƚ ke' neƚuts in i'nyijup qa hats ham pa'qu' netuj. ");
INSERT INTO mca_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Qa qu' hipilhenintaxii hane'ej pe' ƚetsilii in hats ham pa'qu' netuj, qa nanaxkat'axijju' ƚeyipkul pa'qu' wit'ikheyije'ji', qe uja'x ne' totsii pe' ƚetsetits.— ");
INSERT INTO mca_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","He' ƚ'ijatshenhei qa yeku'ƚ: —¿Pa'n qu' netenitaƚi'yiji' pe'qu' pane' qu' niƚinijju' enewe'en, ha'ne ju'uni' ham i'ni'i'?— ");
INSERT INTO mca_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Qa nifaakanij: —¿Pa'n uja'x pe' pan na'li'ƚ e'm?— hekhewe'en qa yit'ijiju'ƚ: —Wetsjuk tatsaiƚe (7) ne' pan.— ");
INSERT INTO mca_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma' qa inaqyaji'ij qu' week na'ni'ju'kii ha' sehe'. Qa t'eku'mi' ke' wetsjuk tatsai (7) pan. Ma' qa in hats yit'ijetspha'm ƚe'wisij pa' Intata, qa napk'asitju' qa netisijju' he' ƚ'ijatshenhei qa' hik hekhewe'ye' qu' net'ihinijkii qa' nentisijju' hekhewe' olots. ");
INSERT INTO mca_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Qa na'l iye ke' uja'x sehets ƚelits, qa in hats iyinipji' iye, ma' qa yit'ijets iye qu' nentisijju' iye he' week. ");
INSERT INTO mca_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Qa week tuj qa qi in iƚinijju' iye. Qa he' ƚ'ijatshenhei qa ewi'ƚ yeni' ke' ƚaqaxpalii qa topolij iye he' wetsjuk tatsai (7) qits canastul. ");
INSERT INTO mca_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hekhewe' tuj kekhewe'en i'nƚi'i qu' namets ikwetju'ƚ mil (4.000). Ma' qa ha' Jesús qa wetfeli'm. ");
INSERT INTO mca_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma' qa aje'eƚ t'ilitji'ju' ke' witinhitjii weeki'ƚ he' ƚ'ijatshenhei. Ma' qa ikii qu' namii ha' sehe' ƚii Dalmanuta. ");
INSERT INTO mca_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Qa namii he' fariseol qu' niyetiƚju ha' Jesús, qe qa' nijaajin iye ma' qa iyintaxijets qu' nethinij pa'qu' pakha' ƚunye'je' qu' ham ƚunye'ji'iju'ƚ ha'ne wa'sji'pha'm. ");
INSERT INTO mca_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ha' Jesús qa s'uuf yit'ij, ma' qa yit'ij: —¿Inhats'ek enewe' hane'ej ƚahats'ij in iyintaxets qu' net'ethinheti'yij pa'qu' ham ƚunye'ji'iju'ƚ? Yijaa'ija aka' hit'iƚij ewets, in nite' ƚeke' qu' netesti'yij enewe' hane'ej ƚahats'ij pa'qu' ewi'ƚe' pakha' ƚunye'je' qu' ni'wen.— ");
INSERT INTO mca_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma' qa ikik'ui qa wapiliiju' iye ke' witinhitjii qa i'nji'ju' iye qa ikiiteje'm iye ha' ƚajaika' ke' kaƚi'. ");
INSERT INTO mca_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","He' ƚ'ijatshenhei qa nite' nikfe'liikii qu' neka'x ƚaqatse', qe ewi'ƚƚe ka' pan in hikka' yeka'xkii. ");
INSERT INTO mca_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ha' Jesús qa yiyajitaxetskiiha he' ƚ'ijatshenhei: —Jeƚi'ƚiju'ƚ ne' ƚeqe levadura ne' fariseol qa ne' ƚeqe levadura na' Herodes.— ");
INSERT INTO mca_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Qa he' ƚ'ijatshenhei qa aje'eƚ yifaakatetaxji' in hamitsi'm pe'qu' ƚaqatse' pan. ");
INSERT INTO mca_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ha' Jesús qa hatsƚe nikfe'lets, qa yit'ijji'ju': —¿Inhats'ek in ƚit'iƚijets qu' hamitsi'iƚ e'm pe'qu' pane'? ¿Me menjiit nite' ƚenikfe'li'ƚik'i qa qu' enikfe'li'ƚetsha iye? ¿Ye' me tit'oiji' pa' ikfeliyaxitsi'ƚkii? ");
INSERT INTO mca_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Na'l ne' otoyi'ƚ. ¿Me qa nite' ƚi'weni'ƚ? Na'l ne' ekfiyi'ƚ. ¿Me qa nite' ƚepi'ye'eƚ? ¿Me ƚantapi'iƚik'i ");
INSERT INTO mca_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","in hanapk'asiti'mju' kekhewe' lee'fij (5) pan hekhewe' lee'fij mil (5.000) yamets he' jukhew? ¿Qa pa'n uja'x canastul ke' topolij ke' ƚephelthii in ewi'ƚ ƚ'eniƚi'?— Qa yit'ijju': —Doce (12) hikke'.— ");
INSERT INTO mca_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Qa in hanapk'asiti'mju' iye kekhewe' wetsjuk tatsai (7) pan hekhewe' ikwetju'ƚ mil (4.000) yamets iye he' jukhew, ¿qa pa'n uja'x iye ke' canastul topolij iye ke' ƚephelthii in ewi'ƚ ƚ'eniƚi' iye?— Qa yit'ijju' iye hekhewe'en: —Wetsjuk tatsai (7) hikke'.— ");
INSERT INTO mca_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Qa yit'ijji'ju' iye: —¿Me qa menjiit nite' ƚenikfe'li'ƚik'i pa'n ikji' ekewe'en?— ");
INSERT INTO mca_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Qa yamets wete'm ha' witset ƚii Betsaida. Ha' Jesús qa tetka'xii ha' ewi'ƚ puk'al. Hekhewe' neka'xii qa iyinijets qu' net'eku'mipji'. ");
INSERT INTO mca_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Qa t'eku'mi' ha' ƚokoi ha' puk'al qa yetsinik'uifik'i ha' witset. Ma' qa in hats tek'iiji' he' ƚotoi qa in hats t'eku'mipji' iye, qa nifaakan: —¿Me hats ƚi'wen pe'ye'?— ");
INSERT INTO mca_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ha' puk'al qa nejeƚtaxfik'i, qa yit'ij: —Hats hi'wentax nekhewe' jukhew qa hikƚe ƚunyejei najkakui qa ikƚe.— ");
INSERT INTO mca_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma' qa ha' Jesús qa ewi'ƚij iye in t'eku'mipji' he' ƚotoi. Qa ha' jukhew wo'oiji' qu' les exkemetsaxi'ijha in nejeƚfik'i iye, ma' qa hats ƚe'wisju'. Hats week yeqet'axi'mkiiha in yejeƚkii. ");
INSERT INTO mca_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ha' Jesús in yipilheninii pe' ƚetsi', qa yit'ijets iye: —Hasu'uj mapil ji'teje'm iye na' witset.— ");
INSERT INTO mca_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ha' Jesús qa he' ƚ'ijatshenhei qa ikkii iye qe qa' namii hekhewe' witsetits ƚelits hakha' witset Cesarea de Filipo. Qa ha' wit'ikheyi'jik'i, ha' Jesús qa nifaakan he' ƚ'ijatshenhei: —¿Pa'n ƚii pa' tsumti'iikii ene' jukhew qu' yakha'ye'?— ");
INSERT INTO mca_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Qa hekhewe'en qa yeku'ƚ: —Na'l he' yit'ijets in akha' ka' Juan Bautista'ik'i, qa hekhewep iye qa yit'ijetsek iye in akha' pa' Elias'ik'i, qa hekhewep iye qa yit'ijetsek iye in akha'te' ewi'ƚ pekhewe' profetas'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ha' Jesús qa nifaakanji'ju' iye: —Qa ekheweli'ƚ, ¿ƚekpa' ƚetsumti'iƚiikiyek qu' yakha'ye'?— Ha' Pedro qa yit'ijiju'ƚ: —Akha' pa' Cristo.— ");
INSERT INTO mca_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ha' Jesús qa yiyaji'ijetskiiha qu' hasu'uj nenfeli'm pe'ye' in ƚakha' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ha' Jesús qa i'nk'aƚe yijatshenij he' ƚ'ijatshenhei: —Ha'ne Ƚa's na' Jukhew qi qu' nawtsheten hatse' pa'qu' ƚunye'je'kii, qa' nite' net'ekumi'iju'ƚ iye ne' tenek'enheiji' na' witset, qa ne' tenek'enhe'yij ne' pa'il qa nekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei. Ma' qa' ninaqyaji'ij qu' nawa'm, qa qu' namets wetshetk'ewi'ƚ neƚuts qa iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","In nifeli'm ekewe'en qa yeqetheenimik'iha. Qa ha' Pedro qa wenitonijfik'i pa'aj, ma' qa yaq'ayintaxij ekewe' yit'ij. ");
INSERT INTO mca_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ha' Jesús qa tetwek'elax qa t'ejuyii in yejeƚii he' ƚ'ijatshenhei. Qa yaq'ayinij ha' Pedro, qa yit'ij: —Me'niton ye'mii inwo'met (Satanás). Akha' nite' ƚijamti'ijets pa'qu' nisu'un na' Dios, qe uja'xƚe ene' jukhewe'ƚe in ƚijamti'ijets pa'qu' nisu'un.— ");
INSERT INTO mca_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma' qa ha' Jesús qa taya'yets hekhewe' olots qa week iye he' ƚ'ijatshenhei, qa yit'ijji'ju': —Qu' nana'l pa'qu' ewi'ƚe' qu' nisu'unija qu' natsjayan, qa' nili'ij pa'qu' ƚakhayeƚetax qu' nisu'un, net'eku'mi' yijat'ij pe'qu' ƚeqe cruze' qa' natsjayan. ");
INSERT INTO mca_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Qe pa'qu' nisu'un pa' witiƚa'x ha'ne sehe' ipji', qa qu' nawa'm qa' hami'im. Qa pakha'ƚe qu' nite' nana'yi'ij pa' witiƚa'x ha'ne sehe' ipji' qe ta'ƚ yiwets qa ta'ƚets iye ekewe' ƚe'sits wi'tlijei, qa' nanali'm pa' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Qe pa'n ƚii pa'qu' ne'weju'ƚij pa'qu' jukhewe' qu' nanaxtaxij ha'ne week sehe' ipji' qa ham ƚi'im na' witiƚa'x nite' yili'ij? ");
INSERT INTO mca_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Qe ƚek pakha' qu' ƚaqja'ye'taxij pa'qu' jukhewe' qu' nataqhaitaxets na' witiƚa'x nite' yili'ij? ");
INSERT INTO mca_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Qe pakha' qu' ƚunye'je'ƚe qu' newepinyij qa wepiniji'm iye eke' yi'lijei enewe' hane'ej ƚahats'ij nite' ewi'ƚƚi'i' nakha' yijayantax qa qi iye pe' ƚewuƚ'ets, qa ha'ne Ƚa's na' Jukhew qa' newepinjiijek hatse' pakha'an, qu' netpiltaxijju' iye na' qi ƚesa'x qa na' ƚet'unha'x iye na' Ƚatata qa ne' ƚe'sits angelits ha'ne wa'sji'.— ");
INSERT INTO mca_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ha' Jesús qa yit'ijji'ju' iye: —Yijaa'ija aka' hit'iƚij ewets, na'l enewe' uja'x hane'e'in mente' naxju' qa' ni'wen hatse' na' tenek'enheiji' na' Dios qu' nanamijju' na' qi ƚet'unha'x.— ");
INSERT INTO mca_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Qa in hats ewi'ƚ tatsai (6) ke' neƚutsik'i, ha' Jesús qa t'eku'mi' ha' Pedro qa ha' Jacobo (Santiago) qa ha' Juan iye, qa yeka'xfik'i, uja'xƚi'iƚkii, qa ikiipha'm hakha' toxpha'm ke' ewi'ƚ utek, ma' qa hik hakha'a' qa we'nethinets in tujtseika' ƚunye'j ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","He' ƚeqhinatai qa pakha' ƚunyejei qa tujji'ha, foo'ija, nite' hik ƚunye'j ha'ne sehe' epji' na'aj wempuli'jtax penyilo qu' fo'yi'ija. ");
INSERT INTO mca_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma' qa laxaji' ka' Elías qa ka' Moisés iye, tafaakate'yi'ƚju' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma' qa ha' Pedro qa nijaqhitijju' in tafaakateiju', qa yit'ijets ha' Jesús: —Maestro hayits qa ƚe'wis in ju'uni' hane'e'in. Haqsiiƚijkii wetshetk'ewi'ƚe' wititsil ƚelitse', ewi'ƚ pe'qu' akha'yi'ij qa ewi'ƚ pe'qu' ƚakha'yi'ijek na' Moisés qa' pekhepe' iye qa' ƚakha'yi'ijek na' Elías.— ");
INSERT INTO mca_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Qe ha' Pedro nite' nikfe'lets pa'qu' ni'ttaxij, qe qi in nijiwei qa hekhewe' iye Jacobo (Santiago) qa ha' Juan iye. ");
INSERT INTO mca_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma' qa namju' ke' ewi'ƚ wasi' qa ts'iƚijipji', qa pa' ewi'ƚ wit'ax nokes ji'teje'm ke' wasi', qa yit'ij: —Hane'en hik ha'ne ya's qi in hisu'un, ek'eni'ƚetsha hane'en.— ");
INSERT INTO mca_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Qa aje'eƚ pekhel yejeƚtaxijji'kii hekhewe'en, qa hatsƚe ham yi'wene', qe hats ewi'ƚƚe iye ha' Jesús in yi'wen. ");
INSERT INTO mca_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Qa in hats tepilik'uiju'kii iye ke' utek, qa yiyaji'ijetskii qu' hasu'uj nenfeli'm pe'ye' kekhewe' yi'wen, ipƚu'ui qu' iƚa'xe'tax iye ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma' qa hekhewe'en qa yaqsi'j aka' wenit'ijets qa nite' nifel, qa nite'ƚe nikfe'lik'i qa watfaakanijju' pa'n ikji'ha in yit'ijets qu' iƚa'xe' iye qu' hats nawa'mtax. ");
INSERT INTO mca_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hekhewe'en qa nifaakan ha' Jesús: —¿Inhats'ek nekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei in yit'ijets tit nonjo qu' nanam pa' Elías?— ");
INSERT INTO mca_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ha' Jesús qa yeku'ƚ: —Yijaa'ija pa' Elías qu' nanam, qa' hikpa' week naqsi'jju' ekewe' wekwek. ¿Qa inhats'ekek kekhewe' we'nika'ajji' in yit'ijets ha'ne Ƚa's na' Jukhew qu' qi pa'qu' naats'e'ej qa qu' netutenhetii iye? ");
INSERT INTO mca_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Qa yakha'ƚe qa hit'iƚij ewets ka' Elias'ik'i in hats namtax, qa ƚeqfenyejeyij kakha' yisu'un qu' ƚeqfenyejeyi'ij, in ƚ'anye'jek kakha' we'nika'ajji' t'ejuyets kakha'an.— ");
INSERT INTO mca_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma' qa in hats wapilii iye hakha' i'ni' hekhewep ƚ'ijatshenhei, qa yi'wen in k'ooyijji' in yeqewuk'un hekhewe' olots jukhew qa efuts iye, qa hekhewe' iye uja'x he' i'nq'ijatshenij ke' Moisés ƚe'lijei in qi in iyeti'ƚju'. ");
INSERT INTO mca_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Qa aje'eƚ, hekhewe' olots in yi'weniju'ƚ ha' Jesús, qa yitjuƚaxijpha'mkii, ma' qa wekuma'xiju'ƚkii qa wetfeli'mkii. ");
INSERT INTO mca_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ha' Jesús qa nifaakanji'ju' hekhewe'en, qa yit'ijji'ju': —¿Ƚekpa' ƚ'afaakateyiƚijju' enewe'en?— ");
INSERT INTO mca_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Qa ewi'ƚ hakha' i'nji'teje'm he' olots qa inku'ƚ, qa yit'ij: —Maestro, henka'xtax ei hakha' ya's i'nji' pa' ewi'ƚ ham ƚe'lijeye' espíritu uƚ'ax qa yihaminhetji'ij ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Week qa nekji'jets qa yawitjiji'ij, ma' qa nijeleji'ijetsju' sehe', qa jewf'uji'ijje'm ƚeji', qa txhak'ak'akji'ij iye ƚek'unhetii, qa t'unji'ij je'm iye qa tiiniji'ijpha'm. Hats k'iyintaxijets ene' ijatshenhei qu' nukinik'uifik'i, qa nite'ƚe yamit.— ");
INSERT INTO mca_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Qa yeku'ƚ ha' Jesús qa yit'ij: —¡Peyijaat'ij enewe' hane'ej ƚahats'ij inqeku'! ¿Pa'n ƚahats'ij qu' mexe ha'ni'ƚ etji'teje'm? ¿Pa'n ƚahats'ij qu' mexe ye'weju'ƚi'iƚ eju'ƚ in menjiit ƚ'inqeku'uƚ? ¡Enka'x met hane'e'in!— ");
INSERT INTO mca_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma' qa tetka'xets. Qa pa' espíritu uƚ'ax in yi'wen ha' Jesús, qa aje'eƚ t'unik'i in yitsalalinhetkii ha' jutjana'x ƚa's, hakha'an qa namiji'ju' sehe', qa petetpetetijkii ma' qa nekfik'i ke' ƚaq'astalii qa jewf'uje'm ha' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma' qa ha' Jesús qa nifaakan ha' ƚatata: —¿Pa'n ipƚu'uk'i pa'aj in ƚunye'j aka'an?— Qa yeku'ƚ, qa yit'ij: —In mexee'ija. ");
INSERT INTO mca_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Qa hats olotsij in yiwu'mji'ijtaxji'ju' na'aj fe't qa na'aj iweli' iye qe wo'taxii qu' naq'alij. Qa qu' eke'ye' qu' aqsiijkii pe'ye', enq'eleti'ƚyij iye wat'ij qa' etsi'feni'ƚ wat'ij.— ");
INSERT INTO mca_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ha' Jesús qa yit'ijets: —¿Pa'n ƚ'ukinji' in ƚit'ij “qu' eke'ye'?” Week eke' wekwek nite' jutsitaxi'm pakha' qu' nite' ninqekuye'.— ");
INSERT INTO mca_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma' qa aje'eƚ hakha' ƚatata ha' jutjana'x ƚa's qa tayai, qa yit'ij: —¡Nite' heqeku'uk'i! Etsi'fenij wat'ij pa' nite' yeqekuye'jtax.— ");
INSERT INTO mca_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ha' Jesús qa yi'wen in te'nilit'ii hekhewe' olots he' jukhew qa efuts, ma' qa yaq'ayinij pa' espíritu uƚ'ax, qa yit'ijets: —Espíritu ham ƚe'lijeye' qa nite' yepi'ye'kii iye, yakha' hit'ij ewets: Ma'ak'uifik'i nakha'an qa' hasu'uj mapil ji'teje'm iye.— ");
INSERT INTO mca_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma' qa pa' inwo'met in hats tayai qa in hats qi in yik'elelinhetkii iye, qa ikik'uifik'i. Qa ha' jutjana'x ƚa's qa hik ƚunye'j qu' nawa'm. Qa yaqaamij qu' weeke' hekhewe' olots in yit'ijju': —¡Hats wa'm!— ");
INSERT INTO mca_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Qa ha' Jesús qa t'eku'mi' ha' ƚokoi qa niihinpha'm, qa ha' jutjana'x ƚa's qa niipha'm qa ts'ap'a. ");
INSERT INTO mca_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ha' Jesús in hats uyifi ke' wititsi', qa he' ƚ'ijatshenhei qa nifaakan in uja'xƚi'iƚkii: —¿Inhats'ek yekheweli'ƚ in nite' ƚeke' qu' hukini'ƚfik'i?— ");
INSERT INTO mca_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ha' Jesús qa yit'ijiju'ƚ: —Aka'aj'in in ƚunye'j pa'qu' inwo'met'e ham yamite' qu' nukintaxfik'i, qe ewi'ƚe' yijat'ij pa' wit'iyinheye'j.— ");
INSERT INTO mca_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ha' Jesús qa he' ƚijatshenhei qa ikik'ui iye hakha' i'ntaxi', qa nek ji'teje'm ha' sehe' Galilea. Ha' Jesús qa nite' yisu'untax qu' ninikfe'l, ");
INSERT INTO mca_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","qe mexe yijatshen he' ƚ'ijatshenhei. Qa yit'ijets: —Ha'ne Ƚa's na' Jukhew testi'yij hatse' nekhewe' jukhew qa' nilan. Qa qu' namijets wetshetk'ewi'ƚ neƚuts qu' nawa'm, qa' iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Qa nite'ƚe nikfe'lik'i aka'an hekhewe'en, qa nijiwe'yets qu' nanfaakanijha. ");
INSERT INTO mca_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma' qa hats yamets ha' witset Capernaum, qa in hats i'ni'ƚifi ke' wititsi', qa ha' Jesús qa nifaakanji'ju': —¿Ƚekpa' ƚifaaketeji'iƚji' hakha' wit'ikheyi'jik'i?— ");
INSERT INTO mca_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Qa hamƚe yeku'ƚe' hekhewe'en, qe ha' wit'ikheyi'jik'i yifaakateji' pa'n ƚii pa'qu' les qiye'ji' hekhewe'en qu' netnek'enhei. ");
INSERT INTO mca_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma' qa i'nju' ha' Jesús qa taya'yets he' doce (12) ƚ'ijatshenhei, qa yit'ijji'ju': —Qu' nana'l pa'qu' nisu'un qu' nojo, qa hik pakha'ye' qu' netke'lenju' qa' net'iftits'etsha iye ene' week.— ");
INSERT INTO mca_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Qa t'eku'mi' ha' ewi'ƚ omeƚa's, qa yenji'ju' ƚeqewuk'u hekhewe'en, qa tik'eyij iye, qa yit'ijji'ju': ");
INSERT INTO mca_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pakha' qu' neneqjunu'uji' aka' yiiji' pa'qu' ewi'ƚe' omeƚa's in ƚunye'jek hane'en, qa yakha'ƚe in neqjunu'yij, qa pakha' qu' neneqjunu'yij nite' yakha' qu' neneqjunu'yij, nakha'ƚe ts'ukinju' hikna' neqjunu'uj.— ");
INSERT INTO mca_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma' qa ha' Juan qa yit'ijets: —Maestro, hi'weniƚij ha' ewi'ƚ in yukinik'uifik'i pe' inwo'metets yit'iji' aka' ii, qa haq'ayinƚi'iƚij qe nite' i'n'init ji'teje'mkii.— ");
INSERT INTO mca_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Qa ha' Jesús qa yit'ijets: —Hasu'uj aq'ayini'ƚij, qe ham pa'qu' nit'iji' aka' yii in yaqsiijkii pa'qu' ham ƚunye'ji'iju'ƚ, ma' qa' aje'eƚ qu' uƚ'axi'ik'i pa'qu' ƚ'anye'je'yij. ");
INSERT INTO mca_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Qe pakha' qu' nite' i'nejuihifeyi'ij pakha'an inife. ");
INSERT INTO mca_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Qe pa'qu' ƚunye'je'ƚe qu' neƚisi'ƚij pa'qu' ewi'ƚ wasuye' iweli'ye', qu' nata'ƚets in ƚijayani'ƚ ha'ne Cristo, yijaa'ija aka' hit'iƚij ewets, pakha'an nite' yaqamij pa'qu' ƚenisit'e'.— ");
INSERT INTO mca_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Qa pa'qu' ƚunye'je'ƚe iye qu' naqsiijkii qu' nilanhenijifi pe'ye' ewi'ƚe' enewe' mente' qits nite' tseqeku', les ƚe'wistax qek hayiits newet-sifinijifi ƚaqawe'j ne'ej qi ute t'ejuyets na'aj we'neqhipitju' ƚetsinki na'aj matikkatax, ma' qekha netwumhitiitaxji'ju' na' qi iweli'. ");
INSERT INTO mca_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Qa qu' nakha'ye' okoi qu' hikna' nata'ƚets in ƚaqsiijkii pa' uƚ'ax qa' isa'xii, qe les qu' ƚe'wise' qu' amii na' witiƚa'x qu' ewi'ƚe'ƚetax pa'qu' hame' na' ese'n, qa nite' hik ƚunye'j qu' week netwumhitiyeji'ju' na' ese'n na' fe't, hik nakha' nite' yom, ");
INSERT INTO mca_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(hik nakha'a' nakha' ƚoqo q'oiq'oq'oi nekhewe'en nite' wa'm, qa na' fe't qa nite' yom.) ");
INSERT INTO mca_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Qa qu' nakha'ye' ef'i' qu' nata'ƚets in ƚaqsiijkii pa' uƚ'ax qa' isa'xii, qe les qu' ƚe'wise' qu' etepeep tepepeƚe qu' amii na' witiƚa'x, qa nite' hik ƚunye'j qu' weeke' wetets ne' ef'iyei qu' ewumhitiiji'ju' na' qi fe't, hik nakha' nite' yom. ");
INSERT INTO mca_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Hik nakha'a' nakha' ƚoqo q'oiq'oq'oi nekhewe'en nite' wa'm, qa na' fe't qa nite' yom.) ");
INSERT INTO mca_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Qa qu' nekhe'ye' oto' qu' nata'ƚets in ƚaqsiijkii pa' uƚ'ax, qa' enifte'pha'm, qe les qu' ƚe'wise' qu' amii na' tenek'enheiji' na' Dios qu' ewi'ƚe'ƚetax pe'qu' otoye', qa nite' hik ƚunye'j qu' weeke' wetets ne' otoi qu' ewumhitiiji'ju' na' qi fe't. ");
INSERT INTO mca_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hik nakha'a' nakha' ƚoqo q'oiq'oq'oi nekhewe'en nite' wa'm, qa na' fe't qa nite' yom. ");
INSERT INTO mca_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Qe week hatse' enewe'en qu' newet-tsile'ƚipji'kii pa' fe't, in ƚunye'jek na'aj qe yefulutipji'kii na'aj ƚaq na'aj witlepinek. ");
INSERT INTO mca_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na'aj witlepinek ƚe'wis, qa qu' nite'ƚe ek'eme'ye' pa' witlepinek ¿qa pa'n qu' eqfenyejeyi'iƚij qu' ek'emeti'ƚ iye? Hik ejunyejeyi'iƚ na'aj witlepinek in ƚe'wis, qa hasu'uj iye qu' anwakayu'uƚ wetju'ƚkii e'ƚe'sitse'ƚi'iƚi'mkii yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","In hats ikik'ui iye ha' Jesús ha' witset Capernaum, ma' qa yamets ha' sehe' Judea, qa ikiiteje'm hakhap iye ƚajaika' ha' haqqi' Jordán. Qa hik hakha'a' iye qa not'axets iye he' olots jukhew qa efuts, qa ka' hats ƚeqfenye'jji'jij, ma' qa yijatshen. ");
INSERT INTO mca_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Qa he' uja'x fariseol qa nekets ha' Jesús, qe qa' nijaajin, ma' qa nifaakanij: —¿Me ƚenexke'ej pa'qu' jukhewe' qu' neweqle'eƚ pe'qu' ƚewhe'ye'ye'?— ");
INSERT INTO mca_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Qa yeku'ƚ ha' Jesús hekhewe'en: —¿Pa'n yit'iƚij ewets ke' ƚe'lijei ka' Moises'ik'i?— ");
INSERT INTO mca_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hekhewe'en qa yit'ijju': —Pa' Moises'ik'i ƚexke'ej pa'qu' jukhewe' qu' naqsiijkii pa'qu' witfaakanek'e t'ejuyets qu' neweqle ma' qa' nukin pe'qu' ƚewhe'ye'ye'.— ");
INSERT INTO mca_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ha' Jesús qa yit'ijiju'ƚ: —Qe t'units pe' atawjetsi'ƚ, ham eq'iltaxitsi'iƚ, ka' Moises'ik'i qa yika'ajji' aka' qu' nenit'ij. ");
INSERT INTO mca_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Qa nite'ƚe hik aka' ƚunye'j in i'nk'a wanaqsiijkii ha'ne week, pa' Dios qa yaqsiijkii pa' jukhew qa pe' efu. ");
INSERT INTO mca_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Qa aka'an in ta'ƚijupi', pa'qu' jukhewe' qa' niwejin pa'qu' ƚatataye' qa pe'qu' ƚeneneye' iye, ");
INSERT INTO mca_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","qa enewe' wetsjuk qa hats ewi'ƚƚe pa' ƚ'ese'n. Ma' qa hats nite' wetsjuk, hats ewi'ƚƚe pa' ƚ'ese'n. ");
INSERT INTO mca_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Qa hik ta'ƚijupi', pe'qu' hats ewi'ƚ neni' na' Dios, ham pa'qu' jukhewe' qu' nak'esa'x wetju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Qa in hats i'nifi ke' wititsi', qa he' ƚ'ijatshenhei qa ewi'ƚij iye in nifaakanijha aka'an. ");
INSERT INTO mca_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Qa ha' Jesús qa yit'ijji'ju': —Pa'qu' neweqle qa' tujtseika'ye' iye pe'qu' ƚewhe'ye'yi'ij iye, ma' qa hats wetwuƚ'enhetets pe' hayiits ƚewhe'yetax qe yaqsiimijkii kakha' witwuƚ'ax (adulterio). ");
INSERT INTO mca_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Qa pe'qu' efuye' iye qu' neweqle qa' tujtseika'ye' iye pa'qu' ƚewhe'ye'yi'ij qa hik ƚunye'j iye, yaqsiijkii iye kakha' witwuƚ'ax wo'oi jukhew in hats tewhe'yeitax (adulterio).— ");
INSERT INTO mca_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ha' Jesús qa tetka'xets he' uja'x omehets, qe qa' net'eku'mipji' ƚesinjel, qa he' ƚ'ijatshenhei qa yaq'ayintaxij hekhewe' neka'xtaxii. ");
INSERT INTO mca_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ha' Jesús in yi'wenij ma' qa nayu'kii, qa yit'ij: —Enwejini'ƚ met ne' omehets qu' nenek yiwets, qa hasu'uj othetiƚik'ui qe nekhewe' hik ƚunyejei enewe'en hik nekhewe' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nite' hik ƚunye'je' na'aj omeƚa's in nite' inqeku' qa nite' net'ekumiju'ƚ na' tenek'enheiji' na' Dios, qa' nite' ƚeke'ye' qu' nuiji'teje'm nakha'an.— ");
INSERT INTO mca_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Qa tik'eyij he' omehets, qa iyinipji', qa t'eku'mjiipji' ƚesinjel. ");
INSERT INTO mca_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","In hats nikheyu' ha' Jesús qu' nakij iye pa' ƚ'ikheyi'j, qa tekuma'xii ha' ewi'ƚ, qa wonokok'eni'ju' ƚ'ejuyi'jii, qa nifaakan: —Teik'unei maestro, ¿pa'n ƚii pa'qu' haqsiijkii hats'inha qu' nana'l ye'm pa' witiƚa'x nite' yili'ij?— ");
INSERT INTO mca_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ha' Jesús qa yit'ijiju'ƚ: —¿Inhats'ek in ƚit'ij yiwets teik'unei? Ham pa'qu' ewi'ƚe' qu' neteik'unei. Ewi'ƚƚe na' teik'unei, Dios. ");
INSERT INTO mca_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Akha' hats ƚenikfe'lets kekhewe' wenit'ij: “Hasu'uj eqek'ui. Hasu'uj mowo'oi efu qu' hats ewhe'yei qa hik ƚunye'j iye ne'ej efu, hasu'uj ejtenkii, hasu'uj mowotk'onƚi'imkii pe'qu' netnek'enhei, hasu'uj awitji'iji' pe'ye' pakhape', ek'enets qa' iwqinhet iye atata qa enene iye.”— ");
INSERT INTO mca_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hakha'an qa yeku'ƚ: —Maestro, hats week ekewe'en hayiits heik'eenik'iha in mente' ye'qi.— ");
INSERT INTO mca_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ha' Jesús qa yejeƚju', qa qi in yisu'un, qa yit'ijets: —Ewii'ƚƚi'ija pa' ham e'm. Yape ma. Qa ihinijkii week pe' na'l e'm qa' ƚisij ne' ham yiwq'axine'. Ma' qa' nana'l e'm pa'qu' enisit'e na' wa'sji', qa' etpil iye, qa' atsjayan.— ");
INSERT INTO mca_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Qa hakha'an in yepi'ye' ek'i aka'an, qa selelju', qa qi in uƚ'axi'mkii in ik, qe ƚakha' yiwq'axinija pe' wekwek. ");
INSERT INTO mca_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ha' Jesús qa yejeƚ ji'teje'mkii hekhewe' yeqewuk'un, qa yit'ijji'ju' he' ƚ'ijatshenhei: —¡Hayits qa jutsitax nekhewe' yiwq'axin wekwek qu' nuiji'teje'm na' tenek'enheiji' na' Dios!— ");
INSERT INTO mca_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","He' ƚ'ijatshenhei qa yitjuƚaxijpha'mkii ekewe' yit'ij. Qa ewi'ƚij iye ha' Jesús in wapilijupji' iye in yit'ijets: —Yilits, ¡hayits qa jutsitax qu' nuiji'teje'm na' tenek'enheiji' na' Dios! ");
INSERT INTO mca_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Les qu' nite' jutsitaxe' pa'qu' ewi'ƚe' ats'etax qu' nuyii ne'ej tawjena'x ƚoto', qa nite' hik ƚunye'j pa'qu' ewi'ƚe' yiwq'axin wekwek in jutsitax wiikfik'i qu' nuiji'teje'm na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Qa hekhewe'en qa les in qi in yitjuƚaxijpha'mkii iye, qa watfaakateji'ijju', qa yit'ijju': —Maa, ¿qa ƚekpa' ek qu' ƚeke'ye' qu' namii na' wa's?— ");
INSERT INTO mca_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Qa ha' Jesús yejeƚ ji'teje'm, qa yit'ijji'ju': —Ene' jukhew nite' ƚeke' qu' naqsiijkii aka'an. Ewi'ƚƚe na' Dios in ƚeke', qe week eke' wekwek nite' jutsitetsi'm na' Dios.— ");
INSERT INTO mca_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma' qa ha' Pedro qa yit'ijets ha' Jesús: —Jeƚ, yekheweli'ƚ week henejeti'ƚ he' na'ltaxi'ƚ ye'm, ma' qa k'ajayani'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Qa ha' Jesús, qa yit'ij: —Yijaa'ija aka' hit'ij ewets, in ham pakha' qu' hats niwejinƚi'i pe'qu' ƚetsi'ye', i'nƚi'i pe'qu' ƚamatsitse' qa ƚek'injats iye, i'nƚi'i pe'qu' ƚekutiiye' qa ƚek'injai iye, i'nƚi'i pe'qu' ƚeneneye', i'nƚi'i pa'qu' ƚatataye', i'nƚi'i pe'qu' ƚelitse', i'nƚi'i pa'qu' ƚeq'ejinqa'wet'e in ta'ƚ yiwets qa eke' yi'lijei iye, ");
INSERT INTO mca_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","qu' nite' nat'ani'ipji' qu' cien (100) ni'ij ne'ej testi'yij ha'ne hane'ej ƚahats'ij: axe'm ƚetsil, ƚamatsits qa ƚek'injats iye, ƚekutii qa ƚek'injai iye, ƚenenel, qa ƚelits iye, qa ƚeq'ejinqa'wetits iye. Qa na'lƚi'ijup iye pe'qu' wekweke' qu' naats'e'ej qu' natawitjaxtii. Qa pa' mexe hamik'ui qa hikpa' pa' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Qa olotsƚe nekhewe' hane'ej yojo, qa' hik nekhewe'ye' hatse' qu' netke'lenju'. Qa olots iye nekhewe' hane'ej teke'lenju' qa' hik nekhewe'ye' hatse' qu' nojo.— ");
INSERT INTO mca_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hekhewe'en in ikik'i ha' wit'ikheyi'j qu' namii ha' Jerusalén. Ha' Jesús yojo'ok'oi hekhewe'en, he' ƚ'ijatshenhei qi in nite' nikfe'lijkii pa'n ƚunyee'jkiiha, qa hekhewep hekhewe' nijayanik'i qa qi in nijiwei. Ha' Jesús qa t'eku'mi' iye he' doce (12) ƚ'ijatshenhei qa wetqetheni'ƚju' iye. Ma' qa nifeli'mha kakha' qu' ƚunye'je'kii hatse'. ");
INSERT INTO mca_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Qa yit'ij: —Ek'en qeku'ni'ƚek, hane'ej qu' jinamtaxiipha'm na' Jerusalén. Qa hik nakha'yi'i' ha'ne Ƚa's na' Jukhew qa' netesti'yij nekhewe' tenek'enhe'yij ne' pa'il, qa nekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei qa' ninaqyaji'ij qu' natlanhetii qa' netisij nekhewe' jukhewiikal nite' judiol. ");
INSERT INTO mca_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Qi qu' nawitji'iji' pe'qu' ƚe'lijeye' qa' nilakijukii qa' netk'iyikii iye, qa' neqsilanje'mkii ma' qa' nilaanija qa' nawa'm. Qa qu' namets wetshetk'ewi'ƚ neƚuts qa' iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ma' qa ha' Jacobo (Santiago) qa ha' Juan, hik hekhewe' he' wetsjuk ƚelits ha' Zebedeo, qa ikets qa we'tmetinheti'm ha' Jesús, qa yit'ijets: —Maestro, hisu'untaxi'ƚ qu' aqsi'ji'ƚ ye'mijkii aka' qu' nek'iyini'ƚij ewets.— ");
INSERT INTO mca_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ha' Jesús qa yit'ijiju'ƚ: —¿Ƚekpa' ƚisu'uni'ƚ qu' haqsi'ji'ƚ e'mijkii?— ");
INSERT INTO mca_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hekhewe'en qa yit'ijets: —Ets'eni'ƚi' hatse' qu' enek'enheitax qu' ewi'ƚe' pa'qu' na'ni'ju' na' ƚeniyayik'i qa pakhap qa' na'ni'ju' ek na' efeyi'j.— ");
INSERT INTO mca_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ha' Jesús qa yit'ijiju'ƚ: —Aka' ƚ'iyintaxi'ƚets nite' ƚenikfe'li'ƚets. ¿Me ƚeke' qu' iya'aƚji' nakha' qi ek'imiiji' k'iya'ji' hatse'? ¿Me ƚeke' iye qu' mempulijiƚijju' nakha' hempuli'jji' hatse'?— ");
INSERT INTO mca_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hekhewe'en qa yeku'ƚ: —Ehe, ƚeke'.— Ha' Jesús qa yit'ijets: —Ekheweli'ƚ ƚ'iya'aƚji' hatse' na' ek'imiiji' k'iya'ji' hatse', qa' mempulijiƚijju' iye nakha' qu' hempuli'jji' hatse'. ");
INSERT INTO mca_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Qa qu' niƚi'iƚiju' ha'ne ts'iyayik'i i'nƚi'i ha'ne yifeyi'j, qa nite' yakha' qu' k'eƚisiƚij, qe uja'xƚe pekhewe' hats watji'leti'm.— ");
INSERT INTO mca_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hekhewe' diez (10) ƚ'ijatshenhei in yepi'ye' ek'i aka'an, ma' qa nayu'um hekhewe' Jacob (Santiago) qa ha' Juan. ");
INSERT INTO mca_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Qa ha' Jesús qa taya'yets week hekhewe'en qa yit'ijji'ju': —Ekheweli'ƚ ƚenikfe'li'ƚets nekhewe' tenek'enhe'yipji' ne' nite' judiol in ewi'ƚƚe in yisu'un qu' nenethinijkii pa' ƚet'unhaxits in tenek'enhei. Qa nekhewe' te'weyik'uiju' nekhewe'en qa yisu'unek in inaqyaji'ijkii pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Qa ekhewelƚi'iƚ qa' hasu'uj ejunyejeyi'iƚ aka'an, qe pakha' qu' nisu'un qu' neniwqinhetji' ekheweli'ƚ, qa' hik pakha'ye' qu' nithayiki'iƚ. ");
INSERT INTO mca_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Qa pa'qu' ƚunye'je' iye ekheweli'ƚ in yisu'un qu' nojo, qa' hik ƚunye'je' qu' ƚeqejkunenek'e ene' week. ");
INSERT INTO mca_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Qe ha'ne iye Ƚa's na' Jukhew nite' nam ma' qa' neteniftitshiyets, qe nam yijat'ij qe qa' net'iftits'ets ene' week qa' net'ihinij iye na' ƚiƚa'x, hats'inha qu' nilithinik'ui pa' witaxtanithenkeye'j pe'qu' olotse'.— ");
INSERT INTO mca_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma' qa yamets ha' Jericó. Qa in hats ikik'uifik'i iye ha' Jericó qa week iye ƚ'ijatshenhei qa hekhewe' iye olots jukhew qa efuts. Ewi'ƚ ha' puk'al iyiniikii ƚaq'astaye' ƚii Bartimeo, Timeo ƚa's, i'niju' ƚekuwe'e' ha' wit'ikheyi'j. ");
INSERT INTO mca_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","In impi'ye'ej in hik kakha'ija Jesús Nazaret ƚeiƚe', qa yapeƚek qa tayai, qa yit'ij: —¡Jesús, ƚa's pa' David'ik'i, enq'eletyij wat'ij!— ");
INSERT INTO mca_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Qa olots he' yaq'ayintaxij in tayaikii. Qa yape'enhaƚe les in yit'unhetik'ikii in tayai: —¡Ƚa's pa' David'ik'i, enq'eletyij wat'ij!— ");
INSERT INTO mca_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma' qa ha' Jesús qa teke'lenijupju' qa yit'ij: —Aya'yi'ƚii.— Ma' qa teniya'yii ha' puk'al qa wenit'ijets: —Ment'unhet, hasu'uj e'nijiwei, eniipha'm, qe hats tayai ei.— ");
INSERT INTO mca_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Qa yiwu'mi'ju' ha' ƚe'ntilafit qa ts'enpha'm qa ikii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ha' Jesús qa nifaakan: —¿Ƚek pakha' ƚisu'un qu' haqsi'j e'mijkii?— Ha' puk'al qa yeku'ƚ: —Maestro, hiyee' hisu'untax qu' hi'wenkii.— ");
INSERT INTO mca_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ha' Jesús qa yit'ijets: —Yape ma, pa' nite' eqekuye'j hikpa' ta'ƚets in hats ƚanaxpa'l.— Qa hik akaa'ijha ha' puk'altax ma' qa yi'wenkii, qa yijayan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ha' Jesús in hats k'esiyu'ui ha' Jerusalén, qe hats meti'm hekhewe' witsetits ƚelits Betfagé qa ha' Betania, metitsi'm ke' utek ƚii Olivo. Ma' qa yukin he' wetsjuk hekhewe' ƚ'ijatshenhei ");
INSERT INTO mca_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","qa yit'ijets: —Ma'aƚiiteje'm na' witset ƚa's, qa qu' uyi'ƚ ji'teje'm qa' aje'eƚ i'weni'ƚ pa'qu' nonophe'ƚ matikatax ƚa's mexe ham i'ni' ipji'. Qa' enit'iƚijii qa' enka'xi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Qa qu' nana'l pa'qu' ni'ttaxi'ƚij ewets: “¿Inhats'ek in eqfenyejeyi'ƚij kakha'an?” qa' it'iƚijiju'ƚ: “Ha' Yatsat'ax'inij yisu'un. Aje'eƚƚete' ek tit nenpilet iye hatse'.”— ");
INSERT INTO mca_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hekhewe'en qa ikiiteje'm ha' witset qa yi'wen ha' matikatax ƚa's wo'nophe'ƚi' pa' ipƚu'umets pa' ƚeji' pa' wit'ikheyi'jji'. Qa nit'ijii pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Qa pe' uja'x pekhewe' i'ni' pakha'an, qa yit'ijets pa'aj: —¿Inhats'ek in ƚenit'iƚijii na' matikatax ƚa's?— ");
INSERT INTO mca_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma' qa hekhewe'en qa yeku'ƚijiju'ƚ pa'aj kekhewe' hats ƚ'anye'jets ha' Jesús. Ma' qa ƚexkeliji'm qu' nenka'xii. ");
INSERT INTO mca_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma' qa neka'xii ha' Jesús ha' matikatax ƚa's, qa yipk'eni'pji' he' ƚe'ntaafitits ƚaqlatiyij, ha' Jesús qa i'nipji' hakha'an. ");
INSERT INTO mca_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Qa olots he' yipk'enik'uyiju'kii ha' wit'ikheyi'jik'i he' ƚe'ntaafitits, qa hekhewep iye qa yifekinik'i ek ke' najak ƚesejets qa yenik'uiji'kii iye ha' wit'ikheyi'jik'i. ");
INSERT INTO mca_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hekhewe' yojo'ok'oi qa he' teke'lenijupju' iye, week taya'yijipji': —¡Ƚe'wisija ha'ne nam inii! Ƚe'wis ha'ne namij aka' ƚiiji' pa' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Qi in ƚe'wis in nam qu' netnek'enhei qu' hik ƚunye'je' pa' i'nalek'ik'i David'ik'i in tenek'enhei pa'aj! ¡Ƚe'wisija pakha' i'ni' pa' les in toxpha'm!— ");
INSERT INTO mca_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ma' qa hats uiji'teje'm ha' Jerusalén, qa yamets ke' witlijtsitjii qa uyifi. Ma' qa in hats yejeƚkii ke' wekwek ha' ƚatawejifi, qa ikik'uifik'i iye, ma' qa wapilik'i iye qe qa' nakii ha' Betania qe hats metiyu'ju' junu' qa week iye he' doce (12) ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Qa kakhap neƚuji', in ikik'uifik'i iye ha' Betania, ha' Jesús qa yoksi'wen in iyipkun. ");
INSERT INTO mca_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Qa mexe toxii in yi'wenii ke' ewi'ƚ najkak higokuk hats tesejeitax. Ma' qa iktaxets qu' nejeƚji'teje'm me na'ltu'u pe'qu' ƚe'ye', qa in yamtaxets qa ham yi'wene' uja'xƚe ke' ƚesejets, qe mexe nite' ƚahats'ij ne'ej higokuk qu' netei. ");
INSERT INTO mca_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ha' Jesús qa yiyaji'ets ke' najkak, qa yit'ijets: —Nite' ƚ'anuuyi'i pa'qu' netuj pe'qu' eiye'.— Qa he' ƚ'ijatshenhei qa yepi'ye' ej aka' yit'ij. ");
INSERT INTO mca_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma' qa yamets iye ha' Jerusalén, ha' Jesús qa uyifi iye ke' witlijtsitjii, ma' qa yapeƚek qa yiwutshenfik'ikii hekhewe' t'ihintaxij ke' wekwek qa hekhewe' iye taqhayetskii ke' wekwek in i'nijifi ke' witlijtsitjiyifi. Qa yiwu'mkii ke' ƚeqe mesal hekhewe' wetpiletetskii ƚ'astai, qa kekhewe' iye ƚots'oji'laxits hekhewe' t'ihinij ke' ofol. ");
INSERT INTO mca_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Qa nite' ƚexke'ej iye pa'qu' ƚ'ikheyi'jeƚi'ij qu' nijaqhitjiteje'm ke' witlijtsitjii in yeka'x pe'qu' wekweke'. ");
INSERT INTO mca_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Qa yit'ij in yijatshenij: —¿Me nite' yit'ij ke' we'nika'ajji': “Ene' yitsi' qu' ƚenqiyi'ij ƚ'iyinhetjii pe' week witsetits”? Qa ekhewelƚi'iƚ qa ƚaqsi'ji'ƚijkii in “ƚewejij ne' ejtenhetsilets.”— ");
INSERT INTO mca_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qa he' tenek'enhe'yij he' pa'il qa hekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei yepi'ye' ej ekewe' yit'ij, ma' qa wo'oikii pa'n qu' ƚeqfenye'ji'ij qu' nilan, qe hats nijiweyiju'ƚ, qe week hekhewe' olots jukhew qa efuts iye yisu'unik'i kekhewe' i'nq'ijatshenij. ");
INSERT INTO mca_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Qa in hats uiju' ke' junu' ha' Jesús qa he' ƚ'ijatshenhei qa ikik'uifik'ikii ha' witset. ");
INSERT INTO mca_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ma' qa hats neƚukii iye, qa leefiju' in nekijup iye ke' higokuk'ik'i. Qa yi'wen in hats week yisƚax qa yamijiiju' ke' ƚefitetsiyik'i. ");
INSERT INTO mca_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ha' Pedro qa yijamti'ik'i, ma' qa yit'ijets ha' Jesús: —Maestro, jeƚ qeku'n, eke' ƚiyaji'ets najkak'ik'i. Hats wa'mji', hats yisƚax.— ");
INSERT INTO mca_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ha' Jesús qa yeku'ƚ, qa yit'ijets hekhewe'en: —Hasu'uj eqeku'uƚ na' Dios. ");
INSERT INTO mca_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yijaa'ija aka' hit'iƚij ewets pa'qu' ƚunye'je'ƚe qu' niyaji'ets ene' utek qu' nit'ijets: “Ma'ak'ui hane'e'in qa' anamji'ju' na' qi iweli'.” Qa qu' nite' neqeku'yi'ik'i, qe yumti'ija pa' ƚatawe'j qu' ƚunye'je' pakha' hats yit'ij, ma' qa' hik pakha' qu' ƚunye'je'. ");
INSERT INTO mca_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Qa hik ta'ƚijupi' qu' hit'iƚij ewets in week ekewe' wekwek pa'qu' iyini'ƚets qu' iyini'ƚ, hasu'uj eqeku'uƚik'i in hats ƚ'estiyiƚij, ma' qa' hik aka' qu' ƚunye'je'. ");
INSERT INTO mca_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Qu' iyini'ƚ, yojo qu' e'ƚe'sitse' eku'ni'ƚ wetju'ƚ qu' nana'l pakha' qu' mexe nite' e'ƚe'sitsi'iƚij wetju'ƚ, hats'inha qa' ƚunyeje'ji'jek na' Atata'aƚ i'ni' na' wa's qu' niwu'miƚ'ek'ui pe' ewuƚ'etsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Qa qu' nite'ƚe isu'uni'iƚ qu' e'ƚe'sitsi'iƚ wetju'ƚ, qa' ƚunyeje'ji'jek na' Atata'aƚ i'ni' na' wa's qu' nite' niwumi'iƚ ek'ui pe' ewuƚ'etsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ha' Jesús qa he' ƚ'ijatshenhei qa yamii iye ha' Jerusalén. Ha' Jesús in mexe yijalkisifikii ke' witlijtsitjii, qa namets he' tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei qa hekhewe' iye tenek'enheiji' na' witset. ");
INSERT INTO mca_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hekhewe'en qa nifaakan: —¿Ƚekpa' tenek'enhei neƚisij qu' aqsiiji'kii hane'e'in ekewe' wekwek? i'nƚi'i ¿ƚekpa' neƚisij pa' ƚet'unha'x in tenek'enhei hats'inha qu' aqsiijkii ekewe'en?— ");
INSERT INTO mca_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ha' Jesús qa yeku'ƚiju'ƚ, qa yit'ijets: —Yakhap ji'jek qu' k'afaakanjiiƚek, ojo'oƚij qu' enfeli'ƚ ye'm aka' qu' k'afaakani'ƚij, ma' qa henfeljii'ƚ e'mek hatse' nakha' ta'ƚets in haqsiijkii aka'an. ");
INSERT INTO mca_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","In wenqimpulijin ka' Juan, ¿Me ta'ƚets na' Dios? ¿Me i'nƚi'i ene' jukhewƚe? ¡Enfeli'ƚ ye'm!— ");
INSERT INTO mca_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma' qa wapilƚi'ij wetju'ƚ in iyetijju', qa yit'ijju': —Qu' jintit'ijets “ta'ƚets pa' Dios,” ma' qa nit'ij inwets nakha'an: “¿Qa inhats'ek in nite' ƚ'ek'eni'ƚets?” ");
INSERT INTO mca_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Qa qu' jintittaxijets “jukhewƚe ene' ta'ƚets.”— Hekhewe'en qa nite'ƚe ƚeke' qu' nit'ij, qe nijiweyiju'ƚ hekhewe' olots jukhew qa efuts, qe week yumti ka' Juan in yijaa'ija in ewi'ƚ profeta. ");
INSERT INTO mca_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma' qa yit'ijiju'ƚ hekhewe'en in yeku'ƚ ha' Jesús: —Nite' tsikfe'li'ƚets.— Ma' qa ha' Jesús qa yit'ijiju'ƚek: —Qa' yakhape' ji'jek qu' nite' henfeli'ƚ e'm na' hata'ƚijets in haqsiijkii ekewe' wekwek.— ");
INSERT INTO mca_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma' qa yejeyumtsheni'mijupi' ke' wekwek hekhewe'en: —Ewi'ƚ pa' jukhew yeni'ju' pa' ƚeq'ejinqa'wet pa' uwaket, qa yeqetsitenijijup pe' utel. Qa tijju' pa' ewi'ƚ ƚeq'itset'ij qu' nenq'umutju' pe'qu' ƚeye'. Qa yaqsiijkii iye pe' ewi'ƚ qipha'm t'ejuyets qu' nejeƚipji'kii pa' uwaket. Ma' qa i'nk'aƚe qa yatkinhenets pe' jukhew pa' uwaket, ma' qa ik inji'witshen. ");
INSERT INTO mca_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma' qa in hats yamets ƚahats'ij qu' netenifte'ji', qa pa' ewi'ƚ ƚeqejkunenek qa yukinii pekhewe' yatkinheninets pa' ƚeqe uwaket, hats'inha pekhewe' natkin pa' uwaket qa netisij pa' ƚapk'as pekhewe' ƚei pa' uwaket. ");
INSERT INTO mca_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Qa pekhewe'ƚe'en qa t'eku'mi' pa' wit'ukinektax, qa niyejinijju' in yilanje'mkii, ma' qa yiwutshenik'uifik'i iye ham tisi'ij. ");
INSERT INTO mca_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma' qa pa' yatsat'axij qa yukintax iye hakhap iye ƚeqejkunenek, qa hik pakha' qa wiikfi' yeqfe'meten pa' ƚeiƚa' qa qi iye in yawitji. ");
INSERT INTO mca_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Qa yukintax iye pakhap iye qa hikpa' qa yilaanija. Qa hik ƚeqfenyejeijiij iye pe' hats olots in yukinji'ijtax iye, yilanje'mkii pe' uja'x, qa pekhewep qa nilaanju'ha. ");
INSERT INTO mca_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Qa mexe ewi'ƚtax pa' amanij, hik pakha' pa' ƚaa'sija qi in yisu'un. Ma' qa yukintax iye ha'ne hats ewi'ƚƚe, qe yit'ij: “Tek'enets lemets qa' niwqinhetji' iye ha'ne ya's.” ");
INSERT INTO mca_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Qa pekhewe'ƚe t'ithayii qa yit'ijju' in watfaakateji'ijju': “Hik ha'ne hakha' qu' naya'xtaxij hatse', ¡yape jitalan hats'inha qa' inekhewele' qu' jinatsat'etsij hatse'!” ");
INSERT INTO mca_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma' qa t'eku'mi' qa yilan qa yahinik'uifik'i pa' uwaket, qa yiwu'mƚi'i pakha'a'. ");
INSERT INTO mca_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Pa'n qu' ƚeqfenyeje' ƚewek hatse' pa' yatsat'axij pa' uwaket? Pakha'an nam hatse' qa' nanlanju' pe' t'ithayii qa pa' uwaket qa' netisij pekhewep iye. ");
INSERT INTO mca_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ye' me nite' ƚejeƚi'ƚ aka' we'nika'ajji' in yit'ij: “Ne' ute yuten qa yiwu'mfik'i ne' niihinpha'm ne' wititsi', hane'ej qa hats ewi'ƚ ute les weju'ƚij in teniihinijpha'm ne' wititsi'. ");
INSERT INTO mca_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pa' Yatsat'ax'inij hikpa' yaqsiijkii aka'an qa in jitejeƚju' qa qi in ƚe'sits ine'm.”— ");
INSERT INTO mca_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma' qa hekhewe'en qa yisu'untax qu' net'eku'mi' noq'opheƚineyu'taxij, qe nikfe'lik'i in ƚekhewelƚe in t'ejuyets kakha' yejeyumtshenijupi', qa nijiweiƚi'iju'ƚ iye hekhewe' olots jukhew qa efuts iye. Ma' qa yiwejinƚe, qa ikik'uikii. ");
INSERT INTO mca_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hekhewe' tenek'enhe'yij he' pa'il qa nukintaxii ha' Jesús he' uja'x hekhewe' fariseol qa hekhewe' t'ithayi'yi'mek pa' Herodes (herodianos), qe qa' nit'ijets kakha' yumti qu' nopheƚipji'. ");
INSERT INTO mca_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ma' qa in namii hekhewe'en, qa yit'ijets: —Maestro, tsikfe'li'ƚets in yijaa'ija na'aj ƚit'ij qe ƚ'iyet qa nite' ƚeqethenijii pakhape' ne'ej ƚit'ij, qe week eqjunyejeyij ene' jukhew, qa yijaa'ija iye in ƚ'inq'ijatshentaxij pa' ƚ'ikheyi'j pa' Dios. ¿Me ƚe'wisijupi' in jitajaninkii eke' wekwek qu' net'ejuyets pa' Roma ƚatata, César, me nite'? ");
INSERT INTO mca_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Me jitajanin, me hasu'uj jitajanin?— Ha' Jesús qa hatsƚe nikfe'lets in we'nenƚetaxi' pekhewe'en qu' ƚunyejeye' aka'an, ma' qa yit'ijiju'ƚ: —¿Inhats'ek in ƚ'ewqeleitaxi'ƚ yik'ui? Entsheni'ƚ ewi'ƚe' nijket kekhewe' ƚaq'astai ne' Roma ƚeiƚets ne'ej denario qa hi'wen.— ");
INSERT INTO mca_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma' qa tetka'xii, ha' Jesús qa yit'ijets: —¿Ƚek ƚeju's qa ƚek ƚii iye ha'ne i'nji' ene' ƚ'astaki'?— Qa yeku'ƚ hekhewe'en: —Pa' Roma ƚatata, César.— ");
INSERT INTO mca_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma' qa ha' Jesús qa yit'ijets: —Ƚisi'ƚij pa' César pekhewe' yatsat'etsƚi'ijek pa' César, qa na' Dios pekhewe' yatsat'etsƚi'ijek in Dios.— Hekhewe'en qa qi in yitjuƚaxijpha'mkii aka' yit'ij. ");
INSERT INTO mca_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma' qa he' uja'x saduceo, qa nekets iye ha' Jesús (hik hekhewe' saduceo yumti ek pe' naxju' in nite' iƚii iye, wa'mti'ija.) Ma' qa nifaakanij, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, pa' Moises'ik'i nejet'inij pa'aj in yika'ajji' qa yit'ij: “Pa'qu' jukhewe' qu' nawa'm qa hamƚe ƚelitsi'iƚ pe'qu' ƚewhe'ye'ye', qa pa'qu' ƚek'inije' i'nƚi'i qu' ƚamats'e pakha' wa'm, qa' hikpa' qu' ƚewhe'ye'yi'ij pe' ƚewju'lelaxtax, ma' qa qu' nataltsa'yi'ƚ, qa pa' yojo qa' hikpa' qu' ƚa'si'ij pa' ƚejefe'ek'i, hats'inha qu' neniihinik'uipha'm pe'qu' nata'ƚetsek pa' ƚejefe'ik'i.” ");
INSERT INTO mca_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na'l pa'aj pe' wetsjuk tatsai (7) witk'injayek. Pa' yojo'oj in tewhe'yeitax, qa wa'mƚe pa'aj, mexe hamtax ƚa'si'iƚ pe' ƚewhe'ye'. ");
INSERT INTO mca_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Qa yaya'xij iye pakhap in ƚewhe'ye'ej iye pe' wikiihale' qa wa'mƚe iye pa'aj, mexe hamtax iye ƚa'si'iƚ, qa hik ƚunye'j iye pakha' wetshetk'ewi'ƚ in ƚewhe'ye'taxij iye. ");
INSERT INTO mca_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pekhewe' wetsjuk tatsai (7) witk'injayek ham pa'qu' nataltsa'yi'ƚ pe' efu. Ma' qa teke'lenju' qa wa'mek pe' efu'uk'i. ");
INSERT INTO mca_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ma' qa qu' iƚiye'tax iye pe' naxju', ¿pa'n ƚii qu' namijfik'i qu' ƚewhe'ye'yi'ij? Qe pe' wetsjuk tatsai (7) hats week ƚewhe'yetstaxij pe' efu?— ");
INSERT INTO mca_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ha' Jesús qa yeku'ƚiju'ƚ: —¿Me nite' ƚenikfe'li'ƚets aka' ta'ƚijupi' in ƚijaniƚik'i: in nite' ƚenikfe'li'ƚets eke' Intata ƚe'lijei qa in nite' ƚenikfe'li'ƚets iye na' ƚet'unha'x na' Dios? ");
INSERT INTO mca_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Qe qu' iƚiye'tax iye pe' naxju', hats nite' tewhe'yei hatse', qa nite' ƚeke' iye qu' netesti'yij qu' netewhe'yeiju', qe hik qu' ƚunyejeye' yijat'ij ne' angelits, wa's ƚeiƚets. ");
INSERT INTO mca_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ye'ehe, hane'ej qu' jintafaakateji' in t'ejuyets qu' iƚiye'tax pe' naxju', ¿me nite' ƚejeƚi'ƚ na' ƚafaakanek ka' Moises'ik'i, kakha' ƚ'anye'jets na' Dios in i'nijupi' ji'teje'm pe' najkak ƚasi' tujje'm, qa yit'ijets: “Yakha' ƚeqe Dios na' Abraham, na' Isaac qa na' Jacob”? ");
INSERT INTO mca_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na' Dios nite' ƚeqe Dios pe' naxju', qe ƚeqe Dios yijat'ij pe' iƚii. Qa hik ta'ƚijupi' in ekheweli'ƚ qi in ƚijaniƚik'i.— ");
INSERT INTO mca_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Qa nekets iye ha' ewi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei qe ha' Jesús in yasiinik'iha ka' yit'ijiju'ƚ hekhewe'en, qa nifaakanij: —¿Pa'n ƚunye'j pakha' les qiji' kekhewe' wenit'ij (ley)?— ");
INSERT INTO mca_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ha' Jesús qa yeku'ƚ hakha'an: —Aka' les in qiji' t'anipji' kekhewe' week wenit'ij, aka'an: “Ek'en qeku'nek, Israel, pa' Yatsat'ax'inij inqe Dios, Pa' Yatsat'ax'inij ewi'ƚƚe. ");
INSERT INTO mca_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Isu'unija pa' Yatsat'ax'inij eqe Dios weekij pa' atawe'j, weekij pa' iƚa'x, weekij pa' aqjamtikineye'jkii qa weekij iye pa' et'unha'x.” ");
INSERT INTO mca_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Qa ka' yojo'opji', qa aka'an: “Isu'un week pa'qu' mete' e'm jukhew qa efuts in ejunye'jek in ƚewetsu'unƚe.” Qa ham pakhape' iye qu' nenit'ij qu' nat'anipji' ekewe' wetsjuk.— ");
INSERT INTO mca_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Qa ha' i'nq'ijatshenij ke' Moisés ƚe'lijei qa yit'ij: —Hayits yijat'ij Maestro, kakha' ƚit'ij yijaa'ija, in ewi'ƚƚe pa' Dios, ham iye pe'ye' iye, ");
INSERT INTO mca_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","qa' jintesu'unija iye weekij pa' intawe'j, weeki'ij pa' inaqjamtikineye'jkii qa weeki'ij iye pa' int'unha'x, qa' jintesu'un week pa'qu' mete' ine'm in injunye'j intijek in jiwetsu'unƚe inte'm. Ekewe'en t'anipji' week na'aj testiitaxij i'nƚi'i qu' natlanhetiitaxifi pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","In yepi'ye' ej ha' Jesús ha' jukhew in yasiinik'iha ka' yit'ij in yeku'ƚ, qa yit'ijets: —Nite' itoxi'mii na' tenek'enheiji' na' Dios.— Ma' qa hik aka'aj qa ham iye pakhape' qu' ifiyaxi'im qu' nanfaakanijkii iye pe'ye'. ");
INSERT INTO mca_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ha' Jesús in mexe i'nq'ijatshen ke' witlijtsitjiyetsji', qa inaqfaakanij qa yit'ij: —¿Inhats'ek nekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei in yit'ijets pa' Cristo qu' ƚa'se' ka' David'ik'i? ");
INSERT INTO mca_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Qe na' Espíritu Santo hik nakha' yitijinenij ka' David'ik'i in ƚakha'ija in yit'ij: “Pa' Intata qa yit'ijets pa' Yatsat'axyij: ‘Niju' ni'iju' ha'ne ts'iyayik'i ipƚu'ui qu' hentaxiiju' ne' ef'iyei qa' otsi'pji'kii ne' ejuihifets.’” ");
INSERT INTO mca_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pa' David'ik'i in yit'ijets, “Yatsat'axyij.” ¿Qa pa'n ƚunye'j iye qu' nit'ijets qu' ƚa'se'?— Qa hekhewe' olootsija he' jukhew qa efuts iye ma' qa yisu'unija qu' nepiye' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Qa in mexe i'nq'ijatshen qa yit'ij iye: —Jeƚi'ƚiju'ƚ ne' i'nq'ijatshenij ke' Moisés ƚe'lijei, nekhewe' yisu'unƚe qu' nijalkisijkii ne' juffufuf ƚeqhinatai, qa yisu'unƚe in weniwqinhetji' in teniwetfelhi'yi'mkii ne' witaqhawetitsji'. ");
INSERT INTO mca_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Qa yisu'un iye qu' na'nipji' ne'ej wits'ojilaxits t'ejuyets ne'ej qitsji' ne'ej witlijtsitjiyifi, qa yisu'un iye qu' na'ni' na'aj ƚetset ne'ej qitsji' na'aj witkujiiji' ƚe'wis neƚu. ");
INSERT INTO mca_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nitka'mij iye ne' wikiihalei ne' ƚetsil. Qa yape'ejets iye qe iyin qe yisu'unƚe qu' ne'twenhetii, ma' qa' netjumtaxtii qu' yijaayi'ija qu' nijayan na' Intata. Enewe'en les qu' qiye' qu' nattanithenhetii hatse'.— ");
INSERT INTO mca_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ha' Jesús i'nijupju' ke' witlijtsitjiyifi ke' ewi'ƚ hekhewe' tinajkii we'nenik'iju' ƚ'astai. Yejeƚijju' hekhewe' olots jukhew qa efuts iye in yenik'iju'kii ke' ƚaq'astai. Qa olots he' patunits in yenik'iju' ke' olots ƚaq'astai. ");
INSERT INTO mca_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Qa nam ke' ewi'ƚ wikiihale' if'iljetsax ham yiwq'axine'. Qa yenik'iju' ke' wetsjuk ƚelimmits nijketits ƚelits ƚaq'astai, nite' inyetets. ");
INSERT INTO mca_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma' qa taya'yets he' ƚ'ijatshenhei, qa yit'ijji'ju': —Yijaa'ija aka' qu' hit'iƚij ewets, ene' wikiihale' ham yiwq'axine' in les olots ke' yenik'iju' t'anipji' he' week in yentaxik'iju' ke' ƚaq'astai ne' ƚ'astai ƚejiiki', ");
INSERT INTO mca_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","qe week enewe'en kekhewe' yenik'iju' hik kekhewe' ƚammi'sƚe pekhewe' olots ƚaqaxpalii ƚaq'astai pe' ƚetsilii, qa ene'ƚe wikiihale' in hamtax yiwq'axine' qa week yenik'iju' ke' na'ltaxi'm ƚaq'astayik'i qa ham amani'i' pe' ƚetsi'ii.— ");
INSERT INTO mca_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","In hats k'esiyufik'i qu' nakik'uifik'i iye ha' Jesús ke' witlijtsitjii, qa ha' ewi'ƚ hekhewe' ƚ'ijatshenhei qa' yiyaji'ets: —Maestro, jeƚ qeku'n ene' witlijtsitjii. ¡Hayits qa ƚe'sits ene' utel! ¡Hayits qa ƚe'sits ene' wititsil!— ");
INSERT INTO mca_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ha' Jesús qa yit'ijets: —¿Me hats ƚi'wen enewe' qits wititsil ene' witlijtsitjiyifi? Nite' ewii'ƚe' hatse' pe'qu' uteye' qu' amani'ipji' pekhepe' iye uteye' qu' nite' nonopƚaxeju'.— ");
INSERT INTO mca_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma' qa i'nk'aƚe, ha' Jesús qa i'niju' ke' utek'ik'ipha'm Olivos, t'ejuyiiteje'm ke' qi witlijtsitjii. Qa ha' Pedro qa ha' Jacob (Santiago) qa ha' Juan qa ha' Andrés iye qa uja'xƚi'iƚ wetju'ƚ in nifaakanij, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Enfeeli'ƚ ye'mha, ¿pa'n ipƚu'uk'ui qu' namets kakha' ƚit'ij? ¿Pa'n ƚunye'j iye pa'qu' jutsiqaxi'ij qu' hats namiyu'ets qu' ƚunyejeye'kii week eke' ƚit'ij?— ");
INSERT INTO mca_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ha' Jesús qa yapeƚek in nifeli'm, qa yit'ijets: —Jeƚi'ƚiju'ƚha, hasu'uj pa'qu' nawitji'iƚ ma' qa' naqani'ƚkii. ");
INSERT INTO mca_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Olots hatse' pe'qu' nanam qa' netyinenyij, qa nit'ij: “Yakha' ye' Cristo.” Ma' qa' naqankii pe'qu' olotse'. ");
INSERT INTO mca_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Qa qu' impi'ye'eƚij pe'qu' nawatlan qa pe'qu' nanwatlanheyu' iye, qa' hasu'ujƚe e'nijiwe'yi'ƚ, qe les ƚe'wis qu' ƚunyejeye'kii ekewe'en, qa mexeƚe nite' yamets pa' ƚ'aka'the'ju'. ");
INSERT INTO mca_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Qe ewi'ƚ pa'qu' witset'e qa' nawatlani'ƚ pakhape' iye witsetiika'ye', qa ewi'ƚ pa'qu' wittataye' qa' nawatlani'ƚ pakhape' iye wittataye'. Qa' nana'l iye pe'qu' me'le'le' witsetitse', qa pe'qu' qi qu' niyipkunju' iye. Qa hikƚe ƚunyejei ekewe'en ne'ej iwkajitshen in i'nk'a yoksi'wen pa'qu' ƚaqati'yi'ij hatse'. ");
INSERT INTO mca_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Qa ekheweli'ƚ, matjanitheni'ƚkii, qe ƚ'ekekiti'yi'ƚiikii hatse' pekhewe' qu' nejeƚik'ui pa'qu' ƚunye'je'kii (tribunal), qa' eqsilanheti'yi'ƚ je'mkii iye nekhewe' judiol ƚe'lijtsitjiyitsifi, qa' ami'ƚetsji' iye pekhewe' wit'alheiji' pe' witsetits (gobernadores) qa pe' qitsji' wittatal iye (reyes), qe ta'ƚ yiwets in ƚatsjayani'ƚha, hats'inha qu' iwq'axini'ƚij qu' enfeli'ƚi'mha pekhewe'en aka' yijunye'j. ");
INSERT INTO mca_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Qa lesƚe ƚe'wis qu' nojo qu' week netfelhitiyi'm pe' week witsetiikal ha'ne sehe' epji', in mexe nite' yamets pa' ƚ'aka'the'ju' qa' hame' ha'ne week. ");
INSERT INTO mca_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma' qa qu' ekekiti'yi'ƚii pe'qu' wit'alheyeji' pa'qu' witset'e, hasu'uj natawje'meteni'ƚ pa'qu' it'iƚijiju'ƚ, it'iƚij yijat'ij pakha' qu' neƚisi'ƚij na' Dios in hats yamets qu' iyeti'ƚ, qe nite' ekheweli'ƚ qu' iyeti'ƚ, nakha'ƚe Espíritu Santo hik nakha' qu' niyet. ");
INSERT INTO mca_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma' qa ene' jukhew qa' ninaqyaji'ij qu' natlanhetii pa'qu' ƚek'inije' i'nƚi'i pa'qu' ƚamats'e. Qa pa' ƚatata qa ninaqyaji'ij qu' natlanhetii pa' ƚa's qa i'nƚi'i pe'qu' ƚasi'ye', qa pe' witlitstax qa' ƚ'ejuihifetsi'ij pe'qu' ƚ'alheye' qa' ninaqyaji'ij qu' natlanhetiiju'. ");
INSERT INTO mca_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Week ha'ne sehe' epji' qi qu' nuteni'ƚ qe ta'ƚ yiwets in ƚatsjayani'ƚha, qa pa' qu'nte' niliye'yij qu' namijii pa' ƚ'aka'the' qa' hikpa' qu' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Qa qu' i'weni'ƚ hatse' pakha' qi uƚ'ax yeq'ilatkii hatse' qa' ne'nenifi nakha' nite' ƚeke'tax qu' na'ni' (pakha' qu' niyinenik'i, nenikfe'lik'i aka'an) ye'ehe, qa pekhewe' qu' na'ni' na' sehe' Judea aje'eƚ nilatii ne' utekui. ");
INSERT INTO mca_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Qa pa'qu' na'nipji' pe'qu' ƚetsi'ye' na'aj k'eewe'epji', qa' hasu'uj net'ilitju' qu' nenuihiyu'ufi pe'qu' ƚetsi'ye' qa' neka'xfik'i pe'qu' ƚewekwekitse'. Aje'eƚ nilat yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Qa pa'qu' na'nji' pa'qu' ƚ'ejinqa'wet, hasu'uj netpilii iye ƚ'uihitjiye'. Aje'eƚ nilat yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Qa ¡hiyee'ƚe enewusits pekhewe' qu' niwkajitshenju' qa pekhewe' qu' mexe nifunen pe'qu' ƚelitse' qu' namtaxets pekhewe' neƚutsji' qu' ƚunye'je' aka'an! ");
INSERT INTO mca_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Iyini'ƚijets na' Dios qu' hasu'uj namets aka'an qu' lop'e. ");
INSERT INTO mca_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Qe pe' neƚutsji' hatse' qii'ija pa'qu' a'taxe' qa iftsitsji'ha iye, qa ham pa'qu' hayiits ƚunye'ji'iju'ƚ in ipƚu'uk'i ek in i'nk'a wanaqsiijkii ha'ne sehe' qa yamijii hane'ej, qa nite' ƚ'anuuyi'i iye qu' ƚunye'je'kii iye hatse'. ");
INSERT INTO mca_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Qa na' Yatsat'ax'inij qu' nite' niwk'itsini'ijuƚ pekhewe' neƚutsji' hatse', qa' ham pa'qu' iƚa'xe'. Qa in ta'ƚƚe'ets pekhewe' hats te'nekumhi'yiiji' t'eku'miiji' nakha'an, ma' qa yiwk'itsiniju'ƚ kekhewe' neƚutsji'. ");
INSERT INTO mca_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Qa qu' nana'l pa'qu' ni'ttaxi'ƚij ewets hatse': “Ek'en qeku'ni'ƚ, hik ha'nete' i'ni' pa' Cristo,” i'nƚi'i qu' nit'ij “hatsiite' pa' i'ni'”. Qa' hasu'ujƚe umti'iƚ qu' yijaayi'ija. ");
INSERT INTO mca_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Qe na'l hatse' pe'qu' nit'ij ƚetets qu' Cristoye' qa pe'qu' nit'ij ƚetets qu' profetaye'. Qa' ni'nq'ethinij pe'qu' qits ham ƚunyejeyi'iju'ƚ qa pe'qu' qi qu' nitjuƚaxijpha'mkii iye, qe qa' naqankii ene' week, qa qu' ƚeke'ye', qa' naqankii iye nekhewe' hats t'eku'miiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Qa ekheweli'ƚ qa' matjanitheniƚiju'ƚ, hats ƚek week henfeli'ƚ e'm aje'eƚ ekewe'en in mente' yamets qu' nana'l.— ");
INSERT INTO mca_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Qu' nanaxijik'i hatse' pekhewe' neƚutsji' qi iftsitsji' qa a'tits iye, ma' qa ne' junu' qa' aje'eƚ nom, qa juwel iye qa'nte' nana'leji' iye, ");
INSERT INTO mca_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","qa ne' footekii qa' nanamiiju'kii iye qa pa' qi ƚet'unha'x ne' wasits qa' nawapja'. ");
INSERT INTO mca_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma' qa' ne'twenhetii ha'ne Ƚa's na' Jukhew qu' netpiltaxju' iye i'nji'teje'm pe' wasil in ta'ƚiipha'm na' wa's, qi pa'qu' ƚet'unha'xe' qa qi iye pa'qu' ƚesa'xe'. ");
INSERT INTO mca_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma' qa' nukinkii ne' angelits, qa' nonothet wetju'ƚ week pe' hats t'eku'miiji' i'ni' enewe' ikwetju'ƚ (4) ta'ƚji' na'aj t'unik'i, in uja'xek pe' week in i'nipji' ha'ne sehe' qa ha'ne wa'sji' iye. ");
INSERT INTO mca_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Maxtayit qekuni'ƚijupi' ek ne'ej ewi'ƚ higokuk aka' jiyijatshenij, in hats esufui iye ne'ej ƚenuts ma' qa ta'ƚji' iye ne'ej ƚesejets, qa hats ƚenikfe'li'ƚets in hats k'esets na'aj jinawa'p. ");
INSERT INTO mca_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Qa hik ƚunye'j, ekheweli'ƚ qu' i'weni'ƚ week ekewe' wekwek tefelhitii, qa' menikfeliti'ƚets na' Ƚa's na' Jukhew in hats metifikii na' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yijaa'ija aka' hit'iƚij ewets in nite' hamits hatse' pekhewe' qu' nanamji'ju'kii pakha' ƚahats'ij hatse', qa namƚi'ijii qu' week ƚunye'je'kii ekewe' hats hit'ij. ");
INSERT INTO mca_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na' wa's qa ha'ne sehe' hamits hatse', qa ekewe'ƚe hats hit'ij qa nite' ƚeke' qu' hamitse'. ");
INSERT INTO mca_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Qa pakha'ƚe i'niha pa' neƚuji' hatse' i'nƚi'i pa'qu' na'ni'ha pe'qu' horaye', ham nikfe'le'ets, nite' nikfe'lets iye ne' angelits wa's ƚeiƚets, nite' iye ha'ne Ƚa's, ewi'ƚƚe na' Ƚatata in nikfe'lets. ");
INSERT INTO mca_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Qa hik ta'ƚijupi', matjanitheni'ƚkii, qa' jeƚi'ƚkiiha iye, qe nite' ƚenikfe'li'ƚets pa' neƚuji' qu' namets qu' nanam. ");
INSERT INTO mca_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hik ƚunye'j pa'qu' ewi'ƚ jukhewe' in ikji' pa'qu' toxeji', qa in hats nikheyu'uk'ui pe' ƚetsi' qa nejetij pe' ƚeqejkunenhei qu' nejeƚipji', qa week yejeyumtshenij pe'qu' nithayiki, qa pa' yejeƚinenij pa' ƚeji' qa yiyaji'ets qu' natjanithenkii. ");
INSERT INTO mca_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Qa hik ta'ƚijupi', matjanitheni'ƚkiiha, qe nite' ƚenikfe'li'ƚets pa'n i'ni' junu' qu' nanam pa' yatsat'axij pe' wititsi', i'nƚi'i qu' na'najaleikii, i'nƚi'i qu' ƚeqewuk'uye'ji' naja'x, i'nƚi'i qu' ipƚu'yi'iju'ƚ neƚu, i'nƚi'i qu' leefi'iju' qu' nanam. ");
INSERT INTO mca_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","In nitjuƚati'ƚ qu' nanam, hasu'uj qu' nanami'ƚ ewets qu' ama'aƚju'. ");
INSERT INTO mca_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aka' hit'iƚij ewets, aka'an hit'ijets iye ne' weekji': ¡Matjanitheni'ƚkiiha!— ");
INSERT INTO mca_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hats wetsjuk neƚuts hamitsik'ui qu' namets ka' ƚe'wis neƚu ƚii Pascua qa pa' ƚeqe ƚe'wis neƚu iye ne'ej pan nite' yetsji'ƚ pe'qu' levaduraye'. Hekhewe' tenek'enhe'yipji' he' pa'il qa hekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei qa wo'taxiikii pakha' qu' ƚeqfenyejeyi'ij qu' naqankii ha' Jesús, hats'inha qu' net'eku'mi' qa' nophe'ƚ qa' nilan. ");
INSERT INTO mca_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Qa yi'tƚi'ijju' iye: —Qa hasu'ujƚe eku'n enewe' ƚe'sits neƚutsji', hats'inha qa' nite' nat'ayeji' qu' na'nayu'kii ene' jukhew.— ");
INSERT INTO mca_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ha' Jesús i'ni' ha' Betania ke' ƚetsi'ii ha' Simón ƚenqii iye leproso, i'nijupju' ha' ƚeqe mesa. Qa nam ke' ewi'ƚ efu neka'x ke' ewi'ƚ ute eƚi'ni'ij ta'ƚets pe' ute ƚii alabastro, topo'oj ka' ewjisii inyetax yaqamaxju'ha pa' ƚits'i ta'ƚets pe' najkak ƚii nardo. Qa yilanje'm in yit'ij qhof ke' ƚejiiki', qa yatsi'yipji' ha' ƚeiƚa' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Qa hekhewe' uja'x hekhewe' i'ni' hakha'a' qa nayu'uk'ikii qa yit'ijju' in watfaakateji'ijju': —¿Inhats'ek in yaq'ayinƚekii ka' ewjisiyik'i? ");
INSERT INTO mca_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Qe aka' ewjisiyik'i ƚeke'tax qu' ne'tninei t'antaxi' trescientos (300) denarios, ma' qekha netestiitaxij pe' qek ƚ'astayetax nekhewe' if'iljetsits.— Ma' qa yaq'ayintaxij ka' ƚeqfenye'j ƚewek ke' efu. ");
INSERT INTO mca_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Qa ha' Jesús qa yit'ij: —Iwejinƚi'iƚ, ¿Inhats'ek in ƚ'ikesime'metentaxi'ƚ ene' efu? Aka' ƚeqfenye'jyij qi in ƚe'wis yijat'ij. ");
INSERT INTO mca_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Qe enewe' if'iljetsits nite' yili'ij week ƚahatsiyij qu' nana'li'ƚ ejup. Qa qu' isu'uni'ƚ qu' iftits'iƚets qa ƚeke' qu' iftits'iƚets. Qa yakha'ƚe qa nite' week ƚahatsiyij qu' natsa'li'ƚ ejup. ");
INSERT INTO mca_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ene' efu yaqsiijkii aka' weju'ƚij qu' naqsiijkii. Hats yewjisit aje'eƚ ha'ne yaj in mexe nite' hayajkati'yik'ui. ");
INSERT INTO mca_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yijaa'ija aka' qu' hit'iƚij ewets: Pa'qu' na'ne'ƚi'i ha'ne week sehe' epji' qu' netfelhitii eke' ƚe'sits wi'tlijei t'ejuyets na' witiƚa'x, qa aka' ƚeqfenye'jyij ene' efu qa' netfelhitiiji'ij, qa' natjamtaxtiijiik'i iye.— ");
INSERT INTO mca_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ma' qa hik aka'aj ka' Judas Iscariote, hikka' ta'ƚtaxets he' doce (12) ƚ'ijatshenhei. Qa ikii pa'aj he' tenek'enhe'yij pe' pa'il qe qa' netisij hatse' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hekhewe'en in yepi'ye' pa'aj qa qi in ƚe'sitsi'mkii pa'aj qa yiwjutsiqeni'mha qu' netisij hatse' pe'qu' ƚ'astaye'. Ma' qa ka' Judas qa wo'oikiiha pa'aj pa'qu' iwemetsaxe'ji' qu' net'ihinij ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kakha' yojo neƚu kekhewe' ƚe'sits ƚeqe neƚutsji' ne'ej pan nite' yetsji'ƚ pe'qu' levaduraye', in hats talanhetii na'aj kots'etaxik'i t'ejuyets na'aj ƚe'wis neƚu Pascua, he' ƚ'ijatshenhei qa yit'ijets: —¿Pa'n i'ni' pa'qu' isu'un qu' haki'ƚii qa haqsiiƚijkii qu' hajileti'ƚ pa'qu' etuj ha'ne ƚe'wis neƚuji' Pascua?— ");
INSERT INTO mca_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma' qa yukin he' wetsjuk ƚ'ijatshenhei qa yit'ijets: —Ma'aƚiiteje'm na' witset. Qa hik nakha' qu' i'weni'ƚi' pa'qu' jukhewe' qu' nekaxij pe'qu' kamusiye' pa'qu' iweli'ye', qa' ijayani'ƚpha'mkii. ");
INSERT INTO mca_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Qa pakha' qu' nuyiteje'm pakha'an, qa' it'iƚijets pa' yatsat'axij pe' wititsi': “Ha' Maestro yit'ij: ‘¿Pa'n i'ni' pakha' ƚatawe'j ene' wititsi', pakha' ƚeke' qu' haqsiiƚiji'kii ene' yijatshenhei qu' heyeki'ƚji' ha'ne ƚe'wis neƚu Pascua?’” ");
INSERT INTO mca_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma' qa' nethiniƚij nakha' qu' jina'niji' epk'etsaxifi na' te'weipha'm ne' wititsi', hats week yijat'axju'. Qa' aqsi'ji'ƚijkii qu' aje'eƚ ajileti'ƚ week pe'qu' net'ejuyets ha'ne ƚe'wis neƚu qu' jinteƚuj.— ");
INSERT INTO mca_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma' qa ikkii he' ƚ'ijatshenhei qa yamii pa'aj ha' witset qa week yi'wen ka' hats yit'ijets ha' Jesús. Ma' qa yaqsi'jju' aje'eƚ week kekhewe' qu' netuj t'ejuyets ka' ƚe'wis neƚu Pascua. ");
INSERT INTO mca_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Qa in hats lef'ekii, ma' qa hats namii ha' Jesús qa he' doce (12) ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Qa in hats week i'nijupkii ha' ƚeqe mesa qa tekju', ha' Jesús qa yit'ij: —Yijaa'ija aka' hit'iƚij ewets. Na'l na' ewi'ƚ ekheweli'ƚ yekufe hane'ej, t'ihinyij hatse'.— ");
INSERT INTO mca_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma' qa hik aka'aj qa yoksi'wen in qi in ika'metetskii hekhewe'en, qa week ewiƚei in yitjiijets: —¿Me yakha'?— ");
INSERT INTO mca_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ha' Jesús qa yit'ijets iye: —Nakha'an hik nakha' ewi'ƚ ta'ƚets enewe' doce (12), nakha' ewi'ƚ na' yoqotok'o'oƚ in hilke'eƚijetsju'kii ne' pan. ");
INSERT INTO mca_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Qe ha'ne Ƚa's na' Jukhew hats ikƚi'ij qu' ƚunye'je' in ƚ'anyejeyek kekhewe' hats we'nika'ajji' t'ejuyets nakha'an, qa ¡hiyee'ƚe ha'nus nakha' jukhew t'ihinij hatse' ha'ne Ƚa's na' Jukhew! Les in ƚe'wistaxju' qu' hasu'uj nenekfik'i pa'aj hakha' jukhew.— ");
INSERT INTO mca_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","In mexe tekju', ha' Jesús qa t'eku'mi' ka' pan, qa yit'ijetspha'm ƚe'wisij pa' Dios, ma' qa napk'asiti'mju' qa tisijets hekhewe'en, qa yit'ijji'ju': —Ƚuji'ƚ, hane'en hik ha'ne yese'n.— ");
INSERT INTO mca_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Qa t'eku'mi' iye ha' ewi'ƚ tok'o qa yit'ijetspha'm iye ƚe'wisij pa' Dios, qa tisijets iye hekhewe'en, ma' qa week iya'aj iye ha' ewi'ƚ tok'o. ");
INSERT INTO mca_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Qa yit'ijji'ju' iye: —Ha'ne i'nji' ha'ne tok'o hik enewe' yathits, hik enewe' qu' nata'ƚets pakha' ink'ayik qu' nenit'ij, qa' nawantsiifik'i qe qa' net'ejuyets pe'qu' olootse'. ");
INSERT INTO mca_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yijaa'ija aka' hit'iƚij ewets, in hats nite' k'iya'ji' iye ni'khap iye uwa ƚ'i', ipƚu'ui qu' namtaxets pa' neƚuji' qu' ji'niyataxji' iye na' ink'ayik uwa ƚ'i' na' tenek'enhe'yi' na' Tata.— ");
INSERT INTO mca_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","In yili'ijju' in te'lijtsii yiji'ik'i ka' ewi'ƚ witlijtsine', ma' qa ikfik'ikii qu' nakiiteje'm ke' utek Olivos. ");
INSERT INTO mca_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ha' Jesús qa yit'ijji'ju' iye: —Week hatse' ekheweli'ƚ qu' anak'esi'ƚ yik'uikii, qe kekhewe' we'nika'ajji' yit'ij: “Hilan hatse' na' kots'etets ƚenilayets qa ne' kots'etets qa' nak'eskii.” ");
INSERT INTO mca_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Qa qu' yi'ƚa'xe'tax iye qa' hathayini'ƚ ek'uyii ha' Galilea.— ");
INSERT INTO mca_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma' qa ha' Pedro qa yit'ijets: —Yemjeetax qu' week ne'nitontax e'mets hatse' qa yakha'ƚe qa' nite' ƚ'anuuyi'i qu' haqsiijkii kakha'an.— ");
INSERT INTO mca_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Qa ha' Jesús qa yit'ijiju'ƚ: —Yijaa'ija aka' qu' hit'ij ewets in akha' hane'ej ha'ne naja'xji', in mente' wetsjuk'ij qu' nap pa'qu' ta'a'aye' qa' hats wetshetk'ewi'ƚij qu' mewelku'tyijkii.— ");
INSERT INTO mca_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Qa ha' Pedro qa hamƚe yami'ik'ui in yit'ijetskii: —Ƚunye'j ji'ij qu' k'eyiwamhifeye', nite' hewelku't ejkii.— Qa week in ƚ'anyejeitax aka'an hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ma' qa yamets ha' najkaket ƚii Getsemaní. Qa ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —Hik ha'ne ni'ekuni'ƚi'ju'kii qa yakha'ƚe qa' mexe nek'iyin.— ");
INSERT INTO mca_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Qa t'eqe'mets ha' Pedro qa ha' Jacobo (Santiago) qa ha' Juan iye. Ha' Jesús qa hik aka'aj qa yoksi'wen in qi in ika'metkii qa itawje'met iye. ");
INSERT INTO mca_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Qa yit'ijets hekhewe'en: —Qi in k'ikametkii, qa hats naq'aliyuyij, hik ha'ne a'maneyi'iƚi', mama'kite' e'ƚju'— ");
INSERT INTO mca_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma' qa les ha'nii ha' ikji', qa we'niyipiniju' sehe', qa iyinijii pa' Dios qu' ƚeke'ye' qu' hasu'uj namitets pakha' ƚunye'jkii hatse' qi a'tax. ");
INSERT INTO mca_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qa yit'ij in iyin: —¡Abba, Tata! Akha' ham pa'qu' iwjutsiten eke' week wekwek, anamitkitek yiwets wat'ij qu' nek'iya'aj nakha' tok'o i'nji' na' qi in ek'imiiji', qa hasu'ujƚe pa'qu' yakha' ye'ƚe qu' hisu'un, akha' yijat'ij pa'qu' isu'un.— ");
INSERT INTO mca_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma' qa tepilii iye he' ƚ'ijatshenhei qa yi'wenij in ima'ju', qa yit'ijets ha' Pedro: —Simón, ¿me ƚama'? ¿Me nite' eke' qu'nte' ama'ye' qu' ewi'ƚ horaye'? ");
INSERT INTO mca_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hasu'uj mama' a'ƚju', iyini'ƚ hats'inha qa'nte' nanami'iƚ ewets na' witaqjaajinkeye'j. Ekheweli'ƚ hats qi in ƚisu'untaxi'ƚha qu' aqsiiƚijkii kakha'an, qa nite'ƚe t'units ne' esenitsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Qa ik iye qa iyin iye, qa yiyeketij iye kekhewe' hats yit'ij. ");
INSERT INTO mca_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Qa tepiltaxii iye qa yi'wen iye in ima'ju' iye, qe nite' weju'ƚiju'ƚ in qi in nijatiyu'ju'ha. Qa' nite' nikfe'lets hekhewe'en pa'qu' nit'ijiju'ƚ qu' neku'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Qa tepiltaxii iye qa hats wetshetk'ewi'ƚij in tepilii ma' qa yit'ijji'ju': —¿Me menjiit ƚama'aƚju', qa ƚawapiyi'ƚju' iye? Hats ƚ'ajƚu'uj je'm in ƚama'aƚju'. Hats yamets nekhe' hora, qa ha'ne Ƚa's na' Jukhew netesti'yij nekhewe' uƚ'ets jukhew. ");
INSERT INTO mca_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eniyi'ƚpha'mkii, yape ju'ukkii, hats na'liju'ƚ na' wotk'onyijkii.— ");
INSERT INTO mca_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Hik aka'aj ha' Jesús mexe iyettax, qa namets ka' Judas, hik kakha' ewi'ƚtax iye hekhewe' doce (12) ƚ'ijatshenhei, qa olots he' ƚijts'eyek neka'x he' ƚaqatsjikinetits qa he' najak ƚeqek'unetits, nukin he' tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei qa hekhewe' iye tenek'enheiji' na' witset. ");
INSERT INTO mca_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Qa kakha' t'ihinij qa hayiits nifeli'm pa'aj kakha' qu' niwjutsiqenij, qa yit'ij pa'aj: —Hakha' qu' hetu'je'm qa' hik hakha'ye'. Qa' ku'mi'ƚi' qa' matjanitheni'ƚij qu' eka'xi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ma' qa in namets qa aje'eƚ nekets ha' Jesús, qa yit'ijets: —¡Maestro!— Qa tu'je'm. ");
INSERT INTO mca_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma' qa hekhewe'en qa nekets ha' Jesús qa t'eku'mi' qa niyejinju'ha. ");
INSERT INTO mca_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Qa ha' ewi'ƚ hekhewe' metitsi'm qa nit'ijpha'm ha' ƚaqa'tsjikinet qa yifekin je'm hakha' ƚeqejkunenek ha' qiji' pa'il ƚatata qa yasinijii ke' ƚekfi'ik'i qa k'itsji'. ");
INSERT INTO mca_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Qa ha' Jesús qa yit'ijets hekhewe'en: —¿Inhats'ek in ƚenka'xi'ƚ ne' aqa'tsjikinetitsi'ƚ qa ne' najak eqek'unetitsi'ƚ qu' ots'opheƚi'ƚ? ¿Me hik yijunye'j na'aj ejtenhetsax? ");
INSERT INTO mca_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Week neƚuts ewi'ƚ ju'uni' ne' qi witlijtsitjiyifi qa k'inq'ijatshenji'ij, qa nite' ƚots'opheƚiƚ. Qa hatsƚe ƚunye'jƚe aka'an qe qa' nafits kekhewe' hats we'nika'ajji'.— ");
INSERT INTO mca_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma' qa he' ƚ'ijatshenhei qa yiwejinƚi'i qa week ilatkii. ");
INSERT INTO mca_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Qa ewi'ƚ ha' jutjana'x yijayanpha'mkii, ewi'ƚƚi'i' ha' wentila'fij qa t'eku'mtaxi' iye qu' neka'x ");
INSERT INTO mca_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma' qa yiwu'mƚi'i ha' ƚe'ntilafit qa ilat laxaxƚekii in ilat. ");
INSERT INTO mca_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma' qa wetka'xii ha' Jesús ha' qiji' pa'il ƚatata, ma' qa not'ax wetju'ƚ he' week hekhewe' tenek'enhe'yij pe' pa'il qa he' tenek'enheiji' ha' witset qa hekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ha' Pedro yijayantaxpha'mkii qa toxƚi'imii yamƚi'iiji'ha hakha' joofji'ju' ke' ƚetsi' ha' pa'il ƚatata, ma' qa i'nijupju' he' oq'opheƚinetsilets t'aƚijup ka' fe't. ");
INSERT INTO mca_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","He' tenek'enhe'yij he' pa'il qa weekji' hekhewe' tenek'enhei (Junta Suprema) qa wo'taxiikii pekhewe' qu' wi'tlijeye' qu' net'ejuyiju'ƚ ha' Jesús hats'inha qu' nilan, qa nite'ƚe yi'wen. ");
INSERT INTO mca_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yemjeetax in olotstax hekhewe' wotk'ontaxijkii, qa nite'ƚe ƚ'anyejeyij wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Qa uja'x he' niyijpha'mkii iye qa yittaxij iye kekhewe' wotk'onƚi'ijkii iye in t'ejuyiju'ƚ ha' Jesús, qa yit'ijju' hekhewe'en: ");
INSERT INTO mca_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Yekheweli'ƚ hepi'ye'eƚij in yit'ijets nakha'an: “Yakha' hiwu'm hatse' ene' qi witlijtsitjii ƚaqsijki'ijkii ene' jukhew, qa qu' namets wetshetk'ewi'ƚ neƚuts qa' heniihinpha'm pekhepe' iye nite' ƚaqsijki'ijkii ene' jukhew.”— ");
INSERT INTO mca_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nite'ƚe week ƚ'anyejeyij aka' yittaxijju'. Nite' yeqet'etskii. ");
INSERT INTO mca_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma' qa ha' qiji' pa'il ƚatata qa niipha'm qa ts'ap'aji'ju' ƚeqewuk'u, qa nifaakan ha' Jesús: —¿Me ham pa'qu' eku'ƚik'i? ¿Pa'n ƚunye'jkii aka' yit'ij ewets enewe'en?— ");
INSERT INTO mca_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Qa hakha'ƚe Jesús qa ham yit'i'ij, ham pa'qu' nekuƚik'i. Qa ha' pa'il ƚatata qa wapilijets iye in nifaakan, qa yit'ijets iye: —¿Me hik akha' pa' Cristo, pakha' Ƚa's pa' ƚe'wis Dios?— ");
INSERT INTO mca_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús qa yit'ij: —Ehe yakha', qa ƚi'weni'ƚ hatse' ha'ne Ƚa's na' Jukhew qu' na'ni'ju' na' yiya'yik'i nakha' qi in t'un qa' nenekijju' ne' wasil.— ");
INSERT INTO mca_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma' qa ha' pa'il ƚatata qa yiwjaf'itik'i ka' ƚ'uihitjiiƚe, qa yit'ij: —¿Inhats'ek qu' menjiit hami'ik'ui iye pakhape' iye qu' nenfelijkii pa'qu' ƚunye'je' hane'en? ");
INSERT INTO mca_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hats ƚepi'ye'eƚ in uƚ'etsik'i ƚe'lijeyets pa' Dios. ¿Pa'n ƚumti'iƚ?— Ma' qa week yisu'un qu' nattanithenhetii, qa yit'ijju' in ewi'ƚƚe in weju'ƚij qu' nawa'm. ");
INSERT INTO mca_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma' qa yapeƚek pe' uja'x qa tek'iyi'kii pa'aj, qa yit'onjo' iye pa'aj ƚeju's qa yi'wiƚtenje'mkii iye pa'aj, qa yitjiijets iye: —Enfeli'ƚ ye'm ¿ƚek pakhate'ek nalan?— Qa he' oq'opheƚinetsilets testi'yij qa yeqsilanje'm kiyek ƚeju's pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ha' Pedro i'niju' ha' joofji'ju' ke' wititsi'. Ma' qa namets ke' ewi'ƚ hekhewe' ƚeqejkunenkii ha' qiji' pa'il ƚatata. ");
INSERT INTO mca_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Qa in yi'wen ha' Pedro in t'aƚets ka' fe't, qa ts'in in yejeƚju', qa yit'ijets: —Qete'e' hik akha' iye hekhewe' ƚijts'eyekkii ha' Jesús, Nazaret ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Qa ha' Pedro qa welkutƚi'ijkii, qa yit'ij: —Nite' tsikfe'lij, qa nite' tsikfe'lets iye kakha' ƚit'ij yiwets.— Qa ikik'ui ka' fe't qa ts'ap'a'a' ha' ƚekuwe'e' meti'm ha' epk'etsaxii ƚeji', ma' qa ip pa' ta'a'a'. ");
INSERT INTO mca_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Qa ke' witqejkunenki' in yi'wen iye, ma' qa hats yit'ijets hekhewe' i'ni' hakha'a': —Hik ha'ne hakha' ewi'ƚ hekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Qa welkutƚi'ijkii iye hakha'an. Qa suujƚe iye hekhewe' i'ni' hakha'a' qa wapilijets iye in yit'ijets ha' Pedro: —Qete'e' yijaa'ija in akha' ƚata'ƚets hekhewe'en, qe akha' iye Galilea ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma' qa hik aka'aj ha' Pedro qa yapeƚek in uƚ'axik'i ƚ'anye'j qa weniwjutsiqentaxijha iye in yit'ij: —Nite' tsikfe'lij pakha' jukhew ƚiyineni'ƚkii.— ");
INSERT INTO mca_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Qa hik pakha'aj qa ip iye pa' ta'a'a', ma' qa hats wetsjuk'ij in ip. Ma' qa ha' Pedro qa yijamti'ik'i kakha' ƚ'anye'jets ha' Jesús in yit'ijets: —Qu' hats wetsjuk'i'ij qu' nap pa'qu' ta'a'aye' qa akha' qa' hats wetshetk'ewi'ƚij qu' mewelku'tyijkii.— In yijamti'ik'i aka'an, ma' qa qi in ip. ");
INSERT INTO mca_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Qa mexe leefƚi'iju' iye hekhewe' tenek'enhe'yij he' pa'il qa aje'eƚ yaqsi'jju' iye qu' nonot'axi'ƚ wetju'ƚ iye hekhewe' tenek'enheiji' na' witset qa hekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei, qa week in uja'xju' ek in tenek'enhei (Junta Suprema.) Ma' qa in hats ƚe'sitsijju' iye pa'qu' nit'ijju', qa yophe'ƚ ha' Jesús qa yeka'xii qa tisij ha' Pilato. ");
INSERT INTO mca_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ha' Pilato qa nifaakan ha' Jesús: —¿Me akha' pakha' ƚatata ne' judiol?— Ha' Jesús qa yeku'ƚ: —Ehe, ƚ'asiinik'iha ka' ƚit'ij.— ");
INSERT INTO mca_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qa he' tenek'enhe'yij he' pa'il qa yit'ijetskii kekhewe' olots wekwek uƚ'etsik'i yit'ijets in yaqsiijkii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma' qa ha' Pilato qa ewi'ƚij iye in nifaakan ha' Jesús, qa yit'ijets: —¿Me nite' ƚ'inku'ƚ? Jeƚ qeku'nek, eke' olots wekwek uƚ'etsik'i titijiti'yijets in ƚaqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Qa hakha'ƚe Jesús qa hats nite' inku'ƚ iye, qa hik ta'ƚijupi' pa' Pilato in yitjuƚaxijpha'm. ");
INSERT INTO mca_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ma' qa ha' Pilato in weekji'ij ininqapits ƚeqfenye'jji'ij ƚewek qa ƚe'wisji'ij neƚu Pascua qa yiwejinji'ij na'aj wit'opheƚik pa'qu' niyinji'jets pekhewe'en qu' netwejinhetii. ");
INSERT INTO mca_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ewi'ƚ pa' wit'opheƚik ƚii Barrabás, ewi'ƚ i'ni'ƚi' pekhewep iye ƚe'fetsijup pa'aj in t'ilittax, ma' qa teqek'uiju' pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Qa namii pa'aj pe' olotsjo' jukhew. Ma' qa yapeƚek qa iyinijets pa'aj ha' Pilato qu' ƚeqfenyeje' ƚewek pa' hayiits ƚeqfenye'jji'ij ƚewek. ");
INSERT INTO mca_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma' qa ha' Pilato qa yeku'ƚ pa'aj: —¿Me ƚisu'uni'ƚ qu' hiwejin ha'ne Ƚatata ene' judío?— ");
INSERT INTO mca_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Qe ha' Pilato nikfe'lets hekhewe' tenek'enhe'yij he' pa'il in tisij ha' Jesús qe teqhemtshenetskii. ");
INSERT INTO mca_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma' qa hekhewe' tenek'enhe'yij he' pa'il qa yiyaji'etskii pa'aj pekhewe' olots jukhew qu' niyinijets yijat'ij qu' netwejinhetii pa' Barrabás qa' hasu'uje' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma' qa ha' Pilato qa nifaakanji'ju' iye pa'aj: —¿Pa'n ƚii pa'qu' isu'uni'ƚ qu' yeqfenye'ji'ij ha'ne eqiyi'ƚij, judiol Ƚatata?— ");
INSERT INTO mca_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Qa pekhewe'en qa yeku'ƚ pa'aj, taya'yijipji'kii pa'aj in yit'ijju': —¡Eni'ƚji'pha'm cruze'!— ");
INSERT INTO mca_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ha' Pilato qa yittaxijets iye pa'aj: —¿Inhats'ek? ¿Pa'n ƚii pa' uƚ'ax yaqsiijkii?— Qa yape'enha les in taya'yijipji'kii in yit'ijju': —¡Eni'ƚji'pha'm cruze'!— ");
INSERT INTO mca_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Qa ha' Pilato in yisu'un pakha' qu' ni'wejuƚenij pekhewe' olots jukhew, ma' qa yiwejin pa'aj pa' Barrabás. Ma' qa in yaqhat'etsij in inaqyaji'ij in teqsilanhetiikii ha' Jesús, qa tisij he' oq'opheƚinetsilets, hats'inha qu' nenji'pha'm ke' cruz. ");
INSERT INTO mca_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ma' qa pe' oq'opheƚinetsilets qa yeka'xifi pa'aj ke' palacio, qa yenifi pe' ƚenextsi'ij pekhewe' yejeƚ ke' palacio (pretorio). Ma' qa taya'yii pe' week pekhewe' i'nifi pekhe'en oq'opheƚinetsilets qa not'axij wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Qa yi'ntaafinij pa'aj pa' penyilo witpalinek, qa in hats yaqhat'etsij iye in yiftii pe' tii qu' ƚ'iwat'i'ij, qa yuihinji'ju' iye. ");
INSERT INTO mca_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma' qa yawitji'etskii qa yit'ijiijetskii: —E'ƚe'wisi'imkii, qi ƚatata ene' judiol.— ");
INSERT INTO mca_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Qa yilanijkii pa'aj ƚeiƚa' pa' ewi'ƚ tutsi'latax, qa tek'iyi'kii iye pa'aj qa wonokok'enjiijupju'kii qa totjoiji'ijju'kii yitjiij qhup qhup ƚeiƚal. ");
INSERT INTO mca_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","In yili'ij pa'aj in yawitji qa nit'ijji' pa' yintilafinij witpalinek qa yuihinik'ipha'm iye pe' ƚeqhinataayija, ma' qa yeka'xfik'i pa'aj qe qa' nenji'pha'm ke' cruz. ");
INSERT INTO mca_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Qa ewi'ƚ ha' jukhew ta'ƚiifik'i pa'aj ha' ƚ'ejinqa'wet, ƚii Simón, Cirene ƚeiƚe', ƚatata ha' Alejandro qa ha' Rufo, qa tayajaxti'yijets pa'aj qu' neka'xi'm ke' ƚeqe cruz ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma' qa yeka'xii pa'aj ha' ewi'ƚ tseenepha'm ƚenqii Gólgota, ikji' witjiƚa'ak'i ƚetset. ");
INSERT INTO mca_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Qa testiitaxij ka' wino wenetsjiƚkinij na'aj mirra, qa nite'ƚe iya'ji' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma' qa in hats yenji'pha'm ke' cruz, qa he' oq'opheƚinetsilets qa watk'esaxijju' ke' ƚeqhinatai, qa ikij wetju'ƚ pa'n ƚunye'j pa'qu' neka'x week ewiƚei. ");
INSERT INTO mca_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Qa juufik'ipha'm junu' (las nueve) in yenji'pha'm ke' ƚeqe cruz. ");
INSERT INTO mca_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Qa yeni' ka' ƚe'nikahat nifel ka' ta'ƚijupi' in talanhetii, yit'ij: —Ƚatata ene' judío.— ");
INSERT INTO mca_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ha' Jesús ƚe'nenhifetsji'pha'm iye ke' cruzits ke' wetsjuk ejtenhetsits, ewi'ƚ ka' te'weyij yiya'yik'i qa kakhap qa ƚefeyi'j te'weyijek. ");
INSERT INTO mca_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Ma' qa hats yafits kekhewe' we'nika'ajji' in yit'ij: —Tojonkaxti'yik'i pekhewe' uƚ'ets jukhew.—) ");
INSERT INTO mca_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","He nekjiijup qa yawitjijeetspha'mkii, qa yitjiij qhet tetet ƚeiƚal, ma' qa yiyajije'etspha'm: —¡Haa, haa! Akha' in ƚit'ijets qu' onopƚetju' ne' qi witlijtsitjii qa' wetshetk'ewi'ƚ neƚutse' qu' eniihinpha'm iye, ");
INSERT INTO mca_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡meteƚinƚe qa' ilit'ik'uiju' ne' cruz in ƚ'enhetiijipha'm!— ");
INSERT INTO mca_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Qa hik ƚunyejei iye hekhewe' tenek'enhe'yij he' pa'il qa he' i'nq'ijatshenij ke' Moisés ƚe'lijei in yawitji'etspha'mkii iye qa watfaakateji'ijju' qa yit'ijju': —Yiƚinji'ij pekhewep qa ƚakha'ƚe qa nite' ƚeke' qu' neteƚinƚe. ");
INSERT INTO mca_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Qu' hik nakha'ye' pa' Cristo'ija, pakha' Ƚatata ene' judiol, qa' net'ilit'ik'uiju' hane'ej ne' cruz, hats'inha qu' jinte'wenij ma' qa' nite' jinteqekuye' yijat'ij.— Qa kekhewe' iye ƚenenhefetspha'm ke' cruzits uƚ'etsik'ikii iye ke' ƚe'lijeyets. ");
INSERT INTO mca_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","In hats natsathenju' junu' ma' qa week ha' sehe' in nookii qa yamijii las tres metiyu'ju' junu'. ");
INSERT INTO mca_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Qa hik aka'aj ha' Jesús qa t'unik'i in tayai, qa yit'ij: —Eloi, eloi ¿lama sabactani?— Ikji' aka'an: —Dios yatsat'axyij, Dios yatsat'axyij, ¿inhats'ek in ƚetswu'm?— ");
INSERT INTO mca_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na'l he' uja'x metitsi'm yepi'ye' in iyet, qa yit'ijju': —Ek'en qeku'ni'ƚets, hats taya'yiikii pa' Elias'ik'i.— ");
INSERT INTO mca_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma' qa ewi'ƚ ha' wekuma'xii qa yuihinji'ju' ke' ewi'ƚ jupayek (esponja) ka' wino na'aj ewtsik'iiji', qa yenji' ka' ewi'ƚ najak tutsi'latax qa yetshenetspha'm qe qa' netufij, ma' qa yit'ij: —Jitewejinƚe eku'n, jitejeƚ eku'nijju' q'ax qu' nentenilit'etsju' pa' Elias'ik'i qu' nilithinju' nakha'an.— ");
INSERT INTO mca_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ha' Jesús qa t'unik'i in tayai, ma' qa wa'm. ");
INSERT INTO mca_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Qa ka' penyilo ƚenjilafi' ke' witlijtsitjii qa' ja'fik'iju' ƚeqewuk'u pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Qa ha' ewi'ƚ centurión ts'ap'a'afi ka' Jesús, hakha'an in yi'wenij in tayai qa wa'm, ma' qa yit'ij: —Qete'e' yijaa'ija aka' jukhew in Ƚa'staxija pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na'l iye he' efuts neeƚiikii totsii ha' i'ni' i'nji'teje'm kikhe' María Magdalena qa ke' Salomé qa ke' María ƚenene ha' omehe' Jacobo (Santiago) qa ha' José. ");
INSERT INTO mca_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Enewe' efuts yijayanik'ikii qa t'ifti'ts'etskii ha' Jesús in mexe neki'kii ha' Galilea, qa olots iye hekhewep iye yijayanik'i in hats yamii ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Qa hats metju' junu', ka' neƚuji' in mexe watji'letji' pe'qu' wekweke', ehe, qa hats k'esik'iha qu' witwapiihijiye'. ");
INSERT INTO mca_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ma' qa nam ha' José Arimatea ƚeiƚe', hikha' iye i'nji'teje'm hekhewe' Junta Suprema, hikha' ewi'ƚ hekhewe' les te'nekumhi'yi' na'aj yit'ij, ƚakha' iye notkiji'ijtaxik'uyek pa' tenek'enheiji' pa' Dios, ma' qa we'nt'unhet in uyetsji' pa'aj pa' i'ni' pa' Pilato qu' niyinijets pa' Jesus'ik'i. ");
INSERT INTO mca_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ha' Pilato ts'iƚimkii pa'aj in aje'eƚ wa'm pa'aj, ma' qa taya'yii pa'aj hakha' centurión, qa nifaakanij qu' yijaayi'ija qu' hats nawa'm. ");
INSERT INTO mca_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma' qa jutsiqaxi'mha qe ta'ƚets ha' centurión, ha' Pilato qa tisij pa'aj ha' José ka' Jesus'ik'i qu' neka'x. ");
INSERT INTO mca_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma' qa taqha'yets pa'aj ha' José pa' ewi'ƚ penyilo fo' qa inyetax iye, qa nit'ijju' pa'aj ka' Jesus'ik'i. Ma' qa yijuphe'ƚji' pa'aj pa' penyilo qa yeka'x qa yenifi ke' inqajkaninijju' pa'aj ke' utekji'teje'm ƚenimeƚuk qa yiwkoyoyinets ke' qi ute pa' ƚeji' qa yit'onji'. ");
INSERT INTO mca_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ke' María Magdalena qa kikhep iye María ƚenene ha' José, yejeƚijik'ikii qe qa' nenikfe'lets pa'n qu' neni'. ");
INSERT INTO mca_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","In hats naxijik'i ka' witwapiihijii (sábado), qa ke' María Magdalena qa ke' Salomé qa ke' María iye ƚenene ha' Jacobo (Santiago), qa taqha'yets pa'aj ne'ej ewjisiiji' (especias) qe qa' nakii qu' newjisitipji' ka' Jesus'ik'i. ");
INSERT INTO mca_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Qa leefiju' pa'aj kakha' yojo neƚuji' ka' semana (domingo), qa hats yamets pa'aj ke' nimeƚuk in hats nekiyupha'm pa'aj junu'. ");
INSERT INTO mca_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","He' efuts qa yit'ijju' pa'aj: —¿Qa pa'n ƚii pa'qu' nikoyoyinhet ke' qi ute qu' nit'ij i'nemii qhof ha' ƚeji' ke' nimeƚuk?— ");
INSERT INTO mca_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma' qa yejeƚtax pa'aj, qa yi'wen in hayiits qhofij pa'aj ke' nimeƚuk, yemjeetax in qitax ke' ute ƚit'o'oj. ");
INSERT INTO mca_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","In uyifi pa'aj ke' ƚenimeƚuk, qa yi'wen pa'aj pa' ewi'ƚ jutjana'x i'niju' pa' yiya'yik'i pa' te'weiji' pa'aj. Pe' ƚeqhinatai yamik'iju' qa fo' iye, ma' qa he' efuts qa qi in nijiwei pa'aj. ");
INSERT INTO mca_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Qa pakha'an qa yit'ijets pa'aj: —Hasu'uj e'nijiwe'yi'ƚ, tsikfe'lets in ƚowotaxiƚiikii ha' Jesús Nazaret ƚeiƚe', hikha' t'enhetiijipha'm ke' cruz. Hats iƚa'x iye, ham hane'e'in. Jeƚ qeku'ni'ƚek ha'ne we'nentaxi'. ");
INSERT INTO mca_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yape ma'aƚkii qa aka' qu' it'iƚijets he' ƚ'ijatshenhei qa hakha' iye Pedro: “Ha' Jesús wathayinti'iƚ ek'uyii ha' Galilea, hikna' tit i'weni'ƚi' hatse' in ƚunye'jek ka' hayiits yit'iƚij ewets.”— ");
INSERT INTO mca_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hekhewe'en qa ikfik'ikii pa'aj, ilatik'uifik'ikii ke' nimeƚuk, qe qi in tsalal wetju'ƚ, nijiwei pa'aj. Qa ham pa'qu' nithinets, qe nijiwei. ");
INSERT INTO mca_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","In hats iƚa'x iye ha' Jesús, ka' yojo neƚuji' ka' semana (domingo) mexe leefiju' pa'aj. Qa ke' María Magdalena qa hik kikhe' yojo'oj pa'aj in yi'wen, hik kikhe' yukinik'uifik'i pa'aj pe' wetsjuk tatsai (7) inwo'metets i'ntaxji'. ");
INSERT INTO mca_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma' qa kikhe'en qa ikii pa'aj qu' nenfeli'm hekhewe' ƚijts'eyekji'ijtaxkii hakha'an. Hekhewe'en qi in ika'metetstaxkii qa qi in ipju' iye. ");
INSERT INTO mca_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hekhewe'en in impi'yelij hakha'an in hats iƚa'x iye qa kikhe'en iye in yi'wenija, qa hekhewe'en qa nite'ƚe yisu'un qu' netk'enik'i. ");
INSERT INTO mca_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Qa i'nk'aƚe iye pa'aj, ha' Jesús qa we'nethinets iye tujtseika'ƚe pa' ƚunye'j in we'nethinets he' wetsjuk hekhewe' ƚ'ijatshenhei in nekik'iju' pa' wit'ikheyi'j qu' namii pa' ƚ'ejinqa'wet. ");
INSERT INTO mca_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Qa tepilii iye ha' Jerusalén qa nifeltaxii iye aje'eƚ hekhewep, qa yeqekuƚi'ij iye. ");
INSERT INTO mca_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma' qa i'nk'aƚe qa we'nethinetsha hekhewe' once (11) ƚ'ijatshenhei hekhewe'en in mexe i'nijupju'kii week ha' ewi'ƚ mesa in tekju', ma' qa yaq'ayinij pakha' ƚeqekuyejei qa in t'units iye pe' ƚatawjets, qe yeqeku'uj hekhewe' yojo'oj in yi'wen in hats iƚa'x iye. ");
INSERT INTO mca_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Qa yit'ijji'ju': —Yape, ma'aƚik'i ha'ne week sehe' ipji' qa' enfeli'ƚi'm eke' ƚe'sits wi'tlijei week pa'qu' ƚunye'je'ƚe. ");
INSERT INTO mca_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pa'qu' hats netk'eenik'iha qa' nempuli'jij ma' qa' iƚa'xe'. Qa pakha'ƚe qu' neqeku'uk'i ma' qa hats jutsiqaxe' qu' nattanithenhetii hatse'. ");
INSERT INTO mca_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ekewe'en kekhewe' ham ƚunyejeyi'iju'ƚ qu' ƚijts'eyek'ekii pekhewe' qu' hats nite' neqekuyi'ik'i: Aka' yii qu' nit'iji' qu' nukinfik'ikii pe' inwo'metets, qa' nit'ij iye pe'qu' i'nk'aihitse' ƚe'lijeye'. ");
INSERT INTO mca_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Q'oiq'oyits qu' net'eku'mi', qa qu' niyataxji' pe'ye' na'aj yaq'alij pa'qu' jukhewe', qa' nite'ƚe neqenijani'ij, ham ƚunyeji'ijkii. Qa qu' net'eku'mjiipji' pe'qu' nanqaats'eju' ma' qa' ƚe'sitse'ji'ijju'.— ");
INSERT INTO mca_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ma' qa ha' Yatsat'ax'inij Jesús in yili'ij in iyetik'ui hekhewe'en, ma' qa tenilesiyiju'ƚ na' wa'sji', qa i'niju' pa' yiya'yik'i pa' Dios. ");
INSERT INTO mca_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma' qa hekhewe'en qa ikij qu' nenfel eke' ƚe'sits wi'tlijei week ha'ne sehe' ipji'. Ha' Yatsat'ax'inij qa qi in yi'fen, qa qu' niwjutsiqenija kekhewe' ƚe'sits wi'tlijei in yijaalija qa ta'ƚets kekhewe' ham ƚunyejeyi'iju'ƚ in ƚijts'eyekkii.");
INSERT INTO mca_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Olots hekhewe' t'eku'mi' qu' nika'aji' kakha' ƚunye'jkii pe' wekwek te'wenhetii ha'ne hane'ej jinamji'ju', ");
INSERT INTO mca_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","qa jinikfe'lets ekewe'en qe ta'ƚets in nifel ine'm hekhewe' ta'ƚijii in i'nk'aa'ija pa'aj in yi'wenijha qa hik hekhewe' iye nifel eke' wi'tlijei. ");
INSERT INTO mca_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yakha' Lucas, yakhap iye in qi in week hejeeƚtaxik'uiha in ipƚu'uk'i ek in i'nk'a, qa humti qu' les ƚe'wise' qu' hata'ƚijii qa' heyeiƚi'ijpha'm qa' natsamijii ka' ƚ'aka'the' qu' hika' e'm tenek'enhei Teófilo. ");
INSERT INTO mca_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hats'inha qu' enikfee'letsha in yijaalija kekhewe' wekwek ƚ'ijatshenheti'yij. ");
INSERT INTO mca_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Qa ƚunye'jkii kekhewe' neƚutsji' in mexe wittata'a' ka' Herodes ha' sehe' Judea, hikha' i'ni' pa' ewi'ƚ pa'i ƚii Zacarías. I'nji'teje'm pe' pa'il ƚiyinyejeyek Abías, ƚ'ithayifetskiyek. Pe' ƚewhe'ye' ƚii Elisabet ta'ƚets pekhewe' ƚawa'mhitsik'i pe' ta'ƚets pa' Aaron'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pa' Zacarías qa pe' ƚewhe'ye' Elisabet enewe'en wattsathenketik'uiha pa' Dios, qa yijayanija iye week kekhewe' yit'ij pa'qu' nanaqsiijkii. Ham pa'qu' nit'ijets qu' nijanik'i in yijayaanija. ");
INSERT INTO mca_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Qa hamƚe ƚelitse' qe ints'ateki' pe' Elisabet qa hats ƚawa'mhits iye. ");
INSERT INTO mca_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ewi'ƚ pa' neƚuji' pa'aj pekhewe' pa'il i'nji'teje'm pa' Zacarías, qa yasinji' pa'aj qu' net'ithayii pekhe' qi witlijtsitjii. ");
INSERT INTO mca_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pa' hats ƚeqfenyejeiji'jij pe' pa'il, qa yasinji' pa'aj pa' Zacarías qu' nuyetsji' pakha' foƚetsji' pe' witlijtsitjii pa' ƚe'wis wititset t'ejuyets pa' Yatsat'ax'inij, qe qa' nene'ƚju' pa' ewjisii (incienso). ");
INSERT INTO mca_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","In mexe ne'ƚju' pa'aj pa' yejutshenets ewjisii (incienso), qa pe' i'nfik'i olots qa iyinek pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Qa hik pa'aj qa we'nethinets pa' ewi'ƚ ƚaqa ángel pa' Yatsat'ax'inij, ts'ap'a pa'aj, te'weyij pa' yiya'yik'i pa' ts'eewe'epji' (altar) t'ejuyets in tene'ƚju' pa' ewjisii (incienso). ");
INSERT INTO mca_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pa' Zacarías in yi'wen pa'aj pa' ángel qi in yitjuƚaxijpha'm qa qi iye in nijiwei pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Qa pa' ángel qa yit'ijets pa'aj: —Zacarías, hasu'uj e'nijiwei. Na' Dios hats t'eku'mij eju'ƚ ka' iyinheye'j qa ke' ewhe'ye' Elisabet qa' nana'l pa' ƚa's qa' eqiyi'ij hatse' Juan. ");
INSERT INTO mca_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Akha' qi qu' ne'sinheti'mkii qa olots iye pe'qu' qi qu' ƚe'sitsi'imkii qu' nenektaxfik'i. ");
INSERT INTO mca_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Qe pakha'an qi qu' qiyi'imji' hatse' na' Dios. Nite' iya'ji' hatse' pa'qu' winoye' qa niyatsik'e iye, qa aje'eƚ qu' notpo'oj pa' Espíritu Santo qu' mente' neneketaxfik'i. ");
INSERT INTO mca_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ƚakha' yepiletets hatse' pe'qu' olotse' enewe' ƚelits ka' Israel na' Yatsat'ax'inij hikna' ƚeqe Dios. ");
INSERT INTO mca_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Qa hik pakha' iye nojo'ok'oi hatse' nakha' Yatsat'ax'inij. Pakha'an hik ƚunye'j qa hik ƚet'unhenye'j iye hatse' ka' profeta'ik'i Elías, qe qa' naqsiijkii pe' ƚatawjets pe' ƚ'alhei qu' nenpiletetsju' pe' ƚelits, qa nekhewe' nite' nek'enheyutax qa' hik ƚunyejeye' ka' ƚunyejei ne' yatsathen, hats'inha qu' nanamtax na' Yatsat'ax'inij qa' hatsƚe nawatjilet'ik'ui.— ");
INSERT INTO mca_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma' qa pa' Zacarías qa yit'ijets pa'aj pa' ángel: —¿Pa'n ƚunye'j pa'qu' ƚeke'ye' qu' humtii'ija aka'an? Qe yakha' hats yaƚawa'ma'x qa ke' yiwhe'ye' iye hats ƚawamhi'.— ");
INSERT INTO mca_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Qa yeku'ƚ pa'aj pa' ángel: —Yakha' Gabriel. Yakha' ye'meti'mkii nakha' Dios, hik nakha' ts'ukin ewetsju' qu' jintafaakateiju' qu' henfel e'm ekewe' ƚe'sits ink'aihits. ");
INSERT INTO mca_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Qa hane'ej in nite' ƚumti qu' yijaayi'ija ke' k'efe'ltaxi'm. Ma' qa' ham e'lijeye' hane'ej yamijii qu' nana'ltax aka' hats hi'ttaxij ewets qe yijaa'ija hatse' qu' nana'l aka'an.— ");
INSERT INTO mca_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Qa pe' i'nfik'i olots qa hats nitatsittaxets pa'aj qu' nentenuifik'i pa' Zacarías, qa yiwjutsiten inhats'ek in yape'efi pa' foƚetsji' pe' witlijtsitjii pa' ƚe'wis wititset. ");
INSERT INTO mca_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma' qa in hats t'atsji'ƚtaxfik'i pa'aj, qa hatsƚe ham ƚe'lijeye', qa aje'eƚ tumtaxtii qu' ni'weni' pe'ye' pakha' foƚetsji' pe' witlijtsitjiiyifi. Qa ƚokoyeiƚetax pe' jutsiqetsij in iyettax, qa hats amanƚi'ij pa'aj in ham ƚe'lijeye'. ");
INSERT INTO mca_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma' qa in yamik'ui pa' uja'x pe' neƚuts in t'ithayi'yifi pe' witlijtsitjii, qa wapilii pa'aj pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","In hats teƚuyik'i pa'aj ekewe' neƚutsji' in t'ithayii, pe' ƚewhe'ye' Elisabet qa iwkajitshen pa'aj, qa lee'fij (5) pe' juwelits in nite' wi's pa'aj, qa yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Yaqsi'j ye'mijkii pa' Yatsat'axyij aka'an qe qa' nili'ij ne' tsutentax.— ");
INSERT INTO mca_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Qa in hats ewi'ƚ tatsai (6) pa'aj ƚeqe juwelits pe' Elisabet, pa' Dios qa nukinetsju' iye pa' ángel Gabriel pa' ewi'ƚ witset ƚa's ƚii Nazaret, na' sehe' Galilea ");
INSERT INTO mca_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pe' ewi'ƚ inanyi' mexe ham yawitjiye', ƚii María. Qa hats jutsiqetsi'ƚ wetju'ƚ qu' ƚewhe'ye'yi'ij pa' ewi'ƚ jutjana'x ƚii José ta'ƚets pa' David'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pa' ángel qa we'tmetinheti'm pa' i'ni' pe' inanyi', qa yit'ijets: —¡Hewetfel e'm, akha' qi pa' ƚenekumhiyijiiji'! Na' Yatsat'ax'inij qu' na'n ejupkii.— ");
INSERT INTO mca_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ke' María qa qi in yitjuƚaxijpha'm pa'aj pe' ƚe'lijeyets pa' ángel, qa ƚatawe'jƚeji' pa'aj in watfaakanƚe in yit'ij qetuk pa' ikji'ha aka' witwetfelhewo. ");
INSERT INTO mca_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pa' ángel qa yit'ijets pa'aj: —Hasu'uj e'nijiwei, María, qe na' Dios t'eku'm eiji'. ");
INSERT INTO mca_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hane'ej qa' iwkajitshen qa' nenekfik'i hatse' pa' oqwomehe', qa' eqiyi'ij Jesús. ");
INSERT INTO mca_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pakha'an qiji'ha hatse' qa' ƚeqiyi'ij iye, Ƚa's pa' Qiji'ha. Na' Yatsat'ax'inij Dios qa' netisij hatse' qu' nayaxipji' na' ƚots'oji'la'x kakha' aqwa'maxi'ƚik'i wittata'ik'i David. ");
INSERT INTO mca_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Qa' nite' niliyi'ij qu' qiye' qu' netnek'enhe'yipji' ne' ƚetsi' ka' Jacob, qu' netnek'enhei ham pa'qu' ƚ'aka'the'ye'.— ");
INSERT INTO mca_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ke' María qa yit'ijets pa'aj pa' ángel: —¿Pa'n ƚunye'j qu' nana'l hatse' aka'an in mexe nite' yaqapi' pa'qu' jukhewe'?— ");
INSERT INTO mca_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Qa pa' ángel qa yit'ijiju'ƚ pa'aj: —Na' Espíritu Santo qu' nanam ewetsju' qa na'n'epji', qa na' ƚet'unha'x na' Qiji'ha qa' na'n'epji' iye hik qu' ƚunye'je' na'aj ƚeq'eneƚeya'x ne'ej wasi'. Qa hik ta'ƚijupi' pakha' qi in Ƚe'wis qu' nenektaxfik'i qa ƚenqiyi'ij “Ƚaa'sija pa' Dios.” ");
INSERT INTO mca_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jeƚ qeku'nek, ke' ejefeki' Elisabet in na'l iye hatse' pa' ƚa's, yemjeetax in hats k'utshetax, kikhe'en titijiti'yijets in ham ƚa'se' qa hane'ej qa hats ewi'ƚ tatsai (6) ƚeqe juwelits in iwkajitshen. ");
INSERT INTO mca_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Qe ham pa'qu' wekweke' qu' jutsitaxi'im na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma' qa yit'ij pa'aj pe' María: —Yakha' ƚeqejkunenki'yij pa' Yatsat'ax'inij. Naqsi'jijkii pa' Dios in ƚunye'jek kakha' hats ƚenfel ye'm.— Ma' qa pa' ángel qa ikik'ui iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Qa hik pekhewe' pe' neƚutsji' pa'aj, ke' María qa itaqsunii qu' namii pa' ewi'ƚ pe' witsetits ƚelits pa' uteket i'ni' na' sehe' Judea. ");
INSERT INTO mca_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Qa uyifi pa'aj pe' ƚetsi' pa' Zacarías qa wetfeli'm pe' Elisabet. ");
INSERT INTO mca_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","In yepi'ye' pa'aj pe' Elisabet pa' ƚewetfelhinye'j ke' María, ma' qa pa' omeƚa's qa t'otspha'mkii pa'aj ƚatawe'jji' pe' Elisabet. Qa pe' Elisabet qa topo'oj pa'aj pa' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma' qa pe' Elisabet qa yit'unhetik'i pa'aj in yit'ij: —Pa' Dios les qi'ija in ƚe'wis pa' neƚisij qa nite' hik ƚunyejei ene' week efuts pe' tisij, qa les in ƚe'wis iye pa' tisij pakha' omeƚa's i'nji' ne' ekutjii. ");
INSERT INTO mca_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Inhats'ek in yijunye'jkii aka'an, in namyii ene' ƚenene pa' Yatsat'axyij? ");
INSERT INTO mca_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Qe in i'nk'a k'epiye'ej kakha' ewetfelhinye'j qa pa' ya's ene' yikutjiiji' qa aje'eƚ t'otspha'mkii qe qi in ƚe'wisi'mkii. ");
INSERT INTO mca_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ƚe'wisi'mkii ene' nite' yeqeku'uk'i qu' yijaayi'ija qu' nana'l hatse' week pekhewe' hats nifeli'm pa' Yatsat'ax'inij.— ");
INSERT INTO mca_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma' qa ke' María qa yit'ij pa'aj: —Pa' yitawe'j qi in yiwqinhetji'ha pa' Yatsat'ax'inij, ");
INSERT INTO mca_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","qa pa' yeqe espíritu ƚe'wisi'mkiiha qe ta'ƚets pa' Dios hik pakha' eqiƚina'x tsiƚin hatse'. ");
INSERT INTO mca_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Qe nejeƚ yiwetsju' in yi'f'iljetsaxtax in ƚeqejkunenki'yij, qa hane'ej qa week ƚahatsiyij qu' nenit'ij yiwets in qi pa' ƚe'wis heyesti'yij. ");
INSERT INTO mca_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Qe pa' Qi T'un Ham Ƚunye'ji'iju'ƚ yaqsi'j ye'mijkii pe' qits wekwek ham ƚunyejeyi'iju'ƚ. ¡Qiji'ha qa ƚe'wisija iye aka' ƚii pa' Dios! ");
INSERT INTO mca_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Qa ene' week ƚahatsiyij qu' ne'nq'eletij pekhewe' qu' ne'nijiweyiju'ƚha. ");
INSERT INTO mca_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pa' ƚokoi yaqsiijkii pe' qits wekwek, yak'esaxik'uikii pa' yijamtitaxets pe' qi nikfe'ltaxets wekwek. ");
INSERT INTO mca_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yiwu'mik'uifik'i pe' t'unitstax in tenek'enhei pe' ƚots'ojilaxitstax, qa yenpha'm qu' netnek'enhei ene' wetf'iljetsin. ");
INSERT INTO mca_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pe' qi iyipkuntaxju' qa tisij pa' qi qa ƚe'wis ƚaq, qa pe' qi yiwq'axintax wekwek qa ham pa'qu' netisij. ");
INSERT INTO mca_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Qi in t'ifti'ts'ets ha'ne Israel. Hik ha'ne ƚeqejkunenek, qe nite' nitapi'ii pa' qi ƚeq'iltiye'j pa'aj ");
INSERT INTO mca_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","in yiwjutsiqeni'm pa' i'nalek'ik'i Abraham'ik'i qa week pekhewe' ta'ƚets.— ");
INSERT INTO mca_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ke' María qa wetshetk'ewi'ƚ juwelits in amanijup pa'aj pe' Elisabet, ma' qa i'nk'aƚe qa wapilii iye pa'aj pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","In yamets pa' ƚahats'ij qa nekfik'i pa'aj pa' ƚa's pe' Elisabet. ");
INSERT INTO mca_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pe' metitsi'm qa pe' ƚejefets iye qi in ƚe'sitsi'mkii in impi'yelij pa' Yatsat'ax'inij in hats yethinij pa' ƚeq'ilta'xij pe' Elisabet, ma' qa week ƚesitsiƚi'mkii pekhe'en. ");
INSERT INTO mca_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Qa in hats yamets pa'aj wetshetk'ewi'ƚ tatsai (8) pe' ƚeqe neƚuts, qa namii pekhewe'en, qe qa' ne'nisa'xii ƚaxpa's pa' omeƚa's, qa yisu'untax qu' ƚiyifeyi'ij pa' ƚatata Zacarías. ");
INSERT INTO mca_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Qa ke' ƚenene qa yit'ij: —Nite', qe aka' qu' ƚiyi'ij yijat'ij Juan.— ");
INSERT INTO mca_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Qa yit'ijju' iye pekhewe'en: —Ham inek pa'qu' ƚiyi'ij kakha'an ene' ejefets.— ");
INSERT INTO mca_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma' qa ƚokoyeiƚe pe' yittaxiji' in nifaakantaxij iye pa' ƚatata, pa'n qu' ƚiyi'ij. ");
INSERT INTO mca_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Qa pakha'an qa iyinets pa' ewi'ƚ najak k'eewe, qa yika' pa'aj aka'an in yit'ij: —Aka' qe ƚii hane'en Juan.— Qa week yitjuƚaxijpha'mkii pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma' qa aje'eƚ pa' Zacarías qa wejje'm pa' ƚeji' qa q'ul iye pa' ƚelepep, qa yape qa iyetƚek pa'aj yiwqinhet pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Qa week pekhewe' metitsi'm qi in yitjuƚaxijpha'mkii pa'aj. Ma' qa week pa'aj pe' witsetits ƚelits pa' uteket na' sehe' Judea in i'ye'ej pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Week pekhewe' impi'yelij aka'an qa yaqsi'j pe' ƚatawjetsji', qa yitjiijju': —¿Qetuk pa' ƚunye'j hatse' ha'ne omeƚa's? Qe pa' ƚokoi pa' Yatsat'ax'inij yijaa'ija in i'nijup nakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pa' Zacarías hikpa' ƚatata pa'aj pa' omeƚa's, qi in topo'oj pa'aj pa' Espíritu Santo, ma' qa nifel pakha' mexe hamik'ui qu' ƚunye'je'kii pa'aj, qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Neniwqinhetji'ha pa' Yatsat'ax'inij, ƚeqe Dios ene' Israel, qe te'nilitju' qe qa' niƚin ha'ne ƚetset. ");
INSERT INTO mca_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma' qa hats niihin ink'uipha'm pa' ewi'ƚ qi t'un eqiƚina'x ta'ƚets pa' David'ik'i, hikpa' ƚeqejkunenek pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Qa in ƚ'anye'jek pa'aj in nifel qa i'nijji' pe' qi ƚe'sits ƚeqe profetalik'i, pakhaa'ij pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Qe qa' jinaqsi'jij pekhewe' inejuihifets, qa' jinaqsi'jij iye pa' ƚokoi pekhewe' week napjaxtax ine'm. ");
INSERT INTO mca_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Qe qa' ni'nq'ethinij pa' ƚeq'iltiyejij pe' i'nalheyik'i qa qu' naqsiijkii iye pakha' hats yiwjutsiqeni'm pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Qa aka' yiwjutsiqen pa'aj hik aka' nifeli'm pa'aj pa' i'nalek'ik'i Abraham, ");
INSERT INTO mca_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","qe qa' jinilithinik'ui pa' ƚokoi pe' inejuihifets, ma' qa' ham i'nijiweya'xe'kii qu' ji'nt'ithayiyi'm ");
INSERT INTO mca_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","in ji'we'neni'ha qa jiwattsathenketetsha iye pakha'an week pekhewe' inqeneƚutsji'. ");
INSERT INTO mca_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Qa akha', omeƚa's, ƚenqii'ej hatse' ƚeqe profeta pa' Qiji'ha, qe ƚojo'ok'oi hatse' pa' Yatsat'ax'inij qe qa' ajiletik'ui pe'qu' ƚ'ikheijeye', ");
INSERT INTO mca_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","hats'inha qu' ikfelitets aje'eƚ na' ƚetset in ƚeke' qu' iƚiye' qu' nata'ƚets qu' netwumhiti'yik'ui pe' ƚewuƚ'ets, ");
INSERT INTO mca_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","qe ta'ƚets pa' qi'ija in ƚeq'iltiye'j inij pa' inqe Dios, ma' qa pa' hik ƚunye'j ne' junu' na'aj ink'ayik neƚukii qa' nanam inwetsju' ta'ƚiipha'm pakha' les in toxpha'm, ");
INSERT INTO mca_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","qe qa' nanaliti'pji' pekhewe' i'ni' pa' qi in nookii qa i'ni' iye pa' ƚeq'eneƚeya'x pa' witwamhi'. Hats'inha qa' nojo i'nk'uyii pa' ƚenikheyij pa' wit'ikesimeya'xƚekii.— ");
INSERT INTO mca_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pa' omeƚa's qa teiƚem in hats qiyu' pa'aj qa in t'unij iye pa' ƚeqe'spiritu. Qa i'ni'kii pa'aj pa' ham i'ni'i' qa yamijii pa' neƚuji' in hats nifeli'm pekhewe' Israel ƚeiƚets. ");
INSERT INTO mca_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Qa ƚunye'jkii pa'aj pekhewe' neƚutsji' in t'atsji'ƚfik'i pa' ƚafaakanek pa' qi Roma ƚatata ƚii Augusto, hats'inha qu' ne'nika'ajji' (censo) pe' week jukhew, efuts, omehets in uja'xek pe' week witsetits pa' Roma ƚeqe sehe'. ");
INSERT INTO mca_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aka'an hik aka' pa' yojo pa'aj in i'nk'aƚe wanaqsiijkii in wenika'ajji'kii (censo), hik pakha'aj pa' ƚahats'ij pa' Cirenio mexe gobernador ipji' pa' sehe' Siria. ");
INSERT INTO mca_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma' qa week ikiikii qu' namiikii pekhewe' ƚetsetits pe' ta'ƚetskii ƚawa'mhitsik'i, hats'inha qu' ne'nika'ajji'kii. ");
INSERT INTO mca_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Qa hik ta'ƚijupi' pa'aj pa' José in ikik'ui pa' witset Nazaret, i'ni' pa' sehe' Galilea, qa yamii pa'aj na' ƚetset'ek pa' David'ik'i witset ƚii Belén nakha' sehe' Judea, qe pa' José ta'ƚets pa'aj pa' David'ik'i, ");
INSERT INTO mca_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","qe qa' ne'nika'aƚijji' ke' María, hikke' hayiits jutsiqaxij pa'aj qu' ƚewhe'ye'yi'ij, kikhe'en iwkajitshen pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Qa ƚunye'jkii pa'aj pekhewe'en in mexe i'ni' pa'aj ha' Belén, ke' María qa yamets pa'aj ƚahats'ij qu' nanqala'x. ");
INSERT INTO mca_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Qa nekfik'i pa'aj pa' yojo in ƚa's, qa yijupheƚiji' pa'aj pe' penyilots qa yiwhinjiju' pa' wakka ƚenexkutjiyij, qe hats ham pa'aj pa'qu' ƚetset'e pekhewe' ƚewhitil. ");
INSERT INTO mca_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Meti'm ha' Belén pa'aj pe' uja'x kots'etets yejeƚ i'wiji' pa'aj pe' ƚeƚinhei in naja'xij pa' ƚ'ejinqa'wet. ");
INSERT INTO mca_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Qa te'nethinets pa'aj pa' ewi'ƚ ƚaqa ángel pa' Yatsat'ax'inij, qa pa' ƚesa'x pa' Yatsat'ax'inij qa napjuyit'ipji' pekhewe'en. Qa qi in nijiwei pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Qa pa' ángel qa yit'ijets pa'aj: —Hasu'uj e'nijiwe'yi'ƚ qe yakha' henka'xi'ƚ ewetsju' ka' ewi'ƚ qi ƚe'wis witiihet, qa hikka' week qu' ni'sinheti'mkii ");
INSERT INTO mca_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","qe hane'ej hats neki'ƚ ewetsfik'i na' ƚetset'ii ka' David'ik'i, na' ewi'ƚ Eqiƚina'x, hik nakha' Cristo Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na'l ka' jutsiqaxij qu' i'weni'ƚ na' omeƚa's, wetjuphe'ƚji' ne' penyilots qa weniwhinjiju' ne' wakka ƚenexkutjiyij.— ");
INSERT INTO mca_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Qa hik pakha'aj qa laxa pekhewep iye olots angelits ewi'ƚ i'ni'ƚi' pa' hayiits we'nethinetsju' pa'aj, qa yiwqinhetji'ha pa' Dios, qa yit'ijju': ");
INSERT INTO mca_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Qi'ija in ƚe'wis pa' Dios i'ni' pa' les toxpha'mha! ¡Wit'ikesimeya'xƚekii ha'ne sehe' ipji' pekhewe' qu' netk'enetsha nakha'an!— ");
INSERT INTO mca_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ma' qa in hats wapiletspha'mkii iye pe' angelits na' wa's, qa pe' kots'etets yejeƚ qa yifaakateji' pa'aj: —Yape jiyamii ha' Belén qa jinte'wen pakha' nifel ine'm iku'uj pa' Yatsat'ax'inij.— ");
INSERT INTO mca_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Qa qi in itaqsunii pa'aj, ma' qa wo'oikii qa yi'wen pa'aj ke' María qa pa' José qa pa' omeƚa's i'wji'ju' pa'aj pe' wakka ƚenexkutjiyij. ");
INSERT INTO mca_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","In yi'wen pa'aj, ma' qa nifelimik'i week pa' yit'ijets pa'aj pa' ángel in t'ejuyets pa' omeƚa's. ");
INSERT INTO mca_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Qa week pekhewe' yepi'ye'ji'jij qa yitjuƚaxjiijpha'mkii pe' wekwek tefelhiti'yi'm pa'aj pe' kots'etets yejeƚ. ");
INSERT INTO mca_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ke' María yaqsi'jija pa'aj week na'aj yepi'ye'jiik'i ekewe' wekwek ƚunyejeikii, ma' qa yijamtijiijupkii. ");
INSERT INTO mca_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Qa pe' kots'etets yejeƚ in hats wapilkii pa'aj, qi in yiwqinhetji'ha pa'aj pa' Dios, qe ta'ƚets week pekhewe' yepi'ye' qa yi'wen iye, qa hik ƚunye'j pakha' hats tefelhiti'yi'm pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Qa in yamets wetshetk'ewi'ƚ tatsai (8) ƚeqe neƚuts in teƚuifik'i qa yisaxji' pa' ƚaxpa's qa testi'yij qu' ƚiyi'ij Jesús. Hik aka' hayiits yit'ijets pa'aj pa' ángel ke' María qu' ƚiyi'ij in mexente' iwkajitshen pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma' qa in yafits iye pa'aj pa' uja'x pe' neƚuts pekhewe'en qu' naqsiijkii qu' hik ƚunye'je' qu' mexe netetlij eku'uk'uiju' pe' witlijtsitjii, in ƚ'anye'jek pakha' wenit'ij yika' pa'aj pa' Moises'ik'i. Qa neka'xii pa'aj pa' omeƚa's ne' qi witlijtsitjii na' Jerusalén qe qa' netisij pa' Yatsat'ax'inij, ");
INSERT INTO mca_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","in ƚ'anye'jek kakha' we'nika'ajji' yit'ij (ley) pa'aj pa' Yatsat'ax'inij in yit'ij: —Pakha' qu' nojo qu' wita'se' jukhew pakha'an yatsat'axij na' Yatsat'ax'inij.— ");
INSERT INTO mca_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Qa qu' nilanifi pe'qu' inqa'metetse' ma' qa yaqsiijkii kakha' hats yit'ij pa'aj (ley) pa' Yatsat'ax'inij: —wetsjuk pe'qu' k'iwukitetse' i'nƚi'i qu' wetsjuk'e pe'qu' ofotets ƚelitse'.— ");
INSERT INTO mca_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na'l pa'aj pa' ewi'ƚ jukhew na' witset Jerusalén ƚii Simeón, ha'ne jukhew yatsathen qa yijayaanija iye pa' Intata. Notkitaxiikiiha qu' nanam pakha' qi qu' ni'fen ene' Israel. Pa' Espíritu Santo i'nipji' pakha'an. ");
INSERT INTO mca_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pa' Espíritu Santo qa yikfelitets in nite' wa'm qu' mexe nite' ni'wene' pa' Cristo nukinju' hatse' pa' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pa' Simeón qa ikii pa'aj ne' qi witlijtsitjii qe pa' Espíritu Santo hik pakha'ƚe in ta'ƚets. Qa pekhewe' ƚ'alhei pa' omeƚa's Jesús in neka'xii qu' naqsiijkii pakha' hats wenit'ij pa'aj qu' net'ejuyets pa' omeƚa's, ");
INSERT INTO mca_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pa' Simeón weikuti'ƚ wetju'ƚ pekhewe'en pe' witlijtsitjiyifi qa tik'eyij pa'aj pa' omeƚa's, qa iyinetspha'm pa' Dios, qa yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Hane'ej, Yatsat'axyij, yape exke'yi'ij qu' ƚe'wise'ƚe qu' hats nawa'm ha'ne eqejkunenek, in ƚunye'jek kakha' hats ƚit'ij, ");
INSERT INTO mca_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","qe ene' yitooyija in hats yi'wen ha'ne eqiƚinkeye'j. ");
INSERT INTO mca_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ha'ne hayiits ƚajilet pa'aj qu' ni'wen hatse' ene' week witsetits. ");
INSERT INTO mca_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hik qu' ƚunye'je' fetitjii qa' nanaliti'pji' pe' nite' Israel ƚelits, qa' nata'ƚets iye qu' niwqinhetji' pe' nite' Israel ha'ne etse't Israel.— ");
INSERT INTO mca_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Qa pe' ƚ'alhei pa' omeƚa's qa qi in yitjuƚaxijpha'mkii pa'aj ekewe' wekwek yit'ij pa'aj pa' Simeón in t'ejuyets pa' Omeƚa's Jesús. ");
INSERT INTO mca_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pa' Simeón ma' qa iyinipji' pa'aj pekhewe'en. Ma' qa yit'ijets pa'aj ke' María ƚenene ha' Jesús: —Ek'en qeku'nek, ha'ne omeƚa's taqsijkitiyijkii qu' nata'ƚets qu' olotse' pe'qu' nanamju'kii qa pe'qu' neniipha'mkiyek ene' Israel. Hik ha'ne iye qu' jutsiqaxi'ij pe'qu' net'ejuyiju'ƚ, ");
INSERT INTO mca_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","qe qa' netwenhetiyetsju' pa' ƚunyejeeyija pe' ƚaqjamtikineyejeikii pe' olots wittawjets, qa akha'ƚe qa' qi qu' aats'e' qa qu' ika'metkii iye, María, hik qu' ƚunye'je' qu' nat'atsjiƚ'ejfik'i pa'qu' witqatsjikinet'e.— ");
INSERT INTO mca_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na'l iye pa'aj pe' ewi'ƚ profetaki' ƚii Ana, ƚasi' pa' Fanuel'ik'i ta'ƚetsek pa'aj pe' ƚawa'mhitsik'i pekhewe' ta'ƚetsek pa' Aser'ik'i. Pekhe'en hats ƚawa'mhi'ija pa'aj. Mexe inanyi' pa'aj in tewhe'yei qa wetsjuk tatsai (7) ƚeqe'ninqapitsij pa' ƚewhe'ye' qa wa'm pa'aj, qa nite'ƚe tewhe'yei iye. ");
INSERT INTO mca_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Qa in hats wikiihale'ej pa'aj qa yamijets ochenta y cuatro (84) ƚeqe'ninqapitsij. Nite' ikik'uifik'i pe' qi witlijtsitjii, qe t'ithayi'yi'm yijat'ij pa' Dios neƚuts qa najai iye, yaqsi'j jiijkii qa nite' tekji'ij qa iyiinjiija iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma' qa pe' Ana qa namijets pa'aj pa' ƚunye'jkii, ma' qa yit'ijetspha'm pa'aj ƚe'wisij pa' Dios, ma' qa nifelji'ijkii pa' omeƚa's, nifelji'ji'm week pekhewe' notkitaxik'ui pakha' yiwejinfik'i hatse' na' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ma' qa in hats week naq'axijipji' pa'aj in yaqsiijkii pekhewe' yit'ij pa'aj pa' Yatsat'ax'inij qu' nanaqsiijkii (ley), qa wapilii iye pa'aj ha' sehe' Galilea pa' ƚetset'ija Nazaret. ");
INSERT INTO mca_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pa' omeƚa's qa hats qiyu' pa'aj qa hats t'uniyu' iye pa'aj, week neƚuts t'ijayijfik'i pa' ƚikfeliya'xkii, qa pa' ƚeqi'fenkeye'j pa' Dios qa i'nipji' pakha'an. ");
INSERT INTO mca_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pe' ƚ'alhei hayiitsƚe yamji'jii ha' Jerusalén week ininqapits yaqsiijkii qa yamji'jets pe' ƚe'sits neƚuts Pascua. ");
INSERT INTO mca_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","In hats doce (12) pa'aj ƚeqe'ninqapits pa' Jesús qa yamets iye pa'aj ƚahats'ij qu' nami'ƚii pe' ƚ'alhei pa' Jerusalén, pakha' hats ƚunyejeiji'ij qa yamji'jets pa' ƚe'wis neƚu. ");
INSERT INTO mca_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Qa in hats wapiltaxkii iye pa'aj pekhewe'en, in hats week naxijik'i pa'aj pe' ƚe'sits neƚutsik'i, qa pa' omeƚa's Jesús qa amanji' pa' witset Jerusalén. Nite' nikfe'lets pe' ƚ'alhei in amanji' pa' witset. ");
INSERT INTO mca_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yumtitax qu' na'n ji'teje'm pekhewepe' pekhewe' olots in ikkii pa'aj qa hats ewi'ƚ neƚu pa'aj in ikijje'm in ikkii, qa yapeƚek qa wo'taxiikii pa'aj qa nifaakantaxij pe' ƚejefets qa pe' nikfe'li'ƚ wetju'ƚ iye. ");
INSERT INTO mca_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Qa hamƚe yi'wene' pa'aj. Ma' qa wapilijii pa'aj ha' Jerusalén qu' nowo'oikii. ");
INSERT INTO mca_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Qa ƚunye'jkii pa'aj in hats wetshetk'ewi'ƚ neƚuts qa yi'weni' pa'aj ke' qi witlijtsitjiyifi, i'nji'ju' ƚeqewuk'u pa'aj pekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei. Tek'enets in iyetik'ui qa nifaakankii iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Week pekhewe' yepi'ye' pa'aj in iyet qi in yitjuƚaxijpha'mkii pa' ƚikfeliya'xets qa in yasiinjiik'iha iye qa yeku'ƚjiik'i na'aj tafaakanhetiiji'ijtaxij. ");
INSERT INTO mca_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","In yi'wenij pa'aj aka'an pe' ƚ'alhei qa qi in yitjuƚaxijpha'mkii pa'aj, qa pe' ƚenene qa yit'ij: —Ya's, ¿inhats'ek in eqfenyejeyi'ƚyij aka'an? Ha'ne atata qa yakha' qi in howotaxi'ƚ eikii qa qi iye in ƚesƚ'ileheti'ƚ iye.— ");
INSERT INTO mca_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ha' Jesús qa yeku'ƚ pa'aj: —¿Inhats'ek in pekhel ƚamiƚijji'kii in ƚowotaxiƚyiikii? ¿Inhats'ek in nite' ƚenikfe'li'ƚets in les ƚe'wis qu' ha'nifi ene' ƚetsi' na' Tata?— ");
INSERT INTO mca_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Qa pe' ƚ'alhei qa nite'ƚe nikfe'lik'i kakha' yit'ijets pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ma' qa ƚijts'eyek pa'aj in wapilkii qa yamii iye pa'aj ha' Nazaret. Qi in tek'en pa' omeƚa's, tek'eenetsha pe' ƚ'alhei. Qa ke' ƚenene yaqsi'jija pa'aj week na'aj yepi'ye'jiik'i ekewe' wekwek ƚunyejeikii. ");
INSERT INTO mca_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pa' Jesús hats t'ijaipha'mha pa'aj pa' ƚikfeliya'xkii qa pa' ƚ'a'j iye, qa yape'enha iye les in yisu'un pa' Dios qa pe' jukhew pakha' ƚunye'j pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pa' qi wittata Tiberio qa hats yamijets pa'aj quince (15) ƚeqe'ninqapitsij in wittata pa' Roma. Pa' Poncio Pilato hikpa' gobernadorijek na' sehe' Judea, qa pa' Herodes qa gobernadorijek na' Galilea, qa pa' ƚek'inij pa' Herodes ƚii Felipe qa gobernadorijek pa' Iturea qa pa' Traconite, qa pa' Lisanias qa gobernadorijek pa' Abilinia. ");
INSERT INTO mca_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pa' Anás qa pa' Caifás hik pekhewe' uja'xƚe in qitsji' in pa'il ƚatatal, hik pakha'aj pa' Dios qa nithinetsju' pa' Juan ƚa's pa' Zacarías, in i'ni' pa' ham i'ni'i'. ");
INSERT INTO mca_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Qa pa' Juan qa ikijik'iju' pa' ƚekuwe' pa' week haqqi' Jordán. Qa nifeli'm pe' week qu' nili'ij in yaqsiijkii pe' uƚ'ets qa' nempuli'jju', hats'inha qu' netwumhiti'yik'ui pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Qa in ƚ'anye'jek pa'aj kakha' we'nika'ajji' pa' witfaakanek ƚe'lijei pa' profeta'ik'i Isaías in yit'ij pa'aj: —Ewi'ƚ pa' wit'ax taya'yi'kii pa' ham i'ni'i', yit'ij: “Aqsi'ji'ƚik'i pa'qu' ƚikheyije' pa' Yatsat'ax'inij. Qa' natsathen iye hasu'uj q'if'imme' pe'qu' ƚ'ikheijeye'. ");
INSERT INTO mca_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Week pa'qu' kiimiyetaxju' qa' nenenjiju' sehe'ye' qa' ƚ'ajaye' wetju'ƚ, week ne' utekui qa ne' utekui ƚelits qu' newetts'ejinhetifikii qa' week ƚ'ajaye' wetju'ƚ pa' wit'ikheyi'j. Ne' q'if'imtax wit'ikheijei qa' nawattsathenket iye, qa ne' f'ulummik'i wit'ikheijei qa' nete'nila'sju' qa' lememmi'ik'i iye. ");
INSERT INTO mca_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Week aka' wit'eseninye'j qu' ni'wen hatse' pa' ƚeqiƚinkeya'x pa' Dios.”— ");
INSERT INTO mca_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Qa hik ta'ƚijupi' pa'aj pa' Juan in yit'ijji'ju' pekhewe' olots nektaxii qu' nenimpulijinju': —¡Hik ejunyejeyi'ƚ q'oiq'oyits ƚelits! ¿Ƚekpa' nefeliƚi'm qu' ƚeke'ye' qu' ilati'ƚik'ui hatse' pa' qi iftsax ƚawak pa' Dios qu' nanamtax? ");
INSERT INTO mca_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Manaqsiji'ƚju'ha yijat'ij pa'qu' ejunyejeyi'iƚ qu' yijaayi'ija qu' menink'aihiti'ƚ hats'inha qa' ne'twenhetii, qa hasu'uj umti'iƚ qu' nelithiniƚik'ui hatse' pa' qi ƚawak hatse' pa' Intata qu' it'iƚij: “Yekheweli'ƚ hata'ƚi'ƚets pa' Abraham'ik'i” qe yijaa'ija qu' hit'iƚij ewets pa' Dios in ƚeke' qu' naqsiijkii ene' utel qu' ƚelitsi'ij pa' Abraham'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Qa pe' witfejinetki' qa hats we'nenijupju' pa' ƚefitets pe' najkakui. Qa hik ta'ƚijupi', week pe'qu' najkak'e qu' nite' ƚe'sitse' pe'qu' ƚeye' qa' newetfekinifi qa' netwumhitiiji'ju' pa' fe't.— ");
INSERT INTO mca_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma' qa pe' olots jukhew qa efuts qa nifaakanij pa'aj: —¿Pa'n ƚiyek pa'qu' haqsiiƚijkii?— ");
INSERT INTO mca_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pa' Juan qa yeku'ƚ pa'aj: —Pa'qu' nana'li'm wetsjuk'e ƚ'uihitjiyitse' qa netisij ewi'ƚe' pa'qu' wiikfi' ham ƚ'uihitjiye'. Qa pa'qu' nana'li'm pe'qu' ƚaqatse' qa' netisij iye pe'ye' pa'qu' wiikfi' ham ƚaqe'.— ");
INSERT INTO mca_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qa nekets iye pekhewe' yijaninkii wekwek qu' nenimpulijinju' iye, pekhewe'en qa yit'ijets iye: —Maestro, ¿pa'n qu' yeqfenyejeyi'iƚ yiwekek?— ");
INSERT INTO mca_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma' qa pa' Juan qa yeku'ƚ iye: —Hasu'uj anhinƚi'iƚi' pa' hats uja'x pa' ƚ'ayajaxtiyiƚijets qu' ijanini'ƚkii ekewe' wekwek.— ");
INSERT INTO mca_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Qa na'l iye pe' uja'x oq'opheƚinetsilets qa nifaakan iye pa'aj: —Qa yekheweli'ƚ, ¿ƚekpa' qu' haqsiiƚijkiyek?— Qa yeku'ƚ iye pa'aj pa' Juan: —Hasu'uj aqani'ƚijkii pe'qu' e'lijeyi'iƚ ma' qa' neƚisij pe'qu' ƚ'astaye' pa'qu' ijiweikiti'ƚkii. Hasu'uj iye mowotk'oniƚijkii iye qu' it'iƚijets qu' naqsiijkii pa'qu' uƚ'axe' pa'qu' hamtax uƚ'axe' qu' naqsiijkii. I'wejuƚeni'ƚij yijat'ij pekhewe' qu' ajaleji'ji'ƚ in oq'opheƚinetsiletsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Qa in ƚunyejeyek pekhewe' jukhew qa efuts in na'l pakha' notkitaxiikii, qa week ƚatawjetsƚeji' in watfaakanƚeji'ij, yijamtijijets pa' Juan qu' hik pakha'ye' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Qa pa' Juan qa yeku'ƚik'i pa'aj aka'an, qa yit'ijji'ju' pekhewe' week: —Yakha' k'empuujini'ƚji' ha'ne iweli'ƚe, qa pakha'ƚe teke'lenju' qu' nanam hatse', pakha'an les t'un, t'anyipji', hik pakha' nite' ye'weju'ƚij iye qu' henit'ijji' pe' ƚeqniihayij pe' ƚ'otshilaxtii, pakha'an qa' nempuujini'ƚji'ek pa' Espíritu Santo qa pa' fe't iye. ");
INSERT INTO mca_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hats t'eku'mi'kii pe' ƚeqe tseyem qe qa' niwu'mpha'mkii qu' naqsijijji' pe' trigo hats'inha pa' t'unik'i qa' niwu'mkii pe' ƚ'ajits. Qa pe' ƚoi qa' naqsi'j qa' nenifi pe' ƚextsi'ij, qa pekhewe'ƚe ƚ'ajits qa' niwu'mji'ju'kii pa' fe't nite' yom.— ");
INSERT INTO mca_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Qa olots iye pekhewep iye nifel pa' Juan in yakakƚinij eke' ƚe'sits wi'tlijei pe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pa' Juan yaq'ayintaxij iye pa'aj pa' tenek'enhei Herodes in ƚewhe'ye'ej pe' Herodías ƚewhe'ye'tax pa'aj pa' ƚek'inij ƚii Felipe, qa week iye pekhewep iye uƚ'ets in yaqsiijkii yaq'ayintaxij iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Qa week ekewe'en in hats uƚ'etstax in yaqsiijkii qa yukinets iye aka'an in yaqsiijkii: in yophe'ƚ pa'aj pa' Juan. ");
INSERT INTO mca_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Qa ƚunye'jkii pa'aj in nimpulijinju' pekhewe' olots pa' Juan, pa' Jesús qa wempili'j iye pa'aj. Qa in mexe iyin pa'aj pa' Jesús, qa qhofii pa'aj na' wa's. ");
INSERT INTO mca_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Qa pa' Espíritu Santo qa te'nilit'etsju' pa'aj qa i'nipji' hik ƚunye'jtax na'aj ofo'. Qa pa' wit'ax qa nokesji'pha'm pa'aj na' wa's, qa yit'ij: —Akha' K'ayaasija qi in k'esu'un. Akha' qi in ƚets-sinheti'mkii.— ");
INSERT INTO mca_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","In hats i'nju' pa'aj qu' nenfel eke' ƚe'sits wi'tlijei, pa' Jesús qa hats yamets pa'aj treinta (30) pe' ƚeqe'ninqapits. Titijiti'yijets qu' ƚa'se' pa' José. Ta'ƚets pa' Elí, ");
INSERT INTO mca_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","pa' Eli'ik'i pa' ƚatata ƚii Matat. Pa' Matat'ik'i pa' ƚatata ƚii Leví. Pa' Levi'ik'i pa' ƚatata ƚii Melquí. Pa' Melqui'ik'i pa' ƚatata ƚii Jana. Pa' Jana'ik'i pa' ƚatata ƚii José. ");
INSERT INTO mca_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Pa' Jose'ik'i pa' ƚatata ƚii Matatías. Pa' Matatias'ik'i pa' ƚatata ƚii Amós. Pa' Amos'ik'i pa' ƚatata ƚii Nahúm. Pa' Nahum'ik'i pa' ƚatata ƚii Esli. Pa' Esli'ik'i pa' ƚatata ƚii Nagai. ");
INSERT INTO mca_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Pa' Nagai'ik'i pa' ƚatata ƚii Maat. Pa' Maat'ik'i pa' ƚatata ƚii Matatías. Pa' Matatias'ik'i pa' ƚatata ƚii Semei. Pa' Semei'ik'i pa' ƚatata ƚii Josec. Pa' Josec'ik'i pa' ƚatata ƚii Judá. ");
INSERT INTO mca_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Pa' Juda'ik'i pa' ƚatata ƚii Joanán. Pa' Joanan'ik'i pa' ƚatata ƚii Resa. Pa' Resa'ik'i pa' ƚatata ƚii Zorobabel. Pa' Zorobabel'ik'i pa' ƚatata ƚii Salatiel. Pa' Salatiel'ik'i pa' ƚatata ƚii Neri. ");
INSERT INTO mca_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Pa' Neri'ik'i pa' ƚatata ƚii Melquí. Pa' Melqui'ik'i pa' ƚatata ƚii Adí. Pa' Adi'ik'i pa' ƚatata ƚii Cosam. Pa' Cosam'ik'i pa' ƚatata ƚii Elmadam. Pa' Elmadam'ik'i pa' ƚatata ƚii Er. ");
INSERT INTO mca_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Pa' Er'ik'i pa' ƚatata ƚii Josué. Pa' Josue'ik'i pa' ƚatata ƚii Eliezer. Pa' Eliezer'ik'i pa' ƚatata ƚii Jorim. Pa' Jorim'ik'i pa' ƚatata ƚii Matat. ");
INSERT INTO mca_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Pa' Matat'ik'i pa' ƚatata ƚii Leví. Pa' Levi'ik'i pa' ƚatata ƚii Simeón. Pa' Simeon'ik'i pa' ƚatata ƚii Judá. Pa' Juda'ik'i pa' ƚatata ƚii José. Pa' Jose'ik'i pa' ƚatata ƚii Jonam. Pa' Jonam'ik'i pa' ƚatata ƚii Eliaquim. ");
INSERT INTO mca_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Pa' Eliaquim'ik'i pa' ƚatata ƚii Melea. Pa' Melea'ik'i pa' ƚatata ƚii Mena. Pa' Mena'ik'i pa' ƚatata ƚii Matata. Pa' Matata'ik'i pa' ƚatata ƚii Natán. ");
INSERT INTO mca_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Pa' Natan'ik'i pa' ƚatata ƚii David. Pa' David'ik'i pa' ƚatata ƚii Isaí. Pa' Isai'ik'i pa' ƚatata ƚii Obed. Pa' Obed'ik'i pa' ƚatata ƚii Booz. Pa' Booz'ik'i pa' ƚatata ƚii Sala. Pa' Sala'ik'i pa' ƚatata ƚii Naasón. ");
INSERT INTO mca_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Pa' Naason'ik'i pa' ƚatata ƚii Aminadab. Pa' Aminadab'ik'i pa' ƚatata ƚii Admin. Pa' Admin'ik'i pa' ƚatata ƚii Arni. Pa' Arni'ik'i pa' ƚatata ƚii Esrom. Pa' Esrom'ik'i pa' ƚatata ƚii Fares. Pa' Fares'ik'i pa' ƚatata ƚii Judá. ");
INSERT INTO mca_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Pa' Juda'ik'i pa' ƚatata ƚii Jacob. Pa' Jacob'ik'i pa' ƚatata ƚii Isaac. Pa' Isaac'ik'i pa' ƚatata ƚii Abraham. Pa' Abraham'ik'i pa' ƚatata ƚii Taré. Pa' Tare'ik'i pa' ƚatata ƚii Nacor. ");
INSERT INTO mca_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Pa' Nacor'ik'i pa' ƚatata ƚii Serug. Pa' Serug'ik'i pa' ƚatata ƚii Ragau. Pa' Ragau'ik'i pa' ƚatata ƚii Peleg. Pa' Peleg'ik'i pa' ƚatata ƚii Heber. Pa' Heber'ik'i pa' ƚatata ƚii Sala. ");
INSERT INTO mca_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Pa' Sala'ik'i pa' ƚatata ƚii Cainán. Pa' Cainan'ik'i pa' ƚatata ƚii Arfaxad. Pa' Arfaxad'ik'i pa' ƚatata ƚii Sem. Pa' Sem'ik'i pa' ƚatata ƚii Noé. Pa' Noe'ik'i pa' ƚatata ƚii Lamec. ");
INSERT INTO mca_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Pa' Lamec'ik'i pa' ƚatata ƚii Matusalén. Pa' Matusalen'ik'i pa' ƚatata ƚii Enoc. Pa' Enoc'ik'i pa' ƚatata ƚii Jared. Pa' Jared'ik'i pa' ƚatata ƚii Mahalaleel. Pa' Mahalaleel'ik'i pa' ƚatata ƚii Cainán. ");
INSERT INTO mca_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Pa' Cainan'ik'i pa' ƚatata ƚii Enós, Pa' Enos'ik'i pa' ƚatata ƚii Set. Pa' Set'ik'i pa' ƚatata ƚii Adán. Pa' Adan'ik'i ƚatata pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pa' Jesús qi in topo'oj pa'aj pa' Espíritu Santo, qa tepilik'uipha'm pa'aj ha' haqqi' Jordán qa pa' Espíritu Santo qa yeka'xii pa' ham i'ni'i', ");
INSERT INTO mca_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","qa yamijets pa'aj cuarenta (40) neƚuts in i'ni'kii. Qa pa' inwo'met qa yijaajintax pa'aj. Ham tuje' pa'aj pe' neƚutsji' in i'ni'kii pa' ham i'ni'i'. Ma' qa i'nk'aƚe yoksi'wen in iyipkun. ");
INSERT INTO mca_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma' qa pa' inwo'met qa yittaxijets pakha'aj: —Qu' yijaa'ija qu' o' Dios Ƚa'se' qa it'ijets ene' ute qu' pani'ij.— ");
INSERT INTO mca_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Qa yeku'ƚ pa'aj pa' Jesús: —Kekhewe' we'nika'ajji' yit'ij: “Nite' ewi'ƚƚe pa'qu' pane' qu' niƚin pa'qu' jukhewe'.”— ");
INSERT INTO mca_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ma' qa pa' inwo'met qa yeka'xiipha'm pakha' les in toxpha'm ma' qa aje'eƚ yethinij pe' week witsetits ha'ne sehe' epji'. ");
INSERT INTO mca_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Qa yit'ijets: —Yakha' qu' k'eƚisij enewe' ƚet'unhaxitstax qa week iye aka' ƚe'sinyejeitax enewe' witsetits, qe yakha' hats heyesti'yij enewe'en, qa ƚeke' qu' hetisij pakha' qu' hisu'un qu' hetisij. ");
INSERT INTO mca_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Qa hik ta'ƚijupi', qu' monokok'enyifi qa' iyinyii ma' qa' week antsat'etsij enewe'en.— ");
INSERT INTO mca_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pa' Jesús qa yeku'ƚ iye pa'aj: —Ke' we'nika'ajji' Dios ƚe'lijei yit'ij: “Iyinii pa' Yatsat'ax'inij eqe Dios. Ewi'ƚƚe qu' aqsiijkii pa'qu' nit'ij.”— ");
INSERT INTO mca_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma' qa pa' inwo'met qa yeka'xii iye na' Jerusalén qa yeka'xiipha'm ƚesinje'eipha'm pe' qi witlijtsitjii, qa yit'ijets iye pa'aj: —Qu' yijaa'ija qu' o' Dios Ƚa'se' qa' ilit'iiju' na' sehe', ");
INSERT INTO mca_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","qe ke' we'nika'ajji' Dios ƚe'lijei yit'ij iye: “Qa' nenukinju' ne' ƚaqa angelits qa' nejeƚ ewets,” ");
INSERT INTO mca_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","qa yit'ij iye: “Qa pe' ƚokoyei qa' net'eku'm e' hats'inha qa'nte' neqfe'metene' ne' utel ne' ef'iyei.”— ");
INSERT INTO mca_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pa' Jesús qa yeku'ƚ iye pa'aj: —Yit'ij iye ke' Dios ƚe'lijei: “Hasu'uj ijaajin pa' Yatsat'ax'inij eqe Dios.”— ");
INSERT INTO mca_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pa' inwo'met in hats ham pa'qu' ƚeqfenye'ji'ij iye in yijaajintax pa'aj, ma' qa mexe ikik'ui iye pa'aj qe qa' nonotki'ets pakha' qu' niwemetsintaxij iye qu' nijaajin. ");
INSERT INTO mca_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pa' Jesús qa wapilii iye pa'aj ha' Galilea topo'oj pa' ƚet'unha'x pa' Espíritu Santo. Ma' qa weekij pe' witsetits na' sehe' Galilea in i'ye'ej wetju'ƚ pa'aj pa' ƚunye'j. ");
INSERT INTO mca_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Qa i'nq'ijatshenjiifi pe' ƚe'lijtsitjiyits pe' witsetits, qa qi in yiwqinhetji' pekhewe' week. ");
INSERT INTO mca_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pa' Jesús qa yamii iye pa'aj ha' Nazaret, hik hakha' qi'i' pa'aj. Qa hayiitsƚe yaqsi'j jiijkii qa yamji'jets na'aj witwapiihijii (sábado) qa uyifi pa'aj pe' witlijtsitjii. Qa niipha'm pa'aj qe qa' niyinenik'i ke' Intata ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Qa testi'yij pa'aj pakha' ƚafaakanek pa' profeta'ik'i Isaías. Qa mexe yejeƚiikii pa'aj pakha' yisu'un qu' niyinenik'i, qa yi'wen pa'aj pakha' yiyinenik'i, qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Na' ƚeqe Espíritu na' Yatsat'ax'inij i'nyipji', qe tsiwjutsiqen in tseqethenju' qe qa' henfeli'm eke' ƚe'sits wi'tlijei nekhewe' if'iljetsits. Ts'ukinju' qe qa' henfeli'm qu' netwejinhetiikii nekhewe' wit'opheƚiitax, qa' ni'wen wetju'ƚ iye nekhewe' puk'aletstax. Qa' netwejinhetiikii iye nekhewe' qi in tawitjaxtiitax. ");
INSERT INTO mca_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Qe qa' henfel iye pa'n ƚunye'j hatse' pakha' ƚeqe'ninqa'pji' pa' qi ƚeqi'fenkeye'j pa' Yatsat'ax'inij.— ");
INSERT INTO mca_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ma' qa yili'ij in yejeƚ qa yepiletje'm iye pa'aj pa' witfaakanek qa tisij iye pa' yejeƚik'ui pe' witfaakanhei, qa i'nju' pa'aj. Week pekhewe' i'nifi pe' witlijtsitjii qa nite' nitalket'ij in yejeƚju' pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma' qa iyet pa'aj pa' Jesús, qa yit'ij: —Hane'ej ha'ne neƚuji' hats yafits aka' we'nika'ajji' pa'aj ƚepi'ye'eƚik'i.— ");
INSERT INTO mca_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Qa week qi in ƚe'sitsik'i pe' ƚe'lijeyij pa'aj qa yitjuƚaxijpha'mkii iye pekhewe' yit'ij in qi in ƚe'sitsik'i, ma' qa yit'ijju' pa'aj: —¿Me nite' hik ha'ne ha' ƚa's ka' José?— ");
INSERT INTO mca_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma' qa pa' Jesús qa yit'ijji'ju' pa'aj: —Tsikfe'letsha qu' it'iƚij yiwets iye kakha' yi'niyayetsju' qe wenit'ij: “Weihetax meteƚinƚe ete'm. Week kekhewe' k'impiye'eƚij in ƚaqsiiji'kii ha' Capernaum, aqsiiji'kii iye ha'ne etsetiitsija.”— ");
INSERT INTO mca_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Qa yit'ij iye: —Yijaa'ija aka' hit'iƚij ewets in ham pa'qu' ewii'ƚe' profeta qu' qi qu' nineqju'nu qe yamtaxii na'aj ƚetsetitsija. ");
INSERT INTO mca_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Qa yijaa'ija iye aka' qu' hit'iƚij ewets kekhewe' ƚeqe neƚutsji' ka' Elias'ik'i olotstax kekhewe' wikiihaleiyik'i ha'ne Israel, hik aka'aj hik ƚunye'j qu' netit'oiji' na' wa's yamijets wetshetk'ewi'ƚ ininqapits qa ewi'ƚ k'itsje'm, qa qi in iyipkunju' ha'ne week sehe'. ");
INSERT INTO mca_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Qa ka' Elias'ik'i qa nite' ewii'ƚe' pe'qu' net'ukinhetiyii ke' wikiihaleyik'i Israel ƚeiƚekiyik'i, qe t'ukinheti'yii yijat'ij ke' ewi'ƚƚe efu wikiihale' Sarepta ƚeiƚeki', meti'm na' witset Sidón. ");
INSERT INTO mca_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Qa hik ƚunye'j iye ha'ne Israel in olotstax kekhewe' i'nij ka' witja'me't lepra kekhewe' ƚeqe neƚutsji' ka' profeta'ik'i Eliseo. Qa ham pa'qu' ewii'ƚe' qu' nanaxpa'lij kekhewe'en, qe ewi'ƚƚe yijat'ij kakha' Naamán in naxpa'lij, Siria ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Qa week pekhewe' i'nifi pe' witlijtsitjii qa qi in nayu'kii in yepi'ye' ek'i ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Qa niyijupha'mkii pa'aj, qa yukinik'uifik'i pa' witset, qa yeka'xii pa' koomo'oijo' pe' utek, hik pekhe' i'nipji' pa' witset, ma' qekha niwu'mtaxiiju'. ");
INSERT INTO mca_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Qa pa' Jesús qa tetwek'elaxiju'ƚ qa ikji'teje'm pa'aj ƚeqewuk'u, qa ik iye. ");
INSERT INTO mca_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pa' Jesús qa yamii iye pa'aj ha' witset Capernaum, i'ni' na' sehe' Galilea. Qa i'nq'ijatshenji'ij week qa yamji'jets na'aj witwapiihijii (sábado), ");
INSERT INTO mca_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","qa qi qa yitjuƚaxjiijpha'mkii pe' i'nq'ijatshenij qe in iyet hik ƚunye'j na'aj qi qe tenek'enhei. ");
INSERT INTO mca_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Qa na'l pa'aj pe' witlijtsitjiyifi pa' ewi'ƚ jukhew i'nji' pa' ewi'ƚ espíritu uƚ'ax. Pakha'an qa tayai pa'aj qi in t'unik'i in yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Etswejinƚi'iƚ. ¿Ƚekpa' ƚanami'ƚ yijii, Jesús Nazaret ƚeiƚe'? ¿Ye' me hats ƚanami'ƚyii qu' etswuƚ'enheti'ƚju'? Yakha' tsikfe'l ewets pa'n ejunye'j: Akha' eƚ'ewi'ƚƚe in ƚataƚiiha pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pa' Jesús qa yaq'ayinij pa'aj pa' inwo'met, qa yit'ijets: —¡Ewuikitek qa' ma'ak'ui nakha'an!— Qa pa' inwo'met qa niwu'metsju' pa'aj sehe' pa' jukhew ƚeqewuk'uji'ju' pekhewe'en, ma' qa ikik'uifik'i pa'aj, qa nite'ƚe yeqfe'meten. ");
INSERT INTO mca_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Qa week qi in yitjuƚaxijpha'mkii pa'aj, qa yifaakateji', qa yit'ijju': —¿Pa'n ƚunyejei ekewe' wi'tlijei? Qe ekewe'en na'li'm pa' ƚenek'enheye'jipji' qa pa' ƚet'unha'xipji' iye in yukinfik'ikii pe' espíritu uƚ'ets, qa ikfik'ikii.— ");
INSERT INTO mca_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma' qa pa' ƚeniihe't qa weekij in yamipji' pe' metitsi'm witsetits. ");
INSERT INTO mca_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pa' Jesús qa niipha'm pa'aj, ma' qa ikik'uifik'i pa'aj pe' witlijtsitjii, qa iki'ƚii qa uyi'ƚifi pa'aj pe' ƚetsi' ha' Simón. Pe' ƚeqewketi' ha' Simón qi in wanqaats'e' qe qi'ij in iwilhan pa'aj, ma' qa iyinijets pa'aj wete'm pa' Jesús qu' ni'fen. ");
INSERT INTO mca_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pa' Jesús qa t'upi'yetsju' pa'aj pekhe'en qa yaq'ayinij pa' witwilhat, qa pa' witwilhat qa ikik'uifik'i pa'aj pekhe'en. Pekhe'en qa aje'eƚ niipha'm pa'aj ma' qa yithayiki'im pa' ƚaq. ");
INSERT INTO mca_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","In uiju' pa'aj pe' junu', ma' qa tetka'xii pa'aj pa' Jesús week pekhewe' wanqaats'eju' ƚawtshenyejeiƚe wetju'ƚ. Qa t'eku'mipji'kii week pekhewe'en, ma' qa iƚii. ");
INSERT INTO mca_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Qa olots iye pe' ikik'uifik'ikii pe' inwo'metets, qa tayaiji'ij qa yitji'jij: —¡Akha' Ƚaa'sija pa' Dios!— Qa pa' Jesús qa yaq'ayinƚeji'jij, nite' yiwejini'm qu' niyet, qe pekhewe'en nikfe'lets in ƚakhaa'ija pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Qa in hats neƚukii iye pa'aj, pa' Jesús qa ikik'uifik'i pa'aj pa' witset qa ikii pa' ham i'ni'i'. Qa pe' olots jukhew qa efuts iye qa wo'taxiikii pa'aj, ma' qa in yafits'ii pa' i'ni' pa'aj, qa yisu'untax qu' nenyejinju' hats'inha qu'nte' toxi' imets pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Qa pakha'ƚe Jesús qa yit'ijets pa'aj: —Nite' ƚeke' qu' ya'maneƚi'ikii hane'e'in qe les ƚe'wis iye qu' henfeljiimek eke' ƚe'sits wi'tlijei t'ejuyets na' tenek'enheiji' na' Dios nekhewep witsetits, qe hik aka' he'yukinheti'yijetsju' ha'ne sehe' epji'.— ");
INSERT INTO mca_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma' qa ikijik'i in nifel eke' ink'aihits wi'tlijei pe' ƚe'lijtsitjiyits pe' judiol. ");
INSERT INTO mca_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ewi'ƚ pa' neƚuji' pa'aj pa' Jesús in i'ni' ƚotkoyek ke' kaƚi' Genesaret (Galilea). Qa qi in puk'u'uk'ui pa'aj pe' olots jukhew qa efuts iye watkatitij wetepji' qe nexpiikeyu'uj ke' ƚe'lijei pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pa' Jesús qa yi'wen pa'aj pe' wetsjuk witinhitjiyits wo'nophe'ƚi'ju' pa' ƚotkoyek ke' kaƚi'. Ham ineji' qe pe' tenhitjiyii mexe t'ili'tjukii nimpuujinju' pe' ƚeq'ehemkil. ");
INSERT INTO mca_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Qa pa' Jesús t'ilitji'ju' pa'aj pe' ewi'ƚ pekhewe' witinhitjiyits pekhe' ƚenhitjii pa'aj ha' Simón, qa yiyaji'ijets qu' les niwu'mijetsji' pa' akaptax. Ma' qa i'nji'ju' pa'aj pe' witinhitjii, qa iyetik'ui qa yijatshen pe' olots jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","In yili'ij in iyet pa'aj, qa yiyaji'ets pa'aj ha' Simón: —Yape ma'ajiiji' na' les akaptax ene' witinhitjii qa hikna' iwu'mi'ƚi'ju' ne' eq'ehemkili'ƚ hats'inha qu' eq'ehemki'yi'ƚju'.— ");
INSERT INTO mca_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Qa ha' Simón qa yeku'ƚ pa'aj: —Maestro, hats najamet in qi in he'yithayiitaxi'ƚ qa hamƚe yeq'ehemkineli'iƚ. Qa hane'ej qa' heiq'ehemkiyi'ƚju iye qe ƚit'iƚij yiwets.— ");
INSERT INTO mca_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma' qa in hats teq'ehemkiiju' pa'aj, qa olots pe' ƚeq'ehemkinel pa'aj, qa hats k'esik'i pa'aj qu' neniwk'itsinju' pe' ƚeq'ehemkil. ");
INSERT INTO mca_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ma' qa k'es k'ek'es yit'ij pa'aj pe' ƚokoyei in taya'yiikii pa'aj pe' ƚeq'ehemkifetskii i'nji'ju'kii pekhep witinhitjii qe qa' nifenijiiji'. Ma' qa namii pa' i'ni', qa week topolij pe' wetsjuk witinhitjiyits pe' ƚejits. Yaqaamij qu' nuyij. ");
INSERT INTO mca_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","In yi'wen pa'aj aka'an ha' Simón Pedro, qa wonokok'enifi pa'aj pa' Jesús, qa yit'ijets: —Me'niton ye'mets, Yatsat'axyij, qe yakha' qi in yuƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Qe ha' Simón qa week iye pekhewep ƚenhifetsji' qi in niju's pa'aj in olots wiikfik'i pe' ƚejits ƚeq'ehemkinel. ");
INSERT INTO mca_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Qa hik ƚunyejei iye pa'aj pakha' ƚunyejei pekhewe'en ha' Jacobo (Santiago) qa ha' Juan, ƚelits pa' Zebedeo, hik enewe' ƚeq'ehemkifetskii pa'aj ha' Simón. Qa pa' Jesús qa yit'ijets pa'aj ha' Simón: —Hasu'uj e'nijiwei. Hane'ej qa' eq'ehemki'yii ene' jukhew qa efuts iye.— ");
INSERT INTO mca_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma' qa in hats yamijetspha'mkii pa' ƚ'isƚa'wet pe' witinhitjiyits, qa hikpa' yiwu'mi' pe' week, ma' qa yijayan pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ewi'ƚ pa' neƚu pa'aj pa' Jesús in i'ni' pa'aj pa' ewi'ƚ witset, qa namii pa'aj pa' ewi'ƚ jukhew wanqaats'e' weekij pa' ƚ'aj in i'nij pa' witja'me't lepra. Pa' jukhew in yi'wen pa'aj pa' Jesús, qa wonokok'enju' yamitetsju'ha pa'aj ƚotkoyek pa' sehe', qa iyinets: —Yatsat'axyij qu' isu'un, qa' ƚeke'ye' qu' enli'j ye'mju' ha'ne yawtshek.— ");
INSERT INTO mca_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pa' Jesús qa yijin pa' ƚokoi qa t'eku'mets, qa yit'ijets: —Ehe, hisu'un. ¡Hane'ejija qu' etetli'jju'!— Qa hik pakhaa'ijha qa naxpa'lij pa' ƚaatshektax pa' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pa' Jesús qa yiyajitaxetskii pa'aj, qa yittaxijets: —Hasu'uj enfeli'm pe'ye'. Maƚi'ii qa' menethinets pa'qu' pa'iye'. Qa' eyijii pa'qu' eqisit'e (ofrenda) qu' net'ejuyets in hats ƚetetlijju' qe hikka' inaqyaji'ij pa'aj ka' Moises'ik'i, hats'inha qa week nenikfe'lets in hats ƚanaxpa'lijha ka' aja'me'ttax.— ");
INSERT INTO mca_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Qa week neƚuts les qi in te'niihei pa'aj pa' Jesús. Ma' qa olootsija pa'aj pekhewe' namiikii qe qa' nepi'ye'ija qa qu' nihaminheti'miikii iye pe' ƚaatsheitax. ");
INSERT INTO mca_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Qa pa' Jesús qa ikji'jii pa' ham i'ni'i' qu' niyinji'ij. ");
INSERT INTO mca_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ewi'ƚ pa'aj pa' neƚu pa' Jesús in yijatshen pe' jukhew qa efuts iye, i'nji'teje'm iye pe' uja'x fariseol qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei ta'ƚiikii pe' week witsetits Galilea qa pa' Judea, qa ha' Jerusalén iye. Qa pa' ƚet'unha'x pa' Yatsat'ax'inij Dios qa i'nji'teje'm pa' Jesús qe qa' ninqiƚinijkii. ");
INSERT INTO mca_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma' qa namii pa'aj pe' uja'x jukhew nekaxij pa' witiwhi'la'x pa' ewi'ƚ jukhew onqok nite' p'e's. Qa yisu'untax qu' neka'xetsji' pa' i'ni' pa' Jesús pe' wititsi'ifi. ");
INSERT INTO mca_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Qa hamƚe ƚ'ikheyi'ji'ij pa'aj qe olots pe' jukhew qa efuts iye. Ma' qa weƚijipji' pe' wititsi' qa yitju'etsju' pa' wankaajuƚiju'. Qa hikpa' yuihinijii pa' ƚewhi'la'x pa' wanqaats'e'. Qa yetshenetsju' pa' ƚeqewuk'uji'ju' pe' jukhew pa' ƚ'ejuyi'jii pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pa' Jesús in yi'wen pa'aj pekhewe'en in nite' yeqeku', qa yit'ijets pa'aj pa' wanqaats'e': —Jukhew, pe' ewuƚ'ets hats tewu'mhitii'ek'ui.— ");
INSERT INTO mca_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma' qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pe' fariseol iye qa yapeƚek pa'aj in yijamti'ets, qa yit'ijju': —¿Pa'n ƚunye'j ha'ne t'ejuyiju'ƚ pa' Dios kekhewe' yit'ij? ¿Pa'n ƚii pa'qu' ƚeke'ye' qu' niwu'm pe' witwuƚ'ets? Ewi'ƚƚe inek pa' Dios qu' niwu'm.— ");
INSERT INTO mca_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Qa pa' Jesús hatsƚe nikfe'lets pe' ƚaqjamtikineyejeikii pekhewe'en, qa yeku'ƚ pa'aj: —¿Inhats'ek pe' atawjetsi'ƚ in yijamti'ets qu' hik aka' ƚunye'je'? ");
INSERT INTO mca_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Pa'n ƚunye'j pa'qu' les nite' jutsitaxe' qu' jintit'ij: “Me pe' ewuƚ'ets hats tewu'mhitii ek'ui,” me i'nƚi'i qu' jintit'ijets “eniipha'm qa' ma”? ");
INSERT INTO mca_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Qa qu' enikfe'li'ƚets hane'ej ha'ne Ƚa's na' Jukhew in na'li'm na' ƚet'unha'xijup ha'ne sehe' ipji' qe qa' niwu'm pe' witwuƚ'ets.— Ma' qa yiyaji'etsju' pa' onqok: —Akha' hit'ij ewets, eniipha'm, ku'mi' na' ewhi'la'x qa mapilii pe' etsi'.— ");
INSERT INTO mca_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Qa hik pakhaa'ijha pa' wanqaats'e' qa niipha'm pa'aj qa week yi'wenij pekhewe'en, qa t'eku'mi' pa' ƚewhi'la'x, qa wapilii pe' ƚetsi' qi in yiwqinhetji' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Qa qi in yitjuƚaxijpha'mkii pa'aj pe' week qa yiwqinhetji' iye pa' Dios, ma' qa qi in nijiwei pa'aj, qa yit'ijju': —Ha'ne neƚuji' ham ƚunyejeyi'iju'ƚ ekewe' jite'wen.— ");
INSERT INTO mca_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","In yili'ij pa'aj ekewe'en pa' Jesús qa ikik'uifik'i pe' wititsi', qa yi'wen pa'aj pa' ewi'ƚ pe' yijaninkii pe' wekwek t'ejuyets pa' witset Roma, ƚii Leví (Mateo). I'nju' i'nifi pe' wititsi' pa' i'niji'kii in yijaninkii pe' wekwek. Pa' Jesús qa yit'ijets pa'aj: —Atsjayan.— ");
INSERT INTO mca_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pakha'an qa niipha'm pa'aj, qa yiwu'mƚi'i pe' week ƚ'ithayijkititstax qa yijayan pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma' qa i'nk'aƚe pa'aj pa' Leví qa yaqsiimijkii pa' Jesús pa' ewi'ƚ qi ƚekujii pe' ƚetsi'ii, qa olots iye pekhewep yijaninkii pe' wekwek qa pekhewep iye jukhew in ƚekufetsij pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Qa pe' fariseol qa pekhewep iye fariseol pekhewe' ƚeq'ikanenheyijji' ke' Moisés ƚe'lijei, qa iyettaxijets pa'aj he' Jesús ƚ'ijatshenhei: —¿Inhats'ek in ekufetsi'ƚij qa iyafetsi'ƚij iye ne' yijaninkii wekwek qa ne' qi iye pa' ƚewuƚ'ax?— ");
INSERT INTO mca_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pa' Jesús qa yeku'ƚik'i pa'aj aka'an, qa yit'ij: —Ne'ej ham yaats'eyi'iju' nite' wo'oikii pa'qu' weihetaxe' witeqjunhetits ƚeiƚe'ye', qe uja'xƚe yijat'ij ne'ej wanqaats'eju' qa wo'oikii na'aj weihetax witeqjunhetits ƚeiƚe'. ");
INSERT INTO mca_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nite' tsamijju' ma' qa' haiya'yii ne' yatsathen, qe tsamijju' yijat'ij ma' qa' haiya'yii ne' uƚ'ets hats'inha qu' nili'ij pe' uƚ'ets in yaqsiijkii qa ni'nk'aihit pe' ƚatawjets.— ");
INSERT INTO mca_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma' qa titijiti'yijets pa'aj pa' Jesús: —He' ƚ'ijatshenhei ka' Juan Bautista yaqsi'j jiijkii qa'nte' tekji'ijju' qa iyiinjiija iye, qa ne' fariseol ƚ'ijatshenhei iye qa hik kakha' ƚunyejei iye, qa nekhewe'ƚe ijatshenhei qa nite' les qu' nili'ij in tek qa iya' iye.— ");
INSERT INTO mca_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Qa pa' Jesús qa yeku'ƚ pa'aj, qa yit'ij: —¿Me ƚeke' ekheweli'ƚ qu' nite' ekunheni'iƚ pe'qu' nanamii pa'qu' witiwhe'yejiye' in mexe i'nji'teje'm pa' niwhe'yeyu' pekhewe'en? ");
INSERT INTO mca_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yamets hatse' pa' neƚuji' qu' newetkax pa' niwhe'yeyu', ma' qa hayitse' yijat'ij qu'nte' neteke'ju' pekhewe' neƚutsji' hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Qa nifeli'm iye pa' ewi'ƚ yejeyumtshenijupi' qu' ƚunye'je': —Ham pa'qu' niwjaf'itets ƚepk'eye'en pa'qu' ink'ayik'e witqhinawat'e ma' qa' nok'oyinij pa'qu' hats ƚawa'ma'xe' witqhinawat, qe qu' hik aka' ƚeqfenye'ji'ij ma' qa yiwuƚ'enhetƚe pa' ink'ayiktax, qa pa' ƚok'opƚe' pa' ink'ayik qa les yiwuƚ'enhet pa' ƚawa'ma'x. ");
INSERT INTO mca_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nite' ƚeke' iye qu' ne'nenji' pa'qu' ink'ayik'e winoye' pe'qu' ƚawa'mhitse' eƚi'nil inqa'met ƚ'ajits, qe pa'qu' ink'ayik'e winoye' ja'fijje'm ma' qa' week hamitse' pa'qu' winoyi'ik'i qa pe'qu' eƚi'nili'ik'i inqa'met ƚ'ajits. ");
INSERT INTO mca_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma' qa hik ta'ƚijupi' qu' eni'ƚji' yijat'ij pa'qu' ink'ayik'e winoye' qa pe'qu' ink'aiki'ye' iye ƚ'aje' eƚi'niye', hats'inha qa' week ƚunyejeyi'iƚ yijat'ij. ");
INSERT INTO mca_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Qa ham iye pa'qu' niya'ji' pa'qu' ƚawa'maxe'ji' winoye' qa' i'nk'aƚe qa' ne'niyayuji' iye pa'qu' ink'ayik'e winoye', qe yit'ij: “Ka' ƚawa'maxji' hik kakha' in les yimax.”— ");
INSERT INTO mca_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yamets pa'aj pa' neƚuji' witwapiihijii (sábado), pa' Jesús in ikji'teje'm pe' wit'enheiju' qa pe' ƚ'ijatshenhei qa teyijkii in nit'ijji' pe' ƚei trigo (fooji'ij), qa yit'iji' ƚokoyei in yosja' qa namju'kii pe' ƚ'ajits qa tuj pe' ƚoi. ");
INSERT INTO mca_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma' qa pe' uja'x fariseol qa yit'ijets pa'aj: —¿Inhats'ek in ƚaqsiiƚijkii kakha' nite' ƚenexke'ej qu' nanaqsiijkii na'aj witwapiihijiiji' (sábado)?— ");
INSERT INTO mca_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Qa yeku'ƚiju'ƚ pa'aj pa' Jesús: —¿Ye' me nite' ƚejeƚi'ƚ iye qu' iyineni'ƚik'i kakha' yaqsiijkii ka' David'ik'i in qi in iyipkun? Kakha'an qa week iye ke' ƚijts'eyekkii, ");
INSERT INTO mca_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","in uyetsji' pa'aj pe' t'ejutshenheti'yets na' Dios qa t'eku'mi' qa tuj pe' pan testiitaxij na' Dios, ma' qa tisijets iye pe' ƚijts'eyek ma' qa week tuji'ƚ pa'aj pekhewe' nite' ƚenexketaxij pa'qu' netuj, qe uja'xƚe yijat'ij pe' pa'il in ƚenexkeliji'm qu' netuj.— ");
INSERT INTO mca_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Qa yit'ij iye pa'aj: —Ha'ne Ƚa's na' Jukhew tenek'enhe'yipji' na' neƚu witwapiihijii (sábado).— ");
INSERT INTO mca_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ewi'ƚ iye pa'aj pa' neƚuji' witwapiihijii (sábado), pa' Jesús qa uyifi iye pa'aj pe' witlijtsitjii qa i'nq'ijatshen pa'aj, qa hik pekhe' qa i'nifi iye pa'aj pa' ewi'ƚ jukhew yisƚax pa' yiya'yik'i ƚokoyik'i. ");
INSERT INTO mca_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pe' fariseol iye qa ts'in pa'aj in yejeƚijju' pa' Jesús me yiƚin tu'u in mexe witwapiihijiitax (sábado), qe wo'taxiikii pa'qu' nit'ijets qu' uƚ'axe' in yaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pa' Jesús qa hatsƚe nikfe'lets pa'aj aka' yijamti'ets pekhewe'en qa yit'ijets pa'aj pa' jukhew yisƚax pa' ƚokoyik'i: —Eniipha'm qa' te'ƚun hane'e'in.— Pa' jukhew qa niipha'm pa'aj qa ikii. ");
INSERT INTO mca_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pa' Jesús qa yit'ijji'ju' pa'aj pekhewe'en: —Hisu'un qu' k'afaakani'ƚ: ¿Ƚekpa' ƚenexke'ej qu' jintaqsiijkii pa'qu' neƚuyeji' in witwapiihijii? ¿Me pa' ƚe'wis me i'nƚi'i pa' uƚ'ax? ¿Me jitiƚin pakhape'? ¿Me i'nƚi'i qu' jintewuƚ'enhetju'?— ");
INSERT INTO mca_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma' qa yejeƚ ji'teje'm pa'aj pe' week, qa i'nk'aƚe qa yit'ijets pa'aj pa' jukhew: —¡Ijin na' okoi!— Qa pa' jukhew qa yijin pa'aj pa' ƚokoi. Ma' qa hik pakhaa'ijha pa'aj in hats ƚe'wisju' pa' ƚokoi. ");
INSERT INTO mca_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Qa pekhewe'ƚe'en qa qi in nayu'kii pa'aj, ma' qa tafaakateitaxijju' pa'qu' ƚeqfenyejeyi'ij pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hik pekhewe' pe' neƚutsji' pa'aj pa' Jesús in ikii pe' utek qa niyini'. Qa najamet pa'aj in i'ni' iyinii pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ma' qa neƚukii pa'aj qa taya'yets pe' week ƚ'ijatshenhei qa t'eku'miiji'kii pe' doce (12) jukhew, qa hik pekhewe' qa ƚenqiyits apóstoles. ");
INSERT INTO mca_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Enewe'en ƚiyits: Simón hikha' ƚeqiyij Pedro qa ha' ƚek'inijƚe Andrés, Jacob (Santiago) qa ha' Juan, Felipe qa ha' Bartolomé, ");
INSERT INTO mca_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo qa ha' Tomás, Jacobo (Santiago) hikha' ƚa'sek pa' Alfeo qa ha' Simón ƚenqii iye Zelote, ");
INSERT INTO mca_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas hikha' ƚa'sek pakha' ƚii Jacobo (Santiago) qa pa' Judas Iscariote, hik pakha' wotk'onijkii pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pa' Jesús qa tepilik'uiju' pa'aj pe' utek ƚijts'eyekju' pa'aj pekhewe'en qa nametsju' pa' ƚe'wisju' sehe' qa hikpa' tekeleni'ju', qa hik pakha' i'ni' pa'aj pe' olootsija ƚ'ijatshenhei qa pekhewep iye qa les olootsija iye pe' pekhel ta'ƚji'kii na' sehe' Judea, na' Jerusalén qa week pekhewe' ta'ƚiikii pe' ƚekuwelii pa' qi iweli' hik pakha' i'ni' iye pe' witsetits Tiro qa Sidón. ");
INSERT INTO mca_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pekhewe'en namii qe nexpiikeyu'uj qa namijii iye qu' nanpaliti'mju' pe' ƚawtshei wetju'ƚkii. Qa pekhewe' yawtshetenkii pekhewe' uƚ'ets espíritus qa iƚii iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Qa week iye pa'aj in yisu'untax qu' net'eku'mets pa' Jesús, qe pakha'an ta'ƚji'teje'm pa' ewi'ƚ qi witt'unha'x qa yiƚin pe' week. ");
INSERT INTO mca_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pa' Jesús qa yejeƚipji' iye pa'aj pe' ƚ'ijatshenhei, qa yit'ij: —E'ƚe'sitsi'iƚi'mkii ekheweli'ƚ in if'iljetsitsi'ƚ, qe ekheweli'ƚ hats ƚa'ni'ƚ ji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","E'ƚe'sitsi'iƚi'mkii pekhewe' qu' hane'ej niyipkuntaxju', qe ekheweli'ƚ hats ƚ'iƚini'ƚju' hatse'. E'ƚe'sitsi'iƚi'mkii ekheweli'ƚ pe'qu' hane'ej napju', qe ƚ'ijuye'eƚju' hatse'. ");
INSERT INTO mca_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","E'ƚe'sitsi'iƚi'mkii ekheweli'ƚ qu' qi qu' i'napjaxtaxi'ƚ, qa qu' ewutshenheti'yi'ƚfik'i iye. Qa qu' uƚ'etsi'ik'i pe'qu' ene'lijeyi'iƚ qa qu' netutenhetii iye pa'qu' iyi'iƚ hik ƚunye'j qu' wekwek ƚiye' qe ta'ƚijupi' in ƚijayani'ƚ ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Qa hik pakha' pa' neƚuji' e'ƚe'sitsi'iƚi'mkii ilit'iƚijpha'mkii qu' e'ƚe'sitsi'iƚi'mkii, qe nakha' enisit'iƚ qi'ija i'ni' na' wa'sji'. Qe hik ƚunyejei iye ke' ƚaqa'jteyik'i in hik ƚeqfenyejeyij iye kekhewe' profetas'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Qa hiyee' e'newusitsi'ƚ ekheweli'ƚ yiwq'axin wekwek, qe hane'ej hats ƚ'estiyiƚij in e'ƚe'sitsi'ƚi'mkii. ");
INSERT INTO mca_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hiyee' e'newusitsi'ƚ ekheweli'ƚ pekhewe' hane'ej iƚinju', qe ekheweli'ƚ qi qu' iyipkuni'ƚju' hatse'. Hiyee' e'newusitsi'ƚ ekheweli'ƚ pekhewe' hane'ej qi in ijuyeju', qe qi qu' ika'metetsi'ƚkii hatse' qa qi iye qu' mapi'ƚju'. ");
INSERT INTO mca_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hiyee' e'newusitsi'ƚ ekheweli'ƚ, in nesu'uni'ƚ qa ƚe'sitsik'i iye ƚe'lijeyi'ƚ ej ene' week, qe hik aka' ƚunyejeyij iye ke' aqa'jteyi'ƚik'i kekhewe' yit'ij ƚetets qu' profetaye'.— ");
INSERT INTO mca_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Qa ekheweli'ƚ pekhewe' qu' nespi'ye', qa hit'iƚij ewets: Isu'uni'ƚ pe'qu' ejuihifetsetaxi'ƚ, aqsi'ji'ƚi'mijkii pa'qu' ƚe'wise' pekhewe' qu' na'napjaxtaxi'ƚ e'm. ");
INSERT INTO mca_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ƚe'sits e'lijeyi'iƚets pekhewe' qu' uƚ'ets ƚe'lijeyetaxi'ƚ ewetskii qa' iyini'ƚipji'kii iye pekhewe' qu' nawitjitaxi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Qu' nana'l pa'qu' nilanje'm ewi'ƚe' ne' ekukii qa' ƚisijets iye ni'khep qu' nilanje'm iye. Qa qu' nana'l pa'qu' netka'mij pa'qu' e'ntilafit'e qa' iwejinƚi'ij, qa qu' nisu'un iye qu' neka'x pa'qu' uihitjiye' qa' ƚisij iye qu' neka'x. ");
INSERT INTO mca_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Week pa'qu' niyinij ewets pe'ye', qa' ƚisij, qa pa'qu' netka'mij pa'qu' antsat'axij, qa' hasu'uj iyinijets qu' nenpilet ewets iye. ");
INSERT INTO mca_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Qa pa'qu' isu'uni'ƚ qu' naqsi'ji'ƚ e'mijkii pekhewepe', qa' hik pakha' qu' aqsi'ji'ƚi'mijkii. ");
INSERT INTO mca_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Qu' uja'xe'ƚetax qu' isu'uni'ƚ pekhewe' qu' nesu'uni'ƚ, ¿me qa hats pakha' ejunyejeyi'ƚ? Qe nekhewe' mexe na'l pe' ƚewuƚ'ets hik ƚunyejei iye aka'an uja'xƚe in yisu'un pekhewe' qu' nisu'un nekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Qu' uja'xe'ƚetax qu' aqsi'ji'ƚi'mijkii pa'qu' ƚe'wise' pekhewe' qu' ƚe'wise' pa'qu' naqsi'ji'ƚ e'mijkii, ¿me qa pakha' ejunyejeyi'ƚ iye? Qe hik aka' iye yaqsiijkii nekhewe' mexe na'l pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Qa qu' uja'xe'ƚetax qu' anatkinheni'ƚets pe'ye' pekhewe' qu' umti'iƚ qu' nenpileti'ƚ ewets iye, ¿me qa pakha' ejunyejeyi'ƚ iye? Qe hik aka' ƚeqfenyejei ƚewek iye ene' mexe na'l pe' ƚewuƚ'ets in yatkinhenetskii pekhewep iye na'l pe' ƚewuƚ'ets, qe qa' nijanin pakha' hats uja'x pe' tanatkinhe'yij. ");
INSERT INTO mca_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aka' yijat'ij ejunyejeyi'iƚ, isu'uni'ƚ pekhewe' qu' ejuihifetsetaxi'ƚ, ƚe'wis pa'qu' aqsiiƚi'mijkii, ƚisi'ƚij qu' nanatkinheyu'uƚ ewets qa hasu'uj onotki'iƚiikii qu' nenpileti'ƚ ewets iye. Ma' qa pa'qu' enisit'i'iƚ qa' qiye', qa' ninikfe'l iye in ƚelitsiƚ'ejha na' Dios toxpha'm, qe nakha'an qi in neq'eletij iye nekhewe' nite' t'esiji'yij na'aj tistaxij qa uƚ'ets iye. ");
INSERT INTO mca_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Les ƚe'wis qu' eq'iltinhetsi'iƚ in ƚunye'jek na' Atata'aƚ in qi in eq'iltinhetsax.— ");
INSERT INTO mca_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Hasu'uj it'iƚijets qu' uƚ'etse' pekhewepe' hats'inha qa'nte' jeek nenit'i'iƚij ewets qu' uƚ'etsi'iƚ. Hasu'uj it'iƚijets qu' les ƚe'wise' qu' nattanithenhetii pakhape', hats'inha qa'nte' jeek nenit'i'iƚij ewets qu' les ƚe'wise' qu' atanithenheti'yi'ƚ. Iwejinƚi'iƚ pekhewe' qu' naqsi'jtaxi'ƚ e'mijkii pa'qu' uƚ'axe', hats'inha qu' niwu'mjii'ƚ ek'uyek pa' Intata pe' ewuƚ'etsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ƚisƚi'iƚij pa'qu' hami'im pekhewepe' qa na' Dios qa' hikna' qu' nata'ƚets qu' les olotse' pe'qu' esti'yi'ƚij. Yoponhetij pa'qu' eqe ti'naje' qa' naqat'etijik'iju' iye qa' naqfiijik'iju' iye qa qi qu' tsektsek'i'ijha, qe pakha' ƚuk'e' pa' eqe ti'najij pekhewe' ƚ'ihinij qa' hik ƚuk'eyeji'jek pa'qu' ti'naje' pe'qu' esti'yij.— ");
INSERT INTO mca_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pa' Jesús qa yeni' pa' ewi'ƚ yejeyumtshenijupi', qa yit'ij: —¿Me ƚeke' pa'qu' puk'ale' qu' nojo'ok'oi pakhape' iye puk'ale'? ¿Me nite' week qu' nanamik'iju' pe'qu' witijkiye'? ");
INSERT INTO mca_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ham pa'qu' ewi'ƚe' wit'ijatshenek'e qu' nat'anipji' pa'qu' ƚaqa maestroye', qa qu' nanq'axiji'pji' pekhewe' qu' net'ijatshenhetiyij ma' qa hik ƚunye'je' pa'qu' ƚaqa maestroye'. ");
INSERT INTO mca_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Qa inhats'ek in ƚenjusij na' ejefe in i'nji' ƚoto' na' jup'el qa akha' qa nite' ƚetetju'sij in i'nji' ne' oto' na' qi'ik'i najak? ");
INSERT INTO mca_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Qa pa'n ƚunye'j qu' it'ijets na' ejefe: “Yejefe, etswejinij qu' hiwu'm ek'ui na' jup'el i'nji' ne' oto'” in akha' nite' ƚi'wenetsju' na' qi'ik'i najak i'nji' ne' oto'? ¡E'jtitsaxƚe hik ejunye'j qu' wetsjuk'e ejusitse'! Ojo'oj yijat'ij qu' iwu'm na' qi'ik'i najak i'nji' ne' oto' ma' qa' i'wenetsju' yijat'ij qu' iwu'mik'ui na' jup'el i'nji' ne' ƚoto' na' ejefe.— ");
INSERT INTO mca_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Qe ham pe'qu' najkak'e qu' ƚe'wise' qa' uƚ'etse' pe'qu' ƚeye'. Qa pe'qu' uƚ'ax najkak'e qa nite' ƚeke' qu' ƚe'sitse' pe'qu' ƚeye'. ");
INSERT INTO mca_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Week ene' najkakui jutsiqetsij ne'ej ƚei. Nite' ƚeke' qu' nata'ƚets ne'ej higo pe'qu' ti'ye'. Nite' ƚeke' iye qu' nata'ƚets iye ne'ej uwa pe'qu' newekitetse'. ");
INSERT INTO mca_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na'aj ƚe'wis ene' jukhew qa efuts iye, qa yit'ij pe' wekwek ƚe'sits qa pa'qu' ƚunye'je' iye ƚe'wis, qe ta'ƚiiju' pa' ƚatawe'j in ƚe'wis. Qa na'aj uƚ'ax ene' jukhew qa efuts iye, qa yit'ij pe' wekwek uƚ'ets qa pa'qu' ƚunye'je' iye uƚ'ax, qe ta'ƚiiju' pa' ƚatawe'j in uƚ'ax, qe pa' topo'oj pa' ƚatawe'j qa hikpa' nekii ƚeji'.— ");
INSERT INTO mca_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—¿Qa inhats'ek in ƚit'iƚij yiwets, “Yatsat'axyij, Yatsat'axyij,” qa nite' ƚaqsiiƚijkii na'aj hi'ttaxi'ƚij ewets? ");
INSERT INTO mca_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hane'ej qa' henfeli'ƚ e'm aka' ewi'ƚ hik ƚunye'j pakha' qu' nenek yiwets qa tsepi'ye' iye qa yaqsiijkii pa'qu' hit'ij. ");
INSERT INTO mca_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hik ƚunye'j pa'qu' ewi'ƚ jukhewe' in yaqsiijkii pe'qu' ƚetsi'ye'. Yojo in ti'jik'ui qa yakaptinik'ui. Qa yamiiju' pa' t'un sehe'. Qa hikpa' qa yaqsi'jipji' pe' ƚextuk'ij. Qa qitax pa'qu' haqqi'ye' qa ikifi qa qi in t'unik'i pa' iweli' qa pe' ƚeqe t'uyuyuyits qa yeqsilanje'mkii pe' wititsi', qa nite'ƚe nopƚetju' qe yijanit'ax in we'nithayiki. ");
INSERT INTO mca_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qa pa'qu' nespi'ye'tax qa nite'ƚe yaqsiijkii pa'qu' hit'ij, qa hik ƚunye'j pa'qu' ewi'ƚe' jukhew in yaqsiijkii pe'qu' ƚetsi'ye'. Qa yenƚi'ipji' pa' sehe' nite' t'un qa ham ƚextuk'i'ij. Qa qi pa'qu' haqqi'ye' qa ikifi qa qi iye in t'unik'i pa' iweli', ma' qa pe' ƚeqe t'uyuyits qa yeqsilanje'mkii pe' wititsi', ma' qa aje'eƚ nopƚetju' qa week yiwuƚ'enhet.— ");
INSERT INTO mca_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pa' Jesús in yili'ij pa'aj in iyetik'ui pe' jukhew qa efuts iye, ma' qa ik pa'aj qu' namii ha' Capernaum. ");
INSERT INTO mca_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hikha' qa i'ni' pa'aj pa' ewi'ƚ qi wanqaats'e' hats niwamhiyu' ƚeqejkunenek pa' ewi'ƚ centurión, hik pakha' qi in yisu'un pa'aj in ƚeqejkunenek. ");
INSERT INTO mca_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pa' centurión in yepi'ye' pa'aj in tenifaakateji' pa' Jesús, ma' qa yukinii pa'aj pe' uja'x pekhewe' tenek'enhei judiol qu' niyinijets qu' nanamii qa' niƚini'm pa' ƚeqejkunenek pakha'an. ");
INSERT INTO mca_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pekhewe'en in yamii pa'aj pa' Jesús, qa qi in iyinijets pa'aj, qa yit'ijets: —Ha' centurión les ƚe'wistax qek iftits'ets wat'ij ");
INSERT INTO mca_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","qe hakha'an hik hakha' qi in yisu'un ha'ne initset. Qa hikha' iye inqaqsijkinenijkii ke' yilijtsitjiyi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pa' Jesús qa yijayan pa'aj pekhewe'en. Qa in hats metitsi'm pe' ƚetsi' pa' centurión qa aje'eƚ nukiniju'ƚ pe' uja'x pe' ƚejuwaikal qu' nit'ijets: —Yatsat'axyij, yape hasu'uj me'nithayi'metenƚekii, qe nite' ye'weju'ƚiju'ƚ qu' uyifi ene' yitsi'. ");
INSERT INTO mca_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Qa hik ta'ƚijupi' in nite' yakha'ija iye qu' henek eju'ƚ, itƚi'ij pa'qu' e'lijeye', qa na' yeqejkunene'k qa' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Qe yakha' iye na'l ne' tenek'enhe'yipji', qa yakha' iye qa na'l ye'm ne' heinek'enhe'yipji' ek oq'opheƚinetsilets, qe hit'ijets na'aj ewi'ƚ, “Ma”, ma' qa ik. Qa qe hit'ijets iye nikhapij, “Te'ƚun”, ma' qa nek iye. Qa na'aj hiyaji'ijets ha'ne yeqejkunene'k qu' naqsiijkii, qa yaqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pa' Jesús in yepi'ye' ek'i pa'aj aka'an, ma' qa qi in yitjuƚaxijpha'm pa'aj. Qa tetwek'elaxiju'ƚ pa'aj pe' olots nijayanik'i, qa yit'ijji'ju' pa'aj: —Yijaa'ija aka' hit'iƚij ewets, in hami' iye ha'ne week Israel pa'qu' hi'weni' qu' hik ƚunye'je' ha'ne jukhew in qi in nite' inqeku'.— ");
INSERT INTO mca_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","In wapiltaxii iye pe' wititsi' pekhewe' wit'ukinhei, qa yi'wen pa'aj pa' witqejkunenek in hats t'un. ");
INSERT INTO mca_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Qa in hats ƚ'anu'upji' iye pa'aj ekewe'en, pa' Jesús qa ik iye qa yamii pa' ewi'ƚ witset ƚii Naín. Qa ƚijts'eyek pa'aj he' ƚ'ijatshenhei qa olootsija iye pekhewep iye. ");
INSERT INTO mca_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma' qa in hats k'esitsiyu'etsha pa'aj pa' ƚeji' pa' witset, qa weikutijiju'ƚ pe' yeka'x qu' netijik'ui pa' ewi'ƚ wa'm pa'aj, ewi'ƚƚi'i' in ƚa's pe' efu qa wikiihale' iye. Olots iye pa'aj pe' nijayanik'i tetseti'yi' pa' witset. ");
INSERT INTO mca_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pa' Yatsat'ax'inij in yi'wen pa'aj pe' efu qa qi in neq'eletij pa'aj, ma' qa yit'ijets pa'aj: —Mapkitek.— ");
INSERT INTO mca_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ma' qa ikets pa'aj pe' ƚejiiki' pa' wa'm ham ƚit'oye' qa t'eku'mets, qa pe' yeka'x qa tekelenijju'kii pa'aj. Pa' Jesús qa yit'ijetsju' pa' wa'mtax: —Jutjana'x, akha' hit'ij ewets. ¡Eniipha'm!— ");
INSERT INTO mca_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma' qa pa' wa'mtax qa niipha'm pa'aj qa i'nju', qa iyet pa'aj. Qa pa' Jesús qa tisij pa'aj pe' ƚefti'. ");
INSERT INTO mca_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","In yi'wen pa'aj aka' ƚunye'jkii ma' qa week in qi in nijiwei pa'aj. Qa yiwqinhetji'ha pa'aj pa' Dios. Qa yit'ijju' pekhewe'en: —Hats nam inwets ha'ne qi profeta.— Qa yit'ijju' iye pekhewe'en: —Pa' Dios hats nametsju' ha'ne ƚetset qu' ni'fen.— ");
INSERT INTO mca_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Weekij pa' sehe' Judea qa pe' ƚekuweliikii iye witsetits in i'ye'ej wetju'ƚ pa' yaqsiijkii pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pe' ƚ'ijatshenhei pa' Juan Bautista qa nifelimik'i pa'aj week ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Qa pa' Juan qa taya'yets pa'aj pe' wetsjuk pekhewe' ƚ'ijatshenhei, qa yukinii pa'aj pa' Yatsat'ax'inij, qu' nanfaakanijha pa'aj, qa' nit'ijets: —¿Me hik akha' pakha' hats jutsiqaxik'ui qu' nanam, me i'nƚi'i qu' honotki'iƚik'ui pakhape' iye?— ");
INSERT INTO mca_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pe' jukhew in hats yamii pa'aj pa' Jesús, qa yit'ijets pa'aj: —Ha' Juan Bautista ts'ukini'ƚ ei, qa yit'ij ei: “¿Me hik akha' pa' hats jutsiqaxik'ui qu' nanam? ¿Me i'nƚi'i qu' honotki'iƚik'ui pakhape' iye?”— ");
INSERT INTO mca_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","In i'nk'a namets pa'aj pekhewe'en qa hik pakhaa'ijha pa'aj pa' Jesús in niƚinju' pe' olots pekhewe' taja'meteiju' qa pe' pekhel yaats'e'eju'kii, qa pe' i'ntaxji' pe' espíritu uƚ'ets qa yi'wenkitkii iye pe' puk'aletstax. ");
INSERT INTO mca_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pa' Jesús qa yeku'ƚ pa'aj, qa yit'ijets: —Yape mapiliƚii ha' Juan Bautista qa' enfeli'ƚi'm aka' ƚi'weni'ƚ qa aka' ƚepi'ye'eƚik'i iye. Enfeli'ƚi'm ene' puk'aletstax qa hats yi'wenkii, ene' onqokitstax qa hats t'otsjo' qa ene' otshimetetstaxju' qa hats otshimetsitsju' iye, enewe' i'nij ka' witja'met lepra qa hats naxpa'lij iye, ene' nite' yepi'ye'taxkii qa hats yepi'ye'kii, hekhewe' hats naxtaxju' qa iƚii iye, qa enewe' if'iljetsits qa tefelhiti'yi'm eke' wi'tlijei t'ejuyets na' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Qa ƚe'wisi'mkii pakha' qu' nite' na'nayu'ye' yi'ij ye'm pe'ye'.— ");
INSERT INTO mca_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","In hats ikkii pa'aj pekhewe' ƚ'ukinhei pa' Juan Bautista, qa pa' Jesús qa iyetik'ui pa'aj pe' jukhew qa efuts in t'ejuyets pa' Juan Bautista, qa yit'ij pa'aj: —¿Ƚekpa' ƚami'ƚijii pa'aj qu' i'weni'ƚi' ha' ham i'ni'i'? ¿Me fapuk pe'qu' nime'lejit pa'qu' t'uni'ik'i? ");
INSERT INTO mca_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Qa qu' nite'ye', ¿ƚekpa' ƚami'ƚijii qu' i'weni'ƚ? ¿Me ewi'ƚ pa'qu' jukhewe' qu' neqhinataji' pe'qu' inyetetse' witqhinatai? Ekheweli'ƚ ƚenikfe'li'ƚets nekhewe' yeqhinataji' ke' ƚe'sits qa inyetets iye, qa qi iye in ƚe'sitsju' in ham hamitsi'im qa i'nifi nekhewe' ƚetsil ne' wittatal. ");
INSERT INTO mca_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Qa qu' nite'ye', ¿ƚekpa' ƚami'ƚii qu' i'weni'ƚ? ¿Me ewi'ƚ pa'qu' profetaye'? Ehe, yijaa'ija in ewi'ƚ profeta, qa lesƚe in qiji' nite' hik ƚunyejei kekhewep profeta'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ha'ne Juan Bautista hik ha'ne t'ejuyets kakha' we'nika'ajji' in yit'ij: “Jeƚ qeku'nek, yakha' hiwathayinket ek'ui hatse' nakha' yukine'k qa' hikna' najilet'ek'ui pa'qu' ikheyi'je'.” ");
INSERT INTO mca_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yakha' hit'iƚij ewets in week pekhewe' nekfik'i ta'ƚets ne'ej efu in ham pa'qu' nat'anipji' ha' Juan Bautista in qiji'ha. Qa pakha'ƚe qu' nite' qiyetaxji' pe' i'nji'teje'm na' tenek'enheiji' na' Dios qa t'anipji' ek hakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Week pe' jukhew qa efuts qa pekhewe' iye yijaninkii pe' wekwek t'ejuyets pa' Roma in yepi'ye' pa'aj, ma' qa nikfe'lets pa' Dios in hats yaqsiijkii in hats yatsathen pekhewe'en, qe nimpuujinju' pa'aj pa' Juan. ");
INSERT INTO mca_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Qa pekhewe'ƚe fariseol qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa nite' nimpuujinju' pa'aj pa' Juan Bautista, qe pekhewe'en nite' t'eku'miju'ƚ yuten pakha' yisu'untax pa' Dios qu' ƚeqfenyejeyi'ij pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma' qa yit'ij pa'aj pa' Jesús: —¿Pa'n ƚii pa'qu' hejeyumtshenijupi' enewe' hane'ej ƚahats'ij? ¿Ƚekpa' qu' hik ƚunyejeye'? ");
INSERT INTO mca_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hik ƚunyejei ne'ej omehets qe i'niju'kii na'aj joofji'ju' qe t'otoijo' qa taya'yi'ƚ wetju'ƚkii ne'ej ƚ'otoihifetsju', qa yit'ijiikii: “In hifuyutaxi'ƚ e'mik'i ne' foj qa nite'ƚe ƚ'otoyi'ƚ. Hijitaxi'ƚ e'mik'i ke' if'iljetsitsik'i witlijtsinel qa nite'ƚe ƚapi'ƚju'.” ");
INSERT INTO mca_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Qe in nam ha' Juan Bautista qa nite' tuj pa'qu' pane', nite' iya'ji' iye pa'qu' winoye', qa ekheweli'ƚ qa ƚit'iƚij: “I'nji' pa' ewi'ƚ inwo'met.” ");
INSERT INTO mca_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Qa in nam ha'ne Ƚa's na' Jukhew qa tek qa iya' iye. Qa ekheweli'ƚ qa ƚit'iƚij: “Jeƚ qeku'ni'ƚek na' jukhew hayits qa ekuna'x qa iyana'x iye, qi iye in ƚejuwaika' ne' yijaninkii eke' wekwek qa ne' qi iye in uƚ'ets.” ");
INSERT INTO mca_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Qa pakha'ƚe qi ƚikfeliya'xkii pa' Dios qa jutsiqaxƚi'ij pa' ƚunyejei pekhewe' week hats ƚelitsij.— ");
INSERT INTO mca_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ewi'ƚ pa' fariseo t'eqe'mets pa'aj pa' Jesús qu' netekiƚi'ju' pe' ƚetsi'ii. Ma' qa yijayanii pa'aj pe' ƚetsi'ii, qa i'nijupju'kii pa' ƚekula'x. ");
INSERT INTO mca_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pakha' witset na'l pa'aj pe' ewi'ƚ efu qi in uƚ'ax. Pekhe'en in nikfe'lets pa'aj pa' Jesús in mexe i'nijupju' pa'aj pa' mesa in teki'ju' pe' ƚetsi'ii pa' fariseo. Ma' qa namets pa'aj teneyij pa' ewjisii topo'oj pe' ƚejiiki' ta'ƚets na'aj alabastro. ");
INSERT INTO mca_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pekhe'en ip pa'aj ƚ'anu'ui i'nii pa' Jesús qa pe' ƚet'ilii qa tsapetsju'kii pe' ƚef'iyei pa' Jesús, ma' qa nili'jijju' pa'aj pe' ƚ'ewkujits qa tu'je'm iye pa'aj pe' ƚef'iyei qa i'nk'aƚe qa yatsi'yipji' pa'aj pa' ewjisii pe' ƚef'iyei pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Qa pa' fariseo pakha' t'eqe'mets pa'aj pa' Jesús in yi'wenij pa'aj aka'an, qa yit'ij in iyet pa' ƚatawe'j: —Qek yijaayi'ija qek profetaye' ha'ne jukhew ma' qekha nenikfe'ltaxets pa'n ƚunye'j nekhe' efu t'ekumetskii, nekhe'en uƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma' qa pa' Jesús qa yit'ijets pa'aj pa' fariseo: —Simón, na'l ka' tseqitijineyu'uj ewets.— Qa yeku'ƚ pa'aj pa' fariseo: —Enfel ye'm, Maestro pakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Qa pa' Jesús qa yit'ij: —Wetsjuk pe' jukhew t'eku'mi' pe' ƚaq'astai pa' ewi'ƚ jukhew inq'eku'mhini'kii pe' ƚaq'astai. Ewi'ƚ pa' t'eku'mi' pe' quinientos (500) denarios qa pakhap iye qa cincuentaƚe (50) pe' t'eku'mi'. ");
INSERT INTO mca_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pekhewe'en qa nite'ƚe weju'ƚij qu' nijanin, qa pa' inq'eku'mhini'kii pe' ƚaq'astai qa yiwejinƚe qu'nte' nijanine' pe' ƚ'ekumhifkinel pe' wetsjuk. Qa hane'ej qa' enfel ye'm, ¿ƚek pakha' enewe' wetsjuk pakha' les qi in yisu'un pa' inq'eku'mhini'kii pe' ƚaq'astai?— ");
INSERT INTO mca_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Qa yeku'ƚ pa' Simón: —Humtitax pakha' les olots ƚ'ekumhifkinel qu' hik pakha'ye' pakha' les in yisu'un.— Qa yit'ij pa'aj pa' Jesús: —Hats i'woyaxijik'iha.— ");
INSERT INTO mca_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ma' qa pa' Jesús qa tetwek'ela'xets pa'aj pe' efu qa yit'ijets pa'aj pa' Simón: —¿Me hats ƚi'wenij ene' efu? In k'uyifi ene' etsi' qa nite' ƚesƚisij pa'qu' iweli'ye' qu' himpulijinji' ene' yif'iyei. Qa ene'ƚe efu qa nili'jijju' ene' yif'iyei ke' ƚet'il qa yit'iji' in yisƚatij ne' ƚ'ewkujits. ");
INSERT INTO mca_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nite' ƚesƚu'je'm iye, qa ene'ƚe efu, in i'nk'a hente'nuiteje'm, qa nite' yili'ij tu'je'mkii ene' yif'iyei. ");
INSERT INTO mca_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nite' ƚ'atsiyipji' aceitiye' ha'ne yijiƚa', qa ene'ƚe efu qa yatsi'yipji' ka' ewjisii ene' yif'iyei. ");
INSERT INTO mca_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Qa hik ta'ƚijupi' qu' hit'ij ewets, in hats tewumhiti'yik'ui pe' olots ƚewuƚ'ets ma' qa qi in ineqsu'un. Qa pakha'ƚe qu' nite' qiye' qu' tewumhiti'yik'ui pe' ƚewuƚ'ets, qa nite' qi qu' nineqsu'un.— ");
INSERT INTO mca_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma' qa yit'ijets pa'aj pe' efu: —Pe' ewuƚ'ets hats tewu'mhitii ek'ui.— ");
INSERT INTO mca_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma' qa pekhewep pekhewe' ƚekufets qa tajawehenij wetju'ƚkii in yit'ijju': —¿Ƚekpa' yumtitax qu' ƚakha'ye' ha'ne jukhew in yit'ijets qu' niwu'm pe' witwuƚ'ets?— ");
INSERT INTO mca_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Qa pakha'ƚe Jesús qa yit'ijets iye pa'aj pe' efu: —Pa' nite' eqekuye'j hikpa' ta'ƚets qa hats iƚa'x. Yape ma, hasu'uj itawje'met'e'.— ");
INSERT INTO mca_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma' qa in hats suujik'i pa'aj aka'an, pa' Jesús qa ikijik'i pe' olots witsetits qa pe' witsetits ƚelits iye in nifel eke' ƚe'sits ƚe'lijei t'ejuyets pa' tenek'enheiji' pa' Dios. Ƚijts'eyek he' doce (12) ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Qa uja'x iye pe' efuts ƚijts'eyek iye pa'aj, hik pekhewe' niƚinju' iye pa'aj yukinik'uifik'ikii pe' i'ntaxji' inwo'metets qa pe' ƚaatsheitax iye. Pekhewe'en ƚiyits María, ƚenqii iye Magdalena. Hik pekhe' ikik'uifik'ikii pa'aj pe' wetsjuk tatsai (7) inwo'metets. ");
INSERT INTO mca_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Qa pekhe' Juana ƚewhe'ye' pa' Cuza, ƚeqjeƚinenek pa'aj pa' Herodes. Qa pe' Susana, qa olots iye pekhewep, qa ƚekhewelƚe in yatsat'etsƚi'ij pekhewe' natkiniji' in t'iftits'ijetskii pa'aj pa' Jesús qa pe' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Qa olootsija pa'aj pe' jukhew qa efuts iye, ta'ƚiikii pe' olots pekhelji'kii witsetits, namii pa'aj qu' ni'wen pa' Jesús. Ma' qa yit'iji' pa'aj pa' ewi'ƚ yejeyumtshenijupi' in iyetik'ui: ");
INSERT INTO mca_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Pa' iwenq'enhena'x ikijfik'i pe' ƚoqoƚoi qu' nenju'. Ma' qa in hats we'nq'en qa uja'x pe' ƚoi namji'ju'kii pa' wit'ikheyi'j qa tonotshiyipji'kii qa pe' junatai qa tuj. ");
INSERT INTO mca_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Qa pekhewep ƚoi qa namji'ju'kiyek pa' uteket leseesƚi'ik'i pa' sehe' ija, qa in ta'ƚtax pekhewe'en qa aje'eƚ yisƚax qa wa'mji' iye qe nite' eqhimiyifi. ");
INSERT INTO mca_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Qa pekhewep iye qa namji'ju'kiyek pa' tiiket. Qa ta'ƚi'ƚ pe' tii qa tik'eyijju'. ");
INSERT INTO mca_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Qa pekhewepƚe qa namji'ju'kiyek pa' ƚe'wisji' sehe' qa ta'ƚ ma' qa qipha'm qa na'l pe' ƚei ƚe'sits qa olots iye qa yamets cien (100) pe' ƚei in ewi'ƚ ƚenu.— Ekewe'en in yit'ij pa'aj pa' Jesús qa yit'unhetik'i in yit'ij iye pa'aj: —¡Pekhewe' qu' nana'l ƚekfiiye', nepiye'ek'iha aka'an!— ");
INSERT INTO mca_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","He' ƚ'ijatshenhei qa nifaakanij pa'aj pa' ikji'ha kakha' yejeyumtshenijupi'. ");
INSERT INTO mca_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pa' Jesús qa yit'ijets pa'aj: —Ekheweli'ƚ ƚenexke'ej qu' enikfe'li'ƚetsha kekhewe' nite' hayiits qu' nana'l pa'qu' nenikfe'lets t'ejuyets na' tenek'enheiji' na' Dios. Qa nekhewepƚe qa hit'iji' in k'iyetik'ui kekhewe' hejeyumtshenƚi'ijupi'kii, hats'inha qu' ni'wentax hikƚe ƚunye'j qu'nte' ni'wene', qa qu' nepi'ye'taxik'i qa nite'ƚe nikfe'lik'i pa' iikji'ha.— ");
INSERT INTO mca_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Aka'an kakha' ikji'ha ka' wetjeyumtshenijupi'. Pe' ƚoi hik ƚunyejei ekewe' ƚe'lijei na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Qa pa' wit'ikheyi'j qa hik ƚunyejei pekhewe' qu' nepi'ye'taxik'i eke' Dios ƚe'lijei, qa i'nk'aƚe qa namets na' inwo'met qa nitkamijik'i in we'nentaxji'ju' pe' ƚatawjets. Hats'inha qa yeqeku'uk'i ma' qa'nte' iƚiye'. ");
INSERT INTO mca_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Qa pa' uteket in leseesƚi'ik'i pa' sehe'taxija, qa hik ƚunyejeyek pekhewe' yepi'ye' ek'i eke' ƚe'lijei na' Dios, ma' qa qi in yisu'unik'i qa t'eku'mi', qa hamƚe ƚefitetsiye'. Ƚ'ajƚi'ij in tek'entaxik'i, qa in namets pa'qu' witaqjaajinkeyeje', ma' qa yili'ijju'. ");
INSERT INTO mca_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Qa pa' tiiket qa hik ƚunyejeyek pekhewe' yepi'ye'taxik'i eke' ƚe'lijei na' Dios, qa in iktaxij pa' ƚ'ikheyi'j, qa yuƚametenƚe in yitawje'meten wekwek, ƚaq'astaye' qu' olotse' qa pa'qu' ƚakha' ye'ƚe qu' nisu'un qu' ni'sinheti'mkii. Ma' qa nite' yuji' pe' ƚeitax. ");
INSERT INTO mca_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Qa pa' ƚe'wisji' sehe', qa hik ƚunyejeyek pekhewe' yepi'ye' ek'i ke' ƚe'lijei na' Dios, ma' qa weekijha pe' ƚatawjets in yatsathen qa ƚe'sits iye in t'eku'mi' qa went'unhetij watjanithenijha. Ma' qa nite' yili'ij in na'l pe'qu' ƚeye'.— ");
INSERT INTO mca_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Ham pa'qu' ƚeqfenye'ji'ij qu' nene'ƚji' pe'qu' fetitjiye' qa' nit'onijju' pe'ye', i'nƚi'i qu' nenifi ƚatawe'j pa'qu' witiwhi'la'xe'. We'nitonpha'm yijat'ij qe we'nenpha'm hats'inha qa yi'wenkii ne'ej te'nuiteje'm. ");
INSERT INTO mca_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Qe ham pa'qu' natat'inhetiikii qu'nte' ne'twenheti'ye' hatse', qa ham iye pa'qu' nite' netfelhiti'ye' qu'nte' ninikfe'le' hatse', qa' ninikfe'l hatse'. ");
INSERT INTO mca_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Qa hik ta'ƚijupi', jeƚi'ƚiju'ƚ pa'n ƚunye'j in ƚepi'ye'eƚik'i, qe pa'qu' hats nana'li'm qa' les netesti'yij iye. Qa pa'qu' hami'im, qa' netitkamhiti'yij iye pakha' yumtitax qu' nana'li'm.— ");
INSERT INTO mca_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ke' ƚenene qa he' ƚek'injats pa' Jesús namtaxii pa'aj pa' i'ni', qa nite'ƚe ƚeke' qu' nametsji' pe' wititsi'ifi qe olots pe' jukhew, efutsji'kii. ");
INSERT INTO mca_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Qa tefelhitiitaxi'm pa'aj pa' Jesús: —Ke' enene qa he' ek'injats iye ha'nii qe amaneyi'fik'i. Yisu'untax qu' ne'wen.— ");
INSERT INTO mca_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Qa yeku'ƚ pa'aj pa' Jesús: —Pekhewe' yepi'ye' ek'i qa yaqsi'jijkiiha iye ekewe' yit'ij eke' ƚe'lijei na' Dios, qa' hik pekhewe' nenel qa' k'injats iye.— ");
INSERT INTO mca_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ewi'ƚ pa' neƚuji' pa'aj pa' Jesús qa pe' ƚ'ijatshenhei qa t'ilitji'ju'kii pe' ewi'ƚ witinhitjii, qa yit'ijets: —Ju'ukiiteje'm na' ƚajaika' ene' kaƚi'.— Ma' qa ikkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","In ikteje'mkii pa'aj qa pa' Jesús qa ima'. Qa nam pa'aj pa' qi t'unik'i. Qa pe' witinhitjii qa tsxiƚtsxiƚji'ju'kii pa' iweli'. Qa qi in iftsaxets pa'aj qu' nuihin. ");
INSERT INTO mca_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ma' qa ikii pa'aj qa nijt'otshenii pa' Jesús, qa yit'ijets pa'aj: —¡Maestro! ¡Maestro! ¡Hats k'esik'i qu' jinanaxju'!— Pa' Jesús qa niipha'm pa'aj qa yaq'ayinij pa' t'unik'i qa pe' qitsik'i ƚeqe t'uyuyits iye, qa aje'eƚ qesik'ui pa'aj pa' t'unik'i qa ikesimen iye pa' iweli'. ");
INSERT INTO mca_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pa' Jesús qa yit'ijets pa'aj he' ƚ'ijatshenhei: —¿Khaye'ek pa'nte' eqekuye'ji'ƚ? ¿Pa'n ikji'?— Qa hekhewe'ƚe'en qa qi in nijiwei pa'aj qa yitjuƚaxijpha'mkii iye. Qa yifaakateji' pa'aj, qa yit'ijju': —¿Pa'n ƚunye'j ha'ne jukhew in tek'enets iye in yaq'ayinij ka' t'unik'i qa ha'ne iweli' iye?— ");
INSERT INTO mca_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ma' qa yametsteje'm pa' sehe' ƚii Gadara ƚajaika' ai wankaajuƚetsteje'm ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Qa in hats t'ilitpha'm pa'aj pa' Jesús, qa te'nilitfik'i pa'aj qa nekets pa' ewi'ƚ jukhew i'nji' pe' inwo'metets hayiits ta'ƚtaxets pa'aj pa' witset'ija qa hatsƚe nite' i'nji'. Qa hats toxik'i pa'aj in nite' yeqhinataji' pe'qu' witqhinataye', qa nite' iye i'nifi pe'qu' wititsi'ye', qe pa' nimeƚkuket hikpa' i'nji'kii. ");
INSERT INTO mca_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pakha'an in yi'wen pa'aj pa' Jesús, ma' qa yejtsi'le' pa'aj qa wonokok'enifi qa yit'unhetik'i in yit'ij pa'aj: —¿Inhats'ek in ƚanamyii, Jesús, Ƚaa'sija pa' Qiji'ha in Dios? K'iyinij ewets qu' hasu'uj atsawtsheten wat'ij.— ");
INSERT INTO mca_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yit'ij pa'aj aka'an qe pa' Jesús yiyaji'ets pa'aj pa' espíritu uƚ'ax qu' nakik'uifik'i pa' jukhew in i'ntaxji', qe hats olotsij in uijiik'i. Qa pe' jukhew in yophe'ƚ ji'ijtaxij ƚokoyei qa ƚef'iyei iye pe' foƚoƚik'il qa yejeƚji'ijtaxetsha iye, qa niwk'itsinƚeji'ijju' qa pa' inwo'met qa yilithinji'jii pa' ham i'ni'i'. ");
INSERT INTO mca_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pa' Jesús qa nifaakan pa'aj: —¿Pa'n ii?— Qa pakha'an qa yeku'ƚ: —Yakha' yii Legión.— Qe olots pe' inwo'metets i'nji' pa'aj pa' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pekhewe'en qa qi in iyinijets pa' Jesús qu' hasu'uj nit'ij pa'qu' ƚeji'ye', pekhewe'en qa' nakiiju' pa' koomojo' ham ƚ'aka'the'ye' (abismo). ");
INSERT INTO mca_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Qa na'l pa'aj pe' olots tafitets taqakiyi'ju' pe' utek ipji'. Qa pe' inwo'metets qa iyinijetskii pa'aj pa' Jesús qu' nuyik'i pekhewe'en pe' tafitets. Qa pa' Jesús qa ƚexke'ej pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma' qa pe' inwo'metets qa ikik'uifik'ikii pa'aj pa' jukhew qa uijiteje'mkii pe' tafitets. Ma' qa pe' tafitets qa wekuma'xik'iju'kii pa' kiimiju' qa yamjeetsju' pa' iweli' qa hikpa' qa uyi'kii qa naxiju'. ");
INSERT INTO mca_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pe' yejeƚtax pe' tafitetsik'i, in yi'wen pa'aj aka' ƚunye'jkii qa wekuma'xii pa'aj pa' witset qu' nenfelkii. Qa' nenfeli'm iye pe' i'ni' pa' ƚ'ejinqa'wet. ");
INSERT INTO mca_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pe' jukhew qa efuts iye qa neeƚii pa'aj pa' ƚunye'jkii. In namii pa' i'ni' pa' Jesús qa yi'wen pa' jukhew i'ntaxji' pa'aj pe' inwo'metets. I'nijupju' pe' ƚef'iyeyiiju' pa' Jesús. Hats teqhinatai pa'aj qe hats teik'uneikii. Qa qi pa'aj in nijiwei pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Qa pekhewe' yi'wenijha pa'aj pa' ƚunye'jkii, qa nifelimik'i pa'aj pa' ƚunyee'jkiiha pakha' i'ntaxji' pe' inwo'metets in hats ƚe'wisju'. ");
INSERT INTO mca_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Week pekhewe' tetseti'yi' pa' sehe' Gadara, iyinijets pa'aj pa' Jesús qu' nakik'ui iye pa' sehe', qe qi in nijiwei pa'aj pekhewe'en. Ma' qa pa' Jesús qa t'ilitji'ju' iye pa'aj pe' witinhitjii qa ik iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pa' jukhew pakha' i'ntaxji' pa'aj pe' inwo'metets qa iyintaxijets qu' nijayan pa' Jesús. Qa pakha'ƚe Jesús qa nite' ƚexke'ej, qa yit'ijets pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mapilii yijat'ij pe' etsi' qa' week enfel ka' ƚeqfenye'j ej na' Dios.— Pa' jukhew qa ik pa'aj. Ma' qa week nifelimik'i pa' witset pa' ƚeqfenye'jij pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ma' qa in hats yamiiteje'm iye pa'aj pa' ƚajaika' pe' kaƚi', qa pe' olots jukhew, efutsji'kii qa qi in ƚe'sitsi'mkii pa'aj in hats namets iye pa'aj, qe week hayiits notki'iikii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Qa hik pa'aj qa namets pa' ewi'ƚ jukhew ƚii Jairo. Pakha'an tenek'enhe'yij iye pe' witlijtsitjii. Ha'ne jukhew we'niyipinifi pa'aj ƚef'iyei pa' Jesús, qa qi in iyinijets pa'aj qu' namiƚii pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Qe pakha'an na'l pa'aj pe' ewi'ƚƚi'i' in ƚasi', doce (12) ƚeqe'ninqapits, qa pekhe'en qa hats k'esik'iha pa'aj qu' nawa'm. Qa in hats iktax pa'aj pa' Jesús, qa olotsƚe pe' jukhew qa efuts watkatitij wetepji' in nijayanik'i. ");
INSERT INTO mca_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pekhewe'en i'nji'teje'm pe' ewi'ƚ efu hats doce (12) ƚeqe'ninqapits in nite' hamitsik'ui pe' ƚ'athits. Qa hats olots pe' naq'axiji' ƚaq'astayik'i pe' weihetets witeqjunhetits ƚeiƚets qa ham pa'qu' napaliti'm pekhewe'en pa' ƚawtshek. ");
INSERT INTO mca_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pe' efu qa wetjuk'etetsji' pa'aj pa' Jesús ƚ'anu ta'ƚii qa t'eku'mets pa'aj pa' ƚ'aka'the' eiju' pa' ƚ'uihitjii. Ma' qa hik pakhaa'ijha qa aje'eƚ qesitsik'ui pa'aj pe' ƚ'athits. ");
INSERT INTO mca_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Qa pa' Jesús qa inaqfaakanij pa'aj: —¿Ƚekpa' t'eku'm yiwets?— Qa week welkut'ijkii pa'aj pekhewe'en pa'qu' net'eku'mi'. Qa pa' Pedro qa yit'ij: —Maestro, ene' olots najayanpha'm qi in puk'upha'm wetwumij wetepji'.— ");
INSERT INTO mca_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Qa pa' Jesús qa yit'ij: —Na'l pa' t'eku'm yiwets qe hoksi'wen in ikfik'i pa' yit'unha'x.— ");
INSERT INTO mca_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pe' efu, in nikfe'lets in nite' ƚeke' qu' nanat'inij, qa tsalalkii pa'aj in nekets qa wonokok'eniiju' pa'aj ƚef'iyei pa' Jesús. Qa tetfeliji'm pa'aj week yepi'ye' ej pe' week in nifel pa' ta'ƚijupi' in t'eku'mets pa' ƚ'uihitjii pa' Jesús, qa in aje'eƚ naxpa'lij iye pa' ƚaatshektax. ");
INSERT INTO mca_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pa' Jesús qa yit'ijets pa'aj: —Yasi', pa' nite' eqekuye'j ta'ƚets in ƚanaxpa'lij pa' ejunye'jtax. Hasu'uj natawje'meten. Yape ma.— ");
INSERT INTO mca_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","In mexe iyettax pa'aj pa' Jesús qa namets pa' ewi'ƚ ta'ƚii pe' ƚetsi' pa' tenek'enhe'yij witlijtsitjii, qa yit'ijets pa'aj: —Ke' oqwomeki'ik'i hats wa'm. Yape iwejinƚe na' Maestro.— ");
INSERT INTO mca_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Qa pa' Jesús qa yepi'ye' ej pa'aj, qa yit'ijets: —Hasu'uj e'nijiwei. E'meheyi'ij yijat'ij qu' hasu'uj inqeku' qa pe' oqwomeki' qa' ƚe'wise'ju'.— ");
INSERT INTO mca_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","In yamets pa'aj pe' wititsi', qa nite' ƚexke'ej pa'qu' nijayanteje'm in uyetsji'. Uja'xƚe in t'eqe'mets ha' Pedro qa ha' Juan qa ha' Jacobo (Santiago) qa pa' ƚatata qa pe' ƚenene pe' ome'ƚaski'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Week pekhewe' nekii ipju' qa yilanje'mkii iye pe' ƚ'ejuijets in yayinju' pa'aj pe' ome'ƚaski'ik'i. Qa pa' Jesús qa yit'ijji'ju' pa'aj: —Hasu'uj mapi'ƚju', qe ne' ome'ƚaski' nite' wa'm, ima'ƚe.— ");
INSERT INTO mca_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Qa yilaki'ijju' pa'aj aka' yit'ij, qe nikfe'lets in hats waa'mija. ");
INSERT INTO mca_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma' qa pa' Jesús qa t'eku'mi' pa'aj pa' ƚokoi, qa yit'unhetik'i in yit'ij pa'aj: —¡Ome'ƚaski', eniipha'm!— ");
INSERT INTO mca_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma' qa tepilets iye pa' ƚiƚa'x pe' ome'ƚaski'. Qa aje'eƚ niipha'm pa'aj. Qa pa' Jesús qa inaqyaji'ij qu' netesti'yij pa'qu' ƚaqe'. ");
INSERT INTO mca_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pe' ƚ'alhei qi in yitjuƚaxijpha'mkii pa'aj. Qa pa' Jesús qa yiyaji'ijets qu' hasu'uj nenfeli'm pe'ye' aka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pa' Jesús qa no'thet wetju'ƚ pe' doce (12) ƚ'ijatshenhei qa tisij pa' ƚet'unhaxitsijup qa qu' netk'enets iye pe' inwo'metets qu' nukinji'ijfik'i, qa qu' nanpalit iye pe' week witja'metets. ");
INSERT INTO mca_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma' qa yukinijkii pa'aj qu' nenfel pa' tenek'enheiji' pa' Dios, qa' nenƚinju'kii iye pekhewe' qu' nanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Qa yit'ijets pa'aj: —Hasu'uj eka'xi'ƚ pe'ye' in ƚaki'ƚkii, hasu'uj iye awaikajiti'yi'ƚ, hasu'uj iye eqe ti'naji'yi'ƚ, hasu'uj iye aqatsi'iƚ pan, hasu'uj iye aq'astayi'iƚ, hasu'uj iye eqhinatayi'iƚ, uja'xƚe pe'qu' hats eqhinataji'iƚ. ");
INSERT INTO mca_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Qu' ami'ƚets pa'qu' witset'e qa pe'qu' mewi'iƚifi wititsi'ye' qa hasu'uj i'nk'aihiti'ƚ iye ami'ƚijii qu' mataxiƚik'ui iye pa'qu' witset'e. ");
INSERT INTO mca_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Qa pa'qu' witset'e in nite' neqjunu'uƚij ewetskii, qa qu' ma'aƚik'uifik'i iye qa' enfuluti'ƚju' pa'qu' sehe'ye' qu' namtaxij ne' ef'iyeyi'ƚ qa jutsiqetsi'im in uƚ'ets. ");
INSERT INTO mca_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma' qa ikkii pa'aj pekhewe'en, qa ikijik'i pe' witsetits ƚelits in nifeli'm eke' ƚe'sits wi'tlijei qa niƚinju'kii iye pe' wanqaats'etaxju'.— ");
INSERT INTO mca_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pa' wittata Herodes qa i'ye'ej pa'aj week pe' yaqsi'jijkii pa' Jesús, ma' qa in nite' nikfe'lijkii pa'n qu' numti, qe uja'x pe' yit'ijets in hik pakhate' pa' Juan Bautista'ik'i qu' iƚa'xe' iye. ");
INSERT INTO mca_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Qa na'l pe' yit'ijetsek qu' hik pakha'ye' pa' Elias'ik'i. Qa pekhewep iye qa yumti ek qu' ewi'ƚe' pekhewe' hayiits profeta'ik'i qu' iƚa'xe' iye. ");
INSERT INTO mca_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma' qa pa' Herodes qa yit'ij pa'aj: —Ka' Juan'ik'i yakha' k'inaqyaji'ij qu' ne'nisa'xii ka' ƚeiƚa'. ¿Qa pa'n ƚunye'j pakha'an, pakha' k'impi'ye'ejkii pa' ƚeqfenye'j ƚewek?— Qa yisu'untax qu' ni'wen pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pe' apóstoles in hats tepilkii iye pa'aj, qa nifelimik'i pa' Jesús week pekhewe' yaqsiijkii. Pa' Jesús qa iki'ƚiiteje'm pa' witset Betsaida qe qa' uja'xe'ƚe eku'ni'ƚkii. ");
INSERT INTO mca_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Qa in nikfe'lets pe' jukhew qa efuts qa yijayanpha'm iye pa'aj. Qa nite'ƚe t'oqowe'yiju'ƚ pa' Jesús. Ma' qa nifeli'm pa' ƚunye'j pa' tenek'enheiji' pa' Dios, qa niƚinju' iye pa'aj pe' wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Qa in hats metiyu'ju' pa'aj junu', qa pe' doce (12) ƚ'ijatshenhei qa nekets pa'aj pa' Jesús, qa yit'ijets pa'aj: —Yape mewetfeli'm week nekhewe' jukhew qa efuts, hats'inha qu' nakiikii ne' metits witsetits ƚelits qa nekhewe' iye wititsil i'ni' na' ƚ'ejinqa'wet, qa' ni'wen pa'qu' ƚewhi'wet'e' qa pa'qu' ƚaqe' iye, qe ha'ne ju'uni' ham wekweki'i'.— ");
INSERT INTO mca_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Qa pakha'ƚe Jesús qa yit'ij pa'aj: —Ƚisi'ƚij pa'qu' netuj.— Pekhewe'en qa yeku'ƚ pa'aj: —Nite' inek olots he' inqats, i'nƚi'i qu' leefijƚe (5) he' pan qa wetsjuk tu'u he' sehets, qa qu' isu'un qa' mexe hayaqhai eku'ni'ƚii pa'qu' netuj week enewe'en.— ");
INSERT INTO mca_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Qe i'nƚi'i tit namets pa'aj lee'fij mil (5.000) pe' jukhew.) Qa pa' Jesús qa yit'ijets pa'aj he' ƚ'ijatshenhei: —Iyaji'iƚets qu' na'nju'kii qa' pumume'pha'mkii cincuentaye'kii (50) qu' namets ewiƚei pe'qu' pumume'pha'mkii.— ");
INSERT INTO mca_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ma' qa hik aka' ƚeqfenyejeyij pa'aj, qa week i'nju'kii. ");
INSERT INTO mca_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pa' Jesús qa t'eku'mi' pe' lee'fij (5) pan qa pe' wetsjuk sehets, qa yejeƚpha'm pa'aj qa yit'ijetspha'm ƚe'wisij pa' Dios. Ma' qa napk'asitju' qa tisij pa'aj he' ƚ'ijatshenhei qa hikhe' qa netisijju' pekhewe' week jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Week tekju' pa'aj qa iƚiinƚi'ijju'ha iye. He' ƚ'ijatshenhei qa ewi'ƚ yeni' pe' ƚaqaxpalii qa yenji' pe' doce (12) canastul qa week topolij iye pe' ƚaqaxpalii. ");
INSERT INTO mca_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ewi'ƚ pa' neƚuji' pa'aj in iyin pa' Jesús. Uja'xƚi'iƚkii pa'aj he' ƚ'ijatshenhei, qa nifaakanji'ju' pa'aj: —¿Pa'n yit'ij ene' jukhew qu' yakha'ye'?— ");
INSERT INTO mca_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hekhewe'en qa yeku'ƚ pa'aj: —Na'l he' yit'ijets qu' akha'ye' ka' Juan Bautista'ik'i, hekhewep qa yit'ijetsek in akha'te' pa' Elias'ik'i qa hekhewep iye qa yit'ijetsek qu' ewi'ƚe' pe' profeta'ik'i qu' iƚa'xe'.— ");
INSERT INTO mca_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pa' Jesús qa yit'ijets: —Qa ekheweli'ƚ, ¿Qa ƚekpa' ƚit'iƚijets qu' yakha'ye'?— Qa ha' Pedro qa yeku'ƚ pa'aj: —Hik akha'ija pa' Cristo ta'ƚiiha pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pa' Jesús qa qi in yiyaji'ijetskiiha pa'aj qu' hasu'uj nenfeli'm pe'ye' in ƚakha'ija pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma' qa yit'ijets pa'aj: —Ha'ne Ƚa's na' Jukhew les ƚe'wis hatse' qu' nataatshenhetii, qa qu' qi iye qu' nuten nekhewe' tenek'enheiji' na' witset qa ne' tenek'enhe'yij ne' pa'il qa nekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei, qa' nawa'm iye, qa' iƚa'xe' iye qu' namets wetshetk'ewi'ƚ pe'qu' neƚutse'.— ");
INSERT INTO mca_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma' qa i'nk'aƚe qa yit'ijets iye pa'aj pe' week: —Qu' nana'l pa'qu' nisu'un qu' natsjayanija qa' nili'ij pa'qu' ƚakha' ye'ƚetax qu' nisu'un, net'eku'mi' yijat'ij pe'qu' ƚeqe cruze' qa' natsjayan. ");
INSERT INTO mca_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Qe pakha' qu' nisu'un qu' niƚin pa'qu' ƚiƚa'xe', qa' hami'im hatse' pa'qu' ƚiƚa'xe' nite' yili'ij. Qa pakha'ƚe qu' naqamij pa'qu' ƚiƚa'xe' qe ta'ƚ yiwets, qa' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Qe, ¿ƚek pakha' qu' ne'weju'ƚij pa'qu' jukhewe' qu' nanaxtaxij ha'ne week sehe' ipji', qu' ƚakha'ye'ƚi'ij ƚete'm qu' netwuƚ'enhetijju' pa' witiƚa'x nite' yili'ij? ");
INSERT INTO mca_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Qe pakha' qu' newepinyij qa wepinij iye ke' yi'lijei, pakha'an qa' newepinjiijek hatse' ha'ne Ƚa's na' Jukhew qu' nanamtaxijju' na' qi ƚesa'x qa na' ƚesa'x iye na' Ƚatata qa ne' ƚesaxits ne' ƚe'sits angelits. ");
INSERT INTO mca_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yijaa'ija aka' hit'iƚij ewets in na'l ene' uja'x ha'ne i'ni'in mente' naxju' qa' ni'wen hatse' pa'n ƚunye'jija na' ƚesa'x na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","I'nƚi'i qu' hats wetshetk'ewi'ƚ tatsai (8) neƚutsik'i pa'aj ekewe' yit'ijets, qa pa' Jesús qa ikik'ipha'm pa'aj pe' utek qu' niyin, qa t'eku'miiji' pa'aj in t'eqe'mets ha' Pedro qa ha' Juan qa ha' Jacobo (Santiago) iye. ");
INSERT INTO mca_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Qa in mexe iyin pa'aj, qa pa' ƚeju's qa hats tujtseika' pa' ƚunye'j pa'aj, qa pe' ƚeqhinatai qa hats fo'ija pa'aj qa leppepep iye. ");
INSERT INTO mca_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma' qa na'lji' iye pa'aj pe' wetsjuk jukhew tafaakate'yi'ƚju' pa'aj pa' Jesús. Pekhewe'en hik pekhewe' pa' Moises'ik'i qa pa' Elias'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pekhewe'en tujji'ha iye pa'aj pa' ƚunyejei, qa iyeti'ƚijju' pa' ƚawamhijii hatse' pa' Jesús, in hats k'esik'iha qu' ƚunye'je'kii na' Jerusalenii. ");
INSERT INTO mca_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ha' Pedro qa hekhewep iye ƚijts'eyek pa'aj, qi in nite' ƚekheweliju'ƚ pa'aj in nijatiyu'ju' qa imaa'ju'ha pa'aj, qa in nompha'mkii pa'aj qa yi'wen in koojo pa'aj pa' Jesús qa pekhewe' iye wetsjuk jukhew i'nijup pa'aj pakha'an. ");
INSERT INTO mca_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Qa ƚunye'jkii pakha'aj in hats nikheyu'uk'ui iye pekhewe'en pa' Jesús, pa' Pedro qa yit'ijets pa'aj: —Maestro, hayits qa ƚe'wisi' hane'e'in qu' jina'nji'ji', qek haqsiiƚijkii wetshetk'ewi'ƚ wititsil ƚelitse', ewi'ƚ pe'qu' akha'yi'ij qa pekhep qa' ƚakha'yi'ijek na' Moisés qa pekhep iye qa' ƚakha'yi'ijek na' Elías.— Ha' Pedro nite' nikfe'lik'i aka' yit'ij pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","In mexe yit'ij pa'aj aka'an ha' Pedro, ma' qa nametsju' pe' ewi'ƚ wasi' qa ts'iƚijipji' pa'aj. Pekhewe'en qa qi in nijiwei pa'aj in hats week ts'iƚijipji' pe' wasi'. ");
INSERT INTO mca_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma' qa pe' wasi' qa nokes ji'teje'm pa'aj pa' wit'ax, qa yit'ij pa'aj: —Hane'en hik ha'ne Yaa'sija, hik ha'ne he'yeku'miiji'. Ek'eni'ƚetsha.— ");
INSERT INTO mca_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","In hats yili'ij pa' wit'ax in nokes, qa yeeƚtax iye pa'aj ma' qa hats ewi'ƚƚekii pa'aj pa' Jesús pa' i'ni'. Hekhewe'en qa ham pa'qu' nenfeli'm pa'aj aka' yi'wen pekhewe' neƚutsji' pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Qa ƚunye'jkii iye pa'aj pakhap neƚukii, in hats nekik'iju' in tepilik'uiju'kii pe' utek, qa olootsija iye pa'aj pe' jukhew qa efuts nejelu'uk'ui pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Qa ewi'ƚ pa' jukhew i'nji'teje'm pa'aj pekhewe'en, qa yit'unhetik'i in tayai pa'aj, qa yit'ij: —Maestro, e'nq'elet qeku'nyij wat'ij, k'iyintaxij ewets qu' jeƚ qeku'n wat'ij ha' ya's, qeku'n ewi'ƚƚeyi' in ya's. ");
INSERT INTO mca_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Qa aka' ƚunye'j ji'ijkii qa i'nk'a t'ilitji'jets pa' ewi'ƚ inwo'met, qa mexe yiyaiyayinhetji'ijkii, qa i'nk'aƚe qa yik'elelinhetji'ijkii ma' qa hufji'ijje'm na' ƚeji'. Qi qa uƚ'axji'ij qa yawtshetenji'ij ma' qa mexe yiwejinji'ijtax. ");
INSERT INTO mca_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hats k'iyintaxijets ne' ijatshenhei qu' nukinik'uifik'i, qa nite'ƚe ƚeke' qu' nukinik'uifik'i.— ");
INSERT INTO mca_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pa' Jesús qa yeku'ƚ pa'aj: —Peijaat'ij, enewe' hane'ej namji'ju' ha'ne ƚahats'ij hayits qa qi in inqeku' qa uƚ'ets iye. ¿Pa'n ipƚu'uk'ui qu' mexe ha'ni'ƚ etji'teje'mkii? ¿Pa'n ƚahats'ij qu' mexe ye'weju'ƚi'iƚ eju'ƚ? Enka'x met hane'e'in pa' oqwomehe'.— ");
INSERT INTO mca_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","In hats k'esiyu'ets pa'aj pa' omeƚa's, qa pa' inwo'met qa nijele'ijetsju' pa'aj pa' sehe' qa yik'elelinhetkii iye. Qa pa' Jesús qa yaq'ayinƚi'ij pa'aj pa' espíritu uƚ'ax. Ma' qa hik pakha'aj in ƚe'wisju' pa' omeƚa's ma' qa testi'yij iye pa'aj pa' ƚatata. ");
INSERT INTO mca_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Qa week qi in yitjuƚaxijpha'mkii pa' ƚuk'eji' in qiji'ha in tenek'enhei pa' Dios. Qa in mexe qi in yitjuƚaxijpha'mkii pa'aj pe' week aka' yaqsiijkii pa'aj pa' Jesús, pa' Jesús qa yit'ijji'ju' pa'aj he' ƚ'ijatshenhei: ");
INSERT INTO mca_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ek'eni'ƚik'i qa hasu'uj qu' antapi'iƚik'i aka' qu' hit'iƚij ewets, qe ha'ne Ƚa's na' Jukhew testi'yij hatse' ene' jukhew ma' qa' net'eku'mi'.— ");
INSERT INTO mca_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Qa pekhewe'en qa nite' nikfe'lik'i aka' yit'ij pa'aj, qe mexe nite' ƚexke'ej pa' Dios qu' nenikfe'lik'i. Qa pekhewe'en qa wetjeyepunijets iye pa'aj pa' Jesús qu' niyinijets qu' nenfeeli'mha pa' ikji'ha. ");
INSERT INTO mca_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma' qa he' ƚ'ijatshenhei qa watfaakateji'ijju' pa'aj pa'n ƚii pakha' qu' les qiye'ji' hatse' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pa' Jesús qa hatsƚe nikfe'lets pakha' yumtitax pekhewe'en qu' ƚunye'je'. Qa t'eku'mi' pa'aj pa' omeƚa's qa yenƚetijup pa'aj, ");
INSERT INTO mca_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma' qa yit'ij pa'aj: —Pakha' qu' neneqjunu'uji' aka' yii ha'ne omeƚa's, yakha'ƚe in neqjunu'yij. Qa pakha' qu' neneqjunu'yij, nakha'ƚe ts'ukinju' hikna' neqjunu'uj. Qe pakha' qu' nite' neniwqinhete'ji' qa hik pakha' pa' les in qiji'.— ");
INSERT INTO mca_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Qa ha' Juan qa yit'ijets pa'aj: —Maestro, hi'weniƚij ha' ewi'ƚ jukhew yit'iji' ka' ii in yuki'nfik'ikii pe' inwo'metets, qa haq'ayini'ƚij qe nite' i'ni'ƚ yitji'teje'm.— ");
INSERT INTO mca_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Qa pa' Jesús qa yeku'ƚ pa'aj: —Hasu'uj aq'ayini'ƚij, qe pakha' qu' nite' i'nejuihifeyi'ij, pakha'an inife'ej.— ");
INSERT INTO mca_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Qa ƚunye'jkii iye pa'aj pa' Jesús in hats k'esiyu'ets pa' ƚahats'ij qu' napiletspha'm iye na' wa's, ma' qa we'neni'ha pa'qu' ƚet'unha'xi'ii qu' namii ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pa' Jesús qa yiwathayinket aje'eƚ pe' ƚ'ukinhei, pekhewe'en qa ikkii pa'aj, qa uyetsji' pa' ewi'ƚ ƚetset ƚa's pe' Samaria ƚeiƚets qe qa' najilet pa'qu' ƚewhi'wet'e'. ");
INSERT INTO mca_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Qa pekhewe'ƚe Samaria ƚeiƚets qa nite' ƚexkelij pa'aj, qe nikfe'lets in t'ejuyii ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hekhewe' ƚ'ijatshenhei Jacobo (Santiago) qa ha' Juan, yi'wen pa'aj pakha' ƚunyejeyij pekhewe'en, ma' qa yit'ijets pa'aj pa' Jesús: —Yatsat'axyij, ¿me ƚisu'un qu' nek'iyiniƚetspha'm pa'qu' fet'e' qu' nata'ƚji'pha'm na' wa'sji' qa' nanq'axijju' ha'ne witset ƚa's?— ");
INSERT INTO mca_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Qa pa' Jesús qa tetwek'ela'xets qa yaq'ayinij pa'aj, qa yit'ijets: —Ekheweli'ƚ nite' ƚenikfe'li'ƚets pa'n ƚunyejei ne' eqe'spirituli'ƚ, ");
INSERT INTO mca_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","qe ha'ne Ƚa's na' Jukhew nite' namijetsju' qu' niwuƚ'enhetju' pekhewe' ƚiƚaxits ene' jukhew, qe namijetsju' yijat'ij qu' nenƚinju'.— Ma' qa ikkii iye pa'aj qa yamii iye pakhap iye witset ƚa's iye. ");
INSERT INTO mca_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","In mexe ikik'i pa'aj pa' wit'ikheyi'j, qa ewi'ƚ pa' jukhew yit'ijets pa'aj pa' Jesús: —Yatsat'axyij, hisu'untax qu' k'ajayanik'i pa'qu' maji'ijji'.— ");
INSERT INTO mca_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pa' Jesús qa yeku'ƚ pa'aj: —Ne' ejenelits na'l ne' ƚewjets qa ne' junatai qa na'l ne' ƚupits, qa ha'neƚe Ƚa's na' Jukhew qa ham pa'qu' ƚewhiwet'i'ija.— ");
INSERT INTO mca_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pa' Jesús qa yit'ijets iye pakhap jukhew: —Atsjayan.— Pakha'an qa yeku'ƚ pa'aj: —Yatsat'axyij, etswejinƚe eku'n hojohontax hatse' qu' hetijik'ui ha' tata.— ");
INSERT INTO mca_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pa' Jesús qa yeku'ƚ iye pa'aj: —Iwejinƚi'ij pekhewe' hik ƚunyejei qu' nanaxju' qu' netijik'ui pekhewe' wa'm. Qa akha'ƚe qa' yape ma, qu' enfeli'm ene' week pekheli'kii na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qa pakhap iye qa yit'ijetsek: —Yatsat'axyij, hisu'untax qu' k'ajayanija hatse', qa hisu'unƚe qu' etswejinƚe eku'n qu' mexe hewetfel eku'ni'm he' yalhei qa he' yejefets iye.— ");
INSERT INTO mca_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Qa pa' Jesús qa yeku'ƚ iye pa'aj: —Ham pakha' qu' hats nenipji' ƚokoyei ne'ej witexp'ilasineti' yetsin ne'ej wakka qu' nejeƚik'i pakha' qu' nata'ƚji', qu' ne'weju'ƚij qu' na'n ji'teje'm na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma' qa i'nk'aƚe pa'aj pa' Yatsat'ax'inij qa t'eku'miiji'kii pekhewep iye setenta (70), qa wetsjukkii in yiwathayinketiikii pe' witsetits qu' namets hatse'. ");
INSERT INTO mca_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma' qa yit'ijets: —Olotsija nekhewe' ƚei na' wit'enekju' hats yuji', qa nekhewe'ƚe yithayikitax qa nite' olots. Qa hik ta'ƚijupi', qu' iyini'ƚijets na' Yatsat'axij na' wit'enekju' qu' nenukin pe'qu' nithayiki qu' nenit'ijji' ne' ƚei. ");
INSERT INTO mca_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yape ma'aƚkii. Menikfelitiƚetsha in k'ukini'ƚkii hik ejunyejeyi'ƚ ne'ej kots'etets ƚelits qu' na'n ji'teje'm pe'qu' wowole'. ");
INSERT INTO mca_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hasu'uj eka'xi'ƚ pa'qu' aq'astajiwoyi'iƚ ti'naj, hasu'uj iye eka'xi'ƚ pa'qu' eqe'lhuyitaxi'iƚ, hasu'uj iye wetsjuk'e otshilaxtiyi'iƚ. Qa hasu'uj etke'leni'ƚijupju' pe'ye' qu' mewetfeli'm pa'qu' wit'ikheyije'ji'. ");
INSERT INTO mca_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Qu' ami'ƚets pe'qu' wititsi'ye' qu' mewi'iƚifi, qa' nojo qu' mewetfeliƚi'm qa' it'iƚijets: “Pa' wit'ikesimeya'xƚekii qu' na'nipji' ene' wititsi'.” ");
INSERT INTO mca_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma' qa qu' nana'l pakha' qu' hats ƚa'si'ij pa'aj pa' wit'ikesimeya'xƚekii, ma' qa pa' wit'ikesimeya'xƚekii ta'ƚi'ƚ ewets qa amani'ijup pakha'an. Qa qu' hame'ƚe qa pa' wit'ikesimeya'xƚekii ƚetistaxi'ƚij qa' netpilƚi'iƚ ewets iye. ");
INSERT INTO mca_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hasu'uj e'wisitsi'iƚi' pekhe' qu' hats ni'iƚifi wititsi'ye', ƚuji'ƚ i'nƚi'i qu' iya'aƚji' pakha' qu' neƚisi'ƚij, qe na'aj t'ithayii weju'ƚij qu' natjai. Hasu'uj tujtseika'ye'ji'ij qu' mewijiiƚifi pe'qu' wititsile'. ");
INSERT INTO mca_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Week pa'qu' witset'e in ƚami'ƚets qa t'eku'mi'ƚ eju'ƚ, qa' ƚuji'ƚ week pa'qu' neƚisi'ƚij. ");
INSERT INTO mca_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Iƚini'ƚ pe'qu' nanqaats'etaxju' tetseti'yi' pakha'an, qa' it'iƚijets iye: “Na' tenek'enheiji' na' Dios hats metitsi'ƚ e'm.” ");
INSERT INTO mca_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Qa pakha'ƚe qu' witset'e qu' uitaxi'ƚ ji'teje'm qa nite' neqjunu'uƚ'eju'ƚ, qa' ma'aƚijetsfik'i pe'qu' ƚ'ikheijeye', qu' it'iƚijets: ");
INSERT INTO mca_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ha'nep iye ƚ'eqhip ha'ne sehe' ha'ne etset'iƚ yamtaxij ene' yif'iyeyi'ƚ, qu' henfuluti'ƚju' iye, qe qa' jutsiqetsi'iƚ e'm in uƚ'ax aka' ƚaqsiiƚijkii. Qa lesƚe ƚe'wis qu' menikfelitiƚetsha aka'an, pa' tenek'enheiji' pa' Dios hats met.” ");
INSERT INTO mca_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yakha' hit'iƚij ewets qu' namtaxets hatse' pa' neƚuji' les qi qu' nattanithenhetii hatse' pekhewe'en, tees qu' ƚunye'ji'iju'ƚ na' ƚantanithenkeye'j hatse' kekhewe' tetsetii ka' witsetik'i Sodoma.— ");
INSERT INTO mca_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—¡Hiyee' ha'nus witset Corazín! ¡Hiye' ha'nus iye witset Betsaida! Qe qek hakha'ye' Tiro qa ha' Sidón qu' nanaqsiiji'kii kekhewe' ham ƚunyejeyi'iju'ƚ wanaqsi'jtaxi'ƚ e'mijkii, ma' qekha hayiits nilitaxij in yaqsiijkii pe' uƚ'ets. Qa hik ta'ƚijupi' qekha ninq'ethintaxij in yijaa'ija qu' netf'iljetsin ƚeqhinatai qekha uƚ'etse'tax qa ƚeiƚa' qekha nilintaxij na'aj lo. ");
INSERT INTO mca_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Qa hik ta'ƚijupi', qu' ejeyumtshenhetiitaxi'ƚ hatse' les qu' iftsaxe' qu' atanithenheti'yi'ƚ hatse' qa nite' ƚunyejeyiju'ƚ hatse' ne' tetseti'yi' na' Tiro qa na' Sidón. ");
INSERT INTO mca_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Qa akha' witset Capernaum, ¿me ƚumti qu' ekekiti'yetspha'm na' wa's? Akha' ƚ'ewumhiti'yiiju' hatse' na' fe't ƚe'nq'itset'ij ne' naxju' (Hades). ");
INSERT INTO mca_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pakha' qu' netk'eni'ƚ ewets, yakha'ƚe in tek'enyitwets. Qa pakha' qu' not'oqowe'yi'ƚ eju'ƚ, qa yakha'ƚe in t'oqoweiyiju'ƚ. Qa pakha' qu' not'oqoweiyiju'ƚ, qa nakha'ƚe ts'ukinju' hik nakha' pa' t'oqowe'yiju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pekhewe' setenta (70) jukhew in hats tepilkii iye pa'aj qi in ƚe'sitsi'mkii, qa yit'ijets pa'aj: —Yatsat'axyij, yamijii pe' inwo'metets in tek'eni'ƚ yiju'ƚ in hit'iƚij aka' ii.— ");
INSERT INTO mca_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pa' Jesús qa yit'ij pa'aj: —Ehe, hats hi'wen na' inwo'met (Satanás) in namiiju' ha'ne sehe' hik ƚunye'j na'aj tejen. ");
INSERT INTO mca_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jeƚ qeku'ni'ƚek, yakha' in k'eƚisiƚij pa'qu' et'unhaxitsi'iƚ qe qa otsi'ƚipji'kii ne' hik ƚunyejei q'oiq'oyits qa neyeyits iye, qa week iye na' ƚet'unha'x na' wit'ejuihife, qa' ham pa'qu' ƚeke'ye' qu' nawtsheteni'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Qa hasu'ujƚe qu' ne'sinheti'ƚi'mkii in tek'eni'ƚ eju'ƚkii in ƚukini'ƚfik'ikii pe' inwo'metets. Les ƚe'wis yijat'ij qu' ne'sinheti'ƚi'mkii ke' iyitsi'ƚ in hats we'nika'ajji' na' wa'sji'.— ");
INSERT INTO mca_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Qa hik pakha'aj pa' Espíritu Santo qa qi in yi'sinheti'mkii pa'aj pa' Jesús, ma' qa yit'ij pa'aj: —Qi in ƚe'wisij, Tata, Yatsat'axij na' wa's qa na' sehe' iye, qe ƚat'ini'm nite' ƚ'ethinij ekewe' wekwek pekhewe' wekwek nikfe'lets qa pekhewe' iye wekwek yiya'yij, qa ƚ'ethinij enewe' hik ƚunyejei omehets nite' weniwqinhetji'. Ehe, Tata, qe hik aka' ƚisu'un qu' ƚunye'je'. ");
INSERT INTO mca_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Week ene' wekwek hats tseƚisij na' Tata qu' heinek'enhe'yij. Qa ham nikfe'le'ets pa'n ƚunye'jija na' Ƚa's, ewi'ƚƚe na' Ƚatata in nikfe'lets. Qa ham iye pa'qu' nenikfe'lets na' Ƚatata, qe ewi'ƚƚe na' Ƚa's in nikfe'lets, qa nekhewe' iye yisu'un ha'ne Ƚa's qu' nikfelitets qa yikfelitets.— ");
INSERT INTO mca_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Qa tetwek'ela'xets pa'aj he' ƚ'ijatshenhei qa yejeƚ ji'teje'm. Qa uja'xƚi'ijkii in yit'ijets pa'aj: —Ƚe'sitsi'imkii pekhewe' qu' ni'wen aka' ƚi'weni'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Qe yakha' hit'iƚij ewets in olots ke' profeta'ik'i qa ke' qitsji' wittatalik'i iye qi in neqwenkeyu'taxij aka' hane'ej ƚi'weni'ƚ, qa nite'ƚe yi'wen. Qa qi in yisu'untax iye qu' nepiye'ek'i ekewe' hane'ej ƚepi'ye'eƚik'i, qa nite'ƚe yepi'ye'.— ");
INSERT INTO mca_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma' qa niipha'm pa'aj pa' ewi'ƚ pa' i'nq'ijatshenij ke' Moisés ƚe'lijei qe qa' nijaajin pa' Jesús, qa nifaakan pa'aj: —Maestro, ¿pa'n yeqfenye'j yiwek qu' nana'l ye'm pa' witiƚa'x nite' yili'ij?— ");
INSERT INTO mca_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Qa yeku'ƚ pa'aj pa' Jesús: —¿Pa'n ƚunye'j pa' we'nika'ajji' ke' Moisés ƚe'lijei? ¿Pa'n yit'ij kekhewe'en pa' ƚenikfe'lets?— ");
INSERT INTO mca_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Qa inku'ƚ pa'aj pakha'an, qa yit'ij: —Isu'unija pa' Yatsat'ax'inij eqe Dios weekij pa' atawe'j, weekij pa' iƚa'x, weekij pa' et'unha'x qa weekij iye pa' aqjamtikineye'jkii. Qa' isu'un week pa'qu' mete' e'm jukhew, efuts in ejunye'jek in ƚewetsu'unƚe.— ");
INSERT INTO mca_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma' qa pa' Jesús qa yit'ijets pa'aj: —Ƚ'asiinik'iha in ƚ'inku'ƚ. Aqsiijkii aka'an qa' iƚa'xe'.— ");
INSERT INTO mca_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Qa in ƚunye'jek pa' i'nq'ijatshenij ke' Moisés ƚe'lijei in wo'ƚetaxii qu' netitijitiyijets qu' natsathen, qa yit'ijets pa'aj pa' Jesús: —¿Qa pa'n ƚii pakha' qu' mete' ye'm qu' hisu'un ene' jukhew qa efuts?— ");
INSERT INTO mca_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pa' Jesús qa yeku'ƚ pa'aj, qa yit'ij: —Ewi'ƚ pa'aj pa' jukhew ta'ƚii na' Jerusalén nekik'iju' pa'aj na' wit'ikheyi'j yamii ha' Jericó. Qa weikutiju'ƚ pe' ejtenhetsilets qa t'ilit'ets pa'aj qa nitka'mij pe' ƚewekwekits qa ƚeqhinatai iye. Qa yilanje'mkii iye pa'aj. Ma' qa yiwu'mƚi'iju' qa ikik'uikii, yaqwamitaxijkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma' qa ewi'ƚ pa' pa'i nekik'iju' iye ha' wit'ikheyi'j. Qa in yi'wen qa ikijup pa'aj qa yape'enha ikik'ui pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Qa in namtaxets iye pa'aj pa' ewi'ƚ pekhewe' ta'ƚets pa' Levi'ik'i (levitas). In yi'wentax iye pa'aj qa ikijup iye qa yape'enha ikik'ui iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Qa namets iye pa' ewi'ƚ jukhew, Samaria ƚeiƚe'. In yi'wen pa'aj qa qi in neq'eletij. ");
INSERT INTO mca_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma' qa ikets pa'aj, qa yatsi'yipji' pe' ƚenqek'uwjei pa' aceite qa pa' wino iye, qa yilophe'ƚijipji' pe' penyilots. Ma' qa yinhini'pji' pa'aj pa' ƚe'wut qa yeka'xii pe' ewi'ƚ witiwhiti' qa i'wi'ƚi' qa yejeƚets pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Qa neƚukii pa'aj, qa pa' Samaritano qa t'eku'metsju' pe' wetsjuk denarios, qa tisij pakha' yatsat'axij pe' witiwhiti', qa yit'ijets pa'aj: “Jeƚets ha'ne jukhew. Qu' nat'anipji' ene' k'eƚisij pe'qu' anq'axiji' qa' qu' hetpiltax iye ma' qa' k'ajanin.” ");
INSERT INTO mca_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kha'ye', ¿pa'n ƚii enewe' wetshetk'ewi'ƚ pakha' ƚumti qu' ni'nq'ethinij in meti'm qa yisu'un pa' jukhew t'ilit'ets pe' ejtenhetsilets?— ");
INSERT INTO mca_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Qa pa' i'nq'ijatshenij ke' Moisés ƚe'lijei, qa yeku'ƚ pa'aj: —Pakha' neq'eletij pakha'an.— Qa pa' Jesús qa yit'ijets: —¡Yape ma, qa' aqsi'jijkii aka' ƚunye'j!— ");
INSERT INTO mca_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ma' qa ikkii iye pa'aj pa' Jesús qa he' ƚ'ijatshenhei, ma' qa yamets pa'aj ha' witset ƚa's, hik hakha' qa i'ni' pa'aj pe' ewi'ƚ efu ƚii Marta qa yiwhini' pa'aj pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pe' Marta na'l pa'aj pe' ƚejefeki' ƚii María, pekhe'en i'nijupju' pa'aj pe' ƚef'iyeyifi pa' Yatsat'ax'inij tek'enets pa'aj in iyet. ");
INSERT INTO mca_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Qa pekhe'ƚe Marta qa qi in mehe'ej in yithayiki'im pe' wekwek qa pa'qu' netuj iye, ma' qa nekets pa'aj pa' Jesús, qa yit'ijets: —Yatsat'axyij, ¿me nite' ƚijamti'ij yiwets ne' yejefeki' in nite' tsi'fenij ene' hithayikitaxi'ƚ e'm? Iyaji'ets qu' netsi'fenij.— ");
INSERT INTO mca_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pa' Yatsat'ax'inij qa yeku'ƚ pa'aj: —Marta, Marta, hayits qa natawje'meten qa e'mehe'ej iye wiikfik'i enewe' olotsiiji' wekwek qu' aqsiijkii. ");
INSERT INTO mca_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Qa na'lƚe ka' ewii'ƚija les ƚe'wistax qu' nana'l e'm. Ene' María na' yaftsin in t'eku'miiji' hik ha'ne les qi in ƚe'wis, qa ham pa'qu' nenitka'mij.— ");
INSERT INTO mca_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Qa ƚunye'jkii iye pa'aj pa' Jesús in iyin qa pa'n qu' na'ni'iji' iye pa'aj in iyin, qa in yili'ij pa'aj, qa pa' ewi'ƚ pekhewe' ƚ'ijatshenhei, qa yit'ijets pa'aj: —Yatsat'axyij, ets'ijatsheni'ƚij qu' nek'iyini'ƚ, in ƚunye'jek ka' Juan Bautista'ik'i in yijatshenij he' ƚ'ijatshenhei.— ");
INSERT INTO mca_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pa' Jesús qa yit'ij pa'aj: —Qu' iyini'ƚ qa it'iƚij: “Intata, neniwqinhetji'ha aka' qiji' ii. Yape namets pa' ƚahats'ij qu' qi'ija qu' enek'enhei. ");
INSERT INTO mca_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Esƚisi'ƚij ha'ne neƚuji' pa'qu' hetuji'ƚ in ƚunye'jek week neƚuts. ");
INSERT INTO mca_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iwu'mi'ƚyik'ui pe' uƚ'ets haqsi'ji'ƚijkii in yijunyejeyi'ƚek in hiwejinƚi'iƚ week nekhewe' uƚ'ax yaqsi'jtaxi'ƚ ye'mijkii. Hasu'uj etswejinƚi'iƚij qu' netswumi'ƚju' pa' witaqjaajinkeye'j.”— ");
INSERT INTO mca_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Qa yit'ij iye pa'aj pa' Jesús: —Jit'enqeku'ni' ek pa'qu' ewi'ƚe' ekheweli'ƚ qu' nana'l pa'qu' ƚejuwaika'ye', qa' nakii in hats ƚeqewuk'uji' naja'x, qa' nit'ijets: “Waika', atsatkinhenin qeku'nets wetshetk'ewi'ƚe' pane', ");
INSERT INTO mca_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","qe hanee'ij namyii ha' ewi'ƚ waika' iye toxii pa' ta'ƚji'. Ham yaqi'ijup qu' hetisij.” ");
INSERT INTO mca_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pakha'an qa nekuƚetsfik'i qa' nit'ij: “Hasu'uj atsjati'meten. Hats yijanit'axji' na' ƚeji' qa yiwhifetsju' iye ene' yilits. Qa nite' ƚeke' qu' netsiipha'm qu' k'eƚisij pe'ye'.” ");
INSERT INTO mca_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hit'ij ewets, in yemjeetax in ƚejuwaika'tax qa nite' ni'yijupha'm qu' netisij pe'ye', qa hastaax qa' niipha'm qe ta'ƚets in nite' yili'ij in iyinijetsji'kii. Ma' qa week tisij pe'qu' hami'im. ");
INSERT INTO mca_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Qa hik ta'ƚijupi' qu' hit'iƚij ewets: “Iyini'ƚetskii qa' esti'yi'ƚij. Mowo'oƚiikii qa' i'weni'ƚ. Ilani'ƚetskii na' ƚeji' qa nenit'iƚij e'mii qhof.” ");
INSERT INTO mca_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Qe week na'aj iyinkii qa testii. Qa na'aj wo'oikii qa yi'wen iye. Qa na'aj yilanetskii na'aj ƚeji' qa' wenit'iji'mii qhof. ");
INSERT INTO mca_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jit'enqeku'ni' ek iye pa'qu' ewi'ƚe' ekheweli'ƚ qu' hats nana'li'm pe'qu' ƚelitse', qa pa'qu' ƚa'se' qu' niyintaxijets sehetse', ¿me qa' netisij pa'qu' q'oiq'oye' in iyintaxijets sehetse'? ");
INSERT INTO mca_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","I'nƚi'i qu' niyintaxijets pe'qu' ƚihi'ye', ¿me qa' netisij pe'qu' neyeye'? ");
INSERT INTO mca_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Qe ekheweli'ƚ in uƚ'etstaxi'ƚ qa ƚe'niyayi'ƚij pa'qu' ƚisi'ƚij wekwek ƚe'wis ene' elitsi'ƚ, qa na' Atata'aƚ i'ni' na' wa's in ƚe'wiisija, qa les in ƚe'wis wiikfik'i qu' netisij na' Espíritu Santo pekhewe' qu' niyinijets.— ");
INSERT INTO mca_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Qa pa' Jesús qa yukinik'uifik'i pa'aj pa' jukhew pa' i'ntaxji', ewi'ƚ inwo'met ham ƚe'lijeye'. Qa ƚunye'jkii pakha'aj pa' inwo'met in hats ikfik'i, qa pa' jukhew qa hats iyet pa'aj. Qa pe' olots jukhew qa efuts qa qi in yitjuƚaxijpha'm pa'aj aka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Qa uja'x pe' yit'ijju': —Pakha'ƚe Beelzebú, ƚatata pe' inwo'metets, tisij hane'en pa' ƚet'unha'xijup qa ƚeke' in yuki'nfik'ikii pekhewe' inwo'metets.— ");
INSERT INTO mca_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Qa pekhewepƚe qa naqjaajinkeyu'ujek, ma' qa yiyajitaxijets qu' nethinij pa'qu' ham ƚunye'ji'iju'ƚ qu' nata'ƚetspha'm na' wa's. ");
INSERT INTO mca_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pa' Jesús qa hats nikfe'lets pa' ƚaqjamtikineyejeitaxkii pekhewe'en, qa yit'ijji'ju': —Na'aj qi witset qu' nawatlanju'kii ma' qa ƚakha'ƚe ƚete'm qu' netwuƚ'enhetju', qa hik ƚunye'j iye na'aj ewi'ƚ jukhew qa ƚelits qa ƚewhe'ye' iye in watlanju'kii, qa ƚekhewelƚe ƚete'm iye in wetwuƚ'enhetju'. ");
INSERT INTO mca_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Qa hik ƚunye'j iye nakha' Satanás qu' neqet'ets wetju'ƚkii qa wapilƚe wetju'ƚkii, ¿qa pa'n ƚunye'j qu'nte' niliyi'ij pa' ƚet'unha'x? Aka'an hit'iƚij ewets qe ƚit'iƚijets in hata'ƚijets pa' ƚet'unha'x pa' Beelzebú qa ƚeke' in hukinfik'ikii ne' inwo'metets. ");
INSERT INTO mca_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ekheweli'ƚ in ƚit'iƚijets qu' hukinfik'ikii pe' inwo'metets qu' nata'ƚets pa' ƚet'unha'x pa' Beelzebú, ¿qa ƚek ƚet'unha'xek pa' yit'iji' nekhewe' elitsi'ƚ in yiwu'mfik'i pe' inwo'metets? Qa hik ta'ƚijupi', nekhewe'en qu' hik nekhewe'ye' qu' nejeƚiƚijik'ui aka' ƚit'iƚijju'. ");
INSERT INTO mca_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Qa yakha' in hukinfik'ikii ne' inwo'metets qa hit'iji' pe' ƚayaqsi'ƚe na' Dios, qa aka'an qa hats jutsiqaxij na' tenek'enheiji' na' Dios hats namtaxi'ƚ ewetsju'. ");
INSERT INTO mca_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pa'qu' jukhewe' in t'un, watjanithen week na'l ƚatjanetits, qa yejeeƚija pe'qu' ƚetsi'ye', qa pekhewe' i'nifi wekwek pekhe'en qa ham peeyi'ijkii qe tejeƚitii. ");
INSERT INTO mca_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Qa na'lƚe iye pakha' les t'un iye wiikfik'i t'anipji' pakha'an, ma' qa t'ilit'ets qa naxij, qa nitka'mij week pe' ƚatjanetistax hik pekhewe' qi in wetjumtitaxets. Qa yeka'xik'ui pe' week ƚewekwekitstax qa week t'ihinijkii. ");
INSERT INTO mca_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pakha' qu' nite' yi'feyi'ij pakha'an yejuihife'ej. Qa pakha' nite' tsi'fenij in haqsi'jje'mkii qa yak'esa'xƚekii.— ");
INSERT INTO mca_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Pa'qu' ewi'ƚe' espíritu uƚ'ax in ikik'uifik'i na'aj jukhew, ma' qa nekƚi'ikii pa' ham i'ni'i' yisƚaxkii, wo'taxiikii ƚawapiihiwet'e. Qa in nite' yi'wen pa'qu' nawapi'yi', qa yijamtikii: “Maa, ma hapiliyek ke' yitsi' ke' hata'ƚifi.” ");
INSERT INTO mca_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Qa in tepilii qa yi'wen in hats wetp'ilastaxifi qa hats wanaqsi'jtaxifi iye. ");
INSERT INTO mca_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma' qa ik iye qa yi'wen qa t'eqe'mets pekhewep iye wetsjuk tatsai (7) espíritu les uƚ'ets wiikfi' nite' hik ƚunyejei pakha'an. Ma' qa week enewe'en qa uiji'teje'm iye qa i'nji' iye pakha' jukhew. Pakha'an ma' qa les qi'ija in uƚ'ax, nite' hik ƚunye'j in yojo.— ");
INSERT INTO mca_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","In mexe iyetij pa'aj pa' Jesús ekewe' wekwek, qa ewi'ƚ pe' efu i'nji'teje'm pekhewe' olots, qa taya'yij pa'aj in yit'ij: —Qi qu' ƚe'wisi'imkii pe' efu ƚata'ƚets in ƚenekfik'i qa nefunenkii iye.— ");
INSERT INTO mca_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Qa yeku'ƚ pa'aj pa' Jesús: —Ehe, qa lesƚe qu' qi qu' ƚe'sitsi'imkiiha pekhewe' qu' nepiye'ek'i eke' ƚe'lijei na' Dios qa yaqsi'jijkiiha iye.— ");
INSERT INTO mca_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pekhewe' olots jukhew qa efuts, in hats les t'ijaifik'i qa olots wiikfik'i, ma' qa pa' Jesús qa yit'ij pa'aj: —Ene' hane'ej na'l ha'ne ƚahats'ij qi in uƚ'ets, iyintaxets qu' net'ethinheti'yij pa'qu' ewi'ƚ ham ƚunye'ji'iju'ƚ, qa teesƚe qu' net'ethinheti'yij, qa ewi'ƚƚe hatse' qu' net'ethinheti'yij ka' ƚunye'jkii ka' Jonas'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Qe hik qu' ƚunye'ji'ija ka' ƚunye'jkii ka' Jonas'ik'i in yamii ma' qa jutsiqetsi'm kakha' qek ƚunyejeye'taxkii kekhewe' Nínive ƚeiƚetsik'i, qa hik aka' qu' ƚunyeji'ijek ha'ne Ƚa's na' Jukhew enewe' hane'ej ƚahats'ij. ");
INSERT INTO mca_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kekhe' qi witnene efu'uk'i ta'ƚiiju' na' i'wk'uyi'liiju' niipha'm hatse' qu' newetjeyumtshentax ene' jukhew ha'ne hane'ej ƚahats'ij, ma' qa' nit'iƚij ewets qu' qiye' qu' uƚ'etsi'iƚ, qe kekhe'en toxii pa' ta'ƚji' qa namii qe qa' nepi'ye'ej ka' qi ƚikfeliya'xkii ka' Salomon'ik'i. Qa hane'ej, jeƚ qeku'ni'ƚek nakha' les t'anipji'ha ka' Salomon'ik'i hats ha'ne i'ntaxi'in. ");
INSERT INTO mca_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kekhewe' Nínive ƚeiƚetsik'i niipha'mkii hatse' qu' newetjeyumtshentax ene' jukhew ha'ne hane'ej ƚahats'ij, ma' qa' nit'iƚij ewets qu' qiye' qu' uƚ'etsi'iƚ, qe kekhewe'en yili'ij pe' uƚ'ets in yaqsiijkii in yepi'ye' ek'i ke' ƚe'lijei pa' Dios nifeli'm kakha' Jonas'ik'i. Qa hane'ej, jeƚ qeku'ni'ƚek nakha' les t'anipji'ha ka' Jonas'ik'i hats ha'ne i'ntaxi'in.— ");
INSERT INTO mca_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Ham pa'qu' nene'ƚji' fetitjiye' qa nat'inkii, qa nite' ƚeke' iye qu' nit'onijju' pe'qu' ti'najki'ye' ƚasi'ye'. We'nitonpha'm yijat'ij qe we'nenpha'm hats'inha qa week yi'wenkii pe'qu' nuiteje'mkii. ");
INSERT INTO mca_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne' otoi hik ƚunyejei qu' ƚefetitjiye' na' ese'n, qa hik ta'ƚijupi', ne' otoi qu' ƚe'sitse' qa' nana'ljiim kiyek na' ese'n. Qa qu' uƚ'etse'ƚe ne' otoi qa' nooye'jiimkiyek na' ese'n. ");
INSERT INTO mca_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jeƚ etij pa' na'lkii in'etji' qa hasu'uj qu' noo'ye'kii. ");
INSERT INTO mca_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Qe qu' weeke' na' ese'n qu' hik ƚunye'je' qu' nana'lkii qa ham pa'qu' ƚuk'eye' qu' noo'ye'kii, ma' qa' qi'ija qu' nana'l e'mkii hik qu' ƚunye'je' ne'ej fetitjii qu' nanalit epji' pa'qu' ƚ'uƚaxe'.— ");
INSERT INTO mca_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","In yili'ij pa'aj pa' Jesús in iyet, qa pa' ewi'ƚ fariseo qa t'eqe'mets qu' netekiƚi'ju' pe' ƚetsi'ii. Qa pa' Jesús qa yijayan pa'aj qa uiteje'm qa i'nijupju' pa' ƚekula'x. ");
INSERT INTO mca_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pa' fariseo qa qi in yitjuƚaxijpha'm pa'aj in yi'wen pa' Jesús in nite' yijayanij pakha' yit'ij pe' ƚawa'mhitsik'i qu' nojo qu' nawa'nqa' qa' i'nk'aƚe netek. ");
INSERT INTO mca_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Qa pakha'ƚe Yatsat'ax'inij qa yit'ijets pa'aj: —Ek'en qeku'ni'ƚek ekheweli'ƚ fariseol, ekheweli'ƚ ƚenliji'ƚju' na' i'nfik'i na' wasu qa tok'o iye, qa nakha'ƚe ƚatawe'jji' qa topo'oj nakha' wit'ejtenheye'j qa na' uƚ'ax iye. ");
INSERT INTO mca_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ham ƚenikfe'li'iƚets. Nakha' yaqsiijkii na' i'nfik'i, ¿me nite' yaqsiijkii iye na' i'nteje'm? ");
INSERT INTO mca_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ihini'ƚij yijat'ij nekhewe' wekwek topo'oj nakha' i'nteje'm qa' ƚisi'ƚ ne' ham yiwq'axine', ma' qa' hayitse' yijat'ij qu' ham ƚejili'ye' na' i'nteje'm qa na' i'nfik'i. ");
INSERT INTO mca_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Qa hiyee'ƚe e'newusitsi'ƚ fariseol! Qe in ƚeqethentaxi'ƚfik'i ne'ej menta qa ne'ej ruda qa week iye ni'khewepij ƚesejets, in yamets qu' diezse' qa ewi'ƚ na'aj ƚetisi'ƚij na' Dios. Qa ƚ'anƚi'iƚipji'kii nite' ƚaqsiiƚijkii pa' yatsathen qa pa' witeqsu'unka'xij iye pa' Dios. Hik ekewe'tax qek aqsiiƚijkii yijat'ij, qa hasu'ujƚetax qek ili'iƚij kekhewep iye hats ƚaqsi'ji'ƚijkii. ");
INSERT INTO mca_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Hiyee' e'newusitsi'ƚ fariseol! Qe ƚisu'uni'ƚ wiikfik'i qu' ni'iƚipji' ne'ej ƚots'oji'laxits ne'ej tenek'enhei ne' witlijtsitjiyitsifi, qa ƚisu'uni'ƚ iye qu' eniwetfelhe'yiƚi'mkii ne' witaqhawetitsji'. ");
INSERT INTO mca_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Hiyee' e'newusitsi'ƚ! Qe hik ejunyejeyi'ƚ ne'ej nimeƚkui qe hats nite' yeqet'etsiikii na'aj i'ni' qa t'otsipji'kii ene' jukhew qa efuts qe nite' nikfe'lets.— ");
INSERT INTO mca_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Qa yeku'ƚ pa'aj pa' ewi'ƚ i'nq'ijatshenij ke' Moisés ƚe'lijei: —Maestro, in ƚit'ij aka'an yekheweli'ƚ iye in ƚatswakanini'ƚkii iye.— ");
INSERT INTO mca_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pa' Jesús qa yit'ij: —¡Hiyee' e'newusitsi'ƚ iye ekheweli'ƚ, i'nq'ijatshenij ke' Moisés ƚe'lijei! Qe ƚiƚkonini'ƚij ene' jukhew pe' niihetits witqatai jutsitets qu' jinteka'xtax, qa ekheweli'ƚ qa nite' ƚisu'uni'ƚ qu' eka'xi'ƚ nite' ewii'ƚe' iye pe'qu' ayaqsiyi'iƚ qu' ekumhini'ƚi'. ");
INSERT INTO mca_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Hiyee' e'newusitsi'ƚ! Qe ƚeniihini'ƚpha'm qa ƚaqsi'ji'ƚ ne' ƚenimeƚkui ke' profetalik'i in hik ekewe' ƚalanhei iye ke' aqa'jteyi'ƚik'i. ");
INSERT INTO mca_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Qa aka'an in ƚaqsiiƚijkii, ma' qa hats ƚi'sinhetiƚijupi' aka' yaqsiijkii ke' aqa'jteyi'ƚik'i, qe kekhewe'en nilanju' qa ekheweli'ƚ qa ƚeniihini'ƚpha'm ƚaqsi'ji'ƚ ne' ƚenimeƚkui. ");
INSERT INTO mca_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Qa hik ta'ƚijupi' na' qi ƚikfeliya'xkii na' Dios in yit'ij iye: “He'nukini'ƚ ei hatse' pe'qu' profetale' qa apóstoles iye, pekhewe'en qa' natlanhetiiju' pe'qu' uja'xe' qa pekhewep iye qa' natawitjaxtii.” ");
INSERT INTO mca_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Qa hik ta'ƚijupi' ene' hane'ej ha'ne ƚahats'ij qu' netitijitiyijets hatse' qu' ƚekhewele' qu' nanlanju' pe' week profetalik'i in uja'xek pe' talanhetii'ju'kii ta'ƚijii in i'nk'a wanaqsiijkii ha'ne sehe'. ");
INSERT INTO mca_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Qa' nata'ƚijii in talanhetii ka' Abel'ik'i qa' namijii in talanhetii ka' Zacarias'ik'i. Hikka' talanheti'yi' nakha' ƚeqewuk'uji'ju' na' ts'eewe'epji' (altar) qa ne' t'ejutshenheti'yets na' Dios. Ehe, yakha' hit'iƚij ewets, aka'an in t'enhetiyipji' iye enewe' hane'ej ƚahats'ij. ");
INSERT INTO mca_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Hiyee' e'newusitsi'ƚ, i'nq'ijatshenij ke' Moisés ƚe'lijei! Qe ekheweli'ƚ ƚaqsi'jtaxi'ƚ ne' ƚejinje' na' witikfeliya'xkii. Qa ekheweli'ƚ nite' ƚe'nuihiyu'uƚii qa nite' ƚiwejiniƚi'm iye nekhewe' hats nuihiyu'taxii.— ");
INSERT INTO mca_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","In ikik'uifik'i pa'aj pa' Jesús pe' wititsi', qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pekhewe' iye fariseol, qa yijayanfik'i pa'aj, ma' qa yapeƚek qa iyetƚe etsek pa'aj qe qi in nayu'um, qa pekhel ƚ'anyejeyetskii in nifaakankii, ");
INSERT INTO mca_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","qe tewqeleiƚetaxijik'ui qu' nophe'ƚji' pa'qu' nit'ij. ");
INSERT INTO mca_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma' qa i'nk'aƚe pa'aj, qa not'axets iye pa'aj pe' olootsija milits yamets pe' jukhew qa efuts iye, watkatitij wetepji' pa'aj. Pa' Jesús qa iyet, me yojo in iyetik'ui pe' ƚ'ijatshenhei: —Jeƚi'ƚiju'ƚ ne' ƚeqe levadura ne' fariseol, ikji' in hik ƚunyejei qu' wetsjuk ƚejusitse'. ");
INSERT INTO mca_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qe ham pa'qu' natat'inhetiikii qu'nte' ne'twenheti'ye', qa ham iye pa' qu'nte' netfelhiti'ye' qu'nte' ninikfe'le'. ");
INSERT INTO mca_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qa hik ta'ƚijupi', week pe'qu' it'iƚij na' nookii qa' netpiikaxti'yi' na' na'lkii, qa pe'qu' it'iƚij qu' ajawehentaxi'ƚij wetju'ƚ pe'qu' wititsiyi'ifi, qa' netniya'yijkii qu' netfelhitii pa'qu' ƚ'anuyi'ipji' pe'qu' wititsi'ye'.— ");
INSERT INTO mca_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Qa yakha' qa hit'iƚij ewets, ekheweli'ƚ yijuwaikal, e'nijiweikitek'iƚiju'ƚ ene' yilanƚe ne' esenitsi'ƚ, qe qu' hats nalan qa hats ham iye pa'qu' ƚeqfenyeje'ej. ");
INSERT INTO mca_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Qa yakha'ƚe qa' k'efeli'ƚi'm pa'n ƚii pa'qu' les e'nijiwe'yi'ƚiju'ƚ. E'nijiwe'yi'ƚiju'ƚ nakha' qu' hats nalan qa na'li'm iye na' ƚet'unha'x qu' newu'miiju' nakha' fe't qi iftsax. Ehe, yakha' hit'iƚij ewets, ¡Hane'en hik ha'ne e'nijiwe'yi'ƚiju'ƚha yijat'ij! ");
INSERT INTO mca_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Me nite' te'ninei ne'ej lee'fij (5) papaye'mtsil in ƚaja'aju'ƚ ne'ej wetsjuk ƚ'astakii nijketits ƚelits? Qa nakha'ƚe Dios qa nite' ewii'ƚe' pe'qu' nantapi'ii enewe'en. ");
INSERT INTO mca_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Qa hik ƚunyejei iye, ne' ewkujitsi'ƚ hats week wetjeyumtshen. Qa hik ta'ƚijupi' qu' hasu'uj e'nijiwe'yi'ƚ, ekheweli'ƚ e'weju'ƚi'ƚij ƚ'ani'ƚi'pji' pe'qu' olotsetax papaye'mtsile'.— ");
INSERT INTO mca_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Yakha' hit'iƚij ewets, week pakha' qu' nite' newelkut'e' yijkii qa tetfeliji'm ene' jukhew in tsijayan, qa ha'ne Ƚa's na' Jukhew qa' netetfeljiiji'mek ne' ƚaqa angelits na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Qa pakha'ƚe qu' newelkutyijkii nite' tetfeliji'm ene' jukhew, qa ha'ne Ƚa's na' Jukhew qa' newelkutjiijets kiyek ne' ƚaqa angelits na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Qa week pakha' qu' nit'ij pa'qu' ewi'ƚ wi'tlijeye' t'ejuyiju'ƚ ha'ne Ƚa's na' Jukhew, qa ƚeke'ƚe qu' netwumhiti'yik'ui aka'an. Qa pakha'ƚe qu' nit'ij pekhewe' qu' net'ejuyiju'ƚ nakha' Espíritu Santo qa nite' ƚeke' qu' netwumhiti'yik'ui pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Qu' ekekiti'yi'ƚii nekhewe' witlijtsitjiyits qa qu' ekekiti'yi'ƚetsji' iye nekhewe' wittatal qa nekhewep iye wit'alhei, qa hasu'uj natawje'meteni'ƚ pa'qu' eqfenyejeyi'iƚ ewek qa pa'qu' it'iƚijiju'ƚ iye. ");
INSERT INTO mca_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Qe nakha' Espíritu Santo hik nakha'ija qu' nijatshenij pa'qu' it'ij qu' hats namets qu' iyet.— ");
INSERT INTO mca_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma' qa ewi'ƚ pa'aj pa' jukhew i'nji'teje'm pekhewe' olots pakha'aj, qa yit'ijets pa' Jesús: —Maestro, it'ijets ha' mats qu' nesƚisij pe'ye' qu' natsak'esijek pe' ta'ƚets ka' tata'aƚik'i.— ");
INSERT INTO mca_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Qa pa' Jesús qa yeku'ƚ pa'aj: —Jukhew, ¿pa'n ƚii pa' ts'entaxi' qu' yakha'ye' qu' k'ejeyumtsheni'ƚij pe' ewekwekitsi'ƚ?— ");
INSERT INTO mca_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Qa pa' Jesús qa yit'ijets pe' weekji': —Jeƚi'ƚiju'ƚ week eke' ƚunyejeiƚe wetju'ƚ ejunyejeyi'ƚij in ƚisu'uni'ƚ eke' wekwek, qe ha'ne witiƚa'x nite' yeqethenii qu' olotsi' i'm pe' wekwek.— ");
INSERT INTO mca_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Qa nifeli'm pa' ewi'ƚ yejeyumtshenijupi': —Ewi'ƚ pa' jukhew qi in yiwq'axin wekwek qa olots iye pe' ƚaq'astai, qa pa' ƚeq'ejinqa'wet in hats yamets in yuji' pe' ƚ'enheiju' qa olots iye pe' ƚei. ");
INSERT INTO mca_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Qa pa' patun qa yijamtikii: “¿Paa's qu' yeqfenye'ji'ij ha'ne yenekju'? Hats ham yeqitset'i'ij ene' ƚei.” ");
INSERT INTO mca_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma' qa yit'ij pa'aj: “Ye'ehe aka' qu' yeqfenye'ji'ij. Heni'ttaxijju' enewe' yeqjiikiyij qa' heniihinpha'm iye qa' les hiwqinhet ma' qa' week henifi yijat'ij ene' yenheiju' qa ene' na'l ye'm.” ");
INSERT INTO mca_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma' qa' hitƚi'ij yitets: “Jukhew, hayits qa olots ene' ƚaqsi'j. Weju'ƚij pe'qu' olots ininqapitse', mawapii, qa' ek, qa' iya' qa' e'ƚe'wisi'imkii iye.” ");
INSERT INTO mca_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Qa nakha'ƚe Dios qa yit'ijets: “Nite' ƚ'eqeneƚuikii, hane'ejija ha'ne naja'xji' qu' awa'm qa ne' na'l e'm ƚaqsi'jtax, ¿pa'n ƚii pa'qu' naya'x e'j?” ");
INSERT INTO mca_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aka'an hik aka' ƚunye'j pakha' qu' naqsi'jtax pe'qu' olootse' qu' ƚakha' ye'ƚe qu' net'ejuiƚe'ets, qa hamƚe yiwq'axine' ekewe' t'ejuyets na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma' qa yit'ijji'ju' he' ƚ'ijatshenhei: —Qa hik ta'ƚijupi' qu' hit'iƚij ewets aka'an. Hasu'uj natawje'meteni'ƚ pa'qu' etuji'ƚ qa pe'qu' eqhinatayi'iƚ iye in mexe i'ƚiyi'ƚ, ");
INSERT INTO mca_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","qe na' witiƚa'x les t'anipji' na'aj inaq, qa ha'ne i'naj i'nese'n qa les t'anipji' ek ekewe' witqhinatai. ");
INSERT INTO mca_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jeƚ qeku'ni'ƚju' ek ne'ej o'powil, in nite' wenq'entax qa nite' nit'ijji' iye pe'qu' ƚ'enheyeju', qa hamtax iye pe'qu' ƚextsili'ij qu' naqsi'j pe'qu' ƚeqeye', ƚa'mek na' Dios qa tisijkii pa'qu' netuj. Qa ekheweli'ƚ ¡hayits qa qi qu' e'weju'ƚi'iƚij yijat'ij ƚ'ani'ƚi'pji' ne' junatai! ");
INSERT INTO mca_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Pa'n ƚii ekheweli'ƚ pa'qu' itawje'met'e' qa' naqsiijkii qu' les nijetin eku'nij iye pa' ƚiƚa'x? ");
INSERT INTO mca_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","In nite' ƚeke' qu' aqsiiƚijkii aka' nite' qi ƚammi's, ¿qa inhats'ek in natawje'meteni'ƚ kekhewep iye wekwek? ");
INSERT INTO mca_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jeƚi'ƚju' ne' ƚop'omits (lirios) in t'ijaifik'i. Nite' t'ithayiitax qa nite' taftiƚintax iye. Qa yakha'ƚe qa hit'iƚij ewets ka' Salomon'ik'i in wanaqsii'jtaxija, qa nite' ƚunyejeyiju'ƚ ene' ƚop'om in ƚe'sitswikfi. ");
INSERT INTO mca_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Qa na' Dios in ƚeqjunyejeyij aka'an enewe' uje' qu' nonoxp'onhetji qa' lomomeji' hane'ej na'l jup'elket ta'ƚi' na' ƚ'ejinqa'wet, ye'ehe, qa ekheweli'ƚ qa' les qu' qiye' pa'qu' ƚeqjunyejeyi'iƚ ej, ¡jukhew hayits qa ƚ'inqekuteetsi'ƚkii! ");
INSERT INTO mca_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ekheweli'ƚ, hasu'uj natawje'meteni'iƚ qu' mowo'oƚiikii pa'qu' etuji'ƚ qa pa'qu' iya'aƚji' iye. ");
INSERT INTO mca_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Qe week ene' nite' yijayan na' Dios witsetits ha'ne sehe' epji' enewe'en qi in wo'oi week ekewe' wekwek. Qa nakha'ƚe Atata'aƚ qa hats nikfe'lets in nite' ƚisu'untaxi'ƚ qu' hamitsi'iƚ ejup ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Qa hik ta'ƚijupi', ekheweli'ƚ qa' aftsini'ƚek na' tenek'enheiji' na' Dios, ma' qa' esti'yi'ƚij week ekewe' wekwek.— ");
INSERT INTO mca_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—E'nijiweikitek'iƚ kots'etets nite' olots, qe na' Atata'aƚ hats yiwjutsiqenija qu' neƚisi'ƚij na' tenek'enhe'yi'. ");
INSERT INTO mca_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ihini'ƚij pekhewe' qu' nana'liƚ'em qa pekhewe' qu' ƚ'astaye' qa' ƚisi'ƚijkii pekhewe' ham yiwq'axine'. Aqsi'ji'ƚijkii aq'astajiwotsi'iƚ ti'naj nekhewe' nite' ƚipipji' yijat'ij, hik nekhewe' wekwek ƚe'sits na' wa'sji' nite' yili'ij yijat'ij in na'l. Hik nakha'a' yijat'ij ham pa'qu' ejtenhetsaxe' qu' namii, ham iye nosositetsi'i' qu' netuj. ");
INSERT INTO mca_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Qe pakha' qu' eni'ƚi' pekhewe' qu' ewekwekitsi'iƚ, qa' hikpa' jeek qu' na'ni' ne' atawjetsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Matjanitheni'ƚkii, qa' itujinheti'ƚji' iye pe' efetitjiyitsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hik ejunyejeyi'iƚ pa'qu' jukhewe' qu' natjanithenik'uikii pa'qu' ƚaqa patune' in yamii pa'qu' ewi'ƚ ƚe'wis neƚu witiwhe'yejii, qa in nam qa yilanetskii pa' ƚeji' qa aje'eƚ yit'ijimiiqhof. ");
INSERT INTO mca_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ƚe'sitsi'mkii pe' jukhew in nam pa' ƚaqa patun qa yi'wen in nite' ima'ju'. Yijaa'ija aka' hit'iƚij ewets pa' patun qa' naya'x eku'nijek pe' ƚeqejkunenhei qa ninhinijupjukii pa' mesa qa' nenkunhenju' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ƚe'sitsi'mkii pekhewe'en in nite' yif'eli' iju'ƚ inye'jƚu' qu' ƚeqewuk'uyetaxji' naja'x, i'nƚi'i qu' ipƚu'yi'iju'ƚ neƚu. ");
INSERT INTO mca_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Menikfeliti'ƚets aka'an, pa'qu' ewi'ƚ natsat'axij pe'qu' wititsi'ye' qu' nenikfe'lets pa'n uja'x hora qu' na'naja'xij qu' nanamets pa'qu' ejtenhetsi'le', qa' qi qu' natjanithenik'uikii qa'nte' name'etsji' pe'qu' ƚetsi'ye' qu' net'ejtenij pe'qu' ƚewekwekitse'. ");
INSERT INTO mca_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ekheweli'ƚ iye matjanitheni'ƚkii, qe ha'ne Ƚa's na' Jukhew namji' hatse' pe'qu' horaye' qu'nte' umtiyetaxi'ƚ qu' nanamji'.— ");
INSERT INTO mca_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ma' qa ha' Pedro qa nifaakan pa'aj: —Yatsat'axyij, ¿me yu'ja'xƚi'iƚ qu' it'iƚij yiwets aka' ƚejeyumtshenijupi', me week iye qu' it'ijets?— ");
INSERT INTO mca_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pa' Yatsat'ax'inij qa yit'ij pa'aj: —¿Pa'n ƚii pakha' witqejkunenek tek'en qa nikfe'lkiiha iye, hik pakha' pa' ƚaqa patun qa' neni' qu' nejeƚipji' pe' week ƚeqejkunenhei hats'inha qu' netisji'jij ƚaqe' in hats yamji'jets ƚekujii? ");
INSERT INTO mca_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ƚe'wis pakha' witqejkunenek in ƚunye'j aka'an, qe pa' ƚaqa patun in nam qa yi'wenij in yaqsi'jijkiiha pakha' ƚ'ithayijkit. ");
INSERT INTO mca_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yijaa'ija aka' hit'iƚij ewets pa' patun qa' neni' qu' week netnek'enhe'yij pe' ƚewekwekits. ");
INSERT INTO mca_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Qa qu' nitƚi'ij pa' witqejkunenek pa' ƚatawe'j: “Ha' yaqa patun tees qu' nanam aje'eƚ.” Ma' qa' yapeye'ƚek qa' nilanje'mkii pekhewep ƚ'ithayifets jukhew qa pe' efuts iye, qa tek, qa iya', qa yek'uwet iye. ");
INSERT INTO mca_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pa' ƚaqa patun pa' witqejkunenek qa' nanam pakha' neƚuji' nite' notkitaxji'kii, qa pe' hora iye nite' nikfe'lets qu' nanamji', ma' qa' qi qu' nitanithen qa neni' pakha' ƚeq'itset'ij pekhewe' inqeku'. ");
INSERT INTO mca_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Qa pakha'ƚe qu' witqejkunenek'e in hats nikfe'ltaxets pakha' qu' nisu'untax pa' ƚaqa patun, qa nite'ƚe watji'let, nite' yaqsi'jijkii iye pakha' hats yisu'untax pa' ƚaqa patun, ma' qa' qi iye qu' nitanithen. ");
INSERT INTO mca_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Qa pakha'ƚe qu' nite' nenikfe'le'ets pakha' qu' nisu'untax pa' ƚaqa patun, qa yaqsi'jƚi'ijkii pe' yutentax, qa nite' qi'ija qu' nitanithen. Week pakha' qu' hats netesti'yij pe'qu' olotse', qa' olotse'ji'jek pe'qu' natyajaxti'yijets pakha'an, qa pakha' qu' les olotse' pe'qu' netesti'yij, qa' les olotse'ji'jek pe'qu' netniyinheyijets qu' naqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Yakha' in tsam qe qa' hitujinhetje'm pa'qu' fet'e' ha'ne sehe' ipji'. ¡Hayits qa qi in hisu'untaxija qu' hats netujje'm! ");
INSERT INTO mca_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Qa mexeƚe qu' nojo qu' hempuli'jji' pa' qi a'tax. ¡Hayits qa qi in tsitawje'meten qa' naamƚi'ijii qu' week nijat'etstax! ");
INSERT INTO mca_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Me ƚumti'iƚ in tsam qa' hetisij pa'qu' ƚ'ikesimeyaxitse'ƚekii ha'ne week sehe' ipji'? Nite', yakha' hit'iƚij ewets, in tsam qe qa' neqet'etsju'kii ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Qe hane'ejija qu' nata'ƚi', lee'fij (5) pe'qu' na'nifi pe'qu' ewi'ƚ wititsi'ye' qa' neqet'etsju'kii ƚunyejei, pe' wetshetk'ewi'ƚ qa' ƚ'ejuihifetsi'ij pekhewe' wetsjuk, qa pekhewe' wetsjuk qa' ƚ'ejuihifetsi'ij pekhewe' wetshetk'ewi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Qa' neqet'ets wetju'ƚkii iye, pa' ƚatata qa' ƚ'ejuihifeyi'ij pa' ƚa's, pa' wita's qa' ƚ'ejuihifeyi'ij pa' ƚatata, pe' ƚenene qa' ƚ'ejuihifekiyi'ij pe' ƚasi', pe' ƚasi' qa' ƚ'ejuihifekiyi'ij pe' ƚenene, qa pe' ƚeqewketi' qa' ƚ'ejuihifekiyi'ij pe' ƚefelits, qa pe' ƚefelits qa' ƚ'ejuihifekiyi'ij pe' ƚeqewketi'.— ");
INSERT INTO mca_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma' qa yit'ijji'ju' iye pe' oloots jukhew qa efuts: —In ƚi'weni'ƚii pe'qu' wasi'ye' in nekpha'm ta'ƚiiju' na' tefeji', ma' qa aje'eƚ ƚit'iƚijju': “Nekju'kii hatse'” qa hik aka' ƚunye'j. ");
INSERT INTO mca_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Qa na'aj t'unik'i in ta'ƚji' na' i'wk'uyi'lii, qa ƚit'iƚijju': “Elejei hatse'” qa hik aka' ƚunye'jkii iye. ");
INSERT INTO mca_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Wetsjuk ƚejusits! In ƚenikfe'li'ƚets in ƚejeƚiƚijupkii ekewe' ƚunyejeikii ha'ne sehe' epji' qa na' wa'sji'pha'm iye, ¿qa inhats'ek qu' nite' enikfe'li'iƚets qu' jeƚi'ƚijupkii ha'ne hane'ej ƚahats'ij?— ");
INSERT INTO mca_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—¿Qa inhats'ek in nite' ekhewelƚi'iƚ ete'm qu' ejeƚi'ƚji' qu' ku'mi'ƚi' pa' yatsathen? ");
INSERT INTO mca_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Qe in mexe ƚijayan pakha' qu' net'ejui eju'ƚ qu' neka'xii pekhewe' qu' netnek'enhei, e'meheyi'ij qu' mowo'oi qu' aje'eƚ e'ƚe'sitsi'iƚ wetju'ƚ pakha' wit'ikheyi'jik'i, qa hasu'uj qu' nejufta'xƚi'ij qu' neka'xii pa'qu' jueze', ma' qa pa' juez qa netis e'j pa'qu' oq'opheƚinetsi'le', qa pa' oq'opheƚinetsi'l qa' nuihinifi'ek pe'qu' witq'opheƚitjiye'. ");
INSERT INTO mca_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yakha' hit'ij ewets, in nite' ƚ'atsji'ƚfik'i aje'eƚ ipƚu'ui qu' week ijanin.— ");
INSERT INTO mca_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hik pakha'aj pa' neƚuji' na'l pa'aj pe' uja'x jukhew pakha' i'ni' pa' Jesús, qa nifelimik'i pa' ƚunyejeikii pa'aj pe' jukhew'ik'i Galilea ƚeiƚetsik'i, pa' Pilato in nilanju' pa'aj qa pe' ƚ'athits pekhewe'en qa yetsjiƚkinij pe' ƚ'athits pe' inqa'metetsik'i ƚeqististax pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pa' Jesús qa yit'ijiju'ƚ pa'aj: —¿Me ƚumti'iƚ ekheweli'ƚ aka' ƚunyejeikii pe' jukhew'ik'i Galilea ƚeiƚetsik'i qu' nata'ƚets qu' lees uƚ'etse' wiikfik'i qa' nite' ƚunyejeye' pekhewep Galilea ƚeiƚets iye? ");
INSERT INTO mca_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Qa yakha'ƚe qa hit'iƚij ewets in nite'. Hik qu' ejunyejeyi'iƚ iye qu' nite' menink'aihiti'iƚ pa'qu' ejunyejeyi'iƚ qa' anaxi'ƚju' iye hatse'. ");
INSERT INTO mca_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Ye' me ƚumti'iƚ iye kekhewe' dieciocho (18) jukhew'ik'i in jaƚaq'ipji' ke' qaaxapha'm wititsi'ik'i (torre) na' Siloé ei qu' nata'ƚets iye qu' les uƚ'etse' qa' nite' ƚunyejeye' nekhewe' week i'ni' na' Jerusalén? ");
INSERT INTO mca_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Qa yakha'ƚe qa hit'iƚij ewets iye in nite'. Hik qu' ejunyejeyi'iƚ iye qu' nite' menink'aihiti'iƚ pa'qu' ejunyejeyi'iƚ qa' anaxi'ƚju' iye hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma' qa nifeli'm iye aka' yejeyumtshenijupi': —Ewi'ƚ pa' jukhew na'li'm pe' ewi'ƚ ƚ'enkiju' higokuk yeni'ju' pa' ƚeq'ejinqa'wet. Qa yejeƚtaxii qu' hats netei qa hamƚe pe'qu' ewii'ƚe' ƚe'ye' qu' ni'wen. ");
INSERT INTO mca_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Qa yit'ijets pa' ƚeqjeƚinenek'ij pa' ƚeq'ejinqa'wet: “Jeƚ, hats wetshetk'ewi'ƚ ke' ininqapits in henjeƚji'ijtaxii ene' higokuk qa ham ji'ij hi'wene' ƚeye'. Enfekinju' hatse'. ¿Inhats'ek in natkinƚetax qa yothetƚetaxi'kii ha'ne ƚe'wisji' sehe'?” ");
INSERT INTO mca_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pakha'an qa yit'ijiju'ƚ pa'aj: “Yaqa patun, taaqu' ewi'ƚi'ij qu' iwejinƚe eku'n ha'ne ininqa'pji'. Qa' hef'uƚ'utifikii qa' hiwu'mifi iye ne' wakka ƚi'mhui, ");
INSERT INTO mca_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ma' qa i'nƚi'i qu' hats nana'l hatse' ƚeiye'. Qa qu' ham ƚeiye' iye ma' qa' henfekinju' yijat'ij.”— ");
INSERT INTO mca_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa' Jesús i'nq'ijatshenifi pa'aj pe' ewi'ƚ pekhewe' ƚe'lijtsitjiyits pe' judío pa' ewi'ƚ neƚuji' witwapiihijii (sábado). ");
INSERT INTO mca_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Qa hik pakha' i'ni' pa'aj pe' ewi'ƚ efu hats dieciocho (18) ƚeqe'ninqapitsij pa' ewi'ƚ ƚaatshek ta'ƚets pa' ewi'ƚ inwo'met in i'nji', qa hikpa' nite' yatsathenket qa yit'ij tuufufuf, qa nite' ƚeke' qu' natsathen pa' ƚ'anu. ");
INSERT INTO mca_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pa' Jesús in yi'wen pa'aj qa taya'yii, qa yit'ijets pa'aj: —Efu, hats ik'ek'uifik'i pa' awtshektax.— ");
INSERT INTO mca_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pa' Jesús qa t'eku'mipji' pa'aj pekhe'en, qa hik pakha'aj pe' efu qa ƚeke' in yatsathen pa' ƚ'anu, ma' qa yiwqinhet pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Qa pa' tenek'enhe'yij pe' judío ƚe'lijtsitjii qa qi in nayu'kii, qe pa' Jesús inqiƚinji' pa'aj pa' neƚu witwapiihijiitax. Qa pa' tenek'enhe'yij pe' judío ƚe'lijtsitjii, qa yit'ijji'ju' pe' jukhew qa efuts: —Olots kekhewe' ewi'ƚ tatsai (6) neƚuts qu' ji'nt'ithayiiji', qa hik kekhewe'tax ke' neƚutsji' qu' eneki'ƚijii qa' menqiƚini'ƚji', qa' hasu'uje' pe' neƚutsji' witwapiihijiyits (sábados).— ");
INSERT INTO mca_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma' qa pa' Yatsat'ax'inij qa yeku'ƚ pa'aj: —Ejtitsits hik ƚunyejei qu' wetsjuk'e ƚejusitse', ¿me nite' ƚenit'iƚijii week ewiƚei ekheweli'ƚ pa'qu' wakkaye' oqokoyoyiwo'oƚ i'nƚi'i qu' matikataxe' in yamets na'aj neƚuji' witwapiihijii qu' eka'xi'ƚiiju' pa'qu' iweli'ye' qu' niya'? ");
INSERT INTO mca_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Qa ene' efu, ene'en ta'ƚets ka' Abraham'ik'i qa na' Satanás qa yophe'ƚtaxji' aka' ƚeqfe'met hats dieciocho (18) ƚeqe'ninqapitsij, ¿me nite' ƚe'wisij qu' netenit'ijii na' ƚaatshek ha'ne neƚuji' in witwapiihijiitax?— ");
INSERT INTO mca_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","In yit'ij pa'aj aka'an pa' Jesús, qa pe' ƚ'ejuihifets qa qi in wepin wetju'ƚ pa'aj. Qa pekhewe'ƚe week jukhew qa efuts iye qa qi in ƚe'sitsi'mkii pa'aj in yi'wen eke' qits wekwek yaqsiijkii pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ma' qa pa' Jesús qa yit'ij iye pa'aj: —¿Pa'n ƚii pa'qu' hik ƚunye'je' na' tenek'enheiji' na' Dios? ¿Qa pa'n ƚunye'j pa'qu' hejeyumtshenijupi'? ");
INSERT INTO mca_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hik ƚunye'j ne'ej ewi'ƚ mostaza ƚo' in yeni'ju' na'aj jukhew pa'qu' ƚewenq'enhe'wet'e, qa ƚeyijƚem in ta'ƚ ma' qa najkak'ij, qa ne' junatai qa tupiiji' pe' ƚakjil.— ");
INSERT INTO mca_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Qa yit'ij iye pa'aj pa' Jesús: —¿Pa'n ƚii pa'qu' hejeyumtshenijupi' na' tenek'enheiji' na' Dios? ");
INSERT INTO mca_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hik ƚunye'j ne'ej levadura pe'qu' ewi'ƚ efuye' in yetsjiƚkinij pa'qu' fo'ji'ye' qa wetshetk'ewi'ƚ yamitets pa' ƚeqjeyumtshela'xij in yenpha'm, ma' qa notki'ets ipƚu'ui in hats week yiju'fjufinhetik'i.— ");
INSERT INTO mca_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pa' Jesús in ik pa'aj qu' namii ha' Jerusalén, qa teiƚi'ij iye pa'aj in yijatshenji'ij pe' witsetits qa pe' witsetits ƚelits iye. ");
INSERT INTO mca_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Qa ewi'ƚ pa' nifaakan pa'aj: —Yatsat'axyij, ¿me nite' olots pe'qu' iƚiye'?— Qa yeku'ƚ pa'aj pa' Jesús: ");
INSERT INTO mca_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ment'unhetiƚets qu' uyi'ƚii na' epk'iyit ƚeji', qe yakha' hit'iƚij ewets in olots pe'qu' nenuihiyu'taxii qa nite'ƚe ƚeke'. ");
INSERT INTO mca_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Qa' ink'aye'ƚe na' yatsat'axij ne' wititsi' qa' neniipha'm qa' nit'onji' na' ƚeji', qa ekheweli'ƚ qu' a'maneyi'iƚfik'i qa' ilantaxi'ƚetskii, qa' i'ttaxi'ƚij: “Yatsat'axyij, i'tqeku'ni'ƚij ye'mii qhof.” Qa' neku'ƚi'ƚ nakha'an, qa' nit'ij: “Nite' tsikfe'li'ƚ ej pa'n ƚataƚi'ƚji'.” ");
INSERT INTO mca_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma' qa' yapeye'ƚek qu' ittaxi'ƚijju': “K'eyekufe'ini'ƚkiyek qa k'eyiyafe'eƚkii iye qa akha' iye ƚinq'ijatshenikii ne' yikheijeyi'ƚik'i.” ");
INSERT INTO mca_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma' qa' neku'ƚiƚ nakha'an: “Hats inek hit'iƚij ewets in nite' tsikfe'li'ƚ ewets pa'n ƚataƚi'ƚji'. Me'nitoni'ƚ ye'mii, week nekhewe' yaqsiijkii na' uƚ'ax.” ");
INSERT INTO mca_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Qa' hik nakha'yi'i' qu' qi qu' mapiƚi'ju' qa' nat'aiji' iye ek'unhetiyi'ƚ qu' i'weni'ƚii ka' Abraham qa ka' Isaac qa ka' Jacob qa week iye ke' profetas'ik'i qu' na'ni' na' tenek'enhe'yi' na' Dios. Qa ekhewelƚi'iƚ qa' ewumhiti'yi'ƚfik'i. ");
INSERT INTO mca_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Qa' nanam hatse' pekhewe' qu' nata'ƚii na' neƚu'uju'ƚ, na' tefeji', na' ima'xii, qa na' i'wk'uyi'lii, ma' qa' na'nijupju'kii na' mesa qu' netekiju' na' tenek'enhe'yi' na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ma' hayits, hane'ej na'l ne' teke'lenju' qa' nojo hatse', qa na'l ne' hane'ej yojo qa' netke'lenju' hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma' qa hik pakha'aj qa namets pe' uja'x fariseol qa yit'ijets pa'aj pa' Jesús: —Yape ma'ak'uifik'i iye hane'e'in qa' ma, qe ha' Herodes yisu'un qu' nalan.— ");
INSERT INTO mca_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Qa yeku'ƚ pa'aj: —Ma'aƚii qa' it'iƚijets hakha' ejene'l: “Yakha' hukinfik'ikii ne' inwo'metets, qa henƚinju' iye ne' wanqaats'etaxju', hane'ej qa uje' iye, qa qu' namets wetshetk'ewi'ƚ neƚuts qa' nasqhat'axij aka' yithayijkit.” ");
INSERT INTO mca_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Qa yakha'ƚe qa mexe hakij na' yikheyij, hane'ej, uje' qa neƚukii iye, qe nite' ƚe'wisijupi' pa'qu' ewi'ƚ profetaye' qu' na'nik'uifik'i na' Jerusalén qu' nawa'm. ");
INSERT INTO mca_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén, Jerusalén, ƚanlanju'kii ke' profetas'ik'i, ƚenjele'ejkii utel kekhewe' t'ukinhetiiji'ijtax ei, ¡Pa'n uja'xij in hisu'untax qu' ewi'ƚ heni' ne' elits, qu' hik ƚunye'je' ne'ej ta'a'a' qe ewi'ƚ yeni' ne'ej ƚelits qa uyifi ƚefets, qa nite'ƚe ƚisu'un! ");
INSERT INTO mca_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jeƚ qeku'ni'ƚju' ek na' etset'iƚ qu' hats ham na'ni'i hatse'. Qa hit'iƚij ewets in hats nite' ƚetsweni'ƚ iye hatse', ipƚu'ui qu' hats namets pa' ƚahats'ij qu' ittaxi'ƚij: “¡Qi in ƚe'wis ha'ne namij aka' ƚii pa' Yatsat'ax'inij!”— ");
INSERT INTO mca_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Qa ƚunye'jkii iye pa'aj pa' Jesús in uyifi pe' ƚetsi' pa' ewi'ƚ pekhewe' tenek'enhe'yij pe' fariseol, qe qa' neteki'ƚju' pa' neƚuji' witwapiihijii pa'aj (sábado). Qa pekhewe'en qa aje'eƚ nite' nitalket'ij pa'aj in yejeƚijkii pa'qu' ƚeqfenyeje' ƚewek pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hik pakha' i'ni' pa'aj, ƚ'ejuyi'jii pa' Jesús, pa' ewi'ƚ jukhew wanqaats'e' qhofqhofi'k'i pa' ƚ'ajik'i. ");
INSERT INTO mca_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pa' Jesús qa nifaakan pa'aj pekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pe' fariseol iye: —¿Me ƚenexke'ej qu' netiƚinhetii pa'qu' nanqaats'etax pa'qu' neƚuyeji' in witwapiihijii (sábado)? ¿Me i'nƚi'i qu' nite' ƚene'xkeyi'ij?— ");
INSERT INTO mca_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Qa pekhewe'en qa hamƚe iyete' pa'aj. Qa t'eku'mets pa'aj pa' wanqaats'e', ma' qa yiƚin pa'aj qa yit'ijets qu' nak. ");
INSERT INTO mca_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pa' Jesús qa yit'ijets iye pa'aj pe' fariseol: —¿Pa'n ƚii ekheweli'ƚ pa'qu' nanamik'iju' pe'qu' witijkiye' pa'qu' ƚa'se', i'nƚi'i qu' ƚoqokoyoyiwoye' wakka pa'qu' neƚuyeji' in mexe witwapiihijii, qa' nite' nentsine'pha'm aje'eƚ?— ");
INSERT INTO mca_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Qa nite'ƚe weju'ƚiju'ƚ pekhewe'en qu' nekuƚik'i aka'an. ");
INSERT INTO mca_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pa' Jesús in yi'wenij pa'aj pekhewe' wit'iyinhei in yejeƚji' qa i'niju'kii pe' ƚetsetitits ne' qitsji' pa' mesa'ajup, ma' qa yit'ijets pa'aj aka' ewi'ƚ yejeyumtshenijupi': ");
INSERT INTO mca_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Qu' nana'l pa'qu' niyinij'ejupi' pa'qu' ƚe'wis neƚuye' witiwhe'yejiye', hasu'uj ni'iju' pa'qu' ƚetset'e pa'qu' qiye'ji', qe q'ax iye pakha'an qu' net'eqe'mets iye pakhape' iye qu' les nat'an epji' qu' qiye'ji'. ");
INSERT INTO mca_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Qa pa' iyini'ƚ ei qa' nenek ei qa' nit'ij ewets: “Ƚisij qu' na'ni'ju' nakha' ƚa'niju' hane'en.” Ma' qa' ijayik'ui qi qu' mewepinkii qu' ni'iju' pa'qu' netweifik'i. ");
INSERT INTO mca_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Les ƚe'wis yijat'ij qu' e'niyinhei, qa' ni'iju' pa'qu' netweifik'i. Hats'inha qu' nanam pakha' qu' niyin'ei qa' nit'ij ewets: “Waika', eniipha'm les ente'nijai teje'm yijat'ij.” Ma' qa' hayitse' yijat'ij qu' newqinhetji' week pekhewe' i'nijupju'kii pa' mesa. ");
INSERT INTO mca_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Qe pakha' qu' ƚakha' ye'ƚetax ƚete'm qu' neniwqinhetƚetaxji', qa' hik pakha'ye' qu' newepinkii qu' nite' netiwqinheti'ye'ji'. Qa pakha'ƚe qu' nite' neniwqinhete'ji' qa' hik pakha'ye' yijat'ij qu' netiwqinhetii.— ");
INSERT INTO mca_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pa' Jesús qa yit'ijets iye pa'aj pakha' iyinii: —Qu' aqsiijkii pa'qu' etuj in neƚu'uj, i'nƚi'i qu' naja'xi'ij, qa' hasu'uj iyinii pe'qu' ejuwaikale', hasu'uj iye iyinii pe'qu' ejefetsi'ija qa hasu'uj iye iyinii pe'qu' e'metitsi'im yiwq'axin wekwek qe enewe'en q'ax qu' natqa'tjai ej qu' niyin eyek, ma' qa hats aja'ƚi'ij in neƚis. ");
INSERT INTO mca_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Qu' aqsiijkii ƚe'wis neƚuye' qa' les ƚe'wis yijat'ij qu' iyinii pekhewe' qu' if'iljetsitse', pekhewe' qu' uƚ'etse' ƚewek, pe'qu' onqokitse' qa pe'qu' puk'aletse' iye. ");
INSERT INTO mca_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ma' qa' qiye' yijat'ij qu' e'ƚe'wisi'imkii, qe pekhewe'en ham pa'qu' najaninij. Qa akha' qa' nana'l hatse' pa'qu' aja'ye' qu' iƚiye'tax iye kekhewe' yatsathen.— ");
INSERT INTO mca_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","In yepi'ye' ek'i aka'an pa' ewi'ƚ pekhewe' i'nijup pa' mesa, pakha'an qa yit'ijets pa' Jesús: —Ƚe'wisi'mkii week pa'qu' na'nij ji'teje'm pakha' qi witkujii hatse' pa' tenek'enhe'yi' pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Qa pakha'ƚe Jesús qa yit'ijets pa'aj pakha'an: —Ewi'ƚ pa' jukhew yaqsiijkii qu' qi qu' netekju', qa olots pe' iyinii. ");
INSERT INTO mca_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Qa in yamets pe' hora qu' netekju', qa yukin pa' ƚeqejkunenek qu' niyaji'ik'i pe' hats jutsiqets qu' ƚekufetse': “Yapete' eneki'ƚ. Hats yijat'ets he' aqatsi'ƚ.” ");
INSERT INTO mca_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Qa weekƚe ƚunyejei pekhewe'en in welku't iju'ƚkii. Pa' yojohontax pa'aj qa yit'ij: “Peyijaat'ij, hanee'ij hayaqha'yets pa' ewi'ƚ sehe' qa' hejeƚ eku'nii qe nite' ƚeke' qu'nte' hi'wene'. Qa k'iyinij ewets qu' hasu'uj utenij wat'ij.” ");
INSERT INTO mca_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Qa pakhap qa yit'ijek: “Peyijaat'ij, i'nk'aa'ija hayaqha'yets he' week inyaqsii (10) wakka koyoyoyiwots, Qa' mexe eku'n qu' hijaajin. Qa k'iyinij ewets qu' hasu'uj utenij wat'ij.” ");
INSERT INTO mca_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Qa pakhap iye qa yit'ijek: “Peyijaat'ij, i'nk'aa'ija naxijik'i in heyewhe'yei qa nite' ƚeke' qu' henek.” ");
INSERT INTO mca_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Qa pa' witqejkunenek qa wapilii pa' ƚaqa patun qa week nifeli'm ekewe'en. Ma' qa pa' patun qa qi in nayu'kii, qa yit'ijets pa' ƚeqejkunenek: “If'elitik'i qu' ma'atsfik'i ne' wit'ikheijei ha'ne witsetji' qa' eqe'mets pe' if'iljetsits, pe' uƚ'ets ƚewek, pe' puk'alets qa pekhewe' iye onqokits.” ");
INSERT INTO mca_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ma' qa nam iye pa' witqejkunenek qa yit'ijets pa' ƚaqa patun: “Yatsat'axyij, hats week haqsi'jijkii ka' hats ƚit'ij yiwets qa menjiit qi ha'ne ham i'ni'i'.” ");
INSERT INTO mca_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma' qa pa' patun qa yit'ijets pa' ƚeqejkunenek: “Yape, ma iye qa ma'ak'i ne' i'nfik'i ne' qits wit'ikheijei qa ne' wit'ikheijei ƚelits iye qa' eqe'mets pa'qu' i'wen qa' enka'x met iye, hats'inha qa' notpo'oj ene' yitsi'. ");
INSERT INTO mca_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Qe yijaa'ija aka' hit'iƚij ewets in nite' ewii'ƚe' hekhewe' jukhew k'iyintaxii qu' ƚeke'ye' qu' nijaajin ha'ne qu' netnekui.”— ");
INSERT INTO mca_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Olootsija pa'aj pe' nijayanik'i pa' Jesús, ma' qa tetwek'elaxiju'ƚ pa'aj qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Qu' nana'l pa'qu' ewi'ƚe' qu' nisu'un qu' natsjayan, qa qu' nite' les qiyi'ija qu' netsu'un qa' namitfik'i qu' nisu'unija pa'qu' ƚatataye' qa ƚenene iye, qa pe'qu' ƚewhe'ye'ye' qa ƚelitse' iye, qa pe'qu' ƚamatsitse' qa ƚek'injats iye, qa ƚekutii qa ƚek'injai iye qa ƚakha' iye pa' ƚiƚa'x qu' namitfik'i wiikfik'i qu' nisu'un, qa' nite' ƚeke'ye' qu' yijatshenek'i'ij. ");
INSERT INTO mca_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Qa pa'qu' nite' net'ekumi'i pe'qu' ƚeqe cruze' qa' natsjayantax, nite' ƚeke'ye' qu' yijatshenek'i'ij. ");
INSERT INTO mca_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Qe, ¿pa'n ƚii ekheweli'ƚ pa'qu' qu' nisu'un qu' naqsiijkii pe'qu' ewi'ƚ qaaxaye'pha'm wititsi' (torre), qu' nite' nojoye' qu' na'n eku'nijju' qu' nejeyumtshenji' pa'qu' uja'xe' pe'qu' nanaxi', hats'inha qu' nenikfe'lets me weju'ƚij pe' ƚaq'astai qu' nijat'ax? ");
INSERT INTO mca_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Qu' naf'aliƚi'ij qu' nitsupintaxju' pe'qu' ƚetku'ye' qa nite' nijat'axe' qe nite' weju'ƚij pe'qu' ƚ'astaye', ma' qa week pe'qu' niwenji'ij qa' nawitjijiijikii ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Qa' nit'ijju': “Ha'ne jukhew in yitsupintaxju' ne' wititsi' qa nite'ƚe yaqhat'axij.” ");
INSERT INTO mca_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","I'nƚi'i pa'qu' ewi'ƚ wittataye' qu' nanwatlanheyu'uƚ pakhape' iye wittataye' ¿me nite' yojo iye qu' mexe na'n eku'nijju' qu' nijamti eku'nijupkii pe' diez mil (10.000) oq'opheƚinetsilets me les qu' t'unitse' qu' nat'anipji' pe' veinte mil (20.000) oq'opheƚinetsilets ƚelits pakha' t'ejuyiju'ƚ? ");
INSERT INTO mca_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Qa qu' nite'ƚe ƚeke'ye' qu' net'ejuyiju'ƚ, qa pa' wittata in mexe toxiju'ƚ ma' qa' nukiniju'ƚ aje'eƚ pe'qu' ƚeqejkunenheye' qu' niyinijets pa'qu' nisu'un qa' week netisij hats'inha qu' ƚe'sitsi'iƚ wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hik aka' ƚunye'j, pa'qu' ƚunye'je'ƚe ekheweli'ƚ qu' nite' weeke' qu' niwu'm pe'qu' nana'li'm, qa nite' ƚeke' qu' yijatshenek'i'ij. ");
INSERT INTO mca_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Qe na'aj witlepinek ƚe'wistax. Qa qu'nte' ek'eme'ye'ji', ¿pa'n qu' ƚunye'je' qu' ƚeke'ye' qu' newetk'emetji' iye? ");
INSERT INTO mca_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ham weju'ƚi'ij, nite' weju'ƚij iye ha'ne sehe' epji', qa nite' weju'ƚij iye na'aj yi'sinhetji' sehe' (abono), qa' netwu'mhitiiƚefik'i. Pakha' qu' nana'l ƚekfiye' qa' nepiye'ek'iha aka'an.— ");
INSERT INTO mca_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Week pekhewe' yijaninkii wekwek t'ejuyets pa' witset Roma, qa pekhewe' iye titijiti'yijets in qi in uƚ'ets jukhew qa efuts iye, qa nekets pa'aj pa' Jesús qu' nepiye'. ");
INSERT INTO mca_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pe' fariseol qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa yejefitki'ijipji' pa'aj qa yit'ijju': —Ha'ne jukhew t'eku'miju'ƚ ene' qi uƚ'ets jukhew qa efuts iye, qa ƚekufetskii iye.— ");
INSERT INTO mca_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma' qa pa' Jesús qa nifeli'm aka' ewi'ƚ yejeyumtshenijupi': ");
INSERT INTO mca_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Pa'n ƚii ekheweli'ƚ pa'qu' nana'li'm cien (100) kots'etetse' qa ewi'ƚ pe'qu' hami'iikii, me nite' yiwejinƚe eku'ni' pe' noventa y nueve (99) pa' ƚ'ejinqa'wet, qa qi qu' nowo'oikii pe' hamiikii ipƚu'ui in yi'wen? ");
INSERT INTO mca_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma' qa in yi'wen qa tik'eyifi qa yeni' ƚowonje' qa qi in ƚe'wisi'mkii qe hats yi'wen pe' hamtaxiikii. ");
INSERT INTO mca_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Qa in yamii pe' ƚetsi' qa no'thet wetju'ƚ week pe' ƚejuwaikal qa pe' metitsi'm iye qa yit'ijets: “Week je'ƚe'sitsi'imkiiha qe hats hi'wen ha'ne hamtaxiikii kots'etax.” ");
INSERT INTO mca_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yakha' hit'iƚij ewets in hik ƚunye'j aka'an, pa'qu' ewi'ƚe' in yili'ij in yaqsiijkii pa' uƚ'ax qa yi'nk'aihit pa'qu' ƚunye'je', ma' qa qi in ƚe'sitsi'mkiiha na' wa'sji', qe ta'ƚets pakha'an, qa nite' hik ƚeqjunyejeyij pe' noventa y nueve (99) yatsathen in hats nite' hamik'ui qu' ni'nk'aihit pa'qu' ƚunyejeye'.— ");
INSERT INTO mca_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—I'nƚi'i pe'qu' efuye' qu' nana'li'm week inyaqsii (10) ƚ'astai nijketitse' (plata) inyetets, qa ewi'ƚ pe'qu' nanamju'. ¿Me nite' aje'eƚ yitujinhetji' pe' fetitjii qa yit'iji' pe' ƚexp'ilasineti' in wo'oikii ipƚu'ui in yi'wen qa yili'ij? ");
INSERT INTO mca_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Qa in yi'wen qa no'thet wetju'ƚ pe' ƚejuwaikakii qa pe' metitsi'm iye, qa yit'ijji'ju': “Week je'ƚe'sitsi'imkiiha qe hats hi'wen ene' hamtaxiikii yaq'astaki'.” ");
INSERT INTO mca_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hit'iƚij ewets, in hik ƚunyejei aka'an ne' ƚaqa angelits na' Dios, in qi in i'nji'teje'm pa' witisa'xi'mkii nekhewe'en, qe ta'ƚets pa'qu' ewi'ƚe' in wenink'aihit qa yili'ij pa' uƚ'ax in yaqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pa' Jesús qa yit'ij iye: —Ewi'ƚ pa' jukhew wetsjuk pe' ƚelits. ");
INSERT INTO mca_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pa' omehe' qa yit'ijets pa'aj pa' ƚatata: “Tata, esƚisij hane'ej week pa' uja'x pekhewe' tsatsat'etsijek.” Ma' qa pa' ƚatata qa yejeyumtshenij pekhewe'en pe'qu' natsat'etsijek. ");
INSERT INTO mca_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma' qa uja'x pe' neƚutsik'i pa'aj, pa' omehe' qa ewi'ƚ yeni' pe' week ƚewekwekits, ma' qa ik qa yamii pa' toxii witset. Qa hikpa' naq'axiji' nite' yoksi'wenik'i pe' ƚaq'astayik'i wekwekƚe pe' taqhayijets. ");
INSERT INTO mca_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma' qa in hats week naq'axij pe' ƚaq'astayik'i, qa nam pa'aj pa' qi yipku' pakha' witset. Ma' qa yapeƚek pa'aj pakha'an qa qi in iyipkun pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma' qa wo'oikii ƚ'ithayiwet'e. Qa yi'wen pa' ewi'ƚ jukhew tetseti'yi' pakha'an, ma' qa yukinii pa' ƚeq'ejinqa'wet qa yithayinenij pe' ƚeƚinhei tafitets. ");
INSERT INTO mca_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Qa yaqaamij qu' netuj pe' tafitets ƚaqats ƚei ne'ej najkak algarroba, qe ham testiyi'ij ƚaqe'. ");
INSERT INTO mca_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ma' qa yijamtikii pa'aj, qa yit'ij: “Olots he' t'ithayi'yi' ke' ƚetsi' ha' tata qa na'l na'aj amanfik'i wityejket, qa hane'ej yakha' qa naq'aliyuyij yiyipku' ha'ne ha'ni'.” ");
INSERT INTO mca_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Qa' hapilii hane'ej ha' tata, qa hit'ijets: “Tata, yakha' yuƚ'ax. Nite' heik'enets pa' Dios qa akhap iye qa nite' heik'en ewets iye. ");
INSERT INTO mca_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nite' ye'weju'ƚij qu' it'ij yiwets, ya's. Umti yijat'ij qu' eqejkunenek'eyij.” ");
INSERT INTO mca_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma' qa niipha'm, qa ik pa'aj qu' napilii pa' ƚatata. Qa k'esiyu'ui pa'aj pe' ƚetsi', ma' pa' ƚatata qa yi'weniju'ƚ qa qi in neq'eletij pa'aj. Qa wekuma'xiju'ƚ pa'aj, qa tik'eyi'ƚ wetju'ƚ, qa wetƚu'uƚ iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma' qa iyet pa'aj pa' jutjana'x, qa yit'ij: “Tata, yakha' yuƚ'ax. Nite' heik'enets pa' Dios qa akhap iye qa nite' heik'en ewets iye. Nite' ye'weju'ƚij qu' it'ij yiwets, ya's.” ");
INSERT INTO mca_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Qa pakha'ƚe ƚatata qa yit'ijets pa'aj pe' ƚeqejkunenhei: “If'elitiƚik'i qu' enka'xi'ƚ ne' les ƚe'sits witqhinatai qa' uihiniƚik'ipha'm. Enka'xi'ƚ iye ƚayaqsi'ye' qa' iyaqsineni'ƚji' iye, qa' ƚ'otshilaxtiye' iye qa' otshini'ƚji' iye. ");
INSERT INTO mca_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Enka'xi'ƚ hakha' we'nujeninƚe wakka ƚa's, qa' ilani'ƚ, qa' hikha' jinteƚuj qu' jintaqsiijkii pa'qu' ƚe'wis neƚuye'. ");
INSERT INTO mca_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Qe ha'ne ya's humtitax qu' hats nawa'm qete'e' mexe iƚa'x iye. Hamtaxiikii qa hane'ej qa jite'wen iye.” Ma' qa hik pakha'aj qa yenju' qu' naqsiijkii pa' ƚe'wis neƚu. ");
INSERT INTO mca_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Qa pakha'ƚe ajit wita's qa mexe i'ni' pa'aj pa' ƚ'ithayi'wet pa' ƚ'ejinqa'wetji'. Ma' qa in tepil pa'aj, qa k'esiyuu'etsha pe' ƚetsi' qa yepi'ye' pe' fiƚii qa pe' t'otoi iye. ");
INSERT INTO mca_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma' qa taya'yii pa' ewi'ƚ pekhewe' ƚeqejkunenhei qa nifaakanij pa'aj: “¿Pa'n ƚunye'jkii pe' t'otoi?” ");
INSERT INTO mca_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Qa pa' witqejkunenek qa yeku'ƚ pa'aj qa yit'ij: “Qe hats nam ha' ek'ini'j. Qa ha' atata qa inaqyaji'ij kakha' we'nujenin wakka ƚasik'i qa talanhetii, qe ha' ek'ini'j ham ƚunye'je'kii in nam.” ");
INSERT INTO mca_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma' qa nayu'kii pa'aj pakha'an, qa nite' nuihiyu'ufi pe' wititsi'. Ma' qa pa' ƚatata qa uyetsfik'i pa'aj, qa qi in iyintaxijets qu' nuiteje'm. ");
INSERT INTO mca_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma' qa yeku'ƚ pa'aj qa yit'ijets pa'aj pa' ƚatata: “Akha' ƚenikfe'lets in olots ininqapits in he'yithayii e'mkii, qa ham pa'qu' nite' heik'eni'ik'i qu' it'ij yiwets, ƚa'mek qa nite' les qu' esƚisi'ij pe'qu' ewi'ƚe' kots'eteika'ye' qu' hilan qa' hekunhenij ne' waikal. ");
INSERT INTO mca_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Qa hane'ej in nam na' oqwomehe', hik nakha' naq'axƚi'iji' ke' aq'astayik'i pe' witqesul, qa hane'ej qa ƚilanik'ui ka' t'ujei wakka ƚasik'i.” ");
INSERT INTO mca_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma' qa pa' ƚatata qa yit'ijets pa'aj: “Ya's, akha' ƚa'nyijupkii. Qa week ene' yiwekwekits akha' eƚ'ewi'ƚƚe in ƚantsat'etsij. ");
INSERT INTO mca_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Qa lesƚe ƚe'wisij qu' jitaqsiijkii pa'qu' ƚe'wis neƚuye' qa' ƚe'sitse' ine'mkii, qe hane'en, ha'ne ek'ini'j humtitax qu' hats nawa'm qete'e' mexe iƚa'x. Hamtaxiikii qa hane'ej qa jite'wen iye.”— ");
INSERT INTO mca_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pa' Jesús nifeli'm pe' ƚ'ijatshenhei aka' ewi'ƚ ƚunye'jkii: —Na'l pa'aj pa' ewi'ƚ jukhew qi in yiwq'axin wekwek. Qa na'l pa'aj pa' ewi'ƚ ƚeqjeƚinenek'ijik'ui pe' yatsat'etsij. Pa' patun qa tefelhiti'yi'm pa'aj in hats naq'axƚi'ijik'iju' pekhewe' yejeƚinentaxij ƚ'astai. ");
INSERT INTO mca_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pa' patun qa iyinii pa'aj, qa yit'ijets: “¿Inhats'ek aka' heifelhiti'yi'm eq'inye'j? Ika'ajji' pa'qu' witfaakanek'e week pekhewe' hane'ej ithayijkitits, qe hats nite' ƚeke' qu' k'eyeqjeƚinenek'i'ij.” ");
INSERT INTO mca_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pa' witeqjeƚinenek qa qi in yijamtikii pa'aj, qa yit'ij: “¿Pa'n ƚii pa'qu' ƚeke'ye' qu' haqsiijkii hane'ej in hats tsilinenij ha' yaqa patun ha'ne yithayijkittax? Hats nite' yet'un qu' hithayiki ha'ne sehe'. Qa hewepinij iye qu' nek'iyinƚekii.” ");
INSERT INTO mca_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ye', hats tsikfe'lets aka' qu' yeqfenye'je' yiwek hatse', qa' nana'l pe'qu' qi qu' neneqjunu'yij qu' natsamji'jii pe'qu' ƚetsile qu' hamtax hatse' yithayijkit'e. ");
INSERT INTO mca_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ma' qa iyinji'jii ewii'ƚji'ij pekhewe' t'eku'mi' pa'aj pa' patun. Pa' nojo'oi qa nifaakan pa'aj: “¿Pa'n uja'x pe' ƚ'eku'mi' ha' yaqa patun?” ");
INSERT INTO mca_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Qa yeku'ƚ pa'aj: “Cien (100) yamijets ke' ƚeqjeyumtshenki' eƚi'ni ka' aceite.” Qa pa' witeqjeƚinenek qa yit'ijets: “Ehe, hane'en afaakane'k, if'elitik'i qu' niju' qa' ika'ajji' qu' cincuentaye'ƚi'ij (50).” ");
INSERT INTO mca_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Qa pakhap iye qa nifaakan iye: “Qa akha', ¿pa'n uja'xek pe' ekumhifkinel?” Qa yeku'ƚ qa yit'ij: “Ciennij (100) ke' ƚeqjeyumtshenki'ij coro ke' trigo fooji'ij.” Qa yit'ijets iye: “Ehe, hane'en afaakane'k, ika'ajji' qu' ochentaye'ƚe (80).” ");
INSERT INTO mca_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pa' patun qa yaqan in teqenij pakha' nite' yatsathen ƚeqjeƚinenektax, qe pakha'an yiya'yij ƚewek pa'qu' ƚeq'inye'je' in iyowk'elax. Qe pekhewe' yatsat'etsij ha'ne sehe', pekhewe'en les in nikfe'lets pa'n ƚunye'j in i'nji'teje'm ha'ne sehe' ipji', qa nite' hik ƚunyejei nekhewe' i'ni' na' na'lkii in nite' nikfe'letsha pa'n qu' ƚunyejeyi'ija in i'nji'teje'm na' na'lkii. ");
INSERT INTO mca_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Qa yakha'ƚe qa hit'iƚij ewets, anaxi'ƚij pe'qu' ejuwaikali'iƚ qu' nata'ƚets qu' ƚe'wis qu' anatkini'ƚ ekewe' nite' ƚe'sits wekwek qa ƚ'astai iye ha'ne sehe' epji' qu' i'feni'ƚ pekhewepe', hats'inha qu' hamitse'tax ejup ekewe'en, hats ƚek na'l pe'qu' neneqjunu'uƚ eju'ƚ qu' amtaxi'ƚii ne' etsili'ƚ na' wa'sji'. ");
INSERT INTO mca_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pakha' qu' net'ekumi'ha pa'qu' ƚammi'se'ƚetax, qa' net'ekumjiiha'ek pa'qu' qiye'. Qa pakha' qu' nite' net'ekumi'iha pa'qu' ƚammise', qa' nite' jeek net'ekumi'iha pa'qu' qiye'tax. ");
INSERT INTO mca_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Qa hik ta'ƚijupi', qu' nite' ku'mi'iƚi'ha qu' ƚe'wis qu' anatkini'ƚ ekewe' nite' ƚe'sits wekwek qa ƚ'astai iye ha'ne sehe' ipji', ¿qa pa'n ƚii pa'qu' nite' na'nuteni'iƚij hatse' qu' neƚisi'ƚij nekhewe' yijaalija yijat'ij in ƚe'sits wekwek? ");
INSERT INTO mca_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Qa qu' nite' ku'mi'iƚi'ha qu' anatkini'ƚ ekewe' nite' ƚantsat'etsi'ƚij, ¿qa pa'n ƚii pa'qu' neƚisi'ƚij hatse' pekhewe' ƚantsat'etstaxiƚijha? ");
INSERT INTO mca_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ham pa'qu' witqejkunenek'e qu' ƚeke'ye' qu' net'ithayi'yi'm pe'qu' wetsjuk'e patunits, qe i'nƚi'i qu' nuten pa'qu' ewi'ƚe' qa pakhape' qa' nisu'un, qa i'nƚi'i qu' nite' nanqatsit'i'ij pakhap qa pa' ewi'ƚ qa' nuten. Nite' ƚeke' qu' week aqa patunitsi'iƚij na' Dios qa eke' ƚ'astai.— ");
INSERT INTO mca_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pekhewe' fariseol, in uja'xƚi'i in qi in yisu'un eke' ƚ'astai, pekhewe'en qa yilaki'ijju' yawitji'iji' ƚe'lijei pa'aj pa' Jesús in yepi'ye' ej in yit'ij pa'aj ekewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pa' Jesús yit'ijets pa'aj: —Ekheweli'ƚ, hik ekheweli'ƚ nekhewe' wattsathenketƚetaxik'ui qe yi'wen ene' jukhew, qa nakha'ƚe Dios qa hats nikfe'lets ne' atawjetsi'ƚ, qe ene' jukhew na'aj qi qe yiwqinhettax qa nakha'ƚe Dios qa qi in yutenija.— ");
INSERT INTO mca_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Kekhewe' hayiits qa kekhewe' iye ƚe'lijei ke' profetas'ik'i yamijii in hats nam ka' Juan Bautista'ik'i. Ma' qa hik aka'aj tefelhitii na' tenek'enheiji' na' Dios, qa week in qitax in went'unhetetsji' qu' nuiji'teje'm nakha'an. ");
INSERT INTO mca_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nite' jutsitax qu' nili'ij pa' ƚunye'j na' wa's qa ha'ne sehe', qa nite' hik ƚunyejei ekewe' yika'ajji' pa'aj ka' Moises'ik'i wenit'ij qu' nanaqsiijkii, in jutsitax qu' nawa'mik'i nite' iye pe'qu' ewii'ƚe' witq'ikati'ye'.— ");
INSERT INTO mca_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Pa'qu' jukhewe' qu' nili'ij pe'qu' ƚewhe'ye'ye' qa' tujtseika'ye' pe'qu' ƚewhe'ye'yi'ij, ma' qa hats yaqsiijkii aka' witwuƚ'ax (adulterio), qa pakha' qu' ƚewhe'ye'yi'ij pekhe' qu' neweqle, ma' qa hats yaqsiijkii iye aka' witwuƚ'ax (adulterio).— ");
INSERT INTO mca_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Na'l pa'aj pa' ewi'ƚ jukhew qi in yiwq'axin pe' wekwek, yeqhinataji'kii pa' witpalinek pe' ƚe'sits qa inyetets iye witqhinatai. Qa week neƚuts qa qiji'ij qa tekji'ijju'. ");
INSERT INTO mca_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Qa na'l iye pa'aj pa' ewi'ƚ jukhew ham yiwq'axine' ƚii Lázaro. Qi in ƚoq'oqkii pa' ƚ'ajik'i qe tajametei qa i'njiikii pa' ƚeqeji'ji' pa' yiwq'axin wekwek. ");
INSERT INTO mca_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pakha' if'iljetsax yisu'untax qu' niƚinij pekhewe' ƚaqamhiltiiju'kii ƚapk'asil pe' ƚaqats pa' yiwq'axin wekwek. Qa pe' nunajits qa nilepinkii pa' ƚoq'oqkii ƚ'ajik'i pa' jukhew if'iljetsax. ");
INSERT INTO mca_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Qa yamets pa'aj pa' ewi'ƚ neƚu ma' qa wa'm pa'aj pa' if'iljetsax jukhew'ik'i. Qa pe' angelits qa yeka'xii na' i'ni' ka' Abraham'ik'i. Qa wa'm iye pa'aj pa' wekwek yiwq'axin qa tajkati'yik'ui pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Qa yamii pa' fe't ƚe'nq'itset'ij pe' naxju' (Hades), qa qi in yejtsi'le'kii qe yaats'etax. Ma' qa nejeƚtaxpha'm pa'aj, qa yi'weniiteje'm pa'aj ka' Abraham'ik'i, ewi'ƚ i'ni'ƚi' pa' Lazaro'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma' qa tayaitax pa'aj qa yit'ij: “Tata Abraham, e'nq'elet qeku'nyij wat'ij. E'nukin qeku'nyii na' Lázaro qu' neqhimit ne' ƚayaqsi' qa' e'nukinij met qu' neqhimit ha'ne yilepep. Hats qitax in elejeitax ye'mji' ha'ne fe't.” ");
INSERT INTO mca_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Qa kakha'ƚe Abraham yeku'ƚ pa'aj, qa yit'ij: “Ya's, menikfelitik'i akha' qi in e'ƚe'wisju' in mexe iƚa'x. Ham hame'em. Qa ha'neƚe Lázaro qa qi in if'iljetsax in mexe iƚa'x. Qa hane'ej qa yineq'elet qa tetka'xii hane'e'in qa akha'ƚe qa qi'ek qu' enejtsi'le'kii. ");
INSERT INTO mca_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Qa na'l iye ha'ne qi in akaptax jite'wetshen wetju'ƚ. Qa hik ta'ƚijupi' ene' hane'e'in in nite' ƚeke' qu' namii nakha' ƚa'ni'. Qa nekhewe' nakha' i'ni' ek qa nite' ƚeke' iye qu' nanamii ha'ne ha'ni'ƚi'.” ");
INSERT INTO mca_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ma' qa pa' yiwq'axin wekwek qa yittaxij iye pa'aj: “Enq'elet qeku'nyij wat'ij tata Abraham, qu' ukinii na' Lázaro ke' ƚetsi' ha' tata. ");
INSERT INTO mca_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Hikha' i'ni' he' lee'fij (5) yejefets qu' niyetik'ui, hats'inha qa'nte' nanami'ii iye hatse' ha'ne ƚetset pa' qi a'tax.” ");
INSERT INTO mca_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Qa ka' Abraham'ik'i qa yit'ijiju'ƚ iye pa'aj: “Hekhewe'en hats inek na'li'm ke' ƚe'lijei ka' Moises'ik'i qa ke' profetas'ik'i. Hik kekhewe'tax qek netk'enets.” ");
INSERT INTO mca_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Qa yeku'ƚ iye pa'aj pa' wekwek yiwq'axintax pa'aj: “Ehe, tata Abraham, na'ltaxi'm. Qa lesƚe ƚe'wis qu' nenethinets pa'qu' iƚa'xe' iye qu' hats nawa'mtax, ma' qa' hayitse' yijat'ij qu' netk'enetsha hekhewe'en ma' qa' nili'ij pe' uƚ'ets in yaqsiijkii qa ni'nk'aihit pa'qu' ƚunyejeye' pe' ƚatawjets.” ");
INSERT INTO mca_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka' Abraham'ik'i qa yit'ijiju'ƚ iye pa'aj: “Qu'nte' ne'nk'enhe'yuyiik'i ke' ƚe'lijei ka' Moises'ik'i qa ke' profetas'ik'i iye, qa'nte' jeek ne'nk'enhe'yuye'ets pa'qu' nittaxijets qu' nenethintaxets pa'qu' iƚa'xe' iye qu' hats nawa'mtax.”— ");
INSERT INTO mca_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pa' Jesús qa yit'ijets iye he' ƚ'ijatshenhei: —Nite' ƚeke' qu' hami'ik'ui pakha' qu' nilanheninijifi pe'ye' pakhape' iye, qa ¡hiyee' ha'nus pakha' qu' ninaqlanhenijifi pe'ye'! ");
INSERT INTO mca_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Les in nite' iftsax qu' nonopheƚijifi ƚaqawe'j ne'ej qi ute t'ejuyets na'aj we'neqhipitju' qa' netwumhitiiji'ju' pa' qi iweli', qa nite' hik ƚunye'j in uƚ'ax wiikfik'i in yaqsijkinenijkii pa'qu' uƚ'axe' enewe' hik ƚunyejei mente' qits. ");
INSERT INTO mca_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Jeƚi'ƚwet otok'oiha! Pa'qu' ejefeye' qu' naqsi'j e'mijkii pa'qu' uƚ'axe', aq'ayinij. Qa qu' niliƚi'ij qa yi'nk'aihit pa'qu' ƚatawe'je', qa ku'miju'ƚ qu' e'ƚe'sitsi'iƚ wetju'ƚ iye. ");
INSERT INTO mca_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Qu' sieteyi'ij (7) qu' naqsi'j e'mijkii pa'qu' uƚ'axe' in ewi'ƚ neƚu, qa siete'ej (7) iye qu' netpilij ewetskii, qu' ni'tjiij ewets: “Tsaf'ali'ƚi'ij,” qa' ku'mjiiju'ƚ qu' e'ƚe'sitse'jiiƚ wetju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma' qa he' apóstoles qa yit'ijets pa'aj pa' Yatsat'ax'inij: —Ijatshenfik'iha wat'ij qu' iwqinheti'ƚ ye'mha pakha' nite' yeqekuyejeitaxi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pa' Yatsat'ax'inij qa yeku'ƚ pa'aj: —Qek hik ƚuk'eye' pa'qu' nana'liƚ'em nite' eqekuyejeyi'ƚ ne'ej mostaza ƚo', ma' qekha ƚeke'ye'tax qek it'iƚijets ene' najkak: “Ijayik'ui ha'ne ƚa'ni' qa' niji'ju' na' qi iweli'.” Ene' najkak qekha netk'entaxik'i.— ");
INSERT INTO mca_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—¿Pa'n ƚii ekheweli'ƚ pa'qu' nana'li'm pa'qu' ƚeqejkunenek'e in yefuƚ'ut pa'qu' sehe'ye' i'nƚi'i qu' naqakinenkii pe'qu' ƚeƚinheye' kots'etets, qa in tepilik'ui pa'qu' ƚ'ejinqa'wet'e, me qa' nit'ijets: “Te'ƚun qa niju' qa ek”? ");
INSERT INTO mca_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Me nite' yit'ijets yijat'ij: “Aqsi'j eku'n ye'mijkii pa'qu' yaqe'. Manaqsi'j qa' ets'ithayiki eku'niji' ipƚu'ui qu' hats hili'ij qu' heyek, ma' qa' ink'aye'ƚe qu' ekek eku'nek”? ");
INSERT INTO mca_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Me qa wetfeliji'm iye qu' nit'ijets ƚe'wisij qe yaqsi'ji'mijkii pakha' hats yiyaji'ijets? ");
INSERT INTO mca_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Qa hik ejunyejeyi'ƚ ekheweli'ƚ, qu' hats week aqsiiƚijkii pe'qu' hats ayajaxti'yi'ƚijets qa' les ƚe'wis qu' it'iƚij: “Yekheweli'ƚ yewitqejkunenheyiƚ, ham yewejuƚi'iƚij, qe uja'xƚe in haqsi'ji'ƚijkii kekhewe' hats haiyajaxti'yi'ƚijets qu' haqsiiƚijkii.”— ");
INSERT INTO mca_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Qa ƚunye'jkii iye pa'aj, pa' Jesús in ik qu' namii ha' Jerusalén qa nek ji'teje'm pa'aj pa' ƚ'axka'thel wetju'ƚ pe' sehel Samaria qa Galilea. ");
INSERT INTO mca_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","In hats k'esiyu'uiha pa'aj qa' nakji'teje'm pa' ewi'ƚ witset ƚa's, qa nekfik'ikii pa'aj pe' week inyaqsii (10) yamets jukhew i'nij pa' witja'me't lepra. Pekhewe'en qa mexeƚe totsi'mii pa'aj pa' ts'ap'a'aju', ");
INSERT INTO mca_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","qa yit'unhetik'i pa'aj in yithiniju'ƚ, qa yit'ijju' pa'aj: —Jesús, Maestro, enq'eleti'ƚyij wat'ij.— ");
INSERT INTO mca_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Qa pa' Jesús in yi'wenii pa'aj qa yit'ijets: —Ma'aƚii qa' me'nethiniƚets pekhewe' pa'il.— Qa in ikkii pa'aj qa hamitsiikii pe' ƚaja'metets pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma' qa pa' ewi'ƚ pa'aj pekhewe'en, in wetjeƚ in hats naxpa'l, qa mexe tepilƚetepji' pa'aj qi in yit'unhetik'i pa'aj in qi in yiwqinhetji' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Qa wonokok'enifi pa'aj pa' Jesús yamitetsju' ƚotkoyek sehe', qe yiwjutsiqeni'm in qi in ƚe'wisij in yiƚin. Ha'ne jukhew Samariaƚe ƚeiƚe'. ");
INSERT INTO mca_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pa' Jesús qa yit'ij pa'aj: —¿Me nite' week inyaqsii (10) hekhewe' hats naxpa'lij? ¿Qa kheweye'ek hekhewep ikwetju'ƚ tatsai (9)? ");
INSERT INTO mca_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Me hamija pa'qu' ewi'ƚe' qu' netpil eku'nƚetepji' qu' niwqinhetji' na' Dios, qa ewi'ƚƚe ha'ne jukhewiika'?— ");
INSERT INTO mca_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pa' Jesús qa yit'ijets pa'aj pa' jukhew: —Eniipha'm qa ma, pa' nite' eqekuye'j ta'ƚets in ƚanaxpa'lij ka' awtshektax.— ");
INSERT INTO mca_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pekhewe' fariseol qa nifaakan pa'aj pa' Jesús: —¿Pa'n ipƚu'uk'ui qu' nanam pa' tenek'enheiji' pa' Dios?— Pa' Jesús qa yeku'ƚ pa'aj: —Na' tenek'enheiji' na' Dios in nam nite' hik ƚunye'j na'aj na'l na'aj jutsiqaxij in jite'wen. ");
INSERT INTO mca_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nite' ƚeke' iye qu' netitijitiyijets: “Ha'ne i'ni'in,” i'nƚi'i qu' nenit'ij “ha'niite'ji' pa' i'ni',” qe na' tenek'enheiji' na' Dios hats i'ntaxi'ƚ etji'teje'm.— ");
INSERT INTO mca_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Qa yit'ijets pa'aj he' ƚ'ijatshenhei: —Yamets hatse' pa' ƚahats'ij ekheweli'ƚ qu' qi qu' eneqwenkeyu'taxi'ƚij pa'qu' ewi'ƚe' neƚuyeji' ha'ne Ƚa's na' Jukhew. Qa teesƚe qu' ƚeke'ye' qu' i'weni'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma' qa' nenit'iƚij ewets: “¡Ha'ne qe i'ni'in! ¡Ha'niite'ji' pa' i'ni'!” Makitek'iƚii, hasu'uj iye ijayani'ƚii pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Qe hik qu' ƚunye'je' na'aj etheluna'x qe lepep lepep qa pekhel na'likii na' wa'sji'pha'm qa toxii in jite'wenii, qa hik qu' ƚunye'je' hatse' qu' nanamtax iye ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Qa lesƚe ƚe'wis qu' nojo qu' qi qu' nataatshenhetii ha'ne Ƚa's na' Jukhew qa qu' nuten enewe' hane'ej ha'ne ƚahats'ij.— ");
INSERT INTO mca_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—In ƚunye'jek kakha' ƚunye'jkii kekhewe' ƚeqe neƚutsji' ka' Noe'ik'i, qa hik ƚunye'je' iye hatse' pekhewe' neƚutsji' qu' netpiltaxju' iye ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ke' jukhew'ik'i qa efuts iye tekƚe, iya'ƚe, tewhe'yeiju'kii qa testiiji'jij iye qu' netewhe'yeiju'kii qa yamƚi'ijii ka' neƚuji' ka' Noé in hats i'nji'ju' ke' qi tokoyei, ma' qa nam ka' qi piƚei qa ka' iwelitax qa week naq'axijju' ha'ne sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Qa hik ƚunye'j iye kakha' ƚunye'jkii kekhewe' ƚeqe neƚutsji' ka' Lot, ke' jukhew'ik'i tekƚe, iya'ƚe taqhayetskii wekwek, t'ihinij wekwek, we'nq'en qa naqsi'jju' iye ƚetsil. ");
INSERT INTO mca_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Qa kakha'ƚe neƚuji' ka' Lot in hats ikik'uifik'i ka' witset Sodoma, qa te'nilit ka' piƚei qa fe'tƚe azufre ta'ƚetspha'm na' wa's, ma' qa week naq'axijju'. ");
INSERT INTO mca_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Qa hik aka' iye qu' ƚunye'je' iye hatse' pa' neƚuji' ha'ne Ƚa's na' Jukhew qu' ne'twenhetiitaxija. ");
INSERT INTO mca_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pakha' neƚuji' hatse' pakha' qu' na'nipji' ts'eeweyi'ipji' pe'qu' ƚetsi'ye' qa pe'qu' ƚewekwekitse' qa i'nifi ƚatawe'j pe'qu' ƚetsi'ye'. Hasu'uj net'ilitetsju' qu' nenkaxfik'ikii pe'qu' ƚewekwekitse'. Qa pakha' qu' na'ni' pa'qu' ƚ'ejinqa'wet'e qa hasu'uj netpilii pe'qu' ƚetsi'ye', aje'eƚ nilat yijat'ij. ");
INSERT INTO mca_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Qa' menikfelitiƚik'i pekhe' ƚewhe'ye'ek'i pa'aj pa' Lot. ");
INSERT INTO mca_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Week pakha' qu' nanaitaxij pa'qu' ƚunye'je' pa'qu' ƚiƚa'xe', qa' naqamij, qa pakha' qu' naqamij pa'qu' ƚunye'jetax pa'qu' ƚiƚa'xe', qa' iƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Qa hit'iƚij ewets pakha' naja'xji' hatse' pakha'an wetsjuk pe'qu' witiwhifeyek'eju', qa' ewi'ƚ pa'qu' newetkax qa pakhape' qa' amane'. ");
INSERT INTO mca_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wetsjuk pe'qu' efutse' taqfijinju' qa ewi'ƚ pe'qu' newetkax iye qa pekhepe' qa' amane' iye. ");
INSERT INTO mca_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wetsjuk pe'qu' jukhewe' qu' na'ni' pa'qu' ƚ'ejinqa'wet'e, qa ewi'ƚ pa'qu' newetkax qa pakhape' qa' amane'.— ");
INSERT INTO mca_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pekhewe'en qa nifaakanij pa'aj: —Yatsat'axyij ¿Pa'n i'niji' hatse' aka'an qu' namets?— Qa yeku'ƚ pa'aj: —Pakha' qu' na'ni' pa'qu' iwamhi'le' qa' hik pakha' jeek qu' nonot'axii pe'qu' o'powile'.— ");
INSERT INTO mca_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pa' Jesús qa nifeli'm pa' ewi'ƚ yejeyumtshenijupi' qe qa' nijatshenij pekhewe'en pa'qu' ƚunyejeyi'ij qu' niyin week ƚahatsiyij, qa hasu'uj qu' thalali'ijju'. ");
INSERT INTO mca_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Qa yit'ij pa'aj: —Na'l pa'aj pa' ewi'ƚ juez i'ni' pa' ewi'ƚ witset, pakha'an nite' nijiweyiju'ƚ na' Dios qa nite' nijiweyiju'ƚ iye pa'qu' ƚunye'je'ƚe ene' jukhew, ham nijiwe'yi'iikii. ");
INSERT INTO mca_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pakha' witset i'ni' iye pa'aj pe' ewi'ƚ wikiihale', hik pekhe' week ƚahatsiyij namji'jiii pakha'an, qa yitjiijets: “E'wei qeku'n ye'miju'ƚ wat'ij hekhewe' yejuihifets.” ");
INSERT INTO mca_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Olotsij pa'aj in yamji'ijtaxii, qa nite'ƚe yejeƚjiiju'ƚ pa'aj. Ma' qa i'nk'aƚe pa'aj qa yijamtikii pa'aj, qa yit'ij: “In yemjeetax in nite' ts'ijiwe'yiju'ƚ pa' Dios qa ene' jukhew iye. ");
INSERT INTO mca_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Qa lesƚe ƚe'wis qu' hi'fen ene' wikiihale', qe nite' yili'ij wiikfik'i in namyiikii, hats'inha qa' nite' nasnalkete'kii in week neƚuts namyii.”— ");
INSERT INTO mca_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Qa pa' Yatsat'ax'inij qa yit'ij iye pa'aj: —Jeƚ qeku'ni'ƚek aka' yit'ij pakha' juez nite' yatsathen. ");
INSERT INTO mca_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Me qa' nite' netweyi'ik'i na' Dios pekhewe' hats t'eku'miiji'kii in iyiniikii ene' week neƚuts qa najai iye? ¿Me qa' qiye' iye qu' nonotki'ets qu' nenjeƚiju'ƚ? ");
INSERT INTO mca_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yakha' hit'iƚij ewets in nite' optoxij qu' netweyik'i. Qa ha'neƚe Ƚa's na' Jukhew qu' netpiltaxju' iye hatse', ¿me mexe na'l pa'qu' nite' witqekuye'je' qu' ni'wen hatse' ha'ne sehe' ipji'?— ");
INSERT INTO mca_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Qa pa' Jesús qa iyetij iye pa'aj aka' ewi'ƚ yejeyumtshenijupi' qu' net'ejuyets pekhewe' uja'x in yumtiitaxija qa wanamitƚetaxij ƚewek qu' natsathen, ma' qa yuten pekhewepe', ");
INSERT INTO mca_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","qa yit'ij pa'aj: —Wetsjuk pa'aj pe' jukhew uyetsji' ne' qi witlijtsitjii qu' niyin. Ewi'ƚ pa' fariseo qa pakhap qa nekhewe' yijaninkii wekwek t'ejuyets pa' Roma. ");
INSERT INTO mca_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pa' fariseo ts'apa'aj pa'aj, ma' qa iyintax pa'aj ƚakha'ƚe in iyinƚetets pa'aj, qa yit'ij: “Dios, hit'ij eipha'm in qi in ƚe'wisij qe nite' yijunyejeyiju'ƚ nekhewep jukhew. Nekhewe'en ejtenhetsits, qa nite' yatsathen iye, efunajats iye. Nite' hik yijunye'j iye ha'ne yijaninkii ke' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yakha' wetsjuk'ij neƚuts qe nite' heyek na'aj ewi'ƚ semana, qa week ne'ej ha'yanij ƚ'astai qe yamets week inyaqsii (10) qa ewi'ƚ ne'ej k'eƚisij.” ");
INSERT INTO mca_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Qa pakha' yijaninkii wekwek, qa ts'ap'a'aji' ek pa' ipƚu'ui pa'aj in iyin nite' yisu'un iye qu' nejeƚijetspha'm na' wa's mehe'ej in yilanje'mkii ƚ'ejuyi'j, qa yit'ij pa'aj: “Dios, e'nq'elet qeku'nyij wat'ij qe tsikfe'lets in qi in yuƚ'ax.” ");
INSERT INTO mca_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Hit'iƚij ewets pa' yijaninkii pe' wekwek in wapilii pe' ƚetsi' qa hats yiwu'mik'ui na' Dios pe' ƚewuƚ'ets. Qa pakha'ƚe fariseo qa nite' tewumhiti'yik'ui pe' ƚewuƚ'ets. Qe pakha' qu' ƚakha'ye' ƚetaxƚete'm qu' neniwqinhettaxji' qa' hik pakha'ye' qa' nite' qiye'ji'. Qa pakha'ƚe qu' nite' neniwqinhete'ji' ma' qa hikpa' qa' neniwqinhetji'.— ");
INSERT INTO mca_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Qa tetka'xii pa'aj pa' Jesús pe' omehets weekji' pekhewe' mexeelija qu' net'eku'mipji'. Qa in yi'wenij pa'aj he' ƚ'ijatshenhei qa nite' ƚexkeltaxij qa t'oqowe'itaxijiju'ƚ pa'aj pekhewe' nekaxtaxetskii pe' ƚelits. ");
INSERT INTO mca_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma' qa pa' Jesús qa taya'yets pe' ƚ'ijatshenhei, qa yit'ijji'ju': —Enwejinƚi'iƚ yiwets ne' omehets qu' nenek yiwets. Hasu'uj oqowe'yi'ƚiju'ƚ, qe nekhewe' hik ƚunyejei enewe'en hik nekhewe' ne' yatsat'etsipji' na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nite' net'eku'miju'ƚ na' tenek'enheiji' na' Dios qu' nite' hik ƚunye'je' na'aj omeƚa's in nite' inqeku', nite' ƚeke' qu' nuiji'teje'm nakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ewi'ƚ pa' jukhew pekhewe' tenek'enhei qa nifaakan pa'aj pa' Jesús: —Teik'unei Maestro, ¿pa'n yeqfenye'j yiwek qu' nana'l ye'm pa' witiƚa'x nite' yili'ij?— ");
INSERT INTO mca_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Qa pa' Jesús qa yeku'ƚ pa'aj: —¿Inhats'ek in ƚit'ij yiwets teik'unei? Ham pa'qu' neteik'unei, ewi'ƚƚe na' Dios. ");
INSERT INTO mca_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akha' hats inek ƚenikfe'lets ke' yit'ij na' Dios qu' nanaqsiijkii: “Hasu'uj mowo'oi efu qu' hats ewhe'yei qa hik ƚunye'j iye ne'ej efu, hasu'uj eqek'ui, hasu'uj ejtenkii, hasu'uj mowotk'onimkii pakha' qu' netnek'enhei. Ek'eenetsha qa iwqinhetji'ha iye pa'qu' atataye' qa pe'qu' eneneye' iye.”— ");
INSERT INTO mca_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Qa yeku'ƚ pa'aj pakha'an qa yit'ij: —Week ekewe'en hayiits heik'enik'iha qa hijayanija iye in i'nk'a ye'jutjanax ƚa's.— ");
INSERT INTO mca_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pa' Jesús in yepi'ye' ek'i aka'an qa yit'ijets pa'aj: —Mexe na'l pa' ewi'ƚ hamik'ui qu' aqsiijkii. Ihinijkii week pe' ewekwekits qa pekhewe' qu' ƚajale' qa' ƚisij ne' if'iljetsits, ma' qa' nana'l e'm yijat'ij pe'qu' ewekwekitse' na' wa'sji', qa' etpil iye qa' atsjayan.— ");
INSERT INTO mca_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Qa pakha'ƚe'en in yepi'ye' ek'i pa'aj aka'an, qa qi in uƚ'axi'mkii pa'aj, qe pakha'an qi in yiwq'axin pe' wekwek. ");
INSERT INTO mca_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pa' Jesús in yejeƚju' pa'aj, ma' qa yit'ij: —¡Hayits qa jutsitax qu' nuiji'teje'm na' tenek'enheiji' na' Dios enewe' yiwq'axin wekwek! ");
INSERT INTO mca_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Qe les qu' nite' jutsitaxe' pa'qu' ewi'ƚe' ats'etaxe' qu' nuyii ne'ej tawjena'x ƚoto', qa' nite' hik ƚunye'je' pa'qu' ewi'ƚe' yiwq'axin wekwek in jutsitax wiikfik'i qu' nuiji'teje'm na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Qa pekhewe' yepi'ye' ej pa'aj aka'an, qa yit'ijju' pa'aj: —Maa, ¿qa pa'n ƚiyek pa'qu' ƚeke'ye' qu' iƚa'xe'?— ");
INSERT INTO mca_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pa' Jesús qa yeku'ƚ pa'aj: —Pakha' qu' nite' ƚeke'ye' qu' naqsiijkii ene' jukhew qa efuts iye, qa nakha'ƚe Dios qa ƚeke' qu' naqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ha' Pedro qa yit'ijets pa'aj: —Yatsat'axyij, yekheweli'ƚ week henejeti'ƚ he' yiwekwekitsi'ƚ qa k'aftsini'ƚ in k'ajayani'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Qa yeku'ƚ pa'aj: —Yijaa'ija aka' hit'iƚij ewets, in ham pakha' qu' hats niwejinƚi'i pe'qu' ƚetsi'ye', i'nƚi'i ƚewhe'ye'ye', i'nƚi'i qu' ƚamatsitse' qa ƚek'injats iye, i'nƚi'i qu' ƚ'alheye' qa i'nƚi'i qu' ƚelitse' qe ta'ƚijupi' na' tenek'enheiji' na' Dios ");
INSERT INTO mca_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","qu' nite' les olotsi'ij qu' netesti'yij ekewe'en ha'ne hane'ej ƚahats'ij, qa pakha' mexe hamik'ui, qa pa' witiƚa'x nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pa' Jesús t'eku'mi' pa'aj he' doce (12) ƚ'ijatshenhei qa wetqhetheni'ƚfik'i pa'aj, qa yit'ijji'ju': —Jeƚ qeku'ni'ƚek, hane'ej in jiteyii qu' jinamii ha' Jerusalén, qa' hik nakha'yi'i' ma' qa' hats nafits week kekhewe' wekwek yika'ajji' pa'aj ke' profetas'ik'i in t'ejuyets ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Qe hik nakha'a' hatse' qu' netesti'yij ne' jukhewiikal, qa' qi qu' nawitji'iji' pe'qu' ƚe'lijeye', qa' uƚ'etsi'ik'i iye pe'qu' ƚe'lijeye'ets qa' netk'iyikii iye. ");
INSERT INTO mca_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Qa' ink'aye'ƚe qu' hats neqsilanje'mkii, ma' qa' nilan, qa qu' namets wetshetk'ewi'ƚ neƚuts qa' iƚa'xe' iye.— ");
INSERT INTO mca_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Qa he' ƚ'ijatshenhei qa nite' nikfe'lik'uyii aka' yit'ijets pa'aj, qe mexe nite' ƚenexke'ej qu' nenikfelik'uiyii, qa hik ta'ƚijupi' in nite' ƚeke' qu' nenikfe'lik'i. ");
INSERT INTO mca_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","In hats k'esets pa'aj pa' Jesús pa' witset Jericó, ewi'ƚ pa' puk'al i'niju' pa'aj ƚekuwe' pa' wit'ikheyi'j, iyiniikii ƚaq'astaye'. ");
INSERT INTO mca_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pa' puk'al in yepi'ye' pa'aj in olots pe' jukhew nekijup, qa inaqfaakanij pa'aj pa'n ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Qa tefelhiti'yi'm pa'aj in neki' pa' Jesús Nazaret ƚeiƚe'. ");
INSERT INTO mca_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma' qa pa' puk'al qa tayaiƚek pa'aj, qa yit'ij: —Jesús, Ƚa's pa' David'ik'i, ¡enq'eletyij wat'ij!— ");
INSERT INTO mca_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pekhewe' nojo'ok'oi qa yaq'ayintaxij qe qa'nte' net'ewu'ye'. Qa pakha'an qa yape'enhaƚe les in yit'unhetik'i in tayai: —Ƚa's pa' David'ik'i, ¡enq'eletyij wat'ij!— ");
INSERT INTO mca_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Qa pa' Jesús qa teke'lenju' pa'aj qa inq'ukinii qu' netetka'xii, qa in hats meti'm, qa nifaakan pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ƚekpa' ƚisu'un qu' haqsi'j e'mijkii?— Qa pa' puk'al qa yeku'ƚ pa'aj: —Yatsat'axyij, hisu'untax qu' hi'wenkii iye.— ");
INSERT INTO mca_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pa' Jesús qa yit'ijets pa'aj: —Hane'ej qu' i'wenkii iye. Na' nite' eqekuye'j hik nakha' neƚin.— ");
INSERT INTO mca_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Qa hik pakha'aj qa yi'wenkii, qa yijayan pa' Jesús qi in yiwqinhetji' pa' Dios. Qa week iye pekhewe' yi'wenij pa'aj aka'an qa qi in yiwqinhetji' iye pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pa' Jesús qa yamji'teje'm pa'aj pa' witset Jericó, ma' qa nek ji'teje'm pa'aj pa' witset. ");
INSERT INTO mca_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Qa ewi'ƚ pa'aj pa' jukhew ƚii Zaqueo, tenek'enhe'yipji' pekhewe' yijaninkii wekwek t'ejuyets pa' Roma, pakha'an qi yiwq'axin iye pa'aj wekwek. ");
INSERT INTO mca_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pakha'an neqwenkeyu'taxij pa'aj pa'n ƚunye'jija pa' Jesús, qa nite'ƚe ƚeke' qu' ni'wen qe olots pe' jukhew qa efuts iye, qe ik'ajiyit pa'aj pa' Zaqueo. ");
INSERT INTO mca_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hik ta'ƚijupi' in wekuma'x pa'aj qu' yojo'ok'oyii pa' teiji', qa weƚik'ipha'm pa'aj pe' najkak hats'inha qu' ni'wen, qe pa' Jesús hats k'esiyu'ui qa' neneki' pakha'an. ");
INSERT INTO mca_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Qa pa' Jesús in yamets pa'aj, qa yeeƚik'ipha'm pe' najkak, qa yit'ijetspha'm pa'aj: —Zaqueo, if'elitik'i, ilitju', qe hane'ej qu' ya'mane' eku'ni' pe' etsi'ii.— ");
INSERT INTO mca_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ma' qa pa' Zaqueo qa yif'elitik'i pa'aj in t'ilitju', qi in ƚe'wisi'mkii pa'aj qu' namiƚii pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","In te'wenheti'yij pa'aj aka'an, ma' qa week in t'ayijji' pa'aj, qa yit'ijju': —Hats ikii qu' amani'i' pe' ƚetsi'ii aka' ewi'ƚ jukhew uƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pa' Zaqueo qa niipha'm pa'aj, ma' qa yit'ijets pa'aj pa' Yatsat'ax'inij: —Ma' hayits, Yatsat'axyij, pa' ƚapk'as enewe' na'l ye'm qa' hetisij nekhewe' if'iljetsits. Qa qu' nana'l pa'qu' he'yejteni'm pa'qu' ƚuk'eye'en qa' les ƚe'wis qu' ikwetju'ƚi'ij (4) qu' hanhinipji' qu' hepiletets.— ");
INSERT INTO mca_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pa' Jesús qa yit'ijets pa'aj: —Hane'ej na' witiƚa'x nite' yili'ij hats namets ene' wititsi', qe ha'ne jukhew ƚa's iye ka' Abraham'ik'i qe hik ƚunye'j in nite' inqeku'. ");
INSERT INTO mca_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Qe ha'ne Ƚa's na' Jukhew nam qa' nowo'oikii qa' nenƚinju' iye pekhewe' hamitstaxiikii.— ");
INSERT INTO mca_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pe' jukhew in yepi'ye' ek'i pa'aj ekewe' wekwek, pa' Jesús qa ewi'ƚij iye in nifel pa' ewi'ƚ yejeyumtshenijupi' iye, qe hats meti'mii ha' pa'aj ha' Jerusalén, qa pekhewe'en qa yumtitax pa'aj qu' hats k'esiyuye'etsha qa' na'nju' pa' tenek'enheiji' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Qa hik ta'ƚijupi' in yit'ij pa'aj: —Na'l pa'aj pa' ewi'ƚ qiji' patun pa' ewi'ƚ witset, yamii pa' toxii witset qa' netestiyiji' qu' wittatayi'i pakha' ta'ƚi', ma' qa' ink'aye'ƚe qa' netpil iye. ");
INSERT INTO mca_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Qa mexe taya'yii pa'aj pekhewe' week inyaqsii (10) ƚeqejkunenhei, qa week ewiƚeyi'mkii tinajits ƚelits pe' ƚ'astai in netisijju', qa yit'ijets iye pa'aj: “Ithayi'yi'ƚij enewe'en ipƚu'ui qu' hetpiltax iye.” ");
INSERT INTO mca_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Qa pekhewe'ƚe ƚetsetifets qa qi in napjaxi'm, ma' qa yijayankeninijpha'm pe' uja'x jukhew, qu' nit'ijets: “Nite' hisu'uni'ƚ qu' wittatayi'i ha' yitset'iƚ.” ");
INSERT INTO mca_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Qa hasƚe testi'yij qu' wittatayi'ij, qa tepilii iye pa' ƚetset. Ma' qa in namii pa'aj qa iyinii iye pekhewe' ƚeqejkunenhei netisijju' pa'aj pe' ƚaq'astai, qe qa' nenikfe'lets pa'n uja'x pe'qu' ƚaxifkinele' in t'ithayi'yij. ");
INSERT INTO mca_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pa' yojo qa nekets pa'aj, qa yit'ijets: “Yaqa patun, ene' aq'astai qi in ha'yanijfik'i, qa week inyaqsii (10) ene' tinajits ƚelits ene' ha'yanij.” ");
INSERT INTO mca_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Qa yit'ij pa' wittata: “¡Hayits yijat'ij! Akha' ƚeniyayij in e'witqejkunene'k, qe in nite' ƚawitjiƚe ke' nite' olotstax, qa hane'ej qa' k'eƚisij qu' enek'enhe'yipji' nekhewe' week inyaqsii (10) witsetits.” ");
INSERT INTO mca_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ma' qa nekets iye pakhap iye, qa yit'ijets: “Yaqa patun, ene' aq'astai qi in ha'yanijfik'i lee'fij (5) ene' ti'najits ƚelits ene' ha'yanij.” ");
INSERT INTO mca_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Qa yeku'ƚ iye pa'aj pakha'an, qa yit'ijets: “Akha' qa' leefi'ijek (5) pe'qu' enek'enhe'yipji' ek witsetits.” ");
INSERT INTO mca_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Qa pakhap iye qa nekets iye, qa yit'ijets iye pa'aj: “Yaqa patun, enewe'en he' aq'astai. Hijuphe'ƚji' ka' penyilo in hat'inkii. ");
INSERT INTO mca_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Qe ts'ijiwei eju'ƚ qe akha' ewi'ƚ jukhew its'iyoptox, ƚ'eku'mi' qa ƚeka'x na'aj nite' akha' qu' eni' pakha' we'nentaxi' qa ƚenit'ijji' iye ne'ej ƚei ne'ej nite' akha' qu' enju'.” ");
INSERT INTO mca_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ma' qa pa' wittata qa yit'ij: “Akha' ham e'wejuƚi'ij in e'witqejkunene'ktax, kekhewe' akha'ƚe in e'lijei hik kekhewe' qu' nata'ƚets qu' atanithenhetii. In ƚenikfe'l yiwets in yits'iyoptox qa he'yeku'mi' qa heka'x iye na'aj nite' yakha' qu' heni' pakha' we'nentaxi' qa henit'ijji' iye ƚei ne'ej nite' yakha' qu' henju'. ");
INSERT INTO mca_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Qa inhats'ek in nite' ƚekaxii ne' yaq'astai pe'qu' bancoye', hats'inha qekha nana'ltax pe' qek nat'antaxfik'i in hetpil iye?” ");
INSERT INTO mca_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Qa yit'ijets pekhewe' i'nijup: “Enitka'mi'ƚij ne' ƚ'astai qa' ƚisi'ƚij nakha' t'anij ne' week inyaqsii (10) ti'naj ƚelits.” ");
INSERT INTO mca_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pekhewe'en qa yit'ijju': “Yaqa patun, qa in hats week inyaqsii (10) iye ne' t'anij nakha'an.” ");
INSERT INTO mca_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Qa yeku'ƚ pa' wittata: “Yakha' hit'iƚij ewets pakha' qu' ƚunye'je'ƚe qu' hats nana'li'm qa' les netesti'yij iye, qa pa'qu' hami'im qa' netitkamhiti'yij iye pa'qu' nana'ltaxi'm. ");
INSERT INTO mca_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Qa nekhewe' yejuihifets, hik nekhewe' ne' nite' yisu'untax qu' ƚatataye'yij in ye'wittata, enka'xi'ƚ met hane'e'in qa' k'eweni'ƚij qu' anlani'ƚju'.”— ");
INSERT INTO mca_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","In yili'ij in yit'ij ekewe'en pa' Jesús, ma' qa yojofik'i iye qu' namii ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","In hats meti'm pa'aj ha' witset ƚa's Betfagé qa ha' Betania meti'm ha' puumupha'm uteket ƚii Olivos, qa yukin pa'aj he' wetsjuk ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Qa yit'ijets: —Ma'aƚii na' witset ƚa's, nakha' jiwankaajuƚesteje'm, na' les in met. Qa qu' ami'ƚetsteje'm qa' i'weni'ƚi' pa'qu' ewi'ƚ matikataxe' wo'nophe'ƚ, mexe ham i'ni' ipji'. Qa' enit'iƚijii qa' enka'xi'ƚ met. ");
INSERT INTO mca_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Qa qu' nana'l pa'qu' nafaakantaxiƚij: “¿Inhats'ek in ƚenit'iƚijii?” qa' it'iƚijiju'ƚ: “Yisu'un ha' Yatsat'ax'inij.”— ");
INSERT INTO mca_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ma' qa ikkii pa'aj pekhewe' t'ukinhetii. Qa week yi'wen ekewe' hats yit'ijets pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","In mexe nit'ijii pa'aj pa' matikatax, qa pe' yatsat'etsij qa nifaakan pa'aj: —¿Inhats'ek in ƚenit'iƚijii?— ");
INSERT INTO mca_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Qa yeku'ƚ pa'aj pekhewe'en: —Qe ha' Yatsat'ax'inij yisu'un.— ");
INSERT INTO mca_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma' qa neka'xii pa'aj pa' Jesús, qa yipk'enipji'kii pe' ƚe'ntaafitits, ma' qa yinhini'pji' pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Qa in ikij pa'aj pa' Jesús, ma' qa pe' jukhew qa efuts iye qa yipk'enik'uiyi'jukii pa' witikheyijji' pe' ƚe'ntaafitits. ");
INSERT INTO mca_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","In hats meti'm pa'aj ha' kiimiju' ma' qa' hats nakik'iju' ke' uteket Olivos, qa week pekhewe' olots ƚ'ijatshenhei qa taya'yijipji'kii qe ƚe'sitsi'mkii qa qi in yiwqinhetji' iye pa' Dios, qe hikpa' ta'ƚets pekhewe' week ham ƚunyejeyi'iju'ƚ in yi'wenij pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Qa yit'ijju': —¡Qi in ƚe'wis ha'ne wittata namij aka' ƚii pa' Yatsat'ax'inij! ¡Wit'ikesimeya'xƚekii hatse' pa' wa'sji'pha'm qa' neniwqinhetji'ha iye pakha' i'ni' pa' les toxpha'mha!— ");
INSERT INTO mca_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Qa uja'x pekhewe' fariseol i'nji'teje'm pa'aj pekhewe' jukhew, qa yit'ijets pa'aj: —Maestro, aq'ayinij aka' yit'ijju' enewe' ijatshenhei.— ");
INSERT INTO mca_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Qa yeku'ƚ pa'aj pa' Jesús, qa yit'ij: —Yakha' hit'iƚij ewets, qu'nte' net'ewuyetax enewe'en qa' nekhewe'ye' utel qu' natyai wetju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Qa in hats meti'm pa'aj ha' Jerusalén, qa pa' Jesús in hats yi'wenii pa'aj ha' witset, ma' qa yayinju' pa'aj ");
INSERT INTO mca_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","qa yit'ij pa'aj: —Qek akha'ye'ƚe iye qek enikfe'lets ha'ne neƚuji' nakha' qek k'eƚistaxij wit'ikesimeya'xƚekii. Qa ha'neƚi'ij qa hats wanat'in ek'uikii qa' nite' i'wene'. ");
INSERT INTO mca_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Qe nam ewets hatse' nekhewe' uƚ'ets neƚuts. Ma' qa nekhewe' ejuihifets qa' nam ejupkii, qa' neqetsitenij ejup pa'qu' qiye'pha'm qa'nte' maye'fik'i. ");
INSERT INTO mca_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Week qu' nonopƚaxju' na' witset qa week qu' nalani'ƚju' iye akha' qa ene' elits. Ham nejete'pha'm pe'qu' uteye' qu' amani'ipji' pekhepe' iye uteye', qe nite' ƚenikfeliyu'ets ha'ne ƚahats'ij in hats namtax ei ha'ne Dios.— ");
INSERT INTO mca_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pa' Jesús qa uyifi pa'aj ke' qi witlijtsitjii. Ma' qa yiwutshenijfik'ikii pa'aj pekhewe' i'ntaxijifi pe' t'ihinij, ");
INSERT INTO mca_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","qa yit'ijji'ju' pa'aj: —Ke' we'nika'ajji' ƚe'lijei na' Dios yit'ij: “Ene' yitsi' qu' ƚetsiyi'ij pa' wit'iyinheye'j” qa ekheweli'ƚ qa eqiwe'jtaxiƚij nekhewe' ejtenhetsilets.— ");
INSERT INTO mca_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Qa week neƚuts i'nq'ijatshenifi pa'aj pa' Jesús ke' qi witlijtsitjii. Qa pekhewe'ƚe tenek'enhe'yipji' pe' pa'il qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pekhewe' iye tenek'enheiji' ha' witset qa wotaxiikiyek pa'qu' ƚeqfenyejeyi'ij qu' nilan. ");
INSERT INTO mca_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Qa nite'ƚe yi'wen pa'qu' ƚeqfenyejeyi'ij, qe week pakha' witset yisu'unjiija qu' nepiye' qa i'nq'ijatshenji'ij pa'aj pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Qa ƚunye'jkii iye pakha'aj pa' ewi'ƚ neƚuji' pa' Jesús in mexe yijatshen pa'aj pe' jukhew ke' qi witlijtsitjiyifi qa nifeli'm eke' ƚe'sits wi'tlijei, qa namets pa'aj pekhewe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa pekhewe' iye tenek'enheiji' ha' witset. ");
INSERT INTO mca_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pekhewe'en qa nifaakan pa'aj pa' Jesús, qa yit'ijets pa'aj: —¿Pa'n ƚunye'j pa' witt'unha'x ta'ƚets in ƚaqsiijkii aka'an? ¿Pa'n ƚii pa' tenek'enhei neƚisij aka'an qu' aqsiijkii?— ");
INSERT INTO mca_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Qa yeku'ƚ pa'aj pa' Jesús: —Yakhap ji'jek qu' k'afaakani'ƚij pa'qu' ewi'ƚe', qa' enfeli'ƚ ye'm: ");
INSERT INTO mca_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","In wenqimpuujinkii ka' Juan, ¿me ta'ƚets na' Dios, me i'nƚi'i ene' jukhewƚe?— ");
INSERT INTO mca_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma' qa wapilij wetju'ƚ pa'aj in iyetijju', qa yit'ijju': —Qu' jintittaxijets nukin pa' Dios, ma' qa nit'ij inwets: “¿Inhats'ekek in nite' ƚ'ek'eni'ƚets?” ");
INSERT INTO mca_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Qa nite' ƚeke' iye qu' jintit'ijets qu' enewe'ye' jukhewƚe qu' nata'ƚets, qe qu' jintit'ijets ma' qa jinijele'ejkii ne' utel qu' jinilanju'ha, qe enewe'en week yumti in yijaa'ija ka' Juan in profeta.— ");
INSERT INTO mca_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ma' qa in yeku'ƚ pa'aj pekhewe'en, qa yit'ijets in nite' nikfe'lets pa' ta'ƚets in inqimpuujinkii ka' Juan. ");
INSERT INTO mca_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Qa pa' Jesús qa yeku'ƚ pa'aj: —Yakhap ji'jek qa'nte' k'efeli'iƚi'm nakha' hata'ƚijets aka' yit'unha'x in haqsiijkii aka'an.— ");
INSERT INTO mca_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma' qa hik pakha'aj qa yit'ijets iye pa'aj pekhewe' jukhew qa efuts aka' yejeyumtshenijupi': —Ewi'ƚ pa' jukhew yeni'ju' pa' ƚeq'ejinqa'wet pa' uwaket. Ma' qa yatkinheninets pekhewe' jukhew qa' hikpe' nejeƚets qa qu' netei qa' niwjafiti'ƚje'm. Ma' qa ik pa'aj qa yamii pa' toxii witset qa yape'eikii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Qa in yamets in tei qa yukinii pa' ewi'ƚ ƚeqejkunenek pekhewe' jukhew qu' niyinijets pa' uja'xek pekhewe' qu' ƚekheweli'ijek pa' t'enheiju'. Pe' jukhew qa yilanje'mkii pa' wit'ukinektax qa yipilhenin iye, ham tisi'ij. ");
INSERT INTO mca_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Qa yukintax iye pakhap iye ƚeqejkunenek, qa hik ƚeqfenyejeyij iye in qi in yilanje'mkii iye, tejitheyetskii qa yipilhenin iye, ham tisi'ij iye. ");
INSERT INTO mca_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Qa yukintax iye pakhap iye ma' qa hats wetshetk'ewi'ƚ, qa pakha'an qa yeqfe'meten iye pa'aj, qa yiwutshenfik'i pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Qa yit'ij pa' yatsat'axij pa' uwaket: “¿Paa's qu' yeqfenye'ji'ij? Ye'ehe, nakha' yaa'sija qi in hisu'un qu' hukinii iye, axe'm qu' hik nakha'ye' qu' niwqinhetji' qa' netk'enets.” ");
INSERT INTO mca_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pekhewe' jukhew in yi'wen iye pa'aj, qa yit'ijju' pa'aj: “Hik nakha' qu' naya'xtaxij hatse' ha'ne ƚeq'ejinqa'wet. Jitalan hats'inha qa' inekhewele' qu' jinatsat'etsijha hatse' ha'ne ƚ'ejinqa'wet.” ");
INSERT INTO mca_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ma' qa t'eku'mi' pa'aj qa yeka'xik'uifik'i pa' ƚ'ejinqa'wet, ma' qa yilan pa'aj.— Qa yit'ijets pa'aj pa' Jesús pekhewe' jukhew qa efuts: —Ye'ehe, ¿qa pa'n qu' ƚeqfenye'ji'ij hatse' pa' yatsat'axij pa' uwaket pekhewe'en? ");
INSERT INTO mca_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Namii hatse' qa' nanlanju' pekhewe' jukhew, qa pa' uwaket qa' netisij pekhewepe' iye.— In yepi'ye' ek'i pa'aj aka'an pe' jukhew qa efuts iye, qa yit'ijju': —Hasu'uj qek nana'l pa'qu' ƚunye'je' kakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pa' Jesús qa yejeƚ ji'teje'mkii pa'aj, qa yit'ij: —¿Qa pa'n ikji' ek kakha' yit'ij ke' hats we'nika'ajji' Dios ƚe'lijei, in yit'ij: “Ne' ute yuten qa yiwu'mfik'i nekhewe' niihinpha'm ne' wititsi', hane'ej qa hats ewi'ƚ ute les in weju'ƚij in teniihinijpha'm ne' wititsi'”? ");
INSERT INTO mca_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Week pakha' qu' nilantaxifi qa' nanamipji' ene' ute qa' nenepƚetju' ƚenutsik'i, qa ene'ƚe ute pa'qu' nanamipji' qa' niƚipipinhetji'ha.— ");
INSERT INTO mca_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Qa hik pakha'aj pekhewe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei qa nilithiyu'taxets pa'aj qu' net'eku'mi' pa' Jesús, qe nikfe'lik'i aka' iyetij pa'aj pa' Jesús in t'ejuiƚe'ets pekhewe'en. Qa nijiweiƚi'iju'ƚ pa'aj pe' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Qa pe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei, ma' qa yejeƚijupkii pa'aj. Ma' qa yukinii pa'aj pe' uja'x qa' notjonketi'k'i qu' natsathen, qe qa' nitjuƚatij pe'qu' ƚe'lijeye' qe wo'taxii qu' uƚ'axi'ik'uyi' pa'qu' nit'ij qa' iwemetsaxe' qu' net'eku'mi' qa' netisij pakha' gobernador pa' witset. ");
INSERT INTO mca_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pekhewe'en qa nifaakan pa'aj, qa yit'ijets: —Maestro, tsikfe'li'ƚets kekhewe' ƚit'ij qa ke' ƚi'nq'ijatshenij iye in yatsathenik'iha. Akha' week eqjunyejeyij iye ene' week. Akha' ƚinq'ijatshenijha pakha' yijaa'ija in ƚunye'j pa' ƚ'ikheyi'j pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Me ƚe'wisijupi' in jitajaninkii eke' wekwek qu' net'ejuyets pa' Roma ƚatata (César), me i'nƚi'i qu' nite' ƚe'wisi'ijupi'?— ");
INSERT INTO mca_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pa' Jesús qa hatsƚe nikfe'lets in tewqeleiƚetaxik'ui pekhewe'en, qa yit'ijets pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ets'ethini'ƚij ewi'ƚe' ƚ'astaki'ye' ne'ej denario. ¿Ƚek ƚesi'nq'al ha'ne i'nji' qa ha'ne witii, ƚek ƚii iye?— Pekhewe'en qa yeku'ƚ pa'aj: —Pa' Roma ƚatata (César) ƚesi'nq'al.— ");
INSERT INTO mca_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Qa pa' Jesús qa yit'ij: —Ye'ehe, qa' ƚisi'ƚij pa' Roma ƚatata (César) pekhewe' yatsat'etsƚi'ijek in Roma ƚatata, qa na' Dios qa pekhewe' yatsat'etsƚi'ijek in Dios.— ");
INSERT INTO mca_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Qa pakha'an qa ham pa'qu' nit'ij in iyet qu' net'ejuyiju'ƚ pekhewe' week in yepi'ye' pa'aj, ma' qekha niwq'axintaxij qu' net'eku'mi'. Qa qi in yitjuƚaxijpha'mkii, qa ham pa'qu' nit'ijju' pa'aj pekhewe' tewqeleiƚetaxik'ui. ");
INSERT INTO mca_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma' qa uja'x pe' saduceol namii qu' ni'wen pa'aj pa' Jesús. Pe' saduceol yit'ijetsek in nite' iƚii iye pe'qu' hats nanaxju'. Qa hik ta'ƚijupi' in nifaakanij pa'aj aka' ewi'ƚ ƚunye'jkii qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, pa' Moises'ik'i yika' ine'm pa'aj in yit'ij: “Pa'qu' jukhewe' qu' nawa'm qa mexe hamtax ƚelitsi'iƚ pe'qu' ƚewhe'ye'ye', qa pa' ƚek'inij i'nƚi'i qu' ƚamats'e qa' ƚewhe'ye'yi'ij pe' ƚewju'lelaxtax, ma' qa qu' nataltsa'yi'ƚ qa' ƚa'si'ij pa' ƚejefe'ik'i.” ");
INSERT INTO mca_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na'l pa'aj pe' wetsjuk tatsai (7) witjefeye'k. Pa' yojo'oj in tewhe'yei qa wa'm pa'aj qa mexe hamtax ƚa'si'iƚ pe' ƚewhe'ye'tax. ");
INSERT INTO mca_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma' qa ƚewhe'ye'ej iye pa'aj pa' te'weyiju'ƚ, qa wa'm iye pa'aj qa mexe hamtax iye ƚa'si'iƚ pekhe'en. ");
INSERT INTO mca_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Qa pa' te'weiji' iye ƚeqewuk'u qa ƚewhe'ye'ej iye pa'aj qa hik ƚunye'j iye pa'aj, qa week in ƚunyejei pa'aj aka'an in naxju' pekhewe' wetsjuk tatsai (7) witjefeye'k, ham taltsayi'iƚ pe' efu. ");
INSERT INTO mca_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Qa teke'lenju' qa wa'm iye pa'aj pe' efu'uk'i. ");
INSERT INTO mca_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Qa hane'ej, qu' iƚiye' iye pe' hats naxtaxju', ¿pa'n ƚii pa'qu' namijfik'i qu' ƚewhe'yeyi'ijha pe' efu in hats week ƚewhe'ye'tsij pe' wetsjuk tatsai (7) witjefeye'k?— ");
INSERT INTO mca_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Qa pa' Jesús qa yeku'ƚ pa'aj, qa yit'ij: —Enewe' hane'ej ƚahats'ij tewhe'yeiju'kii, qa testiiji'jij iye qu' netewhe'yeiju', ");
INSERT INTO mca_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","qa pekhewe'ƚe hats jutsiqets qu' namets hatse' nakha' ink'ayik hatse' ƚahats'ij qa na' ƚiƚijii iye kekhewe' hats naxtaxju', qa hats nite' tewhe'yei hatse' nite' testi'yij iye qu' netewhe'yeiji'ijju', ");
INSERT INTO mca_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","qe hats nite' ƚeke' qu' nawa'm hatse', hik qu' ƚunyejeye' ne' angelits. Pekhewe'en ƚelitsijha hatse' na' Dios qe ƚelitsij na' witiƚijii. ");
INSERT INTO mca_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pe' hats naxtaxju' iƚii iye hatse', ka' Moises'ik'i i'nq'ijatshenij qa yenji' pa' ƚafaakanek qa yika'ajji pa' ƚunye'jkii pekhe' tujje'm pa'aj najkak ƚasi', in hik pakha'a' pa'aj in taya'yets nakha' Yatsat'ax'inij, ƚeqe Dios ka' Abraham, ka' Isaac qa ka' Jacob. ");
INSERT INTO mca_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nakha'an nite' ƚeqe Dios pe' naxju', qe ƚeqe Dios yijat'ij pe' iƚii, qe nakha'an week iƚiyi'm.— ");
INSERT INTO mca_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Qa uja'x pe' i'nq'ijatshenij ke' Moisés ƚe'lijei, qa yit'ijets pa'aj: —Maestro ¡hayits qa ƚ'asinik'iha kakha' ƚit'ij in ƚ'inku'ƚ!— ");
INSERT INTO mca_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma' qa hik pakha'aj pa'aj qa hats wetjeyepunets qu' nanfaakanij iye pe'ye' iye. ");
INSERT INTO mca_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma' qa pa' Jesús qa nifaakanek pa'aj, qa yit'ijets: —¿Pa'n ƚunye'j in titijiti'yijets pa' Cristo qu' ƚa'se' ka' David'ik'i? ");
INSERT INTO mca_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ka' David'ik'i hik kakha'ija in yit'ij qa yika'ajji' na' ƚafaakanek Salmos, in yit'ij: “Pa' Yatsat'ax'inij yit'ijets pa' Yatsat'axyij: ‘Niju' ni'iju' ha'ne ts'iyayik'i, ");
INSERT INTO mca_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ipƚu'ui qu' hentaxiiju' ne' week ejuihifets ne' ef'iyei.’” ");
INSERT INTO mca_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ma' hayits, ka' David'ik'i in yit'ijets: “Yatsat'axyij,” ¿qa pa'n ƚunye'j in wenit'ijets qu' ƚa'se'?— ");
INSERT INTO mca_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Week pekhewe' jukhew qa efuts iye in mexe tek'enets pa'aj, qa yit'ijets pa'aj he' ƚ'ijatshenhei: ");
INSERT INTO mca_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Jeƚi'ƚiju'ƚ nekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei, nekhewe'en yisu'unƚe qu' nijalkisijkii ne' ƚ'uihitjiyits juffufuf, qa qi'ija iye in yisu'un qu' neniwqinhetji'ha qu' netniwetfelhiyi'm in neki'kii na'aj joofji'ju', wo'oiji' iye qu' na'nipji' ne'ej ƚots'oji'laxits ne'ej tenek'enhei nekhewe' witlijtsitjiyitsifi, wo'oiji' iye qu' na'nipji' ne'ej qitsji' ƚots'oji'laxits na'aj qi ƚekujiiji'. ");
INSERT INTO mca_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nitka'mij iye ne' wikiihalei ne' ƚetsil. Qa yape'ejets iye qe iyin qe yisu'unƚe qu' ne'twenhetii ma' qa' netjumtaxtii qu' yijaayi'ija qu' nijayan na' Intata. Nekhewe'en les qu' qiye' qu' nattanithenhetii hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pa' Jesús qa nejeƚpha'm pa'aj, qa yi'wenij pekhewe' wekwek yiwq'axin in yenik'iju'kii pe' ƚaq'astai ƚeqe ofrenda pe' ti'najki' pe' qi witlijtsitjii. ");
INSERT INTO mca_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Qa yi'wenij iye pa'aj pe' ewi'ƚ wikiihale' if'iljetsax in yenjiik'iju' ek iye pa'aj pe' wetsjuk uja'xƚi'i in ƚaq'astai nijketits nite' inyetets. ");
INSERT INTO mca_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Qa yit'ij pa'aj: —Yijaa'ija aka' hit'iƚij ewets ene' wikiihale' in qi in if'iljetsaxtaxija, qa ƚakha' qa les olots ke' yenik'iju' week t'anipji'. ");
INSERT INTO mca_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Qe week hekhewe' yenik'iju'kii mexe na'l yijat'ij pekhewe' qu' amaneyi'ij, qa nekhe'ƚe efu if'iljetsax, qa week yakapilenets kekhewe' qek netektaxij.— ");
INSERT INTO mca_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Qa pekhewe' uja'x in mexe yifaakatetaxji' pa'aj pe' qi witlijtsitjii, in qi in ƚe'sits pe' utel, qa pe' yik'eihini'kii iye wekwek ƚenistitskii pekhe'en qa qi in ƚe'sits iye, qa pa' Jesús qa yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Nam hatse' pe' neƚutsji' qa enewe' hane'ej ƚi'weni'ƚ qa' ham pe'qu' ewii'ƚe' uteye' qu' amani'ipji' pekhepe' iye uteye'. Week qu' jaƚaq'eju'kii hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma' qa nifaakanijha pa'aj pekhewe'en, qa yit'ijets pa'aj: —Maestro, ¿pa'n ipƚu'uk'ui qu' namets kakha' ƚit'ij? ¿Pa'n ƚunye'j iye pa'qu' jutsiqaxi'ij hatse' ekewe' wekwek qu' hats k'esiyuye'ets qu' namets qu' ƚunye'je'kii?— ");
INSERT INTO mca_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Qa pa' Jesús qa yit'ij pa'aj in yeku'ƚ: —¡Jeƚi'ƚiju'ƚha, hats'inha qa'nte' awitjaxti'yi'iƚ! Qe olots hatse' pe'qu' nanam qa' netyinenyij, qa' nit'ijju': “Yakha' Cristo.” Qa' nit'ij iye: “Hats yamets hane'ej pa' ƚahats'ij.” Qa' hasu'uj ijayani'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Qa qu' impi'ye'eƚij pe'qu' nawatlan qa pekhewe' qu' natya'yij wetju'ƚkii pa'qu' nuten, qa' hasu'uj e'nijiwe'yi'ƚ, qe les ƚe'wis qu' nojo qu' ƚunye'je'kii ekewe' wekwek. Qa nite'ƚe aje'eƚ qu' namets pakha' ƚ'aka'the'ju' ha'ne hane'ej ƚahats'ij.— ");
INSERT INTO mca_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma' qa yit'ijets iye pa'aj: —Pa'qu' witset'e qa' nawatlani'ƚ pakhape' iye witset'e. Ewi'ƚ pa'qu' wittataye' qa' nawatlani'ƚ pakhape' iye wittataye'. ");
INSERT INTO mca_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na'l hatse' pe'qu' qi qu' nawapja' sehel. Witja'metets qa yipku' iye qu' nana'li' pe'qu' uja'xe' witsetitse'. Qa na' wa'sji' qa' ne'twenhetiiji'pha'm pe'qu' wekweke' qi qu' ni'nijiwei qa pakha' ƚunyejei iye. ");
INSERT INTO mca_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","In mexe nite' ƚunyejeikii hatse' week ekewe'en, ekheweli'ƚ qa' e'nekumhi'yi'ƚi'kii qa' awitjaxti'yi'ƚ. Nite' yili'iƚ ej qu' nowo'oƚ eikii. Qa ekekiti'yi'ƚiikii iye ne' ƚe'lijtsitjiyits ne' judiol qa' opheƚitiyi'ƚ ju'kii iye. Qa ekekiti'yi'ƚetsji'kii iye pe'qu' wittatale' qa pe'qu' netnek'enhei iye (gobernadores), qe ta'ƚ yiwets in ƚatsjayani'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma' qa' iwq'axini'ƚij qu' enfeli'ƚi'm pa'n ƚunye'j in ƚatsjayani'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eni'ƚji'ha pe' atawjetsi'ƚ qu' hasu'uj matji'leti'ƚij pa'qu' it'iƚij qu' me'tweiƚeti'ƚik'i, ");
INSERT INTO mca_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","qe yakha' qu' k'eƚisiƚij pe'qu' e'lijeyi'iƚ qa pa'qu' ikfeliyaxitsi'ƚkiiha iye, qa pekhewe' qu' ejuyi'ƚiju'ƚ qa' ham pa'qu' ƚeke'ye' qu' neweju'ƚiju'ƚ qa qu' nittaxijets iye qu' nite' natsathenik'i pa'qu' it'iƚijiju'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Qa' eniwotk'onhe'yi'ƚijkii iye hatse' yemjeetax qu' alheye'taxi'ƚha, qu' ejefetstaxija, qa e'witk'injayektaxi'ƚha iye, qa ejuwaikaltaxija iye. Qa pe'qu' uja'xe' ekheweli'ƚ qa' natlanhetiiju'ha. ");
INSERT INTO mca_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Qa' week qu' na'napjaxi'ƚ e'm ha'ne sehe' epji' qe ta'ƚets in ƚatsjayani'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Qa hamƚe hami'iikii pa'qu' ewii'ƚe' ne' ewkujitsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Me'nt'unheti'ƚ hasu'uj neqenijani'ƚ ej qa' anaxi'ƚij pe'qu' iƚaxitsi'iƚ. ");
INSERT INTO mca_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Qu' i'wentaxi'ƚ ha'ne Jerusalén qu' namijupkii pe'qu' oq'opheƚinetsiletse', ma' qa' hats enikfe'li'ƚets pa' ƚewuƚ'eye'jju' in hats k'esetsha. ");
INSERT INTO mca_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma' qa pe'qu' na'ni' na' sehe' Judea qa' nilatii ne' utekui, qa pe'qu' na'ni' ha'ne Jerusalén qa' nilatik'uifik'i ha'ne witset, qa pe'qu' na'ni'kii na' ƚ'ejinqa'wet qa' hasu'uj nenek ji'teje'm ha'ne Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Qe pekhewe'en pe' neƚutsji' hatse', hik pakha' pa' witqatja' hatse', hats'inha qa' nafits week kekhewe' wekwek hats we'nika'ajji'. ");
INSERT INTO mca_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Hiyee' enewusits pekhewe' qu' efutse' qu' iwoyitsi'ij ji'teje'm qu' mexe niwkajitshenju' qa pekhewe' qu' mexe nifunen iye pe'qu' ƚelitse' pe' neƚutsji' hatse'! Qe qi hatse' pa'qu' a'taxe' ha'ne sehe' Israel, qa qi iye pa'qu' ƚantanithenkeye'je' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Uja'x pe'qu' naq'alij witqatsjikinet, qa pekhewepe' qa' not'opheƚitiiju' qa newetkaxik'i week pekhewe' witsetiikal. Qa pekhewe' nite' judiol qa' na'ni' na' Jerusalén, qa namƚi'ijii qu' hats nafits pa' ƚahats'ij qu' newetlinenij iye.— ");
INSERT INTO mca_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Na'l pe'qu' jutsiqetsi'ij, axe'm pa'qu' ƚunye'je' ne' junu', ne' juwel qa ne' footekii iye, qa ha'ne sehe' epji' iye, qi qu' neƚ'ilaxtax ene' witsetits, qa' nenq'ijiweyij pa' qi iftsax ƚ'anye'j na' qi iweli' qa pe'qu' ƚeqe t'uyuyitse' iye. ");
INSERT INTO mca_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ene' jukhew qa efuts iye ha'ne sehe' epji' qa nanaxkat'axijju' pa'qu' ƚ'ijiweyaxitse' qu' nijamti'ets pa'qu' ƚunye'je'kii hatse' ha'ne sehe' epji'. Qa pe' qits ƚet'unhaxits ene' wasits qa' nawapja'. ");
INSERT INTO mca_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma' qa' ne'twenhetii ha'ne Ƚa's na' Jukhew qu' nenekijju' pe'qu' wasi'ye'. Qi pa' ƚet'unha'x qa qi iye qu' netujjiha. ");
INSERT INTO mca_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Qu' namtaxets qu' ƚunyejeye'kii ekewe' wekwek, eniipha'm qa' jeƚpha'm qe hats k'esets qu' hats ewejinhetiiƚi'iƚ.— ");
INSERT INTO mca_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma' qa nifel pa'aj aka' ewi'ƚ yejeyumtshenijupi': —Jeƚ qeku'ni'ƚek ne'ej ewi'ƚ higokuk, i'nƚi'i pekhepe' iye najkak'e. ");
INSERT INTO mca_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Qu' i'weni'ƚ qu' hats nata'ƚji' pe'qu' ƚesejetse' qa hats ƚenikfe'li'ƚets in hats ininqapiyu'. ");
INSERT INTO mca_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Qa hik ƚunye'j qu' i'weni'ƚ qu' namets ekewe' wekwek qa' menikfeliti'ƚets na' tenek'enheiji' na' Dios in hats met. ");
INSERT INTO mca_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yijaa'ija aka' hit'iƚij ewets in nite' hamits hatse' pekhewe' qu' nanamji'ju'kii pakha' ƚahats'ij hatse', qa namƚi'ijii qu' week ƚunye'je'kii ekewe' hats hit'ij. ");
INSERT INTO mca_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na' wa's qa ha'ne sehe' hamits hatse', qa ekewe'ƚe hats hit'ij qa nite' ƚeke' qu' hamitse'. ");
INSERT INTO mca_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Matjanitheni'ƚkiiha, iwejinkitek'iƚij pe' atawjetsi'ƚ qu' naqamaxji' na'aj ƚisu'uni'ƚji' qe ƚaqsiiƚijkii, qa pa' witk'uwetax iye, qa pa' wittawje'mete'ej eke' wekwek ha'ne witiƚa'x. Hats'inha qu' namtaxets pa' neƚuji' hatse' qa'nte' enf'eliyi'iƚiju'ƚ qu' hik ƚunye'je' na'aj witiwqe'l, ");
INSERT INTO mca_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","qe week qu' na'nipji' ene' witsetits ha'ne sehe' epji' hatse'. ");
INSERT INTO mca_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Qa hik ta'ƚijupi', matjanitheni'ƚkii qa' hasu'uj ili'iƚij qu' iyini'ƚ hats'inha qu' nana'li'ƚ e'm pa'qu' et'unhaxitsi'iƚijup qu'nte' neqenijani'iƚ ej week ekewe' wekwek qu' namtaxets qu' nana'l, ma' qa' ƚeke'ye' qu' ats'ap'ayi'iƚifi hatse' na' Ƚa's na' Jukhew, ham ijiweyaxitsi'iƚi'm.— ");
INSERT INTO mca_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pa' Jesús neƚuji'jij qa i'nq'ijatshenjiifi ke' qi witlijtsitjii, qa najaiƚe qa ikji'jii qa amaneiji'ji' ke' utek ƚii Olivos. ");
INSERT INTO mca_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Qa week pekhewe' jukhew qa efuts iye mexe ham ji'ij junuye' qa wekiya'fji'jii ke' qi witlijtsitjii qu' nepiye'ji'ij. ");
INSERT INTO mca_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hats k'esetsha pa'aj qu' namets pa' ƚe'wis neƚu witkujiiji' pe' pan nite' yetsji'ƚ pe'qu' levaduraye', qa ƚenqii iye Pascua. ");
INSERT INTO mca_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei qa wo'oikii pa'aj pa'n qu' ƚeqfenyejeyi'ij qu' nanat'inij qu' nilan pa' Jesús, qe nijiweyiju'ƚ pe' week jukhew. ");
INSERT INTO mca_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma' qa pa' Satanás qa uiji'teje'm pa'aj pa' Judas, ƚenqii iye Iscariote, hik pakha' i'ntaxji'teje'm pe' doce (12) ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pakha'an qa ikii pa'aj qu' natfaakateyi'ƚju' pekhewe' tenek'enhe'yij pe' pa'il qa pekhewe' iye yejeƚ ke' qi witlijtsitjii, qa nifeli'm pa'qu' ƚeqfenye'ji'ij qu' netisij pa' Jesús pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pekhewe'en qa qi in ƚe'sitsi'mkii pa'aj qa yiwjutsiqeni'mha pa'aj qu' netisij hatse' pe'qu' ƚ'astaye'. ");
INSERT INTO mca_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pakha'an qa t'eku'miju'ƚ pe' tefelhiti'yi'm. Ma' qa wo'oikii pa'aj pa'qu' iwemetsaxe' qu' ƚeke'ye' qu' net'ihinij pa' Jesús qu' nite' na'ni'ijup pe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Qa hats yamets pa'aj pa' ƚe'wis neƚu witkujiiji' pe' pan nite' yetsji'ƚ pe' levadura qa ƚenqek'ujiiji' iye na'aj kots'etax ƚa's qu' net'ejuyets pa' ƚe'wis neƚu Pascua. ");
INSERT INTO mca_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma' qa pa' Jesús qa yukin pa'aj ha' Pedro qa ha' Juan, qa yit'ijets: —Mathayini'ƚ qa' ajileti'ƚ pa'qu' jinteƚuj qu' net'ejuyets pa' ƚe'wis neƚu Pascua.— ");
INSERT INTO mca_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hekhewe'en qa yit'ijets pa'aj: —¿Pa'n i'ni' pa' ƚisu'un qu' hajileti'ƚi' pa'qu' inaqe'?— ");
INSERT INTO mca_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pa' Jesús qa yeku'ƚ: —Qu' ami'ƚets na' witset qa hikna' i'weni'ƚi' pa'qu' ewi'ƚ jukhewe' qu' neka'x pe'qu' camusiye' i'nji' pa'qu' iweli'ye' qa' ijayani'ƚpha'm, amƚi'iƚijii pe'qu' nuyifi wititsi'ye'. ");
INSERT INTO mca_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Qa' it'iƚijets pakha' tetsii: “Ha' Maestro yit'ij ei: ‘¿Pa'n i'ni' pakha' ƚatawe'j ene' wititsi' qu' ha'ni'ƚiji' ene' yijatshenhei qu' heyeki'ƚju' qu' net'ejuyets pa' ƚe'wis neƚu Pascua?’” ");
INSERT INTO mca_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pakha'an qa' nethiniƚij na' te'weipha'm ne' wititsi' epk'etsaxifi qa week hats q'axitsju' ne' wekwek. Qa' hikna' aqsiiƚiji'kii qu' ajileti'ƚ pa'qu' jinteƚuj hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ma' qa pekhewe'en qa ikkii pa'aj, qa week yi'wen aka' hats yit'ijets pa'aj pa' Jesús. Ma' qa yaqsiijkii pa'aj qu' najilet pa' ƚaq t'ejuyets pa' ƚe'wis neƚu Pascua. ");
INSERT INTO mca_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","In hats yamets pa'aj pa' uja'x pe' hora, qa pa' Jesús qa he' apóstoles iye qa i'nijupju'kii pa' mesa. ");
INSERT INTO mca_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pa' Jesús qa yit'ij pa'aj: —Hayits qa qi'ija in hisu'un qu' k'eyekufetsi'ƚji' ha'ne ƚe'wis neƚu in mente' yamets pakha' qi qu' haats'e'ej. ");
INSERT INTO mca_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Qe yakha' hit'iƚij ewets in hats nite' k'eyekufetsi'ƚ iye, ipƚu'ƚi'ii iye hatse' nakha' tenek'enhe'yi' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma' qa t'eku'mi' pa'aj pa' tok'o qa in hats yit'ijetspha'm pa'aj ƚe'wisij pa' Dios, qa yit'ij pa'aj: —Iya'aƚji' hane'en, e'weeki'iƚij. ");
INSERT INTO mca_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Qe yakha' hit'iƚij ewets in hane'ej qu' nata'ƚi' qa hats nite' nek'iya'ye'ji' iye pa'qu' uwa ƚ'iye', ipƚu'ui qu' nanamtax na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Qa t'eku'mi' iye pa'aj pa' pan, qa in hats yit'ijetspha'm iye pa'aj ƚe'wisij pa' Dios, qa napk'asitju' pa'aj, qa netisijju' pa'aj he' ƚ'ijatshenhei. Ma' qa yit'ijji'ju' iye pa'aj: —Aka'an yese'n, wetƚisƚetij qu' nawa'm qe ta'ƚi'ƚ ewets. Aqsi'ji'ƚijkii aka'an hats'inha qu' anjamtijiiƚyik'i.— ");
INSERT INTO mca_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Qa hik ƚunye'j iye pa'aj in t'eku'mi' pa' tok'o in hats yili'ij pa'aj in tek, qa yit'ij pa'aj: —Ha'ne i'nji' ha'ne tok'o hik ha'ne pakha' ink'ayik qu' nenit'ij qa hik enewe' yathits, t'ilitfik'i hatse' qe ta'ƚi'ƚ ewets. ");
INSERT INTO mca_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Qa ha'neƚi'ij nakha' ƚokoi na' t'ihinyij hatse' hats i'nyijup ha'ne mesa ijup. ");
INSERT INTO mca_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Qe yijaa'ija, ha'ne Ƚa's na' Jukhew hats ikƚi'ij qa' hik ƚunye'je', in ƚ'anyejeyek kekhewe' hats we'nika'ajji' t'ejuyets nakha'an, qa ¡hiyee'ƚe ha'nus nakha' t'ihinyij hatse'!— ");
INSERT INTO mca_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma' qa pekhewe'en qa watfaakateji'ijju' pa'aj ƚek pakha' pa' yaqsiijkii hatse' aka'an. ");
INSERT INTO mca_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hekhewe' ƚ'ijatshenhei qa tek'eƚeyiteetsijju' pa'aj ƚekpa' qu' les qiye'ji'ha pa'qu' ƚunye'je' hatse' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pa' Jesús qa yit'ij pa'aj: —Nekhewe' wittatal ne' witsetits nite' judiol, ewi'ƚƚe in yisu'un qu' nethinkii pa' ƚet'unhaxits in tenek'enhei qa na'aj inaqyaji'ij qa wanaqsiijkii. Qa nekhewe' te'weyik'uiju' nekhewe'en qa titijiti'yijetsek in ƚe'wis pa'qu' naqsiijkii. ");
INSERT INTO mca_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Qa ekhewelƚi'iƚ qa hasu'uj qu' hik ejunyejeyi'iƚ aka'an. Pakha' qu' les qiye'ji' ekheweli'ƚ, naqsiijkii qu' hik ƚunye'je' qu' nite' qiye'ji'. Qa pa'qu' netnek'enhei qa naqsiijkii qu' hik ƚunye'je' qu' witqejkunenek'e. ");
INSERT INTO mca_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Qa ƚek pakha' les qu' qiye'ji'? ¿Me pakha' qu' na'nijup pa'qu' mesaye' qu' netek? ¿Me i'nƚi'i pa'qu' witqejkunenek'e? Ehe, pakha' i'nijup pa' mesa hik pakha' les in qiji'. Qa yakha'ƚe in ha'ni'ƚ etji'teje'm qa hik yijunye'j qu' yewitqejkunenek'e. ");
INSERT INTO mca_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ekheweli'ƚ week ƚahatsiyij ƚa'ni'ƚ yijijup kekhewe' yinjaajinkeyejeikii. ");
INSERT INTO mca_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Qa in ƚunye'jek na' Tata in tseƚisij nakha' qu' heinek'enhe'yi', qa yakha' qa' k'eƚisjiiƚijek ");
INSERT INTO mca_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","qu' eki'ƚipji' na' yeqe mesa nakha' qu' heinek'enhe'yi'. Qa' ni'iƚipji' ne' qitsji' wits'ojilaxits qu' ejeyumtsheni'ƚ nekhewe' doceju' (12) witsetits ta'ƚetskii ke' ƚelits ka' Israel'ik'i.— ");
INSERT INTO mca_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Simón, Simón, ek'en qeku'nek, na' Satanás hats iyini'ƚ ewets qu' najaajini'ƚ, qa' hik ƚeqfenyejeyi'iƚ ej ne'ej trigo qe wanaqsi'jji' qa wenit'ijkii ful ful. ");
INSERT INTO mca_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Qa yakha'ƚe qa k'iyin'epji' hats'inha qu' nite' hame'em pa'qu' nite' eqekuye'je', qa akha' qu' hats etpiltax yiwets iye qa iftits'ijets ne' ejefets qu'nte' niliyi'ij qu' net'units.— ");
INSERT INTO mca_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ha' Simón qa yit'ij pa'aj: —Yatsat'axyij, inye'jƚu' qu' k'oyopheƚifeye' i'nƚi'i qu' k'eyiwamhifeye'. Nite' ts'ijiwei.— ");
INSERT INTO mca_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pa' Jesús qa yit'ij: —Pedro, hit'ij ewets hane'ej ha'ne naja'xji' in nite' ip pa'qu' ta'a'aye', ipƚu'ui qu' hats wetshetk'ewi'ƚij qu' mewelku'tyijkii, qa it'ijets qu' nite' enikfe'le'yij.— ");
INSERT INTO mca_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pa' Jesús qa nifaakanji'ju' pa'aj, qa yit'ij: —In k'ukini'ƚijkii hik aka'aj qu' enfeli'ƚ eke' wi'tlijei qa k'ayaji'iƚijets qu' hasu'uj eka'xi'ƚ pe'qu' aq'astayi'iƚ qu' ijutsjayiƚik'iju' eqelutsitsi'ƚ, qa pa'qu' eqe ti'naji'iƚij pe'qu' aqatsi'iƚ qa pe'qu' eqjefetsi'iƚ iye otshilaxtiyi'iƚ, ¿me qa hamitsi'ƚ e'm pe'ye' hik aka'aj?— Hekhewe'en qa yeku'ƚ pa'aj: —Ham hami'iƚ ye'm hik aka'aj.— ");
INSERT INTO mca_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma' qa yit'ijets iye: —Qa ha'neƚi'ij qa hats tujtseika' ƚunye'je', pa'qu' natq'astajiyii qa' neka'x. Qa pa'qu' nana'li'm ƚeqeti'naje' ne'ej ƚaqats qa' neka'x. Qa pa'qu' ham ƚaqatsjikinet'e qa' net'ihinij pa'qu' ƚ'uihitjiye' qa' nataqha'yets pa'qu' ƚaqatsjikinet'e. ");
INSERT INTO mca_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Qe yakha' hit'iƚij ewets in les ƚe'wis qu' na'nyi'pji' qa' nafits aka' hats we'nika'ajji' in yit'ij: “Tojonkaxti'yik'i pekhewe' uƚ'ets jukhew.” Qe yijaa'ija kekhewe' week hats we'nika'ajji' qu' yijunye'je'kii, nite' ƚeke' qu' nijanik'i.— ");
INSERT INTO mca_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hekhewe'en qa yit'ijets: —Yatsat'axyij, jeƚ qeku'nek, enewe'en wetsjuk witqatsjikinetits.— Qa yeku'ƚ pa'aj pakha'an qa yit'ij: —Hayits hats ujaxƚu'.— ");
INSERT INTO mca_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pa' Jesús qa ikik'uifik'i pa'aj pa' witset, qa pa' hats ƚunye'j ji'ij, ma' qa ikji'jii ke' utek Olivos, qa he' ƚ'ijatshenhei qa yijayanjiik'i pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma' qa yamets pa'aj pakha' i'nji'ji', qa yit'ijets hekhewe'en: —Iyiini'ƚha, hats'inha qu' nite' neqenijani'iƚ ej na' witaqjaajinkeye'j.— ");
INSERT INTO mca_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pa' Jesús qa ikik'ui pa'aj pa' ha'niiji'in in ipƚu'uk'i ek ne'ej ute qe jitewu'm, qa wonokok'eni'ju' pa'aj qa iyin. ");
INSERT INTO mca_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Qa yit'ij pa'aj: —Tata, qu' isu'un qa' iwu'myik'ui nakha' qu' nek'iya'aj tok'o i'nji' na' qi in ek'imiiji'. Qa hasu'ujƚe qu' nanaqsiijkii pakha' qu' yakha' ye'ƚe qu' hisu'un. Akha' yijat'ij pa'qu' isu'un.— ");
INSERT INTO mca_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma' qa nametsju' pa'aj pa' ewi'ƚ ángel ta'ƚiipha'm na' wa's qu' netisij pa'qu' ƚet'unha'xe'. ");
INSERT INTO mca_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pa' Jesús qi in yoksi'wen pa'aj pakha' qi a'tax hatse', ma' qa qi'ija in we'nt'unhet pa'aj in iyin qa pa' ƚenejut'ax qa hik ƚunye'j ne'ej wit'athits in qitsju' qe tsaptsapijukii sehe'. ");
INSERT INTO mca_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","In yili'ij in iyin pa'aj qa niipha'm qa ikii pe' ƚ'ijatshenhei pa' i'ni'. Qa hats ima'ju' pa'aj hekhewe'en qe yeqiwefijju' in qi in itawje'metets. ");
INSERT INTO mca_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Qa yit'ijets pa'aj: —¿Inhats'ek in ƚama'aƚju'? Eniyi'ƚpha'mkii qa' iyini'ƚ, hats'inha qu' nite' neqenijani'iƚ ej na' witaqjaajinkeye'j.— ");
INSERT INTO mca_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","In mente' yili'ij pa'aj in iyet pa' Jesús qa namets pa'aj pe' olots jukhew, qa pakha' ƚii pa'aj Judas hik pakha' i'ntaxji'teje'm iye pa'aj he' doce (12) ƚ'ijatshenhei, nojo'ok'oi pa'aj pekhewe'en. Qa nekets pa'aj pa' Jesús qe qa netuje'm. ");
INSERT INTO mca_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Qa pa' Jesús qa yit'ij pa'aj: —Judas, ¿me in ƚetuje'm qa ƚ'ihinij ha'ne Ƚa's na' Jukhew?— ");
INSERT INTO mca_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pekhewe' metitsifi pa'aj pa' Jesús in yi'wen pa' ƚunye'jkii, qa yit'ijets pa'aj: —Yatsat'axyij, ¿me ƚisu'un qu' heqfekini'ƚij je'm ene' yaqa'tsjikinetitsi'ƚ?— ");
INSERT INTO mca_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma' qa pa' ewi'ƚ pa'aj hekhewe'en qa yifekin je'm pa' ƚeqejkunenek pa' qiji' ƚatata pe' pa'il qa yasinii pa'aj qa k'itsii pe' ƚekfi'ik'i yiya'yik'i te'weiji'. ");
INSERT INTO mca_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pa' Jesús qa yit'ij pa'aj: —Hasu'uj meqfekini'ƚ je'm. ¡Ili'iƚij!— Pa' Jesús qa t'eku'mets pa'aj pe' ƚekfi' pa' witqejkunenek qa yiƚin pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ma' qa pa' Jesús qa yit'ijets pa'aj pekhewe' tenek'enhe'yij pe' pa'il qa pe' tenek'enhe'yipji' pe' yejeƚ pe' qi witlijtsitjii qa pekhewe' iye tenek'enheiji' pa' witset: —¿Inhats'ek in ƚenteneyi'ƚij ne' aqa'tsjikinetitsi'ƚ qa ne' ek'uli'ƚ najak? ¿Me hik yijunye'j pa'qu' ewi'ƚe' ejtenhetsax? ");
INSERT INTO mca_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yakha' in ha'ni'ƚ etji'teje'mkii week neƚuts ne' qi witlijtsitjiyii, qa ham pa'qu' ewi'ƚe' ekheweli'ƚ qu' net'eku'myi'. Qa ƚantsat'etsƚi'iƚij ene' hane'ej hora qa nakha' iye ƚet'unha'x na' nookii ƚantsat'etsi'ƚij iye.— ");
INSERT INTO mca_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ma' qa pekhewe'en qa t'eku'mi' qu' nophe'ƚ pa' Jesús, qa yeka'xii pa'aj pe' ƚetsi' pa' qiji' ƚatata pe' pa'il. Qa ha' Pedro qa yijayantaxij pha'mkii pa'aj qa toxƚi'iju'ƚkii. ");
INSERT INTO mca_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pekhewe'en in hats niƚani' pa'aj pa' fe't pa' joofji'ju' pe' wititsi'ii, qa i'nijup pa'aj, qa ha' Pedro qa i'nji'teje'm pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Qa pe' ewi'ƚ witqejkunenki', in yi'wen pa'aj in i'nijupju' pa' fe't qa nalitetsju', ma' qa ts'in pa'aj in yejeƚju', qa yit'ij: —Hane'en, qete'e' hik ha'ne iye hakha' ƚijts'eji'ijjkii.— ");
INSERT INTO mca_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Qa welkutƚi'ijkii pa'aj ha' Pedro, qa yit'ijets pe' efu: —Efu, nite' tsikfe'lets pakha'an.— ");
INSERT INTO mca_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Qa sujƚe iye pa'aj qa na'l iye pe' yejeƚju' iye qa yit'ijets: —¡Qete'e' hik akha' iye ƚa'nji'teje'mkii hekhewe'en!— Ha' Pedro qa yit'ij iye pa'aj: —¡Efu, nite'! ¡Nite' yakha' pekhewe'en!— ");
INSERT INTO mca_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Qa hats ewi'ƚ pa'aj hora t'ani' qa na'l iye pa' yumti'ija qa yit'ij: —Yijaa'ija in hik ha'ne hekhewe' ƚijts'eyekkii, qe hane'en Galilea ƚeiƚe' iye.— ");
INSERT INTO mca_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ha' Pedro qa yit'ij iye pa'aj: —Jukhew, ¡nite' tsikfe'lets kakha' ƚit'ij!— In mexe nite' naq'axtaxijik'i pakha' yit'ij in welkut'ijkii, ma' qa iipƚek pa'aj pa' ta'a'a'. ");
INSERT INTO mca_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma' qa pa' Yatsat'ax'inij qa hik pakha'aj t'atsji'ƚfik'i qa lee'sii pa'aj in nejeƚii ha' Pedro, ma' qa ha' Pedro qa yijamti'ik'i pa'aj ke' ƚe'lijei pa' Yatsat'ax'inij in yit'ijets pa'aj: —Ha'ne naja'xji' tees qu' nap pa'qu' ta'a'aye' ipƚu'ui qu' hats wetshetk'ewi'ƚij qu' mewelku'tyijkii.— ");
INSERT INTO mca_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma' qa ikfik'i pa'aj ha' Pedro qa qi in ip pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pekhewe' jukhew testi'yij pa'aj pa' Jesús qu' nejeƚets, qa qi in yawitji pa'aj qa yilanje'mkii iye. ");
INSERT INTO mca_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yit'onjo' iye pa'aj ƚotoi, qa nifaakanji'ij: —¿Ƚek pakha' te'ek nalan?— ");
INSERT INTO mca_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Qa olots iye pekhewep iye wekwek yit'ijetskii t'ejuyiju'ƚ pakha'an, in uƚ'etsik'i ƚe'lijeyetskii. ");
INSERT INTO mca_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","In hats neƚukii pa'aj qa not'ax wetju'ƚ pekhewe' tenek'enheiji' pa' witset qa pe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei, ma' qa wetka'xii pa'aj pa' Jesús pa' not'axi' wetju'ƚ pekhewe'en. Qa hikpa' qa tafaakanheti'yi'kii pa'aj: ");
INSERT INTO mca_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Qu' hik akha'ye' pa' Cristo, yape enfeli'ƚ ye'm.— Pa' Jesús qa yeku'ƚ: —Qu' hi'ttaxi'ƚij ewets: “Ehe, yakha',” qa' esqeku'ƚi'iƚij iye. ");
INSERT INTO mca_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Qa qu' k'afaakantaxi'ƚij pe'ye', tees qu' esku'ƚi'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Qa ha'neƚi'ij qu' nata'ƚi', qa ha'ne Ƚa's na' Jukhew qa na'ni'ju' na' yiya'yik'i nakha Ham Ƚet'unhenye'ji'iju'ƚ in Dios.— ");
INSERT INTO mca_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma' qa yit'ijju' pa'aj pe' week: —Ye'ehe, ¿me qa hik akha' pa' Ƚaa'sija pa' Dios?— Qa pa' Jesús qa yeku'ƚ pa'aj: —Ehe, yakha', ƚ'asiini'ƚik'iha in ƚit'iƚij yiwets.— ");
INSERT INTO mca_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma' qa yit'ijju' pa'aj pekhewe'en: —¿Inhats'ek qu' menjiit hami'ik'ui iye pakhape' iye qu' nenfelijkii pa'qu' ƚunye'je' hane'en? Inekhewel hats jitepi'ye'ejha kakha' yit'ij.— ");
INSERT INTO mca_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma' qa week niipha'mkii pa'aj pekhewe'en, qa yeka'xii pa' Jesús pa' Pilato. ");
INSERT INTO mca_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Qa in yamijii pa'aj, ma' qa hik pakha'aj qa yit'ijetskii pekhewe'en pe' wekwek yit'ijets in yaqsiijkii pakha'an, qa yit'ijju' pa'aj: —Hats hi'weni'ƚ ha'ne jukhew in yink'aihittaxik'ui qa yiwuƚ'enhettaxijkii aka' ƚunye'jtax ha'ne initset, ma' qa inqaq'ayintaxij in tajaikii eke' wekwek qu' net'ejuyets pa' Roma ƚatata (César), qa yit'ij ƚetets iye in ƚakhaati'ija pa' Cristo, qi wittata.— ");
INSERT INTO mca_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma' qa pa' Pilato qa nifaakan pa'aj: —¿Me akha' pa' qi ƚatata ene' judiol?— Qa yeku'ƚ pa'aj pa' Jesús: —Ehe, yakha'.— ");
INSERT INTO mca_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Qa pa' Pilato qa yit'ijji'ju' pekhewe' tenek'enhe'yij pe' pa'il qa pekhewe' iye olots jukhew: —Ham hi'weni'ij pa'qu' uƚ'axe' ha'ne jukhew.— ");
INSERT INTO mca_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Qa pekhewe'en qa yape'enhaƚe yit'ijju': —Kekhewe' i'nq'ijatshenij nakha'an t'ayijji' in yeƚ'ilehet ha'ne week witset. Hats naq'axij in yijatshenij ha'ne week Judea, ta'ƚijii ha' Galilea qa namƚi'ij met hane'e'in.— ");
INSERT INTO mca_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pa' Pilato in yepi'ye' ek'i pa'aj ekewe'en, qa inaqfaakanij: —¿Me Galilea ƚeiƚe' ha'ne jukhew?— ");
INSERT INTO mca_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pa' Pilato in nikfe'lets pa'aj pa' Jesús in ta'ƚii pakha' sehe' tenek'enheiji' ek pa' Herodes, ma' qa yukinii pa'aj pa' Herodes, hik pakha' namii iye pa'aj na' Jerusalén pekhewe' neƚutsji'. ");
INSERT INTO mca_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pa' Herodes in yi'wen pa'aj pa' Jesús, qa qi'ija in ƚe'wisi'mkii, qe hats tooxik'i pa'aj in neqwenkeyu'taxij qe ta'ƚets pekhewe' impiye'ji'jij yaqsiijkii pakha'an. Qa neqwenkeyu'uj qu' naqsiijkii pa'qu' ewi'ƚe' ham ƚunye'ji'iju'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ma' qa qi in nifaakantaxkii pa'aj, qa pakha'ƚe Jesús qa nite' yeku'ƚ pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pekhewe' tenek'enhe'yij pe' pa'il qa pe' i'nq'ijatshenij iye ke' Moisés ƚe'lijei, hik pakha' ts'ap'a'aju' iye pa'aj, qa qi in yit'ijetskii pekhewe' wekwek yit'ijets in yaqsiijkii pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma' qa pa' Herodes qa pe' ƚeqejkunenhei oq'opheƚinetsilets in hats yili'ij pa'aj in qi in yawitji pekhel ƚeqfenyejeyijkii, ma' qa pa' Herodes qa yuihinik'ipha'm pa'aj pa' ƚe'wis ƚe'ntilafittax qa yepiletii iye pa'aj pa' Pilato. ");
INSERT INTO mca_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma' qa hik pakha'aj pa' neƚuji' qa witjuwaikayek'iƚ pa'aj pa' Pilato pa' Herodes qe mexe wanapjajitax pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pa' Pilato qa taya'yii pekhewe' tenek'enhe'yipji' pe' pa'il qa pe' tenek'enheiji' pa' witset qa week pakha' witset. ");
INSERT INTO mca_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Qa yit'ijji'ju': —Ekheweli'ƚ ƚenkaxi'ƚyii ha'ne jukhew, ƚit'iƚijets in qi in t'ayijji' qa yeƚ'ilehet ha'ne witset. Qa yakha' qa hats ƚe'tsweni'ƚij in hanfaakantaxkii, qa ham pa'qu' ewi'ƚe' qu' hi'wenij qu' uƚ'axi'ijupi' ha'ne jukhew, qu' hik ƚunye'je' kekhewe' ƚit'iƚijets in uƚ'ets in yaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Qa hik ƚunye'j iye ha' Herodes, qe nepiletmet iye. Hane'en hats ƚi'weni'ƚ, ham ta'ƚi'ijupi' qu' ƚeke'ye' qu' natlanhetii. ");
INSERT INTO mca_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Qa hik ta'ƚijupi', mexe qu' hitani'then qa i'nk'aƚe qa' hiwejin hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pa' Pilato in hayiits ƚeqfenye'jji'jij qa yamji'jets aka' ƚe'wis neƚu qa yiwejinji'ij pa'qu' ewi'ƚe' wit'opheƚik'e. ");
INSERT INTO mca_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Qa week taya'yijipji' pa'aj pekhewe' jukhew, ewi'ƚik'i ka' yit'ijju': —¡Natlanhetii nakha'an qa' netwejinhetii ha' Barrabás!— ");
INSERT INTO mca_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Qe pa' Barrabás in t'opheƚitii pa'aj qe ta'ƚijupi' in taya'yijipji'kii in yutentax pe' tenek'enhei qa teqek'ui iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pa' Pilato yisu'untax qu' niwejinƚe pa' Jesús, ma' qa ewi'ƚij iye in iyettaxji'ju' iye pe' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Qa pekhewe'ƚe'en qa yape'enha taya'yij wetju'ƚ in yit'ijju': —¡Ne'nenji'pha'm cruze'! ¡Ne'nenji'pha'm cruze'!— ");
INSERT INTO mca_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Qa pa' Pilato qa yittaxijji'ju' iye ma' qa hats wetshetk'ewi'ƚij: —¿Inhats'ek qu' natlanhetii? ¿Pa'n ƚunye'j pa' uƚ'ax in yaqsiijkii hane'en? Ham hi'weni'ij hane'en pa'qu' uƚ'axe' qu' hikpa' nata'ƚets qu' natlanhetii, qa hik ta'ƚijupi', mexe qu' hitani'then eku'n qa' i'nk'aƚe qa' hiwejin hatse'.— ");
INSERT INTO mca_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pekhewe'en qa yape'enha qi in taya'yijipji'kii in iyinijets qu' ne'nenji'pha'm cruze'. Ma' qa pa' Pilato qa ƚexke'ej. ");
INSERT INTO mca_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pa' Pilato ma' qa inaqyaji'ij pa'aj qu' nanaqsi'ji'mijkii pakha' iyinets pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Qa yiwejin pa'aj pakha' iyinets pekhewe'en qu' netwejinhetii, pakha' t'opheƚiti'yipji' pa'aj in taya'yijipji'kii in yutentax pe' tenek'enhei qa teqek'ui iye pa'aj. Qa pakha'ƚe Jesús qa tisij pakha' yisu'un pekhewe'en qu' ƚeqfenyejeyi'ij. ");
INSERT INTO mca_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","In wetka'x pa'aj pa' Jesús qu' ne'nenji'pha'm pe' cruz, qa te'nekumhi'yi' pa'aj pa' ewi'ƚ jukhew Cirene ƚeiƚe' ƚii Simón ta'ƚiifik'i pa' ƚ'ejinqa'wet, qa tayajaxti'yijets qu' neka'x pe' cruz, qa yeka'xi'm pa'aj. Pa' Jesús yojo'ok'oi qa pakha'an qa teke'lenijju' pa'aj pe' cruz. ");
INSERT INTO mca_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Olootsija pa'aj pe' jukhew yijayanpha'mkii pa'aj, qa pe' efuts iye pa'aj qi in yayinju' neq'elettaxij. ");
INSERT INTO mca_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pa' Jesús qa tetwek'elaxiju'ƚ pekhewe'en, qa yit'ijets pa'aj: —Efuts, Jerusalén ƚeiƚekii, hasu'uj ats'ayini'ƚju'. Ekheweli'ƚ yijat'ij qu' manayinƚi'iƚju' qa pe'qu' elitsi'iƚ iye. ");
INSERT INTO mca_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Qe nam hatse' nekhewe' neƚutsji' qu' it'iƚijju': “Ƚe'sitsi'mkii pekhewe' qu' ints'atekiiye', pekhewe' qu' mexe ham pe'qu' ƚelitse' qa pekhewe' iye qu' mente' neqfunene'.” ");
INSERT INTO mca_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma' qa' yapeye'ƚek qa ittaxi'ƚijets ne' utekui: “¡Anami'ƚyipji'!” qa nekhewe' pumumpha'mkii utekui ƚelits qa ittaxi'ƚijetsek: “¡Atsat'ini'ƚkii!” ");
INSERT INTO mca_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Qe in ƚenifenye'j aka'an nekhe' najkak asaƚ'ai, ¿qa pa'n qu' ƚenifenye'je' hatse' nekhe' ƚawa'mhine'?— ");
INSERT INTO mca_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wetka'x iye pa'aj pekhewe' wetsjuk uƚ'ets jukhew, qe qa' ƚawamhifetse' iye. ");
INSERT INTO mca_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","In yamijii pa'aj pa' ƚenqii “Witjiƚa'ik'i” (La Calavera), qa hik pakha' qa we'nenji'pha'm pe' cruz pa' Jesús qa pekhewe' iye wetsjuk jukhew qi uƚ'ets. Ewi'ƚ pa' te'weyij yiya'yik'i qa pakhap qa ƚefeyi'j te'weyijek. ");
INSERT INTO mca_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pa' Jesús qa yit'ij pa'aj: —Tata, iwejinƚe enewe'en qe nite' nikfe'lets aka' yaqsiijkii.— Qa pe' oq'opheƚinetsilets qa ikij wetju'ƚ in watk'esaxijju' pa'aj pe' ƚeqhinatai pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Olots pe' nekii pa'aj qa yejeƚju', qa pekhewe' tenek'enhei iye qa qi in yawitji'iji'kii ƚe'lijei qa yilakijukii iye pa'aj, qa yitjiijetspha'm: —Yiƚin pekhewep, yape neteƚinƚe, qu' hik nakha'ye' pa' ƚeqe Cristo pa' Dios, pakha' T'eku'miiji'.— ");
INSERT INTO mca_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Qa pe' oq'opheƚinetsilets iye qi iye in yawitji'iji' iye pa'aj pe' ƚe'lijei, qa iktaxijets pa'aj qu' niyahanji' na'aj wino ewtsik'iiji' (vinagre). ");
INSERT INTO mca_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Qa yit'ijetspha'm pa'aj: —Qu' hik akha'ye' pakha' qi Ƚatata ene' judío, ¡meteƚinƚe!— ");
INSERT INTO mca_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Qa na'l iye pa'aj pa' ƚe'nikahat te'weyik'uipha'm pa' ƚejiƚa', qa yit'ij pe' ƚe'nikatii: —Hane'en hik ha'ne pakha' qi Ƚatata ene' judío.— ");
INSERT INTO mca_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Qa pakha' ewi'ƚ pekhewe' uƚ'ax pa' yaqsiijkii ƚenenhefetsji'pha'm pa'aj pe' cruzits, qa uƚ'etsik'i iye pa'aj pe' ƚe'lijeyets, qa yit'ijets pa'aj: —¿Me nite' hik akha' pa' Cristo? ¡Meteƚinƚe qa yekhewepi'ƚ iye qu' etsiƚini'ƚ!— ");
INSERT INTO mca_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Qa yeku'ƚƚe pa'aj pakhap iye, qa yaq'ayinij, qa yit'ijets pa'aj: —¿Me qa nite' qu' e'nijiweitaxiju'ƚ iye pa' Dios, in akhap iye hane'ej hats qi in ƚ'atanithenhetii? ");
INSERT INTO mca_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Inekhewel hats weju'ƚij aka' jitatanithenheti'yij, qe in jitesti'yij aka'an ta'ƚets kekhewe' uƚ'ets in jitaqsiijkii. Qa haneƚe'en qa ham pa'qu' ƚuk'eye'en qu' uƚ'axe' qu' naqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Qa yit'ij iye pa'aj: —Jesús, menikfelityiikii hatse' wat'ij qu' anamtax iye qa' enek'enhei.— ");
INSERT INTO mca_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Qa pa' Jesús qa yeku'ƚ pa'aj: —Yijaa'ija aka' hit'ij ewets, hane'ejija qu' niyijup nakha' qu' ha'ni' ƚe'wis wititset (paraíso).— ");
INSERT INTO mca_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma' qa in hats natsathenju' pa'aj junu', qa weekij ha' sehe' in nookii pa'aj, qa yamijii in las tres ");
INSERT INTO mca_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ne' junu' in noo'ii pa'aj. Qa pakha' te'weiteje'm pa' ƚejilafi' t'apƚii penyilo ke' qi witlijtsitjiyifi, qa ja'fik'iju' ƚeqewuk'u pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Qa pa' Jesús qa t'unik'i pa'aj in tayai, qa yit'ij: —Tata, ne' okoyei hats hetisij na' yeqe'spiritu.— In yili'ij aka'an in yit'ij, ma' qa s'uff pa'aj qa wa'm. ");
INSERT INTO mca_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Qa pakha' centurión in yi'wen pa'aj aka' ƚunye'jkii, qa qi in yiwqinhetji' pa'aj pa' Dios, qa yit'ij pa'aj: —Yijaa'ija aka' jukhew in qi in yatsathen.— ");
INSERT INTO mca_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Week pekhewe' olots namii qu' nejeƚju' pakha' ƚunye'jkii pa'aj, in yi'wen pa'aj aka'an qa wapilik'uikii pa'aj yilanje'mkii ƚ'ejuijets qe qi in ika'metets wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Qa pekhewe'ƚe week pe' nikfe'li'ƚ wetju'ƚ pa'aj pa' Jesus'ik'i qa pekhewe' iye efuts pe' yijayanik'ikii pa'aj ta'ƚijii in nijayan ha' Galilea'ai, qa totsi'mii pa'aj pa' i'nijupi' ek qa week yi'wenij iye ekewe' wekwek ƚunyejeikii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Qa na'l iye pa'aj pa' ewi'ƚ jukhew ƚii José, i'nji'teje'm pekhewe' Junta Suprema, teik'unei qa yatsathen iye pa'aj, ");
INSERT INTO mca_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","hik pakha' nite' yijayanij pakha' t'eku'mi' pa'aj pekhewe'en in yaqsiijkii, pakha'an Arimatea ƚeiƚe', judiol ƚetset, qa qi in notkitaxets qu' netnek'enhei pa' Dios. ");
INSERT INTO mca_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pakha'an qa yamiiji' pa'aj pa' Pilato qa iyinijets pa'aj pa' Jesus'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","In hats nit'ijju' qa yijuphe'ƚji' pa'aj pa' ƚe'wis penyilo fo' qa inyetax iye, ma' qa yenifi pe' ewi'ƚ nimeƚuk wa'najkaninji'teje'm pe' utek, mexe ham we'neni'ifi pa'qu' nawa'm. ");
INSERT INTO mca_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hik pakha'aj pa' neƚuji' watji'letji' pe'qu' wekweke', ma' qa hats k'esik'iha pa'aj qu' hats witwapiihijiye'. ");
INSERT INTO mca_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Qa pekhewe' efuts pekhewe' ta'ƚijii pa'aj ha' Galilea in nijayan pa'aj pa' Jesús qa yijayanijpha'm pa' José, qa yi'wen pa'aj pe' nimeƚuk qa pa' ƚeqfenye'jij iye in yiwhinju'. ");
INSERT INTO mca_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Qa in wapilii pa'aj pe' ƚetsil qa yaji'let ne'ej ƚesejets yewjisitji' na'aj tenekui qa pe' ewjisiyits iye. Ma' qa pa' witwapiihijiiji' qa wapiiju' pa'aj in ƚ'anyejeyek kekhewe' wenit'ij qu' nanaqsiijkii yika'ajji' pa'aj pa' Moises'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Qa pa' yojo neƚu (domingo) in hats fo'iju' pa'aj sehe', qa pekhewe' efuts qa ikii pa'aj pe' nimeƚuk yeka'xtaxii pekhewe' hats yaji'let ƚesejets ewjisii. ");
INSERT INTO mca_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","In yamtaxets pa'aj qa yi'wen pe' ƚit'otaxij ute pe' nimeƚuk in nite' i'nji' pa' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Qa uitaxifi pa'aj pe' nimeƚuk qa ham qu' ni'wen pe' ƚ'ajiiki pa' Yatsat'ax'inij Jesús. ");
INSERT INTO mca_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pekhewe'en qa ts'iƚitsi'mkii pa'aj in yi'wen aka'an, ma' qa thxuuƚets iye pa'aj pe' wetsjuk jukhew ts'ap'a'ajupju' leppepep pe' ƚeqhinatai, ");
INSERT INTO mca_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ma' qa qi in nijiwei pa'aj qa wonokok'enju'kii yametsju' sehe' in t'upiijukii pa'aj. Qa pe' wetsjuk jukhew qa yit'ijets pa'aj: —¿Inhats'ek in ƚenjeƚtaxiƚijii ke' naxju' hakha' hats nite' wa'm? ");
INSERT INTO mca_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nite' i'ni' hane'e'in, hats iƚa'x iye. Menikfelitiƚik'i kakha' hats yit'iƚij ewets in mexe i'ni'kii ha' Galilea, in yit'ij: ");
INSERT INTO mca_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ha'ne Ƚa's na' Jukhew testi'yij hatse' nekhewe' uƚ'ets jukhew qa' nenji'pha'm pe'qu' cruze' qa' nawa'm. Qa qu' namets wetshetk'ewi'ƚ neƚuts qa' iƚa'xe' iye.”— ");
INSERT INTO mca_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma' qa pe' efuts qa nikfe'lik'i pa'aj ekewe' wi'tlijei. ");
INSERT INTO mca_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Qa tepilik'uikii pa'aj pe' nimeƚuk, ma' qa nifelimik'i week ekewe' wekwek pe' once (11) apóstoles qa week iye pekhewep. ");
INSERT INTO mca_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Enewe' efuts nifelii pa'aj hekhewe' apóstoles, enewe'en: María Magdalena, Juana, ke' María ƚenene ha' Santiago qa hekhewep iye efuts. ");
INSERT INTO mca_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Qa hekhewe'ƚe apóstoles qa hik ƚeqjunyejeyij pa'aj eke' wi'tlijei na'aj wenitƚi'ij qe tefelhitiyik'i nite' yija' qu' ƚunye'je'kii, ma' qa nite' tek'enets pa'aj, yeqeku'. ");
INSERT INTO mca_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Qa hakha'ƚe Pedro qa niipha'm qa wekuma'xii pa' i'ni' pe' nimeƚuk, qa teleqhetinifi pa'aj qa uja'xƚe in yi'wen pe' penyilots. Ma' qa ik iye pa'aj qi in yitjuƚaxijpha'm qa yijamti'ijupkii pa'n ƚunyee'jkiiha. ");
INSERT INTO mca_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hik pakha'aj pa' neƚuji' pe' wetsjuk pekhewe' tek'enets in nekik'iju' pa' wit'ikheyi'j yamii pa' witset ƚa's ƚii Emaús, ipƚu'umii once (11) kilómetro na' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pekhewe'en qi in yifaakateji' pa'aj week aka' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Qa ƚunye'jkii pa'aj pekhewe'en in mexe yifaakateji' pa'aj, qa pa' Jesús qa nijayanpha'm ma' qa ƚijts'eyek pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Qa pekhewe'ƚe ƚotoi pekhewe'en qa mexeƚe hik ƚunyejei qu' netit'oijo' qe qa' nite' nenikfe'li'ij. ");
INSERT INTO mca_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pa' Jesús qa nifaakanij: —¿Ƚekpa' ƚifaakateji'iƚji' ha'ne wit'ikheyi'jik'i?— Qa teke'lenju'kii pa'aj qi in ika'metetskii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Qa pakha' ewi'ƚ pekhewe'en ƚii Cleofas, qa yeku'ƚ pa'aj qa yit'ijets: —¿Me akha' eƚ'ewi'ƚƚe in pakha' ƚataƚik'uiji' na' Jerusalén qu' nite' enikfe'le'ets ekewe' wekwek ƚunyejeyi'kii nakha'an eke' neƚutsik'i?— ");
INSERT INTO mca_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma' qa pa' Jesús qa yit'ijets pa'aj: —¿Ƚek pekhewe' wekwek?— Pekhewe'en qa yit'ijju' pa'aj: —Kekhewe' ƚunyejeikii kakha' Jesús Nazaret ƚeiƚe', hik kakha' ewi'ƚ profetatax qi pa' ƚet'unha'xijup na'aj yaqsiijkii qa ne'ej yit'ij iye, qa yi'wenijha pa' Dios qa week iye ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Qa hekhewe' tenek'enhe'yij he' pa'il qa he' tenek'enheiji' ha' witset in inaqyaji'ij qu' natlanhetiiyija, ma' qa yenji'pha'm ke' cruz. ");
INSERT INTO mca_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yekheweli'ƚ qi in humtitaxi'ƚ qu' hik kakha'ye' pakha' qu' naqsijju'ha qa' netwejinhetiiƚe ene' Israel. Qa hatsƚe wetshetk'ewiƚik'i neƚuts kakha' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Qa na'l iye he' uja'x efuts i'ni'ƚ yitji'teje'm qi in ts'itjuƚati'ƚij iye, qe ikii pa'aj mexe leefiju' ke' ƚenimeƚuk. ");
INSERT INTO mca_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Qa nite'ƚe yi'wen pe' ƚ'ajiiki kakha'an. Qa nami'ƚyii qa nifelkii in yi'wen pe' angelits qa nifeli'm pa'aj in hatste' iƚa'x iye ka' Jesús. ");
INSERT INTO mca_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Qa hekhewe' uja'x hekhewe' i'ni'ƚ yitji'teje'm qa ikkii qa yejeƚii iye ke' ƚenimeƚuk pa'aj, qa yi'wen ka' hats yit'ijju' he' efuts, kakha'ƚe Jesús qa nite' te'wenhetii.— ");
INSERT INTO mca_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma' qa pa' Jesús qa yit'ijets pa'aj: —¡Hayits qa nite' ƚenikfe'li'ƚik'i qa nite' iye aje'eƚ qu' ek'eeni'ƚik'iha week ke' hats nifel ke' profetas'ik'i! ");
INSERT INTO mca_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Me nite' yit'ij qu' les ƚe'wise' pa' Cristo qu' naats'e'ej week ekewe' wekwek ma' qa' nuiji'teje'm pa' tenek'enhe'yi' na' wa'sji'?— ");
INSERT INTO mca_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma' qa nifeeli'mha pa'aj week pekhewe' t'ejuyets pakha'an kekhewe' hats we'nika'ajji' pa'aj, qa ta'ƚijii pe' ƚ'ikahai pa' Moises'ik'i qa teiƚi'ij pe' week ƚ'ikahai pe' profetas'ik'i. ");
INSERT INTO mca_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","In yamets pa' witset ƚa's Emaús hikpa' yamii pa'aj pekhewe'en, qa pa' Jesús qa we'nitonhiftsin ƚi'ik'i pa'qu' nakji'. ");
INSERT INTO mca_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Qa pekhewe'en qa yinijit qu' mexe amane' eku'nijup, qa yit'ijets pa'aj: —A'mane' eku'ni'ƚ yijup. Hats metju' ne' junu'. Hats najaleyiyukii.— Ma' qa yijayanteje'm pa'aj qa amanijup hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Qa ƚunye'jkii pa'aj in hats i'nijupju'kii pa' mesa qu' netekju' qa t'eku'mi' pa' pan qa yit'ijetspha'm ƚe'wisij pa' Dios qa napk'asitju' qa netisijju' pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Qa hik pakha'aj qa hats ƚeke' qu' nenikfe'lij in hik pakha' Jesús, qa aje'eƚƚe qessiikii pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Qa yifaakateji' pa'aj hekhewe'en: —¿Me nite' f'uƚfik'ikii pe' intawjets in i'nk'a nifel ine'm na' wit'ikheyi'jik'i, qa yeqethen inemik'iha iye kekhewe' hayiits we'nika'ajji' pa'aj?— ");
INSERT INTO mca_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pekhewe'en qa nite' optotskii iye pa'aj, qa aje'eƚ wapilii iye ha' Jerusalén, qa iwoyitsii in ewi'ƚ i'niji' hekhewe' once (11) apóstoles qa pekhewep iye, ");
INSERT INTO mca_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","in yit'ijju': —Yijaa'ija in hats iƚa'x iye ha' Yatsat'ax'inij, qa we'nethinets pa'aj na' Simón.— ");
INSERT INTO mca_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma' qa he' wetsjuk qa nifelimik'i' ek pakha'aj in ƚijts'ekii pa'aj wete'm qa nite'ƚe nikfe'lij pa'aj, qa i'nk'aƚe nikfe'ltaxij in napk'asiti'mju' pa'aj pa' pan. ");
INSERT INTO mca_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","In mexente' yilitaxijju' pa'aj in yifaakateji' hekhewe'en, ma' qa we'nethinets pa' Jesús ts'ap'aji'ju' ƚeqewuk'u, qa yit'ijji'ju' in wetfelji'ju' pa'aj: —Na' wit'ikesimeya'xƚekii qu' na'ni'ƚ ejup.— ");
INSERT INTO mca_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Qa pekhewe'ƚe'en qa qi in nijiwei pa'aj, yumtitax qu' ni'wen pa'qu' wit-si'nq'ale'. ");
INSERT INTO mca_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Qa pa' Jesús qa yit'ijji'ju' pa'aj: —¿Inhats'ek in qi in ƚe'nijiwe'yi'ƚ? ¿Qa inhats'ek iye in ƚ'eni'ƚji' eke' witaqjamtikineyejeikii ne' atawjetsi'ƚ? ");
INSERT INTO mca_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jeƚi'ƚ ene' yikoyei qa ene' yif'iyei iye. Yakhaa'ija, nite' ye'tujtseika'. Ku'mi'ƚ yiwetsha qa' enikfe'li'ƚ yiwetsha, qe na'aj witsinq'al ham ƚ'ese'ne' qa ham iye ƚenutse' qa yakha'ƚe qa ƚetsweni'ƚ in week na'l ye'm.— ");
INSERT INTO mca_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","In yit'ijets pa'aj ekewe'en qa yethiinijha pe' ƚokoyei qa pe' ƚef'iyei iye. ");
INSERT INTO mca_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Qa in ƚunyejeyek pa'aj pekhewe'en in mexe nite' yumtii'ija qu' hik pakha'ye' qe ta'ƚijupi' pa' ƚesaxitstaxi'mkii qa in yitjuƚaxijpha'mkii iye pa'aj. Pa' Jesús qa yit'ijets pa'aj: —¿Me na'li'ƚ e'm aqi'iƚ qu' hetuj?— ");
INSERT INTO mca_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Qa testi'yij pa' ewi'ƚ ƚapk'as pa' wit'osjeyik sehets. ");
INSERT INTO mca_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Qa t'eku'miju'ƚ qa tuj pa'aj qa week yi'wenij pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Qa yit'ij iye pa'aj: —Aka'an aka' yinifenye'j hik aka' ka' henfeli'ƚ e'mkii in mexe ha'ni'ƚ etji'teje'mkii, in hit'iƚij ewets qu' les ƚe'wise' qu' nafits qa' nasini'ik'iha kekhewe' week yika'ajji' pa'aj ka' Moises'ik'i qa kekhewe' iye ƚafaakanhei ke' profetas'ik'i qa kekhewe' iye Salmos.— ");
INSERT INTO mca_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ma' qa hik pakha'aj pa' Jesús qa yit'ij qhof pe' ƚaqjamtikineyejeikii ma' qa nikfe'lik'i kekhewe' ƚe'lijei pa'aj pa' Intata. ");
INSERT INTO mca_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Qa yit'ijets pa'aj: —We'nika'ajji' pa'aj, pa' Cristo qu' nawa'm qa qu' namets wetshetk'ewi'ƚ neƚuts qa' iƚa'xe' iye, ");
INSERT INTO mca_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","qa aka' ƚii qa' netfelhitii qa hik aka' nata'ƚets qu' nenikfe'lƚetets qa' nili'ij pe' uƚ'ets in yaqsiijkii hats'inha qu' netwumhiti'yik'ui pe' ƚewuƚ'ets ene' week witsetits, qa' nojo'oj na' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Qa ekheweli'ƚ ƚi'weni'ƚha week ekewe' wekwek qa' enfeli'ƚ. ");
INSERT INTO mca_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Qa yakha' qa' he'nukini'ƚ ewetsju' nakha' hats yiwjutsiqen na' Tata. Qa ekheweli'ƚ, amaneye' ekuni'ƚji' ha'ne witset Jerusalén hatse'ƚu' qu' hats estiitaxi'ƚij na' witt'unha'x ta'ƚetspha'm na' wa's.— ");
INSERT INTO mca_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma' qa i'nk'aƚe pa'aj pa' Jesús qa yeka'xik'uifik'i pekhewe'en pa' witset, qa yamii pa'aj hakha' meti'm ha' Betania, ma' qa yit'ijipji' pa'aj k'eewe ƚokoyei in iyinipji' pa'aj. ");
INSERT INTO mca_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","In mexe iyinipji' pa'aj qa ƚeyijƚem in toxi'mets pa'aj hekhewe'en qa tenilesi'yiju'ƚ na' wa'sji'. ");
INSERT INTO mca_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hekhewe'en, in hats yili'ijju' pa'aj in totjoyik'uiju'kii in qi in iyinets, ma' qa wapilii iye pa'aj ha' Jerusalén qi in ƚe'sitsi'mkiiha, ");
INSERT INTO mca_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","qa week neƚuts yamji'jii pa'aj ke' qi witlijtsitjii qu' niwqinhetji' pa' Dios.");
INSERT INTO mca_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In mexe ham pakha'aj ha'ne sehe' qa hayiits na'l pa'aj hakha' Wi'tlijei. Hakha' Wi'tlijei qa hayiits i'nijup pa' Dios, qa Diosƚe iye. ");
INSERT INTO mca_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hakha' Wi'tlijei, in mexe ham pa'aj ha'ne sehe' qa hayiits i'nijup pakha'aj pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Week ene' wekwek yaqsiijkii pakha'aj Hakha'an, qa qu' hame' hakha'an qa' ham nana'le' enewe' hane'ej na'l. ");
INSERT INTO mca_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hakha'an hayiits na'l ji'teje'm pa'aj pa' witiƚa'x nite' yili'ij, ma' qa ha'ne witiƚa'x qa hik ha'ne qa hik ƚunye'j qu' ƚefetitjiyi'ij ene' jukhew, qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Qa ha'ne fetitjii qa nalittaxipji' pa' nookii, qa pakha'ƚe nookii qa nite' nikfe'lik'uyii. ");
INSERT INTO mca_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Qa nam kakha' ewi'ƚ jukhew nukin pa' Dios, kakha'an qa ƚii Juan. ");
INSERT INTO mca_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kakha'an in nam hik ƚunye'j pakha' qu' nana'li'm na'aj nifelkii, qe qa' nenfelkii hakha' fetitjii, hats'inha qu' week nite' neqeku'ye' qu' nata'ƚets kakha'an. ");
INSERT INTO mca_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kakha'an nite' hik kakha' hakha' fetitjii, qe nam yijat'ij qe qa nenfelkii hakha' fetitjii. ");
INSERT INTO mca_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hakha' yijaa'ija in na'lkii hik ƚunye'j fetitjii, in nametsju' ha'ne sehe', qa nalitipji' ene' week jukhew qa efuts. ");
INSERT INTO mca_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hakha' nametsju' ha'ne sehe' epji'. Hik hakha' yaqsi'jijkii ha'ne week sehe' ipji', qa ha'neƚe sehe' ipji' qa nite' nikfe'lij hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Namtaxii enewe' yatsat'etstaxij, qa enewe'ƚe yatsat'etstaxij qa nite' neqjunu'uju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Qa weekƚe nekhewe' t'eku'miju'ƚ qa neqjunu'uj, qa nite' iye yeqeku' hakha'an, ma' qa testi'yij qu' ƚelitsi'ijha pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hik enewe' in i'nk'a nekfik'ikii iye nite' ta'ƚets ene' wit'esenits, nite' ta'ƚets iye qu' ƚekhewele'ƚe qu' nisu'un, nite' ta'ƚets iye pa'qu' jukhewe', qe ta'ƚets yijat'ij pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma' qa hakha' Wi'tlijei qa wanaqsi'jƚi'ijkii in jukhewij, qa i'ni'ƚyit ji'teje'mkiiha, qa hi'weni'ƚijha ka' qi ƚesa'x, kakha' ƚesa'x hik ƚunye'j in ewi'ƚƚe in Ƚaa'sija pa' Dios, topo'oj pa' qi ƚeqi'fenkeye'j qa pa' yijaa'ija iye in ƚunye'jkii t'ejuyets pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kakha' Juan Bautista in iyetij hakha'an, qa yit'unhetik'i in yit'ij: —Hane'en hik ha'ne k'iyetij in hit'ijets: “Yakha' qa hakha' teke'lenju' qu' nanam, hakha'an qiji'ha t'anyipji', qe hakha'an hayiits na'l pakha'aj qa yakha'ƚe qa yi'nk'aƚe.”— ");
INSERT INTO mca_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Qe week pakha' topo'oj ƚeqi'fenkeye'j hakha'an in jiyeƚisijkii, qa yape'enha les in jiyeƚisijkii nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Qe kekhewe' wenit'ij qu' nanaqsiijkii (ley) in jiyeƚisij pa' Intata qa tisij pa'aj pa' Moises'ik'i, qa pakha'ƚe ƚeqi'fenkeye'j qa pa' yijaa'ija in ƚunye'jkii t'ejuyets pakha'an in jiyeƚisij qa i'nijji' ha' Jesucristo. ");
INSERT INTO mca_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Haamija pakha' qu' hats ni'wen pa' Dios. Hakha' ewi'ƚƚe in Ƚaa'sija, hikha' ewi'ƚ i'ni'ƚi'ha pa' Ƚatata qa hik hakha' qa jiyikfelitets pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ekewe'en kekhewe' ƚe'lijei ka' Juan Bautista'ik'i, hekhewe' judiol in nukin hekhewe' pa'il ta'ƚii ha' Jerusalén qa hekhewe' iye yithayikikiyek ke' qi witlijtsitjii, ƚiyits levitas, qu' nanfaakan ka' Juan pa' ƚunyee'jija. ");
INSERT INTO mca_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kakha'an qa tetfeltaxi'mha, nite' yat'intaxi'm, qa yit'ij: —Nite' yakha' pa' Cristo.— ");
INSERT INTO mca_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Qa ewi'ƚij iye in nifaakan iye: —¿Pa'n ejunye'jek? ¿Me akha' pa' Elías?— Qa yit'ijiju'ƚ iye ka' Juan: —Nite' yakha'.— Qa yit'ijets iye: —¿Me akha' pakha' profeta?— Qa yeku'ƚ iye: —Nite'.— ");
INSERT INTO mca_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma' qa yit'ijets pa'aj: —¿Qa pa'n ejunye'jek? hats'inha qu' henfeli'ƚi'm hekhewe' ts'ukini'ƚ ei. ¿Qa akha' pa'n qu' it'ij etetsek qu' ejunye'je'?— ");
INSERT INTO mca_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Qa yeku'ƚ iye ka' Juan Bautista: —Yakha' inek, pakha' wit'ax taya'yi'kii pa' ham i'ni'i' qa yit'ij: “Atsathenketi'ƚha pakha' ƚ'ikheyi'j pa' Yatsat'ax'inij,” in ƚ'anye'jek kakha' yit'ij pa'aj pa' profeta'ik'i Isaías.— ");
INSERT INTO mca_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hekhewe' wit'ukinhei, hekhewe'en ƚ'ukinhei pa'aj hekhewe' fariseol. ");
INSERT INTO mca_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hekhewe'en qa nifaakan iye, qa yit'ijets: —¿Qa inhats'ekek in ƚ'inqimpulijin in nite' hik akha' pa' Cristo, qa nite' iye pakha' Elías qa nite' iye pakha' profeta?— ");
INSERT INTO mca_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ka' Juan Bautista qa yeku'ƚ, qa yit'ijiju'ƚ iye: —Yakha' k'inqimpulijinji' ha'ne iweli', qa hakha'ƚe ewi'ƚ hats i'ntaxi'ƚ etji'teje'm qa nite'ƚe ƚenikfe'li'ƚij. ");
INSERT INTO mca_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hik hakha' pakha' teke'lenju' qu' nanam, yakha' nite' ye'weju'ƚij qu' henit'ijii pe' ƚeqniihayij pe' ƚ'otshilaxtii.— ");
INSERT INTO mca_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ekewe' wekwek ekewe'en ƚunyejeyi'kii hakha' witset ƚa's Betania neƚu'uju'ƚ ƚajaika' ai hakha' haqqi' Jordán. Hik hakha' i'niji' ha' Juan Bautista in wenqinpulijin. ");
INSERT INTO mca_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kakhap neƚuji', ka' Juan Bautista qa yi'wen ha' Jesús in nekets, qa yit'ij: —Jeƚ qeku'ni'ƚek, hik ha'ne hakha' Kots'etax Ƚa's yatsat'axij pa' Dios, hik ha'ne pakha' nit'ijji' hatse' pa' ƚewuƚ'ax ha'ne sehe' epji'. ");
INSERT INTO mca_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hik ha'ne k'iyetij in hit'ijets: “Yakha' qa hakha' teke'lenju' qu' nanam, hakha'an qiji'ha t'anyipji', qe hakha'an hayiits na'l pakha'aj qa yakha'ƚe qa yi'nk'aƚe.” ");
INSERT INTO mca_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yakhap iye nite' hayiits qu' ne' tsikfe'lij nakha'an. Qa aka' ta'ƚijupi' yakha' in tsam qu' nek'inqimpujinji' pa'qu' iweli'ye', qe qa' nenikfe'lij ene' Israel nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ka' Juan Bautista qa nifeelija iye: —Hi'wenijha in te'nilit'etsju' pa' Espíritu Santo ta'ƚetspha'm na' wa's qa hikƚe ƚunye'j ofo', ma' qa amanipji' nakha'an. ");
INSERT INTO mca_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yakha' qa mente' tsikfe'ltaxij pa'n ƚunye'j hakha'an, qa pakha'ƚe ts'ukinij qu' nek'inqimpujinji'kii pa'qu' iweli'ye', qa yit'ij yiwets: “Nakha'an nakha' qu' i'wenij qu' neketsju' na' Espíritu Santo qa' amani'ipji', nakha'an hik nakha' hakha' hik ƚunye'j qu' nenqimpulijinji' na' Espíritu Santo.” ");
INSERT INTO mca_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yakha' hi'wenijha qa henfelija iye in hik nakha'ija Ƚa's pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Qa kakhap neƚuikakii ka' Juan Bautista qa hik hakha' i'ni' iye qa wetsjuk hekhewe' ƚ'ijatshenhei i'nijup. ");
INSERT INTO mca_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Qa in yi'wenik'i pakha' neki' pa'aj ha' Jesús, qa yit'ij: —Jeƚ qeku'ni'ƚek, hik kakha' hakha' Kots'etax Ƚa's yatsat'axij pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Qa hekhewe' wetsjuk ƚ'ijatshenhei yepi'ye' ej aka'an in yit'ij, ma' qa yijayanpha'm ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Qa ha' Jesús qa nejeƚƚetepji' pa'aj, qa yi'wen in nijayanpha'mkii, qa yit'ijets: —¿Ƚekpa' ƚowo'oƚiikii?— Qa yeku'ƚ hekhewe'en: —Rabí, (Maestro) ¿pa'n i'ni' pakha' ƚa'wi'?— ");
INSERT INTO mca_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ha' Jesús qa yeku'ƚ pa'aj: —Te'ƚuni'ƚ qa i'weni'ƚ.— Ma' qa ƚijts'eyek qa yi'wen hakha' i'wi'. Ma' qa mexe amaneyijup qa yamijii in hats metju' junu', qe hats las cuatro (4) kakha' neƚuji'. ");
INSERT INTO mca_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hakha' ewi'ƚ hekhewe' wetsjuk hikhe' yepi'ye' ej ka' Juan Bautista qa yijayanpha'm ha' Jesús, hakha'an ƚii Andrés, ƚejefe ha' Simón Pedro. ");
INSERT INTO mca_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hakha' Andrés yojohon in wo'oikii ha' ƚejefe Simón, qa yit'ijets: —Hats hi'weni'ƚ hakha' Mesías (ikji' aka'an Cristo).— ");
INSERT INTO mca_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma' qa neka'xii hakha' i'ni' ha' Jesús. Ha' Jesús in yejeƚju', qa yit'ijets: —Akha' Simón, ƚa's ha' Juan, qa hane'ej qa iyi'ij Cefas (ikji' Pedro, “ute”).— ");
INSERT INTO mca_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Qa kakhap neƚukii ha' Jesús qa namiyu'ui ha' sehe' Galilea, qa yi'wen ha' Felipe qa t'eqe'mets, qa yit'ijets: —Atsjayan.— ");
INSERT INTO mca_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ha' Felipe Betsaida ƚeiƚe', hikha' witset ƚetset iye ha' Andrés qa ha' Pedro. ");
INSERT INTO mca_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ha' Felipe qa wo'oikii ha' Natanael, qa yit'ijets: —Hats hi'weni'ƚ hakha' toxik'i yika'ajji' pa'aj pa' Moises'ik'i qa pe' profeta'ik'i iye, hakha' Jesús Nazaret ƚeiƚe', ƚa's pa' José.— ");
INSERT INTO mca_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ha' Natanael qa yit'ijets pa'aj: —¿Me ƚeke' qu' nata'ƚ ji'ju' pa'qu' ƚe'wise' hakha' witset Nazaret?— Ha' Felipe qa yeku'ƚ pa'aj, qa yit'ijets: —Teƚunik'i qa' i'wen.— ");
INSERT INTO mca_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Qa ha' Jesús in yi'weniju'ƚ in hats meti'm ha' Natanael, qa yit'ij: —Jeƚ qeku'ni'ƚek ha'ne yijaa'ija in Israel ƚeiƚe' yijat'ij, nakha'an hami'm pa'qu' witqawitjinaxe'.— ");
INSERT INTO mca_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ha' Natanael qa yit'ijets: —¿Pa'n ƚunye'j in ƚenikfe'lyij?— Ha' Jesús qa yeku'ƚ: —In mente' tayai ei na' Felipe ƚa'nifi ke' higokuk, qa hayiits k'ewen.— ");
INSERT INTO mca_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Qa ha' Natanael qa yit'ij: —Rabí (Maestro), ¡hik akha' pa' Ƚaa'sija pa' Dios! ¡Akha' pakha' Qi Ƚatata ene' Israel!— ");
INSERT INTO mca_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Qa yeku'ƚ ha' Jesús, qa yit'ijets: —¿Inhats'ek in hit'ij ewets in k'ewen in ƚa'nifi ke' higokuk, ma' qa nite' ƚesqeku'? Qa' i'wen iye hatse' kekhewe' wekwek les in qits yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ha' Jesús qa yit'ij: —Yijaa'ija aka' qu' hit'iƚij ewets, ƚi'weni'ƚ hatse' na' wa's qu' qhofi'ij qa nekhewe' ƚaqa angelits na' Dios qa' netf'eyeikiyetsju'kii ha'ne Ƚa's na' Jukhew.— ");
INSERT INTO mca_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Qa in hats wetshetk'ewiƚik'i neƚuts qa na'l ka' ewi'ƚ witiwhe'yejii hakha' witset'ii Caná, hakha' sehe' Galilea, qa ke' ƚenene ha' Jesús qa hats i'ni' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ha' Jesús te'niyinhe'yij iye qa week he' ƚ'ijatshenhei kakha' witiwhe'yejii. ");
INSERT INTO mca_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Qa in hats aje'eƚ yimji' ka' wino'ok'i, qa ke' ƚenene ha' Jesús qa yit'ijets: —Hatste' yimji' ka' wino'ok'i.— ");
INSERT INTO mca_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús qa yit'ijets: —Efu, ¿inhats'ek in ƚit'ij yiwets kakha'an? Mente' yamtaxets ƚahats'ij qu' haqsiijkii pa'qu' ƚunye'je'.— ");
INSERT INTO mca_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ke' ƚenene qa yiyaji'ijets hekhewe' t'ihinijkii, qa yit'ijets: —Aqsiiƚijkii week pa'qu' nit'iƚij ewets nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Qa na'l hekhewe' ewi'ƚ tatsai (6) kekhewe' qits utel wanaqsiijkii in eƚi'nilij, we'neni' hakha'a' qe qa' natnatkinhe'yij kakha' ƚunyejei nekhewe' judiol qe wa'nqa'. Ewi'ƚ hekhewe' eƚi'nil wejuƚji'ju' pa'qu' iweli'ye' qu' wetshetk'ewi'ƚe' ne'ej qits kamusil. ");
INSERT INTO mca_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ha' Jesús qa yiyaji'ijets hekhewe' t'ihinijkii, qa yit'ijets: —Oponhetiƚik'i pa'qu' iweli'ye' nekhewe' eƚi'nil.— Ma' qa yoponhetik'i he' eƚi'nil. ");
INSERT INTO mca_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma' qa ha' Jesús qa yit'ijets iye: —Hane'ej qa' a'natsiyi'ƚju' ƚammise'ji qa eka'xi'ƚii nakha' tenek'enhe'yij ha'ne ƚe'wis neƚu qu' nijaajin.— Ma' qa yeka'xii. ");
INSERT INTO mca_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Qa ha' tenek'enhe'yij ka' ƚe'wis neƚu in yijaajin kakha' iweli'tax in wino'oj, hakha'an in nite' nikfe'lets pa'n ta'ƚji' ka' wino, qa hekhewe'ƚe yithayiki qa nikfe'lets qe ƚekhewel natsiiju' kakha' iweli'ƚetax. Ma' qa ha' tenek'enhe'yij ka' ƚe'wis neƚu qa taya'yii ha' tewhe'yei, ");
INSERT INTO mca_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","qa yit'ijets: —Week na'aj jukhew yojohon qe t'ihinij qu' ne'tniyahaiji' na'aj ƚe'wisji'ha wino, ma' qa in hats yape'ejets qe te'niyahaiji', qa' hats t'ihinij iye qu' ne'tniyahaiji' na'aj les nite' ƚe'wisji'ha wino. Qa akha'ƚe qa menjiit ƚaqsi'j nite' ƚ'ihinij qu' ne'tniyahaiji' ha'ne ƚe'wisji' wino.— ");
INSERT INTO mca_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aka'an hik aka' yojo kekhewe' ham ƚunyejeyi'iju'ƚ in yaqsiijkii ha' Jesús, qa yaqsiiji'kii hakha' witset'ii Caná, hakha' sehe' Galilea. Aka'an ƚunye'j in hats inq'ethinij pa' qi ƚewqiye'jji'ha, qa he' ƚ'ijatshenhei qa qi'ija in nite' yeqeku' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Qa in hats ƚ'anu'upji' week ekewe'en, ma' qa yamii ha' Capernaum ƚijts'ekikii ke' ƚenene qa he' ƚek'injats qa he' ƚ'ijatshenhei, qa nite'ƚe olots ke' neƚuts in amaneyi' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kakha' ƚeqe ƚe'wis neƚu nekhewe' judiol Pascua hats k'esets, qa ha' Jesús qa yamii ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Qa in uyifi ke' witlijtsitjii qa yi'wenifi he' t'ihinij he' wakka, he' t'ihinij he' kots'etets, he' t'ihinij ofol qa hekhewe' iye yepiletetskii ƚ'astai i'niju'kii hakha'a'. ");
INSERT INTO mca_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ha' Jesús qa yaqsiijkii ka' ewi'ƚ ƚeqsilanhet niihai, qa yiwutshenik'uifik'ikii ke' witlijtsitjiiyifi he' weekji', qa weeki'ƚ he' ƚeƚinhei kots'etets qa he' wakka iye. Qa niwu'mi'ju'kii iye sehe' kekhewe' ƚ'astai nijketits hekhewe' yepiletetskii ƚ'astai, qa yiwu'mkii iye ke' ƚeqe mesalik'i. ");
INSERT INTO mca_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Qa yit'ijets he' t'ihinij he' ofol: —¡Eka'xi'ƚik'uifik'i hane'e'in enewe'en! ¡Hasu'uj eqfenyejeyi'iƚij ene' ƚetsi' na' Tata na'aj witaqhawet!— ");
INSERT INTO mca_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","He' ƚ'ijatshenhei qa nikfe'lik'i ma' qa yijamti'ik'i kekhewe' we'nika'ajji' pa'aj in yit'ij: —Pakha' nite' yeqwejinka'xtaxiji'm qu' ham niwqinhete'ji' ene' etsi', hik pakha' qu' nesƚuj.— ");
INSERT INTO mca_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hekhewe' judiol qa yit'ijets: —Ets'ethini'ƚij pa'qu' ham ƚunye'ji'iju'ƚ qu' aqsiijkii hane'ej, hats'inha qu' netsikfe'liƚets qu' nata'ƚets pa' Intata in ƚaqsiijkii aka'an.— ");
INSERT INTO mca_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Qa yeku'ƚ ha' Jesús: —Iwuƚ'enheti'ƚju' qa' onopƚeti'ƚju' iye ene' qi witlijtsitjii, qa qu' namets wetshetk'ewi'ƚ neƚuts qa' heniihinpha'm iye.— ");
INSERT INTO mca_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma' qa he' judiol qa yeku'ƚ iye, qa yit'ij: —Cuarenta y seis (46) ininqapits in we'nithayiki ene' qi witlijtsitjii, qa akha' ¿me ƚumti qu' wetshetk'ewi'ƚ neƚutse' qu' eniihinpha'm iye?— ");
INSERT INTO mca_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Qa hakha' Jesús in yit'ij, “ene' qi witlijtsitjii” qete'e' hakha'ƚe week ƚ'ese'n in iyetij. ");
INSERT INTO mca_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Qa hik ta'ƚijupi' in iƚa'x iye qa he' ƚ'ijatshenhei qa yijamti'ik'i in hik aka' hayiits yit'ij, ma' qa les in nite' yeqeku' kekhewe' hayiits we'nika'ajji' pa'aj qa kekhewe' iye ƚe'lijei ha' Jesús qa iyetji'ij. ");
INSERT INTO mca_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ha' Jesús in mexe i'ni' ha' Jerusalén kekhewe' ƚe'sits neƚutsji' Pascua, ma' qa olots hekhewe' tek'entaxets, qe ta'ƚijupi' in yi'wenijha kekhewe' yaqsiijkii in ham ƚunyejeyi'iju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Qa hakha'ƚe Jesús qa nite'ƚe yija'am pekhewe'en, qe nikfe'letsha pa' ƚunyejei hekhewe' weekji'. ");
INSERT INTO mca_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Qa hik ta'ƚijupi' in nite' hamik'ui pakha' qu' nenfeltaxi'm pa' ƚunyejei' hekhewe'en, qe hakha'an nikfe'lets week pa'qu' jukhewe'. ");
INSERT INTO mca_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ewi'ƚ ha' jukhew fariseo, ƚii Nicodemo, hik hakha' ewi'ƚ hekhewe' tenek'enhei ne' judiol. ");
INSERT INTO mca_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Hakha'an qa namii ha' Jesús naja'xij hakha' i'ni', qa yit'ijets: —Rabí (Maestro), tsikfe'li'ƚets in ƚata'ƚijiiha pa' Dios in a'maestro, qe ham pa'qu' naqsi'jƚi'ijkii kekhewe' ham ƚunyejeyi'iju'ƚ ƚaqsiijkii qu' nite' na'ni'ijup pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ha' Jesús qa yeku'ƚ: —Yijaa'ija aka' qu' hit'ij ewets, pakha' qu' nite' ewi'ƚi'ij qu' nenekfik'i iye qa' nite' ƚeke'ye' qu' ni'wen na' tenek'enheiji' na' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ha' Nicodemo qa yit'ijets iye: —¿Pa'n ƚunye'j qu' ƚeke'ye' qu' ewi'ƚij nenekfik'i iye pakha' qu' hats ƚawa'ma'xe'? ¿Me ƚeke' qu' napil ji'teje'm iye ƚeneneye' ma' qa' nenekfik'i iye?— ");
INSERT INTO mca_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ha' Jesús qa yeku'ƚ iye: —Yijaa'ija aka' qu' hit'ij ewets, pakha' qu' nenekfik'i qa nite'ƚe nekijfik'i na' Espíritu Santo, nite' ƚeke' qu' nuiji'teje'm na' tenek'enheiji' na' Dios. ");
INSERT INTO mca_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Qe na'aj nekijupfik'i aka' wit'eseninye'j, qa wit'ese'nƚe, qa pakha'ƚe qu' nenekijupfik'i na' Espíritu Santo, qa espirituƚe ek. ");
INSERT INTO mca_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hasu'uj e'nitjuƚaxijpha'm in hit'ij ewets: “ekheweli'ƚ les ƚe'wistax qu' ewi'ƚi'ij iye qu' eneki'ƚfik'i.” ");
INSERT INTO mca_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na'aj t'unik'i ikji' pakha' qu' nisu'un qu' nakji', qa ƚepiye' na'aj ƚ'anye'j, qa nite'ƚe ƚenikfe'lets pa'n qu' nataa'ƚji'ha, qa pa'n qu' net'ejuiji'ha iye. Aka'an hik aka' ƚunye'j week pakha' qu' nenekijfik'i na' Espíritu Santo.— ");
INSERT INTO mca_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma' qa ha' Nicodemo qa nifaakan iye: —¿Maa, pa'n ƚunyee'jkiiha aka' ƚit'ij?— ");
INSERT INTO mca_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús qa yeku'ƚ iye, qa yit'ijets: —Akha' inek a'maestro ha'ne Israel, ¿me qa nite' ƚenikfe'lik'i ekewe' wekwek? ");
INSERT INTO mca_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yijaa'ija aka' hit'ij ewets, yekheweli'ƚ hit'iƚij eke' tsikfe'li'ƚets qa eke' hi'weni'ƚ iye, qa ekhewelƚi'iƚ qa nite' ƚ'eku'mi'ƚiju'ƚ ekewe' henfeltaxi'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","In hats k'efeltaxi'ƚi'm ekewe' wekwek t'ejuyets ha'ne sehe' ipji', qa ƚeqeku'ƚi'iƚik'i, ¿qa pa'n qu' ƚunye'je' qu' nite' eqeku'yi'iƚik'i qu' henfeltaxi'ƚ e'm nekhewe' wekwek wa's ƚeiƚets? ");
INSERT INTO mca_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ham pakha' qu' hats namiipha'm na' wa's, qe ewi'ƚƚe nakha' ta'ƚiipha'm na' wa's, ikji', ha'ne Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Qa in ƚunye'jek ka' Moisés in yenpha'm ka' yojonketik'i q'oiq'oi hakha' ham i'ni'i' sehe', qu' hik aka' ƚunye'je' ha'ne Ƚa's na' Jukhew in les ƚe'wis qu' ne'nenpha'm hatse'. ");
INSERT INTO mca_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Hats'inha qu' weeke' pakha' qu' nite' neqeku'ye' nakha'an, ma' qa' nana'li'm na' witiƚa'x nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Qe na' Intata qi in yisu'un ene' week jukhew qa efuts iye qa nukinju' na' ewi'ƚƚe in Ƚaa'sija, hats'inha qu' weeke' pakha' qu' netk'eenetsha nakha'an, qa'nte' nami'ii hatse' nakha' fe't qi iftsax. Ma' qa' nana'li'm na' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na' Intata nite' nukinetsju' ha'ne Ƚa's ha'ne sehe' ipji', ma' qa' nitanithen ha'ne week sehe' ipji', qe nukinju' yijat'ij hats'inha ha'ne week sehe' ipji' qa iƚiye' qu' nata'ƚets nakha'an. ");
INSERT INTO mca_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pakha' qu' netk'enets nite' yeqeku' nakha'an ma' qa' hats nite' nattanithenheti'ye' hatse'. Qa pakha'ƚe qu' nite' netk'ene'ets yeqeku' qa hayiits jutsiqax qu' nattanithenhetii hatse', qe nite' tek'enets yeqeku' kakha' ƚii nakha' ewi'ƚƚe in Ƚaa'sija na' Dios. ");
INSERT INTO mca_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aka'an kakha qu' netjeyumtshenheti'yij, qe na' na'lkii in namtaxetsju' ha'ne sehe' epji', qa enewe'ƚe jukhew qa efuts iye qa les in yisu'un na' nookii qa nite' yisu'un na' na'lkii, qe pekhewe' yaqsi'jijkii enewe'en uƚ'ets. ");
INSERT INTO mca_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Qe week nekhewe' uƚ'ax yaqsiijkii qa yuten na' na'lkii. Qa nite' nekets na' na'lkii qe nite' yisu'un qu' ne'twenhetii pekhewe' yaqsiijkii uƚ'ets. ");
INSERT INTO mca_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Qa nikha'ƚi'ij yaqsi'jijkii pa' ƚe'wis, qa nekets na' na'lkii, qe qa' ne'twenhetii week pekhewe' yaqsiijkii in ta'ƚets na' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma' qa i'nk'aƚe iye in hats naxijik'i ekewe'en, ha' Jesús qa he' ƚ'ijatshenhei qa iketsfik'i ha' sehe' Judea, qa hik hakha'a' qa mexe amaneyi' ƚ'ajƚi'ij qa wenqimpuujinju'. ");
INSERT INTO mca_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ka' Juan Bautista wenqimpulijin iye hakha' witset'ii Enon meti'm ha' witset Salim, qe hik hakha'a' he' olots iwelii. Qa olots he' namii qa wempuli'jju'. ");
INSERT INTO mca_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Qe ka' Juan Bautista hik aka'aj mexente' we'nenifi pe' witq'opheƚitjii. ");
INSERT INTO mca_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Qa ƚunye'jkii pa'aj hekhewe' ƚ'ijatshenhei kakha' Juan Bautista in tek'eƚeyiteetsiƚijju'kii pa' ewi'ƚ judío in t'ejuyets pa' ƚeqfenyejyij qu' nojo qu' netetlijik'uiju' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma' qa hekhewe'en qa nekii pa'aj ka' Juan Bautista, qa yit'ijets pa'aj: —Maestro, jeƚ qeku'nek hakha' in'ejup ha' ƚajaika' ai ha' haqqi' Jordán hikha' ƚenfeli'ƚ ye'm iye pa' ƚunye'j. Hane'ej qa hatste' wenqimpulijin iye qa hatste' week yot'axii hane'ej hakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka' Juan qa yeku'ƚ pa'aj, qa yit'ij: —Ham pakha' qu' nana'lƚi'im pa'qu' ƚunye'je', qu' nite' netisi'ij pakha' i'nji' ha'ne wa's. ");
INSERT INTO mca_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ekheweli'ƚ ƚespi'ye'eƚijha in hit'ij: “Nite' yakha' pa' Cristo, yakha' hoijohonhetiiƚi'ik'ui hakha'an.” ");
INSERT INTO mca_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pakha' i'nijup pe' witiwhe'ye', hik pakha' pa' witiwhe'ye', pakha'ƚe ƚejuwaika' pa' witiwhe'ye' i'nijup qa yepi'ye', qa qi in ƚe'wisi'mkii in yepi'ye' pa' ƚ'a'x pa' witiwhe'ye'. Qa hik yijunye'j yakha' in hats qi in ye'ƚe'wisi'mkii. ");
INSERT INTO mca_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Les ƚe'wis hakha'an qu' les net'ijaifik'iha qu' les qiye'ji'ha, qa yakha'ƚe qa les ƚe'wis qu' he'yijayik'iju' ek qu'nte' ye'qiye'ji'.— ");
INSERT INTO mca_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Ha' ta'ƚetspha'm na' wa's hik hakha' week tenek'enhe'yipji'. Qa ha'neƚe sehe' taƚipji' qa sehe' ƚe'ek ƚeiƚe' qa iyetij eke' wekwek i'nipji' ha'ne sehe'. Qa hakha'ƚe ta'ƚetspha'm na' wa's qa hik hakha' week tenek'enhe'yipji'. ");
INSERT INTO mca_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hakha'an nifel pakha' yi'wen qa yepi'ye' iye. Qa hamƚe nek'enheyuye'ets. ");
INSERT INTO mca_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pakha' qu' netk'enetsha nite' yeqeku'uk'i pakha' qu' nit'ij hakha'an, pakha'an qa yiwjutsiqenija qu' nit'ijets pa' Dios in yijaa'ija. ");
INSERT INTO mca_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Qe hakha' nukinju' pa' Dios qa nifel pe'qu' ƚe'lijeye' pa' Dios, qe pakha'an in tisij hakha'an pa' ƚeqe Espíritu, qa nite' wo'oi pa'qu' ƚeqjeyumtshelaxi'ijup pa'qu' netisij. ");
INSERT INTO mca_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pakha' Ƚatata yisu'un hakha' Ƚa's, qa tisij pa' qi ƚet'unha'x qa week tenek'enhe'yij ene' week wekwek. ");
INSERT INTO mca_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pakha' qu' netk'enetsha nite' yeqeku' ha' Ƚa's qa hats na'li'm pa' witiƚa'x nite' yili'ij. Qa pakha'ƚe qu' nite' netk'ene'ets ha' Ƚa's qa' nite' ni'wene' pa' witiƚa'x, qe pa' qi ƚawak pa' Dios hik pakha' yijat'ij qu' na'nipji' enewe' week ƚahatsiyij.— ");
INSERT INTO mca_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ha' Yatsat'ax'inij in nikfe'lets hekhewe' fariseol in hats i'ye'ej hakha'an in yaqsiijkii in nimpulijinju' hekhewe' les olots qu' ƚ'ijatshenheyi'ij iye qa nite' hik uja'x ka' Juan hekhewe' nimpulijinju' ek. ");
INSERT INTO mca_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Qa nite'ƚe hik hakha'tax ha' Jesús qu' ninqinpulijin, hekhewe'ƚe ƚ'ijatshenhei hik hekhewe' wenqinpulijin. ");
INSERT INTO mca_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma' qa ikik'ui ha' sehe' Judea, qa wapilii iye ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","In ikkii, qa les ƚe'wis qu' nenek ji'teje'm ha' Samaria ƚeqe sehe'. ");
INSERT INTO mca_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma' qa yamets ha' ewi'ƚ witset hakha' Samaria ƚii Sicar, meti'm hakha' joofji'ju' ƚeqe sehe' pa' Jacob tisij pa'aj pa' ƚa's José. ");
INSERT INTO mca_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hik hakha' i'ni' ke' witijki' ƚejki pa'aj pa' Jacob'ik'i. Ha' Jesús hats yiwef, qa i'nju' wapi'yijup ke' witijki', hats natsatheniyu'ju' junu'. ");
INSERT INTO mca_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma' qa namets ke' ewi'ƚ efu Samaria ƚeiƚeki' woƚ'oljo'oijo' ke' witijki'. Qa ha' Jesús qa yit'ijets pa'aj: —Entshen qeku'n yat'e'.— ");
INSERT INTO mca_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Qe hekhewe' ƚ'ijatshenhei mexe taqhayiiteje'm ha' witset pe'qu' netuj. ");
INSERT INTO mca_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Qa in ƚunye'jek nekhewe' judío in nite' wetku'ƚiƚ nekhewe' Samaria ƚeiƚets, ma' qa ke' efu qa yit'ijets pa'aj in yeku'ƚ: —¿Inhats'ek, in akha' e'judio, qa ƚ'iyintaxij yiwets pa'qu' at'e' iweli' in yakha' ya'samaria ƚeiƚeki'?— ");
INSERT INTO mca_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ha' Jesús qa yeku'ƚ: —Qek enikfe'lets nakha' ƚeqisit na' Dios, qa nakha' iye yittaxij ewets: “Entshen qeku'n yat'e'.” Ma' qekha iyintaxets nakha'an, qa nakha'an qekha neƚistaxij na' iweli' witiƚa'x.— ");
INSERT INTO mca_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ke' efu qa yeku'ƚ iye pa'aj: —Jukhew, ham inek eqniyak'i'ijup qa ham iye oqotok'o yi'ijup qu' iwu'miiju' ne' witijki' qe akaptax. ¿Pa'n qu' ata'ƚiji' pakha' iweli' witiƚa'x ƚenqisti'neyutaxyij? ");
INSERT INTO mca_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pa' yaqwa'maxi'ƚik'i Jacob tsejeti'ƚij ene' ƚejki. Hik ene' iya'ji'kii pa'aj qa week iye pe' ƚelitsik'i qa pe' ƚeƚinheiyik'i iye in ƚ'iyafetsjikii iye pa'aj. ¿Qa akha' me les ƚ'anipji' pakha'an?— ");
INSERT INTO mca_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ha' Jesús qa yeku'ƚ pa'aj qa yit'ij: —Week pakha' qu' niya'ji' ha'ne iweli' ene' witijki' nite' yili'ij qu' neniyayuji'ij. ");
INSERT INTO mca_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Qa pakha'ƚe qu' niya'ji' na' iweli' ta'ƚ yiwets qu' hetisij, qa nite' ƚ'anuuyi'i qu' ne'niyayu'. Qe na' iweli' ta'ƚ yiwets qu' hetisij qa' hik ƚunye'je' qu' ne'niwekƚeji' ƚatawe'j qa' netisij na' witiƚa'x nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Qa yit'ij pa'aj ke' efu: —Jukhew, esƚisij pa' iweli' hats'inha qa'nte' ƚ'anuuyi'i qu' nets'iyayu'. Qa'nte' heneki'iiju' iye ene' witijki' qu' heka'xji'ij pa'qu' iweli'ye'.— ");
INSERT INTO mca_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ha' Jesús qa yeku'ƚ iye: —Iihetii pa' ewhe'ye' qa' eneki'ƚmet hane'e'in.— ");
INSERT INTO mca_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ke' efu qa yit'ij pa'aj: —Ham yiwhe'ye'ye'.— Qa yit'ij pa'aj ha' Jesús: —Ƚ'asiinik'iha ka' ƚit'ij in ham ewhe'ye'ye' ");
INSERT INTO mca_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","qe hats lee'fij (5) ewhe'yets, qa hakha' hane'ej in'ejup nite' ewhe'ye' iye. Aka'an hik aka' ƚunye'j in yijaa'ija kakha' ƚit'ij iku'uj.— ");
INSERT INTO mca_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","In yepi'ye' pa'aj ke' efu aka'an qa yit'ij: —Jukhew, qete'e' tu'u qu' o'profetaye'. ");
INSERT INTO mca_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pe' yaqwa'mhitsiƚik'i Samaria ƚeiƚets ha'ne i'niji' ek in iyiniikii pa' Dios ene' utek'ipji', qa ekheweli'ƚ in e'judioli'ƚ qa ƚit'iƚijets qu' nakha' Jerusalenii qu' hik nakha'yi'i' qu' netninhiyiji' qu' netniyinheyiikii pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ha' Jesús qa yeku'ƚ qa yit'ijets: —Efu, ek'en yiwetsha hasu'uj esqeku', na' ƚahats'ij yamets hatse' qu' nite'ye' ene' utek'ipji' qa nite' iye na' Jerusalenii qu' ni'iƚiji' qu' iyini'ƚii na' Intata. ");
INSERT INTO mca_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ekheweli'ƚ nite' ƚenikfe'li'ƚets nakha' ƚ'iyintaxi'ƚii, qa yekheweli'ƚ qa tsikfe'li'ƚets nakha' k'iyini'ƚii, qe na' witiƚijii ta'ƚji'ju' ne' judiol. ");
INSERT INTO mca_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","In hats k'esets qu' namets hora ma' qa hats yamets hane'ejija, qa pekhewe' qu' yijaali'ija qu' niyinii na' Dios qa niyiinija weekij pe' ƚatawjets qa' yijaayi'ija iye qu' niyin, qe na' Dios hik aka' yisu'un pe'qu' hik ƚunyejeye' aka'an. ");
INSERT INTO mca_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Na' Dios in espirituƚe, qa pekhewe' qu' nijayan qa' les ƚe'wis qu' nijayanij pa' espíritu pa' yisu'un, qa' yijaayi'ija iye.— ");
INSERT INTO mca_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Qa pe' efu qa yit'ijets pa'aj: —Tsikfe'lets in nam hatse' pakha' Mesías (ikji' Cristo). Ma' qa qu' nanam pakha'an titha neqethen'inemik'iha week ekewe' wekwek.— ");
INSERT INTO mca_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús qa yeku'ƚ qa yit'ij: —Pakha'an yakha' inek, ha'ne hane'ej ƚ'afaakateyi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma' qa namijets he' ƚ'ijatshenhei, qa qi in nijusij in tafaakate'yi'ƚju' ke' efu ha' Jesús. Qa hamƚe pa'qu' nanfaakanij qu' nit'ijets: ¿Ƚekpa' ƚanfaakanijkii? i'nƚi'i qu' nit'ijets ¿Inhats'ek in ƚ'afaakateyi'ƚ nekhe'en? ");
INSERT INTO mca_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma' qa ke' efu qa nejeti' ke' ƚeweƚi'ni' qa wapilii ha' witset, qa nifeli'm hekhewe' jukhew qa efuts iye, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Te'ƚun qeku'ni'ƚ qu' i'weni'ƚ ha' ewi'ƚ jukhew nifel ye'm week ke' yeq'inye'jeikii. ¿Me hik tu'u hakha'ye' pa' Cristo?— ");
INSERT INTO mca_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma' qa olots he' ta'ƚets ha' witset nekii ha' i'ni' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Qa in mente' namets hekhewe'en qa he' ƚ'ijatshenhei qa yiyajitaxets qa yittaxijets: —Rabí (Maestro), ek eku'n.— ");
INSERT INTO mca_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Qa yeku'ƚ ha' Jesús, qa yit'ij: —Na'l ye'm na' qu' hetuj nakha' ekheweli'ƚ nite' ƚenikfe'li'ƚets.— ");
INSERT INTO mca_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Qa he' ƚ'ijatshenhei qa watfaakateji'ijju': —¿Maatsek tetka'xii pa'qu' netuj pa'aj?— ");
INSERT INTO mca_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Qa yit'ij ha' Jesús: —Nakha' qu' hetuj nakha'an in haqsiijkii pa'qu' nisu'un nakha' ts'ukinju', qa qu' nasqhat'axij iye na' ƚ'ithayijkit. ");
INSERT INTO mca_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Me nite' ƚit'iƚijets: “Mexe hamitsik'ui ikwetju'ƚ (4) juwelits qu' nuji' qa' netenifte'ji' pa'qu' wit'enek'eju'”? Qa yakha' qa hit'ijek: “Jeƚi'ƚju' ene' jukhew qa efuts hik ƚunyejei wit'enekju' hats yuji', hats ƚeke' qu' netenit'ijji'.” ");
INSERT INTO mca_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na'aj nit'ijji' ne'ej ƚei na'aj wit'enekju' qa tajayipji', ma' qa nit'ijji' pe' ƚei pa' wit'enekju' qe qa' net'ejuyets na' witiƚa'x nite' yili'ij. Hats'inha pakha' yenju' pe' ƚoi qa' week ƚe'sitsi'iƚi'mkii pakha' nifte'ji' pe' ƚei. ");
INSERT INTO mca_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Qa aka'an in ƚunye'j qa yasin ji'teje'm kakha' wenit'ij: “Ewi'ƚ pakha' we'nq'en qa pakhap iye qa nit'ijji'ek pe' ƚei.” ");
INSERT INTO mca_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yakha' in k'ukini'ƚii qa ƚenit'iƚijji' nekhewe' ƚei nakha' nite' ekheweli'ƚ qu' eni'ƚju', tujtseikal ke' yithayiki in yenju' qa hane'ej ekheweli'ƚ qa hats ƚ'uyi'ƚ ji'teje'm nakha' ƚ'ithayijkit.— ");
INSERT INTO mca_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Olots he' jukhew qa efuts iye he' ta'ƚets ha' witset Samaria tek'enets qa nite' yeqeku' iye ha' Jesús, qe ta'ƚets ke' efu in yit'ij: —Nikfe'l yiwets week ka' yeq'inye'jkii.— ");
INSERT INTO mca_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma' qa hik ta'ƚijupi' hekhewe'en in namii ha' Jesús ha' i'ni', qa iyinijets qu' mexe amane' eku'nijup ha' witset. Ma' qa wetsjuk neƚuts in mexe amanji'. ");
INSERT INTO mca_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","In hats yepi'yee'ija in iyet ma' qa les olots he' tek'enets nite' yeqeku'. ");
INSERT INTO mca_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Qa hekhewe'en qa yit'ijets ke' efu: —Hane'ej in nite' heqeku'uƚ, hats nite' ewi'ƚƚe qu' nata'ƚets kakha' ƚit'iƚij yiwets, qe ta'ƚets iye in hats hepi'yee'iƚha in iyet, qa tsikfe'li'ƚets in yijaa'ija in hik ha'ne pakha' Eqiƚina'x ha'ne sehe' epji'.— ");
INSERT INTO mca_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","In t'ani' kekhewe' wetsjuk neƚuts, ha' Jesús qa ikik'ui ha' sehe' Samaria, qe qa' namii ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Qe ha' Jesús ƚakhaa'ija in nifel na'aj ewi'ƚ profeta in nite' yiwqinhetji' pekhewe' qu' ƚetsetifeetsetaxija. ");
INSERT INTO mca_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma' qa in yamets ha' Galilea, hekhewe' Galilea ƚeiƚets qa lesitsiju'ƚ, qe hayiits yi'wenij week kekhewe' yaqsiijkii ha' Jerusalenii kekhewe' ƚe'sits neƚutsji' Pascua, qe ƚekhewel yamii iye kekhewe' ƚe'sits neƚuts. ");
INSERT INTO mca_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ha' Jesús qa wapilii iye in ikii ha' witset Caná ha' sehe' Galilea. Hik hakha'a' hayiits yaqsiiji'kii ka' iweli' in wino'oj. Na'l pa'aj ha' ewi'ƚ ƚeqe oficial pa' wittata, pa' ƚa's qi in wanqaats'e' ha' witset'ii Capernaum. ");
INSERT INTO mca_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hakha'an in i'ye'ej pa'aj ha' Jesús in ta'ƚii ha' Judea qa namets ha' Galilea, qa ikii qu' newetweni'ƚ ma' qa qi in iyintaxijets qu' ƚijts'eyi'ii pe' ƚetsi' qu' niƚini'm pa' ƚa's, qe hats niwamhiyu'. ");
INSERT INTO mca_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ha' Jesús qa yit'ijji'ju': —Qu' nite' i'weni'iƚ pe'qu' ham ƚunyejeyi'iju'ƚ qu' e'nitjuƚaxiƚijpha'mkii, qa' nite' ek'eni'iƚ ƚ'inqeku'uƚ.— ");
INSERT INTO mca_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Qa hakha' ƚeqe oficial pakha' wittata, qa yit'ij: —Jukhew, if'elitik'i wat'ij qu' enek qe mente' wa'm ha' ya's.— ");
INSERT INTO mca_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ha' Jesús qa yit'ijets: —Yape mapilii pe' etsi', pa' oqwomehe' hats iƚa'x.— Ha' jukhew nite' yeqeku'uk'i ka' yit'ijets ha' Jesús. Ma' qa ik qa wapilii pe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","In hats wapilii pa'aj pe' ƚetsi', qa pe' ƚeqejkunenhei qa iwoyitsiju'ƚ pa'aj qa nifeli'm in hats iƚa'x pa' ƚoqwomehe'. ");
INSERT INTO mca_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma' qa nifaakanij pa'aj pa' i'ni' junu' in hats wat'ij pa'aj. Qa yeku'ƚ pa'aj: —Neƚu in hats jelji' junu' (la una) qa yili'ij in iwilhantax.— ");
INSERT INTO mca_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ha' ƚatata qa nikfe'lik'i in hik i'ni' junu' ha' Jesús in yit'ij: —Pa' oqwomehe' hats iƚa'x.— Ma' qa hakha'an qa week iye he' ƚelits, ƚewhe'ye' qa nite' yeqeku' iye qa tek'enets ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aka'an hik aka' ka' wetsjuk yamets ham ƚunyejeyi'iju'ƚ in yaqsiiji'kii ha' Jesús ha' sehe' Galilea in hats tepilik'ui iye ha' Judea. ");
INSERT INTO mca_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma' qa i'nk'aƚe in hats ƚ'anu'upji' ekewe'en, ha' Jesús ma' qa yamii iye ha' Jerusalén qa hikha' i'niju' kakha' ewi'ƚ ƚeqe ƚe'wis neƚu ne' judiol. ");
INSERT INTO mca_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Qa ha' Jerusalenii, na'l ha' ewi'ƚ meti'm hakha' ƚeqeji'teje'm ne'ej kots'etets, ha' ewi'ƚ ƚajakju' ƚeqiyij ne' hebreo Betzata, qa lee'fij (5) he' ts'ewemmifi ƚeq'eneƚewetits. ");
INSERT INTO mca_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hekhewe' lee'fij (5) ts'ewemmifi qa weju'ƚji' he' olots wanqaats'eju', puk'alets, f'oyoq f'oyoq uƚ'ets ƚewek, qa hekhewe' iye nite'ija t'otsjo' i'wijupju'kii, (notkitaxets qu' nawapja' ha' iweli', ");
INSERT INTO mca_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","qe i'nƚi'i qe te' nametsju' pa' ewi'ƚ ƚaqa ángel pa' Yatsat'ax'inij ha' ƚajakju' qa te' wapja' ha' iweli', qa na'aj yojoji'ju' qe te' t'ilitji'ju' qa te' naxpa'lij pa'qu' ƚawtshek'etax.) ");
INSERT INTO mca_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hikha' i'ni' ha' ewi'ƚ jukhew hatste' yamijets treinta y ocho (38) ƚeqe'ninqapitsij in qi in wanqaats'e'. ");
INSERT INTO mca_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ha' Jesús in yi'wen in i'wju', ma' qa nikfe'lets in hats qu' toxetaxik'i aka' ƚunye'j, qa nifaakan: —¿Me ƚisu'un qu' ham awtshek'e'?— ");
INSERT INTO mca_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ha' wanqaats'e' qa yeku'ƚ: —Jukhew, ham tsi'feni'ij qu' natsahinetsju' na' iweli' qa wapjaji'ij, ma' qa in tsamji'ijtaxetsju' qa hatsƚe na'l na'aj yojoji'ijji'ju'.— ");
INSERT INTO mca_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ha' Jesús qa yit'ijets: —Eniipha'm. It'ij jof na' ewhi'la'x qa' ma.— ");
INSERT INTO mca_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma' qa hik akaa'ijha ha' jukhew qa t'un, qa yit'ij jof ha' ƚewhi'la'x ma' qa ik. Ka' neƚuji' witwapiihijiitax (sábado). ");
INSERT INTO mca_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Qa hik ta'ƚijupi' he' judiol in yit'ijets hakha' jukhew wanqaats'etax: —Ha'ne neƚuji' witwapiihijii (sábado) qa nite' ƚenexke'ej qu' eka'xkii na' ewhi'la'x.— ");
INSERT INTO mca_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ha' jukhew qa yeku'ƚ: —Hakha' hane'ej tsiƚin yit'ij yiwets: “It'ij jof na' ewhi'la'x qa' ma.”— ");
INSERT INTO mca_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hekhewe'en qa nifaakanij: —¿Pa'n ƚii pa' jukhew yit'ij ewets. “It'ij jof na' ewhi'la'x qa' ma”?— ");
INSERT INTO mca_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Qa ha' jukhew nite' nikfe'lij hakha' yiƚin, qe ha' Jesús ikji'teje'm he' olots jukhew i'ni' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ha' Jesús qa i'nk'aƚe yi'weni' ha' jukhew ke' qi witlijtsitjiiyifi, qa yit'ijets: —Jeƚ, in hats ƚanaxpa'lij iye pa' awtshektax. Hasu'uj uƚ'axe' iye pa'qu' aqsiijkii, hats'inha qa'nte' les qiyi'ija qu' uƚ'axe' pa'qu' ejunye'je'kii.— ");
INSERT INTO mca_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ha' jukhew qa ik, qa nifeli'm he' judiol ha' Jesús in hik hakha' yiƚin. ");
INSERT INTO mca_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma' qa hik ta'ƚijupi' hekhewe' judiol in hik ƚunyejei qu' nijayankii ha' Jesús, qe yaqsi'j jiijkii ekewe' wekwek in mexe witwapiihijiitax (sábado). ");
INSERT INTO mca_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Qa ha' Jesús qa yeku'ƚ, qa yit'ij: —Na' Tata nite' yili'ij in t'ithayii, qa yakhap ji'jek iye nite' hili'ij in he'yithayii.— ");
INSERT INTO mca_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Qa aka'an in ta'ƚets iye, he' judiol qa les in yisu'untaxija qu' nilan, qe nite' ewi'ƚƚe qu' nata'ƚets in t'otsipji'kii pakha' ƚeqe ley wete'm in t'ejuyets na'aj sábado, qe in yit'ijets iye pakha' Dios in ƚatataa'ija, qa ikji', hik ƚunye'j pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Qa hik ta'ƚijupi' ha' Jesús in yeku'ƚik'i ekewe'en, qa yit'ij: —Yijaa'ija aka' hit'iƚij ewets, na' Ƚa's nite' ƚeke' pa'qu' ƚakha' ye'ƚe qu' nisu'un qu' naqsiijkii, qe yaqsiijkii yijat'ij pakha' qu' ni'wenij na' Ƚatata qu' naqsiijkii, qe week pakha' qu' naqsiijkii na' Ƚatata qa' hik pakhaayi'ija qu' naqsi'jjiijkiyek iye na' Ƚa's. ");
INSERT INTO mca_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Qe na' Ƚatata yisu'un na' Ƚa's, ma' qa yethinij week kekhewe' ƚakha'ija in yaqsiijkii, qa kekhewe' iye les in qits wekwek ƚaqsijiyijkii hik kekhewe' qu' nethiniƚij iye hatse', ma' qa qi qu' e'nitjuƚaxiƚijpha'mkii. ");
INSERT INTO mca_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Qe in ƚunye'jek na' Ƚatata in niihinpha'mkii iye pekhewe' qu' hats nanaxtaxju' qa' netisij iye ƚiƚaxitse', qa hik ƚunye'je'jeek iye na' Ƚa's qu' netisij iye ƚiƚa'xe' pekhewe' qu' nisu'un nakha'an qu' netisij. ");
INSERT INTO mca_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Qa nite'ƚe hik nakha' na' Ƚatata qu' nit'ijets hatse' pa'qu' ƚunyejeye' me uƚ'ax me i'nƚi'i qu' ƚe'wise' ene' jukhew qa efuts iye, qe na' Ƚa's hik nakha' tisij qu' week naqsiijkii aka'an, ");
INSERT INTO mca_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","hats'inha qu' weeke' ene' jukhew qa efuts iye qu' niwqinhetji'ha na' Ƚa's pakha' hats ƚequk'elijji' in yiwqinhetji' na' Ƚatata. Pakha' qu' nite' niwqinhete'ji' na' Ƚa's, nite' yiwqinhetji' iye na' Ƚatata hik nakha' nukinju'. ");
INSERT INTO mca_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nepiye'ek'i kekhewe' hit'ij qa nite' yeqeku' nakha' ts'ukinju', pakha'an hats na'li'm na' witiƚa'x nite' yili'ij, qa' hats nite' nami'ii na' witaxtanithenkeye'j, qe hats ikik'uifik'i na' witwamhi' qa hats uiji'teje'm na' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yijaa'ija aka' qu' hit'iƚij ewets, nakha' ƚahats'ij hats nam, hane'ejija in hats nam, qa nekhewe' hik ƚunyejei qu' nanaxju' qa' nepiye' na' ƚ'a'x nakha' Ƚa's na' Dios, qa pekhewe' qu' nepi'ye' qa' iƚiye'. ");
INSERT INTO mca_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Qe in ƚunye'jek iye na' Ƚatata in na'l ji'teje'm na' witiƚa'x, qa hik ƚunye'je' iye na' Ƚa's in tisij qa' nana'lji'ij ji'teje'mek na' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma' qa tisij iye na' ƚet'unha'xijup qu' nitanithen ene' jukhew qa efuts iye, qe ƚakha' Ƚa's na' Jukhew. ");
INSERT INTO mca_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hasu'uj e'nitjuƚaxi'ƚijpha'm aka'an, qe yamets hatse' ƚahats'ij qu' weeke' ke' naxju' qu' nepiye' na' ƚ'a'x nakha'an, ");
INSERT INTO mca_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma' qa' nenekfik'ikii. Pekhewe' qu' naqsiijkii pakha' ƚe'wis qa' iƚiyi'ijup na' witiƚa'x. Qa pekhewe'ƚe qu' naqsiijkii pa' uƚ'ax qa' iƚiyi'ijupek qu' newetjeyumtshen.— ");
INSERT INTO mca_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Yakha' nite' ƚeke' qu' haqsiijkii pe'ye' qu' yakha' ye'ƚe qu' nata'ƚ yiwets. Pakha' hepi'ye' qa hikpa' qa hit'ij, qa pakha' hit'ij qa yatsathenik'iha qe nite' howo'oi pakha' qu' yakha' ye'ƚe qu' hisu'un, qe howo'oi yijat'ij qu' haqsiijkii pakha' hats yisu'un nakha' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Qu' yakha'ye' ƚetax yite'm qu' hetetfelƚetaxyik'i, pekhewe' qu' hi'ttaxij ham weju'ƚi'ij. ");
INSERT INTO mca_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Qa na'lƚe hakhap iye in iyetyij qa tsifel, qa yakha' qa tsikfe'lets hakha'an in iyetyij qu' netsfel in yijaa'ija. ");
INSERT INTO mca_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ekheweli'ƚ ƚ'ukiniƚii he' jukhew qu' nanfaakan kakha' Juan Bautista. Qa kakha'an qa yit'ijiju'ƚ kakha' yijaa'ija in ƚunyee'jkiiha. ");
INSERT INTO mca_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Qa nite'ƚe enewe' jukhewƚe qu' nata'ƚets kakha' witlijei in tsifelkii, qa lesƚe ƚe'wis qu' hitjiiƚij ewets aka'an qe qa' i'ƚiyi'iƚ. ");
INSERT INTO mca_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kakha' Juan hik ƚunye'jtax ne'ej fetitjii qe tujji'ha qa nalitkii, ma' qa ka' ƚ'uƚa'x qa ƚisu'uni'ƚ qu' ne'sinheti'ƚi'mkii, qa nite'ƚe ijetaxijje'm ƚ'ajƚi'ij. ");
INSERT INTO mca_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Qa kakha'ƚe na'l ye'm qu' henfelek qa les t'anipji' kakha' nifelek ka' Juan, qe kekhewe' wit'ithayijkitits tseƚisij na' Tata qu' haqsiijkii, hik kekhewe' hane'ej haqsiijkii, qa hik kekhewe' tsifeltax, na' Tata in hikna' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Qa nakha' ts'ukinju' Tata, ƚakha' iye in tsifeelija iye. Qa nite'ƚe ƚepi'ye'eƚ ka' ƚ'a'x, nite' ƚi'weni'ƚ iye kakha' ƚunye'j. ");
INSERT INTO mca_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Qa kekhewe' ƚe'lijei qa nite' amaneyi'ƚ etji'teje'm qe ƚeqeku'uƚ nakha' nukinju' nakha'an. ");
INSERT INTO mca_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ekheweli'ƚ qi in ƚejeƚtaxi'ƚ kekhewe' we'nika'ajji' pa'aj, qe ƚumtitaxi'ƚ qu' hik kekhewe'ye' qu' ata'ƚi'ƚijets qu' nana'liƚ'em na' witiƚa'x nite' yili'ij, qa hik kekhewe' ke' tsifeltaxkii, ");
INSERT INTO mca_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","qa nite'ƚe ƚisu'uni'ƚ qu' eneki'ƚ yiwets ma' qekha nana'ltaxi'ƚ e'm na' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yakha' nite' he'yeku'mijiju'ƚ in tsiwqinhetƚetaxji' ene' jukhew, ");
INSERT INTO mca_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","qe tsikfe'li'ƚ ewets ekheweli'ƚ, in nite' yija'aj qu' isu'uni'ƚ na' Dios. ");
INSERT INTO mca_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yakha' henekijju' aka' ƚiiji' na' Tata, qa ekhewelƚi'iƚ qa nite' ƚ'ekumi'ƚ yiju'ƚ. Qa qu' pakhape' qu' nanamij iye pakha' qu' ƚakha' ye'ƚe in ƚii, ma' qa hik pakha' yijat'ij qa' ku'mi'ƚiju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Pa'n ƚunye'j qu' nite' esqeku'yi'iƚ, in ekheweli'ƚ ƚiwetwumhiti'ƚ wetju'ƚkii in ƚeniwqinheti'ƚji', qa nite' ƚowo'oƚii yijat'ij qu' newqinheti'ƚji' na' ewi'ƚƚe Dios? ");
INSERT INTO mca_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hasu'uj umti'iƚ qu' yakha'ye' qu' hit'iƚij ewets hatse' qu' uƚ'etsi'iƚ qa' nespiye'ej na' Tata. Kakha' Moisés hik kakha' qu' nit'iƚij ewets hatse' yijat'ij qu' uƚ'etsi'iƚ, hik kakha' ƚetjumtitaxiƚifi. ");
INSERT INTO mca_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Qe qu' nite' eqeku'yi'iƚ ka' Moises'ik'i, qekha nite' esqeku'ye'ji'ijtaxi'ƚek, qe ka' Moises'ik'i kekhewe' yika'ajji' yakha' t'ejui yiwets. ");
INSERT INTO mca_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Qa qu' nite'ƚe ek'eni'iƚik'i kekhewe' yika'ajji' kakha'an ¿qa pa'n ƚunye'j qu' nite' eqeku'yi'iƚik'i kekhewe' yi'lijei?— ");
INSERT INTO mca_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","In yili'ij ekewe'en ha' Jesús, qa ikii ƚajaika' ke' kaƚi' Galilea qa ƚii iye Tiberias. ");
INSERT INTO mca_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Qa olots he' nijayan jukhew, efutsji'kii, qe yi'wenij kekhewe' ham ƚunyejeyi'iju'ƚ yaqsiimijkii hekhewe' wanqaats'etaxju'. ");
INSERT INTO mca_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ha' Jesús qa ikik'ipha'm ke' utek qa i'nju' qa he' ƚ'ijatshenhei iye. ");
INSERT INTO mca_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Qa hats k'esets ka' ƚe'wis neƚu Pascua, ƚeqe ƚe'wis neƚu ne' judiol. ");
INSERT INTO mca_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ma' qa ha' Jesús qa nejeƚtaxpha'm ma' qa yi'wen in hats namets hekhewe' olots, qa yit'ijets ha' Felipe: —Felipe ¿Pa'n qu' jintaƚi'iji' qu' jintaqhayets pe'qu' pane' qu' weeki'ij ene' jukhew?— ");
INSERT INTO mca_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yit'ijets aka'an qe qa' nijaajinij pa'qu' nit'ij ha' Felipe, qe ha' Jesús hats nikfe'ltaxets pa'qu' ƚeqfenye'ji'ij. ");
INSERT INTO mca_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ha' Felipe qa yeku'ƚ, qa yit'ij: —Nite' weju'ƚij pe'qu' doscientos (200) denariose' qu' namiju'ƚ pe'qu' pane' qa' ƚuk'eli'imkii pe'qu' netuj.— ");
INSERT INTO mca_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Qa hakha' ewi'ƚ iye hekhewe' ƚ'ijatshenhei, Andrés, ƚek'inij ha' Simón Pedro, qa yit'ijets ha' Jesús: ");
INSERT INTO mca_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Hane'en omeƚa's na'li'm ne' ƚaqats lee'fij (5) ne' pan ta'ƚets ke'ej cebada qa wetsjuk iye ne' sehets, ¿qa pa'n qu' ƚenifenye'je' in olots ene' jukhew, efuts iye?— ");
INSERT INTO mca_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ha' Jesús qa yit'ij: —Iyaji'iƚets qu' week na'nju'kii.— Qi'ii ha' qheele jup'elket qa i'nju'kii. Uja'x yamets he' jukhew lee'fij mil (5.000). ");
INSERT INTO mca_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ha' Jesús qa t'eku'mi' ke' pan, qa in hats yit'ijetspha'm ƚe'wisij pa' Dios, ma' qa tisij hekhewe' i'nju'kii. Qa hik ƚeqfenyejeyij iye ke' sehets, qa tisji'jij week pa'qu' ƚequk'eleƚi'ij. ");
INSERT INTO mca_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","In hats week iƚinijju', ma' qa ha' Jesús qa yit'ijets he' ƚ'ijatshenhei: —Ewi'ƚ eni'ƚi' ne' ƚexpelthil hats'inha qa ham pa'qu' netwumhitiiƚe'.— ");
INSERT INTO mca_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma' qa ewi'ƚ yeni', qa topolij he' doce (12) canastul ke' ƚapk'asil ke' lee'fij (5) pan ta'ƚets ke'ej cebada, ƚexpelthil hekhewe' tuj. ");
INSERT INTO mca_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hekhewe' week in yi'wenij aka' yaqsiijkii ha' Jesús in ham ƚunye'ji'iju'ƚ, qa yit'ijju': —Qete'e' yijaa'ija in hik ha'ne pakha' Profeta hayiits jutsiqaxik'ui qu' nanametsju' ha'ne sehe' ipji'.— ");
INSERT INTO mca_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Qa ha' Jesús qa hatsƚe nikfe'lets pa' yisu'untax pekhewe'en qu' net'eku'mi' qa' neka'x qa nenpha'm qu' ƚatatayi'ij. Ma' qa ikik'ipha'm iye ke' utek ewi'ƚƚekii. ");
INSERT INTO mca_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","In hats najaleyiyu'kii qa he' ƚ'ijatshenhei qa hats tepiletsju'kii ke' kaƚi', ");
INSERT INTO mca_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","qa t'ilitji'ju'kii ke' ewi'ƚ witinhitjii, qa' namiiteje'm iye ha' ƚajaika', hakha' witset'iiteje'm Capernaum. Qa hats najaleikiiha, qa ha' Jesús qa menjiit nite' tepilii hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Qa ha' qi iweli' qa nite' ikesimen qe ta'ƚets in qi ka' t'unik'i qa yiwqinhetik'i ke' ƚeqe t'uyuyits. ");
INSERT INTO mca_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hekhewe'en hats lee'fij (5), i'nƚi'i qu' ewi'ƚ tatsaye' (6) kilómetros pa' yamiji'kii in ti'jifi ke' witinhitjii, qa yi'wen ha' Jesús in hats meti'm ke' witinhitjii, t'otsipji' ha' iweli'. Ma' qa qi in nijiwei hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ha' Jesús qa yit'ijets: —¡Yakha'ƚe, hasu'uj e'nijiwe'yi'ƚ!— ");
INSERT INTO mca_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma' qa hekhewe'en qa yisu'unija qu' net'ilitji'ju' ha' Jesús ke' witinhitjii, ma' qa ke' witinhitjii qa aje'eƚ yametsteje'm ha' sehe' hakha' hats jutsiqax qu' nametsteje'm. ");
INSERT INTO mca_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Qa kakhap neƚuikakii, hekhewe' olots jukhew qa efuts iye amaneyiiteje'm hakhap iye ƚajaika' ke' kaƚi', hekhewe'en nikfe'lets in ewi'ƚƚe kekhe' witinhitjii hakha'a', qa ha' Jesús qa nite' i'netsju' iye he' ƚ'ijatshenhei, qe uja'xƚe he' ƚ'ijatshenhei in ikijteje'm ke' witinhitjii. ");
INSERT INTO mca_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma' qa uja'x he' witinhitjiyits ta'ƚii ha' witset Tiberias, qa namets ha' meti'm hakha' tuji' ke' pan in hats yit'ijetspha'm ha' Jesús ƚe'wisij pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma' qa hik ta'ƚijupi', hekhewe'en in hats nite' yi'weni' hakha'a' ha' Jesús qa he' ƚ'ijatshenhei iye, qa t'ilitji'ju'kii pa'aj he' witinhitjiyits qa nijayaniiteje'm ha' Capernaum qu' nowo'oikii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","In yametsteje'm hekhewe'en ha' ƚajaika' qa we'tweni'ƚ ha' Jesús, qa nifaakanij: —Rabí (Maestro), ¿pa'n ipƚu'uk'i in ƚanametsteje'm hane'e'in?— ");
INSERT INTO mca_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Qa ha' Jesús qa yeku'ƚ, qa yit'ij: —Yijaa'ija aka' qu' hit'iƚij ewets, ekheweli'ƚ in ƚowo'oƚyiikii nite' kekhewe' ham ƚunye'ji'iju'ƚ in haqsiijkii qu' owo'oƚijyiikii, qe ƚowo'oƚyijiikii yijat'ij in ƚetuji'ƚ ke' pan ma' qa qi in ƚ'iƚini'ƚju'. ");
INSERT INTO mca_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ithayi'yi'ƚ, qa hasu'ujƚe pa'qu' aqe'ƚi'iƚ nite' yape qu' net'ejuyets, net'ejuyets yijat'ij nakha' yape witaq nakha'an t'ejuyets hatse' na' witiƚa'x nite' yili'ij. Nakha' witaq hik nakha' ha'ne Ƚa's na' Jukhew qu' neƚisi'ƚij, hik ha'ne na' ƚatata, Dios, hats yeni' ne' ƚeq'ikati'.— ");
INSERT INTO mca_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ma' qa pekhewe'en qa yit'ijets: —¿Pa'n ƚunye'j pa'qu' wit'ithayijkit'e qu' haqsiiƚijkii qu' nisu'un pa' Dios?— ");
INSERT INTO mca_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ha' Jesús qa yeku'ƚ, qa yit'ijets: —Aka'an kakha' wit'ithayijkit yisu'un na' Dios, qu' ek'eni'ƚets hasu'uj eqeku'uƚ nakha' nukinju' nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma' qa yit'ij iye hekhewe'en in yeku'ƚ: —¿Pa'n ƚunye'j pa'qu' aqsiijkii qu' e'jutsiqaxi'ij hats'inha qu' hi'weni'ƚ qa' nite' k'eqekuyi'iƚ? ¿Ƚek pakha' qu' aqsi'jijkii? ");
INSERT INTO mca_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pe' yaqwa'mhitsiƚik'i tuj pa'aj pe' maná in neki'kii pa'aj pa' ham i'ni'i', in yit'ijek ke' we'nika'ajji': “Tisij qu' netuj pe' pa'n ta'ƚiipha'm na' wa's.”— ");
INSERT INTO mca_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ha' Jesús qa yeku'ƚ: —Yijaa'ija aka' qu' hit'iƚij ewets, nite' kakha' Moises'ik'i qu' neƚisi'ƚij kekhewe' pan ta'ƚiipha'm na' wa's. Nakha'ƚe Tata hik nakha' tisij qa hik nakha' iye qu' neƚisi'ƚij na' yijaa'ija in pan ta'ƚiipha'm na' wa's. ");
INSERT INTO mca_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Qe nakha' pan ta'ƚets na' Dios hik nakha' hats t'ilitju' ta'ƚiipha'm na' wa's, qa tisij na' witiƚa'x ha'ne week sehe' epji'.— ");
INSERT INTO mca_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma' qa hekhewe'en qa yit'ijets: —Jukhew, esƚisi'ƚijkii pakha' pan.— ");
INSERT INTO mca_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ha' Jesús qa yit'ijets: —Yakha' nakha' pan ta'ƚets na' witiƚa'x, pakha' qu' nenek yiwetsha qa' nite' ƚ'anuuyi'i qu' niyipkun. Qa pakha' qu' nite' nesqeku'ye' nite' ƚ'anuuyi'i iye qu' ne'niyayu'. ");
INSERT INTO mca_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Qa hatsƚe hit'iƚij ewets in yemjeetax in ƚetswentaxi'ƚha, qa nite'ƚe ƚ'ek'eni'ƚ yiwets ƚesqeku'uƚ. ");
INSERT INTO mca_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Week pakha' qu' nesƚisij na' Tata, qa' nenekji'ij yiwets, qa pakha' qu' nenek yiwets nite' ƚeke' qu' hoyoqoweyiju'ƚ qa nite' ƚeke' iye qu' hiwu'mfik'i. ");
INSERT INTO mca_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Qe in hata'ƚetspha'm na' wa's in hente'nili'tju', nite' tsamijju' qu' haqsiijkii pa'qu' yakha' ye'ƚe qu' hisu'un, qe tsamijju' yijat'ij qu' haqsiijkii pa' yisu'un nakha' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Qa aka'an kakha' yisu'un nakha' ts'ukinju' qu' weeke' nekhewe' hats tseƚisij nakha'an qu' hasu'uj natsqamij pe'ye', qe qu' henƚinju' yijat'ij qa' iƚiye' hatse' iye nakha' teke'lenju' neƚuji' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Qe aka'an kakha' yisu'un na' Tata qu' weeke' pakha' qu' ni'wen ha'ne Ƚa's qa nite' yeqeku', ma' qa hats na'li'm na' witiƚa'x nite' yili'ij. Qa' yakhaayi'ija qu' hiƚin qa' iƚa'xe' iye hatse' nakha' teke'lenju' neƚuji' hatse'.— ");
INSERT INTO mca_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Qa hik ta'ƚijupi' hekhewe' judiol in tajawehenij wetju'ƚkii in yuten ha' Jesús, qe ƚakha' yit'ij: —Yakha' pan ta'ƚetspha'm na' wa's in te'nilitju'.— ");
INSERT INTO mca_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Qa yit'ijju': —¿Me nite' hik ha'ne hakha' Jesús, ƚa's ka' José, kakha' ƚatata qa ke' ƚenene iye inekhewel jinikfe'lij? ¿Qa pa'n ƚunye'j hane'ej in yit'ij ƚetets: “Yakha' hata'ƚetspha'm na' wa's”?— ");
INSERT INTO mca_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Qa yeku'ƚ ha' Jesús qa yit'ijets: —Ili'iƚij in ƚ'ajaweheni'ƚ wetju'ƚkii. ");
INSERT INTO mca_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ham pa'qu' ƚeke'ye' qu' nenekƚe yiwets qu' nite' nenka'xe' yiwets na' Tata, hikna' ts'ukinju'. Qa yakha' qa' hiƚin qa' iƚa'xe' iye hatse' nakha' teke'lenju' neƚuji' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kekhewe' yika'ajji' ke' profetas'ik'i yit'ij: “Pa' Dios qu' nijatshen week enewe'en.” Week pakha' qu' nepiye' na' Tata qa hats nikfe'lets, ma' qa nek yiwets. ");
INSERT INTO mca_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nite' ikji' aka'an qu' hats nana'l pakha' qu' ni'wen na' Intata, qe ewi'ƚƚe ha'ne ta'ƚiipha'm na' Dios, hik ha'ne yi'wen yijat'ij na' Intata. ");
INSERT INTO mca_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nite' nesqeku'ye', ma' qa hats na'li'm na' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yakha' pakha' pan ta'ƚets pa' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kekhewe' alheyi'ƚik'i tuji' kekhewe' maná hakha' ham i'ni'i', qa naxƚeju'. ");
INSERT INTO mca_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Qa hane'en hik ha'ne pan ta'ƚetspha'm na' wa's, hats'inha pakha' qu' netuj hane'en, pakha'an nite' wa'm. ");
INSERT INTO mca_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yakha' pan iƚa'x ta'ƚetspha'm na' wa's. Pakha' qu' netuj ha'ne pan, qa' pakhaaye'ƚi'ij qu' iƚa'xe'. Nakha' pan qu' he'yihinij hatse' qa' ƚaja'yi'ij pe'qu' ƚiƚaxitse' ene' week ene' sehe' epji', hik nakha' yese'n.— ");
INSERT INTO mca_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma' qa he' judiol qa tek'eƚeyiteetsijju'kii, in yit'ijju': —¿Pa'n ƚunye'j hane'en qu' jineƚisij na' ƚ'ese'n qu' jinteƚuj?— ");
INSERT INTO mca_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma' qa ha' Jesús qa yit'ijets: —Yijaa'ija aka' qu' hit'iƚij ewets: qu' nite' etuji'iƚ na' ƚ'ese'n na' Ƚa's na' Jukhew qa nite' iye ƚ'iya'aƚji' ne' ƚ'athits, qa' hami'iƚ etji' na' witiƚa'x. ");
INSERT INTO mca_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pakha' qu' netuj na' yese'n qa iya'ji' iye ne' yathits, pakha'an hats na'li'm na' witiƚa'x nite' yili'ij, qa yakha' qa' hiƚin qa' iƚa'xe' iye hatse' nakha' teke'lenju' neƚuji' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Qe na' yese'n yijaa'ija yijat'ij in witaq, qa ne' yathits qa yijaa'ija iye in witaat'ija. ");
INSERT INTO mca_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pakha' qu' netuj na' yese'n qa iya'ji' iye ne' yathits, pakha'an i'nyit ji'teje'mha qa yakhap ji'jek qa ha'nji'ij ji'teje'mha'ek pakha'an. ");
INSERT INTO mca_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na' Tata, hikna' ts'ukinju', na'li'm na' ƚiƚa'x, qa yakha' qa na'lji'ij ye'mek na' yiƚa'x qe ta'ƚets nakha'an. Qa hik ƚunye'j pakha' qu' netuj na' yese'n, qa' nata'ƚjiij yiwetsek ƚiƚa'xe'. ");
INSERT INTO mca_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hane'en hik ha'ne pan ta'ƚetspha'm na' wa's in te'nilitju', hane'en nite' hik ƚunye'j pekhewe' tujtax ke' aqa'jteyi'ƚik'i, qa naxƚeju'. Qa pakha' qu' netuj ha'ne pan ta'ƚetspha'm na' wa's qa' pakhaaye'ƚi'ij qu' iƚa'xe'.— ");
INSERT INTO mca_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ekewe'en hik ekewe' ke' yit'ij ha' Jesús ke' witlijtsitjiyifi in i'nq'ijatsheni' ha' witset Capernaum. ");
INSERT INTO mca_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Qa olotsƚe hekhewe' ƚ'ijatshenheitax in yepi'ye' ek'i kekhewe' yit'ij, ma' qa yit'ijju': —Ka' yit'ij nakha'an jutsitax qu' jint'eku'mi'. ¿Pa'n ƚii pakha' qu' ƚeke'ye' qu' net'eku'miju'ƚ kakha'an?— ");
INSERT INTO mca_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ha' Jesús qa nikfe'lƚi'ik'uyi' hekhewe'en in tajawehenij wetju'ƚkii in nite' yisu'un kekhewe' yit'ij, qa yit'ijji'ju': —¿Me nawakanini'ƚkii ekewe'en? ");
INSERT INTO mca_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Qa pa'n qu' ejunyejeyi'iƚek qu' i'wentaxi'ƚ hatse' ha'ne Ƚa's na' Jukhew qu' napiletspha'm iye na' hayiits i'ntaxi'? ");
INSERT INTO mca_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na' Espíritu Santo hik nakha' ta'ƚets nakha' witiƚa'x, ha'ne i'nese'n ham weju'ƚi'ij. Kekhewe' wekwek hit'iƚij ewets espirituƚe qa witiƚa'x iye. ");
INSERT INTO mca_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Qa na'lƚe ne' uja'x ekheweli'ƚ ne' yeqeku'uk'i.— Qe ha' Jesús hayiits pa'aj in nikfe'lets pekhewe' yeqeku' qa kakha' iye wotk'onijkii. ");
INSERT INTO mca_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Qa yit'ij iye: —Qa hik ta'ƚijupi' in hit'iƚij ewets, in ham pakha' qu' nenekƚe yiwets qu' nite' nesƚisi'ij na' Tata.— ");
INSERT INTO mca_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Qa aka'an qa hik aka' ta'ƚets in olots hekhewe' yak'esik'uikii yijayantax, qa hats nite' yijayan. ");
INSERT INTO mca_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma' qa ha' Jesús qa yit'ijets he' doce (12) ƚ'ijatshenhei: —Qa ekheweli'ƚ, ¿me ƚenikheyu'u'ƚ yik'ui iye?— ");
INSERT INTO mca_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ha' Simón Pedro qa yeku'ƚ: —Yatsat'axyij ¿pan ƚii pa'qu' hijayani'ƚ? Ke' e'lijei ta'ƚets pa' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Qa yekheweli'ƚ qa nite' heqeku'uƚik'i qa tsikfe'li'ƚets iye in hik akhaa'ija pakha' ewi'ƚƚe in ta'ƚiiha pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ha' Jesús qa yeku'ƚ: —¿Me nite' yakha' he'yeku'mi'ƚ eiji'kii qa o'doce'eƚ? Ƚa'mek nakha' ewi'ƚ ekheweli'ƚ qa hik nakha' ewi'ƚ inwo'met.— ");
INSERT INTO mca_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","In yit'ij aka'an ha' Jesús qete'e' kakha' Judas, ƚa's pakha' Simón Iscariote, in yekelki'sijkii. Qe kakha'an hik kakha' t'ihinij hatse' Jesús yemjeetax in i'ntaxji'teje'm hekhewe' doce (12). ");
INSERT INTO mca_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","In yili'ij ekewe'en ha' Jesús qa i'nk'aƚe qa ikik'i he' witsetits ha' sehe' Galilea. Nite' yisu'un qu' neneki'kii hakha' sehe' Judea, qe hik hakha'a' hekhewe' judiol wo'taxiikii qu' nilan. ");
INSERT INTO mca_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Qa in hats k'esets kekhewe' ƚeqe ƚe'sits neƚuts nekhewe' judío, ƚeqiyij tabernáculos. ");
INSERT INTO mca_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Qa hik ta'ƚijupi' hekhewe' ƚek'injats in yit'ijets: —Hasu'uj a'mani'iju' hane'e'in. Amii ha' Judea hats'inha qa ne'wenij pa'qu' aqsiijkii he' hikna' i'ni' najayan iye. ");
INSERT INTO mca_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Qe ham pa'qu' ewii'ƚe' qu' nanat'inijkii pe'qu' naqsiijkii in yisu'un qu' ninikfe'l. Qu' yijaayi'ija qu' aqsi'jijkii ekewe' wekwek, qa' yape menethinijets ha'ne week sehe' epji' qu' aqsiijkii iye.— ");
INSERT INTO mca_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Qe in yemjeetax in ƚek'injatstaxija qa yeqeku' iye hekhewe'en hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma' qa ha' Jesús qa yit'ijets: —Pakha' yinjeyumtshenek'ii hatse' mexente' yamets, qa ekhewelƚi'iƚ qa pakha'ƚe qu' ƚahats'i'ij qu' ami'ƚii qa hats ƚe'wisijupi'. ");
INSERT INTO mca_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ene' week sehe' epji' nite' ƚeke' qu' na'napjaxi'ƚ e'm, qa yakha'ƚe qa napjax ye'm qe ta'ƚijupi' in henfeli'mha kekhewe' yaqsiijkii in uƚ'ets. ");
INSERT INTO mca_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ami'ƚii pakha' ƚe'wis neƚu, yakha'ƚe qa' mexe nite' natsami'ii, qe pakha' yinjeyumtshenek'ii mexe nite' yafits pa' ƚahats'ij.— ");
INSERT INTO mca_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aka'an in yit'ijets, qa ha' Jesús qa amani'ju' ha' sehe' Galilea. ");
INSERT INTO mca_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Qa in hatsƚe ikkii he' ƚek'injats yamii ka' ƚe'wis neƚu, ma' qa ha' Jesús qa ikek iye, qa nite'ƚe watanalitij wanat'inkii. ");
INSERT INTO mca_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Qa hik ta'ƚijupi' hekhewe' judiol in wo'taxiikii kakha' ƚe'wis neƚuji' qa yit'ijju': —¿Pa'n qu' na'ni'i' hakha' jukhew?— ");
INSERT INTO mca_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Qa week in tajawehenij wetju'ƚkii yifaakateji' hakha' Jesús. Uja'x he' yit'ijju': —Hakha' teik'unei.— Qa uja'x he' yit'ijju'ek: —Nite', hakha'an yaqanƚekii ene' jukhew.— ");
INSERT INTO mca_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Qa ƚunye'j ji'ij in ham pakha' qu' nit'unhetijpha'm qu' niyet in yijamti'ets ha' Jesús qe nijiweyiju'ƚ hekhewe' judiol. ");
INSERT INTO mca_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Qa in hats ƚeqewuk'uje'm yamijets ke' ƚe'sits neƚuts, ha' Jesús qa uyifi ke' qi witlijtsitjii, ma' qa i'nq'ijatshen. ");
INSERT INTO mca_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma' qa hekhewe' judiol qa qi in yitjuƚaxijpha'mkii, qa yit'ijju': —¿Pa'n ƚunye'j hane'en in qi in nikfe'lets ekewe' wekwek in nite' qu' nenq'ikataxij?— ");
INSERT INTO mca_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ha' Jesús qa yeku'ƚ, qa yit'ij: —Ekewe' k'inq'ijatshenij nite' ta'ƚ yiwets, nakha'ƚe ts'ukinju' hikna' ta'ƚets. ");
INSERT INTO mca_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Qu' nana'l pakha' qu' nisu'un qu' naqsiijkii pakha' yisu'un nakha'an, qa hik pakha'ye' qu' nenikfe'lets kekhewe' k'inq'ijatshenij me ta'ƚets na' Dios, me i'nƚi'i qu' yakha' ye'ƚe qu' nek'iyetƚeyitij. ");
INSERT INTO mca_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pakha' qu' ƚakha' ye'ƚe qu' nata'ƚets pekhewe' qu' nit'ij wo'ƚi'ii qu' neniwqinhetji'. Qa pakha'ƚe qu' nowo'oi qu' neniwqinhetji' pakha' yukin, hik ha'ne yijat'ij pakha' iyetij yijaa'ija qa hami'm pakha' witwejtitsi' hane'en. ");
INSERT INTO mca_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Me nite' neƚisi'ƚij ka' Moises'ik'i kekhewe' wenit'ij qu' nanaqsiijkii (leyes)? Qa ƚa'mek qa ham pa'qu' ewii'ƚe' qu' naqsi'jijkii kekhewe'en. ¿Inhats'ek in ƚenqek'uyutaxi'ƚyij?— ");
INSERT INTO mca_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hekhewe' olots jukhew qa efuts iye qa yeku'ƚ, qa yit'ijju': —¡In'etji' pa' ewi'ƚ inwo'met! ¿Ƚek pakha' qu' nenqek'uyu' ej?— ");
INSERT INTO mca_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Qa yeku'ƚ ha' Jesús qa yit'ijets: —Ewi'ƚƚe kakha' haqsiijkii qa e'weeki'ƚ in ƚenitjuƚaxiƚijpha'm. ");
INSERT INTO mca_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Qa kakha' Moises'ik'i in neƚisi'ƚij kakha' circuncisión, qa yemjeetax in namtaxji'ju' na'aj witwapiihijiitax qa ƚunye'j ji'ij qa ƚaqsi'ji'ƚi'mijkii kakha'an na'aj omeƚa's. Qa ka' Moises'ik'i qa nite' hik kakha'tax qu' nata'ƚets kakha' ƚunye'jkii, qe hayiits kekhewe' aqa'jteyi'ƚik'i in hik kekhewe' in ta'ƚets yijat'ij. ");
INSERT INTO mca_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Qa qu' nite' notnotshiyi'ipji'kii kakha' ley ma' qa we'nisa'xii ƚaxpa's na'aj omeƚa's in yemjeetax qu' witwapiihijiye'tax, ¿qa hane'ej qa inhats'ek in ƚanayu'uƚij ye'm in hiƚinji' ka' ewi'ƚ neƚuji' witwapiihijii ha' ewi'ƚ jukhew qi wanqaats'etax? ");
INSERT INTO mca_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hasu'uj it'iƚijets qu' hik pakhaayi'ija qu' ƚunye'je' pakha' qu' nite' iweeni'iƚha, mowo' eku'ni'ƚii yijat'ij qu' enikfee'liƚetsha, ma' qa' hayitse' yijat'ij qu' it'iƚij.— ");
INSERT INTO mca_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma' qa he' uja'x hekhewe' tetseti'yi' ha' Jerusalén qa watfaakateji'ijju': —¿Me nite' hik ha'ne ha' teniwohoitaxiikii qu' natlanhetii? ");
INSERT INTO mca_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jeƚ qeku'ni'ƚek, hats iyetik'ui ene' jukhew qa efuts iye, qa ham pa'qu' nit'ijets. ¿Maatsek yumti iye nekhewe' wit'alhei qu' hik nakha'ye' pa' Cristo? ");
INSERT INTO mca_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Inekhewel jinikfe'lets hakha' ta'ƚji' nakha'an, qa pakha'ƚe Cristo qu' nanamtax qa ham nenikfe'lets pa'qu' nata'ƚji'.— ");
INSERT INTO mca_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ha' Jesús in mexe i'nq'ijatshenifi ke' qi witlijtsitjii, qa yit'unhetik'i in yit'ij: —Ekheweli'ƚ ƚenikfe'li'ƚyij qa ƚenikfe'li'ƚets iye pa'n hata'ƚji'. Yakha' nite' ta'ƚƚe yiwets in tsam, qe ts'ukin yijat'ij nakha' ewi'ƚ yijaa'ija kakha' ƚunye'j, hik nakha' nite' ƚenikfe'li'ƚets. ");
INSERT INTO mca_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yakha' tsikfe'lets nakha'an, qe hikna' hata'ƚii, qa nakha'an qa hik nakha' ts'ukin.— ");
INSERT INTO mca_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma' qa yisu'untax qu' net'eku'mi', qa hamƚe pakha' qu' net'eku'mets, qe mexente' yamets pakha' ƚenjeyumtshenek. ");
INSERT INTO mca_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Qa olotsƚe hekhewe' tek'enets nite' yeqeku', qa yit'ijju': —Qu' nanamtax pa' Cristo, ¿me qa' naqsiijkii iye pe'qu' ham ƚunyejeyi'iju'ƚ qu' les nat'anipji' kekhewe' yaqsiijkii ha'ne jukhew?— ");
INSERT INTO mca_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","He' fariseol yepi'ye' ej hekhewe' olots in tajawehenij wetju'ƚkii ekewe' wekwek t'ejuyets ha' Jesús. Ma' qa he' tenek'enhe'yij he' pa'il qa hekhewe' iye fariseol qa yukintaxii he' yejeƚ ke' qi witlijtsitjii qu' nophe'ƚ ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma' qa ha' Jesús qa yit'ij: —Hats nite' toxik'ui qu' hats nite' ha'ni'iƚ etji'teje'm, ma' qa hapilii iye na' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ekheweli'ƚ qa' mowotaxi'ƚyiikii, qa' nite'ƚe e'tsweni'iƚ, qa nakha' qu' ha'ni', ekheweli'ƚ nite' ƚeke' qu' ami'ƚii.— ");
INSERT INTO mca_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma' qa hekhewe' judiol qa watfaakateji'ijju': —¿Qetuk pa'qu' nakji' hane'en in yit'ijets qu'nte' jinte'wene'? ¿Me i'nƚi'i qu' namii pekhewep judiol i'nji'kii pe' griego ƚetsetits qa' nijatshen pe' griego? ");
INSERT INTO mca_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Pa'n qu' nukinji'ha aka' yit'ij inwets: “Ekheweli'ƚ qa' mowotaxi'ƚyiikii, qa' nite'ƚe e'tsweni'iƚ, nakha' qu' ha'ni' ekheweli'ƚ nite' ƚeke' qu' ami'ƚii”?— ");
INSERT INTO mca_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","In hats ewi'ƚƚe ka' neƚu aman qa' nanaxijik'i ke' ƚe'sits neƚuts, hik kakha' les in ƚe'wisija kakha' neƚu. Ha' Jesús qa niipha'm qa ts'ap'a, qa yit'unhetik'i in iyet: —Qu' nana'l pakha' qu' ne'niyayu' qa nenek yiwets qa' niya'. ");
INSERT INTO mca_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pakha' qu' netk'en yiwets nite' tseqeku', qa hik ƚunye'je' kakha' yit'ij kekhewe' hats we'nika'ajji': “Pakha' les toxiiju' pa' ƚatawe'j qu' ne'niwekƚeji' pe'qu' iweliiye' haqqil witiƚa'x.”— ");
INSERT INTO mca_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ha' Jesús in yit'ij aka'an, pakha'ƚe Espíritu Santo hik pakha' nifel, qu' netesti'yij hatse' pekhewe' qu' netk'enets nite' yeqeku' hakha'an, qe pakha' Espíritu Santo mexente' namju', qe ha' Jesús mente' wapiletspha'm na' wa's ma' qa' ne'nenpha'm qa' hats qiye'ji'ha. ");
INSERT INTO mca_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma' qa he' uja'x hekhewe' olots jukhew qa efuts iye, in yepi'ye' ek'i ekewe' yit'ij ha' Jesús, qa yit'ijju': —Yijaa'ija in hik ha'ne pakha' profeta t'otkaxtiitaxik'uikii.— ");
INSERT INTO mca_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hekhewep qa yit'ijetsek: —Hik ha'ne pakha' Cristo.— Qa yi'tƚi'ijju' iye hekhewep iye: —Nite', ¿me ƚeke' pa' Cristo qu' nata'ƚii na' sehe' Galilea? ");
INSERT INTO mca_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Me nite' yit'ij kekhewe' we'nika'ajji' Intata ƚe'lijei pa' Cristo qu' nata'ƚets hatse' pekhewe' ta'ƚets pa' David'ik'i, qa' nata'ƚets iye na' Belén hik nakha' ƚetset pa'aj pa' David'ik'i?— ");
INSERT INTO mca_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma' qa he' olots jukhew qa efuts iye qa nite' ƚ'anyejeyij wetju'ƚ ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Qa he' uja'x hekhewe'en qa yisu'untax qu' net'eku'mi' qu' nophe'ƚ, qa hamƚe pa'qu' net'eku'mets. ");
INSERT INTO mca_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ma' qa hekhewe' yejeƚ ke' qi witlijtsitjii qa tepilii iye ha' i'ni' hekhewe' tenek'enhe'yipji' he' pa'il qa he' fariseol, qa enewe'en qa nifaakantaxij, qa yittaxijets: —¿Inhats'ek in nite' ƚenka'xi'ƚ?— ");
INSERT INTO mca_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hekhewe' yejeƚ ke' qi witlijtsitjii qa yeku'ƚ: —¡Ham pa'qu' jukhewe' qu' niyet qu' hik ƚunye'je' hakha' jukhew in iyet!— ");
INSERT INTO mca_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma' qa he' fariseol qa yit'ijets: —¿Ye' me ekhewepi'ƚ iye nawitji'iƚ iye? ");
INSERT INTO mca_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Me na'l pa'qu' ewii'ƚe' nekhewe' tenek'enhei qu' netk'enets hakha'an, i'nƚi'i ene' fariseol? ");
INSERT INTO mca_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Qa enewe'ƚe olots jukhew qa ne' efuts iye in nite' nikfe'lets kekhewe' wenit'ij (ley), hats qi in i'nipji' pa' uƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ha' Nicodemo, hikha' fariseo namii hik aka'aj ha' Jesús, hikha' i'nji'teje'm iye hekhewe'en, qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Me nite' yit'ij kakha' inqe ley qu' hasu'uj jintit'ijets qu' uƚ'axe' pa'qu' naqsiijkii pa'qu' ewi'ƚ jukhewe' qu' nite' nojoye' qu' natfaakanhetiikii ma' qa jutsiqax pa'qu' naqsiijkii?— ");
INSERT INTO mca_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma' qa hekhewe'en qa yeku'ƚiju'ƚ, qa yit'ijets: —¿Me akhap iye Galilea ƚeiƚe'? Jeƚijupkii ke' Intata ƚe'lijei, qa' enikfe'lets in ham pa'qu' profetaye' qu' nata'ƚii ha' Galilea.— ");
INSERT INTO mca_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ma' qa week wapiliikii pe' ƚetsil. ");
INSERT INTO mca_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Qa hakha'ƚe Jesús qa ikii ke' utek Olivos. ");
INSERT INTO mca_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Qa kakhap neƚukii qa wekiyaafii iye ke' qi witlijtsitjii. Ma' qa nekets hekhewe' olots jukhew qa efuts iye, ha' Jesús qa i'nju' qa yijatshen. ");
INSERT INTO mca_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hekhewe' i'nq'ijatshenij ke' Moisés ƚe'lijei qa he' fariseol iye t'ilit'ijets pa'aj ke' ewi'ƚ efu in wanawitji'iƚ pa'aj pa' jukhew nite' ƚewhe'ye'tax. Qa neka'xii ha' Jesús qa yenji'ju' ƚeqewuk'u pe' week jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Hekhewe'en qa yit'ijets ha' Jesús: —Maestro, ene' efu titkamhitiiƚi'ij in yawitjitax ha' ewi'ƚ jukhew nite' ƚewhe'ye'tax. ");
INSERT INTO mca_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In t'ejuyets kakha' ley, pa' Moises'ik'i yit'ij inwets qu' netje'laxti'yijkii pe'qu' utele' qa' naq'alƚi'ij pe'qu' efuye' qu' hik ƚunye'je' aka'an. Qa akha' ¿pa'n qu' it'i'ij?— ");
INSERT INTO mca_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hekhewe'en nifaakanij aka'an, qe yijaajintax ha' Jesús, hats'inha qu' nana'li'm pa'qu' nit'ijju' qu' nit'ijets qu' uƚ'axe' in yaqsiijkii. Ma' qa totjoijo' ha' Jesús qa yika' ha' sehe' yit'iji' ƚayaqsi'. ");
INSERT INTO mca_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","In menjiit nite' yili'ij in nifaakanijkii, ma' qa nejeƚpha'm ha' Jesús qa yit'ij: —Pakha' qu' haamija ƚewuƚ'axe' ekheweli'ƚ qa' hik pakha'ye' qu' nojo'oj qu' nenjele'ej pe'qu' uteye'.— ");
INSERT INTO mca_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ma' qa totjoijo' iye qa yika' iye ha' sehe'. ");
INSERT INTO mca_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","In yepi'ye' ek'i aka'an hekhewe'en ma' qa wapilƚe kiyek yojo'oj in wapilkii he' ƚawa'mhits ma' qa teiƚem in week wapilik'uikii, qa hats yiwejinƚe ha' Jesús qa kikhe' iye efu we'nenji'ju' ƚeqewuk'u. ");
INSERT INTO mca_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ha' Jesús qa nejeƚpha'm iye qa nifaakan: —Efu, ¿kheweye'ek hekhewe' neqek'uyutax'ej? ¿Me ham pakha' qu' nisu'un qu' natanithenij pa' uƚ'ax ƚaqsi'jijkii?— ");
INSERT INTO mca_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kikhe'en qa yeku'ƚ: —Ham, jukhew.— Ha' Jesús qa yit'ijets: —Qa' yakhape' jeek iye qu' nite' k'atanitheni'ij. Yape ma. Hane'ej qu' nata'ƚi' qu' hasu'uj mapilets iye qu' aqsiijkii pa'qu' uƚ'axe'.— ");
INSERT INTO mca_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ma' qa iyetik'ui iye ha' Jesús he' jukhew qa efuts, qa yit'ij: —Yakha' ƚefetitjii ha'ne week sehe' ipji'. Pa'qu' natsjayan qa' nite' ƚ'anuuyi'i qu' nijalki'sji'kii na' nookii, qe nakha' na'lkii ta'ƚets na' witiƚa'x hik nakha' qu' nana'li'm yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma' qa he' fariseol qa yit'ijets: —Akha'ƚe ete'm in ƚetetfeltax. In ƚetetfeltax nite' weju'ƚij.— ");
INSERT INTO mca_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ha' Jesús qa yeku'ƚ, qa yit'ij: —In yemjeetax in yakha'ƚetax yite'm in hetetfelƚetax, qa yijaalƚi'ija kekhewe' hit'ij, qe yakha' tsikfe'lets pa'n hata'ƚji' qa' pa'n hakji' iye. Qa ekhewelƚi'iƚ qa nite' ƚenikfe'li'ƚ yiwets pa'n hata'ƚji' qa pa'n qu' hakji' iye. ");
INSERT INTO mca_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ekheweli'ƚ ewi'ƚƚe in ƚejeƚi'ƚ pa' ƚunyejei ene' i'nipji' ha'ne sehe', qa yakha'ƚe qa ham pa'qu' hats hit'ijets qu' uƚ'axe' pa'qu' ƚunye'je'. ");
INSERT INTO mca_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Qa qu' hit'ijets pe'ye' pa'qu' ƚunye'je' me uƚ'ax me i'nƚi'i qu' nite' uƚ'axe', qa yijaa'ija yijat'ij in hik pakha' qu' ƚunye'je', qe nite' yeƚ'ewi'ƚ ƚi'ijkii qu' hit'ijets, qe nakhapji'ij iye Tata hik nakha' ts'ukin hikna' yeweeki'ƚij. ");
INSERT INTO mca_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Qa kakha' we'nika'ajji' eqe leyi'ƚ qa yit'ijets iye qu' wetsjuk'e pe'qu' jukhewe' in week ƚ'anyejeyi'ij pa'qu' nenfelkii, ma' qa hats yijaa'ija yijat'ij. ");
INSERT INTO mca_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Qa hik yijunye'j, yakha' in yakha'ƚe yite'm in hetetfel, qa nakha' ts'ukin, Tata, hik nakha' iye tsifel iye.— ");
INSERT INTO mca_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma' qa hekhewe'en qa yit'ijets: —¿Pa'n i'ni' pa' atata?— Qa yeku'ƚ ha' Jesús, qa yit'ij: —Ekheweli'ƚ nite' ƚenikfe'li'ƚ yiwets qa nite' ƚenikfe'li'ƚets iye na' Tata. Qek enikfe'li'ƚ yiwets qekha enikfe'lji'ijtaxi'ƚetsek na' Tata.— ");
INSERT INTO mca_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ha' Jesús in yit'ijji'ju' ekewe'en in i'nq'ijatshenifi ke' qi witlijtsitjii, qa i'niji' hakha' i'ni' hekhewe' ƚeqjiikilij ne'ej ƚ'astai ofrendas, qa ham pa'qu' net'eku'mi' qu' nophe'ƚ, qe mexe nite' yamets pa' ƚenjeyumtshenek. ");
INSERT INTO mca_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma' qa ha' Jesús qa ewi'ƚij iye in yit'ijets: —Qu' haktax qa ekheweli'ƚ qa mowotaxi'ƚyiikii, ma' qa' anaxƚi'iƚijju' ne' ewuƚ'etsi'ƚ. Nakha' qu' hakji', ekheweli'ƚ nite' ƚeke' qu' ami'ƚii.— ");
INSERT INTO mca_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Qa hik ta'ƚijupi' he' judiol qa yit'ijju': —¿Ma yijamti'etsek qu' ƚakha' ye'ƚe ƚete'm qu' natwamhit, qe yit'ij: “Nakha' qu' hakji', ekheweli'ƚ nite' ƚeke' qu' ami'ƚii”?— ");
INSERT INTO mca_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ha' Jesús qa yit'ij: —Ekheweli'ƚ yatsat'etsi'ƚ epji' ha'ne metju', qa yakha'ƚe qa na' toxpha'm. Ekheweli'ƚ yatsat'etsi'ƚ epji' ha'ne sehe' qa yakha'ƚe qa nite' yatsat'axyipji' ha'ne sehe' epji'. ");
INSERT INTO mca_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hik ta'ƚijupi' in hit'iƚij ewets qu' anaxƚi'iƚijju'ha hatse' ne' ewuƚ'etsi'ƚ, qe qu' esqeku'uƚ in hik yakha'taxija (aka' hit'ij), qa' anaxƚi'iƚijju' ne' ewuƚ'etsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma' qa nifaakan iye: —¿Pa'n ejunye'jija?— Ha' Jesús qa yeku'ƚ: —Yakha' inek week ƚahatsiyij k'efeljiiƚi'm kakha' yijunye'j. ");
INSERT INTO mca_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Olotstax kekhewe' tseqitijineyutaxi'ƚij ewets in t'ejuyets kakha' uƚ'ax ejunyejeyi'ƚ, qa nite'ƚe ƚeke', qe ewi'ƚƚe qu' hit'ij pakha' qu' nit'ij yiwets nakha' ts'ukinju', qa hik nakha' yijaa'ija na'aj yit'ij. Yakha', kekhewe' wekwek hepi'ye'ej nakha'an, hik kekhewe' henfeltaxi'm ene' sehe' epji'.— ");
INSERT INTO mca_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hekhewe'en nite' nikfe'lik'i in iyetij pa' Intata in hikpa' nukin. ");
INSERT INTO mca_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Qa hik ta'ƚijupi' ha' Jesús in yit'ij: —Ekheweli'ƚ qu' entaxi'ƚpha'm na' Ƚa's na' Jukhew, ma' qa' enikfe'li'ƚets in hik yakhaataxija, qa' enikfe'li'ƚets iye in ham pakha' qu' haqsiijkii qu' yakha' ye'ƚe qu' hisu'un, qe k'iyetij yijat'ij ekewe' wekwek in ƚunyejeyek kekhewe' hats ts'ijatshenij na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Qa Nakha'an, nakha' ts'ukin qa i'nyijupha, nite' ts'iton, qe yakha' haqsi'jijkii week na'aj yi'sinhetij.— ");
INSERT INTO mca_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ha' Jesús in iyetij ekewe' wekwek, qa olots hekhewe' tek'enets nite' yeqeku'. ");
INSERT INTO mca_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma' qa ha' Jesús qa yit'ijets he' judiol hekhewe' nite' yeqeku'tax hakha'an: —Ekheweli'ƚ qu' nite' anqatsit'i'iƚij kekhewe' yi'lijei, ma' qa yijaayi'ija qu' k'eyijatshenheiyi'iƚij, ");
INSERT INTO mca_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ma' qa' enikfe'li'ƚets nakha' yijaa'ija, qa nakha' yijaa'ija qa' hik nakha' newejini'ƚkii.— ");
INSERT INTO mca_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hekhewe'en qa yeku'ƚ, qa yit'ijets: —Yekheweli'ƚ hata'ƚi'ƚets pa' Abraham'ik'i, qa ham pa'qu' ƚeƚinheiyi'iƚyij. ¿Qa pa'n ƚunye'j in ƚittaxiƚij yiwets: “Qa' ewejinheti'yi'ƚkii”?— ");
INSERT INTO mca_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ha' Jesús qa yeku'ƚ iye: —Yijaa'ija aka' hit'iƚij ewets, week pakha' qu' naqsiijkii pa' uƚ'ax, pakha'an ƚeƚinek'ij pa' uƚ'ax. ");
INSERT INTO mca_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na'aj jukhew witƚinek nite' ƚeke' qu' pakhaaye'ƚi'ij qu' amani'ijupkii ne'ej wititsi'. Qa na'aj ƚaa'sija na'aj yatsat'axij ne'ej wititsi' qa hik na'aj yijat'ij in amanijup ne'ej ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Qa hik ta'ƚijupi' qu' pakha'ye' Wita's qu' nelineniƚij qu' hats nite' e'witƚinheyi'iƚij, qa' yijaayi'ija qu' hats nite' e'witƚinheyi'iƚij, qa pakhaaye'ƚi'ij qu' a'maneyi'iƚijupkii. ");
INSERT INTO mca_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tsikfe'lets in ƚata'ƚiƚets kakha' Abraham'ik'i, ƚa'mek qa ƚenqek'uyu'uƚyij qe ta'ƚijupi' in nite' ƚ'eku'mi'ƚi' kekhewe' yi'lijei. ");
INSERT INTO mca_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yakha' k'iyetij kekhewe' hi'wen in ha'nijup na' Tata, qa ekheweli'ƚ qa ƚaqsiiƚijkiyek pa' yit'iƚij ewetsek na' atata'aƚ.— ");
INSERT INTO mca_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hekhewe'en qa yeku'ƚ iye, qa yit'ijju': —Pa' Abraham'ik'i hik pakha' tata'aƚ.— Ha' Jesús qa yeku'ƚ: —Qu' yijaayi'ija qu' atatayi'iƚ kakha' Abraham'ik'i, aqsiiƚijkii kakha' yaqsiijkii ka' Abraham'ik'i. ");
INSERT INTO mca_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Qa ha'neƚi'ij qa ƚenqek'uyu'uƚyij, yakha' in henfeltaxi'ƚ e'm kakha' yijaa'ija hepi'ye'ej na' Dios. Ka' Abraham'ik'i nite' yaqsiijkii aka'an in ƚenqek'uyu'taxi'ƚyij. ");
INSERT INTO mca_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ekheweli'ƚ ƚaqsiiƚijkii pakha' yisu'un na' atata'aƚ.— Qa yeku'ƚ hekhewe'en qa yit'ijets: —Yekheweli'ƚ nite' heneki'ƚijfik'ikii qu' yewitqa'ƚetsi'iƚ. Na'l pa' ewi'ƚƚe in tata'aƚ, pakha'an Dios.— ");
INSERT INTO mca_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ha' Jesús qa yeku'ƚ: —Qek yijaayi'ija qek atatayi'iƚ na' Dios, ma' qekha ets-su'untaxi'ƚ, qe yakha' hata'ƚii na' Dios, ma' qa tsam. Nite' yakha'ƚe yite'm qu' natsam, nakha'ƚe Dios ts'ukinju' qa tsam. ");
INSERT INTO mca_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Inhats'ek in nite' ƚenikfe'li'ƚik'i kekhewe' hit'ij? Qe nite' ƚisu'uni'ƚ qu' ek'eni'ƚik'i kekhewe' yi'lijei. ");
INSERT INTO mca_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ekheweli'ƚ na' atata'aƚ nakha'an inwo'met (Satanás), qa ƚisu'uni'ƚ qu' aqsiiƚijkii kekhewe' yisu'un na' atata'aƚ. Nakha'an hayiitsƚe in eqek'una'x ta'ƚijii in i'nk'aa'ija. Nite' aman ji'teje'm na' yijaa'ija qe hamji' na' yijaa'ija nakha'an, in iyet yaqanƚekii, iyetƚi'ij kakha' hats ƚunye'jƚe nakha'an, qe nakha'an ejtitsax qa ƚatata iye na' witwejtitsi'. ");
INSERT INTO mca_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Qa yakha' in yijaa'ija na'aj hi'ttaxi'ƚij ewets, qa nite'ƚe ƚ'ek'eni'ƚ yiwets, ƚesqeku'uƚ. ");
INSERT INTO mca_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ƚek pakha' ekheweli'ƚ pa'qu' ni'nq'ethinij qu' na'nyitji' pa' uƚ'ax? Qa qu' hit'ij pa' yijaa'ija, ¿qa inhats'ek in ƚesqeku'uƚ? ");
INSERT INTO mca_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na'aj yatsat'axij na' Dios qa tek'enets ke' ƚe'lijei na' Dios. Qa ekhewelƚi'iƚ qa nite' ƚ'ek'eni'ƚets, qe nite' yatsat'etsi'ƚ ej na' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hekhewe' judiol qa yeku'ƚ iye: —Yekheweli'ƚ hasiniƚik'iha ka' hit'iƚij ewets in a'samaritano qa in'etji' iye pa' ewi'ƚ inwo'met.— ");
INSERT INTO mca_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ha' Jesús qa yeku'ƚ iye, qa yit'ij: —Ham yitji' pa'qu' inwo'met'e, qe hiwqinhetji' yijat'ij na' Tata, qa ekhewelƚi'iƚ qa nite' ƚetsiwqinheti'ƚji'. ");
INSERT INTO mca_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Qa nite'ƚe howo'oiji' qu' heniwqinhetji', qa na'lƚe nakha' wo'oiji' qu' netsiwqinhetji', qa hik nakha' iye qu' nejeƚik'ui yijat'ij me ƚe'wisju' me i'nƚi'i qu' nite' ƚe'wise'ju'. ");
INSERT INTO mca_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' netk'enik'iha eke' yi'lijei, qa' nite' ƚ'anuuyi'i qu' ni'wen na' witwamhi'.— ");
INSERT INTO mca_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Qa yeku'ƚ hekhewe' judiol, qa yit'ijju': —Hane'ej hats tsikfe'li'ƚetsha in i'n'etjiha pa' ewi'ƚ inwo'met. Pa' Abraham'ik'i wa'm, qa week pekhewe' profetas'ik'i iye in naxju'. Qa akha' qa ƚit'ij: “Pakha' qu' netk'enik'iha eke' yi'lijei qa' nite' nijaajine' na' witwamhi'.” ");
INSERT INTO mca_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Me akha' les qu' anipji' pakha' tata'aƚik'i Abraham'ik'i hikpa' wa'm iye pa'aj? Pe' profetas'ik'i naxju' iye pa'aj. ¿Ƚek pakha' ƚumtitax qu' akha'ye'?— ");
INSERT INTO mca_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ha' Jesús qa yeku'ƚ: —Qu' yakha'ye' ƚetax yite'm qu' heniwqinhettaxji', pa'qu' yiwqiyejeji ham weju'ƚi'ij. Na' Tata hik nakha' tsiwqinhetji', hik nakha' ekheweli'ƚ ƚit'iƚijets: “Pakha'an hik pakha' inqe Dios.” ");
INSERT INTO mca_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Qa ekheweli'ƚ qa nite'ƚe ƚenikfe'li'ƚets nakha'an, qa yakha'ƚe qa tsikfe'letsha nakha'an. Qa qu' hit'ijets qu' nite' netsikfe'le'ets, yakha' hats ye'jtitsaxƚe in ejunyejeyi'ƚek. Qa tsikfe'lƚe'ets nakha'an ma' qa heik'enik'iha kekhewe' ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kakha' aqwa'maxi'ƚik'i Abraham'ik'i qi in ƚe'wisi'mkii in nikfe'lets qu' ni'wen hatse' kakha' yeqe neƚu. Qa hats yi'wen, ma' qa qi'ija in ƚe'wisi'mkiiha.— ");
INSERT INTO mca_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Qa hik ta'ƚijupi' he' judiol in yit'ijets ha' Jesús: —Mente' enek cincuenta (50) yamets eqe'ninqapits, ¿me qa ƚi'wen pa' Abraham'ik'i?— ");
INSERT INTO mca_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ha' Jesús qa yit'ijets: —Yijaa'ija aka' hit'iƚij ewets, in mexe nite' nekfik'i ka' Abraham'ik'i, yakha' tsa'l.— ");
INSERT INTO mca_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hekhewe'en qa t'eku'mtaxi' he' utel qu' nenjele'ejkii, qa wanat'inƚekii aje'eƚ ha' Jesús, ma' qa ikik'uifik'i ke' qi witlijtsitjii. ");
INSERT INTO mca_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hakha' neki'kii ha' Jesús, qa yi'wen ha' ewi'ƚ jukhew, hayiits ta'ƚij ji'teje'm wittawe'j in puk'al. ");
INSERT INTO mca_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","He' ƚ'ijatshenhei qa nifaakanij: —Rabí (Maestro), ¿inhats'ek in ta'ƚij ji'teje'm wittawe'j in puk'al ha'ne jukhew? ¿Me ta'ƚets qu' uƚ'etse' pe' ƚ'alhei? ¿Me i'nƚi'i qu' ƚakha' ye'ƚe qu' uƚ'axe'?— ");
INSERT INTO mca_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ha' Jesús qa yeku'ƚ: —Nite' ta'ƚets hane'en qu' uƚ'axe', qa nite' ta'ƚets iye pe' ƚ'alhei qu' uƚ'etse', qe ta'ƚets yijat'ij hane'en in puk'alij qe qa' ne'twenhetiiji'teje'm pakha' yisu'un na' Dios qu' nanaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Inekhewel jit'ithayiki' pekhewe' yisu'un nakha' ts'ukinju' qu' ji'nt'ithayiki in mexe neƚukii, qe na' naja'x in nam qa hats ham pa'qu' net'ithayii. ");
INSERT INTO mca_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yakha' in mexe ha'nipji' ha'ne sehe', yakha' ƚefetitjiiyij ha'ne sehe' ipji'.— ");
INSERT INTO mca_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","In yili'ij ekewe'en in yit'ij, ma' qa tek'iyiju' ha' sehe' qa ke' ƚaq'astalii qa yaqasja'ajji'kii ka' sehe'. Ma' qa yilinipji' he' ƚotoi ha' puk'al. ");
INSERT INTO mca_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma' qa yit'ijets: —Ma'ai qu' matanaxtapulijji' na' ƚajakju' ƚa's ƚii Siloé.— (Siloé ikji' “wit'ukinek”.) Ha' puk'al qa ik qa yamii qa watanaxtapulijji' ma' qa in hats tepilik'ui qa hats yi'wenkii. ");
INSERT INTO mca_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma' qa hik ta'ƚijupi' hekhewe' metitsi'm ke' ƚetsi' qa hekhewe' yi'wenji'ijkii qa iyinji'ijkii, qa yit'ijju': —¿Me nite' hik ha'ne ha' i'nƚe'kji' ha' wit'ikheyi'j qa iyinji'ijkii?— ");
INSERT INTO mca_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Qa uja'x he' yit'ij: —Hik nakha'.— Qa hekhewep qa yit'ijju'ek: —Tujtseika', hikƚe ƚunye'jtax.— Qa ha' puk'altax, qa yit'ij: —Ehe, hik yakhaa'ija.— ");
INSERT INTO mca_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma' qa nifaakan: —¿Pa'n ƚunye'j in ƚi'wenkii?— ");
INSERT INTO mca_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Qa yeku'ƚ hakha'an: —Hakha' jukhew ƚiite' Jesús ke' ƚaq'astalii yaqasja'ajji'kii ha' sehe' qa yilinipji' ene' yitoi, qa yit'ij yiwets: “Ma'aiju' na' ƚajakju' ƚa's ƚii Siloé qa matanaxtapulijji'.” Qa hak qa tsamiiju' qa hatanaxtapuli'jji' ma' qa hats hi'wenkii hane'ej.— ");
INSERT INTO mca_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Qa nifaakanij iye: —¿Pa'n i'ni' hakha'an?— Qa yit'ijiju'ƚ: —Axe'm, nite' tsikfe'lets.— ");
INSERT INTO mca_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Qa hekhewe'en qa' yeka'xii hekhewe' fariseol hakha' puk'altax. ");
INSERT INTO mca_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Qa hik kakha' ka' neƚuji' witwapiihijiitax (sábado) ha' Jesús in yaqasja'ajji' ke' ƚaq'astalii ka' sehe' qa yilinipji' he' ƚotoi ha' puk'altax qa yi'wenkii. ");
INSERT INTO mca_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma' qa he' fariseol qa nifaakankii iye: —¿Pa'n ƚunye'jkiiha in hats ƚi'wenkii?— Qa yeku'ƚ hakha'an: —Yilinipji' ene' yitoi ka' oƚoq'oi qa hatanaxtapuli'j ma' qa hane'ej qa hats hi'wenkii.— ");
INSERT INTO mca_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Qa hik ta'ƚijupi' in yit'ijju' hekhewe' uja'x he' fariseol: —Hakha' jukhew nite' ta'ƚii pa' Dios, qe nite' yiwqinhetji' ka' neƚu witwapiihijiitax.— Qa uja'x he' yit'ijju'ek: —¿Me ƚeke' pakha' qu' uƚ'axe' jukhewe' qu' naqsiijkii ekewe' ham ƚunye'ji'iju'ƚ?— Ma' qa nite' ƚ'anyejeyij wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","He' fariseol qa wapilijets iye pa'aj in nifaakan iye ha' puk'altax: —Hakha' ne'wenkitkii ¿pa'n ƚumti qu' ƚunye'je' hakha'an?— Qa yeku'ƚ: —Hakha'an ewi'ƚ profeta.— ");
INSERT INTO mca_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma' qa he' judiol qa hats yeqeku'uj pa'aj hakha'an qu' puk'ale'tax pa'aj, qa i'nk'aƚe qa' ni'wenkii iye. Qa inq'ukinii iye pa'aj qu' nanamii pekhewe' ƚ'alhei hakha' puk'altax. ");
INSERT INTO mca_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Qa nifaakanij: —¿Me oqwo'mehe'eƚha hane'en? ¿Me yijaa'ija qu' hayiits nata'ƚij ji'teje'm wittawe'j in puk'altax pa'aj? ¿Qa pa'n ƚunye'j hane'ej in hats yi'wenkii?— ");
INSERT INTO mca_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pe' ƚ'alhei qa yeku'ƚ pa'aj: —Tsikfe'li'ƚets in hik nakhaa'ija hakha' ya'si'ƚ, qa ta'ƚij ji'teje'm wittawe'j in puk'altax, ");
INSERT INTO mca_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","qa nite'ƚe tsikfe'li'ƚets pa' ƚunye'jkii in hats yi'wenkii, nite' tsikfe'li'ƚets iye pa' yi'wenkitkii. Anfaakaani'ƚijha nakha'an. Hats ƚek yamets ƚilanye'j, ƚakha' qu' nenfeli'ƚ e'mik'i yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pe' ƚ'alhei yit'ij pa'aj aka'an qe nijiweyiju'ƚ hekhewe' judiol, qe hekhewe' judiol hats yit'ijets qu' niwumik'uifik'i hekhewe' ƚe'lijtsitjiyits pakha' qu' netetfelij qu' nit'ijets ha' Jesús qu' hik hakha'ye' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Qa hik ta'ƚijupi' in yit'ijets he' ƚ'alhei: —Anfaakani'ƚha nakha'an. Hats ƚek yamets ƚilanye'j.— ");
INSERT INTO mca_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","He' judiol qa ewi'ƚij iye in taya'yii hakha' jukhew puk'altax, qa yit'ijets: —Iwqinhet yijat'ij pa' Dios, qe yekheweli'ƚ tsikfe'li'ƚets ha' jukhew in uƚ'ax pa' yaqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hakha'an qa yeku'ƚ pa'aj: —Qu' uƚ'axe' pakha' yaqsiijkii, nite' tsikfe'lets. Ewi'ƚƚe aka' tsikfe'lets: yakha' in mexe yepuk'altax qa hane'ej qa hats hi'wenkii.— ");
INSERT INTO mca_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma' qa yit'ijets iye hekhewe'en: —¿Pa'n ƚeqfenye'j ej? ¿Pa'n ƚeqfenye'jij in ne'wenkitkii?— ");
INSERT INTO mca_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Qa yeku'ƚ iye hakha'an: —Hats inek k'efeltaxi'ƚi'm qa nite'ƚe ƚ'eni'ƚji' ekfiyi'ƚ. ¿Inhats'ek in ƚisu'uni'ƚ qu' hiyeketij iye qu' hit'iƚij ewets? ¿Ye' me ekhewepi'ƚ iye ƚisu'uni'ƚ qu' ƚ'ijatshenheyi'iƚ ej?— ");
INSERT INTO mca_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hekhewe'en qa nayu'um, qa yit'ijets: —Akha' ƚijayan hakha' jukhew qa yekhewelƚi'iƚ qa hijayani'ƚek pa' Moises'ik'i. ");
INSERT INTO mca_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yekheweli'ƚ tsikfe'li'ƚets pa' Dios in tafaakate'yi'ƚkii pa'aj pa' Moises'ik'i, qa hakha'ƚe jukhew qa nite' tsikfe'li'ƚets pa'n ta'ƚji'.— ");
INSERT INTO mca_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Qa yeku'ƚ iye ha' jukhew: —¡Peyijaat'ij aka'an in tsitjuƚaxijpha'm, in ekheweli'ƚ nite' ƚenikfe'li'ƚets pa' ta'ƚi', ƚa'mek qa tsi'wenkitkii hakha'an! ");
INSERT INTO mca_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jinikfe'letsha pa' Dios in nite' t'eku'miju'ƚ pe' uƚ'ets, qa pakha'ƚe qu' ne'nijiweyiju'ƚ pa' Dios qa yaqsiijkii pa'qu' nisu'un pakha'an, ma' qa hik ha'ne yijat'ij in t'eku'miju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","In ipƚu'uk'i ek in i'nk'aa'ija pa'aj ha'ne sehe' qa ham pa'qu' nek'impi'ye'ej pakha' qu' ni'wenkitkii pa'qu' nata'ƚij ji'teje'm wittawe'j qu' puk'ale'. ");
INSERT INTO mca_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hakha' jukhew qu' nite' nata'ƚi'ii pa' Dios, qekha hamtax ƚeke'ye' qu' naqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hekhewe'en qa yeku'ƚ, qa yit'ijets: —Akha', in topo' ej pa' uƚ'ax in ƚenekfik'i pa'aj, ¿me qa ƚets'ijatshentaxi'ƚ?— Ma' qa yiwu'mfik'i. ");
INSERT INTO mca_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Qa i'ye'ej ha' Jesús in tewu'mhitiifik'i ha' puk'altax, ma' qa wo'oikii qa yi'wen, qa nifaakan: —¿Me nite' ƚeqeku' na' Ƚa's na' Jukhew?— ");
INSERT INTO mca_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Qa yeku'ƚ hakha'an: —Jukhew, ¿pa'n ƚii pakha'an, hats'inha yakha' qa' nite' heqeku'ye' pakha'an?— ");
INSERT INTO mca_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Qa yeku'ƚ ha' Jesús: —Hats ƚi'wen, ha'ne hane'ej ƚ'afaakateyi'ƚ hik ha'ne.— ");
INSERT INTO mca_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ha' jukhew qa yit'ijets: —Nite' k'eqeku', Yatsat'axyij.— Ma' qa wonokok'enju'. ");
INSERT INTO mca_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ha' Jesús qa yit'ij: —Yakha' tsametsju' ha'ne sehe' ipji' qe qa' hujtse wetju'ƚ, hats'inha nekhewe' puk'aletstax qa' ni'wen wetju'ƚ, qa nekhewe' yi'wentax wetju'ƚ qa' puk'aletsi'ij.— ");
INSERT INTO mca_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Uja'x hekhewe' fariseol i'nji'teje'm yepi'ye' ej ha' Jesús in yit'ij aka'an, qa yit'ijets: —¿Me yekheweli'ƚ iye qu' yepuk'aletsi'iƚ?— ");
INSERT INTO mca_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ha' Jesús qa yeku'ƚ: —Qek e'puk'aletsi'iƚ qekha hamtax ewuƚ'etsi'iƚ, qa ƚi'tƚi'iƚijju' “Hi'weni'ƚ wetju'ƚ” ma' qa pa' ewuƚ'axitsi'ƚ qa amaneyi'ƚ etji'.— ");
INSERT INTO mca_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nite' nuyi'ii na' ƚeji' na' ƚenqetsitax ne' kots'etets qa tujtseika' uyi'teje'm, pakha'an ejtenhetsaxƚe qa eqitkamhitsax iye. ");
INSERT INTO mca_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Qa pakha'ƚe qu' nuyii yijat'ij pa'qu' ƚeji'ye' qa hik ha'ne yijat'ij pakha' kots'etets yejeƚ. ");
INSERT INTO mca_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pakha' yejeƚ pa' ƚeji' qa yit'iji'mii qhof, ma' qa pa' kots'etets yejeƚ qa taya'yii yiyinenik'i pe' ƚiyitsƚe wetju'ƚ, qa pe' kots'etets qa nikfe'lik'i pa' ƚ'a'x pakha'an, ma' qa pakha'an qa yojo'ok'oifik'i pe' kots'etets. ");
INSERT INTO mca_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Qa in hats yot'axfik'i pe' yatsat'etsij, ma' qa yojo'ok'oi, qa pe' kots'etets qa yijayanpha'm, qe nikfe'lik'i ƚ'anye'j. ");
INSERT INTO mca_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Qa pakhape'ƚetax qu' nojotaxik'ui, nite' yijayan, ilatik'uikii, qe nite' nikfe'lik'i pa'qu' ƚ'anye'je'.— ");
INSERT INTO mca_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aka'an kakha' yejeyumtshenijupi' ha' Jesús tistaxij hekhewe'en, qa nite'ƚe nikfe'lik'i pakha' ikji'ha. ");
INSERT INTO mca_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ma' qa ha' Jesús qa yit'ijets iye: —Yijaa'ija aka' qu' hit'iƚij ewets, yakha' ƚeji' na' ƚentsitax ne' kots'etets. ");
INSERT INTO mca_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Week nekhewe' nojo in namtax ejtenhetsitsƚe qa eqitkamhitsitsƚe iye, qa nekhewe'ƚe kots'etets qa nite' tek'enets. ");
INSERT INTO mca_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yakha' ƚeji' na' ƚentsitax, pakha' qu' nuyii ha'ne ƚeji' qa' iƚa'xe'. Qa' hik ƚunye'je' ne'ej kots'etax in uiteje'm qa uifik'i iye qa yi'wen na'aj jup'elket. ");
INSERT INTO mca_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na'aj ejtenhetsi'l in nam ewi'ƚƚe in wo'oi qu' net'ejtenkii, qu' netqek'ui, qa qu' nineqwuƚ'enhetju' iye. Qa yakha' in tsam qe qa' nana'li'ƚ e'm pe'qu' iƚaxitsi'iƚ, qa' qitsi'iƚ e'mha iye. ");
INSERT INTO mca_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yakha' qi ƚe'wis kots'etets ƚenilayets. Ha'ne qi ƚe'wis kots'etets ƚenilayets nite' yiwejin ne' kots'etets qa wa'mifi. ");
INSERT INTO mca_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Qa pakha'ƚe qu' net'ithayiiƚi'ipji' pa'qu' ƚaja'ye', qa nite' ƚenilayets pe' kots'etets, nite' hik pakha' pa' yatsat'axij pe' kots'etets, ma' qa in yi'weniju'ƚ pa' wowo, qa yiwu'mƚi'i pe' kots'etets qa ilat. Ma' qa pa' wowo qa t'ilit'ets pe' kots'etets qa yak'esa'xkii iye. ");
INSERT INTO mca_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pakha'an in ilat qe t'ithayiiƚetaxiikii ƚaja'ye', qa nekhewe'ƚe kots'etets qa nite' nekewet'ets yiwejinƚe. ");
INSERT INTO mca_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yakha' qi ƚe'wis kots'etets ƚenilayets, qa tsikfe'lets nekhewe' tsatsat'etsij kots'etets qa ƚekhewel qa nikfe'lji'ij yiwetsek. ");
INSERT INTO mca_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Qa hik ƚunye'jija aka'an na' Tata in nikfe'l yiwets, qa yakha' qa tsikfe'ljeetsek na' Tata. Qa yakha' qu' hawa'mifi nekhewe' kots'etets qa' iƚiye'. ");
INSERT INTO mca_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na'l ye'm iye nekhewep kots'etets nite' ha'ne i'ni'in. Qa hisu'un qu' henka'x iye nekhewe'en. Nekhewe'en yepi'ye' hatse' na' ya'x qa ewi'ƚ hatse' pa'qu' na'ni' qa ewi'ƚƚe iye pa'qu' ƚenilayets'e. ");
INSERT INTO mca_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Qa hik ta'ƚijupi' na' Tata in qi in tsisu'un, qe yakha' he'yihinij na' yiƚa'x, qa' ink'aƚe qa' hepilet iye. ");
INSERT INTO mca_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hamtax pa'qu' netsitka'mij na' yiƚa'x, qe yakha'ƚe in ta'ƚ yiwets qa he'yihinij. Yakha' heyesti'yij na' yit'unha'xijup qu' he'yihinij na' yiƚa'x, qa heyesti'yij iye na' yit'unha'xijup qu' hepilet iye, qe hik aka' ƚ'anye'j yiwets na' Tata.— ");
INSERT INTO mca_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","He' judiol in yepi'ye' ek'i ekewe' wi'tlijei, ma' qa hats yeqet'etsju'kii nite' ƚ'anyejeyij wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Olots hekhewe' yit'ijju': —I'nji' pa' ewi'ƚ inwo'met nakha'an qa hats nite' teik'uneikii. ¿Inhats'ek in ƚ'ek'eni'ƚets?— ");
INSERT INTO mca_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Qa hekhewep qa yit'ijju'ek: —Ekewe'en nite' ƚe'lijei pa'qu' ewi'ƚe' qu' na'nji' pa'qu' inwo'met'e. ¿Me ƚeke' pa'qu' ewi'ƚ inwo'met'e qu' ni'wenkitkii ne' puk'alets?— ");
INSERT INTO mca_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hik kekhewe' ke' neƚutsji' yamets kekhewe' ƚe'sits neƚuts tajamtaxti'yik'i kekhe' qi witlijtsitjii. Lop ƚahats'ij ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Qa ha' Jesús yijalki'si'kii ke' qi witlijtsitjiyifi ha' ƚeq'eneƚeya'x ts'eewe'efi ƚii Salomón. ");
INSERT INTO mca_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma' qa hekhewe' judiol qa k'ooyijji' iye, qa yit'ijets: —¿Pa'n ipƚu'uk'ui qu' yape metetfeli'ƚ ye'mha? Qu' hik akha'ye' pa' Cristo, yape, eqetheni'ƚ ye'mkiiha.— ");
INSERT INTO mca_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ha' Jesús qa yeku'ƚ: —Hats inek hetetfeltax qa ƚesqeku'ƚi'iƚ, kekhewe' wekwek in haqsiijkii hit'iji' aka' ƚiiji' na' Tata, hik kekhewe' tsifeltaxkii. ");
INSERT INTO mca_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Qa ekhewelƚi'iƚ qa ƚesqeku'ƚi'iƚ qe nite' nekhewe' tsatsat'etsij kots'etets. ");
INSERT INTO mca_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ne' tsatsat'etsij kots'etets nikfe'lik'i yanye'j, qa yakha' qa tsikfe'ljeetsek iye qa tsijayanija. ");
INSERT INTO mca_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma' qa yakha' qa' hetisij na' ƚiƚa'x nite' yili'ij qa nite' ƚeke' qu' namii pakha' fe't, qa ham pakha' qu' netsitka'mtaxij ha'ne yikoiji'. ");
INSERT INTO mca_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na' Tata hik nakha' tseƚisij enewe'en, nakha'an week t'anipji', qa ham iye pakha' qu' nenitka'mtaxij na' ƚokoiji' na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na' Tata qa yakha' ewi'ƚ aka' yijunyejeyi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","He' judiol qa t'eku'metsju'kii iye he' utel, qe neqje'lenheyu'taxijkii iye. ");
INSERT INTO mca_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Qa ha' Jesús qa yit'ijji'ju': —Yakha' k'ethini'ƚij kekhewe' olots haqsi'jijkii ƚe'sits ta'ƚii na' Tata. ¿Qa pa'n ƚunye'j kekhewe'en pa' ta'ƚets in ƚeneqje'lenheyu'uƚ yijkii ne' utel?— ");
INSERT INTO mca_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","He' judiol qa yeku'ƚ qa yit'ij: —Nite' ƚ'ejelaxti'yipji'kii pa'qu' aqsiijkii qu' ƚe'wise', qe ƚ'ejelaxti'yipji'kii yijat'ij in uƚ'etsik'i ke' e'lijeyets pa' Dios, qa ta'ƚijupi' iye in akha' e'jukhewƚe qa ƚittaxijets qu' o' Diose'.— ");
INSERT INTO mca_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ha' Jesús qa yeku'ƚ: —¿Me nite' yit'ij kakha' we'nika'ajji' eqe leyi'ƚ: “Yakha' hit'ij: ‘Ekheweli'ƚ o'diositsi'ƚ’”? ");
INSERT INTO mca_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na' Dios in yit'ijets qu' diositse' pekhewe' tisij ke' ƚe'lijei qa kekhewe' we'nika'ajji' qa ham pa'qu' ƚeke'ye' qu' nenwu'mpha'm, ");
INSERT INTO mca_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿me ha'ne t'eku'miiji' na' Dios qa nukinetsju' ha'ne sehe' epji' pa' ƚit'iƚijets: “Uƚ'etsik'i ke' e'lijeyets pa' Dios” qe yakha' hit'ij: yakha' Ƚaa'sija na' Dios? ");
INSERT INTO mca_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Qu' nite' haqsi'ji'ijkii kekhewe' ƚ'ithayijkitits na' Tata, qa' hasu'uj ek'eni'ƚ yiwets, esqeku'uƚ. ");
INSERT INTO mca_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Qa qu' haqsi'jƚi'ijkii, inye'jƚu' qu' esqeku'taxi'ƚ, qa' hasu'ujƚe eqeku'uƚ kekhewe' haqsiijkii, hats'inha qu' enikfe'li'ƚetsha qa umti'iƚha iye na' Tata in i'nyit ji'teje'm qa yakha' qa ha'nji'ij ji'teje'mek na' Tata.— ");
INSERT INTO mca_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Qa hik ta'ƚijupi' hekhewe'en in ewi'ƚij iye in yisu'untax qu' net'eku'mi', ha' Jesús qa aje'eƚƚe ilatik'ui iye he' ƚokoyei hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma' qa ikiiteje'm iye ƚajaika' ha' haqqi' Jordán, hakha' yojo in wenqimpulijini' pa'aj ka' Juan, qa hikha' qa amani'. ");
INSERT INTO mca_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Olots hekhewe' nekii ha' i'ni', qa yit'ijju': —In yemjeetax kakha' Juan Bautista in nite' yaqsi'jtaxijkii pa'qu' ham ƚunye'ji'iju'ƚ, ƚa'mek qa week kekhewe' yit'ij t'ejuyets ha'ne jukhew qa yijaalija.— ");
INSERT INTO mca_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma' qa olots iye he' tek'enets nite' yeqeku' ha' Jesús hakha' i'ni'. ");
INSERT INTO mca_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ewi'ƚ ha' jukhew wanqaats'e' ƚii Lázaro, Betania ƚeiƚe', ƚetset ke' María qa ke' ƚejefeki' (ƚekuti') Marta. ");
INSERT INTO mca_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ke' María ha' ƚejefe (ƚek'inij) Lázaro qi in wanqaats'e', hikke' yatsi'yipji' ka' ewjisii he' ƚef'iyei ha' Yatsat'ax'inij qa nili'jijju' iye he' ƚ'ewkujits. ");
INSERT INTO mca_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Enewe' wetsjuk witk'injayek qa inq'ukinii qu' netfelhiti'yi'm ha' Jesús qa' nit'ijets: —Yatsat'axyij, nakha' qi ƚisu'un ejuwaika' qi in wanqaats'e'.— ");
INSERT INTO mca_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ha' Jesús in impi'ye'ej qa yit'ij: —Hane'en ha'ne witaatshek nite' t'ejuyets pa' witwamhi', qe t'ejuyets yijat'ij qu' neniwqinhetji' na' Dios, hats'inha ha'ne Ƚa's na' Dios qa' neniwqinhetji' qu' nata'ƚets nakha' witaatshek.— ");
INSERT INTO mca_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Qa ha' Jesús yisu'un ke' Marta qa ke' ƚejefeki' (ƚek'inja') qa ha' Lázaro iye. ");
INSERT INTO mca_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","In tefelhiti'yi'm in qi in wanqaats'e' ha' Lázaro, qa hik ta'ƚijupi' mexe wetsjuk ke' neƚuts in amaneyiju' iye hakha' i'ni'. ");
INSERT INTO mca_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma' qa i'nk'aƚe qa yit'ijets he' ƚ'ijatshenhei: —Yape jiwapilii iye ha' Judea.— ");
INSERT INTO mca_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Qa he' ƚ'ijatshenhei qa yit'ijets: —Rabí (Maestro), mexe ink'a'ak'i he' judiol neqje'lenheyu'tax ejkii ke' utel qu' nalan. ¿Me qa' amii iye hane'ej?— ");
INSERT INTO mca_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ha' Jesús qa yeku'ƚ: —¿Me nite' doceji' (12) ne'ej hora na'aj neƚu? Pa'qu' ewi'ƚe' qu' nijalki'sji'kii pa'qu' neƚuye' ham yilani'ifi, qe mexe yi'wenji'kii na' na'lkii ha'ne sehe' epji'. ");
INSERT INTO mca_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Qa pakha'ƚe qu' nijalki'sji'kii naja'x qa yilanifi pe'ye', qe hats nite' i'nji'teje'm na' na'lkii.— ");
INSERT INTO mca_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yit'ij aka'an, qa i'nk'aƚe qa yit'ij iye: —Hakha' injuwaika' Lázaro hats imaa'ija, qa' natsamii qa' henijt'otshen.— ");
INSERT INTO mca_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma' qa he' ƚ'ijatshenhei qa yit'ijets: —Yatsat'axyij, hakha'an in hats ima', ikji' in hats wat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Qa iyetƚi'ij ha' Jesús ka' Lazaro'ik'i in hats wa'm pa'aj, qa hekhewe'ƚe ƚ'ijatshenhei qa yumtitax qu' nit'ijets na'aj ima'ija. ");
INSERT INTO mca_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ma' qa ha' Jesús, qa hik ta'ƚijupi' in yatsathenkeetik'iha in nifeli'm: —Ka' Lazaro'ik'i hats wa'm. ");
INSERT INTO mca_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ƚe'wis ye'mkii in nite' ha'nijup, qe hik aka' kakha' les in ƚe'wisju' qu' net'ejuyi'ƚ ewets, hats'inha qa' les nite' inqekuyi'iƚ. Yape ju'ukii hakha' i'ni' kakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma' qa ha' Tomás ƚenqii iye wetsjukji' qa yit'ijets hekhewep iye. —Yape jiyamii hats'inha qa' je'weeke' qu' jinanaxi'ƚju' nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","In hats yamets, ma' qa ha' Jesús qa impi'ye'ej in hats ikwetju'ƚ (4) pe' neƚutsik'i in i'nifi ke' ƚesehek ka' Lazaro'ik'i. ");
INSERT INTO mca_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ha' Betania ipƚu'umets ha' Jerusalén wetshetk'ewi'ƚ kilómetro ets. ");
INSERT INTO mca_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Olots he' judiol namii ke' ƚetsi' ke' Marta qa ke' María, qe qa' nisimetsinij pakha' ƚawamhijii kakha' ƚejefe'ek'i. ");
INSERT INTO mca_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ke' Marta in impi'ye'ej ha' Jesús in hats k'esiyu'ets ha' witset qa nejelu'ui. Qa kikhe'ƚe María qa amani' ke' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ke' Marta qa yit'ijets ha' Jesús: —Yatsat'axyij, qek ni'i' hane'e'in qekhante' nawa'metax ka' yejefe'ek'i, ");
INSERT INTO mca_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","qa tsikfe'lƚe'ets hane'ej in week pa'qu' iyinijets pa' Dios, qa pa' Dios qa' neƚisij.— ");
INSERT INTO mca_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ha' Jesús qa yeku'ƚ: —Ha' ejefe iƚa'x iye hatse'.— ");
INSERT INTO mca_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Qa ke' Marta qa yeku'ƚ: —Ehe, tsikfe'lets in iƚa'x iye hatse' qu' iƚiye'tax iye week pe' hats naxtaxju' qu' namtaxets pa' neƚuji' qu' hats ƚ'aka'the' ye'ƚe hatse'.— ");
INSERT INTO mca_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ha' Jesús qa yit'ijets: —Yakha' ƚiƚijii pe' naxju' qa yakha' iye witiƚa'x nite' yili'ij. Pakha' qu' nite' nesqeku'ye', yemjeetax qu' nawa'mtax qa' iƚa'xe' iye. ");
INSERT INTO mca_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Qa week pakha' qu' mexe iƚa'xe' qa nite' tseqeku', ma' qa' nite' ƚ'anuuyi'i qu' nawa'm hatse'. ¿Me nite' ƚeqeku'uk'i aka'an?— ");
INSERT INTO mca_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Qa yeku'ƚ kikhe'en qa yit'ij: —Ehe, Yatsat'axyij, yakha' nite' heqeku'uk'i in hik akhaa'ija pa' Cristo Ƚa's pa' Dios pakha' neketsju' ha'ne sehe' ipji'.— ");
INSERT INTO mca_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","In yili'ij in yit'ij ke' Marta aka'an, ma' qa yiihetii ke' ƚejefeki' María qa tanqat'inijets in yit'ijets: —Ha' Maestro hats ha'ne i'ni' qa iyin ei.— ");
INSERT INTO mca_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","In yepi'ye' ek'i ke' María aka'an qa aje'eƚ niipha'm qa ikii hakha' i'ni' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Qe ha' Jesús mente' uitaxetsji'ha ha' witset ƚa's, qe mexe amantaxi' hakha' wetweni'ƚi' ke' Marta. ");
INSERT INTO mca_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","He' judiol he' i'nijup kikhe'en ke' ƚetsi'ii yisimetsintax, hekhewe'en in yi'wen ke' María in ts'enpha'm qa ikfik'i, ma' qa yijayanfik'i, yumtitax qu' nakii ke' ƚesehek qu' nayinju' iye. ");
INSERT INTO mca_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ke' María in yamii hakha' i'ni' ha' Jesús, ma' qa in yi'wen qa wetjele'efi ƚef'iyeyiiju', qa yit'ij: —Yatsat'axyij, qek ni'i' hane'e'in qekhante' nawa'metax ka' yejefe'ek'i.— ");
INSERT INTO mca_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ha' Jesús in yi'wen in qi in ip ke' María qa hekhewe' iye judiol ƚijts'eyek, ma' qa qi in yoksi'wen qa ika'me'tji'ij kiyek iye. ");
INSERT INTO mca_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Qa yit'ijets: —¿Pa'n ƚ'eniƚi'?— Hekhewe'en qa yit'ijets: —Te'ƚun qa' i'wen, Yatsat'axyij.— ");
INSERT INTO mca_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ha' Jesús qa ip. ");
INSERT INTO mca_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Qa hik ta'ƚijupi' he' judiol in yit'ijju': —¡Jeƚ qeku'ni'ƚju' hayits qa qi in yisu'untax pa'aj!— ");
INSERT INTO mca_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Qa uja'x he' yit'ijju'ek: —Hane'en hik ha'ne hakha' yi'wenkitkii ha' puk'altax. ¿Pa'n ƚahats in nite' ƚeke' qu' naqsiijkii ka' Lazaro'ik'i qu' nite' nawa'me'?— ");
INSERT INTO mca_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ha' Jesús qa ewi'ƚij iye in qi in yoksi'wen pa' ƚunye'jkii in hats meti'm ke' ƚesehek. Ke' ƚesehek yikumunhetje'm ke' utek qa ha' ƚit'o qa ute iye. ");
INSERT INTO mca_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ha' Jesús qa yit'ij: —¡Iwu'mi'ƚ ne' ute ƚeji'ij!— Qa ke' Marta ƚejefeki' ka' wa'm qa yit'ijets: —Yatsat'axyij, hats qi qu' ne'nisjut qe hats ikwetju'ƚ (4) ke' neƚutsik'i in i'nji'.— ");
INSERT INTO mca_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ha' Jesús qa yit'ijets: —¿Me nite' hit'ij ewets, qu' nite' esqeku'ye' qa' i'wen na' qi ƚesa'x na' Dios?— ");
INSERT INTO mca_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma' qa wenit'ij qhof ke' ute ƚit'o'oj. Ha' Jesús qa yejeƚetspha'm na' wa's, qa yit'ij: —Tata, hit'ij ewetspha'm qi in ƚe'wisij qe ƚ'eku'mij yiju'ƚ kakha' k'iyinij ewets. ");
INSERT INTO mca_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yakha' tsikfe'ltaxets in ƚ'eku'mij yiju'ƚ na'aj k'iyinij ewets, qa hitƚi'ij aka'an qe ta'ƚets enewe' olots tseqewuk'un, hats'inha qu' nite' neqekuyi'ik'i in akha' ƚets'ukinju'.— ");
INSERT INTO mca_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","In yili'ij aka'an in yit'ij, qa yit'unhetik'i in iyet: —¡Lázaro, enekik'uifik'i na' ƚa'ni'!— ");
INSERT INTO mca_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Qa ka' wa'mtax qa nekfik'i. Ke' ƚokoyei qa ke' ƚef'iyei iye wetjuphe'ƚij ke' penyilots, qa ka' ƚeju's qa wet-sifinijipji' ka' penyilo ƚa's. Ha' Jesús qa yit'ij: —Enit'iƚijipji' ne' wetjupheƚij qa' ƚeke'ye' qu' nak.— ");
INSERT INTO mca_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Qa aka'an in ta'ƚets qa olots he' judiol hekhewe' namii qu' ni'wen ke' María, in yi'wen aka' yaqsiijkii ha' Jesús, ma' qa tek'enets nite' yeqeku' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Qa na'lƚe he' uja'x hekhewe'en qa yamii he' fariseol qa nenfeli'mik'i kakha' yaqsiijkii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma' qa he' tenek'enhe'yipji' he' pa'il qa he' fariseol iye qa not'axij wetju'ƚ in uja'xek pe' week Junta Suprema qa yit'ijju': —¿Pa'n qu' ineqfenyejeye' inwek? Hakha' jukhew hats olots pe' yaqsiijkii ham ƚunyejeyi'iju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Qe qu' jintewejinƚe, qa' week netk'enets hatse' hakha'an. Ma' qa ne' oq'opheƚinetsilets Roma ƚeiƚets qa' nanam qa' niwuƚ'enhetju' ene' qi i'nlijtsitjii qa' weeke' iye ha'ne initset qu' niwuƚ'enhetju'.— ");
INSERT INTO mca_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hakha' ewi'ƚ hekhewe'en, ƚii Caifás, hik hakha' qiji' pa'il ƚatata kakha' ininqa'pji', qa yit'ijji'ju': —Ekheweli'ƚ ham ƚenikfe'li'iƚets, ");
INSERT INTO mca_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","qa nite' i'nji' iye pe'qu' aqjamtikineyejeyi'iƚkii in les in ƚe'wisju' qu' ewi'ƚe' pa'qu' jukhewe' qu' nawa'mifi ha'ne witset, qa' hasu'uje' qu' weeke' qu' nanaxju' ha'ne witset.— ");
INSERT INTO mca_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Qa ha' Caifás, qa nite'ƚe qu' ƚakha' ye'ƚe qu' nata'ƚets in yit'ij aka'an, qe in qiji' pa'il ƚatata kakha' ininqa'pji', ma' qa pa' Dios qa tisij qu' nit'ij aka'an qu' aje'eƚ nenfel ha' Jesús qu' nawa'mifi ha'ne witset. ");
INSERT INTO mca_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Qa nite' ewi'ƚƚe iye ha'ne witset qu' nawa'mifi, qe wa'mifi iye qu' ewi'ƚ neni' pe' week ƚelits pa' Dios pe' mexe yak'estaxkii. ");
INSERT INTO mca_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma' qa hik akaa'ijha in ta'ƚi' ka' neƚuji' in wo'oikii pa'qu' ƚeqfenyejeiyi'ij qu' ƚeke'ye' qu' nilan ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Qa hik ta'ƚijupi' ha' Jesús in hats nite' ƚeke' qu' nijalki'sji'kii qa' week ni'wen he' judiol. Ma' qa yamii ha' witset ƚii Efraín meti'm ha' ham i'ni'i'. Qa hikha' mexe i'ni'ƚi'kii he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma' qa hats k'esiyu'ets kakha' qi ƚeqe ƚe'wis neƚu ne' judiol ƚii Pascua. Qa olots he' pekhel ta'ƚji'kii namii aje'eƚ ha' Jerusalén qe qa' aje'eƚ naqsiijkii pekhewe' hats jutsiqax qu' naqsiijkii, hats'inha qu' ƚeke'ye' qu' na'nij ji'teje'm pa' ƚe'wis neƚu ƚii Pascua. ");
INSERT INTO mca_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma' qa teniwohoitaxiikii ha' Jesús, qa yifaakateji' pa'aj pekhewe'en in i'nifi ke' qi witlijtsitjii, qa yit'ijju': —¿Ƚekpa' qu' umti'iƚ? ¿Me qu' nite' nanami'ii ha'ne ƚe'wis neƚu?— ");
INSERT INTO mca_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","He' tenek'enhe'yij he' pa'il qa hekhewe' iye fariseol hayiits inaqyaji'ijji'ju' pakha' qu' nenikfe'lets pa'qu' na'ni' ha' Jesús qa' nenfeli'm hats'inha qu' nophe'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma' qa ha' Jesús, in mexe ewi'ƚ tatsai (6) neƚutsets qu' namets kakha' ƚe'wis neƚu Pascua, qa yamii iye ha' Betania. Hikha' ƚetset ha' Lázaro yiƚin ha' Jesús in hats wa'mtax. ");
INSERT INTO mca_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hik hakha'a' qa wanaqsiimiji'kii ka' ƚaq ha' Jesús. Qa ke' Marta qa yithayiki'iji' ka' ƚaq, qa hakha'ƚe Lázaro qa i'nji'teje'm hekhewe' i'nijupju'kii ha' mesa qa ƚekufets ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma' qa ke' María qa t'eku'mi' ka' ewjisii yamets trescientos cuarenta (340) gramos ka' ƚuk'eji' ta'ƚets ne'ej najkak ƚii nardo qa qi iye in inyetax, ma' qa yatsi'yi he' ƚef'iyei ha' Jesús qa in yili'ij ma' qa nili'jijju' he' ƚ'ewkujits yisƚatij he' ƚef'iyei ha' Jesús, qa weekij ha' ƚatawe'j ke' wititsi' in ikifi ka' ƚ'ewjisi' ka' ewjisii. ");
INSERT INTO mca_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma' qa ha' Judas Iscariote, hik hakha' iye i'ntaxji'teje'm he' doce (12) ƚ'ijatshenhei, hik hakha' t'ihinij hatse' ha' Jesús, qa yit'ij: ");
INSERT INTO mca_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Inhats'ek in nite' te'ninei yijat'ij kakha' ewjisii, uja'x yamtaxets pe' qek ƚaja'ye' trescientos (300) denarios ma' qekha netestiitaxij nekhewe' ham yiwq'axine'?— ");
INSERT INTO mca_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Qa nite' yit'ij aka'an qu' neƚ'ilaxets nekhewe' if'iljetsits, qe yit'ij yijat'ij aka'an qe ƚakha' ejtenhetsax qa in ƚakha' iye yaqsi'j kakha' ti'naj ƚ'astajii, qa hik kakha' ka' ta'ƚijetsju'kii kekhewe' yiwu'mƚekii ƚ'astayik'i. ");
INSERT INTO mca_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Qa ha' Jesús qa yit'ij: —Iwejinƚi'ij, qe qa' najilet aje'eƚ qu' net'ejuyets pa' neƚuji' qu' hayajkati'yik'ui. ");
INSERT INTO mca_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Qe enewe' if'iljetsits ham yiwq'axine' nite' hamitsi'ƚ ejup week ƚahatsiyij qu' nanali'ƚ ejup, qa yakha'ƚe qa nite' week ƚahatsiyij qu' e'tsweni'ƚ qu' ha'ni'ƚ ejup.— ");
INSERT INTO mca_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ma' qa hekhewe' olotsija judiol in nikfe'lets ha' Jesús in i'ni' ha' Betania, ma' qa namii, nite' ewi'ƚƚe in neqwenkeyu'uj ha' Jesús qe hakhap iye Lázaro in neqwenkeyu'uj iye, hikha' yiƚin ha' Jesús in hats wa'mtax hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma' qa hik ta'ƚijupi' he' tenek'enhe'yij he' pa'il in yijamti'ets iye pa'qu' ƚeqfenyejeyi'ij qu' nilan iye ha' Lázaro ");
INSERT INTO mca_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","qe ha' Lázaro hikha' ta'ƚets in olots pe' judiol yili'ijju' in tek'entaxets he' pa'il, ma' qa tek'enets nite' yeqeku' ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Qa kakhap neƚuikakii, hekhewe' olotsija namii kekhewe' ƚe'sits neƚuts, qa i'ye'ek'ui ha' Jesús qu' nanametsji'ha ha' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ma' qa yifekinik'i ke' ƚesejets he' omhetekui qa nejelu'ujiju'ƚ, qa taya'yijipji'kii: —¡Qi'ija in ƚe'wis! ¡Qi in ƚe'wis ha'ne namij ka' ƚii pa' Yatsat'ax'inij! Hane'en hik ha'ne pa' qi ƚatata ene' Israel.— ");
INSERT INTO mca_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ha' Jesús qa yi'wen ha' ewi'ƚ matikatax ƚa's mexe ham i'ni' ipji', ma' qa i'nipji', in ƚ'anyejeyek kekhewe' hats we'nika'ajji' pa'aj: ");
INSERT INTO mca_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—E'nijiweikitek witset Sión, jeƚ qeku'nek na' qi Atata'aƚ hats nami'ƚ ei i'nipji' na' matikatax ƚa's.— ");
INSERT INTO mca_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","In i'nk'a he' ƚ'ijatshenhei nite' nikfelik'iha ekewe' wekwek. Qa i'nk'aƚe ha' Jesús in wapiletspha'm iye na' wa's qa yijamti'ik'i ke' we'nika'ajji' pa'aj in hik hakha'ija t'ejuyets kekhewe'en, qa ƚekhewel iye t'ejuyets iye hekhewe'en in yaqsiimijkii ke' wekwek. ");
INSERT INTO mca_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Qa hik ƚunyejei iye hekhewe' yi'wenij ha' Jesús in taya'yetsji' ha' Lázaro ke' ƚesehekji' qa iƚa'x iye in hats wa'mtax, hekhewe'en qa nifelji'ijkii iye aka'an. ");
INSERT INTO mca_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Qa hik ta'ƚijupi' in olotsija he' nejelu'ujuƚ ha' Jesús, qe impi'yelij hakha'an in hik hakha' yaqsiijkii aka' ewi'ƚ ham ƚunye'ji'iju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma' qa hekhewe' fariseol qa yit'ijju' in tafaakate'yijju': —¿Me hats ƚi'weni'ƚ in ham weju'ƚi'ij pakha' ƚijamtitaxiƚets? Jeƚ qeku'ni'ƚek, hats week itupi'le'ets ene' week nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Qa uja'x hekhewe' griegos i'nji'teje'm hekhewe' olotsija namii qu' niyiinija kekhewe' ƚe'sits neƚutsji'. ");
INSERT INTO mca_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Enewe'en qa ikii ha' Felipe, hikha' ta'ƚiyek ha' witset Betsaida ha' sehe' Galilea, ma' qa qi in iyinijets: —Jukhew, tseqwenkeyu'taxi'ƚij pa' Jesús.— ");
INSERT INTO mca_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ha' Felipe qa ikii ha' Andrés qa nifeli'm, ma' qa ha' Andrés qa ha' Felipe qa nifelii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ha' Jesús qa yeku'ƚ, qa yit'ijets: —Hats yamets ƚahats'ij ha'ne Ƚa's na' Jukhew qu' napiletspha'm iye na' wa's. ");
INSERT INTO mca_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yijaa'ija aka' qu' hit'iƚij ewets, ne'ej ƚo' ne'ej trigo in nite' nami'ju' sehe' qa wa'mƚeji', qa ham pe'qu' nata'ƚets hats ewi'ƚƚe, qa in namƚi'iju' yijat'ij na'aj sehe', qa wa'mji', ma' qa olots yijat'ij pe'qu' nata'ƚets ƚei. ");
INSERT INTO mca_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pakha' qu' nisu'un pa'qu' ƚiƚa'xe' qa' naqamij hatse', qa pakha'ƚe qu' nuten pa'qu' ƚiƚa'xe' ha'ne sehe' epji', qa' niƚin pa'qu' ƚiƚa'xe' qe qa' nejutshenets pa' witiƚa'x nite' yili'ij. ");
INSERT INTO mca_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pakha' qu' net'ithayii ye'm, qa' natsjayan, qa nakha' qu' ha'ni' qa' hik nakhajeek qu' na'ni' pakha' yeq'ithayinenek. Pakha' qu' net'ithayii ye'm qa na' Tata qa' qi qu' niwqinhetji' pakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Hane'ej pa' yitawe'j qi in hoksi'wen in uƚ'axi'mkii. ¿Qa pa'n qu' hit'ij? ¿Me hit'ij: “Tata anamitkitek yiwets pakha' iftsax”? Qa hik ta'ƚijupi' in tsam qe qa' yijunye'je'kii aka' iftsaxji'. ");
INSERT INTO mca_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, iwqinhetji'ha ka' ii.— Ma' qa nokes pa' ewi'ƚ wit'ax ta'ƚiipha'm na' wa's qa yit'ij: —Hats hiwqinhetji'ha aka' Yii qa' ewi'ƚij iye qu' hiwqinhetji'ha iye.— ");
INSERT INTO mca_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Qa hik ta'ƚijupi' hekhewe' olots i'ni' hakha'a' qa yepi'ye', yit'ijets in ewi'ƚte' pa' tejen. Qa hekhewep qa yit'ijetsek in ewi'ƚte' pa' ángel iyeti'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Qa ha' Jesús qa yit'ij: —Pakha' t'aiji' nite' yakha' qu' net'ejui yiwets, ekheweli'ƚ t'ejuyi'ƚ ewets. ");
INSERT INTO mca_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hane'ej hats nam ha'ne ƚahats'ij qa ha'ne week sehe' epji' qa' newetjeyumtshenij pa'qu' ƚunyejeye'. Qa hane'ej nakha' tenek'enheitaxipji' ha'ne week sehe' epji' qa' netwumhitiifik'i. ");
INSERT INTO mca_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Qa yakha', qu' heyiihinhetiitaxik'uipha'm ha'ne sehe', qa yakha' qa haqsiijkii qu' nonot'ax yiwets ene' weekji'.— ");
INSERT INTO mca_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Qa yi'tƚi'ij aka'an hats'inha qa yeqethentaxik'iha pa' ƚunye'jkii hatse' qu' nawa'm. ");
INSERT INTO mca_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Qa he' jukhew qa yit'ijju': —Tsikfe'litiƚets kekhewe' we'nika'ajji' pa'aj pa' Cristo in tees tit hame' ene' week ƚahatsiyij. ¿Qa pa'n ƚunye'j in ƚit'ijets: “Ha'ne Ƚa's na' Jukhew qa' ne'nenpha'm qa na' wa'm”? ¿Ƚek pakha' pa' Ƚa's pa' Jukhew?— ");
INSERT INTO mca_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús qa yit'ij: —Mexe, hats ƚammi'sƚe pa' hamik'ui, qa nakha' hik ƚunye'j na'lkii, qa hats nite' na'ni'iƚ etji'teje'mkii. Ijalkisi'ƚji'kii na' na'lkii in mexe i'ni'ƚ etji'teje'm, hats'inha qu' nite' e'nitjuƚaxi'iƚijpha'm na' nookii. Na'aj yijalki'sji'kii na'aj nookii nite' nikfe'lets pa'n ikji'. ");
INSERT INTO mca_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","In mexe i'ni'ƚ etji'teje'm na' na'lkii, ek'eni'ƚets hasu'uj eqeku'uƚ na' na'lkii, hats'inha qu' ƚelitsi'iƚ ej na' na'lkii.— In yili'ij ekewe'en in yit'ij ha' Jesús qa ik qa wanat'inik'uikii hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Qa in yemjeetax in hats olotstax ke' yi'wentaxijha in yaqsiijkii ham ƚunyejeyi'iju'ƚ, qa ƚunye'j ji'ij in yeqeku' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hats'inha qu' nasinik'i kekhewe' yit'ij pa'aj pa' profeta'ik'i Isaías, in yit'ij: —Yatsat'axyij, ¿pa'n ƚii pakha' qu' nite' neqekuyi'ik'i ekewe' jitefeltax? ¿Qa pa'n ƚii pakha' qu' hats ni'wen in t'ethinhetiitaxij pa' ƚet'unha'x pa' Yatsat'ax'inij?— ");
INSERT INTO mca_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma' qa hik ta'ƚijupi' in nite' ƚeke' qu' netk'enets, qe pa' Isaias'ik'i yit'ij iye pa'aj: ");
INSERT INTO mca_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Pa' Dios yit'onji' ƚotoi pekhewe'en qa yit'unhetje'm iye pe' ƚatawjets, hats'inha qu' nite' ni'wene' qa nite' nenikfeli'ik'i iye, ma' qa' nite' netetwek'elaxe' yiwets qa yakha' qa' nite' henƚine'ju'.— ");
INSERT INTO mca_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ekewe'en yit'ij pa'aj pa' Isaias'ik'i, qe yi'wen pa' qi ƚesa'x ha' Cristo qa nifelkii iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ƚa'mek qa ƚunye'j ji'ij iye in olots hekhewe' tek'enets, nite' yeqeku' hakha'an, qa i'ntaxji'teje'm iye hekhewe' uja'x tenek'enhei qa nite'ƚe tetfelij, qe nijiweyiju'ƚ he' fariseol qu' nukinik'uifik'i he' ƚe'lijtsitjiyits. ");
INSERT INTO mca_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Qe les yisu'unji' in yiwqinhetji' ene' jukhew, qa nite' qu' les nisu'un qu' pakha'ye' yijat'ij Dios qu' niwqinhetji' enewe'en. ");
INSERT INTO mca_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ha' Jesús yit'unhetik'i in yit'ij: —Pakha' qu' nite' nesqeku'ye', nite' yakha' qu' nite' nesqeku'ye', nakha'ƚe ts'ukinju' hikna' nite' yeqeku'. ");
INSERT INTO mca_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Qa pakha' qu' hats netswen, ma' qa hats yi'wen na' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yakha', fetitjii, tsametsju' ha'ne sehe' ipji', hats'inha qu' weeke' pakha' qu' nite' nesqeku'ye' qa' nite' amane' ji'teje'm na' nookii. ");
INSERT INTO mca_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pakha' qu' nepi'ye'taxik'i eke' yi'lijei qa nite'ƚe tek'enik'i, hane'ej nite' hitani'then, qe nite' tsamijetsju' qu' hitani'then ha'ne week sehe' ipji', tsametsju' qe qa' henƚinju'. ");
INSERT INTO mca_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pakha' qu' nite' net'eku'me'yiju'ƚ qa nite' t'eku'miju'ƚ iye kekhewe' yi'lijei, ma' qa hats na'l pakha' qu' newetjeyumtshenij hatse', kekhewe' yi'lijei henfeltaxi'ƚ e'm, hik kekhewe' qu' netjeyumtshenij hatse' pa' neƚuji' qu' hats ƚ'akathe'ye'ƚeju' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Qe yakha' nite' henfel pakha' qu' yakha' ye'ƚe qu' hisu'unƚe, nakha'ƚe Tata hik nakha' ts'ukinju', hik nakha'ƚe yit'ij yiwets qu' hit'ij week kekhewe' henfel qa k'inq'ijatshenij iye. ");
INSERT INTO mca_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Qa tsikfe'lets iye pakha' qu' nit'ij na' Tata qu' nanaqsiijkii in ta'ƚets qu' nanali'ƚ e'm na' witiƚa'x nite' yili'ij. Qa hik ta'ƚijupi' kekhewe' hit'ij, qa hit'ij in ƚunyejeyek kekhewe' hats yit'ij yiwets qu' hit'ij.— ");
INSERT INTO mca_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","In mexente' tekju' qu' net'ejuyets kakha' ƚe'wis neƚu Pascua, ha' Jesús nikfe'lets in hats yamets ƚahats'ij qu' nakik'ui iye ha'ne sehe' ipji' qa' namii iye pa' Ƚatata. Ƚakha' in yisu'unija hekhewe' yatsat'etsij in mexe i'nipji' ha'ne sehe' qa nite' yili'ij qu' qi qu' nisu'un yamijii pa' neƚuji' qu' hats ƚ'aka'the' ye'ƚe hatse'. ");
INSERT INTO mca_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","In hats nekuyuju' pa'aj, qa pa' inwo'met hats yenji' ƚatawe'j ka' Judas, ƚa's pakha' Simón Iscariote, qu' net'ihinij ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Qa ha' Jesús qa nikfe'lƚe'ets pa' Ƚatata in tisij qu' netnek'enhe'yipji' week ekewe' wekwek, qa nikfe'letsha iye in ta'ƚiiha pa' Dios qa nikfe'lets iye qu' napiliipha'm iye pa' i'ni' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Qa in mente' tektaxju' qa niyik'uipha'm, ma' qa nit'ijji' ka' juffufuf ƚ'uihitjii qa t'eku'mi' ka' ewi'ƚ toalla qa yeqelutsiji'. ");
INSERT INTO mca_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Qa yatsiiji'ju' ka' iweli' ha' k'eeweji' tok'o, ma' qa yapeƚek qa nimpuujinju' he' ƚef'iyei he' ƚ'ijatshenhei qa ha' yeqelutsiji' toalla qa hikha' qa nili'jijju'. ");
INSERT INTO mca_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma' qa yamets ha' Simón Pedro, hakha'an qa yit'ij: —Yatsat'axyij, ¿me ƚenqempuujitsheneyu'taxij ene' yif'iyei?— ");
INSERT INTO mca_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ha' Jesús qa yeku'ƚ: —Hane'ej nite' ƚenikfe'lets aka' haqsiijkii, qa hatse'ƚu' enikfe'lets.— ");
INSERT INTO mca_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ha' Pedro qa yit'ij: —¡Nite' yexke'ej qu' impuujin ne' yif'iyei!— Ha' Jesús qa yeku'ƚ: —Qu' nite' himpuujine' qa' nite' hik akha'ye' nekhewe' tsatsat'etsij.— ");
INSERT INTO mca_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ha' Simón Pedro qa yit'ij: —Ye'ehe, Yatsat'axyij, qa hasu'uj uja'xe'ƚe qu' impuujin ne' yif'iyei, qe ene' yikoyei iye qu' impuujin qa ha'ne yijiƚa' iye.— ");
INSERT INTO mca_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ha' Jesús qa yit'ijets: —Na'aj hats wempuli'j hats nite' hamik'ui qu' nempuli'j iye, hats uja'xƚe ne'ej ƚef'iyei qu' nimpulijin qe hats week ham ƚejili'ye' na'aj ƚ'aj. Qa ekheweli'ƚ hats ham ejiliyi'iƚ, qa nite'ƚe e'weeki'ƚha.— ");
INSERT INTO mca_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Qe nikfe'lets kakha' qu' net'ihinij hatse', qa hik ta'ƚijupi' in yit'ij: —Nite' e'weeki'ƚ qu' hats ham ejiliyi'iƚ.— ");
INSERT INTO mca_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ma' qa in hats week yaqhat'etsij in nimpuujinju' he' ƚef'iyei, qa uyik'ipha'm iye ha' te'nweipha'm ƚ'uihitjii, ma' qa i'nijupju' iye ha' mesa, qa yit'ij: —¿Me ƚenikfe'li'ƚets aka' haqsi'ji'ƚ e'mijkii? ");
INSERT INTO mca_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ekheweli'ƚ ƚit'iƚij yiwets Maestro qa ƚit'iƚij yiwets iye Yatsat'ax'inij, qa i'woyitsi'ƚijik'iha, qe yakha' hik aka' yijunye'j. ");
INSERT INTO mca_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ehe, in yakha' Yatsat'ax'inij qa Maestro iye, ma' qa' henimpuujinju' ne' ef'iyeyi'ƚ, qa ekhewepe'jiiƚek iye qu' enimpuujini'ƚju' ne' ef'iyeiƚi'iƚ wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Qe yakha' hojo'oƚ e'mij, hats'inha qu' ekhewepe'jiiƚek qu' aqsiiƚijkii aka' hats yeqfenyejeyi'ƚ ej. ");
INSERT INTO mca_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yijaa'ija aka' hit'iƚij ewets, ham pa'qu' witqejkunenek'e qu' nat'anipji' pa'qu' ƚaqa patune', qa ham iye pa'qu' wit'ukinek'e qu' na' t'anipji' pakha' qu' nukin. ");
INSERT INTO mca_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Qu' enikfe'li'ƚik'i aka'an, qi qu' e'ƚe'sitsi'iƚi'mkii qu' aqsiiƚijkii. ");
INSERT INTO mca_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nite' e'weeki'ƚ qu' nek'iyeti'ƚ ek'ui. Yakha' tsikfe'lij nekhewe' hats he'yeku'mi', qa t'ejuiƚe'ets aka'an qu' nafits kekhewe' we'nika'ajji': “Pakha' yekufetax yemjee qa yetshenyijupha'm pa' ƚoqok'o qu' not'otsyit je'mkii, qe hats yejuihife'ej.” ");
INSERT INTO mca_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hane'ej hats k'efeli'ƚi'm aje'eƚ in mente' yamets aka'an, hats'inha qu' namtaxets qu' ƚunye'je', qa' nite' eqeku'yi'iƚik'i in yakhaa'ija Cristo. ");
INSERT INTO mca_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' neneqjunu'uj pa'qu' yukinek'e, qa yakha'ƚe in neqjunu'yij. Qa pakha' qu' neneqjunu'yij qa nakha'ƚe ts'ukinju' hikna' neqjunu'uj.— ");
INSERT INTO mca_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","In yili'ij in yit'ij aka'an ha' Jesús, ma' qa yoksi'wen in qi in itawje'met, qa yatsathenketija in nifel, qa yit'ij: —Yijaa'ija aka' qu' it'iƚij ewets, in na'l na' ewi'ƚ ekheweli'ƚ t'ihinyij hatse'.— ");
INSERT INTO mca_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","He' ƚ'ijatshenhei qa yejeƚ wetju'ƚkii, qe nite' nikfe'lets pa'n ƚunye'j pakha'an. ");
INSERT INTO mca_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ha' ewi'ƚ hekhewe' ƚ'ijatshenhei, hik hakha' ha' yisu'un ha' Jesús, ewi'ƚ i'ni'ƚi' in teki'ƚju'. ");
INSERT INTO mca_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma' qa ha' Simón Pedro qa yit'ijii k'ewk'ew he' ƚokoyei, qa ƚokoyeiƚe he' yit'ijii in yit'ijets: —Anfaakanij pa'n ƚiiyija pakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ma' qa to'siyijets ha' Jesús, qa nifaakanij: —Yatsat'axyij, ¿pa'n ƚii pakha'an?— ");
INSERT INTO mca_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ha' Jesús qa yeku'ƚ: —Nakha' qu' hetisij ha'ne qu' hilke'ejji'ju' na' ƚ'i' pan ƚapk'as.— Ma' qa yuihinji'ju' ka' pan ƚapk'as ka' ƚ'i', qa tisij ka' Judas ƚa's pakha' Simón Iscariote. ");
INSERT INTO mca_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ma' qa in hats tuj ka' pan, qa pa' Satanás qa uiji'teje'm kakha'an. Ha' Jesús qa yit'ijets: —Pakha' ƚanqaqsijkineyu'ujkii, yape if'elitik'i qu' aqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Qa nite'ƚe ewii'ƚe' pa'qu' nenikfe'lik'i hekhewe' i'nijup ha' mesa inhats'ek in yit'ijets aka'an. ");
INSERT INTO mca_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Qe uja'x hekhewe' yumtitax kakha' Judas in hikka' yaqsi'j ka' ti'naj i'nji' kekhewe' ƚ'astai, ha' Jesús qu' nit'ijets: Aqha'yii pekhewe' qu' mexe hamitse' ine'm qu' net'ejuyets ha'ne ƚe'wis neƚu, i'nƚi'i qu' netisij pe'ye' pe' ham yiwq'axine'. ");
INSERT INTO mca_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ma' qa ka' Judas in hats testi'yij ka' pan ƚapk'as, qa yenteje'm qa aje'eƚ niipha'm qa ikfik'i. Hik aka'aj hats najaleikii. ");
INSERT INTO mca_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma' qa in hats ikfik'i ka' Judas, ha' Jesús qa yit'ij: —Hane'ej qu' neniwqinhetji' ha'ne Ƚa's na' Jukhew, qa na' Dios qa' neniwqinhetji' iye qu' nata'ƚets hane'en. ");
INSERT INTO mca_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Qa qu' nata'ƚets hane'en qu' neniwqinhetji' na' Dios, qa na' Dios qa niwqinhetji'ijji' ek hane'en, qa' aje'eƚ qu' niwqinhetji'. ");
INSERT INTO mca_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yilits, hats k'esets qu' hats nite' ha'ni'iƚ etji'teje'm. Ekheweli'ƚ qa' mowotaxi'ƚyiikii. Qa hik ƚunye'j kakha' hit'ijets he' judiol qa hikka' hit'iƚij ewets iye hane'ej: nite' ƚeke' qu' eneki'ƚ nakha' qu' hakji'. ");
INSERT INTO mca_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","K'eƚisiƚij hane'ej aka' ewi'ƚ ink'ayik wenit'ij qu' nanaqsiijkii: mewet-su'uniƚha ekheweli'ƚ, in yijunye'jek in qi in k'esu'uni'ƚ qa hik aka' ejunyejeyi'iƚij qu' mewet-su'uni'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Qa aka'an qa' hik aka' qu' nata'ƚets qu' week nenikfe'letsha in ekheweli'ƚ k'eyijatshenheyi'ƚ, ehe, qu' nanali'ƚ e'm pa'qu' e'qsu'unkaxitsi'iƚ wetju'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ha' Simón Pedro qa yit'ijets: —Yatsat'axyij, ¿pa'n ƚakji' hatse'?— Qa yeku'ƚ ha' Jesús: —Hane'ej nite' ƚeke' qu' atsjayan nakha' qu' hakji', qa' ink'aye'ƚe hatse' qu' atsjayan.— ");
INSERT INTO mca_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro qa yit'ij: —Yatsat'axyij, ¿inhats'ek in nite' hane'ej qu' k'ajayan yijat'ij? Nite' hetjeyepun inye'jƚu' qu' hawa'm efi.— ");
INSERT INTO mca_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ha' Jesús qa yeku'ƚ: —¿Me ƚit'ij yiwets qu' mawamyifi? Yijaa'ija aka' qu' hit'ij ewets: in nite' ip pa'qu' ta'a'aye' qu' mente' wetshetk'ewi'ƚi'ij qu' mewelku'tyijkii.— ");
INSERT INTO mca_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—Hasu'uj itawje'metetsi'iƚ. Hasu'uj eqeku'uƚ na' Dios, qa hasu'uj esqeku'uƚ iye. ");
INSERT INTO mca_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne' ƚetsi' na' Tata olots ne' ƚatawjets. Qek nite' yijaayi'ija aka'an qekha nite' hit'etaxi'ƚij ewets. Qa' hathayinpha'm hatse' qa' haji'let pa'qu' etset'i'iƚ. ");
INSERT INTO mca_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Qu' haktax qa' haji'let pa'qu' etset'i'iƚ, qa' hetpilju' iye hatse', ma' qa' k'ekaxi'ƚpha'm qa' ewi'ƚ jina'ni' na' ha'ni'. ");
INSERT INTO mca_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hats ƚek ƚenikfe'li'ƚets nakha' wit'ikheyi'jii nakha' qu' hakji'.— ");
INSERT INTO mca_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma' qa ha' Tomás qa yit'ijets: —Yatsat'axyij, qu' nite' netsikfe'li'iƚets pa' ƚakji', ¿qa pa'n ƚunye'j qu' netsikfe'liƚets pa' wit'ikheyi'j?— ");
INSERT INTO mca_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ha' Jesús qa yit'ijets: —Yakha' yewit'ikheyij, yakha' ye'yijaa'ija, qa yakha' iye ye'witiƚa'x. Yakha' yeƚ'ewi'ƚƚe qu' k'amitiƚii na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Qu' hats enikfe'li'ƚ yiwets ma' qa' hats enikfe'li'ƚets na' Tata. Hane'ej hats ƚenikfe'li'ƚij qa hats ƚi'weni'ƚha iye.— ");
INSERT INTO mca_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ha' Felipe qa yit'ijets: —Yatsat'axyij, ets'ethini'ƚij pa' Atata, ma' qa' hats nami'ƚyijju'ha.— ");
INSERT INTO mca_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ha' Jesús qa yeku'ƚ: —¿Me nite' hats tooxik'i in ha'ni'ƚ etji'teje'mkii qa menjiit nite' ƚenikfe'lyij, Felipe? Pakha' qu' hats netswen ma' qa hats yi'wen na' Tata. ¿Qa pa'n ƚunye'j in ƚit'ij: “Ets'ethini'ƚij pa' Atata”? ");
INSERT INTO mca_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Me ƚeqeku'uk'i in ha'n ji'teje'mha na' Tata, qa na' Tata qa i'nji'ij yitji'teje'mha ek? Kekhewe' wi'tlijei hit'iƚij ewets nite' yakha'ƚe qu' nata'ƚ yiwets in hit'iƚij ewets, qe nakha' Tata hik nakha' i'nyit ji'teje'mha hik nakha'ƚe yaqsiijkii kekhewe' qits wit'ithayijkitits. ");
INSERT INTO mca_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hasu'uj esqeku'uƚij in ha'n ji'teje'mha na' Tata, qa na' Tata qa i'nji'ij yitji'teje'mha ek. Qa qu' esqeku'ƚi'iƚij in hit'ij qa kekhewe' haqsiijkii qu' hik kekhewe'ye' qu' hasu'uj eqeku'uƚij aka'an. ");
INSERT INTO mca_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yijaa'ija aka' hit'iƚij ewets, pakha' qu' nite' nesqeku'ye', qa kekhewe' haqsiijkii qa' naqsi'jiijkiyek pakha'an, qa pekhewepe' iye les qits qu' naqsiijkii iye, qe hats tsamii hatse' na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Qa week pakha' qu' iyini'ƚets qu' it'iƚij ka' yii, qa' haqsiijkii, hats'inha na' Tata qa' neniwqinhetji'ha qu' nata'ƚets ha'ne Ƚa's. ");
INSERT INTO mca_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pa'qu' ƚunye'je' qu' iyini'ƚets qu' it'iƚij ka' yii, yakha' qa' haqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Qu' etsu'uni'ƚ, qa' aqsiiƚijkiiha kekhewe' hats hit'ij qu' nanaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Qa yakha' qa' nek'iyinets na' Tata, qa nakha'an qa' nenukini'ƚ ewetsju' qu' neƚisi'ƚij nakhap iye Eqi'fenkena'x, hats'inha qa' hikna' na'ni'ƚ ejupkii, nite' yili'ij qu' na'ni'ƚ ejupkii, ");
INSERT INTO mca_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ikji', nakha' Espíritu ta'ƚets na' yijaa'ija, hik nakha' ha'ne week sehe' ipji' nite' ƚeke' qu' netesti'yij, qe nite' yi'wen qa nite' nikfe'lets iye. Qa ekhewelƚi'iƚ qa ƚenikfe'li'ƚets qe i'ni'ƚ ejup, qa' ink'aye'ƚe qa' na'ni'ƚ etji'teje'mha. ");
INSERT INTO mca_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nite' k'ewu'mi'ƚ qu' hik ejunyejeyi'iƚ qu' a'ftiletsi'iƚ, hetpili'ƚ ei iye hatse'. ");
INSERT INTO mca_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hats nite' toxik'ui qa ha'ne week sehe' ipji' qa' hats nite' netswene', qa ekheweli'ƚ qa' e'tsweni'ƚ iye hatse', qe yakha' yi'ƚa'x iye hatse' qa ekheweli'ƚ qa' i'ƚiyejiiƚek iye hatse'. ");
INSERT INTO mca_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hik pakha' pa' neƚuji' hatse' ekheweli'ƚ qa' enikfee'liƚetsha yakha' in ha'n ji'teje'mha na' Tata, qa ekheweli'ƚ qa ƚa'ni'ƚ yitji'teje'mek, qa yakha' qa' haniƚ'et ji'teje'mek. ");
INSERT INTO mca_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pakha' qu' nana'li'm ekewe' hit'ij qu' nanaqsiijkii qa tek'enik'iha iye, pakha'an hik pakha' yijat'ij in tsisu'un. Qa pakha' tsisu'un qa na' Tata qa yisu'unek. Qa yakha' qa' hisu'un pakha'an qa' hoksi'wenketij in ha'nijupha.— ");
INSERT INTO mca_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Qa ha' Judas (nite' ka' Iscariote) qa yit'ijets: —Yatsat'axyij, ¿inhats'ek in yuja'xƚi'iƚ qu' k'eweni'ƚ iye hatse' qa nite' ha'ne week sehe' ipji'?— ");
INSERT INTO mca_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ha' Jesús qa yeku'ƚ qa yit'ijets: —Pakha' qu' netsu'un qa' netk'enik'iha eke' yi'lijei. Qa na' Tata qa' nisu'un pakha'an. Na' Tata qa yakha' qa' heneki'ƚetsju' pakha'an qa' ha'ni'ƚ ji'teje'mha qa' yitsiyi'iƚij. ");
INSERT INTO mca_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pakha' qu' nite' netsu'une, nite' tek'enik'i ke' yi'lijei, qa eke' yi'lijei ƚepi'ye'eƚik'i nite' yakha' qu' yi'lijeye'ƚe. Na' Tata hik nakha' ƚe'lijei, hik nakha' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ekewe'en wekwek hit'iƚij ewets hane'ej in mexe ha'ni'ƚ etji'teje'm. ");
INSERT INTO mca_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Qa nakha'ƚe Eqi'fenkena'x, nakha' Espíritu Santo, hik nakha' na' Tata nukinijju' hatse' aka' yiiji', nakha'an qa' nijatsheni'ƚij week ekewe' wekwek, ma' qa' enikfe'li'ƚik'i iye qu' ijamti'iƚik'i week kekhewe' hats hit'iƚij ewets. ");
INSERT INTO mca_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","K'ejetiƚij na' wittawjemetsi', k'eƚisiƚij na' yitawjemetsi', qa nite'ƚe k'eƚisiƚij qu' hik ƚunye'je' pakha' t'ihintaxij wittawjemetsi'tax ha'ne sehe' ipji'. Hasu'uj itawje'metetsi'iƚ. Hasu'uj iye e'nijiwe'yi'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hats ƚespiye'e'ƚ in hit'iƚij ewets: “Hak hatse' qa' hetpili'ƚ ei iye hatse'.” Qu' yijaayi'ija qu' etsu'uni'ƚ qa' qi qu' e'ƚe'sitsi'iƚi'mkii in ƚenikfe'li'ƚets qu' natsamii na' Tata, qe ƚakha' les in qiji' t'anyipji'. ");
INSERT INTO mca_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hane'ej hats k'efeli'ƚi'm aje'eƚ in mente' yamets aka'an, hats'inha qu' namtaxets qu' ƚunye'je', qa' nite' esqekuyi'iƚ. ");
INSERT INTO mca_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hats nite' qi qu' jintafaakateiju' hane'ej, qe hats nam na' tenek'enhe'yipji' ha'ne sehe'. Yemjeetax nakha'an in nite' yeqenijantaxyij. ");
INSERT INTO mca_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Qa lesƚe ƚe'wis qu' nenikfe'lets ha'ne week sehe' ipji' in hisu'un na' Tata, ma' qa' haqsiijkii week pakha' hats ƚunye'j pa' tsiyaji'ijets qu' haqsiijkii. Yape eniyi'ƚpha'mkii qinakik'ui ha'ne ju'uni'.— ");
INSERT INTO mca_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Yakha' pe' yijaa'ija uwakuk ƚetuk, qa na' Tata qa hikna' yejeƚets. ");
INSERT INTO mca_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Week pakha' qu' ham ƚeye' enewe' yakjil, qa' ne'nisa'xii. Qa week pakha' qu' netei, qa ne'nisa'xik'i pe'qu' ƚakjile'tax iye, hats'inha qu' les olotse' pe'qu' ƚeye'. ");
INSERT INTO mca_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ekheweli'ƚ qa hats te'nisa'xik'i pe' akjitaxi'ƚ iye, qe ta'ƚets kekhewe' wi'tlijei k'efeli'ƚi'm. ");
INSERT INTO mca_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","E'wisitse'kite'eƚ yijup, qa yakha' qa' nite' ye'wisitsi'iƚ ejup. Hik qu' ƚunye'je' na'aj ewi'ƚ ƚakji' ne'ej uwakuk in nite' ƚeke' qu' neteiƚe qu' nite' netije'ets pe'qu' ƚetuk'e, qa hik aka' qu' ejunyejeyi'iƚ qu' nite' a'maneyi'iƚ yijup. ");
INSERT INTO mca_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yakha' pekhe' uwakuk, qa ekheweli'ƚ qa pekhewe' ƚakjil pekhe'en. Pakha' qu' nite' wi'se'yijup, qa yakha' qa' nite' jeek ye'wi'si'ijup pakha'an, pakha'an qa olots pe'qu' ƚeye'. Qe qu' i'totsi'iƚ ye'mets ham pa'qu' ƚeke'ye' qu' aqsiiƚijkii. ");
INSERT INTO mca_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pakha' qu' nite' amane' yijup, qa' netwumhitiifik'i in ƚunye'jek na'aj ewi'ƚ ƚakji' qe we'nisa'xii ma' qa yisƚax, qa ewi'ƚ we'neni' qa tewumhitiiji'ju'kii na'aj fe't ma' qa naq'axij fe't. ");
INSERT INTO mca_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Qu' a'maneyi'iƚ yijup, qa ekewe' yi'lijei iye qu' amaneyi'iƚ etji'teje'm, iyini'ƚets pa'qu' isu'uni'ƚ qa' esti'yi'ƚij. ");
INSERT INTO mca_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aka' ta'ƚets qu' neniwqinhetji' na' Tata aka'an, qu' olotse' pe'qu' eyi'iƚ, aka'an hik aka' qu' ni'nq'ethinij in ekheweli'ƚ k'eyijatshenheyi'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","In ƚunye'jek na' Tata in qi in tsisu'un, qa hik yijunye'j yakha' in qi in k'esu'uni'ƚ, e'wisitse'kite'eƚij yijup na' yeqsu'unkaxitsi'ƚ ej. ");
INSERT INTO mca_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Qu' ek'eeni'ƚik'iha kekhewe' hit'ij qu' nanaqsiijkii, ma' qa' nite' e'wisitsi'iƚji' na' yeqsu'unka'x. In yijunye'jek yakha' in heik'enik'iha kekhewe' yit'ij na' Tata qu' nanaqsiijkii, ma' qa nite' ye'wi's ji'teje'm na' qi ƚeqsu'unka'x. ");
INSERT INTO mca_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ekewe'en wekwek k'efeli'ƚi'm, hats'inha qu' hik ƚunye'je' pa' yisa'xi'mkii pa'qu' isaxitsi'iƚi'mkii, qa pa' isaxitsi'ƚi'mkii qa' notpoli'ƚ ej. ");
INSERT INTO mca_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aka' yi'lijei hit'ij qu' aqsiiƚijkii, aka'an: “Ekheweli'ƚ qi qu' mewet-su'uni'ƚ, in yijunyejeyi'ƚ ejek yakha' in qi in k'esu'uni'ƚ.” ");
INSERT INTO mca_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ham pa'qu' nana'li'm pa'qu' ƚeqsu'unka'xe' qu' nat'anipji' aka'an: pa'qu' ewi'ƚe' in wetƚisij in wa'mifi pe'qu' ƚejuwaikale'. ");
INSERT INTO mca_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ekheweli'ƚ k'eyijuwaikali'ƚ qu' aqsiiƚijkii pakha' qu' k'ayaji'iƚijets. ");
INSERT INTO mca_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Hats nite' hit'iƚij ewets qu' e'witqejkunenheyi'iƚ, qe na'aj witqejkunenek nite' nikfe'lets pa'qu' naqsiijkii pa'qu' ƚaqa patune'. Hit'iƚij ewets yijat'ij qu' k'eyijuwaikali'iƚ, qe yakha' k'eƚisiƚij qu' enikfe'li'ƚets week kekhewe' yit'ij yiwets na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nite' ekhewelƚi'iƚ qu' ku'mi'ƚyi', yakha'ƚe in he'yeku'mi'ƚ eiji'kii, qa he'yekumi'ƚij eiji'kii qu' ma'aƚij hats'inha qu' nana'l pe'qu' hik ƚunyejeye' qu' eyi'iƚ, qa pe'qu' eyi'iƚ qa hasu'uj qu' hamitse', hats'inha na' Intata qa' neƚisi'ƚij week pe'qu' iyini'ƚijets qu' it'iƚij ka' yii. ");
INSERT INTO mca_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aka' k'ayaji'iƚijets qu' aqsiiƚijkii aka'an: mewet-su'uniƚha ekheweli'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Qu' na'napjaxi'ƚ e'm ha'ne sehe' ipji', qa' menikfeliti'ƚets in yakha' yojo qu' na'napjax ye'm. ");
INSERT INTO mca_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Qek natsat'etsi'ƚ ej ha'ne sehe' ipji', qekha nesu'untaxi'ƚ ha'ne sehe' ipji', in ƚunyejeyijek nekhewe' yatsat'etsij in qi in yisu'un. Qa nite'ƚe yatsat'etsi'ƚ epji' ha'ne sehe' ipji', qe yakha' hats he'yeku'mi'ƚ eiji'kii qa hats nite' ƚa'ni'ƚ ji'teje'm ha'ne sehe' ipji', qa hik ta'ƚijupi' ha'ne sehe' ipji' in napjaxi'ƚ e'm. ");
INSERT INTO mca_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Maxtayitiƚik'i kakha' wi'tlijei hit'iƚij ewets: “Ham pa'qu' witqejkunenek'e qu' nat'anipji' pa'qu' ƚaqa patune'.” Qu' hayawitjaxtii qa' ekheweljiiƚek iye qu' awitjaxti'yi'ƚ. Qu' net'eku'miju'ƚ eke' yi'lijei qa' net'ekumjii'ƚ ejuƚek. ");
INSERT INTO mca_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Week ekewe'en qu' ƚeqfenyejeyi'iƚ ej hatse' qe ta'ƚets in ƚatsjayani'ƚ, qe nite' nikfe'lets nakha' ts'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Qek nite' natsame' qa qek nite' henfeli'imha iye, qekha nite' noksi'wene'tax pe' ƚewuƚ'ets. Qa ha'neƚi'ij qa hats nite' ƚeke' qu' nittaxijets qu' nite' nenikfe'le'ets pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pakha' qu' na'napjax ye'm, napjaxi'm iye na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Qek nite' haqsi'ji'imijkii kekhewe' wekwek ham ƚunyejeyi'iju'ƚ, qekha nite' noksi'wene'tax pe' ƚewuƚ'ets. Qa ha'neƚi'ij qa hats yi'wen kekhewe' haqsiijkii, ma' qa napjax ye'm qa napjaxi'm iye na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Qa yaqsi'jƚi'ijkii aka'an qe qa' nafits kakha' wi'tlijei we'nika'ajji' nakha' yit'ijets nekhewe'en qu' ƚeqe leye': “Hamtax ta'ƚi'ijupi' qa napjaxƚe ye'm.” ");
INSERT INTO mca_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Qu' nanamtax nakha' Eqi'fenkena'x nakha' qu' he'nukinju' hatse' ta'ƚets na' Tata, ikji', nakha' Espíritu ta'ƚets na' yijaa'ija ta'ƚii na' Intata, nakha'an qa' hik nakha' qu' netsfeelija. ");
INSERT INTO mca_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Qa ekheweli'ƚ iye qu' etsfeli'ƚ, qe ƚata'ƚi'ƚijii in i'nk'aa'ija in ƚa'ni'ƚ yijupkii. ");
INSERT INTO mca_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Henfeli'ƚ e'm ekewe' wekwek hats'inha qu' hame' pa'qu' ilani'ƚifi qa' anami'ƚju'kii. ");
INSERT INTO mca_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Newumiƚik'uifik'i iye hatse' nekhewe' ƚe'lijtsitjiyits ne' judiol. Qa namƚe hatse' nakha' ƚahats'ij qa pakha' qu' ƚunye'je'ƚe qu' nalani'ƚju' qa' numtitax qu' hik aka' ƚunye'je' qu' net'ithayiyi'mha na' Dios. ");
INSERT INTO mca_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yaqsiijkii hatse' aka'an qe nite' nikfe'lets na' Tata qa nite' nikfe'l yiwets iye. ");
INSERT INTO mca_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","K'efeli'ƚi'm ekewe'en hats'inha qu' namtaxets qu' ƚunyejeye'kii ekewe'en, ma' qa' ijamti'iƚik'i kekhewe'en in hats k'efeli'ƚi'm. Qa nite' hayiits qu' henfeli'ƚ e'm ekewe' wekwek qe mexe ha'ni'ƚ etji'teje'm.— ");
INSERT INTO mca_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","—Qa ha'neƚi'ij qa' hats natsamii nakha' ts'ukinju', qa ham ekheweli'ƚ pa'qu' natsfaakanij qu' nit'ij: “¿Pa'n qu' maji'?” ");
INSERT INTO mca_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Qe in ta'ƚets in k'efeli'ƚi'm ekewe' wekwek, ma' qa qi in topolij pe' atawjetsi'ƚ pa' ika'metaxitsi'ƚ wetju'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Qa yijaaƚi'ija aka' qu' hit'iƚij ewets: in les ƚe'wis qu' haki'ƚ ek'ui, qe qu' nite' hake', qa na' Eqi'fenkena'x qa' nite' nanami'iƚ ewetsju'. Qa qu' hakƚi'iƚ ek'uipha'm ma' qa' he'nukini'ƚ ewetsju' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Qu' nanamtax hatse' nakha'an, qa hikna' nikfelitets ha'ne week sehe' ipji' pa' ƚewuƚ'ax, qa pa' wittsathenkeye'j qa qu' newetjeyumtshentax hatse' ene' week. ");
INSERT INTO mca_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pa' ƚewuƚ'ax ikji', in nite' tek'en yiwets tseqeku'. ");
INSERT INTO mca_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Qa pa' wittsathenkeye'j qa ikji', yakha' in hats tsamii na' Tata qa' hats nite' e'tsweni'iƚ. ");
INSERT INTO mca_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Qa pa' wetjeyumtshen ene' week qa ikji', nakha' tenek'enhe'yipji' ha'ne sehe' in hats ta'nanhi'yipji' qa hats jutsiqax qu' qi qu' nattanithenhetii hatse'. ");
INSERT INTO mca_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Olots kekhewe' wekwek tseqfelenheyu'uƚij e'm, qa mexeƚe nite' e'weju'ƚi'ƚiju'ƚ ha'ne hane'ej ƚahats'ij. ");
INSERT INTO mca_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Qa nakha'ƚe Espíritu ta'ƚets na' yijaa'ija, nakha'an qu' nanamtax qa' hikna' qu' nijatsheni'ƚ qa' nikfeliti'ƚets week pa' yijaa'ija, qe tees qu' niyetij pakha' qu' ƚakha' ye'ƚe qu' nisu'un, qe iyetij yijat'ij week pakha' qu' nimpi'ye'ej nakha'an, ma' qa nakha'an qa' nikfeliti'ƚets pekhewe' wekwek mexe hamitsik'ui ƚunyejeikii hatse'. ");
INSERT INTO mca_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nakha'an qi qu' netsiwqinhetji' hatse', qe testi'yij hatse' kekhewe' tsatsat'etsij, ma' qa' nikfeliti'ƚets. ");
INSERT INTO mca_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Week nekhewe' na'li'm na' Tata yakha' tsatsat'etsij iye, hik ta'ƚijupi' in hit'iƚij ewets na' Espíritu Santo qu' netesti'yij hatse' nekhewe' tsatsat'etsij, qa nakha'an qa' naqsiijkii qu' enikfe'li'ƚets.— ");
INSERT INTO mca_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Hats k'esetsha hats nite' toxik'ui, ekheweli'ƚ qa' hats nite' e'tswene' eku'ni'ƚ, qa ink'aye'ƚe iye qa' e'tsweni'ƚ iye.— ");
INSERT INTO mca_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma' qa he' uja'x hekhewe' ƚ'ijatshenhei qa yifaakateji': —¿Pa'n ikji'ha in yit'ij inwets: “hats nite' toxik'ui, ekheweli'ƚ qa' hats nite' e'tswene' eku'ni'ƚ, qa ink'aye'ƚe iye qa' e'tsweni'ƚ iye” qa yit'ij iye: “qe yakha' tsamii hatse' na' Tata”?— ");
INSERT INTO mca_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Qa yit'ijju' iye: —¿Pa'n yukinji' in yit'ij inwets: “hats nite' toxik'ui”? Nite' jinikfe'li'k'uyii pa' iyettaxij.— ");
INSERT INTO mca_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ha' Jesús qa hatsƚe nikfe'lets hekhewe'en in naqfaakanheyu'uj, qa yit'ijji'ju': —¿Me ƚifaakateji'iƚji' in hit'ij: “Hats nite' toxik'ui, ekheweli'ƚ qa' hats nite' e'tswene' eku'ni'ƚ, qa' ink'aye'ƚe qa' e'tsweni'ƚ iye”? ");
INSERT INTO mca_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yijaa'ija aka' hit'iƚij ewets, in ekheweli'ƚ ƚapi'ƚju' hatse', qa' qi iye qu' ika'metetsi'ƚkii. Qa ha'neƚe sehe' ipji' qa qi'ek qu' ƚe'sitsi'imkii. Ekheweli'ƚ ƚ'ikametetstaxi'ƚkii hatse', qa' naya'xƚi'i hatse' pakha' ika'metaxitstaxi'ƚkii na' qi witisa'xi'mkii. ");
INSERT INTO mca_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ne'ej efu in hats k'esik'i qu' nanqala'x, qa qi in yaats'eji' ƚekutjii, qe hats yamets pakha' ƚahats'ij qu' nenekfik'i. Qa in hatsƚe nekfik'i na'aj omeƚa's, ma' qa hats nitapi'ik'i ƚaqa'ti'ij, qe ta'ƚets pakha' qi ƚesaxi'mkii in hats neketsfik'i pakha' omeƚa's ha'ne sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Qa hik ejunyejeyi'ƚ in qi in ƚ'ikametetsi'ƚ wetju'ƚ qa ƚaats'e'eƚ, qa k'ewenƚi'iƚ iye hatse', qa ne' atawjetsi'ƚ qa' qi qu' ƚe'sitsi'imkii, qa ham pa'qu' netka'miƚij pakha' qu' esaxitsi'iƚi'mkii. ");
INSERT INTO mca_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pakha'an pa' neƚuji' hatse' ham pa'qu' atsfaakani'ƚij. Yijaa'ija aka' hit'iƚij ewets. Na' Tata week qu' neƚisi'ƚij pa'qu' iyini'ƚijets qu' it'iƚij aka' yii. ");
INSERT INTO mca_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hane'ej mexe nite' ƚ'iyiniƚets pe'ye' qu' it'iƚij ka' yii. Iyini'ƚets, qa' esti'yi'ƚij pa'qu' iyini'ƚets, hats'inha qa' qi qu' e'ƚe'sitsi'iƚi'mkiiha.— ");
INSERT INTO mca_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Ekewe' wekwek in k'iyetij qa hit'iƚij'e' kekhewe' hejeyumtshenƚi'ijupi'. Qa hatsƚe yamets hatse' nakha' ƚahats'ij qu' hats nite' hit'i'iƚij'e' pe'qu' hejeyumtshenijupi', qe hats qu' hatsa'thenketik'iha yijat'ij qu' henfeli'ƚ e'm na' Tata. ");
INSERT INTO mca_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hik pakha' pa' neƚuji' hatse' ma' qa' iyini'ƚets pe'ye' qa' it'iƚij aka' yiiji'. Qa nite' hit'iƚij ewets qu' yakha'ye' qu' nek'iyini'ƚ e'mets na' Tata qu' net'ekumi'ƚ eju'ƚ, ");
INSERT INTO mca_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","qe na' Tata ƚakha'ija in qi in nesu'uni'ƚ, qe ekheweli'ƚ ƚetsu'uni'ƚ qa nite' ƚeqeku'uƚik'i iye in yakha' hata'ƚii na' Dios. ");
INSERT INTO mca_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","In henek hata'ƚets na' Tata qa heneketsju' ha'ne sehe'. Qa hane'ej qa' hakik'ui iye ha'ne sehe' qa' natsamii iye na' Tata.— ");
INSERT INTO mca_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma' qa he' ƚ'ijatshenhei qa yit'ijets: —Hayits yijat'ij, hats yeqet'aaxik'iha ka' ƚit'ij in ham pa'qu' ejeyumtshenijupi'. ");
INSERT INTO mca_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hane'ej hats tsikfe'li'ƚetsha in week ƚenikfe'lets pe' wekwek. Qa nite' hamik'ui iye qu' nafaakan pe'ye' qe hayiits ƚenikfe'lets pa'qu' nafaakantaxij. Qa hik ta'ƚijupi' yekheweli'ƚ in nite' k'eqeku'uƚij in ƚataƚiiha pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ha' Jesús qa yeku'ƚ: —¿Ye' me hats nite' ƚeqeku'uƚik'i? ");
INSERT INTO mca_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ek'en qeku'ni'ƚek, na' ƚahats'ij hats nek, qa hats nam, ekheweli'ƚ qa anak'esi'ƚkii. Week ewiƚei ekheweli'ƚ qu' ilati'ƚiikii pekhewe' ewhi'wetitsi'ƚ, ma' qa' yeƚ'ewiiƚe'kii qu' etswu'mi'ƚi'. Qa nite'ƚe yeƚ'ewi'ƚkii na' Tata hik nakha' qu' na'nyijup. ");
INSERT INTO mca_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ekewe'en hats week k'efeli'ƚi'm hats'inha in ƚatsjayani'ƚha qa' nikesimenƚekii pe' atawjetsi'ƚ. Ha'ne sehe' ipji' qi qu' nana'l pe'qu' aats'e'eƚij, qa' yape'enhaƚe imeheti'ƚji' qu' e'ƚe'sitsi'iƚi'mkii, yakha' hats tsaxij ha'ne week sehe' ipji'.— ");
INSERT INTO mca_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ha' Jesús in yili'ij in yit'ij ekewe' wekwek, qa yejeƚetspha'm ha'ne wa's, qa yit'ij: —Tata, hats yamets ƚahats'ij. Yape iwqinhetji' ha'ne oqwomehe', hats'inha ji'jek ha'ne oqwomehe' qa' newqinhetji'ijji' ek. ");
INSERT INTO mca_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Akha' ƚetisij ha'ne oqwomehe' na' ƚet'unha'xipji' ene' week jukhew qa efuts iye, hats'inha qa' netisij na' witiƚa'x nite' yili'ij week ne' hats ƚetisij. ");
INSERT INTO mca_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ha'ne witiƚa'x nite' yili'ij, hane'en, qu' nenikfe'l ewets in eƚ'ewi'ƚƚe in e'yijaa'ija in o' Dios, qa qu' nenikfe'lets iye ha'ne Jesucristo in hik ha'ne ƚenukinju'. ");
INSERT INTO mca_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yakha' qi in k'ewqinhetjiha ha'ne sehe' ipji' qa week haqsiijkii qa tsaqhat'etsij kekhewe' ƚanyaji'ij yiwets qu' haqsiijkii. ");
INSERT INTO mca_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Qa hane'ej, Tata, etsiwqinhetji' qa' je'weeke' qu' jineniwqinhetji', qa' esƚisij kakha' hayiits yuk'eji' in ha'n ejup in mexe ham ha'ne week sehe'. ");
INSERT INTO mca_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yakha' hikfelit ewets pa'n ejunye'j nekhewe' ƚesƚisij ha'ne sehe' ipji'. Nekhewe'en ƚantsat'etstaxij qa ƚesƚisƚi'ij, nekhewe'en qa tek'enik'iha eke' e'lijei. ");
INSERT INTO mca_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hane'ej hats nikfe'lets in week eke' ƚesƚisij in akha' ta'ƚ ewets. ");
INSERT INTO mca_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yakha' henfeli'm ekewe' wi'tlijei ƚesƚisij, ma' qa t'eku'miju'ƚ, qa hats nikfe'lets in yijaa'ija in hata'ƚ ei, qa nite' yeqeku'uk'i iye in akha' ƚets'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yakha' k'iyinij ei enewe'en, qa nite' k'iyinij ei ha'ne week sehe' ipji', qe uja'xƚe yijat'ij enewe' hats ƚesƚisij, qe ƚantsat'etsij. ");
INSERT INTO mca_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Qa week nekhewe' tsatsat'etsij, akha' ƚantsat'etsij iye. Qa nekhewe' ƚantsat'etsij qa tsatsat'etsij iye. Qa yakha' qa heyiwqinhetiiji' qe ta'ƚets nekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yakha' hats nite' ha'nipji' ha'ne sehe' ipji', qa nekhewe'ƚe'en qa mexe amaneyi'ipji' ha'ne sehe' ipji', qa yakha'ƚe qa' hats natsam ei. Qi ƚe'wis Tata, jeƚinenijetsha na' ƚet'unha'x aka' ii, hik aka' ƚesƚisij, hats'inha qa' week ewi'ƚ pa'qu' ƚunyejeye', in injunyejeyek in ewi'ƚ kakha' injunyejei. ");
INSERT INTO mca_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","In mexe ha'nijup nekhewe'en ha'ne sehe' epji', qa qi in hejeƚetsha hit'iji' aka' iiji', hik aka' ƚesƚisij ƚet'unha'x ka' ii. Qa ham pa'qu' ewii'ƚe' nekhewe'en qu' uƚ'axe'ju', ewi'ƚƚe nakha' hats ƚa'sƚe na' witwuƚ'eye'jju' qe qa' nafits kakha' yit'ij kekhewe' hats we'nika'ajji'. ");
INSERT INTO mca_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Qa ha'neƚi'ij qa' hats natsam ei na' ƚa'ni', qa aka'an qa hik aka' henfel in mexe ha'nipji' ha'ne sehe', hats'inha qu' nana'l jii'mek nekhewe'en qu' hik ƚunye'je' na' qi yisa'xi'mkii. ");
INSERT INTO mca_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yakha' hats hetisij enewe'en ke' e'lijei, qa ha'ne sehe' ipji' qa qi in napjaxi'm enewe'en, qe enewe'en nite' yatsat'etsipji' ha'ne sehe' ipji', in yijunye'jek yakha' in nite' yatsat'axyipji' ha'ne sehe' epji'. ");
INSERT INTO mca_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nite' k'iyinij ewets enewe'en qu' ilithinik'ui ha'ne sehe' ipji', k'iyinij ewets yijat'ij qu' jeƚijets nakha' uƚ'ax. ");
INSERT INTO mca_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Enewe'en nite' yatsat'etsipji' ha'ne sehe' ipji', in yijunye'jek iye yakha' in nite' yatsat'axyipji' ha'ne sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Eqethenfik'iha nakha' yijaa'ija, eke' e'lijei hik ekewe' nakha' yijaa'ija. ");
INSERT INTO mca_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","In ƚunye'jek in ƚets'ukinetsju' ha'ne sehe' ipji', qa yakha' jeek iye in hukinijkii enewe'en qu' nakijik'i' ha'ne week sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Enewe'en in ta'ƚets, yakha' qa he'neni'ha in haqsiijkii week pa'qu' isu'un, hats'inha qa' hatsƚe ye'weeki'iƚij enewe'en qu' ne'nenjiiha' ek. ");
INSERT INTO mca_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nite' uja'xƚe enewe'en qu' nek'iyinij ewets, qe k'iyinij ewets iye pekhewe' qu' netk'en yiwets iye hatse' qu' nata'ƚets pe'qu' ƚe'lijeye' enewe'en, ");
INSERT INTO mca_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","hats'inha qu' weeke' qu' hik ƚunyejeye' qu' ewi'ƚe'. In ejunye'jek akha', Tata, in ƚa'nyit ji'teje'mha qa yakha' qa ha'nji'ij etji'teje'mha ek, enewe'en qu' nanji'ij initji'teje'mha ek, hats'inha ha'ne week sehe' ipji' qu' nite' neqekuyi'ik'i in akha' ƚets'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kakha' yisa'x ƚesƚisij hats hetisij enewe'en, hats'inha qu' hik ƚunyejeye' qu' ewi'ƚe', in injunyejeyek in ewi'ƚija ka' injunyejei, ");
INSERT INTO mca_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","aka'an ikji' yakha' ha'nji'teje'm enewe'en qa akha' qa ƚa'nyit ji'teje'mek, hats'inha qa' hik ƚunyejeyi'ija qu' ewi'ƚe', ma' qa ha'ne week sehe' epji' qa' nenikfe'letsha in akha' ƚets'ukinju' qa' nenikfe'letsha iye in qi in ƚisu'un enewe'en in ƚunye'jek in qi in ƚetsu'un. ");
INSERT INTO mca_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, hisu'un enewe' ƚesƚisij qu' na'nyijupkii week pa'qu' ha'ni', hats'inha qu' ni'wenija nakha' yisa'x, nakha' yisa'x ƚesƚisij, qe qi'ija in hayiits ƚetsu'un in mexe ham ha'ne week sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yatsathen Tata, ha'ne week sehe' ipji' in nite' nikfe'l ewets, qa yakha'ƚe qa tsikfe'l ewets, qa enewe'en qa nikfe'lets in akha' ƚets'ukinju'. ");
INSERT INTO mca_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yakha' hikfelit ewets enewe'en, qa nite' hili'ij qu' hikfelit ewetskii, hats'inha nakha' e'qsu'unka'x, nakha' ƚetsit'iji in ƚetsu'un qa na'nji'ju' enewe'en qa yakha' qa' ha'nji'teje'm iye.— ");
INSERT INTO mca_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ha' Jesús in yili'ij ekewe'en in iyinijii pa' ƚatata, ma' qa iki'ƚkii he' ƚ'ijatshenhei qu' namiiteje'm ha' ƚajaika' ai hakha' kimi'ik'i ƚ'ikheyi'j na'aj iweli' ƚii Cedrón, hikha' i'ni' ha' wit'enekju' najkaket, qa hikha' qa i'ni'ƚi' ha' Jesús qa he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ka' Judas, kakha' t'ihinij ha' Jesús, nikfe'lii hakha' najkaket, qe hats olotsij qa i'njiiƚi' he' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ma' qa ka' Judas qa ƚijts'eyek hekhewe' ewi'ƚ tup'uje'm (grupo) he' hik ƚunyejei oq'opheƚinetsilets witeqjeƚinenheyij ke' qi witlijtsitjii qa hekhewe' uja'x tenek'enhei judiol, nukin hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye fariseol. Ma' qa neka'x he' ƚek'ul qa he' ƚefetitjiyits qa ke' ƚaqapjuyititsijup pha'm yenji' ke' najak (antorchas). ");
INSERT INTO mca_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Qa ha' Jesús in hayiits week nikfe'lets kakha' ƚunye'jkii, qa ikiju'ƚ, qa nifaakan: —¿Ƚekpa' ƚowo'oƚiikii?— ");
INSERT INTO mca_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hekhewe'en qa yeku'ƚ: —Pa' Jesús, Nazaret ƚeiƚe'.— Jesús qa yit'ij: —Yakha' inek.— Qa ka' Judas, kakha' t'ihinij ha' Jesús, i'nji'teje'm hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ha' Jesús in yit'ij: —Yakha' inek— qa week t'oqoyik'uikii qa namiju'kii sehe' hekhewe'en. ");
INSERT INTO mca_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ha' Jesús qa ewi'ƚij iye in nifaakan: —¿Ƚekpa' ƚowo'oƚiikii?— Hekhewe'en qa yit'ijju' iye: —Pa' Jesús, Nazaret ƚeiƚe'.— ");
INSERT INTO mca_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Qa ha' Jesús qa yeku'ƚ iye, qa yit'ij: —Hats inek hi'ttaxi'ƚij ewets yakha' inek. Qu' yakha'ye' pakha' ƚowo'oƚiikii, qa' iwejinƚi'iƚ qu' nakkii enewe'en.— ");
INSERT INTO mca_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aka'an hik aka' ƚunye'jkii in yafits kakha' hayiits yit'ij ha' Jesús in yit'ij: —Tata, enewe' ƚesƚisij ham pa'qu' ewii'ƚe' qu' natsqamij.— ");
INSERT INTO mca_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma' qa ha' Simón Pedro, hikha' na'li'm ha' ƚaqa'tsjikinet, qa nit'ijpha'm qa yifekinij je'm hakha' ƚeqejkunenek ha' qiji' pa'il ƚatata, qa yasinii qa k'itsji' ke' yiya'yik'i te'weiji' ƚekfi'ik'i, ha' witqejkunenek ƚii Malco. ");
INSERT INTO mca_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ha' Jesús qa yit'ijets ha' Pedro: —Ukinik'iju' iye na' ƚejii na' aqa'tsjikinet. Na' Tata in tseƚisij qu' nek'iyaji' na' qi ek'imiiji', ¿me qa' nite' nek'iya'ye'ji'?— ");
INSERT INTO mca_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ma' qa hekhewe' ewi'ƚ tup'uje'm (grupo) he' hik ƚunyejei oq'opheƚinetsilets witeqjeƚinenheyij ke' qi witlijtsitjii, qa hakha' iye yejeƚijipji' hekhewe'en (comandante) qa hekhewe' iye tenek'enhei judíos, qa t'eku'mi' ha' Jesús qa yophe'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma' qa yojo in yeka'xii ha' Anás, qe hikha' ƚeqewket ha' Caifás, qiji' pa'il ƚatata kakha' ininqa'pji'. ");
INSERT INTO mca_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ha' Caifás hik hakha' yit'ijji'ju' hekhewe' judiol qu' les qu' ƚe'wise'ju' qu' ewi'ƚe' pa'qu' jukhew qu' nawa'mifi ha'ne witset. ");
INSERT INTO mca_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ha' Simón Pedro yijayanpha'mkii ha' Jesús in wetka'x qa hakhap iye ƚ'ijatshenek. Hik ha'ne ha' nikfe'li'ƚ wetju'ƚ hakha' qiji' pa'il ƚatata, qa hik ta'ƚijupi' in ƚeke' in yijayanetsji' ha' Jesús hakha' jofji'ju' ke' ƚetsi' ha' pa'il ƚatata. ");
INSERT INTO mca_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Qa hakha'ƚe Pedro qa amanfik'i ha' ƚeji'ii. Qa hakha' wit'ijatshenek nikfe'lij ha' qiji' pa'il ƚatata, qa tepiliifik'i iye qa tafaakate'yi'ƚ ke' yejeƚ ha' ƚeji' ma' qa yuihinteje'm iye ha' Pedro. ");
INSERT INTO mca_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ma' qa ke' witqejkunenki' yejeƚ ha' ƚeji', qa nifaakan ha' Pedro: —¿Me nite' hik akha' ha' ewi'ƚ hekhewe' ƚ'ijatshenhei hakha' jukhew?— Ha' Pedro qa yeku'ƚ: —Nite'. Nite' yakha'.— ");
INSERT INTO mca_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","In k'ui qa hekhewe' ƚeqejkunenhei qa he' witeqjeƚinenheyij ke' witlijtsitjii qa niƚani' ka' ƚefet qa t'aƚets. Qa ha' Pedro qa ts'ap'a'ajup i'nji'teje'm hekhewe'en t'aƚets iye ka' fe't. ");
INSERT INTO mca_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ma' qa ha' qiji' pa'il ƚatata qa nifaakanij ha' Jesús in t'ejuyets hekhewe' ƚ'ijatshenhei qa ke' yijatshenij iye. ");
INSERT INTO mca_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ha' Jesús qa yeku'ƚ: —Yakha' in k'iyet nite' hanat'inijik'uikii ene' weekji', k'inq'ijatshenjiifi nekhewe' ƚe'lijtsitjiyits ene' judiol qa k'inq'ijatshenjiifi iye nekhe' qi witlijtsitjii, hik nakha' ƚothewet ne' week judiol, qa ham pakha' qu' hit'ij qu' hanat'inijkii. ");
INSERT INTO mca_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Inhats'ek in yakha' in ƚatsfaakan? Anfaakan yijat'ij hekhewe' tsepi'ye'ej kekhewe' k'iyetij, hik enewe' nikfe'lets kekhewe' hit'ij.— ");
INSERT INTO mca_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ha' Jesús in yit'ij aka'an, ma' qa ha' ewi'ƚ hekhewe' witeqjeƚinenheyij ke' qi witlijtsitjii qa yilanje'm ƚeju's, qa yit'ij: —¿Me hik aka' pa' i'nanye'j qu' jinteku'ƚ ha'ne qiji' pa'il ƚatata?— ");
INSERT INTO mca_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ha' Jesús qa yeku'ƚ: —Qu' uƚ'axe'ju' pa'qu' hit'ij, enfel ye'm pakha' uƚ'axju' in hit'ij, qa qu' ƚe'wise'ƚeju' in k'iyet, ¿qa inhats'ek in ƚaslan?— ");
INSERT INTO mca_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ma' qa ha' Anás qa inaqyaji'ij qu' newetka'xii ha' Caifás, qiji' pa'il ƚatata, ha' Jesús wo'nophe'ƚ he' ƚokoyei. ");
INSERT INTO mca_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ha' Simón Pedro ts'ap'a'ajup ka' fe't, t'aƚets, ma' qa titijiti'yijets: —¿Me nite' hik akha' iye hekhewe' ƚ'ijatshenhei hakha'an?— Ha' Pedro qa welkut'ijkii, qa yit'ij: —Nite', nite' yakha'.— ");
INSERT INTO mca_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ha' ewi'ƚ hekhewe' ƚeqejkunenhei hakha' qiji' pa'il ƚatata, hik hakha' ha' ƚejefe hakha' k'istaxii ke' ƚekfi' yifekinii ha' Pedro, hakha'an qa yit'ijets iye ha' Pedro: —¿Me nite' hik akha' k'eweni' hakha' wit'enekju'ui najkaket, in ijts'ekii hakha'an?— ");
INSERT INTO mca_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ha' Pedro qa ewi'ƚij iye in welkut'ijkii iye, ma' qa hik aka'aj qa ip pa' ta'a'a'. ");
INSERT INTO mca_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma' qa wetka'xik'uifik'i iye ha' Jesús ke' ƚetsi' ha' Caifás, qa wetka'xii ke' wititsi' ƚii pretorio, Roma ƚakha', i'nifi ek hakha' judiol tenek'enhe'yipji' Roma ƚeiƚe' (gobernador). Mexe leefiju', he' judiol qa nite' uyetsji' ke' wititsi' pretorio, qe tit nuyetsji' ma' titha hats hik ƚunyejeye' qu' netjilii in mexe ƚe'sits pe' neƚuts, qa' nite' ƚeke'ye' qu' na'nij ji'teje'm pakha' witkujiiji' pe' ƚe'sits neƚuts Pascua. ");
INSERT INTO mca_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Qa hik ta'ƚijupi' ha' gobernador Pilato in iketsfik'i hekhewe'en, qa yit'ijji'ju': —¿Pa'n ƚunye'j pa' uƚ'ax yaqsiijkii ha'ne jukhew qa ƚenka'xi'ƚmet?— ");
INSERT INTO mca_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hekhewe'en qa yeku'ƚ, qa yit'ijju': —Qu' nite' uƚ'axe' ha'ne jukhew qekha nite' henka'xe'taxi'ƚ ei qu' k'eƚisiƚij.— ");
INSERT INTO mca_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma' qa ha' Pilato qa yit'ijets iye: —Eka'xi'ƚ nakha'an qa' it'iƚiji' pa' hats ƚ'anye'j pa' eqe leyi'ƚ qu' ekhewele'ƚi'iƚij qu' itanitheni'ƚij nakha'an pa' yaqsiijkii.— He' judiol qa yeku'ƚ iye: —Yekheweli'ƚ in ye'judioli'ƚ nite' ƚenexkeli'ƚij ye'm qu' hilani'ƚ pa'qu' jukhewe'.— ");
INSERT INTO mca_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aka'an in ƚunye'jkii qe qa' nafits kekhewe' ƚe'lijei ha' Jesús in iyetij qa yeqethenik'iha pa'n qu' ƚawamhinye'je' hatse'. ");
INSERT INTO mca_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ma' qa ha' Pilato qa uyifi iye kekhe' wititsi' pretorio, qa taya'yets ha' Jesús, ma' qa wetka'xetsji', qa yit'ijets: —¿Me hik akha' pakha' qi ƚatata ene' judiol?— ");
INSERT INTO mca_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ha' Jesús qa yeku'ƚ: —¿Me akha'ƚe qu' it'ij aka'an? ¿Me i'nƚi'i qu' nata'ƚƚe'ets qu' nit'ij ewets pekhewepe' qu' yakha'ye'?— ");
INSERT INTO mca_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ha' Pilato qa yeku'ƚ iye: —¿Ye' me yakha' ye'judio? Ene' ejefets qa nekhewe' iye tenek'enhe'yij ne' pa'il tseƚis ej. ¿Pa'n eqfenye'j ewek pa'aj?— ");
INSERT INTO mca_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ha' Jesús qa yeku'ƚ: —Na' heinek'enhe'yi' nite' ha'ne sehe' ipji'. Qe qek hik ha'neyi'i' ha'ne sehe' ipji' na' heinek'enhe'yi', ma' qa nekhewe' tsijayan qekha nawatlantaxyipji', qekha nite' niwejinetaxij ne' judiol in t'eku'myi'. Qa nite'ƚe hik ha'ne i'ni'in nakha' heinek'enheiji'.— ");
INSERT INTO mca_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma' qa ha' Pilato qa yit'ijets: —¿Ye' me akha' e'wittata?— Ha' Jesús qa yeku'ƚ iye: —Ƚ'asiinik'iha ka' ƚit'ij in yakha' ye'wittata. Qa hik ta'ƚijupi' in tsekfik'i qa hik ta'ƚijupi' iye in tsametsju' ha'ne sehe' ipji', qe qa' henfel na' yijaa'ija. Qa week nekhewe' hats i'nji'teje'm na' yijaa'ija, qa tek'en yiwets.— ");
INSERT INTO mca_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ha' Pilato qa yit'ij: —¿Pakhana's qu' ƚunye'je'kii pa' yijaa'ija?— In yit'ij aka'an, ma' qa uyetsfik'i iye hekhewe' judiol, qa yit'ijji'ju': —Ham hi'wene' pa'qu' uƚ'axe' qu' ƚunye'je' hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Qa na'lƚe ka' hayiits eqfenyejeijii'ƚ ewek qu' yakha'ye' qu' hiwejinji'ij pa'qu' ewi'ƚe' wit'opheƚik'e' qa yamji'jets ene' ƚe'sits neƚutsji' Pascua. ¿Me ƚisu'uni'ƚ qu' hiwejin ha'ne qi ƚatata ne' judiol?— ");
INSERT INTO mca_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma' qa ewi'ƚij iye in week tayai wetju'ƚ, qa yit'ijju': —¡Hasu'uj iwejin nakha'an! Hakha' yijat'ij Barrabás qu' iwejin.— Ha' Barrabás hikha' qi in uƚ'ax ejtenhetsax. ");
INSERT INTO mca_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ma' qa hik ta'ƚijupi' ha' Pilato qa inaqyaji'ij qu' neteqsilanhetiikii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Qa he' oq'opheƚinetsilets qa yiftii ke' tii qa yiwataninij ha' Jesús, qa yi'ntaafinij iye ka' witpalinek'ij penyilo. ");
INSERT INTO mca_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hekhewe'en qa ikets, qa yit'ijets: —¡Pakhaaye'ƚi'ij qu' ƚunye'je' ha'ne ƚatata ne' judiol!— Qa yeqsilanje'mkii ƚeju's. ");
INSERT INTO mca_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ha' Pilato qa wapiletsfik'i iye he' jukhew, qa yit'ijji'ju' iye: —Jeƚ qeku'ni'ƚek, hane'ej qu' henka'xi'ƚ ewetsfik'i qa' i'weni'ƚ hats'inha qa enikfe'li'ƚetsha in ham hi'wene' pa'qu' uƚ'axe' qu' ƚunye'je' hakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ma' qa ha' Jesús qa nekfik'i wenuihinji'ju' ƚejiƚa' ke' tii weniftii qa weni'ntaafinij ka' witpalinek'ij penyilo. Qa ha' Pilato qa yit'ijji'ju': —¡Hane'en hakha' jukhew!— ");
INSERT INTO mca_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma' qa in yi'wentax hekhewe' tenek'enhe'yij he' pa'il qa hekhewe' iye witeqjeƚinenheyij ke' qi ƚe'lijtsitjii, qa taya'yijipji', qa yit'ijju': —¡Eni'ƚji'pha'm cruze'! ¡Eni'ƚji'pha'm cruze'!— Qa ha' Pilato yit'ij: —Eka'xi'ƚ qa' eni'ƚji'pha'm pe'qu' cruze'. Qe yakha' ham hi'wene' pa'qu' uƚ'axe' qu' ƚunye'je' nakha'an.— ");
INSERT INTO mca_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","He' judiol qa yeku'ƚ: —Yekheweli'ƚ na'li'ƚ ye'm ka' yeqe leyi'ƚ, qa kakha' ƚ'anye'j nakha'an qa hikka' ta'ƚets in les ƚe'wis qu' nawa'm, qe yit'ij ƚetets in Ƚa's pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ma' qa ha' Pilato in yepi'ye' ek'i aka'an, ma' qa les qi'ija in nijiwei. ");
INSERT INTO mca_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Qa wapilijifi iye ke' wititsi' pretorio qa yit'ijets ha' Jesús: —¿Pa'n ƚataƚji'ha?— Qa hakha'ƚe Jesús qa nite' yeku'ƚ. ");
INSERT INTO mca_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma' qa ha' Pilato qa yit'ijets: —¿Me nite' ƚesku'ƚ? ¿Me nite' ƚenikfe'l yiwets in na'l ye'm pa' yit'unha'x in heinek'enhei qa ƚeke' qu' k'ewejin, qa na'l ye'm iye pa' yit'unha'xijup qu' nek'inaqyaji'ij qu' enhetiiji'pha'm pe'qu' cruze'?— ");
INSERT INTO mca_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ha' Jesús qa yeku'ƚ: —Ham pa'qu' et'unha'xe' in ƚ'enek'enhei qu' nite' neƚisi'ij na' Dios. Qa hik ta'ƚijupi' pakha' ta'ƚets in heyestii ej, pakha'an les qi wiikfik'i pa' ƚewuƚ'ax.— ");
INSERT INTO mca_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ma' qa hik aka'aj ha' Pilato qa wo'taxiikii pa'qu' ƚeqfenye'ji'ij qu' niwejin ha' Jesús. Qa hekhewe'ƚe judiol qa taya'yijipji'kii iye, qa yit'ijju': —Qu' iwejin hakha'an ma' qa hats nite' ejuwaika' pa' qiji' Roma ƚatata (César). Week pa'qu' naqsi'jƚetaxijkii qu' qiye' qu' wittatayi'ij, ma' qa hats t'ejuyiju'ƚ pa' qi Roma ƚatata.— ");
INSERT INTO mca_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ma' qa ha' Pilato in yepi'ye' ek'i aka'an, qa inaqyaji'ij qu' netetkaxetsfik'i ha' Jesús. Ha' Pilato qa i'nipji' ha' ƚots'oji'la'x t'ejuyets in hik ƚunye'j qu' jueze', i'ni' hakha' ts'eewe'epji' ha' joofji'ju' ƚanfaakanhe'wet'ij ƚenqii Utel Yaqamax, ke' hebreo qa yit'ijek Gabata. ");
INSERT INTO mca_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hik kakha' ka' neƚuji' watji'letji' ne'ej wekwek qu' net'ejuyets kakha' ƚe'wis neƚu Pascua, qa hats natsathenju' junu'. Ha' Pilato qa yit'ijji'ju' hekhewe' judiol: —Hane'en hakha' atata'aƚ.— ");
INSERT INTO mca_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma' qa taya'yijipji' iye hekhewe'en, qa yit'ijju': —¡Ilaani'ƚha! ¡Ilaani'ƚha! ¡Eni'ƚji'pha'm cruze'!— Ha' Pilato qa yit'ijji'ju': —¿Me ƚisu'uni'ƚ qu' henji'pha'm pe'qu' cruze' ha'ne qi atata'aƚ?— Qa he' tenek'enhe'yij he' pa'il qa yeku'ƚ: —Yekheweli'ƚ ham pakhape' iye qu' wittatayi'iƚ yipji', ewi'ƚƚe pa' qi Roma ƚatata.— ");
INSERT INTO mca_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma' qa hik ta'ƚijupi' ha' Pilato in tisij hekhewe'en, hats'inha qu' ne'nenji'pha'm pe'qu' cruze'. ");
INSERT INTO mca_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma' qa wetka'x ha' Jesús. Ha' Jesús qa ikijfik'i in yeka'x ke' ƚeqe cruz, qa' namijii hakha' sehe' ƚenqii witjiƚa'ak'i ƚetset, ke' hebreo qa yit'ijek Gólgota. ");
INSERT INTO mca_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma' qa hik hakha'a' qa yenji'pha'm ke' cruz, qa wetsjuk iye ke' ƚenenhefetsji'pha'm ke' cruzits hakha'an, ewi'ƚ ka' te'weyij yiya'yik'i qa kakhap qa ƚefeyi'j te'weyij, ha' Jesús qa ƚeqewuk'u te'weiji'. ");
INSERT INTO mca_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ha' Pilato yika' iye ka' ewi'ƚ k'eewe qa yenipji' ke' cruz. Ka' we'nika' yit'ij: —Jesús Nazaret ƚeiƚe', qi ƚatata ene' judiol.— ");
INSERT INTO mca_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ma' qa olots he' judiol yiyinenik'i ka' we'nika'ajji', qe hakha' we'neni' in we'nenji'pha'm ke' cruz meti'm ha' witset. Qa ka' ƚe'nikahat qa we'nika'ajji' kekhewe' wi'tlijei hebreo, ke' latín qa ke' griego iye. ");
INSERT INTO mca_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Qa hik ta'ƚijupi' he' tenek'enhe'yij he' ƚaqa pa'il enewe' judiol, qa yittaxijets ha' Pilato: —Hasu'uj ika'ajji' qu' nit'ij: “Qi ƚatata ene' judiol.” Ika'ajji' yijat'ij: “Hane'en yit'ij: Yakha' qi ƚatata ene' judiol.”— ");
INSERT INTO mca_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Qa ha' Pilato qa yit'ij: —Pakha' qu' hats hika'ajji', qa hats hika'.— ");
INSERT INTO mca_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma' qa hekhewe' oq'opheƚinetsilets in hats yenji'pha'm ke' ƚeqe cruz ha' Jesús, qa t'eku'mi' ke' ƚeqhinatai ma' qa yak'esa'xju'kii yit'ij cuatsuju' in yak'esa'xju'kii, qa weju'ƚji' he' ikwetju'ƚ (4) oq'opheƚinetsilets, qa t'eku'mi' iye ka' te'weiju' yamik'iju' ƚ'uihitjii, qa kakha' te'weiju' yamik'iju' ƚ'uihitjii qa ham ƚentiƚititse', itupi'le'ƚe in wetƚii. ");
INSERT INTO mca_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Qa hik ta'ƚijupi' hekhewe' oq'opheƚinetsilets in yit'ijju': —Hasu'uj jitawjaf'itju' hane'en qu' jinawatk'esa'xijju' iye, ju'ukij wetju'ƚ yijat'ij qa' jutsiqaxe' pa'qu' nitupilen.— Aka'an in ƚunye'jkii qe qa' nasinik'iha ka' hats we'nika'ajji' qu' ƚunyejeye'kii in yit'ij: —Wetjeyumtshenij qa watk'esaxijju' ke' yeqhinatai qa ikij wetju'ƚ iye kakha' yeqhinawat.— Aka'an hik aka' yaqsiijkii hekhewe' oq'opheƚinetsilets. ");
INSERT INTO mca_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hakha' i'ni' ke' ƚeqe cruz ha' Jesús, qa metifi ke' ƚenene qa ke' ƚejefeki'ƚe ke' ƚenene, qa ke' María ƚewhe'ye' pa' Cleofas, qa kikhe' iye María Magdalena (Magdala ƚeiƚeki'). ");
INSERT INTO mca_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma' qa ha' Jesús in yi'wen ke' ƚenene qa hakha' iye ƚ'ijatshenek hikha' qi in yisu'un ts'ap'a'afi iye ke' ƚeqe cruz, qa yit'ijets ke' ƚenene: —Efu, nakha'an ha' oqwomehe'.— ");
INSERT INTO mca_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Qa yit'ijetsek iye ha' ƚ'ijatshenek: —Nekhe'en ke' enene.— Ma' qa hik aka'aj ta'ƚi' hakha' ƚ'ijatshenek qa yejeƚetsha qa yeka'xii ke' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma' qa i'nk'aƚe pa'aj, ha' Jesús in hats nikfe'lets in hats week qu' nafits pa' ƚunye'jkii, ma' qa qu' hats nafits'ija kekhewe' we'nika'ajji' pa'aj, qa yit'ij: —Ts'iyayu'.— ");
INSERT INTO mca_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na'li' hakha'a' ke' ewi'ƚ kamusi ƚasi' topo'oj ka' wino na'aj etsik'iiji' (vinagre), ma' qa yenji' ka' ewi'ƚ tutsi'latax ta'ƚets ne'ej ƚii isopo ke' ewi'ƚ hik ƚunye'j jupayek (esponja) wenilke' ijetsju' ka' wino etsik'iiji' ma' qa yilke'ejiipha'm ha' ƚeji'. ");
INSERT INTO mca_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Qa ha' Jesús in hats tu'fij ka' we'nilke'ejetspha'm wino, qa yit'ij: —¡Hats uja'xƚe!— Ma' qa nososjo', qa wa'm. ");
INSERT INTO mca_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma' qa hekhewe' judiol, kakha' neƚuji' in mexe qu' nawatjiletji' pe'qu' wekweke' t'ejuyets kakha' neƚuji' sábado, qa nite' yisu'un qu' amaneye' ji'pha'm pe'qu' witlanheye' pe'qu' ƚeqe cruzitse' in yamets kakha' witwapiihijii, qe kakha' witwapiihijii kakha'an les in qi in yiwqinhetji'ha. Qa hik ta'ƚijupi' in iyinijets ha' Pilato qu' ninaqyaji'ij qu' natlanhetiiju' ƚekumkenetits week hekhewe' we'nenji'pha'm ke' cruzits, ma' qa' netenit'ijju'. ");
INSERT INTO mca_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma' qa he' oq'opheƚinetsilets qa ikii qa nilanju' ke' ƚekumkenetitsik'i ka' yojo qa kakhap iye kekhewe' ƚenenhefetsji'pha'm ke' cruzits ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Qa in yamtaxets ha' Jesús, qa yi'wen in hats wa'm, ma' qa nite' nilanju' he' ƚekumkenetits. ");
INSERT INTO mca_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ƚa'mek hakha' ewi'ƚ he' oq'opheƚinetsilets qa ti'jijetspha'm ƚe'weƚi' ka' ƚeqilkenet leeseji', qa aje'eƚ t'ilitfik'i ke' ƚ'athits qa ka' iweli' iye. ");
INSERT INTO mca_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nakha' yi'wenij ekewe'en qa nifelkii, qa kekhewe' nifelkii qa yijaalija. Qa nakha'an nikfe'lets iye kekhewe' yit'ij in yijaalija, hats'inha qu' ekhewele'jiiƚek qu' nite' eqeku'yi'iƚik'i. ");
INSERT INTO mca_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Qe aka'an in ƚunye'jkii qe qa nafits kekhewe' hayiits we'nika'ajji' pa'aj in yit'ij: —Nite' ewii'ƚe' pa'qu' netenepƚet pe' ƚenuts.— ");
INSERT INTO mca_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qa kakhap iye we'nika'ajji' qa yit'ijek: —Yejeƚijju' hatse' pekhewe'en pakha' ƚanajkanewe'j.— ");
INSERT INTO mca_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","In hats naxijik'i ekewe' wekwek, ma' qa ha' José, Arimatea ƚeiƚe', hakha'an tek'entaxets iye ha' Jesús qa nite'ƚe jumumij qe nijiweyiju'ƚ hekhewe' judiol. Ha' José qa iyinijets ha' Pilato qu' netisij qa' neka'x ka' Jesus'ik'i. Ha' Pilato qa ƚexke'ej qu' neka'x. Ma' qa ha' José qa ikii ka' Jesus'ik'i qa yeka'x. ");
INSERT INTO mca_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Qa hakha' iye Nicodemo, hikha' nekii ka' ewi'ƚ naja'x ha' Jesús qu' natfaakate'yi'ƚ. Neka'x ke' treinta (30) kilos yamets ke' mirra yetsjiƚiƚ ke' áloe. ");
INSERT INTO mca_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ma' qa t'eku'mifi wete'm ka' Jesus'ik'i yijuphe'ƚji' ka' ƚe'wis penyilo qa hatsƚe yefulutipji' kekhewe' wanaqfi'j ƚesejets ewjisii mirra qa ke' áloe, qa in ƚeqfenyejeyijek ka' hats ƚeqfenyejeyij ne' judiol qe yenifi ne'ej ƚesehek na'aj wa'm. ");
INSERT INTO mca_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ha' i'ni' in we'nenji'pha'm ke' cruz, meti'm ha' najkaket qa hikha' i'ni' ke' ewi'ƚ witnimeƚuk ink'aiki', mexe ham we'neni'ifi. ");
INSERT INTO mca_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma' qa hikke' qa we'nenifi ka' Jesus'ik'i qe les in met, qe hats k'esets qu' nanaxijik'i kakha' neƚu ma' qa' hats namets kakha' ƚawapiihijii ne' judiol. ");
INSERT INTO mca_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ka' yojo neƚuji' kakha' semana (domingo) leefiju', ke' María Magdalena mexe nookii pa'aj in ikii ke' nimeƚuk. Qa yi'wen pa'aj ke' qi ute in hats tenit'ijji' in ƚit'otaxij ke' nimeƚuk. ");
INSERT INTO mca_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma' qa wekuma'xii ha' i'ni' ha' Simón Pedro qa hakhap iye ƚ'ijatshenek, hakha' qi yisu'un ha' Jesús, qa yit'ijets: —Wetka'xik'uifik'i pa'aj ke' ƚesehektax ka' Yatsat'ax'inij, qa nite' tsikfe'li'ƚets pa'n qu' ne'neni'.— ");
INSERT INTO mca_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ha' Pedro qa hakhap iye ƚ'ijatshenek qa yeeƚii ke' nimeƚuk. ");
INSERT INTO mca_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Enewe' wetsjuk wekuma'xii in yejeƚii. Qa ha' ewi'ƚ hakha' ƚ'ijatshenek qa les in we'niyitiiha qa yojo'ets in yamets ke' nimeƚuk qa i'nk'aƚe nafits'ii ha' Pedro. ");
INSERT INTO mca_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Qa t'upi'yijupju' in yejeƚtaak'iteje'm, qa yi'weniiji' ke' wetjuphe'ƚtaxji' ƚe'sits penyilots in i'ni' hakha'a', qa nite'ƚe uyetsji'ha. ");
INSERT INTO mca_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma' qa nafits'ii ha' Simón Pedro, qa uyetsji'ha ke' nimeƚuk. Qa yi'wen iye ke' wetjuphe'ƚtaxji' ƚe'sits penyilots in i'ni' hakha'a'. ");
INSERT INTO mca_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Qa ka' penyilo kakha' wenik'eihinƚi'ipji' ka' ƚeiƚa', qa nite' ewi'ƚ i'ni'ƚi' kekhewe' wetjuphe'ƚji' penyilots, qe kakha'an wetpephe'ƚik'i qa tujtseika' ha' i'ni'. ");
INSERT INTO mca_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ma' qa uyetsji'ek iye hakhap iye ƚ'ijatshenek, hakha' nojo'ets in namets ke' nimeƚuk, ma' qa yi'wen qa nite' yeqeku'. ");
INSERT INTO mca_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Qe in i'nk'aa'ija mexe nite' nikfe'ltaxik'iha kekhewe' hayiits we'nika'ajji' pa'aj, ha' Jesús in les ƚe'wis qu' iƚa'xe' iye. ");
INSERT INTO mca_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma' qa he' ƚ'ijatshenhei qa wapiliikii iye pe' ƚetsil. ");
INSERT INTO mca_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ke' María Magdalena qi in ipi' hakha' i'nfik'i ke' nimeƚuk'ii, qa in mexe ip qa t'upi'yijupju' in yejeƚifi ke' nimeƚuk. ");
INSERT INTO mca_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Qa yi'wen pa'aj pe' wetsjuk angelits fo' pe' ƚeqhinatai, i'nipji' pa'aj kakha' we'nenipji' ka' Jesus'ik'i. Ewi'ƚ pa' te'weyii ka' t'osiiji' qa pakhap qa te'weyiyek ka' t'efiiji'. ");
INSERT INTO mca_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pe' angelits qa yithinets pa'aj: —Efu, ¿inhats'ek in ƚap?— Kikhe'en qa yeku'ƚ pa'aj: —Qe wetka'x ka' Yatsat'axyij, qa nite' tsikfe'lets pa'n qu' ne'neni'.— ");
INSERT INTO mca_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","In hats yit'ij ekewe'en qa tetwek'elaxtax pa'aj qa yi'wen ha' Jesús in hats i'ntaxi' pa'aj hakha'a', qa nite'ƚe nikfe'lij in hik hakha'tax ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ha' Jesús qa yit'ijets: —Efu, ¿inhats'ek in ƚap? ¿Ƚekpa' ƚowotaxiikii?— Kikhe'en qa yumtiƚetax qu' hik hakha'ye' pa' yejeƚ hakha' najkaket, qa yit'ijets: —Jukhew qu' akha'ye' pakha' yeka'x ka' Jesus'ik'i, enfel ye'm pa' ƚekaxji' qa' howo'oikii qa' heka'x.— ");
INSERT INTO mca_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ha' Jesús qa yit'ijets pa'aj: —¡María!— Kikhe'en qa tetwek'elaxetsha pa'aj qa yit'iji' ke' ƚe'lijei ne' hebreo: —¡Raboni!— (Ikji' yaqa Maestro.) ");
INSERT INTO mca_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ha' Jesús qa yit'ijets pa'aj: —Etswejin qe mexe nite' haketspha'm qu' natsamii na' Tata. Yape ma, qa' enfelii hekhewe' hane'ej hats k'injatsij qa' it'ijets aka' yi'lijei: “Haketspha'm hatse' qa' natsamii na' Tata qa Atata'aƚ iye, na' yeqe Dios qa eqe Diosi'ƚ iye ekheweli'ƚ.”— ");
INSERT INTO mca_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ma' qa ke' María Magdalena qa ikii qa nifeli'm hekhewe' ƚ'ijatshenhei, qa yit'ijets: —¡Hats hi'wen ha' Yatsat'ax'inij!— Ma' qa yit'ijets kakha' hats ƚ'anye'jets pa'aj hakha'an. ");
INSERT INTO mca_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma' qa in hats najaleikii kakha' yojo neƚuji' ka' semana (domingo), hekhewe' ƚ'ijatshenhei qa ewi'ƚ i'ni' yijanithenji' he' ƚejil qe nijiwe'yik'uikii hekhewe' judiol. Ha' Jesús qa we'nethinets qa ts'ap'aji'ju' ƚeqewuk'u he' ƚ'ijatshenhei qa wetfeli'm, qa yit'ij: —Ƚe'sitsi'imkii ne' atawjetsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","In yit'ij aka'an qa yethinij he' ƚokoyei qa ha' ƚe'weƚi' iye. Qa hekhe' ƚ'ijatshenhei qa qi in ƚe'sitsi'mkii in yi'wen ha' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ha' Jesús qa ewi'ƚij iye in yit'ijji'ju' hekhewe'en: —Ƚe'sitsi'imkii ne' atawjetsi'ƚ. In ƚunye'jek na' Tata in ts'ukinju' qa yakha' qa' k'ukiniƚek.— ");
INSERT INTO mca_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Qa i'nk'aƚe in hats yit'ij ekewe'en, qa yifuyu ipji', qa yit'ijji'ju': —Na' Espíritu Santo qu' esti'yi'ƚij. ");
INSERT INTO mca_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pekhewe' qu' iwu'mi'ƚik'ui pe'qu' ƚewuƚ'etse', qa' hik pekhewe' qa' netwumhiti'yik'ui pe' ƚewuƚ'ets. Qa pekhewe' qu' nite' iwu'mi'iƚik'ui pe'qu' ƚewuƚ'etse', qa' hik pekhewe' qa' nite' netwumhitiyi'ik'ui pe' ƚewuƚ'ets.— ");
INSERT INTO mca_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ha' Tomás, hikha' i'nji'teje'm he' doce (12) ƚ'ijatshenhei, ƚenqii iye Wetsjukji', hakha'an nite' i'nji'teje'm hekhewe'en in we'nethinets ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma' qa hekhewep, hekhewe' ƚ'ijatshenhei, qa yit'ijets hakha'an: —¡Hi'weni'ƚ ha' Yatsat'ax'inij!— Qa ha' Tomás qa yit'ij: —Qu' nite' hi'wene' he' ƚokoyei in watlaniji' ke' kanalifi, qa qu' nite' huihini'ik'iju' iye ene' yiyaqsi' ka' watlaniji' ke' kanalifil, qa ha'ne yikoi iye qu' nite' huihinik'iju' ka' ƚanajkanewe'j ha' ƚeweƚi'je'm, ma' qa' nite' humtiye' qu' hik hakhayi'ija.— ");
INSERT INTO mca_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma' qa teƚuuyik'i iye hats wetshetk'ewi'ƚ tatsai (8) neƚutsik'i, qa ewi'ƚ iye i'ni' he' ƚ'ijatshenhei ma' qa hats i'nji'teje'm ha' Tomás. Yijanithenji' iye he' ƚejil ke' wititsi', ha' Jesús qa we'nethinets iye, ts'ap'aji'ju' iye ƚeqewuk'u hekhewe'en qa yit'ijji'ju' iye in wetfelji'ju': —Ƚe'sitsi'imkii ne' atawjetsi'ƚ.— ");
INSERT INTO mca_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Qa i'nk'aƚe qa yit'ijets ha' Tomás: —Te'ƚun qu' ikesinenij ene' yikoyei ne' ayaqsi' qa jeeƚija iye. Te'ƚunij na' okoi qa' uihinik'iju' ne' ayaqsii ha'ne yi'weƚi'. Hasu'uj e'qekuna'xe'. Ek'en yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Qa ha' Tomás qa yit'ij: —¡Yatsat'axyij qa yeqe Dios iye!— ");
INSERT INTO mca_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ha' Jesús qa yit'ijets: —Qe hats ƚetswen ma' qa hats nite' ƚesqeku', ƚe'sitsi'mkii pekhewe' qu' nite' netswenetax qa nite'ƚe tseqeku'.— ");
INSERT INTO mca_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Olots kekhewep iye ham ƚunyejeyi'iju'ƚ yaqsiijkii ha' Jesús, qa he' ƚ'ijatshenhei qa yi'weenijha. Kekhewe'en nite' week we'nika'ajji' ha'ne witfaakanek. ");
INSERT INTO mca_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Qa ekewe'en in we'nika'ajji', qe qa' nite' eqeku'yi'iƚik'i ha' Jesús in hik hakha' pa' Cristo, Ƚaa'sija pa' Dios, hats'inha qu' nite' eqeku'yi'iƚ hakha'an ma' qa' nana'li'ƚ e'm pa'qu' iƚaxitsi'iƚ qu' nata'ƚets ka' ƚiiji'. ");
INSERT INTO mca_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Qa ƚ'anu'upji' iye ekewe'en, ha' Jesús qa ewi'ƚij iye in we'nethinets he' ƚ'ijatshenhei ha' ƚotkoyek'iiju' ke' qi kaƚi' Tiberias. Qa aka'an kakha' ƚunye'jkii in we'nethinets iye: ");
INSERT INTO mca_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Witijts'eyek hik aka'aj Simón Pedro, qa ha' Tomás, ƚenqii iye Wetsjukji', qa ha' Natanael, Caná de Galilea ƚeiƚe', qa he' ƚelits ha' Zebedeo qa hekhewep iye wetsjuk hekhewe' ƚ'ijatshenhei. ");
INSERT INTO mca_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Qa ha' Simón Pedro qa yit'ij: —Qa' mexe heiq'ehemkii.— Qa hekhewe'en qa yit'ijju': —Ye'ehe qa k'ajayani'ƚ.— Ma' qa ikkii qa i'nji' ke' witinhitjii qa najamet teq'ehe'mkiitaxju', ham ƚeq'ehe'mkinele'. ");
INSERT INTO mca_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","In hats na'liyukii, ha' Jesús qa we'nethinets iye i'ni' ha' ƚotkoyek ke' kaƚi'. He' ƚ'ijatshenhei nite' nikfe'lij in hik hakha'tax ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ha' Jesús qa nifaakan: —Omehets, ¿me ham eq'ehemkineli'iƚ?— Hekhewe'en qa yeku'ƚ: —Hamija.— ");
INSERT INTO mca_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ha' Jesús qa yit'ijets iye: —Iwu'mi'ƚii ne' eq'ehemki'iƚ na' ƚe'niyayiƚik'i qa' nana'l pe'qu' eq'ehemkineli'iƚ.— Ma' qa yijayanij ka' hats yit'ijets. Ma' qa netsintaxijpha'm ke' ƚeq'ehemki' nite' yamifi qe topo'oj ke' sehets. ");
INSERT INTO mca_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma' qa hakha' yisu'un ƚ'ijatshenek ha' Jesús, qa yit'ijets ha' Pedro: —¡Qete'e' hik nakha' ha' Yatsat'ax'inij!— In yepi'ye' ek'i aka'an ha' Simón Pedro qa aje'eƚ teqhinatai, qe nit'ijji' he' ƚeqhinatai in mexe t'ithayii, qa t'ilitiiju' aje'eƚ ha' iweli'. ");
INSERT INTO mca_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Qa hekhewepƚe ƚ'ijatshenhei qa amaneiji' ke' witinhitjii qe hats metiipha'm ha' ƚotkoyek ke' kaƚi', cien (100) metros ipƚu'uipha'm, netsinij ke' ƚeq'ehemki' topo'oj ke' sehets. ");
INSERT INTO mca_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","In hats yametspha'm ha' ƚ'isƚa'wet, ma' qa t'ilitju'kii qa yi'wen ka' fe't hayiits tujje'm. Qa ewi'ƚ ka' sehets wo'nosjeyijup qa ka' pan. ");
INSERT INTO mca_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ha' Jesús qa yit'ijets: —Enka'xi'ƚ met pe'ye' ne' eq'ehemkineli'ƚ sehets.— ");
INSERT INTO mca_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ha' Simón Pedro qa t'ilitji'ju' ke' witinhitjii qa t'eku'mi' ke' witq'ehemki' qa netsinijetspha'm ha' ƚotkoyek ke' kaƚi' topo'oj ke' qits sehets, uja'x yamets ciento cincuenta y tres (153). In olotstaxji' yemjee qa nite'ƚe niwjaf'itju' ke' witq'ehemki'. ");
INSERT INTO mca_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ha' Jesús qa yit'ijets: —Enek eku'ni'ƚ qu' eki'ƚju'.— Ham pakha' qu' nite' netjeyepuni'ijets hekhewe' ƚ'ijatshenhei qu' nanfaakanij qu' nit'ijets: —¿Ƚek akha'?— qa hatsƚe nikfe'ltaxets in hik hakha' ha' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ha' Jesús qa iketsha hekhewe'en, qa t'eku'mi' ka' pan qa netisijju', qa hik ƚeqfenye'jij iye ka' sehets. ");
INSERT INTO mca_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aka'an in ƚunye'jkii ma' qa hats wetshetk'ewi'ƚij in we'nethinetskii he' ƚ'ijatshenhei in hats iƚa'x iye. ");
INSERT INTO mca_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma' qa in hats naq'axju', ha' Jesús qa yit'ijets ha' Simón Pedro: —Simón, ƚa's ha' Juan, ¿me les qi qu' etsu'unija qa enewe'ƚe'en qa' nite' les qiye' qu' isu'un?— Ha' Pedro qa yeku'ƚ: —Ehe, Yatsat'axyij, akha' ƚenikfe'lets in k'esu'un.— Ha' Jesús qa yit'ijets: —Aqakinenkii nekhewe' tsatsat'etsij kots'etets ƚelits.— ");
INSERT INTO mca_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Qa ewi'ƚij iye in nifaakan ma' qa hats wetsjuk'ij: —Simón, ƚa's ha' Juan, ¿me ƚetsu'unija?— Ha' Pedro qa yeku'ƚ iye: —Ehe, Yatsat'axyij, akha' ƚenikfe'lets in k'esu'un.— Ha' Jesús qa yit'ijets iye: —Aqakinenkii nekhewe' tsatsat'etsij kots'etets.— ");
INSERT INTO mca_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma' qa ewi'ƚij iye in yit'ijets qa hats wetshetk'ewi'ƚij in nifaakan: —Simón, ƚa's ha' Juan, ¿me ƚetsu'un?— Ha' Pedro qa hats yitawje'meten qe in hats wetshetk'ewi'ƚij in nifaakan qa yi'tƚi'ij: —¿Me ƚetsu'un?— qa yit'ij in yeku'ƚ: —Yatsat'axyij, akha' week ƚenikfe'lets. Ƚenikfe'lets in k'esu'un.— Ha' Jesús qa yit'ijets iye: —Aqakinenkii nekhewe' tsatsat'etsij kots'etets. ");
INSERT INTO mca_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yijaa'ija aka' hit'ij ewets, in mexe e'jutjana'x qa akha'ƚe in ƚanaqsi'j qa ƚakji' iye na'aj ƚe'nikheyuji'. Qa qu' a'ƚawa'ma'xe'tax qa' etshenƚepha'm ne' okoyei qu' it'ij k'eewe qa' tujtseika'ye' pa'qu' neqhinatanin qa' neka'xji' iye pakha' qu' nite' e'nikheyuye'taxji'.— ");
INSERT INTO mca_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aka'an in yit'ijets ha' Jesús qa hats yiwjutsiqentaxi'mha pa'qu' ƚawamhinye'je' hatse' ha' Pedro qu' nata'ƚets qu' niwqinhetji'ha pa' Dios. Ma' qa yit'ijets: —¡Atsjayan!— ");
INSERT INTO mca_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ha' Pedro in tetwek'elaxtax, qa yi'wen in nijayanpha'mkii ha' qi yisu'un ƚ'ijatshenek ha' Jesús. Hik hakha' ewi'ƚ i'ni'ƚi' in tekju' qa hikha' nifaakanij iye in yit'ijets: —Yatsat'axyij, ¿ƚek pakha' pa' t'ihin ej hatse'?— ");
INSERT INTO mca_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ha' Pedro in yi'wen hakha'an, qa yit'ijets ha' Jesús: —Yatsat'axyij qa hane'en, ¿pa'n qu' ƚunye'je'kiyek hatse'?— ");
INSERT INTO mca_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Qa ha' Jesús qa yit'ijets: —Yakha' qu' hisu'un qu' nite' nawa'me' nakha'an qa' namijii qu' hetpiltaxju' iye, nite' akha' qu' enikfe'lets aka'an. Akha' atsjayan yijat'ij.— ");
INSERT INTO mca_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Qa hik ta'ƚijupi' hekhewe' tek'enets in i'ye'ej wetju'ƚ hakha' ƚ'ijatshenek in tees tit nawa'm. Qa ha' Jesús nite'ƚe yit'ijets qu' nite' nawa'me'. Aka'ƚe qe yit'ij: —Yakha' qu' hisu'un qu' nite' nawa'me' qa' namijii qu' hetpiltaxju' iye, nite' akha' qu' enikfe'lets aka'an.— ");
INSERT INTO mca_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hik ha'ne ha'ne ƚ'ijatshenek yi'wen qa yepi'ye' iye ekewe' wekwek qa yika'ajji', ma' qa jinikfe'letsha iye ekewe' yika'ajji' in yijaalija. ");
INSERT INTO mca_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ha' Jesús olots iye ke' yaqsiijkii wekwek, qu' week ne'nika'ajji' ke' week, yakha' humti qu' nite' newejuƚi'ipji' ha'ne sehe' epji' pe'qu' witfaakanheye' qu' ne'nika'ajji'.");
INSERT INTO mca_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ka' yojo yifaakanek, waika' Teófilo, hika' e'm ke' week ƚeqfenyejeyij pa'aj pa' Jesús in i'nk'a yaqsiijkii ke' ham ƚunyejeyi'iju'ƚ qa ke' i'nq'ijatshenij iye ");
INSERT INTO mca_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","qa yamijii in tenilesi'yiju'ƚ na' wa'sji'. In mente' yamii na' wa's, qa pa' Espíritu Santo qa hikpa' ta'ƚets pa'aj pa' Jesús in nifeli'm pakha' qu' naqsiijkii hekhewe' apóstoles t'eku'miiji'kii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","In naxijik'i pa' qi in yaats'e'ej qa in wa'm iye, qa ƚakha'ija in we'nethinetskii pa'aj hekhewe' apóstoles, qa yethinijkii kekhewe' olots jutsiqetsij in hats iƚa'x iye, qa yamijets cuarenta (40) neƚuts in we'nethinetskii qa nifeli'm pe' wekwek t'ejuyets pa' tenek'enheiji' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pa' Jesús in mexe i'nji'teje'm pa'aj he' apóstoles, qa yit'ijets: —Hasu'uj ma eku'ni'ƚik'ui na' Jerusalén, o'notki eku'ni'ƚets yijat'ij qu' nafits kakha' hats yiwjutsiqen na' Tata, hikka' yakha' hats k'efeli'ƚi'm, ");
INSERT INTO mca_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","qe ka' Juan Bautista wenqimpuujinji' na'aj iweli', qa ekhewelƚi'iƚ qa' mempuliji'ƚji' ek na' Espíritu Santo, hats nite' toxik'ui.— ");
INSERT INTO mca_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma' qa pe' not'axi'ƚ wetju'ƚ pa'aj apóstoles qa nifaakan, qa yit'ijets: —Yatsat'axyij, ¿me hats yamets hane'ej ƚahats'ij qu' iwu'mfik'i pe' romano tenek'enhe'yij na' Israel ƚeqe sehe'?— ");
INSERT INTO mca_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pa' Jesús qa yeku'ƚ pa'aj: —Nite' ekheweli'ƚ qu' enikfe'li'ƚets pekhewe' neƚutsji' hatse' qa pekhewe' ƚahatsiyij iye, na' Tata hats yaji'letju' yit'iji' nakha' ƚet'unha'x in qi in tenek'enhei. ");
INSERT INTO mca_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Qa ƚ'estiiƚi'iƚij hatse' pe'qu' et'unhaxitsi'iƚ qu' nanam na' Espíritu Santo qa' na'ni'ƚ epji', ma' qa' etsfeli'ƚi' ha'ne Jerusaleni' qa week na' sehe' Judea qa na' Samaria, qa amƚi'iƚijii pekhewe' totsii witsetits ha'ne sehe' ipji'.— ");
INSERT INTO mca_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","In yili'ij in yit'ij pa'aj ekewe' wekwek, qa he' apóstoles in mexe yejeƚtaxju' pa'aj qa ts'eejpha'm pa'aj in ikpha'm, qa uiji'teje'm pe' ewi'ƚ wasi' ma' qa hats nite' na'l. ");
INSERT INTO mca_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","In mexe yejeƚtaxiikii pa'aj hekhewe'en na' wa'sji' ha' Jesús in ikpha'm, qa ƚunye'jkii pa'aj in hats i'nijup hekhewe'en pe' wetsjuk jukhew fo' pe' ƚeqhinatai. ");
INSERT INTO mca_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pekhewe'en qa yit'ijji'ju': —Jukhew, Galilea ƚeiƚets, ¿inhats'ek in ƚejeƚiƚik'ipha'm na' wa'sji'? Ha'ne Jesús i'ntaxi'ƚ etji'teje'm qa hats wetka'xetspha'm na' wa's, hik ha'ne tepilju' iye hatse' qa' hik ƚunye'je' iye in ƚi'weni'ƚ in ikpha'm.— ");
INSERT INTO mca_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ma' qa tepilik'uikii iye ke' utek ƚii Olivos, qa tepilets iye ha' Jerusalén, ipƚu'umets ewi'ƚ kilómetro qe hik ƚ'a'j na'aj ƚenexke'ej pa'aj qu' jintajalki'sji' na'aj witwapiihijiiji' (sábado). ");
INSERT INTO mca_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","In hats uiji'teje'mkii pa'aj ha' witset qa iketspha'mkii pa' toxpha'm pe' wititsi' hikpa' ƚewhi'wet'ijkii pa'aj ha' Pedro, ha' Juan, ha' Jacobo (Santiago) qa ha' Andrés, ha' Felipe qa ha' Tomás, ha' Bartolomé qa ha' Mateo, ha' Jacobo (Santiago), ƚa's pa' Alfeo, ha' Simón ƚenqii iye Zelote (cananista) qa ha' Judas, ƚa's pakha' ƚii iye Jacobo (Santiago). ");
INSERT INTO mca_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Week enewe'en ewi'ƚ we'neniji'ha pa'aj, qa iyiinjiija iye, weekji' pekhewe' efuts iye, qa kikhe' iye María ƚenene pa' Jesús, qa hekhewe' iye ƚek'injats. ");
INSERT INTO mca_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hik pakha'aj pe' neƚutsji', ha' Pedro qa ts'ap'aji'ju' pa'aj ƚeqewuk'u pekhewe' tek'enets pa' Jesús, uja'x yamets pa'aj in week pekhewe' not'ax wetju'ƚ ciento veinte (120), qa yit'ijji'ju' pa'aj: ");
INSERT INTO mca_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yejefets, hatsƚe ƚ'anye'j pa'aj qa lesƚe ƚe'wis qu' nafits kekhewe' hats we'nika'ajji' pa'aj ƚe'lijei pa' David'ik'i yitijinenij pa'aj pa' Espíritu Santo. Qa nifel pa'aj in t'ejuyets ka' Judas'ik'i, hikka' nojo'ok'oyii hekhewe' t'eku'mi' qa yophe'ƚ ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Qe ka' Judas'ik'i kakha'an week heinekumhiitaxiƚiiji' qa na'ltax pa' testiitaxij aka' wit'ithayijkit. ");
INSERT INTO mca_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kakha'an, pekhewe' ƚajal pa' ƚewuƚ'ax qa yamitiju'ƚ pa' ewi'ƚ sehe', qa namiiju' pa'aj qa tike'ƚ je'm pa'aj ke' ƚekutjiyik'i qa lasasfik'ikii pe' ƚajatayik'i. ");
INSERT INTO mca_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","In nikfe'lets pa'aj aka'an pe' week Jerusalén ƚeiƚets qa ƚeqiyij ha' sehe' kekhewe' ƚe'lijei yit'ij Acéldama, ikji' wit'athits ƚetset. ");
INSERT INTO mca_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Qe nakha' witfaakanek Intata ƚe'lijei Salmos, we'nika'ajji' pa'aj in yit'ij: “Ham pa'qu' na'ni' hatse' pakha' ƚetset. Hasu'uj pa'qu' na'ni' pakha'an.” Qa yit'ij iye: “Naya'xi' pakhape' pakha' ƚ'ithayijki'ttax.” ");
INSERT INTO mca_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Qa hik ta'ƚijupi', in les ƚe'wis hekhewe' jukhew, hekhewe' tsijayaniƚik'ikii eke' week ƚahatsiyij in mexe i'n'init ji'teje'm ha' Yatsat'ax'inij Jesús, ");
INSERT INTO mca_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hekhewe' ta'ƚijii in i'nk'a yimpuujin ka' Juan'ik'i hakha'an, qa yamƚi'ijii in in hats ikii na' wa's, pakha' qu' ewi'ƚe' qu' na'n initji'teje'm iye qa' nenfel iye in iƚa'x iye ha' Jesús.— ");
INSERT INTO mca_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma' qa taya'yiiji' pe' wetsjuk jukhew, hakha' José ƚii Barsabás qa hik hakha' iye ƚii Justo qa ha' Matías. ");
INSERT INTO mca_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma' qa iyin, qa yit'ijju': —Yatsat'axyij, akha' in ƚenikfe'lets yijat'ij pe' ƚatawjets ene' weekji', ets'ethini'ƚij wat'ij pa'n ƚii pakha' qu' hayiits ku'miiji' pa'aj enewe' wetsjuk jukhew, ");
INSERT INTO mca_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hats'inha qu' naya'xi' qa' nithayiki aka' wit'ithayijkit qu' apostoli'ij iye, hik aka' ka' Judas'ik'i yiwu'mi' qe qa' namii pakha' weju'ƚij qu' namii.— ");
INSERT INTO mca_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma' qa ikij wetju'ƚ, qa t'an pa'aj ha' Matías. Ma' qa i'nji'teje'm he' once (11) apóstoles. Ma' qa hats doce (12) iye. ");
INSERT INTO mca_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","In yamets pa'aj pakha' ƚe'wis neƚu ƚii Pentecostés, qa week pekhewe' tek'enik'i ke' Jesús ƚe'lijei qa ewi'ƚ pa' i'ni' pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma' qa aje'eƚ pa'aj yepi'ye' pa' nokes hik ƚunye'j na'aj qi t'unik'i ta'ƚiipha'm na' wa's, qa weekij pa'aj pe' wititsi'ifi pakha' i'niju'kii. ");
INSERT INTO mca_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma' qa laxaji' pa'aj pe' hik ƚunyejeitax fetei. Ma' qa yak'eskii qa week i'nipji' ƚesinjel pekhewe' jukhew qa pe' efuts iye. ");
INSERT INTO mca_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Qa week topolij pa' Espíritu Santo, ma' qa yapeƚek pa'aj in yit'ij pekhewep witlijeikal, pekhewe' tisij pa' Espíritu Santo qu' nit'ij qa yit'ij. ");
INSERT INTO mca_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Qa na'l pekhewe' i'ni'kii ha' Jerusalén judiol, yijayan pa' Intata, ta'ƚiikii pe' week witsetits ha'ne week sehe' ipji'. ");
INSERT INTO mca_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","In nokes pa'aj pa' kimiim, ma' qa pe' olots jukhew qa efuts iye qa not'axii pa'aj, pekhewe'en qa qhel qhelƚi'ij wetju'ƚ pa'qu' numti, qe week ewiƚei pekhewe'en in yepi'ye' ej in yit'ij pe' ƚe'lijeiƚe wetju'ƚ in jukhewiikal. ");
INSERT INTO mca_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Qa qi in yitjuƚaxijpha'mkii, qa yit'ijju': —Jeƚ qeku'ni'ƚju' ek, ¿me nite' week Galilea ƚeiƚets enewe' iyetju'? ");
INSERT INTO mca_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Pa'n ƚunye'j in week ewiƚei inekhewel in jitepi'ye'ej in yit'ij ekewe' i'nlijeyija ekewe' jinekijfik'i? ");
INSERT INTO mca_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Inekhewel na'l ne' ta'ƚii pa' Partia, ne' ta'ƚii pa' Media, ne' ta'ƚii pa' Elam, ne' ta'ƚii pa' Mesopotamia qa ene' Judea ƚeiƚets, qa ne' ta'ƚii pa' Capadocia, ne' ta'ƚii pa' Ponto, ne' ta'ƚii pa' Asia, ");
INSERT INTO mca_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ne' ta'ƚii pa' Frigia, ne' ta'ƚii pa' Panfilia, ne' ta'ƚii pa' Egipto, ne' ta'ƚii pa' Libia ipƚuli'ƚ wetju'ƚ pa' Cirene, ne' ta'ƚii pa' Roma nekhewe' judiolija qa nekhewe' t'eku'mƚi'i' ka' ƚunyejei ne' judiol, ");
INSERT INTO mca_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ne' ta'ƚii pa' Creta qa ne' ta'ƚii pa' Arabia. Week inekhewel jitepi'ye'ej in iyetij pe' wekwek ham ƚunyejeyi'iju'ƚ ƚaqsijiyijkii pa' Dios yit'ij ekewe' i'nlijeyija.— ");
INSERT INTO mca_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Week yitjuƚaxijpha'mkii qa qhel qhelƚi'ij wetju'ƚ pa'qu' numti, ma' qa watfaakanijju': —¿Pa'n qu' naakji'ha aka'an?— ");
INSERT INTO mca_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Qa pekhewepƚe qa yawitjitaxiji' ek ƚe'lijei qa yit'ijju': —Yek'uwetƚeju' nekhewe'en.— ");
INSERT INTO mca_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ma' qa ha' Pedro qa ts'ap'a qa week iye hekhewe' once (11), qa yit'unhetik'i, qa yit'ijji'ju': —Jukhew, Judea ƚeiƚets qa week iye ene' Jerusalén ƚeiƚets, menikfeliti'ƚetsha aka'an qa' ek'eni'ƚik'iha iye aka' qu' hit'ij, ");
INSERT INTO mca_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","qe enewe'en nite' yek'uwetju' in ƚumtitaxi'ƚ qu' nek'uwetju', qe mexe hanee'ij juufik'ipha'm ne' junu', ");
INSERT INTO mca_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","qe hik aka' yijat'ij pakha' nifel pa'aj pa' ewi'ƚ profeta'ik'i ƚii Joel, in yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Pa' Dios yit'ij: ‘Qa' ƚunye'je'kii hatse' pekhewe' teke'lenju' neƚutsji' na' yeqe Espíritu qa' hatsi'yipji' ene' week i'nipji' ha'ne sehe', ma' qa pe'qu' elitsi'iƚ jukhew qa efuts qa' nenfel pa'qu' hit'ijets, pe' jutjanhets qa na'nƚeji'kii ƚotoi pa'qu' hetisij qa ne' ƚawa'mhits qa' nits'owoƚ'ax ƚi'ij pa'qu' hetisij. ");
INSERT INTO mca_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Qa' hatsi'yipji' iye na' yeqe Espíritu nekhewe' yeqejkunenhei qa nekhewe' yeqejkunenkii iye.’ Ma' qa' niyetij pekhewe' qu' nit'ijets pa' Intata. ");
INSERT INTO mca_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","‘Qa' hethinij hatse' ha'ne wa'sji' pe'qu' ham ƚunyejeyi'iju'ƚ, qa pe'qu' jutsiqetsi'ij ha'ne sehe' ipji': wit'athits, fe't qa pa'qu' qi tutsaxe'. ");
INSERT INTO mca_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ne' junu' qa' noo'yi' ipji' hatse', ne' juwel qa s'e' ye'ji' hik ƚunye'j wit'athits, ma' qa' ƚ'anu'upji' qa' namets na' qiji' qa ƚe'wis iye ƚeqe neƚu ha'ne Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma' qa' ƚunye'je'kii hatse' week pakha' qu' niyinijets ƚiƚa'xe' ha'ne Yatsat'ax'inij qa' iƚa'xe'.’”— ");
INSERT INTO mca_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ha' Pedro qa yit'ij iye pa'aj: —Jukhew Israel ƚeiƚets, ek'en qeku'ni'ƚik'i ek ekewe' qu' hit'ij: ha' Jesús, Nazaret ƚeiƚe', pa' Dios hik hakha' yiwjutsiqentaxi'ƚ e'mha in nukinju', qa hikha' i'ntaxijji' in nethintaxi'ƚijkii kekhewe' ham ƚunyejeyi'iju'ƚ, kekhewe' jiyitjuƚaxijpha'mkii qa kekhewe' jutsiqetsij in ta'ƚiiha pa' Dios, in ƚunyejeyek kekhewe' hats ƚi'weni'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hane'en, in testi'yij qu' nawa'm qe ta'ƚets pakha' hayiits watji'letju' pakha'aj qu' ƚunye'je'kii qa pakha' iye qi ƚikfeliya'xkii pa' Dios. Ma' qa ƚilani'ƚiji' ke' cruz ƚa'niƚijji' hekhewe' uƚ'ets jukhew, ma' qa ƚilani'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Qa yiƚinƚe iye pa' Dios, yaq'ayinij iye aje'eƚ pakha' qi ƚaqa'ti'ij kakha' ƚawamhijii, qe pa' witwamhi' nite' ƚeke' qu' nenyejinju'. ");
INSERT INTO mca_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Qe pa' David'ik'i iyetij iye pa'aj hakha'an in yit'ij: “Nite' yili'ij in hi'wen na' Yatsat'ax'inij met ye'mkiiha, qe i'ni' ha'ne ts'iyayik'i hats'inha qu' hame' pakha' qu' netsyejinijik'ui aka'an. ");
INSERT INTO mca_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Qa hik ta'ƚijupi' in ƚe'wisi'mkii ha'ne yitawe'j qa ha'ne yilepep qa iyetij pa' ƚesaxi'mkii. Qa ha'ne yese'n iye qu' nawapiitax qa na'lƚi'im pa' wetjumti'ik'ui, ");
INSERT INTO mca_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","qe akha' tees qu' iwejinƚi'i' pa' yiƚa'x pakha' ƚetset pe' naxju', nite' exke'ej iye qu' ƚipipe'ji' ha'ne ƚ'aj ha'ne ham pa'qu' naqsiijkii uƚ'axe' eqejkunenek. ");
INSERT INTO mca_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Akha' ƚetsikfelitets nakha' wit'ikheyi'jii qu' yi'ƚa'xe' iye. Qi qu' otsponhetij hatse' pa'qu' yisa'xi'imkii qu' natsamtax ei.” ");
INSERT INTO mca_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yejefets, nite' hetjeyepuni'ƚij ewets qu' hit'iƚij ewets pakha' inaqwa'ma'xik'i David in wa'm pa'aj qa we'nenifi pa'aj kekhe' ƚesehek, kekhe' hane'ej mexe na'l hane'e'in. ");
INSERT INTO mca_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Qa pa' David'ik'i in profetaƚe qa nikfe'letsha pa' Dios in yiwjutsiqeni'mha pa'aj qu' nayaxipji' hatse' pakha' ƚots'oji'la'x in qi in wittata pakha' ewi'ƚ pekhewe' ta'ƚets hatse'. ");
INSERT INTO mca_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pa' David'ik'i yejeƚii pakha' mexe hamik'ui qa iyetij pakha' ƚiƚijii hatse' pa' Cristo, in nite' tewejinhetiiƚi'iiju' pakha' ƚetset pe' naxju', qa nite' ƚeke' iye qu' ƚipipe'ji' pa' ƚ'aj. ");
INSERT INTO mca_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ha'ne Jesús yiƚin pa' Dios, hik ha'ne yekheweli'ƚ ye'weeki'ƚ in tsikfe'li'ƚijets aka'an qe hi'weni'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ma' qa hats weniwqinhetji' i'niju' pa' yiya'yik'i pa' Dios, qa pa' Intata qa tisijets pa' Espíritu Santo yiwjutsiqeni'm pa'aj qu' netisij, ma' qa hakha'an qa natsiyi'ƚ yiwetsju' aka'an aka' hane'ej ƚi'weni'ƚ qa ƚepi'ye'eƚ iye. ");
INSERT INTO mca_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Qe pa' David'ik'i nite' hik pakha' qu' naketspha'm pa'aj na' wa's, qa yi'tƚi'ij pa'aj: “Pa' Yatsat'ax'inij yit'ijets pa' Yatsat'axyij: ‘Ni'iju' ha'ne ts'iyayik'i ");
INSERT INTO mca_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ipƚu'ui qu' hentaxiiju' ne' ef'iyei qa otsi'pji'kii nekhewe' ejuihifets.’” ");
INSERT INTO mca_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Week ene' Israel ƚeiƚets nenikfelitetsha ha'ne Jesús ha'ne ƚ'eni'ƚji'pha'm ke' ƚeqe cruz, hik ha'ne pa' Dios yaqsiijkii qa yeni' ma' qa Yatsat'ax'inij qa Cristo iye.— ");
INSERT INTO mca_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma' qa in yepi'ye' ek'i pa'aj ekewe'en pekhewe'en, qa qi in yasin ji'teje'm pe' ƚatawjets. Pekhewe'en qa nifaakanij pa'aj ha' Pedro qa hekhewep apóstoles: —Yejefets, ¿pa'n ƚii pa'qu' haqsi'ji'ƚijkii?— ");
INSERT INTO mca_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ha' Pedro qa yit'ijji'ju' pa'aj: —Ili'iƚij pe' uƚ'ets in ƚaqsiiƚijkii qa' mempuji'ƚij week ewiƚei ekheweli'ƚ aka' ƚiiji' ha' Jesucristo hats'inha qu' netwumhiti'yi'ƚ ek'ui pe' ewuƚ'etsi'ƚ, ma' qa' esti'yi'ƚij pakha' witqisit pakha'an hikpa' pa' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Qe ha'ne yiwjutsiqen pa'aj pa' Dios, t'ejuyi'ƚ ewets qa t'ejuyets iye pe' elitsi'ƚ qa week t'ejuyets iye pekhewe' totsii pa' i'ni', ehe, t'ejuyets pekhewe' qu' natya'yiiji' pa' Yatsat'ax'inij inqe Dios.— ");
INSERT INTO mca_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ekewe'en yit'ij pa'aj ha' Pedro qa olots iye pekhewep iye in nifeeli'mha pa'aj qa yakakƚinijha iye pa'aj, qa yit'ijets: —Eneki'ƚik'uifik'i yijat'ij pakha' ƚantanithenkeye'j hatse' enewe' hane'ej ƚahats'ij uƚ'ets jukhew, ma' qa' i'ƚiyi'iƚ.— ");
INSERT INTO mca_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma' qa pe' tek'enik'i qa t'eku'mi' kekhewe' yit'ij pa'aj, qa wempuli'jju' pa'aj. Ma' qa hats ikets iye pa' neƚuji' pekhewe' ink'aihits i'nƚi'i qu' namets wetshetk'ewi'ƚ mil (3.000) pe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Qa we'neniha pa'aj nite' yili'ij in tek'enik'i pekhewe' i'nq'ijatshenij he' apóstoles, we'neniha pa'aj in nite' yili'ij qa not'axji'ij wetju'ƚ, we'neniha pa'aj in nite' yili'ij qa wetƚisjiijju' pe' pa'n qa we'neniha iye pa'aj in nite' yili'ij qa iyinji'ij. ");
INSERT INTO mca_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pe' weekji' qiji'ij qa yitjuƚaxjiijpha'mkii pekhewe' ham ƚunyejeyi'iju'ƚ yaqsi'j jiijkii hekhewe' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Week nite' yeqeku' tek'enets qa ewi'ƚ i'njiiji' qa nite' ekuyitsij wetju'ƚ iye pe' ƚewekwekits. ");
INSERT INTO mca_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","T'ihinji'jij pe' ƚeqe sehel qa pe' ƚewekwekits iye, ma' qa pe' ƚ'astai netisjiiju' pe' week pakha' qu' hami'im pe'ye'. ");
INSERT INTO mca_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Week neƚuts nite' yili'ij pa'aj in ewi'ƚ i'nji'ji' nekhe' qi witlijtsitjiyii qa pe' ƚetsilii iye qa wetƚisjiijju' pe' pan, ewi'ƚ i'njiiji' iye pa'aj qa tekji'ijju' qa pa' ƚunyejei pe' ƚatawjets qa yijaa'ija iye ham yat'ine'kii. ");
INSERT INTO mca_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yiwqinhetji'ha pa'aj pa' Intata qa week pakha' witset in yisu'unij. Qa pa' Yatsat'ax'inij qa week neƚuts yenji'teje'mkii pekhewe' ƚelits pe' ink'aihits qu' iƚiye' iye. ");
INSERT INTO mca_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ewi'ƚ pa' neƚu pa'aj ha' Pedro qa ha' Juan ikik'ipha'm pa'aj ke' qi witlijtsitjii jelji' junu' las tres pa'aj yamets iye in ƚ'iyinhejii. ");
INSERT INTO mca_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na'l pa'aj pa' ewi'ƚ jukhew onqok, ta'ƚij ji'teje'm pa'aj wittawe'j in onqok. Week neƚuts wetka'xji'jii ha' ƚeji' ƚenqii Ƚe'wis qa iyinjiijets ƚaq'astaye' pe' uijiifi ke' qi witlijtsitjii. ");
INSERT INTO mca_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hane'en in yi'wen pa'aj ha' Pedro qa ha' Juan in hats k'esitsiyu'ets pa' ƚeji' qa' nuyetsji' ke' qi witlijtsitjii, qa iyintaxijets pa'aj ƚaq'astaye'. ");
INSERT INTO mca_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ma' qa ha' Pedro qa ha' Juan qa ts'in pa'aj in yejeƚju' pakha'an, qa yit'ijets pa'aj: —¡Etsjeƚi'ƚju'ha!— ");
INSERT INTO mca_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ha' onqok qa yejeeƚjuha qe yumtitax qu' netisij pe'ye'. ");
INSERT INTO mca_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Qa ha'ƚe Pedro qa yit'ijets pa'aj: —Ham yaq'astaye' qa ham iye yoqo oroye', qa aka'ƚe na'l ye'm qa' hik aka' qu' k'eƚisij: Aka' ƚiiji' ha' Jesucristo, Nazaret ƚeiƚe', ¡eniipha'm qa' ma!— ");
INSERT INTO mca_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma' qa ha' Pedro qa t'eku'mi' pa'aj pa' yiya'yik'i ƚokoi, qa niihinpha'm pa'aj. Ma' qa aje'eƚ pa'aj t'unitsik'i pe' ƚef'iyei qa pe' ƚofonjei iye qa hats ƚe'sitju', ");
INSERT INTO mca_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","qa t'ilit'ijpha'm pa'aj qu' ts'ap'aye' qa ik. Qa uyifi pa'aj ke' qi witlijtsitjii ƚijts'eye'kteje'm pa'aj hekhewe'en hats t'otsjo', qa t'ilitpha'mkii pa'aj qi in yiwqinhetji' pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Week pe' jukhew qa efuts iye in yi'wen pa'aj in t'otsjo' qa in yiwqinhet iye pa' Dios, ");
INSERT INTO mca_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","qa nikfe'lij pa'aj in hik pakhaa'ija pakha' i'nƚe'kji' pa' ƚeji' ƚenqii Ƚe'wis kekhe' qi witlijtsitjii qa iyinjiikii ƚaq'astaye', ma' qa qi in yitjuƚaxijpha'mkii pa'aj in yi'wen aka' ƚunye'jkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pa' onqoktax in mexe nite' yaqamij pa'aj in tik'eyijup ha' Pedro qa ha' Juan, ma' qa pe' week jukhew qa efuts iye qa tekumaxiikii pa'aj pekhewe'en in i'niji' pakha' ts'eewe'efi ƚii Salomón ke' qi witlijtsitjiyetsji', qa qi in yitjuƚaxijpha'mkii pa'aj pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aka'an in yi'wen pa'aj ha' Pedro, qa yit'ijji'ju' pe' weekji': —Jukhew, Israel ƚeiƚets, ¿inhats'ek in ƚenitjuƚaxiƚijpha'm aka'an? ¿Inhats'ek in ƚetsjeƚi'ƚju', qa hik ƚunye'j qu' nata'ƚets pa'qu' yit'unha'xe'ƚi'iƚ i'nƚi'i pa'qu' yijunyejeyi'iƚij pa' Intata in hotshini'ƚju' ha'ne onqoktax? ");
INSERT INTO mca_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pakha' ƚeqe Dios pa' Abraham'ik'i, pa' Isaac'ik'i qa pa' Jacob'ik'i, pakha' ƚeqe Dios pe' inaqwa'mhitsik'i, hats yiwqinhetji' hakha' ƚa's Jesús, hik hakha' ekheweli'ƚ ƚ'ihiniƚij qa qi in ƚuteni'ƚ a'ts'ap'a'aƚijets hakha' Pilato, hakha'an in yisu'untax qu' niwejin. ");
INSERT INTO mca_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Qa ekhewelƚi'iƚ qa qi in ƚuteni'ƚ hakha' Hamji' pa'qu' uƚ'axe' qa Yatsathenija iye, ma' qa ƚ'iyiniƚets qu' netwejinhetii hakha' ewi'ƚ eqek'una'x, ");
INSERT INTO mca_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","qa ƚetisi'ƚij qu' natlanhetii qa' nawa'm hakha' ta'ƚets pa' witiƚa'x. Qa pa' Dios qa yiƚinƚe iye niihinik'uipha'm pe' naxju', hik aka' yekheweli'ƚ hi'weni'ƚha. ");
INSERT INTO mca_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Qa in ta'ƚets pakha' nite' yeqekuyejeyi'ƚij aka' ƚiiji', ma' qa aka' ƚiiji' ha' Jesús qa hik aka' yit'unhet ha'ne jukhew, ha'ne hane'ej ƚi'weni'ƚ qa ƚenikfe'li'ƚij iye, pakha' nite' witqekuye'j ta'ƚets ha' Jesús hik pakha' yaqsi'jju'ha ha'ne jukhew, qa ekheweli'ƚ qa e'weeki'ƚ in ƚi'weni'ƚijha. ");
INSERT INTO mca_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Qa hane'ej, yejefets, yakha' tsikfe'lets in ƚaqsi'jƚi'iƚijkii aka'an in ƚilani'ƚ ha' Jesús qe nite' ƚenikfe'li'ƚetsha pa' ƚunyee'jkiiha, in ƚunyejeyek iye nekhewe' ek'enhejkititsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Qa hatsƚe yafitsheninƚi'ij pa' Dios pakha' hayiits yit'ij pa'aj i'njiijji' pekhewe' week profetalik'i: pakha' ƚeqe Cristo qu' qi qu' nataatshenhetii qa' nawa'm iye. ");
INSERT INTO mca_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Qa hik ta'ƚijupi', menikfeliti'ƚij etetsha aka'an in ƚijaniƚik'i qa' etetwek'elaxi'ƚijets yijat'ij qu' hasu'uj eqeku'uƚ, hats'inha pe' ewuƚ'etsi'ƚ qa' nawatwamhitik'i, ma' qa' e'lefitsi'iƚijets qu' uƚaije'yi'ƚ qu' hats ni'iƚijup pakha' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Qa pakha'an qa' ne'nukiniƚ'ei hatse' ha' Jesús hikha' Cristo, hik hakha' hayiits pa'aj te'nekumhi'yiiji' qu' esti'yi'ƚij qa' ne'feni'ƚ hatse', ");
INSERT INTO mca_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","qa lesƚe ƚe'wis qu' mexe amani'iipha'm na' wa's ipƚu'ui qu' namtaxets pa' neƚuji' qu' newetpilettaxi' iye pa' hayiits ƚunyejei ene' wekwek, in ƚ'anye'jek pakha' hats yit'ij pa'aj pa' Dios i'nijji' pekhewe' ƚe'sits ƚeqe profetas'ik'i pakhaa'ij pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pa' Moises'ik'i yit'ij pa'aj: “Pakha' Yatsat'ax'inij Dios yaqsiijkii hatse' qu' nata'ƚi'ƚ etji'ju' pakha' ewi'ƚ profeta hik yijunye'j. Ek'eni'ƚets hatse' pakha'an week pakha' qu' nit'iƚij ewets. ");
INSERT INTO mca_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Qe pakha' qu' nite' netk'ene'ets pakha' profeta, qa' netwumhiti'yik'uifik'i pakha' witset hatse'.” ");
INSERT INTO mca_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ma' qa hik aka' iyetji'jij iye pa'aj pe' week profetas'ik'i in ta'ƚi' ek pakha' Samuel'ik'i qa teneiƚi'ijpha'm pe' week in nifel pa'aj ekewe' hane'ej ƚunyejeikii enewe' neƚutsji'. ");
INSERT INTO mca_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ekheweli'ƚ ƚelits pekhewe' profetas'ik'i qa ƚelits iye pakha' yiwjutsiqeni'm pa'aj pa' Dios pekhewe' alheyi'ƚik'i, qe in yit'ijets pa'aj pa' Dios pa' Abraham'ik'i: “Qa pe' ƚo' ta'ƚ ewets hatse' qa' nata'ƚets qu' hi'fen enewe' week witsetits ha'ne sehe' ipji'.” ");
INSERT INTO mca_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pa' Dios in yiƚin iye ha' Ƚa's, qa nojohoni'ƚij in nukiniƚ'ei, qe qa' ne'feni'ƚ ekheweli'ƚ qu' menink'aihiti'ƚ qa' ili'iƚij pe' uƚ'ets ƚaqsi'ji'ƚijkii.— ");
INSERT INTO mca_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ma' qa ha' Pedro qa ha' Juan in mexe iyettaxik'ui pa'aj pekhewe' jukhew qa efuts iye qa nekii pa'aj pekhewe' pa'il, qa pa' tenek'enhe'yipji' pekhewe' yejeƚ ke' qi witlijtsitjii qa pe' saduceos. ");
INSERT INTO mca_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Qi pa'aj in nayu'kii pekhewe'en qe hekhewe'en i'nq'ijatshenij pa'aj in iƚii iye hatse' pe' naxju' qe pa' Jesús hik pakha' inq'ethinij pa'aj aka'an in iƚa'x iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ma' qa t'eku'mi' pa'aj qa yuihinifi pe' ƚoq'opheƚitjii qa yamijii pa'aj in neƚukii, qe hats metju' pa'aj pe' junu'. ");
INSERT INTO mca_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Qa hatsƚe olots iye pa'aj pekhewe' yepi'ye' pe' nifel pa'aj, qa nite' yeqeku'uk'i, ma' qa hats i'nƚi'i qu' namets lee'fij mil (5.000) in weekji' pekhewe' jukhew qa efuts iye tek'enets pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Qa ƚunye'jkii pa'aj pakhap neƚukii in not'axi' wetju'ƚ pa'aj na' Jerusalén pekhewe' tenek'enhe'yij pe' qi witlijtsitjii, pe' tenek'enheiji' pa' witset qa pe' i'nq'ijatshenij ke' Moisés ƚe'lijei. ");
INSERT INTO mca_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","I'nji'teje'm iye pa' qiji' pa'il ƚatata Anás, qa pa' Caifás, qa pa' Juan qa pa' Alejandro iye, qa pe' week pe' ƚejefets pa' qiji' ƚatata pe' pa'il. ");
INSERT INTO mca_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ma' qa tetka'x pa'aj ha' Pedro qa ha' Juan, qa we'nenji'ju' pa'aj pa' ƚeqewuk'uji' pekhewe'en, ma' qa nifaakan pa'aj: —¿Pa'n ƚii ƚet'unha'x, axe'm pa'qu' witiye' qu' ƚit'iƚiji' in ƚaqsiiƚijkii ekewe'en?— ");
INSERT INTO mca_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ma' qa ha' Pedro, topo'oj pa'aj pa' Espíritu Santo, qa yit'ijji'ju' pa'aj: —Wit'alhei qa week iye nekhewe' tenek'enheiji' ha'ne witset, ");
INSERT INTO mca_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","pakha' ƚatsfaakani'ƚij, qu' hik kakha'ye' kakha' ƚe'wis wanaqsiimijkii nakha' jukhew wanqats'etax qa pa'n ƚunye'j iye in hats ƚe'wisju' nakha'an. ");
INSERT INTO mca_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ye'ehe, enikfe'li'ƚetsha week ekheweli'ƚ qa week iye ha'ne witset Israel, ha'ne jukhew in hats ƚe'wisju' qa hats ƚi'weni'ƚ hane'ej hane'e'in, ta'ƚets aka' ƚiiji' hakha' Jesucristo, Nazaret ƚeiƚe', hikha' ekheweli'ƚ ƚ'eni'ƚji'pha'm ke' cruz, qa hikha' iye pa' Dios niihinik'uipha'm pe' naxju'. ");
INSERT INTO mca_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ha'ne Jesús hik ha'ne pekhe' ute yuten qa yiwu'mfik'i pekhewe' niihinpha'm pe' wititsi' hik pekhewe' ekheweli'ƚ, qa hatsƚe ewi'ƚ ute les weju'ƚij in teniihinijpha'm pe' wititsi'. ");
INSERT INTO mca_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Qa ham iye pakhape' qu' jiniƚin, qe ham pakhape' iye witiye' ha'ne week sehe' ipji' qu' netesti'yij ene' jukhew qu' hik pakha'ye' qu' jiniƚin.— ");
INSERT INTO mca_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pekhewe' tenek'enhei in yi'wen in nite' nijiwei pa'aj ha' Pedro qa ha' Juan iye, qa nikfe'lets iye hekhewe'en in nite' ikii pe'qu' witq'ikatjiye' qa nite' iye hayiits qu' nenikfe'lets pe'ye', ma' qa qi in yitjuƚaxijpha'mkii, qa nikfe'lets in hik hekhewe' ƚijts'eyekkii ha' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Qa yi'wen iye pa'aj in ewi'ƚ ts'ap'a'aƚi' pakha' jukhew yiƚin pa'aj pekhewe'en, ma' qa ham pakha' qu' nit'ijiju'ƚ qu' net'ejuyiju'ƚ aka'an. ");
INSERT INTO mca_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Qa inaqyajiƚi'ij pa'aj qu' mexe nak eku'nik'uifik'ikii pakha' ƚ'ithi'wet, ma' qa uja'xe'ƚe wetju'ƚ pa'aj qu' natfaakate'yijju', ");
INSERT INTO mca_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","qa yit'ijju' pa'aj: —¿Pa'n ineqfenyejeyij enewe' jukhew? Qe kakha' ewi'ƚ na'lij in ham ƚunye'ji'iju'ƚ yaqsiijkii nekhewe'en, week nikfe'letsha enewe' i'ni' ha'ne Jerusalén in yijaa'ija kakha'an, qa ham ƚeke'ye' qu' jintittaajets qu' nite' yija'ye'. ");
INSERT INTO mca_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Qa qu' nite' weeki'ij ha'ne week witset pekhewe' nifel, yape jit'ijeweikitijkii pe'qu' i'nlijeye', hats'inha qu' yape hasu'uj nenfeli'm pakhape' iye jukhewe' aka' witii.— ");
INSERT INTO mca_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ma' qa in taya'yiifik'i iye pa'aj qa yiyajitaxijets qu' yape hasu'uj nenfel qa qu' ninq'ijatshenij iye kakha' ƚii pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Qa hakha'ƚe Pedro qa ha' Juan iye, qa yeku'ƚ pa'aj: —Ekheweli'ƚ qu' enfeli'ƚ ye'm ¿me les ƚe'wisi'm pa' Dios qu' ekheweli'iƚ qu' heik'eni'ƚ ewets qa pakha'ƚe Dios qa' nite'ye', ");
INSERT INTO mca_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","qe yekheweli'ƚ nite' ƚeke' qu' hili'iƚij in henfeli'ƚ eke' hi'weni'ƚ qa hepi'ye'eƚ iye?— ");
INSERT INTO mca_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pekhewe' wit'alhei, in hats yili'ijju' in ewi'ƚij iye in yijiweikittaxkii, ma' qa yiwejinfik'ikii pa'aj, nite' yi'wen pa'qu' ƚeqfenyejeyi'ij ƚewek qu' ƚeke'ye' qu' nitanithen, qe ta'ƚets pekhewe' week jukhew qa efuts, qe week qi in yiwqinhet pa' Dios qe ta'ƚets pakha' ƚunye'jkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Qe pakha' jukhew pakha' wanaqsiimijkii pa'aj aka' ewi'ƚ ham ƚunye'ji'iju'ƚ, t'ani' qu' cuarenta (40) ƚeqe'ninqapitse'. ");
INSERT INTO mca_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ha' Pedro qa ha' Juan in hats t'atsji'ƚfik'ikii pa'aj, ma' qa ikii pakha' i'ni' pekhewe' hats ƚejefetsipji', ma' qa nifelimik'i pa'aj week pekhewe' yit'ijets pe' tenek'enhe'yij pe' pa'il qa pe' tenek'enheiji' pa' witset. ");
INSERT INTO mca_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","In yepi'ye' ek'i pa'aj aka'an pekhewe'en, qa yit'unhet ƚi'ijpha'mek pa' ewi'ƚik'i ƚ'a'x in iyinii pa' Intata, qa yit'ijiipha'm: —Yatsat'axyij, akha' pakha' yaqsiijkii pa'aj na' wa's qa ha'ne sehe', qa pakha' qi iweli' iye qa week iye pekhewe' i'nji' enewe'en. ");
INSERT INTO mca_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Akha' ƚenukinijetsju' pa'aj pa' Espíritu Santo pe' e'lijei pa' eqejkunenek'ik'i yaqwa'maxi'ƚik'i David, ma' qa nifel pa'aj in ƚit'ij: “¿Inhats'ek in nayu'kii nekhewe' nite' judiol, qa nekhewe' Israel ƚeiƚets qa yijamti'ets qu' naqsiijkii pekhewe' wekwek ham weju'ƚi'ij? ");
INSERT INTO mca_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pekhewe' wittatal ha'ne sehe' yit'ijju' pakha' t'eku'mi' qu' naqsiijkii, qa pe' tenek'enhei qa ewi'ƚ i'niji' in t'eku'mij wetju'ƚ qu' net'ejuyiju'ƚ pa' Yatsat'ax'inij Dios qa pa' ƚeqe Cristo.” ");
INSERT INTO mca_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Qe yijaa'ija ha'ne witset in not'axi' wetju'ƚ hakha' Herodes qa ha' Poncio Pilato qa week nekhewe' jukhewiikal nite' judiol qa nekhewe' witsetits ha'ne Israel, qa ewi'ƚ i'niji' in t'ejuyiju'ƚ hakha' ƚe'wis oqwomehe' Jesús, hikha' ƚ'ekumiiji' pa'aj, ");
INSERT INTO mca_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","qe qa' naqsiijkii enewe'en pakha' hayiits yaji'letju' pa'aj pa' et'unha'x qa pa' ikfeliya'xkii iye qu' ƚunye'je'kii. ");
INSERT INTO mca_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Qa hane'ej Yatsat'axyij, jeƚii wat'ij kakha' ts'ijiweikittaxi'ƚijkii enewe'en, qa ƚisij wat'ij ene' eqejkunenhei pakha' qu' nite' ƚ'ijiweyaxitsi'ipji' qu' nenfel eke' e'lijei, ");
INSERT INTO mca_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","qa pa' ƚet'unha'x pa' okoi qa' naqsiijkiyek qu' nenqiƚinkii, qa qu' naqsiijkii iye pe'qu' ham ƚunyejeyi'iju'ƚ qa pe'qu' qi qu' nitjuƚaxijpha'mkii iye qu' nata'ƚets aka' ƚiiji' hakha' qi ƚe'wis oqwomehe' Jesús.— ");
INSERT INTO mca_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Qa in hats uja'xƚi'ik'i pa'aj in iyin, ma' qa pakha' i'niji' in not'ax wetju'ƚ qa me'le'le'l pa'aj. Qa week topolij pa'aj pa' Espíritu Santo, ma' qa nite' nijiweyipji' in nifel ke' ƚe'lijei pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pekhewe' tek'enik'i pa'aj week ewi'ƚ pa' ƚaqjamtikineyejeikii. Ham pa'qu' nit'ijets qu' natsat'etsijha pekhewe' yatsat'etstaxijha in ƚewekwekits, qe weekij yijat'ij in yatsat'etsij week pekhewe' wekwek. ");
INSERT INTO mca_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Qi pa'aj pa' ƚet'unha'x hekhewe' apóstoles qa nite' yili'ij pa'aj in nifel in iƚa'x iye pa' Yatsat'ax'inij Jesús, qa qi pa'aj in yi'fen pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ham pakha' qu' hami'im pa'aj pe'ye' pekhewe'en, qe week pekhewe' na'li'm ƚeqe sehel qa pe' ƚetsil iye qa t'ihinji'jij pa'aj, qa neka'xiikii pe' ƚ'astai ");
INSERT INTO mca_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","qa tisji'jij pa'aj he' apóstoles. Ma' qa netisjiiju' pe' weekji' pakha' qu' hame'jiji'm pe'ye'. ");
INSERT INTO mca_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qa pakha' José, Chipre ƚeiƚe', ewi'ƚ jukhew ta'ƚets pekhewe' ta'ƚets pa'aj pa' Levi'ik'i, qa he' apóstoles qa ƚeqiyij pa'aj Bernabé, ikji' eq'iltinhetsax. ");
INSERT INTO mca_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pakha'an na'li'm pa'aj pa' ƚeqe sehe', ma' qa t'ihinij pa'aj. Qa pe' ƚ'astai qa neka'xii pa'aj qa tisij he' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Qa pakha'ƚe ewi'ƚ jukhew ƚii Ananías qa pe' ƚewhe'ye' Safira, t'ihintaxij iye pa'aj pa' ƚeqe sehe'. ");
INSERT INTO mca_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Qa amaneiƚi'ij pa'aj pe' uja'x pe' ƚ'astai, qa hatsƚe weeki'ƚij pe' ƚewhe'ye' in nikfe'li'ƚets, ma' qa pe' uja'x iye qa tisij pa'aj he' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma' qa ha' Pedro qa yit'ijets pa'aj: —Ananías, ¿inhats'ek pa' inwo'met (Satanás) in yoponhetij pa' atawe'j qa ƚaqantaxkii pa' Espíritu Santo, ma' qa amaneitaxij pa' ƚapk'as pe' ƚaja' pa' sehe'? ");
INSERT INTO mca_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","In mexe nite' ƚ'ihinij, ¿me nite' ƚantsat'axij? Qa in hats ƚ'ihinij, ¿me qa nite' akha' qu' ejeƚijkii pa'qu' eqfenye'ji'ij pe' ƚ'astai? ¿Inhats'ek in ƚ'enji' pa' atawe'j qu' aqsiijkii aka'an? Nite' ene' jukhew qu' aqankii, qe pa' Dios hikpa' ƚaqantaxkii.— ");
INSERT INTO mca_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","In yepi'ye' ek'i pa'aj pa' Ananías ekewe' wi'tlijei, qa namju', qa ƚeyi'jju' pa'aj in wa'm. Qa week pekhewe' i'ye'ej pa'aj qa qi in nijiwei. ");
INSERT INTO mca_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ma' qa niipha'mkii pe' jutjanhets qa yijuphe'ƚ qa yahi'nfik'i pa'aj qa ti'jik'ui. ");
INSERT INTO mca_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ma' qa in hats suujik'i pa'aj i'nƚi'i qu' wetshetk'ewi'ƚ horayi'ik'i pa'aj in namtax pe' ƚewhe'ye', nite' nikfe'lets pa'aj pakha' ƚunye'jkii. ");
INSERT INTO mca_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ha' Pedro qa nifaakan pa'aj: —Enfel ye'mha, ¿me ƚ'ihiniƚij pa' eqe sehe' e'ƚ aka' uja'x?— Pekhe'en qa yeku'ƚ pa'aj: —Ehe, hik kakha' ƚajanye'j.— ");
INSERT INTO mca_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ma' qa ha' Pedro qa yit'ijets: —¿Inhats'ek in ƚ'eku'mi'ƚij wetju'ƚ in ƚatyaji'i'ƚij qu' ijaajini'ƚ pa' ƚeqe Espíritu pa' Yatsat'ax'inij? Hats na'liju'ƚ ne' ti'jik'ui iku'uj ka' ewhe'ye'ek'i qa hane'ej qa' akha'ye' qu' neti'j ek'ui.— ");
INSERT INTO mca_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Qa hik pakha'aj pe' efu qa namijupju' ƚef'iyeyiiju' pa'aj ha' Pedro, qa s'uuf pa'aj. Qa in hats te'nuitaxetsji' iye pa'aj pe' jutjanhets, qa yeeƚtax iye pa'aj in hats wa'm iye. Ma' qa yeka'xfik'i iye pa'aj qa yimetinheti'm pa' tiji'k'uyi' iye pe' ƚesehek pa' ƚewhe'ye'ek'i. ");
INSERT INTO mca_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ma' qa week pekhewe' yijayan pa' Jesús qa week iye pekhewe' i'ye'ej aka' ƚunye'jkii pa'aj, qa qi in nijiwe'yets pa'aj qu' ƚunyejeye' aka'an. ");
INSERT INTO mca_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pe' ƚokoyei hekhewe' apóstoles i'nijji' pa' Dios in yaqsiimijkii pekhewe' olots ham ƚunyejeyi'iju'ƚ qa pekhewe' iye qi in yitjuƚaxijpha'mkii pekhewe' jukhew qa efuts iye. Week not'axji'ij qu' ewi'ƚ na'nji'ji' pa' ts'eewe'efi estji' ƚii Salomón pe' qi witlijtsitjiyetsji'. ");
INSERT INTO mca_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Qa hamƚe pekhewep pakha' qu' nisu'un qu' nakets iye pekhewe'en, ƚa'mek, pakha' week witset qa yiwqinhetji' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Qa pe' tek'enets nite' yeqeku' pa' Yatsat'ax'inij, qa hats les in t'ijaifik'iha pa'aj, olotsija pekhewe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Qi'ija in nite' yeqeku', ma' qa neka'xijetsfik'ikii iye pe' wanqaats'eju' pe' ƚewhilaxits qa ƚalatits iye pa' wit'ikheyi'j, hats'inha qu' nenekik'i pa' wit'ikheyi'j ha' Pedro. Ma' qa nasinipji' pe'ye' pa' ƚesi'nq'al, ƚeq'eneƚeya'x. ");
INSERT INTO mca_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Qa pekhewe' iye i'ni' pe' witsetits ƚelits ƚekuwelii na' Jerusalén, qa namii iye pa'aj neka'xiikii pe' wanqaats'eju' qa pekhewe' i'nji' pekhewe' uƚ'ets espíritus, ma' qa week iƚii pa'aj enewe'en. ");
INSERT INTO mca_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma' qa pa' qiji' ƚatata pe' pa'il qa pekhewe' iye saduceos ewi'ƚ i'ni'ƚi' pa'aj, qa qi in teqemtshenetskii pa'aj hekhewe' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Qa te'nekumhi'yi' pa'aj he' apóstoles qa wenuihinifi pe' witq'opheƚitjii. ");
INSERT INTO mca_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Qa pakha'ƚe ewi'ƚ ƚaqa ángel pa' Yatsat'ax'inij, in najaleikii, qa yit'ijik'i qhof pe' ƚejil qa yeka'xik'uifik'ikii pa'aj, qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Ma'aƚii iye ne' qi witlijtsitjii qa' ats'ap'ayi'iƚijifi iye qu' enfeli'ƚi'm ha'ne witset week ekewe' wi'tlijei t'ejuyets na' witiƚa'x nite' yili'ij.— ");
INSERT INTO mca_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","In yepi'ye' ek'i aka'an, ma' qa uyifi iye pa'aj in leefiju' kekhe' qi witlijtsitjii ma' qa i'nq'ijatshen iye pa'aj. Pa' qiji' ƚatata pe' pa'il qa week pekhewe' ewi'ƚ i'ni'ƚi' pakha'an, ma' qa iyinii pa'aj qu' nonothet wetju'ƚ pa'aj pe' week pekhewe' Junta Suprema, ikji' pekhewe' wit'alheiji' pa' Israel. Ma' qa inq'ukintaxii pa'aj pe' witq'opheƚitjii qu' netetka'xii he' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Qa pekhewe'ƚe oq'opheƚinetsilets in yamtaxii qa ham pa'qu' ni'wenifi pekhewe'en pe' witq'opheƚitjii. Qa tepilii iye pa'aj pekhewe' ƚ'alhei, qa nifeli'm qa yit'ijets: ");
INSERT INTO mca_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—In tsami'ƚets ke' witq'opheƚitjii week yijanit'etsji' he' ƚejil qa he' yejeƚ qa ts'ap'a'ajup iye he' ƚejil. Qa in hi'ttaxi'ƚij qhof qa k'uitaxi'ƚifi qa ham pa'qu' hi'weni'ƚ.— ");
INSERT INTO mca_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","In yepi'ye' ek'i pa'aj ekewe'en pakha' tenek'enhe'yipji' (capitán) pekhewe' yejeƚ ke' qi witlijtsitjii qa pekhewe' iye tenek'enhe'yij pe' pa'il, ma' qa qi in qhel qhelij wetju'ƚ pa'qu' nit'ijju', ma' qa aje'eƚ yumti'ijets iye qu' les juffe' pa'qu' ƚunyejeye' iye pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Qa suujƚe in nametsji' pa'aj pa' ewi'ƚ jukhew, qa yit'ijets pa'aj in nifeli'm: —Hekhewe' jukhew ƚo'nophe'ƚtaxi'ƚju' hats i'ni' iye ne' qi witlijtsitjiyii yijatshen iye hekhewe' jukhew qa efuts iye.— ");
INSERT INTO mca_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ma' qa pa' tenek'enhe'yipji' (capitán) pe' oq'opheƚinetsilets yejeƚ pe' witlijtsitjii qa ikii pa'aj he' apóstoles ƚijts'eyek pe' ƚelits oq'opheƚinetsilets, qa neka'x pa'aj ham ƚeqfenyejeyi'ij, qe nijiweyiju'ƚ pekhewe' jukhew qa efuts iye, qe q'ax qu' nenjele'ejkii pe'qu' utele'. ");
INSERT INTO mca_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","In neka'x pa'aj qa yenji'ju' pakha' ƚeqewuk'uji' pekhewe' wit'alhei Junta Suprema. Ma' qa pakha' qiji' pa'il ƚatata ");
INSERT INTO mca_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","qa yit'ijets pa'aj: —Yekheweli'ƚ hayiits k'ayajitaxi'ƚijetsha' qu' yape hasu'uj i'nq'ijatsheni'ƚij kakha' witii. Jeƚ qeku'ni'ƚek, hats week topo'oj ha'ne Jerusalén pekhewe' ƚ'inq'ijatsheniƚij. Qa ƚisu'uni'ƚ iye qu' it'iƚij yiwets qu' yekheweli'iƚ qu' hilani'ƚ kakha' jukhew'ik'i.— ");
INSERT INTO mca_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Qa hakha'ƚe Pedro qa week iye hekhewe' apóstoles qa yeku'ƚ pa'aj, qa yit'ijiju'ƚ: —Les ƚe'wis qu' nojo qu' heik'eni'ƚets pa' Dios qa' ink'aye'ƚe ene' jukhew. ");
INSERT INTO mca_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Pakha' ƚeqe Dios pe' i'nalheyik'i hats yiƚin iye ha' Jesús, hik hakhaa'ija ekheweli'ƚ ƚilani'ƚ qa ƚ'eni'ƚji'pha'm ke' ewi'ƚ k'ayaji' (cruz). ");
INSERT INTO mca_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Hakha'an pa' Dios hats yiwqinhetji' qa yinhiniju' pa' yiya'yik'i, ma' qa ƚakha' qa Tenek'enhei qa Eqiƚina'x iye, hats'inha ha'ne Israel qa ƚeke'ye' qu' nenikfelitijƚetets pa' uƚ'ax in yaqsiijkii ma' qa' nawatwamhitik'i pe' ƚewuƚ'ets. ");
INSERT INTO mca_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yekheweli'ƚ tsikfe'li'ƚets qa hi'weni'ƚ iye ekewe' wekwek, qa pa' Espíritu Santo iye qa yi'wenij iye, hik pakha' pa' Dios tisij pekhewe' qu' netk'enets.— ");
INSERT INTO mca_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","In yepi'ye' ek'i pa'aj aka'an, ma' qa qi in nayu'kii pa'aj pekhewe'en qa neqek'uyutaxijju' pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Qa pakha'ƚe ewi'ƚ fariseo ƚii Gamaliel, i'nq'ijatshenij iye kekhewe' Moisés ƚe'lijei, pe' jukhew yisu'un yiwqinhetji' iye pa'aj pakha'an. Qa ts'ap'a pa'aj qa mexe yuki'nfik'ikii ƚ'ajƚi'ij he' apóstoles. ");
INSERT INTO mca_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ma' qa yit'ijji'ju' pa'aj: —Jukhew Israel ƚeiƚets, jeƚi'ƚiju'ƚ pakha' ƚeneqfenyejeyu'uƚij enewe' jukhew. ");
INSERT INTO mca_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ijamti'iƚik'i mente' toxik'i pakha' Teudas'ik'i in we'nt'unhettax qa wo'taxii pa'qu' ƚunye'je'. Qa olots pa'aj pe' yijayan i'nƚi'i qu' cuatrocientoye' (400) pe' jukhew. Qa talanhetiiƚe pa'aj qa week pe' yijayantax pa'aj qa yak'eskii, ma' qa yili'ij pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Qa ƚ'anu'upji' iye aka'an qa niipha'm iye in we'nt'unhettax iye pakha' Judas'ik'i Galilea ƚeiƚe', pekhewe' neƚutsji' pa'aj in wetjeyumtshen ene' week (censo). Qa olots iye pe' yijayan pa'aj jukhew. Qa wa'mƚe iye pa'aj, qa week pekhewe' yijayantax qa yak'eskii iye, ma' qa yili'ij iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Qa hik ta'ƚijupi' qu' hit'iƚij ewets: hasu'uj pa'qu' eneqfenyejeyu'uƚij enewe' jukhew. Iwejinƚi'ij, qe kakha' naqaqsijkineyu'ujkii axe'm qu' hats naqsiijkii qu' nata'ƚƚe'ets ene' jukhewƚe, ma' qa' nili'ij hatse'. ");
INSERT INTO mca_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Qa qu' nata'ƚƚe'ets pa' Dios, qa' nite' amiti'iƚ qu' iwuƚ'enhettaxi'ƚijkii. Jeƚi'ƚiju'ƚ, hasu'uj ejuihifeyi'iƚij pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Qa week yumti qu' nasiinik'iha. Ma' qa in hats taya'yiifik'i iye pa'aj he' apóstoles qa neqsilanju' pa'aj, qa yittaxijets iye qu' yape hasu'uj nenfel kakha' Jesús ƚii, ma' qa yiwejinfik'ikii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","He' apóstoles qa ikik'uifik'i pa'aj pe' wit'alhei. Qa qi in ƚe'sitsi'mkii pa'aj, qe pekhewe'en nikfe'lets pa' Dios in hats nikfe'lets in hats qitsi'm pa' nite' ƚeqekuyejei pekhewe'en, ma' qa yiwejinets qe hats weju'ƚiju'ƚ qu' nataatshenhetii qu' nata'ƚets kakha' Jesús ƚii. ");
INSERT INTO mca_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Week neƚuts, kekhe' qi witlijtsitjiyifi qa ƚunye'j ji'ij pe' wititsiliikii in nite' yili'ij in i'nq'ijatshenij qa nifel iye pa' Jesús in hik pakha' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pekhewe' neƚutsji' pa'aj, in hats t'ijaifik'iha pa'aj pe' nite' yeqeku', ma' qa pekhewe' judiol Grecia ƚeiƚets qa na'l pa'aj pa' yutenij ƚunyejei pe' judiol itsetina'x, qa yit'ijets pekhewe' ƚeqe wikiihalei pekhewe'en in nite'te' testiiji'ij qa te'nineiji'ijkii pe' witqats week neƚuts. ");
INSERT INTO mca_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ma' qa he' doce (12) apóstoles qa no'thet wetju'ƚ pa'aj pekhewe' week hats yijayan pa' Jesús, qa yit'ijji'ju' pa'aj: —Nite' ƚe'wisijupi' qu' nite' hejeƚi'iƚets ekewe' ƚe'lijei pa' Dios ma' qa' k'ejeƚiƚijets pekhewe' aqatsi'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Qa hik ta'ƚijupi', yejefets, jeƚi'ƚji' qa ku'mi'ƚiiji' nekhewe' i'ni'ƚ etji'teje'm pe'qu' wetsjuk tatsai (7) jukhewe' qu' enikfe'li'ƚijets pa'qu' ƚunyejeye' in ƚe'wis, qa qitsi'm iye pa' Espíritu Santo qa pa'qu' ƚikfeliyaxitse'kii iye. Qa hik pekhewe'ye' qu' hetisi'ƚij aka'an qu' nithayiki. ");
INSERT INTO mca_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Qa yekhewelƚi'iƚ qa' hetjimaaƚijek qu' nek'iyini'ƚ qa qu' nek'inq'ijatsheniƚij iye ke' ƚe'lijei pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Week yi'sinhetijupi' pa'aj aka' wenit'ij. Ma' qa t'eku'miiji' pa'aj pa' Esteban, hik pakha' qi'imha pa'aj pa' nite' ƚeqekuye'j qa pa' Espíritu Santo iye. Qa t'eku'miiji' iye pa' Felipe, pa' Prócoro, pa' Nicanor, pa' Timón, pa' Parmenas qa pa' Nicolás, hik pakha' ta'ƚiyek ha' Antioquía hatsƚe judio'oj pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma' qa pekhewe'en qa neka'xets pa'aj he' apóstoles, qa in naxijik'i in iyinipji' pa'aj, ma' qa week he' apóstoles qa t'eku'mipji'kii pa'aj ƚeiƚal pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma' qa kekhewe' ƚe'lijei pa' Dios qa hats qi'ija in t'ijaifik'i pa'aj, qa pakha' uja'x pekhewe' tek'enets pa'aj i'ni' na' Jerusalén qa qi'ija in t'ijaifik'i pa'aj, qa olots iye pa'aj pe' pa'il tek'enik'i eke' witlijei t'ejuyets pa' nite' witqekuye'jij pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pa' Esteban, qi'im pa'aj pa' nite' ƚeqekuye'j qa pa' ƚet'unha'x iye, qa yaqsi'ji'mijkii pe' qits ham ƚunyejeyi'iju'ƚ qa pe' yitjuƚaxijpha'mkii iye pekhewe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma' qa pe' uja'x pekhewe' judiol pe' ƚe'lijtsitjii ƚiyek “Libertos”, wenetsji'ƚiƚ pe' judiol ta'ƚii pa' sehe' Cirene qa pe' ta'ƚii pa' witset Alejandría qa pe' ta'ƚiyek pa' sehe' Cilicia, qa pe' ta'ƚiyek pa' sehe' Asia qa iyeti'ƚju' pa'aj pa' Esteban qi in t'unitsik'i pe' ƚe'lijei pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Qa nite'ƚe weju'ƚiju'ƚ pekhewe'en qe pa' Esteban in iyet qi pa' ƚikfeliya'xets pe' wekwek ta'ƚets pa' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ma' qa pekhewe'en qa wanat'inij pa'aj in yiyaji'etskii qa yijanin pekhewe' uja'x jukhew qu' nowotk'onijkii pa' Esteban qa' nit'ijju': —Hepi'ye'eƚij in uƚ'etsik'i kekhewe' ƚe'lijeyij pa' Moises'ik'i qa pa' Dios iye.— ");
INSERT INTO mca_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ma' qa pekhewe'en qa ta'ƚets in yiwakaninkii pa'aj pa' witset, qa week iye pe' tenek'enhei qa pekhewe' iye i'nq'ijatshenij ke' Moisés ƚe'lijei. Qa t'eku'mi' pa'aj qa yeka'xii pekhewe' Junta Suprema. ");
INSERT INTO mca_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ma' qa yits'apanhetji'ju' ƚeqewuk'u pekhewe' jukhew qu' nowotk'oni'mkii pe' wit'alhei, qa yit'ijju' pa'aj: —Ha'ne jukhew nite' yili'ij in uƚ'ax qa iyetji'jij in t'ejuyiju'ƚ ne' qi witlijtsitjii qa t'ejuyiju'ƚ iye kekhewe' yit'ij pa'aj pa' Moises'ik'i, ");
INSERT INTO mca_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","qe hepi'ye'eƚij in yit'ijets kakha' Jesus'ik'i, Nazaret ƚeiƚe'ek'i, qu' niwu'm hatse' ne' qi witlijtsitjii qa' nink'aihitik'ui iye kekhewe' injunyejei jiyejetij pa'aj pa' Moises'ik'i.— ");
INSERT INTO mca_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma' qa in yejeƚtaxje'mha pa'aj pa' ƚeju's pakha'an, week pekhewe' i'nju'kii wit'alhei (Junta Suprema), qa yi'wen pa' ƚeju's in hik ƚunye'j qu' angele'. ");
INSERT INTO mca_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ma' qa pa' qiji' pa'il ƚatata qa yit'ijets pa'aj pa' Esteban: —¿Me yijaa'ija aka'an?— ");
INSERT INTO mca_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pakha'an qa yit'ij pa'aj: —Ek'en qeku'ni'ƚ yiwetsek, yejefets qa wit'alhei iye. Pakha' ƚe'wis Dios we'nethinets pa'aj pakha' i'nalek'ik'i Abraham in mexe i'ni' pa'aj pa' sehe' Mesopotamia, in mexente' i'ni'kii pa'aj pa' witset Harán. ");
INSERT INTO mca_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Qa yit'ijets pa'aj: “Ma'ak'ui ha'ne eqe sehe' qa enewe' iye ejefets, qa' amii na' sehe' yakha' qu' k'ethinij.” ");
INSERT INTO mca_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ma' qa pa' Abraham qa ikik'uifik'i pa'aj pekhewe' ƚiyits caldeos, qa yamii qa i'ni'kii pa' Harán. Qa hikpa' qa ta'ƚi' pa'aj in hats wa'm pa'aj pa' ƚatata'ak'i, qa pa' Dios qa neka'xii pa'aj ha'ne hane'e'in sehe', ha'ne hane'ej ekheweli'ƚ ƚa'ni'ƚi'. ");
INSERT INTO mca_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Qa pa' Dios qa nite'ƚe tisij qu' natsat'axij nite' iye pa'qu' ƚuk'eye'en ha'ne sehe'. Ƚa'mek qa yit'ijets pa'aj in yiwjutsiqeni'm pa' Abraham in mexe hamtax pa'qu' ƚa'se' qu' netisij ha'ne sehe' qa week pekhewe' qu' nata'ƚets hatse' pakha'an. ");
INSERT INTO mca_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Qa yi'tƚi'ijets iye pa'aj pa' Dios aka'an: “Pekhewe' ta'ƚ ewets hatse' i'nji'kii hatse' pa'qu' nite' natsat'etsi'ij witset ma' qa jukhewiikali'ij, ma' qa' hikpa' qu' na'ni' qu' witƚinheyi'ij qa' qi qu' natawitjaxtii qa' namijets cuatrocientos (400) ininqapits. ");
INSERT INTO mca_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Qa' hitani'thenƚe yakhaa'ija qu' hitatinithen pakha' qu' ƚunye'je'ƚe pe' witsetits qu' ƚeƚinheye'taxi'ƚ ej,” yit'ij pa'aj pa' Dios, “qa' ƚ'anu'upji' aka'an ma' qa ma'aƚik'uifik'i pakha' witset qa' iyini'ƚyii qu' ni'iƚiji' ha'ne hane'e'in sehe'.” ");
INSERT INTO mca_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma' qa pa' Dios qa tisij kakha' ewi'ƚ qu' ƚeqfenyeje' ƚewek ƚii circuncisión. Qa hik aka' ƚunye'j pa'aj pa' Abraham qa nekfik'i pa' ƚa's Isaac, qa in hats wetshetk'ewi'ƚ tatsai (8) ƚeqe neƚutsfik'i pa'aj qa yaqsiijkii kakha' circuncisión. Pa' Isaac qa hikpa' ƚatata pa' Jacob, qa Jacob qa ƚatata'ek pekhewe' pe' doce (12) jukhew jita'ƚets pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ma' qa enewe' jita'ƚets pa'aj qa teqemtshenetskii pa'aj pa' José, ma' qa t'ihinij qu' newetka'xii pa' Egipto. Qa pakha'ƚe Dios qa yejeƚets pa'aj pakha'an, ");
INSERT INTO mca_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","qa yilithinik'ui pe' wekwek yaats'etaxij, qa tisij iye pa' ƚikfeliya'xets pe' wekwek qa yisu'unkeninij iye pa' Faraón, wittata pa' Egipto, hik pakha' yeni' pa'aj qu' netnek'enhei (gobernador) pa' week Egipto qa week iye pekhe' ƚetsi'. ");
INSERT INTO mca_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma' qa nam pa'aj pa' yipku' pakha' week sehe' Egipto qa pa' sehe' Canaán iye, qa qi pa'aj pakha' yaats'e'ej, qa pe' inalheiyik'i qa ham pa'aj yeeƚi'ijji' pa'qu' ƚaqe'. ");
INSERT INTO mca_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma' qa pa' Jacob in i'ye'ej pa'aj in na'li' pa' Egipto pe' witqats trigo qa yukinii pa'aj pekhewe' ƚelits i'nalheyik'i, hik pakha'aj i'nk'aƚe pa'aj yamii. ");
INSERT INTO mca_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Qa in wapilii iye pa'aj, ma' qa hik pakha'aj qa tetfeli'm pa' José pekhewe' ƚejefets. Qa hik aka' ƚunye'j pa' Faraón in nikfe'lets pa'aj pekhewe' ta'ƚets pa' José. ");
INSERT INTO mca_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma' qa pa' José qa inqekenij pa'aj pe' ƚe'lijei, qa iyinii pa' ƚatata Jacob qa week pekhewe' yatsat'etsij pakha'an uja'x yamets pa'aj in week setenta y cinco (75) pe' jukhew. ");
INSERT INTO mca_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ma' qa hik ta'ƚijupi' pa' Jacob qa yamii pa' Egipto, pakha'an qa hikpa' wa'mi' pa'aj qa week iye pekhewe' i'nalheyik'i. ");
INSERT INTO mca_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Qa pe' ƚenuts wa'nahinii pa'aj pa' sehe' meti'm pa' witset Siquem, qa we'neni' pa'aj pakha' nimeƚkuket, pakha' sehe' taqhayijets pa'aj pa' Abraham'ik'i pekhewe' ƚelits pa' Hamor'ik'i i'ni' pa' witset Siquem. ");
INSERT INTO mca_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Qa in hatsƚe k'esiyu'ets pa'aj pa' ƚahats'ij qu' nafits pakha' hayiits yiwjutsiqeni'm pa'aj pa' Dios pa' Abraham'ik'i, qa pe' Israel qa hats qi in t'ijaifik'i pa'aj in i'ni' pa' Egipto, ");
INSERT INTO mca_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","yamƚi'ijii in ink'ayik iye pakha' wittata pa' Egipto, pakha'an qa hats nite' nikfe'lets pa'aj pa' Jose'ek'i. ");
INSERT INTO mca_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ha'ne ink'ayik wittata pa'aj, qi in yawitji pa'aj pe' inejefetsik'i. Qa inaqyaji'ij pe' i'nk'a nekji'ijtaxfik'i qu' netwumhitiiƚeji'ij, ma' qa' nawa'mƚeji'ij. ");
INSERT INTO mca_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Qa hik pakha'aj pakha' ƚahats'ij pa'aj pa' Moises'ik'i qa nekfik'i pa'aj, pakha'an pa' Dios yisu'un pa'aj. Qa pe' ƚ'alheyik'i qa yejeeƚetsha pe' ƚetsi'ii pa'aj yamijets wetshetk'ewi'ƚ juwelits. ");
INSERT INTO mca_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma' qa in hats nite' ƚeke' pa'aj qu' naqsi'j, qa yeka'xtaxfik'i ma' qekha nawa'mƚetax, qa pe' Faraón ƚasi' qa t'eku'mi' pa'aj qa yaqsi'j qa hik ƚunye'j qu' ƚa'se'. ");
INSERT INTO mca_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma' qa pa' Moisés qa t'ijatshenheti'yij week pa' ƚikfeliya'xets wekwek pe' Egipto ƚeiƚets, qa nikfe'lets pa'qu' nit'ij qa pa'qu' naqsiijkii iye. ");
INSERT INTO mca_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Qa in hats k'esiyu'ets qu' cuarenta (40) ƚeqe'ninqapitse' pa'aj pa' Moisés, ma' qa yoksi'wen pa'aj pa' ƚatawe'j in yisu'un qu' nat'alit'ii pe' ƚejefets, hik pekhewe' israel'ik'i ƚelits. ");
INSERT INTO mca_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Qa hik pakha'aj qa yi'wenij pa'aj pa' Egipto ƚeiƚe' in qi in yawitji pa'aj pa' Israel ƚeiƚe'. Qa te'weyik'i pa'aj pa' Moisés qa yilan pa'aj pa' Egipto ƚeiƚe'ek'i. ");
INSERT INTO mca_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pa' Moisés yumtitax pekhewe' ƚejefets qu' hats nenikfe'lik'uyi' pekhewe'en, pa' Dios qu' nukinfik'ikii hatse' qu' na'nijji' pakha'an, qa nite'ƚe nikfe'lik'uyi' pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Qa pakhap neƚukii qa yamii pa'aj pekhewe'en, qa yi'wenij pa'aj pekhewe' wetsjuk in ijenju' wapilƚe wetju'ƚ pa'aj, qa yaq'ayintax wetju'ƚ, qa yittaxijets: “Jukhew, e'witjefeye'k ini'ƚek, ¿inhats'ek in uƚ'etsi'ƚ wetju'ƚ?” ");
INSERT INTO mca_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Qa pakha' teqek'uikii pa'aj qa weqwu'm pa'aj, yiwu'm pa' Moisés, qa yit'ijets: “¿Ƚek pakha' neni' qu' enek'enhe'yi'ƚyipji' qa qu' e'juezi'iƚ yipji' iye? ");
INSERT INTO mca_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ye' me ƚenqek'uyu'yij iye qu' hik ƚunye'je' ka' ƚilan neƚu egipto'ok'i?” ");
INSERT INTO mca_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ma' qa in yepi'ye' ek'i pa'aj aka'an, pa' Moisés qa ilatii pa'aj qa i'ni'kii pa' sehe' ƚii Madián. Qa hik pakha'a' qa na'l pe' ƚelits wetsjuk. ");
INSERT INTO mca_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ma' qa in hats yamijets cuarenta (40) ƚeqe'ninqapits in i'ni'kii pakha'an, qa we'nethinets pa'aj pa' ewi'ƚ ángel i'nji'teje'm pa' ƚ'elepep pe' ewi'ƚ najkak ƚasi' in tujje'm pa'aj pakha' ham i'ni'i' qa meti'm pe' utek ƚii Sinaí. ");
INSERT INTO mca_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pa' Moisés yitjuƚaxijpha'm pa'aj in yi'wen aka'an. Ma' qa in iktaxets pa'aj qu' netmetinheti'm lees qe qa' itometsaaxji'ijha, ma' qa yepi'ye' pa'aj pa' ƚ'a'x pa' Yatsat'ax'inij, qa yit'ij pa'aj: ");
INSERT INTO mca_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yakha' ƚeqe Dios ke' alheyik'i Abraham, Isaac qa Jacob.” Pa' Moisés qa tsalalkii pa'aj, qa nite' yejeƚju' pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Qa pakha'ƚe Yatsat'ax'inij qa yit'ijets pa'aj: “Enit'ijji' ne' otshilaxtiiqe ha'ne sehe' mexe ha'ni'. ");
INSERT INTO mca_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Hi'wenijha na' yitset in qi in tawitjaxtii in i'ni' na' Egipto, qa hepi'ye' iye in qi in yeqejtsile'ejkii. Qa he'yili'tju' qe qa' hiwejinkii. Te'ƚun, hane'ej qu' k'ukinii na' Egipto.” ");
INSERT INTO mca_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ha'ne Moisés, hik ha'ne pakha' t'oqowe'yiju'ƚ pa'aj pekhewe'en in yit'ijets pa'aj: “¿Ƚek pakha' neni' qu' enek'enhe'yi'ƚyipji' qa qu' e'juezi'iƚ yipji' iye?” qa hik hane'ija pakha' yukin pa'aj pa' Dios qe qa' netnek'enhei qa qu' nineqweji'nfik'i iye qu' nata'ƚets qu' ni'fen pa' ángel we'nethinets pa'aj pekhe' najkak ƚasi' ji'teje'm. ");
INSERT INTO mca_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ha'ne jukhew in yukinik'uifik'i pa'aj pa' Egipto, yaqsiijkii pe' ham ƚunye'ji'iju'ƚ qa qi in yitjuƚaxijpha'mkii pakha' witset'ii Egipto, qa pa' qi iweli'ii iye ƚii Mar Rojo qa in neki'kii iye pakha' ham i'ni'i' qa yamijets cuarenta (40) ininqapits pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Qa hik hane'ija iye ha'ne Moisés yit'ijets pe' ƚelits pa' Israel'ik'i: “Pa' Dios yaqsiijkii hatse' qu' nata'ƚi'ƚ etji'ju' pakha' ewi'ƚ profeta hik yijunye'j.” ");
INSERT INTO mca_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ha'ne Moisés hik ha'ne i'nji'teje'm pa'aj pekhewe' neki'kii pa'aj pa' ham i'ni'i', qa weekji' iye pa' ángel pakha' tafaakate'yi'ƚkii pa'aj pe' utekji'pha'm ƚii Sinaí, qa hik pakha' iye pa' tafaakate'yi'ƚ pa'aj pe' inqa'jteyik'i. Qa hik ha'ne iye ha'ne Moisés testi'yij pa'aj eke' wi'tlijei ta'ƚets pa' witiƚa'x qe qa' nayaxkit inwets qu' jineƚisij. ");
INSERT INTO mca_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Qa hane'en pekhewe' inqa'jteyik'i nite' yisu'un pa'aj qu' netk'enets, qe yutenija yijat'ij, qa pe' ƚatawjets qa yaqamaxji' in nipilheyu'taxii iye pa' Egipto. ");
INSERT INTO mca_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pekhewe'en qa yit'ijets pa'aj pa' Aarón: “Anaqsi'ji'ƚ ye'mju' pekhewe' qu' inqo diositsi'ij qa' hik pekhewe'ye' qu' nojo i'nk'ui, qe hakha' jiyekaxik'uifik'i ha' sehe' Egipto, Moisés, nite' tsikfe'li'ƚets pa'n qu' ƚunye'je'kii.” ");
INSERT INTO mca_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hik pakha'aj pekhewe' neƚutsji' qa yaqsiijkii pa'aj pa' ewi'ƚ wakka ƚa's qa yilanifi iye pe' inqa'metetsik'i pakha' witeqsi'nq'al, qa qi in yi'sinhet wetju'ƚ pa'aj pakha' ƚaqsijikƚi'ijkii pe' ƚokoyeiƚe pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Qa pakha'ƚe Dios qa we'nitonimets pa'aj pekhewe'en ma' qa tisij aka'an, hats'inha pekhewe'en qa' niyinii week pekhewe' i'nji' ha'ne wa's, in ƚ'anyejeyek pa'aj pekhewe' ƚafaakanhei pe' profetas'ik'i: “Israel'ik'i ƚelits, ¿me yakha' qu' anlani'ƚ yifikii qa ƚesƚisi'ƚij kekhewe' inqa'metetsik'i ƚami'ƚijets cuarenta (40) ininqapits in mexe ƚa'ni'ƚi'kii hakha' ham i'ni'i'? ");
INSERT INTO mca_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ekheweli'ƚ ƚekaxiƚkii ne' eqjiiki'iƚij na' witeqsi'nq'al Moloc, qa ne' ƚoqo footeki' na' dios Renfán, hik enewe' witeqsi'nq'alits ƚanaqsi'ji'ƚju' qe qa' iyini'ƚii. Qa yakhap ji'jek qu' k'ewu'mi'ƚii na' ƚ'anu'ui les toxi'mii na' Babilonia.” ");
INSERT INTO mca_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pekhewe' inqa'jteyik'i in i'ni'kii pa'aj ham i'ni' na'li'm pekhe' witlijtsitjii (tabernáculo) jutsiqaxij in i'nijupkiiha pa' Dios. Qa hik ƚunye'jija pekhe'en pakha' hats yit'ij qu' ƚunye'je' pakha' tafaakate'yi'ƚ pa'aj pa' Moisés, ma' qa hik ƚunye'jija pekhe' yi'wen pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Qa pe' i'nalheyik'i iye pa'aj qa yaya'xij iye qu' neka'xkii iye pe' witlijtsitjii in hats yojo'ok'oi pa'aj pa' Josué qu' ninqitka'mij pekhewe'en pe' witsetits, tetsetiitax pekhewe' yiwu'mfik'ikii pa'aj pa' Dios qa' nayaxkiti' pekhewe'en. Ma' qa hik pakha' qa i'ni' iye pa'aj pe' witlijtsitjii yamijii pekhewe' ƚeqe neƚutsji' pa'aj pa' David'ik'i. ");
INSERT INTO mca_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pa' David'ik'i yisu'unija pa'aj pa' Dios, qa pa' Dios qa yi'fenji'jek pa'aj, ma' qa inƚe in iyintaxijets pa'aj qu' naqsiimijkii pe'qu' ƚextsi'yi'ij pakha' ƚeqe Dios ene' ƚelits pa' Jacob'ik'i. ");
INSERT INTO mca_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Qa Salomonƚe pakha' niihinpha'm pa'aj pekhe' ƚextsi'ij pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ƚa'mek, pakha' qiji'ha in Dios qa nite'ƚe i'nifi pe' ƚaqsijiiƚeju' ene' jukhew, in ƚ'anye'jek kakha' yit'ij pa'aj pa' profeta'ik'i: ");
INSERT INTO mca_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Pa' Yatsat'ax'inij yit'ij: ‘Ha'ne wa's yits'oji'la'x qa ha'ne sehe' qa yotshilaxƚe. ¿Pa'n ƚunye'j pe' wititsi' ƚaqsi'jtaxi'ƚ ye'mijkii? ¿Pa'n i'ni' pakha' qu' ƚeke'ye' qu' hawapi'yi'? ");
INSERT INTO mca_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Me nite' hik ha'ne ha'ne yikoi yaqsiijkii ene' week wekwek?’” ");
INSERT INTO mca_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ekheweli'ƚ qi in ham ƚami'iƚik'ui, nite' ƚenk'enheyu'uƚets qa nite' ƚenexpiikeyu'uƚij iye. Hayiitsƚe nite' ƚ'eku'mi'ƚijiju'ƚ pe'ye' pa' Espíritu Santo, in ƚunyejeyek pa'aj pe' alheyi'ƚik'i, qa hik aka' ejunyejeyi'ƚ. ");
INSERT INTO mca_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Pa'n ƚii pekhewe' profetas'ik'i pakha' qu'nte' nijayane'kii pa'aj pe' alheyi'ƚik'i? Pekhewe'en week nilanju' pa'aj pekhewe' hayiits nifeltax pakha' ƚamijiiju' hakha' yijaa'ija in yatsathen, hik hakha' ekheweli'ƚ hane'ej qa ƚowotk'oni'ƚijkiyek qa ƚilani'ƚ iye. ");
INSERT INTO mca_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ekheweli'ƚ in neƚistaxi'ƚij pa' Dios kekhewe' yit'ij pa'aj qu' nanaqsiijkii (leyes) qa i'nijji' pa'aj pe' angelits, ƚa'mek qa nite' ƚ'ek'eni'ƚets kekhewe'en (leyes).— ");
INSERT INTO mca_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pekhewe'en in yepi'ye' ek'i pa'aj aka'an, qa yamik'ui wiikfik'i in nayu'kii, qa t'aiji' pe' ƚek'unhetii in qi in nayu'um pa' Esteban. ");
INSERT INTO mca_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Qa pakha'ƚe Esteban qa qi in topo'oj pa'aj pa' Espíritu Santo, qa yejeƚiipha'm pa'aj na' wa's, ma' qa yi'weniipha'm pa'aj pa' ƚesa'x pa' Dios qa pa' Jesús ts'ap'a'a' pa' yiya'yik'i pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Qa yit'ij pa'aj: —¡Jeƚ qeku'uƚetspha'm! Hi'wen ne' wasits wejje'm qa na' Ƚa's na' Jukhew qa ts'ap'a'a' na' yiya'yik'i na' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma' qa pekhewe'en qa taya'yij wetju'ƚ pa'aj, yit'onji' pe' ƚekfii qa t'ilit'ij wetju'ƚ pa'aj pa' Esteban. ");
INSERT INTO mca_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Qa yeka'xik'uifik'i pa'aj nakha' witset, qa yapeƚek pa'aj qa nijele'ejkii pe' utel. Pekhewe' yit'ijets in uƚ'ax pa' yaqsiijkii pa' Esteban qa yenijupju'kii pa'aj pe' ƚe'ntaafitits ƚef'iyeyiiju' pa' ewi'ƚ jutjana'x ƚii Saulo, qe qa' nejeƚi'mets. ");
INSERT INTO mca_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pa' Esteban in tejelaxti'yijkii pa'aj pe' utel, qa yit'ij pa'aj in iyin: —Yatsat'axyij Jesús, ku'miju'ƚ pa' yiƚa'x.— ");
INSERT INTO mca_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Qa yenju' pa'aj ƚaqhutsii qa tayai yit'unhetik'i in yit'ij: —Yatsat'axyij, hasu'uj ijanin aka' qi ƚewuƚ'ax enewe'en.— Naq'axƚi'ijik'i ek pa'aj aka' yit'ij qa wa'm pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Pa' Saulo yi'sinhetijupi'ha pa'aj in talanhetii pa' Esteban'ik'i. Hik pakha'aj pa' ƚahats'ij qa yape pa'aj qa i'nju' pa' qi a'tax ƚenifenyejei pekhewe' nite' yeqeku' pa' Jesús nakha' Jerusalenji'. Ma' qa week ilatkii yak'esji'kii pa' week sehe' Judea qa pa' Samaria iye, qa pekhewe'ƚe apóstoles qa nite' ilatkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Qa pe' uja'x jukhew yijayan pa' Intata qa ti'jik'ui pa'aj pa' Esteban'ik'i, qi in yayinju' pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Qa pakha'ƚe Saulo qa hats wo'oyek qu' niwuƚ'enhetju' qa' hamitse' pekhewe' tek'enets pa' Jesús, qa uyijik'i pe' wititsil, ma' qa yetsinji'ij pe' jukhew qa efuts iye yuihinjiifikii pe' witq'opheƚitjii. ");
INSERT INTO mca_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Qa pekhewe'ƚe ilatkii yak'eskii pa'aj qa nifelƚe iye pa'aj eke' ƚe'sits wi'tlijei pakha' qu' namji'ijji'. ");
INSERT INTO mca_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pa' Felipe qa yamii pa'aj pakha' witset'ija pa' Samaria, qa i'nq'ijatshenij pa'aj in t'ejuyets pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Qa not'axii pa'aj pe' olootsija, qa qi in tek'enets pa'aj in yepi'ye' pe' nifel pa' Felipe, qe yi'wenij iye pa'aj pekhewe' ham ƚunyejeyi'iju'ƚ in yaqsiijkii. ");
INSERT INTO mca_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Qe olots pa'aj pekhewe' i'ntaxji' pe' espíritus uƚ'ets (inwo'metets), pekhewe'en in ikjiik'uifik'i pa'aj qa tayaiji'ij wetju'ƚ. Qa olots iye pekhewe' onqokitstax qa pekhewe' iye f'oyoq f'oyoqtax in ƚe'sitsju' iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Qa pa' witset qa qi in ƚe'sitsi'mkii pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Qa na'l pa'aj pa' ewi'ƚ jukhew ƚii Simón, hayiits weihetaxji' pa'aj pa' witset. Qa nawitjiju'kii pe' Samaria ƚeiƚets, yit'ij ƚetets in ƚakha' ewi'ƚ jukhew qiji'. ");
INSERT INTO mca_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Qa week tek'enets pekhewe' if'iljetsits qa pe' patunits, qa yit'ijju': —Hane'en hik ha'ne pakha' ƚii Qi Ƚet'unha'x pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tek'entaxetsha pa'aj pekhewe'en qe hats olots pe' ininqapits in ikijje'm in yethinijkii pekhewe' yitjuƚaxjiijpha'mkii pekhewe'en. ");
INSERT INTO mca_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Qa pekhewe'en in hats nite' yeqeku' pa' Felipe in nifel eke' ƚe'sits wi'tlijei t'ejuyets pa' tenek'enheiji' pa' Dios qa aka' ƚii iye pa' Jesucristo, ma' qa wempuli'jijju' pa'aj pe' jukhew qa efuts iye. ");
INSERT INTO mca_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Qa pakha' iye Simón qa nite' yeqeku' iye pa'aj. Qa in hats wempuli'jij pa'aj, qa nite' yiton pa'aj pa' Felipe, qa qi qa yitjuƚaxjiijpha'm qa yi'wenji'ij pekhewe' qits ham ƚunyejeyi'iju'ƚ yaqsiijkii pa' Felipe. ");
INSERT INTO mca_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ma' qa hekhewe' apóstoles mexe amaneiji' pa'aj ha' Jerusalén, in i'ye'ej pa'aj pe' Samaria ƚeiƚets in hats testi'yij iye kekhewe' ƚe'lijei pa' Dios, qa t'ukinheti'yii pa'aj ha' Pedro qa ha' Juan. ");
INSERT INTO mca_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ma' qa in yamii pa'aj qa iyinipji' pa'aj pekhewe'en hats'inha qu' netesti'yij iye pa' Espíritu Santo, ");
INSERT INTO mca_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","qe mexe nite' nametsju' pa'qu' ewii'ƚe' pekhewe'en pa' Espíritu Santo, ewi'ƚƚe in hats wempuli'jijju' ka' ƚiiji' pa' Yatsat'ax'inij Jesús. ");
INSERT INTO mca_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ma' qa t'eku'mipji'kii pekhewe'en, ma' qa testi'yij pa' Espíritu Santo. ");
INSERT INTO mca_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pa' Simón in yi'wenij pa' Espíritu Santo qu' jintesti'yij qu' nata'ƚets pe' ƚokoyei pe' apóstoles, ma' qa neqistineyutaxij pa'aj pe'qu' ƚ'astaye', ");
INSERT INTO mca_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","qa yittaxijets pa'aj: —Yakhap iye esƚisi'ƚij aka' witt'unha'x hats'inha pa'qu' he'yeku'mjiipji' ƚesinje' qa' netestiiji'jij pa' Espíritu Santo.— ");
INSERT INTO mca_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma' qa ha' Pedro qa yit'ijets pa'aj: —Les ƚe'wis pe' aq'astai qa akha' iye qu' ami'ƚii pa' fe't, qe ƚumtitax qu' ƚeke'ye' qu' aqha'yijets pe'qu' ƚ'astaye' pakha' ƚeqisitƚe pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Akha' a'ham ji'teje'm qa nite' iye qu' eneqfeetsiyu'uj aka' witqisit, qe pa' atawe'j nite' wattsathenketik'ui pa' ƚeqjeƚinet pa' Dios. ");
INSERT INTO mca_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Qa hik ta'ƚijupi' mewetlinenij aka' ewuƚ'ax, qa' iyinijetsha pa' Dios, q'axqe qu' niwamhit e'mik'i kakha' naqaqsijkineyu'taxijkii pa' atawe'j. ");
INSERT INTO mca_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Qe hi'wen in topo' ej pa' ek'imii qa pa' witwuƚ'ax qa ƚeƚinek'ej iye.— ");
INSERT INTO mca_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma' qa pa' Simón qa yeku'ƚ pa'aj, qa yit'ij: —Iyini'ƚ ye'mii pa' Yatsat'ax'inij, hats'inha qu' ham pa'qu' yijunye'je'kii kekhewe' ƚit'iƚij yiwets iku'uj.— ");
INSERT INTO mca_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Qa hekhewe'en, in hats naq'ajik'i pa'aj in nifeli'm pa' ƚunye'jkii in t'ejuyets pa' Jesús qa in nifeli'mha iye kekhewe' ƚe'lijei pa' Yatsat'ax'inij, ma' qa wapilii iye pa'aj ha' Jerusalén qa teneiƚi'ij pa'aj in nifeli'm eke' ƚe'sits wi'tlijei pe' olots witsetits ƚelits pa' sehe' Samaria. ");
INSERT INTO mca_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ewi'ƚ pa' ƚaqa ángel pa' Yatsat'ax'inij qa yiyaje'ets pa'aj pa' Felipe, qa yit'ijets: —Eniipha'm qa' ma, ejuyii na' i'wk'uyi'lii ma'ai hakha' wit'ikheyi'j ta'ƚii ha' Jerusalén qa yamiiju' ha' Gaza.— (Pakha' wit'ikheyi'j yijawe'j ji'teje'm pakha' ham i'ni'i'.) ");
INSERT INTO mca_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pa' Felipe qa niipha'm pa'aj qa ik, qa pa' wit'ikheyi'jii qa hikpa' qa yi'weni' pa'aj pa' ewi'ƚ eunuco Etiopía ƚeiƚe', qiji' ƚeqjeƚinenek pe' Candace qi ƚenene pekhewe' week Etiopía ƚeiƚets, pakha'an tenek'enhe'yipji' pa'aj pe' week ƚaq'astai pekhe' witnene, qa namii pa'aj na' Jerusalén qe qa' niyinii pa' Intata. ");
INSERT INTO mca_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pakha'an hats wapilii iye pa'aj pa' ƚetsetits, i'nji'ju' pekhe' ƚenhitjii koyoyoi, qa yiyinenik'i pekhewe' ƚe'lijei pa' profeta'ik'i Isaías. ");
INSERT INTO mca_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Qa Espíritu qa yit'ijets pa'aj pa' Felipe: —Iƚun qa' metmetinheti'm ne' ƚenhitjii.— ");
INSERT INTO mca_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ma' qa pa' Felipe qa wekuma'xipji' pa'aj qu' netmetinheti'm, qa yepi'ye' ej pa'aj in yiyinenik'i pe' ƚe'lijei pa' profeta'ik'i Isaías, qa yit'ijets pa'aj: —¿Me ƚenikfe'lik'i na' ƚiyinenik'i?— ");
INSERT INTO mca_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pakha'an qa yit'ijiju'ƚ pa'aj: —¿Inhats'ek qu' netsikfelik'i in ham pakha' qu' neqethen ye'mik'iha pakha' iikji'ha?— Pakha'an qa yiyaji'ets qu' na'ni'ƚji' pe' ƚenhitjii. ");
INSERT INTO mca_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pakha' i'ni' pa' yiyinenik'i pa'aj kekhewe' Intata ƚe'lijei yit'ij: —Hik ƚunye'j na'aj kots'etax in wetka'xii pa' ƚenqek'uwet, qa hik ƚunye'j iye na'aj kots'etax ƚa's qe we'ntusij nite' iyet ikesimenij, pakha'an ham yit'i'ij. ");
INSERT INTO mca_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Qi in tawitjaxtii qa nite' tewejinheti'yi'm qu' netniwohoyiikii pa'qu' ƚunye'ji'ija. ¿Pa'n ƚii pakha' qu' nenfelkii hatse' qu' nana'l pe'qu' ƚelitse' pakha'an,? qe hats qu' nilanipji' ha'ne sehe'.— ");
INSERT INTO mca_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pa' eunuco qa yit'ijets pa'aj pa' Felipe: —Enfel ye'm wat'ij, ¿pa'n ƚii pakha' yit'ijets aka'an pa' profeta'ik'i? ¿Me ƚakha'ƚe qu' net'ejuyets, me i'nƚi'i pakhape' iye?— ");
INSERT INTO mca_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma' qa pa' Felipe qa yapeƚek pa'aj qa iyet, qa ta'ƚijii pa' hats yiyinenik'i pa'aj kekhewe' we'nika'ajji', qa nifeli'm kekhewe' ƚe'sits wi'tlijei t'ejuyets pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Qa in mexe nekik'i pa'aj pa' wit'ikheyi'j, qa yamii pa'aj pakha' na'li' pa' iweli'. Qa pa' eunuco qa yit'ij pa'aj: —Jeƚ qeku'nek, hane'en iweli'. ¿Pa'n ƚii pakha' qu' mexe nenyejinik'ui qu' etsimpulijin?— ");
INSERT INTO mca_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pa' Felipe qa yit'ij: —Qu' hats weeki'ijha pa' atawe'j qu' nite' eqeku'ye', qa' ƚeke'ye'.— Qa yeku'ƚ pa'aj pakha'an qa yit'ij: —Ehe, nite' heqeku'uk'i pa' Jesucristo in hik pakha' pa' Ƚa's pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma' qa yiyaji'ets pa' ƚeqejkunenek qa yitkelenhetju' pe' ƚenhitjii. Qa t'ilitijupju'kii pa'aj pa' iweli' qa yimpuujin pa'aj pa' Felipe pa' eunuco. ");
INSERT INTO mca_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","In hats tepilik'uipha'mkii pa'aj pekhewe'en pa' iweli', qa pa' ƚeqe Espíritu pa' Yatsat'ax'inij qa aje'eƚ yeka'x iye pa'aj pa' Felipe. Qa pa' eunuco qa hats nite' yi'wen iye pa'aj. Ma' qa ik iye pa'aj, qi in ƚe'wisi'mkii. ");
INSERT INTO mca_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pa' Felipe qa te'wenheti'yi' pa'aj pa' witset Azoto. Qa week na'aj yamjeets pe' witsetits qa nifelji'ji' eke' ƚe'sits wi'tlijei, week pekhewe' witsetits, yamƚi'iiha pa' witset Cesarea. ");
INSERT INTO mca_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ha' Saulo, mexe nite' yili'ij pa'aj in yijiweikit wetju'ƚ qa neqek'uyu'ujju' iye pekhewe' tek'enets pa' Yatsat'ax'inij, qa ikii pa'aj pakha' qiji' ƚatata pe' pa'il, ");
INSERT INTO mca_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","qa iyinijets pe'qu' witfaakanheye' (cartas) qu' net'ejuyii pekhewe' judiol ƚe'lijtsitjiyits pa' Damasco, hats'inha pe'qu' ni'wenjiifi pekhewe'en pe' yatsat'etsij pakha' Wit'ikheyi'j (Jesús) pekhewe' jukhew qa efuts, qa' no'nophe'ƚju' qa' nenka'xii na' Jerusalén. ");
INSERT INTO mca_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Qa ƚunye'jkii pa'aj in hats ik, qa in hats k'esiyu'uiha pa'aj pa' Damasco, qa aje'eƚ namju' pa' koojo yamijup pa'aj ta'ƚiipha'm na' wa's. ");
INSERT INTO mca_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma' qa pa' Saulo in hats nami'ju' pa'aj sehe' qa yepi'ye' pa' wit'ax in yit'ijets: —Saulo, Saulo, ¿inhats'ek in ƚatsawitjitax?— ");
INSERT INTO mca_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Qa yit'ijets pa'aj: —¿Ƚek akha' Yatsat'axyij?— Qa yeku'ƚ pa'aj: —Yakha' Jesús, hik yakhaa'ija in ƚatsawitjitax. ");
INSERT INTO mca_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Eniipha'm qa amets na' witset, qa' hik nakha'yi'i' qu' efelhiti'yi'm kakha' qu' aqsiijkii.— ");
INSERT INTO mca_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pe' jukhew ƚijts'eyek pa'aj ha' Saulo qa teke'lenju'kii pa'aj ham yit'i'ijju', yepi'ye'tax pa' wit'ax qa hamƚe pa'qu' ni'wen. ");
INSERT INTO mca_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ma' qa niitaxpha'm pa'aj ha' Saulo, qa in yemjeetax in nite' ima'taxpha'm qa hatsƚe nite' yi'wenkii. Ma' qa teneku'mhiiƚi'i' pa'aj pa' ƚokoi qa wetka'xii pa' witset Damasco. ");
INSERT INTO mca_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Qa wetshetk'ewi'ƚ neƚuts in nite' yi'wenkii, qa nite' tek iye qa nite' iya'ji' iye pa'qu' iweli'ye'. ");
INSERT INTO mca_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ha' Damasco i'ni' pa'aj pa' ewi'ƚ yijayan pa' Jesús ƚii Ananías. Qa i'nji'kii pa'aj ƚotoi pa' Yatsat'ax'inij qa yit'ijets: —Ananías.— Qa yeku'ƚ pa'aj: —Ha'ne qe ha'ni'in Yatsat'axyij.— ");
INSERT INTO mca_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pa' Yatsat'ax'inij qa yit'ijets pa'aj: —Eniipha'm, qa' ma'ai qu' ma'ak'i na' wit'ikheyi'j ƚii Yatsathen, qa ke' ƚetsi'ii ha' Judas, qa' inaqfaakanij ha' ewi'ƚ jukhew Tarso ƚeiƚe' ƚii Saulo, qe hane'ej hakha'an mexe iyin, ");
INSERT INTO mca_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","qa hats i'nji'kii ƚotoi na' ewi'ƚ jukhew ƚii Ananías in uyetsji' qa t'eku'mipji' qe qa' ni'wenkii iye.— ");
INSERT INTO mca_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Qa pakha'ƚe Ananías qa yeku'ƚ pa'aj: —Yatsat'axyij, olots he' hepi'ye'ej qa nifelji'ijkii pakha' ƚunye'j ha'ne jukhew, qi pa' uƚ'ax yaqsiimijkii pekhewe' ƚantsat'etsij na' Jerusalenii, ");
INSERT INTO mca_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","hane'ej hats na'li'm pa' ƚet'unha'x qe pe' ƚafaakanhei ta'ƚijets pe' tenek'enhe'yij pe' pa'il hats'inha qu' week no'nophe'ƚju' pekhewe' hats najayantax.— ");
INSERT INTO mca_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Qa pakha'ƚe Yatsat'ax'inij qa yit'ij: —Ma'ai, qe hakha'an he'yeku'mijiiji' qe qa' nenfeli'm aka' yii nekhewe' nite' judiol, nekhewe' wittatal qa nekhewe' iye ƚelits ka' Israel'ik'i. ");
INSERT INTO mca_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Qe yakha' qu' hethinij hakha'an qu' qi qu' naats'e'ej pe'qu' wekweke' qu' nata'ƚ yiwets.— ");
INSERT INTO mca_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ma' qa pa' Ananías qa ikii pa'aj, qa uyifi pe' wititsi', ma' qa in hats t'eku'mipji' pa'aj qa yit'ijets: —Yejefe Saulo, hakha' Yatsat'ax'inij Jesús, hakha' we'nethin ewets pa'aj pakha' ƚenekik'i wit'ikheyi'jik'i, ts'ukin ei qe qa' i'wenkii iye qa qu' notpo' ej iye pa' Espíritu Santo.— ");
INSERT INTO mca_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Qa hik pakha'aj qa namju'kii pekhewe' i'ntaxji' pe' ƚotoi hik ƚunyejeitax sehets ƚ'ajits, ma' qa hats yi'wenkii iye. Ma' qa niipha'm qa wempuli'jij pa'aj aka' ƚii pa' Jesucristo. ");
INSERT INTO mca_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Qa hats tek pa'aj qa' t'un iye. Ma' qa uja'x pe' neƚuts in mexe amaneyijup pekhewe' tek'enets pa' Jesús tetseti'yi' pa' Damasco. ");
INSERT INTO mca_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Qa aje'eƚ pa'aj yisu'un qu' nenfel pa' Jesús pekhewe' judiol ƚe'lijtsitjiyitsifi, qa yit'ij: —Hakha'an hik hakha' pa' Ƚa's pa' Dios.— ");
INSERT INTO mca_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Qa week pe' yepi'ye' pa'aj qa yitjuƚaxijpha'mkii, qa yit'ijju' pa'aj: —¿Me nite' hik ha'ne pakha' Jerusalenii nawitjiju'kii pekhewe' yijayantax aka' witii? ¿Me nite' hik ha'ne iye pakha' namijii hane'e'in qu' no'nophe'ƚju' iye qa' neka'xii iye pekhewe' tenek'enhe'yij pe' pa'il?— ");
INSERT INTO mca_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Qa pakha'ƚe Saulo qa yape'enha les in t'ijayijfik'i pa'aj in t'unij qa pe' judiol Damasco ƚeiƚets qa hats ham pa'qu' nit'ijiju'ƚ, yethinijha pa' Jesús in hik pakha' pa' Cristo. ");
INSERT INTO mca_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","In hats olots pa'aj neƚuts pe' judiol qa tafaakateitaxijju' pa'aj qu' nilan pa' Saulo. ");
INSERT INTO mca_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Qa nikfe'lƚe'ets pa'aj pa' Saulo pakha' neqfenyejeyutaxij pa'aj pekhewe'en. Neƚuts qa najai iye in yejeƚtaxik'uikii pe' ƚejilji' pa' witset qe neqek'eyutaxij pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Qa pekhewe'ƚe ƚ'ijatshenhei qa t'eku'mi' pa'aj pa' naja'xji' qa yilithinii pa' ewi'ƚ kumu'ui pa' qipha'm ƚejilafi' pa' witset, qa yilithinijiiju' pa'aj pe' ewi'ƚ kanastu. ");
INSERT INTO mca_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Qa in hats yamii pa'aj ha' Jerusalén, qa yisu'untax qu' nakets qa' ewi'ƚ na'ni'ƚi' pekhewe' tek'enets pa' Jesús. Qa weekƚe nijiwe'yi'm pa'aj qe yumti qu' naqanƚekii in hats tek'enets pa' Jesús. ");
INSERT INTO mca_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Qa ha' Bernabé qa yeka'x pa'aj qa yethinii he' apóstoles, qa nifelimik'i pa'aj pa' ƚunye'jkii pa' Saulo in yi'wenji' pa' wit'ikheyi'jji' pa' Yatsat'ax'inij, qa tafaakate'yi'ƚ pa'aj, qa nifeli'm iye in we'nt'unhet in iyetij ka' ƚii pa' Jesús pa' Damasco'oi. ");
INSERT INTO mca_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma' qa pa' Saulo qa amanji' pa'aj ha' Jerusalén qa ewi'ƚ i'ni'ƚi' pekhewe'en, qa we'nt'unhet pa'aj in iyetij aka' ƚii pa' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma' qa tafaakate'yi'ƚju' iye qa tek'eƚeyi'ƚju' iye pa'aj pekhewe' judiol Grecia ƚeiƚets. Ma' qa hik pekhewe' qa neqek'uyu'taxij iye pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma' qa pekhewe' yijayan pa' Jesús in nikfe'lets pa'aj aka'an, qa yeka'xii pa'aj pa' Cesarea, ma' qa hikpa' ta'ƚi' in yukinii pa' ƚetset'ija Tarso. ");
INSERT INTO mca_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma' qa hik pakha'aj iye, pekhewe' yijayan pa' Jesús qa hats qi in ƚe'sitsƚi'imkii iye pa'aj week pekhewe' i'ni' pa' sehe' Judea pa' Galilea qa pa' Samaria, qa les in ni'yijpha'm pa'aj. Qa qi iye na'li'm pa' ƚ'ijiweyaxitsiju'ƚ pa' Yatsat'ax'inij qa na'li'm iye pa' ƚet'unha'x pa' Espíritu Santo, qa yape'enha les in t'ijaifik'i pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Qa pa' Pedro in mexe yamik'i pa'aj pekhewe' witsetits pakha' sehe', qa yamii iye pa'aj pekhewe' hats yijayan pa' Jesús tetsetiyi' ek pa' Lida. ");
INSERT INTO mca_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Qa hik pakha'a' qa yi'weni' pa'aj pa' ewi'ƚ jukhew ƚii Eneas, wetshetk'ewi'ƚ tatsai (8) ƚeqe'ninqapitsij pa'aj in nite' niyik'uipha'm pa' ƚewhi'la'x, qe nite' p'esits pe' ƚewekwekits. ");
INSERT INTO mca_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ha' Pedro qa yit'ijets pa'aj: —Eneas, ha' Jesucristo qu' neƚin hane'ej. Eniipha'm qa' aqsi'jju' na' ewhi'la'x.— Qa hik pakhaa'ijha qa niipha'm pa'aj. ");
INSERT INTO mca_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Week pekhewe' Lida ƚeiƚets qa pe' Sarón ƚeiƚets iye qa yi'wen pa'aj pakha'an, ma' qa hats yijayan iye pa'aj pekhewe'en pa' Yatsat'ax'inij. ");
INSERT INTO mca_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na'l pa'aj pe' ewi'ƚ efu yijayan pa' Jesús i'ni' pa' witset Jope, ƚii Tabita, griego qa ikji' ek Dorcas. Pekhe'en week neƚuts ƚe'wis pa' yaqsiijkii qa t'ifti'ts'etskii iye pe' ham yiwq'axine'. ");
INSERT INTO mca_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Qa ƚunye'jkii pa'aj pekhewe' neƚutsji' qa wanqaats'e' pa'aj qa wa'm. Qa in hats yaqhat'etsij pa'aj in yimpuujin pa' ƚ'ajik'i, qa yeniipha'm pa'aj pakha' te'weipha'm ƚatawe'j pe' wititsi'. ");
INSERT INTO mca_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Qa pa' witset Lida in metitsi'ƚ wetju'ƚ pa' witset Jope, pekhewe' yijayan pa' Jesús i'ye'ej pa'aj ha' Pedro in i'ni' pa'aj pa' Lida, ma' qa yukinii pa'aj pe' wetsjuk jukhew, qu' nit'ijets: —If'elitik'i qu' enek ha'ne witset'ii Jope.— ");
INSERT INTO mca_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ma' qa ha' Pedro qa niipha'm pa'aj qa yijayan pekhewe'en. Qa in hats yamijii pa'aj qa aje'eƚ yeka'xiipha'm pa'aj pakha' toxpha'm pe' wititsi',