﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbu_vpl;
CREATE TABLE mbu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbu_vpl WRITE;
INSERT INTO mbu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A tite ka Ɓakuli pusǝ kùli andǝ nzali. ");
INSERT INTO mbu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nzali ka pur kǝgìr ɗàng, nda kam anggo ɗulkǝm. Pǝndǝa gir mur mùr mǝlime. Sǝ Bangŋo mala Ɓakuli ka camarǝ gāɗi amur mùr. ");
INSERT INTO mbu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Sǝ Ɓakuli na ama, <<Ɓǝ̀ tǎlaban pusǝ rǝi.>> Pǝlǝa tǎlaban puro. ");
INSERT INTO mbu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ɓakuli sǝni ka tǎlaban ɓoaro, pǝlǝa tsǝk nzong anre tǎlaban andǝ pǝndǝa. ");
INSERT INTO mbu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ɓakuli tunǝ tǎlaban ama, <<pwari>> sǝ pǝndǝa ka tunǝi ama, <<dù.>> Pwari kya kpa, sǝ ban yi kwaro; mǝno nda nongŋo mǝdǝmbe. ");
INSERT INTO mbu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Sǝ Ɓakuli bang ama, <<Ɓǝ̀ nreban gau mùr mana a kùli andǝ mana a nzali ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Anggo sǝ pa. Ɓakuli tsǝk mǝnia yì nreban ngga yi nongŋo anre mùr mana a nzali andǝ mana a kùli ka. ");
INSERT INTO mbu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ɓakuli tunǝ mǝnia yì nreban ngga ama, <<bumkuli.>> Pwari kya kpa, sǝ ban yi kwaro; mǝno nda ɓaria nongŋo. ");
INSERT INTO mbu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ɓakuli na ama, <<Ɓǝ̀ mùr mǝnana aɓata bumkuli ka, dapi a banɓwáná, sǝ ɓǝ̀ nza sa.>> Anggo sǝ pa. ");
INSERT INTO mbu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ɓakuli tunǝ nza ama, <<kwàrban>> sǝ ramba mala mùr ka tunǝi ama, <<nggeamùr.>> Ɓakuli sǝni ka ɓoaro. ");
INSERT INTO mbu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ɓakuli na ama, <<Ɓǝ̀ nzali pusǝ agirpwala: abondo andǝ mbúgir mǝnana à nǝ̀ pusǝ mǝsǝia ka, andǝ anggun mǝnana à nǝ̀ pusǝ ɓǝlea nǝ amǝsǝia aɓalǝia ka. Komǝyenani le ka ɓǝ̀ pusǝ ulang male yì ɓeali.>> Anggo sǝ pa. ");
INSERT INTO mbu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nzali pusǝ agirpwala: abondo andǝ ambúgir mǝnana à kǝ pusǝ mǝsǝia ulangyia, andǝ anggun mǝnana à kǝ pusǝ ɓǝlea nǝ amǝsǝia aɓalǝia ka ulangyia. Ɓakuli sǝni ka ɓoaro. ");
INSERT INTO mbu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pwari kya kpa, sǝ ban yi kwaro; mǝno nda tàruià nongŋo. ");
INSERT INTO mbu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Pǝlǝa Ɓakuli na ama, <<Ɓǝ̀ atǎlaban pusǝ rǝia a bumkuli, ɓǝà gau nre pwari andǝ du. Ɓǝà duk agir-lǝmdǝa ace lǝmdǝ anongŋo, andǝ apǝlǝa, andǝ akúnì. ");
INSERT INTO mbu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Sǝ amǝnia yì atǎlaban ngga ɓǝà tá a bumkuli amur ɓanza.>> Anggo sǝ pa. ");
INSERT INTO mbu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nda Ɓakuli pàk atǎlaban mǝgulke ɓari. Mǝgule mala ɓì, yì pwari ka, ɓǝ̀ kǝ tá nǝ pwari, sǝ mǝkyauwe, yì zongŋo ka, ɓǝ̀ kǝ tá nǝ du. Ɓakuli nyar ɗǝm ngga pusǝ anlero. ");
INSERT INTO mbu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ɓakuli tsǝk amǝnia yì atǎlaban ngga a bumkuli ɓǝà kǝ tá amúr ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ɓǝà kǝ yálmúr pwari andǝ du, sǝ ɓǝà gau nre tǎlaban andǝ pǝndǝa. Sǝ Ɓakuli sǝni ka ɓoaro. ");
INSERT INTO mbu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pwari kya kpa, sǝ ban yi kwaro. Mǝno nda inea nongŋo. ");
INSERT INTO mbu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ɓakuli na ama, <<Ɓǝ̀ mùr lùmsǝ nǝ anji andǝ acili agir mǝyilǝmui mǝnana a mùr ka. Ɓǝ̀ bumkuli lùmsǝ nǝ koya ulang nyal.>> ");
INSERT INTO mbu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nda Ɓakuli pusǝki agirkusǝu mǝgulke mǝnana a nggeamùr, andǝ koya gìr mǝnana nǝyilǝmu kǝ ging mbǝl-mbǝl a mùr ka, andǝ koya ulang nyal. Ɓakuli sǝni ka ɓoaro. ");
INSERT INTO mbu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Sǝ Ɓakuli tsǝkia wia bù, na ama, <<Wu ɓǝla, wu hatǝki, wu aki nggeamùr, sǝ ɓǝ̀ anyal hatǝki ɓanza.>> ");
INSERT INTO mbu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pwari kya kpa, sǝ ban yi kwaro; mǝno ka nda tongnoia nongŋo. ");
INSERT INTO mbu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ɓakuli nyare na ama, <<Ɓǝ̀ nzali pusǝ koya ulang gìr mǝnana nǝyilǝmu ka: agirkusǝu andǝ agir-nzali mǝnana à kǝ púrǝ́ki nǝ múrbumia a nzali ka, andǝ koya ulang nyam-bondo andǝ nyam-ɓala.>> Anggo sǝ pa. ");
INSERT INTO mbu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ɓakuli pusǝ koya ulang girkusǝu, anyam-ɓala andǝ anyam-bondo, andǝ koya gìr mǝnana kǝ kuɗǝki a nzali ka. Ɓakuli sǝni ka ɓoaro. ");
INSERT INTO mbu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Pǝlǝa Ɓakuli na ama, <<Ɓǝ̀ sǝm pàk ɓwapǝndǝa ɓǝ̀ pa kǝla sǝm, ɓǝ̀ pur sǝm, ace mǝnana ɓǝ̀ yálmúr anji mǝnana aɓa nggeamùr, andǝ anyal mǝnana a bumkuli ka, agir-nzali andǝ agirkusǝu mǝnana kat à kǝ gāli a nzǝm-nzali, andǝ ɓanza kat, andǝ agiryilǝmu mǝnana kat à kǝ pūrǝki nǝ múrbumia a nzali ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nda Ɓakuli pusǝ ɓwapǝndǝa kǝla yì. Aɓa purban male yì Ɓakuli sǝ pusǝì. Pàk ɓwapǝndǝa ɓwabura andǝ ɓwama. ");
INSERT INTO mbu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ɓakuli tsǝkia wia bù sǝ nea wia ama, <<Wu ɓǝla, wu hatǝki; wu lùmsǝ ɓanza. Wu akí ɓanza sǝ wu ɓunni. Wu yálmúr anji mǝnana a mùr andǝ anyal mǝnana a bumkuli, andǝ koya gìr mǝnana ndanǝ yilǝmu kǝ gya a nzǝm-nzali ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Pǝlǝa Ɓakuli nea wia ama, <<Ən pana wun koya mbúgir andǝ bondo mǝnana kǝ pusǝ ɓeali a nzǝm-nzali kat ka, andǝ koya nggun mǝnana kǝ pusǝ ɓǝle nǝ mǝsǝì aɓalǝi ka. À nda ace girlina ma'wun. ");
INSERT INTO mbu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ən pana koya ulang mbúgir andǝ koya girpwala, nda girlina mala anyam-bondo mǝnana a ɓanza, andǝ anyal mǝnana a bumkuli, andǝ anyama mǝnana à kǝ pūrǝ nǝ múrbumia a nzali ka, andǝ koya gìr mǝnana ndanǝ yilǝmu ka.>> Anggo sǝ pa. ");
INSERT INTO mbu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ɓakuli sǝn gìr mǝnana pè kat ka, ɓoar kǝ̀rkǝ́r. Pwari kya kpa, sǝ ban yi kwaro; mǝno nda tongno-nong-mwashatia nongŋo. ");
INSERT INTO mbu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Anggo sǝ pusǝ kùli andǝ nzali andǝ agir mǝnana aɓalǝia kat ka yiu a masǝlǝate. ");
INSERT INTO mbu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","A tongno-nong-ɓaria nongŋo ka, Ɓakuli malǝna túró male mǝnana pàk ka, sǝ usǝlǝo. ");
INSERT INTO mbu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ɓakuli tsǝkbu amúr tongno-nong-ɓaria pwari, sǝ nyesǝi duk pwari mǝfele, acemǝnana nda pwari mǝnana usǝlǝ nǝi arǝ atúró male mǝnana kat pa, mala pusǝki agir ka. ");
INSERT INTO mbu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Anggo sǝ à pusǝ kùli andǝ nzali. Lang Mǝtalabangŋo Ɓakuli pusǝna kùli andǝ nzali ka, ");
INSERT INTO mbu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ɓekǝ girpwala pa kàm a ɓanza ɗàng, sǝ ɓekǝ mǝsǝɓeale to gbal a nzali ɗang. Gìrnî pa anggo acemǝnana Mǝtalabangŋo Ɓakuli malaká nya mbulo ɓǝ̀ liu nzali ɗang, sǝ kǝ ɓwapǝndǝa pa kàm nǝ̀ rik nzali ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amaɗi na mǝnana à kǝ tu mùr a nzali ace liu ban ngga. ");
INSERT INTO mbu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Pǝlǝa Mǝtalabangŋo Ɓakuli ɓak ɓwa nǝ muku nzali, sǝ pyaupi wi n-yali mala yilǝmu aɓa lùllǝì, sǝ yì ɓwa ka pak nǝyilǝmu. ");
INSERT INTO mbu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mǝtalabangŋo Ɓakuli pǝlǝa tsǝk ɓaban a Iden nǝ njar-takuli sǝ pandǝki anggun kàm; a kàm sǝ tsǝk ɓwa mǝnana pè ka. ");
INSERT INTO mbu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mǝtalabangŋo Ɓakuli tsǝk anggun ɗàngɗáng ɓǝà to a ɓabanì: anggun mǝɓoarsǝne andǝ amǝɓoarli. A tsùrú mala ɓabanì ka anggun nakam ɓari, nggun-yilǝmu andǝ nggun mala pà sǝlǝe mala gìr mǝɓoarne andǝ mǝɓane. ");
INSERT INTO mbu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ɓè nggeasala pur a Iden kǝ pa mùr a ɓabanì; lo kano ka kya gauwa arǝ amyalmúr ine. ");
INSERT INTO mbu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mǝdǝmbe ka à tunǝi ama Pishon; ɓangŋa pǝlǝki arǝ abân aɓa nzali Havila, nzali mana à kǝ kum bolo-njengǝlan kam ngga. ");
INSERT INTO mbu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Bolo-njengǝlan mala nzali mǝno ka mǝɓoarne na; akàm ɗǝm ngga à kǝ kum myang mǝ'rǝmɓoarne andǝ atali gǝna.) ");
INSERT INTO mbu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ɓaria myalmúr ka nda Gihon; ɓangŋa pǝlǝki arǝ abân aɓa nzali Kush. ");
INSERT INTO mbu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tàruià myalmúr ka nda Tigris; ɓangŋa pǝlǝ nǝ bantakuli mala nzali Assuriya. Inea myalmúr ka nda Yiufǝretis. ");
INSERT INTO mbu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mǝtalabangŋo Ɓakuli tsǝk ɓwabura man a ɓaban mala anggun a Iden, ɓǝ̀ kǝ paktúró aɓalǝi, sǝ ɓǝ̀ kǝ yállí. ");
INSERT INTO mbu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mǝtalabangŋo Ɓakuli nunkiri yì ɓwabura ama, <<A earǝ́nò ama wu li ɓǝla koya nggun a mǝnia yì ɓaban mala anggun ngga. ");
INSERT INTO mbu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Sǝama kǝa na ama awu nǝ li ɓǝlanggun mala pà sǝlǝe mala gìr mǝɓoarne andǝ mǝɓane ɗàng. A pwari mana a li ka, ɓafo, awu nǝ wǔ.>> ");
INSERT INTO mbu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Pǝlǝa Mǝtalabangŋo Ɓakuli na ama, <<Ɓoaro ɓǝ̀ ɓwabura mǝnia ka ɓǝ̀ do nǝmurǝì ɗàng. Mǝ nǝ pakki wi mǝ'bwali wi, mǝnana karǝ arǝì ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mǝtalabangŋo Ɓakuli ka, pàngŋǝ̀nà túró nǝ muku-nzali ɓangŋǝna anyama mǝnana à kǝ gya a kwàrban, andǝ anyal mǝnana à kǝ yal a bumkuli ka. Yinǝia a ban mǝnia yì ɓwa ka, nǝ̀ sǝni lang sǝ nǝ̀ tunǝia. Ɓǝ̀ mana sǝ mǝnia yì ɓwabura tunǝna koya gìr mǝnana ndanǝ yilǝmu nǝi ka, dumǝna lùllǝì. ");
INSERT INTO mbu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ɓwabura man tsǝki agirkusǝu kat lullǝu: anyal mǝnana kat à kǝ yal a bumkuli, andǝ anyam-ɓala kat, andǝ anyam-bondo kat. Sǝ male yì ɓwabura ka, à kumbi wi kǝ gbasha mǝnana karǝ arǝì ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Pǝlǝa Mǝtalabangŋo Ɓakuli tsǝk ɓwabura ɓǝ̀ koa nggea ntulo mǝlime. Ndarǝ nong ntulo ka, Mǝtalabangŋo Ɓakuli pusǝ mu nkanggari ɓwabure mwashat sǝ lúmsǝ banì nǝ nyama. ");
INSERT INTO mbu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Pǝlǝa Mǝtalabangŋo Ɓakuli pak ɓwama nǝ mǝnia yì mu pusǝì a nkanggari ɓwabura ka, sǝ yinǝi aban ɓwaburè. ");
INSERT INTO mbu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ɓwabura man na ama, <<Mǝnia adyan ngga mǔ na à pusǝì aɓalǝ amuem; sǝ nyama na mala nyamam! À nǝ̀ tunǝi ama, <ɓwama> acemǝnana à pusǝì arǝ ɓwabura.>> ");
INSERT INTO mbu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nda gìr mana tsǝa sǝ ɓwabura nǝ̀ ɗeki tárrí andǝ ngge, sǝ nǝ̀ lanzǝa arǝ māmí, sǝ yia kǝm ngga à dumǝna nyama mwashat. ");
INSERT INTO mbu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Anggo ka, yì ɓwabura andǝ māmí ka, à ndanǝ ɓatea, sǝ kǝsǝkea pakkia wia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Atà anyam-bondo mǝnana Mǝtalabangŋo Ɓakuli pusǝia ka, n'yau na mǝnana kútiǎ kat nǝ kutan ngga. Ɓè kǝ pwari ka, n'yau ɗì ɓwama ama, <<Mbak-kàngkàng Ɓakuli bang ama, <Wu kǝa li kǝ ɓǝlanggun mǝnana a ɓaban mala anggun ngga ɗàng le?> >> ");
INSERT INTO mbu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɓwama eari n'yau ama, <<Sǝm nǝ̀ gandǝ li aɓǝlanggun mǝnana a ɓaban mala anggun ngga. ");
INSERT INTO mbu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Sǝama Ɓakuli bangga sǝm ama, kǝ ɓǝlanggun mǝnana came a ɓaɓalǝu mala ɓaban mala anggun ngga, nda pà sǝm nǝ̀ je, ko sǝm nǝ̀ li raka; ɓǝ̀ sǝm je, ko ɓǝ̀ sǝm li ka, sǝm nǝ̀ wú.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","N'yau eari ɓwama ama, <<Mǝsǝcau ka pà wun nǝ̀ wu ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Acemǝnana Ɓakuli sǝlǝna ama, ɓǝ̀ wu li ɓǝlanggun man ngga, amǝsǝ wun nǝ̀ mǝnna, sǝ wun nǝ̀ do kǝla Ɓakuli, wun nǝ̀ súrǝ̀ mǝɓoarne andǝ mǝɓane.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lang ɓwama sǝna ɓǝla-nggunì ndanǝ ɓoaro ace girlina, sǝ ɓoarsǝna, ɗǝm ngga sǝn ɓoaro mala sǝlǝe mǝnana nǝ̀ kùmô arǝì, a ɓabumi ka, kara tù atà aɓǝla-nggunì lì. Sǝ pè burí, pǝlǝa yì ka lì gbal. ");
INSERT INTO mbu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Anggo kara mǝsǝia yia kǝm mǝnna, kǝsǝkea bwalia acemǝnana à yi sǝlǝa ama à nda nǝ ɓatea. Pǝlǝa à ɓungi ambú nggun vwari à gbàrǝna ɓatea nǝi. ");
INSERT INTO mbu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nǝ́ pwarikpǝra mǝno ka, ɓwaburè andǝ māmí ok gǝshi kusǝ Mǝtalabangŋo Ɓakuli aban gya a ɓaban mala anggun. Kara à ɓangŋa à sǝmbǝrǝì Mǝtalabangŋo Ɓakuli aɓalǝ anggun mǝnana a ɓaban ngga. ");
INSERT INTO mbu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pǝlǝa Mǝtalabangŋo Ɓakuli tunǝban ɗì ɓwaburè ama, <<A nda ke lè?>> ");
INSERT INTO mbu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yi ka eare ama, <<Ən ok gǝshi kusǝo aban gya a ɓaban mala anggun, ɓangciu pàkkam, nda sǝ ǝn sǝmbǝrǝ ka, acemǝnana mǝ nda nǝ ɓatam.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mǝtalabangŋo Ɓakuli ɗì ama, <<Yana nô ama a nda nǝ ɓato? Ko a lina ɓǝlanggun mǝnana ǝn nô nǝma wu kǝa li raka lè?>> ");
INSERT INTO mbu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pǝlǝa ɓwaburè ne Mǝtalabangŋo Ɓakuli ama, <<Ɓwama mǝnana a pam ɓǝ̀ sǝm duk sǝni ka, nda pam ɓǝlanggun sǝ ǝn li ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mǝtalabangŋo Ɓakuli pǝlǝa ɗì ɓwama ama, <<Mana mǝnia a pak ka?>> Ɓwama eare ama, <<N'yau swarkiam, nda gìr mana tsǝa sǝ ǝn li ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pǝlǝa Mǝtalabangŋo Ɓakuli ne n'yau ama, <<Acemǝnana a pángŋǝ̀nà mǝnia ka, <<Súban na amuro mǝnana kútì mala koya girkusǝu ka: anyam-ɓala andǝ anyam-bondo. Awu nǝ pūrǝki nǝ múrbumo, awu nǝ li nzali a do-yilǝmu mô kat. ");
INSERT INTO mbu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mǝ nǝ tsǝk do-ɓibura a nre wun, wunǝ ɓwama man, amunio andǝ amǝ'keò nǝ̀ duk ɓibura mala amuni andǝ amǝkè. We ka, awu nǝ kwar mǝkè a nkpalkusǝi, sǝ yì ka, nǝ̀ ar ɓamuro.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ɓwama ka Ɓakuli ne wi ama, <<Mǝ nǝ hatǝki kwanban mô aɓa ɓǝlmuna; aɓa kwanban sǝ awu nǝ gbáshí muna. Kat andǝ amani ka, nzal burio nǝ̀ aki ɓalǝo, sǝ yì ka nǝ̀ duk murǝm amuro.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Mala ɓwabura ka, Ɓakuli ne wi ama, <<Acemǝnana a kwakikiro arǝ māmó, sǝ a lina ɓǝlanggun mǝnana ǝn nunkiro nǝma wu kǝa lì raka, <<Nzali twalǝna súban amurí akǝ cau mò. Do mô bà, a nǝ tanni aɓa túró mǝcandǝe sǝ a nǝ kum girlina. ");
INSERT INTO mbu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nzali nǝ̀ pusǝô azwe andǝ amǝzwezwe, sǝ kat andǝ amani ka, awu nǝ li ɓǝla abondo mǝnana nzali nǝ̀ pusǝ ka. ");
INSERT INTO mbu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nǝ piban a nggun-muro sǝ awu nǝ kum girlina, mana a nǝ lì ka, bà pwari mǝnana awu nǝ wǔ a nǝ nyare a nzali ka; acemǝnana nǝ tú-nzali sǝ à peo. We ka a nda nzali, sǝ a nzali sǝ a nǝ nyare a nǝ o.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ɓwabura, yì Adamu ka, tsǝkî māmí lullǝu ama Hawawu, acemǝnana yì na nǝ̀ duk nggea ka ɓwapǝndǝa kat mana à ndanǝ yilǝmu ka. ");
INSERT INTO mbu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mǝtalabangŋo Ɓakuli pakki Adamu andǝ māmí agirkùrarǝu nǝ nggû, ɓǝà gbàrǝna rǝia nǝi. ");
INSERT INTO mbu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Sǝ Mǝtalabangŋo Ɓakuli na ama, <<Ɓwapǝndǝa adyan ngga dumǝna kǝla sǝm, súrǝ́nà rǝ mǝɓoarne andǝ mǝɓane. Ɓǝ̀ sǝm eari wi lǝmdǝ buì sǝ tù ɓǝlanggun mala nggun-yilǝmu gbal, sǝ lì ka, nǝ̀ duk bà, pà nǝ̀ wù ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Acemani ka Mǝtalabangŋo Ɓakuli pǝrì pusǝì a Iden, yì ɓaban mala anggun, ama ɓǝ̀ kyane ɓǝ̀ kya rik nzali mǝnana à pusǝì kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Anzǝm mǝnana pǝrna ɓwabure pusǝni ka, Mǝtalabangŋo Ɓakuli pǝlǝa tamsǝ acerup, akanggǝrang amǝ'yál ban mala Ɓakuli, nǝ njar-takuli a ɓaban mala anggun a Iden, sǝ tsǝk nggeabyau mǝnana kǝ earki nǝ lasǝ-bǝsa sǝ kǝ pǝlǝki a koya buì ka, ɓǝà kǝ yál njargula ká aban nggun-yilǝmu. ");
INSERT INTO mbu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu nongnǝ māmí Hawawu, pǝlǝa muna kpa a bum māmí, sǝ ɓǝl Kayinu. Pǝlǝa Hawawu bang ama, <<Nǝ ɓwamuru mala Mǝtalabangŋo ka, ǝn ɓǝlǝna muna-ɓwabura.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nǝnzǝ́mò ka yi ɓǝl mǝ'eambi, tsǝki wi lullǝu ama Habila. Habila twal túró yál agirkusǝu, sǝ Kayinu twal túró rya. ");
INSERT INTO mbu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Lang kún pwan gir-ɓaban karna ka, Kayinu yinǝì Mǝtalabangŋo ɓoro mala aɓǝla agir-ɓaban. ");
INSERT INTO mbu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Sǝ Habila ka yinǝ ɓoro male mala agirkusǝu, atà amǝ'nyange mǝnana à ɓǝlia a dǝmba a domwan male ka. Mǝtalabangŋo earnǝ Habila andǝ ɓoro male. ");
INSERT INTO mbu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Sǝ mala Kayinu andǝ ɓoro male ka, Mǝtalabangŋo earnǝia ɗàng. Mǝnia ka tsǝk Kayinu bumi lul kǝ̀rkǝ́r, kara rǝmsǝ dǝmbì. ");
INSERT INTO mbu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Pǝlǝa Mǝtalabangŋo ɗì Kayinu ama, <<Palang sǝ bumo lúllô? Palang sǝ a rǝmsǝ dǝmbò? ");
INSERT INTO mbu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ɓǝ̀ a pak gìr mǝnana mǝɓoarne na ka, à pà nǝ̀ eo re? Sǝ ɓǝ̀ a pàk mǝɓane ka, cauɓikea na kùmsǝó a kunɓala kǝ alte nǝ̀ parǒ aɓate ka, sǝama dumǝna púp wu limurǝm amurí.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ɓè kǝ pwari ka Kayinu ne mǝ'eambi Habila ama, <<Tsǝktam a ɓabondo.>> Lang à nda ɓabondo ka, Kayinu kara lo bwal mǝ'eambi Habila wali wú. ");
INSERT INTO mbu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mǝtalabangŋo ɗì Kayinu ama, <<Mǝ'eambo, Habila ka, nda kǝshe?>> Kara pǝlǝì Mǝtalabangŋo ama, <<Ən súrǝ̀ banì ɗàng. Nggeari ka, mǝ nda mǝ'yál mǝ'eambam le?>> ");
INSERT INTO mbu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mǝtalabangŋo ne wi ama, <<Mana man a pak ka? Kwakikiro! Nkila mǝ'kyauweo ka ndya kǝ ɓua abanam a nzali ka! ");
INSERT INTO mbu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Adyan ngga, súban na amuro, sǝ à pǝrǝno a nzali mǝnana mǝn kúni kǝ nu nkila mǝ'eambo mǝnana a sukki ka. ");
INSERT INTO mbu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","<<Ɓǝ̀ a rik mǝnia yì nzali ka, pà nǝ̀ pusǝo kǝ girlina mǝɓoarne ɗàng. A dumǝna mǝgya-kusǝu, mǝnana pà nǝ̀ do aban mǝ mwashati a ɓanza raka.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pǝlǝa Kayinu ne Mǝtalabangŋo ama, <<Tanni mala cauɓikea mem man kútì rǝcandǝa mem. ");
INSERT INTO mbu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Yalung ngga a ndarǝ pǝram mǝ purî nzali mǝnia ka mǝ nying ɓadǝmbo; mǝ nǝ duk mǝgya-kusǝu a ɓanza, ban-usǝlǝo pa kàm a buam ɗàng, sǝ ɓwa mǝnana kat kumam ngga nǝ̀ wal-luem.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Sǝ Mǝtalabangŋo banggi wi ama, <<Pà nǝ̀ pa anggo ɗàng; ɓǝ̀ kǝ ɓwa wal-luio ka, mǝ nǝ wal atà aɓwana male tongno-nong-ɓari.>> Pǝlǝa Mǝtalabangŋo tsǝki Kayinu nyoulǝa ace mǝnana ɓǝ̀ kǝ ɓwa kumi ka, ɓǝ̀ kǝa wal-luí raka. ");
INSERT INTO mbu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Nda Kayinu nying ɓadǝm Mǝtalabangŋo o kya do a nzali Nod, nǝ njar-takuli mala Iden ngga. ");
INSERT INTO mbu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayinu nong nǝ māmí, sǝ muna kpa a bumi sǝ ɓǝl Inok. Kayinu ka nda aban ɓak nggea-là, sǝ lě ka tunǝi nǝ lullǝ muna-ɓwabura male Inok. ");
INSERT INTO mbu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inok ɓǝl muna-ɓwabura à tunǝi ama Irad. Irad yi ɓǝl muna-ɓwabura lùllǝì ama Mehujayel. Mehujayel yi duk tár Metushayel, sǝ Metushayel ka nda tár Lamek. ");
INSERT INTO mbu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek al amamǝna ɓari; māmí mǝdǝmbe ka nda Ada, sǝ ɓaria nda Zila. ");
INSERT INTO mbu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ɓǝl Jabal, mǝnana nda tár amǝ'do aɓalǝ agumli andǝ amǝ'yál agir ka. ");
INSERT INTO mbu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Lullǝ mǝ'eambi nda Jubal, mǝnana nda tár amǝ'wal zangŋan andǝ amǝ'twang ntetu ka. ");
INSERT INTO mbu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila gbal ka ɓǝl muna à tunǝi ama Tubal-Kayinu, mǝnana yi pǝlǝ mǝ'ntùl kǝ tulki ambalang agirtúró nǝ bolo-bángŋá andǝ bolo-candǝa ka. Mǝ'kyauwa Tubal-Kayinu muna-ɓwama nda Naama. ");
INSERT INTO mbu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek banggi amāmí ama, <<Ada andǝ Zila, wu kwakikir wun arǝàm; wun amālá Lamek, wu ok cau mem. Ən walna-lú acemǝnana ɓwe tsǝkam penye ka, Lagga ɓwa na ǝn wal-luí acemǝnana tùlam ngga. ");
INSERT INTO mbu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ɓǝ̀ ayilǝmu tongno-nong-ɓari na à nǝ̀ ɗwanyi ace wal-lú Kayinu ka, ayilǝmu lumi-tongno-nong-ɓari bwamdǝ tongno-nong-ɓari (77) na à nǝ̀ ɗwanyi ace wal-luem ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu nyare nongnǝ māmí, pǝlǝa ɓǝli wi ɓè muna-ɓwabura ɗǝm. Māmí tsǝki muna lullǝu ama Set. Ne ɓamúrì ama, <<Ɓakuli panam muna-ɓwabura a kun Habila mana Kayinu wal-luí ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set gbal ka ɓǝl muna-ɓwabura, pǝlǝa tsǝki wi lullǝu ama Enosh. A kǝ nzê mǝno ka sǝ aɓwapǝndǝa tita tunǝ lullǝ Mǝtalabangŋo aɓa peri. ");
INSERT INTO mbu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Mǝnia ka nda tsaɗi mala atau mǝnana à pur aɓa Adamu, kǝla mǝnana à gilǝì ɓara-ɓara ka. Ɓakuli pusǝ ɓwapǝndǝa ka, peǎ a purban male yì Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Pusǝia ɓwabura andǝ ɓwama; lang pusǝia ka, tsǝkia wia bù sǝ tunǝia ama <<ɓwapǝndǝa.>> ");
INSERT INTO mbu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lang Adamu pángŋǝ̀nà pǝlǝa gbǝman-mwashat nǝ lumi-tàrú (130) a ɓanza ka, yi ɓǝl muna-ɓwabura kǝla yì, a purban male, sǝ pe wi lullǝu ama Set. ");
INSERT INTO mbu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Anzǝm ɓǝl Set ka, Adamu pak aɓea apǝlǝa gbǝman-tongno-nong-tàrú (800) a ɓanza; sǝ yi duk tár aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Apǝlǝa do ɓanza mala Adamu kat ka nda gbǝman-tongno-nong-ine nǝ lumi-tàrú (930). Anzǝm mǝno ka yi wu. ");
INSERT INTO mbu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Lang Set pàngŋǝ̀nà pǝlǝa gbǝman-mwashat nǝ mǝsǝi tongno (105) a ɓanza ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Enosh. ");
INSERT INTO mbu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Anzǝm ɓǝl Enosh ka, Set pak aɓea apǝlǝa gbǝman-tongno-nong-tàrú nǝ mǝsǝi tongno-nong-ɓari (807) a ɓanza; ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Apǝlǝa do ɓanza mala Set kat ka nda gbǝman-tongno-nong-ine nǝ lum-nong-ɓari (912), sǝ yi wu. ");
INSERT INTO mbu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Lang Enosh pàngŋǝ̀nà apǝlǝa lumi-tongno-nong-ine (90) a ɓanza ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Kenan. ");
INSERT INTO mbu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Anzǝm ɓǝl Kenan ngga, Enosh pakki aɓea pǝlǝa gbǝman-tongno-nong-tàrú nǝ lum-nong-tongno (815) a ɓanza; ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Do ɓanza mala Enosh kat ka apǝlǝa gbǝman-tongno-nong-ine mǝsǝi tongno (905) na, sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Lang Kenan pàngŋǝ̀nà apǝlǝa lumi-tongno-nong-ɓari (70) ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Mahalale. ");
INSERT INTO mbu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan pàk aɓea apǝlǝa gbǝman-tongno-nong-tàrú nǝ lumi-ine (840) a ɓanza anzǝm ɓǝl Mahalale. Sǝ yi ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Do ɓanza mala Kenan kat ka, pàk apǝlǝa gbǝman-tongno-nong-ine nǝ lum (910), sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Lang Mahalale pàngŋǝ̀nà apǝlǝa lumi-tongno-nong-mwashat nǝ mǝsǝi tongno (65) ka, yi ɓǝl muna-ɓwabura lùllǝì ama Jared. ");
INSERT INTO mbu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Anzǝm ɓǝl Jared ka, Mahalale pàk aɓea apǝlǝa gbǝman-tongno-nong-tàrú nǝ lumi-tàrú (830) a ɓanza. Sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Do ɓanza mala Mahalale kat ka apǝlǝa gbǝman-tongno-nong-tàrú nǝ lumi-tongno-nong-ine nǝ mǝsǝi tongno (895) na, sǝ yi wu. ");
INSERT INTO mbu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Lang Jared pàngŋǝ̀nà apǝlǝa gbǝman-mwashat nǝ lumi-tongno-nong-mwashat nǝ mǝsǝi ɓari (162) ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Inok. ");
INSERT INTO mbu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Anzǝm ɓǝl Inok ka, Jared pàk aɓea apǝlǝa gbǝman-tongno-nong-tàrú (800) a ɓanza. Sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Do ɓanza mala Jared kat ka apǝlǝa gbǝman-tongno-nong-ine nǝ lumi-tongno-nong-mwashat nǝ mǝsǝi ɓari (962) na, sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Lang Inok pàngŋǝ̀nà apǝlǝa lumi-tongno-nong mwashat nǝ mǝsǝi tongno (65) ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Metusela. ");
INSERT INTO mbu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Anzǝm ɓǝl Metusela ka, Inok kpata njar mala Ɓakuli arǝ apǝlǝa gbǝman-tàrú (300) a do ɓanza male. Sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Do ɓanza mala Inok kat ka apǝlǝa gbǝman-tàrú nǝ lumi-tongno-nong-mwashat nǝ mǝsǝi tongno (365) na. ");
INSERT INTO mbu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Aɓa do ɓanza male kat ka, Inok kpata njar mala Ɓakuli. A ɓè fara ka Ɓakuli yi twal Inok umnǝi, à nyare à sǝni ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Lang Metusela pàngŋǝ̀nà apǝlǝa gbǝman-mwashat nǝ lumi-tongno-nong-tàrú nǝ mǝsǝi tongno-nong-ɓari (187) ka, yi ɓǝl muna-ɓwabura, lùllǝì ama Lamek. ");
INSERT INTO mbu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Anzǝm ɓǝl Lamek ka, Metusela pàk aɓea apǝlǝa gbǝman-tongno-nong-ɓari nǝ lumi-tongno-nong-tàrú nǝ mǝsǝi ɓari (782) a ɓanza. Sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Do ɓanza mala Metusela kat ka, apǝlǝa gbǝman-tongno-nong-ine nǝ lumi-tongno-nong-mwashat nǝ mǝsǝi tongno-nong-ine (969) na, sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lang Lamek pàngŋǝ̀nà apǝlǝa gbǝman-mwashat nǝ lumi-tongno-nong-tàrú nǝ mǝsǝi ɓari (182) ka, yi ɓǝl muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek tsǝki muni muna-ɓwabura lullǝu ama Nuhu, sǝ na ama, <<Nǝ̀ yina sǝm nǝ girikiban aɓalǝ atanni andǝ atúró rikrya ma'sǝm a nzali mǝnana Mǝtalabangŋo sulǝ súban amurí ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Anzǝm ɓǝl Nuhu ka, Lamek pàk aɓea apǝlǝa gbǝman-tongno nǝ lumi-tongno-nong-ine nǝ mǝsǝi tongno (595) a ɓanza. Sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Do ɓanza mala Lamek kat ka, apǝlǝa gbǝman-tongno-nong-ɓari nǝ lumi-tongno-nong-ɓari nǝ mǝsǝi tongno-nong-ɓari (777) na, sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lang Nuhu pàngŋǝ̀nà apǝlǝa gbǝman-tongno (500) ka, yi ɓǝl amuna-burana tàrú, lullǝia ama Shem andǝ Ham andǝ Jafet. ");
INSERT INTO mbu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lang ɓwapǝndǝa tinata làkkì a ɓanza sǝ à ɓǝlki amuna-mamǝna ka, ");
INSERT INTO mbu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","amuna mala Ɓakuli sǝn ɓoarkinsari mala amuna-mamǝna mala aɓwapǝndǝa, nda à yiu à yì twalki amana à earkicea ateà ka, ɓǝà duk amālea. ");
INSERT INTO mbu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pǝlǝa Mǝtalabangŋo bang ama, <<Bangŋo mem pà nǝ̀ lidǝmba nǝ do aɓa ɓwapǝndǝa do mana málá male pà kàm raka ɗàng, acemǝnana yì ka nǝ̀ nggá wǔ. Sauwa mala do ɓanza male pà nǝ̀ kútì apǝlǝa gbǝman-mwashat nǝ lumi-ɓari (120) ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","A bàkú mǝno sǝ a nzǝmi ka, akwatǝman-ɓwa, yia Nefilim ngga, à ndakam a ɓanza, sǝ lang amuna mala Ɓakuli nongnǝ amuna-mamǝna mala aɓwapǝndǝa ka à ɓǝlki amunia. À nda ka akanggǝrang aɓwana, amǝ'lwa mǝnana lullǝia zǝ́kí ɗiɗyal ka. ");
INSERT INTO mbu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mǝtalabangŋo pelǝki ɓikipa mala ɓealɓikea mala ɓwapǝndǝa a ɓanza, sǝ sǝni ka koya ɗenyicau mala ɓabum ɓwapǝndǝa ka mǝɓike na koya pwari. ");
INSERT INTO mbu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mǝtalabangŋo pak ɓǝnsǝlǝma nǝ pusǝ ɓwapǝndǝa aɓa ɓanza. Gìrnî ɓungi ɓabumi kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Sǝ Mǝtalabangŋo bang ama, <<Mǝ nǝ esǝki ɓwapǝndǝa mǝnana ǝn pe ka a ɓanza; mǝ nǝ kiɗikia atārǝia andǝ agirkusǝu mǝgulke, andǝ amǝkèke mǝnana à kǝ ɓang amur nzali, andǝ anyal mǝnana a bumkuli ka. Ən pak ɓǝnsǝlǝma nǝ pea.>> ");
INSERT INTO mbu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Sǝ mala Nuhu ka, kum earmúrú aban Mǝtalabangŋo. ");
INSERT INTO mbu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mǝnia ka nda cau mǝnana à gilǝì amur Nuhu andǝ ɓala male ka. Nuhu ka nggea mǝɓealɓoarna na aban Ɓakuli; atà aɓwana mǝnana a nza male ka, kǝ yì na do male pàk jik ka. Nuhu kpata njar mala Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu ka ndanǝ amuna-burana tàrú. Lullǝia ma: Shem, sǝ Ham, andǝ Jafet. ");
INSERT INTO mbu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ɓakuli sǝni adyan ngga ɓanza ka kǝ cauɓikea nda mùrú hasǝa mala ɓwapǝndǝa, nyare lùmsǝ nǝ caukpaka. ");
INSERT INTO mbu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ɓakuli pelǝki ka, cauɓikea marǝkina ɓanza kàngkàng, acemǝnana koyan a ɓanza ka anjar male kiɗikina nǝ ɓealɓikea. ");
INSERT INTO mbu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ɓakuli pǝlǝa ne Nuhu ama, <<Mǝ ndo mǝ nǝ twalta ɓwapǝndǝa kat, acemǝnana ɓanza lùmsǝ nǝ caukpaka. Mǝsǝcau ka, mǝ nǝ kiɗiki ɓwapǝndǝa andǝ ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","We ka gballî ɓamur rǝò nggea-waru nǝ nggun gofa, sǝ wu lanzǝ ɓālǝi andǝ nzǝmi nǝ myang mǝcandǝe mǝnana mùr pà nǝ̀ sùr kàm raka. Kasǝki akurǝm aɓalǝi. ");
INSERT INTO mbu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ani sǝ awu nǝ gballì warunì: Sauwa male ka, kusǝu gbǝman-ine nǝ lumi-tongno (450). Tangŋa male ka kusǝu lumi-tongno-nong-ɓari bwamdǝ tongno (75). Sǝ dāh'rya male ka, kusǝu lumi-ine bwamdǝ-tongno na (45). ");
INSERT INTO mbu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gballì mùrí, sǝ wu nying nreban mǝnana tangŋa male ka ɓakusǝu mwashat na nǝ tsùrú aɓata mùrí sǝ arǝ agírǝí, ɓǝ̀ kàrìban kat. Gballì ɓá warunì ɓǝ̀ pangnǝ aɓalǝ akurǝm a nzali, a ɓalǝu, sǝ a kùli, sǝ wu tsǝk kun waru a nkanggari. ");
INSERT INTO mbu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Sǝni! Mǝ ndo mǝ nǝ yinǝ nggea mùr-gùla a ɓanza mǝnana nǝ̀ yia twalta gìr mana kat ndanǝ yilǝmu ka. Koman a ɓanza kǝ lin'ueo ka nǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Sǝama we ka, mǝ nǝ tamsǝ kùrcau mem a nre sǝm, sǝm nǝ we. Awu nǝ kúti aɓa waru, we sǝ māmó, sǝ amunio andǝ amālia. ");
INSERT INTO mbu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Awu nǝ yinǝ koya ulang girkusǝu ɓari-ɓari: jamne andǝ mǝ'nggaule, atò a waru, ace mǝnana wu amsǝia ka. ");
INSERT INTO mbu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Koya ulang nyal ka, awu nǝ oasǝ ɓari-ɓari a waru, sǝ koya ulang girkusǝu ka, awu nǝ oasǝ ɓari-ɓari a waru, andǝ koya ulang gìr mǝyilǝmui mǝnana kǝ ɓang a nzali ka ɓari-ɓari, ɓǝà yiu atò aɓa waru. ");
INSERT INTO mbu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Awu nǝ ram koya ulang girlina ma'wun, sǝ mala agirkusǝu, mana nǝ̀ karǝban kat ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu pàk koya gìr ka a nggùnì kǝla mǝnana Ɓakuli ne wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mǝtalabangŋo ne Nuhu ama, <<Yiu kùtí aɓa nggea-waru, we wunǝ amǝ'ɓala mò kat, acemǝnana a nda kǝ ɓwa mǝnana ǝn sǝni mǝ'ɓealɓoarna aɓalǝ aɓwana mana à ndanǝ yilǝmu ado ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Twal koya girkusǝu mǝnana mǝɓoarne na ace girlina ka, jamne tongno-nong-ɓari sǝ mamǝne tongno-nong-ɓari, wu yinǝia atò aɓa nggea-waru. Ɗǝm ngga twal ɓari-ɓari atà koya girkusǝu mǝnana gìr'ɓeami na ace girlina ka, komǝye ka jamne andǝ mamǝna, ɓǝà kùtí atò a waru. ");
INSERT INTO mbu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Twal atò ɗǝm koya nyal mǝnana kǝ yal a kùli ka tongno-nong-ɓari, komǝyenani ka jamne andǝ mamǝne. Pàk mǝnia ka ace mǝnana atà koya ulang girkusǝu andǝ koya ulang nyal ka, ɓǝà kum amǝnana à nǝ̀ pangnǝ yilǝmu ace ɓǝla malea a ɓanza ɗǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Anzǝm nongŋo tongno-nong-ɓari, tite ado ka, mǝ ndo mǝ nǝ nya mbulo mǝnana nǝ̀ nggǝ nya dù lumi-ine andǝ pwari lumi-ine. Aɓa pě anggo ka, mǝ nǝ twalta koya gìr mana nǝyilǝmu ǝn pê a ɓanza ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu pàk koya gìr mǝnana kat Mǝtalabangŋo banggi wi ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu ka ndanǝ apǝlǝa gbǝman-tongno-nong-mwashat (600) sǝ mùr-gùla yi aki ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Yì andǝ māmí, andǝ amuni andǝ amālia, à kùtí aɓa nggea-waru ace apî mùr-gùla. ");
INSERT INTO mbu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Koya ulang girkusǝu andǝ koya ulang nyal, yia ɓari-ɓari; amǝnana Ɓakuli bang ama amǝɓoarne na ace girlina, andǝ amǝnana bang ama agir'ɓeami na ka. Kpapi andǝ amǝnana à kǝ ɓang a kwàr nzali ka. Komǝye ateà ka, ");
INSERT INTO mbu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","jamne andǝ mamǝne, à yiu aban Nuhu à yì kúti aɓa nggea-waru, kǝla mǝnana Ɓakuli banggi Nuhu ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Anzǝm nongŋo tongno-nong-ɓari ka, mùr-gùla yi aki ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Aɓa pǝlǝa mǝnana Nuhu lùmsǝ̀nà pǝlǝa gbǝman-tongno-nong-mwashat (600) nǝi a ɓanza, a lum bwamdǝ tongno-nong-ɓaria pwari mala ɓaria zongŋo ka, akun atūli-mùr mǝnana atà nzali kat ka à mǝngia, sǝ mbulo ɓun nǝ bumkuli kpana-kpana. ");
INSERT INTO mbu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mbulo nya aɓa ɓanza twal nongŋo lumi-ine, du andǝ pwari. ");
INSERT INTO mbu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Akǝ mǝno yì pwari mbulo tinata nya nǝi ka, Nuhu andǝ amuna-burana male tàrú, Shem, andǝ Ham, sǝ Jafet, à kùtí aɓa waru atārǝia andǝ mālá Nuhu andǝ amālá amuna-burana male mǝno tàrú ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","À oasǝ akoya girkusǝu ateà a waru: anyam-bondo andǝ anyam-ɓala, amǝgulke andǝ amǝkèke, andǝ koya ulang nyal. ");
INSERT INTO mbu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Girbunda man kat kǝ lin'ueo ka, à yiu ɓari-ɓari à yì kùtí atà Nuhu a waru. ");
INSERT INTO mbu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Agirkusǝu mana à kútí ka, jamne andǝ mǝ'nggaule mala koya ulang gìr-yilǝmu na, kǝla mǝnana Ɓakuli ne wi yì Nuhu ka. Pǝlǝa Mǝtalabangŋo gìr kun waru nǝ Nuhu aɓalǝi. ");
INSERT INTO mbu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mùr-gùla camarǝ yiu sǝ kǝ lime a ɓanza kya bwal nongŋo lumi-ine. Mùr lo gul kǝ̀rkǝ́r, kara loasǝ waru a kùli. Waru kya purrì múr ɓanza piku-piku. ");
INSERT INTO mbu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mùr long nǝ lo ana kpana-kpana amúr ɓanza kat, waru kǝ kyal nǝmurǝì amúr mùr. ");
INSERT INTO mbu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mùr camarǝ lo gandǝa kya kongsǝ ankono mǝ'dāh'rike kat mala koya ban a ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","A masǝlǝate ka, mùr kya lim kǝ̀rkǝ́r yàle ankono mana à kutiban kat nǝ dāh'rya ka, mùr kongsǝ múrià nǝ lime ɓakusǝu lumi-ɓari nǝ mǝsǝì ɓari (22). ");
INSERT INTO mbu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Koya gìr nani mana ndanǝ yilǝmu ka, wù kat: anyal, anyam-ɓala andǝ anyam-bondo, amuna-nyama mǝkèke mǝnana à kǝ kuɗǝki a kwàr nzali, andǝ ɓwapǝndǝa kat, wu puppup. ");
INSERT INTO mbu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Koya gìr mana kǝ lin'ueo sǝ do a ɓanza man ngga, tè twal kat. ");
INSERT INTO mbu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mǝtalabangŋo twalta koya gìr mana kǝ lin'ueo a ɓanza man ngga: aɓwana, agirkusǝu, agiryilǝmu mǝkèke mǝnana à kǝ ɓang a kwàr nzali, andǝ anyal mǝnana a bumkuli ka, twaltea kat a ɓanza. Kǝ aɓwana mana à au ka, à nda ka Nuhu andǝ aɓwana mǝnana atè aɓa waru ka. ");
INSERT INTO mbu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mùr aki ɓanza pàk nongŋo gbǝman-mwashat nǝ lumi-tongno (150). ");
INSERT INTO mbu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Sǝ cau mala Nuhu andǝ anyam-ɓabondo andǝ anyam-ɓala mana atè aɓa waru ka nda a ɓabum Ɓakuli. Nda tasǝ gung ɓǝ̀ ɓua amur ɓanza, mùr pǝlǝa tita sonzǝo. ");
INSERT INTO mbu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Amáɗí-mùr mana a tà-nzali ka à tākya, ɓunno mala mùr mana nǝ bumkuli kpana-kpana ka amsǝa, sǝ mbulo tukio. ");
INSERT INTO mbu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mùr pǝlǝa tita nyar ɓukɓuk aban sonzǝo a ɓanza. Lang yi lùmsǝ̀nà anongŋo gbǝman nǝ lumi-tongno (150) ka, mùr sonzǝna adyan pepè. ");
INSERT INTO mbu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Aɓa lum bwamdǝ-tongno-nong-ɓaria pwari mala tongno-nong-ɓaria zongŋo ka, nggea-waru yi came amúr ɓè nkono aɓalǝ ankono mala nzali Ararat. ");
INSERT INTO mbu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mùr lidǝmba nǝ nyar nǝ te yi pur a lumia zongŋo. Aɓa pwari mǝdǝmbe mala lumia zongŋo ka, ɓong ankono sa a nza. ");
INSERT INTO mbu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Anzǝm anongŋo lumi-ine ka, Nuhu mǝn fongǝran mǝnana pè arǝ nggea-waru ka, ");
INSERT INTO mbu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","pǝlǝa tasǝ gang'lang ɓǝ̀ puro. Gang'langnì camarǝ gāli, nǝ̀ ká sǝ nǝ̀ nyare bà ime mala mùr a nzǝm-nzali. ");
INSERT INTO mbu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Anzǝm mǝno bǝti ka, Nuhu tasǝ kutu ɓǝ̀ kya sǝni ko mùr sonzǝna, nza sangna. ");
INSERT INTO mbu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kutu gandǝ kum ban sulǝo ɗang acemǝnana mùr nakam più, akban kat a ɓanza. Kutu pǝlǝa nyare aban Nuhu a waru. Nuhu lǝmdǝ bui a fongǝran, ak kutu, sǝ nyesǝi aɓa nggea-waru. ");
INSERT INTO mbu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Anzǝm nongŋo tongno-nong-ɓari ka, Nuhu nyare tasǝ kutu ɗǝm ɓǝ̀ puro. ");
INSERT INTO mbu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Lang pwari nǝ̀ ká kpa ka, kutu nyare yiu, sǝ Nuhu sǝni ka, mbú nggun-olif mǝpwale na a kúni. Nda Nuhu sǝlǝa ama mùr-gùla nyarna nǝ te. ");
INSERT INTO mbu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuhu kundǝ ɗǝm aɓea nongŋo tongno-nong-ɓari, sǝ nyare tasǝ kutu ɓǝ̀ kyane. Lang kutu umna ka nyare yiu ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Adyan ngga, Nuhu ndanǝ apǝlǝa a ɓanza gbǝman-tongno-nong-mwashat nǝ mǝsǝì mwashat (601). A pwari mǝdǝmbe mala zongŋo mǝdǝmbe mala mǝno yì pǝlǝa ka, mùr sonzǝni ɓanza. Nuhu pǝlǝa loasǝ gìr mǝnana kùmsǝ̀ múr waru ka. Lang nǝ̀ sǝnban ngga nzali imǝna. ");
INSERT INTO mbu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Aɓa lumi-ɓari bwamdǝ tongno-nong ɓaria (27) pwari mala ɓaria zongŋo ka, ɓanza imǝna kat! ");
INSERT INTO mbu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Pǝlǝa Ɓakuli ne Nuhu ama, ");
INSERT INTO mbu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Wu pùrrî ɓá waru, we sǝ māmó, sǝ amunio andǝ amālia. ");
INSERT INTO mbu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pusǝ koya gìr-yilǝmu mana atò a waru ka: anyal, andǝ agirkusǝu andǝ amǝnana àkǝ kuɗǝki a kwàr nzali ka: ace mǝnana ɓǝà yi ɓǝla, ɓǝà hatǝki, ɓǝà aki ɓanza ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nda Nuhu pùrrî ɓá waru, yì andǝ māmí andǝ amuni andǝ amālia. ");
INSERT INTO mbu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sǝ koya girkusǝu, koya gìr mana kǝ pūrǝki nǝ múrbumi a nzali, andǝ koya nyal, andǝ koya gìr mana kǝ gya a ɓanza ka, à pùrrî ɓá waru kat, koya mbalangni a ɓinalea. ");
INSERT INTO mbu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pǝlǝa Nuhu ɓakkî Mǝtalabangŋo gyangŋan; twal atà koya girkusǝu andǝ nyal mǝnana amǝɓoarne na ace girlina ka, pana gir'nkila mala pisǝe kǝring nǝia amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mǝtalabangŋo ka banɓoari wi nǝ ok rǝm mǝno yì ɓoro ka. Ne ɓamúrì ama, <<Pà mǝ nǝ sú nzali ɗǝm ace cau mala ɓwapǝndǝa ɗang, ko kat andǝ amani ama koya ɗenyicau malea lùmsǝo nǝ ɓealɓikea twal a lo-ɓwa malea ka. Pa mǝ nǝ nyar ɗǝm mǝ nǝ kiɗiki gìr mǝnana ǝn pe, mana ndanǝ yilǝmu ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ɓǝ̀ mbak sǝ ɓanza na kam ngga, pwari ɓeale, sǝ pwari cane, kunɗwal andǝ gungpi, mbulo sǝ kunte, pwari andǝ du, à pà nǝ̀ ue ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ɓakuli tsǝki Nuhu andǝ amuni bu sǝ nea wia ama: Wu ɓǝla, wu hatǝki, wu lùmsǝ ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Koya nyam-bondo, sǝ koya nyal a bumkuli, andǝ koya gìr mǝnana kǝ kuɗǝki a nzǝm-nzali, andǝ anji kat a nggeamùr, à nǝ̀ nggǝ ɓangga wun sǝ múrià nǝ̀ kària arǝ wun. Ən pana wunia kat a bù wun. ");
INSERT INTO mbu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Koya gìr mǝnana kǝ gya sǝ ndanǝ yilǝmu ka, nǝ̀ duk girlina ma'wun. Kǝla mǝnana ǝn pa wun agirpwala ɓǝà duk girlina ma'wun ngga, ǝn pana wun girbunda kat. ");
INSERT INTO mbu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kǝgìr mǝnana pa wu nǝ li raka nda nyama mǝnana yilǝmi na aɓa nyami più ka, mǝnana nda nkile ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ɓwa mǝnana twal yilǝmi ɓwa ka, mǝ nǝ ɗice mǝno yì yilǝmu ka a bu kǝ ɓwe. Sǝ ɓǝ̀ girkusǝu na gbal sǝ wal-lú ɓwa ka, girkusǝunì gbal ka ɓǝà wali ɓǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ɓǝ̀ yana sǝ twal yilǝmi ɓwa ka, yì gbal ka à nǝ̀ twal yilǝmi, acemǝnana Ɓakuli pak ɓwapǝndǝa aɓa purban male. ");
INSERT INTO mbu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Wun ngga, wu ɓǝla, wu hatǝki, wu akiban a ɓanza. ");
INSERT INTO mbu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Pǝlǝa Ɓakuli ne Nuhu andǝ amuni ama, ");
INSERT INTO mbu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<Mǝ ndya ǝn nggǝ tamsǝ kùrcau mem sǝnǝa wun andǝ amuna wun andǝ amǝkà wun, ");
INSERT INTO mbu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","sǝ nǝ́ koya girkusǝu mǝnana kutio atà wun aɓa waru ka; anyal, andǝ anyam-ɓala andǝ nyam-bondo; andǝ koya gìr nani mǝnana ndanǝ yilǝmu a ɓanza ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mǝ ndya ǝn nggǝ tamsǝ kusǝ kùrcau mem nǝ wun ngga: Mùr-gùla pa nǝ̀ nyar ɗǝm nǝ̀ twalta yilǝmu ɗàng. À pà nǝ̀ kiɗiki ɓanza ɗǝm nǝ nggea mùr-gùla ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ɓakuli nyare na ama, <<Mǝnia ka nda gìr'lǝmdǝa mala kùrcau mǝnia ǝn nggǝ kùrì a nrem sǝm sǝnǝa wun andǝ koya gìr mana nǝyilǝmu atà wun ngga, kùrcau mana nda ace anza mǝnana à kǝ yiu peatu ka: ");
INSERT INTO mbu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ən tsǝ́ngŋǝ̀nà npāring aɓalǝ apǝrɓang. Nda gìr'lǝmdǝa mem mala kùrcau a nrem andǝ ɓanza ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ɓǝ̀ nda aya pwari sǝ ǝn sulǝ apǝrɓang amur ɓanza, sǝ npāring pusǝrǝi aɓalǝ apǝrɓang ngga, ");
INSERT INTO mbu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mǝ nǝ ɗenyi nǝ kùrcau mem mǝnia ǝn pangnǝ wun andǝ koya ambalang agir mǝnana à ndanǝ yilǝmu ka. Nggea mùr-gùla pa nǝ̀ nyare nǝ̀ twalta yilǝmu ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ɓǝ̀ aya pwari sǝ npāring pusǝrǝi aɓalǝ apǝrɓang ngga, mǝ nǝ sǝnì, sǝ ɓalǝam nǝ̀ kasǝa arǝ kùrcau mana málá male pà kàm raka, mǝnana a nre Ɓakuli andǝ yilǝmu kat a ɓanza ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pǝlǝa Ɓakuli ne Nuhu ama, <<Mǝnia yì npāring ngga, nda gìr'lǝmdǝa mala kùrcau mǝnana ǝn tsǝì a nrem andǝ yilǝmu kat a ɓanza ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Amuna-burana mala Nuhu mana à purî ɓá waru ka à nda ka Shem, andǝ Ham sǝ Jafet. Ham ɓǝl muna-ɓwabura lùllǝì ama Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Amǝnia yì amuna-burana mala Nuhu tàrú ka, à nda à yi ɓǝl ɓwapǝndǝa kat mana à mesǝ a koya ban a ɓanza ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu ka mǝrya na sǝ nda tita tsǝk ɓaban mala anggun-anap ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","A ɓè pwari ka, Nuhu nu mùr-ɓǝlanggun anap mǝhangŋe kǝ̀rkǝ́r, mùr anap wàlì, pǝlǝa kpa nong nǝ ɓate aɓa tara male. ");
INSERT INTO mbu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, tár Kan'ana ka sǝn tárrí aban nongŋo nǝ ɓate. Pǝlǝa puro wari a nza kya banggi amǝ'eambi mǝnia ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sǝ Shem andǝ Jafet ka, à twal lagir à mǝni a nzǝmia sǝ à ging nǝ nzǝm à yi kùmsǝî tárrià amurí, gìr ɓate. À pǝlǝ mǝsǝia nǝ ɓe ban ɗàng, à sǝn ɓata tárrià ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Lang dǝm Nuhu kwarna ka, yi sǝlǝce gìr mǝnana Ham, muni mǝkyauwe pakki wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Bang ama, <<Súban ɓǝ yiu amúr Kan'ana! Yì ka nǝ̀ duk guro mala aguro aban amǝ'eambi. ");
INSERT INTO mbu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ɓwangsǝban ɓǝ pa aban Mǝtalabangŋo, Ɓakuli mala Shem! Kan'ana nǝ̀ duk guro mala Shem. ");
INSERT INTO mbu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ɓakuli ɓǝ̀ tangsǝ nzong-nzali mala Jafet! Amuna male andǝ amǝkè nǝ̀ do atārǝia andǝ aɓwana mala Shem! Kan'ana nǝ̀ duk guro mala Jafet.>> ");
INSERT INTO mbu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Anzǝm pa mala mùr-gùla ka, Nuhu pàk aɓea pǝlǝa gbǝman-tàrú nǝ lumi-tongno (350). ");
INSERT INTO mbu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Do ɓanza mala Nuhu kat ka pǝlǝa gbǝman-tongno-nong-ine nǝ lumi-tongno na (950). Anzǝm mǝno ka sǝ yi wú. ");
INSERT INTO mbu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Amǝnia ka à nda ka amuna andǝ amǝkau a tàu mala Shem, andǝ Ham, andǝ Jafet, yì amuna-burana mala Nuhu. Yia mǝnia tàrú ka à ɓǝlki amuna anzǝm málá mala mùr-gùla. ");
INSERT INTO mbu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Amuna-burana mala Jafet ka à nda ka: Goma, Magog, Madai, Javan, Tubal, Meshek andǝ Tiras. ");
INSERT INTO mbu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Amuna andǝ amǝkà Goma ka à nda ka: Amǝ Asǝkena, amǝ Rifat andǝ amǝ Togama. ");
INSERT INTO mbu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Amuna andǝ amǝkà Javan ngga à nda ka ɓwapǝndǝa mala anzali: Elisha, Tarshi, Kitim, andǝ Rodanim. ");
INSERT INTO mbu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(A tǝrta aɓwana mǝnia ka sǝ aɓwapǝndǝa mǝnana à duki arǝ aluran aɓa nggeamùr andǝ akún nggeamùr ka à puro. À nda ka amǝkà Jafet mǝnana à mesǝe arǝ anzali ɗàngɗáng, sǝ koyan ateà ka à súrǝì nǝ kún male, sǝ tàu male, andǝ nzali male mǝnana pàk kàm ngga.) ");
INSERT INTO mbu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Amuna-burana mala Ham ngga à nda ka: Kush, Mizǝrem, Put andǝ Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Amuna mala Kush ka à nda ka Seba, Havila, Sapta, Raama, andǝ Sapteka. Amuna mala Raama ka à nda ka Sheba andǝ Dedan. ");
INSERT INTO mbu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ɓè ɓwa atà amǝkà Kush ka nda Nimro. Yì Nimro ka nda ɓwa mǝnana tita duk ɓwa mǝcandǝe a ɓanza ka. ");
INSERT INTO mbu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nǝ́ pâ gbasha mala Mǝtalabangŋo ka, yi duk nggeà kanggǝrang mǝ'nta. Acemani ka aɓwana kǝ na ama, <<Ɓǝ̀ Mǝtalabangŋo tsǝo wu duk kanggǝrang mǝ'nta kǝla Nimro!>> ");
INSERT INTO mbu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Anggea-là mǝnana à ɓoaro à kutiban kat aɓata nzali-murǝm mala Nimro a nzali Shinar ka à nda ka Babila, Erek, Akat andǝ Kalne. ");
INSERT INTO mbu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimro puro a nzali Shinar sǝ o a nzali Assuriya kya ɓakia anggea-là Nineva, Rehobot-Ir, Kalne ");
INSERT INTO mbu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","andǝ Resen kàm. Resen ngga nggea-là na a nre Nineva andǝ nggea-là mǝgule Kalne. ");
INSERT INTO mbu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizǝrem ngga nda tár a Lud, Anam, Lehap, Naftu, ");
INSERT INTO mbu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patǝru, Kasǝlu, andǝ Kafto. Arǝ abân mǝnia ka sǝ amǝ Filisti puro à yiu. ");
INSERT INTO mbu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Muna-ɓwabura mǝkyauwe mala Ham yì Kan'ana ka nda yi duk tár Sidon andǝ amǝ'Hitti ka. ");
INSERT INTO mbu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kan'ana ɗǝm ngga nda kàka amǝ'Jebus, amǝ'Amor, amǝ'Girgash, ");
INSERT INTO mbu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","amǝ'Hivi, amǝ'Arkit, amǝ'Sǝni, ");
INSERT INTO mbu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","amǝ'Arǝvad, amǝ'Zema, andǝ amǝ'Hamat. Nǝ nzǝ́mò ka aɓwapǝndǝa mǝnia à pùr a tàu mala Kan'ana ka, à yi mesǝke. ");
INSERT INTO mbu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Acemani ka nzong-nzali mala amǝ'Kan'ana tangŋa tite a ban nggea-là Sidon sǝ sulǝo yi puro aban là Gera, pǝlǝa twalo a là Gaza sǝ sárǝ́ aban ká arǝ alá Sodom, Gomora, Adǝma andǝ Zeboyim, sǝ kya masǝlǝa a Lasha. ");
INSERT INTO mbu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amǝno yì aɓwana kat ka, à pur a tàu mala Ham. Koyan ateà ka à súrǝì nǝ tàu male, sǝ kún male, sǝ bu-nzali male, andǝ nzali male mǝnana pàk kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem mǝnana nda mǝgula Jafet ka à ɓǝli wi amuna-burana gbal. Shem ngga nda kàka Eba andǝ amuni andǝ amǝkè kat. ");
INSERT INTO mbu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Amuna-burana mala Shem ngga à nda ka: Elam, Asshur, Arfakza, Lud andǝ Aram. ");
INSERT INTO mbu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aɓwapǝndǝa mǝnana a tàu mala Aram ngga à nda ka: Amǝ'Uz, amǝ'Hul, amǝ'Geta andǝ amǝ'Meshek. ");
INSERT INTO mbu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakza ka nda tár Shela, sǝ Shela ka nda tár Eba. ");
INSERT INTO mbu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","À ɓǝlî Eba amuna-burana ɓari. Ɓè man mwashat ka à tunǝi ama Pele, acemǝnana a nza male sǝ aɓwapǝndǝa mesǝe arǝ abân aɓa ɓanza; mǝ'eambi nda Joktan. ");
INSERT INTO mbu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan ngga nda tár a Almoda, Shelep, Hazamave, Jera, ");
INSERT INTO mbu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikǝla, ");
INSERT INTO mbu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimayel, Sheba, ");
INSERT INTO mbu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, andǝ amǝ'Jobap. Yia mǝnia kat ka, à nda ka amǝkà Joktan. ");
INSERT INTO mbu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nzali-do mala aɓwana mǝnia kat ka, tite a Mesha sǝ sarǝa kya puro a Sefar, nzali múr ankono a njar-takuli. ");
INSERT INTO mbu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amǝno ka, à nda ka amuna andǝ amǝkà Shem. Koyan ateà ka à súrǝì nǝ tàu male, sǝ kún male, sǝ bu-nzali male, andǝ nzali male mǝnana pàk kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aɓwapǝndǝa mǝno kat ka à nda ka amuna andǝ amǝkau mala amuna-burana mala Nuhu, koyan ngga nǝ nggurkwar mala tàu male, aɓalǝ anzali malea. Twalo abania sǝ aɓwapǝndǝa mesǝe arǝ aban aɓa ɓanza kat, anzǝm mùr-gùla. ");
INSERT INTO mbu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Anggo ka kǝ kún mǝmwashati na ɓwapǝndǝa nakiyi a ɓanza kat ka, sǝ acau mǝmwashati na gbal à kǝ puro a kunia ka. ");
INSERT INTO mbu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lang ɓwapǝndǝa tita tùrki arǝ abân nǝ bù takuli ka, à kya kum ɓè ɓawanban a Shinar pǝlǝa à duk kam. ");
INSERT INTO mbu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sǝ à nea rǝia ama, <<Ɓǝ̀ sǝm ɓak atobali, sǝ ɓǝ̀ sǝm twania a bǝsa pepè.>> À paktúró nǝ dǝɓang ɗurǝkya a kúnì tali, sǝ kwalta do nda shiminti malea. ");
INSERT INTO mbu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Pǝlǝa à na ama, <<Wu fani, ɓǝ̀ sǝm ɓàngŋǝ́nì nggea-là nǝ ndà-kulí nggea mǝ'dāhre mǝnana ɓǝ̀ u ɓong-ɓong a kùli ka, ace mǝnana ɓǝ̀ sǝm kumbi ɓamur rǝ sǝm lullǝu, sǝ ɓǝ̀ sǝm kǝa mesǝkì tarǝ sǝm aɓa ɓanza raka.>> ");
INSERT INTO mbu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sǝ Mǝtalabangŋo sulǝo yiua sǝn nggea-là andǝ nggeaɓa mǝɓong-ɓongni mǝnana aɓwapǝndǝa ɓakkiyi ka. ");
INSERT INTO mbu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mǝtalabangŋo na ama, <<Ɓǝ̀ kǝla aɓwana mwashat, sǝ kún mǝmwashati na à nakiyi ka, sǝ à tita pàk gìr kǝla mǝnia ka, kǝgìr pà kàm mǝnana à kùr kunarǝia à nǝ̀ pè sǝ nǝ̀ gandǝia ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wu yiu sǝm nǝ̀ sùlǝ́nì, ɓǝ̀ sǝm kya zurǝkini kunia, ace mǝnana ɓǝà kǝa bwalta acau mǝnana à nakiyi arǝarǝia ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nda Mǝtalabangŋo mesǝkia akanó arǝ aban aɓa ɓanza, kara à tamsǝ ɓak mǝno yì nggea-là ka. ");
INSERT INTO mbu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nda gìrnî sǝ à tsǝki banì lullǝu ama, Babel, acemǝnana akǝ banì sǝ Mǝtalabangŋo zurǝki kún mala ɓanza kat. A kàm ɗǝm sǝ Mǝtalabangŋo mesǝki aɓwana a bum ɓanza kat. ");
INSERT INTO mbu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Mǝnia ka nda cau mǝnana à gilǝì amur Shem andǝ aɓwana mana a tàu male ka. Shem ngga ndanǝ pǝlǝa gbǝman-mwashat (100) sǝ ɓǝl Arfakza; ɓǝli a ɓaria pǝlǝa anzǝm yiu mala mùr-gùla. ");
INSERT INTO mbu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Anzǝm ɓǝl Arfakza ka, Shem nyare pàk aɓea pǝlǝa gbǝman-tongno (500) a ɓanza sǝ ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Lang Arfakza pàngŋǝ̀nà pǝlǝa lumi-tàrú bwamdǝ tongno (35) ka, yi ɓǝl Shela. ");
INSERT INTO mbu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Anzǝm ɓǝl Shela ka, Arfakza pàk aɓea pǝlǝa gbǝman-ine nǝ mǝsǝi tàrú (403) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Lang Shela pàngŋǝ̀nà pǝlǝa lumi-tàrú (30) ka, yi ɓǝl Eba ");
INSERT INTO mbu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Anzǝm ɓǝl Eba ka, Shela pàk aɓea pǝlǝa gbǝman-ine nǝ mǝsǝi tàrú (403) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Lang Eba pàngŋǝ̀nà pǝlǝa lumi-tàrú nǝ mǝsǝ ine (34) ka, yi ɓǝl Pele. ");
INSERT INTO mbu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Anzǝm ɓǝl Pele ka, Eba pàk aɓea pǝlǝa gbǝman-ine nǝ lumi-tàrú (430) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Lang Pele pàngŋǝ̀nà pǝlǝa lumi-tàrú (30) ka, yi ɓǝl Reyu. ");
INSERT INTO mbu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Anzǝm ɓǝl Reyu ka, Pele pàk aɓea pǝlǝa gbǝman-ɓari bwamdǝ tongno-nong-ine (209) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Lang Reyu pàngŋǝ̀nà pǝlǝa lumi-tàrú nǝ mǝsǝi ɓari (32) ka, yi ɓǝl Seru. ");
INSERT INTO mbu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Anzǝm ɓǝl Seru ka, Reyu pàk aɓea pǝlǝa gbǝman-ɓari bwamdǝ tongno-nong-ɓari (207) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Lang Seru pàngŋǝ̀nà pǝlǝa lumi-tàrú (30) ka, yi ɓǝl Naho. ");
INSERT INTO mbu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Anzǝm ɓǝl Naho ka, Seru pàk aɓea pǝlǝa gbǝman-ɓari (200) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Lang Naho pàngŋǝ̀nà pǝlǝa lumi-ɓari bwamdǝ tongno-nong-ine (29) ka, yi ɓǝl Tera. ");
INSERT INTO mbu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Anzǝm ɓǝl Tera ka, Naho pàk aɓea pǝlǝa gbǝman-mwashat nǝ lum bwamdǝ tongno-nong-ine (119) a ɓanza. Aɓalǝ apǝlǝa mǝno ka, ɓǝlki aɓea amuna-burana andǝ amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Anzǝm mana Tera pàngŋǝ̀nà pǝlǝa lumi-tongno-nong-ɓari (70) ka, yi ɓǝl a Ibǝram, andǝ Naho sǝ Haran. ");
INSERT INTO mbu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Mǝnia ka nda cau mǝnana à gilǝì amur Tera andǝ aɓwana mana a tàu male ka. Tera ɓǝl a Ibǝram, andǝ Naho sǝ Haran. Haran yi ɓǝl Lotu. ");
INSERT INTO mbu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran aki tárrí dǝmba paklú a nggea-là Ur a nzali mala amǝ Chaldi, ban mǝnana à ɓǝli kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibǝram andǝ Naho yia kǝm à alki amamǝna. Mālá Ibǝram nda Sarayi, sǝ mālá Naho nda Milka. Milka andǝ mǝkyauwe muna-ɓwama Iska ka, à nda ka amuna-mamǝna mala Haran. ");
INSERT INTO mbu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi ka nkombi na, ɓǝl muna ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera tùrlà nying Ur nǝ̀ o a nzali Kan'ana. Twal muni Ibǝram andǝ mǝkè Lotu, muna mala Haran, andǝ nkili Sarayi yì mālá Ibǝram atè. Amur njar aban ká ka, à yi cam a nggea-là Haran, pǝlǝa à duk kano. ");
INSERT INTO mbu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Lang Tera lùmsǝna pǝlǝa gbǝman-ɓari bwamdǝ tongno (205) ka, paklú kanó a Haran. ");
INSERT INTO mbu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mǝtalabangŋo ne Ibǝram ama, <<Purî nzali ma'wun, puro nying aɓwana mô, andǝ ɓala mala tárró. O a nzali mǝnana mǝ nǝ lǝmdǝo wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","<<Mǝ nǝ tsǝo awu nǝ duk nzali mala aɓwapǝndǝa mǝ'làkke. Mǝ nǝ tsǝko bù, mǝ nǝ tsǝa lullǝo nǝ̀ zǝkya, sǝ awu nǝ duk mǝgulo kǝ̀rkǝ́r. Nǝbano sǝ aɓwana nǝ̀ kum tsǝkbu. ");
INSERT INTO mbu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aɓwana mǝnana à tsǝko bù ka, mǝ nǝ tsǝkia wia bù sǝ aɓwana mǝnana à suio ka, mǝ nǝ suia. Sǝ atau mala aɓwapǝndǝa kat a ɓanza ka, à nǝ̀ kum tsǝkbu nǝbano.>> ");
INSERT INTO mbu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ibǝram bwal njargula o kǝla mǝnana Mǝtalabangŋo banggi wi ka; Lotu gbal ka o atè. Ibǝram nǝ̀ nying nzali Haran ngga, ndanǝ apǝlǝa lumi-tongno-nong-ɓari nǝ mǝsǝì tongno (75). ");
INSERT INTO mbu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ibǝram twal māmí Sarayi andǝ mǝkine Lotu andǝ gǝna malea mǝnana kat à ram ngga, andǝ aɓwapǝndǝa mǝnana à ndanǝi a Haran ngga, sǝ à bwal njargula aban o a nzali Kan'ana. Lang à bingŋǝna ka, ");
INSERT INTO mbu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ibǝram gya arǝ aban aɓa nzali Kan'ana yi bwal Shekem. A banì ka tsǝk gumli a tǝ́r ɓe nggun mǝgule mana à tunǝki ama nggun Moreh ka. A mǝno yì bàkú ka amǝ'Kan'ana nakam nǝdo a nzalinì. ");
INSERT INTO mbu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mǝtalabangŋo pusǝrǝi aban Ibǝram, sǝ ne wi ama, <<Nzali mǝnia a sǝngiyi ka, mǝ nǝ pè amunio andǝ amǝ'keò.>> Pǝlǝa Ibǝram ɓak gyangŋan kàm ace Mǝtalabangŋo, mǝnana pusǝrǝi a baní ka. ");
INSERT INTO mbu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ibǝram loapi Shekem, twal gya o a nzali múr ankono a takuli mala là Betel. Kya tsǝk gumli male a ɓè ban mǝnana Betel na a bui mala njar-nzali, sǝ là Ai ka nda a bui mala njar-takuli ka. A ban mǝno ka Ibǝram nyare ɓak gyangŋan ace Mǝtalabangŋo, sǝ peri aban Mǝtalabangŋo. ");
INSERT INTO mbu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ibǝram nyare lo lidǝmba nǝ gya, kǝ turki arǝ abân bǝti-bǝti, tsǝk múrí nǝ̀ ká a Negev. ");
INSERT INTO mbu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nzala yi kpa aɓa nzali Kan'ana. Nzalè ɓiki pa kǝ̀rkǝ́r nda Ibǝram lo nǝ̀ o a nzali Masar nǝ̀ nggá duk kam bǝti. ");
INSERT INTO mbu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Lang malanǝ̀ kùtí a Masar ka, banggi māmí Sarayi ama, <<Sǝni pé, ǝn sǝlǝna ama a nda ɓwama nggea mǝɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ɓǝ̀ aɓwana mǝnana a Masar sǝno ka, à nǝ̀ na ama a nda māmám; pǝlǝa à nǝ̀ wal-luem ace mǝnana à nǝ̀ twalo wu duk malea ka. ");
INSERT INTO mbu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Acemani ka, ida, banggia wia ama a nda mǝkyauwem; sǝ atàcau mò ka à nǝ̀ ɗekiǎm nǝ yilǝmu sǝ à nǝ̀ pakkam mǝɓoarne.>> ");
INSERT INTO mbu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Lang Ibǝram yina aɓa nzali Masar ka, amǝ Masar sǝn Sarayi ka ɓwama nggea mǝɓoarnsari na. ");
INSERT INTO mbu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lang amǝ tamurǝm Masar sǝni ka, à kya bang cau mala ɓoarnsari male aban Firona, murǝm malea. Nda à yiu à yi twal Sarayi à umnǝi a ɓala-murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Murǝm pakki Ibǝram mǝɓoarne atàcau mala Sarayi; pè Ibǝram anzur, andá, adambǝritso jamne andǝ amamǝne, amǝ'túró-ɓala aburana andǝ amamǝna, andǝ akalakadambi. ");
INSERT INTO mbu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sǝ acemǝnana murǝm Firona twal Sarayi, mālá Ibǝram ngga, Mǝtalabangŋo tasǝ nggea kwánó mǝɓike amur murǝm Firona andǝ amǝɓala male. ");
INSERT INTO mbu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Acemani ka, murǝm Firona túrban à tunǝ Ibǝram, sǝ banggi wi ama, <<Mana mǝnia a pakkam ngga? Mana tsǝa sǝ a ɓinǝ banggàm ama yi ka māmó na. ");
INSERT INTO mbu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Palang sǝ a bang ama yi ka mǝ'kyauweo na, sǝ mǝno ka tsǝa ǝn twali ɓǝ̀ duk māmám? Ado ka māmó nya ka. Twali sǝ wu o!>> ");
INSERT INTO mbu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pǝlǝa murǝm Firona tasǝ aburana male nǝ cau amur Ibǝram, sǝ à kya pusǝì purî ɓá nzali Masar, yì andǝ māmí andǝ koman mana kat male na ka. ");
INSERT INTO mbu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Acemǝno ka, Ibǝram loapi Nzali Masar sǝ nyare a Negev. Twal māmí andǝ agirkuma male kat atè. Lotu gbal ka o atè. ");
INSERT INTO mbu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibǝram ngga mǝkume na kǝ̀rkǝ́r. Ndanǝ adomwan mala agirkusǝu, andǝ azǝrfa andǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Twal gya kǝ turkio arǝ aban bǝti-bǝti, lo a Negev yi pur a Betel. Yi bik ban mǝnana tsǝk gumli male sǝ duk kàm a tadǝmbe a nre Betel andǝ Ai ka. ");
INSERT INTO mbu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mǝnia ka nda ban mǝnana Ibǝram ɓak gyangŋan kàm a nggea dǝmbe, sǝ peri aban Mǝtalabangŋo ka. ");
INSERT INTO mbu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lotu mǝnana o atà Ibǝram ngga, ndanǝ anzur andǝ ambulpǝndǝa, andǝ agumli. ");
INSERT INTO mbu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Sǝ acemǝnana à ndanǝ agirkusǝu kǝ̀rkǝ́r ka, nzali yál agir karǝia mǝnana yia ɓari à nǝ̀ do abanarǝia ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nda kúnɓuàna lo a nre ka ayálgír mala Ibǝram andǝa mala Lotu ka. (A mǝno yì bàkú ka, amǝ'Kan'ana andǝ amǝ'Periz na kam gbal a kǝ nzali mǝno nǝdo.) ");
INSERT INTO mbu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Pǝlǝa Ibǝram ne Lotu ama, <<Ən nggǝ zǝmbô, kúnɓuana ɓǝ kǝa lo a nre sǝm, ko a nre ka ayálgír mò andǝ amem ɗàng, acemǝnana sǝm nda mwashat. ");
INSERT INTO mbu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nggea nzali mǝnia kat ka pà mbak a ɓadǝmbo? Ida, ɓǝ̀ sǝm gapita rǝ sǝm. Twal buì mǝnana a earce ka, ɓǝ̀ sǝm gauwa. Ɓǝ̀ a o nǝ bu mǝ'nggare ka, mǝ nǝ um nǝ bu mǝlì, sǝ ɓǝ̀ a nǝ u gbal nǝ bu mǝlì ka, mǝ nǝ o nǝ bu mǝ'nggare.>> ");
INSERT INTO mbu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lotu loasǝ mǝsǝì sǝn nzali mana kàrì ɓangŋaban kún Mur Jodan kya pur a Zowar, sǝ sǝni ka, nzali na mǝnana kǝ kum mùr pepè ka, kǝla nzali ɓaban mala anggun mala Mǝtalabangŋo, ko kǝla nzali Masar. (Anggo ka Mǝtalabangŋo malaká kiɗiki Sodom andǝ Gomora ɗàng.) ");
INSERT INTO mbu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Pǝlǝa Lotu twal ɓangŋaban nzali kún Mur Jodan ace ɓamúrì, sǝ bwal njargula o nǝ njar-takuli. Anggo sǝ Lotu gapitarǝia andǝ kine Ibǝram. ");
INSERT INTO mbu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibǝram do a kǝ nzali Kan'ana, sǝ Lotu ka tùro kya do aɓalǝ anggea-là mala dulum, tsǝk agumli male duk kam a nkanggari Sodom. ");
INSERT INTO mbu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sǝ amǝ Sodom ngga, amǝ'ɓealɓikea na kǝ̀rkǝ́r (à kǝ pakki Mǝtalabangŋo cauɓikea ko aya pwari.) ");
INSERT INTO mbu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Anzǝm mana Lotu nyìngŋǝ̀nà Ibǝram ngga, Mǝtalabangŋo ne Ibǝram ama, <<Loasǝ mǝsǝo pé a kǝ ban mana a cam kam ngga, sǝnban kàrìban; sǝn njar-nza, sǝn njar-kunmur, sǝn njar-takuli, sǝ wu sǝn njar-nzali. ");
INSERT INTO mbu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nzali mǝnana kat mǝsǝo gandǝ sǝne ka, mǝ nǝ po wi, we wunǝ amunio andǝ amǝ'keò bà, málá male pà kàm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mǝ nǝ tsǝk amunio andǝ amǝ'keò à nǝ̀ làkkì kǝla mǝsǝsala mana a nzali ka. Ɓǝ̀ kǝ ɓwa nǝ̀ gandǝ ɓal làkkì mala mǝsǝsala mǝnana a nzali ka, ɓwe nǝ̀ gandǝ ɓal amunio andǝ amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lo, gya aɓa sauwa mala nzali andǝ tangŋa male, acemǝnana mǝ nǝ po wi.>> ");
INSERT INTO mbu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Pǝlǝa Ibǝram o kya tsǝk agumli male do aban anggun mǝgulke mala Mamǝre, mǝnana a Hebǝron ngga. Akanó sǝ kya ɓakki Mǝtalabangŋo gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","A bàkú mǝno ka lwa yi lo a nre ka nzali mala buban mǝno. Amrafel murǝm nzali Shinar, Ariyok murǝm nzali Elasa, Kedolaoma murǝm nzali Elam, andǝ Tidal murǝm nzali Goyim ");
INSERT INTO mbu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","à dapi à oa munǝo arǝ Bera murǝm nzali Sodom, Birsha murǝm nzali Gomora, Shinap murǝm nzali Adǝma, Shemeba murǝm nzali Zeboyim, andǝ murǝm nzali Bela (mana à tunǝi ama nzali Zowar ka). ");
INSERT INTO mbu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Amurǝma mǝnia tongno nǝnzǝ́mò andǝ amǝ'lwa malea ka à yi ramba a Dulum mala Sidim (mana à tunǝi ama Nggeamùr Tuɓamur ka). ");
INSERT INTO mbu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Amǝnia yì amurǝma ka à pak pǝlǝa lum-nong-ɓari à nda ɓata parban mala Murǝm Kedolaoma, sǝama a lum-nong-tàruià pǝlǝa ka à mgbicau arǝì. ");
INSERT INTO mbu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A lum-nong-inea pǝlǝa ka Murǝm Kedolaoma andǝ amurǝma mǝnana atè ka, à yiu nǝ amǝ'lwa malea à yì soa munǝo arǝ amǝ'Refa mala nzali Ashterot-Karnem, amǝ'Zuz mala nzali Ham, amǝ'Emit mala nzali Shave-Kiriatem, ");
INSERT INTO mbu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","andǝ amǝ'Hor mala Seyir, nzali múr ankono, sǝ à gandǝia aban ká ɗār a El-paran, ɓè ban a masǝlǝata pǝɗanban. ");
INSERT INTO mbu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Pǝlǝa à wulio à yiu a nggea-là Kadesh (mana à tunǝi ama En-Mishpat ka). À lì nzali mala amǝ'Amalek kat nǝ lwa sǝ à gandǝ amǝ'Amor mǝnana à ndanǝdo a là Hazazon-Tamar ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pǝlǝa amurǝma mala anzali Sodom, Gomora, Adǝma, Zebo, andǝ Bela (mana à tunǝi ama Zowar ka) andǝ amǝ'lwa malea kat puro à yi ram rǝia ace lwa a Dulum mala Sidim. ");
INSERT INTO mbu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","À soa munǝo arǝ Kedolaoma murǝm nzali Elam, Tidal murǝm nzali Goyim, Amrafel murǝm nzali Shinar andǝ Ariyok murǝm nzali Elasa, yia andǝ amǝ'lwa malea kat. Amurǝma ine arǝ tongno. ");
INSERT INTO mbu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ɓá Ɓangŋaban Sidim ngga lùmsǝ nǝ atūli kwalta pas. Lang amǝ'lwa mala amurǝma mala anzali Sodom andǝ Gomora ɓanggi munǝo ama à nǝ̀ u ka, à kya kpakia aɓalǝ atūli kwalta; acili amurǝma tàrú andǝ amǝ'lwa malea mǝnia munǝo gandǝia ka, à ɓangŋa à kya eaki amur ankono. ");
INSERT INTO mbu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Amǝ'lwa mala amurǝma man ine à limurǝm ngga, à pwan kume mala amǝ Sodom andǝ Gomora andǝ girlina malea kat; pǝlǝa à bwal njar à o. ");
INSERT INTO mbu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Mǝkina Ibǝram, yi Lotu mǝnana ndanǝdo a Sodom ngga, à pwan kume male gbal kat sǝ à bwali. ");
INSERT INTO mbu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ɓè ɓwa mǝnana apî kún munǝo ka, ɓangŋa yiu nǝ cau mǝnia ka aban Ibǝram ɓwa Ibǝru. Ibǝram ngga ndanǝdo a là-gumli male aban anggun mǝgulke mala Mamǝre ɓwa Amor. Mamǝre andǝ amǝ'eambi, yia Eshkol andǝ Aner ka, à kùrkún arǝia andǝ Ibǝram à nǝ̀ bwalia rǝia kàm arǝ aɓia-mǝbura ɓǝ̀ munǝo lo ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Lang Ibǝram ok ama mǝkine Lotu ka à bwalǝni ka, ramba aburana amǝtúró male gbǝman-tàrú nǝ lum-bwamdǝ-tongno-nong-tàrú 318 mǝnana à ɓǝlia a ɓala male, sǝ à kania wia lwa ka. Yì andǝia kat ka à lo pǝrta aɓia-mǝbura, yia amǝ'lwa mala Kedolaoma, sǝ à kya bwaltea kuko a njar-nza a bu-nzali Dan. ");
INSERT INTO mbu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","A ban mǝno ka Ibǝram gau amǝ'lwa male mbop-mbop. Lang dù pǝndǝna ka Ibǝram andǝ amǝ'lwa male yasǝlǝ aɓia-mǝbura nǝ munǝo arǝ anjar ɗàng-ɗáng sǝ à gandǝia. À mesǝia sǝ à pǝrtea kuko à kya bik Hoba, mǝnana nda a njar-nza mala nggea-là Damaska ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ibǝram ak agir mǝnana kat aɓwana mǝno pwania ka, sǝ nyesǝ mǝkine Lotu andǝ agirkuma male, atārǝia andǝ amamǝna andǝ acili aɓwana mǝnana aɓia-mǝbura bwalkia ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Lang Ibǝram nyarni limurǝm a lwa amur Kedolaoma andǝ amurǝma mana atè sǝ nda njar nǝ̀ o a là ka, murǝm Sodom puro wari a kúllè a Ɓangŋaban Shave (mǝnana à tunǝi gbal ama Ɓangŋaban mala Murǝm ngga). ");
INSERT INTO mbu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ɓè murǝm mǝnana à tunǝi ama Melkizedek, murǝm mala nggea-là Salem, yiu aban Ibǝram. Wari nǝì Ibǝram bǝredi andǝ múr ɓǝlanggun anap. Yì ka pǝris na mala Ɓakuli Mana Karban Kat nǝ Gulo ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tsǝki Ibǝram bu, kǝ bang ama, <<Ɓǝ̀ bu Ɓakuli Mana Karban Kat nǝ Gulo, yì mana pusǝ kùli andǝ nzali ka, do amur Ibǝram! ");
INSERT INTO mbu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ɓwangsǝban ɓǝ pa aban Ɓakuli Mana Karban Kat nǝ Gulo, mǝnana po limurǝm amur aɓio amǝbura ka.>> Pǝlǝa Ibǝram pè Melkizedek kāmbe mala agir mǝnana kat ea a bu aɓi-mǝbura a lwa ka. ");
INSERT INTO mbu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nǝ nzǝ́mò ka Murǝm Sodom banggi Ibǝram ama, <<Pam aɓwana mem mǝnana a amsǝia ka, sǝ agirkuma ka, umnǝia ɓǝà duk amô.>> ");
INSERT INTO mbu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Sǝ Ibǝram ngga earî murǝm Sodom ama, <<Ən loasǝ buam a kùli ǝn kánagìr aban Mǝtalabangŋo, Ɓakuli Mana Karban Kat nǝ Gulo ka, Mǝtala kùli andǝ nzali ");
INSERT INTO mbu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ama pà mǝ nǝ twal kǝgìr mǝnana mona ka ɗàng, ko ɓǝ̀ nkonggúr ko nggúr-nkura na ka. Anggo ka a pà nǝ gandǝ bang ama, <Mǝ nda mǝnana ǝn tsǝa sǝ Ibǝram pǝlǝ mǝgǝna ka> ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Pà mǝ nǝ ak kǝgìr ace ɓamúràm ɗàng she gìr mǝnana amǝ'lwa mem lì ka. Sǝama aburana mǝnana à dapi ɓamuria atàm a lwa mǝnia, yia Aner, Eshkol andǝ Mamǝre ka, ɓǝà pea wia kāmbe malea aɓa girkuma mǝnana à pwano a ban lwa ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Anzǝm mǝnia ka, Mǝtalabangŋo nacau nǝ Ibǝram aɓa sǝna ama: <<Ɓangciu ɓǝ̀ kǝa pakko ɗàng, Ibǝram, Mǝ nda ntongŋo mò, nggea tangnakusǝo mǝgule.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Sǝ Ibǝram na ama, <<Mǝtalabangŋo Ɓakuli, mana nda ɓoaro mala tangnakusǝu mò abanam, yì mǝnana ǝn panǝ muna raka, kǝ muna-ɓala mem Eliyeza, ɓwa Damaska na nǝ̀ liɓala mem ngga?>> ");
INSERT INTO mbu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ibǝram na ɗǝm ama, <<A pam amuna ɗang; acemani ka, mǝtúró-ɓala mǝnana à ɓǝli a ɓala mem ngga nda nǝ̀ liɓala mem ngga ra.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pǝlǝa cau mala Ɓakuli yiu a baní ama, <<Mǝnia yì ɓwa ka pà nǝ̀ liɓala mò ɗàng. Muna-ɓwabura mô mǝnana awu nǝ bǝl ka nda nǝ̀ liɓala mò ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mǝtalabangŋo pǝlǝa pusǝì a nza, sǝ ne wi ama, <<Loasǝ mǝsǝo a kùli pé, sǝ ɓal anlero ɓǝ̀ a nǝ gandǝì ka.>> Sǝ ne wi ama, <<Mǝno ka nda làkkì mala amunio andǝ amǝ'keò.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibǝram earnǝ Mǝtalabangŋo, sǝ Mǝtalabangŋo twali yì ka mǝɓealɓoarna na. ");
INSERT INTO mbu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nyar ɗǝm Mǝtalabangŋo ne wi ama, <<Mǝ nda Yahweh, mana pusǝo a purì ɓá nggea-là Ur a nzali mala amǝ'Chaldi ace po mǝnia yì nzali ɓǝ̀ duk girkuma mò ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Sǝ Ibǝram ɗì ama, <<Mǝtalabangŋo, Ɓakuli, lang sǝ mǝ nǝ sǝlǝ ama mǝnia yì nzali ka nǝ̀ duk girkuma mem?>> ");
INSERT INTO mbu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mǝtalabangŋo nyesǝi wi ama, <<Yinǝàm nǝ muna-ndá, andǝ muna-mbul, andǝ muna-gam, komǝye ka mbule tàrú, atārǝia andǝ kutugangyi andǝ muna-kutumurǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibǝram yinǝ agir mǝnia kat a baní, pǝlǝa komǝye ateà ka zanzǝi aɓalǝu ɓari, sǝ nongsǝ abare man a nkanggari arǝia. Sǝ mala anyal ka zanzǝia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Adǝkǝlaki yiu à yi sulǝo amur alúgir mǝnia à nǝ̀ lia sǝ Ibǝram pǝria. ");
INSERT INTO mbu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lang pwari na rǝ kpa ka, Ibǝram ko a nggea ntulo mǝlime, pǝlǝa ɓe pǝndǝa cikcik mǝpà ɓangciunì yi gir múrí. ");
INSERT INTO mbu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pǝlǝa Mǝtalabangŋo ne Ibǝram ama, <<Sǝlǝ fa ama amǝ'keò nǝ̀ nggá duk abǝri a ɓè nzali mǝnana malea na raka. Amǝ nzali mǝno nǝ̀ tsǝia à nǝ̀ duk aguro, à nǝ̀ paria aɓata tanni arǝ pǝlǝa gbǝman-ine (400). ");
INSERT INTO mbu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Sǝama mǝ nǝ lǝmdǝ ɓashi mem amur mǝno yì nzali nǝ̀ nggá dumsǝ aɓwana mô a guro ka. Nǝnzǝ́mò ka aɓwana mô nǝ̀ purî ɓá nzali mǝno, à nǝ̀ pur nǝ agirkuma mǝ'làkke a buia. ");
INSERT INTO mbu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sǝ we ka, ɓǝ̀ a ena ě mǝɓoarne mala akapana ka, sǝ a wúnǝ́ wu aɓa rǝpwala. À nǝ̀ tsǝkbaniò atà akeô. ");
INSERT INTO mbu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A inea nza mala do ɓanza mala amunio andǝ amǝ'keò ka, à nǝ̀ nyare à nǝ̀ yiu a nzali mǝnia ɗǝm. Mǝno ka pà nǝ̀ pa adyan ɗang acemǝnana cauɓikea mala amǝ'Amor malaká bik ban mǝnana nǝ̀ tsǝa mǝ nǝ tasǝ ɓashi mem amúrià ado ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lang pwari kpana sǝ ban bwalna ka, muna nkenye mana nǝ nkalang-bǝsa aɓalǝi kǝ loasǝ yele, andǝ ɓukan mana kǝ earki bǝsa ka, à yi puro sǝ à kùtí a nre ka anyama mǝnia à sangia ka. ");
INSERT INTO mbu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","A pwari mǝno ka Mǝtalabangŋo kùrcau nǝ Ibǝram ama, <<Mǝ nǝ pè amunio andǝ amǝ'keò nzali mǝnia, twal a kún myalmúr mala amǝ Masar aban ká kún nggeasala mǝgule, yi Yiufǝretis; ");
INSERT INTO mbu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","kat andǝ nzali mala amǝ'Ken, andǝ amǝ'Keniz, andǝ amǝ'Kadǝmon, ");
INSERT INTO mbu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","andǝ amǝ'Hitti, andǝ amǝ'Periz, andǝ amǝ'Refa, ");
INSERT INTO mbu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","andǝ amǝ'Amor, andǝ amǝ'Kan'ana, andǝ amǝ'Girgash, sǝ amǝ'Jebus.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi, mālá Ibǝram ngga, ɓǝlî wi kǝ muna ɗang. Sǝama yì ka ndanǝ muna-ɓwama mǝ'bwali wi túró a ɓala, ɓwama Masar na, lùllǝì ama, Hajara. ");
INSERT INTO mbu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Acemani ka, Sarayi ne Ibǝram ama, <<Sǝni, Mǝtalabangŋo gìrnam nǝ ɓǝlmuna. Ida kyane, kúti atà muna-ɓala mem, yakǝla mǝ nǝ kum amuna nǝ njarbaní.>> Ibǝram pǝlǝa ear nǝ cau mana Sarayi ne wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Anzǝm mana Ibǝram dumǝna pǝlǝa lum a nzali Kan'ana ka, Sarayi twal Hajara, muna-ɓala male, ɓwa Masar, sǝ pè burí Ibǝram, ɓǝ̀ duk māmí. ");
INSERT INTO mbu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ibǝram kùtí atà Hajara, sǝ kum muna a bumi. Lang Hajara sǝni muna kpana a bumi ka, tita būrǝce Sarayi mǝtala-ɓala male. ");
INSERT INTO mbu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi pǝlǝa ne Ibǝram ama, <<A nda a yinǝ mǝnia yì ɓǝsǝkiban ǝn nggǝ kumi ka amuram. Ən twal muna-ɓala mem ǝn po wu pak-ɓwama nǝi, sǝ lang yi sǝni kumna muna a bumi ka, kǝ nyesǝcem-ɓà. Ɓǝ̀ Mǝtalabangŋo pak ɓashi a nre sǝm sǝnǝ we.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Pǝlǝa Ibǝram ne wi ama, <<Yì ka mǝguro mò na aɓata rǝcandǝa mò. Pang nǝi kǝla mǝnana a sǝni nda ɓoaro kutibanì ka.>> Pǝlǝa Sarayi kùtí a ɓìkî Hajara nǝ patanni, nda Hajara ɓangŋa o nying ɓala ka. ");
INSERT INTO mbu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mǝturonjar mala Mǝtalabangŋo kum Hajara tù a ban ɓe mgbeɗe mùr aɓa pǝɗanban a njenza; mǝno ka nda mgbeɗe mùr mǝnana a gírí njargula ká a Shur ka. ");
INSERT INTO mbu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ne wi ama, <<Hajara, mǝguro mala Sarayi, a pur ake, sǝ a nǝ ká ake?>> Eari wi ama, <<Mǝ nda aban ɓangŋa mǝ nǝ upi ban Mǝtala-ɓala mem, Sarayi.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pǝlǝa Mǝturonjar mala Mǝtalabangŋo banggi wi ama, <<Nyare aban mǝtala-ɓala mò, kya pa ɓamuro aɓata rǝcandǝa male.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mǝturonjar mala Mǝtalabangŋo lidǝmba nǝ cau ama, <<Mǝ nǝ hatǝki amunio andǝ amǝ'keò, yàle làkkì malea ka kǝ ɓwa pà nǝ̀ gandǝ ɓallia ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mǝturonjar mala Mǝtalabangŋo ne wi ɗǝm ama, <<We ka a ndanǝ muna a bumo ado, sǝ awu nǝ ɓǝl muna-ɓwabura. Awu nǝ tsǝki wi lullǝ ama Ishmayel, acemǝnana Mǝtalabangŋo ongŋǝna ɓua andǝ pǝ́lǝ́kí nǝ ɓalǝu mô. ");
INSERT INTO mbu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Yì ka nǝ̀ pa kǝla mǝdambǝriso bondo; nǝ̀ do nǝ bumɓikea arǝ koya ɓwa, sǝ koya ɓwa ka nǝ̀ do nǝ bumɓikea arǝì. Nǝ̀ ɓìkìdo aban aɓǝla male kat.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Acemani ka Hajara pe Mǝtalabangŋo man bangcau nǝi ka lullǝu ama: El Roi; yì ka bang ama, <<Ən sǝna Ɓwa mǝnana sǝngiyiam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nda gìr mǝnana tsǝa sǝ à tunǝ tūli-mùr mǝno ka ama <<Biya-Lahai-Royi.>> Tūli-mùrnî nakam yalung a nre Kadesh andǝ Bered. ");
INSERT INTO mbu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajara yi ɓǝlì Ibǝram muna-ɓwabura, sǝ Ibǝram tsǝki muna lullǝu ama Ishmayel. ");
INSERT INTO mbu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ibǝram adyan ngga ndanǝ apǝlǝa lumi-tongno-nong-tàrú bwamdǝ tongno-nong-mwashat 86 mana Hajara ɓǝlì wi Ishmayel ka. ");
INSERT INTO mbu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Lang Ibǝram bwalǝna apǝlǝa lumi-tongno-nong-ine bwamdǝ tongno-nong-ine (99) ka, Mǝtalabangŋo pusǝrǝi a baní sǝ ne wi ama, <<Mǝ nda Ɓakuli mana Karban Kat ne Gulo ka; kpata njar mem koya pwari, sǝ wu dukdo ɗwanyicau-arǝǔ. ");
INSERT INTO mbu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mǝ nǝ tsǝk kùrcau mem mǝnana a nrem sǝm nǝ we ka ɓǝ̀ yi lumsǝo, sǝ mǝ nǝ po amuna andǝ amǝkau à nǝ̀ làkkì pas.>> ");
INSERT INTO mbu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ibǝram kùndǝó nǝ ɓamǝsǝi a nzali. Pǝlǝa Ɓakuli ne wi ama, ");
INSERT INTO mbu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<Mǝnia ka nda kùrcau mem mana sǝm nǝ we ka: Awu nǝ duk tár akún pas. ");
INSERT INTO mbu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","À pà nǝ̀ tunǝo ɗǝm ama Ibǝram ɗàng, lùllǝò adyan ngga nda Ibǝrayim, acemǝnana ǝn tsǝ́ngŋǝ̀nó a nda tár akún pas. ");
INSERT INTO mbu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mǝ nǝ tsǝo awu nǝ sa kǝ̀rkǝ́r. Amunio andǝ amǝ'keò nǝ̀ duk akún pas, amurǝma nǝ̀ pur a tàu mò. ");
INSERT INTO mbu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mǝ nǝ tsǝk mǝnia yì kùrcau ka nǝ̀ do bà a nre sǝm, sǝm nǝ we, andǝ amunio, andǝ amǝ'keò, andǝ amǝnana à kǝ yiu a nzǝmia ka. Mǝ nǝ duk Ɓakuli mò andǝ malea. ");
INSERT INTO mbu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nzali Kan'ana mǝnana kat ado a ndakam kǝla bǝri ka, mǝ nǝ pò wi, wunǝ amunio atò, ace mǝnana ɓǝ̀ duk girkuma mala ɓala mò bà. Mǝ nǝ duk Ɓakuli malea.>> ");
INSERT INTO mbu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ɓakuli pǝlǝa ne Ibǝrayim ama, <<Mò ado ka, nda mǝnana ama wu kpata mǝnia yì kùrcau ka, we wunǝ amunio andǝ amǝ'keò, andǝ amǝnana à malaká ɓǝlia raka. ");
INSERT INTO mbu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mǝnia ka nda kùrcau mem sǝnǝ we andǝ amunio andǝ amǝ'keò, kùrcau mǝnana wun nǝ̀ kpate ka: Koya ɓwabura atà wun ngga à nǝ̀ kasǝî wi ɓate. ");
INSERT INTO mbu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nggú mǝnana a kun ɓatau wun ngga, à nǝ̀ kasǝì. Mǝnia ka nda nǝ̀ lǝmdǝ ama kùrcau nakam a nre sǝm, sǝnǝ awun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Twal ado aban ká arǝ anza ma'wun mǝnana kat à nǝ̀ yiu ka, koya muna-ɓwabura mǝnana à ɓǝli sǝ bingŋǝna nongŋo tongno-nong-tàrú ka, dumǝna púp à nǝ̀ kasǝî wi ɓate. Mǝnia yì nzongcau ka pà ace amǝ'ɓala mò nǝmurǝia ɗàng, nda gbal ace amǝ'ɓala mala aguro mǝnana à ɓǝlia a ɓala mò, andǝ mala aguro mǝnana à kúria nǝ boalo a bù ɓwa kúnɗàngna mǝnana pà a tàu mò raka. ");
INSERT INTO mbu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Koyan kat ateà ka dumǝna púp à nǝ̀ kasǝî wi ɓate, ko à ɓǝl ɓwe a ɓala mò ko à kúrí nǝ boalo. Kasǝ-ɓatau ka nǝ̀ do nda gìr'lǝmdǝa ngguont a nggūrǝ wun mala kùrcau mem nǝ wun, mǝnana málá male pà kàm raka. ");
INSERT INTO mbu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Koya ɓwabura mǝnana à kasǝî wi ɓate ɗàng, sǝ ɓinǝ kasǝ ɓate ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana mem ɗǝm ɗàng, acemǝnana, yì ka mgbinakiru arǝ kùrcau mem. ");
INSERT INTO mbu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ɓakuli nyare ne Ibǝrayim ama, <<Mala māmó Sarayi ka, à pà nǝ̀ nggǝ tunǝi ɗǝm ama Sarayi ɗàng. Twal ado aban ká dǝmba ka lùllǝì nda Saratu. ");
INSERT INTO mbu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mǝ nǝ tsǝki wi bu, sǝ mǝ nǝ pò muna-ɓwabura nǝ kǝ buì. Mǝ nǝ tsǝki wi bu, ace mǝnana ɓǝ̀ duk nggeau mala akún pas. Amurǝma pas à nǝ̀ pur nǝ baní.>> ");
INSERT INTO mbu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pǝlǝa Ibǝrayim kùndǝó nǝ ɓamǝsǝi a nzali; oalo sǝ ne ɓamúrì ama, <<Ɓwa mǝnana ndanǝ apǝlǝa lumi-lum ngga nǝ̀ ɓǝl muna le? Sǝ nggearǝ Saratu ka, nǝ̀ ɓǝl muna le, yì mǝnana ndanǝ apǝlǝa lumi-tongno-nong-ine ka?>> ");
INSERT INTO mbu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibǝrayim ne Ɓakuli ama, <<Mǝnia yì tsǝkbu ɓǝ̀ do mala Ishmayel!>> ");
INSERT INTO mbu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Pǝlǝa Ɓakuli ne wi ama, <<Awo, nggearǝ māmó Saratu nǝ̀ ɓǝ̀lô muna-ɓwabura, sǝ awu nǝ tsǝki wi lullǝu ama Ishaku. Mǝ nǝ tamsǝkusǝ kùrcau mem sǝm nǝi, kùrcau mǝnana pà nǝ̀ mal raka, ace yì andǝ amuni andǝ amǝkè mana a nzǝmi ka. ");
INSERT INTO mbu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sǝ mala Ishmayel gbal ka, ǝn ongŋǝno. Ɓafo mǝ nǝ tsǝki wi bu; mǝ nǝ tsǝì nǝ̀ ɓǝla, nǝ̀ hatǝki kǝ̀rkǝ́r. Nǝ̀ duk tár amurǝma lum-nong-ɓari, sǝ mǝ nǝ tsǝì nǝ̀ do nǝ nzali mǝgule. ");
INSERT INTO mbu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Sǝama kùrcau mem ngga mǝ nǝ tamsǝkusǝi nǝ múr Ishaku, mǝnana Saratu nǝ̀ ɓǝ̀lô wi a kúnì ani a pǝlǝa mǝno kǝ yiu ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lang Ɓakuli malna nacau nǝ Ibǝrayim ngga, o nying Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Akǝ mǝno yì pwari ka, Ibǝrayim twal muni Ishmayel andǝ koya ɓwabura andǝ muna-ɓwabura mǝnana à ɓǝli a ɓala male, andǝ mǝnana à kúrí nǝ boalo ka, sǝ kasǝî koyan ateà ka ɓate, kǝla mǝnana Ɓakuli banggi wi ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibǝrayim ngga ndanǝ pǝlǝa lumi-tongno-nong-ine bwamdǝ tongno-nong-ine (99) sǝ à kasǝî wi ɓate. ");
INSERT INTO mbu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmayel ka ndanǝ pǝlǝa lum-nong-tàrú sǝ Ibǝrayim kasǝî wi ɓate. ");
INSERT INTO mbu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ibǝrayim andǝ muni Ishmayel yia kǝm ngga à kasǝia wia ɓatea akǝ mǝno yì pwari mǝmwashati. ");
INSERT INTO mbu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Aburana andǝ amuna-burana a ɓala mala Ibǝrayim kat, amǝnana à ɓǝlia a ɓala male andǝ amǝnana à kúria nǝ boalo a bù bǝri ka, yia kat à kasǝia wia ɓatea atà Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mǝtalabangŋo nyare pusǝrǝi aban Ibǝrayim a là-gumli male mana a ban anggun mǝgulke mala Mamǝre ka. Ɓè pwari, nǝ pwarizǝkya, Ibǝrayim na ban do a kún ndà-gumli male. ");
INSERT INTO mbu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Loasǝ mǝsǝi ka sǝn aburana tàrú aban came tù a ban mǝno. Lang sǝnia ka, pǝlǝa loapi kún ndà-gumli male akaurǝa wari abania nǝ̀ gingsǝia. Kùndǝ nǝ ɓamǝsǝi a nzali makkia wia kún. ");
INSERT INTO mbu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Bang cau nǝia ama, <<Wun aɓwana-mǝgule, ǝn nggǝ zǝmba wun, ɓǝ̀n kumǝna earmúrú a ban wun ngga, ida, wu kǝa kutiam wun nǝ̀ o sǝ wu kàr a ɓala mem, mim guro ma'wun ɗàng pé. ");
INSERT INTO mbu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ida, wu came mǝ yinǝa wun nǝ mùr wu lákkí akusǝ wun, sǝ wu usǝlǝo a tǝr nggun mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ɗǝm ngga mǝ nǝ yinǝa nǝ wun girlina bǝti ɓǝ̀ wu par ɓalǝ wun nǝi sǝ wu lidǝmbǝa nǝ gya ma'wun. Wu earâm mǝ pakka wun anggo acemǝnana wu yina akani abanam ngga.>> Pǝlǝa à nyesǝi wi ama, <<Sǝm pakko yàwá; sǝm earna, pa kǝla mǝnana a bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibǝrayim pǝlǝa ɓangŋa kúti aɓa ndà-gumli male sǝ banggi Saratu ama, <<Fà rǝo, ɗàrǝ́ muku mǝɓǝlke a muna-kwár tàrú, karkia wia nɗǝmo.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Anzǝm mǝnana nana anggo ka, pǝlǝa ɓangŋa wari a domwan kya bwal muna-ndá mǝ'nyane, mǝnana nyame nǝ̀ ɓǝlki amala shě ka, sǝ pè ɓè mǝtúró-ɓala male. Pǝlǝa mǝtúró-ɓala pwan-myali, sàngi nyami sǝ lambi akaurǝa. ");
INSERT INTO mbu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ibǝrayim pǝlǝa ɗàrǝ́ kiura mǝɓwal-ɓwali andǝ mǝbwale sǝ twal nyam muna-ndá mǝnana à lambi ka, yinǝia aban abǝri a tǝr nggun. Pea wia girline nǝ nggearǝì ɓǝà li, sǝ cam abania a tǝr nggun sǝ à kǝ lìli. ");
INSERT INTO mbu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Pǝlǝa à ɗì Ibǝrayim ama, <<Māmó Saratu ka nda ake?>> Earia wia ama, <<Nda aɓa gumli.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ɓwamǝgule malea bang cau ama, <<A bàkú mǝnia mala pǝlǝa mǝnana kǝ yiu ka, mǝ nǝ nyare mǝ yiu, sǝ māmó Saratu ka, nǝ̀ kum muna-ɓwabura.>> Saratu ka nda a nzǝmi a kún gumli aban kwakikiri arǝ cau. ");
INSERT INTO mbu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibǝrayim andǝ Saratu ka à ena kǝ̀rkǝ́r, sǝ yàle Saratu ka bumkwana kasǝni wi. ");
INSERT INTO mbu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nda Saratu oalo a ɓabumi kǝ ne ɓamurì ama, <<Mim mǝnana ǝn pǝlǝna ɓwagula ka, lang sǝ mǝ nǝ ok banɓoarna mala nongnǝban ɗǝm? Sǝ mǝno ka nda nǝmurǝì ɗàng, nggearǝ mǝtala-ɓala mem yì burém ngga ena gbal.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pǝlǝa Mǝtalabangŋo ɗì Ibǝrayim ama, <<Palang sǝ Saratu oalo sǝ bang ama kǝ sǝni kǝla pà nǝ̀ gandǝ ɓǝl muna ado mǝnana ena ka ɗàng? ");
INSERT INTO mbu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kǝgir kàm kwan kǝ̀rkǝ́r mǝnana Mǝtalabangŋo pà nǝ̀ gandǝ pe raka le? Kǝla mǝnana ǝn na ka, a kàra mala pǝlǝa ka, mǝ nǝ nyare mǝ yiu, sǝ Saratu ka, nǝ̀ ɓǝl muna-ɓwabura.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saratu ka ɓangciu pakki wi, nda na nyir bang ama, <<Ən oal ɗang.>> Sǝ Mǝtalabangŋo na ama, <<E, a oalo.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pǝlǝa aburana mǝno lo à nǝ̀ o. À tsǝk múrià aban ká a ban mǝnana à nǝ̀ gandǝ dili mǝsǝia kàm à nǝ̀ sǝn nggea-là Sodom ngga. Ibǝrayim wari andǝia nǝ̀ tsǝkteà a njargula. ");
INSERT INTO mbu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pǝlǝa Mǝtalabangŋo bang ama, <<Mǝ nǝ sǝmbǝrǝì Ibǝrayim gìr mǝnana ǝn nggǝ ká pě ka le? ");
INSERT INTO mbu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Aɓwapǝndǝa a tàu mala Ibǝrayim ngga mbak-kàngkàng à nǝ̀ làkkì kǝ̀rkǝ́r, à nǝ̀ nggá duk nzali mǝgule, sǝ acili anzali ɓanza kat ka à nǝ̀ kum tsǝkbu nǝ baní. ");
INSERT INTO mbu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ən tarni aɓalǝ aɓwana ace mǝnana ɓǝ̀ tsǝk amuni andǝ amǝkè kat a njar ɓǝà okam, ɓǝà kasǝ ɓashi a njari sǝ ɓǝà pè aɓa kpata mǝsǝcau. Anggo ka sǝ mǝ nǝ pakki Ibǝrayim agir mǝnana kat ǝn pacau acea ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Pǝlǝa Mǝtalabangŋo ne Ibǝrayim ama, <<Ən ongŋǝna ɓua mala aɓwana arǝ atúró ɓealɓikea mǝkǝ̀rkǝ́rnì mala amǝ Sodom andǝ amǝ Gomora. Acauɓikea malea ɓikipa. ");
INSERT INTO mbu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mǝ nǝ nggá sǝni ko gìr mǝnana à pè ka ɓike male kārǝa arǝ ɓua mala aɓwana amúrià mǝnana yiu abanam ngga. Ɓǝ̀ pa anggo raka, mǝ nǝ sǝlǝa.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pǝlǝa ɓari atà aburana mǝnia bwal njar aban o nǝ njar ban Sodom, sǝ Ibǝrayim ngga ueo aban came a ɓadǝm Mǝtalabangŋo. ");
INSERT INTO mbu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibǝrayim pǝlǝa sung tù a ban Mǝtalabangŋo sǝ ɗì ama, <<Ɓafo awu nǝ dapi amǝ'ɓealɓoarna andǝ amǝ'ɓealɓikea a nǝ twaltea le? ");
INSERT INTO mbu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ɓǝ̀ amǝ'ɓealɓoarna nakam lumi-tongno aɓa nggea-lê ka, a nǝ kìɗikì le? A pà nǝ twalbanì atàcau mala amǝ'ɓealɓoarna mǝnia lumi-tongno aɓalǝi ka ɗàng? ");
INSERT INTO mbu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mǝno ka ɓǝ̀ sappi bano, we murǝmɓashi amur koyan kat a ɓanza, mǝnana ɓǝà bang ama awu nǝ wal-lú amǝ'ɓealɓoarna atà amǝ'ɓealɓikea, sǝ a nǝ pangnǝ amǝ'ɓealɓoarna a njar mǝmwashati kǝla mǝnana awu nǝ pangnǝ amǝ'ɓealɓikea ka. A pà wunǝ pè ɗàng acemǝnana we mana a nda murǝmɓashi amur koyan kat a ɓanza ka, a nǝ pàk gìr mǝnana nda a njarì ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mǝtalabangŋo bang ama, <<Ɓǝ̀n kum aɓwana amǝ'ɓealɓoarna lumi-tongno aɓa nggea-là Sodom ngga, pà mǝ nǝ kìɗikì ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pǝlǝa Ibǝrayim nacau ɗǝm ama, <<Ida twàlâm-ban mǝsǝcandǝa mem mala lidǝmba nǝ nacau nǝ we Mǝtalabangŋo, acemǝnana mǝ nda nzali andǝ tú. ");
INSERT INTO mbu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ɓǝà bang ama amǝ'ɓealɓoarna nakam lumi-ine bwamdǝ tongno aɓa nggea-là Sodom ngga, awu nǝ kìɗikì acemǝnana kǝ à ndo lumi-ine bwamdǝ tongno ka le?>> Mǝtalabangŋo eari wi ama, <<Pà mǝ nǝ kìɗikì nggea-lê ɗàng ɓǝ̀n kum amǝ'ɓealɓoarna lumi-ine bwamdǝ tongno aɓalǝi ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibǝrayim nyare ne wi cau ɗǝm ama, <<Yakǝla à nǝ̀ kum amǝ'ɓealɓoarna lumi-ine aɓalǝi ka, awu nǝ kìɗikì le?>> Mǝtalabangŋo nyesǝi wi ama, <<Pà mǝ nǝ kìɗikì ɗàng atàcau mala amǝ'ɓealɓoarna lumi-ine aɓalǝi.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pǝlǝa Ibǝrayim bang ama, <<Cè bum Mǝtalabangŋo lúllô arǝàm ɗàng, ida earâm mǝ nacau ɗǝm. Ɓǝ̀ amǝ'ɓealɓoarna nakam lumi-tàrú aɓa nggea-lê ka, awu nǝ nggaɗi bumo arǝ kiɗikè le?>> Mǝtalabangŋo eare ama, <<Pà mǝ nǝ kìɗikì ɗàng ɓǝ̀n kum amǝ'ɓealɓoarna kam lumi-tàrú ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibǝrayim bang ama, <<Ida, mǝno ado ǝn pángŋǝ̀nà nǝ mǝsǝkang-kangŋa mǝ nô cau ka, Mǝtalabangŋo, ɓǝ̀ ndo ama lumi-ɓari na nǝmurǝì à nǝ̀ kum kam ngga, mana a nǝ pa?>> Mǝtalabangŋo na ama, <<Pà mǝ nǝ kìɗikì ɗàng ɓǝ̀n kum lumi-ɓari ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibǝrayim bang ama, <<Ɓǝ̀ bum Mǝtalabangŋo ɓǝ̀ kǝa lúllô arǝàm ɗàng. Ida, earâm mǝ nacau ɗǝm kusǝ mwashat. Mana awu nǝ pa ɓǝà kum amǝ'ɓealɓoarna sǝ kǝ à ndo lum kam ngga?>> Mǝtalabangŋo eari wi ama, <<Pà mǝ nǝ kìɗikì ɗàng atàcau mala aɓwana mǝno lum ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ibǝrayim nyare nacau ɗǝm ɗàng, sǝ lang Mǝtalabangŋo malna nacau nǝ Ibǝrayim ngga, pǝlǝa o, sǝ Ibǝrayim nyare a ɓala. ");
INSERT INTO mbu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Amǝturonjar mǝno ɓari yiu a Sodom nǝ pwarikpǝra. À yi kum Lotu aban do a kún nggea-là. Lang sǝnia ka, lo akaurǝa wari abania, ɓunno a nzali makkia wia kún. ");
INSERT INTO mbu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Banggia wia ama, <<Wun aɓwana-mǝgule, ida wu kàr a ɓala mem, wu lákkí akusǝ wun sǝ wu nongŋo. Ɓǝ̀ banfana ka, wun nǝ̀ gandǝ bwal njar nǝ dǝmbari ɗiɗyal wun nǝ̀ uki a o ma'wun.>> À bang ama, <<Awo, sǝm ngga sǝm nǝ̀ nongŋo a ban-kpapí mala nggea-là a kún limo.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Sǝ Lotu ka pìtea, camarǝ ɓuaki arǝia ɓǝà yi nongŋo a ɓala male. Pǝlǝa à eare à wari atè a ɓala male. Kya tsǝk amǝ'túró-ɓala male à pakkia wia girlina mǝɓoarne sǝ à lurǝia wia bǝredi, pǝlǝa à li. ");
INSERT INTO mbu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kaniama abǝri man nǝ̀ o a ndà ka, aburana purkio a koya bareban mala nggea-là Sodom, alo-ɓwa andǝ aɓwana-mǝgule kat, à yì kārì ɓala mala Lotu. ");
INSERT INTO mbu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","À tunǝ Lotu nǝ nza sǝ à ɗiban ama, <<Aburana mǝnana à yiu à yi sulǝo a ɓala mò nǝ pwarikpǝra man yalung ngga, à ndake? Pusǝa sǝmia ace mǝnana ɓǝ̀ sǝm nongnǝia ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lotu puro wari abania a nza pǝlǝa gìr kunkurǝm a nzǝmi ");
INSERT INTO mbu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","sǝ banggia wia ama, <<Wun aɓiam, ǝn nggǝ zǝmba wun, wu kǝa pàk mǝnia yì túró mǝɓike ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wu sǝni, mǝ ndanǝ amunem amuna-mamǝna ɓari mǝnana à malaká súrǝ̀ ɓwabura raka. Ən nggǝ zǝmba wun, wu came mǝ nǝ yinǝà wun nǝia a nza, sǝ wun nǝ̀ gandǝ pangnǝia kǝla mǝnana wu earce ka. Sǝ mala aburana mǝnia ka, wu kǝa jea ɗàng, acemǝnana yia ka, abǝri na mǝnana à yiu abanam, sǝ à nda aɓata yálban mala ɓala mem ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","À sà'arǝì ama, <<Nyara sǝm anggo!>> Pǝlǝa à bang ama, <<Mǝnia yì ɓwa ka yiu kǝla bǝri a nzali ma'sǝm, sǝ ado ka kǝ earce ama nǝ̀ duk ɓwamǝgule amur sǝm, nǝ̀ kania sǝm gìr mǝnana ɓoaro ɓǝ̀ sǝm pàk ka! Nyingga sǝm njar, ɓǝ̀ ana raka sǝm nǝ̀ pakko gìr mǝnana nǝ̀ ɓike nǝ̀ kútì mǝnana sǝm nǝ̀ pangnǝia ka.>> Pǝlǝa à soa aban yiu arǝ Lotu, à yi nggiki ama à nǝ̀ ɓun kunkurǝm. ");
INSERT INTO mbu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Sǝ amǝturonjar mǝno aɓalǝi ka, à mǝn kunkurǝm, à bwal Lotu à nunni, à nyesǝi aɓa ɓala sǝ à gìr kunkurǝm. ");
INSERT INTO mbu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pǝlǝa à soapi aɓwana mǝno ntedu, alo-ɓwa andǝ aɓwana-mǝgule kat, yia mǝno a kunkurǝm a nza nǝ ɓala ka. Mǝsǝia gandǝ sǝnban mǝnana à nǝ̀ súrǝ̀ ban mǝnana kunkurǝm nakam ngga ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Amǝturonjar mǝno banggi Lotu ama, <<Ko a ndanǝ aɓea ɓǝla mò, ko amunio amuna-burana ko amuna-mamǝna, ko ankilo abura amunio, mǝnana à ndanǝ do a ban mǝnia ka? Yinǝia ɓǝà purî ɓá nggea-là mǝnia, ");
INSERT INTO mbu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","acemǝnana sǝm ndo sǝm nǝ̀ kìɗìki nggea-là mǝnia ka. Ɓua mala ɓwapǝndǝa aban Mǝtalabangŋo amur aɓwana mala nggea-là mǝnia ka gul kǝ̀rkǝ́r, nda tasǝ sǝm ɓǝ̀ sǝm yi kiɗikì ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Pǝlǝa Lotu puro wari aban ankili, aburana mǝnana à pur'amur amuna-mamǝna male ka. Banggia wia ama, <<Wu fà rǝ wun wu purî ɓá nggea-là mǝnia ka, acemǝnana Mǝtalabangŋo no nǝ̀ kìɗíkì ka!>> Sǝ yia ankili ka, à twali ama ndoro na pàkkiyi ka. ");
INSERT INTO mbu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lang ban na rǝ ká kwáró ka, amǝturonjar pîtà Lotu nǝ cau ama, <<Fà rǝo! Twal māmó andǝ amunio ɓari amuna-mamǝna mǝnana à ndakani a bano ka. Wu puro adyan wu o, ɓǝ̀ ana raka wun nǝ̀ ɗwanyi yilǝmi wun ɓǝ̀ à nǝ̀ sulǝ ɓashi amur nggea-là ka!>> ");
INSERT INTO mbu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lotu dǝndi kǝ pǝlǝki rǝì, nda amǝturonjar kpa garabui, andǝ garabu māmí, andǝ agarabu amuni ɓari amuna-mamǝna sǝ à nunnia à pusǝia ɓǝà purî ɓá nggea-là jam. Amǝturonjar pak mǝno ka acemǝnana Mǝtalabangŋo sǝn mǝsǝswatǝr mala Lotu andǝ amǝɓala male. ");
INSERT INTO mbu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Lang amǝturonjar pusǝnia à yina a nzǝm nggea-là ka, mwashat atà amǝturonjar banggia ama, <<Wu ɓangŋa ace amsǝ yilǝmi wun! Wu kǝa pǝlǝ mǝsǝ wun anzǝm wun, sǝ wu kǝa came àkǝ ban aɓa dulum ɗàng. Wu ɓang nǝ mire wu o amúr ankono, ɓǝ̀ ana raka wun nǝ̀ kìɗìkì!>> ");
INSERT INTO mbu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Sǝ Lotu ka bang ama, <<Awo, ɓwamǝgule, ida kǝa tsǝk sǝm ɓǝ̀ sǝm pàk mǝno ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Sǝni, mim guro mò ka, a lǝ́mdǝ́nàm earmúrú kǝ̀rkǝ́r sǝ a pàngŋǝ́nàm cauɓoarna mǝnana a amsǝ yilǝmem ngga. Sǝama pà mǝ nǝ gandǝ ɓangŋa aban ká a ban ankono ɗàng; kaniama mǝ nǝ bik ka, mǝnia yì gìr'mur'mwana ka nǝ̀ kumam a njar, sǝ mǝ nǝ wú. ");
INSERT INTO mbu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Sǝni, ɓè là nya kani tù mǝnana ɓwa nǝ̀ gandǝ ɓangŋa nǝ̀ ká kàm ngga. Ida, earâm ɓǝ̀n kyan nggam. Là mǝkyauwe na, sǝ a kàm ngga yilǝmem nǝ̀ kum àwá.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mǝturonjar eari wi ama, <<Ən earǝ́nò, pàk gìr mǝnana a zǝm ngga. Pà mǝ nǝ kìɗiki mǝno yì là a bangce ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sǝama fà rǝo! Ɓangŋa! Pà mǝ nǝ pàk kǝgir ɗàng sheɓǝ̀ a bingŋǝna banì ka.>> Acemani ka à tunǝ lullǝ lê ama Zowar. ");
INSERT INTO mbu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lang pwari na rǝ eau ka sǝ Lotu andǝ amǝɓala male yi bik Zowar. ");
INSERT INTO mbu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kara Mǝtalabangŋo nya mǝsǝtali-earbǝsa andǝ bǝsa amur anggea-là Sodom andǝ Gomora. Yì mǝsǝtali-earbǝsa ka pùr nǝban Mǝtalabangŋo a kùli. ");
INSERT INTO mbu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Anggo sǝ Mǝtalabangŋo kìɗìki anggea-là mǝno andǝ abân aɓa mǝno yì dulum ngga puppup, sǝ twalta aɓwapǝndǝa mǝnana kat aɓalǝ anggea-lê, andǝ koya girpwala mala nzali mǝno ka. ");
INSERT INTO mbu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Sǝ mālá Lotu mǝnana nda a nzǝm burí ka, pǝlǝ mǝsǝì sǝnban a nzǝmi, kara nggun-rǝì pǝlǝ tali tuɓamur aban came. ");
INSERT INTO mbu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Banfa nǝ dǝmbari ɗiɗyal ka Ibǝrayim puro wari a ban mǝnana cam kàm a tadǝmbe a ɓadǝm Mǝtalabangŋo ka. ");
INSERT INTO mbu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Dìlì mǝsǝì sǝnban nǝ njar Sodom andǝ Gomora andǝ nzali ɓá mǝno yì dulum ngga, sǝ sǝni ka, yele na aban lo amur nzali mǝno kat kǝla ɓá ndà-bǝsa. ");
INSERT INTO mbu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lang Ɓakuli kiɗiki anggea-là mala dulum mǝnana Lotu duk kam ngga, ɗenyinǝ zǝmba mala Ibǝrayim, pǝlǝa pusǝ Lotu ɓǝ̀ apî kìɗìkìban mǝnana yiu amur amǝno yì anggea-là ka. ");
INSERT INTO mbu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lotu ka ɓangciu pakki wi arǝ do a Zowar, pǝlǝa yì andǝ amuni ɓari amuna-mamǝna à tùro à kya do amur ankono, aɓa ɓè gumi-ɓa'tali. ");
INSERT INTO mbu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ɓè fara ka, muni mǝgule ne mǝkyauwe ama, <<Tár sǝm ngga ena, sǝ kǝ ɓwabura pa kàm kaní nǝ̀ kùtí aban sǝm, kǝla mǝnana aɓwana pàkkiyi a koya bân a ɓanza ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yiu ɓǝ̀ sǝm pè wi mùr-anap ɓǝ̀ nu ɓǝ̀ walì, sǝ sǝm nǝ̀ nongnǝi ace mǝnana ɓǝ̀ sǝm kum amuna, ɓǝ̀ tàu ma'sǝm nǝban tár sǝm ngga ɓǝ̀ kǝa kasǝ raka.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A dù mǝno ka à tsǝk tárrià nu mùr-anap kǝ̀rkǝ́r sǝ walì. Pǝlǝa muna mǝgule muna-ɓwama yiu yi nongnǝ tárrí. Sǝ yì tarrí ka súrǝ̀ bu-pwari mǝnana muni yi nongnǝi sǝ lo u ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Banfa nǝ dǝmbari ka, muna-ɓwama mǝgule banggi mǝkyauwe ama, <<Aɓa dù mǝnia kútí ka, ǝn warina ǝn nongŋǝna nǝ tár sǝm. A dù man yalung ngga, ɓǝ̀ sǝm pè wi mùr-anap ɗǝm ɓǝ̀ nu ɓǝ̀ walì, sǝ wu kyane wu kya nongnǝi. Anggo ka sǝm nǝ̀ kum amuna, ace mǝnana ɓǝ̀ tàu ma'sǝm nǝban tár sǝm ngga ɓǝ̀ kǝa kasǝ raka.>> ");
INSERT INTO mbu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nda à tsǝk tárrià nu mùr-anap walì a dù mǝno gbal, sǝ muni muna-ɓwama mǝkyauwe wario kya nongnǝi. Yì ɗǝm ngga sǝlǝce yiu mǝnana muni yi nongnǝi sǝ lo u ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Anggo sǝ amunà Lotu amuna-mamǝna yia kǝm à kum muna a bumia nǝban tárrià. ");
INSERT INTO mbu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Muni muna-ɓwama mǝgule ɓǝl muna-ɓwabura, sǝ tsǝki wi lullǝu ama Mowap; yì nda tár amǝ'Mowap ba yalung. ");
INSERT INTO mbu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Muni muna-ɓwama mǝkyauwe gbal ka ɓǝl muna-ɓwabura, sǝ tsǝki wi lullǝu ama Ben-Ami; yì nda tár amǝ'Amon ba yalung. ");
INSERT INTO mbu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Pǝlǝa Ibǝrayim tùro nying Mamǝre umnǝ Pǝɗanban Negev, sǝ kya do kǝla bǝri a ɓè ban à tunǝki ama Gera, a nre Kadesh andǝ Shur. ");
INSERT INTO mbu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ibǝrayim ne aɓwana mala là mǝno ama māmí Saratu ka, mǝ'eambi na. Nda Abimale, murǝm Gera, túrban à kya yinǝì wì nǝ Saratu a baní a palta male. ");
INSERT INTO mbu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Sǝama nǝ dù ka, Ɓakuli yiu aban Abimale aɓa lòrǝo sǝ ne wi ama, <<A nda lú ɓwa, acemǝnana ɓwama mana a twali ka, mā-ala na.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Sǝ Abimale ka malaká sungŋo abani peatu ɗàng, nda bang ama, <<Ɓakuli, awu nǝ twalta aɓwapǝndǝa mǝnana à pàk kǝ cauɓikea raka lè? ");
INSERT INTO mbu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ibǝrayim nǝ nggearǝì banggam ama Saratu ka mǝ'eambi na, sǝ yì Saratu gbal ka anggo sǝ banggam. Ən pak gìr mǝnana ǝn pak ka nǝ ɓabum mǝpwat-pwati andǝ kunpwasǝa.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Pǝlǝa Ɓakuli ne wi aɓa mǝno yì lòrǝo ka ama, <<E, ǝn sǝlǝna ama ɓabumo na pwat-pwat, nda gìr mǝnana tsǝa sǝ ǝn tamsǝo arǝ pakkam cauɓikea ka; ǝn ɗekio wu kúmsǝí ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ado ka, nyesǝ ɓwame kyane kya pê burí, acemǝnana yì burí ka mǝɓangnǝa na. Yì ka nǝ̀ pakko hiwi sǝ awu nǝ dum nǝyilǝmu. Sǝ ɓǝ̀a nyesǝi wi māmí raka, awu nǝ sǝlǝa ama ɓafo we wunǝ amǝ'ɓala mò puppup ka, wun nǝ̀ wǔ.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimale lo nǝ dǝmbari ɗiɗyal, tunǝ amǝ'túró-ɓala male kat sǝ nea wia gìr mǝnana kat kumban ngga. Lang à ok cê ka, ɓangciu bwalia. ");
INSERT INTO mbu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pǝlǝa Abimale túrban à tunǝ Ibǝrayim ɓǝ̀ yiu a baní, sǝ ɗì ama, <<Mana mǝnia a pakka sǝm ani ka? Ya cauɓikea na ǝn pakko mǝnana nǝ̀ tsǝa sǝ a nǝ yinǝ ulang mǝnia yì gìr'mur'mwana amuram andǝ nzali-murǝm mem ngga? A pàngŋǝ́nàm gìr mǝnana ɓoaro ɓwa ɓǝ̀ pè raka.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Osso Abimale ɗì Ibǝrayim ama, <<Mana nda ɗenyicau mò sǝ a pak mǝnia yì gìr ka?>> ");
INSERT INTO mbu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibǝrayim eari wi ama, <<Ən pê anggo acemǝnana ɗenyicau mem ngga nda mana ama, kǝɓwa pà kàm a ban mǝnia mǝnana kǝ ɓanggi Ɓakuli ka ɗàng, sǝ à nǝ̀ wal-luem ace mǝnana à nǝ̀ ak māmám ngga. ");
INSERT INTO mbu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Sǝ ɓafo ka, yì, yì Saratu ka mǝ'eambam na. Sǝm nda eambuta-tárrú sǝni, nggea sǝm na pà mwashat raka. Sǝ ǝn ali duk māmám. ");
INSERT INTO mbu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lang Ɓakuli tunǝam ɓǝ̀n nying ɓala mala tárrám sǝ mǝ nggǝ gya arǝ abân ngga, ǝn banggi wi nǝma, <Mǝnia ka nda pěmǝɓoarne mǝnana awu nǝ lǝmdǝàm ngga: Ban mǝnana kat sǝm nǝ̀ ká kàm ngga, banggi aɓwana ama mǝ nda mǝ'eambo.> >> ");
INSERT INTO mbu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimale pǝlǝa yinǝ anzur andǝ andá, andǝ aguro aburana andǝ amamǝna, pè Ibǝrayim. Sǝ nyesǝî Ibǝrayim māmí, Saratu. ");
INSERT INTO mbu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Pǝlǝa Abimale ne Ibǝrayim ama, <<Sǝni, nzali mem ngga, ndya a ɓadǝmbo ka. Ban mana kat wariò a mǝsǝo ka, duk kàm.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ne Saratu ama, <<Mǝ ndya ǝn nggǝ pè <mǝ'eambo> agbatali bolo azǝrfa á-mwashat (1,000) ka. Mǝnia ka mbweban na a bano ace ɓekǝ mǝɓane mǝnana yakǝla ǝn pangnò, sǝ ace lǝmdǝì aɓwana mana atò ka ama kǝ mǝɓane pà kàm a rǝò ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Acemǝnana Murǝm Abimale twal Saratu, mālá Ibǝrayim ngga, Mǝtalabangŋo tamsǝ ɓǝlmuna mala koya ɓwama a palta mala Abimale. Nda Ibǝrayim pàk hiwi aban Ɓakuli ace Abimale, sǝ Ɓakuli sonzǝi. Ɗǝm ngga sonzǝ mālá Abimale andǝ amā-guro male sǝ à kum ɓǝlmuna. ");
INSERT INTO mbu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mǝtalabangŋo ɓwamur Saratu kǝla mǝnana na ka, sǝ pàkkî Saratu kǝla mǝnana pàcau ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Muna kpa a bum Saratu, ɓǝlî Ibǝrayim muna-ɓwabura aɓa ě male. Mǝnia ka yi lumsǝo a kǝ kúnì mǝnana Ɓakuli na ama à nǝ̀ ɓǝl munê ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibǝrayim pǝlǝa tsǝki muna-ɓwabura mǝnana Saratu ɓǝli wi ka lullǝu ama Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Anzǝm nongŋo tongno-nong-tàrú mala ɓǝl Ishaku ka, Ibǝrayim kasǝî wi ɓate kǝla mana Ɓakuli bang ngga. ");
INSERT INTO mbu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibǝrayim ngga, ndanǝ apǝlǝa lumi-lum mǝnana à ɓǝl Ishaku ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saratu na ama, <<Ɓakuli yinǝnàm nǝ oalo. Ɓwa mǝnana kat okce ka nǝ̀ bwalàm oalo.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Nyare na ɗǝm ama, <<Yana nǝ̀ gandǝ ne Ibǝrayim ama Saratu nǝ̀ pe amuna kiura? Sǝ kat andǝa ě male ka, ǝn ɓǝli wi muna-ɓwabura!>> ");
INSERT INTO mbu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Muna, yì Ishaku ka, yi gulo, sǝ a pwari mǝnana à nǝ̀ būrǝi ka, Ibǝrayim tunǝ dapi ace ligirlina mǝgule. ");
INSERT INTO mbu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ɓè pwari ka Saratu sǝn Ishmayel, muna mǝnana Hajara, ɓwama Masar ɓǝlî Ibǝrayim ngga, aban pak ndoro nǝ Ishaku, muna-ɓwabura mala Saratu. ");
INSERT INTO mbu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nda Saratu ne Ibǝrayim ama, <<Pǝ̀r mā-guro man andǝ muni ɓǝà o. Muna-ɓwabura mala ɓwama man pà nǝ̀ liɓala atà muna-ɓwabura mem Ishaku ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Cau mǝnia ka zurǝi ɗenyicau mala Ibǝrayim kǝ̀rkǝ́r, acemǝnana Ishmayel gbal ka muni na. ");
INSERT INTO mbu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Sǝ Ɓakuli banggi Ibǝrayim ama, <<Cè ɓabumo zurǝi amur cau mala muna, ko mala muna-ɓwama mǝtúró-ɓala mò ɗàng. Pàk gìr mǝnana kat Saratu kǝ banggo ka, acemǝnana nǝban Ishaku sǝ à nǝ̀ ɓal amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ɗǝm ngga mǝ nǝ tsǝk muna-ɓwabura mala mā-guro mò nǝ̀ duk kàka aɓwapǝndǝa mala nzali mǝgule, acemǝnana yì gbal ka munio na ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Banfa nǝ dǝmbari ɗiɗyal ka, Ibǝrayim twal girlina andǝ mùr a dù sǝ pè Hajara. Tsǝki wi a múrí sǝ tasǝ takwari andǝ muna ɓǝà o. Hajara andǝ muna o à kǝ gāli a ɓabondo mala amǝ Biyasheba. ");
INSERT INTO mbu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Lang à nùnà mùr mana a dù kat ka, Hajara nongsǝ muna a yilǝm mala ɓè karwan, ");
INSERT INTO mbu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","sǝ o kya duk zak kǝla sauwa mala ban mǝnana ɓǝà túr mundi ka nǝ̀ ká kàm ngga. Bang a ɗenyicau male ama, <<Pà mǝ nǝ gandǝ do sǝ mǝ nggǝ sǝn munem nǝ̀ nggǝ wú ɗàng.>> Lang kya dumǝna zak ka, túrkuni a ɓua, mǝrǝm kǝ sukkio a mǝsǝi. ");
INSERT INTO mbu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ɓakuli ok gi muna aban ɓua. Mǝturonjar mala Ɓakuli tunǝ Hajara nǝ kuli sǝ ne wi cau ama, <<Man pùr arǝò le, Hajara? Cè ɓangciu pakko ɗàng; Ɓakuli ongŋǝna gì muna a ban mǝno nongŋo kǝ ɓua kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lo kyane a baní, loasǝi sǝ wu bwali a buo wu girikì. Mǝ nǝ nggá tsǝk amǝkè à nǝ̀ pǝlǝ ɓwapǝndǝa mala nzali mǝgule.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pǝlǝa Ɓakuli mǝn mǝsǝi sǝn tūli-mùr nǝ mur aɓalǝi. Nda wario kya lùmsǝ dù nǝ mur sǝ pè muna nu. ");
INSERT INTO mbu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ɓakuli ka nda atà muna bà gulo male. Gulo aɓa pǝɗanban sǝ pǝlǝ nggea mǝ'sǝlǝ túr mundi. ");
INSERT INTO mbu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Do a pǝɗanban mala nzali Paran. Nggè alì wi ɓwama nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","A bàkú mǝno ka murǝm Abimale andǝ Fiko, mǝ'sàrǝ̀ban amur amǝ'lwa male yiu aban Ibǝrayim, sǝ ne Ibǝrayim ama, <<Ɓakuli na atò aɓa koman kat a pak ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ado ka kánbàm gìr àkǝ̀ ban mǝnia ka, aɓa lullǝ Ɓakuli ama a pà nǝ swarkiam, ko amuna mem, ko amǝkèm ɗàng. Kǝla mǝnana ǝn do nǝ ɓabum-mwashat arǝò ka, dumnǝ ɓabum-mwashat arǝàm sǝ arǝ aɓwana mǝnana kat aɓa nzali mǝnia a dukiyi kam ado kǝla bǝri ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibǝrayim na ama, <<Ən nggǝ kánbò, mǝ nǝ pàk anggo.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pǝlǝa Ibǝrayim nggwani aban Abimale amur cau mala tūli-mùr mǝnana amǝtúró mala Abimale e nǝ rǝcandǝa a bu amǝtúró male ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Sǝ Abimale bang ama, <<Ən súrǝ̀ yana ɓwe na pàk mǝno yi gìr ka ɗàng. A banggàm ɗàng, sǝ ǝn ok kǝ cau amurí ɗàng she yalung.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Pǝlǝa Ibǝrayim yinǝ aɓea anzur andǝ andá male yi pe Abimale, sǝ yia kǝm à kùrkûn arǝarǝia mala dotarǝu aɓa rǝpwala. ");
INSERT INTO mbu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibǝrayim ɗǝm ngga tàrki amuna-nzur tongno-nong-ɓari a domwan male, sǝ tsǝia tàràng. ");
INSERT INTO mbu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimale ɗì Ibǝrayim ama, <<Amuna-nzur mǝnia tongno-nong-ɓari a pusǝia aɓa domwan sǝ a tsǝia tàràng ngga, mana nda tǝ́rí?>> ");
INSERT INTO mbu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibǝrayim eari wi ama, <<Ən nggǝ earce nǝma wu ak amuna-nzur mǝnia tongno-nong-ɓari ka a buam, ace lǝmdǝa a ɓaɓwa ama a earna tūli-mùr mǝnia ka mema acemǝnana mǝ nda ǝn tǝmi ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Acemani ka à tunǝ banì ama Biyasheba, acemǝnana aburana mǝnia ɓari ka, à pacau arǝarǝia nǝ kángìr a banì. ");
INSERT INTO mbu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Lang à malna pacau arǝarǝia nǝ kángìr a Biyasheba ka, Abimale andǝ Fiko, mǝ'sàrǝ̀ban amur amǝ'lwa male ka, à nyare à o a nzali malea, nzali mala amǝ Filisti. ");
INSERT INTO mbu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibǝrayim yi pandǝ nggun zāmbo a Biyasheba. A banì ka pàk hiwi aban Mǝtalabangŋo, yì Ɓakuli mǝnana nda tàtǝ́k ka. ");
INSERT INTO mbu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Anggo sǝ Ibǝrayim do kǝla bǝri a nzali mala amǝ Filisti banì sauwa. ");
INSERT INTO mbu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nǝnzǝ́mò ka, Ɓakuli kárǝ́ki Ibǝrayim. Ne wi ama, <<Ibǝrayim!>> Sǝ Ibǝrayim eare ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pǝlǝa Ɓakuli ne wi ama, <<Kyane twal muna-ɓwabura mô, kǝ muna mô mwashat ɓǝ̀rɓǝ̀r, Ishaku, mǝnana a earkiyi ace raka, sǝ wu kyan nǝi a nzali Moriya. Kyane pana ɓoro nǝi kǝla gir'nkila mala pisǝe kǝring, akanó amúr ɓè mǝ'nkono mǝnana mǝ nǝ kanio rǝì ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nǝ bu-dǝmbari ɗiɗyal, Ibǝrayim lo arki nggun-bǝsa mana nǝ̀ karǝ pisǝ mǝno yì pàgir mala pisǝe kǝring ngga, pǝlǝa tsǝki mǝdambǝriso male twalo a nzǝmi. Loasǝ aɓea amǝ'túró-ɓala male ɓari atè, sǝ muni Ishaku. Pǝlǝa à bwal njar aban ká a ban mǝnana Ɓakuli ne wi cè ka. ");
INSERT INTO mbu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A tàruià nongŋo ka Ibǝrayim loasǝ mǝsǝì sǝn banì kuko. ");
INSERT INTO mbu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Pǝlǝa ne amǝ'túró-ɓala male ama, <<Wu cam kani, wun andǝ mǝdambǝriso, wu kundǝ sǝm. Mim sǝnǝ muna ka, sǝm nǝ̀ ká kano a dǝmba. Sǝm nǝ̀ nggá peri sǝ sǝm nǝ̀ nyare aban wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibǝrayim twal nggun-bǝsa mala pisǝ gir'nkila kǝring, parì muni Ishaku amurí. Sǝ yì ka twal bǝsa andǝ munabyau a bui. Yia ɓari à bwalna njargula aban o ka, ");
INSERT INTO mbu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ishaku tunǝ tárrí ama, <<Dàdá?>> Ibǝrayim eari wi ama, <<Mana girnì na, munem?>> Ishaku lidǝmba ama, <<Bǝsa andǝ gimsa ka à ndya ka, sǝ nggearǝ mǝgam mala pagìr mala pisǝe kǝring ngga, nda male kǝshe?>> ");
INSERT INTO mbu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibǝrayim eari wi ama, <<Ɓakuli nǝ nggeari ka nǝ̀ yinǝ mǝgam mala pa gir'nkila ace pisǝì kǝring, munem.>> Yia kǝm ngga pǝlǝa à lidǝmbǝa aban o atārǝia. ");
INSERT INTO mbu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lang à kya bwalna banì mǝnana Ɓakuli kani wi ka, Ibǝrayim ɓak gyangŋan, sǝ gilǝki nggun-bǝsa amurí. Pǝlǝa bwal muni Ishaku tà ka abui andǝ akusǝi sǝ nongsǝi amur nggun-bǝsa mǝnana amur gyangŋan ngga. ");
INSERT INTO mbu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Sǝ Ibǝrayim lǝmdǝ bui twal byau nǝ̀ wal muni. ");
INSERT INTO mbu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Sǝama mǝturonjar mala Mǝtalabangŋo tunǝi nǝ kuli ama, <<Ibǝrayim! Ibǝrayim!>> Yi ka pǝlǝa eare ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mǝturonjar ne wi ama, <<Kǝa tsǝk buo arǝ mǝnia yì muna ka ɗàng. Kǝa pakki wi kǝgìr ɗàng. Ən sǝlǝna adyan ama a kǝ ɓanggi Ɓakuli, acemǝnana kǝ munio mǝnia mwashat ɓǝ̀rɓǝ̀r ka, cè kwánǒ arǝàm ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibǝrayim loasǝ mǝsǝì nǝ̀ sǝnban ngga, kara sǝn mǝgam nǝ anjawe sorǝkina aɓa karwan. Pǝlǝa wario kya pusǝ mǝgam mǝno, sǝ yi pwanmyali, pana gir'nkila mala pisǝe kǝring nǝi a kúnì muni Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibǝrayim pǝlǝa tunǝ banì ama, <<Yahweh Yireh.>> Ɓalǝi ama, <<Yahweh nǝ̀ pa.>> Adyan ngga aɓwana kǝ paktúró nǝi aɓa cau pasǝlǝe ama, <<Amur nkono mala Yahweh ka, à nǝ̀ pà gìr kàm.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mǝturonjar mala Mǝtalabangŋo tunǝ Ibǝrayim nǝ kuli ɓaria tunǝban, ");
INSERT INTO mbu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","sǝ ne wi ama, <<Mǝnia ka nda cau mǝnana Mǝtalabangŋo na ka: Acemǝnana a okam, sǝ a giram nǝ kǝ muna-ɓwabura mò mǝnia mwashat ɓǝ̀rɓǝ̀r raka, ǝn kánǝna nǝ ɓamúràm ama, ");
INSERT INTO mbu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mǝsǝcau ka, mǝ nǝ tsǝko bù. Mǝ nǝ tsǝk amunio andǝ amǝ'keò à nǝ̀ làkkì pas mǝnana à pà nǝ̀ gandǝ ɓallia raka. À nǝ̀ làkkì kǝla anlero a bumkuli andǝ làkkì mala mǝsǝsala a kun nggeamùr. Amunio andǝ amǝ'keò ka, à nǝ̀ limurǝm amur aɓia-mǝbura, sǝ à nǝ̀ ak anggea-là malea nǝ rǝcandǝa ɓǝà duk malea. ");
INSERT INTO mbu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nǝban amunio andǝ amǝ'keò sǝ akún mǝnana a ɓanza kat ka, à nǝ̀ kum tsǝkbu, yia kat, acemǝnana a okam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pǝlǝa Ibǝrayim nyare aban amǝ'túró-ɓala male sǝ à bwal njar atārǝia aban nyare a Biyasheba. Ibǝrayim lidǝmba nǝ do a Biyasheba. ");
INSERT INTO mbu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Anzǝm agir mǝnia ka, à banggi Ibǝrayim ama Milka, mālá mǝ'eambi Naho ɓǝlǝ́ni wi amuna-burana. ");
INSERT INTO mbu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ɓwa mǝdǝmbe malea ka à tunǝi ama Uz, ɓwa mǝnana kpá'nzǝm mǝdǝmba ka nda Buz, sǝ amana à kpá'nzǝmia ka à nda ka Kemuyel, yì tár Aram, kàka amǝ'Aramiya, ");
INSERT INTO mbu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","sǝ Kesed, andǝ Hazo, andǝ Pildash, andǝ Jilap andǝ Betuwel. ");
INSERT INTO mbu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel nda tár Rabeka. Milka ɓǝlî Naho, mǝ'eam Ibǝrayim amǝnia yì amuna-burana tongno-nong-tàrú ka. Amúr amǝnia yì amuna-burana tongno-nong-tàrú nǝ bu Milka ka, ");
INSERT INTO mbu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naho nyare kum aɓea amuna nǝ bu mā-twala male mana à tunǝi ama Ruma ka. Alullǝ amuna mala Ruma nda ka: Teba, andǝ Gaham, andǝ Tahash, sǝ Ma'aka. ");
INSERT INTO mbu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saratu pàk apǝlǝa gbǝman-mwashat nǝ lumi-ɓari bwamdǝ tongno-nong-ɓari (127) a ɓanza, ");
INSERT INTO mbu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","sǝ yi wú a Kiriyat Arba (là mǝnana à tunǝki ama Hebǝron ngga) a nzali Kan'ana; sǝ Ibǝrayim kùtí a ɓala kya ɓua lú male nǝ sukki mǝrǝm. ");
INSERT INTO mbu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ibǝrayim pǝlǝa loapi ban ɓua lú māmí sǝ bangcau nǝ amǝ'Hitti ama, ");
INSERT INTO mbu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Mǝ nda ɓwa kúnɗàngna, sǝ ǝn do aɓalǝ wun kǝla bǝri. Ida, wu pam nzali kani aɓalǝ wun ace mǝnana ɓǝ̀n tsǝk lú mem kàm ɓǝ̀ gǝshì ɓamǝsǝam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Amǝ'Hitti eari wi ama, ");
INSERT INTO mbu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<Ɓwamǝgule, kwakikiro arǝ sǝm, sǝm nggǝ sǝno nǝ gulo mala muna murǝm Ɓakuli aɓalǝ sǝm. Tsǝk lú mò a koya ɓembe-ɓa-tali mǝnana a sǝni nda ɓoaro ka. Kǝɓwa pà kàm atà sǝm nǝ̀ gironǝ ɓembe-ɓa-tali male ama nǝ̀ tamsǝo arǝ tsǝk lú mò ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Pǝlǝa Ibǝrayim lo sǝ ɓunbî aɓwana mala là mǝno, yì amǝ'Hitti. ");
INSERT INTO mbu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Sǝ banggia wia ama, <<Ɓǝ̀ wu earǝ́nàm mǝ tsǝk lú mem, ɓǝ̀ gǝshì ɓamǝsǝam ngga, wu kwakikir wun arǝàm: wu zǝmbâm Efǝron muna-ɓwabura mala Zohar, ");
INSERT INTO mbu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ace mǝnana ɓǝ̀ pam gumi-ɓa'tali mǝnana nda a ɓaban male a ban mǝnana à tunǝi ama Makpela ka; nda kano a masǝlǝata kún ɓaban male. Wu zǝmbamì ɓǝ̀ makkamì. Mǝ nǝ mbwe boale kat a mǝsǝ amǝ'nakún, ace mǝnana ɓǝ̀ duk girkuma mem, kǝla ban ace tsǝk lú.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efǝron ɓwa Hitti nǝ nggeari ka ndakam aban do aɓalǝ acili amǝ'Hitti. Pǝlǝa Efǝron ɓwa Hitti earî Ibǝrayim cau sǝ koyan atà aɓwana-mǝgule mala là ka, à nda kǝ kwakikiria ka. ");
INSERT INTO mbu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Bang ama, <<Awo, ɓwamǝgule, kwakikiro oěm, ɓaban ngga ǝn pano wi kat, sǝ ǝn pano gumi-ɓa'tali mǝnana aɓalǝi ka. Akani a ɓadǝm aɓwana mem, ǝn pano wi. Tsǝk lú mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibǝrayim nyare ɓunno a ɓadǝm aɓwana mala là mǝno ");
INSERT INTO mbu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","sǝ bangcau nǝ Efǝron, a kir aɓwana mala là mǝno ka ama, <<Kwakikiro arǝàm, ɓǝ̀ awu nǝ ear ka. Mǝ nǝ mbweo boalo ɓabanì. Banggam shen nda boale, sǝ mim ngga mǝ nǝ po wi. Ak boale a buam acemǝnana mǝ tsǝk lú mem kàm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efǝron earî Ibǝrayim ama, ");
INSERT INTO mbu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<Ɓwamǝgule, kwakikiro arǝàm. Ɓaban mǝnana boale ka gbatali bolo azǝrfa gbǝman-ine na ka, ɓè kǝgìr mǝgule na a nrem sǝnǝ we le? Tsǝk lú mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibǝrayim eare nǝ̀ pà boalo mǝno Efǝron kasǝa sǝ amǝ'Hitti oè ka. Pǝlǝa Ibǝrayim kárǝì Efǝron dǝmbǝrya mala mǝsǝbolo azǝrfa gbǝman-ine, mǝnana kasǝa sǝ amǝ'Hitti oè ka; pàktúró nǝ sǝkel mala azǝrfa mǝnana amǝ'kúrkúró nǝ agir a nza mǝno kǝ pàktúró nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Anggo sǝ ɓaban mǝnana ɗiɗyal mala Efǝron na a Makpela, nǝ bu takuli mala Mamǝre, andǝ gumi-ɓa'tali mǝnana aɓalǝi, andǝ anggun mǝnana kat aɓalǝi aban ká nzong kún ɓabanì, andǝ abân mǝnana à kàrì ka, à pǝlǝ girkuma mala Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Amǝ'Hitti mǝnana kat à wari kano a ban kpapi mala là a kún nggea-là ka, à eare ama ɓaban andǝ koman kat aɓalǝi ka, pǝlǝna girkuma mala Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Anzǝm mǝno ka, Ibǝrayim tsǝk lú māmí Saratu a gumi-ɓa'tali mǝnana a ɓaban a Makpela tù nǝ nggea-là Mamǝre, mǝnana ba yalung à tunǝi ama Hebǝron, a nzali Kan'ana ka. ");
INSERT INTO mbu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Anggo sǝ ɓaban mǝno mǝnana ɗiɗyal mala amǝ'Hitti na, andǝ gumi-ɓa'tali mǝnana aɓalǝi ka, pǝlǝ girkuma mala Ibǝrayim ɓǝ̀ duk nzali ɓembe. ");
INSERT INTO mbu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibǝrayim adyan ngga enà pǝlǝna jamgula, sǝ Mǝtalabangŋo ka tsǝngŋǝ́nì bù aɓa koman kat. ");
INSERT INTO mbu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Pwari mwashat Ibǝrayim bangcau nǝ ɓwamǝgule amur acili amǝ'túró-ɓala male, mǝnana koman kat mala Ibǝrayim ngga nda a buì ka, ama, <<Ida, tsǝk buo aɓa byalam sǝ wu kánbam gìr. ");
INSERT INTO mbu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kán nǝ Mǝtalabangŋo Ɓakuli, mǝtala kùli andǝ nzali ama, a pà nǝ earî munem ɓǝ̀ al ɓwama atà amuna-mamǝna mala amǝ'Kan'ana, mǝnana mǝ ndanǝ do aɓalǝia ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kǝpǝna awu nǝ o a nzali mem, aban aɓǝla mem, wu kya kumbì munem Ishaku ɓwama kàm.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pǝlǝa yì mǝtúró-ɓala ka ɗì ama, <<Ɓǝ̀n wario sǝ ǝn kum ɓwama atà aɓǝla mò, sǝ yakǝla pà nǝ̀ eare nǝ̀ nying là male nǝ̀ twal gya mǝsauwe nǝ̀ yiu atàm a nzali man raka; ɓǝ̀n twal Ishaku mǝ nyesǝi kano ɓǝ̀ kya do aɓalǝ aɓwana mò a là mǝnana a pur kàm ngga le?>> ");
INSERT INTO mbu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibǝrayim eari wi ama, <<Awo, tsǝkiro, cala a twal munem a kyan nǝi akano ɗàng! ");
INSERT INTO mbu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mǝtalabangŋo Ɓakuli, mǝtala kùli pùsǝám ɓǝ̀n purì ɓala mala tárrám andǝ nzali mana à ɓǝ̀lám kam ngga. Yinǝam kani sǝ banggam cau nǝ kángìr ama, nǝ̀ pè amunem andǝ amǝ'kèm nzali mǝnia ka. Yì ka nǝ̀ tasǝ mǝturonjar male ɓǝ̀ ako dǝmba ace mǝnana wu kumbì munem ɓwama kanó. ");
INSERT INTO mbu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sǝ ɓǝ̀ ɓwame ɓinǝe ama pà nǝ̀ yiu atò raka, a purni ɓata kána mem mǝnia ka. Sǝ cè kǝgìr tsǝo a twal munem a umnǝi kano ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nda mǝtúró-ɓala man tsǝk buì aɓa byal Ibǝrayim mǝtala-ɓala male, sǝ kángìr ama nǝ̀ kpata cau mǝnana Ibǝrayim banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pǝlǝa mǝtúró-ɓala man twal lum aɓalǝ akalakadambi mala mǝtala-ɓala male, sǝ gilǝ twalo a nzǝmia mala agir mǝɓoarne ɗàng-ɗáng mǝnana mǝtala-ɓala male pè wi ɓǝ̀ umnǝia a buì ace paɓoro ka. Twal gya aban o a bu-nzali Aram-Naharayim. Kutio wari a nggea-là mala a Naho, mǝ'eam Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Lang bingŋǝ́nà ka, tsǝk akalakadambi à ɓunno amur ankūnǝia a ban ɓe mgbeɗe mùr a nzǝm la. Ndanǝ pwarikpǝra nǝ bu-pwari mana amamǝna kǝ puro ace to mùr ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Pàk hiwi ama, <<Mǝtalabangŋo, Ɓakuli mala mǝtala-ɓala mem Ibǝrayim, ǝn nggǝ zǝmbo, tsǝa ɓǝ̀ gya mem kum lùmsǝo yalung. Lǝmdǝna domǝsǝcau mò aban mǝtala-ɓala mem Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Sǝni, mǝ ndya ǝn came a kún mgbeɗe mùr mǝnia ka, sǝ amamǝna mala aɓwana mǝnana à nda a là mǝnia ka, à ndya à kǝ yiua to mùr ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Zǝmba mem ngga ndya ani ka: Ɓǝ̀n ne ɓeɓwa atà amuna-mamǝna ama, <Ida, pàm mùr mana aɓa bàng mò ka ɓǝ̀n nu,> sǝ nǝ̀ bang ama, <Ang nu, sǝ mǝ nǝ pè akalakadambi mô mùr ɓǝà nu gbal> ka, ɓǝ̀ do nda muna-ɓwama mǝnana a tarrì ace guro mò Ishaku, ɓǝ̀ duk māmí ka. Anggo ka sǝ mǝ nǝ sǝlǝa ama a lǝmdǝna domǝsǝcau aban mǝtala-ɓala mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Malaká mal pàk hiwi ɗàng, Rabeka yi tusǝo nǝ bàng amurí. Yì Rabeka ka muna Betuwel muna-ɓwabura mala Milka, mālá Naho mǝ'eam Ibǝrayim na. ");
INSERT INTO mbu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rabeka ka, ɓanggî ɓoarnsari male, sǝ gulna kārǝ́na doɓala, sǝ malaká je andǝ kǝ ɓwabura ɗang. Yi sulǝo a kún mgbeɗe mùr, lùmsǝ bàng male nǝ mùr, pǝlǝa eauwe. ");
INSERT INTO mbu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mǝtúró-ɓala mala Ibǝrayim tù nǝ mire atè, ne wi ama, <<Ida, pàm mùr a bàng mò ɓǝ̀n nu.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ne wi ama, <<Ɓwamǝgule, mùr nia ka nu.>> Pǝlǝa sulǝ bàng akaurǝa a myal-bui, sǝ danggǝri kún bàng pè wi mùr nu. ");
INSERT INTO mbu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Anzǝm mana pàni wi mùr nùnà ka, bang ama, <<Mǝ nǝ ɗarǝî akalakadambi mò mùr gbal ɓǝà nu sheɓǝ̀ kārǝ́nia ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Pǝlǝa nyesǝ cili mùr mǝno a bàng ngga solǝi akaurǝa aɓa nkenye-mùr mala agirkusǝu, sǝ nyar nǝ mire a kún tūli-mùr, sǝ camarǝ dàrǝ́kì akalakadambi male mùr mana kárǝìa kat ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ɓwabura man came kǝ sǝni kúni ɗǝong, kǝ ndali ko Mǝtalabangŋo tsǝngŋǝ̀nà gya male kumǝna lùmsǝo. ");
INSERT INTO mbu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Anzǝm mana akalakadambi malna nù mùr ka, ɓwabura man pusǝ nyanye andǝ agirgarabu ɓari amǝɓoarne kǝ̀rkǝ́r, mǝnana à pea nǝ bolo-njengǝlan ngga. Oasǝi wi nyanye a lùllǝì, sǝ oasǝi wi agirgarabu arǝ abui. ");
INSERT INTO mbu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Pǝlǝa ɗì ama, <<Ən zǝmbo, banggam yana nda tárró? Ɗǝm ngga banggam, ban nakam a ɓala mala tárró mǝnana mim sǝnǝ aburana mǝnia atàm ngga sǝm nǝ̀ gandǝ nong kàm yalung ngga le?>> ");
INSERT INTO mbu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rabeka eari wi ama, <<Mǝ nda muna mala Betuwel. Kâ mǝɓwabure nda Naho, sǝ kâ mǝɓwame nda Milka. ");
INSERT INTO mbu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","E, sǝm ndanǝ ban mǝnana wun kat wun nǝ̀ gandǝ nong kam yalung a ɓala ma'sǝm, sǝ ɗǝm ngga sǝm ndanǝ mǝsǝkuri andǝ dǝmo kpǝm ace akalakadambi ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ɓwabura man ti múrí sǝ peri aban Mǝtalabangŋo, ");
INSERT INTO mbu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","bang ama, <<Ɓwangsǝban ɓǝ̀ pà aban Mǝtalabangŋo, yì Ɓakuli mala mǝtala-ɓala mem Ibǝrayim. Yì ka nying buì arǝ lǝmdǝ pěmǝɓoarne andǝ kpata pacau male aban mǝtala-ɓala mem ɗàng. Mǝtalabangŋo gingŋǝ́nànǝ mim kporong aban aɓǝla mala mǝtala-ɓala mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nsari man twal mire o aban amǝɓala mala nggè, sǝ kya bang cau mala agir mǝnia kat. ");
INSERT INTO mbu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nsari yì Rabeka ka, ndanǝ mǝgula muna-ɓwabura, lùllǝì ama Laban. Laban puro akaurǝa aban ká aban mgbeɗe mùr nǝ̀ nggá kum mǝtúró-ɓala mala Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lang sǝn agirgarabu arǝ abu mǝ'eambi Rabeka andǝ nyanye-lullǝu, sǝ ok cau mǝnana mǝ'eambi yi na, mǝnana ɓwabure banggi wi ka, puro wario sǝ yi sǝn ɓwabure aban came a ban akalakadambi a kún mgbeɗe mùr. ");
INSERT INTO mbu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Pǝlǝa gingsǝ ɓwabure sǝ ne wi ama, <<Yiu atàm a ɓala. A nda ɓwa mǝnana Mǝtalabangŋo tsǝngŋǝ́nì bù ka. Ɓoaro wu cam kani a nza ɗàng. Mǝ ndanǝ ban aceo a ɓala mem, sǝ ban nakam ace akalakadambi mô.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nda ɓwabure, yì mǝtúró-ɓala mala Ibǝrayim o a ɓala, sǝ kya sulǝ atwalo mǝnana a nzǝm akalakadambi ka. À yinǝ mǝsǝkuri andǝ dǝmo à pè akalakadambi, sǝ à ɗàrǝ́ mùr à pè mǝtúró-ɓala mala Ibǝrayim andǝ aburana mana atè ka ɓǝà lakki akusǝia. ");
INSERT INTO mbu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Lang à yinǝia wia girlina ɓǝà lì ka, mǝtúró-ɓala mala Ibǝrayim bang ama, <<Pà mǝ nǝ lìli ɗang she ɓǝ̀n bangŋǝ́nà wun gìr mǝnana yinǝ mim ngga.>> Laban bang ama, <<Lidǝmba bangga sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Pǝlǝa ɓwabure tite ama, <<Mǝ nda mǝtúró-ɓala mala Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mǝtala-ɓala mem ngga Mǝtalabangŋo tsǝki wi bu kǝ̀rkǝ́r, sǝ tsǝì duk mǝgǝna. Ɓakuli pe wi adomwan mala andá, andǝ ambulpǝndǝa, andǝ anzur; sǝ pè wi azǝrfa, andǝ bolo-njengǝlan, andǝ aguro aburana andǝ amamǝna, andǝ akalakadambi, andǝ amǝdambǝriso. ");
INSERT INTO mbu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saratu, mālá mǝtala-ɓala mem ngga ɓǝli wi muna-ɓwabura a ě male, sǝ mǝtala-ɓala mem pàni wi a buì koman mǝnana kat male na ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mǝtala-ɓala mem tsǝem ǝn kánbì wi gìr ama mǝ nǝ kpata cau male. Bang ama, <Cè a alì munem ɓwama atà ansarina mala amǝ'Kan'ana mǝnana mǝ ndanǝ do a nzali malea ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","A kún mani ka, o aban aɓwana mala tárrám, aban aɓǝla mem, sǝ wu kya alì ɓwama kàm.> ");
INSERT INTO mbu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Sǝ ǝn ɗî mǝtala-ɓala mem nǝma, <Mana mǝ nǝ pa, ɓǝ̀n kum ɓwama mǝnana nǝ̀ eare nǝ̀ yiu atàm raka?> ");
INSERT INTO mbu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nyesǝâm cau ama, <Mǝtalabangŋo mǝnana ǝn kpakiyi atà njar male koya pwari ka, nǝ̀ tasǝ mǝturonjar male atò, nǝ̀ tsǝk gya mô ɓǝ̀ kum lùmsǝo. Awu nǝ kumbì munem ɓwama atà aɓwana mem, a ɓala mala tárrám. ");
INSERT INTO mbu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Sǝama ɓǝ̀a wari aban aɓǝla mem, sǝ à ɓinǝe ama à pà nǝ̀ earî ɓwame ɓǝ̀ yiu atò raka, a purni ɓata kána mò mǝnia ka.> ");
INSERT INTO mbu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","<<Lang ǝn yiu yalung a kún mgbeɗe mùr ka, ǝn pak hiwi ama, <Mǝtalabangŋo, Ɓakuli mala mǝtala-ɓala mem Ibǝrayim, ǝn zǝmbo, ɗeki gya mǝnia ǝn twalo sǝ ǝn yiu kani ka ɓǝ̀ kum lùmsǝo. ");
INSERT INTO mbu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mǝ ndya ǝn came a kún mgbeɗe mùr ka. Ɓǝ̀ kǝ muna-ɓwama puro yiua to mùr ka, mǝ nǝ zǝmbi wi ɓǝ̀ pàm mùr a bàng male ɓǝ̀n nu. ");
INSERT INTO mbu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ɓǝ̀ eare pàm mùr sǝ bang gbal ama nǝ̀ ɗarǝî akalakadambi mem mùr ka, ɓǝ̀ do ama yì nda ɓwama mǝnana a tarni ɓǝ̀ duk mālá muna mala mǝtala-ɓala mem ngga.> ");
INSERT INTO mbu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","<<Kaniama mǝ nǝ mal pàk hiwi mem ngga, Rabeka yi tusǝo nǝ bàng a múrí sǝ kutio sulǝo a tūli mgbeɗe mùr, ɗàrǝ́ mur. Ən banggi wi nǝma, <Ida, pàm mùr mǝ nu.> ");
INSERT INTO mbu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kara sulǝ bàng male a myal bui sǝ na ama, <Nu, sǝ mǝ nǝ ɗarǝî akalakadambi mô gbal ɓǝà nu.> Nda ǝn nu, sǝ kutio kya ɗarǝî akalakadambi mem mùr à nu. ");
INSERT INTO mbu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Osso ǝn ɗî nǝma, <Yana nda tárró?> Pǝlǝa earâm ama, <Tárrám nda Betuwel, muna mala Naho mǝnana à ɓǝl andǝ Milka ka.> Pǝlǝa ǝn twal nyanye-lullǝu ǝn oasǝi wi, sǝ ǝn oasǝi wi agirgarabu arǝ amyal-bui. ");
INSERT INTO mbu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sǝ ǝn ɓunno ǝn peri aban Mǝtalabangŋo. Ən ɓwangsǝ Mǝtalabangŋo, yì Ɓakuli mala mǝtala-ɓala mem Ibǝrayim, mǝnana gingnǝ mim kporong aban ɓǝla mala mǝtala-ɓala mem, ban mǝnana ǝn yi kum ɓoarnsarile ɓǝ̀ duk mālá muna mala mǝtala-ɓala mem ngga. ");
INSERT INTO mbu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ado ka wu banggam, wun nǝ̀ lǝmdǝ pěmǝɓoarne andǝ domǝsǝcau aban mǝtala-ɓala mem, wun nǝ̀ pàk gìr mǝnana ǝn nggǝ ɗice ka le? Sǝ ɓǝ̀ pà wun nǝ̀ pàk raka, wu banggam gbal, ace mǝnana mǝ bwal njar mǝnana mǝ nǝ u kam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Pǝlǝa Laban andǝ Betuwel eari wi ama, <<Gìr mǝnia ka pur nǝban Mǝtalabangŋo; sǝm panǝ kǝ cau mǝnana sǝm nǝ̀ na ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rabeka ka ndya ka; twali wu o. Ɓǝ̀ kya duk mālá muna-ɓwabura mala mǝtala-ɓala mò, kǝla mǝnana Mǝtalabangŋo nǝ nggeari bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lang mǝtúró-ɓala mala Ibǝrayim ok cau mǝnia ka, ɓunno a nzali sǝ peri aban Mǝtalabangŋo. ");
INSERT INTO mbu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Pǝlǝa pusǝ agir-nggūrǝu andǝ agir gilǝki rǝu mǝnana à pea nǝ bolo-azǝrfa andǝ bolo-njengǝlan ngga, sǝ pè Rabeka. Nyar ɗǝm pè mǝ'eambi andǝ ngge aɓoro mana boalea pà bǝti raka. ");
INSERT INTO mbu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pǝlǝa mǝtúró-ɓala mala Ibǝrayim andǝ aburana mana atè ka à lǐ sǝ à nǔ, sǝ à nong kanó. Lang ban fana nǝ dǝmbari ka, mǝtúró-ɓala mala Ibǝrayim bang ama, <<Ən nggǝ earce nǝma ɓǝ̀ wu ɗekiam mǝ nǝ nyare aban Mǝtala-ɓala mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Sǝ mǝ'eam Rabeka andǝ ngge ka à bang ama, <<Ɗeki Rabeka ɓǝ̀ ue kani atà sǝm, kǝla nongŋo lum; anzǝm mǝno ka sǝ nǝ̀ o.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Sǝ yì ka na ama, <<Wu kǝa tsǝem ɓǝ̀n dǝndi ɗang. Mǝtalabangŋo tsǝngŋǝ̀nà gya mem kumǝna lùmsǝo; wu ɗekiam mǝ nyare aban Mǝtala-ɓala mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","À eari wi ama, <<Cam lâ ɓǝ̀ sǝm tunǝ muna-ɓwama, yì Rabeka, ɓǝ̀ sǝm ɗì ɓǝ̀ na sǝm eare mala ɓabumi.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Osso à tunǝ Rabeka sǝ à ɗì ama, <<A kǝ earce wun nǝ̀ o wunǝ ɓwa man le?>> Rabeka eare ama, <<E.>> ");
INSERT INTO mbu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Nda aɓwana mala Rabeka ɗeki ɓǝ̀ o atārǝia andǝ ɓwama mǝnana iulǝi ka, andǝ mǝtúró-ɓala mala Ibǝrayim andǝ aburana mana atè ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","À tsǝktè nǝ mǝnia yì acau mǝɓoarne mala tsǝkbu ka ama: Ɓǝ̀ Ɓakuli tsǝo, we mǝ'eam sǝm, wu duk nggea ka amuna nyangsang! Ɓǝ̀ Ɓakuli tsǝa amunio andǝ amǝ'keo ɓǝà lì ka nggea-là mala aɓia-mǝbura! ");
INSERT INTO mbu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Pǝlǝa Rabeka andǝ amuna-mamǝna amǝ'túró-ɓala mǝnana à pe wi ka, à gilǝ atwalo malea sǝ à eaki a nzǝm akalakadambi, à nǝ̀ o andǝ mǝtúró-ɓala mala Ibǝrayim. Nda à bwal njargula aban o ka. ");
INSERT INTO mbu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ishaku nyàrî Biya-Lahai-Royi; yì ka ndanǝ do a nzali Negev. ");
INSERT INTO mbu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ɓè pwarikpǝra ka puro kǝ gya aban pakki aɗenyicau a banfana a nzǝm là-gumli malea. Lang loasǝ mǝsǝi ka, sǝn akalakadambi aban yiu. ");
INSERT INTO mbu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lang Rabeka loasǝ mǝsǝi gbal sǝn Ishaku ka, zúrró sùlǝî nzǝm kalakadambi male ");
INSERT INTO mbu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","sǝ ɗì mǝtúró-ɓala mala Ibǝrayim ama, <<Yana ɓwe nda mǝno kǝ gya a banfana kǝ yiu a kúllí sǝm ngga?>> Mǝtúró-ɓala mala Ibǝrayim earî wi ama, <<Mǝtala-ɓala mem ma.>> Kara Rabeka gìr múrí nǝ nggubyau-koarǝu male. ");
INSERT INTO mbu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Lang à bwalna ka, mǝtúró-ɓala mala Ibǝrayim bǝ́lì Ishaku kún-bǝri ɗǝɗak. ");
INSERT INTO mbu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pǝlǝa Ishaku kútí nǝ Rabeka aɓa gumli mala nggè Saratu. Twal Rabeka sǝ pǝlǝ māmí. Ishaku earce Rabeka. Nda Ishaku kum girikiban anzǝm lú mala nggè ka. ");
INSERT INTO mbu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibǝrayim al ɓè ɓwama lùllǝì ama Ketura. ");
INSERT INTO mbu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ɓǝlî wi amuna mǝnia: Zimran, andǝ Jokshan, andǝ Medan, andǝ Midiyan, andǝ Ishbak, sǝ Shua. ");
INSERT INTO mbu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan nda tár a Sheba andǝ Dedan. A tǝrta Dedan sǝ amǝ'Asshurim, andǝ amǝ'Letushim, andǝ amǝ Leumim yi puro. ");
INSERT INTO mbu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Amuna-burana mala Midiyan ngga, à nda ka Efa, andǝ Efer, andǝ Hanok, andǝ Abida sǝ Elda. Yià mǝnia kat ka, à nda ka amuna andǝ amǝ'kau nǝ bu Ketura. ");
INSERT INTO mbu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Koman mǝnana kat Ibǝrayim ndanǝi ka nyinggi muni Ishaku ɓǝ̀ do nda mǝliɓala male. ");
INSERT INTO mbu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Sǝ mala amuna-burana mǝnana acili amāmí ɓǝli wi ka, pākia wia aɓoro. Sǝ nda andǝa-yilǝmu peatu ka, gbara tasǝia ɓǝà o a ɓè nzali a njar-takuli, ɓǝà upi ban muni Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Do ɓanza mala Ibǝrayim kat ka, apǝlǝa gbǝman-mwashat nǝ lumi-tongno-nong-ɓari bwamdǝ tongno na (175). ");
INSERT INTO mbu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibǝrayim yi wú, lú mala kaɓa-ɓwa, anzǝm do ɓanza mǝsauwe aɓa rǝpwala pepè. À tsǝì atà akê. ");
INSERT INTO mbu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Amuna-burana male, Ishaku andǝ Ishmayel tsǝk-luí a gumi-ɓa'tali a Makpela, tù a ban là Mamǝre a ɓaban mǝnana ɗiɗyal ka mala Efǝron muna-ɓwabura mala Zohar, ɓwa'Hitti na ka. ");
INSERT INTO mbu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Mǝno yì nzali ka nda ɓaban mǝnana Ibǝrayim akdǝmba kúrí a bu amǝ'Hitti ka. A kàm sǝ à tsǝk-lú Ibǝrayim a nkanggari māmí Saratu. ");
INSERT INTO mbu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Anzǝm lú mala Ibǝrayim ngga, Ɓakuli tsǝki muni Ishaku bu. Ishaku tùro yi do tù aban là mǝnana à tunǝi ama Biya-Lahai-Royi ka. ");
INSERT INTO mbu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Mǝnia ka nda tsaɗya mala amuna andǝ amǝkau a nggurkwar mala Ishmayel, muna mala Ibǝrayim nǝ bu Hajara ɓwama Masar sǝ mǝtúró-ɓala mala Saratu. ");
INSERT INTO mbu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Amǝnia ka à nda ka alullǝ amuna-burana mala Ishmayel; à ɓallia kǝla mǝnana à ɓǝlia ka: muna-dǝmba mala Ishmayel nda Nebayot. A nzǝmi ka à yi ɓǝl Keda, andǝ Adǝbil, andǝ Mibsam, ");
INSERT INTO mbu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","andǝ Mishma, andǝ Duma, andǝ Masa, ");
INSERT INTO mbu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","andǝ Hadat, andǝ Tema, andǝ Jetur, andǝ Nafish, sǝ Kedema. ");
INSERT INTO mbu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Amǝnia yì amuna-burana lum-nong-ɓari mala Ishmayel ka, à yi duk atár anzali. Ko yan ateà ka à tunǝ lullǝ nzali andǝ bando male nǝ lullǝì. ");
INSERT INTO mbu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Do ɓanza mala Ishmayel kat ka, pǝlǝa gbǝman-mwashat nǝ lumi-tàrú bwamdǝ tongno-nong-ɓari (137) na. Do ɓanza male malâ pǝlǝa wu, sǝ à tsǝkbani atà akê. ");
INSERT INTO mbu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Amuni andǝ amǝkè do a bu-nzali mǝnana nongŋo a nre Havila andǝ Shur, tù nǝ nzong-nzali Masar a njar-takuli, ɓǝ̀ ɓwa nǝ̀ umnǝ nzali Asshur ka. Tārǝtè kya dupi aɓǝla male zak. ");
INSERT INTO mbu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Mǝnia ka nda tàu mala Ishaku muna mala Ibǝrayim. Ibǝrayim nda tár Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishaku ka ndanǝ apǝlǝa lumi-ine sǝ al Rabeka, muna mala Betuwel, ɓwa'Aram, mǝnana pùr a nzali Padan Aram ngga. Yì Rabeka ɗǝm ngga nda mǝ'nggaula Laban, ɓwa'Aram. ");
INSERT INTO mbu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rabeka ka nkombi na, acemani ka Ishaku ɓua aban Mǝtalabangŋo ace māmí ace mǝnana ɓǝ̀ kum muna ka. Mǝtalabangŋo ok ɓua male pǝlǝa muna kpa a bum māmí Rabeka. ");
INSERT INTO mbu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Amuna man ngga à kǝ warwara a bum nggea. Rabeka bang ama, <<Man tsǝa sǝ mǝnia yì gìr kǝ kumam?>> Pǝlǝa wario kya ɗìbancau aban Mǝtalabangŋo. ");
INSERT INTO mbu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mǝtalabangŋo ne wi ama, <<Atár anzali ɓari na a bumo. Aɓwana ɓari mǝnia a bumo ka, à nǝ̀ nggá duk anzali ɓari, sǝ à nǝ̀ duk ɓìbura arǝarǝia. Nzali mala ɓwa man mwashat ka, nǝ̀ kútì nzali mala ɓì nǝ rǝcandǝa. Aɓwana mala muna-dǝmba ka, à nǝ̀ nggá duk aguro aɓata aɓwana mala mǝkyauwe.>> ");
INSERT INTO mbu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lang pwari gbáshí kārǝ́na ka, à sǝni ka amuna pasa na mǝnana a bum Rabeka ka. ");
INSERT INTO mbu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mǝdǝmbe nǝ̀ yia pùr ka mǝ'nggubangŋa na, sǝ rǝi ka nyáng na kat kǝla daura mana à tè nǝ nyáng ngga. Pǝlǝa à tsǝki wi lullǝu ama Isǝwa. ");
INSERT INTO mbu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Anzǝmi ka, mǝ'eambi yi tusǝ nǝ bui aban gbami myalkusǝ Isǝwa. Acemani ka, à tsǝki wi lullǝu ama Yakupu. Ishaku ka ndanǝ apǝlǝa lumi-tongno-nong-mwashat (60) mana Rabeka gbáshí apasa man ngga. ");
INSERT INTO mbu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Lang amuna-burana man gulna ka, Isǝwa yi duk mǝ'sǝlǝ pǝra ace sǝlǝ ɓombo male. Kǝ mal apwari male aban gya a njenza. Sǝ mǝ'eambi Yakupu ka, mǝkúnɗǝong na, dukiyi male a ɓala. ");
INSERT INTO mbu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishaku ka earce Isǝwa acemǝnana ban kǝ ɓoari wi arǝ shak nyam-bondo mǝnana Isǝwa kǝ walo kǝ yinǝi ka. Sǝ Rabeka ka kǝ earce Yakupu. ");
INSERT INTO mbu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","A ɓè fara, Yakupu na ban lam mbú sǝ Isǝwa nyàrî ɓabondo, aulǝna sǝ nzala kǝ wali. ");
INSERT INTO mbu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ne Yakupu ama, <<Ɗàrǝâm mbú mǝbangŋe mò mǝna pé, nzala earam ɗàng.>> (Akani sǝ Isǝwa kum lullǝ mǝnana ama, Edom ngga.) ");
INSERT INTO mbu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakupu eari wi ama, <<Mǝ nǝ pò, ɓǝ̀ awu nǝ nyinggam bancame mala gulo mò mala muna-dǝmba ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isǝwa ama, <<Mana nda ɓoaro mala gulo mala muna-dǝmba abanam mǝnana nzala no kǝ earce wal-luem ngga? Mǝ nǝ pò wi.>> ");
INSERT INTO mbu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Sǝ Yakupu ne wi ama, <<Kánbàm gìr peatu ama awu nǝ pàmì.>> Nda Isǝwa kángìr, makkì Yakupu bancame mala gulo male mala muna-dǝmba ka. ");
INSERT INTO mbu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Pǝlǝa Yakupu pe Isǝwa npan sǝ ɗarǝî wi mbú mǝsǝ-nkunding. Isǝwa li sǝ nugìr atè, pǝlǝa lo o. Anggo sǝ Isǝwa ɓǝsǝki gulo male mala muna-dǝmba. ");
INSERT INTO mbu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nggea nzal-gula kpa aɓa nzali mǝno kǝla kǝ mǝnana kpa a pwarian, a nza mala Ibǝrayim ngga. Nda Ishaku tùro o aban Abimale, murǝm mala amǝ Filisti, a Gera ka. ");
INSERT INTO mbu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mǝtalabangŋo pusǝrǝi aban Ishaku sǝ ne wi ama, <<Kǝa sulǝo aban ká a Masar ɗàng; do a nzali mǝnana mǝ nǝ lǝmdǝo wu do kam ngga. ");
INSERT INTO mbu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Do akani a mǝnia yì nzali ka zuku, mǝ nda atò, mǝ nǝ tsǝko bù. Anzali mǝnia kat ka, mǝ nǝ po wia, wunǝ amunio andǝ amǝ'keò, sǝ mǝ nǝ lùmsǝ kùrcau mem mǝnana ǝn kánbì tárró Ibǝrayim ngga. ");
INSERT INTO mbu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mǝ nǝ tsǝa amunio andǝ amǝ'keò nǝ̀ làkkì kǝla anlero a bumkuli, sǝ mǝ nǝ pea wia amǝnia yì anzali ka. Aɓwapǝndǝa mǝnana a ɓanza kat ka, à nǝ̀ kum tsǝkbu mem nǝban amunio andǝ amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mǝ nǝ pàk mǝnia ka acemǝnana Ibǝrayim kwakikiri arǝàm, sǝ kpata anzongcau, andǝ angguracau, andǝ anê, andǝ akwarkiru mem ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nda Ishaku akrǝi duk gbal a Gera ka. ");
INSERT INTO mbu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Lang aɓwana mǝnana a ban mǝno ɗice māmí Rabeka abani ka, bang ama mǝ'eambi muna-ɓwama na. Ɓangciu pakki wi arǝ bang ama māmí na acemǝnana pàk ɗenyicau ama, <<Rabeka ka ɓwama nggea mǝɓoarnsari na, sǝ ace mǝno ka, aɓwana mala ban mǝnia nǝ̀ wal-luem ace twal Rabeka.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Anzǝm mana Ishaku dumǝna banì sauna akanó ka, a ɓè fara ka Abimale Murǝm mala amǝ Filisti pelǝban a mǝsǝkurǝm mala ndà-kulí male, kara sǝni ka, Ishaku na aban pakkiɗire-earban andǝ māmí Rabeka. ");
INSERT INTO mbu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nda Abimale túrban ɓǝà tunǝ Ishaku sǝ ne wi ama, <<Ashe Rabeka ka māmó na! Sǝ palang sǝ a bangga sǝm ama mǝ'eambo na?>> Ishaku eari wi ama, <<Ɓangciu na pàkkam ama ɓǝ̀n bang nǝma māmám na ka, yakǝla ɓeɓwa nǝ̀ wal-luem ace mǝnana nǝ̀ twali ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Pǝlǝa Abimale bang ama, <<Mana nda mǝnia yì gìr a pakka sǝm ngga? Ɓǝ́ ɓeɓwa atà aburana mem nongŋǝna nǝi. Sǝ ɓǝ̀ pàngŋǝ̀nà anggo ka, sǝm dumǝna amǝ'cauɓikea mala ɓealɓikea mǝgule.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Pǝlǝa Abimale pà nzongcau aban aɓwana male kat ama: <<Ɓwa mǝnana je ɓwabura man ko māmí ka, à nǝ̀ wal-luí.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ishaku ɓealɓeale a mǝno yì nzali ka, sǝ àkǝ̀ mǝno yì pǝlǝa ka, kum girlina kǝ̀rkǝ́r acemǝnana Mǝtalabangŋo tsǝkbui amurí. ");
INSERT INTO mbu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yì ka kum gǝna, sǝ kume male kǝ lidǝmba nǝ gulo, gandǝa kya duk nggea mǝgǝna kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ndanǝ adomwan mala andá andǝ adomwan mala anzur andǝ ambul, andǝ aguro pas, gandǝa amǝ Filisti kǝ mwárí. ");
INSERT INTO mbu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(Amǝ'Filisti ka à yi lúmsǝ́kina atūli-mùr mala Ishaku kat; atūli-mùr mǝnana amǝ'túró-ɓala mala tárrí Ibǝrayim tǝmgia ɗiɗyal a nza male ka. À lúmsǝ́kia kat nǝ nzali.) ");
INSERT INTO mbu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","A masǝlǝate ka Abimale banggi Ishaku ama, <<O nying sǝm. We adyan ngga a kutina sǝm nǝ rǝcandǝa.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nda Ishaku tùro upi ban mǝno, kya tsǝk là-gumli male a Ɓangŋaban mala Gera, sǝ duk kam. ");
INSERT INTO mbu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ishaku nyare busǝlǝki atūli-mùr mǝnana à tǝmgia ɗiɗyal a nza mala tárrí Ibǝrayim ngga, yì atūli-mùr mǝnana amǝ Filisti yi lúmsǝ́kia nǝ nzali anzǝm lú mala Ibǝrayim ngga. Ishaku pè atūli-mùr mǝno àkǝ lullǝu mana tárrí akdǝmba pea wia ɗiɗyal ka. ");
INSERT INTO mbu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Amǝ'túró-ɓala mala Ishaku tǝm tūli aɓa pǝɗanban, sǝ à kum mùr mǝɓoarnsari kǝ pur kàm. ");
INSERT INTO mbu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sǝ ayálgír mala amǝ Gera yiu à yi makgir, sǝ kunia ɓua andǝ ayálgír mala Ishaku ama, <<Tūli-mùr mǝnia ka ma'sǝma!>> Nda Ishaku tsǝki tūli-mùr mǝno ka lullǝu ama Esek acemǝnana kunia ɓua amurí ka. ");
INSERT INTO mbu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pǝlǝa amǝ'túró-ɓala male o à kya tǝm ɓè tūli-mùr, sǝ mǝno ɗǝm ngga kunia ɓua amurí andǝia. Nda Ishaku tsǝkî tūli-mùrnî lullǝu ama Sitnah. ");
INSERT INTO mbu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Pǝlǝa Ishaku andǝ amǝ ɓala male gǝshì ban mǝno sǝ o a ɓè ban ɗàng, à kya tǝm ɓè tūli-mùr kàm. Kǝ ɓwa makgir amur mǝnia yì tūli-mùr ka ɗàng. Nda Ishaku tsǝki wi lullǝu ama Rehobot. Yì ka bang ama, <<Adyan ngga Mǝtalabangŋo pana sǝm ban makrǝu, sǝm nǝ̀ nyakǝti sǝ túró ma'sǝm nǝ̀ kum lidǝmba kàm aɓa nzali mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ishaku loapi ban mǝno tùro o a Biyasheba. ");
INSERT INTO mbu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A bu du mǝno ka, Mǝtalabangŋo pusǝrǝi abani sǝ bang ama, <<Mǝ nda Ɓakuli mala tárró Ibǝrayim. Ɓangciu ɓǝ̀ kǝa pakko ɗàng, acemǝnana mǝ nda atò. Mǝ nǝ tsǝko bù sǝ mǝ nǝ hatǝki amunio andǝ amǝkeo àtàcau mala guro mem Ibǝrayim.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ishaku ɓak gyangŋan a ban mǝno, sǝ ɓua aban Mǝtalabangŋo aɓa peri. A ban mǝno ka tsǝk là-gumli male, sǝ amǝ'túró-ɓala male tǝm tūli-mùr. ");
INSERT INTO mbu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aɓa mǝno anggo ka, Abimale andǝ Ahuzat mǝpà kwarkiru male, andǝ Fiko ɓwamǝgule amur amǝ'lwa male pur a Gera, sǝ à yiu aban Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ishaku ɗia ama, <<Ace mana sǝ wu yiu abanam, yì mana ɗiɗyal ka wu ɓinǝmǝsǝàm, wu pakkam mǝɓane, sǝ wu pǝram ɓǝ̀n nying nzali ma'wun ngga?>> ");
INSERT INTO mbu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","À eari wi ama, <<Sǝm sǝni a banfana ama mǝsǝcau ka, Mǝtalabangŋo na atò. Nda sǝm nggǝ earce ama ɓoaro ɓǝ̀ sǝm kángìr sǝm nǝ we, kángìr mala do aɓa rǝpwala a nre rǝarǝ sǝm. Eara sǝm ɓǝ̀ sǝm kùrcau nǝ we amur mǝno, ");
INSERT INTO mbu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ace mǝnana wu kǝa yiu nǝ munǝo arǝ sǝm ɗàng, kǝla mǝnana sǝm ngga sǝm pakko mǝɓane raka. Do mô a ban sǝm ngga sǝm pàkkô cauɓoarna, sǝ sǝm yi tasǝto a o aɓa rǝpwala. Sǝ ado ka Mǝtalabangŋo tsǝ̀ngŋǝ́nò bù.>> ");
INSERT INTO mbu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Pǝlǝa Ishaku tsǝa à pàkki agirlina andǝ agir-nùná ɗàngɗáng acea. À li sǝ à nu atārǝia. ");
INSERT INTO mbu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ban fana nǝ tadǝmbari ɗiɗyal ka, aburana man andǝ Ishaku kánbia rǝia gìr ama à nǝ̀ kpata cau mǝnana à bang ama à nǝ̀ pàk ka. Pǝlǝa Ishaku tasǝia ɓǝà o; à bwal njargula à o aɓa rǝpwala. ");
INSERT INTO mbu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","A pwari mǝno ka amǝ'túró-ɓala mala Ishaku yiu à yì banggi wi cau mala bǝsa tūli-mùr mǝnana à mal tǝ̀mé ka, ama à kum mùr kàm. ");
INSERT INTO mbu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nda tsǝki wi lullǝu ama Shiba, sǝ yi pur a yalung ngga lullǝ la mǝno ka, à súrǝì nǝ Biyasheba. ");
INSERT INTO mbu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Lang Isǝwa lùmsǝ̀nà pǝlǝa lumi-ine mala do ɓanza male ka, al amamǝna ɓari amǝ'Hitti, Judit ɓoarnsarile Beri, andǝ Basemat ɓoarnsarile Elon. ");
INSERT INTO mbu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Amamǝna mǝnia ɓari ka, à yinǝi Ishaku andǝ Rabeka bumkiɗikea kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Lang Ishaku ènà sǝ amǝsǝi kǝ sǝnban ɗǝm pepè raka, tunǝ Isǝwa muna-dǝmba male ama, <<Isǝwa.>> Pǝlǝa Isǝwa ear ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ishaku ne wi ama, <<Sǝni, ǝn ènà, sǝ ǝn súrǝ̀ pwari lú mem ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ida, twal ntà mò andǝ kpǝliba, kya a bondo kya ɓomɓombo walâm nyama, ");
INSERT INTO mbu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","sǝ wu lambam girlina mǝnana ǝn earkiyi ace raka pé. Yinǝàm nǝi mǝ li, mǝ tsǝko buam, sǝ mǝ wú.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Cau mǝnana Ishaku na aban ne muni ka, Rabeka na aban oe. Lang Isǝwa umǝna a ɓombo ka, ");
INSERT INTO mbu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rabeka pǝlǝa tunǝ muni Yakupu sǝ ne wi ama, <<Ən ok tárró kǝ ne mǝ'eambo Isǝwa ama, ");
INSERT INTO mbu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ɓǝ̀ kya wali wi nyam ɓombo, ɓǝ̀ yi lambi wi girlina mǝɓoarne nǝ̀ li, sǝ nǝ̀ tsǝki wi bù a ɓadǝm Mǝtalabangŋo sǝ ɓǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ado ka, we munem, ida kwakikiro arǝàm sǝ wu pak gìr mǝnana ǝn no nǝma wu pak ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kya aɓa domwan wu yinǝàm nǝ amuna-mbùl amǝɓoarne ɓari, mǝ nǝ ya lambî tárró girlina mǝnana earkiyice ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Awu nǝ kánǝí wu kya pe tárró ɓǝ̀ lî, ɓǝ̀ tsǝko bù, sǝ ɓǝ̀ wǔ.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakupu pǝlǝì nggè Rabeka ama, <<A sǝlǝna ama Isǝwa ka nyáng na arǝì, sǝ mim ngga rǝàm na halhal. ");
INSERT INTO mbu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ɓǝ̀ tárrám kya je rǝàm ngga mǝ nǝ pàk lang? Nǝ̀ na ama ǝnggǝ earce ɓangginǝi, sǝ a kúnì tsǝkbu ka nǝ̀ suem.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pǝlǝa nggè pǝlǝi wi ama, <<Munem, ɓǝ̀ súbanì yiu amuram. We ka pàk gìr mǝnana ǝn no nǝma wu pak ka; kyane kya yinǝàm nǝia.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nda Yakupu o kya yinǝì nggè nǝ ambulnì. Rabeka yi lam girlina mǝɓoarne mǝnana Ishaku kǝ earce ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pǝlǝa Rabeka twal daura mǝɓoarne mala Isǝwa, mǝnana nda a ɓala ka, oasǝì Yakupu muni mǝkyauwe, ");
INSERT INTO mbu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","sǝ gìr abui andǝ myali nǝ nyáng ambulnì. ");
INSERT INTO mbu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Pǝlǝa pè Yakupu nɗǝmo andǝ mbú mǝɓoarne mǝnana lam ngga. ");
INSERT INTO mbu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakupu twal girlina umnǝi aban tárrí sǝ kya ne wi ama, <<Dàdá.>> Ishaku eari wi ama, <<Woi, munem, a nda yana ɗê?>> ");
INSERT INTO mbu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakupu eari wi ama, <<Mǝ nda Isǝwa muna-dǝmba mò. Ən pángŋǝ̀nà gìr mǝnana a nam ama ɓǝ̀n pak ka. Nyame ndya ka. Ida, lo dumnǝdo, li girlina sǝ wu tsǝkam bù.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishaku ɗì ama, <<A pak lang sǝ a kaurǝa kum nyame anggo tù, munem?>> Yakupu pǝlǝi wi ama, <<Mǝtalabangŋo Ɓakuli mò na tsǝa sǝ ǝn kumi tù ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ishaku pǝlǝa ne Yakupu ama, <<Sung abanam pě mǝ jeo, munem, mǝ sǝlǝa ko mǝsǝcau a nda Isǝwa ko a nda ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pǝlǝa Yakupu sungŋo aban tárrí, sǝ Ishaku je rǝì sǝ na ama, <<Giu ka mala Yakupu na, sǝ abú ka à mala Isǝwa na.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yì ka ɓwàrki arǝ súrǝ̀ Yakupu, acemǝnana abuí ka à ndanǝ nyáng arǝia kǝla mala Isǝwa. Nda Ishaku gilǝrǝi nǝ̀ tsǝki wi bù, ");
INSERT INTO mbu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","sǝ ɗì ɗǝm ama, <<Mbak-kàngkàng a nda munem Isǝwa le?>> Isǝwa pè wi eare ama, <<È, mǝ nda.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Pǝlǝa Ishaku ne wi ama, <<Sungsǝàmi a banam ace mǝnana mǝ li nyam-bondo mala munem mǝ tsǝko bù.>> Nda Yakupu twal girlina pè tárrí lǐ, sǝ pe wi mùr-ɓǝlanggun anap nuì. ");
INSERT INTO mbu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ishaku ne muni ama, <<Ida, sung abanam kùram a rǝo, munem.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakupu pǝlǝa sungŋo a baní sǝ kùrì arǝì. Lang Ishaku ok rǝm daura rǝì ka, tsǝki wi bu sǝ na ama, <<Rǝm munem na kǝla rǝm ɓabondo mǝnana Mǝtalabangŋo tsǝ̀ngŋǝ́nì wi bù ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ɓǝ̀ Ɓakuli pò ncimna nǝ kuli andǝ nzali mǝɓoarne mǝnana nǝ pusǝ mǝssa kpǝm andǝ mùr-ɓǝlanggun anap ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Aɓwapǝndǝa pas nǝ̀ duk amǝ'túró mô, sǝ aɓwapǝndǝa mala nzali nǝ̀ ɓun a ɓadǝmbo. Awu nǝ duk ɓwamǝgule amur amǝ'eambo sǝ amuna mala nggò nǝ̀ kùndǝó a ɓadǝmbo. Aɓwana mǝnana kat à sueo ka, à nǝ̀ suia, sǝ aɓwana mǝnana à tsǝko bù ka, à nǝ̀ tsǝkia wia bù.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Lang Ishaku mal tsǝki Yakupu bù, sǝ Yakupu puro nǝ̀ nggǝ u ka, nda Isǝwa kǝ nyàrî ɓombo ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Isǝwa lam girlina mǝɓoarne sǝ twali wari nǝi aban tárrí. Pǝlǝa ne tárrí ama, <<Dàdá, ida lo dumnǝdo lì girlina mem mala nyam-bondo, sǝ wu tsǝkam bù.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ishaku ɗì ama, <<A nda yana?>> Isǝwa pe wi eare ama, <<Mǝ nda muna-dǝmba mò Isǝwa.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Rǝ Ishaku kútia ɓǝ̀l rang-rang sǝ na ama, <<Yana ɓwe na kya ɓomɓombo yinǝàm nǝ girlina? Ən lina girlinê adyan sǝ a yiu, sǝ ǝn tsǝ́ngŋǝ̀nì wi bu, sǝ yì tsǝkbu ka dumǝna anggo male na.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lang Isǝwa ok cau mala tárrí ka, sak zwalo mala ɓua kwanban, ne tárrí ama, <<Dàdá, tsǝkam bù, mim gbal ka tsǝkam bù!>> ");
INSERT INTO mbu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tárrí ne wi ama, <<Mǝ'eambo yiu kani yi swarkiam, angŋǝna tsǝkbu mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isǝwa na ama, <<Ɓà sǝ à pè wi lullǝu ama Yakupu ɗàng, ɓǝmbǝrinǎm ado kusǝ ɓari. Angŋǝnàm gulo ɓǝlban mem mala muna-dǝmba, sǝ ado ɗǝm ngga angŋǝnàm tsǝkbu mem!>> Pǝlǝa ɗì tárrí ama, <<Kǝ ɓè tsǝkbu ueo mǝnana awu nǝ tsǝkam ngga re?>> ");
INSERT INTO mbu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishaku ne wi ama, <<Ən angŋa dǝmba ǝn tsǝ́ngŋǝ̀nì ɓǝ̀ do ɓwamǝgule amuro, sǝ ǝn pana amǝ'eambi kat ɓǝà duk aguro male. Ən mǝnǝni wi njar mala hatǝki a kum mǝssa andǝ mùr-ɓǝlanggun anap. Man ɗǝm ado mǝ nǝ pa aceo le, munem?>> ");
INSERT INTO mbu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isǝwa lidǝmba nǝ zǝmbi tárrí ama, <<Kǝ ɓè tsǝkbu mwashat pa kàm mǝnana awu nǝ tsǝkam ngga re, Dàdá? Mim gbal ka tsǝkam bù!>> Sǝ Isǝwa loasǝ gì sak ɓua. ");
INSERT INTO mbu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ishaku nǝ̀ mǝn kúní ka ne wi ama, <<Kwakikiro ǒ . Nzali-rya mala bando mò ka nǝ̀ duk pǝɗan ban, sǝ mbulo pa nǝ̀ nggǝ sulǝ kam ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nǝ́ nggeabyau mò sǝ awu nǝ kúmbi ɓamúr rǝò do. Awu nǝ dupi mǝ'eambo guro. Sǝama ɓǝ̀ a longna a nǝ ak garabuo ka, awu nǝ purî ɓatè.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nda Isǝwa ɓinǝmǝsǝ Yakupu ace gìr mǝnana Yakupu pè, tsǝk tárrià pè wi tsǝkbu mǝnana male yì Isǝwa na ka. Ɓalbure a ɓabumi ama, <<Pwari doatu ace lú mala tár sǝm gbàshìnà; anzǝmi ka, she mǝ nǝ wal-lú mǝ'eambam Yakupu.>> ");
INSERT INTO mbu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lang ɓè ɓwa yi banggi Rabeka gìr mǝnana muna-dǝmba male Isǝwa shame nǝ̀ pè ka, túrban atà Yakupu yi ne wi ama, <<Mǝ'eambo Isǝwa na kǝ ɓalburio ama nǝ wal-lueó ace gìr mǝnana à pakki wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ado ka munem, pàk gìr mǝnana ǝn nggǝ banggo ka: Lo ɓangŋa o aban mǝ'eambam Laban a Haran. ");
INSERT INTO mbu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kyane duk kanó a banì she ɓǝ̀ bumlulla mala mǝ'eambo pwalǝna ka. ");
INSERT INTO mbu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ue kano she ɓǝ̀ bumlulla male sulǝna, sǝ ɓālǝi lorǝna gìr mǝnana a pakki wi ka. Mǝ nǝ túrban atò wu nyare. Ace mana sǝ mǝ nǝ ɗwanyiban wun kǝm a pwari mwashat?>> ");
INSERT INTO mbu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Pǝlǝa Rabeka ne Ishaku ama, <<Banshirìnam, sǝ ǝn aulǝna nǝ amālá Isǝwa amǝ'Hitti mǝnia. Ɓǝ̀ Yakupu nǝ̀ al ɓwama a nzali mǝnia, atà mamǝna mala amǝ'Hitti kǝla amǝnia ka, lú nǝ̀ ɓoarîbanì abanam.>> ");
INSERT INTO mbu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Acemani ka Ishaku tunǝ Yakupu tsǝki wi bù sǝ banggi wi ama, <<Cè a al kǝ ɓwama Kan'ana ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lo o a nzali Padan Aram, a ɓala mala keò Betuwel, kya al ɓwama atà amuna-mamǝna mala kìnò Laban. ");
INSERT INTO mbu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ɓǝ̀ Ɓakuli Mana Karban Kat nǝ Gulo ka tsǝko bù! Ɓǝ̀ tsǝa wu ɓǝla wu hatǝki, ɓǝ̀ tsǝktau mò gulo ɓǝ̀ duk aɓwapǝndǝa mǝ'làkke pas. ");
INSERT INTO mbu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ɓǝ̀ Ɓakuli tsǝa tsǝkbu mǝnana tsǝki Ibǝrayim ngga ɓǝ̀ sulǝo amuro wunǝ aɓwana mǝnana a tàu mò ka. Ɓǝ̀ nzali mǝnana a nda aɓalǝi ado kǝla bǝri ka ɓǝ̀ duk mò acemǝnana Ɓakuli panì Ibǝrayim nzalinì.>> ");
INSERT INTO mbu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Nda Ishaku pusǝbǝri Yakupu ɓǝ̀ o, sǝ Yakupu bwal njar aban o a nzali Padan Aram. Wario nǝ̀ nggá do atà kine Laban, muna mala Betuwel ɓwa'Aram sǝ mǝ'eam Rabeka, nggea ka yì Yakupu andǝ Isǝwa. ");
INSERT INTO mbu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isǝwa yi sǝlǝ ama, tárrí Ishaku tsǝ̀ngŋǝ́nì Yakupu bù sǝ tasǝnate ɓǝ̀ o a nzali Padan Aram ɓǝ̀ kya al ɓwama kàm, sǝ lang tárrí na rǝ tsǝki Yakupu bù ka, nunkiri ama ɓǝ̀ kǝa al ɓwama Kan'ana ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakupu okî tárrí andǝ ngge sǝ o a nzali Padan Aram. ");
INSERT INTO mbu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Lang gìrnî yi kpākì Isǝwa ama tárrí andǝ ngge earce amamǝna mala amǝ'Kan'ana raka, ");
INSERT INTO mbu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","lo gbal o atà Ishmayel mǝ'eam tárrí kya al ɓè muna-ɓwama mala Ishmayel, yinǝi amur amamǝna mǝnana ndanǝia ɗiɗyal ka. Bǝsa māmí ka lùllǝì nda Mahalat. Yì ka nda mǝ'kyauwa Nebayot ɓè muna-ɓwama mala Ishmayel muna Ibǝrayim. ");
INSERT INTO mbu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakupu nying Biyasheba bwal njar aban o a Haran. ");
INSERT INTO mbu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yi bwal ɓè ban nǝ pwarikpǝra sǝ giliki banì nǝ̀ nong nggam. Twal ɓè tali a banì loasǝna múrí nǝi. Pǝlǝa ko a ntulo a banì. ");
INSERT INTO mbu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Aɓa lòrǝo kara sǝni ka, à loasǝna njar-eauwe, tǝ́rtè lo a nzali sǝ múrí kya bwal kùli. Sǝ sǝni ka, amǝturonjar mala Ɓakuli à kǝ eauwe sǝ à kǝ sulǝo amurí. ");
INSERT INTO mbu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nyare sǝni amurí a kùli ka, Mǝtalabangŋo na aban came sǝ na ama, <<Mǝ nda Yahweh Ɓakuli mala keò Ibǝrayim, sǝ Mǝ nda Ɓakuli mala tárró Ishaku. Nzali mǝnana a nong amurí ka, mǝ nǝ po wi wunǝ amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tàu mò nǝ làkkì kǝla tú nzali. À nǝ̀ mesǝe arǝ abuban ɗàngɗáng, nǝ njar-nzali andǝ njar-takuli, nǝ njar-nza andǝ njar-kunmur. Aɓwapǝndǝa kat a ɓanza nǝ̀ kum tsǝkbu nǝbano sǝ nǝban amunio andǝ amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Sǝni, mǝ nda atò, sǝ mǝ nǝ yálo, a koya ban kat a nǝ ká kam ngga, sǝ mǝ nǝ nggá nyesǝo ɗǝm aɓa mǝnia yi nzali ka. Pà mǝ nǝ nyio ɗang she ɓǝ̀n pángŋǝ́nò agir mǝnana kat ǝn no nǝma mǝ nǝ pakko ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakupu loapi ntulo sǝ na ama, <<Mǝsǝcau Mǝtalabangŋo na a ban mǝnia sǝ ko ǝn sǝlǝ ɗang!>> ");
INSERT INTO mbu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ɓangciu pakki wi gbal sǝ na ama, <<Man yì ban ngga nda ɓiki kàrmúrû ka! Kǝ ban nda man ɗang, ɓala mala Ɓakuli na; nda kǝ bankutio mala ká kùli.>> ");
INSERT INTO mbu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ban fanà nǝ ban'mbul-mbul ka Yakupu lo sǝ twal tali mǝnana loasǝna múrí nǝi ka, tamsǝì sǝ pǝlǝa ɗārǝí nǝ mùrú. ");
INSERT INTO mbu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tsǝkî banì lullǝu ama Betel, sǝ ɗiɗyal ka à kǝ tunǝ banì ama Luz. ");
INSERT INTO mbu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakupu pǝlǝa pàcau nǝ-shambum aɓadǝm Ɓakuli ama: <<Ɓǝ̀ awu nǝ do atàm, a nǝ yálǎm aɓa mǝnia yì gya ǝn nggǝ twalo, sǝ awu nǝ pàm girlina kunam andǝ agir-nggūrǝu mǝnana mǝ nǝ oasǝo, ");
INSERT INTO mbu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sǝ ɓǝ̀n nyar bǎng a ɓala mala tárrám ngga, Mǝtalabangŋo nǝ̀ duk Ɓakuli mem. ");
INSERT INTO mbu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mǝnia yì tali ǝn tamsǝì ka, nǝ̀ duk ɓala mala Ɓakuli, sǝ mǝ nǝ po kāmbe mwashat aɓa lum mala girbunda mǝnana kat awu nǝ pàm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakupu lidǝmba nǝ gya male, yi bwal nzali mala aɓwana mǝnana a takuli ka. ");
INSERT INTO mbu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Lang loasǝ mǝsǝi ka, kara sǝn tūli-mùr a banfana nǝ domwan tàrú mala anzur aban nongŋo a nkanggari à kǝ kundǝ pàmur. Nggea tali mǝgule gìr kún tūli-mùrnî. ");
INSERT INTO mbu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","(A là mǝno ka she ɓǝ̀ adomwan yi ramǝna kat ka, sǝ ayálgír nǝ̀ ramta tali à nǝ̀ pea anzur mùr. Sǝ ɓǝà malǝna ka, à nǝ̀ nyesǝ tali a kún tūli-mùr.) ");
INSERT INTO mbu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakupu wari aban ayálgírnì sǝ ɗia ama, <<Wun amǝ'eambam, wu pur nǝ kǝshe?>> À eari wi ama, <<Sǝm pur a Haran.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Pǝlǝa ɗia ama, <<Wu súrǝ̀ Laban mǝ'kà Naho le?>> À bang ama, <<E, sǝm súrǝì.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Pǝlǝa Yakupu ɗia ama, <<Nda bǎng le?>> À pè wi eare ama, <<Nda bǎng. Sǝni, munì Rahila nda mǝno kǝ yiu nǝ anzur male ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakupu na ama, <<Wu sǝni, pwari malaká kārǝa à nǝ̀ nyesǝ agirkusǝu a domwan ɗàng. Wu pea wia mùr sǝ wu nyesǝia aban likiagir a bondo.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","À pǝlǝi wi ama, <<Pà sǝm nǝ̀ pak mǝno ka ɗàng she ɓǝ̀ adomwan yina kat ka; sǝ sǝm nǝ̀ gǝ́shí tali sǝm nǝ̀ pè anzur mùr.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakupu naban nacau più sǝ Rahila yi tusǝ nǝ anzur mala tárrí. Yì Rahila ka, nda mǝyál anzur mala tárrí. ");
INSERT INTO mbu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Lang Yakupu sǝn Rahila, muna mala kine Laban andǝ domwan mala Laban ngga, wario kya gǝ́shí tali mǝnana gìr kún tūli-mùr ka, pè anzur mala kine mùr. ");
INSERT INTO mbu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pǝlǝa Yakupu pàkkî Rahila popuro sǝ loasǝ gì aban ɓua ace banɓoarnado. ");
INSERT INTO mbu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakupu banggi Rahila ama, <<Mǝ nda ɓǝla mala tárró, muna mala Rabeka.>> Rahila pǝlǝa ɓangŋa o kya ne tárrí. ");
INSERT INTO mbu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sǝ lang Laban ok ama mǝkine Yakupu yina ka, lo nǝ mire nǝ̀ nggá kumi. Mǝn abui kùr Yakupu zǝp, gingsǝi sǝ umnǝi a ɓala. Lang Yakupu bǝlǝni wi kúni kat ka, ");
INSERT INTO mbu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban loasǝ gì na ama, <<Mǝsǝcau, a nda muem andǝ nyamam.>> Nda Yakupu do atà Laban zongŋo mwashat ka. ");
INSERT INTO mbu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban ne Yakupu ama, <<A pà wunǝ pàkkam túró ɓà acemǝnana a nda ɓǝla mem ngga ɗàng. Banggàm ya tangnakusǝu na a earkice mǝ po?>> ");
INSERT INTO mbu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ngga ndanǝ amuna-mamǝna ɓari; muna mǝgule ka lùllǝì nda Liya, sǝ mǝkyauwe ka lùllǝì nda Rahila ");
INSERT INTO mbu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya ka amǝsǝi ɓoarsǝna sǝ Rahila ka ɓamǝsǝi ɓoarnsari sǝ ndanǝ nggunrǝu mǝnana à nǝ̀ earce ka. ");
INSERT INTO mbu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakupu ka kǝ earce Rahila sǝ ne kine ama, <<Mǝ nǝ pàkkô túró mala pǝlǝa tongno-nong ɓari, ɓǝ̀ awu nǝ earâm mǝ al Rahila ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ne Yakupu ama, <<Pò Rahila ka nǝ̀ ɓoaram nǝ̀ kútì mǝnana mǝ nǝ pè ɓeɓwa ka. We ka do atàm pàkkam túró.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nda Yakupu pàktúró apǝlǝa tongno-nong-ɓari ace Rahila sǝ yàle sǝni a baní kǝla anongŋo na bǝti ace ulang earban mǝnana ndanǝi ace Rahila ka. ");
INSERT INTO mbu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","A masǝlǝate ka, Yakupu ne Laban ama, <<Apǝlǝa mala túró mem lùmsǝ̀nà. Pam māmám. Ən nggǝ earce nǝma mǝ nǝ kutio a baní.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Pǝlǝa Laban tunǝki aɓwana a cengge ɓǝà yiu ace ligirlina mala isǝban. ");
INSERT INTO mbu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sǝ lang ban bwalnà ka, yinǝ Liya yi pe Yakupu, sǝ Yakupu kùtí a baní. ");
INSERT INTO mbu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban twal muna-ɓwama mǝtúró-ɓala male Zilpa pè Liya ɓǝ̀ duk muna-ɓala male.) ");
INSERT INTO mbu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Lang banfana ka Yakupu yi sǝni ka, ashe Liya na. Pǝlǝa ɗì Laban ama, <<Mana mǝnia a pakkàm ani ka? Ən pakko túró ace Rahila re? Sǝ palang sǝ a ɓosǝkiam anggo?>> ");
INSERT INTO mbu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban nyesǝi wi ama, <<Kuncau ma'sǝm ear ama muna-ɓwama mǝkyauwe ɓǝ̀ albura amur mǝgule ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kúndǝô ɓǝ̀ limo mala pakkiɗire isǝban mǝnia ɓǝ̀ kutio, sǝ sǝm nǝ̀ pò mǝkyauwe gbal, ɓǝ̀ awu nǝ eare awu nǝ pàktúró mala ɓè pǝlǝa tongno-nong-ɓari ɗǝm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakupu pǝlǝa eare pè kǝla mǝnana Laban bang ngga. Limo mwashat anzǝm pakkiɗire isǝban mala Liya ka, Laban pè wi Rahila ɓǝ̀ duk māmí gbal. ");
INSERT INTO mbu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban pè Rahila guro male Bilha ɓǝ̀ duk muna-ɓala male.) ");
INSERT INTO mbu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakupu kùtí aban Rahila gbal, sǝ earce Rahila kútì mǝnana earce Liya ka, pǝlǝa do pakki Laban túró mala ɓè pǝlǝa tongno-nong-ɓari ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Lang Mǝtalabangŋo sǝni Liya ka à eàrì pepè raka, pǝlǝa pè wi ɓǝlmuna sǝ mala Rahila ka, duk nkombi. ");
INSERT INTO mbu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liya kum muna a bumi sǝ ɓǝl muna-ɓwabura, sǝ pe wi lullǝu ama Ruben. Pǝlǝa bang ama, <<Mǝtalabangŋo sǝna tanni mem, ado ka burém nǝ̀ earám.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nyare kum muna a bumi ɗǝm, ɓǝl ɓè muna-ɓwabura, sǝ pè wi lullǝu ama Shimiyon. Pǝlǝa bang ama, <<Mǝtalabangŋo pam mǝnia yi muna acemǝnana yi ok ama à eàrám ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nyar ɗǝm kum muna a bumi, ɓǝl ɓè muna-ɓwabura, pè wi lullǝu ama Lawi. Pǝlǝa bang ama, <<Ado ka burém nǝ̀ tà arǝàm, acemǝnana ǝn ɓǝlǝni wi amuna-burana tàrú.>> ");
INSERT INTO mbu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nyar ɗǝm kum muna a bumi ɓǝl ɓè muna-ɓwabura sǝ pe wi lullǝu ama, Yahuda. Pǝlǝa bang ama, <<Ado ka mǝ nǝ ɓwangsǝ Mǝtalabangŋo.>> Sǝ ɓǝlmuna kasǝi wi. ");
INSERT INTO mbu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lang Rahila sǝni pà nǝ̀ gandǝ ɓǝlî Yakupu muna raka, kara mɓali pakki wi arǝ mǝgule muna-ɓwama. Pǝlǝa zǝmbi Yakupu ama, <<Pam amuna, ɓǝ̀ ana raka mǝ nǝ wú!>> ");
INSERT INTO mbu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kara bum Yakupu lul kǝ̀rkǝ́r arǝ Rahila, sǝ ɗì ama, <<Mǝ nda Ɓakuli le? Yì nda ɓwa mǝnana po ɓǝlmuna raka!>> ");
INSERT INTO mbu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Pǝlǝa Rahila banggi wi ama, <<Twal mǝtúró-ɓala mem, Bilha, pàk-ɓwama nǝi. Yì ka nǝ̀ ɓǝlâm amuna, sǝ nǝbaní sǝ mǝ nǝ kum mem gbal yìa amǝɓala.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nda Rahila pè Yakupu mǝtúró-ɓala male, yì Bilha, ɓǝ̀ duk māmí, pǝlǝa pàngŋǝ̀nà-ɓwama nǝi. ");
INSERT INTO mbu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha kum muna a bumi, ɓǝ̀lî Yakupu muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahila bang ama, <<Ɓakuli angŋamuram! Ongŋǝna ɓua mem, nda pam muna-ɓwabura ka.>> Acemani ka tsǝki mune lullǝu ama Dan. ");
INSERT INTO mbu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nyare Bilha kum muna a bumi, ɓǝ̀lî Yakupu ɓè muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Pǝlǝa Rahila bang ama, <<Ən warǝ̀nà wara kǝ̀rkǝ́r mala Ɓakuli sǝnǝ mǝ'eambam muna-ɓwama, sǝ ndo ǝn nggǝ limurǝm amurí ka!>> Acemani ka tsǝki muna lullǝu ama Naftali. ");
INSERT INTO mbu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lang Liya sǝni kǝ kum muna a bumi ɗǝm raka, twal muna-ɓala male, yì Zilpa, pè Yakupu ɓǝ̀ duk māmí. ");
INSERT INTO mbu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, muna-ɓala mala Liya ɓǝ̀lî Yakupu muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liya pǝlǝa bang ama, <<Ən kumǝna múrɓoarna!>> Nda tsǝki wi lullǝu ama, Gad. ");
INSERT INTO mbu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nyare Zilpa ɓǝ̀lî Yakupu ɓaria muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Pǝlǝa Liya bang ama, <<Ən kumǝna bumpwasǝa kǝ̀rkǝ́r! Adyan ngga acili amamǝna nǝ̀ pàk bumpwasǝa atàm.>> Nda tsǝki muna lullǝu ama, Asha. ");
INSERT INTO mbu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","A ɓè pwari, nǝ kún cangi amǝsa, Ruben wari a ɓabondo sǝ kum dude, pǝlǝa uí sǝ yinǝì nggè Liya wi. Rahila zǝmbî Liya ama, <<Ida, pam bǝti aɓa dude mana munio yinǝo wi ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sǝ Liya ka nyesǝi wi cau ama, <<Karǝma re, yi mǝnana a ak burém arǝàm ngga? Ado ka awu nǝ nyar ɗǝm a nǝ ak dude mana munem yinǝi ka le?>> Rahila ama, <<Pam dude bǝti mana munio yinǝo wi ka, sǝ Yakupu ka, ɓǝ̀ nongnǝ we a dù man yalung ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lang Yakupu naban nyàrî ɓabondo nǝ pwarikpana mǝno ka, Liya lo wari a kuliè, sǝ banggi wi ama, <<A bù dù man yalung ngga a nǝ yiu, awu nǝ nong atàm, acemǝnana ǝn angŋa dǝmba ǝn mbwena aceo nǝ dude mǝnana munem yinǝi ka.>> Nda sǝ Yakupu nongnǝ Liya a bù mǝno yi dù ka. ");
INSERT INTO mbu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ɓakuli ok hiwi mala Liya; kum muna a bumi ɗǝm sǝ ɓǝlî Yakupu tongnoia muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Pǝlǝa Liya bang ama, <<Ɓakuli panam tangnakusǝam acemǝnana ǝn pe burém muna-ɓala mem ɓǝ̀ duk māmí ka.>> Nda tsǝki muna lullǝu ama Isaka. ");
INSERT INTO mbu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liya nyare kum muna a bumi ɗǝm, ɓǝlî Yakupu tongno-nong-mwashatia muna-ɓwabura. ");
INSERT INTO mbu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liya pǝlǝa bang ama, <<Ɓakuli panam ɓoro mǝɓoarne. Adyan ngga burém nǝ̀ nggǝ pakkam gìr nǝ gusǝlǝban, acemǝnana ǝn pani wi amuna-burana tongno-nong-mwashat.>> Nda tsǝki muna lullǝu ama, Zebulu. ");
INSERT INTO mbu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nǝnzǝ́mò ka Liya yi ɓǝl muna-ɓwama, sǝ tsǝki wi lullǝu ama, Dina. ");
INSERT INTO mbu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Pǝlǝa Ɓakuli ɗenyinǝ Rahila. Ok ɓua male, sǝ pe wi ɓwamuru mala ɓǝl amuna. ");
INSERT INTO mbu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Muna kpa a bumi, ɓǝl muna-ɓwabura sǝ bang ama, <<Ɓakuli pusǝ̀nam a kǝsǝkya mala do nkombi. ");
INSERT INTO mbu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ɓǝ̀ Mǝtalabangŋo kārǝàm ɓè muna-ɓwabura a ɓala mem.>> Pǝlǝa tsǝki muna lullǝu ama, Yisǝfu. ");
INSERT INTO mbu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Banì sau ɗang, anzǝm mǝnana Rahila ɓǝlna Yisǝfu ka, Yakupu banggi Laban ama, <<Nyem ɓǝ̀ ǝn o a là, a nzali mem. ");
INSERT INTO mbu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pàm amāmám andǝ amunèm, mǝnana ǝn pakko túró acea ka, sǝ wu ɗekiam mǝ bwal njar mǝ o. Ko nggearǝ we nǝ ɓamurò ka, a súrǝ́nà rǝ túró mǝcandǝe mǝnana ǝn pakko ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sǝ Laban ngga pè wi eare ama, <<Ida, ɓǝ̀ bumo pwasǝo arǝàm ngga, duk a kani, acemǝnana Mim ngga aɓa sǝnsǝna sǝ ǝn yi sǝlǝa ama Mǝtalabangŋo tsǝkam buì, àtàcau mò. ");
INSERT INTO mbu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Banggam, mana nda tangnakusǝo; gìr mǝnana kat a earce ka mǝ nǝ mbweo.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakupu pà eare ama, <<A sǝlǝna rǝ cê túró mǝcandǝe mǝnana ǝn pakko ka, sǝ a sǝlǝna ama adomwan mala agirkusǝu mô ka mǝ nda ǝn ɗenyi nǝia ka. A buàm sǝ à hatǝki. ");
INSERT INTO mbu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kaniama mǝ yiu a bano ka, agirkusǝu mô ka à nda bǝti, à làkkì ɗàng. Sǝ adyan, nǝ yiu mem ngga, gǝna andǝ kume mò gulna kpǝm. Mǝtalabangŋo tsǝ̀ngŋǝ́nò bù nǝ túró mǝnana kat ǝn pê ka. Sǝ ado ka, nǝ̀ ká aya pwari sǝ mǝ nǝ tita pàk gìr mala buam ace gulo mala ɓala mem gbal?>> ");
INSERT INTO mbu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ɗì ɗǝm ama, <<Shen sǝ a earce mǝ mbweo?>> Yakupu pè wi eare ama, <<Kǝa pam kǝgìr ɗàng. Gìr mwashat nda mǝnana awu nǝ pàkkam, sǝ mǝ nǝ lidǝmba nǝ ɗenyinǝ agirkusǝu mô ka. ");
INSERT INTO mbu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Came ɓǝ̀n pelǝki agirkusǝu arǝ adomwan mò yalung, ɓǝ̀n pusǝ koya nzur mǝnana ndanǝ abân mǝpǝndǝe arǝì, andǝ koya nzur mǝpǝndǝe aɓalǝ amuna-nzur, andǝ koya mbulpǝndǝa mǝnana ndanǝ aban mǝpwasǝe arǝì, ko amǝnana mùr rǝià na ɗàng-ɗáng ngga. Amǝnia ka à nda ka mǝnana awu nǝ pam mia, amala mbweban mem ngga. ");
INSERT INTO mbu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A dǝmba ka, ɓǝ̀ a yi sǝngi agirkusǝu mǝnana a pam mala mbweban ngga, a nǝ sǝlǝa ama ǝn tǝpǝrio ɗang. Sǝ ɓǝ̀ a kum aɓa domwan mem ambul-pǝndǝa mǝnana à pànǝ ban mǝpwasǝke arǝia, ko ana raka, anzur mǝnana amǝpǝndǝe na raka, anggo sǝ awu nǝ sǝlǝa ama ǝn iuwia arǝò.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban nyesǝi wi cau ama, <<E, ǝn earna ɓǝ̀ do anggo, kǝla mana a bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sǝama nǝ kǝ pwari mǝno ka, Laban wario kya pusǝki ambul-pǝndǝa kat, ajamne andǝ amǝ'nggaule mǝnana à ndanǝ abân mǝpwasǝe arǝia, sǝ pusǝki anzur mǝnana amǝpǝndǝe na ka, nyesǝia a bu amuna-burana male ɓǝà ɗenyi nǝia. ");
INSERT INTO mbu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Pǝlǝa twal gya mala anongŋo tàrú nǝ adomwan man upi ban mǝnana Yakupu duk kam ngga. Kat andǝ amǝno ka, Yakupu lidǝmba nǝ ɗenyinǝ cili agirkusǝu mala Laban. ");
INSERT INTO mbu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakupu pǝlǝa wario kya kasǝki agara mǝpwale mala nggun libǝne, andǝ mala nggun lus, andǝ mala nggun armon, sǝ komǝye ka fasǝki nggwate arǝ aɓea ban arǝì ɓǝ̀ lǝmdǝ abân mǝpwasǝe. ");
INSERT INTO mbu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pǝlǝa tsǝkia a ban ankenye-mùr mala agirkusǝu, ace mǝnana amunagara ka ɓǝà pa a ɓadǝmbǝ agirkusǝu ɓǝà nǝ̀ yiu a nu mur ka. Pè anggo acemǝnana agirkusǝu ka à kǝ eau rǝia ɓǝà yiu a nu mur ka. ");
INSERT INTO mbu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Lang agirkusǝu eau rǝia a ɓadǝmbǝ amunagara mǝno à fasǝkia a lǝmdǝ abân mǝpwasǝe andǝ mǝpǝndǝe arǝia ka, à ɓǝl amunia mana à ndanǝ abân mǝpwasǝe andǝ mǝpǝndǝe arǝia ka. ");
INSERT INTO mbu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakupu pusǝ amǝno yì amuna-nzur ka ɓǝà cam ɗàng, sǝ ɓǝà kǝa pà aɓa domwan mala Laban ɗàng. Ɓǝ̀ agirkusǝu nǝ̀ eau'eawe ka, Yakupu tsǝk anzur male mǝno ɓǝà sǝn ɓamǝsǝa rǝia andǝ agirkusǝu mǝnana a domwan mala Laban, amana à ndanǝ abân mǝpǝndǝe andǝ aban mǝpwasǝe arǝia ka. Anggo sǝ Yakupu kum male yì domwan, sǝ eare kpapia andǝ agirkusǝu mala Laban ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ɓǝ̀ bàkú eau'eawe mala agirkusǝu amǝ'rǝcandǝe karǝ ka, Yakupu nǝ̀ nongsǝ agara mǝno fasǝki rǝia ka a ɓadǝmbia aɓalǝ ankenye-mùr malea, ace mǝnana ɓǝà eau rǝia a ban agare ka. ");
INSERT INTO mbu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Sǝ ɓǝ̀ agirkusǝu mǝnana à pànǝ rǝcandǝa raka à nǝ̀ eau rǝia ka, kǝ pak mǝno ka ɗàng. Aɓa pě anggo ka agirkusǝu mǝnana à pànǝ rǝcandǝa raka, à nda ka mala Laban, sǝ amǝ'rǝcandǝe ka à nda ka mala Yakupu. ");
INSERT INTO mbu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Anggo sǝ Yakupu pǝlǝ mǝkume kǝ̀rkǝ́r. Yi dum nǝ adomwan mala agirkusǝu kpǝm, andǝ amǝ'túró-ɓala aburana andǝ amamǝna, andǝ akalakadambi andǝ adambǝritso. ");
INSERT INTO mbu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakupu ok ama amuna mala Laban ngga à nda ban bang ama, <<Yakupu pwana gìr mǝnana kat tár sǝm ndanǝi ka. Gǝna male kat ka kumi aɓa gìr mǝnana mala tár sǝm na ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Sǝ Yakupu sǝni ɗǝm ngga ɓamǝsǝ Laban panzǝ arǝì kǝla mǝnana kǝ pak ɗiɗyal ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Pǝlǝa Mǝtalabangŋo banggi Yakupu ama, <<Lo, nyare o a nzali la mala tárró, nzali mala akeo, andǝ mala aɓǝla mò, sǝ mim ngga mǝ pà atò.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nda Yakupu túrban atà Rahila andǝ Liya ɓǝà yiu ɓǝà yì kumi a ɓabondo a ban mǝnana kǝ yál domwan mala ambul male kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Banggia wia ama, <<Ən sǝni ka tár wun kǝ twalam ɗǝm nǝ earmúrú kǝla mana ɗiɗyal ka ɗàng. Sǝama, Ɓakuli mala tárrám ngga nda atàm. ");
INSERT INTO mbu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wun kǝm ngga wu sǝlǝna rǝ ulang túró mǝkǝ̀rkǝ́rnì mǝnana ǝn pakki tár wun nǝ rǝcandǝa mem kat ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kat andǝ amani ka, ɓǝmbǝriam, nggaɗi mbweban mem kusǝ lum. Sǝama Ɓakuli eari wi pàkkam kǝgìr mǝɓane ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ɓǝ̀ bang ama, <Ambul mǝnana rǝia pwasǝ ka à nǝ̀ duk mbweban mò> ka, kara domwan kat ka à ɓǝl amuna amǝ rǝpwasǝke. Sǝ ɓǝ̀ nggaɗi bumi sǝ bang ama, <Ambul mǝnana amǝ rǝ'nyoulǝke nda mǝ nǝ po à nǝ̀ duk mbweban mò> ka, kara domwan kat ka à ɓǝl amuna mǝnana amǝ rǝ'nyoulǝke na ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Anggo sǝ Ɓakuli fwa agirkusǝu mala tár wun sǝ pam mia. ");
INSERT INTO mbu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","<<A ɓè pwari, nǝ kún eau'eawe mala agirkusǝu, aɓa lòrǝo ǝn loasǝ mǝsǝam sǝ ǝn sǝni ka, agbato mǝnana à kǝ eau amǝ'nggaulea a domwan ngga, à nda ka mǝnana rǝia nyoulǝkya, andǝ amǝnana rǝia dok-dok, andǝ amǝnana rǝia mbulet-mbulet ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mǝturonjar mala Ɓakuli tunǝam aɓa mǝno yì lòrǝo ka ama, <Yakupu!> Sǝ ǝn eare nǝma, <Uong! Mǝ ndya ka.> ");
INSERT INTO mbu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Pǝlǝa banggàm ama, <Loasǝ mǝsǝo, sǝni, agbato mǝnana à kǝ eau amǝ'nggaulea a domwan ngga amǝnana rǝia nyoulǝkya, andǝ amǝnana rǝia dok-dok, andǝ amǝnana rǝia mbulet-mbulet ka à nda. Mǝ nda ban pak mǝnia ka ɓǝ̀ pa anggo acemǝnana ǝn sǝnǝna cè gìr mǝnana Laban kǝ pakko ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mǝ nda Ɓakuli mǝnana ǝn pusǝ rǝàm a bano a Betel, ban mǝnana a kwaki nggea tali sǝ a ɗārǝí nǝ mùrú, sǝ a pàcau nǝ-shambum abanam ngga. Adyan ngga, lo purî nzali mǝnia ka, nyare a nzali mô mǝnana à ɓǝ̀lo kam ngga.> >> ");
INSERT INTO mbu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahila andǝ Liya pè Yakupu eare ama, <<Ɓè kǝ kāmbe ko liɓala ueka sǝm a ɓala mala tár sǝm le? ");
INSERT INTO mbu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yàle yì ka kǝ pangnǝ sǝm kǝla sǝm nda ka amǝ'kúnɗàngna. Mak sǝm, sǝ gǝna mǝnana à pe wi amur sǝm ngga, kara lìnì arǝ sǝm. ");
INSERT INTO mbu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kume mǝnia mǝnana kat Ɓakuli fwê a bu tár sǝm ngga, ma'sǝma sǝnǝ amuna ma'sǝm. Acemani ka, lidǝmba pàk gìr mǝnana kat Ɓakuli banggo ama wu pe ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nda Yakupu eamsǝ amāmí andǝ amuni anzǝm akalakadambi ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Pwan agirkusǝu male kat andǝ agirkuma male mǝnana ramba a Padan Aram ngga. Pǝlǝa bwal njar aban o a nzali Kan'ana, nǝ̀ nyar aban tarrí Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Aɓa mǝno anggo ka Laban pà a là ɗàng. Umǝna a ban mǝnana à kǝ mwaki wi nyang anzur male ka, sǝ a nzǝmi ka Rahila iu aɓǝ̀nzál mala amǝɓala mala tarrí. Pwania umnǝia a bui. ");
INSERT INTO mbu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakupu ɓosǝki Laban ɓwa'Aram, eare ɓǝ̀ sǝlǝa ama kǝ umnǝ o ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakupu pwan agirkuma male kat sǝ bwal njar aban o akaurǝa. Wario kya yàllî Nggeasala Yiufǝretis, pǝlǝa tsǝkmuri aban o a Gilǝyat, nzali múr ankono. ");
INSERT INTO mbu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Anzǝm nongŋo tàrú ka, à banggi Laban ama Yakupu andǝ amǝɓala male ɓangŋǝna, à umǝna. ");
INSERT INTO mbu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nda pwan aburana male atè sǝ à lo ɓangŋa ta Yakupu. Twalia nongŋo tongno-nong ɓari sǝ à yi bwalte amúr ankono mala nzali Gilǝyat. ");
INSERT INTO mbu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","A bù dù mǝno ka, Ɓakuli pusǝrǝi aban Laban ɓwa'Aram aɓa lòrǝo, banggi wi ama, <<Nggǝ nunkiro, kǝa na ama awu nǝ ne Yakupu kǝ cau, ko mǝɓoarne ko mǝɓane ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakupu ka angŋa dǝmba à tsǝkina agumli malea amur ɓè nkono sǝ Laban yi kasǝmúrí. Sǝ yì Laban gbal andǝ aɓwana male ka, à yi tsǝkia malea yì agumli tù aban agumli do mala Yakupu akanó amur nkono a nzali Gilǝyat. ");
INSERT INTO mbu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban pǝlǝa ɗì Yakupu ama, <<Mana mǝnana a pak anggo ka? A ɓosǝkiam, a pwan amuna-mamǝna mem a ɓangŋa a umnǝia kǝla aguro mana à bwalia a kún lwa ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Palang sǝ a pakkam kutan, a swárô a o aɓa sǝmbǝrǝa? Palang sǝ a ɓinǝ banggàm ama a ndo a nǝ o, sǝ anggo ka ɓǝ́ mǝ nǝ tsǝkto nǝ banɓoarnado mala li girlina pakkiɗire, andǝ nggyal, andǝ nggwam mǝnana àkǝ te nǝ walki aɓǝm, andǝ azangŋan ngga? ");
INSERT INTO mbu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A earam mǝ bwal amunem andǝ amǝ'kem mǝ kùria arǝàm mǝ tsǝiandà ɗàng. We ka, a pángŋǝ̀nà ɓwaɓana! ");
INSERT INTO mbu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mǝ ndanǝ rǝcandǝa mala pàkkô mǝɓane, sǝama, Ɓakuli mala tárró lǝmdǝ rǝi abanam nǝ bu du mana kútí ka, aban nunkiram ama mǝ kǝa nô kǝcau, ko mǝɓoarne ko mǝɓane ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ən sǝlǝna nǝma a o acemǝnana ɓabumo kǝ pi arǝ earce nyare a ɓala mala tárró. Sǝ ace mana sǝ a iu aɓǝ̀nzál mem?>> ");
INSERT INTO mbu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakupu pe Laban eare ama, <<Ən o aɓa sǝmbǝrǝa acemǝnana ɓangciu pakkam. Ən twali nǝma a nǝ ak amuna-mamǝna mô arǝàm nǝ rǝcandǝa. ");
INSERT INTO mbu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Sǝ cau mala aɓǝ̀nzál mô ka, ɓwa mǝnana kat a kumi nǝ agirnì a bui ka, à nǝ̀ wal-luí. A ɓadǝm aɓǝla ma'sǝm akani, sǝngiaban nǝ nggearǝo ko awu nǝ kum ɓè kǝgir mǝnana mò na ka; sǝ ɓǝ̀ a kum ngga, twali.>> Sǝ Yakupu ka sǝlǝ ama, Rahila iuna amǝno yì aɓǝ̀nzál mala tarrí Laban ngga ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Pǝlǝa Laban kùtí altaban aɓa gumli mala Yakupu, andǝ ɓá gumli mala Liya, andǝ mala amuna-mamǝna amǝ'túró-ɓala malea, sǝ ko kum kǝgìr ɗàng. A masǝlǝate ka, yi kúti aɓa gumli mala Rahila. ");
INSERT INTO mbu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Yì Rahila ka angŋa dǝmba twalna aɓǝ̀nzálnì oasǝnia aɓa luru gyare arǝ buno-nzǝm kalakadambi sǝ nda aban do amúrià. Laban alta ban aɓa gumli kat, sǝ ko kum kǝgìr ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahila banggi tarrí ama, <<Dâ, ida bumo ɓǝ̀ kǝa lúllô arǝàm acemǝnana ǝn gandǝ lo ǝn cam nǝ came a ɓadǝmbo ǝn po gulo raka; mǝ nda aɓa bumkwana mem.>> Anggo sǝ Laban lidǝmba nǝ altaban sǝ kum amǝno yì aɓǝ̀nzál ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kara Yakupu pàk bumlulla, munǝki arǝ Laban ama, <<Ya gìr mǝɓane na mǝnana ǝn pak ka? Ya cauɓikea na mǝnana ǝn pa, sǝ a lo atam ngga? ");
INSERT INTO mbu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ado mǝno a sǝnginaban aɓalǝ agir mem kat ka, ya gìr ɓala mò na a kumô? Tsǝk gìrnî kani a ɓadǝm aɓwana mô andǝ amem, sǝ yia ka ɓǝà gau cau, ɓǝà kasǝ cè mǝnana a nre sǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","<<Ən dumǝna sǝnǝ we bwalna pǝlǝa lumi-ɓari adyan. Atà anzur andǝ ambul-pǝndǝa mô ka, kǝ ɓè sulǝmuna ɗang, sǝ yàle ǝn shak ma atà agam a domwan mò ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Pwari mana kat nyamɓikea wal mwashat atà agirkusǝu mò, ko bwali san ɓè bare ka, ǝn yiu ma nǝi a bano ǝn lǝmdǝo ɗàng. Ən twal mǝno yì ɗwanyi ka amuram. Ɓǝ̀ aya pwari sǝ à iu mwashat atà agirkusǝu mô, ko nǝ du ko nǝ pwari ka, a ɗice mǝ mbwe nǝ ɓe a kúnì aɓalǝ agirkusǝu mem. ");
INSERT INTO mbu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ən camarǝ pakko túró nǝ tanni aɓa banpina nǝ pwari zǝkya, aɓa ɗwal andǝ ɗwanyi nong'ntullo nǝ du. ");
INSERT INTO mbu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","E, apǝlǝa lumi-ɓari ǝn pak túró guro a ɓala mò. Ən pak túró mala apǝlǝa lum-nong-ine ace al amuna-mamǝna mô ɓari, sǝ apǝlǝa tongno-nong mwashat ace kum anzur andǝ ambul-pǝndǝa mǝnia a pam a domwan mò ɓǝà do nda mbweban mem ngga. Aɓalǝ apǝlǝa mǝno mǝ nda aban pakko túró ka, a camarǝ nggaɗiki mbweban mem kusǝ lum! ");
INSERT INTO mbu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ɓǝ̀ pà ama Ɓakuli mala kèm Ibǝrayim, yì Ɓakuli mana tárrám Ishaku kǝ ɓanggi wi ka, pang ma atàm raka, ɓǝ́ a tasǝnatam nǝ ɓabuam atàrǝì. Sǝama Ɓakuli sǝnǝna tanni mem andǝ túró mǝnana ǝn pe nǝ buam ngga. Nda gìr mǝnana tsǝa nǝ bu du mana yilung ngga Ɓakuli pak ɓashi male, nunkiro ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban pǝlǝa pè wi eare ama, <<Amamǝna mǝnia ka amunem na, sǝ amuna ka amǝ'kem na, sǝ adomwan mala agirkusǝu gbal ka, amem na. Yàle agir mǝnana kat a sǝnia kani ka, amem na. Sǝ mana girni mǝ nǝ gandǝ pa ace amunem andǝ amunia mǝnana à ɓǝlki ka? ");
INSERT INTO mbu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yiu ɓǝ̀ sǝm kùrcau, mim sǝ we. Mǝnia ka nǝ̀ lǝmdǝ ama eare nakam a nre sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nda Yakupu twal tali kwákítè ɓǝ̀ cam nǝ came a nzali ɓǝ̀ duk tali-kwakya. ");
INSERT INTO mbu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Sǝ banggi aɓwana male, amǝɓala male, ama, <<Wu pwangi amuna-tali, wu ramgia.>> Pǝlǝa à ramgi atali, à eamsǝia amur rǝarǝia. Pǝlǝa Yakupu andǝ Laban dumnǝdo a ban atali mǝnana a eamsǝia amur rǝarǝia ka, sǝ à li girlina atārǝia. ");
INSERT INTO mbu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban tunǝ banì ama, Jegar-Sahaduta, sǝ Yakupu ka tunǝi ama, Galiyet. ");
INSERT INTO mbu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Pǝlǝa Laban ham ama, <<Mǝnia yì atali à rambia ka, à nǝ̀ duk gir nakún mala kùrcau ma'sǝm yalung.>> Nda gìr mǝnana tsǝa sǝ tunǝ banì ama, Galiyet ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban ɗǝm ngga bang ama, <<Yahweh ɓǝ̀ tsǝk mǝsǝi arǝ sǝm, mim sǝ we, ace mǝnana ɓǝ̀ sǝm bwal mǝnia yì kùrcau, anzǝm mǝnana sǝm gauni tarǝ sǝm ngga. Acemani ka tunǝ banì ɗǝm ama Mizǝpa. ");
INSERT INTO mbu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ɓǝ̀ a pakki amuna-mamǝna mem gìr mǝɓane, ko a al aɓea amamǝna amúrià sǝ ko ǝn sǝlǝce raka, ɗenyi ama Ɓakuli ka nda mǝ'nakún a nre sǝm sǝnǝ we.>> ");
INSERT INTO mbu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban nyare banggi Yakupu ama, <<Sǝn atali mǝnia à gwalikia ka pepè, sǝ sǝn nggea tali mǝnia ǝn kwakì a nrem sǝnǝ we ka pepè. ");
INSERT INTO mbu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mǝnia yì atali à gwalì ka à dumǝna gìr nakún, sǝ mǝnia yì tali kwaki ka dumǝna gìr nakún. À nǝ̀ came kǝla agir kasǝɓalǝu ama pà mǝ nǝ yàllî ban mala atali mǝnia à gwalì ka aban ká a nzali mô ace pakko mǝɓane ɗàng, sǝ we gbal ka a pa wunǝ yàllî mǝnia yi nzong, ban mala atali mǝnia à gwalì andǝ tali mǝnia kwakì ka aban ká a nzali mem ace pakkam mǝɓane ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ən nggǝ tunǝ Ɓakuli mala keò Ibǝrayim andǝ aɓakuli mala kèm Naho, yia aɓakuli mala tárrià ɓǝà pàk ɓashi a nre sǝm.>> Pǝlǝa Yakupu pàcau nǝ kángìr aɓa lullǝ Ɓakuli mǝnana tárrí Ishaku kǝ ɓanggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakupu pwan-myal girkusǝu pana gìr'nkila nǝi a kǝ banì, amur nkono mǝno, sǝ tunǝ aɓwana male ɓǝà yiu ɓǝà yi li girlina. Lang à lina girlina ka, à nong kano amur nkono bankwaria. ");
INSERT INTO mbu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nǝ bu dǝmbari ɗiɗyal ka, Laban yi kùr amǝkè andǝ amuni amuna-mamǝna zǝp nǝ abui, tsǝkia wia bù sǝ tsǝiandà, pǝlǝa bwal njar nyare o a nzali male. ");
INSERT INTO mbu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Lang Yakupu bwalǝna njar aban lidǝmba nǝ gya male ka, amǝturonjar mala Ɓakuli yi kumi. ");
INSERT INTO mbu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Lang sǝnia ka, bang ama, <<Ban mǝnia ka kàttì mala Ɓakuli na!>> Pǝlǝa tunǝ banì ama, Mahanayim. ");
INSERT INTO mbu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakupu tasǝ amǝ'na-túrbân, à aki wi dǝmba à wari aban mǝ'eambi Isǝwa, mǝnana ndanǝ do a buban Seyir, a nzali Edom ngga. ");
INSERT INTO mbu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kwarkiria ama, <<Mǝnia ka nda cau mǝnana wun nǝ̀ banggi ɓwamǝgule mem, Isǝwa ka: <Guro mò Yakupu kǝ bang ama, ǝn o a bǝri a ban Laban sǝ ǝn kya do atè bà pwari man yalung ngga. ");
INSERT INTO mbu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mǝ ndanǝ andá, andǝ adambǝritso, andǝ anzur, andǝ ambul-pǝndǝa, andǝ amǝ'túró-ɓala, amamǝna andǝ aburana. Ən nggǝ tasǝ cau mǝnia ka a bano ɓwamǝgule, ace alta ɓwamuru mala kum akban a bano.> >> ");
INSERT INTO mbu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Anzǝm mana amǝ'na-turbanì kya nana kún-turban mǝnana à túriá nǝi sǝ à nyarǝna aban Yakupu ka, à yi banggi wi ama, <<Sǝm wari aban mǝ'eambo, yi Isǝwa, sǝ bangga sǝm ama nda a njargula aban yiu a bano, atārǝia andǝ aburana male gbǝman-ine atè!>> ");
INSERT INTO mbu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nǝ ɓangciu arǝì andǝ ɓālǝkasǝkya, Yakupu pǝlǝa gau aɓwana mǝnana atè ka arǝ abanì ɓari. Anggo gbal sǝ gau adomwan mala anzur, andǝ ambul-pǝndǝa, andǝ andá, andǝ mala akalakadambi. ");
INSERT INTO mbu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ɗenyicau male ka nda mǝnana ama, <<Ɓǝ̀ Isǝwa yiu nǝ munǝo arǝ banì mwashat mala aɓwana andǝ agirkusǝu male ka, ɓè banì man mwashat ka nǝ̀ gandǝ ɓangŋa nǝ̀ àwá.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Pǝlǝa Yakupu pakhiwi ama, <<We Ɓakuli mala kèm Ibǝrayim, sǝ Ɓakuli mala tárrám Ishaku, We Mǝtalabangŋo, mǝnana a banggàm ama, <Nyare o a nzali mô, aban aɓwana mô, sǝ mǝ nǝ pakko mǝɓoarne> ka. ");
INSERT INTO mbu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ən kārǝa mǝ nǝ kum pěmǝɓoarne andǝ domǝsǝcau mǝnana a lǝmdǝam, yi mim guro mò ka ɗàng. Acemǝnana ɗiɗyal mana ǝn nying là, ǝn yi yàl a nkaring Nggeasala Jodan ngga, kǝ mǝgara nda gìr mǝnana mǝ ndanǝi a buam ngga. Sǝ adyan ngga, mǝ ndya nǝ agirkuma à lùmsǝ kàttì ɓari ka! ");
INSERT INTO mbu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ida, amsǝam a bu mǝ'eambam, Isǝwa, acemǝnana ɓangciu kǝ pakkam ama, ndo nǝ̀ yiu nǝ munǝo arǝàm, mim sǝnǝ anggea ka amuna andǝ amuna. ");
INSERT INTO mbu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A bangŋǝna ama, <Nǝ mǝsǝcau, mǝ nǝ tsǝko bu, mǝ nǝ pakko mǝɓoarne, amǝkeo nǝ̀ làkkì pas kǝla mǝsǝsala mala nggeamùr, mǝnana à pà nǝ̀ gandǝ ɓallia raka.> >> ");
INSERT INTO mbu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakupu nongŋo akǝ banì mǝno ka a dù mǝno. Pǝlǝa tàr aɓea girkusǝu ace paɓoro aban mǝ'eambi, Isǝwa ani: ");
INSERT INTO mbu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ambul-pǝndǝa amǝ'nggaule gbǝman-ɓari sǝ agbato lumi-ɓari, anzur amǝ'nggaule gbǝman-ɓari, andǝ agam lumi-ɓari, ");
INSERT INTO mbu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","akalakadambi amǝ'nggaule lumi-tàrú andǝ amunia, andǝ andá lumi-ine, andǝ ajamnda lum, andǝ amǝdambǝriso amǝ'nggaule lumi-ɓari, sǝ amǝdambǝriso ajamne lum. ");
INSERT INTO mbu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Pǝlǝa gaki agirkusǝu mǝnia ka arǝ adomwan, sǝ pà koya domwan a bu amǝ'túró-ɓala male ɗàngɗáng. Banggia wia ama, <<Wu akàm dǝmba, wu um nǝ agirkusǝu, sǝ a ká ma'wun ngga, wu kǝa gbashi tarǝ wun ɗàng. Nreban ɓǝ̀ nong zak a nre domwan andǝ domwan mala agirkusǝu.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakupu pǝlǝa kwarkir mǝtúró-ɓala mǝnana nda a dǝmba ka ama, <<Ɓǝ̀ a yi jena wunǝ mǝ'eambam Isǝwa, sǝ ɗio ama, <A nda mǝtúró-ɓala mala yana? Sǝ a nǝ ká ke? Sǝ yana nda mǝtala agirkusǝu mǝnia a ɓadǝmbo ka?> ");
INSERT INTO mbu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Pǝlǝa awu nǝ pe wi eare ama, <Amala guro mò Yakupu na. Ɓoro na túrnaban nǝi aban ɓwamǝgule male, Isǝwa. Sǝ yì Yakupu ka nda kǝ yiu anzǝm sǝm ngga.> >> ");
INSERT INTO mbu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nǝ kǝ kwarkiru mǝno ka Yakupu kwarkir ɓaria, andǝ tàruia, andǝ acili amǝ'túró-ɓala gbal mǝnana tsǝia à kǝ pǝ̀r adomwan ngga ama, <<Wun nǝ̀ banggi Isǝwa kǝ cau mǝ'mwashati ɓǝ̀ wu jena wunǝi ka, ");
INSERT INTO mbu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","sǝ wun nǝ̀ banggi wi ɗǝm ama, <Sǝni guro mò Yakupu ka ndya kǝ yiu anzǝm sǝm ngga.> >> Yakupu pàk ɗenyicau ama, <<Mǝ nǝ ɓariki mǝ nǝ pwasǝlǝ ɓabumi nǝ agir ɓoro mǝnana mǝ nǝ ak dǝmba mǝ nǝ tasǝi wi ka. Sǝ nǝnzǝ́mò, ɓǝ̀ ǝn yiu ǝn yi kumi ǝn sǝn ɓamǝsǝi ka, yakǝla nǝ̀ eam nǝ dotarǝu.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Anggo sǝ aɓoro ak dǝmba aban ká a ɓadǝmbi, sǝ yì Yakupu nǝ ɓamúrì ka, ueo anzǝ́mò, nongŋo aɓa gumli a ban mǝno sulǝ kam ngga a dù mǝno. ");
INSERT INTO mbu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nǝ bu du mǝno ka, Yakupu lo, twal amāmí mǝnana ɓari ka, andǝ amamǝna amǝ'túró-ɓala male mǝnana ɓari ka, andǝ amuna-burana male yia lum-nong-mwashat, pǝlǝa à sulǝo a Mùr Jabok a ban mǝnana lim raka sǝ à eauwe a ɓè nkaring. ");
INSERT INTO mbu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Lang eamsǝnia à eauna a nkaring Mùr Jabok ka, pǝlǝa tasǝ acili agirkuma male kat à eauwe a nkaring ateà, ");
INSERT INTO mbu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","sǝ yì ka ueo anzǝ́mò, nǝmurǝì. Kara ɓe ɓwa yiu, à warwara andǝi bà kwaro mala ban. ");
INSERT INTO mbu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Lang ɓwe sǝni gandǝ mak Yakupu nǝ wara raka, pǝlǝa tùl mú nkpakota Yakupu, kara nkpako ɓuni songŋo. ");
INSERT INTO mbu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ɓweni bang ama, <<Nyem, ɓǝ̀ ǝn o, acemǝnana ban malanǝ̀ kwaro!>> Sǝ Yakupu ka pǝlǝi wi ama, <<Pà mǝ nǝ ɗekio wu o ɗang, she ɓǝa tsǝ́ngŋǝ̀nàm bù ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Pǝlǝa ɓweni ɗì ama, <<Lùllǝò ɗe a mana?>> Pǝlǝa pe wi eare ama, <<Yakupu.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ɓweni banggi wi ama, <<À pà nǝ̀ tunǝo ɗǝm ama Yakupu ɗàng; twal adyan ngga à nǝ̀ nggǝ tunǝo ama, Isǝrayila, acemǝnana a warwara wunǝ Ɓakuli andǝ aɓwapǝndǝa, sǝ rǝcandǝa mò amsǝ ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakupu na ama, <<banggàm lùllǝò pé.>> Pǝlǝa ɓwenî ɗì ama, <<Ace mana sǝ a kǝ earce súrǝ̀ lullǝam?>> Pǝlǝa tsǝki Yakupu bù abanì. ");
INSERT INTO mbu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakupu bang ama, <<Ən sǝna Ɓakuli a ɓamǝsǝi, kat andǝa mani ka, yilǝmem kum àwá.>> Pǝlǝa Yakupu tsǝki banì lullǝu ama, Penǝyel. ");
INSERT INTO mbu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Pwari na aban eauwe, yi mana Yakupu nǝ nggǝ nying Penǝyel aban o ka. Kǝ zanggǝɗi aban gya, ace npenye mǝnana kúmô a nkpakote ka. ");
INSERT INTO mbu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nda gìr mǝnana tsǝa bà yalung amǝ Isǝrayila kǝ li mazo nkpakota koya nyama raka, ace gìr mǝnana kum Yakupu, à tùllì amur mazo nkpakote ka. ");
INSERT INTO mbu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakupu loasǝ mǝsǝi sǝn Isǝwa aban yiu, yì andǝ aburana male gbǝman-ine. Pǝlǝa gakkia amuna a nre ka Liya, andǝ Rahila, andǝ amamǝna ɓari amǝ'túró-ɓala male. ");
INSERT INTO mbu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Tsǝk amamǝna amǝ'túró-ɓala andǝ amunia a dǝmba, sǝ Liya andǝ amuni kpatea, sǝ Rahila andǝ muni Yisǝfu masǝlǝia wia a nzǝ́mò. ");
INSERT INTO mbu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Sǝ yì Yakupu nǝ nggearǝì ka akia wia dǝmba aban ká. Lang gbàshìnà ban mǝ'eambi ka, kara ɓunbî wi kusǝ tongno-nong-ɓari a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Sǝ Isǝwa ka ɓangŋa aban yiu abani, soak abui a myali, kùrì zǝp. Yià kǝm ngga, à túr kunia aban ɓua. ");
INSERT INTO mbu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Lang Isǝwa loasǝ mǝsǝi sǝn amamǝna andǝ amuna ka, pǝlǝa ɗì Yakupu ama, <<A yana mǝnia wu nda wunǝia ka?>> Yakupu pǝlǝa pe wi eare ama, <<Amuna na mǝnana Ɓakuli ɓwamur guro mò pe wi ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Pǝlǝa amamǝna amǝ'túró-ɓala andǝ amunia yiu à yi ɓun a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Anggo sǝ Liya andǝ amuni kpatea, à yiu à yi ɓun a nzali a ɓadǝmbi. A masǝlǝate ka, Yisǝfu, sǝ Rahila, yia gbal ka, à yiu à yi ɓun a nzali a ɓadǝm Isǝwa. ");
INSERT INTO mbu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isǝwa ɗì Yakupu ama, <<Man nda ɓalǝ amǝnia yia girkusǝu andǝ adomwan ǝn je sǝnǝia aban yiu ka?>> Yakupu pe wi eare ama, <<Aɓoro na ǝn yinǝo wia ka, ace kum ɓwamuru andǝ akban a bano, we ɓwamǝgule mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Sǝ Isǝwa ne wi ama, <<Mǝ'eambam, mǝ ndanǝ agir kpǝm mǝnana à kàrǝ́nǎm ngga. Bwal agir mǝnana amô na ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakupu ɓinǝi wi ama, <<Awo, ɓǝ̀ ǝn kumǝna earmúrú a bano ka, ida ak mǝnia yi ɓoro ka a buam. Acemǝnana, sǝna mǝno ado ǝn sǝn ɓamǝsǝo sǝ a angŋǝnam ngga, nda kǝla ǝn sǝna ɓamǝsǝ Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ən nggǝ zǝmbo, ak ɓoro mǝnia ǝn yinǝo nǝi ka, acemǝnana Ɓakuli ka lǝ́mdǝ́nàm pěmǝɓoarne male kǝ̀rkǝ́r sǝ pànâm koman mǝnana kat ɓoaro ɓǝ̀n pang nǝi ka.>> Sǝ acemǝnana Yakupu camarǝ pità Isǝwa ka, a masǝlǝate ka, Isǝwa eare ak aɓoronì. ");
INSERT INTO mbu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pǝlǝa Isǝwa bang ama, <<Ado ka wu fa, ɓǝ̀ sǝm twal gya ɓǝ̀ sǝm o. Mǝ nǝ dupa wun a dǝmba.>> ");
INSERT INTO mbu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sǝ Yakupu eari wi ama, <<Ɓwamǝgule mem, a sǝlǝna ama, aɓea amuna atà sǝm ngga à ɓiki keke, sǝ adomwan mala ambul andǝ andá gbal ka à ndanǝ amunia ateà mǝnana à nda kúnkiura ka. Dumǝna púp mǝ nǝ ɗenyi nǝia. Ɓǝ̀n pǝrtea akaurǝa, ko ɓǝ̀ mala nongŋo mwashat na ka, à nǝ̀ wuki kat. ");
INSERT INTO mbu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nggǝ zǝmbo, ɓǝ̀ nǝ̀ ɓoar ka, ɓwamǝgule mem, ak dǝmba o. Sǝm nǝ̀ nggǝ kpato ɓukɓuk aban yiu, nǝ gya mǝnana pà nǝ̀ kwanbi agirkusǝu andǝ amuna raka. Mǝ nǝ nggá kúmǒ a Seyir.>> ");
INSERT INTO mbu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isǝwa pǝlǝa eare ama, <<Ida, ɗeki lâ ɓǝ̀n nying aɓea burana mem atà wun.>> Yakupu pǝlǝi wi ama, <<Awo, sheɓǝ̀ a pángŋǝ̀nà anggo ka ɗàng. Mim ngga earmúrú a bano na ǝn earkiyice mǝ kum ngga, ɓwamǝgule mem!>> ");
INSERT INTO mbu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Pǝlǝa Isǝwa nyare a kusǝì a kǝ pwari mǝno aban o a Seyir. ");
INSERT INTO mbu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sǝ Yakupu ka, o a Sukkot. Akano ka kya pakki ɓamúrì bando, sǝ tǝmgi atara ace agirkusǝu male. Nda gìr mǝnana tsǝa sǝ à tunǝ banì ama, Sukkot ka. ");
INSERT INTO mbu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Anzǝm mana Yakupu nyìngŋǝ̀nà Padan Aram ngga, yiu jam a nggea-là Shekem, a nzali Kan'ana. Akano sǝ tsǝk kàttì nǝ agumli male, duk kam a nzǝm la. ");
INSERT INTO mbu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Pǝlǝa Yakupu kúr nzali mǝno tsǝk agumli male kàm ngga; kúrí a bù amuna-burana mala Hamo, tár Shekem, a kún mǝsǝ bolo-azǝrfa gbǝman-mwashat. ");
INSERT INTO mbu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A kǝ ban mǝno, Yakupu ɓak gyangŋan, pǝlǝa tunǝi ama, El Elohe Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","A ɓè pwari ka, Dina muna-ɓwama mala Liya, mǝnana à ɓǝl andǝ Yakupu ka, lo wari ama nǝ̀ nggá sǝn aɓi ansarina mǝnana à do a bu-nzali mana à ndakam nǝ do ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Lang Shekem, muna-ɓwabura mala Hamo ɓwa Hivi, mǝnana nda murǝm mala mǝno yì bu-nzali, nǝ sǝn Dina ka, kara bwali nǝ rǝcandǝa pàngŋǝ̀nà ɓwama nǝi, kìɗikì. ");
INSERT INTO mbu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sǝ yì Shekem ngga, cè ɓwama Dina, muna mala Yakupu ɓoari wi, pǝlǝa ɓariki nǝ̀ tsǝa ɓǝ̀ ɓwama earì; ne wi cau ɓukɓuk nǝ kún lǝmdǝ earban, ɓǝ nuni arǝì. ");
INSERT INTO mbu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Pǝlǝa Shekem ne tarrí Hamo, ama, <<Ən nggǝ earce nǝma wu alàm muna-ɓwama man ɓǝ̀ duk māmám.>> ");
INSERT INTO mbu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakupu yi ok ama Shekem kìɗìkìna muna-ɓwama male Dina, sǝ acemǝnana amuni amuna-burana à nda a ɓabondo aban yál agir ka, na kǝ cau ɗàng. Kúndǝô she ɓǝà nyàrnà ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamo, tár Shekem, puro wari aban Yakupu nǝ̀ nggá bangcau nǝi amur cenî. ");
INSERT INTO mbu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anggo ka, amuna-burana mala Yakupu nyàrǝ́nì ɓabondo. Lang à ongŋǝna ama à kìdìki mǝ'eambia muna-ɓwama ka, gìrnî kwanrǝia, sǝ à pàk bumlulla kǝ̀rkǝ́r nǝ man yì gìr Shekem pè, mǝnana ɓoaro ɓǝà pè raka; nggea gìr pà kǝsǝkya arǝ aɓwana mala Isǝrayila na, mǝnana kìɗìki mǝ'eambia muna-ɓwama mala Yakupu ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sǝ Hamo ka bang cau nǝ Yakupu andǝ amuna-burana male. Banggia wia ama, <<Muna-ɓwabura mem Shekem, nǝ mǝsǝcau ka, kǝ earce muna-ɓwama ma'wun, sǝ ɓabumi kat umǝna arǝì. Ɓǝ̀ wun nǝ̀ earka, ida, wu pè wi ɓǝ̀ ali. ");
INSERT INTO mbu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ɓǝ̀ sǝm eare alban ɓǝ pà a nre rǝarǝ sǝm. Wu pà sǝm amuna-mamǝna ma'wun, sǝ sǝm nǝ̀ pà wun amuna-mamǝna ma'sǝm. ");
INSERT INTO mbu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wun nǝ̀ gandǝ do akani aɓalǝ sǝm a nzali ma'sǝm. Wu do sǝ wu gya a koya ban wu earce ka, wu pàk nggaliki atà sǝm, wu kúrki anzali sǝ wu ɓakki aɓala ɓǝà duk agirkuma ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Pǝlǝa Shekem nacau nǝ tár Dina andǝ amǝ'eam Dina ama, <<Ən nggǝ zǝmba wun, wu lǝmdǝàm earmúrú, wu earâm ɓǝ̀n al Dina. Mǝ nǝ pa wun gìr mǝnana kat wu ɗìce ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ko ɓǝ̀ mana nda gǝna mǝnana wun nǝ̀ kasǝa, andǝ agir mana mǝ nǝ mbwe amur ɓwama ka, mǝ nǝ yia mbwe nǝ banɓoarnado, ɓǝ̀ wun nǝ̀ pam muna-ɓwama man ɓǝ̀ duk māmám ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Amuna-burana mala Yakupu pa kǝla à earǝna. À nyesǝî Shekem andǝ tárrí Hamo cau nǝ kún ɓosǝkiban, acemǝnana kìɗìkìna mǝ'eambia, yi Dina. ");
INSERT INTO mbu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","À banggia wia ama, <<Pà sǝm nǝ̀ eare ɓǝ̀ sǝm al wun ɗàng, acemǝnana wun ngga, à kasǝa wun ɓata wun ɗàng; gìr kǝsǝkya na aban sǝm, ɓǝ̀ mǝ'eam sǝm muna-ɓwama al ɓwa mǝnana à kasǝî wi ɓate raka! ");
INSERT INTO mbu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Gìr mwashat nda mǝnana nǝ̀ tsǝa sǝ sǝm nǝ̀ eara wun ngga: ɓǝ̀ wun mǝnana kat wu nda ka aburana, à nǝ̀ kasǝa wun ɓata wun, kǝla mana sǝm ngga à kasǝa sǝm ɓata sǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Anggo sǝ sǝm nǝ̀ pà wun amuna-mamǝna ma'sǝm, sǝ wun gbal ka, wun nǝ̀ pà sǝm amuna-mamǝna ma'wun. Sǝm nǝ̀ do atà wun, sǝ sǝm sǝnǝa wun ngga, sǝm nǝ̀ duk aɓwana amǝ'mwashati. ");
INSERT INTO mbu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sǝ ɓǝ̀ pà wun nǝ̀ eare anggo, à nǝ̀ kasǝa wun ɓata wun raka, sǝm nǝ̀ twal mǝ'eam sǝm, sǝm nǝ̀ bwal njargula, sǝm nǝ̀ o.>> ");
INSERT INTO mbu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Acau mǝnia ka à ɓoarì Hamo andǝ muna-ɓwabura male Shekem. ");
INSERT INTO mbu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sǝ yì lagga Shekem ngga, kìɗìki pwari arǝ pak gìr mǝnana à earce ama ɓǝ̀ pàk ka ɗàng, acemǝnana kǝ earce Dina muna-ɓwama mala Yakupu nǝ rǝɓǝla, sǝ ɗǝm ngga yì nda ɓwa mǝnana à kǝ pe wi gulo kútì acili aɓwana kat a ɓala mala tárrí ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Pǝlǝa Shekem andǝ tárrí Hamo lo à wari aban kpapi-kùrcau mala là a kún nggea-là. À kya bang cau nǝ aɓwana-mǝgule mala là malea ama: ");
INSERT INTO mbu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","<<Aɓwana mǝnia ka, amǝ do ɓa-rǝpwala nǝ aɓwana na; ɓǝ̀ sǝm earia wia ɓǝà duk kani aɓalǝ sǝm, ɓǝà gya koya ban à earce ká a nzali ma'sǝm ngga. Nzali ka gul kpǝm nǝ̀ karǝ sǝm sǝnǝia. Sǝm nǝ̀ al amuna-mamǝna malea, sǝ yia gbal ka, à nǝ̀ al ama'sǝm yì amuna-mamǝna. ");
INSERT INTO mbu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Gìr mwashat mǝnana à bang ama sǝm nǝ̀ pa sǝ à nǝ̀ eare à nǝ̀ do aɓalǝ sǝm, sǝ sǝm nǝ̀ duk aɓwana mwashat sǝnǝia ka, nda mana ama koya ɓwabura atà sǝm ngga, ɓǝà kasǝî wi ɓate, kǝla mana yia gbal ka à kasǝ ɓatea ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ɓǝ̀ sǝm pa anggo ka, adomwan mala andá malea, andǝ agirkuma malea, andǝ agirkusǝu malea kat nǝ̀ duk ama'sǝm. Acemani ka, ɓǝ̀ sǝm eare ɓǝ̀ sǝm pàk gìr mǝnana à earkiyice nǝ sǝm ɓǝ̀ sǝm pàk ka, sǝ yia ka à nǝ̀ eare à nǝ̀ do aɓalǝ sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aɓwana mǝnana kat à puro sǝ à wari a kún nggea-là ka, à earnǝ cau mala Hamo andǝ mala muni Shekem. Koya ɓwabura andǝ muna-ɓwabura mǝnana à nda kǝ là mǝno ka, à kasǝî wi ɓate. ");
INSERT INTO mbu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nongŋo tàrú anzǝm mǝno, lang penye mala kasǝ-ɓatau nggeangsǝkina, sǝ à nda ɓá kwanban più ka, ɓari atà amuna-burana mala Yakupu, yì Shimiyon andǝ Lawi, amǝ'eam Dina, twal anggea-byau malea, sǝ à wario à kya kúti aɓa nggea-là hamama. Pǝlǝa à wal-lú koya ɓwabura a mǝno yì nggea-là ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","À wal-lú Hamo andǝ muni Shekem gbal nǝ anggea-byau malea, sǝ à pusǝ mǝ'kyauwea, Dina a ɓala mala Shekem, sǝ à puro à o a là-gumli malea. ");
INSERT INTO mbu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Anzǝm mǝno ka, acili amuna-burana mala Yakupu yi tusǝo. Lang à yi sǝn alú aburana mǝnana à walia ka, kara à kutio à pwan kume mala là mǝno ka, atàcau mala mǝ'kyauwea muna-ɓwama mǝnana à kìɗikì ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","À pwan ambul, andǝ andá, andǝ adambǝritso malea, mǝnana à kumia aɓa nggea-là, andǝ amǝnana a nzǝm la andǝ ɓabondo ka. ");
INSERT INTO mbu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","À pwan gǝna mala aɓwana mala là mǝno kat, andǝ agir mǝnana kat arǝ aɓala malea ka. À bwalki amamǝna malea kat andǝ amuna à umnǝia. ");
INSERT INTO mbu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nǝnzǝ́mò ka Yakupu ne Shimiyon andǝ Lawi ama, <<Wu kùmǝ́nàm cau! Wu tsǝ̀ngŋǝ̀nám aɓwana mala nzali mǝnia nǝ̀ ɓinǝcem, yià amǝ'Kan'ana andǝ amǝ'Periz. Mǝ nda bǝti, ǝn làkkì ɗàng; ɓǝà ram rǝia sǝ à yiu nǝ munǝo arǝàm ngga, à nǝ̀ yia twaltam, mim sǝnǝ amǝ'ɓala mem kat!>> ");
INSERT INTO mbu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sǝ yia ka à pà eare ama, <<Lang ɗe sǝ à nǝ̀ pang nǝ mǝ'eam sǝm muna-ɓwama kǝla mā-gyatarǝu?>> ");
INSERT INTO mbu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ɓakuli banggi Yakupu ama, <<Lo, o a Betel sǝ wu do abanì. Ɓak gyangŋan abanì acem, mim Ɓakuli mǝnana ǝn lǝmdǝ rǝàm a bano mana a ndaban ɓangŋa ace upi ban mǝ'eambo Isǝwa ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Pǝlǝa Yakupu banggi amǝ'ɓala male andǝ aɓwana mana kat à nda atè ka ama, <<Wu pusǝki aɓǝ̀nzál mala peri aban abǝri aɓakuli mǝnana à nda bu wun ngga, wu lak rǝ'wun, sǝ wu nggaɗi agir-nggūrǝu ma'wun. ");
INSERT INTO mbu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ɓǝ̀ sǝm lo sǝm nǝ̀ umì a Betel. Akano ka mǝ nǝ nggá ɓakkî Ɓakuli gyangŋan, yì Ɓakuli mana ok hiwi mem a pwari tanni mem, sǝ nda atàm a koya ban ǝn wari kam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Nda à pè Yakupu abǝri ɓakuli mǝnana a buia ka kat, andǝ agirkiru mana a kiria ka. Yakupu lúmsǝiǎ a tǝrta nggun mǝgule mǝnana a Shekem ngga. ");
INSERT INTO mbu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Lang à puro à nǝ̀ o ka, nggea ǝn'ò mǝnana pùr nǝban Ɓakuli ka sulǝo amur alá mǝnana à nda a ban mǝno ka. Acemani ka kǝɓwa lo ama nǝ̀ pǝ̀rta amuna mala Yakupu ama nǝ̀ pàkkia wia kǝgìr ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nda sǝ Yakupu andǝ aɓwana mana atè ka à yi bik Luz (mǝnana à tunǝi gbal ama Betel ka) a nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakupu ɓak gyangŋan kano sǝ tunǝ lullǝ banì ama El Betel, acemǝnana Ɓakuli lǝmdǝ rǝì a baní a ban mǝno lang nda rǝ ɓangŋa nǝ̀ upi ban mǝ'eambi Isǝwa ka. ");
INSERT INTO mbu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Bǝti anzǝm mǝnia ka, Debora, yì ɓwagula mǝnana ɗiɗyal nda iulǝ Rabeka mālá Ishaku a muna ka, paklú. À tsǝk-luí a tà nggun mǝgule aɓa ɓangŋaban mǝnana a Betel ka. Sǝ à tsǝkî nggunî lullǝu ama, <<Nggea-nggun sukkimǝrǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nyare mǝno Yakupu nyàrî Padan Aram ngga, Ɓakuli lǝmdǝ rǝì a baní ɗǝm a Betel. Ɓakuli tsǝki wi bù ");
INSERT INTO mbu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","banggi wi ama, <<Lùllǝò nda Yakupu, sǝama à pà nǝ̀ nggǝ tunǝo ɗǝm ama Yakupu ɗàng. Twal ado aban ká dǝmba ka, lùllǝò nda Isǝrayila.>> Anggo sǝ Ɓakuli nggaɗi wi lullǝu ama Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Pǝlǝa Ɓakuli banggi wi ama, <<Mǝ nda Ɓakuli Mana Karban Kat nǝ Gulo ka. Ɓǝl amuna sǝ wu hatǝki! Tau mò nǝ̀ duk nzali mǝgule sǝ nǝ̀ ɓǝl anzali pas. Aɓalǝ amǝ'keò ka amurǝma nǝ̀ puro! ");
INSERT INTO mbu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nzali mǝnana ǝn pê Ibǝrayim andǝ Ishaku ka mǝ nǝ po wì, sǝ mǝ nǝ pè amunio andǝ amǝ'keo mǝnana à nǝ̀ ɓǝlia anzǝmo ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pǝlǝa Ɓakuli upi ban mǝno nacau nǝ Yakupu kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","A ban mǝno Ɓakuli nacau nǝi ka, Yakupu twal nggea tali sǝ kwaki, ɓǝ̀ cam nǝ came. Pǝlǝa solǝ mùr-ɓǝlanggun anap amurí kǝla paɓoro aban Ɓakuli; ɗǝm ngga ɗārǝi nǝ mùrú olif ɓǝ̀ tàrì, ban-peri aban Ɓakuli na. ");
INSERT INTO mbu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakupu pǝlǝa tsǝki banì mǝnia Ɓakuli na cau nǝi kàm ngga lullǝu ama Betel. ");
INSERT INTO mbu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakupu andǝ amǝ'ɓala male tùro à nying Betel, sǝ lang à nda njar à malanǝ̀ bik Efǝrat ka, Rahila twal gbáshí, sǝ nda aɓa kwanban mala gbáshí. ");
INSERT INTO mbu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Lang tanni kwanban mala gbáshí male yi ɓikina ka, ɓwama mǝ'bwal gbáshí ne wi ama, <<Cè ɓangciu pàkkô ɗàng, Rahila; a ɓǝ́lǝnà muna-ɓwabura.>> ");
INSERT INTO mbu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Sǝ aɓa mǝno anggo ka yilǝmi na rǝ purì rǝì, sǝ lang nǝ̀ tusǝ masǝlǝata lin'ueo male ka, tsǝkî muna lullǝu ama, Ben-oni. Sǝ tár muna ka tunǝi ama, Benjami. ");
INSERT INTO mbu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Lang Rahila wù ka à tsǝk-luí a nkanggari njargula ká Efǝrat, là mǝnana yalung à súrǝì ama Betalami ka. ");
INSERT INTO mbu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakupu loasǝ nggea-tali tàmsǝì abanì, sǝ nda lǝmdǝ ban ɓembe mala Rahila ka bà yalung. ");
INSERT INTO mbu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Pǝlǝa Isǝrayila andǝ amǝ'ɓala male lidǝmba nǝ gya à o à kya tsǝk là-gumli malea a ɓè buì mala ɓè ban à tunǝi ama, Migdal-Eda. ");
INSERT INTO mbu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Lang Isǝrayila na ban do a nzali mǝno ka, Ruben pàk-ɓwama nǝ Bilha, mwashat atà mā-guro mala tárrí. Isǝrayila ok cè. Amuna-burana mala Yakupu ka à nda lum-nong-ɓari: ");
INSERT INTO mbu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Amuna-burana nǝ bu Liya ka à nda ka Ruben (muna-dǝmba mala Yakupu), andǝ Shimiyon, andǝ Lawi, andǝ Yahuda, andǝ Isaka, sǝ Zebulu. ");
INSERT INTO mbu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Amuna-burana nǝ bu Rahila ka à nda ka Yisǝfu andǝ Benjami. ");
INSERT INTO mbu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Amuna-burana nǝ bu Bilha, mǝtúró-ɓala mala Rahila ka, à nda ka Dan andǝ Naftali. ");
INSERT INTO mbu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Amuna-burana nǝ bu Zilpa, mǝtúró-ɓala mala Liya ka, à nda ka Gad andǝ Asha. Amǝno ka à nda ka amuna-burana mǝnana à ɓǝlî Yakupu a Padan Aram ngga. ");
INSERT INTO mbu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nda Yakupu nyare a là aban tárrí Ishaku a Mamǝre, a Kiriyat-Arba mǝnana à súrǝì yalung ama Hebǝron, yì ban mǝnana Ibǝrayim andǝ Ishaku duk kam kǝla abǝri ka. ");
INSERT INTO mbu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishaku pàk apǝlǝa gbǝman mwashat nǝ lumi-tongno-nong-tàrú 180 a ɓanza ");
INSERT INTO mbu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","sǝ yi wú, lú mala kaɓa-ɓwa, sǝ à tsǝkbani atà akê. Amuna-burana male, Isǝwa andǝ Yakupu, na à tsǝì ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Mǝnia ka nda tsadya mala amuna andǝ amǝ'kau a tàu mala Isǝwa (yì Edom) kǝla mǝnana à gilǝì ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Amālá Isǝwa ka alia atà amamǝna mala amǝ'Kan'ana. À nda ka: Ada ɓoarnsarile Elon ɓwa Hitti, andǝ Oholibama mǝnana Anah ɓǝl andǝ māmí mǝ'kà Zibiyon ɓwa Hivi, ");
INSERT INTO mbu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","sǝ Basǝmat muna-ɓwama mala Ishmayel sǝ ɗǝm ngga nda mǝ'kyauwa Nebayot ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ɓǝlî Isǝwa muna-ɓwabura à tunǝi ama Elifas. Basemat ɓǝl muna-ɓwabura à tunǝi ama Rewel, ");
INSERT INTO mbu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","sǝ Oholibama ɓǝl a Jewus, andǝ Jalam andǝ Kora. À ɓǝlî Isǝwa amǝnia yi amuna kat ka aɓa nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isǝwa pwan amāmí andǝ amuni amuna-burana andǝ amuna-mamǝna andǝ acili aɓwana mǝnana a ɓala male ka kat, sǝ pwan adomwan mala andá andǝ acili agirkusǝu male, andǝ agirkuma mǝnana kat kúmô aɓa nzali Kan'ana ka, sǝ tùro o a ɓè nzali kuko nǝban mǝ'eambi Yakupu. ");
INSERT INTO mbu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Agirkusǝu malea làkkì kǝ̀rkǝ́r mǝnana à pà nǝ̀ gandǝ do atārǝia a ban mǝmwashati raka; nzali mǝnana à ndakam nǝ do ka karǝia yia kǝm ɗàng ace ɓiki làkkì mala andá malea. ");
INSERT INTO mbu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nda Isǝwa (mana à tùnǝì gbal ama Edom ngga) wario kya dukla a Seyir, nzali múr ankono ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mǝnia ka nda tsaɗya mala aɓwapǝndǝa mǝnana à puro a nggurkwar mala Isǝwa, yì tár amǝ'Edom, mǝnana à do a Seyir, nzali múr ankono ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Alullǝ amuna-burana mala Isǝwa ka à nda ka: Elifas, muna mala Ada mālá Isǝwa, andǝ Rewel, muna mala Basemat ɓè mālá Isǝwa. ");
INSERT INTO mbu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Amuna-burana mala Elifas ka à nda ka: Teman, andǝ Omar, andǝ Zefo, andǝ Gatam andǝ Kenas. ");
INSERT INTO mbu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas, muna-ɓwabura mala Isǝwa ɗǝm ngga twal ɓè ɓwama lùllǝì ama Timna, mǝnana ɓǝli wi ɓè muna-ɓwabura, yì Amalek. Amǝno ka, à nda ka amǝ'kà Isǝwa nǝ bu māmí Ada. ");
INSERT INTO mbu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Amuna-burana mala Rewel ka à nda ka: Nahat, andǝ Zera, andǝ Shama andǝ Miza. À nda ka amǝ'kà Isǝwa nǝ bu māmí Basemat. ");
INSERT INTO mbu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Mālá Isǝwa yì Oholibama, mǝnana muna-ɓwama mala Anah, sǝ mǝ'kà Zibiyon na ka, ɓǝlî Isǝwa amuna-burana; à nda ka: Jewus, andǝ Jalam andǝ Kora. ");
INSERT INTO mbu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Amǝnia ka à nda ka aɓwana a nggurkwar mala Isǝwa mana à yi duk amúr-là ka: Amuna-burana mala Elifas muna-dǝmba mala Isǝwa ka, à nda ka: Amúr-là Teman, andǝ Omar, andǝ Zefo, andǝ Kenas, ");
INSERT INTO mbu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","andǝ Kora, andǝ Gatam andǝ Amalek. Yia mǝnia ka à nda ka amúr-là a tàu mala Elifas a nzali Edom; yia ka amǝ'kà Ada na. ");
INSERT INTO mbu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Muna-ɓwabura mala Isǝwa, yì Rewel ka nda tár a: Amúr-là Nahat, andǝ Zera, andǝ Shama andǝ Miza. Yia mǝnia ka à nda ka amúr-là a tàu mala Rewel a nzali Edom; à nda ka amǝ'kà Basemat mālá Isǝwa. ");
INSERT INTO mbu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Amuna-burana mala Isǝwa nǝ bu māmí Oholibama ka, à nda ka: Amúr-là Jewus, andǝ Jalam andǝ Kora. Amǝnia ka à nda ka amúr-là mǝnana à puro a tàu mala mālá Isǝwa, Oholibama muna-ɓwama mala Anah ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yia mǝno kat ka à nda ka aɓwapǝndǝa mǝnana à pur a nggurkwar mala Isǝwa, yì Edom ngga. ");
INSERT INTO mbu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Akún mǝnana à nda ka amǝ nzali Edom ɓara-ɓara ka tǝrtea pur nǝban amǝnia yì amuna andǝ amǝkà Seyir ɓwa Hori ka: Lotan, andǝ Shobal, andǝ Zibiyon, andǝ Anah, ");
INSERT INTO mbu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","andǝ Dishon, andǝ Eza, andǝ Dishan. Koyan ateà ka yi duk múr-là mala ɓè kún mala amǝ'Hor, yì aɓwana a nggurkwar mala Seyir a nzali Edom. ");
INSERT INTO mbu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Amuna-burana mala Lotan mǝnana à yi duk tár akún ngga, à nda ka: Hori andǝ Homam. Timna ka muna-ɓwama mǝ'kyauwa Lotan na. ");
INSERT INTO mbu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Amuna-burana mala Shobal mǝnana à yi duk tár akún ngga, à nda ka: Alvan, andǝ Manahat, andǝ Ebal, andǝ Shefo andǝ Onam. ");
INSERT INTO mbu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Amuna-burana mala Zibiyon mǝnana à yi duk tár akún ngga, à nda ka: Ayah andǝ Anah. Anah mǝnia ka nda ɓwa mǝnana tita kum amgbeɗe mala mùrpina a ɓabondo a ban yál amǝdambǝriso mala tárrí Zibiyon ngga. ");
INSERT INTO mbu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah ka nda tár Dishon; Anah ɗǝm ngga ndanǝ muna-ɓwama à tunǝi ama Oholibama. ");
INSERT INTO mbu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon ngga nda yi duk tár akún mala amǝ'Hemdan, andǝ amǝ'Eshban, andǝ amǝ'Itǝran, andǝ amǝ'Keran. ");
INSERT INTO mbu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eza nda tár akún mala amǝ'Bilhan, andǝ amǝ'Zaavan andǝ amǝ'Akan. ");
INSERT INTO mbu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan nda tár akún mala: amǝ'Uz andǝ amǝ'Aran. ");
INSERT INTO mbu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Amǝnia ka à nda ka amúr-là mala amǝ'Hor: Múr-là Lotan, Múr-là Shobal, Múr-là Zibiyon, Múr-là Anah, ");
INSERT INTO mbu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Múr-là Dishon, Múr-là Eza andǝ Múr-là Dishan. Yia mǝnia ka, à nda ka amúr-là mala amǝ'Hor kǝla mǝnana à gakkia arǝ aban aɓa nzali Seyir ka. ");
INSERT INTO mbu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kaniama à nǝ̀ yia kum amurǝma a nzali Isǝrayila ka, amurǝma mǝnia ka à nda mǝnana à yálmúr aɓwana a nzali Edom, kǝla mǝnana à kpatarǝia ani ka: ");
INSERT INTO mbu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela muna-ɓwabura mala Beyo ɓwa nggea-là Dinhaba ka nda murǝm Edom. ");
INSERT INTO mbu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Anzǝm lú mala Bela ka, Jobap muna-ɓwabura mala Zera ɓwa nggea-là Bozǝra yi eauwe a buno-murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Lang Jobap wuna ka, Husham ɓwa nzali Teman yi duk murǝm a kúnì. ");
INSERT INTO mbu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Lang Husham wuna ka, Hadat muna-ɓwabura mala Bedat, mǝnana gandǝ amǝ'Midiyan a lwa aɓa nzali Mowap ka, nda à yi pe wi buno-murǝm ngga. Lullǝ nggea-là male nda Avit. ");
INSERT INTO mbu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Lang Hadat wuna ka, Samla ɓwa nggea-là Masǝreka yi eauwe a buno-murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Lang Samla wuna ka, Shawul ɓwa nggea-là Rehobot a kún nggeasala, yi eauwe a buno-murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Lang Shawul wuna ka, Baal-Hanan muna mala Akbuo yi eauwe a buno-murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Lang Baal-Hanan muna mala Akbuo wuna ka, Hadat yi eauwe a buno-murǝm. À tunǝ lullǝ nggea-là male ama Pau. Lullǝ māmí ka nda Mehetabel muna-ɓwama mala Matǝred, muna-ɓwama mala Me-Zahap. ");
INSERT INTO mbu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Amǝnia ka à nda ka amúr-là mǝnana à puro a nggurkwar mala Isǝwa ka; à tunǝia nǝ alullǝia, koyan ngga a kún male andǝ bu-nzali male: Timna, andǝ Alva, andǝ Jetet, ");
INSERT INTO mbu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","andǝ Oholibama, andǝ Ela, andǝ Pinon, ");
INSERT INTO mbu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","andǝ Kenas, andǝ Teman, andǝ Mibza, ");
INSERT INTO mbu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","andǝ Magdiel andǝ Iram. Yia mǝno ka à nda ka amúr-là a nzali Edom. Isǝwa nda keà mǝnana à pur a tǝrtè ka. Koyan ngga nǝ ban male mǝnana duk kam aɓa nzali Edom ngga. ");
INSERT INTO mbu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakupu lidǝmba nǝ do a nzali Kan'ana, nzali mǝnana tárrí duk kam ɗiɗyal ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mǝnia ka nda cau amur ɓala mala Yakupu. Yisǝfu, mǝlagga aɓa lum bwamdǝ tongno-nong-ɓaria pǝlǝa male ka, nda ban yál agir andǝ amǝgule. Amǝgule mǝnia ka à nda ka amuna-burana mala Bilha andǝ Zilpa, amālá tárrí. Yisǝfu kǝ yinǝi tárrià cau mǝɓane amúrià. ");
INSERT INTO mbu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isǝrayila, yì Yakupu ka earce Yisǝfu kútì acilia amuni kat, acemǝnana à ɓǝli wi Yisǝfu aɓa e male. Swàrî Yisǝfu nggea-daura mǝ'ɓoarjamnì. ");
INSERT INTO mbu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Lang amǝ'eambi sǝni tárrià earce kútiǎ kat ka, pǝlǝa à twal ɓinǝmǝsǝì. À gandǝ ne kǝcau mǝɓuɓɓuki ani ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ɓè du nakam Yisǝfu lòrǝo, sǝ lang ne amǝ'eambi lòrǝê ka, kara à nyare à ɓinǝmǝsǝì kàm kpǝm. ");
INSERT INTO mbu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nea wia ama, <<Wu kwakikir wun arǝ mǝnia yì lòrǝo ǝn lorǝ ka, pé: ");
INSERT INTO mbu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Lang ǝn loasǝ mǝsǝàm ngga, ǝn sǝni, sǝm nda a ɓaban aban kùrki akúnò mǝssa, kara kùnò mǝssa mem lo cam nǝ came. Sǝ akúnò ma'wun lo à kàrì mem aɓalǝu sǝ à kùndǝi wi.>> ");
INSERT INTO mbu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Amǝ'eambi pǝlǝa à pǝlǝi wi ama, <<A sǝne mò ka awu nǝ duk murǝm amur sǝm, ko ana raka awu nǝ duk gbani ma'sǝm le?>> Nyare à ɓinǝmǝsǝì kàm kpǝm ace lòrǝo male andǝ acau mǝnana na ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nyare lòrǝ ɗǝm, pǝlǝa nea amǝ'eambi ama, <<Ɓè lòrǝo nya ɗǝm ǝn lorǝ ka, wu kwakikir wun. Mǝnia yalung ngga, pwari andǝ zongŋo sǝ anlero lum-nong-mwashat kùndǝó a ɓadǝmbam.>> ");
INSERT INTO mbu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mǝnia ka ne tárrí andǝ amǝ'eambi, sǝ tárrí sà'arǝì ama, <<Ya ulang lòrǝo nda mǝna ka? A nda rǝ na ama nggò, sǝ mim, sǝ amǝ'eambo sǝm nǝ̀ yia ɓungio a nzali a ɓadǝmbo?>> ");
INSERT INTO mbu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Amǝ'eambi kara à mwar arǝì, sǝ mala tárrí ka bwal cê kǝ ɗenyi nǝi a bumi. ");
INSERT INTO mbu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ɓè pwari ka, amǝ'eam Yisǝfu wari a yál adomwan mala agirkusǝu mala tárrià a Shekem. ");
INSERT INTO mbu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yakupu ne Yisǝfu ama, <<Amǝ'eambo na aban yál adomwan mala agirkusǝu a Shekem. Yiu mǝ nǝ túrǒ abania.>> Pǝlǝa ne tárrí ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tárrí ne wi ama, <<Kyan pé, kya sǝntà amǝ'gulio, ko yia andǝ adomwan ngga à nda jam, sǝ wu nyare wu yi banggàm.>> Nda tárrí tsǝkte sǝ ɗeki a ɓangŋaban Hebǝron, pǝlǝa bwal njar aban o. Lang Yisǝfu yi bik Shekem ngga, ");
INSERT INTO mbu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ɓè ɓwabura sǝni nda aban sokkikuni a ɓabondo sǝ ɗì ama, <<Mana a alkiyite le?>> ");
INSERT INTO mbu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yisǝfu eari wi ama, <<Mǝ nda rǝ alta amǝ'eambam. Ida, ko a nǝ gandǝ banggàm ban mǝnana à kǝ yál adomwan mala agirkusǝu malea kàm ngga?>> ");
INSERT INTO mbu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ɓwabure ama, <<À nyingǝna ban mǝnia. Ən oea à bang ama à nǝ̀ o a Dotan.>> Nda Yisǝfu nying ban mǝno, kutio o nǝ̀ nggá kum amǝgule a Dotan ngga. ");
INSERT INTO mbu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nda kuko aban ká, mǝsǝia kpa arǝì. Malaká bwal ɗang, à kurkunarǝia amurí ama à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","À ne arǝia ma, <<Wu sǝni, mǝ'lorǝki alorǝo man ngga ndya kǝ yiu ka! ");
INSERT INTO mbu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ɓǝ̀ yiu sǝm nǝ̀ yia wal-luí adyan, sǝ sǝm nǝ̀ túr luí aɓa ɓè tūli kani. Sǝm nǝ̀ na ama nyam-candǝa na bwali ka. Sǝm nǝ̀ sǝni ko lang sǝ lòrǝo male nǝ̀ yia lùmsǝó.>> ");
INSERT INTO mbu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben ongŋǝna mǝnia ka, ɓariki nǝ̀ amsǝi a ɓabuia. Nea wia ama, <<Ɓǝ̀ sǝm kǝa twal yilǝmi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Wu kǝa sukki nkila ɗàng. Wu túrí aɓa tūli-mùr mǝ'ime mǝnia kani a ɓabondo ka. Sǝama wu kǝa na ama wun nǝ̀ tsǝk bu wun arǝì, wun nǝ̀ tsǝki wi npenye ɗàng.>> Ruben ngga bang anggo ace mǝnana nǝ̀ amsǝ Yisǝfu a buia, nǝ̀ tasǝ takwari ɓǝ̀ nyare aban tárrí ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lang Yisǝfu yi bwalǝna ban amǝ'eambi ka, kara à swárì wi nggea-daura male, yì nggea-daura mǝ'ɓoarjamnì male man arǝì ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Pǝlǝa à twali à túrí aɓa tūli. Tūlinì ka ɓālǝi na kpokǝrok; ɓālǝi ka mǝ'ime na. ");
INSERT INTO mbu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","À ɓuntea à do à nǝ̀ lìli, sǝ lang à loasǝ mǝsǝia ka, à sǝn amǝ'fuli nǝ akalakadambi malea, à tsaɗi atārǝia aban yiu; amǝ'Ishmayel na à pur nǝ Gilǝyat. Twalo mǝnana a nzǝm akalakadambi malea ka lùmsǝ nǝ muku agir mǝ'rǝmɓoarne, andǝ mùrú-hasǝa mǝ'rǝmɓoarne, andǝ myang mala wal rǝkwangya andǝ kwanban. À nda mur njargula à nǝ̀ kánǝia a Masar. ");
INSERT INTO mbu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahuda ne amǝ'eambi ama, <<Mana sǝm nǝ̀ kúmô mǝnana ɓǝ̀ sǝm wal-lú mǝ'eam sǝm, sǝm sǝmbǝrǝ cè ka? ");
INSERT INTO mbu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ɓǝ̀ sǝm makkì amǝ'fuli mala amǝ'Ishmayel mǝno à kǝ yiu ka. Ɓǝ̀ sǝm kǝa tsǝki wi npenye ɗàng; kǝla yì ka nkila sǝm na ɗe andǝ nyam sǝm!>> Amǝ'eambi kara à earcau male. ");
INSERT INTO mbu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Lang amǝ'Ishmayel, yia mǝnana amǝ'fuli mala nzali Midiyan na, à yiu à nǝ̀ kútí ka, amǝ'eam Yisǝfu nunni à pusǝì aɓa tūli, sǝ à makkia wia yì a kun gbatali boalo azǝrfa lumi-ɓari. Sǝ amǝ'fuli man twal Yisǝfu, à umnǝi a Masar. ");
INSERT INTO mbu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lang Ruben nyare wari a tūli, sǝ sǝni ka Yisǝfu pà kàm aɓalǝi raka, kara bwal daura male sannì. ");
INSERT INTO mbu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nyare aban amǝ'eambi, sǝ na ama, <<Munê pa kàm a tūli ɗang! Lang sǝ mǝ nǝ pa ado?>> ");
INSERT INTO mbu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Pǝlǝa à twal nggea-daura mala Yisǝfu, à pari aɓa nkila mala muna-mbul mǝnana à pwan-myali ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","À twal nggea-daura mǝ'ɓoarjamnì mǝnia ka, à wari nǝi aban tárrià sǝ à banggi wi ama, <<Sǝm kum daura mǝnia ka a ɓabondo. Ida, pelǝki wu sǝni ko nggea-daura mala munio na.>> ");
INSERT INTO mbu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Lang sǝni ka kara súrǝì sǝ bang ama, <<Daura mala munem na! Ɓè nyam-bondo walni shangni! Munem Yisǝfu ka nyam-bondo sangini!>> ");
INSERT INTO mbu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Bumkiɗikea atàcau mala muni tsǝk Yakupu bwal daura male sannì, pǝlǝa oasǝ asanginagìr arǝì. Twal anongŋo pas nda ban ɓua ace muni. ");
INSERT INTO mbu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Amuni amuna-burana andǝ amuna-mamǝna kat yiu abani à nǝ̀ giriki, sǝ yì ka ɓinǝ girikiban. Bang ama, <<Awo, mǝ nǝ ɓua munem mǝ nǝ wǔ mǝ o atè a Shewol.>> Nda lidǝmba nǝ ɓua muni Yisǝfu ka. ");
INSERT INTO mbu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Anggo ka amǝ'Midiyan amǝ'Fuli kya mangŋǝna Yisǝfu a Masar aban Potifa, ɓè mǝbuno mala Firona, murǝm Masar, gbani mala aɓwana-mǝgule mala amǝ'yáltà murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A ɓè bàkú ka, Yahuda nying amǝ'eambi pǝlǝa kutio o nǝ̀ nggá do atà ɓè ɓwabura ɓwa Adulam lùllǝì ama Hira. ");
INSERT INTO mbu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","A ban mǝno ka Yahuda je andǝ ɓè muna-ɓwama Kan'ana lùllǝ tárrí ama Shua. Al muna-ɓwame ");
INSERT INTO mbu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","sǝ ɓǝli wi muna-ɓwabura. Tsǝkî munê lullǝu ama Er. ");
INSERT INTO mbu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nyare muna kpa a bumi sǝ ɓǝl ɓè muna-ɓwabura tsǝki wi lullǝu ama Onan. ");
INSERT INTO mbu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nyar ɗǝm ɓǝl ɓè muna-ɓwabura tsǝki wi lullǝu ama Shela. Mǝnia ka a Kezip sǝ à ɓǝli. ");
INSERT INTO mbu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Lang Er, yì muna-dǝmba mala Yahuda gulna ka, tárrí alì wi ɓwama. Lullǝ ɓwame ama Tamar. ");
INSERT INTO mbu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Sǝ Er ka pàk gìr mǝnana mǝɓike na aban Mǝtalabangŋo ka; nda Mǝtalabangŋo wal-luí ka. ");
INSERT INTO mbu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Anzǝm lú mala Er ka, Yahuda ne Onan ama, <<Kúti aban mā-lú mala mǝguleo. Lùmsǝ túró mô abani kǝla mǝ'eam burí, ace mǝnana mǝ'eambo ɓǝ̀ kum amuna nǝbano.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Sǝ Onan ngga earnǝ mǝno ka ɗàng acemǝnana sǝlǝna ama amunè ka à pà nǝ̀ duk amale ɗàng. Acemani ka ɓǝ̀ nda rǝ nongnǝ mā-lú mala mǝ'eambi ka nǝ̀ sukki mùr-ɓwabura a nza. Kǝ pê anggo ace mǝnana ɓwame ɓǝ̀ kǝa kum muna a bumi ɓǝ̀ ɓǝlî mǝ'eambi raka. ");
INSERT INTO mbu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gìr mǝno Onan pè ka, gìr mǝɓike na aban Mǝtalabangŋo; nda Mǝtalabangŋo walì wú gbal ka. ");
INSERT INTO mbu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda pǝlǝa ne nkili Tamar ama, <<Nyare a ɓala aban tárró kya duk kàm kǝla mā-lú sheɓǝ̀ munem Shela gulna ka.>> Yahuda bang mǝno ka acemǝnana ɓangciu pàkki wi ama Shela nǝ̀ wú kǝla mǝnana amǝ'eambi wù ka. Nda Tamar o kya do a ɓala mala tárrí ka. ");
INSERT INTO mbu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Anzǝm aɓea apǝlǝa ka mālá Yahuda, muna-ɓwama mala Shua, wú. Anzǝm mana Yahuda kumǝna girikiban ngga, lo wari a Timna, a ban mǝnana à kǝ mwaki wi nyang anzur male ka. Gyajam male Hira ɓwa Adulam wari atè. ");
INSERT INTO mbu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ɓè ɓwa banggi Tamar ama, <<Nkilo na a njar aban o a Timna nǝ̀ nggá bwalì aburana mana à kǝ mwaki wi nyang anzur male ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar pǝlǝa swár anggūbyau-mā-lú male sǝ kùmsǝ nggubyau-koarǝu amurí ace ɓosǝki rǝì. Yi do a kún njarkutio a Enayim, ɓè là a njargula ká Timna. Yì ka sǝlǝna ama muna mǝkyauwe mala Yahuda, yì Shela ka gulna dumǝna ɓwabura, sǝ Yahuda pàk kǝgìr ace yinǝi ɓǝ̀ yi duk mālá Shela ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Lang Yahuda nǝ̀ yia kutio sǝ sǝni ka, twali ama ɓè mā-gyatarǝu na, acemǝnana kùmsǝ ɓamǝsǝi. ");
INSERT INTO mbu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda ka gandǝ sǝlǝa ama nkili na ɗang, pǝlǝa kàra abani a gírí njargula, sǝ ne wi ama, <<Ida, yiu mǝ kya kúti a bano.>> Pǝlǝa ɗì ama, <<Mana awu nǝ pam ace mǝnana wu kúti a banam ngga?>> ");
INSERT INTO mbu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Bang ama, <<Mǝ nǝ túròban nǝ muna-mbul atà ambul mala domwan mem.>> Pǝlǝa ɗì ama, <<Sǝ ya gìr'kùrban na awu nǝ tsǝì mǝ bwali a buam bà a túrnaban nǝ muna-mbulni ka?>> ");
INSERT INTO mbu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yahuda bang ama, <<Ya ulang gìr'kùrban na a earce mǝ tsǝk ka?>> Eari wi ama, <<Pam gìrparbu mò andǝ nggurrì mǝnana gyar arǝì a myalo ka, andǝ gara-gya mò mǝnana a buo ka.>> Yahuda pè wi agir man. Pǝlǝa kúti a baní, sǝ muna kpa a bumi. ");
INSERT INTO mbu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar lo o a ɓala, kya swár lagìr koarǝu male sǝ oasǝ anggūbyau-mā-lú male ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Lang Yahuda nyarna a là ka, kya túr gyajam male Hira, ɓwa Adulam, nǝ muna-mbul ɓǝ̀ kyan nǝi ɓǝ̀ pè ɓwame sǝ ɓǝ̀ aki wi agir mǝnana pà ka. Sǝ lang Hira wari ka, kya kum ɓwame ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pǝlǝa ɗì ka aɓwana mǝnana à do a ban mǝno ka ama, <<Mā-gyatarǝu mǝnana dukiyi kani a kún njarkutio a Enayim ngga, nda ake?>> Sǝ yia ka à eari wi ama, <<Sǝm pànǝ ɓekǝ mā-gyatarǝu kani ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nda Hira nyare sǝ banggi Yahuda ama, <<Ən kumi ɗàng, sǝ aɓwana mǝnana à duk kano ka à bang ama, ɓekǝ mā-gyatarǝu pà kàm a banì ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda pǝlǝa bang ama, <<Ɗeki ɓǝ̀ bwal agirnì a buì. Ɓǝ̀ sǝm lidǝmba sǝm nǝ̀ alte ka, sǝm nǝ̀ pǝlǝ gìr'oalban aban aɓwana. Mim ngga ǝn túrnì wi ban nǝ muna-mbul, a warina sǝ a kumi ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Anzǝm zongŋo tàrú ka aɓwana yi banggi Yahuda ama, <<Nkilo Tamar ka kutina gyatarǝì, sǝ ado ka ndanǝ muna a bumi.>> Yahuda bang ama, <<Wu pusǝì ɓǝà pisǝì ɓǝ̀ wú!>> ");
INSERT INTO mbu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Lang aɓwana wario à nǝ̀ pusǝì ka, Tamar túr ɓeɓwa aban nkili, nǝ cau ama, <<Ɓwabura mǝnana twàlâm muna ka nda mǝtala agir mǝnia ka. Ida, pelǝki wu sǝni ko a nǝ súrǝ̀ yana nda mǝtala gìrparbu andǝ nggurrì andǝ gara-gya mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda yi súrǝ̀ agirnì sǝ na ama, <<Cau male ɓoaro kútì mem, acemǝnana ǝn pak ɓè kǝgìr ace ɓǝ̀ yiu a ɓala aban munem Shela, ɓǝ̀ yi duk māmí kǝla mǝnana ǝn pacau ace ka ɗàng.>> Yahuda nyare nongnǝ Tamar ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Lang zongŋo gbáshí bingŋǝna ka, amuna-pasa na mǝnana a bumi ka. ");
INSERT INTO mbu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Lang nda rǝ gbáshí ka, mwashat atà pasa pusǝ bui a nza; mǝ'bwal-gbáshí pǝlǝa kùrî wi nkonggúr mǝbangŋe a garabui sǝ bang ama, <<Mǝnia ka nda tita puro ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sǝ lang nyesǝ bui ka, mǝ'eambi yi puro. Mǝ'bwal-gbáshí pǝlǝa bang ama, <<Ani sǝ a yi sanban a puro!>> Nda tsǝki wi lullǝu ama Perez. ");
INSERT INTO mbu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nǝnzǝ́mò ka mǝ'eambi mǝnana nǝ nkonggúr mǝbangŋe a garabui ka yi puro sǝ à tsǝki wi lullǝu ama Zera. ");
INSERT INTO mbu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Amǝ'Ishmayel yinǝ Yisǝfu a Masar. Potifa ka nda ɓè mǝbuno mala Firona, murǝm Masar, gbani mala aɓwana-mǝgule mala amǝ'yáltà murǝm. Yì nda ɓwa mǝnana yi kúmó kúr Yisǝfu guro a bu amǝ'Ishmayel ka. ");
INSERT INTO mbu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mǝtalabangŋo na atà Yisǝfu. Koman kat pa aɓalǝ atúró male kǝla guro a ɓala mala mǝtala-ɓala male, yì ɓwa Masar ka, kǝ kum lidǝmba. ");
INSERT INTO mbu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Lang mǝtala-ɓala mala Yisǝfu sǝni bu Mǝtalabangŋo na amur Yisǝfu, sǝ ɗǝm ngga Mǝtalabangŋo kǝ pe wi lidǝmba arǝ komana mǝnana kat nda a buì ka, ");
INSERT INTO mbu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","bumi pwasǝo arǝ Yisǝfu, pǝlǝa nyesǝi duk mǝkwaɗitè. Tsǝk Yisǝfu duk mǝɗenyi nǝ ɓala male, sǝ nyinggi wi agirkuma male kat a buì. ");
INSERT INTO mbu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Twal a kǝ pwari mana nyesǝna ɓala male andǝ agirkuma male kat a ɓabù Yisǝfu ka, Mǝtalabangŋo tsǝki ɓala mala ɓwabura Masar bu àkǝ̀ cè Yisǝfu. Tsǝkbu mala Mǝtalabangŋo mǝnia ka do amur komana mǝnana kat mala Potifa na ka, a ɓala sǝ a ɓaban. ");
INSERT INTO mbu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nda Potifa nying komana kat ndanǝi ka a bu Yisǝfu ɓǝ̀ kǝ ɗenyi nǝia. Potifa nyare tsǝk ɓamúrì aɓa ɗenyi nǝ ɓe kǝgìr ɗǝm ɗàng. Kǝ girlina mǝnana nǝ̀ li ka nda nakiyice ka. Yisǝfu ka nda dwat, sǝ nggunrǝi ɓoaro, ɓoarjam pepè. ");
INSERT INTO mbu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Banì sau ɗang mālá Potifa tita tsǝk mǝsǝi arǝ Yisǝfu. A ɓè pwari ka ne Yisǝfu ama, <<Yiu nongnǝ mim.>> ");
INSERT INTO mbu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Sǝ Yisǝfu ka ɓinǝe, ne wi ama, <<Sǝni, Mǝtala-ɓala mem earnǝ mim, nying koman kat mana male na ka a buam. Kǝgìr oasǝi ɗǝm arǝ kǝgìr a ɓala ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kǝ ɓwa pà kàm atà amǝtúró a ɓala man kútiǎm nǝ gulo ɗang. Mǝtala-ɓala mem gìram nǝ kǝgìr ɗàng shekǝ we, acemǝnana a ndà māmí. Sǝ ado ka palang sǝ mǝ nǝ pàk mǝnia yì túró ɓealɓikea mǝgule ka, sǝ mǝ nǝ pàk cauɓikea aban Ɓakuli?>> ");
INSERT INTO mbu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ɓwama mǝnia lidǝmba nǝ pità Yisǝfu nǝ cau pwari-pwari, sǝ Yisǝfu ka ɓinǝ oki wi, ginggi wi zak, sǝ eare gbashì baní ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ɓè pwari ka, Yisǝfu wari a ɓaɓala ace pàkki atúró male, sǝ acili amǝtúró ka kǝ ɓwa pà kàm ateà a ɓala ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ɓwama man yiu yi gbami daura-múrɓì mala Yisǝfu, sǝ ne wi ama, <<Yiu nongnǝ mim!>> Yisǝfu gwamsǝ rǝì swárô nying daura-múrɓì male a bu ɓwame, ɓangŋa puro nying ɓala. ");
INSERT INTO mbu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Lang ɓwama man sǝni Yisǝfu ɓàngŋǝ̀nà umǝna sǝ nyingŋǝna daura-múrɓì male a buì ka, ");
INSERT INTO mbu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","pǝlǝa tunǝban, nda amǝ'túró-ɓala male ɓangŋa à yiu. Nea wia ama, <<Wu sǝni, burém yinǝ mǝnia yì guro ɓwa Ibǝru akani ace mana ɓǝ̀ yi ɓangginǝ sǝm! Ndya yiu yi kútí atàm a kurǝm ama nǝ̀ nongnǝ mim, nda ǝn mak'zwalo ka. ");
INSERT INTO mbu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Lang oem ǝn loasǝ giem ǝn mak'zwalo ka, nda puro ɓangŋa o nying daura-múrɓì male a nkanggariam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Pǝlǝa ɓwama man nyesǝ daura-múrɓì tsǝì abani bà nyare mala burí a ɓala. ");
INSERT INTO mbu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Lang burí yina ka, twal cê banggi wi ama, <<Mǝno yì guro ɓwa Ibǝru a yina sǝm nǝi ka, yi kúti atàm a kurǝm ama nǝ̀ ɓangginǝ mim; ");
INSERT INTO mbu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","sǝ lang ǝn loasǝ giem ǝn mak'zwalo ka, kara sarǝa mire o nying daura-múrɓì male abanam, purî ɓala.>> ");
INSERT INTO mbu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Lang mǝtala-ɓala male ok cau mǝnia māmí banggi wi amur gir mǝnana Yisǝfu pè ka, kara bumi lul kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Mǝtala-ɓala mala Yisǝfu pǝlǝa twal Yisǝfu umnǝi kya túrí a ndàkurban, a ban mǝnana à kǝ tsǝk apusǝna mala murǝm kàm ngga. Yisǝfu ueo kano a ndàkurban. ");
INSERT INTO mbu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Sǝ Mǝtalabangŋo ka nda atè; sǝntǝ̀r mala Yisǝfu pǝlǝa pè wi múrɓoarna a mǝsǝ ɓwamǝgule mala túró yál ndàkurban. ");
INSERT INTO mbu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ɓwamǝgule mala túró yál ndàkurban tsǝk Yisǝfu amúr aɓwana mana kat à kàsǝ̀kúnià a ndàkurban ngga ɓǝ̀ kǝ ɗenyinǝia, sǝ nyinggi wi ɓǝ̀ kǝ sǝntà koya túró mǝnana kat à kǝ pè a ban mǝno ka. ");
INSERT INTO mbu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ɓwamǝgule mala túró yál ndàkurban nyare tsǝk ɓamúrì aɓa ɗenyi nǝ ɓè kǝgìr ɗǝm mǝnana nyingŋǝ́nì Yisǝfu a buì ka ɗàng. Mǝtalabangŋo ka nda atà Yisǝfu sǝ pè wi lidǝmba aɓa koman mǝnana kat kǝ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Anzǝmi bǝti ka, ɓwamǝgule mǝ'pa-girnùná, andǝ ɓwamǝgule mǝ'lurǝgìr mala Murǝm Firona ka à pàk mǝɓane. ");
INSERT INTO mbu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Bum Firona lul kǝ̀rkǝ́r arǝ amǝbuno man ɓari, yì a ɓwamǝgule mǝ'pa-girnùná, andǝ ɓwamǝgule mǝ'lurǝgìr. ");
INSERT INTO mbu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Pǝlǝa tasǝtea a ndàkurban a ɓala mala ɓwamǝgule mala amǝ'yál murǝm, àkǝ̀ ban mǝnana à oasǝ Yisǝfu kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bania sauwa aɓa ndàkurban, sǝ ɓwamǝgule mala túró yál ndàkurban tsǝk Yisǝfu ɓǝ̀ duk guro mala ɗenyi nǝ aburana man ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Aɓa du mwashat ka aburana mǝnia, yia ɓwamǝgule mǝ'pa-girnùná, andǝ ɓwamǝgule mǝ'lurǝgìr mala murǝm Masar, yia kǝm à lòrǝo sǝ koyan ngga ɓá lòrǝo male ka nda ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Lang Yisǝfu wari abania nǝ dǝmbari yi sǝnia ka, à nda ɓá bumkiɗikea. ");
INSERT INTO mbu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Pǝlǝa ɗì aɓwana-mǝgule mala murǝm Firona mǝnana à nda a ndàkurban andǝi a ɓala mala mǝtala-ɓala male ka ama, <<Márǝ̀ wun sǝ wu kùrɓamǝsǝ wun anggo yalung?>> ");
INSERT INTO mbu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","À pè wi eare ama, <<Alorǝo na sǝm lòrǝ̀ ka sǝ kǝɓwa pà kàm nǝ̀ mǝngia sǝm ɓalǝia ɗàng.>> Yisǝfu pǝlǝa nea wia ama, <<Mǝngi ɓalǝ alorǝo ka Ɓakuli na pākiyi ka re? Ida, wu nam alorǝè.>> ");
INSERT INTO mbu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Pǝlǝa ɓwamǝgule mǝ'pa-girnùná ne Yisǝfu lòrǝo male ama, <<Aɓa lòrǝo mem, ǝn sǝni ka, nggun anap, na a ɓadǝmbam; ");
INSERT INTO mbu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","sǝ yì nggun anap ka ndanǝ abui tàrú. Lang ambui nǝ̀ to ka, pǝlǝa sak pwasǝe sǝ adangŋanshi ɓǝle kya bángŋá. ");
INSERT INTO mbu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kap nugìr mala murǝm ngga nda a buam, pǝlǝa ǝn kasǝ mwashat atà adangŋanshi ɓǝla anap ǝn kam mùrì aɓa kap, sǝ ǝn pê murǝm a bui.>> ");
INSERT INTO mbu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yisǝfu ne wi ama, <<Ɓá lòrǝê ndya ka: abu-nggun tàrú ka nongŋo tàrú na. ");
INSERT INTO mbu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Anzǝm nongŋo tàrú ka, murǝm nǝ̀ twalôbanì, nǝ̀ nyesǝo a bancame mò mana ɗiɗyal ka. A nǝ nggǝ pê Murǝm kap nugìr male a buì kǝla mana ɗiɗyal a nda mǝ'pa-girnùná male ka. ");
INSERT INTO mbu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sǝ ǝn nggǝ zǝmbô, ɓǝ̀ agir ɓoarno ka ɗenyi nǝ mim. Ida, kya nacem a ɓadǝm murǝm ace mǝnana ɓǝ̀ pusǝam ɓǝ̀n purì ɓá ndàkurban man. ");
INSERT INTO mbu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","À iuwam nǝ iuwe a nzali mem, nzali mala amǝ Ibǝru, sǝ akani a Masar ka, ǝn pak kǝgìr mǝnana tsǝa à nǝ̀ oasǝam a ndàkurban ace ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Lang ɓwamǝgule mǝ'lurǝgìr sǝni mǝngi ɓá lòrǝo mǝno ɓoar ka, pǝlǝa ne Yisǝfu ama, <<Mim gbal aɓa lòrǝo mem ngga, ǝn sǝni ka, ǝn twal azace bǝredi tàrú aɓalǝarǝia amuram. ");
INSERT INTO mbu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Aɓa zace mǝnana amur aɓi ka, agirlina nakam ɗàngɗáng mǝnana à lurǝì murǝm ngga, sǝ anyal sulǝo à kǝ fwakia amuram à kǝ lia.>> ");
INSERT INTO mbu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yisǝfu ne wi ama, <<Ɓá lòrǝo mò ndya ka: azace tàrú ka anongŋo tàrú na. ");
INSERT INTO mbu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aɓa nongŋo tàrú ka murǝm nǝ̀ kasǝ ɓamuro sǝ nǝ̀ gyar nggunrǝo a nggun, sǝ anyal nǝ̀ yiu à nǝ̀ fwaki nyam rǝo.>> ");
INSERT INTO mbu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A tàruià nongŋo, mǝnana nda pwari ɗenyinǝ ɓǝlban mala Firona ka, Firona gilǝki do mala lì girlina banɓoarnado ace amǝ'tè andǝ amǝ'túró male kat. Túrban ɓǝà kya pusǝ ɓwamǝgule mǝ'pa-girnùná, andǝ ɓwamǝgule mǝ'lurǝgìr male ɓǝà yinǝia a ɓadǝm acili amǝ'tè. ");
INSERT INTO mbu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nyesǝ ɓwamǝgule mǝ'pa-girnùná a bancame male, ace mǝnana ɓǝ̀ lidǝmba nǝ túró male mala pè murǝm girnùná, ");
INSERT INTO mbu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","sǝ ɓwamǝgule mǝ'lurǝgìr ka à wal-luí. Agir mǝno kat yi pa anggo kǝla mǝnana Yisǝfu bang ngga. ");
INSERT INTO mbu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kat andǝ mani ka, ɓwamǝgule mǝ'pa-girnùná ka ɓālǝi kasǝ arǝ Yisǝfu ɗàng; ɓālǝi lorǝi. ");
INSERT INTO mbu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Anzǝm mana pǝlǝa ɓari lùmsǝna ka, Firona murǝm Masar lòrǝ̀ ama cam a kún Nggeasala Nayel. ");
INSERT INTO mbu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Aɓa lòrǝo male ka, sǝn andá tongno-nong-ɓari amǝ'nyange ɓùlɓùl, à pùr nǝ mùr sǝ à kǝ li bondo mǝpwale a kún nggeasala. ");
INSERT INTO mbu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pǝlǝa sǝn aɓea andá tongno-nong-ɓari, aman ngga amǝ'eamdǝke kwakǝɗak na. À pùr nǝ mùr à yi cam a kún nggeasala a nkanggari amǝ'nyange mǝno. ");
INSERT INTO mbu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kara andá amǝ'eamdǝke kwakǝɗak mǝnia shak amǝ'nyange ɓùlɓùl mǝno. Pǝlǝa mǝsǝ Firona sapî ntulo. ");
INSERT INTO mbu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ntulo nyare e, sǝ lòrǝ̀ ɗǝm; sǝni ka kuri-mǝssa mwashat nǝ amur-mǝssa tongno-nong-ɓari amǝɓoarne, amǝɓǝle aban gulo amurí. ");
INSERT INTO mbu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nǝnzǝ́mò ka nyare sǝn aɓea amur-mǝssa tongno-nong-ɓari amǝkwetǝke mǝnana gùngpi mala takuli imsǝia kaksǝkǝrak ka, à yi to. ");
INSERT INTO mbu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sǝ amur-mǝssa amǝkwetǝke mǝnia ka à yi myal amur-mǝssa amǝɓoarne, amǝɓǝle mǝno. Mǝsǝ Firona sak a ntulo sǝ yi sǝlǝ ama lòrǝo na. ");
INSERT INTO mbu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ban yi fana ka ɗenyicau mala Firona zurì, nda túrban ɓǝà tunǝ amǝ'pakki agir nggár andǝ amǝ'sǝlǝe mala nzali Masar. Firona nea wia alorǝo male, sǝ kǝ ɓwa ateà gandǝ mǝngi wi ɓalǝ alorǝo male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pǝlǝa ɓwamǝgule mǝ'pa-girnùná mala Firona banggi Firona ama, <<Yalung ngga ɓalǝam kasǝna arǝ gatti mem. ");
INSERT INTO mbu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","A ɓè pwari mana kútí ka, bum Murǝm lúllô arǝ aguro male sǝ tasǝta sǝm a ndàkurban, mim sǝnǝ ɓwamǝgule mǝ'lurǝgìr, a ɓala mala ɓwamǝgule mala amǝ'yáltà murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A ɓè du mwashat koyan atà sǝm ngga lòrǝo, sǝ ɓalǝ alorǝe ka à nda ɗàngɗáng. ");
INSERT INTO mbu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ɓè mǝlagga ɓwa Ibǝru, guro mala ɓwamǝgule mǝ'yáltà murǝm nakam atà sǝm. Sǝm ne wi alorǝo ma'sǝm, sǝ mǝngia sǝm ɓalǝia. ");
INSERT INTO mbu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Anggo sǝ yi lùmsǝó kǝla mǝnana bangga sǝm ngga: à nyesǝam a bantúró mem, sǝ mǝ'lurǝgìr ka à gyari a nggun.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pǝlǝa Firona túrban ɓǝà kya pusǝ Yisǝfu aɓa ndàkurban ɓǝà yinǝi tsuk-tsuk. Sǝ anzǝm mana Yisǝfu mwana-mwâ ka, nggaɗi agir'ngūrǝì sǝ o a ɓadǝm Firona. ");
INSERT INTO mbu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firona ne Yisǝfu ama, <<Ən lorǝ lorǝo sǝ kǝ ɓwa gandǝ mǝngiàm ɓālǝi ɗàng. Sǝ ǝn ok ama ɓǝà nô lòrǝo ka, a kǝ gandǝ mǝngi ɓālǝi.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yisǝfu pǝlǝì Firona ama, <<Mǝ nda ǝn pakkiyi ka ɗàng, sǝama Ɓakuli ka nǝ̀ mǝngio ɓá lòrǝo mô.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firona ne Yisǝfu ama, <<Aɓa lòrǝo mem, ǝn sǝni ka, mǝ nda aban came a kún Nggeasala Nayel. ");
INSERT INTO mbu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ən sǝn andá tongno-nong-ɓari amǝ'nyange ɓùlɓùl, à puro a mùr sǝ à tita li bondo mǝpwale a kún nggeasala. ");
INSERT INTO mbu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nyare ǝn sǝn aɓea andá tongno-nong-ɓari amǝ'eamdǝke kwakǝɗak. Ən malaká sǝn ulang andá amǝ'ɓikijamnì kǝla amǝno a ɓè kǝban aɓa nzali Masar ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Amǝnia yì aɓikina andá tongno-nong-ɓari amǝ'eamdǝke ka, à shak amǝ'nyange mǝno ǝn sǝnia a dǝmba ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sǝ anzǝm mǝnana à shanŋǝnia ka, kǝ ɓwa pà nǝ̀ sǝlǝ ama à shangŋǝna amǝ'nyange mǝno ka ɗang, acemǝnana à ndakam akǝ banì kwakǝɗak. Pǝlǝa mǝsǝam sapî ntulo. ");
INSERT INTO mbu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","<<Aɓa lòrǝo mem ɗǝm, ǝn sǝni ka, kuri-mǝssa mwashat pusǝ amur-mǝssa tongno-nong-ɓari amǝ'ɓoarne mǝnana à ɓǝl gbatsǝkǝrak ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nyare ǝn sǝni ɗǝm ngga aɓea amur-mǝssa tongno-nong-ɓari amǝkwetǝke yi puro. Amǝnia ka gùngpi ɓá pǝɗanban imsǝnia katsak. ");
INSERT INTO mbu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kara amur-mǝssa amǝkwetǝke mǝnia myal amǝɓoarne mǝno. <<Ən banggi amǝ'pakki agir nggár lòrǝê, sǝ kǝ ɓwa ateà gandǝ mǝngiàm ɓālǝi ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Pǝlǝa Yisǝfu ne Firona ama, <<Alorǝo mò ka à nda mwashat. Ɓakuli lǝmdǝnò gìr mǝnana kǝ earce pê ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Amǝno yì andá amǝ'nyange tongno-nong-ɓari ka, apǝlǝa tongno-nong-ɓari na, sǝ amur-mǝssa mǝɓoarne mǝno tongno-nong-ɓari ka, apǝlǝa tongno-nong-ɓari na. Alorǝè ka à nda mwashat. ");
INSERT INTO mbu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Andá amǝ'eamdǝke mǝno tongno-nong-ɓari mǝnana à pur nǝnzǝ́mò, andǝ amur-mǝssa amǝkwetǝke mǝno gùngpi ɓá pǝɗanban tsǝia à wulì sǝ imsǝia ka, apǝlǝa tongno-nong-ɓari mala nzal-gula na. ");
INSERT INTO mbu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kǝ ndo kǝla mǝnana ǝn banggo ka, Murǝm: Ɓakuli lǝmdǝnò we Murǝm, gìr mǝnana ndo nǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Apǝlǝa tongno-nong-ɓari mǝnana Ɓakuli nǝ hatǝki nzali Masar nǝ girlina ka, à nda aban yiu. ");
INSERT INTO mbu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sǝ anzǝmi ka, nzal-gula nǝ̀ kpa aɓa nzali Masar aɓa pǝlǝa tongno-nong-ɓari, mǝnana nǝ̀ tsǝa à nǝ̀ lorǝce kume mala nzali Masar ka. Nzal-gulê nǝ̀ kiɗiki nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Nzal-gulê nǝ̀ ɓikipa mǝnana nǝ̀ tsǝa à nǝ̀ lorǝce hatǝki mala girlina a Masar. ");
INSERT INTO mbu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","À ɓǝsǝlǝò lorǝê kusǝ ɓari ace lǝmdǝ ama Ɓakuli kasǝna cê ama, mǝno nda gìr mǝnana zuku ka nǝ̀ kumban ngga. ");
INSERT INTO mbu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","<<Acemani ka, ɓǝ̀ Murǝm tàr ɓwa mwashat, mǝnana ndanǝ sǝlǝe andǝ sǝndǝmba ka, ɓǝ̀ tsǝì amur nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ɓǝ̀ tsǝk aɓea aɓwana-mǝgule mǝnana à nǝ̀ nggǝ ak kāmbe mwashat aɓa tongno mala agirɓaban mǝnana à nǝ̀ kum aɓalǝ apǝlǝa tongno-nong-ɓari mala kum ɗǝmbo ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ɓǝ̀ tsǝia ɓǝà ram girlina mǝnana kat à nǝ̀ kúmô aɓalǝ apǝlǝa mǝɓoarne mǝnana àkǝ yiu ka, sǝ ɓǝ̀ pea wia rǝcandǝa nǝ bu Murǝm ɓǝà tsǝk mǝsǝsa arǝ abah ace kum girlina a là, sǝ ɓǝà tsǝkir girlinê. ");
INSERT INTO mbu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mǝnia yì girlina ka à nǝ̀ tsǝì ace kum girlina mǝnana nǝ̀ karǝ aɓwana aɓalǝ apǝlǝa tongno-nong-ɓari mala nzal-gula mǝnana kǝ yiu amur nzali Masar ka. Anggo sǝ nzala pa nǝ̀ twalta aɓwana ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Firona andǝ amǝtè kat ka, à earnǝ cau mǝnana Yisǝfu banggia wia ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firona pǝlǝa ɗì amǝtè ama, <<Yana sǝm nǝ̀ kúmô mǝnana nǝ̀ kútì ɓwa man, mǝnana Bangŋo mala Ɓakuli na aɓalǝi ka?>> ");
INSERT INTO mbu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pǝlǝa Firona ne Yisǝfu ama, <<Ɓakuli na lǝmdǝo mǝnia yì agir kat ka, kǝ ɓwa pà kàm ndanǝ sǝlǝe andǝ súrǝ̀gir kǝla we ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","A nda mana mǝ nǝ tsǝo amur nzali mem ngga. Cau mǝnana pur a kuno ka, nda aɓwana mem nǝ̀ kpate ka. Kǝ mim Firona murǝm, nda mǝnana mǝ nǝ kútiǒ nǝ gulo ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Sǝ Firona ne Yisǝfu ama, <<Ado ka ǝn tsǝ́ngŋǝ̀nó a nda nggwamna amur nzali Masar kat.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pǝlǝa Firona pusǝ gbalmo-gulo male mǝnana a munabuì ka, oasǝì Yisǝfu a munabuì, sǝ turì wi daura nggubyau-linǝn mǝ'ɓoarjamnì arǝì sǝ oasǝi wi nlang bolo-njengǝlan a myali. ");
INSERT INTO mbu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Firona eamsǝi aɓa ɓaria waru-pǝr mala murǝm, sǝ à kǝ hamnǝi a ɓadǝmbi ama, <<Wu ɓunno amur ankūnǝ wun!>> Anggo sǝ tsǝì duk nggwamna amur nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firona ne Yisǝfu ɗǝm ama, <<Mǝ nda murǝm, sǝ kǝɓwa pà nǝ̀ loasǝ bui ko nǝ̀ twal kusǝì a nzali man ɗang she nǝ cau mǝnana pur a kuno ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pǝlǝa Firona tsǝki Yisǝfu lullǝu mala amǝ Masar ama, Zafǝnat-Panǝya, sǝ pè wi Asenat, ɓoarnsarile Potifera, ɓè pǝris mala ndà-peri a nggea-là On, ɓǝ̀ duk māmí. Nda aɓwana zǝ̀kìce Yisǝfu aɓa nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yisǝfu ka ndanǝ pǝlǝa lumi-tàrú sǝ tita túró a ban Firona murǝm Masar. Firona pè Yisǝfu túró a buì, sǝ pè wi gara ɓǝ̀ duk nggwamna amur nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Aɓalǝ apǝlǝa tongno-nong-ɓari mala ɗǝmbo ka, nzali pusǝ girlina kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Sǝ aɓalǝ amǝno yì apǝlǝa ka, Yisǝfu ram girlina mǝnana à rì aɓa nzali Masar ka. A koya nggea-là ka, à so mǝsǝsa mǝnana à pusǝì arǝ aɓaban malea ka aɓalǝ abah. ");
INSERT INTO mbu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","À gwali mǝsǝsa kǝla sala mǝnana a kún nggeamùr ka, gandǝa Yisǝfu tamsǝ kārǝki gìr mǝnana aɓwana kǝ yinǝi ka. Girlina ramba à gandǝ ɓallè ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kaniama apǝlǝa mala nzala nǝ̀ yiu ka, Yisǝfu kum amuna-burana ɓari, mǝnana Asenat nsari mala Potifera, pǝris mala On ɓǝli wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yisǝfu tsǝkî muna-dǝmba male lullǝu ama Manasa, acemǝnana bang ama, <<Ɓakuli tsǝ́ngŋǝ̀nà ɓalǝam lorǝna tanni mem andǝ ɓala mala tárrám.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ɓaria muna-ɓwabura ka, Yisǝfu tsǝki wi lullǝu ama Ifǝrem, acemǝnana bang ama, <<Ɓakuli panam amuna a nzali tanni mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Apǝlǝa tongno-nong-ɓari mala hatǝki mala girlina a nzali Masar yiu a masǝlǝate, ");
INSERT INTO mbu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","sǝ apǝlǝa mala nzal-gula tite, kǝla mǝnana Yisǝfu bang ngga. Nzala kpa arǝ aɓea anzali kat, sǝ aɓa nzali Masar kat ka, girlina na kam kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Lang nzala kútí arǝ amǝ Masar ka, à warinǝ ɓua malea aban Firona murǝm ace girlina. Firona murǝm banggia wia ama, <<Wu kya ban Yisǝfu, sǝ gìr mana kat bangga wun ngga, wu pè.>> ");
INSERT INTO mbu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Lang nzala akinaban kat aɓa nzali ka, pǝlǝa Yisǝfu mǝngi abân tsǝk agirlina kat, sǝ makki amǝ Masar girlina, acemǝnana nzala ɓikina aɓa nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aɓwana arǝ abân a bum ɓanza kat yiu a Masar ace kúr girlina aban Yisǝfu, acemǝnana nzala akina ɓanza kat. ");
INSERT INTO mbu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Lang Yakupu ok ama mǝsǝsa na a Masar ka, ne amuni ama, <<Palang sǝ wu kǝ sǝngi rǝarǝ wun? ");
INSERT INTO mbu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ən ok ama mǝsǝsa kúró na a Masar. Wu o wu kya kúr mǝsǝsa ace mǝnana ɓǝ̀ sǝm apî nzala, ɓǝ̀ ana raka ndo sǝm nǝ̀ wukio.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Pǝlǝa amǝ'gula Yisǝfu yia lum, à wari a Masar a kúr mǝsǝsa. ");
INSERT INTO mbu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sǝ Yakupu ka earî Benjami, mǝ'kyauwa Yisǝfu ɓǝ̀ o ateà ɗàng, acemǝnana ǝn'ò kǝ pakki tárrí cè ɓè kǝgir mǝɓane kum muna ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nda amuna-burana mala Yakupu wario andǝ aɓea ɓwana a Masar ace kúr girlina ka, acemǝnana nzala kpana gbal a nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sǝ acemǝnana Yisǝfu nda nggwamna mala Masar sǝ nda mǝnana makkiyi aɓwana girlina ka, amǝ'eambi wari a baní, à kya ɓunno a ɓadǝmbi nǝ ɓamǝsǝia a nzali. ");
INSERT INTO mbu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Lang Yisǝfu sǝn amǝ'eambi ka, kara súrǝ̀ia sǝ pa kǝla súrǝ̀ia ɗàng, kǝ nea wia cau nǝ lúllô. Ɗia ama, <<Wu pur a ya la?>> À pe wi eare ama, <<Sǝm pur a nzali Kan'ana, sǝm yiua kúr girlina.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yisǝfu ka súrǝ̀ amǝ'eambi, sǝ yia ka à súrǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ɓalǝ Yisǝfu kasǝ arǝ alorǝo male amúrià apǝlǝa pas mana à kutiki ka, sǝ nea wia ama, <<Wun nda ka amǝ'shenzǝ-nzali, wu yiua sǝn fě mala nzali ma'sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sǝ à pǝlǝi wi ama, <<Awo, ɓwamǝgule, sǝm yiu kǝla aguro mò, girlina na sǝm yiua kúrè ka. ");
INSERT INTO mbu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sǝm kat ka sǝm nda ka amuna mala ɓwa mwashat, sǝm nda ka amǝ'shenzǝ-nzali ɗang ɓwamǝgule, sǝm nda ka aɓwana amǝ'ɓafoe.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yisǝfu pǝlǝia wia ama, <<Ən earnǝ wun ɗàng! Wu yiua sǝn fě mala nzali ma'sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sǝ à pǝlǝi wi ama, <<Ɓwamǝgule, sǝm aguro mò ka, sǝm nda ka amuna-burana lum-nong-ɓari a bù tár sǝm a nzali Kan'ana. Mǝtankwang ma'sǝm ngga nda andǝ tár sǝm a là ado, sǝ ɓè mǝ'eam sǝm mwashat ka wuna.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yisǝfu pǝlǝia wia ama, <<Kǝla mǝnana ǝn na ka: Wun ngga wu nda ka amǝ'shenzǝ-nzali! ");
INSERT INTO mbu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ani sǝ mǝ nǝ súrǝ̀ mǝsǝcau: Mbak-kàngkàng Firona nakam ngga, pà wu nǝ nying Masar ɗàng sheɓǝ̀ wu yina nǝ mǝ'kyauwa wun ngga! ");
INSERT INTO mbu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wu túr mwashat aɓalǝ wun ɓǝ̀ kya yinǝ mǝ'kyauwa wun; cili wun ngga mǝ nǝ gìr wun a ndà, she ɓǝ̀ cau mǝnana wu na ka, yi purna ama mǝsǝcau na ka. Ɓǝ̀ ana raka ǝn kánbà wun nǝ yilǝmi Firona, wun nda ka amǝ'shenzǝ-nzali!>> ");
INSERT INTO mbu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Pǝlǝa gìria a ndà nongŋo tàrú. ");
INSERT INTO mbu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A tàruià nongŋo ka, Yisǝfu nea wia ama, <<Mim ngga ǝn nggǝ ɓanggi Ɓakuli. Gìr mwashat na wun nǝ̀ pa sǝ mǝ nǝ nying wun nǝyilǝmu ka. ");
INSERT INTO mbu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ɓǝ̀ wu nda ka aɓwana amǝ'ɓafoe ka, wu tàr ɓwa mwashat aɓalǝ wun ɓǝ̀ ueo kani a ndàkurban, sǝ cili wun ngga wu umnǝ girlina aban amǝ'ɓala ma'wun mǝnana à nda aɓa nzala ka. ");
INSERT INTO mbu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sǝ dumǝna púp wun nǝ̀ yinǝ mǝ'kyauwa wun abanam, ace mǝnana ɓǝ̀n sǝlǝ ama mbak-kàngkàng wu nda aban na mǝsǝcau, sǝ pà mǝ nǝ wal-lú wun ɗàng.>> Sǝ yia ka à eare ama à nǝ̀ pa anggo. ");
INSERT INTO mbu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sǝ à ne arǝia ama, <<Mǝsǝcau gìr mǝɓane mǝnana sǝm pakkî mǝ'kyauwa sǝm ɗiɗyal ka, nda mǝno sǝm nggǝ kum tangnakusǝu tanni male ka. A bàkú mǝno ka sǝm sǝn tanni mǝnana nda aɓalǝi, mana kǝ ɓua kǝ zǝmba sǝm, sǝ sǝm ginǝ oě ka; nda gìr mǝnana tsǝa sǝ tanni mǝnia sulǝo amur sǝm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Pǝlǝa Ruben nea wia ama, <<Ən bangga wun a pwari mǝno nǝma wu kǝa tsǝk bù arǝ muna man ama wun nǝ̀ pàkkî wi cauɓikea ɗang sǝ wu ginǝe! Ado ka dumǝna púp sǝm nǝ̀ mbwe nkila male mǝnana sǝm sukki ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yia ka à sǝlǝ ama Yisǝfu kǝ ok cau mǝnana à kǝ na ka ɗàng, acemǝnana ɓè ɓwa na Yisǝfu yinǝi kǝ nyesǝia wia cau nǝ kún malea ka. ");
INSERT INTO mbu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yisǝfu gǝshì bania sǝ sukki mǝrǝm, pǝlǝa imsǝ mǝsǝi sǝ nyare abania nea wia cau. Pǝlǝa tsǝa à bwal Shimiyon à taka abui akǝ ɓadǝmbia. ");
INSERT INTO mbu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yisǝfu pǝlǝa ne amǝ'túró male ɓǝà lùmsǝki abuku mala amǝ'eambi nǝ mǝsǝsa sǝ ɓǝà nyesǝî koya ɓwa ka boalo male mǝnana pǎ ace kúr mǝsǝsa ka aɓa buku male, sǝ ɓǝà pea wia girlina mǝnana à nǝ̀ li aban o a njar ka. Anggo gbal sǝ à pakkia wia. ");
INSERT INTO mbu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","À tsǝk abuku mǝsǝsa malea a nzǝm amǝdambǝriso malea sǝ à kpa a njar. ");
INSERT INTO mbu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lang à yi bwalǝna ban mǝnana à nǝ̀ nong kam ngga, ɓè ɓwa ateà mǝn kún buku male nǝ̀ pè mǝdambǝriso male girlina, kara sǝni ka boalo male na a kún buku. ");
INSERT INTO mbu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ne amǝ'eambi ama, <<À nyesǝnàm boalo mem. Wu sǝni, ndya aɓa buku mem ngga!>> Ɓabumia yasǝlǝia, ɓangciu pakkia wia pǝlǝa à ɗì rǝia ama, <<Ya gìr na mǝnia Ɓakuli pakka sǝm ngga?>> ");
INSERT INTO mbu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lang à yi bwalna ban tárrià a nzali Kan'ana ka, à twal cau mala gìr mǝnana kumia kat ka à ne wi. À bang ama, ");
INSERT INTO mbu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","<<Ɓwabura mǝnana nda nggwamna amur nzali Masar ka na sǝm cau nǝ pekiban ama sǝm nda ka amǝ'shenzǝ-nzali malea. ");
INSERT INTO mbu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Sǝm ne wi ama, sǝm nda ka aɓwana amǝ'ɓafoe, sǝm nda ka amǝ'shenzǝ-nzali ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sǝm ngga sǝm nda lum-nong-ɓari a bu tár sǝm, mwashat wuna, sǝ mǝtankwang ma'sǝm ngga nda a ban tár sǝm a nzali Kan'ana.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Pǝlǝa ɓwabure mǝnana nda nggwamna mala nzalinì ka na sǝm ama, <<Gìr mǝnana wun nǝ̀ pa sǝ mǝ nǝ earnǝ wun ngga nda mǝnana ama, wun nǝ̀ nying mǝ'eam wun mwashat abanam, sǝ cili wun ɓǝ̀ umnǝ girlina aban amǝ'ɓala ma'wun mǝnana aɓa nzala ka. ");
INSERT INTO mbu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Wu kya yinǝ mǝtankwang ma'wun abanam. Anggo sǝ mǝ nǝ ear ama wun nda ka aɓwana amǝ'ɓafoe, wu yiua shenzǝ-nzali ɗang. Pǝlǝa mǝ nǝ panzǝà wun mǝ'eam wun, sǝ wun nǝ̀ lidǝmba nǝ kúró a nzali ma'sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lang koyan ngga ndaban solǝki mǝsǝsa mana aɓa buku male ka, à sǝni ka, koya ɓwa ka boalo male mǝnana pà ace kúr mǝsǝsa ka, nda aɓa buku male; sǝ lang à sǝn boale ka, yia andǝ tárrià ka ɓabumia tù mùr. ");
INSERT INTO mbu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tárrià Yakupu banggia wia ama, <<Wu malǝna amuna arǝàm. Yisǝfu umá; Shimiyon umá; sǝ ado ka wu kǝ earce wun nǝ̀ umnǝ Benjami ɗǝm. Kǝ mǝ nda mǝno tanni kǝ kumam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Pǝlǝa Ruben ne tárrí ama, <<Ɓǝ̀n nyesǝ Benjami a bano raka, wal-lú ka amuna-burana mem ɓari. Nyi a buam, mim ngga mǝ nǝ nyesǝô wi.>> ");
INSERT INTO mbu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Sǝ Yakupu ka nyesǝi wi ama, <<Munem pà nǝ̀ ká atà wun ɗàng. Mǝ'eambi wuna, kǝ yì na ue nǝmurǝi ka. Ɓǝ̀ ɓè kǝgìr mǝɓane kumi a njar, a gya mǝno wun nǝ̀ twal ka, wun ndo wun nǝ̀ tasǝtam nǝ mbù amuram a Shewol nǝ bumkiɗikea.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Adyan ngga nzala ɓikina kǝ̀rkǝ́r a nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lang Yakupu andǝ amǝ'ɓala male lina mǝsǝsa mǝnana à kùró a Masar ka, Yakupu banggia wia ama, <<Wu nyare a Masar wu kya kúrà sǝm mǝsǝsa ɗǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yahuda banggi wi ama, <<Ɓwabura mǝnana makka sǝm mǝsǝsa ka, nunkir sǝm nǝ pekiban ama, <Pà mǝ nǝ eara wun, wun nǝ̀ kùtí abanam ace sǝnam ɗang, she ɓǝ̀ wu yina nǝ mǝ'eam wun atà wun ngga.> ");
INSERT INTO mbu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ɓǝ̀ awu nǝ eare a nǝ tasǝ mǝ'kyauwa sǝm atà sǝm ngga, sǝm nǝ̀ o a Masar ace kúr mǝsǝsa. ");
INSERT INTO mbu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Sǝ ɓǝ̀ a pà nǝ tasǝì raka, pà sǝm nǝ̀ ká akanó ɗang, acemǝnana ɓwabure bangŋǝ́nà ama, <Pà wun nǝ̀ sǝn ɓamǝsǝàm ɗàng she ɓǝ̀ mǝ'kyauwa wun na atà wun ngga.> >> ");
INSERT INTO mbu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isǝrayila, yì Yakupu ɗia ama, <<Palang sǝ wu yinǝàm nǝ tanni mǝnia amuram nǝ banggi ɓwabure ama wu ndanǝ ɓe mǝ'eam wun le?>> ");
INSERT INTO mbu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","À earî wi ama, <<Ɓwabure ɗiki sǝm pepè amur ɓamur rǝ sǝm andǝ ɓala ma'sǝm ama, <Tár wun nakam nǝyilǝmu più le? Wu ndanǝ ɓe mǝ'eambu le?> Dumǝna púp sǝm nǝ̀ pe wi eare amur aɗikiban mǝnana ɗiki sǝm ngga. Lang sǝ sǝm nǝ̀ sǝlǝa ama nǝ̀ bang ama, <Wu yinǝ mǝ'kyauwa wun atà wun?> >> ");
INSERT INTO mbu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Pǝlǝa Yahuda banggi tárrí Isǝrayila ama, <<Nyinggam yì muna a buam sǝ sǝm nǝ̀ lo sǝm nǝ̀ o, ace mǝnana sǝm sǝnǝ we, andǝ amuna mǝkèke ma'sǝm gbal ka, ɓǝ̀ sǝm àwá, ɓǝ̀ sǝm ngga wukî nzala ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Muna ka, mǝ nda rǝ kánbò, mim nǝ nggearǝam, mǝ nǝ yállí. Ɓǝ̀ ǝn nyesǝi ǝn yinǝi a bano ǝn yi tamsǝi a ɓadǝmbo raka, ɓǝ̀ cê pà amuram bà. ");
INSERT INTO mbu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ɓǝ̀ sǝm kìdìkima pwari raka, ɓǝ́ adyan ngga sǝm warina sǝ nyarna kusǝ ɓari.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Pǝlǝa tárrià banggia wia ama, <<Ɓǝ̀ ɓekǝ njar pà kàm sǝm nǝ̀ purî ɓá mǝnia yì cau raka, wu pàk gìr mǝnia ka: wu twal atà aɓea agir mǝɓoarne mala nzali mǝnia ka aɓalǝ abuku ma'wun, wu kyan nǝia kǝla ɓoro aban ɓwabure; wu ɗàrǝ́ myang bǝti, andǝ mùr-nyì bǝti, andǝ mùrú-hasǝa andǝ mukugìr mǝ'rǝmɓoarne, andǝ mǝsǝbyara, sǝ ɓǝla-ngbamso, wu kya pe wi. ");
INSERT INTO mbu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Wu twal boalo mana kàr boalo kúr mǝsǝsae kusǝ ɓari ka, ace mǝnana ɓǝ̀ wu kya nyesǝ aboalo mana wu kumia a kún abuku ma'wun ngga. Yakǝla à ɓwarki nǝ ɓwarkio sǝ à tsǝka wunia aɓalǝ abuku ma'wun. ");
INSERT INTO mbu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wu twal mǝ'eam wun atà wun, wu bwal njar wu nyare aban ɓwabure. ");
INSERT INTO mbu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ɓǝ̀ Ɓakuli mana Karban Kat nǝ Gulo ka tsǝa ɓǝ̀ ɓwabure sǝn mǝsǝswatǝr ma'wun ace mǝnana ɓǝ̀ nying Shimiyon andǝ Benjami ɓǝ̀ wu nyar wunǝia. Ma mem ngga ɓǝ̀ dumǝna púp ama mǝ ɗwanyi amuna mem ngga, mǝ nǝ ɗwanyia.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Nda amuna mala Yakupu kùr aɓoro mana tárrià pà ka, à twal boalo mana karǝ kúr mǝsǝsa mǝno kusǝ ɓari ka, sǝ ɗǝm ngga à twal Benjami ateà, sǝ à bwal njargula à o a Masar. Wario malea ka, à kya kutio à cam a ɓadǝm Yisǝfu. ");
INSERT INTO mbu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Lang Yisǝfu sǝn Benjami ateà ka, banggi ɓwamǝgule mala amǝ'túró-ɓala male ama, <<Kyan nǝ aburana mǝnia ka a ɓala mem. Yia ka à nǝ̀ lì girlina-pwari atàm yalung. O kya pwan-myal girkusǝu sǝ ɓǝà lam girlina.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mǝtúró-ɓala man pa kǝla mǝnana à banggi wi ka, wari nǝ amǝ'eam Yisǝfu a ɓala mala Yisǝfu. ");
INSERT INTO mbu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amǝ'eam Yisǝfu ka ɓangciu bwalia kǝ̀rkǝ́r lang à sǝni à nda rǝ umnǝia a ɓala mala Yisǝfu ka. À bangŋi arǝarǝia ama, <<Yi ka nda rǝ kánǝ sǝm ace aboalo mǝnana sǝm kumia aɓalǝ abuku ma'sǝm, a yiu ma'sǝm mǝdǝmbe ka. Nda rǝ alta njar arǝ sǝm ace mǝnana nǝ̀ kum sǝm nǝ cau, ace bwalki sǝm ɓǝ̀ sǝm duk aguro sǝ nǝ̀ ak amǝdambǝriso ma'sǝm arǝ sǝm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Lang à bingŋǝ́nà kún ɓala ka, à sungŋo aban mǝtúró-ɓala mana amúr ɓala mala Yisǝfu ka ");
INSERT INTO mbu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","sǝ à bang cau nǝi ama, <<Ɓwamǝgule, Ida, kwakikiro arǝ sǝm. Sǝm yina kani ɗiɗyal ace kúr girlina. ");
INSERT INTO mbu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","A njar aban o a là ka, sǝm sulǝo a ɓè ban ace usǝlǝo, sǝ sǝm mǝngi abuku ma'sǝm, kara koyan atà sǝm ngga sǝn boalo male mǝnana kat pà ace kúr mǝsǝsa ka, a kún buku male. Yiu ma'sǝm mǝnia ka, ndya sǝm nyesǝ aboale ka. ");
INSERT INTO mbu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Aɓea boalo nya gbal sǝm yinǝia a bù sǝm ace kúr mǝsǝsa ɗǝm ngga. Sǝm súrǝ̀ ɓwa mǝnana tsǝka sǝm aboalo mǝno aɓalǝ abuku ma'sǝm ngga ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mǝtúró-ɓala man banggia wia ama, <<Wu nongsǝ ɓalǝ wun. Cè ɓangciu pàkka wun ɗàng. Ɓakuli ma'wun, yì Ɓakuli mala tár wun, nda mǝnana tsǝka wun mǝnia yì gǝna aɓalǝ abuku ma'wun ngga, acemǝnana boalo mana wu mbwe a pwari mǝno ace kúr mǝsǝsa ka, mǝ nda ǝn ak boale ka.>> Sǝ kutio wario kya panzǝ Shimiyon a ndàkurban, pusǝì yinǝi abania. ");
INSERT INTO mbu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mǝtúró-ɓala man pǝlǝa kútinǝia a ɓala mala Yisǝfu. Pea wia mùr ɓǝà lakki akusǝia sǝ peà amǝdambǝriso malea girlina. ");
INSERT INTO mbu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Banggia wia ama ɓǝ̀ pwari eauna a ɓongŋu ka, à nǝ̀ lì girlina atārǝia andǝ Yisǝfu. Nda à gilǝkice aɓoro mana à nǝ̀ pè Yisǝfu ɓǝ̀ yina ka. ");
INSERT INTO mbu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Lang Yisǝfu yina a ɓala ka, à pè wi aɓoro mǝnana à yinǝì wi ka, pǝlǝa à ɓunno a nzali a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Anzǝm mana mangŋǝ́nià-kún ngga, ɗìban ama, <<Lang tár wun, yì jamgula mǝnana wu banggam cau male a pwari mǝno ka? Ndakam più andǝamǝsǝi le?>> ");
INSERT INTO mbu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","À eari wi ama, <<E, tár sǝm, yì guro mò ka ndakam più andǝamǝsǝi, sǝ nda bǎng.>> Nyare à ɓunno a nzali a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Lang Yisǝfu loasǝ mǝsǝi sǝn mǝ'eambi Benjami, mǝnana à nda nggeau mwashat ka, ɗia ama, <<Mǝnia nda mǝ'kyauwa wun mǝnana wu banggam cau male ka le? Ɓǝ̀ Ɓakuli tsǝko bù, munem.>> ");
INSERT INTO mbu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kara Yisǝfu lo a kaurǝa nying banià, acemǝnana mǝrǝm yi lùmsǝ mǝsǝi, ue bǝti ɓǝ́ sangna a ɓua; earcearǝu mǝkǝ̀rkǝ́rnì ace mǝkyauwe na yi lùmsǝ bumi ka. Wario kya kúti a kurǝm male sǝ ɓua kàm. ");
INSERT INTO mbu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Anzǝm mǝno ka, lak ɓamǝsǝi sǝ puro yiu abania ɗǝm, imsǝ mǝsǝi. Banggi amǝ'túró-ɓala male ama ɓǝà gau girlina. ");
INSERT INTO mbu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yisǝfu do a banli male nǝmurǝi, sǝ amǝ'eambi ka à tsǝkia wia amalea yì akwar girlina a ban malea ɗàng. Amǝ Masar do a malea yì banli tarang, acemǝnana amǝ Masar kǝ lìli a kwar mwashat andǝ amǝ Ibǝru ɗàng; mǝno ka gìr ɓeami na aban amǝ Masar. ");
INSERT INTO mbu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Amǝ'eam Yisǝfu do a banli malea à kǝ sǝn ɓamǝsǝ arǝia andǝ Yisǝfu. À dumsǝia nǝ kpata pǝlǝa mala ɓǝlban malea, tite aban muna-dǝmba aban ká aban mǝtankwang malea. Lang à sǝn do mǝno à dumsǝia ka, à sǝngi rǝarǝia nǝ ndali. ");
INSERT INTO mbu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Girlina ka a ɓadǝm Yisǝfu sǝ à ɗarǝi à pe koyan ngga. À ɗarǝî Benjami male kpǝm kusǝ tongno kútì mǝnana à ɗarǝî koyan atà acili amǝ'eambi ka. Nda à lì girlina sǝ à nu girnùná atārǝia andǝ Yisǝfu, sǝ à makrǝia nǝ banɓoarnado ka. ");
INSERT INTO mbu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Lang amǝ'eambi gilǝnarǝia à nǝ̀ o ka, Yisǝfu banggi ɓwamǝgule amur amǝ'túró-ɓala male ama, <<Lùmsǝ abuku mala aburana man nǝ mǝsǝsa kǝla mana à nǝ̀ gandǝ twale ka, sǝ nyesǝî koyan ateà ka boalo male; oasǝkia wia a kún abuku malea. ");
INSERT INTO mbu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Sǝ oasǝ kap azǝrfa mala nugìr mem aɓa buku mala mǝtankwang malea, atārǝia andǝ boalo male mǝnana pà ace kúr mǝsǝsa ka.>> Mǝtúró-ɓala man pa kǝla mǝnana Yisǝfu banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ban fana nǝ dǝmbari ɗiɗyal ka, amǝ'túró-ɓala mala Yisǝfu tsǝktea ɓǝà o, pǝlǝa à bwal njar aban o nǝ amǝdambǝriso malea. ");
INSERT INTO mbu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lang à purnì nzǝm la sǝ à malaká o ɗār raka, Yisǝfu banggi ɓwamǝgule amur amǝ'túró-ɓala male ama, <<Lo pyangnǝata aburana mǝno! Ɓǝ̀ a kya bwalnateà ka, bang ama, <Ace mana sǝ wu mbweban nǝ mǝɓane a kún mǝɓoarne? ");
INSERT INTO mbu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ace mana sǝ wu iu kap nugìr mala mǝtala-ɓala mem? Nugìr na nǝmurǝi mǝnana mǝtala-ɓala mem kǝ nu aɓa mǝno yì kap ka ɗàng, aɓalǝi gbal sǝ kǝ ɓangnǝ-ɓangnǝa. Gìr mǝnana wu pè ka nggea mǝɓane na!> >> ");
INSERT INTO mbu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Lang mǝtúró-ɓala man kya bwalteà ka, ɓǝsǝlǝ amǝnia yì acau ka. ");
INSERT INTO mbu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","À eari wi ama, <<Mana girnì na a nakiyicau amurí, ɓwamǝgule, nǝ bang ulang mǝnia yì cau ka? Kpekpe pà sǝm nǝ̀ pàk kǝgìr kǝla mǝno ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","We ka a sǝlǝna ama aboalo mǝnana sǝm kya kumia a kún abuku ma'sǝm akanó a nzali Kan'ana ka, sǝm nyesǝô wia. Sǝ ace mana sǝ sǝm nǝ̀ kùtí a iu azǝrfa ko bolo-njengǝlan a ɓala mala mǝtala-ɓala mò? ");
INSERT INTO mbu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɓwamǝgule, ɓǝ̀ a kum mǝnia yì kap a bù kǝ ɓwa atà sǝm ngga, ɓǝà wal-luí, sǝ cili sǝm ngga sǝm nǝ̀ duk aguro mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ɓwabure bang ama, <<E, ǝn earna, mǝ nǝ pàk gìr mǝnana wu bang ngga. Sǝama ɓwa mǝnana twal mǝnia yì kap ka nda mǝnana nǝ̀ duk guro mem ngga, sǝ cili wun ngga wun nǝ̀ o atà rǝ wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Pǝlǝa koyan ateà ka sulǝ buku mǝnana a nzǝm mǝdambǝriso male ka, sǝ mǝn kún buku. ");
INSERT INTO mbu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Pǝlǝa mǝtúró-ɓala man kùtí a alta kap man aɓa koya buku ka. Tite nǝ buku mala muna-dǝmba sǝ yi masǝlǝi nǝ buku mala mǝtankwang malea. Yi kum kapni aɓa buku mala Benjami. ");
INSERT INTO mbu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lang amǝ'eambu man sǝn gìr man ngga, yia kat ka à sangi anggea-daura malea ace bumkiɗikea. Pǝlǝa koya ɓwa ka eamsǝ twalo a nzǝm mǝdambǝriso male, sǝ à nyare a nggea-là. ");
INSERT INTO mbu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yisǝfu ka nda a ɓala male più sǝ Yahuda andǝ amǝ'eambi nyare à yiu. À yi kpa a nzali a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yisǝfu ɗia ama, <<Mana mǝnia wu pàk ka? Wu sǝlǝ mbak ama ɓwa kǝla mim ngga nǝ̀ gandǝ súrǝ̀ gir mǝnana nda aɓa sǝmbǝrǝa ka nǝ ɓangnǝ-ɓangnǝa?>> ");
INSERT INTO mbu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda eari wi ama, <<Ya cau sǝm ndanǝi sǝm nǝ̀ na, mǝtala-ɓala mem? Lang sǝ sǝm nǝ̀ bǝlkun sǝm? Mana sǝm nǝ̀ gandǝ pa ace lakɓamur rǝ'sǝm? Ɓakuli pusǝnatà cauɓikea mala aguro mò. Sǝm kat sǝnǝ ɓwa mǝnana à kumi nǝ kapni ka, sǝm pǝlǝna aguro mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yisǝfu bang ama, <<Awo, pà anggo ɗàng! Pà mǝ nǝ pàk gìr kǝla mǝno ka ɗàng. Ɓwa mǝnana à kumi nǝ kap ka, yì nǝmurǝi nda nǝ̀ duk guro mem ngga. Cili wun ngga wu nyare wu o a là nǝ rǝpwala aban tár wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yahuda sung tù aban Yisǝfu sǝ bang ama, <<Ɓwamǝgule, ida, earâm mǝ nacau nǝ we. Cè bumo lúllô arǝàm, mim guro mò ɗàng, acemǝnana rǝcandǝa mò ka nda mwashat andǝ mala murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","<<Ɓwamǝgule mem, a ɗî sǝm ko tár sǝm ngga ndakam più nǝyilǝmu, sǝ ɗǝm ngga we ama ko sǝm ndanǝ ɓe mǝ'eambu. ");
INSERT INTO mbu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Sǝm earô ɓwamǝgule ama, <E, tár sǝm ngga ndakam nǝyilǝmu, sǝama ena kǝ̀rkǝ́r. Yì tár sǝm ngga ndanǝ muna-ɓwabura mǝkyauwe mǝnana à ɓǝli wi a ě male ka. Muni mǝnia ka ndanǝ mǝgule mǝnana wuna ka, sǝ ado ka yì nda kǝ muna mala nggè mǝnana ueo nǝyilǝmu ka; tárrí kǝ earce kǝ̀rkǝ́r.> ");
INSERT INTO mbu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","<<A bangga sǝm ama, <Wu yinǝ mǝno yì mǝ'kyauwa wun ngga akani ace mǝnana mǝ sǝni nǝ amǝsǝàm ngga.> ");
INSERT INTO mbu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Sǝ sǝm banggo ɓwamǝgule ama, <Mune ka pà sǝm nǝ̀ gandǝ pusǝì ɓǝ̀ nying tárrí ɗàng; ɓǝ̀ nying tárrí ka, tárrí nǝ̀ wǔ.> ");
INSERT INTO mbu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sǝ a bangga sǝm ama, <Ɓǝ̀ wu nyare wu yiu sǝ mǝ'kyauwa wun mǝno pà atà wun raka, pà mǝ nǝ eara wun ɓǝ̀ wu sǝn ɓamǝsǝam ɗǝm ɗàng.> ");
INSERT INTO mbu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","<<Lang sǝm nyare a là aban tár sǝm guro mò ka, sǝm kya banggi wi acau mǝnana we ɓwamǝgule a bangga sǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","<<Nǝnzǝ́mò ka tár sǝm yi bangga sǝm ama ɓǝ̀ sǝm nyare a Masar ace kúr girlina. ");
INSERT INTO mbu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Sǝm banggi wi ama, <Pà sǝm nǝ̀ gandǝ nyare sǝm nǝ̀ ká a Masar ɗàng she ɓǝ̀ mǝ'kyauwa sǝm na atà sǝm ngga. À pà nǝ̀ eara sǝm ɓǝ̀ sǝm sǝn ɓamǝsǝ ɓwabura mǝno a Masar ka ɗàng, she ɓǝ̀ mǝ'kyauwa sǝm ngga nda atà sǝm ngga.> ");
INSERT INTO mbu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","<<Pǝlǝa tár sǝm, guro mò bangga sǝm ama, <Wu sǝlǝna ama māmám Rahila ɓǝlâm amuna-burana ɓari. ");
INSERT INTO mbu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ɓè man mwashat ka ǝn ɗwanyini. Anyam-candǝa sangina nyami a ɓabondo, acemǝnana ǝn nyare ǝn sǝni ɗǝm ɗàng lang umǝna ka. ");
INSERT INTO mbu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ɓǝ̀ wu twal mǝnia arǝàm ado sǝ ɓè kǝgìr kya kumǝni ka, wun nǝ̀ tàsǝám, mim mǝjamgula a Shewol nǝ bumkiɗikea.> ");
INSERT INTO mbu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","<<Ado ka ɓǝ̀ ǝn nyare sǝ ǝn o aban tár sǝm, yì guro mò, sǝ yì tár sǝm mǝnana yilǝmi muna nda yilǝmi ka, ");
INSERT INTO mbu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","yi sǝni muna ka pà atàm raka, nǝ̀ kasǝa nǝ̀ wú. Sǝ sǝm aguro mò ka, sǝm nǝ̀ duk amǝ'cauɓikea mala tasǝta mǝjamgula ma'sǝm, yì guro mò, nǝ mbù amurí a Shewol aɓa bumkiɗikea. ");
INSERT INTO mbu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ən kánbì tár sǝm gìr ama mǝ nǝ nyesǝ mune a là jam. Sǝ ado ɓǝ̀n nyesǝì wi muna raka, mǝ nǝ twal twalo mala do nǝ cau arǝàm a ɓadǝm tárrám aɓa cili do mem kat. ");
INSERT INTO mbu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","<<Acemani ka, ida, ɗeki ɓǝ̀n ue kani kǝla guro mò a kúnì mǝtankwang ma'sǝm, sǝ ɗeki yì muna ka ɓǝ̀ o a là atārǝia andǝ acili amǝgule. ");
INSERT INTO mbu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Lang sǝ mǝ nǝ nyare mǝ nǝ ká aban tár sǝm sǝ yì muna ka pà kàm atàm ɗàng? Pà mǝ nǝ gandǝ came mǝ nǝ sǝn gìr'mur'mwana mǝnana nǝ̀ sulǝo amur tárrám ngga ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yisǝfu ka gandǝ bwal ɓabumi a ɓadǝmba amǝtè kat ɗàng, nda loasǝ gì bang ama, <<Wu tsǝk koyan ngga ɓǝà purî banam.>> Kǝɓwa pà kam atà Yisǝfu ɗàng lang banggi amǝ'eambi yan nda yì ka. ");
INSERT INTO mbu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Sǝ loasǝ gì sak a ɓua nǝ tusǝki ɓālǝi gandǝ amǝ Masar mǝnana a nza ka à oè, sǝ cê ak ɓá palta mala murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yisǝfu banggi amǝ'eambi ama, <<Mǝ nda Yisǝfu! Tár sǝm nakam nǝyilǝmu più le?>> Amǝ'eambi gandǝ nyesǝì wi kǝ cau ɗàng, acemǝnana nggea ɓangciu bwalia kǝ̀rkǝ́r a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yisǝfu ne amǝ'eambi ama, <<Ida, wu yiu abanam tù.>> Pǝlǝa à sungŋo abani, sǝ na ama, <<Mǝ nda Yisǝfu, mǝ'eam wun, mǝnana wu mé sǝ à yinǝi a Masar ka. ");
INSERT INTO mbu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sǝ ado ka, wu kǝa pàk bumkiɗikea ɗang, sǝ cè bum wun lúllô arǝ ɓamur rǝ wun ama wu mém sǝ à yinǝ mim kani ka ɗàng. Ɓakuli ka nda ak dǝmba tasǝam mǝ akà wun dǝmba yiu kani ace amsǝ yilǝmi aɓwana. ");
INSERT INTO mbu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mǝnia nda ɓaria pǝlǝa mala nzala aɓa nzali mǝnia ka; apǝlǝa tongno nakam più mǝnana nzala man nǝ̀ lidǝmba, sǝ aɓalǝia ka rya pa kàm ɗàng, sǝ pwan gìrɓaban pa kàm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ɓakuli tasǝam mǝ akà wun dǝmba ace tsǝkcè atsǝktau a ɓanza ace wun, sǝ ɓǝà amsǝ ayilǝmi wun nǝ mǝnia yì kaɓa amsǝban ngga. ");
INSERT INTO mbu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ace mǝno ka, wun nda wu tasǝam kani ka ɗàng, Ɓakuli na. Pànâm bancame kani mǝ do mǝkwarkiru aban murǝm, kǝla ɓwamǝgule amur ɓala male kat, sǝ mǝ'yálmúr nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","<<Ado ka wu nyare aban tárrám akaurǝa, wu banggi wi ama, <Mǝnia ka nda cau mana munio Yisǝfu na ka: Ɓakuli tsǝ́ngŋǝ̀nám mǝ nda nggwamna amur nzali Masar kat. Acemani ka, yiu a nzali Masar; kǝa dǝndi ɗang! ");
INSERT INTO mbu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Awu nǝ ya do a bu-nzali Goshen; awu nǝ do abanam tù, we wunǝ amunio andǝ amǝkeo, andǝ adomwan mala andá, andǝ mbulpǝndǝa, andǝ anzur mô, andǝ koman mǝnana kat a ndanǝi ka. ");
INSERT INTO mbu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","A ban mǝno ka mǝ nǝ pà wun girlina acemǝnana apǝlǝa tongno mala nzala nakam più; sǝ ǝn earce nǝma we wunǝ amǝ'ɓala mò andǝ agirkusǝu mô ɓǝ̀ wu kútí a do tapwasǝa ka ɗàng.> >> ");
INSERT INTO mbu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","<<Wun nǝ nggearǝ wun ngga, wun ndo wu kǝ sǝni nǝ amǝsǝ wun, sǝ mǝ'eambam Benjami gbal ka ndo kǝ sǝni nǝ mǝsǝì ama, mǝ nda ǝn nggǝ na wun cau nǝ kunam ngga. ");
INSERT INTO mbu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Wu banggi tárrám cau mala gulo mǝnana kat à pàm a Masar andǝ koman mǝnana kat wu sǝni ka. Sǝ wu yinǝ tárrám akani akaurǝa!>> ");
INSERT INTO mbu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Pǝlǝa Yisǝfu mǝn abui kùr mǝ'eambi Benjami a myali sǝ ɓua sukki mǝrǝm; Benjami gbal kǝ ɓua sǝ bwali arǝì. ");
INSERT INTO mbu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nǝ ɓua a kúni più, Yisǝfu mǝn abui kùr acili amǝ'eambi mwashat-mwashat, koyan ngga ateà. Anzǝm mǝno ka, amǝ'eambi nacau nǝi. ");
INSERT INTO mbu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Lang cau yì mǝsǝe aban ká a palta mala murǝm ama amǝ'eam Yisǝfu yina ka, Murǝm Firona andǝ amǝ'tè ka banɓoaria wia. ");
INSERT INTO mbu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firona ne Yisǝfu ama, <<Banggi amǝ'eambo ama: <Wu tsǝk twalo a nzǝm amǝdambǝriso ma'wun wu nyare a nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ɓǝ̀ wu warina ka, wu kya yinǝ tár wun andǝ amǝ'ɓala male ɓǝà tùr kani a Masar. Mǝ nǝ pà wun bu-nzali yál agir mǝnana ɓoaro kutibanì kat a Masar ka, sǝ wun nǝ̀ li gìr mǝɓoarne mala nzalinì.> ");
INSERT INTO mbu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","<<Ɗǝm ngga banggi amǝ'eambo ama: <Wu twal aɓea waru-pǝr mala Masar atà wun ace pwan amuna ma'wun, andǝ amālá wun, andǝ tár wun, wu yiu wunǝia kani akaurǝa. ");
INSERT INTO mbu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wu kǝa pè ɓamur rǝ wun tanni arǝ pwan agir ɓala ma'wun ɗàng. Acemǝnana koya mǝɓoarne aɓa nzali Masar kat ka nǝ̀ duk ma'wun.> >> ");
INSERT INTO mbu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Anggo sǝ amuna mala Yakupu pa kǝla mǝnana à banggia wia ka. Yisǝfu peà wia awaru-pǝr andǝ girlina mǝnana à nǝ̀ lì a njar, kǝla mǝnana murǝm Firona bang ngga. ");
INSERT INTO mbu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ɗǝm ngga pè koyan ateà ka bǝsa anggea-daura; sǝ mala Benjami ka pè wi boalo azǝrfa mǝsǝì gbǝman-tàrú andǝ bǝsa anggea-daura tongno. ");
INSERT INTO mbu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Sǝ tárrí ka túrìwìban nǝ amǝdambǝriso lum ajamne nǝ atwalo mala agir mǝɓoarne mala nzali Masar a nzǝmia, sǝ amǝdambǝriso lum amǝ'nggaule nǝ atwalo mala mǝsǝsa, andǝ agirlina, andǝ agirshake, ace gya male aban yiu a Masar. ");
INSERT INTO mbu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pǝlǝa Yisǝfu tasǝ amǝ'eambi ɓǝà o, sǝ lang à bwal njar aban o ka, banggia wia ama, <<Cè wu munǝ a njar fa!>> ");
INSERT INTO mbu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nda à nying Masar sǝ à nyare aban tárrià Yakupu a nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","À kya banggi tárrià ama, <<Yisǝfu nakam nǝyilǝmu! Yàle yì nda nggwamna mala nzali Masar kat!>> Cau mǝnia yipì Yakupu nǝ yasǝlǝban, sǝ túrí aɓa dǝmpǝndǝa; earnǝi ama cê ka mǝsǝcau na ɗang. ");
INSERT INTO mbu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sǝama lang à banggi wi acau mǝnana kat Yisǝfu banggia wia, sǝ lang sǝn awaru-pǝr mǝnana Yisǝfu tasǝia ɓǝà yi twali nǝia ɓǝà kyan nǝi a Masar ka, kara dǝmbi kwaro. ");
INSERT INTO mbu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Bang ama, <<Cau mǝnana wu bang ngga karǝna, ǝn earǝ̀nà nǝi. Munem Yisǝfu ka ndakam nǝyilǝmu. Mǝ nǝ ká sǝni sǝ mǝ wú!>> ");
INSERT INTO mbu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nda Isǝrayila, yì Yakupu tita gya male, pwan gìr mǝnana kat ndanǝi ka. Lang yi bik Biyasheba ka, pà agir'nkila aban Ɓakuli mala tárrí Ishaku. ");
INSERT INTO mbu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ɓakuli tunǝ Isǝrayila aɓa sǝna nǝ du, sǝ ne wi cau ama, <<Yakupu, Yakupu!>> Pǝlǝa eare ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ɓakuli bang ama, <<Mǝ nda Ɓakuli, yì Ɓakuli mala tárró. Cè ɓangciu pakko arǝ ká a Masar ɗàng, acemǝnana mǝ nǝ tsǝa tàu mò nǝ̀ hatǝki, awu nǝ duk aɓwana mala nzali mǝgule akanó. ");
INSERT INTO mbu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mǝ nǝ ká atò a Masar, sǝ nǝnzǝ́mò ka, mim nǝ nggearǝam, mǝ nǝ nyesǝ tau mò à nǝ̀ nyare a nzali mǝnia ɗǝm. We ka a nǝ wú a Masar, sǝ Yisǝfu nǝ̀ pà a nkanggario a lú mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Pǝlǝa Yakupu loapi Biyasheba nǝ̀ o a Masar. Nda amuna mala Isǝrayila twal tárrià yì Yakupu, sǝ à tsǝì aɓa waru-pǝr mǝnana Firona Murǝm Masar túrìwìban nǝi ka, sǝ à tsǝk amuna malea, andǝ amālia aɓalǝ acili awaru-pǝr. ");
INSERT INTO mbu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","À pwan agirkusǝu malea, andǝ agirkuma malea mǝnana à kúmô aɓa nzali Kan'ana ka, sǝ à o a Masar. Yakupu twal amǝ'ɓala male kat atè: ");
INSERT INTO mbu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","yìa amuna-burana male andǝ amǝkè amuna-burana, andǝ amuna-mamǝna male andǝ amǝkè amuna-mamǝna; yì tau male kat oa tè. ");
INSERT INTO mbu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Amǝnia ka, à nda ka alullǝ amuna-burana mala Isǝrayila, yì Yakupu, mǝnana à pwan rǝia sǝ à wari andǝi a Masar ka: Ruben yì muna-dǝmba male ka, ");
INSERT INTO mbu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","pwan amuna-burana male: à nda ka Hanok, andǝ Palu, Hezǝron andǝ Karmi. ");
INSERT INTO mbu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Muni Shimiyon pwan amuna-burana male: à nda ka Jemuyel, andǝ Jamin, andǝ Ohat, andǝ Jakin, andǝ Zohar, sǝ Shawul mǝnana nggè ka ɓwama Kan'ana na ka. ");
INSERT INTO mbu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawi pwan amuna-burana male: à nda ka Gashon, andǝ Kohat, andǝ Merari. ");
INSERT INTO mbu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda pwan amuna-burana male: à nda ka Shela, andǝ Perez andǝ Zera. (Amuna-burana mala Yahuda, yia Er andǝ Onan ngga, à akdǝmba à wǔ a nzali Kan'ana.) Perez pwan amuna-burana male: À nda ka Hezǝron andǝ Hamul. ");
INSERT INTO mbu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka pwan amuna-burana male: à nda ka Tola, andǝ Puwa, andǝ Jashup, andǝ Shimiron. ");
INSERT INTO mbu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulu pwan amuna-burana male: à nda ka Seret, andǝ Elon andǝ Jali. ");
INSERT INTO mbu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Amǝno ka à nda ka amuna-burana mǝnana Liya ɓǝlî Yakupu a Padan Aram ngga, sǝ ɓoarnsarile Dina. Làkkì mala amuna andǝ amǝkà Yakupu amuna-burana nǝ bu Liya ka, à nda lumi-tàrú-nong-tàrú (33). ");
INSERT INTO mbu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Muna-ɓwabura male Gad pwan amuna-burana male: à nda ka Zefon, andǝ Hagi, andǝ Shuni, andǝ Ezǝbon, andǝ Eri, andǝ Arodi andǝ Areli. ");
INSERT INTO mbu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asha pwan amuna-burana male: à nda ka Imǝna, andǝ Ishva, andǝ Ishvi andǝ Beriya. Mǝkyauwea muna-ɓwama Sera ka nda ateà. Beriya gbal ka pwan amuna-burana male: À nda ka Heba andǝ Malkiyel. ");
INSERT INTO mbu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Amǝno ka à nda ka amuna andǝ amǝkau mǝnana à ɓǝlî Yakupu nǝ bu Zilpa, yì muna-ɓwama mǝtúró-ɓala mala Laban mǝnana twali pè muni muna-ɓwama Liya, ɓǝ̀ duk muna-ɓala male ka. Yia kat ka à nda lum bwamdǝ tongno-nong-mwashat. ");
INSERT INTO mbu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Amuna-burana mala Yakupu mǝnana à ɓǝl andǝ māmí Rahila ka à nda ka: Yisǝfu andǝ Benjami. ");
INSERT INTO mbu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yisǝfu ka ak dǝmba nda a Masar, ban mǝnana à ɓǝlî wi amuna-burana ɓari: À nda ka Manasa andǝ Ifǝrem. Nggea nda Asenat, ɓoarnsarile Potifera, ɓè pǝris a On, yì Heliyopolis. ");
INSERT INTO mbu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjami pwan amuna-burana male gbal: À nda ka Bela, andǝ Becha, andǝ Ashbel, andǝ Gera, andǝ Naaman, andǝ Ehi, andǝ Rosh, andǝ Mupim, andǝ Hupim, andǝ Arǝd. ");
INSERT INTO mbu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Amǝno ka à nda ka amuna-burana mala Rahila andǝ amǝkè, mǝnana ɓǝlî Yakupu ka. Yia kat ka à nda lum nong ine. ");
INSERT INTO mbu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Muna-ɓwabura male Dan twal muni: Hushim. ");
INSERT INTO mbu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Muna-ɓwabura male Naftali pwan amuna-burana male: à nda ka Jaziyel, andǝ Guni, andǝ Jeza andǝ Shilem. ");
INSERT INTO mbu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Amǝno ka à nda ka amuna andǝ amǝkau mǝnana à ɓǝlî Yakupu nǝ bu Bilha, yì muna-ɓwama mǝtúró-ɓala mala Laban mǝnana twali pè muni muna-ɓwama Rahila, ɓǝ̀ duk muna-ɓala male ka. Yia kat à nda tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Amuna andǝ amǝkà Yakupu mǝnana à wari a Masar andǝi ka làkkì malea kat ka nda lumi-tongno-nong-mwashat nǝ mǝsǝi tongno-nong-mwashat (66). Amālá amuni ka à ɓallia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kpapì andǝ amuna-burana mala Yisǝfu mǝnana à ɓǝlî wi a Masar ka, làkkì mala amǝ'ɓala mala Yakupu, yia kat a nzali Masar ka lumi-tongno-nong-ɓari na (70). ");
INSERT INTO mbu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Lang à gbàshìnà Masar ka, Yakupu tasǝ Yahuda ɓǝ̀ aki wi dǝmba ká aban Yisǝfu, ɓǝ̀ banggi wi ama ɓǝ̀ kumia a Goshen. Lang Yakupu andǝ amǝ'ɓala male yi bingŋǝna ka, ");
INSERT INTO mbu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yisǝfu kùtí aɓa waru-pǝr male sǝ o a Goshen nǝ̀ nggá je andǝ tárrí, Isǝrayila. Lang à yì je ka, Yisǝfu mǝn abui yi kùr tárrí a myali sǝ ɓua banì sauwa. ");
INSERT INTO mbu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isǝrayila, Yakupu ne Yisǝfu ama, <<Ado ka mǝ nǝ gandǝ wú, acemǝnana ǝn sǝnǝno sǝ ǝn sǝlǝna ama a ndakam più nǝyilǝmu ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pǝlǝa Yisǝfu banggi amǝ'eambi andǝ acili amǝ'ɓala mala tárrí ama, <<Dumǝna púp mǝ kyane mǝ kya banggi Firona murǝm ama amǝ'eambam andǝ amǝ'ɓala mala tárrám kat, mǝnana à do a nzali Kan'ana ka, à yina abanam. ");
INSERT INTO mbu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mǝ nǝ banggi wi ama wun ngga wu nda ka ayálgír, amǝ ɗenyi nǝ agirkusǝu, sǝ wu yina nǝ adomwan mala anzur, andǝ ambulpǝndǝa, andǝ andá ma'wun, andǝ koman mǝnana kat ma'wun na ka. ");
INSERT INTO mbu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ɓǝ̀ Firona murǝm tunǝ wun sǝ ɗì wun ama, mana nda túró ma'wun ngga, ");
INSERT INTO mbu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","wu ne wi ama, <Sǝm nda ka ayálgír. Ɗenyinǝ agirkusǝu nda túró ma'sǝm a do ma'sǝm kat, kǝla mǝnana aká sǝm pàk ka.> Anggo ka nǝ̀ eara wun ɓǝ̀ wu do a bu-nzali Goshen.>> Yisǝfu bang mǝnia ka acemǝnana koya yálgír mala anzur ka gìr'ɓeami na aban amǝ Masar. ");
INSERT INTO mbu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Pǝlǝa Yisǝfu kùtí a ban Murǝm Firona sǝ banggi wi ama, <<Tárrám andǝ amǝ'eambam puro a nzali Kan'ana, à yi sulǝna. À yinǝ anzur, andǝ ambulpǝndǝa, andǝ andá malea, andǝ koya gìr mǝnana malea na ka. Ado ka à nda a bu-nzali Goshen.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Pǝlǝa Yisǝfu twal tongno atà amǝ'eambi, kútí nǝia sǝ lǝmdǝia aban Firona. ");
INSERT INTO mbu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firona ɗì amǝ'eam Yisǝfu ama, <<Mana nda túró ma'wun?>> À eari wi ama, <<Sǝm aguro mò ka, sǝm nda ka amǝ yál agir, kǝla mǝnana aká sǝm pàk ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nyare à banggi Firona murǝm ama, <<Sǝm yiua do bǝti a nzali mǝnia, acemǝnana a nzali Kan'ana ka nzala ɓikina, sǝ ko kǝ girlina ko bondo pa kàm agirkusǝu ma'sǝm nǝ̀ lì ɗàng. Sǝm nggǝ zǝmbô, eara sǝm ɓǝ̀ sǝm do a bu-nzali Goshen.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pǝlǝa Firona banggi Yisǝfu ama, <<Tárró andǝ amǝ'eambo yina a bano. ");
INSERT INTO mbu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Nzali Masar ka nda a ɓadǝmbo. Dumsǝia a ban mǝɓoarne kat-kat mala nzali man. Awu nǝ gandǝ kánǝia ɓǝà do a bu-nzali Goshen. Ɓǝ̀ akǝ aɓwana nakam ateà mǝsǝia kàngkàng ngga, tsǝia ɓǝà kǝ yálàm agirkusǝu mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pǝlǝa Yisǝfu yinǝ tárrí Yakupu aban Murǝm Firona, sǝ Yakupu tsǝkî Firona bù. ");
INSERT INTO mbu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firona ɗì ama, <<Apǝlǝa mô shen a ɓanza?>> ");
INSERT INTO mbu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakupu eari wi ama, <<Do-yilǝmu mem mala gya arǝ abân kǝla bǝri ka, apǝlǝa gbǝman-mwashat nǝ lumi-tàrú na (130). Amǝno yì apǝlǝa ka à nda bǝti sǝ à kwano; à bik lakkì mala apǝlǝa mala akêm aɓa gya-bǝri malea ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pǝlǝa Yakupu tsǝki Firona bu ɗǝm sǝ purî ɓadǝm Firona. ");
INSERT INTO mbu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nda Yisǝfu kumbi tárrí andǝ amǝ'eambi bando. Kasǝia wia bân ɓǝ̀ duk girkuma malea a bu-nzali mǝɓoarne mala nzali Masar, tù aban nggea-là Ramisi, kǝla mǝnana Firona bang ngga. ");
INSERT INTO mbu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Sǝ Yisǝfu pè tárrí, andǝ amǝ'eambi, andǝ acili amǝ'ɓala mala tárrí girlina; koyan ngga pè wi girlina mǝnana kārǝa arǝ làkkì mala amuni ka. ");
INSERT INTO mbu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nzala yi ɓiki kam kpǝm, girlina malâ a koya ban aɓa nzali Masar andǝ ɓá nzali Kan'ana, sǝ aɓwana kútí a tanni kǝ̀rkǝ́r, atàcau mala ɗwanyi girlina. ");
INSERT INTO mbu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Nda Yisǝfu kútí a makkì aɓwana mǝsǝsa mǝnana à soe aɓalǝ abah ka, ɓǝà kúrô. Anggo sǝ ak boalo mana kat aɓa nzali Masar andǝ nzali Kan'ana ka, sǝ tsǝì a ndaboalo mala Firona, Murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Lang boalo yi malnì bù aɓwana a Masar andǝ Kan'ana ka, amǝ Masar pur kat, à yiu aban Yisǝfu sǝ à bang ama, <<Pà sǝm girlina. Ace mana sǝ sǝm nǝ̀ wuki kani a mǝsǝo? Boalo ma'sǝm malǝna kat.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Pǝlǝa Yisǝfu earia wia ma, <<Ɓǝ̀ wu pànǝ boalo raka, wu pàm agirkusǝu ma'wun sǝ mǝ nǝ pà wun girlina a kúnì agirkusǝu.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nda à yinǝ agirkusǝu malea aban Yisǝfu, sǝ Yisǝfu pea wia girlina a kúnì apǝr, andǝ anzur, andǝ ambul, andǝ andá, andǝ amǝdambǝriso malea ka. Aɓa pǝlǝa mǝno ka, pea wia girlina a kúnì agirkusǝu malea. ");
INSERT INTO mbu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lang pǝlǝa mǝno kutina ka, à yiu abani a ɓaria pǝlǝa sǝ à ne wi ama, <<Pà sǝm nǝ̀ sǝmbǝrǝò wi ɗàng, we mǝtala-ɓala ma'sǝm, ama, boalo ma'sǝm malna, sǝ agirkusǝu ma'sǝm ngga amona. Kǝgìr ueo mǝnana sǝm nǝ̀ po ka ɗàng, shekǝ ɓamur rǝ sǝm andǝ aɓaban ma'sǝm. ");
INSERT INTO mbu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kǝa ɗeki sǝm ɓǝ̀ sǝm wukio, sǝ aɓaban ma'sǝm kìɗìkì ɗàng. Pà sǝm girlina mǝnana sǝm nǝ̀ li sǝ sǝm nǝ̀ dum nǝyilǝmu ka, andǝ mǝsǝɓeale mǝnana sǝm nǝ̀ ɓeal ka, ace mǝnana aɓaban ma'sǝm ɓǝà kǝa duk pǝɗanban raka. Kúr sǝm sǝnǝ aɓaban ma'sǝm a kúnì girlina. Sǝm nǝ̀ duk aguro mala Firona Murǝm.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Anggo sǝ Yisǝfu kúr aɓaban mǝnana kat a Masar ka à duk aɓaban mala Firona Murǝm. Amǝ Masar kat makki wi aɓaban malea acemǝnana nzala ɓikipa; sǝ nzali kat yi duk girkuma mala Firona Murǝm. ");
INSERT INTO mbu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yisǝfu yi nyesǝ aɓwana kat à pǝlǝ aguro mala Firona, tite a nzong-nzali aban ká ɓè nzong-nzali mala Masar. ");
INSERT INTO mbu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kǝ anzali mǝnana kúria raka à nda ka nzali mala apǝris. Apǝris mak anzali malea ɗàng acemǝnana girlina malea ka, kǝ pur nǝ ɓala mala Firona Murǝm, sǝ mǝno ka kǝ kārǝia. ");
INSERT INTO mbu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Pǝlǝa Yisǝfu banggi amǝ Masar ama, <<Ado mǝnana ǝn kúrnà wun wunǝ aɓaban ma'wun ace Firona ka, mǝ nǝ pà wun mǝsǝɓeale wu kya ɓeali arǝ aɓabanì. ");
INSERT INTO mbu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ɓǝ̀ pwari pwan gìrɓaban kārǝ́na ka, wun nǝ̀ pè Firona banì mwashat aɓa gauwe tongno mala gìr mǝnana wu kum ngga. Cili ka ma'wun na ace mǝsǝɓeale, sǝ ace girlina mala amuna ma'wun andǝ acili amǝ'ɓala ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","À pà eare ama, <<Ɓwamǝgule, a ámsǝ̀nà ayilǝmi sǝm! Sǝm kumǝna earmúrú a bano, sǝ sǝm earna sǝm nǝ̀ duk aguro mala Firona.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nda Yisǝfu tsǝì dumǝna nzongcau mǝnana à kùrì a nzali Masar, sǝ bà yalung ngga ndakam, ama banì mwashat aɓa gauwe tongno mala gìrɓaban ngga, mala Firona na. Kǝ aɓaban mala apǝris na à pǝlǝ mala Firona raka. ");
INSERT INTO mbu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isǝrayila andǝ amǝ'ɓala male yì dukla a Masar, a bu-nzali Goshen. A ban mǝno ka, yi sau ɗang à kum gǝna, sǝ à ɓǝlki amuna, à hatǝki kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakupu pàk apǝlǝa lum bwamdǝ tongno-nong-ɓari a Masar anzǝm yiu male. Acemani ka, apǝlǝa mala do ɓanza mala Yakupu kat ka gbǝman mwashat nǝ lumi-ine bwamdǝ tongno-nong-ɓari na (147). ");
INSERT INTO mbu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Lang pwari lú mala Isǝrayila gbàshìnà ka, túrban à tunǝ muna-ɓwabura male Yisǝfu, sǝ ne wi ama, <<Ɓǝ̀ bumo pwasǝo arǝàm ngga, ida, tsǝk buo aɓa byalam sǝ wu kángìr ama awu nǝ lǝmdǝàm pěmǝɓoarne sǝ a pà nǝ mém arǝ gir mǝnana mǝ nǝ banggo ado ka ɗàng: Kǝa tsǝk luem a Masar ɗàng. ");
INSERT INTO mbu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ɓǝ̀ ǝn wuna, ǝn umǝna atà akêm ngga, twal luem, pur nǝi aɓa Masar sǝ kya tsǝem a ban mǝnana à tsǝia kàm ngga.>> Pǝlǝa Yisǝfu pà eare ama, <<Mǝ nǝ pǎ kǝla mǝnana a bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakupu ama, <<Kánbàm.>> Nda Yisǝfu kánbì wi ka. Pǝlǝa Yakupu pǝlǝ rǝì amur gyangŋan-nongŋo male sǝ peri. ");
INSERT INTO mbu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","A ɓè pwari, anzǝm mǝnia ka, ɓeɓwa banggi Yisǝfu ama, <<Tárró ka rǝì eari wi ɗàng.>> Nda Yisǝfu wari a sǝn tárrí, atārǝia andǝ amuna-burana male ɓari, Manasa andǝ Ifǝrem. ");
INSERT INTO mbu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Lang Yisǝfu yi bwalǝna ka, ɓeɓwa banggi Yakupu ama, <<Muna-ɓwabura mô Yisǝfu ndya yiua sǝno ka.>> Pǝlǝa Yakupu candǝki amǝsǝi lo, do a kún gyangŋan-nongŋo male. ");
INSERT INTO mbu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakupu banggi Yisǝfu ama, <<Ɓakuli mana Karban nǝ Gulo Kat ka, pusǝrǝi abanam a Luz, a nzali Kan'ana, tsǝkam bù. ");
INSERT INTO mbu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Banggam ama, <Mǝ nǝ tsǝo, awu nǝ ɓǝl amuna pas, sǝ awu nǝ hatǝki. Mǝ nǝ tsǝk tàu mò nǝ̀ gulo nǝ̀ pǝlǝ aɓwapǝndǝa mala anzali. Sǝ mǝ nǝ pè tàu mò mǝnia yi nzali Kan'ana ka, ɓǝ̀ duk malea, girkuma malea mǝnana málá male pà kàm raka.> >> ");
INSERT INTO mbu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Pǝlǝa Yakupu lidǝmba nǝ cau ama, <<Adyan ngga, amuna-burana mô ɓari, Ifǝrem andǝ Manasa, mǝnana a ɓǝlia kani a nzali Masar ka, à dumǝna amunem. Yia ka à dumǝna kǝla Ruben andǝ Shimiyon, amuna-burana mem. ");
INSERT INTO mbu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Sǝama amuna mana à nǝ̀ ɓǝ̀lô wia nǝnzǝ́mò ka, à dumǝna amô; à nǝ̀ kum liɓala mala nzali nǝban amǝ'eambia, kǝla Ifǝrem andǝ Manasa. ");
INSERT INTO mbu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","<<A pwarian, mana mǝ ndarǝ nyari Padan Aram ngga, nggò Rahila yi wú a nkanggariam a nzali Kan'ana. Sǝm nda peatu amur njar, sappi Efǝrat (mǝnana à tunǝi gbal ama Betalami ka) ɗàng. Nǝ bumkiɗikea, sǝ ǝn tsǝk luí a kǝ ban mǝnana wù kàm ngga, a nkanggari njargula ká Efǝrat.>> ");
INSERT INTO mbu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Pǝlǝa Yakupu pǝlǝ mǝsǝi sǝn amuna-burana mala Yisǝfu, sǝ ɗì ama, <<Ayana mǝnia ka?>> ");
INSERT INTO mbu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yisǝfu pè tárrí eare ama, <<Amuna-burana mǝnana Ɓakuli pam kani a Masar ka, à nda.>> Tárrí banggi wi ama, <<Ida, yinǝia abanam tù ace mǝnana ɓǝ̀n tsǝkia wia bù ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakupu ka, ena, kǝ sǝnban pepè ɗàng. Nda Yisǝfu yinǝ amuna a baní tù, sǝ Yakupu mǝn abui, sǝ kùria arǝì bwalia kàngkàng. ");
INSERT INTO mbu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yakupu pǝlǝa aban Yisǝfu sǝ ne wi ama, <<Ən sǝlǝa nǝma mǝ nǝ sǝn ɓamǝsǝo ɗǝm ɗàng, sǝ ado ka, Ɓakuli earǝ́nàm ǝn sǝnǝna nggearǝ amunio!>> ");
INSERT INTO mbu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Pǝlǝa Yisǝfu pusǝ amuna a nre ka ankūnǝ keâ, sǝ ɓunno a ɓadǝmbi nǝ ɓamǝsǝi a nzali. ");
INSERT INTO mbu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pǝlǝa Yisǝfu yinǝ amuna man nǝ mbup-ɓàriá tù aban tárrí Isǝrayila. Bwal muni mǝkyauwe Ifǝrem a buì mǝlì sǝ tsǝì atà bu mǝ'nggare mala Yakupu, sǝ muni mǝgule Manasa ka bwali a buì mǝ'nggare tsǝì atà bu mǝlì mala Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Sǝ Yakupu ka, sárǝ́ abui a nkāɓe rǝarǝia, tsǝk buì mǝlì a ɓamur Ifǝrem, kat andǝ amani ama yì nda muna mǝkyauwe ka, sǝ buì mǝ'nggare ka tsǝì a ɓamur Manasa, kat andǝ amani ama Manasa nda muna-dǝmba ka. ");
INSERT INTO mbu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Pǝlǝa tsǝkî Yisǝfu bù nǝ na ama, <<Ɓǝ̀ Ɓakuli mǝnana kâ Ibǝrayim andǝ tárrám Ishaku kpata njar male ka, tsǝkî amuna man bù. Ɓǝ̀ Ɓakuli mǝnana yálǎm aɓa do mem kat, bà yalung ngga, tsǝkia wia bù. ");
INSERT INTO mbu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ɓǝ̀ mǝturonjar mǝnana akmúrám amsǝam a ɓabù ɓealɓikea kat ka, tsǝki amuna mǝnia ka bù. Ɓǝ̀ do ama yìa ka à nǝ̀ kánǝ lullǝàm, andǝ lullǝ kèm Ibǝrayim, andǝ lullǝ tárrám Ishaku a dǝmba. Ɓǝ̀ Ɓakuli pea wia amuna andǝ amǝkau ɓǝà hatǝki ɓǝà pǝlǝ aɓwabundǝa a ɓanza.>> ");
INSERT INTO mbu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yisǝfu ka, earce gìr mǝno tárrí pè ka ɗàng, mǝnana tsǝk buì mǝlì amur muni mǝkyauwe ka. Nda ɓariki nǝ̀ loasǝ bù-mǝlì mala tárrí amur Ifǝrem nǝ̀ kánǝí amur Manasa. ");
INSERT INTO mbu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Banggi tárrí ama, <<Dàdá, kǝa pè anggo ɗàng. Mǝnia ka, nda muna-dǝmba. Tsǝk buo mǝlì amurí.>> ");
INSERT INTO mbu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tárrí ɓinǝe, pǝlǝi wi ama, <<Ən sǝlǝna, munem, ǝn súrǝ̀ gir mǝnana ǝn pakki ka. Mǝsǝcau na, Manasa ka, nǝ̀ nggá duk ɓwabundǝa mala nzali mǝgule. Sǝ ko ɓǝ̀ lang le ka, mǝkyauwe Ifǝrem ngga, nǝ̀ kútì nǝ gulo. Acemǝnana amǝkè nǝ̀ nggá duk ɓwabundǝa mala anzali.>> ");
INSERT INTO mbu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nda Yakupu tsǝki amuna-burana mǝno bù a pwari mǝno, kǝ na ama, <<Amǝ Isǝrayila nǝ̀ paktúró nǝ alullǝ wun, ɓǝ̀ à nǝ̀ tsǝki aɓwana bù ka. À nǝ̀ bang ama, <Ɓǝ̀ Ɓakuli tsǝk wun wu dum nǝ kume mala lidǝmba, kǝla mala Ifǝrem andǝ Manasa.> >> Anggo sǝ Yakupu tsǝk Ifǝrem amur Manasa. ");
INSERT INTO mbu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Pǝlǝa Isǝrayila yì Yakupu ne Yisǝfu ama, <<Sǝni, málá mǝ nǝ wǔ, sǝ Ɓakuli ka nda atà wun. Yì ka nǝ̀ nyesǝ wun a nzali mala aká wun, yì nzali Kan'ana. ");
INSERT INTO mbu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sǝ we mǝnana a nda amur amǝ'eambo ka, mǝ nda ban po nzali mǝɓoarne mala pal nkono mǝnana a Shekem ngga. Nzali mǝno ka ǝn é nǝ â arǝ amǝ'Amor a lwa nǝ nggeabyau mem andǝ nta mem.>> ");
INSERT INTO mbu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakupu pǝlǝa tunǝ amuna-burana male sǝ bang ama, <<Wu yiu wu yi ramba abanam mǝ bangga wun gìr mǝnana nǝ̀ yia kum wun arǝ anza mǝnana à nǝ̀ yiu ka. ");
INSERT INTO mbu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","<<Wu yi ramba wu ǒ, wun amuna-burana mala Yakupu; wu kwakikir wun arǝ tár wun Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","<<We Ruben, a nda muna-dǝmba mem, ǝn ɓǝ́ló aɓa rǝcandǝa mala lo-ɓwa mem; arǝò sǝ tita ɓwabura-ɓwa mem lǝmdǝa. Aɓa gulo ka a nda mǝdǝmba mala amunem, a kútiǎ kat nǝ rǝcandǝa. ");
INSERT INTO mbu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Sǝ acemǝnana a ɗwanyi bwal ɓamuro, a songnǝo kǝla nggeamùr ka, a pà nǝ duk mǝdǝmba ɗǝm ɗàng. Acemǝnana a kutio a ndà-nongŋo mala tárró, a nongnǝ māmí. We, a eauwe a gyangŋan-nongŋo mem a pǝndǝki! ");
INSERT INTO mbu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","<<Shimiyon andǝ Lawi ka, njar malea mwashat aɓa ɓealɓikea. Anggea-byau malea ka, agirbura mala lúllô na. ");
INSERT INTO mbu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yilǝmem, kǝa kúti aɓa kùrkún ɓa-sǝmbǝrǝa malea ɗàng, bangŋo mem, kǝa oasǝ ɓamuro aɓa dapi malea ɗàng, acemǝnana à wal-lú aɓa bumlulla malea. À gbakǝri ajamnda ace pakkiɗire. ");
INSERT INTO mbu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bumlulla malea ka mala ɓìkìbura na; ɓǝ̀ súban sulǝo amurí. Bumkpǝmna malea ka mala pàkkiagir ɗwanyi sǝn mǝsǝswatǝr na. Mǝ nǝ mesǝkia aɓa nzali Isǝrayila. Mǝ nǝ mesǝkia aɓalǝ aɓwana mala Yakupu. ");
INSERT INTO mbu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","<<Yahuda, amǝ'eambo nǝ̀ ɓwangsǝo; buo nǝ̀ kpa myal aɓio amǝbura; amuna-burana mala tárró nǝ̀ ɓun a nzali a ɓadǝmbo. ");
INSERT INTO mbu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Munem Yahuda, a ndà muna-im, mǝnana nǝ̀ ɓangŋatà nyama nǝ̀ wali sǝ nǝ̀ nyare a mpù male ka. Kǝla im awu nǝ sarǝa a nǝ nongŋo, kǝla nggeàɓwaná im, yana ɓwe nǝ̀ kum ɓabumcandǝa nǝ̀ zorǝǒ? ");
INSERT INTO mbu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Gara-murǝm pà nǝ̀ purî bù Yahuda ɗàng, yálmúr aɓwana ka nǝ̀ pà a tàu male bà yiu mala ɓwa mǝnana garè ka male na ka, sǝ aɓwapǝndǝa ka à nǝ̀ ɓun a ɓadǝmbi, à nǝ̀ oki wi. ");
INSERT INTO mbu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nǝ̀ kùr mǝdambǝriso male arǝ nggun-anap, muna-mǝdambǝriso male ka nǝ̀ kùrì arǝ bu nggun-anap mǝɓoarne mala aɓî; nǝ̀ lákkí adaura male aɓa mùr-ɓǝlanggun anap, adaura-múrɓì male ka nǝ̀ lákkia nǝ mùr-ɓǝlanggun anap mǝbangŋe. ");
INSERT INTO mbu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amǝsǝì nǝ̀ bang bìng-bìng ace nu mùr-ɓǝlanggun anap, aminǝi nǝ pwasǝ pwat-pwat ace nu kiura. ");
INSERT INTO mbu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","<<Zebulu ka nǝ̀ do a kún nggeamùr sǝ ban male nǝ̀ duk ban kpasha mala awaru-mur; nzong-nzali male nǝ̀ bik nggea-là Sidon. ");
INSERT INTO mbu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","<<Isaka ka dambǝritso mǝ'ɓiki twal twalo na. Nǝ̀ nongŋo a nzali ace ak twalo mǝdǝmbǝre a nzǝmi. ");
INSERT INTO mbu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ɓǝ̀ sǝn ɓoaro mala ban usǝlǝo male, sǝ ɓǝ̀ nzali-do male pwasǝbumi ka, nǝ̀ eare nǝ̀ twalki atwalo mǝdǝmbǝre a kwàrì. Nǝ̀ eare nǝ̀ pak túró guro. ");
INSERT INTO mbu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","<<Dan ngga nǝ̀ duk mǝ'ɓashi mǝ'mǝsǝcaunì amur aɓwana male kǝla mana acili atau mala Isǝrayila nǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan nǝ̀ do kǝla n'yau a nkanggari njargula, kǝla n'yau-barya aban nongŋo a gírí njarkusǝu. Nǝ̀ kwar pǝr mana kǝ kútí ka a kusǝì sǝ mǝkwak pǝr nǝ̀ puro nǝ̀ kpa nǝ nzǝmi. ");
INSERT INTO mbu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","<<We Mǝtalabangŋo, ǝn nggǝ soa mǝsǝam arǝò ace kum amsǝban mò. ");
INSERT INTO mbu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","<<Amǝ'iuban nǝ agirbura a buià à nǝ̀ eau amúr Gad hǝrkit nǝ kiɗikiban, sǝ yì ka nǝ̀ pǝlǝ arǝia nǝ munǝo nǝ̀ pǝrtea. ");
INSERT INTO mbu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","<<Asha ka nǝ̀ lìli, lǐ mala agirlina mǝɓoarne, sǝ nǝ̀ pusǝ girlina mǝnana ndanǝ ɓoaro ace amurǝma ka. ");
INSERT INTO mbu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","<<Naftali ka nda kǝla mbamba mǝnana nda atarǝì ka; nǝ̀ ɓangŋa aban ká a ban mǝnana bumi earce ka. Nǝ̀ ɓǝlki amuna amǝɓoarsǝne. ");
INSERT INTO mbu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","<<Yisǝfu ka nggun anap mǝ'pa ɓǝle na, mǝnana à pandǝi a kún mgbeɗe mùr ka; abui to à eauwe amur sheran. ");
INSERT INTO mbu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Amǝ ɓinǝmǝsǝì soa munǝo arǝì nǝ lúllô mǝkǝ̀rkǝ́rnì. À pǝrte nǝ anta andǝ amundi malea. ");
INSERT INTO mbu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Sǝama nta male ue ɓandang, anggwarbui cam kàngkàng, atàcau mala bu Mǝ'rǝcandǝa mala Yakupu, atàcau mala Yálgír, Tali mala Isǝrayila, ");
INSERT INTO mbu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","atàcau mala Ɓakuli mala tárró, yì Ɓakuli mǝnana bwalkiyio kàm ngga. Ɓakuli mǝnana Kàrban Kat nǝ Gulo ka nǝ̀ tsǝko bù mala nya mbulo nǝ kuli; nǝ̀ tsǝko bù nǝ pô mùr a tà-nzali; nǝ̀ tsǝko bù mǝnana we wunǝ agirkusǝu mô ka wun nǝ̀ ɓǝl nyangsang. ");
INSERT INTO mbu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Atsǝkbu mǝnana ǝn earce Ɓakuli ɓǝ̀ pò ka amǝgulke na. À gulo à kútì atsǝkbu mala tárrám andǝ mala kèm; à kútì atsǝkbu mala ankono share ɓanza; à kútì agǝna mala amgbang-ban mana à nda tàtǝ́k ka. Yia kat ɓǝà sulǝo amuro, we Yisǝfu, acemǝnana a nda murǝm aɓalǝ amǝ'eambo. ");
INSERT INTO mbu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","<<Benjami ka nvwa-bondo mǝ'ɓiki pak-nzal nyam-pǝra na; nǝ dǝmbari ka nǝ̀ wal nyam-pǝra male, nǝ pwarikpǝra ka nǝ̀ sàngi nyami.>> ");
INSERT INTO mbu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Amǝnia kat ka à nda ka tàu lum-nong-ɓari mala amǝ Isǝrayila, sǝ amǝnia yì acau ka à nda ka cau mǝnana tárrià banggia wia mana ndarǝ tsǝkia wia bù, kǝ pè koyan ateà ka tsǝkbu mǝnana kārǝa arǝì ka. ");
INSERT INTO mbu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Pǝlǝa Yakupu pè amuni amǝnia yì akwarkiru ka ama: <<Mǝ ndo mǝ nǝ wǔ mǝ nǝ o atà akêm mǝnana à akàm dǝmba à wuna ka. Wu tsǝk luem a ban mǝnana à tsǝk aɓea akêm kàm, a gumi-ɓa'tali a ɓaban mǝnana ɗiɗyal ka mala Efǝron ɓwa Hitti na ka. ");
INSERT INTO mbu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Mǝno yì gumi-ɓa'tali a ɓaban a Makpela, tù nǝban là Mamǝre, a nzali Kan'ana ka, Ibǝrayim kúrí atārǝia andǝ ɓabanì a bu Efǝron ɓwa Hitti, ɓǝ̀ do nda ban tsǝk alú male. ");
INSERT INTO mbu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","A banì sǝ à tsǝk lú Ibǝrayim andǝ lú māmí Saratu; a banì sǝ à tsǝk lú Ishaku andǝ lú māmí Rabeka, sǝ a banì sǝ ǝn tsǝk lú Liya. ");
INSERT INTO mbu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ɓabanì andǝ gumi-ɓa'tali mana aɓalǝi ka à kúrí a bu amǝ'Hitti.>> ");
INSERT INTO mbu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lang Yakupu malna pa amǝnia yì akwarkiru aban amuni amuna-burana ka, nyare sarǝa akusǝi amur gyangŋan-nongŋo, lin'ueo male kasǝa, à kpapì atà akê. ");
INSERT INTO mbu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yisǝfu lo kùmsǝ amur tárrí, kùrrì zǝp nǝ abui sǝ kǝ ɓua aceì. ");
INSERT INTO mbu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Pǝlǝa banggi amǝtúró male, yì amǝ'ɓuri ama ɓǝà gilǝki lú tárrí Yakupu ace tsǝie. Anggo gbal sǝ à pa. ");
INSERT INTO mbu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Túrè twalia anongŋo lumi-ine, acemǝnana mǝno ka nda làkkì mala anonggio mala mal túró gilǝki lú sǝ à nǝ̀ tsǝì. Amǝ Masar ɓua lú Yakupu anongŋo lumi-tongno-nong-ɓari (70). ");
INSERT INTO mbu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lang anonggio mala ɓua-lú kutina ka, Yisǝfu banggi amǝ'tamurǝm Firona ama, <<Ɓǝ̀ bum wun pwasǝ arǝàm ngga, ida wu kyan nǝ mǝnia yì càu ka a kunièm aban Firona Murǝm. Wu banggi wi ama, ");
INSERT INTO mbu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","<Mǝnana Tárrám malanǝ̀ wu ka, tsǝem ɓǝ̀n kángìr ama mǝ nǝ tsǝk luí a ɓembe mǝnana tǝmbî ɓamúrì a nzali Kan'ana ka. Acemani ka, ǝn nggǝ zǝmbô pé, ɗekiam ɓǝ̀n kyane mǝ tsǝk lú tárrám a Kan'ana, sǝ mǝ nyare.> >> ");
INSERT INTO mbu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firona Murǝm nyesǝi wi càu ama, <<Kyane kya tsǝk lú tárró kǝla mǝnana tsǝo a kánbì wi ama awu nǝ pàk ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Nda Yisǝfu lo oa tsǝk-lú tárrí ka. Aɓwana-mǝgule kat mala Firona Murǝm, andǝ amǝ'pè murǝm kwarkiru, andǝ aɓwana-mǝgule kat mala nzali Masar o atè. ");
INSERT INTO mbu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Amǝɓala mala Yisǝfu, andǝ amǝ'eambi, andǝ acili amǝɓala mala tárrí yia kat à o atè. Kǝ amuna-mǝkèke malea, andǝ adomwan mala anzur, andǝ ambul andǝ andá malea na à ɗekia a bu-nzali Goshen ngga. ");
INSERT INTO mbu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aɓwana aɓalǝ awaru-pǝr sǝ a nzǝm apǝr gbal ka à o atè. Nggea ramba mala ɓwabundǝa na kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lang à yi bingŋǝna katǝra mala Atat, a nkaring Nggeasala Jodan ngga, à lo keban andǝ ɓua lú Yakupu kàm kǝ̀rkǝ́r. Akanó ka, Yisǝfu twal anonggio tongno-nong-ɓari aban dokúnɓembe andǝ ɓua-lú tárrí. ");
INSERT INTO mbu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Lang amǝ'Kan'ana mǝnana à do a nzali mǝno sǝnia aban ɓua andǝ keban a katǝra mala Atat ka, à bang ama, <<Mǝnia ka ɓua-lú mǝkǝ̀rkǝ́rnì mala amǝ Masar na.>> Nda gìr mǝnana tsǝa sǝ à tunǝ banì ama Abel-Mizǝrem ngga; nda kano a nkaring Mùr Jodan. ");
INSERT INTO mbu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Anggo sǝ amuna-burana mala Yakupu pa kǝla mǝnana banggia wia ka. ");
INSERT INTO mbu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","À twal lú tárrià à umnǝi a nzali Kan'ana. À kya tsǝi a gumi-ɓa'tali a ɓaban a Makpela, tù nǝban là Mamǝre. Mǝno yì ɓaban ngga nda mana Ibǝrayim kúrí a bu Efǝron ɓwa Hitti, ɓǝ̀ do nda ban tsǝk alú male ka. ");
INSERT INTO mbu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Anzǝm mana Yisǝfu tsǝ̀ngŋǝ̀nà lú tárrí ka, nyare a Masar, atārǝia andǝ amǝ'eambi andǝ acili aɓwana mǝnana kat à o atè ace tsǝkban mala tárrí ka. ");
INSERT INTO mbu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lang amǝ'eam Yisǝfu sǝni tárrià wuna ka, à bang ama, <<Yakǝla Yisǝfu ndanǝ bumlulla mala agir mǝɓike mǝnana kat sǝm pakki wi ka più a bumi, nǝ̀ yia mbwe sǝm nǝ mǝɓike gbal.>> ");
INSERT INTO mbu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nda à túrban ɓǝà banggi Yisǝfu mǝnia yi càu ka ama, <<Kaniama tárró nǝ̀ wù ka, bangga sǝm càu mǝnia ka, ama: ");
INSERT INTO mbu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","<Wu banggi Yisǝfu ida ɓǝ̀ twali amǝ'eambi ban acauɓikea andǝ agir mǝɓane mǝnana à pea, mala tanni mǝnana à pe wi ɗiɗyal a njar mana ɓoar raka.> Nda sǝm nggǝ zǝmbo, twali aguro mala Ɓakuli mala tárró banì.>> Lang cau mǝnia yina a baní ka, Yisǝfu ɓua sukki mǝrǝm. ");
INSERT INTO mbu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Amǝ'eambi gbal ka à yiu à yi kpa a nzali a ɓadǝmbi; à bang ama, <<Sǝm ndya ka; sǝm nda ka aguro mò.>> ");
INSERT INTO mbu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sǝ Yisǝfu ka nea wia ama, <<Ɓangciu ɓǝ̀ kǝa pakka wun ɗàng. Mǝ nda Ɓakuli le? ");
INSERT INTO mbu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mala wun ngga, wu sham a ɓabum wun ama wun nǝ̀ pàkkam gìr mana nǝ̀ kwanrǝàm ngga, sǝ Ɓakuli ka kànì ama gìr mǝɓoarne na nǝ̀ pur aɓalǝi ka, ace mǝnana ɓǝà amsǝ ayilǝmi aɓwana pas, kǝla mǝno yalung sǝm nggǝ sǝni kǝ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Acemani ka, ɓangciu ɓǝ̀ kǝa pakka wun ɗàng. Mǝ nǝ ɗenyinǝ wun andǝ amuna ma'wun.>> Pǝlǝa ɓak ɓabumia sǝ nea wia acau mǝɓoarne. ");
INSERT INTO mbu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yisǝfu do a Masar andǝ ɓala mala tárrí kat. Dǒ lùmsǝ apǝlǝa lumi-lum nǝ mǝsǝì lum (110). ");
INSERT INTO mbu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Mǝnana Yisǝfu ka nda andǝamǝsǝì ka, sǝn amuna andǝ amǝkà Ifǝrem. Ɗǝm ngga à ɓǝl amuna mala Makir, muna mala Manasa a mǝsǝì; amuna mǝnia ka Yisǝfu ea amuni na. ");
INSERT INTO mbu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yisǝfu pǝlǝa nea amǝ'eambi ama, <<Málá mǝ nǝ wǔ, sǝ ɓafo ka Ɓakuli nǝ̀ yia bwala wun nggàm. Nǝ̀ pusǝ wun a nzali man, nǝ̀ nyesǝ wun a nzali mǝnana kánbì Ibǝrayim, sǝ Ishaku, sǝ Yakupu, ama nǝ̀ pea wia ka.>> ");
INSERT INTO mbu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pǝlǝa Yisǝfu tsǝk amuna mala Isǝrayila à kánbì wi ama, <<Mbak-kàngkàng Ɓakuli ka nǝ̀ yiu aban wun, sǝ wun nǝ̀ pwan amuem akani.>> ");
INSERT INTO mbu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nda Yisǝfu yi wú mana apǝlǝa male bingŋǝna gbǝman-mwashat nǝ lum (110) ngga. Lang à gilǝkina luí ka, à nongsǝi aɓa kpamgbang tsǝk-lú a Masar.");
INSERT INTO mbu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Amǝnia ka à nda ka amuna-burana mala Isǝrayila mǝnana à kùtí a Masar andǝa tárrià Yakupu ka; koyana ateà ka andǝ amǝ'ɓala male: ");
INSERT INTO mbu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, andǝ Shimiyon, andǝ Lawi, andǝ Yahuda, ");
INSERT INTO mbu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","andǝ Isaka, andǝ Zebulu, andǝ Benjami, ");
INSERT INTO mbu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","andǝ Dan, andǝ Naftali, andǝ Gad, sǝ Asha. ");
INSERT INTO mbu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Amuna andǝ amǝ'kau mala Yakupu kat ka, à nda lumi-tongno-nong-ɓari (70). Yisǝfu ka ak dǝmba nda a Masar. ");
INSERT INTO mbu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yisǝfu yi wú, sǝ amǝ'eambi gbal kat à yi wukio; anggo sǝ yia kat a nza malea ka teà yi twalo. ");
INSERT INTO mbu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Sǝama amunia andǝ amǝkea, yia amǝ Isǝrayila ka, à yi ɓǝlki amuna andǝ amǝkau pas; à sa à làkkì nyangsang, à būndǝ kǝ̀rkǝ́r, à lùmsǝ ɓá nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Anzǝm apǝlǝa pas ka, ɓè bǝsa murǝm mǝnana súrǝ̀ kǝgìr amúr Yisǝfu raka, eau a buno-murǝm mala Masar. ");
INSERT INTO mbu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Banggi aɓwana male ama, <<Wu sǝni, amǝ Isǝrayila adyan ngga à làkkìna kǝ̀rkǝ́r, sǝ à dumǝna gìr ǝn'o aban sǝm! ");
INSERT INTO mbu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wu yiu, sǝm nǝ̀ alta kutan mala tamsǝ lidǝmba mala làkkì malea. Ɓǝ̀ ana raka, ɓǝ̀ lwa lo ka, yangǝla à nǝ̀ kpapibu andǝ aɓisǝm amǝbura, à nǝ̀ o a munǝo arǝ sǝm, sǝ à nǝ̀ nying nzali ma'sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nda amǝ Masar tsǝk amǝ-pǝ̀rta aguro amúrià, ɓǝà ɓungi bangŋo malea nǝ paria wia akanggǝrang atúró mǝkwane amúrià ka. À tsǝia púp à ɓakkia anggea-là Pitom andǝ Ramisi, anggea-là ramgìr mala Firona, Murǝm. ");
INSERT INTO mbu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Sǝ kat andǝ pàtanni mǝnana amǝ Masar kǝ par amǝ Isǝrayila nǝi ka, kara amǝ Isǝrayila kǝ lidǝmba nǝ li aban làkkì andǝ mesǝe aɓa nzali. Nda ɓangciu yi pakki amǝ Masar arǝia, ");
INSERT INTO mbu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","sǝ à tsǝk amǝ Isǝrayila púp aɓa túró-guro mǝɓike, sǝn mǝsǝswatǝr pà kàm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Amǝ Masar tsǝk amǝ Isǝrayila do ɓikia wia nǝ tsǝia púp ɓǝà kǝ ɓakkî amǝ Masar atobali andǝ pak koya túró-ɓaban. Amǝ Masar parì amǝ Isǝrayila atúró mǝcandǝe mǝnia ka kat amúrià, sǝ à tsǝia púp ɓǝà peǎ, sǝn mǝsǝswatǝ̀r pà kàm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Pǝlǝa murǝm mala Masar bang cau nǝ Shifǝra andǝ Puwa, yì amǝ'bwal-gbáshí mala amǝ Ibǝru ama, ");
INSERT INTO mbu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","<<Lang wu ndarǝ bwalì amālá amǝ Ibǝru gbáshí, sǝ wu sǝni muna-ɓwabura na à ɓǝl ka, wu wal-luí, sǝ ɓǝ̀ muna-ɓwama na ka, wu ɗeki ɓǝ̀ àwá.>> ");
INSERT INTO mbu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Sǝama amǝ'bwal-gbáshí man ngga amǝ ɓanggi Ɓakuli na, acemani ka à eare à pàk gìr mǝnana Murǝm Masar banggia wia ka ɗàng; à ɗeki amuna-burana à àwá. ");
INSERT INTO mbu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Murǝm Masar pǝlǝa túrban ɓǝà tunǝ amǝ'bwal-gbáshí man sǝ ɗia ama, <<Mana tsǝa sǝ wu pàk gìr man? Palang sǝ wu kǝ nying abangna amuna-burana nǝyilǝmu?>> ");
INSERT INTO mbu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Amǝ'bwal-gbáshí eari wi ama, <<Amālá amǝ Ibǝru ka à pà kǝla amālá amǝ Masar ɗàng; amālá amǝ Ibǝru ka à nda dwat nǝ mǝsǝkàngkàngŋa; kaniama mǝ'bwal-gbáshí nǝ̀ ká a bania ka, à angŋa dǝmba à gbashina.>> ");
INSERT INTO mbu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Anggo sǝ Ɓakuli lǝmdǝ earmúrú male aban amǝ'bwal-gbáshí, sǝ amǝ Ibǝru lidǝmba nǝ hatǝki andǝ gulo nǝ rǝcandǝa kàm kpǝm. ");
INSERT INTO mbu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Sǝ acemǝnana amǝ'bwal-gbáshí ɓanggi Ɓakuli ka, pea wia malea yià amuna. ");
INSERT INTO mbu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pǝlǝa Firona Murǝm, tsǝki aɓwana male kat amǝ Masar nzongcau ama: <<Koya muna-ɓwabura mǝnana kat ɓwa Ibǝru loa ɓǝle ka, ɓǝà túrí aɓa Nggeasala Nayel. Sǝ amuna-mamǝna kat ka, ɓǝà ɗekia nǝyilǝmu.>> ");
INSERT INTO mbu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A bàkú mǝno ka, ɓè ɓwabura a tàu mala Lawi al ɓwama a tàu male. ");
INSERT INTO mbu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ɓwama mǝnia kum muna a bumi, sǝ ɓǝl muna-ɓwabura. Sǝni ka mune ɓoarɓwa kǝ̀rkǝ́r, sǝ pǝlǝa sǝmbǝrǝi zongŋo tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Lang yi sǝni pà nǝ̀ gandǝ lidǝmba nǝ sǝmbǝrǝè raka, pǝlǝa twal mǝgó mǝnana à tè nǝ bondo papiros ka, lanzǝ ɓālǝi nǝ myang andǝ muku kùrrí. Pǝlǝa nongsǝ muna aɓalǝi sǝ tsǝì aɓalǝ anzuno a kún múr mala Nggeasala Nayel. ");
INSERT INTO mbu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mǝ'nggaula mune pǝlǝa cam zak aban yálè nǝ̀ sǝn koman nǝ̀ kum muna. ");
INSERT INTO mbu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Zuku ka, ɓoarnsarile Firona Murǝm yiu a sussǝo a kún nggeasala, sǝ amǝ'tè amuna-nsarina mana a tè ka à kùtí aban gya a kún nggeasala. Mǝsǝì kpa arǝ mǝgó mǝno aɓalǝ anzuno ka, sǝ ne mǝtè muna-ɓwama ama ɓǝ̀ kya twali wi. ");
INSERT INTO mbu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Lang muna Murǝm loasǝ kún mǝgó ka, kara sǝn bangna muna-ɓwabura. Nda aban ɓua, kara mǝsǝswatǝr male bwali, sǝ na ama, <<Muna man ngga mwashat aɓalǝ amuna mala amǝ Ibǝru na.>> ");
INSERT INTO mbu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Sǝ mǝ'nggaula muna sung tù aban ɓoarnsarile murǝm, osso ɗì ama, <<Ɓǝ̀ ǝn kya yinǝ mwashat atà amamǝna mala amǝ Ibǝru ace mǝnana ɓǝ̀ iulǝô munê ka le?>> ");
INSERT INTO mbu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ɓoarnsarile murǝm eari wi ama, <<E, kyane kya yinǝam nǝi.>> Pǝlǝa mǝ'nggaula muna tù a mire kya tunǝ nggea mune. ");
INSERT INTO mbu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ɓoarnsarile murǝm ne nggea muna ama, <<Twal muna mǝnia ka umnǝi a ɓala, kya iulǝami, mǝ nǝ nggá mbweo tangnakusǝo.>> Pǝlǝa twal mune umnǝi kya iulǝì. ");
INSERT INTO mbu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nǝnzǝ́mò, lang mune yi gulna ka, nyesǝi wari nǝi kya pê ɓoarnsarile murǝm, sǝ pǝlǝ muni. Tsǝki wi lullǝu ama Musa, nda ban bang ama, <<Acemǝnana ǝn twali amúr mùr>> ka. ");
INSERT INTO mbu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mǝnana Musa gulna karǝna-ɓwa ka, puro wario nǝ̀ nggá sǝn aɓwana male amǝ Ibǝru, sǝ kya sǝn nggea tanni mǝnana à nda aɓalǝi ka. Sǝn ɓwa Masar aban walki mwashat atà amǝ'eambi, ɓwa Ibǝru. ");
INSERT INTO mbu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Lang Musa pelǝkiban sǝ sǝni kǝɓwa pà kàm aban sǝne raka, kara wal-lú ɓwa Masar sǝ sǝmbǝrǝi a sala. ");
INSERT INTO mbu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ban nǝ fa ka, Musa purna ɗǝm nǝ̀ ká aban aɓwana male. Kya kum amǝ Ibǝru ɓari aban munǝo. Sǝ ɗì ɓwa mǝnana tita altacau ka ama, <<Palang sǝ a kǝ walki mǝ'eambo?>> ");
INSERT INTO mbu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ɓwa mǝno pǝlǝa nyesǝi wi cau ama, <<Yana tsǝo murǝm andǝ mǝ'ɓashi amur sǝm? A ndarǝ earce awu nǝ wal-luem kǝla mǝnana a wal-lú ɓwa Masar yilung ngga le?>> Kara ɓangciu bwal Musa, nda kútí a ɗenyicau ama, <<Gìr mǝno ǝn pê ka aɓwana sǝlǝnace.>> ");
INSERT INTO mbu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Lang Firona Murǝm okce ka, alta Musa nǝ̀ wal-luí. Sǝ Musa ka ɓangŋa apî Firona, o kya do a nzali Midiyan, a nkanggari ɓe tūli-mùr. ");
INSERT INTO mbu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ɓè pǝris mala amǝ Midiyan, ndanǝ amuni amuna-mamǝna tongno-nong-ɓari. Amuna-mamǝna mǝnia yiu, à tò mùr a tūli, à lùmsǝki ankenye-mùr, à nǝ̀ pè anzur mala domwan mala tárrià. ");
INSERT INTO mbu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Aɓea ayálgír aburana yiu, à pǝ̀r amuna-mamǝna mǝnia ama ɓǝà o. Sǝ Musa ka lo camata amuna-mamǝna mǝnia ka, bwalia wia kàm à pè domwan mala anzur malea mùr. ");
INSERT INTO mbu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lang amuna-mamǝna man nyarna a ɓala aban tárrià Rewel ka, ɗia ama, <<Lang sǝ wu nyar tù yalung a ɓala?>> ");
INSERT INTO mbu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","À eari wi ama, <<Ɓè ɓwabura Masar na amsǝ sǝm a bu ayálgír aburana ka, sǝ yàle toka sǝm mùr a tūli sǝ pè agirkusǝu ma'sǝm à nǔ.>> ");
INSERT INTO mbu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tárrià ɗia ama, <<Sǝ ɓwabure ka, nda ke? Palang sǝ wu o wu ɗeki? Wu kyane wu kya tunǝi ɓǝ̀ yiu ɓǝ̀ yi lìli atà sǝm!>> ");
INSERT INTO mbu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa eare duk kano atà Rewel, pǝlǝa Rewel twal ɓè muni muna-ɓwama, Zipora sǝ pè Musa ɓǝ̀ duk māmí. ");
INSERT INTO mbu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora ɓǝlî Musa muna-ɓwabura. Musa bang ama, <<Mǝ nda ɓwa-kúnɗàngna a nzali mǝɗàngne, acemani ka mǝ nǝ tsǝki wi lùllǝú ama Gashom.>> ");
INSERT INTO mbu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Anzǝm apǝlǝa pas ka murǝm Masar paklú. Sǝ amǝ Isǝrayila ka à kǝ imge ace tanni aɓata túró guro mǝnana à nda aɓalǝi ka. À ɓua kǝ̀rkǝ́r, sǝ ɓua malea eauwe aban Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Pǝlǝa Ɓakuli ok imge malea sǝ ɓālǝi kasǝa arǝ kùrcau male mǝnana pangnǝ Ibǝrayim, nǝ Ishaku, sǝ nǝ Yakupu ka. ");
INSERT INTO mbu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Pǝlǝa Ɓakuli sǝn amǝ Isǝrayila, sǝ yi sǝlǝa ama pwari kārǝ́na ace amsǝia. ");
INSERT INTO mbu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","A ɓè pwari ka, Musa na arǝ yál domwan mala ambul andǝ anzur mala nkili Jetǝro, ɓwamǝgule pǝris mala amǝ Midiyan, sǝ Musa umnǝia kuko a ɓabondo yi pur a ban mǝnana à tunǝki ama Horep, nkono mala Ɓakuli ka. ");
INSERT INTO mbu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Akano ka, kara sǝn mǝturonjar mala Yahweh pusǝrǝi kǝla bǝsa mǝ'earke aɓa mǝ'nkwarki. Kǝ sǝn earke mala lasǝ bǝsa amur nkwarki, sǝ ko nkwarki pì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Pǝlǝa Musa bang ama, <<Mǝ nǝ ká mǝ nggá sǝn mǝnia yì gìr'ndali, mǝnana bǝsa kǝ earke sǝ nkwarki pi raka.>> ");
INSERT INTO mbu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Lang Yahweh sǝna Musa pǝlǝna rǝì ace sǝnban pepè ka, pǝlǝa tunǝ Musa nǝ ɓá mǝ'nkwarki ama, <<Musa! Musa!>> Sǝ Musa pa eare ama, <<Mǝ ndya ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Pǝlǝa ne Musa ama, <<Kǝa sung kani ɗang! Swár ankura mǝnana a kusǝo ka, acemǝnana ban mana a cam kam ngga, nzali mǝfele na.>> ");
INSERT INTO mbu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ɗǝm ngga banggi wi ama, <<Mǝ nda Ɓakuli mala keò, Ɓakuli mala Ibǝrayim, Ɓakuli mala Ishaku, sǝ Ɓakuli mala Yakupu.>> Lang Musa ok cau man ngga, kùmsǝ ɓamǝsǝi, acemǝnana ɓangciu pakki wi arǝ sǝn Ɓakuli a ɓamǝsǝì. ");
INSERT INTO mbu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Sǝ Mǝtalabangŋo banggi wi ama, <<Mǝsǝcau ǝn sǝnǝna tanni mǝkǝ̀rkǝ́rnì mala aɓwana mem mǝnana aɓa Masar ka, sǝ ǝn ongŋǝna ɓua malea atàcau mala amǝ pea wia tanni aɓata túró guro. Ən sǝlǝnace nutanni malea. ");
INSERT INTO mbu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Acemani ka, ǝn sulǝo ace amsǝia a ɓabù amǝ Masar, mǝ nǝ pusǝia ɓǝà purî ɓá nzali mǝno, sǝ mǝ nǝ kánǝia a nzali mǝɓoarne, andǝ nzali mǝgule, nzali mǝnana kiura andǝ mur'nyi kǝ ɓang kàm ngga; nzali mǝnana amǝ'Kan'ana, andǝ amǝ'Hitti, andǝ amǝ'Amor, andǝ amǝ'Periz, andǝ amǝ'Hivi, andǝ amǝ'Jebus duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Adyan ngga, ɓua mala amǝ Isǝrayila bwalǝna banam, sǝ ǝn sǝnǝna twalo mǝdǝmbǝre mǝnana amǝ Masar paria wia amúrià ka. ");
INSERT INTO mbu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Yiu, mǝ nǝ túrô aban Firona, Murǝm Masar, ace mǝnana wu pusǝ aɓwana mem, amǝ Isǝrayila, ɓǝà purî ɓá Masar ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pǝlǝa Musa ɓuaki Ɓakuli ama, <<Mǝ nda yana mana mǝ nǝ kúti aɓadǝm Firona ka? Mǝ nda yana mǝnana mǝ nǝ pusǝ amǝ Isǝrayila aɓa Masar ka?>> ");
INSERT INTO mbu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Pǝlǝa Ɓakuli ne wi ama, <<Mǝ nda atò, sǝ mǝnia ka nda gìr mana nǝ̀ lǝmdǝ ama mǝ nǝ̀ túrrǒ ka: Lang a pusǝna amǝ Isǝrayila à purnǝì ɓá Masar ka, we wunǝia, wun nǝ̀ yia peri abanam amur nkono mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pǝlǝa Musa ne Ɓakuli ama, <<Ɓǝ̀ ǝn wari aban amǝ Isǝrayila, sǝ ǝn nea wia ama, <Ɓakuli mala aká wun nǝ̀ túrǎm aban wun,> sǝ à ɗiem ama, <Mana nda lùllǝì ka?> Mana mǝ nǝ banggia wia?>> ");
INSERT INTO mbu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ɓakuli pê Musa eare ama, <<MƏ NDA MƏNANA MƏ NDA KA. Mǝnia ka nda cau mana awu nǝ ne amǝ Isǝrayila ka: <MƏ NDA nǝ̀ túrǎm aban wun.> >> ");
INSERT INTO mbu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ɓakuli nyar ɗǝm ne Musa ama, <<Banggi amǝ Isǝrayila mǝnia yì cau ka ama: <Yahweh, Ɓakuli mala aká wun, yì Ɓakuli mala Ibǝrayim, Ɓakuli mala Ishaku, sǝ Ɓakuli mala Yakupu, nda túrǎm aban wun ngga.> Mǝnia ka nda lùllǝàm mǝnana málá male pà kàm raka, kǝ lùllǝú mǝnana à nǝ̀ ɗenyinǝ mim nǝi arǝ anza kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","<<Kyane, kya ramba aɓwana-mǝgule mala amǝ Isǝrayila a banɓwáná sǝ wu banggia wia ama <Yahweh, Ɓakuli mala aká wun, Ɓakuli mala Ibǝrayim, Ɓakuli mala Ishaku, sǝ Ɓakuli mala Yakupu, pusǝrǝi abanam, sǝ na ama, <<Ən soana mǝsǝàm kyap-kyap arǝ wun, andǝ gìr mǝnana à kǝ pakka wun a Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Sǝ mǝ ndarǝ pacau ama mǝ nǝ pusǝ wun ɓǝ̀ wu purî ɓá parban mala tanni mǝɓike mala Masar, sǝ mǝ nǝ kánǝia a nzali mǝnana kiura andǝ mur'nyi kǝ ɓang kàm ngga; nzali mǝnana amǝ'Kan'ana, andǝ amǝ'Hitti, andǝ amǝ'Amor, andǝ amǝ'Periz, andǝ amǝ'Hivi, andǝ amǝ'Jebus duk kam ngga.>> > ");
INSERT INTO mbu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","<<Aɓwana-mǝgule mala Isǝrayila nǝ̀ kwakikiria a rǝò. Pǝlǝa we wunǝ aɓwana-mǝgule ka wun nǝ̀ ká aban murǝm Masar sǝ wun nǝ̀ banggi wi ama, <Yahweh, Ɓakuli mala amǝ Ibǝru lǝmdǝna rǝì aban sǝm. Ado ka, ida eara sǝm ɓǝ̀ sǝm twal gya mala nongŋo tàrú aban ká njenza aɓa pǝɗanban ace pà gìr'nkila aban Yahweh, Ɓakuli ma'sǝm.> ");
INSERT INTO mbu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Sǝama ǝn sǝlǝna ama murǝm Masar pà nǝ̀ nying wun ɓǝ̀ wu u ɗang, she ɓǝ̀ kaɓa bù tsǝ̀ngŋǝ̀nì púp ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Acemani ka, mǝ nǝ loasǝ buam mǝ nǝ wal Masar, nǝ agir-ndǝlǝki amǝ kàrmuruì mǝnana kat mǝ nǝ peǎ aɓalǝi ka. Anzǝm mǝno ka nǝ̀ nying wun ɓǝ̀ wu o. ");
INSERT INTO mbu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mǝ nǝ tsǝa aɓwana man nǝ̀ kum earmúrú aban amǝ Masar, sǝ ɓǝ̀ yina o, wun nǝ̀ nying Masar ka, pà wun nǝ̀ umnǝ ɓabù wun ɓà ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Koya ɓwama Isǝrayila ka nǝ̀ nggá zǝmbî aɓî amǝ'murkala amamǝna Masar andǝ koya ɓwama Masar mǝnana ndanǝ do a atè ka, ɓǝà pè wi agir-nggūrǝu andǝ agir azǝrfa andǝ bolo-njengǝlan. Wun nǝ̀ oasǝì amuna ma'wun amuna-burana andǝ amuna-mamǝna amǝnia yì agir ka arǝia. Anggo sǝ wun nǝ̀ pwan kume mala amǝ Masar arǝia.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Sǝ Musa ka pè Yahweh eare ama, <<Sǝ amǝ Isǝrayila ka, à pà nǝ̀ earnǝ mim, ko à nǝ̀ ok cau mem ɗàng; à nǝ̀ bang ama, we Yahweh ka a lǝmdǝ rǝò abanam ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nda Yahweh ɗì ama, <<Mana mǝna a buo ka?>> Musa eari wi ama, <<Gara na.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yahweh ne wi ama, <<Túrí a nzali.>> Pǝlǝa Musa túr gara mana a buì ka a nzali, kara garè pǝlǝ n'yau. Musa nyar nǝ te cambi wi zak. ");
INSERT INTO mbu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Sǝ Yahweh ne wi ama, <<Lǝmdǝ buo bwali a nggilate.>> Pǝlǝa Musa lǝmdǝ buì bwali a nggilate, kara nyare pǝlǝ gara ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yahweh pǝlǝa na ama, <<Mǝnia ka nda ace mǝnana ɓǝà ear ama, Mim, Yahweh, yì Ɓakuli mala akeâ, Ɓakuli mala Ibǝrayim, Ɓakuli mala Ishaku, sǝ Ɓakuli mala Yakupu ka, ǝn lǝmdǝna rǝàm a bano.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Pǝlǝa Yahweh ne Musa ɗǝm ama, <<Ado ka oasǝ buo aɓa daura mô.>> Pǝlǝa Musa oasǝ buì aɓa daura male, sǝ lang pusǝ bui ɗǝm ngga, kwánó nggû angŋa bui pwasǝna pwapwat kǝla talimbulo. ");
INSERT INTO mbu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nyare Yahweh banggi wi ama, <<Nyesǝ buo aɓa daura mô.>> Pǝlǝa Musa nyesǝ bui aɓa daura male, sǝ lang pusǝ bui ka, buì nyarna pǝlǝna mǝɓoarne kǝla cili rǝì. ");
INSERT INTO mbu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yahweh banggi Musa ama, <<Ɓǝ̀ amǝ Isǝrayila ginǝ earnǝ we ko à tsǝkir gir'ndali mǝnana a dǝmba raka, à nǝ̀ earnǝ gir'ndali mǝnia nǝnzǝ́mò ka. ");
INSERT INTO mbu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ɓǝà ginǝ earnǝ we ko à ok cau mò raka, kat andǝ amani ama a lǝmdǝia wia amǝnia yì agir'ndali ɓari ka, ɗàrǝ́ mur a Nggeasala Nayel sǝ wu solǝi a nzali. Mùrnî nǝ̀ pǝlǝ nkila a nzali.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Pǝlǝa Musa banggi Yahweh, ama, <<Ida Mǝtalem, ǝn sǝlǝ nacau ɗàng. Kaniama awu nǝ nacau nǝ mim ngga, mǝ nda mǝ'sǝlǝ nacau ɗàng, sǝ ko ado mǝno a nanacau nǝ mim guro mò ka ǝn gandǝi ɗàng. Acemǝnana ǝn nggǝ dǝndi nacau, sǝ lasǝàm kǝ twal cau tù ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pǝlǝa Yahweh ɗî Musa ama, <<Yana pak kún ɓwa ɗe? Sǝ yana tsǝkiyi ɓwa ɓǝ̀ do mǝtalasǝ-ɓunna, ko mǝkir'ara, ko mǝ sǝnban, ko nte? Mim Yahweh ka, mǝ nda re? ");
INSERT INTO mbu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ado ka kyane, Mǝ nǝ bwalo kàm, awu nǝ nacau pepè, sǝ mǝ nǝ kanio cau mǝnana awu nǝ na ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Sǝ Musa nyar ɗǝm zǝmba ama, <<Mǝtalem, ida, túr ɓeɓwa ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kara bum Yahweh lúllô arǝ Musa, pǝlǝa banggi wi ama, <<Mǝ'eambo Haruna, mǝ'kà Lawi ka pà kàm re? Ən sǝlǝ nǝma yì ka sǝlǝ nacau. Ko ado ka nda kǝ yiua kúllió ka, sǝ ɓǝ̀ yi sǝno ka, ban nǝ̀ ɓoari wi. ");
INSERT INTO mbu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","We ka awu nǝ ne wi cau, awu nǝ tsǝki wi cau a kúni. Mǝ nǝ dupô gbasha arǝ nacau, sǝ mǝ nǝ dupî wi gbasha arǝ nacau, sǝ mǝ nǝ kania wun gìr mǝnana wun nǝ̀ pak ka. ");
INSERT INTO mbu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haruna nǝ̀ duk mǝ'nacau a kunio aban aɓwana, yì ka nǝ̀ duk mǝ'bǝlkúnó, sǝ we ka awu nǝ do kǝla Ɓakuli a baní. ");
INSERT INTO mbu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sǝ awu nǝ twal gara mò mǝnia ka a buo, acemǝnana kǝ garè na awu nǝ pàkki agir-ndali nǝi ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Pǝlǝa Musa nyare aban nkili Jetǝro sǝ banggi wi ama, <<Ida, earâm ɓǝ̀n o mǝ nyare aban aɓwana mem a Masar. Nǝma mǝ nǝ nggá sǝnia ko à ndakam nǝyilǝmu più.>> Jetǝro pǝlǝa banggi wi ama, <<Kya ɓá rǝpwala.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa ka nda kano a nzali Midiyan più sǝ Yahweh banggi wi ama, <<Nyare o a Masar, acemǝnana aɓwana mǝnana à kǝ alta yilǝmo ama à nǝ̀ wal-luio ka à wukina kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Nda Musa twal māmí andǝ amuni tsǝia a nzǝm mǝdambǝriso, sǝ bwal njar andǝia aban o a nzali Masar ka. Musa twal gara male mǝnana Ɓakuli banggi wi ama ɓǝ̀ bwali a bui ka. ");
INSERT INTO mbu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yahweh nyare nacau nǝ Musa ama, <<Lang a bingŋǝna Masar ka, kya ban Firona kya pàkki agir'ndali mǝnana ǝn pô rǝcandǝa mala pàkkia ka, a ɓadǝmbi. Sǝ mim ngga, mǝ nǝ tǝ́r ɓabumi, sǝ yì ka pà nǝ̀ earî amǝ Isǝrayila ɓǝà u ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Pǝlǝa awu nǝ banggi wi ama Mim, Yahweh ka, ǝn nggǝ na nǝma, <Isǝrayila nda muna-dǝmba mem. ");
INSERT INTO mbu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ən bangŋǝno nǝma wu nying munem ɓǝ̀ o, ace mǝnana ɓǝ̀ kya peri abanam ngga, sǝ a ginǝ eari wi ɓǝ̀ o. Acemani ka, mǝ nǝ wal-lú muna-dǝmba muna-ɓwabura mô.> >> ");
INSERT INTO mbu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","A ɓè bansulǝo a njar aban ká Masar ka, Yahweh yiu yi je andǝ Musa sǝ earce ama nǝ̀ wal-lú Musa. ");
INSERT INTO mbu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Pǝlǝa Zipora, mālá Musa twal tali mǝ'kún-cauwe kasǝ nggú kún ɓata muni nǝi kpat. Twal nggú kún ɓata muna mǝnana kasǝi ka, wario kya je ka kusǝ Musa nǝi sǝ bang ama, <<A nda bura mala nkila abanam.>> ");
INSERT INTO mbu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Cau mǝno bang ama, A nda bura mala nkila ka, nda ace kasǝ-ɓatau mǝno kasǝî muna sǝ nkila sukki ka. Nda Yahweh ɗeki Musa wal-luí raka. ");
INSERT INTO mbu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yahweh ka nanì Haruna ama, <<Puro kyane a njenza aɓa pǝɗanban kya kum Musa.>> Nda Haruna puro wario kya kum Musa a Nkono mala Ɓakuli ka; sǝ lang à je ka, mǝn abui kùrì zǝp, pàkkì'nzalè. ");
INSERT INTO mbu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa pǝlǝa banggi Haruna agir mǝnana kat Yahweh túrí ama ɓǝ̀ kya nâ, andǝ agir-lǝmdǝa mǝnana banggi wi ama ɓǝ̀ kya peǎ ka. ");
INSERT INTO mbu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nda sǝ Musa andǝ Haruna nyare a Masar à kya tunǝ dapi mala aɓwana-mǝgule mala amǝ Isǝrayila kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haruna pǝlǝa banggia wia cau mǝnana kat Yahweh banggi Musa ka, sǝ Musa pàk agir-ndali mǝnana Ɓakuli lǝmdǝì wi ka, a ɓamǝsǝ aɓwana. ");
INSERT INTO mbu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Pǝlǝa aɓwana eare ama Yahweh na túr Musa ka, sǝ lang à ok ama Yahweh ɗenyina nǝ Isǝrayila sǝ sǝnǝna nggea tanni mǝkǝ̀rkǝ́rnì mǝnana à kǝ nu ka, à ɓun a nzali à peri aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Anzǝm mani ka, Musa andǝ Haruna kùtí aban Firona, Murǝm Masar, à ne wi ama, <<Mǝnia ka nda cau mǝnana Yahweh, Ɓakuli mala amǝ Isǝrayila bang ngga, <Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya pak Lamsan mala gusǝlǝ lùllǝàm a ɓabondo.> >> ");
INSERT INTO mbu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Sǝ Firona nyesǝia wia ama, <<Yana nda Yahweh, mǝnana mǝ nǝ oki wi sǝ mǝ nying Isǝrayila ɓǝ̀ u ka? Ən súrǝ̀ Yahweh ɗàng, sǝ pà mǝ nǝ nying Isǝrayila ɓǝ̀ u ɗang.>> ");
INSERT INTO mbu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Pǝlǝa Haruna andǝ Musa bang ama, <<Ɓakuli mala amǝ Ibǝru lǝmdǝna rǝì aban sǝm. Acemani ka, ida, nying sǝm ɓǝ̀ sǝm twal gya mala nongŋo tàrú aban ká a ɓabondo, ace mǝnana ɓǝ̀ sǝm kya pa gir'nkila aban Yahweh Ɓakuli ma'sǝm ngga. Ɓǝ̀ sǝm pa anggo raka, nǝ̀ wal-lú sǝm nǝ kwánó ko nǝ lwa.>> ");
INSERT INTO mbu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Firona, Murǝm Masar banggia wia ama, <<We Musa wunǝ Haruna, palang sǝ wu kǝ tamsǝ aɓwana man arǝ túró malea le? Wu nyar a túró guro ma'wun!>> ");
INSERT INTO mbu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pǝlǝa Firona Murǝm na ama, <<Wu sǝni, amǝ Ibǝru adyan ngga à làkkìna aɓa nzali Masar sǝ ndo wu kǝ tamsǝia arǝ túró malea mana nda púp à nǝ̀ pè ka!>> ");
INSERT INTO mbu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","A kǝ pwari mǝno ka, Firona túrban à tunǝ aɓwana male, yià amǝ-pǝ̀rta aguro andǝ aɓea amǝ Isǝrayila mana à twalia ace sǝntà túró ka, sǝ banggia wia ama: ");
INSERT INTO mbu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","<<Twal ado aban ká dǝmba ka, wu kǝa nyare wu pè amǝ Isǝrayila lusung-pwasǝa ace yau dǝɓang ɓak tobali ɗǝm ɗang; yia nǝ nggearǝia ɓǝà kyane ɓǝà kya pwan lusung-pwasǝa malea. ");
INSERT INTO mbu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Sǝ wu kǝa na ama wun nǝ̀ amsǝ làkkì mala atobali mǝnana à nǝ̀ ɓak aɓa pwari mwashat ka ɗàng ko bǝti. Sǝ ɗǝm ngga dumǝna púp à nǝ̀ lùmsǝkún túró malea ɓǝ̀ pǎ kǝla mana ndakam ɗiɗyal ka. Ɗwanyi túró nǝ tsǝia sǝ à kǝ ɓua ama ɓǝ̀n ɗekia à nǝ̀ o, à nǝ̀ ká pà gìr'nkila aban Ɓakuli malea ka. ");
INSERT INTO mbu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wu paria wia túró amúrià mǝnana nǝ̀ tsǝia à nǝ̀ do aɓa túró mǝkǝ̀rkǝ́rnì koya pwari ka. Anggo ka à pà nǝ̀ kwakikiria arǝ nyir mǝnana à kǝ banggia wia ka ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nda amǝ-pǝ̀rta aguro andǝ aɓwana mana à tsǝia ace sǝntà túró ka, à puro à kya ramba amǝ Isǝrayila sǝ à banggia wia ama, <<Mǝnia ka nda cau mǝnana Firona Murǝm Masar bang ngga: <À pà nǝ̀ nyare à nǝ̀ pà wun lusung-pwasǝa ace yau dǝɓang ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Wun nǝ nggearǝ wun wu kyane wu kya alta lusung-pwasǝa ma'wun a ban mǝnana wun nǝ̀ kumi kàm ngga, sǝ kat andǝ amǝno ka à pà nǝ̀ amsǝa wun túró ma'wun ɗàng ko bǝti.> >> ");
INSERT INTO mbu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nda amǝ Isǝrayila puro à mesǝe aɓa nzali Masar kat, aban alta kwa arǝ aɓaban à nǝ̀ pangna túró nǝi a kúnì lusung-pwasǝa ka. ");
INSERT INTO mbu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Amǝ-pǝ̀rta aguro camarǝ pìtea ama, <<Wu masǝlǝ túró mana à kasǝa wun mala koya pwari, kǝla pě mana ɗiɗyal à kǝ pa wun lusung-pwasǝa ka!>> ");
INSERT INTO mbu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Amǝ-pǝ̀rta aguro mala Firona kok amǝ Isǝrayila mana twalia ace sǝntà túró ka nǝ nkamso, sǝ à ɗiǎ ama, <<Mana tsǝa sǝ aguro mana à tsǝk wun amúrià ka à mal túró ɓak tobali mǝnana kat à kasǝia wia yilung andǝ yalung, kǝla mana ɗiɗyal ka ɗàng?>> ");
INSERT INTO mbu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Amǝ Isǝrayila mǝnia à twalia ace sǝntà túró ka, à wari aban Firona nǝ ɓua malea ama, <<Palang sǝ a pakka sǝm ani, sǝm aguro mò? ");
INSERT INTO mbu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","À tàmsǝna pà sǝm lusung-pwasǝa ace yau dǝɓang, sǝ kat andǝ mǝno ka, à camarǝ pîtà sǝm ama ɓǝ̀ sǝm ɓak tobali. Ado ka à kutina kok sǝm. Aɓwana mô amǝ Masar na mǝnana à pàk pepè raka.>> ");
INSERT INTO mbu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Sǝ Firona nyesǝia wia ama, <<Wu nda ka amǝ'doɓana, wu earce pàk túró ɗang! Nda gìr mǝnana tsǝa sǝ wu kǝ nam ama ɓǝ̀n ɗeki wun, wun nǝ̀ o a pà gir'nkila aban Yahweh Ɓakuli ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ado ka, wu nyare a kún túró! À pà nǝ̀ pà wun lusung-pwasǝa ɗàng, sǝ dumǝna púp wun nǝ̀ ɓak làkkì mala atobali mǝnana à kasǝa wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Amǝ Isǝrayila mǝnana à tsǝia sǝntà túró, sǝni ka, à nda ɓá tanni mǝkwane lang à ok ama à pà nǝ̀ amsǝia wia làkkì mala atobali mǝnana à nǝ̀ ɓak aɓa pwari mwashat raka. ");
INSERT INTO mbu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Lang à purî ɓadǝm Firona ka, à kum Musa andǝ Haruna aban came, à nda rǝ kúndǝia. ");
INSERT INTO mbu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","À banggi Musa andǝ Haruna ama, <<Ɓǝ̀ Yahweh sǝn gìr mǝnana wu pàk ka, sǝ ɓǝ̀ ɓasha wun, acemǝnana wu tsǝ̀ngŋǝ̀nà, sǝm pǝlǝna aɓwana mǝnana à nǝ̀ ɓinǝmǝsǝia a sǝne mala murǝm andǝ amǝtúró male ka, sǝ wu pània wia gara wal sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Pǝlǝa Musa nyare aban Yahweh sǝ banggi wi ama, <<We Yahweh, palang ado sǝ a yinǝ tanni amur aɓwana mǝnia? Ace mana sǝ a túrǎm? ");
INSERT INTO mbu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Twala a pwari mǝnana ǝn wari nǝi aban Firona ace ne wi cau mò mǝnana a túrǎm nǝi ka, kara kǝ lidǝmba nǝ li aban pea aɓwana mô tanni, sǝ ko a pak kǝgìr mǝnana awu nǝ pusǝia aɓa tanni ka ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pǝlǝa Yahweh ne Musa ama, <<Ado ka, awu nǝ sǝn gìr mǝnana mǝ nǝ pàkkî Firona ka: Mǝ ndo mǝ nǝ tsǝì nǝ rǝcandǝa mem ɓǝ̀ nying aɓwana mem ɓǝà o. Yàle yì ka, nǝ̀ pǝria nǝ pǝra, ɓǝà upi nzali male.>> ");
INSERT INTO mbu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nyare Ɓakuli ne Musa cau ama, <<Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ən lǝmdǝ rǝàm aban Ibǝrayim, aban Ishaku, sǝ aban Yakupu, ama, Mǝ nda Ɓakuli mǝnana Kar Ban Kat nǝ Gulo ka. Sǝama lùllǝàm mǝnana ama Yahweh ka, ǝn lǝmdǝia wia à súrǝàm nǝi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ɗǝm ngga ǝn kúti aɓa kùrcau sǝnǝia ama, mǝ nǝ pea wia nzali Kan'ana, yì nzali mǝnana à duk kam kǝla abǝri ka. ");
INSERT INTO mbu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Sǝ adyan ngga, ǝn ongŋǝna imge mala amǝ Isǝrayila mǝnana amǝ Masar tsǝia aguro ka, sǝ ɓalǝam kasǝna arǝ kùrcau mem. ");
INSERT INTO mbu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","<<Acemani ka, kyane banggi amǝ Isǝrayila ama, <Mǝ nda Yahweh. Mǝ nǝ amsǝ wun ɓǝ̀ wu purî ɓá nggea kanggǝrang tanni mǝnana amǝ Masar tsǝk wun aɓalǝi ka. Mǝ nǝ pusǝ wun aɓata doguro aɓatea, sǝ mǝ nǝ akmúr wun nǝ kaɓa rǝcandǝa mem andǝ lǝmdǝ atúró mǝgule mala ɓashi amur amǝ Masar. ");
INSERT INTO mbu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mǝ nǝ ak wun, wun nǝ̀ duk aɓwana mem, sǝ mǝ nǝ duk Ɓakuli ma'wun. Sǝ wun nǝ̀ sǝlǝ ama Mǝ nda Yahweh, Ɓakuli ma'wun, mǝnana pusǝ wun wu purî ɓá nggea kanggǝrang tanni mǝnana amǝ Masar tsǝk wun aɓalǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Sǝ mǝ nǝ yinǝ wun a nzali mana ǝn kángìr nǝma mǝ nǝ pè Ibǝrayim, andǝ Ishaku, andǝ Yakupu ka. Mǝ nǝ pà wuni ɓǝ̀ duk girkuma ma'wun. Mǝ nda Yahweh!> >> ");
INSERT INTO mbu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Anggo sǝ Musa nea amǝ Isǝrayila cau, sǝ yia ka à kwakikiria arǝì ɗàng, ace ɓungio mana ɓabumia ɓungi ka andǝ tanni mǝcandǝe mǝnana à nu aɓata túró-guro mǝɓike ka. ");
INSERT INTO mbu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Pǝlǝa Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","<<Nyare, kyane aban Firona, murǝm Masar, kya ne wi ama, ɓǝ̀ nying amǝ Isǝrayila ɓǝà purî ɓá nzali male.>> ");
INSERT INTO mbu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Sǝ Musa ka nyesǝî Yahweh cau ama, <<Nggearǝ amǝ Isǝrayila, yì aɓwana mem ngga à kwakikiria arǝàm rakâ, sǝ lang sǝ Firona nǝ̀ kwakikiri arǝàm, mim mǝnana ǝn nggǝ gandǝ nacau pepè raka?>> ");
INSERT INTO mbu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yahweh nacau nǝ Musa andǝ Haruna sǝ tasǝia nǝ cau aban amǝ Isǝrayila, sǝ aban Firona murǝm Masar, ɓǝà panzǝ amǝ Isǝrayila ɓǝà purî ɓá nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Amǝnia ka à nda ka kau mala atau a nggurkwar mala Musa andǝ Haruna: Amuna-burana mala Ruben, muna-dǝmba mala Isǝrayila ka à nda ka: Hanok, andǝ Palu, andǝ Hezǝron, sǝ Karmi. À nda ka kau a nggurkwar mala Ruben. ");
INSERT INTO mbu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Amuna-burana mala Shimiyon ngga à nda ka: Jemuyel, andǝ Jamin, andǝ Ohat, andǝ Jakin, andǝ Zohar, sǝ Shawul muna mala ɓwama Kan'ana. À nda ka kau a nggurkwar mala Shimiyon. ");
INSERT INTO mbu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Amǝnia ka, à nda ka lullǝ amuna andǝ amǝkau mala Lawi, arǝ aɓala malea, sǝ arǝ anza malea: Gashon, andǝ Kohat, sǝ Merari. Sauwa mala do ɓanza mala Lawi ka, apǝlǝa gbǝman mwashat nǝ lumi-tàrú nǝ mǝsǝi tongno-nong ɓari na (137). ");
INSERT INTO mbu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Amuna-burana mala Gashon ngga à nda ka: Libǝni andǝ Shimeyi, koyan ngga a nggurkwar male. ");
INSERT INTO mbu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Amuna-burana mala Kohat ka à nda ka: Amram, andǝ Izǝhar, andǝ Hebǝron, sǝ Uziyel. Sauwa mala do ɓanza mala Kohat ka apǝlǝa gbǝman mwashat nǝ lumi-tàrú nǝ mǝsǝi tàrú na (133). ");
INSERT INTO mbu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Amuna-burana mala Merari ka, à nda ka: Mali andǝ Mushi. Aɓwana mǝno kat à tsaɗi lullǝia ka à pur a tàu mala Lawi; à tsaɗia arǝ anza malea. ");
INSERT INTO mbu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram al Jochebet mǝ'kyauwa tárrí, sǝ ɓǝli wi amuna-burana ɓari: Haruna andǝ Musa. Sauwa mala do ɓanza mala Amram ngga pǝlǝa gbǝman mwashat nǝ lumi-tàrú nǝ mǝsǝi tongno-nong ɓari na 137. ");
INSERT INTO mbu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Amuna-burana mala Izǝhar ka à nda ka: Kora, andǝ Nefeg, sǝ Zǝkiri. ");
INSERT INTO mbu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Amuna-burana mala Uziyel ka à nda ka: Mishayel, andǝ Elzafan, sǝ Sitǝri. ");
INSERT INTO mbu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna al Elisheba, nsarile Aminadap sǝ mǝ'eam Nashon. Elisheba ɓǝlî wi amuna-burana, à nda ka: Nadap, andǝ Abihu, andǝ Eleaza, sǝ Itamar. ");
INSERT INTO mbu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Amuna-burana mala Kora ka à nda ka: Asir, andǝ Elkana, sǝ Abiyasaf. À nda ka kau a nggurkwar mala Kora. ");
INSERT INTO mbu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleaza muna-ɓwabura mala Haruna ka yi al mwashat atà ansarina mala Putiyel, sǝ ɓǝli wi muna-ɓwabura male: Finehas. Amǝno ka à nda ka aká aɓwana andǝ amǝɓala malea a tàu mala Lawi, koyan ngga a nggurkwar male. ");
INSERT INTO mbu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haruna andǝ Musa mǝnana à tunǝ lullǝia a tsadya mala alullǝu kani ka, à nda mǝnana Yahweh bangcau nǝia ka ama, <<Wu pusǝ amǝ Isǝrayila ɓǝà purî ɓá nzali Masar, koya tàu ka a nggǝsan malea a nzǝmarǝia.>> ");
INSERT INTO mbu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Kǝ yià, Musa andǝ Haruna mǝnia ka, à nda ka aɓwana mana à bangcau nǝ Firona, murǝm Masar ace pusǝ amǝ Isǝrayila ɓǝà purî Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","A pwari mana Yahweh bangcau nǝ Musa a nzali Masar ka, ");
INSERT INTO mbu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yahweh ne wi ama, <<Mǝ nda Yahweh. Banggi Firona murǝm Masar gìr mana kat ǝn banggo ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Sǝ Musa ka na a ɓadǝm Yahweh ama, <<Sǝni, ǝn sǝlǝ nacau ɗàng; lang sǝ Firona nǝ̀ kwakikiri arǝàm?>> ");
INSERT INTO mbu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Pǝlǝa Yahweh banggi Musa ama, <<Sǝni, ǝn nyésǝ̀no a dumǝna kǝla Ɓakuli aban Firona, sǝ mǝ'eambo Haruna ka nǝ̀ do nda mǝɓangnǝa mô. ");
INSERT INTO mbu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Awu nǝ bang cau mana kat ǝn banggo ka, sǝ mǝ'eambo Haruna ka nǝ̀ banggi Firona ama dumǝna púp ɓǝ̀ panzǝ amǝ Isǝrayila ɓǝà purî nzali male. ");
INSERT INTO mbu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Sǝama, mǝ nǝ candǝmúr Firona, sǝ ko ɓǝ̀ ǝn hatǝki pàkkì agir-lǝmdǝa, andǝ agir-ndǝlǝki a nzali Masar ka, ");
INSERT INTO mbu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firona pà nǝ̀ oka wun ɗàng. Pǝlǝa mǝ nǝ nongsǝ buam amur Masar, sǝ mǝ nǝ pàkkì agir mǝgulke mala ɓashi mem, mǝ nǝ pusǝ atau mala aɓwana mem, amǝ Isǝrayila, à nǝ̀ purî ɓá nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nda wuni amǝ Masar nǝ̀ sǝlǝ ama mǝ nda Yahweh, a pwari mana ɓǝ̀n lǝmdǝna buam arǝ Masar, mǝ nǝ pusǝ amǝ Isǝrayila ɓǝà purî ɓalǝia ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa andǝ Haruna pàk gìr mǝnana Yahweh banggia wia ama ɓǝà pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","A bàkú mana à waria banggi Firona cau ka, apǝlǝa mala Musa ka, lumi-tongno-nong-tàrú na (80), sǝ mala Haruna ka, lumi-tongno-nong-tàrú nǝ mǝsǝ tàrú na (83). ");
INSERT INTO mbu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Pǝlǝa Yahweh ne Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","<<Ɓǝ̀ Firona bangga wun ama ɓǝ̀ wu pàk gir'ndǝlǝki ka, ne Haruna ɓǝ̀ twal gara male ɓǝ̀ túrí a ɓadǝm Firona, garè nǝ̀ pǝlǝ n'yau.>> ");
INSERT INTO mbu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Pǝlǝa Musa andǝ Haruna wari aban Firona Murǝm, à kya pa kǝla mǝnana Yahweh banggia wia ka. Haruna túr gara male a ɓadǝm Firona andǝ amǝgulo male, sǝ garè kara pǝlǝ n'yau. ");
INSERT INTO mbu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pǝlǝa Firona tunǝ amǝ'sǝlǝe andǝ amǝ'monzǝo; sǝ yià gbal, amǝ'pakki anggár mala Masar ka, à paktúró nǝ monzǝo malea à pak gbal kǝla mǝnana Musa pak ka. ");
INSERT INTO mbu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","À túrki agara malea a nzali, sǝ agara pǝlǝ an'yau. Sǝama gara mala Haruna myal agara malea. ");
INSERT INTO mbu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kat andǝ amani ka, Firona candǝmúrí. Sǝ kǝla mǝnana Yahweh bang ngga, anggo sǝ pa, ko Firona kwakikiri arǝ Musa andǝ Haruna ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Pǝlǝa Yahweh ne Musa ama, <<Firona ka múrí-candǝna, sǝ ɓinǝna pà nǝ̀ nying amǝ Isǝrayila ɓǝà u ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Acemani ka, kyane kya kumi nǝ dǝmbari lang purna nǝ̀ ká a nggeasala ka. Came a kún Nggeasala Nayel wu kundǝi ace mǝnana wun nǝ̀ je wunǝi ka. Twal gara mò mǝno pǝlǝ n'yau ka a buo. ");
INSERT INTO mbu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Banggi wi ama, <Yahweh, yì Ɓakuli mala amǝ'Ibǝru tasǝam ɓǝ̀n banggo ama, <<Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya peri abanam a ɓabondo ka.>> Sǝ bà ado ka a kwakikiro ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ado ka, Yahweh kǝ bang ama, <<Nǝ mǝnia ka, sǝ awu nǝ sǝlǝ ama, mǝ nda Yahweh.>> Sǝni, nǝ gara mǝnia a buam ngga, mǝ nǝ wal mùr Nggeasala Nayel, sǝ mùrî ka nǝ̀ pǝlǝ nkila. ");
INSERT INTO mbu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nji mǝnana kat a Nggeasala Nayel ka nǝ̀ wú, sǝ rǝmban mǝɓane nǝ̀ ak mùr, sǝ amǝ Masar nǝ̀ ginǝki nu mùrnî.> >> ");
INSERT INTO mbu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yahweh ne Musa ama, <<Banggi Haruna ɓǝ̀ twal gara male a buì sǝ ɓǝ̀ sárǝí amur amúr mala nzali Masar, amur anggeasala malea, andǝ amyalmúr malea, andǝ aguguri malea, andǝ tūli-mùr malea, ace mǝnana ɓǝà pǝlǝ nkila ka. Nkila nǝ̀ ak ɓá nzali Masar kat, yàle kat andǝ ɓalǝ adù-mùr andǝ abàng-mùr.>> ");
INSERT INTO mbu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Nda Musa andǝ Haruna pak kǝla mǝnana Yahweh banggia wia ka. A mǝsǝ Firona andǝ amǝtúró male, Haruna loasǝ gara male wal mùr Nggeasala Nayel nǝi, sǝ mùr nggeasala kat ka, pǝlǝ nkila. ");
INSERT INTO mbu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nji mǝnana a nggeasala kat ka wǔ rǝmbô, sǝ rǝmban mǝɓike ak mùr kat, gandǝa amǝ Masar gandǝ nue ɗàng. Koya ban aɓa Masar ka nkila na. ");
INSERT INTO mbu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Sǝ amǝ'pakki agir nggár mala Firona gbal ka, à pàktúró nǝ monzǝo malea, à nyesǝ mùr pǝlǝ nkila. Sǝ kǝla mǝnana Yahweh na ka, Firona tǝ́r ɓabumi, ɓinǝ kwakikiri arǝ Musa andǝ Haruna. ");
INSERT INTO mbu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kara wulio, bwal njar o a palta male, falǝ nǝia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Pǝlǝa amǝ Masar kat kùtí a tǝm sala a kún Nggeasala Nayel aban alta mùr-nùná, acemǝnana à pà nǝ̀ gandǝ nu mùr mala nggeasalê ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Anonggió tongno-nong-ɓari yi kutio anzǝm mana Yahweh tsǝk mùr Nggeasala Nayel pǝlǝ nkila ka. ");
INSERT INTO mbu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Pǝlǝa Yahweh ne Musa ama, <<Kyane aban Firona murǝm Masar, sǝ wu ne wi ama: Yahweh na kǝ banggo ama, <Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya peri a banam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ɓǝ̀ a ɓinǝ nyia ɓǝà u ka, sǝni mǝ nǝ tsǝa nzali mô kat nǝ̀ lùmsǝ nǝ anɗwalung. ");
INSERT INTO mbu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nggearǝ Nggeasala Nayel ka nǝ̀ lùmsǝ nǝ anɗwalung, yàle à nǝ̀ nggá ara aɓa palta mô, andǝ ndà-nongŋo mô, andǝ gyangŋan-nongŋo mô, andǝ aɓala mala amǝtúró mô, andǝ amala aɓwana mô kat. Ko nggearǝ andá-lurǝgìr andǝ atasau-sùrǝ̀gir ma'wun ngga à nǝ̀ lùmsǝ nǝ anɗwalung. ");
INSERT INTO mbu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Anɗwalung nǝ̀ eauwe amuro, andǝ múr aɓwana mô, andǝ múr amǝtúró mô kat.> >> ");
INSERT INTO mbu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Pǝlǝa Yahweh banggi Musa ama, <<Banggi Haruna ɓǝ̀ lǝmdǝ gara male mǝnana a buì ka amur anggeasala, andǝ amyal-múr, andǝ aguguri, ɓǝ̀ tsǝk anɗwalung ɓǝà eauwe ɓǝà kya gir nzǝm-nzali Masar kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Pǝlǝa Haruna lǝmdǝ gara male mana a buì ka amur amúr mala Masar, sǝ anɗwalung eapi mùr à kya lumsǝ ɓá nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Sǝ amǝ'pakki agir nggár pak gìr mǝmwashati nǝ túró kutan malea, à tsǝk anɗwalung à yiu amur nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pǝlǝa Firona Murǝm tunǝ Musa andǝ Haruna, sǝ banggia wia ama, <<Wu pak hiwi aban Yahweh ɓǝ̀ twàlâm amǝnia yì anɗwalung ngga ɓǝà nying sǝm sǝnǝ aɓwana mem, sǝ mǝ nǝ nying aɓwana mô ɓǝà o ace mǝnana ɓǝà kya pa agir'nkila aban Yahweh ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa pe wi eare ama, <<Ən nggǝ pò gulo mala nyinggo tsǝk pwari mǝnana ɓǝ̀n pak hiwi nǝi aceo, sǝ ace amǝ'túró mô, andǝ aɓwana mô, ace mǝnana anɗwalung ɓǝà nying wun andǝ aɓala ma'wun ngga, she akǝ mana a Nggeasala Nayel ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firona banggi wi ama, <<Pè lí.>> Pǝlǝa Musa banggi wi ama, <<Mǝ nǝ pè kǝla mǝnana a bang ngga, sǝ awu nǝ sǝlǝ ama kǝ ɓè ɓakuli pa kàm kǝla Yahweh Ɓakuli ma'sǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Anɗwalung nǝ̀ upì ban wun, andǝ aɓala ma'wun, andǝ mala amǝ'túró mô, andǝ mala aɓwana mô. Kǝ amǝnana à nǝ̀ ue ka à nda ka mana a Nggeasala Nayel ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Pǝlǝa Musa andǝ Haruna nying ɓadǝm Firona Murǝm, sǝ Musa ɓua aban Yahweh ama, ɓǝ̀ pǝ̀r anɗwalung mǝnana yinǝia amur Firona, murǝm Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yahweh pak kǝla mǝnana Musa zǝm ngga. Anɗwalung mana arǝ aɓala, andǝ amǝnana a palta, andǝ amǝnana arǝ abanfana ka, à wukio. ");
INSERT INTO mbu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Amǝ Masar ramgia amur rǝarǝia gum-gum, sǝ nggea rǝmban mǝɓike ak nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lang Firona Murǝm sǝni kumǝna usǝlǝo bǝti ka, kara candǝmúrí ɗǝm, ɓinǝ kwakikiri arǝ Musa andǝ Haruna, kǝla mǝnana Yahweh bang ngga. ");
INSERT INTO mbu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nda Yahweh banggi Musa ama, <<Ne Haruna ɓǝ̀ loasǝ gara male ɓǝ̀ wal nzali nǝi sǝ tú ka nǝ̀ pǝlǝ agirlanduno a koya ban aɓa nzali Masar kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Anggo sǝ à pa. Haruna loasǝ gara male wal nzali, kara tú nzali Masar pǝlǝ agirlanduno, mǝnana à akrǝ aɓwana andǝ agirkusǝu ka; tú nzali kat pǝlǝ agirlanduno a koya ban aɓa nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Amǝ'pakki agir nggár mala Firona ɓariki à nǝ̀ pàktúró nǝ monzǝo ɓǝ̀ agirlanduno puro, sǝ ko à gandǝi ɗàng. Sǝ agirlanduno ueo arǝ aɓwana andǝ agirkusǝu. ");
INSERT INTO mbu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Amǝ'pakki agir nggár banggi Firona ama, <<Mǝnia ka, túró mala Ɓakuli na!>> Sǝ kǝla mǝnana Yahweh bang ngga, Firona candǝmúrí, ɓinǝ kwakikiri arǝ Musa andǝ Haruna. ");
INSERT INTO mbu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yahweh ne Musa ama, <<Lo nǝ dǝmbari ɗiɗyal sǝ wu kya kasǝkun Firona ɓǝ̀ purna nǝ̀ o a nggeasala ka. Banggi wi ama, Yahweh kǝ bang ama, <Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya peri a banam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ɓǝ̀ a ɓinǝ nying aɓwana mem ɓǝà u ka, mǝ nǝ tasǝ anggi nggǝm-nggǝm amuro, amur amǝ'túró mô, sǝ amur acili aɓwana mô. À nǝ̀ kutikio arǝ aɓala ma'wun. Aɓala mala amǝ Masar nǝ̀ lùmsǝ nǝ anggi nggǝm-nggǝm, sǝ à nǝ̀ gìr múr nzali mǝnana à duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","<< <Sǝama a pwari mǝno ka, mǝ nǝ yál bu-nzali Goshen, ban mǝnana aɓwana mem nakam nǝ do ka; kǝ anggi pa nǝ̀ pàk kàm ɗàng, ace mǝnana wu sǝlǝ ama, Mim, Yahweh ka, mǝ ndakam aɓa nzali mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mǝ nǝ gau nre aɓwana mem andǝ aɓwana mô. Mǝnia yì gìr'lǝmdǝa ka nǝ̀ kumban li.> >> ");
INSERT INTO mbu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yahweh pè anggo; Yahweh tasǝ anggi nggǝm-nggǝm, à yì ak ɓá palta mala Firona Murǝm, andǝ aɓala mala amǝ'túró male. Ɓá nzali Masar kat kìɗìkì nǝ anggi. ");
INSERT INTO mbu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pǝlǝa Firona túrban ɓǝà tunǝ Musa andǝ Haruna sǝ bang ama, <<Wu kyane, wu kya pa gìr'nkila aban Ɓakuli ma'wun aɓa nzali Masar kani.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Sǝ Musa banggi wi ama, <<Mǝno ka pà nǝ̀ ɓoaro ɓǝ̀ sǝm pè anggo ɗàng. Apagir mala gir'nkila mǝnana sǝm nǝ̀ pà aban Yahweh Ɓakuli ma'sǝm ngga, gìr'ɓeami na aban amǝ Masar. Sǝ ɓǝ̀ sǝm pà agir'nkila mǝnana gìr'ɓeami na a mǝsǝia ka, à pà nǝ̀ ɓukki sǝm nǝ atali re? ");
INSERT INTO mbu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Dumǝna púp sǝm nǝ̀ twal gya mala nongŋo tàrú aban o a ɓabondo, sǝ sǝm nǝ̀ pà gìr'nkila aban Yahweh Ɓakuli ma'sǝm, kǝla mǝnana bangga sǝm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firona bang ama, <<Mǝ nǝ nying wun ɓǝ̀ wu kyane wu kya pa gìr'nkila aban Yahweh Ɓakuli ma'wun a ɓabondo, sǝama wu kǝa u kuko ɗàng. Ado ka, wu pàkkam hiwi.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa eari wi ama, <<Mǝ ndo mǝ nǝ purî ɓadǝmbo, mǝ nǝ pàk hiwi aban Yahweh, sǝ li ka, anggi nǝ̀ nyio wunǝ amǝ'túró mô, andǝ acili aɓwana mô. Sǝama cè a nyare a swarki sǝm ɗǝm, a tamsǝ aɓwana arǝ o a pà gìr'nkila aban Yahweh ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nda Musa puro nying palta mala Firona sǝ zǝmba aban Yahweh ɓǝ̀ pǝ̀r anggi kat ɓǝà u ka. ");
INSERT INTO mbu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Sǝ Yahweh pak kǝla mǝnana Musa zǝmbi wi ka; sǝ tsǝk nggea làkkì mala anggi man à ndǝrmì ban Firona, andǝ amǝ'túró male andǝ acili aɓwana male. Kǝ nggi ueo ko mwashat ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Sǝ kat andǝ mǝno ka Firona Murǝm candǝmúrí, nyare ɓinǝ nying aɓwe ɓǝà o. ");
INSERT INTO mbu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Pǝlǝa Yahweh ne Musa ama, <<Nyare o aban Firona kya ne wi ama, <Yahweh, Ɓakuli mala amǝ Ibǝru kǝ bang ama: Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya peri abanam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ɓǝ̀ a ginǝna ɗǝm a pa wunǝ nyia ɓǝà u raka, ");
INSERT INTO mbu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","buam, Mim Yahweh nǝ̀ sulǝ gìr'mur'mwana mǝɓike kǝ̀rkǝ́r amur agirkusǝu ma'wun mǝnana a patal ka; apǝr ma'wun andǝ amǝdambǝriso ma'wun, andǝ akalakadambi ma'wun, andǝ andá ma'wun, andǝ anzur ma'wun, andǝ ambul-pǝndǝa ma'wun. ");
INSERT INTO mbu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Sǝama mǝ nǝ gakkita agirkusǝu mala amǝ Isǝrayila andǝ mala amǝ Masar; kǝ agirkusǝu mala amǝ Isǝrayila na à pà nǝ̀ wù raka. ");
INSERT INTO mbu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mim Yahweh ka ǝn tsǝ̀ngŋǝ̀nà lí ɓǝ̀ duk pwari mana mǝ nǝ pàk mǝnia yì gìr ka.> >> ");
INSERT INTO mbu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ban yi fana ka, Yahweh pàk gìr mǝnana na ama nǝ̀ pàk ka; agirkusǝu mala amǝ Masar kat wukio, sǝ agirkusǝu mala amǝ Isǝrayila ka, kǝ ɓè wù ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firona ɗiban, sǝ à ne wi gìr mǝnana kumban ngga, ama kǝ girkusǝu mala amǝ Isǝrayila wù ɗàng. Sǝ yì ka, nying buì arǝ murcandǝa male ɗàng; ginǝ nying amǝ Isǝrayila ɓǝà o. ");
INSERT INTO mbu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yahweh ne Musa andǝ Haruna ama, <<Wu pwan tú ɓá ndà-ntul arǝ aɓabu wun; Musa ɓǝ̀ mesǝi aɓa gung a ɓadǝm Firona. ");
INSERT INTO mbu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tú mǝno nǝ̀ mesǝe kǝla kǝkǝri amur nzali Masar kat, sǝ nǝ̀ yinǝ ceakúmsǝǎm, sǝ yì ceakúmsǝǎm ngga à nǝ̀ pǝlǝ ampengŋe gula arǝ ɓwapǝndǝa andǝ agirkusǝu aɓa nzali Masar kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nda à pwan tú a ndà-ntul sǝ à o à kya came a ɓadǝm Firona; Musa mesǝ tú aɓa gung, kara ceakúmsǝǎm mǝnana pǝlǝ ampengŋe gula ka à sàkkya arǝ ɓwapǝndǝa andǝ agirkusǝu. ");
INSERT INTO mbu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Nggearǝ amǝ pàkki agir nggár ka à gandǝ came a ɓadǝm Musa ɗàng atàcau mala ceakúmsǝǎm, acemǝnana rǝia kat ka, ceakúmsǝǎm e kǝla mǝnana ak rǝ amǝ Masar kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Sǝ Yahweh ka candǝ ɓabum Firona, ɓinǝ okia Musa andǝ Haruna, kǝla mǝnana Yahweh ne Musa ka. ");
INSERT INTO mbu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Pǝlǝa Yahweh ne Musa ama, <<Lo nǝ bari ɗiɗyal kyane lǝmdǝ ɓamurò a ɓadǝm Firona, sǝ wu ne wi ama, <Yahweh, Ɓakuli mala amǝ Ibǝru kǝ na ama: Nying aɓwana mem ɓǝà o ace mǝnana ɓǝà kya peri abanam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Sǝ ɓǝ̀ a ginǝ ka, mǝnia adyan ngga mǝ nǝ tasǝ gìr'mur'mwana mǝnana kútì amana ɗiɗyal ka amuro, nggearǝ we, sǝ amur amǝtúró mô, sǝ amur aɓwana a là ma'wun kat. Sǝ wun nǝ̀ sǝlǝ ama, aɓa ɓanza kat ka ɓekǝ ɓwa pà kàm kǝla mim ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ɓǝ̀n ear ka ɓǝ́ adyan ngga ǝn loasǝna buam ǝn kongŋǝ̀no wunǝ aɓwana mô nǝ nggea kwánó mǝɓike, mǝnana ɓǝ́ twalnata wun a bum ɓanza kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Sǝ mim ngga ǝn nyio nǝyilǝmu ace mǝnana ɓǝ̀n lǝmdǝo rǝcandǝa mem, sǝ ɓǝ̀ lullǝam zǝ́kí a ɓanza kat. ");
INSERT INTO mbu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Sǝ kat andǝ amǝno ka, a kǝ twalkirǝo amur aɓwana mem più, sǝ a ɓinǝ ɗekia ɓǝà o. ");
INSERT INTO mbu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Sǝni, lí, a bu-pwari mǝnia ka, mǝ nǝ sulǝ talimbulo mǝkǝ̀rkǝ́rnì mǝnana nzali Masar malaká sǝn ulangnì raka, twal a pwari mana à kwambi nǝi ka, yi pur ado. ");
INSERT INTO mbu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ado ka, túrban ɓǝà nyesǝ agirkusǝu mô andǝ koya gìr mǝnana nda a patal ka, ɓǝà kùtí aɓata tara. Ɓǝ̀ ɓwa, sǝ ɓǝ̀ girkusǝu na mǝnana kat talimbulo man kumi a nza ka, nǝ̀ wù kat.> >> ");
INSERT INTO mbu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Aɓwana-mǝgule mala Firona Murǝm mana ɓangciu pakkia wia arǝ cau mǝnana Yahweh na ka, à nyesǝ aguro andǝ agirkusǝu malea akaurǝa ɓǝà yi kúti arǝ aɓala ace kum àwá. ");
INSERT INTO mbu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Sǝ aɓwana mǝnana à tsǝkir cau mala Yahweh raka, à nying aguro andǝ agirkusǝu malea a patal. ");
INSERT INTO mbu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pǝlǝa Yahweh ne Musa ama, <<Sárǝ́ buo a kùli, ace mǝnana talimbulo ɓǝ̀ sulǝo amur nzali Masar kat; amur ɓwapǝndǝa, amur agirkusǝu, andǝ agirpwala mǝnana a ɓaban aɓa nzali Masar ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Nda Musa loasǝ gara male a kùli, sǝ Yahweh tasǝ sàkkya mala mgbarangce andǝ nya mala talimbulo; sǝ mgbarangce sulǝ nǝ bǝsa amur nzali. Anggo sǝ Yahweh tasǝ talimbulo yi rak kpana-kpana amur nzali Masar kat. ");
INSERT INTO mbu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Lang talimbulo na arǝ nya ka, bǝsa camarǝ liki'nzama aɓalǝi. À nya talimbulo kǝ̀rkǝ́r ulang mǝnana a do mala Masar kǝla nzali ka, à nya ulang mǝno raka. ");
INSERT INTO mbu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Talimbulo mǝno kiɗiki koya gìr mǝnana kumi a nza aɓa nzali Masar ka, kat andǝ ɓwapǝndǝa andǝ agirkusǝu. Agirpwala mǝnana a ɓaban ngga, talimbulo koea rangsǝia a nzali kat, sǝ makki anggun mǝnana kat a patal ka, ɓungia gucik-gucik. ");
INSERT INTO mbu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kǝ ban mǝnana ueo talimbulo je raka, nda bu-nzali mala Goshen, ban mǝnana amǝ Isǝrayila duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firona Murǝm túrban ɓǝà tunǝ Musa andǝ Haruna sǝ banggia wia ama, <<Adyan ngga, ǝn pángŋǝ̀nà cauɓikea! Yahweh ka mǝɓealɓoarna na, sǝ mim sǝnǝ aɓwana mem ngga, sǝm ɓwarkina. ");
INSERT INTO mbu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ida, wu zǝmbî Yahweh! Sàkkya mala mgbarangce andǝ nya mala talimbulo mala Ɓakuli ka, kārǝ́na anggo. Mǝ nǝ nying wun wu o; ɓoaro wu duk kani ɗǝm ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa ne wi ama, <<Ən nggǝ purî ɓá nggea-là ani ka, mǝ nǝ loasǝ buam a kùli aban Yahweh. Talimbulo andǝ mgbarangce nǝ̀ came, sǝ awu nǝ sǝlǝ ama ɓanza ka mala Yahweh na. ");
INSERT INTO mbu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Sǝ ǝn sǝlǝna ama we wunǝ aɓwana-mǝgule mò ka, wu malaká ɓanggi Yahweh Ɓakuli peatu ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Aɓa mǝno anggo ka záng andǝ mǝssa mala bálì ka à kiɗikina, acemǝnana bálì ka ɓǝlǝna sǝ záng ngga nda rǝ sak pwasǝe. ");
INSERT INTO mbu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Sǝama mǝssa alkama andǝ mutsǝkǝm ngga à kiɗiki ɗàng, acemǝnana à yi ɓǝl nǝnzǝ́mò.) ");
INSERT INTO mbu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa nying palta mala Firona Murǝm, purî nggea-là sǝ kya loasǝ abui aban Yahweh; sàkkya mala mgbarangce andǝ kpa mala talimbulo, andǝ nya mala mbulo a nzali ka à came. ");
INSERT INTO mbu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Lang Firona Murǝm sǝni sàkkya mala mgbarangce, andǝ kpa mala talimbulo, andǝ nya mala mbulo camǝna ka, nyare pàk cauɓikea ɗǝm. Yi andǝ aɓwana-mǝgule male candǝmúrià. ");
INSERT INTO mbu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Anggo sǝ Firona tǝr ɓabumi, ɓinǝ nying amǝ Isǝrayila ɓǝà o, kǝla mǝnana Yahweh bangŋi nǝ kún Musa ka. ");
INSERT INTO mbu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Pǝlǝa Yahweh ne Musa ama, <<Nyare aban Firona Murǝm. Ən tsǝ́ngŋǝ̀nà murcandǝa a ɓabumi andǝ ɓabum aɓwana-mǝgule male, ace mǝnana mǝ lǝmdǝ agir'ndali mem aɓalǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Mǝ nǝ pàk mǝno yì gìr ka ace mǝnana ɓǝ̀ wu banggi amuna wun andǝ amǝ'kà wun, ulang ɓangginǝban mǝnana ǝn ɓangginǝ amǝ Masar, andǝ agir-lǝmdǝa mǝnana ǝn pea, ace mǝnana ɓǝ̀ wu sǝlǝ ama mǝ nda Yahweh ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Nda Musa andǝ Haruna wari aban Firona Murǝm à kya banggi wi ama, <<Yahweh Ɓakuli mala amǝ Ibǝru kǝ na ama, <Nǝ̀ sau lang sǝ awu nǝ ginǝ nongsǝmuro abanam? Nying aɓwana mem ɓǝà o, ace mǝnana ɓǝà kya peri abanam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sǝ ɓǝ̀ a ɓinǝ nying aɓwana mem ɓǝà u ka, loasǝ mǝsǝo, lí ka mǝ ndo mǝ nǝ sulǝ doshi amur nzali ma'wun. ");
INSERT INTO mbu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","À nǝ̀ gìr múr nzali ma'wun, yàle pà wu nǝ̀ gandǝ sǝn nzǝm nzali ɗang ace ɓiki lakkì malea. À nǝ̀ lì gìr mǝnana kat talimbulo nyî kiɗiki raka, sǝ à nǝ̀ kpǝri koya nggun mǝnana ueo kǝ gulo aɓa nzali ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","À nǝ̀ yia lùmsǝ palta mô, andǝ aɓala mala amǝtúró mô, andǝ mala aɓwana mala nzali Masar kat. Ɓike malea nǝ̀ kàrmúr gir kat, mǝnana atár wun andǝ aká wun ɓara-ɓara sǝni, twal a do malea a nzali mǝnia yi puro a yalung ngga.> >> Sǝ Musa wulio, upi ɓadǝm Firona. ");
INSERT INTO mbu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Aɓwana-mǝgule mala Firona yiu à yi banggi wi ama, <<Nǝ̀ sau lang sǝ ɓwabura man nǝ̀ nggǝ pá sǝm tanni anggo? Nying aɓwana mǝno ɓǝà o, ace mǝnana ɓǝà kya peri aban Yahweh Ɓakuli malea! A sǝlǝ mbak ama, Masar kiɗikina?>> ");
INSERT INTO mbu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Nda à nyesǝ Musa andǝ Haruna a ɓadǝm Firona, sǝ yi banggia wia ama, <<Wu kyane, wu kya peri aban Yahweh Ɓakuli ma'wun! Sǝ nggeari kǎ, ayana ɗe aɓalǝ wun mǝnana à nǝ̀ u ka?>> ");
INSERT INTO mbu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa pǝlǝi wi ama, <<Sǝm kat sǝ sǝm nǝ̀ o, alo-ɓwa andǝ akapana, amuna-burana ma'sǝm, andǝ amuna-mamǝna ma'sǝm, anzur ma'sǝm, andǝ ambul-pǝndǝa ma'sǝm, andǝ andá ma'sǝm. Dumǝna púp sǝm kat sǝm nǝ̀ nggá pàk lamsan ace gusǝlǝ Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pǝlǝa Firona nea wia ama, <<She ɓǝ̀ Yahweh nǝ̀ bwala wun kàm aɓa kàne ma'wun mǝna ka, sǝama pà mǝ nǝ nying wun, wun nǝ̀ umnǝ amamǝna andǝ amuna ma'wun ɗàng! Acemǝnana ǝn sǝni ka, wu nda rǝ pak kutan mala mgbicau. ");
INSERT INTO mbu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Pà mǝ nǝ eara wun anggo ɗàng. Kǝ aburana na à nǝ̀ ká peri aban Yahweh ka, acemǝnana mǝno nda gìr mǝnana wu zǝmba cè ka.>> Firona pǝlǝa pǝr Musa andǝ Haruna ɓǝà nying ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Pǝlǝa Yahweh ne Musa ama, <<Sárǝ́ buo amur nzali Masar ɓǝ̀ doshi sulǝo amurí ɓǝ̀ lì koya girpwala andǝ gir mǝnana kat talimbulo nyî ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nda Musa lǝmdǝ gara male amur nzali Masar, sǝ Yahweh loasǝ gung nǝ takuli yi ɓua amur nzali. Pwari andǝ du kat gung na ban ɓua. Lang bân nǝ kwar ka, gung takuli yina nǝ adoshi. ");
INSERT INTO mbu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Doshi yiu amur nzali Masar kat, yi sulǝo aki ɓá nzali Masar kat. Sulǝo mala doshi nggǝm-nggǝm mǝno ka, à malaká sǝn ulangnì ɗàng, sǝ à pà nǝ̀ nyare à nǝ̀ sǝn ulangnì ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","À gìr nzǝm-nzali kat, gandǝa nzali pǝlǝ mǝpǝndǝe. À lì girpwala mǝnana a bondo ka kat, andǝ aɓǝla anggun mǝnana talimbulo kúmsǝia raka. Kǝ mbúgir mǝpwale ue ɗǝm amur anggun andǝ bondo aɓa nzali Masar ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Firona pǝlǝa túrban akaurǝa ɓǝà tunǝ Musa andǝ Haruna sǝ na ama, <<Ən pángŋǝ́nì Yahweh Ɓakuli ma'wun cauɓikea, sǝ ǝn pángŋǝ̀nà wun cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ado ka, wu twàlâm-ban cauɓikea mem ɗǝm, sǝ wu zǝmbî Yahweh Ɓakuli ma'wun ɓǝ̀ twàlâm-ban mǝnia yì lú ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa pǝlǝa nying ban Firona Murǝm sǝ kya pakhiwi aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Pǝlǝa Yahweh ɓua gung mǝcandǝe tò nǝ njar-nzali, pwan doshi umnǝi a Nggeamùr Nzuno. Kǝ doshi mwashat ueo ɗǝm a koya ban aɓa nzali Masar ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Sǝ Yahweh ka tsǝk murǝm múrí candǝ ɗǝm, ginǝ nying amǝ Isǝrayila ɓǝà o. ");
INSERT INTO mbu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yahweh ne Musa ama, <<Loasǝ buo a kùli ace mǝnana pǝndǝa mǝcikcikì, mǝnana à nǝ̀ gandǝ ue nǝ bu ka, ɓǝ̀ gìr mur nzali Masar.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa pǝlǝa loasǝ bui a kùli sǝ pǝndǝa mǝcikcikì kara ak nzali Masar kat nongŋo tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kǝ ɓwa gandǝ sǝn ɓì atà amǝ Masar ɗàng, sǝ kǝ ɓwa gandǝ nying ɓala male aɓalǝ amǝno yì apwari ka ɗàng. Sǝama a bu bando mala amǝ Isǝrayila ka, tǎlaban nakam. ");
INSERT INTO mbu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pǝlǝa Firona Murǝm tunǝ Musa ne wi ama, <<Wu o, wu kya peri aban Yahweh; amamǝna andǝ amuna ma'wun ɓǝà kyane. Sǝama anzur ma'wun, andǝ ambul-pǝndǝa ma'wun, andǝ andá ma'wun ngga ɓǝà ueo kani.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Sǝ Musa ka nyesǝi wi ama, <<Dumǝna púp awu nǝ nying sǝm ɓǝ̀ sǝm umnǝ agirkusǝu andǝ apagir mala pisǝe kǝring a bù sǝm, mǝnana sǝm nǝ̀ nggá pà aban Yahweh Ɓakuli ma'sǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Agirkusǝu ma'sǝm nǝ̀ o atà sǝm. Pa sǝm nǝ̀ nying kǝ nkaulakusǝ girkusǝu anzǝ́mò ɗàng. Aɓalǝia sǝ sǝm nǝ̀ twal amǝnana sǝm nǝ̀ nggá pana gir'nkila nǝia aban Yahweh ka. Sǝ pà sǝm nǝ̀ súrǝ̀ ya girkusǝu na sǝm nǝ̀ pana gir'nkila nǝi ka ɗàng, she ɓǝ̀ sǝm bwalǝna ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yahweh nyare candǝ múr Firona, ginǝ nying amǝ Isǝrayila ɓǝà o. ");
INSERT INTO mbu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firona ne Musa ama, <<Puro nying ɓadǝmbam! Cè a nyare a yiu ama awu nǝ sǝnam ɗǝm ɗàng! Pwari mǝnana a sǝn ɓamǝsǝam ɗǝm ngga, awu nǝ wú!>> ");
INSERT INTO mbu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa ne wi ama, <<Cau mǝnana a ne ka, nda jik, pà mǝ nǝ sǝn ɓamǝsǝo ɗǝm ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Pǝlǝa Yahweh ne Musa ama, <<Mǝ ndanǝ ɓe gìr'mur'mwana mwashat mana mǝ nǝ tasǝte amur Firona murǝm Masar andǝ aɓwana male ka. Anzǝm mǝno ka, nǝ̀ nying wun ɓǝ̀ wu o. Yàle, nǝ̀ pǝ̀r wun nǝ pǝra kat ɓǝ̀ wu nying ban mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ado ka, bangcau nǝ amǝ Isǝrayila ama, aburana andǝ amamǝna ɓǝà zǝmbî aɓia mǝ'murkala ɓǝà pea wia agir bolo-njengǝlan andǝ bolo-azǝrfa.>> ");
INSERT INTO mbu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yahweh tsǝa amǝ Isǝrayila kum earmúrú aban amǝ Masar. Sǝ Musa ka, ɓwa na amǝ Masar andǝ aɓwana-mǝgule mala Firona twali nǝ gulo kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa wari aban Firona Murǝm sǝ banggi wi ama, <<Mǝnia ka nda cau mǝnana Yahweh kǝ nô ka, <Nǝ ɓadu yalung ngga, mǝ nǝ gya aɓa nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Koya muna-dǝmba aɓa nzali Masar ka nǝ̀ wú, twal amur muna-dǝmba mala Firona Murǝm, kya puro aban muna-dǝmba mala guro ɓwama mana kǝ go mǝsǝsa ka, andǝ muna-dǝmba mala agirkusǝu-ɓala kat. ");
INSERT INTO mbu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","À nǝ̀ ok ɓua mǝcandǝe aɓa Masar kat, yàle ulang ɓuanî ka à malaká oè àkǝ pwari ɗàng, sǝ à pà nǝ̀ ɓǝsǝlǝ ok ulangnì ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Sǝ a buì mala amǝ Isǝrayila ka, ban nǝ pwal ɗǝong, ko nva pà nǝ̀ gim ɓwa ko girkusǝu ɗang. Sǝ anggo sǝ wun nǝ̀ sǝlǝ ama Mim Yahweh ka, Ən gau nre ka amǝ Masar andǝ amǝ Isǝrayila.> ");
INSERT INTO mbu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Sǝ aɓwana-mǝgule mò mǝnia kat ka, à nǝ̀ ɓangŋa à nǝ̀ yiu abanam, à nǝ̀ yia ɓunno a nzali a ɓadǝmbam. À nǝ̀ zǝmbam ama, <Ida, wu o, we wunǝ aɓwana mǝnana kat à kǝ̀ kpato ka!> Sǝ anzǝm mǝno ka mǝ nǝ o.>> Pǝlǝa Musa puro o nǝ bumlulla, nying Firona. ");
INSERT INTO mbu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Pǝlǝa Yahweh ne Musa ama, <<Murǝm Masar pà nǝ̀ kwakikiri arǝò ɗàng. Sǝ aɓa mǝno anggo ka, mǝ nǝ pàkki aɓea agir'ndali amǝgulke kàm aɓa nzali Masar.>> ");
INSERT INTO mbu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa andǝ Haruna pàkki amǝno yì agir'ndali ka a ɓadǝm Firona Murǝm. Sǝ Yahweh ka tsǝk Firona múrí candǝe, eare nying amǝ Isǝrayila ɓǝà puro ɓǝà nying nzali male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mǝnana amǝ Isǝrayila na aɓa nzali Masar più ka, Yahweh pè Musa andǝ Haruna amǝnia yì akwarkiru ka, ama: ");
INSERT INTO mbu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","<<Zongŋo mǝnia aban wun ngga nda nǝ̀ duk zongŋo mǝdǝmbe mala pǝlǝa ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Banggi ɓinala amǝ Isǝrayila kat, ama, <A lumia nongŋo mala zongŋo mǝnia ka, dumǝna púp koya mǝtala-ɓala ka nǝ̀ twal muna-nzur ko muna-mbul ace amǝ'ɓala male, mwashat ace koya ɓala. ");
INSERT INTO mbu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sǝ ɓǝ̀ ɓala ka kyapî muna-nzur ko muna-mbul mwashat ka, yì andǝ ɓi mǝ'murkala ka ɓǝà twal mana nǝ̀ karǝ amǝ'ɓala malea ka; ɓǝà gauwi aɓa kpata làkkì mala aɓwana mǝnana à nǝ̀ lì ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Muna-nzur ko muna-mbul mǝnana wun nǝ̀ twal ka, ɓǝ̀ pàk jamne mǝnana mbule mwashat ka, mǝnana kǝ npenye pà arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Koya ɓala ka à nǝ̀ ɗenyinǝ muna-mbul ko muna-nzur mǝnana à twal ka. Nǝ́ pwarikpǝra mala lum-nong-inea pwari mala zongŋo mǝnia ka, koya ɓala mala ɓinala amǝ Isǝrayila kat ka, à nǝ̀ pwanmyal agirkusǝu mǝno. ");
INSERT INTO mbu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","À nǝ̀ ɗārǝ́ nkilia sǝ à nǝ̀ hasǝkia arǝ anggun-kunaɓala, arǝ ankanggari andǝ murkuli mala kunɓala mana à nǝ̀ shak anyam agirkusǝu mǝno kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Nǝ mǝno yì bù dù ka, à nǝ̀ twan nyame amur bǝsa, sǝ à nǝ̀ shè nǝ mbúgir mǝ'lùlle andǝ bǝredi mana à tsǝki wi yis raka. ");
INSERT INTO mbu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Wu kǝa shak nyame andapwale ko mǝnana à lambi nǝ mùr ka ɗàng. Nyame ka wu twani nǝ twano kat sǝ wu shè. Wu twani andǝa ɓamúrí, andǝ akusǝi, andǝ alungŋè. ");
INSERT INTO mbu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Wu kǝa nying kǝ cili nyame ɓǝ̀ bankwari ɗàng. Ɓǝ̀ cili ue ka wu pisǝì. ");
INSERT INTO mbu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Lang wun nǝ̀ shak nyame ka, wun nǝ̀ gilǝ rǝ wun ace lo bǝri, nǝ ankura a kusǝ wun, andǝ agara ma'wun a bù wun. Wu lì girline akaurǝa, acemǝnana mǝnia ka Lamsan Yàlîmurû na ace gusǝlǝ lullǝam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","<< <Aɓa kǝ bù dù mǝno ka, mǝ nǝ gya aɓa nzali Masar, mǝ nǝ wal-lú ka amuna-dǝmba mala ɓwapǝndǝa andǝ agirkusǝu aɓa nzali Masar. Sǝ mǝ nǝ yinǝ aɓashi mem amur aɓakuli mǝnana amǝ Masar kǝ peri a bania ka. Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Nkila mǝnana arǝ anggun-kunaɓala ma'wun ngga nǝ̀ duk gìr'lǝmdǝa mǝnana tàr ɓala mana wu duk kam ngga. Sǝ ɓǝ̀ ǝn sǝn nkila ka, mǝ nǝ yàllî mur wun, pa mǝ nǝ pàkka wun mǝɓane ɗàng. Mǝnia yì gìr wal-lú ka pà nǝ̀ je wun ɗàng, yi mana mǝ nda rǝ wal nzali Masar nǝ gìr'mur'mwana ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","<< <Mǝnia yì pwari ka nǝ̀ dupa wun pwari mala kasǝɓalǝu aban wun arǝ gir mǝnana Yahweh pàk ka, sǝ wun nǝ̀ nggǝ ɗenyi nǝi kǝla lamsan a baní. Dumǝna nggurcau tàtǝ́k, ama arǝ anza ma'wun kat ka, wun nǝ̀ nggǝ pagulo arǝ pwari mǝnia ka nǝ pak lamsan male. ");
INSERT INTO mbu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","<< <Wun nǝ̀ twal anongŋo tongno-nong-ɓari wun nǝ̀ nggǝ lì bǝredi mǝnana à pè nǝ muku yis arǝì raka. A pwari mǝdǝmbe mala Lamsan Pakkiɗire ka, wun nǝ̀ pusǝ yis kat arǝ aɓala ma'wun. Aɓalǝ anonggio tongno-nong-ɓari mǝno ka, ɓǝ̀ kǝ ɓwa lì bǝredi mǝnana à pè nǝ muku yis ka, à pà nǝ̀ ɓal ɓwe aɓalǝ aɓwana mem Isǝrayila ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A pwari mǝdǝmbe andǝ tongno-nong-ɓarià pwari ka, wun nǝ̀ yia ramba a banɓwáná ace peri abanam, Mim Yahweh. Aɓalǝ apwari mǝno ɓari ka, pà wun nǝ̀ pàk kǝ túró ɗàng, she kǝ túró lam girlina mana wun nǝ̀ lì ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","<< <Wu pàk Lamsan mala Bǝredi mǝnana Yis pa arǝì raka, koya pǝlǝa, ace ɗenyinǝ pwari mǝnia ǝn pusǝ atau ma'wun wu purî ɓá nzali Masar nǝi ka. Acemani ka, wun nǝ̀ pagulo arǝ pwari mǝnia, arǝ anza ma'wun kat, kǝla nggurcau tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Aɓa zongŋo mǝdǝmbe ka wun nǝ̀ lì bǝredi mǝnana yis pà arǝì raka, tite a pwarikpǝra mala lum-nong-inea pwari aban ká pwarikpǝra mala lumi-ɓari-nong-mwashatia pwari. ");
INSERT INTO mbu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Aɓalǝ anonggio mǝno tongno-nong-ɓari ka, ɓǝà kǝà kum yis ko ɓè kǝgìr kǝla yis arǝ aɓala ma'wun ɗàng ko bǝti. Sǝ ɓwa mǝnana kat lì ɓè kǝgìr nǝ yis aɓalǝi ka, à nǝ̀ kasǝì, ɓǝ̀ ɗwanyi pa aɓa ɓinado mala aɓwana mala Isǝrayila, ko ɓǝ̀ ɓwe ka à ɓǝlì ɓwa Isǝrayila na, ko yì ka ɓwa-kúnɗàngna na ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Aɓalǝ anonggio mǝno tongno-nong-ɓari ka, pà wun nǝ̀ lì kǝgìr nǝ yis arǝì ɗàng. A rǝ aban mǝnana kat wu duk kam ngga, bǝredi mǝnana yis pà arǝì raka nda wun nǝ̀ lì ka.> >> ");
INSERT INTO mbu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa pǝlǝa tunǝ aɓwana-mǝgule mala amǝ Isǝrayila kat sǝ banggia wia ama, <<Koyan atà wun ngga ɓǝ̀ kyane ɓǝ̀ kya tàr muna-nzur ko muna-mbul ace amǝɓala male, sǝ ɓǝ̀ pwan-myali kǝla muna-nzur mala Yàlîmurû. ");
INSERT INTO mbu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Wu ak nkile aɓa tasau. Wu twal esǝe-kùtùrù, wu oasǝ kúni aɓa nkile sǝ wu hasǝki arǝ anggun-kunaɓala, arǝ ankanggari andǝ murkuli mala kunɓala ma'wun. Anzǝm mǝno ka, koyan ngga ɓǝ̀ do a ɓala ɓǝ̀ kǝa pùro a nza ɗàng, she ɓǝ̀ ban kwarna ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Nǝ́ du mǝno ka, Yahweh nǝ̀ ya kúti aɓa Masar, sǝ nǝ̀ wal-lú amǝ'Masar. Lang Yahweh sǝn nkila mǝnana wu hasǝi arǝ ankanggari andǝ murkuli mala anggun-kunaɓala ka, nǝ̀ yàlî mur ɓala mǝno. Pà nǝ̀ earî Mǝturonjar mala Lú ɓǝ̀ kùtí arǝ aɓala ma'wun ɓǝ̀ wal-lú wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","<<Amǝnia yì akwarkiru ka, wun wunǝ amuna ma'wun, wun nǝ̀ kpatea bà. ");
INSERT INTO mbu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lang wu kutina a nzali mǝnana Yahweh pa wun cau ace ama nǝ̀ pà wun ngga, wun nǝ̀ lidǝmba nǝ pak mǝnia yì nàtà ka, ɓǝ̀ duk pakkiɗire mala Yàlîmurû koya pǝlǝa. ");
INSERT INTO mbu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Lang amuna ma'wun ɗì wun ama, <Mana nda ɓá mǝnia yì nàtà ka?> ");
INSERT INTO mbu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Wun nǝ̀ earia wia ama, <Mǝnia nda pà gir'nkila mala Yàlîmurû aban Yahweh, acemǝnana Yahweh yàlî múr aɓala mala amǝ Isǝrayila a Masar, lang wal-lú amuna-dǝmba mala amǝ Masar ka, sǝama sǝm ngga je sǝm arǝ aɓala ma'sǝm ɗàng.> >> Lang Musa malna nacau ka, amǝ Isǝrayila kat ɓunno amur ankūnǝia a nzali, à peri aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Sǝ amǝ Isǝrayila wario à kya pak kǝla mǝnana Yahweh tsǝk Musa andǝ Haruna banggia wia ama ɓǝà pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nǝ ɓadu gum, Yahweh twalta amuna-dǝmba mala nzali Masar kàng. Twal a ban muna-dǝmba mala Firona Murǝm, mǝnana nda nǝ̀ aki tárrí buno-murǝm ngga, kya bwal ban muna-dǝmba mala koya pursǝna mǝnana nda a ndàkurban ngga, andǝ amuna-dǝmba mala agirkusǝu kat ka, à wal-luia. ");
INSERT INTO mbu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","A mǝno yì dù ka, Firona Murǝm andǝ amǝtúró male, andǝ acilia amǝ Masar ka, mǝsǝia sak kat. Kara ɓua mǝcandǝe twal ɓá Masar kat, acemǝnana kǝ ɓala pà kàm mǝnana ɓwa wù kàm raka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","A kǝ mǝno yì bu dù ka, Firona Murǝm túrban atà Musa andǝ Haruna ɓǝà yiu, sǝ nea wia ama, <<Wu lo! Wu purî ɓalǝ aɓwana mem, wun wunǝ amǝ Isǝrayila! Wu kyane, wu kya peri aban Yahweh kǝla mǝnana wu bang ngga! ");
INSERT INTO mbu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Wu twal anzur, andǝ ambul-pǝndǝa, andǝ andá ma'wun, kǝla mǝnana wu na ka, wu kyane! Sǝ wu tsǝkam bù gbal!>> ");
INSERT INTO mbu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Amǝ Masar camarǝ pîtà amǝ Isǝrayila ama ɓǝà fà rǝia ɓǝà nying nzali malea. À banggia wia ama, <<Ɓǝ̀ wu u raka, sǝm ndo sǝm nǝ̀ wuki kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Nda amǝ Isǝrayila pwan atasau malea mǝnana à kǝ karki dyar bǝredi aɓalǝia ka, andǝ dyar bǝredi mǝnana à malaká tsǝki wi yis raka, à kària aɓalǝ alagir sǝ à gyarkia arǝ ankpamtaria. ");
INSERT INTO mbu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Yià amǝ Isǝrayila ka à angŋa dǝmba à pàngŋǝ̀nà gìr mǝnana Musa banggia wia ama ɓǝà pàk ka. À warina aban aɓia mǝ'murkala mǝnana amǝ Masar na ka, sǝ à zǝmǝnia wia agir-nggūrǝu andǝ agir bolo-njengǝlan andǝ azǝrfa. ");
INSERT INTO mbu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yahweh tsǝa amǝ Isǝrayila kum earmúrú aban amǝ Masar sǝ à pea wia agir mǝnana kat à zǝm ngga. Anggo sǝ amǝ Isǝrayila pwan gǝna mala amǝ Masar. ");
INSERT INTO mbu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Amǝ Isǝrayila lo gya a nggea-là Rameses aban ká nggea-là Sukkot nǝ kusǝia. Làkkì malea ka aburana á-gbǝman-tongno-nong-mwashat na 600,000, sǝ amamǝna andǝ amuna ka à ɓallia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nggea ɓwabundǝa mǝ'làkke mala akún ɗàngɗáng, andǝ anzur, andǝ ambul-pǝndǝa, andǝ andá, o ateà gbal. ");
INSERT INTO mbu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Amǝ Isǝrayila lurǝ agbatali dyar bǝredi mǝnana yis pà arǝì raka, mǝnana à pùr nǝi a buia a Masar ka. À lurǝ bǝredi anggo yis pà rǝì ɗàng acemǝnana nǝ mire sǝ à loasǝtea à puro à nying Masar, à kum dǝmbu mala pàk kǝ girlina ɗang she kǝ dyar bǝredi mǝno yis pà arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Làkkì mala apǝlǝa mǝnana amǝ Isǝrayila pǎ aɓa nzali Masar ka, apǝlǝa gbǝman-ine nǝ lumi-tàrú na 430. ");
INSERT INTO mbu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Akǝ̀ dù mǝnana apǝlǝa gbǝman-ine nǝ lumi-tàrú mala do malea a Masar lùmsǝ nǝi ka, atau mala aɓwana mala Yahweh kat nying Masar. ");
INSERT INTO mbu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Aɓa dù mǝno ka, Yahweh tsǝk mǝsǝi amur aɓwana male ace pusǝia ɓǝà purî nzali Masar. Acemani ka, mǝnia yì dù ka, nǝ̀ duk dù mana amǝ Isǝrayila kat nǝ̀ do andǝ amǝsǝia ka, ace gusǝlǝ Yahweh, sǝ à nǝ̀ ɗenyi nǝi koya pǝlǝa arǝ anza malea kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yahweh pè Musa andǝ Haruna amǝnia yì anzongcau ace lamsan mala Yàlîmurû ka, ama: Kǝ amǝ Isǝrayila nǝmurǝia, nda à nǝ̀ lì girlina Yàlîmurû ka. Ɓwa-kúnɗàngna pa nǝ̀ lì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Aguro ma'wun mǝnana wu kúria nǝ boalo ka, à nǝ̀ gandǝ li ɓǝà kasǝnia wia ɓatea ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɓwa mǝnana bǝri na, ko à twali a túró sǝ yiua do bǝti aɓalǝ wun ngga pà nǝ̀ lì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Girlina Yàlîmurû ka à nǝ̀ lì kat a ɓala mǝnana à lambi kàm ngga; pà wun nǝ̀ twal kǝ bare nyame wun nǝ̀ kánǝí a nza ɗàng. Pà wun nǝ̀ ɓun kǝ mú mala muna-nzur ko muna-mbul mǝnana à pwan-myali ace girlina Yàlîmurû ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isǝrayila kat a ɓinalea ka dumǝna púp à nǝ̀ pàk lamsan mala Yàlîmurû. ");
INSERT INTO mbu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ɓǝ̀ ɓwa ka ɓwa Isǝrayila na ɗang, sǝ ndanǝ do aɓalǝ wun, sǝ kǝ earce ama nǝ̀ pàk lamsan mala Yàlîmurû atà wun ace gusǝlǝ Yahweh ka, dumǝna púp koya ɓwabura andǝ muna-ɓwabura a ɓala male ka, à nǝ̀ kasǝia wia ɓatea; sǝ ɓǝ̀ yiu ɓǝ̀ gbàshì ban aɓwana ace pàk lamsan mala Yàlîmurû; yì ka, à nǝ̀ twali ama ɓwa mala nzali Isǝrayila na a ɓǝlban. Sǝama ɓwabura mǝnana à kasǝî wi ɓate raka, à pà nǝ̀ eari wi ɓǝ̀ lì girlina Yàlîmurû ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Amǝnia yì anzongcau ka à nda ace aɓwana kat, koɓǝ̀ ɓwa ka à ɓǝli ɓwa Isǝrayila na, ko ɓwa-kúnɗàngna na yiu sǝ yi do aɓalǝ wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Nda amǝ Isǝrayila kat ka, à okiru, à kpata gìr mǝnana Yahweh tsǝkia Musa andǝ Haruna ama ɓǝà pak ka. ");
INSERT INTO mbu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Àkǝ̀ pwari mǝno ka, Yahweh pusǝ amǝ Isǝrayila à nying nzali Masar, koya tàu ka a nggǝsan malea a nzǝmarǝia. ");
INSERT INTO mbu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","<<Koya muna-dǝmba muna-ɓwabura ka, wu tàrì ɓǝ̀ duk mem. Muna-ɓwabura mǝnana tita puro a bum ngge, ko jamna girkusǝu mǝnana tita puro a bum ngge, aɓalǝ amǝ Isǝrayila ka, memma.>> ");
INSERT INTO mbu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa banggi ɓwapǝndǝa ama, <<Wu ɗenyinǝ pwari mǝnia ka; yì pwari mǝnana aɓalǝi sǝ wu purî Masar, yì nzali mǝnana à dumsǝ wun a guro kàm ngga. Mǝnia ka nda pwari mǝnana Yahweh pusǝ wun nǝ rǝcandǝa male mǝgule wu purî ban mǝno ka. A pwari mǝnia ka wu kǝa lì kǝ girlina mǝnana à pè nǝ yis arǝì ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","A pwari mǝnia yalung, nǝ kún ɓǝla mala mǝssa, aɓa zongŋo Abip ka, à panzǝna wun, wun ndya wu kǝ purî Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yahweh pàcau nǝ kána aban aká wun ama nǝ̀ pà wun nzali mala amǝ'Kan'ana, andǝ amǝ'Hitti, andǝ amǝ'Amor, andǝ amǝ'Hivi, andǝ amǝ'Jebus, ɓǝ̀ duk nzali ma'wun. Ɓǝ̀ Yahweh yina nǝ wun aɓa mǝno yì nzali, mǝnana kiura andǝ mur'nyi kǝ ɓang kàm ngga, dumǝna púp wun nǝ̀ pàk lamsan mala mǝnia yì nàtà ka, aɓa zongŋo mǝnia ka, a koya pǝlǝa. ");
INSERT INTO mbu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Wun nǝ̀ twal anongŋo tongno-nong-ɓari wun nǝ̀ li girlina mǝnana yis pà arǝì raka, sǝ a tongno-nong ɓaria pwari ka, wun nǝ̀ pàk lamsan ace gusǝlǝ Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Aɓalǝ anonggio tongno-nong-ɓari mǝno ka, pà wun nǝ̀ lì kǝ bǝredi mǝnana à pè nǝ yis arǝì ka ɗàng. Yàle girlina yis ko ɓekǝ yis ka ɓǝà kǝa kumi aɓa nzali ma'wun aɓalǝ anonggio mǝno ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","<<Aɓalǝ anongŋo mǝno ka wun nǝ̀ bǝ́lì amuna ma'wun ama, wu kǝ pak agir mǝnia ka ace gìr mǝnana Yahweh pè ace sǝm, mǝnana sǝm nda rǝ purì ɓá Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mǝnia yì lamsan ngga nǝ̀ dupa wun kǝla gìr'lǝmdǝa mǝnana wun nǝ̀ kùrì a garabu wun, ko a kúndǝm wun ace kasǝɓalǝ wun ama Yahweh pusǝ aká wun à purî Masar nǝ rǝcandǝa male mǝgule. Nǝ̀ kasǝɓalǝ wun ɗǝm ace mǝnana ɓǝ̀ kanigir mala Yahweh ɓǝ̀ ueo a kún wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Pakkiɗire mala mǝnia yì lamsan ngga, wun nǝ̀ nggǝ pê ɓǝ̀ pwari male kārǝ́ ka, a koya pǝlǝa. ");
INSERT INTO mbu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","<<Anzǝm mǝnana Yahweh yina nǝ wun, wu kutina aɓa nzali mala amǝ'Kan'ana, kǝla mǝnana kánba wun, wunǝ aká wun, sǝ pana wun nǝi ka, ");
INSERT INTO mbu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","koya muna-dǝmba muna-ɓwabura mǝnana tita puro a bum ngge ka, wun nǝ̀ tàrì ɗàng ɓǝ̀ duk mala Yahweh. Amuna-dǝmba mala agirkusǝu ma'wun mǝnana kat ajamne na ka, à nǝ̀ duk amala Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sǝama koya jamna mǝdambǝriso mǝnana nda tita puro a bum ngge ka, awu nǝ akmúrí a bu Yahweh ɓǝ̀ nyare ɓǝ̀ duk mô nǝ pâ muna-nzur a kunì. Ɓǝ̀ a pà wu nǝ akmúrí ɓǝ̀ nyare ɓǝ̀ duk mô raka, dumǝna púp awu nǝ ɓùn myali. Ɗǝm ngga dumǝna púp atà amuna mô, koya muna-ɓwabura mǝnana muna-dǝmba na ka, awu nǝ akmúrí a bu Yahweh ɓǝ̀ nyare ɓǝ̀ duk mô nǝ pǎ muna-nzur a kunì. ");
INSERT INTO mbu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","A dǝmba ka, ɓǝ̀ kǝ muna mô ɗio ama, <Mana nda ɓá pàkki amǝnia yì agir ka?> Awu nǝ eari wi ama, <Yahweh pàktúró nǝ rǝcandǝa male mǝgule amsǝ sǝm a do guro a Masar. ");
INSERT INTO mbu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lang Firona murǝm Masar mgbikiru, ɓinǝe ama pà nǝ̀ nying sǝm ɓǝ̀ sǝm u raka, Yahweh wal-lú koya muna-ɓwabura mǝnana muna-dǝmba na, andǝ koya jamna girkusǝu mǝnana muna-dǝmba na ka a Masar. Nda gìr mǝnana tsǝa sǝ sǝm nggǝ pà gir'nkila nǝ girkusǝu jamne mǝnana à tita ɓǝlea ka aban Yahweh, sǝ koya muna-ɓwabura ma'sǝm mǝnana muna-dǝmba na ka, sǝm nǝ̀ akmúrí a bu Yahweh nǝ pâ muna-nzur a kunì, ace mǝnana ɓǝ̀ nyare ɓǝ̀ duk ma'sǝm ngga.> >> ");
INSERT INTO mbu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Pǝlǝa Musa lidǝmba nǝ banggi aɓwana cau ama, <<Mǝnia yì nàtà ka nǝ̀ dupa wun kǝla gìr'lǝmdǝa mǝnana wun nǝ̀ kùrì a garabu wun andǝ kúndǝm wun ace kasǝɓalǝ wun ama Yahweh pusǝ wun a Masar nǝ rǝcandǝa male mǝgule ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Lang Firona murǝm Masar nyingŋǝna amǝ Isǝrayila ɓǝà u ka, Ɓakuli pǝlǝ nǝia ɓǝà kǝa kàr nǝ njargula kún nggeamùr mǝnana kútí nǝ ɓá nzali mala amǝ Filisti ka ɗàng, kat andǝ amani ama mǝno ka nda njar mǝnana kasǝ tù aban ká a nzali Kan'ana ka. Ɓakuli ɗenyi ama, <<Pà mǝ nǝ earce aɓwana mem nggaɗi ɓabumia ace nyar a Masar, ɓǝ̀ lwa kasǝ a kunia a njar ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","A kún mani ka, Ɓakuli gingnǝia à pǝlǝ a njar mǝnana gumbǝliban nǝ ɓá pǝɗanban kya puro a ban Nggeamùr Nzuno ka. Anggo sǝ amǝ Isǝrayila nying Masar, nǝ gilǝrǝu nǝ agirbura ace lwa. ");
INSERT INTO mbu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Pǝlǝa Musa twal amú lú Yisǝfu a buì, kǝla mǝnana Yisǝfu tsǝk amǝ Isǝrayila à kána ama à nǝ̀ pàk ka. Yisǝfu angŋa dǝmba bangŋǝnia wia ama: <<Mbak-kàngkàng, Ɓakuli ka nǝ̀ yia bwala wun kàm, sǝ wun nǝ̀ twal amuem a bu wun, ɓǝ̀ wun nǝ̀ purî nzali mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Amǝ Isǝrayila nying Sukkot sǝ à twal gya aban ká, à yi came à tsǝk agumli malea a Etam, a nkanggari pǝɗanban. ");
INSERT INTO mbu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mǝnana à purna aban o ka, Yahweh dupia wia a dǝmba aɓa pǝrɓang mǝnana cam pǝrapǝra ka nǝ pwari, ace lǝmdǝia wia njar, sǝ nǝ dú ka kúti a ɓadǝmbia aɓa lasǝ bǝsa mǝnana cam pǝrapǝra ka ace pea wia tǎlaban. Mǝnia ka tsǝa à nǝ̀ gandǝ gya, ko nǝ pwari ko du aban o. ");
INSERT INTO mbu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mǝnia yì pǝrɓang mǝnana cam pǝrapǝra ka ue kam a ɓadǝmba aɓwana nǝ pwari, sǝ yì lasǝ bǝsa gbal mǝnana cam pǝrapǝra ka ndakam a ɓadǝmbia nǝ du aban gya. ");
INSERT INTO mbu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","<<Banggi ama Isǝrayila ɓǝà pǝlǝ nǝ nzǝmia ɓǝà kya tsǝk agumli malea a ɓadǝm Pi-Hahirot, a nre Migdol andǝ Nggeamùr Nzuno, tù aban Ba'al-Zefon. ");
INSERT INTO mbu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firona nǝ̀ twali ama, <Amǝ Isǝrayila na arǝ gāli aban sokkikunia aɓa nzali, pǝɗanban gumbǝlinia.> ");
INSERT INTO mbu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mǝ ndo mǝ nǝ tsǝì nǝ̀ candǝmúrí, sǝ nǝ̀ lo ɓangŋatà wun, sǝ limurǝm mem amurí andǝ amǝ'lwa male ka nǝ̀ yinǝàm nǝ gulo. Anggo sǝ amǝ Masar nǝ̀ sǝlǝ ama Mǝ nda Yahweh.>> Anggo sǝ à pa. ");
INSERT INTO mbu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Lang à bangŋǝ́nì Firona murǝm Masar ama amǝ Isǝrayila auna à umǝna ka, kara yì andǝ amǝtúró male nggaɗi ɓabumia arǝ amǝ Isǝrayila, sǝ à na ama, <<Mana nda gìr mǝnia sǝm pàk ka, mǝnana sǝm nyìngŋǝ̀nà amǝ Isǝrayila à umǝna, à pà nǝ̀ duk aguro ma'sǝm ɗǝm raka?>> ");
INSERT INTO mbu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Murǝm pǝlǝa tsǝa à yì kur apǝr arǝ waru-pǝr lwa male, sǝ tunǝ amǝ'lwa male ɓǝà do aɓa gilǝrǝu. ");
INSERT INTO mbu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Pwan awaru-pǝr male amǝɓoarne mana làkkì malea ka, nda gbǝman tongno-nong-mwashat (600) ka, atārǝia andǝ acili awaru-pǝr mala Masar kat. Pwania kat andǝ amǝgulo-lwa aɓa koya waru-pǝr, atè. ");
INSERT INTO mbu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Acemǝnana Yahweh tsǝk murǝm Masar múrí candǝ ka, nda lo pyangnǝata amǝ Isǝrayila mǝnana à nyingŋǝna là à nda rǝ o nǝ mǝsǝkang-kangŋa ka. ");
INSERT INTO mbu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Amǝ'lwa mala amǝ Masar, andǝ apǝr, andǝ awaru-pǝr mala Firona andǝ amǝ'koea ka, à ɓangŋatà amǝ Isǝrayila, à kya bwal teà a ban mǝnana à yì came à tsǝk agumli malea kàm a kún Nggeamùr Nzuno, tù aban Pi-Hahirot andǝ Ba'al-Zefon ngga. ");
INSERT INTO mbu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Lang Firona gbàshìnà banià ka, amǝ Isǝrayila loasǝ mǝsǝia, à sǝn Firona andǝ amǝ'lwa male aban yiu amúrià. Ɓangciu pakki amǝ Isǝrayila, sǝ à ɓua, à tunǝ Yahweh ɓǝ̀ amsǝia. ");
INSERT INTO mbu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Pǝlǝa à ne Musa ama, <<Palang sǝ a yinǝ sǝm akani ɓǝ̀ sǝm yi wukio a ɓabondo? Aɓembe pà kàm a Masar mǝnana à nǝ̀ tsǝk lú sǝm kàm ngga re? Sǝn gìr mǝnana ado a pakka sǝm, nǝ pusǝ sǝm aɓa Masar ka! ");
INSERT INTO mbu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Mǝnana sǝm nda kano a Masar più ka, sǝm banggo ama gìr man nǝ̀ yia kum sǝm re? Sǝm no ama wu nying sǝm, ɓǝ̀ sǝm lidǝmba nǝ doguro ma'sǝm a bu amǝ Masar. Nǝ̀ ɓoaribani ɓǝ̀ sǝm duk aguro a bu amǝ Masar amur mǝnana sǝm nǝ̀ wukio a ɓabondo mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Sǝ Musa pǝlǝia wia ama, <<Cè ɓangciu pakka wun ɗàng! Wu cam kàngkàng, wun nǝ̀ sǝn gìr mǝnana Yahweh nǝ̀ pa, nǝ̀ amsǝna wun nǝi yalung ngga. Amǝ Masar mǝnia wu kǝ sǝnia ado ka, pà wun nǝ̀ nyare wun nǝ̀ sǝnia ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yahweh nǝ̀ lwa-lwa ace wun. Acemani ka, wu cam più.>> ");
INSERT INTO mbu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Pǝlǝa Yahweh banggi Musa ama, <<Palang sǝ a kǝ ɓua abanam ama mǝ bwala wun nggàm? Banggi amǝ Isǝrayila ama ɓǝà kya dǝmba. ");
INSERT INTO mbu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Loasǝ gara mò sǝ wu lǝmdǝí amur nggeamùr. Mùr ka nǝ̀ gauwa ace mǝnana amǝ Isǝrayila ɓǝà kútí nǝ ɓá nggeamùr, ɓǝà gya amur nzali-ima. ");
INSERT INTO mbu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mǝ nǝ tsǝk amǝ Masar múrià nǝ̀ candǝe, sǝ à nǝ̀ soa nǝ mire aban ká atà amǝ Isǝrayila. Sǝ mǝ nǝ kumbi ɓamúràm gulo nǝ limurǝm mǝnana mǝ nǝ lì amur Firona, andǝ amǝ'lwa male, andǝ awaru-pǝr male, andǝ amǝ kok awaru-pǝr male ka. ");
INSERT INTO mbu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ɓǝ̀n gandǝna Firona andǝ awaru-pǝr male andǝ amǝ kok awaru-pǝr male ka, mǝ nǝ kumbi ɓamúràm gulo, sǝ acili amǝ Masar kat nǝ̀ sǝlǝ ama Mǝ nda Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mǝturonjar mala Ɓakuli mǝnana akiyidǝmba a ɓadǝmba amǝ'lwa mala amǝ Isǝrayila ka, nyare a nzǝmia; sǝ pǝrɓang mǝnana cam pǝrapǝra ka, loapi ɓadǝmbia sǝ nyare a nzǝmia. ");
INSERT INTO mbu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Yi came a nre ka amǝ'lwa mala amǝ Masar andǝ amǝ'lwa amǝ Isǝrayila. Yì pǝrɓang ngga pè amǝ Isǝrayila tǎlaban, sǝ amǝ Masar ka túrià wia pǝndǝa, mǝnana tsǝa aɓa dù mǝno kat ka, amǝ Masar andǝ amǝ Isǝrayila ka à gandǝ sungŋo à gbàshì banarǝia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Pǝlǝa Musa lǝmdǝ buì amur nggeamùr, kara Yahweh tasǝ gung-takuli mǝcandǝe, mǝnana ɓua dùkkù-dúkkú, ramta nggeamùr nyar nǝ te sǝ gau ɓari aɓalǝu, nying ban-ima a ban mana mùr nong kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kara amǝ Isǝrayila gya aɓa nggeamùr a ban-ima, mùr dupia wia sheran a buia-mǝlì andǝ buia-mǝ'nggare. ");
INSERT INTO mbu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Sǝ amǝ Masar zùppì aban ká ateà aɓa tsùrú mala nggeamùr nǝ apǝr, andǝ awaru-pǝr mala Firona andǝ amǝ koea kat. ");
INSERT INTO mbu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Sǝ lang ban malanǝ̀ ori ka, Yahweh dili múrí aɓa bǝsa andǝ pǝrɓang mana kǝ gya amur amǝ Isǝrayila ka, sǝn amǝ'lwa mala Masar, sǝ túrià wia múrzùrǝkya. ");
INSERT INTO mbu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yahweh tsǝk kusǝ awaru-pǝr malea cam kingging, sǝ mire dupia wia nǝ kwano. Kara amǝ Masar ne arǝarǝia ama, <<Yahweh na ban lwa-lwa ace amǝ Isǝrayila arǝ sǝm! Wu ɓangŋa ɓǝ̀ sǝm ɗeki pyangnǝata amǝ Isǝrayila!>> ");
INSERT INTO mbu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Pǝlǝa Yahweh ne Musa ama, <<Lǝmdǝ buo ɗǝm amur nggeamùr, ace mǝnana ɓǝ̀ mùr nyare ɓǝ̀ gìr amur amǝ Masar andǝ awaru-pǝr malea, andǝ amǝ koea ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nda Musa lǝmdǝ buì amur nggeamùr, sǝ lang ban na rǝ kwaro ka, kara mùr nyare a kusǝì a lime male. Amǝ Masar ɓariki ama à nǝ̀ ɓangŋa à nǝ̀ apî mùr mana kǝ yiua zùppì amúrià ka, sǝ Yahweh ka tsǝa mùr yi pwania umnǝia a tsùrú mala nggeamùr. ");
INSERT INTO mbu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mùr nyar a kusǝi, sǝ gìr múr awaru-pǝr, andǝ amǝ koea, andǝ amǝ'lwa mala Firona kat mana à kǝ zùppì atà amǝ Isǝrayila aɓa nggeamùr ka; ko kǝɓwa aɓalǝia au ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Sǝ amǝ Isǝrayila ka, à gya a nzǝm nzali à kùtí a ɓaɓalǝu mala nggeamùr, mana dupia wia kǝla sheran a buia mǝlì andǝ mǝ'nggare ka. ");
INSERT INTO mbu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A pwari mǝno ka Yahweh amsǝ amǝ Isǝrayila a ɓabù amǝ Masar, sǝ amǝ Isǝrayila sǝn alú ka amǝ Masar aban nonggio a kún nggeamùr. ");
INSERT INTO mbu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Lang amǝ Isǝrayila sǝnǝna nggea rǝcandǝa mǝgule mana Yahweh twalǝnata amǝ Masar nǝi ka, gìrnî pea wia ndali andǝ ɓangciu arǝ Yahweh. Mǝnia yì gìr ka tsǝia à earnǝ Yahweh andǝ guro male yì Musa. ");
INSERT INTO mbu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pǝlǝa Musa andǝ amǝ Isǝrayila tùkî Yahweh mǝnia yì nggyal ka, ama: <<Mǝ nǝ tùkî Yahweh nggyal, acemǝnana linamurǝm, nggea limurǝm mǝgule. Apǝr andǝ amǝ'koea ka, kongsǝnia aɓa nggeamùr. ");
INSERT INTO mbu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yahweh ka nda rǝcandǝa andǝ nggyal mem. Yì nda ɓwa mǝnana amsǝam ngga. Yì nda Ɓakuli mem, mǝ nǝ ɓwangsǝki, Ɓakuli mala tárrám, mǝ nǝ tu-nggyal ace gulo male! ");
INSERT INTO mbu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yahweh ka mǝ'lwa na; Yahweh nda lùllǝì. ");
INSERT INTO mbu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","<<Awaru-lwa andǝ amǝ'lwa mala Firona ka ramnateà aɓa nggeamùr. Akanggǝrang amǝ'sàrǝ̀ban mala amǝ'lwa male ka à kongsǝnia aɓa Nggeamùr Nzuno ");
INSERT INTO mbu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mùr-lìma kongsǝna múrià; à kò a tàmùr kǝla tali. ");
INSERT INTO mbu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","We Yahweh, buo mǝlì ka ndanǝ rǝcandǝa mǝgule. Nǝ buo mǝlì, we Yahweh sǝ a arki ɓimǝbura, a mesǝki mwashat-mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Aɓa gulo mala ɓoarɓwa mò sǝ a makki aɓwana mana à mgbicau arǝò ka. A so bumlulla mò mǝ'earke, pisǝia n'hāun kǝla pǐ mala lusung. ");
INSERT INTO mbu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Aɓa bumlulla mò a loasǝ gung mǝnana tsǝk mùr yi ramgi amurǝarǝia gum-gum ngga; mùr-gùla cam pǝrapǝra kǝla sheran; mùr-lìma shiuri a tàban aɓa nggeamùr, ");
INSERT INTO mbu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","sǝ ɓimǝbura na ama, <Mǝ nǝ pǝrtea, mǝ nǝ nggá kasǝmurià. Mǝ nǝ gau gǝna malea, sǝ mǝ twal gìr mǝnana ǝn earkiyice ka; mǝ nǝ kwetǝ nggeabyau mem, sǝ buam nǝ̀ twaltea.> ");
INSERT INTO mbu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","We Yahweh, bumo lúllô, a tsǝk gung mò ɓua, sǝ amǝ Masar ko kat a mùr; à kò kǝla bolo-dànà a gbǝlwan mùr. ");
INSERT INTO mbu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yana ɓwe kǝla we, We Yahweh, aɓalǝ aɓakuli kat? Yana ɓwe kǝla we mǝnana ndanǝ ɓoarɓwa aɓa fele, andǝ gulo mǝ'kàrmuruî, sǝ kǝ pa ndali aɓa túró ka? ");
INSERT INTO mbu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","A loasǝ buo mǝlì sǝ nzali myal aɓisǝm amǝbura. ");
INSERT INTO mbu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","<<Aɓa earcearǝu mô mǝnana kǝ nggaɗi raka, a gingnǝ aɓwana mô mǝnana a amsǝia ka. Aɓa rǝcandǝa mò, a kàrnǝia aban ká nzali mô mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Anzali ɓanza okce gìr man, sǝ rǝia ɓǝl nǝ ɓangciu. Aɓwana mǝnana à do a nzali Filisti ka, ǝn'ò bwalia. ");
INSERT INTO mbu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Amurǝma mala nzali Edom ngga, à gǝggǝli. Akanggǝrang aburana mala nzali Mowap ka, ɓabumia tù mùr. Amǝ Kan'ana ka yilǝmia o ace ɓangciu; ");
INSERT INTO mbu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ǝn'ò andǝ kàrmúrû sulǝo amuria. À sǝn rǝcandǝa mò, we Yahweh sǝ à cam yak nǝ ɓangciu, sheɓǝ̀ aɓwana mô gingŋǝ́na à yi kutina ka, yì aɓwana mô mǝnana a akmúria à purî do guro ka. ");
INSERT INTO mbu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Awu nǝ yinǝia, sǝ awu nǝ dumsǝia amur nkono mǝnana girkuma mò na ka, yì ban mǝnana we Yahweh, a tárì ɓǝ̀ do nda bando mô ka, yì Tara-mǝfele mǝnana we nǝ nggearǝo a loasǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","We Yahweh a nda murǝm, málá male pà kàm ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Amǝ Isǝrayila gya à kùtí nǝ ɓá nggeamùr amur nzali mǝ'ime. Sǝ lang awaru-pǝr andǝ apǝr mala amǝ Masar andǝ amǝ'koea kùtí aɓa nggeamùr ka, Yahweh nyesǝ mùr nǝ te yi kongsǝ múrià. ");
INSERT INTO mbu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriyam māɓangnǝa, muna-ɓwama mǝ'eam Haruna, twal karata-bu male sǝ puro a dǝmba sǝ amamǝna kat kpate à kǝ wal akarata-bu malea nǝ ta'nggwam. ");
INSERT INTO mbu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam loasǝia wia nggyal ama: <<Wu tùkî Yahweh nggyal ɓwangsǝban, ace limurǝm male mǝgule! Apǝr andǝ amǝ'koea ka, túrnia aɓa nggeamùr.>> ");
INSERT INTO mbu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Amǝ Isǝrayila loapi ban Nggeamùr Nzuno sǝ Musa gingnǝia aban o aɓa Pǝɗanban Shur. À gya nongŋo tàrú aɓa pǝɗanban sǝ ko à kum kǝ mùr ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Pǝlǝa à yì bik ɓè ban gaɓakan à tunǝi ama Mara, sǝ mùr mǝnana a banì ka lúllô à gandǝ nue ɗàng. Nda gìr mǝnana tsǝa sǝ à tunǝi ama Mara ka. ");
INSERT INTO mbu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Aɓwana nggwanî Musa ama, <<Mana ado sǝm nǝ̀ nu?>> ");
INSERT INTO mbu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Nda Musa ɓua aban Yahweh ɓǝ̀ bwalì wi kàm. Yahweh lǝmdǝì wi ɓè gbǝlang nggun, sǝ Musa twali túrí aɓa mùrnî; sǝ mùrnî pǝlǝ mǝɓoarne, à nǝ̀ gandǝ nuî. Akanó a Mara sǝ Yahweh pea aɓwana male aɓea nggurcau andǝ akanìgìr mǝnana à nǝ̀ gingnǝ do malea ka; akanó gbal sǝ mwamia. ");
INSERT INTO mbu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Bang ama, <<Ɓǝ̀ wun nǝ̀ kpata cau mala Yahweh Ɓakuli ma'wun nǝ̀ ɓabum wun kat, sǝ wun nǝ̀ pàk gìr mǝnana nda pepè a sǝne male, sǝ wun nǝ̀ kwakikir wun arǝ anzongcau male, sǝ wun nǝ̀ bwal anggurcau male kat ka, akwánó mǝnana kat ǝn yinǝia amur amǝ Masar ka, pà mǝ nǝ yinǝia amur wun ɗàng, acemǝnana Mim, Yahweh ka, Mǝ nda mǝ'twalban akwánó ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Anzǝm mǝnana à nyìngŋǝ̀nà Mara ka, amǝ Isǝrayila gya à yi bik gaɓakan Elim, ban mǝnana à kum amáɗí-mùr lum-nong-ɓari andǝ anggun nkangga lumi-tongno-nong-ɓari (70) ka; à came à tsǝk agumli malea kàm. ");
INSERT INTO mbu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Amǝ Isǝrayila a ɓinalea kat ka à nying Elim, sǝ à gya à kya puro aɓa pǝɗanban mala Sin, mǝnana nda a nre Elim andǝ Saina ka. À kya bwal banì a lum-nong-tongnoia pwari mala ɓaria zongŋo mana à nyìngŋǝ̀nà nzali Masar nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Akanó aɓa pǝɗanban ngga, amǝ Isǝrayila a ɓinalea kat ka, à nggwanî Musa andǝ Haruna ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","À nea wia ama, <<Ɓǝà bang ama Yahweh walna-lú sǝm aɓa nzali Masar ka ɓǝ́ ɓoarna. Acemǝnana akanó ka, sǝm nǝ̀ gandǝ dumnǝdo, sǝm nǝ̀ shak nyama andǝ acili agirlina kǝla mana sǝm earce ka. Sǝ adyan ngga, wu yinanǝ sǝm aɓa pǝɗanban mǝnia ace wal-lú sǝm a ɓinala sǝm kat nǝ nzala.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yahweh banggi Musa ama, <<Ado ka, mǝ ndo mǝ nǝ soapa wun girlina nǝ kuli kǝla nya mala mbulo. Banggi aɓwana ɓǝà puro koya pwari ka ɓǝà kya ram gìr mǝnana nǝ̀ kārǝia mala pwari mwashat ka. Anggo sǝ mǝ nǝ sǝlǝa ko yia ka à nǝ̀ kpata kwarkiru mem. ");
INSERT INTO mbu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A tongno-nong-mwashatia pwari mala koya limo ka, wun nǝ̀ ram gìr mǝnana wu kǝ ram pwari-pwari ka kusǝ ɓari.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Nda Musa andǝ Haruna banggi amǝ Isǝrayila kat ama, <<A pwarikpǝra mala pwari man yalung ngga, wun nǝ̀ sǝlǝ ama Yahweh na pusǝ wun wu purî ɓá nzali Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Nǝ́ dǝmbari ka wun nǝ̀ sǝn gulo mala Yahweh nǝ̀ pusǝrǝi nǝ tǎlaban. Yì ka ongŋǝna nggwani mǝnana wu kǝ nggwanî wi ka, sǝm nda wu nggwania sǝm ngga ɗàng. Sǝm nda ka yana gbal mǝnana wun nǝ̀ nggwania sǝm ngga?>> ");
INSERT INTO mbu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa banggia wia ɗǝm ama, <<Yahweh nǝ̀ pà wun nyama wun nǝ̀ li nǝ pwarikpǝra ka, ɗǝm ngga nǝ̀ pà wun girlina mǝnana nǝ̀ kārǝ́ wun ngga nǝ dǝmbari, acemǝnana ongŋǝna nggwani ma'wun mǝnana wu nggwanî wi ka. Sǝ sǝm ngga sǝm nda ka yana? Nggwani ma'wun ngga pà arǝ sǝm ɗàng, nda arǝ Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa banggi Haruna ama, <<Banggi amǝ Isǝrayila a ɓinala kat ama, <Wu yiu wu yi came a ɓadǝm Yahweh, acemǝnana ongŋǝna nggwani ma'wun.> >> ");
INSERT INTO mbu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Sǝ lang Haruna naban nacau nǝ ɓinala amǝ Isǝrayila kat ka, à pǝlǝ mǝsǝia nǝban pǝɗanban, kara à sǝn tǎlaban mǝnana kǝ twalmǝsǝu ka, mala Yahweh, puro aɓa pǝrɓang. ");
INSERT INTO mbu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Pǝlǝa Yahweh ne Musa cau ama, ");
INSERT INTO mbu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","<<Ən ongŋǝna nggwani mala amǝ Isǝrayila; ado ka, banggia wia ama, <Koya pwarikpǝra ka, wun nǝ̀ kum nyama wun nǝ̀ she, sǝ koya dǝmbari ka, wun nǝ kum girlina mana nǝ̀ ɗǝmsǝ wun ngga. Anggo sǝ wun nǝ̀ sǝlǝa ama Mǝ nda Yahweh, Ɓakuli ma'wun.> >> ");
INSERT INTO mbu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nǝ́ pwarikpǝra mǝno ka, ankwar mǝ'làkke kǝ̀rkǝ́r yiu à yi sulǝo à lùmsǝ ɓá kàttì mala amǝ Isǝrayila. Sǝ nǝ dǝmbari ka, ɓá kàttì liuwe nǝ ncimna mana kpa ka. ");
INSERT INTO mbu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Anzǝm mana ncimna imǝna ka, kara à sǝn agir kǝla a'imna nggwato-ɓa'nkwaring, mǝnana ɓoarsǝna kǝla talimbulo ka, à yi lumsǝ nzǝm-nzali. ");
INSERT INTO mbu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lang amǝ Isǝrayila nǝ̀ sǝni ka, à ɗiki rǝarǝia ama, <<Mana man?>> Acemǝnana à súrǝ̀ mana nda mǝno yì gìr ka ɗàng. Pǝlǝa Musa nea wia ama, <<Mǝnia ka nda girlina mǝnana Yahweh pa wun ɓǝ̀ wu lì ka. ");
INSERT INTO mbu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mǝnia ka nda nzongcau mala Yahweh aban wun: <Koyan atà wun ngga ɓǝ̀ ram gìr mǝnana nǝ̀ gandǝ lié ka, munakwar-karǝgìr ɓari ace koya ɓwa a ɓala male.> >> ");
INSERT INTO mbu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Amǝ Isǝrayila pàk mǝno ka anggo; aɓea ɓwana pwan kpǝm, sǝ aɓea ka à pwan bǝti. ");
INSERT INTO mbu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Sǝ lang à yi kārǝki ka, aɓwana mǝnana à pwan kpǝm ngga malea woribani ɗàng, sǝ aɓwana mǝnana à pwan bǝti ka malea shingnǝ ɗang. Koyan ngga kum gìr mǝnana kārǝ́ arǝì sǝ nǝ̀ gandǝ li ka. ");
INSERT INTO mbu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa banggia wia ama, <<Kǝ ɓwa ɓǝ̀ kǝa tsǝk cili ɓǝ̀ nongŋo bankwari ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Sǝ aɓea ɓwana ka à mgbikî Musa kiru, à tsǝk cili nongŋo. Lang bankwarna ka, à yi kumi ka sàngŋǝ̀nà mǝsǝ'nggwaso sǝ rǝmbi mǝɓike kǝ puro. Bum Musa lúllô arǝia. ");
INSERT INTO mbu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Koya dǝmbari ka koyan ngga pwan gìr mǝnana nǝ̀ kārǝi ka; sǝ ɓǝ̀ pwari pì ka, gìr mǝnana ueo a nzali ka panzǝa. ");
INSERT INTO mbu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nǝ́ dǝmbari mala tongno-nong-mwashatia pwari ka, à pwan girlina mǝnana à nǝ̀ li aɓa pwari ɓari ka; koya ɓwa ka pwan munakwar-karǝgìr ine. Aɓwana-mǝgule amur ɓinala aɓwana wario à kya banggi Musa cê, ");
INSERT INTO mbu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","sǝ banggia wia ama, <<Mǝnia ka nda cau mǝnana Yahweh na ka: <Lí ka, pwari mala usǝlǝo na, pwari mǝfele mǝnana à tàrì ace pagulo abanam Mim Yahweh ka nda. Acemani ka, gìr mǝnana kat wu earce lurǝè ka, wu lurǝi yalung; gìr mǝnana kat wu earce lambe ka, wu lambi yalung, sǝ wu tsǝk cili girlina mǝnana nǝ̀ kārǝ́ wun lí ka.> >> ");
INSERT INTO mbu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Aɓwana okiru à kpate kǝla mǝnana Musa bang ngga; à tsǝk cili girlina mǝnana ue ka bà ɓè dǝmbari; kiɗiki ɗàng sǝ sak nggwaso ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa na ama, <<Wu lì girlina mǝnia ka yalung, acemǝnana yalung nda pwari Sabbat, pwari usǝlǝo mǝnana à tàrì ace Yahweh ka; kǝ girlina pa kàm wun nǝ̀ kúmô wun nǝ̀ pwano a nzali yalung ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Girlina ka, wun nǝ̀ kumi a nzali wun nǝ̀ pwano aɓa nongŋo tongno-nong-mwashat. Sǝ tongno-nong-ɓaria pwari ka, pwari Sabbat na. Pà wun nǝ̀ kum kǝ girlina a nzali a pwari mǝno ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Aɓea ɓwana puro a tongno-nong-ɓaria pwari à nǝ̀ nggá pwan girlina, sǝ lang à wari ka, à kya kum kǝgìr ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pǝlǝa Yahweh ɗì Musa ama, <<Nǝ̀ sau lang sǝ aɓwana mǝnia nǝ̀ ɓinǝ kpata anzongcau andǝ akwarkiru mem? ");
INSERT INTO mbu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wu sǝni! Mim Yahweh ka, mǝ nda ǝn pa wun Sabbat, yì pwari usǝlǝo ka. Nda gìr mǝnana tsǝa sǝ a tongno-nong-mwashatia pwari ka, ǝn pa wun girlina mǝnana nǝ̀ kārǝ́ wun mala nongŋo ɓari ka. Koyan ngga ɓǝ̀ do a ɓala ɓǝ̀ usǝlǝo, kǝ ɓwa ɓǝ̀kǝa na ama nǝ̀ purî ɓala male a pwari Sabbat ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nda aɓwana usǝlǝo, à pàk kǝ túró a pwari Sabbat raka. ");
INSERT INTO mbu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Amǝ Isǝrayila tunǝ girline ama Manna. Pwasǝo sǝ nda kǝla kyak mǝlapati mǝnana a pè nǝ mǝsǝ mbulara ɓa-mbyau ka, sǝ a lasǝu ka, nda pǝlpǝl kǝla mùr-nyì. ");
INSERT INTO mbu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa na ama, <<Mǝnia ka, nda cau mǝnana Yahweh ɓang ngga: <Wu ɗàrǝ́ munakwar-karǝgìr ɓari mala girlina Manna sǝ ɓǝà tsǝì ace anza mala aɓwana mǝnana à nǝ̀ yiu ka, ace mǝnana ɓǝà sǝn girlina, mǝnana ǝn linǝ wun nǝi a ɓabondo, lang ǝn pusǝ wun wu purî ɓá nzali Masar ka.> >> ");
INSERT INTO mbu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa banggi Haruna ama, <<Twal muna-nkwaring, tsǝk munakwar-karǝgìr ɓari mala girlina Manna aɓalǝi, sǝ kya tamsǝi a ɓadǝm Yahweh aɓa ban mǝfele ace anza mǝnana à kǝ yiu ka ɓǝà sǝni.>> ");
INSERT INTO mbu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kǝla mǝnana Yahweh banggi Musa ka, Haruna tsǝk muna-nkwaring nǝ girlina Manna aɓalǝi, a ɓadǝm Acau-nakûn, yì Akwati Kùrcau ace mǝnana ɓè kǝgìr ɓǝ̀ kǝa kúmsǝí raka. ");
INSERT INTO mbu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Aɓalǝ apǝlǝa lumi-ine mǝnana à yi kútí ka, Manna nda girlina mǝnana amǝ Isǝrayila lì ka bà yiu malea a nzong-nzali mala nzali Kan'ana, ban mǝnana aɓwana duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Tasau mǝnana à kǝ kārǝki Manna aɓalǝi ka nda oma ko lita lumi-ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Amǝ Isǝrayila a ɓinalea kat nying pǝɗanban mala Sin, à lo gya malea bǝti-bǝti, à nǝ̀ sulǝo a kàttì man sǝ à nǝ̀ tùr a ɓè, kǝla mǝnana Yahweh banggia wia ka. À kya sulǝo a Rifidim, sǝ banì ka mùr-nùná pa kàm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nda à tita nggwanî Musa, aban ne wi ama: <<Pà sǝm mùr sǝm nǝ̀ nú!>> Musa pea wia eare ama, <<Mana tsǝa sǝ wu kǝ nggwaniàm? Mana tsǝa sǝ wu kǝ mwam Yahweh?>> ");
INSERT INTO mbu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Aɓwana ka mǝsamùr wallia kǝ̀rkǝ́r, osso à lidǝmba nǝ nggwanì Musa. À kǝ bang ama, <<Ace mana sǝ a pusǝ sǝm aɓa Masar? A pusǝ sǝm ace mǝnana awu nǝ yia wal-lú sǝm nǝ mǝsamùr, sǝnǝ amuna sǝm andǝ agirkusǝu ma'sǝm le?>> ");
INSERT INTO mbu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Pǝlǝa Musa ɓua aban Yahweh, bang ama, <<Mana mǝ nǝ pang nǝ aɓwana man? Pà nǝ̀ sau ɗang à ndo à nǝ̀ kùtí a ɓukkiam nǝ atali ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yahweh pǝlǝa ne Musa ama, <<Twal aɓea aɓwana-mǝgule mala amǝ Isǝrayila atò, sǝ wu aki aɓwana dǝmba. Twal gara mana a walǝna mùr Nggeasala Nayel nǝi ka a buo, sǝ wù kyane. ");
INSERT INTO mbu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Wun nǝ̀ yia kumam aban kundǝ wun akanó a ban ɓe tali amur Nkono Saina, a Horep. Wal mǝno yì tali ka nǝ gara, mùr nǝ̀ pur aɓalǝi, mǝnana aɓwana nǝ̀ nu ka.>> Anggo sǝ Musa pa a ɓadǝmbǝ aɓwana-mǝgule mala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa pè ban mǝno lullǝu ama Massa sǝ Meriba, acemǝnana amǝ Isǝrayila nggwani sǝ à mwam Yahweh nǝ ɗiban ama, <<Mbak-kàngkàng Yahweh na aɓalǝ sǝm le?>> ");
INSERT INTO mbu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amǝ'amalek yiu nǝ lwa arǝ amǝ Isǝrayila a Rifidim. ");
INSERT INTO mbu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nda Musa banggi Jesǝwa ama, <<Tarki aɓea aburana ɓǝà puro sǝ ɓǝà oa munǝo arǝ amǝ Amalek. Lí ka mǝ nǝ nggá came a ɓong nkono nǝ gara mala Ɓakuli a buam.>> ");
INSERT INTO mbu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jesǝwa pa kǝla mǝnana Musa banggi wi ka, pur nǝ amǝ'lwa sǝ à o à kya je munǝo arǝ amǝ'Amalek, sǝ Musa andǝ Haruna andǝ Hur ka à eauwe à kya came a ɓong nkono. ");
INSERT INTO mbu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Lang Musa loasǝ abui a kùli ka, bù amǝ Isǝrayila kǝ twalki arǝ amǝ'Amalek a munǝo, sǝ lang sulǝ abui a nzali ka, bù amǝ Amalek kǝ twalki arǝ amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Lang banì sau ka, abú Musa aulǝa aban loasǝe a kùli. Nda Haruna andǝ Hur twal tali, à tsǝki wi aɓate ɓǝ̀ do amurí, sǝ yià ka à came arǝ ankanggari sǝ à mbali abui a kuli; anggo sǝ abuí cam kàngkàng bà kpa mala pwari. ");
INSERT INTO mbu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Anggo sǝ Jesǝwa andǝ amǝ'lwa male gandǝ amǝ Amalek nǝ nggeabyau. ");
INSERT INTO mbu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Anzǝm mǝno yì limurǝm ngga, Yahweh banggi Musa ama, <<Gilǝ cau mala limurǝm mǝnia ka a malǝmce ace mǝnana ɓǝ̀ duk gir tsǝa a ɗenyicau koya pwari, sǝ wu ɓalli ɓǝ̀ Jesǝwa oè ɓǝ̀ sǝlǝ ama mǝ nǝ twalta amǝ'Amalek, aɓwana pà nǝ̀ sǝlǝ cau malea a ɓanza ɗǝm ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Pǝlǝa Musa ɓak gyangŋan sǝ tsǝki wi lullǝu ama Yahweh-Nissi. ");
INSERT INTO mbu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Bang ama, <<Ən loasǝ tútà mala Yahweh a kùli. Acemani ka, arǝ anza mǝnana à kǝ yiu ka, Yahweh nǝ̀ lwa-lwa arǝ amǝ'Amalek bà masǝlǝate.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetǝro, nkil Musa mǝɓwabure, pǝris mala amǝ Midiyan ok cau mala agir mǝnana kat Ɓakuli pakki Musa andǝ amǝ Isǝrayila, andǝ pusǝó mǝnana pùsǝiá à purî ɓá nzali Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Nda lo yiu aban Musa ka. Musa ka akdǝmba tasǝna māmí andǝ amuni ɓari ɓǝà kya aban Jetǝro, sǝ yì Jetǝro ka ea à do a baní. Lang yiu ka, yiu atārǝia andǝ mālá Musa, yì Zipora, ");
INSERT INTO mbu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","andǝ amuna-burana mala Musa ɓari. À ɓǝlî Musa amuna-burana mǝnia ɓari ka a bàkú mǝnana yì ka bǝri na peatu a nzali Midiyan ngga. Acemani ka, tsǝkî muna-dǝmba male lùllǝú ama Gashom. ");
INSERT INTO mbu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Lang à ɓǝli wi ɓaria muni ka, tsǝki wi lùllǝú ama Eliyeza, acemǝnana bang ama, <<Ɓakuli mana akâ peri a baní ka, bwalam nggam sǝ amsǝam a bu Firona, murǝm Masar, mǝnana ɓǝ́ walna-luem ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yì Jetǝro, nkil Musa, atārǝia andǝ mālá Musa andǝ amuna-burana mala Musa ka, à yiu a ɓabondo aban Musa, a ban mǝnana Musa andǝ amǝ Isǝrayila tsǝk là-gumli kàm, tù aban Nkono mala Ɓakuli ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kaniama Jetǝro nǝ̀ yiu ka, akdǝmba tasǝî Musa cau ɓǝà banggi wi ama, <<Mim, Jetǝro nkilo, mǝ ndya ǝn nggǝ ká a bano atarǝ sǝm sǝnǝ māmó andǝ amunio amuna-burana ɓari ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Lang à yi bingŋǝna ka, Musa puro yi ɓunno a ɓadǝm Jetǝro sǝ kùrì zǝp, gingsǝi. Pǝlǝa Musa kútí nǝ Jetǝro aɓa gumli male. ");
INSERT INTO mbu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa twal cau banggi wi koman kat mala gìr mǝnana Yahweh pangnǝ Firona, Murǝm andǝ amǝ Masar ace amsǝ amǝ Isǝrayila ka. Ɗǝm ngga banggi wi cau mala tanni mǝnana yiu amuria a njar aban yiu, andǝ amsǝa mǝnana Yahweh amsǝ aɓwana male aɓalǝ atanni malea ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Lang Jetǝro ok acau mǝnia ka, banɓoari wi ace agir mǝɓoarne mǝnana Yahweh pea ace amǝ Isǝrayila, nǝ amsǝa mana amsǝia a bu amǝ Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Sǝ bang ama, <<Ɓwangsǝban ɓǝ̀ pa aban Yahweh mǝnana amsǝ wun a bù Firona Murǝm sǝ a bù amǝ Masar ka! Ɓǝà ɓwangsǝ Yahweh mǝnana amsǝ aɓwana male a ɓata parban mala amǝ Masar ka! ");
INSERT INTO mbu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Adyan ngga ǝn sǝlǝna ama Yahweh ka, nda Ɓakuli mana kàrmúr aɓakuli kat ka, acemǝnana amsǝ aɓwana male a ɓata parban mala amǝ Masar, amǝ twàlɓamúruì.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Pǝlǝa Jetǝro, nkil Musa yinǝ ɓoro mala pisǝe kǝring, andǝ agir shawuɗiban, ace pàgir aban Ɓakuli; sǝ Haruna andǝ aɓwana-mǝgule kat mala Isǝrayila yiu à yi li girlina atārǝia andǝ Jetǝro akanó a ɓadǝm Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ban fana ka, Musa puro yi do a ban ɓashì aɓwana. Aɓwana yi ramba à kàrì Musa aɓalǝu twal a dǝmbari aban ká kpa mala pwari. ");
INSERT INTO mbu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Lang Jetǝro, nkil Musa sǝn gìr mǝnana kat Musa kǝ pè ace aɓwana ka, ɗì ama, <<Mana mǝnia a kǝ pê ace aɓwana ani ka? Palang sǝ a dum nǝmurǝo aban pak ɓashi, sǝ aɓwana kat came à kàrio aɓalǝu twal a dǝmbari aban ká kpa mala pwari?>> ");
INSERT INTO mbu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa eari wi ama, <<Nda acemǝnana aɓwana kǝ yiu abanam ace ɗìbancau aban Ɓakuli ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pwari mǝnana kat kúnɓuàna lo a nre aɓwana ɓari ka, à kǝ yiu abanam, sǝ mǝ nǝ kasǝ-ɓashi amur yana ateà ndanǝ mǝsǝcau, sǝ mǝ nǝ kania wia anzongcau andǝ anggurcau mala Ɓakuli.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Pǝlǝa Jetǝro, nkil Musa banggi wi ama, <<Pě mana anggo ka ɓoar ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","We wunǝ aɓwana mǝnana à kǝ yiu a bano ka, banì pà nǝ̀ sau ɗang wun nǝ̀ yauwí. Túró mǝnia ka ɓiki gulò; a pà nǝ gandǝ pe nǝmurǝo ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kwakikiro arǝàm sǝ mǝ nǝ po aɓea cau kwarkiru, sǝ Ɓakuli ka nǝ̀ pà atò. Awu nǝ do mǝ'came a nre ka aɓwana andǝ Ɓakuli, ace yinǝ acau mala akúnɓuàna malea a baní. ");
INSERT INTO mbu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Awu nǝ kània wia anê andǝ anggurcau mala Ɓakuli, wu bǝlia wia lang sǝ do malea ɓoaro ɓǝ̀ pa, andǝ gir mǝnana à nǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tsǝa amur mǝno ka, ɓoaro wu tàrki aɓwana mǝnana mǝsǝia kàngkàng, amǝ ɓanggî Ɓakuli, aɓwana mǝnana à nǝ̀ earnǝia, sǝ à nda ka amǝ ɓinǝce ak pàbunǝnzali ka. Tsǝia ɓǝà duk aɓwana-mǝgule amur aɓwana: amǝ'yálmúr aɓwana á, amǝ'yálmúr aɓwana gbǝman, amǝ'yálmúr aɓwana lumi-tongno, sǝ amǝ'yálmúr aɓwana lum. ");
INSERT INTO mbu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tsǝia ɓǝà do à nda ka amǝ'ɓashi koya pwari amur aɓwana. Ɓǝ̀ ɓekǝ cau mǝkwane nakam mǝnana gandǝia ka, nda à nǝ̀ yinǝi a bano ka, sǝama koya cau mana kwan raka, à nǝ̀ gilǝki nǝ nggearǝia. Anggo ka agir pà nǝ̀ kwanbo ɗàng, acemǝnana yìa mǝno ka, à nǝ̀ amsǝô dǝmbǝrya mala túrô. ");
INSERT INTO mbu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ɓǝ̀ a kpata kwarkiru mǝnia, sǝ ɓǝ̀ Ɓakuli tsǝko wi ama wu pê anggo ka, awu nǝ gandǝ twal gandǝa nǝ acau, sǝ aɓwana mǝnia kat ka, à nǝ̀ nyar a ɓala aɓa rǝpwala.>> ");
INSERT INTO mbu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa kpata kwarkiru mala nkili, sǝ pàk gìr mǝnana kat banggi wi ka; ");
INSERT INTO mbu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","tàrki aɓwana mǝnana mǝsǝia kàngkàng ngga aɓalǝ amǝ Isǝrayila kat sǝ tsǝia à duk aɓwana-mǝgule amur aɓwana: amǝ'yálmúr aɓwana á, amǝ'yálmúr aɓwana gbǝman, amǝ'yálmúr aɓwana lumi-tongno, sǝ amǝ'yálmúr aɓwana lum. ");
INSERT INTO mbu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","À duk amǝ'ɓashi amur aɓwana a koya pwari. Ɓǝ̀ ɓekǝ cau mǝkwane yiu mǝnana gandǝia ka, à wari nǝi a baní. Acili acau mǝkèke ka, à sǝngi ɓālǝia nǝ nggearǝia. ");
INSERT INTO mbu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Bǝti anzǝm mǝno ka, pwari o mala Jetǝro nkil Musa yi pa, pǝlǝa Musa tsǝiandà, sǝ bwal njar nyare o a nzali male. ");
INSERT INTO mbu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","A pwari mǝdǝmbe mala tàruià zongŋo anzǝm mǝnana amǝ Isǝrayila purnǝì ɓá nzali Masar ka, à yì bik pǝɗanban mala Saina aɓa mǝno yì pwari ka. ");
INSERT INTO mbu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Lang à loapi Rifidim ngga à twal gya sǝ à yi bik pǝɗanban mala Saina. Akanó ka amǝ Isǝrayila tsǝk là-gumli malea a kusǝ Nkono Saina. ");
INSERT INTO mbu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Pǝlǝa Musa eau amur nkono aban Ɓakuli, sǝ Yahweh tunǝi nǝ múr nkono, ne wi ama, <<Ne amǝ ɓala mala Yakupu, amǝ Isǝrayila ama: ");
INSERT INTO mbu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","<Wu sǝnǝna gìr mǝnana ǝn pakki amǝ Masar, andǝ lang sǝ ǝn twal wun kǝla mana nkwang kǝ twal muni arǝ ankpamtari ka, sǝ ǝn yinǝ wun akani abanam. ");
INSERT INTO mbu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Adyan ngga ɓǝ̀ wun nǝ̀ okam, sǝ wun nǝ̀ lùmsǝ kùrcau mem ngga, aɓalǝ anzali kat ka, wun nǝ̀ duk aɓwana mǝnana ǝn tària à dumǝna mem ngga, kat andǝ amani ama ɓanza kat ka memma ka. ");
INSERT INTO mbu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Wun nǝ̀ duk domurǝm mala apǝris abanam, aɓwana amǝfele mem.> Amǝnia ka à nda ka acau mǝnana awu nǝ ne amǝ Isǝrayila ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Pǝlǝa Musa sùlǝî múr nkono, sǝ tunǝ aɓwana-mǝgule mala aɓwana kat, sǝ banggia wia cau mana kat Yahweh tsǝì ama ɓǝ̀ banggia wia ka. ");
INSERT INTO mbu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Osso aɓwana ear gǝu ama, <<Sǝm nǝ̀ kpata cau mǝnana kat Yahweh bang ngga.>> Sǝ Musa nyesǝ cau mala aɓwana kya ne Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yahweh banggi Musa ama, <<Mǝ ndya mǝ nǝ yiu a bano aɓa pǝrɓang mǝɓiktiki, ace mǝnana ɓǝ̀ aɓwana ok giem aban nacau nǝ we ka. Anggo ka à nǝ̀ earnǝ we a koya pwari.>> Anzǝm mana Musa nyesǝna cau mǝnana aɓwana bang ngga, kya nani Yahweh ka, ");
INSERT INTO mbu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yahweh banggi Musa ama, <<Kyane, aban aɓwana, kya nea wia ɓǝà twal pwari mala yalung andǝ lí ɓǝà gilǝki rǝia aɓa ɓoarnsari ace yiu a peri. Nea wia ɓǝà lákkí agir-nggūrǝu malea ");
INSERT INTO mbu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","sǝ ɓǝà gilǝrǝia a tàruià pwari. A pwari mǝno ka mǝ nǝ sulǝo, mǝ nǝ yiu amur Nkono Saina, a ban mǝnana aɓwana kat nǝ̀ sǝnam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tsǝk nzong ɓǝ̀ kàrì nkono ace mǝnana aɓwana ɓǝà kǝa yàllî wi ɗàng, sǝ banggia wia ama ɓǝà kǝa eauwe a nkono ɗàng, yàle ɓǝà kǝa na ama à nǝ̀ gbàshì baní ɗàng. Ɓǝ̀ kǝɓwa tsǝk kusǝì amur nkono ka, ɓǝà wali ɓǝ̀ wu; ");
INSERT INTO mbu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ɓǝà ɓukki nǝ atali, ko ɓǝà tāki nǝ amundi; sǝ bù kǝɓwa ɓǝ̀ kǝa na ama nǝ̀ je mǝno yì ɓwa ka ɗàng. Ko ɓǝ̀ girkusǝu na sǝ je nkono mǝnia ka, dumǝna púp à nǝ̀ wali ɓǝ̀ wú. Sǝama aɓwana nǝ̀ gandǝ ká tù a kusǝ nkono anzǝm mǝnana ɓǝà ok twang njawe ɓua tè sau ɗār ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Pǝlǝa Musa sùlǝî múr nkono yiu aban aɓwana, sǝ banggi aɓwana ɓǝà gilǝrǝia ace peri. Nda à lákkí agir-nggūrǝu malea ka, ");
INSERT INTO mbu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","sǝ Musa banggia wia ama, <<Wu gilǝ rǝ wun ace tàruià pwari, tite a pwari mala yalung. Wu kǝa gbàshì ban amālá wun ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","A tàruià nongŋo nǝ dǝmbari ka, mgbarangce sàkkya, tǎlaban liki'nzama pǝlilip, pǝrɓang mǝgule yi zuppi amur nkono, sǝ à ok gìu mǝcandǝe mala njawe aban ɓua, sǝ koyan a kàttì ka rǝì ɓǝl nǝ ɓangciu. ");
INSERT INTO mbu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Pǝlǝa Musa ak dǝmba sǝ aɓwana kpatè, pusǝia à nying kàttì, aban ká je andǝ Ɓakuli. À yiu à yi came a kusǝ nkono. ");
INSERT INTO mbu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sǝ Nkono Saina ka lùmsǝ nǝ yele, acemǝnana Yahweh angŋa dǝmba yi sulǝna amurí aɓa bǝsa mǝ'earke, sǝ yele male kǝ lo a kùli kǝla yele tūli bǝsa, sǝ nkono kat ka kǝ gǝggǝli nǝ rǝcandǝa. ");
INSERT INTO mbu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Lang gì njawe nǝ̀ nggǝ ɓua kàm kpǝm bàng-bàng ngga, Musa pǝlǝa nacau, sǝ Ɓakuli nyesǝi wi cau nǝ giu mala mgbarangce. ");
INSERT INTO mbu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yahweh yi sulǝo a ɓong Nkono Saina sǝ tunǝ Musa ɓǝ̀ eauwe ɓǝ̀ kyane a ɓong nkono. Musa eauwe wario, ");
INSERT INTO mbu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","sǝ Yahweh banggi wi ama, <<Sulǝo kyane kya nunkir aɓwana ama ɓǝà kǝa yàlî nzong ama à nǝ̀ ɓunno aban yiu aban Yahweh ace sǝnban ɗàng. Ɓǝ̀ à pàk anggo ka, pas ateà à nǝ̀ wukio. ");
INSERT INTO mbu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ko nggearǝ apǝris mǝnana à kǝ yiu à kǝ gbashi banam pwari-pwari ka, dumǝna púp à nǝ̀ tàr ɓamuria aɓa domǝfele, ɓǝ̀ ana raka mǝ nǝ sulǝ bumlulla mem amuria, mǝ nǝ twaltea.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa ne Yahweh ama, <<Aɓwana pà nǝ̀ eauwe aban yiu aban nkono ɗàng, acemǝnana à earia wia ɓǝà yiu ɗang; we nǝ nggearǝo ka, a bangŋǝna sǝm ama ɓǝ̀ sǝm tsǝk nzong ɓǝ̀ kàrì nkono ace mǝnana ɓǝ̀ tàrì, dumǝna ban mǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yahweh nyesǝi wi ama, <<Sulǝo kyane sǝ wu kya yiu wunǝ Haruna akani. Sǝ apǝris andǝ acili aɓwana ka, ɓǝà kǝa ɓunno ama à nǝ̀ yiu abanam ɗàng, ɓǝ̀ ana raka mǝ nǝ sulǝ bumlulla mem amuria, mǝ nǝ twaltea.>> ");
INSERT INTO mbu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Pǝlǝa Musa sulǝo wari aban aɓwana sǝ nea wia gìr mǝnana Yahweh bang ngga. ");
INSERT INTO mbu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ɓakuli bang amǝnia yì acau ka, ama: ");
INSERT INTO mbu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Mim Yahweh ka, mǝ nda Ɓakuli mô, mǝnana amsǝo a nzali Masar, a purî ɓala guro ka. ");
INSERT INTO mbu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","A pà wu nǝ pàngnǝ aɓea aɓakuli ɗang she kǝ mim. ");
INSERT INTO mbu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","A pà wunǝ pakkî ɓamurò kǝ ɓǝ̀nzál mǝnana à shàrrì, ko ɓè gìr mǝnana kat kǝ pur ɓè kǝgìr akanó a kùli, ko akani a nzali, ko a tǝta mùr a tà-nzali ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Dumǝna púp a pà wu nǝ ɓun a ɓadǝmbia, ko awu nǝ peri abania ɗàng. Acemǝnana Mim Yahweh Ɓakuli mô ka, mǝ nda Ɓakuli mǝ'mɓali. Ən nggǝ yinǝ ɓashi ace acauɓikea mala atárrú amur amunia andǝ amǝ'keà, aban ká tàruia andǝ inea nza mala aɓwana mǝnana à kǝ ɓinǝcem ngga. ");
INSERT INTO mbu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Sǝama ǝn nggǝ lǝmdǝ earcearǝu mem mǝnana malkiyi raka, amur aɓwana mǝnana à kǝ earcem sǝ à kǝ bwal anzongcau mem ngga. Earcearǝu mem nǝ̀ gya amuria andǝ amunia andǝ amǝ'keà aban ká arǝ anza á-pas malea. ");
INSERT INTO mbu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","A pà wunǝ pàktúró nǝ lullǝ Yahweh Ɓakuli mô ace pàkkiagir ɓana ɗàng; acemǝnana Yahweh pa nǝ̀ nying ɓashì ɓwa mǝnana kǝ nyesǝ lullǝì ɓà ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ɗenyinǝ Pwari Sabbat, pwari usǝlǝo; awu nǝ tàrì ɗàng ɓǝ̀ duk mǝfele, pwari ace Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Arǝ apwari tongno-nong mwashat sǝ awu nǝ pàk túró, a nǝ mal atúró mô kat. ");
INSERT INTO mbu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Sǝama tongno-nong-ɓaria nongŋo ka, pwari Sabbat na abanam Yahweh. Aɓalǝi ka, a pà wu nǝ pàk kǝ túró ɗang, ko we, ko muna-ɓwabura mô, ko muna-ɓwama mô, ko muna-ɓwabura mǝtúró-ɓala mô, ko muna-ɓwama mǝtúró-ɓala mô, ko agirkusǝu mô, ko abǝri-aɓwana mǝnana à do atà wun a là ka. ");
INSERT INTO mbu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Acemǝnana aɓalǝ anongŋo tongno-nong-mwashat sǝ Yahweh pusǝ kùli andǝ nzali, sǝ nggeamùr, andǝ agir mǝnana kat aɓalǝia ka, sǝ usǝlǝo a tongno-nong-ɓaria pwari. Nda gìr mǝnana tsǝa sǝ Yahweh tsǝki pwari Sabbat bù, ɓǝ̀ do mǝfele na ka. ");
INSERT INTO mbu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Gusǝlǝ tárró andǝ nggo, ace mǝnana anongŋo mala do ɓanza mô mǝnana Yahweh Ɓakuli mô po ka, ɓǝà làkkì. ");
INSERT INTO mbu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","A pà wu nǝ wal-lú ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","A pà wunǝ nongnǝ kǝ ɓwa mǝnana wu al rǝ wun wunǝi raka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","A pà wunǝ iun'í ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","A pà wunǝ nakún nyir arǝ ɓio mǝ'murkala ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","A pà wu nǝ sham ɓala mala ɓio mǝ'murkala ɗang. A pà wu nǝ sham mālá ɓio mǝ'murkala, ko mǝtúró-ɓala male ɓwabura ko ɓwama, ko jamnda, ko dambǝritso male, sǝ koya gìr mǝnana kat mala ɓio mǝ'murkala na ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Lang ɓwapǝndǝa kat nǝ̀ ok sàkkya mala mgbarangce, andǝ gi njawe, sǝ à sǝn liki'nzama mala tǎlaban, andǝ yele mǝnana kǝ lo amur nkono ka, ɓangciu pakkia wia, rǝia kǝ ɓǝla, sǝ à cam kuko. ");
INSERT INTO mbu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","À banggi Musa ama, <<We ka bangga sǝm cau, sǝm nǝ̀ ǒ, sǝama Ɓakuli ɓǝ̀kǝa na sǝm cau nǝ nggeari ɗàng, ɓǝ̀ ana raka sǝm nǝ̀ wukio.>> ");
INSERT INTO mbu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa pea wia eare ama, <<Ɓangciu ɓǝ̀ kǝa pakka wun ɗàng. Ɓakuli yiu nǝ̀ yia mwam wun, ace mǝnana ɓǝ̀ wu do nǝ ɓanggi wi, wu kǝa pàk cauɓikea raka.>> ");
INSERT INTO mbu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Aɓwana ueo aban came zak; Musa na nǝmurǝì sungŋo wari aban pǝndǝa mǝcikciki, a ban mǝnana Ɓakuli nakam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yahweh banggi Musa ama, <<Nea amǝ Isǝrayila cau mǝnia ka ama: <Wu sǝnǝni nǝ nggearǝ wun ama ǝn bangga wun cau nǝ kuli. ");
INSERT INTO mbu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Pà wun nǝ̀ alita ɓamur rǝ wun ɓekǝ nkúl mǝnana à pè nǝ bolo-azǝrfa ko bolo-njengǝlan ama wun nǝ̀ peri abania sǝ wun nǝ̀ kpapiam sǝnǝia ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","<< <Wu ɓak gyangŋan nǝ dǝɓang-nzali acem, sǝ wu pāki agir'nkila nǝ anzur andǝ andá ma'wun mǝnana à nǝ̀ pisǝia kǝring ngga, andǝ pākiagir mala dotarǝu, amurí. A koya ban mǝnana ǝn tárì ace mǝnana ɓǝ̀ wu yi peri abanam kàm ngga, mǝ nǝ yiu aban wun mǝ nǝ tsǝka wun bù. ");
INSERT INTO mbu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ɓǝ̀ wun nǝ̀ ɓak gyangŋan nǝ atali acem ngga, wu kǝa ɓè nǝ atali mǝnana à ɓunnia nǝ ɓunno ka ɗàng. Ɓǝ̀ wu pàktúró nǝ tali mǝnana à ɓunni ko à gilǝki rǝi nǝ girtúró sǝ à ɓak gyangŋan nǝi ka, gyangŋanì pànǝ ɓoaro abanam ace peri ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Wu kǝa ɓakkam gyangŋan mǝnana ndanǝ aban-eauwe arǝì ka ɗàng, ace mǝnana ɓǝ̀ a ndaban eauwe aban ká amurí ka, wu kǝ alí rǝò ɗàng.> ");
INSERT INTO mbu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","<<Amǝnia ka, à nda ka akwarkiru mǝnana awu nǝ pè amǝ Isǝrayila ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","<<Ɓǝ̀ a kúr guro ɓwa Ibǝru ka, nǝ̀ pàkkô túró guro apǝlǝa tongno-nong-mwashat. Sǝ aɓa tongno-nong-ɓaria pǝlǝa ka, awu nǝ nyì ɓǝ̀ kum ɓamúrì, ɓǝ̀ kǝa mbweo kǝgir ace ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ɓǝ̀ nda nǝmurǝì, pànǝ ɓwama ɗàng, sǝ a kúrí ka, yì nǝmurǝì na awu nǝ panzǝi ɓǝ̀ u ka. Sǝ ɓǝ̀ ndanǝ ɓwama sǝ yi duk guro mò ka, nǝ̀ twal māmí à nǝ̀ o andǝi. ");
INSERT INTO mbu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ɓǝ̀ mǝtala-ɓala male na pè wi ɓwama, sǝ ɓwame ɓǝli wi amuna ka, nǝ̀ um nǝmurǝì, ɓwama andǝ amuna ka amala mǝtala-ɓala male na. ");
INSERT INTO mbu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Sǝ ɓǝ̀ mǝno yì guro ne bwāng ama, <Ən nggǝ earce mǝtala-ɓala mem, andǝ māmám andǝ amunem,> sǝ earce ama ɓǝà panzǝi nǝ̀ o nǝ̀ nyia raka, ");
INSERT INTO mbu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mǝtala-ɓala male nǝ̀ kánǝi a ɓadǝm Ɓakuli. Akanó ka nǝ̀ nggá tamsǝi a kunkurǝm ko arǝ kpangbang kunkurǝm, sǝ mǝtala-ɓala male nǝ̀ tusǝ kiri nǝ nlerǝman, sǝ yì ka nǝ̀ duk guro mala mǝtala-ɓala male bà lú male. ");
INSERT INTO mbu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","<<Ɓǝ̀ ɓwa mak nsarile ɓǝ̀ duk guro mǝturo-ɓala ka, à pà nǝ̀ panzǝi ɓǝ̀ o kǝla mala guro muna-ɓwabura ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ɓǝ̀ guro muna-ɓwame mǝnia ka, mǝtala-ɓala male yinǝi sǝ yi tàrì ace ɓamúrì ɓǝ̀ duk māmí, sǝama nǝnzǝ́mò ka guro muna-ɓwame pwasǝbumi raka, dumǝni mǝtala-ɓala mǝnia ka púp ɓǝ̀ ɗeki ɓǝà akmúr muna-ɓwame. Njar pà kàm a bu mǝtala-ɓala mǝnia ama nǝ̀ makkì amǝ'kúnɗàngna mǝnia yì guro muna-ɓwama ka ɗàng, acemǝnana ɓungina tsǝkɓalǝu mala muna-ɓwame. ");
INSERT INTO mbu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ɓǝ̀ ɓwa kúr mā-guro ace mǝnana ɓǝ̀ duk mālá munì ka, nǝ̀ twali kǝla munì. ");
INSERT INTO mbu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","<<Ɓǝ̀ mǝtala-ɓala al ɓaria ɓwama ka, dumǝna púp nǝ̀ lidǝmba nǝ pê ɓwama mǝdǝmbe girlina andǝ gìr'nggūrǝu ɓǝ̀ kārǝí, sǝ nǝ̀ lidǝmba nǝ pakki wi gìr mǝnana ɓoaro ɓǝ̀ ɓwabura pakki māmí ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Sǝ ɓǝ̀ ginǝ lùmsǝ amǝnia yì atúró male kǝla ɓwabura aban ɓwame ka, dumǝna púp nǝ̀ nyì ɓǝ̀ purî ɓala male, sǝ ɓǝ̀ kǝa mbwe kǝgir ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","<<Ɓwa mǝnana kat wal ɓè ɓwa, ɓwe wù ka, à nǝ̀ wal-luí gbal. ");
INSERT INTO mbu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sǝama ɓǝ̀ turtúró nǝ túró arǝì, hamce nǝ̀ wal-lui raka, sǝ kat andǝ amani ka Ɓakuli eare gìrnî kumban ngga, mǝ nǝ tsǝk ɓè ban-auwa mǝnana ɓwê nǝ̀ gandǝ ɓangŋa nǝ̀ ká kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Sǝ ɓǝ̀ ɓwa kànì a ɓabumi sǝ wal-lú kpakpak ka, ko ɓǝ̀ ɓangŋa sǝ kya auwa arǝ gyangŋan mem ngga, wu nungi wu pusǝì, wu wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","<<Ɓwa mǝnana kat walki tárrí ko walki ngge ka, dumǝna ama à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","<<Ɓwa mǝnana iu ɓè ɓwa kya mé ko à kumi a buì ka, dumǝna ama à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","<<Ɓwa mǝnana kat sanggi tárrí ko sanggi nggè ka, dumǝna ama à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","<<Ɓǝ̀ ndo ama aɓwana ɓari à nda aban pǝlǝkirǝia, sǝ ɓè ɓwa wal ɓì nǝ tali ko tùllì nǝ bui sǝ wù ɗàng, sǝama kum penye mǝnana nongsǝi a kala, ");
INSERT INTO mbu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","sǝ ɓǝ̀ nǝnzǝ́mò ka ɓwê yi longŋǝna nǝ nggǝ ging nǝ gara a nza ka, ɓwa mǝno walban ngga auna, sǝama nǝ̀ mbwe apwari mǝnana kiɗiki wi ka, sǝ ɗǝm ngga nǝ̀ tsǝkiri sǝ nǝ̀ mbwe boalo agir'sonzǝo male she ɓǝ̀ rǝì malna kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","<<Ɓǝ̀ mǝtala-ɓala walki guro male, ɓwama ko ɓwabura nǝ gara, sǝ wal-luí a kún bui ka, dumǝna púp à nǝ̀ ɓashì wi nǝ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Sǝ ɓǝ gurè wù ɗàng, rǝi malâ aɓa nongŋo mwashat ko ɓari ka, à pà nǝ̀ pakkî mǝtala-ɓala male kǝgir ɗàng acemǝnana guro ka girkuma male na. ");
INSERT INTO mbu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","<<Ɓǝ̀ aɓwana ɓari na aban munǝo, sǝ ɓè ɓwa ateà tùl ɓwama nǝ muna a bumi, muna-sulǝ'arǝì, sǝ kum ɓekǝ npenye raka, ɓwa mǝnana tul ɓwamè ka burí nǝ̀ kasǝi wi boalo mǝnana nǝ̀ mbwe ka, sǝ amǝ'ɓashi nǝ̀ sǝngi gir mǝnana ɓoaro ɓǝ̀ mbwe ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Sǝ ɓǝ̀ ɓè kǝgir kum ɓwamè ka, à nǝ̀ mbwe yilǝmu nǝ yilǝmu, ");
INSERT INTO mbu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mǝsǝu ace mǝsǝu, minǝu ace minǝu, bù ace bù, kusǝu ace kusǝu, ");
INSERT INTO mbu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","pisǝban ace pisǝban, npenye ace npenye, kokban ace kokban. ");
INSERT INTO mbu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","<<Ɓǝ̀ ɓwa wal guro male, ɓwabura ko ɓwama, sǝ ar mǝsǝi ka, dumǝna púp ɓǝ̀ nying guro mǝno ɓǝ̀ o atàrǝì. Mǝno ka nǝ̀ do nda mbweban ace mǝsǝì. ");
INSERT INTO mbu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Sǝ ɓǝ̀ ɓun minǝ guro male ɓwabura ko ɓwama ka, dumǝna púp ɓǝ̀ nying guro mǝno ɓǝ̀ o a do-ɓamurì ace minǝì. ");
INSERT INTO mbu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","<<Ɓǝ̀ ndǎ soa ɓwabura ko ɓwama nǝ njawe sǝ wal-luí ka, dumǝna púp à nǝ̀ ɓukki mǝno yì ndǎ ka nǝ atali sǝ à pà nǝ̀ shak nyami ɗàng; sǝ mǝtala ndǎ ka à pà nǝ̀ pakki wi kǝgir ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Sǝ ɓǝ̀ ndǎ mǝno ka à súrǝì kǝ soaban, sǝ mǝtale ka à nunakiri sǝ oasǝi aɓa nkāndan raka, ɓǝ̀ wal-lú ka, à nǝ̀ ɓukki mǝno yì ndǎ ka, sǝ mǝtale gbal ka à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Sǝama ɓǝà kasǝi wi gìr mǝnana nǝ̀ mbwe ace amsǝ yilǝmi ka, dumǝna púp nǝ̀ mbwe gìr mǝnana kat à kasǝi wi ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Sǝ ɓǝ̀ mǝno yì ndǎ ka tùl muntulo ɓwama ko ɓwabura ka, kǝ ɓashi mǝmwashati kǝla mǝno na à nǝ̀ kasǝ ka. ");
INSERT INTO mbu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ɓǝ̀ mǝno yi ndǎ ka, soa guro ɓwama ko ɓwabura ka, à nǝ̀ mbwe mǝtala guro mǝsǝbolo azǝrfa lumi-tàrú sǝ yì ndǎ ka, à nǝ̀ ɓukki ɓǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","<<Ɓǝ̀ ɓwa busǝlǝ tūli, ko tǝm tūli sǝ lúmsǝí raka, ɓǝ̀ ndǎ ko mǝdambǝriso kpa aɓalǝi ka, ");
INSERT INTO mbu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mǝtala tūli ka nǝ̀ mbwe mǝtala girkusǝu boalè, sǝ lú girkusǝu ka nǝ̀ duk male. ");
INSERT INTO mbu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","<<Ɓǝ̀ ndǎ mala ɓwa soa ndǎ mala ɓè ɓwa, wal-luí ka, yì aɓwana mǝnia ɓari ka à nǝ̀ mak ndǎ mǝnana nǝyilǝmu ka, à nǝ̀ gau boalè sǝ nyam lú ndǎ gbal ka à nǝ̀ gauwi. ");
INSERT INTO mbu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","<<Sǝ ɓǝ̀ ndo ama mǝno yì ndǎ ka à súrǝì nǝ tulkiban ɗiɗyal sǝ mǝtale tsǝkiri oasǝi aɓa nkāndan raka, mǝtala ndê nǝ̀ mbwe ɓè ndǎ a kúnì lú ndǎ, sǝ nǝ̀ twal lú ndǎ ɓǝ̀ duk male. ");
INSERT INTO mbu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","<<Ɓǝ̀ ɓwa iu ndǎ ko nzur, sǝ pwanmyali ko mé ka, dumǝna púp ɓwe nǝ̀ mbwe andá tongno a kúnì ndǎ mwashat, sǝ nǝ̀ mbwe anzur ine a kúnì nzur mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","<<Ɓǝ̀ à bwal mǝn'í aɓa ɓala nǝ dú aban ǝn'í sǝ à wal-luí ka, ɓwa mǝno wal-lú mǝn'í ka à pà nǝ̀ bwali nǝ kúmcàu mala wal-lú ɗàng; ");
INSERT INTO mbu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","sǝama ɓǝ̀ nda nǝ pwari sǝ gìrnî kumban ngga, ɓwa mǝnana wal-luí ka, à nǝ̀ ɗice nkila mǝn'í a buì. <<Mǝn'í ka, dumǝna púp nǝ̀ mbwe gìr mǝnana kat iu ka. Ɓǝ̀ gandǝ mbwe raka, ɓǝà mé kǝla guro ace mbwe gìr mǝnana iu ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","<<Ɓǝ̀ ɓwa iu ndǎ, ko mǝdambǝriso, ko nzur sǝ à kumi a buì ka, dumǝna púp nǝ̀ mbwe ɓari a kúnì mwashat mala gìr mǝnana iu ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","<<Ɓǝ̀ ɓwa nying agirkusǝu à kùtí a ɓaban mala ɓeɓwa sǝ à lì mǝssa ko aɓǝlanggun anap ka, dumǝna púp mǝtala agirkusǝu nǝ̀ pwan mǝssa ko ɓǝlanggun anap mǝɓoarne kat-kat aɓalǝ agirɓaban male ɓǝ̀ mbwe mǝtala ɓaban gìr mǝnana kat agirkusǝu kiɗiki wi ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","<<Ɓǝ̀ ɓwa soa bǝsa aban pisǝki azwe sǝ bǝshè àwá pisǝ mǝssa mǝnana nda aban came, ko mǝnana à wàlnì, ko mǝnana à ramǝni a ɓaban mala ɓeɓwa ka, ɓwê ka nǝ̀ mbwe mǝtala ɓaban gìr mǝnana kat bǝsa pìsǝì ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","<<Ɓǝ̀ ɓwa pè ɓi mǝ'murkala boalo, ko ɓè girkuma ɓǝ̀ tsǝki wi, sǝ à yi iuwi arǝì a ɓala, sǝ ɓǝ̀ à yi bwal mǝn'î ka, dumǝna púp mǝn'í nǝ̀ mbwe gìr mǝnana iu ka kusǝ ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Sǝ ɓǝ̀ à bwal mǝn'î raka, ɓwa mǝnana à pè wi tsǝk boalo ko girkuma ka, à nǝ̀ kánǝí aban amǝ'ɓashi a ɓadǝm Ɓakuli. Akanó ka ɓǝà kya sǝngi cê ko yì na oasǝ buì arǝ girkuma mala ɓì mǝ'murkala ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","<<Ɓǝ̀ makgir lo a nre ka aɓwana ɓari amur ndǎ, ko mǝdambǝriso, ko nzur, ko ɓè girkuma, ko gìr'nggūrǝu, ko ɓè gìr mǝnana ɓwaro sǝ koyan ngga kǝ na ama male na ka, à nǝ̀ kánǝ cê malea mǝnia yia kǝm ngga aban amǝ'ɓashi aɓadǝm Ɓakuli, sǝ ɓwa mǝnana amǝ'ɓashi bwali nda mǝ'nyir ka, nǝ̀ mbwe gìrnî kusǝ ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","<<Ɓǝ̀ ɓwa eare nǝ̀ bwal mǝdambǝriso, ko ndǎ, ko nzur, ko ɓekǝ girkusǝu ace mǝnana nǝ̀ tsǝkiri ace ɓi mǝ'murkala, sǝ yì girkusǝu ka wǔ, ko kum npenye, ko ɓwaro sǝ kǝɓwa sǝni raka, ");
INSERT INTO mbu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ɓwa mǝnana à pè wi tsǝkirgir ka, dumǝna púp nǝ̀ kángìr a ɓadǝm Yahweh ama, iu-ma girkusǝu mala ɓì mǝ'murkala ɗang; sǝ mǝtala girkusǝu ka nǝ̀ earnǝ mǝno, sǝ à pà nǝ̀ ɗice kǝ mbweban ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Sǝ ɓǝ̀ mǝno yì girkusǝu ka à iuwi nǝ iuwe ka, ɓwa mǝnana iuwi ka, nǝ̀ mbwe mǝtale. ");
INSERT INTO mbu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ɓǝ̀ mǝno yì girkusǝu ka nyamɓikea na bwali ka, ɓǝà yinǝ abare luí aban mǝtale; mbweban pa kàm ace girkusǝu mǝnana nyamɓikea bwali ko sàngi ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","<<Ɓǝ̀ ɓwa ak girkusǝu a bù ɓi ace mǝnana nǝ̀ pàngŋǝ̀nà túró nǝi, sǝ ɓè kǝgir mǝɓane kumi, ko wǔ, sǝ pà a mǝsǝ mǝtale raka, ɓwa mǝnana ak girkusǝunì ka, nǝ̀ mbwe mǝtale a kúnì. ");
INSERT INTO mbu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Sǝama ɓǝ̀ mǝtala girkusǝunì nakam a banì ka, ɓoaro ɓǝ̀ ɓwê mbwe ɗàng. Ɓǝ̀ yì girkusǝu ka à é nǝ â nǝ boalo ka, boalè nda boalo murí. ");
INSERT INTO mbu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","<<Ɓǝ̀ ɓwabura swár nsari mǝnana à malaká pur'amuri raka, sǝ nongnǝi ka, dumǝna púp nǝ̀ mbwe gǝna murí, à nǝ̀ do andǝi ɓǝ̀ duk māmí. ");
INSERT INTO mbu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Sǝ ɓǝ̀ tár mǝnia yì nsarì ɓinǝ pà muni ɓǝ̀ ɓwabure ali ka, kat andǝ amani ka, dumǝna púp ɓwabure nǝ̀ mbwe boalo mǝnana kārǝ arǝ gǝna múr nsari ka. ");
INSERT INTO mbu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","<<Ɓwama mǝnana kǝ pakkiagir nggár ka, kǝa ɗeki ɓǝ̀ dumnǝ yilǝmu ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","<<Ɓwa mǝnana kat nongnǝ girkusǝu ka, dumǝna púp à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","<<Ɓwa mǝnana kat pa gir'nkila aban ɓekǝ ɓakuli sǝ Yahweh na raka, à nǝ̀ tàrrì aban Ɓakuli ɓǝ̀ kìɗikì. ");
INSERT INTO mbu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","<<Cè wu nyesǝce ɓwa-kúnɗàngna ɓà ko wu ɓiki wi ɗàng. Wu ɗenyi ama wun gbal ɗiɗyal ka, wun nda ka amǝ'kúnɗàngna a nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","<<Wu kǝa pàkkî mā-lú ko káwá mǝɓane ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ɓǝ̀ a ɓǝmbǝria a koya buì, sǝ ɓǝ̀ à ɓua abanam ngga, dumǝna ama mǝ nǝ ok ɓua malea, ");
INSERT INTO mbu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","sǝ bumlulla mem nǝ̀ earki amur wun, mǝ nǝ wal-lú wun nǝ nggeabyau. Sǝ amālá wun nǝ̀ duk amā-lú, amuna wun nǝ̀ duk akáwá. ");
INSERT INTO mbu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","<<Ɓǝ̀ a pê kǝɓwa atà aɓwana mem mǝnana à nda aɓa tǝle ka, tangna boalo ka, cè a na ama awu nǝ é nǝ mur amurí kǝla pě mala amǝ'pa tangna ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ɓǝ̀ a ak nggubyau kùmsǝó mala ɓio mǝ'murkala a kún kǝgir mǝnana ak a buo ka, dumǝna púp, kaniama pwari nǝ̀ kpa ka, awu nǝ nyesǝi wi, ");
INSERT INTO mbu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","acemǝnana nǝ̀ gandǝ do ama, mǝno nda kǝ nggubyau kùmsǝó male. Lang sǝ nǝ̀ nong'ntullo yi mǝnana gìr'kùmsǝó pa a buì raka? Ɓǝ̀ a nyesǝi wi raka, sǝ ɓǝ̀ ɓua abanam ngga, mǝ nǝ ok ɓua male acemǝnana mǝ nda mǝ'sǝn mǝsǝswatǝr. ");
INSERT INTO mbu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","<<Cè a na mǝɓane amur Ɓakuli, ko a tsǝk kuno arǝ mǝ'yálmúr wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","<<Cè a dǝndi arǝ pam ɓoro mala ɓǝlagir mǝdǝmbe mala ɓaban mô, ko mala mùr-anap mò, ko mala mùrú-olif mò, mǝnana a tita kàmbe ka ɗàng. <<Amuna-dǝmba, amuna-burana ma'wun ngga, wun nǝ̀ pam mia. ");
INSERT INTO mbu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Sǝ amuna-dǝmba jamne mala andá, andǝ anzur, andǝ ambul-pǝndǝa ma'wun ngga wun nǝ̀ pam mia. Ɓǝ̀ jamna muna girkusǝu pángŋǝ̀nà nongŋo tongno-nong-ɓari atà nggè ka, wun nǝ̀ pam mi aɓa tongno-nong-tàruià nongŋo. ");
INSERT INTO mbu_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","<<Wun ngga wun nǝ̀ duk aɓwana mem mǝnana à tària ka. Wu kǝa li nyam girkusǝu mǝnana nyamɓawan wal-luí ka ɗang; wu túrì anvwa wì ɓǝà shè. ");
INSERT INTO mbu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","<<Cè a mesǝ acau na'ongŋale mǝ'nyirnì ɗàng, sǝ cè a pu a nzǝm mǝɓealɓikea nǝ nakún nyir ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","<<Kǝa pu atà bangula ɓwabundǝa ace pak gìr mǝnana mǝɓike na ka ɗàng. Ɓǝ̀ à tunǝo a nakún a ɓadǝm ɓashi ka, kǝa nakún nyir ace pu a nzǝm bangula ɓwabundǝa, wun nǝ̀ pūrǝ ɓashi a mgbasho ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Sǝ kǝa pu a nzǝm mǝ'tǝ̀r a ban ɓashi acemǝnana yì ka mǝ'tǝ̀r na ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","<<Ɓǝ̀ a yaki arǝ jamnda ko mǝdambǝriso mala ɓiomǝbura aban gya atà rǝì ka, bwali nyesǝî wi. ");
INSERT INTO mbu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","<<Ɓǝ̀ a sǝn mǝdambǝriso mala ɓwa, twalo gandǝì sǝ kpa ka, kǝa ɗeki ɗàng, bwalì wi kàm ɓǝ̀ lo, ko ɓǝ̀ ndo ama mǝtale kǝ ɓinǝmǝsǝo ka. ");
INSERT INTO mbu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","<<A pà wunǝ ɗeki kpata mǝsǝcau aɓa pàk ɓashi mala amǝ'tǝ̀r mò ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kǝa tsǝki kǝ ɓwa cau arǝì amur nyir ɗang. Kǝa kasǝ ɓashi-lú amur mǝ'kunpwasǝa ko mǝɓealɓoarna ɗang, acemǝnana ɓashi mem ngga nǝ̀ sulǝo amur ɓwa mǝnana pàk mǝno yì ɓealɓikea ka. ");
INSERT INTO mbu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","<<Cè a ak pàbunǝnzali ɗang, acemǝnana pàbunǝnzali ka, kǝ tsǝk ɓwa pà nǝ̀ falǝnǝ mǝsǝcau mǝnana kǝ sǝni a banfana ka ɗàng; sǝ ɗǝm ngga kǝ tsǝk amǝ'ɓashi ɓǝà pūrǝ ɓashi a mgbasho. ");
INSERT INTO mbu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","<<Wu kǝa nyesǝce ɓwa-kúnɗàngna ɓà, wu lǝmdǝì wi rǝcandǝa mala parban ɗang; wun nǝ nggearǝ wun ngga wu sùrǝ́nà mana nda do kǝla ɓwa-kúnɗàngna, acemǝnana ɗiɗyal ka wu nda ka amǝ'kúnɗàngna a nzali Masar. ");
INSERT INTO mbu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","<<Aɓalǝ apǝlǝa tongno-nong-mwashat ka, ɓealɓeale a ɓaban mô sǝ wu pwan gìr mǝnana ɓaban pusǝ ka. ");
INSERT INTO mbu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Sǝama a tongno-nong-ɓaria pǝlǝa ka, ɗeki ɓaban ɓǝ̀ usǝlǝo sǝ ɓǝ̀ nong búlí, sǝ kǝa pwan kǝgìr mǝnana gulo sǝ ɓǝl kàm aɓalǝi ka ɗàng; amǝ'tǝ̀r mǝnana aɓalǝ wun ngga, ɓǝà lì gìr mǝnana ɓǝ̀l a nkwalo ka; sǝ cili mǝnana à nyì ka, ɓǝ̀ anyam-bondo ɓǝà lì. Anggo sǝ awu nǝ pangnǝ aɓaban nggun-anap andǝ aɓaban nggun-olif mò. ");
INSERT INTO mbu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","<<Awu nǝ pàkki atúró mô aɓalǝ anongŋo tongno-nong-mwashat, sǝ tongno-nong-ɓaria pwari ka, awu nǝ usǝlǝì atúró mô; andá mô andǝ amǝdambǝriso mò gbal ka, ɓǝà usǝlǝo; kat andǝ aguro mô andǝ abǝri mǝnana à pàkkiyio túró ka, ɓǝ̀ rǝia pwalo. ");
INSERT INTO mbu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","<<Párkiro arǝ acau mǝnana Mim Yahweh ǝn banggo kat ka. Cè a pak hiwi aban kǝ ɓè ɓakuli ɗang; yàle ɓǝà kǝa ok lullǝia a kuno ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","<<A koya pǝlǝa ka, wun nǝ̀ pakkiɗire mala alamsan tàrú ace gusǝlǝ lullǝàm. ");
INSERT INTO mbu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Atà dǝmbe ka, wun nǝ̀ pàk Lamsan mala Bǝredi mǝnana Yis pà arǝì raka. Wu pè a njar mǝnana ǝn tsǝka wun nǝma ɓǝ̀ wu pè ka. Wun nǝ̀ twal anongŋo tongno-nong-ɓari a nzǝmarǝia mǝnana aɓalǝia ka, pà wu nǝ̀ shak bǝredi mǝnana à pè nǝ yis arǝì ka ɗàng. Koya pǝlǝa ka wun nǝ̀ nggǝ pak mǝnia yì lamsan ngga a pwari mǝnana ǝn kanì ka, aɓa zongŋo Abip, zongŋo mǝnana wu nyìngŋǝ̀nà Masar nǝi ka. <<Kǝ ɓwa ɓǝ̀kǝa yiu a peri abanam nǝ ɓabui atarǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","<<Ɓaria ka, wu pakkiɗire Lamsan mala Pwan Gìrɓaban; wu pè nǝ paɓoro mala aɓǝlagir mǝdǝmbe mala ɓeale mǝnana wu ɓeal a ɓaban ma'wun ngga. <<A masǝlǝate ka, wu pakkiɗire Lamsan mala Pwan Gìrɓaban Kat-kat aban yinǝe a ɓala a masǝlǝata koya pǝlǝa. ");
INSERT INTO mbu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","<<Koya pǝlǝa, ɓǝ̀ apwari mala amǝnia yì alamsan kārǝ́ ka, aburana ma'wun kat ka, à nǝ̀ yiu púp ace peri a ɓadǝmbam, Mim Yahweh Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","<<Wu kǝa pà nkila mala gir'nkila abanam nǝ bǝredi mǝnana à pè nǝ yis arǝì ka ɗàng. Sǝ mùrú-nyam girkusǝu mǝnana wu yinǝi à pàna gir'nkila nǝi ka, ɓǝ̀ kǝa nongŋo ban ɓǝ kwarí ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","<<Koya pǝlǝa ka, awu nǝ yinǝ banboàrné mala aɓǝlagir mǝdǝmbe mala ɓaban mô a ɓala mala Yahweh Ɓakuli mô. <<Cè a lam muna-mbul nǝ kiura nggè ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","<<Mǝ ndo mǝ nǝ tasǝ mǝturonjar a dǝm wun ɓǝ̀ yál wun a njar aban ká, sǝ ɓǝ̀ kyan nǝ wun a ban mǝnana ǝn gilǝkice ace wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Wu kwakikir wun arǝì sǝ wu kpata akwarkiru male. Wu kǝa mgbiki wi cau ɗàng, acemǝnana mǝ nda ǝn tasǝi ka, sǝ yì ka pà nǝ̀ twalban mgbikiru ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Sǝ ɓǝ̀ wun nǝ̀ kwakikir wun pepè, wun nǝ̀ kpata gì, sǝ wun nǝ̀ pàk gìr mǝnana kat ǝn bang ngga, mǝ nǝ duk ɓibura mala aɓiwun amǝbura, sǝ mǝ nǝ ɓinǝmǝsǝ amǝ ɓinǝmǝsǝ wun. ");
INSERT INTO mbu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mǝturonjar mem nǝ̀ ká a dǝm wun, sǝ nǝ̀ kánǝ wun a nzali mala amǝ'Amor, andǝ amǝ'Hitti, andǝ amǝ'Periz, andǝ amǝ'Kan'ana, andǝ amǝ'Hivi, andǝ amǝ'Jebus, ace mǝnana ɓǝ̀ wu kya duk kam ngga. Mǝ nǝ twaltea kat-kat. ");
INSERT INTO mbu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Wu kǝa ɓunno a nzali a ɓadǝm aɓakuli malea, ko wun nǝ̀ peri abania ɗàng. Wu kǝa kpata anjar mala pàkki agir kúncau malea ɗàng. Wu kìɗìki aɓakuli malea kat, wu arki akúnamúrú malea. ");
INSERT INTO mbu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","<<Kǝ Mim Yahweh Ɓakuli ma'wun, nda wun nǝ̀ peri abanam ngga! Mǝ nǝ tsǝka wun bù arǝ girlina ma'wun andǝ mùr-nùná ma'wun, sǝ mǝ nǝ twalban rǝkwana aɓalǝ wun. ");
INSERT INTO mbu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Muna pà nǝ̀ sulǝo arǝ kǝ ɓwama, ko à nǝ̀ kum nkombi aɓa nzali ma'wun ɗàng. Mǝ nǝ pà wun sauwa mala yilǝmu andǝ lùmsǝó male. ");
INSERT INTO mbu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","<<Mǝ nǝ tasǝ ɓangciu mem a ɓadǝm wun, sǝ aɓwana mǝnana wun nǝ̀ kùtí a nzali malea ka, mǝ nǝ yinǝ zùrǝki aɓalǝia. Mǝ nǝ tsǝk aɓiwun amǝbura ɓǝà pǝlǝà wun nzǝmia nǝ mire. ");
INSERT INTO mbu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mǝ nǝ tasǝ amǝ'ta-nta a ɓadǝm wun mǝnana à nǝ̀ pǝr amǝ'Hivi, andǝ amǝ'Kan'ana, andǝ amǝ'Hitti, aɓa ká ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pà mǝ nǝ pǝria aɓa pǝlǝa mwashat ɗang, ɓǝ̀ ana raka nzali nǝ nong atarǝì, anyamɓawan nǝ̀ hatǝki, à nǝ̀ pǝlǝà wun gìr ɓangciu. ");
INSERT INTO mbu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Bǝti-bǝti sǝ mǝ nǝ nggǝ pǝria, sheɓǝ̀ wu làkkìna wu akina nzali ka. ");
INSERT INTO mbu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mǝ nǝ tsǝk nzong-nzali ma'wun nǝ̀ twal a Nggeamùr mala Nzuno aban ká Nggeamùr mala amǝ Filisti, sǝ nǝ̀ twal a pǝɗanban aban ká Nggeasala Yiufǝretis. Mǝ nǝ pà wun rǝcandǝa amur aɓwapǝndǝa mǝnana à do a nzali mǝno ka, sǝ wun nǝ̀ pǝria a ɓadǝm wun. ");
INSERT INTO mbu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Wu kǝa kùr kǝ cau wunǝia, ko nǝ aɓakuli malea ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Wu kǝa ɗekia ɓǝà do a nzali ma'wun ɗàng; ɓǝ̀ wu ɗekia ka, à nǝ̀ dupa wun nggea gbǝ́lî mǝnana nǝ̀ tsǝk wun, wun nǝ̀ pàkkam cauɓikea, sǝ wun nǝ̀ peri aban aɓakuli malea ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yahweh banggi Musa ama, <<Yiu abanam amur nkono, we wunǝ Haruna, andǝ Nadap, andǝ Abihu, sǝ aɓwana-mǝgule lumi-tongno-nong-ɓari mala amǝ Isǝrayila. Ɓǝ̀ wu nda aban yiu zak ka, wu ɓunno a nzali aɓa peri abanam. ");
INSERT INTO mbu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","We nǝmurǝo ɓǝ̀rɓǝ̀r, na a nǝ yiu awu nǝ gbashì banam tù ka. Cili aɓwana ka, ɓǝà cam zak. Acili amǝ Isǝrayila ka ɓǝà kǝa na ama à nǝ̀ eauwe a nkono ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Lang Musa wario kya nea aɓwana acau mala Yahweh kat, andǝ anggurcaunì ka, aɓwana ak cau gǝu ama, <<Sǝm nǝ̀ kpata koya cau mana Yahweh na ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Pǝlǝa Musa gilǝ acau mala Yahweh kat. Ban nǝ fa nǝ dǝmbari ɗiɗyal ka, lo ɓak gyangŋan a kusǝ nkono, sǝ loasǝ akúnamúrú lum-nong-ɓari, mǝnana koya tali mwashat ka kǝ cam a kúnì koya tàu lum-nong-ɓari mala amǝ Isǝrayila ka. ");
INSERT INTO mbu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pǝlǝa tasǝ alaggana mala amǝ Isǝrayila, à kya pākiagir mala pisǝe kǝring, sǝ à pà gir'nkila nǝ ajamnda ace apagir mala dotarǝu aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa twal gauwa-tsùrú mala nkila mala agirkusǝu mǝnana à ɗārǝia ka, solǝi aɓalǝ ankenye, sǝ cili ka watsǝki amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Pǝlǝa twal Malǝmce Kùrcau sǝ ɓallì aɓwana wi ɓǝà oè. Sǝ aɓwana pà eare ama, <<Sǝm nǝ̀ kpata cau mǝnana kat Yahweh na ka, sǝm nǝ̀ oki wi.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa pǝlǝa twal nkila mana aɓalǝ ankenye ka, sǝ watsǝki aɓwana arǝia, sǝ bang ama, <<Wu sǝni, kùrcau mǝnana Yahweh pang nǝ wun, mana pà wun amǝnia yì anzongcau ka, ndya kǝ kùrrì nǝ nkila mǝnia ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa andǝ Haruna, andǝ Nadap, andǝ Abihu, sǝ aɓwana-mǝgule lumi-tongno-nong-ɓari mala amǝ Isǝrayila, à eauwe amur nkono, ");
INSERT INTO mbu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","sǝ à sǝn Ɓakuli mala amǝ Isǝrayila. Aɓata akusǝi ka, ɓè kǝgìr kǝla múrbân mala tali-gǝna mala safir; kwár gǝraɗau kǝla ɓamǝsǝ kuli. ");
INSERT INTO mbu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kat andǝ amani ama amǝnia yi aɓwana-mǝgule mala amǝ Isǝrayila sǝn Ɓakuli ka, loasǝ buì arǝia ɗàng. Yàle à lìli sǝ à nugìr atārǝia a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yahweh banggi Musa ama, <<Eauwe yiu abanam amur nkono sǝ wu duk kani. Mǝ nǝ po akpamgbǝlang tali ɓari mǝnana ǝn gilǝ nggurcau andǝ anzongcau mem amuria ace mǝnana wu kanì aɓwana mem ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nda Musa lo atārǝia andǝ Jesǝwa mǝbwali wi túró, sǝ Musa eauwe o amur nkono mala Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa ka angŋa dǝmba bangŋǝ́nì aɓwana-mǝgule ama, <<Wu kundǝ sǝm a ban mǝnia ka sheɓǝ̀ sǝm nyarna aban wun ngga. Haruna andǝ Hur ka à ndya kani atà wun ngga. Ɓwa mǝnana kat ndanǝ ɓekǝ cau wuliban, anzǝm mǝnana sǝm umǝna ka, ɓǝ̀ kyan nǝ cê a bania.>> ");
INSERT INTO mbu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pǝlǝa Musa eauwe o a kùli amur Nkono Saina, kara pǝrɓang yi gir múr nkono. ");
INSERT INTO mbu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Tǎlaban mǝɓoarɓwe mala Yahweh yi sulǝo amur Nkono Saina, sǝ pǝrɓang gìr múrí anongŋo tongno-nong-mwashat. A tongno-nong-ɓaria pwari ka, Yahweh tunǝ Musa nǝ ɓá pǝrɓang. ");
INSERT INTO mbu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","A ban amǝ Isǝrayila a kusǝ nkono ka, à sǝn tǎ mala ɓoarɓwa mala Yahweh ka nda kǝla bǝsa mǝ'earke mǝnana kǝ lì gìr ka, a ɓong nkono ");
INSERT INTO mbu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Pǝlǝa Musa eau aban ká amur nkono sǝ kya kúti aɓa pǝrɓang. Akanó sǝ kya do pàk pwari lumi-ine andǝ du lumi-ine. ");
INSERT INTO mbu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","<<Ne amǝ Isǝrayila ama ɓǝà yinǝ aɓoro ɓǝà yi pa abanam. Ak gìr mǝnana ɓwa twalo a ɓabumi sǝ yinǝi nǝ̀ pà acem ngga. ");
INSERT INTO mbu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Amǝnia ka à nda ka aɓoro mǝnana awu nǝ ak a buia ka: bolo-njengǝlan, bolo-azǝrfa, andǝ bolo-bángŋá; ");
INSERT INTO mbu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe; nkonggúr-linǝn mǝɓǝlke mana à pyauwì ka, andǝ nggubyau nyang-mbulpǝndǝa; ");
INSERT INTO mbu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","nggú gam mǝnana à bàngsǝí ka; nggú mǝɓǝlke mala ambulpǝndǝa; kpamgbang mala nggun-akasiya; ");
INSERT INTO mbu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mùrú olif ace tsǝk bǝsa arǝ pitǝla; amuku-gìr mǝ'kuskushi mǝnana à nǝ̀ kpapi andǝ mùrú olif ace ɗārǝâ, sǝ ace kpapè andǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","amunatali-onis, andǝ amǝsǝtali-gǝna ace gilǝkice rǝ efot andǝ lǝpan-damɓalǝu male. ");
INSERT INTO mbu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","<<Tsǝk amǝ Isǝrayila ɓǝà pàk Tara-mǝfele acem, ace mǝnana ɓǝ̀ ǝn do aɓalǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pàk mǝnia yì Tara-mǝfele ka andǝ agir ɓālǝi kat aɓa kpate a nzongni gǝ̀rgǝ̀r, kǝla karikè mala Taragula mǝnana mǝ nǝ lǝmdǝò ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","<<Tsǝk aɓwana ɓǝà gbàllì Akwati Kùrcau nǝ kpamgbang mala nggun-akasiya. Sauwa male ɓǝ̀ pàk ɓakusǝu tàrú nǝ incì tongno-nong-ine, tangŋa male ɓǝ̀ pàk ɓakusǝu ɓari nǝ incì tàrú, sǝ dāh'rya male ɓǝ̀ pàk ɓakusǝu ɓari nǝ incì tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne, ɓālǝi andǝ nzǝmi; ɓak bolo-njengǝlan ɓǝ̀ kàrì kúni kat. ");
INSERT INTO mbu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tùl agbalmò ine mala bolo-njengǝlan aceì, sǝ kpapì mwashat arǝ nkanggariban mala koya kusǝ akwati. ");
INSERT INTO mbu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Shàr agara mala nggun-akasiya, sǝ wu gir rǝia kat nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Oasǝ agare aɓalǝ agbalmò arǝ ankanggariban mala akwati ace twale. ");
INSERT INTO mbu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Amǝnia yì agara ace twal akwati ka ɓǝà ɗekia kàm aɓalǝ agbalmò arǝ akwati; ɓǝà kǝa pusǝia ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Awu nǝ tsǝk Acau-nakûn mǝnana mǝ nǝ po ka aɓa mǝnia yì akwati ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","<<Awu nǝ pàkkî Akwati gìrkúni male, mǝnana nda buno sǝntǝ̀r ka, nǝ bolo-njengǝlan mǝɓoarne kat. Sauwa male ɓǝ̀ pàk ɓakusǝu tàrú nǝ incì tongno-nong-ine, tangŋa male ɓǝ̀ pàk ɓakusǝu ɓari nǝ incì tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Awu nǝ tùl aɓǝ̀nzál mala acerup ɓari nǝ bolo-njengǝlan mǝnana à walki ka, ɓǝà came arǝ akún-bân ɓari amur gìrkúni, mǝnana nda buno sǝntǝ̀r ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tsǝk ɓè cerup ɓǝ̀ came a ɓè kún-bân amur gìrkún Akwati sǝ ɓè cerup ka tsǝì a nkāɓe ɓì a kún-bân. Bolo-njengǝlan mǝnana à nǝ̀ peǎ nǝi ka ɓǝ̀ kpapi arǝ bolo-njengǝlan mǝnana à nǝ̀ pàngŋǝ̀nà gìrkún Akwati nǝi ka, ace mǝnana ɓǝà duk mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Acerup ka tsǝia, komǝye ka ɓamǝsǝi ɓǝ̀ pǝlǝ nǝban ɓamǝsǝ ɓi. Ɓamǝsǝia ɓǝà kǝ sǝn múr gìrkún Akwati, sǝ abuia mǝnana à mǝn a kùli ka ɓǝà kùmsǝó amur gìrkún Akwati, yì buno sǝntǝ̀r. ");
INSERT INTO mbu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Acau-nakûn mǝnana mǝ nǝ pò ka, awu nǝ tsǝia aɓa Akwati, sǝ awu nǝ kùmsǝ̀ gìrkún Akwati amúrià. ");
INSERT INTO mbu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Mǝ nǝ nggǝ je sǝnǝ we kano, a nre ka ɓǝ̀nzál acerup ɓari, mǝnana à nda amur gìrkún Akwati, yì buno sǝntǝ̀r ka, sǝ mǝ nǝ banggo cau nǝ kuli, acau mala nzongcau mana kat ǝn nggǝ pò ace amǝ Isǝrayila ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","<<Awu nǝ gballì kpamgbang mala nggun-akasiya, ace tsǝk agir amurí; sauwa male ɓǝ̀ pàk ɓakusǝu tàrú, tangŋa male ɓǝ̀ pàk ɓakusǝu mwashat nǝ incì tongno-nong-mwashat, sǝ dāh'rya male ka ɓǝ̀ pàk ɓakusǝu ɓari nǝ incì tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Awu nǝ gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne, sǝ a nǝ ɓak kúní ɓǝ̀ kàrì nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Múr kpamgbang mana sárǝ́ ka, awu nǝ pàkki wi mǝ-nzong mǝnana nyane male ka incì tàrú na ka ɓǝ̀ kàrì kúní kat, sǝ wu ɓak bolo-njengǝlan ɓǝ̀ kàrì mǝ-nzong nì. ");
INSERT INTO mbu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Awu nǝ tùl agbalmò ine nǝ bolo-njengǝlan aceì, sǝ awu nǝ kpapia arǝ abankara male ine, arǝ akusǝi ine. ");
INSERT INTO mbu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Agbalmò mǝnia mana à nda ace bwal agara mǝnana à nǝ̀ nggǝ twalna kpamgbang-tsǝk-agir nǝia ka, tsǝia arǝ akusǝ kpamgbang ɓǝà gbashì ban nzong kúni. ");
INSERT INTO mbu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Awu nǝ pàk agara twal kpamgbang-tsǝk-agir nǝ nggun-akasiya, sǝ awu nǝ gìr rǝia kat nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Awu nǝ pàk aparanti male, andǝ acembe male, andǝ amuna-nkenye male, andǝ amuna-bàng male ace solǝ pàgir mala girnùná; awu ne pea nǝ bolo-njengǝlan mǝɓoarne. ");
INSERT INTO mbu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Awu nǝ tsǝk Bǝredi mala Ɓadǝm Yahweh, mǝnana à pànà ɓoro nǝi abanam ngga amur kpamgbang a ɓadǝmbam koya pwari. ");
INSERT INTO mbu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","<<Awu nǝ pàk gìr tàmsǝ apitǝla nǝ bolo-njengǝlan mǝɓoarne. Kusǝ gìr tàmsǝ apitǝla, andǝ garè mǝnana cam a ɓaɓalǝu, andǝ nyoulǝa rǝi mǝnana kǝla tǒ mala fufe nǝ pwasǝe andǝ tǝ́r-fufe ka, awu nǝ̀ pè kat nǝ gumtǝli bolo-njengǝlan mwashat mǝnana à walki ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Pàk garè ɓǝ̀ pàngnǝ abui tongno-nong-mwashat mǝnana à san arǝ ankanggari ka; tàrú a nkanggari man sǝ tàrú a ɓè nkanggari. ");
INSERT INTO mbu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Komǝye atà abui tongno-nong-mwashat ka, ɓak rǝì ɓǝ̀ lǝmdǝ nyoulǝa tǒ mala afufe tàrú mala nggun-almon, sǝ koya fufe ka ɓǝ̀ pàngnǝ pwasǝe andǝ tǝ́r-fufe male. ");
INSERT INTO mbu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ɓak rǝ gìr tàmsǝ apitǝla ɓǝ̀ lǝmdǝ nyoulǝa mala afufe ine mala nggun-almon nǝ apwasǝe andǝ atǝ́r-fufe malea. ");
INSERT INTO mbu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nyoulǝa tǝ́r-fufe mwashat ka nǝ̀ pa a ban-kpapí mala ɓari atà abu gìr tamsǝ apitǝla; ɓaria nyoulǝa tǝ́r-fufe ka nǝ̀ pa a ban-kpapí mala aɓea abui ɓari, sǝ tàruià nyoulǝa tǝ́r-fufe ka nǝ̀ pa a ban-kpapí mala masǝlǝata abui ɓari, mǝnana yià kat à sana arǝ gara gìr tàmsǝ apitǝla ka; anggo sǝ gìr tàmsǝ apitǝla ka nǝ̀ pàngnǝ abui tongno-nong-mwashat mǝnana à san arǝ garè ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Yì gìr tàmsǝ apitǝla andǝ nyoulǝa rǝi mala afufe andǝ apwasǝe andǝ atǝ́r-fufe ka, à nǝ̀ pea kat nǝ gumtǝli bolo-njengǝlan mǝɓoarne mwashat mǝnana à walki ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","<<Awu nǝ pàk apitǝla tongno-nong-ɓari ace gìr tàmsǝ apitǝla, sǝ wu tamsǝkia amur garè andǝ abui tongno-nong-mwashat, ace mǝnana ɓǝà pa tǎlaban a banfana mana a ɓadǝmbi ka. ");
INSERT INTO mbu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Amǝmyal (mala kǝtǝriki tú kún bùgìr-bǝsa) andǝ atasau-bǝsa ka, ɓǝà peǎ nǝ bolo-njengǝlan mǝɓoarne. ");
INSERT INTO mbu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Pàktúró nǝ bolo-njengǝlan mǝɓoarne mǝnana dǝmbǝrya male ka tyang lumi-tàrú-bwamdǝ-tongno 35 na ka sǝ wu pàk gìr tàmsǝ apitǝla andǝ agirtúró male kat. ");
INSERT INTO mbu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","<<Tsǝkiro wu pak agir man kat aɓa kpate a nzongni kǝla mǝnana ǝn lǝmdǝò amur nkono ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","<<Sǝ Taragula mǝnana awu nǝ pàk ka, pàk ɓālǝi nǝ alagìr lum mǝnana à teǎ nǝ nkonggúr-linǝn mana à pyauwì ka andǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe. Mǝ'sǝlǝ pakkiagir ɓǝ̀ peǎ sǝ ɓǝ̀ tà pǎ mala acerup ɓǝà lǝmdǝa arǝia. ");
INSERT INTO mbu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Amǝnia yì alagìr lum ngga, ɓǝà kārǝa; sauwa malea ɓǝ̀ pàk ɓakusǝu lumi-ine nǝ mǝsǝi ɓari, sǝ tangŋa malea ka ɓǝ̀ pàk ɓakusǝu tongno-nong-mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tongno atà alagìr mǝnia ka, awu nǝ kpapia sǝ awu nǝ swària a kunarǝia ɓǝà duk lagìr mǝsauwe mwashat. Anggo gbal sǝ awu nǝ pangnǝ acilia mǝno tongno ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Awu nǝ pakkì atǝkrǝk nǝ nkonggúr ɗà'ndíng mǝlùre sǝ awu nǝ ɗúrkia a nkanggari arǝia a gírí-kún komǝye atà alagìr mǝsake mǝno ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Awu nǝ ɗúrki atǝkrǝk nkonggúr lumi-tongno a gírí-kún mwashat atà alagìr amǝsake mǝno ka; anggo gbal ɓè man mwashat ka ɗúrkì wi atǝkrǝk nkonggúr male lumi-tongno mǝnana à nǝ̀ cam a nkāɓe gǝ̀rgǝ̀r andǝ amǝno à ɗúrkia arǝ gírí-kún lagìr mǝdǝmbe ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Awu nǝ pàk anlǐ-bwalkúngir lumi-tongno nǝ bolo-njengǝlan. Bwalki atǝkrǝk gírí-kún lagìr mǝsauwe man mwashat ka, wu kpapia a kúnarǝ atǝkrǝk gírí-kún ɓe lagìr mǝsauwe mǝno ka nǝ anlǐ-bwalkúngir, ace mǝnana yì alagìr mǝsake ka ɓǝà duk mwashat. Anggo sǝ nǝ̀ do ama Taragula ka, lagìr mwashat na à pè nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","<<Awu nǝ pàk alagìr-nggû nǝ anggu-mbulpǝndǝa lum-nong-mwashat ace kùmsǝ múr Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Amǝnia yì anggu-mbulpǝndǝa lum-nong-mwashat ka ɓǝà kārǝa; sauwa mala komǝye ka ɓǝ̀ pàk ɓakusǝu lumi-ine bwamdǝ tongno, sǝ tangŋa mala komǝye ka ɓǝ̀ pàk ɓakusǝu tongno-nong-mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tongno ateà ka awu nǝ kpapia sǝ awu nǝ swària a kunarǝia ɓǝà duk lagìr-nggû mǝsauwe mwashat, sǝ aman tongno-nong-mwashat ka swària gbal a kunarǝia ɓǝà duk ɓaria lagìr-nggû mǝsauwe mwashat. Tongno-nong-mwashatia nggu-mbulpǝndǝa mǝnana masǝlǝì aɓî a kún lagìr-nggû mǝnia ka, kàrrì aɓalǝarǝia ɓari ɓǝ̀ gyare a ɓadǝm Tara-mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Awu nǝ ɗúrki atǝkrǝk nkonggúr lumi-tongno a nkanggari arǝia a gírí-kún komǝye atà alagìr-nggû amǝsake mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Awu nǝ pàk anlǐ-bwalkúngir nǝ bolo-bángŋá, yia lumi-tongno. Awu nǝ oasǝkia aɓalǝ atǝkrǝk gírí-kún alagìr-nggû amǝsake mǝnia ɓari ka, sǝ awu nǝ kpapia a kúnarǝia ɓǝà duk lagìr-nggû nggea mǝgule mwashat, ace mǝnana ɓǝà gìrna múr Tara-mǝfele nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Cili lagìr-nggû mǝnana ueo sǝ à lǝpì ka, ɓǝà nyesǝi ɓǝ̀ gyare a nzǝm Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Cili sauwa mala lagìr-nggû, ɓakusǝu mwashat nǝ incì tongno-nong-mwashat mǝnana ueo sǝ sùlǝî múr Taragula a koya bumban male ka, nyia ɓǝa gyare arǝ abumban, ace mǝnana ɓǝà gìr múr Taragula kat-kat. ");
INSERT INTO mbu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","<<Awu nǝ pàk aɓea lagìr-nggû kàm ɓari ɗǝm ace kùmsǝ múr Taragula. Man mwashat ka pè nǝ nggú ka gam mǝnana à bangsǝi ka, sǝ ɓè man, mǝnana nǝ̀ masǝlǝi aɓî nǝ̀ sarǝa amúrià a kùli ka, pè nǝ nggú mǝɓǝlke mala ambulpǝndǝa. ");
INSERT INTO mbu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","<<Awu nǝ̀ pàk anggun-tara ace Taragula nǝ akpamgbang mala nggun-akasiya mǝnana à sárǝ́ pǝrapǝra ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Koya nggun-tara ka dāh'rya male ɓǝ̀ duk ɓakusǝu lum-bwamdǝ-tongno, sǝ tangŋa male ka, ɓǝ̀ duk ɓakusǝu ɓari nǝ incì tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Akpamgbang ɓari nǝ kúnià kǝla ankpako na awu nǝ kpapia a nkanggari rǝarǝia ɓǝà pàk nggun-tara mwashat ka. Anggo sǝ awu nǝ pàk anggun-tara mala Taragula kat. ");
INSERT INTO mbu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Awu nǝ pàk anggun-tara lumi-ɓari ace bumban mala Taragula mǝnana sǝn njar-kunmur ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Awu nǝ pàk agumtǝli-tǝrtà anggun-tara lumi-ine nǝ bolo-azǝrfa. Agumtǝli-tǝrtè ɓari, komǝye ka nǝ tūli male arǝì, à nǝ̀ pà aɓata koya nggun-tara, ace bwal akusǝ akpamgbang amǝ pyalpyalni ɓari mala nggun-tara. ");
INSERT INTO mbu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A bumban mala Taragula mǝnana sǝn njar-nza ka, awu nǝ tsǝk anggun-tara lumi-ɓari, ");
INSERT INTO mbu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","aɓalǝ agumtǝli-tǝrteà mǝnana à pea nǝ bolo-azǝrfa ka lumi-ine, ɓari a kusǝ koya nggun-tara. ");
INSERT INTO mbu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Sǝ a nzǝm Taragula, yì bumban male mǝnana sǝn njar-nzali ka, awu nǝ̀ tsǝk anggun-tara kam tongno-nong-mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Awu nǝ pàk aɓea nggun-tara ɓari ɗǝm ace koya bankara a nzǝm Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Anggun-tara ɓari-ɓari mǝnana à nǝ̀ cam a koya bankara a nzǝm Taragula ka, awu nǝ kpapi tǝrtea ɓǝà cam a ban mǝ'mwashati, sǝ múrià ka kùria nǝ gbalmo kàngkàng ɓǝà duk mwashat. Yì anggun-tara arǝ abankara mǝno ɓari ka anggo sǝ awu nǝ pangnǝia. ");
INSERT INTO mbu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Lǝmdǝ ama ɓǝà kpapia kat ka, nzǝm Taragula nǝ̀ pangnǝ anggun-tara tongno-nong-tàrú aban came aɓalǝ agumtǝli-tǝrteà lum-bwamdǝ-tongno-nong-mwashat, mǝnana à peǎ nǝ bolo-azǝrfa ka; koya nggun-tara ka, kusǝi nǝ̀ pà aɓalǝ agumtǝli-tǝrtè ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","<<Awu nǝ pàk anggun-gangndea lum-bwamdǝ-tongno nǝ akpamgbang mala nggun-akasiya ace kpapiki anggun-tara. Tsǝk tongno ɓǝà kpapi anggun-tara mala Taragula a bumban male mǝnana sǝn njar-nza ka, ");
INSERT INTO mbu_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","tongno ɓǝà kpapi anggun-tara a bumban mala Taragula mǝnana sǝn njar-kunmur ka, sǝ tongno ka ɓǝà kpapi anggun-tara a bumban mala Taragula a nzǝmi, yì bumban mǝnana sǝn njar-nzali ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Nggun-gangndea mǝnana nǝ̀ gangndǝi a tsùrú mala anggun-tara ka, nǝ̀ tite arǝ nggun-tara mǝnana nda a masǝlǝata kún-bân, sǝ nǝ̀ sarǝa aban ká ɓè masǝlǝata kún-bân mala Taragula ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Anggun-tara ka awu nǝ tasǝ rǝia nǝ bolo-njengǝlan, sǝ awu nǝ kùrkia wia agbalmò bolo-njengǝlan ace bwal anggun-gangndea mǝnana à nǝ̀ oasǝkia aɓalǝia ka. Yià anggun-gangndea ka awu nǝ tasǝ rǝia gbal nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Awu nǝ loasǝ mǝnia yì Taragula ka a pě mǝnana ǝn lǝmdǝo amúr nkono ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","<<Awu nǝ pàk lagìr-kasǝbân nǝ nggubyau-linǝn ace gau ɓá Taragula. Ɓwa mǝ'sǝlǝ pakkiagir ɓǝ̀ pàktúró nǝ nkonggúr ɗà'ndíng, mǝlùre, mǝwanye, andǝ mǝbangŋe andǝ mala nkonggúr-linǝn mǝɓǝlke mana à pyauwì ka, ɓǝ̀ tagìr mala acerup ɓǝà lǝmdǝ arǝì. ");
INSERT INTO mbu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Awu nǝ gyar mǝnia yì lagìr-kasǝbân ngga, nǝ anlǐ-gyargìr mala bolo-njengǝlan, a kún anggun-ɓalǝu ine mala kpamgbang-akasiya, mǝnana à tasǝ rǝia nǝ bolo-njengǝlan, sǝ à camgi aɓalǝ agumtǝli-tǝrteà mala bolo-azǝrfa ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Awu nǝ bwalki kún lagìr-kasǝbân mǝnia ka nǝ anlǐ-bwalkúngir ɓǝ̀ gyare a kùli arǝ múr Taragula, sǝ awu nǝ tsǝk Akwati mala Acau-nakûn aɓalǝi nǝ nzǝm lagìr-kasǝbân, mǝnana gau Ban Mǝfele andǝ Ban Nggea Mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Awu nǝ tsǝk gìrkún Akwati mala Acau-nakûn, mǝnana nda buno sǝntǝ̀r ka, amur Akwati Kùrcau sǝ awu nǝ tamsǝì aɓa Ban Nggea Mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","A nza nǝ Ban Nggea Mǝfele aɓa Taragula ka, awu nǝ tsǝk kpamgbang mala tsǝk bǝredi ɓǝ̀ came a nkanggariban nǝ njar-nza; sǝ a nkāɓe male nǝ njar-kunmur ka, awu nǝ tsǝk gìr tàmsǝ apitǝla. ");
INSERT INTO mbu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","<<Awu nǝ pàk lagìr-gbarban ace bankutio aɓa mǝno yì tara ka. Pè nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì ka. Ɓwa mǝ'sǝlǝ tagìr nǝ bù ɓǝ̀ nbákí rǝì nǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe. ");
INSERT INTO mbu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Awu nǝ pàk anggun-ɓalǝu nǝ kpamgbang-akasiya amǝsake tongno, sǝ awu nǝ tasǝ rǝia nǝ bolo-njengǝlan. Awu nǝ tamsǝ komǝye ka aɓa gumtǝli-tǝrtè mǝnana à pè nǝ bolo-bángŋá ka, sǝ awu nǝ gyar mǝnia yì lagìr-gbarban ngga arǝia nǝ anlǐ-gyargìr mala bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","<<Awu nǝ pàk gyangŋan nǝ nggun-akasiya. Sauwa male nǝ̀ duk ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú, tangŋa male, ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú, sǝ dāh'rya male ka ɓakusǝu ine nǝ gauwa-tsùrú. ");
INSERT INTO mbu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Sǝ awu nǝ pàkki wi anjawe arǝ agirikúní ine. Yì gyangŋan andǝ anjawe ka shària nǝ nggun mǝmwashati, sǝ wu gir rǝi kat nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Awu nǝ pàk ankwaring-bolo ace pwan tú male, andǝ ashebǝl, andǝ ankenye, andǝ ashokali-nyama, andǝ atasau-bǝsa. Amǝnia yì agirtúró kat ka, awu nǝ peǎ nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Awu nǝ pàk bàndà nǝ waya mala bolo-bángŋá, sǝ awu nǝ̀ tsǝki wi agbalmò bolo-bángŋá ine arǝ abankara male a kúní ace bwale. ");
INSERT INTO mbu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Awu nǝ tsǝk mǝno yì bàndà ka aɓa gyangŋan, a bumi nǝ ɓalǝu. ");
INSERT INTO mbu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Awu nǝ pàk agara ɓari nǝ nggun-akasiya, sǝ wu gir rǝia nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Komǝye ka oasǝi aɓalǝ atūli gbalmò ɓari a ban ankanggari gyangŋan, ace twale. ");
INSERT INTO mbu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Yì gyangŋan ngga pè nǝ akpamgbang; nying ɓālǝi ɓǝ̀ nong horondong. Pè kǝla mǝnana à lǝmdǝò amur nkono ka. ");
INSERT INTO mbu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","<<Awu nǝ kasǝ patal ɓǝ̀ kàrì Taragula. A bumban male mana sǝn njar-kunmur ka, gyarki wi alagìr mǝnana à teǎ nǝ nkonggúr linǝn mǝɓǝlke mana à pyauwì ka; sauwa malea ɓǝ̀ pàk ɓakusǝu gbǝman-mwashat nǝ lumi-tongno (150), sǝ ɓǝà gyarki arǝ ");
INSERT INTO mbu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","anggun-kala male lumi-ɓari aban camge aɓalǝ agumtǝli-tǝrteà lumi-ɓari, mana à peǎ kat nǝ bolo-bángŋá ka; sǝ anggun-kala andǝ ankò malea, andǝ anlǐ-gyargìr mana à bwal alagìr ka, ɓǝà peǎ nǝ bolo-azǝrfa. ");
INSERT INTO mbu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Anggo gbal, a bumban mǝnana sǝn njar-nza ka, à nǝ̀ gyarki alagìr mǝnana sauwa malea ka ɓakusǝu gbǝman-mwashat nǝ lumi-tongno na (150) ka, arǝ anggun-kala lumi-ɓari, aban camge aɓalǝ agumtǝli-tǝrteà, mǝnana yià kat ka, bolo-bángŋá na à peǎ nǝia ka. Anlǐ-gyargìr mana à bwal alagìr, arǝ anggun-kala andǝ ankò malea ka, ɓǝà peǎ nǝ bolo-azǝrfa. ");
INSERT INTO mbu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","<<Bumban mala patal a buì mǝnana nǝ njar-nzali ka, awu nǝ gyarki alagìr mana sauwa malea ka, ɓakusǝu lumi-tongno-nong-ɓari bwamdǝ tongno (75) na ka, arǝ anggun-kala male lum mǝnana à camgi aɓalǝ agumtǝli-tǝrteà lum ngga. ");
INSERT INTO mbu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Bumban mǝnana nǝ njartakuli, ban kutio a patal mala Taragula ka, sauwa male gbal ka ɓǝ̀ pàk ɓakusǝu lumi-tongno-nong-ɓari bwamdǝ tongno. ");
INSERT INTO mbu_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Lagìr mǝnana nǝ̀ gyar a buì mǝlì mala kunɓala ka, tangŋa male ɓǝ̀ pàk ɓakusǝu lumi-ɓari-nong-ɓari nǝ gauwa-tsùrú, sǝ ɓǝ̀ gyare arǝ anggun-kala tàrú aban came aɓalǝ agumtǝli-tǝrteà tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Lagìr mǝnana nǝ̀ gyar a buì mǝ'nggare ka, tangŋa male ɓǝ̀ pàk ɓakusǝu lumi-ɓari nong-ɓari nǝ gauwa-tsùrú, sǝ ɓǝ̀ gyar arǝ anggun-kala tàrú aban came aɓalǝ agumtǝli-tǝrteà tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","<<Bankutio aɓa patal ka, kumbi wi lagìr gbare mǝnana tangŋa male ka ɓǝ̀ pak ɓakusǝu lumi-tàrú. Ɓǝà tè nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì ka, sǝ ɓǝà nyoulǝ rǝi aɓa sǝlǝ tagìr mǝɓoarsǝne nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe. Gyari arǝ anggun-kala ine mǝnana à came aɓalǝ agumtǝli-tǝrteà ine ka. ");
INSERT INTO mbu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Anggun-kala mǝnana kat à kàrì patal ka, ɓǝà camgi aɓalǝ agumtǝli-tǝrteà mala bolo-bángŋá. Gangndǝki agara bolo-azǝrfa amur anggun-kala kat sǝ wu kùrkia arǝarǝia. Tsǝkia wia anlǐ-gyargìr malea mǝnana à peǎ nǝ bolo-azǝrfa ka. ");
INSERT INTO mbu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Yì patal kat ka, sauwa male ɓǝ̀ pak ɓakusǝu gbǝman nǝ lumi-tongno (150), sǝ tangŋa male ka ɓakusǝu lumi-tongno-nong-ɓari nǝ mǝsǝi tongno (75). Dāh'rya mala alagìr male mǝnana à nǝ̀ gìr ban ngga, ɓǝ̀ pàk ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú (7.5). Ɓǝà peǎ nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì ka. Agumtǝl-tǝrtà anggun-kala ka, ɓǝà peǎ nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Agir mǝnana kat à nǝ̀ pàngŋǝ̀nà túró nǝia ace túró ɓá Taragula, ko ɓǝ̀ mǝye nda túró malea ka, andǝ ankpako male, andǝ ankpako mala anggun-kal patal ka, dumǝna púp à nǝ̀ peǎ nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","<<Banggi amǝ Isǝrayila ɓǝà yinǝo nǝ mùrú olif mǝɓoarne mǝnana à kambi nǝ kamba ka ace soe aɓa pitǝla, ace mǝnana abǝsa male ka ɓǝà kǝ earke koya pwari. ");
INSERT INTO mbu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haruna andǝ amuni, na à nǝ̀ tamsǝ pitǝla a ɓadǝmbam aɓa Tara Ban-peri, anzǝm lagìr-kasǝbân mǝnana gbàr Akwati mala Acau-nakûn ngga, sǝ à nǝ̀ nggǝ tsǝkir pitǝla ace mǝnana abǝsa male ɓǝà kǝ earke a ɓadǝmbam, twal a koya pwarikpǝra bà kwaro mala ban. Mǝnia yi nzongcau ka, dumǝna púp amǝ Isǝrayila andǝ amǝ'keà arǝ anza malea kat à nǝ̀ kpate. ");
INSERT INTO mbu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","<<Túrban ɓǝ̀ mǝ'eambo Haruna andǝ amuna-burana male, Nadap, andǝ Abihu, andǝ Eleaza, sǝ Itamar atè, ɓǝà yiu a bano. Pusǝia a nggǝsanì aɓalǝ amǝ Isǝrayila. Tsǝia ɓǝà duk apǝris ace pakkam túrô. ");
INSERT INTO mbu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","<<Awu nǝ swàrî mǝ'eambo Haruna adaura mǝfele mala apǝris, amǝ'ɓoarɓwe andǝ amǝ'ɓoarsǝne. ");
INSERT INTO mbu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Awu nǝ nacau ne aɓwana mǝnana kat amǝ'sǝlǝ pakkiagir na ka, aɓwana mǝnana ǝn pania wia sǝlǝe a ɓabumia ka, ɓǝà pakkî Haruna agir-nggūrǝu, ace tàre ɓǝ̀ duk pǝris aɓa túró mem.>> ");
INSERT INTO mbu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Amǝnia ka à nda ka agir-nggūrǝu mǝnana à nǝ̀ swària ka: lǝpan-damɓalǝu, andǝ efot, andǝ daura-tsuru mǝsauwe mala efot, andǝ daura-ɓaɓalǝu mǝlime mǝnana à nyoulǝ rǝi nǝ tagìr mǝɓoarsǝne ka, andǝ nggubyau mbuɓi múrû, sǝ bugìr mārǝ́ taɓunu. Ɓǝà pàk amǝnia yì adaura mǝfele ka ace mǝ'eambo Haruna andǝ amuni amuna-burana, ace mǝnana ɓǝà nyesǝia ɓǝà duk apǝris ace pakkam túrô ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Amǝ'túró amǝ'sǝlǝ pakkiagir ɓǝà ak nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala bolo-njengǝlan, sǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì nǝ pyauweka, ace pàk adaura mǝno. ");
INSERT INTO mbu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","<<Muna daura-múrɓì mǝfele, yì efot ka ɓwa mǝ'sǝlǝ pakkiagir ɓǝ̀ tè nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì nǝ pyauwe ka; ɓǝ̀ tà gìr mǝɓoarsǝne arǝì nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Yì efot ka ɓǝà swàrí wi anggúr-nkpamtaru ɓari mǝnana à nǝ̀ kpapi ɓadǝmbi andǝ nzǝmi ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Bugìr mārǝ́ taɓunu ace kpapè arǝ efot ka, ɓǝà tè kǝla mala efot, nǝ ankonggúr mala bolo-njengǝlan, andǝ mala ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, sǝ nkonggúr linǝn mǝɓǝlke mana à pyauwì nǝ pyauweka, sǝ ɓǝà swàrì arǝ efot ace mǝnana ɓǝà duk mwashat ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","<<Twal amunatali-onis ɓari sǝ wu nyoulǝ lullǝ amuna-burana lum-nong-ɓari mala Isǝrayila amuria. ");
INSERT INTO mbu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Nyoulǝ alullǝu tongno-nong-mwashat amur koya munatali-onis; tsaɗi alullǝia kǝla mǝnana à ɓǝlia ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ɓǝà nyoulǝ amǝno yì alullǝ amuna-burana mala Isǝrayila ka, amur amunatali-onis mǝno ɓari, kǝla mǝnana mǝ'pàk-njengǝlan nǝ̀ nyoulǝ gir amur ɓamur gbalmo-parbù ka. Koya munatali-onis ka oasǝi aɓa tǝkrǝk-waya male mǝnana bolo-njengǝlan na ka, ");
INSERT INTO mbu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","sǝ wu dambia arǝ anggúr-nkpamtaru mala efot. À nǝ̀ duk atali ɗenyinǝban mala amuna-burana mala Isǝrayila. Haruna nǝ̀ nggǝ gyar alullǝia a myali a ɓadǝm Yahweh ace ɗenyinǝia. ");
INSERT INTO mbu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Awu nǝ pàk atǝkrǝk-waya mala bolo-njengǝlan ace amunatali-onis mǝno ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Pàk amuna-nsolo ɓamyalu nǝ bolo-njengǝlan mǝɓoarne; ɓolǝia ɓǝà pa kǝla nggur, sǝ wu kpapia arǝ atǝkrǝk waya bolo-njengǝlan mala amunatali-onis mǝno ɓari ka, ɓǝà gyare arǝia. ");
INSERT INTO mbu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","<<Awu nǝ pàk lǝpan-damɓalǝu ace súrǝ̀ nê mala Ɓakuli. Ɓǝà tè aɓa sǝlǝ tagìr ulang mala efot, nǝ ankonggúr bolo-njengǝlan, andǝ ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ linǝn mǝɓǝlke mana à pyauwì nǝ pyauwe ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ɓǝà pè nǝ kasǝna lagìr mǝnana à kàrrì ɓari sǝ kúní lǝpi amur ɓè sǝ pàk lǝpan ngga. Sauwa male ɓǝ̀ pàk mwashat andǝ tangŋa male, incì tongno-nong-ine. ");
INSERT INTO mbu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Awu nǝ gyari wi arǝ amuna tali-gǝna tàrú-tàrú a nzǝmarǝia arǝ asangbǝlang ine; a sangbǝlang mǝdǝmbe ka, ɓǝà lanzǝì wi atali-gǝna rubi, tofas, andǝ beril; ");
INSERT INTO mbu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","a ɓaria sangbǝlang ngga ɓǝà lanzǝì wi amuna tali-gǝna mala emeral, safir, andǝ daimon; ");
INSERT INTO mbu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","a tàruia sangbǝlang ngga ɓǝà lanzǝì wi amuna tali-gǝna jasinta, aget, andǝ amitis; ");
INSERT INTO mbu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","a inea sangbǝlang ngga ɓǝà lanzǝì wi amuna tali-gǝna kǝrisolat, onis, andǝ jaspa; komǝye ka ɓǝ̀ pa aɓa tǝkrǝk-waya bolo-njengǝlan mǝnana à ɓolǝì ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Yia kat ka amuna tali-gǝna lum-nong-ɓari na; komǝye ateà ka ɓǝà nyoulǝî wi mwashat atà alullǝ amuna-burana lum-nong-ɓari mala Yakupu amurí, ɓǝà cam a kúnì atau mala amǝ Isǝrayila. Ɓǝà nyoulǝ alullǝia kǝla mana à nǝ̀ nyoulǝ gir amur gbalmo parbu ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","<<Amuna-nsolo mǝno à peǎ nǝ bolo-njengǝlan sǝ à pyauwia kǝla nggur ka, à nda ace kùrre arǝ lǝpan-damɓalǝu. ");
INSERT INTO mbu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Awu nǝ pàk agbalmò ɓari nǝ bolo-njengǝlan sǝ wu oasǝia arǝ lǝpan-damɓalǝu a ban akúní mǝnana à pǝlǝ nǝ kùli ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Awu nǝ kùr amuna-nsolo mǝno ɓari ka arǝ agbalmò mǝnia ɓari a kún bankara mala lǝpan-damɓalǝu ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kún ansolo mǝno ɓari ka, awu nǝ kùria arǝ atǝkrǝk-waya mala amunatali-onis mǝno ɓari ka. Anggo sǝ lǝpan-damɓalǝu ka nǝ̀ gyare a ɓadǝmbu arǝ anggúr-nkpamtaru mala efot. ");
INSERT INTO mbu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Awu nǝ pàk agbalmò bolo-njengǝlan ɓari sǝ awu nǝ oasǝia arǝ lǝpan-damɓalǝu a ban akúni mǝnana a nzali ka nǝ ɓalǝu, ɓǝà nong amur efot. ");
INSERT INTO mbu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Awu nǝ pàk aɓea agbalmò bolo-njengǝlan ɓari ɗǝm, sǝ awu nǝ kpapia a kún anggúr-nkpamtaru mana à pǝlǝ nǝ nzali ka a ɓadǝm efot, tù a ban-kpapya male amur bugìr mārǝ́ taɓunu mǝ'nbaké mala efot. ");
INSERT INTO mbu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Awu nǝ kùr agbalmò mala lǝpan-damɓalǝu arǝ agbalmò mala efot nǝ nggur mǝlùre, ace mǝnana lǝpan-damɓalǝu ka ɓǝ̀ nongŋo amur bugìr mārǝ́ taɓunu mǝ'nbaké mala efot, sǝ ace mǝnana ɓǝ̀ bwal kàngkàng arǝ efot ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","<<Ɓǝ̀ Haruna nǝ̀ kùtí aɓa Ban Mǝfele ka, nǝ̀ oasǝ mǝnia yì lǝpan-damɓalǝu mala súrǝ̀ nê mala Ɓakuli, mana à nyoulǝî wi alullǝ atau mala amǝ Isǝrayila amurí ka a myali; ɓǝ̀ gyare a damɓalǝi, yì ban ɓabumi, ace mǝnana Mim, Yahweh ka, mǝ nǝ nggǝ ɗenyinǝ aɓwana mem a koya pwari. ");
INSERT INTO mbu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Awu nǝ oasǝ a Urim andǝ Thummim aɓa lǝpan-damɓalǝu ace mǝnana ɓǝà pà amur ɓabum Haruna a koya pwari nǝ̀ kùtí a ɓadǝmbam aɓa Ban Mǝfele ka. Anggo sǝ amǝno yì agir ka à nǝ̀ nongŋo amur ɓabum Haruna ace súrǝ̀ nê mem amur amǝ Isǝrayila a ɓadǝmbam, Mim Yahweh koya pwari. ");
INSERT INTO mbu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","<<Daura-tsuru mǝsauwe mala efot ka ɓǝà tè kat nǝ ɗà'ndíng mǝlùre. ");
INSERT INTO mbu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ɓǝà nying ban fonggǝrang a myali ace oasǝ ɓamuru, sǝ ɓǝà tà myali nǝ nkonggúr mǝcandǝe ɓǝ̀ gumbǝli kat, ace mǝnana ɓǝ̀ kǝa sàn raka. ");
INSERT INTO mbu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Awu nǝ kàrì kún daure nǝ agir kǝla aɓǝla mɓǝring mǝnana à teǎ nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe ka, sǝ wu gyarki amuna gwaroji bolo-njengǝlan a nrea. ");
INSERT INTO mbu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Amuna gwaroji bolo-njengǝlan andǝ aɓǝla mɓǝring ngga ɓǝà gaɓi-ɓalǝarǝia camge a kún daure, ɓǝà gumbǝli. ");
INSERT INTO mbu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Dumǝna púp Haruna nǝ̀ oasǝ mǝnia yì daura ka arǝì ɓǝ̀ ndarǝ pàk túró mala pǝris ka. Ɓǝ̀ ndarǝ kutio nǝ̀ yiu a ɓadǝmbam aɓa Ban Mǝfele, ko ɓǝ̀ ndarǝ púrì wi nǝ̀ u ka, à nǝ̀ ok ɓua mala amuna gwaroji mǝnia ka, ace mǝnana ɓǝkǝa wù raka. ");
INSERT INTO mbu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","<<Pàk baji mǝkyauwe nǝ bolo-njengǝlan mǝɓoarne sǝ wu nyoulǝ cau mǝnia ka amurí ama: Mǝfele na aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kùrrì nǝ nkonggúr mǝlùre arǝ nggubyau mbuɓi múrû mala Haruna nǝ ban ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Haruna nǝ̀ nggǝ mārǝi a kúndǝmbi koya pwari. Mǝnia ka nda ace lǝmdǝ ama ɓǝ̀ amǝ Isǝrayila pà agir'nkila abanam kǝla pàɓoro mǝfele malea, sǝ à pè nǝ ɓwarkio aɓalǝi ka, Haruna nǝ̀ twal atanni mǝnana à nǝ̀ yiu atàcau mala amǝno yì aɓwarkio ka amurí, ace mǝnana, Mim, Yahweh ka, mǝ ak apaɓoro mǝnana kat à yinǝia abanam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","<<Awu nǝ tà daura-ɓaɓalǝu mǝlime ace Haruna, andǝ nggubyau mbuɓi múrû male, nǝ nkonggúr-linǝn mǝɓǝlke. Sǝ awu nǝ pàkki wi bugìr mārǝ́ taɓunu mǝnana à nbákí rǝì nǝ tagìr mǝɓoarsǝne ka. ");
INSERT INTO mbu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","<<Awu nǝ pàk adaura túró-pǝris, andǝ abugìr mārǝ́ taɓunu, andǝ asukuru, ace amuna-burana mala Haruna, ace mǝnana ɓǝ̀ aɓwana sǝnia nǝ ɓoarɓwa andǝ gulo. ");
INSERT INTO mbu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Awu nǝ oasǝì Haruna andǝ amuna-burana male amǝnia yì agir-nggūrǝu ka arǝia. Sǝ awu nǝ ɗārǝia nǝ mùrú olif ace kùria wia gulo, sǝ ace tària mala pàkkam túró kǝla apǝris. ");
INSERT INTO mbu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Awu nǝ swàrî Haruna andǝ koyan atà amuna-burana male ka ashiwan mala nggubyau linǝn. Shiwan ngga à nǝ̀ oasǝi a taɓunu sǝ akusǝì nǝ̀ sulǝo aban yiu amur abyalu, ace mǝnana ɓata ɓwa ɓǝ̀ kǝa ueo a nza raka. ");
INSERT INTO mbu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Dumǝna púp Haruna andǝ amuna-burana male ka à nǝ̀ oasǝ agirɓadǝmbu ateà a pwari mana kat à nǝ̀ kùtí a ɓadǝmbam aɓa Tara Ban-peri, ko à nǝ̀ gbashì ban gyangŋan ace pàk túró pǝris aɓa Ban Mǝfele ka. Mǝnia ka nda ace mǝnana ɓǝà kǝa nunbi ɓamuria cauɓikea sǝ à nǝ̀ wù ka ɗàng. Mǝnia yì nggurcau ka nda ace Haruna andǝ amuni andǝ amǝkè tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","<<Mǝnia ka nda nàtà mǝnana awu nǝ kpate ace tàr Haruna andǝ amuna-burana male ɓǝà duk apǝris aɓa túró mem ngga: Twal lo jamnda mwashat andǝ agam ɓari mǝnana à pànǝ ɓe kǝgìr mǝɓane arǝia raka. ");
INSERT INTO mbu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Pàktúró nǝ muku mǝssa-alkama mǝɓǝlke mana yis pà arǝì raka sǝ wu pak agbatali bǝredi. Kpapi mukuì andǝ mùrú olif sǝ wu pak agbatali kyak, pǝlǝa pàk abiskit sǝ wu hasǝkia wia mùrú olif. ");
INSERT INTO mbu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Awu nǝ tsǝia kat aɓa ndakade mǝmwashati, sǝ awu nǝ yinǝia abanam atārǝia andǝ amǝno yì lo jamnda andǝ agam ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","<<Awu nǝ kyan nǝ Haruna andǝ amuna-burana male a kún Tara Ban-peri, sǝ awu nǝ lákkià wia rǝia nǝ mùr. ");
INSERT INTO mbu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Pǝlǝa awu nǝ twal adaura-pǝris sǝ awu nǝ oasǝì Haruna daura-ɓaɓalǝu mǝlime, andǝ daura-tsuru mǝsauwe mala efot, andǝ efot, andǝ lǝpan-damɓalǝu; sǝ awu nǝ mārǝi wi a taɓuni, bugìr mārǝ́ taɓunu mǝnana à tè nǝ ankonggúr mǝɓoarsǝne ulang mala efot ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mārǝi wi nggubyau mbuɓi múrû amurí, sǝ wu kùri wi baji male mǝfele mǝnana à nyoulǝ cau amurí ama: <Mǝfele ace Yahweh> ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Anzǝm mǝno ka, pè wi gara mala tàrban ace túró pǝris nǝ solǝì wi mùrú olif amurí. ");
INSERT INTO mbu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","<<Kǝla mǝno gbal, awu nǝ yinǝ amuna-burana male, sǝ awu nǝ oasǝia wia adaura túró-pǝris arǝia. ");
INSERT INTO mbu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Awu nǝ mārǝia wia abugìr mārǝ́ taɓunu, sǝ awu nǝ mbuɓia wia múrià nǝ anggubyau mbuɓi múrû. Anggo sǝ dobuno-pǝris ka nǝ̀ duk mala Haruna andǝ amuna-burana male andǝ amǝ'keà tàtǝ́k. Anggo sǝ awu nǝ̀ kùrî Haruna andǝ amuna-burana male túró pǝris. ");
INSERT INTO mbu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","<<Awu nǝ yinǝ lo jamnda mǝno ka a ɓadǝmbam, a kún Tara Ban-peri, sǝ awu nǝ banggi Haruna andǝ amuna-burana male, ɓǝà tsǝk abuia a ɓamúrí. ");
INSERT INTO mbu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Awu nǝ pwanmyal mǝnia yi lo jamnda ka a ɓadǝmbam, Mim Yahweh, a kún Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Awu nǝ ɗàrǝ́ nkile bǝti sǝ wu hasǝki amur anjawe gyangŋan nǝ muna-buo. Cili nkila ka, solǝi a kusǝ gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mùrú nyama mǝnana gìr múr alungŋo jamnda, andǝ bare mǝsauwe mala nkundingŋi, andǝ amuna-gbè ɓari, andǝ mùrú nyama mǝnana amuria ka, pwania kat sǝ wu pisǝia a bǝsa amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Sǝama, cili nyam jamnda, andǝ ngguí, andǝ ciute ka, awu nǝ pisǝia a nzǝm là-gumli; mǝnia ka pàgir ace acauɓikea na. ");
INSERT INTO mbu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","<<Ɗǝm ngga awu nǝ twal mwashat atà agam mǝno ɓari ka sǝ wu banggi Haruna andǝ amuna-burana male ɓǝà tsǝk abuia a ɓamúrí. ");
INSERT INTO mbu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Sǝ awu nǝ pwanmyal gamnì, sǝ nkile ka awu nǝ watsǝki arǝ gyangŋan ɓǝ̀ gumbǝli. ");
INSERT INTO mbu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Awu nǝ kasǝki nyam gamnì bǝti-bǝti; awu nǝ lak agir-bumi, andǝ akusǝi, sǝ awu nǝ tsǝia amur ɓamúrí andǝ nyami mǝnana à kasǝki bǝti-bǝti ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Pisǝ abare gam mǝnia ka kat a bǝsa amur gyangŋan. Mǝnia ka pàgir mala pisǝe kǝring abanam Yahweh na; pàgir na nǝ bǝsa abanam Yahweh, ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","<<Awu nǝ twal ɓè gam mǝno ue ka, sǝ awu nǝ tunǝ Haruna andǝ amuna-burana male ɓǝà tsǝk abuia a ɓamúrí. ");
INSERT INTO mbu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Pǝlǝa awu nǝ pwan-myal gamnì, sǝ awu nǝ ɗàrǝ́ bǝti aɓa nkile wu hasǝkì Haruna andǝ amuna-burana male arǝ amburkiria mǝlì, andǝ amuna-buia mǝbure mǝlì, sǝ arǝ amuna-kusǝia mǝbure mǝlì. Cili ka watsǝki arǝ gyangŋan ɓǝ̀ kàrì kat. ");
INSERT INTO mbu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Awu nǝ ɗàrǝ́ aɓa nkila mǝnana amur gyangŋan ngga, sǝ wu zurǝì andǝ mùrú olif mǝnana nda ace ɗārǝâ ka, sǝ wu watsǝki amur Haruna sǝ amur amuna-burana male, andǝ adaura malea. Anggo, sǝ yia andǝ adaura malea ka awu nǝ tària, amǝfele na. ");
INSERT INTO mbu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","<<Mǝnia yi gam ngga nda ace nàtà mala pè Haruna andǝ amuna-burana male gara ace túró pǝris. Acemani ka, pusǝki mùrú rǝ nyam gamnì, andǝ mùrú nyam nggilate, andǝ mùrú nyama mǝnana gìr múr agir-bumi ka; sǝ wu pusǝ ban mǝɓoarne mala nkundingŋi, andǝ amuna-gbè ɓari, andǝ mùrú nyama mǝnana gìr múrià ka, andǝ byal kusǝi mǝlì. ");
INSERT INTO mbu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Aɓa ndakade mǝno à yinǝi ace pà ɓoro nǝi abanam ngga, twal gbatali bǝredi mwashat, gbatali kyak mwashat mana à pè nǝ mùrú ka, sǝ biskit mwashat; ");
INSERT INTO mbu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","tsǝia andǝ abare nyama mǝnia ka a ɓabù a Haruna andǝ ɓabu amuna-burana male, ɓǝà loasǝia a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Anzǝm mǝnia ka, awu nǝ ak gbatali bǝredi, andǝ gbatali kyak, andǝ biskit, andǝ abare nyama kat a buia, awu nǝ tsǝia amur abare nyam gam mǝdǝmbe mǝnana nda aban pi amur gyangŋan ngga, sǝ awu nǝ pisǝia kǝring a ɓadǝmbam Yahweh. Pàgir nǝ bǝsa na abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","<<Sǝ awu nǝ twal kikil gam mǝnana à pwanmyali ace nàtà mala tàr Haruna ace túró pǝris ka, sǝ awu nǝ loasǝi a kùli a ɓadǝmbam, ɓǝ̀ do pàgir na mǝnana à loasǝi a kùli abanam Yahweh ka. Mǝnia yì bare girkusǝu ka nda nǝ̀ duk kāmbe mò ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","<<Ɓǝ̀ à nǝ̀ tàr ɓwa ace túró pǝris ka, kikil andǝ byal gam mǝnana à pwan-myali ace nàtà mala mǝno yi tàrban, mǝnana à loasǝia a kùli kǝla pàɓoro mana à loasǝi a kùli ka, dumǝna ɓoro mǝnana à tàrni, nda kāmbe mala apǝris, yì a Haruna andǝ amuni andǝ amǝkè ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mǝnia ka nǝ̀ duk kāmbe mǝnana amǝ Isǝrayila nǝ̀ nggǝ pê apǝris, yì a Haruna andǝ amuni andǝ amǝkè mana a nzǝmi ka, nggaɗè pà kàm ɗàng tàtǝ́k. Mǝnia ka nǝ̀ duk kāmbe mala ɓoro mala amǝ Isǝrayila abanam, Mim Yahweh, mana à twali aɓalǝ apagir ace dotarǝu ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","<<Adaura-pǝris mala Haruna ka, à nǝ̀ tsǝia ace amuni andǝ amǝkè mana à nǝ̀ yia lidǝmba nǝ túró pǝris anzǝm lú male ka. À nǝ̀ oasǝia arǝia ɓǝ̀ à nǝ̀ kùria wia túró pǝris nǝ ɗārǝ́bân nǝ mùrú olif amúrià mala tàrban ace túró pǝris ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Muna-ɓwabura mala Haruna mǝnana nǝ̀ twal bancame male a túró pǝris ka, nǝ̀ oasǝ adaura-pǝris mǝnia ka arǝì sǝ nǝ̀ nggǝ kúti a ɓadǝmbam aɓa Tara Ban-peri ace pàktúró aɓa Ban Mǝfele, nongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","<<Awu nǝ twal cili abare nyam gam mana à pàngŋǝ̀nà túró nǝi ace nàtà mala tàr Haruna andǝ amuna-burana male ace túró pǝris ka, sǝ wu lam nyamì nǝ mùr a ɓè ban mǝnana à tàrì ace pàkkì atúró mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna andǝ amuna-burana male nǝ̀ shak nyama mǝnia ka atārǝia andǝ agbatali bǝredi mǝnana à ueo aɓa ndakade ka, a kún Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","À nǝ̀ shak mǝnia yì nyama andǝ bǝredi mǝnana à pàngŋǝ̀nà túró nǝi ace shawuɗiban aɓa nàtà mala kùria wia gulo andǝ tàrban malea aɓa túró pǝris ka. Kǝ yia apǝris nǝmurǝia na à nǝ̀ lì mǝnia yì girlina ka, acemǝnana girlina mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Sǝ ɓǝ̀ cili mǝnia yì nyama ko bǝredi ueo, kya bwal bu dǝmbari ka, dumǝna púp à nǝ̀ súkkì a bǝsa ɓǝ̀ pǐ; kǝ ɓwa ɓǝ̀ kǝa lì ɗàng, acemǝnana mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","<<Anggo sǝ awu nǝ kùrî Haruna andǝ amuna-burana male túró pǝris, kǝla mana ǝn tsǝko nǝma wu pê ka; mǝnia yì nàtà mala kùrî ɓwa túró pǝris ka, à nǝ̀ pè aɓalǝ apwari tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Aɓa koya pwari ka, dumǝna púp awu nǝ pwan-myal lo-jamnda kǝla pàgir mala shawuɗiban ace cauɓikea. Ɗǝm ngga ɓǝ̀ a nda rǝ shawuɗì gyangŋan ngga, awu nǝ ɗārǝí nǝ mùrú olif ace tàre ace Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Awu nǝ pàk amǝnia yì anàtà mala shawuɗiban ngga koya pwari arǝ anongŋo tongno-nong-ɓari, ace tàr gyangŋan ɓǝ̀ duk mǝfele kat-kat. Anggo sǝ gyangŋan nǝ̀ duk mǝfele, sǝ gìr mǝnana kat je gyangŋan ngga nǝ̀ duk mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","<<Amǝnia ka, à nda ka agir'nkila mǝnana awu nǝ pànà ɓoro nǝia amur gyangŋan-pàɓoro koya pwari arǝ apwari kat ka: Amǝgam ɓari, komǝye ka mbule mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mǝgam mǝnia mwashat ka, awu nǝ pànà ɓoro nǝi kǝla gir'nkila nǝ dǝmbari, sǝ ɓè ka awu nǝ pana ɓoro nǝi kǝla gir'nkila nǝ pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Mǝgam mǝdǝmbe mǝnana awu nǝ pànà ɓoro mala gir'nkila nǝi ka, kpapi andǝ tasau mwashat mala mǝssa-alkama mǝɓǝlke mana à soapi wi mùrú olif mǝɓoarne mǝnana ɓè kǝgìr ɗàng pà kàm arǝì raka, dù-lita mwashat. Sǝ wu so dù-lita mwashat mala mùr-anap amurí, ɓǝ̀ do nda pàgir mala girnùná. ");
INSERT INTO mbu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ɓaria mǝgam ngga awu nǝ pànà ɓoro mala gir'nkila nǝi nǝ pwarikpǝra; awu nǝ gilǝkì atārǝia andǝ pàgir mala mǝsǝsa, andǝ pàgir mala girnùná male, kǝla mana a pê nǝ dǝmbari ka. Pàgir nǝ bǝsa na abanam Yahweh, mala pà rǝmban mǝɓoarne mǝnana kǝ pwasǝbumam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","<<Arǝ anza mǝnana kat à nǝ̀ yiu ka, à nǝ̀ nggǝ pak mǝnia yì pàɓoro mala pisǝ gir a bǝsa ka koya pwari, a ɓadǝmbam, Mim Yahweh, a kún Tara Ban-peri. A mǝnia yì ban a kún Tara Ban-peri ka, sǝ mǝ nǝ nggǝ je sǝnǝ aɓwana mem, sǝ mǝ nǝ nggǝ nô cau. ");
INSERT INTO mbu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","A kǝ banì sǝ mǝ nǝ nggǝ je sǝnǝ amǝ Isǝrayila, sǝ tǎlaban mala ɓoarɓwa mem nǝ̀ tsǝk banì nǝ̀ duk mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","<<Anggo sǝ mǝ nǝ tsǝk Tara Ban-peri andǝ gyangŋan-pàɓoro ɓǝà duk amǝfele, sǝ Haruna andǝ amuna-burana male ka, mǝ nǝ tària ace ɓamúràm mana à nǝ̀ nggǝ pakkam túró kǝla apǝris ka. ");
INSERT INTO mbu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Sǝ mǝ nǝ do aɓalǝ amǝ Isǝrayila, mǝ nǝ duk Ɓakuli malea. ");
INSERT INTO mbu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Sǝ à nǝ̀ sǝlǝ ama, Mǝ nda Yahweh Ɓakuli malea. Mǝ nda ɓwa mǝnana pusǝia aɓa nzali Masar ace mǝnana ɓǝ̀ ǝn do aɓalǝia ka. Mǝ nda Yahweh Ɓakuli malea. ");
INSERT INTO mbu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","<<Awu nǝ ɓak ɓè gyangŋan nǝ akpamgbang mala nggun-akasiya, mǝnana à nǝ̀ nggǝ pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne amurí ka. ");
INSERT INTO mbu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Tangŋa male andǝ sauwa male ɓǝà kārǝa, komǝye ka ɓakusǝu mwashat nǝ gauwa-tsùrú, sǝ dāh'rya male ɓǝ̀ pàk ɓakusǝu tàrú. A koya nkanggari ka awu nǝ tsǝki wi njawe nǝ ulang kǝ nggun mǝnana à pè nǝi ka, ɓǝà duk mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Awu nǝ gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne: múrí, andǝ ankanggari, andǝ anjawe. Sǝ awu nǝ ɓak bolo-njengǝlan ɓǝ̀ kàrì kúni kat. ");
INSERT INTO mbu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Sǝ awu nǝ pàkki wi agbalmò bolo-njengǝlan ɓari-ɓari arǝ ankanggari; tsǝia ɓǝà sulǝî ban kúní bǝti sǝ ɓǝà came a nkāɓe rǝarǝia. Amǝnia yì agbalmò ka à nda ace oasǝ agara mǝnana à nǝ̀ nggǝ twal gyangŋanì nǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Awu nǝ pàk agara twale nǝ nggun-akasiya, sǝ wu gìr rǝia nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Awu nǝ tsǝk mǝnia yì gyangŋan loasǝ yele mǝ'rǝmɓoarne ka anzǝm lagìr-kasǝbân mana gyare a ɓadǝm Akwati mala Acau-nakûn ngga. Yì Akwati mala Acau-nakûn andǝ gìrkúni ka, ɓǝ̀ pa a ɓadǝm gyangŋan loasǝ yele. Gìrkún Akwati ka nda buno sǝntǝ̀r, sǝ nda ban mǝnana Mǝ nǝ nggǝ je sǝnǝ we kam ngga. ");
INSERT INTO mbu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Dumǝna púp Haruna nǝ̀ nggǝ pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne amur mǝnia yì gyangŋan ngga. Koya dǝmbari ɓǝ̀ warina nǝ̀ giliki apitǝla ka, nǝ̀ pisǝì. ");
INSERT INTO mbu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Koya pwarikpǝra ɓǝ̀ warina nǝ̀ tsǝk bǝsa arǝ apitǝla ka, nǝ̀ pìsǝì. Mǝnia yì pàgir mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne a ɓadǝm Yahweh ka, nǝ̀ lidǝmba anggo, tamsǝe pà kàm ɗàng, arǝ anza kat. ");
INSERT INTO mbu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Pà wunǝ pàɓoro mala loasǝ yele nǝ ɓekǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne mǝnana ǝn earnǝi raka amur mǝnia yì gyangŋan ngga ɗàng; wu kǝa na ama wun nǝ̀ pà gir'nkila mala pisǝe kǝring, ko wun nǝ̀ pàgir mala mǝsǝsa amurí ɗàng; sǝ wu kǝa na ama wun nǝ̀ pàgir mala so mùr-ɓǝlanggun anap amurí ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kusǝ mwashat a koya pǝlǝa ka Haruna nǝ̀ pàk nàtà mala shawuɗiban amur anjawe male. Nǝ̀ hasǝki wi nkila arǝ anjawe, yì nkila mǝnana à ɗarǝi arǝ girkusǝu mala pàgir ace cauɓikea, mǝnana à pwan-myali kǝla gir'nkila ace shawuɗì aɓwapǝndǝa ka. Anggo sǝ à nǝ̀ lidǝmba nǝ pe a koya pǝlǝa, arǝ anza kat. Mǝnia yì gyangŋan loasǝ yele ka nǝ̀ duk nggea mǝfele abanam Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Pǝlǝa Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","<<Ɓǝ̀ awu nǝ ɓal amǝ Isǝrayila ace súrǝ̀ làkkì malea ka, koya ɓwa mǝnana à ɓalli kat ka, nǝ̀ mbwegìr abanam, Mim Yahweh ace amsǝ yilǝmi. À nǝ̀ mbwe ace mǝnana ɓǝ̀ gìr'mur'mwana ɓǝ̀ kǝa kumia ɓǝ̀ à nda rǝ ɓalban ngga ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ɓwa mǝnana kat à ɓalli a mǝnia yì ɓalban ngga, nǝ̀ mbwe boalo, gauwa-tsùrú mala shekel, yì mǝsǝbolo-azǝrfa mǝnana à kārǝ́ dǝmbǝrya male sǝ à earna amurí a Tara-mǝfele ka. (Shekel mwashat ka mǝtyang lum-nong-ɓari na.) Koya ɓwa ka nǝ̀ mbwe boalo mǝnia kǝla ɓoro abanam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Aɓwana mana kat pǝlǝa ɓǝlban malea bwalǝna lumi-ɓari ka, à nǝ̀ pà mǝnia yì ɓoro ka abanam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ɓǝ̀ wun nǝ̀ yinǝ mǝnia yì ɓoro ace shawuɗì ayilǝmi wun, abanam, Mim Yahweh ka, mǝkume pà nǝ̀ pà gìr mǝnana kútì boalo mǝnana à kasǝ ka ɗàng, sǝ mǝ'tǝ̀r pà nǝ̀ pà gìr mǝnana gattì boalo mǝnana à kasǝ ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Awu nǝ ak mǝnia yì boalo shawuɗiban ngga a bu amǝ Isǝrayila, sǝ awu nǝ pàngŋǝ̀nà túró nǝi ace tsǝkir Tara Ban-peri; ace mǝnana ɓalǝam ɓǝ̀ kasǝa arǝ yália ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Pǝlǝa Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","<<Awu nǝ pàk nkenye nǝ bolo-bángŋá ace lákkí arǝu, sǝ girtàmsǝe ka pè gbal nǝ bolo-bángŋá. Tsǝì ɓǝ̀ came a nre Tara Ban-peri andǝ gyangŋan-pàɓoro, sǝ wu so mùr aɓalǝi. ");
INSERT INTO mbu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna andǝ amuna-burana male nǝ̀ pàktúró nǝ mùrnî ace lákkí abuia andǝ akusǝia. ");
INSERT INTO mbu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kaniama à nǝ̀ kùtí aɓa Tara Ban-peri, ko à nǝ̀ gbàshì ban gyangŋan ace pàk túró-pǝris, à nǝ̀ pà ɓoro mala pisǝ gir a bǝsa amurí ace loasǝ yele mǝ'rǝmɓoarne abanam Mim Yahweh ka, dumǝna púp, à nǝ̀ lákkí arǝia nǝ̀ mùr. Ɓǝà pàk anggo raka à nǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Dumǝna púp à nǝ̀ lákkí abuia andǝ akusǝia, ace mǝnana ɓǝà kǝa wù raka. Mǝnia ka nzongcau na mǝnana yì, andǝ amuni, andǝ amǝ'keà nǝ̀ kpatè arǝ anza malea kat ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","<<Twal amǝnia yì amuku agir-mǝ'kuskushi ka: tyang tongno-nong-mwashat mala muku mǝr, sǝ tyang tàrú mala muku nggwato-nggun sinamon mǝ'rǝmɓoarne, andǝ tyang tàrú mala muku kǝkar-bondo mǝ'rǝmɓoarne, ");
INSERT INTO mbu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","sǝ tyang tongno-nong-mwashat mala muku nggwato-nggun kasiya mǝ'rǝmɓoarne. Yia kat ka, ɓǝà kārǝia nǝ kārǝgìr mǝnana à earna amurí a Tara-mǝfele ka. Soapi wia lita ine mala mùrú olif. ");
INSERT INTO mbu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Nǝ mǝnia yi amuku agir ka sǝ awu nǝ pàk mùrú mǝfele ace ɗārǝ́bân; ɓǝà pè kǝla mǝnana mǝ'sǝlǝ pakki agir pà rǝmban mǝɓoarne kǝ pê ka; mǝnia yì mùrú ka nǝ̀ duk mùrú-ɗārǝ́bân mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Pàktúró nǝ mǝnia yi mùrú ka wu hasǝki arǝ Tara Ban-peri sǝ arǝ Akwati mala Acau-nakûn, ");
INSERT INTO mbu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","sǝ wu hasǝki arǝ kpamgbang-tsǝk-agir andǝ agirtúró male, andǝ gir tamsǝ pitǝla andǝ agirtúró male kat, andǝ gyangŋan mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne, ");
INSERT INTO mbu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","andǝ gyangŋan pàgir mala pisǝe kǝring andǝ agirtúró male kat, sǝ nkenye lákkí arǝu andǝ girtàmsǝe. ");
INSERT INTO mbu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Awu nǝ ɗārǝia nǝ mùrú-ɗārǝ́bân anggo ace mǝnana ɓǝà duk agir mǝfele kat-kat. Ɓwa ko gìr mǝnana kat jea ka, nǝ̀ duk mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Awu nǝ ɗārǝ́ Haruna andǝ amuna-burana male gbal nǝ mùrú ɗārǝ́bân, sǝ wu kùria wia gulo mala pǝris ɓǝà duk amǝ pakkam túró kǝla apǝris. ");
INSERT INTO mbu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Sǝ awu nǝ banggi amǝ Isǝrayila ama, <Mǝnia yì mùrú-ɗārǝ́bân mǝfele ka, nda ace túró mem arǝ anza kat. ");
INSERT INTO mbu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","À pà nǝ̀ pàngŋǝ̀nà túró nǝi kǝla mùrú-hasǝa arǝ aɓwana ɗàng, sǝ wu kǝa pàk ɓekǝ mùrú nǝ agir kpapè ulang male ɗàng. Mǝnia yì mùrú-ɗārǝ́bân ngga mǝfele na, sǝ anggo sǝ wun nǝ̀ twali mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ɓǝ̀ kǝɓwa pàk kǝ ulangnì, ko ɗārǝ́na kǝɓwa nǝi mǝnana pǝris na raka, nǝ̀ purî ɓalǝ aɓwana mem.> >> ");
INSERT INTO mbu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yahweh ne Musa ama, <<Kpapiki amǝnia yì agir mǝpà rǝmban mǝɓoarne ka: mǝrǝm nggun, andǝ nkpoulo nkombo, andǝ myang nggun, andǝ myang-kwarra mǝɓoarne; (komǝye ka dǝmbǝrya male ɓǝ̀ kārǝa andǝ mala aɓî). ");
INSERT INTO mbu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Nǝ mǝnia yì agir ka sǝ awu nǝ pàk muku-gìr loasǝ yele mǝ'rǝmɓoarne; pè kǝla mǝnana mǝ'sǝlǝ pakki agir pà rǝmban mǝɓoarne kǝ pê ka. Awu nǝ zùrǝì amǝnia yì agir ka, sǝ awu nǝ kúnǝkì wi tuɓamur ɓǝ̀ pàk mǝɓoarnsari sǝ mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ɗàrǝ́ bǝti aɓa kpapè mǝno, goe ɓǝ̀ ɓǝlki lǝkǝt-lǝkǝt sǝ wu tsǝî a ɓadǝm Akwati mala Acau-nakûn, a ban mǝnana sǝm nǝ nggǝ je sǝnǝ we kam aɓa Tara Ban-peri ka. Mǝnia yì muku-gìr loasǝ yele mǝ'rǝmɓoarne ka, twali gìr nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mǝnia yì muku-gìr loasǝ yele mǝ'rǝmɓoarne ka dumǝna mǝfele, wu kǝa pakkî ɓamur rǝ wun ulangnì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ɓwa mǝnana kat pàk ulang mǝnia yì gìr loasǝ yele mǝ'rǝmɓoarne ace ɓamurì ka, nǝ̀ purî ɓalǝ aɓwana mem.>> ");
INSERT INTO mbu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","<<Sǝni, ǝn twalna Bezal-El muna-ɓwabura mala Uri, mǝkà Hur, a tàu mala Yahuda sǝ ");
INSERT INTO mbu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ǝn lúmsǝ̀nì nǝ bangŋo mala Ɓakuli. Ən panì wi kwárô aɓa ɗenyicau, andǝ súrǝ̀gir, andǝ sǝlǝe mala pàk koya ulang túróbù; ");
INSERT INTO mbu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","nǝ̀ sǝlǝ nyoulǝ pǎ mala agir mǝɓoarsǝne ɗàng-ɗáng, andǝ tùlki agir nǝ bolo-njengǝlan, bolo-azǝrfa, andǝ bolo-bángŋá; ");
INSERT INTO mbu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ndanǝ sǝlǝpe mala kpaliki rǝ atali-gǝna ace oasǝkia aɓalǝ agir-bwalia, andǝ mala shàr nggun, andǝ mala pak koya ulang túróbù. ");
INSERT INTO mbu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ɗǝm ngga ǝn twalna Oholiyap, muna-ɓwabura mala Ahisamak, a tàu mala Dan, ɓǝà pàktúró andǝi. Nyare ǝn panì acili aɓwana mǝnana kat amǝ pàkkiagir túróbù na ka sǝlǝpe ace mǝnana ɓǝà pàk koya gìr kat gǝ̀rgǝ̀r kǝla mǝnana ǝn banggo nǝma ɓǝà pè ka amur cau mala: ");
INSERT INTO mbu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tara Ban-peri, andǝ Akwati mala Acau-nakûn andǝ gìrkúni amurí, mǝnana nda buno sǝntǝ̀r ka, andǝ acili agir mana kat à nǝ̀ tsǝia aɓa Tara Ban-peri ka, ");
INSERT INTO mbu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","andǝ kpamgbang-tsǝk-agir andǝ agirtúró male amurí, andǝ gìr tamsǝ apitǝla, andǝ agirtúró male kat, andǝ gyangŋan ace loasǝ yele mǝ'rǝmɓoarne, ");
INSERT INTO mbu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","andǝ gyangŋan mala pagir mala pisǝ kǝring andǝ agirtúró male kat, andǝ nkenye andǝ girtàmsǝe, ");
INSERT INTO mbu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","andǝ adaura-pǝris amǝ'ɓoarɓwe, yi adaura mǝfele ace Haruna pǝris mǝgule andǝ adaura ace amuna-burana male, mǝnana à nǝ̀ oasǝ arǝia ɓǝ̀ à nǝ̀ pàk túró pǝris ka, ");
INSERT INTO mbu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","andǝ mùrú-ɗārǝ́bân, andǝ muku-agir loasǝ yele mǝ'rǝmɓoarne ace Ban Mǝfele. Aɓa pàkki amǝnia yì agir kat ka, ɓǝà peǎ gǝ̀rgǝ̀r kǝla mǝnana ǝn banggo ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Pǝlǝa Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","<<Ne amǝ Isǝrayila ama, <Dumǝna wun púp wun nǝ̀ kpata nzongcau mala Pwari Sabbat, pwari usǝlǝo mem. Acemǝnana Pwari Sabbat ka nda gìr'lǝmdǝa a nrem sǝnǝa wun aban ká arǝ anza mǝnana kat à kǝ yiu ka, ace mǝnana ɓǝ̀ wu sǝlǝ ama, Mim Yahweh ka, ǝn tárnà wun ɓǝ̀ wu duk aɓwana mem. ");
INSERT INTO mbu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Dumǝna púp wun nǝ̀ kpata nzongcau mala Pwari Sabbat, acemǝnana pwari mǝfele na aban wun. Ɓwa mǝnana pǝndǝkice ka, dumǝna púp à nǝ̀ wali ɓǝ̀ wú. Ɓwa mǝnana pàk túró a pwari mǝno ka, à nǝ̀ pusǝì, pà nǝ̀ pa aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Wu ndanǝ anongŋo tongno-nong-mwashat mala pàkki atúró, sǝama tongno-nong-ɓaria pwari ka, nda pwari Sabbat mala usǝlǝo, pwari mǝfele mana à tàrì ace Yahweh ka. Ɓwa mǝnana bwal túró a Pwari Sabbat ka, dumǝna púp à nǝ̀ wali ɓǝ̀ wú. ");
INSERT INTO mbu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Acemani ka, amǝ Isǝrayila nǝ̀ pà gulo arǝ Pwari Sabbat, à nǝ̀ kpata nzongcau male arǝ anza mǝnana kat à kǝ yiu ka, kǝla kùrcau mana málá male pà kàm raka. ");
INSERT INTO mbu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mǝnia yì pwari ka, nǝ̀ do gìr'lǝmdǝa na tàtǝ́k a nrem sǝnǝ amǝ Isǝrayila ama, Mim Yahweh ka, ǝn pusǝ kùli andǝ nzali aɓa nongŋo tongno-nong-mwashat, sǝ a tongno-nong-ɓaria pwari ka, ǝn nying buam arǝ túró, ǝn usǝlǝo.> >> ");
INSERT INTO mbu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Lang Ɓakuli malna nacau nǝ Musa amur Nkono Saina ka, pǝlǝa pè wi akpamgbǝlang tali ɓari mala Acau-nakûn, yì akpamgbǝlang Acau-nakûn mǝnana Ɓakuli nyoulǝia nǝ munabui ka. ");
INSERT INTO mbu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Lang aɓwana sǝnǝna sauwa mǝnana ban Musa sauwa amur nkono ka, kara à ramba aban Haruna, à ne wi ama, <<Lo, pakka sǝm ɓakuli, ɓǝ̀ dupa sǝm a dǝmba. Acemǝnana sǝm súrǝ̀ gir mana kum mǝnia yì ɓwa, yì Musa mǝnana pusǝ sǝm aɓa Masar ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Pǝlǝa Haruna nea wia ama, <<Wu pusǝki agirkiru bolo-njengǝlan mala amālá wun, andǝ mala amuna-burana andǝ amuna-mamǝna ma'wun, wu yinǝàm nǝia.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kara ɓwabundǝa kat pusǝki agir bolo-njengǝlan mana a kiria ka, à yinǝì Haruna nǝia. ");
INSERT INTO mbu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Pǝlǝa Haruna ak agir bolo-njengǝlan mǝnia, tsǝia a bǝsa, à panzǝa. Pǝlǝa ɓakia wia ɓǝ̀nzál lo-jamnda nǝi, konggi rǝì sǝ kolǝì pepè nǝ agirtúró. Lang ɓwapǝndǝa sǝni ka, à na ama, <<Mǝnia ka nda ɓakuli ma'wun, wun amǝ Isǝrayila, mana pusǝ wun aɓa nzali Masar ka!>> ");
INSERT INTO mbu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Lang Haruna sǝn mǝnia ka, kara ɓak gyangŋan-ɗārǝâ a ɓadǝm ɓǝ̀nzál lo-jamnda. Pǝlǝa hambî aɓwana cau ama, <<Li ka, Lamsan nakam ace pagulo aban Yahweh!>> ");
INSERT INTO mbu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Aɓwana lo nǝ dǝmbari ɗiɗyal, à pākia agir'nkila mala pisǝe kǝring a bǝsa aban ɓǝ̀nzál mǝno, sǝ à yinǝ aɓoro mala pàgir ace dotarǝu. Anzǝm mǝno ka, à do sǝ à kùtí a likia agir, andǝ nukia agir. Pǝlǝa à lo à pakkiɗire. ");
INSERT INTO mbu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yahweh ne Musa ama, <<Sùlǝî mur nkono akaurǝa! Aɓwana mô mana a pusǝia a Masar ka, à kìɗìkìna ɓamuria. ");
INSERT INTO mbu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","À kaurǝ kyanggi njar, yì njar mǝnana ǝn tsǝkia wia nzongcau ɓǝà kpate ka! À pàngŋǝ́nì ɓamuria ɓǝ̀nzál mala lo-jamnda nǝ bolo-njengǝlan. À ɓunǝna a ɓadǝmbi, sǝ à ɗārǝ́na gìr'nkila a baní, à kǝ na ama, <Mǝnia ka nda ɓakuli ma'wun, wun amǝ Isǝrayila, mana pusǝ wun aɓa nzali Masar ka.> >> ");
INSERT INTO mbu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Pǝlǝa Yahweh banggi Musa ama, <<Ən sǝnǝni ama aɓwana mǝnia ka amǝ'murcandǝa na. ");
INSERT INTO mbu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ado ka ɗekiǎm ace mǝnana bumlulla mem ɓǝ̀ earke amúrià, mǝ nǝ twàlteà kat. Sǝ we ka mǝ nǝ tsǝk tàu mò ɓǝ̀ pǝlǝ ɓwapǝndǝa mala nzali mǝgule.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Sǝ Musa ka ɓariki nǝ pwasǝlǝbum Yahweh Ɓakuli male, na ama: <<We Yahweh, man tsǝa sǝ bumlulla mò nǝ̀ earke anggo amur aɓwana mô, yià mǝnana a pusǝia à purî ɓá nzali Masar nǝ kanggǝrang rǝcandǝa andǝ kaɓa bù ka? ");
INSERT INTO mbu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ɓǝ̀ a pak anggo ka amǝ Masar nǝ̀ kum kún nacau ama, <Nǝ bumɓikea sǝ Ɓakuli malea pusǝia ɓǝà purî ɓá nzali Masar, ace mǝnana nǝ̀ nggá wal-luia amur ankono, sǝ nǝ̀ twaltea ɗǝɗak ɓǝà malì ɓanza ka.> Nying bumlulla mò mǝ'earke; nggaɗi ɗenyicau mò, sǝ kǝa yinǝ mǝnia yì gìr'mur'mwana ka amur aɓwana mô ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","<<Ɓalǝo ɓǝ̀ kasǝa arǝ pacau mò aban aguro mò, Ibǝrayim andǝ Ishaku sǝ Isǝrayila, mǝnana a kánbia wia gìr nǝ ɓamurò ama: <Mǝ nǝ hatǝki wun, amuna andǝ amǝkà wun nǝ̀ làkkì kǝla làkkì mala anlero a bumkuli, sǝ nzali mǝnia kat ǝn pacau ace ka, mǝ nǝ pè amuna ma'wun andǝ amǝ'kà wun ɓǝ̀ duk gìr'liɓala malea tàtǝ́k.> >> ");
INSERT INTO mbu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nda Yahweh nggaɗi ɗenyicau male arǝ gìr'mur'mwana mǝnana bang ama nǝ̀ yinǝi amúr aɓwana male ka. ");
INSERT INTO mbu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa pǝlǝa, sǝ sulǝî múr nkono nǝ akpamgbǝlang tali ɓari mala Acau-nakûn a buì, yì akpamgbǝlang tali mǝnana Ɓakuli gilǝ cau mala kùrcau kàm amúrià ɓālǝi andǝ nzǝmi ka. ");
INSERT INTO mbu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Akpamgbǝlang atali ka Ɓakuli nǝ ɓunnia, sǝ gilǝgir mǝnana amúrià ka Ɓakuli nǝ gilǝì, nyoulǝì amúrià. ");
INSERT INTO mbu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Lang Jesǝwa ok loàsǝ̀ban mala aɓwana aban sakkiban ngga, banggi Musa ama, <<Ən nggǝ ok gǝshi lwa a kàttì.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa pè wi eare ama, <<Loàsǝ̀ban mǝno ǝn nggǝ oè ka, mala ɓuà-gāwàn mala kum limurǝm, ko mak'zwalo mala kum kpa a lwa na ɗàng. Gì aɓwana aban tu-nggyal na ǝn nggǝ oè ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Lang Musa yi gbashi ban kàttì sǝ sǝn ɓǝ̀nzál mala lo-jamnda andǝ aɓwana aban ta'nggwam ngga, kara bumlulla male pì kùlkùl. Akpamgbǝlang tali mǝnana a buì ka sukkia, à kya arki a nzali a kusǝ nkono. ");
INSERT INTO mbu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Pǝlǝa twal ɓǝ̀nzál mala lo-jamnda mǝnana à pè ka, túrí a bǝsa panzǝa; goe pǝlǝ mukuì sǝ soé a mùr. Pǝlǝa tsǝia, yì aɓwana mala Isǝrayila ɓǝà nuì. ");
INSERT INTO mbu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa ɗì Haruna ama, <<Mana girnì na aɓwana mǝnia pakko mǝnana tsǝa sǝ a yinǝi mǝnia yì cauɓikea mǝgule amúrià ka?>> ");
INSERT INTO mbu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna pà eare ama, <<Ɓwamǝgule mem, cè bumo lúllô arǝàm ɗàng; a súrǝ́nà rǝ candǝkicau mala aɓwana man arǝ pak mǝɓike. ");
INSERT INTO mbu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Yià na à banggam ama, <Pakka sǝm ɓakuli, ɓǝ̀ dupa sǝm a dǝmba ka. Acemǝnana sǝm súrǝ̀ gir mana kum mǝnia yì ɓwa, yì Musa mǝnana pusǝ sǝm aɓa Masar ka ɗàng.> ");
INSERT INTO mbu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Pǝlǝa ǝn banggia wia nǝma, <Koyan mana kat ndanǝ gìrkiru mala bolo-njengǝlan a kiri ka, ɓǝ̀ pusǝì ɓǝ̀ yinǝi. Nda à pusǝkia, à yinǝia abanam, sǝ ǝn soea a bǝsa ka. Aɓalǝi sǝ mǝnia yì ɓǝ̀nzál mala lo-jamnda ka puro.> >> ");
INSERT INTO mbu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa sǝni ka aɓwana man nyārinà kǝtsǝu, sǝ Haruna na ɗekia atàrǝia à kǝ pàkki agir anggo kǝtsǝu, mǝnana tsǝa à duk gir oalo aban aɓiamǝbura ka. ");
INSERT INTO mbu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Pǝlǝa Musa yi came a kún kàttì sǝ hama ama, <<Ɓwa mǝnana kat nda a buì mala Yahweh ka, ɓǝ̀ puro ɓǝ̀ yiu abanam!>> Aburana mǝnana kat à nda a tàu mala Lawi ka, à pùro à yì ramba a baní. ");
INSERT INTO mbu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Pǝlǝa banggia wia ama, <<Yahweh Ɓakuli mala Isǝrayila kǝ na ama, <Koyan atà wun ngga ɓǝ̀ kùr rǝi nǝ nggeabyau male! Wu kya kutikio arǝ abân aɓa kàttì kat, aɓa koya gumli, sǝ koyan ngga ɓǝ̀ wal-lú aɓǝla, andǝ agyajam, andǝ aɓi amǝ'múrkala.> >> ");
INSERT INTO mbu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Anggo sǝ aburana mǝno a tàu mala Lawi ka pǎ kǝla mǝnana Musa banggia wia ama ɓǝà pàk ka. A pwari mǝno ka à wal-lú ka aɓwana kǝla á-tàrú (3,000). ");
INSERT INTO mbu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa banggi aburana mǝno a tàu mala Lawi ka cau ama, <<Yalung ngga à tàrnà wun ace Yahweh, wun nǝ̀ pàkki wi túrô, sǝ mǝno ka warinǝ wun a wal-lú amuna wun andǝ amǝ'eam wun, ace mǝnana ɓǝ̀ Yahweh tsǝka wun buì a pwari man ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Lang ban fana ka, Musa banggi aɓwana ama, <<Wu pàngŋǝ̀nà nggea cauɓikea mǝgule. Sǝama ado ka mǝ ndo mǝ nǝ nyare mǝ nǝ eauwe aban Yahweh; yakǝla mǝ nǝ nggá gandǝ shawuɗì wun ace cauɓikea ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nda Musa nyare o amur Nkono aban Yahweh sǝ banggi wi ama, <<Caukwanban, aɓwana man pángŋǝ̀nà nggea cauɓikea. À ɓangŋǝ́nì ɓamuria ɓakuli nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sǝama, ǝn nggǝ zǝmbô twalia wia banì. Sǝ ɓǝ̀ a pà nǝ twaliabanì raka, ida, esǝki lullǝàm aɓa malǝmce mò mǝnana a gilǝ lullǝ aɓwana mô kàm ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Sǝ Yahweh ka banggi Musa ama, <<Ɓwa mǝnana pàkkam cauɓikea ka, nda mǝnana mǝ nǝ esǝki lùllǝì aɓa malǝmce mem ngga. ");
INSERT INTO mbu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sǝama ado ka, nyare, kyan nǝ aɓwana mǝnia a ban mǝnana ǝn banggo cè ka. Ɓalǝo ɓǝ̀ kasǝa ama Mǝturonjar mem nǝ̀ ká dǝm wun; nǝ̀ lǝmdǝa wun njar. Sǝ ɓǝ̀ pwari mana ǝn tsǝa mǝ nǝ pur'ata aɓwana man ngga yina ka, mǝ nǝ ká arǝ cauɓikea malea amúrià.>> ");
INSERT INTO mbu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nǝnzǝ́mò ka Yahweh tasǝ gìr'mur'mwana mala kwánó mǝɓike mǝnana mesǝ amúrià kat ace gìr mǝnana à pàk nǝ ɓǝ̀nzál lo-jamnda mala bolo-njengǝlan mǝnana à tsǝk Haruna ɓakia wia ka. ");
INSERT INTO mbu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yahweh banggi Musa ama, <<Wu loapi ban mǝnia ka, we wunǝ aɓwana mǝnana a pusǝia à purî ɓá nzali Masar ka. Wu bwal njar aban ká a nzali mǝnana ǝn pacau ace nǝ kángìr aban Ibǝrayim, andǝ Ishaku, andǝ Yakupu ama, <Mǝ nǝ pè amunio andǝ amǝ'keo ka.> ");
INSERT INTO mbu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mǝ nǝ tasǝ mǝturonjar a ɓadǝmbo, sǝ mǝ nǝ pǝ̀r amǝ'Kan'ana, andǝ amǝ'Amor, andǝ amǝ'Hitti, andǝ amǝ'Periz, andǝ amǝ'Hivi, andǝ amǝ'Jebus. ");
INSERT INTO mbu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Wun ndo wun nǝ̀ ká a nzali mǝɓoarne, mǝnana kiura andǝ mur'nyi kǝ ɓang kàm ngga. Sǝama pà mǝ nǝ ká atà wun ɗàng, acemǝnana mǝ nǝ nggá twàltà wun a njargula raka; wun ngga wun nda ka amǝ'mgbicau.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lang aɓwana ok mǝnia yì cau zunggǝli ɓabum ngga, à tíkínǝ múrià ace bumkiɗikea mǝlime, sǝ à tamsǝ oasǝki agir gilǝkirǝu andǝ agir-nggūrǝu mǝɓoarne arǝia. ");
INSERT INTO mbu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yahweh ka angŋa dǝmba nanì Musa ɓǝ̀ banggi amǝ Isǝrayila ama, <<Wun nda ka amǝ'ɓamurcandǝa; ɓǝ̀n bang nǝma mǝ nǝ o atà wun zuku ka, mǝ nǝ twalta wun. Ado ka wu swárki agir gilǝkirǝu ma'wun mǝnana arǝ wun ngga, sǝ mǝ nǝ ɓalkiɓabumam amur gir mǝnana mǝ nǝ pangnǝ wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Nda amǝ Isǝrayila swárki agir gilǝkirǝu malea mǝnana arǝia ka, sǝ twal a bàkú mǝno à nying Nkono Saina, yì Horep aban ká dǝmba ka, à nyare à oasǝia ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ɓǝ̀ aya pwari sǝ amǝ Isǝrayila bwal ban mǝnana à nǝ̀ duk kàttì kam ngga, pàkka Musa nǝ̀ twal agir tsǝk tara sǝ nǝ̀ purî kàttì, nǝ̀ nggá tǝm tara zak nǝ kàttì. Yì tara ka tunǝi ama tara ban-peri. Koyan sǝ earce nǝ̀ súrǝ̀ ɓekǝ cau aban Yahweh ka, nǝ̀ puro nǝ̀ ká kàm a mǝno yì tara ban-peri mǝnana purî kàttì ka. ");
INSERT INTO mbu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Pwari mana kat Musa puro nǝ̀ ká a mǝno yì Tara ka, aɓwana kat nǝ̀ lo à nǝ̀ cam nǝ came a kún agumli malea aban sǝn Musa sheɓǝ̀ kya kutina aɓalǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Anzǝm mǝnana Musa kutina aɓa yì tara ka, pǝrɓang nǝ̀ sulǝo nǝ̀ yia cam pǝrapǝra a kún mǝno yì tara ka, sǝ Yahweh nǝ̀ nacau nǝ Musa. ");
INSERT INTO mbu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sǝ lang aɓwana sǝn pǝrɓang aban came pǝrapǝra a kún mǝno yì tara ka, koyan atà aɓwana kat ka, nǝ̀ lo sǝ nǝ̀ ɓunno a nzali a kún male yì gumli, sǝ nǝ̀ peri. ");
INSERT INTO mbu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Anggo ka Yahweh nǝ̀ nacau nǝ Musa ɓamǝsǝu andǝ ɓamǝsǝu, kǝla mǝnana ɓwa kǝ nacau andǝ gyajam male ka. Pǝlǝa Musa nǝ̀ nyare a kàttì, sǝ mǝlagga mǝnana kǝ bwalì wi túró, yì Jesǝwa, muna-ɓwabura mala Nun ngga, uekiyi kano, pà nǝ̀ nying ban mǝno yì tara ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa ne Yahweh ama, <<A bangŋǝ́nàm ama, mǝ ging nǝ aɓwana mǝnia ka; sǝ a banggam yana mǝnana awu nǝ tasǝì atàm ngga ɗàng. Nyare a nam ama, a súrǝàm nǝ lullǝam, sǝ ɗǝm ngga bumo kǝ pwasǝ arǝàm. ");
INSERT INTO mbu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ɓǝ̀n kumǝna earmúrú a bano ka, kaniam anjar mò, ace mǝnana ɓǝ̀n bwaltò pepè, sǝ ɓǝ̀n lidǝmba aɓa kum earmúrú mô. Ɗenyi ama aɓwana mǝnia ka aɓwana mô na.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Pǝlǝa Yahweh nyesǝi wi ama, <<Mim nǝ nggearǝam mǝ nǝ o atò, sǝ mǝ nǝ tsǝk ɓālǝo ɓǝ̀ kum usǝlǝo.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa pǝlǝa ne wi ama, <<Ɓǝ̀ a pà wunǝ ká atà sǝm raka, cè a eara sǝm ɓǝ̀ sǝm nying ban mǝnia ɗang. ");
INSERT INTO mbu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Lang sǝ ɓwa nǝ̀ sǝlǝa ama mim sǝnǝ aɓwana mô ka sǝm kumǝna earmúrú mô, yi mǝnana a o atà sǝm raka? Do mô aɓalǝ sǝm ngga, nda nǝ̀ tsǝk sǝm ɓǝ̀ sǝm pak ɗàngnǝ́ acilia aɓwana kat aɓa ɓanza ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Osso Yahweh ne Musa ama, <<Mǝ nǝ kpata cau mana a na ka, acemǝnana a kumǝna earmúrú abanam, sǝ ǝn súrǝ́nà rǝò nǝ lúllǝò.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa pǝlǝa na ama, <<Mǝ nda ban zǝmbo, lǝmdǝam rǝò aɓa ɓoarɓwa mò.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Sǝ Yahweh ne Musa ama, <<Mǝ nǝ tsǝk ɓoarɓwa mem kat ɓǝ̀ yi kúti a ɓadǝmbo, sǝ mǝ nǝ hambô lullǝam mana à tunǝki ama <Yahweh> ka. Mǝ nǝ lǝmdǝ ɓwamuru aban ɓwa mǝnana mǝ nǝ lǝmdǝì wi ɓwamuru ka, sǝ mǝ nǝ sǝn mǝsǝswatǝr mala ɓwa mǝnana mǝ nǝ sǝn mǝsǝswatǝr male ka. ");
INSERT INTO mbu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Sǝ ɓamǝsǝam ngga, a pà nǝ gandǝ sǝne ɗàng, acemǝnana kǝɓwa pà kàm mǝnana nǝ̀ sǝnam sǝ nǝ̀ au ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Pǝlǝa Yahweh lidǝmba, ne wi ama, <<Sǝni, cam kani a banam amur mbisong man. ");
INSERT INTO mbu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ɓǝ̀ ɓoarɓwa mem na rǝ kúti ka, mǝ nǝ oasǝǒ aɓa sà-tali, mǝ nǝ gìr muro nǝ buam, she ɓǝ̀n kutinǒ ka. ");
INSERT INTO mbu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Sǝ mǝ nǝ twal buam, ace mǝnana wu sǝn nzǝmam ngga. Sǝ ɓamǝsǝam ngga, kǝɓwa pà nǝ̀ sǝni ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Pǝlǝa Yahweh banggi Musa ama, <<Ɓun aɓea akpamgbǝlang tali ɓari kǝla atali amǝdǝmbe. Mǝ nǝ gilǝ gir amuria, kǝ akǝ cau mǝnana à nda amur akpamgbǝlang tali mǝnana a arkia ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Gilǝrǝò ace dǝmbari mala lí, awu nǝ eauwe amur Nkono Saina, awu nǝ lǝmdǝ rǝò abanam a ɓong nkono. ");
INSERT INTO mbu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ɓǝ̀ kǝɓwa ɓǝ̀kǝa yiu atò ɗàng; sǝ ɓǝà kǝa sǝn ɓè kǝɓwa a bum ban mala mǝnia yi nkono ka ɗàng; ko anzur, ko andá ka, ɓǝà kǝa sǝnia aban likiagir a kusǝ nkono ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa pǝlǝa ɓun akpamgbǝlang tali ɓari, kǝla amana a dǝmbe ka. Twalia a buì nǝ dǝmbari ɗiɗyal sǝ kya eau nǝia amur Nkono Saina, kǝla mǝnana Yahweh tsǝa ama ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yahweh yiu sulǝo aɓa pǝrɓang, yi cam kanó a ban Musa, sǝ tunǝ lullǝu mana ama, Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yahweh pǝlǝa gya kúti a ɓadǝm Musa, sǝ hama ama, <<Mǝ nda Yahweh! Nggearǝ Yahweh! Mǝ nda Ɓakuli mana lùmsǝ nǝ mǝsǝswatǝr andǝ ɓwamuru ka! Bumam kǝ kaurǝa lúllô ɗang, sǝ ǝn lumsǝ nǝ earcearǝu mana kǝ gatti raka, andǝ domǝsǝcau. ");
INSERT INTO mbu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ən nggǝ bwal earcearǝu mem nǝ mǝsǝcau aban aɓwana arǝ anza á-pas. Ən nggǝ twalban ɓealɓikea, andǝ mgbikiru, andǝ cauɓikea; sǝama, pà mǝ nǝ nying ɓwa mǝnana à kumi nǝ ɓealɓikea ka, ɓǝ̀ o atarǝì ɓà ɗàng. Ən nggǝ yinǝ ɓashi ace acauɓikea mala atárrú amur amunia andǝ amǝ'keà, aban ká tàruia andǝ inea nza malea.>> ");
INSERT INTO mbu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kara Musa ɓunno amur ankūnǝi a nzali akaurǝa, sǝ peri. ");
INSERT INTO mbu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Pǝlǝa na ama, <<Yahweh, ɓǝ̀n kumǝna earmúrú a bano ado ka, ida, We Yahweh do atà sǝm aɓa o ma'sǝm. Aɓwana mǝnia ka, amǝ ɓamúr-candǝa na. Sǝama, twala-sǝm-ban ɓealɓikea andǝ cauɓikea ma'sǝm. Ak sǝm kǝla agirkuma mò.>> ");
INSERT INTO mbu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yahweh pǝlǝa earî Musa ama: Adyan ngga, mǝ ndya ǝn nggǝ kùrcau nǝ amǝ Isǝrayila ka. A ɓamǝsǝia kat, mǝ nǝ pakki agir-ndǝlǝki mǝnana à malaká pea aɓa ɓanza ko a ɓekǝ nzali raka. Sǝ aɓwana mǝnana kat wu do aɓalǝia ka, à nǝ̀ sǝn túró mem, Mim Yahweh, acemǝnana gìr'ndali na mǝ nǝ pàngnǝ wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Wu kpata anzongcau mana ǝn nggǝ pà wun ado ka. Sǝni, mǝ ndya mǝ nǝ pǝr amǝ'Amor, andǝ amǝ'Kan'ana, andǝ amǝ'Hitti, andǝ amǝ'Periz, andǝ amǝ'Hivi, andǝ amǝ'Jebus, a ɓadǝm wun ngga. ");
INSERT INTO mbu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wu tsǝkir wun, wu kǝa na ama wun nǝ̀ kùtí aɓa ɓekǝ kùrcau wunǝ aɓwapǝndǝa mǝnana à do a nzali mǝnana ado wun nǝ̀ ká kàm ngga ɗàng. Ɓǝ̀ wu pàk anggo ka, wun nǝ̀ kpa aɓalǝ agir-tamban malea. ");
INSERT INTO mbu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A kún mani ka, wun nǝ̀ bǝbbǝriki agyangŋan malea, wun nǝ̀ kiɗikia. Wun nǝ̀ arki akúnamúrú malea, sǝ wun nǝ̀ kasǝki anggun peri mala Ashera, yì mā-ɓakuli malea. ");
INSERT INTO mbu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Wu kǝa na ama wun nǝ̀ ɓunno a nzali, wun nǝ̀ peri aban ɓekǝ ɓakuli ɗang, acemana Mim Yahweh, mǝnana lullǝàm nda Mɓali ka, mǝ nda Ɓakuli mǝ'mɓali. ");
INSERT INTO mbu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Wu tsǝkir wun, wu kǝa kúti aɓa ɓekǝ kùrcau wunǝ aɓwana mana à do a nzali mǝnia ka ɗàng. Acemǝnana yia ka, ɓǝ̀ à nǝ̀ peri aban aɓakuli malea, sǝ à nǝ̀ ɗārǝ́ agir'nkila aban aɓakuli malea ka, à nǝ̀ tunǝ wun ama wu kya ateà, sǝ wun nǝ̀ liki agirlina mala gir'nkila malea. ");
INSERT INTO mbu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Sǝ amuna-burana ma'wun nǝ̀ alki amuna-mamǝna malea mǝnana à kǝ peri aban aɓakuli malea ka. Sǝ yia ka, à nǝ̀ swár amuna-burana ma'wun ɓǝà pàk cauɓikea arǝàm nǝ kpata aɓakuli malea. ");
INSERT INTO mbu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","A pà wu nǝ pàkkî ɓamúrò ɓekǝ ɓakuli mǝnana à tùllì nǝ bolo-ntùl ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Awu nǝ bwal Lamsan mala Bǝredi mǝnana Yis pà arǝì raka, nǝ pakkiɗire male. Kǝla mǝnana ǝn bangga wun ngga, wun nǝ̀ twal anongŋo tongno-nong-ɓari a nzǝmarǝia mǝnana aɓalǝia ka, pà wu nǝ̀ shak bǝredi mǝnana à pè nǝ yis arǝì ka ɗàng. Koya pǝlǝa ka, wun nǝ̀ nggǝ pak mǝnia yì lamsan ngga a pwari mǝnana ǝn kanì ka, aɓa zongŋo Abip; acemǝnana aɓa zongŋo Abip sǝ wu nying Masar. ");
INSERT INTO mbu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Koya muna-dǝmba muna-ɓwabura mǝnana tita puro a bum ngge ka mem na; kat andǝ ajamna muna-ndá, andǝ ajamna muna-nzur, andǝ ajamna muna-mbul, mǝnana à tita puro a bum anggea ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Jamna muna mǝdambǝriso mǝnana tita puro a bum ngge ka, awu nǝ akmúrí a buam, Mim Yahweh, ɓǝ̀ nyare ɓǝ̀ duk mô nǝ pǎ muna-nzur a kunì. Ɓǝ̀ a pà wu nǝ akmúrí raka, awu nǝ ɓùn myali. Ɗǝm ngga dumǝna púp atà amuna mô ka, koya muna-ɓwabura mǝnana muna-dǝmba na ka, awu nǝ akmúrí nǝ pǎ muna-nzur a kunì. Kǝɓwa ɓǝ̀ kǝa yiua peri abanam nǝ ɓabui atarǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Wun nǝ̀ pàk túró aɓa nongŋo tongno-nong-mwashat, sǝ aɓa tongno-nong-ɓaria pwari ka, wun nǝ̀ usǝlǝo; ko ɓǝ̀ nda nǝ kún rya ko nǝ kún pwan-gìrɓaban ngga, she wun nǝ̀ usǝlǝo. ");
INSERT INTO mbu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Dumǝna púp, wun nǝ̀ nggǝ pakkiɗire Lamsan mala Alimo nǝ paɓoro mala mǝssa mǝnana wu tita pwane a ɓaban ngga, andǝ pakkiɗire mala Lamsan mala Pwan-Gìrɓaban Kat-kat aban yinǝe a ɓala a masǝlǝata pǝlǝa. ");
INSERT INTO mbu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Kusǝ tàrú a koya pǝlǝa ka, aburana kat à nǝ̀ yiua peri a ɓadǝmbam, Mim Yahweh, yi Ɓakuli mala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mǝ nǝ pǝr aɓwana mala aɓea nzali a ɓadǝm wun, sǝ mǝ nǝ tangsǝ anzong-nzali ma'wun; kǝɓwa pà kàm nǝ̀ sham nzali ma'wun ɗàng, mana ɓǝ̀ wu yiu a peri abanam, Mim Yahweh, koya pǝlǝa arǝ abu-pǝlǝa mala alamsan mǝno tàrú ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ɓǝ̀ wun nǝ̀ pà nkila mala gìr'nkila abanam ngga, pà wun nǝ̀ pè nǝ bǝredi mǝnana à tsǝki wi yis arǝì ka ɗàng. A pwari pakkiɗire mala Lamsan mala Yàlîmurû ka, wu kǝa nying ɓekǝ nyam girkusǝu mǝnana à pana gir'nkila nǝi ka ɓǝ̀ ueo ɓè bankwari ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Koya pǝlǝa ka, wun nǝ̀ twal ban mǝɓoarne kat-kat mala aɓǝlagir mǝdǝmbe mǝnana wu pwano arǝ aɓaban ma'wun ngga, wu yinǝi a ɓala mem, Mim Yahweh, Ɓakuli ma'wun. A pà wunǝ lam muna-mbul ko muna-nzur nǝ mùr'kiura nggè ɗàng. ");
INSERT INTO mbu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yahweh pǝlǝa banggi Musa ama, <<Gilǝ amǝnia yì acau ka, acemǝnana nǝ acau mǝnia ka, sǝ ǝn kùrcau sǝnǝ we andǝ amǝ Isǝrayila.>> ");
INSERT INTO mbu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa ka nda kanó andǝ Yahweh amur nkono dù lumi-ine andǝ pwari lumi-ine; aɓalǝ anongŋo mǝno anggo ka, ko li girlina ɗang sǝ nù mùr gbal ɗàng. Sǝ Yahweh gilǝ acau mala mǝnia yì kùrcau mǝnana pè andǝ aɓwana male ka, yì Anzongcau Lum, amur akpamgbǝlang tali mǝno. ");
INSERT INTO mbu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Lang Musa sulǝî múr Nkono Saina, nǝ akpamgbǝlang tali mǝno ɓari a buì, yì akpamgbǝlang tali Acau-nakûn ngga, ko sǝlǝ ama ɓamǝsǝi kǝ tà'nzama ɗàng; ɓamǝsǝi kǝ tà'nzama ace nacau mana à na andǝ Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna andǝ amǝ Isǝrayila kat pǝlǝ mǝsǝia à sǝn Musa, sǝ à sǝni ka, nggú ɓamǝsǝi kǝ tà'nzama, sǝ ɓangciu pakkia wia arǝ gbashi baní. ");
INSERT INTO mbu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pǝlǝa Musa tunǝia, sǝ Haruna andǝ aɓwana-mǝgule kat mala ɓinala amǝ Isǝrayila nyare a baní, sǝ Musa nacau nǝia. ");
INSERT INTO mbu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Anzǝm mani ka, amǝ Isǝrayila kat, sungŋo a baní tù, sǝ banggia wia anggurcau mana Yahweh banggi wi amur Nkono Saina ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Sǝ lang Musa malǝna nacau nǝia ka, pǝlǝa gìr ɓamǝsǝi nǝ lagir. ");
INSERT INTO mbu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sǝ pwari mana kat Musa wari a ɓadǝm Yahweh ace nacau nǝi ka, nǝ̀ pusǝ lagir mǝno gìrna ɓamǝsǝi nǝi ka, sheɓǝ̀ purnì ɓadǝm Yahweh ka. Sǝ ɓǝ nyarǝna yina aban amǝ Isǝrayila ka, nǝ̀ banggia wia gìr mana Yahweh banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Amǝ Isǝrayila sǝn Musa ka, nggú ɓamǝsǝi kǝ tà'nzama gbǝang. Pǝlǝa yì gbal ka, nǝ̀ gìr ɓamǝsǝi nǝ lagir, bà pwari mǝnana nǝ̀ ká nacau nǝ Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa ram ɓinala amǝ Isǝrayila kat, sǝ banggia wia ama, <<Amǝnia ka à nda ka nggurcau mǝnana Yahweh tsǝka wun ama ɓǝ̀ wu kpatea ka ama: ");
INSERT INTO mbu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","<<Wun ndanǝ anonggio tongno-nong-mwashat mǝnana aɓalǝia ka, wun nǝ̀ pàkki atúró ma'wun. Sǝama tongno-nong-ɓaria pwari ka, nǝ̀ do pwari mǝfele na ace wun; pwari Sabbat na à tàrì aban Yahweh ace usǝlǝo. Ɓwa mǝnana pàk túró a mǝnia yì pwari ka, à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Yàle wu kǝa bwal kǝ bǝsa arǝ aɓala ma'wun a pwari Sabbat ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa lidǝmba bang cau nǝ ɓinala amǝ Isǝrayila kat ama, <<Mǝnia ka nda nggurcau mana Yahweh pa ka, ama: ");
INSERT INTO mbu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","<<Wu twal aɓalǝ agirkuma ma'wun, wu pa ɓoro aban Yahweh. Ɓwa mǝnana kat earna a ɓabumi ka, ɓǝ̀ yinǝì Yahweh ɓoro atà amǝnia yì agir ka: bolo-njengǝlan, andǝ bolo-azǝrfa, andǝ bolo-bángŋá; ");
INSERT INTO mbu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe; nkonggúr-linǝn mǝɓǝlke mana à pyauwì ka, andǝ nggubyau nyang-mbulpǝndǝa; ");
INSERT INTO mbu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","nggú gam mǝnana à bàngsǝí ka; nggú mǝɓǝlke mala ambulpǝndǝa; kpamgbang mala nggun-akasiya; ");
INSERT INTO mbu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mùrú olif ace pitǝla; amuku-agir mǝ'kuskushi ace mùrú ɗārǝâ, sǝ ace muku-gìr loasǝ yele mǝ'rǝmɓoarne; ");
INSERT INTO mbu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","amunatali-onis, andǝ amǝsǝtali-gǝna ace gilǝkice rǝ efot, andǝ lǝpan-damɓalǝu male. ");
INSERT INTO mbu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","<<Koya ɓwa aɓalǝ wun mǝnana mǝ'sǝlǝ pakkiagir na ka, ɓǝ̀ yiu ɓǝà yi pak amǝnia yì agir mǝnana kat Yahweh tsǝa ama ɓǝà peǎ ka: ");
INSERT INTO mbu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Taragula, andǝ alagìr mana à kàrì, andǝ lagìr-nggû ace kùmsǝ múr Taragula; andǝ anlǐ-gyargìr, andǝ anggun-tara, andǝ anggun-gangndea; andǝ anggun-ɓalǝu andǝ agumtǝli-tǝrteà; ");
INSERT INTO mbu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","andǝ Akwati Kùrcau, andǝ agara twale, andǝ gìrkúni mǝnana nda buno sǝntǝ̀r ka, andǝ lagìr-kasǝbân mǝnana nǝ̀ gbàrì ka; ");
INSERT INTO mbu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","andǝ kpamgbang-tsǝk-agir andǝ agara twale, andǝ akwar male, andǝ bǝredi mala ɓadǝm Yahweh; ");
INSERT INTO mbu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","andǝ gìr tamsǝ apitǝla ace pà tǎlaban andǝ agirtúró male kat; andǝ apitǝla andǝ mùrú olif ace tsǝk bǝsa malea; ");
INSERT INTO mbu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","andǝ gyangŋan mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne, andǝ agara twale; andǝ mùrú-ɗārǝ́bân, andǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne; andǝ lagìr-gyare a kún bankutio aɓa Taragula; ");
INSERT INTO mbu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","andǝ gyangŋan mala pagìr ace pisǝe kǝring andǝ bàndà bolo-bángŋá male, andǝ agara twale andǝ agirtúró male kat; andǝ nkenye lákkí arǝu andǝ girtàmsǝe; ");
INSERT INTO mbu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","andǝ alagìr ace gumbǝli patal mala Taragula, andǝ anggun-kala male andǝ agumtǝli-tǝrteà mana à nǝ̀ camgi aɓalǝia ɓǝà kàrì patal ka; andǝ lagìr ace gbar kún patal; ");
INSERT INTO mbu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","andǝ ankpako mala anggúr Taragula andǝ mala anggun-kal patal; ");
INSERT INTO mbu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","andǝ adaura-pǝris mǝnana à teǎ pepè ace peri, yì adaura mǝfele ace Haruna pǝris mǝgule, andǝ adaura mala amuna-burana male, mǝnana à nǝ̀ oasǝ arǝia ɓǝ̀ à nǝ̀ pàk túró pǝris aɓa Ban Mǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Nda ɓinala amǝ Isǝrayila kat purî ɓadǝm Musa. ");
INSERT INTO mbu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Koya ɓwa mǝnana twalcau a bumi nǝ̀ pàk ɓè gìr, andǝ koyan mǝnana bangŋo male loasǝi ka, à puro à yinǝì Yahweh ɓoro mala aɓea agir ace loasǝ Tara Ban-peri, ace pàkki atúró kat aɓalǝi, sǝ ace adaura mǝfele mala apǝris. ");
INSERT INTO mbu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Aɓwana kat, aburana andǝ amamǝna, mǝnana à ndanǝ ɓabum mala earce pà gìr ka, à yinǝ aɓoro mala agirgilǝki-rǝu, agirkiru, agirmunabu, agirgarabu, andǝ agir ɗàngɗáng mǝnana à peǎ nǝ bolo-njengǝlan ngga; koyan ngga pà gìr bolo-njengǝlan male, ɓoro na aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Koyan mǝnana ndanǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ nggubyau-linǝn mǝɓǝlke, andǝ nyang mbulpǝndǝa, andǝ nggú nzur mǝnana à bàngsǝí, ko nggú mǝɓǝlke mala ambulpǝndǝa ka, à yinǝia. ");
INSERT INTO mbu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ɓwa mana kat ndanǝ bolo-azǝrfa ko bolo-bángŋá ka, yinǝi yi pana ɓoro nǝi aban Yahweh, sǝ ɓwa mana kat ndanǝ nggun-akasiya mǝnana à nǝ̀ pàngŋǝ̀nà túró nǝi ace koya ulang túró ka, yinǝi. ");
INSERT INTO mbu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Amamǝna mana kat à sǝlǝ túróbù ka, à pyau nkonggúr nǝ bu, sǝ à yinǝ ankonggúr linǝn mǝɓǝlke andǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe mǝnana à pyau ka. ");
INSERT INTO mbu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Sǝ amamǝna mana kat à súrǝ̀ túró pyau nyang mbul, sǝ ɓabumia loasǝia ka, à pàk túrè. ");
INSERT INTO mbu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Amǝ'yálmúrû yinǝ amunatali-onis, andǝ amǝsǝtali-gǝna mǝtà'nzame ace gilǝkice rǝ efot, andǝ lǝpan-damɓalǝu male. ");
INSERT INTO mbu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Aɓea gir ɗǝm mana à yinǝia ka, à nda ka amuku-agir mǝ'kuskushi ace loasǝ yele mǝ'rǝmɓoarne, andǝ mùrú olif ace ɗārǝâ, sǝ ace tsǝk bǝsa a pitǝla. ");
INSERT INTO mbu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Amǝ Isǝrayila kat, aburana andǝ amamǝna, mǝnana ɓabumia eare à nǝ̀ yinǝ koman kat ace túró mana Yahweh bangŋǝ́nì Musa ama ɓǝà pè ka, à yinǝia à yi pana ɓoro nǝia aban Yahweh, kǝla mana ɓabumia twal ka. ");
INSERT INTO mbu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Pǝlǝa Musa banggi amǝ Isǝrayila ama, <<Wu sǝni, Yahweh tunǝna sǝ twalna Bezal-El, muna-ɓwabura mala Uri, mǝkà Hur, a tàu mala Yahuda; ");
INSERT INTO mbu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","sǝ lùmsǝ̀nì nǝ Bangŋo mala Ɓakuli, pani wi kwárô aɓa ɗenyicau, andǝ sǝlǝe, andǝ bwaltagìr, andǝ súrǝ̀ pàk koya ulang gìr nǝ bu; ");
INSERT INTO mbu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","nǝ̀ gandǝ nyoulǝ pǎ mala anggaman gìr amǝɓoarsǝne ɗàng-ɗáng andǝ tùlki agir nǝ bolo-njengǝlan, bolo-azǝrfa, andǝ bolo-bángŋá; ");
INSERT INTO mbu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ndanǝ sǝlǝpe mala kpaliki rǝ atali-gǝna ace oasǝkia aɓalǝ agir-bwalia, andǝ mala shàr nggun, ace pusǝ anggaman gìr ɗàng-ɗáng. ");
INSERT INTO mbu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yahweh pani wi andǝ Oholiyap, muna-ɓwabura mala Ahisamak, a tàu mala Dan, sǝlǝe mala kànî aɓwana túróbù malea. ");
INSERT INTO mbu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Lùmsǝ̀nia nǝ sǝlǝpe mala pàkki atúróbù kat mala mǝ'nyoulǝ pa mala agir; andǝ mala mǝ'mbàkì gìr mǝɓoarsǝne arǝ nggubyau nǝ nkonggúr mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ nkonggúr linǝn mǝɓǝlke; andǝ mala mǝ'tà-nggubyau. Yale à nǝ̀ gandǝ pak koya ulang nggaman túróbù. ");
INSERT INTO mbu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","<<Bezal-El, andǝ Oholiyap, andǝ acili amǝ'túróbù mǝnana kat Yahweh pania wia sǝlǝe andǝ bwaltagìr, yia mǝnana à súrǝ̀ lang sǝ à nǝ̀ pàk koya túró mala pàk Tara-mǝfele ka, à nǝ̀ pàk túrè aɓa kpata gìr mǝnana kat Yahweh tsǝk ama ɓǝà pè ka.>> ");
INSERT INTO mbu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Nda Musa túrban à tunǝ a Bezal-El andǝ Oholiyap andǝ koya mǝ'sǝlǝ pakkiagir, yià mǝnana Yahweh pania wia sǝlǝpe a ɓabumia, koyan ateà mǝnana ɓabumi loasǝi ka, ɓǝà yiu ɓǝà pàk túrè. ");
INSERT INTO mbu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa pea wia aɓoro mǝnana kat amǝ Isǝrayila yinǝia ace pàk túró mala Tara-mǝfele ka. Sǝ kat andǝ amǝno ka, aɓwana lidǝmba nǝ yinǝì Musa aɓoro malea mǝnana à pa nǝ eare mala ɓabumia ka koya dǝmbari. ");
INSERT INTO mbu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nda amǝ'túróbù mǝnia kat, yià mana à kǝ pàkkì atúró ɗàngɗáng mala Tara-mǝfele ka, koyan ngga nying bui arǝ túró mǝnana pàkkiyi ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","À lo à wari aban Musa sǝ à banggi wi ama, <<Aɓwana pànà gìr mǝnana kútì mana kārǝ́na ace mal túró mǝnana Yahweh tsǝka sǝm ama ɓǝ̀ sǝm pè ka, sǝ à nda rǝ yinǝ agir più!>> ");
INSERT INTO mbu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Pǝlǝa Musa tasǝban ɓǝà hamnǝ cau aban aɓwana arǝ abân kat aɓa là-gumli ama, <<Aɓwana ɓǝà tàmsǝ pagìr ace túró mala Tara-mǝfele, kārǝ́na anggo.>> Nda aɓwana came, à yinǝ ɓekǝ ɓoro ɗǝm ace túró Tara-mǝfele raka. ");
INSERT INTO mbu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Agir mǝnana aɓwana angŋa dǝmba à pànà ka, à kútì mana à nǝ̀ earce ace pàk túrè kat ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Amǝ'sǝlǝ pakkiagir mǝnana kat aɓalǝ amǝ'túró mǝnia ka, à pàk alagìr mǝtangge lum ace kùmsǝ múr tara mala Taragula. Yì alagìr ka, à peǎ nǝ anggubyau linǝn mǝɓǝlke mana à tè mǝsǝi kèkì ka. Mǝ'sǝlǝ tagìr tà aɓǝ̀nzál mala acerup arǝia nǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe mǝnana à pyauwì ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Yì alagìr ka gulo malea kārǝa; komǝye ka sauwa male na ɓakusǝu lumi-ine nong ɓari (42), sǝ tangŋa malea ka ɓakusǝu tongno-nong-mwashat na. ");
INSERT INTO mbu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Tongno atà alagìr man ngga à swària a kunarǝia à duk lagìr mǝsauwe mwashat, sǝ acilia man tongno gbal ka à swària a kunarǝia à duk ɓè lagìr mǝsauwe mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","À pàk atǝkrǝk nǝ nkonggúr ɗà'ndíng mǝlùre, sǝ à ɗúrkia a nkanggari arǝia a kún alagìr mǝsake mǝnia ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","À ɗúrki atǝkrǝk nkonggúr lumi-tongno a kún ɓè lagìr mǝsauwe man mwashat ka, sǝ à ɗúrki lumi-tongno a kún ɓaria lagìr mǝsauwe. Atǝkrǝk mala ɓè lagìr ka à came a nkāɓe gǝ̀rgǝ̀r nǝ atǝkrǝk mala ɓì lagìr. ");
INSERT INTO mbu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","À pàk anlǐ-bwalkúngir lumi-tongno nǝ bolo-njengǝlan. À bwalki atǝkrǝk kún ɓè lagìr mǝsauwe man mwashat ka, sǝ à kpapia a kúnarǝ atǝkrǝk kún ɓe lagìr mǝsauwe mǝno ka, nǝ anlǐ-bwalkúngir, sǝ alagìr mǝsake mǝnia ɓari ka à duk mwashat. Anggo sǝ do ama tara mala Taragula ka, lagìr mwashat na à kùmsǝì nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","À pàk alagìr lum-nong-mwashat nǝ anggu-mbulpǝndǝa ace kùmsǝ múr tara mala Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Amǝnia yì alagìr lum-nong-mwashat ka à kārǝa; sauwa mala komǝye ka nda ɓakusǝu lumi-ine bwamdǝ tongno, sǝ tangŋa mala komǝye ka ɓakusǝu tongno-nong-mwashat na. ");
INSERT INTO mbu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Tongno ateà ka à kpapia sǝ à swària a kunarǝia à duk lagìr-nggû mǝsauwe mwashat, sǝ aman tongno-nong-mwashat ka à swària gbal a kunarǝia à duk ɓaria lagìr-nggû mǝsauwe. ");
INSERT INTO mbu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","À ɗúrki atǝkrǝk nkonggúr lumi-tongno a nkanggari arǝia a gírí-kún ɓe lagìr-nggû mǝsauwe mǝnia, sǝ à ɗúrki lumi-tongno a nkanggari arǝia a gírí-kún ɓi lagìr-nggû mǝsauwe man mwashat, mǝnana à nǝ̀ kpapia a kunarǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","À pàk anlǐ-bwalkúngir nǝ bolo-bángŋá, yia lumi-tongno. À oasǝkia aɓalǝ atǝkrǝk gírí-kún alagìr-nggû amǝsake mǝnia ɓari ka, sǝ à kpapia a kúnarǝia à duk lagìr-nggû nggea mǝgule mwashat, mǝnana à gìrna múr Taragula nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","À pàk aɓea lagìr-nggû kàm ɓari ɗǝm ace kùmsǝ múr Taragula. Man mwashat ka à pè nǝ anggû ka gam mǝnana à bangsǝi ka, sǝ ɓè man, mǝnana masǝlǝi aɓî nǝ̀ sarǝa amúrià a kùli ka, à pè nǝ nggú mǝɓǝlke mala ambulpǝndǝa. ");
INSERT INTO mbu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","À pàk anggun-tara mǝ'sàré ace Taragula nǝ akpamgbang mala nggun-akasiya. ");
INSERT INTO mbu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dāh'rya mala koya nggun-tara ka ɓakusǝu lum-bwamdǝ-tongno na, sǝ tangŋa mala komǝye ka, ɓakusǝu ɓari nǝ incì tàrú na. ");
INSERT INTO mbu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Akpamgbang ɓari mala koya nggun-tara ka, à kārǝ́ kunia gǝ̀rgǝ̀r sǝ à shària pyalpyal. Anggo sǝ à pàk anggun-tara mala Taragula kat. ");
INSERT INTO mbu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","À pàk anggun-tara mala Taragula kǝla mǝno ka, sǝ à tamsǝkia ani: lumi-ɓari ka à tsǝia a bumban mǝnana sǝn njar-kunmur ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","À pàk agumtǝli-tǝrtà anggun-tara nǝ bolo-azǝrfa yià lumi-ine ace bwal akusǝ anggun-tara lumi-ɓari; agumtǝli-tǝrtè ɓari, komǝye ka nǝ tūli male arǝì, na a kusǝ koya nggun-tara, ace bwal akusǝ akpamgbang amǝ'pyalpyalni ɓari mala nggun-tara. ");
INSERT INTO mbu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A bumban mala Taragula mǝnana sǝn njar-nza ka, à tsǝk anggun-tara lumi-ɓari, ");
INSERT INTO mbu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","nǝ agumtǝli-tǝrteà mǝnana à pea nǝ bolo-azǝrfa ka lumi-ine, ɓari a kusǝ koya nggun-tara. ");
INSERT INTO mbu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Sǝ ace nzǝm Taragula, yì bumban mǝnana sǝn njar-nzali ka, à tsǝk anggun-tara tongno-nong-mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","À tsǝk aɓea anggun-tara ɓari ɗǝm, mwashat ace koya bankara a nzǝm Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Anggun-tara ɓari-ɓari arǝ abankara ɓari ka, à kpapi tǝrtea a ban mǝ'mwashati, sǝ múrià ka à kùria nǝ gbalmo kàngkàng à duk mwashat a koya bankara. Yì anggun-tara arǝ abankara mǝno ɓari ka anggo sǝ à pangnǝia. ");
INSERT INTO mbu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Lǝmdǝ ama à kpapia kat ka, nzǝm Taragula na nǝ anggun-tara tongno-nong-tàrú aban came aɓalǝ agumtǝli-tǝrteà lum-bwamdǝ-tongno-nong-mwashat, mǝnana à peǎ nǝ bolo-azǝrfa ka; koya nggun-tara ka, akusǝi cam aɓalǝ agumtǝli-tǝrtè ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","À pàk anggun-gangndea lum-bwamdǝ-tongno mala nggun-akasiya ace kpapiki anggun-tara. À tsǝk anggun-gangndea tongno à kpapiki anggun-tara mala Taragula a bumban mǝnana sǝn njar-nza ka, ");
INSERT INTO mbu_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","tongno a bumban male mǝnana sǝn njar-kunmur ka, sǝ tongno a nzǝmi, yì bumban mǝnana sǝn njar-nzali ka. ");
INSERT INTO mbu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A koya bumban mala Taragula ka, à tsǝk nggun-gangndea mǝnana à bwalki anggun-tara a tsùrú malea ka; tite arǝ nggun-tara mǝnana nda a masǝlǝata ban ngga aban ká ɓè masǝlǝata ban mala Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Anggun-tara ka à tasǝrǝia nǝ bolo-njengǝlan, sǝ à kùrkia wia agbalmò bolo-njengǝlan ace bwal anggun-gangndea mǝnana à nǝ̀ oasǝkia aɓalǝia ka. Yià anggun-gangndea ka à tasǝrǝia gbal nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","À pàk lagìr-kasǝbân ace gau ɓá Taragula nǝ nggubyau-linǝn mǝɓoarne mǝnana à tè mǝsǝì kèkì ka. Mǝ'sǝlǝ pakkiagir pàktúró nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe sǝ tà pǎ mala acerup à lǝmdǝa arǝì. ");
INSERT INTO mbu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ace gyar mǝnia yì lagìr-kasǝbân ngga, à kasǝ anggun-ɓalǝu mala kpamgbang-akasiya amǝsake ine mǝnana à tasǝrǝia nǝ bolo-njengǝlan ngga. Komǝye ka à pàkki wi gumtǝli-tǝrtè nǝ bolo-azǝrfa ace tamsǝe aɓalǝi, sǝ à pàk anlǐ-gyargìr malea nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ace gbar bankutio aɓa Taragula ka, à pàk lagìr-gbarban nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pūrǝki arǝarǝia ka. Mǝ'sǝlǝ tagìr nǝ bù, mbákí rǝì nǝ tagìr mǝɓoarsǝne, nǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe. ");
INSERT INTO mbu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","À pàk anggun-ɓalǝu mǝsake tongno andǝ anlǐ-gyargìr malea. À tasǝ rǝ anggun-ɓalǝu mǝnia andǝ ankò malea nǝ bolo-njengǝlan, sǝ agumtǝli-tǝrteà ka bolo-bángŋá na. ");
INSERT INTO mbu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezal-El gbàllì Akwati Kùrcau nǝ kpamgbang mala nggun-akasiya; sauwa male ka ɓakusǝu tàrú nǝ incì tongno-nong-ine na, tangŋa male ka ɓakusǝu ɓari nǝ incì tàrú, sǝ dāh'rya male ka ɓakusǝu ɓari nǝ incì tàrú na. ");
INSERT INTO mbu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne, ɓālǝi andǝ nzǝmi, sǝ ɓak bolo-njengǝlan kàrì kúni kat. ");
INSERT INTO mbu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Tùl agbalmò ine mala bolo-njengǝlan ace, sǝ komǝye ka kpapì arǝ nkanggariban mala mwashat atà akusǝ akwati. ");
INSERT INTO mbu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Shàr agara mala nggun-akasiya sǝ tasǝ rǝia nǝ bolo-njengǝlan, ");
INSERT INTO mbu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","sǝ oasǝ agare aɓalǝ agbalmò mana arǝ ankanggariban mala Akwati ka ace twale. ");
INSERT INTO mbu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Pǝlǝa pàk gìrkún Akwati nǝ bolo-njengǝlan mǝɓoarne kat, ɓǝ̀ do nda buno sǝntǝ̀r. Sauwa male ka ɓakusǝu tàrú nǝ incì tongno-nong-ine na, sǝ tangŋa male ka ɓakusǝu ɓari nǝ incì tàrú na. ");
INSERT INTO mbu_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Tùl aɓǝ̀nzál mala acerup ɓari nǝ bolo-njengǝlan mǝnana à walki ka, sǝ tsǝia arǝ akún-bân ɓari amur gìrkún Akwati, yì gìrkúni mǝnana nda buno sǝntǝ̀r ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Tsǝk cerup man mwashat ka a ɓè kún-bân, sǝ ɓè cerup ka tsǝì a nkāɓe ɓì a ɓè kún-bân amur gìrkún Akwati. Bolo-njengǝlan mǝnana à pàk acerup nǝi ka kpapì arǝ bolo-njengǝlan mǝnana à pàngŋǝ̀nà gìrkún Akwati nǝi ka, ace mǝnana ɓǝà duk mwashat ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Tsǝk acerup, komǝye ka ɓamǝsǝi pǝlǝ nǝban ɓamǝsǝ ɓi. Ɓamǝsǝia kǝ sǝn múr gìrkún Akwati, yì buno sǝntǝ̀r, sǝ abuia mǝnana à mǝn a kùli ka, à kùmsǝó amur gìrkúni, yì buno sǝntǝ̀r. ");
INSERT INTO mbu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezal-El andǝ aɓî amǝtúró pǝlǝa à gbàllì kpamgbang mala nggun-akasiya, ace tsǝk agir amurí; sauwa male ka ɓakusǝu tàrú na, tangŋa male ka ɓakusǝu mwashat nǝ incì tongno-nong mwashat, sǝ dāh'rya male ka ɓakusǝu ɓari nǝ incì tàrú na. ");
INSERT INTO mbu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","À gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne, sǝ à ɓak kúní kàrì nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Múr kpamgbang mana sárǝ́ ka, pàkki wi mǝ-nzong mǝnana nyane male ka incì tàrú na ka, kàrì kúní kat, sǝ ɓak bolo-njengǝlan kàrì mǝ-nzongnì. ");
INSERT INTO mbu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","À tùl agbalmò ine nǝ bolo-njengǝlan sǝ à tsǝkia arǝ abankara ine arǝ akusǝ kpamgbang ine. ");
INSERT INTO mbu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Yìa agbalmò ine ka à tsǝia à gbàshìban nzong kún kpamgbang mala tsǝk agir arǝ akusǝì, ace bwal agara mǝnana à nǝ̀ nggǝ twali nǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Yì agara ace twale ka à pea nǝ nggun-akasiya sǝ à gìr rǝia kat nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","À pàk atanggǝla mala múr kpamgbang nǝ bolo-njengǝlan mǝɓoarne; yì aparanti male, andǝ atasau male ace loasǝ yele mǝ'rǝmɓoarne, andǝ amuna-nkenye male, andǝ amuna-bàng male mala a pàgir mala girnùná. ");
INSERT INTO mbu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","À pàk gìr tàmsǝ apitǝla nǝ bolo-njengǝlan mǝɓoarne. Kusǝì andǝ garè mǝnana nǝ̀ cam a ɓaɓalǝu, andǝ nyoulǝa rǝi mǝnana kǝla tǒ mala fufe, andǝ apwasǝe andǝ atǝ́r-fufe ka, à pea kat nǝ gumtǝli bolo-njengǝlan mwashat mǝnana à walki ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","À pè nǝ abui tongno-nong-mwashat mǝnana à san arǝ garè mana a ɓaɓalǝu ka; tàrú a nkanggari man sǝ tàrú a ɓè nkanggari. ");
INSERT INTO mbu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Komǝye atà abui tongno-nong-mwashat ka à ɓak rǝi lǝmdǝ tǒ mala afufe tàrú mala nggun-almon, andǝ apwasǝia andǝ atǝ́r-fufe malea. ");
INSERT INTO mbu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Garè mǝnana a ɓaɓalǝu ka à ɓak rǝi lǝmdǝ pa mala afufe ine mala nggun-almon nǝ apwasǝia andǝ atǝ́r-fufe malea. ");
INSERT INTO mbu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Tǝ́r-fufe mwashat ka nda a koya ban-kpapí mala abui ɓari-ɓari banì tàrú arǝ garè. ");
INSERT INTO mbu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Yì gìr tamsǝ apitǝla andǝ nyoulǝa rǝi mala fufe andǝ apwasǝe andǝ atǝ́r-fufe ka, à pè kat nǝ gumtǝli bolo-njengǝlan mǝɓoarne mwashat mǝnana à walki ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","À pàk apitǝla male tongno-nong-ɓari, andǝ amǝmyal male, andǝ atasau-bǝsa male nǝ bolo-njengǝlan mǝɓoarne. ");
INSERT INTO mbu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","À pàktúró nǝ bolo-njengǝlan mǝɓoarne mǝnana dǝmbǝrya male ka tyang lumi-tàrú-bwamdǝ-tongno 35 na ka, sǝ à pàk yì gìr tamsǝ apitǝla andǝ agirtúró male kat. ");
INSERT INTO mbu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","À pàk gyangŋan mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne nǝ nggun akasiya. Tangŋa male andǝ sauwa male ka à kārǝa, komǝye ka ɓakusǝu mwashat nǝ gauwa-tsùrú, sǝ dāh'rya male ka ɓakusǝu tàrú na. Koya nkanggari ka à tsǝki wi njawe nǝ ulang kǝ nggun mǝnana à pè nǝi ka, à duk mwashat. ");
INSERT INTO mbu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","À gìr rǝi kat nǝ bolo-njengǝlan mǝɓoarne: múrí, andǝ ankanggari, andǝ anjawe. À ɓak bolo-njengǝlan kàrì kúni kat. ");
INSERT INTO mbu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","À tsǝki wi agbalmò bolo-njengǝlan ɓari arǝ ankanggari; à tsǝia à sulǝî ban kúní mana à ɓè ka bǝti, sǝ à came a nkāɓe rǝarǝia. Agbalmò ka à nda ace oasǝ agara mǝnana à nǝ̀ nggǝ twali nǝia ka. ");
INSERT INTO mbu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Agara twale ka à peǎ nǝ nggun-akasiya sǝ à tasǝ rǝia nǝ bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","À pàk mùrú mǝfele ace ɗārǝ́bân sǝ à kpapiki amuku-agir mǝɓoarne ace loasǝ yele mǝ'rǝmɓoarne; à pè kǝla mǝnana mǝ'sǝlǝ pakki agir pà rǝmban mǝɓoarne nǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Pǝlǝa Bezal-El pàk gyangŋan nǝ nggun-akasiya ace pàgir mala pisǝe kǝring; sauwa male ka ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú, tangŋa male ka, ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú, sǝ dāh'rya male ka, ɓakusǝu ine nǝ gauwa-tsùrú na. ");
INSERT INTO mbu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Pǝlǝa pàk anjawe male arǝ abankara ine amurí. Yì gyangŋan andǝ anjawe ka à shària nǝ nggun mǝmwashati, sǝ à gìr rǝi kat nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Sǝ pàk agirtúró male kat: ankwaring-bolo, andǝ ashebǝl, andǝ ankenye, andǝ ashokali-soagìr, andǝ atasau-bǝsa. Amǝnia yì agirtúró kat ka, à peǎ nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Pǝlǝa pakkî gyangŋan bàndà male nǝ waya bolo-bángŋá mǝnana à tè aɓalǝarǝia kǝla ndǝambu ka; à oasǝi aɓa gyangŋan, sulǝî kúni, yi came a ɓalǝu. ");
INSERT INTO mbu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tùl agbalmò ine arǝ abankara a kún bàndà bolo-bángŋá ace oasǝ agara twale. ");
INSERT INTO mbu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Pàk agare ɓari nǝ nggun-akasiya, sǝ tasǝ rǝia nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Sǝ oasǝ agara mǝno aɓalǝ atūli gbalmò arǝ ankanggari gyangŋan ace twale. Shàr gyangŋan mǝnia ka nǝ akpamgbang, nying ɓālǝi nong horondong. ");
INSERT INTO mbu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezal-El pàk nkenye nǝ bolo-bángŋá ace lákkí arǝu, sǝ girtàmsǝe ka à pè gbal nǝ bolo-bángŋá; pè nǝ atapwari-bolobangŋá mala amamǝna mana à kǝ pàktúró a kún Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Pǝlǝa kasǝ patal ace Taragula. A bumban male mǝnana sǝn njar-kunmur ka gyarki alagìr nggubyau-linǝn mana à teǎ pepè ka; sauwa malea ka, ɓakusǝu gbǝman-mwashat nǝ lumi-tongno na (150). ");
INSERT INTO mbu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Gyarkia arǝ anggun-kala lumi-ɓari aban camge aɓalǝ agumtǝli-tǝrteà lumi-ɓari, mana à peǎ kat nǝ bolo-bángŋá ka; sǝ anlǐ-gyargìr mala anggun-kala andǝ ankò malea ka, bolo-azǝrfa na à peǎ nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Sǝ ace bumban mǝnana sǝn njar-nza ka, à gyarki alagìr male mǝnana sauwa malea ka ɓakusǝu gbǝman-mwashat nǝ lumi-tongno na (150) ka. Anggun-kala lumi-ɓari andǝ agumtǝli-tǝrteà lumi-ɓari ka, à peǎ kat nǝ bolo-bángŋá; sǝ anlǐ-gyargìr mala anggun-kala andǝ ankò malea ka, bolo-azǝrfa na à peǎ nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sǝ ace bumban mǝnana sǝn njar-nzali ka, sauwa mala alagìr male ka ɓakusǝu lumi-tongno-nong-ɓari bwamdǝ tongno na (75). À gyarkia arǝ anggun-kala lum aban camge aɓalǝa agumtǝli-tǝrteà lum; anlǐ-gyargìr mala anggun-kala andǝ ankò malea ka, bolo-azǝrfa na à peǎ nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A bumban mǝnana sǝn eauwe mala pwari a njartakuli, a bankutio aɓa patal mala Taragula ka, sauwa mala lagìr male ka ɓakusǝu lumi-tongno-nong-ɓari bwamdǝ tongno na (75). ");
INSERT INTO mbu_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Koya buì mala bankutio a patal mala Taragula ka, ndanǝ lagìr male. Sauwa mala lagìr mǝnana a bu-mǝlì mala kun patal ka, ɓakusǝu lumi-ɓari-nong-ɓari nǝ gauwa-tsùrú na (22.5). À gyari arǝ anggun-kala tàrú aban came aɓalǝ agumtǝli-tǝrteà tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Anggo gbal sǝ pa a bu-mǝnggare. Sauwa mala lagìr male ka ɓakusǝu lumi-ɓari-nong-ɓari nǝ gauwa-tsùrú na (22.5). À gyari arǝ anggun-kala tàrú aban came aɓalǝ agumtǝli-tǝrteà tàrú. ");
INSERT INTO mbu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alagìr mǝnana kat à gumbǝli patal ka, à peǎ nǝ nggubyau linǝn mǝɓǝlke mǝnana à tè mǝsǝi kèkì ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Agumtǝli-tǝrtà anggun-kala ka à peǎ nǝ bolo-bángŋá; sǝ anlǐ-gyargìr mala anggun-kala andǝ ankò malea ka, à peǎ nǝ bolo-azǝrfa. Anggun-kala ka à tasǝ ɓongŋia nǝ bolo-azǝrfa. Anggun-kala mǝnana kat à kàrì patal ka, à pàkkia wia ankò mala bolo-azǝrfa. ");
INSERT INTO mbu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Lagìr mala gbar kunɓala ka, à pè nǝ nggubyau-linǝn mǝɓoarne mǝnana à nyoulǝ rǝi aɓa sǝlǝ tagìr mǝɓoarsǝne nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe ka. Sauwa male ka, ɓakusǝu lumi-tàrú na (30), sǝ dāh'rya male ka ɓakusǝu tongno-nong-ɓari nǝ gauwa-tsùrú na (7.5), kǝla mǝnana alagìr mala patal pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","À tsǝki wi anggun-kala male ine mǝnana à camgi aɓalǝ agumtǝli-tǝrteà mala bolo-bángŋá ine ka. Anlǐ-gyargìr malea ka, à peǎ nǝ bolo-azǝrfa. À tasǝ ɓongŋia sǝ à pàk ankò malea nǝ bolo-azǝrfa. ");
INSERT INTO mbu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ankpako mala Taragula andǝ mala anggun-kala mana à kàrì patal kat ka, à peǎ nǝ bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mǝnia ka nda tsaɗya mala agirtúró ace pàk Taragula, yì Taragula mala Acau-nakûn. Aburana a tàu mala Lawi na à gilǝ agir mǝnia aɓa malǝmce kǝla mǝnana Musa banggia wia ka. Itamar, muna-ɓwabura mala Haruna, Pǝris Mǝgule, nda ɓwamǝgule mǝgilǝgir amur acili amǝtúró mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezal-El muna-ɓwabura mala Uri, mǝkà Hur, a tàu mala Yahuda, nda ɓwa mǝnana pak agir kat pepè kǝla mǝnana Yahweh pè Musa nzongcau ama ɓǝà kpate ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Nda atārǝia andǝ ɓì mǝbwali wi túró, yi Oholiyap, muna-ɓwabura mala Ahisamak, a tàu mala Dan, mǝnana yi gbal ka mǝ'sǝlǝ pàkki atúróbù mala nyoulǝgir arǝ tali, andǝ pusǝ pa mala koya ulang gìr, andǝ tà gìr mǝɓoarsǝne arǝ nggubyau nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Bolo-njengǝlan mǝnana kat aɓwana yi pa kǝla ɓoro ace pàk Tara-mǝfele ka, dǝmbǝrya male ka tyang á-mwashat na (1,000). À kpata kārǝ́ dǝmbǝrya mala gìr, mǝnana à ear amurí a Tara-mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Bolo-azǝrfa mana à kum a bu ɓwabundǝa mǝnana à ɓallia ka, dǝmbǝrya male na tyang á-tārú, nǝ gbǝman ine nǝ lumi-tàrú (3,430). À kpata kārǝ́ dǝmbǝrya mala gìr, mǝnana à ear amurí a Tara-mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Mǝnia yi bolo-azǝrfa ka à kumi aɓa cemi aɓwana mana à gilǝ alullǝia a malǝmce aban ɓalban ngga. Koyan ngga pà gìr mǝnana à kasǝ ka, mǝtyang tongno nǝ gauwa-tsùrú; à kpata kārǝ́ dǝmbǝrya mala gìr, mǝnana à ear amurí a Tara-mǝfele ka. Làkkì mala aburana mana à ɓallia, amǝnana pǝlǝa ɓǝlban malea bingŋǝnà lumi-ɓari andǝ mana kútì ka, á-gbǝman-tongno-nong-mwashat-nǝ-tàrú nǝ gbǝman-tongno nǝ lumi-tongno na (603,550). ");
INSERT INTO mbu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","À pàktúró nǝ tyang lumi-tàrú nǝ mǝsǝi ine (34) mala bolo-azǝrfa sǝ à ɓakki agumtǝli-tǝrtà anggun-tara mala Tara-mǝfele andǝ anggun-ɓalǝu mana à bwal lagìr-kasǝbân aɓa Tara-mǝfele ka; làkkì mala agumtǝli-tǝrtà anggun-tara andǝ amala anggun-kala kat ka gbǝman mwashat na. ");
INSERT INTO mbu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Cili bolo-azǝrfa mǝnana ueo, tyang lumi-tàrú ka, à pàngŋǝ̀nà-túró nǝi ace pàk anlǐ-gyargìr ace anggun-ɓalǝu andǝ tasǝ múr anggun-ɓalǝu, andǝ pak ankò malea. ");
INSERT INTO mbu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bolo-bángŋá mǝnana aɓwana pànà ɓoro nǝi aban Ɓakuli ka dǝmbǝrya male ka tyang á-ɓari, nǝ gbǝman-ine nǝ lumi-ɓari bwamdǝ-tongno na 2,425. ");
INSERT INTO mbu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","À pàktúró nǝ mǝnia ka sǝ à pàk agumtǝli-tǝrtà anggun-kúnkurǝm mala bankutio aɓa Taragula, yì Tara Ban-peri, andǝ gyangŋan bolo-bángŋá, andǝ bàndà ace twangìr, andǝ agirtúró mala mǝnia yì gyangŋan ngga kat. ");
INSERT INTO mbu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ɗǝm ngga nǝ cili mǝno yì bolo-bángŋá ka sǝ à pàk agumtǝli-tǝrtà anggun-kala mǝnana à gumbǝli patal, andǝ agumtǝli-tǝrtà anggun kún patal, andǝ ankpako mala Taragula kat, andǝ ankpako mala anggun-kala mana à kàrì patal ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","À pàktúró nǝ ɗà'ndíng mǝlùre, mǝwanye andǝ mǝbangŋe sǝ à tà adaura amǝɓoarne mǝnana apǝris nǝ̀ nggǝ oasǝo arǝia ɓǝà nǝ̀ pàk túró pǝris aɓa Ban Mǝfele ka. Ɗǝm ngga à swàr adaura amǝfele ace Haruna, kǝla mǝnana Yahweh pè Musa nzongcau ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","À Pàk efot nǝ nkonggúr bolo-njengǝlan andǝ mala ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe mǝnana à tè aɓalǝarǝia andǝ nkonggúr linǝn mǝɓǝlke mana à pyauwì ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","À walki bolo-njengǝlan lapat-lapat, à kasǝki ganggǝrang-ganggǝrang, sǝ à tè aɓalǝarǝia andǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala linǝn mǝɓǝlke mǝnana à pyauwì ka, sǝ à tà efot nǝi, nǝ sǝlǝ tagìr. ");
INSERT INTO mbu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","À swàrî efot anggúr-nkpamtaru ɓari mǝnana à kpapi arǝ kúní a ɓadǝmbi andǝ nzǝmi ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","À tà bugìr mārǝ́ taɓunu nǝ nkonggúr mǝmwashati ulang mala efot aɓa sǝlǝ pak gìr mǝɓoarsǝne sǝ à swàrì arǝ efot; à tè nǝ ankonggúr mala bolo-njengǝlan andǝ mala ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala linǝn mǝɓǝlke mǝnana à pyauwì ka. À pè kǝla mǝnana Yahweh banggi Musa ama ɓǝà pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","À gilǝki amunatali-onis mǝno ɓari ka, sǝ à nyoulǝ alullǝ amuna-burana lum-nong-ɓari mala Isǝrayila amuria; à nyoulǝia kǝla mana à kǝ nyoulǝ gir a ɓamur gbalmo-parbù ka, sǝ à oasǝia aɓalǝ atǝkrǝk-waya mala bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","À tsǝia arǝ anggúr-nkpamtaru mala efot. À duk atali ɗenyinǝban mala amuna-burana mala Isǝrayila, kǝla mǝnana Yahweh banggi Musa ama ɓǝà pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","À pàk lǝpan-damɓalǝu aɓa sǝlǝpe mala tagìr. À tè kǝla pě mala efot, nǝ nkonggúr bolo-njengǝlan andǝ mala ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala linǝn mǝɓǝlke mǝnana à pyauwì ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","À pè sauwa male kārǝa andǝ tangŋa male, incì tongno-nong-ine, sǝ à kàrrì ɓari, kúní lǝpi amur ɓì. ");
INSERT INTO mbu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","À lanzǝì wi amuna tali-gǝna tàrú-tàrú arǝì a nzǝmarǝia arǝ asangbǝlang ine; a sangbǝlang mǝdǝmbe ka à lanzǝì wi atali-gǝna mala rubi, tofas, andǝ beril; ");
INSERT INTO mbu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","a ɓaria sangbǝlang ngga à lanzǝì wi atali-gǝna mala emeral, safir, andǝ daimon; ");
INSERT INTO mbu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","a tàruia sangbǝlang ngga à lanzǝì wi atali-gǝna mala jasinta, aget, andǝ amitis; ");
INSERT INTO mbu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","sǝ a inea sangbǝlang ngga à lanzǝì wi atali-gǝna mala kǝrisolat, onis, andǝ jaspa. Yia amuna tali-gǝna mǝno kat ka à oasǝkia aɓalǝ atǝkrǝk-waya mala bolo-njengǝlan. ");
INSERT INTO mbu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Amuna tali-gǝna mǝno ka à nda lum-nong-ɓari; komǝye ateà ka nda ace mwashat atà amuna-burana lum-nong-ɓari mala Isǝrayila, sǝ komǝye ateà ka à nyoulǝî wi mwashat atà alullǝ atau mala amǝ Isǝrayila amurí; à nda kǝla aɓamur gbalmo-parbù. ");
INSERT INTO mbu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sǝ à pàk amuna-nsolo ɓamyalu nǝ bolo-njengǝlan mǝɓoarne; à ɓolǝia aɓalǝarǝia, à pa kǝla nggur. ");
INSERT INTO mbu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","À pàk atǝkrǝk-waya mala bolo-njengǝlan ɓari sǝ à pàk agbalmò bolo-njengǝlan ɓari, sǝ à oasǝkia agbalmò mǝnia ka arǝ lǝpan-damɓalǝu a ban akúní ɓari. ");
INSERT INTO mbu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Amuna-nsolo bolo-njengǝlan mǝno ɓari à ɓolǝia ka à ɗúrkia arǝ agbalmò mana arǝ akún lǝpan-damɓalǝu ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Akún amuna-nsolo ɓari mana à ue ka à ɗúrkia arǝ atǝkrǝk-waya mǝno ɓari ka, sǝ à kpapia arǝ anggúr-nkpamtaru mala efot, a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","À pàk agbalmò bolo-njengǝlan ɓari sǝ à oasǝia arǝ lǝpan-damɓalǝu aban akúni ɓari mana à pǝlǝ nǝɓalǝu, tù aban efot ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Pǝlǝa à pàk aɓea gbalmò bolo-njengǝlan ɓari ɗǝm, sǝ à kpapia a kún anggúr-nkpamtaru mana à pǝlǝ nǝ'nzali ka a ɓadǝm efot, tù amur bugìr mārǝ́ taɓunu mǝ'nbaké mala efot. ");
INSERT INTO mbu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Pǝlǝa à kùrki agbalmò mala lǝpan-damɓalǝu arǝ agbalmò mala efot, nǝ nkonggúr mǝlùre, ace mǝnana lǝpan-damɓalǝu ka ɓǝ̀ nongŋo amur bugìr mārǝ́ taɓunu mǝ'nbaké, sǝ ɓǝ̀ bwal kàngkàng arǝ efot, kǝla mǝnana Yahweh tsǝki Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ɗǝm ngga à tà daura-tsuru mǝsauwe mala efot; à tè kat nǝ ɗà'ndíng mǝlùre. ");
INSERT INTO mbu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","À nying ban fonggǝrang a myali, kǝla mala nggea-daura, ace oasǝ ɓamuru, sǝ à tà myali nǝ nkonggúr mǝcandǝe gumbǝli kat, ace mǝnana ɓǝ̀ kǝa sàn raka. ");
INSERT INTO mbu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","À kàrì kún daure a nzali nǝ agir kǝla aɓǝla mɓǝring mǝnana à teǎ nǝ nkonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, andǝ mala linǝn mǝɓǝlke mana à pyauwì ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ɗǝm ngga à pàk amuna gwaroji bolo-njengǝlan sǝ à gyarkia à camgi a nre ka ɓǝla mɓǝring à kàrì kún daure kat. ");
INSERT INTO mbu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Aɓǝla mɓǝring andǝ amuna gwaroji gaɓi-ɓalǝarǝia camge à kàrì kún daure mǝnana Haruna nǝ̀ oasǝo arǝì ɓǝ̀ nǝ̀ pàk túró pǝris ka, kǝla mǝnana Yahweh banggi Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ɗǝm ngga à swàrî a Haruna andǝ amuna-burana male adaura túró-pǝris mǝnana à teǎ nǝ nkonggúr linǝn mǝɓoarne ka, ");
INSERT INTO mbu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","sǝ à pak anggubyau mbuɓi múrû mala linǝn mǝɓǝlke, andǝ asukuru linǝn, andǝ ashiwan mala nggubyau linǝn mǝnana à tè mǝsǝì kèkì ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bugìr mārǝ́ taɓunu ka, à tè nǝ nkonggúr linǝn mǝɓǝlke mǝnana à pyauwì ka, andǝ ankonggúr ɗà'ndíng mǝlùre, mǝwanye, andǝ mǝbangŋe, nǝ tagìr mǝɓoarsǝne, kǝla mǝnana Yahweh banggi Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","À walki bolo-njengǝlan mǝɓoarne pàk lapat ace mǝnana ɓǝ̀ duk muna baji mǝfele ka, sǝ à nyoulǝ cau amurí kǝla mǝnana à nǝ̀ nyoulǝ gir a ɓamur gbalmo-parbù ka ama, <<Mǝfele ace Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","À kùrrì nǝ nkonggúr mǝlùre arǝ nggubyau mbuɓi múrû mala Haruna nǝban ɓadǝmbi, kǝla mǝnana Yahweh banggi Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Anggo sǝ túró mala loasǝ Taragula, yì Tara Ban-peri ka à yi masǝlǝi kat. Amǝ Isǝrayila pàk girbunda kat kǝla mǝnana Yahweh banggi Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","À yinǝ Taragula aban Musa: yì agir mala loasǝ Tara andǝ agirtúró ɓālǝi; anlǐ-gyargìr male, andǝ anggun-tara male, andǝ nggun-gangndea male; andǝ anggun-ɓalǝu male andǝ agumtǝli-tǝrteà; ");
INSERT INTO mbu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","andǝ anggú-bángŋá amǝtangge, andǝ nggú mǝɓǝlke mala ambulpǝndǝa, andǝ lagìr-kasǝbân, ");
INSERT INTO mbu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","andǝ Akwati mala Acau-nakûn andǝ agara twale, andǝ gìrkúni mǝnana nda buno sǝntǝ̀r ka; ");
INSERT INTO mbu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","andǝ kpamgbang-tsǝk-agir, andǝ agir mǝnana kat amurí ka, andǝ bǝredi mala ɓadǝm Yahweh; ");
INSERT INTO mbu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","andǝ gìr tamsǝ apitǝla mǝnana à pè nǝ bolo-njengǝlan mǝɓoarne ka, andǝ apitǝla male mǝnana à tsǝkinia aɓalǝ abancame malea amurí ka; andǝ agirtúró kat mala apitǝla andǝ mùrú olif ace tsǝk bǝsa malea; ");
INSERT INTO mbu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","andǝ gyangŋan mǝnana à gìr rǝi kat nǝ bolo-njengǝlan ngga; andǝ mùrú-ɗārǝ́bân, andǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne; andǝ lagìr gyare a kún bankutio aɓa Tara; ");
INSERT INTO mbu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","andǝ gyangŋan bolo-bángŋá, andǝ bàndà male mala waya bolo-bángŋá, andǝ agara twale, andǝ agirtúró male kat; andǝ nkenye lákkí arǝu andǝ girtàmsǝe; ");
INSERT INTO mbu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","andǝ alagìr ace gumbǝli patal, andǝ anggun-kala male, andǝ agumtǝli-tǝrteà; andǝ lagìr-gbarban kún patal; andǝ anggur andǝ ankpako male; andǝ agir mǝnana kat à nǝ̀ pàktúró nǝia aɓa Taragula, yì Tara Ban-peri ka; ");
INSERT INTO mbu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","andǝ adaura amǝɓoarne mǝnana apǝris nǝ̀ nggǝ oasǝo arǝia ɓǝ̀ à nǝ̀ pàk túró-pǝris aɓa Ban Mǝfele ka, sǝ adaura mǝfele ace Haruna pǝris mǝgule, andǝ adaura mala amuna-burana male, mǝnana à nǝ̀ oasǝ arǝia ɓǝ̀ à nǝ̀ pàk túró-pǝris ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Amǝ Isǝrayila pàk atúrè kat aɓa kpata agir kat kǝla mǝnana Yahweh ak dǝmba bangŋǝni Musa ama ɓǝ̀ pè ka. ");
INSERT INTO mbu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa pelǝki atúrè pepè sǝ sǝni ka, à pàngŋǝ̀nì kǝla mǝnana Yahweh bang ama ɓǝà pè ka; à pè gǝ̀rgǝ̀r, sǝ Musa tsǝkia wia bù. ");
INSERT INTO mbu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Pǝlǝa Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","<<A pwari mǝdǝmbe mala zongŋo mǝdǝmbe ka, awu nǝ loasǝ Taragula, yì Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Awu nǝ twal Akwati mala Acau-nakûn, awu nǝ̀ tsǝì aɓa Taragula, sǝ awu nǝ gyar lagìr-kasǝbân a ɓadǝmbi ɓǝ̀ gbàrì aɓa Ban Nggea Mǝfele. ");
INSERT INTO mbu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Awu nǝ yinǝ kpamgbang-tsǝk-agir, awu nǝ tamsǝi, sǝ awu nǝ tsǝki agir male amurí. Awu nǝ yinǝ gìr-tàmsǝ apitǝla wu yi tsǝì, sǝ wu tsǝki wi apitǝla male amurí. ");
INSERT INTO mbu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Sǝ awu nǝ tsǝk gyangŋan bolo-njengǝlan ace loasǝ yele mǝ'rǝmɓoarne, ɓǝ̀ came a ɓadǝm Akwati mala Acau-nakûn, sǝ wu gyar lagìr mala gbàr bankutio aɓa Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","<<Awu nǝ tsǝk gyangŋan mala pàgir mala pisǝe kǝring ɓǝ̀ came a nza, a kún Taragula, yì Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Sǝ awu nǝ tsǝk nkenye lákkí arǝu a nre Tara Ban-peri andǝ gyangŋan mǝnia ka, sǝ wu lúmsǝì nǝ mùr. ");
INSERT INTO mbu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Awu nǝ kasǝ patal, ɓǝ̀ kàrì Taragula. Gumbǝli nǝ alagìr sǝ wu gyar lagìr mǝnana nǝ̀ gbàr kún patal ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","<<Pǝlǝa awu nǝ twal mùrú ɗārǝ́bân sǝ awu nǝ ɗārǝ́ Taragula andǝ agir mǝnana aɓalǝi ka kat, sǝ awu nǝ tàrì andǝ agirtúró-ɓalǝi ace Ɓakuli, ace mǝnana ɓǝ̀ duk mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sǝ ɗǝm ngga awu nǝ ɗārǝ́ gyangŋan mala pàgir ace pisǝe kǝring, atārǝia andǝ agirtúró male kat, nǝ mùrú olif. Yì gyangŋan ngga awu nǝ tàrì ace Ɓakuli sǝ nǝ̀ duk gyangŋan nggea mǝfele kat-kat. ");
INSERT INTO mbu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ɗǝm ngga awu nǝ ɗārǝ́ nkenye lákkí arǝu andǝ girtàmsǝe, nǝ mùrú olif, sǝ awu nǝ tàrì ace Ɓakuli. ");
INSERT INTO mbu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","<<Pǝlǝa awu nǝ yinǝ Haruna andǝ amuna-burana male a kún Tara Ban-peri, awu nǝ lákkià wia rǝia nǝ mùr. ");
INSERT INTO mbu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Awu nǝ oasǝì Haruna adaura mǝfele mala pǝris arǝì, sǝ awu nǝ ɗārǝí nǝ mùrú olif; awu nǝ tàrì ɓǝ̀ duk mǝ'pàkkam túró kǝla pǝris. ");
INSERT INTO mbu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ɗǝm ngga, awu nǝ yinǝ amuna-burana male, awu nǝ oasǝkia wia adaura-múrɓì arǝia, ");
INSERT INTO mbu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","sǝ awu nǝ ɗārǝia nǝ mùrú olif, kǝla mǝnana à ɗārǝ́ tárrià ka, ace mǝnana ɓǝà pàkkam túró kǝla apǝris ka. Sǝ ɗārǝ́bân malea ka nǝ̀ yinǝia a dobuno-pǝris mana tè pà nǝ̀ mal raka, arǝ anza malea kat.>> ");
INSERT INTO mbu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa pàk koman kat kǝla mǝnana Yahweh banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Taragula ka à tǝmi a pwari mǝdǝmbe mala zongŋo mǝdǝmbe a ɓaria pǝlǝa anzǝm mǝnana amǝ Isǝrayila nyingŋǝna Masar ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Lang Musa nǝ̀ loasǝ Taragula ka, tsǝki agumtǝli-tǝrtè a nzali sǝ tamsǝki akusǝ anggun-tara aɓalǝia, sǝ nongsǝki anggun-gangndea sǝ kùrkia. Anzǝm mǝno ka pǝlǝa loasǝ anggun-ɓalǝu mana à nǝ̀ mbali múr Taragula ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Pǝlǝa sárǝ́ lagìr nggu-bangŋa mǝtangŋe male, kùmsǝ múr anggun-tara yi sulǝ a nzali arǝ abumban mala Taragula, sǝ kùmsǝi wi lagìr-murí mǝgule mala nggu ambulpǝndǝa amurí nǝ'nza. Pàk koman kat kǝla mana Yahweh tsǝki wi nzongcau ama ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Twal akpamgbǝlang tali ɓari mala Acau-nakûn, tsǝia aɓa Akwati, sǝ twal agara mǝnana à kǝ twalǝna yì Akwati nǝia ka, oasǝki aɓalǝ atūli gbalmò arǝ Akwati, sǝ twal gìrkún Akwati, mǝnana do nda buno sǝntǝ̀r ka, tsǝì amur Akwatinî. ");
INSERT INTO mbu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Pǝlǝa twal Akwatinî kútí nǝi aɓa Taragula, pǝlǝa gyar lagìr-kasǝbân mǝnana nǝ̀ gau ɓá Taragula ka, gbàr Akwati mala Acau-nakûn, kǝla mana Yahweh tsǝki wi, yì Musa ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa tsǝk kpamgbang-tsǝk-agir aɓa Tara Ban-peri, aɓalǝi mǝdǝmbe, a ɓadǝm lagìr-kasǝbân, nǝ bumban mala Taragula mǝnana sǝn njar-nza ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Pǝlǝa tsǝk bǝredi amur kpamgbang-tsǝk-agir a ɓadǝm Yahweh, kǝla mana Yahweh banggi wi, yì Musa ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Pǝlǝa tsǝk gìr tamsǝ apitǝla aɓa Tara Ban-peri, a nkāɓe kpamgbang-tsǝk-agir, nǝ buì mala Taragula mǝnana sǝn njar-kunmur ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Pǝlǝa tamsǝki apitǝla a ɓadǝm Yahweh, kǝla mana Yahweh tsǝki wi nzongcau, yì Musa ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa pǝlǝa tsǝk gyangŋan bolo-njengǝlan aɓa Tara Ban-peri, a ɓadǝm lagìr-kasǝbân, ");
INSERT INTO mbu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","sǝ pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne amúr gyangŋan, kǝla mana Yahweh tsǝki wi nzongcau ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sǝ yi gyar lagìr-gbarban a kún ban mǝnana à nǝ̀ kùtí nǝi aɓa Taragula ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A ɓadǝm mǝno yì lagìr-gbarban a kún Taragula, yì Tara Ban-peri ka, Musa tsǝk gyangŋan mala pàgir ace pisǝe kǝring, sǝ pagìr mala pisǝe kǝring amurí, andǝ pa ɓoro mala mǝsǝsa, kǝla mǝnana Yahweh tsǝki wi nzongcau ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Musa tamsǝ nkenye a nre Tara Ban-peri andǝ gyangŋan mǝno, sǝ so mùr aɓalǝi ace lákkí arǝu, ");
INSERT INTO mbu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","A kàm sǝ Musa andǝ Haruna, andǝ amuna-burana mala Haruna à nǝ̀ nggǝ lákkí abuia andǝ akusǝia. ");
INSERT INTO mbu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Koya pwari sǝ à nǝ̀ kùtí aɓa Tara Ban-peri, ko à nǝ̀ ká a ban gyangŋan ngga, à nǝ̀ lakki abuia andǝ akusǝia sǝ à nǝ̀ kùtí a banì, kǝla mǝnana Yahweh tsǝki Musa nzongcau ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Pǝlǝa Musa kasǝ patal ɓǝ̀ kàrì Taragula, tsǝk nkāndan ɓǝ̀ gumbǝliban, túr Taragula andǝ gyangŋan a ɓalǝu. Pǝlǝa gyarki alagìr-gbarban ace kàrì rǝ nkāndan kat, sǝ ace gbar kún patal. Anggo sǝ Musa mal túró. ");
INSERT INTO mbu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kara pǝrɓang yì gir múr Tara Ban-peri, sǝ ɓoarɓwa mala Yahweh yì lumsǝ ɓá Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa ka gandǝ kúti aɓa Tara Ban-peri ɗang, acemǝnana pǝrɓang yi sulǝna amurí, sǝ ɓoarɓwa mala Yahweh lùmsǝ ɓá Taragula. ");
INSERT INTO mbu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Aɓa gya mala amǝ Isǝrayila kat ka, koya pwari sǝ pǝrɓang loapì múr Taragula ka, à nǝ̀ lo gya aban ká atè. ");
INSERT INTO mbu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Sǝ ɓǝ̀ pǝrɓang lo raka, yià gbal ka à pà nǝ̀ lo ɗang, she pwari mana pǝrɓang longŋǝna ka. ");
INSERT INTO mbu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Nǝ́ pwari ka pǝrɓang mala Yahweh nǝ̀ gìr múr Taragula, sǝ nǝ dú ka, bǝsa nǝ̀ pa aɓa pǝrɓangnî, a mǝsǝ amǝ Isǝrayila kat. Anggo sǝ pa arǝ abân mǝnana kat amǝ Isǝrayila kǝ tùrki kam a gya malea ka.");
INSERT INTO mbu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yahweh tunǝ Musa, sǝ nacau nǝi nǝ ɓá Tara Ban-peri, ama, ");
INSERT INTO mbu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","<<Nacau nǝ amǝ Isǝrayila, sǝ wu banggia wia ama: Pwari mana koyan atà wun nǝ̀ yinǝ girkusǝu ace pagìr abanam Yahweh ka, ɓǝ̀ ɓwe twal atà andá ko anzur ko ambul mala domwan male, sǝ ɓǝ̀ yinǝi kǝla pàgir male. ");
INSERT INTO mbu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","<<Ɓǝ̀ pàgir mala ɓwa ka, ndǎ na twal a domwan nǝ̀ pǎ, ace pàgir mala pisǝe kǝring ngga, ɓǝ̀ yinǝ jamnda mǝnana kǝgìr mǝɓane pà kàm arǝì raka. Ɓǝ̀ yinǝi a bankutio aɓa Tara Ban-peri, ace mǝnana ɓǝ̀ duk gir'a a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yì ka nǝ̀ tsǝk bui a ɓamur jamnda mana yinǝi nǝ̀ pa ace pàgir mala pisǝe kǝring ngga, sǝ à nǝ̀ é a kúnì, ace shawuɗǝe. ");
INSERT INTO mbu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Pǝlǝa yì ka nǝ̀ pwan-myal jamnda mǝno ka a ɓadǝm Yahweh, sǝ amuna-burana mala Haruna, yia apǝris ka, à nǝ̀ yinǝ nkile sǝ à nǝ̀ tàkki arǝ abumban mala gyangŋan mǝnana a bankutio aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Pǝlǝa nǝ̀ ɓwā jamnda mǝno, mala pàgir ace pisǝe kǝring ngga, sǝ nǝ̀ sàngi, ");
INSERT INTO mbu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","sǝ amuna-burana mala Haruna, yià apǝris ka, à nǝ̀ ram gimsa amur gyangŋan, à nǝ̀ tsǝk bǝsa ɓǝ̀ tita earke. ");
INSERT INTO mbu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Pǝlǝa amuna-burana mala Haruna, yià apǝris ka à nǝ̀ nongsǝki nyama mana à kasǝki ka, andǝ ɓamúrí, andǝ mùruí, amur gimsa mǝnana a bǝsa amur gyangŋan ngga; ");
INSERT INTO mbu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","sǝ agir-bumi andǝ akusǝi ka, ɓwê nǝ̀ lea nǝ mùr. Sǝ pǝris nǝ̀ pisǝia puppup a bǝsa amur gyangŋan, ɓǝ̀ duk pàgir mala pisǝe kǝring; pàgir nǝ bǝsa na, mala pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","<<Ɓǝ̀ pàgir mala ɓwa ka, nzur ko mbul na twal a domwan nǝ̀ pǎ, kǝla pàgir ace pisǝe kǝring ngga, ɓǝ̀ yinǝ gam ko gbato mǝnana kǝgìr mǝɓane pà kàm arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ɓǝ̀ ɓwê pwan-myali a bù gyangŋan mǝnana sǝn njar-nza ka, a ɓadǝm Yahweh. Sǝ amuna-burana mala Haruna, yià apǝris ka, à nǝ̀ tàkki nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","Ɓwê nǝ̀ sàngi nyami, sǝ agir-bumi andǝ akusǝi ka, nǝ̀ lea nǝ mùr, sǝ nǝ̀ kpapia andǝ ɓamúrí, andǝ mùruí. Sǝ pǝris nǝ̀ nongsǝki abare nyama man amur gimsa mana kǝ earki nǝ bǝsa amur gyangŋan ngga; nǝ̀ pà gir'nkila nǝia puppup, sǝ nǝ̀ pisǝia amur gyangŋan; pàgir mala pisǝe kǝring na; pàgir nǝ bǝsa na abanam Yahweh ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","<<Ɓǝ̀ pàgir mala ɓwa abanam Yahweh ka, anyal na ace pàgir mala pisǝia kǝring ngga, ɓǝ̀ yinǝ pàgir aɓalǝ akutumurǝm ko akutugangyi. ");
INSERT INTO mbu_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Sǝ pǝris ka nǝ̀ kánǝi amur gyangŋan, nǝ̀ pūrǝ myali ɓǝ̀ kasǝ kpat, nǝ̀ ɗārǝ́ nkile arǝ bum gyangŋan, sǝ nǝ̀ pisǝ ɓamúrí a bǝsa amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Nǝ̀ pusǝ bumi sǝ nǝ̀ sukki agir mana aɓalǝi ka a nkanggari gyangŋan, a bù gyangŋan mana sǝn njar-takuli ka, a ban mǝnana à kǝ̀ so tú kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pǝlǝa nǝ̀ sàn nyalnì, nǝ̀ mǝni a ban ankpamtari, sǝama pà nǝ̀ gau rǝì kat ɗàng. Sǝ pǝris nǝ̀ pisǝì amur gyangŋan, amur gimsa mǝnana kǝ earki nǝ bǝsa ka. Pàgir mala pisǝe kǝring na; pàgir nǝ bǝsa na abanam Yahweh ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","<<Lang koyan nǝ̀ yinǝ pàgir mala mǝsǝsa ace pàgir abanam Yahweh ka, pàgir male ɓǝ̀ duk muku mǝɓǝlke. Ɓǝ̀ soapi wi mùrú olif, sǝ ɓǝ̀ tsǝk myang-kwarra amurí, ");
INSERT INTO mbu_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","sǝ ɓǝ̀ yinǝi aban amuna-burana mala Haruna, yià apǝris. Pǝris nǝ̀ ɗàrǝ́ muku mǝɓǝlke mǝno andǝ mùrú olif mana à soapi wi ka ɓǝ̀ lùmsǝ ɓabui, sǝ ɓǝ̀ twal myang-kwarra mǝno à yinǝi ka kat, pǝlǝa ɓǝ̀ soea a bǝsa ɓǝà pi amur gyangŋan. Mǝnia ka nda kāmbe mala kasǝɓalǝu; pàgir nǝ bǝsa na, mala pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Cili pàgir mala mǝsǝsa mǝnia ueo à pisǝì raka, nǝ̀ duk mala Haruna andǝ amuna-burana male; mǝno ka nda kāmbe nggea mǝfele mala pàgir mala girlina abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","<<Lang awu nǝ yinǝ pàgir mala mǝsǝsa mǝnana à lurǝi aɓa ovù, ace pàgir ka, she ɓǝ̀ duk agbatali kyak mǝnana à pè nǝ muku mǝsǝsa mǝɓǝlke mana à zurǝì andǝ mùrú olif ka, sǝama à pà nǝ̀ tsǝki wi yis arǝì ɗàng, ko ɓǝ̀ duk biskit mana à pè nǝ yis arǝì raka, sǝ à hasǝki wi mùrú olif arǝì ka. ");
INSERT INTO mbu_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","<<Ɓǝ̀ pàgir mala mǝsǝsa mò ka gìr na à kàngŋì aɓa nkenye kàng gìr ka, she à nǝ̀ pè nǝ muku mǝsǝsa mǝɓǝlke mana à zurǝì andǝ mùrú olif ka, sǝama à pà nǝ̀ tsǝki wi yis ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Awu nǝ ɓwangi bǝti-bǝti, sǝ awu nǝ watsǝki wi mùrú olif arǝì. Mǝno ka nda pàgir mò mala mǝsǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","<<Ɓǝ̀ pàgir mò ka pàgir mala mǝsǝsa na à lambi aɓa tasau ka, she à nǝ̀ pè nǝ muku mǝsǝsa mǝɓǝlke mana à zurǝì andǝ mùrú olif ka. ");
INSERT INTO mbu_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Sǝ awu nǝ yinǝ pàgir mala mǝsǝsa mò abanam Yahweh, sǝ ɓǝ̀ mǝye na à pè kǝla amǝno à bǝlɓalǝia ka; awu nǝ pè pǝris, sǝ yì ka nǝ̀ kánǝi amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Pǝris nǝ̀ twal kāmbe mala kasǝɓalǝu aɓa pàgir nǝ mǝsǝsa man, sǝ nǝ̀ pisǝì amur gyangŋan; pàgir nǝ bǝsa na ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Cili pàgir mala mǝsǝsa mǝnia ueo à pisǝì raka, dumǝna mala Haruna andǝ amuna-burana male; pàgir nggea mǝfele na acemǝnana à twali aɓalǝ apagir mala girlina mana à pà abanam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","<<Koya pàgir mala mǝsǝsa mǝnana wun nǝ̀ yinǝi abanam Yahweh ka, à pà nǝ̀ pè nǝ yis arǝì ɗàng; acemǝnana pà wun nǝ̀ pisǝ kǝ yis, ko mùr-nyì a bǝsa, kǝla pàgir nǝ bǝsa abanam Yahweh ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Aɓǝlagir-mǝdǝmbe ma'wun ngga, wun nǝ̀ gandǝ yinǝia abanam Yahweh, sǝama à pà nǝ̀ pà ɓoro nǝia amur gyangŋan ace pà rǝmban mǝɓoarne mala pwasǝbum ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Koya pàgir mala mǝsǝsa ka, awu nǝ̀ kúnǝkì wi tuɓamur amurí. A pà nǝ eare ɓǝ̀ tuɓamur mala kùrcau wunǝ Ɓakuli ma'wun ɓǝ̀ ɗwanyi pa aɓa pàgir mala mǝsǝsa ɗàng; apagir mô kat ka awu nǝ pa nǝ tuɓamur arǝia. ");
INSERT INTO mbu_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","<<Ɓǝ̀ awu nǝ pàgir mala mǝsǝsa mala aɓǝlagir-mǝdǝmbe, abanam Yahweh ka, awu nǝ pà mana múr mǝsse ka, à loa cane sǝ à nyé ka. Múr mǝsse ka awu nǝ dandǝi amur bǝsa ɓǝ̀ wùlì, sǝ awu nǝ hārǝí. ");
INSERT INTO mbu_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Awu nǝ tsǝki wi mùrú olif arǝì, sǝ awu nǝ soapi wi myang-kwarra amurí. Mǝno ka nda pàgir mala mǝsǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Pǝris nǝ̀ ɗàrǝ́ aɓa mǝsǝsa mǝno mana à hārǝí sǝ à zurǝì andǝ mùrú olif ka, sǝ nǝ̀ kpapi andǝ myang-kwarra mǝno kat, sǝ nǝ̀ pisǝia, ɓǝ̀ duk kāmbe mala kasǝɓalǝu. Mǝno ka pàgir nǝ bǝsa na abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","<<Ɓǝ̀ pàgir mala ɓwa ka girkusǝu na nǝ̀ twal a domwan male ace pàgir mala dotarǝu ka, ɓǝ̀ ɓwe pà jamne ko mǝ'nggaule, mǝnana ɓè kǝgìr mǝɓane pà kàm arǝì raka, a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ɓwe nǝ̀ nongsǝ bui a ɓamúr girkusǝu mǝnana nǝ̀ pànà ɓoro nǝi ka, sǝ nǝ̀ pwan-myali a bankutio aɓa Tara Ban-peri; sǝ amuna-burana mala Haruna, yià apǝris ka, à nǝ̀ tàkki nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Aɓa pà gìr'nkila mala dotarǝu mǝnana yì ka nǝ̀ pa, ɓǝ̀ duk pàgir nǝ bǝsa abanam Yahweh ka, ɓwe nǝ̀ pà mùrú-nyama mǝnana kat gìr múr agir-bum, andǝ mana lanzǝ arǝ agir-bum ngga, ");
INSERT INTO mbu_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","andǝ amuna-gbè ɓari andǝ mùrú-nyama mana lanzǝ arǝia, tù a ban ɓunì ka, andǝ ban mǝɓoarne mala nkundingŋi mǝnana à pusǝì atārǝia andǝ amuna-gbè ka. ");
INSERT INTO mbu_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Amuna-burana mala Haruna nǝ̀ pisǝ abare nyama mǝnia ka amur gyangŋan, atārǝia andǝ acili abare girkusǝu mana à nda amur nggun a bǝsa ka. Mǝnia ka pàgir nǝ bǝsa na abanam Yahweh ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","<<Ɓǝ̀ pàgir mala ɓwa ka girkusǝu na twal a domwan male, jamne ko mǝ'nggaule, ɓǝ̀ duk pàgir mala dotarǝu abanam Yahweh ka, ɓǝ̀ ɓwe pà mǝnana ɓè kǝgìr mǝɓane pà kàm arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ɓǝ̀ nzur nda pàgir mala ɓwa ka, dumǝna púp nǝ̀ yinǝi aɓadǝmbam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Yì ka nǝ̀ tsǝk buì a ɓamúr girkusǝu male, sǝ nǝ̀ pwan-myali a bankutio aɓa Tara Ban-peri, sǝ amuna-burana mala Haruna ka, à nǝ̀ tàkki nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Pǝlǝa aɓa gìr'nkila mala pàgir ace dotarǝu ka, nǝ̀ yinǝ pàgir nǝ bǝsa abanam Yahweh nǝ pa mùruí, andǝ mùrú-nyama kat mala nggilate, mana à kasǝì tù a ban mù'nzǝmi ka, andǝ mùrú-nyama mana nong amúr agir-bumi, andǝ mùrú-nyama mana lanzǝ arǝ agir-bumi ka, ");
INSERT INTO mbu_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","andǝ amuna-gbè ɓari andǝ mùrú-nyama mana lanzǝ arǝia, tù a ban ɓunì ka, andǝ ban mǝɓoarne mala nkundingŋi mǝnana nǝ̀ pusǝì atārǝia andǝ amuna-gbè ka. ");
INSERT INTO mbu_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sǝ pǝris nǝ̀ pisǝi a bǝsa, amur gyangŋan ɓǝ̀ duk pàgir nǝ bǝsa na abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","<<Ɓǝ̀ pàgir mala ɓwa ka mbul na ka, dumǝna púp nǝ̀ yinǝi aɓadǝm Yahweh, ");
INSERT INTO mbu_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","sǝ nǝ̀ tsǝk buì a ɓamúr mbulnî, sǝ nǝ̀ pwan-myali a ɓadǝm Tara Ban-peri, sǝ amuna-burana mala Haruna ka, à nǝ̀ tàkki nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Pǝlǝa aɓa paɓoro mǝnia ka nǝ̀ yinǝ pàgir male mala pàgir nǝ bǝsa abanam Yahweh nǝ pa mùrú-nyama mana kat nong amúr agir-bumi, andǝ mana lanzǝ arǝ agir-bumi ka, ");
INSERT INTO mbu_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","andǝ amuna-gbè ɓari andǝ mùrú-nyama mana lanzǝ arǝia, tù a ban ɓunì ka, andǝ ban mǝɓoarne mala nkundingŋi mǝnana nǝ̀ pusǝì atārǝia andǝ amuna-gbè ka. ");
INSERT INTO mbu_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sǝ pǝris nǝ̀ pisǝia a bǝsa amur gyangŋan, ɓǝ̀ duk pàgir mala girlina ace pà rǝmban mǝɓoarne mana kǝ pwasǝbumam ngga. Mùrú-nyama kat ka mem Yahweh na. ");
INSERT INTO mbu_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Acemani ka, wun wunǝ amuna ma'wun, andǝ amǝ'kà wun ngga, pà wun nǝ̀ lì kǝ mùrú-nyama ko nkila ɗàng, arǝ abando ma'wun kat. Mǝnia ka nǝ̀ dupa wun nggurcau mana nggaɗe pà kàm raka arǝ anza ma'wun kat tàtǝ́k.>> ");
INSERT INTO mbu_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Nacau nǝ amǝ Isǝrayila, sǝ wu banggia wia ama: Mǝnia ka nda gìr mǝnana à nǝ̀ pàk ka ɓǝ̀ ɓwa pàk cauɓikea aɓa ɓwarkio, mala yàllî mwashat atà anzongcau mala Yahweh mǝnana à pà amur agir mǝnana à pǝrban arǝia, sǝ kya pàk mwashat ateà ka. ");
INSERT INTO mbu_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ɓǝ̀ Pǝris Mǝgule na pàk cauɓikea ka, cauɓikea male nǝ̀ mesǝ amur koyan ngga. Acemani ka, dumǝna púp ama yì ka nǝ̀ pàgir ace cauɓikea mǝnana pàk ka; nǝ̀ twal jamnda mǝnana ɓekǝ gìr mǝɓane pà kàm arǝì raka, a domwan, sǝ nǝ̀ pa abanam Yahweh, ɓǝ̀ duk pàgir ace lak cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Nǝ̀ yinǝ jamnda mǝnia ka a bankutio aɓa Tara Ban-peri, a ɓadǝm Yahweh, sǝ nǝ̀ nongsǝ bui a ɓamúr jamnda, sǝ nǝ̀ pwan-myali a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sǝ yì Pǝris Mǝgule ka, nǝ̀ ɗàrǝ́ aɓa nkila mala jamnda, nǝ̀ kùtí nǝi aɓa Tara Ban-peri, ");
INSERT INTO mbu_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","nǝ̀ oasǝ munabuì aɓa nkila sǝ nǝ̀ watsǝki kusǝ tongno-nong-ɓari, a ɓadǝm Yahweh, a kusǝ lagìr-kasǝbân mala Ban-mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sǝ yì pǝris ka nǝ̀ ɗàrǝ́ aɓa nkila, nǝ̀ hasǝki arǝ anjawe gyangŋan mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne a ɓadǝm Yahweh, mǝnana nda aɓa Tara Ban-peri ka. Cili nkila jamnda mǝnana ue ka, dumǝna púp nǝ̀ solǝi kat a kusǝ gyangŋan mala pagìr mala pisǝe kǝring, mǝnana nda a bankutio aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Sǝ mùrú-nyam jamnda mala pàgir ace cauɓikea ka nǝ̀ pusǝki kat; yì mùrú-nyama mana nong amúr agir-bum, andǝ mùrú-nyama mana kat lanzǝ arǝ agir-bum jamnda, ");
INSERT INTO mbu_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","andǝ amuna-gbè ɓari andǝ mùrú-nyama mana lanzǝ arǝia, tù a ban ɓunì ka, andǝ ban mǝɓoarne mala nkundingŋi mǝnana à nǝ̀ pusǝì atārǝia andǝ amuna-gbè ka, ");
INSERT INTO mbu_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(kǝla mana à pusǝki amǝnia arǝ ndǎ mana à pànà gìr'nkila nǝi kǝla pàgir ace dotarǝu ka.) Sǝ pǝris nǝ̀ pisǝia amur gyangŋan mala pàgir mala pisǝe kǝring a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Sǝ nggú jamnda andǝ nyami kat, atārǝia andǝ ɓamúrí, andǝ akusǝi, andǝ alungŋe, andǝ ciute, ");
INSERT INTO mbu_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yì acili abare jamnda kat ka, dumǝna púp nǝ̀ kánǝia anzǝm kàttì, a ban mǝɓoarnsari, a gìgí ban so tú, sǝ nǝ̀ pisǝì kǝring aɓa bǝsa mala nggun. Dumǝna púp nǝ̀ pisǝì kǝring amur gìgí ban so tú. ");
INSERT INTO mbu_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ɓǝ̀ amǝ Isǝrayila na kat a ɓinalea à pàk cauɓikea aɓa ɓwarkio, mala pak komǝyenani na mwashat atà agir mǝnana anzongcau mala Yahweh pǝrban arǝia ama ɓǝà kǝa peǎ ɗàng, sǝ cauɓikê ka sǝmbǝrǝ rǝì a mǝsǝ ɓwabundǝa, sǝ nǝnzǝ́mò ka à yì sǝlǝce ama à pàngŋǝ̀nà cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","lang cauɓikê mana à pè ka à yi súrǝ́nà rǝì ka, yì aɓwana a ɓinalea ka, à nǝ̀ pà jamnda mwashat a domwan ace pàgir ace lak cauɓikea, sǝ à nǝ̀ yinǝi a ɓadǝm Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Sǝ aɓwana-mǝgule amur ɓwabundǝa ka, dumǝna púp à nǝ̀ nongsǝ abuia a ɓamúr jamnda man, a ɓadǝm Yahweh, sǝ à nǝ̀ pwanmyali a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Pǝlǝa Pǝris Mǝgule ka, nǝ̀ ɗàrǝ́ aɓa nkila mala jamnda man, nǝ̀ kùtí nǝi aɓa Tara Ban-peri, ");
INSERT INTO mbu_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","sǝ pǝris nǝ̀ oasǝ munabuì aɓa nkile sǝ nǝ̀ watsǝki kusǝ tongno-nong-ɓari, a ɓadǝm Yahweh, a kusǝ lagìr-kasǝbân mala Ban-mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sǝ yì pǝris ka, nǝ̀ ɗàrǝ́ bǝti aɓa nkila, nǝ̀ hasǝki arǝ anjawe gyangŋan mǝnana nda aɓa Tara Ban-peri, a ɓadǝm Yahweh ka. Cili nkila mǝnana ue ka, dumǝna púp nǝ̀ solǝi kat a kusǝ gyangŋan mala pàgir mala pisǝe kǝring, mǝnana nda a bankutio aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Sǝ nǝ̀ pusǝki mùrú-nyama mala jamnda kat, nǝ pisǝì amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Amǝno ka à nda ka gir mǝnana nǝ̀ pàngnǝ mǝno yì jamnda ka. Kǝla mǝnana pàngnǝ jamnda mala pàgir ace cauɓikea ka, anggo sǝ nǝ̀ pàngnǝ mǝnia. Sǝ yì pǝris ka nǝ̀ shawuɗia, sǝ à nǝ̀ twaliabanì. ");
INSERT INTO mbu_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Sǝ nǝ̀ twal acili bare jamnda man, nǝ̀ kánǝia anzǝm kàttì, sǝ nǝ̀ pisǝì kǝla mana pisǝ jamnda mǝdǝmbe ka; mǝnia ka pàgir ace cauɓikea mala aɓwana a ɓinalea na. ");
INSERT INTO mbu_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Lang ɓwamǝgule amur tàu mala aɓwana, nda pàk cauɓikea aɓa ɓwarkio, mala pàk komǝyenani atà agir mǝnana anzongcau mala Yahweh, Ɓakuli male, bang ama ɓǝà kǝa pè raka, sǝ yi sǝlǝ ama pàngŋǝ̀nà cauɓikea, ");
INSERT INTO mbu_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ko ana raka, à yi lǝmdǝì wi cauɓikea mǝnana yì ka pàk ka, dumǝna púp nǝ̀ yinǝ gbato mǝnana ɓè kǝ̀ gìr mǝɓane pà kàm arǝì raka, ɓǝ̀ duk pàgir male ");
INSERT INTO mbu_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","sǝ yì ka, nǝ̀ nongsǝ bui a ɓamur gbato, sǝ nǝ̀ pwan-myali a ban mǝnana à kǝ̀ pwanmyal agir'nkila mala pisǝia kǝring ngga, a ɓadǝm Yahweh; mǝnia ka pàgir ace cauɓikea na. ");
INSERT INTO mbu_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Pǝlǝa pǝris nǝ̀ ɗàrǝ́ aɓa nkila mala pàgir ace lak cauɓikea sǝ nǝ̀ hasǝki nǝ munabui arǝ anjawe gyangŋan mala pàgir ace pisǝe kǝring, sǝ nǝ̀ solǝ cili nkile a kusǝ gyangŋan mala pàgir ace pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Sǝ mùrú-nyama male kat ka, dumǝna púp nǝ̀ pisǝì amur gyangŋan, kǝla mana à pàngnǝ mùrú-nyama mala apagir mala gìr'nkila ace dotarǝu ka. Anggo sǝ pǝris nǝ̀ shawuɗi ɓwa mǝno ace cauɓikea male, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ɓǝ̀ koyan atà amǝ'tǝ̀r na pàk cauɓikea aɓa ɓwarkio, mala pàk komǝyenani atà agir mǝnana anzongcau mala Yahweh bang ama ɓǝà kǝa pè raka, sǝ yi sǝlǝ ama pàngŋǝ̀nà cauɓikea, ");
INSERT INTO mbu_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ko ana raka, à yi lǝmdǝì wi cauɓikea mǝnana yì ka pàk ka, dumǝna púp nǝ̀ yinǝ pàgir male, mbul mǝ'nggaule mǝnana ɓè kǝ̀ gìr mǝɓane pà kàm arǝì raka, ace cauɓikea male mǝnana pàk ka. ");
INSERT INTO mbu_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Sǝ yì ka nǝ̀ nongsǝ bui a ɓamúr pàgir man ace cauɓikea ka, sǝ nǝ̀ pwan-myali a ban mǝnana à kǝ̀ pàgir mala pisǝe kǝring ngga. ");
INSERT INTO mbu_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sǝ pǝris nǝ̀ ɗàrǝ́ aɓa nkile, nǝ̀ hasǝki nǝ munabui arǝ anjawe gyangŋan mala pàgir mala pisǝe kǝring, sǝ nǝ̀ solǝ cili nkile a kusǝ gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Sǝ mùrú-nyama male kat ka, nǝ̀ pusǝki, kǝla mana à pusǝki mùrú-nyama mala apagir ace dotarǝu ka, sǝ pǝris nǝ̀ pisǝì amur gyangŋan ace pa rǝmban mǝɓoarne mana nǝ̀ pwasǝbumam Yahweh ka. Sǝ pǝris nǝ̀ shawuɗì ɓwê, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ɓǝ̀ muna-nzur na yì ka nǝ̀ yinǝi kǝla pàgir male ace cauɓikea ka, dumǝna púp nǝ̀ yinǝ mǝ'nggaule mǝnana ɓè kǝ̀ gìr mǝɓane pà kàm arǝì raka; ");
INSERT INTO mbu_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","yì ka nǝ̀ nongsǝ bui a ɓamúr mǝnia yì pàgir ace cauɓikea ka, sǝ nǝ̀ pwan-myali ɓǝ̀ duk pàgir ace cauɓikea a ban mǝnana à kǝ̀ pwan-myal girkusǝu mana à pà ace pisǝe kǝring ngga. ");
INSERT INTO mbu_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Pǝlǝa pǝris nǝ̀ ɗàrǝ́ aɓa nkila mala mǝnia yì pàgir ace cauɓikea ka, nǝ̀ hasǝki nǝ munabui arǝ anjawe gyangŋan mala pàgir mala pisǝe kǝring ngga, sǝ nǝ̀ solǝ cili nkile a kusǝ gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Sǝ mùrú-nyama male kat ka, nǝ̀ pusǝki, kǝla mana à pusǝki mùrú-nyama arǝ nzur mala gìr'nkila mala apagir ace dotarǝu ka, sǝ pǝris nǝ̀ pisǝì amur gyangŋan, amur apagir mala girlina abanam Yahweh. Sǝ pǝris nǝ̀ shawuɗì, ace cauɓikea mana pàk ka, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","<<Ɓwa pàngŋǝ̀nà cauɓikea ɓǝ̀ kùtí aɓa komǝyenani atà amǝnia yì acau ka: Ɓǝ̀ túrban yiu aban ɓwa ama ɓǝ̀ yì nakuni a ndàɓashi amur ɓè gìr mǝnana kumban a ɓadǝmbi, ko sǝni, ko mǝnana súrǝ̀ cau amurí, sǝ yì ka ɓinǝe, pà nǝ̀ bang gìr mǝnana súrǝì ka, raka, bafe mala cauɓikea male nǝ̀ do amurí. ");
INSERT INTO mbu_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ko ana raka, ɓǝ̀ ɓwa je ɓekǝ gìr mǝnana gìr'ɓeami na, ko lugir nyam-ɓabondo mǝɓeami na, ko lugir nyam-ɓala mǝɓeami na, ko lú giryilǝmu mǝɓeami mǝnana kǝ kuɗǝki a nzali ka nda ka, sǝ ko ɓǝ̀ yì ka sǝlǝce raka, nggearǝ yi ka pǝlǝna gìr'ɓeami. Sǝ mǝno ka nunbǝnǝi wi cauɓikea amurí. ");
INSERT INTO mbu_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ko ana raka, ɓǝ̀ ɓwa je ɓekǝ gìr'ɓeami mǝnana kǝ pur arǝ ɓwapǝndǝa, ko ɓǝ̀ ya ulang gìr'ɓeami na mǝnana nǝ̀ tsǝk ɓwa ɓǝ̀ duk gìr'ɓeami, sǝ pà nǝ sǝlǝe male raka, lang ɓǝ̀ yi sǝlǝce ka, nunbǝnǝi wi cauɓikea amurí. ");
INSERT INTO mbu_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ko ana raka, ɓǝ̀ ɓwa kaurǝ a pàcau nǝ kángìr ama nǝ̀ pàk ɓekǝ gìr, ko mǝɓoarne ko mǝɓane, sǝ pàk ɗenyicau amurí ɗàng, ko ɓǝ̀ ya pacau na mǝnana aɓwana kǝ pe a kaurǝa nǝ kángìr, sǝ ko pè aɓa ɗwanyi sǝlǝe, sǝ nǝnzǝ́mò ka yi sǝlǝce ka, nunbǝnǝi ɓamúrì cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ɓǝ̀ ɓwa yi sǝlǝce cauɓikea male amur komǝyenani atà acau mǝno, sǝ earnǝ cauɓikea mǝnana pàk ka, ");
INSERT INTO mbu_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","dumǝna púp nǝ̀ bwal nzur ko mbul mǝ'nggaule a domwan, sǝ nǝ̀ yinǝi abanam Yahweh, ɓǝ̀ duk mbwegìr ace cauɓikea mǝnana pàk ka. Sǝ pǝris nǝ̀ shawuɗì ace cauɓikea male. ");
INSERT INTO mbu_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","<<Sǝama ɓǝ̀ ɓwe ka, kume male bik mǝnana nǝ̀ gandǝ pà nzur ko mbul raka, ɓǝ̀ yinǝ akutugangyi ɓari ko akutumurǝm ɓari abanam Yahweh. Mǝno ka nǝ̀ duk pàgir male mala mbwegìr ace cauɓikea mǝnana pàk ka. Man mwashat ka nda ace pàgir ace cauɓikea, sǝ ɓè man mwashat ka nda ace pàgir mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Yì ka nǝ̀ yinǝia aban pǝris, sǝ pǝris nǝ̀ pà mǝdǝmbe ɓǝ̀ duk pàgir ace cauɓikea. Nǝ̀ pūrǝ myali sǝama pà nǝ̀ kasǝi kpat ɗang, ");
INSERT INTO mbu_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","sǝ nǝ̀ watsǝki bǝti aɓa nkila mala mǝnia yì pàgir ace cauɓikea ka arǝ abumban mala gyangŋan, sǝ cili nkile ka nǝ̀ solǝi a kusǝ gyangŋan. Pàgir ace cauɓikea na. ");
INSERT INTO mbu_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Pǝlǝa nǝ̀ pà ɓaria ɓǝ̀ duk pàgir mala pisǝe kǝring, kǝla mana nzongcau kasǝ ka. Sǝ pǝris nǝ̀ shawuɗì, ace cauɓikea mana pàk ka, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","<<Sǝ ɓǝ̀ kume male bik mǝnana nǝ̀ gandǝ pà akutugangyi ɓari ko akutumurǝm ɓari raka, dumǝna púp nǝ̀ yinǝ tasau mwashat mala muku mǝɓǝlke, kǝla pàgir male ace cauɓikea mǝnana pàk ka, ɓǝ̀ duk pàgir ace cauɓikea. Pà nǝ̀ so kǝ mùrú olif amurí ɗàng, sǝ pà nǝ̀ tsǝk kǝ myang-kwarra amurí ɗàng, acemǝnana pàgir ace cauɓikea na. ");
INSERT INTO mbu_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Sǝ yì ka nǝ̀ yinǝi aban pǝris, sǝ pǝris nǝ̀ ɗàrǝ́ mukuì ɓǝ̀ lùmsǝ ɓabui, mǝnana do kǝla kāmbe mala kasǝɓalǝu, mana à twal aɓa pàgir mǝno ka, sǝ nǝ̀ soe a bǝsa, ɓǝ̀ pi amur gyangŋan atārǝia andǝ apagir mala girlina abanam Yahweh; pàgir ace cauɓikea na. ");
INSERT INTO mbu_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Anggo sǝ pǝris nǝ̀ shawuɗì, ace cauɓikea mǝnana pàk ka, ko ɓǝ̀ mǝyenani atà amǝno yì acau ka, sǝ à nǝ̀ twalîbanì. Sǝ cili muku ka nǝ̀ duk mala pǝris, kǝla mana à pǎ a pàgir mala mǝsǝsa ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","<<Ɓǝ̀ ɓwa yàl-nzong aɓa ɗwanyi-sǝlǝe sǝ pàk cauɓikea mala kyanggî anggurcau mala pagìr abanam Yahweh, atà agir mǝnana à tàrnia ace mǝnana ɓǝà pam ngga, dumǝna púp ɓwe nǝ̀ bwal gam a domwan male, mǝnana ɓekǝ gìr mǝɓane pà kàm arǝì raka, sǝ kúrè ka shekel mala bolo-azǝrfa na, kǝla mana à ear amurí aɓa Tara-mǝfele ka, sǝ nǝ̀ yinǝi abanam Yahweh, ɓǝ̀ duk pàgir mala mbwegìr ace kumcau. ");
INSERT INTO mbu_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Sǝ ɓǝ̀ mana girnì na ɓwe gatti pa aɓalǝ agir mana amala Yahweh na ka, dumǝna púp nǝ̀ nyesǝ gir mǝno ka, sǝ nǝ̀ tsǝk mwashat aɓa gauwe tongno mala gìrnî amurí, sǝ nǝ̀ pè pǝris. Sǝ pǝris nǝ̀ shawuɗì nǝ mǝno yì gam, mala pagìr mala mbwegìr ace kumcau ka, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","<<Ɓǝ̀ koyan sǝ pàk cauɓikea mala yàlî komǝyenani atà anzongcau mala Yahweh, amur agir mǝnana à bang ama ɓǝà kǝa peǎ raka, kat andǝ amani ama ɓwê pè aɓa ɗwanyi-sǝlǝe, sǝ nǝ nzǝ́mò ka yi sǝlǝ ama pàngŋǝ̀nà cauɓikea ka, bafe mala cauɓikea male nǝ̀ do amurí. ");
INSERT INTO mbu_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Dumǝna púp nǝ̀ yinǝì pǝris gam mǝnana ɓekǝ gìr mǝɓane pà kàm arǝì raka, a domwan male, ko nǝ̀ pe wi boalo shekel mala bolo-azǝrfa ace gam, mala pàgir mala mbwegìr ace kumcau, sǝ pǝris nǝ̀ shawuɗì ɓwê, ace ɓwarkio male mǝnana pè aɓa ɗwanyi-sǝlǝe ka, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Pagìr mala mbwegìr ace kumcau na, ace gǝshi cauɓikea mǝnana ɓwê pàkkî Yahweh ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yahweh nacau nǝ Musa ama: ");
INSERT INTO mbu_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Ɓǝ̀ kǝɓwa atà wun pàk cauɓikea mala yàl nzongcau mala Yahweh, nǝ lǝmdǝ ɗwanyi domǝsǝcau aban ɓi mǝ'murkala amur cau mala gìr mǝnana à tsǝì abani ɓǝ̀ tsǝkiri sǝ lì, ko ak gìr a bù ɓi sǝ ɓinǝ nyesǝi wi, ko mala fwà gìr arǝ ɓi nǝ rǝcandǝa, ko ɓǝ̀ ɓǝmbǝri ɓi mǝ'murkala; ");
INSERT INTO mbu_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ko mala kum ɓekǝ gìr mala ɓi mǝnana ɓwaro sǝ tǝmce; andǝ mala koya ulang cauɓikea na mǝnana ɓwa pè sǝ kángìr aɓa nyir amurí ka; ");
INSERT INTO mbu_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ɓǝ̀ à kum ɓwa nǝ cauɓikea atà agir mǝnia ka, dumǝna púp nǝ̀ nyesǝ gir mana fwè nǝ rǝcandǝa, ko gìr mǝnana kumi aɓa ɓǝmbǝriban, ko gìr mǝnana à tsǝì abani, ko gìr mǝnana ɓwaro sǝ kumi ka. ");
INSERT INTO mbu_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Sǝ gìrnî na nǝmurǝi nǝ̀ nyesǝî mǝtale ka ɗàng, dumǝna púp nǝ̀ tsǝk mwashat aɓa gauwe tongno mala kúrè amurí. Dumǝna púp nǝ̀ mbwe mǝtale anggo ɓǝ̀ yi sǝlǝnace cauɓikea male ka. ");
INSERT INTO mbu_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Sǝ nǝ̀ bwal gam a domwan male, mǝnana ɓekǝ gìr mǝɓane pà kàm arǝì raka, sǝ nǝ̀ yinǝi aban pǝris, ko nǝ̀ pe wi boalo shekel mala bolo-azǝrfa ace gam, ace pàgir abanam Yahweh, mala pagìr mala mbwegìr ace kumcau. ");
INSERT INTO mbu_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Sǝ pǝris nǝ̀ shawuɗì a ɓadǝm Yahweh, sǝ à nǝ̀ twalîban koyagir nani mǝnana kumcau arǝì ka. ");
INSERT INTO mbu_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","<<Banggi Haruna andǝ amuna-burana male ama, <Amǝnia ka à nda ka anggurcau mala pāki agir'nkila mala pisǝe kǝring. Gir'nkila mala pisǝe kǝring ngga nǝ̀ ueo a bǝsa amur gyangŋan aɓa dù kat ba kwaro mala bân, sǝ bǝsa amur gyangŋan ngga dumǝna púp ɓǝ̀ lidǝmba nǝ earke koya pwari. ");
INSERT INTO mbu_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Pǝlǝa pǝris ka nǝ̀ oasǝ shiwan male mala nggubyau linǝn atè, sǝ nǝ̀ túr adaura-pǝris male mana à peǎ nǝ nggubyau linǝn ngga arǝì; sǝ nǝ̀ pwan tú pagìr mala pisǝe kǝring, mǝnana bǝsa lì amur gyangŋan ngga, sǝ nǝ̀ tsǝì a nkanggari gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Pǝlǝa nǝ̀ swár adaura-pǝris mana arǝì ka, nǝ̀ nggaɗia nǝ aɓea agir-nggūrǝu, sǝ nǝ̀ twal tú mǝnia ka nǝ̀ nggá soé a ban mǝɓoarnsari anzǝm kàttì. ");
INSERT INTO mbu_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Dumǝna púp bǝsa mǝnana amur gyangŋan ngga à nǝ̀ tsǝì ɓǝ̀ kǝ earke; ɓǝ̀ kǝa limgi ɗang. Koya dǝmbari ka pǝris nǝ̀ tsǝk nggun a bǝsa, nǝ̀ nongsǝ pagìr mala pisǝe kǝring amurí, sǝ nǝ̀ pisǝ mùrú-nyama mala apagir ace dotarǝu amurí. ");
INSERT INTO mbu_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Bǝsa ka nǝ̀ lidǝmba nǝ earke amur gyangŋan bà; à pà nǝ̀ ɗeki ɓǝ̀ limgi ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","<< <Amǝnia ka à nda ka anggurcau mala apagir mala mǝsǝsa. Amuna-burana mala Haruna nǝ̀ pàgir mala mǝsǝsa mǝnia abanam Yahweh a ɓadǝm gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ɓeɓwa ateà nǝ̀ ɗàrǝ́ muku mǝɓǝlke mala pàgir mala mǝsǝsa mǝnana à zurǝì andǝ mùrú olif ka ɓǝ̀ lùmsǝ ɓabui, sǝ atārǝia andǝ myang-kwarra mana amurí ka kat, nǝ̀ pisǝì amur gyangŋan. Mukuì mǝno a ɓabu ka nda kāmbe mala kasǝɓalǝu aɓa pàgir mǝno kat à pà abanam Yahweh ka; sǝ rǝmbi mǝɓoarne mana lo aɓa pǐ male a bǝsa ka nǝ̀ pwasǝbumam. ");
INSERT INTO mbu_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sǝ cili mana ue ka Haruna andǝ amuna-burana male nǝ̀ lì. À nǝ̀ lì sǝ pà nǝ yis arǝì ɗàng a ban mǝfele, aɓa patal mala Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","À pà nǝ̀ lurǝi nǝ yis arǝì ɗàng. Ən pania wia ɓǝ̀ duk kāmbe malea aɓa pàgir mala girlina mem. Pàgir nggea mǝfele na, kǝla pàgir ace cauɓikea andǝ pàgir mala mbwegìr ace kumcau. ");
INSERT INTO mbu_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Arǝ anza mǝnana kat à kǝ yiu ka, koya muna-ɓwabura a tàu mala Haruna ka nǝ̀ li aɓa mǝnia yì pàgir mana à pà abanam Yahweh, nǝ pisǝe a bǝsa ka. Mǝnia ka kāmbe malea na tàtǝ́k.> >> ");
INSERT INTO mbu_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","<<Mǝnia ka nda pàgir mana Haruna andǝ amuna-burana male nǝ̀ pà abanam Yahweh, a pwari mana à nǝ̀ ɗārǝì wi mùrú olif amurí ace tàré ɓǝ̀ duk pǝris ka: tasau mwashat mala muku mǝɓǝlke, kǝla mana à kǝ panagir nǝi koya pwari ka, gauwa-tsùrú male nǝ dǝmbari sǝ gauwa-tsùrú male nǝ pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","À nǝ̀ zurǝì andǝ mùrú olif pepè sǝ à nǝ̀ lurǝi aɓa nkenye kàng gìr. Awu nǝ ɓwangi bǝti-bǝti sǝ a nǝ yinǝi, awu nǝ panagir mala mǝsǝsa nǝi a bǝsa, ace pà rǝmban mǝɓoarne abanam Yahweh mana kǝ pwasǝbumam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Anggo sǝ koyan atà amuna ko amǝkau aburana a tàu mala Haruna, mana à tàrì ɓǝ̀ ak bancame male kǝla pǝris mǝgule ka, nǝ̀ pà mǝnia yì pàgir ka. Nzongcau na mǝnana à nǝ̀ kpate ka bà. Dumǝna púp à nǝ̀ pisǝi kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Koya pàgir mala mǝsǝsa na mana pǝris pà ka, à nǝ̀ pisǝì kat; à pà nǝ̀ lì ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","<<Banggi Haruna andǝ amuna-burana male ama, <Mǝnia ka nda nggurcau mala pàgir ace cauɓikea. A ban mǝnana à kǝ pwan-myal girkusǝu mala pàgir ace pisǝe kǝring ngga, kàm sǝ à nǝ̀ pwan-myal girkusǝu mala pàgir ace cauɓikea, a ɓadǝm Yahweh. Pàgir mǝnia ka nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Pǝris mǝnana pàkki agir mala pagìr ace cauɓikea ka nda nǝ̀ lì ka, a ban mǝfele, aɓa patal mala Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ɓǝ̀yaɓwa na sǝ koyagir na mǝnana je nyam pagìr mǝnia ka, nǝ̀ duk mǝfele, sǝ ɓǝ̀ nkile tàu arǝ daura ka, dumǝna púp awu nǝ̀ lak mǝno yì daura ka a ban mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Koya nkwaring dǝɓang na à lam nyama mǝnia aɓalǝi ka, dumǝna púp à nǝ̀ arki, sǝ ɓǝ̀ nkwaring bolo na ka, dumǝna púp à nǝ̀ gosǝki ɓalǝi sǝ à nǝ̀ sheli nǝ mùr. ");
INSERT INTO mbu_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Koya ɓwabura a tàu mala apǝris ka nǝ̀ gandǝ li. Pàgir mǝnia ka nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Sǝama nyam girkusǝu mǝnana à pà ace cauɓikea, sǝ nkile ka à yinǝi aɓa Tara Ban-peri, ace shawuɗì, aɓa Ban Mǝfele ka, à pà nǝ̀ lì ɗàng; dumǝna púp à nǝ̀ pisǝi kǝring a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","<< <Mǝnia ka nda nggurcau mala pagìr mala mbwegìr ace kumcau. Pàgir mǝnia ka nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Girkusǝu mala pagìr mala mbwegìr ace kumcau ka, à nǝ̀ pwan-myali a ban mǝnana à kǝ pwan-myal agirkusǝu mala pagìr mala pisǝe kǝring ngga, sǝ nkile ka à nǝ̀ watsǝki arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mùrú-nyama male kat ka, à nǝ̀ pusǝki sǝ à nǝ̀ pàgir nǝi amur gyangŋan, yì mùrú-nyama mala nggilate andǝ mùrú-nyama mana nong amur agir-bumi, ");
INSERT INTO mbu_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","andǝ amuna-gbè ɓari andǝ mùrú-nyama mana lanzǝ arǝia tù a ban ɓunì ka, andǝ ban mǝɓoarne mala nkundingŋi mǝnana à nǝ̀ pusǝì atārǝia andǝ amuna-gbè ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Pǝris nǝ̀ pisǝia amur gyangŋan ɓǝ̀ duk pàgir nǝ bǝsa na abanam Yahweh; pagìr mala mbwegìr ace kumcau na. ");
INSERT INTO mbu_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Koya muna-ɓwabura a tàu mala Haruna ka nǝ̀ lì aɓa mǝnia yì pàgir à pà ka. À nǝ̀ lì a ban mǝfele. Pàgir nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Nggurcau mala pàgir mala mbwegìr ace kumcau ka nda mwashat andǝ nggurcau mala pàgir ace cauɓikea. Nyame ka nǝ̀ duk mala pǝris mana shawuɗiban ngga. ");
INSERT INTO mbu_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","<< <Nggū girkusǝu mana koya ɓwa pa ace pagìr mala pisǝe kǝring ngga, nǝ̀ duk mala pǝris mana shawuɗiban nǝ gìr'nkilè ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sǝ koya pàgir mala mǝsǝsa mǝnana à lurǝi a ovù, ko à kàngŋì aɓa nkenye kàng gìr ka, mala pǝris na mǝnana wari nǝi aban Ɓakuli ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Sǝ koya pàgir mala mǝsǝsa, mana à zurǝì andǝ mùrú olif, ko mana nda andǝa ime ka, à nǝ̀ gapì amuna-burana mala Haruna, koyan ngga ɓǝ̀ kumo kǝla mala ɓì. ");
INSERT INTO mbu_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","<< <Mǝnia ka nda nggurcau mala pà gìr'nkila ace apagir mala dotarǝu, mana ɓwa nǝ̀ yinǝia abanam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ɓǝ̀ ɓwa yinǝ pàgir mǝnia ace pàk-yàwá ka, dumǝna púp ama, atārǝia andǝ gìr'nkila mala pàk-yàwá ka, nǝ̀ pa agbatali bǝredi mana peǎ nǝ muku mana à zurǝì andǝ mùrú olif, sǝ yis pà arǝì raka, andǝ abiskit mana à peǎ nǝ yis raka, sǝ à hasǝkia wia mùrú olif arǝia ka, andǝ agbatali bǝredi mana à peǎ nǝ muku mǝɓǝlke mana à zurǝì pepè andǝ mùrú olif ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Atārǝia andǝ gìr'nkila mala apagir ace dotarǝu mana ɓwa nǝ̀ pa ace pàk-yàwá ka, dumǝna púp nǝ̀ yinǝi andǝ agbatali bǝredi mana yis pà arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Yì ka nǝ̀ twal kāmbe mwashat aɓa koya ulang bǝredi ace pàgir abanam Yahweh; à nǝ̀ pè pǝris mana twal nkila mala girkusǝu mana à pà ace dotarǝu, sǝ watsǝki arǝ gyangŋan ngga, ɓǝ̀ duk male. ");
INSERT INTO mbu_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sǝ nyam gìr'nkila mala apagir mala ɓwa ace dotarǝu, mana pà ace pàk-yàwá ka, dumǝna púp à nǝ̀ lì a pwari mala pàgir male. À pà nǝ̀ ɗeki ɓekǝ bare ɓǝ̀ bik dǝmbari ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","<< <Sǝama ɓǝ̀ pàgir mala ɓwa ka gìr'nkila na pa ace lùmsǝ pacau male mana pè nǝ shambum, ko pàgir mala eare mala ɓabumi na ka, à nǝ̀ lì gìr'nkilè a kǝ pwari mǝno, sǝ ɓǝ̀ cili ueo bà ɓè pwari mana kpata mǝno ka, à nǝ̀ lì. ");
INSERT INTO mbu_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Sǝama gìr mǝnana ueo aɓa nyam gìr'nkila mǝnia sǝ yi bik tàruia pwari ka, à nǝ̀ pisǝì kǝring a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ɓǝ̀ à lì cili nyam gìr'nkila mala pàgir male ace dotarǝu a tàruia pwari ka, Ɓakuli pa nǝ̀ ak pàgir mala ɓwe ɗàng, sǝ ɓwe pà nǝ̀ kum kǝ tsǝkbu aɓalǝi ɗàng. À nǝ̀ nyesǝì gìr'ɓeami na, sǝ ɓwa mǝnana lì ka, bafe mala cauɓikea male nǝ̀ do amurí. ");
INSERT INTO mbu_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","<< <Ɓǝ̀ nyame je ɓekǝ gìr'ɓeami ka à pà nǝ̀ lì ɗàng. À nǝ̀ pisǝì a bǝsa kǝring. << <Koya ɓwa mǝnana pǝndǝki rǝì raka, nǝ̀ gandǝ li nyame mala pàgir ace dotarǝu, ");
INSERT INTO mbu_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","sǝama ɓwa mǝnana lì nyam gìr'nkila mala apagir ace dotarǝu, mana à pà abanam Yahweh, sǝ nda aɓa do-ɓeami ka, mǝno yì ɓwa ka à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ɓǝ̀ ɓwa je gìr mǝnana gìr'ɓeami na (kǝla gìr'ɓeami mana kǝ pur arǝ ɓwapǝndǝa, ko girkusǝu mǝɓeami, ko ɓè giryilǝmu mǝɓeami mana à ɓinǝce), sǝ lì aɓa nyam gìr'nkila mala apagir ace dotarǝu mana mala Yahweh na ka, à pà nǝ̀ ɓal ɓwe aɓalǝ aɓwana male ɗàng.> >> ");
INSERT INTO mbu_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","<<Banggi amǝ Isǝrayila ama, <Pà wu nǝ̀ lì kǝ mùrú-nyama mala ndǎ ko nzur ko mbulpǝndǝa ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mùrú-nyama mala girkusǝu mǝnana à kumi wuna, ko anyamɓikea sàngi ka, à nǝ̀ gandǝ paktúró nǝi ace ɓè gìr, sǝama pà wun nǝ̀ lì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ɓǝ̀ ya ɓwa atà wun sǝ lì mùrú-nyama mala girkusǝu mǝnana à nǝ̀ pàgir nǝ bǝsa nǝi abanam Yahweh ka, ɓwê mǝno lì ka à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ɗǝm ngga pà wu nǝ̀ lì nkila ɗàng, ko ɓǝ̀ mǝye nani ka, ko mala nyal ko girkusǝu, arǝ abân mǝnana kat wu duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ɓwa mǝnana kat lì nkila ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng.> >> ");
INSERT INTO mbu_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","<<Banggi amǝ Isǝrayila ama, <Ɓwa mǝnana kat nǝ̀ pà gìr'nkila mala apagir male ace dotarǝu abanam Yahweh ka, dumǝna púp nǝ̀ twal kāmbe pagìr male aɓa gìr'nkila mala apagir male ace dotarǝu nǝ̀ yinǝi abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Yi ka nǝ̀ yinǝ apagir mala girlina mana mala Yahweh na ka, nǝ bui. Nǝ̀ yinǝ mùrú-nyama mala girkusǝunì andǝ kikili, sǝ nǝ̀ loasǝ kikili a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Pǝris nǝ̀ pisǝ mùrú-nyama mǝnia amur gyangŋan, sǝ kikili ka nǝ̀ duk mala Haruna andǝ amuna-burana male. ");
INSERT INTO mbu_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Sǝ byalu mǝlì mala girkusǝu mǝnia ka, à nǝ̀ pè pǝris kǝla kāmbe male aɓa gìr'nkila mala apagir ma'wun ace dotarǝu. ");
INSERT INTO mbu_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ɓǝ̀ yana atà amuna-burana mala Haruna nda pà nkila mala apagir ace dotarǝu andǝ mùrú-nyama male ka, nda à nǝ̀ pè wi byalu mǝlì ɓǝ̀ duk kāmbe male ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kikil girkusǝu mǝnia à loasǝi a kùli, sǝ byalu mǝlì mǝnana à pà kāmbe nǝi abanam, Mim Yahweh ka, ǝn twalǝni a bu amǝ Isǝrayila, aɓalǝ agir'nkila mala apagir malea ace dotarǝu, sǝ ǝn pani pǝris Haruna andǝ amuni andǝ amǝkè amuna-burana. Mǝnia ka dumǝna púp nda gìr mǝnana amǝ Isǝrayila nǝ̀ nggǝ pê apǝris arǝ anza mǝnana kat à kǝ yiu ka.> >> ");
INSERT INTO mbu_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Mǝnia ka nda kāmbe mala Haruna andǝ mala amuna-burana male aɓa pàgir mala girlina abanam Yahweh, twal a pwari mǝnana à tària ace túró kǝla apǝris mala Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yahweh pà nzongcau mǝnia ka a pwari mǝno à tària ka ama ɓǝ̀ amǝ Isǝrayila ɓǝà kǝ pea wia mǝnia yì kāmbe mala pàgir ka. Nggurcau na, mǝnana dumǝna púp amǝ Isǝrayila nǝ̀ kpatè arǝ anza mǝnana kat à kǝ̀ yiu ka. ");
INSERT INTO mbu_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Amǝno ka à nda ka nggurcau mala pàgir ace pisǝe kǝring, pàgir mala mǝsǝsa, pàgir ace cauɓikea, pàgir mala mbwegìr ace kumcau, pàgir mala tàrban ace túró pǝris, andǝ pàgir mala dotarǝu. ");
INSERT INTO mbu_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Akano amur Nkono Saina, a pǝɗanban, Yahweh pè Musa anzongcau mǝnia a pwari mana banggi amǝ Isǝrayila ɓǝà yinǝ apagir malea aban Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","<<Yinǝ Haruna andǝ amuna-burana male atè, andǝ adaura-pǝris, andǝ mùrú ɗārǝ́bân, andǝ jamnda mala pàgir ace cauɓikea, andǝ agam ɓari, sǝ zace mana nǝ bǝredi mǝnana yis pà arǝì raka, ");
INSERT INTO mbu_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","sǝ wu ram ɓwabundǝa kat a kún Tara Ban-peri.>> ");
INSERT INTO mbu_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa kpata gìr mǝnana Yahweh tsǝki wi ka; ɓwabundǝa yiu ramba a kún Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa ne ɓwabundǝa ama, <<Mǝnia ka ndà gìr mǝnana Yahweh tsǝa ama ɓǝà pè ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Pǝlǝa Musa yinǝ Haruna andǝ amuna-burana male a dǝmba, sǝ lakkia wia rǝia nǝ mur. ");
INSERT INTO mbu_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Yi oasǝi Haruna daura-ɓaɓalǝu mǝlime, kùri wi nggur-ɓunu a taɓuni, túrì wi daura-tsuru mǝsauwe sǝ oasǝi wi efot arǝì. Ɗǝm ngga mārǝi wi bugìr mārǝ́ taɓunu mǝ'nbaké mala efot sǝ kùrì. ");
INSERT INTO mbu_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Gyarì wi lǝpan-damɓalǝu a myali, sǝ aɓa lǝpan-damɓalǝu ka tsǝki wi Urim andǝ Tummim. ");
INSERT INTO mbu_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Pǝlǝa mārǝi wi nggubyau mbuɓi múrû amurí, sǝ tsǝki wi baji bolo-njengǝlan, yì jeko mǝfele, amur nggubyau mbuɓi múrû, nǝ kúndǝmbi, kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Pǝlǝa Musa twal mùrú ɗārǝ́bân sǝ ɗārǝ́ Taragula andǝ agir mana aɓalǝi ka kat, sǝ tària ace Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Sǝ ɗàrǝ́ aɓa mùrúnì, watsǝki amur gyangŋan kusǝ tongno-nong-ɓari, sǝ ɗārǝ́ gyangŋan andǝ agirtúró male kat, andǝ nkenye andǝ girtàmsǝe; tària ace Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Pǝlǝa Musa ɗàrǝ́ aɓa mùrú ɗārǝ́bânì, solǝì Haruna amurí, ɗārǝi, ace tàre ɓǝ̀ duk mala Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Sǝ Musa pusǝ amuna-burana mala Haruna a dǝmba ǝ oasǝkia wia adaura-pǝris arǝia, sǝ kurkia wia anggur-ɓunu a taɓunia, sǝ mārǝkia wia anggubyau mbuɓi múrû amúrià, kǝla mana Yahweh ne Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Osso yinǝ jamnda mala pàgir ace cauɓikea, sǝ Haruna andǝ amuna-burana male tsǝk abuia a ɓamur jamnda mala pàgir ace cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Osso Musa pwan-myal jamndê, ak nkile, sǝ hasǝki nǝ munabuì arǝ anjawe gyangŋan kat ace mǝnana ɓǝ̀ tsǝì ɓǝ̀ dumnǝ ɓoarnsari ka. Cili nkile ka solǝi a kusǝ gyangŋan. Anggo sǝ tàrì ace Ɓakuli ace mǝnana ɓǝ̀ shawuɗì ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa pǝlǝa twal mùrú-nyama mana kat lanzǝ arǝ agir-bum jamnda ka, andǝ ban mǝɓoarne mala nkundingŋi, andǝ amuna-gbè ɓari andǝ mùruia, sǝ pisǝia amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Sǝ cili jamnda, andǝ ngguí, andǝ nyami, andǝ ciute ka, à pisǝia a nzǝm kàttì, kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Pǝlǝa Musa warinǝ gam mala pàgir ace pisǝe kǝring, sǝ Haruna andǝ amuna-burana male nongsǝ abuia a ɓamur gamnì. ");
INSERT INTO mbu_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Osso Musa pwan-myal gamnì, sǝ tàkki nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Osso sàngi gamnì, sǝ lak agir-bumi andǝ akusǝi. Pǝlǝa nongsǝ ɓamúrí, andǝ mùruí, andǝ acili bare gam kǝring amur gyangŋan. Pàgir mala pisǝe kǝring na mala pà rǝmban mǝɓoarne ace pwasǝbum Yahweh; pàgir nǝ bǝsa na ace Yahweh, kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Nyar ɗǝm Musa yinǝ ɓaria gam, yì gam mala kùrî ɓwa túró pǝris, sǝ Haruna andǝ amuna-burana male nongsǝ abuia a ɓamur gamnì. ");
INSERT INTO mbu_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Osso Musa pwan-myal gamnì sǝ ɗàrǝ́ nkile, hasǝì Haruna a mburkiri mǝlì, andǝ munabui mǝbure mǝlì, andǝ muna-kusǝi mǝbure mǝlì. ");
INSERT INTO mbu_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ɗǝm ngga, Musa yinǝ amuna-burana mala Haruna a dǝmba, sǝ hasǝkia wia nkila gbal a mburkiria mǝlì, andǝ amuna-buia mǝbure mǝlì andǝ amuna-kusǝia mǝbure mǝlì. Pǝlǝa tàkki cili nkile arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Anzǝm mǝno ka, yi twal mùrú-nyama mala gamnì, andǝ mùrú nggilate, andǝ mùrú mana nong amur agir-bumi ka, andǝ ban mǝɓoarne mala nkundingŋi, andǝ amuna-gbè ɓari andǝ mùrú mana lanzǝ arǝia ka, andǝ byali mǝlì. ");
INSERT INTO mbu_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Sǝ aɓa zace mala bǝredi mǝnana yis pà arǝì raka, mana a ɓadǝm Yahweh ka, kya twal gbatali bǝredi mwashat, andǝ gbatali kyak mwashat mana nǝ mùrú olif arǝì ka, andǝ biskit mwashat, sǝ tsǝia amur abare mùruí andǝ byalu mǝlì. ");
INSERT INTO mbu_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Sǝ tsǝk amǝnia yi agir kat ka a ɓabu Haruna andǝ ɓabu amuna-burana male, sǝ à loasǝia a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Sǝ Musa ea a buia, sǝ pisǝia amur gyangŋan atārǝia andǝ pàgir mala pisǝe kǝring. Mǝnia ndà pàgir mala tàrban ace túró pǝris; pagir nǝ bǝsa na, mala pà rǝmban mǝɓoarne, mana kǝ pwasǝbum, mǝnana à pà aban Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa twal damɓalǝi, mǝnana nda kāmbe male aɓa gam mala tàrban ace túró pǝris ka, sǝ loasǝi a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh, kǝla mana Yahweh ne Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Pǝlǝa Musa ɗàrǝ́ aɓa mùrú ɗārǝ́bân sǝ aɓa nkila mana amur gyangŋan ngga sǝ watsǝki amur Haruna andǝ mur adaura-pǝris male, sǝ amur amuna-burana male andǝ adaura-pǝris malea gbal. Anggo sǝ tàr Haruna ace túró pǝris, yì andǝ adaura-pǝris male, andǝ amuna-burana male, andǝ adaura-pǝris malea. ");
INSERT INTO mbu_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa pǝlǝa ne Haruna andǝ amuna-burana male ama, <<Wu lam nyame a bankutio aɓa Tara Ban-peri, sǝ akǝ banì wu she atārǝia andǝ bǝredi mana aɓa zace mala pàgir mala tàrban ace túró pǝris ka, kǝla mana ǝn bang ama, <Haruna andǝ amuna-burana male na à nǝ̀ she ka.> ");
INSERT INTO mbu_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Gìr mana kat ueo mala nyama andǝ bǝredi ka wun nǝ̀ pisǝì a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pà wunǝ purî bankutio aɓa Tara Ban-peri ɗang bà nongŋo tongno-nong-ɓari, she ɓǝ̀ anongŋo mala tàrban ma'wun lumsǝna ka, acemana tàrban ma'wun nǝ̀ twal anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Gìr mǝnana à pè a pwari mǝnia yalung ngga, Yahweh nǝ̀ tsǝa ama ɓǝà pè ace shawuɗi wun. ");
INSERT INTO mbu_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dumǝna púp wun nǝ̀ ueo a bankutio aɓa Tara Ban-peri du andǝ pwari, bà anongŋo tongno-nong-ɓari, sǝ wun nǝ̀ camarǝ pakki atúró mana Yahweh na ama ɓǝ̀ wu pea ka, ace mǝnana ɓǝ̀ wu kǝa wù raka; mǝno ka nda gìr mǝnana Yahweh banggam ama ɓǝ̀n bangga wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Acemani ka, Haruna andǝ amuna-burana male pàk agir mana kat Yahweh ne nǝban Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A tongno-nong-tàruià pwari ka, Musa tunǝ Haruna andǝ amuna-burana male andǝ aɓwana-mǝgule mala amǝ Isǝrayila, ");
INSERT INTO mbu_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","sǝ ne Haruna ama, <<Twalî ɓamúrò lo-jamnda ace pàgir ace cauɓikea, andǝ gam ace pàgir mala pisǝe kǝring; yia kǝm ngga ɓǝà kǝa kum ɓekǝ gìr mǝɓane arǝia ɗàng, sǝ wu yinǝia a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Sǝ wu ne amǝ Isǝrayila ama, <Wu twal gbato ace pàgir ace cauɓikea, andǝ lo-jamnda andǝ mǝgam, mǝnana yia kǝm ngga mbulea mwashat, sǝ yia kǝm ngga kǝgìr mǝɓane pà kàm arǝia raka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ɗǝm ngga wu twal ndǎ andǝ gam ace apagir mala dotarǝu, mana wun nǝ̀ pà gìr'nkila nǝia a ɓadǝm Yahweh ka, atārǝia andǝ pàgir mala mǝsǝsa mana à zurǝì nǝ mùrú olif ka, acemana yalung ngga Yahweh nǝ̀ lǝmdǝ rǝì aban wun.> >> ");
INSERT INTO mbu_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Pǝlǝa à yinǝ agir mǝnana Musa nea wia ama ɓǝà yinǝia ka, a ɓadǝm Tara Ban-peri, sǝ ɓwabundǝa kat sung tù à yi came a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa osso bang ama, <<Mǝnia ka ndà gìr mǝnana Yahweh na wun ama ɓǝ̀ wu pàk ka, ace mana ɓǝ̀ ɓoarɓwa mala Yahweh ɓǝ̀ lǝmdǝ rǝì aban wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Pǝlǝa Musa ne Haruna ama, <<Sung tù aban gyangŋan sǝ wu pàgir mò ace cauɓikea, andǝ pàgir mô mala pisǝe kǝring, ace shawuɗi ɓamuro sǝ ace shawuɗi aɓwana; sǝ wu yinǝ pàgir mala aɓwana, wu shawuɗia, kǝla mǝnana Yahweh bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ndà sǝ Haruna sung tù aban gyangŋan, yi pwan-myal lo-jamnda mala pàgir ace cauɓikea, mǝnana nda ace ɓamúrì ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Osso amuna-burana male, yì Haruna ka à pe wi nkile, sǝ oasǝ munabuì aɓalǝi sǝ hasǝki arǝ anjawe gyangŋan; cili nkile ka solǝi a kusǝ gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Sǝ mùruí, andǝ amuna-gbè, andǝ ban mǝɓoarne mala nkundingyi mana à pusǝia arǝ lo-jamnda mala pàgir ace cauɓikea ka, pisǝia amur gyangŋan, kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nyame andǝ ngguí ka pisǝia anzǝm kàttì. ");
INSERT INTO mbu_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Pǝlǝa Haruna pwan-myal gam mala pàgir ace pisǝe kǝring, sǝ amuna-burana male yinǝi wi nkile, sǝ tàkki arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Sǝ à pè wi ɓamúr gam mala pagìr mala pisǝe kǝring, andǝ abare mwashat-mwashat, sǝ pisǝia amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Sǝ lak agir-bumi andǝ akusǝi sǝ pisǝia amur gyangŋan atārǝia andǝ acili bare gam mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Pǝlǝa yinǝ agirkusǝu mana aɓwana pà ace pàgir ka, sǝ twal gbato mǝnana nda ace pàgir ace cauɓikea mala aɓwana ka, sǝ pwan-myali, sǝ pàgir ace cauɓikea nǝi, kǝla mana pangnǝ mǝdǝmbe ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Sǝ yinǝ lo-jamnda andǝ mǝgam mana à nda ace pàgir mala pisǝe kǝring ngga, yi panagir nǝia kǝla mana nggurcau kasǝ ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ɗǝm ngga yinǝ pàgir mala mǝsǝsa, ɗàrǝa lùmsǝ ɓabui, sǝ pisǝi amur gyangŋan tsǝa amur pàgir mana à pisǝì kǝring nǝ dǝmbari ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pǝlǝa pwan-myal ndǎ andǝ gam, yì agir'nkila ace apagir mala dotarǝu mǝnana à nda ace aɓwana ka. Sǝ amuna-burana male yì Haruna pe wi nkila sǝ tàkki arǝ abumban mala gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Sǝama mùrú-nyama mana arǝ abare ndǎ andǝ gam, yì mùrú mana arǝ a anggilatea, andǝ mana lanzǝ arǝ agir-bumia ka, à pusǝkia atārǝia andǝ amuna-gbea, andǝ abân mǝɓoarne mala ankundingyia; ");
INSERT INTO mbu_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","à nongsǝki abare mùrú-nyama mǝnia ka amur akikil agirkusǝu mǝno, sǝ Haruna pisǝ abare mùrú-nyama man amur gyangŋan; ");
INSERT INTO mbu_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","sǝ akikilu andǝ byalu mǝlì ka Haruna loasǝia a kùli, ɓǝ̀ duk pàgir na, mǝnana à loasǝi a kùli a ɓadǝm Yahweh, kǝla mana Musa tsǝk ka. ");
INSERT INTO mbu_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Lang Haruna malna pākia pàgir ace cauɓikea, andǝ pàgir ace pisǝe kǝring, andǝ apagir ace dotarǝu ka, pǝlǝa loasǝ abui sǝ sārǝia amur aɓwana sǝ tsǝkia wia bù, pǝlǝa sùlǝî múr gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Pǝlǝa Musa andǝ Haruna kùtí aɓa Tara Ban-peri. Lang à pur a nza ka, à tsǝki aɓwana bù, sǝ ɓoarɓwa mala Yahweh pusǝrǝi aban aɓwana kat à sǝni. ");
INSERT INTO mbu_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Pǝlǝa bǝsa pur nǝban Yahweh, yi li pàgir mala pisǝe kǝring mǝno ka andǝ abare mùrú mana amur gyangŋan ngga. Lang aɓwana kat sǝni ka, à mak'zwalo, sǝ à sárǝ́ nǝ ɓamǝsǝia a nzali. ");
INSERT INTO mbu_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","A ɓè fara ka, amuna-burana mala Haruna, yià Nadap andǝ Abihu, koyan ateà ka twal tasau-bǝsa male, ɗàrǝ́ nkalang bǝsa aɓalǝi sǝ so muku-gìr loasǝ yele mǝ'rǝmɓoarne amurí, sǝ pàgir nǝ bǝsa mana mala Ɓakuli na raka a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kara bǝsa pur nǝban Yahweh, pisǝia kǝring, sǝ à wǔ a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa osso ne Haruna ama, <<Mǝnia ka ndà gìr mana Yahweh banggice lang na ama, << <Mǝ nǝ lǝmdǝ ɓamúràm mǝ nda mǝfele aban aɓwana mana à nda tù abanam ngga, sǝ mǝ nǝ kum gulo a ɓadǝmbǝ aɓwana kat.> >> Haruna duk kúni ɗǝong. ");
INSERT INTO mbu_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa túrban ɓǝà tunǝ Mishayel andǝ Elzafan, amuna-burana mala Uziyel, kina Haruna, sǝ nea wia ama, <<Wu yiu kani wu pwan aɓǝla ma'wun ɓǝà nying ɓadǝm ban mǝfele, wu umnǝia anzǝm kàttì.>> ");
INSERT INTO mbu_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ndà à wario à kya pwan aluia, mana à nda aɓalǝ adaura-pǝris malea piu ka; à umnǝia anzǝm kàttì, kǝla mana Musa bang ngga. ");
INSERT INTO mbu_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Pǝlǝa Musa ne Haruna, sǝ Eleaza andǝ Itamar, amuna-burana male ama, <<Cè wu lǝmdǝ bumkiɗikea ma'wun nǝ nying nyang múr wun zuli, ko wu sàngi adaura ma'wun ɗàng, ace mǝnana wu kǝa wù raka, sǝ bumlulla mala Yahweh ɓǝkǝa sulǝo amur ɓwabundǝa kat raka. Sǝama amǝ'eam wun, amǝ Isǝrayila puppup ka, à earnia wia ɓǝà ɓua mǝnia yì alú atàcau mala bǝsa mana Yahweh tasǝ ka. ");
INSERT INTO mbu_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Sǝ wu kǝa purî bankutio aɓa Tara Ban-peri ɗang, ɓǝ̀ ana raka wun nǝ̀ wukio, acemǝnana mùrú ɗārǝ́bân mala Yahweh ka nda amur wun.>> Nda sǝ à pa kǝla mana Musa na ka. ");
INSERT INTO mbu_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Pǝlǝa Yahweh nacau nǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","<<A pà wunǝ nu mùr-anap ko mba ɗàng, we wunǝ amuna-burana mô, ɓǝ̀ wun nǝ̀ kùtí aɓa Tara Ban-peri ka, ace mǝnana wu kǝa wù raka. Mǝnia ka nǝ̀ duk nggurcau arǝ anza ma'wun kat tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mǝnia ka nda ace mǝnana ɓǝ̀ wu gau nre gir mǝfele andǝ mana mǝfele na raka, sǝ wu gau nre gìr'ɓeami andǝ mǝnana mǝɓoarnsari na ka. ");
INSERT INTO mbu_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Sǝ dumǝna púp awu nǝ̀ kanî aɓwana mala Isǝrayila kat angguracau mǝnana Mim Yahweh, ǝn banggia wia nǝban Musa ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Pǝlǝa Musa ne Haruna cau andǝ Eleaza andǝ Itamar, amuna-burana male mana à ue nǝ yilǝmu ka ama, <<Wu twal cili pàgir mala mǝsǝsa mǝnana ueo aɓa pàgir mala girlina mana à pà abanam Yahweh ka, wu lì, sǝama ɓǝkǝa pàngnǝ yis arǝì ɗàng; wu lì a nkanggari gyangŋan, acemǝnana pàgir nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Dumǝna púp wun nǝ̀ lì a ban mǝfele, acemǝnana kāmbe mò na sǝ kāmbe mala amuna-burana mô na aɓa pàgir mala girlina mǝnana à pà abanam Yahweh ka; acemǝnana anggo sǝ à nam. ");
INSERT INTO mbu_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Sǝama kikilu mana à loasǝi a kùli andǝ byali mana à pà kǝla kāmbe ka, wun nǝ̀ lì a ban mǝɓoarnsari, we, wunǝ amuna-burana mô, andǝ amuna-mamǝna mô atò, acemana à pana wunǝia kǝla kāmbe mò sǝ kāmbe mala amuna-burana mô aɓalǝ agir'nkila mala apagir ace dotarǝu mala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Byalu mana à pà kāmbe nǝi andǝ kikilu mana à loasǝi a kùli ka à nǝ̀ yinǝia atārǝia andǝ abare mùrú-nyama mala pàgir mala girlina, ace loasǝe a kùli ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. Mǝnia ka nǝ̀ duk kāmbe mò andǝ mala amuna-burana mô atò tàtǝ́k, kǝla mana Yahweh bang ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa ɗice gbato mala pàgir ace cauɓikea, sǝ yi sǝlǝa ama à angŋa dǝmba à pisǝni. Bumi-lullo arǝ Eleaza andǝ Itamar, yì amuna-burana mala Haruna mana à ue ka, sǝ ɗia ama, ");
INSERT INTO mbu_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","<<Ace mana sǝ nyam pàgir ace cauɓikea ka wu lì aɓa patal mala ban mǝfele ɗàng? Mǝnia yì pàgir ka nggea mǝfele na, sǝ Yahweh pana wuni ace mǝnana ɓǝ̀ wu twal twalo mala cauɓikea mala ɓwabundǝa, ɓǝ̀ wu shawuɗia a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nkile ka, à kùtí nǝi aɓa ban mǝfele aɓalǝi ɗàng. Ɓoaro male ka yale ɓǝ́ wu lina gìr'nkilè aɓa ban mǝfele, kǝla mana ǝn na wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pǝlǝa Haruna pè Musa eare ama, <<Yalung sǝ yia ka à pàgir malea ace cauɓikea sǝ à pàgir malea mala pisǝe kǝring a ɓadǝm Yahweh. Sǝ sǝni, nǝ ulang agir kǝla mǝno à kumam ngga, Yahweh nǝ̀ earam ɓǝn li mǝnia yì pàgir ace cauɓikea ka le?>> ");
INSERT INTO mbu_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Lang Musa ok cau mǝno ka, cê kpaki wi pǝlǝa earnǝi. ");
INSERT INTO mbu_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Sǝ Yahweh nacau nǝ Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","<<Wu banggi amǝ Isǝrayila acau mǝnia ka ama: Atà agirkusǝu mǝnana à kǝ gya a nzǝm-nzali ka, amǝnia ka à nda ka mana wun nǝ̀ gandǝ lia ka: ");
INSERT INTO mbu_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Koya girkusǝu mǝnana nkaulakusǝi na ɓulkǝt sǝ gauwa, sǝ kǝ ɓǝsǝlǝshe ka, wun nǝ̀ gandǝ nǝ li. ");
INSERT INTO mbu_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","<<Sǝama, atà agirkusǝu mana à kǝ ɓǝsǝlǝshe ko kusǝia na ɓulkǝt sǝ gau ka, pà wun nǝ̀ lì amǝnia ka ɗang: Kalakadambi, acemǝnana kǝ ɓǝsǝlǝshe sǝama kusǝi gau ɗang; ace mani ka, gìr'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Sǝ mpkalang, acemǝnana kǝ ɓǝsǝlǝshe sǝama kusǝi gau ɗang; ace mani ka, gìr'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Sǝ nsong, acemǝnana kǝ ɓǝsǝlǝshe sǝama kusǝi gau ɗang; ace mani ka, gìr'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Sǝ tǝmbǝrǝm, acemǝnana nkaulakusǝi na ɓulkǝt sǝ gauwa, sǝama kǝ ɓǝsǝlǝshe ɗàng; ace mani ka, gìr'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Dumǝna púp pà wun nǝ̀ lì kǝ nyamia ɗàng, sǝ pà wun nǝ̀ je luia ɗàng; agir'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","<<Atà agir mǝyilǝmui mǝnana à nda mùr ka, wun nǝ̀ gandǝ li amǝnia ka. Koya gìr mǝnana nda a nggeamùr ko nggeasala, sǝ ndanǝ abú-omùr andǝ nggwate ka, wun nǝ̀ gandǝ li. ");
INSERT INTO mbu_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Sǝama agir mǝyilǝmui mana a nggeamùr, andǝ amana a nggeasala, atà agir mǝyilǝmui mana à kǝ ging mbǝl-mbǝl a mùr, mǝnana à pànǝ abú-omùr andǝ nggwatea raka, agir ɓeakǝno na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Wun nǝ̀ twalia agir ɓeakǝno na; pà wun nǝ̀ lì kǝ nyamia ɗàng, sǝ wun nǝ̀ ɓinǝce aluia. ");
INSERT INTO mbu_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Gìr mǝnana kat nda a mùr, sǝ pànǝ abú-omùr andǝ nggwate raka, gìr ɓeakǝno na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","<<Amǝnia ka, à nda ka anyal mǝnana wun nǝ̀ ɓinǝcea ka; pà wu nǝ̀ lia ɗàng; agir'ɓeami na: nyal-nkeli, andǝ baula, andǝ dǝkǝlaki, ");
INSERT INTO mbu_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kùnggúm, andǝ koya ulang gìrfwanji, ");
INSERT INTO mbu_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","andǝ koya ulang gang'lang, ");
INSERT INTO mbu_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","andǝ ndaù, andǝ gihi, andǝ nyal-nggeamùr, andǝ koya nyal mǝnana nda kǝla mǝ'nzǝkarka ka, ");
INSERT INTO mbu_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","andǝ gihi mǝkyauwe, andǝ npyauwar, andǝ gihi mǝgule, ");
INSERT INTO mbu_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","andǝ gihi mǝpwasǝe, andǝ kùnggúm pǝɗanban, andǝ kàrkà, ");
INSERT INTO mbu_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","andǝ nyal-la, andǝ koya ulang mǝ'garakusǝsakya, andǝ nzaɓako, andǝ mǝkyengkyeng. ");
INSERT INTO mbu_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","<<Ankūngga mǝnana kat à ndanǝ mburu sǝ à kǝ gya amur akusǝia ine ka agir ɓeakǝno na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Sǝama, atà ankūngga mǝnana à ndanǝ mburu sǝ à kǝ gya amur akusǝia ine ka, wun nǝ̀ gandǝ li amana à ndanǝ agbata a garakusǝia mǝnana à kǝ zurki nǝia amur ɓakusǝia a nzali ka. ");
INSERT INTO mbu_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Aɓalǝia ka wun nǝ̀ gandǝ li amǝnia: koya ulang doshi, andǝ koya ulang doshi-sú'nzali, andǝ koya ulang nshire. ");
INSERT INTO mbu_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Sǝama acili ankūngga mǝnana à ndanǝ mburu andǝ akusǝia ine ka, agir ɓeakǝno na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","<<Amǝno ka à nda ka agir mǝnana à nǝ̀ tsǝk wun a do-ɓeami ka. Ɓwa mana kat je lú ka amǝno yì agir ka, nǝ̀ duk gìr'ɓeami ba kpa mala pwari. ");
INSERT INTO mbu_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Sǝ ɓwa mana kat twal kǝ bare lú ka agir mǝno ka, dumǝna púp nǝ̀ lakki anggubyau male, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","<<Koya girkusǝu mǝnana nkaulakusǝi na ɓulkǝt sǝ gauwa sǝama gau kat ɗàng, ko kǝ ɓǝsǝlǝshe raka, gìr'ɓeami na aban wun; ɓwa mǝnana kat jea ka nǝ̀ duk mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Agirkusǝu mana kat à kǝ gya amur akusǝia ine, sǝ à ndanǝ amuna-kusǝia nǝ ankaulakusǝia ka, agir'ɓeami na aban wun; ɓwa mana kat je luia ka, nǝ̀ duk mǝɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Sǝ ɓwa mǝnana kat twal luia ka, dumǝna púp nǝ̀ lak anggubyau male, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. Agir'ɓeami na aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","<<Atà agiryilǝmu mǝnana à kǝ kuɗǝki a nzali ka, amǝnia ka, à nǝ̀ duk gìr'ɓeami aban wun: butǝle, andǝ nkwam, andǝ koya ulang kalakuso mǝgule, ");
INSERT INTO mbu_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","andǝ shishar, andǝ tsarang, andǝ kasǝnazana, andǝ dàrá, andǝ kalankunding. ");
INSERT INTO mbu_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Amǝno ka agir'ɓeami na aban wun atà agir mǝnana à kǝ kuɗǝki a nzali ka. Ɓwa mana kat je luia ka, nǝ̀ duk gìr'ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Yale gìr mana kat luia kpa amurí ka, girni nǝ̀ duk gìr'ɓeami, ko gìr mǝnana à pè nǝ nggun ngga nda, ko gìr'nggūrǝu na, ko nggú na, ko záng na, ko koya girtúró na ka. Dumǝna púp à nǝ̀ oasǝi a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Sǝ komǝye na ateà mana kpa aɓa ɓekǝ nkwaring-dǝɓang ngga, agir mǝnana aɓalǝi kat ka à nǝ̀ duk agir'ɓeami, sǝ dumǝna púp à nǝ̀ arki. ");
INSERT INTO mbu_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Koya girlina na mana ɓoaro à nǝ̀ lì, sǝ liuwe aɓa mùr mana nda aɓa mǝno yì nkwaring ngga, nǝ̀ duk gìr'ɓeami, sǝ koya girnùná mǝnana nda aɓa mǝno yì nkwaring ngga nǝ̀ duk gìr'ɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Sǝ koya gìr na mǝnana kat koya bare lú mǝno yì girkusǝu ka kpa amurí ka, nǝ̀ duk gìr'ɓeami. Ko ɓǝ̀ ovù ko pira na sǝ ɓekǝ bare lugir mǝno kpa amurí ka dumǝna púp à nǝ̀ arki gucik-gucik. À dumǝna gìr'ɓeami sǝ à nǝ̀ duk gìr'ɓeami aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kat andǝ amani ka, mùr a mgbeɗe ko mùr a tūli ka nǝ̀ dum nǝ ɓoarnsari ko ɓǝ̀ lú komǝye na atà amǝno yì agirkusǝu sǝ kpa aɓalǝi ka, sǝama ɓwa mǝnana kat je luia ka nǝ̀ duk mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ɓǝ̀ mwashat aɓalǝ alúgir mǝno kpa amur ɓekǝ mǝsǝɓeale mana à nǝ̀ ká ɓeale ka, mǝnia yì mǝsǝɓeale ka nǝ̀ pàk mǝɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Sǝama ɓǝ̀ mǝsǝɓeale ka à liuni a mùr, sǝ ɓekǝ bare alúgir mǝno kpa amurí ka, dumǝna gìr'ɓeami aban wun. ");
INSERT INTO mbu_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","<<Ɓǝ̀ mwashat atà agirkusǝu mana mǝɓoarne na ace girlina sǝ wǔ ka, ɓwa mǝnana kat je luí ka nǝ̀ duk mǝɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ɓwa mǝnana kat lì nyam mǝno yì lugir ka, dumǝna púp nǝ̀ lak anggubyau male, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. Sǝ ɓwa mana kat twal lugir mǝno ka, dumǝna púp nǝ̀ lak anggubyau male, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","<<Giryilǝmu mǝnana kat kǝ kuɗǝki a nzali ka, gìr ɓeakǝno na; à pà nǝ̀ lì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Gìr mǝnana kat kǝ ɓangnǝ múrbumi, andǝ gìr mǝnana kat kǝ kuɗǝki a nzali nǝ akusǝi ine ko akusǝi pas ka, pà wun nǝ̀ lia ɗàng, acemǝnana agir ɓeakǝno na. ");
INSERT INTO mbu_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Wu kǝa pǝndǝki ɓamurǝ wun nǝ kǝɓè giryilǝmu mǝnana kǝ kuɗǝki ka, sǝ anggo ka wun nǝ̀ duk amǝɓeami nǝbania ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mǝ nda Yahweh, Ɓakuli ma'wun; wu tàr ɓamurǝ wun acem, wu duk domǝfele, acemǝnana mim ngga, mǝ nda mǝfele ka. Pà wun nǝ̀ pǝndǝki ɓamurǝ wun nǝ kǝɓè gìr mǝnana kǝ kuɗǝki a nzali ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mǝ nda Yahweh, mana ǝn pusǝ wun, wu purî ɓá Masar ka, ace mǝnana mǝ do, mǝ nda Ɓakuli ma'wun ngga. Acemani ka, wu duk amǝfele, acemana mim ngga mǝ nda mǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mǝnia ka nda nggurcau amur agirkusǝu, andǝ anyal, andǝ koya giryilǝmu mana kǝ gya a mùr, andǝ koya giryilǝmu mana kǝ kuɗǝki a nzali ka, ");
INSERT INTO mbu_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ace mǝnana ɓǝ̀ wu gau nre gìr'ɓeami andǝ gìr mǝɓoarnsari, sǝ ɓǝ̀ wu súrǝ̀ giryilǝmu mǝnana à nǝ̀ lì andǝ mana à pà nǝ̀ lì raka. ");
INSERT INTO mbu_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","<<Banggi amǝ Isǝrayila, ama, <Ɓwama mana kum muna-bum, sǝ gbáshí muna-ɓwabura ka, mǝno yì ɓwama ka nǝ̀ duk gìr'ɓeami ba anongŋo tongno-nong-ɓari, kǝla mana mǝɓeami na a bumkwana male ka. ");
INSERT INTO mbu_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sǝ a tongno-nong-tàruià pwari ka, à nǝ̀ kasǝî muna ɓate. ");
INSERT INTO mbu_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sǝ ɓwame ka, dumǝna púp nǝ̀ lidǝmba nǝ lakrǝu arǝ sukkio mala nkila gbáshí male anongŋo lumi-tàrú nong tàrú (33). Aɓalǝ anongŋo mala lakrǝu mǝno ka, dumǝna púp pà nǝ̀ je kǝgir mǝnana à tàrì mǝfele na ka ɗàng. Sǝ dumǝna púp pà nǝ̀ kùtí aɓa ban mǝfele ɗàng, sheɓǝ̀ anongŋo male, mala lakrǝu yi lumsǝna ka. ");
INSERT INTO mbu_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Sǝ ɓǝ̀ ɓwame ka muna-ɓwama na gbáshí ka, do-ɓeami male ka anongŋo mala limo ɓari na, kǝla mana mǝɓeami na a bumkwana male ka. Dumǝna púp nǝ̀ lidǝmba aɓa lakrǝu arǝ sukkio mala nkila gbáshí male anongŋo lumi-tongno-nong-mwashat bwamdǝ tongno-nong-mwashat (66). ");
INSERT INTO mbu_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","<< <Sǝ ɓǝ̀ anongŋo mala lakrǝu male arǝ sukkio mala nkila gbáshí muna-ɓwabura, ko muna-ɓwama lùmsǝna ka, nǝ̀ kánǝ muna-nzur mana mbule mwashat ka nǝ̀ pà aban pǝris a bankutio aɓa Tara Ban-peri, ace pàgir mala pisǝe kǝring, andǝ kutugangyi mwashat ko kutumurǝm mwashat ace pàgir ace cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Sǝ pǝris ka nǝ̀ yinǝia a ɓadǝm Yahweh, nǝ̀ shawuɗi ɓwame nǝia. Anzǝm mǝno ka, sǝ ɓwame nǝ̀ kum ɓoarnsari arǝ ɓunno mala nkila male. Mǝno ka, nda nggurcau mana ɓwama mǝnana loa gbáshí muna-ɓwabura, ko muna-ɓwama ka, nǝ̀ kpate ka. ");
INSERT INTO mbu_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Sǝama, ɓǝ̀ ɓwame pà nǝ̀ gandǝ pâ muna-nzur raka, ɓǝ̀ twal akutugangyi ɓari, ko akutumurǝm ɓari. Mwashat ka, nda ace pàgir mala pisǝe kǝring, sǝ ɓè man ngga nda ace pàgir ace cauɓikea. Sǝ pǝris nǝ̀ shawuɗì nǝia, sǝ ɓwame nǝ̀ kum ɓoarnsari.> >> ");
INSERT INTO mbu_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yahweh nacau nǝ Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","<<Lang ɓè ban a nggū rǝ ɓwa kum gìr-mwara, ko bàndà, ko ngguí terìkì, mǝnana yakǝla nǝ̀ nggá pǝlǝ kwánó nggû a nggū rǝì ka, dumǝna púp à nǝ̀ yinǝ ɓwe aban Haruna, yì pǝris, ko aban mwashat atà amuna-burana male, mana pǝris na ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Sǝ pǝris ka, nǝ̀ pelǝki ban mǝnana kwánó sak kam a nggū rǝ ɓwe ka. Sǝ ɓǝ̀ nyang mala ban mǝnana kwánó sak kam a nggū rǝ ɓwe ka, pǝlǝna mǝpwasǝe, sǝ kwane ka, lǝmdǝa kǝla limna aɓa ngguí ka, mǝnia ka kwánó nggû na bwali ka. Anzǝm mana pǝris pelǝkina ɓwe ka, pǝlǝa nǝ̀ bang bwāng ama, mǝnia yì ɓwa ka, dumǝna mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Sǝama ɓǝ̀ ban mana terìkì a nggū rǝ ɓwe ka pwasǝo, sǝ lǝmdǝ ama lime kútì ngguí ɗàng, sǝ nyang banì ka pǝlǝ mǝpwasǝe raka, pǝris nǝ̀ kasǝkun ɓwe a kurǝm ba anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sǝ a tongno-nong-ɓaria pwari ka, pǝris nǝ̀ pelǝki rǝ ɓwe ɗǝm. Sǝ ɓǝ̀ sǝni ama kwane ka ndakam piu sǝ ak nggū rǝ ɓwe raka, pǝris nǝ̀ kasǝkun ɓwe, ɓǝ̀ pàk aɓea nongŋo tongno-nong-ɓari ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sǝ pǝris nǝ̀ pelǝkì ɗǝm a tongno-nong-ɓaria pwari, sǝ ɓǝ̀ ban mǝno mana kum kwánó ka pǝlǝna mbǝrǝm-mbǝrǝm, sǝ kwane ka ak nggū rǝ ɓwe raka, pǝlǝa pǝris nǝ̀ bang bwāng ama, ɓwe ɓoarnansari; kǝ bàndà na kumi ka. Sǝ ɓwe ka nǝ̀ lakki anggubyau male, sǝ nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Sǝama, ɓǝ̀ bàndà aki nggū rǝ ɓwe, anzǝm mana ɓwe lǝmdǝna ɓamúrì aban pǝris ace lakban male ka, dumǝna púp, ɓwe nǝ̀ nyare nǝ̀ nggá lǝmdǝ ɓamúrì aban pǝris ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Sǝ pǝris nǝ̀ nyare nǝ̀ sǝngi rǝ mǝno yì ɓwa ka, sǝ ɓǝ̀ sǝni ama bàndà ka akina nggū rǝ ɓwe ka, pǝris nǝ̀ bang bwāng ama, ɓwe dumǝna mǝɓeami; kwánó nggû na bwali ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","<<Lang ɓwa bwal kwánó nggû ka, dumǝna púp à nǝ̀ yinǝi aban pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Sǝ pǝris nǝ̀ sǝngi nggūrǝ ɓwe. Ɓǝ̀ gìr-mwara mǝpwasǝe, nakam a nggū rǝì, mana tsǝ̀ngŋǝ̀nà nyang nggū rǝi pǝlǝna mǝpwasǝe, sǝ npenye loa mǝna a ban mǝnana mwar a nggū rǝì ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","mǝnia ka, kwánó nggû nggea mǝɓike na a nggū rǝì. Sǝ pǝris nǝ̀ bang bwāng ama, ɓwe ka, dumǝna mǝɓeami. Pà nǝ̀ ɓoaro ɓǝ̀ pǝris kasǝkun ɓwe ɗàng acemǝnana pǝlǝna mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Sǝ ɓǝ̀ mǝnia yì kwánó nggû ka ak nggū rǝ man yì ɓwa kwánó bwali ka kat, twal a ɓamúrí yi puro arǝ akusǝi, andǝ abân mǝnana arǝì kat pǝris nǝ̀ gandǝ sǝni ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","pǝlǝa pǝris nǝ̀ pelǝki ɗǝm. Ɓǝ̀ kwánó nggû akina nggūrǝ ɓwe kat ka, pǝris nǝ̀ bang bwāng ama, ɓwe ka ɓoarnansari. Acemǝnana nggū rǝ ɓwe pǝlǝna mǝpwasǝe kat-kat ka, ɓwe ɓoarnansari. ");
INSERT INTO mbu_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Sǝama a pwari mana kat à sǝn bǝsa npenye puro arǝ ɓwe ka, ɓwe nǝ̀ duk mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Sǝ pǝris nǝ̀ pelǝki bǝsa npenye mǝno arǝ ɓwe ka, sǝ nǝ̀ bang bwāng ama, ɓwe ka dumǝna mǝɓeami. Sak mala bǝsa npenye ka gìr'ɓeami na, sǝ lǝmdǝ ama, ɓwe ka ndanǝ kwánó nggû. ");
INSERT INTO mbu_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Sǝ ɓǝ̀ bǝsa npenye sonzǝo sǝ pǝlǝ mǝpwasǝe ɗǝm ngga, dumǝna púp ɓwe nǝ̀ yiu aban pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Pǝris nǝ̀ pelǝki nggūrǝ ɓwe, sǝ ɓǝ̀ kwane pǝlǝna mǝpwasǝe ka, pǝris nǝ̀ bang bwāng ama, ɓwe ka ɓoarnansari. Anggo, sǝ à nǝ̀ sǝlǝ ama, ɓwe ɓoarnansari. ");
INSERT INTO mbu_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","<<Lang ceakúmsǝǎm puro a nggū rǝ ɓwa sǝ yi sonzǝo, ");
INSERT INTO mbu_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","sǝ ɓǝ̀ ban mǝnana ceakúmsǝǎm pak kam ngga, mwaro sǝ pwasǝo ko terìkì, pǝlǝ mǝbangŋe sǝ kǝ tanzama ka, dumǝna púp à nǝ̀ lǝmdǝí aban pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Pǝris nǝ̀ pelǝki, sǝ ɓǝ̀ ban mǝnana terìkì ka lime kútì ngguí, sǝ nyang mǝnana aɓalǝi ka pǝlǝna mǝpwasǝe ka, pǝris nǝ̀ bang bwāng ama, ɓwe ka, dumǝna mǝɓeami. Mǝnia ka kwánó nggû na sak aɓa ceakúmsǝǎm ngga. ");
INSERT INTO mbu_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Sǝama, ɓǝ̀ pǝris pelǝki sǝ sǝni ama nyang mǝpwasǝe pà kàm aɓalǝi ɗàng, sǝ lime kútì cili nggū rǝ ɓwe raka, sǝ nda mbǝrǝm-mbǝrǝm ngga, pǝris nǝ̀ kasǝkun ɓwe ɓǝ̀ pàk anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Sǝ ɓǝ̀ kwane ka nda aban aki rǝ ɓwe ka, pǝris nǝ̀ bangŋi bwāng ama, ɓwe dumǝna mǝɓeami; kwánó na. ");
INSERT INTO mbu_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Sǝama, ɓǝ̀ ban mǝnana terìkì ka ueo a ban mǝmwashati, mesǝ raka, lǝmdǝ ama, npenye malǝna; kǝ yale-npenye na ue ka. Pǝris nǝ̀ gandǝ bangŋi bwāng ama, ɓwe ɓoarnansari. ");
INSERT INTO mbu_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","<<Lang bǝsa pisǝ ɓwa a nggū rǝì, sǝ nyam banì terìkì pǝlǝ mǝbangye sǝ pwasǝ ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","pǝris nǝ̀ pelǝki, sǝ ɓǝ̀ nyang mana a ban mǝnana terìkì ka pǝlǝna mǝpwasǝe, sǝ lǝmdǝ ama npenye lime kutini ngguí ka, mǝno ka kwánó nggû na pusǝrǝi a ban mǝno bǝsa pisǝi kam ngga. Pǝris ka, nǝ̀ na bwāng ama, ɓwe dumǝna mǝɓeami; kwánó nggû bwalǝni. ");
INSERT INTO mbu_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Sǝama ɓǝ̀ pǝris pelǝki, sǝ sǝn kǝ nyang pwasǝo a ban mǝnana terìkì ka ɗàng, sǝ npenye ka lime kútì ngguí raka, sǝ nda mbǝrǝm-mbǝrǝm ngga, pǝris nǝ̀ kasǝkuni she ɓǝ̀ pàkkina anongŋo tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A tongno-nong-ɓaria pwari ka, pǝris nǝ̀ pelǝkì ɗǝm, sǝ ɓǝ̀ nda ban mesǝe nǝ̀ ak rǝì ka, pǝris nǝ̀ bang bwāng ama, ɓwe dumǝna mǝɓeami; ndanǝ kwánó nggû. ");
INSERT INTO mbu_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Sǝama ɓǝ̀ ban mǝnana terìkì ka ueo a ban mǝmwashati, mǝsǝe a nggūrǝì ɗàng, sǝ nda mbǝrǝm-mbǝrǝm ngga, gìr-mwara na pusǝrǝi a ban mǝno bǝsa pisǝi kam ngga. Pǝris ka, nǝ̀ bang bwāng ama, ɓwe ka ɓoarnansari; yale-npenye mala pisǝban mala bǝsa na. ");
INSERT INTO mbu_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","<<Lang ɓwabura, ko ɓwama, kum kwánó a ɓamúrí, ko a mgbatakuni ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","pǝris nǝ̀ pelǝki kwane. Sǝ ɓǝ̀ sǝni ama lime kútì ngguí ɗàng, sǝ nyang mǝnana aɓalǝi ka mǝ'gwalani na sǝ nda watsǝkǝrak ka, pǝris nǝ̀ bang bwāng ama, ɓwe dumǝna mǝɓeami. Mǝnia ka, nzwari na; kwánó nggû mana kǝ puro a ɓamur, ko a mgbatakun ɓwa ka nda. ");
INSERT INTO mbu_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sǝ ɓǝ̀ pǝris pelǝki kwánó nzwarinì sǝ sǝni ama lime kútì ngguí ɗàng, sǝ nyang-pǝndǝa pà kàm a banì raka, pǝlǝa pǝris nǝ̀ kasǝkun ɓwe mana nǝ kwánó nzwari ka, she ɓǝ̀ pakkina anongŋo tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sǝ a tongno-nong-ɓaria pwari ka, pǝris nǝ̀ pelǝki kwane. Ɓǝ̀ nzwarinì malaká mesǝ ɗang, sǝ ɓǝ̀ nyang mǝ'gwalani pà kàm aɓalǝi ɗàng, sǝ nzwarinì lime kútì nggū rǝ ɓwê raka, ");
INSERT INTO mbu_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ɓwê nǝ̀ mwa nyang ɓamúrí, sǝama pà nǝ̀ mwa ban mǝnana nzwari nakam ngga ɗàng; sǝ pǝris nǝ̀ kasǝkun ɓwe mǝno kwánó nzwari bwali ka ba anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sǝ a tongno-nong-ɓaria pwari ka, pǝris nǝ̀ pelǝki nzwarinì, sǝ ɓǝ̀ sǝni ama nzwarinì mesǝ a nggūrǝ ɓwe ɗàng, sǝ ɓǝ̀ lǝmdǝ ama lime kútì ngguí raka, pǝlǝa pǝris nǝ̀ bang bwāng ama, ɓwê ɓoarnansari. Sǝ yì ka nǝ̀ lakki anggubyau male, sǝ nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Sǝama ɓǝ̀ nzwarinì mesǝe aki nggūrǝ ɓwe, anzǝm lakban male ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","pǝris nǝ̀ pelǝki ɓwe ɗǝm. Ɓǝ̀ nzwarinì akina nggūrǝ ɓwe ka, pǝris pà nǝ̀ alta kǝ nyang mǝ'gwalani aɓa npenye ɗàng; ɓwê dumǝna mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Sǝama ɓǝ̀ pǝris sǝni ama nzwarinì nggaɗi ɗang, sǝ nyang-pǝndǝa gulna aɓalǝi ka, lǝmdǝ ama nzwarinì sonzǝna, sǝ ɓwe ɓoarnansari, sǝ pǝris nǝ̀ bang bwāng ama ɓwe ɓoarnansari. ");
INSERT INTO mbu_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","<<Lang ɓwabura ko ɓwama, ndanǝ abân a nggū rǝì mǝnana à terìkì sǝ à pwasǝ ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","pǝris nǝ̀ sǝngi, sǝ ɓǝ̀ abân mǝno terìkì a nggū rǝ ɓwe, à pwasǝ mbǝrǝm-mbǝrǝm ngga, rǝǔ'eakya na pur a nggū rǝì ka; ɓwê ka ndanǝ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","<<Lang nyang ɓamur ɓwa rak ka, ɓwê pǝlǝna mǝɓamur-swara, sǝama ndanǝ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Sǝ ɓǝ̀ nyang kúndǝm ɓwa rak ka, ɓwê nǝ̀ pàngnǝ ɓamur-swara a kúndǝmbi, sǝama ndanǝ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Sǝama ɓǝ̀ ɓè ban a ɓamur-swara ko kúndǝm-swara mala ɓwa kum kwánó, sǝ banì pǝlǝ mǝbangye sǝ pwasǝ ka, kwánó nggû na sak a ɓamur-swara male ko kúndǝm-swara male ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Pǝlǝa pǝris nǝ̀ pelǝki, sǝ ɓǝ̀ sǝni kwánó mwárkya mǝno sak a ɓamur-swara ko kúndǝm-swara mala ɓwê ka, pǝlǝna mǝbangye sǝ pwasǝo, kǝla puro mala kwánó nggû a nggū rǝì ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ɓwê bwalna nǝ kwánó nggû. Ace mani ka dumǝna mǝɓeami. Pǝris nǝ̀ bang bwāng ama, ɓwê dumǝna mǝɓeami; kwánó male ka nda a ɓamúrí. ");
INSERT INTO mbu_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","<<Ɓwa mǝnana ndanǝ kwánó nggû ka, dumǝna púp nǝ̀ oasǝ agir-nggūrǝu mǝsange arǝì, sǝ nǝ̀ nying nyang ɓamúrí zuli. Sǝ ɓwê nǝ̀ gìr ban mburkuni sǝ nǝ̀ nggǝ hama ama, <Mǝɓeami! Mǝɓeami!> ");
INSERT INTO mbu_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ɓwê ka nǝ̀ ueo anggo mǝɓeami na aɓalǝ anongŋo mala do nǝ kwánó mǝno arǝì ka kat. Dumǝna mǝɓeami. Ɓwê nǝ̀ dum nǝmurǝì; nǝ̀ duk zak anzǝm la. ");
INSERT INTO mbu_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","<<Lang kwàpì sak arǝ gìr'nggūrǝu, mǝnana à tè nǝ ɗà'ndíng ko linǝn, ");
INSERT INTO mbu_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ko nda arǝ nkonggúr ko bugìr mala linǝn ko ɗà'ndíng, ko nda arǝ nggūgir, ko arǝ ɓè kǝgìr mǝnana à pè nǝ nggū ka, ");
INSERT INTO mbu_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ɓǝ̀ ban mǝnana kwàpì ka lǝmdǝ mùrì mǝpwale ko mǝbangŋe arǝ gìr'nggūrǝuǐ, ko arǝ nggūgirnì, ko arǝ nkonggúrnì, ko arǝ bugìrnî, ko arǝ ɓè kǝgìr mana à pè nǝ nggū ka, kwàpì mala kwánó nggû na, sǝ dumǝna púp à nǝ̀ lǝmdǝì pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Anzǝm mana pǝris pelǝkini ka, nǝ̀ tsǝa ama ɓǝà tsǝì zak, ba anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pǝlǝa a tongno-nong-ɓaria pwari ka, pǝris nǝ̀ pelǝki. Ɓǝ̀ sǝni ama kwàpì mǝno akina rǝ gìr'nggūrǝuǐ, ko nkonggúrnì, ko bugìrnî, ko nggūgirnì, komǝye nda túró mana à kǝ pangnǝi ka, kwàpì mala yinǝ kwánó nggû mǝɓinǝ malâ na; gìr'ɓeami na. ");
INSERT INTO mbu_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sǝ yì ka nǝ̀ pisǝ mǝno yì gìr'nggūrǝu mala nkonggúr ɗà'ndíng ko linǝn, andǝ koya gìr na mǝnana à pè nǝ nggū, mana kwánó aki rǝì ka; kwàpì mǝno ka mala yinǝ kwánó nggû mǝɓinǝ malâ na. Dumǝna púp à nǝ̀ pisǝì a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","<<Sǝ ɓǝ̀ pǝris pelǝkì sǝ sǝni ama kwane aki rǝ gìr'nggūrǝuǐ, ko nkonggúrnì, ko bugìrnî, ko koya gìr na mǝnana à pè nǝ nggū ka, raka, ");
INSERT INTO mbu_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","pǝlǝa pǝris nǝ̀ tsǝa ama ɓǝà lé sǝ ɓǝà tsǝì zak nǝ aɓwana ba anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sǝ pǝris nǝ̀ pelǝki mǝno yì gìr mana kwàpì ka ɗǝm. Sǝ ɓǝ̀ sǝni ama ban mǝnana kwàpì ka nggaɗi mùrì ɗàng, anzǝm mana à langŋǝ́nì ka, sǝ ko ɓǝ̀ kwàpì mesǝ raka, gìrnî dumǝna mǝɓeami. Dumǝna púp à nǝ̀ pisǝì a bǝsa, koɓǝ̀ ban mana kwàpì lì arǝ nggubyaunì ka nda aɓalǝi ko a nza ka. ");
INSERT INTO mbu_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","<<Sǝama ɓǝ̀ pǝris pelǝkì, sǝ sǝni ama ban mǝnana kwàpì ka nda mbǝrǝm-mbǝrǝm, anzǝm mana à langŋǝ́nì ka, nǝ̀ kasǝì arǝ gìr'nggūrǝuǐ, ko nggūgirnì, ko nkonggúrnì, ko bugìrnî. ");
INSERT INTO mbu_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ɓǝ̀ kwàpì nyare pusǝrǝi ɗǝm arǝ gìr'nggūrǝuǐ, ko arǝ nkonggúrnì, ko arǝ bugìrnî, ko arǝ koya gìr na mǝnana à pè nǝ nggū ka, lǝmndǝ ama kwàpìnî na arǝ akiban; dumǝna púp à nǝ̀ pisǝ koya gìr mǝnana ndanǝ kwàpìnî arǝì ka a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Sǝama ɓǝ̀ kwàpìnî ndǝrminì rǝ gìr'nggūrǝuǐ, ko nkonggúrnì, ko bugìrnî, ko koya gìr na mǝnana à pè nǝ nggū ka, anzǝm mana à langŋǝ́nì ka, dumǝna púp à nǝ̀ ɓǝsǝlǝ lê, sǝ nǝ̀ ɓoarnsari.>> ");
INSERT INTO mbu_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Mǝnia ka nda nggurcau mǝnana à nǝ̀ kpate ɓǝ̀ kwàpì pusǝrǝi arǝ gìr'nggūrǝu mana à swàrì nǝ nkonggúr ko bugìr mala linǝn ko ɗà'ndíng ngga, ko arǝ ɓè kǝgìr mǝnana à pè nǝ nggū ka, ace kasǝcau ama ɓoarnansari ko dumǝna mǝɓeami ka. ");
INSERT INTO mbu_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yahweh banggi Musa cau ama, ");
INSERT INTO mbu_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","<<Mǝnia ka nda nggurcau ace mǝkwánó nggû, a pwari mala lakban male. À nǝ̀ yinǝi a ɓadǝm pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Sǝ pǝris nǝ̀ pùr anzǝm lá nǝ̀ ngga pelǝki kwane. Ɓǝ̀ pǝris sǝni rǝ ɓwê mana ndanǝ kwánó nggû ka malǝna ka, ");
INSERT INTO mbu_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","pǝris nǝ̀ tsǝa ama ɓǝà yinǝ amuna-nyal mǝɓoarne ɓari nǝ yilǝmia, andǝ munagara nggun-seda, andǝ bugir mǝbangŋe, andǝ bondo-hisop, ace ɓwa mana à nǝ̀ lé ka. ");
INSERT INTO mbu_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Pǝlǝa pǝris nǝ̀ tsǝa ama ɓǝà pwan-myal mwashat atà amuna-nyal mǝno ka amúr mùr mgbeɗe aɓa nkwaring-dǝɓang. ");
INSERT INTO mbu_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sǝ pǝris ka, nǝ̀ twal nyal mana nǝyilǝmu ka, atārǝia andǝ munagara nggun-seda, andǝ bugir mǝbangŋe, andǝ bondo-hisop, sǝ nǝ̀ oasǝia aɓa nkila mala nyal mana à pwan-myali amúr mùr mgbeɗe ka. ");
INSERT INTO mbu_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Sǝ nǝ̀ watsǝkì kusǝ tongno-nong-ɓari amur ɓwa mǝnana à kǝ lé arǝ kwánó nggû ka. Pǝlǝa nǝ̀ bang bwāng ama ɓwê ɓoarnansari, sǝ nǝ̀ nying muna-nyal mana nǝ yilǝmu ka ɓǝ̀ o a bondo. ");
INSERT INTO mbu_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Sǝ ɓwa mana à kǝ lé ka, nǝ̀ lakki agir'nggūrǝì, nǝ̀ swár nyang múrí kat, nǝ̀ sussǝo a mùr, sǝ yì ka nǝ̀ ɓoarnsari. Sǝ anzǝm mǝno ka, ɓwê nǝ̀ gandǝ yiu aɓalǝ aɓwana a bando malea, sǝama pà nǝ̀ kùtí aɓa gumli male ɗàng, ba nongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A tongno-nong-ɓaria pwari ka, dumǝna púp ɓwê nǝ̀ swár nyang rǝi ɗǝm, andǝ mbotokuni, andǝ nyang múrmǝsǝì. Nǝ̀ swár nyang rǝi kat, nǝ̀ lakki agir'nggūrǝì kat, nǝ̀ sussǝo a mùr, sǝ yì ka nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","<<Sǝ a tongno-nong-tàruià nongŋo ka, ɓwê nǝ̀ yinǝ amuna-gam ɓari mǝnana ɓekǝ gìr mǝɓane pà kàm arǝia raka, andǝ nsari nzur mǝnana mbule mwashat sǝ ɓekǝ gìr mǝɓane pà kàm arǝì raka, andǝ tasau tàrú mala muku mǝɓǝlke, mǝnana à kpapi andǝ mùrú olif ace pàgir mala mǝsǝsa ka, andǝ mùrú olif banì mwashat aɓa gauwe tàrú mala du lita. ");
INSERT INTO mbu_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sǝ pǝris mana kǝ lé ka, nǝ̀ tamsǝ ɓwa mǝnana à kǝ lé ka, andǝ amǝnia yì agir ka a ɓadǝm Yahweh, a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Pǝlǝa pǝris nǝ̀ twal mwashat aɓalǝ amuna-gam, nǝ̀ pàgir mala mbwegìr ace kumcau nǝi, atārǝia andǝ mùrú olif banì mwashat aɓa gauwe tàrú mala du lita, sǝ nǝ̀ loasǝia a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Sǝ pǝris nǝ̀ pwan-myal mǝnia yì nzur ka, a ban mǝnana à kǝ pwan-myal agirkusǝu mala pàgir ace cauɓikea andǝ pàgir mala pisǝe kǝring ngga, a ban mǝfele. Pàgir mana à pà mala mbwegìr ace kumcau, kǝla pàgir mana à pà ace cauɓikea ka, amala pǝris na; nggea mǝfele na. ");
INSERT INTO mbu_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Pǝris ka, nǝ̀ ɗàrǝa aɓa mǝnia yì nkila mala pàgir ace kumcau ka, nǝ̀ dwakǝɗi a gyare mburkiru mǝlì mala ɓwa mǝnana à kǝ lé ka, sǝ amur munabui mǝbure mǝlì, sǝ amur muna-kusǝi mǝbure mǝlì. ");
INSERT INTO mbu_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Sǝ pǝris ka, nǝ̀ ɗàrǝa aɓa banì mwashat mala gauwe tàrú mala du lita mala mùrú olif, sǝ nǝ̀ solǝi a ɓabui mǝ'nggare, ");
INSERT INTO mbu_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","sǝ pǝris nǝ̀ oasǝ munabui mǝlì aɓa mùrú mana a ɓabui mǝ'nggare ka, sǝ nǝ̀ watsǝki nǝ munabui kusǝ tongno-nong-ɓari a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Sǝ aɓa mùrú mana ueo a ɓabui ka, pǝris nǝ̀ dwakǝɗi bǝti a gyare mburkiru mǝlì mala ɓwa mǝnana à kǝ lé ka, sǝ arǝ munabui mǝbure mǝlì, sǝ arǝ muna-kusǝi mǝbure mǝlì, amur nkila mala pàgir mala mbwegìr ace kumcau. ");
INSERT INTO mbu_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sǝ cili mùrú mana a ɓabu pǝris ka, nǝ̀ solǝi a ɓamur ɓwa mǝnana à kǝ lé ka. Pǝlǝa pǝris nǝ̀ shawuɗì a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Pǝris nǝ̀ pà pàgir ace cauɓikea ace shawuɗi ɓwa mǝnana à kǝ lé ɓǝ̀ purî ɓá do-ɓeami male ka. Anzǝm mǝno ka, nǝ̀ pwan-myal girkusǝu mala pàgir mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Sǝ nǝ̀ pà gir'nkila mala pàgir mala pisǝe kǝring, atārǝia andǝ pàgir mala mǝsǝsa, amur gyangŋan. Anggo sǝ pǝris nǝ̀ shawuɗi ɓwê, sǝ ɓwê nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","<<Sǝama ɓǝ̀ ɓwê ka mǝtǝr na, mana pà nǝ̀ gandǝ pà amǝnia yì apagir raka, dumǝna púp nǝ̀ yinǝ mǝgam ace pàgir mala mbwegìr ace kumcau, à nǝ̀ loasǝi a kùli ace shawuɗì. Ɗǝm ngga ɓwê nǝ̀ yinǝ tasau mwashat mala muku mǝɓǝlke, mǝnana à kpapi andǝ mùrú olif ka ace pàgir mala mǝsǝsa, andǝ mùrú olif banì mwashat aɓa gauwe tàrú mala du lita. ");
INSERT INTO mbu_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Dǝm ngga, ɓwe nǝ̀ yinǝ akutumurǝm ɓari, ko akutugangyi ɓari, kǝla mana ndanǝi nǝ̀ pà ka. Mwashat ka, nda ace pàgir ace cauɓikea, sǝ ɓè man ngga nda ace pàgir mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","A tongno-nong-tàruià nongŋo ka, dumǝna púp ɓwe nǝ̀ yinǝ agirnì aban pǝris ace lakban male, a bankutio aɓa Tara Ban-peri, a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Sǝ pǝris nǝ̀ twal mǝgam mǝno, mala pàgir mala mbwegìr ace kumcau, atārǝia andǝ mùrú olif mǝno banì mwashat aɓa gauwe tàrú mala du lita ka. Sǝ pǝris nǝ̀ loasǝia a kùli, ɓǝ̀ duk pàgir na mǝnana à loasǝi a kùli a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Sǝ pǝris nǝ̀ pwan-myal mǝgam mala pàgir mala mbwegìr ace kumcau. Pǝlǝa pǝris nǝ̀ ɗàrǝa aɓa kǝ nkila mala pàgir mala mbwegìr ace kumcau, sǝ nǝ̀ dwakǝɗi a gyare mburkiru mǝlì mala ɓwa mǝnana à kǝ lé ka, sǝ arǝ munabui mǝbure mǝlì, sǝ arǝ muna-kusǝi mǝbure mǝlì. ");
INSERT INTO mbu_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Pǝlǝa pǝris nǝ̀ ɗàrǝa aɓa mùrúnì, sǝ nǝ̀ solǝi a ɓabui mǝ'nggare, ");
INSERT INTO mbu_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","sǝ nǝ̀ tàu mùrú mana a ɓabui mǝ'nggare ka nǝ munabui mǝlì, sǝ nǝ̀ watsǝki kusǝ tongno-nong-ɓari a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Sǝ aɓa mùrú mana a ɓabui ka, pǝris nǝ̀ dwakǝɗi bǝti a gyare mburkiru mǝlì mala ɓwa mǝnana à kǝ lé ka, sǝ a munabui mǝbure mǝlì, sǝ a muna-kusǝi mǝbure mǝlì, arǝ abân mǝnana à dwakǝɗi nkila mala pàgir mala mbwegìr ace kumcau kam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Sǝ cili mùrú mana ueo a ɓabu pǝris ka, nǝ̀ solǝi a ɓamur ɓwa mǝnana à kǝ lé ka, ace shawuɗè a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sǝ pǝris ka nǝ̀ pa gìr'nkila nǝ akutugangyi ko akutumurǝm mǝno, mana atea ɓwê gandǝ pa ka; ");
INSERT INTO mbu_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","mwashat ka, nda ace pàgir ace cauɓikea, sǝ ɓè ka, nda ace pàgir mala pisǝe kǝring, atārǝia andǝ pàgir mala mǝsǝsa. Pǝlǝa pǝris nǝ̀ shawuɗi ɓwa mǝnana à kǝ lé ka, a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Mǝnia ka nda nggurcau ace ɓwa mana kat ndanǝ kwánó nggû, sǝ kume male bik mana nǝ̀ gandǝ yinǝ apagir ace lakban male raka.>> ");
INSERT INTO mbu_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yahweh banggi Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","<<Lang wun nǝ̀ kùtí aɓa nzali Kan'ana, mǝnana ǝn nggǝ pà wun ɓǝ̀ duk girkuma ma'wun, sǝ ǝn tsǝk kwàpì mala kwánó nggû a ɓè ɓala aɓa nzali girkuma ma'wun ngga, ");
INSERT INTO mbu_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","dumǝna púp mǝtala ɓale nǝ̀ nggá banggi pǝris, ama, <Ən sǝni kǝla kwàpì ka nda kam a ɓala mem.> ");
INSERT INTO mbu_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sǝ kaniama pǝris nǝ̀ ká ace pelǝki kwanè ka, dumǝna púp nǝ̀ tsǝa ama ɓǝà pusǝki agir mǝnana a ɓale kat ka a nza, ace mǝnana ɓǝà kǝa tunǝî koman kat a ɓalanǐ mǝɓeami ɗàng. Anzǝm mǝno ka pǝris nǝ̀ ká ace sǝn ɓale. ");
INSERT INTO mbu_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Pǝris nǝ̀ kutio nǝ̀ pelǝki kwàpì mana arǝ abumkurǝm ngga. Ɓǝ̀ abân mǝnana à kwàpì arǝ bumkurǝm ngga à lǝmdǝ mùrì mǝpwale ko mǝbangŋe, sǝ ɓǝ̀ pǝris sǝni ama kwàpì ka ndarǝ li aɓa bumkurǝm ngga, ");
INSERT INTO mbu_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","pǝris nǝ̀ puro a nza a kunɓala, sǝ nǝ̀ gìr kun mǝno yì ɓala ka, ba nongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A tongno-nong-ɓaria pwari ka, pǝris nǝ̀ yiu ɗǝm nǝ̀ pelǝki ɓá mǝno yì ɓala ka. Sǝ ɓǝ̀ kwane akinaban arǝ abumkurǝm ngga, ");
INSERT INTO mbu_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","pǝris nǝ̀ tsǝa ama atali mana à ɓangŋaɓa nǝia, sǝ ado ka à ndanǝ kwánó arǝia ka, ɓǝà pusǝkia; à nǝ̀ sukkia a ban mǝɓeamî anzǝm la. ");
INSERT INTO mbu_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Sǝ pǝris nǝ̀ tsǝa, à nǝ̀ konggi rǝ abumkurǝm kat, sǝ tú mana à konggi ka, à nǝ̀ ngga solǝi a ban mǝɓeamî anzǝm la. ");
INSERT INTO mbu_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Pǝlǝa à nǝ̀ twal aɓea atali à nǝ̀ oasǝkia a kunì amǝno à pusǝkia ka, sǝ à nǝ̀ tasǝ abumkurǝmì nǝ bǝsa biɗǝman. ");
INSERT INTO mbu_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","<<Sǝ ɓǝ̀ kwàpì mǝno mana yikinǝ kwánó ka, nyare pusǝrǝi ɗǝm a ɓale, anzǝm mana à pusǝkina atali mana à ndanǝ kwánó arǝia, sǝ à konggina abumkurǝmnì, à tasǝna rǝia ka, ");
INSERT INTO mbu_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","pǝris nǝ̀ ká, nǝ̀ sǝni ɗǝm pepe; sǝ ɓǝ̀ kwàpì akinaban a ɓale ka, kwàpì mala yinǝ kwánó nggû mǝɓinǝ malâ na; gìr'ɓeami na. ");
INSERT INTO mbu_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Dumǝna púp ɓale ka, à nǝ̀ arki, sǝ atali male andǝ anggun male, andǝ tú male ka, à nǝ̀ pwania kat, à nǝ̀ umnǝia anzǝm la, a ban mǝɓeamî. ");
INSERT INTO mbu_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Sǝ koyana kat, mana kúti a mǝno yì ɓala, anzǝm mǝnana à girǝna kún ɓale ka, ɓwê nǝ̀ duk mǝɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ɓwa mana kat nongŋo a ɓale, ko li girlina kam ngga, dumǝna púp nǝ̀ lakki agir'nggūrǝì. ");
INSERT INTO mbu_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","<<Sǝama, ɓǝ̀ pǝris yiu, sǝ sǝni ama kwane mesǝe akiban a ɓale ɗang, anzǝm tasǝ abumkurǝmì ka, pǝris nǝ̀ bang bwāng ama ɓale ka ɓoarnansari; kwane umǝna. ");
INSERT INTO mbu_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Sǝ ace lak ɓale ka, pǝris nǝ̀ twal amuna-nyal ɓari, andǝ munagara nggun-seda, andǝ bugir mǝbangŋe andǝ bondo-hisop, ");
INSERT INTO mbu_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","sǝ nǝ̀ pwan-myal mwashat atà amuna-nyal mǝno ka amúr mùr mgbeɗe aɓa nkwaring-dǝɓang. ");
INSERT INTO mbu_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Pǝlǝa nǝ̀ twal munagara nggun-seda andǝ bondo-hisop andǝ bugir mǝbangŋe, atārǝia andǝ muna-nyal mana nǝ yilǝmu ka, sǝ nǝ̀ oasǝia aɓa nkila mala muna-nyal mana à pwan-myali ka, sǝ aɓa mùr mgbeɗe mǝno ka, sǝ nǝ̀ watsǝkì ɓale kusǝ tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Anggo sǝ pǝris nǝ̀ lak ɓale nǝ nkila mala muna-nyal, sǝ nǝ̀ mùr mgbeɗe, sǝ nǝ muna-nyal mana nǝ yilǝmu ka, sǝ nǝ munagara nggun-seda, andǝ bondo-hisop, andǝ bugir mǝbangŋe. ");
INSERT INTO mbu_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Pǝlǝa pǝris nǝ̀ nying muna-nyal ɓǝ̀ o ɓǝ̀ purî ɓá nggea-là aban ká a bondo. Anggo sǝ pǝris nǝ̀ shawuɗi ɓala mǝno, sǝ nǝ̀ ɓoarnsari.>> ");
INSERT INTO mbu_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Mǝnia ka nda nggurcau amur cau mala koya kwánó nggû: ace nzwari, ");
INSERT INTO mbu_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ace sa mala kwàpì arǝ gìr'nggūrǝu ko arǝ ɓala, ");
INSERT INTO mbu_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","sǝ ace gìr-mwara, ko bàndà, ko terìkì mala nggū, ");
INSERT INTO mbu_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ace kasǝcau ama gìr ko ɓwa ka mǝɓeami na ko ɓoarnansari. Mǝnia ka nda nggurcau amur kwánó nggū andǝ kwàpì. ");
INSERT INTO mbu_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yahweh bangcau nǝ Musa andǝ Haruna, ama, ");
INSERT INTO mbu_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","<<Ne amǝ Isǝrayila ama, Lang ɓwa na nǝ kwánó arǝì sǝ ɓate kǝ pur mùrgìr ka, puro mala mùrgìr male ka gìrɓeami na. ");
INSERT INTO mbu_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Sǝ mǝnia ka nda nggurcau amur do-ɓeami atàcau mala puro mala mùrgìr male: ko ɓate kǝ pur mùrgìr, ko puro mala mùrgìr male gìr kún ɓate, mǝno ka do-ɓeami na a baní. ");
INSERT INTO mbu_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","<<Koya gìr-nongŋo na mana ɓwa mǝno mùrgìr kǝ puro a ɓate, sǝ nongŋo amurí ka, gìr-nongŋê nǝ̀ duk mǝɓeami. Yale gìr mana kat ɓwê do amurí ka, nǝ̀ duk mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Sǝ ɓwa mana kat je gìr-nongŋo male ka, dumǝna púp ɓwe nǝ̀ lak agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Sǝ koya ɓwa na kat do amur koyagir na mǝno yì mǝ pùr mùrgìr a ɓate duk kam ngga, dumǝna púp ɓwê nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ɓwa mana kat je rǝ ɓwa mǝnana ndanǝ puro mala mùrgìr a ɓate ka, dumǝna púp ɓwê nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Sǝ ɓǝ̀ mǝnia yì ɓwa mana ndanǝ puro mala mùrgìr a ɓate, sǝ tau'ntāra arǝ aɓwana mana amǝɓoarnsari na ka, dumǝna púp à nǝ̀ lakki agir'nggūrǝia, sǝ à nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka à nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Sǝ koya gìr-do-anzǝm girkusǝu mana mǝnia yì mǝ pùr mùrgìr a ɓate do amurí ka, yì gìr-do-anzǝm girkusǝu ka nǝ̀ duk mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Sǝ ɓwa mana kat je koyagir mana mǝnia yì ɓwa dumǝna amurí ka, nǝ̀ duk mǝɓeami ba pwarikpǝra. Sǝ ɓwa mana kat twal mǝno yì gir ka, dumǝna púp ɓwê nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ɓǝ̀ ɓwa mǝnana ndanǝ puro mala mùrgìr a ɓate ka je ɓeɓwa sǝ ak tadǝmba shèlǝ́ abui a mùr raka, mǝnia yì ɓwa à je ka dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nda aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Sǝ ɓǝ̀ ɓwa mana mùrgìr kǝ puro a ɓate ka je koya nkwaring dǝɓang ngga, dumǝna púp à nǝ̀ arki nkwaringnì, sǝ koya kwar mana à shàrrì nǝ nggun sǝ ɓwê je ka, dumǝna púp à nǝ̀ shèlǝì a mùr. ");
INSERT INTO mbu_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","<<Lang ɓwa mǝnana mùrgìr kǝ puro a ɓate ka kumǝna lakban arǝ puro mala mùrgìr a ɓate ka, nǝ̀ twal anongŋo tongno-nong-ɓari mala lakban male, nǝ̀ kùndǝô, pǝlǝa nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo aɓa mùr mgbeɗe, sǝ yi ka nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sǝ a tongno-nong-tàruià nongŋo ka, dumǝna púp nǝ̀ yinǝ akutugangyi ɓari ko akutumurǝm ɓari a ɓadǝm Yahweh, a bankutio aɓa Tara Ban-peri, sǝ nǝ̀ pè pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Pǝlǝa pǝris nǝ̀ pàɓoro nǝia; mwashat ka mala pàgir ace cauɓikea na, sǝ man mwashat ka, mala pàgir mala pisǝe kǝring na. Sǝ pǝris nǝ̀ shawuɗi ɓwê a ɓadǝm Yahweh, ace puro mala mùrgìr male a ɓate. ");
INSERT INTO mbu_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","<<Ɓǝ̀ ɓwabura sukkimùr arǝì ka, dumǝna púp nǝ̀ lak rǝì kat a mùr sǝ kat andǝ amani ka nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Sǝ koya daura andǝ koya nggūgir mana mùrtaunî sùr amurí ka dumǝna púp à nǝ̀ lé nǝ mùr, sǝ kat andǝ amani ka, nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ɓǝ̀ ɓwabura nongnǝ ɓwama sǝ sukkimùr ka, dumǝna púp yia kǝm ngga à nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka, à nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","<<Lang mùrgìr kǝ puro a ɓata ɓwama, sǝ mùrgìrnî ka nkila na ka, dumǝna púp nǝ̀ ueo aɓa pǝndǝkya mala bumkwana male nongŋo tongno-nong-ɓari, sǝ ɓwa mǝnana kat je ɓwame ka, nǝ̀ duk mǝɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Gìr mana kat ɓwame nongŋo amurí aɓa pǝndǝkya mala bumkwana male ka, gìrnî nǝ̀ duk mǝɓeami. Ɗǝm ngga gìr mǝnana kat yì ka do amurí ka nǝ̀ duk gìr'ɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","<<Sǝ ɓwa mǝnana kat je gìr-nongŋo mala ɓwame ka, dumǝna púp ɓwê nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka ɓwê nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Sǝ ɓwa mǝnana kat je koyagir mana mǝnia yì ɓwama do amurí ka, dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ko ɓǝ̀ gìr-nongŋo na, andǝ koyagir nani mǝnana ɓwame dumǝna amurí, sǝ ɓwa je ka, ɓwê nǝ̀ duk mǝɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Sǝ ɓǝ̀ koya ɓwabura nongnǝ man yì ɓwama, sǝ nkila mala bumkwana mala ɓwame sulǝ arǝì ka, ɓwabure nǝ̀ duk mǝɓeami anongŋo tongno-nong-ɓari. Sǝ koya gìr-nongŋo mǝnana ɓwabure nong amurí ka nǝ̀ duk gìr'ɓeami. ");
INSERT INTO mbu_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","<<Ɓǝ̀ nkila kǝ ɓunno arǝ ɓwama sǝ twal anongŋo pas, sǝ pà aɓa pǝndǝkya bumkwana male raka, ko ana raka, ɓǝ̀ ɓunno mala nkila yàlî anongŋo mala pǝndǝkya bumkwana male ka, dumǝna púp nǝ̀ lidǝmba aɓa do-ɓeami aɓalǝ anongŋo mala ɓunno mala nkila mǝno ka kat. Yì ka, nǝ̀ duk mǝɓeami kǝla mana mǝɓeami na aɓa pǝndǝkya bumkwana male ka. ");
INSERT INTO mbu_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Koya gìr-nongŋo mǝnana ɓwame nong amurí, aɓalǝ anongŋo mala ɓunno mala nkila male ka, nǝ̀ dupi wi kǝla gìr-nongŋo mala pǝndǝkya bumkwana male. Sǝ komana kat do amurí ka nǝ̀ duk mǝɓeamî, kǝla mana nda aɓa do-ɓeami mala pǝndǝkya bumkwana male ka. ");
INSERT INTO mbu_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ɓwa mǝnana kat je amǝnia yì agir ka, nǝ̀ duk mǝɓeamî, sǝ dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ɓǝ̀ ɓwame kumǝna lakban arǝ ɓunno mala nkila male ka, nǝ̀ twal anongŋo tongno-nong-ɓari nǝ̀ kùndǝô, sǝ anzǝm mǝno ka nǝ̀ ɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sǝ a tongno-nong-tàruià nongŋo ka, dumǝna púp nǝ̀ twal akutugangyi ɓari ko akutumurǝm ɓari sǝ nǝ̀ yinǝia aban pǝris a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Pǝlǝa pǝris nǝ̀ pàɓoro nǝia; mwashat ka ace pàgir mala gǝshi cauɓikea, sǝ man mwashat ka, ace pàgir mala pisǝe kǝring. Sǝ pǝris nǝ̀ shawuɗi ɓwame a ɓadǝm Yahweh, ace ɓunno mala nkila ɓeami male. ");
INSERT INTO mbu_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","<<Anggo sǝ awu nǝ nunkir amǝ Isǝrayila ɓǝà yál rǝia arǝ do-ɓeami malea, ɓǝ̀ ana raka à nǝ̀ wú aɓa do-ɓeami malea, acemǝnana do-ɓeami malea nǝ̀ pǝndǝki Taragula mem mana nda aɓalǝia ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Mǝnia ka nda nggurcau ace ɓwabura mǝnana mùrgìr kǝ puro a ɓate, sǝ ace ɓwabura mana sukkimùr arǝì, mǝnana tsǝì pǝlǝ mǝɓeami ka; ");
INSERT INTO mbu_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ɗǝm ngga nda ace ɓwama mana kum rǝkwana nǝ bumkwana male ka, sǝ ace koyan, ɓwabura ko ɓwama, mana mùrgìr kǝ puro a ɓate ka, sǝ ace ɓwabura mǝnana nongnǝ ɓwama mana mǝɓeami na ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Anzǝm lú mala amuna-burana ɓari mala Haruna, mana à wǔ acemǝnana à gbàshì ban Yahweh sǝ Yahweh wal-luia ka, ");
INSERT INTO mbu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yahweh nacau nǝ Musa ama, <<Banggi mǝ'eambo Haruna ama ɓǝkǝa na ama nǝ̀ nggǝ yiu ɓàɓà ace kùtí aɓa ban mǝfele mana à gbàrì nǝ lagìr, a ɓadǝm buno sǝntǝ̀r mǝnana amur Akwati ka, ɗàng, ace mǝnana ɓǝkǝa wù raka. Mǝnia ka nda acemǝnana mǝ nǝ lǝmdǝ rǝàm aɓa pǝrɓang amur buno sǝntǝ̀r. ");
INSERT INTO mbu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","<<Ani sǝ Haruna nǝ̀ kùtí aɓa ban mǝfele: Nǝ̀ yinǝ jamnda a domwan ace pàgir ace cauɓikea, andǝ gam ace pàgir mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Nǝ̀ sussǝo a mùr sǝ nǝ̀ oasǝ amǝnia yì adaura mǝfele ka; nǝ̀ oasǝ shiwan male mala nggubyau linǝn atè, nǝ̀ túr daura-ɓaɓalǝu mǝlime mala linǝn arǝì, nǝ̀ kùr bugìr mārǝ́ taɓunu mala linǝn, sǝ nǝ̀ mārǝ́ nggubyau mbuɓi múrû mala linǝn a múrí. ");
INSERT INTO mbu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Sǝ nǝ̀ ak agbato ɓari a bu ɓinala amǝ Isǝrayila, ace pàgir ace cauɓikea, sǝ gam mwashat ace pàgir mala pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","<<Haruna nǝ̀ pà gìr'nkila nǝ jamnda mǝnia ka ɓǝ̀ duk pàgir ace cauɓikea mala ɓamúrì, nǝ̀ shawuɗi ɓamúrì sǝ nǝ̀ shawuɗi ɓala male. ");
INSERT INTO mbu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Pǝlǝa nǝ̀ twal agbato mǝnia ɓari ka, nǝ̀ tamsǝia a ɓadǝm Yahweh a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Sǝ Haruna nǝ̀ bwal-shishar amur agbato man ɓari ka ace súrǝ̀ mǝye na ateà nda ace Yahweh sǝ mǝye na ace Azazel. ");
INSERT INTO mbu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haruna nǝ̀ yinǝ gbato mana bwal-shishar lǝmdǝ ama nda ace Yahweh ka, sǝ nǝ̀ pà gìr'nkila nǝi ɓǝ̀ duk pàgir ace cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Sǝ gbato mǝnana bwal-shishar lǝmdǝ ama nda ace Azazel ka, à nǝ̀ yinǝi andǝamǝsǝì a ɓadǝm Yahweh ace shawuɗiban amurí, ace mǝnana à nǝ̀ tasǝte ɓǝ̀ o a njenza a Azazel ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","<<Haruna nǝ̀ pà gìr'nkila nǝ jamnda mǝnia ka ɓǝ̀ duk pàgir ace cauɓikea ace ɓamúrì, nǝ̀ shawuɗi ɓamúrì, sǝ nǝ̀ shawuɗi ɓala male. Nǝ̀ pwan-myal jamnda mǝnia ka ɓǝ̀ duk pàgir ace cauɓikea ace ɓamúrì. ");
INSERT INTO mbu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Sǝ nǝ̀ twal tasau-bǝsa, nǝ̀ lùmsǝì nǝ nkalang bǝsa mana ɗàrǝ́ atà gyangŋan mana came a ɓadǝm Yahweh ka. Sǝ nǝ̀ ɗàrǝ́ muku-gìr loasǝ yele mǝ'rǝmɓoarne mǝnana à goe lǝkǝt-lǝkǝt ka, ɓǝ̀ lùmsǝ ɓabui ɓari, sǝ nǝ̀ kùtí nǝi aɓa Ban Nggea Mǝfele anzǝm lagir. ");
INSERT INTO mbu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Yì ka nǝ̀ so mǝnia yì muku-gìr loasǝ yele mǝ'rǝmɓoarne ka a bǝsa a ɓadǝm Yahweh, ace mǝnana ɓǝ̀ pǝrɓang mala yele muku-gìr mǝ'rǝmɓoarne ɓǝ̀ gìr múr buno sǝntǝ̀r mana amur Akwati mala Acau-nakûn ngga. Ɓǝ̀ pè anggo raka nǝ̀ wú àkǝ̀ banì. ");
INSERT INTO mbu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Sǝ nǝ̀ ɗàrǝa aɓa nkila mala jamnda, nǝ̀ watsǝki nǝ munabuì amúr buno sǝntǝ̀r, a buì mǝnana sǝn njar-takuli ka; sǝ nǝ̀ ɗàrǝ́ nkile ɗǝm nǝ̀ watsǝki nǝ munabuì a ɓadǝm buno sǝntǝ̀r kusǝ tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","<<Pǝlǝa nǝ̀ pwan-myal gbato mala pàgir ace acauɓikea mana nda ace aɓwana ka, sǝ nǝ̀ kùtí nǝ nkile aɓa Ban Nggea Mǝfele anzǝm lagìr. Akano ka nǝ̀ ɗàrǝa aɓa nkile sǝ nǝ̀ watsǝki amur buno sǝntǝ̀r sǝ a ɓadǝmbi, kǝla mǝnana pàngnǝ nkila mala jamnda ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Anggo sǝ nǝ̀ shawuɗi Ban Mǝfele, atàcau mala do-ɓeami mala amǝ Isǝrayila, sǝ ace akpakpak andǝ acauɓikea malea kat. Anggo gbal sǝ nǝ̀ pǎ ace Tara Ban-peri, mǝnana ndakam aɓalǝia aɓa do-ɓeami malea ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kǝɓwa pà nǝ̀ pàk kàm aɓa Tara Ban-peri twal a bu-pwari mana Haruna kùtí nǝi ace shawuɗiban aɓa Ban Nggea Mǝfele ka ɗàng ba puro male; she ɓǝ̀ malǝna shawuɗiban ace ɓamúrì, sǝ ace ɓala male, sǝ ace ɓwabundǝa mala Isǝrayila kat mana ram ngga. ");
INSERT INTO mbu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Sǝ nǝ̀ puro aban gyangŋan mana nda a ɓadǝm Yahweh ka, nǝ̀ shawuɗi, sǝ nǝ̀ ɗàrǝ́ aɓa nkila mala jamnda, sǝ aɓa nkila mala gbato mǝno ka, nǝ̀ hasǝki arǝ anjawe mala gyangŋan a koya buban. ");
INSERT INTO mbu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Sǝ nǝ̀ ɗàrǝ́ aɓa nkila mǝno, nǝ̀ watsǝki amur gyangŋan nǝ munabui kusǝ tongno-nong-ɓari; anggo ka nǝ̀ lé sǝ nǝ̀ tàrì arǝ ado-ɓeami mala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","<<Anzǝm mǝnana Haruna malǝna shawuɗiban ace Ban Mǝfele, andǝ Tara Ban-peri, andǝ gyangŋan ngga, nǝ̀ yinǝ gbato mǝnana nǝyilǝmu ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Sǝ yì ka nǝ̀ nongsǝ abui kǝm a ɓamúr gbato man nǝyilǝmu ka, sǝ nǝ̀ bang aɓealɓikea mala amǝ Isǝrayila kat amurí, andǝ akpakpak malea kat, andǝ acauɓikea malea kat. Anggo sǝ nǝ̀ tsǝk acauɓikea mala amǝ Isǝrayila a ɓamúr gbato man, sǝ nǝ̀ tasǝte ɓǝ̀ o, sǝ ɓeɓwa mǝnana à twali ace túrè ka, nǝ̀ pǝrte aban ká a njenza. ");
INSERT INTO mbu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Gbato man nǝ̀ twal twalo mala aɓealɓikea mala amǝ Isǝrayila kat a múrí, nǝ̀ kánǝia kuko a ban mǝnana là pà kàm tù raka, sǝ ɓwa mǝno ka nǝ̀ ɗeki ɓǝ̀ o atàrǝì a bondo. ");
INSERT INTO mbu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","<<Pǝlǝa Haruna nǝ̀ kùtí aɓa Tara Ban-peri, nǝ̀ swár adaura nggubyau linǝn mǝnana oasǝ arǝì lang kúti a Ban Mǝfele ka, sǝ nǝ̀ ɗekia kano. ");
INSERT INTO mbu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Sǝ yi ka nǝ̀ sussǝo nǝ mur a ban mǝfele, sǝ nǝ̀ oasǝ agir-nggūrǝu male; pǝlǝa nǝ̀ puro sǝ nǝ̀ pà pàgir mala pisǝe kǝring ace ɓamúrì, sǝ nǝ̀ pà mana nda ace aɓwana ka; nǝ̀ shawuɗì ɓamúrì sǝ nǝ̀ shawuɗì aɓwana. ");
INSERT INTO mbu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Sǝ nǝ̀ pisǝ mùrú-nyama mala pàgir mala pisǝe kǝring amur gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Sǝ ɓwa mǝno nying gbato mǝno ɓǝ̀ o aban Azazel ka nǝ̀ lákkí agir'nggūrǝì, sǝ nǝ̀ sussǝ nǝ mùr, sǝ anzǝm mǝno ka nǝ̀ gandǝ yiu aɓa kàttì. ");
INSERT INTO mbu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Sǝ jamnda andǝ gbato mana à pàna gìr'nkila nǝia kǝla pàgir ace cauɓikea, mǝnana nkilea ka, à yinǝi ace shawuɗiban aɓa Ban Mǝfele ka, à nǝ̀ kánǝia anzǝm kàttì. Nyamia, andǝ nggūia, andǝ ciutea ka, à nǝ̀ pisǝia nǝ bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Sǝ ɓwa mǝnana pisǝia ka, nǝ̀ lak agir'nggūrǝì, sǝ nǝ̀ sussǝ nǝ mùr, sǝ nǝnzǝ́mò ka nǝ̀ gandǝ kúti aɓa kàttì. ");
INSERT INTO mbu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","<<Mǝnia ka nǝ̀ duk nggurcau aban wun tàtǝ́k, ama a lumia pwari mala tongno-nong-ɓaria zongŋo ka, dumǝna púp ama amǝ Isǝrayila andǝ abǝri mana à ndanǝdo aɓalǝia ka, à nǝ̀ gilmùr sǝ à pà nǝ̀ pàk kǝ túró ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","A man yì pwari ka, à nǝ̀ shawuɗi wun ace lak wun. À nǝ̀ lak wun arǝ acauɓikea ma'wun kat ace mǝnana ɓǝ̀ wu ɓoarnsari a ɓadǝm Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Mǝnia yì pwari ka, pwari mala usǝlǝo na kat-kat aban wun kǝla pwari Sabbat, sǝ aɓalǝi ka, wun nǝ̀ ginǝì ɓamur rǝ wun agir; nggurcau na tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Sǝ pǝris mǝnana à ɗārǝi sǝ à tàrì ɓǝ̀ duk pǝris a kunì tárrí ka, nda mǝnana nǝ̀ shawuɗiban ngga. Nǝ̀ oasǝ adaura mǝfele mala nggubyau linǝn arǝì. ");
INSERT INTO mbu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Nǝ̀ shawuɗi Ban Nggea Mǝfele, andǝ Tara Ban-peri, andǝ gyangŋan, sǝ nǝ̀ shawuɗi apǝris andǝ ɓwabundǝa mana ram ngga kat. ");
INSERT INTO mbu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Mǝnia ka nǝ̀ duk nggurcau ace wun tàtǝ́k, ama à nǝ̀ shawuɗi amǝ Isǝrayila kusǝ mwashat a pǝlǝa, atàcau mala acauɓikea malea kat.>> Sǝ Haruna pè kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","<<Banggi Haruna andǝ amuna-burana male, andǝ amǝ Isǝrayila kat, ama, Mǝnia ka nda nzongcau mana Yahweh pà ka. ");
INSERT INTO mbu_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ɓǝ̀ kǝɓwa a tàu mala Isǝrayila wal ndǎ, ko nzur, ko mbulpǝndǝa aɓa kàttì, ko pwan-myali anzǝm kàttì, ");
INSERT INTO mbu_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","sǝ yinǝi a bankutio aɓa Tara Ban-peri nǝ̀ pà ɓoro nǝi abanam Yahweh, a ɓadǝm Taragula mem Yahweh raka, bafe mala sukki'nkila nǝ̀ sulǝo amur ɓwê. Man yi ɓwa ka sukkina nkila, sǝ ɓwê ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Tǝ́r mǝnia yì nzongcau ka nda mǝnana ama, agir'nkila mala amǝ Isǝrayila mana à kǝ̀ pana gìr'nkila nǝia a patal ka, ɓǝà yinǝia abanam Yahweh, aban pǝris a bankutio aɓa Tara Ban-peri, sǝ ɓǝà pà gìr'nkila nǝia kǝla agir'nkila mala apagir ace dotarǝu abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sǝ pǝris nǝ̀ tàkki nkile amur gyangŋan mem Yahweh a bankutio aɓa Tara Ban-peri, sǝ nǝ̀ pisǝ mùruí ace pà rǝmban mǝɓoarne mana nǝ̀ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Anggo ka, à pà nǝ̀ nyare à nǝ̀ pà agir'nkila malea ɗǝm aban akukwar-mbul ɗàng, akukwar-mbul mǝnana à kutina aɓa nongginǝ-rǝarǝu andǝia ka. Mǝnia ka nǝ̀ duk nggurcau tàtǝ́k acea arǝ ado'nza malea kat. ");
INSERT INTO mbu_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","<<Sǝ wu nea wia ama, koya ɓwa a tàu mala Isǝrayila, ko atà abǝri mǝnana à ndanǝdo aɓalǝia, mǝnana pàgir mala pisǝe kǝring, ko pà gìr'nkila, ");
INSERT INTO mbu_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","sǝ yinǝi a bankutio aɓa Tara Ban-peri, ace pagìr nǝi abanam Yahweh raka, man yì ɓwa ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","<<Ɓǝ̀ kǝɓwa a tàu mala Isǝrayila, ko atà abǝri mǝnana à ndanǝdo aɓalǝia, lì koya nkila ka, Mim Yahweh ka, mǝ nǝ twalî man yì ɓwa ka ɓamǝsǝam, sǝ à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Mǝnia ka nda acemǝnana yilǝmi koya gìr mana ndanǝ yilǝmu ka, nda aɓa nkila. Sǝ ǝn pana wun nkila mala agirkusǝu ace shawuɗi ayilǝmi wun amur gyangŋan. Nkila ka yilǝmu na, sǝ kǝ lak cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Acemani ka, ǝn bángŋǝ́nì amǝ Isǝrayila nǝma, kǝɓwa pà kàm atà wun, ko ɓekǝ bǝri mana ndanǝdo aɓalǝ wun, mana nǝ̀ lì nkila ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","<<Sǝ koya ɓwa Isǝrayila, ko bǝri mana ndanǝdo aɓalǝia, mǝnana pur ɓombo, sǝ bwal nyama ko nyal, mǝnana mǝɓoarne na à nǝ̀ lì ka, dumǝna púp nǝ̀ ɗārǝ́ nkile sǝ nǝ̀ gìrì nǝ nzali. ");
INSERT INTO mbu_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Yilǝmi koya gìr mana ndanǝ yilǝmu ka, nda aɓa nkile: nkile nda yilǝmi. Acemani ka, ǝn bángŋǝ́nì amǝ Isǝrayila nǝma, Pà wu nǝ̀ lì nkila mala ɓekǝ giryilǝmu ɗang, acemǝnana yilǝmi koya giryilǝmu ka, nda nkile. Ɓwa mǝnana kat lì nkila ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Sǝ koya ɓwa Isǝrayila ko bǝri, mǝnana lì girkusǝu mǝnana wuna atàrǝì ko anyamɓikea wal-lui ka, dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo a mùr, sǝ kat andǝ amani ka, nda aɓa do-ɓeami ba kpa mala pwari. ");
INSERT INTO mbu_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Sǝ ɓǝ̀ lakkia ɗàng, ko sussǝ rǝì raka, nǝ̀ twal twalo mala ɓealɓikea male.>> ");
INSERT INTO mbu_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","<<Banggi amǝ Isǝrayila ama, <Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Pà wun nǝ̀ pàk kǝla mǝnana à pàkkiyi a nzali Masar, ban mana wu duk kam ɗiɗyal ka ɗàng, sǝ pà wun nǝ̀ pàk kǝla mǝnana à pàkkiyi a nzali Kan'ana, mǝnana ado mǝ nǝ kánǝ wun kàm ngga ɗàng. Pà wun nǝ̀ kpata akúncau malea ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Wun ngga, wun nǝ̀ kpata anzongcau mem sǝ wun nǝ̀ bwal anê mem. Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Wu bwal anê andǝ anzongcau mem; ɓǝ̀ ɓwa kǝ peǎ ka, nǝ̀ kum auwa nǝ bania. Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","<< <Kǝɓwa atà wun ɓǝ̀kǝa gbàshìban ɓekǝ ɓǝla male ama nǝ̀ nongnǝi ɗàng. Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Kǝa pè tárró kǝsǝkya nǝ nongnǝ nggo ɗàng; yì ka nggo na, acemani ka, a pà wunǝ pe wi kǝsǝkya ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","A pà wunǝ nongnǝ mālá tárró ɗàng; anggo ka a panì tárró kǝsǝkya. ");
INSERT INTO mbu_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","A pà wunǝ nongnǝ mǝ'nggauleo, nsarile tárró ko nsarile nggò ɗàng, ko yì ka gul a ɓala ma'wun ko a ɓè ɓala. ");
INSERT INTO mbu_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","A pà wunǝ nongnǝ nsari mala muna-ɓwabura mô ko nsari mala muna-ɓwama mô ɗàng, acemǝnana yià ka amǝɓala mò na. ");
INSERT INTO mbu_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","A pà wunǝ nongnǝ nsari mala mālá tárró, mana gul a ɓala mala tárró ka ɗàng, acemǝnana yì ka mǝ'nggauleo na. ");
INSERT INTO mbu_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","A pà wunǝ nongnǝ mǝ'nggaula tárró ɗàng; yì ka ɓǝla mala tárró na. ");
INSERT INTO mbu_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","A pà wunǝ nongnǝ mǝ'nggaula nggò ɗàng, acemǝnana yì ka ɓǝla mala nggò na. ");
INSERT INTO mbu_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","A pà wunǝ pe mǝ'eam tárró kǝsǝkya nǝ gbàshìban māmí ama awu nǝ nongnǝi ɗàng; yì ka nggò na. ");
INSERT INTO mbu_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","A pà wunǝ nongnǝ nkilo muna-ɓwama ɗàng; yì ka mālá munio na. ");
INSERT INTO mbu_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","A pà wunǝ nongnǝ mālá mǝ'eambo ɗàng, acemǝnana yì ka nda a ɓala mala mǝ'eambo. ");
INSERT INTO mbu_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","A pà wunǝ nongnǝ ɓwama andǝ muna-ɓwama male ɗàng; sǝ a pà nǝ al mǝkè muna-ɓwama ɗàng, acemǝnana yià ka aɓǝla na; pě mǝno anggo ka ɓealɓana na. ");
INSERT INTO mbu_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Sǝ a pà wunǝ twal ɓwama ɓǝ̀ duk ɓimama mala mǝ'eambi, a nǝ nongnǝi sǝ yì mǝ'eambi ka ndakam nǝyilǝmi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","<< <A pà wunǝ nongnǝ ɓwama sǝ mana nda aɓa pǝndǝkya mala bumkwana male ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Sǝ a pà wunǝ nongnǝ mālá ɓio mǝ'murkala, wu pǝndǝki ɓamurò nǝi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","<< <A pà wunǝ pa komǝye na atà amunio kǝla pagìr aban Molek ɗàng. Kǝa pǝndǝkice lullǝ Ɓakuli mô ɗàng; Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ɓwabura andǝ ɓwabura pa nǝ̀ nongnǝ rǝarǝia kǝla mana ɓwabura nǝ̀ nongnǝ ɓwama ka ɗàng; mǝnia ka gìr'ɓeami na. ");
INSERT INTO mbu_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","A pà wunǝ nongnǝ girkusǝu, wu pǝndǝki ɓamúrò nǝi ɗàng, sǝ kǝ ɓwama ɓǝkǝa pà ɓamúrì aban girkusǝu ɓǝ̀ eauwi ɗàng; mǝno ka pǝlǝmúr-gìr na. ");
INSERT INTO mbu_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","<< <Wu kǝa pǝndǝki ɓamur rǝ wun nǝ kǝ mǝye atà pakkiagir mǝnia ka ɗàng, acemǝnana aɓwapǝndǝa mala anzali mǝnana ǝn nggǝ pǝria ɓǝà nyingga wun ban ngga, à pǝndǝkina ɓamuria nǝ pakki agir ɓeami mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Sǝ acemǝnana nzali kat pǝndǝkina ka, mǝ nǝ yinǝ ɓashi amur cauɓikea male, sǝ nzali ka nǝ̀ ukki aɓwana mǝnana aɓalǝi ka. ");
INSERT INTO mbu_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Sǝama wun ngga, wun nǝ̀ kpata anggurcau andǝ anê mem, sǝ pà wun nǝ̀ pàk komǝye atà amǝno yì agir ɓeami ka ɗàng, ko ɓwa mǝnana à ɓǝli ɓwa Isǝrayila na ko ɓwa kúnɗàngna na ka. ");
INSERT INTO mbu_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Aɓwana mǝnana à akdǝmba do a nzali mǝnana mǝ nǝ kánǝ wun kàm ngga, anggo sǝ à pàkki amǝno yì agir ɓeami kat ka, sǝ nzalinì pǝndǝkya). ");
INSERT INTO mbu_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Acemani ka, wu kǝa pǝndǝki nzalinì mǝnana nǝ̀ tsǝa nǝ̀ ukki wun kǝla mana ukki aɓwana mǝnana à ndanǝdo kàm ado ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ɓwa mǝnana kat pàk komǝye na atà agir'ɓeami mǝno ka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Acemani ka, wu bwal kwarkiru mem, wu kǝa kúti a pàk kǝɓè atà agirɓana mala akúncau malea mǝnana à pàkkiyi a ɓadǝm wun ngga ɗàng, sǝ wu kǝa eare wu pǝndǝki ɓamur rǝ wun nǝia ɗàng: Mǝ nda Yahweh Ɓakuli ma'wun.> >> ");
INSERT INTO mbu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","<<Banggi amǝ Isǝrayila kat a ɓinalea ama, <Dumǝna púp wun nǝ̀ dukdo mǝfele, acemǝnana Mim Yahweh Ɓakuli ma'wun ngga mǝ nda mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","<< <Koyan atà wun ngga nǝ̀ pà gulo aban nggé andǝ tárrí, sǝ wun nǝ̀ kpata nzongcau mala Pwari Sabbat, pwari usǝlǝo mem: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","<< <Cè wu pǝlǝa aban kpata ankúl, ko wu pàkkî ɓamur rǝ wun ɓekǝ ɓakuli mǝnana à tùllì nǝ bolo-ntùl ka ɗàng: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","<< <Lang wun nǝ̀ pà gìr'nkila mala apagir ace dotarǝu abanam Yahweh ka, wu pè pepè ace mǝnana ɓǝ̀ wu kum â aban Ɓakuli ka. ");
INSERT INTO mbu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Dumǝna púp ama mǝnia yì gìr'nkila ka, wun nǝ̀ lì a pwari mǝnana à pànàɓoro nǝi ka, ko ɓè pwari mana kpate ka, sǝ ɓǝ̀ ɓekǝ gìr ueo aɓalǝi, bà tàruià pwari ka, dumǝna púp wun nǝ̀ pisǝì kǝring a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ɓǝ̀ wu lì ɓekǝ bare gìr'nkilè a tàruià pwari ka, pǝndǝkina; pà nǝ̀ kum â aban Ɓakuli ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ɓwa mǝnana kat lì ka, bafe mala cauɓikea male nǝ̀ do amurí, acemǝnana pǝndǝkinace gìr mǝnana à pànì abanam, Mim Yahweh ka, sǝ mǝno yì ɓwa ka à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","<< <Lang wun nǝ̀ pwàn agirɓaban mǝnana à ɓǝl aɓa nzali ma'wun ngga, wu kǝa pwàn gìr kat-kat ɓǝ̀ kya bwal masǝlǝata kún aɓaban ma'wun ɗàng, sǝ pà wu nǝ̀ nyar aban ká alta ɓakurikuri anzǝm pwan-gìrɓaban ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Pà wu nǝ̀ tùki aɓǝlanggun anap kat arǝ aɓaban mala anggun-anap ma'wun ɗàng, sǝ pà wu nǝ̀ tàrki amǝnana à sukki a nzali ka ɗàng; wu nyia ace amǝ'tǝ̀r andǝ abǝri: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","<< <Pà wu nǝ̀ iun'i ɗang; pà wu nǝ̀ pàkgìr aɓa ɓosǝkiban ɗang; pà wu nǝ̀ ne arǝwun nyir ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Pà wu nǝ̀ kángìr nǝ lullǝàm aɓa nyir ɗang, mǝnana nǝ̀ tsǝa wun nǝ̀ pǝndǝkice lullǝ Ɓakuli ma'wun ngga: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","<< <A pà wu nǝ tǝpǝri ɓio mǝ'murkala, ko awu nǝ ak gìr male arǝì ɗàng. Tangnakusǝu mala amǝ'túró-boalo ka, a pà wu nǝ bwali a buo aɓa dù kat bà kwaro mala ban ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","A pà wu nǝ sáng mǝkir'ara, ko awu nǝ tsǝk gìr-annda a ɓadǝm nte ɗang. Ɓanggî Ɓakuli mô: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","<< <Dum nǝ ɓafo andǝ kpata mǝsǝcau aɓa pàk ɓashi: a pà wunǝ lǝmdǝ tàrbân arǝ mǝ'tǝ̀r, ko pagulo arǝ mǝkume ɗàng. Dumǝna púp awu nǝ pàk ɓashi mala aɓio aɓwana mala nzali ma'wun nǝ ɓealɓoarna. ");
INSERT INTO mbu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","A pà wunǝ duk ɓwa mǝ̀ ká andǝ nyare aɓalǝ aɓwana mô nǝ acau kiɗikiɓwa ɗàng. Kǝa cam ɗǝong sǝ yilǝmi ɓio mǝ'murkala na aɓa ká-mǝɓane mala lú ɗàng: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","<< <A pà wu nǝ ɓinǝmǝsǝ mǝ'eambo a ɓabumo ɗàng. Awu nǝ gim ɓio mǝ'murkala a ɓamǝsǝi nǝ banggi wi mǝsǝcau, ɓǝ̀ ana raka awu nǝ nunbi ɓamurò bafe mala cauɓikea male. ");
INSERT INTO mbu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kǝa nyesǝì ɓwa gìr mǝɓane a kúnì mǝɓane ɗàng, sǝ a pà wunǝ bwal bumlulla a bumo arǝ kǝɓwa a ɓinado mala aɓwana ma'wun ɗàng; a kún mani ka awu nǝ earce ɓio mǝ'murkala kǝla mana a earce ɓamurò ka: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Dumǝna púp wun nǝ̀ bwal anê mem. Wu kǝa tsǝk agirkusǝu ma'wun, mǝnana à pà ɓǝle mwashat raka ɓǝà eau rǝia ɗàng; a pà wu nǝ ɓeal a'ulang amǝsǝɓeale ɓari a ɓaban mô ɗàng; a pà wu nǝ oasǝ daura mǝnana à tè nǝ ankonggúr ulangnì ɓari ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","<< <Ɓǝ̀ kǝ ɓwabura nongnǝ ɓwama guro mǝnana ɓeɓwa pùrnamurí nǝ̀ ali, sǝ à malaká akmúrí ko à nyi ɓǝ̀ kum ɓamúrì raka, dumǝna púp ama ɓwabura man nǝ̀ mbwegìr. Sǝama à pà nǝ̀ kasǝ ɓashi mala wal-luia ɗàng acemǝnana yì ɓwama guro ka, malaká kum panzǝban male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Sǝama dumǝna púp ɓwabure nǝ̀ yinǝ gam ace pagìr male mala mbwegìr ace kumcau, abanam Yahweh, a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Sǝ pǝris nǝ̀ shawuɗì nǝ gam mala pagìr male mala mbwegìr ace kumcau, a ɓadǝm Yahweh, ace cauɓikea male mana pàk ka, sǝ à nǝ̀ twalîbanì. ");
INSERT INTO mbu_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","<< <Lang wu yina aɓa nzali Kan'ana sǝ wu pandǝna koya ulang nggun ace girlina ka, dumǝna púp ama ɓǝla-nggunì ka wun nǝ̀ nyesǝì kǝla gìr na mǝnana à pǝrban arǝì ka; wun nǝ̀ twal apǝlǝa tàrú, nǝ̀ dupa wun gìr'ɓeami na; pà wu nǝ̀ lì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A inea pǝlǝa ka, wun nǝ̀ tàr aɓǝla-nggunì kat ɓǝà duk paɓoro aban Ɓakuli, ace lǝmdǝ yàwá ma'wun abanam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A tongnoia pǝlǝa ka, wun nǝ̀ gandǝ li ɓǝla-nggunì. Ɓǝ̀ wu kpata nzongcau mǝnia anggo ka, pàɓǝle mala anggunì nǝ̀ hatǝki ace wun: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","<< <Cè wu lì kǝ̀ nyama nǝ nkile arǝì ɗàng. << <Pà wun nǝ̀ kùtí a pàkkiagir mala ɓángnǝ́'ɓángna ko mala sǝ̀lǝ̀ɓǝla ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","<< <Pà wun nǝ̀ kasǝki nyang a takir wun, ko wun nǝ̀ mwa mbotokun wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","<< <Wu kǝa cangi rǝ wun ace alú, ko wun nǝ̀ tsǝk nyoulǝa arǝ wun ɗàng: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","<< <Wu kǝa pǝndǝkice amuna-mamǝna ma'wun nǝ tasǝia ɓǝà duk amā-gyatarǝu ɗàng, ɓǝ̀ ana raka nzali ma'wun nǝ̀ kpa aɓa gyatarǝu sǝ nǝ̀ lùmsǝ nǝ kìɗìkì. ");
INSERT INTO mbu_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","<< <Wu bwal nzongcau mala Sabbat, yì pwari usǝlǝo mem, sǝ wu lǝmdǝ pagulo arǝ Tara-mǝfele mem. ");
INSERT INTO mbu_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","<< <Cè wu pǝlǝa wu kùtí a pàkkiagir mala amǝ'ɗikalú ko mala amǝ'nggár ɗàng; wu kǝa kúti a altea ɗàng. Ɓǝ̀ wu pàk ka, à nǝ̀ dupa wun gìr mǝnana nǝ̀ tsǝa wun nǝ̀ pǝndǝki ka: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","<< <Wu gusǝlǝ akapana, wu pagulo aban aɓwana-mǝgule, sǝ wu ɓanggî Ɓakuli ma'wun: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","<< <Lang bǝri yiu sǝ yi do atà wun aɓa nzali ma'wun ngga, wu kǝa pàkce-ɓà ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Wu pàngnǝ bǝri mǝnana yiu a do aɓalǝ wun ngga kǝla mana wun nǝ̀ pàngnǝ ɓwa mǝnana à ɓǝli a nzali ma'wun ngga, sǝ awu nǝ earce kǝla mana a earce ɓamurò ka. Mǝnia ka nda acemǝnana wun ngga wu nda ka abǝri ɗiɗyal a nzali Masar; Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","<< <Kǝa ɓǝmbǝri kǝɓwa aɓa kārǝki gìr ɗàng; ko aɓa sauwa mala gìr na, ko aɓa dǝmbǝrya mala gìr na, ko aɓa mwaro mala gìrnî na. ");
INSERT INTO mbu_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Dumǝna púp ama sǝkel mò, ko tyang mò, ko tasau mô, mala kārǝkigir ka ɓǝ̀ do mǝ'mǝsǝcaunì na. Mǝ nda Yahweh Ɓakuli ma'wun mǝnana pusǝ wun, wu purî ɓá nzali Masar ka. ");
INSERT INTO mbu_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Wu kpata anggurcau mem kat andǝ anzongcau mem kat, sǝ wu pea. Mǝ nda Yahweh.> >> ");
INSERT INTO mbu_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","<<Awu nǝ banggi amǝ Isǝrayila ama, <Ɓwa mǝnana kat atà amǝ Isǝrayila ko atà abǝri mana à do a nzali Isǝrayila sǝ pà komǝye na atà amuni aban Molek ka, dumǝna púp à nǝ̀ wal-luí; aɓwana mala ɓinalê nǝ̀ ɓukki púp nǝ atali. ");
INSERT INTO mbu_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mim nǝ nggearǝam ngga mǝ nǝ pǝlǝ arǝì, mǝ nǝ pusǝì ɓǝ̀ purî ɓalǝ aɓwana male, acemǝnana pànà mwashat atà amuni aban Molek, mǝnana tsǝa ban-mǝfele mem duk gir-ɓeami sǝ pǝndǝkice lullǝàm mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Sǝ ɓǝ̀ aɓwana mala mǝno yì nzali, gìr mǝsǝia, à ɗeki mǝno yì ɓwa mǝnana pà muni aban Molek, sǝ à wal-luí raka, ");
INSERT INTO mbu_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mǝ nǝ pǝlǝ arǝì andǝ tàu male, mǝ nǝ kasǝia, ɓǝà purî ɓalǝ aɓwana malea. Mǝnia ka nda gìr mana nǝ̀ kum ɓwa mǝno, andǝ koya ɓwa mǝnana kutia gyatarǝu aban kpata Molek ka. ");
INSERT INTO mbu_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","<< <Ɓwa mǝnana pǝlǝa kǝla mǝgyatarǝu nǝ́ ká atà amǝ'ɗikalú andǝ amǝ'nggár ka, mǝ nǝ pǝlǝ arǝì sǝ mǝ nǝ kasǝì ɓǝ̀ purî ɓalǝ aɓwana male. ");
INSERT INTO mbu_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Wu tàr ɓamur rǝ wun aɓa domǝfele, acemǝnana Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Wu parkir wun wu kpata anê mem acemǝnana Mǝ nda Yahweh mana ǝn tàr wun ɓǝ̀ wu duk aɓwana mem ngga. ");
INSERT INTO mbu_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","<< <Ɓǝ̀ ɓwa sáng tárrí ko nggè ka dumǝna púp à nǝ̀ wal-luí. Ɓwa kǝla mǝno ka dumǝna púp ɓǝà wal-luí acemǝnana sángŋǝ́nà tárrí andǝ nggé; nkila male na amurí. ");
INSERT INTO mbu_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","<< <Ɓǝ̀ ɓwabura pàk cauɓikea mala nongnǝ mālá ɓi mǝ'murkala ka, dumǝna púp ɓwabure andǝ ɓwame mana à pàk cauɓikea mala nongnǝ rǝarǝia, yià kǝm ngga à nǝ̀ wal-luia. ");
INSERT INTO mbu_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ɓǝ̀ ɓwa nongnǝ mālá tárrí ka, pànî tárrí kǝsǝkya. Dumǝna púp yì andǝ ɓwame yià kǝm ngga à nǝ̀ wal-luia; nkila malea na amúrià. ");
INSERT INTO mbu_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ɓǝ̀ ɓwabura nongnǝ nkili mālá muni ka, dumǝna púp ɓwabure andǝ nkili yià kǝm ngga à nǝ̀ wal-luia; à pàngŋǝ̀nà gir-ɓeami; nkila malea na amúrià. ");
INSERT INTO mbu_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ɓǝ̀ ɓwabura nongnǝ ɓi ɓwabura, kǝla mana ɓwabura nǝ̀ nongnǝ ɓwama ka, à pàngŋǝ̀nà gìr'ɓeami. Dumǝna púp yia kǝm ngga à nǝ̀ wal-luia; nkila malea na amúrià. ");
INSERT INTO mbu_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ɓǝ̀ ɓwabura pak-ɓwama nǝ ɓwama andǝ nggeà ɓwame yià kǝm ngga, ɓealɓikea na. Dumǝna púp yià kat ka, à nǝ̀ pisǝia a bǝsa, ace mǝnana ɓealɓikea ɓǝ̀ kǝa pàk kàm aɓalǝ wun raka. ");
INSERT INTO mbu_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ɓwabura mǝnana pàk cauɓikea mala eau girkusǝu ka, dumǝna púp à nǝ̀ wal-luí, sǝ girkusǝuî gbal ka ɓǝà wal-luí. ");
INSERT INTO mbu_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ɓwama mǝnana pà ɓamúrì aban girkusǝu ace mǝnana ɓǝ̀ eauwi ka, dumǝna púp à nǝ̀ wal-luí andǝ girkusǝunì. ");
INSERT INTO mbu_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","<< <Ɓǝ̀ ɓwabura twal mǝ'nggaule, muna-ɓwama mala tárrí ko muna-ɓwama mala nggè, sǝ à nongnǝ rǝarǝia ka, gìr kǝsǝkya na. À nǝ̀ pǝria a mǝsǝ aɓwana ɓǝà purî ɓalǝ aɓwana malea. Yì ka kìɗìkìna mǝ'nggaule, sǝ bafe mala cauɓikea male nǝ̀ do amurí. ");
INSERT INTO mbu_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ɓǝ̀ ɓwabura nong andǝ ɓwama mǝnana nda aɓa bumkwana male, sǝ pak-ɓwama nǝi ka, ndǝlina tǝr ɓunno mala nkila male, sǝ yì gbal ka nyingna tǝr ɓunno mala nkila male kwas. Yià kǝm ngga à pà nǝ̀ ɓallia aɓalǝ aɓǝla malea ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","<< <A pà wunǝ nongnǝ mǝ'eam nggò ko mǝ'eam tárró ɗàng. Ɓwa mǝnana pè ka, ndarǝ pê aɓǝla male kǝsǝkya; yì andǝ ɓwame ka bafe mala cauɓikea malea nǝ̀ do amúrià. ");
INSERT INTO mbu_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ɓǝ̀ ɓwabura nongnǝ mālá kine ka, pànî kine kǝsǝkya; bafe mala cauɓikea male andǝ mala ɓwame nǝ̀ do amúrià, sǝ à nǝ̀ wǔ à pà nǝ̀ kum muna ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ɓǝ̀ ɓwabura nongnǝ mālá mǝ'eambi ka, pàngŋǝ̀nà gìr'ɓeami sǝ pànî mǝ'eambi kǝsǝkya. Yì andǝ ɓwame ka à nǝ̀ wǔ à pà nǝ̀ kum muna ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","<< <Dumǝna púp wun nǝ̀ bwal anê mem kat andǝ anggurcau mem kat sǝ wun nǝ̀ pea, ace mǝnana nzali mana ǝn nggǝ yinǝ wun ɓǝ̀ wu do aɓalǝi ka, ɓǝ̀kǝa u wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Sǝ pà wu nǝ̀ kpata akúncau mala nzali mala aɓwana mǝnana ǝn nggǝ pǝria a ɓadǝm wun ngga ɗàng; acemǝnana yià ka à pàkki agir mǝno ka, nda tsǝa sǝ ǝn ɓinǝcea ka. ");
INSERT INTO mbu_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Sǝama wun ngga ǝn pana cau mem aban wun ama: Wun nǝ̀ ak nzali malea arǝia. Mǝ nǝ pà wuni ɓǝ̀ duk girkuma ma'wun, nzali mǝnana kiura andǝ mur'nyi kǝ ɓang kàm ngga. Mǝ nda Yahweh Ɓakuli ma'wun mana tàr wun ɓǝ̀ wu duk ɗàng nǝ aɓwana mala acili anzali ka. ");
INSERT INTO mbu_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Acemani ka, wun nǝ̀ gau nre girkusǝu mǝnana mǝɓoarne na ace girlina andǝ mana gìr'ɓeami na ka, sǝ anre nyal mǝnana gìr'ɓeami na andǝ mana mǝɓoarne na ace girlina ka. Wu kǝa pǝndǝki ɓamur rǝ wun nǝ ɓekǝ girkusǝu ko nyal andǝ koman mǝnana kat kǝ pūrǝ nǝ múrbumi a nzali, amǝnana ǝn tárnia ɓǝ̀ wu nyesǝia agir'ɓeami na ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Dumǝna púp wun nǝ̀ amǝfele abanam, acemǝnana Mim Yahweh ka mǝ nda mǝfele, sǝ ǝn tarna wun aɓalǝ acili aɓwana ɓǝ̀ wu duk mem. ");
INSERT INTO mbu_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","<< <Ɓwabura ko ɓwama mǝnana mǝɗikalú na ko mǝ'nggár na ka, dumǝna púp à nǝ̀ wal-luí. Ɓǝà ɓukkia nǝ atali; nkila malea nǝ̀ pa amúrià.> >> ");
INSERT INTO mbu_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yahweh ne Musa ama, <<Nacau nǝ apǝris, andǝ amuna-burana mala Haruna, sǝ wu banggia wia ama, ɓǝ̀ kǝɓwa ateà ɓǝkǝa pǝndǝki rǝì nǝ oasǝ ɓamúrì aɓalǝ anàtà mala tsǝkban mala ɓeɓwa atà aɓǝla male mana wù ka ɗàng, ");
INSERT INTO mbu_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","she ɓǝ̀ ɓǝlê ka nda tù abani, ko nggè na, ko tárrí na, ko muna-ɓwabura male na, ko ɓoarnsarile, ko mǝ'eambi na, ");
INSERT INTO mbu_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ko mǝ'nggaule nsari (mǝnana dupi wi acemǝnana malaká albura raka) nda ka; amǝnia ka nda yakǝla nǝ̀ pǝndǝki rǝì acea ka. ");
INSERT INTO mbu_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pǝris pà nǝ̀ pǝndǝki rǝì acemǝnana yì ka nda múr aɓwana a tàu male, sǝ anggo ka nǝ̀ duk gìr'ɓeami ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Dumǝna púp pǝris pà nǝ̀ mwa kǝ ban a ɓamúrí ɓǝ̀ duk kongǝlang ɗàng, pà nǝ̀ mwaki ankanggari mbotokuni ɗàng, sǝ pà nǝ̀ cangi nyoulǝa arǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Apǝris nǝ̀ duk amǝfele aban Ɓakuli malea sǝ à pà nǝ̀ pǝndǝkice lullǝ Ɓakuli malea ɗàng. Yia ka à nda ka aɓwana mǝnana à pākiyi Yahweh apagir mala pisǝe a bǝsa, yì girlina mala Ɓakuli malea ka; acemani ka, dumǝna púp à nǝ̀ duk amǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Pǝris pà nǝ̀ al mā-gung, ko ɓwama mǝnana à kìɗìkìnì ka ɗàng, sǝ pà nǝ̀ al ɓwama mǝnana purî burí ka ɗàng, acemǝnana pǝris ka mǝfele na aban Ɓakuli male. ");
INSERT INTO mbu_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Pǝris ka dumǝna púp aɓwana nǝ̀ twali mǝfele na acemǝnana yì na kǝ pàgir mala girlina abanam, Ɓakuli ma'wun ngga. Yì ka nǝ̀ duk mǝfele aban wun, acemǝnana Mim, Yahweh, mana ǝn tar wun ace ɓamúràm ngga, Mǝ nda mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Sǝ ɓǝ̀ ɓoarnsarile koya pǝris pǝndǝki rǝì nǝ gyatarǝu ka, ndarǝ pǝndǝkice tárrí; dumǝna púp à nǝ̀ pisǝi a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","<<Pǝris mǝnana nda muna-dǝmba aɓalǝ amǝ'eambi, mǝnana à ɗārǝ́ni nǝ mùrú ɗārǝ́bân, sǝ à tàrnì ɓǝ̀ oasǝ adaura-pǝris arǝì ka, dumǝna púp pà nǝ̀ nying nyang ɓamúrí zuli ɗang, sǝ pà nǝ̀ san agir'nggūrǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Pà nǝ̀ kùtí amur koya lú ɗàng; pà nǝ̀ pǝndǝki ɓamúrì ɗàng, ko ɓǝ̀ lú tárrí ko nggè na ka, ");
INSERT INTO mbu_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","sǝ pà nǝ̀ purî ban mǝfele mala Ɓakuli male nǝ̀ ká a nza ɗàng, ace mǝnana ɓǝkǝa pǝndǝkice ban mǝfele raka; tàrban mala mùrú ɗārǝ́bân mala Ɓakuli ka nda amurí: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Sǝ pà nǝ̀ al ɓwama mǝnana súrǝ́nà ɓwabura ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Pà nǝ̀ al mā-lú ko ɓwama mǝnana purî ta burí, ko ɓwama mǝnana à gbárí, ko mā-gung na ka ɗàng. Nsari na nǝ̀ al aɓalǝ aɓwana male ka, ");
INSERT INTO mbu_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","acemǝnana ɓǝ̀ pàk ka, amuna mǝnana nǝ̀ yia ɓǝlia nǝnzǝ́mò ka à pǝndǝkina aɓalǝ aɓwana male. Mǝ nda Yahweh mana ǝn nggǝ tàr pǝris ɓǝ̀ duk mǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Sǝ Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","<<Nacau nǝ Haruna, banggi wi ama, kǝ muna ko mǝkau pá kàm a nggurkwar ma'wun, mǝnana ɓekǝ bare shingnǝe, ko ɗwanyi ɓekǝ bare rǝì ka, nǝ̀ sung tù aban gyangŋan ama nǝ̀ pà ɓoro girlina mala Ɓakuli male ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ɓǝ̀ ya ɓwa na sǝ ndanǝ kǝ mǝɓane a ɓè bare ka, ɓǝkǝa sung tù aban gyangŋan ama nǝ̀ pàgir ɗàng: nte ko gbakǝre, ko ɓwa mǝnana nggun-lullǝi sana, ko ɓè kusǝì ko buì sauwa kúti ɓì, ");
INSERT INTO mbu_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ko ɓwa mǝnana ɓè kusǝì ko buì ɓunno, ");
INSERT INTO mbu_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ko mǝ'nzongtong, ko nkpandal-candǝa, ko ɓwa mana ndanǝ ɓwá a mǝsǝì, ko ndanǝ kwánó oakiban, ko kwánó kwàmbì, ko ɓwê ka bedǝran na ka. ");
INSERT INTO mbu_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kǝɓwa pà kàm atà amuna andǝ amǝkau a tàu mala Haruna pǝris, mǝnana ɓè bare rǝì ka ndanǝ kǝ mǝɓane, nǝ̀ sung tù aban gyangŋan ama nǝ̀ pà aɓoro mǝnana à nǝ̀ pisǝia a bǝsa abanam, Mim Ɓakuli male ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Kat andǝ amani ka, nǝ̀ gandǝ li girlina mala Ɓakuli male, yì girlina mala apagir mǝfele andǝ apagir nggea mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Sǝama pà nǝ̀ kùtí nǝ ɓá lagir, ko nǝ̀ gbàshìban gyangŋan ɗàng, acemǝnana ndanǝ mǝɓane a ɓè bare rǝì, sǝ ace mǝnana abân mǝfele mem ɓǝà kǝa duk mǝɓeami ɗàng. Mǝ nda Yahweh, mǝnana ǝn nggǝ tàr abân mǝnia ɓǝà duk amǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Anggo sǝ Musa nacau nǝ Haruna andǝ amuni, andǝ amǝ Isǝrayila kat. ");
INSERT INTO mbu_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Sǝ Yahweh banggi Musa cau ama, ");
INSERT INTO mbu_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","<<Nacau nǝ Haruna andǝ amuni, ama ɓǝà dum nǝ tsǝkiru arǝ apagir mǝfele mala amǝ Isǝrayila, mǝnana à tària acem ngga, ace mǝnana ɓǝà kǝa pǝndǝkice lullǝàm mǝfele raka: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Banggia wia ama, <Arǝ anza ma'wun mǝnana kat à kǝ yiu ka, ɓǝ̀ kǝ ɓwa atà amuna andǝ amǝkau ma'wun, gbàshìban ko je agir mǝfele mala amǝ Isǝrayila, mǝnana à tària acem Mim Yahweh, sǝ nda aɓa do-ɓeami ka, mǝno yì ɓwa ka, à nǝ̀ kasǝi, ɓǝ̀ purî ɓadǝmbam: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ɓǝ̀ ɓè kǝɓwa kàm a tàu mala Haruna, ndanǝ kwánó nggû, ko mùrgìr kǝ sur a ɓate ka, pà nǝ̀ lì atà agir mǝfele ɗàng, she ɓǝ̀ langŋa rǝì ɓoarnansari ka. Koya pǝris mǝnana kat je ɓè kǝgir mǝnana je rǝ lú, ko yi ka sukkimùr arǝì ka, nǝ̀ pǝlǝ mǝɓeami, ");
INSERT INTO mbu_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","sǝ ɓǝ̀ yi ka je ɓekǝ gìr mǝnana kǝ kuɗǝki a nzali, mana nǝ̀ gandǝ tsǝì ɓǝ̀ duk mǝɓeami, ko ɓǝ̀ je ɓekǝ ɓwa mǝnana nǝ̀ gandǝ tsǝì ɓǝ̀ duk mǝɓeami, ko ɓǝ̀ mana nda do-ɓeami mala ɓwê ka. ");
INSERT INTO mbu_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Koya pǝris mǝnana je ulang amǝno yì agir ka, nǝ̀ duk mǝɓeami ba pwarikpǝra, sǝ pà nǝ̀ lì atà apagir mǝfele ɗàng she ɓǝ̀ sussǝna a mùr ka. ");
INSERT INTO mbu_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Lang pwari kpana ka, nǝ̀ ɓoarnsari, sǝ anzǝm mǝno ka, nǝ̀ gandǝ li atà agir mǝfele, acemǝnana girlina male na. ");
INSERT INTO mbu_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Pǝris ka pà nǝ̀ lì nyam girkusǝu mǝnana à kumi wuna atàrǝì ko anyambura wal-luí ka ɗàng, acemǝnana nǝ̀ tsǝì nǝ̀ duk mǝɓeami: Mǝ nda Yahweh.> ");
INSERT INTO mbu_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Acemani ka, dumǝna púp ɓǝà kpata kwarkiru mem, ɓǝ̀ ana raka à nǝ̀ twaltwalo mala cauɓikea amúrià sǝ à nǝ̀ wǔ atàcau male ɓǝ̀ à pǝndǝkice ka: Mǝ nda Yahweh, mǝnana ǝn nggǝ tàr apǝris ɓǝà duk amǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","<<Ɓwapwasǝa ka pà nǝ̀ lì aɓa gìr mǝfele ɗàng; kǝ ɓè bǝri ɓwa-kúnɗàngna mala pǝris, ko ɓwa mǝnana à twali ace túró-boalo ka, pà nǝ̀ li aɓa gìr mǝfele ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Sǝama ɓǝ̀ pǝris kúr guro nǝ boalo, duk girkuma male ka, gurè nǝ̀ gandǝ lì, sǝ koya ɓwa mǝnana à ɓǝli a ɓala male ka, à earǝ́nì wi ɓǝ̀ li aɓa girlina male. ");
INSERT INTO mbu_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ɓǝ̀ nsarile pǝris al ɓwapwasǝa ka, nsarile mǝno pà nǝ̀ lì aɓalǝ agir mǝfele mǝnana à pāki ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Sǝama ɓǝ̀ nsarile pǝris ka duk mā-lú ko doɓala male gauwa pànǝ muna ɗang, sǝ nyare a ɓala mala tarrí, kǝla mana pá a lo-ɓwa male ka, à nǝ̀ eari wi ɓǝ̀ lì aɓa girlina mala tarrí; ɓǝ̀ mǝno na raka, kǝ ɓwapwasǝa pà nǝ̀ lì girlinê ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Sǝ ɓǝ̀ ɓwa kǝla mǝno lì gir mǝfele aɓa ɗwanyi-sǝlǝe ka, dumǝna púp ɓwê nǝ̀ mbwe girlina mǝno lì ka, sǝ nǝ̀ tsǝk mwashat aɓa gauwe tongno mala kúrè amurí, sǝ nǝ̀ pè pǝris mǝnia yì gir mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Agir mǝfele mala amǝ Isǝrayila mǝnana à kǝ yinǝia ace pè Yahweh ka, apǝris ɓǝà kǝa pǝndǝkicea ");
INSERT INTO mbu_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nǝ nying aɓwana mana apǝris na raka ɓǝà lì ɗàng. Ɓǝ̀ à pàk ka à nǝ̀ twaltwalo mala cauɓikea andǝ bafe amúrià: Mǝ nda Yahweh, mǝnana ǝn nggǝ tàr apǝris ɓǝà duk amǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Sǝ Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","<<Bangcau nǝ Haruna andǝ amuna-burana male, andǝ amǝ Isǝrayila ama, Lang ɓeɓwa a tàu mala amǝ Isǝrayila, ko atà amǝ'kúnɗàngna mǝnana à ndanǝdo a nzali Isǝrayila, yinǝ ɓoro nǝ̀ pa, ko mala lùmsǝ komǝye na atà apàcau nǝ-shambum male, ko pàgir mala eare mala bumi na, mǝnana à nǝ̀ pàgir mala pisǝe kǝring nǝi abanam Yahweh ka, ");
INSERT INTO mbu_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ɓǝ̀ do ama à nǝ̀ é ka, dumǝna púp ɓǝ̀ pa jamnda ko gbato, ko gam a domwan male, mǝnana ɓekǝ gìr mǝɓane pà kàm arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Wu kǝa pà ɓekǝ gir mǝnana ndanǝ ɓekǝ mǝɓane arǝì ka ɗàng, acemǝnana Yahweh pà nǝ̀ é a kúnì wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Sǝ ɓǝ̀ ɓwa nǝ̀ pè Yahweh gir'nkila mala pàgir mala dotarǝu ace lùmsǝ pàcau nǝ-shambum male, ko pàgir mala eare mala ɓabumi na, atà andá ko ambul a domwan ngga, ɓǝ̀ à nǝ̀ é ka, dumǝna púp nǝ̀ duk mǝnana lùmsǝ puppup, ɓekǝ gìr mǝɓane pà kàm arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Pà wun nǝ̀ pà ɓekǝ girkusǝu mǝnana nte na, ko gbakǝri, ko mǝnana kúm-penye, ko mǝnana ɓekǝ mùrgìr kǝ pur arǝì, ko ndanǝ nzwari ko kwàmbì ka abanam Yahweh ɗàng, ko wun nǝ̀ pam, Mim Yahweh, ɓǝ̀ duk pàgir na nǝ bǝsa amur gyangŋan ngga ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Awu nǝ gandǝ pa jamnda ko nzur mǝnana ɓè bare sauwa kútì ɓi, ko gattì ɓi ka, ace pàgir mala eare mala ɓabum, sǝama ɓǝ̀ pàgir na ace lùmsǝ pàcau nǝ-shambum ngga, à pà nǝ̀ é ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Girkusǝu mǝnana kat kúm-penye a nkyari, ko à arki ankyari, ko nkyari sanā, ko kasǝ ka, à pà nǝ̀ panagir nǝi abanam Yahweh ɗàng; pà wu nǝ̀ pàk mǝno ka aɓa nzali ma'wun ɗàng, ");
INSERT INTO mbu_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","sǝ pà wu nǝ̀ ak ulang agirkusǝu mǝnia ka a bu ɓwa-kúnɗàngna ama wun nǝ̀ pa gìr'nkila nǝi kǝla pàgir mala girlina mala Ɓakuli ma'wun ɗàng. Ɓakuli ka pà nǝ̀ ak a'ulang agirkusǝu mǝno ka a kúnì wun ɗàng, acemǝnana mǝɓane nakam arǝia atàcau mala kúm-penye malea.>> ");
INSERT INTO mbu_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Sǝ Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","<<Lang à ɓǝl jamnda, ko nzur ka, à nǝ̀ nyi atà nggè nongŋo tongno-nong-ɓari, sǝ twal a tongno-nong-tàruià pwari aban ká dǝmba ka, à nǝ̀ gandǝ é ɓǝ̀ duk pàgir nǝ bǝsa abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sǝama pà wun nǝ̀ wal ndǎ ko nzur, a pwari mǝ'mwashati andǝ muni ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Sǝ ɓǝ̀ wun nǝ̀ pwan-myal girkusǝu ace pa gìr'nkila ace pàk-yàwá abanam Yahweh ka, dumǝna púp wun nǝ̀ pè aɓa kpata njarì ace mǝnana ɓǝ̀ wu kum â ka. ");
INSERT INTO mbu_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Wun nǝ̀ lì a kǝ pwari mǝ'mwashati; pà wun nǝ̀ nying kǝ cili ɓǝ̀ bankwari ɗàng: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","<<Anggo sǝ wun nǝ̀ kpata anzongcau mem sǝ wun nǝ̀ peǎ: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Sǝ pà wu nǝ̀ pǝndǝkice lullǝam mǝfele ɗàng, ace mǝnana ɓǝ̀ aɓwana sǝni ama mǝ nda mǝfele aɓalǝ amǝ Isǝrayila ka. Mǝ nda Yahweh mǝnana ǝn nggǝ tàr wun ɓǝ̀ wu duk aɓwana mem, ");
INSERT INTO mbu_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Mim mǝnana ǝn pusǝ wun wu purî ɓá nzali Masar ace mǝnana mǝ duk Ɓakuli ma'wun ngga: Mǝ nda Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","<<Bangcau nǝ amǝ Isǝrayila, nea wia ama, Amǝnia ka, à nda ka alamsan mem mǝnana à kwakia, ama dumǝna púp ɓǝ̀ wu hamnǝia kǝla aramba-banɓwáná mǝfele ka; alamsan mem mǝnana ǝn kwakia ka à nda. ");
INSERT INTO mbu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","<<Aɓa nongŋo tongno-nong-mwashat wun nǝ̀ pàktúró, sǝama tongno-nong-ɓaria pwari ka, nǝ̀ duk pwari Sabbat, pwari usǝlǝo kat-kat, mala ramba-banɓwáná mǝfele. Pà wu nǝ̀ pàk kǝ túró aɓalǝi ɗàng. Sabbat na acem Yahweh arǝ abando ma'wun kat. ");
INSERT INTO mbu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","<<Amǝnia ka à nda ka alamsan mem Yahweh mǝnana ǝn kwakia ka, yì aramba-banɓwáná mǝfele mǝnana wun nǝ̀ hamnǝia ɓǝ̀ apwari malea mǝnana à tsǝkia wia ka à yi kārǝ́ ka. ");
INSERT INTO mbu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Aɓa lum-nong-inea nongŋo mala zongŋo mǝdǝmbe, nǝ pwari-ká-ndwent ka, wun nǝ̀ pà gìr'nkila mala Yàlîmurû abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Sǝ a lum-bwamdǝ-tongnoia pwari mala kǝ zongŋe ka, nda tita Lamsan mala Bǝredi mana Yis pà arǝì raka acem Yahweh; wun nǝ̀ twal anongŋo tongno-nong-ɓari mǝnana aɓalǝia ka, wun nǝ̀ li Bǝredi mǝnana yis pà arǝì raka. ");
INSERT INTO mbu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A pwari mǝdǝmbe ka, wun nǝ̀ yiu ace ramba-banɓwáná mǝfele; a pwari mǝnia ka, pà wu nǝ̀ pak kǝ túró mala koya pwari ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sǝama a koya pwari mala amǝno yì anongŋo tongno-nong-ɓari ka, wun nǝ̀ yinǝ pàgir nǝ bǝsa abanam Yahweh. A tongno-nong-ɓaria pwari ka, nda pwari mala ramba-banɓwáná mǝfele; a pwari mǝnia ka, pà wu nǝ̀ pak kǝ túró mala koya pwari ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Pǝlǝa Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","<<Bangcau nǝ amǝ Isǝrayila, nea wia ama, Lang wu yina a nzali mana ǝn nggǝ pà wun, sǝ wu pwàn gìrɓaban male ka, dumǝna púp wun nǝ̀ yinǝ kùnò mala aɓǝlagir mǝdǝmbe mala agirɓaban ma'wun aban pǝris, ");
INSERT INTO mbu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","sǝ wun nǝ̀ loasǝ kùnoê a kuli a ɓadǝmbam Yahweh, ace mǝnana ɓǝ̀ wu kum â ka. A pwari mǝnana anzǝm Sabbat ka sǝ pǝris nǝ̀ loasǝi a kuli. ");
INSERT INTO mbu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A pwari mǝnana à nǝ̀ loasǝ mǝno yì kùnò ka, dumǝna púp awu nǝ pà muna-gam mǝnana mbule mwashat, sǝ ɓekǝ gìr mǝɓane pà kàm arǝì raka, ɓǝ̀ duk pàgir mala pisǝe kǝring abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Sǝ atārǝia andǝ mǝno ka awu nǝ pà tyang ɓari mala muku mǝɓǝlke mana à zurǝì andǝ mùrú olif ka, ɓǝ̀ duk pàgir mala mǝsǝsa male; pàgir nǝ bǝsa na, mala pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. Sǝ atārǝia andǝ mǝno ɗǝm ngga awu nǝ pà lita mwashat mala mùr-anap, ɓǝ̀ duk pàgir mala girnùná. ");
INSERT INTO mbu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pà wu nǝ̀ lì kǝɓè bǝsa mǝsǝsa ɗàng, ko pwale, ko ime, ko mǝnana à lurǝi pǝlǝ bǝredi ka, sheɓǝ̀ wu yina nǝ pàgir mǝnia aban Ɓakuli ma'wun ngga. Mǝnia ka nggurcau na tàtǝ́k arǝ anza ma'wun kat, arǝ abân mǝnana kat wu duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","<<Twal a pwari mǝnana yiu anzǝm Sabbat, yì pwari mana wu yinǝ kùnò mala aɓǝlagir nǝi, ace pàgir mala loasǝe a kuli a ɓadǝmbam Yahweh ka, wun nǝ̀ ɓal alimo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","A lumi-tongnoia pwari, yì masǝlǝata pwari mala tongno-nong-ɓaria limo ka, wun nǝ̀ yinǝ ɓè pàgir mala mǝsǝsa nǝ bǝsa mǝsǝsa abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Arǝ aɓala ma'wun ngga, dumǝna púp wun nǝ̀ yinǝ agbatali bǝredi ɓari, ace pàgir mala loasǝe a kuli; koya gbatali bǝredi ka, à nǝ̀ pè nǝ tyang ɓari mala muku mǝɓǝlke, à nǝ̀ lurǝi nǝ yis arǝì, sǝ à nǝ̀ yinǝi à nǝ̀ ya pam Yahweh kǝla ɓǝlagir mǝdǝmbe. ");
INSERT INTO mbu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Atārǝia andǝ agbatali bǝredi mǝno ka, dumǝna púp wun nǝ̀ pa amuna-nzur tongno-nong-ɓari mǝnana mbulea mwashat-mwashat, sǝ kǝ mǝɓane pà kàm arǝia raka, andǝ lo-jamnda mwashat, andǝ agam ɓari. À nǝ̀ duk pàgir mala pisǝe kǝring abanam Yahweh atārǝia andǝ pàgir mala mǝsǝsa malea, andǝ apagir mala girnùná; pàgir nǝ bǝsa na mala pà rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Sǝ wun nǝ̀ pagìr nǝ gbato mwashat ɓǝ̀ duk pàgir ace cauɓikea, sǝ amuna-gam ɓari mǝnana mbulea mwashat-mwashat ka kǝla gìr'nkila mala apagir ace dotarǝu. ");
INSERT INTO mbu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Sǝ pǝris nǝ̀ loasǝ agam mǝnia ɓari ka a kuli atārǝia andǝ bǝredi mala ɓǝlagir-mǝdǝmbe, kǝla pàgir mǝnana à nǝ̀ loasǝi a kuli a ɓadǝmbam Yahweh ka. À nǝ̀ duk mǝfele abanam Yahweh, ace pǝris. ");
INSERT INTO mbu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","<<A pwari mǝno ka wun nǝ̀ hama ama pwari mǝgule na ace ramba mala aɓwana; ramba-banɓwáná mǝfele na ace wun. Pà wu nǝ̀ pàk kǝ túró mala koya pwari ɗàng. Nggurcau na tàtǝ́k arǝ anza ma'wun kat, arǝ abân mǝnana kat wu duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","<<Sǝ lang wu yina pwàn aɓǝlagir mala nzali ma'wun ngga, pà wu nǝ̀ pwania aban ká arǝ nzong ɓaban ma'wun ɗàng, sǝ pà wu nǝ̀ alta ɓakurikuri ma'wun anzǝm pwan-gìrɓaban ɗang. Wu nyinggi amǝ'tǝ̀r andǝ abǝri mǝnana à do aɓalǝ wun ngga: Mǝ nda Yahweh Ɓakuli ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Sǝ Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","<<Banggi amǝ Isǝrayila ama, Pwari mǝdǝmbe mala tongno-nong-ɓaria zongŋo ka, wun nǝ̀ twali pwari na à tsǝì ace usǝlǝo kat-kat; pwari mǝfele ace ramba-banɓwáná, mǝnana à nǝ̀ hamnǝ pakkiɗire male mala kasǝɓalǝu nǝ ɓua-njawe mǝcandǝe mala anjawe ka. ");
INSERT INTO mbu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Pà wu nǝ̀ pàkki atúró ma'wun aɓalǝi ɗàng. A kún mani ka, wun nǝ̀ pàɓoro nǝ bǝsa abanam Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","<<Lumia pwari mala mǝnia yì tongno-nong-ɓaria zongŋo ka nda Pwari mala Shawuɗiban. Nǝ̀ dupa wun pwari ramba-banɓwáná mǝfele. Wun nǝ̀ ɓinǝì ɓamur rǝ wun agir sǝ wun nǝ̀ pàgir nǝ bǝsa abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Sǝ pà wu nǝ̀ pàk kǝ túró mala koya pwari a mǝno yì pwari ka ɗàng, acemǝnana Pwari mala Shawuɗiban na, ace shawuɗì wun a ɓadǝmbam Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ɓwa mǝnana gilmur a mǝno yì pwari raka, à pà nǝ̀ ɓalli aɓalǝ aɓwana male ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Sǝ ɓwa mǝnana kat pàk kǝ túró a mǝno yì pwari ka, mǝ nǝ kiɗiki aɓalǝ aɓwana male. ");
INSERT INTO mbu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Pà wu nǝ̀ pàk kǝ túró ɗang kpékpé. Dumǝna nggurcau tàtǝ́k aɓalǝ anza ma'wun kat, arǝ abando ma'wun kat. ");
INSERT INTO mbu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Nǝ̀ dupa wun Sabbat mala usǝlǝo kat-kat, sǝ wun nǝ̀ ɓinǝì ɓamur rǝ wun agir. A tongno-nong-inea pwari mala zongŋe, nǝ pwarikpǝra, lo a pwarikpǝra aban ká ɓè pwarikpǝra ka, wun nǝ̀ pagulo arǝ Sabbat ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Sǝ Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","<<Banggi amǝ Isǝrayila ama: Lamsan mala Do aɓalǝ Agumli ka, nǝ̀ tite a lum-bwamdǝ-tongnoia pwari mala mǝnia yì tongno-nong-ɓaria zongŋo ka, sǝ nǝ̀ lidǝmba arǝ anongŋo tongno-nong-ɓari ace pagulo abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Pwari mǝdǝmbe ka nǝ̀ duk mala ramba-banɓwáná mǝfele; pà wu nǝ̀ pàk kǝ túró mala koya pwari aɓalǝi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Wun nǝ̀ twal anongŋo tongno-nong-ɓari, sǝ a koya pwari ka, wun nǝ̀ pàgir nǝ bǝsa abanam Yahweh. A tongno-nong-tàruià pwari ka, wun nǝ̀ yiu ace ramba-banɓwáná mǝfele, sǝ wun nǝ̀ pàɓoro mala girlina abanam Yahweh. Dápí ace peri na; pà wu nǝ̀ pàk kǝ túró mala koya pwari aɓalǝi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","<<Amǝnia ka, à nda ka alamsan mem Yahweh mǝnana à kwakia, mǝnana dumǝna púp ɓǝ̀ wu hamnǝia kǝla aramba-banɓwáná mǝfele, ace pà aɓoro mala girlina abanam Yahweh, apagir mala pisǝe kǝring andǝ apagir mala mǝsǝsa, agir'nkila, andǝ apagir mala girnùná, komǝye ka a pwari male mǝnana kārǝ́ nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Acilia alamsan mana à kwakia ka à nda ka, Sabbat mala Yahweh, andǝ aɓoro ma'wun, andǝ apagir mala lùmsǝ apacau nǝ-shambum ma'wun, andǝ apagir ma'wun mala eare mala ɓabum wun, mǝnana wun nǝ̀ pam Mim Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","<<A lum-bwamdǝ-tongnoia pwari mala tongno-nong-ɓaria zongŋo, lang wu pwanǝna agirɓaban mala nzali ma'wun ngga, wun nǝ̀ pàkkiɗire lamsan mem Yahweh aɓa nongŋo tongno-nong-ɓari. A pwari mǝdǝmbe ka, wun nǝ̀ twal usǝlǝo kat-kat, sǝ a tongno-nong-tàruià nongŋo ka nǝ̀ duk pwari usǝlǝo ɗǝm kat-kat. ");
INSERT INTO mbu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A mǝno yì pwari mǝdǝmbe ka, wun nǝ̀ tù aɓǝla anggun mǝɓoarsǝne andǝ abú nggun nkangga, andǝ abú nggun mǝnana nǝ ambui kpǝm arǝì ka, andǝ ambú girpwala mana à kǝ gul a kún myalmúr ka, sǝ wu pakkiɗire nǝ banɓoarnado a ɓadǝm Yahweh Ɓakuli ma'wun aɓa nongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wun nǝ̀ pàkkiɗire male kǝla lamsan abanam Yahweh aɓa nongŋo tongno-nong-ɓari aɓa pǝlǝa. Dumǝna nggurcau tàtǝ́k arǝ anza ma'wun kat; wun nǝ̀ pakkiɗire male a tongno-nong-ɓaria zongŋo. ");
INSERT INTO mbu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Wun nǝ̀ do aɓalǝ agumli aɓa nongŋo tongno-nong-ɓari. Aɓwana mǝnana kat à ɓǝlia amǝ Isǝrayila na ka, dumǝna púp à nǝ̀ do aɓalǝ agumli, ");
INSERT INTO mbu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ace mǝnana anza ma'wun ɓǝà sǝlǝ ama ǝn tsǝk amǝ Isǝrayila à do aɓalǝ agumli lang ǝn pusǝia à purî ɓá nzali Masar ka: Mǝ nda Yahweh Ɓakuli ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Anggo sǝ Musa hama amǝ Isǝrayila alamsan mana Yahweh kwakia ka. ");
INSERT INTO mbu_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","<<Tsǝk amǝ Isǝrayila ɓǝà yinǝo nǝ mùrú mǝkware mǝnana à kambi arǝ aɓǝla-olif ka ace apitǝla, ace mǝnana abǝsa malea ɓǝà lidǝmba nǝ earke koya pwari. ");
INSERT INTO mbu_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","A nza nǝ lagir mala Akwati mala Acau-nakûn, aɓa Tara Ban-peri ka, Haruna nǝ̀ tsǝk bǝsa mala apitǝla koya pwarikpǝra ace mǝnana ɓǝà kǝ earke a ɓadǝm Yahweh ba dǝmbari, koya pwari ka. Nǝ̀ duk nggurcau tàtǝ́k arǝ anza ma'wun kat. ");
INSERT INTO mbu_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Dumǝna púp nǝ̀ kǝtǝrǝki apitǝla mǝnia sǝ nǝ̀ tamsǝkia amur gìr-tamsǝia mǝnana à pè nǝ bolo-njengǝlan ngga, ace mǝnana ɓǝà kǝ earke a ɓadǝm Yahweh koya pwari ka. ");
INSERT INTO mbu_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","<<Awu nǝ ɗàrǝ́ muku mǝɓǝlke sǝ wu pàk agbatali bǝredi lum-nong-ɓari nǝi, komǝye ka dǝmbǝrya male ɓǝ̀ pàk tyang ɓari. ");
INSERT INTO mbu_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Sǝ awu nǝ yinǝia a ɓadǝm Yahweh, awu nǝ gwalikia amur rǝarǝia arǝ abanì ɓari, tongno-nong-mwashat aɓa koya gwali amur kpamgbang-tsǝk-agir mǝnana à pè nǝ bolo-njengǝlan ngga. ");
INSERT INTO mbu_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Sǝ awu nǝ tsǝk myang-kwarra a nkanggari koya gwali, ace mǝnana atārǝia andǝ bǝredi ka, ɓǝ̀ duk kāmbe mala kasǝɓalǝu; pàgir nǝ bǝsa na abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Koya pwari Sabbat ka, Haruna nǝ̀ gilikicia a ɓadǝm Yahweh, pà nǝ̀ ue ɗang; gìr na mǝnana dumǝna púp amǝ Isǝrayila nǝ̀ nggǝ pè kǝla kùrcau tàtǝ́k ka. ");
INSERT INTO mbu_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Sǝ bǝredi mǝno ka mala Haruna na andǝ amuni andǝ amǝkè; à nǝ̀ shè aɓa ban mǝfele, acemǝnana kāmbe nggea mǝfele male na aɓalǝ apagir nǝ bǝsa abanam Yahweh; dumǝna male, à nǝ̀ nggǝ pe wi málá male pà kàm ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A ɓè pwari ka, ɓè muna-ɓwabura mǝnana nggè ka ɓwama Isǝrayila na sǝ tárrí ka ɓwa Masar na ka, wari aɓalǝ amǝ Isǝrayila. Muna-ɓwabura mala ɓwama Isǝrayila mǝnia munǝ andǝ ɓwa Isǝrayila aɓa kàttì, ");
INSERT INTO mbu_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","sǝ muna-ɓwabura mala ɓwama Isǝrayila ka pàkce lullǝ Yahweh ɓà nǝ suban. Pǝlǝa à wari nǝi aban Musa. Lullǝ ngge ndà Shelomit muna-ɓwama mala Dibǝri, a tàu mala Dan. ");
INSERT INTO mbu_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Sǝ à oasǝi a ndà, à nǝ̀ kundǝ súrǝ̀ kàne mala Yahweh amurí. ");
INSERT INTO mbu_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Pǝlǝa Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","<<Wu pusǝ mǝno yì ɓwa ɓǝ̀ purî ɓá kàttì, sǝ aɓwana mǝnana kat à oè ka, ɓǝà tsǝk buia amurí, sǝ ɓwabundǝa kat ɓǝà ɓukki nǝ atali. ");
INSERT INTO mbu_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Sǝ wu nunkir amǝ Isǝrayila ama ɓwa mǝnana kat tsǝk kúni arǝ Ɓakuli male ka, bafe mala cauɓikea male nǝ̀ do amurí. ");
INSERT INTO mbu_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ɓwa mǝnana kat na mǝɓane amur lullǝ Yahweh ka, dumǝna púp à nǝ̀ wal-luí. Ɓwabundǝa kat nǝ̀ ɓukki. Ko ɓǝ̀ ɓwa-kúnɗàngna na ko ɓwa Isǝrayila na, sǝ na mǝɓane amur lullǝ Yahweh ka, à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","<<Ɓwa mǝnana wal-lú ɓi ka, à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ɓwa mǝnana wal-lú girkusǝu ka, nǝ̀ mbwe girkusǝu. ");
INSERT INTO mbu_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ɓǝ̀ ɓwa tsǝkî ɓì npenye ka, gìr mǝnana pakkî ɓì ka, nda à nǝ̀ pàkki wi ka. ");
INSERT INTO mbu_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","À nǝ̀ ɓun mǔ ace ɓun mǔ, mǝsǝu ace mǝsǝu, minǝu ace minǝu; gìr mǝnana kat ɓwa pakkî ɓì ka, kǝ nda à nǝ̀ pàkki wi ka. ");
INSERT INTO mbu_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ɓwa mǝnana kat wal girkusǝu ka, nǝ̀ mbwe girkusǝu, sǝ ɓwa mǝnana wal-lú ɓwa ka à nǝ̀ wal-luí. ");
INSERT INTO mbu_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kǝ nzongcau mǝmwashati na amur ɓwa-kúnɗàngna ko ɓwa Isǝrayila, acemǝnana mǝ nda Yahweh Ɓakuli ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Pǝlǝa Musa banggi amǝ Isǝrayila, sǝ à pusǝ ɓwa mǝno namǝɓane ka anzǝm kàttì, sǝ à ɓukki nǝ atali. Anggo sǝ amǝ Isǝrayila pǎ kǝla mǝnana Yahweh ne Musa ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yahweh banggi Musa cau amur Nkono Saina ama, ");
INSERT INTO mbu_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","<<Nacau nǝ amǝ Isǝrayila sǝ wu banggia wia ama, lang wu yina aɓa nzali mǝnana ǝn pà wun ngga, wu nying nzalî ɓǝ̀ kum usǝlǝo mala Sabbat abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Wun nǝ̀ ɓealɓeale arǝ aɓaban ma'wun aɓa pǝlǝa tongno-nong-mwashat, sǝ wun nǝ̀ kpaliki anggun anap ma'wun sǝ wun nǝ̀ pwan ɓǝlea aɓa pǝlǝa tongno-nong-mwashat, ");
INSERT INTO mbu_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","sǝama tongno-nong-ɓaria pǝlǝa ka, nǝ̀ duk Sabbat mala usǝlǝo kat-kat ace nzalî abanam Yahweh. Aɓalǝi ka pà wu nǝ̀ ɓealɓeale a ɓaban ko wun nǝ̀ kpaliki anggun anap ma'wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Pà wu nǝ̀ pwàn gìr mǝnana gul a nkwalo anzǝm ram girɓaban ma'wun ngga ɗàng, sǝ pà wu nǝ̀ tùki aɓǝla nggun-anap mǝnana wu kpaliki abui raka ɗàng. Pǝlǝê ka nǝ̀ duk mala usǝlǝo kat-kat ace nzalî. ");
INSERT INTO mbu_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pǝlǝa mala Sabbat mala nzali ka nǝ̀ pusǝ girlina ace wun, ace aguro ma'wun andǝ amǝ'túró-boalo ma'wun aburana andǝ amamǝna, andǝ abǝri mǝnana à do aɓalǝ wun ngga, ");
INSERT INTO mbu_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","sǝ ace anyam-lǝsǝa ma'wun andǝ anyam-ɓabondo mǝnana a nzali ma'wun ngga: gìr mǝnana kat nzali nǝ̀ pusǝ ka girlina na. ");
INSERT INTO mbu_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","<<Wun nǝ̀ ɓal alimo Sabbat mala apǝlǝa, apǝlǝa tongno-nong-ɓari kusǝ tongno-nong-ɓari, ace mǝnana anonggio mala alimo Sabbat mala apǝlǝa ka, à nǝ̀ pà wun apǝlǝa lumi-ine bwamdǝ tongno-nong-ine (49). ");
INSERT INTO mbu_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sǝ a lumia pwari mala tongno-nong-ɓaria zongŋo, mǝnana nda Pwari mala Shawuɗiban ngga, wun nǝ̀ twang njawe ɓǝ̀ ɓua ɓua-mǝcandǝe. Dumǝna púp amǝnia yì Pwari ka wun nǝ̀ twang njawe aɓa nzali ma'wun kat. ");
INSERT INTO mbu_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Wun nǝ̀ tàr mǝnia yì lumi-tongnoia pǝlǝa ka, sǝ wun nǝ̀ hamnǝ kumɓamuru aɓa nzali kat ace aɓwana andǝ agir mǝnana kat à ndanǝdo aɓalǝi ka. Nǝ̀ duk pǝlǝa mala pàkkiɗire-banɓoarnado ace wun. Aɓa pǝlǝa mǝnia ka, koya nzali mǝnana kat à me ka, à nǝ̀ nyesǝi ɓǝ̀ nyare a bù mǝtale mana atadǝmbe ka ko a bù amǝke, sǝ koyan mǝnana kat à me kǝla guro ka nǝ̀ nyare aban amǝɓala male. ");
INSERT INTO mbu_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mǝno yì lumi-tongnoia pǝlǝa ka, nǝ̀ duk pǝlǝa mala pàkkiɗire-banɓoarnado ace wun. Aɓalǝi ka pà wu nǝ̀ ɓealɓeale ɗang, pà wu nǝ̀ pwàn kǝ mǝssa mǝnana gul a nkwalo ka ɗàng, sǝ pà wu nǝ̀ tùki aɓǝla nggun-anap mǝnana wu kpaliki abui raka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mǝno yì pǝlǝa ka, mala pàkkiɗire-banɓoarnado na. Nǝ̀ duk pǝlǝa mǝfele aban wun. Kǝ gìr mǝnana ɓǝl atàrǝì a ɓaban ngga nda wun nǝ̀ lì ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","<<A mǝnia yì pǝlǝa mala pàkkiɗire-banɓoarnado ka, koya nzali mǝnana kat à me ka, à nǝ̀ nyesǝi ɓǝ̀ nyare a bù mǝtale mana atadǝmbe ka ko a bù amǝke, sǝ koyan mǝnana kat à me kǝla guro ka nǝ̀ nyare aban amǝɓala male. ");
INSERT INTO mbu_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Sǝ ɓǝ̀ a makkì ɓio mǝ'murkala kǝgir, ko a kúr kǝgir a bù ɓio mǝ'murkala ka, cè a tǝpǝri ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ɓǝ̀ a kúr nzali a bù ɓio mǝ'murkala ka, kúrè ka nǝ̀ kārǝa arǝ lakkì mala apǝlǝa mana à kutikio anzǝm pàkkiɗire-banɓoarnado mǝ'nzǝ́moè ka. Sǝ yì ka nǝ̀ makko wi amur làkkì mala apǝlǝa mǝnana à ueo sǝ ɓè pàkkiɗire-banɓoarnado yiu ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ɓǝ̀ apǝlǝe na pas ka, awu nǝ eamsǝ kúrè, sǝ ɓǝ̀ à nda kpokyak ka, awu nǝ sulǝ kúrè, acemǝnana làkkì mala apǝlǝa mala pwan girɓaban na kǝ makkò ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Pà wu nǝ̀ tǝpǝri rǝarǝ wun ɗàng; wun nǝ̀ ɓanggi Ɓakuli ma'wun, acemǝnana Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","<<Ɓǝ̀ wu earce do jam aɓa nzali ka, dumǝna púp wun nǝ̀ bwal anê mem, sǝ wun nǝ̀ kpata acau mem, sǝ wun nǝ̀ peǎ. ");
INSERT INTO mbu_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nzali ka nǝ̀ pà ɓǝle, sǝ wun nǝ̀ lì, wun nǝ̀ ɗǝmbo, sǝ wun nǝ̀ duk jam. ");
INSERT INTO mbu_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Sǝ ɓǝ̀ wu na ama, <Mana sǝm nǝ̀ lǐ aɓa tongno-nong-ɓaria pǝlǝa, yi mǝnana sǝm ɓealɓeale ko sǝm pwan girɓaban raka?> ");
INSERT INTO mbu_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mǝ nǝ tsǝkî nzali buam aɓa tongno-nong-mwashatia pǝlǝa, wun nǝ̀ pwan girlina mǝnana nǝ̀ linǝ wun, aɓalǝ apǝlǝa tàrú ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Sǝ lang wu ɓealɓeale a tongno-nong-tàruià pǝlǝa ka, wun nǝ̀ pwan girlina, mǝnana nǝ̀ yia kum mǝ'e mana wu pwan a tongno-nong-mwashatia pǝlǝa ka, sǝ wun nǝ̀ kum kpǝm mǝnana wun nǝ̀ lǐ nǝ̀ kánǝ wun a tongno-nong-inea pǝlǝa, a bàkú mala pwan gìrɓaban male ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","<<Pà wu nǝ̀ mak nzali ɓǝ̀ duk mala ɓwa tàtǝ́k ɗàng, acemǝnana nzali ka mema. Wun ngga, wu nda ka abǝri, sǝ wu yiu a dola atàm. ");
INSERT INTO mbu_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Sǝ aɓa nzali mǝnana kat nda a bù wun ngga, dumǝna púp wu sǝlǝ ama ɓǝ̀ ɓwa makkò ɓè bare nzali ka ndanǝ njar nǝ̀ nyare nǝ̀ kúrí ɗǝm a buo, ɓǝ̀ earce ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","<<Ɓǝ̀ tǝ̀r tsǝk ɓio ɓwa Isǝrayila sǝ mak bare nzali male ka, ɓwa mǝnana ɓǝla li-gìr-lú male na ka ɓǝ̀ akmúr gìr mǝnana mǝ'eambi mangŋǝ́nì ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Sǝ ɓǝ̀ ɓwe panǝ kǝɓwa mǝnana nǝ̀ akmúr nzalinì raka, sǝ nǝnzǝ́mò ka yi kumbu sǝ kum gìr mǝnana kārǝa nǝ̀ kúrí nǝi ka, ɓǝ̀ nyare ɓǝ̀ akmúrí. ");
INSERT INTO mbu_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ɓǝ̀ ɓal apǝlǝa, twal a pwari mana mangŋǝna nzalî nǝi ka, sǝ ɓǝ̀ mbwe cili boalo ace apǝlǝa mǝnana ueo aban ká ɓè pàkkiɗire-banɓoarnado ka, aban ɓwa mana kúrí ka, sǝ ɓǝ̀ nyesǝ girkuma male. ");
INSERT INTO mbu_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Sǝ ɓǝ̀ pànǝ boalo mana kārǝa nǝ̀ akmúr nzalî raka, ɓǝ̀ nyi a bu ɓwa mǝnana kúrí ka she ɓǝ̀ pǝlǝa mala pàkkiɗire-banɓoarnado karna ka. Aɓa pǝlǝa mala pàkkiɗire-banɓoarnado ka, à nǝ̀ nyinggi wi girkuma male ɓǝ̀ nyar a buì. ");
INSERT INTO mbu_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","<<Ɓǝ̀ ɓwa mak ɓala-do male, aɓa nggea-là mǝnana à kàrì nǝ sheran ngga, nǝ̀ gandǝ nyare nǝ̀ akmúrí aɓa kǝ pǝlǝa mana mé nǝi ka. Aɓa pǝlǝa kat ka, ndanǝ njar mala nyare nǝ̀ akmúr girkuma male. ");
INSERT INTO mbu_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ɓǝ̀ à gandǝ akmúr ɓalae aɓa lumsǝo mala pǝlǝa mwashat raka, ɓalae aɓa nggea-là mana à kàrì nǝ sheran ngga, nǝ̀ duk mala ɓwa mǝnana kúrí ka andǝ amuni andǝ amǝkè tàtǝ́k; à pà nǝ̀ akmúrí aɓa pǝlǝa mala pàkkiɗire-banɓoarnado ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Sǝ aɓala mǝnana à nda arǝ amuna-là mǝnana à kàriá nǝ sheran raka, à nǝ̀ twalia à nda mwashat andǝ aɓaban mala nzalinì. À nǝ̀ gandǝ akmúria, sǝ à nǝ̀ gandǝ nyesǝia aɓa pǝlǝa mala pàkkiɗire-banɓoarnado. ");
INSERT INTO mbu_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Sǝama Amǝ'Lawi ka à ndanǝ njar koya pwari à nǝ̀ akmúr aɓala malea aɓalǝ anggea-là mǝnana à tsǝia kàm ngga. ");
INSERT INTO mbu_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Sǝ ɓǝ̀ ya ɓala aɓa mwashat atà anggea-là mǝnia Ɓwa-lawi me sǝ à akmúrí raka, dumǝna púp à nǝ̀ nyesǝi aɓa pǝlǝa mala pàkkiɗire-banɓoarnado, acemǝnana aɓala mǝnana amala Amǝ'Lawi na aɓalǝ anggea-là ka, agirkuma malea na aɓalǝ amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Amur mani ka, anzali yál-agir mala anggea-là malea ka, dumǝna púp à pà nǝ̀ mea ɗàng acemǝnana girkuma malea na tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","<<Ɓǝ̀ ɓekǝ ɓwa atà amǝ'eam wun duk mǝtǝ̀r sǝ gandǝ pàkki ɓamúrì gbasha raka, dumǝna púp wun nǝ̀ pe wi gbasha kǝla mǝnana wun nǝ̀ pàkkî bǝri, sǝ ɓwa kúnɗàngna mana yiu a dola aɓalǝ wun ngga. ");
INSERT INTO mbu_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Wu kǝa ligir arǝì ɗàng, sǝ wu kǝa ak kǝ mùr amúr tangna mǝnana wu pe wi ka ɗàng. A kún mani ka wu ɓanggi Ɓakuli ma'wun, ace mǝnana mǝ'eam wun ngga ɓǝ̀ do a nkanggari wun. ");
INSERT INTO mbu_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kǝa pe wi tangna boalo nǝ alta mùr amurí ɗàng, sǝ kǝa pe wi girlina ace kum ligir arǝì ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mǝ nda Yahweh, Ɓakuli ma'wun, mǝnana pusǝ wun aɓa nzali Masar, ace pà wun nzali Kan'ana, sǝ mǝ duk Ɓakuli ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","<<Ɓǝ̀ mǝ'eambo duk mǝ'tǝ̀r a nkanggario, sǝ makko ɓamúrì ka, kǝa tsǝì ɓǝ̀ pàkkô túró kǝla guro ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Sǝama ɓǝ̀ do kǝla mǝ'túró-boalo atò, sǝ kǝla bǝri mana yiu ace dola ka. Nǝ̀ pàktúró atò ba pǝlǝa mala Pàkkiɗire-banɓoarnado. ");
INSERT INTO mbu_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Sǝ yì andǝ amuni ka, à nǝ̀ purî ɓala mò, à nǝ̀ nyare aban aɓwana male, a tàu male, sǝ a nzali mala akê. ");
INSERT INTO mbu_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Yia ka aguro mema, mǝnana ǝn pusǝia à purî ɓá nzali Masar ka; à pà nǝ̀ mea ɓǝà o a guro ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Pà wu nǝ̀ yálmuria nǝ ɗwanyi sǝn mǝsǝswatǝr ɗàng, wu ɓanggi Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Aguro mò aburana andǝ amamǝna mǝnana awu nǝ pàngŋǝ́nǝia ka, awu nǝ kúria arǝ anzali mǝnana à kàrì wun ngga. ");
INSERT INTO mbu_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Awu nǝ gandǝ kúr gbal atà amǝ'kúnɗàngna mǝnana à yiu a dola atà wun ngga, sǝ amǝɓala malea mǝnana à nda atà wun, mǝnana à ɓǝlia a nzali ma'wun ngga, à nǝ̀ duk agirkuma ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wun nǝ̀ gandǝ nyinggi amuna ma'wun kǝla agirkuma malea, mǝnana à nǝ̀ duk aguro a buia tàtǝ́k ka. Sǝama mala amǝ'eam wun, amǝ Isǝrayila ka, kǝɓwa pà nǝ̀ yálmúr ɓì nǝ ɓikido ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","<<Ɓǝ̀ bǝri ko ɓwa-kúnɗàngna mǝnana nda dola aɓalǝ wun, pǝlǝ mǝkume, sǝ mǝ'eam wun mǝnana a nkanggari ka pǝlǝ mǝ'tǝ̀r sǝ mak ɓamúrì aban bǝri ko ɓwa-kúnɗàngna mǝnia mana ndanǝdo aɓalǝ wun ngga, ko aban ɓeɓwa a tàu mala bǝri mǝnia ka, ");
INSERT INTO mbu_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","nǝ̀ do ama, anzǝm mana mangŋǝna ɓamúrì ka, ndanǝ njar a bui nǝ̀ akmúr ɓamúrì. Mwashat atà amǝ'eambi nǝ̀ gandǝ akmúrí, ");
INSERT INTO mbu_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ko kine ko muna mala kine ka nǝ̀ gandǝ akmúrí, ko ɓeɓwa atà acili aɓǝla-nggurkwar ko amǝɓala male nǝ̀ gandǝ akmúrí; ko ɓǝ̀ yì ka yi kum gìrbu ka, nǝ̀ gandǝ akmúr ɓamúrì. ");
INSERT INTO mbu_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yì ka nǝ̀ tàɓala andǝ ɓwa mǝnana kúrí ka amur kúró kum-ɓamúrû male twal a pǝlǝa mǝnana mangŋǝna ɓamúrì nǝi ka aban ká a pǝlǝa mala Pàkkiɗire-banɓoarnado, sǝ kúrè ka nǝ̀ pa kǝla mana làkkì mala apǝlǝe pàk ka. Kúró mala kumɓamuru male ka, à nǝ̀ kārǝí arǝ tangnakusǝu mana à kǝ mbwe mǝ'túró-boalo nǝi ka. ");
INSERT INTO mbu_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ɓǝ̀ apǝlǝa nakam pas piu mana à ue ka, boalo mana nǝ̀ mbwe ace akmúr ɓamúrì ka nǝ̀ pàk kpǝm. ");
INSERT INTO mbu_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Sǝ ɓǝ̀ apǝlǝe ue kpokyak sǝ pǝlǝa mala Pàkkiɗire-banɓoarnado nǝ̀ yiu ka, boalo mana nǝ̀ mbwe ace akmúr ɓamúrì ka nǝ̀ pàk bǝti. ");
INSERT INTO mbu_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Yì bǝri ka dumǝna púp nǝ̀ pàngnǝi kǝla mǝtúró mana à twali a túró-boalo sǝ à kǝ mbwe a masǝlǝata koya pǝlǝa ka. Pà nǝ̀ yálmúrí nǝ ɗwanyi sǝn mǝsǝswatǝr ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Sǝ ɓǝ̀ à akmúrí nǝ mǝno yì anjar raka, yì andǝ amuni ka, à nǝ̀ panzǝia aɓa pǝlǝa mala Pàkkiɗire-banɓoarnado. ");
INSERT INTO mbu_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Mǝ nda mǝnana amǝ Isǝrayila nda ka aguro abanam ngga. À nda ka aguro mem mǝnana ǝn pusǝia à purî ɓá nzali Masar ka: Mǝ nda Yahweh Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","<<Pà wun nǝ̀ pàkkî ɓamur rǝ wun ɓekǝ nkul ɗang, sǝ pà wun nǝ̀ shàr ɓekǝ ɓǝ̀nzál, ko wun nǝ̀ tamsǝ ɓekǝ nggun ko tali, ko wun nǝ̀ tsǝk kǝ kúnamúrú a nzali ma'wun ace mǝnana wun nǝ̀ peri abania ka ɗàng. Mim Yahweh ka, mǝ nda Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Dumǝna púp wun nǝ̀ kpata nzongcau mala Sabbat, yì pwari usǝlǝo, sǝ wun nǝ̀ dum nǝ pagulo arǝ Ban Mǝfele mem: Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","<<Ɓǝ̀ wu bwal anggurcau mem, sǝ wu kpata anzongcau mem, wu pea ka, ");
INSERT INTO mbu_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","mǝ nǝ tsǝa mbulo ma'wun nǝ̀ nggǝ nyaka wun a kúnì male, sǝ nzali ma'wun nǝ̀ pusǝa wun ɓǝle, sǝ anggun ɓaban ma'wun nǝ̀ pà ɓǝlea. ");
INSERT INTO mbu_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kúnì mala nyamessa nǝ̀ sauwa nǝ̀ ká a kúnì mala pwan ɓǝlanggun anap, sǝ kúnì mala pwan ɓǝlanggun anap ka, nǝ̀ sauwa nǝ̀ ká a kúnì mala ɓealɓeale; anggo ka wun nǝ̀ li girlina sheɓǝ̀ wu ɗǝmna ka; wun nǝ̀ do aɓa rǝpwala, kǝ mǝɓane pà nǝ̀ yiu arǝ wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Mǝ nǝ pà wun dorǝpwala aɓa nzali ma'wun, wun nǝ̀ nongnǝ-nongŋo sǝ kǝ ɓwa pà nǝ̀ yipa wun nǝ̀ ɓekǝ gìr pà ɓangciu ɗàng; mǝ nǝ pǝr anyamɓikea ɓǝà upi nzali ma'wun, sǝ nggeabyau mala ɓiu-mǝbura pa nǝ̀ kùtí a nzali ma'wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Wun nǝ̀ pǝrta aɓiwun amǝbura, sǝ nggeabyau ma'wun nǝ̀ gandǝia, à nǝ̀ kpaki a ɓadǝm wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Aɓwana ma'wun tongno nǝ̀ loasǝtà aɓwana gbǝman, sǝ aɓwana ma'wun gbǝman nǝ̀ loasǝtà aɓwana á-lum, sǝ nggeabyau ma'wun nǝ̀ gandǝ aɓiwun amǝbura, à nǝ̀ sukkio a nzali a ɓadǝm wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Earmúrú mem nǝ̀ sulǝo amur wun, sǝ mǝ nǝ tsǝk wun, wun nǝ̀ ɓǝla, wun nǝ̀ hatǝki; mǝ nǝ bwal kùrcau mem mǝnana ǝn pê nǝ wun ngga. ");
INSERT INTO mbu_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Wun nǝ̀ nggǝ li mǝssa mǝnana wu soe a bah aɓa pǝlǝa mǝnana kútí ka, gandǝa wun nǝ̀ pusǝ mǝssa mǝ'e a bah ace mǝnana wun nǝ̀ so bǝshe ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mǝ nǝ tsǝk Taragula mem, yì bando mem aɓalǝ wun sǝ pà mǝ nǝ ɓinǝki wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mǝ nǝ gya aɓalǝ wun sǝ mǝ nǝ duk Ɓakuli ma'wun, sǝ wun ngga, wun nǝ̀ duk aɓwana mem. ");
INSERT INTO mbu_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mǝ nda Yahweh Ɓakuli ma'wun, mǝnana pusǝ wun, wu purî ɓá nzali Masar, ace mǝnana wu kǝa duk aguro malea raka. Ən ɓungi agara-bolo mala nggun-rya malea a myal wun, sǝ ǝn tsǝk wun, wu ging pǝrapǝra. ");
INSERT INTO mbu_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","<<Sǝama ɓǝ̀ wu mgbikamkiru, wu ginǝ bwal anzongcau mem mǝnia kat, ");
INSERT INTO mbu_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","sǝ ɓǝ̀ wu ginǝ anê mem, sǝ yilǝmi wun nǝ̀ ɓinǝce anggurcau mem, mǝnana à nǝ̀ kánǝ wun a ɗwanyi kpata atsǝkcau mem, sǝ wun nǝ̀ panzǝki kùrcau mem ngga, ");
INSERT INTO mbu_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Mim a buì mem ngga mǝ nǝ pàkka wun agir mǝnia ka: Mǝ nǝ tasǝ gìr'mur'mwana hǝrkit amur wun, mǝ nǝ kwak wun nǝ kwánó mǝnana pà nǝ̀ mal ɗang, andǝ ɓauwa mǝnana nǝ̀ dumsǝ wun a nte andǝ do-tikimúrú ka. Wun nǝ̀ ɓeal mǝsǝɓeale ma'wun ɓà acemǝnana aɓiwun-amǝbura nǝ̀ ya lì gìr mǝnana ɓǝl ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mǝ nǝ pǝlǝa wun nzǝmam, mǝ nǝ ɗeki aɓiwun-amǝbura ɓǝà gandǝ wun. Aɓwana mǝnana à ɓinǝmǝsǝ wun ngga, à nǝ̀ duk amǝ'yálmúr wun. Wun nǝ̀ ɓangŋa ko ɓǝ̀ ndo ama kǝɓwa pà kàm kǝ pǝrta wun raka. ");
INSERT INTO mbu_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Sǝ kat andǝ amǝnia yì agir, ɓǝ̀ wu ginǝ okam ngga, mǝ nǝ lidǝmba nǝ pakka wun gìrkwanban ɗǝm mǝnana kàrmúr acauɓikea ma'wun kusǝ tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nggori andǝ murcandǝa ma'wun ngga mǝ nǝ ɓunni. Mǝ nǝ tsǝk ɓamǝsǝ kùli ma'wun nǝ̀ pàk gbǝrantang kǝla bolo-candǝa, sǝ nzali ma'wun nǝ̀ candǝ kanggǝrang kǝla bolo-bángŋá. ");
INSERT INTO mbu_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Rǝcandǝa ma'wun nǝ̀ malâ sǝ wu pàk kǝ túró ɗang: nzali ma'wun pà nǝ̀ pusǝa wun kǝ gìrɓaban ɗàng, sǝ anggun mǝnana aɓa nzali ma'wun ngga à pà nǝ̀ pà ɓǝlea ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","<<Sǝ ɓǝ̀ wu candǝcau arǝàm, wu ɓinǝ okam ngga, mǝ nǝ hatǝki tanni mǝnana kàrmúr acauɓikea ma'wun kusǝ tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mǝ nǝ tasǝ anyam-candǝa arǝ wun, à nǝ̀ yia wala wun amuna ma'wun, sǝ à nǝ̀ kiɗikia wun agirkusǝu mana wu kǝ yália ka. Aɓwana bǝti aɓalǝ wun na à nǝ̀ ueo nǝyilǝmu ka. Mǝnia ka nǝ̀ tsǝa aɓwana kpokyak na à nǝ̀ nggǝ gya amur anjargula mala nzali ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","<<Sǝ kat andǝ amǝnia yì agirkwanban, ɓǝ̀ wu ginǝ nyare abanam, wu lidǝmba nǝ mgbicau arǝàm ngga, ");
INSERT INTO mbu_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mim gbal ka mǝ nǝ camba wun a nggaro; mim nǝ nggearǝam mǝ nǝ kwak wun nǝ tanni mana kàrmúr acauɓikea ma'wun kusǝ tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mǝ nǝ yinǝ lwa amur wun mǝnana nǝ̀ mbwe wun a kúnì mǝɓane mana wu pè, mala yàl anzongcau mana ǝn tsǝka wun aɓa kùrcau mana ǝn pangnǝ wun ngga. Ko ɓǝ̀ wu ɓangŋa wu kutiki aɓalǝ anggea-là ma'wun ngga, mǝ nǝ tasǝ rǝkwana mǝ'kiɗikibanì aɓalǝ wun, sǝ wun nǝ̀ kpa a ɓabù aɓiwun-amǝbura. ");
INSERT INTO mbu_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Mǝ nǝ tamsǝ kum girlina ma'wun, sǝ mǝnia ka nǝ̀ tsǝa ovù mwashat na amamǝna lum nǝ̀ lurǝ bǝredi mǝnana kat à ndanǝi ka. Ɓǝ̀ à nǝ̀ gakki bǝredi ka, ɓwangine na koyan nǝ̀ kum ngga. Wun nǝ̀ li, sǝ pà nǝ̀ kārǝ́ wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","<<Sǝ kat andǝ mǝnia ka, ɓǝ̀ pà wun nǝ̀ ok cau mem ɗàng, wu lidǝmba nǝ mgbicau arǝàm ngga, ");
INSERT INTO mbu_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mǝ nǝ gingga wun a ngbasho aɓa nusǝban mala bumlulla mǝɓike, sǝ mim nǝ nggearǝam mǝ nǝ pakka wun gìrkwanban mǝnana kàrmúr acauɓikea ma'wun kusǝ tongno-nong-ɓari ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Wun nǝ̀ lì nyam amuna-burana andǝ amuna-mamǝna ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mǝ nǝ kìɗìki amgbangban ndàka-lú ma'wun, mǝ nǝ kwarki agyangŋan mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ma'wun, mǝ nǝ eamsǝki alú wun amúr alú ka nkúl ma'wun, sǝ yilǝmem ngga nǝ̀ ɓinǝce wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mǝ nǝ tsǝk anggea-là ma'wun ɓǝà pǝlǝ ɓarwan, sǝ andaka-ankúl ma'wun ɓǝà pak kèlàngkélàng, sǝ mǝ nǝ ɓinǝce rǝmba aɓoro mǝrǝmɓoarne ma'wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Mǝ nǝ pàk nzali ma'wun kèlàngkélàng, gandǝa aɓiwun-amǝbura mǝnana à yi e a do aɓalǝi ka, nǝ̀ kàrmúrià ɓǝ̀ à sǝni ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mǝ nǝ mesǝki wun arǝ anzali, mǝ nǝ kwetǝ nggeabyau mem a ndè mǝ nǝ pǝ̀rta wun, nzali ma'wun nǝ̀ pǝlǝ ɓarwan, sǝ anggea-là ma'wun nǝ̀ pǝlǝ gìgí. ");
INSERT INTO mbu_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","<<Nda wuni nzali ma'wun nǝ̀ ok banɓoarnado mala apǝlǝa Sabbat male aɓalǝ nonggio mǝnana kat nong ɓarwan, sǝ wun ngga wu nda a nzali mala aɓiwun amǝbura ka; pǝlǝa nzali ma'wun nǝ̀ usǝlǝo, sǝ nǝ̀ ok banɓoarnado mala apǝlǝa mala Sabbat male. ");
INSERT INTO mbu_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Aɓalǝ anonggio mǝnana kat nǝ̀ nong ɓarwan ngga, nzalinì nǝ̀ usǝlǝo, usǝlǝo mǝnana kumi raka aɓalǝ apǝlǝa mala Sabbat mana wu nda aban do aɓalǝi ka. ");
INSERT INTO mbu_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Sǝ aɓwana atà wun mǝnana à au ka, mǝ nǝ tasǝia wia ɓabum-ɓungya aɓa ɗenyicau malea arǝ abân mǝnana à umnǝia kàm aɓalǝ anzali mala aɓia-mǝbura ka. Gì dǝurǝo mala mbu-nggun nǝ̀ loasǝtea nǝ mire, sǝ à nǝ̀ ɓangŋa kǝla ɓwa mǝnana à kǝ pǝrte a lwa ka, sǝ à nǝ̀ nggá kpa, ko ɓǝ̀-ndo ama kǝɓwa pà kàm kǝ pǝrtea raka. ");
INSERT INTO mbu_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","À nǝ̀ anndǝki arǝarǝia, kǝla aɓwana mana à kǝ ɓangŋa ace apî nggeabyau ka, ko ɓǝ̀-ndo ama kǝɓwa pà kàm kǝ pǝrtea raka. Sǝ pà wun nǝ̀ gandǝ came a ɓadǝmbǝ aɓiwun amǝbura ɗang. ");
INSERT INTO mbu_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Wun nǝ̀ wukio arǝ abǝri-nzali; nzali mala aɓiwun amǝbura nǝ̀ twalta wun. ");
INSERT INTO mbu_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Sǝ cili wun mǝnana à ue nǝyilǝmu arǝ anzali mala aɓiwun amǝbura ka, à nǝ̀ twal eamdǝe atàcau mala ɓealɓikea malea, sǝ atàcau mala aɓealɓikea mala akeâ. ");
INSERT INTO mbu_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","<<Sǝama, ɓǝ̀ à bang ɓealɓikea malea, andǝ ɓealɓikea mala atárrià andǝ mala akeâ, mǝnana à pè nǝ ɗwanyi domǝsǝcau malea abanam, andǝ pǝlǝa mǝnana à pǝlǝ arǝàm, ");
INSERT INTO mbu_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","sǝ tsǝa ǝn pǝlǝ arǝia, sǝ ǝn tasǝia a bǝri-nzali, aɓa nzali mala aɓia-mǝbura, sǝ ɓǝ̀ ɓabumia nǝ̀ nying candǝcau malea à nǝ̀ nongsǝmúrià, sǝ à nǝ̀ mbwegìr ace ɓealɓikea malea ka, ");
INSERT INTO mbu_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","pǝlǝa mim ngga mǝ nǝ ɗenyinǝ kùrcau mem mǝnana ǝn pê nǝ Yakupu, sǝ mǝ nǝ ɗenyinǝ kùrcau mem mǝnana ǝn pê nǝ Ishaku, andǝ kùrcau mem mǝnana ǝn pê nǝ Ibǝrayim ngga. Mǝ nǝ ɗenyinǝ gir mǝnana ǝn pacau-ace amur nzali man ngga, ");
INSERT INTO mbu_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","sǝ mǝ nǝ ɗeki ɓǝ̀ ok banɓoarnado mala apǝlǝa mala Sabbat male arǝ apǝlǝa mǝnana nǝ̀ nong ɓarwan acemǝnana à pà kàm aɓa nzalinì raka, à umna a bǝri-nzali aban mbwegìr ace ɓealɓikea malea acemǝnana à ginǝki acau mem, sǝ yilǝmia ɓinǝce anê mem ngga. ");
INSERT INTO mbu_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Kat andǝ amǝno ka, ɓǝ̀ à nda kano a nzali mala aɓia-mǝbura ka, pà mǝ nǝ ginǝkia ɗàng, sǝ pà mǝ nǝ ɓinǝcea mǝnana nǝ̀ tsǝa mǝ nǝ twaltea ka ɗàng. Pà mǝ nǝ nggaɗikunam arǝ kùrcau mem sǝnǝia ɗàng, acemǝnana mǝ nda Yahweh Ɓakuli malea. ");
INSERT INTO mbu_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Atàcau malea ka ɓalǝam nǝ̀ kasǝa arǝ kùrcau mǝnana ǝn pangnǝ akeâ, mana ǝn pusǝia à purî ɓá nzali Masar, a mǝsǝ aɓwapǝndǝa mala anzali kat, ace mǝnana ɓǝ̀ ǝn duk Ɓakuli malea ka. Mǝ nda Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Amǝno ka à nda ka anê, andǝ akanìgìr andǝ anggurcau mana Yahweh pa anre andǝ amǝ Isǝrayila nǝ bu Musa amur Nkono Saina ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","<<Nacau nǝ amǝ Isǝrayila sǝ wu banggia wia ama, <Lang à pànà ɓwa ace lùmsǝ pàcau nǝ-shambum mǝnana ɓeɓwa pà abanam, Mim Yahweh ka, ɓwa mǝno à pà ka, à nǝ̀ gandǝ panzǝe nǝ mbwe boalo mǝnana à kasǝ ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Boalo mǝnana à kasǝa à nǝ̀ mbwe ka ɓǝà kārǝí arǝ shekel, yì mǝsǝbolo-azǝrfa mǝnana à kārǝ́ dǝmbǝrya male sǝ à earna amurí a Tara-mǝfele ka: shekel lumi-tongno (50) a kúnì ɓwabura mana pǝlǝa ɓǝlban male ka nda lumi-ɓari aban ká lumi-tongno-nong-mwashat ka; ");
INSERT INTO mbu_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","shekel lumi-tàrú (30) a kúnì ɓwama mana pǝlǝa ɓǝlban male ka nda lumi-ɓari aban ká lumi-tongno-nong-mwashat ka; ");
INSERT INTO mbu_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","shekel lumi-ɓari (20) a kúnì lagga mana pǝlǝa ɓǝlban male ka nda tongno aban ká lumi-ɓari ka; shekel lum (10) a kúnì nsari mana pǝlǝa ɓǝlban male ka nda tongno aban ká lumi-ɓari ka; ");
INSERT INTO mbu_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","shekel tongno (5) a kúnì muna-ɓwabura mana pǝlǝa ɓǝlban male ka nda zongŋo mwashat aban ká tongno ka; shekel tàrú (3) a kúnì muna-ɓwama mana pǝlǝa ɓǝlban male ka nda zongŋo mwashat aban ká tongno ka; ");
INSERT INTO mbu_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","shekel lum-nong-tongno (15) a kúnì ɓwabura mǝnana pǝlǝa ɓǝlban male ka kutini lumi-tongno-nong-mwashat (60) ka; shekel lum (10) a kúnì ɓwama mǝnana pǝlǝa ɓǝlban male ka kutini lumi-tongno-nong-mwashat (60) ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","<< <Ɓǝ̀ ɓwa ka tǝ̀r male ɓikipa mǝnana pà nǝ̀ gandǝ mbwe boalo mana à kasǝa ace panzǝ ɓwa ɓǝ̀ purî pàcau mǝnana pà ka raka, yì ka ɓǝ̀ yinǝ ɓamúrì a ɓadǝm pǝris, sǝ pǝris nǝ̀ kasǝ boalo mǝnana sǝni ɓwê mana pàcau ka nǝ̀ gandǝ mbwe ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","<< <Ɓǝ̀ pàcau mala ɓwa ka girkusǝu na mǝnana à nǝ̀ pa kǝla pàgir abanam Yahweh ka, mǝno yì girkusǝu à pà ka pǝlǝna mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ɓwê pà nǝ̀ nggaɗi, ko nǝ̀ yinǝ ɓe a kúnì ɗàng, ko mǝɓoarne a kúnì mǝɓane, ko mǝɓane a kúnì mǝɓoarne; sǝ yale ɓǝ̀ ɓwê nggaɗi kǝ girkusǝu a kúnì ɓè ka, girkusǝunì andǝ mǝno à nggaɗi ka, yia kǝm à pǝlǝna mǝfele. ");
INSERT INTO mbu_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Sǝ ɓǝ̀ girkusǝunì ka mǝɓeami na mǝnana à pà nǝ̀ pànàɓoro nǝi abanam, Mim Yahweh raka, ɓwê nǝ̀ tamsǝ girkusǝunì a ɓadǝm pǝris, ");
INSERT INTO mbu_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","sǝ yì pǝris ka nǝ̀ sǝn mana ɓoaro ko ɓike arǝ girkusǝunì sǝ nǝ̀ kasǝ kúrè; gìr mǝnana kat pǝris kasǝa ama nda kúrè ka anggo sǝ nǝ̀ pa. ");
INSERT INTO mbu_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Sǝ ɓǝ̀ ɓwê earce ama nǝ̀ akmúr girkusǝu mana pànà ka, dumǝna púp ama nǝ̀ mbwe boale sǝ nǝ̀ tsǝk banì mwashat aɓa gauwe tongno mala boale amurí. ");
INSERT INTO mbu_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","<< <Lang ɓwa tàr ɓala male sǝ pà kǝla pàgir mǝfele abanam Yahweh ka, pǝris nǝ̀ ká nǝ̀ sǝn mana ɓoaro ko ɓike arǝ ɓalanì sǝ nǝ̀ kasǝ kúrè; gìr mǝnana kat pǝris kasǝa ama nda kúrè ka anggo sǝ nǝ̀ pǎ. ");
INSERT INTO mbu_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Sǝ ɓǝ̀ ɓwê earce ama nǝ̀ akmúr ɓala mana pànà ka, dumǝna púp ama nǝ̀ mbwe boale sǝ nǝ̀ tsǝk banì mwashat aɓa gauwe tongno mala boale amurí. ");
INSERT INTO mbu_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","<< <Ɓǝ̀ ɓwa tàr ɓe bare nzali mǝnana girkuma male na sǝ pàmì ɓǝ̀ duk mem, Mim Yahweh ka, pǝris nǝ̀ karǝ boale arǝ gulo mala mǝsǝɓeale mǝnana à nǝ̀ ɓeali aɓalǝi ka. Tyang lumi-ɓari (20) mala mǝsǝ mǝssa bálì ka shekel lumi-tongno (50) mala mǝsǝbolo-azǝrfa na. ");
INSERT INTO mbu_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ɓǝ̀ ɓwê tàr nzali mǝnia aɓa pǝlǝa mala pàkkiɗire-banɓoarnado ka, boalo mǝnana pǝris kasǝa ama nda kúrè ka camna anggo. ");
INSERT INTO mbu_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Sǝ ɓǝ̀ nda anzǝm pǝlǝa mala pàkkiɗire-banɓoarnado sǝ ɓwê tàr nzali male ka, pǝris nǝ̀ kasǝ boale aɓa kpata làkkì mala apǝlǝa mǝnana à ueo sǝ à nǝ̀ bik ɓè pǝlǝa mala pàkkiɗire-banɓoarnado ka, sǝ à nǝ̀ amsǝ ɓegìr aɓa boale. ");
INSERT INTO mbu_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Sǝ ɓǝ̀ ɓwa mǝnana tàr nzalinì earce ama nǝ̀ akmúrí ka, dumǝna púp ama nǝ̀ mbwe boale andǝ banì mwashat aɓa gauwe tongno mala boale, sǝ nzalinì nǝ̀ nyar male ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Sǝama ɓǝ̀ ɓwê earce ama nǝ̀ akmúr nzalinì raka, ko ɓǝ̀ mangŋǝ́nì ɓeɓwa ka, à pà nǝ̀ eari wi ɓǝ̀ akmúrí ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Lang pǝlǝa mala pàkkiɗire-banɓoarnado nǝ̀ kàr ka, nzalinì nǝ̀ duk pagìr mǝfele, kǝla nzali mana à tàrnì acem, Mim Yahweh ka. Nǝ̀ duk girkuma mala apǝris. ");
INSERT INTO mbu_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","<< <Ɓǝ̀ nzali ka ɓwa kúrí nǝ kúró, pà aɓa gìr'liɓala male ɗàng, sǝ tàrì acem, Mim Yahweh ka, ");
INSERT INTO mbu_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","pǝris nǝ̀ kasǝ boale aɓa kpata làkkì mala apǝlǝa mǝnana à ueo sǝ à nǝ̀ bik ɓè pǝlǝa mala pàkkiɗire-banɓoarnado ka, sǝ ɓwê nǝ̀ mbwe boale, kǝla ɓoro mǝfele abanam, Mim Yahweh, a pwari mǝno. ");
INSERT INTO mbu_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sǝ ɓǝ̀ pǝlǝa mala pàkkiɗire-banɓoarnado kàrna ka, nzalinì nǝ̀ nyare a bù ɓwa mǝnana à kúrí a buì ka ɓǝ̀ duk girkuma male ɗǝm, yì ɓwa mǝnana nzalinì ka gìr'liɓala male na ɗiɗyal ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Koya boalo na à pà ka ɓǝà kārǝí arǝ shekel, yì mǝsǝbolo-azǝrfa mǝnana à kārǝ́ dǝmbǝrya male sǝ à eare amurí a Tara-mǝfele ka: Shekel mwashat ka mǝtyang lum-nong-ɓari na. ");
INSERT INTO mbu_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","<< <Sǝ amuna-dǝmba mala agirkusǝu ka cè kǝɓwa tària ɗàng, acemǝnana ɓǝlban malea kǝla amuna-dǝmba ka à tàrnia amema, Mim Yahweh; ko ɓǝ̀ ndǎ na, ko nzur na, ko mbul na ka, mema, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Sǝama ɓǝ̀ girkusǝunì ka mǝɓeami na ka, ɓwê nǝ̀ kúrí nǝ boalo mǝnana à kasǝa arǝì ka ace mǝnana ɓǝ̀ nyare a bui, sǝ nǝ̀ tsǝk banì mwashat aɓa gauwe tongno mala boale amurí; ɓǝ̀ à akmúr girkusǝunì raka, à nǝ̀ me a kún boalo mǝnana à kasǝa amurí ka. ");
INSERT INTO mbu_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","<< <Kat andǝ amani ka koyagir mǝnana ɓwa tàrni kat-kat abanam, Mim Yahweh ka, ko ɓwa na, ko girkusǝu na, ko nzali male mana à pe wi liɓala ka nda ka, à pà nǝ̀ me ko à nǝ̀ akmúrí ɗàng; koya gìr mǝnana à tàrni kat-kat abanam, Mim Yahweh ka, pǝlǝna nggea mǝfele abanam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ɓwapǝndǝa mǝnana kat à tàrni aɓalǝ aɓwana ace ká kìɗikè ka, ê pà kàm a kún kǝ boalo ɗàng; yì ka dumǝna púp ɓǝà wal-luí. ");
INSERT INTO mbu_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","<< <Koya kāmbe mala nzali mǝnana à sannì, ko mala mǝssa mǝnana à pwan a ɓaban, ko mala aɓǝla-nggun ngga, mema Mim Yahweh; dumǝna mǝfele na abanam Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ɓǝ̀ ɓwa earce ama nǝ̀ kúr ɓè bare kāmbe mwashat aɓa gauwe lum mala kume male ka, dumǝna púp nǝ̀ mbwe boale mana pǝris nǝ̀ kasǝ ka, sǝ nǝ̀ tsǝk banì mwashat aɓa gauwe tongno mala boale amurí. ");
INSERT INTO mbu_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Akāmbe mwashat aɓa gauwe lum mala adomwan mala andá, andǝ mala anzur, andǝ mala ambul kat, koya mwashat aɓa lum ateà mǝnana kúti nǝ ɓata gara mala yálgír ka, nǝ̀ duk mǝfele abanam, Mim Yahweh. ");
INSERT INTO mbu_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mǝtala agirkusǝunì pà nǝ̀ pelǝkia ace tàrki amǝɓoarne aɓalǝ amǝɓane ɗàng, sǝ pà nǝ̀ nggaɗi kǝɓè ɗàng. Ɓǝ̀ nggaɗi kǝ girkusǝu a kúnì ɓè ka, girkusǝunì andǝ mana à nggaɗi nǝi, yià kǝm ngga à dumǝna amǝfele; à pà nǝ̀ gandǝ akmúria ɗàng.> >> ");
INSERT INTO mbu_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Amǝno ka à nda ka anzongcau mǝnana Yahweh pè Musa ɓǝ̀ banggi amǝ Isǝrayila a Nkono Saina ka.");
INSERT INTO mbu_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yahweh nacau nǝ Musa aɓa Tara Ban-peri, a ɓabondo Saina, a pwari mǝdǝmbe mala ɓaria zongŋo, a ɓaria pǝlǝa, anzǝm mana amǝ Isǝrayila purni ɓá nzali Masar ka, ama, ");
INSERT INTO mbu_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","<<Ɓal ɓinala amǝ Isǝrayila kat; ɓallia arǝ atau, arǝ aɓala-kàu malea; gilǝ lullǝ koya mwashat aɓalǝ aburana, ");
INSERT INTO mbu_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","twal a pǝlǝa lumi-ɓari aban ká dǝmba, mala koya ɓwabura mǝnana nǝ̀ gandǝ ká lwa a Isǝrayila ka; we wunǝ Haruna ka wun nǝ̀ gilǝ làkkì mala amǝ'lwa malea. ");
INSERT INTO mbu_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Wu twal ɓwa mwashat a koya tàu, mǝnana ɓwamǝgule na a ɓala-kàu male ka, atà wun, ɓǝ̀ dupa wun gbasha. ");
INSERT INTO mbu_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Amǝnia ka à nda ka alullǝ aburana mǝnana à nǝ̀ dupa wun gbasha ka: Elizur muna-ɓwabura mala Shedeur a tàu mala Ruben; ");
INSERT INTO mbu_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Shelumiyel muna-ɓwabura mala Zurishaddai a tàu mala Shimiyon; ");
INSERT INTO mbu_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nashon muna-ɓwabura mala Aminadap a tàu mala Yahuda; ");
INSERT INTO mbu_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netanel muna-ɓwabura mala Zuar a tàu mala Isaka; ");
INSERT INTO mbu_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliyap muna-ɓwabura mala Helon a tàu mala Zebulu; ");
INSERT INTO mbu_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","atà amǝkà Yisǝfu ka: Elishama muna-ɓwabura mala Ammihud a tàu mala Ifǝrem, sǝ Gamaliyel muna-ɓwabura mala Pedazur a tàu mala Manasa; ");
INSERT INTO mbu_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abidan muna-ɓwabura mala Gidiyoni a tàu mala Benjami; ");
INSERT INTO mbu_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahieza muna-ɓwabura mala Amishaddai a tàu mala Dan; ");
INSERT INTO mbu_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagiyel muna-ɓwabura mala Okran a tàu mala Asha; ");
INSERT INTO mbu_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eliyasaf muna-ɓwabura mala Dewel a tàu mala Gad; ");
INSERT INTO mbu_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","sǝ Ahira muna-ɓwabura mala Enan a tàu mala Naftali. ");
INSERT INTO mbu_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Amǝnia ka à nda ka aburana mǝnana à tària aɓa ɓwabundǝa ace túró ka; à nda ka amúrû amur atau mala akeâ; à nda ka aɓwana-mǝgule amur aɓala mala amǝ Isǝrayila.>> ");
INSERT INTO mbu_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Nda Musa andǝ Haruna twal aburana mǝnia à tunǝ alullǝia ka, ");
INSERT INTO mbu_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","sǝ à tunǝ ramba mala ɓwabundǝa kat a banɓwáná, a pwari mǝdǝmbe mala ɓaria zongŋo. Pǝlǝa à gilǝ làkkì mala aɓwana kat arǝ atau sǝ arǝ aɓala-kàu malea, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba ka à gilǝ lullǝi, ");
INSERT INTO mbu_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kǝla mana Yahweh banggi Musa ka. Anggo sǝ gilǝ làkkì malea a ɓabondo Saina. ");
INSERT INTO mbu_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Tite nǝ amǝkà Ruben, muna-dǝmba mala Isǝrayila, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","à kum làkkì mala aburana a tàu mala Ruben ɓwa á-lumi-ine-bwamdǝ-tongno-nong-mwashat nǝ gbǝman-tongno (46,500). ");
INSERT INTO mbu_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Atà amǝkà Shimiyon ngga, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","à kum làkkì mala aburana a tàu mala Shimiyon, ɓwa á-lumi-tongno-bwamdǝ-tongno-nong-ine nǝ gbǝman-tàrú (59,300). ");
INSERT INTO mbu_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Atà amǝkà Gad ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","à kum làkkì mala aburana a tàu mala Gad ɓwa á-lumi-ine-bwamdǝ-tongno nǝ gbǝman-tongno-nong-mwashat nǝ lumi-tongno (45,650). ");
INSERT INTO mbu_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Atà amǝkà Yahuda ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","à kum làkkì mala aburana a tàu mala Yahuda ɓwa á-lumi-tongno-nong-ɓari-bwamdǝ-ine nǝ gbǝman-tongno-nong-mwashat (74,600). ");
INSERT INTO mbu_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Atà amǝkà Isaka ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","à kum làkkì mala aburana a tàu mala Isaka ɓwa á-lumi-tongno-bwamdǝ-ine nǝ gbǝman-ine (54,400). ");
INSERT INTO mbu_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Atà amǝkà Zebulu ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","à kum làkkì mala aburana a tàu mala Zebulu ɓwa á-lumi-tongno-bwamdǝ-tongno-nong-ɓari nǝ gbǝman-ine (57,400). ");
INSERT INTO mbu_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Atà amǝkà Yisǝfu, nǝban muna-ɓwabura male Ifǝrem ngga, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","à kum làkkì mala aburana a tàu mala Ifǝrem ɓwa á-lumi-ine nǝ gbǝman-tongno (40,500). ");
INSERT INTO mbu_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Sǝ nǝban muna-ɓwabura male Manasa ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","à kum làkkì mala aburana a tàu mala Manasa ɓwa á-lumi-tàrú-nong-ɓari nǝ gbǝman-ɓari (32,200). ");
INSERT INTO mbu_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Atà amǝkà Benjami ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","à kum làkkì mala aburana a tàu mala Benjami ɓwa á-lumi-tàrú-bwamdǝ-tongno nǝ gbǝman-ine (35,400). ");
INSERT INTO mbu_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Atà amǝkà Dan ngga, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","à kum làkkì mala aburana a tàu mala Dan ɓwa á-lumi-tongno-nong-mwashat-nong-ɓari nǝ gbǝman-tongno-nong-ɓari (62,700). ");
INSERT INTO mbu_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Atà amǝkà Asha ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","à kum làkkì mala aburana a tàu mala Asha ɓwa á-lumi-ine-nong-mwashat nǝ gbǝman-tongno (41,500). ");
INSERT INTO mbu_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Atà amǝkà Naftali ka, à gilǝ lullǝ koya mwashat atà aburana arǝ atau, arǝ aɓala-kàu malea, kǝla mǝnana làkkì mala alullǝia pàk ka mwashat-mwashat, koya ɓwabura mǝnana pǝlǝa male bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana nǝ̀ gandǝ ká lwa ka; ");
INSERT INTO mbu_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","à kum làkkì mala aburana a tàu mala Naftali ɓwa á-lumi-tongno-bwamdǝ-á-tàrú nǝ gbǝman-ine (53,400). ");
INSERT INTO mbu_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Mǝnia ka nda làkkì mala aburana mǝnana Musa andǝ Haruna ɓallia ka, atārǝia andǝ aburana lum-nong-ɓari, aɓwana-mǝgule amur amǝ Isǝrayila mǝnana koyan ngga nda ace ɓala-kàu male ka. ");
INSERT INTO mbu_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Amǝ Isǝrayila mǝnana kat pǝlǝa malea bingŋǝna lumi-ɓari aban ká dǝmba, mǝnana à nǝ̀ gandǝ ká lwa a Isǝrayila ka, à ɓallia kǝla mana à pa arǝ aɓala-kàu malea ka. ");
INSERT INTO mbu_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Làkkì malea kat-kat ka nda á-gbǝman-tongno-nong-mwashat-bwamdǝ-tàrú nǝ gbǝman-tongno nǝ lumi-tongno (603,550). ");
INSERT INTO mbu_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Sǝama Amǝ'Lawi a tàu mala akeâ ka, à ɓallia atà aɓwana ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Nda acemǝnana Yahweh bangŋǝ́nì Musa cau ama, ");
INSERT INTO mbu_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","<<She kǝ tàu mala Lawi nda mǝnana a pà nǝ ɓalli raka, sǝ a pà nǝ gilǝ làkkì malea atà amǝ Isǝrayila ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","A kún mani ka awu nǝ twal Amǝ'Lawi ɓǝà duk amǝ'tsǝkir Taragula mala Acau-nakûn, andǝ agirtúró male kat, andǝ agir mǝnana kat à nda ace ka. À nda à nǝ̀ nggǝ twal Taragula andǝ agirtúró male kat ka; à nda à nǝ̀ ɗenyinǝi sǝ à nǝ̀ tsǝki agumli malea ɓǝà kàrì a tsùrú mala kàttì ka. ");
INSERT INTO mbu_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","A pwari mǝnana kat à nǝ̀ panzǝ Taragula ace tùr là-gumli ka, Amǝ'Lawi na à nǝ̀ panzǝki ka, sǝ a ban mǝnana kat à nǝ̀ kwaki Taragula kàm ngga, Amǝ'Lawi na à nǝ̀ pàk túrè ka. Ɓǝ̀ ɓwa-ɗàng gbashi banì ka ɓǝà wal-luí. ");
INSERT INTO mbu_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Amǝ Isǝrayila nǝ̀ tsǝk agumli malea, koya tàu ka a kàttì male, sǝ koya ɓwa ka a ban tútà mala tàu male, arǝ anggǝsan mala amǝ'lwa malea. ");
INSERT INTO mbu_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Sǝ Amǝ'Lawi ka, à nǝ̀ tsǝki agumli malea ɓǝà kàrì Taragula mala Acau-nakûn a tsùrú, ace mǝnana bumlulla mem ɓǝkǝa sulǝo amur ɓinado mala amǝ Isǝrayila raka. Amǝ'Lawi ka à nda mǝnana túró yál Taragula mala Acau-nakûn na amúrià ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Amǝ Isǝrayila pàk koya gìr kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yahweh banggi Musa andǝ Haruna ama: ");
INSERT INTO mbu_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","<<Amǝ Isǝrayila ɓǝà tsǝki agumli arǝ akattì malea zak nǝ ban Tara Ban-peri, koya gumli a kàttì ka ɓǝ̀ ɓamǝsǝi pǝlǝ nǝban Tara Ban-peri a koya buì; koyan ngga a ban tútà nǝ baji mala ɓala-kàu malea. ");
INSERT INTO mbu_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Amǝ Isǝrayila mǝnana à nǝ̀ tsǝk agumli malea a njar-takuli, a buì mala eauwe mala pwari ka, à nda ka anggǝsan mala amǝ'lwa aɓata tútà mala kàttì mala Yahuda. Ɓwa mǝnana nǝ̀ duk ɓwamǝgule amur amǝkà Yahuda ka nda Nashon, muna-ɓwabura mala Aminadap; ");
INSERT INTO mbu_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno-nong-ɓari-bwamdǝ-ine nǝ gbǝman-tongno-nong-mwashat (74,600). ");
INSERT INTO mbu_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Amǝnana à nǝ̀ tsǝk agumli malea a nkanggaria ka nda tàu mala Isaka, sǝ ɓwamǝgule amur amǝkà Isaka ka nda Netanel, muna-ɓwabura mala Zuar; ");
INSERT INTO mbu_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno nǝ á-ine nǝ gbǝman-ine (54,400). ");
INSERT INTO mbu_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Pǝlǝa tàu mala Zebulu nǝ̀ kpa; ɓwamǝgule amur amǝ'kà Zebulu ka nda Eliyap, muna-ɓwabura mala Helon, ");
INSERT INTO mbu_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","sǝ amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno nǝ á-tongno-nong-ɓari nǝ gbǝman-ine (57,400). ");
INSERT INTO mbu_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yià mǝno kat à ɓallia arǝ anggǝsan mala amǝ'lwa malea a kàttì mala Yahuda ka, làkkì malea na á-gbǝman-mwashat nǝ á-lumi-tongno-nong-tàrú nǝ á-tongno-nong-mwashat nǝ gbǝman-ine (186,400). Yia na à nǝ̀ tita lo gya ka. ");
INSERT INTO mbu_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","<<Amǝ Isǝrayila mǝnana a njar-kunmur ka, à nda ka anggǝsan mala amǝ'lwa mala kàttì mala Ruben aɓata tútà malea; ɓwamǝgule amur amǝkà Ruben ngga nda Elizur, muna-ɓwabura mala Shedeur; ");
INSERT INTO mbu_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-ine nǝ á-tongno-nong-mwashat nǝ gbǝman-tongno (46,500). ");
INSERT INTO mbu_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Sǝ aɓwana mǝnana à nǝ̀ tsǝk agumli malea a nkanggaria ka nda tàu mala Shimiyon; ɓwamǝgule amur amǝkà Shimiyon ngga nda Shelumiyel, muna-ɓwabura mala Zurishaddai; ");
INSERT INTO mbu_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno nǝ á-tongno-nong-ine nǝ gbǝman-tàrú (59,300). ");
INSERT INTO mbu_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Pǝlǝa tàu mala Gad nǝ̀ kpa, sǝ ɓwamǝgule amur amǝkà Gad ka nda Eliyasaf, muna-ɓwabura mala Rewel; ");
INSERT INTO mbu_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-ine nǝ á-tongno nǝ gbǝman-tongno-nong-mwashat nǝ lumi-tongno (45,650). ");
INSERT INTO mbu_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Yià mǝno kat à ɓallia arǝ anggǝsan mala amǝ'lwa malea a kàttì mala Ruben ngga, làkkì malea na á-gbǝman-mwashat nǝ á-lumi-tongno nǝ á-mwashat nǝ gbǝman-ine nǝ lumi-tongno (151,450). À nda ka ɓaria aɓwana aɓa lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","<<Anzǝm Ruben ngga Amǝ'Lawi nǝ agir mala Tara Ban-peri a buia ka, à nǝ̀ lo gya a tsùrú mala akattì; à nǝ̀ lo gya kǝla mana à tsǝì ace bwal kàttì ka, koyan ngga a ban male aɓata tútà male. ");
INSERT INTO mbu_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","<<Amǝ Isǝrayila mǝnana à nǝ̀ pa a njar-nzali ka, à nda ka anggǝsan mala amǝ'lwa mala kàttì mala Ifǝrem aɓata tútà malea; ɓwamǝgule amur amǝkà Ifǝrem ngga nda Elishama, muna-ɓwabura mala Ammihud; ");
INSERT INTO mbu_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-ine nǝ gbǝman-tongno (40,500). ");
INSERT INTO mbu_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Aɓwana mǝnana a nkanggaria ka nda tàu mala Manasa; ɓwamǝgule amur amǝkà Manasa ka nda Gamaliyel, muna-ɓwabura mala Pedazur; ");
INSERT INTO mbu_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tàrú nǝ á-ɓari nǝ gbǝman-ɓari (32,200). ");
INSERT INTO mbu_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Pǝlǝa tàu mala Benjami nǝ̀ kpa, sǝ ɓwamǝgule amur amǝkà Benjami ka nda Abidan, muna-ɓwabura mala Gidiyoni; ");
INSERT INTO mbu_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tàrú nǝ á-tongno nǝ gbǝman-ine (35,400). ");
INSERT INTO mbu_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Yià mǝno kat à ɓallia arǝ anggǝsan mala amǝ'lwa malea a kàttì mala Ifǝrem ngga, làkkì malea na á-gbǝman-mwashat nǝ á-tongno-nong-tàrú nǝ gbǝman-mwashat (108,100). À nda ka tàruia aɓwana aɓa lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","<<Amǝ Isǝrayila mǝnana à nǝ̀ pà a njar-nza ka, à nda ka anggǝsan mala amǝ'lwa mala kàttì mala Dan aɓata tútà malea; ɓwamǝgule amur amǝkà Dan ngga nda Ahieza, muna-ɓwabura mala Amishaddai; ");
INSERT INTO mbu_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno-nong-mwashat nǝ á-ɓari nǝ gbǝman-tongno-nong-ɓari (62,700). ");
INSERT INTO mbu_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aɓwana mǝnana à nǝ̀ tsǝk agumli malea a nkanggaria ka nda tàu mala Asha; ɓwamǝgule amur amǝkà Asha ka nda Pagiyel, muna-ɓwabura mala Okran; ");
INSERT INTO mbu_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-ine nǝ á-mwashat nǝ gbǝman-tongno (41,500). ");
INSERT INTO mbu_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Pǝlǝa tàu mala Naftali nǝ̀ kpa, sǝ ɓwamǝgule amur amǝkà Naftali ka nda Ahira, muna-ɓwabura mala Enan; ");
INSERT INTO mbu_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","amǝ'lwa mǝnana à ɓallia a nggǝsan male ka, làkkì malea na á-lumi-tongno nǝ á-tàrú nǝ gbǝman-ine (53,400). ");
INSERT INTO mbu_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Yià mǝno kat à ɓallia a kàttì mala Dan ngga, làkkì malea na á-gbǝman-mwashat nǝ á-lumi-tongno nǝ á-tongno-nong-ɓari nǝ gbǝman-tongno-nong-mwashat (157,600). À nda ka amǝ'tànkwàng aɓa lo gya.>> ");
INSERT INTO mbu_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Amǝnia ka à nda ka amǝ Isǝrayila mana à ɓallia arǝ aɓala-kàu malea ka. Yià mǝno kat à ɓallia arǝ akattì malea, arǝ anggǝsan mala amǝ'lwa malea ka, làkkì malea na á-gbǝman-tongno-nong-mwashat nǝ á-tàrú nǝ gbǝman-tongno nǝ lumi-tongno (603,550). ");
INSERT INTO mbu_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sǝama Amǝ'Lawi ka à ɓallia atà amǝ Isǝrayila ɗàng, kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Anggo sǝ amǝ Isǝrayila pa. À kpata cau mǝnana kat Yahweh banggi Musa ka, sǝ anggo sǝ à duk kàttì aɓata atútà malea, sǝ anggo gbal sǝ à puro aban ká, koyan ngga a tàu andǝ ɓala-kàu male. ");
INSERT INTO mbu_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Amǝnia ka à nda ka amuna andǝ amǝkà Haruna andǝ Musa mǝnana à gilǝia a bàkú mana Yahweh bangcau nǝ Musa a Nkono Saina ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Amuna-burana mala Haruna ka à nda ka Nadap muna-dǝmba, andǝ Abihu, andǝ Eleaza sǝ Itamar. ");
INSERT INTO mbu_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Amǝnia ka à nda ka alullǝ amuna-burana mala Haruna mǝnana à ɗārǝia sǝ à kùria wia túró-pǝris ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Sǝama Nadap andǝ Abihu ka à wǔ a ɓadǝm Yahweh acemǝnana à pàgir nǝ bǝsa mǝnana mala Ɓakuli na raka, a ɓadǝm Yahweh a ɓabondo Saina, sǝ à pànǝ amuna ɗang. Acemani ka, kǝ Eleaza andǝ Itamar na à pàk túró-pǝris atà tárrià Haruna ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Pǝlǝa Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","<<Yinǝ tàu mala Lawi ɓǝà sung tù sǝ ɓǝà yi came a ɓadǝm Haruna pǝris, ace mǝnana ɓǝà pàkki wi gbasha aɓa túró ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","À nǝ̀ pàkki atúró mǝnana amale na ka, sǝ à nǝ̀ pàkkî amǝ Isǝrayila atúró mǝnana à nda cea a ɓinalea ka, a ɓadǝm Tara Ban-peri, a ban pàk túró aɓa Taragula. ");
INSERT INTO mbu_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Yià na à nǝ̀ yál agir mǝnana aɓa Tara Ban-peri ka, sǝ à nǝ̀ pàk atúró mǝnana nda ace amǝ Isǝrayila, a ban túró aɓa Taragula ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Twal Amǝ'Lawi, pè Haruna andǝ amuna-burana male; ǝn tarnia aɓalǝ amǝ Isǝrayila kat ace bwali wi túró. ");
INSERT INTO mbu_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Awu nǝ twal Haruna andǝ amuna-burana male ɓǝà bwal dobuno-pǝris malea. Sǝ ɓǝ̀ ɓekǝ ɓwa-ɗàng gbàshìban ban-mǝfele ka, dumǝna púp à nǝ̀ wal-luí.>> ");
INSERT INTO mbu_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ɗǝm ngga Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","<<Sǝni, ǝn twalǝna Amǝ'Lawi aɓalǝ amǝ Isǝrayila a kúnì koya muna-dǝmba mǝnana nda tita puro a bum nggé atà amǝ Isǝrayila ka. Amǝ'Lawi nǝ̀ duk amem, ");
INSERT INTO mbu_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","acemǝnana amuna-dǝmba kat ka amem na. A pwari mǝno ǝn wal amuna-dǝmba kat aɓa nzali Masar ka, ǝn tárì ɓamúràm amuna-dǝmba kat a Isǝrayila, amala aɓwapǝndǝa andǝ amala agirkusǝu kǝm. À nǝ̀ duk amem: Mǝ nda Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yahweh nacau nǝ Musa a ɓabondo Saina, ama, ");
INSERT INTO mbu_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","<<Ɓal amuna-burana mala Lawi arǝ aɓala-kàu malea sǝ arǝ anggurkwar malea; koya muna-ɓwabura mǝnana à ɓǝli pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba ka awu nǝ ɓalli.>> ");
INSERT INTO mbu_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Nda Musa ɓallia kǝla mana Yahweh banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Sǝ amǝnia ka à nda ka alullǝ amuna-burana mala Lawi: Gashon andǝ Kohat andǝ Merari. ");
INSERT INTO mbu_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Sǝ amǝnia ka à nda ka amuna-burana mala Gashon: Libǝni andǝ Shimeyi; koyan ngga a nggurkwar male. ");
INSERT INTO mbu_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Sǝ amuna-burana mala Kohat ka à nda ka: Amram, andǝ Izǝhar, andǝ Hebǝron, andǝ Uziyel; koyan ngga a nggurkwar male. ");
INSERT INTO mbu_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Amuna-burana mala Merari ka, à nda ka: Mali andǝ Mushi; koyan ngga a nggurkwar male. Amǝnia ka, à nda ka anggurkwar mala Amǝ'Lawi, arǝ aɓala-kàu malea. ");
INSERT INTO mbu_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Aɓwana a nggurkwar mala Amǝ'Libǝni andǝ nggurkwar mala Amǝ'Shimeyi ka à nda ka amǝɓala mala Gashon. À nda ka amǝ'Gashon arǝ anggurkwar malea. ");
INSERT INTO mbu_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Amuna-burana mǝnana à ɓǝlia, à pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba, mǝnana à ɓallia ka, làkkì malea na á-tongno-nong-ɓari nǝ gbǝman-tongno (7,500). ");
INSERT INTO mbu_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Aɓwana mana arǝ anggurkwar mala amǝ'Gashon ngga à nǝ̀ tsǝk kàttì malea anzǝm Taragula a njar-nzali, ");
INSERT INTO mbu_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","sǝ Eliyasaf, muna-ɓwabura mala Layel ka nda nǝ̀ duk múrû amur ɓala-kàu mala amǝ'Gashon ngga. ");
INSERT INTO mbu_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Túró mala amuna-burana mala Gashon ngga nda yál Taragula, andǝ Tara mǝfele andǝ alagìr male mana à gìrì ka, andǝ lagìr gbar bankutio male, ");
INSERT INTO mbu_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","andǝ alagìr mǝnana à kàrì patal ka, andǝ lagìr mala gbar bankutio aɓa patal mǝnana kàrì Taragula andǝ gyangŋan ngga, andǝ anggur, andǝ agirtúró mǝnana kat à kǝ pangŋǝ̀nà túró nǝia ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amǝkà Kohat ka, à nda ka nggurkwar mala Amǝ'Amram, andǝ nggurkwar mala Amǝ'Izǝhar, andǝ nggurkwar mala Amǝ'Hebǝron, andǝ nggurkwar mala Amǝ'Uziyel; yià mǝnia ka à nda ka anggurkwar mala amǝ'Kohat. ");
INSERT INTO mbu_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Aɓa ɓal koya muna-ɓwabura mǝnana à ɓǝli pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba ka, à kum làkkì malea á-tongno-nong-tàrú nǝ gbǝman-tongno-nong-mwashat (8,600). Túró yál ban-mǝfele ka nda a buia. ");
INSERT INTO mbu_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Anggurkwar mala amuna andǝ amǝkà Kohat nǝ̀ tsǝk kàttì malea a buì mala Taragula mǝnana sǝn njar-kunmur ka, ");
INSERT INTO mbu_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","sǝ Elizafan, muna-ɓwabura mala Uziyel na nǝ̀ duk ɓwamǝgule amur aɓala-kàu mala anggurkwar mala amǝ'Kohat ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Túró malea nda yál Akwati, andǝ kpamgbang-tsǝk-agir, andǝ gìr-tàmsǝ pitǝla, andǝ agyangŋan, andǝ agirtúró mǝnana apǝris kǝ pangŋǝ̀nà túró nǝia a ban-mǝfele ka, andǝ lagìr-kasǝbân; koya túró mǝnana kat je amǝnia yì agir ka, à nǝ̀ pè. ");
INSERT INTO mbu_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Sǝ Eleaza muna-ɓwabura mala Haruna, yì pǝris ka nda nǝ̀ duk múrû amur aɓwana-mǝgule mala Amǝ'Lawi, sǝ nǝ̀ tsǝk-mǝsǝì arǝ aɓwana mǝnana kat à kǝ̀ pàkki atúró aɓa ban-mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Amǝkà Merari ka, à nda ka nggurkwar mala Amǝ'Mali, andǝ nggurkwar mala Amǝ'Mushi: Amǝnia ka à nda ka anggurkwar mala Merari. ");
INSERT INTO mbu_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Aɓwana mǝnana à ɓallia, yì amuna-burana mǝnana kat ɓǝlia ka, à pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba ka, à kum làkkì malea á-tongno-nong-mwashat nǝ gbǝman-ɓari (6,200). ");
INSERT INTO mbu_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Sǝ ɓwamǝgule amur ɓala-kàu mala anggurkwar mala Merari ka nda Zuriyel, muna-ɓwabura mala Abihel. À nda à nǝ̀ tsǝk kàttì malea a buì mala Taragula mǝnana sǝn njar-nza ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Sǝ túró mǝnana à kàsǝî amuna-burana mala Merari ka nda tsǝkir anggun-tara mala Taragula, andǝ anggun-gangndea, andǝ anggun-ɓalǝu, andǝ agumtǝli-tǝrteà, andǝ agirtúró male kat; koya túró mǝnana kat je amǝnia yì agir ka, à nǝ̀ pè; ");
INSERT INTO mbu_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ɗǝm ngga à nǝ̀ tsǝkir anggun-kala mǝnana à kàrì patal ka, andǝ agumtǝli-tǝrteà, andǝ ankpako tara, andǝ anggúr malea. ");
INSERT INTO mbu_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aɓwana mǝnana à nǝ̀ tsǝk kàttì malea aɓadǝm Taragula a buì mǝnana sǝn njar-takuli, aɓadǝm Tara Ban-peri a buì mala eauwe mala pwari ka, à nda ka Musa andǝ Haruna andǝ amuna-burana male. Tsǝkir Taragula andǝ yálè ka nda a buia ace lùmsǝ atúró mǝnana à nǝ̀ peǎ ace amǝ Isǝrayila ka. Sǝ ɓǝ̀ ɓekǝ ɓwa-ɗàng gbàshìbanì ka à nǝ̀ wal-luí ");
INSERT INTO mbu_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Làkkì mala Amǝ'Lawi mǝnana Yahweh banggi Musa andǝ Haruna ama ɓǝà ɓallia arǝ anggurkwar malea, koya muna-ɓwabura mǝnana à ɓǝli pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba ka, nda á-lumi-ɓari-nong-ɓari (22,000). ");
INSERT INTO mbu_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Sǝ Yahweh banggi Musa ama, <<Ɓal amuna-dǝmba amuna-burana mala amǝ Isǝrayila kat, amǝnana ɓǝlia ka, à pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba ka, sǝ wu gilǝ alullǝia. ");
INSERT INTO mbu_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ak Amǝ'Lawi ɓǝà duk amem, a kúnì amuna-dǝmba kat atà amǝ Isǝrayila, sǝ agirkusǝu mala Amǝ'Lawi a kúnì amuna-dǝmba kat mala agirkusǝu mala amǝ Isǝrayila. Mǝ nda Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Nda Musa ɓal amuna-dǝmba kat mala amǝ Isǝrayila, kǝla mana Yahweh banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Làkkì mala amuna-dǝmba amuna-burana kat-kat, mǝnana ɓǝlia ka à pàngŋǝ̀nà zongŋo mwashat aban ká dǝmba, kǝla mana à gilǝ alullǝia ka, à nda á-lumi-ɓari-nong-ɓari nǝ gbǝman-ɓari nǝ lumi-tongno-nong-ɓari nǝ mǝsǝi tàrú (22,273). ");
INSERT INTO mbu_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Sǝ Yahweh bangcau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","<<Ak Amǝ'Lawi a kúnì amuna-dǝmba mala amǝ Isǝrayila kat, sǝ agirkusǝu mala Amǝ'Lawi a kúnì amalea. Amǝ'Lawi nǝ̀ duk amem. Mǝ nda Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Sǝ ace mbwe boalo akmúr amuna-dǝmba mǝnia gbǝman-ɓari nǝ lumi-tongno-nong-ɓari nǝ mǝsǝi tàrú (273) mana làkkì malea eauwe amur làkkì mala Amǝ'Lawi ka, ");
INSERT INTO mbu_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","awu nǝ ak shekel tongno a kúnì koyan ateà; ak boale aɓa kpata dǝmbǝrya mala shekel, yì mǝsǝbolo-azǝrfa mǝnana à kārǝ́ dǝmbǝrya male sǝ à earna amurí a Tara-mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Pè Haruna andǝ amuna-burana male boalo mala akmúr amǝ Isǝrayila mǝnia mana làkkì malea eau ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Nda Musa ak boalo mala akmúrú mǝnia ka a bu aɓwana mana làkkì malea eapi mala aɓwana mana Amǝ'Lawi akmúria ka. ");
INSERT INTO mbu_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","A bu amuna-dǝmba mala amǝ Isǝrayila ka, ak boalo shekel á-mwashat nǝ gbǝman-tàrú nǝ lumi-tongno-nong-mwashat nǝ mǝsǝi tongno (1,365); À kpata shekel mala Tara-mǝfele. ");
INSERT INTO mbu_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Sǝ Musa pè Haruna andǝ amuna-burana male boalo mala akmúrú mǝnia ka, kǝla mana Yahweh banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yahweh bangcau nǝ Musa andǝ Haruna, ama, ");
INSERT INTO mbu_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","<<Ɓal làkkì mala amuna-burana mala Kohat aɓalǝ Amǝ'Lawi, arǝ anggurkwar malea sǝ arǝ aɓala-kàu malea. ");
INSERT INTO mbu_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ɓal aburana mǝnana kat pǝlǝa malea na lumi-tàrú aban ká lumi-tongno, mǝnana à kārǝ́na à nǝ̀ pàk túró aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","<<Túró mala amǝ'Kohat aɓa Tara Ban-peri ka nda tsǝkir agir nggea-mǝfele andǝ yália. ");
INSERT INTO mbu_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lang kàttì nǝ̀ lo ace o ka, Haruna andǝ amuna-burana male nǝ̀ kùtí aɓa Ban Nggea Mǝfele, sǝ à nǝ̀ sulǝ lagìr-kasǝbân sǝ à nǝ̀ gìr Akwati mala Acau-nakûn nǝi. ");
INSERT INTO mbu_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Pǝlǝa à nǝ̀ kùmsǝi wi nggu-mbulpǝndǝa amurí, sǝ à nǝ̀ sárǝ́ nggubyau mǝnana mùr-rǝì ka mǝlùre na kat ka amurí, sǝ à nǝ̀ oasǝi wi agare. ");
INSERT INTO mbu_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","<<À nǝ̀ sárǝ́ nggubyau mǝlùre amúr kpamgbang mala Bǝredi Ɓadǝm Yahweh. Amur nggubyau man ngga, à nǝ̀ tsǝk aparanti, andǝ atasau (ace muku-gìr loasǝ yele mǝ'rǝmɓoarne), andǝ amuna-nkenye, andǝ amuna-bàng ace pàgir mala girnùná; sǝ bǝredi mana ndakam koya pwari ka, nǝ̀ pàk kàm gbal. ");
INSERT INTO mbu_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pǝlǝa à nǝ̀ sárǝ́ nggubyau mǝbangye amúrià, à nǝ̀ kùmsǝ múrià nǝ nggu-mbulpǝndǝa, sǝ à nǝ̀ oasǝi wi agare. ");
INSERT INTO mbu_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","<<À nǝ̀ twal nggubyau mǝlùre sǝ à nǝ̀ gìrna gìr-tàmsǝ pitǝla mana nda ace pà tǎlaban ngga, atārǝia andǝ apitǝla male, andǝ amǝmyal male, andǝ atasau-bǝsa, andǝ adú male kat mala mùrú olif mǝnana à kǝ soapi wi ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Sǝ à nǝ̀ kàrrì andǝ agirtúró male kat aɓa girkàrre mala nggu-mbulpǝndǝa, sǝ à nǝ̀ tsǝì amur gambǝlam twal gìr. ");
INSERT INTO mbu_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","<<Gyangŋan bolo-njengǝlan ngga à nǝ̀ sárǝ́ nggubyau mǝlùre amurí ɓǝ̀ gìrì, à nǝ̀ kùmsǝi wi nggu-mbulpǝndǝa, sǝ à nǝ̀ oasǝi wi agare. ");
INSERT INTO mbu_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Sǝ agirtúró kat mala túróperi aɓa ban-mǝfele ka, à nǝ̀ pwania sǝ à nǝ̀ kàrria aɓa nggubyau mǝlùre, à nǝ̀ kùmsǝia wia gìrkùmsǝo mala nggu-mbulpǝndǝa amúrià, sǝ à nǝ̀ tsǝia amur gambǝlam twal gìr. ");
INSERT INTO mbu_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","<<À nǝ̀ pwan tú mana aɓa gyangŋan bolo-bángŋá ka sǝ à nǝ̀ sárǝì wi nggubyau mǝwanye amurí. ");
INSERT INTO mbu_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Pǝlǝa à nǝ̀ tsǝk agirtúró mala gyangŋanì kat amurí: atasau-bǝsa, andǝ ashokali-soagìr, andǝ ashebǝl, andǝ ankenye, yì agirtúró kat mala gyangŋan; à nǝ̀ sárǝ́ gìrkùmsǝo mala nggu-mbulpǝndǝa amurí sǝ à nǝ̀ oasǝi wi agare a ban malea. ");
INSERT INTO mbu_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","<<Anzǝm mǝnana Haruna andǝ amuna-burana male malna gìrki agir mǝfele andǝ agirtúró kat mala ban-mǝfele ka, sǝ lang kàttì gilǝnarǝì nǝ̀ lo gya ka, amǝ'Kohat nǝ̀ yiu ace twal agirnì. Sǝama à pà nǝ̀ jeka agir mǝfele ɗàng, ɓǝ̀ ana raka à nǝ̀ wǔ. Amǝ'Kohat na à nǝ̀ pwan agir mǝnana aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","<<Túró mala Eleaza muna-ɓwabura mala Haruna pǝris ka, nda tsǝkir mùrú ace pà tǎlaban, andǝ muku-gìr loasǝ yele mǝrǝmɓoarne, andǝ pàgir mala mǝsǝsa mana à pākiyi pwari-pwari ka, andǝ mùrú-ɗārǝ́bân. Ɗǝm ngga yì na nǝ̀ nggǝ tsǝk-mǝsǝì arǝ Taragula andǝ agir mǝnana kat aɓalǝi ka, kat andǝ ban-mǝfele andǝ agirtúró ɓalǝi.>> ");
INSERT INTO mbu_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yahweh banggi Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","<<Wu kǝa ɗeki amuna andǝ amǝkau mǝnana aɓalǝ amǝ'Lawi a nggurkwar mala Kohat ka tea ɓǝ̀ twal ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ace amsǝia, ɓǝà kǝa wuki raka, lang à nǝ̀ sung tù a ban agir nggea-mǝfele ka, pàk mǝnia ka acea: Haruna andǝ amuna-burana male ɓǝà kùtí aɓa ban-mǝfele, sǝ ɓǝà pè koyan atea ka túró male andǝ gìr mǝnana nǝ̀ twal ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Sǝama amǝ'Kohat pà nǝ̀ kúti ace sǝn agir mǝfele ɗàng ko bǝti, ɓǝ̀ ana raka à nǝ̀ wǔ.>> ");
INSERT INTO mbu_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","<<Ɓal làkkì mala amuna-burana mala Gashon gbal, arǝ aɓala-kàu sǝ arǝ anggurkwar malea. ");
INSERT INTO mbu_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ɓal aburana mǝnana kat pǝlǝa malea na lumi-tàrú aban ká lumi-tongno, mǝnana à kārǝ́na à nǝ̀ pàk túró aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Mǝnia ka nda túró mana amuna andǝ amǝ'kàu arǝ anggurkwar mala amǝ'Gashon nǝ̀ pak ka, aɓa túró andǝ twaltwalo ka: ");
INSERT INTO mbu_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Yià na à nǝ̀ twal alagìr mala Taragula, sǝ Tara Ban-peri andǝ lagìr-murí, andǝ nggu-mbulpǝndǝa mǝnana gìr múrià ka, andǝ lagìr gbar bankutio aɓa Tara Ban-peri, ");
INSERT INTO mbu_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","andǝ alagìr mǝnana à kàrì patal, andǝ lagìr ace gbar kún patal mana kàrì Taragula andǝ gyangŋan ngga, andǝ anggur malea, andǝ agirtúró ace túró malea kat. Amǝ'Gashon na à nǝ̀ pàk gìr mǝnana kat ɓoaro ɓǝà pè nǝ amǝnia yì agir ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Atúró mǝnana kat amuna-burana mala amǝ'Gashon nǝ̀ pè, ko mala twaltwalo, ko aɓea atúró ka, à nǝ̀ pè aɓata gingnǝban mala Haruna andǝ amuna-burana male. Sǝ awu nǝ pea wia agir mǝnana kat à nǝ̀ twal ka, ɓǝ̀ duk túró malea. ");
INSERT INTO mbu_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Mǝnia ka nda túró mǝnana nda ace amuna andǝ amǝkà Gashon, aɓa Tara Ban-peri ka. Sǝ túró mana à nǝ̀ pea wia ka, nda aɓata gingnǝban mala Itamar muna-ɓwabura mala Haruna pǝris. ");
INSERT INTO mbu_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","<<Ɓal làkkì mala amǝkà Merari arǝ anggurkwar malea sǝ arǝ aɓala-kàu malea. ");
INSERT INTO mbu_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ɓal aburana mǝnana kat pǝlǝa malea na lumi-tàrú aban ká lumi-tongno, mǝnana à kārǝ́na à nǝ̀ pàk túró aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Túró malea aɓa Tara Ban-peri, aɓa túró mǝnana kat à nǝ̀ pè ka, nda twal anggun-tara mala Taragula, andǝ anggun-gangndea male, andǝ anggun-ɓalǝu male, andǝ agumtǝli-tǝrteà, ");
INSERT INTO mbu_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kat andǝ anggun-kala mana à kàrì patal ka, andǝ agumtǝli-tǝrteà, andǝ ankpako malea, andǝ anggúr malea, andǝ agirtúró malea kat, andǝ acili agir mǝnana kat à nǝ̀ pà gbasha arǝ túró ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Mǝnia ka nda túró mǝnana nda ace amuna andǝ amǝkà Merari, aɓa Tara Ban-peri ka. Sǝ túró mana à nǝ̀ pea wia ka, nda aɓata gingnǝban mala Itamar muna-ɓwabura mala Haruna pǝris.>> ");
INSERT INTO mbu_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Nda Musa andǝ Haruna andǝ aɓwana-mǝgule mala ɓwabundǝa ɓal amuna andǝ amǝkà Kohat arǝ anggurkwar, sǝ arǝ aɓala-kàu malea ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","À ɓal aburana mǝnana kat pǝlǝa malea na lumi-tàrú aban ká lumi-tongno, mǝnana à kārǝ́na à nǝ̀ pàk túró aɓa Tara Ban-peri ka; ");
INSERT INTO mbu_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","sǝ yià mǝnana à ɓallia arǝ anggurkwar mala Kohat ka, à nda á-ɓari nǝ gbǝman-tongno-nong-ɓari nǝ lumi-tongno (2,750). ");
INSERT INTO mbu_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Amǝnia ka nda làkkì mala aɓwana mǝnana à ɓallia arǝ anggurkwar mala amǝ'Kohat, yià mǝnana kat à pàktúró aɓa Tara Ban-peri, mana Musa andǝ Haruna ɓallia, kǝla mana Yahweh bangŋi nǝ kún Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","À ɓal amuna andǝ amǝkà Gashon, arǝ anggurkwar, sǝ arǝ aɓala-kàu malea, ");
INSERT INTO mbu_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","twal a ban ɓwa mǝnana pǝlǝa male na lumi-tàrú aban ká lumi-tongno, mǝnana kārǝ́na nǝ̀ pàk túró aɓa Tara Ban-peri ka; ");
INSERT INTO mbu_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","yià mǝnana à ɓallia arǝ anggurkwar malea, sǝ arǝ aɓala-kàu malea ka à nda á-ɓari nǝ gbǝman-tongno-nong-mwashat nǝ lumi-tàrú (2,630). ");
INSERT INTO mbu_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mǝnia ka nda làkkì mala amuna andǝ amǝkau a nggurkwar mala Gashon, mǝnana à kārǝ́na à nǝ̀ pàk túró aɓa Tara Ban-peri, mana Musa andǝ Haruna ɓallia kǝla mana Yahweh bang ngga. ");
INSERT INTO mbu_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Aburana mǝnana à ɓallia arǝ anggurkwar mala amuna andǝ amǝkà Merari, sǝ arǝ aɓala-kàu malea, ");
INSERT INTO mbu_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","twal a ban ɓwa mǝnana pǝlǝa male na lumi-tàrú aban ká lumi-tongno, mǝnana kārǝ́na nǝ̀ pàk túró aɓa Tara Ban-peri ka, ");
INSERT INTO mbu_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","yià mǝno à ɓallia arǝ anggurkwar malea ka, à nda á-tàrú nǝ gbǝman-ɓari (3,200). ");
INSERT INTO mbu_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Mǝnia ka nda làkkì mala amuna andǝ amǝkau a nggurkwar mala Merari, mana Musa andǝ Haruna ɓallia kǝla mana Yahweh bangŋi nǝ kún Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Nda Musa andǝ Haruna andǝ aɓwana-mǝgule mala Isǝrayila ɓal Amǝ'Lawi arǝ anggurkwar sǝ arǝ aɓala-kàu malea ka. ");
INSERT INTO mbu_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Aɓwana mǝnana kat pǝlǝa malea na lumi-tàrú aban ká lumi-tongno, mǝnana à kārǝ́na à nǝ̀ pàk túró andǝ twaltwalo mala agir mala Tara Ban-peri ka, ");
INSERT INTO mbu_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","làkkì malea na á-tongno-nong-tàrú nǝ gbǝman-tongno nǝ lumi-tongno-nong-tàrú (8,580). ");
INSERT INTO mbu_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","À ɓallia aɓa kpata nzongcau mala Yahweh nǝ kún Musa, koyan ngga nǝ túró male mǝnana nǝ̀ pàk ka ko gìr mǝnana nǝ̀ twal ka. Anggo sǝ à ɓallia kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","<<Banggi amǝ Isǝrayila ama ɓǝà pusǝ koyan mǝnana ndanǝ kwánó nggû, andǝ koyan mǝnana mùrgìr kǝ pur arǝì, andǝ koyan mǝnana pǝndǝki rǝì nǝ je lú ka, ɓǝà purî ɓá kàttì; ");
INSERT INTO mbu_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ko ɓwabura ko ɓwama na ka, wun nǝ̀ pusǝia, ɓǝà purî ɓá kàttì, ace mǝnana ɓǝà kǝa pǝndǝki akàttì malea, mǝnana mǝ ndakam nǝdo aɓalǝia ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Amǝ Isǝrayila pàk mǝno; à pusǝkia à purî ɓá kàttì. Kǝla mana Yahweh banggi Musa ka, anggo sǝ amǝ Isǝrayila pǎ. ");
INSERT INTO mbu_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Sǝ Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","<<Banggi amǝ Isǝrayila ama: Lang ɓwabura ko ɓwama yàl nzongcau mala Yahweh nǝ pakkì ɓì mǝɓane a koya buì, sǝ ɓwê yì ear cauɓikea male ka, ");
INSERT INTO mbu_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","dumǝna púp ɓwê nǝ̀ bang cauɓikea male mǝnana pàk ka. Sǝ dumǝna púp nǝ̀ mbwegìr puppup a kúnì gìr mǝnana kat kiɗiki ka, sǝ nǝ̀ tsǝk banì mwashat aɓa gauwe tongno mala gìrnî amurí, sǝ nǝ̀ pè ɓwa mǝno pàkki wi mǝɓane ka. ");
INSERT INTO mbu_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Sǝ ɓǝ̀ ɓwê pànǝ kǝ mǝliɓala mǝnana à nǝ̀ kánǝ mǝno yì mbwegìr-akúnì ka abani raka, yì mbwegìr-akúnì ka pǝlǝna mala Yahweh sǝ dumǝna púp à nǝ̀ pè pǝris, atārǝia andǝ gam mala shawuɗiban mǝnana à nǝ̀ shawuɗi ɓwê nǝi ace mǝɓane mǝnana pàk ka. ");
INSERT INTO mbu_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Sǝ koya ɓoro mala apagir mǝfele mala amǝ Isǝrayila, mǝnana à kǝ yinǝia aban pǝris ka, à nǝ̀ duk mala pǝris. ");
INSERT INTO mbu_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Agir mǝfele mala koya ɓwa ka amale na, sǝ ɓǝ̀ mana kat ɓwa pè pǝris ka mala pǝris na.>> ");
INSERT INTO mbu_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","<<Banggi amǝ Isǝrayila ama: Ɓǝ̀ ɓwabura tsǝki māmí cau arǝì, mala kyanggî njar, ama māmí lǝmdǝna ɗwanyi-domǝsǝcau a baní, nǝ nongŋo-nda andǝ ɓe ɓwabura, sǝ burí sǝlǝce ɗàng, sǝ kǝ ɓwa sǝlǝce raka (acemǝnana kǝ ɓwa sǝni ko bwali aban pe raka), sǝ ɓǝ̀ burí pàk mɓali, sǝ nusǝ māmí nǝ pǝndǝki rǝì, ko mɓali bwali sǝ nusǝ māmí, kat andǝ amani ama māmí pǝndǝki rǝì raka, ");
INSERT INTO mbu_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ɓǝ̀ kyan nǝ māmí aban pǝris. Sǝ ɗǝm ngga ɓǝ̀ yinǝ pagìr amur māmí: tyang mwashat mala muku mǝssa-bálì; sǝama pà nǝ̀ so kǝ mùrú amurí ɗàng, sǝ pà nǝ̀ kpapi wi myang-kwarra aɓalǝi ɗàng, acemǝnana pàgir mǝsǝsa na mala nusǝban-mɓali, sǝ pàgir na ace kasǝɓalǝu, mala nyesǝ ɗenyicau arǝ pě-mǝɓane mala ɓwa. ");
INSERT INTO mbu_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","<<Sǝ Pǝris nǝ̀ yinǝi ɓwame ɓǝ̀ yi came aɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Pǝlǝa pǝris nǝ̀ so mùr mǝfele aɓa nkwaring dǝɓang sǝ nǝ̀ ɗàrǝ́ tú a nzali aɓa Taragula sǝ nǝ̀ soe aɓa mùr mǝnia. ");
INSERT INTO mbu_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Sǝ pǝris nǝ̀ tamsǝ ɓwame aɓadǝm Yahweh, nǝ̀ panzǝki nyang múr ɓwame, sǝ nǝ̀ tsǝki wi pàgir mǝsǝsa mala kasǝɓalǝu, mǝnana nda pàgir mǝsǝsa mala nusǝban-mɓali ka, a ɓabui, sǝ yì pǝris ka nǝ̀ twal mùr mǝlulle mǝnana kǝ yinǝ suban ngga a buì. ");
INSERT INTO mbu_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pǝlǝa pǝris nǝ̀ tsǝk ɓwame ɓǝ̀ kángìr, nǝ̀ ne ɓwame ama, <Ɓǝ̀ ɓekǝ ɓwabura mǝnana burio na raka nongnǝ we ɗang, sǝ a pǝlǝmì njar a kútímá a ɓeami, kǝla ɓwama aɓata burí raka, ɓǝ̀ suban mǝnana mǝnia yì mùr mǝlulle kǝ yinǝi ka ɓǝ̀ yàllî muro. ");
INSERT INTO mbu_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Sǝama ɓǝ̀ a kyangŋǝ́nì njar, mǝnana a nda aɓata burio, a pǝndǝkina ɓamurò, sǝ ɓè ɓwabura mǝnana burio na raka nongŋǝna nǝ we ka, ");
INSERT INTO mbu_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","suban mǝnia ka nǝ̀ sulǝo amuro.> Pǝlǝa pǝris ka nǝ̀ tsǝk ɓwame ɓǝ̀ kána, kángìr mala suban, sǝ pǝris nǝ̀ banggi ɓwame ama, <Ɓǝ̀ aɓwana mô sǝlǝ ama suban mala Yahweh na amuro, lang Yahweh tsǝngŋǝ̀nà abyalo kwetǝna, sǝ tabumo mwarna ka; ");
INSERT INTO mbu_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ɓǝ̀ mùr mǝnia mǝnana kǝ yinǝ suban ngga, ɓǝ̀ kùtí a bumo, ɓǝ̀ tsǝk tabumo ɓǝ̀ mwaro sǝ abyalo ɓǝà eamdǝe.> <<Pǝlǝa ɓwame ka nǝ̀ ear ama, <Amin, Ɓǝ̀ do anggo.> ");
INSERT INTO mbu_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","<<Pǝlǝa pǝris ka nǝ̀ gilǝ asuban mǝnia ka aɓa mbu-malǝmce, sǝ nǝ̀ lea nǝ mùr, ɓǝà solǝo aɓa mùr mǝlulle mǝno. ");
INSERT INTO mbu_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Sǝ nǝ̀ tsǝk ɓwame ɓǝ̀ nu mùr mǝlulle mǝnia mana kǝ yinǝ suban ngga, sǝ yì mùr ka nǝ̀ kùtí a bumi sǝ nǝ̀ yinǝi wi nǝ tanni mǝlulle. ");
INSERT INTO mbu_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Sǝ pǝris nǝ̀ ak pàgir mǝsǝsa mala nusǝban-mɓali a bu ɓwame, sǝ nǝ̀ lǝmdǝí a kuli aɓadǝm Yahweh, sǝ nǝ̀ yinǝi aban gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Sǝ pǝris nǝ̀ ɗàrǝ́ aɓa pàgir mǝsǝsa mǝno ka, ɓǝ̀ lùmsǝ ɓabui, ɓǝ̀ duk kāmbe male mala kasǝɓalǝu, sǝ nǝ̀ pisǝi amur gyangŋan; anzǝm mǝno ka, nǝ̀ tsǝk ɓwame ɓǝ̀ nu mùr mǝno. ");
INSERT INTO mbu_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","<<Anzǝm mana tsǝ̀ngŋǝ̀nà ɓwame nuna mùrnî, sǝ ɓǝ̀ do ama ɓwame pǝndǝkina ɓamurì, lǝmdǝna ɗwanyi-domǝsǝcau aban burí ka, mùr mala yinǝ suban ngga nǝ̀ kùtí a bumi, sǝ nǝ̀ yinǝi wi nǝ tanni mǝlulle, sǝ tabumi nǝ̀ mwaro, sǝ abyali nǝ̀ kpami, sǝ ɓwame nǝ̀ pǝlǝ gìr suban aɓalǝ aɓwana male. ");
INSERT INTO mbu_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Sǝama ɓǝ̀ ɓwame ka pǝndǝki ɓamurì ɗàng, nda aɓa ɓoarnsari ka, nǝ̀ pà atàrǝì, kǝgìr mǝɓane pà nǝ̀ kumi ɗàng, sǝ nǝ̀ kum ɓǝlmuna. ");
INSERT INTO mbu_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","<<Mǝnia ka nda nggurcau mǝnana à nǝ̀ kpate amur mɓali ka, lang ɓwama mǝnana ndanǝ bura amurí ka kyanggî njar, sǝ kya pǝndǝki ɓamurì, ");
INSERT INTO mbu_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ko a pwari mana ɓwabura ka mɓali bwali sǝ pàk mɓali ace māmí ka. Yì ka nǝ̀ yinǝ māmí aɓadǝm Yahweh sǝ pǝris nǝ̀ kpata acau mala nggurcau mǝnia amur ɓwame. ");
INSERT INTO mbu_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Yì bura ɓwama ka, à pà nǝ̀ sǝni nǝ cauɓikea ɗàng, sǝ ɓwama ka, bafe mala cauɓikea male mǝnana pàk ka nǝ̀ do amurí.>> ");
INSERT INTO mbu_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","<<Nacau nǝ amǝ Isǝrayila sǝ wu banggia wia ama: Lang ɓwabura ko ɓwama nǝ̀ twal kanggǝrang pàcau nǝ-shambum, mala duk ɓwa-nazir, ace tàr ɓamurì aban Yahweh ka, ");
INSERT INTO mbu_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dumǝna púp nǝ̀ yál ɓamurì arǝ nu mùr-anap andǝ mba. Dumǝna púp pà nǝ̀ nu ɓekǝ mùr-hangŋa mǝnana à pè nǝ mùr-anap, ko mùr-hangŋa mana à pè nǝ mba ka ɗàng; sǝ pà nǝ̀ nu ɓekǝ girnùná mǝnana à kàmbi arǝ ɓǝla-anap ka ɗàng; sǝ pà nǝ̀ lì ɓǝla-anap, pwàlè ko imè ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Aɓalǝ anonggio kat mala tàrɓamuru male ka, pà nǝ̀ lì ɓekǝ gìr mǝnana kat pùro arǝ nggun-anap, ko amǝsǝi na ko nggwate na ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","<<Aɓalǝ anonggio mala pàcau nǝ-shambum mala tàrɓamuru male kat ka, ɓekǝ nkembu pa nǝ̀ je ɓamúrí ɗàng, she pwari mǝnana anonggio mala do male kǝla ɓwa-nazir aban Yahweh lùmsǝna ka. Yì ka nǝ̀ duk mǝfele sǝ nǝ̀ nying nyang ɓamúrí ɓǝ̀ dāh'rya. ");
INSERT INTO mbu_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","<<Aɓalǝ anonggio kat mala tàrɓamuru male aban Yahweh ka, dumǝna púp pà nǝ̀ ká amur lú ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Dumǝna púp, pà nǝ̀ pǝndǝki ɓamurì ɗàng ko ɓǝ̀ nda ace lú mala tárrí, ko nggè, ko mǝ'eambi-ɓwabura, ko mǝ'eambi-ɓwama ka ɗàng. Mǝnia ka nda acemǝnana nyang mǝnana a múrí, mana lǝmdǝ tàrɓamuru male aban Ɓakuli ka, nda a ɓamúrí. ");
INSERT INTO mbu_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Aɓalǝ anonggio mala tàrɓamuru male kat ka, nǝ̀ duk mǝfele aban Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","<<Ɓǝ̀ kǝ ɓwa kasǝa wǔ aɓa yasǝlǝban a nkanggari, mǝnana nǝ̀ tsǝa nyang ɓamúrí mala tàrɓamuru male nǝ̀ pǝndǝki ka, dumǝna púp nǝ̀ mwa nyang ɓamúrí a pwari lakban male; nǝ̀ mwe a tongno-nong-ɓaria pwari. ");
INSERT INTO mbu_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A tongno-nong-tàruià pwari ka nǝ̀ yinǝ akutugangyi ɓari ko amuna-kutumurǝm ɓari aban pǝris, a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Pǝris nǝ̀ pà mwashat kǝla pàgir ace cauɓikea, sǝ ɓè ka ace pàgir mala pisǝe kǝring, sǝ nǝ̀ shawuɗì, acemǝnana lú mǝno wù a nkanggari tù ka, nunbi wi cauɓikea amurí, sǝ dumǝna púp ama àkǝ̀ pwari mǝno ka nǝ̀ tsǝk ɓamúrí ɓǝ̀ duk mǝfele ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Dumǝna púp nǝ̀ tàr ɓamurì ɗǝm ace anonggio male, mala do ɓwa-nazir aban Yahweh, sǝ nǝ̀ yinǝ muna-gam mǝnana mbule mwashat ka ace pàgir mala kumcau. Sǝ anonggio mǝɗiɗyalni ka, à nǝ̀ ueɓà acemǝnana tàrɓamuru male pǝndǝkina. ");
INSERT INTO mbu_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","<<Mǝnia ka nda nggurcau mǝnana à nǝ̀ kpate ace ɓwa-nazir, lang anonggio mala tàrɓamuru male lùmsǝna ka: à nǝ̀ yinǝi a bankutio aɓa Tara Ban-peri; ");
INSERT INTO mbu_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","sǝ yì ka nǝ̀ yinǝ pàgir male aban Yahweh ani: muna-gam mǝnana mbule mwashat, sǝ ɓè kǝgìr mǝɓane pà kàm arǝì raka, ace pàgir mala pisǝe kǝring, andǝ muna-nzur mǝnana mbule mwashat ka, ace pàgir mala gǝshi cauɓikea, andǝ gam mana ɓè kǝgìr mǝɓane pà kàm arǝì raka, ace pàgir mala dotarǝu, ");
INSERT INTO mbu_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","atārǝia andǝ apagir mala mǝsǝsa andǝ apagir mala girnùná malea, andǝ zace mala agbatali bǝredi mana yis pà arǝì raka, mana à pea nǝ muku mǝɓǝlke mana à zurì nǝ mùrú olif ka, andǝ abiskit mana à pea nǝ yis raka, sǝ à hasǝkia wia mùrú olif arǝia ka. ");
INSERT INTO mbu_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","<<Sǝ pǝris nǝ̀ yinǝ agir mǝnia kat ka tù aɓadǝm Yahweh, sǝ nǝ̀ pà gir'nkila mala pàgir mala gǝshi cauɓikea male, yì ɓwa-nazir, andǝ pàgir male ace pisǝe kǝring. ");
INSERT INTO mbu_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Pǝlǝa nǝ̀ pà gir'nkila nǝ gam mala pàgir ace dotarǝu aban Yahweh, atārǝia andǝ bǝredi mana yis pà arǝì raka, mǝnana nda aɓa zace ka; sǝ a masǝlǝate ka nǝ̀ pàgir mala mǝsǝsa atārǝia andǝ pàgir mala girnùná. ");
INSERT INTO mbu_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","<<Anzǝm mǝno ka, yì ɓwa-nazir ka nǝ̀ mwa ɓamúrí mala tàrɓamuru male, a bankutio aɓa Tara Ban-peri, sǝ nyang ɓamúrí mala tàrɓamuru male ka, nǝ̀ twali sǝ nǝ̀ tsǝì amur bǝsa mǝnana nda aɓata gir'nkila mala apagir mala dotarǝu ka. ");
INSERT INTO mbu_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Anzǝm mana ɓwa-nazir mwana nyang mala tàrɓamuru male ka, pǝlǝa pǝris nǝ̀ twal bù gam, mǝnana à lamni ka, sǝ nǝ̀ twal gbatali bǝredi mwashat mǝnana yis pà arǝì raka, andǝ biskit mwashat mana yis pà arǝì raka, amǝnana aɓa zace ka, sǝ nǝ̀ tsǝia arǝ abú ɓwa-nazir. ");
INSERT INTO mbu_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Pǝlǝa pǝris nǝ̀ loasǝia a kuli, ɓǝ̀ duk pàgir mǝnana à loasǝi a kuli aɓadǝm Yahweh ka. Akāmbe mǝfele na ace pǝris, atārǝia andǝ kikil gam mana à loasǝi a kuli, andǝ byali mana à pàna ɓoro nǝi ka. Anzǝm mǝno ka, yì ɓwa-nazir ka à earǝ́nì wi ɓǝ̀ nu mùr-anap. ");
INSERT INTO mbu_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","<<Mǝnia ka nda nggurcau amur ɓwa-nazir mǝnana pàcau nǝ-shambum, sǝ amur pàgir male mǝnana nǝ̀ pà aban Yahweh ace tàrɓamuru male ka. Dumǝna púp nǝ̀ yinǝ pàgir mǝnia ka, sǝ ɓǝ̀ nǝ̀ gandǝi ka, ɓǝ̀ yinǝ aɓea amur mǝno, aɓa kpata nggurcau mala tàrɓamuru male.>> ");
INSERT INTO mbu_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","<<Banggi Haruna andǝ amuna-burana male ama: Ani sǝ wun nǝ̀ tsǝki amǝ Isǝrayila bù. Wun nǝ̀ banggia wia ama, ");
INSERT INTO mbu_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","<< <Ɓǝ̀ Yahweh tsǝka wun bù, ɓǝ̀ yál wun; ");
INSERT INTO mbu_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ɓǝ̀ Yahweh tsǝa ɓamǝsǝi ɓǝ̀ tǎ amur wun, ɓǝ̀ lǝmdǝa wun ɓwamuru; ");
INSERT INTO mbu_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ɓǝ̀ Yahweh sǝn mǝsǝswatǝr ma'wun, ɓǝ̀ pa wun dorǝpwala.> ");
INSERT INTO mbu_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","<<Anggo ka à nǝ̀ tsǝk lullǝam amur amǝ Isǝrayila, sǝ mǝ nǝ tsǝkia wia bù.>> ");
INSERT INTO mbu_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Lang Musa malǝna loasǝ Taragula ka, pǝlǝa ɗārǝi sǝ tàrì andǝ agirtúró male kat. Ɗǝm ngga ɗārǝ gyangŋan sǝ tàrì andǝ agirtúró male kat. ");
INSERT INTO mbu_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Sǝ à yinǝ aɓwana-mǝgule mala Isǝrayila, amúrû amur aɓala-kàu malea, mǝnana à nda ka amǝdǝmba mala atau ka. Yia na mǝnana à tsǝia amur aɓwana mǝnana à ɓallia ka; à yiu sǝ à cam tù, ");
INSERT INTO mbu_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","sǝ à yinǝ apagir malea aɓadǝm Yahweh: akeke-ndá tongno-nong-mwashat andǝ ajamnda lum-nong-ɓari; keke-ndá mwashat ace ɓari atà amúrû mala atau, sǝ jamnda mwashat ace koyan ateà. À yinǝia a ɓadǝm Taragula. ");
INSERT INTO mbu_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Pǝlǝa Yahweh ne Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","<<Ak agir mǝnia ka a buia, sǝ wu pe amǝ'Lawi ace túró twal agir mǝfele mala Tara Ban-peri, koyan ateà ka kǝla mana túró male nǝ̀ pàk ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Nda Musa ak akeke-ndá andǝ ajamnda mǝno sǝ pè amǝ'Lawi ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Pè amǝ'Gashon akeke-ndá ɓari andǝ ajamnda ine, kǝla mana kún túró malea pàk ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Pè amǝ'Merari akeke-ndá ine andǝ ajamnda tongno-nong-tàrú, kǝla mana kún túró malea pà aɓata gingnǝban mala Itamar muna-ɓwabura mala Haruna pǝris ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Sǝ amǝ'Kohat ka Musa pea wia kǝgìr ɗàng acemǝnana túró malea ka nda tsǝkir agir ɓá ban-mǝfele, mǝnana a kwàrú sǝ à nǝ̀ twalia ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","A pwari mǝnana à nǝ̀ ɗārǝ gyangŋan ngga, amúrû mala atau pāki apagir ace tàre; à yinǝ apagir malea a ɓadǝm gyangŋanì. ");
INSERT INTO mbu_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yahweh banggi Musa ama, <<Aɓa pwari mwashat ka ɓwamǝgule mwashat na nǝ̀ yinǝ pàgir male ace tàr gyangŋan ngga.>> ");
INSERT INTO mbu_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ɓwamǝgule mǝnana yinǝ pàgir male a pwari mǝdǝmbe ka nda Nashon muna-ɓwabura mala Aminadap, a tàu mala Yahuda. ");
INSERT INTO mbu_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Sǝ pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na ka, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne; ");
INSERT INTO mbu_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Nashon muna-ɓwabura mala Aminadap. ");
INSERT INTO mbu_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","A ɓaria pwari ka Netanel muna-ɓwabura mala Zuar, múr-là mala Isaka, yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Pàgir male mǝnana pà ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Netanel muna-ɓwabura mala Zuar. ");
INSERT INTO mbu_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","A tàruià pwari ka Eliyap muna-ɓwabura mala Helon, múr-là mala amǝkà Zebulu yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat-mwashat na ka ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Eliyap muna-ɓwabura mala Helon. ");
INSERT INTO mbu_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","A inea pwari ka Elizur muna-ɓwabura mala Shedeur, múr-là mala amǝkà Ruben yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ̀ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Elizur muna-ɓwabura mala Shedeur. ");
INSERT INTO mbu_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","A tongnoia pwari ka Shelumiyel muna-ɓwabura mala Zurishaddai, múr-là mala amǝkà Shimiyon yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","andǝ lo-jamnda a domwan, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Shelumiyel muna-ɓwabura mala Zurishaddai. ");
INSERT INTO mbu_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","A tongno-nong-mwashatia pwari ka Eliyasaf muna-ɓwabura mala Dewel, múr-là mala amǝkà Gad yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Eliyasaf muna-ɓwabura mala Dewel. ");
INSERT INTO mbu_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","A tongno-nong-ɓaria pwari ka Elishama muna-ɓwabura mala Ammihud, múr-là mala amǝkà Ifǝrem yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Elishama muna-ɓwabura mala Ammihud. ");
INSERT INTO mbu_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","A tongno-nong-tàruià pwari ka Gamaliyel muna-ɓwabura mala Pedazur, múr-là mala amǝkà Manasa, yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Pàgir male mǝnana pà ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝno ka nda pàgir mala Gamaliyel muna-ɓwabura mala Pedazur. ");
INSERT INTO mbu_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","A tongno-nong-inea pwari ka Abidan muna-ɓwabura mala Gidiyoni, múr-là mala amǝkà Benjami yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Abidan muna-ɓwabura mala Gidiyoni. ");
INSERT INTO mbu_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A lumia pwari ka Ahieza muna-ɓwabura mala Amishaddai, múr-là mala amǝkà Dan yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Ahieza muna-ɓwabura mala Amishaddai. ");
INSERT INTO mbu_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A lum-nong-mwashatia pwari ka Pagiyel muna-ɓwabura mala Okran, múr-là mala amǝkà Asha yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Pagiyel muna-ɓwabura mala Okran. ");
INSERT INTO mbu_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A lum-nong-ɓaria pwari ka Ahira muna-ɓwabura mala Enan, múr-là mala amǝkà Naftali yinǝ pàgir male. ");
INSERT INTO mbu_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Pàgir male ka paranti na mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), andǝ tasau mǝnana à pè nǝ bolo-azǝrfa sǝ dǝmbǝrya male ka shekel lumi-tongno-nong-ɓari na ka (70); à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià kǝm ngga à lùmsǝia nǝ muku mǝɓǝlke mǝnana à zurì nǝ mùrú olif ace pàgir mala mǝsǝsa ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Ɗǝm ngga yinǝ muna-nkenye mǝnana à pè nǝ bolo-njengǝlan sǝ dǝmbǝrya male ka shekel lum na, sǝ à lùmsǝì nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka; ");
INSERT INTO mbu_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","andǝ lo-jamnda, andǝ gam, andǝ muna-gam mǝnana mbule mwashat ka, ace pàgir mala pisǝe kǝring; ");
INSERT INTO mbu_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","andǝ gbato ace pàgir mala gǝshi cauɓikea; ");
INSERT INTO mbu_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","sǝ ace gir'nkila mala apagir mala dotarǝu ka yinǝ andá ɓari, agam tongno, agbato tongno, andǝ amuna-gam tongno mǝnana mbulea mwashat-mwashat ka. Mǝnia ka nda pàgir mala Ahira muna-ɓwabura mala Enan. ");
INSERT INTO mbu_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Amǝnia ka à nda ka apagir mala amúrû mala atau mala Isǝrayila ace tàr gyangŋan lang à ɗārǝi ka: aparanti bolo-azǝrfa lum-nong-ɓari, atasau bolo-azǝrfa lum-nong-ɓari, amuna-nkenye bolo-njengǝlan lum-nong-ɓari, ");
INSERT INTO mbu_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","koya paranti bolo-azǝrfa ka dǝmbǝrya male ka shekel gbǝman-mwashat nǝ lumi-tàrú na (130), sǝ koya tasau bolo-azǝrfa ka dǝmbǝrya male na shekel lumi-tongno-nong-ɓari (70). Dǝmbǝrya kat-kat mala atanggǝla bolo-azǝrfa ka shekel á-ɓari nǝ gbǝman-ine na (2,400); à kpata shekel mǝnana à ear amurí a Tara-mǝfele ka. ");
INSERT INTO mbu_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Komǝye atà amuna-nkenye bolo-njengǝlan lum-nong-ɓari mǝnana à lùmsǝia nǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne ka, dǝmbǝrya male na shekel lum; à kpata shekel mǝnana à ear amurí a ban-mǝfele ka. Yià amuna-nkenye bolo-njengǝlan kat ka dǝmbǝrya malea na shekel gbǝman-mwashat nǝ lumi-ɓari (120). ");
INSERT INTO mbu_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Agirkusǝu mǝnana kat à yinǝia ace pàgir mala pisǝe kǝring ngga à nda ka: ajamnda lum-nong-ɓari, agam lum-nong-ɓari, amuna-gam mǝnana mbulea mwashat-mwashat ka lum-nong-ɓari, atārǝia andǝ pàgir mala mǝsǝsa malea; andǝ agbato lum-nong-ɓari ace pàgir mala gǝshi cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Làkkì mala agirkusǝu kat-kat ace pà gir'nkila mala pàgir mala dotarǝu ka à nda ka: ajamnda lumi-ɓari-nong-ine, agam lumi-tongno-nong-mwashat, agbato lumi-tongno-nong-mwashat, amuna-gam lumi-tongno-nong-mwashat mǝnana mbulea mwashat-mwashat ka. Amǝnia ka à nda ka apagir ace tàr gyangŋan anzǝm ɗārǝè. ");
INSERT INTO mbu_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","A koya pwari sǝ Musa kúti aɓa Tara Ban-peri nǝ̀ nacau nǝ Yahweh ka, kǝ ok gì Yahweh aban ne wi cau a nre ka acerup ɓari mǝnana à mǝn abuia a kùli amur buno sǝntǝ̀r, mǝnana nda amur Akwati mala Acau-nakûn ngga; anggo sǝ Yahweh kǝ ne wi cau. ");
INSERT INTO mbu_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yahweh ne Musa cau, ama, ");
INSERT INTO mbu_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","<<Nacau nǝ Haruna sǝ wu banggi wi ama, <Lang awu nǝ tamsǝki apitǝla ka, tsǝia a njar mǝnana à nǝ̀ nggǝ pa tǎlaban a ɓadǝm gìr-tamsǝia ka.> >> ");
INSERT INTO mbu_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Anggo sǝ Haruna pǎ; tsǝki apitǝla à pǝlǝ nǝ ɓadǝm gìr-tamsǝia, kǝla mǝnana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ani sǝ à pàk gìr-tàmsǝ apitǝla: à pè nǝ bolo-njengǝlan mǝnana à walki ka, twal a kusǝì aban ká arǝ nyoulǝa rǝi mala tǒ mala afufe. Anggo sǝ pè kǝla mǝnana Yahweh lǝmdǝì Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yahweh banggi Musa ama: ");
INSERT INTO mbu_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","<<Pusǝ amǝ'Lawi aɓalǝa amǝ Isǝrayila sǝ wu leǎ. ");
INSERT INTO mbu_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ace leǎ ka pàk mǝnia: Watsǝkia wia mùr lakban amúrià; sǝ wu tsǝia ɓǝà mwa nyang mǝnana a rǝia ka kat, sǝ ɓǝà lakki agir'nggūrǝia. Anggo sǝ à nǝ̀ lak ɓamuria. ");
INSERT INTO mbu_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Anzǝm mǝno ka ɓǝà yinǝ jamnda, atārǝia andǝ pàgir mala mǝsǝsa male, mǝnana muku mǝɓǝlke na à zurì nǝ mùrú olif ka; sǝ awu nǝ twal ɓè jamnda a domwan ace pàgir mala gǝshi cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Pǝlǝa awu nǝ yinǝ amǝ'Lawi aɓadǝm Tara Ban-peri, sǝ wu ram ɓinala amǝ Isǝrayila kat. ");
INSERT INTO mbu_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Lang a yinanǝ amǝ'Lawi aɓadǝm Yahweh ka, pǝlǝa aɓwana-mǝgule mala amǝ Isǝrayila nǝ̀ nongsǝ abuia amur amǝ'Lawi. ");
INSERT INTO mbu_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Pǝlǝa Haruna nǝ̀ yinǝ amǝ'Lawi aɓadǝm Yahweh, ɓǝà do kǝla pàgir mana à loasǝi a kuli mǝnana amǝ Isǝrayila pa, ace mǝnana ɓǝà do nǝ gilǝrǝu ace pak túró mala Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","<<Pǝlǝa amǝ'Lawi ka ɓǝà nongsǝ abuia a ɓamur ajamnda, mǝnana mwashat ka nda ace pàgir aban Yahweh mala gǝshi cauɓikea, sǝ ɓè ka nda ace pàgir mala pisǝe kǝring, ace shawuɗi amǝ'Lawi. ");
INSERT INTO mbu_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Awu nǝ tsǝk amǝ'Lawi ɓǝà came aɓadǝm Haruna andǝ amuna-burana male, sǝ awu nǝ tària ɓǝà duk pàgir mǝnana à loasǝi a kuli aban Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Anggo sǝ awu nǝ pusǝ amǝ'Lawi aɓalǝa amǝ Isǝrayila, sǝ amǝ'Lawi ka à nǝ̀ duk amem. ");
INSERT INTO mbu_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","<<Anzǝm mǝnana a langŋǝna amǝ'Lawi sǝ a tarnia kǝla pàgir mana à nǝ̀ loasǝi a kuli ka, à nǝ̀ ká ace pàktúró a Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","À nda ka amǝ Isǝrayila mǝnana à panamia kǝring ngga. Ən twalnia ɓǝà duk amem a kúnì aɓwana mǝnana kat à tita puro a bum ngga, yì amuna-dǝmba aburana mala amǝ Isǝrayila kat. ");
INSERT INTO mbu_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Koya muna-dǝmba muna-ɓwabura a Isǝrayila, ɓwapǝndǝa ko girkusǝu ka, mem na. Lang ǝn wal amuna-dǝmba kat a Masar ka, ǝn taria ace ɓamúràm. ");
INSERT INTO mbu_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Sǝ ǝn twalna amǝ'Lawi a kúnì amuna-dǝmba amuna-burana kat a Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Aɓalǝa amǝ Isǝrayila kat ka, ǝn pana amǝ'Lawi kǝla ɓoro aban Haruna andǝ amuna-burana male ace pàktúró a Tara ban-peri a kúnì amǝ Isǝrayila, sǝ ɓǝà shawuɗia, ace mǝnana ɓǝ̀ ɓekǝ gìr'mur'mwana ɓǝkǝa wal amǝ Isǝrayila ɗàng lang à nǝ̀ gbàshìban ban-mǝfele ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, andǝ Haruna andǝ ɓinala amǝ Isǝrayila kat pàngnǝ amǝ'Lawi kǝla mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Amǝ'Lawi lak ɓamuria sǝ à lakki agir'nggūrǝia. Pǝlǝa Haruna tària kǝla pàgir mǝnana à loasǝi a kuli aɓadǝm Yahweh ka, sǝ shawuɗia ace leǎ. ");
INSERT INTO mbu_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Anzǝm mǝno ka amǝ'Lawi wari ace pàktúró malea aɓa Tara Ban-peri aɓata gingnǝban mala Haruna andǝ amuna-burana male. À pàngnǝ amǝ'Lawi kǝla cau mana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","<<Cau mǝnia ka nda arǝ amǝ'Lawi: Ɓwabura mǝnana pǝlǝa male na lumi-ɓari-bwamdǝ-tongno andǝ mana kútì ka nǝ̀ yiu ace pàk túró aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Sǝ lang ɓwabura bingŋǝnà pǝlǝa lumi-tongno ka, nǝ̀ nyingbuì arǝ túró mǝnana pàkiyi pwari-pwari ka, sǝ pà nǝ̀ pàk túró ɗǝm ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Yì ka nǝ̀ gandǝ bwali amǝ'eambi arǝ pakki atúró malea aɓa Tara Ban-peri, sǝama pà nǝ̀ pàk túrè nǝ nggearǝì ɗàng. Anggo sǝ awu nǝ pàkkî amǝ'Lawi aɓa kasǝia wia atúró mǝnana nda acea ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yahweh nacau nǝ Musa a pǝɗanban Saina, a zongŋo mǝdǝmbe mala ɓaria pǝlǝa anzǝm mana amǝ Isǝrayila purnì nzali Masar ka, ama, ");
INSERT INTO mbu_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","<<Amǝ Isǝrayila ɓǝà kǝ pak lamsan mala Yàlîmurû a kǝ pwari mǝnana à tsǝì ace ka. ");
INSERT INTO mbu_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Wu pàk lamsan male a kǝ pwari mǝnana à tsǝk ka, nǝ pwarikpǝra a lum-nong-inea pwari mala mǝnia yì zongŋo ka; dumǝna púp wun nǝ̀ pàk lamsan male nǝ kpata angguracau male kat, andǝ anê male kat.>> ");
INSERT INTO mbu_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Nda Musa banggi amǝ Isǝrayila ɓǝà pak lamsan mala Yàlîmurû ka. ");
INSERT INTO mbu_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Sǝ yià ka à pak lamsan Yàlîmurû a lum-nong-inea pwari mala zongŋo mǝdǝmbe, nǝ pwarikpǝra a pǝɗanban mala Saina. Amǝ Isǝrayila pàk koman kat kǝla mǝnana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Sǝ càu kumban ama aɓea aburana pǝlǝ gìr'ɓeami atàcau mala je lú ɓeɓwa, sǝ gìrnî tsǝa à gandǝ pak lamsan mala Yàlîmurû amǝno yì pwari ka ɗàng. Aburana mǝnia yiu aɓadǝm Musa andǝ Haruna amǝno yì pwari. ");
INSERT INTO mbu_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","À ne Musa ama, <<Mǝsǝcau sǝm pǝlǝna gìr'ɓeami atàcau mala je lú ɓeɓwa. Sǝama palang sǝ mǝno ka tsǝa à tàmsǝ sǝm arǝ yinǝ pagìr mala Yahweh atà amǝ Isǝrayila a pwari mǝnana à tsǝì ace ka?>> ");
INSERT INTO mbu_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa earia wia ama, <<Wu kúndǝô, mǝ ok cau mǝnana Yahweh nǝ̀ bang ace wun ngga.>> ");
INSERT INTO mbu_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Pǝlǝa Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","<<Banggi amǝ Isǝrayila ama: Ɓǝ̀ kǝɓwa aɓalǝ wun, ko atà amǝ'kà wun pǝlǝ gìr'ɓeami atàcau mala je lú, ko twal bǝri mǝsauwe ka, ɓwê nǝ̀ gandǝ pak lamsan mala Yàlîmurû abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Sǝama à nǝ̀ pè a lum-nong-inea pwari mala ɓaria zongŋo nǝ pwarikpǝra. À nǝ̀ shak nyam muna-gam mala Yàlîmurû nǝ bǝredi mana yis pà arǝì raka nǝ mbúgir mǝ'lùlle atè. ");
INSERT INTO mbu_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Dumǝna púp à pà nǝ̀ nying kǝ cili ɓǝ̀ ueo ba dǝmbari ɗàng, sǝ à pà nǝ̀ ɓun kǝ mui ɗàng; sǝ dumǝna púp à nǝ̀ pàk lamsanì nǝ kpata angguracau mala Yàlîmurû kat. ");
INSERT INTO mbu_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Sǝama ɓǝ̀ ɓwa ka mǝɓoarnsari na, sǝ twal bǝri ɗang, sǝ gatti pàk lamsan mala Yàlîmurû ka, mǝno yì ɓwa ka à nǝ̀ pusǝ lullǝì aɓalǝ aɓwana male, acemǝnana yinǝ pagìr acem Yahweh a pwari mana à tsǝk ka ɗàng; mǝno yì ɓwa ka bafe mala cauɓikea male nǝ̀ ueo amurí. ");
INSERT INTO mbu_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","<<Ɓǝ̀ ɓwa-kúnɗàngna do aɓalǝ wun, sǝ earce nǝ̀ pàk lamsan mala Yàlîmurû abanam Yahweh ka, dumǝna púp nǝ̀ kpata angguracau andǝ anê mala Yàlîmurû. Kǝ nggurcau mǝmwashati na ace ɓwa-kúnɗàngna andǝ ɓwa Isǝrayila.>> ");
INSERT INTO mbu_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","A pwari mǝnana à loasǝ Taragula ka, pǝrɓangnî yi gìr múr Taragula, yì Tara mala Acau-nakûn, sǝ à sǝni kǝla bǝsa amur Taragula, twal a pwarikpǝra aban ká dǝmbari. ");
INSERT INTO mbu_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Anggo sǝ pǎ koya pwari: pǝrɓangnî gìr múr Taragula, sǝ nǝ du ka, à sǝni kǝla bǝsa. ");
INSERT INTO mbu_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Sǝ ɓǝ̀ aya pwari sǝ pǝrɓangnî loapì múr tara ka, zuku ka amǝ Isǝrayila nǝ̀ lo gya, sǝ ban mǝnana kat pǝrɓangnî kya cam kam ngga, a banì sǝ amǝ Isǝrayila nǝ̀ duk kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Amǝ Isǝrayila kǝ lo gya kǝla mana Yahweh na ka, sǝ à kǝ duk kàttì kǝla mana na ka. Ɓǝ̀ lang sǝ pǝrɓangnî ka banì sauwa aban ueo amur Taragula ka, anggo sǝ à nǝ̀ ueo a kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ko ɓǝ̀ pǝrɓangnî lidǝmba nǝ came amur Taragula arǝ anongŋo pas ka, amǝ Isǝrayila nǝ̀ okî Yahweh, à pà nǝ̀ lo gya ɗang. ");
INSERT INTO mbu_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Aɓea bákú ka, pǝrɓangnî nǝ̀ twal anongŋo bǝti aban ueo amur Taragula. Sǝ kǝla mana Yahweh bang ngga, à nǝ̀ ueo aɓa kàttì, sǝ kǝla mana Yahweh bang ngga, à nǝ̀ lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sǝ arǝ aɓea apwari ka, pǝrɓangnî ueo, twal a pwarikpǝra aban ká dǝmbari, sǝ lang pǝrɓangnî lo nǝ bari ka, à lo gya. Ko nda nǝ pwari ko nǝ dú, pwari mǝnana kat pǝrɓangnî lo ka, à lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ko ɓǝ̀ pǝrɓangnî twal nongŋo ɓari, ko zongŋo, ko banì sauwa nda piu amur Taragula ka, amǝ Isǝrayila ueo aɓa kàttì, à lo gya ɗang; sǝ lang longŋǝna ka, à lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Aɓa nê mala Yahweh ka, à tsǝk kàttì, sǝ aɓa nê mala Yahweh ka, à lo gya. À kpata kwarkiru mala Yahweh; sǝ cau mǝnana kat Yahweh banggi Musa ama ɓǝà pàk ka, à pè. ");
INSERT INTO mbu_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","<<Wu tùl anjawe bolo-azǝrfa ɓari. Wun nǝ̀ pàngŋǝ̀nà-túró nǝia ace tunǝ ramba mala ɓwabundǝa, sǝ ace loapi kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Lang à twang anjawe mǝnia kǝm ngga, ɓwabundǝa puppup nǝ̀ ramba a bano a bankutio mala Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Sǝ ɓǝ̀ njawe mǝdǝmbe na à twang ngga, amúrû, yì amǝdǝmba mala atau mala amǝ Isǝrayila na mǝnana à nǝ̀ ram rǝia a bano ka. ");
INSERT INTO mbu_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Sǝ lang wu ɓua njawe-lwa ka, akàttì mǝnana à tsǝk agumli malea a takuli ka, à nǝ̀ lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Sǝ lang wu ɓua ɓaria njawe-lwa ka, akàttì mǝnana à tsǝk agumli malea a njar-kunmur ka, à nǝ̀ lo gya. Ɓǝ̀ aya pwari sǝ à nǝ̀ lo gya ka, à nǝ̀ ɓua njawe-lwa. ");
INSERT INTO mbu_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Sǝ lang wun nǝ̀ ram ɓwabundǝa a banɓwáná ka, wun nǝ̀ twang njawe tè ɓǝ̀ sauwa, sǝama pà wun nǝ̀ ɓua njawe-lwa ɗang. ");
INSERT INTO mbu_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Sǝ amuna-burana mala Haruna, yià apǝris ka, à nda à nǝ̀ nggǝ twang anjawe ka. Twang-njawe ka nǝ̀ dupa wun nggurcau mǝnana wun nǝ̀ nggǝ pê arǝ anza ma'wun kat ka. ");
INSERT INTO mbu_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Lang wun nǝ̀ o a lwa aɓa nzali ma'wun arǝ aɓiwun amǝbura mǝnana à kǝ yinǝ munǝo arǝ wun ngga, wu ɓua njawe-lwa, ace mǝnana Yahweh Ɓakuli ma'wun ɓǝ̀ ɗenyinǝ wun, sǝ ɓǝ̀ amsǝ wun a ɓabù aɓiwun amǝbura. ");
INSERT INTO mbu_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","A pwari bumpwasǝa ma'wun gbal, sǝ a kúnì mala alamsan, andǝ apakkiɗire mala bǝsa azongŋo ma'wun ngga, wun nǝ̀ twang anjawe amur apagir ma'wun mǝnana à nǝ̀ pisǝia kǝring ngga, sǝ amur agir'nkila mala apagir ma'wun ace dotarǝu. À nǝ̀ duk gìr kasǝɓalǝ Ɓakuli arǝ wun; Mǝ nda Yahweh Ɓakuli ma'wun.>> ");
INSERT INTO mbu_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","A lumi-ɓaria nongŋo mala ɓaria zongŋo mala ɓaria pǝlǝa ka, pǝrɓangnî loapì múr Taragula mala Acau-nakûn, ");
INSERT INTO mbu_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","sǝ amǝ Isǝrayila lo gya, à nying pǝɗanban Saina, à kǝ turki bǝti-bǝti arǝ abân. Sǝ pǝrɓangnî yi came a pǝɗanban Paran. ");
INSERT INTO mbu_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mǝnia ka nda tadǝmbe mǝnana Yahweh banggi Musa cau ama ɓǝ̀ tsǝk amǝ Isǝrayila ɓǝà lo gya ka. ");
INSERT INTO mbu_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Anggǝsan mala amǝ'lwa aɓata tútà mala kàttì mala Yahuda ka, à nda à tita lo gya ka, sǝ ɓwamǝgule amur anggǝsan mala amǝ'lwa malea ka, nda Nashon, muna-ɓwabura mala Aminadap. ");
INSERT INTO mbu_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanel, muna-ɓwabura mala Zuar ka, nda ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Isaka. ");
INSERT INTO mbu_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sǝ ɓwa mǝnana nda ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Zebulu ka, nda Eliyap muna-ɓwabura mala Helon. ");
INSERT INTO mbu_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Sǝ lang à panzǝkina Taragula à sulǝni ka, amǝkà Gashon, andǝ amǝkà Merari, mǝnana à twal agir mala Taragula ka, à lo gya. ");
INSERT INTO mbu_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Aɓwana mǝnana à kpatea ka à nda ka anggǝsan mala amǝ'lwa mala kàttì mala Ruben, aɓata tútà malea, sǝ ɓwamǝgule amur anggǝsan malea ka, nda Elizur muna-ɓwabura mala Shedeur. ");
INSERT INTO mbu_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sǝ Shelumiyel muna-ɓwabura mala Zurishaddai ka, nda ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Shimiyon. ");
INSERT INTO mbu_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Sǝ ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Gad ka, nda Eliyasaf muna-ɓwabura mala Duwel. ");
INSERT INTO mbu_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Pǝlǝa amǝ'Kohat lo gya, nǝ agir mǝfele a buia; sǝ kaniama à nǝ̀ bwal ka, à (amǝkà Gashon andǝ amǝkà Merari) loasǝna Taragula. ");
INSERT INTO mbu_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Sǝ anggǝsan mala amǝ'lwa a kàttì mala amǝkà Ifǝrem, aɓata tútà malea kpatea, sǝ ɓwamǝgule amur anggǝsan malea ka, nda Elishama muna-ɓwabura mala Ammihud. ");
INSERT INTO mbu_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliyel muna-ɓwabura mala Pedazur ka, nda ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Manasa, ");
INSERT INTO mbu_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","sǝ Abidan muna-ɓwabura mala Gidiyoni nda ɓwamǝgule amur nggǝsan mala tàu mala amǝkà Benjami. ");
INSERT INTO mbu_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Sǝ tútà mala kàttì mala amǝkà Dan mǝnana do kǝla mǝ'yal-nzǝm akàttì kat ka, à lo gya arǝ anggǝsan mala amǝ'lwa malea, sǝ ɓwamǝgule amur nggǝsan mala amǝ'lwa malea ka, nda Ahieza muna-ɓwabura mala Amishaddai. ");
INSERT INTO mbu_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Sǝ ɓwamǝgule amur nggǝsan mala amǝ'lwa mala tàu mala amǝkà Asha ka, nda Pagiyel muna-ɓwabura mala Okran. ");
INSERT INTO mbu_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Sǝ Ahira muna-ɓwabura mala Enan ngga, nda ɓwamǝgule amur nggǝsan mala amǝ'lwa mala tàu mala amǝkà Naftali. ");
INSERT INTO mbu_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mǝnia ka nda, tsaɗi mala lo gya mala amǝ Isǝrayila arǝ anggǝsan mala amǝ'lwa malea lang à tùr kàttì ka. ");
INSERT INTO mbu_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Sǝ Musa ne Hobap muna-ɓwabura mala Rewel ɓwa Midiyan, nkil Musa ama, <<Sǝm nda aban lo o a ban mǝnana Yahweh bang ama, <Mǝ nǝ pa wuni ka.> Yiu atà sǝm, sǝ sǝm nǝ̀ pàkkô mǝɓoarne, acemǝnana Yahweh panacau mala agir mǝɓoarne ace Isǝrayila.>> ");
INSERT INTO mbu_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Sǝ yì ka bang ama, <<Pa mǝ nǝ ká ɗàng. Mǝ nǝ nyar a nzali mem, aban aɓwana mem.>> ");
INSERT INTO mbu_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Sǝ Musa ne wi ama, <<Ida, cè a nying sǝm ɗàng, acemǝnana we ka, a súrǝ́nà rǝ ban mǝnana ɓoaro sǝm nǝ̀ duk kàttì kam aɓa pǝɗanban ngga, sǝ awu nǝ do kǝla mǝsǝu aban sǝm. ");
INSERT INTO mbu_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Sǝ ɓǝ̀ a o atà sǝm ngga, gìr mǝɓoarne mǝnana Yahweh nǝ̀ pàkka sǝm ngga, nda sǝm nǝ̀ pàkkô ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nda à loapi nkono mala Yahweh, à twal gya mala nongŋo tàrú. Akwati Kùrcau mala Yahweh akia wia dǝmba aban ká aɓalǝ anongŋo tàrú mǝno ace kúmbia wia ban usǝlǝo. ");
INSERT INTO mbu_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Sǝ pǝrɓang mala Yahweh ueo amúrià nǝ pwari, a koya pwari mǝnana à loapì kàttì ka. ");
INSERT INTO mbu_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sǝ koya pwari mǝnana à tita gya nǝ Akwati ka, Musa nǝ̀ na ama: <<Lo, Yahweh, sǝ ɓǝ̀ aɓio-amǝbura ɓǝà tǝlli, sǝ aɓwana mǝnana à ɓinǝmǝsǝo ka, ɓǝà ɓangŋa a ɓadǝmbo.>> ");
INSERT INTO mbu_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sǝ lang à kya camǝna ka, nǝ̀ na ama: <<Nyare, Yahweh, aban á-mǝlàkke mala amǝ Isǝrayila mǝnana à pà nǝ̀ gandǝ ɓallia raka.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Lang Yahweh ok nggwani mǝnana aɓwe kǝ pè ace tanni malea ka, bumlulla male pì kǝ̀rkǝ́r arǝia, bǝsa mala Yahweh lo earke aɓalǝia, sǝ pisǝ aɓea ankanggariban mala kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Pǝlǝa ɓwabundǝa ɓua aban Musa, sǝ Musa ɓua aban Yahweh, sǝ bǝsa limge. ");
INSERT INTO mbu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nda sǝ à pè banì lullǝu ama, Tabera ka, acemǝnana bǝsa mala Yahweh earke aɓalǝia. ");
INSERT INTO mbu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Sǝ amǝ'kúnɗàngna mǝnana aɓalǝ amǝ Isǝrayila ka, à lo pàk suno mala aɓea agirlina. Sǝ amǝ Isǝrayila ɓua ɗǝm à kǝ na ama, <<Yana nǝ̀ pà sǝm nyama mǝnana sǝm nǝ̀ lì ka! ");
INSERT INTO mbu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ɓalǝ sǝm kasǝa arǝ nji mǝnana sǝm lì a Masar, sǝm nggǝ mbwe kǝgir ace raka, andǝ ambwario, ajiri, aɓui, ahatǝm, andǝ hangale. ");
INSERT INTO mbu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Sǝ ado ka, rǝcandǝa malǝnì rǝ sǝm, sǝ kǝgir pà kàm sǝm sǝn ɗàng shekǝ mǝnia yì manna ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Manna ka, nda kǝla mǝsǝ mbulara-ɓa-mbyau, sǝ pǎ male na kǝla myang nggun. ");
INSERT INTO mbu_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Aɓwe kǝ pur pwane sǝ à kǝ goe a taligo ko à kǝ soe a nkinggiring sǝ à nǝ̀ lambi a nkwaring, à nǝ̀ pàngŋǝ̀nà kyak nǝi. Lang à oe ka nda kǝla kyak mǝnana à pè nǝ mùrú ka. ");
INSERT INTO mbu_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Lang ncimna kpa a kàttì nǝ du ka, manna kǝ sulǝ andǝi.) ");
INSERT INTO mbu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa ok aɓwana aban ɓua a koya ban arǝ atau malea, koya ɓwa ka a kún gumli male. Bumlulla mala Yahweh earki nggǝr-nggǝr, sǝ Musa ka banɓiki wi. ");
INSERT INTO mbu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa ne Yahweh ama, <<Ace mana sǝ a pakkì guro mò mǝɓane anggo? Sǝ man tsǝa sǝ a ginǝ lǝmdǝam murɓoarna, yimana a tsǝkam twalo mala aɓwana man kat amuram ngga? ");
INSERT INTO mbu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mǝ nda ǝn twal aɓwana man kat a bumam ngga le? Mǝ nda ǝn ɓǝlia ka le, sǝ awu nǝ nam ama, <Twalia a kikilo, kǝla mǝnana mǝ'iulo kǝ twal bangna-muna ka,> aban ká a nzali mǝnana a kán ama, awu nǝ pè atárrià ka? ");
INSERT INTO mbu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ake sǝ mǝ nǝ kum nyama mǝnana mǝ nǝ pè aɓwana mǝnia kat ka? Acemǝnana à kǝ ɓuakam ama, <Pà sǝm nyama, ɓǝ̀ sǝm lì.> ");
INSERT INTO mbu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Pà mǝ nǝ gandǝ twal aɓwana mǝnia kat ka nǝmurǝam ɗàng; twalê dǝmbǝriam kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ɓǝ̀ nda anggo sǝ awu nǝ pàngnǝ mim ngga, ida, wal-luem ado, ɓǝ̀ mǝ ndanǝ murɓoarna a bano ka, ace mǝnana mǝ nggá sǝn tàpùra mem ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Pǝlǝa Yahweh ne Musa ama, <<Rambam aɓwana-mǝgule mala Isǝrayila lumi-tongno-nong-ɓari, mǝnana a súrǝ̀ia à nda ka aɓwana-mǝgule amur aɓwana, sǝ à nda ka amǝbuno amúrià ka, sǝ wu yinǝa a bankutio aɓa Tara Ban-peri, ɓǝà cam kano atò. ");
INSERT INTO mbu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Sǝ mǝ nǝ sulǝo mǝ nǝ bangcau nǝ we kano. Sǝ mǝ nǝ twal aɓa Bangŋo mǝnana amuro ka, mǝ nǝ tsǝì amúrià; sǝ à nǝ̀ bwalo twal dǝmbǝrya mala aɓwana, ace mǝnana ɓǝkǝa do amuro nǝmurǝo ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","<<Ne aɓwe ama, <Wu tàr ɓamur rǝ wun, ace lí, wun nǝ̀ shak nyama, acemǝnana ɓua ma'wun warina a kir Yahweh, ama, <<Yana nǝ̀ pà sǝm nyama mǝnana sǝm nǝ̀ shak ka? Acemǝnana do ma'sǝm a Masar ka ɓoaribanì.>> Acemani ka, Yahweh nǝ̀ pa wun nyama, sǝ wun nǝ̀ shè. ");
INSERT INTO mbu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Pà aɓa nongŋo mwashat, ko anongŋo ɓari, ko anongŋo tongno, ko anongŋo lum, ko anongŋo lumi-ɓari na wun nǝ̀ shè ka ɗàng, ");
INSERT INTO mbu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","wun nǝ̀ shè aɓa zongŋo kat, sheɓǝ̀ ce'shirina wun, pǝlǝna wun gìr'ɓeakǝno ka, acemǝnana wu ginǝkina Yahweh mǝnana nda aɓalǝ wun ngga, sǝ wu ɓuanî wi ama, <<Mana tsǝa sǝ sǝm nying Masar?>> > >> ");
INSERT INTO mbu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Sǝ Musa na ama, <<Aɓwana mǝnana mǝ nda aɓalǝia ka, amǝ'lwa á-gbǝman-tongno-nong-mwashat na, nǝ kusǝia, sǝ a bang ama, <Mǝ nǝ pea wia nyama, mǝnana à nǝ̀ shè aɓa zongŋo kat ka!> ");
INSERT INTO mbu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Adomwan mala ambul andǝ mala andá na à nǝ̀ wallia wia sǝ nǝ̀ karǝia ka le, ko ana raka à nǝ̀ rambia wia nji mǝnana a nggeamùr kat ka, sǝ nǝ̀ karǝia le?>> ");
INSERT INTO mbu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Sǝ Yahweh ne Musa ama, <<Bù Yahweh gatti le? Ado ka awu nǝ sǝni ko cau mem nǝ̀ purmǝsǝi a bano ko pà nǝ̀ purmǝsǝi ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Pǝlǝa Musa puro kya ne aɓwe acau mǝnana Yahweh bang ngga. Sǝ yi ramba aburana lumi-tongno-nong-ɓari mala aɓwana-mǝgule mala aɓwe, sǝ yi tsǝia à came à kàrì Tara. ");
INSERT INTO mbu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Pǝlǝa Yahweh sulǝo aɓa pǝrɓang yi bangcau nǝi, sǝ twal aɓa Bangŋo mǝnana nda amurí ka, sǝ tsǝì amur aɓwana-mǝgule mǝno lumi-tongno-nong-ɓari ka. Sǝ lang Bangŋo sulǝo amúrià ka, à ɓangnǝ-ɓangnǝa. Sǝama à lidǝmba aban pé ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Aɓa mǝno anggo ka, aɓwana nakam ɓari à ueo aɓa kàttì, mwashat ka, à tunǝi ama, Eldat, sǝ ɓè ka, à tunǝ ama, Medat; Bangŋo sulǝo amúrià. À nda aɓalǝ aɓwana mǝnana à gilǝ alullǝia ka, sǝama à puro à wari a Tara ɗang; à ɓangnǝa aɓa kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Sǝ ɓè lagga ɓangŋa kya ne Musa ama, <<Eldat andǝ Medat ka, à nda aban ɓangnǝ-ɓangnǝa aɓa kàttì.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Sǝ Jesǝwa muna-ɓwabura mala Nun, mǝnana twal a lo-ɓwa male ka, nda kǝ pakkî Musa gbasha ka, na ama, <<Mǝtalem Musa, tamsǝia.>> ");
INSERT INTO mbu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Sǝ Musa banggi wi ama, <<A ndarǝ pak mɓali acem le? Eare mem ngga, ɓǝ́ aɓwana mala Yahweh kat ka à dumǝna amǝ'ɓangnǝa, ɓǝ́ Yahweh nǝ̀ tsǝk Bangŋo male amúrià!>> ");
INSERT INTO mbu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Pǝlǝa Musa andǝ aɓwana-mǝgule mala amǝ Isǝrayila nyare a kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Pǝlǝa gung mǝnana pur nǝban Yahweh ka, lo ɓua; loasǝ ankwar a ban nggeamùr, sǝ yinǝia, à yi sukkio a nzali a gírí kàttì; à gumbǝli a koya buì, o ɗār kǝla gya mala pwari mwashat. Gwali malea amur rǝarǝia a nzali ka dāh'rya bik kǝla ɓakusǝu tàrú. ");
INSERT INTO mbu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Sǝ aɓa pwari andǝ du mǝno kat aban ká ɓaria pwari kat ka, aɓwana lo sǝ à camarǝ pwan nkwar. Aɓwana mǝnana à pwan bǝti ka, à nda mana à pwan zace lum ngga; à anzǝia à gumbǝlina kàttì nǝi. ");
INSERT INTO mbu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nyama na a kunia à nǝ̀ nggǝ shè, à malaká mal raka, bumlulla mala Yahweh lo earke arǝia, sǝ Yahweh kwak aɓwana a nzali, nǝ nggea gìr'mur'mwana mǝgule. ");
INSERT INTO mbu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nda sǝ à tunǝ banì ama, Kibǝrot-hatava, acemǝnana a banì sǝ à tsǝk amǝ'suno a ɓembe. ");
INSERT INTO mbu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","À loapi Kibǝrot-hatava aban ká Hazerot, sǝ à kya ueo a Hazerot. ");
INSERT INTO mbu_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriyam andǝ Haruna nacau amur Musa ace ɓwama Kush mǝnana Musa al ka, acemǝnana Musa ka, al ɓwama Kush. ");
INSERT INTO mbu_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Sǝ à na ama, <<Nggeari ka Musa na nǝmurǝi Yahweh kǝ nacau nǝi ka le? Kǝ nacau nǝ sǝm gbal re?>> Cau mǝnana à ne ka Yahweh oè. ");
INSERT INTO mbu_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Musa ka nda ɓukɓuk, kútì aɓwana mǝnana a ɓanza kat ka nǝ ɓukɓuka.) ");
INSERT INTO mbu_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Àkǝ banì Yahweh ne Musa andǝ Haruna andǝ Miriyam ama, <<Wu puro wun tàrú, wu kya bankutio aɓa Tara Ban-peri.>> Sǝ yia tàrú ka à puro. ");
INSERT INTO mbu_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Pǝlǝa Yahweh sulǝo aɓa pǝrɓang mana pǝrapǝra ka, yi came a bankutio aɓa Tara sǝ tunǝ Haruna andǝ Miriyam yia kǝm, sǝ à puro. ");
INSERT INTO mbu_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Sǝ bang ama, <<Wu ok cau mem: <<Ɓǝ̀ ɓekǝ mǝɓangnǝa nakam aɓalǝ wun ngga, Mim Yahweh ka, ǝn nggǝ lǝmdǝ ɓamúràm a baní aɓa sǝna; ǝn nggǝ ne wi cau aɓa lòrǝo. ");
INSERT INTO mbu_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Pa anggo nǝ guro mem Musa ɗàng. Yì ka ndanǝ domǝsǝcau aɓa ɓala mem kat. ");
INSERT INTO mbu_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ən nggǝ nacau nǝi bwāng, kún andǝ kún, pà aɓa cauɓaɓe ɗàng, sǝ yì ka kǝ sǝn pǎ mem Mim Yahweh. Mana tsǝa sǝ wu ginǝ ɓanggi nacau amur guro mem Musa?>> ");
INSERT INTO mbu_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nda bumlulla mala Yahweh earke arǝia sǝ nying bania. ");
INSERT INTO mbu_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Sǝ lang pǝrɓang longŋǝni múr Tara ka, kara Miriyam bwal nǝ kwánó nggû, pwasǝo kǝla talimbulo. Sǝ Haruna pǝlǝa aban Miriyam, sǝ sǝni ka, kwánó nggû bwalǝni. ");
INSERT INTO mbu_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Sǝ Haruna ne Musa ama, <<Ida, mǝtalem, cè a pa sǝm tanni ɗàng, acemǝnana sǝm pàngŋǝ̀nà gìr ɓwaɓana, sǝ sǝm pàngŋǝ̀nà cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ən nggǝ zǝmbo, cè a eare ɓǝ̀ pǎ kǝla lú bangna-muna, mǝnana lang purî bum ngge ka, ngguí kpattíkínà ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Sǝ Musa ɓua aban Yahweh ama, <<We Ɓakuli, ida sonzǝi, ǝn nggǝ zǝmbô.>> ");
INSERT INTO mbu_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Sǝama Yahweh ne Musa ama, <<Ɓǝ̀ tárrí tappi wi ntara a ɓamǝsǝi ka, pà nǝ̀ do aɓa kirsakya anongŋo tongno-nong-ɓari re? Ɓǝà pusǝì anzǝm kàttì ɓǝ̀ ue kano ba anongŋo tongno-nong-ɓari, sǝ anzǝm mǝno ka, wu nyesǝi aɓa kàttì ɗǝm.>> ");
INSERT INTO mbu_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Anggo sǝ à pusǝ Miriyam anzǝm kàttì sǝ ue kano ba anongŋo tongno-nong-ɓari, sǝ aɓwe ka, à lo gya ɗang she lang à nyesǝna Miriyam aɓa kàttì ɗǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Anzǝm mǝno ka, aɓwe lo à nying Hazerot, sǝ à yi duk kàttì a pǝɗanban Paran. ");
INSERT INTO mbu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","<<Tasǝ aburana ɓǝà kya shenzǝ nzali Kan'ana, mǝnana ǝn nggǝ pè amǝ Isǝrayila ka. Aɓa koya tàu mala akeâ ka, à nǝ̀ tasǝ ɓwa mwashat mǝnana múrû na aɓalǝia ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Pǝlǝa Musa tasǝia, à lo a pǝɗanban Paran, kǝla mǝnana Yahweh bang ngga, yia kat ka, amúrû mala amǝ Isǝrayila na. ");
INSERT INTO mbu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Alullǝia nia ka: A tàu mala Ruben ngga, nda Shamuwa muna-ɓwabura mala Zakkur; ");
INSERT INTO mbu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","a tàu mala Shimiyon ngga, nda Shafat muna-ɓwabura mala Hori; ");
INSERT INTO mbu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","a tàu mala Yahuda ka, nda Kalip muna-ɓwabura mala Jefune; ");
INSERT INTO mbu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","a tàu mala Isaka ka, nda Igal muna-ɓwabura mala Yisǝfu; ");
INSERT INTO mbu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","a tàu mala Ifǝrem ngga, nda Hoshiya muna-ɓwabura mala Nun; ");
INSERT INTO mbu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","a tàu mala Benjami ka, nda Palti muna-ɓwabura mala Rafu; ");
INSERT INTO mbu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","a tàu mala Zebulu ka, nda Gadiyel muna-ɓwabura mala Sodi; ");
INSERT INTO mbu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","a tàu mala Manasa (mǝnana a tàu mala Yisǝfu ka), nda Gaddi muna-ɓwabura mala Susi; ");
INSERT INTO mbu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","a tàu mala Dan ngga, nda Amiyel muna-ɓwabura mala Gemalli; ");
INSERT INTO mbu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","a tàu mala Asha ka, nda Setur muna-ɓwabura mala Makel; ");
INSERT INTO mbu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","a tàu mala Naftali ka, nda Nabi muna-ɓwabura mala Vopsi; ");
INSERT INTO mbu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","a tàu mala Gad ka, nda Gewel muna-ɓwabura mala Maci. ");
INSERT INTO mbu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Amǝnia ka à nda ka alullǝ aburana mǝnana Musa tasǝia ɓǝà shenzǝ nzalî ka. Sǝ Musa pè Hoshiya muna-ɓwabura mala Nun lullǝu ama Jesǝwa. ");
INSERT INTO mbu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa tasǝia ɓǝà shenzǝ nzali Kan'ana sǝ nea wia ama, <<Wu eauwe, wu kàr nǝ Negev, sǝ wu kya eauwe a nzali múr ankono, ");
INSERT INTO mbu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","sǝ wu sǝn ko lang sǝ nzalî pa, sǝ ko aɓwana mǝnana à do aɓalǝi ka à ndanǝ rǝcandǝa ko amǝ'rǝwukea na, ko à nda kpokyak ko à bundǝo, ");
INSERT INTO mbu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","sǝ ko nzali mana à do aɓalǝi ka mǝɓoarne na ko mǝɓane na, sǝ ko anggea-là mǝnana à do aɓalǝia ka, akàttì na ko akanggǝrang ala na, ");
INSERT INTO mbu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","sǝ ko nzali gǝna na ko nzali tǝle na, sǝ ko anggun na aɓalǝi ko à pà kàm ɗàng. Wu dumnǝ mǝsǝ'kang'kangŋa wu yinǝ aɓea aɓǝla-nggun mala nzalî.>> Ado ka nda kún tita bangŋa mala aɓǝla-anap. ");
INSERT INTO mbu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Pǝlǝa à eauwe à wario à kya shenzǝ nzalî nǝ bu pǝɗanban Zin aban ká Rehop, tù nǝ Lebo Hamat. ");
INSERT INTO mbu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","À eauwe à o a Negev sǝ à yiu a Hebǝron. Aɓwana mala atau mala Ahiman, Sheshai, andǝ Talmai, amǝkà Anak ka, à nda kano. (Hebǝron ngga à ɓè, apǝlǝa tongno-nong-ɓari sǝ à yi ɓak Zowan a Masar.) ");
INSERT INTO mbu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Sǝ lang à yiu a Ɓangŋaban Eshkol ka, à kasǝ bu-nggun nǝ dangŋanshi ɓǝla-anap, sǝ aɓwana ɓari twali arǝ gara; ɗǝm ngga à yinǝ aɓǝla mɓǝring andǝ vwari. ");
INSERT INTO mbu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Mǝno yì ban ngga à tunǝi ama Ɓangŋaban Eshkol, ace dangŋanshi ɓǝla-anap mǝnana amǝ Isǝrayila kasǝ kano ka. ");
INSERT INTO mbu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","A masǝlǝata anongŋo lumi-ine ka, à nyarî shenzǝ nzalî. ");
INSERT INTO mbu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Sǝ à yiu aban Musa andǝ Haruna andǝ ɓwabundǝa mala amǝ Isǝrayila a pǝɗanban Paran a Kadesh. À yinǝ cau sǝ à yi bǝlì Musa andǝ Haruna kunia andǝ ɓwabundǝa kat, sǝ à lǝmdǝia wia aɓǝla-nggun mala nzalî. ");
INSERT INTO mbu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Sǝ à ne Musa ama, <<Sǝm warina a nzali mana a túr sǝm kam ngga. Mur-nyi andǝ kiura kǝ ɓang kam, sǝ mǝnia ka nda ɓǝlanggun male. ");
INSERT INTO mbu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Sǝama aɓwana mǝnana à do a nzalî ka, amǝ'candǝe na, sǝ anggea-là ka, à gulkio sǝ à kària nǝ asheran. Sǝ ɗǝm ngga, sǝm sǝn amǝkà Anak kàm. ");
INSERT INTO mbu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amǝ'Amalek ka, à ndanǝdo a Negev. Amǝ'Hiti andǝ amǝ'Jebus, andǝ amǝ'Amor ka, à do a nzali múr ankono. Sǝ amǝ'Kan'ana ka, à do a kún nggeamùr, sǝ a nkanggari Jodan.>> ");
INSERT INTO mbu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Pǝlǝa Kalip pwasǝlǝ aɓwana a ɓadǝm Musa, sǝ bang ama, <<Ɓǝ̀ sǝm lo ado ɓǝ̀ sǝm kya ak nzalî, acemǝnana sǝm ndanǝ rǝcandǝa pepè mala limurǝm amurí!>> ");
INSERT INTO mbu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Sǝ aɓwana mǝnana à wari andǝia ka, à na ama, <<Pà sǝm nǝ̀ gandǝ ká a munǝo arǝ amǝno yì aɓwana ka ɗàng, acemǝnana à kútì sǝm nǝ rǝcandǝa!>> ");
INSERT INTO mbu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Anggo sǝ à yinǝì amǝ Isǝrayila cau mǝɓane amur nzali mana à kya shenzǝi ka, ama, <<Nzali mana sǝm wari aɓalǝi a shenzǝe ka, nzali na mǝnana kǝ shak aɓwana mǝnana à do aɓalǝi ka, sǝ aɓwana mana kat sǝm sǝnia aɓalǝi ka, à dāh'riki mwat-mwat. ");
INSERT INTO mbu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Akano ka, sǝm sǝn akwatǝman-aɓwana, amǝ'kà Anak, mǝnana pur a tàu mala akwatǝman-aɓwana ka. Sǝm sǝn ɓamúr rǝ sǝm abania kǝla adoshi, sǝ anggo gbal sǝ à sǝn sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Pǝlǝa ɓwabundǝa loasǝ gia à soɓua, à ɓua aɓa dù mǝno. ");
INSERT INTO mbu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Sǝ amǝ Isǝrayila kat nggwanî Musa andǝ Haruna. Ɓwabundǝa puppup banggia wia ama, <<Eare ma'sǝm ngga, ɓǝ́ sǝm wukina a nzali Masar, ko aɓa mǝnia yì pǝɗanban ngga! ");
INSERT INTO mbu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mana tsǝa sǝ Yahweh kǝ yinǝ sǝm a nzali man ɓǝà wal-lu sǝm nǝ nggeabyau? Amālá sǝm, andǝ amuna ma'sǝm ngga à nǝ̀ pwania kǝla agirkuma. Pà nǝ̀ ɓoaribanì yi mana ɓǝ̀ sǝm nyare a Masar ka re?>> ");
INSERT INTO mbu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Pǝlǝa à ne a rǝia ama, <<Ɓǝ̀ sǝm twal ɓwa ɓǝ̀ dupa sǝm a dǝmba ɓǝ̀ sǝm nyare a Masar.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Pǝlǝa Musa andǝ Haruna kpa nǝ ɓamǝsǝia a nzali a ɓadǝm ɓwabundǝa mala ɓinala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Sǝ Jesǝwa muna-ɓwabura mala Nun, andǝ Kalip muna-ɓwabura mala Jefune, yià mana à nda aɓalǝ amǝ'shenzǝ nzali ka, à sàngi adaura malea, ");
INSERT INTO mbu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","sǝ à banggi ɓwabundǝa mala amǝ Isǝrayila kat ama, <<Nzali mǝnana sǝm kùtí nǝ ɓalǝi ace shenzǝe ka, nggea nzali mǝɓoarne na kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ɓǝ̀ bum Yahweh pwasǝ arǝ sǝm ngga, nǝ̀ yinǝ sǝm a nzali man, sǝ nǝ̀ pasǝmì, yì nzali mǝnana mùr-nyì andǝ kiura à kǝ ɓang kam ngga. ");
INSERT INTO mbu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Wu kǝa na ama wun nǝ̀ mgbikî Yahweh cau ɗàng, sǝ ɓangciu ɓǝkǝa pàkka wun arǝ aɓwana mǝnana à do a nzalî ka ɗàng. Agirlina na aban sǝm. Yalban pâ a buia ɗàng, sǝ Yahweh na atà sǝm; ɓangciu ɓǝkǝa pàkka wun arǝia ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Pǝlǝa ɓwabundǝa lo ama à nǝ̀ ɓukkia nǝ atali. Sǝama ɓoarɓwa mala Yahweh lǝmdǝrǝì aɓa Tara Ban-peri, aban amǝ Isǝrayila kat. ");
INSERT INTO mbu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Sǝ Yahweh banggi Musa ama, <<Nǝ̀ sau lang sǝ aɓwana mǝnia nǝ̀ nyesǝcem-ɓà? Sǝ nǝ̀ sau lang sǝ à nǝ̀ ginǝ earnǝ mim, kat andǝ agir'lǝmndǝa mana kat ǝn pea aɓalǝia ka? ");
INSERT INTO mbu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mǝ nǝ koea nǝ kwánó-ɓikea, mǝ nǝ vwakibuam arǝia, sǝ mǝ nǝ pusǝ nzali mǝnana mǝgule na sǝ candǝe kútiǎ ka, nǝ we.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Sǝama Musa ne Yahweh ama, <<Pǝlǝa amǝ Masar ka à nǝ̀ okce; acemǝnana a pusǝ aɓwana man aɓalǝia nǝ rǝcandǝa mò, ");
INSERT INTO mbu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","sǝ à nǝ̀ bangce aban aɓwana mǝnana a nzali man ngga. Yia ka à ongŋǝna ama we Yahweh ka, a nda aɓalǝ amǝnia yì aɓwana ka. We Yahweh ka aɓwana man sǝnǝno ɓamǝsǝu andǝ ɓamǝsǝu, sǝ pǝrɓang mò kǝ cam amúrià, sǝ a kǝ gya a ɓadǝmbia nǝ pwari aɓa pǝrɓang mǝnana cam pǝrapǝra ka, sǝ nǝ du ka aɓa ɓǝsa mǝnana cam pǝrapǝra ka. ");
INSERT INTO mbu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ado ka ɓǝ̀ a wal-lú ka aɓwana mǝnia, a twaltea ka, anzali mala aɓwapǝndǝa mǝnana à okce zǝ́kí mala lullǝo ka, à nǝ̀ na ama, ");
INSERT INTO mbu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","<Nda acemǝnana Yahweh gandǝ yinǝ aɓwana mǝnia ka a nzali mana kángìr ama nǝ̀ pea wia ka raka, nda tsǝa sǝ wal-luia aɓa pǝɗanban ngga.> ");
INSERT INTO mbu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Sǝ ado ka, ida, ɗeki rǝcandǝa mala Mǝtala sǝm ɓǝ̀ dumnǝ gulo kǝla mana a pacau, ama, ");
INSERT INTO mbu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","<Yahweh kǝ kaurǝa pak bumlulla ɗàng, sǝ pěmǝɓoarne aɓa earcearǝu male mana kǝ dǝurǝ raka nda nyangsang, kǝ twalban cauɓikea andǝ mgbikiru; sǝama pà nǝ̀ nying ɓwa mǝnana kumcau ka ɓǝ̀ ukɓà ɗàng; kǝ yinǝ ɓashi ace acauɓikea mala atárrú amur amunia andǝ amǝ'keà, aban ká tàruià andǝ inea nza.> ");
INSERT INTO mbu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ida, twalban cauɓikea mala amǝnia yì aɓwana ka, atàcau mala gulo mala pěmǝɓoarne aɓa earcearǝu mô mana kǝ dǝurǝ raka, kǝla mana a twali amǝnia yì aɓwana banì aɓa Masar ba ado ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Pǝlǝa Yahweh bang ama, <<Ən twalǝnabanì, kǝla mǝnana a bang ngga. ");
INSERT INTO mbu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Sǝama aɓa mǝsǝcau, mbak-kàngkàng mǝ ndanǝ yilǝmu sǝ ɓanza lumsǝ nǝ gulo mem ngga, ");
INSERT INTO mbu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","kǝɓwa pà kàm atà aɓwana mǝnia mǝnana à sǝn gulo mem andǝ agir-lǝmdǝa, mana ǝn pea a Masar andǝ ɓá pǝɗanban, sǝ kat andǝ amani ka, à karǝkiam kusǝ lum man, sǝ à kwakikiria arǝ giem raka, ");
INSERT INTO mbu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","mǝnana à nǝ̀ sǝn nzali mana ǝn kánbì atárrià ace ka ɗàng. Sǝ kǝɓwa pà kàm atà aɓwana mǝno à nyesǝcem-ɓà ka, nǝ̀ sǝni ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Sǝama guro mem Kaleb, acemǝnana bangŋo male na ɗàng, sǝ kpatam kat-kat ka, mǝ nǝ yinǝi a nzali mǝnana wari kam ngga, sǝ nǝ̀ duk girkuma mala amuni andǝ amǝkè. ");
INSERT INTO mbu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ado ka, acemǝnana amǝ Amalek andǝ amǝ'Kan'ana na kam nǝ do arǝ aɓangŋaban ngga, lí ka wu pǝlǝa wu dǝshi pǝɗanban nǝ njar Nggeamùr Nzuno.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Sǝ Yahweh bangcau nǝ Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","<<Nǝ̀ sau lang sǝ mǝ nǝ twalgàndǝá nǝ mǝnia yì ɓwabundǝa mǝɓealɓike mǝnana à camarǝ nggwaniam ngga? Ən ongŋǝna nggwani mana amǝ Isǝrayila kǝ nggwaniam ngga. ");
INSERT INTO mbu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Banggia wia ama, <Ən kán nǝ yilǝmem, mim Yahweh ama, gìr mǝnana wu ne sǝ ǝn oê ka, nda mǝ nǝ pàkka wun ngga: ");
INSERT INTO mbu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","alú wun nǝ̀ bwamdǝ a mǝnia yì pǝɗanban ngga; sǝ atà aburana mǝnana kat à ɓallia a ɓalban, twal aban ɓwa mǝnana apǝlǝa malea na lumi-ɓari andǝ mana kútì ka, mǝnana à nggwaniam ngga, ");
INSERT INTO mbu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","kǝ mwashat atea pà kàm mǝnana nǝ̀ kùtí aɓa nzali mana ǝn kángìr ama mǝ nǝ dumsǝ wun kàm ngga ɗàng, she Kaleb muna-ɓwabura mala Jefune andǝ Jesǝwa muna-ɓwabura mala Nun. ");
INSERT INTO mbu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Sǝama amuna mǝkeke ma'wun, mǝnana wu na ama à nǝ̀ bwalkia ko à nǝ̀ wal-luia ka, mǝ nǝ yinǝia aɓalǝi, sǝ à nǝ̀ súrǝ̀ nzali mǝnana wu ginǝce ka. ");
INSERT INTO mbu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Sǝ wun ngga, alú wun nǝ̀ bwamdǝ aɓa pǝɗanban mǝnia ka. ");
INSERT INTO mbu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Amuna ma'wun nǝ̀ duk ayalgir a pǝɗanban apǝlǝa lumi-ine, sǝ à nǝ̀ tanni àtàcau mala ɗwanyi-domǝsǝcau ma'wun, sheɓǝ̀ masǝlǝata alú wun bwamdǝna a pǝɗanban ngga. ");
INSERT INTO mbu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kǝla làkkì mala anongŋo mǝnana wu pa aban shenzǝ nzali, anongŋo lumi-ine ka, anggo sǝ wun nǝ̀ nutanni mala acauɓikea ma'wun apǝlǝa lumi-ine, koya pǝlǝa mwashat ka a kúnì nongŋo mwashat, sǝ wun nǝ̀ súrǝ̀ bumkiɗikea mem.> ");
INSERT INTO mbu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mim Yahweh ka, ǝn bangŋǝni. Mǝnia yì gìr ka, ǝn kána mǝ nǝ pàkkî mǝnia yì ɓwabundǝa puppup mǝɓealɓike, mǝnana à kpapikunia arǝàm ngga: àkǝ ɓá pǝɗanban man sǝ masǝlǝatea nǝ yiu kat-kat, sǝ a banì sǝ à nǝ̀ wukio.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Aburana mana Musa túriá ɓǝà shenzǝ nzali, mǝnana à nyare à yi tsǝk ɓwabundǝa à nggwanî wi nǝ yinǝ cau mǝɓane amur nzalî, ");
INSERT INTO mbu_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","yì aburana mǝno à yi mesǝ cau mǝɓane amur nzalî ka, gìr'mur'mwana wal-luia a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aɓalǝ aburana mǝno à wari a shenzǝ nzali ka, kǝ Jesǝwa muna-ɓwabura mala Nun andǝ Kaleb muna-ɓwabura mala Jefune na à ue nǝyilǝmu ka. ");
INSERT INTO mbu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Lang Musa banggi amǝ Isǝrayila kat amǝnia yì acau ka, aɓwe pak bumkiɗikea kǝ̀rkǝ́r. ");
INSERT INTO mbu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sǝ à lo nǝ dǝmbari ɗiɗyal, à eauwe amur ankono mala nzalî, sǝ à na ama, <<Sǝm ndya ka, mǝsǝcau sǝm pàngŋǝ̀nà cauɓikea, sǝama sǝm nǝ̀ eauwe ace ká a ban mǝnana Yahweh pacau ace ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Sǝ Musa ka bang ama, <<Palang ado sǝ wu kǝ yàl nzongcau mala Yahweh, yima pě mǝno anggo ka pà nǝ̀ yinǝ limurǝm raka? ");
INSERT INTO mbu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Wu kǝa ká ɗàng, acemǝnana Yahweh pà aɓalǝ wun ɗàng; ɓǝ̀ ana raka aɓiwun amǝbura nǝ̀ lì wun. ");
INSERT INTO mbu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amǝ'Amalek andǝ amǝ'Kan'ana ka à nda kana, à nǝ̀ dǝshi wun, sǝ à nǝ̀ gandǝ wun nǝ nggeabyau. Acemǝnana wu pǝlǝna nzǝm wun arǝ kpata Yahweh ka, Yahweh pà nǝ̀ pa atà wun ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Sǝ yià ka à twalkicau ama à nǝ̀ eauwe amur ankono mala nzalî, kat andǝ amani ama Musa andǝ Akwati Kùrcau nying kàttì raka. ");
INSERT INTO mbu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Pǝlǝa amǝ'Amalek andǝ amǝ'Kan'ana mǝnana à do arǝ ala amur ankono ka, à sulǝ ateà, à yi gandǝia, à pǝrtea aban ká Horma. ");
INSERT INTO mbu_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","<<Bangcau nǝ amǝ Isǝrayila, nea wia ama, <Lang wu yina aɓa nzali mǝnana ǝn nggǝ pa wun, wun nǝ̀ duk kam, ");
INSERT INTO mbu_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","sǝ wun nǝ̀ pàgir nǝ bǝsa aban Yahweh ka, wu pà jamnda ko gam ko gbato. Wu panagir nǝi kǝla pàgir mala pisǝe kǝring, ko mala gir'nkila ace lumsǝ pàcau nǝ-shambum, ko mala eare mala ɓabum, ko mǝnana wu kǝ pa pwari-pwari ace alamsan ma'wun ngga, ace pa rǝmban mǝɓoarne mǝnana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Ɓwa mǝnana kǝ yinǝ pàgir male aban Yahweh ka, dumǝna púp nǝ̀ yinǝi atārǝia andǝ pàgir mala mǝsǝsa, muku mǝɓǝlke tyang mwashat, mǝnana à zurì nǝ mùrú olif, dù-lita mwashat ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Lang wun nǝ̀ pà muna-gam ace pagir mala pisǝe kǝring ko gir'nkila nǝi ka, dumǝna púp awu nǝ yinǝi atārǝia andǝ dù-lita mwashat mala mùr-anap ace pàgir mala girnùná. ");
INSERT INTO mbu_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","<< <Ɓǝ̀ gam na ka, dumǝna púp awu nǝ yinǝ tyang ɓari mala muku mǝɓǝlke mǝnana à zurì nǝ dù-lita mwashat nǝ gauwa-tsùrú mala mùrú olif ka, ace pàgir mala mǝsǝsa; ");
INSERT INTO mbu_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ɗǝm ngga awu nǝ pàgir mala girnùná, dù-lita mwashat nǝ gauwa-tsùrú mala mùr-anap, ace pà rǝmban mǝɓoarne mǝnana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","<< <Lang jamnda na awu nǝ pa kǝla pàgir mala pisǝe kǝring ko gir'nkila, ace lumsǝ pàcau nǝ-shambum, ko kǝla pàgir mala dotarǝu aban Yahweh ka, ");
INSERT INTO mbu_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dumǝna púp awu nǝ pà mǝno yi jamnda ka andǝ tyang tàrú mala muku mǝɓǝlke mǝnana à zurì nǝ dù-lita ɓari mala mùrú olif ka; ");
INSERT INTO mbu_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ɗǝm ngga dumǝna púp awu nǝ pa dù-lita ɓari mala mùr-anap kǝla pàgir mala girnùná. Pàgir na nǝ bǝsa, mala pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Anggo sǝ à nǝ̀ gilǝkice koya jamnda ko gam, koya muna-gam ko muna-gbato. ");
INSERT INTO mbu_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Dumǝna púp ama, awu nǝ pàk mǝnia ka ace komǝye atea, kǝla mana làkkì malea pàk ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","<< <Koya ɓwa mǝnana kat à ɓǝli ɓwa Isǝrayila na ka, dumǝna púp nǝ̀ pàk agir mǝnia ka anggo lang nǝ̀ yinǝ pàgir nǝ bǝsa, ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Arǝ anza mǝnana kat à kǝ yiu ka, ɓǝ̀ ɓwa-kúnɗàngna yiu a do bǝti atà wun, sǝ ko ɓǝ̀ yana mǝnana ndanǝdo aɓalǝ wun sǝ earce ama nǝ̀ yinǝ pàgir nǝ bǝsa, ace pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka, dumǝna púp nǝ̀ pè a pě ma'wun. ");
INSERT INTO mbu_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Nggurcau mǝmwashati na ace ɓwabundǝa kat, ace wun andǝ ɓwa-kúnɗàngna mana ndanǝdo aɓalǝ wun ngga; nê na mǝnana pà nǝ̀ nggaɗi raka arǝ anza ma'wun kat. Wun, sǝ yià amǝkúnɗàngna ka, wu nda mwashat a ɓadǝm Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Anggurcau andǝ akwarkiru mǝmwashati na ace wun sǝ ace ɓwa-kúnɗàngna mana do aɓalǝ wun ngga.> >> ");
INSERT INTO mbu_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","<<Bangcau nǝ amǝ Isǝrayila sǝ wu nea wia ama, <Lang wu kutina aɓa nzali mǝnana ǝn nggǝ yinǝ wun kam ngga, ");
INSERT INTO mbu_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","nǝ̀ yia do ama, lang wu lina girlina mala nzalî ka, dumǝna púp wun nǝ̀ yinǝ pàgir mala loasǝe a kuli abanam Yahweh. ");
INSERT INTO mbu_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Wun nǝ̀ yinǝ kyak mǝnana à pè nǝ muku mana wu goe a dǝmba ka, sǝ wun nǝ̀ tàrì ɓǝ̀ duk pàgir mǝnana à loasǝi a kuli aban Yahweh ka, kǝla mana wu kǝ pangnǝ mǝsǝsa mǝdǝmbe mana pur a katǝra ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dumǝna púp ama koya pǝlǝa, arǝ anza ma'wun kat ka, wun nǝ̀ nggǝ pê Yahweh pàgir mana à loasǝi a kuli ka aɓa muku mǝdǝmbe mǝnana wu goe ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","<< <Lang wu ɓwarkio, wu gatti kpata anzongcau man mǝnana kat Yahweh banggi Musa ka, ");
INSERT INTO mbu_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","nggearǝ agir mana kat Yahweh na wun nǝ kún Musa, twal a pwari mana Yahweh pana nzongcau nǝi aban ká dǝmba, arǝ anza ma'wun kat ka, ");
INSERT INTO mbu_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","sǝ ɓǝ̀ mǝnia ka wu pè kpakpak ɗang, sǝ pà a mǝsǝ ɓwabundǝa raka, ɓwabundǝa kat nǝ̀ pà lo-jamnda, kǝla pàgir mala pisǝe kǝring, ace pà rǝmban mǝɓoarne mǝnana kǝ pwasǝbumam Yahweh ka, atārǝia andǝ pàgir mala girlina andǝ pàgir mala girnùná male, kǝla mana nggurcau kanì ka, andǝ gbato mwashat ace pàgir mala gǝshi cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Pǝris nǝ shawuɗi ɓwabundǝa mala amǝ Isǝrayila sǝ à nǝ̀ twalia wia banì, acemǝnana ɓwarkio na, sǝ ɗǝm ngga à yinanǝ pàgir malea, yì pàgir nǝ bǝsa aban Yahweh andǝ pàgir mala gǝshi cauɓikea malea aban Yahweh, ace ɓwarkio malea. ");
INSERT INTO mbu_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Sǝ ɓwabundǝa mala amǝ Isǝrayila kat ka, à nǝ̀ twalia wia banì, yia andǝ amǝkúnɗàngna mǝnana à do aɓalǝia ka, acemǝnana mǝno yì gìr à pè ka kum aɓwana kat aɓa ɗwanyi-sǝlǝe. ");
INSERT INTO mbu_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","<< <Ɓǝ̀ ɓwa mwashat pàk cauɓikea aɓa ɗwanyi-sǝlǝe ka, dumǝna púp ama nǝ̀ pà gir'nkila nǝ mamǝna mbul mǝnana mbule mwashat ka, kǝla pàgir mala gǝshi cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Sǝ ɓwa mǝno ɓwarkio, lang pàk cauɓikea aɓa ɗwanyi-sǝlǝe ka, pǝris nǝ̀ shawuɗi a ɓadǝm Yahweh. Nǝ̀ shawuɗì sǝ à nǝ̀ twali wi banì. ");
INSERT INTO mbu_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Nggurcau na mwashat ace ɓwa mǝnana pàk cauɓikea aɓa ɗwanyi-sǝlǝe ka, ko ɓwê ka à ɓǝlì ɓwa Isǝrayila na, ko ɓwa-kúnɗàngna na, mǝnana do aɓalǝ wun ngga. ");
INSERT INTO mbu_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","<< <Sǝ ɓwa mǝnana pàk gìr kpakpak ka, ko ɓwa Isǝrayila na ko ɓwa-kúnɗàngna na ka, ndarǝ ɓǝsǝki Yahweh. Mǝno yì ɓwa ka à nǝ̀ pusǝì aɓalǝ aɓwana male. ");
INSERT INTO mbu_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Acemǝnana nyesǝna cau mala Yahweh ɓà, sǝ yàlni nzongcau male ka, mǝno yì ɓwa ka, à nǝ̀ kasǝì aɓalǝ aɓwana male kat-kat. Bafe male nǝ̀ ueo amurí.> >> ");
INSERT INTO mbu_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Lang amǝ Isǝrayila na aɓa pǝɗanban ngga, à kum ɓeɓwa aban tarki gimsa a pwari Sabbat. ");
INSERT INTO mbu_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Aɓwana mǝnana à kumi aban tarki gimsa ka, à warinǝi aban Musa andǝ Haruna, andǝ ɓwabundǝa kat. ");
INSERT INTO mbu_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","À gìrì a ndà, acemǝnana à malaká kasǝcau amur gìr mǝnana à nǝ̀ pàngnǝi ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yahweh banggi Musa ama, <<Mǝno yì ɓwa ka, dumǝna púp à nǝ̀ wal-luí; ɓwabundǝa ɓǝà ɓukkí nǝ atali zak nǝ kàttì.>> ");
INSERT INTO mbu_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Nda ɓwabundǝa puppup pusǝì zak nǝ kàttì, sǝ à ɓukki nǝ atali wǔ, kǝla mǝnana Yahweh banggi Musa ka. ");
INSERT INTO mbu_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yahweh bang cau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","<<Nacau nǝ amǝ Isǝrayila, sǝ wu banggia wia ama, <Arǝ anza malea kat ka, ɓǝà ɓolǝ ankonggúr ace ɗúrkia arǝ abankara mala kún anggea-daura malea, sǝ arǝ koya ɓolǝo-nkonggúr ka, à nǝ̀ tsǝki wi nkonggúr mǝlùre. ");
INSERT INTO mbu_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Nǝ̀ duk ɓolǝo-nkonggúr ace wun, ace mǝnana ɓǝ̀ wu sǝni, sǝ ɓalǝ wun ɓǝ̀ kasǝa arǝ anzongcau mala Yahweh kat, sǝ wu kpatea, sǝ wu kǝa gya atà ɓabum wun andǝ mǝsǝ wun, mǝnana nǝ̀ kánǝ wun a gyatarǝu atà aɓea aɓakuli ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Anggo sǝ wun nǝ ɗenyinǝ, sǝ wun nǝ̀ kpata anzongcau mem kat, sǝ wun nǝ̀ duk amǝfele aban Ɓakuli ma'wun. ");
INSERT INTO mbu_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mǝ nda Yahweh Ɓakuli ma'wun, mǝnana pusǝ wun aɓa nzali Masar ace duk Ɓakuli ma'wun ngga. Mǝ nda Yahweh Ɓakuli ma'wun.> >> ");
INSERT INTO mbu_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","A ɓe pwari ka, Kora muna-ɓwabura mala Iza, muna-ɓwabura mala Kohat, muna-ɓwabura mala Lawi, twal Datan andǝ Abiram, amuna-burana mala Eliyap, andǝ On muna-ɓwabura mala Pele, amǝkà Ruben, atè. ");
INSERT INTO mbu_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Sǝ à lo arǝ Musa, atārǝia andǝ aɓea aburana gbǝman-ɓari nǝ lumi-tongno, mǝnana à súrǝ̀ia pepè, sǝ amǝ Isǝrayila twalia ɓǝà duk aɓwana-mǝgule amur ɓwabundǝa ka. ");
INSERT INTO mbu_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","À kya ram rǝia a banɓwáná arǝ Musa andǝ Haruna sǝ à banggia wia ama, <<Wu umá ɗār! Koyan aɓa ɓwabundǝa mǝnia kat ka mǝfele na, sǝ Yahweh ka nda aɓalǝia! Sǝ palang sǝ wu kǝ loasǝ ɓamur rǝ wun amur ɓwabundǝa mala Yahweh?>> ");
INSERT INTO mbu_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Lang Musa ok cau man ngga, kara kpa nǝ ɓamǝsǝi a nzali, ");
INSERT INTO mbu_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","sǝ ne Kora andǝ aɓwana mǝnana kat atè ka, ama, <<Nǝ dǝmbari ka, Yahweh nǝ̀ lǝmdǝ yana nda male, sǝ yana nda mǝfele andǝ ɓwa mǝnana nǝ̀ yinǝi tù a baní ka. Ɓwa mǝnana Yahweh nǝ̀ twal ka, nǝ̀ yinǝi tù a baní. ");
INSERT INTO mbu_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","We Kora wunǝ aɓwana mô kat, wu pàk mǝnia ka: wu twal atasau-bǝsa; ");
INSERT INTO mbu_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","lí ka, wu tsǝk bǝsa aɓalǝia, sǝ wu so muku-gìr loasǝ yele mǝ'rǝmɓoarne amúrià aɓadǝm Yahweh. Ɓwa mǝnana Yahweh nǝ̀ twal ka, nǝ̀ duk ɓwa mǝnana mǝfele na ka. Wun amuna-burana mala Lawi ka, wu umá ɗār!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Pǝlǝa Musa ne Kora ama, <<Wu ǒ, wun amuna-burana mala Lawi: ");
INSERT INTO mbu_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Wu kǝ sǝni ama gìr mǝkyauwe na, mǝnana Ɓakuli mala amǝ Isǝrayila tàr wun aɓa ɓwabundǝa mala Isǝrayila, ace yinǝ wun tù a baní, ɓǝ̀ wu pàk túró a Taragula mala Yahweh, sǝ ɓǝ̀ wu came a ɓadǝm ɓwabundǝa ace pakkia wia túró ka, ");
INSERT INTO mbu_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","sǝ ɗǝm ngga yinanǝ wun tù a baní, wun kat andǝ amǝ'eam wun amuna-burana mala Lawi ka le? Wu ndarǝ alta dobuno-pǝris gbal le? ");
INSERT INTO mbu_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Acemani ka, nda arǝ Yahweh sǝ wun, wunǝ amǝ kpata wun ngga, wu ram rǝwun! Yana nda Haruna mǝnana wu kǝ nggwani wi ka?>> ");
INSERT INTO mbu_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Sǝ Musa túrban ɓǝà tunǝ Datan andǝ Abiram, amuna-burana mala Eliyap ɓǝà yiu; sǝ à bang ama, <<Pà sǝm nǝ̀ ká ɗàng! ");
INSERT INTO mbu_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","A kǝ sǝni kǝla gìr mǝkyauwe na mǝnana a pusǝ sǝm, sǝm purî ɓá nzali mǝnana mur-nyi andǝ kiura kǝ ɓang kàm ngga, ace wal-lú sǝm aɓa pǝɗanban ngga, sǝ ado ka a kǝ earce lǝmdǝ do-ɓwamǝgule amur sǝm gbal le? ");
INSERT INTO mbu_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Sǝ yale a malaká yinǝ sǝm a nzali mǝnana mur'nyi andǝ kiura kǝ ɓang kàm ngga ɗàng, sǝ a pa sǝm aɓaban-mǝssa andǝ aɓaban-anap ɓǝà duk agirkuma ma'sǝm ɗàng. A kǝ sǝnì kǝla sǝm pànǝ ɗenyicau re? Awo, pà sǝm nǝ ká ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Bum Musa lul kǝ̀rkǝ́r, sǝ ne Yahweh ama, <<Cè a ak apagir malea ɗàng. Ən ak kǝ mǝdambǝriso a bu kǝɓwa ateà ɗàng, sǝ ǝn pakkì kǝɓwa ateà kǝgir mǝɓane ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Sǝ Musa ne Kora ama, <<Lí ka, we wunǝ amǝ'tò kat, wu kya ɓadǝm Yahweh; we, yià sǝ Haruna. ");
INSERT INTO mbu_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Koyan atà wun ngga ɓǝ̀ twal tasau-bǝsa male, sǝ ɓǝ̀ so muku-gìr loasǝ yele mǝ'rǝmɓoarne aɓalǝi, sǝ koyan ngga ɓǝ yinǝ tasau-bǝsa male aɓadǝm Yahweh, atasau-bǝsa gbǝman-ɓari nǝ lumi-tongno; we gbal, sǝ Haruna, koyan nǝ tasau-bǝsa male.>> ");
INSERT INTO mbu_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Koyan ateà ka, twal tasau-bǝsa male, tsǝk bǝsa aɓalǝi, sǝ so muku-gìr loasǝ yele mǝ'rǝmɓoarne amurí, sǝ came a bankutio aɓa Tara Ban-peri, atārǝia andǝ Musa andǝ Haruna. ");
INSERT INTO mbu_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora ram ɓwabundǝa arǝia a bankutio aɓa Tara Ban-peri. Ɓoarɓwa mala Yahweh pusǝrǝi aban ɓwabundǝa kat. ");
INSERT INTO mbu_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yahweh ne Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","<<Wu gǝ́shìban ɓinala aɓwana mǝnia ka, ace mǝnana mǝ twaltea akǝ dyadyan!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Sǝama Musa andǝ Haruna kpa nǝ ɓamǝsǝia, sǝ à bang ama, <<We Ɓakuli, Ɓakuli mala abangŋo mala aɓwapǝndǝa kat, ɓwa mwashat nǝ̀ pàk cauɓikea sǝ awu nǝ pak-bumlulla nǝ ɓwabundǝa kat le?>> ");
INSERT INTO mbu_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Pǝlǝa Yahweh nacau nǝ Musa, ama, ");
INSERT INTO mbu_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","<<Banggi ɓwabundǝa ama, <Wu gǝ́shìban agumli mala Kora, Datan andǝ Abiram!> >> ");
INSERT INTO mbu_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Pǝlǝa Musa lo wari aban Datan andǝ Abiram; sǝ aɓwana-mǝgule mala Isǝrayila o atè. ");
INSERT INTO mbu_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Sǝ banggi ɓwabundǝa ama, <<Ida, wu upi ban agumli mala aburana amǝɓealɓike man, sǝ wu kǝa je kǝgir malea ɗàng, ɓǝ̀ ana raka à nǝ̀ twalta wun aɓalǝ acauɓikea malea kat!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nda à gǝ́shìban agumli mala Kora, Datan andǝ Abiram, a koya buì. Datan andǝ Abiram puro à cam a kún agumli malea andǝ amālea, amuna-burana malea andǝ amuna mǝkèke malea. ");
INSERT INTO mbu_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa bang ama, <<Nǝ mǝnia ka sǝ wun nǝ̀ sǝlǝa ama Yahweh túrǎm ɓǝn pakki atúró mǝnia ka; à pur aɓa ɗenyicau mem ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ɓǝ̀ aɓwana mǝnia wú kǝla mana aɓwana kat kǝ wú ka, ko ana raka, ɓǝ̀ gìr mǝnana kumgiyi aɓwana nda mana nǝ̀ kumia ka, Yahweh nǝ̀ túrǎm ɗang. ");
INSERT INTO mbu_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Sǝama ɓǝ̀ Yahweh pàk gìr mǝbǝshe, sǝ nzali mǝn kúni myalia kat andǝ agir mana amalea na, sǝ à kùtí nǝmǝsǝia a Shewol ka, sǝ wun nǝ̀ sǝlǝa ama aburana man ɓǝsǝkina Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Lang malǝna naki acau mǝnia ka, kara nzali mǝnana à cam amurí ka gauwa mǝnna. ");
INSERT INTO mbu_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Nzali mǝn kúni, sǝ myalia andǝ amǝɓala malea, aɓwana mala Kora kat, andǝ agirkuma malea. ");
INSERT INTO mbu_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Anggo sǝ yia, andǝ agirkuma malea kat ka, à ko nǝmǝsǝia a Shewol; sǝ nzali gir amúrià, tea-twalî ɓá ɓwabundǝa. ");
INSERT INTO mbu_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Makki'zwalo malea tsǝk amǝ Isǝrayila mǝnana kat à kàrìbania ka à lo nǝ mire; à bang ama, <<Cè nzali myal sǝm ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Bǝsa sulǝ nǝban Yahweh, pisǝ aɓwana mǝno gbǝman-ɓari nǝ lumi-tongno mǝnana à pàgir mala loasǝ yele mǝ'rǝmɓoarne ka. ");
INSERT INTO mbu_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yahweh bangcau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","<<Banggi Eleaza muna-ɓwabura mala Haruna yì pǝris, ama ɓǝ̀ pwangi atasau-bǝsa aɓa pibǝsa, acemǝnana amǝfele na. Sǝ ɓǝ̀ mesǝki ankalang-bǝsanì kuko nǝ kàttì. ");
INSERT INTO mbu_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Atasau-bǝsa mala aɓwana mǝnia à pàk cauɓikea sǝ warinǝia à ɗwanyi yilǝmia ka, ɓǝà walkia lapat-lapat, ace gìr-rǝ gyangŋan nǝia, acemǝnana à panagir nǝia aban Yahweh. Acemani ka amǝfele na. À nǝ̀ duk gìr'lǝmdǝa aban amǝ Isǝrayila.>> ");
INSERT INTO mbu_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Nda Eleaza yì pǝris twal amǝnia yì atasau-bǝsa mala bolo-bángŋá, mǝnana aɓwana mana à pisǝia ka, à panagir nǝia ka, sǝ walkia lapat-lapat, à pǝlǝ gìr gìr-rǝ gyangŋan, ");
INSERT INTO mbu_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","kǝla mana Yahweh banggi wi nǝ kún Musa ka. Mǝno ka nǝ̀ duk gir kasǝɓalǝu aban amǝ Isǝrayila ama kǝ ɓwa-ɗàng pà kàm, mǝnana pur a tàu mala Haruna raka, nǝ̀ sung tù ama nǝ̀ pàgir mala pisǝ muku-gìr loasǝ yele mǝ'rǝmɓoarne aɓadǝm Yahweh ka ɗang, ace mǝnana ɓǝ̀ kǝa pa kǝla Kora andǝ amǝtè ka ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Sǝama lang ban yi fana ka, ɓwabundǝa mala amǝ Isǝrayila nggwanî Musa andǝ Haruna ama, <<Wu walna-lú aɓwana mala Yahweh!>> ");
INSERT INTO mbu_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Sǝ lang ɓwabundǝa yi ramba arǝ Musa andǝ Haruna ka, à pǝlǝ mǝsǝia nǝban Tara Ban-peri. Kara à sǝni ka pǝrɓang girna murí, sǝ ɓoarɓwa mala Yahweh pusǝrǝi. ");
INSERT INTO mbu_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Pǝlǝa Musa andǝ Haruna yiu a bankutio aɓa Tara Ban-peri, ");
INSERT INTO mbu_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yahweh nacau nǝ Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","<<Wu gǝ́shìban ɓwabundǝa mǝnia ka, ace mǝnana ɓǝn twaltea adyan.>> Sǝama à kpa nǝ ɓamǝsǝia a nzali. ");
INSERT INTO mbu_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Sǝ Musa ne Haruna ama, <<Twal tasau-bǝsa mò, ɗàrǝ́ nkalang-bǝsa mana nda amur gyangŋan ngga aɓalǝi, sǝ wu so muku-gìr loasǝ yele mǝ'rǝmɓoarne amurí. Kyane akaurǝa aban ɓwabundǝa sǝ wu shawuɗia, acemǝnana bumlulla sulǝna nǝban Yahweh! Kwánó-ɓikea tinate.>> ");
INSERT INTO mbu_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Nda Haruna pa kǝla mana Musa banggi wi ka; twal tasau-bǝsa male, sǝ ɓangŋa wari a tsùrú mala ɓwabundǝa, sǝ sǝni ka kwánó-ɓikea tinate aɓalǝ aɓwana. Pǝlǝa so muku-gìr loasǝ yele mǝ'rǝmɓoarne, sǝ shawuɗi aɓwe. ");
INSERT INTO mbu_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Yi came a nre ka alú andǝ amǝyilǝmu, sǝ à tamsǝ kwánó-ɓikea, lidǝmba ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Làkkì mala aɓwana mǝnana à wù atàcau mala kwánó-ɓikea mǝnia ka, à nda á-lum-nong-ine nǝ gbǝman-tongno-nong-ɓari (14,700), amur amǝno à wu a gìr-kumban mala Kora ka. ");
INSERT INTO mbu_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Anzǝm mǝnana à tàmsǝna kwánó-ɓikea ka, Haruna nyar aban Musa a bankutio aɓa Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","<<Nacau nǝ amǝ Isǝrayila, sǝ wu ak agara lum-nong-ɓari a buia, mwashat ace koya ɓala-kàu, a bu amúrû kat arǝ aɓala-kàu malea. Gilǝ lullǝ koya múrû arǝ gara male, ");
INSERT INTO mbu_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","sǝ wu gilǝ lullǝ Haruna amur gara mala Lawi. Koya múrû mala koya ɓala-kàu ka nǝ̀ pàngnǝ gara mwashat. ");
INSERT INTO mbu_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tsǝk agara mǝnia ka aɓa Tara Ban Peri, aɓadǝm Akwati mala Acau-nakûn, ban mǝnana ǝn nggǝ je sǝnǝ we kam ngga. ");
INSERT INTO mbu_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Sǝ gara mala ɓwa mǝnana ǝn twal ka nǝ̀ tò-mbuí. Anggo sǝ mǝ nǝ tamsǝ nggwani mala amǝ Isǝrayila mǝnana à kǝ̀ yinǝi tùtù amuro ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nda Musa nacau nǝ amǝ Isǝrayila ka; sǝ koyan atà amúrû malea pe wi gara, mwashat ace koya múrû mala koya ɓala-kàu, agara lum-nong-ɓari, sǝ gara mala Haruna ka nda aɓalǝ amalea. ");
INSERT INTO mbu_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa pǝlǝa tsǝk agara mǝnia ka, aɓadǝm Yahweh, aɓa Tara mala Acau-nakûn. ");
INSERT INTO mbu_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Lang ban fana ka, Musa kúti aɓa Tara mala Acau-nakûn, kara sǝni ka, gara mala Haruna, mana nda ace tàu mala Lawi ka, tongŋǝna sǝ pusǝna mbuí arǝì, sàngŋǝ̀nà pwasǝe, sǝ pusǝna aɓǝla-almon mǝnana à bangŋǝ́nà ka. ");
INSERT INTO mbu_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa pǝlǝa pusǝ agara mǝno a ɓadǝm Yahweh, yinǝia aban amǝ Isǝrayila kat. Pǝlǝa à sǝnggi agare kat, sǝ koya múrû ka twal gara male. ");
INSERT INTO mbu_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Sǝ Yahweh banggi Musa ama, <<Nyesǝ gara mala Haruna tsǝì aɓadǝm Akwati mala Acau-nakûn, ace mǝnana ɓǝ̀ duk gir'lǝmdǝa aban amǝ'mgbicau. Mǝnia ka nǝ̀ tamsǝ nggwani malea arǝàm, ɓǝ̀ ana raka à nǝ̀ wukio.>> ");
INSERT INTO mbu_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Anggo sǝ Musa pa, kǝla mǝnana Yahweh pe wi nzongcau ama ɓǝ̀ pàk ka. ");
INSERT INTO mbu_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Sǝ amǝ Isǝrayila banggi Musa ama, <<Sǝni, ma'sǝm malǝna! Sǝm wukina! Sǝm kiɗikina! ");
INSERT INTO mbu_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Koyan mǝnana sung tù, mǝnana gbàshì ban Taragula mala Yahweh ka, nǝ̀ wǔ. Sǝm kat ka, sǝm nǝ̀ wuki le?>> ");
INSERT INTO mbu_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yahweh banggi Haruna ama, <<We, wunǝ amuna-burana mô andǝ ɓala-kàu mò atò ka wun nda à nǝ̀ tsǝka wun cau arǝ wun mala koya gìr mǝɓane mǝnana kum agir mǝnana à nda aɓa Tara-mǝfele ka. Sǝ we wunǝ amuna-burana mô atò ka, wun nda à nǝ̀ tsǝka wun cau arǝ wun ɓǝ̀ apǝris ɗwanyi kpata nggurcau mala túró pǝris ma'wun ngga. ");
INSERT INTO mbu_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ɗǝm ngga, amǝ'eambo a tàu mala Lawi, yì tàu mala akeô ka, awu nǝ yinǝia ace mǝnana ɓǝà pàkkô gbasha; sǝ we wunǝ amuna-burana mô mana atò ka, wun nǝ̀ pa aɓadǝm Tara mala Acau-nakûn. ");
INSERT INTO mbu_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Yia ka, à nǝ̀ kpata cau mò andǝ bwal túró mǝnana à nǝ̀ nggǝ pa aɓa Taragula kat ka. Sǝama, dumǝna púp, à pà nǝ̀ yiu tù aban agirtúró mala Ban-mǝfele ko gyangŋan ɗàng, ɓǝ̀ ana raka à nǝ̀ wǔ, sǝ awu nǝ wǔ. ");
INSERT INTO mbu_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Yia ka, dumǝna púp à nǝ̀ kpapibu nǝ we ace tsǝkir Tara Ban-peri andǝ pakki atúró mala Tara Ban-peri kat. Ɓwa-ɗàng pà nǝ̀ gbàshìban wun ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","<<Wun nda wu nǝ̀ nggǝ pakki atúró mala Tara-mǝfele andǝ atúró mala gyangŋan ngga, ace mǝnana bumlulla mala Yahweh ɓǝkǝa sulǝo amur amǝ Isǝrayila ɗǝm raka. ");
INSERT INTO mbu_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Sǝni, Mim nǝ ɓamúràm ngga, ǝn tarna amǝ'eambo Amǝ'Lawi, aɓalǝ amǝ Isǝrayila. À nda ka ɓoro a bano, mana à pànî Yahweh, ace pàk túró mala Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Sǝama, we wunǝ amuna-burana mô ka, wun nǝ̀ pàk túró-dopǝris ma'wun ace koman kat mala gyangŋan andǝ gìr mǝnana à nǝ̀ pe aɓa Ban Nggea Mǝfele ka. Wun nǝ̀ pàk túró-pǝris. Mǝ ndaban pa wun túró-dopǝris kǝla ɓoro ace túrô. Sǝ ɓwa-ɗàng mǝnana yiu tù aban Tara-mǝfele ka, dumǝna púp à nǝ̀ wal-lui.>> ");
INSERT INTO mbu_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Pǝlǝa Yahweh banggi Haruna ama, <<Sǝni, Mim nǝ ɓamúràm, ǝn tsǝ́ngŋǝ̀nó amur apagir mana à yinǝia abanam ngga, yì aɓoro mǝfele mana kat amǝ Isǝrayila pa abanam ngga. We wunǝ amuna-burana mô andǝ amǝ'keo ka wun nǝ̀ kum kāmbe mana à pusǝì aɓalǝ aɓoro mǝfele mǝnia ka; dumǝna nê mana à nǝ̀ kpate ka tàtǝ́k. ");
INSERT INTO mbu_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kāmbe aɓalǝ apagir nggea mǝfele mana à pisǝia kǝring raka, komǝye atà apagir malea mǝnana à pà abanam, koya pàgir mala mǝsǝsa, andǝ koya pàgir mala gǝshi cauɓikea, andǝ koya pàgir mala kumcau, mǝnana à nǝ̀ pà abanam ngga, à nǝ̀ duk nggea mǝfele aceo sǝ ace amunio andǝ amǝ'keò. ");
INSERT INTO mbu_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Wun nǝ̀ lì a ban nggea mǝfele. Koya muna-ɓwabura ka nǝ̀ gandǝ li. Nǝ̀ duk gìr mǝfele aban wun. ");
INSERT INTO mbu_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","<<Mǝnia gbal ka, mona: kāmbe mǝnana à twal aɓa pàgir mala aɓoro malea, yì apagir mǝnana kat amǝ Isǝrayila pà abanam nǝ loasǝe a kuli ka. Ən pano wia, we wunǝ amuna-burana andǝ amuna-mamǝna mô atò. Dumǝna nê mana à nǝ̀ kpate ka tàtǝ́k. Koya ɓwa mǝnana nda aɓa ɓoarnsari a ɓala mò ka, nǝ̀ gandǝ li. ");
INSERT INTO mbu_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","<<Mùrú olif kat nggea-mǝɓoarne mǝnana à tita kàmbe, andǝ mùr-anap kat nggea-mǝɓoarne mǝnana à tita kàmbe, andǝ mǝsǝsa nggea-mǝɓoarne mǝnana à tita pwane, yì aɓǝlagir mǝdǝmbe malea mǝnana à kǝ yinǝia ace pè abanam Mim Yahweh ka, ǝn pano wia. ");
INSERT INTO mbu_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Aɓǝlagir mǝdǝmbe mala koman kat, mǝnana nda aɓa nzali malea, mǝnana à kǝ yinǝia aban Yahweh ka, amona. Koya ɓwa mǝnana nda aɓa ɓoarnsari a ɓala mò ka, nǝ̀ gandǝ li. ");
INSERT INTO mbu_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","<<Koya gìr a Isǝrayila, mana à tàrni acem Yahweh ka, dumǝna mona. ");
INSERT INTO mbu_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Koya muna-dǝmba mala agir mǝnana nǝyilǝmu, mana tita puro a bum ngge, ko ɓwapǝndǝa ko girkusǝu na, mana à kǝ panagir nǝi abanam Yahweh ka, mona. Sǝama, dumǝna púp, aɓwana nǝ̀ akmúr muna-dǝmba mala ɓwapǝndǝa, sǝ à nǝ̀ akmúr muna-dǝmba mala girkusǝu mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Akmúria lang à lùmsǝ̀nà zongŋo mwashat anzǝm ɓǝlia ka. Boalo akmúria ka shekel tongno mala mǝsǝbolo-azǝrfa na. Kpata shekel mǝnana à kārǝ́ dǝmbǝrya male sǝ à earna amurí a Tara-mǝfele (mǝnana shekel mwashat ka mǝtyang lum-nong-ɓari na ka). ");
INSERT INTO mbu_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","<<Sǝama muna-dǝmba mala ndǎ, ko muna-dǝmba mala nzur, ko muna-dǝmba mala mbulpǝndǝa ka, à pà nǝ̀ akmúria ɗàng; amǝfele na. Awu nǝ watsǝki nkilea amur gyangŋan, sǝ awu nǝ pisǝ mùrú-nyama malea kǝla pàgir nǝ bǝsa mǝnana kǝ pa rǝmban mǝɓoarne mana kǝ pwasǝbumam Yahweh ka. ");
INSERT INTO mbu_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyam agirkusǝu mǝnia ka, dumǝna mona, kǝla mana nyam kikil girkusǝu andǝ byali mǝlì mana à pàgir nǝi nǝ loasǝe a kuli ka, amona ka. ");
INSERT INTO mbu_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Apagir mǝfele mana amǝ Isǝrayila kǝ yinǝia ace pè Yahweh ka, ǝn pano, we wunǝ amuna-burana andǝ amuna-mamǝna mô atò, kǝla nê mana à nǝ̀ kpate ka tàtǝ́k. Mǝnia ka dumǝna kùrcau mala tuɓamur, mana pà nǝ̀ mal raka, aɓadǝm Yahweh, aceo andǝ amǝ'keò atò.>> ");
INSERT INTO mbu_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Pǝlǝa Yahweh banggi Haruna ama, <<Wun apǝris ka pà wu nǝ̀ kum kǝ nzali ace liɓala atà amǝ Isǝrayila ɗàng, sǝ pà wu nǝ̀ kum kǝ kāmbe ama ma'wun na ateà ɗàng. Mǝ nda kāmbe mana wun nǝ̀ kum ngga andǝ gìr liɓala ma'wun aɓalǝ amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","<<Sǝni, ǝn panì Amǝ'Lawi banì-mwashat-aɓa-lum mala agirkuma kat a Isǝrayila ɓǝ̀ duk gìr liɓala malea, a kúnì túró mǝnana à kǝ pak ka, yì túró mala Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Amǝ Isǝrayila pà nǝ̀ gbàshìban Tara Ban-peri ɗǝm ɗàng, ɓǝ̀ ana raka à nǝ̀ twal cauɓikea amúrià, sǝ à nǝ̀ wǔ. ");
INSERT INTO mbu_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Amǝ'Lawi na mǝnana à earia wia ɓǝà pak túró mala Tara Ban-peri ka, sǝ à nǝ̀ twal bafe mala cauɓikea malea amúrià. Mǝnia ka nggurcau na mǝnana nggaɗe pà kàm raka arǝ anza ma'wun kat. Amǝ'Lawi pànǝ kǝ nzali ace liɓala atà amǝ Isǝrayila ɗàng; ");
INSERT INTO mbu_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Pàgir mala banì-mwashat-aɓa-lum mǝnana amǝ Isǝrayila kǝ yinǝi ace pàgir aban Yahweh ka, ǝn pania wia ɓǝ̀ duk gìr liɓala malea. Acemani ka, ǝn banggia wia nǝma à pànǝ kǝ nzali ace liɓala atà amǝ Isǝrayila ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Pǝlǝa Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","<<Nacau nǝ Amǝ'Lawi sǝ wu banggia wia ama: <Lang wu angŋa banì-mwashat-aɓa-lum mala agirkuma a bu amǝ Isǝrayila, mana ǝn pana wuni ɓǝ̀ duk gir liɓala ma'wun ngga, dumǝna púp wun nǝ̀ pusǝ banì-mwashat-aɓa-lum male, wun nǝ̀ panagir nǝi aban Yahweh; mǝnia ka nda banì-mwashat-aɓa-lum mala banì-mwashat-aɓa-lum. ");
INSERT INTO mbu_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Mǝnia yì pàgir ma'wun ngga Yahweh nǝ̀ ɗenyinǝi kǝla weama pàgir na mǝnana puro arǝ aɓaban ma'wun, mala bǝsa mǝsǝsa mǝnana à nyé a katǝra, andǝ mala mùr-anap mana à kambi arǝ ɓǝle mǝbangŋe ka, sǝ nǝ̀ ɓwangsǝ wun aceì. ");
INSERT INTO mbu_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Acemani ka, dumǝna púp wun nǝ̀ yinǝ pàgir gbal aban Yahweh. Aɓa koya banì-mwashat-aɓa-lum mǝnana wu ak a bu amǝ Isǝrayila ka, wun nǝ̀ pusǝ kāmbe mǝnana nda ace pàgir aban Yahweh ka, wun nǝ̀ pè Haruna, yì pǝris. ");
INSERT INTO mbu_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Aɓa koya ɓoro mǝnana aɓwe pà wun ngga, dumǝna púp wun nǝ̀ pusǝ kāmbe mǝnana nda acem Yahweh ka; kāmbe nggea-mǝɓoarne mala komǝye ka, nda wun nǝ̀ tàrì acem Yahweh ka.> ");
INSERT INTO mbu_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","<<Banggi Amǝ'Lawi ama, <Lang wu pana kāmbe nggea-mǝɓoarne mala banì-mwashat-aɓa-lum ngga, à nǝ̀ ɓwangsǝ wun, wun Amǝ'Lawi aceì, kǝla weama wu pusǝ aɓǝlagirì a katǝra andǝ ban-kam-anap. ");
INSERT INTO mbu_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Sǝ wun Amǝ'Lawi, andǝ amǝ'ɓala ma'wun ngga, wun nǝ̀ gandǝ li girline a koya ban mǝnana wu earce ka. Mǝnia ka, nda tangnakusǝ wun ace túró mana wu kǝ pa aɓa Tara Ban-peri ka. ");
INSERT INTO mbu_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","À pà nǝ̀ na ama, wu pàngŋǝ̀nà gìr mǝɓane nǝ twal banì-mwashat-aɓa-lum mala Yahweh ɗàng, ɓǝ̀ wu pànî apǝris kāmbe nggea-mǝɓoarne malea ka. Sǝama, wu tsǝkir wun, wu kǝa nyesǝ apagir mǝfele mala amǝ Isǝrayila, kǝla gìr mǝkyauwe ɗàng. Ɓǝ̀ wu pàk anggo ka, wun nǝ̀ wǔ.> >> ");
INSERT INTO mbu_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yahweh nacau nǝ Musa andǝ Haruna ama, ");
INSERT INTO mbu_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","<<Mǝnia ka nda nê mala nggurcau mǝnana Yahweh tsǝk ka: Banggi amǝ Isǝrayila ɓǝà yinǝo nǝ muna-ndá mǝbangŋe, mǝnana pànǝ ɓekǝ doak arǝì ɗàng, pànǝ ɓekǝ gìr mǝɓane arǝì ɗàng, sǝ à malaká tsǝki wi nggun-rya a myali a kǝ fara raka. ");
INSERT INTO mbu_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Awu nǝ pè Eleaza, pǝris; sǝ yì ka nǝ̀ kánǝi anzǝm kàttì, sǝ à nǝ̀ pwanmeali a ɓadǝmbi. ");
INSERT INTO mbu_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Pǝlǝa Eleaza pǝris nǝ̀ ɗàrǝ́ aɓa nkile nǝ munabui, sǝ nǝ̀ watsǝki kusǝ tongno-nong-ɓari, nǝ njar ɓadǝm Tara Ban-peri. ");
INSERT INTO mbu_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Pǝlǝa à nǝ̀ pisǝ muna-ndá man a mǝsǝi; ngguí, andǝ nyami, andǝ nkile andǝ ciute ka, à nǝ̀ pisǝia a bǝsa. ");
INSERT INTO mbu_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Sǝ pǝris ka, nǝ̀ twal nggun-seda andǝ bondo-hisop andǝ bugir mǝbangŋe, sǝ nǝ̀ túriá aɓa bǝsa mǝnana muna-ndá kǝ pi aɓalǝi ka. ");
INSERT INTO mbu_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Pǝlǝa pǝris ka, dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo; anzǝm mǝno ka, nǝ̀ gandǝ kutio a kàttì, sǝ kat andǝ amani ka, nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Sǝ ɓwa mana pisǝ mǝno yì muna-ndá ka, dumǝna púp yì gbal ka nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo; sǝ kat andǝ amani ka nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","<<Ɓwa mǝnana mǝɓoarnsari na ka, nǝ̀ ram tú muna-ndá mǝnia ka, sǝ nǝ̀ soe a ban mǝɓoarnsari anzǝm kàttì. Nǝ̀ duk gir mǝnana ɓwabundǝa mala amǝ Isǝrayila nǝ̀ tsǝkce ka, ace mǝnana à nǝ̀ zurì a mùr ace lak ɓwa mǝnana kpa aɓa ɓeami ka. Pàgir na ace lak cauɓikea. ");
INSERT INTO mbu_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Sǝ ɓwa mǝnana ram tú muna-ndá ka, dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ kat andǝ amani ka nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. Mǝnia ka, nǝ̀ duk nggurcau mǝnana málá male pà kàm raka aban amǝ Isǝrayila, sǝ aban amǝ'kúnɗàngna mana à do aɓalǝia ka. ");
INSERT INTO mbu_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","<<Ɓwa mǝnana je lú ɓwapǝndǝa ka, nǝ̀ duk mǝɓeami ba nongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Yì ka, dumǝni wi púp nǝ̀ lak ɓamurì arǝ do-ɓeami male nǝ mùr a tàruia pwari andǝ tongno-nong-ɓaria pwari, sǝ nǝ̀ ɓoarnsari; sǝ ɓǝ̀ lak ɓamurì a tàruia pwari andǝ tongno-nong-ɓaria pwari raka, pà nǝ̀ ɓoarnsari ɗang. ");
INSERT INTO mbu_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ɓwa mǝnana kat je rǝ ɓwa mǝnana wuna, sǝ lak rǝì raka, nǝ̀ tsǝk Taragula mala Yahweh nǝ̀ pǝndǝkya; sǝ mǝno yì ɓwa ka à nǝ̀ kasǝì a Isǝrayila. Yì ka, nǝ̀ ueo aɓa do-ɓeami acemǝnana à watsǝki wi mùr lakban amurí ɗàng. Do-ɓeami male ka nda arǝì piu. ");
INSERT INTO mbu_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","<<Mǝnia ka nda nggurcau mana à nǝ̀ kpate ɓǝ̀ ɓwa wǔ aɓa gumli ka: ɓwa mǝnana kat kúti aɓa gumli mǝnia andǝ koyan mǝnana kat nda aɓa gumli mǝnia ka, nǝ̀ pa aɓa do-ɓeami mala anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Sǝ koya kwár aɓa gumli mǝnia, mǝnana nda atarǝì, à kumsǝi wi gìrkúni raka, dumǝna mǝɓeami. ");
INSERT INTO mbu_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","<<Sǝ ɓwa mana kat, nda a ɓawanban, sǝ je rǝ ɓwa mana à wal-luí nǝ nggeabyau, ko mǝnana wǔ atarǝì ka, ko je mǔ ɓwapǝndǝa, ko ɓembe ka, nǝ̀ pà aɓa do-ɓeami mala anongŋo tongno-nong-ɓari. ");
INSERT INTO mbu_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","<<Ace lak ɓwa mǝnana mǝɓeami na ka, à nǝ̀ ɗàrǝ́ aɓa tú mala pàgir ace gǝshi cauɓikea, mǝnana à pisǝì kǝring ngga, à nǝ̀ soé a dù, sǝ à nǝ̀ soapi wi mùr mana kǝ ɓang ngga amurí. ");
INSERT INTO mbu_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ɓwa mǝnana mǝɓoarnsari na ka, nǝ̀ twal bondo-hisop, nǝ̀ oasǝi a mùrî, sǝ nǝ̀ watsǝki arǝ gumli mǝnia ɓwa wù kam ngga, sǝ arǝ agir mǝnana aɓalǝi ka, andǝ aɓwana mǝnana à ndakam ngga. Yì ɗǝm ngga, nǝ̀ watsǝki arǝ ɓwa mǝnana kat je mǔ ɓwapǝndǝa, ko ɓembe, ko je rǝ ɓwa mana wǔ atarǝì, ko ɓwa mana à wal-luí ka. ");
INSERT INTO mbu_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","<<Sǝ ɓwa mǝnana mǝɓoarnsari na ka, nǝ̀ watsǝki ɓwa mana mǝɓeami na ka a tàruia pwari andǝ tongno-nong-ɓaria pwari; sǝ a tongno-nong-ɓaria pwari ka nǝ̀ lé arǝ do-ɓeami male. Sǝ ɓwa mǝnana à kǝ lé ka, dumǝna púp nǝ̀ lakki agir'nggūrǝì, sǝ nǝ̀ sussǝo, sǝ nǝ pwarikpǝra ka, nǝ̀ duk mǝɓoarnsari. ");
INSERT INTO mbu_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Sǝama ɓǝ̀ ɓwa ka duk mǝɓeami, sǝ ɓinǝ lak rǝì arǝ do-ɓeami male ka, mǝno yì ɓwa ka à pà nǝ̀ eari wi ɓǝ̀ do aɓa ɓwabundǝa mala Isǝrayila ɗàng, acemǝnana pǝndǝkina Ban-mǝfele mala Yahweh. Acemǝnana à watsǝki wi mùr lakban arǝ do-ɓeami amurí raka, mǝɓeami na. ");
INSERT INTO mbu_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Mǝnia ka, nǝ̀ duk nggurcau mǝnana málá male pà kàm raka acea. Sǝ ɓwa mǝnana watsǝkiyi mùr lakban ngga, dumǝna púp, yi gbal ka, nǝ̀ lakki agir'nggūrǝì, sǝ ɓwa mǝnana kat je mǝnia yì mùr lakban arǝ do-ɓeami ka, nǝ̀ ueo aɓa do-ɓeami ba pwarikpǝra. ");
INSERT INTO mbu_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Gìr mǝnana kat ɓwa mǝɓeami je ka, gìrnî nǝ̀ duk mǝɓeami; sǝ ɓwa mǝnana kat je gìrnî ka, nǝ̀ duk mǝɓeami ba pwarikpǝra.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sǝ ɓwabundǝa mala amǝ Isǝrayila puppup yiu aɓa pǝɗanban Zin, a zongŋo mǝdǝmbe. Aɓwe yi tsǝk là-gumli a Kadesh. Miriyam paklú kano, sǝ à tsǝkluí kano. ");
INSERT INTO mbu_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","A ban mǝno ka mùr pà kàm ace ɓwabundǝa ɗàng; pǝlǝa à ram rǝia sǝ à mgbicau arǝ Musa, sǝ arǝ Haruna. ");
INSERT INTO mbu_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kún aɓwe ɓua arǝ Musa ama, <<Ɓǝ̀ sǝm wukina atà amǝ'eam sǝm a pwari mǝno à wuki a ɓadǝm Yahweh ka, ɓǝ́ nǝ̀ ɓoaribani! ");
INSERT INTO mbu_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Palang sǝ a yinǝ ɓwabundǝa mala Yahweh a ɓabondo man? A yinǝ sǝm ace mǝnana sǝm, sǝnǝ agirkusǝu ma'sǝm ngga, ɓǝ̀ sǝm yi wuki kani ka le? ");
INSERT INTO mbu_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Palang sǝ a pusǝ sǝm, sǝm purî nzali Masar? A pusǝ sǝm ace yinǝ sǝm a ban mǝɓike mǝnia ka le? Ban mǝnana kǝ mǝsǝsa, ko nggun-bwari, ko nggun-anap, ko nggun-mɓǝring pà kàm ɗàng, sǝ kǝ mùr pà kàm mana sǝm nǝ̀ nu ka raka!>> ");
INSERT INTO mbu_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Pǝlǝa Musa andǝ Haruna, nying ɓadǝm ɓwabundǝa, à yiu a bankutio aɓa Tara Ban-peri, sǝ à kpa, nǝ ɓamǝsǝia a nzali. Kara ɓoarɓwa mala Yahweh pusǝrǝi abania. ");
INSERT INTO mbu_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yahweh banggi Musa ama, ");
INSERT INTO mbu_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","<<Twal garè a buo, sǝ we wunǝ mǝ'eambo Haruna ka, wu ram ɓwabundǝa, sǝ wu ne tali mǝno cau a mǝsǝia, ɓǝ̀ pusǝ mùr male ɓǝ̀ solǝo. Anggo sǝ awu nǝ pusǝia wia mùr nǝ ɓá talinì, sǝ awu nǝ pè ɓwabundǝa andǝ agirkusǝu malea mùr ɓǝà nǔ.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Anggo, sǝ Musa twal garè a ɓadǝm Yahweh, kǝla mana banggi wi ka. ");
INSERT INTO mbu_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Yì andǝ Haruna ka à ram ɓwabundǝa a banɓwáná a ɓadǝm talinì, sǝ Musa banggia wia ama, <<Wu kwaki kir wun ado, wun amǝ'mgbicau! Dumǝna púp ama sǝm nǝ̀ pusǝa wun mùr aɓa tali mǝnia ka le?>> ");
INSERT INTO mbu_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Pǝlǝa Musa loasǝ bui, wal talinì nǝ gara male kusǝ ɓari. Kara mùr pur aɓalǝi kpǝm, sǝ ɓwabundǝa andǝ agirkusǝu malea nǔ. ");
INSERT INTO mbu_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Sǝama, Yahweh banggi Musa andǝ Haruna ama, <<Acemǝnana wu earnǝ mim, mǝnana wun nǝ̀ pam gulo kǝla mǝfele aɓadǝm amǝ Isǝrayila raka, pà wu nǝ̀ kánǝ ɓwabundǝa mǝnia a nzali mǝnana ǝn pania wia ka ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mùr mǝno ka à tunǝi ama mùr mala Meriba, acemǝnana nda ban mǝnana kún amǝ Isǝrayila ɓua arǝ Yahweh kam ngga, sǝ yì ka lǝmdǝ ɓamurì mǝfele na aɓalǝia. ");
INSERT INTO mbu_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Pǝlǝa Musa tasǝ amǝ'na-túrbân, à lo a Kadesh aban ká aban murǝm Edom nǝ cau ama: <<Mǝnia ka, nda cau mǝnana mǝ'eambo Isǝrayila kǝ bang ngga: A súrǝ́nà rǝ gir mana kat kum sǝm, yì tanni mǝnana yiu amur sǝm, ");
INSERT INTO mbu_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","lang aká sǝm sulǝo, à wari a nzali Masar, sǝ sǝm duk kano arǝ apǝlǝa pas, sǝ amǝ Masar pakka sǝm mǝɓike, sǝm sǝnǝ atár sǝm andǝ aká sǝm ngga. ");
INSERT INTO mbu_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Sǝama, lang sǝm yinǝ ɓua ma'sǝm aban Yahweh ka, yi ka, ok gì sǝm, pǝlǝa tasǝ mǝturonjar, mana yi pusǝ sǝm aɓa nzali Masar ka. Adyan ngga, sǝm ndya a Kadesh, yì là mǝnana a nzong-nzali mô ka. ");
INSERT INTO mbu_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ida, ɗeki sǝm, ɓǝ̀ sǝm kùtí nǝɓa nzali mô. Pà sǝm nǝ̀ kùtí a ɓaban-mǝssa ko ɓaban-anap ɗàng; yale pà sǝm nǝ̀ nu mùr a kǝ tūli-mùr ɗàng. Sǝm nǝ̀ ging cat amur njar-mǝgule mala murǝm, aban o; pà sǝm nǝ̀ kyang a bu-mǝli ko bu-mǝnggare ɗàng, sheɓǝ̀ sǝm kya kutina, sǝm purni bu-nzali mô ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Sǝama, Edom pe wi eare ama, <<Pà wun nǝ̀ kùtí aɓa nzali man ɗang, sǝ ɓǝ̀ wu ɓinǝ ama wun nǝ̀ kùtí kani ka, mǝ nǝ kánǝ amǝ'lwa mem arǝ wun.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Amǝ Isǝrayila eari wi ama, <<Sǝm ngga, sǝm nǝ̀ o cat amur njargula-mǝgule, sǝ ɓǝ̀ sǝm, ko agirkusǝu ma'sǝm nu mùr ma'wun ngga, sǝm nǝ̀ mbwe boale. Eara sǝm, kutio na nǝmurǝì sǝm nǝ̀ kùtí ka, nǝ kusǝ sǝm; pà sǝm nǝ̀ pak ɓekǝ gir mana nda ɗàng ngga ɗàng, ko bǝti.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Murǝm Edom nyesǝ cau ama, <<Pà wun nǝ̀ kùtí kani ɗang.>> Pǝlǝa pur nǝ akanggǝrang amǝ'lwa pas nǝ agirbura mǝcandǝe a buia, ace kánǝ munǝo arǝ amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Anggo sǝ Edom ɓinǝ nyinggi Isǝrayila njar ɓǝ̀ kùtí nǝɓa bu-nzali male; nda Isǝrayila wulimúrí, nying kutio nǝɓa nzalinì ka. ");
INSERT INTO mbu_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Pǝlǝa ɓwabundǝa mala amǝ Isǝrayila puppup loapi Kadesh sǝ à twal gya, à yiu a Nkono Hor. ");
INSERT INTO mbu_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yahweh nacau nǝ Musa andǝ Haruna a Nkono Hor, a nzong-nzali Edom, ama, ");
INSERT INTO mbu_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","<<Haruna ka ndo nǝ̀ o atà aɓwana male. Pà nǝ̀ kùtí a nzali mana ǝn nggǝ pè amǝ Isǝrayila ka ɗàng, acemǝnana wun kǝm ngga, wu okam ɗàng, wu kpata zongcau mem a ban mur Meriba ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Twal Haruna andǝ muna-ɓwabura male, Eleaza, wu eau wunǝia, amur Nkono Hor. ");
INSERT INTO mbu_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Akano ka swárì Haruna adaura-pǝris male, sǝ wu oasǝia arǝ muna-ɓwabura male, Eleaza. Haruna ka nǝ̀ o atà aɓwana male; nǝ̀ nggá wǔ kano.>> ");
INSERT INTO mbu_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Nda Musa pa, kǝla mǝnana Yahweh banggi wi ka. À eauwe amur Nkono Hor, a mǝsǝ ɓwabundǝa kat. ");
INSERT INTO mbu_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa pǝlǝa swárì Haruna adaura-pǝris male, sǝ oasǝì Eleaza, muna-ɓwabura male. Sǝ Haruna paklú kano a ɓong nkono. Pǝlǝa Musa andǝ Eleaza sulǝî mur nkono. ");
INSERT INTO mbu_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Lang ɓwabundǝa sǝni ama Haruna wuna ka, ɓala mala Isǝrayila kat, pak anonggio lumi-tàrú aban ɓua-luí. ");
INSERT INTO mbu_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Lang ɓwa Kan'ana, murǝm Arat, mana ndanǝdo a Negev, ok ama, amǝ Isǝrayila na aban yiu nǝ njargula Atarim ngga, kara yinǝ munǝo arǝia, bwalki aɓea ɓwana atà amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Pǝlǝa amǝ Isǝrayila pàcau nǝ-shambum aban Yahweh, ama, <<Ɓǝ̀ mbak-kàngkàng awu nǝ tsǝk aɓwana mǝnia ɓǝà kpa aɓa bù sǝm ngga, sǝm nǝ̀ tària aban Yahweh ace twalta alá malea kat-kat.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yahweh ok zǝmba mala amǝ Isǝrayila, pǝlǝa pà amǝ'Kan'ana aɓata rǝcandǝa malea, sǝ à twaltea kat, à kiɗiki alá malea. À tunǝ lullǝ banì ama, Horma. ");
INSERT INTO mbu_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Pǝlǝa à lo gya, twal a Nkono Hor, nǝ njargula mala Nggeamùr Nzuno, à kàrìban arǝ nzong-nzali mala amǝ'Edom. Sǝama, aɓwe gandǝ twalgàndǝá nǝ gyê ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","À na mǝɓane arǝ Ɓakuli andǝ Musa, ama, <<Palang sǝ a pusǝ sǝm a nzali Masar, ace mǝnana ɓǝ̀ sǝm yi wukio a ɓabondo ka? Girlina pa kàm ɗàng! Mùr pà kàm ɗàng! Sǝ sǝm aulǝna nǝ girlina mǝɓike man!>> ");
INSERT INTO mbu_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Pǝlǝa Yahweh tasǝ an'yau barya aɓalǝ aɓwe; an'yau kwarkia, gandǝa pas atà amǝ Isǝrayila wukio. ");
INSERT INTO mbu_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nda aɓwe yiu aban Musa, sǝ à bang ama, <<Sǝm pangŋa cauɓikea, mǝnana sǝm na mǝɓane amur Yahweh, sǝ sǝm na mǝɓane amuro ka. Pàk hiwi aban Yahweh ama ɓǝ̀ pǝr an'yau mǝnia ka, ɓǝà upiban sǝm.>> Anggo, sǝ Musa pàk hiwi ace aɓwe. ");
INSERT INTO mbu_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yahweh pǝlǝa banggi Musa, ama, <<Pàk ɓǝ̀nzál mala n'yau barya, sǝ wu loasǝi a kuli, amur tondong. Ɓwa mǝnana kat n'yau kwarí, sǝ loasǝ mǝsǝi, sǝni ka, nǝ̀ auwa.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Anggo sǝ Musa pàk n'yau nǝ bolo-bángŋá, pǝlǝa tsǝì amur tondong, sǝ loasǝi tamsǝi. Ɓǝ̀ n'yau kwarna kǝɓwa, sǝ lang loasǝ mǝsǝi sǝn n'yau mala bolo-bángŋá man ngga, ɓwê nǝ̀ auwa. ");
INSERT INTO mbu_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Amǝ Isǝrayila lo gya à yi tsǝk kàttì a Obot. ");
INSERT INTO mbu_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","À loapi Obot ka, à kya tsǝk kàttì a Iye-abarim, a ɓabondo mana kǝ sǝn ɓamǝsǝarǝia andǝ Mowap, nǝ njartakuli ka. ");
INSERT INTO mbu_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","À loapi ban mǝno ka, à yi tsǝk kàttì a Ɓangŋaban Zeret. ");
INSERT INTO mbu_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","À loapi ban mǝno ka, à lo gya à kya tsǝk kàttì a ɓè nkaring mala Nggeasala Arnon, mana nda a ɓabondo mǝnana pur nǝ nzong-nzali mala amǝ'Amor ka. Nggeasala Arnon ngga nda a nzong-nzali mala Mowap, a nre Mowap andǝ nzali Amor. ");
INSERT INTO mbu_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Nda gìr mǝnana tsǝa sǝ Malǝmce mala A'lwa mala Yahweh, bang ama, <<Wahep aɓa Sufa, andǝ amuna-mùr mala Nggeasala Arnon, ");
INSERT INTO mbu_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","andǝ bum aɓangŋaban mǝnana sárǝ́ aban ká a là Ar, sǝ eangnǝ arǝ nzong-nzali Mowap ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Twal a ban mǝno ka, à lidǝmba, aban ká Biya, yì tūli-mùr mǝnana Yahweh banggi Musa cau amurí, ama, <<Ramba aɓwana abanɓwáná, ace mǝnana ɓǝn pea wia mùr ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Pǝlǝa amǝ Isǝrayila tù mǝnia yì nggyal ka, ama: <<Tù mùr, we tūli-mùr! Tùkî wi nggyal, ");
INSERT INTO mbu_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","yì tūli-mùr mǝnana amǝgulo tǝmi ka; mǝnana aɓwana-mǝgule mala aɓwana busǝlǝi nǝ gara-gulo andǝ agara-gya malea ka.>> Pǝlǝa à nying ɓabondo mǝno à o a Matana. ");
INSERT INTO mbu_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","À nying Matana ka, à o a Nahaliyel. À nying Nahaliyel ka, à o a Bamot. ");
INSERT INTO mbu_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","À nying Bamot ka, à o a ɓangŋaban mǝnana nda aɓa nzali Mowap, tù a ban amgbangban Pisga, mǝnana à cam ɓong-ɓong amur pǝɗanban ngga. ");
INSERT INTO mbu_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isǝrayila tasǝ amǝ'na-túrbân ɓǝà kya ne Sihon, murǝm mala amǝ'Amor, ama, ");
INSERT INTO mbu_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","<<Eara sǝm ɓǝ̀ sǝm kùtí nǝɓa nzali mô. Pà sǝm nǝ̀ kùtí a ɓaban-mǝssa ko ɓaban-anap ɗàng. Pà sǝm nǝ̀ nu mùr a kǝ tūli-mùr ɗàng. Sǝm nǝ̀ ging cat, amur njar-mǝgule mala murǝm, ba purî ɓá nzali mô.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sǝama, Sihon eare ɓǝ̀ Isǝrayila kùtí aɓa nzali male ɗàng. A kún mani ka, ramba amǝ'lwa male puppup, sǝ à puro à nǝ̀ ká nǝ munǝo arǝ Isǝrayila aɓa pǝɗanban. Lang à yina a Jahaz ka, à soa munǝo arǝ amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Amǝ Isǝrayila gandǝia nǝ kún nggeabyau, sǝ à ak nzali malea arǝia, twal a ban Nggeasala Arnon kya bik Nggeasala Jabok, sǝama à kya go a nzong-nzali mala amǝ'Amon; acemǝnana nzong-nzali mala amǝ'Amon ngga mǝcandǝe na. ");
INSERT INTO mbu_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isǝrayila ak alá mala amǝ'Amor kat, sǝ duk kam aɓalǝia, kat andǝ nggea-là Heshbon, andǝ amuna-là mǝnana à nda aɓate ka. ");
INSERT INTO mbu_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon ngga, nda nggea-là mala Sihon, murǝm mala amǝ'Amor, mana ɗiɗyal munǝo andǝ murǝm Mowap, sǝ ak nzali male arǝì kat, kya bwal ban Nggeasala Arnon ngga. ");
INSERT INTO mbu_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Nda gìr mǝnana tsǝa, sǝ amǝ'nggyal bang ama, <<Yiu a Heshbon, ace mǝnana ɓǝà ɓè ka; nggea-là mala Sihon ngga ɓǝà ɓè, kusǝì ɓǝ̀ cam kàngkàng. ");
INSERT INTO mbu_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Bǝsa pur aɓa Heshbon, lasǝ-bǝsa pur a nggea-là mala Sihon. Bǝshe yi li Ar, là mala nzali Mowap, yi twalta amǝtala amgbangban ndàka-lú a kún nggeasala Arnon. ");
INSERT INTO mbu_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Caukwanban nǝ we Mowap! Ma'wun malna, wun aɓwana mala Kemosh! Kemosh pànà amuna-burana male ɓǝà umnǝia a bǝri-nzali, sǝ amuna-mamǝna male ka à umna nǝia a guro aban murǝm Sihon ɓwa Amor. ");
INSERT INTO mbu_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Sǝm gandǝna Mowap kat-kat; Heshbon ngga, à kiɗikini yi pur a Dibon. Sǝm yinǝ kiɗikiban arǝì yi pur a Nofa, mǝnana kya go a Medeba ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nda Isǝrayila do a nzali mala amǝ'Amor ka. ");
INSERT INTO mbu_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Anzǝm mana Musa tasǝna amǝ'shenzǝban a Jaza ka, amǝ Isǝrayila kya aki amuna-là mǝnana à kàrìbanì ka, sǝ à pǝr amǝ'Amor mana à duk kam ngga. ");
INSERT INTO mbu_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Pǝlǝa amǝ Isǝrayila wulio, à um nǝ njargula ká Bashan, sǝ Og, murǝm Bashan, andǝ amǝ'lwa male puppup, wari nǝ munǝo arǝia a Edǝri. ");
INSERT INTO mbu_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yahweh banggi Musa ama, <<Kǝa ɓanggi wi ɗàng, acemana ǝn pano wi, yì andǝ aɓwana male kat, andǝ nzali male. Pàkki wi kǝla mana a pakkì Sihon, murǝm mala amǝ'Amor ka, mana do a Heshbon ngga.>> ");
INSERT INTO mbu_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Anggo sǝ à wal-luí, yì andǝ amuna-burana male, andǝ aɓwana male kat, yale kǝɓwa au ateà ɗàng, sǝ amǝ Isǝrayila ak nzali male pǝlǝ malea. ");
INSERT INTO mbu_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Pǝlǝa amǝ Isǝrayila gya, à wario à kya tsǝk kàttì a ɓawanban mala Mowap, a nkanggari Nggeasala Jodan a nkaring mala Jeriko. ");
INSERT INTO mbu_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak murǝm mala amǝ'Mowap, muna-ɓwabura mala Zippor, sǝn gìr mǝnana kat Isǝrayila pàkkî amǝ'Amor ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Sǝ amǝ'Mowap ka, nggea ǝn'o bwalia arǝ amǝ Isǝrayila acemǝnana à làkkì kǝ̀rkǝ́r. Amǝ'Mowap ka à lùmsǝ nǝ ɓangciu atàcau mala amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Nda amǝ'Mowap banggi aɓwana-mǝgule mala amǝ Midiyan ama, <<Nggea ɓwabundǝa mǝnia ka à nǝ̀ ya mal sǝm kǝla mana jamnda kǝ murǝ bondo ɓá garang ngga.>> Sǝ Balak, muna-ɓwabura mala Zippor, mǝnana nda murǝm Mowap a nza mǝno ka, ");
INSERT INTO mbu_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","tasǝ amǝ'na-túrbân, aban Bil'am, muna-ɓwabura mala Beyo, mǝnana ndanǝdo a Peto, a kún Nggeasala a nzali mala aɓwana male ka, ama ɓǝà tunǝi ɓǝ̀ yiu, nǝ cau ama, <<Sǝni, aɓwana mala ɓè kûn nya à yiu, mana à purî ɓá Masar ka; à aki múr nzali kat, sǝ ndya à do a nkanggariam ngga. ");
INSERT INTO mbu_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Yiu adyan, ida sukàm amǝnia yì aɓwana ka, acemǝnana rǝcandǝa malea kútì mem kǝ̀rkǝ́r. Yakǝla, mǝ nǝ gandǝ limurǝm amúrià sǝ mǝ nǝ pǝria, ɓǝà upi nzali man. Mǝnia ka nda acemǝnana, ǝn sǝlǝna nǝma, aɓwana mana kat a tsǝkbuo amúrià ka, à kumǝna tsǝkbu, sǝ aɓwana mǝnana kat a suia ka, suban dumǝna amúrià.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Nda aɓwana-mǝgule mala amǝ'Mowap, andǝ amala amǝ Midiyan lo, sǝ à bwal-njar aban ká, nǝ boalo a buia, mana à nǝ̀ nggá mbwena Bil'am nǝi ace túró ɓangnǝ-ɓangnǝa male ka. Lang à yina aban Bil'am ngga, à banggi wi cau mǝnana Balak bang ngga. ");
INSERT INTO mbu_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Sǝ Bil'am bang ama, <<Wu nong kani yalung, mǝ nǝ yia na wun cau mana Yahweh nǝ̀ banggam ngga.>> Anggo sǝ amǝnia yì amǝgulo mala Mowap ka, à ueo atà Bil'am. ");
INSERT INTO mbu_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Pǝlǝa Ɓakuli yiu aban Bil'am, sǝ ɗì ama, <<Ayana nda ka aburana mǝnia atò ka?>> ");
INSERT INTO mbu_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bil'am banggi Ɓakuli ama, <<Balak, muna-ɓwabura mala Zippor, murǝm Mowap, nda tasǝia abanam nǝ mǝnia yì cau ka, ama, ");
INSERT INTO mbu_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","<Sǝni, aɓwana mala ɓè kûn nya à yiu, mana à purî ɓá Masar ka; à aki múr nzali kat. Yiu adyan, tsǝkam suban amúrià. Yakǝla, mǝ nǝ gandǝia a lwa sǝ mǝ nǝ pǝria ɓǝà puro.> >> ");
INSERT INTO mbu_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Sǝ Ɓakuli banggi Bil'am ama, <<Kǝa na ama, awu nǝ ká ateà ɗàng; sǝ a pà nǝ súka aɓwana mǝnia ɗàng, acemǝnana à ndanǝ tsǝkbu mem amúrià.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ban fana ka, Bil'am lo, sǝ banggi amǝgulo mala Balak ama, <<Wu nyare a nzali ma'wun, acemǝnana Yahweh ɓinǝna, ama mǝ nggá ká ata wun ɗàng.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nda amǝgulo mala Mowap lo à nyare aban Balak, sǝ à banggi wi ama, <<Bil'am, ɓinǝna yiu atà sǝm.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak tasǝ amǝgulo ɗǝm, mǝnana à kútì amana à wari a tadǝmbe ka nǝ lakkì andǝ gulo ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","À wari aban Bil'am, sǝ à ne wi ama, <<Mǝnia ka nda cau mǝnana Balak, muna-ɓwabura mala Zippor bang ngga: <Ida, kǝa eare kǝgìr ɓǝ̀ tàmsǝo arǝ yiu abanam ɗàng; ");
INSERT INTO mbu_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","nda acemǝnana mǝ nǝ loasǝo wu kum gulo kǝ̀rkǝ́r, sǝ gìr mǝnana kat awu nǝ banggam ngga mǝ nǝ pè. Yiu, sukàm amǝnia yì aɓwana ka.> >> ");
INSERT INTO mbu_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Sǝama Bil'am nyesǝcau sǝ banggi amǝtúró mala Balak ama, <<Ko ɓǝ̀ Balak nǝ̀ pam palta male, lumsǝ nǝ bolo-azǝrfa andǝ bolo-njengǝlan ngga, pà mǝ nǝ pàk ɓè kǝgir mǝgule ko mǝkyauwe, mana nda ɗàng'andǝ nzongcau mala Yahweh, Ɓakuli mem ngga ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Acemani ka, ida, wu nong kani, kǝla mana aɓwana mǝnana à yiu a dǝmbe, à pàk ka, ace mǝnana mǝ súrǝ̀ mana ɗǝm Yahweh nǝ̀ banggam.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ɓakuli yiu aban Bil'am sǝ banggi wi ama, <<Acemǝnana aburana man yina ace tunǝo ka, lo kyan wunǝia. Sǝama, shekǝ gìr mǝnana ǝn banggo ka nda awu nǝ pàk ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Pǝlǝa Bil'am, lo nǝ dǝmbari, tsǝk gìr-do-anzǝm mǝdambǝriso male, sǝ o andǝ amǝgulo mala Mowap. ");
INSERT INTO mbu_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Sǝ Ɓakuli ka, bumi lul kǝ̀rkǝ́r, acemǝnana Bil'am na rǝ ká ka, nda sǝ mǝturonjar mala Yahweh, yi came a njar ace mǝnana nǝ̀ ɓinǝi wi ka. Bil'am ngga, nda a nzǝm mǝdambǝriso male aban ká, sǝ amǝ'túró-ɓala male ɓari na atè. ");
INSERT INTO mbu_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Lang mǝdambǝriso sǝn mǝturonjar mala Yahweh aban came a njar nǝ nggeabyau mana kwetǝnì, a bui ka, kara kyanggî njar kúti a bondo. Bil'am wal mǝdambǝriso, ace mǝnana nǝ̀ tsǝì ɓǝ̀ nyar amur njar ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Pǝlǝa mǝturonjar mala Yahweh wario kya came amur njar mǝɓweari a nre ka aɓaban-anap ɓari, nǝ sheran tali a koya buì. ");
INSERT INTO mbu_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Lang mǝdambǝriso sǝn mǝturonjar mala Yahweh ka, nggiki rǝì arǝ sheran, gandǝa gosǝ kusǝ Bil'am arǝ sheran. Sǝ Bil'am wal mǝdambǝriso ɗǝm. ");
INSERT INTO mbu_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Pǝlǝa mǝturonjar mala Yahweh o a dǝmba amur njar, sǝ kya came a ban mana nda ɓwear, mǝnana kǝ ban pǝlǝa pà kàm ko a bu-mǝli ko a bu-mǝnggare raka. ");
INSERT INTO mbu_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Lang mǝdambǝriso sǝn mǝturonjar mala Yahweh ka, kara nong a nzali aɓata Bil'am. Sǝ yì ka, bumi lúllô, wal mǝdambǝriso nǝ gara male. ");
INSERT INTO mbu_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Pǝlǝa Yahweh mǝn kún mǝdambǝriso, sǝ mǝdambǝriso banggi Bil'am cau, ama, <<Mana ǝn pakko, mana tsǝa sǝ a walam kusǝ tàrú mǝnia ka?>> ");
INSERT INTO mbu_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bil'am, pǝlǝa pè mǝdambǝriso eare ama, <<Nda acemǝnana a ɓangginǝ mim ngga! Ɓǝ̀ mǝ ndanǝ nggeabyau a buam ngga, mǝ nǝ wal-luio ado!>> ");
INSERT INTO mbu_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Pǝlǝa mǝdambǝriso banggi Bil'am ama, <<Mǝ nda mǝdambǝriso mǝnana a kwakiyi a do mô kat ba yalung ngga re? Mǝ ndanǝ ɓealu mala pàkkô ani le?>> Pǝlǝa Bil'am ne wi ama, <<Awo.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Pǝlǝa Yahweh mǝn amǝsǝ Bil'am, sǝ sǝn mǝturonjar mala Yahweh aban came amur njar, nǝ nggeabyau male, mana kwetǝnì ka, a bui. Bil'am pǝlǝa ti múrí, sǝ ɓunno, nǝ ɓamǝsǝi a nzali. ");
INSERT INTO mbu_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Pǝlǝa mǝturonjar mala Yahweh ɗi ama, <<Ace mana sǝ a wal mǝdambǝriso mò kusǝ tàrú mǝnia? Sǝni, ǝn yipo kǝla ɓimǝbura, acemǝnana ká mo mǝnia ka, mǝɓike na abanam. ");
INSERT INTO mbu_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mǝdambǝriso sǝnam, sǝ kyanggam kusǝ tàrú mǝnia ka. Ɓǝ̀ mǝdambǝriso kyangmam raka, mǝsǝcau, ɓǝ́ ado ka ǝn walǝna-luio, sǝ ǝn amsǝna yilǝmi.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bil'am banggi mǝturonjar mala Yahweh ama, <<Ən pangŋa cauɓikea. Acemǝnana ǝn sǝlǝa nǝma a nda ban came a njar, ace ɓinǝàm ɗàng. Sǝ adyan ngga, ɓǝ̀ mǝnia yì gìr ka pwasǝbumo raka, mǝ nǝ nyare.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Pǝlǝa mǝturonjar mala Yahweh, banggi Bil'am ama, <<Kyan wunǝ aburane, sǝama, kǝ cau mǝnana ǝn banggo ka, nda awu nǝ na ka.>> Nda Bil'am kutio wario andǝ amǝgulo mala Balak ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Lang Balak ok ama, Bil'am na aban yiu ka, puro ace mǝnana nǝ̀ nggá kullì a nggea-là mala amǝ'Mowap a kún Nggeasala Arnon mǝnana nda a nzong-nzali male ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak, pǝlǝa banggi Bil'am ama, <<Ən túrban atò tsuk-tsuk nǝma ɓǝà tunǝo re? Palang sǝ a ɓinǝ yiu abanam? Mbak-kàngkàng, mim ngga, pa mǝ nǝ gandǝ loasǝo wu kum gulo re?>> ");
INSERT INTO mbu_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Sǝ Bil'am nyesǝi wi ama, <<Ndya ǝn yiu a bano ka! Sǝama, mǝ ndanǝ rǝcandǝa mala na kǝ cau mǝnana mǝ nǝ gandǝ ne ka le? Dumǝna púp, cau mǝnana Ɓakuli nǝ̀ tsǝkam a kunam ngga, nda mǝ nǝ na ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Pǝlǝa Bil'am wari atà Balak, a Kiriyat Huzot. ");
INSERT INTO mbu_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Sǝ Balak pà gir'nkila nǝ andá, andǝ anzur, sǝ aɓea ka, pè Bil'am andǝ amǝgulo mana à nda atè ka. ");
INSERT INTO mbu_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ban fana, nǝ dǝmbari ka, Balak twal Bil'am sǝ à eauwe andǝi a Bamot Ba'al. Akano sǝ sǝn bare amǝ Isǝrayila. ");
INSERT INTO mbu_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bil'am pǝlǝa bang ama, <<Ɓakkam agyangŋan tongno-nong-ɓari kani; yinǝam nǝ ajamnda tongno-nong-ɓari, andǝ agam tongno-nong-ɓari, sǝ wu gilikiamia.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak pa kǝla mana Bil'am bang ngga; sǝ amur koya gyangŋan ngga, Balak andǝ Bil'am pàgir nǝ jamnda mwashat andǝ gam mwashat. ");
INSERT INTO mbu_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Pǝlǝa Bil'am banggi Balak ama, <<Came a ban pàgir mala pisǝe kǝring mò, sǝ mǝ nǝ o. Yakǝla Yahweh nǝ̀ yiu abanam, sǝ gìr mǝnana kat lǝmdǝàm ngga, mǝ nǝ banggo.>> Pǝlǝa Bil'am o amur ɓè kpakan mgbangban. ");
INSERT INTO mbu_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ɓakuli yiu aban Bil'am, sǝ Bil'am banggi wi ama, <<Ən gilikina agyangŋan tongno-nong-ɓari, sǝ amur koya gyangŋan ngga, ǝn panagir nǝ jamnda andǝ gam.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Pǝlǝa Yahweh tsǝk cau a kun Bil'am, sǝ na ama, <<Nyare kya aban Balak, ne wi mǝnia yì cau ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Anggo, sǝ Bil'am nyare, wario kya kum Balak aban came a nkanggari pàgir mala pisǝe kǝring male, andǝ amǝgulo mala Mowap. ");
INSERT INTO mbu_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Sǝ Bil'am ar cau-pasǝlǝe male, ama: <<Balak, murǝm Mowap yinǝ mim, ǝn pur a Aram aɓalǝa ankono mǝnana nǝ takuli ka. Banggam ama, <Yiu, súam Yakupu, yiu, na mǝɓike arǝ Isǝrayila!> ");
INSERT INTO mbu_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Lang sǝ mǝ nǝ gandǝ sú ɓwa mǝnana Ɓakuli suí raka? Lang sǝ mǝ nǝ gandǝ na mǝɓike arǝ ɓwa mǝnana Yahweh na mǝɓike arǝì raka? ");
INSERT INTO mbu_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","A ɓong atali ǝn nggǝ sǝnia, amur amgbangban ǝn nggǝ pelǝkia. Ən nggǝ sǝn nggǝsanì aɓwana mana à tàr ɓamúrià, sǝ à ɓal ɓamúrià aɓalǝ anzali raka. ");
INSERT INTO mbu_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yana nǝ̀ gandǝ ɓal tú-nzali mala Yakupu, ko nǝ̀ súrǝ̀ inea bare làkkì mala Isǝrayila? Ɗekiam ɓǝn wú, ulang lú mala mǝɓealɓoarna. Ɓǝ̀ masǝlǝata do mem pǎ kǝla male!>> ");
INSERT INTO mbu_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Pǝlǝa Balak banggi Bil'am ama, <<Mana mǝnia a pàkkam anggo ka? Ən twalo ace mǝnana wu sú aɓiam-mǝbura, sǝ ndya, yale tsǝkbu na a tsǝkia wia ka!>> ");
INSERT INTO mbu_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Pǝlǝa Bil'am, pa eare ama, <<Gìr mǝnana Yahweh tsǝkam a kunam ngga nda dumǝna púp, mǝ nǝ tsǝkiram arǝì, mǝ nǝ bangŋi ka re?>> ");
INSERT INTO mbu_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Pǝlǝa Balak banggi Bil'am ama, <<Ida, yiu atàm, sǝm nǝ̀ ká a ɓè ban, ban mǝnana awu nǝ sǝnia kam ngga. Akano ka awu nǝ sǝn barebania, a pà nǝ sǝnia kat ɗàng. Sǝ wu súkamia.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Nda Balak twal Bil'am, um nǝi a banfana mala Zofim, a ɓong Nkono Pisga. Ɓak agyangŋan tongno-nong-ɓari kam, sǝ pàgir nǝ jamnda andǝ gam amur koya gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Pǝlǝa Bil'am banggi Balak ama, <<Cam kani a nkanggari pàgir mala pisǝe kǝring mò, sǝ mim ngga mǝ nǝ ká akano ace gasǝ sǝnǝ Yahweh.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Pǝlǝa Yahweh yiu aban Bil'am, sǝ tsǝki wi cau a kúni, sǝ banggi wi ama, <<Nyar aban Balak sǝ wu bang mǝnia yì cau ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Pǝlǝa Bil'am nyar aban Balak, sǝ yi kumi ka nda aban came a nkanggari pàgir mala pisǝe kǝring male, sǝ amǝgulo mala Mowap ka à nda baní. Sǝ Balak ɗì Bil'am ama, <<Mana nda gìr mǝnana Yahweh na ka?>> ");
INSERT INTO mbu_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Pǝlǝa Bil'am ar cau-pasǝlǝe male sǝ na ama, <<Lo, Balak, sǝ wu ó! Kwakikiro arǝàm, we muna-ɓwabura mala Zippor; ");
INSERT INTO mbu_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ɓakuli ka, ɓwapǝndǝa na ɗang, mǝnana nǝ̀ na nyir ka, sǝ yi ka, muna mala ɓwa na ɗang, mǝnana nǝ̀ nggaɗi kúni ka; Nanacau, sǝ pà nǝ̀ pè re? Ko ana raka, bangŋǝna cau, sǝ pà nǝ̀ lùmsǝì re? ");
INSERT INTO mbu_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Sǝni, mim ngga à tsǝkam nzongcau ɓǝn tsǝkbu; Yì ka tsǝngŋǝnabu, sǝ pà mǝ nǝ gandǝ nggaɗi ɗàng. ");
INSERT INTO mbu_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Kǝ gìr múrɓikea pà kàm à pelǝì aɓa Yakupu ɗàng, À sǝnma kǝ gìr bumkiɗikea aɓa Isǝrayila ɗàng. Yahweh, Ɓakuli malea na ateà; Gawan murǝm na aɓalǝia. ");
INSERT INTO mbu_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ɓakuli pusǝia aɓa Masar; Yì ka nda kǝla anjawe ndwakan abania. ");
INSERT INTO mbu_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kǝ ɓuri pà kàm nǝ̀ li arǝ Yakupu ɗàng, kǝ ɗǐ kàm arǝ Isǝrayila ɗàng. Adyan ngga à nǝ̀ banggi Yakupu, sǝ à nǝ̀ banggi Isǝrayila gìr mǝnana Ɓakuli pangŋǝ̀nì ka! ");
INSERT INTO mbu_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Sǝni, à nda ka aɓwana mana à kǝ lo kǝla nggeàɓwaná-im aɓa gilǝrǝu nǝ̀ kánǝ munǝo; kǝla mana im kǝ loasǝ rǝì ka, sǝ pà nǝ̀ nongnǝ-nongŋo ɗang sheɓǝ̀ shanŋǝ̀nà nyama, sǝ nuna nkila mala nyama mǝnana wal ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Pǝlǝa Balak banggi Bil'am ama, <<Ɓǝ̀ a pà wu nǝ suia raka, ko bǝti, kǝa tsǝkia wia bu ɗàng!>> ");
INSERT INTO mbu_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Pǝlǝa Bil'am pe Balak eare ama, <<Nggearǝì ka, ǝn banggo mbak nǝma, kǝgir mǝnana Yahweh banggam ngga, nda mǝ nǝ pàk ka, re?>> ");
INSERT INTO mbu_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Pǝlǝa Balak banggi Bil'am ama, <<Yiu atàm, mǝ nǝ kánǝ we, a ɓè ban mwashat ɗǝm. Ear ka, nǝ̀ pwasǝbum Ɓakuli, ace mǝnana ɓǝ̀ earô wu suia acem, akano ka.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Pǝlǝa Balak twal Bil'am, sǝ à eau andǝi amur Nkono Piyor, mana sǝngiyi pǝɗanban ngga. ");
INSERT INTO mbu_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Pǝlǝa Bil'am bang ama, <<Ɓakkam agyangŋan, tongno-nong-ɓari, sǝ wu gilikiam jamnda tongno-nong-ɓari, andǝ agam tongno-nong-ɓari.>> ");
INSERT INTO mbu_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Pǝlǝa Balak pa, kǝla mana Bil'am bang ama ɓǝà pè ka. Pǝlǝa pàgir nǝ jamnda andǝ gam, amur koya gyangŋan. ");
INSERT INTO mbu_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Adyan ngga, lang Bil'am sǝnǝni ama, girî pwasǝbum Yahweh, acemǝnana tsǝki amǝ Isǝrayila bù ka, nyare wario kǝla mana ɗiɗyal ka nǝ̀ nggá ɓangnǝ-ɓangnǝa ɗang. A kún mǝno ka, pǝlǝ ɓamǝsǝi nǝ njar ɓabondo. ");
INSERT INTO mbu_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Lang Bil'am loasǝ mǝsǝì sǝ sǝn amǝ Isǝrayila, aban do a kàttì, arǝ atau malea ka, Bangŋo mala Ɓakuli sulǝo amurí, ");
INSERT INTO mbu_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","sǝ ar cau-pasǝlǝe male, ama: <<Cau-pasǝlǝe mala Bil'am, muna-ɓwabura mala Beyo, cau mala ɓwa mǝnana mǝsǝi kǝ sǝn agir pepè ka; ");
INSERT INTO mbu_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","yì cau mala ɓwa mǝnana kǝ ok gi Ɓakuli; yì ɓwa mǝ