﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbtNT_vpl;
CREATE TABLE mbtNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbtNT_vpl WRITE;
INSERT INTO mbtNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Seini ka kaap-apuan ni Hisu Kristu ne kabuhalan ni Dabid, ne kabuhalan ni Abraham. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham ka amey ni Isaak, si Isaak ka amey ni Hakub, ne si Hakub ka amey ni Huda wey te me suled din. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne nakaasawa si Huda ki Tamar wey due daruwa ne anak dan ne si Piris wey si Sira. Si Piris ka amey ni Hisrun, wey si Hisrun ka amey ni Aram. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne si Aram ka amey ni Aminadab, si Aminadab ka amey ni Nasun, wey si Nasun ka amey ni Salmun. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ne nakaasawa si Salmun ki Rahab ne iyan dan anak si Buas, ne nakaasawa si Buas ki Rut ne iyan dan anak si Ubid, ne si Ubid ka amey ni Hisi, ");
INSERT INTO mbtNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ne si Hisi ka amey ni Hari Dabid. Ne si Hari Dabid ka amey ni Sulumun, wey iyan din iney ka asawa dengan ni Uriyas. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Sulumun ka amey ni Rihubuam, si Rihubuam ka amey ni Abyas, si Abyas ka amey ni Asa, ");
INSERT INTO mbtNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ne si Asa ka amey ni Husapat, si Husapat ka amey ni Huram, si Huram ka amey ni Usiyas. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usiyas ka amey ni Hutam, si Hutam ka amey ni Ahas, si Ahas ka amey ni Isikiyas. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Isikiyas ka amey ni Manasis, si Manasis ka amey ni Amun, ne si Amun ka amey ni Husiyas. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne si Husiyas ka amey ni Hikuniyas wey te me suled din. Te seeye ne timpu, in-uyan ka matig-Israil diye te Babilunya eyew eg-uripenen. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pegkapenga uyana te matig-Babilunya ka matig-Israil, nakaanak si Hikuniyas ki Salatiil, ne si Salatiil ka amey ni Surubabil, ");
INSERT INTO mbtNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","si Surubabil ka amey ni Abyud, si Abyud ka amey ni Ilyakim, si Ilyakim ka amey ni Asur, ");
INSERT INTO mbtNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","si Asur ka amey ni Saduk, ne si Saduk ka amey ni Akim, si Akim ka amey ni Ilyud. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Ilyud ka amey ni Ilisar, si Ilisar ka amey ni Matan, si Matan ka amey ni Hakub. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Hakub ka amey ni Husi, ne asawa ni Mariya ne iney ni Hisus ne egngaranan te Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Purisu due sapulu wey hep-at (14) ne kabuhalan puun ki Abraham taman ki Dabid, wey sapulu wey hep-at (14) degma ne kabuhalan puun ki Dabid taman te timpu ne neuyan e ka matig-Israil diye te Babilunya, wey duen pad man-e sapulu wey hep-at (14) ne kabuhalan puun te neuyan ka matig-Israil taman te neetew e ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Seini ka guhuren meyitenged te pegkeetew ni Hisu Kristu. Ka iney rin ne si Mariya, napamalayan e ni Husi, piru te ware pad sikandan migpewulirey, naberes e si Mariya pinaahi te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na, si Husi se egpangasawa kandin, matareng ne etew wey kene sikandin egkeupian ne egpeyilawan din si Mariya. Ne puun dutu, nakasuman-suman sikandin ne egpasuwayey sikandan te heles de. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Piru te migsusuman-suman pad sikandin dutu, due panalihan te Magbebaye ne Manama ne migpakita kandin pinaahi te taheinep ne migkahi, “Husi, kabuhalan ni Dabid, kene ka egkaaldek ne egpangasawa ki Mariya su naberes sikandin pinaahi te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eg-anak sikandin te lukes wey ngarani nu ki Hisus tenged su sikandin ka egluwas te keet-etawan din puun te me sale dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Neyitabu seini se langun eyew egkatuman ka ingkahi te Magbebaye ne Manama pinaahi te prupita: ");
INSERT INTO mbtNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Egkaberes ka mengebay ne ware pad neyilabeti, wey lukes ka ig-anak din wey egngaranan sikandin te Imanyuwil” (Iyan kaluwasan te Imanyuwil, “Duma ta ka Manama.”) ");
INSERT INTO mbtNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Purisu te peggimata ni Husi, intuman din e ka insuhu te panalihan te Magbebaye ne Manama, wey in-asawa rin e si Mariya. ");
INSERT INTO mbtNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piru ware din hilabeti si Mariya te ware pad mig-anak. Te inlesutan e si Mariya, lukes iya ka anak din wey ingngaranan e ni Husi ka bate ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Diye miglesut si Hisus te lungsud te Bitlihim ne sakup te prubinsya te Hudiya, ne si Hirudis pad ka Hari te seeye ne timpu. Ne due me etew ne egkateu ne egpamituen ne diye ne mahinged te dapit te igsile ne nanginguma diye te Hirusalim ne mig-inse, ");
INSERT INTO mbtNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Hendei ka bate ne neetew ne iyan egkeyimu ne Hari te me Hudiyu? Nakita ney ka bituen ne diye dapit te igsile ne iyan palinneu te peglesut din, purisu miggendini key eyew te pegsimba kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te pegkarineg dutu ni Hari Hirudis, nabantalan sikandin duma te langun ne etew te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Purisu impalibulung din ka langun ne me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama wey mig-insaan din ke hendei eglesut ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ne migtabak sikandan, “Diye eglesut sikandin te lungsud te Bitlihim ne sakup te prubinsya te Hudiya, su seini ka nasulat te prupita te Manama: ");
INSERT INTO mbtNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ka Bitlihim ne nasakup te Hudiya, ka mabantug te langun ne lungsud due te Hudiya, su diye egpuun ka egpangulu ne egtanggu te keet-etawan ku ne me kabuhalan ni Israil.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Te pegkarineg dutu ni Hirudis, impeumew rin e te heles de ka me etew ne egkateu ne egpamituen, wey mignengnengan din ke ken-u miglepew ka bituen ne nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nataman, impeendiye din e sikandan te Bitlihim te migkahi, “Hendiye kew e wey ay-ayari niyu te egpammitew ka bate. Ne emun ke egkakita niyud e sikandin, nangeni e re nikaniyu eyew egpekeendiye a degma ka egsimba kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pegkapenga te Hari te miglalag, nangipanew e sikandan. Te sasangan pad sikandan ne eggipanew, duen e man-e ka bituen ne nakita ran diye dapit te igsile. Ne seeye naa ka in-ikul ran taman te migsanggel diye te neugpaan te bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amana sikandan nahale-gale te pegkakita ran te bituen! ");
INSERT INTO mbtNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Te pegseled dan te baley, nakita ran ka bate duma te iney rin ne si Mariya. Ne migpanimbuel sikandan wey insimba ran ka bate. Nataman, migbukalasan dan e ka me mahal ne inuyanan dan wey imbehey ran e diye te bate ka me dasag dan ne bulawan, insinsu wey mira. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Piru te peg-uli dan e, diyad e sikandan migbaye te lein ne dalan tenged su migpanpanayan sikandan te Manama pinaahi te taheinep ne kenad e egpaliberen diye te ki Hirudis. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te nangipanew e ka egkateu ne egmamituen, due panalihan te Magbebaye ne Manama ne migpakita ki Husi pinaahi te taheinep din ne migkahi, “Enew ka. Uyana nu ka manggianak, wey pallahuy kew diye te Ihiptu. Ne diye kew naan pa ugpe taman te egpaaween kud sikaniyu, su egpamitawen ni Hirudis ka bate eyew eggimatayan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Purisu mig-enew e si Husi wey in-uyan din e ka talaanak, wey te sikan de ne karusileman migpallahuy e sikandan peendiye te Ihiptu. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne diye pad mig-ugpe sikandan taman te migpatey e si Hirudis. Neyitabu ka iling kayi eyew egkatuman ka ingkahi te Magbebaye ne Manama pinaahi te prupita ne miggenendue, “Mig-umew ku ka Anak ku puun te Ihiptu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ne migpangebel-ebel e ka langet ni Hirudis te pegkanengnengi rin ne in-akalan de sikandin te me etew ne egkateu ne egpamituen. Purisu migsuhu sikandin ne egpeyimatayan ka langun ne me bate ne lukes diye te Bitlihim wey te marani dutu ne me bariyu puun te iyam pad miglesut peendiye te daruwa ne leg-un ne me bate. Su nakanengneng sikandin ne migdaruwe e ne leg-un ka kariyuan puun te nakita ka bituen te seeye se egkengateu ne egpamituen. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pinaahi te sika ne neyitabu, natuman e ka ingkahi ni prupita Hirimiyas ne miggenendue: ");
INSERT INTO mbtNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Due laheng ne egkarineg diye te Rama, ne egsinehew wey egpalumbibigtew, egpandalawit si Rakil tenged te me anak din; ne kene iya sikandin egkeim-imuan, uya su nenammatey e ka me anak din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ne hengkayi te migpatey e si Hirudis, migpakita ka panalihan te Magbebaye ne Manama ki Husi pinaahi te taheinep te diye pad sikandan te Ihiptu. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Migkahi ka panalihan, “Enew ka. Dumaa nu ka manggianak, wey uli kad e diye te Israil, tenged su migpatey e ka etew ne egkeupian ne eggimatey te bate.” ");
INSERT INTO mbtNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ne mig-enew si Husi wey migduma rin e ka manggianak te mig-uli diye te Israil. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piru te pegkarineg din ne si Arkilaw e ka Hari te Hudiya ne inliwan te amey rin, naaldek e sikandin ne eggendiye. Nataman, impanpanayan e man-e sikandin te Manama pinaahi te taheinep din ne egpeendiyeen te prubinsya te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne diyad e sikandan mig-ugpe te lungsud te Nasarit. Purisu natuman e ka ingkahi te me prupita meyitenged te Kristu ne miggenendue, “Egngaranan sikandin te matig-Nasarit.” ");
INSERT INTO mbtNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Te seeye ne timpu, due etew ne egngaranan ki Huwan ne Talagbewutismu ne migwali diye te mammara ne inged ne kene egkeugpaan diye te Hudiya. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Migkahi sikandin, “Inniyuhi niyu ka me sale niyu, su mahaan e ka Peghari te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Huwan ka egkahiyen ni prupita Isayas ne eggenendue, “Due egpanguleyi diye te mammara ne inged ne kene egkeugpaan ne egkahi: ‘Andama niyu ka dalan te Magbebaye. Tul-ira niyu ka egbayaan din!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ka kumbale ni Huwan innimu ligkat te bulbul te kamilyu, ne ka sinturun din innimu ligkat te laplap te ayam. Ne iyan din de egkeenen ka talangas wey ka teneb. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nangendiye te kandin ka me etew ne diye egpuun te Hirusalim, wey diye te langun ne lungsud te Hudiya, wey te langun ne me inged ne marani te weyig ne Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne nekegsendit e sikandan wey impangguhud dan e ka me sale dan, wey imbewutismuwan e sikandan ni Huwan diye te weyig ne Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Te pegkakita ni Huwan ne masulug ka me Parisiyu wey me Sadusiyu ne migparani kandin eyew egpabewutismu, migkahiyan din e sikandan, “Sikaniyu se egpekeiling te me mammiley, hentew-a ka miglalag kaniyu ne egpakaalihu kew te egginguma ne legpad te Manama? ");
INSERT INTO mbtNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ipakita niyu pinaahi te himu niyu ne mig-inniyuhan niyud e ka me sale niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne kene kew kahi, ‘Me kabuhalan key e ni Abraham.’ Su egnangenan ku sikaniyu te egkaayun ne egpabaluyen te Manama ne me etew ka seini se me batu eyew eggimuwen ne kabuhalan ni Abraham. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ne kuntee, andam e ka perekul ne igpekpek te me kayu; ne egpeleren ka tagse kayu ne kene egbebehas te meupiya, wey igdegpak diye te hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Egbewutismu a kaniyu pinaahi te weyig te pegpeila ne mig-inniyuhan niyud e ka me sale niyu. Piru due egpakasinundul keddi ne subla pad ne maresen keddiey, ne kena a ne likes minsan te peg-uyan naan de te sandal din. Sikandin ka egbewutismu kaniyu te Panisingan te Manama wey te hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Egpekeiling sikandin te etew ne egpalayap te paley, iglein din ka tipasi diye te ukaba. Ne seeye se tipasi diye din igtahu te lelapeng, piru ka ukaba egsilaban din te hapuy ne kene egkeebukan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nataman, miggendiye si Hisus te Hurdan ligkat te Galiliya ka egpabewutismu ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piru kene perem egkeupian si Huwan ne egbewutismu ki Hisus, su migkahi si Huwan, “Sikeddiey ka keilangan ne egbewutismuwan nu, ne mania te miggendini ka keddiey?” ");
INSERT INTO mbtNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piru migtabak si Hisus, “Keilangan iya ne eggimuwen ta seini eyew te pegtuman te langun ne igkeupii te Manama.” Ne mig-uyun e si Huwan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te nabewutismuwan e si Hisus wey nakahakap e, sahuhune ne nalukatan ka langit wey nakita rin ka Panisingan te Manama ne miglene ne egpekeiling te seleppati ne miglatun diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne due laheng ne egpuun te langit ne migkahi, “Seini ka pinalangge ku ne Anak. Amana a nahale kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nataman, in-uyan e te Panisingan te Manama si Hisus diye te mammara ne inged ne kene egkeugpaan eyew egtintalen ni Meibulan. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne dutu, migpuasa sikandin seled te hep-at ne pulu (40) ne aldew wey marusilem, ne nataman, miggutasan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ne miggendiye te kandin si Meibulan ne migkahi, “Ke Anak ke ma te Manama, pabaluya nu ne paan seini se me batu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piru migtabak si Hisus, “Nasulat e diye te Kasulatan ne miggenendue, ‘Kene egkeuyag ka etew te keenen de, ke kene, te tagse lalag ne iglalag te Manama.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nataman, in-uyan e te ahalen te me busew si Hisus diye te Hirusalim, ka Matulus ne Siyudad, wey diye itahu sikandin te kinaribabawan te timplu, ");
INSERT INTO mbtNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wey migkahiyan sikandin, “Ke Anak ke ma te Manama, tinugpu ka seeye te diralem. Su nasulat e diye te Kasulatan, ‘Egsuhu ka Manama te me panalihan din te pegbantey keykew, wey egtapayeen ka nikandan, eyew kene egpakabaras te batu ka paa nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Piru migkahiyan sikandin ni Hisus, “Nasulat e degma diye te Kasulatan ne miggenendue, ‘Kene nu tintala ka Magbebaye ne Manama nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nataman, in-uyan e man-e te ahalen te me busew si Hisus diye te titikangi ne bubungan, wey impapitew kandin ka katelesan te langun ne inged kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne migkahiyan sikandin ni Meibulan, “Igbehey ku seini se langun diye te keykew ke egpanimbuel ka wey egsimba keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne migkahiyan ni Hisus sikandin, “Awe ka Meibulan! Su nasulat e diye te Kasulatan, ‘Simbaa niyu ka Magbebaye ne Manama niyu wey sikandin de pamakaya niyu!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nataman, mig-engkeran e sikandin te ahalen te me busew, ne dutu, nangingume e ka me panalihan te Manama eyew egtanggu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ne nakarineg si Hisus te narakep e si Huwan ne Talagbewutismu, sikan naa ka miglibed e sikandin diye te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ne ware sikandin naluhey diye te Nasarit, wey miggalin e mig-ugpe diye te Kapirnaum ne marani te lanew ne sakup te Sabulun wey Naptali. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Neyitabu sika eyew egkatuman ka ingkahi ni prupita Isayas: ");
INSERT INTO mbtNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ka inged te Sabulun wey ka inged te Naptali, bayaanan peendiye te dahat, ne deyipag te weyig ne Hurdan, ne sakup te Galiliya ne egngaranan te inged te kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Minsan nangugpe due te marusilem ka me etew te sika ne me inged, piru egpakakita red sikandan te dakel ne kalayag. Ne ka nangugpe due te marusilem ne egkaaldek ne egkengammatey, egkalayahan ded.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Puun te seeye ne timpu, migbunsud e migwali si Hisus ne migkahi, “Inniyuhi niyu ka me sale niyu, su mahaan e ka Peghari te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Taheed te miggiphipanew si Hisus diye te ilis te Lanew te Galiliya, nakakita sikandin te talaari ne egpamiyale ne si Simun ne eg-immuan ki Pidru wey ka suled din ne si Andris. Mangngengalap sikandan se daruwa. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne migkahiyan ni Hisus sikandan, “Ikul kew keddiey wey eggimuwen ku sikaniyu ne mangngengalap te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Due-rue ne mig-engkeran dan ka me biyale dan wey mig-ikul e kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Te migpabulus e si Hisus ka miggipanew, due nakita rin ne lein ne talaari ne si Santiyagu wey si Huwan ne me anak ni Sibidiyu. Diye sikandan te balangey ran duma te amey ran ne egpanupak te me biyale dan. Ne dutu, in-umew e sikandan ni Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ne due-rue ne in-engkeran dan e ka balangey ran wey ka amey ran wey mig-ikul e sikandan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nataman, in-empet ni Hisus te egleug-leug ka intiru ne prubinsya te Galiliya, wey migpanulu sikandin diye te me simbaan te me Hudiyu. Inwaliyan din sikandan te Meupiya ne Panugtulen meyitenged te Peghari te Manama, wey imbawian din ka langun ne eggeramen wey dalu te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nekeempet te intiru ne Sirya ka guhuren meyitenged kandin, purisu impanguyan te me etew diye te kandin ka langun ne egmanderalu te nalein-lein ne me dalu, ka seeye se egkabaybayaran te masakit, ka egpanerepan te busew, ka egbabuyen, wey ka migpatey e se me lawa. Ne imbawian sikandan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amana ne susuluhi ka me etew ne migsinundul ki Hisus ne diye egpuun te Galiliya, Dikapulis, Hirusalim, Hudiya, wey diye te deyipag te Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te pegkakita ni Hisus te seeye se masulug ne me etew, migtakereg e sikandin diye te bubungan wey diyad e sikandin migpinnuu. Ne migparani e kandin ka me hibateen din ");
INSERT INTO mbtNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","wey migbunsud e sikandin ka migpanulu kandan ne migkahi: ");
INSERT INTO mbtNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Keupianan te seeye se me etew ne mig-ila ne egkeilangan sikandan te Manama, su egkasakup sikandan te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Keupianan te seeye se me etew ne eglungku, su egbehayan sikandan te Manama te kahale. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Keupianan te seeye se me etew ne mapariralemen, su egkaangken dan ka intiru ne kalibutan. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Keupianan te seeye se me etew ne egpakannekal ne egtuman te igkeupii te Manama, su egbulihan sikandan te Manama te pegtuman due. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Keupianan te seeye se me etew ne hiid-uwen te duma, su igkeyid-u degma sikandan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Keupianan te seeye se me etew ne nasabeka ka suman-suman diye te Manama, su egpakakita sikandan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Keupianan te seeye se me etew ne tigpataliware ke due samuk, su eg-angkenen sikandan te Manama ne me anak din. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Keupianan te seeye se me etew ne egbaybayaran tenged te pegtuman te igkeupii te Manama, su egkasakup sikandan te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Keupianan niyu ke eglemetan kew, ke egbaybayaran kew, wey ke egpangawangan kew egpandakeseli te langun ne mareet tenged keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ne iling ded degma kayi ka natamanan te me prupita ne nekewun-a kaniyu. Purisu gale-gale kew su dakel ka dasag ne intahahe kaniyu diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikaniyu ka asin kayi te ampew te tane. Piru ke egkaawaan e te nanam ka asin, egmenuwen pad te pegpalibed te nanam din? Warad e karuan due, purisu igdegpak e sika wey egdi-diekan e te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Sikaniyu ka kalayag kayi te ampew te tane. Ka sabeka ne siyudad ne diye te bubungan, kene egkeeles. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iling naa degma due, ware egmarekket te sulu ne egsuuban te gantangan, ke kene, igpatawan-tawan iya igtahu eyew egkalayahan ka langun ne diye te seled te baley. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Purisu ipalayag niyu ka sulu niyu diye te tangkaan te me etew eyew egkakita ran ka meupiya ne me himu niyu wey eyew egkasaye dan ka Amey niyu ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kene niyu sumsumana ne iyan ku innendini ka pegdereet te Balaud te Manama wey te sinulat te me prupita. Kene ne pegdereet ka innendini ku, ke kene, ka pegtuman kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Egnangenan ku sikaniyu te malehet: taheed te duen pad ka langit wey ka tane, kene iya egkaawaan ka Balaud te minsan deisek ne baad wey tulduk taman te egkatuman e ka langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Purisu ka minsan hentew ne kene egtuman te minsan deisek ne baad te Balaud, wey egpanulu te duma te pegsupak kayi, sikandin ka kene ne impurtanti diye te Migharian te Manama. Piru ka minsan hentew ne egtuman wey egpanulu te duma te pegtuman due, sikandin ka labew diye te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sikan naa, egnangenan ku sikaniyu te wey kew re egpakaseled te Migharian te Manama ke subla pad ka pegtuman niyu te igkeupii te Manama du te pegtuman te me talagpanulu te Balaud te Manama wey te me Parisiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nakarineg kew e te migkahiyan ka me keet-etawan dengan, ‘Kene kew himatey. Ka minsan hentew ne eggimatey, eg-uyanen diye te hukumanan.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piru egnangenan ku sikaniyu te minsan hentew ne egkabelu te duma rin, eg-uyanen degma diye te hukumanan. Ne minsan hentew ne egkahi diye te duma rin, ‘Ware utek nu,’ eg-uyanen sikandin diye te me Talaggukum te me Hudiyu. Ne minsan hentew ne egkahi diye te duma rin, ‘Egkeungel ka!’ eglegparan sikandin diye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Purisu minsan ke diye kad e migsasindeg te altar ne mig-uyan te igpanubad nu diye te Manama, ne due-rue ne nakasuman-suman ka te due suled nu ne neenenduenan keykew, ");
INSERT INTO mbtNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","engkeri nu pa ka igpanubad nu diye te lenged te altar. Ne hendiyei nu pa ka suled nu wey peul-uliey kew pa te meupiya ne geyinawa. Pegkapenga due, henduen pad ne ibehey nu ka igpanubad nu diye te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ke due egbayung keykew wey igsumbung kad nikandin, dagdahawi nu husaya te sasangan kew e ne egpeendiye te hukumanan, su kema ke igpeendiye kad e nikandin te huwis, ne igpeendiye kad e man-e te pulis, ne egkataman ne igpaprisu kad e. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Egnangenan ku sikeykew te malehet: kene ka iya egpakalihawang ke kene nu egkaamin te egbayad ka multa nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nakarineg kew e te ingkahi dengan ne, ‘Kene kew panlibug.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piru kuntee, egnangenan ku sikaniyu te minsan hentew ne egtengteng te malitan wey egkeupian ne eggilabet kandin, nakapanlibug e sikandin diye te suman-suman din. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne emun ke iyan egpuunan ka kawanan ne mata nu ne egpakasale ka, lekata nu sika wey iregpak nu. Meupiya pad ke egkaawaan ka te sabeka ne baad te lawa nu du te igdegpak diye te linew ne hapuy ka intiru ne lawa nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne emun ke iyan egpuunan ka kawanan ne belad nu ne egpakasale ka, tempuha nu sika wey iregpak nu. Meupiya pad ke egkaawaan ka te sabeka ne baad te lawa nu du te igdegpak diye te linew ne hapuy ka intiru ne lawa nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nakahi e degma dengan ne, ‘Ka lukes ne eg-engked te asawa rin, keilangan ne egbehey te asawa rin te kasulatan te egpakig-engked.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piru kuntee, egnangenan ku sikaniyu te emun ke eg-engkeran te lukes ka asawa rin ne ware nasalei, sikandin e ka egpuunan ne egpakapanlibug ka asawa rin ne malitan ke eg-abey sikandin eg-asawa. Ne ka egpangasawa kandin, egpakapanlibug e degma. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nakarineg kew e degma te migkahiyan ka me keet-etawan dengan, ‘Kene egkaayun ne kene nu egtumanen ka insaad nu, su keilangan ne egtumanen nu ka impahunlibet nu te Magbebaye ne Manama.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piru kuntee, egnangenan ku sikaniyu te kene kew iya pahunlibet. Kene kew kahi, ‘Mengeyibet te langit’ su ka langit pinnuuwan te Manama te egmandu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ne kene kew kahi, ‘Mengeyibet te kalibutan’ su ka kalibutan diekanan te Manama. Ne kene kew man-e pahunlibet te Hirusalim su sika ka siyudad te mabantug ne Hari. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kene kew man-e pahunlibet te me ulu niyu su kene kew egpakapamaangkag wey egpakapameitem minsan te sabeka re ne timman ne bulbul niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kahi kew re te ‘Uya’ ke eg-uya kew. Ne kahi kew re te ‘Kene’ ke kene kew, su emun ke egpahunlibet kew pad, diyad egpuun sika ki Meibulan. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nakarineg kew e te ingkahi dengan ne, ‘Ka mata egbayaran ded te mata, ka ngipen egbayaran ded degma te ngipen.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piru kuntee, egnangenan ku sikaniyu te kene kew suli te miggimu kaniyu te mareet. Ke due egtagpi te beneng nu, ipatagpi nu degma ka limang. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ke due egsumbung keykew ne egkuen din e ka kumbale nu, ibehey nud e sika wey ilagkes nud e degma ka dyakit nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne emun ke due egpehes keykew ne egpatiang te inuyanan din te sabeka ne kilumitru, tianga nu te daruwa ne kilumitru. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ke due egbuyu keykew, behayi nu, wey ke due egsambey keykew, pasambaya nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nakarineg kew e te ingkahi dengan ne, ‘Geyinawei nu ka alukuy nu, wey dumuti nu ka kuntere nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piru kuntee, egnangenan ku sikaniyu te geyinawei niyu ka me kuntere niyu wey ampui niyu ka egbayad-bayad kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Emun ke eggimuwen niyu ka iling due, egkeyimu kew ne me anak te Amey niyu ne diye te langit. Su kene de ne ka me meupiya se batasan ka impasilaan din te aldew, ke kene, minsan degma ka me maddeet se batasan. Ne kene de ne ka me matareng ka imbehayan din te uran, ke kene, minsan degma ka me makasesale. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kene kew pallateng ne due egkarawat niyu ne dasag ne egpuun te Manama ke iyan niyu re eggeyinawaan ka eggeyinawa degma kaniyu. Su minsan ka me talagsukut te buhis, eggeyinawa te seeye se eggeyinawa degma kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne emun ke iyan niyu re eg-el-eliten ka me suled niyu, nekey ma ka neyimu niyu ne labew te neyimu te duma? Minsan ka kene egmalintutuu te Manama, eg-elit-elit ma te me suled dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Purisu, keilangan ne ware igkarew-ey kaniyu, iling te Amey niyu ne diye te langit ne ware iya igkarew-ey. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Bantey kew! Kene kew himu te meupiya diye te tangkaan te me etew eyew egparayan-dayan kandan. Ke iling ma rue, ware egkarawat niyu ne dasag ne egpuun te Amey niyu ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Purisu ke egbehey ka diye te subla ne egkaayu-ayu, kene nu seini iwangal-wangal te langun ne etew iling te eggimuwen te egmapitew-pitew re diye te simbaan te me Hudiyu wey diye te me deralanen su eyew egdayanen sikandan te me etew. Egkahiyan ku sikaniyu te malehet: nakarawat e sikandan te dasag dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Piru ke egbehey ka diye te subla ne egkaayu-ayu, kene nu iwangal-wangal minsan diye te amana ne alukuy nu ");
INSERT INTO mbtNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","eyew egkeeles de ka pegbehey nu. Ne ka Amey nu ne iyan nakakita te innimu nu te heles de ka egdasag keykew. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ne emun ke eg-ampu kew, kene kew iling te me etew ne egmapitew-pitew re su egkeupian sikandan ne egsasindeg ne eg-ampu diye te me simbaan te Hudiyu wey diye te me bebalakan eyew egkiteen sikandan te me etew. Egkahiyan ku sikaniyu te malehet: narawat dan e ka dasag dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piru ke eg-ampu ka, seled ka diye te sinabeng nu wey lelekeb ka, ne ampu ka diye te Amey nu ne kene egkakita. Ne egdasahan ka te Amey nu ne iyan nakakita te innimu nu te heles de. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Emun ke eg-ampu ka, kene nu pangawangi iling te eggimuwen te me etew ne egsimba te me diyus-diyus, su egkahiyen dan ne egkarineg sikandan ke malayat ka peg-ampu dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Purisu kene kew iling kandan, su tapey e nakataha ka Amey niyu ke nekey ka keilangan niyu te ware kew pad migbuyu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sikan naa, henduena niyu kayi te eg-ampu: ‘Amey ney ne diye te langit, egdayanen ka matulus ne ngaran nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Eghari ka kayi te kanami, Egkatuman ka igkeupii nu kayi te ampew te tane iling degma te katumanan diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ibehey nu kanami ka egkeilanganen ney kuntee ne egkeenen ");
INSERT INTO mbtNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","wey pasayluwa key te me sale ney, iling degma te pegpasaylu ney te nakasale kanami. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne kene key ipabaye nikeykew diye te pegtintal, ke kene, luwasa key nikeykew puun ki Meibulan.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Su emun ke egpasayluwen niyu ka me etew ne nakasale kaniyu, egpasayluwen kew degma te Amey niyu ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piru ke kene niyu egpasayluwen sikandan, kene kew degma egpasayluwen te Amey niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ne emun ke egpuasa kew, kene kew palelaggew iling te eggimuwen te me etew ne egmapitew-pitew re. Egguhusen dan ka me ulaula ran eyew egkakita te me etew ne migpuasa sikandan. Egkahiyan ku sikaniyu te malehet: narawat dan e ka dasag dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piru ke egpuasa kew, panugkad wey pandep-ug kew, ");
INSERT INTO mbtNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eyew ware egpekeila te migpuasa kew, gawas te Amey niyu ne kene egkakita. Ne egdasahan kew te Amey niyu ne nakakita te innimu niyu te heles de. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kene kew lilimud te me karatuan kayi te ampew te tane para kaniyu, su egketketen de sika te me uled-uled wey egtaangen de, wey egpanakawen de degma. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Piru lilimud kew te me karatuan diye te langit, su warad e me uled-uled ne egketket wey warad taang ne egdereet kayi, wey warad e me takawen ne egpanakew. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Su ke hendei ka karatuan niyu, diye degma ka geyinawa niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ka mata iyan sulu te lawa. Emun ke mating-ew ka mata nu, egmalayag ka pusung nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piru ke kene ne mating-ew ka mata nu, marusilem degma ka pusung nu. Purisu ke marusilem ka pusung nu, durusilemi naa iya ka keugpe nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ware etew ne egkeyimu ne uripen te daruwa ne ahalen, su egdumutan din ka sabeka ne ka dangeb eggeyinawaan din. Egdapihan din ka sabeka wey ka dangeb eglemetan din. Ne iling naan ded due, kene egkaayun ne egpeuripen kew te daruwa, te Manama wey te seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Purisu egnangenan ku sikaniyu te kene kew kalaggew meyitenged te umul niyu. Kene kew kalaggew meyitenged te lawa niyu ke nekey ka egkakeen wey egkeinum niyu, wey ke nekey ka igsaluub niyu. Su ka umul impurtanti pad du te egkakeen, ne ka lawa impurtanti pad du te igsaluub. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tengtengi niyu ma ka me manuk-manuk, ware me pinamula ran wey eggaaniyen dan wey ware inlimud dan diye te lelapeng, piru impakeen sikandan te Amey niyu ne diye te langit. Ne sikaniyu, labew kew pad iya te me manuk-manuk. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na, hentew ma kaniyu ka egpakapamalayat te umul rin pinaahi te pegkalaggew rin? Ware iya! ");
INSERT INTO mbtNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ne mania te egkalaggew kew meyitenged te igsaluub niyu? Sumsumana niyu ka me bulak diye te mabbenes ke immenu ran te egdakel. Ware sikandan miggimu wey migpaneyi te igsaluub dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piru egnangenan ku sikaniyu te minsan si Sulumun, ka amane e ne meyaman wey mabantug, ware ma kumbale din ne iling kateles te seeye ne me bulak. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ke impamatelesan te Manama ka me bulak ne neuyag pad kuntee, ne egsilaban ded te seup ne aldew, iyan kew naan pa kene pakumbalei nikandin! Amana ne deisek ka pegpalintutuu niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Purisu kene kew kalaggew ke nekey ka egkakeen niyu wey ke egkeinum niyu wey ke nekey ka igsaluub niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Su sika ka igkalaggew te me etew ne ware pegpalintutuu wey pegsalig te Manama. Piru nakanengneng e ka Amey niyu ne diye te langit te egkeilanganen niyu seeye. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sikan naa, hun-a niyu paharia ka Manama diye te geyinawa niyu wey tumana niyu ka igkeupii rin, wey igbehey rin ka langun ne ingkeilangan niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Purisu kene kew kalaggew meyitenged te seup ne aldew, su tagse aldew due igkalaggew niyu. Eleg e ka igkalaggew niyu te kuntee ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kene kew hukum te duma, eyew kene kew degma eggukuman te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Su ke immenu niyu te eggukum ka duma, iling ded degma ka peggukum kaniyu te Manama. Ke nekey ka inggamit niyu ne seked, sikan ded degma ka seked ne eggamiten te Manama diye te kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mania te egtengteng ka te buleg te suled nu, ne ware nu sahipaa ka buleg nu ne hendue karakel te terusu? ");
INSERT INTO mbtNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Egmenuwen nu te egkahi diye te suled nu, ‘Eg-aween ku ka buleg nu,’ ke due degma buleg due te mata nu ne hendue karakel te terusu? ");
INSERT INTO mbtNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Egpapitew-pitew re! Hun-eyi nu pa te eg-awe ka buleg nu ne hendue karakel te terusu, eyew egpakameleg-meleg ka ne eg-awe te buleg te suled nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kene niyu ibehey ke nekey ka matulus diye te me asu su kema ke egkahaten kew re nikandan, wey kene niyu iregpak ka me mahal ne me balieg diye te me babuy su kema ke egdi-diekan de nikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Buyu kew ne egbehayan kew; pammitew kew ne egpakakita kew; panektek kew ne eglukatan kew. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Su seeye se egbuyu, egbehayan; wey seeye se egpammitew, egpakakita; wey seeye se egpanektek, eglukatan. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sikaniyu se me amey, ke egbuyu ka anak niyu te egkeenen, egbehayan niyu naa sikandin te batu? ");
INSERT INTO mbtNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne ke egbuyu sikandin te ngalap, egbehayan niyu naa sikandin te uled? ");
INSERT INTO mbtNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ne sikaniyu, minsan makasesale kew, egkateu kew red ne egbehey te meupiya diye te me anak niyu. Ne ka Amey niyu ne diye te langit, subla pad ne egbehey te meupiya diye te egbuyu kandin! ");
INSERT INTO mbtNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Purisu ke nekey ka igkeupii nu ne eggimuwen te me etew diye te keykew, sika degma himuwa nu diye te kandan. Su sika ka kaluwasan te Balaud te Manama wey te sinulat te me prupita. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Seled kew diye te malig-et ne gumawan; su maluag ka gumawan te dalan peendiye te karereetan wey malemu re ne egbayaan. Ne masulug ka me etew ne egseled te sika ne gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piru malig-et ka gumawan wey malised ne egbayaan ka egpeendiye te umul ne ware egtamanan. Ne deisek de ka nakatulitu te sika ne dalan. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bantey kew te kene ne malehet ne me prupita. Eggendue sikandan te kaniyu ne ubag kun iling te me karniru, kunaleg te egpekeiling bes sikandan te mabbulut ne me singgalung. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Egkeilaan niyu sikandan pinaahi te me himu ran, iling te pegkeila niyu te kayu pinaahi te behas din. Su ka buleynen, kene egbebehas te kapayas, ne ka sapinit, kene egbebehas te beyabas. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ne iling naan ded due, ka meupiya ne kayu egbebehas te meupiya. Piru ka mareet ne kayu egbebehas te mareet. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ka meupiya ne kayu kene egbebehas te mareet, ne ka mareet ne kayu kene egbebehas te meupiya. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ka minsan nekey ne kayu ne kene egbebehas te meupiya, egtempuhen wey igdegpak diye te hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Purisu egkeilaan niyu ka kene ne malehet ne me prupita pinaahi te me himu ran. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kene ne langun ne etew ne eg-umew keddi, ‘Magbebaye, Magbebaye’ ne egpakaseled te Migharian te Manama, ke kene, seeye de se egtuman te igkeupii te Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te aldew te peggukum masulug ka egkahi keddi, ‘Magbebaye, Magbebaye, migpangguhud key te lalag te Manama pinaahi te ngaran nu, wey migpangalew key te me busew pinaahi te ngaran nu, wey masulug ka me kein-inuwan ne neyimu ney pinaahi te ngaran nu!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piru egnangenan ku sikandan, ‘Wara a nekeila kaniyu. Pariyu kew keddi, sikaniyu se mareet ne me etew!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Purisu ka minsan hentew ne egpakarineg te keddi ne lalag wey egtuman kayi, egpekeiling sikandin te matagseb ne etew ne migbebaley ne batu se pabunsuran. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ne miglugsu ka uran, ne migbaggiyu ka weyig, wey migpangalamag. Ne insuru-suru te kalamag ka sika ne baley piru ware seeye napeled tenged su nakapabunsud te batu. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Piru ka etew ne egpakarineg te keddi ne lalag wey kene egtuman kayi, egpekeiling sikandin te etew ne egkeungel-ungel ne migbebaley ne diye ipes-ek te pantad. ");
INSERT INTO mbtNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne miglugsu ka uran, ne migbaggiyu ka weyig, ne migpangalamag. Ne insuru-suru te kalamag ka sika ne baley wey napeled e wey natamtamanan nahuhus.” ");
INSERT INTO mbtNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te pegkapenga ni Hisus te miglalag, neinu-inu ka masulug ne me etew te kandin ne pegpanulu ");
INSERT INTO mbtNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su due geem te pegpanulu din, wey kene ne iling te me talagpanulu te Balaud te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te pegtupang e ni Hisus puun te bubungan, susuluhi ka me etew ne migsinundul kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne due sabeka ne etew ne ibungen ne migparani kandin wey migpanimbuel ne migkahi, “Magbebaye, ke egkeupian ka, egkabawian a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ne insamsam sikandin ni Hisus te migkahi, “Uya, igkeupii ku. Egkeulian kad!” Ne sahuhune ne neulian sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ne migkahiyan sikandin ni Hisus, “Kene nu ipangguhud seini te minsan hentew. Ke kene, hendiye ka te talagpanubad wey papitew ka kandin, wey panubad ka sumale te insuhu ni Muwisis eyew te pegpamalehet te me etew ne neulian kad e.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pegginguma ni Hisus diye te Kapirnaum, due migtemu kandin ne kepitan te me sundalu te Ruma ne migpeyid-u-hid-u diye te kandin ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Magbebaye, nekeyibat de ka suluhuanen ku diye te baley ku ne kene egkaweil se lawa wey amana sikandin mig-antus.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ne migkahiyan ni Hisus sikandin, “Eggendiya a ka egbawi kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ne migtabak ka kepitan, “Magbebaye, kena a ne likes ne egpepanumbaley keykew diye te baley ku. Piru ilalag nu re ne egkeulian iya ka suluhuanen ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nakanengneng a kayi, uya su minsan degma sikeddi, due labew keddiey ne me upisyal wey due degma me sakup ku ne me sundalu. Ke egnangenan ku ka sabeka, ‘Hendiye ka,’ eggendiye iya sikandin. Ne emun ke egnangenan ku ka dangeb, ‘Hendini ka,’ eggendini iya sikandin. Ne emun ke egnangenan ku ka uripen ku, ‘Himuwa nu seini,’ eggimuwen din iya seeye.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te pegkarineg ni Hisus te ingkahi rin, neinu-inu sikandin wey migkahi diye te me etew ne migsinundul kandin, “Egnangenan ku sikaniyu te malehet: ware e pad nakakita te iling kayi karakel ne pegpalintutuu te etew, minsan te me Hudiyu! ");
INSERT INTO mbtNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Egnangenan ku sikaniyu te due masulug ne etew ne diye egpuun te igsile wey diye te iglineb ne eglagpu egkeen engki Abraham, Isaak, wey ki Hakub diye te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piru ka me Hudiyu ne iyan perem egkasakup te Peghari te Manama, iyan nasi igdegpak diye te lihawangan ne amana ne durusilemi. Ne diye, egmandalawit sikandan wey egmakihet te ngipen dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne migkahiyan ni Hisus ka kepitan, “Uli kad e, egkatuman ka impalintutuuwan nu.” Ne neulian e ka suluhuanen te kepitan te seeye de ne uras. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ne migpanumbaley si Hisus diye ki Pidru. Ne dutu nakita rin ka anuhang ni Pidru ne malitan ne miggibat su miglusungan. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne miggen-genan ni Hisus ka belad te malitan, ne due-rue ne neulian sikandin. Ne mig-enew sikandin wey intanggu rin e ensi Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ne hengkayi te egkasagkup e, impanguyan te me etew diye ki Hisus ka masulug ne migpanerepan te me busew. Ne impangalew rin ka me busew pinaahi re te lalag din wey impamawian din ka langun ne egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neyitabu sika eyew egkatuman ka ingkahi ni prupita Isayas, “Sikandin ka egpamawi te egmanggeramen ta wey te me dalu ta.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te pegkakita ni Hisus ne masulug ka me etew ne miglingkus kandin, migkahiyan din e ka me hibateen din, “Eglapas ki diye te deyipag te lanew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ne due talagpanulu te Balaud te Manama ne migparani diye te kandin ne migkahi, “Talagpanulu, eg-ikul a keykew minsan hendei ka eggendiye.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne migtabak si Hisus kandin, “Due eggelesan te me laku wey due salag te me manuk-manuk te aw-awangan, piru ka Anak te Etew ware mule egkeyimmelayan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne due lein ne hibateen ni Hisus ne migkahi, “Ahalen, eg-uli e pad su eglebeng e pad te amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Piru migtabak si Hisus kandin, “Ikul ka keddi! Iyan e balahad ne eglebeng te me minatey seeye se ware umul ne ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nataman, mig-untud e te balangey si Hisus duma te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te sasangan e sikandan ne eglapas, sahuhune ne migpangalamag te makeseg, ne dutu, natimpaan e ka balangey te me bunlud. Piru newulep mule si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Seeye naa, impupukew e si Hisus te me hibateen din te migkahi, “Magbebaye, luwasa key! Egkalened kid e!” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ne migkahiyan ni Hisus sikandan, “Mania te egkaaldek kew? Deisek ka pegsalig niyu!” Ne mig-enew sikandin wey insaparan din ka kalamag wey ka me bunlud. Ne due-rue ne migmalinawen e. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Amana neinu-inu ka me duma rin wey migkahi, “Nekey-a etawa seini se minsan ka kalamag wey me bunlud, egpalintutuu kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te nakatuhun e sikandin diye te deyipag te lanew, diye te inged ne Gadara, due migsinug-ung ki Hisus ne daruwa ne etew ne migserepan te busew. Ka seeye ne me etew, diye migpuun te sulung ne sabalanan wey amana sikandan ne mabbulut, sikan naa, egkaaldek e ka me etew ne egbaye te seeye ne dalan. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te pegkakita ran ki Hisus, migpanguleyi sikandan ne migkahi, “Anak te Manama, kene key nikeykew banggawa! Iyan nu naa innendini ka eglegpad kanami minsan kene pad ne eleg ne timpu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ne diye te bayew madmariyu, due masulug ne me babuy ne egmanuwal. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne migpeyid-u-hid-u ka me busew ki Hisus ne migkahi, “Emun ke eg-alawen key nikeykew, duen key re paserepa te me babuy.” ");
INSERT INTO mbtNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ne migkahiyan ni Hisus sikandan, “Uya, hendiye kew e!” Purisu nanligwang e sikandan dutu te daruwa ne etew wey nanerep e diye te me babuy. Nataman, namallahuy e patupang ka me babuy diye te dalama peendiye te lanew wey nallened e. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ne namallahuy e diye te siyudad ka me talagtameng te me babuy wey impangguhud dan e ka langun ne neyitabu, wey ka neyitabu te me etew ne migserepan te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Seeye naa, nangendiye te ki Hisus ka langun ne etew diye te siyudad wey migpeyid-u-hid-u sikandan ne eg-awe si Hisus te inged dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nataman, mig-untud e si Hisus te balangey ne miglapas te lanew wey miggendiyad e te lungsud din. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne due nanginguma diye te kandin ne migyayung te etew ne kene egkaweil se lawa. Te pegkakita ni Hisus ne dakel ka pegpalintutuu ran, migkahiyan din e ka kene egkaweil se lawa, “Tatu, pakannekal ka su impasaylu e ka me sale nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ne due degma me talagpanulu te Balaud te Manama ne migkahi diye te suman-suman dan, “Egbaley-baley te Manama ka seini ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piru puun su natahaan ni Hisus ka insuman-suman dan, migkahiyan din sikandan, “Mania te egsuman-suman kew te mareet? ");
INSERT INTO mbtNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hendei bes ka malemu ne egkahiyen, ka egkahi, ‘Impasaylu e ka me sale nu,’ wey ke egkahi, ‘Enew ka wey hipanew kad’? ");
INSERT INTO mbtNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Piru igpapitew ku kaniyu ne due katenged te Anak te Etew kayi te ampew te tane te pegpasaylu te me sale.” Ne migkahiyan din e ka etew ne kene egkaweil se lawa, “Enew ka, wey uyana nu ka miggibatan nu, wey uli kad e diye te kaniyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne mig-enew ka etew wey mig-uli e. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te pegpakakita dutu te masulug ne me etew, nenaaldek sikandan wey indayan dan ka Manama tenged te pegbehey rin te iling due ne katenged diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nataman, mig-awe e si Hisus dutu, wey te sasangan e sikandin ne eggipanew, due nakita rin ne egngaranan ki Matiyu ne migpinnuu diye te upisina rin ne bayaranan te buhis. Ne migkahiyan din si Matiyu, “Ikul ka keddiey.” Ne migsasindeg si Matiyu wey mig-ikul e ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nataman, migkeen si Hisus diye te baley ni Matiyu. Ne due nanginguma ne masulug ne me talagsukut te buhis wey me makasesale ne miglagpu kandin te migkeen duma te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te pegkakita dutu te me Parisiyu, mig-insaan dan e ka me hibateen din ne migkahi, “Mania te miglagpu migkeen ka talagpanulu niyu te me talagsukut te buhis wey te me makasesale?” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Piru te pegkarineg dutu ni Hisus, migkahi e sikandin, “Ka me etew ne ware dalu, kene egkeilangan te talagbawi, ke kene, seeye de se egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na, nengnengi niyu ke nekey ka kaluwasan te nasulat diye te Kasulatan ne miggenendue, ‘Kene ne iyan ku igkeupii ka igpanubad niyu ne me ayam, ke kene, ka hid-u niyu te duma.’ Wara a miggendini eyew te peg-umew te me matareng, ke kene, te me makasesale.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nataman, miggendiye te ki Hisus ka me hibateen ni Huwan ne Talagbewutismu wey mig-inse kandin, “Mania te malasi key egpuasa wey ka Parisiyu, piru ware mule ka me hibateen nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ne migtabak si Hisus, “Egkalange naa ka me mahaliyug te egpangasawa ke duma ran pad sikandin? Kene iya! Piru egginguma ka timpu ne eg-angayen e diye te kandan ka egpangasawa ne henduen pad sikandan egpuasa. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ne ware etew ne egtutupak te iyam ne manggad diye te tapey ne kumbale, su egkenseng ka intupak wey egkakatkat e ka inteyian wey nasi e egmaluag ka gisi. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne ware degma etew ne egtahu te iyam ne binu diye te tapey ne tahuanan ne laplap te mananap, su ke eggimuwen din sika, egbetu ka tahuanan wey egkeitis e ka binu ne egkareetan e degma ka tahuanan. Ka iyam ne binu keilangan ne diye igtahu te iyam ne tahuanan ne laplap eyew kene egkareetan ka binu wey ka tahuanan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te sasangan pad ne eglalag si Hisus, due migginguma ne sabeka ne pangulu te me Hudiyu. Migpanimbuel sikandin diye te tangkaan ni Hisus ne migkahi, “Iyam e nabigtawi ka anak ku ne malitan, piru ke eggendiyaan nu sikandin wey egtel-eban nu te belad nu, egkeuyag pad sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ne migsasindeg si Hisus wey migdume e kandin wey ka me hibateen din degma. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ne due malitan ne nabaybayaran ka eglangeseen seled te sapulu wey daruwa (12) ne leg-un. Migpatalisek sikandin te masulug ne me etew ka migparani diye te peka ni Hisus wey insamsam din ka sidsid te kumbale ni Hisus ");
INSERT INTO mbtNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","su migsuman-suman sikandin, “Emun ke egpakasamsam a minsan te kumbale din de, egkeulian a iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ne miglilingey si Hisus wey nakita rin e ka malitan, ne migkahiyan din e, “Beyi, pakannekal ka, ka pegpalintutuu nu ka nekeuli keykew.” Te sikan de, neulian e ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te pegginguma ni Hisus diye te baley te pangulu, nakakita sikandin te egmamulendag wey te maggulub ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ne migkahiyan din sikandan, “Awe kew rue! Ware namatey ka beyi-beyi su nakalipereng de sikandin.” Piru migdali-dian de te me etew si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te impalihawang e ka me etew, migseled e degma si Hisus diye te sinabeng te beyi-beyi wey miggen-genan din ka belad. Ne dutu, mig-enew e ka beyi-beyi. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne nekeempet e te langun ne lungsud te seeye ne inged ka guhuren meyitenged kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Te peg-awe e ni Hisus dutu, due daruwa ne butud ne migsinundul kandin ne migpanguleyi, “Kabuhalan ni Dabid, ikeyid-u key nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nataman, migseled e si Hisus diye te baley ne mig-ugpaan din wey migparani diye te kandin ka daruwa ne butud. Ne mig-insaan din e sikandan te migkahi, “Migpalintutuu kew naa ne egkabawian ku sikaniyu?” Ne migtabak sikandan, “Uya, ahalen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ne dutu, insamsam e ni Hisus ka mata ran te migkahi, “Egkeulian kew sumale te pegpalintutuu niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne due-rue ne nakakita sikandan. Ne migpegpehetan e sikandan panpanayi ni Hisus ne kene egpepangguhuren te minsan hentew. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piru nangipanew sikandan wey nasi dan mule iwangal-wangal si Hisus diye te langun ne lungsud te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ne hengkayi te nangipanew e ka daruwa ne etew, due in-uuyan diye te ki Hisus ne migserepan te busew ne neummew e. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te naalew e ni Hisus ka busew, nakalalag e ka ummew. Ne neinu-inu ka masulug ne me etew diye wey nakakahi sikandan, “Ware de due neyitabu kayi te Israil ne iling due!” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piru migkahi ka me Parisiyu, “Ka pangulu te me busew ka migbehey kandin te geem te pegpangalew te me busew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ne miggendiye si Hisus te langun ne me siyudad wey me bariyu wey migpanulu sikandin diye te me simbaan te me Hudiyu. Ne migpangguhud sikandin te Meupiya ne Panugtulen meyitenged te Peghari te Manama wey migpamawian din ka langun ne egmanderalu wey ka due egmanggeramen. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te pegkakita ni Hisus te masulug ne me etew, neyid-u sikandin kandan tenged su nalasey e sikandan wey ware egpakabulig kandan. Iyan egkeilingan nikandan ka me karniru ne ware talagtameng. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne migkahiyan din e ka me hibateen din, “Dakel ka eggaaniyen, piru deisek de ka talaggaani. ");
INSERT INTO mbtNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Purisu ampu kew diye te Kamuney te eggaaniyen ne egpeuyan sikandin te me talaggaani diye te eggaaniyen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ne impeumew ni Hisus ka sapulu wey daruwa (12) ne hibateen din wey impamehayan din sikandan te katenged te pegpangalew te me busew wey te pegpamawi te langun ne me dalu wey egmanggeramen te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Seini ka me ngaran te seeye se sapulu wey daruwa (12) ne apustulis: ka an-anayan si Simun ne eg-immuan ki Pidru wey si Andris ne suled din, ka daruwa ne anak ni Sibidiyu ne si Santiyagu wey si Huwan, ");
INSERT INTO mbtNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Pilipi wey si Bartulumi, si Tumas wey Matiyu ne talagsukut te buhis, si Santiyagu ne anak ni Alpiyu wey si Tadiyu, ");
INSERT INTO mbtNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simun ne ribildi wey si Hudas Iskaryuti ne mig-eakal ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ne impeyipanew e ni Hisus ka sapulu wey daruwa (12) ne hibateen wey impanagtahaan te migkahi, “Kene kew hendiye te kene ne me Hudiyu wey diye te me lungsud te Samarya, ");
INSERT INTO mbtNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ke kene, hendiyei niyu ka me kabuhalan ni Israil ne nekeiling e te me karniru ne natarin. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Taheed te diye kew, iwali niyu ne mahaan e ka Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ne bawii niyu ka egmanderalu, uyaha niyu ka me minatey, bawii niyu ka egmangibungen, wey pangalawa niyu ka me busew. Nakarawat kew puun te Manama te ware bayad, purisu pamehey kew degma te ware bayad. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kene kew tetahu te seleppi ne bulawan, pelata, wey minsan keddeku diye te puntil niyu, ");
INSERT INTO mbtNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","wey kabil, eg-ilisan niyu ne kumbale, sandal, wey tuked. Su seeye se eggimu, eleg ne egbehayan te egkakeen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Emun ke egginguma kew te sabeka ne lungsud wey ke bariyu naa, pammitew kew te etew ne likes ne egtuenan niyu, wey diye kew pa ugpe taman te eg-awe kew e te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ke egseled kew te baley, panalangini niyu ka mahinged. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne emun ke egdawaten kew te mahinged, ihaat niyu ka panalangin diye te kandan, piru ke kene, hawia niyu ka panalangin diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ke due baley wey ke lungsud ne kene egdawat kaniyu wey kene egpammineg kaniyu, engkeri niyu sika wey pelpela niyu ka alinepung diye te paa niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Egnangenan ku sikaniyu te malehet: te aldew te peggukum subla pad ne masumpit ka legpad te Manama te sika ne lungsud du te matig-Suduma wey Gumura. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pammineg kew! Igpeendiye ku sikaniyu ne egpekeiling te me karniru diye te me etew ne egpekeiling te mabbulut ne me singgalung. Purisu keilangan ne iling kew katagseb te uled wey iling kaamuk te seleppati. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ne bantey kew te me etew su eg-uyanen kew nikandan diye te hukumanan wey egpanlampesan kew nikandan diye te me simbaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eg-uyanen kew nikandan diye te tangkaan te me gubirnadur wey diye man-e te me Hari tenged keddiey eyew egpakapangguhud kew te Meupiya ne Panugtulen diye te kandan wey diye te kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Emun ke egdakepen kew e, kene kew kalaggew ke nekey ka iglalag niyu wey ke egmenuwen niyu te eglalag, su igpanulu e kaniyu te Manama ke nekey ka eglalahen niyu te sika ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Su kenad e ne sikaniyu pad ka eglalag, ke kene, ka Panisingan e te Amey niyu ne Manama ka eglalag pinaahi kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Due me etew ne iyan mismu egpeyimatey te me suled dan. Ne due me amey ne egpeyimatey te me anak dan, ne due degma me anak ne egkuntere te me amey wey iney ran wey egpeyimatey kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Egdumutan kew te langun ne etew tenged keddiey. Piru seeye se egpabulus eg-ikul keddiey taman te katamanan iyan egkaluwas. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Emun ke egbaybayaran kew diye te sabeka ne lungsud, aput kew diye te lein ne lungsud. Egnangenan ku sikaniyu te malehet: te kene niyu pad egkalingut ka langun ne me lungsud te Israil, eglibed e ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ware hibateen ne labew te kandin ne talagpanulu, wey ware uripen ne labew te kandin ne ahalen. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eleg de iya ne egpekeiling ka hibateen te talagpanulu din. Ne ka uripen, eleg de iya ne egpekeiling degma sikandin te ahalen din. Ke egngaranan ma ki Meibulan ka pangulu te sabeka ne pamilya, iyan naan pa iya ka me sakup din. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Purisu kene kew kaaldek te seeye ne me etew. Su ke nekey ka imbunbunan, egkalekisan, wey ka langun ne inneles, egkanengnengan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ke nekey ka ingguhud ku kaniyu diye te marusilem, ipangguhud niyu diye te malayag. Ne ke due narineg niyu ne innaas-naas de, iwangal-wangal niyu diye te langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kene kew kaaldek te me etew ne egpekeyimatey te lawa piru kene egpekeyimatey te gimukud, ke kene, iyan niyu ikaaldek ka Manama ne egpakadereet te lawa wey gimukud diye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ka daruwa ne maya egkabeli re te baratu, piru ware sabeka kandan ne egkeulug diye te tane gawas ke pegbuut te Amey niyu ne egkeulug sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne sikaniyu, naseel rin ma langun minsan ka me bulbul te ulu niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Purisu kene kew kaaldek, su subla kew pad ne labew du te me maya. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sikan naa, ka minsan hentew ne eg-angken keddiey diye te tangkaan te me etew, eg-angkenen ku degma sikandin diye te tangkaan te Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piru minsan hentew ne egpahunware meyitenged keddiey diye te tangkaan te me etew, igpahunware ku degma sikandin diye te tangkaan te Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kene kew suman-suman ne iyan ku innendini ka eg-uyan te keupianan kayi te ampew te tane. Kene ne iyan ku innendini ka eg-uyan te keupianan, ke kene, te kasamuk. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Su iyan ku innendini ka egpegkuntere te me anak ne lukes te amey ran, ka egpegkuntere te me anak ne malitan te iney ran, wey ka egpegkuntere te me ambey te anuhang dan ne malitan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne iyan ded egkakuntere te etew ka diye mismu te baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ka minsan hentew ne eggeyinawa te amey wey iney rin labew te peggeyinawa rin keddiey, kene ne likes ne egkeyimu ne hibateen ku. Ne ka eggeyinawa te me anak din labew te peggeyinawa rin keddiey, kene ne likes ne egkeyimu ne hibateen ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ka minsan hentew ne kene egtiang te kandin ne krus wey kene eg-ikul keddiey, kene ne likes ne egkeyimu ne hibateen ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Seeye se egkeupian ne egluwas te kandin ne umul, nasi egkawaraan kayi, piru seeye se egkawaraan te kandin ne umul tenged keddiey, egpakarawat te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ka minsan hentew ne egdawat kaniyu, egdawat degma keddiey. Ne ka minsan hentew ne egdawat keddiey, egdawat degma te migpeuyan keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ka minsan hentew ne egdawat te prupita tenged su prupita sikandin, egpakarawat te dasag iling te dasag ne egkarawat te prupita. Ne ka minsan hentew ne egdawat te matareng ne etew tenged su matareng sikandin, egpakarawat te dasag iling te dasag ne egkarawat te matareng ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Egnangenan ku sikaniyu te malehet: ka minsan hentew ne egpeinum te minsan senge ubab de ne maagsil ne weyig diye te hibateen ku minsan kene ne impurtanti tenged su hibateen ku sikandin, egpakarawat iya sikandin te dasag.” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hengkayi te nakapenge e si Hisus ka migpanulu te sapulu wey daruwa (12) ne hibateen din, miggendiyad e sikandin te marani ne me lungsud eyew te pegpanulu wey te pegwali. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ne si Huwan ne Talagbewutismu diye pad te prisuwan, wey nakarineg sikandin te neneyimu te Kristu. Seeye naa ka impeendiye din ki Hisus ka duma ne me hibateen din eyew egpepanginginseen. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ne mig-inse sikandan, “Sikeykew iya ka egginguma ne insaad te Manama wey ke egtetahad key pad te duma?” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ne migtabak si Hisus diye te kandan, “Libed kew diye te ki Huwan wey guhuri niyu sikandin ke nekey ka nakita niyu wey narineg niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Guhuri niyu sikandin te ka me butud egmakakite e, ka me pungku egmekeyipanew e, ka me ibungen neneulian e, ka me bengel egmakarineg e, wey ka me minatey neneuyag e wey ka egkengaayu-ayu, napangguhuran e te Meupiya ne Panugtulen. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Keupianan te seeye se ware migduwa-ruwa meyitenged keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te nekeyipanew e seeye se sinuhu ni Huwan, mig-insaan e ni Hisus ka masulug ne me etew meyitenged ki Huwan, “Te peggendiye niyu te ki Huwan diye te mammara ne inged ne kene egkeugpaan, nekey-a ka in-iman-iman niyu ne egtengtengan? Etew naa ne egpekeiling te tibehew ne hendei re iya tapid egbanlaya te kalamag? ");
INSERT INTO mbtNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ke kene, nekey naa ka in-iman-iman niyu ne egtengtengan te peggendiye niyu te ki Huwan? Etew naa ne migsaluub te mahal ne kumbale? Kene, su ka me etew ne egkukumbale te mahal, diye nangugpe te me palasyu te me Hari. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na, nekey naa iya ka in-iman-iman niyu ne egtengtengan te peggendiye niyu? Prupita naa? Uya, piru egnangenan ku sikaniyu te subla pad si Huwan te prupita, ");
INSERT INTO mbtNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","su sikandin ka nasulat te Kasulatan ne miggenendue, ‘Igpewun-a ku keykew ka suluhuanen ku ne iyan eg-andam te dalan ne egbayaan nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Egnangenan ku sikaniyu te malehet: ware de due neetew kayi te ampew te tane ne subla pad ki Huwan ne Talagbewutismu; piru minsan hentew ne kene ne impurtanti diye te Migharian te Manama, subla pad iya ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Puun te pegwali ni Huwan ne Talagbewutismu taman kuntee, due me etew ne migpakannekal migwali te Peghari te Manama, wey due degma me etew ne migpanaman-taman migpehes ne egkasakup sikandan kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Su nahuhud e ka Peghari te Manama te langun ne me prupita wey te Balaud te Manama taman te miggingume e si Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne emun ke egpalintutuu kew te inlalag dan, si Huwan iya si Ilyas, ka egkahiyen ne egginguma. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Purisu, ke egkeupian kew ne egpakasabut, sumsumana niyu ay-ayari ke nekey ka narineg niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Migpabulus si Hisus ka migkahi, “Nekey buwa ka egpeilingan ku te me etew te kuntee ne timpu? Egpekeiling sikandan te me bate ne naminnuu diye te palingkiyan ne egpangumew te duma ran ");
INSERT INTO mbtNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ne egkahi, ‘Migpamulendahan ney e sikaniyu piru ware kew migsesayew, mig-ulahingan ney e sikaniyu te peglungku piru ware kew migmaninehew.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Te peggendini ni Huwan, ware sikandin migkeen wey mig-inum te binu, ne migkahi sikandan te migserepan e sikandin te busew. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ne migginguma degma ka Anak te Etew ne migkeen wey mig-inum te binu, ne migkahi degma sikandan, ‘Pitawa niyu seini ne etew, bel-is wey taleinum, wey alukuy te me talagsukut te buhis wey te me makasesale.’ Piru minsan ke iling due, ka kaalam te Manama egkakita diye te etew ne migpamakey kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nataman, indew-ey ni Hisus ka me matig-siyudad ne innimuwan din te me kein-inuwan tenged su ware dan inniyuhi ka me sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Migkahi sikandin, “Mekeyid-u-hid-u kew ka me matig-Kurasin! Mekeyid-u-hid-u kew ka me matig-Bitsayda, su emun ke diye pa perem te Tiru wey te Sidun himuwa ka me kein-inuwan ne innimu diye te kaniyu, naluhey ran de perem inniyuhi ka me sale dan ne migsaluub te saku wey migbubukbuk te abu diye te ulu ran. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Piru egnangenan ku sikaniyu, maagkap pad ka iglegpad te Manama te matig-Tiru wey matig-Sidun du te iglegpad kaniyu te aldew te peggukum. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne sikaniyu se matig-Kapirnaum, kahiyen niyu buwa ne egpakaparibabew kew taman diye te langit? Kene, nasi kew igdegpak diye te inged te me gimukud ne egngaranan te Hadis! Su emun ke diye pa perem te Suduma himuwa ka me kein-inuwan ne innimu diye te kaniyu, duen pad perem kuntee ka Suduma. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Piru egnangenan ku sikaniyu, maagkap pad ka iglegpad te Manama te matig-Suduma du te iglegpad kaniyu te aldew te peggukum!” ");
INSERT INTO mbtNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te seeye ne timpu, mig-ampu si Hisus ne migkahi, “Ame, Manama te langit wey tane. Egpasalamatan ku sikeykew, su inneles nu seini puun te matagseb wey te utekan ne me etew wey impakita nu seini diye te me etew ne ware katuenan. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Uya Ame, su sika ka egpakapahale keykew. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Imbehey te Amey ku ka langun kayi te keddiey. Ne ware sabeka ne nekeila te Anak gawas te Amey, wey ware degma sabeka ne nekeila te Amey gawas te Anak wey te seeye se igkeupii te Anak ne igpeila diye te Amey rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Parani kew keddiey ka langun ne nabeley wey nabehatan su egpeyimelayen ku sikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Isangen niyu ka yuggu ku wey pepanulu kew keddiey su mapariralemen wey maayad-ayad a, wey egpekeyimeley ka me gimukud niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Su malemu re ka yuggu ne igsangen ku kaniyu wey maagkap de ne egtiangen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te sabeka ne Aldew te Peggimeley, nangipanew ensi Hisus ne diye migbaye te impamulaan te trigu. Ne seeye se me hibateen din nanggutasan, purisu nangetu sikandan te me trigu eyew egkeenen dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Piru te pegkakita dutu te me Parisiyu, migkahiyan dan e si Hisus, “Pitawa nu! Miggimu ka me hibateen nu te supak te Balaud te Aldew te Peggimeley.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Piru migtabak si Hisus, “Ware kew bes nakasabut te imbasa niyu meyitenged te innimu ni Dabid te miggutasan sikandan te me duma rin? ");
INSERT INTO mbtNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Migseled sikandin diye te baley te Manama wey migkeen te paan ne inhalad e diye te Manama. Ne sumale te kanta ne Balaud, kene egpakakeen dutu si Dabid wey ka me duma rin su ka me talagpanubad de ka intuhutan ne egpakakeen dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne ware kew bes nakasabut te imbasa niyu diye te Balaud te Manama ne nakasupak te Aldew te Peggimeley ka me talagpanubad diye te timplu? Piru ware sikandan nakasale. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Piru egnangenan ku sikaniyu te due labew pad te timplu ne kayi kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Emun ke nasabut niyu perem ka kaluwasan te seini se nakahi ne, ‘Kene ne iyan ku igkeupii ka igpanubad niyu ne me ayam, ke kene, ka hid-u niyu te duma.’ Sikan naa, kene niyud e perem senditi ka ware nakasale. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Su ka Anak te Etew iyan ahalen te Aldew te Peggimeley.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nataman, mig-awe e si Hisus wey miggendiyad e te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne diye, due etew ne nakengkeng se belad wey due degma me Parisiyu ne egpammitew te eleg ne katarengan ne igkasumbung dan si Hisus. Ne mig-insaan dan si Hisus ne migkahi, “Intuhut naan ded te Balaud ka pegpamawi te Aldew te Peggimeley?” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne migtabak si Hisus, “Ke due karniru niyu ne neulug diye te lungag te Aldew te Peggimeley, kene niyu naa seeye egkuen? Egkuen iya! ");
INSERT INTO mbtNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Piru subla pad ne labew ka etew du te karniru. Purisu kene ne supak te Balaud ka eggimu te meupiya te Aldew te Peggimeley.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nataman, migkahiyan e ni Hisus ka etew ne nakengkeng se belad, “Ketenga nu ka belad nu.” Ne ingketeng te etew ka belad din wey neulian e, iling te limang ne belad din. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ne nanlihawang ka me Parisiyu wey migplanu ke egmenuwen dan te eggimatey si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pegkanengnengi ni Hisus te planu ran, mig-awe e sikandin dutu. Ne masulug ne etew ka migsinundul kandin wey impamawian din ka langun ne egmanderalu, ");
INSERT INTO mbtNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","wey inteesan din sikandan te kene egpepangguhuren meyitenged kandin ");
INSERT INTO mbtNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","eyew egkatuman ka ingkahi ni prupita Isayas ne miggenendue: ");
INSERT INTO mbtNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Seini ka in-alam ku ne suluhuanen ku. Inggeyinawaan ku sikandin wey ingkahale ku. Igpeuyan ku diye te kandin ka Panisingan ku, wey igpangguhud din diye te langun ne nasud ka matareng ne peggukum ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kene sikandin egpakig-apul wey ke egbalbalukan wey kene eggulub-gulub diye te me kelesadda. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kene din eggepuen ka nabegkul ne luwey, wey kene din eg-ebukan ka sulu ne egpangalap-halap naan de se legleg. Egpabulus sikandin te eggimuwen din taman te egkatuman e ka matareng ne igkeupii te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne iyan egpallatengen te langun ne etew ka ngaran din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nataman, due in-uuyan diye te ki Hisus ne etew ne nabutud wey neummew puun su migserepan te busew. Ne imbawian ni Hisus ka etew, ne dutu nakakite e wey nakalalag e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nawangalan ka langun ne etew, wey migkahi sikandin, “Seini buwa iya ka kabuhalan ni Dabid?” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piru te pegkarineg dutu te me Parisiyu, migkahi sikandan, “Si Meibulan ne pangulu te me busew ka migbehey kandin te geem te pegpangalew te me busew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Piru natahaan ni Hisus ka me suman-suman dan, purisu migkahiyan din sikandan, “Ka sabeka ne inged ne egmeun-unayey egmeeg-ehetey ka me etew, egkahuhus iya ka sika ne inged. Ne ka lungsud wey taltalaanak ne egmeun-unayey egmeeg-ehetey, kene iya sika egpakasasindeg. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne emun ke eg-unayen ni Meibulan te egpangalew ka me duma rin, egmekeg-uney-uney red sikandan egmekeg-ehet. Na, egmenuwen dan naan e te egpasasindeg ka inged dan? ");
INSERT INTO mbtNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne emun ke iyan ku pa inggamit ka geem ni Meibulan te pegpangalew te me busew, hentew naa ka migbehey te geem te me hibateen niyu ne egpangalew degma te me busew? Purisu ka me hibateen niyu ka mismu ne migpamalehet ne seyyup kew iya. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Piru migpangalew a te me busew pinaahi te Panisingan te Manama, sikan naa migpeila seini ne miggingume e diye te kaniyu ka Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ware egpakaseled diye te baley te manekal ne etew wey egpakaahew te me kasangkapan din te kene din pad eggun-aan te egbaku ka kamuney. Ke egkabaku din e ka kamuney henduen din pad egkaahew ka me kasangkapan. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ka kene egpalapig keddiey, egkuntere keddiey; ka kene egbulig keddiey te pegpalibulung, egpegsuwey naa. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Purisu egnangenan ku sikaniyu te egkapasaylu pad ka me sale te me etew wey ka pegbaley-baley ran te Manama, piru ka egbaley-baley te Panisingan te Manama kene iya egkapasaylu. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Minsan hentew ne eglemet te Anak te Etew, egkapasaylu red, piru ka minsan hentew ne eglemet te Panisingan te Manama, kene iya egkapasaylu te ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Egbebehas te meupiya ka kayu ne meupiya, ne egbebehas degma te mareet ka kayu ne mareet, su egkeila ka kayu pinaahi te behas din. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sikaniyu se me uled! Egmenuwen niyu te eglalag te meupiya, te maddeet kew ma? Su ke nekey ka diye te pusung te etew, sika ka iglalag din. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ka meupiya ne etew, eglalag te meupiya ligkat te meupiya ne pusung din. Piru ka mareet ne etew, eglalag te mareet ligkat te mareet ne pusung din. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Egnangenan ku sikaniyu te ka tagse lalag ne ware karuan ne eglalahen te me etew, egpanabaken dan sika te Aldew te Peggukum. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Su eggukuman kew sumale te impanlalag niyu, ke eleg kew naa ne eglegparan wey se kene.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nataman, due me talagpanulu te Balaud te Manama wey me Parisiyu ne migkahi diye te kandin, “Talagpanulu, keupian key ne egkita keykew ne eggimu te kein-inuwan puun te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ne migtabak si Hisus, “Ka me etew te kuntee ne timpu, amana ne mareet wey kenad ne maparuma-ruma te Manama. Migbuyu sikandan te kein-inuwan piru ware igpakita kandan gawas te kein-inuwan ne neyitabu ki Hunas ne sabeka ne prupita. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iling ki Hunas te miggingumaan te tatelu ne aldew wey karusileman diye te getek te dakel ne ngalap te dahat, ne iling ded degma ka egkeyitabu te Anak te Etew. Su eggingumaan sikandin te tatelu ne aldew wey tatelu ne karusileman diye te diralem te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te Aldew te Peggukum, egsasindeg ka matig-Ninibi duma kaniyu wey egsenditan kew nikandan su mig-inniyuhan dan ka me sale dan te pegkarineg dan te wali ni Hunas. Ne kuntee, kayid e ka labew pad ki Hunas. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te Aldew te Peggukum, egsasindeg duma kaniyu ka Rayna puun te Igkakawanan ne Balabahan dapit te Igsile wey egsenditan kew nikandin, su amana ne mariyu ka impuunan din te miggipanew eyew te pegpammineg te maralem ne kaalam ni Hari Sulumun. Ne kuntee, kayid e ka labew pad ki Sulumun. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ne emun ke eg-awe e ka busew diye te etew, egleug-leug sikandin diye te mammara ne me inged eyew egpammitew te egkeyimelayan din. Ke ware egkakita rin, ");
INSERT INTO mbtNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","egkahi e sikandin, ‘Eglibed e red diye te tapey ne migserepan ku.’ Ne emun ke egkakita rin te peglibed din ne ware mig-ugpe dutu ne migmalinis e wey naay-ayaran e nateil, ");
INSERT INTO mbtNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","eglihawang e man-e sikandin wey egpanguyan e te lein ne pitu ne busew ne subla pad ne mareet kandin. Ne egseled sikandan diye wey diyad e eg-ugpe; ne ka peg-ugpe te sika ne etew subla pad ne mareet du te an-anayan. Purisu iling ded due ka egkeyitabu kaniyu te mareet ne me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Te sasangan pad ne eglalag si Hisus te me etew, migtetahad e diye te lihawangan ka iney rin wey me suled din su egkeupian ne egpakiglalag kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne due etew ne mignangen ki Hisus ne migkahi, “Due te lihawangan ka iney wey me suled nu su egkeupian ne egpakiglalag keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Piru migkahi si Hisus, “Nakataha ke naa ke hentew ka iney wey me suled ku?” ");
INSERT INTO mbtNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne dutu, impaninuru din e ka me hibateen din te migkahi, “Seini ka iney ku wey me suled ku! ");
INSERT INTO mbtNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Su ka minsan hentew ne eggimu te igkeupii te Amey ku ne diye te langit, iyan sika ka iney ku, ka suled ku, wey ka atebey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te seeye ded ne aldew, miglihawang si Hisus diye te baley wey migpinpinnuu diye te ilis te lanew. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne due susuluhi ne etew ne miglibulung diye te kandin, ne seeye naa, mig-untud e sikandin te balangey wey diyad e migpinnuu. Ne diye nanasindeg ka me etew te ilis te lanew. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Masulug ka impanulu ni Hisus diye te me etew ne impabaye din te me panunggilingan. Migkahi sikandin, “Due sabeka ne etew ne miggendiye te kamet eyew egpamula. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te pegpanawed din e te beni, due nakasawed diye te dalan, ne migginguma ka me manuk-manuk wey impanuktuk e seeye. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ne ka duma ne beni, diye nakasawed te batuwen ne ware amana tane. Ne mahaan de seeye migtubu su manipis ka tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piru te naaldawan e, nahangu e seeye su ware nakareralid. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Due degma beni ne diye nakasawed te duhiyen. Ne nanubu ka me duhi wey naselung e ka me pinamula. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka duma ne beni, diye nakasawed te meupiya ne tane. Intubu seeye wey migbebehas, ne due duma ne beni ne migbebehas te sabeka ne gatus (100), due duma ne me keen-eman ne pulu (60), wey due degma migbebehas te me tatelu ne pulu (30). ");
INSERT INTO mbtNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Purisu, ke egkeupian ka ne egpakasabut, sumsumana nu ay-ayari ke nekey ka narineg nu!” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ne migparani diye te ki Hisus ka me hibateen din wey mig-inse kandin, “Mania te eggamit ka te me panunggilingan ke egpanulu ka te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ne migtabak si Hisus, “Impatahe e diye te kaniyu ka inggeles meyitenged te Peghari te Manama, piru ware sika ipataha diye te duma. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Su seeye se due katuenan, egtimulan pad eyew egdakel ka katuenan; piru seeye se deisek de se katuenan, eg-angayen pad iya minsan ka deisek ne kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sikan naa ka miggamit a te panunggilingan te pegpanulu ku kandan, su eyew ke egtengteng sikandan, kene egpakakita, wey ke egpammineg sikandan, kene egpakarineg wey egpakasabut. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne natuman e diye te kandan ka ingkahi te Manama pinaahi ki prupita Isayas ne eggenendue, ‘Minsan egmenuwen niyu te egpammineg, kene kew iya egpakasabut. Minsan egmenuwen niyu te egtengteng, kene kew iya egpakakita. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Su memakehal ka ulu te seini ne me etew, insagpengan dan ka talinga ran, wey impileng dan ka mata ran. Su kema ke egpakakita sikandan, wey egpakarineg, wey egpakasabut, wey eglibed kayi te keddi, ne egbawian ku sikandan.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Piru keupianan niyu su egpakakita ka mata niyu wey egpakarineg ka talinga niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Egnangenan ku sikaniyu te malehet: masulug ka me prupita wey matareng ne me etew ne egkeupian perem ne egkita te nakita niyu, piru ware sikandan nakakita. Egkeupian degma sikandan ne egdineg te narineg niyu, piru ware sikandan nakarineg. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sikan naa, pamineha niyu ke nekey ka kaluwasan te panunggilingan meyitenged te pegpamula. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka beni ne nakasawed diye te dalan, iyan seeye se etew ne nakarineg te lalag meyitenged te Peghari te Manama piru ware sikandin nakasabut. Te pegginguma ni Meibulan in-ahew e ka lalag te Manama ne nakapamula diye te pusung din. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne ka beni ne diye nakasawed te batuwen, egpekeiling te seeye se etew ne nakarineg te lalag te Manama ne due-rue ne migdawat kayi ne nahale. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piru ware seini nakareralid diye te pusung din, purisu ware de naluhey ka pegpalintutuu rin. Pegginguma te keyirapan wey pegbayad-bayad tenged te pegdawat din te lalag te Manama, due-rue ne mig-engked sikandin te pegpalintutuu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne ka beni ne nakasawed diye te duhiyen, iyan seeye se etew ne nakarineg te lalag te Manama, piru ka pegkalaggew rin meyitenged te peg-ugpe din, wey ka peggeyinawa te me karatuan din iyan nekeumes te lalag te Manama, wey ware sikandin nakabebehas. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Piru ka beni ne nakasawed diye te meupiya ne tane, iyan seeye se etew ne nakarineg te lalag te Manama wey nakasabut kayi. Ne migbebehas sikandin: due behas din ne sabeka ne gatus (100), ka duma hen-em ne pulu (60), wey ka duma tatelu ne pulu (30).” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mig-abey e man-e migpanulu si Hisus te me etew pinaahi te panunggilingan ne migkahi, “Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te etew ne migsawed te meupiya ne beni diye te kamet din. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Piru te nenewulep e ka me etew, miggingume e ka kuntere din wey insewuhan e saweri te behas te hilamunen ka beni ne insawed diye te kamet wey pegkapenga, mig-awe e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hengkayi te migtubu e ka me pinamula wey te migbebehas e, human pad neileyi ka me hilamunen. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ne nangendiye te kamuney te kamet ka me uripen din wey migkahi, ‘Ahalen, hendei egpuun ka me hilamunen ne nanubu diye te kamet te meupiya ma ka me beni ne insawed nu?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Migtabak ka ahalen diye te kandan, ‘Hinimuwan sika te kuntere ku.’ Ne mig-inse ka me uripen din, ‘Na, egkeupian ke naa ne eggendiye key eyew egpamarut te me hilamunen?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ne migtabak sikandin, ‘Kene kew, su kema ke igpakalagkes niyu te egbarut ka me pinamula. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Balahara niyu re due taman te tinggaani e su igpewun-a ku re igpabarut te me talaggaani ka me hilamunen, wey igpabagkes kandan eyew egsilaban. Pegkapenga, igpalimud ku diye te lelapeng ku ka egkahaani ran.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nataman, migpanulu e man-e si Hisus te me etew te lein ne panunggilingan ne miggenendue, “Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te beni te mustasa ne impamula te etew diye te kamet din. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka beni te mustasa ka mallilintek te langun ne me beni, piru egkeyimu ne pinakarakel te me pinamula diye te kamet ke egdakel e seini. Ne egkataman, egpekeiling e te kayu wey egsesalahan e te me manuk-manuk ka me sugpang din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne mig-abey e man-e si Hisus migpanulu kandan te panunggilingan ne miggenendue, “Ka Peghari te Manama egpekeiling te igpatulin te paan ne in-angey te sabeka ne malitan wey insewug din te harina ne egliware te saku, taman te migtulin ka langun ne innimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Impabaye ni Hisus te me panunggilingan seeye se langun ne impanulu din te masulug ne me etew. Ne ware inlalag din diye te kandan ne ware din ipabaye te panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Neyitabu seini eyew egkatuman ka ingkahi te Manama pinaahi te prupita ne miggenendue, “Eggamit a te me panunggilingan ke eglalag a, igguhud ku ka ware pad nanengnengi puun te peggimu te kalibutan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nataman, mig-engkeran e ni Hisus ka masulug ne me etew wey migseled sikandin diye te baley. Ne migparani diye te kandin ka me hibateen din wey migkahi, “Ne la, ipasabut nu kanami ke nekey ka kaluwasan te panunggilingan meyitenged te hilamunen diye te kamet.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ne migtabak si Hisus, “Ka etew ne migsawed te meupiya ne beni, iyan sika ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ne ka kamet, iyan sika ka kalibutan, ne ka meupiya ne beni iyan ka me etew ne sakup te Peghari te Manama. Piru ka me hilamunen, iyan ka me sakup te ahalen te me busew, ");
INSERT INTO mbtNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ka kuntere ne iyan migsawed te me hilamunen. Ka tinggaani, iyan sika ka katammanan te timpu, ne ka talaggaani, iyan ka me panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ne egbaruten wey egsilaban ka hilamunen, iling naan ded due ka egkeyitabu te katammanan te timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Egpeuyan ka Anak te Etew te me panalihan din eyew igmaawe diye te Migharian din ka langun ne iyan egpuunan ne egpakasale ka duma wey ka langun ne eggimu te mareet. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne igdegpak dan sikandan diye te hapuy ne egkanlabkanlab. Ne diye, egmandalawit sikandan wey egmegkihet te ngipen dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ne seeye se me matareng, eglayag iling te aldew diye te Migharian te Amey ran. Purisu, ke egkeupian ka ne egpakasabut, sumsumana nu ay-ayari ka egkarineg nu! ");
INSERT INTO mbtNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ka Peghari te Manama egpekeiling degma te pangguhuren meyitenged te karatuan ne inggeles diye te kamet ne nakita te sabeka ne etew. Migweil-weil ka etew, imbunbunan din ded man-e seeye. Ne puun te kahale din, mig-ayun e sikandin ka migbelegye te langun ne diye te kandin wey imbeli rin e seeye se kamet. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ka Peghari te Manama egpekeiling man-e te pangguhuren meyitenged te sabeka ne nigusyanti ne egpammitew te mateles wey mahal ne balieg ne egngaranan te pirlas. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te nakakite e sikandin te amana ne mahal ne pirlas, imbelegye din e ka langun ne diye te kandin wey imbeli rin e seeye se pirlas. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ka Peghari te Manama egpekeiling degma te pangguhuren meyitenged te pukut ne in-antug diye te lanew ne migsaharan te nalein-lein ne me ngalap. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ne emun ke egkapenu e te ngalap ka biyale, egganuyen e sika te mangngengalap diye te ilis. Egkataman, egpaminnuu e sikandan eyew te pegpangalam te me ngalap. Ne igtahu dan diye te selaan ka meupiya ne me ngalap, piru igpandegpak dan mule ka maddeet. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iling naan ded degma kayi ka egkeyitabu te katammanan te timpu. Eggendini ka me panalihan te Manama wey igpasuwey ran ka me maddeet ne me etew puun te me matareng. ");
INSERT INTO mbtNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne seeye se me etew ne maddeet, igdegpak diye te hapuy ne egkanlabkanlab. Ne diye, egmandalawit sikandan wey egmegkihet te ngipen dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ne mig-insaan ni Hisus sikandan, “Nasabut niyu red ka langun ne impangguhud ku?” Migtabak sikandan, “Uya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Migkahiyan ni Hisus sikandan, “Purisu ka langun ne me talagpanulu te Balaud te Manama ne due katuenan meyitenged te Peghari te Manama, egpekeiling te kamuney te baley ne mig-angey te iyam wey tapey ne me kasangkapan din ne mahal.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te pegkapenga ni Hisus te pegpangguhud te sika ne me panunggilingan, mig-awe e sikandin te seeye ne inged, ");
INSERT INTO mbtNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wey mig-uli e diye te lungsud ne intulinan din. Ne migpanulu sikandin diye te simbaan te me Hudiyu, wey neinu-inu ka nakarineg kandin wey migkahi, “Hendei buwa nakakuwa sikandin te katuenan wey geem te peggimu te kein-inuwan? ");
INSERT INTO mbtNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kene naa ne anak te talagbebaley sika? Kene naa ne si Mariya ka iney rin, wey kene naa ne ensi Santiyagu, si Husi, si Simun wey si Hudas ka me suled din? ");
INSERT INTO mbtNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kayi ma mule nangugpe ka me atebey rin? Purisu hendei rin naa nakuwa ka langun?” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sikan naa natameneng e sikandan kandin. Piru migkahiyan sikandan ni Hisus, “Egtahuren ka sabeka ne prupita te minsan hendei gawas te inged ne intulinan din wey te pamilya rin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Purisu kene ne masulug ka me kein-inuwan ne innimu ni Hisus te seeye ne inged tenged su ware sikandan migpalintutuu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Te seeye ne timpu, si Hirudis ka migmandu te Galiliya. Te pegkarineg din te guhuren meyitenged ki Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","migkahiyan din e ka me suluhuanen din, “Sikandin iya si Huwan ne Talagbewutismu, neuyag ded sikandin! Sika ka egpuunan ne due geem din te peggimu te me kein-inuwan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Su si Hirudis ka migparakep wey migpaprisu ki Huwan. Innimu ni Hirudis seeye su insaparan sikandin ni Huwan te peg-ahew ki Hirudiyas ne asawa te suled din ne si Pilipi. Miggenendue si Huwan, “Supak te Balaud ni Muwisis ne eg-ahawen nu ka ipag nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Egkeupian perem si Hirudis ne eggimatayan si Huwan, piru naaldek sikandin te me Hudiyu su in-ila ran ne sabeka ne prupita si Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Piru te aldew te neetawan ni Hirudis, migsayew ka beyi ne anak ni Hirudiyas diye te tangkaan te me mahaliyug, wey nahale si Hirudis kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Seeye naa, migpahunlibet sikandin ne migsaad diye te beyi ne igbehey rin ka minsan nekey ne egbuyuen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ne dutu, impanulu e ni Hirudiyas ka anak din te egkahi diye te ki Hirudis, “Ibehey nu keddi kuntee ka ulu ni Huwan ne Talagbewutismu ne diye igtahu te maluag ne pinggan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amana ne nalaggew si Hirudis dutu. Piru tenged su nakapahunlibet e sikandin wey narineg seeye te me mahaliyug din, migsuhu e sikandin ne igbehey te beyi ka imbuyu din. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Purisu impatempuhan din e si Huwan te ulu diye te prisuwan. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nataman, in-uuyan e diye te beyi ka ulu ni Huwan ne diye itahu te maluag ne pinggan wey imbehey rin e degma diye te iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ne nangingume e ka me hibateen ni Huwan wey in-angey ran e ka lawa rin wey inlelebeng dan e. Pegkapenga dutu, innendiyaan dan e si Hisus wey impangguhuran dan e te neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te pegkarineg ni Hisus te neyitabu, mig-awe e sikandin dutu wey mig-untud e te balangey ne migsabsabeka peendiye te mammara ne inged ne kene egkeugpaan. Te pegkarineg degma te masulug ne me etew te mig-awe e si Hisus, mig-engkeran dan e ka me lungsud dan wey miglurug e sikandan te lanew ka egsundul kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te peglegsad ni Hisus te balangey, nakita rin ka masulug ne etew. Ne dutu, neyid-u e sikandin kandan wey impamawian din e ka migmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ne hengkayi te egkasagkup e, migparani kandin ka me hibateen din ne migkahi, “Kema, peendiyaa nu pa ka masulug ne me etew te me bariyu su egpabeliyen te egkakeen dan su egkasagkup man e seini ne kayi ki mem pa te mammara ne inged ne kene egkeugpaan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Piru migkahi si Hisus, “Kene ne keilangan ne egpeyipanawen pad sikandan. Sikaniyu ka egbehey kandan te egkakeen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ne migtabak sikandan, “Nekegmenu naan de iya ka kayi te kanami ne lallalimma ne paan wey daddaruwa ne ngalap te weyig.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne migkahi si Hisus, “Uyana niyu kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nataman, impapinnuu rin e ka masulug ne me etew diye te me hilamunen. Ne ingkuwa rin e seeye se lalimma ne malisen ne paan wey ka daruwa ne ngalap, ne migleng-ag sikandin diye te langit ne migpasalamat te Manama. Nataman, impanepik-tepik din e ka me paan wey impamehey rin e diye te me hibateen din, ne sikandan e ka migpamehey diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ne nangeen sikandan langun wey nenabulung-bulung, wey nakalimud pad sikandan te sapulu wey daruwa (12) ne liyang ne napenu te same dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne seeye se nangeen, migginguma te lalimma ne libu (5,000) ne etew ne ware pad labet te me malitan wey me bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pegkapenga dutu, impeuntud e ni Hisus ka me hibateen din te balangey wey impewun-a rin e ipalapas diye te deyipag te lanew, taheed te impeuli din pad ka masulug ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ne hengkayi te impakapeuli din e sikandan, migtakereg e degma sikandin diye te bubungan ne migsabsabeka eyew te peg-ampu. Ne narusileman e sikandin diye se sabsabeka. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te seeye ne timpu, nekeelat-elat e te lanew ka balangey ne in-unturan te me hibateen din wey amana ne masumpit ka me bunlud su egkasinug-ung dan ka kalamag. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hengkayi te egpamalat-palat pad, innendiyaan e sikandan ni Hisus ne miggipanew diye te kulit te weyig. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Piru te pegkakita te me hibateen din kandin ne miggipanew diye te weyig, naalatan sikandan ne migkahi, “Keyyey, due saping!” Ne migmanguleyi e sikandan te kaaldek dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ne due-rue ne migkahi si Hisus, “Pakannekal kew! Kene kew kaaldek su sikeddiey seini!” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ne migtabak si Pidru kandin, “Magbebaye, ke sikeykew ma sika, peyipanawa a te weyig peendue te keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ne migkahi si Hisus, “Na, hendini ka!” Purisu miglegsad si Pidru diye te balangey wey miggipanew diye te weyig peendiye te ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piru te pegkasahinda rin te makeseg ne kalamag, naaldek e sikandin wey egkabunsuran e egkatanled. Ne migbalbalukan sikandin ka migkahi, “Magbebaye, luwasa a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sahuhune ne inggen-genan sikandin ni Hisus wey ingganuy wey migkahiyan, “Deisek ka pegpalintutuu nu keddi, mania te migduwa-ruwa ka?” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te nekeuntud e sikandan se daruwa diye te balangey, mig-engked e ka kalamag. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne insimba sikandin te me hibateen ne diye te balangey ne miggenendue, “Malehet iya ne sikeykew ka Anak te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Te nakalapas e sikandan, diye sikandan nakatuhun te inged ne egngaranan te Ginisarit. ");
INSERT INTO mbtNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne hengkayi te nekeile e ki Hisus ka me mahinged dutu, impataha ran e ka sumbaley ran ne me inged te due sikandin. Ne dutu, impanguyan e te me etew diye te kandin ka langun ne egmanderalu ");
INSERT INTO mbtNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","wey migpeyid-u-hid-u sikandan ki Hisus ne egpasamsamen sikandan minsan te sidsid de te kumbale din. Ne ka langun ne nakasamsam dutu, neulian iya. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nataman, due me Parisiyu wey me talagpanulu te Balaud te Manama ne diye egpuun te Hirusalim ne miggendiye te ki Hisus wey mig-inse, ");
INSERT INTO mbtNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mania te insupak te me hibateen nu ka tuluuwen te me kaap-apuan ta? Su ware sikandan mig-ayad-ayad migpanlu-lu te belad dan te ware pad migkeen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ne migtabak si Hisus, “Ne mania degma te insupak niyu ka me suhu te Manama tenged te peg-ikul niyu te kaniyu ne tuluuwen? ");
INSERT INTO mbtNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Su migsuhu ka Manama ne migkahi, ‘Tahura nu ka amey wey iney nu,’ wey ‘Ka minsan hentew ne egtampele te amey wey iney rin, keilangan ne eggimatayan iya sikandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piru migpanulu kew ne ka minsan hentew ne egkahi diye te amey wey iney rin, ‘Imbehey ku diye te Manama ka igkabulig ku perem kaniyu,’ ");
INSERT INTO mbtNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ne kenad e ne keilangan ne egtahud pad sikandin kandan. Puun due innimu niyu ne ware karuan te lalag te Manama, pinaahi te peg-ikul niyu te tuluuwen niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikaniyu se egpapitew-pitew re! Malehet ka intagne ni prupita Isayas meyitenged kaniyu ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Diye de egpuun te me be-be te seini ne me etew ka pegtahud dan keddi, piru mariyu ka pusung dan keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ware karuan te pegsimba ran keddiey, su iyan dan igpanulu ka me balaud ne innimu re te me etew isip kun Balaud ku.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ne impeumew ni Hisus ka me etew wey migkahiyan, “Pammineg kew wey sabuta niyu ka iglalag ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kene ne iyan egpakamalindit te etew ka egseled diye te be-be din, ke kene, iyan seeye se eglihawang diye te be-be din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nataman, migparani diye te kandin ka me hibateen din wey migkahi, “Nakanengneng ka ne natameneng ka me Parisiyu te pegkarineg dan te inlalag nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Piru migtabak si Hisus, “Ka langun ne pinamula ne ware ipamula te Amey ku ne diye te langit, egbaruten. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Balahara niyu re due sikandan se me butud ne egkitkit te me butud. Ne emun ke egkitkiten te sabeka ne butud ka lein ne butud, egkengeulug iya sikandan diye te lungag.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ne migkahiyan sikandin ni Pidru, “Pangguhuri key ke nekey ka kaluwasan te sika ne panunggilingan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ne migkahi si Hisus, “Ware kew bes pad degma nakasabut? ");
INSERT INTO mbtNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ware kew bes nakataha te ka minsan nekey ne egkaabeleng te etew, egleus diye te getek din ne egkataman, eglihawang ded diye te lawa rin? ");
INSERT INTO mbtNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piru ka minsan nekey ne eglihawang diye te be-be te etew, diye seeye egpuun te pusung din, ne sika ka egpakamalindit kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Su diye egpuun te pusung te etew ka mareet ne suman-suman, ka peggimatey, ka pegpanlibug, ka pegpeyilabetey ne kene ne alunggun, ka pegpanakew, ka peg-uubat, wey ka peg-iran-iran te duma. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sika ka egpakamalindit te etew. Piru kene egpakamalindit te etew ka egkeen ne kene eg-ayad-ayad egpanlu-lu te belad.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nataman, mig-awe e si Hisus te seeye ne inged wey miggendiyad e te me inged ne sakup te Tiru wey Sidun. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne due malitan ne matig-Kanaan ne mig-ugpe te seeye ne inged. Ne migparani sikandin ki Hisus ne migbalbalukan ne migkahi, “Magbebaye, kabuhalan ni Dabid, ikeyid-u a nikeykew! Amana ne masumpit ka egkeula-ula kuntee te anak ku ne malitan ne migserepan te busew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piru warad en iya migtabak si Hisus. Ne migparani diye te kandin ka me hibateen din wey mighangyu kandin ne migkahi, “Paawaa nu sika se malitan, su egbalbalukan sikandin ka egsinsinundul kanta!” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne migtabak si Hisus, “Diye e re ipeuyan te kabuhalan ni Israil ne nekeiling te me karniru ne nallaag.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piru migparani ka malitan wey migpanimbuel diye te tangkaan ni Hisus ne migkahi, “Bulihi a nikeykew, Magbebaye!” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Piru migkahi si Hisus, “Kene ne meupiya ne egkuen ka keenen te me bate wey igsunggud diye te me asu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne migtabak ka malitan, “Malehet sika Magbebaye, piru minsan ka me asu egpakakeen ma degma te me mummu ne egkengatahak puun te lamisa te me ahalen dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ne migtabak si Hisus kandin, “Mengeatebey, amana ne dakel ka pegpalintutuu nu! Purisu egkarawat nu ka egbuyuen nu.” Ne neulian e ka anak din te seeye de ne uras. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ne mig-awe si Hisus dutu wey miggendiyad e te ilis te Lanew te Galiliya. Nataman, migtakereg e sikandin diye te bubungan wey diye migpinpinnuu. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne due amana ne susuluhi ne etew ne migparani kandin ne nanguyan te me pungku, me butud, me nabalbalangan se lawa, me ummew, wey masulug pad ka duma ne migmanderalu. Ne diye dan seeye ipanahu te katangkaan ni Hisus, wey impamawian din sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne dutu neinu-inu ka me etew te pegkakita ran ne egmakalalag e ka me ummew, neneulian e ka me nabalbalangan se me lawa, nenekeyipanew e ka me pungku, wey egmakakite e ka me butud. Ne insaye dan e ka Manama te Israil. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ne in-umew ni Hisus ka me hibateen din wey migkahiyan, “Neyid-u a te me etew su natateluwan e sikandan ka egduma-ruma keddi ne warad e egmangeenen. Kena a egkeupian ne igpeuli ku sikandan ne egmanggutasan su kema ke egkengalepu sikandan diye te deralanen.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ne migkahi ka me hibateen din, “Etuwey, kayi ki pe ma te mammara ne inged ne kene egkeugpaan! Hendei ki naan de iya egkuwa te egkakeen ne igpakeen te seini se susuluhi ne etew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ne mig-inse si Hisus diye te kandan, “Pilaa ne timman ka paan ne due te kaniyu?” Ne migtabak sikandan, “Pitu ne timman, wey due pila-pila re ne ngalap te weyig.” ");
INSERT INTO mbtNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne impapinnuu e ni Hisus ka me etew diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne ingkuwa rin ka pitu ne paan wey ka me ngalap wey migpasalamat diye te Manama. Pegkapenga dutu, impanepik-tepik din e seini wey impamehey rin e diye te me hibateen din. Ne impangatul e degma impamehey te me hibateen din diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ne nangeen sikandan langun wey nenabbulung-bulung. Pegkapenga rue, duen pad nalimud te me hibateen din ne pitu ne liyang ne napenu te nasame ne keenen. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Migginguma te hep-at ne libu (4,000) ka me lukes ne nangeen ne ware pad labet te me malitan wey te me bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pegkapenga dutu, impeuli e ni Hisus ka me etew wey mig-untud e sikandin te balangey ne miggendiye te inged ne Magadan. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Due me Parisiyu wey me Sadusiyu ne migparani ki Hisus. Migbuyu sikandan ne egpapitawen te kein-inuwan ne egpuun te langit eyew te peg-eleg-eleg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Migkahiyan ni Hisus sikandan, “Emun ke egkasagkup e, egkahi kew e, ‘Meupiya ne aldew kaaselem su malalab ka langit.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te pegkamaselem e, egkahi kew e man-e, ‘Eg-uran naa kuntee su malalab ka langit wey egpaddusilem.’ Egpakasabut kew te palinneu diye te langit, piru kene kew egpakasabut te me palinneu te Manama kuntee! ");
INSERT INTO mbtNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ka me etew te kuntee ne timpu, amana ne mareet wey kenad ne maparuma-ruma te Manama. Migbuyu sikandan te kein-inuwan piru ware igpakita kandan angin e te kein-inuwan ne neyitabu ki Hunas ne sabeka ne prupita.” Nataman, mig-awe e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nakatuhun e ka me hibateen ni Hisus diye te deyipag te lanew, piru nalingew sikandan ne eg-uyan te paan. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Migkahiyan ni Hisus sikandan, “Tanud-tanud kew wey bantey kew te igpatulin te paan te me Parisiyu wey te me Sadusiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Piru migpalalahey ka me hibateen din ne migkahi, “Nalalag din sika su ware ki nekeuyan te paan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Piru nanengnengan ni Hisus ke nekey ka igkewengete dan, purisu migkahiyan din sikandan, “Sikaniyu se deisek se pegpalintutuu! Mania te egkasasew kew te pegkalingew niyu te egkakeen? ");
INSERT INTO mbtNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ware kew bes pad nakasabut? Ware niyu nasuman-suman ka lalimma ne timman ne paan ne impakeen ku te lalimma ne libu (5,000) ne etew ne nakalimud kew pad te sapulu wey daruwa (12) ne liyang te nenasame? ");
INSERT INTO mbtNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ware niyud e man-e nasuman-suman seeye se pitu ne timman ne paan ne impakeen ku te hep-at ne libu (4,000) ne etew ne nakalimud kew pad te pitu ne liyang te nenasame? ");
INSERT INTO mbtNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ware kew bes nakasabut te kene ne paan ka igpasabut te ingkahi ku ne, ‘Tanud-tanud kew te igpatulin te paan te me Parisiyu wey te me Sadusiyu’?” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ne henduen pad nakasabut sikandan ne kene bes ne patulin te paan ka egpatantanuran kandan, ke kene, ka pegpanulu bes te me Parisiyu wey te me Sadusiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nataman, te diyad e si Hisus te inged te Sisarya Pilipus, mig-insaan din ka me hibateen din ne migkahi, “Hentew kun naa ka Anak te Etew sumale te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ne migtabak sikandan, “Ka duma migkahi ne si Huwan kun ne Talagbewutismu. Ne due duma ne migkahi ne si Ilyas kun. Ne ka duma degma migkahi ne si Hirimiyas kun, wey ke sabeka naa sikandin te me prupita.” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mig-inse si Hisus kandan, “Piru ke sikaniyu ka egpalalahen, hentew e naa iya?” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ne migtabak si Pidru, “Sikeykew iya ka Kristu, ka Anak te manekal ne Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ne migkahiyan sikandin ni Hisus, “Keupianan nu Simun ne anak ni Hunas, su kene ne etew ka migpataha keykew kayi, ke kene, ka Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sikan naa, egnangenan ku sikeykew Pidru te iling ka te batu. Te sika ne batu, duen ku igpasasindeg ka punduk te migmalintutuu keddi wey minsan ka geem te kamatayen kene egpakadereet. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne igbehey ku keykew ka me yabi diye te Migharian te Manama, ne ka minsan nekey ne ingkene nu kayi te ampew te tane, ingkene degma diye te langit. Ne ka minsan nekey ne intuhut nu kayi te ampew te tane, intuhut degma diye te langit.” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nataman, impegpehetan e panpanayi ni Hisus ka me hibateen din ne kene egpepanugtulen te minsan hentew ne sikandin ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Puun te seeye ne timpu, impasabut e ni Hisus ka me hibateen din ne keilangan ne eggendiye sikandin te Hirusalim wey eg-antus te igmeulaula kandin te me igbuyag te me Hudiyu, te me pangulu te me talagpanubad, wey te me talagpanulu te Balaud te Manama. Eggimatayan sikandin wey egkeuyag te igkatelu ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ne migweil-weil si Pidru, impasuwey rin e si Hisus wey insaparan din te migkahi, “Suwang-suwang! Magbebaye, kene egkaayun ne egkeyitabu sika due te keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Piru migbalikid si Hisus wey migkahiyan si Pidru, “Awe ka rue Meibulan! Egpakabalabag ka keddiey; su kene ne Manama ka indapihan nu, ke kene, ka me etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nataman, migkahiyan e ni Hisus ka me hibateen din, “Ke hentew seeye se eg-ikul keddi, keilangan ne eg-engked te kandin ne igkeupii wey egtiang te kandin ne krus wey eg-ikul keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Su seeye se egkeupian ne egluwas te kandin ne umul, nasi egkawaraan kayi, piru seeye se egkawaraan te kandin ne umul tenged keddiey, egpakarawat te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nekey ma ka egkakuwa te etew ke egkaangken din ka langun ne tahu kayi te ampew te tane piru egkaware ka umul rin? Ware iya! Su ware igkabehey rin eyew egkaawi din ka kandin ne umul. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Su egginguma ka Anak te Etew ne egdumaan te katelesan te Amey rin, ne iyan din duma ka me panalihan din. Ne egkataman eg-unahan din e ka tagse sabeka ne etew sumale te himu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Egnangenan ku sikaniyu te malehet: due me etew ne kayi kuntee ne kene pad egpatey taman te kene dan pad egkakita ka Anak te Etew ne egginguma isip Hari.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Peglihad te hen-em ne aldew, induma ni Hisus si Pidru wey ka talaari ne si Santiyagu wey si Huwan te migmatakereg diye te matikang ne bubungan ne sikandan de. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne dutu, nabalbalawan ka ulaula ni Hisus wey migsiha ka ulaula rin iling te aldew, wey miglayag te kaangkag ka kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne sahuhune ne migpakita diye te kandan ensi Muwisis wey Ilyas wey migpakiglalag kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ne migkahiyan ni Pidru si Hisus, “Magbebaye, meupiya te kayi key kuntee. Ke igkeupii nu eggimu a kayi te tatelu ne leeb, sabeka ka keykew, sabeka ka ki Muwisis wey sabeka ka ki Ilyas.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te sasangan pad sikandin ne eglalag, due malayag ne gapun ne migdalung kandan wey due laheng ne egpuun dutu te gapun ne migkahi, “Seini ka pinalangge ku ne Anak ne ingkahale ku. Pamineha niyu sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te pegkarineg dutu te me hibateen din, naaldek e sikandan wey miglangkeb e diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Piru migparani si Hisus wey miggen-genan din sikandan te migkahi, “Sasindeg kew wey kene kew kaaldek.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pegtenggak dan, si Hisus naan de ka nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Taheed te egmatupang e sikandan te bubungan, inteesan e sikandan ni Hisus te migkahi, “Kene niyu ipangguhud te minsan hentew ke nekey ka nakita niyu taman te egkeuyag e ka Anak te Etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ne mig-inse ki Hisus ka me hibateen din, “Mania te migkahi ka me talagpanulu te Balaud te Manama ne keilangan ne iyan eggun-a ki Kristu eggendini si Ilyas?” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Migtabak si Hisus, “Uya iya, eggun-a eggendini si Ilyas eyew te peg-ayad-ayad te langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piru egnangenan ku sikaniyu te miggendinid e si Ilyas, piru ware nekeila ka me etew kandin wey nasi dan himuwa diye te kandin ka minsan nekey ne igkeupii ran. Ne iling naan ded degma rue, egbaybayaran dan ded degma ka Anak te Etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ne henduen pad nasabut te me hibateen ni Hisus te si Huwan bes ne Talagbewutismu ka egkahiyen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te pegginguma ran diye te susuluhi ne etew, due lukes ne migparani ki Hisus wey migpanimbuel diye te tangkaan din ");
INSERT INTO mbtNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ne migkahi, “Magbebaye, ikeyid-u nu ka anak ku ne lukes su egbabuyen sikandin wey amana egkabaybayari. Malasi sikandin egpakasubbuk diye te hapuy wey diye te weyig. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","In-uyan kud e sikandin diye te me hibateen nu, piru ware sikandan nakabawi kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ne migkahi si Hisus, “Sikaniyu se me etew te kuntee ne timpu, ware pegpalintutuu niyu wey mareet ka suman-suman niyu wey ka hinimuwan niyu! Hendei bes taman ka pegduma-ruma ku kaniyu? Hendei bes taman ka peg-antus ku kaniyu? Uyana niyu ka bate kayi te keddi!” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ne dutu in-alew e ni Hisus ka busew ne migserep te bate wey te sikan de, neulian e ka bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ne dutu, migparani ki Hisus ka me hibateen din te sikandan de wey mig-inse, “Mania te ware key nakaalew te busew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ne migtabak si Hisus diye te kandan, “Iyan igkeenduena su deisek ka pegpalintutuu niyu. Egnangenan ku sikaniyu te malehet: ke due pegpalintutuu niyu minsan iling kareisek te behas te mustasa, egpakasuhu kew te seini ne bubungan, ‘Halin ka diye!’ wey eggalin iya seini wey ware minsan nekey ne kene niyu egkeyimu!” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Due timpu ne nanlibulung ka me hibateen ni Hisus diye te Galiliya. Ne dutu, migkahiyan e man-e sikandan ni Hisus, “Mahaan e eg-akali ka Anak te Etew wey igbehey diye te me etew ");
INSERT INTO mbtNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne eggimatey kandin, piru egkeuyag sikandin te igkatelu ne aldew.” Ne puun dutu, nalaggew e amana ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te pegginguma enni Hisus diye te Kapirnaum, migparani diye te ki Pidru ka me talagsukut te buhis para te timplu wey mig-inse kandin, “Egbayad naan ded te buhis para te timplu ka talagpanulu niyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Migtabak si Pidru, “Ew red.” Te pegseled ni Pidru diye te baley, migpewun-a mig-inse si Hisus kandin ne migkahi, “Simun, nekey-a te keykew ne suman-suman, hentew-a ka egpabayaren te me Hari kayi te inged te buhis wey te duma pad ne bayaranan? Ka me mahinged naa wey ke me lapu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ne migtabak si Pidru, “Ka me lapu.” Migkahiyan ni Hisus sikandin, “Ke iling ma rue, kene ne keilangan ne egpabayaren ka me mahinged. ");
INSERT INTO mbtNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piru ke kene ki egbayad, kema ke egkatameneng sikandan kanta. Purisu hendiye ka te lanew wey pamunuwit ka. Bekaa nu naa ka be-be te an-anayan ne ngalap ne egkeutel nu wey egkakita nu diye ka seleppi ne eleg ne igbayad te buhis ta te daruwa. Kua nu naa seeye wey ibayad nud e.” ");
INSERT INTO mbtNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Te seeye ne timpu migparani diye te ki Hisus ka me hibateen din wey mig-inse, “Hentew-a ka labew diye te Migharian te Manama?” ");
INSERT INTO mbtNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ne mig-umew si Hisus te bate wey impasasindeg din diye te taliware dan ");
INSERT INTO mbtNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","te migkahi, “Egnangenan ku sikaniyu te malehet: kene kew egpakaseled te Migharian te Manama ke kene kew egbalew-balew wey ke kene kew egpekeiling te me bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Purisu ka minsan hentew ne egpariralem eyew egpekeiling te seini ne bate, sikandin ka labew diye te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ne ka minsan hentew ne egdawat te iling kayi ne bate tenged su mig-ikul rin keddi, egdawat degma keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ka minsan hentew ne egpuunan ne egpakasale ka sabeka te seini ne me bate ne migpalintutuu wey migsalig keddi, meupiya pad ke eggiketan ka lieg din te dakel ne batu ne galingan wey igdegpak diye te pused te dahat. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mekeyid-u-hid-u ka me etew kayi te ampew te tane su layun de eggingumei te me pegtintal. Duen iya me pegtintal ne egginguma, piru mekeyid-u-hid-u ka etew ne iyan egpuunan te pegtintal. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Emun ke iyan egpuunan ka belad nu wey ke paa nu naa ne egpakasale ka, tempuha nu sika wey iregpak nu. Meupiya pad ke egseled ka diye te langit ne napungku wey ke nabalbalangan ka lawa nu du te due me belad nu wey me paa nu ne igdegpak diye te hapuy ne kene egkeebukan. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne emun ke iyan egpuunan ka mata nu ne egpakasale ka, lekata nu sika wey iregpak nu. Meupiya pad ke egseled ka diye te langit ne sabeka re ka mata du te daruwa ka mata nu ne igdegpak de diye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Tanud-tanud kew ne kene kew egpakadeeg-deeg te minsan sabeka re te seini ne me bate. Su egnangenan ku sikaniyu te ka me panalihan dan diye layun te tangkaan te Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nekey-a te suman-suman niyu ke due etew ne due mahatus (100) ne karniru rin ne natarinan te sabeka? Kene din naa eg-engkeran diye te bubungan ka siyam ne pulu wey siyam (99) eyew te pegpammitew te seeye se natarin? Eg-engkeran din iya. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne emun ke egkakita rin e seeye, egnangenan ku sikaniyu te malehet: egkahale iya sikandin. Amana rin pad igkahale sika du te seeye se siyam ne pulu wey siyam (99) ne ware natarin. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ne iling naan ded degma rue, ka Amey niyu ne diye te langit kene egkeupian ne egkatarinan te minsan sabeka re te seini ne me bate. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Emun ke egpakasale keykew ka suled nu, hendiyei nu sikandin wey nangeni nu te sale din. Piru himuwa nu sika te sikaniyu re se daruwa. Ne emun ke egpammineg sikandin keykew, egpekeg-uli ded ka meupiya ne geyinawa niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piru ke kene sikandin egpammineg keykew, duruma ka te sabeka wey ke daruwa naa ne etew su eyew ka langun ne eglalahen nu egkapamalehetan te daruwa wey ke tatelu ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piru ke kene iya sikandin egpammineg kandan, ipangguhud nud e sika diye te punduk te migmalintutuu. Ne emun ke kene pad iya man-e sikandin egpammineg kandan, isipa nu naan de sikandin ne sabeka ne etew ne ware migpalintutuu te Manama wey ke talagsukut naa te buhis. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Egnangenan ku sikaniyu te malehet: ka minsan nekey ne ingkene niyu kayi te ampew te tane, ingkene degma diye te langit. Ne ka minsan nekey ne intuhut niyu kayi te ampew te tane, intuhut degma diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Egnangenan ku man-e sikaniyu te malehet: emun ke due daruwa kaniyu kayi te ampew te tane ne egpekeg-uyun ne egbuyu te minsan nekey, eggimuwen iya sika te Amey ku ne diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Su emun ke hendei ka daruwa wey ke tatelu ne eglibulung tenged keddiey, diya a degma te taliware dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nataman, migparani si Pidru diye te ki Hisus wey mig-inse, “Magbebaye, ke layun de egpakasale kayi te keddiey ka suled ku, kapapila ku naa sikandin egpasayluwa? Kapapitu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ne migtabak si Hisus, “Kene ne kapapitu re, ke kene, pitu ne pulu wey pitu (77) ne lupi. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Sikan naa, ka Peghari te Manama egpekeiling te pangguhuren meyitenged te Hari ne egkeupian ne eggusey te me suluhuanen din ne due me utang. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te migbunsud e sikandin ka eggusey, due etew ne in-uyan diye te kandin ne nekeutang te minilyun ne seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tenged te kene sikandin egpakabayad, migsuhu ka Hari ne igbelegye e ka etew duma te asawa rin wey me anak din wey ka langun ne diye te kandin eyew egpakabayad sikandin te utang din. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ne dutu, migpanimbuel e ka suluhuanen diye te tangkaan te Hari wey migpeyid-u-hid-u ne migkahi, ‘Hari, kene e re ubag nikeykew dalaseka su egbayaran ku re sikeykew te langun!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Neyid-u ka Hari te seeye ne suluhuanen, purisu imbalahad din e ka utang din wey impeyipanew e. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Piru te peggipanew e te sika ne suluhuanen, nasinug-ung din ka duma rin ne suluhuanen ne nekeutang kandin te pila re ne libu. Inggansing din seeye se etew wey impeleng din te migkahi, ‘Bayari ad e nikeykew te utang nu!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Migpanimbuel ka duma rin ne suluhuanen wey migpeyid-u-hid-u kandin ne migkahi, ‘Kena a ubag nikeykew dalaseka su egbayaran ke re!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piru ware sikandin nabennali wey miggipanew e. Ne nasi din ipaprisu ka etew taman te egkabayaran ka utang din. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te pegkakita dutu te duma ne me suluhuanen, amana sikandan nalaggew. Seeye naa, nangendiye sikandan te Hari ka migsumbung kandin te neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Purisu impeumew te Hari seeye se suluhuanen wey migkahiyan, ‘Amana ka ne mareet ne suluhuanen! Imbalahad kud e ka langun ne utang nu tenged su migpeyid-u-hid-u ka keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne mania te ware ka neyid-u te duma nu ne nekeutang keykew iling te pegkeyid-u ku keykew?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amana nabelu ka Hari kandin, seeye naa impaprisu rin e ka suluhuanen eyew egbaybayaran taman te egkabayaran din degma ka langun ne utang din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ne migkahi si Hisus, “Iling naan ded degma ka eggimuwen diye te kaniyu te Amey ku ne diye te langit ke kene niyu egpasayluwen ne egpuun te me pusung niyu ka me duma niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pegkapenga ni Hisus te miglalag te seeye ne me panunggilingan, mig-awe e sikandin diye te Galiliya wey miggendiyad e te inged ne sakup te Hudiya ne deyipag te Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne amana ne susuluhi ka me etew ne migsinundul kandin, wey impamawian din sikandan diye. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Due nangendiye te ki Hisus ne me Parisiyu eyew te peg-eleg-eleg kandin ne mig-inse, “Intuhut naan ded te Balaud ta ne egpakig-engked ka lukes te asawa rin te minsan nekey ne egpuunan?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ne migtabak si Hisus, “Ware kew bes nakasabut te imbasa niyu diye te Kasulatan ne puun pad te an-anayan innimu e sikandan te Manama ne lukes wey malitan? ");
INSERT INTO mbtNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne migkahi pad man-e ka Manama, ‘Sika ka egpuunan ne eg-engked e ka lukes te amey wey iney rin wey egsabeke e diye te asawa rin. Ne sikandan se daruwa, egkeyimu e ne sabeka.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sikan naa, kenad e ne daruwa sikandan, ke kene, sabeka naan de. Purisu kene egkaayun ne egpeg-engkeren te etew ka insabeke e te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mig-inse e man-e ka me Parisiyu, “Piru mania te migsuhu si Muwisis ne egpabehayen ka lukes diye te asawa rin te sulat te pegpakig-engked, ne eyew egpekeengked e sikandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne intabak ni Hisus sikandan, “Intuhutan kew ni Muwisis ne egpakig-engked te me asawa niyu tenged su makehal ka me ulu niyu. Piru kene ne iling due puun pad te an-anayan. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Egnangenan ku sikaniyu, ne ka minsan hentew ne egpakig-engked te asawa rin ne malitan ne ware nakasale kandin, egpakapanlibug e sikandin ke egbalew-balew eg-asawa.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ne migkahi ka me hibateen din diye te kandin, “Ke iling ma due ka egkeula-ula te alunggun, meupiya pad ke kenad e eg-asawa.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Piru migkahiyan ni Hisus sikandan, “Kene ne langun ne etew ne egpakarawat te seini ne lalahen, ke kene, seeye de se me etew ne imbulihan te Manama kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Masulug ka egpuunan ne due me lukes ne kene eg-asawa: ka duma, kene eg-asawa puun su neetew sikandan ne kene iya egpakaanak; ka duma, kene eg-asawa puun su migpakepun sikandan; ne ka duma, egkeupian ne kene eg-asawa su eyew egkasabeka ka suman-suman dan meyitenged te Peghari te Manama. Seeye se egpakarawat kayi, egparawaten.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nataman, due me bate ne in-uuyan diye te ki Hisus eyew egpatel-eban te belad din wey eyew egpaampuan kandin. Piru insaparan sikandan te me hibateen ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ne migkahi si Hisus, “Balahara niyu re due ka me bate ne egparani keddi wey kene niyu sikandan sapari, su nasakup te Migharian te Manama ka me bate ne iling kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pegkapenga ni Hisus te pegtel-eb kandan te belad din, mig-awe e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Due kanakan ne migparani ki Hisus wey mig-inse, “Talagpanulu, nekey-a ka meupiya ne eggimuwen ku eyew egkarawat ku ka umul ne ware egtamanan?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ne migtabak si Hisus, “Mania te mig-inse ka keddi ke nekey ka meupiya? Sabeka re ka meupiya, ka Manama re. Piru ke egkeupian ka ne egpakarawat te umul ne ware egtamanan, keilangan ne egtumanen nu ka me suhu te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mig-inse ka kanakan, “Hendei rutu?” Ne migtabak si Hisus, “Kene ka himatey, kene ka panlibug, kene ka panakew, wey kene ka pamalehet te ubat. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tahura nu ka amey wey iney nu, wey geyinawei nu ka duma nu iling te peggeyinawa nu te pegkeetew nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Migtabak ka kanakan, “Intantanuran kud sika langun. Na, nekey naan pad ka duma ne eggimuwen ku?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ne migkahiyan ni Hisus sikandin, “Emun ke egkeupian ka iya ne likes diye te tangkaan te Manama, ibelegye nu ka me karatuan nu, ne ka halin ipamehey nu diye te egkengaayu-ayu, eyew due karatuan nu diye te langit. Ne egkataman, libed ka kayi wey ikul ka keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te pegkarineg dutu te kanakan, miggipanew e sikandin ne miglungku tenged su dakel ka karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sikan naa, migkahiyan ni Hisus ka me hibateen din, “Egnangenan ku sikaniyu te malehet: malised te meyaman ka pegseled diye te Migharian te Manama! ");
INSERT INTO mbtNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Egnangenan ku man-e sikaniyu te malemu pad ka pegserep te ayam ne kamilyu diye te lungag te simat du te pegseled te meyaman diye te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te pegkarineg te me hibateen dutu, amana sikandan neinu-inu wey mig-inse, “Ke iling ma rue, hentew bes naan de ka egkaluwas?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ne migtengteng si Hisus diye te kandan wey migkahi, “Kene egkeyimu seini te etew, piru egkeyimu te Manama ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ne migkahi si Pidru, “Na, sikanami seini, mig-engkeran ney e ka langun eyew te peg-ikul keykew. Nekey naa ka egkakuwa ney rue?” ");
INSERT INTO mbtNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Migkahiyan ni Hisus sikandan, “Egnangenan ku sikaniyu te malehet: ke egkabalbalawan e seini se kalibutan, egpinnuu ka Anak te Etew diye te amana ne mateles ne trunu rin. Ne sikaniyu se mig-ikul keddi, egpakapinnuu degma diye te sapulu wey daruwa (12) ne trunu eyew te peggukum te sapulu wey daruwa (12) ne tribu te Israil. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne ka minsan hentew ne eg-engked te baley rin, me suled din, me atebey, amey wey iney rin, me anak din wey katantanaan din tenged te peg-ikul rin keddiey, egpakarawat te mahatus (100) ne lupi te seeye se neengkeran din, wey egbehayan pad sikandin te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Piru masulug ka mabantug ne kenad egmabantug, wey masulug ka kene ne mabantug ne egmabantug e.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Migkahiyan ni Hisus sikandan, “Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te kamuney te parasan ne migselem-selem migpammitew te egpatrabahuwen din diye te kamet din. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Due pila ne me etew ne nakita rin wey migpasabutey sikandan ne egbayaran din ka tagse sabeka te sabeka ne dinaryu. Pegkapenga, insuhu din e sikandan diye te kamet din eyew egpatrabahuwen e. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hengkayi te me alas nuwibi e te maselem, miggendiyad e man-e sikandin te palingki wey due me etew ne nakita rin diye ne egmanasindeg de ne ware eggimuwen, ");
INSERT INTO mbtNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","wey migkahiyan din sikandan, ‘Sikaniyu degma, hendiye kew te kamet ku wey egbayaran ku sikaniyu te eleg ne bayad.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ne nangendiyad e ka me etew. Nataman, miggipanew e man-e sikandin te me meudtu ka egpammitew te me etew wey iling ded ka innimu rin te me alas tris e te maapun. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te me alas singku e te maapun, miggipanew e man-e sikandin wey due me etew ne nakita rin ne migmanasindeg de. Ne migkahiyan din sikandan, ‘Mania te iyan niyu re egpulungan ka egmanasindeg ne ware eggimuwen te egkaapunan?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ne migtabak sikandan, ‘Uya su ware ma egpatrabahu kanami.’ Ne migkahiyan din sikandan, ‘Hendiye kew degma te kamet ku wey trabahu kew diye.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hengkayi te egkasagkup e, migkahiyan e te kamuney te parasan ka sinalihan din, ‘Umawa nud ka me trabahanti wey pamayari nud e. Hun-eyi nu seeye se namewuri wey mewuriya nud seeye se nekewun-a.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne seeye se me etew ne alas singku e te maapun nakatrabahu, impamayaran ded sikandan te tigsabeka ne dinaryu. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hengkayi se egbayaran e degma seeye se nekewun-a ne migtrabahu, isip dan ne dakel-rakel ka egkarawat dan, kunaleg te tigsabeka red degma ne dinaryu ka tagse sabeka kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te pegdawat dan dutu, migsagsahukul sikandan diye te kamuney ");
INSERT INTO mbtNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ne migkahi, ‘Senge uras de ka pegtrabahu te seini se namewuri ne me etew, ne impeiling nu ka bayad dan kanami te miglarey te aldew wey napangkag te meinit ka migbasuk!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Piru intabak te kamuney ka sabeka kandan ne migkahi, ‘Suled, ware ku limbungi sikeykew; migpasabutey ki ne egpabayad ka te sabeka ne dinaryu. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dawata nu ka bayad nu wey uli kad. Su keddiey ne igkeupii ne egbayaran ku ka namewuri te iling te imbayad ku keykew. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ware naa katenged ku ke nekey ka igkeupii ku ne eggimuwen te seleppi ku? Wey ke neimma ke re su matumpis a nahud?’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne migkahi si Hisus, “Purisu ka egkamewuri nasi egpekewun-a, wey ka egpekewun-a nasi egkamewuri.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Peggendiye enni Hisus te Hirusalim, impasuwey rin ka sapulu wey daruwa (12) ne hibateen din puun te me etew. Ne migkahiyan din sikandan te diyad e te deralanen, ");
INSERT INTO mbtNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pammineg kew! Diye ki kuntee egpabulus te Hirusalim, ne ka Anak te Etew igbehey e diye te me pangulu te me talagpanubad wey te me talagpanulu te Balaud te Manama wey eggukuman dan e sikandin te kamatayen. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ne igpeendiye dan e man-e sikandin te kene ne me Hudiyu eyew eglemetan, eglampesan, wey iglansang te krus. Piru egkeuyag sikandin te igkatelu ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nataman, miggendiye te ki Hisus ka asawa ni Sibidiyu duma te me anak din ne me lukes. Migpanimbuel sikandin su due egbuyuen diye te ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne mig-inse si Hisus diye te kandin, “Nekey-a ka igkeupii nu?” Migkahi ka malitan, “Emun ke eghari kad e, tuhuti nu ubag ne egpakapinnuu ka sabeka ne anak ku diye te igkakawanan nu wey ka sabeka diye te igkahibang nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Piru migtabak si Hisus, “Ware kew nakanengneng ke nekey ka egbuyuen niyu. Egpekeinum kew naan ded te ubab te peg-antus ne mahaan kud e eg-inuma? Ne migtabak sikandan, “Uya, egpekeinum key red.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Migkahiyan sikandan ni Hisus, “Uya, malehet ne egpekeinum kew red te ubab ku te peg-antus, piru ka meyitenged te egpapinnuuwen diye te igkakawanan ku wey diye te igkahibang ku, ware katenged ku due, su duen e intahahe te Amey ku ne egpapinnuuwen due.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te pegkarineg dutu te sapulu ne me hibateen, nabelu e sikandan te duma ran ne talaari. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Purisu impeparani sikandan ni Hisus wey migkahiyan, “Nakanengneng kew e te ka me pangulu te me etew ne kene ne me Hudiyu, impeuteng dan iya ka geem dan te pegmandu diye te me sakup dan. Ne seeye degma se dakel se katungdanan, igpapitew ran iya ka katenged dan diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piru kene niyu sika himuwa. Su ka minsan hentew due te kaniyu ne egkeupian ne egmabantug, keilangan ne egpeyimu sikandin ne suluhuanen niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne ka minsan hentew ne egkeupian ne egkeyimu ne labew kaniyu, keilangan ne egpeuripen kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ne iling naan ded degma ka Anak te Etew; ware miggendini sikandin eyew egpamakayen, ke kene, eyew egpamakey wey egpeyimatey eyew te peglekat te masulug ne etew puun te me sale dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ne hengkayi te eglihawang e sikandan diye te Hiriku, due susuluhi ne etew ne migsinundul kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne due daruwa ne etew ne butud ne naminpinnuu diye te ilis te dalan. Te pegkarineg dan ne eglihad si Hisus, migpanguleyi sikandan ne migkahi, “Magbebaye, kabuhalan ni Dabid, ikeyid-u key nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Piru insaparan sikandan te me etew ne egpeen-enengen e, piru nanasnasian de iya sikandan ka migbalbalukan ne migkahi, “Magbebaye, kabuhalan ni Dabid, ikeyid-u key nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ne migsanggel si Hisus wey in-umew rin sikandan te migkahi, “Nekey-a ka igkeupii niyu ne eggimuwen ku kaniyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ne migtabak sikandan, “Magbebaye, egkeupian key ne egpakakita!” ");
INSERT INTO mbtNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Neyid-u si Hisus kandan purisu insamsam din ka mata ran, wey due-rue ne egpakakite e sikandan. Nataman, migsinundul e sikandan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te egpakarani-rani e sikandan te Hirusalim, egpalinggumaan e sikandan te Bitpahi ne diye te Bubungan te Ulibu. Ne dutu, impewun-e e ni Hisus ka daruwa te me hibateen din ");
INSERT INTO mbtNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wey migpanagtahaan te migkahi, “Hendiye kew seeye te kewun-aan ne bariyu, ne due-rue ne due egkakita niyu ne talanati ne asnu ne inniket diye. Hekari niyu naa seeye wey uyana niyu kayi te keddi. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne emun ke due eg-inse kaniyu, kahii niyu re, ‘Ingkeilangan seini te Magbebaye,’ ne due-rue ne igpeuyan din sika kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Neyitabu seini eyew egkatuman ka ingkahi te prupita ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pangguhuri niyu ka matig-Hirusalim, ‘Eggendue te kaniyu ka Hari niyu. Mapariralemen sikandin ne eg-untud te asnu, minsan nati te asnu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nataman, nangipanew e ka me hibateen din wey intuman dan ka insuhu ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ne in-uyan dan e ka talanati ne asnu diye te ki Hisus, wey innagpiyan dan te me kumbale dan, wey mig-untud e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne due masulug ne etew ne nambebelat te me kumbale dan diye te dalan, wey ka duma nanempug te me sugpang te kayu wey intalagtag dan diye te dalan. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne migmanguleyi seeye se masulug ne me etew ne nangun-a wey naninundul ki Hisus ne migkahi, “Egdayanen ka kabuhalan ni Dabid! Egpanalanginan sikandin se impeendini te Magbebaye ne Manama kanta! Egdayanen ka Manama ne diye te dibabew te langit!” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te pegseled ni Hisus diye te siyudad te Hirusalim, newukag ka langun ne etew diye wey migkahi, “Hentew-a seini?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne migkahi sikandan, “Sikandin iya si Hisus, ka prupita ne matig-Nasarit ne sakup te Galiliya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nataman, migseled e si Hisus diye te timplu wey indeldel rin ka langun ne egmanitinda wey ka egmambebeli diye te timplu. Ne impamalintuad din ka me lamisa te egmanaliyu te seleppi, wey ka me pinnuuwan te egmameligye te me seleppati. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne migkahiyan ni Hisus sikandan, “Nasulat e diye te Kasulatan, ‘Ka baley ku egngaranan te baley ne ampuanan’; piru innimu niyud e seini ne helesanan te me takawen!” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nataman, due butud wey pungku ne migparani kandin diye te timplu wey impamawian din sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piru nabelu ka me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama te pegkakita ran te kein-inuwan ne innimu ni Hisus, wey te pegkarineg dan te me bate diye te timplu ne egmanguleyi ne eggenendue, “Egdayanen ka kabuhalan ni Dabid!” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne migkahiyan dan si Hisus, “Narineg nu ke nekey ka ingkahi ran?” Ne migtabak si Hisus, “Uya, narineg ku. Ware kew bes nakasabut te imbasa niyu diye te Kasulatan ne miggenendue, ‘Impanulu nu te pegsaye keykew ka me bate wey ka egsusu pad ne me bate’?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nataman, mig-engkeran e sikandan ni Hisus wey miglihawang e te siyudad ne migpeendiyad e sikandin te Bitanya wey diyad e miggirehe. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pegkapawe, te miglibed e si Hisus diye te Hirusalim, miggutasan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ne due nakita rin ne kayu ne iggira diye te ilis te dalan. Indugpu din seeye piru ware nakita rin ne behas su neelin de ne dewun. Ne migkahiyan din ka kayu, “Kene kad e egpakabebehas pad.” Te sikan de, nahangu e ka kayu. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te pegkakita dutu te me hibateen din, neinu-inu sikandan wey mig-inse, “Mania te due-rue ne nahangu ka kayu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ne migtabak si Hisus kandan, “Egnangenan ku sikaniyu te malehet: emun ke due pegpalintutuu niyu wey kene kew egduwa-ruwa, egpekeyimu kew iling te innimu ku te sika ne kayu. Ne kene ne sikan de, ke kene, egpakasuhu kew degma te seini ne bubungan, ‘Keenat ka wey pakaregpak ka diye te dahat’, wey egkeyitabu iya seini. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Egkarawat niyu ka minsan nekey ne egbuyuen niyu te Manama ke due pegpalintutuu niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nataman, miglibed e man-e si Hisus migseled diye te timplu. Te sasangan pad sikandin ka migpanulu, due migparani kandin ne me pangulu te me talagpanubad wey ka me igbuyag te me Hudiyu wey mig-inse, “Nekey ka katenged nu te peggimu kayi? Hentew-a ka migbehey keykew te sika ne katenged?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ne migtabak si Hisus, “Due degma inse ku kaniyu, ne emun ke egkatabak niyu seini, egnangenan ku degma sikaniyu ke nekey ka katenged ku te peggimu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hendei migpuun ka katenged ni Huwan te pegpamewutismu? Diye naa te Manama wey ke diye te me etew?” Ne migpalalahey sikandan ne migkahi, “Emun ke egkahi ki, ‘Diye migpuun te Manama,’ kema ke egkahiyan ki nikandin, ‘Na, mania te ware kew migpalintutuu ki Huwan?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piru ke egkahi ki, ‘Diye migpuun te me etew,’ egkaaldek ki te me etew kema ke nekey ka eggimuwen kanta su migpalintutuu sikandan ne prupita si Huwan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Purisu migtabak sikandan, “Ware key nakanengneng.” Ne migkahiyan degma sikandan ni Hisus, “Ke iling ma rue, kene ku degma egnangenan sikaniyu ke nekey ka katenged ku te peggimu kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne migkahi e man-e si Hisus, “Nekey-a te suman-suman niyu? Due etew ne daruwa se anak ne me lukes. Miggendiyaan din ka panganey ne anak din wey migkahiyan, ‘Tatu, trabahu ke pa kuntee diye te parasan.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ne migtabak sikandin, ‘Kena a egtrabahu!’ Piru ware de nalingen-ngen, nabalbalawan e ka suman-suman din wey miggendiyad e sikandin te kamet. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nataman, miggendiyaan e degma te amey ka hari ne anak din wey iling ded ka ingkahi rin. Ne migtabak ka anak, ‘Uya ame, eggendiya a,’ piru ware sikandin miggendiye. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na, hendei kayi te daruwa ka migtuman te igkeupii te amey ran?” Ne migtabak sikandan, “Seeye se panganey.” Migkahiyan ni Hisus sikandan, “Egnangenan ku sikaniyu te malehet: egpekewun-a pad kaniyu egpakaseled te Migharian te Manama ka me talagsukut te buhis wey ka me malitan ne egpamelegye te me lawa ran. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Su miggendini te kaniyu si Huwan ne Talagbewutismu wey migpanulu kaniyu te matareng ne peg-ugpe, ne ware kew migpalintutuu kandin. Piru migpalintutuu mule kandin ka me talagsukut te buhis wey ka me malitan ne egpamelegye te me lawa ran. Ne minsan nakakita kew e dutu, ware kew en iya mig-inniyug te me sale niyu wey migpalintutuu kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Migkahi si Hisus, “Pamineha niyu seini se panunggilingan. Due sabeka ne etew ne due tane ne impamulaan din te me prutas ne egngaranan te paras wey inlingut din te alad. Ne miglulungag man-e sikandin eyew egluyangan te behas te paras wey migbebaley man-e sikandin te matikang ne bakalag ne eg-ugpaan te talagtameng. Pegkapenga dutu, impatanggu rin e te me talagbasuk ka parasan wey miglapu e sikandin diye te mariyu ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te timpu e te pegpamupu te behas, impeendiye din ka me uripen din diye te me talagtanggu eyew egpakuen te kandin ne baad. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piru impandakep te me talagtanggu ka me uripen din. Ka sabeka ne uripen, inlelampesan dan, ka dangeb inderegpak dan te batu, wey ka igkatelu innimatayan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ne migsuhu e man-e ka kamuney te lein ne me uripen din, ne masulug pad du te nekewun-a. Piru iling ded ka innimu te me talagtanggu diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Te katammanan, impeendiye din e ka anak din ne lukes te migkahi, ‘Egtahuren dan iya sikandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piru te pegkakita te me talagtanggu te anak te kamuney, migpalalahey e sikandan, ‘Sikan e ka anak te kamuney te parasan ne iyan egpakakamuney kayi. Kuwa kid e su eggimatayan ta sikandin eyew sikante e ka egpakakamuney kayi.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Purisu indakep dan e sikandin wey inggehanuy ran e diye te lihawangan te parasan wey innimatayan dan e.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ne mig-inse si Hisus kandan, “Nekey-a ka eggimuwen te kamuney te parasan diye te me talagtanggu ke eglibed sikandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Migtabak sikandan kandin, “Egguleen din iya te egpangimatey seeye se mareet ne me talagtanggu wey egkataman, egpatamengan din e man-e te lein ne egpakabehey kandin te baad te tagse tigpamupu te behas.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ne migkahiyan ni Hisus sikandan, “Ware kew bes nakasabut te imbasa niyu diye te Kasulatan ne eggenendue, ‘Ka batu ne insamsamilian te me talagbebaley, nasi neyimu ne batu ne pabunsuran. Himu seini te Magbebaye ne Manama, wey igkeinu-inu ta seini’?” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ne migkahi pad man-e si Hisus, “Purisu egnangenan ku sikaniyu te kene kew e egkasakup te Migharian te Manama, wey iyan e egkasakup seeye se me etew ne egbebehas te meupiya. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne ka minsan hentew ne egkeulug ne egdeeg te seeye ne batu, egkallepuan, piru ka egkeuluhan te seeye ne batu, egkallupet iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te pegkarineg te me pangulu te me talagpanubad wey te me Parisiyu te panunggilingan ni Hisus, nasabut dan e ne sikandan ka igpasabut din. ");
INSERT INTO mbtNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Egdakepen e perem si Hisus te me pangulu te me Hudiyu, piru naaldek sikandan te me etew su in-ila ran si Hisus ne sabeka ne prupita. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nataman, mig-abey e man-e migpangguhud si Hisus diye te me etew pinaahi te me panunggilingan ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te Hari ne mig-andam te sahakeen para te kasal te anak din ne lukes. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ne impeyipanew e nikandin ka me suluhuanen din eyew egpaangayen te seeye se impanginggat din te sahakeen te kasal, piru migbalibad ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nataman, migpeyipanew e man-e sikandin te lein ne me suluhuanen din wey migkahiyan, ‘Nangeni niyu seeye se impanginggat ku te naandam e ka egkakeen su neyimatayan kud e ka me baka wey ka me nati ne impalambeg ku, wey naandam e ka langun, sikan naa peendiniya niyud e sikandan!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piru ware sikandan miglinga-linga wey nasi de iya nangipanew. Ka sabeka miggendiye te kamet din, ne ka dangeb miggendiye te egpanelepianan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne ka duma, impandakep dan ka me suluhuanen, impeyilawan wey impangimatayan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Purisu nabelu ka Hari wey impeendiye din e ka me sundalu rin eyew egpeyimatayan seeye se me mangngimatey wey egpasilaban ka me siyudad dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ne migkahiyan din ka me suluhuanen din, ‘Naandam e ka sahakeen te kasal, piru kene ne likes ne eggendini seeye se impanginggat ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Purisu hendiye kew te me bebalakan te me dalan wey hinggata niyu te sahakeen te kasal ka minsan hentew ne egkakita niyu diye.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne nangendiyad e seeye se me suluhuanen diye te me deralanen wey impanginggat dan ka langun ne nakita ran, meupiya ma wey se kene. Purisu napenu te me etew seeye se migsahakeenanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Piru te pegseled te Hari eyew egtengteng te me mahaliyug, due nakita rin diye ne etew ne ware migsaluub te igpangasal ne kumbale. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ne migkahiyan din seeye se etew, ‘Suled, immenu nu te egseled kayi te ware ke ma nakasaluub te igpangasal ne kumbale?’ Piru ware nakatabak ka etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nataman, migkahiyan e te Hari ka me suluhuanen din, ‘Bakua niyu ka belad din wey paa rin wey iregpak niyu diye te lihawangan ne marusilem. Ne diye, egmandalawit sikandan wey egmakihet te ngipen dan.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ne in-epus ni Hisus ka panunggilingan te migkahi, “Masulug ka ingginggat, piru deisek de ka in-alam.” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ne miglibulung ka me Parisiyu eyew egpammitew te paahi ne egkasahilut dan si Hisus pinaahi te peglalag-lalag din. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Seeye naa, impeendiye dan te ki Hisus ka me hibateen dan duma te me sakup ni Hirudis. Ne migkahi sikandan, “Talagpanulu, nakanengneng key ne malehet ka inlalag nu, wey impanulu nu ka kamalehetan meyitenged te igkeupii te Manama; wey imbalahad nu ke nekey ka suman-suman te me etew meyitenged te inlalag nu, tenged su ware nu tengtengi ka keugpe dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Purisu nangeni key ke nekey ka suman-suman nu. Supak naa te Balaud ta ka pegbayad te buhis diye ki Sisar ne Impiradur, wey se kene?” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piru natahaan ni Hisus ne mareet ka tuyu dan, purisu migkahi sikandin, “Sikaniyu se egmapitew-pitew re! Mania te eg-el-elehan a nikaniyu? ");
INSERT INTO mbtNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Papitawa a nikaniyu te seleppi ne igbayad te buhis!” Ne intaruwayan dan e sikandin te seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne mig-insaan sikandan ni Hisus, “Hentew ne alung wey ngaran ka nakatahu kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Migtabak sikandan, “Ki Sisar ne Impiradur.” Ne migkahiyan sikandan ni Hisus, “Ke iling due, ibehey niyu diye te Impiradur ka kandin, wey ibehey niyu degma diye te Manama ka kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Neinu-inu sikandan te pegkarineg dan dutu; ne mig-engkeran dan e sikandin wey nangawe e. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Te seeye ded ne aldew, due me Sadusiyu ne migparani ki Hisus. Sikandan ka migkahi ne kenad egkeuyag ka me minatey. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ne mig-insaan dan si Hisus, “Talagpanulu, migkahi si Muwisis, ‘Emun ke egpatey ka etew ne ware pad nakaanak, keilangan ne egpamaluwen te hari rin ka ipag din eyew duen ded anak te kakey rin ne migpatey e.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, due pitu ne taltalaari ne neelin ne lukes ne mig-ugpe dengan kayi te kanta. Nakaasawa ka panganey wey migpatey ne ware nakaanak. Purisu impamalu e te hari rin ka asawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ne iling ded degma due ka neyitabu te igkarangeb ne hari wey te igkatelu peendiye te igkalitan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te katammanan, migpatey e degma ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, ke eggingume e ka aldew ne eg-uyahen e ka me minatey, hentew naa ka egkaasawa rin su sikandan ma langun ka nakaasawa kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Piru migtabak si Hisus kandan, “Naseyyup kew, tenged su ware kew nakasabut te Kasulatan wey te geem te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te aldew ne eg-uyahen e ka me minatey, kenad egmaas-asaweey ka me etew tenged su egpekeiling e sikandan te me panalihan diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, meyitenged te pegkeuyag te me minatey, ware kew bes nakasabut te imbasa niyu ne ingkahi te Manama due te kaniyu ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sikeddiey ka Manama ni Abraham, ka Manama ni Isaak, wey ka Manama ni Hakub’? Iyan igpasabut kayi ne kene ne Manama sikandin te me minatey, ke kene, Manama te neneuyag.” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te pegkarineg dutu te masulug ne etew, neinu-inu sikandan te pegpanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Piru te pegkarineg dutu te me Parisiyu ne natalu ni Hisus te katarengan ka me Sadusiyu, migmarumeey e sikandan peendiye ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Due sabeka diye te kandan ne ebugadu ne mig-eleg-eleg ki Hisus pinaahi te peg-inse. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Talagpanulu, hendei ka labew ne suhu due te Balaud?” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ne migtabak si Hisus, “Keilangan ne eggeyinawaan nu ka Magbebaye ne Manama nu ne egpuun te pusung nu, egpuun te gimukud nu, wey egpuun te suman-suman nu. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sika ka an-anayan wey amana ne labew ne suhu. ");
INSERT INTO mbtNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne ka igkarangeb ne suhu egpekeiling ded te nekewun-a: ‘Geyinawei nu ka duma nu iling te peggeyinawa nu te pegkeetew nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ka intiru ne Balaud te Manama wey ka insulat te me prupita nalagkes e kayi te daruwa ne suhu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te nalibulung pad ka me Parisiyu, mig-insaan sikandan ni Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nekey-a ka suman-suman niyu meyitenged te Kristu? Hentew ne kabuhalan sikandin?” Ne migtabak sikandan, “Kabuhalan ni Dabid.” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ne migkahiyan ni Hisus sikandan, “Ke iling ma rue, mania te mig-umew si Dabid kandin te ‘Magbebaye’ pinaahi te bulig te Panisingan te Manama? Su migkahi si Dabid, ");
INSERT INTO mbtNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ka Manama migkahi diye te Magbebaye ku: Pinnuu ka kayi te igkakawanan ku, taman te eggimuwen ku ne diekanan nu ka me kuntere nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Purisu ke ingngaranan ni Dabid sikandin ne ‘Magbebaye’, egmenuwen naa te Kristu ne egkeyimu ne kabuhalan ni Dabid?” ");
INSERT INTO mbtNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne ware sabeka ne nakatabak ki Hisus, ne puun te seeye ne aldew, warad e egpaalag-alag ne eg-inse-inse kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nataman, migkahiyan ni Hisus ka masulug ne etew wey ka me hibateen din, ");
INSERT INTO mbtNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ka me talagpanulu te Balaud te Manama wey ka me Parisiyu ka imbehayan te katenged ne talagluwas te Balaud te Manama ne impabaye ki Muwisis. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sikan naa, keilangan ne egtumanen niyu wey eggimuwen ka langun ne igpanulu dan kaniyu. Piru kene niyu himuwa ka eggimuwen dan su kene dan eggimuwen ke nekey ka impanulu dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Migbebagkes sikandan te mabbehat ne dinulan wey impatiang dan te me etew, piru sikandan mismu egkamataan de wey kenad iya egbulig ne egtiang te dinulan. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Innimu ran ka langun eyew egparayan-dayan te me etew. Imparakelan dan ka me tahuanan dan te me sinulat ne me birsikulu ne imbagkes dan te me buked wey me belad dan, wey impamalayat dan ka me sidsid te me kumbale dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Egkeupian sikandan ne egpinnuu diye te pinnuuwan te me talahuren ne diye te sahakeenan wey diye te mateles ne me pinnuuwan diye te me simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne egkeupian sikandan ne egtahuren te me etew diye te me palingkiyan wey egngaranan te ‘Talagpanulu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piru kene kew pangaran te ‘Talagpanulu,’ su sabeka re ka talagpanulu niyu wey tagtahasuled kew re langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne kene kew ngaran te minsan hentew kayi te ampew te tane te ‘Amey,’ su sabeka re ka Amey niyu ne iyan ka diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne kene kew man-e pangaran te ‘Ahalen,’ su sabeka re ka ahalen niyu ne iyan sika ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ka iyan mabantug diye te kaniyu, keilangan ne egkeyimu ne suluhuanen te duma. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ka minsan hentew ne egparibabew te pegkeetew rin, igpariralem, piru minsan hentew ne egpariralem te pegkeetew rin, igparibabew. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! Ware niyu paselera ka me etew diye te Migharian te Manama. Ne sikaniyu mismu kene egseled wey imbalabahan niyu seeye se eg-eleg-eleg ne egseled. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! Su inlapas niyu ka karagdahatan wey inleug-leug niyu ka katantanaan eyew egpammitew te minsan sabeka re ne eggimuwen niyu ne hibateen. Ne emun ke egkeyimu e sikandin ne hibateen niyu, eggimuwen niyu sikandin ne subla pad kaniyu ne eleg egpekeendiye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mekeyid-u-hid-u kew se butud ne me talagkitkit ne migkahi, ‘Ka minsan hentew ne egpahunlibet te timplu, ware karuan dutu. Piru ka minsan hentew ne egpahunlibet te bulawan ne diye te timplu, keilangan ne egtumanen din seeye.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sikaniyu se egkengeungel ne me butud! Hendei ka labew, ka bulawan naa wey ke timplu ne iyan nakamatulus te bulawan? ");
INSERT INTO mbtNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Migpanulu kew man-e te ka minsan hentew ne egpahunlibet te altar, ware karuan dutu. Piru ka minsan hentew ne egpahunlibet te dasag ne diye te altar, keilangan ne egtumanen din seeye. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sikaniyu se me butud! Hendei bes ka labew, ka dasag naa wey ke altar ne iyan nakamatulus te dasag? ");
INSERT INTO mbtNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Purisu seeye se egpahunlibet te altar, iyan din egpahunlibetan ka altar wey ka langun ne nakatahu dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne seeye se egpahunlibet te timplu, iyan din degma egpahunlibetan ka timplu wey ka Manama ne mig-ugpe dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne seeye se egpahunlibet te langit, iyan din man-e egpahunlibetan ka trunu te Manama wey ka migpinnuu dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! Migbehey kew te igkasapulu ne baad diye te Manama te me leggu niyu iling te hirbabuwina, anis, wey kaningag, piru ware niyu tumana ka amana ne impurtanti ne me panulu due te Balaud. Su kene kew ne matareng, kene kew ne hiid-uwen diye te duma, wey kene kew egkasalihan. Keilangan ne egbehey kew te igkasapulu ne baad, piru kene niyu balahara ka duma ne panulu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sikaniyu se me butud ne talagkitkit, egsesala kew te ketiketi diye te eg-inumen niyu piru eg-abeleng kew te hendue karakel te kamilyu ne mananap! ");
INSERT INTO mbtNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! Miglinisan niyu ka lawa te pakawan wey pinggan, piru malindit ka diye te seled. Iling kew naa degma rue su napenu te halamlam wey pegtuhes-tuhes. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikaniyu se me butud ne me Parisiyu! Hun-eyi niyu pa te eglinis ka seled te pakawan wey te pinggan niyu, eyew malinis degma ka diye te ligwang. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! Egpekeiling kew te lebenganan ne imbatekan te maangkag wey meupiya ne egtengtengan ka lihawangan. Piru ka diye te seled napenu bes te tul-an te me minatey wey te langun ne mallindit. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne sikan naa degma ka egkeilingan niyu su matareng ne egtengtengan te me etew ka ligwang niyu piru napenu te pegpapitew-pitew wey sale ka seled niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mekeyid-u-hid-u kew se me talagpanulu te Balaud te Manama wey sikaniyu se me Parisiyu! Sikaniyu se egmapitew-pitew re! In-ay-ayaran niyu te migpangimu ka sabalanan te me prupita wey indayrayanan niyu ka me limuanan te matareng ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne migkahi kew man-e, ‘Emun ke duen kid e perem te timpu te me kaap-apuan ta, ware ki red perem nakaamung-amung kandan te migpangimatey te me prupita.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sikan naa, sikaniyu mismu ka migpamalehet ne sikaniyu iya ka me kabuhalan te seeye se migpangimatey te me prupita. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, impusi niyu ka imbunsuran e te me kaap-apuan niyu! ");
INSERT INTO mbtNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Me uled, sikaniyu se me kabuhalan te me mammiley! Egmenuwen niyu te egpanalliya ka legpad diye te linew ne hapuy? ");
INSERT INTO mbtNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne puun due, egpeuyanan ku sikaniyu te me prupita, me matagseb ne me etew, wey me talagpanulu te Balaud te Manama. Ne ka duma kandan egpangimatayan niyu wey iglansang te krus, ne ka duma egpanlampesan niyu diye te simbaan wey egpanlupuhen niyu sikandan diye te nalein-lein ne me inged. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sikan naa ka egkarakeselan kew te legpad tenged te peggimatey te langun ne matareng ne me etew, puun pad ki Abil peendiye te anak ni Barakiyas ne si Sakariyas, ne innimatayan niyu diye te elat-elat te timplu wey te altar. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Egnangenan ku sikaniyu te malehet: ka langun ne iglegpad due, egkaneem-neem iya te me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“E sikaniyu se matig-Hirusalim ne migpangimatey te me prupita wey migpandegpak te seeye se impeendue te kaniyu. Kamasalig ad e perem eglibulung kaniyu, iling te sabeka ne inayan ne migpangalupkup te me piyak din, piru ware kew neupii. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, eg-engkeran e eglahetengi ka siyudad niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Su egnangenan ku sikaniyu, kene kew e egpakakita keddiey man-e taman te egkahi kew e, ‘Egdayanen sikandin se impeendini te Magbebaye ne Manama kanta.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ne miglihawang e si Hisus te timplu wey te peggipanew rin e, migparani kandin ka me hibateen din wey impapitew ran kandin ka timplu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Piru migkahiyan ni Hisus sikandan, “Nakita niyu ma iya sika, menu ma? Piru egnangenan ku sikaniyu te malehet: ware minsan sabeka ne batu keureme ne egkasame diye te neunturan din, egkahebe iya ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Taheed te migpinpinnuu si Hisus diye te Bubungan te Ulibu, migparani kandin ka me hibateen din ne sikandan de wey migkahi, “Nangeni key ke ken-u egkeyitabu seini, wey nekey-a ka palinneu te peglibed nu wey te katammanan te timpu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ne migtabak si Hisus, “Bantey kew ne kene kew egkeuyan te kene ne malehet ne talagpanulu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Su masulug ka eggendini ne egpeila ne sikandan kun ka Kristu, wey masalig ka egkeuyan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Egpakarineg kew te egmabunbunuey due te marani niyu, wey me guhuren meyitenged te egmabunbunuey diye te mariyu, piru kene kew kaaldek su keilangan ne egkeyitabu sika. Piru kene pad ne sika ka katammanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Egpakigkuntere ka sabeka ne nasud te lein ne nasud wey egpakigkuntere ka sabeka ne tribu te lein ne tribu. Egginguma ka me bitil wey me linug diye te minsan hendei ne inged, ");
INSERT INTO mbtNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","piru sika langun, bunsuranan pad te kasakitan iling te eglesutan ne egbaletikan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ne egpandakepen kew eyew egbaybayaran wey eggimatayan. Egdumutan kew te langun ne me nasud tenged keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Egkataman, masalig ka egpakasuwey, wey egmaak-akaley sikandan wey egmarumdumutey. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ne masulug ka egginguma ne kene ne malehet ne me prupita wey masalig ka egkalaag nikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne tenged su egsuble e ka kareet te me etew, kenad e egpaheyinaweey ka masulug ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piru seeye se egpabulus eg-ikul keddiey taman te katamanan iyan egkaluwas. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne ka Meupiya ne Panugtulen meyitenged te Peghari te Manama, igwali te intiru ne kalibutan isip pegpamalehet diye te langun ne me nasud, ne egkataman, eggingume e ka katamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ke egkiteen niyud ka makaalat-halat ne ‘talagdereet ne lilinditi diye te tangkaan te Manama’ ne egkahiyen ni prupita Danyil ne diye egsasindeg te matulus ne timplu (keilangan ne egsabuten sika te talagbasa), ");
INSERT INTO mbtNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","seeye se me etew ne diye te Hudiya, keilangan ne eg-aput diye te me bubungan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne seeye se etew ne diye te atep te baley rin, keilangan ne kenad e egpamaneug eyew egkuwa te me kasangkapan din diye te seled. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne seeye se diye te kamet, keilangan ne kenad e eg-uli eyew egkuwa te kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mekeyid-u-hid-u te seeye ne me timpu ka egkengaberes wey ka egmasusu pad te me anak dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ne ampu kew ne kene ne tingmaagsil wey kene ne Aldew te Peggimeley ka pegpallahuy niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Su due egginguma ne makabayad-bayad ne peg-antus ne ware pad neyitabu puun te peggimu te kalibutan taman kuntee, wey kenad e seini egkeyitabu pad man-e. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ne emun ke ware pad hilepeti te Manama ka seeye ne timpu, egkahule iya egpamatey ka me etew. Piru tenged te me etew ne in-alam din, innilepetan din ka seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ne emun ke due egkahi kaniyu, ‘Pitew kew, kayi ka Kristu!’ wey ke ‘Diye sikandin!’ kene kew en iya palintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Su eglepew ka kene ne malehet ne me Kristu wey ka kene ne malehet ne me prupita. Eggimu sikandan te me derakel ne me palinneu wey me kein-inuwan eyew egkeuyan ka me etew, ke egkaayun, minsan seeye se in-alam te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bantey kew su tapey kud e sikaniyu panpanayi. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Purisu, ke egkahiyan kew nikandan, ‘Pitawa niyu, diye sikandin te mammara ne inged ne kene egkeugpaan,’ kene kew hendiye. Ne emun ke egkahiyan kew nikandan, ‘Pitawa niyu, miggeles sikandin diye te sinabeng,’ kene kew palintutuu kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Su ka peglibed te Anak te Etew egpekeiling te kilat ne miggeteb puun te igsile peendiye te iglineb. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ke hendei ka lawa ne napatey, diye degma eglibulung ka me banug. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pegkapenga te me peg-antus te seeye ne me timpu, egmarusilem e ka aldew wey kenad e eglayag ka bulan, wey egkengeulug e ka me bituen puun te langit wey egkawelwel ka me tahu diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Egkataman, eglepew e diye te langit ka palinneu te Anak te Etew, wey ka langun ne tribu te kalibutan egmanlungku. Ne egkakita ran e ka Anak te Etew ne eglepew diye te gapun duma te geem din wey te dakel ne katelesan. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne due dakel ne trumpita ne igparahing, ne igpeendiye din e ka me panalihan din diye te langun ne inged kayi te ampew te tane eyew te peglibulung te keet-etawan ne in-alam din. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, sumsumana niyu ka kayu ne iggira wey himuwa niyu ne panunggilingan. Emun ke egtunasan e ka me sugpang din, sika ka palinneu ne mahaan e ka tingmeinit. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iling naan ded degma due, emun ke egkiteen niyud e sika se langun ne ingkahi ku, egkatahaan niyud ne marani e sikandin, egpalinggumaan e. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Egnangenan ku sikaniyu te malehet: egkatuman e sika langun te kene pad egkengamatey ka me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Egkaawe ka langit wey ka tane, piru ka keddi ne lalag, kene iya egkaawe. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Piru ware minsan sabeka ne nakataha te aldew wey te uras ke ken-u seeye egkeyitabu, minsan ka me panalihan diye te langit wey ka Anak, su iyan de nakataha ka Amey. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Su ka peglibed te Anak te Etew egpekeiling te neyitabu te timpu ni Nuwi. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Su te ware pad migsipuk ka weyig, migpabulus ka me etew ne nangekeen, nangiinum, wey migmaas-asaweey, taman te aldew te migseled e si Nuwi diye te arka. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ware sikandan nakataha ke nekey ka egkeyitabu taman te migsipuk e ka weyig ne mig-anlas kandan langun. Ne iling naan ded degma kayi ka egkeyitabu te peglibed te Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Emun ke due daruwa ne etew ne diye te kamet; eg-angayen ka sabeka wey eggaaten ka dangeb. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Emun ke due daruwa ne malitan ne eggehaling; eg-angayen ka sabeka wey eggaaten ka dangeb. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Purisu bantey kew, su ware kew nakanengneng ke ken-u egginguma ka Magbebaye niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ne tantanuri niyu seini: emun ke nakanengneng ka kamuney te baley ke nekey ne uras te marusilem eglepew ka takawen, egbantey iya sikandin eyew kene egpakaseled ka takawen te baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Purisu keilangan ne eg-andam kew degma, su egginguma ka Anak te Etew te timpu ne ware niyu pallatenga. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Hentew-a ka suluhuanen ne egkasalihan wey matagseb? Panunggilingan, ke imbehayan ka suluhuanen te ahalen din te katenged te pegmandu te me duma rin ne me suluhuanen, eyew egpakeen kandan te eleg ne timpu, ");
INSERT INTO mbtNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","meupiya sikandin ke nasapenan ne miggimu te peg-uli te ahalen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Egnangenan ku sikaniyu te malehet: sikandin e ka egpeuyanen te ahalen din te langun ne karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piru ke mareet ka suluhuanen, egsuman-suman sikandin ne mananey pad eg-uli ka ahalen din ");
INSERT INTO mbtNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wey dutu egbunsud e sikandin ka egpanlampes te me duma rin ne me suluhuanen, wey egpanaman-taman egkeen wey eg-iinum duma te me talewubug. ");
INSERT INTO mbtNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ne eg-uli ka ahalen din te sabeka ne aldew ne ware din pallatenga, wey te uras ne ware din nanengnengi ");
INSERT INTO mbtNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","wey egdusaan sikandin te ahalen din wey igpalemung diye te me etew ne egmapitew-pitew re. Ne diye egmandalawit ka me etew wey egmegkihet te ngipen dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te sapulu ne mengebay ne mig-uyan te me sulu wey nangipanew ka egsinug-ung te egpangasawa. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Egkengeungel ka lalimma ne mengebay wey me matagseb ka lein ne lalimma ne mengebay. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Su ka egkengeungel, nanguyan te me sulu dan piru ware migtahahe te igtubil dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Piru ka me matagseb, nanguyan mule te me sulu wey te igtubil ran diye te tahuanan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne puun su naangge ka egpangasawa, egtuytuyungen e sikandan wey nenakalipereng e. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Hengkayi te egliware e te karusileman, due migbalbalukan ne migkahi, ‘Duen e ka egpangasawa. Apas kew wey temuwa niyu sikandin!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Te sikan de, nangimate e ka me mengebay wey in-andam dan e ka me sulu dan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ne migkahi seeye se egkengeungel diye te me matagseb ne me mengebay, ‘Behayi key ubag nikaniyu te igtubil su egmangalap-halap naan de ka me sulu ney.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Piru migtabak ka me matagseb, ‘Kema ke kenad e egkeeleg seini kanta. Hendiye kew pa te tindaan wey beli kew e te igtubil niyu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Taheed te nangipanew e ka egmambebeli, miggingume e ka egpangasawa. Ne seeye se nenakaandam, migdume e kandin diye te sahakeenanan, ne inlekeban e ka gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Te ware de nalingen-ngen, nangingume e degma ka duma ne me mengebay wey migbalbalukan sikandan ka migkahi, ‘Ahalen! Ahalen! Lukati key nikeykew!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piru migtabak sikandin, ‘Egnangenan ku sikaniyu te malehet: wara a nekeila kaniyu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Purisu bantey kew su ware niyu nataheyi ka aldew wey ka uras te peglibed ku. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ka Peghari te Manama egpekeiling man-e te pangguhuren meyitenged te etew ne eggipanew te mariyu ne inged. In-umew rin ka me suluhuanen din wey insalig din diye te kandan ka me karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Imbehayan din ka tagse sabeka sumale te katuenan dan. Ka sabeka imbehayan din te lalimma ne libu (5,000) ne seleppi ne bulawan, ka dangeb imbehayan din te daruwa ne libu (2,000) ne seleppi ne bulawan, ka igkatelu imbehayan din te senge libu (1,000) ne seleppi ne bulawan. Nataman, miggipanew e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ka suluhuanen ne nakarawat te lalimma ne libu (5,000) ne seleppi ne bulawan, due-rue ne migbunsud sikandin ka egpaanak te seleppi din, wey mig-anak seeye te lalimma ne libu (5,000). ");
INSERT INTO mbtNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne iling ded degma ka dangeb ne nakarawat te daruwa ne libu (2,000) ne seleppi ne bulawan, mig-anak ka seleppi din te daruwa ne libu (2,000). ");
INSERT INTO mbtNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piru ka nakarawat te senge libu (1,000) ne seleppi ne bulawan, miggipanew sikandin wey migkekali te tane ne inlebengan din te seleppi te ahalen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Te naluhey e ne timpu, mig-uli e ka ahalen eyew egbalansiyan ka me suluhuanen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne migparani seeye se suluhuanen ne insalihan te lalimma ne libu (5,000) ne seleppi ne bulawan wey mig-uyan pad sikandin te lein ne lalimma ne libu wey migkahi, ‘Ahalen, imbehayan a nikeykew te lalimma ne libu ne seleppi ne bulawan. Na, tengtengi nu, seini red ka anak ne lalimma ne libu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ne migkahiyan sikandin te ahalen din, ‘Meupiya ka innimu nu. Meupiya ka wey egkasalihan ka; tenged su egkasalihan ka te deisek ne seleppi, egsalihan ku sikeykew te dakel pad. Seled ka wey sawit ka te kahale te ahalen nu!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne migparani degma seeye se suluhuanen ne insalihan te daruwa ne libu (2,000) ne seleppi ne bulawan wey migkahi, ‘Ahalen, imbehayan a nikeykew te daruwa ne libu ne seleppi ne bulawan. Na, tengtengi nu, seini red ka anak ne daruwa ne libu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Migkahiyan sikandin te ahalen din, ‘Meupiya ka innimu nu. Meupiya ka wey egkasalihan ka; tenged su egkasalihan ka te deisek ne seleppi, egsalihan ku sikeykew te dakel pad. Seled ka wey sawit ka te kahale te ahalen nu!’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nataman, migparani e degma ka suluhuanen ne insalihan te senge libu (1,000) ne seleppi ne bulawan wey migkahi, ‘Ahalen, nakanengneng a ne mabulut ka, eggaani ka te ware nu ibubul wey egpanlimud ka te ware nu isawed. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Purisu naaldek a wey inlebeng ku te tane ka seleppi nu. Na, tengtengi nu, seini red ka seleppi nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Piru migkahi ka ahalen din, ‘Sikeykew se mareet wey pehulen ne suluhuanen! Nakanengneng ke bes te eggaani a te ware ku ibubul wey egpanlimud a te ware ku isawed; ");
INSERT INTO mbtNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ne mania te ware nu itahu diye te bangku ka seleppi ku eyew te peg-uli ku egkaangey ku red seini duma te anak kayi? ");
INSERT INTO mbtNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na, kua niyu ka seleppi due te kandin wey ibehey niyu diye te nakaseleppi te sapulu ne libu (10,000) ne seleppi ne bulawan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Su seeye se due kandin, egtimulan pad eyew egmasalig ka kandin. Piru seeye se ware kandin, eg-angayen minsan ka deisek ubag ne in-isip din ne kandin perem. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne seini se ware gulehud ne suluhuanen, iregpak niyu diye te lihawangan ne marusilem. Ne diye, egpandalawit sikandin wey egpegkihet te ngipen din.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Emun ke eggingume e ka Anak te Etew duma te geem wey katelesan din wey egdumaan te langun ne me panalihan, egpinnuu e sikandin diye te amana ne mateles ne trunu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ne eglibulungen diye te tangkaan din ka me etew te langun ne me nasud. Egkataman, egbaaren din sikandan te daruwa ne baad, iling te eggimuwen te talagtameng ne egpegsuwey te karniru wey te kambing. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne diye din igtahu te igkakawanan din ka me karniru, piru ka me kambing diye din igtahu te igkahibang din. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Egkataman, sikeddi se Hari, egkahiyan ku ka diye te igkakawanan, ‘Hendini kew sikaniyu se impanalanginan te Amey ku wey ugpe kew te Migharian ne intahahe kaniyu puun pad te peggimu te kalibutan. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Su timpu ne miggutasan a, impakeen a nikaniyu, te timpu ne nammaraan a, impeinum a nikaniyu, te timpu ne miglapu a, insagsahipa a nikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Te timpu ne ware kukumbaleen ku, impakumbalaan a nikaniyu, te timpu ne migderalu a, intanggu a nikaniyu, te timpu ne naprisu a, inleuy a nikaniyu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ne eg-inse seeye se me matareng, ‘Magbebaye, ken-u ney-a nakita sikeykew ne miggutasan wey impakeen ney, ne nammaraan ka ne impeinum ney? ");
INSERT INTO mbtNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ken-u ney-a nakita sikeykew ne miglapu wey insagsahipe ney sikeykew, wey ware kukumbaleen nu ne impakumbalaan ney sikeykew? ");
INSERT INTO mbtNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ken-u ney-a nakita sikeykew ne migderalu wey ke naprisu ne inleuy ney?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne egtabak a se Hari, ‘Egnangenan ku sikaniyu te malehet: ka minsan nekey ne innimu niyu diye te kene ne impurtanti ne me suled ku, innimu niyud e sika kayi te keddiey.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ne egkataman, egkahiyan kud e seeye se me etew ne diye te igkahibang, ‘Awe kew rue, sikaniyu se indilus te Manama wey diye kew te hapuy ne ware egtamanan ne in-andam din te ahalen te me busew duma te me panalihan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Su timpu ne miggutasan a, wara a nikaniyu pakeena; te timpu ne nammaraan a, wara a nikaniyu peinuma. ");
INSERT INTO mbtNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Te timpu ne miglapu a, wara a nikaniyu palasura te baley niyu, te timpu ne ware kukumbaleen ku, wara a nikaniyu pakumbalei, te timpu ne migderalu a wey naprisu, wara a nikaniyu leuya.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ne eg-inse degma sikandan, ‘Magbebaye, ken-u ney-a nakita sikeykew ne miggutasan wey ke nammaraan, wey miglapu, wey ware kukumbaleen, wey migderalu, wey naprisu, ne ware ney bulihi sikeykew?’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne egtabak sikandin, ‘Egnangenan ku sikaniyu te malehet: ka minsan nekey ne ware niyu himuwa diye te kene ne impurtanti ne me suled ku, ware niyu himuwa sika kayi te keddiey.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Egkataman, igpeendiyad e sikandan te dusaanan ne ware egtamanan, piru ka me matareng egbehayan te umul ne ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te nakapenge e si Hisus ka miglalag te langun ne eglalahen din, migkahiyan din e ka me hibateen din, ");
INSERT INTO mbtNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nakanengneng kew e ne ikaruwa naan de ka katumanan te Sahakeen te Peglihad te Panalihan, ne ka Anak te Etew igbehey e diye te me etew eyew iglansang te krus.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nataman, miglibulung e ka me pangulu te me talagpanubad wey ka me igbuyag te me Hudiyu diye te palasyu ni Kaypas ne Labew ne Talagpanubad, ");
INSERT INTO mbtNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","wey migplanu sikandan ke egmenuwen ne egkarakep dan si Hisus te heles de eyew egkeyimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Piru migkahi sikandan, “Kene ta eggimuwen seini te timpu te Sahakeen, su kema ke egkasamuk ka me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Te seeye ne timpu, diye ensi Hisus te Bitanya te baley ni Simun ne ibungen. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te sasangan ne egkeen si Hisus, due malitan ne migparani kandin ne mig-uyan te mahal ne peemut ne diye itahu te alabastru, wey mig-itisan din ka ulu ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te pegkakita dutu te me hibateen din, nabelu sikandan wey migkahi, “Mania te migde-deetan sika? ");
INSERT INTO mbtNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Igbelegye perem sika se peemut te dakel ne kentiddad wey igpamehey diye te egkengaayu-ayu ka halin!” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Piru nanengnengan seeye ni Hisus wey migkahiyan din e sikandan, “Mania te egbanggawen niyu sikandin? Amana ne meupiya ka innimu rin kayi te keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Su ka egkengaayu-ayu, layun niyu mule egkaruma, piru sikeddi, kena a nikaniyu layun egkaruma. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","In-itisan din te peemut ka lawa ku eyew te peg-andam te pegsabal keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Egnangenan ku sikaniyu te malehet: minsan hendei igwali ka Meupiya ne Panugtulen kayi te intiru ne kalibutan, egkahuhud degma ka innimu rin kayi te keddiey eyew egkasuman-suman sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nataman, miggendiye te me pangulu te me talagpanubad si Hudas Iskaryuti ne sabeka te sapulu wey daruwa (12) ne hibateen ");
INSERT INTO mbtNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wey migkahi, “Pila ka igbayad niyu keddi ke igbehey ku si Hisus kaniyu?” Ne migbehayan dan e si Hudas te seleppi ne tatelu ne pulu (30) ne timman. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ne puun dutu, migpammitew e sikandin te meupiya ne timpu ne igkabehey rin si Hisus diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te an-anayan ne aldew te Sahakeen te Paan ne Ware Patulin, migparani ki Hisus ka me hibateen din wey mig-inse, “Hendei nu igkeupii ne eg-andamen ney ka egkeenen ta te Peglihad te Panalihan?” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne migtabak sikandin, “Hendiye kew te siyudad, diye te sabeka ne etew wey kahii niyu sikandin, ‘Migkahi ka Talagpanulu te mahaan e ka timpu ku, ne duen a te keykew egsahakeen duma te me hibateen ku te Peglihad te Panalihan.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne innimu te me hibateen ni Hisus ka insuhu din kandan wey in-andam dan e ka egkeenen para te Sahakeen te Peglihad te Panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hengkayi te nasagkup e, migpinnuu e si Hisus duma te sapulu wey daruwa (12) ne hibateen din eyew egkeen e. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te sasangan e sikandan ne egmangekeen, migkahi si Hisus, “Egnangenan ku sikaniyu te malehet: due sabeka kaniyu ne eg-akal keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ne amana sikandan nalaggew wey migpasubsubaley re ka mig-inse, “Magbebaye, kema ke sikeddi ka egkahiyen nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ne migtabak si Hisus, “Sabeka kaniyu te migsaamul keddi migdallut te paan te seini ne yahung ka eg-akal keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Egpatey ka Anak te Etew sumale te nasulat te Kasulatan, piru mekeyid-u-hid-u ka etew ne eg-akal kandin. Meupiya pad ke ware sikandin neetew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne mig-inse si Hudas ka eg-eakal kandin, “Talagpanulu, kema ke sikeddi ka egkahiyen nu?” Migtabak si Hisus, “Inlalag nud en iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te sasangan pad sikandan ne egmangekeen, migkuwa si Hisus te paan wey impasalamatan din ka Manama, wey impanepik-tepik din seini wey impamehey rin diye te me hibateen din te migkahi, “Kuwa kew kayi wey keena niyu. Seini ka lawa ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nataman, migkuwe e man-e sikandin te senge ubab ne binu, ne impasalamatan din ka Manama wey intaruwey rin diye te kandan te migkahi, “Inum kew langun kayi, ");
INSERT INTO mbtNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","su seini ka langesa ku ne igpatihis eyew egkapasaylu ka sale te masulug ne me etew. Seini ka egpamalehet te kasabutan te Manama diye te keet-etawan din. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Egnangenan ku sikaniyu, kena ad e eg-abey eg-inum te seini ne inumen ne egpuun te paras taman te aldew ne eg-inum ad e te iyam ne inumen duma kaniyu diye te Migharian te Amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nataman, nangulahing e sikandan te pegdayan te Manama wey nangendiyad e te Bubungan te Ulibu. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nataman, migkahi e si Hisus diye te kandan, “Te seini ne karusileman, eg-engked kew e langun keddiey su nasulat diye te Kasulatan, ‘Eggimatayan ku ka talagtameng te me karniru, wey egmemekegsuwey-suwey e ka me karniru.’ ");
INSERT INTO mbtNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piru te pegkapenga te peg-uyag keddi, eggun-a ad e kaniyu diye te Galiliya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ne migkahiyan ni Pidru si Hisus, “Minsan pad ke eg-engkeran ka te langun, kena ad iya eg-engked keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne migkahiyan ni Hisus si Pidru, “Egnangenan ku sikeykew te malehet: te kene pad eg-ukale ka manuk te seini ne karusileman, katatelu ad nikeykew igpahunware.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ne migkahiyan ni Pidru sikandin, “Minsan pad eggimatayan a duma keykew, kene ku iya igpahunware sikeykew.” Ne iling ded degma ka ingkahi te langun ne me hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nataman, nangendiyad e ensi Hisus te inged ne egngaranan te Gitsimani wey migkahiyan din ka me hibateen din, “Kayi kew pa paminnuu taheed te eg-ampu e pad seeye te kewun-aan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne induma rin si Pidru wey ka talaari ne anak ni Sibidiyu, ne dutu nakaheram sikandin te subla ne pegkalaggew wey migmemasakit se geyinawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne migkahiyan ni Hisus sikandan, “Amana ne sesakiti ka geyinawa ku ne hendue te egkapatey ad e. Kayi kew naan pa wey kene ki eglipereng.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne migpabulus si Hisus diye te kewun-aan wey mig-usengul diye te tane wey mig-ampu ne migkahi, “Ame, ke egkaayun diye te keykew, angaya nu seini se ubab te peg-antus kayi te keddiey, piru kene ne iyan egkatuman ka keddiey ne pegbuut, ke kene, ka keykew ne pegbuut.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nataman, miglibed e si Hisus diye te me hibateen din wey neumaan din sikandan ne nenewulep e. Ne migkahiyan din e si Pidru, “Etuwey, kene kew egpakaantus ne kene eglipereng duma keddi minsan senge uras de? ");
INSERT INTO mbtNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kene kew lipereng wey ampu kew eyew kene kew egkatintal. Egkeupian perem ka panisingan piru mahuye ka lawa niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne mig-abey e man-e miggendiye te kewun-aan si Hisus wey mig-ampu ne migkahi, “Ame, emun ke keilangan iya ne eg-inumen ku ka seini ne ubab te peg-antus, egkatuman iya ka igkeupii nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te peglibed man-e ni Hisus, neumaan din ded man-e sikandan ne nenewulep su egmemakaliplipereng en iya sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Purisu, mig-engkeran din e man-e sikandan wey mig-ampu. Igkatatelu rin e seini te peg-ampu wey iling ded ka in-ampu din. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nataman, miglibed e man-e sikandin diye te me hibateen din wey migkahi, “Ew, nenewulep kew bes pad wey nangimeley? Pitawa niyu! Seinid e ka timpu ne igbehey e ka Anak te Etew diye te me makasesale. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bukal-bukal kew e su egmangipanew kid. Pitawa niyu, sikan e ka eg-akal keddiey!” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Te sasangan pad ne eglalag si Hisus, miggingume e si Hudas ka sabeka te sapulu wey daruwa (12) ne hibateen din. Due susuluhi ne etew ka migduma kandin ne nanguyan te me kampilan wey me lampes. Insuhu sikandan te me pangulu te me talagpanubad wey igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ne seeye se talag-eakal migbehey kandan te palinneu ne migkahi, “Ka etew ne eggarekan ku, sikan naa dakepa niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Te pegginguma ni Hudas, migleus e sikandin diye te ki Hisus wey migkahi, “Talagpanulu, meupiya red.” Ne miggarekan din e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ne migkahiyan sikandin ni Hisus, “Ne alukuy, himuwa nu ke nekey ka innendini nu.” Nataman, migparani e ka me etew diye te ki Hisus wey inderakep dan e sikandin wey impakamkamelan dan te eggen-gen. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ne due sabeka ne duma ni Hisus ne miggulabut te kampilan din wey intibbas din ka uripen te Labew ne Talagpanubad, ne natamped e ka talinga te uripen. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Piru migkahiyan ni Hisus ka hibateen din, “Ilipi nu ka kampilan nu su ka langun ne egtangkayang te kampilan, egkamatey red degma pinaahi te kampilan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ware ke bes nakanengneng ne egkaayun ne egpepangabang a te Amey ku wey due-rue ne egpeuyanan a nikandin te libu-libu ne luyuran te me panalihan? ");
INSERT INTO mbtNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piru ke eggimuwen ku sika, kenad e egkatuman ka nasulat diye te Kasulatan ne keilangan ne egkeyitabu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ne dutu, migkahiyan din ka masulug ne me etew, “Takawen a? Mania te nanguyan kew te me kampilan wey me lampes ka egdakep keddiey? Tagse aldew ne egpinnuu a diye te timplu ka egpanulu kaniyu, ne wara a derakepa nikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piru neyitabu seini se langun eyew egkatuman ka insulat te me prupita diye te Kasulatan.” Ne in-engkeran e sikandin te me hibateen din wey namallahuy e sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nataman, in-uyan e si Hisus te me etew ne migdakep kandin diye ki Kaypas, ka Labew ne Talagpanubad. Diye nanlibulung ka me talagpanulu te Balaud te Manama wey ka me igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ne migsinundul si Pidru kandin ne migpadpariyu de, taman te lama te Labew ne Talagpanubad. Nataman, migseled e sikandin diye wey migpinnuu duma te me talagbantey su eyew egtengteng ke nekey ka egpangkusan. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne migpammitew te ubat ne me guhuren meyitenged ki Hisus seeye se me pangulu te me talagpanubad wey ka sakup te me Talaggukum te me Hudiyu eyew egpeyimatayan dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piru ware nakita ran, minsan masulug ka mig-uubat ne me talagpamalehet. Te katammanan, due daruwa ne etew ne migpamalehet ");
INSERT INTO mbtNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne migkahi, “Narineg ney ka seini ne etew ne migkahi, ‘Egguhusen ku ka timplu te Manama wey igbalew-balew ku seini igpasasindeg seled te tatelu re ne aldew.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne migsasindeg ka Labew ne Talagpanubad wey mig-inse ki Hisus, “Na, ware igkatabak nu te me sumbung meyitenged keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piru migpeeneng-eneng de iya si Hisus. Ne migkahi e man-e ka Labew ne Talagpanubad diye te kandin, “Egpepahunlibeten ku sikeykew te ngaran te manekal ne Manama ne egnangenan key nikeykew ke sikeykew iya ka Kristu, ka Anak te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ne migtabak si Hisus, “Inlalag nud en iya. Piru egnangenan ku sikaniyu te puun kuntee egkiteen niyu ka Anak te Etew ne egpinnuu diye te igkakawanan te Maresen ne Manama. Ne egginguma sikandin ne egdumaan te me gapun diye te langit.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Te sikan de, inggisi e te Labew ne Talagpanubad ka kumbale din te migkahi, “Imbaley-baley rin e ka Manama! Ne mania te egkeilangan ki pad ne egkuwa te me talagpamalehet te narineg niyud ma ka pegbaley-baley rin? ");
INSERT INTO mbtNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, nekey te suman-suman niyu?” Ne migtabak sikandan, “Eleg sikandin ne eggimatayan!” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nataman, in-iileban dan e ka ulaula rin, wey impandabi ran e wey impanagpi sikandin te duma ");
INSERT INTO mbtNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","te migkahi, “Ne la Kristu, antuki nu ke hentew-a ka migpasakit keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nekey naa te diye migpinpinnuu si Pidru te lama. Ne due malitan ne suluhuanen te Labew te Talagpanubad ne migparani kandin wey migkahi, “Hey, hendue mule te duma ka ni Hisus ne matig-Galiliya?” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piru migpahunware si Pidru diye te tangkaan te langun ne etew ne migkahi, “Wara a nakataha ke nekey ka impanlalag nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nataman, miggendiyad e sikandin te kasunguwan te alad wey duen e man-e lein ne suluhuanen ne malitan ne nakakita kandin, wey migkahi diye te me etew, “Hey, ka seini ne etew duma ni Hisus ne matig-Nasarit.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ne migpahunware ded man-e si Pidru ne migkahi, “Hibet iya, wara a nekeila te sika ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te ware de naluhey, migparani diye te ki Pidru seeye se nanasindeg diye wey migkahi, “Malehet iya ne duma ka nikandan su egkeilaan ka iya minsan te peglalag-lalag nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ne dutu, migpahunlibet en iya si Pidru ne migkahi, “Mengeyibet iya te pegkeetew ku, wara a iya nekeila te sika ne etew minsan pad egpatey a!” Ne due-rue ne mig-ukale ka manuk ");
INSERT INTO mbtNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","wey nasuman-suman ni Pidru ka inlalag ni Hisus kandin, “Te kene pad eg-ukale ka manuk, katatelu ad nikeykew igpahunware.” Ne miglihawang e si Pidru wey migpanaman-taman migsinehew. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Te pegkapawe e, migplanu e ka me pangulu te me talagpanubad wey ka me igbuyag te me Hudiyu ke egmenuwen dan ne egkeyimatayan si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne imbebaku dan e si Hisus wey in-uyan dan e diye te ki Gubirnadur Pilatu, wey imbehey ran e kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Te pegkakita ni Hudas ne talag-eakal ne innukuman dan e ne egpeyimatayan si Hisus, nekegsendit e sikandin wey in-uli din e ka seleppi ne tatelu ne pulu (30) ne timman diye te me pangulu te me talagpanubad wey diye te me igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Migkahi sikandin, “Nakasala a te peg-akal ku te etew ne ware sale.” Ne migtabak sikandan, “Nekey naa ka labet ney due? Prublima nud e sika!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne insabulak e ni Hudas ka seleppi diye te timplu wey mig-awe sikandin. Nataman, miggipanew e ka mig-ehet-ehet ne migbibitin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Impamurut te me pangulu te me talagpanubad ka seleppi te migkahi, “Ka seini ne seleppi, bayad te umul te etew, wey supak te balaud ta ke igtahu ta seini te tahuanan te seleppi kayi te timplu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Purisu nekegsabut sikandan ne igbeli ran ka seleppi te kamet te talaggimu te kuren eyew eggimuwen ne lebenganan te me mahaliyug. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sikan naa, minsan kuntee migngaranan e seeye te, “Ka Tane ne Imbayaran te Langesa.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Purisu natuman e ka ingkahi ni prupita Hirimiyas, “Ingkuwa ran e ka seleppi ne tatelu ne pulu (30) ne timman, ka kentiddad ne neuyunan te me kabuhalan ni Israil ne igbayad kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne inggamit dan e ka seleppi wey imbeli ran te kamet te talaggimu te kuren, sumale te insuhu te Manama keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ne si Hisus diyad e te tangkaan ni Gubirnadur Pilatu, wey mig-insaan e sikandin ni Pilatu te migkahi, “Sikeykew iya ka Hari te me Hudiyu?” Migtabak si Hisus, “Ingkahi nud en iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Piru ware din tabaka ka imbebayung kandin te me pangulu te me talagpanubad wey te me igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Purisu migkahiyan sikandin ni Pilatu, “Ware nu narineg ka masalig ne imbebayung dan keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piru warad iya minsan sabeka te imbebayung dan ne intabak ni Hisus, purisu amana ne neinu-inu ka Gubirnadur. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nabatasan e ni Pilatu ne tagse Sahakeen te Peglihad te Panalihan, due eglekaan din ne pinirisu ne igkeupii te keet-etawan. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te seeye ne timpu, due sabeka ne mabantug ne pinirisu ne egngaranan ki Barabas. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te nalibulung e ka masulug ne me etew, mig-insaan e sikandan ni Pilatu, “Hentew-a ka igkeupii niyu ne eglekaan ku? Si Barabas naa wey ke si Hisus ne egngaranan te Kristu?” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Su nakanengneng si Pilatu ne neimma re sikandan ki Hisus, sikan naa indakep dan e si Hisus wey imbehey e diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Taheed te migpinnuu si Pilatu diye te pinuuwan te eggukum, migpeuyanan sikandin te asawa rin te lalag ne migkahi, “Kene nu hilabeti sika se matareng ne etew, su amana a nabantali te taheinep ku gabii meyitenged kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piru intipu te me pangulu te me talagpanubad wey te me igbuyag te me Hudiyu ka me etew ne si Barabas ka eghangyuen dan ne eglekaan, ne si Hisus ka egpeyimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ne mig-abey e man-e mig-inse si Pilatu diye te me etew, “Hentew-a kayi te daruwa ka igkeupii niyu ne eglekaan ku?” Migtabak sikandan, “Si Barabas!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne mig-inse si Pilatu kandan, “Ke iling due, nekey-a ka eggimuwen ku ki Hisus ne egngaranan te Kristu?” Migtabak sikandan langun ne migkahi, “Ilansang nu sikandin te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne mig-insaan sikandan ni Pilatu, “Mania, nekey bes ka neyimu rin ne mareet?” Piru nanasnasian de iya sikandan ka migbalbalukan ne migkahi, “Ilansang nu sikandin te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te pegkakita ni Pilatu ne warad e egkeyimu rin piru nasi e mule egkasamuk ka me etew, migkuwe e sikandin te weyig wey migpanlu-lu sikandin diye te tangkaan te me etew ne migkahi, “Ware labet ku te kamatayen te seini ne etew! Balahad kew e rue!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne migtabak ka langun ne etew, “Sikanami ka egpanabak duma te me anak ney te kamatayen din.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nataman, impalekaan e ni Pilatu si Barabas, wey impalampesan din si Hisus wey imbehey rin diye te me sundalu eyew iglansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nataman, in-uuyan e si Hisus te me sundalu diye te palasyu te gubirnadur, wey impalibulung dan e ka langun ne duma ran ne me sundalu. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inluungan dan sikandin wey insaluuban dan te kumbale ne malalab-lalab. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne miggimu sikandan te kuruna ne duhi wey impakuruna ran e ki Hisus. Ne impatutuked dan e sikandin ne iyan impahen-gen ka kawanan ne belad din wey migpanimbuel sikandan diye te tangkaan din ka egbaley-baley ne egkahi, “Egmabantug ka Hari te me Hudiyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nataman, mig-iileban dan e si Hisus wey ingkuwa ran ka tuked wey inlelampesan dan ka ulu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pegkapenga ran te egbaley-baley kandin, inluung dan e ka impasaluub dan wey inlibed dan ded ipasaluub ka tapey ne kumbale din. Nataman, in-uyan dan e sikandin diye te lihawangan eyew iglansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te peglihawang dan e, due nasinug-ung dan ne matig-Sirini ne egngaranan ki Simun, ne impepehes dan sikandin patianga te krus ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nataman, miggingume e sikandan diye te inged ne egngaranan te Gulguta (Inged te Angkal ka igpasabut kayi), ");
INSERT INTO mbtNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wey imbebehayan dan e si Hisus te eg-inumen ne binu ne insewuhan te mapeit, piru te naheraman din e seeye, ware din e inuma. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nataman, inlansang dan e si Hisus diye te krus, wey imbaad-baad dan e ka me kumbale din pinaahi te pegpintut-pintut. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pegkapenga dutu, naminnuu e sikandan wey intamengan dan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne due intahu dan diye te ampew te ulu ni Hisus ne keretula ne insulatan te sumbung meyitenged kandin ne migkahi, “Seini si Hisus ka Hari te me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Due daruwa ne takawen ne inlansang dan duma kandin. Ka sabeka diye te igkakawanan din wey ka dangeb diye te igkahibang din. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne seeye se egmanlihad dutu, egmanlengey-lengey ka egbaley-baley ki Hisus ");
INSERT INTO mbtNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ne egkahi, “Ew, sikeykew bes iya ka egguhus te timplu wey igbalew-balew red igpes-ek seled te tatelu re ne aldew! Ke sikeykew ka Anak te Manama, luwasa nu ka pegkeetew nu wey pamaneug ka due te krus.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iling ded degma ka me pangulu te talagpanubad, me talagpanulu te Balaud te Manama, wey me igbuyag te me Hudiyu ne migdali-di kandin ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Inluwas din ka duma, piru kene sikandin egpakaluwas te pegkeetew rin! Sikandin kun ma ka Hari te Israil! Ke egpakapamaneug sikandin kuntee te krus, egpalintutuu kid e wey egsalig kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Migsalig kun sikandin te Manama, ne iyan e balahad ka Manama ne egpangabang kandin ke igkeupii rin, su migkahi sikandin, ‘Anak a te Manama.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne migdali-di ded degma ki Hisus ka me duma rin te inlansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te meudtu e, migmarusilem e ka intiru ne nasud taman te alas tris te maapun. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te alas tris e te maapun, migpanguleyi e si Hisus te meemen ne miggenendue, “Ili, Ili, lima sabaktani?” Ke sikanta pa, “Manama, Manama, mania te in-engkeran a nikeykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te pegkarineg te duma ne me etew ne nanasindeg dutu, migkahi sikandan, “Impangumew rin si Ilyas!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne due-rue ne migpallahuy ka sabeka kandan ne mig-angey te iling te kutsun ne in-eled din te maperes ne binu wey intagkes din diye te geed eyew igpasupsup ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piru migkahi ka duma, “Duen ke pa da, egpitawen ta ke eggendini iya si Ilyas ka egluwas kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nataman, migpanguleyi e man-e si Hisus te meemen, ne dutu nabigtawan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Te seeye de degma ne timpu, nahisi e ka kurtina diye te timplu puun diye te dibabew peendiye te diralem. Ne miglilinug e wey nenaperi e ka me dalama, ");
INSERT INTO mbtNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","wey nenallukatan ka me lebeng, wey neneuyag e ka nenammatey ne keet-etawan te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ne nanlihawang e sikandan te me lebeng dan. Te neuyag e si Hisus, nangendiyad e sikandan te matulus ne siyudad ne Hirusalim wey migpakita sikandan te masulug ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ka kepitan te me sundalu wey ka me duma rin ne migtameng ki Hisus, amana ne naaldek te peglilinug e wey te pegkakita ran te me kein-inuwan ne neyitabu te pegpatey ni Hisus wey migkahi sikandan, “Malehet iya ne Anak te Manama ka sika ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ne due degma masulug ne me malitan ne namipitew diye te bayew madmariyu. Sikandan ka migsinundul wey migtanggu ki Hisus dengan puun pad te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ne dutu ensi Mariya Magdalina, si Mariya ne iney ni Santiyagu wey ni Husi, wey ka iney te me anak ni Sibidiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hengkayi te egkasagkup e, due migginguma ne meyaman ne matig-Arimatiya ne egngaranan ki Husi wey hibateen degma sikandin ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Miggendiye sikandin te ki Pilatu wey imbuyu din ka lawa ni Hisus. Ne migsuhu si Pilatu ne igpabehey e seini diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne in-angey e ni Husi ka lawa ni Hisus wey imbukusan din seini te malinis ne hinabel, ");
INSERT INTO mbtNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wey insabal rin e diye te dalama ne iyam pad neimpusi te eglulungag. Ne miglilid e sikandin te dakel ne batu eyew iglekeb te gumawan te insabalan, wey nataman, miggipanew e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne si Mariya Magdalina wey ka sangey rin, diye migpinpinnuu te egkatangkaan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te seup ne aldew, Aldew te Peggimeley, miggendiye te ki Pilatu ka me pangulu te me talagpanubad wey ka me Parisiyu ");
INSERT INTO mbtNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wey migkahi, “Ahalen, nasuman-suman ney ka ingkahi te ware pad migpatey seeye se talaglimbung ne egkeuyag kun sikandin te igkatelu ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Purisu patamengi nu ka insabalan taman te igkatelu ne aldew su eyew kene egtakawen te me hibateen din ka lawa rin wey egkataman, igpangguhud dan e diye te me etew ne neuyag e sikandin. Ne seini se mewuri ne peglilimbung, egkeyimu ne subla pad ne mareet du te an-anayan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ne migkahiyan sikandan ni Pilatu, “Kuwa kew te me sundalu wey hendiye kew e. Na, paay-ayari niyu naa patamengi kandan ka insabalan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Purisu nangendiyad sikandan wey inniresenan dan ka insabalan pinaahi te pegtahu dan te palinneu diye te batu ne lekeb. Ne nataman, impatamengan dan e. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te peglihad e te Aldew te Peggimeley, te maselem-selem pad te aldew te Duminggu, migleuy te insabalan si Mariya Magdalina wey ka sangey rin ne si Mariya. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ne sahuhune ne miglilinug te mangune-kune, su due panalihan te Magbebaye ne Manama ne miglene puun te langit. Ne miggendiye sikandin te insabalan wey inlilid din ka batu ne insagpeng dutu, wey impinnuuwan din e. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Egpekeiling te layag te kilat ka ulaula rin wey eangkahi ka kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne seeye se me talagtameng, nangelkel te kaaldek dan wey nenaawaan te gimukud. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ne migkahiyan te panalihan ka me malitan, “Kene kew kaaldek! Nakanengneng a ne egpamitawen niyu si Hisus ne inlansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Warad e sikandin kayi su neuyag e sumale te ingkahi rin. Kema hendini kew, tengtengi niyu ka impaley-asan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ne dagdahawi niyu hendiyei ka me hibateen din wey nangeni niyu sikandan te neuyag e sikandin. Miggun-e e sikandin kaniyu diye te Galiliya wey diye niyud e egkakita sikandin. Kene niyu ma kalingawi ka inlaglag ku kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Purisu migdagdahew sikandan mig-awe diye te insabalan ne nenaaldek piru nahale-gale degma, wey namallahuy sikandan ka egpangguhud diye te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te diye pad sikandan te deralanen, sahuhune ne miglambag si Hisus kandan wey migkahi, “Meupiya red.” Ne migparani sikandan ki Hisus wey inggen-genan dan ka paa rin wey insimba ran e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nataman, migkahiyan sikandan ni Hisus, “Kene kew kaaldek! Hendiye kew e wey nangeni niyu ka me suled ku ne egpeendiyeen te Galiliya wey diya ad egkakita nikandan.” ");
INSERT INTO mbtNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te sasangan e ka me malitan ne egmangipanew, due duma ne talagtameng te insabalan ne nangendiye te siyudad wey impangguhud dan diye te me pangulu te me talagpanubad ka langun ne neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ne miglibulung e ka me pangulu te me talagpanubad duma te me igbuyag, wey nakaplanu e sikandan ne egbehayan te dakel ne seleppi ka me sundalu. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Migkahiyan dan ka me sundalu, “Pangguhuri niyu ka me etew te nangendiye te marusilem ka me hibateen din wey intakew ran ka lawa rin taheed te nenewulep kew. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne emun ke egkarineg seini te Gubirnadur, iyan key e balahad ka egpasabut kandin ne warad e likes ne igkalaggew niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Purisu indawat dan ka seleppi wey intuman dan ka igpeyimu kandan. Minsan kuntee, sika iya ne guhuren ka in-empet ipangguhud te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ne seeye se sapulu wey sabeka (11) ne hibateen din, nangendiye te Galiliya diye te bubungan ne ingkahi ni Hisus ne egpeendiyaan kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te pegkakita ran kandin, insimba ran e sikandin piru migduwa-ruwa ka duma. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ne migparani si Hisus diye te kandan wey migkahi, “Imbehey kayi te keddiey ka langun ne katenged diye te langit wey kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Purisu hendiyei niyu ka me etew te langun ne inged wey himuwa niyu sikandan ne me hibateen ku. Bewutismuwi niyu sikandan te ngaran te Amey, te Anak, wey te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Panulua niyu sikandan ne egtuman te langun ne insuhu ku kaniyu. Ne tantanuri niyu ne egdumaan ku iya sikaniyu layun, taman te katammanan te timpu.”");
INSERT INTO mbtNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Seini ka Meupiya ne Panugtulen meyitenged ki Hisu Kristu ne anak te Manama, ne migbunsud ");
INSERT INTO mbtNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","sumale te impasulat te Manama ki prupita Isayas, “Igpewun-a ku keykew ka suluhuanen ku ne iyan eg-andam te egbayaan nu. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Due egpanguleyi diye te mammara ne inged ne kene egkeugpaan ne egkahi: ‘Andama niyu ka dalan te Magbebaye. Tul-ira niyu ka egbayaan din!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ne natuman sika te pegginguma ni Huwan diye te mammara ne inged ne kene egkeugpaan ne migpamewutismu wey migwali ne migkahi, “Inniyuhi niyu ka me sale niyu wey pabewutismu kew eyew egpasayluwen te Manama ka me sale niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne nangendiye te kandin ka masulug ne me etew puun te Hirusalim wey ka me etew puun diye te langun ne lungsud te prubinsya te Hudiya. Ne nekegsendit e sikandan wey impangguhud dan e ka me sale dan, wey imbewutismuwan e sikandan ni Huwan diye te weyig ne Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ne ka kumbale ni Huwan, innimu ligkat te bulbul te kamilyu wey ka sinturun din innimu ligkat te laplap te ayam. Ne talangas de wey teneb ka egkeenen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne migwali sikandin ne miggenendue, “Due egpakasinundul keddi ne subla pad ne maresen keddiey. Ne kena a ne likes ne eg-usengul ka eggekad te hiket te sandal din. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Egbewutismu a kaniyu te weyig, piru sikandin ka egbewutismu kaniyu te Panisingan te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te seeye ne timpu, miggendiye te ki Huwan si Hisus ne diye egpuun te Nasarit ne sakup te prubinsya te Galiliya. Ne dutu imbewutismuwan e sikandin ni Huwan diye te weyig ne Hurdan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te peggakap e ni Hisus, sahuhune ne nakita rin ka langit ne nalukatan wey miglene ka Panisingan te Manama diye te kandin ne egpekeiling te seleppati. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne due laheng ne egpuun diye te langit ne migkahi, “Sikeykew ka pinalangge ku ne Anak. Amana a nahale keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ne due-rue ne impeendiye sikandin te Panisingan te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne diye sikandin tintala ni Meibulan seled te hep-at ne pulu (40) ne aldew. Due degma me mabbulut ne mahintalunan diye piru intanggu sikandin te me panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te naprisu e si Huwan, miggendiye si Hisus te Galiliya ne migwali te Meupiya ne Panugtulen ne egpuun te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Migkahi sikandin, “Miggingume e ka timpu ne intagne dengan. Mahaan e ka Peghari te Manama. Inniyuhi niyu ka me sale niyu wey palintutuu kew te Meupiya ne Panugtulen!” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te peglihad ni Hisus diye te ilis te Lanew te Galiliya, nakita rin si Simun wey ka suled din ne si Andris ne migpamiyale, su mangngengalap ma sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne migkahiyan ni Hisus sikandan, “Ikul kew keddiey wey eggimuwen ku sikaniyu ne mangngengalap te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ne due-rue ne mig-engkeran dan ka me biyale dan wey mig-ikul e kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Te pegpabulus ni Hisus diye te kewun-aan, nakita rin si Santiyagu wey ka suled din ne si Huwan ne me anak ni Sibidiyu. Diye sikandan te balangey ran ka egpanupak te me biyale dan, ");
INSERT INTO mbtNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","wey due-rue ne in-umew sikandan ni Hisus. Ne in-engkeran dan e ka amey ran diye te balangey duma te me suluhuanen ne inakat dan te egpamiyale wey mig-ikul e sikandan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ne miggendiye ensi Hisus te Kapirnaum. Te pegginguma te Aldew te Peggimeley, migseled si Hisus diye te simbaan te me Hudiyu wey migpanulu te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ne neinu-inu ka me etew te kandin ne pegpanulu su due geem te pegpanulu din, wey kene ne iling te me talagpanulu te Balaud te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Due-rue ne miglepew diye te simbaan ka etew ne migserepan te busew ne migbalbalukan ");
INSERT INTO mbtNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ne migkahi, “Hisus ne matig-Nasarit! Nekey-a ka eggimuwen nu kayi te kanami? Iyan nu innendini ka egdereet kanami? Nekeila a keykew; sikeykew ka Matulus ne Impeuyan te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Piru insaparan sikandin ni Hisus te migkahi, “Peeneng-eneng ka wey awe ka due te kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ne dutu, in-umaan e te busew ka etew ne egbabuyen e, ne migpanguleyi te meemen wey mig-awe e ka busew diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne neinu-inu sikandan langun dutu ne migmein-inseey ka tagse sabeka ne miggenendue, “Nekey buwa seini? Iyam seini ne pegpanulu ne due geem! Minsan ka me busew egpalintutuu te me suhu din!” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ne puun dutu, mahaan de nekeempet te intiru ne prubinsya te Galiliya ka guhuren meyitenged ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ne dutu, miglihawang e sikandan te simbaan te me Hudiyu wey miggendiyad e te baley enni Simun wey Andris. Migduma degma ensi Santiyagu wey si Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Miggibat-hibat ka malitan ne anuhang ni Simun su miglusungan, wey te sikan de innangenan dan e si Hisus meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ne indugpu ni Hisus ka malitan wey miggen-genan din ka belad wey impeenew rin e. Ne due-rue ne neulian e ka malitan wey intanggu rin e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te seeye ne maapun, te miglineb e ka aldew, impanguyan te me etew diye te ki Hisus ka langun ne migmanderalu wey ka migpanerepan te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne susuluhi ne me etew te seeye ne siyudad ka miglibulung diye te lama te baley. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne impamawian ni Hisus ka masulug ne egmanderalu te nalein-lein ne egmanggeramen dan, wey impangalew rin degma ka masulug ne me busew piru ware din palalaha tenged su nekeila sikandan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te sikan pad egkasi-si ka kaliwaswasan, mig-enew e si Hisus wey miggendiyad e te inged ne ware etew, ne diye mig-ampu sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ne impammitew e sikandin enni Simun. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te nakita ran e si Hisus, ingkahiyan dan e, “Egpammitawen ka te langun ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ne ingkahiyan din sikandan, “Na, kuwa kid su eggendiye ki te marani ne me lungsud eyew egpakawali a degma diye, su seini iya ka innendini ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne in-empet din te pegwali ka me simbaan te me Hudiyu wey te pegpangalew te me busew ka intiru ne Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ne due ibungen ne migparani ki Hisus ne migpanimbuel wey migpeyid-u-hid-u ne migkahi, “Ke egkeupian ka, egkabawian a nikeykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Neyid-u si Hisus te etew, seeye naa ingketeng din ka belad din wey insamsam din e ka etew te migkahi, “Uya, igkeupii ku. Egkeulian ka!” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ne due-rue ne naawe ka ibung din, wey neulian e iya sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ne impeyipanew e ni Hisus ka etew wey inteesan pegpeheti ");
INSERT INTO mbtNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","te migkahi, “Kene nu ipangguhud seini te minsan hentew. Ke kene, hendiye ka te talagpanubad wey papitew ka kandin ne warad e ka dalu nu, wey panubad ka sumale te insuhu ni Muwisis eyew te pegpamalehet te me etew ne neulian kad e.” ");
INSERT INTO mbtNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piru miggipanew ka etew wey nasi iempet iwangal-wangal ka neyitabu diye te kandin. Sikan naa, kenad e egpahawa-hawa si Hisus ne eggendiye te me lungsud. Ne diye naan de sikandin mig-ugpe te inged ne ware mahinged, piru nasi nangendiye te kandin ka me etew ne migpuun te nalein-lein ne me inged. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Peglihad te pila ne aldew, miglibed e si Hisus diye te Kapirnaum wey nahuhud e ne diyad e sikandin te baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ne miglibulung ka masulug ne me etew wey migsekel e sikandan minsan ka diye te gumawan. Ne migpangguhud e sikandin te lalag te Manama diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Due hep-at ne etew ne nanginguma ne migyayung te etew ne kene egkaweil se lawa. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne tenged te kasulug te me etew, ware sikandan nakaparani ki Hisus. Ne migweil-weil sikandan, inlungahan dan ka atep ne lenged ni Hisus. Ne hengkayi te nakalulungag e sikandan, intuntun dan e ka etew ne kene egkaweil se lawa ne impeyibat diye te hibatanan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te pegkakita ni Hisus ne dakel ka pegpalintutuu ran, migkahiyan din e ka kene egkaweil se lawa, “Tatu, impasaylu e ka me sale nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ne due me talagpanulu te Balaud te Manama ne naminnuu diye wey nekeinse diye te geyinawa ran, ");
INSERT INTO mbtNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mania te egpakalalag seini ne etew te iling due? Egbaley-baley sikandin te Manama! Ware etew ne egpakapasaylu te me sale, su ka Manama re!” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ne due-rue ne natahaan ni Hisus ka me suman-suman dan wey migkahiyan din sikandan, “Mania te egsuman-suman kew te iling due? ");
INSERT INTO mbtNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hendei bes ka malemu, ka egkahi diye te etew ne kene egkaweil se lawa, ‘Impasaylu e ka me sale nu,’ wey ke egkahi, ‘Enew ka, uyana nu ka hibatanan nu wey hipanew kad?’ ");
INSERT INTO mbtNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Piru igpapitew ku kaniyu ne due katenged te Anak te Etew kayi te ampew te tane te pegpasaylu te me sale.” Ne migkahiyan din ka etew ne kene egkaweil se lawa, ");
INSERT INTO mbtNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Enew ka, wey uyana nu ka hibatanan nu wey uli kad e diye te kaniyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ne due-rue ne migsasindeg sikandin ne insabilbil rin e ka hibatanan din wey mig-awe e ne diye migbaye te tangkaan te langun ne etew. Nawangalan ka langun wey indayan dan ka Manama ne migkahi, “Ware key re due nakakita te iling kayi!” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nataman, miglibed e man-e si Hisus diye te ilis te Lanew te Galiliya. Ne miglibulungan sikandin te masulug ne me etew, ne dutu impanulu din e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Te sasangan e sikandin ka eggipanew, due nakita rin ne egngaranan ki Libi ne anak ni Alpiyu ne migpinpinnuu diye te upisina rin ne bayaranan te buhis. Migkahiyan ni Hisus sikandin, “Ikul ka keddiey.” Ne migsasindeg sikandin wey mig-ikul e ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nataman, migkeen si Hisus diye te baley ni Libi. Ne due masulug ne me talagsukut te buhis wey me makasesale ne miglagpu kandin te migkeen duma te me hibateen din tenged su masulug sikandan ka naninundul kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te pegkakita te me Parisiyu ne me talagpanulu te Balaud te Manama ne miglagpu migkeen si Hisus te me makasesale wey te me talagsukut te buhis, mig-insaan dan e ka me hibateen din te migkahi, “Mania te miglagpu migkeen sikandin te me talagsukut te buhis wey te me makasesale?” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te pegkarineg dutu ni Hisus, migkahiyan din e sikandan, “Ka me etew ne ware dalu, kene egkeilangan te talagbawi, ke kene, seeye de se egmanderalu. Wara a miggendini eyew te peg-umew te me matareng, ke kene, te me makasesale.” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Due timpu ne migpuasa ka me hibateen ni Huwan wey ka me Parisiyu. Ne due me etew ne migparani ki Hisus wey mig-inse kandin, “Mania te egpuasa ka me hibateen ni Huwan wey ka me hibateen te me Parisiyu, piru ware mule ka me hibateen nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ne migtabak si Hisus, “Egkaayun naa ne egpuasa ka me mahaliyug te egpangasawa ke duma ran pad sikandin? Kene iya egkaayun ne egpuasa sikandan ke duma ran pad ka egpangasawa! ");
INSERT INTO mbtNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piru egginguma ka timpu ne eg-angayen e diye te kandan ka egpangasawa, ne egpuase e sikandan te seeye ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ne ware etew ne egtutupak te iyam ne manggad diye te tapey ne kumbale, su ke eggimuwen din sika, egkenseng ka intupak wey egkakatkat e ka inteyian wey nasi e egmaluag ka gisi. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne ware degma etew ne egtahu te iyam ne binu diye te tapey ne tahuanan ne laplap te mananap, su ke eggimuwen din sika, egbetu ka tahuanan wey egkeitis e ka binu ne egkareetan e degma ka tahuanan. Ke kene, ka iyam ne binu, keilangan ne diye igtahu te iyam ne tahuanan ne laplap te mananap.” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te sabeka ne Aldew te Peggimeley, nangipanew ensi Hisus ne diye migbaye te impamulaan te trigu. Taheed te egmangipanew sikandan, nangetu te me trigu ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne migkahiyan si Hisus te me Parisiyu, “Pitawa nu! Mania te miggimu ka me hibateen nu te supak te Balaud te Aldew te Peggimeley?” ");
INSERT INTO mbtNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ne migtabak si Hisus diye te kandan, “Ware kew bes nakasabut te imbasa niyu meyitenged te innimu ni Dabid te miggutasan sikandan te me duma rin su warad egkeenen dan? ");
INSERT INTO mbtNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te timpu ne si Abiyatar pad ka Labew ne Talagpanubad, migseled si Dabid diye te baley te Manama wey migkeen te paan ne inhalad e diye te Manama. Ne sumale te kanta ne Balaud, ka me talagpanubad de ka intuhutan ne egpakakeen dutu, piru migkeen si Dabid wey impamehayan din pad ka me duma rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Su innimu ka Aldew te Peggimeley eyew egpakabulig te etew, ne ware himuwa ka etew eyew egtuman te me balaud te Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Purisu ka Anak te Etew iyan ahalen minsan Aldew te Peggimeley.” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Te lein e ne timpu, migseled e man-e si Hisus diye te simbaan te me Hudiyu. Due sabeka ne etew dutu ne nakengkeng se belad. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ne due me etew ne eg-iipat ki Hisus ke egbawian din te Aldew te Peggimeley seeye se etew su eyew igkasumbung dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ne migkahiyan ni Hisus ka etew ne nakengkeng se belad, “Sasindeg ka kayi te tangkaan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne mig-inse si Hisus diye te kandan, “Nekey bes ka intuhut te kanta ne Balaud ne eleg ne eggimuwen ta te Aldew te Peggimeley? Ka pegbulig naa wey ke pegdereet? Ka pegluwas naa wey ke peggimatey?” Piru ware sikandan migtabak. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ne dutu, nabelu e si Hisus ka migpanil-ap-sil-ap kandan. Migmasakit se geyinawa rin tenged su makehal ka me ulu ran. Ne migkahiyan din ka etew ne nakengkeng se belad, “Ketenga nu ka belad nu.” Ne ingketeng te etew wey neulian e ka belad din. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ne nanlihawang e ka me Parisiyu, wey migbunsud e sikandan ka egplanu duma te me sakup ni Hari Hirudis ke egmenuwen dan te eggimatey si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ne migparumeey ensi Hisus te me hibateen din diye te lanew. Naninundul kandin ka amana ne susuluhi ne etew ne diye egpuun te Galiliya wey te Hudiya, ");
INSERT INTO mbtNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","wey ka diye degma egpuun te Hirusalim, te Idumiya wey diye te deyipag te Hurdan wey minsan ka diye te me inged ne marani te Tiru wey te Sidun, su nakarineg sikandan te langun ne innimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ne puun due, migkahiyan din ka me hibateen din ne egpaandamen te balangey ne eg-unturan din, su eyew kene sikandin egkapinpiniet te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Puun su masulug ne etew ka impamawian din, egmekegsegseg e ka egmanderalu ne egparani kandin eyew egsamsam kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne emun ke egpakakita ki Hisus ka me etew ne nanerepan te me busew, sahuhune ne eg-usengul sikandan diye te tangkaan din wey egmanguleyi ne egkahi, “Sikeykew ka Anak te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ne impegpehetan din sikandan teesi ne kene egpepangguhuren meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nataman, migtakereg e si Hisus diye te bubungan. Ne in-umew rin seeye se ingkeupii rin wey migparani sikandan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ne mig-alam sikandin te sapulu wey daruwa (12) ne apustulis su egdumdumeen din wey eyew egsuhuen te pegwali. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne imbehayan din sikandan te katenged te pegpangalew te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Seini ka sapulu wey daruwa (12) ne in-alam din: si Simun ne mig-immuan din ki Pidru, ");
INSERT INTO mbtNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ka talaari ne si Santiyagu wey si Huwan ne me anak ni Sibidiyu. Ingngaranan sikandan ni Hisus te Buwanirgis, ka igpasabut “Me anak te Luhung”; ");
INSERT INTO mbtNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andris wey si Pilipi, si Bartulumi wey si Matiyu, si Tumas wey si Santiyagu ne anak ni Alpiyu, si Tadiyu wey si Simun ne ribildi, ");
INSERT INTO mbtNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","wey si Hudas Iskaryuti ne mig-akal kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te peg-uli e enni Hisus diye te baley, duen e man-e masulug ne me etew ne nanlibulung, ne puun due, kenad e sikandan egpakakeen. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te pegkarineg dutu te pamilya ni Hisus, miggendiyad sikandan ka eg-angey kandin su egkahiyen e te me etew ne egbusawen e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne due me talagpanulu te Balaud te Manama ne migginguma puun te Hirusalim ne migkahi, “Inserepan sikandin ni Meibulan ne pangulu te me busew, wey imbehayan te geem te pegpangalew te me busew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ne impeparani sikandan ni Hisus wey impangguhuran pinaahi te me panunggilingan te migkahi, “Egmenuwen ni Meibulan te eg-alew te duma rin? ");
INSERT INTO mbtNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Emun ka sabeka ne inged egmeun-unayey egmeeg-ehetey ka me etew, kene iya egpakasasindeg ka sika ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne emun ka taltalaanak egmeun-unayey egmeeg-ehetey, kene iya egpakasasindeg ka sika ne taltalaanak. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ne emun ke eg-unayen e ni Meibulan te egkuntere ka me sakup din wey egkabaad-baad e, kene iya sikandin egpakasasindeg, ke kene, egkataman e ka pegmandu din. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ware egpakaseled diye te baley te manekal ne etew wey egpakaahew te me kasangkapan din ke kene din pad eggun-aan te egbaku ka kamuney. Ke egkabaku din e ka kamuney henduen din pad egkaahew ka me kasangkapan. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Egnangenan ku sikaniyu te malehet: egkaayun ne egpasayluwen ka me etew te langun ne me sale dan wey te minsan nekey ne pegbaley-baley ran te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Piru minsan hentew ne egbaley-baley te Panisingan te Manama, kene iya egpasayluwen, su kene egkapasaylu te ware egtamanan ka seini ne sale.” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nakahi rin sika tenged su migkahi sikandan te migserepan e sikandin te busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nataman, nangingume e ka iney ni Hisus wey ka me suled din. Ne diye de sikandan nanasindeg te lihawangan te baley wey migpanaha re ne egpalihawangen sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Amana ne masulug ka me etew ne namminnuu ne nakalingut ki Hisus. Ne migkahi sikandan, “Diye te lihawangan ka iney nu wey ka me suled nu ne egpammitew keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ne migkahi si Hisus, “Nakataha kew naa ke hentew ka iney ku wey ka me suled ku?” ");
INSERT INTO mbtNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne impanil-ap-sil-ap ni Hisus ka me etew ne naminnuu ne nakalingut kandin te migkahi, “Seini ka iney ku wey ka me suled ku! ");
INSERT INTO mbtNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ka minsan hentew ne eggimu te igkeupii te Manama, iyan sika ka iney ku, ka suled ku, wey ka atebey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ne mig-abey e man-e migpanulu si Hisus diye te ilis te lanew. Ne susuluhi ne etew ka miglibulung diye te kandin, ne tenged dutu mig-untud e sikandin te balangey ne diye te lanew wey diye migpinnuu. Ne ka langun ne etew diye de te ilis te lanew. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Masulug ka impanulu ni Hisus kandan ne impabaye din te me panunggilingan. Migkahi sikandin te pegpanulu din: ");
INSERT INTO mbtNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pammineg kew! Due sabeka ne etew ne miggendiye te kamet eyew egpamula. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te pegpanawed din e te beni, due nakasawed diye te dalan, ne migginguma ka me manuk-manuk wey impanuktuk e seeye. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ne ka duma ne beni diye nakasawed te batuwen ne ware amana tane. Ne mahaan de seeye migtubu su manipis ka tane. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Piru te naaldawan e, nahangu e seeye su ware amana nakareralid. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka duma ne beni nakasawed diye te duhiyen. Ne nanubu ka me duhi wey naselung e ka pinamula, sikan naa ka warad nakabebehas. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka duma ne beni, diye nakasawed te meupiya ne tane wey migtubu e. Ne migdakel e wey migbebehas, ne due duma ne beni ne migbebehas te tatelu ne pulu (30), due duma ne keen-eman ne pulu (60), wey due degma migbebehas te sabeka ne gatus (100).” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne migkahi si Hisus, “Purisu, ke egkeupian kew ne egpakasabut, sumsumana niyu ay-ayari ke nekey ka narineg niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te nangawe e ka susuluhi ne etew, mig-insaan e sikandin te sapulu wey daruwa (12) ne hibateen din wey te seeye se miglingut kandin meyitenged te kaluwasan te me panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne migtabak si Hisus, “Impatahe e diye te kaniyu ka inggeles meyitenged te Peghari te Manama; piru diye te duma, impabaye seini langun pinaahi te me panunggilingan, ");
INSERT INTO mbtNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","su eyew, ‘minsan egtengteng sikandan, kene egpakakita, wey minsan egpammineg sikandan, kene egpakasabut. Su emun ke egpakasabut sikandan, kema ke eglibed sikandan diye te Manama, wey egpasayluwen sikandan.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne migkahiyan ni Hisus sikandan, “Ke ware kew nakasabut te kaluwasan te seeye ne panunggilingan, egmenuwen niyu naan pad te egsabut ka duma ne me panunggilingan? ");
INSERT INTO mbtNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ka insawed te talagpamula, iyan ka lalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ne seeye se beni ne nakasawed diye te dalan, iyan seeye se me etew ne nakarineg te lalag te Manama. Piru sahuhune ne migginguma si Meibulan wey in-ahew rin e ka lalag ne nakapamula diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne iling ded seeye se beni ne nakasawed diye te batuwen, iyan seeye se me etew ne nakarineg te lalag te Manama ne due-rue ne migdawat kayi ne nahale. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piru ware seini nakareralid diye te pusung dan, purisu ware de naluhey ka pegpalintutuu ran. Nataman, te pegginguma te me keyirapan wey me pegbayad-bayad tenged te lalag te Manama, due-rue ne mig-engked sikandan te pegpalintutuu ran. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ne ka duma ne beni ne nakasawed diye te duhiyen, iyan seeye se nakarineg te lalag te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","piru ka pegkalaggew ran meyitenged te peg-ugpe dan, wey ka peggeyinawa te me karatuan dan wey ka pegkeeyami te duma pad ne me kasangkapan, iyan nekeumes te lalag te Manama, wey ware sikandan nakabebehas. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Piru ka beni ne nakasawed diye te meupiya ne tane, iyan seeye se me etew ne nakarineg te lalag te Manama ne migdawat wey migbebehas. Ka sabeka nakabebehas te tatelu ne pulu (30), ne ka duma nakabebehas te keen-eman ne pulu (60), ne ka duma nakabebehas te sabeka ne gatus (100).” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ne migkahiyan din sikandan, “Ware egparekket te sulu ne egsuuban te gantangan wey ke diye igtahu te selib te lantawan. Ke kene, igpatawan-tawan iya igtahu. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Su ware iggeles ne kene egkanengnengan; wey ware egbunbunan ne kene egkalekisan. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Purisu, ke egkeupian kew ne egpakasabut, sumsumana niyu ay-ayari ke nekey ka narineg niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne migkahiyan pad man-e sikandan ni Hisus, “Sikan naa, tantanuri niyu ke nekey ka egkarineg niyu. Su emun ke eg-ayad-ayad kew egpammineg, egpakasabut kew iya, wey egtimulan pad sika te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Su seeye se due katuenan, egtimulan pad piru seeye se deisek de se katuenan, eg-angayen pad iya minsan ka deisek ne kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ne migkahi pad man-e sikandin, “Ka Peghari te Manama egpekeiling te pangguhuren meyitenged te etew ne migsawed te beni diye te kamet din. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Taheed te migpabulus sikandin te himu rin te maaldew wey te peglipereng din te marusilem, migtubu ka beni wey migtulin. Piru ware din nataheyi ke immenu te egtulin. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ka tane ka egpabehas te me pinamula, eggun-a egtubu ka dewun, ne egbebehas e, ne egkataman egmatesan e. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Emun ke egkeyinuhan e ka pinamula, eggalaben e te kamuney tenged su tinggaani e.” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne mig-inse si Hisus, “Nekey-a ka egpeilingan ta te Peghari te Manama, wey ke nekey ne panunggilingan ka eggamiten ta kayi? ");
INSERT INTO mbtNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Egpekeiling seini te beni te mustasa ne mallilintek ne impamula te etew diye te kamet din. Ka sika ne beni iyan kinareisekan kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piru ke igpakapamule e sika wey ke egtubu e, egkeyimu e sika ne kinarakelan te langun ne me pinamula. Egderakel e ka me sugpang wey egsesalag e ka me manuk-manuk diye te egdalungan ne me sugpang din.” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ne masulug pad ne me panunggilingan ne iling kayi ka inggamit ni Hisus te pegpanulu din te lalag te Manama diye te me etew ne sumale de te egkasabut dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ne ware inlalag din diye te me etew ne ware din ipabaye te panunggilingan. Piru igpasabut din ded ka langun diye te me hibateen din ke sikandan naan de. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te egkasagkup e te sika ne aldew, migkahiyan e ni Hisus ka me hibateen din, “Kuwa kid e su eglapas ki seeye te deyipag te lanew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne dutu mig-engkeran e te me hibateen ka masulug ne me etew wey nanguntud e sikandan te balangey ne in-unturan ni Hisus. Ne due degma me balangey ne miglegse kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ne due migginguma ne dakel ne kalamag wey imbundul-bundul e te bunlud ka balangey wey hapit e egkapenu te weyig. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Piru newulep si Hisus ne mig-uulunan diye te lebut te balangey. Ne dutu, impupukew e sikandin te me hibateen din wey ingkahiyan, “Talagpanulu, kene ka egkalaggew te hapit kid ma egkalened?” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ne mig-enew si Hisus ne insaparan din ka kalamag wey migkahiyan din ka me bunlud, “Peeneng-eneng kew!” Ne dutu, migsanggel e ka kalamag wey migpeeneng-eneng e ka me bunlud. ");
INSERT INTO mbtNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne migkahiyan din sikandan, “Mania te nenaaldek kew? Ware bes pegpalintutuu niyu wey pegsalig?” ");
INSERT INTO mbtNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ne neinu-inu sikandan wey migmein-inseey ne migkahi, “Hentew buwa etawa seini? Minsan se kalamag wey me bunlud ne egpalintutuu kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ne migpabulus sikandan diye te deyipag te lanew, te inged ne Girasa. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te peglegsad e ni Hisus te balangey, sahuhune ne due migsinug-ung kandin ne etew ne inserepan te busew ne diye migpuun te me sulung ne sabalanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ka seini ne etew diyad e mig-ugpe te sabalanan wey warad en iya egpakabaku kandin minsan egkeddinaan pad. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Malasi egbakua te me etew ka belad din wey paa rin te keddina, piru impamigtus din de ka keddina wey ka baku. Ne warad en iya likes ne egpakaleheng kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Egleug-leug sikandin aldew wey marusilem diye te me sabalanan wey diye te me bubungan ne egpangpanguleyi wey egpamalpalian din ka lawa rin te me batu. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te pegkakita rin ki Hisus te diye pad te madmariyu, migpallahuy sikandin ka migsinug-ung kandin wey migpanimbuel diye te tangkaan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ne migpanguleyi sikandin te meemen ne migkahi, “Hisus, Anak te Amana ne Mabantug ne Manama, kena a nikeykew banggawa! Te ngaran te Manama, egpeyid-u-hid-u a keykew ne kena a legpari!” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Inlalag din sika tenged su insuhu ni Hisus ka busew ne migkahi, “Busew, awe ka rue te kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne mig-insaan e ni Hisus sikandin, “Hentew-a ka ngaran nu?” Ne migtabak sikandin, “Matangen ka ngaran ku, tenged su masulug key.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne amana iya ne migpeyid-u-hid-u ka me busew diye te ki Hisus ne kene egpaaween te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne diye te bayew madmariyu, due masulug ne me babuy ne migpanuwal diye te masandig. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Migpeyid-u-hid-u diye te ki Hisus ka me busew ne migkahi, “Paserepa key ubag nikeykew diye te me babuy.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne intuhutan e sikandan ni Hisus. Seeye naa, mig-awe e ka me busew diye te etew wey nanerep e diye te me babuy. Ne namallahuy e ka me babuy patupang diye te dalama peendiye te lanew wey nallened e. Me daruwa ne libu (2,000) ka kasuluhan te me babuy. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ne namallahuy seeye se me talagtameng te babuy diye te siyudad wey diye te me kamet ka migpangguhud. Ne nangendiye ka me etew eyew egnengneng ke nekey ka neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Migparani sikandan ki Hisus wey nakita ran ne migpinnuu diye ka etew ne inserepan te masulug ne busew. Migkukumbale e sikandin wey maheteng e ka suman-suman din. Ne tenged due, nenaaldek e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne sikandan se nakakita te neyitabu te etew ne inserepan te me busew wey te neyitabu te me babuy, migpangguhud e diye te duma. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne puun dutu, migpeyid-u-hid-u e ka me etew ki Hisus ne egpaaween dutu te inged dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne hengkayi te eg-untud e si Hisus te balangey, migpeyid-u-hid-u seeye se etew ne migserepan te me busew ne egduma kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piru ware sikandin parumaa ni Hisus wey migkahiyan, “Uli kad e diye te kaniyu wey pangguhuri nu sikandan te langun ne innimu te Magbebaye due te keykew wey te keyid-u rin keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne miggipanew e ka etew wey migbunsud e migpangguhud diye te inged ne egngaranan te Dikapulis meyitenged te langun ne innimu ni Hisus diye te kandin, wey neinu-inu ka langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nataman, miglapas e man-e si Hisus diye te deyipag te lanew ne mig-untud te balangey. Te diyad e sikandin te ilis te lanew, miglibulungan e sikandin te susuluhi ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ne due migginguma ne sabeka te me pangulu te simbaan te me Hudiyu ne egngaranan ki Hayru. Te pegkakita rin ki Hisus, migpanimbuel sikandin diye te tangkaan din ");
INSERT INTO mbtNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","wey amana migpeyid-u-hid-u ne migkahi, “Egkabigtawan e ka anak ku ne beyi-beyi. Hendiyei nu pa ubag sikandin wey tel-ebi nu te belad nu eyew egkeulian wey egmanekal e.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ne migdume e si Hisus kandin. Ne dutu, amana ne susuluhi ka me etew ne migsinundul kandin ne egmemekegtuku e diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne due malitan ne eglangeseen seled e te sapulu wey daruwa (12) ne leg-un, ");
INSERT INTO mbtNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ne amana ne nabaybayaran ka migpabawi te me talagbawi piru ware sikandin neulii. Ne naamin de due ka langun ne diye te kandin, piru nasi de iya sikandin lahetleti te dalu rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nakarineg sikandin te guhuren meyitenged ki Hisus, purisu migpatalisek sikandin te masulug ne me etew ka migparani diye te peka ni Hisus wey insamsam din ka kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Su nekeisip sikandin, “Emun ke egpakasamsam a minsan te kumbale din de, egkeulian a iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te pegsamsam te malitan te kumbale ni Hisus, due-rue ne migtigpek ka langesa rin wey naheram din te lawa rin ne neulian e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ne due-rue ne nakaheram si Hisus ne due geem ne naawe diye te kandin, ne seeye naa ka miglilingey sikandin diye te masulug ne etew ne mig-inse, “Hentew-a ka migsamsam te kumbale ku?” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ne migtabak ka me hibateen din, “Pitew ke man de iya te masulug ne me etew seini ne egmasegsehey e due te keykew, ne mania te eg-inse ke pad ke hentew-a ka migsamsam keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piru migpalangas-langas si Hisus ka egpammitew ke hentew ka migsamsam kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne tenged su nanengnengan te malitan ke nekey ka neyitabu kandin, migparani sikandin ki Hisus ne migkelkel te kaaldek wey mig-usengul diye te tangkaan din wey ingguhud din e ka malehet. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne migkahiyan ni Hisus sikandin, “Beyi, ka pegpalintutuu nu ka nekeuli keykew. Uli ka ne meupiye e se geyinawa. Kene kad egliberan te dalu nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te sasangan pad ne eglalag si Hisus, due me etew ne migginguma ne diye egpuun te baley ni Hayru. Migkahiyan dan si Hayru, “Migpatey e ka anak nu. Kema ke egkabanggew nu re ka talagpanulu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piru imbalahad ni Hisus ka ingguhud dan wey migkahiyan din si Hayru, “Kene ka egkalaggew. Palintutuu ke re.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne ware migduruma sikandin gawas engki Pidru wey te tahasuled ne ensi Santiyagu wey Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te pegginguma ran diye te baley te pangulu te simbaan te me Hudiyu, nakita ni Hisus ne newukag ka me etew. Ne due egmaninehew wey egmandalawit. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne migseled e si Hisus te baley wey migkahiyan din sikandan, “Mania te egkengewukag kew wey egmandalawit? Ware migpatey ka beyi-beyi su nakalipereng de sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Piru migdali-dian dan si Hisus. Ne dutu, impalihawang e sikandan langun ni Hisus wey induma rin ka amey wey iney te bate wey ka me hibateen din te migseled diye te impaley-asan te bate. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne miggen-genan din ka belad te bate te migkahi, “Talita kumi!” Ka buut igpasabut, “Beyi-beyi, enew ka!” ");
INSERT INTO mbtNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne due-rue ne mig-enew ka beyi-beyi wey miggiphipanew e. Ne dutu, amana sikandan nawangalan. Sapulu wey daruwe (12) e sikandin ne leg-un. ");
INSERT INTO mbtNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Migteesan sikandan pegpeheti ni Hisus te keilangan ne ware minsan hentew ne egpakanengneng te neyitabu. Ne impabehayan din ka bate te egkeenen. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ne mig-awe e si Hisus te seeye ne inged wey mig-uli diye te lungsud ne intulinan din, wey migduma kandin ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te pegginguma te Aldew te Peggimeley, migpanulu si Hisus diye te simbaan te me Hudiyu. Ne masulug ka nakarineg kandin ne neinu-inu ne migkahi, “Hendei rin buwa natueni seini langun? Hendei rin buwa nakuwa ka katuenan din? Immenu rin buwa te eggimu te me kein-inuwan? ");
INSERT INTO mbtNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kene naa ne sikandin ka talagbebaley? Kene naa ne si Mariya ka iney rin, wey kene naa ne ensi Santiyagu, si Husi, si Hudas wey si Simun ka me suled din? Ware naa ne kayi nangugpe ka me atebey rin?” Sikan naa, natameneng e sikandan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ne migkahiyan sikandan ni Hisus, “Egtahuren ka sabeka ne prupita te minsan hendei gawas te inged ne intulinan din, te me karumaan din wey te pamilya rin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Purisu ware nekeyimu si Hisus te me kein-inuwan te seeye ne inged, gawas te pila-pila re ne me etew ne egmanderalu ne intel-eban din te belad din ne neneulian. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne neinu-inu si Hisus te ware migpalintutuu kandin ka me etew. Nataman, miggendiyad e si Hisus te marani ne me bariyu eyew te pegpanulu te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nataman, impeparani rin ka sapulu wey daruwa (12) ne me hibateen din wey impeyipanew rin sikandan te tigdaruwa wey impamehayan din te katenged te pegpangalew te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne impanagtahaan din sikandan ne kene egpeuyanen te minsan nekey gawas te tuked. Kene sikandan egpeuyanen te keenen, kabil, wey te seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Egpasesandalen sikandan piru kene egpeuyanen te eg-ilisan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Migkahiyan pad man-e sikandan ni Hisus, “Emun ke due baley ne egpamaneyikan niyu, diye kew re iya ugpe taman te eg-awe kew e te sika ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ke due inged ne kene egdawat kaniyu wey kene egpammineg kaniyu, pelpela niyu ka alinepung diye te paa niyu ke eg-awe kew e isip palinneu ne ware sikandan ikahale te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sikan naa, nangipanew e sikandan wey migwali te keilangan ne eg-inniyug ka me etew te me sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Masulug ka impangalew ran ne me busew wey masulug ka egmanderalu ne nangitisan dan te lana ne neneulian. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tenged su migmabantug e si Hisus, narineg e ni Hari Hirudis ka guhuren meyitenged kandin. Due duma ne egkahi, “Neuyag ded si Huwan ne Talagbewutismu, sikan naa ka due geem din te peggimu te me kein-inuwan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piru egkahi ka duma, “Sikandin si Ilyas.” Ne ka duma egkahi degma, “Prupita sikandin, iling te sabeka te me prupita dengan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Te pegkarineg dutu ni Hirudis, migkahi e sikandin, “Neuyag bes si Huwan, ka etew ne impatempuhan ku te ulu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Su si Hirudis ka migparakep wey migpaprisu ki Huwan. Innimu ni Hirudis seeye su insaparan sikandin ni Huwan te peg-ahew ki Hirudiyas ne asawa te suled din ne si Pilipi. Miggenendue si Huwan, “Supak te Balaud ni Muwisis ne eg-ahawen nu ka ipag nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ne puun dutu, nabelu si Hirudiyas ki Huwan wey igkeupii rin ne eggimatayan sikandin piru kene din egkeyimu, ");
INSERT INTO mbtNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","su naaldek si Hirudis ki Huwan. Su nakanengneng sikandin ne matareng wey matulus ne etew si Huwan, purisu ware din tuhuti ne eggimatayan sikandin. Amana sikandin nalibeg te guhuren ni Huwan, piru egkeupian sikandin ne egpammineg. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piru migginguma red ka timpu ne egtetaharan ni Hirudiyas. Ne seeye ne aldew ka neetawan ni Hirudis. Migsahakeen si Hirudis wey impanginggat din ka me upisyal din, ka me kepitan te me sundalu, wey ka me pangulu diye te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ne migseled wey migsayew ka anak ni Hirudiyas ne beyi, wey nahale si Hirudis wey ka me mahaliyug din. Ne migkahiyan ni Hirudis ka beyi, “Buyu ka te minsan nekey ne igkeupii nu, su igbehey ku keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne migpahunlibet sikandin te beyi ne migkahi, “Minsan nekey ne egbuyuen nu, igbehey ku keykew minsan pad ka tenge te karatuan ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Miglihawang ka beyi wey mig-inse te iney rin, “Ine, nekey buwa ka egbuyuen ku?” Ne migtabak ka iney rin, “Iyan nu buyua ka ulu ni Huwan ne Talagbewutismu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ne migdagdahew miglibed ka beyi diye te Hari wey migkahi, “Egkeupian a ne igbehey nu keddi kuntee ka ulu ni Huwan ne Talagbewutismu ne diye igtahu te maluag ne pinggan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ne amana nalaggew ka Hari dutu. Piru tenged te nakapahunlibet sikandin wey narineg seeye te me mahaliyug din, kene din igkeupii ne kene egkatuman ka inlalag din diye te beyi. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Due-rue ne migsuhu ka Hari te sundalu ne talaggilang ne igpeuyan ka ulu ni Huwan. Ne miggendiyad e ka insuhu wey intamperan din e te ulu si Huwan diye te prisuwan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Diye din itahu te maluag ne pinggan ka ulu ni Huwan wey imbehey rin diye te beyi, wey imbehey e degma te beyi diye te iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te pegkarineg dutu te me hibateen ni Huwan, nangendiyad e sikandan wey in-angey ran e ka lawa rin wey inlelebeng dan e. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nataman, nanlibed e diye te ki Hisus ka me hibateen din wey impangguhuran dan sikandin te langun ne neyimu ran wey te impanulu dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ne puun su egmekegsubal-subal re ka masulug ne etew, kenad e egpakakeen ensi Hisus. Sikan naa, migkahiyan din e ka me hibateen din, “Kuwa kid e su eggendiye ki te inged ne ware etew eyew egpekeyimeley kew te minsan dagdahew re.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ne nanguntud e sikandan te balangey wey nangendiyad e te inged ne ware etew ne sikandan de. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piru masulug ka me etew ne nekeila kandan te pegligkat dan. Purisu namallahuy ka me etew ne migpuun te nalein-lein ne me lungsud peendiye te eggendiyaan enni Hisus, wey nekewun-a pad sikandan nekeuma kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te peglegsad ni Hisus te balangey, nakita rin ka susuluhi ne etew, wey neyid-u sikandin kandan tenged su nekeiling e sikandan te me karniru ne ware talagtameng. Purisu imbunsuran e sikandan panulua ni Hisus wey masulug ka impanulu din kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ne hengkayi te maapun e, migparani diye te ki Hisus ka me hibateen din wey migkahi, “Maapun e seini wey kayi ki pe ma te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Peendiyaa nu sikandan te marani ne me kamet wey me bariyu eyew egpakabeli te egkakeen dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piru migkahiyan din sikandan, “Sikaniyu ka egbehey kandan te egkeenen.” Ne migkahi sikandan, “Etuwey! Egpeyipanawen key naa nikeykew wey egpabeliyen te paan ne egkentiddad te daruwa ne gatus (200) ne dinaryu eyew igpakeen kandan?” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ne mig-inse sikandin kandan, “Pilaa ne timman te paan ka due te kaniyu? Na, tengtengi niyu.” Te nakita ran e seeye, migkahiyan dan e si Hisus, “Lalimma ne timman ka paan wey daruwa ka ngalap te weyig.” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nataman, impapunduk-punduk e papinnuuwa ni Hisus sikandan langun diye te me hilamunen. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Purisu naminnuu e sikandan ne migpunduk-punduk te tigmahatus (100) wey te tiglalimma ne pulu (50). ");
INSERT INTO mbtNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ne ingkuwa ni Hisus ka lalimma ne malisen ne paan wey ka daruwa ne ngalap te weyig, ne migleng-ag sikandin diye te langit wey migpasalamat te Manama. Nataman, impanepik-tepik din e ka paan wey impamehey rin e diye te me hibateen din eyew igpepamehey diye te me etew. Ne impanalad din ded degma ka me ngalap diye te etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ne nangeen sikandan langun wey nenabulung-bulung, ");
INSERT INTO mbtNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","wey nakalimud pad sikandan te sapulu wey daruwa (12) ne liyang ne napenu te same te paan wey te ngalap te weyig. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Migginguma te lalimma ne libu (5,000) ka kasuluhan te me lukes de ne nangeen te paan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ne due-rue ne impeuntud ni Hisus ka me hibateen din te balangey wey impewun-a rin e diye te inged ne Bitsayda ne diye te deyipag te lanew taheed te impeuli din e ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te nakapanaha-tahe e si Hisus te me etew, migtakereg e sikandin diye te bubungan eyew eg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te marusilem e, diye de due si Hisus ka migsabsabeka. Ne nekeelat-elat e mule te lanew ka balangey. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakita rin ne neyirapan ka me hibateen din ne egpamegsey, su egkasinug-ung dan ka kalamag. Hengkayi te mahaan e egpamalat-palat, innendiyaan e sikandan ni Hisus ne miggipanew diye te kulit te weyig. Egliharan din de perem sikandan, ");
INSERT INTO mbtNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","piru te pegkakita ran kandin ne miggipanew diye te weyig, nakasuman-suman sikandan ne saping seeye wey migmanguleyi e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Naalatan sikandan langun te pegkakita ran kandin. Ne sahuhune ne migkahiyan sikandan ni Hisus, “Pakannekal kew! Kene kew kaaldek su sikeddiey seini!” ");
INSERT INTO mbtNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nataman, mig-untud e si Hisus te balangey duma kandan wey mig-engked e ka kalamag. Ne dutu, amana sikandan neneinu-inu. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Su ware sikandan nakasabut te kaluwasan te innimu rin ne kein-inuwan ne migmasalig ka paan tenged su makehal ka me ulu ran. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te nakalapas e sikandan, diye sikandan nakatuhun te inged ne egngaranan te Ginisarit, ne inniket dan e ka balangey ran diye te ilis te lanew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te peglegsad dan e te balangey, due-rue ne neilaan si Hisus te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Namallahuy ka me etew ne nangendiye te me bariyu ne marani dutu wey nanguyan te egmanderalu ne impeyibat te me hibatanan dan diye te inged ne narinehan dan ne diye si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Minsan hendei eggendiye si Hisus, diye te me bariyu, wey ke diye te me siyudad, wey ke diye te me sityu, egpanguyanen iya te me etew ka egmanderalu wey diye igmeyibat te me palingkiyan. Ne migpeyid-u-hid-u sikandan ki Hisus ne egpasamsamen sikandan minsan te sidsid de te kumbale din. Ne ka langun ne nakasamsam dutu, neulian iya. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Due miglibulung diye te ki Hisus ne me Parisiyu wey me talagpanulu te Balaud te Manama ne diye migpuun te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakakita sikandan te due me hibateen ni Hisus ne migkeen ne ware mig-ayad-ayad migmanlu-lu te me belad dan, wey supak seeye te impanulu dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Su ka me Parisiyu wey ka langun ne me Hudiyu, kene egkeen ke kene egpakaayad-ayad egpakapanlu-lu te me belad dan sumale te tuluuwen te me kaap-apuan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Emun ke egpuun sikandan diye te palingki, kene sikandan egkeen te minsan nekey ke kene sikandan egpakaayad-ayad egpakapanlu-lu. Masalig pad ka tuluuwen ne egtumanen dan iling te pegpanlu-lu te me ubab, kuren, wey me kepitira.) ");
INSERT INTO mbtNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne mig-inse ki Hisus ka me Parisiyu wey ka me talagpanulu te Balaud te Manama ne miggenendue, “Mania te ware tumana te me hibateen nu ka tuluuwen te me kaap-apuan ta? Migkeen de due sikandan ne ware mig-ayad-ayad migmanlu-lu te me belad dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ne migtabak si Hisus kandan, “Malehet iya ka impanagne ni prupita Isayas meyitenged kaniyu te egmapitew-pitew re. Sumale te insulat din ne miggenendue, ‘Diye de egpuun te me be-be te seini ne me etew ka pegtahud dan keddi, piru mariyu ka pusung dan keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ware karuan te pegsimba ran keddiey, su iyan dan igpanulu ka me balaud ne innimu re te me etew isip kun Balaud ku.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ne mig-engkeran niyu ka me suhu te Manama, wey iyan niyu intuman ka tuluuwen ne innimu re te etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ne migkahi pad man-e si Hisus, “Mangateu kew iya ne egsamsamili te suhu te Manama eyew te peg-ikul te tuluuwen niyu! ");
INSERT INTO mbtNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Su sumale ki Muwisis, ‘Tahura nu ka amey wey iney nu,’ wey ‘Ka minsan hentew ne egtampele te amey wey iney rin, keilangan iya ne eggimatayan sikandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piru migpanulu kew mule te ka minsan hentew ne due perem igkabulig diye te amey wey iney rin egkaayun ne egkahi diye te kandan, ‘Kurban seini’ (ka igpasabut kayi, ‘Para seini te Manama’). ");
INSERT INTO mbtNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sikan naa, ware niyud e tuhuti sikandin ne egbulig te amey wey iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na, puun due innimu niyu ne ware karuan ka lalag te Manama pinaahi te peg-ikul niyu te tuluuwen niyu. Ne masulug pad ka innimu niyu ne iling kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne impeumew e man-e ni Hisus ka me etew wey migkahiyan, “Pammineg kew langun wey sabuta niyu ka iglalag ku. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ware minsan nekey ne egkaabeleng te etew ne egpakamalindit kandin, ke kene, iyan ka egligwe puun kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te mig-engkeran e ni Hisus ka me etew wey migseled e diye te baley, mig-insaan e sikandin te me hibateen din meyitenged te panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne migkahiyan ni Hisus sikandan, “Ew, ware kew bes degma nakasabut? Ware kew bes nakanengneng te minsan nekey ne egkaabeleng te etew, kene egpakamalindit kandin? ");
INSERT INTO mbtNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Su ware sika migseled diye te pusung din, ke kene, diye de te getek din wey eglihawang ded man-e te lawa rin.” (Pinaahi te inlalag ni Hisus, migpasabut ne malinis ka langun ne keenen.) ");
INSERT INTO mbtNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne migkahi e man-e sikandin, “Ke nekey ka eglihawang puun te pusung te etew, iyan sika ka egpakamalindit kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Su diye egpuun te pusung te etew ka mareet ne suman-suman, ka pegpeyilabetey se kene ne alunggun, ka pegpanakew, ka peggimatey, ");
INSERT INTO mbtNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ka pegpanlibug, ka pegkaalamlamen, ka peggimu te langun ne mareet, ka pegpanlimbung, ka pegkaagkayen, ka pegkeimma, ka peg-iran-iran te duma, ka pegpeggasal, wey ka keungelan. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ka seini se langun ne mareet ne diye egpuun te pusung te etew ka egpakamalindit kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nataman, mig-awe e si Hisus te sika ne inged wey miggendiyad e sikandin te me inged ne sakup te Tiru. Ne diye migpamaneyik si Hisus te sabeka ne baley wey kene egkeupian ne due egpakanengneng ne dutu sikandin, piru ware din iya nekeeles. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ne due malitan ne inserepan te busew ka anak din ne beyi-beyi. Te pegkarineg te malitan ne dutu si Hisus, due-rue ne miggendiye sikandin wey mig-usengul diye te tane te egkatangkaan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ne migpeyid-u-hid-u sikandin ki Hisus ne igpaalew ka busew ne diye te anak din. Ka seeye ne malitan kene ne Hudiyu wey diye neetew te Pinisiya ne sakup te prubinsya te Sirya. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sikan naa ka migkahiyan ni Hisus ka malitan, “Keilangan ne iyan eggun-aan eggibulunga ka me bate su kene ne meupiya ne egkuen ka keenen dan wey igsunggud te me asu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Piru migtabak ka malitan, “Malehet sika Magbebaye, piru minsan ka me asu ne diye te selib te lamisa, egpakakeen ma te me mummu ne egkengeulug te me bate.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne migkahiyan sikandin ni Hisus, “Tenged te inlalag nu, egkaayun kad e ne eg-uli su mig-awe e ka busew diye te anak nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ne mig-uli e ka malitan wey neyingumaan din ka anak din ne miggibat diye te lantawan, wey mig-awe e ka busew diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nataman, miglibed e si Hisus diye te Lanew te Galiliya puun te me inged ne sakup te Tiru wey diye sikandin migbaye te Sidun wey me inged ne sakup te Dikapulis. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne due sabeka ne etew ne kene egdineg wey ngasel ne in-uuyan te me etew diye te ki Hisus. Migpeyid-u-hid-u sikandan ki Hisus ne egpatel-eban te belad din ka etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ne impasuwey sikandin ni Hisus diye te masulug ne etew eyew egpekegdaruwa naan de sikandan. Ne intiyuk din te me kemel rin ka me talinga te etew. Nataman, mig-ileb si Hisus wey impulit din seeye diye te dile te etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Migleng-ag sikandin diye te langit wey miggeheyinawa te maralem ne migkahi diye te etew, “Ipata,” ka igpasabut, “Egkalukatan ka.” ");
INSERT INTO mbtNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne sahuhune ne egpakarineg e ka etew wey migmewumel e ka dile din ne mateyul e ka peglalag din. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne impegpehetan teesi ni Hisus ka me etew ne kene egpepangguhuren te minsan hentew. Piru minsan inleglehetan sikandan teesi ni Hisus, nanasnasian de iya sikandan ka migpangguhud te neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amana iya neinu-inu ka me etew wey migkahi, “Amana ne tetelesi ka langun ne innimu rin! Egkabawian din minsan ka kene egdineg wey ka ummew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Te seeye ne timpu, miglibulung e man-e ka susuluhi ne etew diye te ki Hisus ne warad e egmangeenen. Ne dutu, in-umew ni Hisus ka me hibateen din wey migkahiyan, ");
INSERT INTO mbtNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Neyid-u a te me etew su natateluwan e sikandan ka egduma-ruma keddi ne warad e egmangeenen. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne emun ke egpeulien ku sikandan ne egmanggutasan, egkengalepu sikandan diye te deralanen su mariyu pe ma ka impuunan te duma.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ne migkahi ka me hibateen din, “Etuwey, hendei ki naan de iya egkuwa te egkakeen ne igpakeen te seini ne me etew te kayi ki pe ma te mammara ne inged ne kene egkeugpaan?” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ne mig-inse si Hisus kandan, “Pilaa ne timman ka paan ne due te kaniyu?” Ne migtabak sikandan, “Pitu ne timman.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ne impapinnuu e ni Hisus ka me etew diye te tane, ne ingkuwa rin ka pitu ne timman ne paan wey impasalamat te Manama. Nataman, impanepik-tepik din e ka paan wey impamehey rin diye te me hibateen din eyew igpasendad diye te me etew. Ne insendad dan e seeye diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne due degma mallilintek ne ngalap te weyig ne pila-pila re iya wey impasalamatan din seeye. Ne migsuhu si Hisus ne igpepanendad ded degma seeye diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangeen sikandan wey nenabbulung-bulung, wey duen pad nalimud dan ne nasame ne nakapenu te pitu ne liyang. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Me hep-at ne libu (4,000) ka kasulug te me etew. Nataman, impeuli e ni Hisus ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne due-rue ne mig-untud sikandin te balangey duma te me hibateen din wey miggendiye te inged ne Dalmanuta. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nataman, due me Parisiyu ne migginguma wey migpakig-apul ki Hisus. Migbuyu sikandan ne egpapitawen te kein-inuwan ne egpuun te langit eyew te peg-eleg-eleg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ne miggeheyinawa si Hisus te maralem wey migkahi, “Mania te egbuyu te kein-inuwan ka me etew te kuntee ne timpu? Egnangenan ku sikaniyu te malehet: ware kein-inuwan ne igpakapakita kandan!” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne mig-engkeran e sikandan ni Hisus wey mig-untud e man-e te balangey ne peendiye te deyipag te lanew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nalingew ka me hibateen ne eg-uyan te keenen gawas te sabeka ne paan ne diye te balangey. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ne impanpanayan sikandan ni Hisus ne migkahi, “Tanud-tanud kew wey bantey kew te igpatulin te paan te me Parisiyu wey ni Hirudis.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne migmalalahey e ka me hibateen din ne migkahi, “Nalalag din sika su ware ki ma nakabebewu te paan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nanengnengan ni Hisus ke nekey ka igkewengete dan, sikan naa mig-insaan din sikandan, “Mania te egkasasew kew te ware paan niyu? Ware kew bes pad nakasabut? Makehal bes ka me ulu niyu? ");
INSERT INTO mbtNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Due me mata niyu piru kene kew egpakakita, ne due me talinga niyu piru kene kew egpakarineg. Ware niyu nasuman-suman ");
INSERT INTO mbtNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ka pegpanepik-tepik ku te lalimma ne timman ne paan ne impakeen ku te lalimma ne libu (5,000) ne me etew? Ne pilaa ne liyang ka napenu te nalimud niyu ne egkeenen ne nenasame te me etew?” Ne migtabak sikandan, “Sapulu wey daruwa (12) ne liyang.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ne ka pitu ne paan ne impakeen ku te hep-at ne libu (4,000) ne me etew, pilaa ne liyang ka napenu te nalimud niyu ne egkeenen ne nenasame te me etew?” Ne migtabak sikandan, “Pitu ne liyang.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ne migkahiyan sikandan ni Hisus, “Ware kew naan pad man-e nakasabut?” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te pegginguma ran te Bitsayda, due butud ne in-uuyan te me etew diye te ki Hisus, wey migpeyid-u-hid-u sikandan ne egsamsamen din ka etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ne ingkitkit ni Hisus ka etew diye te madmariyu e te bariyu. Nataman, in-ileban din e ka mata te butud wey intel-eban din te belad din, wey mig-insaan din e, “Due nakita nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ne migtenggak ka etew ne migkahi, “Nakakita a te me etew, piru egpekeiling sikandan te me kayu ne egmangipanew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ne intel-eban e man-e ni Hisus te belad din ka mata te butud. Ne migmemetmet migpitew ka butud wey egpakakita rin e wey egkamelmelehan din e ka langun. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne impeuli e ni Hisus seeye se etew diye te ugpaan din wey migkahiyan, “Kene kad e baye dutu te bariyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ne migpabulus si Hisus duma te me hibateen din diye te me bariyu ne sakup te Sisarya Pilipus. Te sasangan pad sikandan ne egmangipanew, mig-insaan ni Hisus ka me hibateen din, “Hentew e kun naa sumale te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ne migtabak sikandan, “Migkahi ka duma ne sikeykew kun si Huwan ne Talagbewutismu. Ka duma degma migkahi ne sikeykew kun si Ilyas, piru ka duma migkahi ne sabeka ke kun te me prupita.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ne mig-inse si Hisus kandan, “Piru ke sikaniyu ka egpalalahen, hentew e naa iya?” Ne migtabak si Pidru, “Sikeykew iya ka Kristu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne migteesan sikandan ni Hisus ne kene egpepangguhuren te minsan hentew meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nataman, migbunsud e si Hisus ka migpanulu kandan ne ka Anak te Etew keilangan ne eg-antus te igmeulaula kandin, wey egsamsamilian sikandin te igbuyag te me Hudiyu, wey te me pangulu te me talagpanubad wey te me talagpanulu te Balaud te Manama. Eggimatayan dan sikandin wey egkeuyag ded te igkatelu ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ne inlalag ni Hisus seeye diye te me hibateen din te ware pegkehe. Tenged dutu, impasuwey e ni Pidru si Hisus wey insaparan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piru migbalikid si Hisus wey migtengtengan din ka me hibateen din, ne insaparan din e si Pidru te migkahi, “Awe ka rue Meibulan! Su kene ne Manama ka indapihan nu, ke kene, ka me etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ne impeparani ni Hisus ka me etew duma te me hibateen din wey migkahiyan, “Ke hentew seeye se egkeupian ne eg-ikul keddiey, keilangan ne eg-engked te kandin ne igkeupii wey egtiang te kandin ne krus wey eg-ikul keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Su seeye se egkeupian ne egluwas te kandin ne umul, nasi egkawarei kayi, piru seeye se egkawaraan te kandin ne umul tenged keddiey wey te Meupiya ne Panugtulen, egpakarawat te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nekey naa ka egkakuwa te etew ke egkaangken din ka langun ne tahu kayi te ampew te tane, piru egkawaraan te umul rin? Ware iya! ");
INSERT INTO mbtNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Su ware igkabehey te etew eyew egkaawi din ka kandin ne umul. ");
INSERT INTO mbtNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Su emun ke igkeyilew a duma te lalag ku te minsan hentew puun te me etew kuntee ne amana ne makasesale wey kenad egpalintutuu te Manama, igkeyilew ku degma sikandin te timpu ne eglibed e ka Anak te Etew duma te katelesan te Amey rin wey te matulus ne me panalihan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne migkahiyan sikandan ni Hisus, “Egnangenan ku sikaniyu te malehet: due me etew ne kayi kuntee ne kene pad egpatey taman te egkakita ran e ka Peghari te Manama ne egginguma duma te geem din.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Peglihad te hen-em ne aldew, induma ni Hisus ensi Pidru, si Santiyagu, wey si Huwan te migtakereg diye te matikang ne bubungan ne sikandan de. Te pegtengteng dan ki Hisus, nabalbalawan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne miglayag te kaangkag ka kumbale din, ne ware minsan hentew kayi te ampew te tane ne egpakapamaangkag te iling dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nataman, nakita ran ensi Ilyas wey Muwisis ne migpakiglalag ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne migkahiyan ni Pidru si Hisus, “Talagpanulu, meupiya te kayi key kuntee. Eggimu key te tatelu ne leeb: sabeka ka keykew, sabeka ki Muwisis, wey sabeka ki Ilyas.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nakahi rin sika su ware sikandin nakanengneng ke nekey ka iglalag din su nenaaldek ma sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ne due migginguma ne gapun ne migdalung kandan, ne due laheng ne migpuun dutu te gapun ne miggenendue, “Seini ka pinalangge ku ne Anak, pamineha niyu sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ne due-rue ne migmanlangas-langas sikandan, piru ware nakita ran gawas ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ne taheed te egmatupang e sikandan te bubungan, migteesan sikandan ni Hisus ne kene egpepangguhuren ke nekey ka nakita ran taman te egkeuyag e ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sikan naa intuman dan iya ka ingkahi ni Hisus. Piru migmein-inseey sikandan se tatelu ke nekey ka kaluwasan te ingkahi rin ne egkeuyag din e. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne mig-insaan dan e si Hisus, “Mania te migkahi ka me talagpanulu te Balaud te Manama ne keilangan ne iyan eggun-a ki Kristu eggendini si Ilyas?” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Migtabak si Hisus, “Malehet iya ne eggun-a eggendini si Ilyas eyew te peg-ayad-ayad te langun. Piru mania te nasulat te Kasulatan ne keilangan ne egbaybayaran wey egsamsamilian ka Anak te Etew? ");
INSERT INTO mbtNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piru egnangenan ku sikaniyu te miggendinid e si Ilyas, wey innimu ran diye te kandin ka langun ne igkeupii ran ne eggimuwen sumale te nasulat te Kasulatan meyitenged kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te peglibed enni Hisus diye te duma ne me hibateen din, nakita ran ka susuluhi ne etew ne miglingut kandan, wey due me talagpanulu te Balaud te Manama ne migpakig-apul kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne neinu-inu ka langun ne etew te pegkakita ran ki Hisus, wey namallahuy e sikandan ka migdugpu wey mig-elit-elit kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne mig-insaan sikandan ni Hisus, “Nekey-a ka igmekeg-apul niyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Due sabeka ne etew ne diye te kasuluhan ne migtabak, “Talagpanulu, in-uyan ku kayi te keykew ka anak ku ne lukes ne kene egpakalalag su inserepan te busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ne emun ke eg-umaan e sikandin te busew, egbalatey sikandin diye te tane. Ne egbubuke e ka be-be din wey egpakihet e te ngipen din, ne egkataman egkeleg e sikandin. Inhangyu ku ka me hibateen nu te peg-alew te busew piru ware sikandan nekeyimu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne migkahiyan ni Hisus sikandan, “Sikaniyu se me etew te kuntee ne timpu, ware pegpalintutuu niyu. Hendei bes taman ka pegduma-ruma ku kaniyu? Hendei bes taman ka peg-antus ku kaniyu? Uyana niyu ka bate kayi te keddi!” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne in-uyan dan e diye te kandin ka bate. Te pegkakita te busew ki Hisus, sahuhune ne in-umaan din e ka bate ne egbabuyen e, wey napeled diye te tane wey miglilid-lilid ne migbubuke se be-be. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ne mig-insaan ni Hisus ka amey te bate, “Kamenu e kaluhey sikandin ka egkeiling due?” Ne migtabak sikandin, “Puun pad te pegkabate din. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kamasalig e sikandin el-elehi te busew te eggimatey pinaahi te pegdegpak kandin diye te hapuy wey diye te weyig. Ne emun ke due egkeyimu nu, ikeyid-u key wey bulihi key nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ne migkahiyan sikandin ni Hisus, “Mania te migkahiyan a nikeykew ke due egkeyimu ku? Egkeyimu te etew ka langun ke due pegpalintutuu rin!” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ne due-rue ne migpanguleyi ka amey te bate ne migkahi, “Migpalintutuu a, piru bulihi a su deisek de ka pegpalintutuu ku!” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Te pegkakita ni Hisus ne egmamallahuy e ka me etew ne egdalapak kandan, in-alew din e ka busew ne miggenendue, “Sikeykew se busew ne egpakapeummew wey egpakapabengel, egsuhu a keykew ne awe ka rue te bate wey kene kad e libed serep diye te kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Migpanguleyi ka busew wey impakunkunaan din e ne egbabuyen ka bate wey nataman, miglihawang e sikandin. Ne hendue te migpatey e ka bate, purisu nangenen te me etew ne migpatey e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piru inggen-genan ni Hisus ka belad te bate wey impeenew rin, ne migsasindeg e ka bate. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Te peglasud enni Hisus te baley, mig-insaan e sikandin tugtuhesi te me hibateen din ne migkahi, “Mania te ware key nakaalew te busew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne migkahiyan sikandan ni Hisus, “Egkaalew ka iling dutu ne busew pinaahi re te peg-ampu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mig-awe sikandan te seeye ne inged wey diye migbaye te Galiliya. Ne kene igkeupii ni Hisus ne due egpakataha ke hendei sikandin, ");
INSERT INTO mbtNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","su eyew egpakapanulu sikandin te me hibateen din. Migkahiyan din sikandan, “Eg-akalan ka Anak te Etew wey igbehey diye te me etew ne eggimatey kandin, piru egkeuyag sikandin te igkatelu ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Piru ware sikandan nakasabut te ingkahi rin, wey nenaaldek sikandan ne eg-inse kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nataman, miggingume e sikandan diye te Kapirnaum. Ne hengkayi te diyad e sikandan te baley, mig-insaan e sikandan ni Hisus, “Nekey-a ka igmemekeg-apul niyu diye te dalan?” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piru migmeeneng-eneng de sikandan tenged su iyan dan igmemekeg-apul diye te dalan ke hentew ka labew kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne migpinnuu si Hisus wey in-umew rin ka sapulu wey daruwa (12) ne me hibateen din wey migkahiyan, “Ke hentew seeye se egkeupian ne egkeyimu ne labew, keilangan ne egpariralem sikandin wey egpeyimu ne suluhuanen te langun.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ne migkuwa sikandin te bate wey impataliware din kandan. Insapipi rin ka bate wey migkahi diye te kandan, ");
INSERT INTO mbtNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ka minsan hentew ne egdawat te iling kayi ne bate tenged su mig-ikul rin keddi, egdawat keddiey. Ne ka minsan hentew ne egdawat keddi, kene de ne sikeddiey ka egdawaten din su egdawaten din degma ka migpeuyan keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne migkahiyan ni Huwan si Hisus, “Talagpanulu, nakakita key te etew ne migpangalew te me busew pinaahi te ngaran nu, wey insaparan ney sikandin tenged su kene ta ne duma sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piru migkahi si Hisus, “Kene niyu sapari sikandin su ware etew ne eggimu te kein-inuwan pinaahi te ngaran ku ne due-rue ne egtampele keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Su ka kene egpakig-ehet kanta, egpalapig kanta. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Su egnangenan ku sikaniyu te malehet: ka minsan hentew ne egbehey kaniyu te senge ubab ne weyig tenged su sakup kew ni Kristu, egpakarawat iya sikandin te dasag din. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Piru ka minsan hentew ne egpuunan ne egpakasale ka sabeka te seini se me bate ne migpalintutuu wey migsalig keddi, meupiya pad ke eggiketan ka lieg din te dakel ne galingan ne batu wey igdegpak diye te dahat. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne emun ke iyan egpuunan ka belad nu ne egpakasale ka, tempuha nu sika! Meupiya pad ne egseled ka te langit ne pungku, du te daruwa se belad ne igdegpak diye te linew ne hapuy ne kene egkeebukan. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ne emun ke iyan egpuunan ka paa nu ne egpakasale ka, tempuha nu sika! Meupiya pad ke egseled te langit ne pungku, du te daruwa se paa ne igdegpak diye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne emun ke iyan egpuunan ka mata nu ne egpakasale ka, lekata nu sika! Meupiya pad ke egseled ka diye te Migharian te Manama ne sabeka re ka mata, du te daruwa se mata ne igdegpak diye te linew ne hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ne diye, kene egpammatey ka me iyas wey kene egkeebukan ka hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Keilangan ne egpakaneem-neem te keyirapan ka langun eyew egmeupiya, iling te ngalap ne eg-asinan eyew egmananam. ");
INSERT INTO mbtNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Meupiya ka asin piru ke egkawaraan e seini te nanam din, egmenuwen pad te pegpalibed kayi? Purisu bantey kew ne kene egkalaag ka keupiya niyu iling te asin, wey peup-upianey kew ka tagse sabeka.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nataman, mig-awe e si Hisus te seeye ne inged wey miggendiyad e te prubinsya te Hudiya wey diye te deyipag te Hurdan. Ne miglibulungan e man-e sikandin te masulug ne me etew wey impanulu din e sikandan sumale te nabatasan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Due me Parisiyu ne migparani ki Hisus eyew te peg-eleg-eleg kandin. Ne mig-insaan dan sikandin, “Intuhut naan ded te Balaud ta ne egpakig-engked ka lukes te asawa rin?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Migtabak si Hisus, “Nekey-a ka insuhu ni Muwisis kaniyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ne migkahi sikandan, “Intuhutan ni Muwisis ne egpabehayen ka lukes diye te asawa rin te sulat te pegpakig-engked, ne egpekeengked e sikandin te asawa rin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Piru migkahiyan sikandan ni Hisus, “Nakasulat si Muwisis te sika ne suhu tenged su makehal ka me ulu niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piru puun pad te an-anayan te peggimu te kalibutan, ‘Innimu e sikandan te Manama ne lukes wey malitan.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ne sika ka egpuunan ne eg-engked e ka lukes te amey wey iney rin su egsabeke e te asawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ne sikandan se daruwa, egkeyimu e ne sabeka.’ Sikan naa, kenad e ne daruwa sikandan, ke kene sabeka naan de. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Purisu, kene egkaayun ne egpeg-engkeren te etew ka insabeke e te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ne miglibed e sikandan diye te baley wey mig-inse e man-e ki Hisus ka me hibateen din meyitenged dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne migtabak si Hisus, “Minsan hentew ne lukes ne eg-engked te asawa rin wey egbalew-balew eg-asawa, egpakapanlibug e diye te tapey ne asawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ne emun ke eg-engked ka malitan te asawa rin wey egbalew-balew eg-asawa, egpakapanlibug e degma sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne due me etew ne nanguyan te me anak dan diye te ki Hisus eyew igpasamsam kandin, piru insaparan sikandan te me hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Piru te pegkakita ni Hisus dutu, nabelu sikandin te me hibateen din wey migkahiyan din sikandan, “Balahara niyu re due ka me bate ne egparani keddiey wey kene niyu sikandan sapari, su nasakup te Migharian te Manama ka me bate ne iling kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Egnangenan ku sikaniyu te malehet: emun ke kene niyu egdawaten ka Peghari te Manama iling te pegdawat te me bate, kene kew iya egpakalagkes dutu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nataman, insapipi rin e ka me bate wey intel-eban din e sikandan te belad din te migpanalangin. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Te peggipanew e ni Hisus, due etew ne migpallahuy peendiye te kandin wey migpanimbuel diye te tangkaan din ne mig-inse, “Meupiya ne talagpanulu, nekey-a ka eggimuwen ku eyew egkarawat ku ka umul ne ware egtamanan?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ne migtabak si Hisus kandin, “Mania te ingngaranan a nikeykew te meupiya? Sabeka re ka meupiya, ka Manama re. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nakanengneng kad e te me suhu: ‘Kene ka himatey, kene ka panlibug, kene ka panakew, kene ka pamalehet te ubat, kene ka panlimbung, tahura nu ka amey wey iney nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ne migtabak ka etew, “Talagpanulu, intantanuran kud sika langun ligkat te pegkabatei ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ne immemetmetan sikandin ni Hisus duma te geyinawa rin kandin wey migkahiyan, “Sabeka naan de ka ware nu pad neyimu. Hipanew kad wey ibelegye nu ka langun ne karatuan nu wey ipamehey nu ka halin diye te egkengaayu-ayu eyew due karatuan nu diye te langit. Ne egkataman, libed ka kayi wey ikul ka keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mabehat-behat amana ka ulaula te etew te pegkarineg din dutu, wey miggipanew sikandin ne miglungku tenged su dakel ka karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ne impanil-ap-sil-ap ni Hisus ka me hibateen din wey migkahiyan, “Amana ne malised te meyaman ka pegseled te Migharian te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ne neinu-inu ka me hibateen din te inlalag din. Piru mig-abayan sikandan ni Hisus te egkahi, “Mengeanak, subla iya ne malised ka pegseled diye te Migharian te Manama! ");
INSERT INTO mbtNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Malemu pad ka pegserep te ayam ne kamilyu diye te lungag te simat du te pegseled te meyaman diye te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Masumpit ne neinu-inu ka me hibateen din ne migmein-inseey ka tagse sabeka, “Hentew bes naan de ka egkaluwas?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Migtengtengan sikandan ni Hisus te migkahi, “Kene egkeyimu seini te etew, piru egkeyimu te Manama, su egkeyimu te Manama ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ne migkahiyan sikandin ni Pidru, “Na, sikanami seini, mig-engkeran ney ka langun eyew te peg-ikul keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne migkahi si Hisus, “Egnangenan ku sikaniyu te malehet: ka minsan hentew ne eg-engked te baley rin, me suled din, me atebey rin, iney wey amey rin, anak din, wey katantanaan din naa tenged te peg-ikul rin keddiey wey tenged te Meupiya ne Panugtulen, ");
INSERT INTO mbtNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","egpakarawat te susuluhi ne baley, suled, atebey, iney, anak wey luluahi ne tane te seini ne timpu. Minsan egkabaybayaran sikandin piru egpakarawat din te umul ne ware egtamanan te egginguma ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Piru masulug ka mabantug ne kenad egmabantug, wey masulug ka kene ne mabantug ne egmabantug e.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nataman, te diyad e ensi Hisus te deralanen peendiye te Hirusalim, miggun-a si Hisus kandan te eggipanew. Ne natanengan ka me hibateen din wey nenaaldek ka me etew ne migsinundul kandin ke nekey ka egkatamanan din diye. Ne dutu, impasuwey e man-e ni Hisus ka me hibateen wey innangenan din ke nekey ka egkeyitabu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Migkahi sikandin, “Pammineg kew! Eggendiye kid e te Hirusalim wey igbehey e ka Anak te Etew diye te me pangulu te talagpanubad wey diye te talagpanulu te Balaud te Manama. Eggukuman dan sikandin ne eggimatayan ne egkataman igbehey e sikandin diye te kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ne eglemetan dan sikandin, eg-ileban, eglampesan wey eggimatayan. Piru egkeuyag ded sikandin te igkatelu ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nataman, migparani diye te ki Hisus si Santiyagu wey si Huwan ne me anak ni Sibidiyu wey migkahi, “Talagpanulu, due igkeupii ney ne egbuyuen diye te keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne mig-inse si Hisus, “Nekey-a ka igkeupii niyu ne egbuyuen kayi te keddi?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ne migtabak sikandan, “Ke eghari kad e diye te mateles ne migharian nu, papinnuuwa key ubag nikeykew diye te andang nu: ka sabeka diye te igkakawanan nu wey ka dangeb diye te igkahibang nu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne migkahi si Hisus, “Ware kew nakataha ke nekey ka egbuyuen niyu. Egpekeinum kew naa te ubab te peg-antus ne eg-inuman ku? Egpakapabewutismu kew naa te bewutismu te peg-antus ne igbewutismu keddi?” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ne migtabak sikandan, “Uya, egpekeyimu key red.” Ne migkahiyan ni Hisus sikandan, “Malehet iya ne egpekeinum kew te ubab te peg-antus ne eg-inuman ku wey egpakapabewutismu te bewutismu te peg-antus ne igbewutismu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piru ka meyitenged te egpapinnuuwen diye te igkakawanan ku wey diye te igkahibang ku, ware katenged ku due, su duen e intahahe te Amey ku ne egpapinnuuwen due.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te pegkarineg dutu te sapulu ne me hibateen, nabelu e sikandan te duma ran ne ensi Santiyagu wey Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sikan naa, impeparani sikandan ni Hisus wey migkahiyan, “Nakanengneng kew e te seeye se in-isip ne me pangulu te kene ne me Hudiyu, impeuteng dan iya ka geem dan te pegmandu diye te me sakup dan. Ne seeye degma se dakel se katungdanan, igpapitew ran iya ka katenged dan diye te me sakup dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piru kene niyu sika himuwa. Ka minsan hentew due te kaniyu ne egkeupian ne egmabantug, keilangan ne egpeyimu sikandin ne suluhuanen niyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka minsan hentew ne egkeupian ne egkeyimu ne labew kaniyu, keilangan ne egpeuripen sikandin te langun. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Su minsan ka Anak te Etew ware miggendini eyew egpamakayen, ke kene, eyew egpamakey wey egpeyimatey eyew te peglekat te masalig ne me etew puun te me sale dan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nataman, miggingume e ensi Hisus diye te lungsud te Hiriku. Hengkayi te eg-awe e sikandin wey ka me hibateen din te seeye ne lungsud duma te susuluhi ne me etew, due butud ne migpinpinnuu diye te ilis te dalan ka egpamuyu ne egngaranan ki Bartimyu ne anak ni Timyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te pegkarineg din ne seeye bes iya si Hisus ne matig-Nasarit, migpanguleyi e sikandin ne migkahi, “Hisus! Kabuhalan ni Dabid! Ikeyid-u a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ne masulug ka migsapad kandin ne egpeen-enengen e, piru nanasnasian de iya sikandin migpanaman-taman migpanguleyi ne migkahi, “Kabuhalan ni Dabid! Ikeyid-u a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ne migsanggel si Hisus wey migkahi, “Umawa niyu sikandin.” Ne in-umew ran e ka butud wey migkahiyan dan, “Nekal-nekal ka! Na, sasindeg kad e su in-umew ka nikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ne indegpak e te butud ka ingkukuyumbu din ne migsasindeg e sikandin wey migparani ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ne mig-insaan sikandin ni Hisus, “Nekey-a ka igkeupii nu ne eggimuwen ku due te keykew?” Ne migtabak ka butud, “Talagpanulu, egkeupian a perem ne egpakakite e pad.” ");
INSERT INTO mbtNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne migkahiyan sikandin ni Hisus, “Hipanew kad. Iyan nekeuli keykew ka pegpalintutuu nu.” Ne sahuhune ne nakakite e sikandin wey migsinundul e ki Hisus te miggipanew. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te egpakarani-rani e sikandan te Hirusalim, egpalinggumaan e sikandan te Bitpahi wey Bitanya ne diye te Bubungan te Ulibu. Ne dutu, impewun-e e ni Hisus ka daruwa te me hibateen din ");
INSERT INTO mbtNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wey migpanagtahaan te migkahi, “Hendiye kew seeye te kewun-aan ne bariyu. Te sikan kew pad iya egginguma, due egkakita niyu ne nati te asnu ne inniket diye ne ware pad neunturi. Hekari niyu naa seeye wey uyana niyu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne emun ke due egkahi kaniyu, ‘Mania te egkuen niyu sika?’ kahii niyu re, ‘Ingkeilangan seini te Magbebaye wey mahaan din de ig-uli.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sikan naa, nangipanew e ka daruwa ne hibateen wey te pegginguma ran diye te bariyu, nakita ran iya ka nati te asnu diye te dalan ne inniket diye te gumawan te sabeka ne baley. Ne miggekaran dan e seeye. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne due me etew ne nanasindeg diye ne mig-inse kandan, “Hey, mania te eggekaran niyu sika?” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne intabak dan ka me etew sumale te ingkahi ni Hisus, seeye naa imbalahad e sikandan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nataman, in-uyan dan e diye te ki Hisus ka asnu wey innagpiyan dan te me kumbale dan, wey mig-untud e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Due masulug ne etew ne nambebelat te me kumbale dan diye te dalan, wey ka duma nanempug te me derewunen diye te me kamet wey intalagtag dan diye te dalan ne egbayaan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne migmanguleyi ka miggun-a ki Hisus wey ka migsinundul ne miggenendue, “Egdayanen ka Manama! Egpanalanginan sikandin se impeendini te Manama kanta! ");
INSERT INTO mbtNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Egpanalanginan ka egginguma ne egharian te apu ta ne si Dabid! Egdayanen ka Manama ne diye te dibabew te langit!” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pegginguma ni Hisus diye te Hirusalim, migseled sikandin diye te timplu wey intengtengan din ka langun. Nataman, miglihawang e sikandin puun su mahaan e seeye egkasagkup wey miggendiyad e te Bitanya duma te sapulu wey daruwa (12) ne hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pegkapawe, migligkat e sikandan puun te Bitanya wey dutu miggutasan e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ne due nakita rin diye te madmariyu ne kayu ne malapung se dewun ne egngaranan te iggira. Indugpu din ka kayu eyew egleuyen ke due behas. Te pegginguma rin diye, ware nakita rin ne behas su neelin de ne dewun tenged su kene pad seeye ne timpu te pegpamehas te seeye ne kayu. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne migkahiyan ni Hisus ka kayu, “Puun kuntee, warad etew ne egpakakeen pad man-e te behas nu!” Ne narineg seeye te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pegginguma ran diye te Hirusalim, migseled si Hisus diye te timplu wey impandeldel rin ka egmambebeli wey egmanitinda. Impamalintuad din ka me lamisa te egmanaliyu te seleppi wey ka pinnuuwan te egmameligye te me seleppati. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne ware din tuhuti ne egbaye diye te timplu seeye se eg-uyan te minsan nekey. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne impanulu din e ka me etew te migkahi, “Nasulat e diye te Kasulatan, ‘Ka baley ku egngaranan te baley ne ampuanan te langun ne nasud’; piru innimu niyud e seini ne helesanan te me takawen!” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Te pegkarineg dutu te pangulu te me talagpanubad wey te me talagpanulu te Balaud te Manama, migpammitew e sikandan te paahi eyew egkeyimatayan dan si Hisus. Piru naaldek sikandan ki Hisus tenged su nana-naayan ka susuluhi ne etew te pegpanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ne hengkayi te egsagkup e, mig-awe ensi Hisus diye te siyudad. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Te napawe e, nangipanew e sikandan wey naliharan dan ka kayu ne iggira wey nakita ran ne nahangu e, minsan ka me dalid. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nasuman-suman ni Pidru ka neyitabu wey migkahiyan din e si Hisus, “Talagpanulu, pitawa nu ka kayu ne indilus nu, nahangu e!” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ne migkahiyan sikandan ni Hisus, “Keilangan ne due pegpalintutuu niyu te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Egnangenan ku sikaniyu te malehet: ka minsan hentew ne egsuhu te sika ne bubungan ‘Keenat ka wey egpakaregpak ka diye te dahat’, ne ware pegduwa-ruwa diye te pusung din wey migpalintutuu ne egkatuman ka ingkahi rin, egkatuman iya seini. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Purisu egnangenan ku sikaniyu te minsan nekey ne egbuyuen niyu te Manama, palintutuuwi niyu ne narawat niyud, wey egkarawat niyu iya. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ke eg-ampu kew, pasayluwa niyu pa ke due nakasale kaniyu eyew ka Amey niyu ne diye te langit, egpasayluwen kew degma te me sale niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nataman, nanlibed e man-e sikandan diye te Hirusalim. Ne taheed te miggiphipanew si Hisus diye te seled te timplu, migparani kandin ka me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama wey ka me igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne mig-insaan dan si Hisus, “Nekey-a ka katenged nu te peggimu kayi? Hentew-a ka migbehey keykew te katenged te peggimu kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Migtabak si Hisus kandan, “Due degma inse ku kaniyu, ne emun ke egkatabak niyu seini, egnangenan ku degma sikaniyu ke nekey ka katenged ku te peggimu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nangeni a nikaniyu, hendei migpuun ka katenged ni Huwan te pegpamewutismu? Diye naa te Manama wey ke diye te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ne migpalalahey sikandan ne migkahi, “Emun ke egkahi ki, ‘Diye migpuun te Manama,’ kema ke egkahiyan ki nikandin, ‘Na, mania te ware kew migpalintutuu ki Huwan?’ ");
INSERT INTO mbtNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piru kene ki egpakakahi, ‘Diye migpuun te me etew.’ ” (Naaldek sikandan te me etew su migpalintutuu sikandan langun ne malehet ne prupita si Huwan.) ");
INSERT INTO mbtNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Purisu migtabak sikandan ki Hisus, “Ware key nakanengneng!” Ne migkahiyan sikandan ni Hisus, “Ke iling ma rue, kene ku degma egnangenan sikaniyu ke nekey ka katenged ku te peggimu kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nataman, migbunsud e man-e migpanulu si Hisus kandan pinaahi te me panunggilingan: “Due sabeka ne etew ne migpamula te me prutas ne egngaranan te paras wey inlingut din te alad. Miglulungag sikandin te egluyangan te behas wey migbebaley man-e te matikang ne bakalag ne eg-ugpaan te talagtameng. Pegkapenga, impatanggu rin e te me talagbasuk ka parasan wey miglapu e sikandin diye te mariyu ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te pegginguma te timpu te pegpamupu te me behas, migsuhu sikandin te sabeka ne uripen din eyew egpakuen te baad din te prutas diye te me talagtanggu. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Piru inderakep dan ka uripen wey inlelampesan, wey impeuli dan ne ware inuyanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ne migsuhu e man-e ka kamuney te lein ne uripen, piru inlelampesan te me talagtanggu ka ulu te uripen wey impeyilawan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Migsuhu e man-e ka kamuney te lein ne uripen wey inggimatayan dan ded sikandin. Ne masulug pad ka insuhu din, ne due duma kandan ne inlelampesan wey ka duma innimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nataman, ka anak din naan de ne lukes ne pinalangge din ka nasame ne egkasuhu din. Ne impeendiye din en iya sikandin te migkahi, ‘Egtahuren dan iya ka anak ku.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Piru migpalalahey ka me talagtanggu, ‘Sikan e ka anak te kamuney te parasan ne iyan egpakakamuney kayi. Kuwa kid e su eggimatayan ta sikandin eyew sikante e ka egpakakamuney kayi.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne inderakep dan e sikandin wey inggimatayan, wey inggehanuy ran e diye te lihawangan te parasan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mig-inse si Hisus te me etew, “Nekey naa ka eggimuwen te kamuney te parasan? Eggendiyaan din ka me talagtanggu wey egpangimatayan din sikandan, wey egpasubalan din ka parasan te duma. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ware kew bes nakasabut te imbasa niyu diye te Kasulatan ne eggenendue, ‘Ka batu ne insamsamilian te me talagbebaley, nasi neyimu ne batu ne pabunsuran. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Himu seini te Magbebaye ne Manama, wey igkeinu-inu ta seini!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Egdakepen e perem si Hisus te me pangulu te me Hudiyu su nasabut dan ne sikandan ka innisuhat te panunggilingan, piru naaldek sikandan te me etew. Purisu in-engkeran dan e si Hisus wey nangipanew e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ne migsuhu ka me pangulu te me Hudiyu te me Parisiyu wey me sakup ni Hirudis eyew te pegsahilut ki Hisus pinaahi te peglalag din. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Purisu nangendiye sikandan te ki Hisus wey mig-inse, “Talagpanulu, nakanengneng key ne malehet ka inlalag nu, wey imbalahad nu ke nekey ka suman-suman te me etew meyitenged te inlalag nu, tenged su ware nu tengtengi ke nekey ka kandan ne keugpe, ke kene, impanulu nu ka kamalehetan meyitenged te igkeupii te Manama. Na, nangeni key ke supak naa te Balaud ta ka pegbayad te buhis diye ki Sisar ne Impiradur, wey se kene? Keilangan naa ne egbayad key, wey se kene?” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piru natahaan ni Hisus ne egpapitew-pitew re sikandan, sikan naa migkahiyan din sikandan, “Mania te eg-el-elehan a nikaniyu? Uyani a te seleppi su egpitawen ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ne in-uyanan dan e sikandin te sabeka ne seleppi. Ne mig-inse si Hisus diye te kandan, “Hentew ne alung wey ngaran ka nakatahu kayi?” Ne migtabak sikandan, “Ki Sisar ne Impiradur.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne migkahiyan din e sikandan, “Ke iling due, ibehey niyu diye te Impiradur ka kandin, wey ibehey niyu degma diye te Manama ka kandin.” Ne dutu, neinu-inu sikandan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ne due me Sadusiyu ne migparani ki Hisus. Sikandan ka migkahi ne kenad egkeuyag ka me minatey. Ne mig-insaan dan si Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Talagpanulu, migsulat si Muwisis kanta te balaud ne emun ke due etew ne egpatey ka kakey rin ne ware pad nakaanak, keilangan ne egpamaluwen din ka ipag din eyew duen ded anak te kakey rin ne migpatey e. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, due pitu ne taltalaari ne neelin ne lukes. Nakaasawa ka panganey wey migpatey ne ware nakaanak. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne impamalu te inggiba ka ipag din, wey migpatey red degma ne ware nakaanak. Ne iling ded ka natamanan te igkatelu ne lukes. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naamin ka pitu ne taltalaari ne ware nakaanak. Te katammanan, migpatey e degma ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, te aldew ne eg-uyahen e ka me minatey, hentew naa ka asawa rin ne malehet su naamin ma ka pitu ne nakaasawa kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ne migtabak si Hisus kandan, “Naseyyup kew su ware kew nakasabut te Kasulatan wey te geem te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Su emun ke egkeuyag e ka me minatey, kenad egmaas-asaweey sikandan su egpekeiling e sikandan te me panalihan diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, meyitenged te peg-uyag te me minatey, ware kew bes nakasabut te imbasa niyu ne insulat ni Muwisis meyitenged te nalegleg ne sapinit ke hendei kahii sikandin te Manama, ‘Sikeddiey ka Manama ni Abraham, ka Manama ni Isaak, wey ka Manama ni Hakub’? ");
INSERT INTO mbtNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iyan igpasabut kayi ne kene ne Manama sikandin te me minatey, ke kene, Manama te neneuyag. Sikan naa ka amana kew iya naseyyup.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ne due sabeka ne talagpanulu te Balaud te Manama ne nakarineg engki Hisus te migpaap-apuley te me Sadusiyu. Narineg din ne meupiya ka tabak ni Hisus kandan, purisu mig-insaan din sikandin, “Nekey ka suhu ne labew te langun?” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne migtabak si Hisus, “Seini ka suhu ne labew te langun: ‘Pammineg kew me kabuhalan ni Israil! Sabsabeka re ka Manama ne Magbebaye ta wey warad duma. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Keilangan ne eggeyinawaan nu ka Magbebaye ne Manama nu ne egpuun te pusung nu, egpuun te gimukud nu, egpuun te suman-suman nu wey egpuun te keseg nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Seini ka igkarangeb: ‘Geyinawei nu ka duma nu iling te peggeyinawa nu te keykew ne pegkeetew.’ Warad duma pad ne suhu ne labew pad kayi te daruwa.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ne migkahiyan sikandin te talagpanulu te Balaud te Manama, “Eleg sika Talagpanulu! Malehet ka ingkahi nu ne sabeka re ka Manama wey warad iya duma su sikandin de iya. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne keilangan ne eggeyinawaan ta ka Manama ne egpuun te pusung ta, wey egpuun te suman-suman ta, wey egpuun te keseg ta. Ne keilangan ne eggeyinawaan ta ka duma ta iling te peggeyinawa ta te kanta ne pegkeetew. Meupiya pad ka pegtuman te seini ne me suhu du te pegtutung te ayam ne igpanubad wey duma pad ne igpanubad diye te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Te pegkakita ni Hisus ne natuenan ka tabak te talagpanulu te Balaud te Manama, migkahiyan din e sikandin, “Mahaan kad e egkasakup te Migharian te Manama.” Ne puun dutu warad e egpaalag-alag ne eg-inse-inse kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Taheed te migpanulu si Hisus diye te timplu, mig-inse sikandin, “Mania te migkahi ka talagpanulu te Balaud te Manama ne ka Kristu kabuhalan kun ni Dabid? ");
INSERT INTO mbtNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si Dabid mismu ka migkahi pinaahi te Panisingan te Manama, ‘Ka Manama migkahi diye te Magbebaye ku: Pinnuu ka kayi te igkakawanan ku, taman te eggimuwen ku ne diekanan nu ka me kuntere nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mismu ne si Dabid ka migngaran kandin te Magbebaye, purisu egmenuwen naa te Kristu ne egkeyimu ne kabuhalan ni Dabid?” Ne nahale ka susuluhi ne etew ne migpammineg ki Hisus te migpanulu. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Te pegpanulu ni Hisus, migkahi sikandin, “Bantey kew te me talagpanulu te Balaud te Manama, su egkeupian sikandan ne egleug-leug ne egkukumbale te mallayat. Ne egkeupian sikandan ne egtahuren te me etew diye te me palingkiyan ");
INSERT INTO mbtNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","wey eg-alam te me mateles ne pinnuuwan diye te me simbaan te me Hudiyu wey te pinnuuwan te me talahuren diye te sahakeenan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inlupihan dan ka me balu wey impangahew ran ka me kasangkapan dan minsan ka me baley ran, wey mallayat sikandan ne eg-ampu ka egpapitew-pitew re. Sikan naa ka subla pad ne masumpit ka legpad ne egkeumaan dan!” ");
INSERT INTO mbtNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Migpinnuu si Hisus diye te egkatangkaan te tahuanan te seleppi diye te timplu wey in-ipat din ka susuluhi ne etew ne nangulug te me seleppi dan. Ne masulug ka me meyaman ne mig-ulug te dakel ne seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nataman, due migginguma ne balu ne egkaayu-ayu ne migparani wey mig-ulug te daddaruwa ne keddeku. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ne impeparani ni Hisus ka me hibateen din kandin wey migkahiyan, “Egnangenan ku sikaniyu te malehet: sika se balu ne egkaayu-ayu, subla pad ne dakel ka in-ulug din du te langun ne mig-ulug diye te tahuanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su ka duma migbehey te subla naan de te seleppi dan, piru ka balu ne egkaayu-ayu, imbehey rin ka langun ne egkaresdesenan din te keuyahan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Te peglihawang ni Hisus te timplu, due sabeka ne hibateen din ne migkahi kandin, “Talagpanulu, pitawa nu ma sika se me batu ne amana ne derakel ne inggamit te peggimu te timplu! Amana ne mateles ka pegpasasindeg kayi!” ");
INSERT INTO mbtNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ne migkahiyan ni Hisus sikandin, “Nakita nu seini se dakel ne baley? Piru keureme, ware minsan sabeka ne batu ne egkasame diye te neunturan din, egkahebe iya ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Taheed te migpinpinnuu si Hisus diye te Bubungan te Ulibu ne egkatangkaan te timplu, migtugtuhesan sikandin insei enni Pidru, Santiyagu, Huwan wey Andris. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Migkahi sikandan, “Nangeni key ke ken-u egkeyitabu seini, wey nekey-a ka palinneu ne egkatuman e seini se langun?” ");
INSERT INTO mbtNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ne migtabak si Hisus kandan, “Bantey kew ne kene kew egkeuyan te kene ne malehet ne talagpanulu. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Su masulug ka eggendini ne egpeila ne sikandan kun ka Kristu, wey masulug ka egkeuyan dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ne kene kew kaaldek ke egpakarineg kew te egmabunbunuey due te marani niyu, wey te me guhuren meyitenged te egmabunbunuey diye te mariyu. Su keilangan iya ne egkeyitabu sika, piru kene pad ne sika ka katammanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Egpakigkuntere ka sabeka ne nasud te lein ne nasud wey egpakigkuntere ka sabeka ne tribu te lein ne tribu. Egginguma ka me linug wey bitil te minsan hendei ne inged. Piru sika langun, bunsuranan pad te kasakitan iling te eglesutan ne egbaletikan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Purisu bantey kew su eg-uyanen kew nikandan diye te hukumanan wey egpanlampesan kew diye te seled te simbaan te me Hudiyu. Egpaatubangen kew diye te me gubirnadur wey te me Hari tenged keddiey eyew egpakapangguhud kew te Meupiya ne Panugtulen diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Keilangan ne iggun-a igwali ka Meupiya ne Panugtulen diye te langun ne me nasud te kene pad egginguma ka katammanan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne emun ke eg-uyanen kew e nikandan wey igbehey diye te hukumanan, kene kew kalaggew ke nekey ka eglalahen niyu. Ilalag niyu re ke nekey ka igpanulu kaniyu te Manama te sika ne timpu su kenad e ne sikaniyu pad ka eglalag, su ka Panisingan e te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Due me etew ne iyan mismu egpeyimatey te me suled dan. Ne due me amey ne egpeyimatey te me anak dan, ne due degma me anak ne egkuntere te me amey wey iney ran wey egpeyimatey kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Egdumutan kew te langun ne etew tenged keddiey. Piru seeye se egpabulus eg-ikul keddiey taman te katamanan iyan egkaluwas.” ");
INSERT INTO mbtNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ne migpabulus si Hisus ne migkahi, “Ke egkiteen niyud ka makaalat-halat ne ‘talagdereet ne lilinditi diye te tangkaan te Manama’ ne diye egsasindeg te kene ne eleg kandin, (keilangan ne egsabuten seini te talagbasa), seeye se me etew ne diye te Hudiya, keilangan ne eg-aput diye te me bubungan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ne seeye se etew ne diye te atep te baley rin, keilangan ne kenad e egpamaneug eyew egkuwa te me kasangkapan din diye te seled. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ne seeye se diye te kamet, keilangan ne kenad eg-uli eyew egkuwa te kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mekeyid-u-hid-u te seeye ne me timpu ka egkengaberes wey ka egmasusu pad te me anak dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ampu kew ne kene egkeyitabu sika te tingmaagsil. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Su egginguma te seeye ne timpu ka makabayad-bayad ne peg-antus ne ware pad neyitabu puun te peggimu te kalibutan taman kuntee, wey kenad e seini egkeyitabu pad man-e. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Emun ke ware pad hilepeti te Manama ka seeye ne timpu, egkahule iya egpamatey ka me etew. Piru tenged te me etew ne in-alam din, innilepetan din ka seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ne emun ke due egkahi kaniyu, ‘Pitew kew, kayi ka Kristu!’ wey ke ‘Pitew kew, diye sikandin!’ kene kew en iya palintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Su eglepew ka kene ne malehet ne me Kristu wey kene ne malehet ne me prupita. Eggimu sikandan te me palinneu wey me kein-inuwan eyew egkeuyan ka me etew, ke egkaayun, minsan seeye se in-alam te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Purisu bantey kew su tapey kud sikaniyu panpanayi te langun-langun. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Emun ke egkapenge e ka me peg-antus te seeye ne timpu, egmarusilem e ka aldew wey kenad e eglayag ka bulan, ");
INSERT INTO mbtNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wey egkengeulug e ka me bituen puun te langit wey egkawelwel ka me tahu diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ne egkataman, egkakita ran e ka Anak te Etew ne eglepew diye te gapun duma te dakel ne geem wey katelesan. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne igpeendiye din ka me panalihan din diye te langun ne inged kayi te ampew te tane eyew te peglibulung te keet-etawan ne in-alam din. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na, sumsumana niyu ka kayu ne iggira wey himuwa niyu ne panunggilingan. Emun ke egtunasan e ka me sugpang din, sika ka palinneu ne mahaan e ka tingmeinit. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iling naan ded degma due, emun egkakita niyud ne egkeyitabu e seini, egkatahaan niyud ne marani e sikandin, egpalinggumaan e. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Egnangenan ku sikaniyu te malehet: egkatuman e sika langun te kene pad egkengamatey ka me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Egkaawe ka langit wey ka tane, piru ka keddi ne lalag kene iya egkaawe. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Piru ware minsan sabeka ne nakataha te aldew wey te uras ke ken-u seeye egkeyitabu, minsan ka me panalihan diye te langit wey ka Anak, su iyan de nakataha ka Amey. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Purisu bantey kew wey tanud-tanud kew su ware kew nakataha ke ken-u sika egkeyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Egpekeiling seini te etew ne eggipanew diye te mariyu ne inged. Te ware pad sikandin migligkat, egpamehayan din te me himu ka tagse uripen din, wey impanagtahaan din ka talagbantey te gumawan te keilangan ne egbantey. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sikan naa, bantey kew su ware kew nakataha ke ken-u eglibed ka kamuney te baley: ke egpangilumkilum naa, wey ke egliware naa te marusilem, wey ke eg-ukale naan e ka manuk, wey ke maselem naan e iya. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kema ke sahuhune ne egginguma sikandin wey egkeumaan kew ne nanlipereng. ");
INSERT INTO mbtNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ka ignangen ku kaniyu, ignangen ku degma diye te langun ne etew: bantey kew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ikaruween naan de ne Sahakeen e te Peglihad te Panalihan wey te Paan ne Ware Patulin. Ne ka me pangulu te talagpanubad wey ka me talagpanulu te Balaud te Manama, migpammitew sikandan te paahi ke egmenuwen ne egkarakep dan si Hisus te heles de eyew egkeyimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Migkahi sikandan, “Kene ta eggimuwen seini te timpu te Sahakeen, su kema ke egkasamuk ka me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te seeye ne timpu, diye ensi Hisus te Bitanya te baley ni Simun ne ibungen. Ne due malitan ne migginguma ne mig-uyan te mahal ne peemut ne nardu ne diye itahu te alabastru. Te sasangan pad ne egkeen si Hisus, migparani ka malitan kandin wey impese din ka tahuanan wey in-itisan din e ka ulu ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Piru due duma dutu ne nabelu wey migpalalahey sikandan ne migkahi, “Mania te migde-deetan sika se peemut? ");
INSERT INTO mbtNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Igbelegye din perem sika te subla te tatelu ne gatus (300) ne dinaryu wey igpamehey diye te egkengaayu-ayu ka halin.” Ne dutu, inderew-ey ran e ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piru migkahiyan sikandan ni Hisus, “Balahara niyu re due sikandin! Mania te egbanggawen niyu sikandin? Amana ne meupiya ka innimu rin kayi te keddi. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Su ka egkengaayu-ayu, layun niyu mule egkaruma wey egpakabulig kew kandan te minsan ken-u ne igkeupii niyu. Piru sikeddi, kena a nikaniyu layun egkaruma. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Innimu rin ke nekey ka egkeyimu rin, wey in-itisan din ka lawa ku tahahe te pegsabal keddiey keureme. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Egnangenan ku sikaniyu te malehet: minsan hendei igwali ka Meupiya ne Panugtulen kayi te intiru ne kalibutan, egkahuhud degma ka innimu rin kayi te keddi eyew egkasuman-suman sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nataman, miggendiye te me pangulu te me talagpanubad si Hudas Iskaryuti ne sabeka te sapulu wey daruwa (12) ne hibateen ni Hisus eyew eg-akalan din sikandin wey igbehey diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Amana sikandan nahale te pegkarineg dan dutu, wey migsaaran dan si Hudas ne egbeheyan dan te seleppi. Purisu migpammitew sikandin te meupiya ne timpu ne egkaakalan din si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne miggingume e ka an-anayan ne aldew te Sahakeen te Paan ne Ware Patulin, ka aldew ne egpanubad te nati ne karniru eyew egkeenen te Sahakeen. Ne dutu mig-insaan si Hisus te me hibateen din, “Hendei key egpeendiyaa nikeykew eyew te peg-andam te egkeenen ta te Peglihad te Panalihan?” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne insuhu din ka daruwa te me hibateen din te migkahi, “Hendiye kew te siyudad wey due etew ne egkasinug-ung niyu diye ne egtiang te banga ka migpanakeru. Sinundula niyu naa sikandin ");
INSERT INTO mbtNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ke hendei eglasud wey kahii niyu ka mahinged, ‘Eg-inse ka talagpanulu keykew, Hendei ka sinabeng ne egkeenan ku duma te me hibateen ku te Peglihad te Panalihan?’ ");
INSERT INTO mbtNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne igpakita rin kaniyu ka maluag ne sinabeng diye te dibabew ne kumplitu te me kasangkapan wey naandam e, wey dutun kew naa andam te iglabung ta.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nataman, miggipanew e ka daruwa ne hibateen ne miggendiye te siyudad, wey nakita ran ka langun sumale te inlalag ni Hisus kandan. Seeye naa in-andam dan e ka egkeenen para te Sahakeen te Peglihad te Panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ne hengkayi te nasagkup e, nangingume e ensi Hisus duma te sapulu wey daruwa (12) ne hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te sasangan e sikandan ka egmangekeen, migkahi si Hisus diye te kandan, “Egnangenan ku sikaniyu te malehet: due sabeka kaniyu kayi kuntee te migkeen ne eg-akal keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ne dutu nalaggew e sikandan wey migpasubsubaley mig-inse ki Hisus ne migkahi, “Kema ke sikeddi ka egkahiyen nu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Migtabak si Hisus, “Sabeka kaniyu te sapulu wey daruwa (12) ne migsaamul keddi migdallut te paan diye te yahung. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Egpatey ka Anak te Etew sumale te nasulat te Kasulatan, piru mekeyid-u-hid-u ka etew ne eg-akal kandin. Meupiya pad ke ware sikandin neetew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te sasangan pad sikandan ne egmangekeen, migkuwa si Hisus te paan wey impasalamatan din ka Manama, wey impanepik-tepik din seini wey impamehey rin diye te me hibateen din te migkahi, “Kuwa kew kayi. Seini ka lawa ku.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nataman, migkuwe e man-e sikandin te senge ubab ne binu, ne impasalamatan din e ka Manama wey intaruwey rin diye te kandan, wey mig-inum e sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne migkahiyan sikandan ni Hisus, “Sika ka langesa ku ne igpatihis para te masulug ne me etew, wey iyan egpamalehet te kasabutan te Manama diye te keet-etawan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Egnangenan ku sikaniyu te malehet: kena ad e eg-abey eg-inum te seini ne inumen ne egpuun te paras taman te aldew ne eg-inum ad te iyam ne inumen diye te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nataman, nangulahing e sikandan te pegdayan te Manama, wey nangendiyad e te Bubungan te Ulibu. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ne migkahiyan sikandan ni Hisus, “Eg-engked kew langun keddiey su nasulat diye te Kasulatan, ‘Eggimatayan ku ka talagtameng te me karniru, wey egmemekegsuwey-suwey e ka me karniru.’ ");
INSERT INTO mbtNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piru te pegkapenga te peg-uyag keddi, eggun-a ad kaniyu diye te Galiliya.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ne migkahiyan ni Pidru si Hisus, “Minsan eg-engkeran kad te langun, kena ad iya eg-engked keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ne migkahiyan sikandin ni Hisus, “Egnangenan ku sikeykew te malehet: te kene pad eg-ukale ka manuk te kararuwa te seini ne karusileman, katatelu ad nikeykew igpahunware.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piru mabagget iya ne migpehet-pehet si Pidru ne migkahi, “Minsan pad eggimatayan a duma keykew, kene ku iya igpahunware sikeykew.” Ne iling ded degma dutu ka ingkahi te duma ne me hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nataman, nangendiyad e ensi Hisus te inged ne egngaranan te Gitsimani wey migkahiyan din ka me hibateen din, “Kayi kew pa paminnuu taheed te eg-ampu e pad.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne induma rin si Pidru, si Santiyagu wey si Huwan, ne dutu naheram din ka subla ne pegkalaggew wey migmemasakit ka geyinawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne migkahiyan sikandan ni Hisus, “Amana ne sesakiti ka geyinawa ku ne hendue te egkapatey ad e. Kayi kew naan pa wey kene kew eglipereng.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne migpabulus si Hisus diye te kewun-aan wey mig-usengul diye te tane. Mig-ampu sikandin ke egkaayun ne kene perem egginguma diye te kandin ka eg-antusen din. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Migkahi sikandin, “Ame, egpekeyimu ka te langun. Angaya nu seini se ubab te peg-antus ne kayi te keddiey. Piru kene ne iyan egkatuman ka keddiey ne pegbuut, ke kene, ka keykew ne pegbuut.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nataman, miglibed e si Hisus diye te me hibateen din wey neumaan din sikandan ne nenewulep e. Ne migkahiyan din e si Pidru, “Etuwey Simun, newulep ke bes? Kene kew egpakaantus ne kene eglipereng duma keddi minsan senge uras de? ");
INSERT INTO mbtNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kene kew lipereng, wey ampu kew eyew kene kew egkatintal. Egkeupian perem ka panisingan piru mahuye ka lawa niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne mig-awe e man-e si Hisus wey mig-ampu te iling ded te in-ampu din te an-anayan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te peglibed din, neumaan din ded man-e sikandan ne nenewulep su egmemakaliplipereng en iya sikandan. Ne ware sikandan nakanengneng ke nekey ka igtabak dan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te igkatelu e ni Hisus te eglibed diye te me hibateen din, migkahiyan din e sikandan, “Ew, nenewulep kew bes pad wey nangimmeley? Eleg e sika! Miggingume e ka timpu ne igbehey e ka Anak te Etew diye te me makasesale. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bukal-bukal kew e su egmangipanew kid. Pitawa niyu, sikan e ka eg-eakal keddiey!” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Te sasangan pad ne eglalag si Hisus, miggingume e si Hudas ka sabeka te sapulu wey daruwa (12) ne hibateen din. Masulug ne me etew ka migduma kandin ne nanguyan te me kampilan wey me lampes. Insuhu sikandan te me pangulu te me talagpanubad, me talagpanulu te Balaud te Manama wey igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ne seeye se talag-akal migbehey kandan te palinneu ne migkahi, “Ka etew ne eggarekan ku, sikan naa dakepa niyu. Uyana niyu sikandin wey ay-ayari niyu te egbantey.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te pegginguma ni Hudas, migleus e sikandin diye ki Hisus wey migkahi, “Talagpanulu!” Ne miggarekan din e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ne inderakep dan e si Hisus wey impakamkamalan dan te eggen-gen. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piru due sabeka ne migsasindeg dutu ne miggulabut te kampilan din wey intibbas din ka uripen te Labew ne Talagpanubad, wey natamped e ka talinga. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ne mig-inse si Hisus diye te kandan, “Takawen a? Mania te nanguyan kew te me kampilan wey me lampes ka egdakep keddiey? ");
INSERT INTO mbtNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tagse aldew duma a nikaniyu diye te timplu ka egpanulu, ne wara a nikaniyu derakepa. Piru keilangan ne egkatuman ka nasulat diye te Kasulatan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nataman, in-engkeran e sikandin te me hibateen din wey namallahuy e sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ne due kanakan ne migsinsinundul ki Hisus ne ware migkukumbale su migkukuyumbu de te hinabel. Egderakepen dan e perem sikandin ");
INSERT INTO mbtNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","piru iyan dan de nahen-genan ka ingkukuyumbu din, ne nakapallahuy sikandin ne migpalawas naan de. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nataman, in-uyan dan e si Hisus diye te baley te Labew ne Talagpanubad. Ne diye nanlibulung ka langun ne pangulu te talagpanubad, ka me igbuyag te me Hudiyu, wey ka me talagpanulu te Balaud te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ne migsinundul degma si Pidru ki Hisus ne migpadpariyu de taman diye te lama te Labew ne Talagpanubad. Ne diye sikandin migpinnuu duma te me talagtameng ka egginarang. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne migpammitew ka me pangulu te me talagpanubad wey ka sakup te me Talaggukum te me Hudiyu te igbayung dan ki Hisus eyew egpeyimatayan dan sikandin, piru ware nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Masulug ne me etew ka migpangguhud te ubat meyitenged ki Hisus piru ware nenekeg-iling ka guhuren dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne due duma ne migsasindeg wey migpangguhud te ubat meyitenged ki Hisus ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Narineg ney sikandin ne migkahi, ‘Egguhusen ku seini se timplu ne innimu re te etew. Ne igpasasindeg ku red man-e seini seled te tatelu ne aldew ne kenad ne hinimuwan te etew.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piru minsan pad dutu, ware nenekeg-iling ka guhuren dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ne migsasindeg ka Labew ne Talagpanubad diye te tangkaan te langun ne etew wey mig-inse ki Hisus, “Na, ware igkatabak nu te me sumbung meyitenged keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Piru migpeeneng-eneng de si Hisus wey ware migtabak. Ne mig-abayan e man-e sikandin insei te Labew ne Talagpanubad, “Sikeykew naa iya ka Kristu ne Anak te Egdeyrayen ne Manama?” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ne migtabak si Hisus, “Sikeddiey iya, wey egkiteen niyu kangkuwa ka Anak te Etew ne egpinnuu diye te igkakawanan te Maresen ne Manama. Ne egginguma sikandin ne egdumaan te gapun diye te langit.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Te pegkarineg dutu te Labew ne Talagpanubad, inggisi din ka kumbale din wey migkahi, “Mania te egkeilangan ki pad ne egkuwa te me talagpamalehet ");
INSERT INTO mbtNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","te narineg niyud ma ka pegbaley-baley rin te Manama? Na, nekey te suman-suman niyu?” Ne dutu, mig-uuyunan dan langun ne eleg ne eggimatayan si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nataman, in-iileban e te duma ne etew si Hisus wey imbagkesan dan ka mata rin wey impandabi ran e sikandin. Ne migkahi sikandan, “Ne la, antuki nu ke hentew-a ka migpasakit keykew?” Ne in-angey e si Hisus te me talagbantey wey impanagpi dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ne taheed te diye pad si Pidru te lama, due miglihad ne malitan ne sabeka te me suluhuanen te Labew ne Talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te pegkakita rin ki Pidru ne migginarang, immemetmetan din sikandin wey migkahiyan, “Hey, duma ka iya ni Hisus ne matig-Nasarit.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piru migpahunware si Pidru ne migkahi, “Wara a nakataha wey nakasabut ke nekey ka impanlalag nu.” Ne miggendiyad sikandin te kasunguwan te alad. Ne dutu, due manuk ne mig-ukale. ");
INSERT INTO mbtNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te nakite e man-e si Pidru te suluhuanen ne malitan, migkahiyan din e ka me etew ne nanasindeg diye, “Duma ran iya ka sika ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piru migpahunware ded man-e si Pidru. Ware de naluhey, migkahiyan e man-e si Pidru te me etew ne nanasindeg dutu, “Malehet iya ne duma ka nikandan su matig-Galiliya ke ma.” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piru migpahunlibet iya si Pidru ne migkahi, “Mengeyibet iya te pegkeetew ku, wara a iya nekeila te sika ne etew ne egkahiyen nu minsan pad egpatey a!” ");
INSERT INTO mbtNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ne due-rue ne mig-ukale e man-e ka manuk wey nasuman-suman ni Pidru ka ingkahi ni Hisus kandin, “Te kene pad eg-ukale ka manuk te kararuwa, katatelu ad nikeykew igpahunware.” Ne dutu, migpanaman-taman e migsinehew si Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Te pegkapawe e, miglibulung wey migmasabsabutey ka me pangulu te me talagpanubad duma te me igbuyag te me Hudiyu, wey me talagpanulu te Balaud te Manama, wey ka langun ne sakup te me Talaggukum te me Hudiyu. Imbebaku dan e si Hisus wey in-uyan dan e diye te ki Gubirnadur Pilatu, wey imbehey ran e kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ne mig-insaan sikandin ni Pilatu, “Sikeykew iya ka Hari te me Hudiyu?” Migtabak si Hisus, “Ingkahi nud en iya.” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne masulug ka imbebayung kandin te me pangulu te me talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Purisu mig-insaan e man-e sikandin ni Pilatu, “Ware igkatabak nu te masalig ne imbebayung dan keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piru warad e migtabak si Hisus, sikan naa ka neinu-inu si Pilatu. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nabatasan e ni Pilatu ne tagse Sahakeen te Peglihad te Panalihan, due eglekaan din ne pinirisu ne igkeupii te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Due egngaranan ki Barabas ne naprisu duma te me duma rin su nekeyimatey te timpu te pegribildi ran te gubirnu. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne amana ne masulug ka me etew ne migparani ki Pilatu wey mighangyu kandin ne eglekaan e ka pinirisu iling te nabatasan din e ne eggimuwen. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne mig-insaan sikandan ni Pilatu, “Egkeupian kew naa ne eglekaan ku ka Hari te me Hudiyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Su nakataha si Pilatu ne neimma re ki Hisus ka me pangulu te talagpanubad, sikan naa ka indakep dan e si Hisus wey imbehey e diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piru intipu te me pangulu te me talagpanubad ka me etew ne si Barabas ka egpalekaan dan ki Pilatu, kene ne si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne mig-insaan e man-e ni Pilatu ka me etew, “Na, nekey naa ka eggimuwen ku kayi te etew ne egnangenen niyu ne Hari te me Hudiyu?” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne migbalbalukan sikandan ka migkahi, “Ilansang nu sikandin te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ne mig-insaan sikandan ni Pilatu, “Mania, nekey bes ka neyimu rin ne mareet?” Piru nanasnasian de iya sikandan ka migmanguleyi ne migkahi, “Ilansang nu sikandin te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ne tenged su egkeupian si Pilatu ne egpakapahale te me etew, impalekaan din e si Barabas, wey impalampesan din si Hisus wey imbehey rin e diye te me sundalu eyew iglansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nataman, in-uuyan e si Hisus te me sundalu diye te lama te palasyu te gubirnadur, wey impalibulung dan e ka langun ne duma ran ne me sundalu. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne insaluuban dan si Hisus te kumbale ne ubi se batek, wey miggimu sikandan te kuruna ne duhi wey impakuruna ran e kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nataman, imbaley-baley ran e sikandin te migkahi, “Egmabantug ka Hari te me Hudiyu!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne inlelampesan dan e te tuked ka ulu ni Hisus wey in-iileban dan e sikandin, wey migpanimbuel e sikandan diye te tangkaan din. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pegkapenga ran te egbaley-baley kandin, inluung dan e ka kumbale ne ubi se batek wey inlibed dan ded ipasaluub ka tapey ne kumbale din. Nataman, in-uyan dan e sikandin diye te lihawangan te siyudad eyew iglansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te sasangan e sikandan ne egmangipanew, due nasinug-ung dan ne matig-Sirini ne egngaranan ki Simun, ne amey enni Alihandru wey ni Rupu. Diye sikandin egpuun te sityu wey eggendiye te siyudad, ne impepehes dan sikandin patianga te krus ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne diye dan uyana si Hisus te inged ne egngaranan te Gulguta (Inged te Angkal ka igpasabut kayi). ");
INSERT INTO mbtNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne egbebehayan dan e perem si Hisus te binu ne insewuhan te delemetan ne egngaranan te mira, piru ware migkuwa si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nataman, inlansang dan e si Hisus te krus, wey imbaad-baad dan e ka kumbale din. Migpintut-pintut sikandan ke nekey ne baad te kumbale ni Hisus ka egkakuwa ran. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Me alas nuwibi seeye te maselem te peglansang dan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne seini ka sumbung ne insulat diye te keretula te krus, “Ka Hari te me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Due degma daruwa ne takawen ne inlansang te krus duma ki Hisus. Ka sabeka diye te igkakawanan din wey ka dangeb diye te igkahibang din. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ne ka me etew ne egmanlihad dutu, egmanlengey-lengey ka egbaley-baley ki Hisus ne egkahi, “Ew, sikeykew bes iya ka egguhus te timplu wey igbalew-balew red igpes-ek seled te tatelu re ne aldew! ");
INSERT INTO mbtNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, luwasa nu ka pegkeetew nu wey pamaneug ka due te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne migdali-di ded degma ki Hisus ka me pangulu te me talagpanubad duma te me talagpanulu te Balaud te Manama ne migkahi, “Inluwas din ka duma, piru kene sikandin egpakaluwas te pegkeetew rin! ");
INSERT INTO mbtNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Egpitawen te naan iya ke egpakapamaneug te krus ka Kristu ne Hari te Israil, eyew egpakapalintutuu kid e kandin!” Ne migdali-di ded degma ki Hisus ka me duma rin te inlansang te krus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ne hengkayi te meudtu e, migmarusilem e ka intiru ne nasud taman te alas tris te maapun. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te alas tris e te maapun, migpanguleyi si Hisus te meemen ne miggenendue, “Ili, Ili, lima sabaktani?” Ka igpasabut kayi, “Manama, Manama, mania te in-engkeran a nikeykew?” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te pegkarineg te duma ne me etew ne nanasindeg dutu, migkahi sikandan, “Pammineg kew, impangumew rin si Ilyas!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne due sabeka kandan ne migpallahuy ne mig-angey te egpekeiling te kutsun wey in-eled din te maperes ne binu wey imbagkes din diye te geed eyew igpasupsup ki Hisus. Ne migkahi sikandin, “Duen kew pa, egpitawen te naan iya ke eggendini si Ilyas ka eg-angey kandin due te krus!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne migpanguleyi si Hisus te heemeni, ne dutu, nabigtawan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ne nahisi e ka kurtina diye te timplu puun te dibabew peendiye te diralem. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te pegkakita te kepitan te me sundalu ne diye migsasindeg te egkatangkaan ni Hisus ne nabigtawan e sikandin, migkahi e sikandin, “Malehet iya ne Anak te Manama ka seini ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ne due degma me malitan ne namipitew diye te bayew madmariyu. Dutu ensi Mariya Magdalina, si Mariya ne iney ni Santiyagu ne egkaari-hari wey ni Husi, wey dutu degma si Salumi. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sikandan seeye se migsinundul wey migtanggu ki Hisus te diye pad sikandin te Galiliya. Ne masulug pad man-e ne me malitan ka migduma kandin peendiye te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aldew seeye te Pegpangandam te Aldew te Peggimeley. Te egkasagkup e, ");
INSERT INTO mbtNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","miggendiye si Husi ne matig-Arimatiya ki Pilatu te ware pegkaaldek wey imbuyu din ka lawa ni Hisus. Si Husi sabeka ne talahuren ne sakup te me Talaggukum te me Hudiyu, wey migtetahad degma sikandin te Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Neinu-inu si Pilatu te pegkarineg din ne migpatey e si Hisus, purisu impeumew rin ka kepitan te me sundalu wey mig-insaan din ke migpatey naan en iya si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Te nanangenan e sikandin te kepitan ne malehet iya seeye, imbehey rin e ka lawa ni Hisus diye te ki Husi. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ne migbebeli si Husi te hinabel wey ingkuwa rin ka lawa ni Hisus diye te krus wey imbukusan din e. Ne insabal rin e ka lawa ni Hisus diye te inlungahan ne dalama. Nataman, miglilid e sikandin te dakel ne batu eyew iglekeb te gumawan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nakakita si Mariya Magdalina wey si Mariya ne iney ni Husi ke hendei isabal si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te miglihad e ka Aldew te Peggimeley, migbebeli te peemut ensi Mariya Magdalina, si Mariya ne iney ni Santiyagu, wey si Salumi su eggendiyaan dan ka lawa ni Hisus eyew eg-itisan te peemut. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te maselem-selem te aldew te Duminggu, te migsile e ka aldew, nangendiyad e sikandan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne migmein-inseey e sikandan ke hentew-a ka egpakalilid te batu ne in-elet te gumawan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pegginguma ran migtenggak sikandan, wey nakita ran ne nalilid e ka bubuyahen ne batu. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te pegseled dan e dutu, due nakita ran ne kanakan ne migkukumbale te maangkag ne diye migpinnuu dapit te igkakawanan dan. Ne dutu, natingkemed sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne migkahiyan sikandan te kanakan, “Kene kew egkangilam! Nakataha a ne egpammitew kew ki Hisus ne matig-Nasarit ne inlansang te krus. Warad e sikandin kayi su neuyag e. Kema, pitawa niyu ka impaley-asan kandin. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, hendiyei niyu ka me hibateen ni Hisus wey guhuri niyu sikandan duma ki Pidru te miggun-e e sikandin kaniyu diye te Galiliya; ne diye niyu egkakita sikandin sumale te ingkahi rin kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sikan naa, nanlihawang e sikandan te insabalan ka namallahuy su amana sikandan neinu-inu wey nangelkel. Ne ware pad sikandan migpangguhud te minsan hentew tenged te pegkaaldek dan. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te pegkeuyag ni Hisus te maselem-selem te Duminggu, diye sikandin an-anayan migpakita ki Mariya Magdalina, ka malitan ne in-alawan din te pitu ne busew. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne miggendiyaan e ni Mariya ka me hibateen ni Hisus ne migmaninehew wey migmanlungku, wey migpangguhuran din e. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Piru ware sikandan migpalintutuu te pegkarineg dan ne neuyag e si Hisus wey nakita ni Mariya. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pegkapenga dutu, migpakite e man-e si Hisus te daruwa ne hibateen din taheed te egpeendiye sikandan te sityu, piru nabalbalawan ka ulaula rin dutu. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ne nanlibed e sikandan ka migpangguhud te me duma ran, piru ware ded degma sikandan palintutuuwi. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pegkapenga dutu, migpakite e man-e si Hisus te sapulu wey sabeka (11) ne hibateen din te sasangan sikandan ne egmangekeen. Indew-ey sikandan ni Hisus su ware pegpalintutuu ran wey me makehal ka me ulu ran, su ware sikandan migpalintutuu te seeye se nakakita kandin te neuyag e. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nataman, migkahiyan din e sikandan, “Hendiyei niyu ka langun ne inged kayi te kalibutan wey iwali niyu ka Meupiya ne Panugtulen diye te langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ka egpalintutuu wey egpabewutismu, egkaluwas, piru ka kene egpalintutuu, eglegparan. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Seini ka me palinneu te seeye se migmalintutuu keddi: egpakaalew sikandan te me busew pinaahi te ngaran ku, wey egpakalalag sikandan te me linalahan ne ware dan natueni. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ke egpakahen-gen sikandan te me uled wey ke egpekeinum te minsan nekey ne eggilu, kene sikandan egkamenu. Ne emun ke igtel-eb dan ka me belad dan te egmanderalu, egkengeulian sikandan.” ");
INSERT INTO mbtNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pegkapenga te Magbebaye ne si Hisus te miglalag kandan, imbatun e sikandin wey diye migpinnuu te igkakawanan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nataman, nangipanew e ka me hibateen din wey migwali sikandan te minsan hendei. Ne migbulihan sikandan te Magbebaye wey impamalehetan din ka lalag dan pinaahi te me kein-inuwan ne innimu ran.");
INSERT INTO mbtNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Talahuren ne Tiyupilu. Masulug ka miggeram migsulat te guhuren ne neyitabu kayi te kanta meyitenged ki Hisu Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ka insulat dan, iyan ka impangguhud kanta te seeye se nakakita kayi puun pad te bunsuranan wey iyan migpangguhud te lalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Natantanuran ku degma sika langun minsan ka bunsuranan kayi. Sikan naa ka meupiya buwa degma ne eg-ay-ayaran ku sika te egsulat para keykew talahuren ne Tiyupilu, ");
INSERT INTO mbtNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","su eyew egkanengnengan nu iya ka kamalehetan te langun ne impanulu keykew. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Te timpu ne si Hirudis ka mighari te Hudiya, due sabeka ne talagpanubad ne egngaranan ki Sakariyas ne puun te kabuhalan ni Abyas ne talagpanubad. Ne due asawa rin ne egngaranan ki Ilisabit ne puun ded degma te kabuhalan te me talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sikandan se alunggun, matareng diye te tangkaan te Manama wey mapahetpet ne migtuman te langun ne suhu wey Balaud te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ne ware anak dan su kene egpakaanak si Ilisabit, wey nabuyag e sikandan se alunggun. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ne migginguma ka aldew ne iyan egpamakey diye te timplu ka punduk enni Sakariyas te me talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ka batasan te me talagpanubad, egpintut-pintut sikandan ke nekey ka eggimuwen dan, wey si Sakariyas ka natinuru ne iyan egseled diye te timplu te Magbebaye ne Manama eyew egtutung te insinsu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te uras ne intutung e ka insinsu, mig-ampu ka masulug ne etew diye te lihawangan te timplu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ne dutu, due panalihan te Magbebaye ne migpakita kandin ne diye migsasindeg te dapit te igkakawanan te altar ne egtutungan te insinsu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Natingkemed si Sakariyas te pegkakita rin te panalihan, wey naaldek sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piru ingkahiyan sikandin te panalihan, “Kene ka egkaaldek Sakariyas. Indineg te Manama ka peg-ampu nu, ne kuntee eg-anak te lukes ka asawa nu ne si Ilisabit. Ne ngarani nu sikandin ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Egkahale-gale kew langun ke eglesut e sikandin, ");
INSERT INTO mbtNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","su egkeyimu sikandin ne mabantug diye te tangkaan te Magbebaye ne Manama. Ne keilangan ne kene sikandin eg-inum te binu wey ke egpekewubug ne eg-inumen, wey egkapenu sikandin te Panisingan te Manama minsan ke diye pad sikandin te getek te iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne igpalibed din ka masulug ne kabuhalan ni Israil diye te Magbebaye ne Manama ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eggun-a sikandin te Magbebaye, wey egpakaangken sikandin te Panisingan te Manama wey geem ne egpekeiling te ki prupita Ilyas dengan. Egpeg-ulien din ka nenekeg-ehet ne me amey wey me anak, wey egpaliberen din diye te maheteng ne dalan ka masinupaken ne me etew. Puun due, egkaandam din ka me etew para te pegginguma te Magbebaye.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ne migkahiyan ni Sakariyas ka panalihan, “Egmenuwen ku te pegkanengneng ne malehet ka inlalag nu? Su buyag ad ma seini wey buyag e degma ka asawa ku.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ne migtabak ka panalihan, “Sikeddi si Gabriil ka sinalihan te Manama. Impeendini a nikandin eyew te peglalag wey pegpanugtul keykew te seini ne meupiya ne panugtulen. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ne puun su ware ka migpalintutuu te ingkahi ku, egkeummew ka taman te aldew ne egkatuman e ka ingkahi ku keykew. Su egkatuman iya seeye te eleg ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ne dutu, migtetaharan te me etew si Sakariyas wey neinu-inu sikandan te naluhey sikandin diye te seled te timplu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te peglihawang din e, kenad sikandin egpakalalag wey migtingyasan din naan de sikandan. Puun due, nasabut dan ne due impakita kandin diye te seled te timplu. Ne neummew en iya sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te napenge e ka pegpamakey ni Sakariyas diye te timplu, mig-uli e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te ware naluhey, naberes e ka asawa rin ne si Ilisabit wey mig-uugpe de iya sikandin seled te lalimma ne bulan. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne migkahi si Ilisabit diye te geyinawa rin, “Kuntee neyid-u e ka Manama keddiey. In-awe din e ka hilew ku diye te tangkaan te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Te hen-em e ne bulan ka getek ni Ilisabit, insuhu te Manama ka panalihan ne si Gabriil diye te lungsud te Nasarit ne sakup te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Egpeendiyaan din ka sabeka ne mengebay ne egngaranan ki Mariya ne egpangasaween te sabeka ne kanakan ne egngaranan ki Husi ne kabuhalan ni Hari Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ne miggendiyad ka panalihan te kandin wey migkahi, “Kahale ka, Mariya! Migpanalanginan ka te Magbebaye wey egdumaan ka nikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nalibeg amana si Mariya meyitenged te narineg din wey impalemlem din ke nekey ka kaluwasan dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne migkahiyan sikandin te panalihan, “Kene ka egkaaldek, Mariya, su ingkeupii ka te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Egkaberes ka wey eg-anak te lukes, wey ngarani nu sikandin ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Egkeyimu sikandin ne mabantug wey eg-umawen sikandin ne Anak te Amana ne Mabantug ne Manama. Ne egpaharien sikandin te Magbebaye ne Manama iling te kaapuan din ne si Hari Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne egharian din ka me kabuhalan ni Hakub te ware egtamanan, ne ware katammanan te kandin ne peghari.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ne mig-insaan ni Mariya ka panalihan, “Egmenuwen ku naa te eg-anak te mengebay e mem pad?” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ne migtabak ka panalihan, “Eggendini te keykew ka Panisingan te Manama wey egdalungan ka te geem din. Puun due, ka matulus ne bate ne ig-anak nu egngaranan te Anak te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sumsumana nu ka suled nu ne si Ilisabit. Kahiyen ne kene din eg-anak. Piru kuntee egkasalayan e sikandin su hen-em e ne bulan ka getek din, minsan buyag e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Su ka Manama egpekeyimu te langun.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ne migkahi si Mariya, “Suluhuanen a te Manama. Egkeyitabu perem kayi te keddi ka inlalag nu.” Ne mig-awe e ka panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te peglihad te pila ne me aldew, migpanines si Mariya wey miglukut-lukut miggendiye te sabeka ne lungsud ne diye te me bubungan te Hudiya. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te pegginguma rin diye, migseled sikandin te baley enni Sakariyas wey migpangemusta ki Ilisabit. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te pegkarineg ni Ilisabit te laheng ni Mariya, migweil ka bate diye te getek din. Ne dutu, napenu si Ilisabit te Panisingan te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ne miglalag te meemen, “Te langun ne me malitan sikeykew re ka migpanalanginan te Manama, wey migpanalanginan degma ka bate ne ingkaberes nu! ");
INSERT INTO mbtNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hentew e naan de iya se impanumbalayan te iney te Magbebaye ku? ");
INSERT INTO mbtNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Su te pegkarineg ku te laheng nu, migweil te kahale ka bate kayi te getek ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Keupianan te seeye se migpalintutuu ne due katumanan te impanengneng te Manama diye kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ne migkahi si Mariya, “Egdayan a te Manama ");
INSERT INTO mbtNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","wey egkahale ka gimukud ku su ka Manama ka keddiey ne kaluwasan ");
INSERT INTO mbtNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tenged te nakasuman-suman sikandin keddiey te suluhuanen din ne kene ne impurtanti! Ne puun kuntee ka langun ne etew egkahi te impanalanginan a, ");
INSERT INTO mbtNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tenged te kein-inuwan ne innimu te maresen ne Manama kayi te keddiey. Matulus sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Egkeyid-u sikandin te langun ne due pegkaaldek diye te kandin, puun pad dengan wey minsan te keureme. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Migpakita sikandin te geem din wey impegsuwey-suwey rin ka me etew ne migpaambug te pegkeetew ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In-awe din ka me Hari diye te katungdanan dan wey imparibabew rin ka me etew ne kene ne impurtanti. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Impeyibhibulung din te me meupiya ka impanggutasan wey impaawe din ne ware me inuyanan ka me meyaman. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ne migbulihan din ka me kabuhalan ni Israil ne suluhuanen din, wey nakasuman-suman sikandin te hid-u rin ");
INSERT INTO mbtNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","diye te ki Abraham wey te langun ne me kabuhalan din te ware egtamanan sumale te insaad din diye te me kaapuan ta.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ne mig-ugpe si Mariya diye te ki Ilisabit seled te tatelu ne bulan. Nataman, mig-uli din e diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ne miggingume e ka timpu ne mig-anak e si Ilisabit wey lukes ka anak din. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nakarineg ka me sumbaley rin wey ka me karumaan din ne meupiya amana ka Manama diye te kandin ne nahale sikandan langun duma ki Ilisabit. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Te walu e ne aldew ka bate, migpanumbaley sikandan diye te ki Ilisabit eyew te pegtambung te pegtuli te bate. Ne egngaranan dan e perem ki Sakariyas ka bate su igsangey ran e te ngaran te amey rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piru migkahi ka iney rin, “Kene! Huwan ka igngaran kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne migkahiyan dan si Ilisabit, “Piru ware ma karumaan nu ne migngaranan te iling due!” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne migtingyasan dan ka amey te bate ne mig-inse, “Nekey-a ka igngaran nu te bate?” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ne migbuyu si Sakariyas te egsulatan, ne neinu-inu sikandan su ka insulat ni Sakariyas, “Huwan ka ngaran te bate.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ne sahuhune ne nakalalag e si Sakariyas wey indayan din ka Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne naaldek ka me sumbaley ran wey nekeempet te langun ne kabubunganan te Hudiya ka guhuren meyitenged te seeye ne neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ka me etew ne nakarineg te seeye ne guhuren, migsuman-suman wey migpein-inseey ke nekey ka katamanan te seini ne bate su ka himenew wey geem te Manama migduma kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Sakariyas ne amey ni Huwan, napenu te Panisingan te Manama wey migpanagne ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayanen ta ka Magbebaye ne Manama te Israil! Su miggendini sikandin eyew te peglekat te keet-etawan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Impeendini rin kayi te kanta ka maresen ne manluluwas, ne kabuhalan te suluhuanen din ne si Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ne seini degma ka impahuhud din te matulus ne me prupita rin dengan. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Intetaha sikandin ne egluwas kanta ligkat te me kuntere ta wey ligkat te karesen te me etew ne egdumut kanta. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Migkahi sikandin ne igkeyid-u rin ka me kaap-apuan ta wey egtantanuran din ka matulus ne kasabutan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Migpahunlibet sikandin diye te kaapuan ta ne si Abraham ");
INSERT INTO mbtNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ne egluwasen ki ligkat te me kuntere ta eyew egpakapamakey ki kandin te ware pegkaaldek. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ne egkeyimu ki ne matulus wey matareng diye te tangkaan din taman te egkabigtus e ka geyinawa ta. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ne sikeykew se anak ku, egngaranan ka te prupita te Amana ne Mabantug ne Manama su eggun-a ka te Magbebaye eyew eg-andam te egbayaan din; ");
INSERT INTO mbtNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","wey te pegnangen te keet-etawan din ne egkaluwas sikandan pinaahi te pegpasaylu te me sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Su amana ne hiimenawen wey hiid-uwen ka Manama. Sikan naa ka due igpeuyan din ne egluwas kanta ne egpekeiling te aldew ne egsile diye te langit ");
INSERT INTO mbtNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","eyew egkalayahan seeye se diye te marusilem wey egkaaldek te kamatayen. Igpanulud ki nikandin diye te dalan te keupianan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ne intulin ka anak ni Sakariyas wey indakel ka katuenan din wey ka pegpalintutuu rin. Diye sikandin mig-ugpe te mammara ne inged taman te migbunsud e sikandin migpanulu te matig-Israil. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te seeye ne timpu, miggimu te balaud ka Impiradur te Ruma ne si Agustu ne keilangan ne egpalista ka langun ne sakup din. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Seeye ka an-anayan ne pegsinsus te timpu ne si Siriniyu ka gubirnadur te Sirya. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Puun due, nangendiye ka langun ne etew te inged te me kaapuan dan eyew te pegpalista. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Seeye naa, si Husi ne matig-Nasarit ne sakup te Galiliya, miggendiye sikandin te Bitlihim ne sakup te Hudiya, ka ugpaan ni Hari Dabid dengan su kabuhalan sikandin ni Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Migparumeey sikandan ki Mariya ne egpangasaween din ne egkaberes e te seeye ne timpu eyew egpalista. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Te diyad sikandan te Bitlihim, miggingume e ka timpu ne eglesutan e si Mariya. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Migpanganayan sikandin te lukes, wey imbukusan din ka bate te manggad wey impeyibat din diye te sungguranan diye te ugpaan te me ayam su warad egkeyirehaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ne marani te seeye ne inged, due me talagtameng ne migpalayud te me karniru ran wey migpulan migbantey te me ayam dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te seeye ne karusileman, due migpakita kandan ne panalihan te Magbebaye wey nalayahan sikandan te layag te Magbebaye, wey naaldek amana sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Piru migkahiyan sikandan te panalihan, “Kene kew kaaldek, su seini a eyew te pegpangguhud kaniyu te meupiya ne panugtulen ne egpakapahale amana te langun ne keet-etawan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Su neetew kuntee diye te lungsud dengan ni Hari Dabid ka Manluluwas niyu, ka Kristu ne Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Seini ka palinneuwi niyu: egkakita niyu ka bate ne imbukusan te manggad wey impeyibat diye te sungguranan te me ayam.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne dutu, sahuhune ne due migpakita ne susuluhi ne me panalihan ne miglagpu kandin te migsaye te Manama ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dayanen ta ka Manama ne diye te langit, wey keupianan te me etew ne ingkahale din kayi te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te nanlibed e ka me panalihan diye te langit, migpanangnangeney e ka me talagtameng te me karniru ne migkahi, “Eggendiye ki te Bitlihim su egpitawen ta seini se impanengneng te Manama kanta.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Seeye naa, miglukut-lukut sikandan nangipanew, wey nakita ran diye si Mariya wey si Husi wey ka bate ne impeyibat diye te sungguranan te me ayam. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ne dutu, impangguhud dan e ka impanengneng kandan te panalihan meyitenged te bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne neinu-inu ka langun ne nakarineg te guhuren te me talagtameng te karniru kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Intetahu seeye ni Mariya diye te geyinawa rin wey layun din palemlema. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ne nanlibed e ka me talagtameng te karniru ne migdayan wey migsaye te Manama tenged te langun ne narineg wey nakita ran, sumale te impanengneng te panalihan kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Te walu e ne aldew ka bate, intulian e sikandin wey ingngaranan ki Hisus. Sika ka ngaran ne innangen te panalihan te ware pad ipangalalin ka bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Migginguma ka timpu ne miggendiye ensi Husi wey Mariya te Hirusalim eyew pegtuman te Balaud ni Muwisis meyitenged te peglinis te malitan ne miglesutan. In-uyan dan degma ka bate ne si Hisus eyew ighalad diye te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","su seini ka nasulat diye te Balaud te Magbebaye ne Manama, “Ka langun ne me panganey ne lukes keilangan ne ighalad diye te Magbebaye ne Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eyew egkalinisan ka miglesutan, egpanubad sikandan te daruwa ne tukmu, wey ke daruwa naa ne seleppati sumale te nasulat diye te Balaud te Magbebaye ne Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ne due etew diye te Hirusalim ne egngaranan ki Simyun ne egtetahad ne egpangabangan te Manama ka kabuhalan ni Israil. Matareng sikandin ne etew wey migpamakey te Manama, wey egduma layun kandin ka Panisingan te Manama ");
INSERT INTO mbtNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ne iyan migpanengneng kandin te kene din pad egpatey te kene din pad egkakita ka Kristu ne igpeuyan te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Insuhu sikandin te Panisingan te Manama ne egpaseleren diye te timplu. Te seeye ne timpu, in-uyan e te iney wey amey si Hisus diye eyew te pegtuman te insuhu te Balaud. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nakita ni Simyun ka bate wey insapipi rin, wey migsaye sikandin te Manama ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kuntee Magbebaye ne amana ne maresen, egkaayun ad ne egpatey, su nakapalene-lene e ka isip ku su natuman e ka inlalag nu. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Su nakita kud iya ka impeuyan nu ne Manluluwas ");
INSERT INTO mbtNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne intahahe nu ne igpakita te langun ne keet-etawan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sika ka layag ne egpanulud te kene ne me Hudiyu peendiye te keykew, wey egbehey te kabantug te keet-etawan nu ne kabuhalan ni Israil.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Neinu-inu ka amey wey iney te inlalag ni Simyun meyitenged te bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ne impanalanginan sikandan ni Simyun wey ingkahiyan din si Mariya ne iney te bate, “Seini ne bate in-alam te Manama eyew pegpariralem wey pegparibabew te masulug ne me etew te Israil. Sikandin ka palinneu ligkat te Manama ne egdali-dian te me etew ");
INSERT INTO mbtNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","wey egkasakitan ka degma iling te egsundangen te kampilan ka pusung nu. Ne igpanengneng din ka neeles ne suman-suman te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Due degma sabeka ne malitan ne prupita ne egngaranan ki Ana ne anak ni Panuwil ne kabuhalan ni Asir. Buyag e sikandin, wey migpalunglungguney sikandin te asawa rin te pitu re ne leg-un, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wey nabalu e sikandin. Migwalu ne pulu wey hep-at (84) e ne leg-un sikandin, wey layun de sikandin eg-uugpe diye te timplu ka egsimba, egpuasa wey eg-ampu tagse maaldew wey marusilem. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ne dutu, migparani sikandin diye te engki Husi wey migpasalamat te Manama, wey miglalag sikandin meyitenged te bate diye te langun ne egtetahad ne egluwasen te Manama ka Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Te napengaan e enni Husi wey Mariya ka langun ne nasulat diye te Balaud te Magbebaye ne Manama, mig-uli e sikandan diye te lungsud dan ne sakup te Galiliya ne iyan ka Nasarit. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ne migtulin e ka bate wey manekal e ka lawa rin, wey dakel ka tahu te ulu rin, wey impanalanginan sikandin te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tagse leg-un ne eggendiye ka iney wey amey ni Hisus te Hirusalim ka egtambung te Sahakeen te Peglihad te Panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te sapulu wey daruwe (12) e ne leg-un si Hisus, migtambung sikandan te sahakeen sumale te nabatasan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te napenge e ka pegsahakeen, nanguli e sikandan piru migpalunggehaat si Hisus diye te Hirusalim. Ware nanengnengi seeye te iney wey amey rin, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","su kahiyen dan ne migluyud sikandin te me etew. Te migsenge kaaldew e sikandan ka miggipanew, impammitew ran si Hisus diye te me karumaan dan wey te me alukuy ran, ");
INSERT INTO mbtNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","piru ware dan kitaa sikandin. Sikan naa ka miglibed sikandan diye te Hirusalim eyew te pegpammitew kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te igkatelu e ne aldew, nakita ran e si Hisus diye te timplu ne migpinnuu duma te me talagpanulu te Balaud te Manama. Migpammineg sikandin wey mig-inse-inse kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ka langun ne nakarineg kandin, neinu-inu sikandan te katuenan din wey te pegpanabak din. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Neinu-inu ka iney rin wey ka amey rin te pegkakita ran kandin. Ne migkahiyan sikandin te iney rin, “Tatu, mania te innimu nu seini kayi te kanami? Neipeng key te amey nu te pegpammitew ney keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ne intabak ni Hisus sikandan, “Mania te egpammitawen a nikaniyu? Ware kew bes nakanengneng te keilangan ne kayi a te baley te Amey ku?” ");
INSERT INTO mbtNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piru ware sikandan nakasabut te inlalag din kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne migdume e si Hisus kandan te mig-uli diye te Nasarit wey migparuma-ruma sikandin kandan. Seini se langun intetahu ni Mariya diye te geyinawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne migdakel pad ka kaalam ni Hisus wey migpabulus migtulin, wey ingkeupii sikandin te Manama wey te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Te igkasapulu wey lalimma (15) ne leg-un te pegmandu ni Hari Tibiriyu, si Punsiyu Pilatu ka gubirnadur diye te Hudiya. Ne si Hirudis ka migmandu diye te Galiliya, wey ka kakey rin ne si Pilipi ka pangulu diye te Ituriya wey diye te Trakuniti. Ne si Lisanyas ka pangulu diye te Abilina, ");
INSERT INTO mbtNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","wey ensi Anas wey Kaypas ka me pangulu diye te timplu. Te seini ne timpu inlalahan te Manama ka anak ni Sakariyas ne si Huwan te diye din te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ne miggendiye si Huwan te langun ne inged ne marani te weyig ne Hurdan ka migwali ne migkahi, “Inniyuhi niyu ka me sale niyu wey pabewutismu kew eyew egpasayluwen te Manama ka me sale niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sumale te nasulat ni prupita Isayas ne eggenendue, “Due egpanguleyi diye te inged ne ware mahinged ne egkahi: ‘Andama niyu ka dalan te Magbebaye. Tul-ira niyu ka egbayaan din! ");
INSERT INTO mbtNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Buneli niyu ka langun ne migleb-eng-leb-eng, Pataha niyu ka langun ne labuntud wey ka me bubungan, Tul-ira niyu ka natiku-tiku ne dalan, Ay-ayari niyu ka migpagpahendak ne dalan. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eyew egkakita te langun ne etew ka kaluwasan ne egpuun diye te Manama!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ne due masulug ne etew ne nangendiye te ki Huwan eyew egpabewutismu kandin. Ingkahiyan ni Huwan sikandan, “Sikaniyu se me etew, iling kew te uled! Hentew ka miglalag kaniyu ne egpakaalihu kew te langet te Manama ne mahaan e egginguma? ");
INSERT INTO mbtNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ipakita niyu pinaahi te himu niyu ne mig-inniyuhan niyud e ka me sale niyu. Ne kene kew palalahey ne kabuhalan kew ni Abraham. Su egnangenan ku sikaniyu te egkaayun ne egpabaluyen te Manama ne me etew ka seini se me batu eyew eggimuwen ne kabuhalan ni Abraham. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Andam e ka perekul te pegpeled te kayu ne kene egbebehas te meupiya; egtempuhen, eggulayen ne igtemeg.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mig-inse ka me etew ki Huwan, “Nekey naa ka eggimuwen ney?” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne migtabak sikandin, “Ka etew ne due daruwa se kumbale keilangan ne igbehey rin ka sabeka diye te etew ne ware kumbale, wey ka etew ne due pegkeen keilangan ne egbehayan din seeye se etew ne ware egkakeen.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Due me etew ne talagsukut te buhis ne nangendiye eyew te pegpabewutismu wey in-insaan dan si Huwan, “Talagpanulu. Nekey-a ka eggimuwen ney?” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Migtabak si Huwan kandan, “Kene niyu pasubleyi ka insuhu kaniyu te balaud ne igpasukut.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ne mig-inse degma ka me sundalu kandin, “Sikanami degma. Nekey-a ka eggimuwen ney?” Ne migtabak si Huwan kandan, “Kene kew paneleppi te minsan hentew pinaahi te pehes, wey kene kew pangawang egpamayung. Keilangan ne egkabennalan kew e te igsuwildu kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Puun dutu, migsalig e ka me etew ki Huwan wey migsuman-suman ne kema ke sikandin buwad ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ne migkahiyan ni Huwan sikandan langun, “Egbewutismu a kaniyu pinaahi te weyig, piru due egginguma ne subla pad ne maresen keddiey. Minsan sikeddi, kena a ne likes ne eggekad te hiket te sandal din. Sikandin ka egbewutismu kaniyu te Panisingan te Manama wey te hapuy. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ne egpekeiling sikandin te sabeka ne etew ne miggen-gen te nihu ne ig-etap te inggaani rin eyew ka ukaba ig-esa te behas. Ne eglimuren seeye se meupiya ne behas diye te lelapeng piru ka ukaba egsilaban te hapuy ne kene egkeebukan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ne nalein-lein ne me panunggilingan ka inggamit ni Huwan te migpanulu wey te migwali te Meupiya ne Panugtulen diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Piru indew-ey ni Huwan si Gubirnadur Hirudis su in-ahew rin ma si Hirudiyas, ka asawa te suled din wey masulug pad ka neyimu rin ne mareet. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nekeyimu pad man-e si Hirudis te amana ne mareet ne iyan ka pegpaprisu rin ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te nabewutismuwan e ka langun ne etew, imbewutismuwan e degma si Hisus. Te mig-ampu pad sikandin, nalukatan ka langit, ");
INSERT INTO mbtNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","wey miglene diye te kandin ka Panisingan te Manama ne egpekeiling te seleppati. Ne due laheng diye te langit ne migkahi, “Sikeykew ka pinalangge ku ne Anak. Amana a nahale keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ne si Hisus migbunsud te himu rin te me tatelu e ne pulu (30) ka idad din. Ka suman-suman te me etew ne anak sikandin ni Husi ne anak ni Hili. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Hili anak ni Matat ne anak ni Libi. Si Libi anak ni Milki ne anak ni Hana. Si Hana anak ni Husi ");
INSERT INTO mbtNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ne anak ni Matatiyas. Si Matatiyas anak ni Amus ne anak ni Nahum. Si Nahum anak ni Isli ne anak ni Nagai. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai anak ni Maat ne anak ni Matatiyas. Si Matatiyas anak ni Simii ne anak ni Husik. Si Husik anak ni Huda ");
INSERT INTO mbtNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ne anak ni Huwanan. Si Huwanan anak ni Risa ne anak ni Surubabil. Si Surubabil anak ni Salatiil ne anak ni Niri. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Niri anak ni Milki ne anak ni Adi. Si Adi anak ni Kusam ne anak ni Ilmadam. Si Ilmadam anak ni Ir. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Ir anak ni Huswi ne anak ni Iliisir. Si Iliisir anak ni Hurim ne anak ni Matat. Si Matat anak ni Libi. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Libi anak ni Simyun ne anak ni Huda. Si Huda anak ni Husi ne anak ni Hunam. Si Hunam anak ni Ilyakim ");
INSERT INTO mbtNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ne anak ni Miliya. Si Miliya anak ni Mina ne anak ni Matata. Si Matata anak ni Natan ne anak ni Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Dabid anak ni Hisi ne anak ni Ubid. Si Ubid anak ni Buas ne anak ni Salmun. Si Salmun anak ni Nasun ");
INSERT INTO mbtNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ne anak ni Aminadab. Si Aminadab anak ni Admin ne anak ni Arni. Si Arni anak ni Isrum ne anak ni Piris. Si Piris anak ni Huda ");
INSERT INTO mbtNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ne anak ni Hakub. Si Hakub anak ni Isaak ne anak ni Abraham. Si Abraham anak ni Tira ne anak ni Nahur. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahur anak ni Sirug ne anak ni Riyu. Si Riyu anak ni Pilig ne anak ni Ibir. Si Ibir anak ni Sala. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala anak ni Kainan ne anak ni Arpaksad. Si Arpaksad anak ni Sim ne anak ni Nuwi. Si Nuwi anak ni Lamik ");
INSERT INTO mbtNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ne anak ni Mitusila. Si Mitusila anak ni Inuk ne anak ni Harid. Si Harid anak ni Mahalaliil ne anak ni Kainan. ");
INSERT INTO mbtNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kainan anak ni Inus ne anak ni Sit, wey si Sit anak ni Adan ne anak te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Napenu si Hisus te Panisingan te Manama wey mig-awe sikandin diye te Hurdan, wey in-uyan sikandin te Panisingan te Manama diye te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne dutu tintala te ahalen te me busew seled te hep-at ne pulu (40) ne aldew. Te seeye ne timpu ware migkeen si Hisus. Nataman, miggutasan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne migkahiyan sikandin te ahalen te me busew, “Ke malehet kema ne anak ka te Manama, pabaluya nu ne paan seini se batu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ne migtabak si Hisus, “Nasulat te Kasulatan ne miggenendue, ‘Kene egkeuyag ka etew te egkeelin de ne keenen.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nataman, in-uyan e si Hisus te ahalen te me busew diye te ampew wey impapitew kandin ka langun ne me inged kayi te ampew te tane te sabeka re ne pegpele-pele. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne migkahiyan sikandin te ahalen te me busew, “Igbehey ku diye te keykew ka langun ne katenged wey ka langun ne karatuan. Su imbehey keddi seini langun wey sikeddiey ka mateu ke hentew ka igkeupii ku ne egbehayan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Egkakeykew seini se langun ke egsimba ka keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne migtabak si Hisus, “Nasulat te Kasulatan ne miggenendue, ‘Simbaa nu ka Magbebaye ne Manama nu wey sikandin de pamakaya nu!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne in-uyan din e man-e si Hisus diye te Hirusalim wey diye itahu te kinaribabawan te timplu, wey migkahiyan, “Ke anak ke ma te Manama, tinugpu ka seeye te diralem. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Su nasulat te Kasulatan, ‘Egsuhu ka Manama te me panalihan din te pegbantey keykew. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Egtapayeen ka nikandan, eyew kene egpakabaras te batu ka paa nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ne migtabak si Hisus, “Ka Kasulatan migkahi, ‘Kene nu tintala ka Magbebaye ne Manama nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nataman, te neimpusan e sikandin tintala te ahalen te me busew te langun-langun de iya ne paahi, in-engkeran pad sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ne mig-uli e si Hisus diye te Galiliya ne due te kandin ka geem te Panisingan te Manama. Nekeempet te seeye ne inged ka pangguhuren meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Migpanulu sikandin diye te me simbaan te me Hudiyu wey indayan sikandin te langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ne miggendiye si Hisus te Nasarit ne migtulinan din. Te Aldew te Peggimeley, miggendiye sikandin te simbaan te me Hudiyu sumale te batasan din. Ne migsasindeg sikandin eyew te pegbasa te Kasulatan, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ne imbehayan sikandin te inlulun ne baseen ne sinulat ni prupita Isayas. Imbelat din seeye wey te pegkakita rin te impamitew rin imbasa rin e, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kayi te keddiey ka Panisingan te Manama, su in-alam a nikandin eyew te pegwali te Meupiya ne Panugtulen diye te egkengaayu-ayu. Insuhu a nikandin eyew te pegpangguhud te neneuripen meyitenged te kaligwangan dan, wey pegbawi te me butud; wey pegpangabang te seeye se me indeeg-deeg, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","wey pegpataha ne miggingume e ka timpu te Magbebaye ne Manama ne egluwasen din e ka me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ne inlulun e ni Hisus ka baseen wey inlibed din diye te impiyalan wey migpinnuu e sikandin ka egpanulu. Migmemetmet kandin ka langun ne etew diye te seled te simbaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne migkahiyan din sikandan, “Natuman e kuntee ne aldew ka narineg niyu puun te Kasulatan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nakareyrey sikandan langun ki Hisus wey neinu-inu te me meupiya ne guhuren ne inlalag din. Migkahi sikandan, “Kene naa ne anak ni Husi seini?” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ne migkahiyan sikandan ni Hisus, “Migpalintutuu ad iya ne iglalag niyu perem keddiey ka panunggilingan ne eggenendue, ‘Talagbawi, un-uneyi nu bawii ka lawa nu.’ Ne iyan igpasabut due, ‘Himuwa nu degma kayi te inged nu ka narineg ney ne innimu nu diye te Kapirnaum.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ne migkahi si Hisus, “Egkahiyan ku sikaniyu te malehet: kene eg-ileen ka sabeka ne prupita diye te inged ne intulinan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sumsumana niyu dengan te timpu pad ni Ilyas ne miggulabung te tatelu ne leg-un wey liware, wey nabitil te masumpit ka me etew. Ne malehet ne masulug ka me balu kayi te Israil, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","piru ware ipeendiye si Ilyas te minsan hentew kandan su diye mule te balu ne matig-Saripta ne sakup te Sidun. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne due masulug degma ne me ibungen kayi te Israil te timpu ni prupita Ilisyu, piru ware sabeka kandan ne nabawian su si Naaman de iya ne matig-Siriya.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te pegkarineg dutu te langun ne diye te seled te simbaan te me Hudiyu, nalangetan amana sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ne dutu, nanasindeg e sikandan wey inggehanuy ran e si Hisus diye te lihawangan te lungsud peendiye te tikeba te bubungan ne impasasindehan dan te lungsud dan. Eg-uuluhen dan e perem si Hisus diye te tikeba, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","piru miggipanew sikandin diye te taliware te me etew ne migpariyu e. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ne migtupang e si Hisus peendiye te Kapirnaum, sabeka ne siyudad diye te Galiliya. Migpanulu sikandin te me etew te Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Neinu-inu ka me etew te kandin ne pegpanulu su due geem te kandin ne lalag. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne diye te seled te simbaan te me Hudiyu, due etew ne migserepan te busew ne migbalbalukan ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hisus ne matig-Nasarit! Nekey-a ka eggimuwen nu kayi te kanami? Iyan nu innendini ka egdereet kanami? Nekeila a keykew: sikeykew ka Matulus ne Impeuyan te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Piru insaparan ni Hisus ka busew, “Peeneng-eneng ka! Awe ka due te kandin!” Ne impabahed e te busew ka etew diye te tangkaan te me etew, wey mig-awe e ka busew ne ware namenu ka etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Neinu-inu ka langun ne etew wey migpanangnangeney ne migkahi, “Nekey buwa seini ne pegpanulu? Mania te due katenged wey geem te seini ne etew ne egpaawe te busew?” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne nekeempet ka guhuren meyitenged ki Hisus diye te langun ne me inged ne marani dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ne mig-awe e si Hisus diye te simbaan te me Hudiyu wey miggendiyad e te baley ni Simun. Te seeye ne timpu, miglusungan te mangune-kune ka anuhang ni Simun ne malitan, wey innangenan dan e si Hisus ne egbawian sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Seeye naa, migdugpu sikandin diye te miggibatan te malitan, wey impaawe din ka lusung. Ne due-rue ne neulian e ka malitan ne mig-enew sikandin wey intanggu rin e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te miglineb e ka aldew, mig-uyan te me etew diye te ki Hisus ka me alukuy ran ne egmanderalu te nalein-lein ne dalu. Ne dutu, in-atul e ni Hisus sikandan tel-ebi te belad din wey neulian sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne impalihawang din degma puun te masulug ne me etew ka me busew wey migmanguleyi ne migkahi, “Sikeykew ka Anak te Manama!” Piru insaparan ni Hisus ka me busew wey ware din palalaha tenged su nakanengneng sikandan ne sikandin ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te malayag e, mig-awe si Hisus diye te lungsud wey miggendiyad e te inged ne ware etew. Ne impammitew sikandin te me etew. Te nakita ran e sikandin, inggawiran dan perem sikandin ne kene pad eg-awe diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piru ingkahiyan din sikandan, “Keilangan ne igwali ku degma ka Meupiya ne Panugtulen meyitenged te Peghari te Manama diye te duma ne me siyudad, su seini ka tuyu te Manama te pegpeendini rin keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne in-empet din te migwali ka me simbaan te me Hudiyu diye te Hudiya. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Due timpu ne migsasindeg si Hisus diye te ilis te lanew te Ginisarit ka egpanulu, wey egmekegsegseg e ka me etew diye te kandin ka egpammineg te lalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne due daruwa ne balangey ne nakita ni Hisus diye te ilis te lanew ne mig-engkeran te me mangngengalap su egpanlu-lu sikandan te me biyale dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ne dutu, mig-untud e si Hisus te sabeka ne balangey ne iyan kamuney si Simun. Inhangyu din si Simun ne bayew igtuu ka balangey peendiye te weyig, ne migpinnuu e sikandin wey migpanulu te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te nekeimpus e sikandin ka migpanulu, migkahiyan din e si Simun, “Hendiye ka te maralem wey isawile niyu ka me biyale niyu eyew egpekeutel kew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ne migtabak si Simun, “Talagpanulu, napawaan key ka migngengalap wey warad iya neutel ney. Piru puun su migkahi ke ma, igsawile ku ka me biyale ney.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne intuman dan ka ingkahi ni Hisus wey amana ne dakel ka ngalap ne migsahad te biyale dan, wey hapit e egkengahisi ka me biyale dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ne ingkamey ran ka me duma ran diye te dangeb ne balangey ne egpeparaniyen kandan wey egpabulihen. Migparani kandan ka me duma ran wey innipenu dan te ngalap ka daruwa ne balangey, sikan naa ka egkahan-ganaran e sikandan egkatanled. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te pegkakita ni Simun Pidru dutu, migpanimbuel sikandin diye te tangkaan ni Hisus ne migkahi, “Magbebaye, pariyu ka keddiey su makasesala a ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nakahi rin sika su neinu-inu sikandin wey ka me duma rin te amana ne dakel ka neutel dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Neinu-inu degma ka me duma ni Simun ne ensi Santiyagu wey Huwan ne me anak ni Sibidiyu. Ne migkahiyan ni Hisus si Simun, “Kene ka kaaldek. Puun kuntee, etew e ka eggingutelen nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Te nakapeilis dan e ka me balangey ran, mig-engkeran dan ka langun, wey mig-ikul ran e ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te diye pad si Hisus te sabeka ne siyudad, due sabeka ne etew ne ibungen. Te pegkakita rin ki Hisus, mig-usengul sikandin diye te tangkaan ni Hisus ne migpeyid-u-hid-u ne migkahi, “Magbebaye, ke egkeupian ka, egkabawian a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ne insamsam ni Hisus ka etew te migkahi, “Uya, igkeupii ku. Egkeulian kad!” Sahuhune neulian ka ibungen. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ne migkahiyan ni Hisus ka etew, “Kene nu ipangguhud seini te minsan hentew. Ne hendiye kad te talagpanubad wey papitew ka kandin ne warad e ka dalu nu wey panubad ka sumale te insuhu ni Muwisis eyew te pegpamalehet te me etew ne neulian kad e.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piru nasi de iya nekeempet ka guhuren meyitenged ki Hisus. Purisu masulug ka me etew ne nangendiye eyew te pegpammineg ki Hisus wey eyew egpabawi te me dalu ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piru egsabsabeka layun si Hisus ne eggendiye te mammara ne inged ne kene egkeugpaan, wey eg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sabeka ne aldew te migpanulu si Hisus, due me Parisiyu wey me talagpanulu te Balaud te Manama ne naminnuu dutu ne diye namuun te lein-lein ne me inged ne sakup te Galiliya, Hudiya wey Hirusalim. Ne imbehayan si Hisus te geem te Manama te pegpamawi te egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Due nanginguma ne me etew ne migyayung te etew ne kene egkaweil se lawa. Egseled perem sikandan te baley eyew igpakasabuk dan ka etew diye te tangkaan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piru ware sikandan nakaseled diye te baley tenged su masulug ka me etew. Ne in-uyan dan e seeye se etew diye te atep wey inlelekat dan ka atep ne tisa wey intuntun dan e ka etew ne impeyibat diye te hibatanan din. Ne diye dan ipalenged te taliware te me etew te tangkaan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te pegkakita ni Hisus ne dakel ka pegpalintutuu ran, migkahiyan din e ka kene egkaweil se lawa, “Suled, impasaylu e ka me sale nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ne ka me talagpanulu te Balaud te Manama wey ka me Parisiyu nekeinse diye te geyinawa ran, “Hentew-a ne etew seini se egbaley-baley te Manama? Ware etew ne egpakapasaylu te me sale, su ka Manama re!” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piru natahaan ni Hisus ka suman-suman dan ne migkahiyan din sikandan, “Mania te egsuman-suman kew te iling due? ");
INSERT INTO mbtNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hendei bes ka malemu: ka egkahi, ‘Impasaylu e ka me sale nu,’ wey ke egkahi, ‘Enew ka wey hipanew kad’? ");
INSERT INTO mbtNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Piru igpapitew ku kaniyu ne due katenged te Anak te Etew kayi te ampew te tane te pegpasaylu te me sale.” Ne migkahiyan din ka etew ne kene egkaweil se lawa, “Enew ka, wey uyana nu ka hibatanan nu wey uli kad e diye te kaniyu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ne sahuhune ne migsasindeg ka etew diye te tangkaan te me etew ne migsabilbil te hibatanan din. Ne mig-uli e sikandin ne migdayan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nawangalan ka langun ne etew wey naaldek degma sikandan, wey indayan dan ka Manama ne migkahi, “Kein-inuwan amana ka nakita ta kuntee!” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pegkapenga dutu, miggipanew e si Hisus wey due nakita rin ne talagsukut te buhis ne egngaranan ki Libi ne migpinpinnuu diye te upisina rin. Ne migkahiyan ni Hisus sikandin, “Ikul ka keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ne migsasindeg si Libi wey mig-engkeran din e ka langun te mig-ikul ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nataman, migsahakeen si Libi te dakel diye te baley rin para ki Hisus. Due degma masulug ne me etew ne miglagpu kandan te migkeen wey me talagsukut te buhis iya ka duma kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Due me Parisiyu wey me talagpanulu te Balaud te Manama ne migbahulbul diye te me hibateen ni Hisus. Ne mig-inse sikandan, “Mania te migpakiglagpu kew migkeen wey mig-inum due te me talagsukut te buhis wey te duma ne me makasesale?” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ne migtabak si Hisus diye te kandan, “Ka me etew ne ware dalu, kene egkeilangan te talagbawi, ke kene, seeye de se egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wara a miggendini eyew te peg-umew te me matareng, ke kene, te me makasesale eyew eg-inniyuhan dan ka me sale dan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Due me etew ne migkahi diye te ki Hisus, “Ka me hibateen ni Huwan malasi ne egpuasa wey eg-ampu, wey iling ded degma ka me hibateen te me Parisiyu. Piru ka me hibateen nu, migpabulus mule migkeen wey mig-inum.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne migtabak si Hisus, “Egpapuaseen niyu naa ka mahaliyug te egpangasawa ke duma ran pad sikandin? Kene iya! ");
INSERT INTO mbtNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piru egginguma ka timpu ne eg-angayen e diye te kandan ka egpangasawa, ne egpuase e sikandan te seeye ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne migpangguhuran pad man-e sikandan ni Hisus te me panunggilingan, “Ware etew ne eggisi te iyam ne kumbale eyew igtupak din te tapey ne kumbale. Su ke eggimuwen din sika, egkareetan e ka iyam ne kumbale, wey kene man-e eggayul ka iyam ne igtupak diye te tapey ne kumbale ne egtupakan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne ware degma etew ne egtahu te iyam ne binu diye te tapey ne tahuanan ne laplap te mananap, su ke eggimuwen din sika, egbetu ka tahuanan wey egkeitis e ka binu ne egkareetan e degma ka tahuanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ka iyam ne binu keilangan ne diye igtahu te iyam ne tahuanan ne laplap. ");
INSERT INTO mbtNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ware etew ne egkeibeg pad eg-inum te iyam ne binu ke nalayam e sikandin te tapey ne binu, su suman-suman din ne meupiya pad iya ka tapey ne binu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te sabeka ne Aldew te Peggimeley, nangipanew ensi Hisus ne diye migbaye te impamulaan te trigu. Ne nangetu te me trigu ka me hibateen din ne ingkusu ran wey ingkeen dan e. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Piru due me Parisiyu ne migkahi, “Hey, mania te miggimu kew te supak te Balaud te Aldew te Peggimeley?” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne migkahiyan ni Hisus sikandan, “Ware kew bes nakasabut te imbasa niyu meyitenged te innimu ni Dabid te miggutasan sikandan te me duma rin? ");
INSERT INTO mbtNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Migseled sikandin diye te baley te Manama wey mig-angey te paan ne inhalad e diye te Manama. Ne sumale te kanta ne Balaud, ka me talagpanubad de ka intuhutan ne egpakakeen dutu, piru migkeen si Dabid wey impamehayan din pad ka me duma rin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne migkahiyan pad man-e ni Hisus sikandan, “Ka Anak te Etew iyan ahalen te Aldew te Peggimeley.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Te lein e man-e ne Aldew te Peggimeley, migseled si Hisus diye te simbaan te me Hudiyu ka egpanulu. Ne due etew diye ne nakengkeng se kawanan ne belad. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Due degma me talagpanulu te Balaud te Manama wey me Parisiyu ne eg-iipat ki Hisus ke egbawian din te Aldew te Peggimeley seeye se etew su eyew igkasumbung dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piru nanengnengan ni Hisus ka suman-suman dan, wey migkahiyan din e ka etew ne nakengkeng se belad, “Sasindeg ka wey hendini ka te tangkaan.” Ne migsasindeg ka etew wey miggendiye te tangkaan te langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne migkahiyan ni Hisus sikandan, “Due inse ku kaniyu: Nekey bes ka intuhut te kanta ne Balaud ne eleg ne eggimuwen ta te Aldew te Peggimeley? Ka pegbulig naa wey ke pegdereet? Ka pegluwas naa wey ke peggimatey?” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne migpanil-ap-sil-ap din ka langun wey ingkahiyan din ka etew, “Ketenga nu ka belad nu.” Ne ingketeng te etew ka belad din wey neulian e. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Piru nalangetan amana sikandan ne migpalalahey ke nekey se eggimuwen dan diye te ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te seeye ne timpu, migtakereg si Hisus diye te bubungan eyew te peg-ampu, wey napawaan sikandin ka mig-ampu te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te maselem e, in-umew rin ka me hibateen din wey mig-alam sikandin te sapulu wey daruwa (12) kandan ne ingngaranan din te apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Seini ka impangalam din: si Simun ne mig-immuan din ki Pidru wey si Andris ne suled din, si Santiyagu wey si Huwan, si Pilipi wey si Bartulumi, ");
INSERT INTO mbtNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Matiyu wey si Tumas, si Santiyagu ne anak ni Alpiyu wey si Simun ne ribildi, ");
INSERT INTO mbtNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Hudas ne anak ni Santiyagu, wey si Hudas Iskaryuti ne talag-eakal. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne nanupang e ensi Hisus te me hibateen din diye te napu. Dutu due masulug ne me hibateen din wey susuluhi ne etew ne diye egpuun te intiru ne Hudiya wey Hirusalim, wey te me inged ne sakup te siyudad te Tiru wey te Sidun ne maddani te dahat. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Miggendiye sikandan te ki Hisus eyew egpammineg kandin wey eyew egpabawi te me dalu ran. Impamawian din degma ka nanerepan te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Amana iya egkeupian ka langun ne etew ne egpakasamsam kandin, su due geem ne egpuun diye te kandin ne egpakabawi kandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ne migtengteng si Hisus te me hibateen din ne migkahi: “Keupianan niyu te egkengaayu-ayu, su egkasakup kew te Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Keupianan niyu te eggutasan kuntee, su eggibulungen kew keureme. “Keupianan niyu te egsinehew kuntee, su egngingisi kew keureme. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Keupianan niyu te egdumutan, egsamsamilian, egpeyilawan, wey egdereetan te me etew se ngaran tenged te Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ne iling ded due ka innimu te me kabuybuyahan dan diye te me prupita. Purisu gale-gale kew wey letu kew te kahale ke eggimuwen dan sika due te kaniyu, su dakel ka dasag ne intahahe kaniyu diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Piru mekeyid-u-hid-u kew kangkuwa se me meyaman, su naheraman niyud ka meupiya ne peg-ugpe! ");
INSERT INTO mbtNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ne mekeyid-u-hid-u kew kangkuwa se nenabulung, su eggutasan kew red keureme. “Ne mekeyid-u-hid-u kew kangkuwa se egngingisi, su eglungku wey egsinehew kew red keureme. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mekeyid-u-hid-u kew kangkuwa ke egdeyrayen kew te langun ne etew, su sika ka innimu te me kabuybuyahan dan diye te kene ne malehet ne me prupita.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Piru kuntee, egnangenan ku sikaniyu se migpammineg keddiey te geyinawei niyu ka me kuntere niyu wey himuwa niyu ka meupiya diye te seeye se egdumut kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Panalangini niyu ka me etew ne egdilus kaniyu wey panubtubari niyu ka me etew ne egdeeg-deeg kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ke due egtagpi te beneng niyu, ipatagpi niyu degma ka limang; ke due eg-ahew te dyakit niyu, ibehey niyu sika minsan ka kumbale niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Behayi niyu ka langun ne egbuyu, ne ke due eg-angey te kasangkapan niyu kene niyud gawia. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ke nekey ka igkeupii niyu ne eggimuwen te me etew diye te kaniyu, sika degma himuwa niyu diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kene kew pallateng ne due egkarawat niyu ne dasag ne egpuun te Manama ke iyan niyu re eggeyinawaan ka eggeyinawa degma kaniyu. Su minsan ka me makasesale, eggeyinawa ma te seeye se eggeyinawa kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne emun ke iyan niyu re eg-ay-ayaran ka meupiya degma kaniyu, nekey naa ka egkarawat niyu ne dasag ne egpuun te Manama? Su minsan ka me makasesale, eg-ay-ayaran dan ma ka me duma ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne emun ke iyan niyu re egpasambayen seeye se natahaan niyu ne egpakabayad, nekey naa ka egkarawat niyu ne dasag ne egpuun te Manama? Minsan ka me makasesale egpasambey ma te iling dan ne makasesale su mig-iman-iman sikandan ne egpakabayad iya sikandan te egsambayan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Geyinawei niyu iya ka me kuntere niyu wey himuwa niyu ka meupiya diye te kandan. Pasambaya niyu sikandan te ware peg-iman-iman ne egkaliwanan ded seeye. Ke iling due ka eggimuwen niyu, dakel ka dasag ne egkarawat niyu wey egkeyimu kew ne me anak te Amana ne Mabantug ne Manama. Su meupiya sikandin te seeye se kene egpasalamat wey te seeye se mareet. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Keilangan ne hiid-uwen kew, iling te Amey niyu ne hiid-uwen. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kene kew hukum te duma ne kene kew degma eggukuman te Manama. Kene kew kahi diye te duma ne keilangan ne egdusaan sikandan, ne kene kew degma egdusaan te Manama. Pasayluwa niyu sikandan ne egpasayluwen kew degma te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Behey kew te duma ne egbehayan kew degma te Manama. Egkarawat niyu ka eleg ne seked, egdaseken, egkigkihuen, wey egpasublaan pad. Ka seked ne eggamiten niyu diye te duma, sikan ded degma ka seked ne eggamiten te Manama diye te kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ne migpangguhuran sikandan ni Hisus te seini ne panunggilingan, “Kene egpakakitkit ka sabeka ne butud te lein ne butud su egkengeulug iya sikandan diye te lungag. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ware hibateen ne labew te kandin ne talagpanulu piru ke napanulu e sikandin wey nabasbas e amana, egpekeiling sikandin te kandin ne talagpanulu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mania te egtengteng ka te buleg te duma piru ware nu sahipaa ka buleg nu ne hendue karakel te terusu? ");
INSERT INTO mbtNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Egmenuwen nu te egkahi diye te duma nu, ‘Eg-aween ku ka buleg nu,’ ke ware nu degma nakita ka buleg nu ne hendue karakel te terusu. Egpapitew-pitew re! Hun-eyi nu pa te eg-awe ka buleg nu ne hendue karakel te terusu, eyew egpakameleg-meleg ka ne eg-awe te buleg te duma nu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ka meupiya ne kayu kene egbebehas te mareet, ne ka mareet ne kayu kene egbebehas te meupiya. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka tagse kayu egkeila pinaahi te behas din. Su ka buleynen, kene egbebehas te beyabas, ne ka sapinit, kene egbebehas te kapayas. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ka meupiya ne etew, eglalag te meupiya ligkat te meupiya ne pusung din. Ne ka mareet ne etew, eglalag te mareet ligkat te mareet ne pusung din. Su ke nekey ka diye te pusung te etew, iyan sika ka iglalag din.” ");
INSERT INTO mbtNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mania te eg-umew kew keddi te ‘Magbebaye, Magbebaye,’ ne kene kew eggimu sumale te insuhu ku kaniyu? ");
INSERT INTO mbtNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Igpakita ku kaniyu ka egkeilingan te minsan hentew ne egparani keddi wey egpammineg te keddi ne lalag wey egtuman kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Egpekeiling sikandin te etew ne migbebaley ne migkekali te maralem wey batu se pabunsuran. Te migdakel e ka weyig, imbaggiyuwan ka baley rin piru ware seeye namenu tenged su maresen ka pegkeyimu. ");
INSERT INTO mbtNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piru ka etew ne migpammineg te keddi ne lalag ne ware migtuman kayi, egpekeiling te etew ne migbebaley ne ware meupiya ne pabunsuran. Te migdakel e ka weyig, imbaggiyuwan ka baley rin wey due-rue ne napeled wey natamtamanan nahuhus.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Te nakapenga si Hisus ne miglalag diye te me etew, miggendiyad sikandin te Kapirnaum. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dutu, due kepitan te me sundalu te Ruma ne migdaluwan te uripen din ne inggeyinawaan din, wey egkabigtawan e. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te pegkarineg te kepitan meyitenged ki Hisus, migsuhu sikandin te me igbuyag te me Hudiyu eyew eghangyu ki Hisus ne eggendiye te baley rin eyew egbawian ka uripen din. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne miggendiye sikandan te ki Hisus wey migpeyid-u-hid-u amana kandin ne migkahi, “Bulihi nu ubag seini ne etew ne likes ne egpangabangan. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Miggeyinawaan ki nikandin se me Hudiyu wey migpasasindeg pad man-e sikandin te simbaan ta.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sikan naa, migdume e si Hisus kandan. Te marani e sikandan te baley te kepitan, migsuhu ka kepitan te me alukuy rin te pegsinug-ung ki Hisus eyew te pegkahi kandin, “Magbebaye, kene kad e biyat-biyat su kena a ne likes ne egpepamaneyik keykew te baley ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sika ka egpuunan ne wara ad iya migbul-ug migdani keykew. Piru ilalag nu re ne egkeulian iya ka suluhuanen ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nakanengneng a kayi, uya su minsan degma sikeddi, due labew keddiey ne me upisyal wey due degma me sakup ku ne me sundalu. Ke egnangenan ku ka sabeka, ‘Hendiye ka,’ eggendiye iya sikandin. Ne emun ke egnangenan ku ka dangeb, ‘Hendini ka,’ eggendini iya sikandin. Ne emun ke egnangenan ku ka uripen ku, ‘Himuwa nu seini,’ eggimuwen din iya seeye.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te pegkarineg ni Hisus dutu, neinu-inu sikandin wey migbalikid sikandin wey migkahi diye te keet-etawan ne migsinundul kandin, “Ware e pad nakakita te iling kayi karakel ne pegpalintutuu te etew, minsan kayi te Israil!” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Te nakalibed e diye te baley ka insuhu te kepitan, nakita ran ne neulian e ka uripen din. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te ware naluhey, miggendiye si Hisus te siyudad te Nain; migduma kandin ka me hibateen din wey ka susuluhi ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te egpalinggumaan e sikandan te gumawan te siyudad, iyan degma peglihawang te me etew ne amana ne susuluhi ka eglebeng te minatey. Sabsabeka ne anak te balu ka migpatey. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te pegkakita ni Hisus te balu, neyimenawan sikandin dutu wey migkahiyan din ka balu, “Kene ka sinehew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne migdugpu si Hisus ne migsamsam te lungun wey migsanggel ka me etew ne migyeyayung kayi. Ne migkahi si Hisus, “Tatu, enew ka!” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ne mig-enew e ka minatey wey miglalag e. Ne imbehey e ni Hisus seeye diye te iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ne dutu, mig-umaan te liyas ka langun ne etew, wey insaye dan ka Manama. Migkahi sikandan, “Miggendiniyan ki te maresen ne prupita! Migtantanuran ded te Manama ka keet-etawan din!” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nekeempet te intiru ne Hudiya wey diye te me duma pad ne inged ka guhuren wey panugtulen meyitenged ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ne impanugtulan si Huwan te me hibateen din meyitenged te langun ne neyitabu. Puun due, mig-umew si Huwan te daruwa te me hibateen din ");
INSERT INTO mbtNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wey impeendiye din sikandan te Magbebaye eyew egpeinseen ke sikandin naan e iya ka egtetaharan dan wey ke egtetahad naan pad sikandan te lein. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te nekeume e sikandan diye te ki Hisus, migkahiyan dan e sikandin, “Impeendini key ni Huwan ne Talagbewutismu eyew te peg-inse keykew ke sikeykew naan e iya ka egtetaharan ney wey ke egtetahad key naan pad te lein?” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te seeye ne timpu, due masulug ne me etew ne impamawian ni Hisus te nalein-lein ne me dalu ran wey te masumpit ne egmanggeramen dan. Impangalew rin man-e ka me busew puun te migmanerepan wey masulug degma ka me butud ne impamawian din. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne intabak din ka me sinuhuan ni Huwan, “Libed kew diye te ki Huwan wey guhuri niyu sikandin ke nekey ka nakita niyu wey narineg niyu. Guhuri niyu sikandin te ka me butud egmakakite e, ka me pungku egmekeyipanew e, ka me ibungen neneulian e, ka me bengel egmakarineg e, wey ka me minatey neneuyag e, wey ka egkengaayu-ayu, napangguhuran e te Meupiya ne Panugtulen. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Keupianan te seeye se ware migduwa-ruwa meyitenged keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Te nekeyipanew e seeye se sinuhuan ni Huwan, miglalag si Hisus diye te masulug ne me etew meyitenged ki Huwan, “Te peggendiye niyu ki Huwan diye te inged ne ware mahinged, nekey-a ka in-iman-iman niyu ne egtengtengan? Etew naa ne egpekeiling te tibehew ne hendei re iya tapid egbanlaya te kalamag? ");
INSERT INTO mbtNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ke kene, nekey-a ka miggendiyaan niyu ne egtengtengan? Etew naa ne migsaluub te mahal ne kumbale? Sikandan se migsaluub te meupiya ne kumbale wey meupiya se peg-ugpe, mig-ugpe diye te me mateles ne ugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na, nekey naa iya ka in-iman-iman niyu ne egtengtengan te peggendiye niyu? Prupita naa? Uya, piru egnangenan ku sikaniyu te subla pad si Huwan te prupita, ");
INSERT INTO mbtNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","su sikandin ka nasulat te Kasulatan ne miggenendue, ‘Igpewun-a ku keykew ka suluhuanen ku ne iyan eg-andam te dalan ne egbayaan nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne migkahi pad man-e si Hisus, “Egnangenan ku sikaniyu te ware de due neetew kayi te ampew te tane ne subla pad ki Huwan, piru minsan hentew ne kene ne impurtanti diye te Migharian te Manama, subla pad iya ki Huwan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pegkarineg dutu te me etew, mig-uyun sikandan langun minsan ka me talagsukut te buhis ne eleg ka Manama, su migpabewutismu ma sikandan ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piru ware mig-uyun ka me Parisiyu wey ka me talagpanulu te Balaud te Manama te igkeupii te Manama kandan, wey ware sikandan migpabewutismu ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ne migpabulus si Hisus ka migkahi, “Nekey buwa ka egpeilingan ku te me etew te kuntee ne timpu, wey ke nekey ka egkeilingan dan? ");
INSERT INTO mbtNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Egpekeiling sikandan te me bate ne naminnuu diye te palingkiyan ne egpangumew te duma ran ne egkahi, ‘Migpamulendahan ney e sikaniyu piru ware kew migsesayew, mig-ulahingan ney e sikaniyu te peglungku piru ware kew migmaninehew!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Te peggendini ni Huwan ne Talagbewutismu, migpuasa sikandin wey ware mig-inum te binu, ne migkahi kew, ‘Migserepan sikandin te busew!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ne migginguma degma ka Anak te Etew ne migkeen wey mig-inum te binu, ne migkahi kew degma, ‘Pitawa niyu seini ne etew, bel-is wey taleinum, wey alukuy te me talagsukut te buhis wey te me makasesale.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piru ka kamalehetan meyitenged te kaalam te Manama, egkakita diye te mig-ikul kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Due sabeka ne Parisiyu ne migginggat ki Hisus ne eglagpu egkeen kandin. Sikan naa ka miggendiye si Hisus te baley rin eyew egkeen. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te seeye ne siyudad, due sabeka ne malitan ne makasesale iya. Te pegkarineg din ne migkeen si Hisus diye te baley te Parisiyu, miggendiye sikandin ne mig-uyan te mahal ne peemut ne diye itahu te alabastru. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ne migsasindeg sikandin diye te peka ni Hisus dapit te paa. Migsinehew sikandin wey nasubid te luwe din ka paa ni Hisus wey impunasan din seeye te bulbul rin wey inggarekan din. Ne in-itisan din e te peemut ka paa ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te pegkakita dutu te Parisiyu ne migginggat ki Hisus, migkahi sikandin diye te geyinawa rin, “Ke malehet ne prupita seini ne etew, egkanengnengan din perem ke nekey ne malitan seini se migsamsam kandin, su makasesale seini ne malitan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Piru migkahiyan sikandin ni Hisus, “Simun, due iglalag ku keykew.” Ne migtabak si Simun, “Nekey-a ka iglalag nu keddi, Talagpanulu?” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne migkahi si Hisus, “Due daruwa ne etew ne nekeutang diye te talagpasambey te seleppi. Ka sabeka nekeutang te lalimma ne gatus (500) ne dinaryu, wey ka sabeka lalimma ne pulu (50). ");
INSERT INTO mbtNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne puun su neelin ne kene sikandan egpakabayad, sikan naa ka imbalahad e ka me utang dan te migpasambey kandan. Ne kuntee, hentew naa te daruwa ka dakel se geyinawa diye te talagpasambey te seleppi?” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ne migtabak si Simun, “Te keddi ne suman-suman, seeye se dakel se utang ne warad e pabayara.” Ne migkahi si Hisus, “Eleg iya ka tabak nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ne miglilingey si Hisus diye te malitan wey migkahi ki Simun, “Nakita nu seini se malitan? Te pegseled ku kayi te baley nu, wara a nikeykew behayi te weyig eyew iglu-lu ku te paa ku. Piru inlu-luan din mule ka paa ku te luwe din wey impunasan din te bulbul din. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wara a hareki nikeykew te peg-alumama nu keddiey, piru ganna re mule sikandin ka miggarek te paa ku bunsud pad te pegginguma ku kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ware nu baluhuwi te lana ka ulu ku, piru imbaluhuwan din mule te peemut ka paa ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Purisu egnangenan ku sikeykew, impasaylu e kuntee ka dakel ne sale din su amana ne dakel ka geyinawa rin keddi. Piru ka etew ne impasaylu e ka deisek ne sale din, deisek de ka geyinawa rin keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne migkahiyan ni Hisus ka malitan, “Impasaylu e ka me sale nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ne seeye se me etew ne miglagpu kandin te migkeen, migkahi diye te geyinawa ran, “Hentew buwa seini ne etew ne egpasaylu te me sale?” ");
INSERT INTO mbtNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ne migkahiyan ni Hisus ka malitan, “Ka pegpalintutuu nu ka nakaluwas keykew. Uli ka ne meupiye e se geyinawa.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te ware naluhey, miggendiye si Hisus te me siyudad wey diye te me bariyu ne migwali te Meupiya ne Panugtulen meyitenged te Peghari te Manama. Migduma kandin ka sapulu wey daruwa (12) ne me hibateen, ");
INSERT INTO mbtNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","wey ka me malitan degma ne impamawian din ka egmanderalu wey migserepan te me busew. Duma kandan si Mariya ne migserepan dengan te pitu ne busew, ");
INSERT INTO mbtNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Huwana ne asawa ni Kusa ne upisyal ni Hari Hirudis, si Susana, wey masulug pad ka duma ran ne me malitan. Sikandan ka me malitan ne migbulig ki Hisus wey te me hibateen din pinaahi te me kasangkapan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Due masulug ne me etew puun te nalein-lein ne me lungsud ne miggendiye te ki Hisus. Te nalibulung e sikandan, impangguhuran sikandan ni Hisus te seini ne panunggilingan, ");
INSERT INTO mbtNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Due sabeka ne etew ne miggendiye te kamet eyew egpamula te beni din. Te pegpanawed din e te beni, due nakasawed diye te dalan. Nataman, nari-diekan e seeye te me etew wey impanuktuk e te me manuk-manuk. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ne ka duma ne beni diye nakasawed te batuwen. Te pegtubu e, nahangu e seeye su mammara ka tane ne napamulaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka duma ne beni diye nakasawed te duhiyen. Ne nanubu ka me duhi duma te beni wey naselung e ka pinamula. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka duma ne beni, diye nakasawed te meupiya ne tane. Intubu seeye wey migbebehas te mahatus (100) ne lupi.” Ne migkahi pad man-e si Hisus, “Purisu, ke egkeupian kew ne egpakasabut, sumsumana niyu ay-ayari ke nekey ka narineg niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ne mig-inse ka me hibateen ni Hisus ke nekey ka igpasabut te seini ne panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne migtabak si Hisus, “Impatahe e diye te kaniyu ka inggeles meyitenged te Peghari te Manama; piru diye te duma, impabaye seini pinaahi te me panunggilingan, eyew ke egtengteng sikandan, kene egpakakita, wey ke egpammineg sikandan, kene egpakasabut.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ne seini ka kaluwasan te panunggilingan: ka beni iyan sika ka lalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ka beni ne nakasawed diye te dalan, iyan seeye se me etew ne nakarineg te lalag te Manama. Piru migginguma ka ahalen te me busew wey in-ahew rin e ka lalag te Manama diye te me pusung dan eyew kene sikandan egpalintutuu wey kene egkaluwas. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka beni ne nakasawed diye te batuwen, iyan seeye se me etew ne nakarineg te lalag te Manama wey migdawat kayi ne nahale. Piru ware seini nakareralid diye te pusung dan, su migpalintutuu sikandan te dagdahew re, wey nataman, mig-engked e sikandan te timpu ne miggingumaan te me pegtintal. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka beni ne nakasawed diye te duhiyen, iyan seeye se me etew ne nakarineg te lalag te Manama, piru ka pegkalaggew ran, ka me karatuan wey me kahalaan kayi te ampew te tane, iyan nekeumes kandan. Sikan naa, ware neyinuhi ka me behas dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ka beni ne insawed diye te meupiya ne tane, iyan seeye se me etew ne nakarineg te lalag te Manama wey migdawat wey migtuman kayi. Intetahu dan seeye diye te malehet wey meupiya ne pusung dan, wey nataman, neyinuhan e ka me behas dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ware egpareket te sulu ne egsuuban te gantangan wey ke diye naa te selib te lantawan. Ke kene, igpatawan-tawan iya igtahu eyew egpakakita te malayag ka me etew ne egseled te baley. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ka langun ne inggeles, egkanengnengan; wey ka langun ne imbunbunan, egkalekisan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Sikan naa, tantanuri niyu ke nekey ka egkarineg niyu su seeye se due katuenan, egtimulan pad piru seeye se deisek de se katuenan, eg-angayen pad iya minsan ka deisek ne in-isip din e ne kandin perem.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nataman, miggendiye te ki Hisus ka iney rin wey ka me suled din. Piru ware sikandan nakaparani diye te kandin tenged su masulug ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne due mignangen ki Hisus, “Diye te lihawangan ka iney nu wey ka me suled nu wey egkeupian sikandan ne egpakigkita keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne migkahiyan ni Hisus sikandan, “Iyan iney wey me suled ku seeye se egpammineg te lalag te Manama wey egtuman kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sabeka ne aldew mig-untud si Hisus te balangey duma ka me hibateen din, ne migkahiyan din sikandan, “Eglapas ki diye te deyipag te lanew.” Seeye naa, miggipanew e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te ware pad sikandan nakatuhun diye te deyipag, nakalipereng si Hisus. Ware naluhey, due migginguma ne dakel ne kalamag ne nasul-uhan te weyig ka balangey ran wey hapit e egkapenu wey nakatahu sikandan te karereetan te seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ne migparani diye te ki Hisus ka me hibateen din wey impukew ran sikandin ne migkahi, “Ahalen! Ahalen! Egkalened kid e!” Ne dutu, mig-enew si Hisus ne insaparan din ka kalamag wey ka dakel ne me bunlud ne egpeeneng-eneng e. Seeye naa, migmalinawen e sikandan wey warad e kalamag. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ne migkahiyan din ka me hibateen din, “Hendei naan e ka pegpalintutuu niyu?” Piru neinu-inu sikandan wey naaldek ne migpanangnangeney, “Hentew buwa seini ne etew ne migpeengked din ka kalamag wey ka me bunlud, ne migpalintutuu ka kalamag wey bunlud te lalag din?” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Migpabulus sikandan diye te inged ne Girasa ne egkatalipag te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te nakatuhun e sikandan diye te deyipag, miglegsad e si Hisus te balangey. Ne due etew ne migserepan te busew ne migsinug-ung kandin ne diye migpuun te siyudad. Seini ne etew, naluhey e ne migpalawas wey warad mig-ugpe diye te baley su diyad te me sulung ne sabalanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Te pegkakita rin ki Hisus, migpanguleyi sikandin ne mig-usengul diye te tangkaan din wey migbalbalukan ne migkahi, “Hisus, Anak te Amana ne Mabantug ne Manama, kena a nikeykew banggawa! Egpeyid-u-hid-u a keykew ne kena a legpari!” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Inlalag din sika su insuhu ma ni Hisus ne egpalihawangen ka busew dutu te kandin. Kamasulug e sikandin umeyi te busew, wey minsan egbantayan sikandin ne imbaku te keddina ka belad wey ka paa rin, egpamugtusen din de seeye. Nataman, in-uyan e sikandin te busew diye te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ne mig-inse si Hisus kandin, “Hentew-a ka ngaran nu?” Ne migtabak sikandin, “Ka ngaran ku si Matangen,” su masulug ka me busew ne migserep diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne migpeyid-u-hid-u ka me busew diye te ki Hisus ne kene sikandan egpatinugpuen diye te bitu ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne diye te bayew madmariyu, due masulug ne me babuy ne migpanuwal diye te masandig. Ne migpeyid-u-hid-u diye te ki Hisus ka me busew ne egpaserepen diye te me babuy. Nataman, in-uyunan e sikandan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Seeye se me busew migligwang diye te etew wey nanerep e diye te me babuy. Ne namallahuy e ka me babuy patupang diye te dalama peendiye te lanew wey nallened e. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nakakita te neyitabu seeye se me etew ne talagtameng te babuy, ne namallahuy e sikandan diye te siyudad wey diye te me kamet ka migpangguhud. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nangendiye ka me etew eyew egleuy te neyitabu. Migparani sikandan ki Hisus wey nakita ran ne migpinnuu diye te marani ni Hisus ka etew ne inserepan te me busew. Migkukumbale e sikandin wey maheteng e ka suman-suman din. Ne dutu, nenaaldek e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sikandan se nakakita te neyitabu, migpanugtul ke immenu te pegbawi ka etew ne egbusawen. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nataman, ka langun ne etew ne nangugpe diye te me inged ne sakup te Girasa, mighangyu sikandan diye te ki Hisus ne eg-awe din dutu te inged dan su nenaaldek amana sikandan. Nataman, mig-untud si Hisus te balangey ne miglibed e. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Migpeyid-u-hid-u diye te ki Hisus ka etew ne migligwangan te busew ne egduma kandin. Piru migkahiyan din ka etew, ");
INSERT INTO mbtNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uli kad e diye te kaniyu wey ipangguhud nu ka innimu te Manama due te keykew.” Ne miggipanew e ka etew wey inlingut din seeye ne siyudad ne migpangguhud te me etew meyitenged te innimu ni Hisus diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nataman, nakalibed e si Hisus diye te deyipag te lanew, wey nahale ka me etew ne mig-elit-elit kandin su migtetahad sikandan langun kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne dutu, due migginguma ne etew ne egngaranan ki Hayru. Sabeka sikandin ne pangulu te simbaan te me Hudiyu. Migpanimbuel sikandin diye te tangkaan ni Hisus ne migpeyid-u-hid-u kandin ne eggendiye te baley rin ");
INSERT INTO mbtNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","su egkabigtawan e ka sabsabeka ne beyi-beyi ne anak din. Me sapulu wey daruwe (12) e ne leg-un ka beyi-beyi. Te miggipanew e si Hisus, due masulug ne me etew ne egmekegsegseg e diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ne due malitan ne eglangeseen seled e te sapulu wey daruwa (12) ne leg-un. Naamin de due ka langun ne diye te kandin te pegpabawi te dalu rin piru ware sikandin neulii. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nataman, migpatalisek sikandin te masulug ne me etew ka migparani diye te peka ni Hisus wey insamsam din ka sidsid te kumbale ni Hisus. Due-rue migtigpek e ka langesa. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ne mig-inse si Hisus, “Hentew-a ka migsamsam keddi?” Piru migware-ware ka langun ne etew. Ne dutu migkahi si Pidru, “Ahalen, amana ne masulug ka me etew ne nakaalingkus ne egmasegsehey e due te keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piru migkahi si Hisus, “Due migsamsam keddiey su naheram ku ne due miglihawang ne geem ligkat kayi te keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te nakita te malitan ne nanengnengan sikandin, migparani sikandin ne migkelkel diye te ki Hisus wey mig-usengul diye te tangkaan din. Ne impangguhud din diye te tangkaan te langun ne etew ke mania te migsamsam sikandin ki Hisus wey ke nekey ka paahi ne sahuhune sikandin ne neulian. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ne migkahiyan ni Hisus sikandin, “Beyi, ka pegpalintutuu nu ka nekeuli keykew. Uli ka ne meupiye e se geyinawa.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Te sasangan pad ne eglalag si Hisus, due etew ne migginguma ne diye egpuun te baley ni Hayru ne migkahi, “Migpatey e ka anak nu. Kene nud e banggawa ka talagpanulu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Piru te pegkarineg dutu ni Hisus migkahiyan din si Hayru, “Kene ka egkalaggew. Palintutuu ke re eyew egkeulian ka anak nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Te pegginguma ni Hisus diye te baley, ware intuhutan din ne egduma kandin te egseled angin e engki Pidru, Huwan, Santiyagu wey ka iney wey amey te bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Naninehew wey migmalumbibigtew ka langun ne etew tenged te bate ne migpatey. Piru migkahi si Hisus, “Kene kew egmandalawit. Ware migpatey ka beyi-beyi su nakalipereng de sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Piru migdali-dian de te me etew si Hisus su nakanengneng sikandan te napatey e ka bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ne migseled si Hisus wey miggen-genan din ka belad te bate te migkahi, “Beyi-beyi, enew ka!” ");
INSERT INTO mbtNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Due-rue ne miglibed ka gimukud te bate wey mig-enew e sikandin. Ne migsuhu si Hisus ne egpakeenen ka bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Amana ne neinu-inu ka iney wey amey te bate piru inteesan sikandan ni Hisus te kene igpangguhud te minsan hentew ka neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Due timpu ne in-umew ni Hisus ka sapulu wey daruwa (12) ne hibateen din wey impamehayan din te geem wey katenged te pegpangalew te langun ne me busew wey pegpamawi te egpanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne impeyipanew rin sikandan eyew te pegpangguhud meyitenged te Peghari te Manama wey egpamawi te egpanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne migkahiyan din sikandan, “Kene kew uyan te minsan nekey te peggipanew niyu: kene kew uyan te tuked, kabil, keenen, seleppi, wey eg-ilisan niyu ne kumbale. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Minsan nekey ne baley ne egpamaneyikan niyu, diye kew re iya ugpe taman te eg-awe kew e man-e dutu ne inged; ");
INSERT INTO mbtNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne minsan nekey ne baley ne kene egdawat kaniyu, engkeri niyu sika ne inged wey pelpela niyu ka alinepung diye te paa niyu isip palinneu ne ware sikandan ikahale te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nataman, nangipanew e ka me hibateen ni Hisus wey nangendiye te lein-lein ne me inged ka migpangguhud te Meupiya ne Panugtulen wey migpamawi te nanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Si Hari Hirudis ne iyan migmandu te Galiliya, nakarineg meyitenged te langun ne neyitabu. Ne nalibeg amana sikandin su due me etew ne migkahi ne neuyag kun si Huwan ne Talagbewutismu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Migkahi man-e ka duma ne me etew ne miglibed kun si Ilyas. Ne migkahi pad man-e ka duma ne due sabeka ne prupita dengan ne neuyag kun kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne migkahi si Hirudis, “Impatempuhan kud e te ulu si Huwan. Hentew naa seini ne etew ne masulug se guhuren meyitenged kandin ne egkarineg ku?” Ne dakel ka peg-iman-iman ni Hirudis ne egpakakita ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nataman, nanlibed e ka me hibateen ni Hisus wey impangguhuran dan sikandin te langun ne neyimu ran. Ne induma rin e sikandan wey miggendiye te sabeka ne lungsud ne egngaranan te Bitsayda. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te pegkanengneng dutu te masulug ne me etew, migsinundul e sikandan engki Hisus. Ne insagsahipe ni Hisus ka me etew wey impanugtulan din meyitenged te Peghari te Manama wey impamawian din ka egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ne hengkayi te eglineb e ka aldew, migparani ki Hisus ka sapulu wey daruwa (12) ne hibateen din ne migkahi, “Peendiyaa nu ka me etew te marani ne me bariyu wey me kamet eyew egpakapammitew sikandan te egkakeen wey egkeyirehaan dan su kayi ki pe ma te inged ne ware mahinged.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piru migkahiyan din sikandan, “Sikaniyu ka egbehey kandan te egkakeen.” Ne migtabak sikandan, “Lalimma re ne paan wey daruwa ne ngalap te weyig ka kayi te kanta. Nekegmenu naan de iya sika, angin e ke eggipanew key pad wey egbebeli te igpakeen kandan langun.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Me lalimma ne libu (5,000) ka kasuluhan te me lukes dutu.) Ne migkahiyan ni Hisus ka me hibateen din, “Papinnuuwa niyu ka me etew wey palibulunga niyu te tiglalimma ne pulu (50) tagse punduk.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Intuman seeye te me hibateen ne impapinnuu ran e ka langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne ingkuwa ni Hisus ka lalimma ne malisen ne paan wey ka daruwa ne malisen ne ngalap te weyig, ne migleng-ag sikandin diye te langit ne migpasalamat te Manama. Nataman, impanepik-tepik din e ka paan wey impamehey rin e diye te me hibateen din eyew igpepamehey diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ne nangeen sikandan langun wey nenabulung-bulung, wey nakalimud pad sikandan te sapulu wey daruwa (12) ne liyang ne napenu te same dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Due timpu ne mig-ampu si Hisus ne migsabsabeka, ne ka me hibateen din diye ded te marani. Ne mig-insaan din sikandan, “Hentew e kun naa sumale te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne migtabak sikandan, “Migkahi ka duma ne sikeykew kun si Huwan ne Talagbewutismu. Ka duma degma migkahi ne sikeykew kun si Ilyas, wey ka duma migkahi ne sabeka ke kun te me prupita dengan ne neuyag ded.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ne mig-inse si Hisus kandan, “Piru ke sikaniyu ka egpalalahen, hentew e naa iya?” Ne migtabak si Pidru, “Sikeykew iya ka Kristu ne insaad te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Piru migteesan sikandan ni Hisus wey impanpanayan ne kene igpepanugtul seini te minsan hentew. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne mig-abey sikandin ne migkahi, “Ka Anak te Etew keilangan ne amana eg-antus te masumpit ne igpeula-ula kandin wey egsamsamilian te me igbuyag te me Hudiyu wey me pangulu te me talagpanubad wey me talagpanulu te Balaud te Manama. Eggimatayan sikandin wey egkeuyag te igkatelu ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne migkahiyan din ka langun ne etew, “Ke hentew seeye se egkeupian ne eg-ikul keddiey, keilangan ne eg-engked te kandin ne igkeupii wey egtiang te kandin ne krus te tagse aldew wey eg-ikul keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Su seeye se egkeupian ne egluwas te kandin ne umul, nasi egkawaraan kayi, piru seeye se egkawaraan te kandin ne umul tenged keddiey, egpakarawat te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nekey naa ka egkakuwa te etew ke egkaangken din ka langun ne tahu kayi te ampew te tane piru egkaware ka umul din? Ware iya! ");
INSERT INTO mbtNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Su emun ke igkeyilew a duma te lalag ku te minsan hentew, igkeyilew ku degma sikandin te timpu ne eggingume e ka Anak te Etew duma te katelesan din wey te Amey wey te matulus ne me panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Egnangenan ku sikaniyu te malehet: due me etew ne kayi kuntee ne kene pad egpatey taman te kene dan pad egkakita ka Peghari te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Me walu e ne aldew ka miglihad puun te peglalag ni Hisus te seeye, induma rin si Pidru, si Huwan wey si Santiyagu wey migtakereg diye te bubungan eyew eg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te mig-ampu e si Hisus, nabalbalawan ka ulaula rin wey miglayag te kaangkag ka kumbale din. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne sahuhune ne due daruwa ne etew ne migpakiglalag kandin. Sikandan ensi Muwisis wey Ilyas, ");
INSERT INTO mbtNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ka migpakita ne miglayag te katelesan, wey migpakiglalag sikandan ki Hisus meyitenged te kamatayen din diye te Hirusalim ne mahaan e egkatuman. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nakaliplipereng si Pidru wey ka me duma rin te seeye ne timpu. Te napukew e sikandan, nakita ran ka layag ni Hisus wey te daruwa ne etew ne migdangdang kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Te eg-awe e seeye se daruwa ne etew diye te tangkaan ni Hisus, migkahiyan sikandin ni Pidru, “Ahalen, meupiya te kayi key kuntee. Eggimu key te tatelu ne leeb: sabeka ka keykew, sabeka ki Muwisis, wey sabeka ki Ilyas.” (Nakahi rin sika su ware sikandin nakanengneng ke nekey ka iglalag din.) ");
INSERT INTO mbtNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te miglalag pad si Pidru, due gapun ne migdalung kandan ne nenaaldek ka me hibateen su nabunbunan e sikandan te gapun. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne natagtaheed, due laheng ne egpuun due te gapun ne migkahi, “Iyan seini ka Anak ku ne in-alam ku. Pamineha niyu sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te warad e laheng diye te gapun, si Hisus naan de ka nasame. Pegkapenga dutu, migpeeneng-eneng de ka me hibateen din wey ware sabeka kandan ne migpanugtul te minsan hentew meyitenged te nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te seup ne aldew, nanupang e sikandan puun te bubungan. Ne due susuluhi ne me etew ne migsinug-ung ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne due sabeka ne etew dutu ne migbalbalukan ne migkahi, “Talagpanulu! Pitawa nu pa ubag seini se lukes ne anak ku su sabsabeka pe man de iya. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eg-umaan sikandin te busew ne sahuhune ne egpanguleyi sikandin wey egkelkelen ne egkataman egbubuke e ka be-be din. Amana sikandin egbaybayari wey kenad iya egpeuwey-uwayen te masakit! ");
INSERT INTO mbtNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inhangyu ku ka me hibateen nu te peg-alew te busew piru ware dan naalew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Migkahi si Hisus, “Sikaniyu se me etew te kuntee ne timpu, ware pegpalintutuu niyu wey seyyup ka suman-suman niyu! Hendei bes taman ka pegduma-ruma ku kaniyu? Hendei bes taman ka peg-antus ku kaniyu? Uyana niyu ka bate kayi te keddi!” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te pegparani te bate diye te ki Hisus, impabahed sikandin te busew diye te tane wey egbabuyen e sikandin. Piru in-alew ni Hisus ka busew ne imbawian din ka bate. Ne inlibed din e ka bate diye te amey rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ne nawangalan ka me etew te amana ne maresen ka Manama. Te neinu-inu pad ka me etew te langun ne innimu ni Hisus, migkahiyan din ka me hibateen din, ");
INSERT INTO mbtNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tantanuri niyu seini se iglalag ku kaniyu: mahaan e igbehey ka Anak te Etew diye te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piru ware sikandan nakasabut te kaluwasan kayi. Inneles seini kandan eyew kene dan egpakasabut, wey nenaaldek sikandan ne eg-inse kandin meyitenged kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Te seeye ne timpu, migpaap-apuley ka me hibateen ke hentew ka labew kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Piru nakanengneng si Hisus te me suman-suman dan. Sikan naa, migkuwa sikandin te bate wey impasasindeg din diye te andang din. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne migkahiyan din sikandan, “Ka minsan hentew ne egdawat te seini ne bate tenged su mig-ikul rin keddi, egdawat keddiey. Ne ka minsan hentew ne egdawat keddiey, egdawat degma te migpeuyan keddiey. Su ka kene ne impurtanti kaniyu langun, iyan sikandin labew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Migkahiyan sikandin ni Huwan, “Ahalen, nakakita key te etew ne migpangalew te me busew pinaahi te ngaran nu wey insaparan ney sikandin tenged su kene ta ne duma sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Piru migkahi si Hisus, “Kene niyu sapari sikandin su ka kene egpakig-ehet kaniyu egpalapig kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te marani e ka aldew ne egbatunen e si Hisus diye te langit, nasabeka ka suman-suman din ne eggendiye din te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Purisu due impewun-a rin ne me etew diye te sabeka ne bariyu te Samarya eyew te peg-andam te egtuenan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piru ware sikandin dawata te me etew te seeye ne inged su diye nahud sikandin egpatangke te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Te pegkanengneng dutu te me hibateen din ne ensi Santiyagu wey Huwan, migkahiyan dan sikandin, “Magbebaye, egkeupian ke naa ne egbuyu key te hapuy puun te langit eyew egkasilaban sikandan?” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piru miglilingey si Hisus wey migsaparan din sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne migpabulus sikandan ne miggipanew diye te lein ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te sasangan pad sikandan ne eggipanew, due sabeka ne etew ne migkahi diye te ki Hisus, “Eg-ikul a keykew minsan hendei ka eggendiye.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ne migtabak si Hisus kandin, “Due eggelesan te me laku wey due salag te me manuk-manuk te aw-awangan, piru ka Anak te Etew ware mule egkeyimmelayan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne migkahiyan din ka lein ne etew, “Ikul ka keddi.” Piru migkahi seeye se etew, “Ahalen, eg-uli e pad su eglebeng e pad te amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Piru intabak sikandin ni Hisus, “Balahad e ka me minatey ne eglebeng te kandan ne minatey. Piru sikeykew mule, hipanew ka wey ipangguhud nu ka meyitenged te Peghari te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Duen pad man-e migkahi diye te ki Hisus, “Ahalen, eg-ikul a keykew, piru tuhuti e pa ne eg-uli su egpana-tahe e pad te pamilya ku.” ");
INSERT INTO mbtNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Piru migtabak si Hisus kandin, “Minsan hentew ne egdaru ne layun eglililingey, kene ne likes ne egkasakup te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te pegkapenga dutu, mig-alam ka Magbebaye te pitu ne pulu wey daruwa (72) pad ne me hibateen din. Impeendiye din sikandan ne naatag diye te me lungsud wey me inged ne eggendiyaan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne migkahiyan din sikandan, “Dakel ka eggaaniyen, piru deisek de ka talaggaani. Purisu ampu kew diye te Kamuney te eggaaniyen ne egpeuyan sikandin te me talaggaani diye te eggaaniyen. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hipanew kew! Igpeendiye ku sikaniyu ne egpekeiling te me nati te karniru diye te me etew ne egpekeiling te mabbulut ne me singgalung. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kene kew uyan te kemuyut, kabil, wey sandal; kene kew sanggel eyew eg-elit-elit te minsan hentew diye te dalan. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Minsan nekey ne baley ne eglasuran niyu, seini ihun-a niyu te egkahi, ‘Ka keupianan egkaangken niyu.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne ke due mig-ugpe dutu ne likes ne egpakaangken te keupianan, egkaangken dan iya sika; piru ke kene dan ne likes, kene iya degma sikandan egpakaangken te keupianan. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Diye kew re iya ugpe te baley ne egpamaneyikan niyu wey kene kew eggalin-halin. Keen kew wey inum kew te igsendad dan kaniyu, su seeye se egtrabahu, eleg iya ne egbayaran. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ke eggendiye kew te lein ne lungsud wey egdawaten kew nikandan, keen kew te igsendad dan kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bawii niyu ka egmanderalu te sika ne lungsud wey kahii niyu sikandan, ‘Mahaan e egginguma kayi te kaniyu ka Peghari te Manama.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piru ke egginguma kew diye te sabeka ne lungsud wey ke kene kew nikandan egdawaten, hendiye kew te me dalan wey kahii niyu ka me etew, ");
INSERT INTO mbtNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Minsan ka me alinepung te lungsud niyu ne migdekket kayi te paa ney, egpelpelen ney isip palinneu ne ware kew ikahale te Manama. Piru tantanuri niyu ne mahaan e egginguma ka Peghari te Manama.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Egnangenan ku sikaniyu, te Aldew te Peggukum, maagkap pad ka iglegpad te Manama te matig-Suduma du te mahinged te sika ne lungsud.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Migkahi sikandin, “Mekeyid-u-hid-u kew ka me matig-Kurasin! Mekeyid-u-hid-u kew ka me matig-Bitsayda, su emun ke diye pa perem te Tiru wey te Sidun himuwa ka me kein-inuwan ne innimu diye te kaniyu, naluhey ran de perem inniyuhi ka me sale dan ne migsaluub te saku wey migbubukbuk te abu diye te ulu ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Te Aldew te Peggukum, maagkap pad ka iglegpad te Manama te matig-Tiru wey matig-Sidun du te iglegpad kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne sikaniyu se matig-Kapirnaum, kahiyen niyu buwa ne egpakaparibabew kew taman diye te langit? Kene, nasi kew igdegpak diye te inged te me gimukud ne egngaranan te Hadis!” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne migkahiyan din ka me hibateen din, “Ka minsan hentew ne egpammineg kaniyu, egpammineg degma keddiey. Ne ka minsan hentew ne eg-angge-angge kaniyu, eg-angge-angge degma keddiey wey ka eg-angge-angge keddiey, eg-angge-angge degma te migpeuyan keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nataman, nakalibed e ka pitu ne pulu wey daruwa (72) ne me hibateen ne nahale-gale wey migkahi diye te ki Hisus, “Magbebaye, minsan ka me busew migparuma-ruma kanami pinaahi te peggamit ney te keykew ne ngaran!” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne migtabak si Hisus kandan, “Nakita ku si Meibulan ne neulug puun diye te langit iling te kilat. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pammineg kew! Imbehayan ku sikaniyu te geem eyew egkaayun kew ne egdiek te me uled wey me salipitsipit wey te langun ne geem te kuntere niyu. Ne kene kew egkamenu. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piru kene kew egkahale tenged te migparuma-ruma ka me busew kaniyu, ke kene, iyan niyu ikahale su nakalista ka me ngaran niyu diye te langit.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te seeye ne timpu, imbehayan si Hisus te kahalaan te Panisingan te Manama ne migkahi si Hisus, “Ame, Manama te langit wey tane. Egpasalamatan ku sikeykew, su inneles nu seini puun te matagseb wey te utekan ne me etew wey impakita nu seini diye te me etew ne ware katuenan. Uya, Ame, natuman seini su iyan ma igkeupii nu. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Imbehey te Amey ku ka langun kayi te keddiey. Ne ware nekeila te Anak gawas te Amey, wey ware nekeila te Amey gawas te Anak wey seeye se igkeupii rin ne igpeila diye te Amey rin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne migtangke si Hisus diye te me hibateen wey migkahiyan din sikandan tugtuhesi, “Keupianan niyu te nakakita te nakita niyu! ");
INSERT INTO mbtNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Su egnangenan ku sikaniyu te masulug ka me prupita wey me Hari ne egkeupian ne egpakakita te nakita niyu, piru ware sikandan nakakita. Egkeupian sikandan ne egdineg te narineg niyu, piru ware sikandan nakarineg.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ne dutu, due sabeka ne talagpanulu te Balaud te Manama ne migsasindeg ne mig-eleg-eleg ki Hisus pinaahi te peg-inse, “Talagpanulu, nekey naa ka eggimuwen ku eyew egkaangken ku ka umul ne ware egtamanan?” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ne migtabak si Hisus kandin, “Nekey ma ka insulat diye te Balaud te Manama? Immenu nu ma seini te egsabut?” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne migtabak ka talagpanulu te Balaud te Manama, “Geyinawei nu ka Magbebaye ne Manama nu ne egpuun te pusung nu wey egpuun te gimukud nu wey egpuun te keseg nu wey egpuun te suman-suman nu. Ne geyinawei nu degma ka duma nu iling te peggeyinawa nu te pegkeetew nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ne migtabak si Hisus, “Eleg ka tabak nu. Himuwa nu sika eyew egkarawat nu ka umul ne ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piru egkeupian sikandin ne eg-ileen ne eleg ka kandin, sikan naa ka mig-inse man-e sikandin ki Hisus, “Hentew naa ka duma ku?” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne migtabak si Hisus, “Due sabeka ne etew ne migtupang te Hirusalim peendiye te Hiriku. Inggepasan sikandin te me tulisan diye te deralanen wey in-ahawan te inuyanan din, wey lagkes ka insaluub din. Inggumian dan sikandin wey in-engkeran ne hapit e egpatey. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na, due degma talagpanubad ne nakasalengan ne migtupang dutu. Te pegkakita rin te etew, mig-alihu sikandin te dalan wey miglihad de. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Natagtaheed duen e man-e miglihad dutu ne talagbulig te talagpanubad ne egngaranan te Libita. Pegkakita rin te etew, mig-alihu sikandin te dalan wey miglihad de. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nataman, due sabeka ne etew ne matig-Samarya ne eglihad te seeye ne dalan. Pegkakita rin te etew, neyid-u amana sikandin ");
INSERT INTO mbtNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","wey indugpu din ka etew wey imbawian din. Mig-itisan din te lana wey binu ka pali wey migbagkesan din e. Nataman, impeuntud din ka etew te unturanan din ne ayam wey indulung din diye te baley ne eg-ad-aranan. Ne intanggu rin sikandin diye. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te seup ne aldew, imbehayan din te daruwa ne dinaryu ne seleppi ka kamuney te baley wey migkahiyan, ‘Tangguwa nu sikandin. Ne emun ke egpakatimul ke pad egpakahastu, egbayaran ku re sikeykew te peglibed ku kayi.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne mig-inse si Hisus ne migkahi, “Na, te keykew ne suman-suman, hentew dutu te tatelu ka miggeyinawa te seeye se inggepasan te me tulisan?” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne migtabak ka talagpanulu te Balaud te Manama, “Seeye se etew ne neyid-u kandin.” Ne migkahi si Hisus, “Hipanew ka wey himuwa nu ka iling te innimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Te migpabulus si Hisus ne miggipanew duma ka me hibateen din, migginguma sikandan diye te sabeka ne bariyu. Ne due sabeka ne malitan ne egngaranan ki Marta ne mig-elit-elit kandin diye te baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Due suled din ne egngaranan ki Mariya ne migpinnuu diye te egkasikuwayan te Magbebaye ne si Hisus ka egpammineg te impanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piru si Marta, egkatabikes e mule ka eg-andam te igsendad din engki Hisus. Sikan naa ka migparani sikandin ki Hisus wey migkahi, “Magbebaye, mania te ware nu sagmana ka suled ku ne migbalahad keddi ne egkatabikes te peg-andam te egkakeen? Kema, banasali nu sikandin ne egbulig keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne migtabak ka Magbebaye kandin, “He Marta! Masulug amana igkalanu nu wey igkalaggew nu Marta. ");
INSERT INTO mbtNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ne sabeka re perem ka egkeilanganen, wey seini iya ka in-alam ni Mariya. Meupiya seini wey kene egkaangey diye te kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te seeye ne timpu, mig-ampu si Hisus diye te sabeka ne inged. Te pegkapenga rin te peg-ampu, due migkahi ne sabeka ne hibateen din, “Magbebaye, panulua key nikeykew te peg-ampu, iling ki Huwan te migpanulu te kandin ne me hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ne migtabak si Hisus kandan, “Henduena niyu kayi te eg-ampu: ‘Amey: Egdayanen ka matulus ne ngaran nu; Eghari ka kayi te kanami. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ibehey nu kanami ka egkeilanganen ney te tagse aldew ne egkeenen ");
INSERT INTO mbtNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","wey pasayluwa key te me sale ney, su egpasaylu key degma te nakasale kanami. Ne kene key ipabaye nikeykew diye te pegtintal.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne migkahiyan ni Hisus ka me hibateen din, “Panunggiling ke due alukuy nu, wey eggendiye ka te baley rin te egliware te marusilem wey egkahi kandin, ‘Suled, pasambaye e pa te tatelu ne timman ne paan, ");
INSERT INTO mbtNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","su due alukuy ku ne sikan pad iya migginguma wey ware igpakapakeen ku kandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne egtabak sikandin diye te seled, ‘Kene ad nikeykew banggawa su inlekeban kud e ka gumawan wey nangibat key e se taltalaanak. Sikan naa ka kene ad egpekeenew eyew egbehayan ka te egkakeen.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, egnangenan ku sikaniyu, minsan kene sikandin eg-enew wey egbehey keykew te egkakeen minsan alukuy kew, piru eg-enew sikandin wey egbehey keykew te ingkeilangan nu puun su kene ka egkeyilew ne eglasi-lasi ne egbuyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Purisu egnangenan ku sikaniyu te buyu kew ne egbehayan kew; pammitew kew ne egpakakita kew; panektek kew ne eglukatan kew. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Su seeye se egbuyu, egbehayan; wey seeye se egpammitew, egpakakita; wey seeye se egpanektek, eglukatan. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikaniyu se me amey, ke egbuyu ka anak niyu te ngalap, nasi niyu naa sikandin egbehayan te uled? ");
INSERT INTO mbtNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ne ke egbuyu sikandin te atelug, egbehayan niyu naa sikandin te salipitsipit? Kene iya! ");
INSERT INTO mbtNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ne sikaniyu, minsan makasesale kew, egkateu kew red ne egbehey te meupiya diye te me anak niyu. Ne ka Amey niyu ne diye te langit, subla pad ne egbehey te Panisingan din diye te egbuyu kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ne due timpu ne mig-alew si Hisus te busew ne ummew ne migserep te etew. Te nakalihawang e ka busew, nakalalag e ka etew wey neinu-inu ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piru due me etew ne migkahi, “Si Meibulan ne pangulu te me busew ka migbehey kandin te geem te pegpangalew te me busew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka duma migbuyu sikandan ki Hisus ne egpapitawen te kein-inuwan ne egpuun te langit eyew te peg-eleg-eleg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piru natahaan ni Hisus ka me suman-suman dan, purisu migkahiyan din sikandan, “Ka sabeka ne inged ne egmeun-unayey egmeeg-ehetey ka me etew, egkahuhus iya ka sika ne inged. Ne ka taltalaanak ne egmeeg-ehetey, egmekegsuwey. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ne emun ke eg-unayen ded ni Meibulan te eg-ehet ka me sakup din, egmenuwen dan naan e te egpasasindeg ka inged dan? Su migkahi kew ne migpangalew a te me busew tenged su imbehayan a ni Meibulan te geem. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne emun ke iyan ku pa inggamit ka geem ni Meibulan te pegpangalew te me busew, hentew naa ka migbehey te geem te me hibateen niyu ne egpangalew degma te me busew? Purisu ka me hibateen niyu ka mismu ne migpamalehet ne seyyup kew iya. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na, puun su migpangalew ku ka me busew pinaahi te geem te Manama, migpeila seini ne miggingume e diye te kaniyu ka Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ke due sabeka ne etew ne manekal, ne kumplitu te panganiban te pegbantey te baley rin, kene egkeubalan ka me kasangkapan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piru ke eglusuran sikandin te manmanekal pad kandin ne etew, egkatalu iya sikandin. Egpanguen e ka insalsalihan din ne me panganiban, wey egba-baaren e ka me kasangkapan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ka kene egpalapig keddiey, egkuntere keddiey; ka kene egbulig keddiey te pegpalibulung, egpegsuwey naa.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne migpabulus si Hisus ka miglalag, “Ne emun ke eglihawang e diye te etew ka busew, egleug-leug sikandin diye te mammara ne me inged eyew egpammitew te egkeyimelayan din. Ke kene sikandin egpakakita, egkahi sikandin, ‘Eglibed e red diye te tapey ne inserepan ku.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Seeye naa, ke eglibed din wey ke egkakita rin ne malinis e ka geyinawa te etew wey meupiye e ka pegkapanines dutu, ");
INSERT INTO mbtNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","egligwang sikandin ne eg-uyan te pitu pad man-e ne me busew ne subla pad ne maddeet kandin, ne egseled sikandan wey eg-ugpe dutu. Te katammanan, egkanasnasian pad egmareet ka seeye ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te nakapenge e si Hisus ka miglalag, due sabeka ne malitan diye te taliware te me etew ne migpanguleyi diye te kandin ne migkahi, “Keupianan te seeye se malitan ne mig-anak wey migpasusu keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Piru migtabak si Hisus, “Keupianan te seeye se egpammineg te lalag te Manama wey egtuman kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te egkatimtimulan e ka kasulug te me etew ne nakaalingkus ki Hisus, migkahi sikandin, “Amana ne mareet ka me etew te kuntee ne timpu! Migbuyu sikandan te kein-inuwan piru ware igpakita kandan gawas te kein-inuwan ne neyitabu ki Hunas. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iling ki Hunas ne neyimu ne palinneu te me etew diye te Ninibi, ka Anak te Etew degma, iyan egkeyimu ne palinneu te me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te Aldew te Peggukum, egsasindeg ka Rayna te Igkakawanan ne Balabahan dapit te Igsile duma te me etew te kuntee ne timpu wey egsenditan din sikandan su amana ne mariyu ka impuunan din te miggipanew eyew te pegpammineg te maralem ne katuenan ni Hari Sulumun. Ne kuntee, kayid e ka labew pad ki Sulumun. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te Aldew te Peggukum, egpangenew degma ka me matig-Ninibi duma te me etew te kuntee ne timpu wey egsenditan dan sikandan. Su mig-inniyug sikandan te me sale dan te pegkarineg dan te wali ni Hunas. Ne kuntee, kayid e ka labew pad ki Hunas.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne migpabulus pad si Hisus ka migkahi, “Ware egpareket te sulu ne iggeles wey egsuuban naa te gantangan, ke kene, igpatawan-tawan din iya igtahu eyew egkalayahan seeye se egseled te baley. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ka mata nu, sulu te lawa nu. Ke malayag ka pegtengteng nu, malayag degma ka intiru ne lawa nu; piru ke marusilem ka pegtengteng nu, marusilem degma ka intiru ne lawa nu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Purisu ayad-ayad ka su kema ke ka layag ne egkahiyen nu ne due te keykew, marusilem bes. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ke napenu te layag ka intiru ne lawa nu wey ke ware baad te lawa nu ne marusilem, eglayag iya ka intiru ne lawa nu iling te sulu ne nakateng-ew due te keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Te nakapenge e si Hisus ne miglalag, due sabeka ne Parisiyu ne migginggat kandin te egkeen. Seeye naa, migdume e si Hisus wey miglagpu migkeen duma kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Neinu-inu ka Parisiyu te nakakita ki Hisus ne migkeen ne ware migpanlu-lu te belad din. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Puun due, migkahi ka Magbebaye diye te kandin, “Sikaniyu se me Parisiyu, miglinisan niyu ka lawa te pakawan wey pinggan, piru malindit ka diye te seled. Iling kew naa degma rue su napenu te halamlam wey te langun ne mareet ka diralem niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sikaniyu se egkengeungel! Innimu te Manama ka dapit te ligwang wey iling ded man-e ka dapit te seled. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Purisu ibehey niyu te egkengaayu-ayu ka tahu te me pakawan wey me pinggan niyu, wey egmalinis ka langun diye te kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mekeyid-u-hid-u kew kangkuwa me Parisiyu! Migbehey kew diye te Manama te igkasapulu ne baad te me leggu niyu iling te hirbabuwina wey kaningag wey me duma pad ne me leggu, piru imbalahad niyu ka katareng wey peggeyinawa te Manama. Keilangan ne egbehey kew te igkasapulu ne baad, piru kene niyu balahara ka duma ne panulu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mekeyid-u-hid-u kew me Parisiyu! Su eg-alam kew te me mateles ne pinnuuwan diye te me simbaan te me Hudiyu, wey egkeupian kew ne egtahuren te me etew diye te me palingkiyan. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mekeyid-u-hid-u kew! Iling kew te me lebeng ne ware tuus ne ware de nanengnengi te me etew ne nariekan dan bes e.” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ne due sabeka ne talagpanulu te Balaud te Manama ne migkahi kandin, “Talagpanulu, te peglalag nu te iling due, impeyilawan key degma nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne migtabak si Hisus, “Mekeyid-u-hid-u kew degma se me talagpanulu te Balaud te Manama! Impatiang niyu ka me etew te me dinulan ne bebehati ne egtiangen, piru sikaniyu mismu kenad iya egbulig minsan deisek de te pegtiang kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mekeyid-u-hid-u kew iya! Migpangimu kew te lebenganan te me prupita ne impangimatayan te me kaapuan niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sikan naa, sikaniyu mismu ka migpamalehet wey mig-uyun te innimu te kaapuan niyu, su sikandan ka miggimatey te me prupita wey sikaniyu ka miggimu te sabalanan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tenged kayi, migkahi ka matagseb ne Manama, ‘Egpeuyanan ku sikandan te me prupita wey me suluhuanen; wey eggimatayan dan ka duma wey ka duma egbaybayaran dan.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Purisu, eglegparan ka me etew te kuntee ne timpu tenged te peggimatey ran te langun ne me prupita puun pad dengan te peggimu te kalibutan, ");
INSERT INTO mbtNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","puun te peggimatey ki Abil peendiye te ki Sakariyas ne innimatayan diye te elat-elat te altar wey te timplu. Uya, egnangenan ku sikaniyu, eglegparan ka me etew te kuntee ne timpu meyitenged te langun ne me prupita ne impangimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mekeyid-u-hid-u kew ka me talagpanulu te Balaud te Manama! Inggeles niyu ka yabi ne iyan perem egpakalukat te gumawan te baley te katuenan; piru sikaniyu mismu, kene kew egseled wey imbalabahan niyu seeye se egseled!” ");
INSERT INTO mbtNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Te peg-awe ni Hisus diye, amana sikandin dew-aya te me talagpanulu te Balaud te Manama wey te me Parisiyu. Ne miglaslasiyan dan sikandin te eg-inse te masulug ne me inse, ");
INSERT INTO mbtNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","su eggeraman dan sikandin te egsahilut pinaahi te peglalag din eyew egkarakep dan sikandin ke egkaseyyup din. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Te seeye ne timpu, due me etew ne miglibulung diye te ki Hisus wey egmemekegdi-diekey e sikandan su amana ran ne susuluhi. Ne migkahiyan hun-eyi ni Hisus ka me hibateen din, “Bantey kew ne kene egkaalinan te igpatulin te paan te me Parisiyu ne iyan ka pegpapitew-pitew. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Su ke nekey ka imbunbunan, egkalekisan, wey ka langun ne inneles, egkanengnengan. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Purisu minsan nekey ne ingguhud niyu diye te marusilem, igkahuhud diye te malayag. Ne minsan nekey ne innaas-naas niyu diye te inlekeban ne sinabeng, igkawangal-wangal diye te langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ne migpabulus si Hisus ne migpanulu, “Egnangenan ku sikaniyu me alukuy ku, kene kew kaaldek te seeye se egpekeyimatey te lawa niyu wey te pegkeimpus due warad e lein ne egkeyimu ran kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Piru egnangenan ku sikaniyu ke hentew ka eleg ne igkaaldek. Iyan niyu ikaaldek ka Manama ne egpekeyimatey te lawa wey due geem te pegdegpak te gimukud diye te linew ne hapuy. Uya, egnangenan ku sikaniyu te kaaldeki niyu sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ka lalimma ne mallilintek ne maya ne igbelegye de te baratu, piru ware sabeka kandan ne egkalingawan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne sikaniyu, minsan ka me bulbul te ulu niyu naseel rin ma langun. Purisu, kene kew kaaldek, su subla kew pad ne labew du te me maya.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Egnangenan ku sikaniyu te ka minsan hentew ne eg-angken keddiey diye te tangkaan te me etew, sikeddi ne Anak te Etew, eg-angken degma kandin diye te tangkaan te me panalihan te Manama; ");
INSERT INTO mbtNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piru minsan hentew ne egpahunware meyitenged keddiey diye te tangkaan te me etew, igpahunware ku degma diye te tangkaan te me panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Minsan hentew ne eglemet te Anak te Etew, egkapasaylu red, piru ka minsan hentew ne egbaley-baley te Panisingan te Manama, kene iya egkapasaylu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ne emun ke eg-uyanen kew diye te me simbaan te me Hudiyu wey diye te tangkaan te me gubirnadur wey diye naa te me pangulu, kene kew kalaggew ke egmenuwen niyu te pegpangatarengan wey ke nekey ka iglalag niyu ");
INSERT INTO mbtNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","su egpanuluen kew te Panisingan te Manama te sika ne timpu ke nekey ka eleg ne iglalag niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nataman, due sabeka ne etew diye te kasuluhan ne migkahi diye te ki Hisus, “Talagpanulu, kahii nu pa ubag ka suled ku ne egbaaran a te karatuan ne inggaat te amey ney.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ne intabak din sikandin, “Usi, hentew-a ka migbehey keddi te katenged ne talaggukum niyu wey ke talagbaad te karatuan niyu?” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne migkahiyan din ka me etew, “Tanud-tanud kew wey bantey kew te pegkaalamlamen te minsan nekey, su ka malehet ne umul te etew ware diye te katubung din wey karakel te karatuan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne migpangguhud si Hisus te seini ne panunggilingan diye te kandan: “Due sabeka ne meyaman ne due tane din wey amana ne dakel ka nahaani rin te me pinamula rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne kahi rin diye te suman-suman din, ‘Nekey buwa ka eggimuwen ku te warad e egkatahuan ku te nahaani ku? ");
INSERT INTO mbtNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Uya bes, seini ka eggimuwen ku. Egguhusen ku ka me lelapeng ku wey eggimu a te dakel ne me lelapeng wey diye ku igtahu ka langun ne nahaani ku wey me kasangkapan ku.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne migkahi man-e sikandin, ‘Matubung ad. Nakalimud ad te dakel ne ingkeilangan ku te minsan pila pad ne leg-un. Egpeelay-helay e naan de, egkeen, eg-inum wey eggale-gale.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Piru migkahi ka Manama diye te kandin, ‘Egkeungel! Te seini ne karusileman, egkuen kud ka umul nu. Ne hentew naan e ka egpakakamuney te langun ne inlimud nu?’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Sika degma ka egkatamanan te etew ne eglilimud te karatuan para kandin de iya piru egkaayu-ayu diye te suman-suman te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne migkahiyan ni Hisus ka me hibateen din, “Purisu egnangenan ku sikaniyu te kene kew kalaggew meyitenged te umul niyu, ke nekey ka egkakeen niyu. Kene kew kalaggew te lawa niyu, ke nekey ka igsaluub niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Su ka umul impurtanti pad du te egkeenen, ne ka lawa impurtanti pad du te igsaluub. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tengtengi niyu ka me uwak, ware me pinamula ran wey eggaaniyen dan wey ware lelapeng dan, piru impakeen sikandan te Manama. Ne sikaniyu, labew kew pad iya te me manuk-manuk. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na, hentew ma kaniyu ka egpakapamalayat te umul rin pinaahi te pegkalaggew rin? Ware iya! ");
INSERT INTO mbtNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Purisu, ke kene kew egpakasumpul te umul niyu minsan deisek de, mania te egkalaggew kew pad te duma ne keilangan niyu? ");
INSERT INTO mbtNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sumsumana niyu ka me bulak ke immenu ran te egdakel. Ware sikandan miggimu wey migpaneyi te igsaluub dan. Piru egnangenan ku sikaniyu te minsan si Sulumun, ka amane e ne meyaman wey mabantug, ware ma kumbale din ne iling kateles te seeye ne me bulak. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ke impamatelesan te Manama ka me bulak ne neuyag pad kuntee, ne egsilaban ded te seup ne aldew, iyan kew naan pa kene pakumbalei nikandin? Amana ne deisek ka pegpalintutuu niyu! ");
INSERT INTO mbtNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kene kew kalaggew egdahayun ke nekey ka egkeenen niyu wey eg-inumen niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Su sika ka igkalaggew te me etew ne ware pegpalintutuu wey pegsalig te Manama. Piru nakanengneng e ka Amey niyu te egkeilanganen niyu seeye. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Purisu, paharia niyu pa ka Manama diye te geyinawa niyu wey igbehey rin ka langun ne ingkeilangan niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kene kew kaaldek minsan pila-pila kew re iya, su nahale ka Amey niyu te pegbehey kaniyu te me panalangin te peghari din. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ibelegye niyu ka me kasangkapan niyu wey ipamehey niyu ka halin diye te egkaayu-ayu. Puun due, egpakakuwa kew te puntil ne kene egkareetan ne eglimuran niyu te karatuan diye te langit. Kenad sika egkasalinan wey egkareetan su ware takawen diye ne egpakarani wey aney ne egpakaketket. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Su ke hendei ka karatuan niyu, diye degma ka geyinawa niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Pangandam kew layun wey pareket kew te sulu, ");
INSERT INTO mbtNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","iling te me suluhuanen ne migtetahad te ahalen dan ke ken-u eg-uli ka miggendiye te kasal. Te peg-uli din e, egpanektek sikandin wey sahuhune ne egkalukatan dan ka gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Keupianan te seeye se me suluhuanen ne nakita te ahalen dan ne ware miglipereng te pegginguma rin. Egnangenan ku sikaniyu te malehet: eg-ilis ka ahalen wey egpapinpinnuuwen din diye te keenanan ka me suluhuanen din wey egsendaran din sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Keupianan iya te seeye se migtetahad te peg-uli te ahalen dan minsan te egliware e te marusilem wey ke eg-ukale naan e ka manuk. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tantanuri niyu seini: emun ke nakanengneng ka kamuney te baley ke nekey ne uras eglepew ka takawen, egbantayan din iya ka baley rin eyew kene egpakaseled ka takawen. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ne sikaniyu degma, keilangan ne eg-andam kew su egginguma ka Anak te Etew te timpu ne ware niyu pallatenga.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ne migkahi si Pidru, “Magbebaye, sikanami naan de ka imparineg nu te sika ne panunggilingan wey ke para te langun?” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne migtabak ka Magbebaye, “Hentew-a ka suluhuanen ne matinumanen wey matagseb? Panunggilingan, ke imbehayan te ahalen ka suluhuanen din te katenged te pegmandu te me duma rin ne me suluhuanen, eyew egpakeen kandan te eleg ne timpu, ");
INSERT INTO mbtNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","keupianan din ke nasapenan sikandin ne miggimu te peg-uli te ahalen din. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Egnangenan ku sikaniyu te malehet: sikandin e ka egpeuyanen te ahalen din te langun ne karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piru ke mareet ka suluhuanen, egsuman-suman sikandin ne mananey pad eg-uli ka ahalen din, wey dutu egbunsud e egpanlampes te me duma rin ne me lukes wey malitan ne me suluhuanen, wey egpanaman-taman egkeen wey egpewubug-hubug. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ne eg-uli ka ahalen din te sabeka ne aldew ne ware din pallatenga, wey te uras ne ware din nanengnengi, wey egdusaan sikandin te ahalen wey igpalemung te me etew ne kene ne matinumanen. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ka uripen ne nakanengneng te igkeupii te ahalen din, piru ware migtanud-tanud wey ware migtuman dutu, egpanlampesan egpatamtamani. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piru ka suluhuanen ne ware nakanengneng te ingkeupii te ahalen din, wey egpekeyimu te eleg ne egkalampesan sikandin, eglampesan iya sikandin piru deisek de. Su minsan hentew ne imbehayan te dakel, eg-im-imanan degma te dakel; wey ka insalihan te dakel, eg-im-imanan degma te subla ne dakel. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Miggendini a su eyew te pegsilab kayi te ampew te tane; wey meupiya pad perem ke egkalegleg e. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piru keilangan ne eg-antus e pad te igpaneem-neem keddi, wey egmemasakit kuntee ka geyinawa ku taman te egkatuman e sika. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kahiyen niyu buwa ne iyan ku innendini ka eg-uyan te keupianan kayi te ampew te tane? Kene ne sika, su pegbaad-baad ka in-uyan ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Puun kuntee egkabaad-baad e ka taltalaanak. Emun ke lalimma sikandan, ka tatelu egkuntere te daruwa wey ka daruwa egkuntere te tatelu. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Egpekegkuntere ka amey te anak din ne me lukes, wey ka iney egpekegkuntere te me anak din ne me malitan. Ne egpekegkuntere degma ka anuhang ne malitan te me ambey ran.” ");
INSERT INTO mbtNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Migkahi man-e si Hisus diye te me etew, “Ke egkakita niyu ka egpaddusilem diye te iglineb, mahaan kew egkahi, ‘Eg-uran seini te kene egkaluhey,’ wey eg-uran iya. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne emun ke nanengnengan niyu ne diye migpuun ka kalamag te igkakawanan ne balabahan dapit te igsile, egkahi kew, ‘Egmeinit naa kuntee,’ wey egmeinit iya. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sikaniyu se egmapitew-pitew re, egpakasabut kew te me palinneu diye te langit, piru kene kew egpakasabut te me palinneu te Manama kuntee! ");
INSERT INTO mbtNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mania te kene kew egpakasuman-suman ke nekey ka eleg ne eggimuwen niyu? ");
INSERT INTO mbtNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ke due egbayung keykew wey igsumbung kad nikandin, pakannekal ka ne egkewusey kew te diye kew pad te dalan, su kema ke igpeendiye kad e nikandin te huwis, ne igpeendiye kad e man-e te pulis, ne egkataman ne igpaprisu kad e. ");
INSERT INTO mbtNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Egnangenan ku sikeykew te kene ka iya egpakalihawang ke kene nu egkaamin te egbayad ka multa nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Te seeye ne timpu, due me etew diye ne mignangen ki Hisus meyitenged te me matig-Galiliya ne inggimatayan ni Pilatu taheed te migpanubad sikandan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ne migkahiyan ni Hisus sikandan, “Ne puun su inggimatayan sikandan te iling due ne paahi, kahiyen niyu buwa ne subla pad sikandan ne makasesale du te duma ne matig-Galiliya? ");
INSERT INTO mbtNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kene! Piru egnangenan ku sikaniyu te emun ke kene niyu eg-inniyuhan ka me sale niyu, sikaniyu langun, egpatey red degma iling kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sumsumana niyu ka sapulu wey walu (18) ne me etew ne nalundusan te matikang ne baley diye te Siluam wey nammatey e. Kahiyen niyu buwa ne subla pad sikandan ne mareet du te duma ne matig-Hirusalim? ");
INSERT INTO mbtNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kene! Piru egnangenan ku sikaniyu te emun ke kene niyu eg-inniyuhan ka me sale niyu, sikaniyu langun, egpatey red degma iling kandan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nataman, migpangguhud si Hisus kandan te seini ne panunggilingan: “Due sabeka ne etew ne migpamula te kayu ne egngaranan te iggira. Inleuy rin seini eyew egpitawen ke duen e behas, piru ware nakita rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Seeye naa, migkahiyan din ka impatameng din te pinamulaan, ‘Tatelu e kuntee ne leg-un ka pegleuy-leuy ku te seini ne kayu eyew egpitawen ke duen naan e behas, piru warad iya nakita ku ne behas. Pelera nud e su egdaat-daat de te kalambehan te tane.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piru migtabak ka talagtameng, ‘Balahara nu pa ahalen, minsan te seini naan de ne leg-un su eglingkusen ku pad te egkali ka lebut din wey eg-ebunuwan ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Emun ke egbebehas e seini te seup ne leg-un, ne meupiye iya, piru ke kene, egpeleren e mule.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te sabeka ne Aldew te Peggimeley, migpanulu si Hisus diye te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ne due sabeka ne malitan diye ne migserepan te busew wey migderalu seled te sapulu wey walu (18) ne leg-un. Napeku e sikandin wey kenad e egkatul-id ka egsasindeg. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Te pegkakita ni Hisus te malitan, in-umew rin sikandin wey ingkahiyan, “Mengeatebey, neulian kad e te dalu nu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne intel-eban ni Hisus te belad din ka malitan wey due-rue ne nakasasindeg sikandin, wey indayan din e ka Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ne nabelu ka pangulu te simbaan te me Hudiyu su migpamawi si Hisus te Aldew te Peggimeley. Ne migkahi ka pangulu diye te me etew, “Due hen-em ne aldew te peggimu. Hendini kew te minsan nekey ne aldew ke egkeupian kew ne egkeulian, piru kene te Aldew te Peggimeley!” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ne migtabak ka Magbebaye kandin, “Sikaniyu se egpapitew-pitew re! Te Aldew te Peggimeley, warad iya minsan sabeka kaniyu kayi ne kene eggekad te me ayam din diye te intagkesan din wey eg-uyan te seeye eyew egpeinumen. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na, seini se kabuhalan ni Abraham, impaantus sikandin ni Meibulan seled te sapulu wey walu (18) ne leg-un. Mania te kene egkaayun ne egbawian sikandin te Aldew te Peggimeley?” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Puun te seeye ne lalag ni Hisus, neyilawan ka langun ne egkuntere kandin, wey nahale mule ka me etew tenged te kein-inuwan ne immangimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Migkahi si Hisus, “Mamenua ka Peghari te Manama? Nekey-a ka egkeilingan kayi? ");
INSERT INTO mbtNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Egpekeiling seini te beni te mustasa ne mallilintek ne impamula te etew diye te kamet din. Migtubu seeye wey migmalayat e ne nekeiling e te kayu wey migsesalahan e te me manuk-manuk ka me sugpang din.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mig-inse e man-e si Hisus, “Nekey-a ka egpeilingan ku te Peghari te Manama? ");
INSERT INTO mbtNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Egpekeiling seini te igpatulin te paan ne in-angey te sabeka ne malitan wey insewug din te harina ne egliware te saku, taman te migtulin ka langun ne innimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ne miggendiye si Hisus te Hirusalim wey sasangan degma sikandin ne egpanulu diye te me lungsud wey me bariyu ne egkaliharan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Due sabeka ne etew ne mig-inse kandin, “Ahalen, deisek bu re ka egkaluwas?” Ne migtabak si Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pakannekal kew te egseled te malig-et ne gumawan, su egnangenan ku sikaniyu te masulug ka eg-eleg-eleg piru kene egpakaseled. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Su egkataman ne eglekeban e te mahinged ka gumawan, wey diye kew naan de te lihawangan egsasasindeg wey egpanektek ne egkahi, ‘Ahalen, lukati key nikeykew!’ Ne egtabak sikandin, ‘Wara a nakanengneng ke hendei kew egpuun!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ne egtabak kew e, ‘Sikanami iya ka duma nu te migkeen wey mig-inum. Ne migpanulu ke pad iya man-e diye te inged ney.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piru egtabak e man-e sikandin, ‘Wara a nakanengneng ke hendei kew egpuun. Pariyu kew keddi, sikaniyu se mareet ne me etew.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ke egkiteen niyud ensi Abraham, si Isaak wey si Hakub, wey ka langun ne me prupita diye te Migharian te Manama, egmandalawit kew wey egmegkihet te ngipen niyu su diye kew re mule te lihawangan. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Due masulug ne me etew ne diye egpuun te igsile wey te iglineb wey puun diye te igkahibang ne balabahan wey te igkakawanan ne balabahan dapit te igsile ne eglagpu egkeen diye te Migharian te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pammineg kew, due namewuri kuntee ne egpekewun-a, wey due nekewun-a kuntee ne egkamewuri.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Te seeye ne timpu, due me Parisiyu ne miggendiye te ki Hisus wey migkahi, “Keilangan ne eg-awe kad kayi su egpeyimatayan ka ni Hirudis.” ");
INSERT INTO mbtNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ne migtabak si Hisus kandan, “Hipanew kew wey kahii niyu sika se egpekeiling te laku te egpangalew e pad te me busew wey egpamawi a te egmanderalu taman kaaselem. Ne ikaruwa, egkeimpusan kud ka himu ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Piru keilangan ne egpabulus a eggipanew kuntee, kaaselem wey ikaruwa su kene egkaayun ne diye eggimatayan te duma inged ka sabeka ne prupita, su diye de iya te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“E sikaniyu se matig-Hirusalim ne migpangimatey te me prupita wey migpandegpak te seeye se impeendue te kaniyu. Kamasalig ad e perem eglibulung kaniyu, iling te sabeka ne inayan ne migpangalupkup te me piyak din, piru ware kew neupii. ");
INSERT INTO mbtNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, eg-engkeran e ka siyudad niyu. Ne egnangenan ku sikaniyu, kene kew e egpakakita keddiey man-e taman te egkahi kew e, ‘Egdayanen sikandin se impeendini te Magbebaye ne Manama kanta.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te sabeka ne Aldew te Peggimeley, miggendiye si Hisus te baley te sabeka ne pangulu te me Parisiyu eyew te pegkeen, wey in-ipat sikandin ay-ayari te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne due etew diye te egkatangkaan din ne migpanlebag ka intiru ne lawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mig-inse si Hisus te me talagpanulu te Balaud te Manama wey me Parisiyu, “Intuhut naan ded te Balaud ka pegpamawi te Aldew te Peggimeley?” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piru ware sikandan migtabak. Ne inggen-genan ni Hisus ka etew wey imbawian din wey impeyipanew rin e. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne migkahiyan ni Hisus sikandan, “Ke due anak niyu wey ke ayam naa ne neulug diye te belun te Aldew te Peggimeley, kene niyu naa egdagdahawan te egkuwa?” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Piru ware sikandan nakatabak meyitenged dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nasahinda ni Hisus ne due me mahaliyug ne mig-alam te pinnuuwan te me talahuren, purisu migpangguhud sikandin kandan te seini ne paney-paney: ");
INSERT INTO mbtNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ke due egginggat keykew te sahakeen te kasal, kene ka pinnuu diye te pinnuuwan te talahuren ne me etew su hanew nu ke duen pad etew ne labew keykew. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne egdani-rani keykew seeye se migginggat kaniyu te daruwa wey egkahi, ‘Sikandin ka egpapinnuuwen ku kayi.’ Ne egkeyilawan kad e mule wey diye ke naan de egpakapinnuu te nakaledled ne pinnuuwan. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ke due egginggat keykew, meupiya pad ke diye ka te nakaledled ne pinnuuwan eyew egdani-rani ka migginggat keykew ne egkahi, ‘Suled, halin ka kayi te meupiya ne egpinnuuwan.’ Ligkat due, egkarayan ka diye te tangkaan te langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Su ka minsan hentew ne egparibabew te pegkeetew rin, igpariralem, ne minsan hentew ne egpariralem te pegkeetew rin, igparibabew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne migkahiyan ni Hisus ka migginggat kandin, “Ke eggilutu ka, kene nu iyan hinggata ka me alukuy nu wey me suled nu wey me karumaan nu wey me sumbaley nu ne meyaman su egpakasuli sikandan egginggat keykew, ne puun due egkasulian kad te miggimu nu kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ke eggilutu ka, iyan nu hinggata ka egkaayu-ayu wey ka me pungku wey ka me napiangan wey ka me butud. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ne keupianan nu su kene sikandan egpakasuli keykew. Iyan e egsuli keykew ka Manama te timpu ne egkeuyag ka me etew ne matareng.” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Te pegkarineg dutu te sabeka ne duma ran te egkekeen, migkahiyan din e si Hisus, “Keupianan te seeye se etew ne egpakakeen diye te Migharian te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne migpangguhuran sikandin ni Hisus, “Due etew ne miggilutu te dakel ne egkeenen wey masalig ka me etew ne ingginggat din. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te miggingume e ka uras ne egsahakeen e, insuhu din e ka suluhuanen din eyew egnangenan seeye se impanginggat din te naandam e ka langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ka tagse sabeka kandan, mig-ealiddanan ne kene egpekeendiye. Migkahi ka an-anayan, ‘Kene ke re keenendueni su nakabeli a te tane wey keilangan ne egleuyen ku seini.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ne migkahi ka igkarangeb, ‘Kene ke re keenendueni su nakabeli a te sapulu ne baka ne eggendiyaan ku naa su eg-el-elehan ku igdaru.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Migkahi ka igkatelu, ‘Iyam a nakaasawa sikan naa ka kena a egkaayun ne eggendiye.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Seeye naa, miglibed e ka suluhuanen wey impangguhuran din e ka ahalen din. Nabelu-belu ka ahalen meyitenged dutu wey migkahiyan din ka suluhuanen din, ‘Hendiye ka dagdahew te kelesadda wey me dalan, wey dumaa nu kayi ka me etew ne egkaayu-ayu, me pungku, me butud wey ka nenapiangan.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te ware naluhey, migkahi ka suluhuanen, ‘Ahalen, natuman e ka insuhu nu, piru ware napenu ka keenanan.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ne migkahi ka ahalen din, ‘Hendiye ke pa man-e te me dalan wey diye te ligwang te siyudad wey pehesa nu ka me etew ne eggendini eyew egkapenu seini se baley ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Egnangenan ku sikaniyu te ware minsan sabeka te seeye se hun-a ne inninggat ku ne egpakaheram te sahakeen ku!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Due masulug ne me etew ne migduma ki Hisus te miggipanew. Ne miglilingey sikandin wey migkahiyan din sikandan, ");
INSERT INTO mbtNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Minsan hentew ne eggendini te keddiey, ne kene din pad eg-engkeran ka igkatiglingey rin diye te amey rin wey iney rin wey asawa rin wey me anak din wey me suled din, wey kene din eg-engkeran ka kandin mismu ne igkeupii, kene egkaayun ne egkeyimu ne hibateen ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne minsan hentew ne kene egtiang te kandin ne krus wey kene eg-ikul keddiey, kene egkeyimu ne hibateen ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ke due sabeka kaniyu ne egsuman-suman egpes-ek te matikang ne baley, eggun-aan din pad iya te egsuman-suman ke pila ka egkahastu rin wey ke egpekeeleg naa ka seleppi din taman te egkeimpusan ka baley. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Su emun ke kene din eggimuwen sika, kema ke tibbal re egkapes-ekan ne kenad egkeimpusan, wey eglemetan e nasi sikandin te egpakakita dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Egkahi sikandan, ‘Et, egpaalag-alag ubag seini ne etew egbebaley ne kene bes egpekeimpus!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ne iling ded degma ke due sabeka ne Hari ne due sapulu ne libu (10,000) se sundalu rin ne egpakigbunu te lein ne Hari ne due daruwa ne pulu ne libu (20,000) se sundalu. Eggun-aan din pad iya te egsuman-suman ke egpakaatu naa sikandan ne egpakigsukub te Hari ne due daruwa ne pulu ne libu (20,000) se sundalu. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ke suman-suman din ne kene sikandin egpakaatu, meupiya ne egsuhu sikandin te me etew rin te pegnangen te kuntere din taheed te diye pad te mariyu ne egpewusayey naan de sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iling naan ded due, sumsumana niyu pa ke egpekeikul kew naa keddiey. Su minsan hentew ne kene egpekeengked te langun ne diye te kandin, kene egkeyimu ne hibateen ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Meupiya ka asin, piru ke egkaawaan e ka asin te nanam din, egmenuwen pad te pegpalibed te nanam din? ");
INSERT INTO mbtNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Warad karuan due wey kenad egkahamit diye te tane wey ke ig-ebunu naa, sikan naa ka igdegpak e. Purisu, ke egkeupian kew ne egpakasabut, sumsumana niyu ay-ayari ke nekey ka narineg niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Due sabeka ne timpu ne masulug ka me talagsukut te buhis wey me makasesale ne miggendiye te ki Hisus eyew te pegpammineg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Migbahulbul ka me Parisiyu wey ka me talagpanulu te Balaud te Manama. Migkahi sikandan, “Ka seini ne etew mig-al-alumama te me makasesale wey miglagpu kandan te egkeen!” ");
INSERT INTO mbtNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Puun due, impangguhuran din sikandan te seini ne panunggilingan: ");
INSERT INTO mbtNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Panunggiling ke due sabeka kaniyu ne due mahatus (100) ne karniru ne natarinan te sabeka, nekey-a ka eggimuwen din? Eg-engkeran din iya ka siyam ne pulu wey siyam (99) diye te egpanabtaban, wey egpammitawen din ka natarin ne karniru taman te egkakita rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ke egkakita rin e seini, egkahale iya sikandin wey egtiangen din e ");
INSERT INTO mbtNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","te eg-uli. Pegginguma rin diye te baley, egpanginggaten din e ka me alukuy rin wey ka me sumbaley rin te egkahi, ‘Eggale-gale ki su nakita kud e ka natarin ne ayam ku.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iling naan ded degma due, egnangenan ku sikaniyu te subla pad ka kahalaan diye te langit tenged te sabeka ne makasesale ne eg-inniyug te sale din, du te siyam ne pulu wey siyam (99) ne me matareng ne kene egkeilangan ne eg-inniyug te sale. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Panunggiling ke due malitan ne due sapulu din ne pelata ne mahal wey natarinan te sabeka, nekey naa ka eggimuwen din? Egpareket iya sikandin te sulu wey egpanlimas te baley rin, ne egpaay-ayaran din seeye te egpammitew taman te egkakita rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne emun ke egkakita rin e seini, eg-umawen din ka me alukuy rin wey me sumbaley rin te egkahi, ‘Eggale-gale ki su nakita kud e ka natarin ne seleppi ku!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iling naan ded degma due, egnangenan ku sikaniyu te igkahale te me panalihan te Manama ka sabeka ne makasesale ne eg-inniyug te sale din.” ");
INSERT INTO mbtNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ne migpabulus si Hisus migkahi, “Due sabeka ne etew ne due anak ne daruwa ne neelin ne lukes. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sabeka ne aldew, migkahi ka hari diye te amey, ‘Ame, behayi ad e te keddiey ne baad te karatuan ta.’ Ne imbaad e te amey ka karatuan din diye te daruwa ne anak din. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Peglihad te pila ne aldew, imbelegye te hari ka kandin ne baad wey miggipanew sikandin diye te mariyu ne inged. Ne diye din us-usala ka seleppi din te ware karuan ne me himu. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Te naamin din e te miggastu ka seleppi din, due migginguma ne masumpit ne bitil te seeye ne inged wey amana sikandin neilui te langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sikan naa, migweil-weil sikandin wey migtrabahu e diye te sabeka ne mahinged dutu wey impeendiye sikandin te unayan eyew egpatangguwen te me babuy. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ne puun su eggutasan e amana sikandin, egkeupian e perem sikandin ne egkeen te igsunggud te babuy, su ware minsan sabeka ne migbehey kandin te egkakeen. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Te katamanan, nakamaan-maan e sikandin te neyimu rin wey migkahi, ‘Egkabayangan ka me suluhuanen te amey ku te egkakeen, piru egkapatey ad mule seini te gutas! ");
INSERT INTO mbtNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Meupiya pad ke eg-awa a kayi wey eglibed a diye te amey ku wey egkahiyan ku sikandin, “Ame, nakasala a te Manama wey due te keykew. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kena ad likes ne egngaranan e pad nikeykew ne anak nu. Isipe e naan de nikeykew ne sabeka ne suluhuanen nu.” ’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne miggipanew e sikandin wey miggendiyad te amey rin. “Piru te diye pad sikandin te mariyu, nakakite e ka amey ran kandin. Neyid-u ka amey te anak din wey migpallahuy ka migsinug-ung kandin wey migkepkepan din wey miggarekan din ka anak din. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ne migkahi ka anak, ‘Ame, nakasala a te Manama wey diye te keykew. Kena ad likes ne egngaranan e pad nikeykew te anak nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piru migpangumew ka amey te me uripen din ne migkahi sikandin, ‘Hendini kew! Uyana niyu kayi ka subla ne meupiya ne hinabel wey saluubi niyu sikandin wey saluubi niyu man-e te sising wey sepatusi niyu sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne kua niyu ka malambeg ne nati te baka wey himatayi niyu su egsahakeen ki. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Su seini se anak ku ne napatey e, neuyag ded; natarin sikandin ne nakite e.’ Ne migbunsud e sikandan miggale-gale. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Te seeye ne timpu, diye te kamet ka kakey ne anak, wey eg-uli e degma. Te nakarani-rani e sikandin te baley ran, nakarineg sikandin te due eg-ulahing wey egsesayew. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne dutu, in-umew rin ka sabeka te me suluhuanen wey mig-insaan, ‘Nekey-a ka eggimuwen niyu due?’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ne migtabak ka suluhuanen, ‘Mig-uli ka hari nu wey ware ded sikandin namenu sikan naa, impeyimatayan te amey nu ka malambeg ne nati te baka.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nalangetan ka kakey wey kene egkeupian ne egseled te baley. Sikan naa ka miglihawang ka amey wey inlimlimuan din ka anak din. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piru migtabak sikandin te amey rin, ‘Kema Ame, sumsumana nu ke pila ne tuig ne migtrabahu a keykew iling te uripen, wey wara ad iya mig-apul te insuhu nu. Piru wara ad iya nikeykew behayi minsan nati naan de te kambing eyew eggale-gale a duma te me alukuy ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Piru te peg-uli mule te anak nu ne migdaat-daat te karatuan nu duma te me malitan ne egmamelegye te lawa, impeyimatayan nu pad sikandin te malambeg ne nati te baka.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ne migtabak ka amey, ‘Tatu, layun ku duma sikeykew, wey keykew degma ka langun ne keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ne keilangan ne egsahakeen ki wey eggale-gale ki su ka hari nu ne kahiyen ku ne napatey e, neuyag bes ded; natarin sikandin ne nakite e.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne migpangguhuran e ni Hisus ka me hibateen din, “Due sabeka ne meyaman ne due sinalihan din. Due migsumbung diye te kandin ne migdaat-daatan kun te sinalihan din ka me karatuan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ne in-umew rin ka sinalihan din wey migkahiyan, ‘Nekey-a ka narineg ku meyitenged keykew? Behayi a te malehet ne guhuren meyitenged te impeuyan ku keykew ne karatuan, su kene kud egsalihan sikeykew.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ne migkahi ka sinalihan diye te isip din, ‘Egpaaween ad e te ahalen ku. Nekey buwad e se eggimuwen ku? Kene egkaayun ne egkekali a su kena a ne manekal wey egkeyilew a degma ne egpamuyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","E, uya, seini bes ka eggimuwen ku su eyew ke egpaaween ad e te ahalen ku, duen ded me etew ne egpepamaneyik keddi diye te me baley ran.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ne impeumew rin ka langun ne nekeutang te ahalen din. Mig-insaan din ka hun-a, ‘Pilaa ka utang nu diye te ahalen ku?’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ne migtabak sikandin, ‘Mahatus (100) ne lata ne lana.’ Ne migkahi ka sinalihan, ‘Seini red ka kentiddad. Dagdahew ka pinnuu wey lalimma ne pulu (50) de isulat nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ne mig-insaan din man-e ka ikarangeb, ‘Ne sikeykew, pilaa ka utang nu?’ Ne migtabak sikandin, ‘Sabeka ne libu (1,000) ne saku ne trigu.’ Ne migkahi ka sinalihan, ‘Walu ne gatus (800) de isulat nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Indeyrey te ahalen ka limbungen ne sinalihan su egkateu ne egpaney-paney meyitenged te keuyahan din. Su ka kalibutanen ne me etew, subla pad ne egkateu ne egpeup-upianey te me iling dan ded du te me etew ne diye te malayag.” ");
INSERT INTO mbtNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne migpabulus si Hisus migkahi, “Kuntee egnangenan ku sikaniyu te gamita niyu ka me karatuan niyu kayi te inged eyew due me alukuy niyu, su eyew ke egkaamin e seini, egdawaten kew red nikandan diye te ugpaan ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Minsan hentew ne egkasalihan te deisek, egkasalihan degma te dakel; wey minsan hentew ne eglilimbung te deisek, eglilimbung degma te dakel. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne emun ke kene kew egkasalihan te karatuan kayi te ampew te tane, hentew naa degma ka egsalig kaniyu te malehet ne karatuan diye te langit? ");
INSERT INTO mbtNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ke kene kew egkasalihan te kasangkapan te duma, hentew naa ka egbehey kaniyu te kasangkapan ne kaniyud e? ");
INSERT INTO mbtNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ware etew ne egkeyimu ne uripen te daruwa ne ahalen, su egdumutan din ka sabeka ne ka dangeb eggeyinawaan din. Egdapihan din ka sabeka wey ka dangeb eglemetan din. Ne iling naan ded due, kene egkaayun ne egpeuripen kew te daruwa, te Manama wey te seleppi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Narineg seeye langun te me Parisiyu wey migdali-dian dan si Hisus su iyan dan indakelan ka seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ne migkahiyan ni Hisus sikandan, “Egpapitew-pitew kew re diye te me etew ne meupiya kew, piru nakanengneng ka Manama te pusung niyu. Su ka amana igkatalesi te me etew, amana igkeepes te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ka Balaud te Manama wey ka sinulat te me prupita, in-ikul taman de te timpu ni Huwan ne Talagbewutismu. Pegkapenga dutu, inwali e ka Meupiya ne Panugtulen meyitenged te Peghari te Manama, wey migpakannekal ka tagse etew te pegseled kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piru malemu pad ne egkaawe ka langit wey ka tane, du te egkeyimu ne ware karuan ka deisek ne baad te Balaud te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Minsan hentew ne eg-engked te asawa rin wey egbalew-balew eg-asawa, egpakapanlibug e. Ne ka lukes ne eg-asawa te malitan ne in-engkeran, egpakapanlibug degma. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Due sabeka ne meyaman ne migsaluub te kumbale ne ubi se batek wey mahal, wey egsahakeen sikandin te mangune-kune te tagse aldew. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Due degma egkaayu-ayu ne egngaranan ki Lasaru ne neempet te kehang ka lawa rin. In-uyan sikandin diye te gumawan te baley te meyaman, ");
INSERT INTO mbtNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","su egkeupian ubag sikandin ne egpakakeen te egkengeulug ne mummu puun te lamisa te meyaman. Migparaniyan sikandin te me asu wey impandilaan ka me kehang din. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Te katamanan, migpatey si Lasaru wey in-uyan sikandin te me panalihan te Manama diye te kakiliran ni Abraham. Migpatey degma ka meyaman wey inlebeng. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Imbaybayaran sikandin diye te inged te me gimukud ne egngaranan te Hadis, wey migleng-ag sikandin wey nakita rin si Abraham diye te mariyu wey si Lasaru diye te kakiliran din. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ne migpanguleyi ka meyaman ne migkahi, ‘Apu Abraham! Ikeyid-u a nikeykew wey suhua nu si Lasaru ne igtinduk din ka kemel rin te weyig wey egpatihisan ka dile ku eyew egmaagsil ubag, su mangune-kune ka peg-antus ku te keinit te seini se hapuy!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Piru migtabak si Abraham, ‘Mengeanak, sumsumana nu te diye ke pad te ampew te tane ne narawat nu ka langun ne me meupiya, piru si Lasaru mareet mule se natamtamanan. Piru kuntee nahale e sikandin kayi, wey sikeykew eg-antus ka due. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne igkarangeb, due seini se eletanan ta ne maralem, eyew ka etew kayi kene egpekeendue wey ka etew due kene egpekeendini.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ne migtabak ka meyaman, ‘Apu, ke iling due, eghangyu a keykew ne ipeendiye nu pa ubag si Lasaru te ugpaan te amey ku, ");
INSERT INTO mbtNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","su duen pad suled ku ne lalimma ne neelin ne lukes. Peendiyaa nu sikandin eyew egkapanpanayan sikandan wey eyew kene egpekeendini kayi te inged ne mangune-kune se pegbayad-bayad.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Piru migtabak si Abraham, ‘Mani naa su diye ded ka sinulat ni Muwisis wey te me prupita. Sikandan e ka mateu ne egpammineg dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ne migtabak ka meyaman, ‘Piru apu Abraham, kene pad ne eleg sika. Piru ke due perem egkeuyag ne eggendiye te kandan, eg-inniyuhan dan iya ka me sale dan.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Piru migkahi si Abraham, ‘Emun ke kene sikandan egpammineg te sinulat ni Muwisis wey te me prupita, kene ded iya man-e sikandan egkeuyan minsan pad due migpatey ne egkeuyag.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ne ingkahiyan ni Hisus ka me hibateen din, “Ka etew eggingumaan iya te me pegtintal, piru mekeyid-u-hid-u ka etew ne egpuunan kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Meupiya pad ke eggiketan ka lieg din te dakel ne galingan ne batu wey igdegpak diye te dahat, du te sikandin ka egpuunan ne egpakasale ka sabeka te seini se me bate. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sikan naa, tanud-tanud kew! “Ke egpakasale ka duma nu, sapari nu sikandin; wey ke eg-inniyug te sale, pasayluwa nu. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ke kapapitu sikandin egpakasale keykew te sabeka ne aldew, wey kapapitu degma sikandin eglibed wey egbuyu te pasaylu diye te keykew, keilangan ne egpasayluwen nu sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ne migkahi ka me apustulis diye te kandin, “Magbebaye, timuli nu ka pegpalintutuu ney.” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne migtabak ka Magbebaye, “Ke due pegpalintutuu niyu minsan iling kareisek te behas te mustasa, egpakasuhu kew te seini ne kayu, ‘Kabarut ka wey halin ka diye te dahat!’ wey egpalintutuu iya seini kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Panunggiling ke due sabeka kaniyu ne due suluhuanen ne migdaru wey ke migtanggu te me ayam. Ke sikan pad iya sikandin egginguma puun te kamet, egkahiyan nu naa sikandin, ‘Hendini kad wey keen kad’? ");
INSERT INTO mbtNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kene iya! Ke kene, nasi nu sikandin egkahii, ‘Andami a te iglabung ku, wey sendari a. Ke egpakapenga ad, human ke pa keen.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Egpasalamatan nu naa ka suluhuanen nu puun su migpalintutuu sikandin te insuhu nu? Kene iya! ");
INSERT INTO mbtNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ne iling kew red degma, ke egkapengaan niyud e ka langun ne insuhu kaniyu, kahi kew, ‘Me suluhuanen key re, wey innimu ney re ke nekey ka impeyimu kanami.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te sasangan pad ne eggipanew si Hisus peendiye te Hirusalim, miglihad sikandin te eletanan te Samarya wey Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te egpalinggumaan e sikandin te sabeka ne bariyu, due migsinug-ung kandin ne sapulu ne ibungen. Diye de sikandan nanasindeg te madmariyu ");
INSERT INTO mbtNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wey migpanguleyi sikandan, “Hisus ne Magbebaye! Ikeyid-u key nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pegkakita ni Hisus kandan, migkahiyan din sikandan, “Hendiye kew te me talagpanubad wey papitew kew kandan.” Te nangipanew e sikandan, neneulian dan e diye te deralanen. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pegkakita te sabeka kandan ne neulian e sikandin, miglibed e sikandin wey migpanguleyi ka migdayan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Migpanimbuel sikandin diye te tangkaan ni Hisus wey migpasalamat kandin. Matig-Samarya ka seeye ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ne migkahi si Hisus, “Sapulu niyu ma te neulian; hendei naan e ka siyam? ");
INSERT INTO mbtNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mania te ware sikandan miglibed eyew egpasalamat te Manama, ne iyan de iya seini se kene ne mahinged kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne migkahiyan ni Hisus sikandin, “Sasindeg ka wey hipanew kad e. Iyan nekeuli keykew ka pegpalintutuu nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Due me Parisiyu ne mig-inse ki Hisus ke ken-u egginguma ka Peghari te Manama. Migtabak sikandin kandan, “Ware palinneu ne iyan tuus te pegginguma te Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ware egpakakahi, ‘Pitew kew, sein ded!’ wey ke ‘Seeye ded!’ Su ka Peghari te Manama duen e te kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne migkahiyan din ka me hibateen din, “Egginguma ka timpu keureme ne egkeupian kew ne egtengteng te Anak te Etew minsan senge ka aldew re perem, piru kene kew egpakakita kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Due me etew ne egkahi kaniyu, ‘Pitew kew, diye sikandin!’ wey ke ‘Kayi sikandin!’ Piru kene kew hendiye wey ikul kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Su ka peglibed te Anak te Etew egpekeiling te kilat ne eggeteb ne egpakatulis ka layag diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piru hun-a te langun, keilangan ne eg-antus sikandin wey egsamsamilian te me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Su ka pegginguma te Anak te Etew egpekeiling te neyitabu te timpu ni Nuwi. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Migpabulus ka me etew ne nangekeen wey nangiinum wey migmaas-asaweey taman te aldew ne migseled e ensi Nuwi diye te arka. Nataman, migsipuk e ka weyig wey nalened ka langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Egpekeiling ded degma te timpu ni Lut. Ka langun ne etew migpabulus nangekeen wey nangiinum, wey nambebeli wey nambelegye, migmammula wey nambebaley. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te aldew ne mig-awe e si Lut te Suduma, mig-uranan seeye te hapuy wey te me batu ne egkalegleg ne egngaranan te asupri ne miggule te langun ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iling degma due ka egkeyitabu te aldew ne egpakite e ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Te seeye ne timpu, seeye se etew ne diye te atep te baley rin, keilangan ne kenad e egpamaneug eyew egkuwa te me kasangkapan din diye te seled. Ne seeye degma se diye te kamet, keilangan ne kenad e eg-uli. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tantanuri niyu ka neyitabu te asawa ni Lut! ");
INSERT INTO mbtNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Seeye se egkeupian ne egluwas te kandin ne umul, nasi egkawaraan kayi, piru seeye se egkawaraan te kandin ne umul, egpakarawat te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Te seeye ne karusileman, due daruwa ne etew ne migpewulirey ka miggibat; eg-angayen ka sabeka wey eggaaten ka dangeb. ");
INSERT INTO mbtNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ke due daruwa ne malitan ne eggehaling; eg-angayen ka sabeka wey eggaaten ka dangeb.” ");
INSERT INTO mbtNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ne mig-inse ka me hibateen din, “Magbebaye, hendei sika egkeyitabu?” Ne migtabak sikandin, “Ke hendei ka lawa ne napatey, diye degma eglibulung ka me banug.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ne migpangguhuran ni Hisus ka me hibateen din te sabeka ne panunggilingan eyew te pegpanulu kandan ne keilangan ne layun eg-ampu wey kene egkapelaan. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ne migkahi si Hisus, “Diye te sabeka ne siyudad, due sabeka ne huwis ne kene egkaaldek te Manama wey kene egtahud te minsan hentew ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te seeye ne siyudad, due degma balu ne malitan ne layun eglibed-libed eggendiye te huwis eyew te pegpepangabang te kandin ne kasu. Migkahi ka balu, ‘Pangabangi a nikeykew su due me kuntere ku!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Te an-anayan migkene-kene ne egpangabang ka huwis, piru te katamanan nakakahi sikandin diye te geyinawa rin, ‘Minsan kena a egkaaldek te Manama wey te me minsan hentew, ");
INSERT INTO mbtNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","piru tenged su layun eglibed-libed ka balu kayi te keddi, egpangabangan kud e. Su kema ke egkeupul ad tenged te peglibed-libed din.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne migkahi ka Magbebaye ne si Hisus, “Sumsumana niyu ka inlalag te huwis minsan kene din ne matareng. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na, kene naa degma egpangabangan te Manama ka me etew ne in-alam din ne migpangananey te aldew wey marusilem? Eglamu-lamu naa ka Manama ne egpangabang kandan? ");
INSERT INTO mbtNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Egnangenan ku sikaniyu, egdagdahawan din te egpangabang sikandan. Piru te peglibed te Anak te Etew, duen bu red egkakita rin ne me etew kayi te ampew te tane ne due pegpalintutuu?” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Due me etew ne migsusuman-suman ne matareng en iya sikandan, wey migdew-ey te duma. Ne puun due, migpangguhuran sikandan ni Hisus te seini ne panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Due daruwa ne etew ne miggendiye te timplu eyew te peg-ampu. Ka sabeka Parisiyu wey ka dangeb talagsukut te buhis. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ne migsasindeg ka Parisiyu ne mig-ampu te kandin, ‘Migpasalamat a keykew Manama ne kena a ne iling te duma ne leheren, limbungen, wey egpanlibug. Migpasalamat a ne kena a man-e ne iling te sika se talagsukut te buhis. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne egpuasa a man-e te daruwa ne aldew tagse simana, wey egbehey a te igkasapulu te langun ne egkaseleppi ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Piru ka talagsukut te buhis diye de migsasindeg te mariyu wey ware sikandin migleng-ag diye te langit. Piru impandabi rin de mule ka kumeng din tenged te pegkalaggew wey migkahi, ‘Manama, ikeyid-u a nikeykew se makasesale!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na, egnangenan ku sikaniyu te sikandin ka in-isip te Manama ne matareng te peg-uli din, kene ne seeye se Parisiyu. Su ka minsan hentew ne egparibabew te pegkeetew rin, igpariralem, piru minsan hentew ne egpariralem te pegkeetew rin, igparibabew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Due me etew ne mig-uyan te me anak dan diye te ki Hisus eyew igpasamsam kandin. Pegkakita dutu te me hibateen, insaparan dan sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piru impeparani ni Hisus ka me bate wey migkahiyan din ka me hibateen din, “Balahara niyu re due ka me bate ne egparani keddiey wey kene niyu sikandan sapari, su nasakup te Migharian te Manama ka me bate ne iling kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Egnangenan ku sikaniyu te malehet: emun ke kene niyu egdawaten ka Peghari te Manama iling te pegdawat te me bate, kene kew iya egpakalagkes dutu. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mig-inse ka sabeka ne pangulu te me Hudiyu diye te ki Hisus, “Meupiya ne talagpanulu, nekey-a ka eggimuwen ku eyew egkarawat ku ka umul ne ware egtamanan?” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ne migtabak si Hisus kandin, “Mania te ingngaranan a nikeykew te meupiya? Sabeka re ka meupiya, ka Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nakanengneng kad e te me suhu: ‘Kene ka panlibug, kene ka himatey, kene ka panakew, kene ka pamalehet te ubat, wey tahura nu ka amey nu wey iney nu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Migtabak ka etew, “Intantanuran kud sika langun ligkat te pegkabatei ku.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Te pegkarineg ni Hisus kayi, migkahiyan din ka etew, “Sabeka naan de ka ware nu pad neyimu. Ibelegye nu ka langun ne karatuan nu, wey ipamehey nu ka halin diye te egkengaayu-ayu eyew due karatuan nu diye te langit. Ne egkataman, libed ka kayi wey ikul ka keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Piru te pegkarineg dutu te etew, miglungku sikandin su subla ne meyaman sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ne migtengtengan ni Hisus ka etew ne miglungku wey migkahi, “Amana ne malised te me meyaman ka pegseled te Migharian te Manama! ");
INSERT INTO mbtNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Malemu pad ka pegserep te ayam ne kamilyu diye te lungag te simat du te pegseled te meyaman diye te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ne mig-inse seeye se nakarineg dutu, “Hentew bes naan de ka egkaluwas?” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne migtabak si Hisus, “Ka kene egkeyimu te etew, egkeyimu te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne migkahi si Pidru, “Na, sikanami seini, mig-engkeran ney ka langun ne kanami eyew te peg-ikul keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ne migkahiyan sikandan ni Hisus, “Egnangenan ku sikaniyu te malehet: ka minsan hentew ne eg-engked te baley rin, wey ke asawa rin, me suled din naa, wey ke amey wey iney rin, me anak din naa tenged te Peghari te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","egpakaangken te subla pad te seini ne timpu. Te egginguma ne timpu, egpakarawat sikandin te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Impasuwey ni Hisus te me etew ka sapulu wey daruwa (12) ne hibateen din wey migkahiyan din, “Pammineg kew! Eggendiye kid e te Hirusalim ne egkatuman e ka langun ne insulat te me prupita meyitenged te Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ne igbehey sikandin diye te kene ne me Hudiyu, wey eglemetan sikandin wey egpeyilawan, wey eg-il-ileban sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eglampesan sikandin wey eggimatayan, piru egkeuyag sikandin te igkatelu ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Piru ware nakasabut ka me hibateen te igpasabut dutu, su inneles kandan ka kaluwasan te inlalag din. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Te nakarani-rani e si Hisus diye te inged ne Hiriku, due sabeka ne butud ne migpinnuu diye te ilis te dalan ka egpamuyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te nakarineg sikandin te due masulug ne etew ne eglihad, mig-inse sikandin, “Nekey-a ka rue?” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Migkahi ka me etew diye te kandin, “Eglihad si Hisus ne matig-Nasarit.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Seeye naa, migpanguleyi sikandin ne migkahi, “E Hisus! Kabuhalan ni Dabid! Ikeyid-u a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ne insaparan sikandin te me etew ne miggun-a ne egpeen-enengen e, piru nanasnasian de iya sikandin migpanaman-taman migpanguleyi ne migkahi, “Kabuhalan ni Dabid! Ikeyid-u a nikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Migsanggel si Hisus wey insuhu ne eg-uyanen ka butud diye te kandin. Te nakarani-rani e ka butud, mig-insaan e sikandin ni Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nekey-a ka igkeupii nu ne eggimuwen ku due te keykew?” Migtabak sikandin, “Magbebaye, egkeupian a perem ne egpakakite e pad.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne migkahiyan sikandin ni Hisus, “Egpakakita kad e! Iyan nekeuli keykew ka pegpalintutuu nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ne sahuhune ne nakakite e sikandin wey migsinundul e ki Hisus, wey indayan din ka Manama. Ka langun ne etew ne nakakita dutu, migdayan degma sikandan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ne migpabulus si Hisus diye te inged ne Hiriku wey eglihad de. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne diye, due sabeka ne meyaman ne egngaranan ki Sakiyu, ne pangulu te talagsukut te buhis ");
INSERT INTO mbtNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ne egkeupian ne egpitew ki Hisus. Piru ware sikandin nakakita kandin su masulug amana ka me etew wey malibutut sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Seeye naa, migpallahuy sikandin ka miggun-a wey migpamaneyik te kayu ne egngaranan te sikumuru eyew egpakakita sikandin ki Hisus su diye iya sikandin egbaye. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Te nakalenged e si Hisus dutu, migleng-ag sikandin wey migkahi, “Sakiyu, mahaan ka rue! Pamaneug ka su keilangan ne diya a kuntee egginguma te baley nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Migdagdahew migpamaneug si Sakiyu wey mig-alumama ki Hisus ne nahale-gale. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pegkakita dutu te me etew, migbahulbul sikandan langun ne migkahi, “Etuwey, iyan din mule egpanumbalayan ka etew ne makasesale!” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ne migsasindeg si Sakiyu wey migkahi, “Magbebaye, pammineg ka! Igbehey ku ka baad te karatuan ku diye te me etew ne egkaayu-ayu, wey ke due nalimbungan ku, eg-ulian ku sikandin te hep-at ne lupi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ne migkahiyan sikandin ni Hisus, “Seini ne aldawa miggingumaan te kaluwasan ka seini ne baley, su kabuhalan ka degma ni Abraham. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Su iyan innendini te Anak te Etew eyew te pegpammitew wey pegluwas te natarin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nataman, migpangguhuran ni Hisus te panunggilingan ka me etew ne egkalihet pad ne egpammineg kandin, su egpalinggumaan e sikandan te Hirusalim wey nangenen te me etew ne mahaan e egginguma ka Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sikan naa ka migkahi si Hisus, “Due sabeka ne talahuren ne etew ne miggipanew te mariyu ne inged eyew egdawat te katenged te peghari diye te inged din, wey eg-uli ded sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te ware pad sikandin migligkat, impeumew rin ka sapulu ne suluhuanen din wey ka tagse sabeka impamehayan din te seleppi ne bulawan wey migkahiyan din sikandan, ‘Paanaka niyu seini te kene e pad eg-uli.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Piru igkeepes-epes sikandin te me etew te seeye ne inged. Seeye naa, migsuhu sikandan te egpasinundulen kandin diye te innendiyaan din wey egpakahiyen te kene sikandan egkeupian ne eghari sikandin kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Piru neyimu iya sikandin ne Hari, ne nataman, mig-uli ded iya sikandin wey impeumew rin e ka me suluhuanen ne impamehayan din te seleppi, eyew egkanengnengan din ke pila ka anak te seleppi din diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka an-anayan miggendiye wey migkahi, ‘Ahalen, mig-anak te sapulu ne lupi ka seleppi ne imbehey nu keddi.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ne migkahi ka Hari, ‘E, meupiya. Meupiya ka ne suluhuanen. Tenged su egkasalihan ka te dereisek de, egbehayan ku sikeykew te katenged ne egmandu te sapulu ne siyudad.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Migginguma degma ka igkarangeb ne suluhuanen wey migkahi, ‘Ahalen, mig-anak te lalimma ne lupi ka seleppi ne imbehey nu keddi.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ne migkahi ka ahalen diye te kandin, ‘Puun due, egbehayan ku sikeykew te katenged ne egmandu te lalimma ne siyudad.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Migginguma degma ka igkatelu ne suluhuanen wey migkahi, ‘Ahalen, seini red ka seleppi nu ne imbehey nu keddi. Imbugsung ku seini te manggad, ");
INSERT INTO mbtNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","su naaldek a keykew puun su mabulut ka amana. Egkuwa ka te kene ne keykew wey eggaani ka te ware nu ibubul.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ne migkahi ka ahalen diye te kandin, ‘Mareet ka ne suluhuanen! Iyan ku red iggukum keykew ke nekey ka inlalag nu. Nakanengneng ke bes te mabulut a wey migkuwa a te kene ne keddi wey miggaani a te ware ku ipamula. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, mani naa te ware nu itahu diye te bangku ka seleppi ku eyew te peg-uli ku egkaangey ku red seini duma te anak kayi? ");
INSERT INTO mbtNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne migkahiyan din ka me etew ne nanasindeg diye, ‘Kua niyu ka seleppi due te kandin wey ibehey niyu diye te nakaseleppi te sapulu ne lupi.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Piru migkahiyan dan sikandin, ‘Ahalen, duen man-e seleppi din ne sapulu!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ne migtabak sikandin, ‘Egnangenan ku sikaniyu te seeye se due kandin, egtimulan pad. Piru seeye se ware kandin, eg-angayen minsan ka deisek ubag ne in-isip din ne kandin perem. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Piru meyitenged te me kuntere ku ne kene egkeupian ne eghari a kandan, uyana niyu sikandan wey pangimatayi niyu kayi te tangkaan ku!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Te nekeimpus e si Hisus ka migpangguhud, migpabulus sikandin migpatakereg peendiye te Hirusalim, wey miggun-a sikandin kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te egpalinggumaan sikandan te inged ne Bitpahi wey te Bitanya ne diye te Bubungan te Ulibu, impewun-e e ni Hisus ka daruwa te me hibateen din ");
INSERT INTO mbtNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wey migpanagtahaan din, “Hendiye kew seeye te kewun-aan ne bariyu. Te egpekeuma kew e, due egkakita niyu ne nati te asnu ne inniket ne ware pad neunturi te minsan hentew. Hekari niyu naa seeye wey uyana niyu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne emun ke due eg-inse kaniyu, ‘Mania te eggekaran niyu sika?’ kahii niyu re, ‘Ingkeilangan seini te Magbebaye!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sikan naa, nangipanew e ka insuhu wey natuman iya ka langun ne innangen ni Hisus kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te egkalihet pad sikandan ne eggekad te nati te asnu, mig-insaan sikandan te kamuney, “Hey, mania te eggekaran niyu sika?” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ne migtabak sikandan, “Ingkeilangan seini te Magbebaye.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne in-uyan dan e seeye diye te ki Hisus, wey innagpiyan dan te me kumbale dan, wey impeuntud e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te mig-untud e si Hisus, imbelatan te me etew te me kumbale dan ka dalan ne egbayaan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te egpatupang e sikandin te Bubungan te Ulibu ne marani e te Hirusalim, nahale-gale ka langun ne hibateen din wey migdayan te Manama ne migmanguleyi tenged te langun ne me kein-inuwan ne nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Migkahi sikandan, “Egdayanen ka Hari ne impeendini te Magbebaye ne Manama kanta! Keupianan diye te langit wey egdayanen ka Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Due me Parisiyu ne nakasewug diye te masulug ne me etew ne migkahi, “Talagpanulu, sapari nu ka me hibateen nu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne migtabak si Hisus diye te kandan, “Egnangenan ku sikaniyu ne meyi egpeeneng-eneng sikandan, iyan e mule egbalbalukan ka me batu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Te egpalinggumaan e si Hisus te Hirusalim wey te nakita rin e seini, migsinehew e sikandin ");
INSERT INTO mbtNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ne migkahi, “Me matig-Hirusalim, meupiya pad perem ke nanengnengan niyud kuntee ke nekey ka egpakabehey kaniyu te keupianan! Piru, ware pad napuwasan ka isip niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Egginguma ka aldew keureme ne egbalabahan kew wey eglingutan te me kuntere niyu, wey eg-as-aseken kew nikandan te eglusud. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Egguhusen dan ka siyudad niyu wey egguleen kew nikandan. Ne warad iya minsan sabeka naan de ne batu ne egkasame diye te neunturan kayi, su ware niyu ilaa ka timpu te pegluwas perem te Manama kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pegginguma ran diye te Hirusalim, migseled si Hisus te timplu wey impandeldel rin ka egmanitinda ");
INSERT INTO mbtNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wey migkahiyan sikandan, “Nasulat e diye te Kasulatan, ‘Ka baley ku egngaranan te baley ne ampuanan’, piru innimu niyud e seini ne helesanan te me takawen!” ");
INSERT INTO mbtNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tagse aldew migpanulu si Hisus diye te timplu. Ka me pangulu te me talagpanubad, ka me talagpanulu te Balaud te Manama, wey ka me pangulu te me etew, migpammitew te paahi te peggimatey kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piru kene sikandan egpakasellat te eggimuwen dan, su ka langun ne me etew, amana ne neupian ne egpammineg te inlalag ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sabeka ne aldew taheed te migpanulu si Hisus te me etew wey migwali te Meupiya ne Panugtulen diye te timplu, migparani kandin ka me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama wey ka me igbuyag te me Hudiyu ");
INSERT INTO mbtNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wey migkahi, “Nangeni key ke nekey ka katenged nu te peggimu kayi? Hentew-a ka migbehey keykew te katenged te peggimu kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ne migtabak si Hisus kandan, “Due degma inse ku kaniyu. Nangeni a ");
INSERT INTO mbtNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ke hendei migpuun ka katenged ni Huwan te pegpamewutismu? Diye naa te Manama wey ke diye te me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne migpalalahey sikandan ne migkahi, “Emun ke egkahi ki, ‘Diye migpuun te Manama’, kema ke egkahiyan ki nikandin, ‘Na, mania te ware kew migpalintutuu ki Huwan?’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piru ke egkahi ki, ‘Diye migpuun te me etew’, ne egbatuwen ki te me etew su migpalintutuu iya sikandan ne prupita si Huwan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Purisu migtabak sikandan ki Hisus, “Ware key nakanengneng ke hendei migpuun.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne migkahiyan sikandan ni Hisus, “Ke iling ma rue, kene ku degma egnangenan sikaniyu ke nekey ka katenged ku te peggimu kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne migpangguhuran ni Hisus ka me etew te seini ne panunggilingan: “Due sabeka ne etew ne migpamula te me prutas ne egngaranan te paras wey migpatanggu rin e te me talagbasuk. Ne miglapu e sikandin diye te mariyu ne inged te naluhey ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te pegginguma te timpu te pegpamupu te me behas, migsuhu sikandin te sabeka ne uripen din eyew egpakuen te baad din te prutas diye te me talagtanggu. Piru inlelampesan te me talangtanggu ka uripen wey impeuli dan ne ware inuyanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ne migsuhu e man-e ka kamuney te lein ne uripen, piru inlelampesan ded te me talagtanggu wey impeyilawan dan, wey impeuli ne ware inuyanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ne migsuhu man-e sikandin te igkatelu ne uripen din. Inggumian ka uripen wey inggehanuy diye te lihawangan te parasan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Migkahi e ka kamuney te parasan, ‘Nekey buwad ka eggimuwen ku? E uya, igpeendiye ku ka pinalangge ku ne anak ne lukes, su kema ke egtahuren dan sikandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piru te pegkakita te me talagtanggu te anak din, migpalalahey e sikandan, ‘Sikan e ka anak te kamuney te parasan ne iyan egpakakamuney kayi. Eggimatayan ta sikandin eyew sikante e ka egpakakamuney kayi.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne inggehanuy ran e sikandin diye te lihawangan te parasan wey inggimatayan dan e.” Mig-inse si Hisus, “Nekey naa ka eggimuwen te kamuney te parasan diye te me talagtanggu? ");
INSERT INTO mbtNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eggendiyaan din ka me talagtanggu wey egpangimatayan din sikandan, wey egpasubalan din ka parasan te duma.” Te pegkarineg dutu te me etew, migkahi sikandan, “Suwang-suwang!” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Piru migtengtengan ni Hisus sikandan wey migkahi, “Nekey naa ka kaluwasan te seini ne insulat: ‘Ka batu ne insamsamilian te me talagbebaley, nasi neyimu ne batu ne pabunsuran.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ka langun ne egkeulug ne egdeeg te seeye ne batu, egkallepuan, piru ka egkeuluhan te seeye ne batu, egkallupet iya.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Te seeye ne timpu, egdakepen e perem si Hisus te me talagpanulu te Balaud te Manama wey te me pangulu te me talagpanubad, su nasabut dan ne sikandan ka innisuhat din te panunggilingan. Piru naaldek sikandan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Seeye naa, migtantanuran naan de sikandin wey impeendiyaan te me etew ne egpeiipaten. Egpeuubaten sikandan ne meupiya se tuyu dan wey egpepammitawen te seyyup te impanlalag din, su eyew igkasumbung dan sikandin diye te gubirnadur wey egpewukuman. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ne mig-inse ki Hisus seeye se me talag-iipat, “Talagpanulu, nakanengneng key ne malehet ka ingkahi nu wey impanulu. Nakanengneng key ne ware impalapihan nu, ke kene, impanulu nu ka kamalehetan meyitenged te igkeupii te Manama te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, nangeni key ke supak naa te Balaud ta ka pegbayad te buhis diye ki Sisar ne Impiradur, wey se kene?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piru natahaan ni Hisus ne egsahiluten de sikandin, sikan naa ka migkahiyan din sikandan, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Papitawa a nikaniyu te seleppi. Hentew ne alung wey ngaran ka nakatahu kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Migtabak sikandan, “Ki Sisar ne Impiradur.” Ne migkahi si Hisus, “Ke iling due, ibehey niyu diye te Impiradur ka kandin, wey ibehey niyu degma diye te Manama ka kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne ware iya sikandan nakasahilut kandin diye te tangkaan te me etew. Ne migpeeneng-eneng naan de sikandan, su neinu-inu sikandan te tabak ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ne due me etew ne me Sadusiyu ne migparani ki Hisus. Sikandan ka migkahi ne kenad egkeuyag ka me minatey. Ne mig-insaan dan si Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Talagpanulu, migsulat si Muwisis kanta te balaud ne emun ke due etew ne egpatey ka kakey rin ne ware pad nakaanak, keilangan ne egpamaluwen din ka ipag din eyew duen ded anak te kakey rin ne migpatey e.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, due pitu ne taltalaari ne neelin ne lukes. Nakaasawa ka panganey wey migpatey ne ware nakaanak. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne impamalu te inggiba ka ipag din, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","wey migpatey red degma ne ware nakaanak. Ne iling ded ka natamanan te igkatelu ne lukes. Naamin ka pitu ne taltalaari ne ware nakaanak. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te katamanan, migpatey e degma ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, te aldew ne eg-uyahen e ka me minatey, hentew naa ka asawa rin ne malehet su naamin ma ka pitu ne nakaasawa kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ne intabak sikandan ni Hisus, “Egmaas-asaweey ka me etew te seini ne timpu, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","piru seeye se in-isip te Manama ne likes ne eg-uyahen wey eg-uyanen diye te langit, kenad e egmaas-asaweey sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kenad sikandan egpatey su egpekeiling e sikandan te me panalihan te Manama. Me anak e sikandan te Manama su in-uyag e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, meyitenged te pegkeuyag te me minatey, minsan si Muwisis migpamalehet kayi. Migsulat sikandin meyitenged te nalegleg ne sapinit ke hendei migkahi ka Magbebaye ne Manama ne sikandin ‘ka Manama ni Abraham, ka Manama ni Isaak, wey ka Manama ni Hakub.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iyan igpasabut kayi ne kene ne Manama sikandin te me minatey, ke kene, Manama te neneuyag. Su ka langun ne etew manekal red diye te kandin ne isip.” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Due me talagpanulu te Balaud te Manama ne migkahi, “Meupiya ka tabak nu, Talagpanulu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne warad e egpaalag-alag ne eg-inse-inse kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ne migkahiyan sikandan ni Hisus, “Mania te migkahi sikandan ne ka Kristu kabuhalan kun ni Dabid? ");
INSERT INTO mbtNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Su minsan si Dabid, migsulat sikandin diye te Libru te me Salmu, ‘Ka Manama migkahi diye te Magbebaye ku: Pinnuu ka kayi te igkakawanan ku, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","taman te eggimuwen ku ne diekanan nu ka me kuntere nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Purisu ke ingngaranan ni Dabid ka Kristu ne ‘Magbebaye’, egmenuwen naa te Kristu ne egkeyimu ne kabuhalan ni Dabid?” ");
INSERT INTO mbtNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Taheed te migpammineg ka langun ne etew ki Hisus, migkahiyan din ka me hibateen din, ");
INSERT INTO mbtNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bantey kew te me talagpanulu te Balaud te Manama, su egkeupian sikandan ne egleug-leug ne egkukumbale te mallayat. Ne egkeupian sikandan ne egtahuren te me etew diye te me palingkiyan wey eg-alam te me mateles ne pinnuuwan diye te me simbaan te me Hudiyu wey te pinnuuwan te me talahuren diye te sahakeenan. ");
INSERT INTO mbtNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Inlupihan dan ka me balu wey impangahew ran ka me kasangkapan dan minsan ka me baley ran, wey mallayat sikandan ne eg-ampu ka egpapitew-pitew re. Sikan naa ka subla pad ne masumpit ka legpad ne egkeumaan dan!” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Taheed te egpipitew si Hisus, nakita rin ka me meyaman ne mig-ulug te me seleppi dan diye te tahuanan diye te timplu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne due degma nakita rin ne balu ne egkaayu-ayu ne mig-ulug te daddaruwa ne keddeku. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ne migkahi si Hisus, “Egnangenan ku sikaniyu te malehet: sika se balu ne egkaayu-ayu, subla pad ne dakel ka in-ulug din du te langun ne mig-ulug. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Su ka duma migbehey te subla naan de te seleppi dan, piru ka balu ne egkaayu-ayu, imbehey rin ka langun diye te kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Due me etew diye ne migpalalahey meyitenged te timplu ke mamenu keupiya ne egtengtengan ne migdayan-dayanan te mateles ne me batu wey me kasangkapan ne indasag te me etew diye te Manama. Ne migkahi si Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Egginguma ka timpu keureme ne seini se langun ne nakita niyu, ware minsan sabeka ne batu ne egkasame diye te neunturan din, egkahebe iya ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ne mig-inse sikandan, “Talagpanulu, ken-u seini egkeyitabu? Nekey-a ka palinneu ke mahaan e seini egkeyitabu?” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ne migtabak si Hisus, “Bantey kew ne kene kew egkeuyan te kene ne malehet ne talagpanulu su masulug ka eggendini ne egpeila ne sikandan kun ka Kristu, wey egkahi ne miggingume e ka timpu. Piru kene kew ikul kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kene kew kaaldek ke egpakarineg kew te egmabunbunuey wey egkengasamuk, su keilangan ne egkeyitabu pad sika hun-a, piru ware sika migpasabut ne mahaan e ka katammanan te inged.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Migpabulus sikandin ne migkahi diye te kandan, “Egpakigkuntere ka sabeka ne nasud te lein ne nasud wey egpakigkuntere ka sabeka ne tribu te lein ne tribu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Egginguma ka mangune-kune ne me linug, bitil, wey me dalu ne kene egkabawian diye te minsan hendei ne inged. Ne due man-e makaalat-halat wey kein-inuwan ne me palinneu puun diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Piru te kene pad egkeyitabu sika, egpandakepen kew, egbaybayaran, egprisuwen, wey eg-uyanen kew diye te simbaan te me Hudiyu eyew eggukuman. Ne egpaatubangen kew diye te me Hari wey te me gubirnadur tenged keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ne sikan en iya ka timpu ne egpakapangguhud kew kandan te Meupiya ne Panugtulen. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sikan naa, tapey niyud sabekaa ka suman-suman niyu ne kene egkalaggew ke egmenuwen niyu te egpanabak, ");
INSERT INTO mbtNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","su egpanuluen ku sikaniyu te iglalag niyu wey egbehayan kew te kaalam eyew kene egpakatabak wey ke egpakaapul ka me kuntere niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Igsumbung kew minsan te me amey wey iney niyu, wey te me hari wey me kakey niyu, wey te me suled wey me alukuy niyu. Ne ka duma kaniyu, eggimatayan dan iya. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Egdumutan kew te langun ne etew tenged keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piru kene kew egbalaharen te Manama su minsan sabeka ne bulbul te ulu niyu kene egkatarin. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ne pinaahi te peg-antus niyu, egpakarawat kew te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ke egkakita niyu ka Hirusalim ne eglikesan te me sundalu, egkanengnengan niyu ne egdereetan e seini te kene egkaluhey. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ne seeye se me etew ne diye te Hudiya, keilangan ne eg-aput diye te me bubungan, wey seeye se diye te siyudad keilangan ne eg-awe diye. Ne seeye se diye te me unayan, keilangan ne kene eggendiye te siyudad ");
INSERT INTO mbtNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","su seeye ne me timpu igpaneem-neem te Manama ka langet din eyew egkatuman ka langun ne nasulat diye te Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mekeyid-u-hid-u te seeye ne me timpu ka egkengaberes wey ka egmasusu pad te me anak dan. Su eggingume e ka masumpit ne peg-antus te seini ne inged wey egkaneem-neem te seini ne keet-etawan ka langet te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Egpangimatayan sikandan pinaahi te kampilan, wey egpanguripenen sikandan diye te langun ne inged. Ne seini se Hirusalim, eg-ahawen te kene ne me Hudiyu wey egmanduan dan taman te egkapenge e ka ingkerew te Manama kandan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Due keureme me palinneu diye te aldew, bulan wey me bituen. Ne ka me etew te langun ne nasud, egkabantalan wey egkabenga-benga te lehes te dakel ne me bunlud te dahat. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Egkengalepu ka me etew te kaaldek dan ka egkapanseb ke nekey ka egkeyitabu kayi te ampew te tane. Su egkawelwel ka me tahu diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ne egkataman, egkakita ran e ka Anak te Etew ne eglepew diye te gapun duma te geem din wey dakel ne katelesan. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ke egbunsud e seini egkeyitabu, nekal-nekal kew wey leng-ag kew su mahaan e ka kaluwasan niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne migpangguhuran sikandan ni Hisus te seini ne panunggilingan, “Na, pitawa niyu ka kayu ne iggira wey ka duma ne me kayu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Emun ke egkakita niyud ne egderewun e, egkatahaan niyu ne mahaan e ka tingmeinit. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iling naan ded degma due, emun egkakita niyud ne egkeyitabu e seini, egkatahaan niyud ne mahaan e ka Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Egnangenan ku sikaniyu te malehet: egkatuman e sika langun te kene pad egkengamatey ka me etew te kuntee ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Egkaawe ka langit wey ka tane piru ka keddi ne lalag, kene iya egkaawe. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sikan naa, tanud-tanud kew ne kene egparuyun-duyun te egkasublaan ne pegdees wey pegpewubug-hubug, wey te pegkalaggew meyitenged te peg-ugpe niyu, su kema ke egkatigkew kew te seeye ne aldew wey egpekeiling kew te nabaled. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Su egtigkew seini egginguma te langun ne etew ne mig-ugpe kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Purisu tanud-tanud kew layun wey ampu kew eyew egmanekal kew ne eg-antus te langun ne egkeyitabu, wey eyew egpakaatubang kew te Anak te Etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tagse aldew, egpanulu si Hisus diye te timplu, piru te pegkamarusilem eg-awe sikandin wey diye eggirehe te Bubungan te Ulibu. ");
INSERT INTO mbtNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te maselem-selem, eggendiyaan sikandin te me etew diye te timplu eyew egpammineg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Te seeye ne timpu, mahaan e ka Sahakeen te Paan ne Ware Patulin ne migngaranan man-e te Sahakeen te Peglihad te Panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ne ka me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama, migpammitew sikandan te paahi ke egmenuwen ne egkeyimatayan dan si Hisus, su naaldek sikandan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nataman, migserepan ni Meibulan si Hudas ne egngaranan ki Iskaryuti ne sabeka te sapulu wey daruwa (12) ne hibateen ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne miggipanew sikandin wey migpakigkita te pangulu te me talagpanubad wey te me pangulu te talagbantey te timplu. Migpasabutey sikandan ke egmenuwen din te pegbehey ki Hisus diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Amana sikandan nahale wey migsaaran dan sikandin ne egbehayan te seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ne mig-uyun si Hudas wey migpamuhawang ne egpasayuwan din eg-akali si Hisus ke ware ka masulug ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ne miggingume e ka aldew te Sahakeen te Paan ne Ware Patulin ne iyan pegpanubad te nati ne karniru eyew egkeenen te Sahakeen. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ne migkahiyan ni Hisus si Pidru wey si Huwan, “Hipanew kew wey andama niyu ka iglabung ta te Peglihad te Panalihan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne mig-insaan dan si Hisus, “Hendei nu igkeupii ne eg-andamen ney seini?” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne migkahiyan din sikandan, “Pammineg kew. Te egginguma kew e diye te siyudad, due etew ne egkasinug-ung niyu ne egtiang te banga ka migpanakeru. Sinundula niyu naa sikandin wey lasud kew diye te baley ne eglasuran din, ");
INSERT INTO mbtNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","wey kahii niyu ka mahinged, ‘Eg-inse ka talagpanulu keykew: Hendei ka sinabeng ne egkeenan ku duma te me hibateen ku te Peglihad te Panalihan?’ ");
INSERT INTO mbtNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne igpakita rin kaniyu ka maluag ne sinabeng diye te dibabew ne kumplitu te me kasangkapan, wey dutun kew naa andam te iglabung ta.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nataman, miggipanew ka daruwa wey nakita ran ka langun ne sumale te inlalag ni Hisus kandan. Seeye naa, in-andam dan e ka egkeenen para te Sahakeen te Peglihad te Panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ne hengkayi te tinglabung e, migpinnuu si Hisus duma te me apustulis din eyew egkeen e. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne migkahiyan din sikandan, “Amana ad iya egkeupian ne eglagpu kaniyu egsahakeen te Peglihad te Panalihan te kene e pad eg-antus! ");
INSERT INTO mbtNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Su egnangenan ku sikaniyu te kena ad eg-abey egkeen kayi taman te egkatuman e ka malehet ne kaluwasan te seini ne Sahakeen diye te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne migkuwa si Hisus te senge ubab ne binu wey migpasalamatan din ka Manama, wey migkahi diye te me hibateen din, “Kua niyu seini wey pasamsameey kew. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Su egnangenan ku sikaniyu ne ligkat kuntee kena ad e eg-abey eg-inum te seini ne inumen ne egpuun te paras taman te eggingume e ka Peghari te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne migkuwa sikandin te paan wey migpasalamatan din ka Manama, wey impanepik-tepik din seini wey impamehey rin diye te me hibateen din te migkahi, “Seini ka lawa ku ne imbehey kaniyu. Himuwa niyu seini eyew te pegsuman-suman keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pegkapenga dutu, migkuwe e man-e sikandin te ubab wey migkahi, “Seini se senge ubab ne inumen, iyan ka langesa ku ne igpatihis para kaniyu wey iyan egpamalehet te iyam ne kasabutan te Manama diye te keet-etawan din. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Piru pammineg kew. Duma ta kuntee kayi te migkeen ka etew ne eg-akal keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Egpatey ka Anak te Etew sumale te intahahaan iya kandin, piru mekeyid-u-hid-u ka etew ne eg-akal kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ne dutu, migpein-inseey sikandan ke hentew buwa kandan ka eg-akal kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne migpaap-apuley ka me hibateen ni Hisus ke hentew dapit kandan ka labew. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sikan naa, migkahiyan sikandan ni Hisus, “Ka me Hari te kene ne Hudiyu, impeuteng dan iya ka geem dan diye te me sakup dan, wey egkeupian sikandan se me pangulu ne egngaranan te ‘egsandihan te me etew.’ ");
INSERT INTO mbtNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piru kene niyu sika himuwa. Ka minsan hentew kaniyu ne iyan mabantug, keilangan ne eg-iling te kinaariyan, wey ka pangulu keilangan ne egpeyimu ne suluhuanen. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hentew ma ka labew, seeye se migsendaran wey ke seeye migsendad? Seeye iya se insendaran. Piru seini a kuntee duma kaniyu ne migtanggu kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mig-unung kew keddiey te me peg-eleg-eleg ne nabayaan ku. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sikan naa, eggimuwen ku degma diye te kaniyu ka innimu te Amey ku kayi te keddi. Egbehayan ku sikaniyu te katenged te peghari, ");
INSERT INTO mbtNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","eyew egpakalagpu kew egkeen wey eg-inum diye te keddi ne lamisa diye te egharian ku. Ne eyew egpakapinnuu kew man-e diye te me trunu eyew te peggukum te sapulu wey daruwa (12) ne tribu te Israil.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ne migkahiyan ni Hisus si Simun, “He Simun, pammineg ka! Bantey ka su migtuhutan si Meibulan te peggeram kaniyu langun ne iling te etew ne egpalayap te trigu. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piru mig-ampuan ku sikeykew Simun, eyew kene egkaawe ka pegpalintutuu nu. Ne emun ke eglibed kad man-e egpalintutuu keddiey, keilangan ne eggeheten nu ka pegpalintutuu te me suled nu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Migtabak si Pidru, “Magbebaye, andam ad e ne eg-unung keykew minsan egprisuwen wey eggimatayan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ne migtabak si Hisus, “Egnangenan ku sikeykew Pidru, te kene pad eg-ukale ka manuk kuntee ne marusilem, katatelu ad nikeykew igpahunware.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne migkahiyan sikandan ni Hisus, “Nakulangan kew naa te impeendiye ku sikaniyu dengan ne ware in-uyan ne me sening, puntil, wey sandal?” Ne migtabak sikandan, “Ware.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ne migkahi si Hisus, “Piru kuntee, seeye se due sening wey puntil, keilangan ne eg-uyanen din. Seeye se ware kampilan, keilangan ne igbelegye din ka binekad din wey egbeli te kampilan. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Su egnangenan ku sikaniyu ne keilangan egkatuman ka diye te Kasulatan meyitenged keddiey ne eggenendue, ‘In-isip sikandin ne sabeka ne mareet ne etew.’ Ne kuntee, egkatuman en iya ka nasulat meyitenged keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Migkahi ka me hibateen din, “Tew ka, Magbebaye. Duen e daruwa ne kampilan kayi.” Ne migtabak si Hisus, “Eleg e sika!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ne mig-awe e si Hisus wey miggendiyad te Bubungan te Ulibu iling te nabatasan din. Ne migduma kandin ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te pegginguma ran diye, migkahi si Hisus, “Ampu kew eyew kene kew egkatintal.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne migpariyu sikandin kandan te eleg de ne egkeumaan te egdegpak, wey migpanimbuel sikandin eyew eg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ne migkahi sikandin, “Ame, ke egtuhut ka, kene nud ipabulus ka igpaantus nu keddi, piru kene ne iyan egkatuman ka keddiey ne pegbuut, ke kene, ka keykew ne pegbuut.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ne due panalihan te Manama ne egpuun diye te langit ne miglepew eyew te pegbehey kandin te kanekal. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne puun su amana ne masakit ka geyinawa rin, nanasnasian pad iya ne migmapahetpet ka peg-ampu din, wey miglimusengan sikandin iling te langesa ne migtihis diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te nakapenge e sikandin ka mig-ampu, miglibed e sikandin diye te me hibateen din wey neumaan din sikandan ne nenewulep e su migmahuye puun te subla ne peglungku. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne ingkahiyan sikandan ni Hisus, “Mania te miglipereng kew? Enew kew wey ampu kew eyew kene kew egkatintal.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Te sasangan pad ne eglalag si Hisus, nangingume e ka masulug ne me etew ne induma ni Hudas ne sabeka te sapulu wey daruwa (12) ne hibateen din. Miggun-a sikandin kandan wey migparani ki Hisus eyew eggarek kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Piru migkahi si Hisus, “Hudas, eg-akalan nu bes ka Anak te Etew pinaahi te harek?” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te pegkakita te me duma ni Hisus ne egsahap e sikandin, migkahi sikandan, “Magbebaye, igpanibas ney naan e seini se me kampilan ney?” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne due sabeka kandan dutu ne intibbas din ka uripen te Labew ne Talagpanubad, wey natamped ka igkakawanan ne talinga te uripen. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Piru migkahi si Hisus, “Eleg e sika!” Ne insamsam ni Hisus ka talinga te uripen wey neulian e. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nataman, migkahiyan ni Hisus ka me pangulu te me talagpanubad, ka me pangulu te talagbantey te timplu, wey ka me igbuyag te me Hudiyu ne migduma te pegdakep kandin, “Takawen a? Mania te nanguyan kew te me kampilan wey me lampes ka egdakep keddiey? ");
INSERT INTO mbtNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tagse aldew duma a kaniyu diye te timplu, ne wara a nikaniyu derakepa. Piru seinid iya ka timpu ne imbehey kaniyu, ka timpu ne due katenged ni Meibulan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ne indakep dan si Hisus wey in-uyan dan diye te baley te Labew ne Talagpanubad. Ne migsundul degma si Pidru ne migpadpariyu de. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ne migtetemeg ka me etew diye te taliware te lama wey naminnuu sikandan ka egginarang. Ne migdugpu degma si Pidru kandan wey migpinnuu. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Due suluhuanen ne malitan ne nakakita ki Pidru te migpinnuu diye te lenged te hapuy. Immemetmetan din si Pidru wey migkahi, “Sika ne etew, duma degma nikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piru migpahunware si Pidru ne migkahi, “Beyi, ware e ma mule nekeila kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te ware naluhey, duen e man-e lukes ne nakakita kandin wey migkahi, “Hey, duma ka iya degma nikandan!” Piru migtabak si Pidru, “Usi, kena a ne duma nikandan!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Me sabeka ne uras ka miglihad, duen e man-e lein ne lukes ne migkahi, “Malehet iya ne duma rin ka seini ne etew su matig-Galiliya ma degma sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piru migtabak si Pidru, “Ti! Wara a nakanengneng te impanlalag nu!” Te sasangan pad sikandin ne eglalag, due-rue ne mig-ukale ka manuk. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Miglilingey ka Magbebaye wey migtengteng diye te ki Pidru, wey nasuman-suman din ke nekey ka inlalag te Magbebaye kandin, “Te kene pad eg-ukale ka manuk kuntee ne marusilem, katatelu ad nikeykew igpahunware.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Te sikan de, miglihawang e si Pidru wey migpanaman-taman migsinehew. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ne imbaley-baley wey inlampesan si Hisus te me etew ne migbantey kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Imbagkesan dan ka mata rin wey mig-insaan, “Ne la, antuki nu ke hentew-a ka migpasakit keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne masulug pad ka impanlalag dan te pegbaley-baley kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te pegkapawe e, miglibulung ka me igbuyag te me Hudiyu ne iyan ka me pangulu te me talagpanubad, wey me talagpanulu te Balaud te Manama. Ne in-uyan dan e si Hisus diye te tangkaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ne migkahi sikandan, “Nangeni key ke sikeykew naa ka Kristu.” Ne migtabak si Hisus, “Ke egnangenan ku sikaniyu, kene kew egpalintutuu keddiey, ");
INSERT INTO mbtNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","wey ke eg-insaan ku sikaniyu, kene kew egtabak. ");
INSERT INTO mbtNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piru puun kuntee, ka Anak te Etew egpinnuu diye te igkakawanan te maresen ne Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne mig-inse sikandan langun, “Sikeykew naa iya ka Anak te Manama?” Ne migtabak sikandin, “Malehet iya ka ingkahi niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne dutu migkahi sikandan, “Mania te egkeilangan ki pad ne egkuwa te egpamalehet? Sikante en iya ka nakarineg te inlalag din.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nataman, migsasindeg sikandan langun wey in-uyan dan si Hisus diye te tangkaan ni Pilatu ");
INSERT INTO mbtNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","wey insumbung dan sikandin. Ne migkahi sikandan, “Nasapenan ney seini ne etew ne inlaag din ka me etew wey mignangenan din sikandan ne kene egpabayaren te buhis diye te Impiradur. Migkahi rin pad man-e te sikandin kun ka Kristu, ka sabeka ne Hari.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne mig-insaan sikandin ni Pilatu, “Sikeykew iya ka Hari te me Hudiyu?” Migtabak si Hisus, “Ingkahi nud en iya.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nataman, migkahiyan ni Pilatu seeye se me pangulu te me talagpanubad wey ka masulug ne etew, “Ware nakita ku ne sale te seini ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piru migpanaman-taman sikandan mig-apul ne migkahi, “Sikandin ka puunan te samuk te me etew diye te intiru ne Hudiya tenged te kandin ne pegpanulu. Diye sikandin migbunsud te Galiliya taman te miggingume e kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Te pegkarineg dutu ni Pilatu, mig-inse sikandin ke matig-Galiliya naa si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te natahaan din e ne diye migligkat si Hisus te inged ne immanduan ni Hirudis, impeendiye din e sikandin ki Hirudis, su diye degma si Hirudis te Hirusalim te seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ne nahale amana si Hirudis te nakita rin si Hisus su nakarineg ma sikandin meyitenged kandin, wey naluhey e ne eg-iman-iman ne egpakakita te kein-inuwan ne eggimuwen ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne mig-in-insaan ni Hirudis si Hisus, piru ware sikandin migtabak. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nanasindeg degma diye ka me pangulu te me talagpanubad wey ka me talagpanulu te Balaud te Manama wey egbebayungan dan patamtami si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ne indeeg-deeg sikandin wey imbaley-baley ni Hirudis duma te me sundalu rin. Insaluuban dan sikandin te mateles ne kumbale wey impalibed dan diye te ki Pilatu. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Seeye ne aldawa nekeg-alukuy e si Hirudis wey si Pilatu, su dengan talagkuntere ma sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nataman, impeumew ni Pilatu ka me pangulu te me talagpanubad, ka me igbuyag te me Hudiyu, wey ka me etew, ");
INSERT INTO mbtNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ne inlalahan din sikandan, “In-uyan niyu seini ne etew kayi te keddiey wey migkahi kew ne inlaag din ka me etew. Ne in-insaan ku sikandin diye te tangkaan niyu piru ware nakita ku ne mareet ne neyimu rin sumale te insumbung niyu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ne minsan si Hirudis, ware nakita rin ne sale te seini ne etew, wey impalibed din e kayi te kanta. Ne ware iya neyimu rin ne mareet ne eleg ne eglegparan te kamatayen. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Sikan naa, egpalampesan ku re seini ne egkataman eglekaan ded.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piru migmanguleyi ka masulug ne me etew, “Himatayi nu sikandin! Si Barabas ka lekei nu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Naprisu si Barabas su migribildi diye te Hirusalim wey nakapatey te etew.) ");
INSERT INTO mbtNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Iyan igkeupii ni Pilatu ne eglekaan si Hisus, sikan naa ka miglalahan din abayi ka me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piru migtabak sikandan ne migbalbalukan, “Ilansang nu sikandin te krus! Ilansang nu sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne igkatatelu e ni Pilatu te egkahi kandan, “Mania, nekey bes ka neyimu rin ne mareet? Ware sale ne nakita ku ne eleg sikandin eglegparan te kamatayen. Egpalampesan ku re sikandin wey egpalekaan e.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piru migpabulus sikandan ne migpanguleyi ne migkahi, “Ilansang nu sikandin te krus!” Ne iyan tamani se nahambaan sikandin te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ne mig-uyun si Pilatu te igkeupii te me etew, ");
INSERT INTO mbtNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","wey impalekaan din e ka imbuyu dan ne naprisu tenged su migribildi te gubirnu wey nakapatey te etew. Piru imbehey rin mule si Hisus diye te kandan eyew egkeyimu ran kandin ka langun ne igkeupii ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Te in-uyan dan e si Hisus, due nasinug-ung dan ne matig-Sirini ne egngaranan ki Simun ne diye egpuun te sityu wey eggendiye te siyudad. Indakep dan sikandin wey impatiang te krus ne impasinundul ran ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Masulug amana ne etew ka migsinundul ki Hisus wey due me malitan ne migmandalawit wey migmalumbibigtew tenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nataman, miglilingey si Hisus diye te me malitan ne migkahi, “Sikaniyu se matig-Hirusalim ne me malitan, kena a nikaniyu sinehawi. Iyan niyu sinehawi ka pegkeetew niyu wey ka me anak niyu. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Su egginguma ka aldew ne egkahi ka me etew, ‘Keupianan te seeye se me malitan ne ware mig-anak wey ware migpangalalin wey ware impasusu ne bate!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te sika ne timpu egkahi ka me etew diye te me bubungan, ‘Kengalunew kew kayi te kanami!’ wey egkahi degma diye te me labuntud, ‘Bunbuni key!’ ");
INSERT INTO mbtNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Emun ke innimu ran seini diye te etew ne ware sale, wey naan pa iya kene ne subla ne mareet ka eggimuwen dan diye te due sale.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Duen pad man-e daruwa ne mareet ne me etew ne in-uyan dan eyew eggimatayan duma ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te nekeume e sikandan diye te inged ne egngaranan te Angkal, inlansang dan e si Hisus wey ka mareet ne me etew, ka sabeka diye te igkakawanan din wey ka sabeka diye te igkahibang din. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ne migkahi si Hisus, “Ame, pasayluwa nu sikandan su ware dan nakanengneng ke nekey ka eggimuwen dan.” Nataman, migpintut-pintut sikandan ke hentew kandan ka egpakakamuney te me kumbale ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nanasindeg ka me etew ne migtengteng, taheed te migdali-di ki Hisus ka me igbuyag te me Hudiyu ne migkahi, “Inluwas din ka duma, igpaluwas degma kandin ka pegkeetew rin ke malehet ne sikandin ka Kristu ne in-alam te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Migdali-dian man-e sikandin te me sundalu, wey migparani sikandan wey intaruwayan sikandin te maperes ne binu. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne migkahi sikandan, “Ke sikeykew ka Hari te me Hudiyu, luwasa nu ka pegkeetew nu!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne seini ka insulat diye te keretula te krus, “Seini ka Hari te me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ka sabeka ne mareet ne etew ne inlansang duma ki Hisus, migbaley-baley degma kandin ne migkahi, “Sikeykew ma iya ka Kristu? Luwasa nu ka pegkeetew nu wey ilagkes key!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piru insaparan sikandin te duma rin ne migkahi, “Ware ke naa naaldek te Manama? Nekeg-iling de ka legpad ta, ");
INSERT INTO mbtNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","piru sikanta se daruwa, likes ki iya ne eglegparan tenged te hinimuwan ta. Piru sikandin, ware mule mareet ne neyimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne migkahiyan din si Hisus, “Hisus, sumsumana a nikeykew te timpu te eghari kad e.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ne migtabak si Hisus, “Egnangenan ku sikeykew te malehet: kuntee ne aldew duma ki diye te ugpaan te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ne hengkayi te meudtu e, mig-engked ka aldew ne miglayag wey migmarusilem ka intiru ne nasud taman te alas tris te maapun; ");
INSERT INTO mbtNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","wey nabindas ka kurtina diye te timplu wey nabaad te daruwa. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ne migpanguleyi si Hisus te meemen ne migkahi, “Ame. Igbehey ku diye te keykew ne me belad ka panisingan ku!” Nataman sikandin se miglalag, nabigtawan e. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te pegkakita te kepitan te me sundalu te neyitabu, indayan din ka Manama te migkahi, “Malehet iya ne matareng seini ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne ka langun ne etew ne miglibulung ne egmamipitew, nakakita te neyitabu wey nanguli sikandan ne migmandabi te me kumeng dan tenged te pegkalaggew ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka langun ne nekeila ki Hisus duma te me malitan ne migsinundul kandin puun te Galiliya, diye de sikandan migsasindeg te madmariyu ne migtengteng te neyitabu ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Due etew ne egngaranan ki Husi ne matig-Arimatiya, sabeka ne lungsud te me Hudiyu. Meupiya sikandin wey matareng ne etew ne egtetahad te Peghari te Manama. Minsan sabeka sikandin ne sakup te Talaggukum te me Hudiyu, piru ware sikandin migparuma-ruma te innimu ran diye te ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Miggendiye sikandin ki Pilatu wey imbuyu din ka lawa ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ne in-angey rin ka lawa ni Hisus diye te krus wey imbukusan din te hinabel wey intahu din diye te inlungahan ne dalama ne ware pad nasabali. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aldew seeye te Pegpangandam su mahaan e egginguma ka Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka me malitan ne migsinundul ki Hisus ligkat te Galiliya, migduma ki Husi wey nakita ran ka insabalan wey ke immenu te egtahu ka lawa ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nataman, mig-uli e sikandan wey in-andam dan e ka me peemut wey ka lana ne igbaluhu te lawa ni Hisus. Seeye ne aldawa, Aldew te Peggimeley sumale te Balaud te me Hudiyu wey miggimeley e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te maselem-selem te aldew te Duminggu, miggendiye ka me malitan te inlungahan ne dalama ne insabalan ki Hisus. Mig-uyan sikandan te peemut ne in-andam dan para te minatey. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pegginguma ran, nakita ran ne nalilid e ka batu ne in-elet dutu te gumawan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne migseled e sikandan, piru ware dan nakita ka lawa ni Hisus ");
INSERT INTO mbtNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","wey amana sikandan ne nalibeg. Ne dutu, due daruwa ne lukes ne miglepew ne nangukumbale te masil-ew wey diye migsasindeg te lenged dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nenaaldek ka me malitan wey nangunduk naan de. Ne migkahi ka daruwa ne lukes, “Mania te kayi niyu egpamitawa te inged te me minatey ka neuyag e? ");
INSERT INTO mbtNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Warad sikandin kayi su neuyag din e. Sumsumana niyu ka inlalag din kaniyu te diye pad sikandin te Galiliya ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Keilangan ne igbehey ka Anak te Etew diye te me makasesale wey iglansang te krus, piru egkeuyag ded sikandin te igkatelu ne aldew.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne nasuman-suman te me malitan ka inlalag ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ne nanguli e sikandan wey impangguhuran dan e te langun ka sapulu wey sabeka (11) ne hibateen ni Hisus wey ka me duma ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ka me malitan ne migpangguhud te me apustulis iyan ensi Mariya Magdalina, si Huwana, si Mariya ne iney ni Santiyagu, wey ka me malitan ne duma ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Piru kahiyen te me hibateen ne ware karuan te guhuren dan, sikan naa ka ware sikandan migpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piru migsasindeg si Pidru wey migpallahuy peendiye te insabalan ki Hisus. Migpepeku sikandin eyew egseilang diye te seled, wey iyan din naan de nakita ka hinabel ne imbukus te minatey. Nataman, mig-uli sikandin ne neinu-inu meyitenged te neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te seeye ded ne aldew, due daruwa ne etew ne miggipanew peendiye te Immaus ne me sapulu wey sabeka (11) ne kilumitru ka kariyu puun te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Taheed te eggipanew sikandan, migpalalahey sikandan meyitenged te langun ne neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te egkalihet sikandan ne egpalalahey, migparani si Hisus kandan wey migluyud kandan te eggipanew. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Piru ware sikandan nekeila kandin su hendue te imbunbunan ka mata ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne migkahiyan sikandan ni Hisus, “Nekey-a ka igkewengete niyu taheed te egmangipanew kew?” Mig-engked sikandan ka eggipanew ne nalanu. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka sabeka ne egngaranan ki Kliyupas mig-inse diye te ki Hisus, “Sikeykew naan de ka mahaliyug diye te Hirusalim ne ware nakanengneng te neyitabu te nanlihad ne me aldew?” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mig-inse si Hisus, “Nekey-a ka neyitabu?” Migtabak sikandan, “Ka meyitenged ki Hisus ne matig-Nasarit. Sabeka sikandin ne maresen ne prupita diye te tangkaan te Manama wey diye te langun ne etew, su due geem te pegpanulu din wey te me himu rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Insumbung sikandin te me pangulu te me talagpanubad ta wey te me igbuyag te me Hudiyu eyew eggukuman te kamatayen, wey inlansang dan e sikandin te krus. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Migpallateng key perem ne sikandin ka eglekat te me kabuhalan ni Israil! Piru natateluwan e mule kuntee seeye se neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ne due duma ney ne me malitan ne nakapeinu-inu kanami. Migselem-selem sikandan miggendiye te migsabalan ki Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","piru ware dan nakita ka lawa ni Hisus diye. Ne miglibed sikandan ne migpangguhud ne nakakita kun sikandan te me panalihan te Manama ne migkahi te neuyag e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne due me duma ney ne miggendiye te insabalan, wey iling ded te ingkahi te me malitan ka nakita ran. Piru ware sikandan nakakita ki Hisus.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne migkahiyan sikandan ni Hisus, “Egkeungel kew iya! Mananey kew egpalintutuu te langun ne inlalag te me prupita! ");
INSERT INTO mbtNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Su keilangan ka Kristu ne eg-antus pad te seini se neneyitabu human sikandin egmabantug.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne impasabut ni Hisus diye te kandan ka langun ne ingkahi te Kasulatan meyitenged kandin, bunsud te sinulat ni Muwisis taman te sinulat te me prupita. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Seeye ne timpu, marani e sikandan te inged ne eggendiyaan dan, ne si Hisus hendue te egpabulus pad, ");
INSERT INTO mbtNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","piru impegpehetan dan sikandin hawiri ne ingkahiyan, “Aran ke pa kayi te kanami su miglineb e ka aldew wey mahaan e egkasagkup.” Nataman, migdume e si Hisus kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te diyad e sikandin te lamisa duma kandan, mig-angey sikandin te paan wey impasalamatan din. Ne impanepik-tepik din e seini wey impamehey rin e diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sahuhune ne iling te napuwasan ka mata ran wey neilaan dan e si Hisus, piru sahuhune ne nalaag sikandin diye te tangkaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne migpanangnangeney sikandan ne migkahi, “Sikan bes iya ka iling te due hapuy ne miglegleg kayi te pusung ta te impasabut din ka Kasulatan te diye ki pad te dalan.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Due-rue ne migsasindeg sikandan wey miglibed diye te Hirusalim. Ne nakita ran diye ka sapulu wey sabeka (11) ne me hibateen wey ka duma pad ne me etew ne nalibulung ");
INSERT INTO mbtNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ne migkahi, “Malehet iya ne neuyag ka Magbebaye! Migpakita sikandin ki Simun!” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne impangguhud degma te daruwa ne etew ka neyitabu diye te dalan, wey ka pegkeila ran te Magbebaye te pegtepik-tepik din e te paan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te sasangan pad sikandan egmalalahey, sahuhune ne miglepew ka Magbebaye wey migsasindeg diye te taliware dan ne migkahi, “Ka keupianan egduma kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Natingkemed sikandan wey nenaaldek, su kahiyan dan ne saping ka nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Piru migkahiyan din sikandan, “Mania te egkalaggew kew? Mania te egduwa-ruwa kew? ");
INSERT INTO mbtNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tengtengi niyu seini se me belad ku wey me paa ku. Sikeddi iya seini. Samsama a wey pitawa a. Ka saping, ware sapu wey ware tul-an piru sikeddiey kuntee ne nakita niyu, due sapu wey due me tul-an.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pegkapenga rin te eglalag, impapitew rin kandan ka belad din wey ka paa rin. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne puun su nahale-gale sikandan wey amana ne neinu-inu, hendue te kene sikandan egpakapalintutuu te nakita ran. Seeye naa, mig-insaan sikandan ni Hisus, “Due egkakeen niyu kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne imbehayan dan sikandin te sabeka ne getad te tinuug te ngalap te weyig. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ingkuwa ni Hisus seeye wey ingkeen din e diye te tangkaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne migkahiyan din sikandan, “Seini ka ingkahi ku kaniyu te dume e pad kaniyu, ne keilangan ne egkatuman ka langun ne nasulat te Balaud ni Muwisis wey te me prupita wey diye te me Salmu meyitenged keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nataman, imbulihan ni Hisus ne egkapuwasan ka me suman-suman dan eyew egpakasabut te Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne migkahiyan din sikandan, “Nasulat diye te Kasulatan ne ka Kristu keilangan ne eg-antus wey egpatey, wey egkeuyag ded sikandin te igkatatelu ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Keilangan ne igpangguhud diye te langun ne nasud, bunsud kayi te Hirusalim, ne tenged kandin, egkapasaylu ka eg-inniyug te me sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ne sikaniyu ka me talagpamalehet te seini se langun. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne igpeuyan ku kaniyu ka insaad te Amey ku. Piru keilangan ne uugpe kew pa diye te Hirusalim taman te egkaleneban kew e te geem ne egpuun diye te langit.” ");
INSERT INTO mbtNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nataman, in-uyan ni Hisus sikandan diye te lihawangan te siyudad taman te Bitanya. Te diyad sikandan, ingkayew rin e ka belad din wey impanalanginan din sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te egkalihet sikandin ne egpanalangin kandan, egkahan-ganaran e degma sikandin egkabatun diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne indayan dan sikandin, wey miglibed e sikandan diye te Hirusalim ne amana nahale-gale. ");
INSERT INTO mbtNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne layun de sikandan diye te timplu eyew te pegpasalamat te Manama.");
INSERT INTO mbtNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Te ware pad neyimu ne minsan nekey, duen e ka egngaranan te Lalag. Ka Lalag duma te Manama, wey iyan iya ka Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Puun te an-anayan, ka Lalag dume e te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Neyimu ka langun pinaahi te Lalag, wey ware minsan sabeka ne neyimu ne kene ne pinaahi kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ne ka Lalag, iyan egpuunan te umul ne iyan miglayag te suman-suman te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nakateng-ew te marusilem ka kalayag, wey ware seini nareeg te marusilem. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, due etew ne insuhu te Manama ne egngaranan ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Migpamalehet sikandin diye te me etew meyitenged te kalayag, su eyew egpakapalintutuu ka langun pinaahi te pegpamalehet din. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ne kene ne si Huwan ka kalayag, piru miggendini sikandin eyew egpamalehet meyitenged kayi. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ne seini se malehet ne kalayag, iyan ka miggendini te kalibutan ne egteng-ew te langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne miggendini sikandin te kalibutan, ne minsan neyimu ka kalibutan pinaahi kandin, piru ware mig-ila kandin ka nangugpe kayi. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Miggendini sikandin te kandin ne inged, piru ka kandin ne keet-etawan ware migdawat kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piru minsan hentew-a ne migdawat wey migpalintutuu kandin, imbehayan din te katenged ne egkeyimu ne anak te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ware sikandan neyimu ne me anak te Manama pinaahi te pegpewulirey te alunggun wey te pegbuut naa te etew, ke kene, pinaahi te pegbuut te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ne ka Lalag, neyimu ne etew wey miglemung mig-ugpe kanta. Amana sikandin ne meupiya wey hiid-uwen, wey malehet ka inlalag din. Nakita ney ka katelesan din, ka katelesan isip sabsabeka ne Anak te Manama ne Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne migpamalehet si Huwan meyitenged kandin, wey migpanguleyi ka migkahi, “Sikandin ka ingkahi ku ne egpakasinundul keddi. Ne labew sikandin keddiey, su duen e sikandin te ware e pad miglesut.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne puun te dakel ne keupiya wey keyid-u rin, ware tamanan te pegpanalangin din kanta. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ka Balaud imbehey te Manama kanta pinaahi ki Muwisis, piru pinaahi ki Hisu Kristu ne migginguma ka keupiya wey keyid-u, wey ka kamalehetan. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ware minsan sabeka ne nakakita te Manama. Piru ka Anak te Manama ne layun duma te Amey rin, sikandin ka migpeila te Manama kanta. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Due me talagpanubad wey me Libita ne insuhu te me pangulu te Hudiyu te Hirusalim ne egpeendiyeen ki Huwan su egpeinseen. Ne migkahi sikandan ka mig-inse, “Hentew kaa?” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne ware miggeeles si Huwan su migpangguhud sikandin te malehet ne migkahi, “Kene ne sikeddi ka Kristu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ne mig-inse e man-e sikandan kandin, “Hentew ke naan iya? Si Ilyas ka?” Ne migtabak si Huwan, “Kena a ne si Ilyas.” Ne mig-inse e man-e sikandan, “Kema ke sikeykew ka Prupita ne egtetaharan ney?” Ne migtabak e man-e si Huwan, “Kene ne sikeddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Seeye naa, migkahi sikandan, “Na, panugtuli key ke hentew kaa, su eyew due igkatabak ney te migsuhu kanami. Nekey-a ka igkalalag nu meyitenged te pegkeetew nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ne migtabak si Huwan, “Sikeddiey ka egkahiyen ni prupita Isayas ne eggenendue: ‘Due egpanguleyi diye te mammara ne inged ne kene egkeugpaan ne egkahi, Tul-ira niyu ka dalan te Magbebaye!’ ” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ne iyan migsuhu te seeye ne me etew ka me Parisiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ne mig-insaan dan e man-e si Huwan, “Ne mania te egpamewutismu ka te kene ke bes ne Kristu wey ke si Ilyas naa, wey ke ka Prupita?” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ne migtabak si Huwan, “Egpamewutismu e re te weyig, piru due duma niyu kayi kuntee ne ware niyu neileyi. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Egpakasinundul sikandin keddiey, piru kena a ne likes ne eggekad te hiket te sandal din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Neyitabu seini diye te Bitanya, diye te deyipag te weyig ne egngaranan te Hurdan ne egpamewutismuwan ni Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te seup ne aldew, nakita ni Huwan si Hisus ne eggendiye te kandin. Ne dutu, migkahi e si Huwan, “Pammineg kew, kayid e ka Nati ne Karniru te Manama ne eg-awe te me sale te me etew kayi te ampew te tane! ");
INSERT INTO mbtNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sikandin ka egkahiyen ku ne egpakasinundul keddiey piru labew keddiey, su duen e sikandin te ware e pad ilesut. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Minsan sikeddi dengan, ware a nekeila ke hentew-a sikandin. Piru miggendini a ka egpamewutismu pinaahi te weyig su eyew egkeila sikandin te me kabuhalan ni Israil. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","“Egpamalehet a ne nakita ku ka Panisingan te Manama ne miglene diye te kandin iling te seleppati puun diye te langit, wey migpalunggehaat seini diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dengan, ware e pad nekeila ke hentew-a sikandin, piru ka Manama ne migsuhu keddi te pegpamewutismu pinaahi te weyig, tapey e migkahi keddi, ‘Ka etew ne egkakita nu ne eglenaan te Panisingan wey egpalunggehaat seini diye te kandin, sikandin naa ka egpamewutismu pinaahi te Panisingan.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne nakita kud en iya sika kuntee, sikan naa ka egpamalehet a te sikandin iya ka Anak te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te seup ne aldew, diyad e man-e si Huwan duma te daruwa ne hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ne nakita ni Huwan si Hisus ka eglihad, wey migkahi sikandin, “Seinid e ka Nati ne Karniru te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne seeye se daruwa ne hibateen din nakarineg te ingkahi rin wey migsinundul e sikandan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Te peglilingey ni Hisus, nakita rin sikandan ka egsinundul kandin. Ne mig-insaan din e sikandan, “Nekey-a ka egpammitawen niyu?” Ne migtabak sikandan, “Rabi, hendei kaa mig-ugpe?” (Ka kaluwasan te Rabi, Talagpanulu.) ");
INSERT INTO mbtNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ne migkahi si Hisus, “Kema, duma kew keddi eyew egkiteen niyu.” Purisu migdume e sikandan wey nakita ran e ka in-ugpaan din, wey migpalunggehaat sikandan duma kandin su me alas kuwatru e seeye te maapun. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andris ne suled ni Simun Pidru ka sabeka te seeye se daruwa ne nakarineg te ingkahi ni Huwan wey ka migsinundul ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Migweil-weil si Andris, impammitew rin ka suled din ne si Simun Pidru wey ingkahiyan, “Nakita ney e ka Misiyas.” (Ka kaluwasan te Misiyas, Kristu.) ");
INSERT INTO mbtNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne induma rin e si Simun diye te ki Hisus. Te pegginguma ran diye te ki Hisus, migmemetmetan sikandin ni Hisus wey migkahiyan, “Sikeykew si Simun ne anak ni Huwan. Piru puun kuntee, egngaranan kad e ki Sipas.” (Ka Sipas iling ded ka kaluwasan te Pidru ne iyan igpasabut se, “batu.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te seup ne aldew, nakasuman-suman si Hisus ne eggendiye te Galiliya. Ne nalambag din si Pilipi diye wey migkahiyan din, “Ikul ka keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Si Pilipi, matig-Bitsayda. Ne diye degma te sikan siyudad nangugpe ensi Andris wey Pidru.) ");
INSERT INTO mbtNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nataman, nakita ni Pilipi si Natanail wey migkahiyan din, “Nakita ney e ka etew ne nasulat diye te Balaud ni Muwisis wey nasulat ded degma te me prupita. Sikandin bes si Hisus ne matig-Nasarit ne anak ni Husi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne mig-insaan sikandin ni Natanail, “Duen bes ded meupiya ne etew ne matig-Nasarit?” Ne migtabak si Pilipi, “Kema, egparumeey ki eyew egkakita nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te pegkakita ni Hisus te egparani e si Natanail diye te kandin, migkahi e sikandin, “Te, seinid e ka malehet ne kabuhalan ni Israil, wey kene mule sikandin egpanlimbung.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ne mig-inse si Natanail, “Immenu nu te eg-ila keddiey?” Ne migtabak si Hisus, “Te ware ke pad umawa ni Pilipi, nakita kud e sikeykew diye te lebut te kayu ne egngaranan te iggira.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ne migkahi si Natanail, “Talagpanulu, sikeykew bes iya ka Anak te Manama! Sikeykew bes iya ka Hari te Israil!” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ne migtabak si Hisus, “Kema ke migpalintutuu ke re puun te ingkahi ku ne nakita ku sikeykew diye te lebut te kayu? Subla pad kangkuwa due ka egkakita nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne migkahiyan ni Hisus sikandan langun, “Egnangenan ku sikaniyu te malehet: egkakita niyu ka langit ne egkalukatan wey ka me panalihan te Manama ne egpamaneug wey egpamaneyik diye te Anak te Etew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Te peglihad e te daruwa ne aldew, due kasal diye te lungsud te Kana ne sakup te Galiliya. Ne migtambung ka iney ni Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","wey inninggat degma ensi Hisus duma te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te naamin e ka eg-inumen ne binu, migkahiyan e si Hisus te iney rin, “Naaminan e sikandan te binu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ne migtabak si Hisus, “Ine, kena a banasali su ware pad migginguma ka keddi ne timpu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nataman, migkahiyan e te iney ni Hisus ka me suluhuanen, “Himuwa niyu ka minsan nekey ne igsuhu din kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne due tuluuwen te me Hudiyu meyitenged te peg-ayad-ayad pegpanlu-lu. Sikan naa ka due hen-em diye ne banga ne batu ne egkatahuan ka tagse sabeka te daruwa ne pulu (20) peendiye te tatelu ne pulu (30) ne gelun ne weyig. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne migkahiyan ni Hisus ka me suluhuanen, “Hipenua niyu te weyig ka hen-em ne banga.” Ne miggipenu dan en iya seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nataman, migkahiyan e man-e sikandan ni Hisus, “Na, sakug kew naan e due te weyig wey uyana niyu diye te migpangulu te seini ne sahakeen.” Ne intuman dan iya seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ne miggeraman e degma te migpangulu te kasal ka weyig ne neyimu ne binu, piru ware sikandin nakanengneng ke hendei migpuun ka binu. (Piru nakanengneng e ka me suluhuanen ne migsakug te weyig.) Seeye naa, impeumew rin e ka egpangasawa ");
INSERT INTO mbtNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","wey migkahiyan, “Nabatasan te kasuluhan ne iyan iggun-a igsendad ka subla ne mananam ne binu ne igpeinum te me mahaliyug. Ne emun ke dakel e ka egkeinum dan, henduen pad ka kene amana ne meupiya ne binu. Piru sikeykew mule, kunteen nud e ipalihawang ka subla ne mananam ne binu!” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sika ka an-anayan ne innimu ni Hisus ne kein-inuwan diye te Kana ne sakup te Galiliya. Impakita rin ka karesen din, wey migpalintutuu kandin wey migsalig ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te pegkapenga rutu, migtupang e si Hisus peendiye te Kapirnaum duma te iney rin, me suled din, wey me hibateen din, wey migpalunggehaat sikandan diye te me pila ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te seeye ne timpu, mahaan e ka sahakeen te me Hudiyu ne egngaranan te Sahakeen te Peglihad te Panalihan te Manama, purisu miggendiye si Hisus te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne diye te timplu, nakita rin ka egmamelegye te me baka, me karniru, wey me seleppati. Nakita rin man-e diye ka egmanaliyu te seleppi ne naminnuu te me lamisa ran. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne puun dutu, miggimu si Hisus te lubid ne igpanlampes din, wey impangalew rin ka me ayam ne me karniru wey me baka, wey impalihawang din diye te timplu. Ne insabulak din ka me seleppi te egmanaliyu te seleppi wey impamalintuad din ka me lamisa. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne migkahiyan din ka egmamelegye te seleppati, “Awaa niyu sika kayi! Kene niyu himuwa ne palingkiyan ka baley te Amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ne dutu, nasuman-suman e te me hibateen din ka nasulat diye te Kasulatan ne miggenendue, “Ka subla ne peggeyinawa ku te baley nu ka egpakapanulud keddi diye te kamatayen.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ne puun te miggimu rin, mig-insaan sikandin te me pangulu te me Hudiyu te migkahi, “Nekey-a ne kein-inuwan ka igkapapitew nu kanami ne due katenged nu te peggimu te iling kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ne migtabak si Hisus, “Guhusa niyu seini se timplu, ne seled te tatelu ne aldew, igpes-ek ku red man-e.” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ne migkahi sikandan, “Miggingumaan te hep-at ne pulu wey hen-em (46) ne leg-un ka pegbebaley kayi, ne kuntee, igpes-ek nu re seled te tatelu ne aldew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piru ka timplu ne egkahiyen ni Hisus, sika se lawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Purisu te timpu ne in-uyag e sikandin, nasuman-suman te me hibateen din ka inlalag din. Ne migpalintutuu e sikandan te nasulat te Kasulatan wey te inlalag ni Hisus meyitenged te lawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ne diye te Hirusalim te timpu te Sahakeen te Peglihad te Panalihan te Manama, masalig ne me etew ka migpalintutuu wey migsalig ki Hisus puun te pegkakita ran te me kein-inuwan ne neyimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piru ware mule migsalig si Hisus kandan su nanengnengan din ka langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne kenad ne keilangan ne egpanugtulan pad sikandin meyitenged te me etew su nakanengneng e sikandin ke nekey ka diye te pusung dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ne due sabeka ne etew ne egngaranan ki Nikudimu. Sabeka sikandin ne pangulu te me Hudiyu wey sakup te punduk te me Parisiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sabeka ne marusilem, miggendiye sikandin te ki Hisus wey migkahi, “Talagpanulu, nakanengneng key ne talagpanulu ka ne impeendini te Manama, su ware egpekeyimu te me kein-inuwan iling te neyimu nu ke ware ka Manama diye te kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ne migtabak si Hisus, “Egnangenan ku sikeykew te malehet: ware etew ne egkasakup te Peghari te Manama ke kene sikandin ig-abey iglesut.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne mig-inse si Nikudimu, “Egmenuwen naan pad te igpalesut ka etew ke buyag e? Kenad egkaayun ne eglibed pad sikandin egseled diye te getek te iney rin eyew igpalelesut e man-e.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ne migtabak si Hisus, “Egnangenan ku sikeykew te malehet: ware etew ne egpakaseled te Migharian te Manama ke kene sikandin ig-anak pinaahi te weyig wey te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Su ka ig-anak te etew, etew re degma, piru ka ig-anak te Panisingan te Manama, ispirituwanen degma. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Purisu, kene ka keinu-inu ne migkahiyan ku sikeykew te keilangan ne ig-abey ka iglesut. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iling te kalamag ne minsan hendei egpabaye, egkarineg ta ka dahing kayi piru kene ta egkanengnengan ke hendei migpuun wey ke hendei egpabulus. Iling ded degma due ka langun ne ig-anak te Panisingan te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ne mig-inse si Nikudimu, “Egmenuwen naa seini?” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ne migtabak si Hisus, “Ware ke bes nakanengneng kayi te mabantug ke ma perem ne talagpanulu kayi te Israil? ");
INSERT INTO mbtNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Egnangenan ku sikeykew te malehet: ke nekey ka nanengnengan ney wey nakita, sikan ded ka egpamalehetan ney. Piru ware kew migpalintutuu te guhuren ney. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ke ware kew migpalintutuu te igpangguhud ku kaniyu meyitenged te kayi te kalibutan, wey kew naan pa iya egpalintutuu ke iyan ku igpangguhud ka meyitenged te diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ne ware pad etew ne nekeendiye te langit, angin e te seeye se migpamaneug puun te langit, ne iyan ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ne iling te pegkayew ni Muwisis te putew ne uled te diye sikandan te mammara ne inged ne kene egkeugpaan, iling naan ded degma ka Anak te Etew ne keilangan ne egkayawen ");
INSERT INTO mbtNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","eyew ka langun ne egpalintutuu wey egsalig kandin, egpakaangken te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Su miggeyinawaan amana te Manama ka me etew kayi te ampew te tane, sikan naa ka imbehey rin ka sabsabeka ne Anak din su eyew ka langun ne egpalintutuu wey egsalig kandin, kene egpatey, ke kene, egpakaangken te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Su ware ipeendini te Manama ka Anak din kayi te ampew te tane eyew te peggukum te me etew, ke kene, te pegluwas kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Purisu ka minsan hentew ne egpalintutuu wey egsalig kandin, kene eggukuman ne eglegparan, piru ka minsan hentew ne kene egpalintutuu kandin, tapey e newukuman su ware sikandin migpalintutuu te sabsabeka ne Anak te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iling kayi ka peggukum: ka kalayag, nekeendinid e te kalibutan piru ware geyinawei te me etew, ke kene, iyan dan miggeyinawaan ka marusilem su mareet ka eggimuwen dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Su ka langun ne eggimu te mareet, kene egkeupian te malayag wey kene degma ne egparani te malayag su egkaaldek ne egkatahaan ka mareet ne eggimuwen dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piru seeye se etew ne mig-ikul te kamalehetan, egparani te malayag su eyew egkatahaan ne iyan egpuunan te meupiya ne neyimu rin ka Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te pegkapenga dutu, miggendiyad e te prubinsya te Hudiya ensi Hisus duma te me hibateen din. Ne migpalunggehaat sikandan diye, wey migpamewutismu sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ne si Huwan, migpamewutismu degma diye te Inun ne marani te Salim, su dakel ka weyig diye. Migpamewutismuwan din ka me etew ne nangendiye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Te seeye ne timpu, ware pad naprisu si Huwan.) ");
INSERT INTO mbtNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ne dutu, migpakig-apul ka me hibateen ni Huwan te sabeka ne Hudiyu meyitenged te tuluuwen dan ne peglinis. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nangendiye sikandan te ki Huwan ne migkahi, “Talagpanulu, nasuman-suman nu pad seeye se etew ne duma nu dengan diye te deyipag te weyig ne Hurdan, ne impeila nu te me etew? Migpamewutismu man e degma sikandin kuntee wey nangendiyad e te kandin ka langun ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ne migtabak si Huwan, “Ware egkeyimu te etew, angin e ke igbehey seini kandin te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sikaniyu mismu ka egpakapamalehet te migkahi ku ne kene ne sikeddiey ka Kristu, ke kene, impewun-e e re kandin ipeendini te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iling te egkasalen: ka egpangasawa, iyan iya egpakakamuney te egpangasaween. Ka alukuy te egpangasawa ne egtetahad kandin, egkahale ke egkarineg din e ka laheng te egpangasawa. Ne egpekeiling e naa degma te alukuy te egpangasawa, ne amana a nahale kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Su keilangan ne egpakaparibabew sikandin, ne sikeddi, egpakapariralem.” ");
INSERT INTO mbtNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sikandin se migpuun diye te langit iyan labew te langun. Ka migpuun kayi te ampew te tane, malebud de wey iyan de iya egkahuhud ka kayi re te ampew te tane. Piru, sikandin se migpuun diye te langit ka labew te langun. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne iyan din impamalehetan ka egkakita rin wey ka egkarineg din, piru ware egpalintutuu te igpangguhud din. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Piru seeye se egpalintutuu te iglalag din, migpamalehet ne malehet ka inlalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Su ka insuhu te Manama, egpangguhud te lalag te Manama su ware tamanan te Panisingan ne imbehey te Manama diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Amana geyinawei te Amey ka Anak din, ne ka langun imbehey rin diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ne minsan hentew ne egpalintutuu wey egsalig te Anak din, egpakaangken te umul ne ware egtamanan. Piru ka kene egpalintutuu wey egsalig te Anak din, kene egpakaangken te umul ne ware egtamanan, ne nasi kene egkaawe ka langet te Manama kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ne nakarineg ka me Parisiyu te iyan e masalig ka neyimu ne hibateen wey nabewutismuwan ni Hisus du te ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Piru ka malehet, kene ne si Hisus iya ka migpamewutismu su ka me hibateen din de.) ");
INSERT INTO mbtNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te pegkanengneng ni Hisus te narineg seeye te me Parisiyu, mig-awe e sikandan diye te Hudiya wey miglibed e diye te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne due inged ne egngaranan te Samarya ne egkaliharan dan te eggendiye te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pegginguma ran te Samarya, due lungsud diye ne egngaranan te Sikar ne marani te tane ne imbehey ni Hakub te anak din ne si Husi. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne due belun dutu ne impakali dengan ni Hakub. Ne diye migpinnuu si Hisus te ilis te belun su nabeley sikandin ka miggipanew. Me meudtu en iya seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ne dutu, nangendiye te lungsud ka me hibateen din ka egbebeli te egkakeen dan. Te iyug de te me hibateen din, due malitan ne matig-Samarya ne miglepew eyew egpanakeru. Ne migkahiyan sikandin ni Hisus, “Peinume e pa.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Te seeye ne timpu, nangendiye te siyudad ka me hibateen din su egbebeli te egkakeen.) ");
INSERT INTO mbtNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ne migtabak ka malitan, “Mania te egbuyuan a nikeykew te weyig te Hudiyu ke ma, wey sikeddi, matig-Samarya a ne malitan?” (Nakakahi ka malitan te iling due su kenad iya eg-elit-elit ka me Hudiyu te me matig-Samarya.) ");
INSERT INTO mbtNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ne migtabak si Hisus, “Ke nanengnengan nu pa perem ke nekey ka igkabehey te Manama, wey ke hentew seini se migbuyu keykew te weyig, sikeykew en iya perem ka egbuyu keddi wey egbehayan ku sikeykew te weyig ne egpakabehey te umul.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ne migkahi ka malitan, “Ahalen, ware timbe nu, wey maralem degma seini se belun. Hendei ke naa eg-angey te weyig ne egpakabehey te umul? ");
INSERT INTO mbtNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Impakali re te kaapuan ta ne si Hakub ka seini ne belun wey kayi re iya degma sikandin mig-inum duma te me anak din wey te me ayam din. Mania, labew ke bes te kaapuan ta ne si Hakub?” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ne migtabak si Hisus, “Minsan hentew ne eg-inum te seini ne weyig, egkammaraan ded man-e; ");
INSERT INTO mbtNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","piru ka egpekeinum te weyig ne igbehey ku kandin, kenad egkammaraan. Su ka weyig ne igbehey ku kandin, egpekeiling te sebseb diye te lawa rin ne kene egkeetiyan ne egpakabehey te umul ne ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ne migkahi ka malitan, “Ahalen, behayi a te sika ne weyig su eyew kena ad egkammaraan, wey eyew kena ad degma eggendini ka egsakeru.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ne migkahiyan sikandin ni Hisus, “Hendiyei nu ka asawa nu wey dumaa nu kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ne migtabak ka malitan, “Ware asawa ku.” Ne migtabak si Hisus, “Malehet ka ingkahi nu ne ware asawa nu. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Su kalalimma kad nakaasawa wey ka iglukes nu kuntee, kene ne malehet ne asawa nu. Sikan naa ka malehet ka ingkahi nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne migkahi ka malitan, “Ahalen, pegsuman ku ne prupita ka. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka me kaapuan ney, kayi migsimba te Manama te seini ne bubungan. Piru sikaniyu se me Hudiyu, migkahi kew te diye de te Hirusalim eleg ne egsimba te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ne migkahiyan sikandin ni Hisus, “Pammineg ka inayen. Egginguma ka timpu ne kene kew e kayi te bubungan wey ke diye naa te Hirusalim egsimba te Amey ne Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sikaniyu se matig-Samarya, ware kew nekeila te egsimbeen niyu, piru sikanami se me Hudiyu, nekeila key mule te egsimbeen ney su kayi ma te me Hudiyu egpuun ka kaluwasan. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Piru egginguma ka timpu, ka seinid en iya kuntee, ne ka malehet ne egsimba, egsimba te Manama pinaahi te panisingan wey te kamalehetan. Ne iling iya due ka igkeupii te Manama ne egsimba kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ka Manama, panisingan sikandin. Purisu ka egsimba kandin, keilangan ne egsimba pinaahi te panisingan wey te kamalehetan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ne migkahi ka malitan, “Nakanengneng a te eggendini ka Misiyas ne egngaranan te Kristu. Emun ke eggingume e sikandin, igpasabut din kanta ka langun.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ne migtabak si Hisus, “Sikeddi seini se migpakiglalag keykew, sikan en iya ka egkahiyen nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ne dutu, nakalibed e degma ka me hibateen ni Hisus. Ne neinu-inu sikandan te nakita ran sikandin ne migpakiglalag te malitan. Piru ware sabeka kandan ne egpekeinse te malitan ke nekey ka igkeupii rin, wey ware degma egpekeinse ki Hisus ke mania te migpakiglalag sikandin te malitan. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Seeye naa, mig-engkeran e te malitan ka banga din te miglibed diye te lungsud wey migkahiyan din ka me etew, ");
INSERT INTO mbtNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kema, mahaan kew, wey tengtengi niyu ka etew ne migpanugtul keddi te langun ne neyimu ku. Sikandin buwad ka Kristu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne nangawe ka me etew diye te lungsud wey nangendiye te ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Taheed te egpalinggumaan pad ka me etew, imbanasalan si Hisus te me hibateen din ne migkahi, “Talagpanulu, keen ke pa.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piru migkahi si Hisus, “Due egkakeen ku ne ware niyu nanengnengi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Seeye naa, migmein-inseey ka me hibateen din ne migkahi, “Duen buwa migdulung kandin te egkakeen?” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ne migkahiyan sikandan ni Hisus, “Ka egkakeen ku, iyan sika se pegtuman te igkeupii te migsuhu keddiey, wey te peg-impus te himu ne impeyimu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Due epad niyu ne eggenendue, ‘Eggingumaan pad te hep-at ne bulan human ka tinggaani.’ Piru egnangenan ku sikaniyu, tinggaani e kuntee. Pitawa niyu ka me pinamula diye te me kamet ne neyinuhan e wey eleg e ne eggaaniyen! ");
INSERT INTO mbtNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ka eggaani, egbayaran sikandin, wey seeye se egkahaani, eglimuren wey egbehayan te umul ne ware egtamanan. Purisu, egkahale seeye se migpamula duma te seeye se miggaani. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Malehet iya ka eparen ne eggenendue, ‘Lein ne etew ka egpamula wey lein ne etew ka eggaani.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Impeyipanew ku sikaniyu eyew eggaani te ware niyu ikalasey te pegpamula. Nalasey ka me duma piru meupiya kew su sikaniyu ka nasunged puun te kandan ne himu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Masalig ka matig-Samarya ne migpalintutuu ki Hisus puun te migpanugtulan sikandan te malitan te nanengnengan ni Hisus ka langun ne neyimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te pegginguma te me matig-Samarya diye te ki Hisus, inhangyu dan sikandin ke egkaayun ne eggirehe pad sikandin diye te kandan. Purisu, miggirehe pad iya si Hisus diye seled te daruwa ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne migmasalig pad man-e ka migpalintutuu kandin tenged te pegpanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne migkahiyan te me etew ka malitan, “Kuntee, migpalintutuu key e kandin, kene ne puun de te impangguhud nu kanami, ke kene, puun te sikanami en iya ka nakarineg kandin. Ne natahaan ney e ne sikandin bes iya ka Manluluwas te me etew kayi te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Te nararuan e ensi Hisus diye, mig-awe e sikandan dutu wey miggendiyad e te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Ne si Hisus mismu ka migkahi ne kene egtahuren ka prupita diye te inged ne intulinan din.) ");
INSERT INTO mbtNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te pegginguma rin diye te Galiliya, meupiya ka pegsagsahipe kandin te me etew. Su nekeendiye ma sikandan te Hirusalim te timpu te Sahakeen te Peglihad te Panalihan te Manama wey nakakita degma sikandan langun te immangimu ni Hisus diye. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ne miglibed e man-e si Hisus diye te Kana ne sakup te Galiliya, ka inged ne miggimuwan din te binu puun te weyig. Ne dutu, due sabeka ne upisyal te gubirnu ne migdaluwan te anak din ne lukes diye te Kapirnaum. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te pegkarineg din ne miglibed si Hisus diye te Galiliya puun te Hudiya, migdagdahew sikandin miggendiye te ki Hisus ne migpeyid-u-hid-u kandin ne eggendiye te Kapirnaum eyew egbawian ka anak din ne egkabigtawan e. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Migkahiyan sikandin ni Hisus, “Wey kew re egpalintutuu keddi ke egpakakita kew te me palinneu wey me kein-inuwan ne himu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Piru migtabak ka upisyal, “Ahalen, duma ke pa ubag keddi te kene pad egkabigtawan ka anak ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne migtabak si Hisus kandin, “Uli kad e su egkeulian e ka anak nu.” Migpalintutuu ka upisyal te inlalag ni Hisus diye te kandin, ne sikan de ne mig-uli sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te egpatiralan pad sikandin, insinug-ung e sikandin te me suluhuanen din wey migpangguhuran, “Manekal e ka anak nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne mig-inse sikandin ke nekey ne uras ne migkabaluan ka anak din. Ne migtabak ka me suluhuanen, “Inlibuwanan e sikandin gabii te me ala una te maapun.” ");
INSERT INTO mbtNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne nasuman-suman te upisyal ne seeye iyan urasa ka pegkahi ni Hisus te egkeulian e ka anak din. Purisu, migpalintutuu sikandan langun se taltalaanak ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sika ka igkarangeb ne kein-inuwan ne innimu ni Hisus te pegginguma rin diye te Galiliya puun te Hudiya. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Te pegkapenga dutu, miggendiyad e man-e si Hisus te Hirusalim eyew te pegtambung te sahakeen te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ne diye te Hirusalim, due gumawan ne bayaanan te me karniru. Ne due lanew ne marani te seeye ne gumawan ne ingngaranan te me Hudiyu te Bitsata. Due lalimma ne helunganan ne nakaalingkus te lanew ");
INSERT INTO mbtNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","ne impangibatan te susuluhi ne egmanderalu, me butud, me pungku, wey kene egkengaweil se lawa ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne due sabeka ne etew diye ne tatelu ne pulu wey walu (38) e ne leg-un ka migderalu. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nakita ni Hisus ka etew ne miggibat diye wey nanengnengan din e degma ka kaluhey te pegderalu rin. Seeye naa, mig-insaan din e ka etew, “Egkeupian ka ne egkeulian?” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne migtabak ka egderalu, “Ahalen, egkeupian a perem piru ware etew ne egpaseneb keddi due te weyig ke egkalihew e sika te panalihan, su emun ke egpeenduen ad e te weyig, duen e egpekewun-a keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ne migkahiyan sikandin ni Hisus, “Enew ka, wey uyana nu ka hibatanan nu wey hipanew kad.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sahuhune ne neulian ka etew te dalu rin, wey insabilbil din e ka hibatanan din wey miggipanew e. Neyitabu seeye te Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Purisu migkahiyan te me pangulu te me Hudiyu ka lukes ne neulian, “Mania te mig-uyan ka te hibatanan nu te Aldew kuntee te Peggimeley? Supak seini te Balaud ta.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne migtabak ka etew, “Ka migbawi keddi ka migsuhu ne igpeuyan ka hibatanan ku wey egpeyipanawen a.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Seeye naa, mig-insaan dan ka etew ke hentew ka migsuhu kandin te peg-uyan te hibatanan din wey te pegpeyipanew kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piru ware neileyi te etew ke hentew ka migbawi kandin, su nakasewug-sewug man-e si Hisus te susuluhi ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nataman, nakite e man-e ni Hisus diye te timplu ka etew ne imbawian din wey migkahiyan din, “Tengtengi nu naa te neulian kad en iya. Kene kad himu te sale su kema ke subla pad ne mareet ka egkeyitabu keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nataman, mig-awe e ka etew ne migpangguhud te me pangulu te me Hudiyu ne si Hisus bes ka migbawi kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne puun dutu, migbunsuran e te me pangulu te me Hudiyu si Hisus te egbayad-bayad tenged su migpamawi sikandin te Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne migkahiyan sikandan ni Hisus, “Kene eg-engked ka Amey ku ne eggimu, sikan naa ka kena a degma eg-engked.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Puun te ingkahi ni Hisus, nanasnasian de iya nalelehet ka me pangulu te me Hudiyu ne eggimatey kandin, su kene ne iyan de egpuunan ka pegsupak din te Balaud meyitenged te Aldew te Peggimeley, ke kene, migkahi pad man-e sikandin te ka Manama iyan iya ka Amey rin. Iyan kaluwasan due ne nekeiling sikandin te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Purisu migkahi si Hisus diye te kandan, “Egnangenan ku sikaniyu te malehet: ware egkeyimu te Anak ke sikandin de. Eggimu re sikandin ke nekey ka nakita rin ne eggimuwen te Amey rin. Ke nekey ka eggimuwen te Amey, iling ded degma ka eggimuwen te Anak. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Miggeyinawaan amana te Amey ka Anak din wey impakita rin kandin ka langun ne eggimuwen din. Igpakita rin pad man-e diye te Anak din ka subla pad kayi ne me kein-inuwan, ne sika ka egpakapeinu-inu kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eg-uyahen te Amey ka me minatey wey egbehayan te umul, ne egbehey red degma ka Anak te umul te seeye se igkeupii rin ne eg-uyahen. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kene eggukum ka Amey te minsan hentew, su imbehey rin diye te Anak din ka katenged te peggukum, ");
INSERT INTO mbtNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","su eyew egtahud ka langun te Anak iling te pegtahud dan te Amey. Purisu, ka kene egtahud te Anak, kene degma egtahud te Amey ne migsuhu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Egnangenan ku sikaniyu te malehet: ka egpammineg te iglalag ku wey egpalintutuu te migsuhu keddiey, due umul ne ware egtamanan. Kenad sikandin eggukuman ne eglegparan tenged su nakabaye e sikandin puun te kamatayen peendiye te umul. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Egnangenan ku sikaniyu te malehet: egginguma ka timpu, ne ka seinid en iya kuntee, ne egdineg ka me minatey te laheng te Anak te Manama, ne seeye se egpakarineg, egkeuyag. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ka Amey ka egpakabehey te umul, ne iling ded degma ka Anak din su imbehayan din te katenged te pegbehey te umul. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Migbehayan din man-e ka Anak te katenged te peggukum, tenged su Anak ma sikandin te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kene kew keinu-inu kayi su egginguma ka timpu ne egpakarineg te laheng din ka langun ne me minatey diye te lebenganan, ");
INSERT INTO mbtNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","wey egmanlihawang sikandan. Ka seeye se meupiya se neyimu, eg-uyahen wey egbehayan te umul ne ware egtamanan. Ka seeye se mareet se neyimu, eg-uyahen ded degma piru eggukuman ne eglegparan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mig-abey pad man-e migkahi si Hisus, “Ware egkeyimu ku ke sikeddiey re. Su minsan eggukum a, piru iyan ku eg-ikulen ka iglalag te Manama keddi. Purisu matareng ka peggukum ku su kene e ma eggimu te igkeupii ku, ke kene, seeye de se igkeupii te migsuhu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Emun ke sikeddiey re ka egpamalehet meyitenged te pegkeetew ku, kene seini egkapalintutuuwan. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piru due duma ne migpamalehet meyitenged keddiey, wey nakanengneng a ne malehet ka ingkahi rin meyitenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Due insuhu niyu diye te ki Huwan eyew te peg-inse-inse kandin, wey migpangguhud sikandin te malehet meyitenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kena a egkeilangan te pegpamalehet te me etew meyitenged keddiey, piru miglalag ku re sika eyew egpalintutuu kew wey egkaluwas kew. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nekeiling si Huwan te impareketan ne sulu ne miglayag. Ne ingkahale niyu ka peglayag din minsan te malepet de ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piru due egpamalehet meyitenged keddiey ne subla pad te pegpamalehet ni Huwan. Su ka immangimu ku ne igmeyimu iya te Amey ku keddiey, iyan sika ka migpamalehet te impeendini a iya te Amey ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne ka Amey ne migpeendini keddiey iyan iya migpamalehet meyitenged keddi. Piru ware kew en iya nakakita te ulaula rin wey ke nakarineg naa te laheng din, ");
INSERT INTO mbtNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","wey warad iya nakapamula te pusung niyu ka lalag din, su ware kew migpalintutuu keddi te impeendini rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","In-ugsi-ugsi niyu ka Kasulatan su kahiyen niyu ne sika ka paahi ne egpakaangken kew te umul ne ware egtamanan. Ne ka Kasulatan, migpamalehet iya meyitenged keddiey ");
INSERT INTO mbtNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","piru ware kew red iya man-e migparani keddiey eyew egpakaangken te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kena a egparayan-dayan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Piru neilaan ku mule sikaniyu wey nanengnengan ku ne ware diye te pusung niyu ka geyinawa te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miggendini a ka mig-uyan te katenged te Amey ku, piru ware a nikaniyu dawata. Ne ke due lein ne eggendini te kandin de ne katenged, iyan niyu nasi egdawaten. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Egmenuwen niyu te pegpalintutuu ke iyan niyu re igkeupii ne egmekegdayan kew, piru egbalaharen niyu ka pegdayan ne egpuun te sabsabeka ne Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Piru kene kew egsuman-suman ne sikeddi ka egsumbung kaniyu diye te Amey ku. Si Muwisis iya ne migpallatengan niyu ka egsumbung kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ke malehet ne migpalintutuu kew ki Muwisis, egpalintutuu kew perem degma keddiey su sikandin iya ka migsulat meyitenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piru tenged su kene kew egpalintutuu te insulat din, sikan naa ka kene kew degma egpalintutuu te iglalag ku kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pegkapenga dutu, miglapas e man-e ensi Hisus diye te Lanew te Galiliya ne egngaranan degma te Lanew te Tibiryas. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Amana ne masalig ne me etew ka migsinsinundul engki Hisus su nakakita sikandan te me kein-inuwan ne innimu rin te pegpamawi din te egmanderalu. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ne migpatakereg e ensi Hisus duma te me hibateen din diye te bubungan wey diye migpinpinnuu. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te seeye ne timpu, mahaan e man-e ka Sahakeen te Peglihad te Panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te pegtengteng ni Hisus, nakita rin ka susuluhi ne me etew ne egpeendiye te kandan. Ne migkahiyan din si Pilipi, “Hendei ki egpakabebeli te egkakeen ne igpakeen ta te seini ne me etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Inlalag din sika eyew te peg-eleg-eleg ki Pilipi, kunaleg te tapey e sikandin nakanengneng ke nekey ka eggimuwen din.) ");
INSERT INTO mbtNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ne migtabak si Pilipi, “Minsan pad ke egbebeli ki te paan ne bali te daruwa ne gatus (200) ne dinaryu, wey egdereiseken te re te pegpamehey, kene de egkakeenan ka seini ne me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne migkahiyan sikandin te sabeka te me hibateen din ne egngaranan ki Andris ne suled ni Simun Pidru, ");
INSERT INTO mbtNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Due lukes-lukes kayi ne due paan ne lalimma ne malisen wey daruwa ne ngalap te weyig. Piru nekegmenu naan de iya sika te iling kayi ne kasuluhan?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ne migkahi si Hisus, “Ne papinnuuwa niyu ka me etew.” Purisu immapinnuu ran e ka me etew diye te me hilamunen, su dakel ka me hilamunen dutu. Lalimma ne libu (5,000) ka kasuluhan te me lukes de. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nataman, ingkuwa ni Hisus ka me paan wey migpasalamat pad sikandin te Manama hendue ipamehey diye te me etew ne namminnuu. Ne iling ded ka ngalap, impanalad din ded degma diye te me etew, wey nangeen sikandan taman te igkeupii ran. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te nabulung-bulung e sikandan langun, migkahiyan e ni Hisus ka me hibateen din, “Limura niyu ka nasame su egkaraat.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Seeye naa, impanlimud dan e ka nasame puun te lalimma ne paan, wey nakapenu te sapulu wey daruwa (12) ne liyang ka nasame. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te pegkakita te me etew te kein-inuwan ne innimu ni Hisus, migkahi sikandan, “Seinid en iya ka Prupita ne nasulat diye te Kasulatan ne eggendini te ampew te tane!” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ne tapey e nakanengneng si Hisus ne egpehesen sikandin te me etew eyew eggimuwen dan ne Hari, seeye naa ka mig-awe sikandin diye wey miglibed migtakereg diye te bubungan ne migsabsabeka. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ne hengkayi se egpangilumkilum e, nanupang e ka me hibateen din diye te lanew ");
INSERT INTO mbtNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wey nanguntud te balangey ka eglapas diye te Kapirnaum. Ne nasagkup de due, ware pad nakasundul si Hisus kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Taheed te eglapas e sikandan, migpangalamag te kekesehi wey migdakel e ka me bunlud. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te me lalimma e wey ke hen-em e ne kilumitru ka imbaye dan te pegpamegsey, nakita ran si Hisus ka miggipanew diye te weyig ne egpeendiye te unturanan dan, wey nenaaldek sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piru migkahiyan sikandan ni Hisus, “Kene kew kaaldek su sikeddiey seini.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ne dutu, igkeupii ran ne eg-untud si Hisus te balangey, wey sahuhune ne nakatuhun sikandan diye te eggendiyaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te seup ne aldew, ka me etew ne migpalunggehaat pad diye te deyipag te linew nakamaan-maan te nangawe e ka me hibateen ni Hisus ne nanguntud te sabsabeka ne balangey diye. Nanengnengan dan man-e ne ware migduma si Hisus te me hibateen din su sikandan de ka nangipanew. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ne dutu, due me balangey puun te Tibiryas ne nanginguma diye te marani te nangeenan dan te paan te napasalamatan e seeye te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Purisu te pegkanengneng dan ne ware bes e si Hisus diye wey ka me hibateen din, nanguntud e sikandan te me balangey wey nangendiyad te Kapirnaum ka egpammitew ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pegginguma te me etew diye te deyipag te lanew, nakita ran si Hisus wey mig-insaan dan, “Talagpanulu, ken-u ke bes pad kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ne migtabak si Hisus, “Egnangenan ku sikaniyu te malehet: kene ne iyan niyu igpammitew keddi su nakakita kew te me kein-inuwan ne neyimu ku, ke kene, puun de su impakeen ku sikaniyu te paan wey nenabulung kew. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kene kew pakannekal ne eggimu para te keenen ne eglihad de, ke kene, te keenen ne egpakabehey te umul ne ware egtamanan. Ne ka Anak te Etew iyan egbehey kaniyu kayi su sikandin ka imbehayan te Amey ne Manama te katenged te pegbehey kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Puun due, mig-inse sikandan kandin, “Nekey naa ka eleg ne eggimuwen ney eyew egkatuman ney ka igpeyimu te Manama?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ne migtabak si Hisus, “Seini ka igkeupii te Manama ne eggimuwen niyu: palintutuu wey salig kew te insuhu din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ne migtabak sikandan, “Nekey naa ne kein-inuwan ka igkapapitew nu kanami eyew egpakapalintutuu key keykew? Nekey ka eggimuwen nu? ");
INSERT INTO mbtNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ka me kaap-apuan ney dengan, nangeen te mana te diye pad sikandan te mammara ne inged ne kene egkeugpaan. Su sumale te nasulat te Kasulatan, ‘Imbehayan din sikandan te keenen ne diye egpuun te langit.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ne migkahi si Hisus, “Egnangenan ku sikaniyu te malehet: kene ne si Muwisis ka migbehey kaniyu te egkeenen ne egpuun diye te langit, su ka Amey ku. Ne sikandin ded man-e ka egbehey kaniyu te malehet ne keenen ne egpuun diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Su ka keenen ne igbehey te Manama, iyan sika se egpamaneug puun te langit wey egbehey te umul te me etew kayi te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne migkahiyan dan si Hisus, “Ahalen, behayi key ma layun te sika ne keenen.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne migkahiyan ni Hisus sikandan, “Sikeddiey ka keenen ne egbehey te umul. Ka egparani keddi kenad iya eggutasan, wey ka egpalintutuu wey egsalig keddi, kenad egkammaraan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piru iling te nakahi kud e kaniyu ne minsan nakita ad nikaniyu, kene kew red iya man-e egpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ka langun ne etew ne igbehey te Amey ku keddi, egparani keddiey. Ne ka egparani keddi, kene ku egdeldelen. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Su wara a migpamaneug puun te langit eyew te pegtuman te keddi ne igkeupii, ke kene, eyew te pegtuman te igkeupii te Amey ku ne migsuhu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne seini ka igkeupii te migsuhu keddiey: egtantanuran ku ka imbehey rin keddi ne kene egkatarinan te minsan sabeka, piru eg-uyahen ku sikandan te katammanan ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Su seini ka igkeupii te Amey ku: ka langun ne egpammitew wey egpalintutuu wey egsalig te Anak, egpakaangken te umul ne ware egtamanan wey eg-uyahen ku sikandan te katammanan ne aldew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Seeye naa, migsalew-salew e ka me Hudiyu meyitenged kandin tenged te ingkahi rin ne sikandin ka keenen ne diye egpuun te langit. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Migkahi sikandan, “Si Hisus ma sika ne anak ni Husi. Nakataha ki ke hentew-a ka amey wey ka iney rin, ne mania te egkahi sikandin te diye din egpuun te langit?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne migtabak si Hisus, “Kene kew e pasalsalawey. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ware egpakaparani keddi ke kene egpeparaniyen te Amey ne migsuhu keddi. Ne seeye se egparani keddi, eg-uyahen ku red te katammanan ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Due insulat te me prupita ne eggenendue, ‘Egpanuluen sikandan langun te Manama.’ Purisu, ka langun ne egpammineg te Amey wey egdawat te iglalag din, egparani keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ne ware seini migpasabut ne due etew ne nakakita te Amey, su ware iya nakakita kandin angin e keddi te diye migpuun te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Egnangenan ku sikaniyu te malehet: ka egpalintutuu wey egsalig keddi, due umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sikeddi ka keenen ne egbehey te umul. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ka me kaap-apuan niyu, nangeen te mana te diye pad sikandan te mammara ne inged ne kene egkeugpaan, piru nammatey man ded sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piru lein ka seini se keenen ne migpamaneug puun te langit. Minsan hentew ne egkeen kayi, kenad e egpatey. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sikeddiey ka manekal ne keenen ne migpamaneug puun te langit. Minsan hentew ne egkeen te seini ne keenen, egkeuyag te ware egtamanan. Ne iyan keenen ka lawa ku ne igbehey ku eyew egpakaangken te umul ne ware egtamanan ka me etew kayi te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ne dutu, nenekeg-apul ka me Hudiyu diye. Ne migkahi sikandan, “Egmenuwen te seini ne etew te pegbehey te lawa rin eyew igpakeen kanta?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne migkahiyan sikandan ni Hisus, “Egnangenan ku sikaniyu te malehet: emun ke kene kew egkeen te lawa te Anak te Etew, wey kene eg-inum te kandin ne langesa, kene kew egpakaangken te umul. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Piru ka minsan hentew ne egkeen te keddi ne lawa, wey eg-inum te keddi ne langesa, due umul ne ware egtamanan, wey eg-uyahen ku te katammanan ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Su ka lawa ku, iyan sika ka malehet ne keenen, ne ka langesa ku, iyan sika ka malehet ne inumen. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ka minsan hentew ne egkeen te keddi ne lawa wey eg-inum te keddi ne langesa, eg-uugpe sikandin kayi te keddiey wey eg-ugpa a degma diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ka manekal ne Amey ka migsuhu keddi, wey neuyag a tenged kandin. Ne iling naan ded degma due, ka egkeen keddiey, egkeuyag tenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ne iyan iya seini ka keenen ne egpuun diye te langit, kene ne iling seini te keenen ne mana ne ingkeen te me kaap-apuan niyu, su nammatey red sikandan. Su ka egkeen te seini ne keenen, egkeuyag te ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Inlalag seeye ni Hisus te pegpanulu din diye te simbaan te me Hudiyu diye te Kapirnaum. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Masalig ne me hibateen din ka nakarineg kayi wey nakakahi, “Malised seini se impanulu din. Hentew-a ka egpekeuyun kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ne minsan ware migpanugtul ki Hisus, piru nanengnengan din ne migsalew-salew ka me hibateen din meyitenged te impanulu din. Sikan naa ka migkahiyan din sikandan, “Neenenduenan kew te ingkahi ku? ");
INSERT INTO mbtNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Emun ke iling due, wey naan pa iya ke egkiteen niyud ka Anak te Etew ne egbatunen igpalibed diye te impuunan din. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ka egbehey te umul iyan ka Panisingan te Manama wey kene seini egkeyimu te etew. Ka inlalag ku kaniyu, diye egpuun te Panisingan te Manama wey egpakabehey te umul. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piru due duma niyu kayi ne kene egpalintutuu keddi.” (Ingkahi seini ni Hisus su tapey rin e nanengnengi ke hentew ka kene egpalintutuu wey ke hentew degma ka eg-akal kandin.) ");
INSERT INTO mbtNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne migpabulus sikandin migkahi, “Sika ka egpuunan ne migkahiyan ku sikaniyu te ware egpakaparani keddi, angin e te igpeparani keddi te Amey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ne puun dutu, masalig ka me hibateen din ne mig-engked wey warad migduma kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ne migkahiyan ni Hisus ka sapulu wey daruwa (12) ne hibateen din, “Ne sikaniyu, eg-engkeran e naa degma nikaniyu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Migtabak si Simun Pidru kandin, “Magbebaye, hentew naa ka egkeendiyaan ney? Sikeykew re ka due lalag ne egpakabehey te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Migpalintutuu key keykew wey nanengnengan ney ne sikeykew iya ka Matulus ne in-alam te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ne migkahiyan sikandan ni Hisus, “Sikeddiey iya ka mig-alam kaniyu te sapulu wey daruwa (12). Piru ahalen te me busew ka sabeka kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si Hudas ne anak ni Simun Iskaryuti ka egkahiyen ni Hisus, su minsan sabeka sikandin te sapulu wey daruwa (12) ne hibateen, sikandin iya ka eg-akal ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pegkapenga dutu, migleug-leug si Hisus diye te Galiliya. Kene sikandin egleug-leug diye te Hudiya, su egbentaanan sikandin te eggimatey te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te seeye ne timpu, mahaan e ka sahakeen te me Hudiyu ne egngaranan te Sahakeen te me Balungbalung, ");
INSERT INTO mbtNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","wey migkahiyan si Hisus te me suled din, “Awe ka kayi wey hendiye ka te Hudiya su eyew egpakakita ka me hibateen nu te me kein-inuwan ne eggimuwen nu. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Su ware etew ne eggeles te eggimuwen din ke egkeupian sikandin ne egpabantug. Ne puun su eggimu ke ma te iling due, panengnenga nu nasi ka me etew kayi te ampew te tane meyitenged keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Nalalag sika te me suled ni Hisus su minsan sikandan, ware migpalintutuu wey migsalig kandin.) ");
INSERT INTO mbtNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ne migkahiyan sikandan ni Hisus, “Kene pad eleg keddi kuntee ne eggendiye, piru egkaayun kew mule te minsan ken-u. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kene egkaayun ne egdumutan kew te me etew kayi te ampew te tane, piru egdumutan a mule nikandan su impamalehetan ku ne mareet ka hinimuwan dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hendiye kew e te sahakeen. Kene e pad eggendiye su kene pad ne eleg ka timpu ne eggimuwen ku ka eleg ne eggimuwen ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sika ka inlalag din kandan wey migpalunggehaat pad sikandin diye te Galiliya. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Te nangipanew e ka me suled ni Hisus peendiye te sahakeen, migsinundul e degma si Hisus piru ware migpeeyang-heyang. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ne impammitew sikandin te me pangulu te me Hudiyu diye te sahakeen wey nanginse sikandan ke hendeid e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te seeye ne kalibulungan, masalig ka egmana-naasey meyitenged kandin. Ka duma migkahi, “Meupiya sikandin ne etew.” Piru ka duma migkahi degma, “Kene ne malehet sika, su eg-akalan din de ka me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piru ware sabeka kandan ne egpakawangal-wangal meyitenged kandin su egkaaldek sikandan te me pangulu te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te mahaan e egpekegliware ka sahakeen, miggendiye si Hisus te timplu wey migpanulu. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne dutu, neinu-inu ka me pangulu te me Hudiyu wey migkahi, “Immenu rin buwa te pegkateu te ware ma sikandin nekeiskuyla?” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Seeye naa, intabak sikandan ni Hisus, “Ka pegpanulu ku, kene egpuun kayi te keddiey, ke kene, diye egpuun te Manama ne migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Minsan hentew ne egkeupian ne eggimu te igkeupii te Manama, egpakanengneng ke diye naa egpuun te Manama ka pegpanulu ku wey ke kayi re egpuun te keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ka etew ne eglalag puun te kandin de ne suman-suman, egpabantug te pegkeetew rin. Piru ka etew ne iyan igpabantug ka migsuhu kandin, egkapalintutuuwan wey kene ne ubaten. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Imbehayan kew ni Muwisis te Balaud te Manama, menu ma iya? Piru ware minsan sabeka kaniyu ne migtuman te Balaud, su emun ke migtuman kew pa perem, kena a nikaniyu eggimatayan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ne migtabak ka me etew, “Migserepan kad te busew! Hentew ma ka egkeupian ne eggimatey keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ne migtabak si Hisus, “Duen de innimu ku te Aldew te Peggimeley wey neinu-inu kew e langun ");
INSERT INTO mbtNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","minsan nekeg-iling ki re iya. Su due impanulu ni Muwisis kaniyu ne pegtuli te me anak niyu (minsan kene ne diye egbunsud sika te ki Muwisis su diye te kaap-apuan din), ne innimu niyu sika minsan ke Aldew te Peggimeley. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ke egtulien niyu ka sabeka ne bate te Aldew te Peggimeley eyew te pegtuman te Balaud ni Muwisis, ne mania te nabelu kew keddi te imbawian ku ka sabeka ne etew te Aldew te Peggimeley? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kene niyu hukumi ka etew pinaahi te egkakita niyu ne hinimuwan din, ke kene, hukumi niyu sikandin pinaahi te eleg ne gantangan wey palabian.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ne due me matig-Hirusalim ne migkahi, “Hendue te seini ma iya ne etew ka egbentaanan dan te eggimatey? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na, pitawa niyud te egpanulu man e mule sikandin kayi te kasuluhan, wey ware igkaapul te me pangulu ta kandin! Kema buwa ke nakanengneng e sikandan te sikandin ka Kristu? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Piru nakanengneng ki ke hendei migpuun ka seini ne etew. Ne ka Kristu mule ke egginguma, ware egpakanengneng ke hendei sikandin egpuun.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Seeye naa, migbalbalukan si Hisus te pegpanulu din diye te timplu ne migkahi, “Malehet naan iya ne nekeila kew keddi wey nakanengneng kew ke hendei a egpuun? Ka malehet, wara a mig-uney-uney miggendini, ke kene, impeendini e re. Egkasalihan sikandin se migsuhu keddi, wey ware kew nekeila kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Piru nekeila a mule kandin, su diye a migpuun te kandin wey sikandin ka migsuhu keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ne puun due, egdakepen dan e perem sikandin, piru ware egpakaaku tenged su ware pad migginguma ka kandin ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Piru masalig ka me etew diye ne migpalintutuu wey migsalig kandin. Migkahi sikandan, “Emun ke egginguma ka Kristu, kene buwa sikandin egpekeyimu te kein-inuwan ne subla pad te neyimu te seini ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nakarineg ka me Parisiyu te igmegna-naasey te me etew meyitenged ki Hisus, purisu sikandan wey ka me pangulu te me talagpanubad, migsuhu te me talagbantey te timplu ne egparakepen ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ne migkahi si Hisus, “Kene naan de egkaluhey ka timpu ne egmekegduma ki, egkataman, eglibed ad man-e diye te migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Egpammitawen a nikaniyu piru kena ad nikaniyu egkakita su ka eggendiyaan ku, kene niyu egkeendiyaan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ne migmein-inseey ka me pangulu te me Hudiyu ne miggenendue, “Hendei bes sikandin eggendiye mania te kene ta sikandin egkakita? Eggendiye buwa sikandin te me siyudad te me Grigu ne nangubpaan te me karumaan ta ne me Hudiyu eyew diyad e man-e egpanulu? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Su migkahi sikandin, ‘Egpammitawen a nikaniyu piru kena ad nikaniyu egkakita,’ wey, ‘Kene kew egpekeendiye te eggendiyaan ku.’ Na, nekey buwa ka igpasabut din due?” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ne migginguma ka katammanan ne aldew te sahakeen ne iyan ka amana ne impurtanti ne aldew. Te seeye ne aldew, migsasindeg si Hisus ne migbalbalukan, “Hentew seeye se nammaraan, parani kew keddi wey inum kew. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Su sumale te nasulat diye te Kasulatan, ‘Ka minsan hentew ne egpalintutuu wey egsalig keddi, egtulayas te pusung din ka weyig ne egpakabehey te umul.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iyan igpasabut ni Hisus kayi ne seeye se egpalintutuu wey egsalig kandin, egpakarawat te Panisingan te Manama. Su ware pad ibehey ka Panisingan te Manama te seeye ne timpu, tenged su ware pad sikandin imbantug te Manama pinaahi te pegbatun kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Masalig ne me etew te seeye ne kalibulungan ka nakarineg te ingkahi rin wey nakakahi, “Malehet iya ne sikandin ka Prupita ne egtetaharan ta!” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne migkahi degma ka duma, “Sikandin iya ka Kristu!” Piru due degma duma ne migkahi, “Kene ne diye te Galiliya egpuun ka Kristu! ");
INSERT INTO mbtNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Su nasulat diye te Kasulatan ne ka Kristu diye egpuun te kabuhalan ni Dabid, wey diye eglesut te Bitlihim ne ugpaan ni Dabid.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Seeye naa, nabaad ka me etew meyitenged te suman-suman dan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Egkeupian ka duma ne egdakepen dan e perem sikandin, piru ware egpakaaku ne egdakep kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nataman, miglibed e ka me talagbantey te timplu diye te me pangulu te talagpanubad wey te me Parisiyu. Ne mig-insaan sikandan, “Mania te ware niyu uyana sikandin kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ne migtabak ka me talagbantey, “Ware de due etew ne nekeiling kandin ke eglalag!” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ne mig-insaan sikandan te me Parisiyu, “Ew, naakalan kew bes e degma nikandin? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Duen naan e natahaan niyu ne me pangulu te me Hudiyu wey ke Parisiyu naa ne migpalintutuu e kandin? ");
INSERT INTO mbtNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Seeye se me etew ne nalibulung, ware nakataha te Balaud ni Muwisis, purisu indilus sikandan te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ne due sabeka ne Parisiyu ne si Nikudimu, ne migpakigkite e dengan ki Hisus ne migkahi kandan, ");
INSERT INTO mbtNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sumale te kanta ne Balaud, kene ki egpekewukum ne nakasale ka sabeka ne etew te kene te pad egkewusey wey egkanengnengan ka neyimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ne migtabak sikandan, “Egpekeiling ka degma te matig-Galiliya! Kema, ug-ugsiya nu ka Kasulatan wey egkanengnengan nu ne ware prupita ne egpuun te Galiliya.” ");
INSERT INTO mbtNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nataman, nanguli e sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ne si Hisus mule, miggendiye sikandin te Bubungan te Ulibu. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te pegkapawe, migselem-selem e man-e si Hisus miggendiye te timplu. Ne miglingutan sikandin te masalig ne me etew wey migpinnuu sikandin ka migpanulu kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ne ka me talagpanulu te Balaud te Manama wey ka me Parisiyu, mig-uyan te malitan ne nasapenan dan ne nalibuhan wey impasasindeg dan diye te tangkaan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ne migkahiyan dan si Hisus, “Talagpanulu, nasapenan ka seini ne malitan ne nalibuhan. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ne sumale te Balaud ni Muwisis, eleg sikandin ne egbatuwen taman te egpatey. Na, nekey ka igkalalag nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inlalag dan seeye eyew te pegsahilut ki Hisus eyew igpakasumbung dan sikandin. Piru migweil-weil si Hisus, mig-usengul sikandin wey migsusulat te kemel rin diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Migpabulus sikandan ka eg-inse kandin, ne dutu, migsasindeg si Hisus ka migkahi, “Ke hentew kayi te kaniyu ka ware nakasale, sikandin ka eggun-a egbatu kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne mig-usengul e man-e si Hisus ka migsusulat diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te pegkarineg dan te inlalag ni Hisus, masihipanew e sikandan, ne iyan miggun-a ka me buyag. Nataman, si Hisus naan de ka nasame wey ka malitan ne migsasindeg diye. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ne migsasindeg si Hisus wey migkahiyan din ka malitan, “Beyi, hendei naan e sikandan? Ware bes sabeka ne miggukum keykew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ne migtabak ka malitan, “Ware, ahalen.” Ne migkahiyan sikandin ni Hisus, “Kene ku degma eggukuman sikeykew. Hipanew kad wey kene kad himu te sale.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ne migkahiyan e man-e ni Hisus ka me etew, “Sikeddiey ka kalayag te kalibutan. Ka eg-ikul keddi, egpakaangken te kalayag te umul wey kenad egpekeyipanew diye te marusilem.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ne migkahiyan sikandin te me Parisiyu, “Sikeykew red ka eg-uney-uney egpamalehet meyitenged keykew, sikan naa ka kene ka egkapalintutuuwan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ne migtabak si Hisus, “Minsan ke eg-uney-uney a egpamalehet meyitenged keddiey, malehet iya ka eglalahen ku, su nakanengneng a ke hendei a migpuun wey hendei a eggendiye. Piru ware kew nataha ke hendei a migpuun wey ke hendei a eggendiye. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka peggukum niyu puun de te suman-suman niyu, piru sikeddiey mule, wara a miggukum te minsan hentew. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Piru ke eggukum e ma, eleg mule ka peggukum ku su kene ne sikeddi de ka eggukum, ke kene, daruwa ney te Amey ne migpeendini keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nasulat diye te Balaud niyu ne emun ke egpekeg-iling ka guhuren te daruwa ne talagpamalehet, malehet naa ka guhuren dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mig-uney-uney a migpamalehet meyitenged keddiey, wey migpamalehet degma meyitenged keddi ka Amey ne migsuhu keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ne mig-inse sikandan, “Hendei ka amey nu?” Ne migtabak si Hisus, “Ware kew nekeila kanami te Amey ku. Emun perem ke nekeila kew keddi, nekeila kew perem degma te Amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Inlalag ni Hisus sika langun te pegpanulu din diye te lenged te intahuan te tahuanan te seleppi diye te timplu. Piru ware migdakep kandin puun su ware pad migginguma ka kandin ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nataman, migkahiyan e man-e sikandan ni Hisus, “Eggipanew a, wey egpammitawen a nikaniyu, piru egkammatey kew re due ne makasesale ded. Ne kene kew egpekeendiye te eggendiyaan ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Purisu migkahi ka me pangulu te me Hudiyu, “Kene ki kun egpekeendiye te eggendiyaan din. Iyan buwa igpasabut due ne egluhe sikandin?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne migtabak si Hisus, “Sikaniyu, kayi kew migpuun te tane, piru sikeddi, diya a migpuun te langit. Kayi kew ne mahinged te kalibutan, piru kena a mule ne mahinged kayi. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ingkahiyan kud sikaniyu ne egkammatey kew re due ne makasesale ded. Su emun ke kene kew egpalintutuu ne sikeddi iya ka egnangenen ku, egkammatey kew re due ne makasesale ded.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ne mig-insaan dan sikandin, “Hentew ke bes iya?” Ne migtabak si Hisus, “Sikeddi iya seeye se impangguhud kud e kaniyu puun pad dengan. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dakel ka igpakalalag ku wey ka igpekewukum ku kaniyu. Piru iyan ku re iglalag te me etew kayi te ampew te tane ka egkarineg ku ne egpuun diye te migpeendini keddi, su egkasalihan sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ware sikandan nakasabut te ka Amey bes e ne Manama ka egkahiyen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Seeye naa, migkahiyan sikandan ni Hisus, “Te timpu ne egkayawen niyud ka Anak te Etew, egkanengnengan niyud e ne sikeddi iya seeye se egnangenen ku. Egkanengnengan niyud man-e ne wara a mig-uney-uney miggimu te egkasuman-suman ku, ke kene, iyan ku re inlalag ka impanulu keddi te Amey ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne sikandin se migpeendini keddi, migduma keddiey. Wara a nikandin balahara ne migsabsabeka, su layun ku ma himuwa ka egpakapahale kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Masalig ka migpalintutuu ki Hisus te pegkarineg dan te inlalag din. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nataman, migkahiyan ni Hisus ka me Hudiyu ne migpalintutuu wey migsalig kandin, “Emun ke egpabulus kew eg-ikul te pegpanulu ku, malehet naa iya ne me hibateen ku sikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Egkanengnengan niyu ka kamalehetan, ne ka kamalehetan ka egbehey kaniyu te kaligwangan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ne migtabak sikandan, “Me kabuhalan key ni Abraham wey ware key re due neuripen te minsan hentew. Ne mania te migkahi ka te egbehayan key te kaligwangan?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ne migtabak si Hisus kandan, “Egnangenan ku sikaniyu te malehet: minsan hentew ne eggimu te sale, uripen te sale. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ne ka uripen, egkaayun ne eg-aween te pamilya, piru ka anak, kene mule egkaayun ne eg-aween. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Purisu emun ke egbehayan kew te Anak te kaligwangan, egpakaligwang kew iya! ");
INSERT INTO mbtNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakataha a te me kabuhalan kew iya ni Abraham, piru egbentaanan a nikaniyu te eggimatey su kene niyu egkarawat ka igpanulu ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iyan ku re igpangguhud ka impapitew keddi te Amey ku, piru sikaniyu, iyan niyu eggimuwen ka narineg niyu puun te amey niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ne migtabak sikandan, “Si Abraham ka amey ney.” Ne migtabak si Hisus, “Ke malehet ne kabuhalan kew ni Abraham, iling ded perem ka eggimuwen niyu te innimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piru nasi mule ne egbentaanan a nikaniyu te eggimatey minsan migpangguhud e re te kamalehetan ne narineg ku puun te Manama. Ne warad iya nekeyimu si Abraham te iling kayi! ");
INSERT INTO mbtNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ka eggimuwen niyu, iling ded te eggimuwen te amey niyu.” Ne migtabak sikandan, “Kene key ne me anak te dalan. Sabeka re ka Amey ney, ka Manama re iya.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ne migkahiyan sikandan ni Hisus, “Ke malehet ne ka Manama ka amey niyu, eggeyinawaan a perem nikaniyu, su diya a migligkat kandin te peggendini ku. Wara a mig-uney-uney re due miggendini, ke kene, impeendini e re nikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iyan puunan ne kene kew egpakasabut te iglalag ku, su egkeepes kew ne egpammineg te iglalag ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Iyan niyu amey ka ahalen te me busew, ne iyan niyu igkeupii te eggimu ka igkeupii rin. Mangimatey sikandin puun pad te bunsuranan, wey ware sikandin migpalapig te kamalehetan su ware kamalehetan diye te kandin. Emun ke eg-uubat sikandin, mig-ikul naan de sikandin te batasan din, tenged su ubaten sikandin wey sikandin ka puunan te langun ne ubat. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne iyan ku mule igpangguhud kaniyu ka kamalehetan, sikan naa ka kene kew egpalintutuu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hentew ma kaniyu ka egpakapamalehet ne nakasala a? Ware iya! Ne mania te kene kew egpalintutuu keddi te kamalehetan ma ka igpangguhud ku? ");
INSERT INTO mbtNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Seeye se kandin te Manama, egpalintutuu te lalag te Manama. Piru sikaniyu, kene kew ne kandin te Manama, sikan naa ka kene kew egpalintutuu te lalag din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne migtabak ka me pangulu te me Hudiyu diye te ki Hisus, “Malehet bes ka inlalag ney ne matig-Samarya ka wey migserepan te busew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ne migtabak si Hisus, “Wara a serepi te busew. Imbantug ku re ka Amey ku, piru impeyilawan a mule nikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wara a migparayan-dayan te keddi ne pegkeetew. Due ka Amey ne iyan egkeupian ne egkarayan a te me etew, wey sikandin ka eggukum ne malehet. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Egnangenan ku sikaniyu te malehet: ka minsan hentew ne egtuman te iglalag ku, kenad iya egpatey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ne migkahiyan sikandin te me pangulu te me Hudiyu, “Kuntee, nanengnengan ney e ne malehet iya ne migserepan ka te busew! Migpatey e si Abraham wey ka me prupita, piru kuntee, egkahi ka te minsan hentew ne egtuman te iglalag nu, kenad iya egpatey. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mania, labew ke bes pad ubag te apu ney ne si Abraham ne migpatey e? Nammatey e degma ka me prupita. Na, hentew ke naa iya ubag?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne migtabak si Hisus, “Emun ke egparayan-dayan e re, ware karuan te pegparayan-dayan ku. Piru ka Amey ku ne egkahiyen niyu ne Manama niyu, iyan egdayan keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ware kew nekeila kandin, piru nekeila a mule kandin. Su emun ke egkahi a te ware a nekeila kandin, egpekeiling ad e kaniyu te ubaten. Piru nekeila a iya kandin wey egtumanen ku ka lalag din. ");
INSERT INTO mbtNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nahale-gale ka apu niyu ne si Abraham ne egkakita rin e ka aldew ne eggendini a. Ne nakita rin e iya seini wey nahale-gale sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ne migkahiyan sikandin te me pangulu te me Hudiyu, “Ware ke pad miglalimma ne pulu (50) ne leg-un. Ne immenu nu naa ubag te pegkakita ki Abraham?” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ne migtabak si Hisus, “Egnangenan ku sikaniyu te malehet: duen ad e te ware pad miglesut si Abraham.” ");
INSERT INTO mbtNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ne puun dutu, migpamurut e sikandan te me batu su egbatuwen dan e si Hisus, piru miggeles sikandin wey mig-awe e diye te timplu. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Taheed te eggiphipanew si Hisus, due nakita rin ne etew ne nabutud puun te peglesut din. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ne mig-insaan sikandin te me hibateen din, “Talagpanulu, sale din naa wey ke sale te amey wey iney rin ka egpuunan ne nabutud sikandin puun te peglesut din?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne migtabak si Hisus, “Nabutud sikandin, kene ne puun te sale din wey ke sale naa te amey wey iney rin. Neyitabu ka iling kayi su eyew egkakita te me etew ka geem te Manama pinaahi kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Keilangan ne eggimuwen ta ka me himu te migsuhu keddi taheed te maaldew pad, su egginguma ka marusilem ne warad egpekeyimu. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne taheed te kayi e pad te ampew te tane, sikeddiey ka egpakalayag te langun ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Te pegkapenga rin te eglalag, mig-ileb sikandin diye te tane wey inluyang din ka in-ileban din. Nataman, impulitan din ka mata te etew ");
INSERT INTO mbtNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","wey migkahiyan din, “Hendiye ka te lanew te Silui wey pandep-ug ka diye.” (Insuhu ka kaluwasan te Silui.) Purisu miggipanew e ka etew wey migpandep-ug, ne egpakakite e sikandin te peglibed din. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ka me sumbaley rin wey ka me etew ne nakakita kandin te egpampamuyu pad, nekeinse sikandan ne eggenendue, “Hendue te seini ka etew ne egpinpinnuu ne egpampamuyu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Due duma ne migkahi, “Uya, sika iya.” Piru due duma ne migkahi, “Kene ne sika. Egpekegsahid de ka ulaula ran.” Ne migkahi seeye se etew, “Sikeddi iya ne.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ne mig-insaan dan sikandin, “Mania te egpakakita kad e?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ne migtabak sikandin, “Migluluyang te tane ka etew ne egngaranan ki Hisus, wey impulit din e te mata ku. Ne insuhu ad nikandin ne egpeendiyeen te lanew te Silui wey egpepandep-uhen. Purisu miggendiya a degma wey migpandep-ug, ne nataman, nakakita ad.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ne mig-inse e man-e sikandan, “Hendeid e sikandin?” Ne migtabak ka etew, “Wara a nakataha.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nataman, mig-uyan dan e diye te me Parisiyu ka etew ne nabutud dengan. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aldew seeye te Peggimeley te inluyang ni Hisus ka tane wey imbawian din ka butud. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nataman, mig-insaan e man-e te me Parisiyu ka etew ke mania te nakakita rin e. Ne migkahi ka etew diye te kandan, “Impulitan din te inluyang ne tane ka mata ku, ne nataman, migpandep-ug a wey nakakita ad.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ne migkahi ka duma ne me Parisiyu, “Kene ne diye te Manama egpuun ka seini ne etew su ware migtuman te Balaud te Aldew te Peggimeley.” Piru due degma duma ne migkahi, “Egmenuwen ma te makasesale te peggimu te iling kayi ne kein-inuwan?” Seeye naa, nabaad sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Purisu mig-abayan e man-e insei te me Parisiyu ka etew, “Nekey-a ka igkalalag nu meyitenged kandin, su egkahiyen nu ne imbawian din ka mata nu?” Ne migtabak ka etew, “Sabeka sikandin ne prupita.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piru ware migpalintutuu ka me pangulu te Hudiyu ne butud sikandin dengan ne egpakakite e kuntee. Ne puun due, impeumew ran ka amey wey iney rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mig-insaan nikandan ka amey wey iney te etew, “Anak niyu iya seini se egkahiyen niyu ne nakapaney nabutud? Ne mania te egpakakite e sikandin kuntee?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne migtabak ka amey wey iney te etew, “Malehet iya ne anak ney sikandin, wey malehet degma ne nakapaney sikandin nabutud. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piru ware key nakataha ke mania te nakakite e sikandin wey ke hentew ka migbawi kandin. Insei niyu sikandin su dakel e wey egkateu e ne egtabak.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Seeye ka nakahi ran puun su naaldek sikandan te me pangulu te me Hudiyu. Su neuyunan e nahud te me Hudiyu ne emun ke due eg-angken ne si Hisus iya ka Kristu, kenad e eg-ileen ne sakup pad te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sika ka egpuunan te nakakahi ka amey wey iney rin, “Insei niyu sikandin su dakel e!” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nataman, impeumew ran e man-e ka etew ne nabutud dengan wey mig-insaan, “Pahunlibet ka te Manama ne egpangguhud ka te malehet, su nakanengneng key ne makasesale ka etew ne migbawi keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ne migtabak ka etew, “Ware a nakataha ke makasesale naa sikandin wey ke kene. Iyan ku re natahaan ne butud a dengan, ne kuntee egpakakita ad.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ne mig-inse e man-e sikandan kandin, “Nekey ka innimu rin diye te keykew? Immenu rin e te egbawi ka mata nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Migtabak sikandin, “Impangguhuran kud e sikaniyu piru ware kew migpalintutuu. Ne mania te egkeupian kew pad man-e ne egpammineg kayi? Egkeupian kew degma ne egkeyimu ne me hibateen din?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Miglanglangitan dan sikandin wey migkahiyan, “Sikeykew re iya ka hibateen din! Piru sikanami, me hibateen key ni Muwisis. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nakanengneng key te migpakiglalag ka Manama ki Muwisis, piru meyitenged te sika ne etew, minsan se egpuunan ne ware ney en iya nataheyi ke hendei!” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ne migtabak ka etew, “Etuwey, amana seini! Imbawian din mule ka mata ku, ne migkahi kew te ware kew nakataha ke hendei sikandin migpuun! ");
INSERT INTO mbtNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nakataha ki ne kene egpamminehen te Manama ka me makasesale. Piru seeye se egtahud wey egtuman te pegbuut te Manama, egpamminehen din mule. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Puun te peggimu te kalibutan, ware de due egkabantug ne egpakabawi te mata te etew ne nakapaney nabutud. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ke kene egpuun diye te Manama ka seini ne etew, ware egkeyimu rin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ne migtabak sikandan, “Makasesale ka puun te peglesut nu, ne kuntee, iyan key re ubag egpanuluen nikeykew?” Ne puun dutu, impaawe e sikandin diye te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nakarineg si Hisus te impaawe e seeye se etew diye te simbaan te me Hudiyu. Te nakita rin e ka etew, migkahiyan din e, “Egpalintutuu ka wey egsalig te Anak te Etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne migtabak ka etew, “Magbebaye, nangeni a ke hentew sikandin su eyew egpakapalintutuu wey egpakasalig a kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ne migkahiyan sikandin ni Hisus, “Nakakita kad e kandin wey sikandin iya ka migpakiglalag keykew kuntee.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ne migkahi ka etew, “Egpalintutuu a Magbebaye.” Ne migpanimbuel sikandin ka migsimba ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Migkahi si Hisus, “Miggendini a te ampew te tane eyew te peggukum te me etew. Ne eyew seeye se me butud te kamalehetan egpakakita, wey seeye se egpakakita kayi, egkabutud.” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Due me Parisiyu diye te lenged din ne nakarineg te inlalag din. Ne mig-insaan dan sikandin, “Me butud key bes degma seini?” ");
INSERT INTO mbtNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne migtabak si Hisus, “Emun ke butud kew perem te kamalehetan, ware perem sale niyu. Piru puun su migkahi kew te egpakakita kew kayi, migpasabut naa sika te ware pad naawe ka sale niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Egnangenan ku sikaniyu te malehet: ka etew ne kene egbaye diye te gumawan te pegseled din diye te kulungan te karniru, wey ke egpamaneyik de sikandin diye te duma ne egbayaan, egpekeiling sikandin te takawen wey ke tulisan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piru ka etew ne egbaye diye te gumawan, iyan sika ka talagtameng te me karniru. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Eglukatan sikandin te talagbantey te gumawan, wey egkeilaan te me karniru ka laheng din te egpangumew kandan. Egpangumawen din ka ngaran te tagse sabeka kandan wey igpanulud din diye te lihawangan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne emun ke igkapalihawang din e sikandan langun, eggun-a sikandin te me karniru, wey egsinundul sikandan kandin su neilaan dan ka laheng din. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kene egsinundul sikandan te lein ne etew su nasi egpamallahuy puun su ware nekeila te laheng din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Impanguhuran sikandan ni Hisus te seini ne panunggilingan piru ware dan nakasabut ke nekey ka igpasabut din. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Seeye naa, migkahi e man-e si Hisus, “Egnangenan ku sikaniyu te malehet: sikeddiey ka gumawan te me karniru. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ka langun ne miggun-a keddi te miggendini, me takawen wey me tulisan sikandan. Piru ware migpammineg kandan ka me karniru. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sikeddiey ka gumawan. Minsan hentew ne egseled ne egbaye keddiey, egkaluwas. Egpekeiling sikandin te karniru ne egseled wey eglihawang ne due egkakita ne panabtaban. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Piru ka takawen, eggendini re eyew egpanakew, eggimatey, wey egdereet. Ne miggendini a mule eyew egbehey te umul ne warad egpammitawen pad. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sikeddiey ka meupiya ne talagtameng te karniru. Ka meupiya ne talagtameng, andam ne egpeyimatey para te me karniru. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kene sikandin egpekeiling te egbayaran de ne talagtameng te me karniru ne egpallahuy ke egpakakita te bubuluti ne singgalung ne egpeendiye te kandan. Eg-engkeran din ka me karniru wey egpamueren e te singgalung ka me karniru wey egmekegsuwey-suwey e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Egpallahuy sikandin su imbayaran man de wey ware de diye te kandin ke nekey ka egtamanan te me karniru. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sikeddiey ka meupiya ne talagtameng te karniru. Nekeila a te me karniru ku wey nekeila degma sikandan keddi ");
INSERT INTO mbtNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","iling te pegkeila te Amey ku keddi wey te pegkeila ku degma kandin. Andam a ne egpeyimatey para kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Due duma ne me karniru ku ne ware kayi te seini ne kulungan. Keilangan ne eg-uyanen ku degma sikandan kayi. Egpammineg sikandan te laheng ku wey egkeyimu sikandan ne sabeka ne punduk wey sabeka degma ka egtameng kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Miggeyinawaan a te Amey puun su egpeyimatey a para kandan, wey egkeuyag e red man-e. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ware egpekeyimatey keddi ke kene ne keddi ne pegbuut. Piru sikeddiey en iya ka eg-uney-uney egbehey te umul ku, su due katenged ku te pegbehey kayi wey te peggawi man-e kayi. Ne seini iya ka insuhu keddi te Amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ne puun te inlalag din, nabaad e man-e ka me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Masalig kandan ka migkahi, “Migserepan sikandin te busew! Egbusawen e sikandin! Ne mania te egpammineg kew pad kandin?” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piru migkahi ka duma, “Ka etew ne egserepan te busew, kene egpakalalag te iling kayi! Egmenuwen-a te migserepan te busew te pegbawi te mata te butud?” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Miggingume e ka timpu te Sahakeen te Peghalad te Timplu diye te Hirusalim. Ne tingmaagsil te seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Miggipanew si Hisus diye te Likansu ni Sulumun diye te timplu, ");
INSERT INTO mbtNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","wey miglibulung ka me pangulu te me Hudiyu diye te kandin ne migkahi, “Ken-u nu ma igpalene-lene ka geyinawa ney? Nangeni key e nikeykew ke sikeykew naan iya ka Kristu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ne migtabak si Hisus, “Mignangenan kud e sikaniyu piru ware kew migpalintutuu keddi. Ka me kein-inuwan ne eggimuwen ku pinaahi te ngaran te Amey ku, ka egpamalehet meyitenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piru kene kew egpalintutuu puun su kene kew ne duma te me karniru ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ka keddi ne me karniru, egpekeila te laheng ku, wey neilaan ku degma sikandan, sikan naa ka egsinundul sikandan keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Egbehayan ku sikandan te umul ne ware egtamanan wey kenad e sikandan egpatey. Ne ware sabeka ne egpakaahew kandan kayi te keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Su imbehey sikandan keddi te Amey ku ne iyan labew te langun. Ne ware minsan hentew ne egpakaahew kandan puun te pegtanggu te Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne sikeddi wey ka Amey, sabeka re.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pegkarineg dutu te me pangulu te me Hudiyu, migpamurut e sikandan te me batu eyew igdegpak kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piru migkahiyan sikandan ni Hisus, “Masalig ka impapitew ku kaniyu ne meupiya ne me himu ne impeyimu keddi te Amey. Ne hendei naa rue ka igbatuwa niyu keddi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ne migtabak ka me pangulu te me Hudiyu, “Kene ney sikeykew egbatuwen puun te meupiya ne me himu, ke kene, puun te pegbaley-baley nu te Manama! Etew ke re piru egpeiling ka te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne migtabak si Hisus, “Nasulat diye te Balaud niyu ne migkahi ka Manama, ‘Me manama kew.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nakanengneng ki ne layun malehet ka nasulat diye te Kasulatan. Ne emun ke ingngaranan te Manama ne me manama seeye se me etew ne imbehayan din te lalag din, ");
INSERT INTO mbtNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ne mania te egkahi kew te imbaley-baley ku ka Manama te pegkahi ku te sikeddi ka Anak te Manama? Sikandin ka mig-alam keddiey wey impeendini a kayi te kalibutan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Purisu, kena a palintutuuwa ke ware ku himuwa ka igmeyimu keddi te Amey ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piru ke eggimu a kayi, palintutuuwa niyu ka me himu ku minsan kene kew palintutuu keddi eyew egkatahaan niyu ne ka Amey, kayi te keddiey wey sikeddi, diye degma te Amey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Egdakepen dan e man-e perem si Hisus piru nakapallahuy sikandin kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nataman, miglapas e man-e si Hisus diye te weyig te Hurdan ne migpamewutismuwan dengan ni Huwan, wey diye pad sikandin mig-uugpe. ");
INSERT INTO mbtNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Masalig ka me etew ne miggendiye te kandin wey migkahi, “Si Huwan, ware nekeyimu te me kein-inuwan, piru malehet langun ka inlalag din meyitenged te seini ne etew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Seeye naa, masalig ka me etew ne migpalintutuu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Due etew ne migderalu ne egngaranan ki Lasaru. Diye sikandin mig-ugpe te Bitanya duma te me atebey rin ne si Mariya wey si Marta. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Sikan ded ne Mariya ka eg-itis te peemut te paa te Magbebaye wey egpunasan din ded te bulbul din. Ne maama rin iya si Lasaru ka migderalu.) ");
INSERT INTO mbtNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Purisu migpanahaan te talaatebey ka Magbebaye ne si Hisus te migderalu si Lasaru ka amana ne alukuy rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te pegkarineg ni Hisus dutu, migkahi sikandin, “Kene ne kapatayan ka egpangkusan te dalu ni Lasaru. Neyitabu seini eyew egkareyrey ka Manama tenged te geem din. Ne eyew degma egkarayan ka Anak te Manama pinaahi kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Miggeyinawaan ni Hisus ensi Marta, Mariya wey si Lasaru. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Piru te pegkarineg din te migderalu si Lasaru, mig-uugpe pad si Hisus te daruwa ne aldew diye te inged ne neugpaan din. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nataman, migkahiyan din ka me hibateen din, “Eglibed ki diye te Hudiya.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ne migtabak ka me hibateen din, “Talagpanulu, ware pad iya naluhey ne egbebatuwen ka perem te me Hudiyu diye, ne kuntee, eglibed kad e man-e diye?” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ne migtabak si Hisus, “Due sapulu wey daruwa (12) ne uras te aldew ne egkaapunan. Purisu ke eggipanew ka etew te maaldew pad, kene sikandin egkasaligkat su malayag mem pad. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piru ke eggipanew sikandin te marusilem e, egkasaligkat sikandin su marusilem ma.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te pegkapenga rin te miglalag kayi, migpabulus e man-e sikandin ka eglalag, “Newulep ka alukuy ta ne si Lasaru, ne eggendiyaan ku sikandin eyew egpukawen ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ne migtabak ka me hibateen din, “Magbebaye, ke newulep sikandin, egkeulian ded sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ka igpasabut ni Hisus ne migpatey e si Lasaru, piru kahiyen te me hibateen din ne maheteng de ne newulep. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Purisu impaay-ayaran e sikandan kahii ni Hisus, “Migpatey e si Lasaru, ");
INSERT INTO mbtNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","piru amana a nahale te wara a diye te impatayan para te keupianan niyu, su egkatimtimulan ka pegpalintutuu niyu tenged te egkakita niyu. Na, eggendiyaan tad sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ne si Tumas ne mig-imuan ki ‘Seping’, migkahiyan din ka duma rin ne me hibateen, “Egduma ki kandin eyew egpakalagkes ki kandin te eggimatayan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te pegginguma ni Hisus, nahuhuran e sikandin ne neep-atan e si Lasaru ka insabal. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Me tatelu ne kilumitru ka kariyu te Bitanya puun te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne masalig ka matig-Hirusalim ne me Hudiyu ne migpanumbaley diye te engki Marta wey ki Mariya eyew egliwang kandan te namatayan te maama ran. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te pegkanengneng ni Marta ne egpalinggumaan e si Hisus, miglihawang sikandin ka egsinug-ung kandin, piru si Mariya, migpalunggehaat de diye te baley. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te nekegsinug-ung e sikandan, migkahiyan din e si Hisus, “Magbebaye, emun ke kayi ke pa perem, ware ded perem migpatey ka maama ku! ");
INSERT INTO mbtNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piru nakataha a te minsan kuntee, igbehey te Manama keykew ka minsan nekey ne egbuyuen nu diye te kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ne migkahiyan sikandin ni Hisus, “Egkeuyag ded ka maama nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Migtabak sikandin, “Nakanengneng a ne egkeuyag sikandin te katammanan ne aldew ke eg-uyahen e ka nammatey e.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ne migkahiyan sikandin ni Hisus, “Sikeddiey ka eg-uyag te nammatey e wey egbehey te umul. Minsan hentew ne egpalintutuu wey egsalig keddi, egkeuyag ded minsan egpatey sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne minsan hentew ne eg-ugpe ne egpalintutuu wey egsalig keddi, kenad e egpatey. Migpalintutuu ke naa kayi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ne migtabak sikandin, “Uya, Magbebaye. Egpalintutuu a ne sikeykew ka Kristu, ka Anak te Manama ne insaad ne eggendini te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pegkapenga ni Marta te miglalag, miglibed e sikandin wey in-umew rin si Mariya wey migkahiyan, “Duen e ka Talagpanulu wey impammitew ka nikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te pegkarineg ni Mariya, migdagdahew sikandin migsasindeg wey miglihawang ka egsinug-ung ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Te seeye ne timpu, ware pad migginguma si Hisus te lungsud, su diye pad sikandin te inged ne nasinug-ungan ni Marta.) ");
INSERT INTO mbtNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ka me Hudiyu ne diye te baley enni Mariya ne egliwang kandin, insinundul dan sikandin te nakita ran ne migdagdahew migsasindeg wey miglihawang. Kahiyen dan ne eggendiye de sikandin te insabalan wey diye egsinehew. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te pegginguma ni Mariya diye te ki Hisus, mig-usengul sikandin diye te tangkaan din wey migkahi, “Magbebaye, emun ke kayi ke pa perem, ware ded perem migpatey ka maama ku!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Te pegkakita ni Hisus ne migsinehew si Mariya wey ka me Hudiyu ne migduma kandin, migmasakit ka geyinawa rin wey nabantalan amana sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne mig-insaan din sikandan, “Hendei niyu sikandin isabal?” Ne migtabak sikandan, “Magbebaye, kema hengkayi ka wey tengtengi nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ne dutu migsinehew e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Seeye naa, migkahi ka me Hudiyu, “Pitew kew, amana rin geyinawei si Lasaru!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piru due duma ne migkahi, “Imbawian din ka mata te butud, ne mania te ware din nabalabahi ka pegpatey ni Lasaru?” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ne dutu, naamanaan e man-e nabantali si Hisus wey miggendiye sikandin te insabalan ki Lasaru ne sabeka ne sulung ne mig-eletan te batu ka gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ne migsuhu si Hisus ne igpaawe ka batu. Ne migkahi si Marta ne atebey te migpatey, “Magbebaye, mangareg e sikandin kuntee su neep-atan e sikandin ka insabal!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ne migkahiyan sikandin ni Hisus, “Migkahiyan kud e sikeykew te egkakita nu ka karesen te Manama ke egpalintutuu ka.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Seeye naa, in-awe dan e ka batu. Ne migleng-ag si Hisus diye te langit wey migkahi, “Amey, migpasalamat a keykew su indineg a nikeykew. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nakanengneng a ne egdinehen a layun nikeykew, piru inlalag ku seini puun te me etew ne seini kuntee, eyew egpalintutuu sikandan ne sikeykew ka migsuhu keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pegkapenga rin ka miglalag kayi, migpanguleyi sikandin ka migkahi, “Lasaru, lihawang ka kayi!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nataman, miglihawang e ka minatey ne nakedked pad ka paa wey me belad te hinabel wey nabukusan pad ka ulaula te manggad. Ne migkahiyan sikandan ni Hisus, “Awaa niyu ka nakabedbed kandin wey peyipanawa niyu sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Seeye se me Hudiyu ne migpanumbaley engki Mariya, masulug kandan ka migpalintutuu wey migsalig ki Hisus te pegkakita ran te innimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piru due degma duma ne miggendiye te me Parisiyu ne migpangguhud kandan meyitenged te innimu ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Purisu inlibulung te me pangulu te me talagpanubad wey te me Parisiyu ka langun ne sakup te Talaggukum te me Hudiyu. Ne migkahi sikandan, “Nekey buwa ka eggimuwen ta te seini ne etew ne eggimu te masalig ne me kein-inuwan? ");
INSERT INTO mbtNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Emun ke egparumdumaan ta sikandin ne egpabulus te eggimuwen din, egpalintutuu wey egsalig e ka langun kandin. Ne egkataman, eggendinid e ka matig-Ruma wey egguhusen dan e ka timplu wey ka nasud ta!” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Piru si Kaypas ne iyan Labew ne Talagpanubad te seeye leg-un, migkahi diye te me duma rin, “Ew, ware bes me aperu niyu? ");
INSERT INTO mbtNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ware kew bes nakanengneng ne meupiya pad ke sabeka re ne etew ka egpatey para te masulug ne me etew du te intiru ne nasud ka egkareetan?” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kene ne puun te kandin ne suman-suman seeye se inlalag din, ke kene, isip Labew ne Talagpanubad te seeye ne leg-un, intagne din ne keilangan ne egpatey si Hisus para te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne kene de man-e ne para kandan, ke kene, eyew degma egkalibulung wey egkasabeka ka me anak te Manama ne nekegsuwey-suwey te minsan hendei. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Puun dutu ne aldew, migplanu e ka me pangulu te me Hudiyu ke egmenuwen dan te peggimatey ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ne seeye naa, warad e migpeeyang-heyang miggiphipanew si Hisus diye te Hudiya, wey miggendiyad nasi te sabeka ne lungsud ne egngaranan te Ipraim ne marani te mammara ne inged ne kene egkeugpaan. Ne diye din pad mig-uugpe duma te me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te seeye ne timpu, mahaan e man-e ka Sahakeen te Peglihad te Panalihan te Manama. Masalig ka me etew puun te me bariyu ne migtakereg diye te Hirusalim eyew te pegtuman te tuluuwen dan ne peglinis te kene pad egginguma ka sahakeen. ");
INSERT INTO mbtNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne impammitew ran si Hisus te eglibulung e sikandan diye te timplu. Migmein-inseey sikandan ne egkahi, “Te kaniyu ne suman-suman, egtambung bu red sikandin te sahakeen?” ");
INSERT INTO mbtNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kunaleg te tapey bes e migsuhu ka me pangulu te talagpanubad wey ka me Parisiyu te emun ke due egpakataha ke hendei si Hisus, keilangan ne egpangguhuran sikandan eyew egkarakep dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te igkeen-em naan de ne aldew ka Sahakeen te Peglihad te Panalihan te Manama, miggendiye si Hisus te Bitanya ne mig-ugpaan ni Lasaru te in-uyag din ka napatey. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Miggilutuan dan sikandin te iglabung, wey si Marta ka migpangenat te keenen. Ne miglagpu mule si Lasaru ki Hisus te egkeen diye te lamisa. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nataman, migkuwa si Mariya te liware te litru ne peemut ne mahal ne nardu, wey mig-itisan din ka paa ni Hisus, wey impunasan din man-e te bulbul din. Ne migsekel de iya te baley ka keemut te peemut. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Piru migkahi si Hudas Iskaryuti ne sabeka te me hibateen ni Hisus ne iyan ka eg-eakal kandin, ");
INSERT INTO mbtNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mania te ware ibelegye seini se peemut te tatelu ne gatus (300) ne dinaryu, ne ka halin, igpamehey e diye te egkengaayu-ayu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Inlalag din seini, kene ne puun su neyid-u sikandin te egkaayu-ayu, ke kene, puun su takawen sikandin. Sikandin nahud ka egpeuy-uyanen te puntil ne tahuanan te seleppi, wey nalayam sikandin ne egkuwa te seleppi diye te puntil. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Piru migkahi si Hisus, “Balahara nu re due sikandin, wey kene nu balabahi ne igtahahe seini te aldew te pegsabal keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Su ka egkengaayu-ayu, layun niyu mule egkaruma, piru sikeddi, kena a nikaniyu layun egkaruma.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Due masalig ne me Hudiyu ne miggendiye te ki Hisus te pegkarineg dan te diye sikandin te Bitanya. Miggendiye sikandan, kene ne tenged de ki Hisus, ke kene, eyew egpitew degma ki Lasaru te in-uyag din ka migpatey. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Seeye naa, imbentaanan e degma te me pangulu te talagpanubad ne eggimatayan dan si Lasaru, ");
INSERT INTO mbtNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","su tenged kandin, masalig ka me Hudiyu ne nangawe diye kandan wey migpalintutuu wey migsalig e ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te seup ne aldew, nakarineg ka masalig ne etew ne migtambung te Sahakeen te Peglihad te Panalihan te Manama te eglepew si Hisus diye te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Purisu nanguwa sikandan te pakew te palmira wey insinug-ung dan sikandin wey migbalbalukan ne eggenendue, “Egdayanen ka Manama! Egpanalanginan sikandin se impeendini te Manama kanta. Egpanalanginan ka Hari te Israil!” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nakakita si Hisus te nati te asnu wey migpangudde sikandin kayi. Ne natuman ka nasulat diye te Kasulatan, ");
INSERT INTO mbtNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kene kew kaaldek me matig-Hirusalim! Egginguma ka Hari niyu, ne eg-untud te nati te asnu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Te seeye ne timpu, ware pad nakasabut dutu ka me hibateen din, piru te imbatun e sikandin, henduen pad nikandan nasuman-suman ne seeye se innimu te me etew diye te kandin, seeye bes iya ka nasulat diye te Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ka me etew ne nakaruma ki Hisus te pegpangumew rin wey peg-uyag ki Lasaru diye te sulung, iyan migpabulus ne migpangguhud ke nekey ka neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ne seeye ka puunan ne masalig ka egsinug-ung kandin tenged su nakarineg sikandan te seeye ne kein-inuwan ne innimu rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ne migmalalahey ka me Parisiyu ne eggenendue, “Tengtengi niyu naa, ware iya egkeyimu ta! Pitew kew, migsinundul e kandin ka langun ne etew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Due duma ne me Grigu ne miggendiye te Hirusalim eyew te pegsimba te Manama te timpu te sahakeen. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ne migparani sikandan ki Pilipi ne matig-Bitsayda ne sakup te Galiliya, wey migkahiyan dan sikandin, “Ahalen, egkeupian key ne egpakigkita ki Hisus.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mignangenan ni Pilipi si Andris, wey migparumeey sikandan se daruwa ka miggendiye ki Hisus eyew egnangen kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ne migtabak si Hisus, “Miggingume e kuntee ka timpu ne egmabantug ka Anak te Etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Egnangenan ku sikaniyu te malehet: ka sabeka ne beni te trigu ne kene iglebeng te tane, egkeyimu ne sabeka re iya ne beni. Piru ke iglebeng wey egpatey, egtubu seeye wey egbebehas te masalig. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Seeye se amana eggeyinawa te kandin ne umul, nasi egkawarei kayi, piru seeye se kene egkannuhun te kandin ne umul, egpakaangken te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Minsan hentew ne egpamakey keddi, keilangan ne eg-ikul keddi eyew ke hendei a, diye degma ka suluhuanen ku. Ka etew ne egpamakey keddi, eggimuwen ne mabantug te Amey ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ne migkahi pad man-e si Hisus, “Due igkabantali ku seini. Nekey buwa ka iglalag ku? Egkahiyan ku buwa ka Amey ku te kene e re egpabaybayaran? Kene, su sika iya ka innendini ku, ka eg-antus te me keyirapan te seini ne timpu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne migkahiyan din ka Amey rin, “Ame, ipakita nu ka karesen nu eyew egmabantug ka ngaran nu!” Ne due laheng ne diye egpuun te langit ne migkahi, “Impakita kud e ka karesen ku, piru igpakita ku pad man-e seini.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ka me etew ne nanasindeg diye, nakarineg te laheng wey migkahi sikandan, “Migluluhung!” Ne due degma duma ne migkahi, “Due panalihan ne migpakiglalag kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Piru migkahiyan sikandan ni Hisus, “Imparineg kaniyu ka seeye ne laheng, kene ne sikeddi ka imparineg dutu. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Seinid iya ka timpu ne eggukuman e ka me etew kayi te ampew te tane. Seinid iya ka timpu ne egdeldelen e si Meibulan ne iyan migmandu kuntee kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Due timpu keureme ne egkayawen ad puun te tane, wey egpeparaniyen ku ka langun ne etew kayi te keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Inlalag din seini eyew te pegpasabut kandan ke nekey ne klasi te kapatayan ka egpangkusan din.) ");
INSERT INTO mbtNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ne migtabak kandin ka me etew, “Sumale te Balaud ta, kene egpatey ka Kristu. Ne mania te migkahi ka te ka Anak te Etew keilangan ne egkayawen? Hentew bes seini se Anak te Etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne migtabak si Hisus, “Kene naan de egkaluhey ka malayag ne egpakigduma kaniyu. Purisu, hipanew kew taheed te malayag pad eyew kene kew egkeyingumaan te marusilem. Su ka eggipanew te marusilem, kene egpakanengneng ke hendei sikandin egpabulus. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Purisu palintutuuwa niyu wey salihi niyu ka malayag taheed te duen pad seini te kaniyu, eyew egkeyimu kew ne keet-etawan te kalayag.” Te pegkapenga rin dutu te miglalag, miggipanew e sikandin wey miggeles kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Minsan masalig e ka me kein-inuwan ne neyimu rin diye te tangkaan dan, piru ware pad iya man-e sikandan migpalintutuu wey migsalig kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Seini ka migpamalehet te ingkahi ni prupita Isayas ne eggenendue: “Magbebaye ne Manama, hentew buwad iya ka migpalintutuu te guhuren ney? Ne hentew buwad iya ka mig-ila te karesen ne impapitew nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sikan naa iya ka ware sikandan migpalintutuu su migkahi pad si Isayas: ");
INSERT INTO mbtNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Imbutud sikandan te Manama, wey impakehal rin ka me ulu ran, su kema ke egpakakita sikandan wey egpakasabut, wey eglibed e sikandin kandan eyew egpabawi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Inlalag seeye ni prupita Isayas su nakita rin ka karesen ni Hisus wey migpangguhud sikandin meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ne minsan pad due, masalig ka me pangulu te me Hudiyu ne migpalintutuu wey migsalig ki Hisus. Piru tenged te me Parisiyu, ware sikandan migpeila eyew kene dan egpaaween diye te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Su iyan dan in-awes ka pegdayan te me etew, du te pegdayan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nataman, migbalbalukan si Hisus ka miglalag ne eggenendue, “Ka egpalintutuu wey egsalig keddiey, kene de ne sikeddi ka egpalintutuuwan wey egsalihan din, ke kene, minsan degma ka migsuhu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ka nakakita keddi, nakakita degma te migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miggendini a kayi te ampew te tane isip kalayag, su eyew minsan hentew ne egpalintutuu wey egsalig keddi, kene egkahaat diye te marusilem. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ke due egpakarineg te iglalag ku wey kene egtuman kayi, kene ku sikandin eggukuman. Su wara a miggendini te ampew te tane eyew te peggukum, ke kene, eyew te pegluwas te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Seeye se egsamsamili keddi wey eggubabe te iglalag ku, seini iya se igpangguhud ku ka eggukum kandin te katammanan ne aldew! ");
INSERT INTO mbtNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Su wara a mig-uney-uney migpangguhud te keddi de ne guhuren, ke kene, ka igpepangguhud te Amey ne migpeendini keddiey ka iglalag ku wey igpangguhud ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne nakanengneng a ne ka suhu din, egpakabehey te umul ne ware egtamanan. Purisu, ka inlalag ku, impalalag naa sika keddiey te Amey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te ware pad migginguma ka aldew te Sahakeen te Peglihad te Panalihan te Manama, tapey e nataheyi ni Hisus ne miggingume e ka timpu ne eg-awe e sikandin kayi te ampew te tane wey eglibed e diye te Amey. Miggeyinawaan din amana seeye se migpamakey kandin kayi te ampew te tane, wey igpapitew rin ka geyinawa rin taman te katamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te peglabung e enni Hisus te me hibateen din, impasuman-suman e ni Meibulan si Hudas ne anak ni Simun Iskaryuti meyitenged te peg-akal ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nanengnengan ni Hisus ne due katenged din te minsan nekey, su imbehey seini te Amey diye te kandin. Ne nanengnengan din man-e ne diye din egpuun te Manama wey eglibed din ded man-e diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Seeye naa, migsasindeg sikandin diye te keenanan wey migluluung te ingkukuyumbu din wey miglilibed te tualya. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne mig-itisan din te weyig ka pelenggana wey impanlu-luan din ka me paa te me hibateen din wey impamunasan din man-e te tualya ne inlilibed din. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te neumaan din e si Simun Pidru, migkahi e si Simun, “Magbebaye, eglu-luan nu ka paa ku?” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne migtabak si Hisus, “Kuntee, kene nu pad egkasabut ka eggimuwen ku, piru wey nud e seini egkasabut.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ne migkahi si Pidru, “Kena ad iya egpalu-lu keykew te paa ku te minsan ken-u!” Piru migtabak si Hisus, “Ke kene ka egpalu-lu te paa nu, kene kud e ne hibateen sikeykew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne migkahi si Pidru, “Ke iling ma rue Magbebaye, kene de ne paa lu-lui nu su ilagkes nud degma ka ulu ku wey ka belad ku!” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Piru migkahi si Hisus, “Ka nakapamanihus e, malinis e wey kenad ne keilangan ne egpanlu-lu pad. Paa rin naan de ka eglu-luan. Sikaniyu langun, malinis e, angin e te sabeka ne duma niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Tapey e ne nanengnengan ni Hisus ke hentew ka eg-akal kandin, purisu migkahi sikandin, “Sikaniyu langun, malinis e, angin te sabeka ne duma niyu.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te pegkapenga rin te miglu-lu te me paa ran, insaluub din e man-e ka ingkukuyumbu din wey miglibed diye te keenanan. Nataman, mig-insaan din e sikandan, “Nakasabut kew red te innimu ku kaniyu? ");
INSERT INTO mbtNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Migngaranan a nikaniyu te Talagpanulu wey Magbebaye, wey eleg iya sika, su malehet iya ne sikan a iya. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ne emun ke migpanlu-luan ku ka me paa niyu te Magbebaye wey Talagpanulu e ma perem nikaniyu, eleg de iya ne egmalu-luey kew degma te me paa niyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Innimu ku sika isip panunggilingan eyew eg-ilingan niyu ka innimu ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Egnangenan ku sikaniyu te malehet: ware uripen ne labew te kandin ne ahalen, ne ware degma insuhu ne labew te migsuhu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ne kuntee te nakataha kew e te kamalehetan, egpanalanginan kew ke eggimuwen niyu seini! ");
INSERT INTO mbtNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kene ne sikaniyu langun ka egkahiyen ku ne egpanalanginan, su nekeila a te in-alam ku. Piru keilangan ne egkatuman ka nasulat te Kasulatan ne eggenendue, ‘Ka etew ne migpakigtuhen keddi, iyan egkuntere keddi.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Egpanpanayan kud sikaniyu eglalahan meyitenged kayi te ware pad seini neyitabu eyew ke egkeyitabu e seini, egpakapalintutuu kew ne ‘Sikeddi iya sikandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Egnangenan ku sikaniyu te malehet: ka minsan hentew ne egdawat te me etew ne migsuhu ku, egdawat degma keddiey, ne ka egdawat keddi, egdawat degma te migsuhu keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te pegkapenga ni Hisus dutu te peglalag, migmasakit ka geyinawa rin wey migkahi, “Egnangenan ku sikaniyu te malehet: due sabeka kaniyu ne eg-akal keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Migmatengtengey ka me hibateen din ne nalibeg ke hentew kandan ka egkahiyen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ka sabeka te me hibateen ni Hisus ne inggeyinawaan din, diye miglumpang te lenged din. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ne migtingyasan ni Simun Pidru seeye ne hibateen ne egpeinseen ki Hisus ke hentew kandan ka egkahiyen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Purisu mig-ensig sikandin diye te ki Hisus wey mig-inse, “Magbebaye, hentew bes sikandin?” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ne migtabak si Hisus, “Ke hentew seeye se egbehayan ku te paan ne igdallut ku, seeye naa ka eg-akal keddi.” Ne dutu, migkuwa sikandin te paan wey indallut din wey imbehey rin ki Hudas ne anak ni Simun Iskaryuti. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te narawat e ni Hudas ka paan, migserep e si Meibulan diye te kandin. Ne migkahiyan sikandin ni Hisus, “Mahaan ka! Himuwa nu ke nekey ka eggimuwen nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ne ware minsan sabeka diye te keenanan ne nakasabut ke mania te inlalag seeye ni Hisus diye te ki Hudas. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kahiyen te duma ne me hibateen ne insuhu de sikandin ni Hisus eyew egpabeliyen te ingkeilangan dan te sahakeen, wey ke due igpabehey ni Hisus diye te egkaayu-ayu, su iyan ma tig-uyan si Hudas te puntil ne tahuanan te seleppi. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te nakeen e ni Hudas ka paan, migdagdahew sikandin miglihawang. Ne marusilem en iya seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Te nekeyipanew e si Hudas, migkahi e si Hisus, “Kuntee, egmabantug e ka Anak te Etew, ne egmabantug degma ka Manama pinaahi kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne emun ke egmabantug ka Manama pinaahi kandin, igpabantug degma sikandin te Manama. Ne due-rue ne eggimuwen seini te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Me anak ku, kenad e egkaluhey ne egpakaruma a kaniyu. Egpammitew kew keddi piru kene niyu egkeendiyaan ka eggendiyaan ku. Ne sikan ded ka inlalag ku te me pangulu te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Egbehayan ku sikaniyu te iyam ne suhu: paheyinaweey kew. Ke immenu ku sikaniyu te eggeyinawa, iling naan ded degma rue ka pegpaheyinaweey niyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Emun ke egpaheyinaweey kew, egpakataha ka langun ne etew te sikaniyu ka me hibateen ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ne mig-inse si Pidru kandin, “Magbebaye, hendei bes ka eggendiyaan nu?” Ne migtabak si Hisus, “Kuntee, kene ke pad egpakaruma keddi te eggendiyaan ku, piru egpakasundul ke red keureme.” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mig-inse si Pidru, “Magbebaye, mania te kena a egpakaruma keykew kuntee? Andam a ne egpeyimatey para keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ne migtabak si Hisus, “Andam ke naan en iya ne egpeyimatey para keddi? Egnangenan ku sikeykew te malehet: te kene pad eg-ukale ka manuk, katatelu ad nikeykew igpahunware.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne migkahiyan sikandan ni Hisus, “Kene kew kalaggew. Palintutuu kew wey salig kew te Manama wey kayi te keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Diye te baley te Amey ku, due masalig ne sinabeng. Eggendiye a ka eg-andam te eg-ugpaan niyu. Ke kene ne malehet seini, kene ku perem egnangenan sikaniyu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne emun ke diye ad e wey egpakaandam ad te eg-ugpaan niyu, eglibed a wey eg-angayen ku sikaniyu su eyew ke hendei a, diye kew degma. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nakatulitu kew e te egbayaan peendiye te eggendiyaan ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Piru migkahiyan sikandin ni Tumas, “Magbebaye, ware key nakanengneng ke hendei ka eggendiye, purisu egmenuwen ney naa te egtulitu te dalan te eggendiyaan nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ne migtabak si Hisus, “Sikeddi ka dalan, ka kamalehetan, wey ka umul. Ware egpekeendiye te Amey ke kene egbaye keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ke nekeila kew e keddi, nekeila kew e degma te Amey ku. Ne puun kuntee, nekeila kew e kandin wey nakakita kew e kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ne migkahiyan sikandin ni Pilipi, “Magbebaye, ipapitew nu kanami ka Amey, ne eleg e sika kanami.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ne migtabak si Hisus, “Naluhey ad e ka migpakigduma kaniyu, ne ware ke bes pad nekeila keddi Pilipi? Ka nakakita keddi, nakakita degma te Amey. Purisu mania te nakakahi ke pad te igpapitew ku kaniyu ka Amey? ");
INSERT INTO mbtNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipi, ware ka migpalintutuu ne duen a te Amey, ne ka Amey kayi te keddiey? Ka me lalag ne immangguhud ku kaniyu, kene ne kayi te keddi egpuun. Ka Amey ne kayi te keddiey ka egpuunan te langun ne eggimuwen ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Palintutuu kew keddi ne duen a te Amey, ne ka Amey kayi te keddiey. Ke kene kew egpalintutuu te inlalag ku, palintutuu kew naan de keddi tenged te me kein-inuwan ne innimu ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Egnangenan ku sikaniyu te malehet: ka egpalintutuu keddi, eggimu degma te miggimu ku wey labew pad kayi ka eggimuwen din, su eggendiya ad e te Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne eggimuwen ku ka minsan nekey ne egbuyuen niyu pinaahi te keddi ne ngaran, eyew egmabantug ka Amey pinaahi te Anak. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Minsan nekey ka egbuyuen niyu keddi pinaahi te keddiey ne ngaran, eggimuwen ku iya seini.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ne migpabulus si Hisus ka migkahi, “Ke miggeyinawaan a nikaniyu, tumana niyu ka me suhu ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne egbuyu a te Amey wey egbehayan kew nikandin te lein ne Talagpangabang ne egduma kaniyu taman te katamanan. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Egngaranan seini te Panisingan te Manama, wey egpanulu kaniyu te kamalehetan. Ka me etew kayi te ampew te tane, kene egpakarawat kandin su kene dan egkakita wey ware dan nekeila kandin. Piru nekeila kew kandin su egduma-ruma sikandin kaniyu wey eg-ugpe due te kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ne kene ku sikaniyu eg-engkeran wey egkabalahad e, su egliberan ku sikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Te kene egkaluhey, kena ad egkakita te me etew kayi te ampew te tane, piru egpakakita kew mule keddi. Ne tenged su neuyag e ma, egkeuyag kew red degma. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pegginguma te sika ne aldew, egkanengnengan niyu ne duen a te Amey ku, ne sikaniyu, kayi kew te keddiey, wey duen a degma te kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ka egdawat te me suhu ku wey egtuman kayi, sika ka miggeyinawa keddi. Ne minsan hentew ne eggeyinawa keddi, eggeyinawaan te Amey ku. Ne eggeyinawaan ku degma ka sika ne etew wey igpeila ku kandin ke hentew a iya.” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ne mig-insaan sikandin ni Hudas (kene ne si Hudas Iskaryuti), “Magbebaye, mania te kayi ka te kanami egpeila ke hentew ka? Mania te kene ne diye te langun ne etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ne migtabak si Hisus, “Ka eggeyinawa keddi, egtuman te iglalag ku. Ne eggeyinawaan sikandin te Amey ku, wey eggendiye key se talaanak te kandin wey eg-ugpe diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piru ka ware miggeyinawa keddi, kene egtuman te iglalag ku. Ne ka lalag ne narineg niyu, kene ne keddiey, ke kene, kandin te Amey ne migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Miglalahan ku sikaniyu kayi taheed te dume e pad kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piru igpasubal te Amey ka Talagpangabang ne ka Panisingan te Manama. Igpeuyan din seini pinaahi te keddi ne ngaran, wey egpanuluen kew nikandin te langun-langun wey igpasuman-suman din kaniyu ka langun ne inlalag ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kene kew keipeng wey kaaldek su ka keupianan iggaat ku kaniyu. Ka keddi ne keupianan mismu ka igbehey ku kaniyu, ne kene ne iling te keupianan ne igbehey te kalibutan. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mignangenan kud sikaniyu te eggipanew a, piru eglibed e red kayi te kaniyu. Ke miggeyinawaan a nikaniyu, egkahale kew perem ne egpekeendiya a te Amey ne labew pad keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Impanpanayan kud sikaniyu te eglalag kayi te kene pad seini egkeyitabu, eyew ke egkeyitabu e seini, egpakapalintutuu kew pad amana. ");
INSERT INTO mbtNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kena ad egkaluhey ka egpakiglalag kaniyu su egpalinggumaan e si Meibulan ne talagmandu kayi te ampew te tane. Kene egdari ka geem din keddiey, ");
INSERT INTO mbtNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","piru keilangan ne egpakanengneng ka me etew kayi te ampew te tane ne miggeyinawaan ku ka Amey, purisu eggimuwen ku ka langun ne insuhu din keddi. “Ne, kuwa kid. Eggipanew kid.” ");
INSERT INTO mbtNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne migkahi si Hisus, “Sikeddiey ka malehet ne lawa te paras, ne ka Amey ku ka talagtanggu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ne ka me sugpang ku ne kene egbebehas, egtempuhen din. Ne ka sugpang ne egpamehas, egpanamperan din eyew egmalinis wey egpamehas pad te masalig. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne sikaniyu, nalinisan kew e pinaahi te lalag ne impanugtul ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ne palunggehaat kew keddiey, ne egpalunggehaat a degma kaniyu. Ka sugpang, kene seini egbebehas ke sikandin de, su keilangan ne nakasugpat ded iya te lawa. Ne iling naan ded due, kene kew egpakabebehas ke kene kew egpalunggehaat keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sikeddiey ka lawa te paras, ne sikaniyu ka me sugpang. Seeye se egpalunggehaat keddiey, wey diya a degma te kandin, iyan egpakabebehas te masalig, su ware egkeyimu niyu ke wara a. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ka etew ne egsuwey keddi, egpekeiling te sugpang ne egkatempug wey igdegpak. Ne egkahangu e seeye wey egpamuruten e wey egsilaban e. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Emun ke egpalunggehaat kew keddiey, wey due degma te kaniyu ka lalag ku, egpakabuyu kew te minsan nekey ne igkeupii niyu, wey igbehey seini kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Egkarayan ka Amey ku te me etew pinaahi te pegpamehas niyu te masalig, wey egkapamalehetan dan ne me hibateen ku sikaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Inggeyinawaan ku sikaniyu iling te peggeyinawa te Amey ku keddiey. Ne palunggehaat kew te keddi ne geyinawa. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ke egtumanen niyu ka me suhu ku, egpakapalunggehaat kew te keddi ne geyinawa, iling te pegtuman ku te me suhu te Amey ku wey nakapalunggehaat a te kandin ne geyinawa. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Inlalag ku seini kaniyu eyew egkahale kew degma iling keddi, wey eyew egkahale-gale kew amana. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne seini ka suhu ku kaniyu: peggeyinaweey kew iling te peggeyinawa ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Warad egpekeiling te dakel ne geyinawa te etew ne egpeyimatey para te me alukuy rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Me alukuy ku sikaniyu ke eggimuwen niyu ka igsuhu ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne kene kud e sikaniyu egngaranan te me uripen, su ka uripen, kene egpakataha te eggimuwen te ahalen din. Alukuy e ka igngaran ku kaniyu, su ke nekey ka narineg ku puun te Amey ku, sikan ded degma ka innangen ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kene ne sikaniyu ka mig-alam keddi, ke kene, sikeddi ka mig-alam kaniyu. Ne in-alam ku sikaniyu eyew egpangipanew wey egpamehas te masalig ne behas ne kene egkatebas. Ne puun due, minsan nekey ne egbuyuen niyu te Amey pinaahi te keddi ne ngaran, igbehey rin kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Seini ka igsuhu ku kaniyu: peggeyinaweey kew. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ke egdumutan kew te me etew kayi te ampew te tane, sumsumana niyu ne sikeddiey ka an-anayan ne indumutan dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ke iyan niyu eg-ikulen ka me etew kayi te ampew te tane, eggeyinawaan kew nikandan. Piru indumutan kew nikandan tenged su kene kew nikandan ne duma, ke kene, in-alam ku sikaniyu puun kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tantanuri niyu ka inlalag ku kaniyu: ‘Ware uripen ne labew te kandin ne ahalen!’ Ne emun ke imbaybayaran a nikandan, egbaybayaran kew degma nikandan! Ke intuman dan ka inlalag ku, egtuman degma sikandan te iglalag niyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Piru eggimuwen dan seini langun diye te kaniyu tenged keddiey, su ware sikandan nekeila te migsuhu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ware perem sale dan ke wara a miggendini wey migpakiglalag kandan, piru kuntee, kenad e sikandan egpakapanalakaye ne ware sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ka egdumut keddi, egdumut degma te Amey ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ware perem sale dan ke ware ku himuwa diye te kandan ka me kein-inuwan ne ware pad neyimu te minsan hentew, piru kuntee, nakakite e sikandan te neyimu ku, piru egdumutan key pad iya man-e nikandan te Amey ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Piru keilangan ne egkeyitabu seini eyew egkatuman ka nasulat diye te kandan ne Balaud ne eggenendue, ‘Indumutan a nikandan minsan ware eleg ne egpuunan.’ ");
INSERT INTO mbtNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Eggendini ka Talagpangabang ne iyan ka Panisingan ne diye egpuun te Amey, wey egpanulu kaniyu te kamalehetan. Ne egpamalehet sikandin meyitenged keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ne keilangan degma ne egpamalehet kew meyitenged keddi su nenekegduma kid e puun pad te an-anayan. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Egpanpanayan kud sikaniyu te eglalag kayi eyew kene kew egkatigkew wey eg-engked egpalintutuu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Egdeldelen kew nikandan te me simbaan dan, wey egginguma ka timpu ne seeye se eggimatey kaniyu egpalintutuu ne igkeupii te Manama ka eggimuwen din. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eggimuwen dan sika kaniyu su ware sikandan nekeila kanami te Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Piru impanpanayan kud sikaniyu meyitenged kayi eyew te pegginguma te timpu ne eggimuwen dan e seini diye te kaniyu, egkasuman-suman niyu ka inlalag ku. “Ware ku ilalag seini te an-anayan su dume e mem pad kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Piru kuntee, eglibed ad e diye te migsuhu keddi, ne warad iya minsan sabeka kaniyu ne mig-inse ke hendei a eggendiye. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne kuntee te ingkahiyan kud sikaniyu, nalaggew kew e amana. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piru egnangenan ku sikaniyu te malehet: egpakameupiya kaniyu ne eg-awa a kayi su emun ke kene, kene eggendini te kaniyu ka Talagpangabang. Piru ke eg-awa ad, igpasubal kud seini kayi te kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te pegginguma rin e kayi te ampew te tane, egpataheen din e ka me etew te makasesale sikandan, wey igpataha rin ne matareng a, wey ka Amey ka eggukum kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Egpataheen din sikandan te makasesale dan, su ware dan migpalintutuu wey migsalig keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ne egpataheen din sikandan ne matareng a, su eggendiye a te Amey wey kene kew e egpakakita keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne egpataheen din sikandan ne ka Manama ka eggukum, su newukuman e si Meibulan ne iyan migmandu kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Masulug pad perem ka iglalag ku kaniyu, piru egkeyirapan kew te pegsabut kayi kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Piru te pegginguma te Panisingan ne egpanulu te kamalehetan, egpanuluen kew nikandin te langun ne kamalehetan. Kene eglalag sikandin te kandin de ne pegbuut, ke kene, egpanugtulan kew nikandin te egkarineg din wey egnangenan kew nikandin ke nekey ka egkeyitabu te mewuri ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Egpabantuhen a nikandin su ka iglalag ku, sika ka iglalag din kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ka langun ne kandin te Amey ku, keddiey degma, purisu nakahi kud e ne egkuen te Panisingan te Manama ke nekey ka keddi, wey igpangguhud din kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kene egkaluhey ne kena ad egkakita nikaniyu, wey kene degma egkaluhey, egkiteen ad e man-e nikaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Due me hibateen ne migmein-inseey, “Nekey-a ka igpasabut din te ingkahi rin kanta ne kene egkaluhey ne kene tad e egkakita sikandin wey kene de degma egkaluhey ne egkiteen tad e man-e sikandin? Ne migkahi pad man-e sikandin te eggendiye kun sikandin te Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Nekey buwa mule ka igpasabut din te ‘Kene egkaluhey’? Ware tad iya seini nasabut.” ");
INSERT INTO mbtNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nakanengneng si Hisus ne egkeupian sikandan ne eg-inse kandin, purisu migkahiyan din sikandan, “Egmeg-in-inseey kew meyitenged te ingkahi ku ne kene egkaluhey ne kena ad egkakita nikaniyu, ne kene degma egkaluhey ne egkiteen ad e man-e nikaniyu? ");
INSERT INTO mbtNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Egnangenan ku sikaniyu te malehet: egsinehew kew wey egpandalawit, piru egkahale mule ka me etew. Piru ka pegkalaggew niyu egkaliwanan sika te kahalaan. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iling te sabeka ne malitan ne egbaletikan, egkalaggew sikandin su miggingume e ka timpu ne egkalasey rin e. Piru te peglesut e te bate, egkalingew e sikandin te pegkalasey rin, su egkahale e sikandin te neetew e ka anak din kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iling ded degma ka egkeyitabu kaniyu: kuntee, egkalaggew kew, piru egpakigkite e red kaniyu man-e wey egkahale kew red kangkuwa. Ne ware egpakaahew kaniyu te kahale niyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Te pegginguma te sika ne aldew, kenad ne keilangan ne eg-inse kew pad keddi te minsan nekey. Egnangenan ku sikaniyu te malehet: minsan nekey ne egbuyuen niyu diye te Amey pinaahi te keddi ne ngaran, igbehey rin sika kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ne taman kuntee, ware kew pad nakabuyu kandin te minsan nekey pinaahi te keddi ne ngaran. Buyu kew eyew egpakarawat kew, ne eyew egkahale-gale kew pad. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Inlalag ku seini kaniyu pinaahi te me panunggilingan. Piru egginguma ka timpu ne kena ad eglalag te me panunggilingan, ke kene, igpaayad-ayad kud igpasabut kaniyu ka meyitenged te Amey. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te peggingume e te sika ne aldew, eg-uney-uney kew e egbuyu te Amey pinaahi te keddi ne ngaran. Kenad e ne sikeddi pad ka egbuyu diye te Amey para kaniyu, ");
INSERT INTO mbtNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","su ka Amey mismu ka miggeyinawa kaniyu. Inggeyinawaan kew nikandin su inggeyinawaan e ma nikaniyu wey migpalintutuu kew ne diya a migpuun te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Diya a migpuun te Amey wey miggendini a te ampew te tane, ne kuntee, eg-awa ad kayi te ampew te tane wey eglibed a diye te Amey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ne migkahiyan sikandin te me hibateen din, “Te, impaayad-ayad nud e te eglalag ka guhuren nu wey kenad e ne pinaahi te panunggilingan. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nakanengneng key e kuntee ne nakataha ka te langun. Su ke due eg-inse keykew, tapey nud e nanengnengi ke nekey ka ig-inse keykew. Sikan naa ka migpalintutuu key e ne diye ka migpuun te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ne migtabak si Hisus diye te kandan, “Migpalintutuu kew e kuntee? ");
INSERT INTO mbtNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piru egginguma ka timpu, ne kuntee miggingume en iya, ne egmemekegsuwey-suwey kew ka egpanguli, wey eg-engkeran ad nikaniyu. Piru kena a egpakasabsabeka su due ka Amey ne duma ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inlalag ku seini kaniyu eyew due keupianan niyu pinaahi te pegsabeka niyu keddiey. Egpaantusen kew kayi te kalibutan, piru pakannekal kew su natalu kud e seini!” ");
INSERT INTO mbtNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Te nakapenge e si Hisus ka miglalag kayi, migleng-ag e sikandin diye te langit wey migkahi, “Ame, miggingume e ka timpu. Ipabantug nud ka Anak nu eyew egbantuhen ka degma te Anak. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Su imbehayan nu sikandin te katenged ne egmandu te langun ne etew eyew egkabehayan din te umul ne ware egtamanan ka langun ne imbehey nu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Seini ka umul ne ware egtamanan: ne ka me etew eg-ila keykew te sikeykew re ka sabsabeka ne malehet ne Manama, wey eg-ila degma ki Hisu Kristu te insuhu nu. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Impabantug ku sikeykew kayi te ampew te tane tenged su napengaan kud ka impeyimu nu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Purisu kuntee Ame, ipabantug a due te tangkaan nu. Ibehey nu keddi ka kabantug ne keddiey dengan te timpu ne dume e pad keykew, ka timpu ne ware nu pad himuwa ka kalibutan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Impeila kud sikeykew diye te me etew ne imbehey nu keddiey ne impangangey nu puun te kalibutan. Sikandan, keykew dengan, ne imbehey nud keddi, wey intuman dan ka me suhu nu. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne kuntee, nakanengneng e sikandan te ka langun ne imbehey nu keddi, diye egpuun te keykew. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ke nekey ka impanulu nu keddi, sikan ded degma ka impanulu ku kandan wey indawat dan seini. Nanengnengan dan man-e ne malehet ne diya a migpuun te keykew, wey migpalintutuu sikandan ne sikeykew ka migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Eg-ampu e pad kandan. Ne kene ne langun ne etew kayi te ampew te tane ka eg-ampuan ku, ke kene, seeye de se me etew ne imbehey nu keddi tenged su keykew sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ka langun ne keddiey, keykew, ne ka langun ne keykew, keddiey degma. Ne impabantug a nikandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne kuntee, eggenduen ad e te keykew. Kena ad e kayi te ampew te tane, piru sikandan, kayi pad. Matulus ne Amey, bantayi nu sikandan pinaahi te geem te ngaran nu ne imbehey nu degma keddi, eyew egkasabeka sikandan langun iling kanta te sabeka re! ");
INSERT INTO mbtNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taheed te dume e pad kandan, imbantayan ku sikandan pinaahi te geem te ngaran nu ne imbehey nu keddi. Imbantayan ku sikandan ne ware minsan sabeka kandan ne nalaag angin e te seeye se egkalaag iya eyew egkatuman ka Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ne kuntee, eggenduen ad te keykew, ne seini inlalag kud e kandan taheed te kayi e pad te ampew te tane eyew egkahale-gale degma sikandan iling keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Impanengneng kud e kandan ka lalag nu wey indumutan e sikandan te me etew kayi te ampew te tane, su iling e sikandan keddi te kenad ne duma te me etew kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kena a eg-ampu ne egkuen nud e sikandan kayi te kalibutan, ke kene, bantayi nu re sikandan puun ki Meibulan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iling degma sikandan keddiey te kenad e ne duma pad te me etew kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Matulusa nu sikandan pinaahi te kamalehetan; ne sika iya se lalag nu ka kamalehetan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Insuhu ku sikandan diye te me etew iling te pegpeendini nu keddi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Igbehey ku keykew ka keddi ne lawa para kandan, eyew sikandan, egpakabehey iya degma te umul ran diye te keykew. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kene ne sikandan de se imbehey nu keddi ka mig-ampuan ku, ke kene, seeye degma se egpalintutuu wey egsalig keddi pinaahi te pegpanulu dan. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mig-ampu a ne egkasabeka perem sikandan langun. Ame, egkasabeka perem sikandan kayi te kanta, iling keykew te kayi te keddiey wey sikeddi ne due degma te keykew. Egkasabeka perem sikandan eyew egpalintutuu ka langun ne etew kayi te ampew te tane ne sikeykew ka migsuhu keddi! ");
INSERT INTO mbtNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Imbehayan ku sikandan te kabantug ne iling te kabantug ne imbehey nu keddi, eyew egkasabeka sikandan iling kanta te sabeka re. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sikeddiey, diye te kandan, ne sikeykew kayi te keddi eyew egkasabeka iya sikandan. Ne puun dutu, egpakanengneng ka langun ne etew kayi te ampew te tane te sikeykew ka migsuhu keddi, wey eyew egkatahaan dan ne inggeyinawaan nu sikandan iling te peggeyinawa nu keddiey. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ame, egkeupian a ne sikandan se imbehey nu keddiey, egpakaruma degma keddi ke hendei a, eyew egpakakita sikandan te karesen ku ne imbehey nu keddi, su inggeyinawaan e ma nikeykew minsan ware pad himuwa ka kalibutan! ");
INSERT INTO mbtNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amey ne matareng, ware nekeila keykew ka me etew kayi te ampew te tane, piru nekeila a mule keykew. Ne seini se me duma ku, nakataha sikandan ne sikeykew ka migsuhu keddi. ");
INSERT INTO mbtNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impeila ku sikeykew diye te kandan wey egpabulusan ku seini te egpeila eyew egkarawat dan degma ka geyinawa ne iling te geyinawa nu keddi, wey eg-ugpa a degma diye te kandan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te nakapenge e si Hisus ka mig-ampu, miggipanew e sikandin duma te me hibateen din wey miglapas te beuhan ne egngaranan te Kidrun. Ne due pamulaan te seeye ne inged wey miggendiye sikandan te seeye ne pamulaan. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ne si Hudas ne mig-akal ki Hisus, nakatulitu dutu, su malasi sikandan eglibulung te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Purisu miggendiye si Hudas te pamulaan ne migduruma te me sundalu wey ka duma ne me talagbantey te timplu ne insuhu te me pangulu te talagpanubad wey te me Parisiyu. Nanguyan sikandan te me ganse wey me sulu wey me panganiban. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nakanengneng si Hisus ke nekey ka egkeyitabu kandin, purisu insinug-ung din sikandan ne migkahi, “Hentew-a ka egpammitawen niyu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ne migtabak sikandan, “Si Hisus ne matig-Nasarit.” Ne migkahi si Hisus, “Sikeddi iya.” Ne si Hudas ka mig-eakal kandin, diye iya degma. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te pegkahi ni Hisus te sikandin iya ka egpammitawen dan, mig-isues sikandan wey nenapeled diye te tane. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mig-abayan e man-e insei sikandan ni Hisus ke hentew-a ka egpammitawen dan. Ne migtabak sikandan, “Si Hisus ne matig-Nasarit.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ne migkahi si Hisus, “Migkahiyan kud e sikaniyu te sikeddi iya si Hisus. Ne emun ke sikeddi ka egpammitawen niyu, peyipanawa niyu re seini se me duma ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Inlalag seini ni Hisus su eyew egkatuman ka ingkahi rin ne eggenendue, “Ame, ware minsan sabeka kandan te imbehey nu keddi ne egkalaag.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ne si Simun Pidru due kampilan din. Inggulabut din seini wey intibbas din e ka uripen te Labew ne Talagpanubad, ne natamped e ka kawanan ne talinga te uripen. Egngaranan ki Malku ka uripen. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ne migkahiyan ni Hisus si Pidru, “Ilipi nu ka kampilan nu. Kahiyen nu ne kene ku eg-inumen ka tahu te ubab ne imbehey keddi te Amey ku?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nataman, inderakep e si Hisus wey imbebaku e te me sundalu duma te kepitan dan, wey te me Hudiyu ne talagbantey te timplu. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Miggun-aan dan pad uyana sikandin diye te ki Anas ne anuhang ni Kaypas ne iyan Labew ne Talagpanubad te seeye ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ne si Kaypas iya ka migtambag te me pangulu te me Hudiyu ne meupiya pad ke sabeka re ne etew ka egpatey para te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Migsinundul ki Hisus si Simun Pidru wey ka sabeka ne hibateen. Ne ka seeye ne hibateen, neilaan te pangulu te talagpanubad diye te timplu, purisu nakaseled sikandin duma ki Hisus diye te lama te baley te pangulu te talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piru diye de migpalunggehaat si Pidru te lihawangan ne marani te gumawan te alad. Nataman, miglibed e man-e miglihawang ka se sabeka ne hibateen ne neilaan te pangulu te talagpanubad wey migpakiglalag te malitan ne migtetameng te gumawan. Nataman, impaseled din e si Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ne migkahiyan si Pidru te malitan ne diye te gumawan, “Kema ke sabeka ka ne hibateen te sika ne etew?” Ne migtabak si Pidru, “Kene ne!” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Maagsil te seeye ne timpu purisu migtetemeg ka me uripen wey ka me talagbantey, ne mig-alungut sikandan ka migmanasindeg ne egginarang. Ne migsasindeg degma si Pidru wey migdangdang kandan ka egginarang. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ne dutu, mig-insaan e te Labew ne Talagpanubad si Hisus meyitenged te me hibateen din wey te pegpanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne migtabak si Hisus, “Kene ne heles ka pegpanulu ku te me etew su diya a migpanulu te me simbaan wey diye te timplu ne libulunganan te langun ne Hudiyu. Ware impanulu ku te heles de. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mania te iyan a eg-insaan nikaniyu? Insei niyu ka nakarineg keddiey su nakataha sikandan te inlalag ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te peglalag ni Hisus kayi, intagpi sikandin te sabeka ne talagbantey ne diye te lenged din, wey migkahiyan sikandin, “Mania te eg-ilingen nu due te egtabak ka Labew ne Talagpanubad?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ne migtabak si Hisus, “Emun ke nakalalag e ma te kene ne eleg, tew ki la ipawangal-wangal nud kuntee kayi. Piru ke eleg ma ka inlalag ku, mania te intagpi a nikeykew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nataman, impeuyan e ni Anas si Hisus ne nabaku de due diye te ki Kaypas ne Labew ne Talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Te seeye ne timpu, migsasindeg pad si Pidru ka egginarang, wey mig-insaan sikandin te me etew, “Kene ka ne sabeka ne hibateen te sika ne etew?” Piru migpahunware si Pidru ne migkahi, “Kene ne!” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nataman, due sabeka ne uripen te Labew ne Talagpanubad ne karumaan te etew ne intibbas ni Pidru se talinga. Ne migkahi sikandin, “Hendue te sikeykew ma iya seeye se nakita ku ne duma rin diye te pamulaan?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ne dutu, migpahunware e man-e si Pidru, ne due-rue ne mig-ukale ka manuk. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nataman in-uyan dan e man-e si Hisus puun te baley ni Kaypas peendiye te palasyu te gubirnadur te pegkamaselem e. Ne ware migseled diye te palasyu ka me Hudiyu su egpakasupak sikandan te tuluuwen dan, su emun ke egseled sikandan te baley te kene ne Hudiyu, eg-isipen sikandan ne malindit wey kene egpakakeen te iglabung te Sahakeen te Peglihad te Panalihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Purisu, iyan e miglihawang si Pilatu wey mig-inse kandan, “Nekey-a ka igsumbung niyu meyitenged te seini ne etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ne migtabak sikandan, “Kene ney perem eg-uyanen kayi te keykew ka seini ne etew ke ware nakasale.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne migkahiyan sikandan ni Pilatu, “Kua niyu red sikandin wey sikaniyud e ka eggukum kandin sumale te kaniyu ne balaud.” Ne migtabak ka me pangulu te me Hudiyu, “Piru ware katenged ney te me Hudiyu ne eggimatey te minsan hentew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Neyitabu seini eyew egkatuman ka ingguhud ni Hisus ke nekey ne klasi te kapatayan ka egpangkusan din.) ");
INSERT INTO mbtNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nataman, miglibed e man-e migseled si Pilatu diye te palasyu wey in-umew rin si Hisus wey mig-insaan, “Sikeykew iya ka Hari te me Hudiyu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ne migtabak si Hisus, “Keykew naa iya sika ne inse, wey ke ingguhuran ke re te duma meyitenged keddi?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ne migtabak si Pilatu, “Mania, kahiyen nu buwa ne Hudiyu a? Iyan mig-uyan keykew kayi te keddi ka duma nu ne me Hudiyu wey ka me pangulu te talagpanubad. Nekey-a ka neyimu nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ne migtabak si Hisus, “Ka peghari ku, kene ne kayi te kalibutan. Su emun ke kayi pa seini te kalibutan, egpakig-ehet e perem ka me etew ku eyew kena a egkarakep te me pangulu te me Hudiyu. Piru kene iya ne kayi te kalibutan ka peghari ku!” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ne puun due, mig-inse e man-e si Pilatu diye te kandin, “Hari ka iya?” Ne migtabak si Hisus, “Ingkahi nud en iya ne Hari a. Neetew a wey miggendini te ampew te tane para te sabeka ne katuyuan ne pegpamalehet te kamalehetan. Ka langun ne diye te kamalehetan, egpammineg keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ne mig-inse e man-e si Pilatu diye te kandin, “Nekey-a ka kamalehetan?” Nataman, miglihawang e man-e si Pilatu wey migkahi diye te me Hudiyu, “Ware nakita ku ne sale te seini ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Piru nabatasan niyu ne due sabeka ne pinirisu ne eglekaan ku te tagse Sahakeen te Peglihad te Panalihan te Manama. Na, igkeupii niyu naa ne eglekaan ku ka Hari te me Hudiyu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ne migbalbalukan sikandan ka migtabak, “Kene ne sikandin! Si Barabas ka igkeupii ney!” (Si Barabas, sabeka ne ribildi.) ");
INSERT INTO mbtNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nataman, impakuwa ni Pilatu si Hisus wey impalampesan. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne miggimu ka me sundalu te kuruna ne duhi wey impakuruna ran ki Hisus. Impakukuyumbu dan man-e sikandin te kumbale ne ubi se batek, ");
INSERT INTO mbtNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","wey migpasubsubaley sikandan ka egparani kandin ne migkahi, “Egmabantug ka Hari te me Hudiyu!” wey impanagpi dan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ne miglihawang e man-e si Pilatu wey migkahi diye te me etew, “Kuntee, eg-uyanen kud sikandin kayi te kaniyu eyew egpakanengneng kew te ware nakita ku ne sale din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ne dutu, miglihawang e si Hisus ne migkukuruna te duhi wey ingkukuyumbu te kumbale ne ubi se batek. Ne migkahi si Pilatu diye te kandan, “Pitawa niyu! Seinid e sikandin!” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te pegkakita kandin te me pangulu te talagpanubad wey te me talagbantey, migbalbalukan sikandan ka migkahi, “Ilansang nu sikandin te krus! Ilansang nu sikandin!” Ne migkahiyan sikandan ni Pilatu, “Ke iling ma rue, sikaniyu ka egkuwa kandin wey eglansang te krus, su ware mule nakita ku ne sale din.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ne migtabak sikandan, “Due kanami ne balaud, ne sumale te sika ne balaud, eleg sikandin ne eggimatayan su migkahi sikandin te Anak din kun te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te pegkarineg ni Pilatu dutu, nasi de iya man-e sikandin naaldek. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Purisu, miglibed e man-e migseled sikandin diye te palasyu wey mig-inse ki Hisus, “Hendei ke bes iya migpuun?” Piru ware migtabak si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Purisu migkahiyan sikandin ni Pilatu, “Mania te kene ka egtabak keddi? Ware ke buwa nakataha te due katenged ku te pegpaleke keykew wey te pegpalansang degma keykew te krus?” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ne migtabak si Hisus, “Egkeyimu nu re sika keddi tenged su sika ne katenged, imbehey te Manama keykew. Purisu iyan dakel se sale te etew ne migbehey keddi diye te keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Te pegkarineg ni Pilatu kayi, migpakannekal sikandin ne eglekaan perem si Hisus. Piru migbalbalukan ka me pangulu te me Hudiyu, “Emun ke eglekaan nu sikandin, kene ke naa ne alukuy te Impiradur! Su ka minsan hentew ne egpaari-Hari, kuntere te Impiradur!” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te pegkarineg dutu ni Pilatu, mig-uyan din e si Hisus diye te lihawangan wey migpinnuu sikandin diye te pinnuuwan te talaggukum diye te plasa ne migngaranan, “Plasa ne Neelin ne Batu.” (Egngaranan seini te me Hibruwanen te “Gabata.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ne seeye, mahaan e egkeudtu wey dispiras e te Sahakeen te Peglihad te Panalihan te Manama. Ne migkahi e si Pilatu diye te me Hudiyu, “Seinid e ka Hari niyu!” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piru migbalbalukan sikandan ka migtabak, “Himatayi nu sikandin! Himatayi nu! Ilansang nu sikandin te krus!” Ne mig-insaan sikandan ni Pilatu, “Iyan niyu igkeupii ne iglansang ku te krus ka Hari niyu?” Ne migtabak ka me pangulu te me talagpanubad ne migkahi, “Ware Hari ney, ka Impiradur de!” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Seeye naa, imbehey e ni Pilatu si Hisus diye te kandan eyew iglansang te krus. Purisu in-uyan dan e si Hisus, ");
INSERT INTO mbtNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","wey miglihawang sikandan te siyudad. Ne impatiang dan sikandin te krus, wey in-uyan dan sikandin diye te inged ne egngaranan te “Angkal.” (Egngaranan seini te me Hibruwanen te “Gulguta.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne diye dan e ilansang sikandin te krus. Ne due degma daruwa ne etew ne inlansang duma kandin. Ka sabeka diye te igkahibang din, ka dangeb diye te igkakawanan din. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ne migsusulat si Pilatu te keretula ne impatahu diye te krus ni Hisus. Seini ka nasulat: “Si Hisus ne matig-Nasarit, ka Hari te me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ne masalig ka me Hudiyu ne nakabasa dutu su marani re te siyudad ka inged ne miglansangan ki Hisus. Ne nasulat pad iya man-e seeye te Hibruwanen, te Latin, wey te Grigu ne me linalahan. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ne migkahiyan si Pilatu te me pangulu te talagpanubad te me Hudiyu, “Kene ne ‘Hari te me Hudiyu’ ka isulat nu, ke kene, ‘Migkahi ka seini ne etew te sikandin kun ka Hari te me Hudiyu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piru migtabak si Pilatu, “Ka nasulat kud, kene kud e egliwanan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te nakapenge e ka me sundalu te eglansang ki Hisus te krus, ingkuwa ran e ka me kumbale din wey imbaad dan te hep-at eyew due baad te tagse sundalu. Ne ingkuwa ran e man-e ka malayat ne kumbale ni Hisus, piru ware mule teyi dutu. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ne migmanangnangeney ka me sundalu, “Kene te re eggisien seini, ke kene, egpintut-pintut ki re ke hentew ka egpakakamuney kayi.” Neyitabu seini su eyew egkatuman ka nasulat te Kasulatan ne migkahi, “Imbaad-baad dan ka me kumbale ku, wey migpapinpintutey ke hentew ka egpakakuwa te kumbale ku ne malayat.” Ne sika iya ka innimu te me sundalu. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ne diye migsasindeg te marani te krus ni Hisus ka iney rin wey ka atebey te iney rin, wey si Mariya ne asawa ni Kliyupas, wey si Mariya Magdalina. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te pegkakita ni Hisus te iney rin wey te inggeyinawaan din ne hibateen din ne migsasindeg dutu te marani rin, migkahiyan din e ka iney rin, “Ine, sikandin e anaka nu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne migkahiyan din e man-e seeye se hibateen, “Sikandin e inaya nu.” Ne puun de dutu, indume e te seeye ne hibateen si Mariya wey impalemung din e diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nanengnengan ni Hisus ne napenge e ka langun, wey migkahi sikandin, “Nammaraan a,” eyew egkatuman ka Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ne due yahung diye ne napenu te maperes ne binu. Seeye naa, in-eled dan dutu ka egpekeiling te kutsun wey intagkes dan diye te sugpang te isupu wey impasupsup dan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te nakaheram e si Hisus te binu, migkahi e sikandin, “Napenge e.” Nataman, mig-unduk sikandin wey nabigtawan e. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aldew seeye te pegpangandam te Peggimeley. Ne kene egkeupian ka me pangulu te me Hudiyu ne egkahaat diye te krus ka me lawa te me minatey tenged su ka seup ne aldew, Aldew e te Peggimeley ne amana ne impurtanti diye te me Hudiyu. Purisu mighangyu sikandan ki Pilatu ke egkaayun ne egpanggepuen ka me paa te me etew ne inlansang te krus eyew mahaan egpatey wey eg-aween e. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Purisu nangendiye ka me sundalu wey impanggepu dan ka me paa te daruwa ne etew ne inlansang duma ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piru te pegginguma ran diye te ki Hisus, nakita ran ne migpatey e sikandin, purisu ware dan e gepua ka paa rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piru ka sabeka te me sundalu, impilak din te deldeg din ka kakiliran ni Hisus, wey due-rue ne migtihis ka langesa wey weyig. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Malehet seini ne neyitabu su due nakakita kayi, wey migpamalehetan din seini. Nakanengneng sikandin te malehet ka guhuren din, wey ingguhud din seini eyew egpalintutuu kew degma.) ");
INSERT INTO mbtNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Neyitabu seini su eyew egkatuman ka nasulat diye te Kasulatan ne eggenendue, “Ware minsan sabeka ne tul-an din ne egkahepu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne duen pad man-e nasulat diye te Kasulatan ne eggenendue, “Egtengtengan dan ka etew ne impilak dan.” ");
INSERT INTO mbtNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Te pegkapenga kayi, imbuyu e ni Husi ne matig-Arimatiya ka lawa ni Hisus diye te ki Pilatu. (Si Husi, sabeka ne hibateen ni Hisus piru te heles de su egkaaldek sikandin te me pangulu te me Hudiyu.) Ne intuhutan ni Pilatu si Husi, purisu miggendiye sikandin wey ingkuwa rin e ka lawa ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Migduma degma kandin si Nikudimu, ka migpakigkita ki Hisus te sabeka ne marusilem. Mig-uyan sikandin te peemut ne me lalimma ne pulu (50) ne kilu ne migsewuhan te mira wey aluyi. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nataman, migkuwa ran e te daruwa ka lawa ni Hisus wey imbukusan dan te hinabel ne migtahuan te peemut. Seini ka batasan te me Hudiyu ke eglebeng te minatey. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne due sabeka ne pamulaan ne diye te miglansangan ki Hisus, wey due iyam pad ne sabalanan ne ware pad nasabali. ");
INSERT INTO mbtNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ne puun su Aldew e seeye te Pegpangandam te Peggimeley te me Hudiyu, wey marani re degma ka sabalanan, diye dan e isabal ka lawa ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Te sikan pad egkaliwaswas te aldew te Duminggu, miggendiye si Mariya Magdalina te inlungahan ne dalama ne insabalan ki Hisus. Te pegtengteng din, nalilid e ka batu ne in-elet dutu te gumawan te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Seeye naa, migpallahuy sikandin peendiye engki Simun Pidru wey te seeye se hibateen ne miggeyinawaan ni Hisus. Ne migkahiyan din sikandan, “Ingkuwa ran e ka Magbebaye diye te insabalan, ne ware key nakataha ke hendei ran e sikandin itahu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Purisu miggendiye te insabalan si Pidru wey ka sabeka ne hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Namallahuy sikandan se daruwa, piru meiyal ne egpallahuy ka duma ni Pidru, purisu iyan nekewun-a diye te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te pegginguma rin diye, mig-unduk sikandin ka egseilang wey nakita rin ka hinabel, piru ware sikandin migseled. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ne miggingume e degma si Simun Pidru ka migsinundul kandin, piru migleus sikandin migseled diye te insabalan. Ne nakita rin dutu ka me hinabel, ");
INSERT INTO mbtNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","wey ka manggad ne imbukus te ulu ni Hisus. Nalupi e seini wey nakasuwey te me hinabel. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne migseled e degma ka sabeka ne hibateen ne nekewun-a ne migginguma diye te insabalan, wey nakakita degma sikandin dutu wey migpalintutuu ne neuyag e si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nakapalintutuu e sikandan minsan ware dan pad nasabut ka nasulat te Kasulatan ne egkeuyag si Hisus.) ");
INSERT INTO mbtNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nataman, mig-uli e ka daruwa ne hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Si Mariya mule, migsasindeg sikandin diye te lihawangan te insabalan ka egsinsinehew. Te egkalihet sikandin ne egsinehew, mig-unduk sikandin ka egseilang diye te insabalan. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ne due nakita rin dutu ne daruwa ne panalihan te Manama ne migkukumbale te maangkag ne diye migpinnuu te migtahuan te lawa ni Hisus. Ka sabeka diye migpinnuu lenged te keulunanan din wey ka dangeb diye lenged te kasikuwayan. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne mig-insaan dan sikandin, “Mengeatebey, mania te egsinehew ka?” Ne migtabak si Mariya, “Uya, su ingkuwa ran e ka lawa te Magbebaye ku, wey wara a nakataha ke hendei ran e sikandin itahu!” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te pegkapenga rin te miglalag, migbalikid e sikandin wey nakita rin si Hisus ka migsasindeg, piru ware sikandin nekeila ne si Hisus bes seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ne mig-insaan sikandin ni Hisus, “Mengeatebey, mania te egsinehew ka? Hentew bes ka egpammitawen nu?” Kahiyen ni Mariya ne talagtanggu seeye te me pinamula diye, purisu migkahiyan din, “Emun ke sikeykew ka migkuwa kandin, nangeni a ke hendei nu sikandin itahu su egkuen ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ne migkahiyan sikandin ni Hisus, “Mariya!” Ne migtangke si Mariya diye te ki Hisus ne migkahi te Hibruwanen ne linalahan, “Rabuni!” (ka igpasabut, “Talagpanulu.”) ");
INSERT INTO mbtNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ne migkahiyan sikandin ni Hisus, “Kene ka gen-gen keddi su ware e pad nabatun diye te Amey. Piru hendiyei nu ka me suled ku wey panugtuli nu sikandan te eggendiya ad te dibabew diye te Amey ku ne Amey niyu red, wey Manama ku ne Manama niyu red degma.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Purisu miggendiyaan e ni Mariya Magdalina ka me hibateen wey impanugtulan din sikandan te nakita rin ka Magbebaye. Ne ingguhuran din man-e sikandan te inlalag ni Hisus diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te pegkamarusilem e te seeye ne Duminggu, miglibulung ka me hibateen diye te sinabeng wey migsiraduwan dan ka me gumawan su naaldek sikandan te me pangulu te me Hudiyu. Nataman, miglepew e si Hisus wey migsasindeg diye te taliware dan wey migkahi, “Ka keupianan egduma kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Te pegkapenga rin te eglalag, impapitew rin e kandan ka me belad din wey ka kakiliran din. Ne nahale-gale ka me hibateen te nakakita sikandan te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne migkahiyan e man-e sikandan ni Hisus, “Ka keupianan egduma kaniyu. Insuhu a te Amey kayi, ne egsuhuen ku degma sikaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne inniyupan din e sikandan wey migkahiyan, “Dawata niyu ka Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Emun ke egpasayluwen niyu ka minsan hentew te me sale dan, impasaylu e sikandan. Piru ke kene niyu egpasayluwen, ware sikandan pasayluwa.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Te pegginguma ni Hisus, ware diye si Tumas ne egngaranan ki Seping, ka sabeka te sapulu wey daruwa (12) ne hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Purisu migpangguhuran naan de sikandin te duma ne me hibateen te nakita ran ka Magbebaye. Piru migkahiyan sikandan ni Tumas, “Angin e ke egkakita ku ka naye te lansang diye te belad din wey egkatiyuk ku te kemel ku ka imbaye te lansang, wey ke egkasamsam ku ka pali diye te kakiliran din, human e naa egpalintutuu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Te egsenge simane e ka miglihad, miglibulung e man-e ka me hibateen diye te sinabeng, ne dutu, duma ran e si Tumas. Nasiraduwan ka me gumawan piru miglepew e man-e si Hisus wey migsasindeg diye te taliware dan ne migkahi, “Ka keupianan egduma kaniyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne ingkahiyan din si Tumas, “Hendini ka, tengtengi nu ka me belad ku wey tiyuka nu. Samsama nu degma ka pali kayi te kakiliran ku. Kene kad duwa-ruwa, ke kene, palintutuu kad nasi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ne migkahiyan sikandin ni Tumas, “Magbebaye ku wey Manama ku!” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ne migkahiyan sikandin ni Hisus, “Migpalintutuu ke naan e su nakakita kad e keddi? Egpanalanginan seeye se egpalintutuu minsan ware nakakita keddi!” ");
INSERT INTO mbtNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Masalig pad ka me kein-inuwan ne innimu ni Hisus ne napamalehetan te me hibateen ne ware nasulat te seini ne baseen. ");
INSERT INTO mbtNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Piru ka nasulat kayi insulat eyew egpakapalintutuu kew ne si Hisus ka Kristu ne Anak te Manama. Ne eyew pinaahi te pegpalintutuu niyu, egpakaangken kew te umul ne ware egtamanan tenged te pegsabeka niyu kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Te peglihad te pila ne aldew, migpakite e man-e si Hisus te me hibateen din diye te Lanew te Tibiryas. Iling kayi ka pegpakita rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nalibulung ensi Simun Pidru, si Tumas ne egngaranan ki Seping, si Natanail ne matig-Kana ne sakup te Galiliya, wey ka me anak ni Sibidiyu, wey duen pad daruwa ne hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne nataman, migkahiyan ni Simun Pidru ka me duma rin, “Egngengalap a.” Ne migkahi sikandan, “Egduma key keykew.” Purisu nangendiyad e sikandan wey nanguntud e te balangey. Piru warad iya neutel ran te seeye ne marusilem. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Te pegsile e te aldew, migsasindeg si Hisus diye te ilis te lanew, piru ware sikandan nekeila te sikandin bes seeye. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne migkahiyan sikandan ni Hisus, “Me suled, ware neutel niyu?” Ne migtabak sikandan, “Ware da!” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne migkahiyan din sikandan, “Iantug niyu ka biyale niyu diye te egkakawanan te balangey ne egpekeutel kew e.” Purisu in-antug dan e ka biyale dan diye te igkakawanan te balangey. Ne dutu, kene dan e egkeelehan te egganuy ka biyale dan puun su dakel amana ka migsahad. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ne migkahiyan si Pidru te hibateen ne miggeyinawaan ni Hisus, “Ka Magbebaye ma mule sika!” Te pegkarineg ni Simun Pidru ne ka Magbebaye bes seeye, insaluub din e ka kumbale ne inluung din wey miglumbuk e ka eggakap. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ka duma ne me hibateen mule, nanguntud ded sikandan te balangey ka migpeilis te lanew ne migganuy te biyale ne napenu te ngalap. Kene de amana ne mariyu sikandan te ilis te lanew su me siyam de ne pulu (90) ne mitrus ka kariyuan. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te nakahakap e sikandan, due nakita ran ne nalimud ne baha ne due intuug ne me ngalap, wey due degma paan. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne migkahiyan sikandan ni Hisus, “Uyan kew kayi te duma ne ngalap ne neutel niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Purisu mig-untud e man-e si Simun Pidru te balangey wey migganuy rin e diye te ilis te lanew ka biyale ne napenu te derakel ne ngalap ne 153 ne timman. Piru minsan dakel amana ka neutel ran, ware ded nahisi ka biyale. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nataman, migkahiyan e ni Hisus sikandan, “Apas kew e wey keen kew.” Ne ware minsan sabeka ne hibateen ne migpatagal eg-inse ke hentew sikandin su nekeila man e sikandan te sikandin ka Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ne dutu, migparani e si Hisus wey ingkuwa rin ka paan ne imbehey rin kandan. Ne ingkuwa rin degma ka ngalap ne imbehey rin man-e kandan. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ne seeye ka igkatatelu ne pegpakita ni Hisus diye te me hibateen din puun te pegkeuyag din. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te nakapenge e sikandan ka miglem-ag, mig-insaan e ni Hisus si Simun Pidru, “Simun ne anak ni Huwan, miggeyinawaan e red nikeykew subla pad te duma kayi?” Ne migtabak si Pidru, “Uya Magbebaye, nakanengneng ka te miggeyinawaan ku sikeykew.” Ne migkahiyan sikandin ni Hisus, “Tangguwa nu ka me nati ne karniru ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nataman, mig-insaan e man-e sikandin ni Hisus, “Simun ne anak ni Huwan, miggeyinawaan e red nikeykew?” Ne migtabak si Pidru, “Uya Magbebaye, nakanengneng ka te miggeyinawaan ku sikeykew.” Ne migkahiyan sikandin ni Hisus, “Tangguwa nu ka me karniru ku.” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne mig-insaan e man-e sikandin ni Hisus te igkatatelu e, “Simun ne anak ni Huwan, miggeyinawaan e red nikeykew?” Ne dutu, neenenduenan e si Pidru su katatelu e sikandin insei ni Hisus ke miggeyinawaan din naa iya. Ne migtabak si Pidru, “Magbebaye, nakanengneng ka te langun. Nakanengneng ka te miggeyinawaan ku sikeykew.” Ne migkahiyan sikandin ni Hisus, “Tangguwa nu ka me karniru ku. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Egnangenan ku sikeykew te malehet: te bate ke pad, sikeykew re ka eg-uney-uney egkukumbale wey egpekeendiye ka te minsan hendei ne igkeupii nu te eggendiye. Piru ke egkabuyag kad e, egkayawen nu naan de ka me belad nu wey lein e ka egsaluub keykew wey eg-uyanen ka diye te inged ne kene nu igkeupii te eggendiye.” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Te peglalag ni Hisus kayi, impanengneng din ke nekey ne paahi ka pegpatey ni Pidru eyew egpakareyrey sikandin te Manama.) Nataman, migkahiyan sikandin ni Hisus, “Ikul ka keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Te peglilingey ni Pidru, nakita rin ne migsinundul kandan ka hibateen ne miggeyinawaan ni Hisus. Sikandin seeye se amana ne marani ki Hisus te peglabung dan wey ka mig-inse te Magbebaye ke hentew-a ka eg-akal kandin. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Te pegkakita ni Pidru kandin, mig-inse e sikandin diye te ki Hisus, “Magbebaye, nekey ma degma ka egkeyingumaan te seini ne etew?” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne migtabak si Hisus, “Emun ke igkeupii ku ne kene sikandin egpatey taman te peglibed ku, nekey ma ka labet nu? Ikul ke re keddi!” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Purisu nekeempet ka guhuren diye te migmalintutuu ki Hisus ne kene egpatey ka seeye ne hibateen. Piru ware migkahi si Hisus ne ka seeye ne hibateen, kene egpatey, ke kene, migkahi re sikandin, “Emun ke igkeupii ku ne kene egpatey sikandin taman te peglibed ku, nekey ma ka labet nu?” ");
INSERT INTO mbtNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ne sikandin iya ka hibateen ne migpamalehet ne malehet ka langun, wey sikandin iya ka migsusulat kayi. Ne nakanengneng key te malehet ka ingkahi rin. ");
INSERT INTO mbtNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Masalig pad amana ka neyimu ni Hisus ne emun ke ig-amin igsulat, kene buwa eg-eleg kayi te ampew te tane ka me libru ne egkasulatan.");
INSERT INTO mbtNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1"," Miggeyinawaan ku ne Tiyupilu, ka an-anayan ne baseen ne insulat ku, nahuhud kud e ka langun ne innimu ni Hisus wey ka impanulu din puun te pegbunsud te himu rin ");
INSERT INTO mbtNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taman te aldew ne imbatun e sikandin diye te langit. Te ware pad sikandin batuna, impanpanayan din panulua pinaahi te Panisingan te Manama seeye se in-alam din ne eggimuwen ne me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ne puun te pegpatey rin, kamasalig pad sikandin migpakita kandan seled te hep-at ne pulu (40) ne aldew eyew te pegpamalehet ne neuyag e man-e sikandin. Nakita ran pad sikandin wey migpakiglalag pad kandan meyitenged te Peghari te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Taheed te duma ran pad si Hisus, impanagtahaan din pad sikandan te miggenendue, “Kene kew pa awe kayi te Hirusalim su tahari niyu pa ka igdasag ne insaad te Amey ku sumale te ingkahi ku kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Su si Huwan, migpamewutismu te weyig, piru pila naan de ne aldew puun kuntee ne egbewutismuwan kew e te Panisingan te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Purisu, te nalibulung e sikandan, mig-insaan dan e si Hisus, “Magbebaye, egtuhut ke naa kuntee ne sikanami se me Hudiyu ka egmandu man-e kayi te nasud te Israil?” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ne migtabak si Hisus kandan, “Ware kew tuhuti ne egpakataha meyitenged te me timpu wey me aldew ne tapey e itahahe te Amey ku, su kandin de sika ne katenged. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piru egpakarawat kew te geem ke eglene due te kaniyu ka Panisingan te Manama. Ne sikaniyu ka talagpamalehet ku diye te Hirusalim, te intiru ne inged te Hudiya wey te Samarya, wey te minsan hendei kayi te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Te nekeimpus e sikandin ka miglalag, imbatun e sikandin diye te langit taheed te namipitew sikandan kandin. Nataman, ware dan e nakita sikandin su nabunbunan e te gapun. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Te sasangan pad sikandan ne egtetengteng diye te langit te pegbatun ki Hisus, sahuhune ne due daruwa ne etew ne migsasindeg diye te lenged dan ne maangkag se me kumbale. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ne migkahi sikandan, “Matig-Galiliya, mania te egsesasindeg kew pad kayi ne egleng-ag diye te langit? Si Hisus se imbatun diye te langit, eglibed ded kayi te iling ded due ne paahi te pegbatun kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nataman, nanlibed e ka me apustulis diye te Hirusalim puun diye te Bubungan te Ulibu, me sabeka ne kilumitru ka kariyuan puun te siyudad te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Peglibed dan e diye te Hirusalim, naneled e sikandan diye te sinabeng ne hirehaanan dan ne diye te dibabew. Sikandan ensi Pidru, si Huwan, si Santiyagu, si Andris, si Pilipi, si Tumas, si Bartulumi, si Matiyu, si Santiyagu ne anak ni Alpiyu, si Simun ne ribildi, wey si Hudas ne anak ni Santiyagu. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Layun sikandan miglibulung ka egsabeka eg-ampu duma te me malitan, wey ki Mariya ne iney ni Hisus wey te me suled ni Hisus ne me lukes. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Te seeye ne timpu, migsasindeg si Pidru diye te taliware dan, me sabeka ne gatus wey daruwa ne pulu (120) sikandan langun, wey migkahi sikandin, ");
INSERT INTO mbtNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Me suled, keilangan ne egkatuman ka diye te Kasulatan ne ingkahi te Panisingan pinaahi ki Dabid. Meyitenged seini ki Hudas, ka migpanulu te me etew ne migdakep ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sabeka sikandin ne sakup te punduk ta dengan su in-alam ma eyew egbulig te himu ta.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ka seleppi ne imbayad te mareet ne himu rin, imbeli e te kamet ne neuluhan din ne nekewun-a se ulu, ne migbetu ka getek din, wey nabukayat e ka bituka rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ka langun ne matig-Hirusalim nakanengneng kayi, purisu ingngaranan dan te Akildama te kandan ne linalahan ka seeye ne kamet ne ke sikanta pa, “Ka Tane ne Imbayaran te Langesa.”) ");
INSERT INTO mbtNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Su nasulat diye te baseen ne Salmu ne miggenendue, ‘Eg-engkeran e perem ka ugpaan din, wey warad e perem eg-ugpe dutu.’ Nasulat ded man-e ne miggenendue, ‘Due perem igliwan te katungdanan din.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Purisu, keilangan ne eg-alam ki te me etew ne nakaruma-rume e kanta puun pad te duma te pad ka Magbebaye ne si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ka puun pad iya te pegpamewutismu ni Huwan taman te pegbatun e ki Hisus. Su keilangan ne egpakapamalehet sikandin duma kanta meyitenged te pegkeuyag ni Hisus.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ne nakaalam sikandan te daruwa ne me lukes: si Husi ne egngaranan ded ki Barsabas (ne egngaranan ded man-e ki Gustus), wey si Matiyas. ");
INSERT INTO mbtNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nataman, mig-ampu e sikandan, kahi ran, “Magbebaye, nakanengneng ka te pusung te langun ne etew. Purisu Magbebaye, ipapitew nu ke hentew kayi te daruwa ka in-alam nu ");
INSERT INTO mbtNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ne egkeyimu ne apustulis liwan ki Hudas, su mig-engkeran din ka sika ne himu wey miggendiye te inged ne eleg kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ne dutu, migpintut-pintut e sikandan, wey si Matiyas ka naalam dan ne igtimul kandan te apustulis ne sapulu wey sabeka (11). ");
INSERT INTO mbtNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Peggingume e te aldew ne egngaranan te Pintikustis, miglibulung e sikandan langun diye te sabeka ne baley. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ne sahuhune ne due dahing ne diye egpuun te langit ne egpekeiling te makeseg ne kalamag wey nekeempet e te baley ne inlibulungan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne nakakita sikandan te hendue te me dile te hapuy ne miglatun te tagse sabeka kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne dutu, napenu e sikandan langun te Panisingan te Manama wey nakalalag e te nakalkalasi ne me linalahan sumale te igpalalag kandan te Panisingan. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ne due mig-ugpe diye te Hirusalim ne me Hudiyu ne amana egtuman te Balaud, ne egpuun te langun ne nasud kayi te ampew te tane. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pegkarineg dan te kahulub, nalibulung e ka masalig ne etew. Ne neinu-inu sikandan langun su ka tagse sabeka kandan nakarineg te due egpakalalag te kandin ne linalahan. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Neinu-inu sikandan ne migkahi, “Matig-Galiliya ma mule seini se egmangasak! ");
INSERT INTO mbtNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mani buwa te egpakalalag sikandan te linalahan te tagse sabeka kanta? ");
INSERT INTO mbtNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Su ka kayi te kanta, due matig-Partiya, matig-Midiya, matig-Ilam, matig-Misuputamya, matig-Hudiya, matig-Kapadusya, matig-Puntu, matig-Asya, ");
INSERT INTO mbtNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","matig-Prigya, matig-Pampilya, matig-Ihiptu, wey ka diye lenged te Libya ne marani te Sirini. Ka duma kanta matig-Ruma, ");
INSERT INTO mbtNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","me Hudiyu, wey ka kene ne me Hudiyu ne neuyan te pegpalintutuu te me Hudiyu. Ne duen pad man-e matig-Krita wey matig-Arabya, ne sikanta langun, egpakarineg kandan te eglalag te kanta ne me linalahan meyitenged te kein-inuwan ne himu te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Neinu-inu ka langun wey nabenga-benga, ne migmein-inseey e sikandan ne miggenendue, “Nekey buwa seini?” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ne due duma ne egbaley-baley ne eggenendue, “Etuwey, nenewubug e sikandan!” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ne dutu, migsasindeg e si Pidru duma te sapulu wey sabeka (11) ne me apustulis wey migkahi te meemen, “Karumaan ku ne me Hudiyu, wey sikaniyu langun se mig-ugpe kayi te Hirusalim, igpasabut ku seini kaniyu ne pammineg kew naa ayad-ayad te iglalag ku. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ka seini ne me etew, ware newubug sumale te insuman-suman niyu. Kene egkengewubug ka me etew te alas nuwibi pad te maselem. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Seinid en iya ka ingkahi ni prupita Huwil, ");
INSERT INTO mbtNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Migkahi ka Manama, ‘Seini ka eggimuwen ku te katammanan ne timpu: igbehey ku te langun ne etew ka Panisingan ku. Ne ka anak niyu ne me lukes wey me malitan, egpangguhud e te igpanengneng te Manama kandan, ne ka me kanakan niyu, egmakakite e te igpakita te Manama, ne ka me buyag e ne me lukes, egmakataheinep. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uya, minsan ka me uripen ku ne me lukes wey me malitan, egbehayan ku te keddiey ne Panisingan te seeye ne timpu, wey egpangguhud e sikandan te igpanengneng te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eggimu a te me kein-inuwan sika te aw-awangan wey kayi te tane: ne due me langesa, me hapuy, wey amana ne dakel ne ebel, ");
INSERT INTO mbtNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","egpaddusilem ka aldew, ne ka bulan egmalalab iling te langesa te kene pad egginguma ka amana ne mateles ne aldew te peglibed te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne seeye se egpangananey te Magbebaye, egkaluwas.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Matig-Israil, pammineg kew! Si Hisus ne matig-Nasarit, ka etew ne impamalehetan te Manama kayi te kanta pinaahi te me kein-inuwan wey me palinneu ne innimu rin pinaahi kandin, sumale te natahaan niyud e. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sikaniyu mismu ka nakataha su kayi ma neyitabu te kaniyu. Ne sumale te pegbuut te Manama wey te daan ne planu rin ne natahaan din ne egkatuman, imbehey rin si Hisus kayi te kaniyu, wey impeyimatayan niyu sikandin te me makasesale te pegpalansang kandin diye te krus. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Piru in-uyag sikandin te Manama wey inluwas puun te geem te kamatayen, su kene egkaayun ne egkaprisu sikandin te kamatayen. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Su migkahi si Dabid meyitenged kandin, ‘Layun ku egkakita kayi te tangkaan ku ka Magbebaye, su kayi sikandin te igkakawanan ku. Purisu ware egpakawelwel te pegpalintutuu ku. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ne puun due, egkahale ka pusung ku wey due kahale te peglalag ku. Ne minsan egkapatey a piru due egkapallateng ku ");
INSERT INTO mbtNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","su kene nu ma eg-engkeran ka gimukud ku diye te inged te me gimukud ne egngaranan te Hadis, kene nu igtuhut ne egkamewu ka lawa te maruma-ruma ne suluhuanen nu. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impapitew nu keddi ka bayaanan peendiye te umul, ne amana a nahale-gale tenged te pegduma nu keddiey!’ ");
INSERT INTO mbtNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Me suled, iglalag ku kaniyu ig-ayad-ayad ka meyitenged ki Dabid ne kaapuan ta. Migpatey sikandin wey inlebeng, ne ka inlebengan kandin, kayi pad minsan kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ne puun su prupita sikandin, nakataha sikandin ne migsaad ka Manama kandin ne due sabeka ne kabuhalan din ne eggimuwen ne Hari. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tapey e nakanengneng si Dabid ke nekey ka eggimuwen te Manama, purisu miglalag e sikandin meyitenged te peg-uyag ki Kristu, ‘Ware din engkeri diye te inged te me gimukud ne egngaranan te Hadis, ne ka lawa rin ware namewu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ne in-uyag te Manama ka sika ne Hisus, ne sikanami langun ka egpamalehet kayi. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Imbatun sikandin diye te kakawanan ne belad te Manama wey nakarawat sikandin te Panisingan ne insaad kandin te Amey. Ne ka seini ne Panisingan ka impalene kayi te kanami ne nakita niyud en iya kuntee wey narineg niyud e ka geem din. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Su si Dabid, ware mismu nekeendiye te langit, piru migkahi sikandin, ‘Ka Manama migkahi diye te Magbebaye ku: Pinnuu ka kayi te igkakawanan ku, ");
INSERT INTO mbtNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","taman te eggimuwen ku ne diekanan nu ka me kuntere nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Purisu ka langun ne etew kayi te Israil keilangan ne egpakanengneng amana te ka seini ne Hisus ne inlansang niyu te krus, innimu te Manama ne Magbebaye wey Kristu!” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te pegkarineg dutu te me etew, amana nekegsendit sikandan wey migkahi diye te ki Pidru wey diye te duma ne me apustulis, “Me suled, nekey ma ka eggimuwen ney?” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ne migtabak si Pidru, “Inniyuhi niyu ka me sale niyu wey pabewutismu kew ka tagse sabeka te ngaran ni Hisu Kristu eyew egkapasaylu ka me sale niyu, wey egkarawat niyu ka dasag te Manama ne sika se Panisingan din. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Su ka saad te Manama, para iya kaniyu wey te me anak niyu, wey te langun ne diyad te maddiyu—ka langun ne eg-umawen te Magbebaye ne Manama ta.” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Masalig pad ka inlalag ni Pidru te pegpamalehet wey pegbanasal kandan, “Luwasa niyu ka pegkeetew niyu te peglegpad ne igpeuma te seini se maddeet ne me etew!” ");
INSERT INTO mbtNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne seeye se migdawat te inlalag ni Pidru, migpabewutismu e. Me 3,000 ka nakatimul kandan ne migpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ne migpabulus sikandan ka egpammineg te pegpanulu te me apustulis, ka egsabeka langun, wey ka egkeen wey eg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Masalig ka me kein-inuwan wey me palinneu ne neyimu te me apustulis, purisu masalig ka me etew ne naaldek duma te pegtahud. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne ka langun ne migmalintutuu, migpabulus ka eglibulung wey insaamulan dan ka langun ne kasangkapan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ne impameligye dan ka me karatuan dan wey ka duma pad ne me kasangkapan dan, wey in-atul ran ipamehey ka halin diye te tagse sabeka sumale te keilangan din. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Migpabulus sikandan tagse aldew ka eglibulung diye te timplu, wey egsabeka sikandan ka egkeen diye te me baley ran duma te pegkahale wey te mapariralemen ne pusung. ");
INSERT INTO mbtNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Migpabulus sikandan ka migdayan te Manama, wey ingkeupii sikandan te langun ne etew. Ne tagse aldew, intimulan sikandan te Magbebaye te seeye se egkengaluwas. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Due sabeka ne aldew ne miggendiye si Pidru ki Huwan te timplu te me alas tris en iya te maapun su sika ka uras te peg-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Diye te gumawan ne egngaranan te “Mateles ne Gumawan,” due sabeka ne etew ne napungku puun te peglesut din. Ne tagse aldew, igdurulung sikandin diye te gumawan te timplu eyew egpakilimus te me etew ne egseled. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te pegkakita rin engki Pidru wey ki Huwan te egseled te timplu, migbuyu e sikandin te limus. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Intetengtengan sikandin enni Pidru ki Huwan, ne migkahi e si Pidru, “Tengtengi key!” ");
INSERT INTO mbtNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ne migtengteng ka pungku diye te kandan ne migtetahad ke egbehayan te limus. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piru migkahi si Pidru, “Ware iya mule seleppi ku, piru egbehayan ku sikeykew te kayi te keddi: te ngaran ni Hisu Kristu ne matig-Nasarit, hipanew ka!” ");
INSERT INTO mbtNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne dutu, inggen-genan din ka kawanan ne belad te pungku wey imbulihan te egpasasindeg. Ne due-rue ne migmanekal ka me paa wey lelenguan te pungku. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ne migletu sikandin te pegsasindeg din wey miggipanew e. Nataman, migdume e sikandin engki Pidru te migseled diye te timpu ne miggiphipanew wey migletu-letu ka migdayan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakakita ka langun ne etew kandin te miggiphipanew ne migdayan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Te neilaan dan e ne sikandin bes ka egpampamuyu ne egpinpinnuu diye te gumawan te timplu ne egngaranan te “Mateles ne Gumawan,” amana neinu-inu sikandan te neyitabu diye te kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te ware pad migleke engki Pidru ki Huwan ka neulian ne pungku, neinu-inu ka langun ne etew wey namallahuy peendiye te kandan diye te likansu ne egngaranan te Likansu ni Sulumun. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Te pegkakita ni Pidru te me etew, ingkahiyan din e sikandan, “Matig-Israil, mania te neneinu-inu kew kayi wey amana key nikaniyu tengtengi? Kahiyen niyu buwa ne puun te geem ney ne nakapeyipanew key te seini ne etew, wey ke puun naa te amana key egtuman te Balaud? ");
INSERT INTO mbtNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ka Manama ni Abraham, ni Isaak, ni Hakub, wey te me kabuybuyahan ta, ka migbehey te kabantug te suluhuanen din ne si Hisus. Sika ne Hisus ka imbehey niyu diye te me pangulu wey ka indeeg-deeg niyu diye te tangkaan ni Pilatu, minsan egpalekaan din ded perem. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Matulus wey matareng sikandin piru ware niyu dawata. Nasi niyu re iya hangyua si Pilatu ne iyan eglekaan ka nekeyimatey te etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Miggimatayan niyu ka kamuney te umul, piru in-uyag sikandin te Manama, wey sikanami iya ka egpakamemalehet kayi. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ka ngaran ni Hisus wey ka pegpalintutuu kandin ka nakabehey te kanekal te seini se etew ne nakita niyu wey neila. Ka pegpalintutuu ki Hisus ka nekeuli kandin sumale te nakita niyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ne kuntee me suled, nakataha a ne sikaniyu wey ka me pangulu niyu ka miggimu kayi diye ki Hisus, ware kew nakataha ke hentew sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Piru tapey e ipanengneng te Manama ka peg-antus te Kristu pinaahi te me prupita. Ne intuman iya te Manama seini te iling kayi ne paahi. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Purisu inniyuhi niyu ka me sale niyu wey libed kew e diye te Manama eyew egpasayluwen ka me sale niyu ");
INSERT INTO mbtNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wey eyew egginguma due te kaniyu ka kanekal te pegpalintutuu ne egpuun te Manama. Ne egkataman, igpeuyan din e si Hisus, ka Kristu ne in-alam din para kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piru keilangan ne diye pad iya sikandin te langit taman te egbalbalawan e te Manama ka langun, sumale te insaad din dengan pinaahi te matulus ne me prupita rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Su migkahi si Muwisis, ‘Egpeuyan ka Magbebaye ne Manama niyu te prupita ne kabuhalan niyu red iling te pegpeuyan din keddiey. Keilangan ne egtumanen niyu ka langun ne iglalag din. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ka kene egtuman te iglalag te seeye ne prupita, egpaaween ligkat te keet-etawan te Manama wey egpangimatayan.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iling ded due ka inlalag te me prupita puun pad ki Samwil wey minsan seeye se nakasinundul e kandin. Migpangguhud sikandan langun meyitenged te seini ne timpu. ");
INSERT INTO mbtNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ka me saad te Manama ne impangguhud te me prupita, para iya kaniyu. Ne sikaniyu, nakalagkes te kasabutan ne innimu te Manama ne imbehey te me kabuybuyahan niyu, su due inlalag din diye te ki Abraham, ‘Pinaahi te kabuhalan nu, egpanalanginan ku ka langun ne etew kayi te ampew te tane.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Purisu, in-alam te Manama ka suluhuanen din wey sikaniyu ka an-anayan ne impeuyanan eyew te pegbulig kaniyu pinaahi te pegpeinniyug kaniyu te mareet ne hinimuwan niyu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Te sasangan pad ensi Pidru ki Huwan ne eglalag diye te me etew, due migdugpu kandan ne me talagpanubad wey ka pangulu te talagtameng te timplu, wey me Sadusiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ingkabelu dan ka daruwa ne apustulis tenged su migpanulu sikandan te me etew wey migpamalehet ne neuyag ded si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ne puun dutu, indakep dan e sikandan wey imprisu ran te sabeka ne karusileman, su marusilem man-e seeye. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piru masalig ka migpalintutuu te pegkarineg dan te wali, wey migginguma te me lalimma ne libu (5,000) ka kasuluhan te me lukes ne migpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pegkapawe, miglibulung diye te Hirusalim ka me pangulu wey ka me igbuyag te me Hudiyu, wey ka me talagpanulu te Balaud te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","duma te Labew ne Talagpanubad ne si Anas, wey si Kaypas, si Huwan, si Alihandru, wey ka karumaan te Labew ne Talagpanubad. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Te nakaatubang e kandan ka me apustulis, mig-insaan dan e, “Nekey-a ne geem wey ngaran ka inggamit niyu?” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ne si Pidru se napenu te Panisingan te Manama, migtabak kandan, “Me pangulu te keet-etawan wey me igbuyag. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ke eg-insaan key kuntee meyitenged te meupiya ne himu ne neyimu diye te pungku, wey ke nekey ne paahi ne neulian sikandin, ");
INSERT INTO mbtNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","eleg iya ne egkanengnengan niyu langun wey te langun ne keet-etawan te Israil, ne ka seini ne etew se migsasindeg kayi te tangkaan niyu, neulian pinaahi te geem te ngaran ni Hisu Kristu ne matig-Nasarit—seeye se inlansang niyu te krus ne in-uyag man-e te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Hisus ka nakahi diye te Kasulatan, ‘Ka batu ne insamsamilian niyud e te talagbebaley, neyimu ne subla ne keilanganen ne batu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ka kaluwasan, diye de egkakita te kandin, su warad e duma ne ngaran kayi te ampew te tane ne imbehey te Manama te keet-etawan ne egpakaluwas kanta, ke kene, si Hisus de.” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Te pegkakita ran te kabulut enni Pidru ki Huwan, neinu-inu sikandan tenged su nanengnengan dan ne ware sikandan nenekeiskuyla wey egkaleig-leig de. Nanengnengan dan man-e ne migduma-ruma pad sikandan dengan ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Piru warad e igkalalag dan su nakita ran ma ka etew ne neulian e ne migsasindeg duma engki Pidru ki Huwan. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ne dutu egpuun, impalihawang dan e ensi Pidru ki Huwan diye te libulunganan te Me Talaggukum te me Hudiyu wey migmein-inseey, ");
INSERT INTO mbtNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nekey naan e ka eggimuwen ta te seini ne me etew? Su ka langun ne mig-ugpe kayi te Hirusalim, nakanengneng meyitenged te seini se masumpit ne kein-inuwan wey kene ki egpakaapul kayi. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ne eyew kene amana egpekeempet ka seini se kein-inuwan diye te keet-etawan, egkenaan tad sikandan ne eglalag meyitenged te ngaran ni Hisus diye te minsan hentew.” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Purisu impeumew ran e man-e ka daruwa ne apustulis wey ingkenaan en iya ne egpepanugtulen wey egpepanuluen te ngaran ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piru migtabak ensi Pidru ki Huwan, “Na, hukumi niyu ke hendei ka malehet diye te tangkaan te Manama: ka peg-ikul naa te suhu niyu wey ke suhu naa te Manama? ");
INSERT INTO mbtNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Su kene key egpakasanggel ka egpanugtul te nakita ney wey narineg ney.” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pegkapenga dutu, amana pad sikandan panpanayi te me pangulu, nataman, inlekaan e sikandan su ware ma nakita ran ne malehet ne katarengan ne eleg sikandan ne eglegparan, su seeye se me etew, migdayan ma te Manama puun te seeye ne neula-ula. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Seeye se etew ne neulian, suble e te keep-atan se idad. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Te nalekaan e ensi Pidru ki Huwan, miggendiyaan dan e ka me alukuy ran wey impangguhuran dan e meyitenged te ingkahi kandan te pangulu te talagpanubad wey me igbuyag te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te pegkarineg dan dutu, mig-ampu e sikandan langun diye te Manama. Migkahi sikandan, “Magbebaye ne Manama ne talagmandu, sikeykew ka miggimu te langit, te tane, te dahat, wey te langun ne nakatahu kayi te inged! ");
INSERT INTO mbtNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ne pinaahi te Panisingan nu, impalalag nu ka kaapuan ney ne si Dabid, ka suluhuanen nu. Migkahi sikandin, ‘Mania te egkabelu ka kene ne me Hudiyu? Ne mania te migplanu ka me keet-etawan te ware karuan? ");
INSERT INTO mbtNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mig-andam ka me Hari kayi te ampew te tane, wey miglibulung ka me pangulu su egpakigkuntere te Magbebaye ne Manama wey te in-alam din ne iyan ka Kristu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kunaleg te si Hirudis, si Punsiyu Pilatu, nasabeke e kayi te seini ne siyudad duma te kene ne me Hudiyu wey te keet-etawan te Israil ne egpakigkuntere ki Hisus, ka matulus ne suluhuanen nu ne innimu nu ne Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ne nasi dan e himuwa ka tapey nud e planuwa ne egkeyitabu sumale te pegbuut nu. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ne kuntee Magbebaye, tengtengi nu seini se peglelalis dan. Behayi key se me uripen nu te kabulut te pegpangguhud te keykew ne lalag. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipapitew nu ka geem nu te pegbawi, wey ituhut nu ne egkeyimu perem ka me kein-inuwan wey me palinneu pinaahi te matulus ne ngaran te suluhuanen nu ne si Hisus.” ");
INSERT INTO mbtNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te nakapenge e sikandan ka mig-ampu, nawelwel ka inlibulungan dan. Ne sikandan langun, napenu te Panisingan te Manama wey migwali te lalag te Manama te ware pegkaaldek. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nasabeka ka me suman-suman wey me pusung te me migmalintutuu. Ne ware sabeka ne egkahi te sikandin de ka kamuney te sika ne kasangkapan, ke kene, egsaamulan dan ka langun ne diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne dakel ka geem te me apustulis te pegpamalehet te peg-uyag te Magbebaye ne si Hisus, wey amana sikandan langun bulihi te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ne ware sabeka kandan ne nakulangan. Seeye se due me kamet wey me baley, impamelegye dan e ");
INSERT INTO mbtNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne ka halin, imbehey ran diye te me apustulis, ne ka me apustulis e ka egtalad-talad te tagse sabeka kandan sumale te keilangan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ne iling naa due ka innimu ni Husi, sabeka sikandin ne Libita ne matig-Sipri ne ingngaranan te me apustulis ki Birnabi (ke sikanta pa, “Ka Talagbagget”), ");
INSERT INTO mbtNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","migbelegye sikandin te kamet din wey ka halin, imbehey rin diye te me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ne due alunggun ne migbelegye te me karatuan dan, si Ananiyas ka lukes, ne si Sapira ka malitan. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Piru in-angayan ni Ananiyas ka halin, ne ka asawa rin nakanengneng dutu, ne iyan naan de imbehey diye te me apustulis ka nasame. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ne migkahiyan sikandin ni Pidru, “Ananiyas, mania te migpaakal ka ki Meibulan wey mig-uubat ka te Panisingan te Manama te peg-angey nu te baad te seleppi ne halin te tane nu? ");
INSERT INTO mbtNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Te ware nu pad ibelegye seeye, keykew pad iya, wey te nakabelegye e, keykew red man-e ka halin. Na, mania te migsuman-suman ka ne eggimu te iling kayi? Su kene ne me etew ka in-ubatan nu, ke kene, ka Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Te pegkarineg ni Ananiyas dutu, napeled e sikandin wey namatey. Ne migdugpu ka me kanakan, bukusi ran ka lawa ni Ananiyas wey indulung dan e diye te lihawangan wey inlebeng. Naaldek ka langun ne nakarineg te seeye ne neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Peglihad te tatelu ne uras, migseled e degma ka asawa ni Ananiyas, piru ware sikandin nakataha ke nekey ka neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne migkahiyan sikandin ni Pidru, “Nangeni a ke seini re iya ka halin te tane ne imbelegye niyu?” Ne migtabak ka malitan, “Uya, sikan de iya.” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piru migkahiyan sikandin ni Pidru, “Mania te nekegsabut kew ka alunggun ne eg-eleg-eleg eg-uubat te Panisingan te Manama? Kuntee, duen e te gumawan ka me kanakan ne miglebeng te asawa nu. Ne sikandan ded degma ka eglebeng keykew!” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ne due-rue ne napeled si Sapira diye te tangkaan ni Pidru wey migpatey. Pegseled te me kanakan, nakita ran ne migpatey e ka malitan, ne in-uyan dan e diye te lihawangan wey inlebeng diye lenged te asawa rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Amana naaldek ka langun ne punduk te migmalintutuu wey ka langun ne nakarineg te sika ne neyitabu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Masalig ka me palinneu wey me kein-inuwan ne neyimu te me apustulis diye te me etew. Ne ka langun ne migmalintutuu, layun eglibulung diye te likansu ne egngaranan te Likansu ni Sulumun. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ne ware minsan sabeka ne mig-apil kandan su naaldek, piru amana tahura sikandan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Piru nasi migmasalig ka nakatimul kandan ne migpalintutuu te Magbebaye—lukes ma wey malitan. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne puun te himu te me apustulis, impanguyan e ka egmanderalu diye te deralanen. Diye imeyibat te me hibatanan wey diye te me ikam su egpaalew-alew sikandan ke egkaralungan ni Pidru ke eglihad. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne due degma nanginguma ne me etew puun te lungsud ne marani te Hirusalim. Nanguyan sikandan te nanderalu wey te nanerepan te busew, wey neneulian sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Piru amana neimma te me apustulis ka Labew ne Talagpanubad te timplu wey ka langun ne me duma rin ne sakup te me Sadusiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Purisu indakep dan ka me apustulis wey imprisu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piru te seeye ne karusileman, inlukatan te panalihan te Magbebaye ka gumawan te prisuwan, wey impalihawang ka me apustulis wey migkahiyan, ");
INSERT INTO mbtNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pangendiye kew te timplu wey panugtuli niyu ka me etew diye meyitenged te seini se iyam ne umul.” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ne intuman seeye te me apustulis, ne hengkayi te egkaliwaswas e, migseled e sikandan diye te timplu wey migpanulu. Nataman, impeumew e te Labew ne Talagpanubad wey te me duma rin ka me Talaggukum te me Hudiyu eyew egkalibulung sikandan langun ka me upisyal te me Hudiyu. Ne due degma insuhu dan ne eggendiye te prisuwan eyew te egpeg-angey te me apustulis wey eg-uyanen diye te tangkaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piru te peggendiye te me pulis te prisuwan, warad e ka me apustulis. Purisu nanlibed e ka me pulis diye te Labew ne Talagpanubad te me Hudiyu wey migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Te pegginguma ney diye te prisuwan, nakita ney ne amana ne maresen ka peglekeb, ne ka me talagtameng, diye ded te gumawan ka egtetameng. Piru te peglukat ney e te gumawan, warad e diye te seled ka me pinirisu!” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pegkarineg dutu te kepitan te talagtameng te timplu, wey te me pangulu te me talagpanubad, nalibeg e sikandan ke nekey ka neyitabu te me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ne due etew ne migseled ne migkahi, “Diyad e te timplu ka impamirisu niyu, wey migpanulu e te me etew.” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ne puun dutu, miggendiyaan e te kepitan te talagtameng te timplu wey te me pulis ka me apustulis wey indakep dan e man-e. Ware sikandan miggamit te keseg su egkaaldek sikandan ke egbatuwen te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ne in-uyan dan e ka me apustulis diye te tangkaan te me Talaggukum eyew eg-insaan. Kahi te Labew ne Talagpanubad, ");
INSERT INTO mbtNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Migkenaan ney e sikaniyu ne kenad egpepanuluen meyitenged te sika ne ngaran, piru nasi de iya nekeempet te intiru ne Hirusalim ka pegpanulu niyu, ne sikanami pe ma ka indakeselan niyu te kamatayen din!” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ne migtabak ensi Pidru wey ka me duma rin ne me apustulis, “Keilangan ne ka Manama re ka egpalintutuuwan ta, kene ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ka Manama te kabuybuyahan ta ka mig-uyag ki Hisus te innimatayan niyu pinaahi te peglansang kandin te krus. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imbatun sikandin te Manama diye te igkakawanan din eyew egkeyimu ne Pangulu wey Manluluwas, wey eyew te pegbehey te timpu diye te me matig-Israil te peg-inniyug te me sale dan eyew egkapasaylu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sikanami ka talagpamalehet due wey ka Panisingan degma ne indasag te Manama te seeye se egpalintutuu kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pegkarineg dan dutu, amana sikandan nabelu wey egkeupian ne egpangimatayan ka me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piru migsasindeg diye te tangkaan dan ka duma ran ne egngaranan ki Gamaliil; sabeka sikandin ne talagpanulu te Balaud te Manama wey intahud te me etew. Migsuhu sikandin ne egpalihawangen pad te dagdahew re ka me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nataman, migkahiyan din e ka me pangulu te Hudiyu, “Kabuhalan ni Israil, bantey kew ke nekey ka eggimuwen niyu te seini ne me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nakasuman-suman kew pad ki Tudas? Mig-angken sikandin ne mabantug, ne due me hep-at ne gatus (400) ne me etew ka neuyan din. Piru innimatayan sikandin wey nallaag-laag e ka me hibateen din, ne nataman, warad e nakapabulus ka pegpanulu din. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Timpu te sinsus, si Hudas e man-e ne matig-Galiliya ka migginggat te me etew ne eg-ikul kandin, piru innimatayan ded sikandin wey nenekegsuwey-suwey e man-e ka me hibateen din. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ne ka seini se prublima kuntee, kene niyu re due hilabeti sikandan wey balahara niyu re due, su emun ke himu re seini te etew wey ke planu re seini te etew, egkaawe ded te kene egkaluhey. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piru ke kandin sika te Manama, kene niyu iya sikandan egkatalu. Ne kema ke iyan niyu pad egkakuntere ka Manama.” Ne migpalintutuu te tambag ni Gamaliil ka me pangulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne impalasud dan e man-e ka me apustulis wey impalampesan dan wey ingkenaan en iya ne egpanugtul te meyitenged te ngaran ni Hisus. Ne nataman, inlekaan e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nataman, nanlihawang e ka me apustulis puun te tangkaan te me Talaggukum, wey nahale-gale sikandan su in-isip sikandan te Manama ne likes te me peg-antus te keyilawan tenged te ngaran ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne tagse aldew, migpabulus sikandan ka egpanugtul wey egpanulu te Meupiya ne Panugtulen meyitenged ki Hisus isip Kristu. Diye dan sika eggimuwa te timplu wey te me kabalbalayan. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na, te seeye ne timpu te egkatimtimulan e ka me hibateen, neepes ka me Hudiyu ne Grigu se linalahan te seeye se me Hudiyu ne mahinged dutu, tenged su ware nabehayi ka me balu ran te tagse aldew ne keilangan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ne puun dutu, inlibulung te sapulu wey daruwa (12) ne apustulis ka langun ne me hibateen wey ingkahiyan, “Kene ne meupiya ne egkabalahad ney ka pegwali te lalag te Manama puun te pegtanggu te me etew ne due keilangan. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Purisu me suled, alam kew te pitu ne etew ne meupiya se batasan wey napenu te Panisingan te Manama wey te katuenan, su sikandan ka egbehayan ney te katenged te peg-uyan due. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ne sikanami, eggamiten ney ka timpu ney te peg-ampu wey te pegwali.” ");
INSERT INTO mbtNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ne sikandan langun neupian te planu te me apustulis. Ne due egpuun ne in-alam dan ensi Istiban ne napenu te Panisingan te Manama wey te pegpalintutuu, wey si Pilipi, si Purukuru, si Nikanur, si Timun, si Parminas, wey si Nikulas ne matig-Antiyukiya ne kene ne Hudiyu ne neuyan te tuluuwen te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nataman, in-uyan e sikandan diye te me apustulis. Ne dutu, in-ampuan e sikandan te me apustulis wey intel-eban te me belad. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Purisu, nakapabulus nekeempet ka lalag te Manama. Ne ka me hibateen diye te Hirusalim, hutuk pad migmasalig. Ne masalig degma ka me talagpanubad diye te timplu ne mig-ikul e te kamalehetan. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ne si Istiban, sabeka ne etew ne imbulihan te Manama wey imbehayan te geem. Nekeyimu sikandin te me kein-inuwan wey te me palinneu diye te tangkaan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Due duma ne me etew ne kene egpalintutuu kandin wey egpakig-ehet. Ka duma kandan matig-Sirini wey matig-Alihandriya ne sakup te simbaan te me Hudiyu ne egngaranan te “Me Etew Ne Inlekaan Puun te Pegkeuripen.” Ne ka me duma, me matig-Silisya wey Asya. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ware sikandan nakaapul ki Istiban su imbehayan ma sikandin te katuenan te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Purisu migpamayad e sikandan te me etew ne egpabayungen kandin ne eggenendue, “Nakarineg key kandin te migbaley-baley ki Muwisis wey te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sikan naa, nasamuk e ka me etew, me igbuyag dan, wey ka me talagpanulu te Balaud te Manama. Purisu impamitew ran e si Istiban wey inderakep dan e wey in-uyan e diye te me Talaggukum te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nataman, impaatubang dan e ka me etew ne egpeuubaten wey egpakahiyen, “Ka seini ne etew, kene eg-engked ka egdereet te matulus ne timplu wey te Balaud ni Muwisis. ");
INSERT INTO mbtNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Narineg ney sikandin ne si Hisus kun ne matig-Nasarit ka egguhus te timplu wey egbalbalawan din ka tulumanen ne inggaat ni Muwisis kanta!” ");
INSERT INTO mbtNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka langun ne me Talaggukum te me Hudiyu, migmemetmet ki Istiban, ne nakita ran ne nekeiling e te ulaula te panalihan te Manama ka kandin ne ulaula. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ne mig-insaan si Istiban te Labew ne Talagpanubad diye te timplu, “Malehet seini se imbayung dan?” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ne migtabak si Istiban, “Me suled ku wey me anggam ku! Pammineg kew keddiey! Ka Manama ne subla ne mabantug wey maresen, migpakita te kaapuan ta ne si Abraham te diye pad sikandin mig-ugpe te Misuputamya, te ware pad sikandin mig-ugpe diye te Haran. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Migkahi ka Manama diye te kandin, ‘Engkeri nu ka inged nu wey ka me karumaan nu, wey hendiye ka te inged ne igpapitew ku keykew.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ne puun dutu, mig-awe e si Abraham diye te Kaldiya wey diyad e mig-ugpe te Haran. Pegpatey te amey rin, impaalin e man-e sikandin te Manama te seini ne inged ne in-ugpaan niyu kuntee. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ware sikandin behayi te Manama te tane kayi, minsan eleg de ubag ne egkariekan din. Piru insaaran sikandin te Manama ne igbehey kandin ka seeye ne tane wey egkakandin e wey te me kabuhalan din. Te seeye ne timpu, ware pad anak ni Abraham. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Seini ka ingkahi te Manama diye te kandin, ‘Ka me kabuhalan nu, diye eg-ugpe te lein ne nasud wey egkeuripen sikandan diye, wey egpaantusen sikandan seled te hep-at ne gatus (400) ne leg-un. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Piru eglegparan ku ka nasud ne eg-uripen kandan, ne egkataman egmangawe e sikandan te seeye ne inged wey egsimba keddiey kayi te seini ne inged.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ne migbehey ka Manama te kasabutan diye ki Abraham pinaahi te pegtuli isip palinneu. Ne puun dutu, intulian din e ka anak din ne si Isaak te nawaluwan pad ka miglesut. Nakapabulus ka sika ne eggimuwen te peglesut ni Hakub te anak ni Isaak, wey diye te sapulu wey daruwa (12) ne me anak ni Hakub ne sika se mabantug ne me kaapuan ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ne ka mabantug ne me kaapuan ta ne me anak ni Hakub, neimma te hari ran ne si Husi, purisu imbelegye dan e eyew eg-uripenen diye te Ihiptu. Piru indumaan sikandin te Manama, ");
INSERT INTO mbtNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wey inluwas puun te langun ne me keyirapan din. Te timpu ne mig-atubang si Husi te Hari te Ihiptu, inlapihan sikandin te Manama wey imbehayan te katuenan. Ne puun due, innimu sikandin te Hari ne pangulu te nasud wey te pamilya te Hari. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nataman, due migginguma ne bitil diye te intiru ne Ihiptu wey diye te Kanaan. Amana neyirapi ka me etew wey warad egkakeen te me kabuybuyahan ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pegkarineg ni Hakub ne due egkakeen diye te Ihiptu, impeendiye din e ka me kabuybuyahan ta. Seeye ka an-anayan ne peggendiye dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Te igkarangeb e ne peggendiye dan te Ihiptu, henduen pad ipeila ni Husi ka pegkeetew rin diye te me suled din. Ne dutu, neilaan e te Hari te Ihiptu ka pamilya ni Husi. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ne puun due, impeuyanan ni Husi si Hakub, ka amey rin, te lalag ne diye egpeugpaa te Ihiptu duma te me suled din. Me pitu ne pulu wey lalimma (75) sikandan langun. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Purisu nangendiyad e ensi Hakub te Ihiptu wey diyad e migpatey sikandin wey ka me kabuybuyahan ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Diye ded uyana ka me lawa ran te Sikim wey diye ilebeng te lebenganan ne imbeli ni Abraham diye te me anak ni Hamur.” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ne migpabulus si Istiban ka migkahi, “Ne hengkayi te mahaan e egtumana te Manama ka insaad din ki Abraham, hutuk pad ne migmasalig ka keet-etawan ta diye te Ihiptu. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne due nakasubal ne Hari diye te Ihiptu ne ware nekeila ki Husi. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inlimbungan din ka keet-etawan ta wey indeeg-deeg ka me kabuybuyahan ta su impehes sikandan ne egpalihawangen te baley ka me anak dan ne dereisek pad eyew egpamatey. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Te seeye ne timpu, neetew si Muwisis ka ingkatelesi te Manama. Me tatelu ne bulan sikandin ka natanggu diye te kandan ne ugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ne hengkayi te in-engkeran e sikandin diye te lihawangan, ingkuwe e sikandin te anak te Hari te Ihiptu ne malitan wey in-anak-anak e. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Napanulu si Muwisis te langun ne katuenan te me Ihiptuhanen, wey neyimu sikandin ne mabantug pinaahi te peglalag din wey te himu rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Te hep-at ne pulu (40) ka idad ni Muwisis, nakasuman-suman sikandin ne egpanumbaley diye te me karumaan din ne me kabuhalan ni Israil. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Te pegkakita rin ne due sabeka kandan ne inlampesan te Ihiptuhanen, migpangabangan din e, ne migsulian din ka Ihiptuhanen wey innimatayan din e. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Kahiyen ni Muwisis ne egpakasabut ka me karumaan din ne eggamiten sikandin te Manama te pegluwas kandan, piru ware bes sikandan nakasabut.) ");
INSERT INTO mbtNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te igkarangeb ne aldew, due nakita rin ne daruwa ne etew ne me kabuhalan ni Israil ne migpeehetey, wey mig-el-elehan din sikandan te eggusey. Migkahi sikandin, ‘Me suled ku, mania te egpeunayey kew egpeehetey se tahasuled de?’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piru sika se etew ne miglampes te duma rin, ingkeyis din si Muwisis te migkahi, ‘Hentew-a ka innimu keykew ne pangulu wey talaggukum kanami? ");
INSERT INTO mbtNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Eggimatayan a nikeykew iling te peggimatey nu te Ihiptuhanen gabii?’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pegkarineg dutu ni Muwisis, migpallahuy e sikandin peendiye te inged ne Midiyan. Ne diyad sikandin mig-ugpe wey diyad e sikandin nakaasawa wey nakaanak te daruwa ne lukes. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Te peglihad te hep-at ne pulu (40) ne leg-un, due panalihan ne migpakita ki Muwisis diye te sapinit ne egkalegleg. Diye seeye te mammara ne inged ne kene egkeugpaan ne diye seeye te Bubungan te Sinay. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Neinu-inu si Muwisis te pegkakita rin dutu, purisu migdani-rani e sikandin diye te sapinit ka egtengteng ke nekey seeye. Piru nakarineg sikandin te laheng te Magbebaye ne Manama ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Sikeddiey ka Manama te me kabuybuyahan nu, ka Manama ni Abraham, ni Isaak, wey ni Hakub.’ Ne dutu migkelkel e si Muwisis wey naaldek ne egpitew. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ne migkahiyan sikandin te Magbebaye ne Manama, ‘Luunga nu ka sandal nu su matulus ka tane ne insesasindehan nu. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakita ku iya ne amana egkabaybayari ka keet-etawan ku diye te Ihiptu wey narineg ku ka pegpangananey ran. Ne migpamaneug ad e kayi eyew te pegluwas kandan. Purisu, hendini ke naa su igpeuyan ku sikeykew diye te Ihiptu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Seini ka Muwisis ne insamsamilian te me kabuhalan ni Israil te miggenendue, ‘Hentew-a ka migtuhut ne sikeykew ka egkeyimu ne pangulu wey talaggukum kanami?’ Si Muwisis ka impeuyan te Manama ne egkeyimu ne pangulu wey manluluwas, wey imbulihan sikandin te panalihan ne nakita rin diye te sapinit ne nalegleg. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sikandin ka migpangulu kandan te mig-awe diye te Ihiptu, wey due me kein-inuwan wey me palinneu ne innimu rin diye te Ihiptu wey diye te Malalab ne Dahat. Miggimu man-e sikandin te iling due seled te hep-at ne pulu (40) ne leg-un diye te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Sika ne Muwisis ka migkahi diye te kabuhalan ni Israil, ‘Egpeuyanan kew te Manama te prupita iling te pegpeuyan din keddi. Ne sabeka sikandin ne kabuhalan niyu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Muwisis ka migduma te me kabuhalan ni Israil ne nalibulung diye te mammara ne inged ne kene egkeugpaan. Diye sikandin duma te kabuybuyahan ta wey te panalihan ne migpakiglalag kandin diye te Bubungan te Sinay, seeye se nakarawat sikandin te lalag te Manama ne igpabehey kanta.” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Piru nekewukum ka me kabuybuyahan ta ne kene egtuman kandin, purisu imbalahad dan sikandin wey egkeupian e perem sikandan ne eglibed diye te Ihiptu. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Seeye naa, migkahiyan dan si Aarun, ‘Himuwi key nikeykew te me diyus-diyus ne iyan eggun-a kanta su ware ki nakataha ke nekey-e ka neyitabu diye te ki Muwisis ne in-uyan kanta ligkat te Ihiptu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ne puun dutu, miggimu e sikandan te diyus-diyus ne egpekeiling te nati te baka. Ne impanubaran nikandan seeye wey migsahakeen sikandan te pegpeila ne nahale sikandan te innimu ran. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Piru in-engkeran sikandan te Manama wey imbalahad sikandan ne egsimba te me bituen diye te langit, sumale te insulat te baseen te me prupita, ‘Me kabuhalan ni Israil, sikeddi ka impanubaran niyu wey ka inhalaran niyu seled te hep-at ne pulu (40) ne leg-un diye te mammara ne inged ne kene egkeugpaan? ");
INSERT INTO mbtNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kene! In-uyan niyu ka balungbalung te diyus-diyus ne si Muluk, wey ka inetew-etew ne bituen te diyus-diyus niyu ne si Ripan. Innimu niyu sika se me diyus-diyus eyew egsimbeen. Purisu egpaaween ku sikaniyu peendiye te mariyu ne inged ne eglihad pad te Babilunya.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Diye te mammara ne inged ne kene egkeugpaan, due balungbalung te me kabuybuyahan ta ne palinneu te due diye te kandan ka Manama. Innimu ni Muwisis seini se balungbalung sumale te impakita kandin te Manama ne egpeilingan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nataman, te si Huswi e ka migpangulu te me kabuybuyahan ta te peg-ahew ran te me nasud ne impaawe te Manama, ka me kabuybuyahan tad e degma ka mig-uyan te sika ne balungbalung. Ne duen pad ka balungbalung taman te miggingume e si Dabid. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ne ingkeupii te Manama si Dabid, wey mighangyu sikandin te Manama ne egpes-ek te ugpaan para te Manama ni Hakub. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Piru si Sulumun ka nakapapes-ek te ugpaan para te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Piru ka Amana ne Mabantug ne Manama, kene eg-ugpe te ugpaan ne impes-ek te etew, su sumale te ingkahi te me prupita, ");
INSERT INTO mbtNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Migkahi ka Magbebaye ne Manama, Ka langit ka pinnuuwanan ku, wey tane ka diekanan ku. Nekey ne klasi te ugpaan ne eggimuwen niyu para keddiey? Wey ke hendei naa ka himelayanan ku? ");
INSERT INTO mbtNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sikeddiey ka miggimu kayi langun!’ ");
INSERT INTO mbtNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Amana ne makehal ka me ulu niyu wey ka me pusung niyu, wey kene kew egpammineg te lalag te Manama! Ne nekeiling kew te me kabuybuyahan niyu! Ne layun kew eg-apul te Panisingan te Manama! ");
INSERT INTO mbtNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ware prupita ne ware baybayari te me kabuybuyahan niyu. Innimatayan dan seeye se migpaney-paney migpataha meyitenged te pegginguma te Suluhuanen ne Matareng, sika se inliputan niyu wey innimatayan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sikaniyu ka nakarawat te Balaud ne imbehey te me panalihan, piru ware niyu seini tumana!” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pegkarineg dutu te me pangulu te me Hudiyu, amana sikandan nabelu ki Istiban wey nakapangngahat te pegkabelu dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piru si Istiban ne napenu te Panisingan te Manama, migleng-ag sikandin te langit wey nakita rin ka katelesan te Manama wey nakita rin degma si Hisus ne migsasindeg diye te igkakawanan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ne migkahi sikandin, “Pitew kew! Nakita ku ka langit ne nalukatan e, ne ka Anak te Etew diye migsasindeg te igkakawanan te Manama!” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Piru migpanguleyi sikandan ne migsesagpeng te talinga ran, wey miglegse sikandan ka migpallahuy ne egsukeung kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ne inggehanuy e sikandin diye te lihawangan te siyudad wey imbebatu e. Ne inggaat te me talagpamalehet meyitenged ki Istiban ka me kumbale dan diye te lukes ne kene pad amana ne mayansan ne si Saulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Taheed te egbebatuwen dan si Istiban, mig-ampu e sikandin ne miggenendue, “Magbebaye ne si Hisus, dawata nu ka panisingan ku!” ");
INSERT INTO mbtNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ne migpanimbuel sikandin wey migbalbalukan ne migkahi, “Magbebaye, kene nu sikandan pakasalaa te innimu ran!” Pegkapenga rin te miglalag dutu, nabigtawan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ne mig-uyunan ni Saulu ka peggimatey ki Istiban. Te seeye ne aldew, migbunsud e ka masumpit ne pegbayad-bayad te migmalintutuu ki Hisus diye te Hirusalim. Ne sikandan langun, angin e te me apustulis, nenekegsuwey-suwey e diye te me prubinsya diye te Hudiya wey te Samarya. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ne due me lukes ne migpamakey te Manama ne miglebeng ki Istiban, wey migpalumbibigtew sikandan te pegkalange dan te pegpatey rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Piru si Saulu, impakannekal sikandin ka egdereet te me etew ne migpalintutuu. Ne tagse baley, eggendiyaan din wey migpangganuy rin ka egpalintutuu ne me lukes wey me malitan, wey impamirisu rin e. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ne seeye se nenekegsuwey-suwey ne migmalintutuu, migwali e te lalag te Manama te minsan hendei ne egkeendiyaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ne si Pilipi, miggendiye te sabeka ne siyudad diye te Samarya wey migwali te me etew meyitenged te Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pegkarineg te sesalihi ne etew te inlalag ni Pilipi, wey te pegkakita ran te me kein-inuwan ne innimu rin, mig-ayad-ayad e sikandan migpammineg kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Masalig ne me etew ka nanerepan te busew ne neneulian wey migmanguleyi ka me busew te meemen. Ne masalig degma seeye se kene egkaweil se lawa wey me pungku ne neneulian e. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Purisu nahale amana ka me etew diye te Samarya. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te seeye ne siyudad, due etew ne egngaranan ki Simun ne miggimu te salamangka, wey nakapeinu-inu seeye te matig-Samarya. Migpeggasal man-e sikandin ne mabantug kun. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne ka langun ne etew te seeye ne siyudad, datu ma wey se kene, migpammineg iya kandin. Migkahi sikandan, “Sikandin ka geem te Manama ne egngaranan te ‘Ka Dakel ne Geem.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Migpammineg sikandan kandin tenged su naluhey re ne nakapeinu-inu kandan ka salamangka rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piru te migpalintutuu e sikandan te wali ni Pilipi meyitenged te Meupiya ne Panugtulen te Peghari te Manama wey te ngaran ni Hisu Kristu, imbewutismuwan e sikandan, lukes ma wey malitan. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ne minsan si Simun, migpalintutuu e degma. Ne hengkayi te nabewutismuwan e sikandin, migduma-rume e sikandin ki Pilipi. Nawangalan sikandin te me kein-inuwan wey me palinneu ne neyimu ni Pilipi. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Te pegkarineg te me apustulis diye te Hirusalim ne migdawat e te lalag te Manama ka matig-Samarya, impeuyan dan e ensi Pidru ki Huwan diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Te pegginguma ran, mig-ampuan dan e ka me migpalintutuu ne egpakarawat te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Su ka Panisingan te Manama, ware pad ipeyinguma diye te minsan sabeka kandan; nabewutismuwan de sikandan te ngaran te Magbebaye ne si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nataman, migtel-eban e sikandan enni Pidru ki Huwan, ne dutu, narawat dan e ka Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Te pegkakita ni Simun ne nakarawat ka me etew te Panisingan pinaahi te pegtel-eb te belad dan, migbehayan din e perem sikandan te seleppi ");
INSERT INTO mbtNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","te migkahi, “Behayi a degma nikaniyu te sika ne geem eyew egpakarawat te Panisingan te Manama ka langun ne egtel-eban ku te belad ku.” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piru migkahiyan sikandin ni Pidru, “Egkareetan ka perem duma te seleppi nu tenged su kahiyen nu ne egkabeli nu ka dasag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ware apil nu wey ware labet nu te seini ne himu su kene ne meupiya ka pusung nu diye te tangkaan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Purisu inniyuhi nu seini se mareet ne suman-suman nu wey ampu ka ne egpasayluwen ka te Magbebaye tenged te pegsuman-suman nu te iling due. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Su nakataha a ne amana ke re neimma kanami wey neuripen ka te sale.” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ne migkahiyan ni Simun si Pidru wey si Huwan, “Iampu a nikaniyu te Magbebaye eyew kene egkatuman ka inlalag niyu keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Te pegkapenga enni Pidru ki Huwan te pegpamalehet meyitenged te ki Hisus wey te pegwali te lalag te Magbebaye, miglibed e sikandan diye te Hirusalim. Ne migwali sikandan te Meupiya ne Panugtulen diye te masalig ne me inged diye te Samarya. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nataman, migkahiyan si Pilipi te panalihan te Magbebaye, “Hendiye ka te igkakawanan ne balabahan dapit te igsile, diye te dalan peendiye te Hirusalim wey Gasa.” Ka seeye ne dalan, warad e bayei. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Purisu miggipanew e si Pilipi te seeye ne timpu. Ne due degma sabeka ne sinalihan ne upisyal ne matig-Itiyupiya ne eg-uli diye te kandan. Sabeka sikandin ne kinepun ne lukes wey talaggen-gen te seleppi ni Kandasi ne rayna te Itiyupiya. Miggendiye sikandin te Hirusalim eyew egsimba te Manama. Te seeye ne aldew, mig-uli e sikandin ne mig-untud te kerumata, ne due baseen ne insulat ni Prupita Isayas ne imbasa rin taheed te mig-untud din. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ne migkahiyan si Pilipi te Panisingan te Manama, “Hendiye ka wey andangi nu ka kerumata.” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Purisu migpallahuy si Pilipi peendiye te kandin wey narineg din ka upisyal ne migbasa te sinulat ni Prupita Isayas. Ne mig-insaan sikandin ni Pilipi, “Nasabut nu red ka imbasa nu?” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ne migtabak ka upisyal, “Egmenuwen ku te egsabut ke ware egpanulu keddiey?” Ne impeuntud din e si Pilipi te kerumata wey migpinnuu andang kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Seini ka baseen te Kasulatan ne imbasa rin: “Iling sikandin te karniru ne in-uyan eyew eggilangen. Ne iling man-e sikandin te nati te karniru ne egpeeneng-eneng ke eg-alutan, ware sikandin miglalag te minsan sabeka re ne lalag. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Impeyilawan sikandin wey ware nabehayi te meupiya ne hukum, ne ware egpakapanugtul meyitenged te me kabuhalan din su malepet de ka peg-ugpe din kayi te ampew te tane.” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ne mig-inse ki Pilipi ka upisyal, “Nangeni e kun ubag ke hentew-a ka egguhuren din kayi, ka kandin naa mismu ne lawa wey ke lein?” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Purisu impangguhuran e sikandin ni Pilipi te Meupiya ne Panugtulen meyitenged ki Hisus, ne migbunsud te seini ne baad te Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ne diye te hipanawan dan, due neyingumaan dan ne weyig, ne migkahi e ka upisyal, “Pitew ka, due weyig seini. Mania te kena a nikeykew egbewutismuwan?” ");
INSERT INTO mbtNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Purisu impasanggel nikandin ka kerumata wey migpamaneug e sikandan se daruwa. Ne migdugpu sikandan diye te weyig wey migbewutismuwan e ni Pilipi ka upisyal. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Te peggakap dan e te weyig, insalukagmit e si Pilipi te Panisingan te Magbebaye, ne warad e nakita sikandin te upisyal, piru migpabulus ka upisyal ne miggipanew ne nahale-gale. ");
INSERT INTO mbtNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Te naalimukawan e si Pilipi, diye bes e sikandin te Asutu, ne migpabulus e man-e sikandin ka egwali te Meupiya ne Panugtulen diye te langun ne lungsud taman te pegginguma rin diye te Sisarya. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Te seeye ne timpu, migpabulus si Saulu ka eglelalis ne egpangimatey te me hibateen te Magbebaye. Purisu miggendiye sikandin te Labew ne Talagpanubad ");
INSERT INTO mbtNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","eyew egbuyu te me sulat ne eg-uyanen din diye te me simbaan te me Hudiyu diye te Damasku. Iyan din igbuyu te sulat su eyew due katenged din te pegpandakep ke due egkakita rin ne eg-ikul te Magbebaye wey eg-uyanen din te eglibed diye te Hirusalim, lukes ma wey ke malitan. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Te peggendiye din te Damasku, wey te marani e sikandin te siyudad, sahuhune ne due malayag ne egligkat te langit ne nakaalingkus kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nataman, napeled e sikandin, ne due laheng ne narineg din ne migkahi, “Saulu, Saulu. Mania te migbaybayaran a nikeykew?” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ne mig-inse sikandin, “Hentew ke ma, Magbebaye?” Ne migkahi ka laheng, “Sikeddi si Hisus ka imbaybayaran nu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ne enew kad wey hipanew kad peendiye te siyudad wey diye kad e egnangeni ke nekey ka eggimuwen nu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ne ka me etew ne duma ni Saulu te hipanawan, nenakasasindeg de ne natanengan. Nakarineg sikandan te laheng piru ware etew ne nakita ran. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ne dutu mig-enew e si Saulu, peggimelat din, kenad e egpakakita sikandin. Purisu ingkitkit naan de sikandin te me duma rin peendiye te Damasku. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tatelu ne aldew ne kene sikandin egpakakita, wey ware degma migkeen wey mig-inum. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ne diye te Damasku, due sabeka ne hibateen ni Hisus ne egngaranan ki Ananiyas. Ne hendue te impataheinep sikandin te Magbebaye ne migkahiyan, “Ananiyas.” Ne migtabak si Ananiyas, “Seini e red, Magbebaye.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ne migkahiyan sikandin te Magbebaye, “Hipanew ka peendiye te dalan ne egngaranan te ‘Matul-id ne Dalan,’ wey pamitawa nu diye te baley ni Hudas ka sabeka ne etew ne egngaranan ki Saulu ne matig-Tarsu. Eg-ampu sikandin ");
INSERT INTO mbtNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wey diye te impakita kandin te Manama, due nakita rin ne sabeka ne etew ne egngaranan ki Ananiyas ne migseled wey migtel-eb kandin te me belad din su eyew egpakakite e man-e sikandin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ne migtabak si Ananiyas, “Magbebaye, masalig ka nakahuhud keddiey meyitenged te sika ne etew, ne subla kun ne mareet ka eggimuwen din te keet-etawan nu diye te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne kuntee, kayid e sikandin te Damasku ne imbehayan te katenged te me pangulu te talagpanubad te pegdakep te langun ne egpamakey keykew.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piru migkahiyan sikandin te Magbebaye, “Hendiyei nu su in-alam ku sikandin eyew te pegpataha te keddi ne ngaran diye te me kene ne me Hudiyu wey diye te me Hari wey diye te me kabuhalan ni Israil. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne igpapitew ku kandin ka langun ne eg-antusen din tenged keddiey.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Purisu miggendiyaan e ni Ananiyas si Saulu te baley wey migtel-eban din te me belad din te migkahi, “Suled, ka Magbebaye ne si Hisus ne migpakita keykew te peggendini nu ka migpeuyan keddiey su eyew egpakakita kad e man-e wey egkapenu te Panisingan te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sahuhune ne due neneulug diye te mata ni Saulu ne hendue te me engil, ne dutu, nakakite e man-e sikandin. Ne mig-enew sikandin wey migpabewutismu e. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Te nakakeen e sikandin, miglibed e man-e ka kanekal din. Ne mig-ugpe pad si Saulu diye te Damasku seled te pila ne aldew duma te me hibateen ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Due-rue miggendiye sikandin te me simbaan te me Hudiyu eyew te pegpanugtul ne si Hisus ka Anak te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Neinu-inu ka langun ne nakarineg kandin wey migmein-inseey ne migkahi, “Henduen ma te seini ka diye te Hirusalim ne egbayad-bayad te seeye se egpamakey ki Hisus. Ne kema ke iyan din de iggendini ka egpandakep te eg-uyanen din diye te me pangulu te talagpanubad?” ");
INSERT INTO mbtNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Piru migmasumpit ka pegwali ni Saulu wey amana nakasuhat te migpammineg kandin. Ne ware nakaapul ka me Hudiyu diye te Damasku puun te pegpamalehet ni Saulu ne si Hisus ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Te peglihad te masalig ne me aldew, migplanu ka me pangulu te me Hudiyu te peggimatey ki Saulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Piru nakarineg si Saulu ke nekey ka planu ran ne eggimuwen. Aldew wey marusilem ka peg-eatang dan diye te gumawan te siyudad eyew te peggimatey ki Saulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Piru te sabeka ne marusilem, intahu si Saulu te me hibateen diye te bukag wey intutuntun diye te bintana te alad te siyudad ne matikang wey makepal. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ne puun dutu, miggendiyad e si Saulu te Hirusalim wey migduma-rume e perem sikandin te me hibateen ni Hisus dutu. Piru naaldek kandin ka langun su ware sikandan migpalintutuu ne sabeke e degma sikandin ne hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piru imbulihan e sikandin ni Birnabi wey in-uyan diye te me apustulis. Nataman, impangguhuran e sikandan ni Birnabi ke immenu te Magbebaye te migpakita wey migpakiglalag ki Saulu diye te dalan peendiye te Damasku, wey ke immenu rin te pegwali te ngaran ni Hisus diye te Damasku te ware pegkaaldek. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Purisu nakarume e si Saulu kandan wey in-empet dan ka Hirusalim te pegwali te ngaran te Magbebaye ne si Hisus te ware pegkaaldek. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ne nekeglalag wey nenekeg-apul sikandan te me Hudiyu ne Grigu se linalahan piru migpammitew sikandan te paahi ne egkeyimatayan sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Te pegkanengnengi te me suled ne migpalintutuu, in-uyan dan e si Saulu diye te Sisarya wey impeendiye te Tarsu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Purisu ka migmalintutuu diye te intiru ne Hudiya, Galiliya, wey diye te Samarya, nalig-en e wey warad e samuk. Ne migmasalig pad sikandan tenged su due pegkaaldek dan te Magbebaye wey imbagget sikandan te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nekey naa te si Pidru, miggiphipanew sikandin te minsan hendei, nataman, miggendiye sikandin te keet-etawan te Manama diye te lungsud te Lida. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ne diye din nakita ka pungku ne lukes ne egngaranan ki Iniyas, ne ware nekeenew seled te walu ne leg-un. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ne migkahiyan sikandin ni Pidru, “Iniyas, egbawian ka ni Hisu Kristu, purisu enew ka wey paninesa nud ka miggibatan nu.” Ne due-rue ne mig-enew si Iniyas. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne ka langun ne etew ne mig-ugpe diye te Lida wey diye te Sarun, nakakita kandin wey migpalintutuu e te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ne diye te Hupi, due malitan ne migpalintutuu ne egngaranan ki Tabita. Ne layun sikandin eggimu te meupiya wey egbulig te egkaayu-ayu. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Te seeye ne timpu, migderalu sikandin wey migpatey. Ne ka lawa rin, miglu-luan dan wey impaley-as dan diye te sinabeng ne diye te dibabew. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ne ka Hupi, bayew re marani te inged ne Lida. Te pegkarineg te me hibateen diye te Hupi ne diye si Pidru te Lida, migsuhu e sikandan te daruwa ne lukes wey impanagtahaan ne egpeendiyeen egparagdahawa si Pidru te Hupi. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Purisu migdume e si Pidru kandan. Te pegginguma ran, impanulud e si Pidru diye te sinabeng ne diye te dibabew. Ne dutu, miglingutan e si Pidru te langun ne me malitan ne balu ne egmaninehew wey impapitew ran kandin ka me kumbale wey ka me dyakit ne innimu ni Durkas te neuyag pad sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nataman, impalihawang e sikandan langun ni Pidru, ne dutu, migpanimbuel sikandin wey mig-ampu diye te Manama. Ne nataman, migtangkaan din e ka minatey te migkahi, “Tabita, enew ka.” Ne miggimelat e si Tabita, pegkakita rin ki Pidru, henduen pad ne migpinnuu sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Miggen-genan ni Pidru ka belad te malitan wey impasasindeg din. Nataman, in-umew rin e ka migmalintutuu wey ka me balu, wey impakita rin e kandan si Durkas ne neuyag e. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nekeempet te intiru ne Hupi ka guhuren meyitenged kandin wey masulug ka me etew ne migpalintutuu te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ne mig-uugpe pad si Pidru diye te Hupi seled te me pila ne aldew diye te ki Simun ne talagderampil te laplap te ngalap. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Due lukes ne egngaranan ki Kurnilyu ne diye mig-ugpe te siyudad te Sisarya. Sabeka sikandin ne kepitan te Rumanhun ne me sundalu ne egngaranan te “Punduk te Italyanu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Migpamakey sikandin te Manama wey migsimba te Manama duma te langun ne pamilya rin. Dakel ka nabulig din diye te me etew ne egkaayu-ayu, wey layun eg-ampu sikandin diye te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sabeka ne maapun te me alas tris e, hendue te impataheinep sikandin te Manama. Nakita rin ka sabeka ne panalihan te Manama ne migparani kandin wey migkahi, “Kurnilyu!” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Migmemetmet sikandin te panalihan duma te pegkaaldek ne mig-inse, “Nekey-a, Ahalen?” Ne migkahi ka panalihan, “Indawat e te Manama ka peg-ampu nu wey ka pegbulig nu diye te egkaayu-ayu, wey ware ka nikandin nalingawi. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ne kuntee, suhu ka te me lukes ne egpeendiyeen te Hupi ne egpaangayen te lukes ne egngaranan ki Simun Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Diye sikandin miglemung ki Simun ne talagderampil te laplap te ngalap, marani te dahat ka baley rin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Te peg-awe e te panalihan ne miglalag kandin, migpangumew e si Kurnilyu te daruwa ne suluhuanen din wey sabeka ne sundalu ne sinalihan din ne migpamakey degma te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ne dutu, impangguhuran din e sikandan te innangen kandin te panalihan te Manama. Nataman, impeendiye din e ka tatelu ne etew diye te Hupi. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Te seup ne aldew, te sasangan e sikandan ne miggipanew, wey te marani e sikandan diye te siyudad, migpamaneyik si Pidru diye te atep eyew eg-ampu, meudtu en iya seeye. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ne dutu, miggutasan e si Pidru wey egkeupian e ne egkeen. Taheed te nanusubba pad te egkeenen, hendue te impataheinep sikandin te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakita rin ne nalukatan ka langit wey due intuntun kayi te tane ne egpekeiling te dakel ne manggad ne miggiketan ka tagse pikungan. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iyan tahu dutu ka langun ne klasi te me ngalap ne egmangipanew wey egmanlayang wey egmandul-ug. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ne due laheng ne migkahi kandin, “Pidru, enew ka wey gilang ke naa wey keen ka!” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piru migtabak si Pidru, “Kena a Magbebaye, su ware e pad nakakeen te minsan nekey ne in-isip ney te me Hudiyu ne malindit wey ke mareet naa.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ne migkahi man-e ka laheng, “Kene nu sumsumana ne malindit ka minsan nekey ne inlinisan e te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Neyitabu seini te katatelu, ne nataman, miglibed ded diye te langit ka intuntun. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ne taheed te migsusuman-suman pad si Pidru ke nekey ka kaluwasan te impakita kandin, mig-inse e ka me etew ne insuhu ni Kurnilyu ke hendei lenged ka baley ni Simun. Diyad e sikandan te egkatangkaan te gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne migpangumew sikandan ka mig-inse ke miglemung naa dutu si Simun ne egngaranan ded degma ki Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Te seeye ne timpu, migpabulus pad si Pidru ka egsusuman-suman te impakita kandin. Ne migkahiyan sikandin te Panisingan te Manama ne miggenendue, “Due tatelu ne etew ne egpammitew keykew. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ne enew ka wey pamaneug ka wey kene ka duwa-ruwa ka egduma kandan su sikeddiey ka migpeendini kandan.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Purisu, migpamaneug e si Pidru wey migkahi diye te me etew, “Sikeddiey ka egpamitawen niyu. Ne mania te miggendini kew?” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ne migtabak sikandan, “Impeendini key ni Kurnilyu ne kepitan te me sundalu. Matareng sikandin ne etew wey migpamakey degma te Manama, wey amana tahura te langun ne me Hudiyu. Insuhu sikandin te matulus ne panalihan te Manama ne egpeyinggaten keykew te eggendiye te baley rin eyew egpakarineg sikandin te iglalag nu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nataman, impalasud e ni Pidru ka me etew wey diyad sikandan peyirehaa te seeye ne karusileman. Pegkapawe, migparumeey e sikandan duma man-e te migmalintutuu ne diye egpuun te Hupi. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Te seup e man-e ne aldew, henduen pad ne nekeuma sikandan diye te Sisarya. Ne migtetahad e kandan ensi Kurnilyu duma te me pamilya rin wey me alukuy rin ne impanginggat din. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ne hengkayi te eglasud e perem si Pidru, migsinug-ung de sikandin ni Kurnilyu ne mig-usengul diye te tangkaan din ka egsimba kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piru impasasindeg sikandin ni Pidru wey migkahiyan, “Sasindeg ka. Etew e re degma.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ne miglasud e si Pidru ka migpahuhurey ka Kurnilyu. Ne iyan din nakita ka masalig ne etew ne nalibulung diye te seled. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne migkahiyan sikandan ni Pidru, “Nakanengneng kew e ne sikanami se me Hudiyu, ingkenaan ne egduma-ruma wey ke egpanumbaley te kene ne me Hudiyu. Piru impapitew a te Manama te keilangan ne kene ku egsumsumanen ne malindit wey ke mareet ka minsan hentew. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Purisu te pegpaangey niyu keddi, wara a mig-apul. Ne eg-insa a kaniyu, mania te impeendini a nikaniyu?” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ne migkahi si Kurnilyu, “Te iling kayi ne uras, te me alas tris te maapun te seeye se neep-atan, mig-ampu a diye te seled te baley ku. Sahuhune ne due sabeka ne lukes ne migkukumbale te egpakasilang ne migsasindeg kayi te tangkaan ku ");
INSERT INTO mbtNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wey migkahi, ‘Kurnilyu, narineg te Manama ka peg-ampu nu wey nakita rin ka pegbulig nu diye te egkaayu-ayu. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ipaangey nu diye te Hupi si Simun Pidru, diye sikandin miglemung ki Simun ne talagderampil te laplap te ngalap ne diye te marani te dahat.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Purisu impaangey ku sikeykew paragdahawi wey salamat te miggendini ka. Ne kuntee, seini key langun te tangkaan te Manama ka egpammineg te langun ne igpalalag keykew te Magbebaye.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ne migkahi si Pidru, “Kuntee nanengnengan kud e ne ware bes iya indapihan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ka etew ne due pegkaaldek te Manama wey matareng ka eggimuwen, egdawaten sikandin te Manama minsan ke nekey ka tribu rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nakataha kew e te guhuren ne impeuyan din kayi te me kabuhalan ni Israil, ne migpanugtul te Meupiya ne Panugtulen ne egpekeg-uli ka meupiya ne geyinawa ta kandin pinaahi ki Hisu Kristu, ka Magbebaye te langun ne etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nakataha kew e man-e te neyitabu diye te intiru ne prubinsya te Hudiya, ne migbunsud diye te Galiliya te pegkapenga ni Huwan te migwali meyitenged te bewutismu. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ne nakataha kew e man-e meyitenged ki Hisus ne matig-Nasarit ne in-alam te Manama wey imbehayan te Panisingan din wey geem. Ne puun su migdumaan sikandin te Manama, miggiphipanew sikandin ne miggimu te meupiya wey migpamawi te langun ne etew ne migbaybayaran te ahalen te me busew. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ne sikanami ka egpamalehet te langun ne neyimu rin diye te siyudad te Hirusalim wey diye te duma ne lungsud te me Hudiyu. Innimatayan dan sikandin pinaahi te peglansang kandin te krus. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piru in-uyag sikandin te Manama te igkatelu ne aldew wey migpakita pad sikandin kanami. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ware migpakita sikandin te langun ne etew, ke kene, kayi re te kanami te in-alam te Manama ne talagpamalehet. Te neuyag e sikandin, nenekegduma key pad iya ka migkeen wey mig-inum. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Insuhu key nikandin te pegwali te Meupiya ne Panugtulen diye te me etew, wey te pegpamalehet ne sikandin iya ka in-alam te Manama te peggukum te neuyag pad wey te nammatey e. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Si Hisu Kristu ka ingguhud te langun ne me prupita ne ka minsan hentew ne egpalintutuu kandin, egkapasaylu se me sale pinaahi te ngaran din.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Te sasangan pad ne eglalag si Pidru, miglene ka Panisingan te Manama diye te langun ne migpammineg te wali. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Neinu-inu ka migmalintutuu ne me Hudiyu ne migduma ki Pidru puun te Hupi te migbehayan degma te Manama te Panisingan ka kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Su nakarineg sikandan te kene ne me Hudiyu ne eglalag te nalein-lein ne me linalahan wey migdayan te karesen te Manama. Ne dutu, migkahi e si Pidru, ");
INSERT INTO mbtNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Minsan kene sikandan ne me Hudiyu, piru nakarawat te Panisingan iling te pegkarawat ta degma. Purisu, kene ne meupiya ke egbalabahan sikandan ka egpabewutismu te weyig.” ");
INSERT INTO mbtNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nataman, insuhu din e sikandan ne egpabewutismu te ngaran ni Hisu Kristu. Pegkapenga dutu, inhangyu dan e si Pidru ne diye pad egpeugpaa te kandan seled te me pila ne aldew. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na, ka me apustulis wey ka me suled ne migmalintutuu diye te Hudiya, nakarineg ne nakarawat e degma te lalag te Manama ka kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Purisu te peglibed ni Pidru diye te Hirusalim, inlemetan e sikandin te punduk te me Hudiyu ne migpalintutuu ki Hisus piru mig-uyun ne ka kene ne Hudiyu, keilangan ne egtulian henduen pad ig-apil kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ne migkahiyan dan si Pidru, “Mania te migpanumbaley ka te kene ne me Hudiyu ne ware natulii, wey migpakigtuhen kandan te egkeen?” ");
INSERT INTO mbtNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Purisu impangguhuran e sikandan ni Pidru puun te pegbunsud ");
INSERT INTO mbtNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ne miggenendue, “Te timpu ne mig-ampu a te diye e pad te siyudad te Hupi, hendue te impataheinep a te Manama. Nakakita a te hendue te dakel ne manggad ne intuntun puun te langit ne miggiketan ka tagse pikungan, ne diye te lenged ku migsanggel. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Migmelmelehan ku ay-ayari ka tahu dutu, ne iyan ku nakita ka me ayam, ka me mahintalunan ne mananap, ka me ngalap ne egdul-ug, wey ka me manuk-manuk ne eglayang diye te aw-awangan. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nataman, due laheng ne narineg ku ne migkahi keddi, ‘Pidru, enew ka wey gilang ke naa wey keen ka!’ ");
INSERT INTO mbtNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Piru migtabak a, ‘Kena a Magbebaye, su ware e re due nakakeen te in-isip ney te me Hudiyu ne malindit wey ke mareet naa.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ne migkahi e man-e ka laheng ne diye egpuun te langit, ‘Kene nu sumsumana ne malindit pad ka miglinisan e te Manama.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katatelu seini neyitabu. Nataman, miglibed e man-e diye te langit. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Te seeye iya ne timpu, due tatelu ne etew puun te Sisarya ne migginguma diye te baley ne in-ugpaan ney ne egpaangayen keddi. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ne migkahiyan a te Panisingan te Manama ne egparumeen kandan te ware pegduwa-ruwa. Ne due degma seini se hen-em ne migmalintutuu ne migduma keddi peendiye te Sisarya, wey migseled key langun te baley ni Kurnilyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne dutu, migpangguhuran key e ni Kurnilyu te pegkakita rin te panalihan te Manama ne migsasindeg diye te seled te baley rin ne migkahi, ‘Suhu ka te egpeendiyeen te Hupi ne egpaangayen te etew ne egngaranan ki Simun Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Due pangguhuren din ne egpakaluwas keykew duma te langun ne sakup te pamilya nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne hengkayi te migbunsud ad ka eglalag, miglene e ka Panisingan te Manama diye te kandan ne egpekeiling te peglene degma kanta te an-anayan. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ne puun dutu, nasuman-suman kud ka ingkahi te Magbebaye, ‘Si Huwan, migpamewutismu te weyig, piru sikaniyu, egbewutismuwan te Panisingan te Manama.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Purisu seeye se neyitabu, migpamalehet ne ka imbehey te Manama kanta te me Hudiyu te timpu ne migpalintutuu ki te Magbebaye ne si Hisu Kristu, imbehey e degma diye te kene ne me Hudiyu. Ke seini ka igkeupii te Manama, hentew e ma ka eg-apul kandin!” ");
INSERT INTO mbtNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Te pegkarineg dutu te migmalintutuu ne me Hudiyu, migpeeneng-eneng e sikandan. Ne indayan dan e ka Manama te miggenendue, “Ke iling ma due, imbehey bes e degma diye te kene ne me Hudiyu ka timpu te peg-inniyug te me sale, su eyew egpakaangken sikandan te umul ne ware egtamanan.” ");
INSERT INTO mbtNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Puun te pegpatey ni Istiban, nenekegsuwey-suwey e ka migmalintutuu tenged te pegbayad-bayad kandan. Ka duma, nekeendiye te Pinisiya, te Sipri, wey diye te Antiyukiya, ne impangguhud dan ka Meupiya ne Panugtulen diye de te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Piru due duma ne matig-Sipri wey matig-Sirini ne migpalintutuu ki Hisus ne miggendiye degma te Antiyukiya, ne migpangguhud te Meupiya ne Panugtulen meyitenged te Magbebaye ne Hisus diye te kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ne due geem te Magbebaye diye te kandan wey puun dutu, masalig amana ka migpalintutuu wey migsalig te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ne seini se neyitabu, narineg te me punduk te migmalintutuu diye te Hirusalim. Purisu impeendiye dan e si Birnabi te Antiyukiya. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te pegginguma rin diye, nahale sikandin te nakita rin ne ingkeyid-u te Manama ka me etew diye. Ne imbagget din sikandan ne eg-ikul te Magbebaye puun te pusung dan wey kene eg-engked ne egsalig kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Meupiya ne etew si Birnabi, napenu sikandin te Panisingan te Manama wey manekal ka pegpalintutuu rin. Ne amana ne masalig ne etew ka migpalintutuu te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nataman, miggendiyad e si Birnabi te Tarsu ka egpammitew ki Saulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ne hengkayi te nakita rin e si Saulu, induma rin e diye te Antiyukiya. Ne migduma-ruma sikandan te me punduk te migmalintutuu diye seled te senge leg-un, wey masalig ne etew ka napanulu dan. Ka me hibateen diye te Antiyukiya ka an-anayan ne migngaranan te Kristuwanen. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Te seeye ne timpu, due me prupita ne migpangendiye te Antiyukiya ne diye egpuun te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ne due sabeka kandan ne egngaranan ki Agabu ne migsasindeg, ne pinaahi te geem te Panisingan te Manama, migpangguhud sikandin te impanengneng te Manama ne due dakel ne gutas ne egginguma te intiru ne kalibutan. Neyitabu seini te timpu ne si Klawdiyu ka Impiradur diye te Ruma. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ne puun dutu, nenekegsabut ka me hibateen ne ka tagse sabeka kandan egpeuyan sumale te egkeyimu ran ne igbulig te me duma ran ne migpalintutuu ki Hisus diye te Hudiya. ");
INSERT INTO mbtNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne innimu ran seeye, ne nataman, impeuyan dan e engki Birnabi ki Saulu eyew igbehey diye te me igbuyag te migmalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Te seeye ne me timpu, migbunsud e si Hari Hirudis ka egbayad-bayad te duma ne me punduk te migmalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ne ka suled ni Huwan ne si Santiyagu, impeyimatayan ni Hirudis pinaahi te kampilan. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Te nakita ni Hirudis ne nahale ka me pangulu te me Hudiyu te innimu rin, imparakep din e degma si Pidru. Neyitabu seini te timpu te Sahakeen te Paan ne ware Patulin. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ne dutu, indakep dan e si Pidru wey impaprisu. Impatamengan dan te hep-at ne punduk ne me sundalu ne tighep-at-hep-at ka tagse punduk. Isip ni Hirudis ne diye eggusaya ka kasu ni Pidru te tangkaan te me etew pegkapenga te Sahakeen te Paan ne ware Patulin. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Purisu diye de iya itahu si Pidru te prisuwan. Piru migpakannekal mig-ampu ki Pidru ka me punduk te migmalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Te seeye ne karusileman te igpalihawang e sikandin ni Hirudis te pegkapawe, newulep sikandin ne impataliwaraan te daruwa ne me sundalu, wey imbaku pad te daruwa ne keddina. Ne duen pad man-e migtameng diye te gumawan te prisuwan. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sahuhune ne due migsasindeg ne panalihan te Magbebaye wey nalayahan ka prisuwan. Nataman, impukew e te panalihan si Pidru ne inwelwel se pamanayen te migkahi, “Enew ka rue! Mahaan ka!” Ne sahuhune ne neekad ka me keddina diye te belad ni Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ne migkahi e ka panalihan, “Sisinturun kad wey sesandal kad.” Ne intuman iya degma ni Pidru. Ne migkahi e man-e ka panalihan, “Kukuyumbu ka wey sinundul ka keddi.” ");
INSERT INTO mbtNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ne migsinundul e degma sikandin te panalihan ne eglihawang diye te prisuwan. Ne ware nakataha si Pidru ke malehet naa ka neyitabu su kahiyen din ne taheinep din de seeye. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ne ka seeye se an-anayan ne talagtameng, inliharan dan de wey ka igkarangeb degma. Pegginguma ran diye te putew ne gumawan ne egkatangkaan te siyudad, nalukatan de due te kandin ka seeye ne gumawan. Purisu nakalihawang e sikandan. Ne hengkayi se nakalihad e sikandan te sabeka ne kelesadda, sahuhune ne mig-awe ka panalihan. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ne henduen pad ne naalimukawan si Pidru, ne migkahi sikandin, “Kunteen ku pad nataheyi ne malehet bes iya ne migpeuyan ka Magbebaye te panalihan din eyew te pegluwas keddi puun ki Hirudis wey diye te langun ne planu te me pangulu te Hudiyu ne eggimuwen dan perem.” ");
INSERT INTO mbtNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Te naalimukawan e si Pidru, miggendiyad e sikandin te baley ni Mariya ne iney ni Huwan Markus. Ne masalig ne me etew ka nalibulung diye te kandan ne mig-ampu. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ne migpanektek si Pidru diye te gumawan. Ne due suluhuanen ne egngaranan ki Ruda ne eglulukat perem te gumawan. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pegkeileyi rin te laheng ni Pidru, nalingawan din e te eglukat ka gumawan tenged te kahale din, wey migpallahuy e sikandin ka mignangen te diyad e te lihawangan si Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ne migkahiyan dan si Ruda, “Egkeungel kad!” Piru egkanasnasian si Ruda ka egmemalehet, purisu migkahi e sikandan, “Panalihan buwa ni Pidru ka due.” ");
INSERT INTO mbtNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ne si Pidru degma, egkalihet e ne egpanektek. Ne hengkayi te miglukatan dan e ka gumawan, nawangalan sikandan te pegkakita ran ki Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piru migtingyasan sikandan ni Pidru te singkalahan, kene kew lalag. Ne dutu, migpangguhuran e sikandan ni Pidru ke immenu sikandin te pegpalihawang te Magbebaye diye te prisuwan. Ne migkahi si Pidru, “Guhuri niyu degma si Santiyagu wey ka duma ne me suled ta meyitenged kayi.” Ne nataman, mig-awe e sikandin wey miggendiyad te lein ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Te seeye ne maselem, nasamuk e ka me talagtameng te prisuwan su ware sikandan nakataha ke nekey ka neyitabu ki Pidru. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ne puun dutu, migsuhu si Hirudis ne igpepammitew si Pidru, piru ware dan nakita. Purisu impeinsaan e ka me talagtameng, ne nataman, impeyimatayan din e. Nataman, mig-awe e si Hirudis te Hudiya ne miggendiyad te Sisarya, ne diye sikandin mig-ugpe te bayew naluhey. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na, si Hari Hirudis, amana nabelu te matig-Tiru wey te matig-Sidun. Purisu, nasabeka ka me etew ne egpakighusey te Hari, piru ka an-anayan ne innimu ran, in-alukuy pad nikandan si Blastu eyew egbulig kandan su iyan sikandin sinalihan te palasyu te Hari. Nataman, imparaniyan dan ka Hari te migpakighusey, tenged su ka me lungsud dan, diye de egkuwa te egkakeen te kandin ne nasud. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Te pegginguma te aldew ne egpakigkite e si Hari Hirudis te matig-Tiru wey te matig-Sidun, migsaluub sikandin te kumbale din te pegkahari wey migpinnuu diye te trunu rin. Nataman, miglalag e sikandin diye te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ne migbalbalukan ka me etew ne migkahi, “Kenad ne etew ka miglalag su maname e.” ");
INSERT INTO mbtNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Due-rue ne miglegparan te panalihan te Magbebaye si Hirudis su ware din tahura ka Manama. Nataman, mig-uleran e sikandin wey migpatey. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Piru nakapabulus nekeempet ka lalag te Manama wey masalig ka nakapalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ne ensi Birnabi wey si Saulu, mig-uli e sikandan puun te Hirusalim su neimpusan dan e ka impeyimu kandan, wey induma ran si Huwan Markus. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Seini ka me talagpanulu diye te punduk te migmalintutuu te Antiyukiya: si Birnabi, si Simun ne eg-imuan te Nigru, si Lusyu ne matig-Sirini, si Manain ne diye migtulin te engki Gubirnadur Hirudis, wey si Saulu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Due sabeka ne aldew ne taheed te migsimba sikandan te Magbebaye wey migpuasa, migkahiyan sikandan te Panisingan te Manama, “Ilein niyu ensi Birnabi ki Saulu su eyew egpekeyimu sikandan te igpeyimu ku kandan.” ");
INSERT INTO mbtNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ne migpuasa wey mig-ampu sikandan, wey migtel-eban dan e ensi Birnabi ki Saulu te me belad dan. Nataman, impeyipanew ran e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Purisu nangipanew e ensi Birnabi ki Saulu ka insuhu te Panisingan te Manama peendiye te Siliusya. Ne puun dutu, nanguntud e sikandan te barku peendiye te Sipri ne pulu te dahat. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Te pegginguma ran diye te siyudad te Salamis, impangguhud dan e man-e ka lalag te Manama diye te me simbaan te me Hudiyu. Ne si Huwan Markus ka egbulig-bulig te eggimuwen dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","In-empet dan ka pulu te dahat te miggendiye taman te nekeuma sikandan diye te Papus. Ne diye dan nalambag ka salamangkiru ne si Bar-Hisus. Hudiyu sikandin ne mig-angken ne prupita kun te Manama, piru kene ne malehet. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Alukuy sikandin ni Sirgiyu Paulu te matagseb ne etew wey gubirnadur te seeye ne pulu. Impeumew ni Sirgiyu ensi Birnabi ki Saulu su egkeupian sikandin ne egpammineg te lalag te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Piru migbalabahan sikandan ni Ilimas ne salamangkiru (si Ilimas ka ngaran ni Bar-Hisus te linalahan te Grigu), su iyan din igkeupii ne kene egpakapalintutuu ka gubirnadur. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ne si Saulu ne egngaranan degma ki Pablu ne napenu te Panisingan te Manama, immemetmetan din te egtetengteng ka salamangkiru ");
INSERT INTO mbtNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","te migkahi, “Anak ka ni Meibulan! Kuntere ka te langun ne matareng. Layun kad egpanlimbung wey eg-uubat, wey ka kamalehetan ne egpuun te Magbebaye, layun nu eggimuwa ne ubat. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ne kuntee, eglegparan ka te Magbebaye, bayew egkaluhey ne kene ka egpakakita te kalayag te aldew.” Ne sahuhune ne migmarusilem ka pegtengteng ni Ilimas, wey nakapanamsam naan de sikandin ka egpammitew te egkitkit kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nakapalintutuu e ka gubirnadur te pegkakita rin te neyitabu, wey nawangalan sikandin te pegpanulu meyitenged te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nataman, nanguntud e te barku ensi Pablu puun te Papus peendiye te siyudad te Pirga ne sakup te Pampilya. Ne si Huwan Markus, migsuwey e mule kandan ne miglibed diye te Hirusalim. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Puun te Pirga, nangendiyad e sikandan te Antiyukiya ne sakup te prubinsya te Pisidiya. Pegginguma te Aldew te Peggimeley, naneled e sikandan diye te simbaan te me Hudiyu wey naminnuu e diye. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Te nakapenge e ka migbasa te Balaud ni Muwisis wey te sinulat te me prupita, impasuhuan e te me upisyal te simbaan te Hudiyu ensi Pablu te miggenendue, “Me suled, ke due igkalalag niyu ne egpakabagget te me etew, egkaayun ne egpakalalag kew.” ");
INSERT INTO mbtNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ne migsasindeg si Pablu ne migtingyas pinaahi te belad din diye te kandan ne migkahi, “Kabuhalan ni Israil, wey sikaniyu se kene ne me Hudiyu ne due pegkaaldek te Manama: pammineg kew keddi! ");
INSERT INTO mbtNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ka Manama te kabuhalan ni Israil ka mig-alam te kaap-apuan ta, wey ka migpeyibuhal kandan wey migpanalangin kandan te diye pad sikandan te Ihiptu. Ne pinaahi te karesen din, impaawe din sikandan diye te Ihiptu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne seled te hep-at ne pulu (40) ne leg-un, naantus te Manama ka pegsukul ran kandin diye te mammara ne inged ne kene egkeugpaan. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ne due imparereetan din ne pitu ne nasud diye te Kanaan, wey iyan din e impakamkamuney te seeye ne tane ka keet-etawan din ");
INSERT INTO mbtNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","seled te me 450 ne leg-un. “Te pegkeimpus dutu, migbehayan din e sikandan te talaggukum taman te timpu ni prupita Samwil. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nataman, migbuyu e man-e sikandan te Hari, ne imbehayan sikandan te Manama ki Saulu ne anak ni Kis ne kabuhalan ni Binhamin eyew iyan eghari diye te kandan seled te hep-at ne pulu (40) ne leg-un. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ne hengkayi te impaawe e sikandin te Manama, si Dabid e man-e ka innimu te Manama ne Hari dan. Seini ka ingkahi te Manama meyitenged kandin, ‘Nakita ku ne si Dabid ne anak ni Hisi, egpakapahale keddiey. Egtumanen din ka langun ne igpeyimu ku kandin.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ka kabuhalan ni Dabid ne egngaranan ki Hisus, ka in-alam te Manama eyew te pegluwas te me kabuhalan ni Israil sumale te insaad din. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Te ware pad migbunsud si Hisus te himu rin, tapey e migwali si Huwan diye te langun ne kabuhalan ni Israil meyitenged te peg-inniyug te sale wey te pegpabewutismu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne hengkayi te mahaan e egkapenga ka himu ni Huwan, mig-insaan din e ka me etew, ‘Diye te suman-suman niyu, hentew e buwa? Su kene ne sikeddiey ka egtetaharan niyu. Piru due egpakasinundul keddi, ne minsan se peggekad te sandal din, kena a ne likes.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Me suled ku, sikaniyu se me kabuhalan ni Abraham wey sikaniyu degma se me duma ne due pegkaaldek te Manama, sikanta ka impeuyanan te seini se guhuren meyitenged te kaluwasan! ");
INSERT INTO mbtNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Su ka matig-Hirusalim, wey ka me pangulu ran, ware nekeila ne si Hisus ka Manluluwas. Ware man-e sikandan nakasabut te inlalag te me prupita ne egbaseen dan te tagse Aldew te Peggimeley. Piru sikandan de iya ka nakapatuman te ingkahi te me prupita te pegpeyimatey ran ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne minsan ware malehet ne katarengan ne nakita ran eyew egkeyimatayan dan si Hisus, piru imbuyu dan iya ki Pilatu ne egpeyimatayan si Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Te natuman e nikandan ka langun ne nasulat te Kasulatan meyitenged kandin, ingkuwa ran e ka lawa ni Hisus diye te krus wey inluglug dan e sikandin diye te inlungahan ne dalama. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Piru in-uyag sikandin te Manama puun te kamatayen. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne migpakita pad sikandin te masalig ne aldew diye te me etew ne migduma-ruma kandin dengan puun te Galiliya peendiye te Hirusalim. Ne sikandan kuntee ka talagpamalehet te me kabuhalan ni Israil meyitenged kandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ne miggendini key kuntee eyew te pegpangguhud kaniyu te Meupiya ne Panugtulen ne ka insaad te Manama diye te me kabuybuyahan ta, ");
INSERT INTO mbtNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","intuman din kayi te kanta te me kabuhalan dan pinaahi te peg-uyag ki Hisus. Seini ka nasulat te igkarangeb ne Salmu ne miggenendue: ‘Anak ku sikeykew; Ne kuntee, igpanengneng ku ne amey ad e nikeykew.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tapey e migsaad ka Manama ne eg-uyahen din si Hisus ne kene egkamewu se lawa. Migkahi sikandin, ‘Igbehey ku keykew ka matulus wey malehet ne panalangin ne insaad ku ki Dabid.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ne sumale degma te nasulat diye te lein ne baad te Salmu ne miggenendue, ‘Kene nu ituhut ne egkamewu ka lawa te matulus ne suluhuanen nu.’ ");
INSERT INTO mbtNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Te natuman e ni Dabid ka impeyimu te Manama kandin te kandin ne timpu, migpatey e sikandin wey diye ilebeng te kakiliran te lebeng te kaapuan din. Ne ka lawa rin, namewu e. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Piru seeye se in-uyag te Manama, ware namewu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Purisu me suled ku, igpangguhud ney kaniyu ne pinaahi ki Hisus, egkapasaylu te Manama ka me sale ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ka minsan hentew ne egpalintutuu kandin, eg-isipen te Manama ne matareng. Ne sika, kene niyu egkeyimu pinaahi te pegtuman te Balaud ni Muwisis. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Purisu tanud-tanud kew eyew kene egkeyitabu diye te kaniyu ka inlalag te me prupita ne miggenendue, ");
INSERT INTO mbtNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Pitew kew, sikaniyu se me lemeten! Egkeinu-inu kew, ne egkataman, egpatey kew. Te kaniyu ne timpu, due eggimuwen ku ne kene kew egpakapalintutuu minsan ke due egpasabut kaniyu.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Te peglihawang enni Pablu ki Birnabi diye te simbaan, inninggat sikandan te me etew ne egpaliberen te seup ne Aldew te Peggimeley eyew te egpanulu kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Te nakalihawang e ka me etew, masalig ka me Hudiyu wey ka kene ne me Hudiyu ne neuyan te pegpalintutuu te me Hudiyu, ne migsinundul engki Pablu wey ki Birnabi. Ne dutu, miglalahan sikandan te me apustulis wey imbagget ne keilangan ne egpabulus sikandan ka egsalig te keupiya wey keyid-u te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Te seup ne Aldew te Peggimeley, hapit e egkaamin ka me etew diye te siyudad ka miglibulung eyew te pegpammineg te lalag te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Te pegkakita te pangulu te me Hudiyu ne amana masalig ka me etew, neimme e sikandan wey in-apul ran e ka inlalag ni Pablu, wey inlemetan dan e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Piru nasi de iya ne migmabulut ne eglalag ensi Pablu ki Birnabi ne migkahi, “Keilangan iya ne sikaniyu ka miggun-aan pangguhuri te lalag te Manama. Piru tenged su ware niyu ma sahipaa, ne seini migpeila ne kene kew ne likes ne egbehayan te umul ne ware egtamanan. Purisu, puun kuntee, eggendiye key e te kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Su seini ka insuhu te Magbebaye kanami: ‘Intahu ku sikeykew ne kalayag para te kene ne me Hudiyu, Eyew pinaahi keykew, egginguma ka kaluwasan minsan diye te katamanan te kalibutan.’ ” ");
INSERT INTO mbtNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ne nahale-gale ka kene ne me Hudiyu te narineg dan seeye, ne migkahi sikandan, “Mateles amana ka lalag te Magbebaye.” Ne migpalintutuu e seeye se naalam para te umul ne ware egtamanan. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne ka lalag te Magbebaye, nekeempet te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Piru intipu te me Hudiyu ka me pangulu te seeye ne siyudad duma te talahuren ne me malitan ne migpamakey te Manama, ne eyew egpakigkuntere e engki Pablu ki Birnabi, ne nataman, impepaawe e sikandan te seeye ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Impelpel enni Pablu ki Birnabi ka alinepung diye te paa ran, isip palinneu ne ware ikahale te Manama ka me mahinged dutu. Nataman, miggendiyad e sikandan te Ikuniyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ne amana ne nahale ka me hibateen diye te Antiyukiya wey napenu degma sikandan te Panisingan te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Diye te Ikuniyu, nangendiye ensi Pablu ki Birnabi te simbaan te me Hudiyu ne migwali te amana egpakasuhat. Ne puun te wali ran, amana ne masalig ka me Hudiyu wey ka kene ne me Hudiyu ne migpalintutuu ki Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Piru intipu te me Hudiyu ne ware migpalintutuu seeye se kene ne me Hudiyu eyew egkabelu degma sikandan te me suled ne migmalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ne naluhey pad mig-ugpe ensi Pablu wey si Birnabi dutu ka egwali te ware pegkaaldek meyitenged te Magbebaye. Impamalehetan te Magbebaye ka impanulu dan meyitenged te keupiya wey keyid-u rin pinaahi te pegbehey rin kandan te geem te peggimu te me kein-inuwan wey te me palinneu. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Piru nabaad ka me etew diye te siyudad su ka duma diye miglapig te me Hudiyu, ne ka duma degma diye migdapig te me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Migplanu ka me Hudiyu wey ka kene ne me Hudiyu duma te me pangulu ran ne egpasakitan dan ka me apustulis wey egbebatuwen dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Piru nanengnengan te me apustulis ka planu ran, purisu migpallahuy e sikandan diye te siyudad te Listra wey Dirbi, ne sakup te Likaunya, wey diye te nakaalingkus ne me inged. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ne diye, migwali man-e sikandan te Meupiya ne Panugtulen. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Due lukes ne pungku ne diye mig-ugpe te Listra. Ne kene egpekeyipanew sikandin puun te pegkeetew rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Migpammineg sikandin ki Pablu te miglalag. Ne migmemetmetan sikandin ni Pablu, wey nakita ni Pablu ne egpalintutuu sikandin ne egkeulian. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Purisu migkahiyan sikandin ni Pablu te meemen, “Tigkew ka sasindeg!” Ne migtigkan-tigkan migsasindeg ka etew wey miggiphipanew. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Te pegkakita te masulug ne me etew te innimu ni Pablu, migbalbalukan e sikandan te kandan ne linalahan ne Likaunyahen, “Migpamaneug kayi te kanta ka me manama ne impeiling te ulaula te etew!” ");
INSERT INTO mbtNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ne ingngengaranan e sikandan te me ngaran te me manama ran. Iyan igngaran ki Birnabi si Siyus, ne si Hirmis ka ki Pablu su sikandin ma ka tigwali. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ka timplu te manama ran ne si Siyus, marani re diye te lihawangan te siyudad. Purisu, ka pari ni Siyus, mig-uyan te me turu ne baka wey me bulak diye te gumawan te siyudad su egkeupian sikandin duma te me etew ne egpanubad diye te me apustulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Te pegkanengnengi enni Pablu ki Birnabi te iling due ka eggimuwen dan, inggisi dan e ka me kumbale dan te pegkalaggew, wey migpallahuy sikandan diye te taliware te me etew ne migbalbalukan ne migkahi, ");
INSERT INTO mbtNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Me suled, mania te eggimu kew te iling kayi? Sikanami seini, etew re degma iling kaniyu! Miggendini key kayi ka egpangguhud te Meupiya ne Panugtulen su eyew eg-inniyuhan niyud ka ware karuan ne me himu niyu. Parani kew te manekal ne Manama ne iyan miggimu te langit wey te tane, te dahat, wey te langun ne nakatahu kayi. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dengan ne timpu, intuhutan te Manama ka langun ne etew ne eggimu te igkeupii ran. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Piru migpeila pad ka Manama diye te me etew pinaahi te meupiya ne himu rin. Migbehayan kew nikandin te uran wey te egkahaani te eleg ne timpu; migbehayan kew degma nikandin te egkakeen wey migbehayan kew te kahale.” ");
INSERT INTO mbtNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Piru minsan inlalahan e sikandan te me apustulis, kene iya perem eg-engked ka me etew ne eggilang te me baka ne igpanubad diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ne due me Hudiyu ne nanginguma puun diye te Antiyukiya ne sakup te Pisidiya. Ne ka duma diye egpuun te Ikuniyu. Miglalahan nikandan ka me etew taman te migpalintutuu e kandan. Puun dutu, imbatu ran e si Pablu wey ingganuy diye te lihawangan te siyudad su kahiyen dan ne migpatey e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Piru te inlibulungan e sikandin te egmalintutuu ki Hisus, mig-enew e sikandin wey miglibed ded diye te siyudad. Te pegkapawe, miggendiyad e sikandan ki Birnabi te Dirbi. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ne migwali te Meupiya ne Panugtulen ensi Pablu wey si Birnabi diye te Dirbi, wey masalig ka migpalintutuu ki Hisus. Nataman, miglibed e man-e sikandan diye te Listra, diye te Ikuniyu, wey diye degma te Antiyukiya ne sakup te Pisidiya. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Inlig-en dan ka migmalintutuu wey imbagget ne egpabulus ne eg-ikul te kamalehetan. Impanulu dan pad man-e sikandan te miggenendue, “Keilangan ne masalig ka me keyirapan ne egkabayaan ta eyew egpakaseled ki te Migharian te Manama.” ");
INSERT INTO mbtNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Si Pablu wey si Birnabi ka mig-alam te eggimuwen ne igbuyag te tagse punduk te migmalintutuu. Mig-ampuan dan wey migpuasaan dan ka naalam dan, nataman imbehey ran e diye te Magbebaye ne insalihan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ne diye migbaye sikandan te Pisidiya, nataman, nangendiyad e sikandan te Pampilya. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ne inwali ran ka lalag te Magbebaye diye te Pirga, nataman, miggendiyad e sikandan te Atalya. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ne puun dutu, mig-untud e man-e sikandan te barku ne eglibed diye te Antiyukiya, ka inged ne migligkatan dan. Su dengan, mig-ampuan sikandan te migmalintutuu diye te Antiyukiya ne egbulihan sikandan te Manama te eggimuwen dan, ne kuntee, napenga ran e. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Te pegginguma ran diye, impalibulung dan ka punduk te migmalintutuu wey impangguhuran dan te langun ne innimu te Manama pinaahi kandan, wey ka paahi te Manama ne nakapalintutuu degma ka kene ne me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ne naluhey pad sikandan ka mig-ugpe diye duma te me hibateen. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Due me etew ne migginguma diye te Antiyukiya ne diye egpuun te Hudiya ne migpanulu te me suled ne migmalintutuu. Migkahi sikandan, “Kene kew egkaluwas ke kene kew egpatuli sumale te insuhu te Balaud ni Muwisis.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Amana migsupak ensi Pablu ki Birnabi meyitenged kayi, purisu neuyunan ne si Pablu ki Birnabi wey ka duma ne migmalintutuu diye te Antiyukiya ka egpeendiyeen te Hirusalim eyew egpakigkita te me apustulis wey te me pangulu diye meyitenged te seini ne prublima. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Purisu impeyipanew e sikandan te seeye se punduk te migmalintutuu. Te pegbaye dan diye te prubinsya te Pinisiya wey te Samarya, impangguhuran dan e sikandan meyitenged te kene ne me Hudiyu ne migpalintutuu e te Manama. Ne seeye, amana nakapahale te me suled te pegpalintutuu diye. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Te pegginguma enni Pablu diye te Hirusalim, insagsahipe sikandan te migmalintutuu diye, te me apustulis, wey te me igbuyag te simbaan. Migpangguhuran dan sikandan te langun ne innimu te Manama pinaahi kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Piru due migmalintutuu ne sakup te Parisiyu ne migsasindeg ne migkahi, “Keilangan ne egtulian ka kene ne me Hudiyu wey egpatumanen te Balaud ni Muwisis.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ne miglibulung ka me apustulis wey ka me igbuyag te migmalintutuu eyew te peggusey dutu. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Te nakapenge e sikandan ka migpaapuley te malmalayat, migsasindeg e si Pidru ka migkahi, “Me suled, nanengnengan niyud ne in-alam a te Manama dengan kayi te kaniyu eyew te pegpanulu te Meupiya ne Panugtulen diye te kene ne me Hudiyu eyew egpakarineg degma sikandan wey egpakapalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ka Manama ne nakataha te suman-suman te me etew, ka migpakita ne indawat din degma ka kene ne me Hudiyu tenged su imbehayan din sikandan te Panisingan din iling te pegbehey rin dengan kanta. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nekeg-iling de ka pegtengteng te Manama kanta te me Hudiyu wey diye te kandan te kene ne me Hudiyu; miglinisan din ka me pusung dan su migpalintutuu ma sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ne kuntee, mania te eg-el-elehan niyu ka Manama pinaahi te pegpatiang niyu te mabehat te migmalintutuu? Su minsan sikanta wey ka me kaapuan ta, ware nekeeleg due! ");
INSERT INTO mbtNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Piru migpalintutuu ki mule ne naluwas ki pinaahi te keupiya wey keyid-u kanta te Magbebaye ne si Hisu Kristu, ne iling naan ded degma ka kene ne me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ne migpeeneng-eneng ka langun ne nanlibulung dutu te pegpangguhud enni Pablu ki Birnabi meyitenged te me palinneu wey ke kein-inuwan ne innimu te Manama diye te kene ne me Hudiyu pinaahi kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Te nakapenge e sikandan ka migpangguhud, migkahi e degma si Santiyagu, “Me suled ku, pammineha a! ");
INSERT INTO mbtNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nahuhud e ni Simun ka an-anayan ne pegpapitew te Manama te hid-u rin diye te kene ne me Hudiyu pinaahi te peg-alam din te me etew ne egpuun diye te kandan ne neyimu ne kandin ne keet-etawan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ne seini iya ka inlalag te me prupita dengan, su sumale te ingkahi te Kasulatan ne miggenendue: ");
INSERT INTO mbtNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pegkapenga kayi, eglibed a, wey egbalbalawan ku te egpes-ek ka nahuhus e ne baley ni Dabid. Egbalbalawan ku man-e te egpes-ek wey igpasasindeg, ");
INSERT INTO mbtNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","eyew ka duma ne me etew, egpammitew te Magbebaye, wey ka langun ne kene ne me Hudiyu ne in-umew ku, egkeyimu ne keet-etawan ku. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Seini iya ka ingkahi ku ne naluhey ku re ipataha,’ kahi te Magbebaye.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ne migpabulus si Santiyagu ka migkahi, “Ka keddiey mule, sika se kene ne me Hudiyu ne migpalintutuu te Manama, kene tad egpabehatan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Meupiya pad ke egsulatan ta sikandan ne kene egpakeenen te keenen ne impanubad e diye te me diyus-diyus, wey kene degma egpeyibhilabetey ka kene ne alunggun. Kene man-e egpakeenen te langesa wey te ngalap ne neehet. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Su puun pad dengan, egbaseen e ka Balaud ni Muwisis diye te me simbaan te tagse Aldew te Peggimeley, ne ka lalag din inwali e diye te tagse siyudad.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nataman, nenekegsabut ka me apustulis, ka me igbuyag dan, wey ka langun ne migmalintutuu ne eg-alam te etew diye te kandan ne igpeendiye te Antiyukiya duma engki Pablu wey ki Birnabi. Ne iyan dan naalam ensi Hudas ne eg-anggaan ki Barsabas wey si Silas. Seini se daruwa, amana tahura te me suled te pegpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","“Sikanami se me apustulis wey me igbuyag te migmalintutuu, migpangemusta key kaniyu te me suled ney ne kene ne me Hudiyu diye te Antiyukiya, diye te Sirya, wey diye te Silisya. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nakarineg key te due me etew ne kayi egpuun te kanami ne miggendue te kaniyu wey migpanulu te nakasamuk kaniyu wey nakalibeg kaniyu. Piru ware ney suhua sikandan ne egpeenduenen eyew egpanulu te iling due. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Purisu miglibulung key wey nenekegsabut ne eg-alam te me etew ne igpeuyan diye te kaniyu, ne imparuma ney engki Birnabi wey ki Pablu te inggeyinawaan ta ne me suled ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Amana mig-antus ensi Birnabi ki Pablu ka egpamakey te kanta ne Magbebaye ne si Hisu Kristu, minsan ke eggimatayan perem sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Purisu, igpeuyan ney due te kaniyu ensi Hudas ki Silas eyew sikandan mismu ka egpangguhud kaniyu te tahu te seini ne sulat. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nenekegsabut key duma te bulig te Panisingan te Manama ne kene kew egpeyibehatan angin e te seini ne me balaud: ");
INSERT INTO mbtNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kene kew keen te inhalad e diye te me diyus-diyus, wey kene kew keen te langesa, wey te ngalap ne neehet, wey kene kew peyibhilabetey ka kene ne alunggun. Meupiya ke egpakapariyu kew te iling kayi. Kayi re taman.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nataman, nangipanew e ka me etew ne impeendiye dan. Te pegginguma ran diye te Antiyukiya, inlibulung dan ka migmalintutuu wey imbehey ran e ka sulat. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nabagget wey nahale ka matig-Antiyukiya te pegbasa ran te seeye ne sulat. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Hudas wey si Silas, me prupita sikandan. Ne imbagget dan wey inlig-en ka me suled te pegpalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Pegkapenga te pila ne me aldew te peg-ugpe dan diye, impepaligkat e sikandan te me suled te pegpalintutuu te migkahi, “Ayad-ayad kew ma.” Nataman miglibed e sikandan diye te migpeuyan kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ne mig-ugpe pad te naluhey-luhey ensi Pablu ki Birnabi diye te Antiyukiya. Ne migpanulu sikandan duma te masalig ne etew wey migwali te lalag te Magbebaye. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Te peglihad te pila ne aldew, migkahiyan e ni Pablu si Birnabi, “Kuwa kad su egliberan ta wey egpanumbalayan ta ka me suled ta te pegpalintutuu diye te tagse siyudad ne nawaliyan ta te lalag te Magbebaye wey egnengnengan ta ke nekey e sikandan.” ");
INSERT INTO mbtNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ne igkeupii ni Birnabi ne egdumeen din si Huwan Markus. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Piru kene eg-uyun si Pablu ne egdumeen si Huwan Markus su dengan te duma ran pad sikandin te himu, mig-engkeran sikandan ni Huwan Markus diye te Pampilya. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ne puun dutu, nekeg-apul amana ensi Pablu ki Birnabi wey nataman, nekegsuwey e sikandan. Ne indume e ni Birnabi si Markus te mig-untud te barku peendiye te Sipri. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Piru si Silas mule ka in-alam ni Pablu. Nataman, in-ampuan e sikandan te me suled te pegpalintutuu eyew egkabulihan sikandan te Magbebaye, nataman miggipanew e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Diye migbaye ensi Pablu te Siriya wey te Silisya wey inlig-en din ka migmalintutuu diye. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Migpabulus ensi Pablu ka miggipanew peendiye te Dirbi wey diye te Listra. Ne due hibateen diye ne egngaranan ki Timutiyu; Hibruwanen ka iney rin ne migpalintutuu degma, piru Grigu ka amey rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Indayan sikandin te me suled te pegpalintutuu diye te Listra wey diye te Ikuniyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Egkeupian si Pablu ne egdumeen din si Timutiyu, purisu intuli din. Innimu rin seini su nakataha ka langun ne me Hudiyu ne mig-ugpe diye, ne Grigu ka amey ni Timutiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Diye te me siyudad ne nangendiyaan dan, impasabut dan te migmalintutuu ka me balaud ne nasabekaan te me apustulis wey me igbuyag diye te Hirusalim ne igpatuman te migmalintutuu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Purisu nalig-en ka pegpalintutuu te seeye se punduk te migmalintutuu wey tagse aldew ne egkatimulan ka kasuluhan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nataman, miggendiyad e man-e sikandan te me inged ne sakup te Prigya wey te Galasya su ware sikandan tuhuti te Panisingan te Manama ne eggendiye te prubinsya te Asya ka egwali. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Te pegginguma ran diye te eletanan te inged ne egngaranan te Misya, eggendiyad e perem sikandan te prubinsya te Bitinya, piru ware tuhuti sikandan te Panisingan ni Hisus. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Purisu migbaye naan de sikandan diye te prubinsya te Misya wey migpatupang e diye te siyudad te Truwas. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Te seeye ne marusilem, hendue te impataheinep si Pablu te Manama, ne due sabeka ne lukes ne matig-Masidunya ne migsasindeg ne mighangyu kandin ne miggenendue, “Hendini ke pa te Masidunya wey bulihi key!” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ne puun te impakita ki Pablu, due-rue ne migpangandam key ka eggendiye te Masidunya, su nakataha key ne in-alam key te Manama eyew te pegwali te Meupiya ne Panugtulen diye te kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ne puun te Truwas, mig-untud key e man-e te barku ne migleus diye te Samutrasya. Te seup ne aldew, diye key e te Niyapulis. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ne puun dutu, miggendiye key e man-e te Pilipus, ka kinarakelan ne siyudad te an-anayan ne distritu te Masidunya ne sakup ded degma te Ruma. Ne diye key pad mig-ugpe seled te pila ne me aldew. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Te Aldew te Peggimeley, nanlihawang key diye te siyudad wey nangendiye key te ilis te weyig, su isip ney ne due inged diye ne ampuanan. Ne naminnuu key seini wey migpakiglalag te me malitan ne miglibulung iya diye. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Si Lidya ne matig-Tiyatira ka duma te seeye se migpammineg kanami. Talagpamelegye sikandin te me manggad ne ubi se batek. Migpamakey sikandin te Manama wey inlukatan te Magbebaye ka pusung din eyew egdawaten ka inwali ni Pablu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nataman, migpabewutismu e sikandin duma te langun ne mig-ugpe diye te kandan. Ne inninggat key e nikandin te miggenendue, “Emun ke in-isip a nikaniyu ne malehet ka pegpalintutuu ku te Magbebaye, diye kew ubag girehe te baley ku.” Ne impehes key nikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sabeka ne aldew te peggendiye ney te inged ne ampuanan, due sabeka ne uripen ne mengebay ne migsinug-ung kanami ne migserepan te mareet ne panisingan. Ne iyan din himu ka egpanagne ke nekey ka egginguma. Ne tenged te pegpanagne din, nakaseleppi amana ka me ahalen din. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ne migsinundul sikandin kanami ki Pablu ka egpanguleyi ne eggenendue, “Ka seini ne me etew, uripen te Amana ne Maresen ne Manama! Egpanuluen kew nikandan ke egmenuwen te egkaluwas.” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ne tagse aldew, seeye ka eggimuwen din taman te napelaan e si Pablu. Purisu miglilingey sikandin ka migkahi diye te mareet ne panisingan, “Te ngaran ni Hisu Kristu, awe ka due te kandin!” Te sikan de, miglihawang e ka mareet ne panisingan. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pegkanengnengi te ahalen te mengebay ne kenad e egpakaseleppi sikandan, indakep dan e ensi Pablu ki Silas, wey ingganuy ran diye te tangkaan te me upisyal diye te palingki. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ne hengkayi te in-uyan e sikandan diye te me talaggukum ne Rumanhun, migkahi ka mig-uyan kandan, “Ka seini ne me etew, me Hudiyu ne mig-uyan te kasamuk kayi te kanta ne inged. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Egpanulu sikandan te pegbebatasan ne supak te kanta ne balaud. Sikanta, me Rumanhun ki, ne ingkene kanta ka pegdawat wey peg-ikul te kandan ne me pegbebatasan!” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ne migsabeka ka me etew ne egpakig-ehet engki Pablu ki Silas. Ne migsuhu ka me pangulu ne igpahisi ka kumbale enni Pablu ki Silas wey egpalampesan sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Te pegkapenga lelampesi sikandan te masumpit, henduen pad prisuwa duma te pegpaney-paney ne egpaay-ayaran sikandan egpatamengi. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Purisu impaseled sikandan te talagtameng diye te kinaledleran e te prisuwan ne intipil te kayu ka me paa ran. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ne hengkayi te egliware e te marusilem, mig-ampu wey mig-ulahing ensi Pablu ki Silas te pegdayan te Manama. Ne ka me duma ran te me pinirisu, migpammineg de kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ne dutu, sahuhune ne miglilinug te makeseg wey nawelwel ka prisuwan, ne sikan de nallukatan ka me gumawan te prisuwan wey nenapekas e ka me keddina te langun ne me pinirisu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nekeyimata ka talagtameng te prisuwan wey te pegkakita rin ne nallukatan e ka me gumawan, kahiyen din ne nakalihawang e ka me pinirisu. Purisu inggulabut din e ka kampilan din su egluhe e sikandin. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Piru migpanguleyi si Pablu ka migkahi, “Kene ka luhe! Seini key red langun te seled!” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ne dutu, migpakuwa te sulu ka talagtameng wey migdagdahew sikandin migseled wey migpanimbuel diye te tangkaan enni Pablu ki Silas ne migkelkel. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nataman, induma rin e ensi Pablu diye te lihawangan wey mig-insaan din e ne miggenendue, “Nekey ka eggimuwen ku eyew egkaluwas a?” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ne migtabak sikandan, “Palintutuu ka wey salig ka te Magbebaye ne si Hisus eyew egkaluwas ka wey ka me pamilya nu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nataman, migwaliyan dan e sikandin te lalag te Manama duma te langun ne diye te baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Te seeye ne uras te karusileman, miglu-luan te talagtameng ka me pali dan wey te seeye ne timpu, migpabewutismu sikandin duma te pamilya rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Te pegkapenga dutu, in-uyan din e ensi Pablu diye te baley rin wey impakeen. Nahale amana ka talagtameng duma te pamilya rin te duen e pegpalintutuu rin diye te Manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Te pegkapawe, insuhu te me talaggukum ka me pulis ne egpalekaan e ensi Pablu. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ne impangguhuran e sikandan te talagtameng te prisuwan te egpalekaan e sikandan te me talaggukum, wey egpakalihawang e sikandan ne malinawen. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Piru migkahiyan ni Pablu ka me upisyal te pulis, “Sikanami, narihistru key ma diye te Ruma, ne migpalampesan key te me talaggukum diye te tangkaan te me etew minsan ware nakita ran ne sale ney, wey impaprisu key pad man e. Ne kuntee, iggeles de nikandan ka pegpalihawang kanami? Kene egkaayun! Keilangan ne sikandan mismu ka me upisyal ne Rumanhun ka eggengkayi ne egpalihawang kanami!” ");
INSERT INTO mbtNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ne ingguhud e seeye te me pulis diye te me talaggukum, purisu naaldek e sikandan te pegkarineg dan ne narihistru bes ensi Pablu diye te Ruma. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Purisu nangendiye sikandan ne migbuyu te pasaylu engki Pablu. Nataman, impanulud dan e sikandan diye te lihawangan te prisuwan wey mighangyu kandan ne eg-awe e te seeye ne siyudad. ");
INSERT INTO mbtNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Te peglihawang e enni Pablu wey ni Silas diye te prisuwan, miggendiyad e sikandan te baley ni Lidya. Ne diye dan nallambag ka me suled te pegpalintutuu wey imbagget dan sikandan. Ne nataman, miggipanew e man-e ensi Pablu ki Silas. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ne diye migbaye sikandan te Ampipulis wey diye te Apulunya taman te Tisalunika. Ne diye te Tisalunika, due simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Sumale te nabatasan din, migseled e man-e si Pablu diye te simbaan. Seled te tatelu e ne Aldew te Peggimeley, migwali sikandin te me etew ne iyan din inggamit ka diye te Kasulatan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Impasabut din sikandan meyitenged te Kasulatan wey impamalehet din ne ka Kristu, keilangan ne eg-antus wey eg-uyahen puun te kamatayen. Migkahi sikandin, “Ka seini ne Hisus ne igwali ku kaniyu, iyan sika ka Kristu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ne due me Hudiyu ne neuyan dutu wey mig-apil e te punduk enni Pablu ki Silas. Ne due mig-apil ne masalig ne me Grigu ne migpamakey e te Manama wey due degma me talahuren ne me malitan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Piru, neimma ka me Hudiyu, purisu miglibulung sikandan te me etew ne mareet se batasan. Ne hengkayi se masalig e ka inlibulung dan, migbunsuran dan e te egsamuk ka siyudad. Inlusuran dan ka baley ni Hasun su ka tuyu dan ne eg-uyanen dan ensi Pablu wey si Silas diye te tangkaan te me etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ne tenged su ware dan nakita ensi Pablu, si Hasun e mule duma te seeye se nasapenan dan ne me suled te pegpalintutuu ka ingganuy ran peendiye te me pangulu te siyudad. Ne migbalbalukan sikandan ka miggenendue, “Seini ne me etew ka miggimu te kasamuk te minsan hendei ne egkeendiyaan dan! Ne kuntee, kayid e sikandan te siyudad ta. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ne diye sikandan ipeugpe ni Hasun te baley rin. Migsupak sikandan langun te balaud te Impiradur su migkahi sikandan te due lein ne Hari ne migngaranan ki Hisus.” ");
INSERT INTO mbtNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Te pegkarineg dutu te me etew wey te me pangulu te siyudad, nasamuk e sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Te ware pad lekei te me pangulu ensi Hasun wey ka duma rin, impabayad pad sikandan ne hendue lekei. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Te seeye de ne karusileman, due-rue ne impeyipanew te me suled te pegpalintutuu ensi Pablu ki Silas peendiye te Birya. Pegginguma ran diye, miggendiye sikandan te simbaan te me Hudiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ne ka me etew diye, mewumel pad ka me suman-suman dan du te me etew diye te Tisalunika. Amana egkeupian sikandan ne egpammineg te igpanulu ni Pablu. Ne tagse aldew, egbaseen dan ka Kasulatan eyew egnengneng ke malehet naa ka impanlalag ni Pablu. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Masalig diye te kandan ka migpalintutuu, wey minsan ka me lukes ne kene ne me Hudiyu wey ka me talahuren ne me malitan, migpalintutuu e degma. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Piru te pegkarineg te me Hudiyu diye te Tisalunika ne migwaliyan e degma ni Pablu te lalag te Manama ka Birya, miggendiyaan dan e sikandan wey intipu ran ka masulug ne me etew diye ne egpeyimuwen te samuk. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Te sikan de, impeendiyad e te me suled te pegpalintutuu si Pablu te ilis te dahat. Piru migpalunggehaat de mule ensi Silas ki Timutiyu diye te Birya. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Seeye se me etew ne migpanulud ki Pablu, migduma pad kandin taman diye te siyudad te Atinas ne henduen pad ne miglibed diye te Birya. Migpanaha si Pablu kandan ne mahaan de egpasundula ensi Silas ki Timutiyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ne taheed te egtetahad si Pablu ki Silas wey ki Timutiyu diye te Atinas, nakita rin diye te siyudad ne amana ne masalig ka diyus-diyus, ne puun dutu, amana sikandin nalaggew. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Purisu, diye te simbaan te me Hudiyu, migpakig-apul sikandin te me Hudiyu wey te kene ne me Hudiyu ne egpamakey e te Manama, wey te me etew ne egpamaye-baye diye te palingki te tagse aldew. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Due degma me talagpanulu ne me Ipikiriyu wey me Istuyku ne migpakig-apul kandin. Migkahi ka duma kandan, “Nekey-a ka igpasabut te seini se ubag kun matagseb?” Ne kahi te duma, “Hendue te egwali sikandin meyitenged te me manama te lein ne inged.” Nalalag dan seeye tenged su migwali si Pablu meyitenged ki Hisus wey te peg-uyag te me minatey. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ne puun dutu, mig-uyan dan e si Pablu diye te libulunganan te me pangulu ne egngaranan te Ariyupagu. Ne migkahi sikandan, “Egkeupian key ne egpakanengneng te iyam ne pegpanulu ne impangguhud nu! ");
INSERT INTO mbtNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Su lein ka impanulu nu wey iyam pad seini kayi te kanami, purisu egkeupian key ne egpakanengneng ke nekey ka kaluwasan kayi.” ");
INSERT INTO mbtNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Su ka langun ne mahinged te Atinas wey ka me duma ne mig-ugpe diye, amana egkeupian ne egmekeglalag-lalag wey egmammineg te me iyam ne guhuren. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nataman, migsasindeg e si Pablu diye te katangkaan te kunsiyal te Ariyupagu ne migkahi, “Me matig-Atinas! Nakita ku ne amana kew migpalintutuu te me manama. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Su te peghiphipanew ku kayi te siyudad niyu wey te pegtengteng ku te egsimbaan niyu, nakakita a te altar ne migsulatan te seini ne lalag, ‘Para te Manama ne ware neila.’ Ka sika se insimba niyu ne ware niyu neileyi ka igpeila ku kuntee kaniyu. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ka Manama ne miggimu te kalibutan wey te langun ne nakatahu kayi, iyan sika ka Magbebaye ne Manama te langit wey te tane, ne ware mig-ugpe sikandin diye te timplu ne innimu re te etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kene degma sikandin egkeilangan te minsan nekey ne egpuun te himu te etew, su sikandin ma mismu ka migbehey te umul diye te etew wey te geyinawa ta wey te langun-langun de iya. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Puun te sabeka ne lukes, innimu rin ka langun ne klasi te etew, wey impeugpe din te langun ne inged kayi te ampew te tane. Sikandin mismu ka mig-alam te timpu te peglesut wey pegpatey ran, wey ka mig-alam ke hendei taman ka egkeugpaan dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Innimu te Manama sika su eyew egpammitew kandin ka me etew wey eg-alew-alew ne egpakasamsam kandin wey egpakakita. Piru ka malehet, kene ne mariyu ka Manama kanta. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Su ‘Neuyag ki, egpakaweil ki, wey neetew ki tenged kandin.’ Iling te ingkahi te duma niyu ne talagbalak, ‘Me anak ki red nikandin!’ ");
INSERT INTO mbtNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ne puun su me anak ki te Manama, kene ta egsumsumanen ne iling ka Manama te me larawan ne bulawan wey te pelata wey ke batu naa ne innimu pinaahi te katuenan te etew. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dengan, te ware pad nakanengneng ka me etew te Manama, imbalahad din ka eggimuwen dan ne migsimba te me diyus-diyus, piru kuntee, egsuhu ka Manama te langun ne etew te minsan hendei ne inged te keilangan ne eg-inniyug te me sale dan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Su mig-alam sikandin te aldew ne eggukuman din ka intiru ne kalibutan te matareng ne paahi, ne seini pinaahi te sabeka ne etew ne in-alam din. Impamalehetan din seini diye te langun ne etew pinaahi te peg-uyag kandin.” ");
INSERT INTO mbtNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Te pegkarineg dan te inlalag ni Pablu meyitenged te peg-uyag te minatey, due duma ne miglemet kandin, piru due me duma ne migkahi, “Egkeupian key man-e ne egpammineg keykew meyitenged kayi te lein ne timpu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nataman, mig-awe e man-e si Pablu diye te kalibulungan. ");
INSERT INTO mbtNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pila ne me etew ka mig-apil te punduk din wey migpalintutuu e. Ne iyan dan duma ka egngaranan ki Diyunisyu ne sakup te kunsiyal te Ariyupagu, wey si Damaris ne sabeka ne malitan wey duen pad duma. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Te pegkapenga dutu, mig-awe e man-e si Pablu diye te Atinas wey miggendiyad e te Kurintu. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ne diye din nalambag si Akilu, sabeka ne Hudiyu ne neetew diye te inged ne egngaranan te Puntu. Iyam pad sikandin migginguma puun te Italya duma te asawa rin ne si Prisila. Nakaawe sikandan puun te mandu ni Impiradur Klawdiyu ne egpaaween diye te Ruma ka langun ne me Hudiyu. Ne migpanumbaley si Pablu diye te kandan, ");
INSERT INTO mbtNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","wey tenged su nekeg-iling ka himu ran ne talaggimu te balungbalung, miglemung e sikandin kandan wey miggimu duma kandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tagse Aldew te Peggimeley, diye si Pablu te simbaan te me Hudiyu ka egpakig-apul te me Hudiyu wey te me Grigu su igkeupii rin ne egpalintutuu sikandan. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Te pegginguma enni Silas ki Timutiyu puun te Masidunya, ware lein ne eggimuwen ni Pablu gawas te pegwali te lalag te Manama. Migpangguhud sikandin diye te me Hudiyu ne si Hisus, iyan sika ka Kristu. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Piru insupak dan si Pablu wey inlemetan. Purisu impelpel rin ka alinepung diye te kumbale din te migkahi, “Ke kene kew egkaluwas, kaniyud e sika ne seyyup! Ware labet ku rue. Ne puun kuntee, eggendiye ad e te kene ne me Hudiyu.” ");
INSERT INTO mbtNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Purisu mig-awe e sikandin diye wey diyad e miglemung te kene ne Hudiyu ne egngaranan ki Titu Hustu ne migpamakey degma te Manama. Lenged te simbaan te me Hudiyu ka baley rin. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ne si Krispu, ka pangulu te simbaan te me Hudiyu, migpalintutuu te Magbebaye duma te pamilya rin, wey masalig pad ne matig-Kurintu ne nakarineg te lalag te Manama ne migpalintutuu wey migpabewutismu e. ");
INSERT INTO mbtNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Due sabeka ne marusilem ne hendue te impataheinep si Pablu te Magbebaye wey migkahiyan, “Kene ka kaaldek, pabu