﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbs_vpl;
CREATE TABLE mbs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbs_vpl WRITE;
INSERT INTO mbs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Diyà te keteboan te kedita, mig-inang se Timanem te langit aw keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Wedad pa bawa te tanà, aw wedad pa awop niyan, aw tomalag mengitngit se kebelad te dagat. Gayed miniwal se Espiritu Santo diyà te lanto te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Minikagi se Timanem, “Megkedoen den kelowahan.” Penga niyan, doen kelowahan. ");
INSERT INTO mbs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kinità te Timanem te mèpiya se kelowahan, aw tinani din se kelowahan aw kengitngitan. ");
INSERT INTO mbs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Se kelowahan, yan se iningedanan din aldaw. Se kengitngitan, yan se iningedanan din delem. Migkemeapon aw migkeiselem, aw yan nepenga se tagnà aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Minikagi se Timanem, “Megkedoen elet diyà te wayeg amon doen wayeg diatas te tanà aw doen wayeg kidoen te ongan.” ");
INSERT INTO mbs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yan ininang te Timanem se elet diyà te wayeg diatas te tanà aw wayeg kidoen te tanà. Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Se lenged diatas te tanà, yan se iningedanan te Timanem langit. Migkemeapon aw migkeiselem, aw yan nepenga se ikedowa te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Minikagi se Timanem, “Metipon se wayeg te ongan amon doen mepangkag.” Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Se mepangkag, yan se iningedanan te Timanem tanà. Se wayeg netipon, yan se iningedanan din dagat. Kinità te Timanem te mèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Penga niyan, minikagi se Timanem, “Megkedoen medita kemolò te tinemunun kidoen te tanà, aw medita kemolò te kayo. Megkedoen pongo niyan doen didalem amon todà iyan tomobò.” Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Timobò se medita kemolò te tinemunun doen benì, aw medita kemolò te kayo doen pongo. Kinità te Timanem te mèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Migkemeapon aw migkeiselem, aw yan nepenga se iketelo te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Minikagi se Timanem, “Megkedoen menge somenang doton te langit amon doen elet te aldaw aw delem. Yan se pengilala te menge bolan, menge aldaw, aw menge omay. ");
INSERT INTO mbs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Yan heman se somenang doton te langit amon melowa se tanà.” Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dowa se dakel lowa ininang te Timanem. Se aldaw, yan se egsenang dalem te aldaw. Se bolan, yan se egsenang dalem te delem. Ininang din heman se menge bitoen. ");
INSERT INTO mbs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Yan se insawol te Timanem doton te langit amon melowa se tanà. ");
INSERT INTO mbs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Yan se egsenang te aldaw aw delem, amon doen elet diyà te kelowahan aw kengitngitan. Kinità te Timanem te mèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Migkemeapon aw migkeiselem, aw yan nepenga se ikeepat te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Minikagi se Timanem, “Megkedoen medita kinemoloan meg-ogpà doton te wayeg aw dagat, aw manok lomayang diatas te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yan ininang te Timanem se kedita te menenanap te dagat, aw kedita te kinemoloan eg-ogpà doton te wayeg aw dagat, aw kedita te kinemoloan te manok. Kinità te Timanem te mèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mèpiya se imbegay te Timanem diyà te kedita niyan, aw migpunù sikandin diyà te kedita eg-ogpà doton te wayeg aw dagat, “Pegbatà kaw, aw pegkedita kaw amon melegeb se dagat kenyo.” Migpunù heman sikandin diyà te menge manok, “Pegkedita kaw doton te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Migkemeapon aw migkeiselem, aw yan nepenga se ikelima te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Minikagi se Timanem, “Megkedoen medita kinemoloan eg-ogpà doton te tanà, menge ayam-ayam aw menenanap te kebenesan dakel aw deitek.” Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ininang te Timanem se kedita niyan, aw kinità din te mèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Penga niyan, minikagi se Timanem, “Meg-inang kidon den te otaw iling kenitadon. Inangen tadon dan melangkaw diyà te kedita te ininang tadon, menge ikan, manok, ayam-ayam, aw menenanap dakel aw deitek.” ");
INSERT INTO mbs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yan ininang te Timanem se otaw iling kandin. Ininang se otaw iling te Timanem. Ininang dan meama aw bayi. ");
INSERT INTO mbs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mèpiya se imbegay te Timanem diyà kandan, aw migpunù sikandin, “Pegbatà kaw te medita amon doen bowad-bowad niyo meg-ogpà diyà te kebelad te tanà aw mengibing kenyan. Sikiyo se mengolo diyà te menge ikan, manok, aw kedita te ayam-ayam aw menenanap eg-ogpà dini lanto te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Minikagi heman se Timanem, “Ibegay ko diyà kenyo se kedita te tinemunun doen benì dini te tanà aw kedita te kayo doen pongo amon doen kànen niyo. ");
INSERT INTO mbs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ibegay ko heman se kedita te mèpiya tinemunun diyà te menge ayam-ayam, manok, aw menenanap, amon doen kànen te kedita eg-ogpà dini lanto te tanà.” Neinang iyan. ");
INSERT INTO mbs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Timengteng se Timanem diyà te kedita te ininang din, aw ontò iyan mèpiya. Migkemeapon aw migkeiselem, aw yan nepenga se ikeenem te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yan nepenga se peg-inang te Timanem te kedakel te langit, aw keneyonan, aw awop niyan. ");
INSERT INTO mbs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pegdateng te ikepito te aldaw, nepenga den se kedita te ininang te Timanem, aw yan mig-ogpà sikandin te ikepito te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ininang din melangkaw aw egpenimeneman se ikepito te aldaw. Yan se aldaw te peg-ogpà din, so nepenga den se peg-inang din. ");
INSERT INTO mbs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yan se indan tepad te peg-inang te langit aw keneyonan. Peg-inang te Timanem te keneyonan aw langit, ");
INSERT INTO mbs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wedad pa tinemunun dini te tanà, aw wedad heman timobò, so wedà pa peodani te Timanem se tanà, aw wedad pa otaw migpawà. ");
INSERT INTO mbs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Meneng doen wayeg timebol lekat didalem te tanà amon meelem se kebelad te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Penga niyan, inabat te Timanem se tanà, aw yan se ginamit din te pegtiyon din te otaw. Penga niyan, inedop din se idong te otaw, aw yan binegayan din se otaw te pedowan. ");
INSERT INTO mbs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Penga niyan, ininang te Timanem se kekeyowan kidoen te Eden doton te eglibtakan, aw yan se pineogpaan din te otaw ininang din. ");
INSERT INTO mbs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Impetilles te Timanem se medita kemolò te kayo kidoen. Mèpiya iyan tengtengen, aw mèpiya heman se pongo niyan. Dowa se kayo intanem din diyà te tengà-tengà te kekeyowan, aw yan se kayo egpemegay te pedowan wedad temanan aw kayo egpemegay te kebiyasa tepad te mèpiya aw medaet. ");
INSERT INTO mbs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Doen heman wayeg kidoen te Eden gayed eg-elem te tanà te kekeyowan. Doton dibabà te Eden, migsoway-soway se wayeg sìyan, aw neinang iyan olo te epat dakel wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Pison se ngadan te tagnà wayeg, aw minokit iyan te tanà iningedanan Habila. ");
INSERT INTO mbs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mèpiya se bolawan egketelaan kidoen, aw doen heman litek te kayo metinadeg aw menge bato meelagà kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gihon se ngadan te ikedowa te wayeg, aw minokit iyan te tanà iningedanan Cus. ");
INSERT INTO mbs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tigris se ngadan te iketelo te wayeg, aw minokit iyan lenged te eglibtakan te tanà iningedanan Asirya. Yofritis se ngadan te ikeepat te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Impeogpà te Timanem se otaw doton te kekeyowan te Eden amon meg-obong sikandin kenyan aw megtonggò heman kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Migpunù se Timanem diyà kandin, “Mepakay aw kànen no se pongo te kedita te kayo kidoen te kekeyowan, ");
INSERT INTO mbs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","meneng ikà egpengaen te pongo te kayo egpemegay te kebiyasa tepad te mèpiya aw medaet. So aw komaen ka kenyan, ontò ka matay te aldaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Minikagi heman se Timanem, “Kenà mèpiya aw sebad olò se otaw. Yan meg-inang a te doma din meketepad kandin amon doen megtelaban kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yan inibing te Timanem se kedita te ayam-ayam, menenanap, aw manok ininang din lekat te tanà. Inibing din se kedita niyan doton te otaw amon ingedanan din iyan. Pengkey eden se in-ingadan din kenyan, yan se ngadan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Iningedanan te otaw se kedita te ayam-ayam, menge manok, aw kedita te menenanap, meneng wedad palos diyà kenyan meketepad kandin meinang doma din. ");
INSERT INTO mbs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Penga niyan, ontò impetedogi te Timanem se otaw. Pegketedogi din, inabat te Timanem se gosok din, aw sinengseng din se awang te onod. ");
INSERT INTO mbs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Penga niyan, ininang din se bayi lekat te gosok, aw inibing din sikandin doton te meama. ");
INSERT INTO mbs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Minikagi se meama, “Na, lekat te tòlan ko se kandin tòlan, aw lekat te onod ko se kandin onod. Ingedanan ko sikandin bayi, so inabat sikandin lekat te meama.” ");
INSERT INTO mbs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yan se doun te tomanan se meama te amay aw inay din, aw megsebad diyà te esawa din. Se didowa dan meinang sebad. ");
INSERT INTO mbs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pengkey migpetabeg-tabeg se meama aw bayi, meneng wedà dan keyàyà. ");
INSERT INTO mbs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nayan, diyà te kedita te menge menenanap ininang te Timanem, memokan se ontò biyasa eg-akal. Mig-insà se memokan diyà te bayi, “Benal lay migpunù se Timanem kenyo te eked kaw kaen te pongo te kedita te kayo dini te kekeyowan?” ");
INSERT INTO mbs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Timaba se bayi, “Mepakay aw komaen kay te pongo te menge kayo dini te kekeyowan. ");
INSERT INTO mbs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Meneng minikagi se Timanem te keilangan eked kay kaen te pongo te kayo doton te tengà-tengà te kekeyowan, aw keilangan eked kay pemaed kenyan, so matay kay.” ");
INSERT INTO mbs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Minikagi se memokan, “Eked kaw kematay. ");
INSERT INTO mbs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Minikagi se Timanem kenyan so netegahan din aw komaen kaw kenyan, megkebiyasa kaw, aw meinang kaw iling kandin, so metaga-taga kaw heman aw eden se mèpiya aw eden se medaet.” ");
INSERT INTO mbs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Penga niyan, kimità se bayi te mèpiya kànen se pongo te kayo sìyan, aw mèpiya se bawa niyan, aw mig-aneng-aneng sikandin te mèpiya aw megkebiyasa sikandin. Yan se doun te inabat din se pongo niyan aw kinaen din iyan. Doen heman imbegay din diyà te esawa din, aw kinaen din heman iyan. ");
INSERT INTO mbs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pegpengaen dan kenyan, migkebiyasa dan aw netegahan dan te migpetabeg-tabeg dan. Yan tinebil dan se dawen te kayo igira amon doen isampeng te sinelowan dan. ");
INSERT INTO mbs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Te kelikit te meapon, minipanaw se Timanem kidoen te kekeyowan. Meneng te aldaw sìyan, pegdineg dan te tegodtod te peg-ipanaw din, mineles dan doton te menge kayo. ");
INSERT INTO mbs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Meneng timawal se Timanem diyà te meama, “Kenan ka lay?” ");
INSERT INTO mbs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Timaba sikandin, “Dinineg ko sikona doton te kekeyowan, meneng nelemitan a so migpetabeg-tabeg a, aw yan mineles a.” ");
INSERT INTO mbs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mig-insà se Timanem, “Sinu lay se mig-indan kamno te migpetabeg-tabeg ka? Kimaen ka lay te pongo te kayo impunù ko kamno?” ");
INSERT INTO mbs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Minikagi se meama, “Se bayi impedoma no diyà kanak, yan se nemegay te pongo diyà kanak, aw kimaen a kenyan.” ");
INSERT INTO mbs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mig-insà se Timanem diyà te bayi, “Eden lay se ininang no seini?” Timaba se bayi, “Se memokan, yan se mig-akal kanak, aw yan kimaen a.” ");
INSERT INTO mbs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Penga niyan, minikagi se Timanem diyà te memokan, “Ipelumun ka tandà te medaet ininang no seini. Diyà te kedita te menge ayam-ayam aw menenanap, olò sikona se ipelumun iling kani. Lekat seini, keilangan domelog se getek nikaw diyà te tanà, aw gayed ka komaen te kepong-kepong te tanà taman te pegkematay nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Inangen ko sikiyo megpepoonay, sikona aw bayi, kamno sakop aw kandin bowad-bowad. Bonalan te bowad-bowad din se olo nikaw, aw bengaen no se palo din.” ");
INSERT INTO mbs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Minikagi se Timanem diyà te bayi, “Ontò ko dogangan se kelimahan te pegbatà nikaw. Aw tebawan ka, elegen ka. Meneng ontò ka meibeg te kamno esawa, aw mengolo sikandin diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Minikagi se Timanem diyà te meama, “Nenenalan ka diyà te esawa nikaw, aw kimaen ka te pongo te kayo impunù ko kamno. Tandà te salà no sìyan, inangen ko heman medaet se tanà. Keilangan gayed ka megterbaho taman te pegkematay nikaw, amon botong se kànen nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Gayed tomilles se sagbet aw tigis kidoen te tanà, aw keilangan mahà ka heman te kànen egtobò doton te kebenesan tandà te kelimahan nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Keilangan gayed ka megterbaho lamig peg-etingan ka amon doen tomilles kidoen te tanà lamig molì ka doton te tanà, so yan se linekatan nikaw. Ininang ka lekat te tanà, aw todà ka heman meinang tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Iningedanan i Adam (kelebadan niyan, otaw) se esawa din ki Eva (kelebadan niyan, pegkeotaw), so sikandin se neinang inay te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Doen penenaktun ininang te Timanem lekat te kindal te menge ayam-ayam, aw imbegay din iyan diyà ki Adam aw esawa din amon doen penenaktun dan. ");
INSERT INTO mbs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nayan, minikagi se Timanem, “Neinang den se otaw iling kenitadon, so netegahan den dan aw eden se mèpiya aw eden se medaet. Eked den kepakay aw mengabat dan te pongo lekat te kayo mekebegay te pedowan wedad temanan, so aw komaen dan kenyan, eked dan palos kematay te wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yan impekesayo te Timanem se otaw lekat te kekeyowan te Eden, aw impeobong din sikandin te tanà linekatan din. ");
INSERT INTO mbs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Penga te pegkesayo te otaw lekat te Eden, insogò te Timanem se iling te anghil iningedanan kirobim lenged te eglibtakan te kekeyowan, aw insawol din se sondang eglegdeg aw gayed egkebiling, amon wedad otaw mekepedapag diyà te kayo egpemegay te pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nayan, migpeleyokay si Adam aw esawa din, aw miglaman si Eva. Pegtebaw te batà din, minikagi si Eva, “Pineokit te tabang te Timanem, doen den batà ko meama.” Iningedanan din se batà din ki Cain (kelebadan niyan, doen den). ");
INSERT INTO mbs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Penga niyan, todà sikandin migbatà te doma batà din meama si Abel. Si Abel se biyasa egdiyaga te menge ayam-ayam, aw si Cain se biyasa egpawà. ");
INSERT INTO mbs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Doen sebad aldaw, nengibing si Cain te menge pongo te tinanem din amon ibegay din iyan diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Meneng si Abel se nemallì te penganay nati te menge karniro din, aw iniyaw din iyan, aw inibing din se melambò onod niyan amon ibegay din iyan diyà te Timanem. Neluba se Timanem ki Abel aw sìyan imbegay din. ");
INSERT INTO mbs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Meneng wedà keluba se Timanem ki Cain aw sìyan imbegay din. Yan ontò neopal si Cain aw timàmod. ");
INSERT INTO mbs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Penga niyan, minikagi se Timanem diyà ki Cain, “Kenà mèpiya se pegkeopal nikaw. Kenà mèpiya se pegtàmod nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Aw metòlid se inangen nikaw, yan meluba a kamno. Meneng aw eked ka peg-inang te metòlid, delisegen ka den i Satanas amon meg-inang ka te salà. Dàgen ka peden te peg-inang no te salà, meneng keilangan domaeg ka kenyan.” ");
INSERT INTO mbs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wedà kenamay, minikagi si Cain diyà te kedowa din si Abel, “Taking ka kanak doton te pawà.” Pegdateng dan doton te pawà, inimetayan i Cain se kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mig-insà se Timanem diyà ki Cain, “Kenan lay se kedowa no si Abel?” Timaba sikandin, “Inday. Kenà a teletonggò te kedowa ko.” ");
INSERT INTO mbs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Minikagi se Timanem, “Ontò den medaet se ininang no seini. Iling te egpengenganay se dipanog din diyà kanak lekat te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Lekat seini, ipelumun ko sikona. Eked den kepakay aw meg-obong ka te tanà, so tanà se inegseban te dipanog te kedowa no te pegpengimatay no kandin. ");
INSERT INTO mbs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Aw todà ka megpawà, eked pongo se tinanem nikaw. Keilangan gayed ka meglegeb dini lanto te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Minikagi si Cain, “Pelaban melima se pegpelumun no kanak, aw eked a peketayod kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Eked a no den pepewai, aw ipekesayo a no den lekat kamno. Keilangan gayed a meglegeb dini lanto te tanà. Aw ketelaan a te doma otaw, imetayan a din.” ");
INSERT INTO mbs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Meneng minikagi se Timanem diyà kandin, “Eked iyan ketoman, so aw doen mengimatay kamno, mekepito pa se kedaet te pelumun domateng diyà kandin.” Penga niyan, doen pengilala imbegay te Timanem diyà ki Cain amon eked sikandin imetayi te otaw meketalà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Penga niyan, timanan si Cain te Timanem, aw mig-ogpà sikandin doton te ogpeanan te Nod, lenged te eglibtakan te Eden. ");
INSERT INTO mbs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nayan, migpeleyokay si Cain aw esawa din, aw doen batà dan timebaw si Enok. Dalem niyan, mig-inang si Cain te lonsod, aw yan heman se iningedanan din Enok, onawa te ngadan te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Si Enok se amay i Irad. Si Irad se amay i Mehujael. Si Mehujael se amay i Metusael. Si Metusael se amay i Lamek. ");
INSERT INTO mbs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Migdoway si Lamek. Si Ada se ngadan te sebad esawa din, aw si Sela se doma. ");
INSERT INTO mbs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada se inay i Jabal, aw sikandin se neinang kemonaan te kedita te telediyaga te menge ayam-ayam. Mig-ogpà dan diyà te menge tolda. ");
INSERT INTO mbs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Doen adi i Jabal si Jubal, aw sikandin se neinang kemonaan te kedita te otaw biyasa egpengablit te sista aw egpengedop te seluli. ");
INSERT INTO mbs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Sela se inay i Tubal Cain, aw sikandin se menenayab te tebaga aw kinis. Doen heman etebay i Tubal Cain si Naama. ");
INSERT INTO mbs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Minikagi si Lamek diyà te didowa esawa din, “Ada aw Sela, penenalan kaw den diyà kanak. E menge esawa ko, seini se kagi ko diyà kenyo. Mekebatog a den mengimatay te otaw menigbas kanak. Pengkey pa telaki se megpeeleg kanak, mengimatay a kandin. ");
INSERT INTO mbs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Aw mekepito pa se kedaet te pelumun domateng diyà te otaw mengimatay ki Cain, Yan mekekepitowan teg pito pa se kedaet te pelumun domateng diyà te otaw mengimatay peden kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nayan, penga te pegkematay i Abel, migpeleyokay si Adam aw esawa din, aw doen batà meama timebaw diyà ki Eva. Iningedanan din se batà din ki Set (kelebadan niyan, imbegay), so minikagi sikandin, “Binegayan a te Timanem te sebad batà inselilin ki Abel, so inimetayan sikandin i Cain.” ");
INSERT INTO mbs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Doen batà meama timebaw diyà te esawa i Set, aw iningedanan din se batà din ki Enos. Nayan, lekat te aldaw sìyan, migtebò se menge otaw migsimba aw migtawal-tawal diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Seini se ngadan te menge bowad-bowad i Adam. Peg-inang te Timanem te otaw, ininang din dan iling kandin. ");
INSERT INTO mbs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ininang din se otaw meama aw bayi. Mèpiya se imbegay din diyà kandan, aw iningedanan din dan otaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Peg-apet te sebad gatos ketlowan se omay i Adam, timebaw se batà din meama iling kandin. Iningedanan din se batà din ki Set. ");
INSERT INTO mbs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Penga te pegtebaw i Set, walo gatos se omay minokit te wedà pa kematay si Adam. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Siyam gatos ketlowan se omay i Adam te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Peg-apet te sebad gatos aw lima se omay i Set, timebaw se batà din meama si Enos. ");
INSERT INTO mbs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Penga te pegtebaw i Enos, walo gatos aw pito se omay minokit te wedà pa kematay si Set. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Siyam gatos sempolò teg dowa se omay i Set te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Peg-apet te kesyaman se omay i Enos, timebaw se batà din meama si Cainan. ");
INSERT INTO mbs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Penga niyan, walo gatos sempolò teg lima se omay minokit te wedà pa kematay si Enos. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Siyam gatos aw lima se omay i Enos te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Peg-apet te kepitowan se omay i Cainan, timebaw se batà din meama si Mahalaleel. ");
INSERT INTO mbs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Penga niyan, walo gatos kepatan se omay minokit te wedà pa kematay si Cainan. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Siyam gatos aw sempolò se omay i Cainan te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Peg-apet te keneman teg lima se omay i Mahalaleel, timebaw se batà din meama si Jared. ");
INSERT INTO mbs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Penga niyan, walo gatos ketlowan se omay minokit te wedà pa kematay si Mahalaleel. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Walo gatos kesyaman teg lima se omay i Mahalaleel te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Peg-apet te sebad gatos keneman teg dowa se omay i Jared, timebaw se batà din meama si Enok. ");
INSERT INTO mbs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Penga niyan, walo gatos se omay minokit te wedà pa kematay si Jared. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Siyam gatos keneman teg dowa se omay i Jared te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Peg-apet te keneman teg lima se omay i Enok, timebaw se batà din meama si Matusalem. ");
INSERT INTO mbs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Penga niyan, dalem te telo gatos se omay, migpedomaay si Enok aw Timanem. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Minapet se omay din te telo gatos keneman teg lima. ");
INSERT INTO mbs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Gayed migpedomaay si Enok aw Timanem lamig te aldaw te pegkewedad din, so binaloy sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Peg-apet te sebad gatos kewelowan teg pito se omay i Matusalem, timebaw se batà din meama si Lamek. ");
INSERT INTO mbs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Penga niyan, pito gatos kewelowan teg dowa se omay minokit te wedà pa kematay si Matusalem. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Siyam gatos keneman teg siyam se omay i Matusalem te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Peg-apet te sebad gatos kewelowan teg dowa se omay i Lamek, doen batà din meama timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Iningedanan din se batà din ki Noe (kelebadan niyan, peg-etod), so minikagi sikandin, “Seini se otaw megpeetod kenitadon lekat te kelimahan te terbaho tadon dini te tanà seini ininang te Timanem medaet.” ");
INSERT INTO mbs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Penga te pegtebaw i Noe, lima gatos kesyaman teg lima se omay minokit te wedà pa kematay si Lamek. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pito gatos kepitowan teg pito se omay i Lamek te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Penga te lima gatos se omay i Noe, timebaw se telo batà din meama, si Sem, si Ham, aw si Japet. ");
INSERT INTO mbs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nayan, pegkedita-dita te menge otaw dini lanto te tanà, aw pegkedita heman te bayi timebaw, ");
INSERT INTO mbs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","doen menge sakop te Timanem kimità te mèpiya se bawa te menge bayi, aw pengkey sinu se neibegan dan, yan se pinengognan dan. ");
INSERT INTO mbs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Penga niyan, minikagi se Timanem, “Eked ko pekeleyati se pedowan ko diyà te menge otaw te wedad temanan, so otaw dan olò. Lekat seini, taman olò te sebad gatos kelowan se omay se tegsebad-sebad otaw.” ");
INSERT INTO mbs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Dalem te aldaw sìyan te pegpengognan te menge sakop te Timanem diyà te menge bayi aw pegbatà dan, aw pengkey pa te pegkepenga niyan, doen menge telandig iningedanan Nefilim. Ontò dan nedengeg gebii, so dakel se nebatog dan. ");
INSERT INTO mbs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kinità te Timanem te ontò medaet se eg-inangen te kedita te otaw dini lanto te tanà, aw tomalag medaet se aneng-aneng aw ibeg dan te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yan miglama-lama sikandin tepad te peg-inang din te otaw aw tepad te pegpeogpà din kandan dini te tanà. Ontò nepuluk se pedowan din, ");
INSERT INTO mbs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","aw minikagi sikandin, “Pegbàtan ko se otaw ininang ko dini te tanà, sipat te menge ayam-ayam, menenanap, aw manok, so miglama-lama a tepad te peg-inang ko kandan.” ");
INSERT INTO mbs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Meneng neluba se Timanem tepad ki Noe. ");
INSERT INTO mbs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Seini se indan tepad ki Noe. Diyà te kedita te otaw, olò si Noe se eg-inang te metòlid, aw wedad palos isila kandin. Migpedomaay si Noe aw Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Telo se batà din meama, si Sem, si Ham, aw si Japet. ");
INSERT INTO mbs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Netegahan te Timanem te medaet se kedita te doma otaw dini lanto te tanà, aw doen samok doton te kedita te ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pegtengteng te Timanem diyà te tanà, kinità din te tomalag iyan medaet, so gayed medaet se eg-inangen te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Minikagi se Timanem diyà ki Noe, “Tod ko, igelaen ko den se kedita te otaw, so nelegeb den se kebelad te tanà te medaet eg-inangen dan. Yan ontò ko dan bàtan sipat te kedita dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Yan peg-inang ka den te arka te mèpiya kemolò te kayo amon doen sekayan nikaw. Peg-inang ka te menge tambì doton te arka, aw pemolit ka kenyan doton didalem aw doton te lowà. ");
INSERT INTO mbs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sebad gatos ketlowan teg telo mitro se kelayat niyan, aw kelowan teg dowa mitro se kebelad niyan, aw sempolò teg telo mitro se kelangkaw niyan. ");
INSERT INTO mbs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Peg-atep ka kenyan, aw peg-inang ka te elet diyà te ampa aw atep taman te tengà mitro se kelangkaw niyan. Peg-inang ka te telo kunsad niyan aw sebad se lelebangan kidoen te ampa. ");
INSERT INTO mbs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Linepen ko se tanà te wayeg amon megelà se kedita doen pedowan. Matay se kedita dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Meneng doen ipakang ko den kamno. Awop ka diyà te arka sipat te esawa nikaw, menge batà nikaw, aw menge esawa dan. ");
INSERT INTO mbs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Pengibing ka heman te meama aw bayi lekat te tegsebad-sebad kemolò te ayam-ayam, menenanap, aw manok amon eked iyan kegelà. ");
INSERT INTO mbs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Peglolan ka heman te medita kemolò te kànen amon doen kànen te kedita niyo.” ");
INSERT INTO mbs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Timolò si Noe te kedita te impunù te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nayan, minikagi se Timanem diyà ki Noe, “Awop ka diyà te arka sipat te kedita diyà te pamilya nikaw, so diyà te kedita te otaw dini lanto te tanà, olò sikona se kinità ko eg-inang te metòlid. ");
INSERT INTO mbs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Pengibing ka te sebad meama aw sebad bayi lekat te tegsebad-sebad kemolò te ayam-ayam aw menenanap eked kepakay sonogen aw ibegay diyà kanak, meneng pengibing ka te pito meama aw pito bayi lekat te tegsebad-sebad kemolò te ayam-ayam aw manok mepakay sonogen aw ibegay diyà kanak. Peg-inang ka kenyan amon todà megbowad-bowad se kedita te kemolò dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Na, pito seini, ipetedak ko se odan, aw eked iyan kedit singed aw kepatan se aldaw aw kepatan se delem amon bàtan ko se kedita ininang ko doen pedowan dini lanto te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Timolò si Noe te kedita te impunù te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Enem gatos se omay i Noe te pegkelinep te tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Minawop sikandin diyà te arka sipat te esawa din, menge batà din, aw menge esawa dan, amon eked dan kegelà aw melinep se tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Netipon se sebad meama aw sebad bayi lekat te tegsebad-sebad kemolò te menge ayam-ayam, menenanap, aw manok pengkey mepakay sonogen aw eked kepakay sonogen. Dimoton se kedita niyan ki Noe, aw minawop dan diyà te arka, iling te impunù te Timanem diyà ki Noe. ");
INSERT INTO mbs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Penga te pito se aldaw, migtebò nelinep se tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Peg-apet te enem gatos se omay i Noe, te pitsa sempolò teg pito te ikedowa te bolan te omay sìyan, neowang se kedita te selep doton didalem te dagat, aw neowang heman se kedita te linekatan te odan doton te langit. ");
INSERT INTO mbs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Penga niyan, minodan te kepatan se aldaw aw kepatan se delem. ");
INSERT INTO mbs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Te wedà pa kelinep se tanà, tapay minawop si Noe diyà te arka sipat te esawa din, menge batà din si Sem, si Ham, aw si Japet, aw menge esawa dan. ");
INSERT INTO mbs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Minawop heman se kedita te kemolò te menge ayam-ayam aw menenanap, dakel aw deitek, aw kedita te kemolò te manok. ");
INSERT INTO mbs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Doen meama aw bayi diyà te tegsebad-sebad kemolò doen pedowan dimoton ki Noe, aw minawop dan diyà te arka, iling te impunù te Timanem diyà ki Noe. Penga niyan, tinakep te Timanem se lelebangan te arka. ");
INSERT INTO mbs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Gayed minodan te kepatan se aldaw aw kepatan se delem. Gayed migkedalem se wayeg lamig limepaw se arka. ");
INSERT INTO mbs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Gayed timilles se wayeg diyà te lanto te tanà, aw miglepaw-lepaw se arka diyà te lanto te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Gayed timilles se wayeg diyà te lanto te tanà lamig nelinep te wayeg se kedita te melangkaw bontod. ");
INSERT INTO mbs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Timilles se wayeg lamig pito mitro se kedalem te wayeg limowan diyà te toktok te menge bontod. ");
INSERT INTO mbs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yan nelemes se kedita diyà te lanto te tanà, pengkey manok, ayam-ayam, menenanap, aw otaw. ");
INSERT INTO mbs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nematay se kedita doen pedowan dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Inigelà te Timanem se kedita te otaw, ayam-ayam, menenanap, aw manok. Olò si Noe se nesamà, sipat te menge doma din kidoen didalem te arka. ");
INSERT INTO mbs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sebad gatos keliman se aldaw se kenamay te pegkelinep te tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wedà kelibeli te Timanem si Noe aw kedita te menenanap aw ayam-ayam doma kandin simakay te arka. Impekedog te Timanem se kelamag, aw migtebò den se wayeg minuyud. ");
INSERT INTO mbs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Sinengseng din se menge selep doton didalem te dagat aw menge linekatan te odan doton te langit. Kimedit se odan. ");
INSERT INTO mbs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Minuyud se wayeg te sebad gatos keliman se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pitsa sempolò teg pito te ikepito te bolan, nekeselà se arka diyà te bontod te Ararat. ");
INSERT INTO mbs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Gayed minuyud se wayeg, aw kinità se toktok te menge bontod te pitsa ono te ikesempolò te bolan. ");
INSERT INTO mbs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Penga te kepatan se aldaw, inowang i Noe se bintanà te arka, ");
INSERT INTO mbs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","aw binoloyan din se sebad owak. Wedà iyan likò doton te arka meneng gayed miglegeb-legeb lamig migkepangkag se tanà. ");
INSERT INTO mbs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Pegkenamay-namay, binoloyan heman i Noe se sebad selepati, amon ketegahan din aw migkepangkag se tanà. ");
INSERT INTO mbs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Meneng so nelinep pa se tanà te wayeg, wedad kinità te selepati embongan din, aw yan limikò iyan doton te arka. Impelowà i Noe se belad din aw inabat din se selepati. ");
INSERT INTO mbs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Penga te sebad simana, todà din binoloyan se selepati. ");
INSERT INTO mbs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pegkemeapon niyan, limikò iyan doton ki Noe, aw doen tobed te kayo olibo inibing diyà te toktokay din. Doun niyan, netegahan i Noe te tabag minuyud se wayeg diyà te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Penga niyan, migtagad si Noe te sebad simana, aw todà din binoloyan se selepati. Meneng wedà iyan palos likò. ");
INSERT INTO mbs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nayan, peg-apet te enem gatos aw sebad se omay i Noe, te pitsa ono te tagnà bolan te omay sìyan, minuyud se wayeg diyà te tanà. Inabat i Noe se atep te arka amon megpeatap-atap. Kinità din te tabag migkepangkag se tanà. ");
INSERT INTO mbs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Peg-apet te pitsa kelowan teg pito te ikedowa te bolan, ontò migkepangkag se tanà. ");
INSERT INTO mbs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yan minikagi se Timanem diyà ki Noe, ");
INSERT INTO mbs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lowà ka den lekat te arka sipat te esawa nikaw, menge batà nikaw, aw menge esawa dan. ");
INSERT INTO mbs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pelowai heman se kedita te manok, ayam-ayam, aw menenanap, amon megbowad-bowad dan aw megkedita dan dini lanto te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yan limowà si Noe lekat te arka sipat te esawa din, menge batà din, aw menge esawa dan. ");
INSERT INTO mbs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Limowà heman se menge ayam-ayam, menenanap, aw manok te tegsebad-sebad kemolò niyan. ");
INSERT INTO mbs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Penga niyan, miglodok si Noe te menge bato amon meg-inang sikandin te sonoganan te ayam-ayam ibegay diyà te Timanem. Inimetayan din se sebad diyà te tegsebad-sebad kemolò te ayam-ayam aw manok mepakay sonogen aw ibegay diyà te Timanem, aw sinonog din se kedita niyan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Peg-adek te Timanem te nadeg niyan, neluba sikandin, aw minikagi sikandin diyà te pedowan din, “Eked a todà pegpelumun te tanà tandà te medaet inang te otaw, so netegahan ko te gayed medaet se ibeg te pedowan te otaw lekat te pegtebaw dan. Eked a todà peg-igelà te kedita te otaw aw menenanap iling te ininang ko den. ");
INSERT INTO mbs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dalem te doen pa keneyonan, gayed doen pegtanem aw peglegani, pegkegenaw aw pegkeinit, pengaldaw aw pengodan, aldaw aw delem.” ");
INSERT INTO mbs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mèpiya se imbegay te Timanem diyà ki Noe aw pamilya din, aw minikagi sikandin, “Pegbatà kaw den te medita, amon doen menge bowad-bowad niyo meg-ogpà doton te kebelad te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Lekat seini, melemitan kenyo se kedita te menenanap, manok, aw ikan. Inangen ko sikiyo olo te kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mepakay den kànen niyo se kedita te ayam-ayam aw menenanap. Tapay ko impekaen kenyo se menge tinemunun, meneng mepakay den heman se pegpengaen niyo te menenanap aw ayam-ayam. ");
INSERT INTO mbs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Sebad olò se eked niyo kepakay kànen, aw yan se pengelapen doen pa dipanog, so doen pedowan pineokit te dipanog. ");
INSERT INTO mbs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Aw memonò se otaw, keilangan ipelumun sikandin. Aw mengimatay se ayam-ayam aw menenanap te otaw, keilangan imetayan heman iyan. ");
INSERT INTO mbs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ininang se otaw iling te Timanem, aw yan se doun te keilangan imetayan se otaw memonò te doma. ");
INSERT INTO mbs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Pegbatà kaw den te medita amon doen menge bowad-bowad niyo meg-ogpà doton te kebelad te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Minikagi se Timanem diyà ki Noe aw pamilya din, ");
INSERT INTO mbs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Doen ipakang ko diyà kenyo aw menge bowad-bowad niyo, ");
INSERT INTO mbs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","sipat te kedita te manok, ayam-ayam, aw menenanap dimoma kenyo kidoen te arka. ");
INSERT INTO mbs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Seini se ipakang ko diyà kenyo. Eked todà kegelà se kedita doen pedowan dini lanto te tanà te pegkelinep te tanà te wayeg. Eked todà kebàti se tanà pineokit te pegkelinep te tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Doen pengilala inangen ko amon ketegahan niyo te gayed ko tomanen se pakang ko kenyo aw kedita doen pedowan dini te keneyonan te wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Isawol ko den se binengonan kidoen te labon. Yan se pengilala tepad te pakang ko diyà te otaw eg-ogpà dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aw meglabon dini te tanà, aw kitaen se binengonan kidoen te labon, ");
INSERT INTO mbs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","keeneng-enengan ko se pakang ko kenyo aw kedita doen pedowan dini lanto te tanà, te eked todà kegelà se kedita pineokit te pegkelinep te tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Aw doen binengonan doton te labon, kitaen ko iyan, aw keeneng-enengan ko se pakang ko wedad temanan diyà te kedita doen pedowan dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yan se pengilala tepad te pakang ko diyà te kedita eg-ogpà dini lanto te tanà.” ");
INSERT INTO mbs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Se menge batà i Noe timenà lekat te arka, yan si Sem, si Ham (amay i Canaan), aw si Japet. ");
INSERT INTO mbs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Se ditelo batà i Noe sìyan, yan se menge kemonaan te kedita te otaw eg-ogpà dini te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nayan, so biyasa si Noe egpawà, sikandin se monà nenanem te paras. ");
INSERT INTO mbs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Peg-inem din te bino ininang din lekat te paras, nelasing sikandin. Minibat sikandin migpetabeg-tabeg kidoen didalem te tolda inogpaan din. ");
INSERT INTO mbs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Timengteng si Ham amay i Canaan te pegpetabeg-tabeg te amay din, aw penga niyan limowà sikandin aw mig-indan te menge kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Penga niyan, nengabat si Sem aw si Japet te penenaktun itaklub kandin. Inewidan dan se taklub diyà te getan dan, aw minipanaw dan te getan te peg-awop dan diyà te tambì din, aw tinekluban dan sikandin. Wedà dan lingì amon eked dan kitai se lawa te amay dan migpetabeg-tabeg. ");
INSERT INTO mbs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Pegkelibwan i Noe te pegkelasing din, aw pegketaga-taga din tepad te ininang i Ham diyà kandin, ");
INSERT INTO mbs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","minikagi sikandin, “Ipelumun te Timanem si Canaan batà i Ham. Meinang sikandin allang te menge kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Iduyun se Timanem egseligan i Sem. Meinang si Canaan allang i Sem. ");
INSERT INTO mbs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Inangen te Timanem medita se menge bowad-bowad i Japet (kelebadan niyan, pegkedita). Ipeogpà dan te Timanem doma te menge bowad-bowad i Sem. Meneng meinang se menge bowad-bowad i Canaan allang te menge bowad-bowad i Japet.” ");
INSERT INTO mbs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Penga te pegkelinep te tanà te wayeg, telo gatos keliman se omay minokit te wedà pa kematay si Noe. ");
INSERT INTO mbs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Siyam gatos keliman se omay i Noe te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Seini se ngadan te menge bowad-bowad te ditelo batà i Noe, si Sem, si Ham, aw si Japet, so doen menge batà dan timebaw penga te pegkelinep te tanà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Se menge batà meama i Japet, yan si Gomer, si Magog, si Madai, si Jaban, si Tubal, si Mesec, aw si Tiras. ");
INSERT INTO mbs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Se menge batà i Gomer, yan si Askenas, si Rifat, aw si Togarma. ");
INSERT INTO mbs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Se menge bowad-bowad i Jaban, yan si Elisa, si Tarsis, aw menge tege Kiti aw tege Dodani. ");
INSERT INTO mbs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sikandan se menge kemonaan te kedita te otaw eg-ogpà medapag te dagat aw doton te menge polò. Yan se menge bowad-bowad i Japet. Mig-ogpà se tegsebad-sebad pongan doton te kandan ogpeanan, aw doen heman kagi te tegsebad-sebad pongan. ");
INSERT INTO mbs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Se menge batà meama i Ham, yan si Cus, si Ehipto, si Put, aw si Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Se menge batà meama i Cus, yan si Seba, si Habila, si Sabata, si Raama, aw si Sabaca. Se menge batà meama i Raama, yan si Saba aw si Dadan. ");
INSERT INTO mbs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Doen batà meama i Cus iningedanan ki Nimrod, aw sikandin se tagnà otaw neinang medengeg tandà te keyseg din. ");
INSERT INTO mbs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ontò sikandin metomawan egpemanà pineokit te tabang te Timanem, aw yan se doun te eg-ikagi den se menge otaw, “Inangen ka peden te Timanem ontò metomawan egpemanà iling ki Nimrod.” ");
INSERT INTO mbs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pegtebò te peglowan din, limowan sikandin diyà te menge lonsod te Babel, Erac, aw Acad, ditelo lonsod doton te Sinar. ");
INSERT INTO mbs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Lekat kidoen, dimoton sikandin te Asirya, aw mig-inang sikandin te menge lonsod te Niniba, Rehobot-Ir, Cala, ");
INSERT INTO mbs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","aw Resen diyà te tengà-tengà te Niniba aw dakel lonsod te Cala. ");
INSERT INTO mbs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Ehipto se kemonaan te kedita te otaw mig-ogpà doton te Lud, Anam, Laab, Neftu, ");
INSERT INTO mbs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fetrusim, Casluim, aw Caftor linekatan te kedita te tege Filisti. ");
INSERT INTO mbs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Se menge batà i Canaan, yan si Sidon penganay batà din, aw si Het. ");
INSERT INTO mbs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan heman se kemonaan te menge pongan te otaw iningedanan Jebusi, Amori, Girgasi, ");
INSERT INTO mbs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hebi, Arki, Sinai, ");
INSERT INTO mbs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadi, Semari, aw Hamati. Neteped se tegsebad-sebad pongan te menge bowad-bowad i Canaan ");
INSERT INTO mbs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","lamig nesakop dan se kebelad te tanà lekat te lonsod te Sidon taman te lonsod te Gerara medapag te Gasa, aw nesakop heman se menge lonsod te Sodoma, Gomora, Adma, aw Seboim medapag te Lasa. ");
INSERT INTO mbs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yan se menge bowad-bowad i Ham. Mig-ogpà se tegsebad-sebad pongan dan doton te kandan ogpeanan, aw doen heman kagi te tegsebad-sebad pongan. ");
INSERT INTO mbs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Sem kakay i Japet, yan se kemonaan te kedita te otaw nesakop te pongan iningedanan Hebreo. ");
INSERT INTO mbs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Se menge batà i Sem, yan si Elam, si Asur, si Arfacsad, si Lud, aw si Aram, aw yan heman se ngadan te menge bowad-bowad dan. ");
INSERT INTO mbs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Se menge batà i Aram, yan si Us, si Hul, si Geter, aw si Mes. ");
INSERT INTO mbs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arfacsad se amay i Sela, aw si Sela se amay i Eber. ");
INSERT INTO mbs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Dowa se batà i Eber. Iningedanan se kakay ki Peleg (kelebadan niyan, netani), so pegtebaw din, netani-tani se kedita te otaw dini lanto te tanà. Iningedanan se adi din ki Joctan. ");
INSERT INTO mbs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joctan se kemonaan te menge pongan iningedanan Almodad, Selap, Hasarmabet, Jera, ");
INSERT INTO mbs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dicla, ");
INSERT INTO mbs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO mbs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Habila, aw Jobab. Menge batà i Joctan se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mig-ogpà se menge pongan dan doton te tanà lekat te Mesa taman te Separ kidoen te bontod lenged te eglibtakan te aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yan se menge bowad-bowad i Sem. Mig-ogpà se tegsebad-sebad pongan dan doton te kandan ogpeanan, aw doen heman kagi te tegsebad-sebad pongan. ");
INSERT INTO mbs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Menge bowad-bowad i Noe se kedita niyan, aw doen pongan aw pamilya te tegsebad-sebad kandan. Penga te pegkelinep te tanà te wayeg, se kedita te otaw diyà te tegsebad-sebad pongan te keneyonan, yan se menge bowad-bowad te menge batà i Noe. ");
INSERT INTO mbs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Gebii, sebad olò se kemolò te kagi eg-ikegiyen te kedita te otaw dini te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Peglegeb-legeb dan, migpesalo dan doton te eglibtakan te aldaw, lamig dimateng dan doton te tanà mebelad aw mepantal kidoen te Sinar, aw mig-ogpà dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Migpeikegihay dan, “Ayas kaw den. Loteken tadon den se pasak aw delapen tadon iyan lamig megkagsen, amon doen inangen tadon balay.” Yan linotek dan se pasak inangen dan bato, aw inimon dan se apog ibolit kenyan amon meg-inang dan te balay. ");
INSERT INTO mbs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Penga niyan, minikagi dan, “Meg-inang kidon den te lonsod aw sebad balay melangkaw lamig mapet se atep niyan doton te langit, aw yan meinang kidon medengeg, aw eked kidon kebilit kidoen te kebelad te keneyonan.” ");
INSERT INTO mbs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nayan, dimoton se Timanem amon tomengteng sikandin te lonsod aw balay melangkaw ininang te menge otaw kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mig-aneng-aneng se Timanem, “Migsebad se pedowan te kedita te otaw seini, aw sebad olò se kagi dan. Migtebò dan olò mig-inang kani. Na, te eked kenamay, pengkey eden se ibeg dan, yan se mebatog dan inangen. ");
INSERT INTO mbs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mèpiya aw domoton kidon kandan, aw todaen tadon se kagi dan amon medita kemolò se kagi dan, aw yan eked dan peilebetay.” ");
INSERT INTO mbs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yan tandà te peg-inang te Timanem kenyan, migbilit-bilit se kedita dan doton te kebelad te keneyonan, aw yan limengà dan te peg-inang dan te lonsod sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iningedanan se lonsod sìyan Babel (kelebadan niyan, migkebulung), so ininang te Timanem medita kemolò se kagi te otaw kidoen, aw lekat kidoen binilit-bilit te Timanem se kedita dan doton te kebelad te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seini se ngadan te menge bowad-bowad i Sem. Dowa se omay minokit penga te pegkelinep te tanà te wayeg, minapet te sebad gatos se omay i Sem, aw timebaw se batà din meama si Arfacsad. ");
INSERT INTO mbs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Penga niyan, lima gatos se omay minokit te wedà pa kematay si Sem. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Peg-apet te ketlowan teg lima se omay i Arfacsad, timebaw se batà din meama si Sela. ");
INSERT INTO mbs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Penga niyan, epat gatos aw telo se omay minokit te wedà pa kematay si Arfacsad. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Peg-apet te ketlowan se omay i Sela, timebaw se batà din meama si Eber. ");
INSERT INTO mbs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Penga niyan, epat gatos telo se omay minokit te wedà pa kematay si Sela. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Peg-apet te ketlowan teg epat se omay i Eber, timebaw se batà din meama si Peleg. ");
INSERT INTO mbs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Penga niyan, epat gatos ketlowan se omay minokit te wedà pa kematay si Eber. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peg-apet te ketlowan se omay i Peleg, timebaw se batà din meama si Reu. ");
INSERT INTO mbs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Penga niyan, dowa gatos siyam se omay minokit te wedà pa kematay si Peleg. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Peg-apet te ketlowan teg dowa se omay i Reu, timebaw se batà din meama si Serug. ");
INSERT INTO mbs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Penga niyan, dowa gatos aw pito se omay minokit te wedà pa kematay si Reu. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Peg-apet te ketlowan se omay i Serug, timebaw se batà din meama si Nahor. ");
INSERT INTO mbs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Penga niyan, dowa gatos se omay minokit te wedà pa kematay si Serug. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Peg-apet te kelowan teg siyam se omay i Nahor, timebaw se batà din meama si Tera. ");
INSERT INTO mbs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Penga niyan, sebad gatos sempolò teg siyam se omay minokit te wedà pa kematay si Nahor. Dalem niyan, doen pa menge doma batà din timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Peg-apet te kepitowan se omay i Tera, timebaw se menge batà din meama si Abram, si Nahor, aw si Haran. ");
INSERT INTO mbs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Seini se ngadan te menge bowad-bowad i Tera. Si Tera se amay i Abram, si Nahor, aw si Haran. Si Haran se amay i Lot. ");
INSERT INTO mbs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Te wedà pa kematay si Tera, nematay se batà din si Haran doton te Ur, sìyan lonsod inogpaan din doton te Caldea. ");
INSERT INTO mbs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nengognan si Abram ki Sarai, aw nengognan si Nahor ki Melca, batà bayi te kedowa din nematay si Haran. Doen heman doma batà i Haran si Isca. ");
INSERT INTO mbs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Wedad batà i Sarai, so eked sikandin pegbatà. ");
INSERT INTO mbs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Impetaking i Tera se batà din si Abram, aw ogangan din si Sarai esawa i Abram, aw apò din si Lot batà i Haran. Nesayo dan lekat te lonsod te Ur doton te Caldea, aw migpesalo dan doton te Canaan. Meneng pegdateng dan doton te Haran, mig-ogpà dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nematay si Tera kidoen te dowa gatos aw lima se omay din. ");
INSERT INTO mbs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nayan, minikagi se Timanem diyà ki Abram, “Tanan ka den te tanà inogpaan no seini. Tanan ka den heman te menge kedomaan nikaw aw pamilya te amay nikaw. Doton ka den te ogpeanan tedoan ko kamno. ");
INSERT INTO mbs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Medita se bowad-bowad ibegay ko diyà kamno, aw meinang dan dakel pongan. Mèpiya se ibegay ko diyà kamno, aw inangen ko medengeg se ngadan nikaw. Mèpiya heman se ibegay ko diyà te menge doma otaw pineokit kamno. ");
INSERT INTO mbs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mèpiya se ibegay ko diyà te kedita te otaw memegay kamno te mèpiya. Meneng ipelumun ko se kedita te otaw megtompuyus kamno. Pineokit kamno, mèpiya se ibegay ko diyà te kedita te otaw dini te keneyonan.” ");
INSERT INTO mbs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yan timolò si Abram te punù te Timanem, aw nesayo sikandin tinekingan i Lot. Kepitowan teg lima se omay i Abram te pegkesayo din lekat te Haran. ");
INSERT INTO mbs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Impetaking i Abram se esawa din si Sarai, aw anak din si Lot, aw inibing din se kedakel te kedònan aw kedita te allang neabat din doton te Haran, aw nesayo dan pesalo doton te Canaan. Pegdateng dan doton te Canaan, ");
INSERT INTO mbs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","dimeleg si Abram lamig dimateng sikandin doton te kayo olayan i More doton te ogpeanan te Sikem. Pegdoton din te Sikem, doen pa menge tege Canaan mig-ogpà kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Migpekità se Timanem diyà ki Abram, aw minikagi sikandin, “Seini se ogpeanan ibegay ko diyà te menge bowad-bowad nikaw.” Yan mig-inang si Abram te sonoganan te ayam-ayam ibegay diyà te Timanem migpekità diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Penga niyan, dimeleg sikandin pesalo doton te menge bontod lenged te eglibtakan te lonsod te Betel. Mig-ogpà sikandin diyà te tengà-tengà te lonsod te Betel aw Ai. Lenged te egsellepan se lonsod te Betel, aw lenged te eglibtakan se lonsod te Ai. Mig-inang heman sikandin te sonoganan te ayam-ayam kidoen, aw migsimba sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Penga niyan, gayed sikandin mig-alin-alin pesalo doton te Negeb. ");
INSERT INTO mbs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nayan, doen bitil doton te Canaan, aw dimeleg si Abram doton te Ehipto amon meg-ogpà dan doton te menamay-namay, so ontò dan nebitilan. ");
INSERT INTO mbs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pegkedapag dan doton te Ehipto, minikagi si Abram diyà te esawa din si Sarai, “Mèpiya ka bayi tengtengen. ");
INSERT INTO mbs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Yan aw komità se menge tege Ehipto kamno, meg-aneng-aneng dan te teleesawa ki, aw yan mengimatay dan kanak amon egawen ka dan. ");
INSERT INTO mbs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Yan ikagi ka kandan te telekedowa ki amon eked a dan imetayi, meneng segmanen a dan beling so etebay ta.” ");
INSERT INTO mbs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Pegdateng dan doton te Ehipto, kinità te menge otaw kidoen te mèpiya bayi tengtengen se esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pegkità te menge opisyal te selotan kandin, mig-indan dan te selotan tepad te kèpiya din, aw yan impeogpà din si Sarai doton te balay din. ");
INSERT INTO mbs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mèpiya se imbegay te selotan diyà ki Abram so etebay din si Sarai. Yan binegayan sikandin te medita karniro, kambing, baka, asno, allang, aw kamilo. ");
INSERT INTO mbs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Meneng so impeogpà te selotan se esawa i Abram si Sarai doton te balay din, doen menge medaet mesakit imbegay te Timanem diyà te selotan aw kedita te doma otaw mig-ogpà kidoen te balay din. ");
INSERT INTO mbs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yan impeangay te selotan si Abram, aw minikagi sikandin, “Medaet se ininang no diyà kanak, so wedà a no indani te teleesawa kaw. ");
INSERT INTO mbs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Meneng minikagi ka beling te telekedowa kaw, aw yan nengognan a kandin. Na, dini den se esawa nikaw. Petekingi sikandin, aw kesayo kaw den.” ");
INSERT INTO mbs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Penga niyan, insogò te selotan se menge sondalo meg-ated ki Abram, aw esawa din, aw kedakel te kedònan din te pegkesayo dan. ");
INSERT INTO mbs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nesayo si Abram lekat te Ehipto aw limikò sikandin doton te Negeb sakop te Canaan sipat te esawa din aw kedakel te kedònan din. Timaking heman si Lot kandin. ");
INSERT INTO mbs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ontò meyaman si Abram, so medita se karniro din, kambing, aw baka, aw dakel heman se selapì aw bolawan din. ");
INSERT INTO mbs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Pegkesayo din lekat te Negeb, mig-alin-alin sikandin pesalo doton te Betel lamig dimateng sikandin doton te tapay ogpeanan din kidoen te tengà-tengà te Betel aw Ai. ");
INSERT INTO mbs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Yan heman se tapay din ininangan te sonoganan te ayam-ayam. Todà sikandin migsimba te Timanem kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Nayan, timaking heman si Lot ki Abram, aw doen heman menge pamilya din, aw sineligan din, aw menge karniro, kambing, aw baka din. ");
INSERT INTO mbs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yan kenà botong se tanà loyawan te kedita te ayam-ayam te didowa dan aw megsebad dan, so pelaban medita se ayam-ayam dan. ");
INSERT INTO mbs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Yan se doun te migbolaw se menge telediyaga i Abram aw menge telediyaga i Lot. (Doen heman menge tege Canaan aw tege Perisi mig-ogpà pa kidoen.) ");
INSERT INTO mbs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yan minikagi si Abram diyà ki Lot, “Eked a keibeg aw megbolaw ki aw megbolaw heman se menge telediyaga ta, so anak ko sikona. ");
INSERT INTO mbs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Yan mèpiya aw megpeteniyay ki den. Na, pegpeatap-atap ka den te kebelad te tanà seini. Aw pemellien no se tanà lenged te bibang, malin a doton te tanà lenged te kowanan. Aw pemellien no se tanà lenged te kowanan, malin a doton te tanà lenged te bibang.” ");
INSERT INTO mbs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Migpeatap-atap si Lot, aw kinità din te mèpiya se kebelad te tanà medapag te wayeg te Jordan taman te lonsod te Soar, so dakel se wayeg kidoen iling te kekeyowan intanem te Timanem, aw iling te Ehipto. (Neinang iyan te wedà pa bàti te Timanem se lonsod te Sodoma aw Gomora kidoen medapag te wayeg te Jordan.) ");
INSERT INTO mbs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yan pinemallì i Lot se kebelad te tanà medapag te wayeg te Jordan, aw minalin sikandin lenged te eglibtakan. Yan se pegpeteniyay te didowa dan. ");
INSERT INTO mbs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Mig-ogpà pa si Abram doton te Canaan, meneng minalin si Lot doton te menge lonsod kidoen medapag te wayeg te Jordan, aw mig-ogpà sikandin medapag te lonsod te Sodoma. ");
INSERT INTO mbs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ontò medaet se eg-inangen te menge tege Sodoma. Ontò medaet se salà eg-inangen dan diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Penga te pegkesayo i Lot, minikagi se Timanem diyà ki Abram, “Pegpeatap-atap ka den doton te kebelad te tanà pengkey kenan se kitaen nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Se kebelad te tanà kitaen nikaw, yan se ibegay ko diyà kamno aw menge bowad-bowad nikaw te wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Inangen ko medita se bowad-bowad nikaw igsà eked dan kebilang. Labi pa mola se pegbilang te menge napò te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nayan, peglegeb ka den doton te kebelad te tanà, so yan se ibegay ko diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Penga niyan, minalin si Abram, aw mig-ogpà sikandin kidoen medapag te menge olayan i Mamre doton te Hebron, aw mig-inang sikandin te sonoganan te ayam-ayam kidoen amon megsimba sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Nayan, si Amrafel se selotan doton te Sinar, si Arioc se selotan doton te Elasar, si Cadorlahomor se selotan doton te Elam, aw si Tadal se selotan doton te Goyim. Dalem te pegkeselotan dan, migsebad se epat dan migbolaw diyà te doma lima selotan seini, si Bara selotan te Sodoma, si Birsa selotan te Gomora, si Sinab selotan te Adma, si Semeber selotan te Seboyim, aw sìyan selotan te Bela doma ngadan niyan Soar. ");
INSERT INTO mbs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Migsebad se lima selotan sìyan, aw netipon se kedita te sondalo dan doton medapag te baog te Sidim neinang den songkani Lanaw te Asin. ");
INSERT INTO mbs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tapay sinakop i Cadorlahomor se lima selotan sìyan dalem te sempolò teg dowa se omay. Meneng pegdateng te ikesempolò teg telo te omay, minato dan kandin. ");
INSERT INTO mbs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pegdateng te ikesempolò teg epat te omay, limompak si Cadorlahomor aw menge doma selotan migsebad diyà kandin. Dinaeg dan se kedita te tege Repai doton te Astarot-carnaim. Dinaeg dan heman se menge tege Susi doton te Ham, aw menge tege Emi doton te kepetagan te Kiriataim. ");
INSERT INTO mbs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Dinaeg dan heman se kedita te menge tege Hori doton te bontod inogpaan dan doton te Seir, aw pig-alaw dan taman te lonsod te Elparan medapag te kebigtilan. ");
INSERT INTO mbs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Penga niyan, limikò dan doton te lonsod te Cades (Enmispat se doma ngadan niyan). Dinaeg dan heman se kedita te otaw mig-ogpà doton te tanà te menge Amalek, aw dinaeg dan se menge Amori mig-ogpà doton te Hasason Tamar. ");
INSERT INTO mbs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Penga niyan, migpetagad se menge selotan te Sodoma, Gomora, Adma, Seboyim, aw Bela te menge sondalo dan. Dimoton dan te baog te Sidim amon mato dan ");
INSERT INTO mbs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","te menge sondalo te epat selotan kidoen, si Cadorlahomor selotan te Elam, si Tadal selotan te Goyim, si Amrafel selotan te Sinar, aw si Arioc selotan te Elasar. Lima se selotan migbolaw te epat selotan. ");
INSERT INTO mbs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Medita se baog-baog kidoen doen koliko te aspalto ontò melemiket. Pegkedaeg te selotan te Sodoma aw selotan te Gomora, kimadas se menge sondalo dan, aw doen nepolotan kandan kidoen te menge baog-baog sìyan, aw kimadas se menge doma sondalo doton te menge bontod. ");
INSERT INTO mbs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Penga niyan, mig-agaw se epat selotan te kedakel te kedònan aw kànen kidoen te lonsod te Sodoma aw Gomora, aw nesayo dan. ");
INSERT INTO mbs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Dinakep dan heman se anak i Abram si Lot, aw inagaw dan se kedònan din, so mig-ogpà sikandin doton te Sodoma. ");
INSERT INTO mbs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Doen sebad otaw nekelowà mig-indan te kedita niyan diyà ki Abram se Hebreo. Dalem niyan, mig-ogpà si Abram doton medapag te menge olayan i Mamre tege Amori. Gayed egpedepitay si Abram, si Mamre, aw menge kedowa i Mamre, si Escol aw si Aner. ");
INSERT INTO mbs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pegketaga-taga i Abram te nedakep se anak din, tinipon din se kedita te sineligan din biyasa eglegamit te kekamang, telo gatos sempolò teg walo se kedita dan, aw mig-alaw dan te epat selotan sìyan taman te lonsod te Dan. ");
INSERT INTO mbs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pegkedelem niyan, impeebong-ebong i Abram se menge sineligan din kidoen, aw limompak dan kandan, aw dimaeg dan kandan. Pig-alaw dan i Abram taman te lonsod te Hoba digsel te Damasko. ");
INSERT INTO mbs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Neabat i Abram se kedakel te kedònan neagaw dan. Impelowà din heman se anak din si Lot, aw in-olì din diyà ki Lot se kedakel te kedònan neagaw lekat kandin. Impelowà din heman se kedita te bayi aw menge doma otaw nedakep. ");
INSERT INTO mbs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Peg-olì i Abram lekat te pegdaeg din ki Cadorlahomor aw menge doma selotan, simongon se selotan te Sodoma kandin doton te Baog te Sabec (iningedanan heman iyan Baog te Selotan). ");
INSERT INTO mbs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Penga niyan, sinongon heman si Abram te selotan te Salem si Melkisedec. Sikandin heman se telekagon te Timanem Melangkaw. Inibing din se pan aw bino doton ki Abram. ");
INSERT INTO mbs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Migtawal-tawal sikandin amon mèpiya se ibegay te Timanem diyà ki Abram. Minikagi sikandin, “Mèpiya se ibegay diyà kamno lekat te Timanem Melangkaw, sìyan mig-inang te langit aw keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Iduyun se Timanem Melangkaw, so tinebangan ka din te pegdaeg no te menge poon nikaw.” Penga niyan, nemegay si Abram diyà kandin te ikesempolò ketengà te kedita neabat din lekat te epat selotan dinaeg din. ");
INSERT INTO mbs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Minikagi se selotan te Sodoma diyà ki Abram, “Kamno den se kedakel te kedònan day neabat no lekat te epat selotan mig-agaw kenyan lekat kenami. Olò menge sakop ko se iolì no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Meneng minikagi si Abram diyà te selotan te Sodoma, “Megsapà a den diyà te Timanem Melangkaw, sìyan mig-inang te langit aw keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Megpakang a den te wedad palos kedònan no eked ko olii diyà kamno, pengkey sebad sinolib, aw pengkey sebad liston te sepatos. Wedad eked ko olii, so eked a keibeg aw mikagi ka te migkeyaman a pineokit kamno. ");
INSERT INTO mbs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wedad palos ebaten ko, meneng se kinaen te menge sineligan ko, yan olò se eked ko olii. Keilangan doen heman talad te menge otaw dimapit kanak, si Aner, si Escol, aw si Mamre.” ");
INSERT INTO mbs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Penga niyan, migpekità se Timanem diyà ki Abram, aw minikagi sikandin, “E Abram, ikà egkelemitan. Siak se megkelasag kamno amon eked ka peelegi. Ontò dakel se ontong ibegay ko diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Meneng minikagi si Abram, “E Timanem eglowan diyà te kedita, wedad palos ibegay no diyà kanak mekebegay te keluba te pedowan ko dalem te wedad batà ko. Aw matay a, metig-apò i Elieser tege Damasko se kedita te kedònan ko. ");
INSERT INTO mbs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","So wedad batà imbegay no kanak, olò allang ko se meketig-apò te kedakel te kedònan ko aw matay a.” ");
INSERT INTO mbs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Penga niyan, minikagi se Timanem diyà kandin, “Kenà si Elieser se meketig-apò te kedònan nikaw, so kamno batà meama se meketig-apò te kedònan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Inibing te Timanem si Abram doton te lowà te balay, aw minikagi sikandin, “Lengag ka den doton te langit. Pegbilang ka te menge bitoen aw mebatog nikaw. Iling kenyan se kedita te menge bowad-bowad nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Nemenal si Abram te Timanem, aw yan se doun te mig-aneng-aneng se Timanem te metòlid sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Minikagi heman se Timanem, “Siaken se Timanem nengibing kamno lekat te Ur te Caldea. Tod ko ibegay ko diyà kamno se tanà seini, amon tig-epoen no iyan.” ");
INSERT INTO mbs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Meneng mig-insà si Abram, “E Timanem eglowan diyà te kedita, eden lay se pengilala ipekità no diyà kanak amon ketegahan ko te metoman a meketig-apò kani?” ");
INSERT INTO mbs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Minikagi se Timanem, “Ibingi dini kanak se baka, kambing, aw karniro, aw keilangan olò telo se omay te tegsebad-sebad kenyan. Ibingi heman dini kanak se ponay aw selepati.” ");
INSERT INTO mbs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Inibing i Abram se kedita niyan, aw inimetayan din iyan. Binekas din se lawa niyan, aw binelabay din iyan tegdowa-dowa, aw doen elet diyà te tengà-tengà. Meneng wedà din bekasi se dowa manok. ");
INSERT INTO mbs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Doen menge dakel manok te kebenesan minembong diyà te lawa niyan, meneng linalag iyan i Abram. ");
INSERT INTO mbs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pegsallep te aldaw, ontò sikandin impetedogi te Timanem, aw iling te ontò nelemitan se pedowan din. ");
INSERT INTO mbs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Minikagi se Timanem diyà kandin, “Metoman meg-ogpà se menge bowad-bowad no doton te tanà tinig-apò te menge doma otaw te sebad pongan. Kelimahan dan aw ellangen dan te doma otaw taman te epat gatos se omay. ");
INSERT INTO mbs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Meneng ipelumun ko se menge otaw meg-allang kandan, aw penga niyan mekelowà dan lekat kidoen te dakel se kedònan ibingen dan. ");
INSERT INTO mbs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Meneng sikona se eked kesamok. Eked ka kematay singed aw ontò ka megketemoay, aw penga niyan ilebeng ka. ");
INSERT INTO mbs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Penga te peg-ogpà te menge bowad-bowad no doton te doma ogpeanan taman te ikeepat kebelikwat se pamilya megpetondogay, molì dan dini, so gayed dogangan te menge otaw Amori se peg-inang dan te salà igsà keilangan ipelumun ko dan.” ");
INSERT INTO mbs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pegsallep te aldaw sìyan aw pegkengitngit, tigkan kinità i Abram se iling te depolan minebel aw gansà limegdeg. Minokit iyan diyà te tengà-tengà te lawa te ayam-ayam binekas din. ");
INSERT INTO mbs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Te delem sìyan, migpakang se Timanem diyà ki Abram, kagi din, “Ibegay ko diyà te menge bowad-bowad nikaw se kebelad te tanà seini. Lekat te wayeg doton te Ehipto taman te dakel wayeg te Yofritis, yan se tanà ibegay ko diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ibegay ko heman diyà kandan se tanà inogpaan te menge pongan te otaw iningedanan Keni, Kenisi, Cadmoni, ");
INSERT INTO mbs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Heti, Perisi, Repai, ");
INSERT INTO mbs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Canaan, Girgasi, aw Jebusi.” ");
INSERT INTO mbs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Nayan, wedad palos batà i Sarai aw si Abram. Meneng doen allang bayi i Sarai ngadan din si Agar tege Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Yan minikagi si Sarai diyà ki Abram, “Wedad batà imbegay te Timanem diyà kanak. Yan mèpiya aw lomayok ka den diyà te allang ko amon doen pa peden batà ko pineokit kandin.” Timandù si Abram diyà te inikagi i Sarai, ");
INSERT INTO mbs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","aw yan nemegay si Sarai te allang din diyà ki Abram amon inangen din esawa din. Neinang ini penga te peg-ogpà i Abram doton te Canaan te sempolò se omay. ");
INSERT INTO mbs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Migpeleyokay dan aw miglaman si Agar. Pegketaga-taga i Agar te miglaman sikandin, migpelangkaw-langkaw sikandin diyà ki Sarai aw piglindoan din. ");
INSERT INTO mbs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Yan minikagi si Sarai diyà ki Abram, “Sikona se linekatan te salà neinang den diyà kanak. Sikona se binegayan ko ki Agar, aw yan miglaman sikandin, aw yan se doun te eglindoan a din. Netaga-taga se Timanem te doen salà no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Minikagi si Abram, “Na, kamno allang sikandin. Pengkey eden se ibeg no inangen diyà kandin, mepakay iyan diyà kanak.” Penga niyan, ontò pinemilang i Sarai si Agar igsà kimadas sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Doen anghil te Timanem migpekità diyà ki Agar kidoen te kebigtilan medapag te selep doton te dalan pesalo doton te lonsod te Sur. ");
INSERT INTO mbs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Minikagi se anghil, “E Agar, allang i Sarai, kenan ka lay lekat, aw kenan ka lay pesalo?” Timaba si Agar, “Kimadas a den lekat te amo ko si Sarai.” ");
INSERT INTO mbs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Minikagi se anghil, “Olì ka den doton kandin, aw tolò ka kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Minikagi heman se anghil, “Inangen ko ontò medita se bowad-bowad nikaw igsà eked dan kebilang. ");
INSERT INTO mbs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Doen batà meama tomebaw diyà kamno, aw ingedanan no sikandin ki Ismael, so dimineg se Timanem te pegpengenganay no diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Meinang se batà nikaw iling te asno wedà kegnuki, so wedad toloen din. Megpoon sikandin te kedita te otaw, aw megpoon dan heman kandin. Eked sikandin peg-ogpà doma te menge kedowa din.” ");
INSERT INTO mbs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Minikagi si Agar, “Ontò ko den kinità se Timanem kimità kanak, aw wedà a kematay.” Iningedanan din se migpekità diyà kandin “Timanem egpengità.” ");
INSERT INTO mbs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yan se doun te iningedanan se selep sìyan Beer Lahai Roi (kelebadan niyan, selep te Timanem doen pedowan egpengità kanak). Kidoen pa songkani se selep sìyan doton te tengà-tengà te lonsod te Cades aw Bered. ");
INSERT INTO mbs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Doen batà meama timebaw diyà ki Agar aw si Abram. Iningedanan sikandin i Abram ki Ismael (kelebadan niyan, egpenenalan se Timanem). ");
INSERT INTO mbs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kewelowan teg enem se omay i Abram te pegtebaw i Ismael. ");
INSERT INTO mbs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Peg-apet te kesyaman teg siyam se omay i Abram, migpekità se Timanem diyà kandin, aw minikagi sikandin, “Siak se Timanem eglowan diyà te kedita. Tolò ka kanak. Keilangan gayed ka meg-inang te metòlid. ");
INSERT INTO mbs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tomanen ko se pakang ko kamno. Inangen ko ontò medita se bowad-bowad nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Limongken si Abram lamig minapet se olo din diyà te tanà, aw minikagi heman se Timanem, ");
INSERT INTO mbs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Seini se ipakang ko diyà kamno. Inangen ko sikona kemonaan te medita pongan. ");
INSERT INTO mbs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Lekat seini, eked ka den ingedani ki Abram (kelebadan niyan, melangkaw amay), meneng ingedanan ka den ki Abraham (kelebadan niyan, amay te medita pongan), so inangen ko sikona kemonaan te medita pongan. ");
INSERT INTO mbs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Inangen ko medita se bowad-bowad nikaw, aw inangen ko dan medita pongan, aw doen heman kandan meinang menge selotan. ");
INSERT INTO mbs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tomanen ko se pakang ko diyà kamno aw diyà te menge bowad-bowad nikaw te wedad temanan. Siak se Timanem meg-ipat kamno aw menge bowad-bowad nikaw te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Se kedakel te tanà te Canaan làno nikaw inogpaan, yan se ibegay ko diyà kamno aw diyà te menge bowad-bowad nikaw amon tig-epoen niyo iyan te wedad temanan. Siak se Timanem meg-ipat kandan.” ");
INSERT INTO mbs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Minikagi se Timanem diyà ki Abraham, “Doen pengilala tepad te pakang ko keilangan inangen no sipat te kedita te bowad-bowad nikaw te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Seini se pengilala tepad te pakang ko keilangan inangen no sipat te kedita te bowad-bowad nikaw. Keilangan tolien se kedita te meama kidoen kamno. ");
INSERT INTO mbs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Keilangan megpetolì ka, so yan se pengilala tepad te pakang ko kamno. ");
INSERT INTO mbs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Se menge bowad-bowad nikaw heman te modi aldaw, keilangan tolien se kedita te batà dan meama te ikewalo te aldaw lekat te pegtebaw, sipat te kedita te allang niyo meama, pengkey tomebaw doton kenyo, aw pengkey beyadan diyà te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Keilangan tolien se kedita te meama, so pineokit te pengilala sìyan kidoen te lawa niyo, ketegahan niyo te wedad temanan te pakang ko kenyo. ");
INSERT INTO mbs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aw eked tolii se meama, eked sikandin pekeakop diyà kenyo, so eked sikandin tolò te punù tepad te pengilala te pakang ko.” ");
INSERT INTO mbs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Minikagi se Timanem diyà ki Abraham, “Lekat seini, eked den kepakay aw si Sarai se ngadan te esawa nikaw. Keilangan ingedanan no sikandin ki Sara (kelebadan niyan, batà bayi te selotan). ");
INSERT INTO mbs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mèpiya se ibegay ko diyà kandin, aw ibegay ko diyà kamno se batà meama tomebaw diyà kandin. Mèpiya se ibegay ko diyà te esawa nikaw, aw meinang sikandin kemonaan te medita pongan. Doen menge bowad-bowad din meinang selotan.” ");
INSERT INTO mbs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Limongken si Abraham lamig minapet se olo din diyà te tanà. Nebebayat sikandin, so mig-aneng-aneng sikandin, “Pengkey sebad gatos se omay ko, meneng doen kedì batà ko tomebaw. Pengkey kesyaman se omay i Sara, meneng tebawan kedì sikandin te batà.” ");
INSERT INTO mbs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Minikagi sikandin diyà te Timanem, “Ibeg ko si Ismael peden heman se begayan no te mèpiya.” ");
INSERT INTO mbs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Meneng minikagi se Timanem, “Esawa no si Sara se tebawan te batà no meama, aw ingedanan no se batà no sìyan ki Isaac (kelebadan niyan, nebebayat). Sikandin aw menge bowad-bowad din se ketomanan te pakang ko te wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dinineg ko se pinemoyò no tepad ki Ismael, aw yan mèpiya heman se ibegay ko diyà kandin. Ibegay ko diyà kandin se medita batà din aw menge bowad-bowad din. Meinang sikandin kemonaan te sempolò teg dowa datò, aw inangen ko dakel pongan se menge bowad-bowad din. ");
INSERT INTO mbs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Meneng se batà no si Isaac, yan se ketomanan te pakang ko kamno. Tomebaw sikandin diyà ki Sara te iling kani te modi omay.” ");
INSERT INTO mbs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Penga te peg-ikagi te Timanem diyà ki Abraham, nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Dalem te aldaw sìyan, timolò si Abraham te Timanem, aw nenolì sikandin te batà din si Ismael, aw kedita te doma sakop din meama, sipat te kedita te allang din, pengkey timebaw kidoen kandin, aw pengkey bineyadan din diyà te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Kesyaman teg siyam se omay i Abraham te pegpetolì din, ");
INSERT INTO mbs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","aw sempolò teg telo se omay te batà din si Ismael. ");
INSERT INTO mbs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Dalem te aldaw sìyan, tinolì se didowa dan, ");
INSERT INTO mbs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","sipat te kedita te allang din meama. ");
INSERT INTO mbs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Peg-ogpà i Abraham doton te menge olayan i Mamre, migpekità se Timanem diyà kandin. Pegkeinit te aldaw, nenenoo si Abraham doton te lelebangan te tolda inogpaan din. ");
INSERT INTO mbs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Pegtengteng din kidoen te lowà, kinità din se telo otaw timindeg medapag kidoen. Pegkità din kandan, ayas sikandin simongon kandan. Limongken sikandin lamig minapet se olo din diyà te tanà amon megsagman kandan. ");
INSERT INTO mbs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Minikagi sikandin, “Sir, apit kaw den dini kanak. Ikà niyo eglaklak. ");
INSERT INTO mbs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ibingen ko se wayeg ionaw te benis niyo, aw mekeetod kaw dini te kayo seini. ");
INSERT INTO mbs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ipekaen ko heman sikiyo amon todà kaw megkagsen te eked kaw pa deleg. Neluba se pedowan ko so dimini kaw, aw meibeg a megtabang kenyo.” Minikagi dan, “Mepakay iyan diyà kenami.” ");
INSERT INTO mbs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ayas minawop si Abraham aw minikagi sikandin diyà ki Sara, “Kegaen ka. Gemiti se sebad sako ontò mèpiya arina, aw inangi se pan ipekaen kandan.” ");
INSERT INTO mbs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Penga niyan, kimagnan si Abraham doton te menge ayam-ayam din, aw pinemallì din se ontò mèpiya nati te baka. Imbegay din iyan diyà te sebad sineligan din amon iyawen din iyan aw ilegaen te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Pegtegilan dan te kedita, inibing i Abraham se kisiyo, aw gatas, aw pengelapen tinoeg, aw imbayaw din iyan diyà kandan. Dalem te pegpengaen dan, timindeg sikandin medapag doton te siyong te kayo. ");
INSERT INTO mbs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Mig-insà dan diyà kandin, “Kenan lay se esawa nikaw si Sara?” Timaba si Abraham, “Doton didalem.” ");
INSERT INTO mbs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Minikagi se sebad, “Doen inangen ko metolos te modi omay, so doen batà meama tomebaw diyà te esawa no si Sara.” Nayan, kidoen si Sara te lelebangan lenged te getan din, aw dinineg din se inikagi dan. ");
INSERT INTO mbs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ontò den temoay si Abraham, aw ontò den lokes si Sara. Wedad bayi tebawan aw mapet se omay din iling te omay i Sara. ");
INSERT INTO mbs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Yan se doun te nebebayat si Sara diyà te kandin pegkeotawun, aw mig-aneng-aneng sikandin, “Meneng ontò a den lokes, aw ontò den temoay se esawa ko. Menonen se pegdateng te keluba sìyan diyà kanak?” ");
INSERT INTO mbs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Penga niyan, mig-insà se Pengolo diyà ki Abraham, “Nengà lay nebebayat si Sara? Nengà lay minikagi sikandin te menonen se pegtebaw te batà diyà kandin so ontò den sikandin lokes? ");
INSERT INTO mbs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wedad palos eked kebatog te Timanem. Doen inangen ko metolos te modi omay, so doen batà meama tomebaw diyà ki Sara.” ");
INSERT INTO mbs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nelemitan si Sara, aw yan migkebolalaw sikandin aw minikagi, “Wedà a kebebayat.” Meneng minikagi se Pengolo, “Benal ka nebebayat.” ");
INSERT INTO mbs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pegkesayo te telo memanit lekat kidoen, dimoton dan te pemebongan aw migpeatap-atap dan doton te lonsod te Sodoma. Timaking si Abraham kandan amon megtedò kandan te dalan. ");
INSERT INTO mbs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mig-aneng-aneng se Pengolo, “Eked ko elesi diyà ki Abraham se tod ko agpet den inangen, ");
INSERT INTO mbs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","so meinang dakel pongan se menge bowad-bowad din, aw mèpiya se ibegay ko diyà te kedita te otaw pineokit kandin. ");
INSERT INTO mbs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pinemallì ko sikandin amon megtoladà sikandin te menge batà din aw menge bowad-bowad din te keilangan tomolò dan kanak, aw keilangan meg-inang dan te metòlid. Aw yan se inangen dan, tomanen ko se kedita te impakang ko diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Penga niyan, minikagi se Pengolo diyà ki Abraham, “Medita se minikagi diyà kanak te medaet se eg-inangen te menge tege Sodoma aw tege Gomora. Ontò ekon mebegat se salà dan. ");
INSERT INTO mbs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Yan domoton a den amon ketegahan ko aw benal se dinineg ko, aw kenà.” ");
INSERT INTO mbs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Penga niyan, nesayo se didowa otaw migpesalo doton te Sodoma, meneng mig-ogpà pa se Pengolo aw si Abraham kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Migpedapag si Abraham diyà te Pengolo, aw mig-insà sikandin, “Aw igelaen no se menge medaet otaw, ipesipat no lay heman se menge mèpiya otaw? ");
INSERT INTO mbs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Simpana aw keliman se mèpiya otaw eg-ogpà doton te lonsod sida, tigkan no lay pegbàtan se lonsod? Eked no lay iyan keidowi tandà te keliman mèpiya otaw? ");
INSERT INTO mbs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aneng-aneng ko eked no imetayi se menge mèpiya otaw sipat te menge medaet otaw. Eked kepakay aw yan se inangen nikaw. Aw ipelumun no se medaet otaw, eked no pesipati se mèpiya otaw, so sikona se eg-okom te kedita te otaw, aw keilangan metòlid se inangen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Timaba se Pengolo, “Aw keliman se mèpiya otaw kitaen ko doton te lonsod sida, keidowan ko se kedakel te lonsod tandà te keliman mèpiya otaw.” ");
INSERT INTO mbs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Minikagi heman si Abraham, “Sir, pengkey ontò ka melangkaw diyà kanak, meneng pekeleyati se pedowan no diyà kanak te peg-ikagi ko todà diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Simpana aw olò kepatan teg lima se mèpiya otaw, pegbàtan no lay se kedakel te lonsod so kolang te lima?” Timaba se Pengolo, “Aw kepatan teg lima se mèpiya otaw kitaen ko kidoen, eked ko pegbàti se lonsod.” ");
INSERT INTO mbs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Minikagi heman si Abraham, “Simpana aw olò kepatan se kitaen nikaw?” Timaba se Pengolo, “Aw doen kepatan, eked ko iyan pegbàti.” ");
INSERT INTO mbs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Minikagi si Abraham, “Sir, ikà egkeopal kanak aw todà a mikagi diyà kamno. Simpana aw olò ketlowan se kitaen nikaw?” Timaba se Pengolo, “Aw ketlowan se kitaen ko, eked ko iyan pegbàti.” ");
INSERT INTO mbs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Minikagi si Abraham, “Sir, pekeleyati se pedowan no diyà kanak te peg-ikagi ko todà diyà kamno. Simpana aw olò kelowan se kitaen nikaw?” Timaba se Pengolo, “Aw kelowan se kitaen ko, eked ko pegbàti se lonsod.” ");
INSERT INTO mbs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Minikagi si Abraham, “Sir, ikà bag egkeopal kanak, so seini se temanan te peg-ikagi ko. Simpana aw olò sempolò se kitaen nikaw?” Timaba se Pengolo, “Aw doen sempolò, eked ko iyan pegbàti.” ");
INSERT INTO mbs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Penga te pegpebelaw-belaway te Pengolo aw si Abraham, nesayo se Pengolo, aw minolì si Abraham. ");
INSERT INTO mbs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Sìyan didowa memanit nekeonà, yan se anghil. Pegkemeapon, dimateng dan doton te Sodoma. Kidoen si Lot nenenoo medapag te lelebangan diyà te melangkaw kotà nekelibed te lonsod sìyan. Pegkità din kandan, timindeg sikandin aw simongon kandan. Limongken sikandin lamig minapet se olo din diyà te tanà, ");
INSERT INTO mbs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","aw minikagi sikandin, “Sir, apit kaw den doton te balay ko. Peonawi niyo se benis niyo, aw idegà kaw dini, aw yan mekedeleg kaw kealdaw te iselem.” Meneng minikagi dan, “Eked kay, so midegà kay dini te plasa.” ");
INSERT INTO mbs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Meneng gayed dan pig-ibing i Lot lamig timaking dan kandin doton te balay din. Impeinang i Lot se pan aw menge doma mèpiya kànen, aw kimaen dan. ");
INSERT INTO mbs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Te wedà dan pa ibat te delem, nelibedan se balay te kedita te meama tege Sodoma. Netipon se kedita dan, pengkey telaki aw temoay. ");
INSERT INTO mbs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Timawal dan diyà ki Lot, kagi dan, “Kenan lay se didowa meama dimateng gina dini kamno te meapon? Pelowai dan diyà kenami amon lomayok kay diyà kandan.” ");
INSERT INTO mbs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Limowà si Lot te balay din aw tinakep din se lelebangan. ");
INSERT INTO mbs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Minikagi sikandin, “Menge sigalak ko, eked iyan kepakay. Ikà niyo eg-inang te medaet sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Meneng doen beling dowa batà ko laga wedà pa palos leyoki. Ipelowà ko den dan, aw mepakay kaw meg-inang diyà kandan te pengkey eden se ibeg niyo. Meneng ikà niyo egpeeleg te didowa meama sìyan, so migmemanit dan diyà kanak, aw yan keilangan ipaten ko dan.” ");
INSERT INTO mbs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Meneng minikagi dan, “Ikà egsagda kenami. Pengkey kenà ka tege dini, meneng mikagi ka peden diyà kenami aw eden se mepakay day inangen. Aw aneng-aneng no medaet se inangen day diyà kandan, labi pa medaet se inangen day diyà kamno.” Sinegseg dan si Lot, aw migpedapag dan diyà te tetakep amon bàtan dan iyan. ");
INSERT INTO mbs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Meneng inowang te didowa anghil se tetakep, aw ginakgak dan si Lot doton didalem te balay, aw tinakep dan se lelebangan. ");
INSERT INTO mbs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Penga niyan, pineokit te tolos dan, ininang dan bota se kedita te otaw medapag te lelebangan, amon eked dan kità te lelebangan. ");
INSERT INTO mbs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Minikagi se didowa anghil diyà ki Lot, “Aw doen menge kedomaan no dini, menge batà nikaw, ogangan nikaw, aw menge doma sakop nikaw mig-ogpà dini te lonsod seini, petekingi dan, aw kesayo kaw den, ");
INSERT INTO mbs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","so pegbàtan day den se lonsod seini. Dinineg te Timanem se insila kandan tepad te medaet eg-inangen dan, aw yan insogò kay din dini amon megbaet kay te kedita.” ");
INSERT INTO mbs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yan nesayo si Lot aw dimoton sikandin te salà te dowa batà din bayi, aw minikagi sikandin, “Ayas kaw den kesayo lekat dini, so pegbàtan den te Timanem se lonsod seini.” Meneng eden dan aw kebawol din iyan. ");
INSERT INTO mbs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pegkeiselem niyan, ginallat te anghil si Lot, kagi dan, “Kegaen ka den. Petekingi den se esawa no aw dowa batà no laga, aw kadas kaw den amon eked kaw kesàbi te pegbaet te Timanem te lonsod seini.” ");
INSERT INTO mbs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Meneng gayed pa sikandin mig-alà-alà. Penga niyan, so neidowan dan te Timanem, minawid se didowa anghil te belad i Lot aw belad te esawa din, aw didowa batà dan, aw inibing dan doton te lowà te lonsod. ");
INSERT INTO mbs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Penga niyan, minikagi se anghil, “Kadas kaw den. Ikà niyo eglengag. Ikà niyo egsagked dini te baog. Meneng kadas kaw den doton te menge bontod amon eked kaw kegelà.” ");
INSERT INTO mbs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Meneng minikagi si Lot, “Sir, eked a. ");
INSERT INTO mbs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Pengkey ontò mèpiya se tabang niyo kanak, aw impelowà a niyo lekat te kededàtan, meneng kesàban a den te peg-igelà, aw matay a te eked a pa dateng doton te bontod. ");
INSERT INTO mbs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Na, doen lonsod sida mebatog ko epetan so medapag iyan, aw deitek iyan ogpeanan. Pekedasi a bag doton. Ontò iyan deitek ogpeanan. Eked a kematay kidoen.” ");
INSERT INTO mbs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Timaba se anghil, “Mepakay iyan. Mepakay diyà kanak se pinemoyò nikaw. Eked a pegbaet te lonsod sida. ");
INSERT INTO mbs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Meneng kegaen kaw den kadas, so wedad meinang ko singed aw domateng kaw doton.” Iningedanan se lonsod sìyan Soar (kelebadan niyan, deitek), so minikagi si Lot te deitek iyan. ");
INSERT INTO mbs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Pegdateng i Lot doton te Soar, limibtak den se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tigkan indagdag te Timanem se esopri limegdeg lekat te langit doton te lonsod te Sodoma aw Gomora. ");
INSERT INTO mbs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Pineokit kenyan, nebàtan se dowa lonsod sìyan aw kedita te doma ogpeanan kidoen te baog sìyan. Negelà se kedita te otaw mig-ogpà kidoen, aw nebàtan se kedita te tinemunun kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Meneng limingì se esawa i Lot te lonsod tinenanan dan, aw yan nebaloy sikandin asin. ");
INSERT INTO mbs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Pegkeiselem niyan, limapos si Abraham doton te pemebongan pinemoyoan din diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Migpeatap-atap sikandin doton te Sodoma aw Gomora, aw doton te kebelad te baog sìyan, aw kinità din se ebel minolbo lekat te tanà, iling te ebel te dakel pogon. ");
INSERT INTO mbs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Meneng pegbaet te Timanem te menge lonsod kidoen te baog sìyan inogpaan i Lot, mig-aneng-aneng se Timanem tepad ki Abraham, aw yan impelowà din si Lot amon eked sikandin kegelà sipat te menge doma otaw. ");
INSERT INTO mbs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nayan, so nelemitan si Lot meg-ogpà doton te Soar, minalin sikandin sipat te didowa batà din bayi doton te bontod, aw mig-ogpà dan doton te ilib. ");
INSERT INTO mbs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Doen aldaw minikagi se batà din kakay diyà te adi din, “Migketemoay den se amay ta, aw wedad palos meama dini te keneyonan mengognan kenita amon megbatà ki. ");
INSERT INTO mbs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Na, mèpiya aw lesingen ta sikandin, aw yan lomayok ki diyà kandin amon megbatà ki pineokit kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Pegkedelem niyan, linasing dan se amay dan, aw limayok se kakay diyà kandin. Meneng wedà peg-aneng-aneng si Lot kenyan, so ontò sikandin nelasing. ");
INSERT INTO mbs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pegkeiselem niyan, minikagi se kakay diyà te adi din, “Siak se limayok diyà ki Amà tidelem. Na, mèpiya aw todà ta sikandin lesingen kwani delem, aw sikona se lomayok diyà kandin amon didowa ki se megbatà pineokit kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pegkedelem niyan, linasing dan heman se amay dan, aw limayok se adi diyà kandin. Wedà heman sikandin peg-aneng-aneng kenyan, so ontò sikandin nelasing. ");
INSERT INTO mbs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Yan miglaman se didowa batà i Lot pineokit kandin. ");
INSERT INTO mbs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Doen batà meama timebaw diyà te kakay, aw iningedanan din ki Moab (kelebadan niyan, lekat te amay). Neinang sikandin kemonaan te kedita te otaw diyà te pongan te Moab songkani. ");
INSERT INTO mbs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Doen heman batà meama timebaw diyà te adi, aw iningedanan din ki Ben-ami (kelebadan niyan, batà te kemonaan). Neinang sikandin kemonaan te kedita te otaw diyà te pongan te Amoni songkani. ");
INSERT INTO mbs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nayan, minalin si Abraham lekat te Mamre doton te Negeb, aw mig-ogpà dan doton te tengà-tengà te lonsod te Cades aw Sur. Peglegeb din doton te lonsod te Gerara, ");
INSERT INTO mbs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","minikagi si Abraham diyà te menge tege Gerara te etebay din se esawa din si Sara. Yan se doun te impeangay si Sara te selotan te Gerara si Abimelec amon inangen din esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Meneng migpekità se Timanem diyà ki Abimelec pineokit te tegeinep, aw minikagi sikandin, “Matay ka den tandà te pegpengabat no te bayi sìyan, so tapay doen esawa din.” ");
INSERT INTO mbs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Meneng so wedà pa pegpedapag si Abimelec diyà ki Sara, minikagi sikandin diyà te Timanem, “Wedad palos salà ko diyà kandin. Eked kepakay aw imetayan a no sipat te menge sakop ko. ");
INSERT INTO mbs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Si Abraham se minikagi diyà kanak te etebay din sikandin, aw minikagi heman se bayi te telekedowa dan. Pegpengabat ko kandin, wedad palos medaet ibeg te pedowan ko, aw wedad palos salà ininang ko.” ");
INSERT INTO mbs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Minikagi se Timanem diyà kandin pineokit te tegeinep, “Ee. Netegahan ko te wedad medaet ibeg te pedowan no te peg-inang no kenyan, aw yan se doun te migsagda a kamno amon eked ka peg-inang te salà diyà kanak. Binelebagan ko se pegpedapag no diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nayan, olii se bayi diyà te esawa din. Si Abraham se telekeliwat te kagi ko, aw megtawal-tawal sikandin tepad kamno amon eked ka kematay. Meneng aw eked no sikandin olii, metoman ka matay sipat te kedita te sakop nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Pegkeiselem niyan, limapos si Abimelec migtipon te kedita te opisyal din, aw mig-indan sikandin diyà kandan tepad te kedita neinang. Yan ontò dan migpeso. ");
INSERT INTO mbs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Penga niyan, impeangay i Abimelec si Abraham, aw minikagi sikandin, “Medaet se peg-akal no kenami. Eden lay se salà ininang ko diyà kamno amon ipedateng no se kededàtan diyà kanak aw menge sakop ko? Ininang no den diyà kanak se eked kepakay inangen. ");
INSERT INTO mbs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nengà lay ininang no ini?” ");
INSERT INTO mbs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Timaba si Abraham, “Mig-aneng-aneng a te wedad otaw dini egsagman te Timanem, aw yan doen otaw mengimatay kanak amon egawen dan se esawa ko. ");
INSERT INTO mbs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Benal se inikagi ko te etebay ko sikandin, so batà te amay ko sikandin, meneng sebad se inay din, aw yan pinengognan ko sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kedengan te pegpekesayo te Timanem kanak lekat te lonsod inogpaan te amay ko, minikagi a diyà te esawa ko aw ontò a din egkeidowan, yan keilangan mikagi sikandin diyà te kedita te otaw te telekedowa kay.” ");
INSERT INTO mbs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Penga niyan, in-olì i Abimelec si Sara diyà ki Abraham. Doen heman imbegay din diyà kandin, menge karniro, baka, aw allang. ");
INSERT INTO mbs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Minikagi heman si Abimelec, “Tengteng ka den diyà te kebelad te tanà ko. Pemellii se ibeg nikaw ogpaan pengkey kenan.” ");
INSERT INTO mbs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Minikagi heman sikandin diyà ki Sara, “Sebad melalan se kwarta plata imbegay ko den diyà te kedowa nikaw. Yan se pengilala amon metaga-taga se kedita te sakop no te wedad salà ko diyà kamno, aw ontò ka den neosayan.” ");
INSERT INTO mbs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Penga niyan, migtawal-tawal si Abraham diyà te Timanem, aw pinegolì te Timanem si Abimelec, aw esawa din, aw menge allang din bayi amon todà dan megbatà. ");
INSERT INTO mbs_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Pinegolì dan te Timanem, so doen tapay ininang din diyà kandan amon eked dan peglaman tandà te pegpengabat i Abimelec te esawa i Abraham si Sara. ");
INSERT INTO mbs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nayan, tinoman te Timanem se impakang din, aw mèpiya se imbegay din diyà ki Sara. ");
INSERT INTO mbs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Miglaman sikandin, aw tinebawan sikandin te batà meama i Abraham, pengkey temoay den sikandin. Timebaw se batà te aldaw tapay impakang te Timanem tepad kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iningedanan i Abraham se batà din ki Isaac (kelebadan niyan, nebebayat). ");
INSERT INTO mbs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pegdateng te ikewalo te aldaw lekat te pegtebaw i Isaac, tinolì sikandin i Abraham iling te impunù te Timanem kandin. ");
INSERT INTO mbs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sebad gatos se omay i Abraham te pegtebaw i Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Minikagi si Sara, “Binegayan a den te Timanem te keluba, aw yan egkebebayat a den. Mebebayat heman se kedita te otaw domineg tepad kani tandà te keluba dan.” ");
INSERT INTO mbs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Minikagi heman sikandin, “Kedengan, wedad palos otaw mekeikagi diyà ki Abraham te doen aldaw megpesoso a te batà. Meneng tinebawan a den beling te batà din, pengkey temoay den sikandin.” ");
INSERT INTO mbs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Timilles si Isaac, aw biningà sikandin. Dakel se kànen ininang i Abraham te aldaw te pegbingà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Meneng se batà i Abraham si Ismael timebaw diyà ki Agar tege Ehipto, yan se gayed migbidò te batà i Sara si Isaac. Pegkità i Sara kenyan, ");
INSERT INTO mbs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","minikagi sikandin diyà ki Abraham, “Pekeseyowi se allang sìyan sipat te batà din, so eked kepakay aw kebegayan se batà te allang te ketengà te keyemanan nikaw aw matay ka, so keilangan ibegay se kedakel niyan diyà te batà ko si Isaac.” ");
INSERT INTO mbs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ontò nepuluk se pedowan i Abraham tepad kenyan, so batà din heman si Ismael. ");
INSERT INTO mbs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Meneng minikagi se Timanem diyà ki Abraham, “Ikà egkepuluk tepad te telaki aw allang no si Agar. Tolò ka te impunù i Sara kamno, so se menge bowad-bowad te batà no si Isaac, yan olò se eneng-enengen ko te ontò bowad-bowad nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Inangen ko heman dakel pongan se menge bowad-bowad te batà te allang, so batà no heman sikandin.” ");
INSERT INTO mbs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Pegkeiselem niyan, limapos si Abraham nemegay te kànen aw sesalok nepenò te wayeg diyà ki Agar amon bebaen din, aw impekesayo din si Agar aw batà din. Dimoton dan te kebigtilan te Berseba, aw miglegeb-legeb dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Pegkeamin te wayeg inibing dan, timanan si Agar te batà din doton te pinonoan te kayo mebabà. ");
INSERT INTO mbs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Minalin sikandin te menge sebad pawà lekat te batà din aw nenenoo kidoen. Mig-aneng-aneng sikandin, “Eked a keibeg komità te pegkematay te batà ko.” Dalem te pegpenenoo din kidoen, migkelag sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dinineg te Timanem se pegkelag te batà, aw minikagi se anghil te Timanem lekat te langit, “E Agar, nengà lay migkelag ka? Ikà egkelemitan. Dinineg te Timanem se pegkelag te batà no doton sida. ");
INSERT INTO mbs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Enaw ka den, aw doton ka te batà nikaw, aw sinelayi sikandin, so inangen ko dakel pongan se menge bowad-bowad din.” ");
INSERT INTO mbs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Penga niyan, impekità te Timanem se sokian diyà ki Agar. Yan dimoton sikandin, aw inipenò din se sesalok, aw impeinem din se batà din. ");
INSERT INTO mbs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mèpiya se imbegay te Timanem diyà te telaki sìyan. Pegtilles din, mig-ogpà sikandin doton te kebigtilan, aw ontò sikandin metomawan egpemanà. ");
INSERT INTO mbs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Peg-ogpà din doton te kebigtilan te Paran, impepengognan sikandin te inay din diyà te bayi tege Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nayan, migpetaking si Abimelec te pengolo te menge sondalo din si Picol, aw dimoton dan ki Abraham. Minikagi si Abimelec, “Netegahan ko te gayed ka egtebangan te Timanem, pengkey eden se inangen nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Yan ibeg ko megsapà ka den diyà te Timanem te eked ka palos peg-akal kanak, menge batà ko, aw menge bowad-bowad ko. Gayed mèpiya se ininang ko diyà kamno, aw yan pegpakang ka den te gayed mèpiya se inangen no diyà kanak aw menge doma otaw eg-ogpà dini te tanà inogpaan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Minikagi si Abraham, “Yan se ipakang ko den diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Penga niyan, mig-indan si Abraham kandin te doen sokian pig-agaw te menge sineligan i Abimelec. ");
INSERT INTO mbs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Meneng minikagi si Abimelec, “Wedà ko ketegahi aw sinu se mig-agaw kenyan. Wedà a no indani, aw wedà ko iyan ketegahi lamig seini.” ");
INSERT INTO mbs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Penga niyan, nemegay si Abraham te menge karniro aw baka diyà ki Abimelec, aw migpepekangay dan. ");
INSERT INTO mbs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Meneng tinani i Abraham se pito nati bayi te karniro diyà te menge doma karniro din. ");
INSERT INTO mbs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Mig-insà si Abimelec, “Nengà lay tinani no iyan?” ");
INSERT INTO mbs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Timaba si Abraham, “Kinewai se pito nati te karniro seini, aw yan doen pengilala te siak se migpebangbang te sokian seini.” ");
INSERT INTO mbs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yan se doun te iningedanan se ogpeanan sìyan Berseba (kelebadan niyan, sokian te pakang), so migpepekangay dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Penga te pegpepekangay dan kidoen te Berseba, minolì si Abimelec aw si Picol doton te tanà te menge tege Filisti. ");
INSERT INTO mbs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Penga niyan, nenanem si Abraham te kayo tamarisko doton te Berseba, aw migtawal-tawal sikandin diyà te Timanem wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nenamay mig-ogpà si Abraham doton te tanà te menge tege Filisti. ");
INSERT INTO mbs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Pegkenamay-namay, migtandà se Timanem te pegsalig i Abraham diyà kandin. Timawal se Timanem, “E Abraham.” Timaba si Abraham, “Seini a.” ");
INSERT INTO mbs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Minikagi se Timanem, “Petekingi se batà no temisa si Isaac ontò no egkedekelan te pedowan, aw doton kaw te tanà te Moria. Tikedeg kaw te bontod tedoan ko kamno kidoen, aw imetayi sikandin aw sonogi se lawa din, so ibegay no sikandin diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Pegkeiselem niyan, limapos si Abraham nengayo, aw inlolan din iyan diyà te asno din. Impetaking din se batà din si Isaac aw dowa sineligan din, aw nesayo dan pesalo doton te tanà sinogoan te Timanem kandin. ");
INSERT INTO mbs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pegdateng te iketelo te aldaw te peg-ipanaw dan, kinità i Abraham se bontod doton te mediyò-diyò. ");
INSERT INTO mbs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Minikagi si Abraham diyà te didowa sineligan din, “Peg-ogpà kaw dini sipat te asno, so domeleg kay pa te batà ko doton sida amon megtawal-tawal kay diyà te Timanem. Penga niyan, lomikò kay dini kenyo.” ");
INSERT INTO mbs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Impeibing i Abraham ki Isaac se kayo itabon, aw inibing i Abraham se pemala aw tigtig bato iantay te apoy. Peg-ipanaw dan, ");
INSERT INTO mbs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","minikagi si Isaac, “Amà.” Timaba si Abraham, “Eden lay, Atò?” Minikagi si Isaac, “Doen tigtig bato aw itabon ta. Meneng kenan lay se nati te karniro sonogen aw ibegay diyà te Timanem?” ");
INSERT INTO mbs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Timaba si Abraham, “Timanem se memegay kenyan diyà kenita.” Penga niyan, dimeleg dan minipanaw. ");
INSERT INTO mbs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pegdateng dan doton te bontod sinogoan te Timanem ki Abraham, mig-inang si Abraham te sonogan din te ayam-ayam ibegay diyà te Timanem, aw insawol din se kayo itabon kidoen te lanto niyan. Penga niyan, ginapos din se batà din aw insawol din heman sikandin diyà te lanto te kayo itabon. ");
INSERT INTO mbs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Penga niyan, nemaed sikandin te pemala amon mengimatay te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Meneng timawal se anghil te Timanem diyà kandin lekat te langit, “E Abraham, Abraham.” Timaba sikandin, “Seini a.” ");
INSERT INTO mbs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Minikagi se anghil, “Ikà egmeno te batà nikaw. Ikà egpeeleg kandin. Netegahan ko den te ontò ka egtolò te Timanem, so pengkey batà no temisa, meneng yan se ibegay no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Penga niyan, doen karniro kinità i Abraham. Nekesaeng se seka din te sagbet. Inangay iyan i Abraham, aw inimetayan din aw sinonog din iyan inselilin te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Penga niyan, iningedanan i Abraham se bontod sìyan “Timanem se Egpemegay.” Pengkey songkani, doen eg-ikegiyen seini, “Doton te bontod te Timanem, Timanem se egpemegay.” ");
INSERT INTO mbs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Todà timawal se anghil te Timanem diyà ki Abraham lekat te langit, ");
INSERT INTO mbs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","aw minikagi sikandin, “Ontò metoman se pakang ko seini, so siaken se Timanem minikagi diyà kamno. Ontò mèpiya se ibegay ko diyà kamno. So timolò ka kanak aw wedà no temengi se batà no temisa meneng imbegay no sikandin diyà kanak, ");
INSERT INTO mbs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","yan mèpiya se ibegay ko diyà kamno, so inangen ko ontò medita se bowad-bowad nikaw iling te kedita te menge bitoen doton te langit, aw iling heman te kedita te enay doton te dagat. Mekedaeg se menge bowad-bowad no te menge lonsod te poon dan. ");
INSERT INTO mbs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tebangan ko se kedita te otaw te keneyonan pineokit te bowad-bowad nikaw. Yan se inangen ko, so timolò ka te impunù ko kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Penga niyan, limikò si Abraham aw si Isaac doton te didowa sineligan, aw minolì dan doton te Berseba, aw mig-ogpà dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nayan, pegkenamay-namay, inindanan si Abraham te doen den menge batà te kedowa din si Nahor, so tinebawan se nayi din si Melca. ");
INSERT INTO mbs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Si Hus se penganay batà din, si Bus se inolid din, si Camuel amay i Aram, ");
INSERT INTO mbs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Cased, si Asau, si Feldas, si Jedaf, aw si Betuel. ");
INSERT INTO mbs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Si Betuel se amay i Rebecca.) Yan se ngadan te walo batà i Nahor timebaw diyà ki Melca nayi i Abraham. ");
INSERT INTO mbs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Doen heman allang i Nahor pig-esawa din ngadan din si Roma tinebawan i Teba, si Gaam, si Taas, aw si Maaca. ");
INSERT INTO mbs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nematay si Sara te sebad gatos kelowan teg pito se omay din. ");
INSERT INTO mbs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nematay sikandin doton te lonsod te Hebron sakop te Canaan. Dimoton si Abraham amon moloy kandin. ");
INSERT INTO mbs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Timanan si Abraham te lawa te esawa din, aw dimoton sikandin te menge tege Heti, aw minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kenà a tege dini, so minalin a dini kenyo. Beyadan ko peden kenyo se tanà dini amon doen lebengan ko te esawa ko nematay.” ");
INSERT INTO mbs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Minikagi se menge tege Heti, ");
INSERT INTO mbs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, penenalan ka den kenami. Netegahan day te dakel ka otaw pinemallì te Timanem. Mepakay diyà kenami aw ilebeng no se esawa no dini te ontò mèpiya lebenganan day. Pengkey eden lebengi se pemellien nikaw, meluba se tig-apò memegay kenyan diyà kamno amon doen lebengan no kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Penga niyan, limongken si Abraham diyà kandan, ");
INSERT INTO mbs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","aw minikagi sikandin, “Aw mepakay diyà kenyo se peglebeng ko te esawa ko dini, pemoyoi niyo si Efron batà i Sohar ");
INSERT INTO mbs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","amon ibeligyà din diyà kanak se ilib te Macpela doton medapag te kilid te pawà din. Ikegihi niyo diyà kandin te pengkey pila se ontò elagà niyan, beyadan ko iyan diyà kandin dini kenyo, amon doen kenaken lebenganan.” ");
INSERT INTO mbs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kidoen heman si Efron doma te menge tege Heti netipon kidoen te lelebangan te lonsod sìyan, aw dinineg te kedita dan se intaba din diyà ki Abraham, ");
INSERT INTO mbs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Sir, penenalan ka den kanak. Tiblug ko ibowang diyà kamno se kedakel te pawà ko sìyan sipat te ilib kidoen. Dalem te pegbantay te kedita te doma ko, ibowang ko den iyan diyà kamno amon lebengan no te esawa nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Todà limongken si Abraham diyà te menge otaw kidoen, ");
INSERT INTO mbs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","aw minikagi sikandin diyà ki Efron dinineg te kedita dan, “Penenalan ka den te kagi ko seini. Beyadan ko den se pawà no sìyan te kedakel te elagà niyan. Kinewai se ibayad ko, amon doen lebengan ko te esawa ko.” ");
INSERT INTO mbs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Minikagi si Efron, ");
INSERT INTO mbs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, penenalan ka den kanak. Epat gatos te kwarta selapì se elagà niyan, meneng eked ko iyan pebeyadi kamno so sigalak ki. Tiblug ka den peglebeng te esawa no kidoen.” ");
INSERT INTO mbs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Timandù si Abraham tepad te elagà inikagi i Efron dinineg te kedita te otaw netipon, aw yan pinisar din se epat gatos kwarta selapì, iling te pegpisar te menge tindiro, aw imbegay din iyan diyà ki Efron. ");
INSERT INTO mbs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Pineokit kenyan, nenig-apò si Abraham te tanà i Efron doton te Macpela medapag te lonsod te Mamre. Bineyadan din se tanà sìyan sipat te ilib kidoen, aw kedita te kayo nesakop te tanà sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Neinang si Abraham tig-apò te tanà sìyan dalem te pegbantay te kedita te tege Heti netipon kidoen te lelebangan te lonsod sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Penga niyan, inlebeng i Abraham se lawa te esawa din si Sara doton te ilib kidoen te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Yan se indan tepad te pegpenig-apò i Abraham te tanà aw ilib ininang din lebenganan tapay tinig-apò te tege Heti. ");
INSERT INTO mbs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nayan, ontò den temoay si Abraham, aw gayed mèpiya se imbegay te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Minikagi si Abraham diyà te pengolo te menge sineligan din, sìyan egpengibing te kedakel te kedònan din, “Soli se belad nikaw diyà te salad te bobon ko amon ketegahan ko te tomanen no se ipunù ko kamno seini. ");
INSERT INTO mbs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ibeg ko megsapà ka pineokit te Timanem mig-inang te langit aw keneyonan. Pegpakang ka diyà kanak te eked no pemellii se bayi pengognanen te batà ko lekat te menge otaw eg-ogpà dini te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Meneng keilangan lomikò ka doton te tanà tinebawan ko, aw pemellii se bayi lekat te menge kedomaan ko amon doen pengognanen te batà ko si Isaac.” ");
INSERT INTO mbs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Meneng mig-insà se sineligan, “Megmeno a aw eked keibeg se bayi tomaking kanak aw molì a dini? Ibingen ko lay se batà no doton te tanà tinikedowan nikaw?” ");
INSERT INTO mbs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Timaba si Abraham, “Ikà palos egpengibing te batà ko doton. ");
INSERT INTO mbs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kedengan, inikegiyan a te Timanem eg-ogpà doton te langit te keilangan mesayo a lekat te menge kedomaan te amay ko aw tanà tinebawan ko, aw ontò a din pinekangan te ibegay din se tanà seini diyà te menge bowad-bowad ko. Isogò te Timanem se anghil monà diyà kamno aw megtabang kamno amon mekeabat ka te bayi pengognanen te batà ko. ");
INSERT INTO mbs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Meneng aw eked keibeg se bayi tomaking kamno, yan wedad keilangan te pegtoman no te pakang no seini. Meneng ikà palos egpengibing te batà ko doton.” ");
INSERT INTO mbs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Penga niyan, insawol te sineligan se belad din diyà te salad te bobon te amo din si Abraham, aw migsapà sikandin te tomanen din se impunù i Abraham diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Penga niyan, nengabat se sineligan te sempolò kamilo te amo din, aw inlolan din se medita kemolò te mèpiya bowang ipeibing te amo din si Abraham. Nesayo sikandin aw dimoton te lonsod inogpaan te kedowa i Abraham si Nahor kidoen te Mesopotamya. ");
INSERT INTO mbs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pegdateng din doton, ontò den meapon, aw yan se oras te pegsalok te menge bayi. Minapit sikandin doton te sokian kidoen te lowà te lonsod, aw impeetod din se menge kamilo din kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Penga niyan, migtawal-tawal sikandin, “E Timanem egseligan te amo ko si Abraham, tebangi a den te aldaw seini amon metoman se pakang no diyà te amo ko si Abraham egkeidowan nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na, dini a den te sokian seini selokan kwani te menge laga eg-ogpà dini. ");
INSERT INTO mbs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mikagi a kwani diyà te sebad bayi, ‘Peinemi a bag diyà te tibod nikaw.’ Aw tomaba sikandin, ‘Inem ka, aw somalok a heman te wayeg inemen te menge kamilo nikaw,’ mèpiya aw sikandin se bayi pinemallì no pengognanen i Isaac. Aw meinang iyan, ketegahan ko te netoman den se pakang no diyà te amo ko.” ");
INSERT INTO mbs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Telobo pa sikandin migtawal-tawal, dimateng si Rebecca batà bayi i Betuel neniang te tibod. Kedowa i Abraham si Nahor se apò din meama, aw si Melca se apò din bayi. ");
INSERT INTO mbs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Laga pa si Rebecca, aw ontò mèpiya se bawa din. Wedà palos sikandin leyoki te meama. Dimoton sikandin te sokian, aw simalok, aw limikò sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mig-ayas se sineligan simongon kandin, aw minikagi sikandin, “Atà, peinemi a bag diyà te tibod nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Minikagi se laga, “Sir, inem ka den.” Ayas din insawol se tibod tiniang din, aw impeinem din sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Penga te peg-inem din, minikagi heman se laga, “Somalok a heman te wayeg inemen te menge kamilo nikaw lamig kebolongan se keleowan dan.” ");
INSERT INTO mbs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ayas din in-olà se wayeg doton te loboganan, aw kimagnan sikandin doton te sokian aw todà simalok lamig nebolongan se keleowan te kedita te kamilo din. ");
INSERT INTO mbs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Wedà ikagi se sineligan, meneng timengteng olò sikandin diyà te terbaho te laga amon metaga-taga sikandin aw tinoman te Timanem se tod din. ");
INSERT INTO mbs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pegkebolong te keleowan te menge kamilo din, inokal te sineligan se aritis bolawan meelagà, aw insawol din iyan diyà te idong te bayi, aw intaklay din heman se dowa dedakel taklay bolawan diyà te bebenayen din. ");
INSERT INTO mbs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mig-insà sikandin, “Sinu lay se amay nikaw? Doen lay keombaan doton te balay din, amon midegà a sipat te menge doma otaw timaking kanak?” ");
INSERT INTO mbs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Timaba se bayi, “Si Betuel se amay ko. Si Nahor se amay din aw si Melca se inay din.” ");
INSERT INTO mbs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Minikagi heman se bayi, “Dakel se legami ibatan te kamilo nikaw aw dakel heman se kànen dan doton kenami, aw doen heman keombaan niyo aw midegà kaw.” ");
INSERT INTO mbs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Penga niyan, limongken se sineligan, aw dimuyun sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Minikagi sikandin, “Iduyun se Timanem egseligan te amo ko, so keseligan sikandin, aw tinoman din se pakang din diyà te amo ko. Yan inelladan a din amon mekepantek a doton te balay te menge kedomaan te amo ko.” ");
INSERT INTO mbs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kimagnan se bayi minolì, aw mig-indan sikandin diyà te inay din aw menge kedomaan din tepad kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Doen kedowa meama i Rebecca ngadan din si Laban. Pegkità i Laban te aritis aw taklay te etebay din, aw pegdineg din te kagi te etebay din tepad te inikagi te otaw dimateng, ayas sikandin simongon kandin doton te sokian. Pegdateng i Laban doton te sokian, kidoen pa se sineligan i Abraham sipat te menge kamilo din. ");
INSERT INTO mbs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Minikagi si Laban, “Mèpiya se imbegay te Timanem diyà kamno. Taking ka den kanak doton te balay ko. Ikà eg-ogpà dini, so doen tambì impetagad ko den kamno, aw doen heman kelokob te menge kamilo nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Penga niyan, dimoton dan te balay, aw mig-awas dan te karga te menge kamilo, aw impekaen dan iyan. Inibing dan heman se wayeg ionaw te benis te sineligan i Abraham aw menge doma din. ");
INSERT INTO mbs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Peglamak dan te kànen, minikagi se sineligan, “Eked a kaen singed aw meg-indan a kenyo tepad te tod ko dini.” Minikagi si Laban, “Indani kay den.” ");
INSERT INTO mbs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Minikagi sikandin, “Siak se sineligan i Abraham. ");
INSERT INTO mbs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ontò mèpiya se imbegay te Timanem diyà te amo ko, aw migkeyaman den sikandin. Binegayan sikandin te Timanem te medita karniro, kambing, baka, selapì, bolawan, allang, kamilo, aw asno. ");
INSERT INTO mbs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Doen batà din meama timebaw diyà te esawa din si Sara te pegkelokes din. Batà din sìyan se binegayan i Abraham te kedakel te keyemanan din. ");
INSERT INTO mbs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Impesapà a te amo ko te tomanen ko se impunù din kanak. Minikagi sikandin, ‘Keilangan eked no pemellii se bayi pengognanen te batà ko lekat te menge otaw eg-ogpà doton te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Meneng keilangan lomikò ka doton te menge kedomaan ko, sìyan menge bowad-bowad te amay ko, aw pemellii se bayi doton kandan amon doen pengognanen te batà ko.’ ");
INSERT INTO mbs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Penga niyan, mig-insà a kandin, ‘Megmeno a aw eked keibeg se bayi tomaking kanak aw molì a?’ ");
INSERT INTO mbs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Timaba sikandin, ‘Doen anghil ipetaking kamno te Timanem gayed ko egtoloen, amon metoman se tod nikaw doton. Yan mekeabat ka te bayi pengognanen te batà ko doton te menge kedomaan ko, sìyan menge bowad-bowad te amay ko. ");
INSERT INTO mbs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Meneng aw domoton ka te menge kedomaan ko aw eked dan penenalan kamno, aw temengan dan se bayi, yan wedad keilangan te pegtoman no te pakang no sìyan.’ ");
INSERT INTO mbs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Nayan, pegdateng ko gina seini doton te sokian, migtawal-tawal a, ‘E Timanem egseligan te amo ko si Abraham, aw mepakay diyà kamno, tomani bag se tod ko dini. ");
INSERT INTO mbs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Na, dini a den te sokian seini. Aw domini se laga amon somalok, aw mikagi a diyà kandin, “Peinemi a bag diyà te tibod nikaw,” ");
INSERT INTO mbs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","aw tomaba sikandin, “Inem ka, aw somalok a heman te wayeg inemen te menge kamilo nikaw,” mèpiya aw sikandin se bayi pinemallì no Timanem, amon doen pengognanen te batà te amo ko.’ ");
INSERT INTO mbs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Telobo a pa migtawal-tawal, dimateng si Rebecca neniang te tibod din. Dimoton sikandin te sokian aw simalok, aw minikagi a diyà kandin, ‘Atà, peinemi a bag.’ ");
INSERT INTO mbs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ayas din insawol se tibod tiniang din, aw minikagi sikandin, ‘Inem ka den, aw somalok a heman te wayeg inemen te menge kamilo nikaw.’ “Yan mininem a, aw impeinem din heman se menge kamilo ko. ");
INSERT INTO mbs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mig-insà a diyà kandin aw sinu se amay din, aw minikagi sikandin, ‘Si Betuel se amay ko. Si Nahor se amay din, aw si Melca se inay din.’ “Penga niyan, insawol ko se aritis diyà te idong din, aw didowa taklay diyà te bebenayen din. ");
INSERT INTO mbs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Limongken a aw migsimba a diyà te Timanem. Induyun ko se Timanem egseligan te amo ko si Abraham, so inelladan a din amon mekepantek a dini mengabat te apò bayi te kedowa te amo ko pengognanen te batà din meama. ");
INSERT INTO mbs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nayan, aw keidowan niyo se amo ko aw mèpiya se inangen niyo diyà kandin, ikagi kaw den kenyan diyà kanak. Meneng aw kenà, ikagi kaw den heman kenyan diyà kanak, amon metaga-taga a aw eden se inangen ko.” ");
INSERT INTO mbs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Minikagi si Laban aw si Betuel, “Impetaga-taga den te Timanem se ibeg din. Eked day iyan todai. ");
INSERT INTO mbs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mepakay diyà kenami aw ibingen no si Rebecca amon pengognanen te batà te amo nikaw, iling te impetaga-taga den te Timanem kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pegdineg te sineligan i Abraham te inikagi dan sìyan, limongken sikandin aw induyun din se Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Penga niyan, inokal din se menge bowang, menge penenaktun, aw selapì aw bolawan, aw imbegay din iyan diyà ki Rebecca. Doen heman menge meelagà imbowang din diyà te kedowa din aw inay din. ");
INSERT INTO mbs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Penga niyan, kimaen sikandin sipat te menge doma otaw timaking kandin, aw minidegà dan kidoen. Pegkeiselem niyan, minikagi se sineligan, “Ibeg ko, mesayo kay den amon molì a doton te amo ko.” ");
INSERT INTO mbs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Meneng timaba se kedowa aw inay i Rebecca, “Mèpiya aw eked no pa sikandin ibingi singed aw menge sempolò pa se aldaw. Penga niyan, mepakay aw mesayo kaw.” ");
INSERT INTO mbs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Meneng minikagi sikandin, “Ikà niyo eg-anggà kenami, so tinoman den te Timanem se tod ko dini. Ibeg ko, mesayo kay den amon molì a doton te amo ko.” ");
INSERT INTO mbs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Minikagi dan, “Tewalen day si Rebecca, aw insaen day sikandin aw eden se ibeg din.” ");
INSERT INTO mbs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Penga niyan, tinawal dan si Rebecca, aw mig-insà dan diyà kandin, “Meibeg ka lay tomaking kandin seini?” Timaba sikandin, “Ee, tomaking a den kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Penga niyan, mepakay diyà kandan aw tomaking si Rebecca aw lokes tapay mig-ipat kandin. Impekesayo dan sipat te sineligan i Abraham aw menge doma din. ");
INSERT INTO mbs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Te wedà dan pa kesayo, nemoyò se menge kedomaan i Rebecca te mèpiya se ibegay te Timanem kandin. Minikagi dan, “Etebay day, ibeg day meinang ka peden kemonaan te minelalan bowad-bowad nikaw. Ibeg day, mekedaeg peden se menge bowad-bowad no te lonsod te kedita te poon dan.” ");
INSERT INTO mbs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Penga niyan, migtigmes si Rebecca aw menge doma bayi timaking kandin te karga ibingen dan, aw simakay dan te menge kamilo amon tomaking dan te sineligan i Abraham. Penga niyan, nesayo se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nayan, mig-ogpà si Isaac doton te Negeb. Kaling sikandin minolì lekat te kebigtilan te Beer Lahai Roi. ");
INSERT INTO mbs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pegkemeapon, dimoton sikandin te pawà din amon megtawal-tawal sikandin, aw kinità din te doen menge otaw dimateng diyà kandin simakay te menge kamilo. ");
INSERT INTO mbs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Pegkità i Rebecca kandin, kimahang sikandin lekat te kamilo ");
INSERT INTO mbs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","aw mig-insà sikandin diyà te sineligan, “Sinu lay se otaw doton te pawà sida simongon kenitadon?” Timaba sikandin, “Amo ko sikandin.” Penga niyan, sinempengan i Rebecca se bawa din amon segmanen din si Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Penga niyan, mig-indan se sineligan diyà ki Isaac tepad te kedita neinang diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inibing i Isaac si Rebecca doton didalem te tolda tapay inogpaan te inay din si Sara. Pinengognan din si Rebecca, aw ontò dakel se pedowan i Isaac diyà kandin. Yan nesinalay si Isaac tepad te pegkematay te inay din. ");
INSERT INTO mbs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nayan, todà nengognan si Abraham, aw si Ketura se ngadan te modi esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Se menge batà meama i Abraham timebaw diyà ki Ketura, yan si Simran, si Jocsan, si Medan, si Midian, si Isbac, aw si Sua. ");
INSERT INTO mbs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jocsan se amay i Seba aw si Dedan. Se menge bowad-bowad i Dedan, yan se neinang menge pongan te Asur, Letus, aw Leum. ");
INSERT INTO mbs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Se menge batà meama i Midian, yan si Epa, si Eper, si Hanoc, si Abida, aw si Eldaa. Menge bowad-bowad i Ketura se kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Si Isaac se binegayan i Abraham te kedakel te keyemanan din. ");
INSERT INTO mbs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Meneng te wedà pa kematay si Abraham, doen heman imbowang din diyà te menge batà te menge doma esawa din. Penga niyan, impekesayo din dan pesalo doton te eglibtakan te aldaw amon eked dan pegsamok te batà din si Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Sebad gatos kepitowan teg lima se omay i Abraham te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ontò sikandin temoay te pegkematay din aw mèpiya se peg-ogpà din, aw yan neketelokon sikandin te menge kemonaan din nematay. ");
INSERT INTO mbs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Inlebeng te batà din si Isaac aw si Ismael se lawa din diyà te ilib te Macpela kidoen te tanà lenged te eglibtakan te lonsod te Mamre tapay tinig-apò i Efron batà i Sohar tege Heti. ");
INSERT INTO mbs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yan se tanà tapay bineyadan i Abraham diyà te menge tege Heti. Yan se linebengan dan ki Abraham sipat te esawa din si Sara. ");
INSERT INTO mbs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Penga te pegkematay i Abraham, mèpiya se imbegay te Timanem diyà te batà din si Isaac, aw mig-ogpà sikandin doton medapag te Beer Lahai Roi. ");
INSERT INTO mbs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Seini se menge bowad-bowad i Ismael batà i Abraham timebaw diyà ki Agar tege Ehipto allang i Sara. ");
INSERT INTO mbs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Seini se ngadan te menge batà i Ismael egpetibos-tibosay dan lekat te penganay. Si Nebaiot se kakay, inolid din si Kedar, si Adbeel, si Mibsam, ");
INSERT INTO mbs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","si Misma, si Duma, si Masa, ");
INSERT INTO mbs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","si Hadad, si Tema, si Jetur, si Napis, aw si Kedema. ");
INSERT INTO mbs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Yan se menge batà i Ismael, aw neinang dan datò te sempolò teg dowa pongan. Yan heman se in-ingadan te menge lonsod aw ogpeanan dan. ");
INSERT INTO mbs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sebad gatos ketlowan teg pito se omay i Ismael te pegkematay din. ");
INSERT INTO mbs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Mig-ogpà se menge bowad-bowad i Ismael doton te tanà diyà te tengà-tengà te lonsod te Habila aw Sur lenged te eglibtakan te Ehipto pesalo te Asirya. Wedà dan peg-ogpà doma te menge doma bowad-bowad i Abraham. ");
INSERT INTO mbs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Seini se indan tepad te batà i Abraham si Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kepatan se omay i Isaac te pegpengognan din ki Rebecca batà i Betuel tege Aramea te Mesopotamya. Si Rebecca se etebay i Laban tege Aramea heman. ");
INSERT INTO mbs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nayan, wedad palos batà i Rebecca, aw yan migtawal-tawal si Isaac diyà te Timanem tepad kenyan. Nenenalan se Timanem te pinemoyò din, aw yan miglaman si Rebecca. ");
INSERT INTO mbs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Doen pingin diyà te belenakan din, aw iling te migbolaw dan te wedà dan pa tebaw. Minikagi si Rebecca, “Nengà lay neinang ini diyà kanak?” Penga niyan, mig-insà sikandin diyà te Timanem tepad kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Minikagi se Timanem, “Se pingin kidoen te belenakan nikaw, yan se meinang kemonaan te dowa pongan. Eked dan pegsebad. Meinang labi pa magsen se sebad pongan, aw meinang sineligan te batà no adi se kakay din.” ");
INSERT INTO mbs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Pegdateng te aldaw te pegtebaw, pingin se timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Melalag se tagnà timebaw, aw bolbolen se lawa din, aw yan iningedanan dan sikandin ki Esau (kelebadan niyan, bolbolen). ");
INSERT INTO mbs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pegtebaw te adi din, minawid sikandin te palo te kakay din, aw yan iningedanan dan sikandin ki Jacob (kelebadan niyan, nengawid te palo, aw doen heman kelebadan niyan, eg-akal). Keneman se omay i Isaac te pegtebaw te didowa dan. ");
INSERT INTO mbs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Pegketelaki te didowa dan, migketomawan si Esau aw gayed eglegeb doton te kebenesan. Meneng netelek si Jacob, aw gayed sikandin netingen medapag te tolda inogpaan dan. ");
INSERT INTO mbs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ontò dakel se pedowan i Isaac diyà ki Esau, so ibeg din egpengànen se menge menenanap te kebenesan egpenaen i Esau. Meneng ontò dakel beling se pedowan i Rebecca diyà ki Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Doen aldaw migpesebo si Jacob te sabaw te temboway melalag. Dimateng si Esau lekat te kebenesan, aw ontò sikandin binallos. ");
INSERT INTO mbs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Minikagi sikandin diyà ki Jacob, “Begayi a den te melalag sabaw sìyan, so ontò a binallos.” (Yan se doun te doen doma ngadan i Esau si Edom, kelebadan niyan, melalag.) ");
INSERT INTO mbs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Minikagi si Jacob, “Eked a pemegay kamno singed aw begayan a no te ontong kinewaen no aw matay se amay ta, so sikona se penganay batà din.” ");
INSERT INTO mbs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Minikagi si Esau, “Mepakay iyan diyà kanak. Pengkey penganay a, meneng wedad ontong ko kenyan aw matay a den tandà te ballos ko.” ");
INSERT INTO mbs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Minikagi si Jacob, “Eked a pemegay kamno singed aw onà ka megsapà.” Yan migsapà si Esau te ibegay din diyà ki Jacob se ontong ibegay te amay dan diyà te penganay batà din. ");
INSERT INTO mbs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Penga niyan, nemegay si Jacob diyà ki Esau te pan aw sabaw te temboway melalag. Kimaen si Esau aw mininem. Penga niyan, nesayo sikandin. Yan mig-aneng-aneng sikandin te wedad elagà te ontong ibegay te amay din diyà te penganay batà din. ");
INSERT INTO mbs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nayan, doen todà bitil doton te Canaan. Kenà iyan onawa te bitil neokitan i Abraham. Dimoton si Isaac te tanà i Abimelec, selotan te menge tege Filisti doton te lonsod te Gerara. ");
INSERT INTO mbs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yan se dinotonan din, so tapay migpekità se Timanem diyà ki Isaac, aw migpunù sikandin, “Ikà egdoton te Ehipto. Peg-ogpà ka doton te tanà tedoan ko kamno. ");
INSERT INTO mbs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Peg-ogpà ka dini, aw yan megtabang a kamno, aw mèpiya se ibegay ko diyà kamno. Ibegay ko se kedakel te tanà seini diyà kamno aw diyà te menge bowad-bowad nikaw, so tomanen ko se impakang ko diyà te amay no si Abraham. ");
INSERT INTO mbs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Inangen ko ontò medita se bowad-bowad nikaw, iling te kedita te menge bitoen doton te langit. Ibegay ko diyà kandan se kedakel te tanà seini. Mèpiya se ibegay ko diyà te kedita te otaw te keneyonan pineokit te bowad-bowad nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Inangen ko iyan so timolò si Abraham kanak. Timolò sikandin te kedita te impunù aw intoladà ko diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yan mig-ogpà si Isaac doton te Gerara. ");
INSERT INTO mbs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Peg-insà te menge meama kidoen tepad te esawa din, minikagi sikandin, “Etebay ko sikandin.” Wedà sikandin ikagi te teleesawa dan, so nelemitan sikandin. Mig-aneng-aneng sikandin te imetayan sikandin te menge meama kidoen amon egawen dan si Rebecca, so ontò mèpiya se bawa din. ");
INSERT INTO mbs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pegkenamay-namay te peg-ogpà i Isaac kidoen te Gerara, dimelowang si Abimelec selotan te menge tege Filisti, aw kinità din si Isaac aw si Rebecca migpekelesay. ");
INSERT INTO mbs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yan impeangay din si Isaac, aw minikagi sikandin, “Esawa no kedì sikandin. Nengà lay minikagi ka te telekedowa kaw?” Timaba sikandin, “So mig-aneng-aneng a te imetayan a aw mikagi a te esawa ko sikandin.” ");
INSERT INTO mbs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Minikagi si Abimelec, “Medaet se ininang no diyà kenami, so simpana leyokan te sakop ko se esawa nikaw, detengan kay te pelumun te Timanem pineokit kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Penga niyan, migpunù si Abimelec diyà te kedita te sakop din, “Aw doen otaw meg-inang te medaet diyà te otaw seini aw esawa din, yan se imetayan.” ");
INSERT INTO mbs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Te omay sìyan, nenanem si Isaac kidoen, aw minongo iyan te ginatos. Dakel se ginani din so mèpiya se imbegay te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Gayed nedogangan se keyemanan din lamig ontò sikandin migkeyaman. ");
INSERT INTO mbs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ontò medita se karniro din, baka, aw allang din, aw yan se doun te miningà se menge tege Filisti kandin. ");
INSERT INTO mbs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Yan se doun te binonbonan dan se kedita te sokian tapay binengbangan te menge sineligan te amay din si Abraham te wedà pa sikandin kematay. ");
INSERT INTO mbs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Penga niyan, minikagi si Abimelec diyà ki Isaac, “Kesayo ka den lekat dini kenami, so neinang ka den beling labi magsen diyà kenami.” ");
INSERT INTO mbs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yan nesayo si Isaac, aw minalin doton te baog te Gerara, aw mig-ogpà sikandin kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Todà din impebangbang se menge sokian tapay impebangbang te amay din, so binonbonan iyan te menge tege Filisti penga te pegkematay i Abraham. Iningedanan i Isaac se menge sokian onawa te in-ingadan te amay din kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nemangbang se menge sineligan i Isaac te kaling sokian doton te baog, aw doen wayeg niyan timebol. ");
INSERT INTO mbs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Meneng migpedindilay se menge telediyaga tege Gerara aw menge telediyaga i Isaac, aw minikagi se menge tege Gerara, “Kenami se wayeg sìyan.” Yan se doun te iningedanan i Isaac se sokian sìyan Esek (kelebadan niyan, dindil), so migpedindilay dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Penga niyan, nemangbang heman se menge sineligan din te doma sokian. Meneng migbolaw heman se tege Gerara tepad kenyan, aw yan iningedanan din se sokian sìyan Sitna (kelebadan niyan, keopal). ");
INSERT INTO mbs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Minalin sikandin lekat kidoen, aw migpebangbang sikandin te sokian doton. Wedad migbolaw tepad kenyan, aw yan iningedanan din iyan Rehobut (kelebadan niyan, keombaan), so minikagi sikandin, “Doen den keombaan imbegay te Timanem diyà kenitadon, aw mèpiya den se peg-ogpà tadon dini.” ");
INSERT INTO mbs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dimeleg si Isaac lekat kidoen aw dimoton sikandin te Berseba. ");
INSERT INTO mbs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pegkedelem niyan, migpekità se Timanem diyà kandin, aw minikagi sikandin, “Siaken se Timanem egseligan te amay no si Abraham. Ikà egkelemitan, so egdomaan ta. Mèpiya se ibegay ko diyà kamno, aw inangen ko ontò medita se bowad-bowad nikaw, so yan se impakang ko diyà ki Abraham gayed timolò kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Mig-inang si Isaac te sonoganan te ayam-ayam ibegay diyà te Timanem, aw migsimba sikandin te Timanem kidoen. Mig-ogpà si Isaac kidoen, aw nemangbang se menge sineligan din te sokian. ");
INSERT INTO mbs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nayan, limaoy si Abimelec ki Isaac. Dimateng sikandin lekat te Gerara sipat te teleglawong din si Ahusa aw pengolo te menge sondalo din si Picol. ");
INSERT INTO mbs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Minikagi si Isaac, “Kedengan neopal kaw diyà kanak, aw impekesayo a niyo. Yan nengà lay dimini kaw den kanak?” ");
INSERT INTO mbs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Timaba dan, “Dimini kay so netegahan day den te gayed ka egtebangan te Timanem. Yan mig-aneng-aneng kay te mèpiya aw megpesepaay kidon. Ibeg day megpakang ka diyà kenami ");
INSERT INTO mbs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","te eked ka pegpeeleg kenami, iling te wedà kay palos pegpeeleg kamno. Mèpiya se ininang day diyà kamno, aw melinaw se pedowan tadon te pegkesayo nikaw. Netegahan day den te mèpiya se ipegbegay te Timanem diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Impeinang i Isaac se dakel kànen, aw kimaen dan aw mininem dan. ");
INSERT INTO mbs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pegkeiselem niyan, migpesepaay dan. Penga niyan, impekesayo dan i Isaac te melinaw se pedowan te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Dalem te aldaw sìyan, dimateng se menge sineligan i Isaac, aw mig-indan dan diyà kandin tepad te sokian binengbangan dan. Minikagi dan, “Neapet day den se wayeg!” ");
INSERT INTO mbs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iningedanan i Isaac se sokian sìyan Seba, aw lamig songkani iningedanan se lonsod kidoen Berseba (kelebadan niyan, sokian te pakang). ");
INSERT INTO mbs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Peg-apet te kepatan se omay i Esau, pinengognan din si Judita batà i Beeri tege Heti. Pinengognan din heman si Basimat batà i Elon tege Heti heman. ");
INSERT INTO mbs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Medaet se peg-ogpà i Isaac aw si Rebecca tandà te eg-inangen te didowa ogangan dan sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nayan, migketemoay den si Isaac, aw wedà den kità. Impeangay din se penganay batà din si Esau, aw minikagi sikandin, “Atò.” Timaba si Esau, “Seini a, Amà.” ");
INSERT INTO mbs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Minikagi si Isaac, “Temoay a den, aw agpet a den matay. ");
INSERT INTO mbs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Na, ebati se kekamang nikaw, menge tonod aw bosog nikaw, aw doton ka te kebenesan amon megdansal ka. ");
INSERT INTO mbs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Peg-elomo ka te pengelapen mèpiya se nanam iling te egkeibegan ko amon kànen ko iyan. Penga niyan te eked a pa kematay, megtawal-tawal a amon mèpiya se ibegay te Timanem diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Dalem te peg-ikagi i Isaac diyà ki Esau, dinineg i Rebecca se kagi din. Pegkesayo i Esau amon megdansal, ");
INSERT INTO mbs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","minikagi si Rebecca diyà te batà din si Jacob, “Na, dinineg ko gina se inikagi te amay no diyà te kakay no si Esau. ");
INSERT INTO mbs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Minikagi sikandin, ‘Pegdansal ka aw peg-elomo ka te pengelapen mèpiya se nanam amon kànen ko, aw penga niyan te eked a pa kematay, megtawal-tawal a amon mèpiya se ibegay te Timanem diyà kamno.’ ");
INSERT INTO mbs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","“Na, Atò, penenalan ka den diyà kanak amon tomolò ka te ipunù ko den kamno seini. ");
INSERT INTO mbs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Doton ka den te menge ayam-ayam, aw ebati se dowa nati te kambing melambò, aw siak se meg-elomo te kànen din mèpiya se nanam iling te egkeibegan te amay nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Penga niyan, sikona se mengibing te kànen doton te amay no amon sikona beling se begayan te mèpiya aw megtawal-tawal sikandin te eked pa kematay.” ");
INSERT INTO mbs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Meneng minikagi si Jacob diyà te inay din, “Ontò bolbolen si Esau, meneng ontò a melenas. ");
INSERT INTO mbs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Megmeno a aw pemàdan a i Amà? Meg-aneng-aneng sikandin te meg-alo-alo a kandin, aw yan wedad ontong ko kandin, meneng detengan a beling te medaet pineokit kenyan.” ");
INSERT INTO mbs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Minikagi se inay din, “Atò, aw doen medaet domateng, siaken se detengan niyan. Tolò ka olò kanak. Engayi den se menge kambing.” ");
INSERT INTO mbs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yan inangay i Jacob se menge kambing aw in-ated din iyan doton te inay din. Mig-elomo sikandin te kànen mèpiya se nanam iling te egkeibegan i Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Penga niyan, inabat i Rebecca se mèpiya saol i Esau intagò kidoen te balay, aw impesaol din iyan ki Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Insawol din se kindal te kambing sipat bolbol niyan diyà te bebenayen aw lieg i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Imbegay din diyà ki Jacob se mèpiya kànen aw pan ininang din. ");
INSERT INTO mbs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Dimoton si Jacob te amay din, aw minikagi sikandin, “Amà.” Minikagi si Isaac, “Ee, Atò. Sinu ka lay?” ");
INSERT INTO mbs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Timaba si Jacob, “Siak se penganay batà no si Esau. Timolò a den te impunù no kanak. Enaw ka den, aw kaen ka den te pengelapen inibing ko, amon megtawal-tawal ka amon mèpiya se ibegay te Timanem diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Mig-insà si Isaac, “Atò, nengà lay wedà kenamay se pegdansal nikaw?” Timaba si Jacob, “Tinebangan a te Timanem egseligan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Penga niyan, minikagi si Isaac diyà ki Jacob, “Atò, pegpedapag ka diyà kanak amon pemàdan ta. Ontò ka lay batà ko si Esau?” ");
INSERT INTO mbs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Migpedapag si Jacob diyà te amay din, aw nemaed si Isaac kandin aw minikagi sikandin, “Iling te kagi i Jacob se kagi nikaw, meneng iling te bebenayen i Esau se bebenayen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wedà din kilelai si Jacob so bolbolen se bebenayen din iling te bebenayen i Esau. Yan se doun te timetoo si Isaac migpeketagad te pegtawal-tawal din tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mig-insà si Isaac, “Ontò ka lay batà ko si Esau?” Timaba si Jacob, “Ee.” ");
INSERT INTO mbs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Minikagi si Isaac, “Begayi a den te kànen. Penga te pegpengaen ko, megtawal-tawal a amon mèpiya se ibegay te Timanem diyà kamno.” Nemegay si Jacob kandin te kànen aw kimaen si Isaac. Inibing din heman se bino, aw mininem sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Penga niyan, minikagi si Isaac, “Diyà ka Atò, aw pengadek ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Dimoton si Jacob aw nengadek te amay din. Peg-adek i Isaac te penenaktun din, migtawal-tawal sikandin, “Mèpiya se nadeg te batà ko, iling te nadeg te tanà binegayan te Timanem te mèpiya. ");
INSERT INTO mbs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Begayan ka te Timanem te tanà melambò gayed egkeelem te namog, amon dakel se geniyen nikaw, aw amon dakel se bino inangen nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ibeg ko medita se pongan meinang sineligan nikaw, aw medita se otaw lomongken diyà kamno. Mengolo ka diyà te kedita te kedomaan nikaw, aw toloen ka te kedita te kedowa nikaw. Ipelumun te Timanem se kedita te otaw megtompuyus kamno, aw mèpiya se ibegay din diyà te kedita te otaw memegay te mèpiya diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Penga te pegtawal-tawal i Isaac tepad kandin, nesayo si Jacob, aw dimateng si Esau lekat te pegdansal din. ");
INSERT INTO mbs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mig-elomo heman sikandin te kànen mèpiya se nanam, aw inibing din iyan doton te amay din. Minikagi sikandin, “Amà, enaw ka den aw kaen ka den te pengelapen inibing ko, amon megtawal-tawal ka amon mèpiya se ibegay te Timanem diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mig-insà si Isaac, “Sinu ka lay?” Timaba sikandin, “Siaken se penganay batà no si Esau.” ");
INSERT INTO mbs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ontò tinegangtang si Isaac tandà te kepela din, aw mig-insà sikandin, “Aw sikona si Esau, sinu lay se nekeabat gina te pengelapen, aw nemekaen kanak? Te wedà ka pa dateng, kimaen a kenyan, aw migtawal-tawal a amon mèpiya se ibegay te Timanem diyà kandin, aw eked ko den iyan todai.” ");
INSERT INTO mbs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pegdineg i Esau te inikagi te amay din, ontò sikandin migkelag aw migkoliyà, aw minikagi sikandin, “Amà, pegtawal-tawal ka heman amon mèpiya se ibegay te Timanem diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Meneng minikagi si Isaac, “Neekalan a te adi nikaw, aw neabat din den se itawal-tawal ko peden tepad kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Minikagi si Esau, “Neketepad se ngadan din si Jacob (kelebadan niyan, eg-akal), so mekedowa den sikandin peg-akal diyà kanak. Kedengan nengagaw sikandin te ontong kinewaen te penganay batà no aw matay ka, aw nengagaw den heman sikandin te mèpiya ibegay peden te Timanem diyà kanak. Doen lay peden mèpiya wedà no pa pemoyoi ibegay te Timanem diyà kandin?” ");
INSERT INTO mbs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Timaba si Isaac, “Migtawal-tawal a amon meinang sikandin pengolo nikaw, aw meinang heman allang din se kedita te kedomaan din. Nemoyò a diyà te Timanem te dakel se geniyen din aw bino din. Atò, wedad den mèpiya pemoyoen ko ibegay te Timanem diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Minikagi si Esau, “Amà, wedad lay palos nesamà wedà no pemoyoi ibegay diyà kandin? Amà, pegtawal-tawal ka bag heman amon mèpiya se ibegay te Timanem diyà kanak.” Penga niyan, migkelag sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Minikagi si Isaac diyà kandin, “Meg-ogpà ka doton te tanà wedad kelambò aw eked elemi te namog. ");
INSERT INTO mbs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Keilangan mengabat ka te kelidoan pineokit te pegbolaw nikaw. Meinang ka allang te kedowa nikaw. Meneng aw eked no iyan keteyodi, mekelowà ka lekat te peglowan din.” ");
INSERT INTO mbs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Gayed nebensi si Esau ki Jacob so migtawal-tawal se amay dan amon si Jacob se begayan te Timanem te ontò mèpiya. Minikagi si Esau, “Eked den kenamay matay si Amà, aw penga niyan imetayan ko si Jacob.” ");
INSERT INTO mbs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pegketaga-taga i Rebecca tepad te inikagi i Esau, impeangay din si Jacob, aw minikagi sikandin, “Miglalang den ekon si Esau mengimatay kamno amon meabat se kebensi din. ");
INSERT INTO mbs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Na Atò, tolò ka den kanak. Kadas ka den, aw doton ka te meama ko si Laban kidoen te Haran. ");
INSERT INTO mbs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Làno-làno ka peg-ogpà doton lamig megkewedad se keopal te kedowa nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Aw kelibelan din se ininang no diyà kandin, ipeangay ta amon mekeolì ka dini. Keilangan komadas ka den, so eked a keibeg aw dowa kaw telekedowa se matay dalem te sebad se aldaw.” ");
INSERT INTO mbs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Minikagi heman si Rebecca diyà ki Isaac, “Ontò melima se peg-ogpà ko doma te menge ogangan ta tege Heti. Aw pengognanen i Jacob se tege Heti iling te didowa bayi pinengognan i Esau, labi pa mèpiya aw matay a.” ");
INSERT INTO mbs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yan impeangay i Isaac si Jacob, aw migtawal-tawal sikandin amon mèpiya se ibegay te Timanem diyà kandin. Penga niyan, migpunù sikandin diyà ki Jacob, “Ikà egpengognan te bayi dini tege Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Doton ka den beling te Mesopotamya kidoen te balay te apò no si Betuel. Mèpiya aw pengognanen no se batà te emayen no si Laban. ");
INSERT INTO mbs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ibeg ko, mèpiya se ibegay te Timanem diyà kamno, aw inangen din medita se bowad-bowad no lamig meinang ka kemonaan te medita pongan te otaw. ");
INSERT INTO mbs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ibeg ko, tomanen te Timanem se impakang din diyà ki Abraham amon tig-epoen no sipat te menge bowad-bowad no se tanà seini inogpaan tadon, sìyan tanà impakang din diyà ki Abraham.” ");
INSERT INTO mbs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Penga niyan, impekesayo i Isaac si Jacob, aw dimoton sikandin te Mesopotamya taman ki Laban batà i Betuel tege Aramea. Si Laban se meama i Rebecca, aw emayen sikandin i Jacob aw si Esau. ");
INSERT INTO mbs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nayan, netaga-taga si Esau te migtawal-tawal si Isaac amon mèpiya se ibegay te Timanem diyà ki Jacob, aw insogò din sikandin doton te Mesopotamya amon mengognan kidoen. Netaga-taga heman sikandin te pegtawal-tawal i Isaac tepad kandin, migpunù sikandin te eked din pengognani se bayi tege Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Netaga-taga heman sikandin te timolò si Jacob te amay aw inay din aw dimoton sikandin te Mesopotamya. ");
INSERT INTO mbs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pegketaga-taga i Esau te wedà keluba se amay din tepad te menge bayi tege Canaan, ");
INSERT INTO mbs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","dimoton sikandin te emayen din si Ismael batà i Abraham, aw pinengognan din se batà din si Mahalat adi i Nebaiot. ");
INSERT INTO mbs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nesayo si Jacob lekat te Berseba aw minipanaw sikandin migpesalo doton te Haran. ");
INSERT INTO mbs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Meneng pegsallep te aldaw, minidegà sikandin diyà te dalan. Minibat sikandin diyà te tanà amon tomedogi, aw bato se inolonan din. ");
INSERT INTO mbs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Migtegeinep sikandin. Kinità din se lelebangan impetindeg diyà te tanà aw minapet iyan te langit, aw medita se anghil egpenayit aw egtenà kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kinità din heman se Timanem timindeg kidoen, aw minikagi sikandin diyà ki Jacob, “Siak se Timanem gayed egseligan te apò no si Abraham, aw amay no si Isaac. Se tanà seini inibatan nikaw, yan se ibegay ko diyà kamno aw diyà te menge bowad-bowad nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Inangen ko medita se bowad-bowad nikaw igsà eked dan kebilang iling te menge napò te tanà. Meg-ogpà se menge bowad-bowad no doton te kebelad te tanà pengkey kenan nikaw kitai. Mèpiya se ibegay ko diyà te kedita te otaw dini te keneyonan pineokit kamno aw bowad-bowad nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na, domoma a kamno aw meg-ipat a kamno pengkey kenan ka pesalo. Siak se megpeolì kamno dini te tanà seini. Gayed a domoma kamno lamig tomanen ko se kedita te impakang ko diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Neloka si Jacob, aw minikagi sikandin, “Dini se Timanem te ogpeanan seini, meneng wedà a ketaga-taga kenyan.” ");
INSERT INTO mbs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Migpeso sikandin, aw minikagi, “Kelemitanan se ogpeanan seini. Balay ini te Timanem. Seini se tetakep te lelebangan te langit.” ");
INSERT INTO mbs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pegkeiselem niyan, inabat i Jacob se bato inolonan din, aw impetindeg din iyan amon inangen din iyan kekitaan. Penga niyan, tinoyongan din iyan te lana te olibo, so yan se pengilala te ininang din iyan simbahan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Iningedanan din se tanà sìyan Betel (kelebadan niyan, balay te Timanem). Meneng iningedanan Luz se lonsod kidoen kedengan. ");
INSERT INTO mbs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Penga niyan, migpakang si Jacob diyà te Timanem, kagi din, “Aw domoma ka kanak, aw meg-ipat ka kanak te peg-ipanaw ko, aw memegay ka te kànen aw penenaktun diyà kanak ");
INSERT INTO mbs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","lamig molì a doton te balay te amay ko, yan sikona Timanem se gayed ko seligan. ");
INSERT INTO mbs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Se bato seini impetindeg ko, yan se inangen ko simbahan kamno, aw ibegay ko heman diyà kamno se ikesempolò ketengà te keyemanan ibegay no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nayan, dimeleg si Jacob lamig dimateng sikandin doton te tanà inogpaan te menge otaw lenged te eglibtakan. ");
INSERT INTO mbs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Dimateng sikandin doton te balon te wayeg binengbangan kidoen mediyò te lonsod. Kinità din se telo ebong te menge karniro minibat medapag te balon. Netipon se karniro so eg-inem dan kidoen. Mebelad se bato insampeng diyà te balon sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Aw egketipon se kedita te karniro kidoen, egkeliden te menge telediyaga se bato lekat te awang te balon, aw egsalok dan te wayeg inemen te karniro. Penga niyan, todà dan iyan egsempengan te bato. ");
INSERT INTO mbs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Mig-insà si Jacob te menge telediyaga, “Elew, kenan kaw lay lekat?” Timaba dan, “Lekat kay te Haran.” ");
INSERT INTO mbs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Mig-insà si Jacob, “Kinilala niyo lay si Laban apò i Nahor?” Timaba dan, “Ee. Kinilala day sikandin.” ");
INSERT INTO mbs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Mig-insà heman si Jacob, “Mèpiya lay se pegkesawol din?” Timaba dan, “Mèpiya man. Na, doton sida se batà din bayi si Raquel nengibing te menge karniro din dini.” ");
INSERT INTO mbs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Minikagi si Jacob, “Melangkaw pa se aldaw. Wedà pa dateng se oras te pegpeawop te menge karniro doton te kelokob. Mèpiya aw ipeinem niyo dan aw todà niyo dan ipeloyaw.” ");
INSERT INTO mbs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Timaba dan, “Meneng eked day peinemi se menge karniro singed aw metipon se kedita dan. Penga niyan, mengelid kay te bato lekat te awang te balon, aw ipeinem day se menge karniro.” ");
INSERT INTO mbs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Telobo pa minikagi si Jacob diyà kandan, dimateng si Raquel nengibing te karniro te amay din, so sikandin se migdiyaga kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pegkità i Jacob ki Raquel nengibing te menge karniro te emayen din si Laban, dimoton sikandin te balon, aw nengelid sikandin te bato insampeng kenyan, aw simalok sikandin te wayeg inemen te karniro te emayen din. ");
INSERT INTO mbs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Penga niyan, nengadek si Jacob ki Raquel, aw migkelag sikandin tandà te keluba din. ");
INSERT INTO mbs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Minikagi sikandin diyà ki Raquel, “Anak a te amay nikaw, so etebay din si Rebecca se inay ko.” Penga niyan, kimagnan si Raquel minolì aw mig-indan sikandin te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pegketaga-taga i Laban te dimateng se anak din si Jacob, ayas sikandin simongon kandin. Kinelesan sikandin i Laban, aw inedekan din, aw inibing din doton te balay din. Pegdateng dan kidoen, mig-indan si Jacob diyà kandin tepad te kedita neinang diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Penga niyan, minikagi si Laban, “Ontò ka anak ko.” Penga niyan, mig-ogpà si Jacob kidoen te sebad se bolan. ");
INSERT INTO mbs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Nayan, minikagi si Laban diyà ki Jacob, “Pengkey anak ko sikona, meneng eked kepakay aw megterbaho ka diyà kanak aw wedad itandan ko kamno. Na, ikegihi a aw eden se itandan ko kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Dowa se batà laga i Laban. Si Lea se kakay, aw si Raquel se adi din. ");
INSERT INTO mbs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mèpiya tengtengen se mata i Lea, meneng ontò beling mèpiya se bawa i Raquel egtengtengen. ");
INSERT INTO mbs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ontò dakel se pedowan i Jacob diyà ki Raquel, aw yan minikagi sikandin, “Aw mepakay pengognanen ko si Raquel, megterbaho a dini kamno te pito se omay.” ");
INSERT INTO mbs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Minikagi si Laban, “Mèpiya aw sikona se ipepengognan ko diyà kandin, so sikona se labi mèpiya diyà te menge doma otaw mengognan peden kandin. Na, pegterbaho ka den diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Penga niyan, migterbaho si Jacob te pito se omay amon pengognanen din si Raquel, meneng diyà te aneng-aneng i Jacob, iling te pilabok olò se aldaw sìyan so dakel se pedowan din diyà ki Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Penga niyan, minikagi si Jacob diyà ki Laban, “Netagkas den se pito se omay. Peipidi den se batà no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Yan migpeinang si Laban te dakel kànen, aw impetanod din se kedita te otaw mig-ogpà kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Meneng pegkedelem niyan, si Lea beling se impeipid i Laban diyà ki Jacob, aw yan se lineyokan i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Imbegay i Laban se allang din bayi si Zilfa diyà ki Lea amon megtelaban kandin. ");
INSERT INTO mbs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pegkeiselem niyan, kinità i Jacob te si Lea se impeipid i Laban diyà kandin, aw yan mig-insà sikandin diyà ki Laban, “Nengà lay mig-inang ka te medaet diyà kanak? Si Raquel se impakang no diyà kanak tepad te terbaho ko. Nengà lay mig-akal ka kanak?” ");
INSERT INTO mbs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Timaba si Laban, “Doen ketanem day dini te eked kepakay aw ipepengognan se adi laga singed aw onà ipepengognan se kakay din laga. ");
INSERT INTO mbs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pegtagad ka den te sebad simana lamig mepenga se peipid no ki Lea. Penga niyan, aw megterbaho ka diyà kanak te pito mendad se omay, ibegay ko heman kamno se adi din si Raquel.” ");
INSERT INTO mbs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yan se ininang i Jacob. Penga te sebad simana te peipid sìyan, imbegay heman i Laban se batà din si Raquel diyà ki Jacob amon meinang heman esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Imbegay heman i Laban se allang din bayi si Bilha diyà ki Raquel amon megtelaban kandin. ");
INSERT INTO mbs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Limayok heman si Jacob diyà ki Raquel. Deitek se pedowan i Jacob diyà ki Lea, meneng dakel se pedowan din diyà ki Raquel. Penga niyan, migterbaho si Jacob diyà ki Laban te pito mendad se omay. ");
INSERT INTO mbs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Pegketaga-taga te Timanem te deitek se pedowan i Jacob diyà ki Lea, impebatà din si Lea. Meneng wedà beling peglaman si Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Miglaman si Lea aw tinebawan sikandin te batà meama. Iningedanan din se batà din ki Ruben (kelebadan niyan, kinità se kelimahan), so minikagi sikandin, “Kinità te Timanem se kelimahan ko. Kedekelan a den besi te esawa ko te pedowan.” ");
INSERT INTO mbs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Todà sikandin miglaman, aw tinebawan heman sikandin te batà meama. Minikagi sikandin, “Binegayan a heman te Timanem te batà seini, so dinineg din te deitek se pedowan te esawa ko diyà kanak.” Yan iningedanan din se batà din ki Simeon (kelebadan niyan, egdineg). ");
INSERT INTO mbs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Todà miglaman si Lea, aw tinebawan heman sikandin te batà meama. Penga niyan, minikagi sikandin, “Kedekelan a den besi te pedowan te esawa ko, so tinebawan a den te telo batà din meama.” Yan iningedanan din se batà din ki Levi (kelebadan niyan, kedekelan). ");
INSERT INTO mbs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Todà miglaman si Lea, aw tinebawan heman sikandin te batà meama. Penga niyan, minikagi sikandin, “Iduyun ko den se Timanem.” Yan iningedanan din se batà din ki Juda (kelebadan niyan, pegduyun). Penga niyan, wedà den sikandin todà pegbatà. ");
INSERT INTO mbs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Pegketaga-taga i Raquel te wedad batà timebaw diyà kandin, miningà sikandin te kakay din. Minikagi sikandin diyà ki Jacob, “Aw eked a no pebetai, matay a.” ");
INSERT INTO mbs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Neopal si Jacob diyà ki Raquel, aw minikagi sikandin, “Kenà a man Timanem! Sikandin se wedà pemebatà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Minikagi si Raquel, “Ibegay ko diyà kamno se allang ko si Bilha. Layok ka den diyà kandin amon doen peden batà tomebaw diyà kandin pegbetaen ko. Yan doen peden menge batà ko pineokit kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yan imbegay i Raquel se allang din si Bilha diyà ki Jacob amon inangen din esawa din. Pegpeleyokay dan, ");
INSERT INTO mbs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","miglaman si Bilha, aw tinebawan sikandin te batà meama. ");
INSERT INTO mbs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Penga niyan, minikagi si Raquel, “Impelangkaw a den te Timanem. Nenenalan sikandin te pinemoyò ko, aw binegayan a din te batà meama.” Yan se doun te iningedanan din se batà din ki Dan (kelebadan niyan, impelangkaw). ");
INSERT INTO mbs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Todà miglaman si Bilha aw tinebawan sikandin te ikedowa batà din meama. ");
INSERT INTO mbs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Minikagi si Raquel, “Kedengan dinaeg a te kakay ko, meneng songkani dinaeg ko heman sikandin.” Yan iningedanan din se batà din ki Neftali (kelebadan niyan, bolaw). ");
INSERT INTO mbs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Na, pegketaga-taga i Lea te wedà todà sikandin pegbatà, imbegay din heman se allang din si Zilfa diyà ki Jacob amon meinang heman sikandin esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Penga niyan, doen batà meama timebaw diyà ki Zilfa. ");
INSERT INTO mbs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Minikagi si Lea, “Neidowan a te Timanem!” Yan iningedanan din se batà din ki Gad (kelebadan niyan, neidowan). ");
INSERT INTO mbs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Doen ikedowa batà meama i Jacob timebaw diyà ki Zilfa. ");
INSERT INTO mbs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Minikagi si Lea, “Ontò neluba se pedowan ko! Mikagi se menge doma bayi te ontò a neluba.” Yan iningedanan din se batà din ki Aser (kelebadan niyan, keluba). ");
INSERT INTO mbs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Dalem te peglegani te trigo, dimoton si Ruben te pawà, aw neketalà sikandin te menge pongo te sagbet iningedanan mandragora egpengànen te bayi meibeg megbatà. Inibing din iyan doton te inay din si Lea. Minikagi si Raquel diyà ki Lea, “Begayi a heman te menge mandragora inibing te batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Minikagi si Lea, “Pengkey inagaw no se esawa ko, meneng kenà besi botong se medaet ininang no sìyan, so egawen no den heman se menge mandragora inibing te batà ko diyà kanak!” Minikagi si Raquel, “Aw ibegay no den diyà kanak se menge mandragora netelaan te batà nikaw, mepakay diyà kanak aw sikona se leyokan i Jacob kwani delem.” ");
INSERT INTO mbs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Peg-olì i Jacob lekat te pawà te meapon, simongon si Lea kandin, aw minikagi sikandin, “Keilangan lomayok ka diyà kanak kwani delem, so netelaan te batà ta se menge mandragora, aw yan se imbayad ko kamno diyà ki Raquel.” Yan se doun te si Lea se lineyokan i Jacob te delem sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nenenalan se Timanem te pinemoyò i Lea, aw yan miglaman sikandin, aw tinebawan te ikelima batà meama i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Minikagi si Lea, “Mèpiya se ontong imbegay te Timanem diyà kanak, so imbegay ko se allang ko diyà ki Jacob.” Yan iningedanan din se batà din ki Isacar (kelebadan niyan, ontong). ");
INSERT INTO mbs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Todà miglaman si Lea, aw tinebawan sikandin te ikeenem batà meama i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Minikagi si Lea, “Ontò meelagà se imbegay te Timanem diyà kanak. Na, segmanen a den besi te esawa ko, so enem den se batà din meama timebaw diyà kanak.” Yan iningedanan din se batà din ki Sabulon (kelebadan niyan, sagman). ");
INSERT INTO mbs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pegkenamay-namay, tinebawan si Lea te batà bayi, aw iningedanan din se batà din ki Dina. ");
INSERT INTO mbs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Wedà kelibeli te Timanem si Raquel, so nenenalan se Timanem te pinemoyò din, aw impebatà din sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Miglaman sikandin aw tinebawan heman te batà meama. Minikagi sikandin, “Inabat den te Timanem se nekeyàyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Iningedanan i Raquel se batà din ki Jose (kelebadan niyan, dogangan), so minikagi sikandin, “Ibeg ko begayan a pa te Timanem te doma batà meama.” ");
INSERT INTO mbs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Penga te pegtebaw i Jose, minikagi si Jacob diyà ki Laban, “Pekeseyowi a lekat dini amon mekeolì a doton te tanà tinebawan ko. ");
INSERT INTO mbs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ikà egtameng te menge esawa ko aw menge batà ko, so yan se ontong tepad te terbaho ko diyà kamno. Mesayo kay den. Netegahan no te mèpiya se terbaho ko diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Minikagi si Laban, “Aw doen keido no diyà kanak, peg-ogpà ka pa dini. Ikà egkesayo, so pineokit te pegpeneleseb ko, netegahan ko te mèpiya se imbegay te Timanem diyà kanak tandà te peg-ogpà no dini kanak. ");
INSERT INTO mbs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pengkey eden se ibeg no itandan ko diyà kamno, yan se ibegay ko diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Minikagi si Jacob, “Netegahan no te mèpiya se terbaho ko diyà kamno, aw mèpiya heman se pegbowad-bowad te menge ayam-ayam nikaw so siak se migtonggò kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kedengan te wedà a pa dateng dini, olò deitek se keyemanan nikaw. Meneng ontò ka den migkeyaman, so mèpiya se imbegay te Timanem diyà kamno pineokit te kedita te ininang ko. Meneng songkani, keilangan doen ontong te kenaken pamilya pineokit te inangen ko.” ");
INSERT INTO mbs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Mig-insà si Laban, “Eden lay se itandan ko diyà kamno?” Timaba si Jacob, “Wedad itandan no diyà kanak. Meneng aw meibeg ka te megtonggò a pa te kamno menge ayam-ayam, keilangan tomandù ka te sebad olò ikegiyen ko kamno seini. ");
INSERT INTO mbs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Te aldaw seini, tomeped a te kedita te ayam-ayam nikaw, aw ebaten ko se kedita te nati te karniro meitem aw kedita te nati te kambing boling. Taman iyan se ibegay no diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Te modi aldaw, ketegahan no aw keseligan a aw kenà, so aw tomengteng ka diyà te menge ayam-ayam imbegay no diyà kanak, aw kitaen no se kambing kidoen kenà boling, aw karniro kenà meitem, ketegahan no te tinakaw ko iyan.” ");
INSERT INTO mbs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Minikagi si Laban, “Ee. Tomanen ko kamno se inikagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Dalem te aldaw sìyan, inabat i Laban se kedita te kambing boling aw doen bolbol migsanged te mepotì pengkey meama aw bayi, aw kedita te karniro meitem, aw impetonggò din iyan te menge batà din meama. ");
INSERT INTO mbs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Inibing dan se menge ayam-ayam sìyan doton te mediyò tanà eked keapet singed aw mipanaw se otaw te telo se aldaw. Migtonggò si Jacob te menge ayam-ayam i Laban nesamà. ");
INSERT INTO mbs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Penga niyan, nengabat si Jacob te menge panga te kayo alamo, almendras, aw platano, aw pinelisan din iyan, meneng doen elet-elet wedà din pelisi amon doen batek niyan. ");
INSERT INTO mbs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Intollok din se menge panga sìyan medapag te loboganan te menge ayam-ayam amon kitaen dan iyan te peg-inem dan kidoen. Peg-inem te menge kambing, migpebelagay dan. ");
INSERT INTO mbs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Pegpebelagay dan doton medapag te panga binetekan, boling se menge pispis timebaw kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tinani i Jacob se menge karniro aw kambing, aw impeasdang din se menge karniro diyà te menge ayam-ayam i Laban boling aw meitem. Pineokit niyan, ininang din medita se kandin ayam-ayam, aw wedà din iyan peeyoni diyà te menge ayam-ayam i Laban. ");
INSERT INTO mbs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Pegpebelagay te menge ayam-ayam melambò, gayed migsawol si Jacob te menge panga binetekan doton medapag te loboganan, amon kitaen dan iyan te pegpebelagay dan. ");
INSERT INTO mbs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Meneng aw megasà se menge ayam-ayam, wedà din soli se menge panga binetekan. Wedà kenamay, si Laban se neketig-apò te kedita te ayam-ayam megasà, aw si Jacob se neketig-apò te kedita te melambò. ");
INSERT INTO mbs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Pineokit kenyan, ontò migkeyaman si Jacob. Medita se ayam-ayam, allang, kamilo, aw asno tinig-apò din. ");
INSERT INTO mbs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Dinineg i Jacob te migbelisì se menge bayaw din, sìyan menge batà i Laban. Minikagi dan, “Nengabat den si Jacob te kedakel te kedònan i Amà. Lekat ki Amà se kedakel te keyemanan i Jacob.” ");
INSERT INTO mbs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kinità heman i Jacob te deitek den se pedowan i Laban diyà kandin, so kenà den iling te kedakel te pedowan din kedengan. ");
INSERT INTO mbs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Minikagi se Timanem diyà ki Jacob, “Olì ka den doton te tanà inogpaan te amay nikaw, apò nikaw, aw menge kedomaan nikaw. Domaan ta sikona.” ");
INSERT INTO mbs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yan intogon i Jacob si Raquel aw si Lea te megkità dan kandin doton te tanà tinonggoan din te menge ayam-ayam. ");
INSERT INTO mbs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pegdateng dan doton, minikagi si Jacob, “Kinità ko te deitek den se pedowan te amay niyo diyà kanak, so kenà den iling te kedakel te pedowan din kedengan. Meneng gayed a egdomaan te Timanem egseligan te amay ko. ");
INSERT INTO mbs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Netegahan niyo te ontò a measeb te pegterbaho ko diyà te amay niyo. ");
INSERT INTO mbs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Meneng gayed a din beling inekalan, so mekesempolò din todai se pakang din tepad te itandan din diyà kanak. Meneng pineokit te tabang te Timanem kanak, wedà a din peelegi. ");
INSERT INTO mbs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Te kelikit te pegpakang te amay niyo diyà kanak, ‘Kedita te kambing boling se itandan ko diyà kamno,’ yan tomalag boling se timebaw. Aw te kelikit te pegpakang din diyà kanak, ‘Kedita te kambing beteken se itandan ko diyà kamno,’ yan tomalag beteken se timebaw. ");
INSERT INTO mbs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Pineokit kenyan, impelowà te Timanem se menge ayam-ayam lekat te belad te amay niyo, aw imbegay din iyan diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Kedengan dalem te pegpebelagay te kambing, migtegeinep a. Kinità ko te beteken aw boling se kedita te kambing meama migbalag. ");
INSERT INTO mbs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dalem te pegtegeinep ko, minikagi se anghil te Timanem diyà kanak, ‘E Jacob.’ Timaba a, ‘Seini a.’ ");
INSERT INTO mbs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Minikagi se anghil, ‘Tengtengi iyan. Beteken aw boling olò se kedita te kambing meama migbalag. Inangen ko medita se ayam-ayam nikaw, so kinità ko se kedita te medaet eg-inangen i Laban diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Siaken se Timanem migpekità diyà kamno kedengan kidoen te Betel. Kidoen ininang no kekitaan se bato tinoyongan no te lana, aw migpakang ka heman kanak. Na, kesayo ka den lekat te ogpeanan seini, aw olì ka den doton te tanà tinebawan nikaw.’” ");
INSERT INTO mbs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Minikagi si Raquel aw si Lea, “Wedad den palos nesamà ibegay diyà kenami aw matay se amay day. ");
INSERT INTO mbs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Eg-aneng-aneng den sikandin te iling kay te kenà batà din. Imbeligyà kay din iling te allang, aw neamin den se imbayad no diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Inabat te Timanem se kedakel te keyemanan te amay day, aw kenitadon den iyan sipat te menge batà tadon. Yan keilangan tomolò ka te kedita te impunù te Timanem diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Penga niyan, impesakay i Jacob se menge batà din aw menge esawa din diyà te menge kamilo. ");
INSERT INTO mbs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Impeipanaw din se kedita te ayam-ayam din doton te monà, aw inlolan din heman se kedakel te kedònan neabat din kidoen te Mesopotamya. Nesayo sikandin migpesalo doton te tanà te amay din si Isaac kidoen te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Pegkesayo dan, wedad kidoen si Laban, so dimoton sikandin te menge karniro din impeloyaw amon meglegonting kenyan. Nengabat si Raquel te menge inotaw lekat te balay te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Mig-akal si Jacob ki Laban, so wedà din sebihi tepad te pegkesayo din. ");
INSERT INTO mbs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inibing i Jacob se kedakel te kedònan din aw kimadas sikandin. Minatas dan te wayeg te Yofritis, aw migpesalo dan doton te bontod te Galaad. ");
INSERT INTO mbs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Penga te telo se aldaw, inindanan si Laban te kimadas si Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yan impetaking din se menge kedomaan din, aw mig-alaw dan kandin. Penga te pito se aldaw, nekesaeb dan kandin doton te bontod te Galaad. ");
INSERT INTO mbs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Te wedà dan pa pekesaeb kandin, migpekità se Timanem diyà ki Laban te delem pineokit te tegeinep, aw minikagi sikandin, “Peg-ahà ka. Ikà egleges ki Jacob.” ");
INSERT INTO mbs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mig-ogpà si Jacob doton te bontod te Galaad. Pegpekesaeb i Laban aw menge kedomaan din ki Jacob, mig-ogpà dan heman kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Minikagi si Laban diyà ki Jacob, “Medaet se ininang nikaw. Mig-akal ka kanak, aw inibing no se menge batà ko iling te otaw nedakep te mengengayaw. ");
INSERT INTO mbs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nengà lay mig-akal ka kanak? Nengà lay nesayo ka te wedà a no sebihi? Aw simabi ka peden kanak, yan mèpiya se pegpekesayo ko kamno, so mèpiya se keluba tadon, aw pegdelangan tadon, aw pegpedaging tadon te edel aw sista. ");
INSERT INTO mbs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wedà a no peedeki te menge apò ko aw batà ko te pegkesayo niyo. Medaet se ininang no sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Pengkey mebatog ko se pegpeeleg kamno, meneng tidelem pinunuan a te Timanem egseligan te amay no te eked kepakay aw megleges a kamno. ");
INSERT INTO mbs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Netegahan ko te nesayo ka den so ibeg no molì ka doton te amay nikaw. Meneng nengà lay tinakaw no se menge inotaw lekat te balay ko?” ");
INSERT INTO mbs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Timaba si Jacob, “Mig-akal a kamno so nelemitan a. Mig-aneng-aneng a te ewien no se menge esawa ko. ");
INSERT INTO mbs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Meneng aw kitaen no se otaw dini nenakaw te inotaw nikaw, imetayan ko sikandin. Na, megsistigos se menge kedomaan ta. Pemahà ka den. Aw doen kedònan no kitaen no dini, ebati iyan.” Yan se inikagi i Jacob so wedà din ketegahi te si Raquel se nengabat te menge inotaw i Laban. ");
INSERT INTO mbs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Penga niyan, nengemahà si Laban doton te tolda inogpaan i Jacob, aw tolda inogpaan i Lea, aw tolda te didowa allang bayi, meneng wedad palos kinità din kidoen. Penga niyan, minawop sikandin diyà te tolda inogpaan i Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tapay in-eles i Raquel se inotaw doton te siyà te kamilo din, aw nenenoo sikandin kidoen. Kinelokad i Laban se kedita te kedònan doton te tolda inogpaan din, meneng wedad palos kinità din. ");
INSERT INTO mbs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Minikagi si Raquel diyà te amay din, “Amà, ikà bag egkeopal diyà kanak, meneng eked a den peketindeg, so pigdònan a den.” Yan pengkey ontò kinelokad i Laban, meneng wedà din kitai se menge inotaw din. ");
INSERT INTO mbs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ontò neopal si Jacob, aw nenompelà sikandin ki Laban. Minikagi sikandin, “Eden lay se salà ininang ko diyà kamno? Eden lay se punù linèpangan ko so gayed a no pig-alaw? ");
INSERT INTO mbs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kinelokad no den se kedakel te kedònan ko. Eden lay se tinakaw lekat kamno? Aw doen kinità nikaw, soli den iyan dini te menge kedomaan ta amon meg-osay dan kenita. ");
INSERT INTO mbs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Migterbaho a den diyà kamno te kelowan se omay. Dalem te pegtonggò ko te kamno menge ayam-ayam, wedà palos keogali se menge karniro aw kambing nikaw. Wedad karniro no kinaen ko. ");
INSERT INTO mbs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Aw doen ayam-ayam no inimetayan te menenanap te kebenesan, wedà ko iyan ibingi diyà kamno, meneng kanak ayam-ayam se inselilin ko kenyan. Aw doen tinakaw pengkey aldaw aw delem, impebayad no iyan kanak. ");
INSERT INTO mbs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Melima se terbaho ko. Melikit a egkeilad te aldaw, aw egkegenawan a te delem. Gayed a egkepolaw. ");
INSERT INTO mbs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yan se kelimahan ko dalem te kelowan se omay te pegterbaho ko diyà kamno. Sempolò teg epat se omay se pegterbaho ko diyà kamno amon isablag ko te didowa batà nikaw. Enem se omay se pegterbaho ko diyà kamno amon ibayad ko te menge ayam-ayam seini, aw mekesempolò nikaw todai se pakang no tepad te itandan no diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Meneng tinebangan a te Timanem egseligan te apò ko si Abraham aw amay ko si Isaac. Aw wedà a din tebangi, nenamay a nikaw den impekesayo te wedad palos ontong ko. Meneng kinità te Timanem se kelimahan ko aw pagod ko, aw yan tinompelà ka din tidelem.” ");
INSERT INTO mbs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Minikagi si Laban, “Kanak batà se menge esawa nikaw, aw kanak apò se menge batà dan. Kanak heman se menge ayam-ayam seini. Pengkey eden se kitaen no dini, tomalag iyan kanak. Meneng eked kepakay aw megpeeleg a te menge batà ko aw menge apò ko. ");
INSERT INTO mbs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mèpiya aw megpepekangay ki den. Mèpiya heman aw doen kekitaan inangen ta amon eked ta kelibeli se pakang ta.” ");
INSERT INTO mbs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Penga niyan, inabat i Jacob se dakel bato, aw impetindeg din iyan amon meinang kekitaan. ");
INSERT INTO mbs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Minikagi sikandin diyà te menge kedomaan din, “Pengimon kaw heman te menge doma bato.” Yan nengimon dan te menge bato, aw binonton dan iyan, aw penga niyan kimaen dan doton medapag kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Iningedanan iyan i Laban Jegar Sahaduta diyà te kagi te Aramea (kelebadan niyan, peg-imon te kekitaan), aw iningedanan iyan i Jacob Galeed diyà te kagi te Hebreo (onawa se kelebadan niyan). ");
INSERT INTO mbs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Minikagi si Laban, “Se menge bato binonton seini, yan se kekitaan ta amon eked ta kelibeli se pakang ta.” Yan se doun te iningedanan se tanà sìyan Galeed. ");
INSERT INTO mbs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Iningedanan heman iyan Mispa (kelebadan niyan, benteyanan), so minikagi heman si Laban diyà ki Jacob, “Penga te pegsoway ta kwani, Timanem se megbantay diyà te tengà-tengà ta amon eked ki pegbolaw. ");
INSERT INTO mbs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Aw ipeeleg no se menge batà ko, sìyan esawa nikaw, aw pengognanen no se doma bayi kenà batà ko, pengkey eked ko iyan ketegahi, meneng kitaen iyan te Timanem aw ipelumun ka din. ");
INSERT INTO mbs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Dini den se menge bato binonton ko diyà te tengà-tengà ta, aw dini den se bato ininang kekitaan ta. ");
INSERT INTO mbs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Insawol ta iyan dini amon eked ta kelibeli se pakang ta seini. Eked a palos làpang te menge bato seini amon megpeeleg a kamno, aw eked ka palos heman làpang kani amon megpeeleg ka kanak. ");
INSERT INTO mbs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aw lèpangan ta se pakang seini, ipelumun ki te Timanem egseligan i Abraham aw si Nahor.” Penga niyan, migsapà heman si Jacob pineokit te ngadan te Timanem egseligan te amay din si Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Inimetayan din heman se ayam-ayam, aw sinonog din iyan, aw imbegay din iyan diyà te Timanem doton te bontod. Mig-inang heman sikandin te kànen, aw impekaen din se menge kedomaan din. Penga te pegpengaen dan, minidegà dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Pegkeiselem niyan, nengadek si Laban te menge apò din aw batà din, aw migtawal-tawal sikandin amon mèpiya se ibegay te Timanem diyà kandan. Penga niyan, nesayo sikandin aw minolì. ");
INSERT INTO mbs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nayan, dimeleg si Jacob, aw migkità sikandin te menge anghil kidoen te dalan. ");
INSERT INTO mbs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pegkità din kandan, minikagi sikandin, “Seini se eg-ogpaan te Timanem.” Yan iningedanan iyan Mahanaim (kelebadan niyan, dowa ogpeanan). ");
INSERT INTO mbs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Doen menge otaw insogò i Jacob impeonà din doton te kedowa din si Esau kidoen te tanà te Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Migpunù si Jacob diyà kandan, “Keliwati niyo se kagi ko seini diyà te kakay ko si Esau egsegmanen ko. ‘Siaken se sineligan no si Jacob. Mig-ogpà a doton ki Tiyò Laban lamig te peg-olì ko seini. ");
INSERT INTO mbs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Medita den se baka, asno, karniro, kambing, aw allang tinig-apò ko. Simabi a den kamno Akay, tepad te pegdateng ko, so doen pa besi keido no diyà kanak.’” ");
INSERT INTO mbs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Peglikò te otaw insogò i Jacob, minikagi dan, “Dimoton kay te kedowa no si Esau, aw nesayo den sikandin amon somongon kamno. Epat gatos se otaw impetaking din.” ");
INSERT INTO mbs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yan nelemitan si Jacob, aw netetana se pedowan din. Tinengà din se otaw timaking kandin, aw tinengà din heman se menge karniro, kambing, baka, aw kamilo din. ");
INSERT INTO mbs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Mig-aneng-aneng sikandin, “Aw lompaken i Esau se monà ebong, mekelowà besi se modi ebong.” ");
INSERT INTO mbs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Penga niyan, migtawal-tawal si Jacob, “E Timanem egseligan te apò ko si Abraham aw amay ko si Isaac. Pengolo ko, sikona se minikagi diyà kanak te keilangan molì a doton te tanà tinebawan ko aw menge kedomaan ko, aw migpakang ka heman te dakel se ibegay no diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Pelaban dakel se keido no diyà kanak wedad temanan niyan, so ontò a medanà diyà kamno. Kedengan te pegbatas ko te wayeg te Jordan pesalo doton ki Laban, wedad palos inibing ko olò bangkà. Meneng songkani doen den dowa dakel ebong ko seini. ");
INSERT INTO mbs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tebangi a bag seini amon eked a peelegi te kedowa ko si Esau. Nelemitan a aw lomompak sikandin diyà kenami, aw megelà se kedita day sipat te menge esawa ko aw menge batà ko. ");
INSERT INTO mbs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Meneng migpakang ka te mèpiya se ibegay no diyà kanak, aw inangen no medita se bowad-bowad ko iling te enay doton te dagat eked kebilang.” ");
INSERT INTO mbs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Minidegà si Jacob kidoen. Pinemallì din se menge ayam-ayam din kidoen amon doen ibowang din diyà ki Esau. ");
INSERT INTO mbs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dowa gatos se kambing bayi, kelowan se kambing meama, dowa gatos se karniro bayi, kelowan se karniro meama, ");
INSERT INTO mbs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ketlowan se kamilo bayi sipat nati niyan, kepatan se baka bayi, sempolò se baka meama, kelowan se asno bayi, aw sempolò se asno meama. ");
INSERT INTO mbs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Impeebong-ebong din se kedita dan, aw doen sineligan impetonggò din diyà te tegsebad-sebad ebong. Minikagi sikandin diyà te menge sineligan din, “Keilangan mengibing kaw te menge ayam-ayam doton te monà day, aw keilangan doen heman elet diyà te tegsebad-sebad ebong.” ");
INSERT INTO mbs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Minikagi si Jacob diyà te sineligan ontò din impeonà, “Aw kitaen no se kedowa ko si Esau, aw meg-insà sikandin aw sinu se amo nikaw aw kenan ka pesalo aw sinu se tig-apò te menge ayam-ayam inibing nikaw, ");
INSERT INTO mbs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","keilangan tomaba ka diyà kandin, ‘Seini se menge ayam-ayam te sineligan no si Jacob. Impeibing din iyan amon ibowang diyà kamno. Doton pa sikandin te modi.’” ");
INSERT INTO mbs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yan heman se impunù i Jacob diyà te ikedowa aw iketelo te otaw aw diyà te kedita te doma otaw nengibing te menge ayam-ayam. Minikagi sikandin, “Aw komità kaw kandin, keilangan onawa heman se ikegiyen niyo. ");
INSERT INTO mbs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Keilangan mikagi kaw diyà kandin, ‘Doton pa te modi se sineligan no si Jacob.’” Yan se impunù din diyà kandan, so mig-aneng-aneng sikandin, “Pineokit te ibowang ko diyà kandin, megkèpiya se pedowan din diyà kanak. Yan aw megkità kay, pegwedaden din besi se salà ininang ko diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yan impeonà i Jacob se ibowang din, meneng minidegà pa sikandin kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Pegkedelem niyan, minenaw si Jacob aw inibing din se dowa esawa din, aw dowa allang dan, aw sempolò tegusà batà din meama, aw impebatas din dan diyà te wayeg te Jordan kidoen te Jaboc. ");
INSERT INTO mbs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Penga te pegpebatas din kandan, impebatas din heman se kedita te ayam-ayam tinig-apò din. ");
INSERT INTO mbs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Olò si Jacob se wedà batas. Penga niyan, doen migpekità diyà ki Jacob aw migpeliyangay dan lamig te iselem. ");
INSERT INTO mbs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pegketaga-taga te otaw sìyan te eked dàgi si Jacob, inewidan din se pangkol i Jacob, aw neliyu iyan. ");
INSERT INTO mbs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Minikagi se otaw sìyan, “Pelowai a den, so agpet den lomibtak se aldaw.” Meneng minikagi si Jacob, “Eked a singed aw begayan a no te mèpiya.” ");
INSERT INTO mbs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mig-insà se otaw sìyan, “Sinu lay se ngadan nikaw?” Timaba sikandin, “Siak si Jacob.” ");
INSERT INTO mbs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Minikagi se otaw sìyan, “Lekat seini, eked ka den ingedani ki Jacob, meneng ingedanan ka beling ki Israel (kelebadan niyan, minato diyà te Timanem). So migpeliyangay ka aw Timanem, domaeg ka heman te menge otaw.” ");
INSERT INTO mbs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Mig-insà si Jacob, “Sinu ka lay bag?” Timaba se otaw sìyan, “Ikà eg-insà aw sinu a.” Penga niyan, mèpiya se impakang din diyà ki Jacob, aw nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iningedanan i Jacob se tanà sìyan Peniel (kelebadan niyan, bawa te Timanem), so minikagi sikandin, “Kinità ko den se bawa te Timanem, meneng wedà a kedì kematay.” ");
INSERT INTO mbs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Peglibtak te aldaw, nesayo si Jacob lekat te Peniel. Miglengkiyod sikandin tandà te pegkeliyu te pangkol din. ");
INSERT INTO mbs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Doun niyan, pengkey lamig songkani, kenà egpengànen te menge bowad-bowad i Israel se ogat te pangkol te ayam-ayam eg-iyawen dan, so yan se inewidan te Timanem te pangkol i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nayan, pegkità i Jacob ki Esau doton te mediyò sipat te epat gatos otaw timaking kandin, impetonggò din se menge batà din ki Lea aw si Raquel aw sìyan dowa allang dan. ");
INSERT INTO mbs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Impeonà din se dowa allang aw menge batà dan, aw impetelokon din se Lea aw menge batà din, aw impemodi din si Raquel aw si Jose. ");
INSERT INTO mbs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Penga niyan, si Jacob se minonà diyà te kedita dan, aw mekepito sikandin longken diyà te tanà te pegpedapag din diyà te kakay din. ");
INSERT INTO mbs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Meneng kimagnan si Esau simongon ki Jacob, aw kimeles sikandin te adi din, aw nengadek kandin. Didowa dan se migkelag. ");
INSERT INTO mbs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Penga niyan, kinità i Esau se menge bayi aw mengisù. Mig-insà sikandin, “Sinu lay se menge doma nikaw?” Timaba si Jacob, “Akay, seini se menge batà ko imbegay te Timanem diyà kanak tandà te keido din.” ");
INSERT INTO mbs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Penga niyan, migpedapag se didowa allang aw menge batà dan, aw limongken dan. ");
INSERT INTO mbs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Penga niyan, migpedapag si Lea aw menge batà din, aw limongken dan. Penga niyan, migpedapag heman si Jose aw si Raquel, aw limongken dan. ");
INSERT INTO mbs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Mig-insà si Esau, “Menonen no se medita ayam-ayam nesongonan ko gina? Eden lay se tod no kenyan?” Timaba si Jacob, “Amon keidowan a no peden Akay.” ");
INSERT INTO mbs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Meneng minikagi si Esau, “Botong den se kanak. Kamno den iyan.” ");
INSERT INTO mbs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Minikagi si Jacob, “Kenà. Aw doen keido no diyà kanak, kinewai bag se ibowang ko diyà kamno. Pegliyag no kanak, iling te liniyagan a te Timanem, so mèpiya den beling se pedowan no diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kinewai bag se bowang seini impeibing ko diyà kamno, so mèpiya se tabang te Timanem diyà kanak, aw botong se kedònan ko.” Gayed migleges si Jacob kandin, aw yan kiminawà si Esau kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Minikagi si Esau, “Na, mesayo kidon den. Domengan a den kenyo.” ");
INSERT INTO mbs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Meneng minikagi si Jacob, “Akay, netegahan no te deitek pa se menge batà ko, aw keilangan megpeloway-loway se menge karniro aw baka ko doen nati. Aw pelaban megaen se pegpengibing day kenyan te olò sebad se aldaw, matay se kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mèpiya beling aw monà ka diyà kenami, aw megpeloway-loway kay tomelokon kamno taman te mebatog te menge ayam-ayam aw batà ko lamig mekesaeb kay kamno doton te Edumea.” ");
INSERT INTO mbs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Minikagi si Esau, “Yan mèpiya aw doen menge otaw ipedengan ko kenyo.” Meneng minikagi si Jacob, “Ikà eg-inang kenyan. Neluba a den so mèpiya se pedowan no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Penga niyan dalem te aldaw sìyan, nesayo si Esau aw minolì doton te Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Meneng dimeleg beling si Jacob doton te Sucot, aw mig-inang sikandin te menge layag ogpaan dan aw menge kelokob te ayam-ayam. Doun niyan, iningedanan se lonsod sìyan Sucot (kelebadan niyan, menge kelokob). ");
INSERT INTO mbs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Peg-olì i Jacob lekat te Mesopotamya, dimeleg sikandin doton te lonsod te Sikem kidoen te Canaan te wedad nemeeleg kandin. Mig-ogpà sikandin doton te tanà medapag te lonsod sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Bineyadan din se tanà sìyan inogpaan din. Sebad gatos plata se kwarta dan selapì se imbayad din kenyan diyà te menge bowad-bowad i Hamor amay i Sikem. ");
INSERT INTO mbs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Mig-inang si Jacob te sonoganan te ayam-ayam ibegay diyà te Timanem, aw iningedanan din iyan El Elohe Israel (kelebadan niyan, magsen se Timanem egseligan i Israel). ");
INSERT INTO mbs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Na, si Dina se batà laga i Jacob aw si Lea. Doen sebad aldaw, miglegeana si Dina doton te menge laga mig-ogpà kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kinità sikandin i Sikem batà meama te datò kidoen si Hamor tege Hebi. Dinakep i Sikem si Dina, aw lineyokan din. ");
INSERT INTO mbs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Neibeg si Sikem ki Dina, aw ontò dakel se pedowan din diyà kandin, aw mèpiya se inikagi din diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Minikagi heman si Sikem diyà te amay din, “Ibeg ko megkagon ka tepad te bayi sìyan amon pengognanen ko sikandin.” ");
INSERT INTO mbs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Dinineg i Jacob tepad te pegleges ki Dina, meneng so migtonggò se menge batà din meama te menge ayam-ayam din doton mediyò te balay, yan wedad ininang din lamig minolì dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Dimoton si Hamor amay i Sikem ki Jacob amon megsontal dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Dalem niyan, minolì se menge batà i Jacob. Pegdineg dan te lineges i Sikem si Dina, ontò nepuluk se pedowan dan aw ontò dan neopal, so pigyàyà i Sikem se menge batà i Israel, aw eked iyan kepakay inangen. ");
INSERT INTO mbs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Meneng minikagi si Hamor diyà kandan, “Ontò dakel se pedowan te batà ko si Sikem diyà te batà no si Dina. Pepengognani niyo bag sikandin diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mèpiya aw gayed megpepengognanay se menge batà ta. ");
INSERT INTO mbs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mepakay heman aw meg-ogpà kaw dini kenami. Pemellii niyo se mèpiya ogpaan niyo. Mepakay se peg-ogpà niyo dini, aw pegnigosyo niyo dini, aw pegketig-apò niyo te tanà dini.” ");
INSERT INTO mbs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Penga niyan, minikagi si Sikem diyà te amay aw menge kedowa i Dina, “Aw keidowan a niyo aw ibegay niyo diyà kanak se bayi sìyan, pengkey eden se pemoyoen niyo, yan se ibegay ko diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Indani a niyo aw eden se isablag ko aw ibowang ko, so pengkey eden se pemoyoen niyo, yan se ibegay ko diyà kenyo. Pepengognani a niyo bag kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Meneng pegtaba te menge batà i Jacob diyà ki Sikem aw amay din si Hamor, mig-akal dan kandan so lineges se etebay dan si Dina. ");
INSERT INTO mbs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Minikagi dan, “Eked iyan kepakay diyà kenami. Eked kepakay diyà kenami aw pengognanen se etebay day te otaw wedà tolii, so meyàyà kay. ");
INSERT INTO mbs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Eked iyan kepakay diyà kenami singed aw megpetolì se kedita te meama doton kenyo, amon mekeiling kaw heman kenami. ");
INSERT INTO mbs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Aw megpetolì kaw, mepakay diyà kenami aw megpepengognanay kidon. Yan meg-ogpà kay doma niyo, aw meinang kidon sebad olò pongan. ");
INSERT INTO mbs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Meneng aw eked kepakay diyà kenyo aw megpetolì kaw, ibingen day se etebay day aw mesayo kay.” ");
INSERT INTO mbs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Neluba si Hamor aw batà din si Sikem tepad te inikagi dan sìyan. ");
INSERT INTO mbs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Melangkaw telaki si Sikem diyà te kedita te kedowa din, aw wedà sikandin peg-alà-alà te pegpetolì din, so ontò dakel se pedowan din diyà te batà bayi i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Yan dimoton si Hamor aw si Sikem te egludukan te otaw kidoen te lelebangan te kotà nekelibed te lonsod dan, aw minikagi dan diyà te menge doma otaw mig-ogpà kidoen, ");
INSERT INTO mbs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ibeg te menge otaw sida megpesigelakay kidon. Mèpiya aw ipeogpà tadon dan dini kenitadon. Mepakay aw megnigosyo dan heman dini, so doen pa keombaan te tanà seini. Mèpiya heman aw megpepengognanay se menge batà tadon aw menge batà dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Meneng eked dan keibeg meg-ogpà dini kenitadon amon meinang kidon sebad pongan singed aw megpetolì se kedita tadon meama iling heman kandan. ");
INSERT INTO mbs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Aw yan se inangen tadon, metig-apò tadon kwani se kedita te ayam-ayam dan aw kedakel te keyemanan dan. Yan mèpiya aw megsebad kidon tepad kenyan amon meg-ogpà dan dini kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Migsebad se kedita te otaw mig-ogpà kidoen tepad te inikagi i Hamor aw si Sikem, aw migpetolì se kedita te meama mig-ogpà kidoen te lonsod dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pegkepenga te telo se aldaw, dalem te ineleg se kedita dan tandà te pegpemetolì dan, dimoton se dowa batà i Jacob si Simeon aw si Levi ontò meama i Dina. Nengibing dan te sondang, aw miglompak dan te lonsod sìyan. Wedad palos otaw minato kandan, aw yan inigelà dan se kedita te meama. ");
INSERT INTO mbs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Inimetayan dan heman si Hamor aw batà din si Sikem tinigbas dan te sondang, aw inabat dan si Dina lekat te balay i Sikem aw minolì dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Penga te peg-igelà dan kandan, dimoton se kedita te batà meama i Jacob, aw linompak dan se kedakel te kedònan kidoen te lonsod sìyan, amon megmalit dan tepad te pegleges te etebay dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dinakep dan se kedita te karniro, baka, aw asno, aw inabat dan se kedakel te kedònan doton te lonsod sìyan aw tanà medapag kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Inabat dan se kedakel te keyemanan dan, aw dinakep dan se kedita te bayi aw mengisù, aw inibing dan se kedakel te awop te menge balay dan. ");
INSERT INTO mbs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Penga niyan, minikagi si Jacob diyà ki Simeon aw si Levi, “Ontò a den nelimahan, so pineokit te medaet ininang niyo sìyan, nebensihan a den te menge tege Canaan aw tege Perisi eg-ogpà dini te tanà seini. Olò kidon pilabok. Aw megtipon dan amon meglompak dan kenitadon, matay se kedita tadon.” ");
INSERT INTO mbs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Meneng timaba dan, “Eked kepakay diyà kenami aw lindoan se etebay day iling te kepoyun.” ");
INSERT INTO mbs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nayan, minikagi se Timanem diyà ki Jacob, “Doton ka den te Betel, aw peg-ogpà ka den kidoen. Peg-inang ka te sonoganan te ayam-ayam kidoen amon megsimba ka kanak, so siak se Timanem migpekità diyà kamno kedengan te pegkadas no lekat te kedowa no si Esau.” ");
INSERT INTO mbs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yan minikagi si Jacob diyà te pamilya din aw diyà te menge sakop din, “Pegbàti niyo den se kedita te inotaw niyo, sìyan egsimbahen te menge doma otaw wedà ketaga-taga te Timanem. Pemedigos kaw den aw peg-ekas kaw amon ipetaga-taga niyo te Timanem olò se toloen niyo. ");
INSERT INTO mbs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pegpeketagad kaw den, so domoton kidon te Betel. Meg-inang a te sonoganan te ayam-ayam kidoen amon megsimba a te Timanem. Pegdateng te kelimahan diyà kanak kedengan, tinebangan a din, aw gayed a din egdomaan pengkey kenan a pesalo.” ");
INSERT INTO mbs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yan imbegay dan diyà ki Jacob se kedita te inotaw dan aw menge belenigan inaritis dan, aw inlebeng din iyan doton te siyong te olayan kidoen te Sikem. ");
INSERT INTO mbs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pegkesayo i Jacob aw pamilya din, wedad otaw mig-alaw kandan, so migpeso se kedita te otaw mig-ogpà doton te menge lonsod medapag kidoen tandà te peglamit te Timanem kandan. ");
INSERT INTO mbs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Dimoton si Jacob te Luz (doma ngadan niyan Betel) kidoen te Canaan sipat te kedita te doma otaw timaking kandin. ");
INSERT INTO mbs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mig-inang sikandin te sonoganan te ayam-ayam kidoen, aw iningedanan din se tanà sìyan Timanem te Betel, so migpekità se Timanem diyà kandin kidoen kedengan te pegkadas din lekat te kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nematay kidoen si Debora tapay migtonggò ki Rebecca te pegkemengisù din, aw inlebeng se lawa din doton te olayan medapag te Betel. Yan se doun te iningedanan iyan Olayan te Pegkelag. ");
INSERT INTO mbs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Peg-olì i Jacob lekat te Mesopotamya, todà migpekità se Timanem diyà kandin, aw migpakang sikandin te mèpiya se ibegay din diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Minikagi se Timanem, “Iningedanan ka ki Jacob, meneng lekat seini, eked ka den ingedani ki Jacob, so ingedanan ka den beling ki Israel.” Yan iningedanan te Timanem sikandin ki Israel (kelebadan niyan, minato diyà te Timanem). ");
INSERT INTO mbs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Minikagi heman se Timanem, “Siaken se Timanem eglowan diyà te kedita. Inangen ko medita se menge bowad-bowad nikaw. Inangen ko medita pongan se menge bowad-bowad nikaw, aw doen heman kandan meinang menge selotan. ");
INSERT INTO mbs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Se kebelad te tanà imbegay ko diyà ki Abraham aw si Isaac, yan se ibegay ko heman diyà kamno, aw ibegay ko heman iyan diyà te menge bowad-bowad nikaw te modi aldaw.” ");
INSERT INTO mbs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Penga niyan, nesayo se Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Kidoen tepad te inikegiyan te Timanem diyà kandin, impetindeg i Jacob se bato ininang din kekitaan. Penga niyan, tinoyongan din iyan te bino aw lana te olibo, so yan se pengilala te ininang din iyan simbahan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Iningedanan din se tanà sìyan Betel (kelebadan niyan, balay te Timanem). ");
INSERT INTO mbs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nesayo si Jacob aw pamilya din, aw dimeleg dan. Te wedà dan pa dateng doton te Efrata, dimateng se aldaw te tebawan si Raquel, aw ontò sikandin nelimahan. ");
INSERT INTO mbs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Aw ontò sikandin ineleg, minikagi se menegemunay diyà kandin, “Ikà egkelemitan, so meama se timebaw diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Penga niyan, nebogtò se pedowan din aw nematay sikandin. Te wedà pa sikandin kematay, iningedanan din se batà din ki Ben-oni (kelebadan niyan, batà te kelimahan). Meneng iningedanan sikandin i Jacob ki Benjamin (kelebadan niyan, batà melangkaw). ");
INSERT INTO mbs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Pegkematay i Raquel, inlebeng dan se lawa din medapag te dalan pesalo doton te lonsod te Efrata. (Se lonsod te Efrata, yan se iningedanan Bitlihim songkani.) ");
INSERT INTO mbs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Impetindeg i Jacob se dakel bato kidoen te lebeng din amon doen kekitaan kenyan, aw kidoen pa iyan te lebeng din lamig songkani. ");
INSERT INTO mbs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Dimeleg si Jacob aw pamilya din, aw mig-ogpà dan doton dibaloy te kotà te Eder. ");
INSERT INTO mbs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Dalem te peg-ogpà i Jacob kidoen te tanà sìyan, limayok si Ruben diyà te sebad esawa te amay din si Bilha, aw dimineg si Jacob tepad kenyan. Sempolò teg dowa se batà meama i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Se menge batà din meama timebaw diyà ki Lea, yan si Ruben penganay batà i Jacob, si Simeon, si Levi, si Juda, si Isacar, aw si Sabulon. ");
INSERT INTO mbs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Se menge batà i Jacob timebaw diyà ki Raquel, yan si Jose aw si Benjamin. ");
INSERT INTO mbs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Se menge batà din timebaw diyà te allang i Raquel si Bilha, yan si Dan aw si Neftali. ");
INSERT INTO mbs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Se menge batà i Jacob timebaw diyà te allang i Lea si Zilfa, yan si Gad aw si Aser. Yan se menge batà meama i Jacob timebaw doton te Mesopotamya. ");
INSERT INTO mbs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nayan, minolì si Jacob doton te amay din si Isaac kidoen te Mamre medapag te Hebron tapay inogpaan i Abraham aw si Isaac kedengan. ");
INSERT INTO mbs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Minapet te sebad gatos kewelowan se omay i Isaac. ");
INSERT INTO mbs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ontò sikandin temoay te pegkematay din. Nebogtò se pedowan din, aw neketelokon sikandin te menge kemonaan din nematay. Inlebeng te batà din si Esau aw si Jacob se lawa din. ");
INSERT INTO mbs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Seini se indan tepad te menge bowad-bowad i Esau, doma ngadan din si Edom. ");
INSERT INTO mbs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nengognan si Esau te telo bayi mig-ogpà kidoen te Canaan, si Ada batà i Elon tege Heti, si Oholibama batà i Anas aw apò i Sibeon tege Hebi, ");
INSERT INTO mbs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","aw si Basimat batà i Ismael aw etebay i Nebaiot. ");
INSERT INTO mbs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Si Elifas se batà i Esau timebaw diyà ki Ada. Si Reuel se batà din timebaw diyà ki Basimat. ");
INSERT INTO mbs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Doen heman batà din timebaw diyà ki Oholibama si Jeus, si Jalam, aw si Coras. Yan se menge batà i Esau timebaw doton te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Impetaking i Esau se kedita te esawa din, menge batà din, aw menge sakop din, aw inibing dan se kedita te ayam-ayam din aw kedakel te kedònan din inabat din doton te Canaan, aw nesayo dan lekat te kedowa din si Jacob. Minalin dan doton te sebad tanà mediyò lekat kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Minalin si Esau so kenà botong se tanà inogpaan dan si Jacob. Pelaban medita se ayam-ayam dan aw gayed dan megsebad. ");
INSERT INTO mbs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yan se doun te mig-ogpà si Esau doton te bontod kidoen te Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seini se menge bowad-bowad i Esau kemonaan te menge tege Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Doen batà din meama si Elifas timebaw diyà ki Ada, aw si Reuel timebaw diyà ki Basimat. ");
INSERT INTO mbs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Se menge batà meama i Elifas, yan si Teman, si Omar, si Sefo, si Gatam, aw si Kenas. ");
INSERT INTO mbs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Doen heman doma esawa i Elifas si Timna, aw tinebawan sikandin i Amalec. Esawa i Esau si Ada se apò bayi te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Se menge batà meama i Reuel, yan si Nahat, si Seras, si Samas, aw si Misas. Esawa i Esau si Basimat se apò bayi te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Se menge batà meama i Esau timebaw diyà ki Oholibama batà i Anas aw apò i Sibeon, yan si Jeus, si Jalam, aw si Coras. ");
INSERT INTO mbs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Seini se ngadan te menge bowad-bowad i Esau neinang datò. Se menge batà i Elifas penganay batà i Esau neinang datò, yan si Teman, si Omar, si Sefo, si Kenas, ");
INSERT INTO mbs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","si Coras, si Gatam, aw si Amalec. Yan se menge batà i Elifas tege Edumea neinang datò, aw si Ada se apò bayi te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Se menge batà i Reuel batà i Esau neinang datò, yan si Nahat, si Seras, si Samas, aw si Misas. Yan se menge batà i Reuel tege Edumea neinang datò, aw si Basimat se apò bayi te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Se menge batà i Esau timebaw diyà ki Oholibama neinang datò, yan si Jeus, si Jalam, aw si Coras. Yan se menge batà te esawa i Esau si Oholibama batà i Anas neinang datò. ");
INSERT INTO mbs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yan se menge bowad-bowad i Esau, doma ngadan din si Edom, neinang menge datò. ");
INSERT INTO mbs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seini se ngadan te menge batà meama i Seir tege Hori, aw mig-ogpà dan doton te Edumea. Si Lotan, si Sobal, si Sibeon, si Anas, ");
INSERT INTO mbs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","si Dison, si Eser, aw si Disan. Se menge batà i Seir, yan se menge datò te tege Hori mig-ogpà doton te Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Se menge batà meama i Lotan, yan si Hori aw si Heman. Si Timna se etebay i Lotan. ");
INSERT INTO mbs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Se menge batà meama i Sobal, yan si Alban, si Manahat, si Ebal, si Sefo, aw si Onam. ");
INSERT INTO mbs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Se menge batà meama i Sibeon, yan si Aias aw si Anas. Si Anas se kimità te selep meinit doton te kebigtilan te pegpeloyaw din te menge asno te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Se menge batà i Anas, yan se meama si Dison, aw bayi si Oholibama. ");
INSERT INTO mbs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Se menge batà meama i Dison, yan si Hemdan, si Esban, si Etran, aw si Seran. ");
INSERT INTO mbs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Se menge batà meama i Eser, yan si Bilhan, si Saaban, aw si Acan. ");
INSERT INTO mbs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Se menge batà meama i Disan, yan si Os aw si Aran. ");
INSERT INTO mbs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Se menge datò te menge tege Hori, yan si Lotan, si Sobal, si Sibeon, si Anas, ");
INSERT INTO mbs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","si Dison, si Eser, aw si Disan. Yan se menge datò te tegsebad-sebad pongan te tege Hori mig-ogpà doton te Seir. ");
INSERT INTO mbs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Seini se ngadan te menge selotan migpetibos-tibosay te peglowan dan doton te Edumea te wedad pa selotan limowan diyà te menge bowad-bowad i Israel. Si Bela batà i Beor tege Dinhaba. Si Jobab batà i Sera tege Bosra. Si Husan tege Teman. Si Hadad batà i Bedad tege Abit. (Si Bedad se nekedaeg te menge tege Midian doton te tanà te Moab.) Si Samla tege Masreca. Si Saul tege Rehobot te Yofritis. Si Baal Hanan batà i Acbor. Si Hadad tege Pau. (Se esawa din, yan si Mehetabel batà bayi i Matred aw apò i Mesahab.) ");
INSERT INTO mbs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Seini se ngadan te menge bowad-bowad i Esau neinang datò kidoen te tegsebad-sebad pongan dan aw ogpeanan dan. Si Timna, si Albas, si Jetet, ");
INSERT INTO mbs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","si Oholibama, si Elas, si Pinon, ");
INSERT INTO mbs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","si Kenas, si Teman, si Mibsar, ");
INSERT INTO mbs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","si Magdiel, aw si Iram. Yan se menge datò te tegsebad-sebad ogpeanan kidoen te Edumea. Si Edom (doma ngadan din si Esau) se kemonaan te kedita te tege Edumea. ");
INSERT INTO mbs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Mig-ogpà si Jacob doton te Canaan, sìyan tanà inogpaan te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Seini se indan-indan tepad te menge batà i Jacob. Nayan, sempolò teg pito se omay i Jose, aw migtelaban sikandin te menge kedowa din kakay migtonggò te menge ayam-ayam te amay dan. Se menge kedowa din, yan se menge batà meama te doma menge esawa te amay din si Bilha aw si Zilfa. Doen medaet eg-inangen te menge kedowa i Jose, aw dimoton sikandin te amay din aw mig-indan diyà kandin tepad kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Pengkey dakel se pedowan i Jacob diyà te menge doma batà din, meneng labi pa dakel se pedowan din diyà ki Jose, so temoay den si Jacob te pegtebaw i Jose. Yan impeinang din se mèpiya saol melayat se buktun aw imbegay din iyan kandin. ");
INSERT INTO mbs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pegkità te menge kedowa din te ontò sikandin nedekelan te pedowan te amay dan, nebensi dan ki Jose, aw wedad palos mèpiya kagi dan diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nayan, migtegeinep si Jose, meneng peg-indan din tepad te tegeinep din diyà te menge kedowa din, labi dan pa nebensi kandin, ");
INSERT INTO mbs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","so minikagi sikandin, “Penenalan kaw tepad te tegeinep ko. ");
INSERT INTO mbs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Peglegani tadon te trigo doton te pawà, nemagkes kidon te ginani tadon. Tigkan neketindeg se kanak bagkes nelibedan te kenyo bagkes, aw limongken se bagkes niyo aw migsagman dan te bagkes ko.” ");
INSERT INTO mbs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Minikagi se menge kedowa din, “Eden no aw meinang ka selotan day. Eden no aw lomowan ka diyà kenami.” Penga niyan, labi dan pa nebensi kandin tandà te tegeinep din aw tandà te inikagi din diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Todà migtegeinep si Jose, aw yan se in-indan din diyà te menge kedowa din, kagi din, “Todà a migtegeinep, aw kinità ko se aldaw, aw bolan, aw sempolò tegusà se bitoen tigkan limongken diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Meneng peg-indan din kenyan diyà te amay din aw menge kedowa din, nenompelà se amay din kandin, kagi din, “Eden lebò se kedegdagan te sìyan tegeinep nikaw? Lomongken a lay diyà kamno sipat te inay nikaw aw menge kedowa nikaw?” ");
INSERT INTO mbs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Gayed miningà se menge kedowa i Jose kandin, meneng gayed mig-aneng-aneng se amay din tepad te kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Doen sebad aldaw, nengibing se menge kedowa i Jose te menge ayam-ayam te amay dan doton te Sikem amon ipeloyaw kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Minikagi si Jacob diyà ki Jose, “Dimoton te Sikem se menge kedowa no aw migpeloyaw dan te menge ayam-ayam kidoen. Peketagad ka so isogò ta doton kandan.” Minikagi si Jose, “Neketagad a den.” ");
INSERT INTO mbs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Minikagi se amay din, “Doton ka, aw laoy ka kandan aw menge ayam-ayam egtonggoan dan. Penga niyan, likò ka dini amon ketegahan ko se pegkesawol dan.” Yan timolò si Jose te sogò te amay din, aw nesayo lekat te Baog te Hebron. Pegdateng i Jose doton te Sikem, ");
INSERT INTO mbs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","miglegeb sikandin aw nengemahà te menge kedowa din. Doen otaw kimità kandin aw mig-insà aw eden se inahà din kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Timaba si Jose, “Nengemahà a te menge kedowa ko. Indani a bag aw kenan dan pegpeloyaw te menge ayam-ayam dan.” ");
INSERT INTO mbs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Minikagi se otaw sìyan, “Dimeleg den dan, so minikagi dan te domoton dan te Dotan.” Yan timelokon si Jose kandan, aw kinità din dan doton te Dotan. ");
INSERT INTO mbs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Pengkey mediyò pa sikandin, kimilala se menge kedowa din kandin. Te wedà pa sikandin dateng doton kandan, miglalang dan te imetayan dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Migpebelaw-belaway dan, “Migpesalo den dini se otaw sìyan gayed egtegeinep. ");
INSERT INTO mbs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ayas kaw. Imetayan tadon sikandin aw idagdag tadon se lawa din doton te medalem sokian. Mikagi kidon te doen menenanap te kebenesan nengimatay kandin. Penga niyan, tegadan tadon aw doen ketomanan te menge tegeinep din.” ");
INSERT INTO mbs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Meneng pegdineg i Ruben te inikagi te menge kedowa din, ibeg din eked dan peelegi se adi dan. Yan minikagi sikandin, “Mèpiya aw eked tadon imetayi. ");
INSERT INTO mbs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ikà niyo egpeeleg kandin, meneng botong aw idagdag tadon sikandin doton te medalem sokian doton te kebigtilan amon matay sikandin te wedad megpeeleg kandin.” Yan se inikagi i Ruben so ibeg din ipelowà din si Jose amon ibingen din doton te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pegdateng i Jose doton kandan, piglowasan dan sikandin te saol din melayat se buktun. ");
INSERT INTO mbs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Penga niyan, inibing dan sikandin doton te medalem sokian wedad wayeg, aw indagdag dan doton. ");
INSERT INTO mbs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Penga niyan, dalem te pegpengaen dan, tigkan dan kinità se menge bowad-bowad i Ismael aw menge ayam-ayam dan kamilo minokit kidoen lekat te Galaad. Doen inlolan diyà te menge kamilo dan menge enagay aw bebolong te saka ibingen dan doton te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yan minikagi si Juda diyà te menge kedowa din, “Aw imetayan tadon se adi tadon aw ibolon tadon iyan, wedad ontong tadon. ");
INSERT INTO mbs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Meneng labi pa mèpiya aw ibeligyà tadon sikandin diyà te menge bowad-bowad i Ismael sida. Eked kepakay aw imetayan tadon sikandin, so telekedowa kidon aw sebad olò se amay tadon.” Yan timandù heman se menge kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pegdateng te menge tege Midian doton kandan, impelowà dan sikandin lekat te sokian, aw imbeligyà dan sikandin. Kelowan plata selapì se kwarta imbayad te menge bowad-bowad i Ismael kandin, aw penga niyan, inibing dan sikandin doton te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nayan, pegdoton i Ruben te sokian amon megpelowà ki Jose, kinità din te wedad den kidoen. Yan miglisì sikandin te saol din tandà te puluk din. ");
INSERT INTO mbs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Dimoton sikandin te menge kedowa din aw minikagi, “Megmeno a? So wedad den kidoen si Jose.” ");
INSERT INTO mbs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Penga niyan, nengimatay dan te kambing, aw linegeb dan se saol i Jose te dipanog niyan. ");
INSERT INTO mbs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Penga niyan, impeibing dan se saol din melayat se buktun doton te amay dan, aw minikagi dan, “Seini se netelaan day. Tengtengi aw yan se saol te batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kinilala din te yan se saol i Jose, aw minikagi sikandin, “Ee, kandin ini. Inimetayan sikandin te mebolot menenanap te kebenesan, aw kinaen se lawa din.” ");
INSERT INTO mbs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Penga niyan, miglisì si Jacob te saol din aw nengelibaeg sikandin te sako tandà te lano din. Nenamay sikandin minoloy tepad te pegkematay te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Netipon se kedita te batà din amon megsinalay dan kandin, meneng kimulu sikandin, kagi din, “Gayed a moloy tandà te pegkematay te batà ko lamig komità a kandin doton te ogpeanan te otaw nematay.” Yan gayed sikandin minoloy te batà din si Jose. ");
INSERT INTO mbs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Meneng kenan si Jose? Doton sikandin te Ehipto, so inibing te menge tege Midian aw imbeligyà dan doton. Bineyadan sikandin i Potifar, sebad opisyal migtelaban te selotan te Ehipto si Paraon, aw sikandin se kapitan te menge sondalo din. ");
INSERT INTO mbs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nayan, dalem niyan, timanan si Juda te menge kedowa din, aw minalin sikandin doton te balay i Hiras tege Adulam. ");
INSERT INTO mbs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kinità i Juda se bayi kidoen tege Canaan batà i Suas, aw yan se pinengognan din. ");
INSERT INTO mbs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Miglaman se esawa din, aw doen batà meama timebaw diyà kandin iningedanan i Juda ki Er. ");
INSERT INTO mbs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Todà miglaman se esawa din, aw doen batà meama timebaw diyà kandin iningedanan te inay din ki Onan. ");
INSERT INTO mbs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Todà doen batà meama timebaw diyà kandin, aw iningedanan iyan te inay din ki Selas. Doton dan te Sesib te pegtebaw i Selas. ");
INSERT INTO mbs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nayan, pegkenamay, impeipid i Juda se penganay batà din si Er diyà ki Tamar. ");
INSERT INTO mbs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Medaet se eg-inangen i Er, aw wedà keluba se Timanem kandin. Yan inimetayan sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Penga niyan, minikagi si Juda diyà ki Onan, “Keilangan lomayok ka diyà te nayi no nebalo, so keilangan tomanen no se ketanem tadon tepad te inangen te kedowa te meama nematay te wedad pa batà te esawa din, amon doen peden batà te kedowa nikaw nematay.” ");
INSERT INTO mbs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Meneng netegahan i Onan te eked kepakay aw kandin se batà tomebaw diyà te nayi din, so meinang iyan batà te kakay din nematay. Doun niyan, peglayok din diyà te nayi din nebalo, gayed din impedelowak se benì din diyà te lowà, amon wedad meinang batà te kakay din nematay. ");
INSERT INTO mbs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Meneng wedà keluba se Timanem tepad te ininang din sìyan, aw yan inimetayan heman sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Penga niyan, minikagi si Juda diyà te ogangan din si Tamar, “Olì ka den aw peg-ogpà ka doton te balay te amay no dalem te wedad pa esawa no lamig megketelaki se doma batà ko si Selas.” Yan se inikagi i Juda so nelemitan sikandin aw matay heman si Selas iling te menge kedowa din. Yan minolì si Tamar doton te balay te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nayan, pegkenamay-namay, nematay se esawa i Juda batà bayi i Suas. Pegketagkas te menge aldaw te pegkelano i Juda, dimoton sikandin te ogpeanan te Timna sipat te sigalak din si Hiras tege Adulam, so gontingan din se menge karniro din kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Inindanan si Tamar te dimoton se ogangan din te Timna amon meglegonting sikandin te menge karniro din. ");
INSERT INTO mbs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pegdineg din kenyan, linowas din se dagom eggemiten te balo aw migdagom sikandin te sebad kemolò, aw sinempengan din heman se bawa din amon eked sikandin kilelai. Dimoton sikandin te dalan medapag te lonsod te Enaim aw nenenoo sikandin kidoen, so yan se dalan okitanan te otaw pesalo doton te Timna. Netegahan din te pengkey migketelaki den si Selas, meneng wedà dan pa peipidi. ");
INSERT INTO mbs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Na, pegkità i Juda ki Tamar, eden din aw kepoyun, so sinempengan din se bawa din. ");
INSERT INTO mbs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yan migpedapag si Juda diyà kandin doton te kilid te dalan, aw minikagi sikandin, “Aw mepakay, lomayok a den diyà kamno.” Wedà din kilelai se ogangan din. Mig-insà si Tamar, “Eden lay se ibayad no aw lomayok ka kanak?” ");
INSERT INTO mbs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Timaba si Juda, “Ipeibing ko diyà kamno se nati te kambing lekat te menge ayam-ayam ko.” Minikagi si Tamar, “Doen lay ipondo no seini lamig ipeibing no se kambing?” ");
INSERT INTO mbs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mig-insà si Juda, “Eden lay se ipondo ko diyà kamno?” Timaba si Tamar, “Se peningsing impeninga nikaw, aw sìyan bangkà diyà te belad nikaw.” Imbegay din iyan diyà kandin, aw limayok diyà kandin, aw miglaman si Tamar. ");
INSERT INTO mbs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Penga niyan, minolì si Tamar, aw linowas din se insampeng din te bawa, aw todà sikandin migdagom te dagom te balo. ");
INSERT INTO mbs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Dalem niyan, insogò i Juda se sigalak din si Hiras amon mengibing sikandin te kambing doton te bayi aw amon mengabat te impondo din diyà kandin. Meneng wedà din kitai. ");
INSERT INTO mbs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Mig-insà si Hiras diyà te menge otaw mig-ogpà kidoen te Enaim, “Kenan lay den se kepoyun nenenoo gina dini medapag te dalan?” Timaba dan, “Wedad palos kepoyun dini.” ");
INSERT INTO mbs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Penga niyan, limikò si Hiras doton ki Juda, aw minikagi, “Wedà ko kitai. Inikegiyan a te menge otaw eg-ogpà kidoen te wedad palos kepoyun kidoen.” ");
INSERT INTO mbs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Minikagi si Juda, “Wedad beloyan. Kandin den se impondo ko amon eked ki den keyàyà. So pengkey begayan ko peden sikandin te kambing, meneng wedà no sikandin kitai.” ");
INSERT INTO mbs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nayan, penga te menge telo se bolan, inindanan si Juda, “Iling te kepoyun se ogangan no si Tamar, so mebedes den sikandin.” Minikagi si Juda, “Engayi niyo sikandin aw sonogi niyo amon matay.” ");
INSERT INTO mbs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Dalem te peg-angay dan ki Tamar, doen insogò din amon mikagi diyà te ogangan din, “Mebedes a den pineokit te tig-apò te peningsing seini ipegpeninga aw bangkà. Ketegahan no besi aw sinu se tig-apò kenyan.” ");
INSERT INTO mbs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kinilala iyan i Juda, aw minikagi sikandin, “Labi pa medaet se ininang ko diyà te ininang din, so wedà ko sikandin peipidi diyà te batà ko si Selas.” Penga niyan, wedà todà layok si Juda diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Pegdateng te aldaw aw agpet tebawan si Tamar, netegahan te pingin se tomebaw. ");
INSERT INTO mbs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dalem te pegtebaw, limowà se bebenayen te sebad batà. Binagkes te menegemunay se lelengoan te sinolib ontò melalag, aw minikagi sikandin, “Seini se tagnà limowà.” ");
INSERT INTO mbs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Meneng linenek te batà se belad din. Kedowa din beling se tagnà timebaw, aw yan minikagi se menegemunay, “Magsen ka limowà.” Yan iningedanan sikandin ki Pares (kelebadan niyan, magsen limowà). ");
INSERT INTO mbs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Penga niyan, timebaw se kedowa din binagkes se lelengoan te sinolib melalag. Iningedanan sikandin ki Seras (kelebadan niyan, ontò melalag). ");
INSERT INTO mbs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nayan, pegpengibing te menge bowad-bowad i Ismael ki Jose doton te Ehipto, imbeligyà dan sikandin diyà ki Potifar. Si Potifar se sebad opisyal migtelaban te selotan te Ehipto si Paraon, aw sikandin se kapitan te menge sondalo din. ");
INSERT INTO mbs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tinebangan te Timanem si Jose, aw mèpiya se kedita te eg-inangen din. Ininang sikandin sineligan doton te balay te amo din sìyan tege Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kinità te amo din te tinebangan sikandin te Timanem, aw tandà te tabang te Timanem, mèpiya se kedita te eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yan neluba si Potifar kandin, aw ininang din sikandin sineligan egtelaban kandin. Ininang din sikandin egpengibing te kedita te otaw doton te balay din aw kedakel te kedònan din. ");
INSERT INTO mbs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Lekat niyan, so kidoen si Jose, tinebangan te Timanem si Potifar aw dakel se ontong din pengkey doton te balay din aw doton te pawà din. ");
INSERT INTO mbs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Insalig din se kedakel te kedònan din diyà ki Jose, so dalem te pegpengibing i Jose kenyan, wedad palos keilangan eneng-enengen din, olò kànen din se egpemellien din. Nayan, mèpiya se bawa i Jose aw magsen se lawa din. ");
INSERT INTO mbs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wedà kenamay, neibeg se esawa i Potifar ki Jose aw minikagi sikandin, “Layok ka den kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Meneng mig-eked si Jose, aw timaba sikandin, “Wedad palos keilangan eneng-enengen te amo ko so sineligan a din. Insalig din se kedakel te kedònan din diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Iling te onawa se kelangkaw ko diyà te kelangkaw din dini te balay seini. Wedad palos wedà din seligi diyà kanak olò sikona, so esawa ka din. Eked kepakay aw meg-inang a te medaet iling kenyan. Eked kepakay aw meg-inang a te salà diyà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pengkey nemoyò sikandin ki Jose te kelikit te aldaw amon lomayok aw domoma kandin, meneng wedà sikandin penenalan kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Doen sebad aldaw, minawop si Jose te balay so doen inangen din doton, aw wedad doma sineligan kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yan minawid se bayi te buktun te saol i Jose, aw minikagi sikandin, “Layok ka den kanak.” Ayas limowà si Jose lekat te balay aw kimadas sikandin, meneng netenanan din se saol din inewidan te bayi. ");
INSERT INTO mbs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pegkità te esawa i Potifar te netenanan i Jose se saol din aw kimadas sikandin lekat te balay, ");
INSERT INTO mbs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tinawal din se menge doma sineligan, aw minikagi sikandin, “Na, inibing te doma ko dini se Hebreo sìyan amon megyàyà kenitadon. Minawop gina sikandin te tambì ko amon megleges peden kanak, meneng mig-olangag a. ");
INSERT INTO mbs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Pegdineg din te peg-olangag ko, netenanan din se saol din dini kanak, aw limowà sikandin lekat te balay aw kimadas.” ");
INSERT INTO mbs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Penga niyan, intagò din se saol i Jose lamig minolì se esawa din. ");
INSERT INTO mbs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Peg-olì din, onawa se in-indan din, kagi din, “Se Hebreo sìyan sineligan inibing no dini, yan se minawop gina te tambì ko amon megleges peden kanak. ");
INSERT INTO mbs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Meneng peg-olangag ko, netenanan din se saol din dini kanak, aw limowà sikandin lekat te balay aw kimadas.” ");
INSERT INTO mbs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Pegdineg te amo i Jose te in-indan te esawa din te medaet se ininang i Jose diyà kandin, ontò sikandin neopal. ");
INSERT INTO mbs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Impedakep din si Jose aw impekeleboso doton te kotà egsolan te selotan te menge otaw ipegpelumun din. Yan se sinolan ki Jose. ");
INSERT INTO mbs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Meneng tinebangan sikandin te Timanem, aw gayed dakel se pedowan te Timanem kandin. Neluba se otaw egbantay te keleboso ki Jose, ");
INSERT INTO mbs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","aw ininang din sikandin egpengibing te kedita te otaw kineleboso, aw sikandin se simogò aw eden se inangen dan doton didalem te keleboso. ");
INSERT INTO mbs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wedad palos keilangan eneng-enengen te otaw egbantay te keleboso tepad te eg-inangen i Jose, so tinebangan te Timanem si Jose, aw yan mèpiya se kedita te eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nayan, doen sineligan te selotan te Ehipto egpengibing te bino diyà kandin, aw doen heman sineligan te selotan eg-inang te pan kandin. Pegkenamay-namay, nekesalà dan diyà te amo dan, sìyan selotan te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Neopal se selotan kandan, ");
INSERT INTO mbs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","aw impekeleboso din dan doton te kinelebosowan ki Jose. Yan se keleboso egbentayan i Potifar, kapitan te menge sondalo te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ininang te kapitan si Jose sineligan te didowa otaw sìyan, aw nenamay dan kineleboso. ");
INSERT INTO mbs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Doen sebad delem migtegeinep dan, sìyan egpengibing te bino aw eg-inang te pan te selotan. Kenà onawa se tegeinep dan, aw kenà heman onawa se kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pegkeiselem niyan te pegdoton i Jose kandan, kinità din te netetana se pedowan dan. ");
INSERT INTO mbs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yan mig-insà sikandin, “Nengà lay netetana se pedowan niyo?” ");
INSERT INTO mbs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Timaba dan, “Migtegeinep kay, aw wedad otaw mekeindan kenami aw eden se kedegdagan niyan.” Minikagi si Jose, “Timanem se egpemegay te kebiyasa diyà te otaw amon mekeindan te kedegdagan te tegeinep. Indani a tepad te tegeinep niyo.” ");
INSERT INTO mbs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yan mig-indan se otaw egpengibing te bino tepad te tegeinep din, kagi din, “Pegtegeinep ko, kinità ko se pinonoan te paras ");
INSERT INTO mbs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","doen telo belagen. Dimawen iyan, aw nemokad, aw nemongo, aw neinog se paras. ");
INSERT INTO mbs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Minawid a te tabò te selotan, aw yan nengipò a te paras aw nengemeg a kenyan. Dimelog se temek niyan diyà te tabò, aw yan se inibing ko doton te selotan.” ");
INSERT INTO mbs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Minikagi si Jose, “Seini se kedegdagan niyan. Se telo belagen sìyan, yan se telo se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Telo seini, ipelowà ka te selotan lekat te keleboso, aw todà ka din ipelikò doton te tapay terbaho nikaw. Todà ka mengibing te bino kandin, iling te tapay nikaw ininang. ");
INSERT INTO mbs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aw todà megkèpiya se peg-ogpà nikaw, eneng-enengi a bag. Indani bag se selotan tepad kanak amon mekelowà a lekat te keleboso. ");
INSERT INTO mbs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tinakaw a lekat te mediyò ogpeanan day menge Hebreo, aw pengkey wedad palos medaet ininang ko, meneng impekeleboso a pa dini te Ehipto.” ");
INSERT INTO mbs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nayan, pegketaga-taga te otaw eg-inang te pan te selotan te mèpiya se kedegdagan te tegeinep te egpengibing te bino, minikagi heman sikandin diyà ki Jose, “Doen heman tegeinep ko. Doen telo bigo nepenò te pan insodò ko. ");
INSERT INTO mbs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Se bigo diyà te lanto, yan se doen medita kemolò te pan ibingen ko doton te selotan, meneng kinaen iyan te menge manok te kebenesan.” ");
INSERT INTO mbs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Minikagi si Jose, “Seini se kedegdagan niyan. Se telo bigo sìyan, yan se telo se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Telo seini, ipelowà ka te selotan lekat te keleboso, aw ipesipal din se lieg nikaw. Ipebitin se lawa no doton te tollok aw kànen te menge manok te kebenesan se onod nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Netoman iyan, so pegkepenga te telo se aldaw, mig-inang se selotan te dakel kànen so yan se aldaw te pegtebaw din, aw impetanod din se kedita te menge opisyal. Impelowà din lekat te keleboso se otaw egpengibing te bino aw otaw eg-inang te pan, aw impeibing din dan doton te menge opisyal netipon. ");
INSERT INTO mbs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Sìyan otaw egpengibing te bino, yan se impelikò te selotan doton te tapay terbaho din, aw sikandin se todà nengibing te bino kandin. ");
INSERT INTO mbs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Meneng sìyan otaw eg-inang te pan, yan se impeimatay te selotan. Netoman se kedita te inikagi i Jose diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Meneng wedà palos peg-aneng-aneng se egpengibing te bino tepad ki Jose. Nelibelan din sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nayan, penga te dowa se omay, migtegeinep heman se selotan. Timindeg sikandin doton te kilid te dakel wayeg iningedanan Nilo. ");
INSERT INTO mbs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tigkan din kinità se pito baka ontò melambò aw mèpiya se bawa. Minanggin dan lekat te wayeg, aw kimaen dan te sagbet doton te kilid niyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tigkan din heman kinità se doma pito baka minanggin lekat te wayeg, meneng ontò dan megasà aw medaet se bawa. Dimoton dan te doma pito baka timindeg kidoen te kilid te wayeg. ");
INSERT INTO mbs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Se menge baka megasà, yan se kimaen te menge baka melambò. Penga niyan, neloka se selotan. ");
INSERT INTO mbs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Todà timedogi se selotan aw todà sikandin migtegeinep. Kinità din se sebad ponò te trigo doen pito oway ontò melambò aw mèpiya se bawa. ");
INSERT INTO mbs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Penga niyan, timilles se doma pito oway nekoped aw kimipes te emiyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Se oway nekoped, yan se nengame te oway melambò. Penga niyan, neloka se selotan aw netaga-taga sikandin te tegeinep din olò iyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pegkeiselem niyan, netetana se pedowan te selotan. Yan impeangay din se kedita te otaw biyasa egselemangka aw menge doma otaw biyasa doton te Ehipto. Mig-indan sikandin diyà kandan tepad te tegeinep din, meneng wedad palos nekeindan kandin aw eden se kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Penga niyan, minikagi se otaw egpengibing te bino, “Keilangan meg-indan a den seini tepad te salà ko. ");
INSERT INTO mbs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kedengan neopalan kay nikaw sìyan otaw mig-inang te pan, aw impekeleboso kay nikaw doton te balay te kapitan te menge sondalo. ");
INSERT INTO mbs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Doen sebad delem, migtegeinep kay, meneng kenà onawa se kedegdagan te tegeinep day. ");
INSERT INTO mbs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Doen Hebreo kidoen, telaki pa, sineligan te kapitan te menge sondalo. Mig-indan kay diyà kandin tepad te tegeinep day, aw in-indan din kenami se kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Netoman se kedita te inikagi din, so todà a no impelikò doton te tapay terbaho ko, aw impeimatay no se otaw mig-inang te pan.” ");
INSERT INTO mbs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yan impeangay te selotan si Jose, aw ayas sikandin impelowà lekat te keleboso. Migpegopit sikandin, aw mig-ekas, aw dimoton te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Minikagi se selotan diyà ki Jose, “Migtegeinep a, aw wedad otaw nekeindan kanak aw eden se kedegdagan niyan. Inindanan a te biyasa ka eg-indan aw eden se kedegdagan te tegeinep aw iindan iyan diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Timaba si Jose, “Kenà lekat kanak se kebiyasa, meneng Timanem olò se megpetaga-taga kamno te mèpiya kedegdagan niyan.” ");
INSERT INTO mbs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Minikagi se selotan, “Pegtegeinep ko, timindeg a doton te kilid te wayeg te Nilo. ");
INSERT INTO mbs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tigkan ko kinità se pito baka ontò melambò aw mèpiya se bawa. Minanggin dan lekat te wayeg, aw kimaen dan te sagbet doton te kilid niyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tigkan ko heman kinità se doma pito baka minanggin lekat te wayeg, meneng ontò dan megasà aw medaet se bawa. Wedad palos baka kinità ko dini te Ehipto labi pa megasà. ");
INSERT INTO mbs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Penga niyan, se menge baka megasà, yan se kimaen te menge baka melambò. ");
INSERT INTO mbs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Meneng pengkey kimaen dan te baka melambò, iling te wedad kinaen dan so kunù pa se kegasà dan. Penga niyan, neloka a. ");
INSERT INTO mbs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Todà a migtegeinep, aw kinità ko se sebad ponò te trigo doen pito oway ontò melambò aw mèpiya se bawa. ");
INSERT INTO mbs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Penga niyan, timilles se doma pito oway nekoped aw kimipes te emiyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Se oway nekoped, yan se nengame te oway melambò. Yan se tegeinep in-indan ko diyà te menge otaw biyasa egselemangka, meneng wedad palos nekeindan kanak aw eden se kedegdagan niyan.” ");
INSERT INTO mbs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Minikagi si Jose diyà te selotan, “Sir, olò sebad se kedegdagan te didowa tegeinep nikaw. Impetaga-taga te Timanem diyà kamno aw eden se inangen din. ");
INSERT INTO mbs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Se pito baka melambò, yan se pito se omay. Se pito oway te trigo, yan heman se pito se omay. Olò sebad se kedegdagan te didowa tegeinep nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Se pito baka megasà nekemodi, aw sìyan pito oway nekoped aw kimipes te emiyan, yan se pito se omay te bitil. ");
INSERT INTO mbs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ontò benal se inikagi ko gina. Impetaga-taga te Timanem diyà kamno aw eden se inangen din. ");
INSERT INTO mbs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Domateng den se pito se omay te ontò dakel se geniyen dini te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Penga te pito se omay mèpiya, domateng se pito se omay te bayil, aw yan se mekebaet te kedita dini te Ehipto igsà kelibelan se pito se omay doen dakel geniyen. ");
INSERT INTO mbs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ontò kelibelan se omay te beyang-beyang tandà te kedaet te bayil domateng te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Mekedowa ka pegtegeinep amon ketegahan no te yan se metoman inangen te Timanem, aw tomanen din iyan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nayan, mèpiya aw pemellien no se otaw ontò biyasa, aw inangen no sikandin keseligan dini te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mèpiya heman aw pemellien no se menge doma opisyal doton te tegsebad-sebad ogpeanan amon ebaten dan se tengà te lima diyà te kedakel te trigo geniyen dalem te pito se omay doen dakel geniyen. ");
INSERT INTO mbs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sogò ka kandan te keilangan imonen dan se kànen dalem te menge omay doen dakel geniyen amon itagò iyan doton te tegsebad-sebad lonsod aw bentayan iyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Se itagò, yan se kànen te menge otaw aw domateng se pito se omay te bitil dini te Ehipto, amon eked kematay se otaw te bitil.” ");
INSERT INTO mbs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nayan, ontò neluba se selotan aw menge doma opisyal tepad te inikagi i Jose. ");
INSERT INTO mbs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Minikagi se selotan diyà kandan, “Wedad doma otaw ketelaan tadon labi pa mèpiya ki Jose, so egdomaan sikandin te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Minikagi se selotan diyà ki Jose, “So sikona se pinetega-tegahan te Timanem te kedita niyan, wedad palos otaw labi pa biyasa diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Inangen ta den melangkaw diyà te gobirno. Pengkey eden se isogò nikaw, yan se keilangan toloen te kedita te otaw. Olò siaken se labi pa melangkaw diyà kamno, so siak se selotan.” ");
INSERT INTO mbs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Minikagi heman se selotan diyà ki Jose, “Inangen ta den gobirnador dini te kebelad te Ehipto.” ");
INSERT INTO mbs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Penga niyan, inabat te selotan se peningsing din, sìyan pengilala te peglowan din, aw imbegay din iyan ki Jose. Impesaol din te sapot ontò meelagà, aw impepeninga din te bolawan. ");
INSERT INTO mbs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Impesakay din heman diyà te kelisa eggemiten te ontò melangkaw sineligan din, aw doen otaw insogò din doton te peselowan i Jose amon tomawal dan, “Peselangi niyo! Peokiti niyo!” Yan se peg-inang ki Jose gobirnador doton te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Minikagi heman se selotan diyà ki Jose, “Pengkey siak se selotan, meneng wedad palos mepakay inangen dini te kebelad te Ehipto singed aw mepakay iyan diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Sinelilinan te selotan se ngadan i Jose so iningedanan din sikandin ki Sapenat Panea. Pineipidan din ki Asenat, batà i Potiferas. Si Potiferas se egpengibing te menge otaw migsimba te aldaw doton te lonsod te On. Yan ininang si Jose melangkaw doton te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Peg-inang ki Jose opisyal te selotan te Ehipto, ketlowan se omay din. Nesayo sikandin lekat te balay te selotan, aw timeped sikandin te kedita te ogpeanan doton te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Dalem te pito se omay mèpiya, dakel se ginani kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Impeimon i Jose se talad te trigo ginani aw impetagò din iyan doton te menge lonsod. Doen intagò doton te tegsebad-sebad lonsod lekat te kedepagan niyan. ");
INSERT INTO mbs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Se kedakel te trigo intagò, yan se iling te kedakel te enay doton te dagat, so ontò iyan dakel. Yan se doun te impelengà i Jose se pegbilang kenyan so ontò iyan dakel. ");
INSERT INTO mbs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Te wedà pa dateng se bitil, dowa se batà i Jose timebaw diyà ki Asenat. ");
INSERT INTO mbs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iningedanan din se kakay ki Manases (kelebadan niyan, nelibelan), so minikagi si Jose, “Tinebangan a te Timanem aw yan nelibelan ko den se kedakel te kelimahan ko aw tepad te dela ko te amay aw menge gaked ko.” ");
INSERT INTO mbs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Iningedanan din se adi ki Efraim (kelebadan niyan, migmengisù), so minikagi si Jose, “Tinebangan a te Timanem aw yan migmengisù a den dini te tanà te kelimahan ko.” ");
INSERT INTO mbs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Minokit se pito se omay dakel se ginani te tege Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Penga niyan, dimateng se pito se omay te bitil, iling te tapay inikagi i Jose. Nebitilan se menge otaw doton te kedita te doma ogpeanan, meneng doen beling kànen doton te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Pegkeballos te menge tege Ehipto, nemoyò dan te kànen diyà te selotan. Meneng minikagi sikandin, “Doton kaw ki Jose aw tolò kaw te ipunù din kenyo.” ");
INSERT INTO mbs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Neinang labi pa medaet se bayil igsà nebitilan se kedita te tege Ehipto. Penga niyan, impeowang i Jose se kedita te pol tinegoan te trigo, aw impebeligyà din iyan diyà te menge tege Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Medita heman se otaw dimoton te Ehipto lekat te menge doma ogpeanan amon mayad dan te trigo diyà ki Jose, so medaet se bitil doton te kebelad te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nayan, pegketaga-taga i Jacob te doen kànen doton te Ehipto, minikagi sikandin diyà te menge batà din, “Nengà lay olò kaw eg-ogpà? ");
INSERT INTO mbs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Doen ekon kànen doton te Ehipto. Doton kaw bayad amon eked kidon kematay te bitil.” ");
INSERT INTO mbs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yan nesayo se sempolò kedowa i Jose, menge kakay din, aw dimoton dan te Ehipto amon mayad dan te trigo. ");
INSERT INTO mbs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Meneng se ontò kedowa i Jose si Benjamin, yan se wedà petekingi i Jacob te menge kedowa din, so nelemitan si Jacob te medaet se kegemakan i Benjamin. ");
INSERT INTO mbs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Dimoton se menge batà i Jacob te Ehipto sipat te menge doma otaw nengemahà te kànen kidoen, so nebitilan heman se menge tege Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Si Jose se gobirnador kidoen te Ehipto, aw sikandin se nemeligyà te kànen diyà te kedita te otaw lekat te menge doma ogpeanan. Yan pegdateng te menge kedowa i Jose doton te Ehipto, dimoton dan kandin aw limongken dan lamig minapet se olo dan diyà te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pegkità i Jose te menge kedowa din, pengkey kinilala din dan, meneng migpelingo-lingo sikandin te wedà din dan kilelai. Minikagi sikandin te dakel se kagi din, “Kenan kaw lekat?” Timaba dan, “Dimini kay lekat te Canaan amon mayad kay te kànen.” ");
INSERT INTO mbs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Pengkey kinilala i Jose se menge kedowa din, meneng wedà dan kilala te sikandin se kedowa dan adi. ");
INSERT INTO mbs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Neeneng-enengan din se tegeinep din tepad kandan, aw minikagi sikandin, “Kenà. Dimini kaw amon megsimà kaw te kelomayan day amon domaeg kaw kenami.” ");
INSERT INTO mbs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Timaba dan, “Sir, kenà iyan benal. Dimini kay amon mayad kay te kànen. ");
INSERT INTO mbs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Telekedowa se kedita day. Sir, kenà kay egsimà dini, so ontò kay metinuud.” ");
INSERT INTO mbs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Minikagi si Jose, “Kenà. Dimini kaw amon megsimà kaw te kelomayan day amon domaeg kaw kenami.” ");
INSERT INTO mbs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Minikagi dan, “Sir, sempolò teg dowa se kedita day telekedowa, aw sebad olò se amay day eg-ogpà doton te Canaan. Nematay se sebad kedowa day, aw mig-ogpà pa se temanan adi doton te amay day.” ");
INSERT INTO mbs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Meneng minikagi si Jose, “Benal se inikagi ko gina. Dimini kaw amon megsimà kaw kenami. ");
INSERT INTO mbs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Meneng seini se inangen ko amon ketegahan ko aw benal se inikagi niyo. Pineokit te ngadan te selotan, ipunù ko den te eked kaw palos pekeolì lekat dini singed aw domini se adi niyo. ");
INSERT INTO mbs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ipeolì ko se sebad kenyo amon mangay kandin, meneng kelebosowen ko se kedita te doma niyo lamig ketegahan ko aw benal se inikagi niyo. Aw kenà benal se inikagi niyo, yan ketegahan ko te dimini kaw amon megsimà kaw kenami.” ");
INSERT INTO mbs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Penga niyan, impekeleboso din dan te telo se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pegketagkas te telo se aldaw, minikagi si Jose diyà te menge kedowa din, “Egsagman a te Timanem, aw yan eked kaw imetayi aw seini se inangen niyo. ");
INSERT INTO mbs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Aw ontò kaw metinuud, sebad kenyo se kelebosowen pa dini dalem te peg-olì te menge doma mengibing te kànen doton te menge pamilya niyo nebitilan. ");
INSERT INTO mbs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Meneng keilangan ibingen niyo dini kanak se kedowa niyo temanan adi amon ketegahan ko te benal se inikagi niyo, aw yan eked kaw imetayi.” Yan timandù dan kandin. ");
INSERT INTO mbs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Penga niyan, migpebelaw-belaway dan, “Na, dinetengan kidon den te kelimahan seini tandà te medaet ininang tadon diyà te kedowa tadon kedengan. Pegpengenganay din kenitadon, pengkey kinità tadon se kelimahan din, meneng wedà tadon sikandin penenelani. Yan se doun te dinetengan kidon te kelimahan seini.” ");
INSERT INTO mbs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Minikagi si Ruben, “Minikagi a diyà kenyo te eked niyo sikandin peelegi, meneng wedà a niyo penenelani. Yan se doun te nelimahan kidon seini tandà te pegkematay din.” ");
INSERT INTO mbs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nekelabet si Jose te kedita te inikagi dan, meneng wedà dan iyan ketegahi, so doen telesogpat mig-obad te kagi dan Hebreo diyà ki Jose, aw mig-obad heman te kagi din Ehipto diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Penga niyan, nesayo si Jose lekat kandan te wedà kenamay, so migkelag sikandin. Penga niyan, limikò sikandin doton kandan, aw minikagi diyà kandan. Pinemallì din si Simeon, aw impebakwì din sikandin kinità te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Doen sineligan insogò i Jose meg-ipenò te sako te kedowa din te trigo. Migpunù heman si Jose kandin te ieles din se kwarta imbayad dan diyà te sako te tegsebad-sebad kandan. Impebegay din heman kandan se kànen dan diyà te dalan. Yan se ininang din diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Penga niyan, miglolan dan te sako te trigo diyà te menge ayam-ayam dan asno, aw nesayo dan. ");
INSERT INTO mbs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pegkedelem, minapit dan amon midegà. Doen sebad kandan mig-okal te sako din amon ipekaen se asno din, aw kinità din se kwarta diyà didalem te sako imbayad din te trigo. ");
INSERT INTO mbs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Timawal sikandin diyà te menge kedowa din, “Dini kedì didalem te sako se kwarta imbayad ko te trigo. In-olì besi iyan diyà kanak.” Pegdineg dan kenyan, ontò migpeso se pedowan dan, aw migpeinsaay dan, “Eden lebò se pelumun te Timanem kenitadon seini?” ");
INSERT INTO mbs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Peg-olì dan doton te amay dan kidoen te Canaan, in-indan dan diyà kandin se kedita te negemakan dan. ");
INSERT INTO mbs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Minikagi dan, “Nenompelà se gobirnador te Ehipto kenami, aw minikagi sikandin te dimoton kay amon megsimà aw domaeg kay kandan. ");
INSERT INTO mbs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Timaba kay te kenà iyan benal, so metinuud kay. ");
INSERT INTO mbs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Mig-indan kay kandin te sempolò teg dowa se kedita day telekedowa aw sebad olò se amay day. Nematay son day se sebad kedowa day, aw mig-ogpà pa se temanan adi doton te amay day kidoen te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Meneng minikagi se gobirnador diyà kenami, ‘Seini se inangen ko amon ketegahan ko aw metinuud kaw. Sebad kenyo se kelebosowen pa dini, dalem te peg-olì te menge doma niyo amon mengibing te kànen doton te menge pamilya niyo nebitilan. ");
INSERT INTO mbs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ibingi niyo dini kanak se kedowa niyo temanan adi amon ketegahan ko te kenà kaw egsimà, meneng metinuud kaw. Yan ipelowà ko se kedowa niyo, aw mepakay kaw mayad dini te Ehipto.’” ");
INSERT INTO mbs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Penga niyan te peg-awak dan te trigo lekat te menge sako dan, kinità te tegsebad-sebad kandan se kwarta imbayad dan kenyan. Pegkità dan te kwarta, nelemitan si Jacob aw kedita te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Minikagi se amay dan diyà kandan, “Pineokit kenyo, eg-ebaten se kedita te batà ko lekat kanak. Wedad den si Jose, wedad den heman si Simeon, aw ibeg niyo ebaten heman si Benjamin lekat kanak. Ontò a egdetengan te kelimahan.” ");
INSERT INTO mbs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Minikagi si Ruben diyà te amay din, “Seligi si Benjamin diyà kanak, aw iolì ko sikandin dini kamno. Aw eked ko sikandin keolì, imetayi se dowa batà ko meama.” ");
INSERT INTO mbs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Meneng minikagi si Jacob, “Eked kepakay diyà kanak aw tomaking si Benjamin kenyo, so nematay se kakay din, aw sikandin olò se nesamà. Ontò a den temoay. Megmeno a aw detengan sikandin te medaet diyà te dalan? Aw matay sikandin, matay a heman tandà te lano ko kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nayan, neinang labi pa medaet se bitil doton te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pegkeamin te kedakel te trigo inabat dan doton te Ehipto, minikagi si Jacob diyà te menge batà din, “Likò kaw den amon beyadan niyo se mekaen tadon.” ");
INSERT INTO mbs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Timaba si Juda, “Migpunù se otaw doton te eked kay pekelikò doton kandin singed aw tomaking se kedowa day temanan adi. ");
INSERT INTO mbs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aw ipetaking no sikandin, lomikò kay doton amon mayad kay te kànen nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Meneng aw eked no sikandin petekingi, eked kay likò, so minikagi se otaw doton te eked kay pekelikò doton kandin singed aw tomaking se kedowa day temanan adi.” ");
INSERT INTO mbs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Minikagi si Jacob doma ngadan din si Israel, “Nengà lay mig-inang kaw kanak te medaet pineokit te peg-indan niyo kandin te doen pa kedowa niyo?” ");
INSERT INTO mbs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Timaba dan, “Gayed sikandin mig-insà tepad kenitadon aw tepad te pamilya tadon. Mig-insà sikandin, ‘Wedà lay pa kematay se amay niyo? Doen lay pa doma kedowa niyo?’ Olò kay timaba te menge insà din. Wedà kay palos peg-aneng-aneng te tomogon sikandin te keilangan ibingen day doton se kedowa day.” ");
INSERT INTO mbs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Minikagi si Juda diyà te amay din, “Seligi si Benjamin diyà kanak, aw mesayo kay den seini amon eked kematay se kedita tadon te bitil sipat te menge mengisù dini kenitadon. ");
INSERT INTO mbs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Megsapà a den kamno te siaken se megbantay kandin amon wedad megpeeleg kandin. Aw eked ko sikandin keolì dini kamno, yan se salà ko kamno te wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Aw wedà kay nikaw keanggà, mekedowa kay den peden likò.” ");
INSERT INTO mbs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Minikagi se amay dan, “Aw yan se keilangan inangen, mèpiya aw ibingen niyo heman se menge mèpiya pongo lekat dini amon doen ibowang niyo diyà te gobirnador, deitek alay aw teneb, menge enagay, aw pongo te kayo pistasio aw almendras. ");
INSERT INTO mbs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Doblihi se kwarta ibingen niyo, so keilangan ilikò niyo se kwarta insawol diyà te sako niyo. Kemalì besi iyan. ");
INSERT INTO mbs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Petekingi niyo heman se kedowa niyo, aw kegaen kaw likò. ");
INSERT INTO mbs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ibeg ko tebangan kaw te Timanem amon keidowan kaw te otaw doton aw ipeolì din si Benjamin aw si Simeon. Nayan tepad kanak, aw keilangan kemetayan a te menge batà ko, aw den iyan.” ");
INSERT INTO mbs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Penga niyan, inibing dan se menge ibowang, aw dobli se kwarta dan, aw dimoton dan te Ehipto sipat si Benjamin. Pegdateng dan, dimoton dan ki Jose. ");
INSERT INTO mbs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Pegkità i Jose te timaking si Benjamin kandan, minikagi sikandin diyà te sineligan din, “Ibingi se menge otaw sìyan doton te balay ko. Pengiyaw ka te ayam-ayam aw peg-elomo ka te kànen, so komaen dan doma ko te alas dosi.” ");
INSERT INTO mbs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Timolò se sineligan aw inibing din dan doton te balay i Jose. ");
INSERT INTO mbs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pegketaga-taga dan te balay i Jose se ibingan kandan, nelemitan dan, aw migpebelaw-belaway dan, “Ibingen kidon doton tandà te kwarta in-olì diyà te sako tadon kedengan. Dekepen kidon besi kwani, aw egawen se menge asno tadon, aw inangen kidon allang din.” ");
INSERT INTO mbs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yan pegdateng dan doton te lelebangan te balay, minikagi dan diyà te sineligan, ");
INSERT INTO mbs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Sir, penenalan ka kenami. Dimini kay kedengan amon mayad kay te kànen. ");
INSERT INTO mbs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Meneng peg-idegà day diyà te dalan te peg-olì day, mig-okal kay te sako day, aw kinità day se kwarta imbayad te tegsebad-sebad kenami te kànen doton te lanto te trigo didalem te sako. Kidoen se kedakel niyan. Todà day heman inibing amon iolì day. ");
INSERT INTO mbs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Inibing day den heman se doma kwarta ibayad te kànen. Wedà day ketegahi aw sinu se migsawol te kwarta diyà te sako day kedengan.” ");
INSERT INTO mbs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Minikagi se sineligan, “Ikà niyo egketetana. Ikà niyo egkelemitan. Se Timanem egseligan niyo aw egseligan te amay niyo, yan besi se migsawol te kwarta diyà te sako niyo. Kininawà ko se imbayad niyo.” Penga niyan, inibing din si Simeon doton kandan. ");
INSERT INTO mbs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Impeawop din dan doton te balay i Jose, aw inibing din se wayeg ionaw te benis dan. Impekaen din heman se menge asno dan. ");
INSERT INTO mbs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Inokal dan se bowang ibegay dan ki Jose te pegdateng din te alas dosi, so inikegiyan dan te komaen dan doma kandin. ");
INSERT INTO mbs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Peg-olì i Jose, imbegay dan kandin se bowang inibing dan, aw limongken dan lamig minapet se olo dan diyà te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mig-insà sikandin tepad te pegkesawol dan. Mig-insà heman sikandin, “Mèpiya lay se pegkesawol te amay niyo, sìyan temoay in-indan niyo kanak kedengan? Wedà lay pa sikandin kematay?” ");
INSERT INTO mbs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Timaba dan, “Sir, wedà pa kematay se amay day, meneng mèpiya pa se pegkesawol din.” Penga niyan, limongken dan aw migsagman dan kandin. ");
INSERT INTO mbs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pegkità i Jose te kedowa din adi si Benjamin, minikagi sikandin, “Sìyan lebò se kedowa niyo temanan adi in-indan niyo kanak kedengan.” Minikagi heman si Jose diyà ki Benjamin, “Atò, ibeg ko keidowan ka te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Penga niyan, agpet migkelag si Jose, so dakel se pedowan din diyà te adi din, aw yan tigkan sikandin nesayo. Dimoton sikandin te tambì din aw migkelag kidoen. ");
INSERT INTO mbs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pegkenamay-namay, migdàpog sikandin aw limikò doton te menge kedowa din. Tinemengan din se pedowan din, aw migpelamak te kànen. ");
INSERT INTO mbs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tinani se kènanan dan, so sebad se lemisa i Jose, aw sebad se lemisa te menge kedowa din, aw sebad heman se lemisa te menge tege Ehipto kimaen kidoen, so eked keibeg se menge tege Ehipto komaen doma te menge Hebreo, so eglindoan te menge tege Ehipto se menge Hebreo. ");
INSERT INTO mbs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Impepenenoo i Jose se tegsebad-sebad kedowa din, lekat te kakay dan taman te adi. Pegkità dan te pegtapid din kandan, migpetengtengay dan tandà te kepela dan. ");
INSERT INTO mbs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Impeibing i Jose se kànen lekat te lemisa din doton te menge kedowa din, meneng lima dobli se kedakel te kànen impeibing din diyà ki Benjamin. Dakel heman se ininem dan, aw neluba dan. ");
INSERT INTO mbs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nayan, insogò i Jose se sineligan din, kagi din, “Ipenoi se menge sako dan te trigo taman te mebatog ibingen te menge asno dan, aw elesi heman se kwarta imbayad dan didalem te sako te tegsebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Soli se tabò ko selapì diyà te sako te temanan adi, sipat te kwarta imbayad din te kànen.” Yan timolò se sineligan te impunù i Jose kandin. ");
INSERT INTO mbs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pegkeiselem niyan, impekesayo se menge kedowa i Jose aw menge asno dan. ");
INSERT INTO mbs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Te wedà dan pa pekeipanaw te mediyò lekat te lonsod, minikagi si Jose diyà te sineligan din, “Ayas ka peg-alaw kandan. Aw mekesaeb ka kandan, peg-insà ka, ‘Nengà lay mig-inang kaw te medaet diyà te otaw mig-inang te mèpiya diyà kenyo? ");
INSERT INTO mbs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nengà lay nenakaw kaw te tabò selapì te amo ko? So yan se eg-ineman din, aw eggemiten din te peg-etok. Ontò medaet se ininang niyo.’” ");
INSERT INTO mbs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Pegkesaeb te sineligan kandan, minikagi sikandin te impunù i Jose kandin. ");
INSERT INTO mbs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Meneng timaba dan, “Sir, nengà lay minikagi ka kenyan? Megsapà kay te wedad ininang day iling kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Pengkey sìyan kwarta kinità day diyà te sako day doton te Canaan, in-olì day den iyan diyà kamno. Nengà lay menakaw kay te selapì aw bolawan lekat te balay te amo nikaw? ");
INSERT INTO mbs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Sir, aw kitaen no te tinakaw iyan te otaw doma day, mepakay aw imetayan no sikandin, aw inangen no heman se kedita day menge allang nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Timaba se sineligan, “Mèpiya se inikagi niyo, meneng olò otaw nenakaw te tabò se inangen ko allang, aw mekelowà se doma.” ");
INSERT INTO mbs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Penga niyan, ayas dan inawas se sako dan aw mig-okal se tegsebad-sebad kandan kenyan. ");
INSERT INTO mbs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ontò nengemahà se sineligan diyà te sako te tegsebad-sebad kandan lekat te kakay taman te adi, aw kinità din se tabò diyà te sako i Benjamin. ");
INSERT INTO mbs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yan miglisì se kedita dan te saol dan tandà te puluk dan. Todà dan miglolan te menge sako diyà te menge asno, aw limikò dan doton te lonsod. ");
INSERT INTO mbs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pegdateng i Juda aw menge kedowa din doton te balay i Jose, kidoen pa sikandin. Tigkan dan limongken taman te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Minikagi si Jose, “Nengà lay mig-inang kaw te medaet seini? Wedà kaw besi ketaga-taga te mebatog ko kitaen se ininang niyo pineokit te peg-etok.” ");
INSERT INTO mbs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Timaba si Juda, “Sir, megmeno kay? Iling te wedad itaba day te inikagi nikaw. Impekità den te Timanem te benal doen salà day. Kedita day se meinang allang nikaw sipat sikandin kinitaan no te tabò.” ");
INSERT INTO mbs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Meneng minikagi si Jose, “Eked a. Eked a keibeg kenyan. Olò otaw kinitaan te tabò se inangen ko allang. Meneng mepakay aw molì se menge doma doton te amay niyo.” ");
INSERT INTO mbs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Penga niyan, migpedapag si Juda diyà ki Jose aw minikagi sikandin, “Sir, aw mepakay diyà kamno, ibeg ko mikagi a peden diyà kamno. Ikà bag egkeopal diyà kanak. Onawa te kelangkaw te selotan se kelangkaw nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sir, kedengan mig-insà ka diyà kenami aw doen amay day aw kedowa day. ");
INSERT INTO mbs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Timaba kay te doen amay day temoay, aw doen adi day timebaw te pegketemoay te amay day. Sikandin olò se nesamà diyà te dowa batà te inay din, so nematay se kakay din. Ontò sikandin egkedekelan te amay day te pedowan. ");
INSERT INTO mbs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sir, timogon ka kenami te keilangan ibingen day sikandin dini kamno amon komità ka kandin. ");
INSERT INTO mbs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Minikagi kay diyà kamno te eked sikandin peketanan te amay day, so aw tomanan sikandin, matay se amay day. ");
INSERT INTO mbs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Penga niyan, minikagi ka te eked kay pekelikò dini kamno singed aw ipetaking day se kedowa day temanan adi. ");
INSERT INTO mbs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Peg-olì day doton te amay day, mig-indan kay kandin tepad te inikagi nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Nayan, doen aldaw minikagi se amay day te keilangan lomikò kay dini amon mayad kay te kànen. ");
INSERT INTO mbs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Meneng minikagi kay te eked iyan kepakay, so eked kay likò singed aw tomaking se adi day. Aw tomaking sikandin, yan lomikò kay. ");
INSERT INTO mbs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Penga niyan, minikagi se amay day diyà kenami, ‘Netegahan niyo,’ son din, ‘te olò dowa se batà ko timebaw diyà te esawa ko si Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Nemetayan a den te sebad. Inimetayan besi sikandin te mebolot menenanap te kebenesan, aw wedà ko palos todà kitai. ");
INSERT INTO mbs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aw ibingen niyo den se adi niyo aw matay sikandin, matay a heman tandà te lano ko kandin, so ontò a den temoay.’ ");
INSERT INTO mbs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Nayan Sir, aw eked taking se adi day te peg-olì day, aw komità se amay day te wedà olì, matay sikandin, so ontò dakel se pedowan din diyà te batà din sìyan. Yan pineokit kenami, matay se amay day tandà te lano din. ");
INSERT INTO mbs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Siaken heman, migsapà a diyà te amay ko te siak se megbantay te adi day amon wedad megpeeleg kandin. Minikagi a, aw eked ko keolì se adi day doton kandin, yan se salà ko kandin te wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Nayan Sir, peogpai a bag dini kamno amon inangen a no allang iselilin kandin. Peolii bag sikandin sipat te menge doma kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Eked a olì doton te amay ko aw eked taking se adi day. Eked a keibeg komità te kegemakan domateng diyà te amay ko.” ");
INSERT INTO mbs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nayan, wedà ketemengi i Jose se pedowan din, aw yan impekesayo din se kedita te sineligan din amon eked dan kità kandin. Wedad doma otaw kidoen dalem te pegpekilala i Jose diyà te menge kedowa din. ");
INSERT INTO mbs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ontò migkelag si Jose igsà dinineg iyan te menge tege Ehipto doton te lowà, aw inindanan heman se menge otaw doton te balay te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Minikagi si Jose diyà te menge kedowa din, “Siaken si Jose. Mèpiya lay pa se pegkesawol te amay ko?” Meneng pegdineg te menge kedowa din kenyan, wedà dan peketaba kandin tandà te peso dan. ");
INSERT INTO mbs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Penga niyan, minikagi si Jose, “Pegpedapag kaw diyà kanak.” Pegpedapag dan diyà kandin, minikagi heman si Jose, “Siaken se kedowa niyo si Jose imbeligyà niyo, aw inibing a dini te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na, ikà niyo egketetana. Ikà niyo egkepuluk tepad te pegbeligyà niyo kanak, so impeonà a te Timanem dini amon eked kaw kematay. ");
INSERT INTO mbs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dowa den se omay te bitil, meneng lima mendad se omay wedad geniyen diyà te pawà. ");
INSERT INTO mbs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Insogò a te Timanem dini amon megtabang a kenyo, so ibeg din eked kaw kematay te bitil amon meantay kaw aw menge bowad-bowad niyo. ");
INSERT INTO mbs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kenà niyo se migsawol kanak dini, meneng Timanem se migsawol kanak dini. Ininang a din melangkaw diyà te menge opisyal te selotan. Siak se egsogò te kedita te sineligan te selotan, aw siak heman se eglowan dini te kebelad te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Kegaen kaw den olì doton te amay tadon, aw peg-indan kaw kandin, ‘Seini se inikagi te batà no si Jose. Impelowan a den te Timanem dini te kebelad te Ehipto. Keilangan meg-ayas kaw dini kanak. ");
INSERT INTO mbs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ipeogpà ta sikiyo dini te Gosen, amon medapag se kedita niyo diyà kanak, pengkey sikona, aw menge batà nikaw, menge apò nikaw, aw menge karniro aw menge kambing, aw menge baka, aw kedita te kedònan nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aw meg-ogpà kaw dini te Gosen, ipaten ta sikiyo. Lima mendad se omay te bitil, aw eked a keibeg aw kelimahan ka, aw menge batà nikaw, aw menge ayam-ayam nikaw.’” ");
INSERT INTO mbs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Minikagi heman si Jose, “Nayan, kedita niyo menge kakay ko, aw sikona heman Benjamin, kimilala kaw den te ontò a si Jose. ");
INSERT INTO mbs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Indani niyo se amay tadon tepad te kelangkaw ko dini te Ehipto aw tepad te kedita te kinità niyo dini. Na, kegaen kaw den, aw ibingi niyo sikandin dini.” ");
INSERT INTO mbs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Penga niyan, kimeles si Jose te adi din si Benjamin, aw migkelag. Migkelag heman si Benjamin te pegkeles din ki Jose. ");
INSERT INTO mbs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Penga niyan, kimeles heman si Jose te tegsebad-sebad kandan, aw nengadek sikandin kandan, aw migkelag. Penga niyan, nekeikagi se menge kedowa i Jose diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pegdineg te selotan te dimateng den se menge kedowa i Jose, neluba sikandin aw kedita te menge opisyal din. ");
INSERT INTO mbs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Minikagi se selotan diyà ki Jose, “Sogoi se menge kedowa no meglolan te karga diyà te menge asno dan aw molì dan doton te Canaan, ");
INSERT INTO mbs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","amon engayen dan se amay niyo aw menge pamilya dan aw lomikò dan dini. Ipeogpà ko dan diyà te mèpiya tanà dini te Ehipto, aw ontò mèpiya se kànen dan dini. ");
INSERT INTO mbs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Begayi dan heman te menge keriton lekat dini amon doen sekayan te menge esawa aw mengisù dan. Keilangan ibingen dan heman dini se amay niyo. ");
INSERT INTO mbs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ikegihi dan te keilangan eked dan ketetana tepad te kedònan dan tenanan doton, so begayan dan te ontò mèpiya dini te Ehipto.” ");
INSERT INTO mbs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yan se ininang te menge batà i Jacob. Doen menge keriton imbegay i Jose kandan iling te inikagi te selotan diyà kandin, aw doen heman kànen dan diyà te dalan imbegay din kandan. ");
INSERT INTO mbs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Doen heman mèpiya ekasan imbegay i Jose diyà te tegsebad-sebad kandan, meneng si Benjamin se binegayan din te kwarta telo gatos plata selapì aw lima se ekasan. ");
INSERT INTO mbs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Doen heman impeibing i Jose doton te amay din, sempolò asno linolanan te mèpiya kemolò te kedònan lekat te Ehipto, aw sempolò heman se doma asno linolanan te trigo, aw pan, aw menge doma kemolò te kànen amon doen kànen din diyà te dalan. ");
INSERT INTO mbs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Penga niyan, minikagi si Jose diyà te menge kedowa din, “Ikà niyo egbolaw diyà te dalan.” Yan impekesayo din dan. ");
INSERT INTO mbs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nesayo dan lekat te Ehipto, aw minolì dan doton te amay dan si Jacob kidoen te Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Minikagi dan diyà kandin, “Neantay pa si Jose, aw eglowan sikandin doton te kebelad te Ehipto.” Ontò nepela si Jacob, so iling te eked din iyan pemenali. ");
INSERT INTO mbs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Meneng peg-indan dan kandin tepad te kedita te inikagi i Jose, aw pegkità din te menge keriton impeibing i Jose amon sekayan din pesalo doton te Ehipto, yan neantay se pedowan din. ");
INSERT INTO mbs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Minikagi sikandin, “Nemenal a den te neantay pa se batà ko si Jose. Wedad den doma ibeg ko. Keilangan domoton a den amon komità a kandin te eked a pa kematay.” ");
INSERT INTO mbs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nayan, miglolan si Jacob te kedakel te kedònan din, aw nesayo dan lekat te Canaan. Pegdateng dan doton te Berseba, doen ayam-ayam inimetayan i Jacob aw sinonog din amon segmanen din se Timanem iling te pegsagman te amay din si Isaac te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Migpekità se Timanem diyà kandin te delem, aw timawal sikandin, “E Jacob.” Timaba si Jacob, “Ee, seini a.” ");
INSERT INTO mbs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Minikagi sikandin, “Siaken se Timanem. Siaken se Timanem egseligan te amay no gebii. Ikà egkelemitan te pegdoton no te Ehipto, so doton te Ehipto inangen ko se menge bowad-bowad nikaw ontò melangkaw pongan. ");
INSERT INTO mbs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Domoma a kenyo te pegdoton niyo te Ehipto, aw ibingen ko heman se menge bowad-bowad nikaw molì dini te Canaan. Aw matay ka, si Jose se meglebeng kamno.” ");
INSERT INTO mbs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Penga niyan, dimeleg dan si Jacob lekat te Berseba. Impesakay sikandin te menge batà din diyà te keriton impeibing te selotan te Ehipto. Impesakay dan heman se menge mengisù aw menge esawa dan. ");
INSERT INTO mbs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Inibing dan heman se menge ayam-ayam dan aw menge kedònan inabat dan doton te Canaan, aw dimoton dan te Ehipto. Impetaking i Jacob se kedita te menge bowad-bowad din, ");
INSERT INTO mbs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","menge batà din meama aw bayi, aw menge apò din heman meama aw bayi. ");
INSERT INTO mbs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Na, seini se menge ngadan te bowad-bowad i Jacob timaking kandin doton te Ehipto. Si Ruben se kakay batà i Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Timaking si Ruben aw menge batà din meama si Hanoc, si Pallu, si Hesrom, aw si Carmi. ");
INSERT INTO mbs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Si Simeon aw menge batà din meama si Jemuel, si Jamin, si Ohad, si Jakin, si Sokar, aw si Saul batà te bayi tege Canaan. ");
INSERT INTO mbs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Si Levi aw menge batà din meama si Gerson, si Cohat, aw si Merari. ");
INSERT INTO mbs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Si Juda aw menge batà din meama si Selas, si Peres, aw si Seras. (Nematay doton te Canaan se doma batà i Juda si Er aw si Onan.) Doen batà meama i Peres si Hesron aw si Hamul. ");
INSERT INTO mbs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Si Isacar aw menge batà din meama si Tolas, si Puas, si Jasub, aw si Simron. ");
INSERT INTO mbs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Si Sabulon aw menge batà din meama si Sered, si Elon, aw si Jaleel. ");
INSERT INTO mbs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yan se menge batà meama i Jacob timebaw diyà ki Lea doton te Mesopotamya. Doen heman batà dan bayi si Dina. Ketlowan teg telo se menge bowad-bowad i Jacob aw si Lea. ");
INSERT INTO mbs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Timaking heman si Gad aw menge batà din meama si Sifeon, si Hagi, si Suni, si Esbon, si Eri, si Arod, aw si Areli. ");
INSERT INTO mbs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Si Aser aw menge batà din meama si Imnas, si Iskas, si Isvi, si Berias, aw etebay dan si Sera. Doen batà meama i Berias si Eber aw si Melkiel. ");
INSERT INTO mbs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sempolò teg enem se kedita dan menge bowad-bowad i Jacob aw si Zilfa, sìyan allang imbegay i Laban diyà te batà din si Lea. ");
INSERT INTO mbs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dowa se batà i Jacob timebaw diyà te esawa din si Raquel, ngadan dan si Jose aw si Benjamin. ");
INSERT INTO mbs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dowa se batà meama i Jose timebaw doton te Ehipto, si Manases aw si Efraim. Yan se batà i Jose aw si Asenat, batà i Potiferas, sìyan egpengibing te menge otaw migsimba te aldaw doton te lonsod te On. ");
INSERT INTO mbs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Doen menge batà meama i Benjamin si Belas, si Betser, si Asbel, si Geras, si Naaman, si Ehi, si Ros, si Mufim, si Hufim, aw si Ared. ");
INSERT INTO mbs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Sempolò teg epat se kedita dan menge bowad-bowad i Jacob aw si Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Timaking heman si Dan aw batà din meama si Husim. ");
INSERT INTO mbs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Si Neftali aw menge batà din meama si Jaseel, si Guni, si Jeser, aw si Selem. ");
INSERT INTO mbs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Pito se kedita dan menge bowad-bowad i Jacob aw si Bilha, sìyan allang imbegay i Laban diyà te batà din si Raquel. ");
INSERT INTO mbs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Keneman teg enem se kedita te menge bowad-bowad i Jacob dimoton te Ehipto. Wedà pesipati diyà te bilang se menge esawa te batà din. ");
INSERT INTO mbs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Dowa se batà i Jose timebaw doton te Ehipto, aw yan kepitowan se kedita dan diyà te pamilya i Jacob te pegdoton din te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nayan, insogò i Jacob si Juda monà kandin domoton ki Jose, so ibeg din songonen dan i Jose doton te Gosen. Pegdateng dan doton, ");
INSERT INTO mbs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","simakay si Jose te kelisa din, aw dimoton sikandin te Gosen amon somongon te amay din. Pegdateng din, kinelesan din se amay din, aw migkelag te ontò nenamay. ");
INSERT INTO mbs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Minikagi si Jacob diyà ki Jose, “Mepakay den kanak aw matay a, so kimità a den kamno aw netegahan ko den te neantay ka pa.” ");
INSERT INTO mbs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Penga niyan, minikagi si Jose diyà te menge kedowa din aw menge doma otaw diyà te pamilya te amay din, “Domoton a den te selotan amon meg-indan a kandin te dimateng den lekat te Canaan se kedita niyo menge kedowa ko aw menge doma otaw diyà te pamilya te amay ko. ");
INSERT INTO mbs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Meg-indan a kandin te telediyaga kaw, aw egtonggò kaw te menge ayam-ayam, aw inibing niyo den se kedita te karniro niyo aw menge doma ayam-ayam niyo, aw kedakel te kedònan niyo. ");
INSERT INTO mbs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Aw tewalen kaw te selotan, aw insaen kaw din aw eden se eg-inangen niyo, ");
INSERT INTO mbs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","keilangan meg-indan kaw kandin te telediyaga kaw lekat te pegkemengisù niyo, iling te eg-inangen te menge kemonaan niyo gebii. Doun niyan, ipeogpà kaw din doton te Gosen.” Yan se inikagi i Jose diyà kandan, so eglindoan te menge tege Ehipto se telediyaga. ");
INSERT INTO mbs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Penga niyan, impetaking i Jose se lima kedowa din, aw dimoton dan te selotan. Minikagi si Jose, “Dimateng den se amay ko aw menge kedowa ko lekat te Canaan, sipat te kedita te karniro aw doma ayam-ayam dan aw kedakel te kedònan dan. Kidoen den dan te Gosen.” Penga niyan, impekilala din se lima kedowa din diyà te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mig-insà se selotan diyà kandan, “Eden lay se eg-inangen niyo?” Timaba dan, “Sir, telediyaga kay, iling te eg-inangen te menge kemonaan day gebii. ");
INSERT INTO mbs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Dimini kay so ontò medaet se bitil doton te Canaan igsà wedad palos mekaen te menge ayam-ayam day. Aw mepakay diyà kamno, peogpai kay doton te Gosen.” ");
INSERT INTO mbs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Minikagi se selotan diyà ki Jose, “Mèpiya so dimateng den se amay nikaw aw menge kedowa nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Sikona se eglowan diyà te kebelad te Ehipto. Peogpai dan doton te Gosen, so yan se ontò mèpiya tanà. Aw doen otaw diyà kandan ontò biyasa egdiyaga, petonggoi kandan se kenaken menge ayam-ayam.” ");
INSERT INTO mbs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Penga niyan, inibing i Jose se amay din si Jacob doton te selotan. Migtawal-tawal si Jacob amon mèpiya se ibegay te Timanem kandin, ");
INSERT INTO mbs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","aw mig-insà se selotan diyà kandin, “Pila lay se omay nikaw?” ");
INSERT INTO mbs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Timaba si Jacob, “Sebad gatos ketlowan se omay ko. Pilabok olò se omay sìyan, aw melima se neokitan ko. Wedà pa apet se omay ko te omay te menge kemonaan ko.” ");
INSERT INTO mbs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Todà migtawal-tawal si Jacob amon mèpiya se ibegay te Timanem diyà te selotan, aw penga niyan, nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Impeogpà i Jose se amay din aw menge kedowa din doton te Ehipto. Ontò mèpiya se tanà imbegay din kandan medapag te lonsod te Ramases, iling te impunù te selotan kandin. ");
INSERT INTO mbs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Doen heman kànen imbegay i Jose diyà te amay din, aw menge kedowa din, aw menge doma otaw diyà te pamilya te amay din sipat te menge mengisù dan. ");
INSERT INTO mbs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ontò medaet se bitil igsà wedad palos kànen pengkey kenan. Nebitilan se kedita te otaw doton te Ehipto aw Canaan so binallos dan. ");
INSERT INTO mbs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Minayad dan te trigo diyà ki Jose, aw inibing din se kedakel te kwarta imbayad dan kenyan doton te balay te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pegkeamin te kedakel te kwarta doton te kebelad te Ehipto aw Canaan, dimoton se menge tege Ehipto ki Jose, aw minikagi dan, “Begayi kay bag te kànen, so agpet kay den matay. Tebangi kay, so wedad den kànen day aw neamin den se kwarta day.” ");
INSERT INTO mbs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Minikagi si Jose, “Aw neamin den se kwarta niyo, ibingi niyo diyà se menge ayam-ayam niyo, so yan se mepakay niyo iliwan te kànen diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Yan inibing dan se menge ayam-ayam dan doton ki Jose, menge kodà dan, menge karniro, kambing, baka, aw asno dan. Yan se imbayad dan te kànen diyà ki Jose. Imbegay din kandan se kànen te omay sìyan liniwanan dan te kedita te ayam-ayam dan. ");
INSERT INTO mbs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pegkepenga te omay sìyan, limikò dan doton ki Jose aw minikagi dan, “Sir, benal se kagi day kamno te neamin se kwarta day, aw tinig-apò no den se kedita te ayam-ayam day. Wedad den ibegay day kamno, olò pawà day aw lawa day se nesamà. ");
INSERT INTO mbs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Aw eked ka pegtabang kenami, matay kay aw kebàtan se pawà day. Lawa day aw pawà se iliwan day te kànen. Mepakay aw inangen kay allang te selotan, aw ibegay day se tanà diyà kandin. Meneng begayi kay bag olò te trigo amon eked kay kematay aw amon doen itanem day diyà te pawà.” ");
INSERT INTO mbs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Penga niyan, bineyadan i Jose se kedita te tanà kidoen te Ehipto amon tig-epoen iyan te selotan. Nemeligyà se kedita te tege Ehipto te tanà dan so ontò medaet se bitil, aw yan neinang se selotan tig-apò te kedakel te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Neinang allang te selotan se kedita te otaw kidoen te kebelad te Ehipto tandà te ininang i Jose. ");
INSERT INTO mbs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Meneng wedà din beyadi se tanà tinig-apò te menge egpengibing te menge otaw egsimba te aldaw doton te Ehipto. Wedà dan beligyai se tanà dan so egtogpoan dan te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Minikagi si Jose diyà te menge otaw, “So bineyadan kaw den te selotan sipat te tanà niyo, ibegay ko den kenyo se benì ipanggas niyo. ");
INSERT INTO mbs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aw doen geniyen niyo, keilangan ibegay niyo se tengà te lima diyà te selotan. Kenyo se samà amon doen benì ipanggas niyo aw amon doen kànen niyo aw menge pamilya niyo.” ");
INSERT INTO mbs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Timaba dan, “Tandà te tabang nikaw kenami, eked kay den kematay. Sir, ontò mèpiya se ininang no kenami, aw yan meinang kay menge allang te selotan.” ");
INSERT INTO mbs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yan migpunù si Jose doton te Ehipto te keilangan ibegay dan diyà te selotan se tengà te lima diyà te kedakel te geniyen dan, aw yan se punù egtoloen dan lamig songkani. Olò tanà te menge egpengibing te simbahan dan se wedà ketig-apò te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mig-ogpà se menge bowad-bowad i Jacob (doma ngadan din si Israel) kidoen te Gosen doton te Ehipto, aw yan neinang dakel se kedònan dan kidoen, aw ontò migkedita se mengisù dan. ");
INSERT INTO mbs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Mig-ogpà si Jacob doton te Ehipto te sempolò teg pito se omay, lamig minapet te sebad gatos kepatan teg pito se omay din. ");
INSERT INTO mbs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Pegdateng te aldaw te agpet den sikandin matay, tinawal i Jacob se batà din si Jose, aw minikagi sikandin, “Soli se belad nikaw diyà te salad te bobon ko amon ketegahan ko te tomanen no se ipunù ko kamno seini. Pegpakang ka kanak te eked no lebengi se lawa ko dini te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ibeg ko ilebeng beling se lawa ko doton te lebenganan doma te menge kemonaan ko. Yan ibingi se lawa ko lekat dini te Ehipto, aw lebengi a doton te linebengan kandan.” Minikagi si Jose, “Ee. Toloen ko se impunù no kanak.” ");
INSERT INTO mbs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Minikagi si Jacob, “Pegsapà ka kanak te yan se inangen nikaw.” Yan migsapà si Jose. Penga niyan, timikelong si Jacob kidoen te katri din, aw migpesiontong sikandin diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Doen sebad aldaw, inindanan si Jose te nesekitan se amay din. Yan impetaking din se dowa batà din si Efraim aw si Manases, aw dimoton dan ki Jacob. ");
INSERT INTO mbs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Inindanan si Jacob te dimateng se batà din si Jose, aw yan migkagsen sikandin aw minenaw diyà te katri din. ");
INSERT INTO mbs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Minikagi si Jacob diyà ki Jose, “Kedengan, migpekità se Timanem metolos diyà kanak kidoen te Luz doton te Canaan, aw mèpiya se impakang din kanak. ");
INSERT INTO mbs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Minikagi sikandin, ‘Medita se batà ibegay ko kamno amon meinang medita pongan se menge bowad-bowad nikaw. Ibegay ko se tanà dini te Canaan diyà te menge bowad-bowad nikaw amon tig-epoen dan ini te wedad temanan.’” ");
INSERT INTO mbs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Minikagi heman si Jacob, “Se didowa batà nikaw timebaw dini te Ehipto te wedà a pa alin dini, yan se sekopen ko diyà te menge batà ko. Inangen ko kanak batà si Efraim aw si Manases, onawa te ontò batà ko si Ruben aw si Simeon. ");
INSERT INTO mbs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Aw betaen no pa se doma, eked ko dan sekopi, meneng tepad te tanà kinewaen te menge bowad-bowad ko te pegkematay ko, mesakop dan diyà te pongan te kakay dan si Efraim aw si Manases. ");
INSERT INTO mbs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Keidowan ko se didowa batà no sìyan tandà te dakel se pedowan ko diyà te inay no si Raquel. Ontò nepuluk se pedowan ko te pegkematay din doton te Canaan medapag te Efrata te peg-olì ko lekat te Mesopotamya. Inlebeng ko se lawa din medapag te dalan pesalo te Efrata.” (Se lonsod te Efrata, yan se iningedanan Bitlihim songkani.) ");
INSERT INTO mbs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Pegkità i Jacob te didowa batà i Jose, mig-insà sikandin, “Sinu lay se menge telaki sìyan?” ");
INSERT INTO mbs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Timaba si Jose, “Seini se didowa batà ko imbegay te Timanem kanak dalem te peg-ogpà ko dini te Ehipto.” Minikagi si Jacob, “Ibingi dan diyà, so megtawal-tawal a den amon begayan dan te Timanem te mèpiya.” ");
INSERT INTO mbs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tabag den medaet se mata i Jacob so migketemoay den sikandin, aw yan wedà nael sikandin kità. Inibing i Jose se batà din, aw yan kinelesan dan i Jacob aw inedekan din dan. ");
INSERT INTO mbs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Minikagi si Jacob diyà ki Jose, “Kedengan mig-aneng-aneng a te eked a den palos kità kamno, meneng pineokit te tabang te Timanem kanak, kimità a den kamno aw menge batà nikaw heman.” ");
INSERT INTO mbs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Penga niyan, inabat i Jose se batà din lekat te giba te amay din, aw limongken sikandin diyà te amay din lamig minapet se olo din diyà te tanà. ");
INSERT INTO mbs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Impetindeg i Jose si Efraim lenged te bibang i Jacob, aw si Manases lenged te kowanan din. ");
INSERT INTO mbs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Meneng pig-ibelios i Jacob se belad din, so belad din lenged te kowanan se impemaed din te olo i Efraim, pengkey adi sikandin, aw bibang din se impemaed din te olo te kakay si Manases. ");
INSERT INTO mbs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Penga niyan, migtawal-tawal sikandin amon begayan te Timanem si Jose te mèpiya, kagi din, “E Timanem, sikona se egseligan te menge kemonaan ko si Abraham aw si Isaac. Sikona se gayed mig-ipat kanak lamig songkani. ");
INSERT INTO mbs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Sikona se migpelowà kanak amon wedad memeeleg kanak. Ibeg ko mèpiya se ibegay no diyà te didowa telaki seini. Ibeg ko eked palos kelibeli se ngadan ko aw ngadan te menge kemonaan ko si Abraham aw si Isaac pineokit te didowa apò ko seini. Ibeg ko heman, megkedita se batà dan aw menge bowad-bowad dan.” ");
INSERT INTO mbs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nayan, pegkità i Jose te si Efraim se pinemàdan te amay din te kowanan, wedà sikandin keibeg kenyan. Yan inabat din se belad te amay din amon elinen din lekat te olo i Efraim doton te olo i Manases. ");
INSERT INTO mbs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Minikagi si Jose, “Amà, wedà iyan peketotok, so seini se kakay. Seini se keilangan pemàdan nikaw te kowanan.” ");
INSERT INTO mbs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Meneng mig-eked si Jacob, aw minikagi sikandin, “Netegahan ko iyan Atò. Netegahan ko iyan. Meinang heman melangkaw se menge bowad-bowad i Manases, meneng labi pa melangkaw si Efraim, so meinang medita pongan se menge bowad-bowad din.” ");
INSERT INTO mbs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yan mèpiya se intawal-tawal din diyà te Timanem tepad kandan te aldaw sìyan te peg-ikagi din kani, “Kenyo ngadan se gemiten te menge bowad-bowad ko te peg-ikagi dan te mèpiya diyà te menge doma otaw, so mikagi dan, ‘Ibeg day, mèpiya se ibegay te Timanem kenyo, iling te ipegbegay din diyà ki Efraim aw si Manases.’” Pineokit kenyan, ininang i Jacob si Efraim labi pa melangkaw diyà ki Manases. ");
INSERT INTO mbs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Penga niyan, minikagi si Jacob diyà ki Jose, “Nayan, agpet den se aldaw te pegkematay ko, meneng ipaten ka pa te Timanem, aw ipeolì din se menge bowad-bowad ta te modi aldaw doton te tanà inogpaan te menge kemonaan ta gebii. ");
INSERT INTO mbs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kenà menge kedowa nikaw se begayan ko den te tanà ko doton te Sikem, meneng sikona se begayan ko kenyan. Yan se tanà melambò inabat ko lekat te menge tege Amori te pegpengayaw ko kandan te sondang aw bosog.” ");
INSERT INTO mbs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Penga niyan, tinawal i Jacob se kedita te batà din meama, aw minikagi sikandin, “Pegpedapag kaw den diyà kanak, so meg-indan a den kenyo aw eden se domateng kenyo te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Menge batà ko, pegpedapag kaw den diyà kanak. Penenalan kaw den kanak. ");
INSERT INTO mbs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Sikona Ruben se kakay diyà te kedita te batà ko. Magsen se lawa nikaw iling kanak kedengan. Diyà te kedita te menge batà ko, sikona se ontò melangkaw aw ontò egsegmanen. ");
INSERT INTO mbs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Meneng iling ka te wayeg eglaneg, so kenà ka egpeketameng te ibeg te pedowan nikaw. Yan meabat se kelangkaw nikaw, so limayok ka te doma esawa ko, aw yan migyàyà ka kanak. ");
INSERT INTO mbs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si Simeon aw si Levi, onawa se didowa dan, so egpenagnos dan te kekamang amon meg-inang dan te medaet. ");
INSERT INTO mbs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Eked a penenalan te pelnao dan. Eked a ayon kandan, so pegkeopal dan, nemonò dan, aw pegkeluba dan, pigpantig dan se menge baka. ");
INSERT INTO mbs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ipelumun dan te Timanem tandà te keopal dan, so pelaban dan mebolot aw ontò melbala. Peg-ebong-ebongen se menge bowad-bowad dan aw mebilit dan doton te ogpeanan te menge doma bowad-bowad ko. ");
INSERT INTO mbs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sikona Juda se iduyun te menge kedowa nikaw. Egpekedaeg ka te menge poon nikaw. Keilangan lomongken se menge kedowa no diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, iling ka te menenanap iningedanan liyon egsagok te kànen din, aw eg-olì doton te salag din aw eg-ibat. Wedad otaw mekeotik kamno. ");
INSERT INTO mbs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Si Juda se mengawid te bangkà te selotan, so gayed lomowan se menge bowad-bowad din lamig domateng se ontò selotan, sìyan toloen te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iiket din se nati te asno diyà te belagen te paras doen ontò mèpiya pongo niyan. Mepakay din bugsakan se penenaktun din diyà te temek te paras ininang bino, so ontò dakel se paras din. ");
INSERT INTO mbs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Labi pa melalag se mata din diyà te bino, aw labi pa mepotì se ngipen din diyà te gatas. ");
INSERT INTO mbs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Si Sabulon se meg-ogpà doton medapag te dagat. Ipegpondo se menge bapor doton te dedongan din. Tig-epoen din se tanà taman te Sidon. ");
INSERT INTO mbs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Si Isacar se iling te magsen asno gayed eg-ibat medapag te karga eg-ibingen din. ");
INSERT INTO mbs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Meneng aw komità sikandin te mèpiya iyan ogpeanan aw mèpiya heman se tanà kidoen, meg-akot sikandin te mebegat, aw measeb sikandin megterbaho iling te allang. ");
INSERT INTO mbs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Mèpiya se pegpengibing i Dan te menge sakop din, iling te menge doma pongan te bowad-bowad i Israel. ");
INSERT INTO mbs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Si Dan se iling te memokan doton te kilid te dalan menongkà te benis te kodà amon medagdag se otaw simakay aw mekelias. ");
INSERT INTO mbs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“E Pengolo, egpelimanan ko se pegpelowà no kanak. ");
INSERT INTO mbs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Doen menge mengengayaw meglompak ki Gad, meneng etowan din dan, aw elawen din dan. ");
INSERT INTO mbs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Mèpiya se geniyen doton te menge pawà i Aser. Mèpiya se kànen ebaten kidoen kandin iling te mèpiya kànen te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Si Neftali se iling te seladeng eked kedakep. Mèpiya heman se bawa te menge batà din. ");
INSERT INTO mbs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Si Jose se iling te kayo intanem medapag te selep. Dakel se pongo niyan, aw minapet se panga niyan te dibaloy te alad. ");
INSERT INTO mbs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Doen otaw meglompak kandin aw memanà kandin, ");
INSERT INTO mbs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","meneng megkedaet se bosog dan, aw megkelomay se bebenayen dan tandà te inang te Timanem Metolos egseligan ko. Timanem se megbantay aw meg-ipat te menge bowad-bowad ko. ");
INSERT INTO mbs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Se Timanem egseligan ko, yan se megtabang kenyo. Se Timanem eglowan diyà te kedita, yan se memegay kenyo te mèpiya. Sikandin se memegay kenyo te odan lekat te langit, aw selep egtebol lekat didalem te tanà. Sikandin se memegay kenyo te medita ayam-ayam aw batà. ");
INSERT INTO mbs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sikandin se memegay kenyo te dakel trigo aw kebokadan. Sikandin se memegay kenyo te mèpiya doton te pemebongan aw doton te bontod wedad temanan. Ibeg ko Jose, begayan ka te Timanem te kedita niyan, so pinemallì ka din diyà te kedita te menge kedowa nikaw. ");
INSERT INTO mbs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Si Benjamin se iling te mebolot menenanap te kebenesan iningedanan lobo gayed egpengimatay aw egpengaen lekat te iselem lamig te meapon.” ");
INSERT INTO mbs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yan se sempolò teg dowa pongan te menge bowad-bowad i Israel, aw yan se inikagi te amay dan diyà kandan. Neketepad se inikagi din diyà te tegsebad-sebad kandan te agpet sikandin matay. ");
INSERT INTO mbs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Penga niyan, doen impunù i Jacob diyà te menge batà din, kagi din, “Agpet a den tomelokon te menge kemonaan ko nematay. Lebengi se lawa ko doton te linebengan te menge kemonaan ko doton te ilib kidoen te tanà tapay tinig-apò i Efron tege Heti ");
INSERT INTO mbs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","doton te Makpela lenged te eglibtakan te lonsod te Mamre doton te Canaan. Yan se ilib aw tanà bineyadan i Abraham ki Efron amon inangen din lebenganan. ");
INSERT INTO mbs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Yan se linebengan ki Abraham aw esawa din si Sara. Yan heman se linebengan ki Isaac aw esawa din si Rebecca. Yan heman se linebengan ko ki Lea. ");
INSERT INTO mbs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Yan se tanà aw ilib bineyadan lekat te menge tege Heti gebii.” ");
INSERT INTO mbs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Penga te pegpunù i Jacob diyà te menge batà din, todà sikandin minibat, aw penga niyan nematay. ");
INSERT INTO mbs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Penga niyan, kimeles si Jose te amay din aw migkelag aw nengadek te bawa din. ");
INSERT INTO mbs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Penga niyan, migpunù si Jose te ipebalsamar te otaw biyasa se lawa te amay din. ");
INSERT INTO mbs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kepatan se aldaw se pegbalsamar dan kandin, so yan se kenamay te pegbalsamar dan te lawa te nematay. Nelenowan sikandin te menge tege Ehipto te kepitowan se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Pegketagkas te pegkelano dan kandin, minikagi si Jose diyà te menge sineligan te selotan, “Aw doen keido niyo kanak, keliwati niyo bag se kagi ko seini diyà te selotan. ");
INSERT INTO mbs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Te wedà pa kematay se amay ko, migpakang a kandin te ilebeng ko se lawa din kidoen te lebenganan tapay din impetagad doton te Canaan. Yan aw mepakay diyà kamno, domoton a amon ilebeng ko, aw penga niyan molì a dini.’” ");
INSERT INTO mbs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Timaba se selotan, “Ee. Doton ka aw lebengi se amay nikaw iling te impakang no kandin.” ");
INSERT INTO mbs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yan nesayo si Jose amon meglebeng te amay din. Tinekingan heman sikandin te kedita te opisyal te selotan, aw menge obanen egseligan te selotan, aw menge doma otaw nedengeg doton te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Timaking heman se kedita te pamilya i Jose, aw menge kedowa din, aw kedita te otaw diyà te pamilya te amay din. Olò menge deitek mengisù, aw karniro, kambing, aw baka se wedà dan petekingi, meneng mig-ogpà dan doton te Gosen. ");
INSERT INTO mbs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Timaking heman ki Jose se menge otaw simakay te kelisa aw kodà. Ontò medita se otaw dimoton. ");
INSERT INTO mbs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pegdateng dan doton te giyekanan kidoen te Atad doton dipag te Jordan, nenamay dan migkoliyà. Minoloy si Jose te amay din kidoen taman te pito se aldaw. ");
INSERT INTO mbs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pegkità te menge tege Canaan te peg-oloy dan doton te Atad, minikagi dan, “Ontò minoloy se menge tege Ehipto.” Yan se doun te iningedanan se ogpeanan sìyan Abel Misraim (kelebadan niyan, oloyanan te tege Ehipto). Yan se neinang doton dipag te Jordan. ");
INSERT INTO mbs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yan tinoman te menge batà i Jacob se impunù din kandan. ");
INSERT INTO mbs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Inibing dan se lawa din doton te Canaan, aw inlebeng dan iyan diyà te ilib kidoen te Makpela lenged te eglibtakan te lonsod te Mamre. Yan se ilib aw tanà bineyadan i Abraham ki Efron tege Heti amon inangen din lebenganan. ");
INSERT INTO mbs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Penga te peglebeng i Jose te amay din, minolì sikandin doton te Ehipto sipat te menge kedowa din aw kedita te doma otaw timaking kandin te peglebeng. ");
INSERT INTO mbs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nayan, so nematay den si Jacob, migpebelaw-belaway se menge kedowa i Jose, kagi dan, “Megmeno kidon aw keopalan kidon den i Jose, aw megmalit den sikandin kenitadon tandà te medaet ininang tadon kandin?” ");
INSERT INTO mbs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Penga niyan, impekeliwat dan se kagi dan diyà ki Jose, “Te wedà pa kematay se amay tadon, ");
INSERT INTO mbs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","migpunù sikandin te ikeliwat day diyà kamno se kagi din seini, ‘Pegwedadi bag se salà te menge kedowa no kedengan te peg-inang dan kamno te medaet.’ Yan, pegwedadi bag se salà ininang day menge sineligan te Timanem egpemenalen te amay tadon.” Pegdineg i Jose te kagi dan sìyan, migkelag sikandin. ");
INSERT INTO mbs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Penga niyan, dimoton se menge kedowa din kandin, aw limongken dan diyà kandin. Minikagi dan, “Dimini kay den amon inangen kay menge allang nikaw.” ");
INSERT INTO mbs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Meneng minikagi si Jose, “Ikà niyo egkelemitan kanak. Kenà ko se meg-okom kenyo, so olò Timanem se mepakay meg-okom. ");
INSERT INTO mbs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Pengkey medaet se tod niyo kanak, meneng ininang te Timanem iyan mèpiya, amon medita se otaw eked kematay te bitil, aw yan se doun te neantay kidon pa songkani. ");
INSERT INTO mbs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ikà niyo palos egkelemitan, so siak se meg-ipat kenyo aw menge pamilya niyo.” Ontò mèpiya se kagi din kandan amon mesinalay se pedowan dan. ");
INSERT INTO mbs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Mig-ogpà dan pa doton te Ehipto, si Jose aw kedita te menge bowad-bowad te amay din. Pegkematay i Jose, sebad gatos sempolò se omay din. ");
INSERT INTO mbs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Te wedà pa sikandin kematay, nesàban sikandin te menge apò din te boel, menge apò i Efraim. Nesàban heman sikandin te menge apò din te boel, menge batà i Makir batà i Manases, aw inelopop din dan. ");
INSERT INTO mbs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nayan, doen aldaw minikagi si Jose diyà te menge kedowa din, “Agpet den domateng se aldaw te pegkematay ko, meneng metoman kaw gayed ipaten te Timanem, aw ibingen kaw din lekat te ogpeanan seini doton te ogpeanan impakang din diyà te menge kemonaan tadon si Abraham, si Isaac, aw si Jacob.” ");
INSERT INTO mbs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Penga niyan, nemoyò si Jose te megsapà se menge doma bowad-bowad i Israel, kagi din, “Pegpakang kaw kanak te ibingen niyo se lawa ko te modi aldaw aw ipeolì kaw te Timanem doton te Canaan.” ");
INSERT INTO mbs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yan nematay si Jose doton te Ehipto te sebad gatos sempolò se omay din. Penga niyan, impebalsamar dan se lawa din, aw insawol dan iyan diyà te longon.");
INSERT INTO mbs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Seini se ngadan te menge kemonaan i Jesu Cristo. Si Jesus se sebad diyà te menge bowad-bowad i David, aw menge bowad-bowad i Abraham. ");
INSERT INTO mbs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham se amay i Isaac. Si Isaac se amay i Jacob. Si Jacob se amay i Juda aw menge kedowa din. ");
INSERT INTO mbs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda se amay i Fares aw si Sara. Si Tamar se inay dan. Si Fares se amay i Esrom. Si Esrom se amay i Aram. ");
INSERT INTO mbs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram se amay i Aminadab. Si Aminadab se amay i Naason. Si Naason se amay i Salmon. ");
INSERT INTO mbs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon se amay i Boos, aw si Rahab se inay din. Si Boos se amay i Obed, aw si Ruth se inay din. Si Obed se amay i Isai. ");
INSERT INTO mbs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Isai se amay te selotan si David. Si David se amay i Solomon, aw inay din se esawa i Uria inagaw i David. ");
INSERT INTO mbs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon se amay i Roboam. Si Roboam se amay i Abias. Si Abias se amay i Asa. ");
INSERT INTO mbs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa se amay i Josafat. Si Josafat se amay i Joram. Si Joram se amay i Usias. ");
INSERT INTO mbs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias se amay i Jotam. Si Jotam se amay i Acas. Si Acas se amay i Esekias. ");
INSERT INTO mbs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esekias se amay i Manases. Si Manases se amay i Amon. Si Amon se amay i Josias. ");
INSERT INTO mbs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias se amay i Jeconias aw menge kedowa din. Dinakep dan sipat menge doma dan Judiyo aw inibing dan doton te mediyò ogpeanan te Babilonya. ");
INSERT INTO mbs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Penga te peg-ibing kandan doton te Babilonya, migbatà si Jeconias ki Salatiel. Si Salatiel se amay i Sorobabel. ");
INSERT INTO mbs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel se amay i Abiud. Si Abiud se amay i Eliakim. Si Eliakim se amay i Asor. ");
INSERT INTO mbs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor se amay i Sadoc. Si Sadoc se amay i Akim. Si Akim se amay i Eliud. ");
INSERT INTO mbs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud se amay i Eleasar. Si Eleasar se amay i Matan. Si Matan se amay i Jacob. ");
INSERT INTO mbs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob se amay i Jose. Si Jose se esawa i Maria inay i Jesus. Si Jesus se ginulal Misiyas insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nayan, lekat ki Abraham lamig ki David, sempolò teg epat kebelikwat se pamilya migpetondogay. Lekat ki David lamig te peg-ibing te menge Judiyo doton te Babilonya, sempolò teg epat heman kebelikwat se pamilya migpetondogay. Lekat te peg-ibing kandan doton te Babilonya lamig te pegtebaw te Misiyas, sempolò teg epat heman kebelikwat se pamilya migpetondogay. ");
INSERT INTO mbs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nayan, seini se indan-indan tepad te pegtebaw i Jesu Cristo. Si Maria se inay din, aw doen salà din si Jose. Te wedà dan pa peipiday, netegahan i Maria te miglaman sikandin pineokit te Espiritu Santo. ");
INSERT INTO mbs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mèpiya otaw se salà din si Jose. Pegketaga-taga din te miglaman den si Maria, mig-aneng-aneng sikandin te eked den ipid ki Maria. Ibeg i Jose osayen dan te wedad metaga-taga amon eked keyàyà si Maria. ");
INSERT INTO mbs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Meneng dalem pa te peg-aneng-aneng din kenyan, doen anghil te Timanem migpekità diyà kandin pineokit te tegeinep, aw minikagi, “Jose, bowad-bowad i David, ikà eg-eked te peg-ipid no ki Maria, so miglaman sikandin pineokit te Espiritu Santo. ");
INSERT INTO mbs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Doen batà meama tomebaw diyà kandin ingedanan no ki Jesus, so sikandin se megpelowà te otaw lekat te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Neinang iyan amon metoman se tapay inikagi te telekeliwat te kagi te Timanem gebii, kagi din, ");
INSERT INTO mbs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Na, meglaman se laga aw tomebaw se batà meama ingedanan ki Emmanuel.” (Se kelebadan niyan, “Dini den se Timanem doma kenitadon.”) ");
INSERT INTO mbs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pegkeloka i Jose, timolò sikandin te impunù te anghil te Timanem kandin, aw minipid sikandin ki Maria. ");
INSERT INTO mbs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Meneng wedà dan pegpeleyokay lamig timebaw se batà. Iningedanan i Jose se batà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Timebaw si Jesus doton te lonsod te Bitlihim sakop te probinsya te Judiya dalem te peglowan te selotan si Herod. Nayan, doen menge otaw dimateng doton te Jerusalem lekat te mediyò ogpeanan doton te eglibtakan te aldaw. Sikandan se ontò biyasa tepad te pengilala te menge bitoen. ");
INSERT INTO mbs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mig-insà dan, “Kenan lay se deitek batà meinang Selotan te menge Judiyo? Kinità day se bitoen limibtak aw yan se pengilala te timebaw den sikandin. Dimini kay amon megsimba kay kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pegdineg i Herod te doen meinang selotan somelilin kandin, ontò sikandin netetana sipat kedita te tege Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Penga niyan, impetipon din se kedita te pengolo te simbahan te Judiyo aw menenoladà te punù ingkeliwat i Moises. Mig-insà sikandin aw kenan tebaw se Misiyas. ");
INSERT INTO mbs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Timaba dan, “Tomebaw sikandin doton te Bitlihim dini te probinsya te Judiya, so yan se tapay insolat te telekeliwat te kagi te Timanem, kagi din, ");
INSERT INTO mbs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikiyo menge tege Bitlihim, pengkey nedengeg se menge doma lonsod doton te probinsya niyo te Judiya, meneng labi pa medengeg se lonsod niyo, so lekat kenyo se Pengolo lomowan diyà te menge bowad-bowad i Israel pinemallì ko.’” ");
INSERT INTO mbs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Penga niyan, impeangay i Herod se menge otaw biyasa te pengilala te bitoen. Netipon dan te wedad doma otaw netaga-taga, aw ontò mig-insà si Herod aw kano dan kitai se bitoen sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Penga niyan, insogò din dan, kagi din, “Doton kaw te Bitlihim, aw ontò niyo pemehai se batà sìyan. Aw kitaen niyo sikandin, likò kaw dini aw indani a niyo amon domoton a heman aw megsimba a kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Penga niyan, nesayo dan aw todà dan kinità se bitoen tapay dan kinità limibtak. Pegkità dan te bitoen, ontò neluba se pedowan dan, aw yan se tinekingan dan lamig simagked iyan diatas te balay inogpaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Peg-awop dan kidoen te balay, kinità dan se batà aw inay din si Maria. Limongken dan aw migsimba dan te batà. Penga niyan, inokal dan se kekanà inibing dan, menge bolawan, aw metinadeg sonogen, aw bebolong te saka iningedanan mira. Tinigkan dan iyan imbowang diyà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nayan, migpunù se Timanem diyà kandan pineokit te tegeinep te eked kepakay aw lomikò dan doton ki Herod. Yan se doun te minokit dan te sebad dalan te peg-olì dan doton te kandan ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nayan, penga te pegkesayo dan, doen anghil insogò te Timanem migpekità diyà ki Jose pineokit te tegeinep, aw minikagi, “Enaw ka. Ibingi se batà aw inay din, aw kadas kaw doton te Ehipto. Peg-ogpà kaw doton lamig te ipeolì ko sikiyo, so doen sondalo isogò i Herod amon mengemahà te batà seini aw imetayan.” ");
INSERT INTO mbs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Penga niyan, pengkey tengà te delem, minenaw si Jose aw inibing din se esawa din aw si Jesus, aw simamsam dan pesalo doton te Ehipto. ");
INSERT INTO mbs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mig-ogpà dan doton lamig nematay si Herod. Yan se neinang amon metoman se inikagi te telekeliwat te kagi te Timanem, “Ipeolì ko se batà ko lekat te Ehipto.” ");
INSERT INTO mbs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nayan, pegketaga-taga i Herod te inekalan sikandin te menge otaw biyasa tepad te pengilala te bitoen, ontò sikandin neopal so wedà dan likò doton kandin. Yan insogò din se menge sondalo doton te lonsod te Bitlihim aw menge ogpeanan medapag kidoen amon imetayan dan se kedita te batà meama lekat te kaling timebaw lamig te didowa se omay, so yan se kenamay netegahan din lekat te in-indan te menge otaw biyasa tepad te pengilala te bitoen. ");
INSERT INTO mbs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pineokit kenyan, netoman se inikagi te telekeliwat te kagi te Timanem gebii si Jeremias, ");
INSERT INTO mbs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Doen dinegen niyo kidoen te lonsod te Rama. Megkelag aw megmatay se menge bowad-bowad i Rakel, so melano dan te mengisù dan. Megkelag dan, aw eked dan kesinelayi, so inimetayan se mengisù dan.” ");
INSERT INTO mbs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nayan, penga te pegkematay i Herod, doen anghil insogò te Timanem migpekità diyà ki Jose doton te Ehipto pineokit te tegeinep. Minikagi se anghil, ");
INSERT INTO mbs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Enaw ka. Ibingi se batà aw inay din, aw olì kaw doton te Israel, so nematay den se otaw mengimatay peden te batà.” ");
INSERT INTO mbs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Penga niyan, minenaw si Jose aw inibing din se esawa din aw si Jesus, aw minolì dan doton te Israel. ");
INSERT INTO mbs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Meneng wedà dan deleg doton te probinsya te Judiya, so nelemitan si Jose te pegdineg din te limowan den si Arkelao simelilin te amay din si Herod nematay. Yan insogò te Timanem si Jose pineokit te tegeinep, aw simoway dan doton te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mig-ogpà dan doton te lonsod te Nasarit. Yan netoman se inikagi te menge telekeliwat te kagi te Timanem te tewalen si Jesus tege Nasarit. ");
INSERT INTO mbs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nayan, dimateng se aldaw te pegdoton i Juan Memonyagay te kebigtilan kidoen te probinsya te Judiya. Migtoladà sikandin, kagi din, ");
INSERT INTO mbs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pegselsel kaw den te menge salà ininang niyo, so agpet den lomowan se Timanem diyà kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan se tinedoan te inikagi te telekeliwat te kagi te Timanem gebii si Isaias, “Dinegen niyo se otaw doton te kebigtilan aw dakel se kagi din, ‘Peketagad kaw te pegdateng te Pengolo. Peg-inang kaw te metòlid, so domateng sikandin.’” ");
INSERT INTO mbs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nayan, egpenaol si Juan te saol inabel lekat te bolbol te ayam-ayam kamilo aw egpengelen te kindal te ayam-ayam. Egpengànen din se menge dolon aw teneb eg-ebaten din doton te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Medita se otaw lekat te Jerusalem aw menge doma lonsod sakop te probinsya te Judiya aw medapag te wayeg te Jordan dimoton amon menenalan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Migselsel dan te menge salà ininang dan, aw binonyagan din dan doton te wayeg te Jordan. ");
INSERT INTO mbs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nayan, medita heman se egpengibing te simbahan te Judiyo dimoton ki Juan amon megpebonyag dan kandin. Sakop dan te menge Parisiyo aw Sadusiyo. Pegkità i Juan kandan, minikagi sikandin, “Tay law. Iling kaw te memokan egkadas te apoy. Eked kaw pekelowà lekat te pelumun te Timanem te modi aldaw singed aw megselsel kaw. ");
INSERT INTO mbs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aw migselsel kaw den, petega-tegahi niyo iyan pineokit te eg-inangen niyo. ");
INSERT INTO mbs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ikà niyo eg-aneng-aneng te eked kaw pelumuni so bowad-bowad kaw i Abraham. Eneng-enengi niyo se kagi ko seini. Pengkey se menge bato seini te lanto te tanà, mepakay iyan inangen te Timanem menge bowad-bowad i Abraham somelilin kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iling kaw te kayo agpet pilayen. Aw kenà mèpiya se pongo te kayo, pilayen iyan aw sonogen. ");
INSERT INTO mbs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Egpemonyag a pineokit te wayeg, so yan se pengilala te migselsel kaw den te salà ininang niyo. Meneng doen pa domateng labi pa melangkaw diyà kanak. Kenà botong se kelangkaw ko amon megtelaban a kandin pengkey mengibing a te sepatos din, so ontò sikandin melangkaw diyà kanak. Sikandin se memonyag kenyo pineokit te Espiritu Santo aw pineokit te apoy. ");
INSERT INTO mbs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iling sikandin te otaw egpepalid te trigo eggiyeken din, amon isawol din te buun aw ibingen din doton te balay. Meneng se ohot aw tipig, yan se sonogen din te apoy kenà egkepadeng.” ");
INSERT INTO mbs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nayan, dimateng si Jesus lekat te probinsya te Galiliya aw dimoton te wayeg te Jordan amon megpebonyag ki Juan. ");
INSERT INTO mbs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Meneng wedà keibeg si Juan aw sikandin se megbonyag ki Jesus, so minikagi sikandin, “Eked kepakay aw siak se megbonyag kamno. Keilangan sikona se megbonyag kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Meneng minikagi si Jesus, “Tomani den se pegbonyag kanak, so keilangan tomoman ki den te kedita te ibeg te Timanem.” Penga niyan, migbonyag si Juan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Penga te pegbonyag din kandin, minanggin si Jesus lekat te wayeg. Pegketà, neowang se langit, aw kinità din se Espiritu Santo migpedanà diyà kandin iling te selepati, aw mig-ogpà diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Penga niyan, dinineg dan se kagi te Timanem lekat te langit, “Seini se Batà ko. Dakel se pedowan ko kandin, aw ontò a neluba kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Penga te pegbonyag ki Jesus, inibing sikandin te Espiritu Santo doton te kebigtilan amon boyowen i Satanas. ");
INSERT INTO mbs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wedad palos kinaen i Jesus dalem te kepatan se aldaw, aw penga niyan binallos sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dimateng si Satanas aw minikagi sikandin, “Aw ontò ka Batà te Timanem, inangi pan se menge bato seini pineokit te tolos no amon doen kànen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Meneng minikagi si Jesus, “Eked a, so doen kagi te Timanem insolat, ‘Kenà olò kànen se keilangan te otaw amon eked kematay, meneng keilangan kominawà se otaw te kedita te impunù te Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Penga niyan, inibing i Satanas si Jesus doton diatas te dakel simbahan doton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Minikagi si Satanas, “Nayan, aw ontò ka Batà te Timanem, kahang ka. Eked ka elegi, so doen kagi te Timanem insolat, ‘Isogò te Timanem se menge anghil amon meg-ipat dan kamno.’ Doen heman kagi te Timanem insolat, ‘Ewidan ka te menge anghil, aw engaten ka dan amon eked ka kesongkol te bato.’” ");
INSERT INTO mbs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Meneng minikagi si Jesus, “Eked a, so doen heman kagi te Timanem insolat, ‘Ikà niyo egtandà te Pengolo niyo Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Penga niyan, inibing i Satanas si Jesus doton te ontò melangkaw bontod, aw impekità din kandin se kedita te ogpeanan te keneyonan aw kèpiya niyan. ");
INSERT INTO mbs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Minikagi si Satanas, “Aw lomongken ka diyà kanak aw simbahen a nikaw, ibegay ko diyà kamno se kedita te ogpeanan sìyan, amon lomowan ka diyà te kedita te otaw kidoen.” ");
INSERT INTO mbs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Meneng minikagi si Jesus, “Satanas, kesayo ka. Eked a pegsimba kamno, so doen kagi te Timanem insolat, ‘Timanem se Pengolo niyo aw sikandin se keilangan simbahen niyo, so sikandin olò se mepakay tekingan niyo.’” ");
INSERT INTO mbs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Penga niyan, nesayo si Satanas, aw doen menge anghil insogò te Timanem amon meg-ipat dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nayan, impedakep i Herod si Juan Memonyagay aw impekeleboso din. Pegketaga-taga i Jesus kenyan, minolì sikandin doton te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Minokit sikandin doton te lonsod te Nasarit aw dimeleg doton te lonsod te Kapirnaom aw mig-ogpà kidoen dapag te kilid te lanaw digsel te tanà te Sabulon aw Neftali. ");
INSERT INTO mbs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pineokit kenyan, netoman se inikagi te telekeliwat te kagi te Timanem gebii si Isaias tepad te pegdateng i Jesus pigpolingunan te lowa, ");
INSERT INTO mbs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Se kedita te otaw eg-ogpà doton te tanà te Sabulon aw Neftali, aw doton dapag te kilid te lanaw, aw doton dipag te wayeg te Jordan, aw doton te Galiliya eg-ogpaan te menge otaw kenà Judiyo, ");
INSERT INTO mbs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","pengkey iling te eg-ogpà dan doton te kengitngitan, meneng kitaen dan se ontò melowa. Pengkey eg-ogpà dan doton te kengitngitan aw egkelemitan dan te kemetayun, meneng egkeenyagan dan.” ");
INSERT INTO mbs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lekat niyan, migtebò si Jesus migtoladà, aw minikagi sikandin, “Pegselsel kaw den te menge salà ininang niyo, so agpet den lomowan se Timanem diyà kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Doen sebad aldaw, minipanaw si Jesus doton te kilid te lanaw te Galiliya. Kinità din se didowa memokotay si Simon iningedanan din ki Pedro, aw adi din si Andres nemokot. ");
INSERT INTO mbs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Timawal si Jesus, “Taking kaw kanak, so megtoladà a kenyo amon kenà ikan se meabat niyo, meneng otaw se ibingen niyo diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pegketà, tinenanan dan se pokot aw timaking dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Dimeleg si Jesus, aw kinità din se doma telekedowa si Santiago aw adi din si Juan didowa batà i Sebedeo. Kidoen dan te belangay sipat amay dan, aw migtigmes dan te pokot. Tinawal dan heman i Jesus, ");
INSERT INTO mbs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aw ayas dan tinenanan se belangay aw amay dan, aw timaking dan heman ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nayan, timeped si Jesus te kedita te lonsod doton te probinsya te Galiliya, aw migtoladà doton te menge simbahan te Judiyo. Migtoladà sikandin te Mèpiya Indan tepad te peglowan te Timanem, aw pinegolian din se kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yan se doun te ontò sikandin nedengeg doton te kebelad te Sirya. Pinegolian din se kedita te otaw doen mesakit inibing diyà kandin, pengkey eden kemoloi te mesakit, aw otaw dinetengan te bosaw, aw otaw pigbaboy, aw otaw kenà egpekeiwal. Negolian se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ontò medita se otaw timaking ki Jesus. Tikedo dan te probinsya te Galiliya, aw lekat te Dikapolis, aw Jerusalem, aw probinsya te Judiya, aw lekat dipag te wayeg te Jordan. ");
INSERT INTO mbs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pegkità i Jesus te medita se otaw netipon, timikedeg sikandin te bontod aw nenenoo kidoen. Migpedapag se kedita te otaw tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aw migtoladà si Jesus kandan, kagi din, ");
INSERT INTO mbs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Doen keluba te kedita te otaw netaga-taga te eked dan pekeinang te mèpiya singed aw tebangan dan te Timanem, so sekopen din dan diyà te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Doen keluba te kedita te otaw nelidò se pedowan dan, so sinelayen dan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Doen keluba te kedita te otaw migpedanà te kandan pegkeotawun, so kominawà dan te tanà impakang te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Doen keluba te kedita te otaw ontò meibeg meg-inang te metòlid, so tebangan dan te Timanem amon mekeinang dan te metòlid. ");
INSERT INTO mbs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Doen keluba te kedita te otaw egkeido te doma, so keidowan dan heman te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Doen keluba te kedita te otaw melobos se pedowan dan tomaking te Timanem, so komità dan kwani kandin. ");
INSERT INTO mbs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Doen keluba te kedita te otaw egpekeaseb eg-inang te kelinaw, so inangen dan te Timanem menge batà din. ");
INSERT INTO mbs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Doen keluba te kedita te otaw egpemilangen tandà te pegtolò dan te Timanem, so sekopen din dan diyà te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Doen keluba te kedita niyo egtompuyusen tandà te pegtaking niyo kanak, pengkey egpemilangen kaw, pengkey bàtan-bàtan kaw. ");
INSERT INTO mbs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Iling heman kenyan se pegpemilang dimateng diyà te menge telekeliwat te kagi te Timanem gebii. Meneng keilangan ontò kaw meluba, so ontò mèpiya se ontong ibegay diyà kenyo doton te langit.” ");
INSERT INTO mbs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Dalem te peg-ogpà niyo dini te keneyonan, iling kaw te asin isanged diyà te kànen. Meneng simpana megkewedad se kepait te asin, eked iyan ketodà. Keilangan iagbel, so wedad den kekemowan niyan, aw gìtan iyan te otaw mokit kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Dalem te peg-ogpà niyo dini te keneyonan, iling kaw te solò diyà te kedita te otaw. Eked keeles se lonsod aw doton te lanto te bontod. ");
INSERT INTO mbs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aw menemtem se otaw te solò, eked din iyan sengkobi te gentangan. Meneng mèpiya aw isawol din iyan diyà te kelengkawan amon keenyagan se didalem te balay. ");
INSERT INTO mbs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iling heman kenyan, keilangan olò mèpiya se inangen niyo, so aw komità se menge doma otaw te mèpiya se eg-inangen niyo, iduyun dan se Amay niyo Timanem doton te langit.” ");
INSERT INTO mbs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ikà niyo eg-aneng-aneng te dimini a amon pegwedaden ko se menge punù ingkeliwat i Moises aw insolat te menge telekeliwat te kagi te Timanem gebii. Meneng dimini a amon ipetaga-taga ko se ontò kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eneng-enengi niyo se kagi ko kenyo seini. Dalem te doen pa langit aw tanà, wedad palos punù te Timanem pegwedaden, meneng metoman se kedita te kagi din. ");
INSERT INTO mbs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aw doen otaw megwedad peden te pengkey sebad punù te Timanem, aw megtoladà kenyan diyà te doma otaw, yan se otaw ontò medanà doton te peglowan te Timanem. Meneng aw tomolò se otaw te kedita te punù te Timanem aw megtoladà te doma otaw kenyan, yan se otaw ontò melangkaw doton te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mikagi a den diyà kenyo, aw kenà labi pa metòlid se eg-inangen niyo diyà te eg-inangen te menge Parisiyo aw menenoladà te punù ingkeliwat i Moises, eked kaw palos sekopi te Timanem diyà te peglowan din.” ");
INSERT INTO mbs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Netegahan niyo den te migpunù si Moises diyà te menge kemonaan niyo te keilangan eked dan pemonò, so keilangan ipelumun se otaw memonò. ");
INSERT INTO mbs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Meneng mikagi a den diyà kenyo te pengkey olò meopal se otaw diyà te doma, ibingen sikandin doton te otaw eg-osay. Aw mikagi se otaw te medaet diyà te doma, ibingen sikandin doton te kelengkawan te oseyanan. Aw mikagi se otaw diyà te doma, ‘Book ka,’ ibingen sikandin doton te apoy te kilot. ");
INSERT INTO mbs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yan aw domoton kaw te dakel simbahan amon memegay te bowang diyà te Timanem, aw keeneng-enengan niyo te doen pa salà ininang niyo diyà te doma otaw, ");
INSERT INTO mbs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tenani niyo onà se ibowang niyo, aw doton kaw te otaw sìyan amon megkità kaw. Penga niyan, mepakay aw lomikò kaw memegay te bowang diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aw doen otaw megdimanda tepad kenyo, ayas kaw pegpeido-ido diyà kandin dalem pa te eked kaw dateng doton te howis, amon eked kaw din ibingi doton te howis, aw ibegay kaw diyà te belad te polis amon kelebosowen kaw. ");
INSERT INTO mbs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eneng-enengi niyo se kagi ko seini. Aw kelebosowen kaw, eked kaw palos pekelowà singed aw beyadan niyo se kedakel te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Netegahan niyo den te migpunù si Moises gebii te eked kepakay aw lomakad se otaw. ");
INSERT INTO mbs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Meneng mikagi a den diyà kenyo te pengkey olò tomengteng se meama diyà te bayi aw medaet se ibeg din kandin, nekelakad den sikandin diyà te pedowan din. ");
INSERT INTO mbs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yan aw meboyo kaw meg-inang te salà pineokit te mata niyo, mèpiya aw logiten niyo se mata, aw iagbel niyo amon eked kaw keboyo. Labi pa medaet aw meboyo kaw pineokit te mata aw iagbel se kedakel te lawa niyo doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aw meboyo kaw heman meg-inang te salà pineokit te belad niyo, mèpiya aw tokongen niyo se belad niyo aw iagbel niyo amon eked kaw keboyo. Labi pa medaet aw meboyo kaw pineokit te belad niyo aw iagbel se kedakel te lawa niyo doton te kilot.” ");
INSERT INTO mbs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Migpunù heman si Moises gebii te keilangan doen papil ibegay te meama diyà te bayi tepad te pegsibwan din kandin, aw penga niyan mepakay din ipekesayo. ");
INSERT INTO mbs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Meneng mikagi a den diyà kenyo, aw somibwan se meama te esawa din wedà peglakad, medaet se inangen te meama sìyan, so pineokit kandin mekelakad se esawa din aw todà mengognan, aw mekelakad heman se meama mengognan te bayi sinibwanan.” ");
INSERT INTO mbs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Netegahan niyo heman te migpunù si Moises diyà te menge kemonaan niyo gebii te eked kepakay aw tomalis se otaw te pakang aw impeokit din iyan diyà te ngadan te Timanem, so keilangan tomanen din iyan. ");
INSERT INTO mbs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Meneng mikagi a den diyà kenyo, aw megpakang kaw diyà te doma otaw, ikà niyo egsapà. Ikà niyo egsapà te langit aw tanà. Medaet iyan, so iling te onsedanan te Timanem se langit, aw iling te gìtanan din se tanà. Ikà niyo heman egsapà te lonsod te Jerusalem, so yan se lonsod ogpaan kwani te Selotan metolos. ");
INSERT INTO mbs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ikà niyo heman egsapà te logay niyo, so eked niyo kebatog todaen se batek niyan pengkey meitem aw mepotì. ");
INSERT INTO mbs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aw keseligan se kagi niyo, botong aw olò kaw tomaba, ‘Ee,’ aw ‘Eked.’ Aw keilangan isogpat niyo se sapà diyà te kebenalan, medaet iyan, so lekat iyan ki Satanas.” ");
INSERT INTO mbs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Netegahan niyo heman te migpunù si Moises gebii, aw memisek se otaw te mata te doma otaw, keilangan piseken heman se kandin mata. Migpunù heman si Moises, aw longeben te otaw se ngipen te doma otaw, keilangan longeben heman se kandin ngipen. ");
INSERT INTO mbs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Meneng mikagi a den diyà kenyo, aw doen otaw meg-inang te medaet diyà kenyo, ikà niyo eg-inang te medaet diyà kandin. Aw sempaken kaw te doma otaw diyà te pisngi lenged te kowanan, pesempaki niyo heman se pisngi lenged te bibang. ");
INSERT INTO mbs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aw doen otaw mengibing kenyo doton te howis amon mengabat te ekasan niyo, begayi niyo heman kandin se saol niyo. ");
INSERT INTO mbs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pengkey legesen kaw te sondalo mengibing te kedònan din taman te sebad kilomitro, pengibing kaw kenyan taman te dowa kilomitro. ");
INSERT INTO mbs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pemegay kaw diyà te otaw memoyò kenyo, aw pemebeles kaw heman diyà te otaw meibeg meles.” ");
INSERT INTO mbs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Netegahan niyo heman te doen migtoladà gebii te keilangan kedekelan niyo te pedowan se kedomaan niyo, aw mepakay keopalan se menge poon niyo. ");
INSERT INTO mbs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Meneng mikagi a den diyà kenyo te keilangan kedekelan niyo te pedowan se poon niyo. Keilangan gayed kaw megtawal-tawal diyà te Timanem tepad te otaw egpemilang kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aw iling kenyan se eg-inangen niyo, yan ipetaga-taga niyo te batà kaw te Timanem doton te langit, so gayed sikandin egpesenang te aldaw diyà te kedita te otaw pengkey medaet aw mèpiya se pedowan dan. Gayed heman sikandin egpetedak te odan diyà te pawà te kedita te otaw pengkey metòlid aw kenà metòlid se eg-inangen dan. ");
INSERT INTO mbs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Keilangan kedita te otaw se kedekelan niyo te pedowan. Aw olò otaw doen dakel pedowan kenyo se kedekelan niyo te pedowan, wedad ontong ibegay te Timanem diyà kenyo, so pengkey kedita te menge iskribinti eglindoan niyo, gayed dan eg-inang te mèpiya diyà te otaw eg-inang te mèpiya diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Keilangan segmanen niyo se kedita te otaw. Aw olò menge kedomaan niyo Judiyo se segmanen niyo, wedad eg-inangen niyo labi pa mèpiya diyà te eg-inangen te doma, so se kedita te otaw kenà Judiyo eglindoan niyo, gayed dan egsagman te menge kedomaan dan. ");
INSERT INTO mbs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yan, keilangan melobos se pedowan niyo iling te kelobos te pedowan te Amay niyo Timanem doton te langit.” ");
INSERT INTO mbs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ikà niyo egpemekità te pegtolò niyo te Timanem diyà te doma otaw amon iduyun kaw dan, so aw ibeg niyo iduyun kaw te doma otaw, wedad ontong kinewaen niyo lekat te Amay niyo Timanem eg-ogpà doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Yan aw megtabang kaw te otaw sagkep, ikà niyo eg-indan diyà te kedita te otaw amon iduyun kaw dan, so iling kenyan se eg-inangen te otaw eden dan aw egpenimanem dan. Yan se eg-inangen dan doton te simbahan te Judiyo aw kidoen te dalan, amon iduyun dan te menge doma otaw. Meneng eneng-enengi niyo se kagi ko seini. Wedad palos ontong ibegay te Timanem kandan. ");
INSERT INTO mbs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Meneng aw megtabang kaw te otaw sagkep, keilangan eked iyan ketegahi te doma otaw pengkey sigalak niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aw eked niyo petega-tegahi diyà te doma otaw se pegpemegay niyo diyà te otaw sagkep, kitaen iyan te Amay niyo Timanem doton te langit, aw begayan kaw din te ontong.” ");
INSERT INTO mbs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aw megtawal-tawal kaw diyà te Timanem, ikà niyo eg-iling te otaw eden dan aw egpenimanem dan, so egkeibeg dan egtawal-tawal doton te simbahan aw doton heman te dalan amon kitaen dan te menge doma otaw. Meneng eneng-enengi niyo se kagi ko seini. Wedad palos ontong ibegay te Timanem kandan. ");
INSERT INTO mbs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Meneng aw megtawal-tawal kaw, pegsiolì kaw. Tekepi niyo se lelebangan, aw pegtawal-tawal kaw diyà te Amay niyo Timanem eked kitai. Pengkey eked kaw kitai te doma otaw, komità se Timanem kenyo, aw begayan kaw din te ontong. ");
INSERT INTO mbs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ikà niyo egtawal-tawal aw kenà lekat te pedowan niyo se kagi, so iling kenyan se pegtawal-tawal te menge otaw kenà egpenimanem. Eden dan aw menenalan se Timanem kandan tandà te medita se kagi dan. ");
INSERT INTO mbs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ikà niyo eg-iling kandan, so tapay netaga-taga se Amay niyo Timanem aw eden se kelidoan niyo pengkey wedà kaw pa pemoyò diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pegtawal-tawal kaw diyà te Timanem iling kani. ‘Amà kidoen te langit, ibeg day iduyun ka te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ibeg day lomowan ka diyà te kedita te otaw. Ibeg day metoman se ibeg no dini te keneyonan iling te pegketoman te ibeg no doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Begayi kay te kànen botong te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pegwedadi se salà ininang day diyà kamno onawa te pegwedad day te salà ininang te doma otaw diyà kenami. ");
INSERT INTO mbs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ikà egpeokit kenami diyà te peg-akal, meneng pekediyoi kay diyà ki Satanas.’ ");
INSERT INTO mbs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aw pegwedaden niyo se salà ininang te doma otaw diyà kenyo, pegwedaden heman te Amay niyo Timanem se salà ininang niyo diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Meneng aw eked niyo pegwedadi se salà ininang te doma otaw diyà kenyo, eked heman pegwedadi te Amay niyo Timanem se salà ininang niyo diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aw megpowasa kaw, ikà niyo egpetaga-taga kenyan diyà te doma otaw pineokit te bawa niyo. Ikà niyo eg-iling te menge otaw eden dan aw egpenimanem dan, so eg-inangen dan medaet se bawa dan amon metaga-taga se doma otaw te kenà dan egpengaen. Eneng-enengi niyo se kagi ko seini. Wedad den palos ontong ibegay te Timanem kandan. ");
INSERT INTO mbs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Meneng aw megpowasa kaw, penowat kaw te logay, aw pegdàpog kaw te bawa, ");
INSERT INTO mbs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","amon eked ketaga-taga se doma otaw te wedà kaw kaen. Pengkey eked iyan ketegahi te doma otaw, meneng ketegahan iyan te Amay niyo Timanem eked kitai, aw doen ontong ibegay din diyà kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ikà niyo egtipon te kedònan dini lanto te tanà, so peg-enayen iyan, aw megkedaet iyan, aw ebaten iyan te menenakaw. ");
INSERT INTO mbs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Meneng keilangan megtipon kaw te kedònan doton te langit. Eked iyan peg-enayi, aw eked iyan pegkedaet, aw eked iyan heman ebati te menenakaw. ");
INSERT INTO mbs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aw kenan ketipon se kedònan niyo, yan heman se keeneng-enengan niyo.” ");
INSERT INTO mbs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Komità se otaw pineokit te mata. Aw mèpiya se mata te otaw, melowa se pegtengteng din. ");
INSERT INTO mbs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Meneng aw medaet se mata, iling te mengitngit se pegtengteng din pengkey aldaw. Iling heman kenyan, aw medaet se pedowan te otaw, ontò medaet se kedita te eg-inangen din.” ");
INSERT INTO mbs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wedad otaw meketolò te dowa amo din. Aw megpelenged sikandin diyà te sebad, eked sikandin tolò te sebad. Sebad olò se tekingan din, aw eked din segmani se sebad. Iling heman kenyan, eked pegsebad se pegpenimanem niyo aw pegpengewarta niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yan se doun te mikagi a den diyà kenyo, ikà niyo egketetana tepad te keogpà niyo aw eden se kànen aw inemen niyo. Ikà niyo heman egketetana tepad te lawa niyo aw eden se ekasan niyo. So binegayan kaw den te Timanem te ontò meelagà, sìyan pedowan niyo aw lawa niyo, yan ikà niyo egketetana tepad te kànen aw ekasan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Eneng-enengi niyo tepad te menge manok te kebenesan. Kenà dan egpenanem. Kenà dan heman eglegani. Kenà dan heman eglodok te kànen dan kidoen te pol. Meneng gayed dan egbegayan te Amay niyo Timanem te kànen. So eg-ipaten te Timanem se kedita te manok te kebenesan pengkey iling te wedad keelagà dan, ontò kaw din heman ipaten, so meelagà kaw pa diyà te kedita te manok te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pengkey metetana kaw, meneng eked pegkelayat se omol niyo pineokit te ketetana niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ikà niyo heman egketetana tepad te ekasan niyo. Eneng-enengi niyo se bolak te kebenesan. Gayed dan egtilles pengkey kenà dan egterbaho, aw kenà dan heman egpengabel te penenaktun. ");
INSERT INTO mbs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Meneng eneng-enengi niyo se kagi ko seini. Pengkey mèpiya se bawa te penenaktun te selotan si Solomon gebii, meneng labi pa mèpiya se bawa te bolak te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","So ininang te Timanem mèpiya se bawa te bolak te kebenesan pengkey sonogen iyan te eked kenamay, labi pa metoman se peg-ipat din kenyo. Meneng wedà pa kedì kelobos se pegsalig niyo kandin. ");
INSERT INTO mbs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ikà niyo egketetana tepad te kànen niyo, aw inemen niyo, aw ekasan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Se kedita te otaw kenà egsalig te Timanem, gayed dan egketetana tepad te keogpà dan. Meneng netegahan den te Amay niyo Timanem se kedita te kepulukan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yan pelowani niyo se Timanem diyà te kenyo pegkeotawun, aw tolò kaw te ibeg din, aw yan begayan kaw din heman te keilangan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Yan ikà niyo egketetana aw eden se domateng diyà kenyo kealdaw. Pebeyai niyo se kepulukan domateng te modi aldaw, so botong se kepulukan niyo te aldaw seini.” ");
INSERT INTO mbs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ikà niyo eg-okom te doma otaw amon eked kaw heman okomi. ");
INSERT INTO mbs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Okomen kaw onawa te peg-okom niyo te menge doma otaw. Keidowan kaw heman onawa te pegkeido niyo te menge doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mola niyo egkitaen se sagbet kidoen te mata te doma niyo, meneng wedà niyo ketegahi te doen batang kidoen te kenyo mata. ");
INSERT INTO mbs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aw doen batang kidoen te kenyo mata, eked kaw peketabang te doma niyo amon meabat se sagbet lekat te kandin mata. ");
INSERT INTO mbs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kolang se aneng-aneng niyo. Ebati niyo onà se batang lekat te kenyo mata, aw penga niyan metaen se pegkità niyo amon mengabat kaw heman te sagbet lekat te mata te doma niyo. ");
INSERT INTO mbs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pekeimanday kaw te pegtoladà niyo te kebenalan. Eked kaw pemowang te mèpiya diyà te menge toyang, so memangà dan beling kenyo. Eked kaw heman pemegay te pirlas meelagà ipeninga diyà te menge osa, so peglegìtan dan beling iyan.” ");
INSERT INTO mbs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Aw memoyò kaw diyà te Timanem, begayan kaw din. Aw mengemahà kaw, doen kitaen niyo. Aw tomawal kaw doton te lelebangan, ipeawop kaw. ");
INSERT INTO mbs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kominawà se kedita te otaw memoyò. Komità se kedita te otaw mengemahà. Ipeawop heman se kedita te otaw tomawal. ");
INSERT INTO mbs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aw doen batà niyo memoyò te pan, eked kaw pemegay kandin te bato. ");
INSERT INTO mbs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aw memoyò se batà niyo te ikan, eked kaw heman pemegay kandin te memokan. ");
INSERT INTO mbs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nayan, pengkey doen medaet eg-inangen niyo, meneng gayed mèpiya se ipegpemegay niyo diyà te menge batà niyo. Labi pa se Amay niyo Timanem kidoen te langit, so egpemegay sikandin te mèpiya diyà te kedita te otaw memoyò diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aw meibeg kaw te mèpiya se inangen te doma otaw diyà kenyo, keilangan mèpiya heman se inangen niyo diyà te doma otaw. Pineokit kenyan, tomanen niyo se kedita te punù ingkeliwat i Moises aw intoladà te menge telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mebelad se lelebangan aw mola okitan se dalan pesalo doton te kilot, aw medita se otaw eg-okit kenyan. Meneng okit kaw te lelebangan mesigpit, ");
INSERT INTO mbs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","so mesigpit se lelebangan aw melima se dalan pesalo doton te Timanem egpemegay te kaling pedowan, aw pilabok se otaw komità kenyan.” ");
INSERT INTO mbs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Peg-ahà kaw amon eked kaw keekali te menge otaw egpelingo-lingo telekeliwat te kagi te Timanem. Medaet se tod dan kenyo iling te mebolot menenanap te kebenesan iningedanan lobo egpelingo-lingo iling te ayam-ayam karniro amon megbaet te karniro. ");
INSERT INTO mbs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aw kitaen niyo se eg-inangen dan, ketegahan niyo aw olò dan egpelingo-lingo. Wedad palos pongo te paras geniyen lekat te ligem. Wedad heman pongo igira ipoen lekat te telayid. ");
INSERT INTO mbs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aw mèpiya se kemolò te kayo, mongo iyan te mèpiya. Meneng aw medaet se kemolò te kayo, mongo iyan heman te medaet. ");
INSERT INTO mbs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aw mèpiya se kayo, eked iyan pongo te medaet. Aw medaet se kayo, eked iyan heman pongo te mèpiya. ");
INSERT INTO mbs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aw kenà mèpiya se pongo te kayo, pilayen iyan aw sonogen. ");
INSERT INTO mbs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yan aw kitaen niyo se eg-inangen dan, ketegahan niyo aw ontò dan telekeliwat te kagi te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kenà kedita te otaw eg-ikagi te siak se pengolo dan se sekopen diyà te peglowan te Timanem, so se otaw egtolò te ibeg te Amay ko Timanem eg-ogpà doton te langit, yan olò se otaw sekopen te Timanem diyà te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aw domateng se aldaw te peg-okom, medita se otaw mikagi diyà kanak, ‘Pengolo, peopi kay bag, so migkeliwat kay te kagi te Timanem tandà te pegtaking day kamno, aw migpelowà kay te bosaw lekat te otaw pineokit te ngadan nikaw, aw doen heman menge kepelahan ininang day pineokit te ngadan nikaw.’ ");
INSERT INTO mbs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Meneng mikagi a diyà kandan, ‘Wedà a palos ketaga-taga kenyo. Kesayo kaw, kedita niyo eg-inang te medaet.’” ");
INSERT INTO mbs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Meg-indan a den diyà kenyo tepad te otaw domineg te kagi ko, aw tomolò kenyan. Iling sikandin te otaw mig-inang te balay. Impetindeg din se tollok diyà te lanto te bato doton didalem te tanà. ");
INSERT INTO mbs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Penga te peg-inang din te balay, minodan aw miglaneg se wayeg aw neapet se balay din. Mebandes se kelamag nekesogat diyà te balay din. Meneng wedà iyan kebàti, so ontò iyan dimasel. ");
INSERT INTO mbs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Meneng aw domineg se otaw te kagi ko, aw eked tolò kenyan, iling sikandin te otaw kolang se aneng-aneng din mig-inang te balay diyà te lanto te enay. ");
INSERT INTO mbs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Penga niyan, minodan aw miglaneg se wayeg. Mebandes se kelamag nekesogat diyà te balay din, aw penga niyan, netongan iyan aw ontò nebàtan.” ");
INSERT INTO mbs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Penga te pegtoladà i Jesus, ontò nepela se kedita te otaw nenenalan te pegtoladà din. ");
INSERT INTO mbs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kenà iling te pegtoladà te menenoladà te punù ingkeliwat i Moises se pegtoladà i Jesus, so tinekingan si Jesus te tolos. ");
INSERT INTO mbs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nayan, timopang si Jesus lekat te bontod, aw medita se otaw timaking kandin. ");
INSERT INTO mbs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Doen otaw pigtompig dimoton ki Jesus. Limongken sikandin aw minikagi, “Sir, aw doen ibeg nikaw, netegahan ko te mekebatog ka megpegolì kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nemaed si Jesus kandin, aw minikagi, “Meibeg a. Kegolian ka.” Pegketà, negolian sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Minikagi si Jesus, “Keilangan wedad palos otaw indanan no tepad te ininang ko kamno. Meneng doton ka te pengolo te simbahan aw pekitai se lawa no diyà kandin. Penga niyan, begayi se ibowang no iling te impunù i Moises amon metaga-taga se kedita te otaw te negolian ka den.” ");
INSERT INTO mbs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nayan, pegdateng i Jesus doton te Kapirnaom, doen kapitan te sondalo te gobirno te Roma simongon kandin aw nemoyò te tabang, ");
INSERT INTO mbs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kagi din, “Sir, nesekitan se sineligan ko doton te balay ko. Kenà den egpekeiwal, aw ontò netigdaan.” ");
INSERT INTO mbs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Minikagi si Jesus, “Tomaking a kamno aw megpegolì a kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Meneng minikagi se kapitan, “Sir, meyàyà a aw ipeawop ta diyà te balay ko, so ontò a medanà diyà kamno. Meneng botong aw olò ka mikagi te kegolian se sineligan ko, so metoman iyan. ");
INSERT INTO mbs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gayed a egtolò te otaw egsogò kanak, aw doen heman menge sondalo nesakop diyà kanak. Aw doen sondalo isogò ko, tomolò sikandin. Aw doen doma ipeangay ko, tomolò heman. Aw doen ipeinang ko te sineligan, yan se inangen din.” ");
INSERT INTO mbs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pegdineg i Jesus te kagi din, ontò nepela. Penga niyan, minikagi sikandin diyà te menge otaw timaking kandin, “Eneng-enengi niyo se kagi ko kenyo seini. Pengkey kidoen te menge bowad-bowad i Israel, wedad palos otaw netelaan ko simalig diyà kanak iling te pegsalig din. ");
INSERT INTO mbs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Metoman se kagi ko seini. Aw domateng se aldaw te peglowan te Timanem, medita se otaw domateng lekat te kedita te ogpeanan te keneyonan, pengkey kenà dan Judiyo. Ipeakop dan diyà te peglowan te Timanem sipat kemonaan niyo si Abraham, aw si Isaac, aw si Jacob. ");
INSERT INTO mbs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Meneng doen menge Judiyo egpeliman te ipeakop dan heman, meneng ipeibing dan doton te kengitngitan amon ipelumun dan. Ontò dan megkelag doton, aw megyangget-yangget se ngipen dan tandà te kegemakan dan.” ");
INSERT INTO mbs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Minikagi si Jesus diyà te kapitan, “Olì ka den, so netoman den se pinemoyò no tandà te pegsalig no kanak.” Peg-ikagi i Jesus kenyan, ayas negolian se sineligan te kapitan. ");
INSERT INTO mbs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nayan, dimoton si Jesus te balay i Pedro, aw kinità din se ogangan i Pedro bayi minibat so piglegenaw. ");
INSERT INTO mbs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Penga niyan, pinemàdan i Jesus se belad din, aw pegketà migkèpiya sikandin. Minenaw sikandin aw mig-inang te kànen i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pegsallep te aldaw, inibing dan doton ki Jesus se medita otaw dinetengan te bosaw, aw impelowà din se bosaw lekat kandan pineokit te kagi din. Pinegolian din heman se kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pegpegolì din kandan, tinoman din se inikagi te telekeliwat te kagi te Timanem gebii si Isaias, “Pegolien din se kedita te mesakit tadon.” ");
INSERT INTO mbs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nayan, pegkità i Jesus te medita se otaw timaking kandin, minikagi sikandin diyà te menge tinoledaan din te ipesakay dan sikandin te belangay matas doton dipag te lanaw. ");
INSERT INTO mbs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Meneng doen menenoladà te punù ingkeliwat i Moises migpedapag diyà ki Jesus. Minikagi sikandin, “Sir, pengkey kenan ka pesalo, gayed a tomaking kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Meneng minikagi si Jesus, “Mèpiya pa se menge menenanap te kebenesan, so doen ogpeanan dan. Mèpiya pa heman se menge manok, so doen heman embonganan dan. Meneng melima aw tomaking ka kanak Timanem Migpekeotaw, so wedad palos ibatan ko te delem.” ");
INSERT INTO mbs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Doen heman doma otaw timaking ki Jesus minikagi, “Pengolo, eked a taking kamno singed aw onà matay se amay ko aw ilebeng ko.” ");
INSERT INTO mbs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Meneng minikagi si Jesus, “Keilangan tomaking ka den kanak, so mèpiya aw otaw wedad kaling pedowan se meglebeng te menge doma dan nematay.” ");
INSERT INTO mbs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nayan, pegsakay i Jesus te belangay, simakay heman se menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wedà kenamay, dinetengan dan te kelamag ontò mebandes, aw agpet neteled se belangay, so dakel se wayeg nekeawop. Meneng timedogi si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Penga niyan, linoka dan sikandin, kagi dan, “Pengolo, tebangi kay, so melemes kidon den.” ");
INSERT INTO mbs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Minikagi si Jesus, “Wedà pa kedì kelobos se pegsalig niyo kanak. Ikà niyo egkelemitan.” Penga niyan, timindeg si Jesus aw sinagda din se kelamag aw balud, aw migkelinaw se lanaw. ");
INSERT INTO mbs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nepela dan aw minikagi dan, “Ontò sikandin metolos, so pengkey kelamag aw balud timolò kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nayan, dimeleg dan doton dipag te lanaw medapag te Gadara. Doen dowa otaw dinetengan te bosaw simongon kandin lekat te menge lebenganan. Ontò dan mebolot, aw yan wedad otaw eg-okit kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mig-olangag dan, kagi dan, “Batà te Timanem, ikà pa egpeeleg kenami, so wedà pa dateng se aldaw te pegpelumun no kenami.” ");
INSERT INTO mbs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ontò medita se osa nenowal kidoen te kedepagan niyan. ");
INSERT INTO mbs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nemoyò se menge bosaw, kagi dan, “Aw ipelowà kay nikaw, peopi kay bag diyà te menge osa sida.” ");
INSERT INTO mbs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Minikagi si Jesus, “Doton kaw den.” Penga niyan, limowà se bosaw lekat te otaw aw minawop dan diyà te osa. Penga niyan, kimagnan se kedita te osa pesalo te keba, aw kimahang dan doton te lanaw, aw nelemes dan. ");
INSERT INTO mbs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Penga niyan, kimadas se menge telediyaga te osa, aw dimoton dan te lonsod. Mig-indan dan te kedita te kinità dan aw eden se neinang diyà te didowa otaw pinelowaan i Jesus te bosaw. ");
INSERT INTO mbs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Penga niyan, dimoton se kedita te otaw ki Jesus. Pegkità dan kandin, nemoyò dan te mesayo si Jesus lekat te ogpeanan dan. ");
INSERT INTO mbs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nayan, simakay si Jesus te belangay, aw minolì doton te lonsod tinikedowan din. ");
INSERT INTO mbs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wedà kenamay, dimateng se otaw neningga te otaw kenà egpekeiwal. Pegkità i Jesus te ontò dan simalig diyà kandin, minikagi sikandin diyà te otaw kenà egpekeiwal, “Elew, peseligi se pedowan no, so pigwedad den se salà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nayan, doen menge menenoladà te punù mig-aneng-aneng te migtompuyus si Jesus te Timanem pineokit te kagi din sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Meneng netegahan i Jesus aw eden se aneng-aneng dan, aw minikagi sikandin, “Nengà lay eg-aneng-aneng kaw te medaet? ");
INSERT INTO mbs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mola megpelingo-lingo se otaw megwedad te salà. Meneng eked pekebatog se otaw megpegolì te otaw kenà egpekeiwal singed aw doen tolos te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Meneng so Timanem a Migpekeotaw, ipekità ko den kenyo te mekebatog a megwedad te salà te otaw dini lanto te tanà.” Penga niyan, minikagi si Jesus diyà te otaw kenà egpekeiwal, “Enaw ka. Loloni se inibatan no, aw olì ka den.” ");
INSERT INTO mbs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yan minenaw sikandin aw minolì. ");
INSERT INTO mbs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pegkità te doma otaw kenyan, ontò dan nelemitan, aw dimuyun dan te Timanem so insogò din si Jesus amon megwedad te salà te otaw. ");
INSERT INTO mbs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nayan, pegkesayo i Jesus lekat kidoen, kinità din se iskribinti nenenoo kidoen te opisina din, ngadan din si Mateo. Minikagi si Jesus, “Taking ka kanak.” Yan timindeg si Mateo aw timaking sikandin ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Penga niyan, kimaen si Jesus doton te balay i Mateo, aw medita heman se menge iskribinti aw doma otaw nelegeb te salà kimaen doma i Jesus aw menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Meneng pegkità te menge Parisiyo kenyan, minikagi dan diyà te menge tinoledaan i Jesus, “Medaet iyan, so egpengaen se pengolo niyo doma te medaet otaw, menge iskribinti aw doma otaw nelegeb te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Meneng pegdineg i Jesus te inikagi dan, minikagi sikandin, “Kenà otaw wedad mesakit se bolongen te doktor, meneng otaw doen mesakit se bolongen din. ");
INSERT INTO mbs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Keilangan eneng-enengen niyo aw eden se kedegdagan te kagi te Timanem seini, ‘Pengkey measeb kaw egpemegay te bowang diyà kanak, meneng labi a pa meluba aw megpeidoway kaw.’ Insogò a dini kenà amon tewalen ko se otaw eg-aneng-aneng te metòlid se eg-inangen dan, meneng insogò a dini amon tewalen ko se otaw mekesesalà.” ");
INSERT INTO mbs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nayan, dimoton se menge tinoledaan i Juan Memonyagay ki Jesus, aw mig-insà dan, “Melikit kay egpowasa onawa te eg-inangen te menge Parisiyo. Nengà lay kenà egpowasa se kamno menge tinoledaan?” ");
INSERT INTO mbs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Minikagi si Jesus, “Aw doen peipid, eked kepuluk se menge sigalak te meama peipiden dalem te kidoen pa sikandin. Meneng doen aldaw domateng aw meabat lekat kandan se meama peipiden, aw yan se aldaw megpowasa dan so mepuluk dan.” ");
INSERT INTO mbs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mig-indan heman si Jesus te tegdeyanan tepad te kaling toladà din, kagi din, “Eked kepakay aw tompalan se tapay penenaktun te kaling tila wedà pa bugsaki, so komotot se itompal, aw labi pa dakel se lisì te saol. ");
INSERT INTO mbs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aw meg-inang heman se otaw te bino, eked din soli se temek te paras diyà te solanan ininang lekat te kindal te kambing tapay linanit, so aw megbohak se temek, megbeto se solanan tapay linanit, aw lomowà se bino aw kebàtan heman se solanan niyan. Meneng keilangan isawol se temek inangen bino diyà te solanan kaling linanit amon wedad kebàtan.” ");
INSERT INTO mbs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nayan, dalem te pegtoladà i Jesus, dimateng se sebad obanen te simbahan te Judiyo. Limongken sikandin diyà ki Jesus, aw minikagi, “Kaling pa nematay se batà ko bayi. Peg-ayas ka bag, aw pemàdi sikandin amon meantay.” ");
INSERT INTO mbs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Penga niyan, timindeg si Jesus aw timaking kandin sipat menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nayan, doen heman sebad bayi pigdipenogan te sempolò teg dowa se omay. Migpedapag sikandin diyà te getan i Jesus aw nemaed olò te toktok te saol din, ");
INSERT INTO mbs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","so tapay sikandin mig-aneng-aneng te megolì se mesakit din aw pemàdan din olò se saol i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Penga niyan, miniling si Jesus, aw kinità din se bayi sìyan. Minikagi sikandin, “Atà, peseligi se pedowan nikaw. Negolian ka so simalig ka diyà kanak.” Pegketà, negolì se mesakit din. ");
INSERT INTO mbs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pegdateng i Jesus doton te balay te obanen, kinità din se menge otaw mig-edop te seluli tandà te lano dan, aw medita heman se doma otaw netipon migkelag. ");
INSERT INTO mbs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Migpunù si Jesus, kagi din, “Lowà kaw den, so wedà kematay se batà. Olò sikandin timedogi.” Meneng nebebeyatan dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pegkeobos te otaw netipon, minawop si Jesus diyà te tambì, aw pinemàdan din se belad te batà, aw minenaw se batà. ");
INSERT INTO mbs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nedengeg se peg-antay i Jesus kandin kidoen te kedepagan te ogpeanan sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nayan, pegkesayo i Jesus lekat kidoen, doen dowa otaw bota timaking kandin. Timawal dan, “Bowad-bowad te selotan tadon gebii si David, keidowi kay bag.” ");
INSERT INTO mbs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pegdateng din doton te balay, migpedapag se otaw bota diyà kandin. Minikagi si Jesus, “Nemenal kaw lay te mekebatog a megpegolì kenyo?” Timaba dan, “Ee, Sir. Nemenal kay.” ");
INSERT INTO mbs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Penga niyan, pinemàdan i Jesus se mata dan, aw minikagi sikandin, “Metoman iyan meinang diyà kenyo tandà te pegsalig niyo diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pegketà, kimità dan. Penga niyan, ontò migpunù si Jesus, “Keilangan wedad palos otaw indanan niyo.” ");
INSERT INTO mbs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Meneng pegkesayo dan, wedà dan tolò kandin, aw yan se doun te labi pa nedengeg si Jesus doton te kebelad te probinsya sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nayan, pegkesayo te didowa otaw pinegolian te mata, doen otaw neomo inibing doton ki Jesus, so dinetengan sikandin te bosaw. ");
INSERT INTO mbs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Penga te pegpelowà i Jesus te bosaw lekat te otaw sìyan, nekeikagi den sikandin. Ontò nepela se kedita te otaw kimità kandin, aw minikagi dan, “Wedad palos kinità tadon iling kenyan dini kenitadon menge bowad-bowad i Israel.” ");
INSERT INTO mbs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Meneng minikagi se menge Parisiyo, “Doen tolos imbegay diyà kandin lekat te pengolo te bosaw si Satanas, aw yan se doun te egpelowà sikandin te bosaw lekat te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nayan, miglegeb si Jesus doton te kedita te lonsod aw doma ogpeanan, aw migtoladà kidoen te menge simbahan te Judiyo. Migtoladà sikandin te Mèpiya Indan tepad te peglowan te Timanem, aw migpegolì te kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pegkità din te medita otaw netipon diyà kandin, ontò din dan neidowan, so ontò dan nelimahan aw wedad egtabang kandan. Iling dan te menge ayam-ayam karniro megketading te eked kenamay aw wedad megdiyaga kandan. ");
INSERT INTO mbs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Penga niyan, minikagi si Jesus te tegdeyanan diyà te menge tinoledaan din, “Ontò dakel se geniyenen, aw pilabok se otaw meglegani. ");
INSERT INTO mbs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Timanem se tig-apò te pawà, aw keilangan megtawal-tawal kaw diyà kandin amon isogò din se menge doma otaw meglegani.” ");
INSERT INTO mbs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nayan, tinawal i Jesus se sempolò teg dowa tinoledaan din, aw imbegay din diyà kandan se tolos amon megpelowà dan te bosaw lekat te otaw, aw amon megpegolì dan te kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Seini se ngadan te sempolò teg dowa sogounun i Cristo, si Simon iningedanan din ki Pedro, aw kedowa din si Andres, aw didowa batà i Sebedeo si Santiago aw si Juan, ");
INSERT INTO mbs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aw si Felipe, si Bartolome, si Tomas, si Mateo sìyan iskribinti, aw si Santiago batà i Alfeo, si Tadeo, ");
INSERT INTO mbs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aw si Simon meyseg, aw si Judas Iscariote, sìyan migtolok ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yan se sempolò teg dowa tinoledaan insogò i Jesus, so doen impunù din diyà kandan, kagi din, “Ikà niyo egdoton te menge ogpeanan te menge otaw kenà Judiyo. Ikà niyo heman egdoton te menge lonsod te Samarya. ");
INSERT INTO mbs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Meneng doton kaw te menge bowad-bowad i Israel. Keilangan tebangan niyo dan so iling dan te menge ayam-ayam karniro migketading. ");
INSERT INTO mbs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pengkey kenan kaw pesalo, pegtoladà kaw te agpet den lomowan se Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pegolii niyo se otaw doen mesakit. Entayi niyo se otaw nematay. Pegolii niyo se otaw pigtompig. Pelowai niyo se bosaw lekat te otaw. Ikà niyo egpebayad te otaw tebangan niyo, so wedad imbayad niyo te tolos insalig ko diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ikà niyo egpengibing te kwarta pengkey bolawan, selapì aw kedakò. ");
INSERT INTO mbs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ikà niyo heman egpengibing te kelepì, aw saol, aw sepatos ekasan niyo, aw bangkà, so keilangan togpoan kaw te otaw tebangan niyo, iling te otaw egterbaho gayed egtogpoan te otaw egtebangan dan. ");
INSERT INTO mbs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aw domateng kaw doton te lonsod aw doma ogpeanan, peg-insà kaw aw sinu se mèpiya otaw ogpaan niyo. Penga niyan, peg-ogpà kaw kidoen te balay din lamig domeleg kaw doton te doma lonsod. ");
INSERT INTO mbs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aw domateng kaw doton te balay, onà kaw ikagi diyà te otaw eg-ogpà kidoen te begayan se kedita dan te kelinaw. ");
INSERT INTO mbs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aw mèpiya se pedowan te otaw eg-ogpà kidoen, metoman dan begayan te kelinaw pineokit te kagi niyo. Meneng aw wedad otaw kidoen mèpiya se pedowan din, lomikò diyà kenyo se inikagi niyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aw doen otaw eked pegsagman kenyo aw eked penenalan te itoladà niyo, tektaki niyo se napò te tanà lekat te sepatos niyo te pegkesayo niyo lekat te balay dan aw lonsod dan. Yan metaga-taga se otaw kidoen te doen salà dan, so wedà dan penenalan te intoladà niyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eneng-enengi niyo se kagi ko kenyo seini. Pengkey ipelumun te Timanem se tege Sodoma aw tege Gomora te modi aldaw tepad te salà dan ontò medaet, meneng labi pa ipelumun te Timanem se otaw eked pegsagman kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nayan, peg-ahà kaw amon eked kaw pemilangi te menge mededaet otaw, so iling kaw te ayam-ayam karniro binenganan te menenanap te kebenesan iningedanan lobo. Yan keilangan ontò kaw megpekebiyasa, aw keilangan wedad palos inangen niyo medaet. ");
INSERT INTO mbs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Peg-ahà kaw te menge mededaet otaw, so ibingen kaw dan doton te howis, aw bedasen kaw dan kidoen te simbahan te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dekepen kaw aw okomen kaw te menge gobirnador aw menge selotan tandà te pegpesakop niyo diyà kanak, amon meg-indan kaw te kebenalan tepad kanak diyà kandan aw diyà te menge doma otaw kenà Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aw ibingen kaw doton te otaw meg-okom kenyo, ikà niyo egketetana tepad te itaba niyo, aw eden se ikegiyen niyo kandan, so dalem te aldaw sìyan, begayan kaw te kebiyasa amon meketaba kaw kandan. ");
INSERT INTO mbs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kenà lekat te kenyo kebiyasa se ikegiyen niyo, meneng mikagi se Espiritu Santo isogò te Timanem Amay niyo pineokit kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Doen otaw megtolok te kandan menge kedowa amon imetayan dan. Doen heman amay megtolok te kandan menge batà amon imetayan dan. Doen heman menge otaw eked pegsagman te kandan amay aw inay, aw ipeimatay dan. ");
INSERT INTO mbs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kebensihan kaw te keditaan te otaw tandà te pegpesakop niyo diyà kanak. Meneng aw tomayod kaw te kedita te kelimahan, ipelowà kaw. ");
INSERT INTO mbs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aw pemilangen kaw kidoen te sebad lonsod, kadas kaw lekat kidoen aw doton kaw te doma lonsod. Penenalan kaw te kagi ko kenyo seini. Siak se Timanem Migpekeotaw, aw lomikò a te eked pa kepenga se pegtoladà niyo kidoen te kedita te lonsod eg-ogpaan te menge bowad-bowad i Israel. ");
INSERT INTO mbs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wedad meiskwilahay labi pa melangkaw diyà te meistro migtoladà kandin. Wedad heman sineligan labi pa melangkaw diyà te amo din. ");
INSERT INTO mbs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Keilangan meluba se meiskwilahay aw mapet se kelangkaw din diyà te kelangkaw te meistro migtoladà kandin. Keilangan meluba heman se sineligan aw mapet se kelangkaw din diyà te kelangkaw te amo din. Netegahan niyo den te tinawal a te doma otaw Belsebul, se doma ngadan i Satanas. Na, aw medaet se intawal dan te Pengolo niyo, labi pa medaet se itawal dan kenyo menge sakop ko.” ");
INSERT INTO mbs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Na, ikà niyo egkelemitan te doma otaw, so ipekità te modi aldaw se kedita te in-eles den seini. Ipetaga-taga heman se kedita wedà pa ketegahi te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pengkey eden se inikagi ko diyà kenyo te olò sikitadon, yan se keilangan ikegiyen niyo diyà te menge doma otaw. Pengkey eden se intoladà ko te wedad doma dimineg, yan se keilangan itoladà niyo diyà te kedita te otaw te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ikà niyo egkelemitan te otaw, so olò lawa niyo se mebatog dan imetayan, kenà pedowan niyo wedad temanan. Meneng sebad se keilangan kelemitanan niyo, aw yan se Timanem, so mebatog din pegbàtan se pedowan aw lawa te otaw doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Meneng ontò heman egkeido se Timanem te otaw. Pengkey iling te wedad keelagà te dowa manok te kebenesan aw beyadan niyo, meneng wedad palos manok te kebenesan medagdag kidoen te tanà aw kenà ibeg te Amay niyo Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yan ikà niyo egkelemitan. So eg-ipaten te Timanem se kedita te manok te kebenesan pengkey iling te wedad keelagà dan, labi kaw pa eg-ipaten te Timanem, so meelagà kaw pa diyà te medita manok te kebenesan. Pengkey logay niyo, netegahan te Timanem aw pila se kedita niyan.” ");
INSERT INTO mbs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aw mikagi se otaw diyà te doma te ontò sikandin migpesakop diyà kanak, mikagi a heman diyà te Amay ko doton te langit te sakop ko se otaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Meneng aw mikagi se otaw te kenà sikandin sakop ko, eked a heman ikagi diyà te Amay ko te sakop ko sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ikà niyo eg-aneng-aneng te dimini a amon doen kelinaw te otaw dini lanto te tanà, meneng labi pa megpedàtay se otaw te pedowan tandà te pegdateng ko. ");
INSERT INTO mbs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eked pegsebad se telebatà tandà te pegdateng ko. Pengkey teleogangan, megpedàtay dan te pedowan tepad kanak. ");
INSERT INTO mbs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Se ontò poon te otaw kwani, yan se menge sakop te kandin balay. ");
INSERT INTO mbs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aw mikagi se otaw te dakel se pedowan din diyà kanak, meneng labi pa dakel se pedowan din diyà te amay aw inay din, eked kepakay megpesakop diyà kanak. Aw mikagi se otaw te dakel se pedowan din kanak, meneng labi pa dakel se pedowan din diyà te batà din, eked kepakay megpesakop diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aw eked taking se otaw kanak so nelemitan te detengan sikandin te kelimahan aw kemetayun, eked kepakay megpesakop diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pengkey ibeg te otaw megkelayat se omol din dini te keneyonan, meneng kunù din gayed matay. Meneng aw mepakay diyà te otaw pengkey imetayan sikandin tandà te pegtaking din kanak, begayan sikandin te kaling pedowan wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Aw megsagman se otaw kenyo, segmanen a din heman. Aw megsagman se otaw kanak, segmanen din heman se Amay ko simogò kanak. ");
INSERT INTO mbs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aw megsagman kaw te telekeliwat te kagi te Timanem tandà te pegkeliwat din te kagi te Timanem, doen ontong ibegay te Timanem diyà kenyo onawa te ontong ibegay din diyà te telekeliwat te kagi din. Aw megsagman kaw te otaw eg-inang te metòlid tandà te peg-inang din te metòlid, doen ontong ibegay te Timanem diyà kenyo onawa te ontong ibegay din diyà te otaw eg-inang te metòlid. ");
INSERT INTO mbs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eneng-enengi niyo se kagi ko kenyo seini. Aw melao se sebad otaw medanà egtaking kanak, aw memegay kaw te wayeg diyà kandin tandà te pegtaking din kanak, begayan kaw te Timanem te ontong.” ");
INSERT INTO mbs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Penga te pegtoladà i Jesus te sempolò teg dowa tinoledaan din, timeped sikandin te menge lonsod medapag amon megtoladà te otaw kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nayan, dalem te pegkekeleboso ki Juan Memonyagay, inindanan sikandin tepad te eg-inangen te Misiyas. Pegdineg i Juan kenyan, insogò din se menge tinoledaan din meg-insà ki Jesus, ");
INSERT INTO mbs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kagi dan, “Sikona lay se ontò insogò te Timanem pinelimanan day, aw doen pa doma domateng?” ");
INSERT INTO mbs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Timaba si Jesus, “Likò kaw den doton ki Juan, aw indani niyo sikandin te kedita te dinineg niyo aw kinità niyo dini. ");
INSERT INTO mbs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Doen menge bota kimità den. Doen heman kapig minipanaw den. Doen tompigun negolian den. Doen bingelen dimineg den. Doen heman nematay neantay den. Doen menge otaw sagkep tinoledaan te Mèpiya Indan. ");
INSERT INTO mbs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Indani niyo heman sikandin te doen keluba te otaw eked pegdowa-dowa te pegsalig din kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pegkesayo te otaw insogò i Juan, minikagi si Jesus tepad ki Juan diyà te otaw netipon, kagi din, “Pegdoton niyo te kebigtilan, kenà tigbaw egkedogen te kelamag se pinengemahà niyo. ");
INSERT INTO mbs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wedà kaw heman doton amon tomengteng te otaw nenaol te ontò meelagà, so se menge otaw egpenaol te ontò meelagà, yan se eg-ogpà doton te balay te selotan. ");
INSERT INTO mbs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Meneng seini indà se tod niyo. Dimoton kaw te kebigtilan amon kitaen niyo se telekeliwat te kagi te Timanem. Pengkey melangkaw se kedita te telekeliwat te kagi te Timanem, meneng labi pa melangkaw si Juan. ");
INSERT INTO mbs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sikandin se migtoladà tepad kanak, aw tinoman din se pakang seini tapay insolat kidoen te kagi te Timanem, ‘Na, doen otaw isogò ko megpetaga-taga te agpet ka den domateng, amon megpeketagad se kedita te otaw te pegdateng nikaw.’” ");
INSERT INTO mbs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Minikagi heman si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Wedad palos otaw dini lanto te tanà labi pa melangkaw diyà ki Juan Memonyagay. Meneng labi pa melangkaw diyà ki Juan se kedita te otaw megpesakop diyà te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Te wedà pa pegtoladà si Juan, gayed migtoladà se menge telekeliwat aw simolat heman si Moises te doen aldaw megtebò se Timanem lomowan. Pengkey lekat te pegtebò te pegtoladà i Juan lamig seini, ontò neibeg se menge otaw megpesakop diyà te peglowan te Timanem, aw medita den se otaw mebolot meibeg peden meg-agaw te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Simpana nemenal kaw te inikagi te menge otaw gebii, netegahan niyo den te si Juan se timoman te intoladà dan te doen domateng iling te telekeliwat te kagi te Timanem gebii si Elias. ");
INSERT INTO mbs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Keilangan menenalan se kedita niyo doen telinga. ");
INSERT INTO mbs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nayan, seini se tegdeyanan iindan ko kenyo amon ketegahan niyo aw eden se pig-ilingan te menge otaw te aldaw seini. Iling dan te mengisù egdanga doton te pedyanan aw egpetewalay dan, ");
INSERT INTO mbs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pengkey mig-edop kay te seluli amon somayaw kaw, meneng wedà kaw sayaw. Pengkey migdelangan kay tepad te pegkematay, meneng wedà kaw heman kelano.’ ");
INSERT INTO mbs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iling heman kandan se menge otaw te aldaw seini, so pegdini i Juan Memonyagay, kinità dan se ketanem din te melikit egpowasa aw kenà palos heman eg-inem. Meneng wedà dan penenalan kandin, aw minikagi dan te dinetengan sikandin te bosaw. ");
INSERT INTO mbs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pegdini ko Timanem Migpekeotaw, kinità dan se ketanem ko te egpengaen a aw eg-inem. Meneng kunù wedà dan penenalan kanak, aw minikagi dan te legoken a aw metiinem a, aw egsigelaken ko se menge iskribinti aw doma otaw nelegeb te salà. Meneng wedad beloyan, so ontò biyasa se Timanem, aw ketegahan iyan te kedita te otaw migpesakop diyà kandin aw komità dan te eg-inangen din.” ");
INSERT INTO mbs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Penga niyan, neopal si Jesus te kedita te otaw eg-ogpà doton te menge lonsod ininangan din te keditaan te kepelahan, so wedà dan pegselsel te salà ininang dan. ");
INSERT INTO mbs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Minikagi sikandin, “Mekelelayò kaw tege Korasin. Mekelelayò kaw heman tege Bitsayda, so wedà kaw pegselsel. Aw impekità diyà te tege Tiro aw tege Sidon gebii se inang metolos impekità ko kenyo, nenaol den dan peden te sako aw migbodbod den dan peden te abo diyà te olo dan amon ipetaga-taga dan te migselsel dan te salà dan ontò medaet. ");
INSERT INTO mbs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eneng-enengi niyo se kagi ko seini. Pengkey ipelumun te Timanem se tege Tiro aw tege Sidon, meneng labi kaw din pa ipelumun, so wedà kaw pemenal kanak. ");
INSERT INTO mbs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sikiyo tege Kapirnaom, pengkey meibeg kaw megpelangkaw-langkaw taman te langit, meneng idagdag kaw doton te kilot. Aw impekità diyà te tege Sodoma se inang metolos impekità ko kenyo, migselsel den dan peden aw wedà heman kebàti se lonsod dan. ");
INSERT INTO mbs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eneng-enengi niyo se kagi ko kenyo. Pengkey ipelumun te Timanem se tege Sodoma te modi aldaw tepad te salà dan ontò medaet, meneng labi kaw din pa ipelumun, so wedà kaw pemenal kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Penga niyan, migtawal-tawal si Jesus, kagi din, “Amà, Pengolo te kedita doton te langit aw dini heman te lanto te tanà, egpesiontong a diyà kamno, so wedà no petega-tegahi se kebenalan diyà te otaw biyasa aw dakel ontò netegahan, meneng impetaga-taga no den iyan diyà te otaw medanà. ");
INSERT INTO mbs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iduyun ta Amà, so lekat iyan te ibeg nikaw ontò mèpiya.” ");
INSERT INTO mbs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Penga niyan, minikagi si Jesus, “Insalig te Amay ko se kedita diyà kanak. Se Amay ko, yan olò se netaga-taga te kedita tepad kanak, so Batà a din. Siak olò heman se netaga-taga te kedita tepad te Amay ko, aw eked ketaga-taga se otaw tepad kandin singed aw ipetaga-taga ko iyan diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aw migkelomay kaw den tandà te pegpengibing niyo te ontò mebegat kidoen te pedowan niyo, diyà kaw den kanak, so ebaten ko iyan diyà kenyo amon mekeetod kaw den. ");
INSERT INTO mbs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiangi niyo se ipeibing ko kenyo iling te yogo, aw peg-iling kaw heman kanak, so ontò mèpiya se pedowan ko, aw mekeetod kaw. ");
INSERT INTO mbs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mèpiya se ipeibing ko kenyo. Kenà mebegat se ipetiang ko kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nayan, penga niyan te wedà kenamay, te aldaw te Sebado, minokit si Jesus aw menge tinoledaan din kidoen te kilid te pawà te trigo agpet den geniyen. Pengkey Sebado se aldaw te peg-etod te menge Judiyo, meneng kimetel se menge tinoledaan din te oway te trigo, aw kinaen dan, so binallos dan. ");
INSERT INTO mbs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Meneng pegkità te menge Parisiyo te ininang dan, minikagi dan diyà ki Jesus, “Tay law. Mig-inang se menge tinoledaan no te salà, so doen punù ingkeliwat i Moises te keilangan eked kidon pegterbaho te aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Minikagi si Jesus, “Kenà medaet se ininang dan. Nelibelan niyo den besi aw eden se insolat kidoen te kagi te Timanem tepad te ininang i David gebii. So binallos sikandin aw menge sondalo timaking kandin, ");
INSERT INTO mbs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","yan minawop dan diyà te balay te Timanem, aw kinaen dan se pan imbegay diyà te Timanem. Pengkey doen punù ingkeliwat i Moises te mepakay olò iyan kànen te menge pengolo te simbahan, meneng kenà medaet se ininang i David. ");
INSERT INTO mbs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nelibelan niyo besi heman aw eden se impunù ingkeliwat i Moises, te keilangan megterbaho se menge pengolo te simbahan pengkey aldaw te peg-etod, meneng kenà iyan salà dan. ");
INSERT INTO mbs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Eneng-enengi niyo se kagi ko seini. Pengkey melangkaw se dakel simbahan, meneng doen dimateng den dini kenyo labi pa melangkaw diyà te simbahan. ");
INSERT INTO mbs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Doen kagi te Timanem insolat, ‘Pengkey measeb kaw egpemegay te bowang diyà kanak, meneng labi a pa meluba aw megpeidoway kaw.’ Simpana mig-aneng-aneng kaw den aw eden se kedegdagan te kagi te Timanem sìyan, eked kaw sila te otaw wedà peg-inang te salà. ");
INSERT INTO mbs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","So siak se Timanem Migpekeotaw, mepakay aw siak se mikagi aw eden se mepakay inangen te otaw te aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nayan, nesayo si Jesus aw dimoton te simbahan te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Doen otaw kidoen nekepis se belad din. Doen heman menge doma otaw kidoen nengemahà te idimanda dan tepad ki Jesus, aw yan se doun te mig-insà dan, “Aw megpegolì se otaw te sebad otaw te aldaw te peg-etod, mekelàpang lay sikandin te punù ingkeliwat i Moises?” ");
INSERT INTO mbs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Minikagi si Jesus, “Aw doen ayam-ayam niyo karniro medagdag doton te medalem awang te tanà te aldaw te peg-etod, ayas kaw megtabang kenyan amon mekelowà. ");
INSERT INTO mbs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pengkey meelagà se karniro, meneng labi pa meelagà se otaw diyà te karniro. Yan se doun te eked kidon làpang te punù ingkeliwat i Moises pineokit te peg-inang tadon te mèpiya pengkey aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Penga niyan, minikagi si Jesus diyà te otaw nekepis se belad, “Oladi se belad nikaw.” Peg-olad din te belad din, migkèpiya iyan, so nekeonawa den te dibaloy. ");
INSERT INTO mbs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Meneng nesayo se menge Parisiyo, aw migpebelaw-belaway dan tepad te inangen dan amon matay dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nayan, pegketaga-taga i Jesus te medaet se ibeg dan, nesayo sikandin lekat kidoen, aw medita se otaw timaking kandin. Migpegolì sikandin te kedita dan doen mesakit, ");
INSERT INTO mbs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aw migpunù sikandin te keilangan wedad doma otaw indanan dan tepad kandin, ");
INSERT INTO mbs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","amon metoman se inikagi te telekeliwat te kagi te Timanem gebii si Isaias, ");
INSERT INTO mbs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Seini se pinemallì ko isogò doton kenyo, sìyan nedekelan ko te pedowan aw nelubahan ko. Ibegay ko se Espiritu Santo meg-ogpà diyà kandin. Megpetaga-taga sikandin te kedita te otaw pengkey kenà Judiyo te agpet a den meg-okom. ");
INSERT INTO mbs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eked sikandin pegbelobansag diyà te menge otaw eked penenalan kandin. Eked heman sikandin pegdindil. Aw megtoladà sikandin doton te menge dalan, eked din pelengkawi se kandin pegkeotawun. ");
INSERT INTO mbs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Inangen din magsen se melomì tigbaw, aw ontò din ipelegdeg se solò kenà melowa lamig domateng se aldaw dàgen din se kedita te kededàtan. ");
INSERT INTO mbs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sikandin se pelimanan te kedita te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nayan, doen otaw bota aw omo inibing doton ki Jesus, so dinetengan te bosaw. Impelowà i Jesus se bosaw lekat kandin, aw penga niyan, nekeikagi sikandin aw kimità den. ");
INSERT INTO mbs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nepela se kedita te otaw kimità kenyan, aw migpebelaw-belaway dan, “Sikandin besi se Misiyas, sìyan bowad-bowad i David egpelimanan tadon.” ");
INSERT INTO mbs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Meneng pegdineg te menge Parisiyo te migpelowà si Jesus te bosaw, minikagi dan, “Binegayan sikandin te tolos lekat te pengolo te bosaw si Belsebul, se doma ngadan i Satanas, aw yan se doun te egpelowà sikandin te bosaw lekat te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Netaga-taga si Jesus te medaet se aneng-aneng dan, aw yan se doun te minikagi sikandin, “Simpana megbebolaw se sakop te sebad selotan, kebàtan se peglowan din te eked kenamay. Simpana megbebolaw se sakop te sebad lonsod, aw megbebolaw se otaw migsebad te balay, kebàtan se ogpeanan dan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Simpana megpelowà si Satanas te menge sakop din, kebàtan se peglowan din, so inangen din poon se menge sakop din. ");
INSERT INTO mbs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aw sinila niyo se pegpelowà ko te bosaw so eden niyo aw pineokit te tolos i Belsebul, sinila niyo heman se kenyo tinoledaan, so egpelowà dan heman te bosaw lekat te otaw. Yan se doun te sikandan se megpetaga-taga kenyo te kolang se pegsila niyo kanak. ");
INSERT INTO mbs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Meneng aw pineokit te Espiritu Santo se pegpelowà ko te bosaw lekat te otaw, yan ketegahan niyo te dimateng den dini kenyo se peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aw magsen se otaw, eked keagaw se awop te balay din singed aw domateng se otaw labi pa magsen diyà kandin. Yan se mekedaeg te tig-apò te balay aw meglegapos kandin, aw penga niyan mengabat sikandin te awop te balay. ");
INSERT INTO mbs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Se kedita te otaw eked pegpesakop diyà kanak, yan se egpoon kanak, aw se kedita te otaw kenà egtelaban kanak, iling te egpekadas dan te doma otaw lekat kanak. ");
INSERT INTO mbs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yan se doun te mikagi a den kani. Aw meg-inang se otaw te salà, pengkey medaet se inang din aw kagi din, meneng aw megselsel sikandin, pegwedaden te Timanem se salà din. Meneng aw megtompuyus se otaw te Espiritu Santo, eked palos pegwedadi te Timanem se salà din sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aw mikagi se otaw te medaet tepad kanak Timanem Migpekeotaw, aw megselsel sikandin, pegwedaden iyan te Timanem. Meneng aw mikagi se otaw te medaet tepad te Espiritu Santo, eked palos pegwedadi se salà din sìyan, pengkey seini aw modi aldaw.” ");
INSERT INTO mbs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Aw mèpiya se kayo, mèpiya heman se pongo niyan. Aw medaet se kayo, medaet heman se pongo niyan. Aw kitaen niyo se pongo te kayo, ketegahan niyo aw eden kemoloi se kayo sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iling kaw te memokan so medaet se eglowà lekat te bahà niyo. Wedad palos mèpiya ikegiyen niyo, so medaet se pedowan niyo. Aw mikagi se otaw, yan ipetaga-taga din aw eden se awop te pedowan din. ");
INSERT INTO mbs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aw mèpiya se pedowan te otaw, mèpiya heman se eg-inangen din. Meneng aw medaet se pedowan te otaw, medaet heman se eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Penenalan kaw te kagi ko kenyo seini. Aw domateng se aldaw te peg-okom te Timanem te otaw, ipelumun din se kedita te otaw minikagi te kagi wedad kekemowan. ");
INSERT INTO mbs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aw mèpiya se eg-ikegiyen niyo, eked kaw pelumuni. Meneng aw medaet se eg-ikegiyen niyo, ipelumun kaw.” ");
INSERT INTO mbs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Penga niyan, nemoyò se menge Parisiyo aw menenoladà te punù, kagi dan, “Sir, ibeg day ipekità no diyà kenami se pengilala amon ketegahan day te ontò ka insogò te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Meneng minikagi si Jesus, “Medaet se ibeg te kedita te otaw songkani timinàyog te Timanem, so gayed kaw egkeibeg te ipekità ko diyà kenyo se pengilala. Meneng sebad olò se pengilala ipekità te Timanem diyà kenyo, aw yan se iling te neinang diyà te telekeliwat te kagi te Timanem gebii si Jonas. ");
INSERT INTO mbs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","So netelowan si Jonas doton te getek te dakel ikan gebii, iling heman kenyan, siak Timanem Migpekeotaw se ketelowan doton didalem te tanà. ");
INSERT INTO mbs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aw domateng se aldaw te peg-okom te Timanem te kedita te otaw, tomindeg heman se tege Niniba aw mikagi dan te keilangan ipelumun kaw so wedà kaw pegselsel te salà, so pegdineg te tege Niniba te intoladà i Jonas, migselsel dan te salà. Na, pengkey melangkaw si Jonas, meneng doen den dimini kenyo labi pa melangkaw diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aw domateng se aldaw te peg-okom te Timanem te kedita te otaw, tomindeg heman se selotan bayi limowan doton te Siba gebii, aw mikagi sikandin te keilangan ipelumun kaw so wedà kaw penenalan kanak. Pengkey mediyò se ogpeanan din, meneng dimoton sikandin ki Solomon amon menenalan te kebiyasa ipegtoladà din. Na, pengkey melangkaw si Solomon, meneng doen den dimini labi pa melangkaw diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Aw ipelowà se bosaw lekat te otaw, meglegeb se bosaw doton te kebigtilan amon mengemahà te mèpiya ogpeanan din. Aw wedad ketelaan din, ");
INSERT INTO mbs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mikagi sikandin, ‘Mèpiya pa aw lomikò a doton te otaw tapay ko eg-ogpaan.’ Lomikò se bosaw doton kandin, aw kitaen din se otaw tapay din inogpaan te mèpiya den, iling te balay melinis aw mèpiya pegkesawol. ");
INSERT INTO mbs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Penga niyan, mangay se bosaw te doma pito bosaw labi pa medaet. Domoton se kedita dan te otaw sìyan aw meg-ogpà dan diyà kandin. Yan labi pa medaet se pegkesawol te otaw sìyan diyà te tapay pegkesawol din. Iling heman kenyan se medaet domateng diyà te kedita te otaw songkani so medaet se ibeg dan.” ");
INSERT INTO mbs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nayan, dalem te migtoladà pa si Jesus, dimateng se inay din aw menge kedowa din. Migtagad dan doton te lowà te balay, so ibeg dan megkità kandin. ");
INSERT INTO mbs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Doen otaw minikagi diyà ki Jesus, “Doton te lowà se inay no aw menge kedowa nikaw. Meibeg dan ekon megkità kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Meneng minikagi si Jesus, “Mikagi a den diyà kenyo aw sinu se inay ko aw menge kedowa ko.” ");
INSERT INTO mbs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Penga niyan, intedò i Jesus se menge tinoledaan din, aw minikagi sikandin, “Seini se inay ko aw menge kedowa ko. ");
INSERT INTO mbs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Se menge otaw egtolò te ibeg te Amay ko doton te langit, yan se meinang inay ko aw menge kedowa ko meama aw bayi.” ");
INSERT INTO mbs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nayan, te aldaw sìyan, limowà si Jesus lekat te balay, aw dimoton te kilid te lanaw, aw nenenoo kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ontò medita se otaw netipon diyà kandin, aw yan se doun te minalin sikandin doton te belangay pinondohan. Nenenoo sikandin, meneng mig-ogpà se kedita te otaw tinoledaan din doton te kilid te lanaw. ");
INSERT INTO mbs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Penga niyan, medita se kebenalan intoladà din kandan pineokit te tegdeyanan. Minikagi si Jesus, “Doen otaw dimoton te pawà amon menabog te benì, so yan se ketanem te pegpenanem din. ");
INSERT INTO mbs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pegsabog din, doen benì nesabog diyà te dalan, aw kinaen iyan te menge manok te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Doen heman benì nesabog diyà te tanà kebeto-betowan, aw wedad nael tanà kidoen. Timobò iyan te wedà kenamay, so kenà medalem se tanà. ");
INSERT INTO mbs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Meneng pegkelangkaw te aldaw, nelanes aw nematay so wedad nael dalid. ");
INSERT INTO mbs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Doen heman benì nesabog diyà te pinonoan te sagbet doen tigis. Timilles heman se sagbet doen tigis, aw kinelep se menge tobò aw nematay. ");
INSERT INTO mbs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Meneng doen benì nesabog diyà te melambò tanà. Yan se timilles aw minongo. Doen minongo te ginatos, aw doen minongo te keneman aw ketlowan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Minikagi heman si Jesus, “Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Penga niyan, dimoton se menge tinoledaan i Jesus kandin, aw mig-insà dan, “Nengà lay pineokit te tegdeyanan se pegtoladà no te menge doma otaw?” ");
INSERT INTO mbs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Timaba si Jesus, “Sikiyo se pinetega-tegahan te Timanem te kebenalan tepad te peglowan din. Meneng wedà din petega-tegahi se doma otaw te kebenalan tepad te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Se otaw kominawà te kebenalan, yan se dogangan te kebenalan amon labi pa dakel diyà te keilangan din. Meneng se otaw eked kinawà te kebenalan, yan se pegwedadan te kebenalan. ");
INSERT INTO mbs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yan olò pineokit te tegdeyanan se pegtoladà ko te doma otaw amon pengkey tomengteng dan, meneng eked dan kità te kedegdagan niyan. Pengkey domineg dan, meneng eked dan ketaga-taga te kebenalan. ");
INSERT INTO mbs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pineokit kandan, netoman se inikagi te telekeliwat te kagi te Timanem gebii si Isaias, ‘Pengkey domineg kaw, meneng eked kaw pekelabet te dinegen niyo. Pengkey tomengteng kaw, meneng eked kaw ketaga-taga aw eden se kitaen niyo. ");
INSERT INTO mbs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Metoman iyan so migkekagsen den se olo dan amon eked dan pemenal. Neinang den bingelen se telinga dan amon eked dan dineg te kebenalan. Inlipedeng dan se mata dan amon eked dan kità te kedegdagan te kagi ko kandan, so eked dan keibeg pengenganay diyà kanak amon tebangan ko dan.’ ");
INSERT INTO mbs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Meneng doen den keluba niyo, so kimità kaw den aw dimineg kaw den te kebenalan. ");
INSERT INTO mbs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eneng-enengi niyo se kagi ko seini. Pengkey medita se telekeliwat te kagi te Timanem aw doma otaw eg-inang te metòlid gebii ibeg komità te inang ko kinità niyo, meneng wedà dan kità kenyan. Pengkey ibeg dan domineg te kagi ko dinineg niyo, meneng wedà dan dineg kenyan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Penenalan kaw den te kedegdagan te tegdeyanan tepad te otaw nenabog te benì. ");
INSERT INTO mbs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Se benì nesabog diyà te dalan, yan se iling te otaw domineg tepad te peglowan te Timanem meneng eked sikandin pekelabet. Penga niyan, doen inangen i Satanas amon kelibelan din se kagi te Timanem dinineg din. ");
INSERT INTO mbs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nayan, se benì nesabog diyà te tanà kebeto-betowan, yan se iling te otaw domineg te kagi te Timanem, aw meluba sikandin, aw tomolò sikandin kenyan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Meneng aw domateng se kelimahan aw pemilangen sikandin tandà te pegpemenal din te kagi te Timanem, tenanan din se pinemenalan din, so iling sikandin te tinanem wedad nael dalid. ");
INSERT INTO mbs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nayan, se benì nesabog diyà te pinonoan te sagbet doen tigis, yan se iling te otaw ontò domineg te kagi te Timanem intoladà. Meneng penga niyan, wedad ontong din so dàgen sikandin te ibeg din tomaking te ketanem te keneyonan, aw ibeg din megkeyaman amon meluba sikandin. Yan se doun te wedad ontong din diyà te kagi te Timanem dinineg din. ");
INSERT INTO mbs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Meneng se benì nesabog diyà te melambò tanà, yan se iling te otaw domineg te kagi te Timanem, aw mekelabet kenyan. Doen ontong din iling te intanem mongo te ginatos, aw keneman aw ketlowan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Migtoladà si Jesus te doma tegdeyanan, kagi din, “Iling kani se peglowan te Timanem. Doen otaw nenanem te mèpiya kemolò te omay trigo doton te pawà din. ");
INSERT INTO mbs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Meneng pegkedelem niyan, doen medaet otaw dimoton te pawà sìyan, aw nenanem heman te benì te sagbet onawa se bawa diyà te trigo intanem te tig-apò. Penga niyan, nesayo se otaw nenanem te medaet benì. ");
INSERT INTO mbs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eleg timilles se trigo aw sagbet. Meneng pegpemagting te trigo, kinità se sagbet so wedad pongo niyan. ");
INSERT INTO mbs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dimoton se menge sineligan te amo dan, aw mig-insà dan, ‘Ontò mèpiya se benì intanem tadon doton te pawà nikaw. Meneng kenan lekat se sagbet?’ ");
INSERT INTO mbs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Timaba se tig-apò, ‘Yan se intanem te otaw neopal kanak.’ Penga niyan, mig-insà dan, ‘Meibeg ka lay aw pispisen day se sagbet?’ ");
INSERT INTO mbs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Meneng minikagi sikandin, ‘Ikà niyo pa egpemispis te sagbet so mepispis heman se trigo intanem tadon. ");
INSERT INTO mbs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pebeyai niyo iyan tomilles. Aw domateng se aldaw te peglegani, isogò ko se menge otaw meglegani te onà dan pispisen se sagbet aw begkesen dan iyan amon sonogen. Meneng geniyen dan se trigo, aw isawol dan iyan doton te pol.’” ");
INSERT INTO mbs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Migtoladà si Jesus te doma tegdeyanan, kagi din, “Iling kani se peglowan te Timanem. Doen benì ontò deitek intanem te otaw doton te pawà din. ");
INSERT INTO mbs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pengkey wedad ekon palos benì labi pa deitek kenyan, meneng aw tomilles iyan, labi pa iyan dakel diyà te kedita te doma intanem din. Megkedakel iyan iling te kayo, aw megsalag se menge manok kidoen.” ");
INSERT INTO mbs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Migtoladà si Jesus te doma tegdeyanan, kagi din, “Iling heman kani se peglowan te Timanem. Aw isanged se yist diyà te dakel arina, lomebag se kedakel niyan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gayed migtoladà si Jesus te otaw netipon pineokit te tegdeyanan tepad te peglowan te Timanem, so impeokit din te tegdeyanan se kedita te intoladà din kandan. ");
INSERT INTO mbs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pineokit kenyan, tinoman din se kagi te telekeliwat te kagi te Timanem gebii, “Megtoladà a te otaw pineokit te tegdeyanan. Iindan ko diyà kandan se wedà ko petega-tegahi lekat te keteboan te keneyonan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Penga niyan, nesayo si Jesus lekat kidoen te otaw netipon, aw minawop diyà te balay. Timaking se menge tinoledaan din aw nemoyò dan, “Indani kay aw eden se kedegdagan te tegdeyanan tepad te sagbet timilles kidoen te pawà.” ");
INSERT INTO mbs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Minikagi si Jesus, “Se tig-apò te pawà nenanem te mèpiya benì, siaken iyan Timanem Migpekeotaw. ");
INSERT INTO mbs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Se pawà, yan se keneyonan. Se mèpiya benì, yan se menge otaw migpesakop diyà te peglowan te Timanem. Meneng se sagbet, yan se menge sakop i Satanas. ");
INSERT INTO mbs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Se medaet otaw nenanem te sagbet, yan si Satanas. Se kedegdagan te peglegani, yan se temanan te keneyonan, aw se otaw meglegani, yan se menge anghil. ");
INSERT INTO mbs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tinipon dan se sagbet aw sinonog dan. Iling heman kenyan se meinang aw domateng se temanan te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Siak Timanem Migpekeotaw se somogò te menge anghil amon melobos se peglowan ko. Tiponen dan se kedita te otaw eg-inang te salà aw egboyo te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Penga niyan, iagbel se kedita dan kidoen te apoy doton te kilot. Ontò dan megkelag doton, aw megyangget-yangget se ngipen dan tandà te kegemakan dan. ");
INSERT INTO mbs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Meneng iling te pegsenang te aldaw, somenang heman se otaw eg-inang te metòlid aw domateng dan doton te peglowan te Amay dan Timanem. Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Iling kani se peglowan te Timanem. Doen bolawan nenamay inlebeng doton te tanà. Nayan, doen otaw neketalà kenyan. Neluba se pedowan din, meneng todà din inlebeng, aw minolì. Penga niyan, imbeligyà din se kedita te kededònan din aw bineyadan din se tanà sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Iling heman kani se peglowan te Timanem. Doen tindiro egbayad te mèpiya kemolò te pirlas iling te peninga te bayi. ");
INSERT INTO mbs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nayan, doen pirlas kinità din ontò meelagà so ontò mèpiya se bawa niyan. Penga niyan, minolì sikandin, aw imbeligyà din se kedita te kededònan din aw bineyadan din se pirlas sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iling heman kani se peglowan te Timanem. Doen pokot indagdag doton te lanaw, aw medita se kemolò te ikan nekeawop. ");
INSERT INTO mbs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pegkedita te ikan, inanggin iyan te otaw egpemokot diyà te kilid te lanaw amon ebaten dan se ikan. Insawol dan se mèpiya kemolò diyà te alat, meneng in-agbel dan se mededaet. ");
INSERT INTO mbs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iling heman kenyan se meinang aw domateng se temanan te keneyonan. Teniyen te menge anghil se otaw eg-inang te medaet aw otaw eg-inang te metòlid. ");
INSERT INTO mbs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Penga niyan, iagbel dan se otaw mededaet kidoen te apoy doton te kilot. Ontò dan megkelag doton, aw megyangget-yangget se ngipen dan tandà te kegemakan dan.” ");
INSERT INTO mbs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nayan, mig-insà si Jesus diyà te menge tinoledaan din, “Nelebetan niyo lay se kedita te intoladà ko?” Timaba dan, “Ee. Nelebetan day.” ");
INSERT INTO mbs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Minikagi si Jesus, “Aw doen otaw biyasa te kagi te Timanem tapay insolat, aw meg-iling heman sikandin te kaling itoladà ko tepad te peglowan te Timanem, iling sikandin te otaw doen dakel kedònan gayed din eggemiten, pengkey tapay aw kaling.” ");
INSERT INTO mbs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nayan, penga te pegtoladà i Jesus te kedita te tegdeyanan sìyan, nesayo sikandin ");
INSERT INTO mbs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aw minolì doton te kandin lonsod. Migtoladà sikandin doton te simbahan te Judiyo. Ontò nepela se menge otaw kidoen, aw minikagi dan, “Sebad den ini, so ontò sikandin biyasa, aw mèpiya heman se kepelahan eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Meneng netegahan tadon te sikandin se batà te karpintiro, aw si Maria se inay din. Netegahan tadon heman se menge kedowa din si Santiago, si Jose, si Simon, aw si Judas. ");
INSERT INTO mbs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eg-ogpà heman se menge etebay din dini kenitadon. Ontò kidon nepela so dakel den se nebatog din.” ");
INSERT INTO mbs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yan nebensi dan kandin. Meneng minikagi si Jesus, “Gayed egsegmanen te doma otaw se telekeliwat te kagi te Timanem, meneng kenà sikandin egsegmanen te otaw te kandin lonsod aw menge kedowa din.” ");
INSERT INTO mbs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yan se doun te pilabok se kepelahan ininang i Jesus kidoen, so wedà dan pemenal kandin. ");
INSERT INTO mbs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nayan, si Herod se otaw limowan doton te Galiliya, aw doen dinineg din tepad te eg-inangen i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Minikagi sikandin diyà te menge opisyal, “Sikandin besi si Juan Memonyagay neantay den lekat te nematay, aw yan se doun te eg-inangen din se kepelahan metolos.” ");
INSERT INTO mbs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yan se inikagi din, so kedengan impedakep din si Juan, aw impegapos din, aw impekeleboso din. Yan se ininang din diyà ki Juan amon meluba se nayi din si Herodias inagaw din diyà te kedowa din si Felipe. ");
INSERT INTO mbs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Peg-agaw i Herod te nayi din, simila si Juan kandin, kagi din, “Mig-inang ka den te salà, so nengagaw ka te nayi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ibeg i Herod ipeimatay din si Juan, meneng wedà deleg, so nelemitan sikandin te meopal se kedita te otaw kandin, so eg-aneng-aneng dan te si Juan se ontò telekeliwat te kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Peg-inang i Herod te pista tepad te aldaw te pegtebaw din, simayaw se laga batà i Herodias amon meluba se menge otaw timanod. Ontò heman neluba si Herod, ");
INSERT INTO mbs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","aw yan se doun te ontò sikandin migsapà te ibegay din diyà te laga sìyan se pengkey eden se pemoyoen din. ");
INSERT INTO mbs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Penga niyan, timolò se laga te punù te inay din aw minikagi, “Pesipali se lieg i Juan Memonyagay, aw pesoli se olo din diyà te dakel sablag, aw peibingi dini kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nelidò se pedowan i Herod. Meneng so migsapà sikandin, aw eked keibeg silahen te menge otaw timanod, tinoman din se pinemoyò te laga. ");
INSERT INTO mbs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Insogò din se sondalo doton te keleboso. Sinipal din se lieg i Juan. ");
INSERT INTO mbs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Insawol din se olo diyà te sablag, aw imbegay din diyà te laga, aw inibing din doton te inay din. ");
INSERT INTO mbs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Penga niyan, dimoton se menge tinoledaan i Juan te keleboso, aw inabat dan se lawa din aw inlebeng dan iyan. Penga niyan, dimoton dan ki Jesus aw mig-indan dan diyà kandin tepad te pegkematay i Juan. ");
INSERT INTO mbs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nayan, pegdineg i Jesus tepad te pegpengimatay ki Juan, nesayo sikandin lekat kidoen. Simakay sikandin te belangay aw dimoton te kesikmihan. Meneng pegketaga-taga te kedita te otaw te pineselowan i Jesus, dimoton dan heman. Minipanaw dan lekat te menge ogpeanan dan. ");
INSERT INTO mbs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pegtenà i Jesus, kinità din se ontò medita otaw migtagad kandin. Ontò din dan neidowan, aw pinegolian din se kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pegkeapon niyan, dimoton se tinoledaan din kandin, aw minikagi dan, “Ontò ini kebigtilan, aw agpet den delem. Pekeseyowi se kedita te otaw doton te lonsod amon mayad dan te kànen dan.” ");
INSERT INTO mbs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Minikagi si Jesus, “Ikà niyo egpekesayo kandan. Pemekàni niyo dan.” ");
INSERT INTO mbs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Minikagi dan, “Meneng doen olò lima se pan, aw didowa se ikan.” ");
INSERT INTO mbs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Minikagi si Jesus, “Ibingi niyo iyan dini kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Penga niyan, impeonsad din se kedita te otaw kidoen te sagbet. Inabat din se lima pan aw didowa ikan. Limengag sikandin doton te langit aw migpesiontong diyà te Timanem kenyan. Penga niyan, binelà-belà din se pan aw imbegay din diyà te menge tinoledaan din, aw imbegay dan iyan diyà te menge otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kimaen se kedita dan aw nebesog dan. Penga niyan, inimon dan se samà te pan kinaen dan, aw sempolò teg dowa se buun nepenò. ");
INSERT INTO mbs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Menge lima melalan se meama kimaen kenyan, aw wedà bilangi se menge bayi aw mengisù. ");
INSERT INTO mbs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Penga niyan, impeonà i Jesus se menge tinoledaan din simakay te belangay pesalo doton dipag te lanaw. Dalem niyan, impeolì din se kedita te otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pegkesayo dan, timikedeg si Jesus doton te bontod sebad din amon megtawal-tawal. Pegsallep te aldaw, kidoen si Jesus te bontod olò din sebad. ");
INSERT INTO mbs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Meneng mediyò den se belangay doton te lawod te lanaw. Ontò dan nelimahan, so dinetengan dan te dedakel balud aw simongsong dan te kelamag. ");
INSERT INTO mbs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ontò mata-mata te iselem, dimoton si Jesus kandan aw minipanaw sikandin diyà te lanto te lanaw. ");
INSERT INTO mbs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Meneng pegkità dan kandin, ontò dan nelemitan. Migpuypuy dan tandà te lamit dan, aw minikagi dan, “Along iyan.” ");
INSERT INTO mbs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Meneng pegketà timawal si Jesus, “Peseligi niyo se pedowan niyo, so siaken ini. Ikà niyo egkelemitan.” ");
INSERT INTO mbs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Minikagi si Pedro, “Pengolo, aw ontò sikona, peipenawi a diyà te lanto te lanaw pesalo doton kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Minikagi si Jesus, “Na, diyà ka.” Penga niyan, timenà si Pedro lekat te belangay aw minipanaw diyà te lanto te lanaw pesalo doton ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Meneng peg-imanman din te kelamag ontò mebandes, nelemitan aw agpet melemes. Meneng nengenganay sikandin, kagi din, “Pengolo, tebangi a.” ");
INSERT INTO mbs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mig-ayas si Jesus minawid kandin, aw minikagi, “Wedà pa kedì kelobos se pegsalig no kanak. Nepela a so migdowa-dowa ka.” ");
INSERT INTO mbs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Penga niyan, eleg dan simakay te belangay, aw timunung se kelamag. ");
INSERT INTO mbs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Limongken se doma tinoledaan diyà ki Jesus, aw migsimba dan kandin, aw minikagi dan, “Ontò ka Batà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nayan, penga te pegbatas dan te lanaw, dimateng dan doton te Genesarit. ");
INSERT INTO mbs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kimilala se tege Genesarit ki Jesus, aw impeangay dan se kedita te otaw doen mesakit lekat te kedepagan niyan. ");
INSERT INTO mbs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nemoyò dan diyà ki Jesus aw mepakay dan olò memaed te toktok te saol din, aw negolian se kedita dan nemaed kenyan. ");
INSERT INTO mbs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nayan, doen menge Parisiyo aw menenoladà te punù ingkeliwat i Moises dimoton ki Jesus lekat te Jerusalem. Minikagi dan diyà kandin, ");
INSERT INTO mbs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Eglàpang se menge tinoledaan no te ketanem te kemonaan tadon, so kenà dan eg-onaw te belad dan te eked dan pa kaen.” ");
INSERT INTO mbs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Minikagi si Jesus, “Eglàpang kaw heman te punù te Timanem pineokit te pegtaking niyo te ketanem te kemonaan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Migpunù se Timanem, ‘Keilangan segmanen no se amay aw inay nikaw.’ Migpunù heman sikandin, ‘Keilangan imetayan se otaw megtindaet te amay aw inay din.’ ");
INSERT INTO mbs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Meneng egtoladà kaw te mepakay aw eked pegsagman se otaw te amay aw inay din aw olò mikagi diyà kandan, ‘Se itabang ko peden kenyo, yan se tapay ko imbegay diyà te Timanem.’ ");
INSERT INTO mbs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Meneng pineokit te pegtaking niyo te ketanem sìyan, timinàyog kaw den te kagi te Timanem te keilangan segmanen niyo se amay aw inay niyo. ");
INSERT INTO mbs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tay law. Eden niyo aw egpenimanem kaw. Sikiyo se tinedoan te kagi te Timanem ingkeliwat i Isaias gebii, ");
INSERT INTO mbs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Pengkey eg-ikagi se otaw sìyan te egtaking dan kanak, meneng wedà kelobos se pedowan dan diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wedad ontong te pegsimba dan kanak, so se ketanem te otaw ipegtoladà dan, yan se ininang dan punù te Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nayan, medita se otaw netipon kidoen, aw timawal si Jesus diyà kandan amon megpedapag dan diyà kandin. Minikagi sikandin, “Penenalan kaw kanak amon mekelabet kaw kani. ");
INSERT INTO mbs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kenà egpekesalà se otaw pineokit te iawop din diyà te bahà din. Meneng egpekesalà se otaw pineokit te lomowà lekat te bahà din.” ");
INSERT INTO mbs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Penga niyan, dimoton se menge tinoledaan i Jesus kandin, aw minikagi dan, “Neopal den se menge Parisiyo tepad te inikagi no sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Minikagi si Jesus, “Pegbàtan dan te Amay ko eg-ogpà doton te langit, iling te sagbet pispisen doton te pawà. ");
INSERT INTO mbs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pebeyai niyo se menge Parisiyo. Iling dan te otaw bota megtelaman mengibing te doma. Meneng wedad otaw bota mekeagak te doma din bota, so medagdag se didowa dan doton te awang te tanà.” ");
INSERT INTO mbs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Minikagi si Pedro, “Lebadi diyà kenami se tegdeyanan intoladà no gina.” ");
INSERT INTO mbs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Minikagi si Jesus, “Nepela a so iling kaw heman te doma otaw wedà pekelabet. ");
INSERT INTO mbs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pengkey eden se kànen iawop diyà te bahà te otaw, yan se domeleg doton te getek, aw penga niyan lomowà lekat te lawa. ");
INSERT INTO mbs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Meneng se kagi lomowà lekat te bahà te otaw, lekat iyan te pedowan din, aw yan se doun te egpekesalà se otaw. ");
INSERT INTO mbs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pedowan se kelekatan te medaet ibeg te otaw egbonò, aw eglakad, aw egpenakaw, aw egkebolalaw, aw egbaet-baet. ");
INSERT INTO mbs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Egpekesalà se otaw pineokit te kedita niyan. Meneng kenà egpekesalà se otaw kenà eg-onaw te belad te eked pa kaen.” ");
INSERT INTO mbs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nesayo si Jesus lekat kidoen aw dimoton te probinsya medapag te lonsod te Tiro aw Sidon. ");
INSERT INTO mbs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Doen bayi mig-ogpà kidoen kenà Judiyo so lekat te Canaan se menge kemonaan din. Dimoton sikandin ki Jesus aw minikagi te dakel se kagi din, “Sir, bowad-bowad i David, keidowi a bag, so ontò dinetengan te bosaw se batà ko bayi.” ");
INSERT INTO mbs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Meneng wedà sikandin segmani i Jesus. Yan dimoton se menge tinoledaan i Jesus kandin aw nemoyò dan, kagi dan, “Pekeseyowi se bayi sìyan, so egtaking kenitadon aw gayed egbelisì.” ");
INSERT INTO mbs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Minikagi si Jesus, “Olò menge bowad-bowad i Israel se sinogoan kanak tebangan ko, so iling dan te menge karniro migketading.” ");
INSERT INTO mbs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nayan, migpedapag se bayi diyà ki Jesus, aw limongken diyà kandin, aw minikagi, “Sir, tebangi a bag.” ");
INSERT INTO mbs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mig-indan si Jesus te tegdeyanan amon metaga-taga se bayi te olò menge Judiyo se tebangan din, kagi din, “Eked kepakay aw ebaten te otaw se kànen te menge batà din amon ibegay din diyà te menge toyang.” ");
INSERT INTO mbs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Minikagi se bayi, “Sir, benal iyan. Meneng mepakay aw komaen se toyang te momò medagdag lekat te lemisa te tig-apò.” ");
INSERT INTO mbs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Penga niyan, minikagi si Jesus, “Tiyà, ontò ka simalig kanak. Tomanen ko den se ibeg nikaw.” Pegketà, negolian se batà din. ");
INSERT INTO mbs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nayan, nesayo si Jesus lekat kidoen, aw minokit te kilid te lanaw te Galiliya. Timikedeg sikandin te bontod medapag, aw nenenoo kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ontò medita se otaw dimoton kandin, aw inibing dan heman se menge doma otaw doen medita kemolò te mesakit. Doen menge kapig, aw nepantig, aw bota, aw omo, aw medita heman se doma otaw doen mesakit. Insawol dan doton dapag i Jesus, aw pinegolian din dan. ");
INSERT INTO mbs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nepela se kedita te otaw, so kinità den dan te minikagi den se omo, aw negolian se nepantig, aw minipanaw se kapig, aw kimità den se bota. Yan se doun te dimuyun dan te Timanem egseligan te menge bowad-bowad i Israel. ");
INSERT INTO mbs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na, penga niyan, tinawal i Jesus se menge tinoledaan din, aw minikagi sikandin, “Neidowan ko den se menge otaw dini, so netelowan den dan timaking kanak, aw wedad den kànen dan. Eked kepakay aw ipeolì ko dan te binallos dan pa, so metapì dan kidoen te dalan.” ");
INSERT INTO mbs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Minikagi se tinoledaan din, “Meneng kebigtilan ini, aw wedad palos ebatan tadon te pan botong te ipekaen tadon kandan, so ontò dan medita.” ");
INSERT INTO mbs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mig-insà si Jesus, “Pila lay se pan inibing niyo?” Timaba dan, “Pito olò, aw pilabok se ikan dedeitek.” ");
INSERT INTO mbs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Penga niyan, impeonsad din se kedita te otaw diyà te tanà. ");
INSERT INTO mbs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inabat din se pito pan aw ikan, aw migpesiontong diyà te Timanem kenyan. Binelà-belà din iyan, aw imbegay din diyà te menge tinoledaan din, aw inteped dan diyà te menge otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kimaen se kedita dan aw nebesog dan. Penga niyan, inimon dan se samà te pan kinaen dan, aw pito se boliyas nepenò. ");
INSERT INTO mbs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Menge epat melalan se meama kimaen kenyan, aw wedà bilangi se menge bayi aw mengisù. ");
INSERT INTO mbs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Penga niyan, impeolì i Jesus se kedita dan, aw simakay sikandin te belangay aw dimoton te probinsya medapag te Magadan. ");
INSERT INTO mbs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nayan, doen menge Parisiyo aw Sadusiyo dimoton ki Jesus amon megtandà dan kandin. Nemoyò dan te ipekità din diyà kandan se pengilala amon ketegahan dan te ontò sikandin insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Minikagi si Jesus, “Aw melalag se langit te pegsallep te aldaw, ketegahan niyo te eked odan te keeldawan niyan. ");
INSERT INTO mbs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aw melalag se langit te iselem aw domelem, ketegahan niyo te modan te aldaw sìyan. Nepela a kenyo, so pengkey egpengilala kaw te ledyawan doton te langit, meneng wedà niyo kilelai aw eden se kedegdagan te egkeinang seini. ");
INSERT INTO mbs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Medaet se ibeg te kedita te otaw songkani timinàyog te Timanem, so gayed kaw egkeibeg te ipekità ko diyà kenyo se pengilala. Meneng sebad olò se pengilala ipekità te Timanem diyà kenyo, aw yan se iling te neinang diyà te telekeliwat te kagi te Timanem gebii si Jonas.” Penga niyan, nesayo si Jesus lekat kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nayan, minatas se menge tinoledaan i Jesus te lanaw, meneng wedad pan inibing dan so nelibelan dan se bawo dan. ");
INSERT INTO mbs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Minikagi si Jesus, “Peg-ahà kaw amon eked kaw ketini te yist te menge Parisiyo aw Sadusiyo.” ");
INSERT INTO mbs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Migpebelaw-belaway se menge tinoledaan din, kagi dan, “Yan se inikagi din so wedad pan inibing tadon.” ");
INSERT INTO mbs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Meneng netegahan i Jesus aw eden se aneng-aneng dan, aw minikagi sikandin, “Tay law. Wedà pa kedì kelobos se pegsalig niyo kanak. Ikà niyo egkepela so wedad pan inibing niyo. ");
INSERT INTO mbs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nepela a kenyo, so wedà kaw pa ketaga-taga aw eden se mebatog ko inangen. Iling te nelibelan niyo den se pegpekaen ko te lima melalan otaw te lima pan, aw medita se buun inipenò niyo te samà. ");
INSERT INTO mbs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iling te nelibelan niyo heman se pegpekaen ko te epat melalan otaw te pito pan, aw medita se boliyas inipenò niyo te samà. ");
INSERT INTO mbs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Meneng nepela a so wedà kaw pa pekelabet te kenà pan se kedegdagan te inikagi ko gina, te keilangan meg-ahà kaw amon eked kaw ketini te yist te menge Parisiyo aw Sadusiyo.” ");
INSERT INTO mbs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Penga niyan, nekelabet dan te kenà yist te pan se keilangan imendayan dan, meneng keilangan megpekeimanday dan te ipegtoladà te menge Parisiyo aw Sadusiyo. ");
INSERT INTO mbs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nayan, dimoton si Jesus te lonsod medapag te Sesarya Filipos. Pegdateng din doton, mig-insà sikandin diyà te menge tinoledaan din, kagi din, “Eden lay se kagi te kedita te otaw tepad te Timanem Migpekeotaw? Sinu a lay ekon?” ");
INSERT INTO mbs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Timaba dan, “Doen menge otaw eg-ikagi te sikona si Juan Memonyagay. Doen heman eg-ikagi te sikona si Elias. Doen heman eg-ikagi te sikona si Jeremias aw doma telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mig-insà si Jesus, “Meneng eden lay se kenyo aneng-aneng tepad kanak? Sinu a lay?” ");
INSERT INTO mbs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Timaba si Simon iningedanan din ki Pedro, kagi din, “Sikona se Misiyas. Sikona se Batà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Minikagi si Jesus, “Simon, batà i Juan, doen ontò keluba nikaw. Kenà otaw se migpetaga-taga diyà kamno te siak se Batà te Timanem, meneng Amay ko doton te langit se migpetaga-taga kenyan diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eneng-enengi se kagi ko kamno seini. Iling ka te bato dimasel tandà te pegsalig no kanak, aw medita se otaw tomaking kamno aw megpesakop diyà kanak. Eked dan dàgi te tolos te kemetayun. ");
INSERT INTO mbs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Isogò ko sikona meg-owang te lelebangan amon medita se otaw megpesakop diyà te peglowan te Timanem. Aw megpunù ka te doen eked kepakay inangen dini lanto te tanà, eked heman iyan kepakay inangen doton te langit. Aw megpunù ka te doen mepakay inangen dini lanto te tanà, mepakay heman iyan inangen doton te langit.” ");
INSERT INTO mbs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Penga niyan, ontò migpunù si Jesus te keilangan eked dan indani diyà te doma otaw te sikandin se Misiyas. ");
INSERT INTO mbs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lekat niyan, mig-indan si Jesus diyà te menge tinoledaan din aw eden se metoman domateng diyà kandin. Keilangan domoton sikandin te Jerusalem, aw ipeeleg sikandin te menge obanen aw pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises. Metoman sikandin imetayan, aw penga niyan meantay lekat te nematay te iketelo aldaw. ");
INSERT INTO mbs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Penga niyan, migpedapag si Pedro diyà ki Jesus, aw sinagda din, kagi din, “Pengolo, eked peden iyan keinang te Timanem diyà kamno. Eked palos iyan ketoman.” ");
INSERT INTO mbs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Meneng miniling si Jesus, aw minikagi diyà ki Pedro, “Kesayo ka lekat kanak. Iling ka ki Satanas, so mekeanggà ka kanak. Kenà lekat te Timanem se ibeg no sìyan, meneng lekat iyan te aneng-aneng nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Penga niyan, minikagi si Jesus diyà te menge tinoledaan din, “Aw meibeg se otaw tomaking kanak, keilangan megsagda sikandin te ibeg te pedowan din, aw tomayod te kelimahan te kelikit te aldaw pengkey imetayan sikandin, aw keilangan ontò tomaking kanak. ");
INSERT INTO mbs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pengkey ibeg te otaw megkelayat se omol din dini te keneyonan, meneng kunù din gayed matay. Meneng aw mepakay diyà te otaw pengkey imetayan sikandin tandà te pegtaking din kanak, begayan sikandin te kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Simpana tig-epoen te otaw se kedakel te keneyonan, aw penga niyan matay sikandin aw ipelumun doton te kilot, wedad ontong din, so eked kebeyadi se kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Siak se Timanem Migpekeotaw, aw lomikò a dini tekingan te menge anghil aw kelangkaw te Amay ko. Aw lomikò a, begayan ko se kedita te otaw te ontong tepad te tapay dan ininang. ");
INSERT INTO mbs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eneng-enengi niyo se kagi ko kenyo seini. Doen otaw dini kenyo eked kematay singed aw onà dan komità te pegtebò te peglowan ko Timanem Migpekeotaw.” ");
INSERT INTO mbs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nayan, pegkeokit te enem se aldaw, impetaking i Jesus si Pedro, si Santiago, aw si Juan adi i Santiago, aw timikedeg dan doton te melangkaw bontod te wedad doma dan. ");
INSERT INTO mbs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pegketà, dalem te pegtengteng dan ki Jesus, netodà se bawa din, aw simenang iyan iling te aldaw. Ontò migkepotì se kedakel te penenaktun din so ontò minanyag. ");
INSERT INTO mbs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pegketà, kinità dan heman si Moises aw si Elias migpebelaw-belaway doma ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Minikagi si Pedro diyà ki Jesus, “Pengolo, mèpiya so dini kay. Aw mepakay diyà kamno, meg-inang a den te telo balay dini amon doen ogpaan te teg sebad-sebad kenyo si Moises aw si Elias.” ");
INSERT INTO mbs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Telobo pa minikagi si Pedro, doen labon melowa dimateng diyà kandan aw wedà dan ebey kità kandan. Penga niyan, dinineg dan se kagi te Timanem lekat te labon, “Seini se Batà ko. Dakel se pedowan ko kandin, aw ontò a neluba kandin. Keilangan sikandin se penenelanen niyo.” ");
INSERT INTO mbs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pegdineg dan kenyan, nekelemlem dan so ontò dan nelemitan. ");
INSERT INTO mbs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Meneng nemaed si Jesus kandan, aw minikagi, “Enaw kaw den. Ikà niyo egkelemitan.” ");
INSERT INTO mbs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Peggimata dan, kinità dan olò si Jesus wedad den doma din. ");
INSERT INTO mbs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pegtopang dan lekat te bontod, ontò migpunù si Jesus kandan, kagi din, “Ikà niyo eg-indan te kinità niyo singed aw meantay a Timanem Migpekeotaw lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Penga niyan, mig-insà se menge tinoledaan din, “Aw agpet ka den lomowan, nengà lay egtoladà se menge menenoladà te punù ingkeliwat i Moises te keilangan domateng si Elias te eked pa lowan se Misiyas?” ");
INSERT INTO mbs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Timaba si Jesus, “Benal domateng onà si Elias, so sikandin se megpeketagad te kedita. ");
INSERT INTO mbs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Meneng mikagi a den diyà kenyo te dimateng den sikandin, aw wedà sikandin kilelai te doma otaw. Meneng medaet se ininang dan diyà kandin. Iling heman kenyan se medaet inangen dan diyà kanak Timanem Migpekeotaw.” ");
INSERT INTO mbs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Penga niyan, neeneng-enengan dan te si Juan se timoman te pakang tepad te pegdateng i Elias. ");
INSERT INTO mbs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pegdateng dan doton te ongan, medita se otaw migtagad kandan. Nayan, doen otaw dimoton ki Jesus aw limongken diyà kandin, aw minikagi, ");
INSERT INTO mbs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Sir, keidowi bag se batà ko, so pigbaboy sikandin aw ontò eg-elegen. Melikit sikandin eg-elosen te bosaw diyà te apoy aw eglemesen heman diyà te wayeg. ");
INSERT INTO mbs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pengkey inibing ko sikandin dini te menge tinoledaan nikaw amon megpegolì dan kandin, meneng wedà dan iyan kebatog.” ");
INSERT INTO mbs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Minikagi si Jesus, “Tay law, sikiyo menge otaw. Ontò kolang se aneng-aneng niyo, so wedà kaw pa salig diyà kanak. Eked den kenamay se pegdoma ko kenyo, meneng keilangan tomayod a pa pengkey eked kaw pemenal. Na, pedinihi se batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Penga niyan, sinagda i Jesus se bosaw aw impelowà din iyan lekat te batà. Pegketà, negolian sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pegkenamay-namay, dimoton se menge tinoledaan i Jesus kandin te wedad doma dan, aw mig-insà dan, “Nengà lay wedà day kebatog se pegpelowà te bosaw lekat kandin?” ");
INSERT INTO mbs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Minikagi si Jesus, “Wedà niyo iyan kebatog so wedà pa kelobos se pegsalig niyo diyà kanak. Mikagi a den diyà kenyo te pengkey deitek pa se pegsalig niyo diyà kanak iling te kedeitek te benì te mostasa, mekebatog kaw mikagi diyà te bontod seini te malin iyan, aw tomolò iyan kenyo, so wedad palos eked niyo kebatog.  ");
INSERT INTO mbs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Meneng eked pelowai se seini kemolò te bosaw singed aw megtawal-tawal kaw aw megpowasa kaw.” ");
INSERT INTO mbs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nayan, pegketipon te menge tinoledaan i Jesus doton te probinsya te Galiliya, minikagi si Jesus, “Seini se metoman domateng diyà kanak Timanem Migpekeotaw. Metoman a itolok aw ibegay a diyà te belad te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Penga niyan, imetayan a dan, aw entayen a lekat te nematay te iketelo te aldaw.” Peg-ikagi din kenyan, ontò nelidò se pedowan dan. ");
INSERT INTO mbs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pegdateng dan doton te lonsod te Kapirnaom, doen menge otaw kidoen egpengabat te kwarta ipegbegay diyà te dakel simbahan te Jerusalem te kelikit te omay. Mig-insà dan diyà ki Pedro, “Egpemegay lay se pengolo niyo te kwarta diyà te dakel simbahan?” ");
INSERT INTO mbs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Timaba si Pedro, “Ee man.” Peg-olì din doton te balay, te wedà pa ikagi si Pedro, minikagi si Jesus, “Simon, doen insà ko kamno. Sinu lay se otaw keilangan memegay te kwarta diyà te selotan? Kandin pamilya, aw doma otaw?” ");
INSERT INTO mbs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Timaba si Pedro, “Olò doma otaw se keilangan memegay.” Minikagi si Jesus, “Yan eked pemegay se kandin menge batà. ");
INSERT INTO mbs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Meneng eked ki keibeg aw doen meopal kenita. Yan doton ka te lanaw aw pegtonton ka te selab. Kitaen no se kwarta selapì doton te bahà te tagnà ikan meabat nikaw. Botong iyan te keilangan ibegay ta diyà te simbahan. Ebati iyan aw begayi diyà te menge otaw egpengabat.” ");
INSERT INTO mbs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nayan, wedà kenamay, dimoton se menge tinoledaan i Jesus kandin, aw mig-insà dan, “Sinu lay se ontò melangkaw doton te peglowan te Timanem?” ");
INSERT INTO mbs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tinawal i Jesus se sebad batà, aw impetindeg din iyan kidoen te tengà-tengà dan. ");
INSERT INTO mbs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Penga niyan, minikagi si Jesus, “Eneng-enengi niyo se kagi ko seini. Eked kaw palos sekopi te Timanem diyà te peglowan din singed todaen niyo se aneng-aneng niyo, aw megpedanà kaw iling te kedanà te mengisù. ");
INSERT INTO mbs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Meneng se otaw ontò melangkaw doton te peglowan te Timanem, yan se otaw megpedanà te kandin pegkeotawun iling te kedanà te batà seini. ");
INSERT INTO mbs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aw megsagman se otaw te sakop ko iling te batà seini tandà te pegpesakop din kanak, pineokit kenyan segmanen a din heman.” ");
INSERT INTO mbs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Meneng aw doen otaw mekebaet te pegpemenal te mengisù egkeidowan ko, ontò medaet se pelumun domateng diyà kandin. Labi pa mèpiya aw iketan se lieg din te dakel bato aw idagdag doton te lawod. ");
INSERT INTO mbs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mekelelayò se kedita te otaw, so doen egpekebaet te kandan pegpemenal. Doen gayed mekebaet te pegpemenal te kedita te otaw, meneng mekelelayò se otaw eg-inang kenyan, so ontò sikandin ipelumun. ");
INSERT INTO mbs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Aw meboyo kaw meg-inang te salà pineokit te belad aw benis niyo, mèpiya aw tokongen niyo iyan aw iagbel niyo amon eked kaw peg-inang te salà, aw amon kominawà kaw te kaling pedowan wedad temanan. Labi pa medaet aw meboyo kaw pineokit te belad aw benis niyo, aw iagbel se kedakel te lawa niyo kidoen te apoy doton te kilot eked palos kepadeng. ");
INSERT INTO mbs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aw meboyo kaw heman meg-inang te salà pineokit te mata niyo, mèpiya aw logiten niyo se mata niyo aw iagbel niyo amon eked kaw peg-inang te salà, aw amon kominawà kaw te kaling pedowan wedad temanan. Labi pa medaet aw meboyo kaw pineokit te mata niyo, aw iagbel se kedakel te lawa niyo kidoen te apoy doton te kilot.” ");
INSERT INTO mbs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Keilangan eked kaw peglindò te sakop ko medanà iling te kedanà te mengisù seini, so mikagi a den diyà kenyo te egtonggoan dan te menge anghil gayed egdoma te Amay ko doton te langit.  ");
INSERT INTO mbs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dimini a Timanem Migpekeotaw amon ipelowà ko se menge otaw nelegeb te salà. ");
INSERT INTO mbs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Eneng-enengi niyo ini. Aw doen otaw doen sebad gatos ayam-ayam din karniro, aw metalon se sebad, tenanan din se kesyaman teg siyam doton te bontod, aw pemehaen din se sebad. ");
INSERT INTO mbs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mikagi a den diyà kenyo, aw kitaen din se sebad netalon, doen keluba din labi pa dakel diyà te keluba din tepad te kesyaman teg siyam wedà ketalon. ");
INSERT INTO mbs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iling heman kenyan se keluba te Amay ko doton te langit, so eked sikandin keibeg aw doen sakop din medanà mekesoway lekat kandin, pengkey sebad.” ");
INSERT INTO mbs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na, aw doen otaw egpemenal meg-inang te salà diyà kenyo, doton kaw kandin te wedad doma otaw kidoen, aw ikagi kaw diyà kandin tepad te salà ininang din. Aw megselsel sikandin, yan tinebangan niyo den sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Meneng aw eked sikandin penenalan te kagi niyo, petekingi niyo se doma otaw pengkey sebad aw dowa, aw lomikò kaw doton kandin, amon doen dowa otaw aw kenà telo meg-indan te benal se kagi niyo kandin. ");
INSERT INTO mbs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aw eked sikandin penenalan kandan, indani niyo iyan diyà te kedita te otaw egsimba kidoen. Aw eked sikandin tolò te menge obanen te simbahan, ikà niyo egdoma kandin, so iling den sikandin te menge otaw kenà egpenimanem aw nelegeb te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eneng-enengi niyo se kagi ko kenyo seini. Aw megpunù kaw te doen eked kepakay inangen dini lanto te tanà, eked heman iyan kepakay inangen doton te langit. Aw megpunù kaw te doen mepakay inangen dini lanto te tanà, mepakay heman iyan inangen doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mikagi a den heman diyà kenyo, aw doen dowa kenyo dini lanto te tanà, aw megsebad kaw te kenyo pemoyoen diyà te Amay ko doton te langit, metoman iyan meinang so ibegay din iyan diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pengkey olò dowa aw telo se otaw metipon amon megsimba kanak, kidoen a heman doma dan.” ");
INSERT INTO mbs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Penga niyan, dimoton si Pedro ki Jesus aw minikagi, “Pengolo, aw melikit gayed eg-inang se doma otaw te salà diyà kanak, mekepila lay se pegwedad ko te salà din? Botong lay aw mekepito?” ");
INSERT INTO mbs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Minikagi si Jesus, “Kenà olò mekepito, meneng keilangan gayed no pegwedaden se peg-inang din te salà, pengkey doblihen se kepitowan te mekepito. ");
INSERT INTO mbs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iling kani se peglowan te Timanem. Doen selotan mig-aneng-aneng te mèpiya aw somokot sikandin te salà te menge sakop din. ");
INSERT INTO mbs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pegtebò din, doen otaw impeangay din ontò dakel se salà din, so minelalan se kwarta binelesan din. ");
INSERT INTO mbs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","So eked sikandin pekeimpas, minikagi se selotan te keilangan inangen din allang se otaw sìyan sipat esawa din aw menge batà din. Keilangan ibeligyà dan heman te selotan sipat kedakel te kededònan dan amon meimpas se salà dan. ");
INSERT INTO mbs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Meneng limongken se otaw sìyan aw migpeido-ido, kagi din, ‘Sir, pegtagad ka bag te eked kenamay, so impasen ko se kedakel te salà ko kamno.’ ");
INSERT INTO mbs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Penga niyan, pigwedad te selotan se salà te otaw sìyan tandà te keido din kandin, aw impelowà din sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Meneng pegkesayo te otaw sìyan, kinità din se doma otaw doton te dalan doen ontò deitek salà diyà kandin. Pegketà, pineleng din se lieg te otaw sìyan aw minikagi, ‘Impasi den se salà no kanak.’ ");
INSERT INTO mbs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Penga niyan, limongken se otaw aw migpeido-ido, kagi din, ‘Pegtagad ka bag te eked kenamay, so impasen ko se kedakel te salà ko kamno.’ ");
INSERT INTO mbs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Meneng wedad keido din, aw impekeleboso din se doma otaw lamig meimpas se salà. ");
INSERT INTO mbs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nayan, pegketaga-taga te menge kedomaan din kenyan, ontò nelidò se pedowan dan. Penga niyan, dimoton dan te selotan aw mig-indan dan te kedita te neinang din. ");
INSERT INTO mbs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Penga niyan, impeangay te selotan se otaw sìyan aw minikagi, ‘Medaet ka otaw. Pegpeido-ido no diyà kanak, pigwedad ko se kedakel te salà nikaw. ");
INSERT INTO mbs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","So neidowan ta, keilangan keidowan no heman se doma otaw.’ ");
INSERT INTO mbs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ontò sikandin neopalan te selotan, aw impekeleboso din sikandin amon ipelumun lamig meimpas se kedakel te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Minikagi si Jesus, “Aw eked kaw ontò pegwedad te salà te doma otaw, iling heman kenyan se inangen te Amay ko diyà kenyo. Eked kaw din keidowi.” ");
INSERT INTO mbs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nayan, penga te pegtoladà i Jesus te kedita niyan, nesayo sikandin lekat te probinsya te Galiliya aw minokit doton dipag te wayeg te Jordan taman te probinsya te Judiya. ");
INSERT INTO mbs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Medita se otaw timaking kandin, aw pinegolian din se kedita dan doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Doen menge Parisiyo nengemahà te kemalì diyà te pegtoladà i Jesus amon doen idimanda dan tepad kandin. Dimoton dan kandin aw mig-insà dan, “Mepakay lay aw somibwan se otaw te esawa din pengkey wedad medaet ininang din?” ");
INSERT INTO mbs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Timaba si Jesus, “Wedà niyo besi besahi se kagi te Timanem insolat. Peg-inang din te otaw gebii, sebad olò se meama ininang din aw sebad olò heman se bayi. ");
INSERT INTO mbs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Minikagi heman se Timanem, ‘Yan se doun te tomanan se meama te amay aw inay din, aw megsebad diyà te esawa din. Se didowa dan meinang sebad.’ ");
INSERT INTO mbs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yan kenà dowa se teleesawa, so neinang dan sebad. Nayan, so ininang dan te Timanem sebad, eked kepakay aw ipesoway dan te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Minikagi dan, “Aw eked iyan kepakay, nengà lay migpunù si Moises gebii te keilangan doen papil ibegay te meama diyà te bayi tepad te pegsibwan din, aw penga niyan mepakay din ipekesayo?” ");
INSERT INTO mbs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Minikagi si Jesus, “Migpunù si Moises te mepakay aw somibwan kaw te esawa niyo, so netegahan din te ontò magsen se olo niyo. Meneng gebii te peg-inang te Timanem te otaw, eked kepakay se pegsibwan. ");
INSERT INTO mbs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mikagi a den diyà kenyo, aw somibwan se meama te esawa din wedà peglakad, aw todà mengognan, mekelakad sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Minikagi se menge tinoledaan din, “Aw iling kenyan se kelimahan domateng diyà te teleesawa, labi pa mèpiya aw eked pengognan se otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Meneng minikagi si Jesus, “Kenà kedita te otaw se eked palos pengognan, meneng olò se menge otaw pinemallì te Timanem te eked pengognan. ");
INSERT INTO mbs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Medita se kemolò te otaw eked palos pengognan. Doen otaw eked pegbatà so kolang lekat te pegtebaw dan. Doen heman eked pengognan so tinelinan dan. Doen heman eked pengognan amon wedad mekeanggà te pegtoladà dan tepad te peglowan te Timanem. Aw pinemallì kaw te Timanem amon eked kaw palos pengognan, keilangan tomolò kaw kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nayan, doen menge otaw nengibing te dedeitek mengisù doton ki Jesus amon pemàdan din dan aw megtawal-tawal te begayan dan te Timanem te mèpiya. Sinagda dan te menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Meneng minikagi si Jesus, “Ikà niyo egsagda kandan, so lomowan se Timanem diyà te otaw ontò somalig diyà kandin iling te pegsalig te mengisù diyà te amay aw inay dan.” ");
INSERT INTO mbs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nemaed si Jesus kandan aw migtawal-tawal. Penga niyan, nesayo sikandin lekat kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nayan, doen sebad otaw dimoton ki Jesus aw mig-insà, kagi din, “Sir, eden lay se mèpiya keilangan inangen ko amon doen kaling pedowan ko wedad temanan?” ");
INSERT INTO mbs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Minikagi si Jesus, “Nepela a so mig-insà ka diyà kanak aw eden se mèpiya inangen nikaw. Sebad olò se ontò mèpiya, olò Timanem. Aw meibeg ka kominawà te kaling pedowan wedad temanan, keilangan tomolò ka te menge punù din ingkeliwat i Moises.” ");
INSERT INTO mbs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mig-insà se otaw sìyan, “Eden lay punui se keilangan toloen ko?” Minikagi si Jesus, “Ikà egbonò. Ikà eglakad. Ikà egpenakaw. Ikà egkebolalaw tepad te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Keilangan memasa ka te amay aw inay nikaw. Kedekeli heman te pedowan no se doma otaw iling te peg-aneng-aneng no te kamno pegkeotawun.” ");
INSERT INTO mbs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Minikagi se otaw, “Gayed ko egtoloen se kedita niyan. Eden lay se wedà ko pa inangi?” ");
INSERT INTO mbs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Minikagi si Jesus, “Aw meibeg ka te ontò melobos se pedowan no diyà te Timanem, olì ka den aw beligyai se kedakel te kedònan no, aw begayi se kwarta no diyà te menge otaw nelimahan. Aw yan se inangen no, doen ontong kinewaen no doton te langit. Penga te pegpemegay no te kedakel niyan, likò ka dini aw taking ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pegdineg din kenyan, nelidò se pedowan din aw nesayo sikandin, so ontò dakel se kedònan din. ");
INSERT INTO mbs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Minikagi si Jesus diyà te menge tinoledaan din, “Eneng-enengi niyo se kagi ko kenyo. Ontò melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mikagi a den heman diyà kenyo te pengkey ontò melima se peg-okit te ayam-ayam kamilo diyà te awang te dagem, meneng labi pa melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pegdineg dan kenyan, ontò dan nepela, aw minikagi dan, “Aw iling kenyan, wedad palos otaw mekelowà lekat te pelumun te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Meneng timengteng si Jesus diyà kandan aw minikagi, “Pengkey eked pekelowà se otaw lekat te pelumun te Timanem, meneng wedad palos eked kebatog te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Penga niyan, minikagi si Pedro, “Meneng sikami, tinenanan day den se kedakel amon tomaking kay kamno. Eden lay se ontong kinewaen day?” ");
INSERT INTO mbs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Minikagi si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Aw inangen te Timanem kaling se keneyonan, menenoo a Timanem Migpekeotaw doton te melangkaw onsedanan te peglowan. Sikiyo menge tinoledaan ko, menenoo kaw heman doton te sempolò teg dowa onsedanan te peglowan, so lomowan kaw diyà te sempolò teg dowa pongan te menge bowad-bowad i Israel. ");
INSERT INTO mbs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aw timanan se otaw te kedònan din, aw kedowa din, aw amay din, aw inay din, aw batà din, aw pawà din, amon megpesakop diyà kanak, kominawà sikandin te ontong ginatos pa meelagà diyà te tinenanan din, aw begayan heman sikandin te kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Meneng medita se otaw melangkaw songkani meinang ontò medanà doton te peglowan te Timanem. Medita heman se otaw medanà songkani, meneng meinang dan kwani melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iling heman kani se peglowan te Timanem. Doen tig-apò te pawà tineneman te paras. Limapos sikandin nengemahà te menge otaw meglegani te paras din. ");
INSERT INTO mbs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Migpakang sikandin te doen kwarta ibegay din diyà kandan sebad dinaryo, so botong iyan itandan te sebad se aldaw. Penga niyan, dimoton dan te pawà din aw migterbaho dan. ");
INSERT INTO mbs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pegkealas nowibi, todà sikandin nengemahà te otaw meglegani. Doen otaw kinità din doton te pedyanan wedad terbaho dan. ");
INSERT INTO mbs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Minikagi sikandin, ‘Aw megterbaho kaw doton te pawà ko, tendanan ko sikiyo te mèpiya.’ Yan nesayo dan aw miglegani. ");
INSERT INTO mbs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Todà sikandin nengemahà te otaw te alas dosi aw alas tris te meapon, aw iling heman kenyan se kagi din kandan. ");
INSERT INTO mbs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sagwa agpet alas singko te meapon, kinità din heman se doma otaw wedad terbaho dan. Mig-insà sikandin, ‘Nengà lay wedad palos terbaho niyo te aldaw seini?’ ");
INSERT INTO mbs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Timaba dan, ‘So wedad megtandan kenami.’ Minikagi sikandin, ‘Pegterbaho kaw heman doton te pawà ko.’ ");
INSERT INTO mbs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nayan, pegkedelem niyan, minikagi se otaw diyà te otaw sineligan din, ‘Tewali se kedita te otaw migterbaho, aw begayi kandan se tandan dan. Onai se otaw kaling migterbaho, aw modihi se otaw tapay migterbaho.’ ");
INSERT INTO mbs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pegtandan din te otaw migtebò migterbaho alas singko te meapon, sebad dinaryo se kwarta imbegay din diyà te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nayan, te wedà pa tendani se menge otaw migterbaho lekat te iselem, migpeliman dan te labi pa dakel se ibegay din diyà kandan. Meneng pegtandan din kandan, sebad heman dinaryo se kwarta imbegay din diyà te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pegkinawà dan te kwarta, migbelisì dan diyà te tig-apò te paras. ");
INSERT INTO mbs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Minikagi dan, ‘Olò sebad oras se pegterbaho te otaw sida, meneng lekat te iselem se kenami pegterbaho, aw neilad kay te aldaw, meneng onawa se intandan no te kedita day.’ ");
INSERT INTO mbs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Meneng minikagi se tig-apò diyà te sebad kandan, ‘Elew, wedà a peglegawa kamno, so sebad dinaryo se kwarta impakang ko kamno. ");
INSERT INTO mbs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yan ibingi se kwarta intandan ko kamno aw olì ka den. Lekat te ibeg ko, onawa se imbegay ko diyà te kedita niyo. ");
INSERT INTO mbs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wedad besi mekesagda kanak aw meibeg a memegay te kanak kwarta diyà te otaw pemellien ko. Miningà ka besi so neido a kandan.’” ");
INSERT INTO mbs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Minikagi heman si Jesus, “Iling heman kenyan, doen otaw medanà songkani ipelangkaw doton te peglowan te Timanem. Doen heman doma otaw melangkaw songkani, meneng meinang dan medanà.” ");
INSERT INTO mbs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nayan, peg-ipanaw i Jesus pesalo doton te Jerusalem, impetaking din se sempolò teg dowa tinoledaan din, aw minikagi diyà kandan te wedad doma dimineg, ");
INSERT INTO mbs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Na, domoton kidon te Jerusalem. Penga niyan, siak Timanem Migpekeotaw se itolok, aw ibegay a diyà te belad te menge pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises. Megsebad dan mikagi te keilangan imetayan a. ");
INSERT INTO mbs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ibegay a dan heman diyà te belad te otaw kenà Judiyo. Kebebeyatan a dan, aw bedasen a dan, aw penga niyan ilansang a diyà te kros amon matay a. Penga niyan, meantay a lekat te nematay te iketelo te aldaw.” ");
INSERT INTO mbs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Penga niyan, dimoton se esawa i Sebedeo ki Jesus sipat didowa batà din si Santiago aw si Juan. Limongken sikandin diyà ki Jesus so doen pemoyoen din. ");
INSERT INTO mbs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mig-insà si Jesus, “Eden lay se ibeg no diyà kanak?” Minikagi sikandin, “Aw megtebò ka lomowan, peonsadi bag se didowa batà ko seini diyà te tangkil no, sebad lenged te kowanan, aw sebad lenged te bibang, amon segmanen dan heman doma nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Minikagi si Jesus, “Wedà niyo ketegahi aw eden se kebegat te pinemoyò niyo. Meketayod kaw lay heman te kelimahan agpet den domateng kanak?” Timaba dan, “Ee, meketayod kay heman kenyan.” ");
INSERT INTO mbs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Minikagi si Jesus, “Metoman kaw heman detengan te kelimahan domateng kanak, meneng eked a pegpakang diyà kenyo te sikiyo se meketangkil diyà kanak, so tomangkil diyà kanak se otaw pinemallì te Amay ko.” ");
INSERT INTO mbs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pegdineg te sempolò tinoledaan aw eden se inikagi dan diyà ki Jesus, neopal dan ki Santiago aw si Juan. ");
INSERT INTO mbs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Meneng tinawal dan i Jesus aw minikagi sikandin, “Netegahan niyo den aw eden se eg-inangen te menge otaw eglowan. Gayed dan egleges te menge sakop dan. Gayed heman egsogò-sogò se melangkaw otaw te menge sakop dan. ");
INSERT INTO mbs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Meneng eked kepakay aw meg-iling kaw kandan. Aw doen otaw diyà kenyo meibeg megkelangkaw, keilangan gayed menabang kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aw doen otaw diyà kenyo meibeg megkelangkaw, keilangan megpedanà sikandin te pegkeotawun din iling te kedanà te allang. ");
INSERT INTO mbs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Keilangan meg-iling sikandin kanak Timanem Migpekeotaw, so dimini a te tanà kenà amon tebangan a te otaw, meneng dimini a amon menabang a te otaw. Neketagad a den imetayan amon medita se otaw mekelowà lekat te pegkeallang dan diyà te salà.” ");
INSERT INTO mbs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nayan, pegkesayo dan lekat te Jeriko, ontò medita se otaw timaking ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Doen dowa otaw bota nenenoo doton te kilid te dalan. Pegdineg dan te si Jesus se minokit kidoen, timawal dan, “Bowad-bowad i David, keidowi kay bag.” ");
INSERT INTO mbs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Migsagda se menge doma otaw kandan, aw migpunù dan te keilangan mepenek dan. Meneng labi dan beling timawal, “Pengolo, bowad-bowad i David, keidowi kay bag.” ");
INSERT INTO mbs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pegdineg i Jesus te pegtawal dan, simagked sikandin aw timawal diyà kandan, kagi din, “Eden lay se ibeg niyo inangen ko kenyo?” ");
INSERT INTO mbs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Timaba dan, “Pengolo, ibeg day, todà kay komità.” ");
INSERT INTO mbs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Neidowan dan i Jesus, aw pinemàdan din se mata dan. Pegketà, kimità dan, aw timaking dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nayan, pegpesalo dan doton te Jerusalem, migpedapag dan kidoen te lonsod te Bitpahi doton te ongan te bontod te Olibo. Insogò i Jesus se didowa tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kagi din, “Onà kaw doton te lonsod sida peselowan tadon. Aw domateng kaw doton, ketelaan niyo se ayam-ayam iling te kodà iningedanan asno sipat nati niyan. Iniketan iyan, meneng lebadi niyo, aw ibingi niyo dini. ");
INSERT INTO mbs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aw doen otaw meg-insà te nengà lay linebad niyo iyan, ikegihi niyo te keilangan sekayan iyan te Pengolo niyo, aw yan ipeibing din iyan kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pineokit kenyan, tinoman din se kagi te telekeliwat te kagi te Timanem gebii, ");
INSERT INTO mbs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Seini se iindan no diyà te kedita te tege Sion. Na, domateng se selotan niyo, aw medanà se pegkeotawun din, so somakay te nati te asno.” ");
INSERT INTO mbs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nesayo se didowa tinoledaan din aw timolò dan te impunù din kandan. ");
INSERT INTO mbs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inibing dan se asno aw nati niyan doton ki Jesus. Menge saol dan se in-ampal dan diyà te getan te nati, aw simakay si Jesus kenyan. ");
INSERT INTO mbs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Inladlad te keditaan te otaw se saol dan doton te dalan peselowan din, aw sinagpì te doma otaw se menge pelapà te palmera aw insawol dan doton te dalan, so yan se ketanem dan aw segmanen dan se otaw meinang selotan. ");
INSERT INTO mbs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Migpegais se kedita te otaw timaking ki Jesus, pengkey nekeonà aw timetondog. Migpegais dan, “Iduyun se bowad-bowad i David. Iduyun se insogò te Pengolo tadon Timanem. Iduyun se Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pegdateng i Jesus doton te Jerusalem, nepela se kedita te otaw, so migpeinsaay dan, “Sinu lay sikandin?” ");
INSERT INTO mbs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Timaba se otaw timaking ki Jesus, “Sikandin se telekeliwat te kagi te Timanem si Jesus. Lekat sikandin te lonsod te Nasarit sakop te probinsya te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nayan, dimoton si Jesus te dakel simbahan te Timanem doton te Jerusalem, aw impekadas din se kedita te otaw egpemeligyà aw egbayad kidoen te dowangen niyan. Impelias din se lemisa te menge otaw egliwan te kwarta, aw impelias din heman se bangkò te otaw egpemeligyà te selepati ibegay diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Minikagi sikandin, “Doen kagi te Timanem impesolat din gebii, ‘Se balay te Timanem, yan se ingedanan balay te pegtawal-tawal.’ Meneng ininang niyo den ini iling te ogpeanan te megdedempasay.” ");
INSERT INTO mbs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dimoton se menge otaw bota aw kapig te dakel simbahan, aw pinegolian dan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Meneng neopal se menge pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises, so kimità dan te menge kepelahan ininang i Jesus, aw dinineg dan heman se mengisù migpetewalay kidoen te dakel simbahan, kagi dan, “Iduyun se bowad-bowad i David.” ");
INSERT INTO mbs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yan se doun te minikagi dan diyà ki Jesus, “Tay law. Aw dinineg no se kagi dan, nengà lay wedà no dan segdahi?” Timaba si Jesus, “Dinineg ko dan, meneng mepakay iyan diyà kanak. Wedà niyo besi besahi se kagi te Timanem seini, ‘Isogò te Timanem se mengisù domuyun kandin.’” ");
INSERT INTO mbs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Penga niyan, nesayo si Jesus lekat kidoen aw dimoton te lonsod te Bitanya aw minidegà kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pegkeiselem niyan, limikò si Jesus doton te Jerusalem. Te wedà pa dateng doton, binallos sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kinità din se kayo igira medapag te dalan, aw dimoton sikandin amon mahà te pongo niyan. Meneng wedad palos pongo kinità din, olò menge dawen. Minikagi sikandin diyà te kayo, “Eked den palos pongo se kayo seini.” Wedà kenamay, nelanes se kayo sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pegkità te menge tinoledaan din kenyan, nepela dan aw minikagi dan, “Nelanes den se kayo igira te wedà kenamay.” ");
INSERT INTO mbs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Minikagi si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Aw somalig kaw diyà te Timanem aw eked kaw pegdowa-dowa, meg-inang kaw te kepelahan labi pa metolos diyà te ininang ko diyà te kayo seini. Aw mikagi kaw diyà te bontod seini te meabat iyan aw mealin doton te dagat, metoman iyan meinang. ");
INSERT INTO mbs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aw megtawal-tawal kaw diyà te Timanem, aw somalig kaw diyà kandin, metoman kaw din begayan te kedita te pemoyoen niyo.” ");
INSERT INTO mbs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nayan, limikò si Jesus doton te dakel simbahan te Jerusalem aw migtoladà. Wedà kenamay, doen menge pengolo te simbahan aw menge obanen te Judiyo dimoton kandin, aw mig-insà dan, “Nengà lay eg-inang ka te kedita nini? Sinu lay se simogò kamno?” ");
INSERT INTO mbs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Minikagi si Jesus, “Doen heman insà ko kenyo. Aw meketaba kaw kani, meg-indan a diyà kenyo aw sinu se simogò kanak. ");
INSERT INTO mbs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sinu lay se simogò ki Juan amon memonyag? Timanem, aw otaw se simogò kandin?” Penga niyan, migpebelaw-belaway dan aw eden se itaba dan kandin. Minikagi dan, “Simpana tomaba kidon te Timanem se simogò ki Juan, silahen kidon din, so wedà kidon pemenal ki Juan. ");
INSERT INTO mbs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Meneng simpana tomaba kidon te olò otaw se simogò ki Juan, keopalan kidon te kedita te otaw netipon, so eg-aneng-aneng dan te ontò telekeliwat te kagi te Timanem si Juan.” ");
INSERT INTO mbs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yan se doun te minikagi dan, “Inday. Wedà day ketegahi aw sinu.” Minikagi si Jesus, “So wedà kaw taba te insà ko, eked a peg-indan diyà kenyo aw sinu se simogò kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Eneng-enengi niyo ini. Doen otaw dowa se batà din. Minikagi sikandin diyà te batà din kakay, ‘Atò, pegterbaho ka den doton te pawà te aldaw seini.’ ");
INSERT INTO mbs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Minikagi se batà din, ‘Eked a.’ Meneng wedà kenamay, netodà se aneng-aneng din aw timolò. ");
INSERT INTO mbs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Penga niyan, dimoton se otaw te batà din adi, aw onawa se inikagi din diyà kandin. Minikagi se batà din sìyan, ‘Ee, amà. Domoton a.’ Meneng penga niyan, wedà deleg. ");
INSERT INTO mbs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nayan, indani a niyo. Eden lay betai se timolò te amay din?” Timaba dan, “Kakay se timolò.” Minikagi si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Medita den se otaw nekeonà kenyo migpesakop diyà te peglowan te Timanem, pengkey nelegeb dan te salà iling te menge iskribinti aw menge kepoyun. ");
INSERT INTO mbs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pegtoladà i Juan te keilangan megselsel kaw amon eneng-enengen te Timanem te metòlid kaw, wedà kaw pemenal kandin. Meneng medita se iskribinti aw kepoyun nemenal kandin. Pengkey kimità kaw kenyan, meneng wedà kaw pegselsel aw wedà kaw heman pemenal kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Penenalan kaw den te tegdeyanan seini. Doen otaw migpawà aw nenanem te paras. Mig-inang sikandin te alad, aw tigmesanan te paras, aw layag. Penga niyan, impetonggò din iyan te menge doma otaw aw dimoton sikandin te mediyò ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pegdateng te aldaw te peglegani, doen menge sineligan insogò te tig-apò amon doen talad din. ");
INSERT INTO mbs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Meneng pegdateng te sineligan din doton, medaet se ininang te menge otaw migtonggò te pawà din. Nemadas dan te sebad sineligan din, aw nengimatay dan te doma, aw nemontog dan te bato diyà te doma. ");
INSERT INTO mbs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Penga niyan, labi pa medita se doma sineligan insogò din doton kandan. Meneng onawa heman se medaet ininang te otaw migtonggò diyà te sineligan insogò din. ");
INSERT INTO mbs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Penga niyan, insogò din se batà din, so aneng-aneng din keilangan segmanen dan se kandin batà. ");
INSERT INTO mbs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Meneng pegdateng te batà din doton, migpebelaw-belaway dan, ‘Seini se meketig-apò te tanà seini aw matay se amay din. Mèpiya aw imetayan tadon sikandin amon sikitadon se meketig-apò te tanà seini.’ ");
INSERT INTO mbs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Penga niyan, inewidan dan sikandin, aw ginoyod dan doton te lowà te pawà, aw inimetayan dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nayan, indani a niyo. Aw domoton se tig-apò te pawà, eden lay se inangen din diyà te menge otaw impetonggò din?” ");
INSERT INTO mbs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Timaba dan, “Ipeeleg din se mededaet otaw sìyan aw imetayan din se kedita dan. Penga niyan, ipetonggò din se pawà din te doma otaw keseligan, amon begayan dan sikandin te talad te kelikit te omay.” ");
INSERT INTO mbs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Minikagi si Jesus, “Iling te wedà kaw palos pegbasa te kagi te Timanem seini, ‘Doen bato in-agbel te menge otaw mig-inang te balay, so eden dan aw wedad kekemowan niyan. Meneng yan se bato ontò salig te balay. Mèpiya se ininang te Pengolo sìyan, aw yan se doun te iduyun tadon sikandin.’ ");
INSERT INTO mbs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Eneng-enengi niyo se kagi ko kenyo. Yan se doun te eked kaw sekopi te Timanem diyà te peglowan din, meneng sekopen din se menge doma otaw ontò tomolò te ibeg din.  ");
INSERT INTO mbs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aw mekedogsò se otaw kidoen te bato seini, melosek se menge tòlan din. Meneng aw kedegdagan se otaw te bato sìyan, mepolpog sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pegdineg te menge Parisiyo aw pengolo te simbahan kenyan, netegahan dan te sikandan se nesogatan te tegdeyanan din sìyan, ");
INSERT INTO mbs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","aw yan se doun te ibeg dan megdakep peden kandin. Meneng wedà dan peketoman, so nelemitan dan te menge otaw gayed egpenenalan kandin, so mig-aneng-aneng se kedita te otaw te si Jesus se telekeliwat te kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Migtoladà si Jesus te doma tegdeyanan, kagi din, ");
INSERT INTO mbs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Iling heman kani se peglowan te Timanem. Doen selotan mig-inang te dakel kànen so peipiden se batà din. ");
INSERT INTO mbs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Insogò din se sineligan mangay te kedita te otaw inindanan din. Meneng wedad ibeg dan gomemaw. ");
INSERT INTO mbs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Doen heman menge doma sineligan insogò te selotan amon megkeliwat dan te kagi din, ‘Na, integilan ko den se kànen. Iniyaw day den se menge baka aw doma ayam-ayam melambò, aw nelegà den se kedita niyan. Ayas kaw den diyà te peipid.’ ");
INSERT INTO mbs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Meneng wedà dan pegsagman kenyan. Doen otaw dimoton te pawà, aw doen doma otaw dimoton te tinda din. ");
INSERT INTO mbs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Doen heman menge doma otaw minawid te sineligan, aw pinemilang dan, aw inimetayan dan. ");
INSERT INTO mbs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Neopal se selotan, aw insogò din se menge sondalo mengimatay kandan aw menonog heman te lonsod dan. ");
INSERT INTO mbs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Penga niyan, minikagi se selotan diyà te menge sineligan din, ‘Integilan den se kànen, meneng eked ko petenodi se otaw tapay impeangay ko, so kimulu dan. ");
INSERT INTO mbs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nayan, doton kaw den te menge dalan eg-okitan te medita otaw, aw petenodi niyo se kedita te otaw ketelaan niyo.’ ");
INSERT INTO mbs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Penga niyan, dimoton dan te menge dalan, aw impetaking dan se kedita te otaw netelaan dan, pengkey mèpiya se keogpà dan aw pengkey kenà. Yan medita se otaw impetanod dan, aw nepenò den se balay. ");
INSERT INTO mbs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nayan, wedà kenamay, limowà se selotan amon tomengteng diyà te otaw timanod te peipid. Kinità din se otaw wedad saol iling te keilangan gemiten te otaw tomanod te peipid. ");
INSERT INTO mbs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Minikagi se selotan, ‘Elew, nengà lay dimini ka te wedad saol no iling te keilangan gemiten te otaw tomanod te peipid?’ Meneng wedad palos intaba din. ");
INSERT INTO mbs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Penga niyan, minikagi se selotan diyà te menge sineligan din, ‘Geposi niyo se belad din aw benis, aw ibingi niyo sikandin doton te lowà kidoen te kengitngitan amon ipelumun. Ontò megkelag se otaw doton, aw megyangget-yangget se ngipen dan tandà te kegemakan dan.’ ");
INSERT INTO mbs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pengkey ontò medita se otaw tinawal te Timanem, meneng pilabok se meinang menge sakop din.” ");
INSERT INTO mbs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Penga niyan, nesayo se menge Parisiyo, aw migpebelaw-belaway dan aw eden se inangen dan diyà ki Jesus amon doen idimanda dan tepad te pegtoladà din. ");
INSERT INTO mbs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Penga niyan, doen menge tinoledaan dan aw menge sakop i Herod insogò dan doton ki Jesus. Minikagi dan diyà kandin, “Sir, netegahan day te kenà ka egkebolalaw. Netegahan day heman te pengkey sinu se otaw toledaan no, ontò benal se ipegtoladà no diyà kandan tepad te ibeg te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nayan, doen insà day kamno. Indani kay aw eden se aneng-aneng nikaw. Lomàpang kidon lay te menge punù ingkeliwat i Moises aw mayad kidon te mihoras diyà te gobirno te Roma? Mepakay lay aw eked?” ");
INSERT INTO mbs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Meneng netegahan i Jesus te medaet se tod dan te peg-insà dan kenyan. Yan minikagi sikandin, “Eden niyo aw egpenimanem kaw. Medaet se pegtandà niyo kanak. ");
INSERT INTO mbs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pekitai niyo diyà kanak se kwarta ipegbayad niyo te mihoras.” Penga niyan, imbegay dan diyà kandin se kwarta plata. ");
INSERT INTO mbs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mig-insà si Jesus, “Sinu lay bawa se insawol kidoen? Sinu lay ngadan se insolat kidoen?” ");
INSERT INTO mbs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Timaba dan, “Selotan te Roma.” Minikagi si Jesus, “Yan begayi niyo diyà te selotan se keilangan ibegay niyo diyà kandin, aw begayi niyo heman diyà te Timanem se keilangan ibegay niyo diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pegdineg dan kenyan, nepela dan, aw nesayo dan lekat kandin. ");
INSERT INTO mbs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wedà kenamay, doen menge Sadusiyo dimoton ki Jesus. Yan se menge otaw egtoladà te eked palos keantay se otaw lekat te nematay. Mig-insà dan diyà ki Jesus, kagi dan, ");
INSERT INTO mbs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sir, doen impunù i Moises kenitadon tepad te inangen te telekedowa meama. Aw matay se meama te wedad pa batà te esawa din, keilangan mengognan se kedowa te nematay diyà te nayi din nebalo, amon doen peden batà te kedowa din nematay. ");
INSERT INTO mbs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nayan, doen ekon pito telekedowa meama. Nengognan se kakay dan, aw nematay sikandin te wedad pa batà dan. Penga niyan, nengognan se kedowa din diyà te nayi din nebalo. ");
INSERT INTO mbs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Meneng iling heman kenyan se neinang diyà te ikedowa aw iketelo lamig te ikepito, so migpetibos-tibosay se pito telekedowa nengognan te bayi sìyan, aw nematay se kedita dan te wedad pa palos batà dan. ");
INSERT INTO mbs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Penga niyan, nematay heman se bayi. ");
INSERT INTO mbs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nayan, indani kay. Aw meantay se otaw lekat te nematay, sinu lay lebò diyà kandan se ontò esawa te bayi sìyan? So migpetibos-tibosay dan se pito nengognan kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Minikagi si Jesus, “Ontò kaw migkemalì, so wedà niyo pa kelebeti se kagi te Timanem insolat, aw wedà niyo heman ketegahi aw eden se mebatog inangen te Timanem pineokit te tolos din. ");
INSERT INTO mbs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aw entayen te Timanem se otaw lekat te nematay, eked dan palos pengognan, so iling dan te menge anghil eg-ogpà doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wedà kaw ketaga-taga te metoman meantay se otaw lekat te nematay so wedà kaw besi pegbasa te kagi te Timanem seini, ");
INSERT INTO mbs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Siak se Timanem gayed egseligan i Abraham, aw si Isaac, aw si Jacob.’ Kenà otaw wedad pedowan se egsalig te Timanem, meneng otaw doen pedowan se egsalig kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ontò nepela se kedita te otaw dimineg te pegtoladà din. ");
INSERT INTO mbs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pegdineg te menge Parisiyo te dinaeg i Jesus se menge Sadusiyo, netipon dan aw dimoton dan heman ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Doen Parisiyo biyasa egtoladà te menge punù ingkeliwat i Moises. Ibeg din megtandà ki Jesus, aw yan se doun te mig-insà sikandin, ");
INSERT INTO mbs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","kagi din, “Sir, diyà te kedita te punù ingkeliwat i Moises, eden lay punui se ontò melangkaw?” ");
INSERT INTO mbs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Minikagi si Jesus, “Kedekeli niyo te pedowan se Pengolo niyo Timanem te ontò melobos se pedowan niyo kandin, aw aneng-aneng niyo. ");
INSERT INTO mbs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yan se punù ontò melangkaw diyà te kedita. ");
INSERT INTO mbs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Seini se punù neketondog kenyan. Kedekeli niyo te pedowan se doma otaw iling te peg-aneng-aneng niyo te kenyo pegkeotawun. ");
INSERT INTO mbs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aw egtoloen niyo se dowa punù sìyan, netolò niyo heman se kedita te punù ingkeliwat i Moises aw menge telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te wedà pa kesayo se menge Parisiyo, mig-insà si Jesus diyà kandan, ");
INSERT INTO mbs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","kagi din, “Eden lay se aneng-aneng niyo tepad te Misiyas? Sinu lay se kemonaan din?” Timaba dan, “Bowad-bowad i David se Misiyas isogò te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Minikagi si Jesus, “Aw benal iyan, nengà lay minikagi si David te Pengolo din se Misiyas? Pineokit te pegbayà-bayà te Espiritu Santo ki David, insolat din se kagi seini, ");
INSERT INTO mbs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Minikagi se Timanem diyà te Pengolo ko, Penenoo ka dini te tangkil ko lamig dàgen ko se menge poon no aw ipetolò ko dan kamno.’ ");
INSERT INTO mbs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, aw minikagi si David te Pengolo din se Misiyas, nengà lay bowad-bowad i David se Pengolo din?” ");
INSERT INTO mbs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Meneng wedad palos otaw neketaba kandin. Lekat te aldaw sìyan, wedad palos otaw migtelaman mig-insà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Penga niyan, migtoladà si Jesus te kedita te otaw netipon aw menge tinoledaan din. Minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Se menge menenoladà te punù aw menge Parisiyo, yan se otaw sineligan te menge punù ingkeliwat i Moises. ");
INSERT INTO mbs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yan se doun te keilangan gayed kaw tomolò te kedita te ipegtoladà dan. Meneng ikà niyo eg-iling te eg-inangen dan, so kenà dan egtolò te punù ipegtoladà dan. ");
INSERT INTO mbs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gayed dan egdogangan se punù ontò melima toloen te otaw. Meneng kenà dan egtelaban te otaw meibeg tomolò kenyan. Iling dan te otaw megleges te doma otaw memaba te pelaban mebegat, aw wedad palos tabang dan kandan amon meinang iyan meagka. ");
INSERT INTO mbs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gayed dan ipekità diyà te doma otaw se pegtolò dan te menge punù amon iduyun dan. Eg-inangen dan pelaban dakel se solanan te kagi te Timanem egpengibingen dan, aw egpelasan dan se saol dan melayat amon meg-aneng-aneng se doma otaw te ontò melobos se pedowan dan diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aw doen dakel kànen, ibeg dan sikandan se monà ipekaen. Ibeg dan heman menenoo doton te mèpiya onsedanan kidoen te simbahan te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ibeg dan segmanen dan te doma otaw doton te pedyanan, aw ibeg dan tewalen Meistro. ");
INSERT INTO mbs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Meneng eked kepakay aw tewalen kaw Meistro te doma otaw, so telekedowa se kedita niyo aw sebad ko se meistro egtoladà kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Eked heman kepakay aw gulalen niyo Amay se doma otaw dini te keneyonan, so sebad olò se Amay niyo Timanem doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eked heman kepakay aw gulalen kaw Amo, so sebad ko se amo niyo, sìyan Misiyas insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Se otaw ontò melangkaw diyà kenyo, yan se keilangan menabang kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aw megpelangkaw-langkaw se otaw, meinang sikandin medanà. Meneng aw megpedanà se otaw te kandin pegkeotawun, meinang sikandin melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw, so egbelebagan niyo se menge otaw egkeibeg megpesakop diyà te peglowan te Timanem. Medaet so wedà kaw pegpesakop diyà kandin, meneng labi pa medaet so wedà niyo pesekopi se otaw egkeibeg megpesakop diyà kandin.  ");
INSERT INTO mbs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw, so eg-agaw kaw te kedònan te bayi balo, aw penga niyan menamay se pegtawal-tawal niyo amon megpelingo-lingo kaw te melobos se pedowan niyo diyà te Timanem. Yan se doun te metoman kaw ontò ipelumun labi pa diyà te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw, so ontò kaw measeb meglegeb te mediyò amon megsakop te pengkey olò sebad se otaw, aw pineokit te pegtoladà niyo kandin, meinang sikandin labi pa medaet diyà kenyo, aw ipedeleg niyo sikandin doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mekelelayò kaw, so iling kaw te otaw bota megtelaman mengibing te doma otaw. Egtoladà kaw te mepakay aw tomalis se otaw te pakang din aw olò megsapà te dakel simbahan dini te Jerusalem. Meneng egtoladà kaw te keilangan tomanen te otaw se pakang din aw megsapà te bolawan impalas te dakel simbahan. ");
INSERT INTO mbs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Iling kaw te otaw bota so eked niyo kitai se kebenalan. Wedad inenengen niyo, so pengkey melangkaw se bolawan impalas te dakel simbahan, meneng labi pa melangkaw se simbahan diyà te bolawan. ");
INSERT INTO mbs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Egtoladà kaw heman te mepakay aw tomalis se otaw te pakang din aw olò megsapà te sonoganan te ayam-ayam ibegay diyà te Timanem. Meneng egtoladà kaw te keilangan tomanen te otaw se pakang din aw megsapà te ayam-ayam sonogen kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iling kaw te otaw bota, so eked niyo kitai se kebenalan. Pengkey melangkaw se ayam-ayam sonogen, meneng labi pa melangkaw se sonoganan diyà te ayam-ayam sonogen kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yan aw megsapà se otaw te sonoganan, megsapà heman sikandin te ayam-ayam sonogen kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aw megsapà se otaw te dakel simbahan, megsapà heman sikandin te Timanem eg-ogpà doton te simbahan. ");
INSERT INTO mbs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aw megsapà se otaw te langit, megsapà heman sikandin te Timanem aw onsedanan din. ");
INSERT INTO mbs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw, so pengkey egpemegay kaw diyà te Timanem te ikesempolò ketengà te kedita te geniyen niyo pengkey menge enagay, meneng wedà niyo beling toloi se menge punù te Timanem labi pa melangkaw kenyan tepad te metòlid inang diyà te doma otaw, aw keido, aw pegsalig te doma otaw. Yan se keilangan inangen niyo, meneng pedeleg kaw heman te pegpemegay niyo diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iling kaw te otaw bota meg-agak peden te doma otaw. Egpengabat kaw te langaw lekat te wayeg inemen niyo, meneng eg-emehen niyo biling se dakel ayam-ayam kamilo. ");
INSERT INTO mbs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw, so gayed kaw eg-ingà aw eglalang te medaet. Iling kaw te otaw olò eg-onaw te lowà te baso aw sablag pengkey melipà pa se didalem niyan. ");
INSERT INTO mbs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikiyo menge Parisiyo, iling kaw te otaw bota, so eked niyo kitai se kebenalan. Keilangan onà kaw megligaw te didalem te baso aw sablag amon melinis se kedakel niyan. ");
INSERT INTO mbs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw. Iling kaw te lebeng pinintorahan te mepotì. Pengkey mèpiya se bawa niyan, meneng doton didalem se tòlan te otaw nematay aw nemahò. ");
INSERT INTO mbs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iling kaw kenyan, so pengkey aneng-aneng te doma otaw metòlid se eg-inangen niyo, meneng nelegeb se pedowan niyo te kebolalaw aw kededàtan.” ");
INSERT INTO mbs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mekelelayò kaw menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Eden niyo aw egpenimanem kaw. Eg-inangen niyo se balay doton te kedita te lebeng te telekeliwat te kagi te Timanem aw doma otaw eg-inang te metòlid gebii, aw egpelasan niyo se lebeng dan. ");
INSERT INTO mbs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eg-ikagi kaw te simpana migdoma kaw kandan gebii, eked kaw akop diyà te pegpengimatay te menge kemonaan niyo te telekeliwat te kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pineokit te kagi niyo, ipetaga-taga niyo te medaet heman se pedowan niyo, so sikiyo se bowad-bowad te otaw nengimatay kandan. ");
INSERT INTO mbs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yan keilangan meg-iling kaw den te menge kemonaan niyo amon sikopen niyo se medaet wedà dan kesikop. ");
INSERT INTO mbs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iling kaw te memokan so biyasa kaw eg-inang te medaet. Eked kaw palos pekelowà lekat te pelumun te Timanem, so metoman kaw din ipeibing doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Isogò ko doton kenyo se menge telekeliwat te kagi te Timanem, aw otaw biyasa te kagi ko, aw otaw megtoladà kenyo. Meneng doen diyà kandan imetayan niyo, aw doen heman ilansang niyo diyà te kros. Doen heman bedasen niyo doton te menge simbahan niyo, aw memilang kaw kandan pengkey kenan dan pesalo. ");
INSERT INTO mbs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yan se metoman niyo inangen amon ipelumun te Timanem se kedita niyo tandà te pegpengimatay te kemonaan niyo te menge otaw eg-inang te metòlid, lekat te peg-imatay dan ki Abel, pengkey wedà peg-inang te salà, taman te peg-imatay dan ki Zacarias batà i Barakia kidoen te dowangen te dakel simbahan medapag te sonoganan te ayam-ayam ibegay diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eneng-enengi niyo se kagi ko kenyo seini. Metoman ipelumun te Timanem se kedita niyo songkani tandà te pegpengimatay kandan.” ");
INSERT INTO mbs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mekelelayò kaw tege Jerusalem. Gayed niyo eg-imetayan se kedita te telekeliwat te kagi te Timanem, aw egbontogan niyo te bato se kedita te otaw insogò te Timanem dini kenyo amon matay dan. Melikit a peden megtipon kenyo amon meg-ipat a kenyo, iling te omagak lomemlem diyà te menge onsoy din. Meneng wedà kaw keibeg. ");
INSERT INTO mbs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, pinebeyaan den se ogpeanan niyo. ");
INSERT INTO mbs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Penenalan kaw kanak. Aw mesayo a, eked kaw kità kanak singed aw mikagi kaw, ‘Iduyun se insogò te Pengolo tadon Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nayan, limowà si Jesus lekat te dakel simbahan te Jerusalem. Pegkesayo din, migpedapag se menge tinoledaan din aw impekità dan diyà kandin se menge balay te simbahan, so mèpiya se bawa niyan. ");
INSERT INTO mbs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Meneng minikagi si Jesus, “Pengkey induyun niyo se simbahan seini, meneng mikagi a kenyo te tigkan iyan kebàtan te modi aldaw, aw wedad palos bato ketenanan diyà te lanto te doma bato.” ");
INSERT INTO mbs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wedà kenamay, dimoton si Jesus te bontod te Olibo aw nenenoo kidoen. Dimoton se menge tinoledaan din kandin te wedad doma dan, aw mig-insà dan, kagi dan, “Indani kay. Kano lay ketoman se in-indan nikaw? Eden lay se pengilala kitaen day amon ketegahan day te agpet ka lomikò aw agpet heman se temanan te keneyonan?” ");
INSERT INTO mbs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Minikagi si Jesus, “Peg-ahà kaw amon eked kaw keekali. ");
INSERT INTO mbs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Doen kwani medita otaw megpelingo-lingo te insogò dan te Timanem. Mikagi dan te sikandan se Misiyas, aw medita se otaw keekalan dan aw tomaking kandan. ");
INSERT INTO mbs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aw domineg kaw te doen gira medapag kenyo aw mediyò heman, ikà niyo egkelemitan. Keilangan iyan meinang, meneng kenà pa niyan se temanan te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Medita se otaw meggira, so doen pongan megbolaw diyà te doma pongan, aw doen heman menge sakop te sebad selotan megbolaw diyà te menge sakop te doma selotan. Megelà se otaw te medita ogpeanan tandà te bayil aw linog domateng diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pengkey medaet iyan, meneng yan olò se keteboan te kelimahan domateng dini te keneyonan, iling te keteboan te mesakit domateng te bayi agpet tebawan. ");
INSERT INTO mbs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Yan kebensihan kaw te keditaan te otaw tandà te pegpesakop niyo diyà kanak, aw dekepen kaw dan amon ipeeleg kaw aw imetayan kaw dan. ");
INSERT INTO mbs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aw metoman iyan, medita se otaw lomengà te pegsalig dan kanak. Megpetolokay dan, aw megpeopalay dan. ");
INSERT INTO mbs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Medita heman se otaw megpelingo-lingo telekeliwat te kagi te Timanem, aw medita se keekalan dan aw tomaking kandan. ");
INSERT INTO mbs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ontò medaet se inangen te otaw, aw yan se doun te megpedeitekay se keditaan te otaw te pedowan. ");
INSERT INTO mbs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Meneng aw tomayod se otaw te kedita te kelimahan, ipelowà sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Onà itoladà se Mèpiya Indan tepad te peglowan te Timanem doton te kebelad te keneyonan, amon domineg se kedita te otaw. Penga niyan, domateng se temanan te keneyonan.” ");
INSERT INTO mbs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, minikagi se telekeliwat te kagi te Timanem gebii si Daniel te doen domateng meg-inang te medaet doton te dakel simbahan te Jerusalem aw ontò mekelamit te otaw. (Keilangan kelebetan iyan te kedita te otaw megbasa te kagi din sìyan insolat.) Aw kitaen niyo iyan doton te dakel simbahan, ");
INSERT INTO mbs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","keilangan komadas se kedita te otaw lekat te Judiya pesalo doton te bontod. ");
INSERT INTO mbs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keilangan eked awop diyà te balay din se otaw doton te lowà amon ebaten din se kedònan, meneng keilangan tenanan din se kedita. ");
INSERT INTO mbs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Se otaw egterbaho doton te pawà, eked heman olì amon ebaten din se ekasan, meneng keilangan komadas. ");
INSERT INTO mbs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mekelelayò heman se menge bayi mebedes aw egsosowan te aldaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pegtawal-tawal kaw diyà te Timanem te kenà pengodan aw kenà aldaw te peg-etod se pegkadas niyo. ");
INSERT INTO mbs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ontò medaet se kelimahan domateng diyà te keneyonan. Wedad palos kelimahan labi pa medaet diyà kenyan lekat te keteboan te keneyonan lamig seini, aw wedad palos heman kelimahan domateng labi pa medaet diyà kenyan. ");
INSERT INTO mbs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Meneng pekebebaen te Timanem se kenamay te aldaw te kelimahan sìyan amon eked kegelà se kedita te otaw. Pekebebaen din iyan tandà te menge otaw pinemallì din. ");
INSERT INTO mbs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Aw domateng se aldaw sìyan, aw doen otaw mikagi, ‘Na, dini den se Misiyas,’ aw doen otaw mikagi, ‘Doton se Misiyas,’ ikà niyo egpemenal kandan. ");
INSERT INTO mbs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Doen menge otaw domateng megpelingo-lingo te sikandan se Misiyas aw menge telekeliwat te kagi te Timanem. Meg-inang dan heman te menge kepelahan amon keekalan dan peden heman se menge otaw pinemallì te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yan peg-ahà kaw, so mig-indan a den kenyan diyà kenyo te eked pa dateng. ");
INSERT INTO mbs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aw doen otaw mikagi diyà kenyo, ‘Na, doton den se Misiyas te kebigtilan,’ ikà niyo egdoton. Aw doen doma otaw mikagi, ‘Na, mineles den sikandin doton didalem te balay,’ ikà niyo egpemenal kenyan, ");
INSERT INTO mbs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","so ontò metaen se peglikò ko iling te kilem ontò somiblat doton te kebelad te langit, aw kitaen te kedita te otaw. Iling kenyan se pegdateng ko Timanem Migpekeotaw. ");
INSERT INTO mbs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Pengkey kenan se lawa te nematay, yan se ketiponan te menge manok egpengaen te lawa te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aw mepenga se kelimahan sìyan, megkengitngit se keneyonan so eked ebey senang se aldaw aw bolan. Medagdag heman se menge bitoen lekat te langit, so mebilit se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Penga niyan, ipekità ko se pengilala doton te langit te agpet a den lomikò Timanem Migpekeotaw. Megkelag se kedita te otaw te keneyonan tandà te lamit dan, so komità dan te pegdateng ko aw lomikò a Timanem Migpekeotaw tekingan te labon lekat te langit. Komità dan te metolos a aw ontò a melangkaw. ");
INSERT INTO mbs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ipeedop ko se bodyong, aw isogò ko se menge anghil, aw tiponen dan se kedita te otaw pinemallì ko lekat te kebelad te keneyonan, pengkey kenan dan peg-ogpà.” ");
INSERT INTO mbs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Penenalan kaw den te tegdeyanan seini tepad te kayo igira. Aw tomobed iyan aw domawen, ketegahan niyo te agpet den domateng se pengaldaw. ");
INSERT INTO mbs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iling heman kenyan, aw kitaen niyo se pegketoman te kedita niyan inikagi ko diyà kenyo, ketegahan niyo te agpet a den lomikò. ");
INSERT INTO mbs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eneng-enengi niyo se kagi ko kenyo seini. Doen menge otaw komità te pengilala sìyan, eked dan kematay singed aw metoman se kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Doen temanan te langit aw tanà, meneng gayed metoman se kagi ko te wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Meneng eked ko indani aw eden eldawi aw orasi se peglikò ko. Wedad palos netaga-taga aw kano a likò, pengkey menge anghil doton te langit, so olò Amay ko se netaga-taga kenyan. ");
INSERT INTO mbs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aw lomikò a Timanem Migpekeotaw, medita se otaw eked peketagad te pegdateng ko, iling te otaw gebii wedà penenalan ki Noe. ");
INSERT INTO mbs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Te wedà pa kelinep se tanà te wayeg, gayed dan egpengaen, aw eg-inem dan, aw egpepengognanay dan, lamig te aldaw te pegsakay i Noe aw pamilya din diyà te arka. ");
INSERT INTO mbs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Meneng wedà ketaga-taga se menge doma otaw te agpet dan megelà lamig nesàban dan te pegkelinep te tanà te wayeg, aw nelemes se kedita dan. Iling heman kenyan se peglikò ko Timanem Migpekeotaw, so medita heman se otaw eked peketagad te pegdateng ko. ");
INSERT INTO mbs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aw domateng se aldaw sìyan, pengkey megterbaho se dowa otaw doton te pawà, meneng ipetaking se sebad, aw tenanan se sebad. ");
INSERT INTO mbs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pengkey meglegiling se dowa bayi, meneng ipetaking se sebad, aw tenanan se sebad. ");
INSERT INTO mbs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yan se doun te keilangan gayed kaw megpeketagad, so wedà niyo ketegahi aw eden eldawi se peglikò ko Pengolo niyo. ");
INSERT INTO mbs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Meneng eneng-enengi niyo ini. Aw ketegahan te tig-apò te balay aw kano dateng se menenakaw, yan meketagad sikandin, aw eked ketekawi se balay din. ");
INSERT INTO mbs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Keilangan gayed kaw heman megpeketagad, so domateng a Timanem Migpekeotaw te eked niyo ketegahi aw kano.” ");
INSERT INTO mbs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Se otaw egkeseligan aw biyasa eg-inang te kedita, yan se inangen te amo din egpengibing te kedita te doma otaw doton te balay din, amon memegay diyà kandan te kànen te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aw domateng se pengolo din, ontò meluba se sineligan gayed egtolò te impunù te amo din. ");
INSERT INTO mbs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eneng-enengi niyo se kagi ko kenyo seini. Aw yan se inangen din, meinang sikandin egpengibing te kedita doton te balay te amo din. ");
INSERT INTO mbs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Meneng aw meg-aneng-aneng se medaet sineligan te menamay pa se pegdateng te amo din, ");
INSERT INTO mbs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aw egbedasen din se doma sineligan, aw gayed sikandin egpengaen aw eg-inem aw egkelasing sipat menge doma otaw metilasing, medaet iyan, ");
INSERT INTO mbs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","so domateng se amo din te aldaw wedà din pelimani. ");
INSERT INTO mbs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Metoman sikandin ipelumun te amo din, so ipelumun sikandin iling te menge otaw eden dan aw egpenimanem dan. Ontò megkelag se otaw doton, aw megyangget-yangget se ngipen dan tandà te kegemakan dan.” ");
INSERT INTO mbs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Iling heman kani se keteboan te peglowan te Timanem. Doen sempolò laga simongon te meama peipiden. Doen solò inibing te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima se laga doen mèpiya aneng-aneng, aw lima se laga kolang se aneng-aneng dan. ");
INSERT INTO mbs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Doen solò inibing te lima laga kolang se aneng-aneng dan, meneng wedad pitrolyo inibing dan amon iawop dan diyà te solò dan aw meamin se awop niyan. ");
INSERT INTO mbs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Meneng nengibing se lima laga doen mèpiya aneng-aneng te solò dan aw pitrolyo todà dan iawop. ");
INSERT INTO mbs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pegtagad dan te pegdateng te meama peipiden, nepilot se kedita dan aw timedogi dan, so nenamay wedà dateng se tinegadan dan. ");
INSERT INTO mbs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pegketengà te delem, dinineg dan se otaw minikagi, ‘Na, dimateng den se peipiden. Ayas kaw den songon kandin.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yan neloka se kedita te laga aw migtodà dan te mitsa te solò dan. ");
INSERT INTO mbs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Minikagi se lima laga kolang se aneng-aneng dan diyà te lima laga doen mèpiya aneng-aneng, ‘Begayi kay bag te pitrolyo, so agpet den mepadeng se solò day.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Meneng minikagi se lima laga doen mèpiya aneng-aneng, ‘Eked kay pemegay, so eked kidon keteped te pitrolyo inibing day. Mèpiya aw domoton kaw te tinda amon mayad kaw.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yan dimoton dan te tinda amon mayad dan. Penga te pegkesayo dan, dimateng se otaw peipiden. Timaking heman se kedita te neketagad, aw dimoton dan te peipid. Penga te peg-awop dan kidoen te balay, tinakep se lelebangan niyan. ");
INSERT INTO mbs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pegkenamay-namay, dimateng se lima laga lekat te tinda. Timawal dan doton te lowà te balay, kagi dan, ‘Sir, owangi bag se tetakep.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Meneng minikagi sikandin, ‘Wedà ko sikiyo kilelai.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Yan se doun te keilangan gayed kaw megpeketagad, so wedà niyo ketegahi aw eden eldawi aw orasi se peglikò ko.” ");
INSERT INTO mbs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Iling heman kani se peglowan te Timanem. Doen otaw dimoton te mediyò ogpeanan. Meneng te wedà pa kesayo, tinawal din se kedita te sineligan din aw imbegay din diyà kandan se kwarta insalig kandan. ");
INSERT INTO mbs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Doen kwarta imbegay din diyà te teg sebad-sebad kandan tepad te kebiyasa dan. Lima melalan se imbegay din diyà te sebad otaw, aw dowa melalan se imbegay din diyà te doma otaw, aw sebad melalan se imbegay din diyà te doma otaw. Penga niyan, nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nayan, se otaw binegayan din te lima melalan, mignigosyo sikandin aw doen gamad din lima melalan. ");
INSERT INTO mbs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iling heman kenyan se ininang te otaw binegayan din te dowa melalan, so doen gamad din dowa melalan. ");
INSERT INTO mbs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Meneng se otaw binegayan din te sebad melalan, nemangbang sikandin kidoen te tanà aw inlebeng din se kwarta imbegay diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nayan, pegkenamay, minolì se amo dan, aw tinawal din se sineligan binegayan din te kwarta amon ketegahan din aw doen gamad dan. ");
INSERT INTO mbs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pegdateng te sineligan binegayan din te lima melalan, inibing din iyan sipat gamad din lima melalan, aw minikagi sikandin, ‘Sir, lima melalan se imbegay no diyà kanak, aw doen den heman gamad ko lima melalan.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Minikagi se amo din, ‘Mèpiya se ininang nikaw. So keseligan ka, labi pa dakel se ibegay ko diyà kamno. Ibeg ko meluba ka heman onawa te kanak pegkeluba.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Penga niyan, dimateng se sineligan binegayan din te dowa melalan, aw minikagi sikandin, ‘Sir, dowa melalan se imbegay no diyà kanak, aw doen den heman gamad ko dowa melalan.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Minikagi se amo din, ‘Mèpiya se ininang nikaw. So keseligan ka, labi pa dakel se ibegay ko diyà kamno. Ibeg ko meluba ka heman onawa te kanak pegkeluba.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Penga niyan, dimateng heman se sineligan binegayan din te sebad melalan, aw minikagi sikandin, ‘Sir, netegahan ko te mebolot ka otaw, so eglegeniyen no se intanem te doma otaw, aw gayed no ipegsawol diyà te pol nikaw se omay trigo impepalid te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yan wedà a pegnigosyo te kwarta nikaw, meneng inlebeng ko iyan kidoen te tanà, so nelemitan a kamno. Iolì ko den diyà kamno se sebad melalan imbegay no diyà kanak.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Minikagi se amo din, ‘Tekahen ka aw ontò medaet se ininang nikaw. Minikagi ka den te eglegeniyen ko se intanem te doma otaw, aw ipegsawol ko diyà te pol ko se omay trigo impepalid te doma otaw. Aw netegahan no iyan, ");
INSERT INTO mbs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","keilangan ipebeles no peden se kwarta ko diyà te doma otaw amon iolì iyan diyà kanak te peg-olì ko sipat batà niyan.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Penga niyan, minikagi sikandin diyà te menge doma sineligan, ‘Na, ebati niyo se sebad melalan imbegay ko diyà kandin, aw begayi niyo diyà te otaw doen sempolò melalan. ");
INSERT INTO mbs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Se otaw egkeseligan, yan se begayan ko te labi pa dakel diyà te keilangan din. Meneng se otaw kenà egkeseligan, yan se ebatan ko te imbegay ko diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, se medaet otaw seini, ibingi niyo sikandin kidoen te lowà doton te kengitngitan amon ipelumun. Ontò megkelag se otaw kidoen, aw megyangget-yangget se ngipen dan tandà te kegemakan dan.’” ");
INSERT INTO mbs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aw lomikò a Timanem Migpekeotaw amon lomowan a, tekingan a te kedita te anghil. Penga niyan, menenoo a kidoen te melangkaw onsedanan te peglowan amon meg-okom a te kedita te otaw ");
INSERT INTO mbs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tiponen ko lekat te kebelad te keneyonan. Tepiden ko dan diyà te dowa pongan iling te eg-inangen te telediyaga te karniro aw tepiden din se menge karniro aw kambing, ");
INSERT INTO mbs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","so egtiponen din se karniro lenged te kowanan din aw egtiponen din heman se kambing lenged te bibang din. Iling heman kenyan se inangen ko te peg-okom ko, ");
INSERT INTO mbs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","so mikagi a diyà te menge otaw lenged te kowanan ko, ‘Taking kaw den kanak, so pinemallì kaw te Amay ko Timanem amon meluba kaw. Metoman den iyan so megtebò a den lomowan diyà kenyo iling te peglalang te Amay ko te wedà pa inangi se keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pegkeballos ko, impekaen a niyo. Pegkelao ko, impeinem a niyo. Pengkey wedà a niyo kilelai te pegdateng ko doton kenyo, meneng impeogpà a niyo doton te balay niyo. ");
INSERT INTO mbs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Pegkewedad te penenaktun ko, doen imbegay niyo kanak. Pegkesakit ko, mig-ipat kaw kanak. Pegkekeleboso ko, linaoy a niyo.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Penga niyan, meg-insà se otaw lenged te kowanan ko eg-inang te metòlid, kagi dan, ‘Sir, kano ka lay bellosi, penga niyan impekaen ka day? Kano ka lay kelao, penga niyan impeinem ka day? ");
INSERT INTO mbs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kano ka lay dini wedà ka day kilelai, penga niyan impeogpà ka day doton te balay? Kano lay pegkewedad se penenaktun no, penga niyan binegayan ka day? ");
INSERT INTO mbs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kano ka lay kesekiti aw kekeleboso, penga niyan mig-ipat kay kamno?’ ");
INSERT INTO mbs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tomaba a, ‘Eneng-enengi niyo se kagi ko seini. Pineokit te peg-inang niyo kenyan diyà te ontò medanà otaw egtaking kanak, ininang niyo iyan diyà kanak.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Penga niyan, mikagi a heman diyà te menge otaw lenged te bibang ko, ‘Ontò kaw ipelumun. Kesayo kaw den lekat kanak. Doton kaw den te kilot doen apoy eked palos kepadeng, so yan se integilan te Timanem amon doen egbelan din ki Satanas aw kedita te anghil din. ");
INSERT INTO mbs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pegkeballos ko, wedà a niyo pekàni. Pegkelao ko, wedà a niyo peinemi. ");
INSERT INTO mbs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pegdateng ko doton kenyo, wedà a niyo peogpai doton te balay niyo. Pegkewedad te penenaktun ko, wedà a niyo begayi. Pegkesakit ko aw pegkekeleboso ko, wedà a niyo leoyi.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Meg-insà dan heman, ‘Sir, kano kay lay kità te binallos ka, aw nelao ka, aw wedad ogpeanan no, aw wedad penenaktun no, aw nesekitan ka, aw kineleboso ka, penga niyan wedà kay pegtabang kamno?’ ");
INSERT INTO mbs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tomaba a, ‘Eneng-enengi niyo se kagi ko seini. Pineokit te wedà kaw pegtabang te ontò medanà otaw egtaking kanak, wedà a niyo tebangi.’ ");
INSERT INTO mbs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Penga niyan, ipedeleg dan doton te pelumun wedad temanan. Meneng se otaw eg-inang te metòlid, begayan dan te kaling pedowan wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Penga te pegtoladà i Jesus te kedita niyan, minikagi sikandin diyà te menge tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Netegahan niyo den besi te dowa mendad se aldaw te pegdateng te Pista te Pegpelowà, aw metoman a ibegay diyà te belad te otaw meglansang kanak Timanem Migpekeotaw diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dalem niyan, netipon se menge pengolo te simbahan aw menge obanen te Judiyo doton te balay te ontò pengolo dan si Caifas. ");
INSERT INTO mbs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Miglalang dan te dekepen dan si Jesus te wedad doma otaw metaga-taga amon imetayan dan. ");
INSERT INTO mbs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Minikagi dan, “Keilangan eked kidon pegdakep kandin dalem te pista, amon eked pegsamok se kedita te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nayan, pegdoton i Jesus te lonsod te Bitanya, limaoy sikandin ki Simon, sìyan otaw pinegolian din te tompig. ");
INSERT INTO mbs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dalem te pegpengaen dan, doen bayi nengibing te lana metinadeg ontò meelagà insawol diyà te deitek botilya mèpiya se bawa. Migpedapag se bayi diyà ki Jesus aw nenoyong te lana diyà te olo din. ");
INSERT INTO mbs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na, pegkità te menge tinoledaan i Jesus te ininang te bayi, neopal dan, aw minikagi dan, “Tay law. Pigbàtan din se lana sìyan. ");
INSERT INTO mbs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aw ibeligyà iyan, doen ontò dakel kwarta iteped diyà te menge otaw sagkep.” ");
INSERT INTO mbs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Meneng netaga-taga si Jesus te ingkeopal dan, aw minikagi sikandin, “Ikà niyo egsila te bayi sìyan, so mèpiya se ininang din diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gayed doen otaw sagkep mebatog niyo tebangan. Meneng eked a gayed peg-ogpà dini kenyo. ");
INSERT INTO mbs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pineokit te pegtoyong din te lana diyà kanak, impetagad a din te peglebeng kanak. ");
INSERT INTO mbs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eneng-enengi niyo se kagi ko seini. Eked palos sikandin kelibeli, so pengkey kenan toledai se Mèpiya Indan doton te kebelad te keneyonan, iindan heman se ininang te bayi sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nayan, doen tinoledaan i Jesus ngadan din si Judas Iscariote. Dimoton sikandin te menge pengolo te simbahan ");
INSERT INTO mbs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aw minikagi sikandin, “Aw itolok ko sikandin amon dekepen niyo, pila lay se kwarta ibegay niyo kanak?” Penga niyan, doen kwarta imbegay dan diyà kandin ketlowan plata. ");
INSERT INTO mbs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lekat niyan, migtagad si Judas te mèpiya aldaw amon itolok din si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nayan, pegdateng te tagnà aldaw te pista te pegpengaen te menge Judiyo te pan kenà eglebag, dimoton se menge tinoledaan i Jesus kandin, aw mig-insà dan, kagi dan, “Kenan kay lay peg-inang te kànen tadon te Pista te Pegpelowà?” ");
INSERT INTO mbs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Minikagi si Jesus, “Doton kaw te otaw te Jerusalem, aw ikagi kaw diyà kandin, ‘Insogò kay te Pengolo day amon mikagi kay diyà kamno te agpet den se pegkematay din. Komaen sikandin te Pista te Pegpelowà dini te balay nikaw sipat sikami menge tinoledaan din.’” ");
INSERT INTO mbs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Penga niyan, timolò dan kandin, aw mig-inang dan te kànen. ");
INSERT INTO mbs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pegkedelem niyan, dimoton si Jesus aw kedita te sempolò teg dowa tinoledaan din, aw kimaen dan. ");
INSERT INTO mbs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dalem te pegpengaen dan, minikagi si Jesus, “Eneng-enengi niyo se kagi ko seini. Doen sebad kenyo megtolok kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ontò nelidò se pedowan dan, aw migpetibos-tibosay dan mig-insà, kagi dan, “Pengolo, kenà ko lay lebò?” ");
INSERT INTO mbs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Minikagi si Jesus, “Doen sebad dini megtolok kanak pengkey timogen sikandin kanak. ");
INSERT INTO mbs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Metoman a imetayan, so yan se insolat gebii tepad kanak Timanem Migpekeotaw. Meneng mekelelayò se otaw megtolok kanak. Mèpiya peden aw wedà sikandin tebaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mig-insà se migtolok kandin si Judas, “Sir, kenà ko lay lebò?” Minikagi si Jesus, “Benal se inikagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nayan, telobo dan pa kimaen, nengabat si Jesus te pan, aw migpesiontong sikandin diyà te Timanem, aw binelà-belà din se pan, aw inteped din diyà kandan, aw minikagi, “Kàni niyo se pan seini, so yan se lawa ko.” ");
INSERT INTO mbs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Penga niyan, inabat din heman se tabò, aw migpesiontong sikandin diyà te Timanem, aw impeinem din iyan diyà kandan, aw minikagi, “Kedita niyo minem kani, ");
INSERT INTO mbs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","so seini se dipanog ko, aw pineokit kani, doen den kaling peokit pesalo doton te Timanem. Pineokit te pegkematay ko, pegwedaden din se salà te ontò medita otaw. ");
INSERT INTO mbs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mikagi a den diyà kenyo te eked a todà inem te ininem tadon seini singed aw metoman kidon minem te kaling bino doton te peglowan te Amay ko.” ");
INSERT INTO mbs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Penga niyan, migdelangan dan tepad te pegduyun dan te Timanem, aw nesayo dan lekat kidoen, aw dimoton dan te bontod te Olibo. ");
INSERT INTO mbs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Penga niyan, minikagi si Jesus diyà te menge tinoledaan din, “Kwani seini, tomanan se kedita niyo kanak tandà te kelimahan domateng diyà kanak, so doen kagi te Timanem insolat gebii, ‘Ipeimatay ko se otaw egtonggò te ayam-ayam karniro, aw mebilit se kedita te karniro tinonggoan din.’ ");
INSERT INTO mbs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Meneng penga te pegkeantay ko lekat te nematay, mekeonà a diyà kenyo doton te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Minikagi si Pedro diyà ki Jesus, “Pengkey tomanan se kedita te doma kamno, meneng eked a palos tanan kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Minikagi si Jesus, “Eneng-enengi se kagi ko kamno seini. Kwani te delem te eked pegkolaak se manok, ibolon a nikaw te meketelo.” ");
INSERT INTO mbs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Minikagi si Pedro, “Eked a palos pegbolon kamno, pengkey imetayan a sipat kamno.” Iling heman kenyan se inikagi te kedita te tinoledaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nayan, dimoton si Jesus aw menge tinoledaan din te kekeyowan iningedanan Gitsimani. Pegdateng dan doton, minikagi si Jesus, “Pegtagad kaw dini. Domoton a sida amon megtawal-tawal a.” ");
INSERT INTO mbs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Impetaking din si Pedro aw sìyan didowa batà i Sebedeo. Penga niyan, ontò den nepuluk se pedowan din, ");
INSERT INTO mbs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","aw minikagi sikandin, “Ontò den nepuluk se pedowan ko, iling te matay a. Peg-ogpà kaw den dini, aw ikà niyo egtedogi.” ");
INSERT INTO mbs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Penga niyan, dimeleg si Jesus te kenà mediyò, aw limemlem sikandin aw migtawal-tawal, kagi din, “Amà, aw mepakay diyà kamno, eked a no peden peokiti diyà te kelimahan seini. Meneng ibeg ko, kamno ibeg se metoman, kenà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Peglikò din doton te tinoledaan din, timedogi den dan. Linoka din dan aw minikagi sikandin diyà ki Pedro, “Nepela a den kenyo, so wedà kaw peketayod te sebad olò oras, meneng timedogi kaw. ");
INSERT INTO mbs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ikà niyo egtedogi. Meneng pegtawal-tawal kaw amon eked kaw keboyo. Pengkey mèpiya se ibeg te pedowan niyo, meneng wedad kagsen te lawa niyo.” ");
INSERT INTO mbs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Migpekediyò-diyò si Jesus te ikedowa, aw migtawal-tawal, kagi din, “Amà, aw eked kepakay aw eked a okit diyà te kelimahan seini, ibeg ko metoman se kamno ibeg.” ");
INSERT INTO mbs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Todà limikò si Jesus doton te menge tinoledaan din, aw kinità din dan timedogi, so nepilot dan. ");
INSERT INTO mbs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Todà sikandin nesayo aw migtawal-tawal te iketelo. Onawa heman se intawal-tawal din. ");
INSERT INTO mbs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Penga niyan, limikò sikandin doton te tinoledaan din aw minikagi sikandin, “Nepela a so gayed kaw timedogi. Na, dimateng den se oras te pegtolok kanak Timanem Migpekeotaw, amon dekepen a te menge otaw mededaet. ");
INSERT INTO mbs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enaw kaw den. Dimateng den se otaw megtolok kanak. Somongon kidon kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Telobo pa minikagi si Jesus, dimateng si Judas, sìyan tinoledaan i Jesus. Ontò medita se otaw timaking kandin, aw migkekamang dan te menge podok aw batota. Insogò dan te menge pengolo te simbahan aw menge obanen te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tapay dan netegahan aw eden se inangen i Judas, so minikagi sikandin, “Se otaw edekan ko, yan se otaw inahà niyo. Dekepi niyo sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nayan, pegdateng dan doton, wedà peg-alà-alà si Judas, meneng dimoton ki Jesus, aw minikagi, “Sir, mèpiya delem.” Penga niyan, inedekan din si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Minikagi si Jesus, “Elew, pedelegi den se tod nikaw.” Penga niyan, migpedapag se doma otaw diyà ki Jesus, aw migdakep dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, doen doma i Jesus nenagnos te podok din aw tinigbas din se sineligan te ontò pengolo te simbahan, aw nepalot se dibaloy telinga din. ");
INSERT INTO mbs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Meneng minikagi si Jesus, “Olii se podok diyà te lomà. Aw meglegamit se otaw te podok, imetayan heman sikandin pineokit te podok. ");
INSERT INTO mbs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wedà no besi ketegahi ini. Aw mengenganay a diyà te Amay ko, isogò din se minelalan anghil din amon megtabang dan kanak. ");
INSERT INTO mbs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Meneng simpana tebangan a dan, eked den ketoman se kagi te Timanem insolat gebii te metoman a detengan te kelimahan.” ");
INSERT INTO mbs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Penga niyan, minikagi si Jesus diyà te kedita te otaw netipon, “Kolang se pegkekamang niyo te podok aw batota amon megdakep kaw kanak, so kenà a megdedempasay. Gayed a migtoladà doton te dakel simbahan, meneng wedà a niyo dekepi doton. ");
INSERT INTO mbs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Meneng neinang se kedita nini amon metoman se insolat te menge telekeliwat te kagi te Timanem gebii tepad kanak.” Penga niyan, kimadas se kedita te tinoledaan i Jesus, aw tinenanan dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Penga niyan, inibing si Jesus te otaw migdakep kandin doton te balay te ontò pengolo te simbahan si Caifas. Tapay netipon kidoen se menenoladà te punù ingkeliwat i Moises aw menge obanen te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Timelokon heman si Pedro, meneng migpekediyò lamig dimateng sikandin doton te dowangen te balay te ontò pengolo te simbahan. Pegdateng din doton te balay, nenenoo si Pedro doma te menge otaw migtonggò te dakel simbahan, amon ketegahan din aw eden se meinang ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nayan, ibeg te menge pengolo te simbahan aw menge doma dan obanen, doen inangan dan si Jesus te salà amon doen tindegan te pegpeimatay dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pengkey medita se otaw migkebolalaw tepad kandin, meneng kenà botong se in-indan dan tepad kandin. Pegkenamay-namay, doen dowa otaw dimoton kandan, ");
INSERT INTO mbs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aw minikagi dan, “Dinineg day se inikagi din te mekebatog sikandin megbaet te dakel simbahan sida eg-ogpaan te Timanem, aw todà din iyan ipetindeg dalem te telo se aldaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Timindeg se ontò pengolo te simbahan aw minikagi, “Eden lay se itaba no kenyan? Indani kay aw benal se inikagi te didowa otaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Meneng wedà taba si Jesus. Penga niyan, minikagi se ontò pengolo te simbahan, “Megpunù a den diyà kamno pineokit te ngadan te Timanem eked palos kematay te keilangan meg-indan ka den te kebenalan. Sikona ekon se Misiyas, sìyan Batà te Timanem. Indani kay den aw benal iyan.” ");
INSERT INTO mbs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Minikagi si Jesus, “Benal se inikagi nikaw. Mikagi a den kani diyà kenyo. Te eked kenamay, komità kaw kanak Timanem Migpekeotaw egpenenoo kidoen te tangkil te Amay ko metolos amon lomowan a doma din. Lomikò a heman dini lekat te langit tekingan te labon.” ");
INSERT INTO mbs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Penga niyan, miglisì se ontò pengolo te simbahan te saol din tandà te keopal din, aw minikagi sikandin, “Migtompuyus sikandin te Timanem, so migpelingo-lingo sikandin Batà te Timanem. Wedad den kekemowan te peg-indan te doma otaw diyà kenitadon tepad kandin, so dinineg tadon den se pegtompuyus din te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, eden lay se aneng-aneng niyo tepad kandin?” Timaba dan, “Keilangan imetayan sikandin so doen salà din.” ");
INSERT INTO mbs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Penga niyan, tineptepan dan se bawa din, aw sinombag dan sikandin. Doen heman menge otaw nenampeng te mata din aw nenampak te bawa din, ");
INSERT INTO mbs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aw minikagi dan, “Na, aw ontò ka Misiyas, etoki aw sinu se nenombag kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dalem niyan, mig-ogpà si Pedro doton te lowà te balay kidoen te dowangen. Doen bayi egtelaban dimoton kandin aw minikagi, “Sikona se egdoma ki Jesus tege probinsya te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Meneng migbolon si Pedro, aw dinineg te kedita dan se kagi din, “Wedà ko ketegahi aw eden se eg-ikegiyen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Penga niyan, minalin si Pedro doton medapag te lelebangan. Doen doma bayi egtelaban kimità ki Pedro, aw minikagi diyà te menge otaw kidoen, “Otaw seini se egdoma ki Jesus tege Nasarit.” ");
INSERT INTO mbs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Todà migbolon si Pedro. Migsapà sikandin aw minikagi, “Wedà ko sikandin kilelai.” ");
INSERT INTO mbs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wedà kenamay, doen menge doma otaw dimoton ki Pedro, aw minikagi dan, “Benal sikona se sebad egdoma te otaw sida dinakep. Netegahan day te sikona se tege probinsya te Galiliya, so dinineg day se litok te kagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Penga niyan, ontò migsapà si Pedro aw minikagi, “Wedà a palos kilala te otaw sida.” Pegketà, migkolaak se manok. ");
INSERT INTO mbs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yan neeneng-enengan i Pedro se tapay inikagi i Jesus te ibolon din sikandin te meketelo te eked pa pegkolaak se manok. Penga niyan, nesayo si Pedro aw ontò migkelag. ");
INSERT INTO mbs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nayan, peglibtak te aldaw sìyan, netipon se kedita te pengolo te simbahan aw menge obanen te Judiyo, aw miglalang dan aw eden se idimanda dan diyà te gobirno tepad ki Jesus amon imetayan sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Penga niyan, ginapos dan si Jesus, aw inibing dan sikandin doton te gobirnador si Pilato. ");
INSERT INTO mbs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nayan, si Judas, sìyan migtolok ki Jesus, pegketaga-taga din te minikagi se menge pengolo te simbahan aw menge obanen te Judiyo te keilangan imetayan si Jesus, miglama-lama sikandin te medaet ininang din. In-olì din se kedakel te kwarta imbegay dan diyà kandin, ");
INSERT INTO mbs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","aw minikagi sikandin diyà kandan, “Doen salà ininang ko, so migtolok a te otaw wedad palos salà din aw imetayan den sikandin.” Meneng minikagi dan, “Wedad labut day te salà nikaw. Inday den kamno.” ");
INSERT INTO mbs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Penga niyan, insabog din se kwarta doton didalem te dakel simbahan, aw nesayo sikandin aw mig-iket te lieg din. ");
INSERT INTO mbs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inimon te menge pengolo te simbahan se kwarta insabog din, aw minikagi dan, “Simpana isawol tadon se kwarta seini diyà te solanan te kwarta ibowang diyà te Timanem, mekelàpang kidon te punù ingkeliwat i Moises, so seini se imbayad te pegpengimatay te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Penga niyan, migsebad dan tepad te kwarta sìyan, aw yan se imbayad dan te tanà te meneniyonay amon doen lebengan te menge otaw matay kidoen kenà tege Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yan se doun te eg-ingedanan se pawà sìyan “Pawà te Dipanog” lamig songkani. ");
INSERT INTO mbs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pineokit kenyan, netoman den se inikagi te telekeliwat te kagi te Timanem gebii si Jeremias, kagi din, “Ketlowan se kwarta plata keelagà din pegsebadan te menge bowad-bowad i Israel, ");
INSERT INTO mbs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aw yan se ibayad dan te tanà te meneniyonay, so yan se insogò te Timanem kanak.” ");
INSERT INTO mbs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nayan, pegpengibing dan ki Jesus doton te gobirnador, mig-insà se gobirnador, “Sikona lay se Selotan te menge Judiyo?” Minikagi si Jesus, “Ee. Benal se kagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Meneng pegdimanda te menge pengolo te simbahan aw menge obanen te Judiyo tepad ki Jesus, pengkey wedad salà din, meneng wedà palos sikandin ikagi. ");
INSERT INTO mbs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Penga niyan, minikagi si Pilato, “Medita se indimanda dan tepad kamno. Nengà lay wedà ka taba kandan?” ");
INSERT INTO mbs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Meneng wedà palos taba si Jesus, aw yan se doun te ontò nepela se gobirnador. ");
INSERT INTO mbs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nayan, kelikit te Pista te Pegpelowà, doen ketanem te gobirnador te ipelowà din se sebad otaw kineleboso, pengkey sinu se pemellien te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, dalem niyan, doen medaet otaw kineleboso ontò nedengeg, ngadan din si Barabas. ");
INSERT INTO mbs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pegketipon te medita otaw, mig-insà si Pilato, “Sinu lay se ibeg niyo ipelowà ko? Si Barabas aw si Jesus egtewalen niyo Misiyas? Sinu lay se pemellien niyo?” ");
INSERT INTO mbs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yan se inikagi i Pilato, so netegahan din te impedakep te menge pengolo te simbahan si Jesus so miningà dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dalem te pegpenenoo i Pilato doton te oseyanan, doen otaw insogò te esawa din amon ikeliwat se kagi din, “Ikà eg-inabut te otaw sìyan, so wedad salà din. Ontò nelemitan se pedowan ko tepad kandin pineokit te tegeinep tidelem.” ");
INSERT INTO mbs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dalem niyan, gayed migdeliseg se menge pengolo te simbahan aw menge obanen te Judiyo diyà te otaw netipon kidoen amon memoyò dan ki Pilato te ipelowà din si Barabas aw imetayan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wedà kenamay, todà mig-insà se gobirnador, kagi din, “Sinu lay se pinemallì niyo ipelowà ko?” Timaba dan, “Si Barabas.” ");
INSERT INTO mbs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mig-insà si Pilato, “Menonen ko si Jesus egtewalen niyo Misiyas?” Timaba se kedita dan, “Imetayi sikandin. Lensangi diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mig-insà si Pilato, “Nengà lay? Eden lay se salà ininang din?” Meneng labi pa dakel se kagi dan aw migbelobansag dan, “Imetayi sikandin. Lensangi diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nayan, netegahan den i Pilato te eked sikandin penalo diyà kandan, aw agpet den dan megsamok. Yan se doun te inabat din se wayeg aw mig-onaw te belad din dalem te pegtengteng dan diyà kandin. Minikagi sikandin, “Pineokit te peg-onaw ko te belad, impetaga-taga ko den kenyo te wedad labut ko aw imetayan niyo se otaw seini. Meneng aw yan se inangen niyo diyà kandin, inday den kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Minikagi se kedita te otaw, “Mepakay diyà kenami aw ipelumun kay aw menge bowad-bowad day tepad te peg-imatay kandin, so salà day iyan.” ");
INSERT INTO mbs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Penga niyan, impelowà i Pilato si Barabas lekat te keleboso. Impebadas din si Jesus, aw impeibing din amon ilansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Penga niyan, inibing te menge sondalo si Jesus doton didalem te balay te gobirnador, aw migtipon dan te kedita te doma dan sondalo. ");
INSERT INTO mbs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Penga niyan, linowas dan se saol din lekat kandin, aw pineseolan dan sikandin te melalag saol iling te saol te selotan. ");
INSERT INTO mbs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Linekò dan se belagen doen tigis, aw yan se insangkob dan diyà te olo din iling te korona te selotan. Doen heman tigbaw impeawid dan kandin iling te bangkà te selotan. Penga niyan, limongken dan diyà kandin aw migpelingo-lingo dan te sikandin se selotan egsegmanen dan. Minikagi dan, “Iduyun sikona Selotan te menge Judiyo.” ");
INSERT INTO mbs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Penga niyan, tineptepan dan sikandin. Inabat dan se tigbaw lekat kandin, aw yan se imbadas dan te olo din. ");
INSERT INTO mbs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Penga te pegtompuyus dan kandin, linowas dan se melalag saol lekat kandin aw impesaol dan diyà kandin se kandin saol. Penga niyan, inibing dan sikandin lekat te balay te gobirnador amon ilansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pegkesayo dan lekat te Jerusalem, netelaan te menge sondalo se tege Sirene ngadan din si Simon. Lineges dan sikandin neniang te kros lensangan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dimoton dan te bontod iningedanan Golgota. Se kelebadan niyan, “Tòlan te Olo.” Pegdateng dan doton, ");
INSERT INTO mbs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","imbegay te sondalo diyà ki Jesus se bino sinengedan te bebolong te saka metabang amon eked din imenmani se kesakit. Meneng pegtimtim din kenyan, wedà din pedelegi inemi. ");
INSERT INTO mbs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Penga te peglansang te sondalo kandin diyà te kros, pigtalad-talad dan se penenaktun linowas din, aw migbonot dan aw eden se penenaktun meabat te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Penga niyan, nenenoo dan aw migtonggò dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Doen solat insawol dan diatas te olo din tepad te indimanda kandin, kagi niyan, “Seini si Jesus, Selotan te menge Judiyo.” ");
INSERT INTO mbs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Doen heman dowa megdedempasay inlansang diyà te kros kidoen te tangkil din, aw si Jesus diyà te tengà-tengà. ");
INSERT INTO mbs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Migtompuyus kandin se menge otaw minokit te dalan medapag kidoen. Migkiling-kiling dan te olo dan te peg-otik dan kandin, ");
INSERT INTO mbs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aw minikagi dan, “Minikagi ka te mekebatog ka megbaet te dakel simbahan sida, aw todà no iyan ipetindeg dalem te telo se aldaw. Aw mekebatog ka kenyan, pekitai diyà kenami te doen tolos no pineokit te pegtabang no te kamno pegkeotawun amon eked ka kematay. Aw ontò ka Batà te Timanem, tenà ka den lekat te kros.” ");
INSERT INTO mbs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iling heman kenyan se pegtompuyus te menge pengolo te simbahan, aw menenoladà te punù ingkeliwat i Moises, aw menge obanen te Judiyo. Minikagi dan, ");
INSERT INTO mbs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Migtabang sikandin te menge doma otaw netigdaan amon eked dan pa kematay. Meneng eked den sikandin peketabang te kandin pegkeotawun amon eked kematay. Minikagi sikandin te sikandin se Selotan te menge bowad-bowad i Israel. Eked kidon pemenal te kagi din singed aw tomenà sikandin lekat te kros. ");
INSERT INTO mbs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Timanem ekon se egseligan din. Kitaen tadon den aw dakel se pedowan te Timanem kandin pineokit te pegtabang te Timanem kandin te aldaw seini, so minikagi sikandin, ‘Siaken se Batà te Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iling heman kenyan se pegtompuyus te megdedempasay inlansang diyà te kros kidoen te tangkil din. ");
INSERT INTO mbs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nayan, pegkealas dosi te aldaw, migkengitngit se langit aw tanà lamig alas tris te meapon. ");
INSERT INTO mbs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Menge alas tris te meapon, timawal si Jesus te dakel se kagi din, kagi te Hebreo, “Eli, Eli, lama sabaktani?” Se kelebadan niyan, “E Timanem ko, nengà lay tinenanan a nikaw?” ");
INSERT INTO mbs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pegdineg te menge otaw netipon kidoen, minikagi dan, “Nengenganay den sikandin diyà ki Elias, sìyan telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Doen otaw ayas minangay te ispongha aw inagem din iyan diyà te bino sinengedan te wayeg. Intangen din iyan diyà te toktok te tigbaw, aw impesopsop din iyan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Meneng timawal se menge doma otaw, “Pebeyai sikandin, so kitaen tadon aw domini si Elias amon megtabang kandin.” ");
INSERT INTO mbs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Penga niyan, todà timawal si Jesus te dakel se kagi din, aw penga niyan nematay. ");
INSERT INTO mbs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nayan, tigkan nelisì se kayad kidoen te tengà-tengà te dakel simbahan te Jerusalem. Nelisì iyan lekat diatas lamig diyà te ongan. Ontò miglinog, aw doen dedakel bato nelebak. ");
INSERT INTO mbs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Neowang se menge ilib linebengan te otaw nematay, aw medita se otaw sinakop te Timanem neantay lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Limowà dan lekat te lebeng dan, aw penga te pegkeantay i Jesus lekat te nematay, dimoton dan te Jerusalem, aw medita se otaw kimità kandan. ");
INSERT INTO mbs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, se menge sondalo aw kapitan migtonggò ki Jesus, nelemitan dan te pegkayong te linog, aw pegkekità dan te kepelahan neinang te pegkematay i Jesus. Minikagi dan heman, “Ontò Batà te Timanem se otaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Medita heman se bayi kidoen kenà mediyò te kros, aw kinità dan se kedita te neinang. Sikandan se tapay timaking ki Jesus lekat te Galiliya taman te Jerusalem amon megtabang dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sikandan si Maria tege Magdala, aw kesangay din si Maria inay i Santiago aw si Jose, aw sìyan esawa i Sebedeo, aw doen heman menge doma dan. ");
INSERT INTO mbs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pegkeapon niyan, dimateng se meyaman otaw tege Arimatiya, ngadan din si Jose. Sikandin heman se tinoledaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dimoton sikandin ki Pilato, aw pinemoyò din se lawa i Jesus amon ilebeng din. Yan migpunù si Pilato te mepakay aw ebaten din se lawa. ");
INSERT INTO mbs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Penga niyan, inabat din iyan lekat te kros, aw ginakes din te kaling sapot. ");
INSERT INTO mbs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Doen lebeng kaling impeawang i Jose diyà te pangpang, aw yan se linebengan din te lawa i Jesus. Penga niyan, kinelid din se dakel bato amon isampeng te lebeng. Penga niyan, nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kinità iyan i Maria tege Magdala aw kesangay din, so nenenoo dan dapag te lebeng. ");
INSERT INTO mbs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Keeldawan niyan, dalem te aldaw te peg-etod, dimoton ki Pilato se menge Parisiyo aw menge pengolo te simbahan, ");
INSERT INTO mbs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","aw minikagi dan, “Sir, doen neeneng-enengan day. Te wedà pa kematay se otaw sìyan migpelingo-lingo Misiyas, minikagi sikandin te meantay lekat te nematay te iketelo te aldaw. ");
INSERT INTO mbs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yan mèpiya aw isogò no se menge sondalo megtonggò te lebeng din te telo se aldaw, amon eked ketakaw te menge tinoledaan din se lawa din lekat te lebeng. Yan eked dan pekeindan te neantay den sikandin lekat te nematay. Medita den se otaw neekalan te sikandin se Misiyas, meneng labi pa medaet aw keekalan dan te neantay den sikandin lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Minikagi si Pilato, “Na, petekingi niyo se menge sondalo doton te lebeng, aw ontò niyo iyan petonggoi.” ");
INSERT INTO mbs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Penga niyan, dimoton dan te lebeng aw impeket dan se pengilala diyà te dakel bato insampeng kenyan amon wedad otaw meg-owang kenyan. Penga niyan, tinonggoan iyan te menge sondalo. ");
INSERT INTO mbs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nayan, penga te aldaw te peg-etod, te wedà pa libtak se aldaw te iselem te Linggo, dimoton si Maria tege Magdala aw kesangay din te lebeng i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Te wedà dan pa dateng doton, ontò miglinog, so doen anghil te Timanem dimateng lekat te langit, aw nengelid te bato insampeng te lebeng, aw nenenoo sikandin kidoen. ");
INSERT INTO mbs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ontò minanyag se bawa din iling te kilem, aw ontò mepotì se penenaktun din. ");
INSERT INTO mbs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tinegangtang se menge sondalo tandà te lamit dan, aw nekelias dan iling te otaw nematay. ");
INSERT INTO mbs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na, pegdateng te didowa bayi doton te lebeng, minikagi se anghil, “Ikà niyo egkelemitan. Netegahan ko te inahà niyo si Jesus, sìyan inlansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Meneng wedad sikandin dini, so neantay den lekat te nematay. Yan se tapay din impakang. Awop kaw diyà amon kitaen niyo se linebengan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, kegaen kaw den doton te menge tinoledaan din, aw indani niyo dan te neantay den sikandin lekat te nematay, aw nekeonà den sikandin diyà kenyo pesalo doton te probinsya te Galiliya. Kitaen niyo sikandin doton. Yan se kagi ko kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Penga niyan, migpekegaen dan se nesayo lekat te lebeng. Pengkey nelemitan dan, meneng ontò heman neluba se pedowan dan. Kimagnan dan amon meg-indan dan kenyan diyà te menge tinoledaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te wedà dan pa dateng doton, kinità dan si Jesus kidoen te dalan, aw minikagi sikandin, “Mèpiya iselem.” Migpedapag dan diyà kandin, aw limongken dan, aw minawid dan te benis din, aw migsimba dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Minikagi si Jesus, “Ikà niyo egkelemitan. Doton kaw den te menge tinoledaan ko. Ikagi kaw diyà kandan te ibeg ko domoton dan te Galiliya, so kitaen a dan doton.” ");
INSERT INTO mbs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nayan, pegkesayo te bayi, dimoton te Jerusalem se menge sondalo migtonggò te lebeng. Mig-indan dan diyà te menge pengolo te simbahan te kedita te neinang diyà kandan doton te lebeng. ");
INSERT INTO mbs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Penga niyan, tinipon te menge obanen te Judiyo se menge doma dan, aw migpebelaw-belaway dan. Penga niyan, dakel se kwarta imbegay dan diyà te menge sondalo, ");
INSERT INTO mbs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aw minikagi dan, “Peg-indan kaw diyà te doma otaw te dimoton se menge tinoledaan din te delem, aw tinakaw dan se lawa din dalem te pegtedogi niyo. ");
INSERT INTO mbs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aw dinegen iyan te gobirnador, sikami se megbalaw-balaw kandin amon eked kaw din keopali.” ");
INSERT INTO mbs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Penga niyan, kininawà te menge sondalo se kwarta, aw timolò dan te impunù kandan. Iling kenyan se ipeg-indan-indan te keditaan te Judiyo lamig songkani. ");
INSERT INTO mbs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nayan, dimoton se sempolò tegusà tinoledaan i Jesus te Galiliya doton te bontod pinedotonan i Jesus kandan. ");
INSERT INTO mbs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pegkità dan kandin, migsimba dan kandin. Meneng doen menge tinoledaan din egdowa-dowa aw benal sikandin. ");
INSERT INTO mbs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Migpedapag si Jesus diyà kandan aw minikagi, “Impelowan a den diyà te kedita doton te langit aw dini heman te lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yan isogò ko den sikiyo doton te kebelad te keneyonan. Pegtoladà kaw te kedita te otaw amon tomaking dan kanak. Pemonyagi niyo dan diyà te ngadan te Timanem Amay, aw Batà din, aw Espiritu Santo. ");
INSERT INTO mbs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pegtoladà kaw kandan te keilangan tomolò dan te kedita te impunù ko diyà kenyo. Na, gayed a meg-ipat kenyo pengkey lamig te temanan te keneyonan.”");
INSERT INTO mbs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Seini se keteboan te Mèpiya Indan tepad te Batà te Timanem, si Jesu Cristo. ");
INSERT INTO mbs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gebii doen insolat te telekeliwat te kagi te Timanem si Isaias, “Na, doen otaw isogò ko megpetaga-taga te agpet ka den domateng, amon megpeketagad se kedita te otaw te pegdateng nikaw. ");
INSERT INTO mbs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dinegen niyo se otaw doton te kebigtilan aw dakel se kagi din, ‘Pegpeketagad kaw te pegdateng te Pengolo. Peg-inang kaw te metòlid, so domateng sikandin.’” ");
INSERT INTO mbs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nayan, dimoton si Juan Memonyagay te kebigtilan. Migtoladà sikandin te kedita te otaw te keilangan megselsel dan te salà ininang dan aw bonyagan dan amon ipetaga-taga dan te pigwedad den te Timanem se salà dan. ");
INSERT INTO mbs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Medita se otaw lekat te menge lonsod sakop te probinsya te Judiya aw lekat te Jerusalem dimoton amon menenalan kandin. Migselsel dan te menge salà ininang dan, aw binonyagan din dan doton te wayeg te Jordan. ");
INSERT INTO mbs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nayan, egpenaol si Juan te saol inabel lekat te bolbol te ayam-ayam kamilo, aw egpengelen te kindal te ayam-ayam. Egpengànen din se menge dolon aw teneb eg-ebaten din doton te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Migtoladà sikandin, kagi din, “Doen domateng labi pa melangkaw diyà kanak. Kenà botong se kelangkaw ko amon megtelaban a kandin pengkey meglebad a te sepatos din, so ontò sikandin melangkaw diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nemonyag a kenyo pineokit te wayeg, meneng sikandin se memonyag kenyo pineokit te Espiritu Santo.” ");
INSERT INTO mbs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nayan, wedà kenamay, dimateng si Jesus lekat te lonsod te Nasarit sakop te probinsya te Galiliya, aw migpebonyag sikandin ki Juan kidoen te wayeg te Jordan. ");
INSERT INTO mbs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Peg-anggin i Jesus lekat te wayeg, pegketà kinità din se langit neowang aw migpedanà se Espiritu Santo diyà kandin iling te selepati. ");
INSERT INTO mbs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Penga niyan, dinineg dan se kagi te Timanem lekat te langit, “Sikona se Batà ko. Dakel se pedowan ko kamno, aw ontò a neluba kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Penga niyan, inibing sikandin te Espiritu Santo doton te kebigtilan. ");
INSERT INTO mbs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mig-ogpà sikandin kidoen taman te kepatan se aldaw, aw binoyo peden i Satanas. Doen menge menenanap te kebenesan dimoma kandin, meneng doen menge anghil mig-ipat kandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nayan, penga te pegpedakep i Herod ki Juan Memonyagay, dimoton si Jesus te probinsya te Galiliya aw migtoladà te Mèpiya Indan lekat te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Minikagi sikandin, “Netoman den se aldaw tapay impakang, aw agpet den lomowan se Timanem diyà kenyo. Pegselsel kaw den te menge salà ininang niyo, aw pemenal kaw den te Mèpiya Indan.” ");
INSERT INTO mbs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nayan, minipanaw si Jesus doton te kilid te lanaw te Galiliya. Kinità din se didowa memokotay si Simon aw adi din si Andres nemokot. ");
INSERT INTO mbs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Timawal si Jesus, “Taking kaw kanak, so megtoladà a kenyo amon kenà ikan se meabat niyo, meneng otaw se ibingen niyo diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pegketà, tinenanan dan se pokot aw timaking dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Penga niyan, dimeleg si Jesus te kenà mediyò, aw kinità din si Santiago aw adi din si Juan didowa dan batà i Sebedeo. Kidoen dan te belangay aw migtigmes dan te pokot. ");
INSERT INTO mbs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pegketà, tinawal dan heman i Jesus. Tinenanan dan se amay dan kidoen te belangay sipat menge doma otaw egtendanan din, aw timaking dan heman ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Penga niyan, dimoton dan te lonsod te Kapirnaom. Pegkesebado, dimoton si Jesus te simbahan te Judiyo aw migtoladà kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ontò nepela se kedita te otaw dimineg te intoladà din, so kenà iling te pegtoladà te menenoladà te punù ingkeliwat i Moises se pegtoladà i Jesus, so tinekingan si Jesus te tolos. ");
INSERT INTO mbs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pegketà, dimateng kidoen te simbahan se otaw dinetengan te bosaw. ");
INSERT INTO mbs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Timawal sikandin, “Tay, Jesus tege Nasarit. Ikà eg-inabut kenami. Ikà egbaet kenami. Netegahan ko aw sinu ka. Sikona se metòlid otaw insogò te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Meneng migsagda si Jesus te bosaw, kagi din, “Kepenek ka den. Lowà ka den diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Impekeseg te bosaw se otaw aw timawal te dakel se kagi din, aw penga niyan limowà diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nepela se kedita te otaw, aw migpebelaw-belaway dan, kagi dan, “Tay law. Sebad se ipegtoladà din. Metolos sikandin, so aw megpelowà sikandin te menge bosaw, egtolò dan kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wedà kenamay, ontò nedengeg si Jesus kidoen te kedita te ogpeanan medapag doton te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wedà kenamay, nesayo si Jesus lekat te simbahan te Judiyo aw dimoton te balay i Simon aw si Andres. Timaking heman si Santiago aw si Juan. ");
INSERT INTO mbs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nayan, netigdaan se ogangan i Pedro bayi piglegenaw, aw inindanan dan si Jesus tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Penga niyan, dimoton si Jesus kandin, aw minawid te belad din, aw impeenaw din. Migkèpiya sikandin, aw penga niyan mig-inang te kànen i Jesus aw menge doma din. ");
INSERT INTO mbs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pegsallep te aldaw sìyan, inibing dan doton ki Jesus se kedita te otaw doen mesakit aw otaw dinetengan te bosaw. ");
INSERT INTO mbs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ontò medita se tege Kapirnaom netipon doton te lowà te balay. ");
INSERT INTO mbs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pinegolian din se medita otaw doen medita kemolò te mesakit, aw medita heman se bosaw impelowà din lekat te otaw. Meneng sinagda i Jesus se menge bosaw amon eked dan ikagi, so netegahan dan aw sinu sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pegkeiselem niyan te wedà pa libtak se aldaw, minenaw si Jesus aw dimoton te wedad otaw eg-ogpà, aw migtawal-tawal doton. ");
INSERT INTO mbs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Meneng nengemahà si Simon aw menge doma otaw kandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pegkità dan kandin, minikagi dan, “Pinengemahà ka te kedita te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Meneng minikagi si Jesus, “Domeleg kidon den doton te menge doma lonsod amon megtoladà a heman doton, so yan se doun te dimini a.” ");
INSERT INTO mbs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yan timeped sikandin te kedita te lonsod doton te probinsya te Galiliya, aw migtoladà kidoen te menge simbahan te Judiyo, aw impelowà din se menge bosaw lekat te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nayan, doen otaw pigtompig dimoton ki Jesus, aw migpeido-ido diyà kandin. Limongken heman sikandin aw minikagi, “Aw doen ibeg nikaw, netegahan ko te mekebatog ka megpegolì kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Neido si Jesus aw nemaed kandin, aw minikagi, “Meibeg a. Kegolian ka.” ");
INSERT INTO mbs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pegketà, negolian sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ontò migpunù si Jesus kandin, kagi din, “Keilangan wedad palos otaw indanan no tepad te ininang ko kamno. Meneng doton ka te pengolo te simbahan, aw pekitai se lawa no diyà kandin. Penga niyan, begayi se ibowang no iling te impunù i Moises amon metaga-taga se kedita te otaw te negolian ka den.” Penga niyan, impekesayo sikandin i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Meneng pegkesayo din, medita se otaw inindanan din tepad te ininang i Jesus kandin. Yan se doun te wedà pekeokit si Jesus te menge lonsod so pelaban medita se otaw metipon. Yan miglegeb sikandin doton te ogpeanan mediyò te lonsod, aw medita se otaw dimoton kandin lekat te kedita te ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nayan, peglaklak te pila aldaw, minolì si Jesus doton te Kapirnaom. Doen menge otaw dimineg te mig-ogpà sikandin diyà te balay kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yan medita se otaw netipon doton didalem te balay igsà wedà pekeombà se menge otaw pengkey doton te lowà te balay medapag te lelebangan. Dalem te pegtoladà i Jesus kandan te kagi te Timanem, ");
INSERT INTO mbs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","dimateng se epat otaw neningga te otaw kenà egpekeiwal. ");
INSERT INTO mbs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wedà dan pekedapag diyà ki Jesus so ontò medita se otaw netipon. Yan nenayit dan doton te atep te balay sìyan, so pantal se atep niyan. Inowang dan se atep kidoen diatas i Jesus, aw intonton dan se otaw kenà egpekeiwal sipat inibatan din. ");
INSERT INTO mbs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pegkità i Jesus te ontò dan simalig diyà kandin, minikagi sikandin diyà te otaw kenà egpekeiwal, “Elew, pigwedad den se salà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nayan, doen menge menenoladà te punù ingkeliwat i Moises nenenoo kidoen, aw mig-aneng-aneng dan, ");
INSERT INTO mbs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Eked kepakay se inikagi din sìyan. Migtompuyus sikandin te Timanem, so wedad mekebatog megwedad te salà meneng olò Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nayan, netegahan i Jesus aw eden se aneng-aneng dan, aw yan minikagi sikandin, “Nengà lay egdowa-dowa se aneng-aneng niyo? ");
INSERT INTO mbs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mola megpelingo-lingo se otaw megwedad te salà. Meneng eked pekebatog se otaw megpegolì te otaw kenà egpekeiwal singed aw doen tolos te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Meneng so Timanem a Migpekeotaw, ipekità ko den kenyo te mekebatog a megwedad te salà te otaw dini te tanà.” Penga niyan, minikagi si Jesus diyà te otaw kenà egpekeiwal, ");
INSERT INTO mbs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Enaw ka. Loloni se inibatan no, aw olì ka den.” ");
INSERT INTO mbs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yan minenaw sikandin, aw inibing din se inibatan din, aw tinengtengan sikandin te menge otaw se minolì. Yan se doun te nepela se kedita dan, aw induyun dan se Timanem. Migpebelaw-belaway dan, “Wedad palos kinità tadon iling kenyan.” ");
INSERT INTO mbs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pegkesayo i Jesus lekat te balay, todà sikandin dimoton te kilid te lanaw. Netipon se kedita te otaw diyà kandin, aw migtoladà sikandin kandan. ");
INSERT INTO mbs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pegkesayo i Jesus lekat kidoen, doen iskribinti si Levi batà i Alfeo nenenoo kidoen te opisina din. Pegkità i Jesus kandin, minikagi sikandin, “Taking ka kanak.” Yan timindeg si Levi, aw timaking sikandin ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Penga niyan, kimaen si Jesus kidoen te balay i Levi, aw medita heman se menge iskribinti aw doma otaw nelegeb te salà kimaen doma i Jesus aw menge tinoledaan din, so medita se otaw iling kenyan timaking ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Doen heman kidoen menge menenoladà te punù ingkeliwat i Moises sakop te menge Parisiyo. Pegkità dan te kimaen si Jesus doma te menge iskribinti aw doma otaw nelegeb te salà, minikagi dan diyà te menge tinoledaan i Jesus, “Medaet iyan, so egpengaen sikandin doma te medaet otaw, menge iskribinti aw doma otaw nelegeb te salà.” ");
INSERT INTO mbs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Meneng pegdineg i Jesus te inikagi dan, minikagi sikandin, “Kenà otaw wedad mesakit se bolongen te doktor, meneng otaw doen mesakit se bolongen din. Insogò a dini kenà amon tewalen ko se otaw eg-aneng-aneng te metòlid se eg-inangen dan, meneng insogò a dini amon tewalen ko se otaw mekesesalà.” ");
INSERT INTO mbs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nayan, egpowasa se menge tinoledaan i Juan, aw egpowasa heman se menge Parisiyo. Doen menge otaw dimoton ki Jesus aw minikagi dan, “Melikit egpowasa se menge tinoledaan i Juan, aw egpowasa heman se menge tinoledaan te Parisiyo. Nengà lay kenà egpowasa se kamno menge tinoledaan?” ");
INSERT INTO mbs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Minikagi si Jesus, “Aw doen peipid, eked kepuluk se menge sigalak te meama peipiden dalem te kidoen pa sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Meneng doen aldaw domateng aw meabat lekat kandan se meama peipiden, aw yan se aldaw megpowasa dan so mepuluk dan.” ");
INSERT INTO mbs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mig-indan heman si Jesus te tegdeyanan tepad te kaling itoladà din, kagi din, “Eked kepakay aw tompalan se tapay penenaktun te kaling tila wedà pa bugsaki, so komotot se kaling tila aw itompal diyà te tapay, aw meinang labi pa dakel se lisì te saol. ");
INSERT INTO mbs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aw meg-inang heman se otaw te bino, eked din soli se temek te paras diyà te solanan ininang lekat te kindal te kambing tapay linanit, so aw megbohak se temek, megbeto se solanan tapay linanit, aw eleg kebàtan se bino aw solanan niyan. Yan keilangan isawol se temek inangen bino diyà te solanan kaling linanit.” ");
INSERT INTO mbs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nayan, Sebado se aldaw te peg-etod te menge Judiyo. Pegkesebado, minokit si Jesus aw menge tinoledaan din kidoen te kilid te pawà te trigo agpet den geniyen. Peg-okit dan kidoen, kimetel se menge tinoledaan din te oway te trigo, aw kinaen dan, so binallos dan. ");
INSERT INTO mbs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Meneng minikagi se menge Parisiyo diyà ki Jesus, “Tay law. Mig-inang se menge tinoledaan no te salà, so doen punù ingkeliwat i Moises te keilangan eked kidon pegterbaho te aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Minikagi si Jesus, “Kenà medaet se ininang dan. Nelibelan niyo den besi aw eden se insolat kidoen te kagi te Timanem tepad te ininang i David gebii dalem te si Abiatar se ontò pengolo te simbahan. So binallos si David aw menge sondalo timaking kandin, aw wedad palos kànen dan, ");
INSERT INTO mbs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","yan minawop sikandin diyà te balay te Timanem, aw kinaen din se pan imbegay diyà te Timanem. Yan heman se impekaen din te menge doma din. Pengkey doen punù ingkeliwat i Moises te mepakay olò iyan kànen te menge pengolo te simbahan, meneng kenà medaet se ininang i David.” ");
INSERT INTO mbs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Minikagi heman si Jesus, “Migpunù se Timanem te doen aldaw te peg-etod kenà amon doen kelimahan te otaw, meneng amon doen kèpiyaan te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","So siak se Timanem Migpekeotaw, mepakay aw siak se mikagi aw eden se mepakay inangen pengkey aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nayan, dimoton si Jesus te simbahan te Judiyo. Doen otaw kidoen nekepis se belad din. ");
INSERT INTO mbs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kidoen heman se menge otaw nengemahà te idimanda dan tepad ki Jesus, aw yan se doun te gayed dan migsimà kandin aw megpegolì sikandin te otaw doen mesakit te aldaw te peg-etod. ");
INSERT INTO mbs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Minikagi si Jesus diyà te otaw nekepis se belad, “Diyà ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Penga niyan, minikagi si Jesus diyà te menge otaw timengteng kandin, “Tepad te punù ingkeliwat i Moises, eden lay se mepakay inangen tadon te aldaw te peg-etod? Meg-inang kidon lay te mèpiya, aw meg-inang kidon te medaet? Megtabang kidon lay te doma otaw, aw mengimatay kidon te doma?” Meneng wedad palos intaba dan. ");
INSERT INTO mbs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Timengteng si Jesus diyà te kedita dan, aw neopal sikandin so nelidò se pedowan din tandà te kagsen te olo dan. Penga niyan, minikagi sikandin diyà te otaw nekepis se belad, “Oladi se belad nikaw.” Peg-olad din te belad din, pegketà migkèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Penga niyan, nesayo se menge Parisiyo, aw migpebelaw-belaway dan sipat menge sakop i Herod tepad te inangen dan amon matay dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nayan, nesayo si Jesus aw menge tinoledaan din lekat kidoen aw dimoton dan te kilid te lanaw. Medita se otaw timaking kandan lekat te probinsya te Galiliya. Doen heman menge otaw lekat te probinsya te Judiya, ");
INSERT INTO mbs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aw tege Jerusalem, aw lekat te probinsya te Idumya, aw lekat dipag te wayeg te Jordan, aw medita heman lekat te kedepagan te lonsod te Tiro aw Sidon. Pegdineg dan tepad te kedita te kepelahan ininang i Jesus, dimoton dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sagwa ontò medita se otaw netipon, migpunù sikandin te menge tinoledaan din te megpetagad dan te belangay sekayan din amon eked sikandin sigpiti te menge otaw. ");
INSERT INTO mbs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Medita se otaw pinegolian din, aw yan medita se otaw doen mesakit migpeegaway se migpedapag diyà kandin amon memaed dan kandin aw kegolian dan. ");
INSERT INTO mbs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dimoton heman kandin se menge otaw dinetengan te bosaw. Pegkità dan kandin, limongken dan diyà kandin aw timawal dan te dakel kagi, “Sikona se ontò Batà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Meneng ontò migpunù si Jesus te keilangan wedad doma otaw indanan dan tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nayan, timikedeg si Jesus te bontod, aw tinawal din se menge otaw pinemallì din, aw dimoton dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Penga niyan, doen sempolò teg dowa otaw pinemallì din aw iningedanan din dan menge apostol, amon gayed dan tomaking kandin, aw yan se insogò din megtoladà te Mèpiya Indan. ");
INSERT INTO mbs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Imbegay din diyà kandan se tolos amon megpelowà dan te bosaw lekat te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Seini se menge ngadan te otaw pinemallì din, si Simon iningedanan i Jesus ki Pedro, ");
INSERT INTO mbs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aw didowa batà i Sebedeo si Santiago aw adi din si Juan. Yan se telekedowa iningedanan i Jesus ki Boanerges. (Se kelebadan niyan, “kenà telawun.”) ");
INSERT INTO mbs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pinemallì din heman si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago batà i Alfeo, si Tadeo, si Simon meyseg, ");
INSERT INTO mbs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aw si Judas Iscariote, sìyan migtolok ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Penga niyan, minolì si Jesus. Meneng wedà sikandin pekekaen aw menge tinoledaan din so medita se otaw todà netipon kidoen kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pegdineg te menge kedomaan i Jesus te wedà sikandin pekekaen, dimoton dan kandin amon ibingen dan sikandin doton te balay, so doen menge otaw eg-ikagi te migkebook sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Doen menge menenoladà te punù ingkeliwat i Moises tikedo te Jerusalem simila ki Jesus, kagi dan, “Dinetengan sikandin i Belsebul, se doma ngadan i Satanas. Pengolo te bosaw se nemegay kandin te tolos amon megpelowà sikandin te bosaw lekat te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Meneng tinawal dan i Jesus, aw minikagi sikandin diyà kandan pineokit te tegdeyanan, “Eked kepakay aw megpelowà si Satanas te menge bosaw sinekopan din. ");
INSERT INTO mbs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Simpana megbebolaw se sakop te sebad selotan, kebàtan se peglowan te selotan sìyan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Simpana megbebolaw se otaw migsebad te balay, kebàtan se ogpeanan dan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Simpana megbolaw si Satanas diyà te menge sakop din aw meinang dan poon din, kebàtan se peglowan din te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Aw magsen se otaw, eked keagaw se awop te balay din singed aw domateng se otaw labi pa magsen diyà kandin. Yan se mekedaeg te tig-apò te balay aw meglegapos kandin, aw penga niyan mengabat sikandin te awop te balay. ");
INSERT INTO mbs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Eneng-enengi niyo se kagi ko kenyo. Pengkey eden kemoloi te salà inangen te otaw, mepakay iyan pegwedaden te Timanem, pengkey megtompuyus dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Meneng aw megtompuyus se otaw te Espiritu Santo, eked palos pegwedadi se salà din sìyan. Meneng ipelumun sikandin te wedad temanan tandà te salà din sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yan se inikagi din diyà kandan, so minikagi dan te dinetengan te bosaw si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nayan, pegtoladà i Jesus, dimateng se inay din aw menge kedowa din. Migtagad dan doton te lowà te balay. Impetawal dan sikandin so ibeg dan megkità kandin. ");
INSERT INTO mbs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Medita se otaw nenenoo kidoen te dapag din, aw minikagi dan diyà kandin, “Doton te lowà se inay no aw menge kedowa nikaw. Meibeg dan ekon megkità kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Meneng minikagi si Jesus diyà kandan, “Mikagi a den diyà kenyo aw sinu se inay ko aw menge kedowa ko.” ");
INSERT INTO mbs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Penga niyan, timengteng si Jesus diyà te menge otaw nenenoo kidoen, aw minikagi sikandin, “Seini se inay ko aw menge kedowa ko. ");
INSERT INTO mbs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Se menge otaw egtolò te ibeg te Timanem, yan se meinang inay ko aw menge kedowa ko meama aw bayi.” ");
INSERT INTO mbs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nayan, doen aldaw migtoladà si Jesus doton te kilid te lanaw. Ontò medita se otaw netipon diyà kandin, aw yan se doun te minalin sikandin doton te belangay pinondohan medapag te kilid te lanaw. Nenenoo sikandin kidoen, meneng mig-ogpà se kedita te otaw tinoledaan din doton te kilid te lanaw kidoen te tanà. ");
INSERT INTO mbs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Penga niyan, medita se kebenalan intoladà din diyà kandan pineokit te tegdeyanan. Pegtoladà din, minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Doen otaw dimoton te pawà amon menabog te benì, so yan se ketanem te pegpenanem din. ");
INSERT INTO mbs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pegsabog din, doen benì nesabog diyà te dalan, aw kinaen iyan te menge manok te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Doen heman benì nesabog diyà te tanà kebeto-betowan, aw wedad nael tanà kidoen. Timobò iyan te wedà kenamay, so kenà medalem se tanà. ");
INSERT INTO mbs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Meneng pegkelangkaw te aldaw, nelanes aw nematay so wedad nael dalid. ");
INSERT INTO mbs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Doen heman benì nesabog diyà te pinonoan te sagbet doen tigis. Timilles heman se sagbet doen tigis aw kinelep se menge tobò aw nematay. Yan wedad palos pongo niyan. ");
INSERT INTO mbs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Meneng doen benì nesabog diyà te melambò tanà. Yan se timobò aw timilles, aw minongo. Doen minongo te ketlowan, aw doen minongo te keneman aw ginatos.” ");
INSERT INTO mbs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Minikagi heman si Jesus, “Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Penga te pegkesayo te keditaan te otaw, doen diyà te sempolò teg dowa tinoledaan i Jesus aw menge otaw nesamà mig-insà diyà kandin tepad te tegdeyanan intoladà din. ");
INSERT INTO mbs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Minikagi si Jesus, “Sikiyo se pinetega-tegahan te Timanem te kebenalan tepad te peglowan din. Meneng olò pineokit te tegdeyanan se pegtoladà ko te doma otaw ");
INSERT INTO mbs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","amon pengkey tomengteng dan, meneng eked dan kità te kedegdagan niyan. Pengkey domineg dan, meneng eked dan ketaga-taga te kebenalan niyan, so aw mekelabet dan, mengenganay dan diyà kanak aw pegwedaden ko se salà ininang dan.” ");
INSERT INTO mbs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Minikagi si Jesus, “Nepela a so wedà kaw pekelabet te tegdeyanan sìyan. Aw wedà kaw pekelabet kenyan, eked kaw pekelabet te kedita te doma tegdeyanan ipegtoladà ko kenyo. ");
INSERT INTO mbs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nayan, se kedegdagan te otaw nenabog te benì, yan se otaw egtoladà te kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Se benì nesabog diyà te dalan, yan se iling te otaw toledaan te kagi te Timanem. Aw domineg dan kenyan, doen inangen i Satanas amon kelibelan dan se kagi te Timanem dinineg dan. ");
INSERT INTO mbs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nayan, se benì nesabog diyà te tanà kebeto-betowan, yan se iling te otaw domineg te kagi te Timanem, aw meluba dan, aw tomolò dan kenyan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Meneng aw domateng se kelimahan aw pemilangen dan tandà te pegpemenal dan te kagi te Timanem, tenanan dan se pinemenalan dan, so iling dan te tinanem wedad nael dalid. ");
INSERT INTO mbs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nayan, se benì nesabog diyà te pinonoan te sagbet doen tigis, yan se iling te otaw ontò domineg te kagi te Timanem intoladà. ");
INSERT INTO mbs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Meneng penga niyan, wedad ontong dan so dàgen dan te ibeg dan tomaking te ketanem te keneyonan, aw ibeg dan megkeyaman amon meluba dan, aw menge doma ibeg dan. Yan se doun te wedad ontong dan diyà te kagi te Timanem dinineg dan. ");
INSERT INTO mbs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Meneng se benì nesabog diyà te melambò tanà, yan se iling te otaw domineg te kagi te Timanem, aw menenalan dan kenyan. Doen ontong dan iling te intanem mongo te ketlowan, aw keneman aw ginatos.” ");
INSERT INTO mbs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Minikagi si Jesus, “Aw menemtem se otaw te solò, eked din iyan sengkobi. Eked din heman elesi doton te siyong te katri. Meneng mèpiya aw isawol din iyan diyà te kelengkawan. ");
INSERT INTO mbs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iling heman kenyan, wedad in-eles songkani eked kitai te modi aldaw. Wedad heman imbolon songkani eked keindan te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Minikagi heman si Jesus, “Keilangan toloen niyo se dinineg niyo. ");
INSERT INTO mbs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Se otaw kominawà te kebenalan, yan se dogangan te kebenalan. Meneng se otaw eked kinawà te kebenalan, yan se pegwedadan te kebenalan.” ");
INSERT INTO mbs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Minikagi heman si Jesus, “Iling kani se peglowan te Timanem. Aw menanem se otaw te benì doton te pawà din, ");
INSERT INTO mbs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","penga niyan, wedad ketetana din tepad te pegtilles niyan pengkey aldaw aw delem, so gayed tomobò aw tomilles se itanem din pengkey wedà din ketegahi se pegtobò niyan. ");
INSERT INTO mbs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gayed tomilles se itanem kidoen te tanà, so onà tomobò, aw penga niyan domawen, aw penga niyan mongo iyan. ");
INSERT INTO mbs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aw metesan se pongo, geniyen iyan te otaw, so dimateng den se aldaw te peglegani.” ");
INSERT INTO mbs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Minikagi heman si Jesus, “Meg-indan a den kenyo tepad te peglowan te Timanem pineokit te tegdeyanan seini. ");
INSERT INTO mbs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Doen benì ontò deitek intanem te otaw doton te pawà din. Pengkey wedad ekon palos benì labi pa deitek kenyan, ");
INSERT INTO mbs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","meneng penga te pegtanem din, timilles iyan, aw labi pa iyan dakel diyà te kedita te doma intanem din. Dakel se menge panga niyan, aw migsalag se menge manok kidoen.” ");
INSERT INTO mbs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Migtoladà si Jesus kandan pineokit te medita tegdeyanan iling kenyan taman te egkelebetan dan. ");
INSERT INTO mbs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Impeokit din te tegdeyanan se kedita te intoladà din kandan. Meneng gayed din ipeg-indan te menge tinoledaan din dalem te wedad doma dan aw eden se kedegdagan te kedita te tegdeyanan. ");
INSERT INTO mbs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pegkeapon te aldaw sìyan, minikagi si Jesus diyà te menge tinoledaan din, “Mèpiya aw matas kidon doton dipag te lanaw.” ");
INSERT INTO mbs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Penga niyan, tinenanan dan se kedita te otaw netipon kidoen te kilid te lanaw, aw simakay dan heman te belangay tapay sinekayan i Jesus. Doen heman menge doma belangay timaking kandan. ");
INSERT INTO mbs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wedà kenamay, dinetengan dan te kelamag ontò mebandes, aw nekeawop se wayeg diyà te belangay, aw agpet dan neteled. ");
INSERT INTO mbs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Meneng neketedogi si Jesus diyà te olonan kidoen te olin. Linoka dan sikandin aw minikagi dan, “Sir, tebangi kay, so melemes kidon den.” ");
INSERT INTO mbs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Neloka si Jesus aw sinagda din se kelamag. Minikagi sikandin diyà te balud, “Pegkelinaw ka.” Penga niyan, timunung se kelamag aw migkelinaw se lanaw. ");
INSERT INTO mbs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Minikagi si Jesus, “Wedà pa kedì kelobos se pegsalig niyo kanak. Ikà niyo egkelemitan.” ");
INSERT INTO mbs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ontò dan nepela aw migpebelaw-belaway dan, kagi dan, “Ontò sikandin metolos, so pengkey kelamag aw balud timolò kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nayan, dimeleg dan doton dipag te lanaw medapag te Gerasa. ");
INSERT INTO mbs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pegtenà i Jesus, doen otaw dinetengan te bosaw simongon kandin lekat te menge lebenganan, ");
INSERT INTO mbs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","so yan se eg-ogpaan din. Ontò sikandin magsen, aw yan se doun te eked sikandin kegapos te doma otaw, pengkey doen sengkalì. ");
INSERT INTO mbs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pengkey melikit dan sikandin eggeposen te sengkalì, aw egpentongan dan sikandin, meneng gayed din egbogtoen se sengkalì, aw egbàtan din se ipegpantong kandin. Wedad palos otaw mekedaeg kandin so ontò magsen. ");
INSERT INTO mbs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pengkey aldaw aw delem, gayed sikandin eglegeb kidoen te lebenganan aw doton heman te bontod, aw gayed egpuypuy aw egpemoneg te lawa din te bato. ");
INSERT INTO mbs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pegkità din ki Jesus doton te mediyò, kimagnan sikandin simongon ki Jesus aw limongken diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Migpunù si Jesus diyà te bosaw, kagi din, “Lowà ka den diyà kandin.” Minikagi se otaw te dakel kagi din, “Jesus, Batà te Timanem ontò melangkaw, ikà egsamok kanak. So Timanem se egtengteng kenita, memoyò a diyà kamno, ikà bag egpeeleg kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mig-insà si Jesus, “Sinu lay se ngadan nikaw?” Timaba sikandin, “Si Minelalan se ngadan ko, so medita kay.” ");
INSERT INTO mbs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ontò nemoyò se bosaw diyà ki Jesus te eked din dan peseyowi doton te mediyò ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ontò medita se osa nenowal doton te bontod medapag. ");
INSERT INTO mbs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nemoyò se menge bosaw diyà ki Jesus, kagi dan, “Aw mepakay diyà kamno, malin kay doton te menge osa sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yan impealin din dan. Limowà se menge bosaw lekat te otaw aw minalin dan doton te osa. Penga niyan, kimagnan se kedita te osa pesalo te keba, aw kimahang dan doton te lanaw. Nelemes se kedita dan menge dowa melalan. ");
INSERT INTO mbs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Penga niyan, kimadas se menge telediyaga te osa aw mig-indan dan tepad kenyan doton te lonsod aw kedepagan niyan. Penga niyan, dimoton se menge otaw inindanan dan amon komità dan kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pegdateng dan doton ki Jesus, kinità dan se otaw pinelowaan te minelalan se bosaw. Nenenoo sikandin, aw nenelowal den, aw migkèpiya den. Pegkità dan kenyan, nelemitan dan. ");
INSERT INTO mbs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Inindanan dan heman te menge otaw kimità kenyan tepad te neinang diyà te otaw sìyan aw menge osa. ");
INSERT INTO mbs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lekat niyan, nemoyò dan te mesayo si Jesus lekat te ogpeanan dan. ");
INSERT INTO mbs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Penga niyan, te pegsakay i Jesus te belangay, nemoyò se otaw pinelowaan te bosaw aw mepakay sikandin tomaking. ");
INSERT INTO mbs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Meneng wedà din petekingi, so inikegiyan i Jesus, “Olì ka den doton te menge kedomaan nikaw, aw peg-indan ka kandan tepad te mèpiya ininang te Pengolo kamno, aw keido din kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Penga niyan, nesayo sikandin aw mig-indan doton te Dikapolis tepad te mèpiya ininang i Jesus diyà kandin. Yan se doun te nepela se kedita te otaw inindanan din. ");
INSERT INTO mbs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pegbatas i Jesus doton dipag te lanaw, ontò medita se otaw netipon diyà kandin doton te kilid te lanaw. ");
INSERT INTO mbs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Penga niyan, dimoton ki Jesus se sebad obanen te simbahan te Judiyo, ngadan din si Jairo. Pegkità din ki Jesus, limongken sikandin ");
INSERT INTO mbs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aw nemoyò, kagi din, “Ontò netigdaan se deitek batà ko bayi. Peg-ayas ka bag, aw pemàdi sikandin amon kegolian aw eked kematay.” ");
INSERT INTO mbs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Penga niyan, timaking si Jesus kandin. Ontò medita se doma otaw timaking ki Jesus aw migpesegsegay dan kidoen te dalan. ");
INSERT INTO mbs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nayan, doen heman sebad bayi timaking kandin pigdipenogan te sempolò den teg dowa se omay. ");
INSERT INTO mbs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Medita se doktor migbolong kandin, aw neamin se kedakel te kwarta din. Ontò sikandin ineleg, so pengkey eden se imbolong dan kandin, meneng labi den beling medaet se mesakit din. ");
INSERT INTO mbs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pegdineg din tepad te eg-inangen i Jesus, dimoton sikandin aw migpedapag diyà te getan din aw nemaed te saol din, ");
INSERT INTO mbs_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","so tapay sikandin mig-aneng-aneng te megolì se mesakit din aw pemàdan din olò se saol i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pegketà, negolì se mesakit din, aw mig-imanman sikandin te mèpiya den se lawa din. ");
INSERT INTO mbs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pegketaga-taga i Jesus te doen neinang pineokit te tolos din, miniling sikandin aw timengteng diyà te menge otaw timaking kandin, aw minikagi, “Sinu lay se nemaed te saol ko?” ");
INSERT INTO mbs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Minikagi se menge tinoledaan din, “Ikà eg-insà aw sinu se nemaed kamno, so pigdenganan ka te medita otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Meneng gayed timengteng si Jesus diyà te kedita dan amon kitaen din aw sinu se nemaed kandin. ");
INSERT INTO mbs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nelemitan se bayi sìyan, so netegahan din te negolì den se mesakit din. Yan migpedapag sikandin diyà ki Jesus aw tinegangtang tandà te lamit din. Limongken sikandin diyà ki Jesus aw mig-indan kandin te kedita tepad te mesakit din aw pegkegolì niyan. ");
INSERT INTO mbs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Penga niyan, minikagi si Jesus, “Atà, simalig ka diyà kanak, aw yan se doun te negolian ka. Olì ka den. Mèpiya den se pedowan aw lawa nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Telobo pa minikagi si Jesus diyà te bayi, dimateng se otaw lekat te balay te obanen te simbahan, aw minikagi diyà ki Jairo, “Nematay den se batà nikaw. Wedad den kekemowan te pegpedeleg no te Menenoladà doton te balay nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Meneng wedà segmani i Jesus se inikagi dan. Minikagi sikandin diyà ki Jairo, “Ikà egkepuluk, meneng salig ka diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wedad doma otaw impetaking i Jesus doton te balay, meneng olò si Pedro, aw si Santiago, aw adi i Santiago si Juan. ");
INSERT INTO mbs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pegdateng dan doton te balay i Jairo, kinità i Jesus se menge otaw migbelisì, aw migkelag, aw migmatay tandà te lano dan. ");
INSERT INTO mbs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Peg-awop din diyà te balay, minikagi sikandin, “Ikà niyo egbelisì. Ikà niyo egkelag. Wedà kematay se batà. Olò sikandin timedogi.” ");
INSERT INTO mbs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Meneng nebebeyatan dan si Jesus. Penga niyan, impelowà din se kedita dan, aw dimoton sikandin te tambì inibatan te batà. Impetaking din olò se tinoledaan din aw amay aw inay te batà. ");
INSERT INTO mbs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pinemàdan din se belad te batà, aw minikagi te kagi te Hebreo, “Talita kumi.” (Se kelebadan niyan, “Atà, enaw ka.”) ");
INSERT INTO mbs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pegketà, minenaw sikandin aw migpanaw-panaw, so sempolò den teg dowa se omay din. Ontò nepela se amay aw inay din. ");
INSERT INTO mbs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Meneng ontò migpunù si Jesus te wedad palos otaw mepakay indanan dan tepad te peg-antay din te batà sìyan. Minikagi heman si Jesus te mèpiya aw pemekànen dan se batà. ");
INSERT INTO mbs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nayan, nesayo si Jesus aw minolì doton te kandin lonsod. Timaking heman se menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pegkesebado, migtoladà sikandin doton te simbahan te Judiyo. Nepela se medita otaw dimineg kandin, aw minikagi dan, “Ontò kidon nepela so dakel den se nebatog din. Ontò sikandin biyasa, aw mèpiya heman se kepelahan eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Meneng netegahan tadon te olò sikandin karpintiro, aw si Maria se inay din. Netegahan tadon heman se menge kedowa din si Santiago, si Jose, si Judas, aw si Simon. Eg-ogpà heman se menge etebay din dini kenitadon.” Yan nebensi dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Penga niyan, minikagi sikandin, “Gayed egsegmanen te doma otaw se telekeliwat te kagi te Timanem, meneng kenà sikandin egsegmanen te menge otaw te kandin lonsod aw menge kedowa din.” ");
INSERT INTO mbs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Nepela si Jesus so wedà dan pemenal kandin, aw yan se doun te pilabok se kepelahan ininang din kidoen. Pilabok olò se otaw pinemàdan din aw negolian. Nayan, miglegeb si Jesus doton te kedita te lonsod, aw migtoladà kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Doen sebad aldaw migtipon sikandin te sempolò teg dowa tinoledaan din. Imbegay din diyà kandan se tolos amon megpelowà dan te bosaw lekat te otaw, aw insogò din dan teg dowa-dowa doton te menge doma ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Te wedà dan pa kesayo, doen impunù din kandan te olò bangkà se mepakay dan ibingen. Eked dan pengibing te kànen, aw kelepì, aw kwarta, so togpoan dan te otaw toledaan dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mepakay aw menepatos dan, meneng eked dan pengibing te ekasan. ");
INSERT INTO mbs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Migpunù sikandin, kagi din, “Aw domateng kaw doton te lonsod, ketingen kaw diyà te sebad balay. Ikà niyo eg-alin-alin lamig domeleg kaw doton te doma lonsod. ");
INSERT INTO mbs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aw doen otaw eked pegsagman kenyo, aw eked dan penenalan te itoladà niyo, tektaki niyo se napò te tanà lekat te sepatos niyo te pegkesayo niyo lekat te lonsod dan. Yan metaga-taga se otaw kidoen te doen salà ininang dan, so wedà dan penenalan kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Penga niyan, nesayo dan. Pengkey kenan dan pesalo, migtoladà dan te keilangan megselsel se kedita te otaw te salà ininang dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Medita se bosaw impelowà dan lekat te otaw, aw medita heman se otaw doen mesakit pinetedakan dan te lana aw negolian dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nayan, dimineg se selotan si Herod tepad te ininang i Jesus aw menge tinoledaan din, so ontò nedengeg si Jesus. Doen menge otaw eg-ikagi, “Sikandin besi si Juan Memonyagay neantay den lekat te nematay, aw yan se doun te eg-inangen din se kepelahan metolos.” ");
INSERT INTO mbs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Meneng doen heman menge doma otaw eg-ikagi, “Sikandin se telekeliwat te kagi te Timanem gebii si Elias.” Doen heman menge doma otaw eg-ikagi, “Ontò sikandin telekeliwat te kagi te Timanem, iling te menge telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Meneng pegdineg i Herod tepad te ininang i Jesus, minikagi sikandin, “Sikandin besi si Juan Memonyagay, sìyan impesipal ko se lieg din, meneng neantay besi lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yan se inikagi i Herod, so kedengan impedakep din si Juan, aw impegapos din, aw impekeleboso din. Yan se ininang din ki Juan amon meluba se nayi din si Herodias inagaw din diyà te kedowa din si Felipe. ");
INSERT INTO mbs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Peg-agaw i Herod te nayi din, simila si Juan kandin, kagi din, “Mig-inang ka te salà, so nengagaw ka te nayi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yan se doun te neopal si Herodias diyà ki Juan, aw ibeg din ipeimatay din si Juan. Meneng wedà pekedeleg, ");
INSERT INTO mbs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","so egsagman si Herod ki Juan, so netegahan din te gayed eg-inang si Juan te metòlid, aw wedad salà ininang din. Yan se doun te eked kepakay diyà kandin aw imetayan si Juan. Egkeibeg si Herod domineg te ipegtoladà i Juan, meneng pegdineg din kenyan, ontò migkebulung se aneng-aneng din. ");
INSERT INTO mbs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nayan, mig-inang si Herod te pista tepad te aldaw te pegtebaw din, aw impetanod din se kedita te opisyal, aw kapitan te sondalo, aw otaw meyaman. Yan se aldaw intelegsà i Herodias amon ipeimatay din si Juan. ");
INSERT INTO mbs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pegsayaw te laga batà i Herodias, ontò neluba si Herod aw menge otaw timanod. Penga niyan, minikagi si Herod, “Pemoyoi den se ibeg no diyà kanak pengkey eden, so ibegay ko iyan diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Migsapà si Herod diyà kandin, kagi din, “Pengkey eden se pemoyoen nikaw, yan se ibegay ko kamno, pengkey taman te ketengà te tanà eglowanan ko.” ");
INSERT INTO mbs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Penga niyan, nesayo se laga aw mig-insà diyà te inay din, kagi din, “Eden lay se mèpiya pemoyoen ko?” Minikagi se inay din si Herodias, “Pemoyoi te ipesipal din se lieg i Juan Memonyagay.” ");
INSERT INTO mbs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Penga niyan, ayas limikò se laga doton ki Herod, aw nemoyò, kagi din, “Ibeg ko, ipesipal no se lieg i Juan Memonyagay, aw ipesawol no se olo din diyà te dakel sablag, aw ipeibing no dini kanak te eked kenamay.” ");
INSERT INTO mbs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ontò nelidò se pedowan i Herod. Meneng so migsapà sikandin, aw eked keibeg silahen te menge otaw timanod, eked sikandin tomalis te pakang din diyà te laga. ");
INSERT INTO mbs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yan se doun te wedà sikandin peg-alà-alà, aw insogò din se sondalo mangay te olo i Juan. Penga niyan, dimoton se sondalo te keleboso aw sinipal din se lieg i Juan. ");
INSERT INTO mbs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Insawol din se olo din diyà te sablag, aw imbegay din diyà te laga, aw inibing te laga doton te inay din. ");
INSERT INTO mbs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pegdineg te menge tinoledaan i Juan te inimetayan sikandin, dimoton dan te keleboso, aw inabat dan se lawa din aw inlebeng dan iyan. ");
INSERT INTO mbs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nayan, peg-olì te menge sogounun i Cristo doton kandin, mig-indan dan diyà kandin tepad te kedita te ininang dan aw intoladà dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Penga niyan, minikagi si Jesus, “Tenani niyo se doma otaw, aw taking kaw kanak doton te kesikmihan amon meg-etod kaw te eked kenamay.” Yan se inikagi din, so medita se otaw gayed egdoton kandin, aw kenà egpekekaen si Jesus aw menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Penga niyan, nesayo dan lekat kidoen. Simakay dan te belangay aw dimoton dan te kesikmihan te wedad doma dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nayan, medita se otaw kimità te pegkesayo dan, aw netegahan dan te sikandan si Jesus aw menge tinoledaan din. Yan nesayo dan lekat te medita ogpeanan dan, aw kimagnan dan diyà te kilid te lanaw, aw nekeonà dan dimateng doton te peselowan te belangay sinekayan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pegtenà i Jesus, kinità din se ontò medita otaw migtagad kandin. Ontò din dan neidowan, so iling dan te menge ayam-ayam karniro megketading te eked kenamay aw wedad megdiyaga kandan. Penga niyan, migtoladà si Jesus kandan te medita kebenalan. ");
INSERT INTO mbs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pegkeapon niyan, dimoton se tinoledaan din kandin, aw minikagi dan, “Ontò ini kebigtilan, aw agpet den delem. ");
INSERT INTO mbs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pekeseyowi se kedita te otaw doton te menge lonsod aw kedepagan amon mayad dan te kànen.” ");
INSERT INTO mbs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Meneng minikagi si Jesus, “Pemekàni niyo dan.” Minikagi dan diyà kandin, “Eked day kebatog. Simpana mayad kay te pan botong te ipekaen day kandan, keilangan dakel se kwarta ibayad day kenyan, menge dowa gatos kwarta dinaryo.” ");
INSERT INTO mbs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Minikagi si Jesus, “Tengtengi niyo aw pila se pan inibing niyo.” Pegkità dan, limikò dan doton ki Jesus aw minikagi dan, “Lima olò se pan, aw didowa se ikan.” ");
INSERT INTO mbs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Penga niyan, impeebong-ebong i Jesus se kedita te otaw aw impeonsad din dan kidoen te sagbet. ");
INSERT INTO mbs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Peg-onsad dan, doen menge inebongan teg sebad gatos otaw, aw doen heman menge inebongan teg keliman otaw. ");
INSERT INTO mbs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Penga niyan, inabat i Jesus se lima pan aw didowa ikan. Limengag sikandin doton te langit aw migpesiontong diyà te Timanem kenyan. Penga niyan, binelà-belà din se pan aw imbegay din diyà te menge tinoledaan din amon iteped dan diyà te menge otaw netipon. Impeteped din heman se didowa ikan diyà te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kimaen se kedita dan aw nebesog dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Penga niyan, inimon dan se samà te pan aw ikan kinaen dan, aw sempolò teg dowa se buun nepenò. ");
INSERT INTO mbs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Menge lima melalan se meama kimaen te pan, aw doen heman menge bayi aw mengisù. ");
INSERT INTO mbs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Penga niyan, impeonà i Jesus se menge tinoledaan din simakay te belangay pesalo doton dipag te lanaw, doton te Bitsayda. Dalem niyan, impeolì din se kedita te otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pegkesayo dan, timikedeg si Jesus doton te bontod amon megtawal-tawal. ");
INSERT INTO mbs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pegsallep te aldaw, mediyò den se belangay doton te lawod te lanaw. Meneng si Jesus kidoen pa te bontod olò din sebad. ");
INSERT INTO mbs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kinità din te ontò melima se pegbugsay dan, so simongsong dan te kelamag. Ontò mata-mata te iselem, dimoton si Jesus kandan aw minipanaw sikandin diyà te lanto te lanaw. Ibeg din mekesaeb kandan. ");
INSERT INTO mbs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Meneng pegkità dan kandin, eden dan aw along sikandin, so minipanaw sikandin diyà te lanto te lanaw. Migpuypuy dan, ");
INSERT INTO mbs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","so kimità se kedita dan kandin, aw ontò dan nelemitan. Meneng pegketà timawal si Jesus, kagi din, “Peseligi niyo se pedowan niyo, so siaken ini. Ikà niyo egkelemitan.” ");
INSERT INTO mbs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Penga niyan, eleg simakay si Jesus te belangay, aw timunung se kelamag. Ontò dan nepela, ");
INSERT INTO mbs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","so pengkey kinità dan se kepelahan ininang i Jesus diyà te pan aw ikan, meneng wedà dan pa ketegahi te doen tolos din, so magsen se olo dan. ");
INSERT INTO mbs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nayan, penga te pegbatas dan te lanaw, dimateng dan doton te Genesarit, aw migpondo dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pegtenà dan, kimilala se menge otaw ki Jesus, ");
INSERT INTO mbs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aw ayas dan inangay se kedita te otaw doen mesakit lekat te kedepagan niyan. Tiningga dan se otaw aw dimoton dan te pengkey kenan ekon si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pengkey doton te lonsod aw mediyò te lonsod, pengkey kenan pesalo si Jesus, inibing dan se otaw doen mesakit doton te pedyanan, aw nemoyò dan diyà ki Jesus aw mepakay dan olò memaed te toktok te saol din, aw negolian se kedita dan nemaed kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nayan, doen menge Parisiyo aw menenoladà te punù ingkeliwat i Moises dimoton ki Jesus lekat te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kinità dan te limàpang se menge tinoledaan i Jesus te ketanem te menge Parisiyo, so kimaen dan te wedà dan peg-onaw te belad dan. ");
INSERT INTO mbs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Doen ketanem te Parisiyo aw kedita te doma dan Judiyo te eked dan kaen singed aw onà dan onawan se belad dan iling te ketanem intoladà te kemonaan dan kandan. ");
INSERT INTO mbs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aw molì dan lekat te pedyanan, linisan dan se lawa dan te eked dan pa kaen. Medita heman se doma ketanem egtekingan dan tepad te pegligaw te baso, aw keldiro, aw telepagan ininang te kinis, aw katri. ");
INSERT INTO mbs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Minikagi se menge Parisiyo aw menenoladà te punù ingkeliwat i Moises, “Kenà egtaking se menge tinoledaan no te ketanem te kemonaan tadon, so kimaen dan te wedà dan peg-onaw te belad dan.” ");
INSERT INTO mbs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Minikagi si Jesus, “Eden niyo aw egpenimanem kaw. Sikiyo se tinedoan te kagi te Timanem ingkeliwat i Isaias gebii, ‘Pengkey eg-ikagi se otaw sìyan te egtaking dan kanak, meneng wedà kelobos se pedowan dan kanak. ");
INSERT INTO mbs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wedad ontong te pegsimba dan kanak, so se ketanem te otaw ipegtoladà dan, yan se ininang dan punù te Timanem.’ ");
INSERT INTO mbs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Limengà kaw den te pegtolò niyo te punù te Timanem, aw gayed kaw egtaking te ketanem te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Minikagi heman si Jesus diyà kandan, “Ontò kaw biyasa egtinàyog te punù te Timanem amon gayed kaw tomaking te ketanem niyo. ");
INSERT INTO mbs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Migpunù si Moises, ‘Keilangan segmanen no se amay aw inay nikaw.’ Migpunù heman sikandin, ‘Keilangan imetayan se otaw megtindaet te amay aw inay din.’ ");
INSERT INTO mbs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Meneng egtoladà kaw te mepakay aw eked pegsagman se otaw te amay aw inay din aw olò mikagi diyà kandan, ‘Se itabang ko peden kenyo, yan se ininang ko corban, so imbegay ko den iyan diyà te Timanem.’ ");
INSERT INTO mbs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yan segdahen niyo se pegtabang din te amay aw inay din. ");
INSERT INTO mbs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pineokit te pegtaking niyo te menge ketanem egkeliwaten niyo, timinàyog kaw te kagi te Timanem te keilangan segmanen niyo se amay aw inay niyo. Medaet heman se menge doma eg-inangen niyo.” ");
INSERT INTO mbs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nayan, medita se otaw netipon kidoen, aw timawal si Jesus diyà kandan amon megpedapag dan diyà kandin. Minikagi sikandin, “Penenalan kaw kanak se kedita niyo amon mekelabet kaw kani. ");
INSERT INTO mbs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kenà egpekesalà se otaw pineokit te iawop din diyà te bahà din. Meneng egpekesalà se otaw pineokit te lomowà lekat te bahà din.  ");
INSERT INTO mbs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Penga niyan, nesayo si Jesus lekat kidoen te otaw netipon, aw minawop diyà te balay. Timaking se menge tinoledaan din aw mig-insà dan kandin tepad te tegdeyanan sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Minikagi si Jesus, “Nepela a so iling kaw heman te doma otaw wedà pekelabet. Pengkey eden se kànen iawop diyà te bahà te otaw, kenà egpekesalà se otaw pineokit kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eked deleg se kànen doton te pedowan din, meneng domeleg iyan doton te getek, aw penga niyan lomowà lekat te lawa.” Pineokit te sìyan kagi i Jesus, netegahan tadon den te mepakay aw komaen kidon te pengkey eden kemoloi te kànen. ");
INSERT INTO mbs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Minikagi heman si Jesus, “Meneng se kagi lomowà lekat te bahà te otaw, yan se doun te egpekesalà se otaw. ");
INSERT INTO mbs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Didalem te pedowan se kelekatan te medaet ibeg te otaw eglayok te kenà kandan esawa, aw egpenakaw, aw egbonò, aw eglakad, ");
INSERT INTO mbs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aw egkeibeg te kedònan te doma, aw eg-inang te medaet, aw eg-akal, aw wedad yàyà metibayi, aw eg-ingà, aw egbaet-baet, aw egpelangkaw-langkaw, aw wedad inenengen. ");
INSERT INTO mbs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lekat didalem te pedowan se kedita te medaet sìyan, aw egpekesalà se otaw eg-inang kenyan.” ");
INSERT INTO mbs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Timindeg si Jesus aw nesayo lekat kidoen, aw dimoton te probinsya medapag te lonsod te Tiro aw Sidon. Pegdateng din doton, mig-ogpà sikandin diyà te balay kidoen. Pengkey ibeg din wedad metaga-taga aw kenan sikandin, meneng wedà sikandin pekeeles. ");
INSERT INTO mbs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Doen batà bayi dinetengan te bosaw, aw dinineg te inay din te dimateng si Jesus. Yan dimoton se inay te batà sìyan aw limongken diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kenà sikandin Judiyo, so eg-ikagi te Griego aw timebaw doton te Fenisya sakop te probinsya te Sirya. Nemoyò sikandin te ipelowà i Jesus se bosaw lekat te batà din. ");
INSERT INTO mbs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Meneng mig-indan si Jesus te tegdeyanan amon metaga-taga se bayi te olò menge Judiyo se tebangan din, kagi din, “Keilangan onà ipekaen te otaw se menge batà din, so eked kepakay aw ebaten din se kànen te menge batà din amon ibegay din diyà te menge toyang.” ");
INSERT INTO mbs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Minikagi se bayi, “Sir, benal iyan. Meneng mepakay aw komaen se toyang te momò medagdag lekat te kinaen te menge batà.” ");
INSERT INTO mbs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Minikagi si Jesus, “Tandà te inikagi no sìyan, mepakay aw molì ka den, so limowà den se bosaw lekat te batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Peg-olì te bayi sìyan, kinità din se batà din minibat, aw wedad den bosaw diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nayan, nesayo si Jesus lekat te lonsod te Tiro, aw minokit doton te lonsod te Sidon aw kedepagan te Dikapolis lamig dimateng doton te lanaw te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pegdateng din doton, doen otaw inibing doton kandin bingelen aw kenà egkelitok se kagi din. Nemoyò se menge doma din te pemàdan i Jesus amon kegolian. ");
INSERT INTO mbs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Penga niyan, inibing sikandin i Jesus doton te keligbinan, aw inloglog din se intetodò din diyà te telinga te otaw bingelen, aw inelem din se intetodò din te ngingi aw pinemàdan din se dilà te otaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Penga niyan, limengag sikandin doton te langit aw migpedo-pedo tandà te keido din, aw minikagi, “Efata.” (Se kelebadan niyan, “Keowang ka den.”) ");
INSERT INTO mbs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pegketà, nekedineg se otaw sìyan, aw migkèpiya se dilà din aw nelitok se kagi din. ");
INSERT INTO mbs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Penga niyan, migpunù si Jesus te keilangan eked dan indani diyà te doma otaw tepad te kepelahan sìyan. Pengkey ontò sikandin migpunù, meneng labi dan pa mig-indan kenyan diyà te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ontò dan nepela, aw minikagi dan, “Ontò mèpiya se kedita te ininang din, so pengkey bingelen impedineg din, aw omo impeikagi din.” ");
INSERT INTO mbs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nayan, wedà kenamay, ontò medita se otaw netipon diyà ki Jesus. Pegkewedad te kànen dan, tinawal i Jesus se menge tinoledaan din, aw minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Neidowan ko den se menge otaw seini, so netelowan den dan timaking kanak, aw wedad den kànen dan. ");
INSERT INTO mbs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Simpana ipeolì ko dan te binallos dan pa, metapì dan kidoen te dalan, so mediyò se ogpeanan te keditaan dan.” ");
INSERT INTO mbs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Minikagi se tinoledaan din, “Meneng kebigtilan ini, aw wedad palos ebatan tadon te pan amon ipekaen tadon kandan.” ");
INSERT INTO mbs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mig-insà si Jesus, “Pila lay se pan inibing niyo?” Timaba dan, “Pito olò.” ");
INSERT INTO mbs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Penga niyan, impeonsad din se kedita te otaw diyà te tanà. Inabat din se pito pan, aw migpesiontong diyà te Timanem kenyan. Binelà-belà din iyan, aw imbegay din diyà te menge tinoledaan din, aw inteped dan diyà te menge otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Doen heman pilabok ikan dedeitek. Migpesiontong heman si Jesus diyà te Timanem kenyan, aw impeteped din heman iyan diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kimaen se kedita dan aw nebesog dan. Penga niyan, inimon dan se samà te pan kinaen dan, aw pito se boliyas nepenò. ");
INSERT INTO mbs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Menge epat melalan se otaw kimaen kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Penga niyan, impeolì i Jesus se kedita dan, aw simakay sikandin te belangay doma te menge tinoledaan din, aw dimoton dan te probinsya medapag te Dalmanota. ");
INSERT INTO mbs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nayan, doen menge Parisiyo dimoton ki Jesus. Megdindil dan peden kandin. Ibeg dan megtandà dan kandin, aw yan se doun te nemoyò dan te ipekità din diyà kandan se pengilala amon ketegahan dan te ontò sikandin insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ontò migpedo-pedo si Jesus tandà te puluk din, aw minikagi sikandin, “Wedad kekemowan te pegpekità ko kenyo te pengilala. Eneng-enengi niyo se kagi ko seini. Wedad palos pengilala ipekità te Timanem diyà kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Penga niyan, nesayo si Jesus lekat kidoen, aw simakay te belangay pesalo doton dipag te lanaw. ");
INSERT INTO mbs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nayan, pegbatas dan te lanaw, wedad pan inibing te menge tinoledaan i Jesus, so nelibelan dan se bawo dan. Meneng doen sebad olò pan kidoen te belangay. ");
INSERT INTO mbs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Migpunù si Jesus kandan, kagi din, “Peg-ahà kaw amon eked kaw ketini te yist te menge Parisiyo aw si Herod.” ");
INSERT INTO mbs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Migpebelaw-belaway se menge tinoledaan din, kagi dan, “Yan se inikagi din so wedad pan inibing tadon.” ");
INSERT INTO mbs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Meneng netegahan i Jesus aw eden se aneng-aneng dan, aw minikagi sikandin, “Tay law. Ikà niyo egkepela so wedad pan inibing niyo. Nepela a kenyo, so wedà niyo pa kelebeti se inikagi ko gina diyà kenyo. Magsen pa se olo niyo. ");
INSERT INTO mbs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pengkey doen mata niyo, wedà kaw pa kità te kebenalan. Pengkey doen telinga niyo, wedà kaw pa penenalan. Iling te nelibelan niyo se kepelahan ininang ko. ");
INSERT INTO mbs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pegpekaen ko te lima melalan otaw te lima pan, pila lay buun se inipenò niyo te samà?” Timaba dan, “Sempolò teg dowa.” ");
INSERT INTO mbs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mig-insà heman si Jesus, “Pegpekaen ko te epat melalan otaw te pito pan, pila lay boliyas se inipenò niyo te samà?” Timaba dan, “Pito.” ");
INSERT INTO mbs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Minikagi si Jesus, “Aw wedà niyo iyan kelibeli, nepela a so wedà niyo pa kelebeti se inikagi ko gina diyà kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nayan, dimoton si Jesus aw menge tinoledaan din te Bitsayda. Doen menge otaw nengibing te otaw bota doton ki Jesus, aw nemoyò dan te pemàdan din sikandin amon kegolian. ");
INSERT INTO mbs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Minawid si Jesus te belad te otaw bota, aw inagak din doton te lowà te lonsod. Penga niyan, migsawol sikandin te ngingi diyà te mata te bota, aw nemaed kandin, aw mig-insà, “Doen lay den kinità nikaw?” ");
INSERT INTO mbs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Timengteng se otaw aw minikagi, “Ee. Meneng kenà metaen so iling te lawa te kayo se bawa te otaw kinità ko migpanaw-panaw.” ");
INSERT INTO mbs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Todà nemaed si Jesus te mata din. Penga niyan, ontò timengteng se otaw sìyan aw kinità din se otaw ontò metaen, so migkèpiya den se mata din. ");
INSERT INTO mbs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Penga niyan, impeolì sikandin i Jesus, kagi din, “Ikà eg-apit pengkey doton te lonsod.” ");
INSERT INTO mbs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nayan, dimeleg si Jesus aw menge tinoledaan din pesalo doton te lonsod te Sesarya Filipos. Peg-ipanaw dan, mig-insà si Jesus diyà kandan, kagi din, “Eden lay se kagi te kedita te otaw tepad kanak? Sinu a lay ekon?” ");
INSERT INTO mbs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Timaba dan, “Doen menge otaw eg-ikagi te sikona si Juan Memonyagay. Doen heman eg-ikagi te sikona si Elias. Doen heman eg-ikagi te sikona se doma telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mig-insà si Jesus, “Meneng eden lay se kenyo aneng-aneng tepad kanak? Sinu a lay?” Timaba si Pedro, kagi din, “Sikona se Misiyas insogò te Timanem dini kenami.” ");
INSERT INTO mbs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Penga niyan, migpunù si Jesus te keilangan eked dan indani diyà te doma otaw tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nayan, migtoladà si Jesus diyà te menge tinoledaan din aw eden se metoman domateng diyà kandin Timanem Migpekeotaw. Ontò sikandin elegen, aw kuluwan sikandin te menge obanen te Judiyo aw menge pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises. Metoman sikandin imetayan, meneng penga niyan te telo se aldaw, meantay sikandin lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ontò nebangal se intoladà din kandan. Penga niyan, migpedapag si Pedro diyà ki Jesus, aw minikagi diyà kandin te eked kepakay aw metoman iyan domateng diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Meneng timengteng si Jesus diyà te menge tinoledaan din aw ontò minikagi diyà ki Pedro, kagi din, “Kesayo ka lekat kanak. Iling ka ki Satanas, so kenà lekat te Timanem se ibeg no sìyan, meneng lekat iyan te aneng-aneng nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Penga niyan, tinawal i Jesus se menge tinoledaan din sipat kedita te doma otaw netipon kidoen. Minikagi sikandin, “Aw meibeg se otaw tomaking kanak, keilangan megsagda sikandin te ibeg te pedowan din, aw tomayod te kelimahan te kelikit te aldaw pengkey imetayan sikandin, aw keilangan ontò tomaking kanak. ");
INSERT INTO mbs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pengkey ibeg te otaw megkelayat se omol din dini te keneyonan, meneng kunù din gayed matay. Meneng aw mepakay diyà te otaw pengkey imetayan sikandin tandà te pegtaking din kanak aw pegtoladà din te Mèpiya Indan tepad kanak, begayan sikandin te kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","So simpana tig-epoen te otaw se kedakel te keneyonan, aw penga niyan matay sikandin aw ipelumun doton te kilot, wedad ontong din, ");
INSERT INTO mbs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","so eked kebeyadi se kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aw eked ikagi se otaw te sikandin se sakop ko, aw eked heman tolò te kagi ko meneng tomaking te otaw nelegeb te salà egtinàyog te Timanem, yan se otaw eked ko heman ikegihi te sikandin se sakop ko te peglikò ko. Siak se Timanem Migpekeotaw, aw lomikò a pa dini tekingan te kelangkaw te Amay ko aw sipat menge anghil te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Minikagi heman si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Doen otaw dini kenyo eked kematay singed aw onà dan komità te pegtebò te peglowan te Timanem metolos.” ");
INSERT INTO mbs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nayan, pegkeokit te enem se aldaw, impetaking i Jesus si Pedro, si Santiago, aw si Juan, aw timikedeg dan doton te melangkaw bontod te wedad doma dan. Pegketà, dalem te pegtengteng dan diyà ki Jesus, netodà se bawa din. ");
INSERT INTO mbs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ontò migkepotì se kedakel te penenaktun din so ontò minanyag. Eked keinang iling kenyan se penenaktun bugsakan dini te tanà, so ontò mepotì. ");
INSERT INTO mbs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Penga niyan, kinità dan heman si Elias aw si Moises migbalaw-balaw doma ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Minikagi si Pedro diyà ki Jesus, “Pengolo, mèpiya so dini kay. Ibeg day meg-inang kay den te telo balay amon doen ogpaan te teg sebad-sebad kenyo si Moises aw si Elias.” ");
INSERT INTO mbs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pengkey yan se inikagi i Pedro, meneng wedà din kelebeti aw eden se inikagi din, so ontò dan nelemitan. ");
INSERT INTO mbs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Penga niyan, doen labon dimateng diyà kandan, aw wedà dan ebey kità kandan. Penga niyan, dinineg dan se kagi te Timanem lekat te labon, “Seini se Batà ko aw ontò dakel se pedowan ko kandin. Keilangan sikandin se penenelanen niyo.” ");
INSERT INTO mbs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wedà kenamay, timengteng dan aw kinità dan olò si Jesus wedad den doma din. ");
INSERT INTO mbs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pegtopang dan lekat te bontod, ontò migpunù si Jesus diyà kandan te eked kepakay aw indanan dan se doma otaw tepad te kinità dan singed aw meantay sikandin Timanem Migpekeotaw lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Timolò dan te punù din sìyan. Meneng gayed dan migpeinsaay aw eden se kedegdagan te inikagi din tepad te pegkeantay din lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Penga niyan, mig-insà dan diyà kandin, “Aw agpet ka den lomowan, nengà lay egtoladà se menge menenoladà te punù ingkeliwat i Moises te keilangan domateng si Elias te eked pa lowan se Misiyas?” ");
INSERT INTO mbs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Timaba si Jesus, “Benal domateng onà si Elias amon megpeketagad te kedita. Meneng eneng-enengi niyo heman te doen kagi te Timanem insolat tepad kanak Timanem Migpekeotaw te ontò a elegen aw kebebeyatan a. ");
INSERT INTO mbs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Meneng mikagi a den diyà kenyo te dimateng den si Elias, aw medaet se ininang te doma otaw diyà kandin, aw yan se pegketoman te pakang insolat tepad kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pegdateng dan doton te menge doma tinoledaan i Jesus, kinità dan te ontò medita se otaw netipon diyà kandan, aw doen menge menenoladà te punù ingkeliwat i Moises migbalaw-balaw kandan. ");
INSERT INTO mbs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pegkità te kedita te otaw ki Jesus, ontò dan nepela, aw kimagnan dan aw simongon dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mig-insà si Jesus, kagi din, “Eden lay se imbalaw-balaw niyo kandan?” ");
INSERT INTO mbs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Timaba se sebad otaw, “Sir, inibing ko se batà ko amon megtabang ka kandin, so egdetengan sikandin te bosaw migpeomo kandin. ");
INSERT INTO mbs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aw egdateng iyan kandin, egpekelias, aw egbohak se bahà din, aw egyangget-yangget se ngipen, aw egkeseg se lawa din. Nemoyò a diyà te menge tinoledaan no te ipelowà dan se bosaw lekat kandin, meneng wedà dan iyan kebatog.” ");
INSERT INTO mbs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Minikagi si Jesus, “Tay law, sikiyo menge otaw. Wedà kaw pa salig kanak. Eked den kenamay se pegdoma ko kenyo, meneng keilangan tomayod a pa pengkey eked kaw pemenal. Na, pedinihi se batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Penga niyan, inibing dan se batà. Meneng pegkità te bosaw ki Jesus, impekeseg te bosaw se batà, aw impelias aw impebolaling sikandin, aw migbohak se bahà din. ");
INSERT INTO mbs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mig-insà si Jesus diyà te amay din, “Kano lay ini pegtebò?” Timaba se amay din, “Lekat pa te deitek sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Melikit sikandin eg-elosen te bosaw diyà te apoy, aw eglemesen heman diyà te wayeg amon imetayan sikandin. Meneng aw mebatog nikaw, keidowi kay bag aw tebangi kay.” ");
INSERT INTO mbs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Minikagi si Jesus, “Nepela a so egdowa-dowa ka te mebatog ko. Wedad palos eked kebatog te Timanem megtabang te otaw somalig diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Minikagi se otaw te dakel se kagi din, “Simalig a den diyà te Timanem. Lobosi se pegsalig ko diyà kandin amon eked a pegdowa-dowa.” ");
INSERT INTO mbs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pegkità i Jesus te labi pa medita se otaw netipon, sinagda din se bosaw, kagi din, “Sikona bosaw migpeomo aw migpebingel kandin, lowà ka den lekat kandin, aw ikà palos eglikò diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Penga niyan, migpuypuy se bosaw, aw ontò din impekeseg se batà, aw penga niyan limowà. Iling te wedad pedowan te batà, aw minikagi se keditaan te otaw, “Nematay den sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Meneng inewidan i Jesus se belad din aw impeenaw din, aw yan neketindeg. ");
INSERT INTO mbs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Peg-olì i Jesus aw menge tinoledaan din, dimoton dan kandin te wedad doma dan, aw mig-insà dan, “Nengà lay wedà day kebatog se pegpelowà te bosaw lekat kandin?” ");
INSERT INTO mbs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Minikagi si Jesus, “Wedà niyo iyan kebatog so eked pelowai se kemolò te bosaw seini singed aw megtawal-tawal kaw.” ");
INSERT INTO mbs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nayan, nesayo si Jesus aw menge tinoledaan din lekat kidoen, aw minokit dan te probinsya te Galiliya. Meneng ibeg i Jesus, wedad metaga-taga aw kenan sikandin, ");
INSERT INTO mbs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","amon eked keanggà se pegtoladà din te menge tinoledaan din. Minikagi sikandin, “Seini se metoman domateng diyà kanak Timanem Migpekeotaw. Metoman a itolok aw ibegay a diyà te belad te doma otaw. Penga niyan, imetayan a dan, meneng penga te telo se aldaw, meantay a lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Meneng wedà dan ketegahi aw eden se kedegdagan te inikagi din sìyan, meneng wedad mig-insà kandin tepad kenyan, so neyàyà dan. ");
INSERT INTO mbs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nayan, pegdateng i Jesus aw menge tinoledaan din doton te Kapirnaom, mig-ogpà dan diyà te balay. Mig-insà si Jesus, “Eden lay se pigdindilan niyo gina kidoen te dalan te wedà kidon pa dateng dini?” ");
INSERT INTO mbs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Meneng wedad timaba, so migpedindilay dan aw sinu se ontò melangkaw diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Penga niyan, nenenoo si Jesus aw tinawal din se kedita te sempolò teg dowa dan, aw minikagi sikandin, “Aw meibeg se otaw megkelangkaw, keilangan megpedanà sikandin te pegkeotawun din iling te kedanà te allang.” ");
INSERT INTO mbs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Penga niyan, tinawal i Jesus se sebad batà, aw impetindeg din iyan kidoen te tengà-tengà dan. Penga niyan, inolid din, aw minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aw megsagman se otaw te sakop ko iling te kedanà te sebad batà seini tandà te pegpesakop din kanak, pineokit kenyan segmanen a din heman. Aw megsagman se otaw kanak, kenà olò siaken se segmanen din, so segmanen din heman se Amay ko simogò kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nayan, minikagi si Juan diyà ki Jesus, “Sir, doen otaw kinità day migpelowà te bosaw lekat te menge otaw pineokit te ngadan nikaw. Meneng sinagda day sikandin so wedà pekeakop diyà kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Meneng minikagi si Jesus, “Ikà niyo egsagda kandin, so aw meg-inang se otaw te kepelahan pineokit te ngadan ko, eked tagmon ikagi te medaet tepad kanak. ");
INSERT INTO mbs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Se otaw kenà poon tadon, meinang sikandin doma tadon. ");
INSERT INTO mbs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eneng-enengi niyo se kagi ko kenyo seini. Aw melao kaw, aw doen otaw memegay kenyo te wayeg tandà te pegpesakop niyo diyà kanak, begayan sikandin te Timanem te ontong.” ");
INSERT INTO mbs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Minikagi heman si Jesus, “Aw doen otaw mekebaet te pegpemenal te mengisù egkeidowan ko, ontò medaet se pelumun domateng diyà kandin. Labi pa mèpiya aw iketan se lieg din te dakel bato aw idagdag doton te lawod. ");
INSERT INTO mbs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Aw meboyo kaw meg-inang te salà pineokit te belad niyo, mèpiya aw tokongen niyo se belad niyo amon eked kaw peg-inang te salà, aw amon kominawà kaw te kaling pedowan wedad temanan. Labi pa medaet aw meboyo kaw pineokit te belad niyo, aw iagbel se kedakel te lawa niyo doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Aw meboyo kaw heman meg-inang te salà pineokit te benis niyo, mèpiya aw tokongen niyo se benis sìyan amon eked kaw peg-inang te salà, aw amon kominawà kaw te kaling pedowan wedad temanan. Labi pa medaet aw meboyo kaw pineokit te benis niyo, aw iagbel se kedakel te lawa niyo doton te kilot. ");
INSERT INTO mbs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aw meboyo kaw heman meg-inang te salà pineokit te mata niyo, mèpiya aw logiten niyo se mata niyo amon eked kaw peg-inang te salà aw amon sekopen kaw te Timanem diyà te peglowan din. Labi pa medaet aw meboyo kaw pineokit te mata niyo, aw iagbel se kedakel te lawa niyo doton te kilot, ");
INSERT INTO mbs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","so eked palos kematay se sapat kidoen, aw eked palos heman kepadeng se apoy, ");
INSERT INTO mbs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","so doen apoy medagdag diyà te kedita dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nayan, isanged se asin diyà te kànen amon megkèpiya se nanam. Meneng aw megkewedad se kepait te asin, eked iyan ketodà. Keilangan ontò mèpiya se eg-inangen niyo amon meinang kaw iling te mèpiya kemolò te asin eked pegkewedad se kepait niyan. Keilangan eked kaw heman pegpedindilay.” ");
INSERT INTO mbs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nayan, nesayo si Jesus lekat kidoen aw dimoton dipag te wayeg te Jordan taman te probinsya te Judiya. Medita heman se otaw netipon diyà kandin, aw migtoladà heman sikandin kandan, so yan se gayed din eg-inangen. ");
INSERT INTO mbs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Doen menge Parisiyo nengemahà te kemalì diyà te pegtoladà i Jesus amon doen idimanda dan tepad kandin. Dimoton dan kandin aw minikagi dan, “Mepakay lay aw somibwan se otaw te esawa din?” ");
INSERT INTO mbs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Timaba si Jesus, “Eden lay se impunù i Moises tepad te pegsibwan?” ");
INSERT INTO mbs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Minikagi dan, “Migpunù si Moises te mepakay aw ibegay te meama se papil diyà te bayi tepad te pegsibwan din, aw penga niyan ipekesayo din.” ");
INSERT INTO mbs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Meneng minikagi si Jesus, “Migpunù si Moises te mepakay aw somibwan kaw te esawa niyo, so netegahan din te ontò magsen se olo niyo. ");
INSERT INTO mbs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Meneng gebii te peg-inang te Timanem te otaw, sebad olò se meama ininang din aw sebad olò heman se bayi. ");
INSERT INTO mbs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yan se doun te tomanan se meama te amay aw inay din, aw megsebad diyà te esawa din. ");
INSERT INTO mbs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Se didowa dan meinang sebad. Yan kenà didowa se teleesawa, so neinang dan sebad. ");
INSERT INTO mbs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nayan, so ininang dan te Timanem sebad, eked kepakay aw ipesoway dan te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Peg-olì i Jesus doton te balay, todà mig-insà se menge tinoledaan din tepad te pegpesibwanay. ");
INSERT INTO mbs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Minikagi si Jesus, “Aw somibwan se meama te esawa din aw todà mengognan, mekelakad sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aw somibwan se bayi te esawa din aw todà mengognan, mekelakad sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nayan, doen menge otaw nengibing te dedeitek mengisù doton ki Jesus amon pemàdan din dan aw megtawal-tawal te begayan dan te Timanem te mèpiya. Sinagda dan te menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Meneng pegkità i Jesus kenyan, neopal sikandin aw minikagi, “Ikà niyo egsagda kandan, so lomowan se Timanem diyà te otaw ontò somalig diyà kandin iling te pegsalig te mengisù diyà te amay aw inay dan. ");
INSERT INTO mbs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eneng-enengi niyo se kagi ko kenyo seini. Aw eked salig se otaw diyà te Timanem iling te pegsalig te mengisù diyà te amay dan, eked sikandin sekopi te Timanem diyà te peglowan din.” ");
INSERT INTO mbs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Penga niyan, inolid i Jesus se menge mengisù, aw nemaed sikandin kandan aw migtawal-tawal tepad kandan. ");
INSERT INTO mbs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nayan, pegkesayo i Jesus lekat kidoen, doen sebad otaw kimagnan doton kandin, aw limongken diyà kandin, aw mig-insà, kagi din, “Sir, ontò ka mèpiya otaw. Eden lay se keilangan inangen ko amon mekinawà ko se kaling pedowan wedad temanan?” ");
INSERT INTO mbs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Minikagi si Jesus, “Nepela a so minikagi ka te mèpiya a otaw. Meneng wedad otaw ontò mèpiya, so olò Timanem se ontò mèpiya. ");
INSERT INTO mbs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Netegahan no besi se menge punù ingkeliwat i Moises. Ikà egbonò. Ikà eglakad. Ikà egpenakaw. Ikà egkebolalaw tepad te doma otaw. Ikà eglegawa. Keilangan memasa ka te amay aw inay nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Timaba se otaw sìyan, “Sir, gayed ko egtoloen se kedita niyan lekat te pegkebatà ko lamig seini.” ");
INSERT INTO mbs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Timengteng si Jesus diyà kandin, aw dakel se pedowan din kandin. Minikagi sikandin, “Sebad mendad se keilangan inangen nikaw. Olì ka den aw beligyai se kedakel te kedònan no, aw begayi se kwarta no diyà te menge otaw nelimahan. Aw yan se inangen no, doen ontong kinewaen no doton te langit. Penga te pegpemegay no te kedakel niyan, likò ka dini aw taking ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pegdineg din kenyan, timàmod sikandin aw nesayo te nepuluk se pedowan din, so ontò dakel se kedònan din. ");
INSERT INTO mbs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Penga niyan, timengteng si Jesus diyà te menge tinoledaan din aw minikagi, “Ontò melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nepela se menge tinoledaan din tandà te inikagi din sìyan. Meneng minikagi heman si Jesus, “Ontò melima se pegpesakop te otaw diyà te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pengkey ontò melima se peg-okit te ayam-ayam kamilo diyà te awang te dagem, meneng labi pa melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pegdineg dan kenyan, ontò dan nepela, aw minikagi dan, “Aw iling kenyan, wedad palos otaw mekelowà lekat te pelumun te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Meneng timengteng si Jesus diyà kandan aw minikagi, “Pengkey eked pekelowà se otaw lekat te pelumun te Timanem, meneng mebatog ipelowà te Timanem se otaw lekat te pelumun, so wedad palos eked kebatog te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Penga niyan, minikagi si Pedro, “Meneng sikami, tinenanan day den se kedakel amon tomaking kay kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Minikagi si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Se otaw timanan den te kedònan din, aw kedowa din, aw amay din aw inay din, aw batà din, aw pawà din, amon tomaking kanak aw amon megtoladà te menge doma otaw tepad te Mèpiya Indan, ");
INSERT INTO mbs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yan se metoman kominawà te ontong ginatos pa meelagà diyà te tinenanan din dalem te eked pa kematay. Pengkey egpemilangen sikandin, meneng metoman sikandin begayan te menge kedònan, aw kedowa, aw inay, aw batà, aw pawà, aw begayan heman sikandin te kaling pedowan wedad temanan te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Meneng medita se otaw melangkaw songkani meinang ontò medanà doton te peglowan te Timanem. Medita heman se otaw medanà songkani, meneng meinang dan kwani melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nayan, minipanaw si Jesus aw menge tinoledaan din pesalo doton te Jerusalem. Pegpesalo dan doton, minipanaw si Jesus diyà te monà dan. Nepela se menge tinoledaan din te ibeg din domoton te Jerusalem. Doen heman menge otaw timaking kandin nelemitan. Meneng migtipon si Jesus te sìyan sempolò teg dowa tinoledaan din, aw mig-indan diyà kandan aw eden se metoman domateng diyà kandin, ");
INSERT INTO mbs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","kagi din, “Na, domoton kidon den te Jerusalem. Penga niyan, siak Timanem Migpekeotaw se itolok, aw ibegay a diyà te belad te menge pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises. Megsebad dan mikagi te keilangan imetayan a. Ibegay a dan heman diyà te belad te menge otaw kenà Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kebebeyatan a dan, aw teptepan a dan, aw bedasen a dan, aw penga niyan imetayan a dan. Penga te telo se aldaw, meantay a lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Penga niyan, dimoton ki Jesus se didowa batà i Sebedeo si Santiago aw si Juan. Minikagi dan, “Sir, ibeg day inangen no diyà kenami se pemoyoen day diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Minikagi si Jesus, “Eden lay se ibeg niyo inangen ko diyà kenyo?” ");
INSERT INTO mbs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Minikagi dan, “Aw megtebò ka lomowan, peonsadi kay bag diyà te tangkil nikaw, sebad lenged te kowanan, aw sebad lenged te bibang, amon segmanen kay heman doma nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Meneng minikagi si Jesus, “Wedà niyo ketegahi aw eden se kebegat te pinemoyò niyo. Meketayod kaw lay heman te kelimahan agpet den domateng kanak? Meketayod kaw lay heman te kegemakan agpet den domateng kanak?” ");
INSERT INTO mbs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Timaba dan, “Ee, meketayod kay heman kenyan.” Minikagi si Jesus, “Metoman kaw heman detengan te kelimahan aw kegemakan domateng kanak, ");
INSERT INTO mbs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","meneng eked a pegpakang kenyo te sikiyo se meketangkil diyà kanak, so tomangkil diyà kanak se otaw tapay pinemallì.” ");
INSERT INTO mbs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pegdineg te sempolò tinoledaan aw eden se inikagi dan diyà ki Jesus, neopal dan diyà ki Santiago aw si Juan. ");
INSERT INTO mbs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Meneng tinawal dan i Jesus aw minikagi sikandin, “Netegahan niyo den aw eden se eg-inangen te menge otaw eglowan. Gayed dan egleges te menge sakop dan. Gayed heman egsogò-sogò se menge melangkaw otaw te menge sakop dan. ");
INSERT INTO mbs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Meneng eked kepakay aw meg-iling kaw kandan. Aw doen otaw diyà kenyo meibeg megkelangkaw, keilangan gayed sikandin menabang kenyo. ");
INSERT INTO mbs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aw doen otaw diyà kenyo meibeg megkelangkaw, keilangan megpedanà sikandin te kandin pegkeotawun iling te kedanà te allang. ");
INSERT INTO mbs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Keilangan meg-iling sikandin kanak Timanem Migpekeotaw, so dimini a te tanà kenà amon tebangan a te otaw, meneng dimini a amon menabang a te otaw. Neketagad a den imetayan amon medita se otaw mekelowà lekat te pegkeallang dan diyà te salà.” ");
INSERT INTO mbs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nayan, minokit si Jesus aw menge tinoledaan din diyà te lonsod te Jeriko. Ontò medita se doma otaw timaking kandan. Pegkesayo dan lekat te Jeriko, doen otaw bota nenenoo doton te kilid te dalan, ngadan din si Bartimeo batà i Timeo. ");
INSERT INTO mbs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pegdineg din te si Jesus tege Nasarit se minokit kidoen, timawal sikandin, kagi din, “Jesus, bowad-bowad i David, keidowi a bag.” ");
INSERT INTO mbs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Medita se otaw migpunù te keilangan mepenek sikandin. Meneng labi beling sikandin timawal, “Bowad-bowad i David, keidowi a bag.” ");
INSERT INTO mbs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pegdineg i Jesus te pegtawal din, simagked sikandin aw minikagi, “Pedinihi niyo sikandin.” Penga niyan, minangay dan kandin, kagi dan, “Peseligi se pedowan nikaw. Tindeg ka den, so impeangay ka din.” ");
INSERT INTO mbs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Penga niyan, ayas timindeg aw tinenanan din se kayab din, aw dimoton ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Pegdateng din doton, minikagi si Jesus, “Eden lay se ibeg no inangen ko kamno?” Minikagi se otaw bota, “Sir, ibeg ko, todà a komità.” ");
INSERT INTO mbs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Minikagi si Jesus, “Mepakay aw molì ka den. Negolian ka den so simalig ka diyà kanak.” Pegketà, kimità sikandin, aw timaking ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nayan, pegpesalo dan doton te Jerusalem, migpedapag dan kidoen te lonsod te Bitpahi aw Bitanya doton te ongan te bontod te Olibo. Insogò i Jesus se didowa tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kagi din, “Onà kaw den doton te lonsod sida peselowan tadon. Aw domateng kaw doton, ketelaan niyo se nati te kodà. Iniketan iyan, meneng wedà iyan lumun kesekayi te otaw. Lebadi niyo, aw ibingi niyo dini. ");
INSERT INTO mbs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aw doen otaw meg-insà kenyo te nengà lay linebad niyo iyan, ikegihi niyo te keilangan sekayan iyan te Pengolo niyo, aw ipeolì din iyan te eked kenamay.” ");
INSERT INTO mbs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Penga niyan, nesayo dan, aw netelaan dan se nati te kodà iniketan diyà te lelebangan te balay medapag te dalan. Penga niyan, linebad dan iyan. ");
INSERT INTO mbs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Meneng mig-insà se menge otaw kidoen, “Nengà lay linebad niyo iyan?” ");
INSERT INTO mbs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yan mig-indan se didowa tinoledaan i Jesus tepad te insogò din kandan, aw penga niyan mepakay iyan diyà te tig-apò. ");
INSERT INTO mbs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Penga niyan, inibing dan se nati doton ki Jesus. Menge saol dan se in-ampal dan diyà te getan te nati, aw simakay si Jesus kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Medita se otaw migladlad te saol dan doton te dalan peselowan din, aw sinagpì te menge doma otaw se menge pelapà te palmera aw insawol dan doton te dalan, so yan se ketanem dan aw segmanen dan se otaw meinang selotan. ");
INSERT INTO mbs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Migpegais se kedita te otaw timaking ki Jesus, pengkey nekeonà aw timetondog. Migpegais dan, “Iduyun se Timanem. Iduyun se Pengolo tadon insogò din. ");
INSERT INTO mbs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iduyun se peglowan din iling te peglowan te kemonaan tadon gebii si David. Iduyun se Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pegdateng i Jesus doton te Jerusalem, dimoton sikandin te dakel simbahan kidoen. Pegtengteng din diyà te kedita, limikò sikandin doton te Bitanya sipat sìyan sempolò teg dowa tinoledaan din, so ontò den meapon. ");
INSERT INTO mbs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pegkeiselem niyan, minipanaw dan lekat te Bitanya pesalo doton te Jerusalem. Te wedà dan pa dateng doton, binallos si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kinità din se kayo igira te mediyò. Dimawen iyan, aw dimoton sikandin amon mahà te pongo niyan. Meneng pegdateng din doton, wedad palos pongo kinità din, olò menge dawen. Wedà pa dateng se aldaw te pegpongo din. ");
INSERT INTO mbs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Minikagi sikandin diyà te kayo, “Eked den palos pongo se kayo seini.” Dinineg te menge tinoledaan din se inikagi din sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pegdateng i Jesus doton te Jerusalem, dimoton sikandin te dakel simbahan, aw impekadas din se kedita te otaw egpemeligyà aw egbayad kidoen te dowangen niyan. Impelias din se lemisa te menge otaw egliwan te kwarta, aw impelias din heman se bangkò te menge otaw egpemeligyà te selepati ibegay diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sinagda din heman se kedita te otaw nengibing te kedònan dan minokit te dowangen te dakel simbahan. ");
INSERT INTO mbs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Penga niyan, migtoladà sikandin, kagi din, “Doen kagi te Timanem impesolat din gebii, ‘Se balay te Timanem, yan se ingedanan balay te pegtawal-tawal te kedita te otaw te keneyonan.’ Meneng ininang niyo den ini iling te ogpeanan te megdedempasay.” ");
INSERT INTO mbs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Meneng doen menge pengolo te simbahan aw menenoladà te punù ingkeliwat i Moises dimineg te inikagi i Jesus. Penga niyan, miglalang dan te imetayan dan sikandin. Nelemitan dan ki Jesus, so ontò nepela se kedita te otaw tepad te intoladà din. ");
INSERT INTO mbs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pegsallep te aldaw sìyan, nesayo si Jesus aw menge tinoledaan din lekat te Jerusalem aw minolì dan. ");
INSERT INTO mbs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pegkeiselem niyan, te peglikò dan doton te Jerusalem, kinità dan se kayo igira nelanes den pengkey dalid. ");
INSERT INTO mbs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Neeneng-enengan i Pedro aw eden se neinang, aw minikagi sikandin diyà ki Jesus, “Sir, tengtengi se kayo inikegiyan no gebenini nelanes den.” ");
INSERT INTO mbs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Minikagi si Jesus, “Aw megtawal-tawal kaw diyà te Timanem, keilangan somalig kaw diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Eneng-enengi niyo se kagi ko kenyo seini. Aw mikagi se otaw diyà te bontod seini te meabat iyan aw mealin doton te dagat, aw kenà egdowa-dowa se pedowan din, meneng egpemenal te metoman se kagi din, metoman iyan meinang. ");
INSERT INTO mbs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yan mikagi a den diyà kenyo, aw megtawal-tawal kaw diyà te Timanem, keilangan memenal kaw te binegayan kaw din den te pinemoyò niyo, aw metoman kinewaen niyo iyan. ");
INSERT INTO mbs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aw megtawal-tawal kaw, aw doen salà ininang te doma otaw diyà kenyo wedà niyo pa pegwedadi, pegwedadi niyo iyan amon pegwedaden heman te Timanem se salà ininang niyo diyà kandin.  ");
INSERT INTO mbs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Meneng aw eked niyo pegwedadi se salà ininang te doma otaw diyà kenyo, eked heman pegwedadi te Timanem Amay se salà ininang niyo diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pegdateng dan doton te Jerusalem, minipanaw si Jesus kidoen te dakel simbahan. Wedà kenamay, doen menge pengolo te simbahan aw menenoladà te punù aw menge obanen te Judiyo dimoton ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mig-insà dan, “Nengà lay eg-inang ka te kedita nini? Sinu lay se simogò kamno?” ");
INSERT INTO mbs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Minikagi si Jesus, “Doen heman insà ko kenyo. Aw meketaba kaw kani, meg-indan a kenyo aw sinu se simogò kanak. ");
INSERT INTO mbs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sinu lay se simogò ki Juan amon memonyag? Timanem lay, aw otaw se simogò kandin?” ");
INSERT INTO mbs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Penga niyan, migpebelaw-belaway dan aw eden se itaba dan kandin. Minikagi dan, “Simpana tomaba kidon te Timanem se simogò ki Juan, silahen kidon din, so wedà kidon pemenal ki Juan. ");
INSERT INTO mbs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Meneng eked kidon heman taba te olò otaw se simogò ki Juan.” Eked dan ikagi te olò otaw se simogò ki Juan, so nelemitan dan aw keopalan dan te kedita te otaw netipon, so eg-aneng-aneng se kedita te otaw te ontò telekeliwat te kagi te Timanem si Juan. ");
INSERT INTO mbs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yan se doun te minikagi dan, “Inday. Wedà day ketegahi aw sinu.” Minikagi si Jesus, “So wedà kaw taba te insà ko, eked a peg-indan kenyo aw sinu se simogò kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nayan, mig-indan si Jesus te menge tegdeyanan diyà te medita otaw netipon kidoen. Minikagi sikandin, “Doen otaw migpawà aw nenanem te paras. Mig-inang sikandin te alad, aw tigmesanan te paras, aw layag. Penga niyan, impetonggò din iyan te menge doma otaw, aw dimoton te mediyò ogpeanan. ");
INSERT INTO mbs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pegdateng te aldaw te peglegani, doen sineligan insogò te tig-apò amon doen talad ebaten din lekat te menge otaw impetonggò din. ");
INSERT INTO mbs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Meneng pegdateng te sogounun doton kandan, binadas dan sikandin aw impekesayo dan te wedad palos imbegay kandin. ");
INSERT INTO mbs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Penga niyan, doen doma sineligan insogò te tig-apò. Meneng binonalan dan sikandin diyà te olo, aw ontò dan pa pigyàyà. ");
INSERT INTO mbs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Penga niyan, doen doma sineligan insogò te tig-apò. Meneng inimetayan dan. Medita pa se sineligan insogò din doton kandan, meneng doen binadas dan, aw doen heman inimetayan dan. ");
INSERT INTO mbs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Se temanan insogò din, yan se batà din egkedekelan din te pedowan, so aneng-aneng din keilangan segmanen dan se kandin batà. ");
INSERT INTO mbs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Meneng pegdateng te batà din doton, migpebelaw-belaway dan, ‘Seini se meketig-apò te tanà seini aw matay se amay din. Mèpiya aw imetayan tadon sikandin amon sikitadon den se meketig-apò te tanà seini.’ ");
INSERT INTO mbs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Penga niyan, inimetayan dan sikandin aw in-agbel dan se lawa din doton te lowà te pawà. ");
INSERT INTO mbs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Nayan, meg-indan a den diyà kenyo aw eden se inangen te tig-apò diyà kandan. Domoton sikandin aw imetayan din se kedita dan, aw ipetonggò din se pawà din te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Migbasa kaw den besi te kagi te Timanem seini insolat, ‘Doen bato in-agbel te menge otaw mig-inang te balay, so eden dan aw wedad kekemowan niyan. Meneng yan se bato ontò salig te balay. ");
INSERT INTO mbs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mèpiya se ininang te Pengolo sìyan, aw yan se doun te iduyun tadon sikandin.’” ");
INSERT INTO mbs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pegdineg te menge obanen te Judiyo kenyan, netegahan dan te sikandan se nesogatan te tegdeyanan din sìyan, aw yan se doun te ibeg dan megdakep peden kandin. Meneng wedà dan peketoman, so nelemitan dan te menge otaw gayed egpenenalan kandin. Penga niyan, nesayo dan lekat kidoen. ");
INSERT INTO mbs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wedà kenamay, doen menge Parisiyo aw menge sakop i Herod insogò dan doton ki Jesus, so ibeg dan doen idimanda dan tepad te pegtoladà din. ");
INSERT INTO mbs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pegdateng dan doton ki Jesus, minikagi dan, “Sir, netegahan day te kenà ka egkebolalaw. Netegahan day heman te pengkey sinu se otaw toledaan nikaw, gayed ka egtoladà te kebenalan tepad te ibeg te Timanem. Nayan, doen insà day kamno. Lomàpang kidon lay te menge punù ingkeliwat i Moises aw mayad kidon te mihoras diyà te gobirno te Roma? Mepakay lay aw eked?” ");
INSERT INTO mbs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Meneng netegahan i Jesus te medaet se tod dan te peg-insà dan kenyan. Yan minikagi sikandin, “Medaet se pegtandà niyo kanak. Pekitai niyo kanak se kwarta ipegbayad niyo te mihoras.” ");
INSERT INTO mbs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Penga niyan, imbegay dan diyà kandin se kwarta plata. Mig-insà si Jesus, “Sinu lay bawa se insawol kidoen? Sinu lay ngadan se insolat kidoen?” Timaba dan, “Selotan te Roma.” ");
INSERT INTO mbs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Minikagi si Jesus, “Begayi niyo diyà te selotan se keilangan ibegay niyo diyà kandin, aw begayi niyo heman diyà te Timanem se keilangan ibegay niyo diyà kandin.” Pegdineg dan kenyan, nepela dan. ");
INSERT INTO mbs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Doen heman menge Sadusiyo dimoton ki Jesus. Yan se menge otaw egtoladà te eked palos keantay se otaw lekat te nematay. Mig-insà dan diyà ki Jesus, kagi dan, ");
INSERT INTO mbs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sir, doen impunù i Moises kenitadon tepad te inangen te telekedowa meama. Aw matay se meama te wedad pa batà te esawa din, keilangan mengognan se kedowa te nematay diyà te nayi din nebalo, amon doen peden batà te kedowa din nematay. ");
INSERT INTO mbs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, doen ekon pito telekedowa meama. Nengognan se kakay dan, aw nematay sikandin te wedad pa batà dan. ");
INSERT INTO mbs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Penga niyan, nengognan se ikedowa meama te nayi din nebalo, meneng nematay heman sikandin te wedad pa batà dan. Onawa heman se neinang te iketelo meama. ");
INSERT INTO mbs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Migpetibos-tibosay se pito telekedowa nengognan te bayi sìyan, meneng nematay se kedita dan te wedad pa palos batà dan. Penga niyan, nematay heman se bayi. ");
INSERT INTO mbs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nayan, indani kay. Aw meantay se otaw lekat te nematay, sinu lay lebò diyà kandan se ontò esawa te bayi sìyan? So migpetibos-tibosay dan se pito nengognan kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Minikagi si Jesus, “Ontò kaw migkemalì, so wedà niyo pa kelebeti se kagi te Timanem insolat, aw wedà niyo heman ketegahi aw eden se mebatog inangen te Timanem pineokit te tolos din. ");
INSERT INTO mbs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aw entayen te Timanem se menge otaw lekat te nematay, eked dan palos pengognan, so iling dan te menge anghil eg-ogpà doton te langit. ");
INSERT INTO mbs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wedà kaw ketaga-taga te metoman meantay se otaw lekat te nematay, so wedà kaw besi pegbasa te libro insolat i Moises gebii. Pegsolat din tepad te pegpekità te Timanem diyà kandin kidoen te sagbet limegdeg, minikagi se Timanem diyà kandin, ‘Siak se Timanem gayed egseligan i Abraham, aw si Isaac, aw si Jacob.’ ");
INSERT INTO mbs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yan kenà otaw wedad pedowan se egsalig te Timanem, meneng otaw doen pedowan se egsalig kandin. Yan se doun te ontò kaw migkemalì.” ");
INSERT INTO mbs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nayan, dimateng se sebad menenoladà te punù ingkeliwat i Moises, aw dinineg din se pegpebelaw-belaway dan. Pegketaga-taga din te mèpiya se intaba i Jesus kandan, mig-insà sikandin, “Diyà te kedita te punù ingkeliwat i Moises, eden lay punui se ontò melangkaw?” ");
INSERT INTO mbs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Minikagi si Jesus, “Seini se punù ontò melangkaw. ‘Kedita niyo menge bowad-bowad i Israel, penenalan kaw kanak. Sebad olò se Timanem, aw sikandin se Pengolo tadon. ");
INSERT INTO mbs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kedekeli niyo te pedowan se Pengolo niyo Timanem te ontò melobos se pedowan niyo kandin, aw aneng-aneng niyo.’ ");
INSERT INTO mbs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Seini se punù neketondog kenyan. ‘Kedekeli niyo te pedowan se doma otaw iling te peg-aneng-aneng niyo te kenyo pegkeotawun.’ Wedad palos punù labi pa melangkaw diyà te didowa punù sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Minikagi se menenoladà sìyan, “Sir, neketotok se intaba nikaw. Benal se inikagi no te sebad olò se Timanem, aw wedad doma timanem lowà pa diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Benal heman se inikagi no te keilangan kedekelan tadon sikandin te pedowan te ontò melobos se pedowan tadon kandin, aw keilangan kedekelan tadon te pedowan se doma otaw iling te peg-aneng-aneng tadon te kenitadon pegkeotawun. Pengkey mèpiya se pegpengimatay aw pegsonog tadon te ayam-ayam ibegay diyà te Timanem, meneng labi pa mèpiya aw tomolò kidon te didowa punù sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pegdineg i Jesus te mèpiya se intaba din, minikagi sikandin, “Agpet den se pegpesakop no diyà te peglowan te Timanem.” Lekat te aldaw sìyan, wedad palos otaw migtelaman mig-insà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nayan, pegtoladà i Jesus doton te dakel simbahan, minikagi sikandin, “Benal se ipegtoladà te menge menenoladà te punù ingkeliwat i Moises te bowad-bowad i David se Misiyas isogò te Timanem dini kenyo. ");
INSERT INTO mbs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Meneng minikagi si David te Pengolo din se Misiyas. Pineokit te pegbayà-bayà te Espiritu Santo ki David, insolat din se kagi seini, ‘Minikagi se Timanem diyà te Pengolo ko, Penenoo ka dini te tangkil ko lamig dàgen ko se menge poon no aw ipetolò ko dan kamno.’ ");
INSERT INTO mbs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, so minikagi si David te Pengolo din se Misiyas, kenà olò bowad-bowad din se Misiyas, meneng Pengolo din heman.” Neluba se kedita te otaw nenenalan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pegtoladà din, minikagi sikandin, “Peg-ahà kaw te menge menenoladà te punù ingkeliwat i Moises. Gayed dan egpenaol te melayat, aw ibeg dan segmanen dan te doma otaw doton te pedyanan. ");
INSERT INTO mbs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ibeg dan heman menenoo doton te mèpiya onsedanan kidoen te simbahan te Judiyo. Aw doen dakel kànen, ibeg dan sikandan se monà ipekaen. ");
INSERT INTO mbs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Meneng sikandan se eg-agaw te kedònan te menge bayi balo, aw penga niyan menamay se pegtawal-tawal dan amon megpelingo-lingo dan te melobos se pedowan dan diyà te Timanem. Meneng metoman dan ontò ipelumun labi pa diyà te doma otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nayan, nenenoo si Jesus doton didalem te dakel simbahan te Jerusalem medapag te solanan te kwarta ibowang diyà te Timanem. Timengteng sikandin diyà te menge otaw egsawol te kwarta dan kidoen. Medita se otaw meyaman egsawol te dakel kwarta ibowang dan. ");
INSERT INTO mbs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Penga niyan, dimateng se sagkep bayi balo, aw migsawol sikandin te didowa kedakò kidoen wedad nael keelagà niyan. ");
INSERT INTO mbs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Penga niyan, tinawal i Jesus se menge tinoledaan din, aw minikagi sikandin, “Eneng-enengi niyo se kagi ko seini. Pengkey dakel se imbowang te kedita te doma otaw migsawol te kwarta kidoen, meneng labi pa meelagà se imbowang te bayi balo sida. ");
INSERT INTO mbs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dakel se kwarta te doma otaw aw eked dan kelimahi tandà te pegpemegay dan. Meneng se bayi sida sagkep, tinigkan din imbowang se kedakel te kedònan din, pengkey nelimahan sikandin.” ");
INSERT INTO mbs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nayan, peglowà i Jesus lekat te dakel simbahan te Jerusalem, doen sebad tinoledaan din minikagi, “Sir, tengtengi se menge balay te simbahan, so mèpiya se bawa niyan, aw ininang iyan te bato mèpiya se bawa niyan.” ");
INSERT INTO mbs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Minikagi si Jesus, “Pengkey induyun niyo se dakel simbahan seini, meneng tigkan iyan kebàtan te modi aldaw, aw wedad palos bato ketenanan diyà te lanto te doma bato.” ");
INSERT INTO mbs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wedà kenamay, dimoton dan te bontod te Olibo dipag te dakel simbahan. Nenenoo si Jesus, aw dimoton kandin si Pedro, si Santiago, si Juan, aw si Andres te wedad doma dan. Mig-insà dan, ");
INSERT INTO mbs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Indani kay. Kano lay ketoman se in-indan nikaw? Eden lay se pengilala kitaen day aw agpet metoman se kedita niyan?” ");
INSERT INTO mbs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Minikagi si Jesus, “Peg-ahà kaw amon eked kaw keekali. ");
INSERT INTO mbs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Doen kwani medita otaw megpelingo-lingo te insogò ko dan. Mikagi dan te sikandan se Misiyas, aw medita se otaw keekalan dan aw tomaking kandan. ");
INSERT INTO mbs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aw domineg kaw te doen gira aw menge samok, ikà niyo egkelemitan. Keilangan onà iyan meinang, meneng kenà pa niyan se temanan te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Medita se otaw meggira, so doen pongan megbolaw diyà te doma pongan, aw doen heman menge sakop te sebad selotan megbolaw diyà te menge sakop te doma selotan. Megelà se otaw te medita ogpeanan tandà te linog aw bayil domateng diyà kandan. Pengkey medaet iyan, meneng yan olò se keteboan te kelimahan domateng dini te keneyonan, iling te keteboan te mesakit domateng te bayi agpet tebawan. ");
INSERT INTO mbs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Meneng peg-ahà kaw, so ibingen kaw te doma otaw doton te howis, aw bedasen kaw dan kidoen te menge simbahan te Judiyo. Ipeibing kaw doton te menge gobirnador aw selotan tandà te pegpesakop niyo diyà kanak, amon mekeindan kaw te kebenalan tepad kanak diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Keilangan onà itoladà se Mèpiya Indan diyà te kedita te otaw te eked pa dateng se temanan te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aw ibingen kaw doton te otaw meg-okom kenyo, ikà niyo egketetana aw eden se ikegiyen niyo kandan. Dalem te aldaw sìyan, begayan kaw te kebiyasa amon meketaba kaw kandan, so kenà lekat te kenyo kebiyasa se ikegiyen niyo, meneng lekat iyan te Espiritu Santo. ");
INSERT INTO mbs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Doen menge otaw megtolok te kandan menge kedowa amon imetayan dan. Doen heman amay megtolok te kandan menge batà amon imetayan dan. Doen heman menge otaw eked pegsagman te kandan amay aw inay, aw ipeimatay dan. ");
INSERT INTO mbs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kebensihan kaw te keditaan te otaw tandà te pegpesakop niyo diyà kanak. Meneng aw tomayod kaw te kedita te kelimahan, ipelowà kaw.” ");
INSERT INTO mbs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Doen pa domateng meg-inang te medaet doton te dakel simbahan te Jerusalem, pengkey eked iyan kepakay, aw ontò mekelamit te otaw. (Keilangan kelebetan iyan te kedita te otaw megbasa te kagi din sìyan insolat.) Aw kitaen niyo iyan doton te dakel simbahan, keilangan komadas se kedita te otaw lekat te Judiya pesalo doton te bontod. ");
INSERT INTO mbs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keilangan eked awop diyà te balay din se otaw doton te lowà amon ebaten din se kedònan, meneng keilangan tenanan din se kedita. ");
INSERT INTO mbs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Se otaw egterbaho doton te pawà, eked heman olì amon ebaten din se ekasan, meneng keilangan komadas. ");
INSERT INTO mbs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mekelelayò heman se menge bayi mebedes aw egsosowan te aldaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pegtawal-tawal kaw diyà te Timanem te kenà pengodan se pegkadas niyo, ");
INSERT INTO mbs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","so ontò medaet se kelimahan domateng diyà te keneyonan. Wedad palos kelimahan labi pa medaet diyà kenyan lekat te peg-inang te Timanem te keneyonan lamig seini, aw wedad palos heman kelimahan domateng labi pa medaet diyà kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Meneng pekebebaen te Timanem se kenamay te aldaw te kelimahan sìyan amon eked kegelà se kedita te otaw. Pekebebaen din iyan tandà te menge otaw pinemallì din. ");
INSERT INTO mbs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Aw domateng se aldaw sìyan, aw doen otaw mikagi, ‘Na, dini den se Misiyas,’ aw doen otaw mikagi, ‘Na, doton se Misiyas,’ ikà niyo egpemenal kandan, ");
INSERT INTO mbs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","so doen menge otaw domateng megpelingo-lingo te sikandan se Misiyas aw menge telekeliwat te kagi te Timanem. Meg-inang dan heman te menge kepelahan amon keekalan dan peden heman se menge otaw pinemallì te Timanem. ");
INSERT INTO mbs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Meneng peg-ahà kaw, so mig-indan a den te kedita diyà kenyo te eked pa dateng.” ");
INSERT INTO mbs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Aw mepenga se kelimahan sìyan, megkengitngit se keneyonan, so eked ebey senang se aldaw aw bolan. ");
INSERT INTO mbs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Medagdag heman se menge bitoen lekat te langit, so mebilit se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Penga niyan, kitaen te kedita te otaw se pegdateng ko, so lomikò a Timanem Migpekeotaw tekingan te labon. Komità dan te ontò a metolos aw melangkaw a. ");
INSERT INTO mbs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Isogò ko se menge anghil, aw ipetipon ko se kedita te otaw pinemallì ko lekat te kebelad te keneyonan, pengkey kenan dan peg-ogpà.” ");
INSERT INTO mbs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Penenalan kaw den te tegdeyanan seini tepad te kayo igira. Aw tomobed iyan aw domawen, ketegahan niyo te agpet den domateng se pengaldaw. ");
INSERT INTO mbs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iling heman kenyan, aw kitaen niyo se pegketoman te kedita niyan inikagi ko diyà kenyo, ketegahan niyo te agpet a den lomikò. ");
INSERT INTO mbs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eneng-enengi niyo se kagi ko kenyo seini. Doen menge otaw komità te pengilala sìyan, eked dan kematay singed aw metoman se kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Doen temanan te langit aw tanà, meneng gayed metoman se kagi ko te wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Meneng eked ko indani aw eden eldawi aw orasi se peglikò ko. Wedad palos netaga-taga aw kano a likò, pengkey menge anghil doton te langit, so olò Amay ko se netaga-taga kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Keilangan gayed kaw megpeketagad, so wedà niyo ketegahi aw eden eldawi se pegketoman niyan. ");
INSERT INTO mbs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iling a te otaw domoton te mediyò ogpeanan. Te eked pa kesayo, doen ipunù din diyà te kedita te sineligan din, so doen inangen te teg sebad-sebad kandan te iyogan din. Megpunù heman sikandin te keilangan gayed megpeketagad se otaw egbantay te balay din. ");
INSERT INTO mbs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yan se doun te keilangan gayed kaw megpeketagad, so wedà niyo ketegahi aw eden orasi se peglikò te Pengolo niyo, atok te pegsallep te aldaw, atok megtengà te delem, atok eked pa libtak se aldaw, atok iselem. Yan se doun te keilangan gayed kaw megpeketagad, ");
INSERT INTO mbs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","so aw lomikò a te wedà kaw pa peketagad, kitaen ko sikiyo timedogi pa. ");
INSERT INTO mbs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Se impunù ko kenyo seini, yan se ipunù ko heman diyà te kedita te otaw, te keilangan megpeketagad se teg sebad-sebad otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nayan, dowa mendad se aldaw te pegdateng te Pista te Pegpelowà. Yan se pegpengaen dan te pan kenà eglebag. Gayed mig-aneng-aneng se menge pengolo te simbahan aw menenoladà te punù aw eden se inangen dan amon dekepen dan si Jesus te wedad pa doma otaw metaga-taga amon imetayan dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Minikagi dan, “Keilangan eked kidon pegdakep kandin dalem te pista, amon eked pegsamok se kedita te otaw.” ");
INSERT INTO mbs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nayan, pegdoton i Jesus te lonsod te Bitanya, limaoy sikandin ki Simon, sìyan otaw pinegolian din te tompig. Dalem te pegpengaen dan, doen bayi nengibing te lana metinadeg insawol diyà te deitek botilya. Ontò iyan meelagà so ininang te ontò nardo. Penga niyan, linebak din se botilya aw intoyong din se lana diyà te olo i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, doen menge otaw kidoen mig-aneng-aneng, “Tay law. Pigbàtan din se lana sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Simpana ibeligyà iyan, ginatos pa se kwarta dinaryo iteped peden diyà te menge otaw sagkep.” Sinila dan heman se bayi sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Meneng minikagi si Jesus, “Pebeyai niyo sikandin. Ikà niyo egsila te bayi sìyan. Mèpiya se ininang din diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gayed doen otaw sagkep mebatog niyo tebangan pengkey kano doen ibeg niyo. Meneng eked a gayed peg-ogpà dini kenyo. ");
INSERT INTO mbs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ininang te bayi sìyan se mebatog din inangen. Pineokit te pegtoyong din te lana sìyan diyà kanak, impetagad a din te peglebeng kanak. ");
INSERT INTO mbs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eneng-enengi niyo se kagi ko seini. Eked palos sikandin kelibeli, so pengkey kenan toledai se Mèpiya Indan doton te kebelad te keneyonan, iindan heman se ininang te bayi sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nayan, doen sebad tinoledaan i Jesus ngadan din si Judas Iscariote. Dimoton sikandin te menge pengolo te simbahan aw migpebelaw-belaway dan tepad te pegtolok din ki Jesus amon dekepen dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pegdineg dan te kagi din, neluba dan aw migpakang dan te doen kwarta ibegay dan diyà kandin. Penga niyan, migtagad si Judas te mèpiya aldaw amon itolok din si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nayan, dimateng se tagnà aldaw te pista te pegpengaen te menge Judiyo te pan kenà eglebag. Yan heman se aldaw te pegpengiyaw dan te nati te karniro kànen dan te Pista te Pegpelowà. Dimoton se menge tinoledaan i Jesus kandin aw mig-insà dan, kagi dan, “Kenan kay lay peg-inang te kànen tadon te Pista te Pegpelowà?” ");
INSERT INTO mbs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Penga niyan, insogò din se didowa tinoledaan din, kagi din, “Doton kaw te Jerusalem. Aw domateng kaw doton, kitaen niyo se otaw neniang te sibolan nepenò te wayeg. Taking kaw kandin. ");
INSERT INTO mbs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aw domateng sikandin doton te balay, ikagi kaw diyà te tig-apò, ‘Insogò kay te Pengolo amon meg-insà kay kamno aw kenan se kànan te kedita day te Pista te Pegpelowà.’ ");
INSERT INTO mbs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Penga niyan, ipekità din diyà kenyo se dakel gibelayan kidoen diatas te balay tapay doen telepagan impetagad kenitadon. Peg-inang kaw te kànen tadon kidoen.” ");
INSERT INTO mbs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Penga niyan, nesayo se didowa tinoledaan din aw dimoton dan te Jerusalem. Kinità dan se kedita iling te tapay inikagi i Jesus diyà kandan. Penga niyan, mig-inang dan te kànen. ");
INSERT INTO mbs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pegkedelem niyan, dimoton si Jesus aw kedita te sempolò teg dowa tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dalem te kimaen dan, minikagi si Jesus, “Eneng-enengi niyo se kagi ko kenyo seini. Doen sebad kenyo megtolok kanak, aw kimaen sikandin doma ko.” ");
INSERT INTO mbs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nepuluk se pedowan dan, aw migpetibos-tibosay dan mig-insà diyà kandin, kagi dan, “Kenà ko lay lebò?” ");
INSERT INTO mbs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Minikagi si Jesus, “Yan se sebad diyà te sempolò teg dowa kenyo. Timogen sikandin kanak. ");
INSERT INTO mbs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Metoman a imetayan, so yan se kagi te Timanem insolat gebii tepad kanak Timanem Migpekeotaw. Meneng mekelelayò se otaw megtolok kanak. Mèpiya peden aw wedà sikandin tebaw.” ");
INSERT INTO mbs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nayan, dalem te pegpengaen dan, nengabat si Jesus te pan, aw migpesiontong sikandin diyà te Timanem. Penga niyan, binelà-belà din se pan, aw inteped din iyan diyà kandan, aw minikagi sikandin, “Kàni niyo se pan seini, so yan se lawa ko.” ");
INSERT INTO mbs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Penga niyan, inabat din heman se tabò, aw migpesiontong sikandin diyà te Timanem, aw inteped din heman diyà kandan, aw mininem se kedita dan kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Minikagi si Jesus, “Yan se dipanog ko, aw pineokit kani, doen den kaling peokit pesalo doton te Timanem. Pineokit te pegkematay ko, medita se otaw tebangan. ");
INSERT INTO mbs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eneng-enengi niyo se kagi ko kenyo seini. Eked a todà inem te ininem tadon seini singed aw metoman kidon minem te kaling bino doton te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Penga niyan, migdelangan dan tepad te pegduyun dan te Timanem, aw nesayo dan lekat kidoen, aw dimoton dan te bontod te Olibo. ");
INSERT INTO mbs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Penga niyan, minikagi si Jesus diyà te menge tinoledaan din, “Tomanan se kedita niyo kanak, so doen kagi te Timanem insolat gebii, ‘Ipeimatay ko se otaw egtonggò te ayam-ayam karniro, aw mebilit se kedita te karniro tinonggoan din.’ ");
INSERT INTO mbs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Meneng penga te pegkeantay ko lekat te nematay, mekeonà a diyà kenyo doton te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Minikagi si Pedro diyà ki Jesus, “Pengkey tomanan se kedita te doma kamno, meneng eked a palos tanan kamno.” ");
INSERT INTO mbs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Minikagi si Jesus, “Eneng-enengi se kagi ko kamno seini. Kwani te eked pegkolaak se manok te mekedowa te delem seini, ibolon a nikaw te meketelo.” ");
INSERT INTO mbs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Meneng ontò minikagi si Pedro, “Eked a palos pegbolon kamno, pengkey imetayan a sipat kamno.” Iling heman kenyan se inikagi te kedita te tinoledaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nayan, dimoton dan te kekeyowan iningedanan Gitsimani. Pegdateng dan doton, minikagi si Jesus diyà te menge tinoledaan din, “Pegtagad kaw dini, so domoton a sida amon megtawal-tawal a.” ");
INSERT INTO mbs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Penga niyan, impetaking din si Pedro, aw si Santiago, aw si Juan. Ontò den nepuluk se pedowan din, ");
INSERT INTO mbs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","aw minikagi sikandin, “Ontò den nepuluk se pedowan ko, iling te matay a. Peg-ogpà kaw den dini, aw ikà niyo egtedogi.” ");
INSERT INTO mbs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Penga niyan, dimeleg si Jesus te kenà mediyò, aw limemlem sikandin aw migtawal-tawal. Nemoyò sikandin diyà te Timanem aw mepakay diyà kandin, eked din peden sikandin peokiti diyà te kelimahan agpet domateng diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Migtawal-tawal sikandin, kagi din, “Amà, wedad palos eked no kebatog. Yan eked a no peden peokiti diyà te kelimahan seini. Meneng ibeg ko, kamno ibeg se metoman, kenà kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Peglikò din doton te tinoledaan din, timedogi den dan. Linoka din sikandan aw minikagi sikandin diyà ki Pedro, “Simon, nepela a den kenyo, so timedogi kaw. Wedà kaw kedì peketayod te sebad olò oras. ");
INSERT INTO mbs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ikà niyo egtedogi, meneng pegtawal-tawal kaw amon eked kaw keboyo. Pengkey mèpiya se ibeg te pedowan niyo, meneng wedad kagsen te lawa niyo.” ");
INSERT INTO mbs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Todà migpekediyò-diyò si Jesus aw migtawal-tawal. Onawa heman se intawal-tawal din. ");
INSERT INTO mbs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Todà limikò si Jesus doton te menge tinoledaan din, aw kinità din dan timedogi, so ontò dan nepilot. Wedà dan ketegahi aw eden se itaba dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Peglikò i Jesus doton kandan te iketelo, minikagi sikandin, “Nepela a so gayed kaw timedogi. Na, botong den iyan, so dimateng den se oras te pegtolok kanak Timanem Migpekeotaw amon dekepen a te menge otaw nelegeb te salà. ");
INSERT INTO mbs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enaw kaw den. Dimateng den se otaw megtolok kanak. Somongon kidon kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Telobo pa minikagi si Jesus, pegketà dimateng si Judas, sìyan tinoledaan i Jesus. Medita se otaw timaking kandin, aw migkekamang dan te menge podok aw batota. Insogò dan te menge pengolo te simbahan aw menge menenoladà te punù ingkeliwat i Moises aw menge obanen te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tapay dan netegahan aw eden se inangen i Judas, so minikagi sikandin, “Se otaw edekan ko, yan se otaw inahà niyo. Dekepi niyo sikandin aw bentayi niyo sikandin te pegpengibing niyo kandin doton te otaw meg-osay kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nayan, pegdateng dan doton, wedà peg-alà-alà si Judas meneng dimoton ki Jesus, aw minikagi, “Sir.” Penga niyan, inedekan din si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Penga niyan, dinakep dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Meneng doen sebad tinoledaan i Jesus nenagnos te podok din aw tinigbas din se sineligan te ontò pengolo te simbahan, aw nepalot se dibaloy telinga din. ");
INSERT INTO mbs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Penga niyan, minikagi si Jesus diyà kandan, “Kolang se pegkekamang niyo te podok aw batota amon megdakep kaw kanak, so kenà a megdedempasay. ");
INSERT INTO mbs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gayed a migtoladà doton te dakel simbahan, meneng wedà a niyo dekepi doton. Meneng keilangan metoman se kagi te Timanem insolat tepad kanak.” ");
INSERT INTO mbs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Penga niyan, kimadas se kedita te tinoledaan i Jesus, aw tinenanan dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Doen sebad telaki timelokon ki Jesus olò migdiping. Dinakep dan heman sikandin, ");
INSERT INTO mbs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","meneng nekelowà, so tinenanan din se diping din aw kimadas migpetabeg-tabeg. ");
INSERT INTO mbs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Penga niyan, inibing dan si Jesus doton te ontò pengolo te simbahan. Tapay netipon kidoen se menge pengolo te simbahan, aw menge obanen te Judiyo, aw menge menenoladà te punù ingkeliwat i Moises. ");
INSERT INTO mbs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Timelokon heman si Pedro, meneng migpekediyò sikandin lamig dimateng doton te dowangen te balay te ontò pengolo te simbahan. Nenenoo sikandin doma te menge otaw migtonggò te dakel simbahan, aw mig-ingadang sikandin diyà te apoy dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nayan, ibeg te menge pengolo te simbahan aw menge doma dan obanen, doen inangan dan si Jesus te salà amon doen tindegan te pegpeimatay dan kandin. Meneng wedad palos salà din kinità dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pengkey medita se otaw migkebolalaw tepad kandin, meneng kenà onawa se in-indan dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Doen menge otaw migkebolalaw tepad kandin, kagi dan, ");
INSERT INTO mbs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dinineg day se inikagi din te mekebatog sikandin megbaet te dakel simbahan sida ininang te otaw, aw ipetindeg din se kaling simbahan eked inangi te otaw dalem te telo se aldaw.” ");
INSERT INTO mbs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pengkey yan se in-indan dan tepad kandin, meneng kenà onawa se in-indan dan. ");
INSERT INTO mbs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Penga niyan, timindeg se ontò pengolo te simbahan aw mig-insà diyà ki Jesus, “Eden lay se itaba no kenyan? Indani kay aw benal se inikagi dan.” ");
INSERT INTO mbs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Meneng wedà taba si Jesus. Minikagi heman se ontò pengolo te simbahan, “Sikona ekon se Misiyas, sìyan Batà te Timanem. Indani kay den aw benal iyan.” ");
INSERT INTO mbs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Minikagi si Jesus, “Benal iyan. Komità kaw kanak Timanem Migpekeotaw egpenenoo kidoen te tangkil te Amay ko metolos amon lomowan a doma din. Lomikò a heman dini lekat te langit tekingan te labon.” ");
INSERT INTO mbs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Penga niyan, miglisì se ontò pengolo te simbahan te saol din tandà te keopal din, aw minikagi sikandin, “Wedad den kekemowan te peg-indan te doma otaw diyà kenitadon tepad kandin, ");
INSERT INTO mbs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","so dinineg tadon den se pegtompuyus din te Timanem pineokit te pegpelingo-lingo din Batà te Timanem. Na, eden lay se aneng-aneng niyo tepad kandin?” Penga niyan, minikagi se kedita dan te keilangan imetayan sikandin so doen salà din. ");
INSERT INTO mbs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lekat niyan, tineptepan dan sikandin, aw doen nenampeng te mata din aw nenombag kandin, aw minikagi dan, “Na, etoki aw sinu se nenombag kamno.” Nenombag heman kandin se menge otaw migtonggò te dakel simbahan. ");
INSERT INTO mbs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dalem niyan, mig-ogpà si Pedro kidoen te dowangen. Doen bayi egtelaban te ontò pengolo te simbahan minokit kidoen te dowangen. ");
INSERT INTO mbs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pegkità din ki Pedro mig-ingadang kidoen te apoy, mininoet sikandin aw minikagi, “Sikona se egdoma ki Jesus tege Nasarit.” ");
INSERT INTO mbs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Meneng migbolon si Pedro, kagi din, “Wedà ko ketegahi aw eden se eg-ikegiyen nikaw.” Penga niyan, minalin si Pedro doton te dapag te dalan, aw migkolaak se manok. ");
INSERT INTO mbs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wedà kenamay, todà kimità se bayi sìyan ki Pedro aw minikagi diyà te menge otaw kidoen, “Sebad heman sakop din se otaw seini.” ");
INSERT INTO mbs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Meneng todà migbolon si Pedro. Penga niyan, te wedà kenamay, doen menge doma otaw kidoen minikagi diyà ki Pedro, “Benal sikona se sebad egdoma te otaw sida dinakep, so tege probinsya ka te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Meneng ontò migsapà si Pedro aw minikagi, “Wedà a palos kilala te otaw eg-ikegiyen niyo sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pegketà, migkolaak se manok te ikedowa. Yan neeneng-enengan i Pedro se tapay inikagi i Jesus te ibolon din sikandin te meketelo te eked pa pegkolaak se manok te mekedowa. Penga niyan, ontò sikandin migkelag. ");
INSERT INTO mbs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nayan, peglibtak te aldaw sìyan, netipon se kedita te pengolo te simbahan, aw menge obanen te Judiyo, aw menge menenoladà te punù ingkeliwat i Moises. Netipon se kedita dan amon meglalang dan aw eden se inangen dan. Penga niyan, ginapos dan si Jesus, aw inibing dan sikandin doton te gobirnador si Pilato. ");
INSERT INTO mbs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pegdateng dan doton, mig-insà si Pilato ki Jesus, kagi din, “Sikona lay se Selotan te menge Judiyo?” Timaba si Jesus, “Ee. Benal se kagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Penga niyan, medita se indimanda te menge pengolo te simbahan tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Minikagi heman si Pilato, “Medita se indimanda dan tepad kamno. Eden lay se itaba no kandan?” ");
INSERT INTO mbs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Meneng wedà den taba si Jesus, aw yan se doun te nepela si Pilato. ");
INSERT INTO mbs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nayan, kelikit te Pista te Pegpelowà, doen ketanem te gobirnador te ipelowà din se sebad otaw kineleboso, pengkey sinu se pemellien te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na, dalem niyan, doen menge ribildi kineleboso, so nemonò dan te otaw te peg-ato dan te gobirno. Doen sebad kandan iningedanan ki Barabas. ");
INSERT INTO mbs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pegketipon te medita otaw, nemoyò dan ki Pilato amon ipelowà din se otaw kineleboso, so yan se ketanem din. ");
INSERT INTO mbs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Penga niyan, mig-insà si Pilato, “Meibeg kaw lay aw ipelowà ko se Selotan te menge Judiyo?” ");
INSERT INTO mbs_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yan se inikagi i Pilato, so netegahan din te impedakep te menge pengolo te simbahan si Jesus so miningà dan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Meneng gayed migdeliseg se menge pengolo te simbahan diyà te otaw netipon kidoen amon ipelowà din si Barabas aw eked din pelowai si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mig-insà heman si Pilato, “Menonen ko sikandin egtewalen niyo Selotan te menge Judiyo?” ");
INSERT INTO mbs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Migbelobansag dan heman, kagi dan, “Imetayi sikandin. Lensangi diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mig-insà si Pilato, “Nengà lay? Eden lay se salà ininang din?” Meneng labi pa dakel se kagi dan, aw migbelobansag dan, “Imetayi sikandin. Lensangi diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Penga niyan, impelowà i Pilato si Barabas lekat te keleboso, so ibeg din meluba se medita otaw netipon. Impebadas din si Jesus, aw impeibing din amon ilansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Penga niyan, inibing te menge sondalo si Jesus doton didalem te balay te gobirnador, aw migtipon dan te kedita te doma dan sondalo. ");
INSERT INTO mbs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Penga niyan, pineseolan dan sikandin te melalag saol iling te saol te selotan. Linekò dan se belagen doen tigis aw yan se insangkob dan diyà te olo din iling te korona te selotan. ");
INSERT INTO mbs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Penga niyan, migpelingo-lingo dan te egsegmanen dan sikandin, kagi dan, “Iduyun sikona Selotan te menge Judiyo.” ");
INSERT INTO mbs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Penga niyan, binadas dan se olo din te tigbaw, aw tineptepan dan sikandin. Limongken dan heman diyà kandin aw migpelingo-lingo dan te sikandin se selotan egsegmanen dan. ");
INSERT INTO mbs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Penga te pegtompuyus dan kandin, linowas dan se melalag saol lekat kandin, aw impesaol dan diyà kandin se kandin saol. Penga niyan, inibing dan sikandin lekat te balay te gobirnador amon ilansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nayan, kidoen te dalan, netelaan te menge sondalo se sebad tege Sirene kaling dimateng lekat te saka. Ngadan din si Simon, aw batà din si Alejandro aw si Rufo. Lineges dan sikandin neniang te kros. ");
INSERT INTO mbs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inibing te menge sondalo si Jesus doton te bontod iningedanan Golgota. (Se kelebadan niyan, “Tòlan te Olo.”) ");
INSERT INTO mbs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pegdateng dan doton, imbegay te sondalo diyà ki Jesus se bino sinengedan te bebolong te saka iningedanan mira amon eked din imenmani se kesakit. Meneng wedà din inemi. ");
INSERT INTO mbs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Penga niyan, inlansang dan sikandin diyà te kros. Penga niyan, pigtalad-talad te menge sondalo se penenaktun linowas din, aw migbonot dan aw eden se penenaktun meabat te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Menge alas nowibi se oras te peglansang dan kandin diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Doen solat tepad te indimanda kandin insawol dan kidoen, kagi niyan, “Seini se Selotan te menge Judiyo.” ");
INSERT INTO mbs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Doen heman dowa megdedempasay inlansang diyà te kros kidoen te tangkil din, aw si Jesus diyà te tengà-tengà.  ");
INSERT INTO mbs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yan netoman se kagi te Timanem insolat gebii, “Ipelumun sikandin iling te otaw dakel se salà.” ");
INSERT INTO mbs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Migtompuyus kandin se menge otaw minokit diyà te dalan medapag kidoen. Migkiling-kiling dan te olo dan te pegsila dan kandin, aw minikagi dan, “Ehe. Minikagi ka te mekebatog ka megbaet te dakel simbahan sida, aw todà no iyan ipetindeg dalem te telo se aldaw. ");
INSERT INTO mbs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, aw mekebatog ka kenyan, pekitai diyà kenami te doen tolos no pineokit te pegtabang no te kamno pegkeotawun amon eked ka kematay. Tenà ka den lekat te kros.” ");
INSERT INTO mbs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iling heman kenyan se pegtompuyus te menge pengolo te simbahan, aw menenoladà te punù ingkeliwat i Moises. Minikagi dan, “Migtabang sikandin te menge doma otaw netigdaan amon eked dan pa kematay. Meneng eked den sikandin peketabang te kandin pegkeotawun amon eked kematay. ");
INSERT INTO mbs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aw benal sikandin se Misiyas aw Selotan te menge bowad-bowad i Israel, mekebatog sikandin tomenà lekat te kros dalem te pegtengteng tadon kandin, amon memenal kidon kandin.” Iling heman kenyan se pegtompuyus te doma otaw inlansang diyà te kros kidoen te tangkil din. ");
INSERT INTO mbs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nayan, pegkealas dosi te aldaw, migkengitngit se langit aw tanà lamig alas tris te meapon. ");
INSERT INTO mbs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Menge alas tris te meapon, timawal si Jesus te dakel se kagi din, kagi te Hebreo, “Eloi, Eloi, lama sabaktani?” Se kelebadan niyan, “E Timanem ko, nengà lay tinenanan a nikaw?” ");
INSERT INTO mbs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pegdineg te menge otaw netipon kidoen, minikagi dan, “Na, nengenganay den sikandin diyà ki Elias, sìyan telekeliwat te kagi te Timanem gebii.” ");
INSERT INTO mbs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Doen otaw ayas minangay te ispongha aw inagem din iyan diyà te bino sinengedan te wayeg. Intangen din iyan diyà te toktok te tigbaw, aw impesopsop din iyan ki Jesus. Minikagi heman se otaw, “Pebeyai niyo sikandin, so kitaen tadon aw domini si Elias amon mengabat kandin.” ");
INSERT INTO mbs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Penga niyan, timawal si Jesus te dakel se kagi din, aw penga niyan nematay. ");
INSERT INTO mbs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nayan, tigkan nelisì se kayad kidoen te tengà-tengà te dakel simbahan te Jerusalem. Nelisì iyan lekat diatas lamig diyà te ongan. ");
INSERT INTO mbs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gayed timengteng se kapitan te sondalo ki Jesus, aw pegkità din te pegtawal din aw pegkematay din, minikagi sikandin, “Ontò Batà te Timanem se otaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Doen heman menge bayi kidoen kenà mediyò te kros, aw kinità dan se kedita te neinang. Sikandan si Maria tege Magdala, aw kesangay din si Maria inay te kaling otaw si Santiago aw si Jose. Kidoen heman si Salome. ");
INSERT INTO mbs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sikandan se tapay timaking ki Jesus te peglegeb din kidoen te probinsya te Galiliya amon megtabang dan kandin. Medita heman se doma dan bayi timaking ki Jesus te pegdoton din te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Agpet den somallep se aldaw, aw keeldawan niyan se Sebado aw aldaw te peg-etod. Doen otaw si Jose tege Arimatiya. Sikandin se sebad obanen egsegmanen te menge doma din obanen eglowan diyà te menge Judiyo, aw egpeliman sikandin te peglowan te Timanem. Pegkeapon niyan, impesalig din se pedowan din, aw dimoton ki Pilato, aw pinemoyò din se lawa i Jesus amon ilebeng din. ");
INSERT INTO mbs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nepela si Pilato te nematay den si Jesus. Yan se doun te impeangay din se kapitan te sondalo, aw mig-insà kandin aw nematay den si Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Peg-ikagi te kapitan te benal nematay den si Jesus, migpunù si Pilato te mepakay aw ebaten i Jose se lawa din. ");
INSERT INTO mbs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Penga niyan, bineyadan din se sapot, aw inabat din se lawa lekat te kros, aw ginakes din iyan te sapot, aw inlebeng din kidoen te lebeng impeawang diyà te pangpang. Penga niyan, kinelid din se dakel bato amon isampeng te lebeng. ");
INSERT INTO mbs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Timaking heman si Maria tege Magdala aw kesangay din si Maria inay i Jose, aw kinità dan se linebengan te lawa. ");
INSERT INTO mbs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nayan, penga te aldaw te peg-etod, migpedomà-domaay si Maria tege Magdala, aw kesangay din si Maria inay i Santiago, aw si Salome. Minayad dan te metinadeg amon doen itoyong dan diyà te lawa i Jesus. ");
INSERT INTO mbs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Peglibtak te aldaw te iselem te Linggo, dimoton dan te lebeng. ");
INSERT INTO mbs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te wedà dan pa dateng doton, migpeinsaay dan, kagi dan, “Sinu lay se mengelid te bato insampeng te lebeng amon mekeawop kidon?” ");
INSERT INTO mbs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Meneng pegtengteng dan, kinità dan te tapay den nekelid se bato insampeng. Ontò dakel se bato sìyan. ");
INSERT INTO mbs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Penga niyan, minawop dan diyà te lebeng, aw kinità dan se anghil nenaol te mepotì aw nenenoo lenged te kowanan dan. Nepela se menge bayi. ");
INSERT INTO mbs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Penga niyan, minikagi se anghil, “Ikà niyo egkepela. Netegahan ko te inahà niyo si Jesus tege Nasarit, sìyan inlansang diyà te kros. Wedad den sikandin dini, so neantay den lekat te nematay. Tengtengi niyo den se linebengan kandin. ");
INSERT INTO mbs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, doton kaw den ki Pedro aw menge doma tinoledaan i Jesus, aw indani niyo dan te nekeonà den si Jesus diyà kenyo pesalo doton te probinsya te Galiliya. Kitaen niyo sikandin doton, so yan se inikagi din kenyo.” ");
INSERT INTO mbs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Penga niyan, limowà dan lekat te lebeng aw kimadas dan, so tinegangtang dan, aw ontò dan nepela. Wedad palos otaw inindanan dan tepad te kinità dan, so nelemitan dan.  ");
INSERT INTO mbs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nayan, penga te pegkeantay i Jesus lekat te nematay te iselem te Linggo, si Maria tege Magdala se tagnà pinekitaan i Jesus. Sikandin se tapay pinelowaan i Jesus te pito se bosaw. ");
INSERT INTO mbs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dimoton sikandin te menge tinoledaan i Jesus. Gayed dan nepuluk aw migkelag dan. Meneng mig-indan si Maria diyà kandan aw eden se kinità din. ");
INSERT INTO mbs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pegdineg dan te neantay den si Jesus lekat te nematay aw kinità din den sikandin, wedà dan pemenal kenyan. ");
INSERT INTO mbs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Penga niyan, migpekità si Jesus diyà te didowa tinoledaan din te peg-ipanaw dan pesalo doton te saka, meneng wedà dan sikandin kilelai, so netodà den se bawa din. ");
INSERT INTO mbs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pegkilala dan kandin, limikò dan doton te Jerusalem, aw mig-indan dan diyà te menge doma tinoledaan din. Meneng wedà dan pa pemenal kandan. ");
INSERT INTO mbs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Penga niyan, migpekità si Jesus diyà te sempolò tegusà tinoledaan din dalem te pegpengaen dan. Simila sikandin kandan so wedà dan pemenal aw magsen se olo dan, so wedà dan pemenal te kagi te menge otaw kimità kandin penga te pegkeantay din lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Penga niyan, minikagi si Jesus, “Doton kaw den te kebelad te keneyonan. Pegtoladà kaw te Mèpiya Indan tepad kanak diyà te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aw memenal se otaw kenyan, aw megpebonyag, ipelowà sikandin lekat te salà. Meneng aw eked pemenal se otaw, ipelumun sikandin. ");
INSERT INTO mbs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Seini se menge pengilala inangen te menge otaw egpemenal kanak. Megpelowà dan te bosaw lekat te otaw pineokit te ngadan ko. Mikagi dan heman te kagi eked kelebeti. ");
INSERT INTO mbs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pengkey mekeawid dan te memokan, pengkey mekeinem dan te mekeilo, eked dan elegi. Aw memaed dan te menge otaw doen mesakit, kegolian dan.” ");
INSERT INTO mbs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nayan, penga te peg-ikagi i Jesus diyà kandan, neengat sikandin doton te langit, aw nenenoo kidoen te tangkil te Timanem amon lomowan doma din. ");
INSERT INTO mbs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Penga niyan, nesayo se menge tinoledaan i Jesus lekat te Jerusalem aw migtoladà dan kidoen te kebelad te keneyonan, pengkey kenan dan pesalo. Tinebangan dan heman te Pengolo, so impetaga-taga din te benal se intoladà dan pineokit te menge pengilala ininang dan.");
INSERT INTO mbs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Elew Teofilo. Medita den se otaw simolat tepad te neinang dini kenami. ");
INSERT INTO mbs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Se insolat dan, yan se kagi ingkeliwat te menge otaw ontò kimità te kedita te ininang i Jesus lekat te ketebò niyan, so ontò dan kinità se ininang din, aw ingkeliwat dan heman se kagi din diyà kenami. ");
INSERT INTO mbs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Elew, nenamay a den mig-iling te kedita niyan, aw yan se doun te mig-aneng-aneng a den te mèpiya aw somolat a heman diyà kamno te kedita te neinang, ");
INSERT INTO mbs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","amon ketegahan no te ontò benal se tapay intoladà diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kedengan, dalem te peglowan i Herod kidoen te probinsya te Judiya, doen sebad pengolo te simbahan te Judiyo ngadan din si Zacarias. Sikandin se sebad pengolo te simbahan sakop te gropo i Abias. Doen esawa din si Elisabet, aw pengolo te simbahan se kemonaan din heman. ");
INSERT INTO mbs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sìyan teleesawa, ontò dan nelubahan te Timanem so metòlid se eg-inangen dan. Wedad palos otaw mekesila kandan so ontò dan egtolò te menge punù te Pengolo. ");
INSERT INTO mbs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wedad palos batà dan, so wedà pegbatà si Elisabet, aw lokes den, aw temoay den se esawa din. ");
INSERT INTO mbs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dimateng se aldaw te pegpengibing i Zacarias te pegsimba, so migpetibos-tibosay se menge gropo te pengolo. ");
INSERT INTO mbs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Se ketanem te menge pengolo te simbahan, migbonot dan aw sinu se mawop doton te dakel simbahan amon menonog te metinadeg. Aldaw sìyan, si Zacarias se nepallì. ");
INSERT INTO mbs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pegdateng te oras te pegsonog, medita se otaw migtawal-tawal doton te lowà. ");
INSERT INTO mbs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Peg-awop din amon menonog, doen anghil insogò te Timanem migpekità diyà kandin doton te sonoganan te metinadeg lenged te kowanan. ");
INSERT INTO mbs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pegkità i Zacarias kandin, migkebulung se aneng-aneng din aw nelemitan. ");
INSERT INTO mbs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Meneng minikagi se anghil, “Zacarias, ikà egkelemitan. Nenenalan se Timanem te intawal-tawal nikaw. Doen batà no meama tomebaw diyà te esawa no, aw keilangan ingedanan no sikandin ki Juan. ");
INSERT INTO mbs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yan se doun te ontò ka meluba, aw meluba heman se medita doma otaw aw tomebaw sikandin, ");
INSERT INTO mbs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","so ipelangkaw sikandin te Pengolo. Eked palos inem te bino aw pengkey eden se mekelasing. Meneng gayed sikandin egbeyà-beyaan te Espiritu Santo lekat te pegtebaw din. ");
INSERT INTO mbs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Megtabang sikandin te medita bowad-bowad i Israel amon todà dan tomaking te Pengolo dan Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mekeonà sikandin diyà te Pengolo amon megpetaga-taga sikandin te kedita te otaw te agpet den domateng se Pengolo. Megtabang se Espiritu Santo kandin iling te pegtabang din te telekeliwat te kagi din si Elias gebii. Pineokit te pegtoladà i Juan, megpèpiyaay se pedowan te menge telebatà. Megtoladà heman sikandin te menge otaw kenà egtolò te Timanem amon meg-inang dan te metòlid. Aw metoman iyan, meketagad den dan te pegdateng te Pengolo.” ");
INSERT INTO mbs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mig-insà si Zacarias, “Menonen ko se pegketaga-taga te metoman iyan? Eked besi iyan ketoman, so temoay a den, aw lokes den se esawa ko.” ");
INSERT INTO mbs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Timaba se anghil, “Siak si Gabriel, aw gayed a ipegsogò te Timanem. Insogò a din dini kamno amon ipetaga-taga ko kamno se mèpiya indan sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nayan, so wedà ka pemenal te inikagi ko gina diyà kamno, lekat seini meinang ka den bingelen aw omo lamig metoman se kagi ko, so ontò iyan metoman aw domateng se aldaw tapay pinemallì te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nayan, se menge otaw kidoen te lowà te dakel simbahan, migtagad dan pa te peglowà din, aw nepela dan so nenamay sikandin doton didalem. ");
INSERT INTO mbs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Peglowà din, wedà sikandin pekeikagi, aw netegahan dan te doen migpekità diyà kandin lekat te langit. Meneng gayed sikandin siminyas diyà kandan te belad din, so neomo. ");
INSERT INTO mbs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pegkepenga te pegpengibing i Zacarias kidoen te dakel simbahan, minolì sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Penga niyan te wedà kenamay, miglaman se esawa din si Elisabet. Dalem te lima se bolan, gayed sikandin mig-ogpà kidoen te balay. ");
INSERT INTO mbs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Minikagi sikandin, “Ontò mèpiya se tabang te Pengolo kanak, so neidowan a din. Eked a den lindoi te doma otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pegdateng te ikeenem se bolan te peglaman i Elisabet, insogò te Timanem se anghil si Gabriel doton te lonsod te Nasarit sakop te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Doen laga kidoen si Maria. Telesalà dan si Jose sebad bowad-bowad te selotan gebii si David. ");
INSERT INTO mbs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Dimoton si Gabriel ki Maria aw minikagi, “Doen keluba nikaw. Ontò ka neidowan te Timanem aw gayed ka din eg-ipaten.” ");
INSERT INTO mbs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meneng pegdineg i Maria te inikagi te anghil, ontò sikandin migkebulung. Mig-aneng-aneng sikandin aw eden se kedegdagan niyan. ");
INSERT INTO mbs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Minikagi heman se anghil, “Maria, ikà egkelemitan, so pinemallì ka te Timanem amon tebangan ka din. ");
INSERT INTO mbs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Meglaman ka, aw tebawan ka te batà meama. Ingedanan no se batà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Melangkaw sikandin, aw doen gulal din Batà te Timanem Melangkaw. Ipelowan sikandin te Timanem iling te peglowan te kemonaan din si David gebii. ");
INSERT INTO mbs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Lomowan sikandin diyà te kedita te bowad-bowad i Jacob te wedad temanan. Wedad palos temanan te peglowan din.” ");
INSERT INTO mbs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Minikagi si Maria, “Menonen lay iyan? So wedà a pa lumun layok te meama.” ");
INSERT INTO mbs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Timaba se anghil, “Domateng se Espiritu Santo kamno, aw ketebangan ka te tolos te Timanem. Yan se doun te menimanem se batà tomebaw kamno, aw sikandin se Batà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nayan, se inayen no si Elisabet, pengkey wedà sikandin pegbatà aw lokes den, meneng miglaman den te enem pa se bolan. ");
INSERT INTO mbs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wedad palos eked kebatog te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Minikagi si Maria, “Na, gayed a egtolò te Timanem. Mepakay aw meinang diyà kanak se inikagi nikaw.” Penga niyan, nesayo se anghil. ");
INSERT INTO mbs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Penga niyan te wedà kenamay, nesayo si Maria aw mig-ayas doton te bontod taman te sebad lonsod sakop te probinsya te Judiya. ");
INSERT INTO mbs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pegdateng din doton, nenayit te balay te emayen din si Zacarias aw timawal ki Elisabet. ");
INSERT INTO mbs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pegdineg i Elisabet te tawal din, miniwal se batà kidoen te getek din, aw dimateng se Espiritu Santo diyà ki Elisabet. ");
INSERT INTO mbs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Timawal sikandin te dakel se kagi din, “Diyà te kedita te bayi, sikona se binegayan te Timanem te ontò dakel keluba. Begayan din heman te keluba se batà tomebaw diyà kamno. ");
INSERT INTO mbs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nepela a so pengkey sikona se inay te Pengolo ko, meneng limaoy ka kanak. ");
INSERT INTO mbs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pegdineg ko te kagi no, miniwal se batà kidoen te getek ko tandà te luba din. ");
INSERT INTO mbs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Doen den keluba nikaw, so nemenal ka te metoman se kagi ingkeliwat diyà kamno lekat te Pengolo.” ");
INSERT INTO mbs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Penga niyan, minikagi si Maria, “Ipegduyun ko se Pengolo, ");
INSERT INTO mbs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aw ontò neluba se pedowan ko tandà te Timanem egpelowà kanak, ");
INSERT INTO mbs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","so pengkey ontò a medanà diyà kandin, meneng neeneng-enengan a din. Yan se doun te mikagi se kedita te otaw te binegayan a te Timanem te ontò dakel keluba, ");
INSERT INTO mbs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","so ontò mèpiya se ininang te Timanem metolos diyà kanak. Ontò sikandin metòlid. ");
INSERT INTO mbs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lekat te ketebò te keneyonan lamig te temanan, gayed din egkeidowan se kedita te otaw egsagman aw egtolò kandin. ");
INSERT INTO mbs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ipetaga-taga din te metolos sikandin pineokit te eg-inangen din. Ipekadas din se menge otaw eg-aneng-aneng te melangkaw dan. ");
INSERT INTO mbs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ebaten din se melangkaw selotan lekat te onsedanan dan te peglowan, aw inangen din melangkaw se menge otaw medanà. ");
INSERT INTO mbs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Begayan din se otaw sagkep te mèpiya tabang, meneng ipekesayo din se otaw meyaman te wedad ibegay kandan. ");
INSERT INTO mbs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tebangan din kidon menge bowad-bowad i Israel pinemallì din, so eked din palos kelibeli se pakang din diyà te menge kemonaan tadon te gayed din keidowan si Abraham aw menge bowad-bowad din te wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nayan, mig-ogpà si Maria diyà ki Elisabet taman te menge telo se bolan, aw penga niyan minolì. ");
INSERT INTO mbs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nayan, pegdateng te aldaw te pegpetebaw i Elisabet, timebaw se batà din meama. ");
INSERT INTO mbs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pegdineg te menge kedomaan din aw menge simbalay din kenyan, neluba dan heman so ontò sikandin neidowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pegdateng te ikewalo te aldaw lekat te pegtebaw din, netipon dan amon tolien aw ingedanan se batà. Ibeg dan ingedanan heman sikandin ki Zacarias, onawa te ngadan te amay din. ");
INSERT INTO mbs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Meneng minikagi si Elisabet, “Eked iyan kepakay, so ingedanan sikandin ki Juan.” ");
INSERT INTO mbs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Minikagi dan, “Meneng wedad palos kedomaan no iningedanan kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Penga niyan, siminyas dan diyà ki Zacarias bingelen pa aw eden se ibeg din iingadan. ");
INSERT INTO mbs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Siminyas heman sikandin aw nemoyò te solatan, aw insolat din se kagi, “Ingedanan sikandin ki Juan.” Ontò nepela se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pegketà negolian se pegkeomo din aw nekeikagi aw dimuyun sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nelemitan se kedita te simbalay dan. Ontò iyan nedengeg kidoen te menge bontod doton te Judiya, so yan se pigsempetanen dan. ");
INSERT INTO mbs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Neeneng-enengan dan se dinineg dan, aw netegahan dan te meinang medengeg se batà sìyan, so egdomaan sikandin te Pengolo metolos. ");
INSERT INTO mbs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nayan, dimateng se Espiritu Santo diyà ki Zacarias, aw ingkeliwat din se kagi te Timanem, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Iduyun se Pengolo tadon Timanem egseligan te kedita tadon menge bowad-bowad i Israel, so doen isogò din megpelowà kenitadon menge sakop din, aw imetayan sikandin iselilin kenitadon. ");
INSERT INTO mbs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Doen isogò te Timanem metolos megpelowà kenitadon, sìyan bowad-bowad i David egtolò te Timanem gebii. ");
INSERT INTO mbs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yan se impakang te Timanem gebii pineokit te menge telekeliwat te kagi din, so minikagi sikandin ");
INSERT INTO mbs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","te tebangan kidon din amon mekelowà kidon lekat te belad te poon tadon. ");
INSERT INTO mbs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Metoman kidon din keidowan, so yan se impakang din diyà te menge kemonaan tadon. Eked din kelibeli se impakang din gebii, ");
INSERT INTO mbs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","so ontò migpakang diyà te kemonaan tadon si Abraham ");
INSERT INTO mbs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","te ipelowà kidon din lekat te belad te menge poon tadon, amon mekesimba kidon diyà kandin te wedad kelemitanan. ");
INSERT INTO mbs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ibeg din menimanem kidon aw metòlid se inangen tadon diyà kandin dalem te peg-ogpà tadon dini te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nayan, sikona batà ko, meinang ka telekeliwat te kagi te Timanem melangkaw. Mekeonà ka doton te menge otaw amon meketagad dan te pegdateng te Pengolo, ");
INSERT INTO mbs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","so sikona se megpetaga-taga diyà te menge Judiyo te ipelowà din se menge sakop din lekat te pelumun aw pegwedaden din se salà tadon. ");
INSERT INTO mbs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yan se inangen te Timanem so gayed egkeido aw dakel se pedowan din. Iling te peglibtak te aldaw se pegdateng din amon megpelowà kenitadon, ");
INSERT INTO mbs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","so manyag sikandin diyà kenitadon pengkey iling kidon te otaw eg-ogpà diyà te kengitngitan aw nelemitan te kemetayun, amon ipeokit kidon din kidoen te dalan pesalo doton te kelinaw.” ");
INSERT INTO mbs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Timilles si Juan aw ontò sikandin egkeseligan. Pegkedakel din, mig-ogpà sikandin kidoen te kebigtilan lamig te aldaw te pegpekità din diyà te menge bowad-bowad i Israel. ");
INSERT INTO mbs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nayan, dalem te peglowan i Cesar Augusto doton te Roma, doen impunù din te keilangan megpelista se kedita te otaw nesakop te gobirno te Roma. ");
INSERT INTO mbs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yan se tagnà pegpelista te ngadan, aw ininang iyan dalem te peggobirnador i Cirenio kidoen te Sirya. ");
INSERT INTO mbs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Migsiolì se kedita te otaw doton te lonsod te kandan kemonaan amon megpelista dan te ngadan. ");
INSERT INTO mbs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nayan, se selotan gebii si David, yan se kemonaan i Jose, aw yan se doun te nesayo si Jose lekat te Nasarit sakop te probinsya te Galiliya aw dimoton te probinsya te Judiya taman te lonsod te Bitlihim, so yan se lonsod tinikedowan i David. ");
INSERT INTO mbs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yan se dinotonan te didowa dan si Maria amon megpelista si Jose. Mebedes den se salà din si Maria. ");
INSERT INTO mbs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dalem pa te kidoen dan te Bitlihim, dimateng se aldaw te pegtebaw te batà din. ");
INSERT INTO mbs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yan timebaw se penganay batà din meama. Linempingan din se batà, aw impeibat din diyà te kènanan te ayam-ayam kidoen te kelokob, so wedad keombaan dan doton te balay eg-ogpaan te mepanaw. ");
INSERT INTO mbs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nayan, medapag te lonsod te Bitlihim, doen menge telediyaga migpolaw se egtonggò te menge ayam-ayam karniro doton te tanà doen sagbet. ");
INSERT INTO mbs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pegketà migpekità se anghil insogò te Pengolo diyà kandan, aw doen minanyag diyà kandan lekat te Pengolo. Ontò dan nelemitan. ");
INSERT INTO mbs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Meneng minikagi se anghil, “Ikà niyo egkelemitan. Na, doen den ikegiyen ko diyà kenyo aw ontò ini mèpiya, so mekebegay te keluba diyà te kedita niyo. ");
INSERT INTO mbs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Doen timebaw gina seini kidoen te Bitlihim. Sikandin se Pengolo si Cristo megpelowà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Seini se pengilala amon ketegahan niyo te benal se inikagi ko kenyo. Kitaen niyo se batà linempingan aw impeibat kidoen te kènanan te ayam-ayam.” ");
INSERT INTO mbs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pegketà kinità dan se ontò medita anghil lekat te langit timaking kandin. Dimuyun dan te Timanem, kagi dan, ");
INSERT INTO mbs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Iduyun tadon den se Timanem doton diatas te langit. Begayan din te kelinaw te pedowan se otaw egkelubahan din dini te tanà.” ");
INSERT INTO mbs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Peg-olì te menge anghil doton te langit, gayed migpebelaw-belaway se telediyaga, kagi dan, “Domoton kidon den te Bitlihim amon kitaen tadon se neinang seini, sìyan impetaga-taga te Pengolo diyà kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Penga niyan, mig-ayas dan doton aw kimità dan ki Maria aw si Jose, aw kinità dan heman se batà impeibat kidoen te kènanan te ayam-ayam. ");
INSERT INTO mbs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pegkità dan kandan, in-indan dan se inikagi te anghil tepad te batà sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nepela se kedita te otaw dimineg te in-indan te menge telediyaga. ");
INSERT INTO mbs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meneng si Maria, insawol din se kedita te kagi dan diyà te pedowan din, aw gayed mig-aneng-aneng kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Penga niyan, minolì se telediyaga, aw gayed dan induyun se Timanem tandà te kedita te dinineg aw kinità dan, so netoman den se inikagi te anghil kandan. ");
INSERT INTO mbs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pegdateng te ikewalo te aldaw lekat te pegtebaw din, tinolì sikandin aw iningedanan ki Jesus, so yan se ngadan inikagi te anghil te wedà pa peglaman se inay din. ");
INSERT INTO mbs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dimateng se aldaw, dimoton si Jose aw si Maria te Jerusalem amon tomolò dan te punù ingkeliwat i Moises tepad te bayi kaling egtebawan. Inibing dan heman se batà si Jesus amon ibegay sikandin diyà te Pengolo, ");
INSERT INTO mbs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","so doen punù impekeliwat te Pengolo te keilangan ibegay diyà te Timanem se batà meama tagnà tomebaw. ");
INSERT INTO mbs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dimoton dan te dakel simbahan amon memegay dan te ibowang diyà te Timanem, so timolò dan te punù impekeliwat te Pengolo te keilangan ibegay se didowa tokmo aw kenà didowa selepati dedeitek pa. ");
INSERT INTO mbs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nayan, doen sebad tege Jerusalem si Simeon. Eg-inang sikandin te metòlid, aw egtolò heman te Timanem. Gayed sikandin egpeliman te megpelowà se Timanem te menge bowad-bowad i Israel. Eg-ogpaan sikandin te Espiritu Santo, ");
INSERT INTO mbs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aw impetaga-taga te Espiritu Santo kandin te eked sikandin kematay singed aw onà din kitaen se Misiyas isogò te Pengolo. ");
INSERT INTO mbs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Inibing te Espiritu Santo si Simeon doton te dakel simbahan kidoen te Jerusalem. Aldaw sìyan, inibing heman si Jesus te amay aw inay din doton te dakel simbahan amon tomolò dan te punù ingkeliwat i Moises tepad te deitek batà. ");
INSERT INTO mbs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pegkità i Simeon kandan, inabat din se batà aw inolid din. Penga niyan, dimuyun sikandin te Timanem, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pengolo ko, mepakay den diyà kanak aw meg-etod a aw matay a den, so netoman den se pakang no kanak, ");
INSERT INTO mbs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","so ontò a den kimità te insogò no megpelowà kenami. ");
INSERT INTO mbs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sikandin se ipekità no diyà te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sikandin se mekelowa te kengitngit kidoen te pedowan te kedita te otaw kenà Judiyo, aw sikandin se megpetaga-taga diyà kenami menge bowad-bowad i Israel pinemallì no te ontò ka melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nayan, se amay aw inay te batà, ontò dan nepela te inikagi i Simeon tepad te batà dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Migtawal-tawal si Simeon te ketebangan dan te Timanem, aw minikagi sikandin diyà te inay te batà si Maria, “Na, meinang se batà seini pengilala kitaen te medita bowad-bowad i Israel. Aw komità dan kandin, medita se otaw komulu kandin aw ipelumun dan, meneng medita se doma otaw somalig diyà kandin aw mekelowà dan lekat te pelumun, ");
INSERT INTO mbs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","so ipetaga-taga din aw eden se aneng-aneng te kedita te otaw. Pengkey sikona, Maria, ontò ka kelimahan, so iling te dogsengen se posong nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Doen heman bayi egkeliwat te kagi te Timanem kidoen te dakel simbahan ngadan din si Ana. Si Panuel se ngadan te amay din, sakop te pongan iningedanan Aser, so si Aser se kemonaan dan. Nengognan si Ana te pito se omay, aw penga niyan nebalo. Ontò den lokes, so kewelowan teg epat se omay din. Egdoton sikandin te dakel simbahan, so egsimba sikandin te aldaw aw delem, aw migpowasa, aw migtawal-tawal. ");
INSERT INTO mbs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dalem pa te minikagi si Simeon diyà ki Maria, dimateng si Ana kidoen kandan, aw migpesiontong diyà te Timanem. Mig-indan heman sikandin tepad te batà diyà te kedita te otaw egpeliman te megpelowà se Timanem te menge Judiyo. ");
INSERT INTO mbs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nayan, pegtoman i Jose aw si Maria te kedita te punù te Pengolo ingkeliwat i Moises tepad te batà kaling timebaw, minolì dan doton te lonsod te Nasarit kidoen te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Timilles se batà, aw migketesan, aw migkebiyasa, so egtebangan sikandin te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nayan, kelikit te omay, gayed egdoton se amay aw inay i Jesus te Jerusalem amon tomanod dan te Pista te Pegpelowà. ");
INSERT INTO mbs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sagwa sempolò teg dowa se omay i Jesus, nemista dan doton te Jerusalem, so yan se gayed dan eg-inangen. ");
INSERT INTO mbs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pegkepenga te pista, minolì dan, meneng mig-ogpà pa si Jesus kidoen te Jerusalem. Meneng wedà iyan ketegahi te amay aw inay din, ");
INSERT INTO mbs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","so eden dan aw timaking sikandin te menge doma dan kidoen te dalan. Minipanaw dan lamig meapon. Pegkeapon, nengemahà dan kandin kidoen te menge kedomaan dan aw menge doma otaw minipanaw. ");
INSERT INTO mbs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Meneng wedà dan kitai. Penga niyan, limikò dan doton te Jerusalem amon mengemahà dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te iketelo te aldaw, kinità dan sikandin kidoen te dakel simbahan doton te Jerusalem. Dimoma sikandin te menge menenoladà, aw nenenalan sikandin diyà kandan aw mig-insà heman diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nepela se kedita te otaw dimineg te inikagi din, so ontò biyasa, aw mèpiya heman se intaba din. ");
INSERT INTO mbs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pegkità te amay aw inay din kandin, ontò dan nepela. Minikagi se inay din, “Atò, eked kepakay se ininang no diyà kenami, so ontò kay netetana, aw nengemahà kay kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Minikagi si Jesus, “Nepela a so pinengemahà a niyo. Nepela a so wedà niyo ketegahi te keilangan dini a te balay te Amay ko.” ");
INSERT INTO mbs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Meneng wedà dan kelebeti se kedegdagan te inikagi din diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Penga niyan, timaking si Jesus kandan aw minolì doton te Nasarit, aw timolò te amay aw inay din. Si Maria, insawol din se kedita niyan diyà te pedowan din aw mig-aneng-aneng kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Timilles si Jesus aw migkebiyasa. Labi pa nelubahan te Timanem aw otaw. ");
INSERT INTO mbs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nayan, pegkenamay, dimateng se ikesempolò teg lima se omay te peglowan i Tiberio kidoen te Roma. Si Poncio Pilato se gobirnador kidoen te Judiya. Limowan si Herod kidoen te Galiliya, aw kedowa din si Felipe se limowan kidoen te Itorya aw Trakoniti. Limowan si Lisanias kidoen te Abilina. ");
INSERT INTO mbs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Si Anas aw si Caifas se ontò pengolo te dakel simbahan te Jerusalem. Dalem te peg-ogpà i Juan batà i Zacarias kidoen te kebigtilan, insogò sikandin te Timanem megtoladà te kagi din. ");
INSERT INTO mbs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yan se doun te miglegeb sikandin kidoen te kedepagan te wayeg te Jordan. Migtoladà sikandin te kedita te otaw te keilangan megselsel dan te salà aw bonyagan dan amon ipetaga-taga dan te pigwedad den te Timanem se salà dan. ");
INSERT INTO mbs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pegtoladà din kenyan, tinoman din se pakang tapay insolat kidoen te kagi te Timanem ingkeliwat i Isaias, “Dinegen niyo se otaw doton te kebigtilan, aw dakel se kagi din, ‘Pegpeketagad kaw te pegdateng te Pengolo. Peg-inang kaw te metòlid, so domateng sikandin.’ ");
INSERT INTO mbs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Peg-epengen se kedita te baog, aw inangen mepantal se kedita te bontod. Tòliden se dalan belegkong, aw inangen melenas se dalan megeled-geled. Keilangan iling kenyan se pegpeketagad niyo te kenyo pedowan, ");
INSERT INTO mbs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","aw komità se kedita te otaw te megpelowà se Timanem te otaw lekat te salà.” ");
INSERT INTO mbs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nayan, pegdineg te otaw te intoladà i Juan, medita dan se dimoton kandin amon bonyagan din dan. Minikagi si Juan, “Tay law. Iling kaw te memokan egkadas te apoy. Eked kaw pekelowà lekat te pelumun te Timanem te modi aldaw singed aw megselsel kaw. ");
INSERT INTO mbs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aw migselsel kaw den, petega-tegahi niyo iyan pineokit te eg-inangen niyo. Ikà niyo eg-aneng-aneng te eked kaw pelumuni so bowad-bowad kaw i Abraham. Eneng-enengi niyo se kagi ko seini. Pengkey se menge bato seini te lanto te tanà, mepakay iyan inangen te Timanem menge bowad-bowad i Abraham amon somelilin dan kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iling kaw te kayo agpet pilayen. Aw kenà mèpiya se pongo te kayo, pilayen iyan aw sonogen.” ");
INSERT INTO mbs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mig-insà se menge otaw, “Aw iling kay kenyan, eden lay se keilangan inangen day?” ");
INSERT INTO mbs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Timaba si Juan, “Seini se inangen niyo. Aw doen dowa saol niyo, begayi niyo se sebad diyà te otaw wedad saol din. Aw doen kànen niyo, ilasi niyo se doma otaw wedad kànen din.” ");
INSERT INTO mbs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Doen heman menge iskribinti dimoton ki Juan amon bonyagan din dan. Minikagi dan, “Sir, eden lay se keilangan inangen day?” ");
INSERT INTO mbs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Timaba si Juan, “Ikà niyo egpengabat te kwarta labi pa dakel diyà te impunù te gobirno.” ");
INSERT INTO mbs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Doen heman menge sondalo mig-insà diyà kandin, “Pengkey sikami, eden lay se keilangan inangen day?” Timaba si Juan, “Ikà niyo egleges te otaw amon mengabat kaw te kwarta dan. Ikà niyo heman egdimanda pineokit te kebolalaw amon begayan kaw te kwarta. Meneng pengkey eden se itandan te gobirno diyà kenyo, yan se keilangan kelubahan niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nayan, pegdineg te menge otaw te intoladà i Juan, egdowa-dowa se aneng-aneng dan aw sikandin se Misiyas pinelimanan dan. ");
INSERT INTO mbs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Meneng minikagi si Juan, “Egpemonyag a pineokit te wayeg. Meneng doen pa domateng labi pa melangkaw diyà kanak. Kenà botong se kelangkaw ko amon megtelaban a kandin pengkey meglebad a te sepatos din, so ontò sikandin melangkaw diyà kanak. Sikandin se memonyag kenyo pineokit te Espiritu Santo aw pineokit te apoy. ");
INSERT INTO mbs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iling sikandin te otaw egpepalid te trigo eggiyeken din, amon isawol din te buun aw ibingen din doton te balay. Meneng se ohot aw tipig, yan se sonogen din te apoy kenà egkepadeng.” ");
INSERT INTO mbs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iling kenyan se pegtoladà i Juan te Mèpiya Indan diyà te kedita te otaw, aw minikagi diyà kandan te keilangan tomolò dan te intoladà din. ");
INSERT INTO mbs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Se otaw limowan kidoen te Galiliya, yan si Herod. Sinila sikandin i Juan so medita se ininang din medaet. Nengagaw heman sikandin te nayi din si Herodias. Peg-inang din kenyan, simila si Juan kandin, ");
INSERT INTO mbs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","aw labi pa medaet se ininang i Herod, so impekeleboso din si Juan. ");
INSERT INTO mbs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Meneng dalem pa te pegbonyag i Juan te kedita te otaw, migpebonyag heman si Jesus. Penga niyan, dalem te pegtawal-tawal i Jesus, neowang se langit, ");
INSERT INTO mbs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aw kinità dan se Espiritu Santo migpedanà diyà kandin iling te bawa te selepati. Dinineg dan heman se kagi te Timanem lekat te langit, “Sikona se Batà ko. Dakel se pedowan ko kamno, aw ontò a neluba kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pegtebò i Jesus te pegtoladà din, menge ketlowan se omay din. Neeneng-enengan te kedita te otaw te si Jesus se ontò batà i Jose. Si Jose se batà i Heli. ");
INSERT INTO mbs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli se batà i Matat. Si Matat se batà i Levi. Si Levi se batà i Melki. Si Melki se batà i Jana. Si Jana se batà i Jose. ");
INSERT INTO mbs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose se batà i Matatias. Si Matatias se batà i Amos. Si Amos se batà i Nahum. Si Nahum se batà i Esli. Si Esli se batà i Nagai. ");
INSERT INTO mbs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai se batà i Maat. Si Maat se batà i Matatias. Si Matatias se batà i Semei. Si Semei se batà i Jose. Si Jose se batà i Joda. ");
INSERT INTO mbs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda se batà i Joana. Si Joana se batà i Resa. Si Resa se batà i Sorobabel. Si Sorobabel se batà i Salatiel. Si Salatiel se batà i Neri. ");
INSERT INTO mbs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri se batà i Melki. Si Melki se batà i Addi. Si Addi se batà i Cosam. Si Cosam se batà i Elmodam. Si Elmodam se batà i Er. ");
INSERT INTO mbs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er se batà i Josue. Si Josue se batà i Eliezer. Si Eliezer se batà i Jorim. Si Jorim se batà i Matat. Si Matat se batà i Levi. ");
INSERT INTO mbs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi se batà i Simeon. Si Simeon se batà i Juda. Si Juda se batà i Jose. Si Jose se batà i Jonan. Si Jonan se batà i Eliakim. ");
INSERT INTO mbs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim se batà i Melea. Si Melea se batà i Mainan. Si Mainan se batà i Matata. Si Matata se batà i Natan. Si Natan se batà i David. ");
INSERT INTO mbs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David se batà i Isai. Si Isai se batà i Obed. Si Obed se batà i Boos. Si Boos se batà i Salmon. Si Salmon se batà i Naason. ");
INSERT INTO mbs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason se batà i Aminadab. Si Aminadab se batà i Aram. Si Aram se batà i Arni. Si Arni se batà i Esrom. Si Esrom se batà i Fares. Si Fares se batà i Juda. ");
INSERT INTO mbs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda se batà i Jacob. Si Jacob se batà i Isaac. Si Isaac se batà i Abraham. Si Abraham se batà i Tare. Si Tare se batà i Nakor. ");
INSERT INTO mbs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nakor se batà i Serug. Si Serug se batà i Ragaw. Si Ragaw se batà i Peleg. Si Peleg se batà i Eber. Si Eber se batà i Sala. ");
INSERT INTO mbs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala se batà i Cainan. Si Cainan se batà i Arfaksad. Si Arfaksad se batà i Sem. Si Sem se batà i Noe. Si Noe se batà i Lamek. ");
INSERT INTO mbs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamek se batà i Matusalen. Si Matusalen se batà i Enok. Si Enok se batà i Jared. Si Jared se batà i Mahalaleel. Si Mahalaleel se batà i Cainan. ");
INSERT INTO mbs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan se batà i Enos. Si Enos se batà i Set. Si Set se batà i Adam. Si Adam se batà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Egbeyà-beyaan si Jesus te Espiritu Santo. Pegkesayo din lekat te wayeg te Jordan, inibing sikandin te Espiritu Santo doton te kebigtilan. ");
INSERT INTO mbs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mig-ogpà sikandin kidoen taman te kepatan se aldaw, aw binoyo i Satanas. Peg-ogpà din kidoen, wedad palos kinaen din, aw penga niyan binallos sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Minikagi si Satanas, “Aw ontò ka Batà te Timanem, inangi pan se bato seini pineokit te tolos no amon doen kànen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Meneng minikagi si Jesus, “Eked a, so doen kagi te Timanem insolat, ‘Kenà olò kànen se keilangan te otaw amon eked kematay.’ ” ");
INSERT INTO mbs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Penga niyan, inibing i Satanas si Jesus doton te melangkaw bontod, aw te wedà kenamay, impekità din kandin se kedita te ogpeanan te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Minikagi si Satanas, “Inangen ta otaw lomowan diyà te kedita te otaw kidoen, aw begayan ta heman te kèpiya niyan, so siak se eg-awid te kedita niyan diyà te belad ko, aw mekebegay a kenyan diyà te pengkey sinu se pemellien ko. ");
INSERT INTO mbs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aw simbahen a no, ibegay ko kamno se kedakel niyan.” ");
INSERT INTO mbs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Meneng minikagi si Jesus, “Eked a, so doen kagi te Timanem insolat, ‘Timanem se Pengolo niyo aw sikandin se keilangan simbahen niyo, so sikandin olò se mepakay tekingan niyo.’” ");
INSERT INTO mbs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Penga niyan, inibing i Satanas si Jesus doton diatas te dakel simbahan te Jerusalem. Minikagi si Satanas, “Nayan, aw ontò ka Batà te Timanem, kahang ka doton te tanà. ");
INSERT INTO mbs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Eked ka elegi, so doen kagi te Timanem insolat, ‘Isogò te Timanem se menge anghil amon meg-ipat dan kamno.’ ");
INSERT INTO mbs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Doen heman kagi te Timanem insolat, ‘Ewidan ka te menge anghil, aw engaten ka dan amon eked ka kesongkol te bato.’” ");
INSERT INTO mbs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Meneng timaba si Jesus, “Eked a, so doen kagi te Timanem insolat, ‘Ikà niyo egtandà te Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nayan, pegketaga-taga i Satanas te eked keboyo si Jesus aw wedad den doma iboyo din kandin, nesayo sikandin aw migtagad te doma aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ontò egbeyà-beyaan te Espiritu Santo si Jesus. Dimoton sikandin te probinsya te Galiliya, aw dimineg se kedita te otaw kidoen te dengeg din. ");
INSERT INTO mbs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Timeped sikandin te menge simbahan te Judiyo amon megtoladà, aw induyun sikandin te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Penga niyan, minolì si Jesus doton te Nasarit. Yan se lonsod tinillesan din. Pegkesebado, dimoton sikandin te simbahan te Judiyo, so yan se ketanem din. Timindeg sikandin amon megbasa te kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Imbegay dan diyà kandin se libro insolat te telekeliwat te kagi te Timanem gebii si Isaias. Migbeka sikandin kenyan aw migbasa te kagi seini, ");
INSERT INTO mbs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dini kanak se Espiritu Santo, so pinemallì a din amon megtoladà a te Mèpiya Indan diyà te menge otaw sagkep. Insogò a din amon mikagi a diyà te menge otaw kineleboso te ipelowà den dan te Timanem. Insogò a heman amon mikagi a diyà te menge otaw bota te komità den dan. Insogò a din amon megpelowà a te kedita te otaw nelimahan, ");
INSERT INTO mbs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aw amon megpetaga-taga a te dimateng den se aldaw te ipekità te Pengolo se keido din.” ");
INSERT INTO mbs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Penga te pegbasa din kenyan, linolon din se libro aw in-olì din diyà te egpengibing te simbahan. Penga niyan, nenenoo si Jesus amon megtoladà. Penga niyan, netingen se kedita te otaw aw timengteng dan diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nayan, migtebò si Jesus migtoladà, kagi din, “Seini aldaw, netoman den se kagi te Timanem dinineg niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mig-aneng-aneng se kedita te otaw te mèpiya se kagi din, aw nepela dan kenyan so eden dan aw olò sikandin batà i Jose. ");
INSERT INTO mbs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Minikagi heman si Jesus, “Meibeg kaw besi megpeaneng-aneng kanak te eg-ikegiyen tadon, ‘Aw doktor ka, keilangan ipetaga-taga no iyan pineokit te pegbolong no te kamno pegkeotawun.’ Dinineg niyo den te doen menge kepelahan ininang ko doton te Kapirnaom, aw mikagi kaw besi heman diyà kanak te keilangan inangen ko heman se menge kepelahan dini te kanak probinsya. ");
INSERT INTO mbs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Meneng eneng-enengi niyo se kagi ko seini. Kenà egsegmanen se telekeliwat te kagi te Timanem kidoen te kandin probinsya. ");
INSERT INTO mbs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Seini se kebenalan ipeaneng-aneng ko kenyo. Gebii dalem te pegkeliwat i Elias te kagi te Timanem, wedad palos odan taman te telo se omay aw enem se bolan, aw doen heman ontò medaet bayil dini te kedita te ogpeanan te kemonaan tadon. Pengkey medita se bayi balo nelimahan dini te Judiya, ");
INSERT INTO mbs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","meneng kenà dan se sinogoan te Timanem ki Elias, so insogò din si Elias megtabang te bayi balo kenà Judiyo eg-ogpà kidoen te Saripta sakop te Sidon. ");
INSERT INTO mbs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iling heman kenyan se neinang dalem te pegkeliwat i Eliseo te kagi te Timanem. Pengkey medita se Judiyo pigtompig, meneng kenà dan se pinegolian din, so olò din pinegolian se kenà Judiyo si Naaman sakop te Sirya.” ");
INSERT INTO mbs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Se otaw netipon kidoen, yan se menge Judiyo. Pegdineg dan te egkeidowan te Timanem se menge otaw kenà Judiyo, yan se doun te neopal se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Penga niyan, timindeg dan aw impelowà dan sikandin lekat te lonsod dan. Kidoen diatas te bontod se lonsod dan. Yan inibing dan si Jesus doton te pangpang niyan amon idagdag dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Meneng minokit si Jesus diyà te tengà-tengà te otaw netipon, aw nesayo sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nayan, dimoton si Jesus te lonsod te Kapirnaom sakop te probinsya te Galiliya. Pegkesebado, migtoladà sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ontò nepela se kedita te otaw dimineg te intoladà din, so tinekingan si Jesus te tolos. ");
INSERT INTO mbs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kidoen te simbahan te Judiyo, doen otaw dinetengan te bosaw. Timawal sikandin aw dakel se kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tay, Jesus tege Nasarit. Ikà egsamok kenami. Eked kay keibeg aw pegbàtan kay nikaw. Netegahan ko aw sinu ka. Sikona se metòlid otaw insogò te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Meneng migsagda si Jesus te bosaw, kagi din, “Kepenek ka. Lowà ka den lekat kandin.” Penga niyan, imbontog te bosaw se otaw sìyan aw limowà lekat kandin, meneng wedà elegi se otaw. ");
INSERT INTO mbs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nepela se kedita te otaw, aw migpebelaw-belaway dan, “Tay law. Sebad se ipegtoladà din. Ontò sikandin metolos, so aw megpelowà sikandin te menge bosaw, egtolò dan kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Penga niyan, ontò nedengeg si Jesus kidoen te kedita te ogpeanan medapag doton. ");
INSERT INTO mbs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pegkesayo i Jesus lekat te simbahan te Judiyo, dimoton sikandin te balay i Simon iningedanan din ki Pedro. Pegdateng din doton, ontò netigdaan se ogangan i Pedro bayi piglegenaw, aw nemoyò dan te tabang din. ");
INSERT INTO mbs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Penga niyan, dimoton si Jesus kandin, aw migpetunung te keinit te lawa din. Pegketà migkèpiya sikandin, aw minenaw amon meg-inang te kànen i Jesus aw menge doma din. ");
INSERT INTO mbs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pegsallep te aldaw, inibing dan doton ki Jesus se kedita te doma dan doen medita kemolò te mesakit. Pinemàdan din se kedita dan aw negolian dan. ");
INSERT INTO mbs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Doen heman medita otaw dinetengan te bosaw inibing doton ki Jesus. Peglowà te bosaw, timawal dan, “Sikona se Batà te Timanem.” Meneng sinagda i Jesus te menge bosaw amon eked dan ikagi, so netegahan dan te sikandin se Misiyas insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pegkeiselem niyan, nesayo si Jesus aw dimoton te wedad otaw eg-ogpà amon megtawal-tawal. Meneng nengemahà se medita otaw kandin. Pegkità dan kandin, ontò dan peden sikandin temengan. ");
INSERT INTO mbs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Meneng minikagi si Jesus, “Keilangan domoton a heman te doma lonsod amon megtoladà a kandan te Mèpiya Indan tepad te peglowan te Timanem, so yan se doun te insogò a din.” ");
INSERT INTO mbs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Penga niyan, migtoladà si Jesus kidoen te menge simbahan te Judiyo doton te kedita te ogpeanan dan. ");
INSERT INTO mbs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nayan, doen aldaw timindeg si Jesus kidoen te kilid te lanaw iningedanan Genesarit. Migpesegsegay se kedita te otaw amon megpedapag dan diyà kandin, so ibeg dan domineg te kagi te Timanem itoladà din. ");
INSERT INTO mbs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Doen dowa belangay kinità din kidoen te kilid te lanaw, meneng tinenanan iyan te otaw egpemokot, so migbollaw dan te pokot. ");
INSERT INTO mbs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Penga niyan, minalin si Jesus doton te belangay i Simon, aw nemoyò te ipelepaw din iyan kidoen te lanaw medapag te kilid. Penga niyan, nenenoo si Jesus kidoen te belangay aw migtoladà te menge otaw kidoen te tanà. ");
INSERT INTO mbs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Penga te pegtoladà din, minikagi si Jesus diyà ki Simon, “Pegpelawod ka aw penagdag kaw te pokot amon doen meabat.” ");
INSERT INTO mbs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Meneng timaba si Simon, “Pengolo, nemokot kay timayod te delem, meneng wedad palos neabat day. Meneng so simogò ka, megdagdag kay te pokot.” ");
INSERT INTO mbs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pegdagdag dan te pokot, nesàban dan se dakel gapang te ikan. Agpet den nelisì se pokot so ontò medita se ikan neabat. ");
INSERT INTO mbs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Penga niyan, kinapay dan se menge otaw kidoen te doma belangay amon megtelaban kandan. Pegdateng dan doton, miglolan dan te ikan lamig agpet den meteled se didowa belangay so nepenò te ikan. ");
INSERT INTO mbs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Si Simon, se doma ngadan din si Pedro, pegkità din kenyan, limongken diyà ki Jesus aw minikagi, “Pengolo, kesayo ka lekat kanak, so nelegeb a te salà.” ");
INSERT INTO mbs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yan se inikagi din so ontò nepela si Pedro aw menge doma din, so ontò medita se ikan neabat dan. ");
INSERT INTO mbs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nepela heman se kedomaan din kidoen te doma belangay si Santiago aw si Juan, didowa batà i Sebedeo. Minikagi si Jesus diyà ki Simon, “Ikà egkelemitan. Lekat seini, kenà ikan se meabat no, meneng otaw den se ibingen no diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pegdong dan te belangay, timanan dan te kedita, aw timaking dan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sagwa kidoen si Jesus te sebad lonsod, kinità din se otaw nelegeb se lawa te tompig. Pegkità din ki Jesus, limongken diyà kandin aw nemoyò, “Sir, aw doen ibeg no, netegahan ko te mekebatog ka megpegolì kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nemaed si Jesus kandin, aw minikagi, “Meibeg a. Kegolian ka.” Pegketà, negolian sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Migpunù si Jesus kandin te wedad palos otaw mepakay indanan din. Minikagi heman sikandin, “Doton ka te pengolo te simbahan aw pekitai se lawa no diyà kandin. Penga niyan, begayi se ibowang no iling te impunù i Moises amon ketegahan te kedita te otaw te negolian ka den.” ");
INSERT INTO mbs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Meneng labi pa medita se otaw dimineg te dengeg i Jesus, aw yan se doun te ontò medita se otaw dimoton kandin amon menenalan dan kandin aw amon kegolian dan. ");
INSERT INTO mbs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Meneng melikit egdoton si Jesus te kebigtilan amon megtawal-tawal. ");
INSERT INTO mbs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nayan, pegtoladà i Jesus, nenenalan kandin se menge Parisiyo, aw doen heman menge menenoladà te punù ingkeliwat i Moises. Lekat dan te medita ogpeanan kidoen te probinsya te Galiliya aw Judiya, aw lekat te lonsod te Jerusalem. Doen tolos i Jesus lekat te Timanem amon megpegolì te menge otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wedà kenamay, dimateng se otaw neningga te otaw kenà egpekeiwal. Ibeg dan ipeawop sikandin diyà te balay amon ibingen doton ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Meneng wedad okitan dan so ontò medita se otaw netipon. Yan nenayit dan doton te atep te balay sìyan, so pantal se atep niyan. Inowang dan se ketengà te atep, aw intonton dan sikandin sipat inibatan din kidoen te tengà-tengà te otaw medapag ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pegkità i Jesus te ontò dan simalig diyà kandin, minikagi sikandin, “Elew, pigwedad den se salà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Meneng migpebelaw-belaway se menge Parisiyo aw menenoladà te punù ingkeliwat i Moises, kagi dan, “Eked kepakay se inikagi din sìyan. Migtompuyus sikandin te Timanem, so wedad mekebatog megwedad te salà meneng olò Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Meneng netegahan i Jesus aw eden se pigbelaw-belaway dan, aw minikagi sikandin, “Nengà lay egdowa-dowa se aneng-aneng niyo? ");
INSERT INTO mbs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mola megpelingo-lingo se otaw megwedad te salà. Meneng eked pekebatog se otaw megpegolì te otaw kenà egpekeiwal singed aw doen tolos te Timanem diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Meneng so Timanem a Migpekeotaw, ipekità ko den kenyo te mekebatog a megwedad te salà te otaw dini te tanà.” Penga niyan, minikagi si Jesus diyà te otaw kenà egpekeiwal, “Enaw ka. Loloni se inibatan no, aw olì ka den.” ");
INSERT INTO mbs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pegketà, dalem te pegtengteng te kedita te otaw diyà kandin, minenaw, aw inibing din se inibatan din, aw minolì sikandin egduyun te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ontò nepela se kedita dan, aw induyun dan se Timanem. Nelemitan dan aw migpebelaw-belaway dan, “Sebad indà se kinità tadon seini.” ");
INSERT INTO mbs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nayan, pegkesayo i Jesus lekat kidoen, doen iskribinti si Levi nenenoo kidoen te opisina din. Pegkità i Jesus kandin, minikagi, “Taking ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yan timindeg si Levi, aw tinenanan din se kedita, aw timaking sikandin ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wedà kenamay, mig-inang si Levi te dakel kànen kidoen te balay din te pegsagman din ki Jesus. Medita heman se iskribinti aw doma otaw kimaen doma dan. ");
INSERT INTO mbs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Meneng doen menge Parisiyo aw menenoladà te punù ingkeliwat i Moises simila te menge tinoledaan i Jesus, kagi dan, “Medaet iyan so kimaen kaw doma te mededaet otaw, menge iskribinti aw doma otaw nelegeb te salà.” ");
INSERT INTO mbs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pegketaga-taga i Jesus te insila dan, minikagi sikandin, “Kenà otaw wedad mesakit se bolongen te doktor, meneng otaw doen mesakit se bolongen din. ");
INSERT INTO mbs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Insogò a dini kenà amon tewalen ko se otaw eg-aneng-aneng te metòlid se eg-inangen dan, meneng insogò a amon indanan ko se otaw mekesesalà te keilangan megselsel dan.” ");
INSERT INTO mbs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Doen heman otaw minikagi diyà ki Jesus, “Melikit egpowasa se menge tinoledaan i Juan, aw egpowasa heman se menge tinoledaan te Parisiyo. Nengà lay kenà egpowasa se kamno menge tinoledaan?” ");
INSERT INTO mbs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Minikagi si Jesus, “Aw doen peipid, eked kepuluk se menge sigalak te meama peipiden dalem te kidoen pa sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Meneng doen aldaw domateng aw meabat lekat kandan se meama peipiden, aw yan se aldaw megpowasa dan so mepuluk dan.” ");
INSERT INTO mbs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mig-indan heman si Jesus te menge tegdeyanan tepad te kaling itoladà din, kagi din, “Aw doen kaling penenaktun, wedad otaw meglisì kenyan amon doen itompal te pepidit din, so aw yan se inangen din, kebàtan se kaling penenaktun, aw kenà onawa se batek te pepidit aw itompal kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aw meg-inang heman se otaw te bino, eked din soli se temek te paras diyà te solanan ininang lekat te kindal te kambing tapay linanit, so aw megbohak se temek, megbeto se solanan tapay linanit, aw eleg kebàtan se bino aw solanan niyan. ");
INSERT INTO mbs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yan keilangan isawol se temek inangen bino diyà te solanan kaling linanit. ");
INSERT INTO mbs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aw gayed eg-inem se otaw te tapay bino, eked sikandin keibeg te bino kaling ininang, so labi pa mèpiya se tapay.” ");
INSERT INTO mbs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nayan, Sebado se aldaw te peg-etod te menge Judiyo. Pegkesebado, minokit si Jesus aw menge tinoledaan din kidoen te kilid te pawà te trigo agpet den geniyen. Kimetel se menge tinoledaan din te oway te trigo, aw kinoso-koso dan iyan diyà te belad, aw kinaen dan, so binallos dan. ");
INSERT INTO mbs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Meneng minikagi se menge Parisiyo, “Doen punù ingkeliwat i Moises te keilangan eked pegterbaho se otaw te aldaw te peg-etod. Nengà lay wedà kaw tolò kenyan?” ");
INSERT INTO mbs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Timaba si Jesus, “Kenà medaet se ininang dan. Nelibelan niyo besi aw eden se insolat kidoen te kagi te Timanem tepad te ininang i David gebii. So binallos sikandin aw menge sondalo timaking kandin, ");
INSERT INTO mbs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","yan minawop sikandin diyà te balay te Timanem, aw kinaen din se pan imbegay diyà te Timanem. Yan heman se impekaen din diyà te menge doma din. Pengkey doen punù ingkeliwat i Moises te mepakay olò iyan kànen te menge pengolo te simbahan, meneng kenà medaet se ininang i David.” ");
INSERT INTO mbs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Minikagi heman si Jesus, “So siak se Timanem Migpekeotaw, mepakay aw siak se mikagi aw eden se mepakay inangen aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nayan, pegdateng te doma aldaw te peg-etod, dimoton si Jesus te simbahan te Judiyo, aw migtoladà. Doen otaw kidoen nekepis se belad din kowanan. ");
INSERT INTO mbs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Doen heman kidoen menge Parisiyo aw menenoladà te punù ingkeliwat i Moises. Nengemahà dan te idimanda dan tepad ki Jesus, aw yan se doun te gayed dan timengteng diyà kandin aw megpegolì sikandin te otaw doen mesakit te aldaw te peg-etod. ");
INSERT INTO mbs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Meneng netegahan i Jesus se aneng-aneng dan, aw minikagi diyà te otaw nekepis se belad, “Tindeg ka, aw diyà ka kanak.” Penga niyan, timolò se otaw ki Jesus aw dimoton kandin. ");
INSERT INTO mbs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Minikagi si Jesus diyà te otaw timengteng kandin, “Doen insà ko kenyo tepad te punù ingkeliwat i Moises. Eden lay se mepakay inangen tadon te aldaw te peg-etod? Meg-inang kidon lay te mèpiya, aw meg-inang kidon te medaet? Megtabang kidon lay te doma otaw, aw mengimatay kidon te doma?” ");
INSERT INTO mbs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Penga niyan, timengteng si Jesus diyà te kedita dan, aw minikagi diyà te otaw nekepis se belad, “Oladi se belad nikaw.” Pegtolò din, migkèpiya iyan. ");
INSERT INTO mbs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Meneng ontò neopal se menge Parisiyo aw menenoladà te punù. Yan migpebelaw-belaway dan aw menonen dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nayan, wedà kenamay, timikedeg si Jesus doton te bontod amon megtawal-tawal. Timayod sikandin te delem aw migtawal-tawal diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pegkeiselem, tinawal din se kedita te otaw tinoledaan din. Penga niyan, pinemallì din se sempolò teg dowa otaw megtelaban kandin, aw iningedanan din dan menge apostol. ");
INSERT INTO mbs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sikandan si Simon iningedanan i Jesus ki Pedro, aw kedowa din si Andres, aw si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO mbs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, aw si Santiago batà i Alfeo, aw si Simon meyseg, ");
INSERT INTO mbs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","aw si Judas batà te kesangay i Santiago, aw kesangay din si Judas Iscariote, sìyan migtolok ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nayan, timopang si Jesus tinekingan te menge tinoledaan pinemallì din, aw timindeg dan kidoen te tanà mepantal. Ontò medita se otaw gayed egtaking kandan, aw minakop diyà kandan se ontò medita otaw lekat te kedita te lonsod sakop te probinsya te Judiya, aw lekat te Jerusalem, aw pengkey lekat te Tiro aw Sidon medapag te dagat. Netipon se kedita dan amon menenalan ki Jesus, aw amon kegolian se mesakit dan. ");
INSERT INTO mbs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dimoton heman kandin se otaw dinetengan te bosaw aw migkèpiya dan. ");
INSERT INTO mbs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Migtelaman se kedita te otaw memaed kandin, so doen tolos din aw yan se doun te nekebatog sikandin migpegolì te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Penga niyan, timengteng si Jesus diyà te menge tinoledaan din aw minikagi, “Doen keluba te kedita niyo sagkep, so lomowan se Timanem diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Doen keluba te kedita niyo binallos seini, so mebesog kaw. “Doen keluba te kedita niyo nelidò seini, so sinelayen kaw te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Doen keluba te kedita niyo kebensihan te doma otaw, aw pemilangen, aw tompuyusen, aw tindàten tandà te pegtaking niyo kanak Timanem Migpekeotaw, ");
INSERT INTO mbs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","so egtindàten heman te kemonaan dan se menge telekeliwat te kagi te Timanem gebii. Aw yan se domateng diyà kenyo, keilangan ontò kaw meluba, so ontò mèpiya se ontong ibegay kenyo kidoen te langit. ");
INSERT INTO mbs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Meneng mekelelayò kaw meyeyaman, so doen den kelubahan niyo aw wedad pa ibegay diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Mekelelayò kaw menge otaw doen den kelidoan niyo seini, so bellosen kaw. “Mekelelayò kaw egkebebayat seini, so doen aldaw domateng aw mepuluk kaw aw megkelag kaw. ");
INSERT INTO mbs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mekelelayò kaw aw iduyun kaw te kedita te otaw, so induyun heman te kemonaan niyo se otaw migpelingo-lingo telekeliwat te kagi te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Meneng seini se kagi ko diyà te kedita niyo nenenalan kanak. Kedekeli niyo te pedowan se poon niyo. Inangi niyo se mèpiya diyà te otaw egkebensi kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pemoyò kaw diyà te Timanem te keidowan din se otaw egpenollon kenyo. Pegtawal-tawal kaw heman diyà kandin tepad te otaw egtompuyus kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aw sempaken kaw diyà te pisngi, pesempaki niyo heman se dibaloy. Aw legesen kaw memegay te ekasan niyo, begayi niyo heman se saol niyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pemegay kaw diyà te otaw memoyò kenyo. Aw doen mengabat te kedònan niyo, ikà niyo egpeolì. ");
INSERT INTO mbs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aw meibeg kaw te mèpiya se inangen te doma otaw diyà kenyo, keilangan mèpiya heman se inangen niyo diyà te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Aw olò otaw doen dakel pedowan diyà kenyo se kedekelan niyo te pedowan, eked kaw duyuni te Timanem, so pengkey otaw kenà egpenimanem, dakel se pedowan dan diyà te otaw doen dakel pedowan diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aw olò otaw eg-inang te mèpiya diyà kenyo se inangan niyo te mèpiya, eked kaw heman duyuni te Timanem, so iling heman kenyan se eg-inangen te otaw kenà egpenimanem. ");
INSERT INTO mbs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aw olò otaw mekeimpas te salà se pebelesan niyo, eked kaw duyuni te Timanem, so pengkey otaw kenà egpenimanem, egpebelesay dan aw egpeimpasay dan. ");
INSERT INTO mbs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Meneng sikiyo, seini se keilangan inangen niyo. Kedekeli niyo te pedowan se poon niyo. Inangi niyo dan te mèpiya. Pebelesi niyo dan pengkey eked dan iyan keolì. Aw yan se inangen niyo, dakel se ontong ibegay diyà kenyo, aw ipetaga-taga niyo te batà kaw te Timanem, so gayed sikandin egkeido te kedita te otaw pengkey medaet dan aw kenà egpesiontong. ");
INSERT INTO mbs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Keilangan egkeido kaw te doma iling te keido te Amay niyo Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ikà niyo eg-okom te doma otaw amon eked kaw okomi. Ikà niyo egpemegay te pelumun diyà te doma otaw amon eked kaw begayi te pelumun. Pegwedadi niyo se salà te doma otaw amon pegwedaden se kenyo salà. ");
INSERT INTO mbs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bowangi niyo se doma, aw bowangan kaw heman te Timanem. Ontò dakel se ibowang din kenyo, so deseken din, aw keyongen din, aw olowan din se ibegay din kenyo amon ontò dakel se kinewaen niyo. Aw bowasag kaw diyà te doma otaw, bowasag heman se Timanem diyà kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Migtegdeyanan si Jesus, kagi din, “Wedad otaw bota mekeagak te doma din bota, so medagdag se didowa dan doton te awang te tanà. ");
INSERT INTO mbs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wedad heman meiskwilahay labi pa biyasa diyà te meistro din. Meneng penga te peg-iling din te kedita, onawa se kebiyasa din aw kebiyasa te meistro din. ");
INSERT INTO mbs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mola niyo egkitaen se sagbet kidoen te mata te doma niyo, meneng wedà niyo ketegahi te doen batang kidoen te kenyo mata. ");
INSERT INTO mbs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aw eked niyo kitai se batang kidoen te kenyo mata, eked kaw peketabang te doma niyo amon meabat se sagbet lekat te kandin mata. Kolang se aneng-aneng niyo te wedad salà niyo. Ebati niyo onà se batang lekat te kenyo mata, aw penga niyan metaen se pegkità niyo amon mengabat kaw heman te sagbet lekat te mata te doma niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Aw mèpiya se kayo, eked iyan pongo te medaet. Aw medaet se kayo, eked heman pongo te mèpiya. ");
INSERT INTO mbs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aw kitaen tadon se pongo te kayo, ketegahan tadon aw eden kemoloi te kayo iyan. Wedad pongo igira geniyen lekat te ligem. Wedad heman paras ipoen lekat te telayid. ");
INSERT INTO mbs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iling heman kenyan se otaw. Aw mèpiya se pedowan te otaw, mèpiya heman se eg-inangen din. Meneng aw medaet se pedowan te otaw, medaet heman se eg-inangen din. Aw mikagi se otaw, yan ipetaga-taga din aw eden se awop te pedowan din.” ");
INSERT INTO mbs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Eked kepakay aw mikagi kaw te siak se Pengolo niyo singed aw tomolò kaw te ipegtoladà ko kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Meg-indan a den kenyo tepad te otaw domini kanak, aw domineg te kagi ko, aw tomolò kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iling sikandin te otaw mig-inang te balay. Nemangbang sikandin te ontò medalem lamig minapet te bato, aw yan se pinetindegan din te tollok. Pegkepenga te peg-inang din te balay, miglaneg se wayeg aw minapet te balay din. Meneng wedà iyan keagos, so ontò dimasel. ");
INSERT INTO mbs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Meneng aw domineg se otaw te kagi ko, aw eked tolò kenyan, iling sikandin te otaw mig-inang te balay diyà te lanto te tanà wedà din bengbangi. Peglaneg te wayeg, netongan iyan te wedà kenamay aw ontò iyan nebàtan.” ");
INSERT INTO mbs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Penga te peg-ikagi i Jesus diyà te otaw netipon kidoen, dimoton sikandin te Kapirnaom. ");
INSERT INTO mbs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Doen kidoen kapitan te sondalo te gobirno te Roma. Nesekitan aw ontò netigdaan se sebad sineligan din ontò din egkeidowan. ");
INSERT INTO mbs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pegdineg te kapitan tepad ki Jesus, doen menge obanen te Judiyo insogò din mangay ki Jesus amon megpegolì te sineligan din. ");
INSERT INTO mbs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pegdateng dan doton ki Jesus, ontò dan nemoyò kandin, kagi dan, “Ontò mèpiya otaw se kapitan migsogò kenami. Pegtabang ka bag kandin, ");
INSERT INTO mbs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","so egkedekelan kidon din te pedowan sikitadon menge Judiyo. Sikandin se migpeinang te simbahan day dini.” ");
INSERT INTO mbs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yan timaking si Jesus kandan. Pegkedapag din kidoen te balay, doen menge sigalak te kapitan insogò din doton ki Jesus amon ikeliwat dan se kagi din seini, “Sir, pebeyai se pegdini no te balay ko, so medanà a diyà kamno, aw meyàyà a aw ipeawop ta diyà te balay ko. ");
INSERT INTO mbs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yan se doun te wedà a songon kamno, so medanà a diyà kamno. Pengkey mediyò ka pa lekat te balay ko, meneng botong aw olò ka mikagi te kegolian se sineligan ko, so metoman iyan. ");
INSERT INTO mbs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gayed a egtolò te otaw simogò kanak, aw doen heman menge sondalo nesakop diyà kanak. Aw doen sondalo isogò ko, tomolò sikandin. Aw doen doma ipeangay ko, tomolò heman. Aw doen ipeinang ko te sineligan, yan se inangen din.” Yan se kagi te kapitan ingkeliwat dan diyà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pegdineg i Jesus kenyan, ontò nepela. Penga niyan, miniling sikandin aw minikagi diyà te medita otaw timaking kandin, “Eneng-enengi niyo se kagi ko kenyo. Pengkey kidoen te menge bowad-bowad i Israel, wedad palos otaw netelaan ko simalig kanak iling te pegsalig din.” ");
INSERT INTO mbs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nayan, peg-olì te otaw insogò te kapitan, kinità dan se sineligan negolian den. ");
INSERT INTO mbs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Penga niyan te wedà kenamay, dimoton si Jesus te lonsod te Nain. Timaking se tinoledaan din kandin, aw ontò heman medita se doma otaw timaking kandin. ");
INSERT INTO mbs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pegkedapag dan te lonsod, kinità dan se medita otaw lekat te lonsod nengibing te lawa te otaw nematay amon ilebeng. Temisa batà se nematay, aw balo se inay din. Ontò medita se otaw timaking pesalo doton te lebengan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pegkità te Pengolo te inay te nematay, ontò sikandin neido aw minikagi, “Ikà egkelag.” ");
INSERT INTO mbs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Penga niyan, migpedapag si Jesus aw nemaed te inibatan te nematay, aw yan simagked se otaw nengibing kenyan. Minikagi si Jesus diyà te nematay, “Atò, enaw ka.” ");
INSERT INTO mbs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yan neantay se otaw lekat te nematay, aw minenaw, aw minikagi diyà kandan. Penga niyan, inibing sikandin i Jesus doton te inay din. ");
INSERT INTO mbs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nelemitan se kedita te otaw kimità kenyan, aw induyun dan se Timanem, kagi dan, “Migtabang den se Timanem kenitadon menge sakop din, so insogò din dini kenitadon se metolos telekeliwat te kagi din seini.” ");
INSERT INTO mbs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nedengeg se sìyan ininang i Jesus kidoen te kedita te menge lonsod kidoen te probinsya te Judiya aw kedepagan niyan. ");
INSERT INTO mbs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nayan, se menge tinoledaan i Juan Memonyagay, mig-indan dan diyà ki Juan tepad te kedita te ininang i Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Impeangay i Juan se dowa tinoledaan din, aw insogò din dan doton te Pengolo amon meg-insà dan aw sikandin se ontò insogò te Timanem pinelimanan dan, aw doen pa doma domateng. ");
INSERT INTO mbs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pegdoton dan ki Jesus, minikagi dan, “Insogò kay i Juan amon meg-insà kay kamno aw sikona se ontò insogò te Timanem pinelimanan day, aw doen pa doma domateng.” ");
INSERT INTO mbs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dalem te aldaw sìyan, migpegolì si Jesus te medita otaw doen mesakit aw otaw netigdaan aw otaw pigbosawan. Migpegolì heman sikandin te otaw bota amon todà dan komità. ");
INSERT INTO mbs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yan se doun te timaba si Jesus, “Likò kaw den doton ki Juan aw indani niyo sikandin te kedita te kinità niyo aw dinineg niyo dini. Doen menge bota kimità den. Doen heman kapig minipanaw den. Doen tompigun negolian den. Doen bingelen dimineg den. Doen heman nematay neantay den. Doen menge otaw sagkep tinoledaan te Mèpiya Indan. ");
INSERT INTO mbs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Indani niyo heman sikandin te doen keluba te otaw eked pegdowa-dowa te pegsalig din kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pegkesayo te otaw insogò i Juan, minikagi si Jesus tepad ki Juan diyà te otaw netipon, kagi din, “Pegdoton niyo te kebigtilan, kenà tigbaw egkedogen te kelamag se pinengemahà niyo. ");
INSERT INTO mbs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wedà kaw heman doton amon tomengteng te otaw nenaol te ontò meelagà, so se menge otaw egpenaol te mèpiya aw egpengabat te pengkey eden se ibeg dan, yan se eg-ogpà doton te balay te selotan. ");
INSERT INTO mbs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Meneng seini indà se tod niyo. Dimoton kaw te kebigtilan amon kitaen niyo se telekeliwat te kagi te Timanem. Pengkey melangkaw se kedita te telekeliwat te kagi te Timanem, meneng labi pa melangkaw si Juan. ");
INSERT INTO mbs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sikandin se migtoladà tepad kanak, aw tinoman din se pakang seini tapay insolat kidoen te kagi te Timanem, ‘Na, doen otaw isogò ko megpetaga-taga te agpet ka den domateng, amon megpeketagad se kedita te otaw te pegdateng nikaw.’” ");
INSERT INTO mbs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Minikagi heman si Jesus, “Eneng-enengi niyo se kagi ko seini. Wedad palos otaw dini lanto te tanà labi pa melangkaw diyà ki Juan. Meneng labi pa melangkaw diyà ki Juan se kedita te otaw megpesakop diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pegdineg dan te intoladà i Juan, minikagi se kedita te otaw pengkey menge iskribinti te metòlid se impunù te Timanem aw migpebonyag dan ki Juan. ");
INSERT INTO mbs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Meneng se menge Parisiyo aw menenoladà te punù ingkeliwat i Moises, mig-eked dan te ibeg te Timanem kandan, so wedà dan pegpebonyag ki Juan. ");
INSERT INTO mbs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Minikagi si Jesus, “Nayan, seini se tegdeyanan iindan ko kenyo amon ketegahan niyo aw eden se pig-ilingan te menge otaw te aldaw seini. ");
INSERT INTO mbs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iling dan te mengisù egdanga doton te pedyanan aw egpetewalay dan, ‘Pengkey mig-edop kay te seluli amon somayaw kaw, meneng wedà kaw sayaw. Pengkey migdelangan kay tepad te pegkematay, meneng wedà kaw heman kelano.’ ");
INSERT INTO mbs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iling kaw heman kandan, so pegdini i Juan Memonyagay, kinità niyo se ketanem din te melikit egpowasa aw kenà palos heman eg-inem. Meneng wedà kaw penenalan kandin, aw minikagi kaw te dinetengan sikandin te bosaw. ");
INSERT INTO mbs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pegdini ko Timanem Migpekeotaw, kinità niyo se ketanem ko te gayed a egpengaen aw eg-inem. Meneng kunù wedà kaw penenalan kanak, aw minikagi kaw te legoken a aw metiinem a, aw egsigelaken ko se menge iskribinti aw doma otaw nelegeb te salà. ");
INSERT INTO mbs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Meneng wedad beloyan, so netegahan te kedita te otaw migpesakop diyà te Timanem te ontò sikandin biyasa.” ");
INSERT INTO mbs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Doen sebad Parisiyo nemekaen ki Jesus, aw dimoton si Jesus te balay din aw kimaen. ");
INSERT INTO mbs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nayan, doen bayi eg-ogpà kidoen te lonsod sìyan, aw nedengeg sikandin mig-inang te salà. Pegketaga-taga din te kimaen si Jesus kidoen te balay te Parisiyo, dimoton sikandin. Inibing din se lana metinadeg insawol kidoen te deitek botilya. ");
INSERT INTO mbs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Peg-awop din kidoen te balay, timikelong diyà te benis i Jesus aw migkelag. Impetedak din se lohà diyà te benis din, aw logay din se inggalis kenyan. Gayed egpengadek te benis i Jesus, aw nenoyong heman te lana diyà te benis din. ");
INSERT INTO mbs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nayan, sìyan Parisiyo migpekaen ki Jesus, pegkità din te ininang te bayi, mig-aneng-aneng sikandin te kenà ontò telekeliwat insogò te Timanem si Jesus. Aneng-aneng din, simpana si Jesus se benal telekeliwat insogò te Timanem, ketegahan din aw eden se eg-inangen te bayi sìyan, so ontò sikandin mig-inang te salà. ");
INSERT INTO mbs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Minikagi si Jesus diyà te Parisiyo, “Simon, doen ikegiyen ko diyà kamno.” Timaba si Simon, “Ee, Sir. Ikegihi a.” ");
INSERT INTO mbs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Minikagi si Jesus, “Doen dowa otaw mineles te kwarta diyà te otaw egpebeles. Se sebad, doen salà din lima gatos. Se doma otaw, doen salà din keliman olò. ");
INSERT INTO mbs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pengkey wedà dan eleg pekebayad te salà dan, meneng pigwedad din se salà te didowa. Na, sinu lay diyà te didowa otaw sìyan se doen ontò dakel pedowan diyà te otaw migpebeles?” ");
INSERT INTO mbs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Timaba si Simon, “Sikandin besi mineles te lima gatos, so labi pa dakel se salà din pigwedad.” Minikagi si Jesus, “Benal se pegtaba nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Penga niyan, timengteng si Jesus diyà te bayi aw minikagi pa diyà ki Simon, “Eneng-enengi se bayi seini. Pegdateng ko dini te balay no, wedad wayeg imbegay no kanak ionaw te benis ko tepad te ketanem tadon. Meneng se bayi seini, lohà din se in-onaw din te benis ko, aw logay din se inggalis din kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Peg-awop ko diyà te balay no, wedà ka adek kanak. Meneng se bayi seini, gayed egpengadek te benis ko lekat te pegdateng ko lamig seini. ");
INSERT INTO mbs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wedà ka pegsawol te lana diyà te olo ko amon segmanen a nikaw. Meneng se bayi seini, meelagà se metinadeg intoyong din diyà te benis ko. ");
INSERT INTO mbs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Penenalan ka kanak. Pengkey ontò medita se salà te bayi seini, meneng pigwedad den te Timanem se kedita te salà din, aw yan se doun te impetaga-taga den te bayi te ontò dakel se pedowan din kanak. Meneng simpana kenà medita se salà te otaw pigwedad te Timanem, eked din ontò petega-tegahi te dakel se pedowan din diyà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Penga niyan, minikagi si Jesus diyà te bayi, “Pigwedad den se salà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nepela se menge otaw kimaen doma din, so aneng-aneng dan eked kepakay aw sikandin se megwedad te salà te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Meneng minikagi heman si Jesus diyà te bayi, “Simalig ka diyà kanak, aw yan se doun te impelowà ka den te Timanem lekat te salà nikaw. Olì ka den. Ibeg ko doen kelinaw te pedowan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wedà kenamay, miglegeb si Jesus aw timeped te menge lonsod aw doma ogpeanan. Migtoladà sikandin te menge otaw te Mèpiya Indan tepad te peglowan te Timanem. Timaking heman kandin se sempolò teg dowa tinoledaan pinemallì din. ");
INSERT INTO mbs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Timaking heman kandin se menge bayi tapay pinegolian din aw pinelowaan din te bosaw. Sikandan si Maria tege Magdala pinelowaan te pito se bosaw, ");
INSERT INTO mbs_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aw si Juana sìyan esawa i Cusa sebad opisyal i Herod, aw si Susana, aw medita heman se doma. Se menge bayi sìyan, yan se migtabang ki Jesus aw menge doma din. ");
INSERT INTO mbs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gayed dimoton ki Jesus se menge otaw lekat te kedita te lonsod. Pegketipon te ontò medita otaw, mig-indan si Jesus te tegdeyanan, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Doen otaw dimoton te pawà amon menabog te benì, so yan se ketanem te pegpenanem din. Pegsabog din, doen benì nesabog diyà te dalan, aw negìtan iyan te otaw aw kinaen te menge manok te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Doen heman benì nesabog diyà te tanà kebeto-betowan. Pegtobò niyan, nelanes aw nematay te wedà kenamay so nepangkag se tanà. ");
INSERT INTO mbs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Doen heman benì nesabog diyà te pinonoan te sagbet doen tigis. Timilles heman se sagbet doen tigis aw kinelep se menge tobò aw nematay. ");
INSERT INTO mbs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Meneng doen benì nesabog diyà te melambò tanà. Yan se timilles aw minongo te ginatos.” Penga niyan, minikagi si Jesus te dakel se kagi din, “Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nayan, mig-insà se menge tinoledaan i Jesus aw eden se kedegdagan te tegdeyanan sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Minikagi si Jesus, “Sikiyo se pinetega-tegahan te Timanem te kebenalan tepad te peglowan din. Meneng olò pineokit te tegdeyanan se pegtoladà ko te menge doma otaw amon pengkey tomengteng dan, meneng eked dan kità te kedegdagan niyan. Pengkey domineg dan, meneng eked dan ketaga-taga te kebenalan.” ");
INSERT INTO mbs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Seini se kedegdagan te tegdeyanan sìyan. Se benì insabog, yan se kagi te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na, se benì nesabog diyà te dalan, yan se iling te menge otaw domineg te kagi te Timanem intoladà. Penga niyan, doen inangen i Satanas amon kelibelan dan se kagi te Timanem dinineg dan, so ibeg i Satanas, eked dan pemenal aw eked dan heman pekelowà lekat te salà. ");
INSERT INTO mbs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nayan, se benì nesabog diyà te tanà kebeto-betowan, yan se iling te otaw domineg te kagi te Timanem, aw meluba dan, aw tomolò dan kenyan te eked kenamay. Meneng aw meboyo dan, tenanan dan se pinemenalan dan, so iling dan te tinanem wedad nael dalid. ");
INSERT INTO mbs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nayan, se benì nesabog diyà te pinonoan te sagbet doen tigis, yan se iling te otaw ontò domineg te kagi te Timanem intoladà. Meneng penga niyan, wedad ontong dan, so dàgen dan te ibeg dan megkeyaman, aw ibeg dan te keluba te keneyonan, aw doma ibeg te pedowan dan. ");
INSERT INTO mbs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Meneng se benì nesabog diyà te melambò tanà, yan se iling te otaw ontò melobos se pedowan dan. Aw domineg dan te kagi te Timanem, ontò dan iyan egtoloen. Egtayod dan te kelimahan lamig doen ontong dan.” ");
INSERT INTO mbs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Aw menemtem se otaw te solò, eked din iyan sengkobi. Eked din heman elesi doton te siyong te katri. Meneng mèpiya aw isawol din iyan diyà te kelengkawan amon keenyagan se didalem te balay. ");
INSERT INTO mbs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iling heman kenyan, wedad in-eles songkani eked kitai te modi aldaw. Wedad heman imbolon songkani eked keindan te modi aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nayan, keilangan toloen niyo se dinineg niyo. Se otaw kominawà te kebenalan, yan se dogangan te kebenalan. Meneng se otaw eked kinawà te kebenalan, yan se pegwedadan te kebenalan.” ");
INSERT INTO mbs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nayan, pegtoladà i Jesus, dimateng se inay din aw menge kedowa din. Meneng wedà dan pekedapag diyà kandin, so ontò medita se otaw netipon kidoen kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Doen otaw minikagi diyà kandin, “Doton te lowà se inay no aw menge kedowa nikaw. Meibeg dan ekon megkità kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Timaba si Jesus, “Se menge otaw domineg te kagi te Timanem aw tomolò kenyan, yan se meinang inay ko aw menge kedowa ko.” ");
INSERT INTO mbs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nayan, doen sebad aldaw minikagi si Jesus diyà te menge tinoledaan din, “Mèpiya aw matas kidon doton dipag te lanaw.” Penga niyan, simakay dan te belangay. ");
INSERT INTO mbs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pegpesalo dan doton, neketedogi si Jesus. Wedà kenamay, dinetengan dan te kelamag ontò mebandes. Dakel se wayeg nekeawop te belangay, aw agpet dan neteled. ");
INSERT INTO mbs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Penga niyan, linoka dan si Jesus, kagi dan, “Pengolo, melemes kidon den.” Neloka si Jesus aw sinagda din se kelamag aw dakel balud. Timunung se kelamag aw migkelinaw se lanaw. ");
INSERT INTO mbs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Penga niyan, minikagi si Jesus, “Wedà pa kedì kelobos se pegsalig niyo kanak.” Meneng nelemitan dan. Nepela dan aw migpebelaw-belaway dan, kagi dan, “Ontò sikandin metolos, so pengkey kelamag aw balud timolò kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Penga niyan, dimeleg dan doton medapag te Gerasa dipag te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pegtenà i Jesus, kinità din se tege Gerasa simongon kandin. Dinetengan sikandin te bosaw, aw nenamay den migpetabeg-tabeg. Kenà eg-ogpà diyà te balay, meneng eg-ogpà doton te menge lebenganan. ");
INSERT INTO mbs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pegkità din ki Jesus, mig-olangag sikandin, aw limongken diyà ki Jesus, aw minikagi te dakel se kagi din, “Jesus, Batà te Timanem ontò melangkaw, ikà egsamok kanak. Memoyò a den diyà kamno, ikà bag egpeeleg kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yan se inikagi te bosaw, so pinunuan i Jesus se bosaw amon lomowà diyà te otaw. Melikit egdetengan te bosaw se otaw sìyan, aw yan eggeposen sikandin te doma otaw te sengkalì, aw egpentongan dan sikandin, aw gayed dan egbentayan. Meneng egkebogtò se ipeggapos kandin aw eg-ibingen sikandin te bosaw doton te kebigtilan. ");
INSERT INTO mbs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na, mig-insà si Jesus, “Sinu lay se ngadan nikaw?” Timaba sikandin, “Minelalan.” Yan se intaba din so ontò medita se bosaw egdateng kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gayed dan egpemoyò diyà ki Jesus te eked din dan peibingi doton te kilot aw ipelumun. ");
INSERT INTO mbs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ontò medita se osa nenowal doton te bontod medapag. Nemoyò se menge bosaw diyà ki Jesus aw mepakay diyà kandin malin dan doton te menge osa sìyan. Yan impealin din dan. ");
INSERT INTO mbs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yan limowà se menge bosaw lekat te otaw aw minalin dan doton te osa. Penga niyan, kimagnan se kedita te osa pesalo te keba, aw kimahang dan doton te lanaw, aw nelemes dan. ");
INSERT INTO mbs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pegkità te menge telediyaga te osa kenyan, kimadas dan aw mig-indan dan tepad kenyan doton te lonsod aw kedepagan niyan. ");
INSERT INTO mbs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Penga niyan, dimoton se menge otaw inindanan dan amon komità dan kenyan. Pegdateng dan doton ki Jesus, kinità dan se otaw pinelowaan te bosaw. Nenenoo sikandin kidoen te dapag i Jesus, aw nenelowal den, aw migkèpiya den sikandin. Pegkità dan kenyan, nelemitan dan. ");
INSERT INTO mbs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inindanan dan heman te menge otaw kimità te pegpelowà i Jesus te bosaw lekat kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Penga niyan, nemoyò se kedita te tege Gerasa te mesayo si Jesus lekat kidoen, so ontò dan nelemitan. Penga niyan, simakay si Jesus te belangay amon molì doton dipag. ");
INSERT INTO mbs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Meneng nemoyò se otaw pinelowaan te bosaw aw mepakay sikandin tomaking. Meneng wedà din petekingi, so inikegiyan i Jesus, ");
INSERT INTO mbs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Olì ka den aw peg-indan ka diyà te menge kedomaan no tepad te mèpiya ininang te Timanem diyà kamno.” Penga niyan, nesayo sikandin aw mig-indan diyà te kedita te otaw te lonsod tepad te mèpiya ininang i Jesus diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Peg-olì i Jesus doton dipag te lanaw, medita se otaw simongon kandin, so tapay dan migtagad kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Penga niyan, dimoton ki Jesus se sebad obanen te simbahan te Judiyo, ngadan din si Jairo. Limongken sikandin diyà ki Jesus aw nemoyò te domoton si Jesus te balay din, ");
INSERT INTO mbs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","so ontò netigdaan se batà din bayi. Yan se temisa batà din, aw menge sempolò teg dowa se omay din. Penga niyan, timaking si Jesus kandin. Medita se otaw timaking ki Jesus aw migpesegsegay dan kidoen te dalan. ");
INSERT INTO mbs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nayan, doen sebad bayi timaking kandin pigdipenogan te sempolò teg dowa se omay, aw migkewedad se kedakel te kedònan din imbayad te menge doktor, meneng wedad otaw nekebolong kandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pegtaking din ki Jesus, migpedapag diyà te getan din aw nemaed olò te toktok te saol din. Pegketà, negolì se mesakit din. ");
INSERT INTO mbs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Penga niyan, mig-insà si Jesus, “Sinu lay se nemaed kanak?” Meneng wedad otaw mig-indan. Minikagi si Pedro, “Pengolo, ikà eg-insà aw sinu se nemaed kamno, so pigdenganan ka te medita otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Meneng minikagi si Jesus, “Doen gina otaw nemaed kanak, so mig-imanman a te doen tolos limowà lekat kanak amon megpegolì te otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nayan, pegketaga-taga te bayi te eked keeles se ininang din, migpedapag sikandin diyà ki Jesus aw tinegangtang tandà te lamit din. Limongken sikandin diyà ki Jesus aw mig-indan aw eden se tod din. Dimineg heman se kedita te otaw te kagi din te negolì den se mesakit din te lekat te pegpemaed din ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Minikagi si Jesus, “Atà, simalig ka diyà kanak, aw yan se doun te negolian ka. Olì ka den. Ibeg ko doen kelinaw te pedowan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Telobo pa minikagi si Jesus diyà te bayi, dimateng se otaw lekat te balay te obanen te simbahan, aw minikagi diyà ki Jairo, “Nematay den se batà nikaw. Wedad den kekemowan te pegpedeleg no te Menenoladà doton te balay nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Meneng pegdineg i Jesus kenyan, minikagi sikandin, “Ikà egkepuluk, meneng salig ka diyà kanak, so meantay pa sikandin.” ");
INSERT INTO mbs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pegdateng dan doton te balay i Jairo, wedad doma otaw impetaking i Jesus doton didalem, meneng olò si Pedro, si Juan, si Santiago, aw amay aw inay te batà. ");
INSERT INTO mbs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pengkey migkelag aw migmatay se kedita te doma otaw, meneng minikagi si Jesus, “Ikà egkelag, so wedà kematay se batà. Olò sikandin timedogi.” ");
INSERT INTO mbs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Meneng nebebeyatan dan si Jesus, so tapay dan netegahan te ontò den nematay se batà. ");
INSERT INTO mbs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Meneng pinemàdan din se belad te batà, aw minikagi te dakel se kagi din, “Atà, enaw ka.” ");
INSERT INTO mbs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Penga niyan, neantay sikandin aw minenaw. Penga niyan, migpunù si Jesus te ipekaen dan sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nepela se amay aw inay din te neantay sikandin. Meneng migpunù si Jesus te wedad palos otaw mepakay indanan dan tepad te peg-antay din te batà sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nayan, doen sebad aldaw migtipon si Jesus te sempolò teg dowa tinoledaan din, aw imbegay din diyà kandan se tolos amon megpelowà dan te bosaw lekat te otaw aw amon megpegolì dan te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Penga niyan, insogò din dan tomeped te menge doma ogpeanan amon megtoladà dan tepad te peglowan te Timanem aw amon megpegolì dan te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Doen impunù din kandan, kagi din, “Ikà niyo egpengibing te kedònan, pengkey bangkà, kelepì, kànen aw kwarta, so togpoan kaw te otaw toledaan niyo. Ikà niyo heman egpengibing te ekasan. ");
INSERT INTO mbs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aw domateng kaw doton te lonsod, ketingen kaw diyà te sebad balay. Ikà niyo eg-alin-alin lamig domeleg kaw doton te doma lonsod. ");
INSERT INTO mbs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aw doen otaw eked pegsagman kenyo, tektaki niyo se napò te tanà lekat te sepatos niyo te pegkesayo niyo lekat te lonsod dan. Yan metaga-taga se otaw kidoen te doen salà dan, so wedà dan penenalan te intoladà niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Penga niyan, nesayo dan aw timeped dan te menge lonsod. Pengkey kenan dan pesalo, gayed dan migtoladà te Mèpiya Indan, aw migpegolì dan heman te menge otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nayan, si Herod se otaw limowan kidoen te Galiliya. Pegdineg din tepad te ininang i Jesus aw intoladà din, migkebulung sikandin, so doen menge otaw eg-ikagi te yan si Juan Memonyagay neantay den lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Meneng doen heman menge doma otaw eg-ikagi te sikandin se telekeliwat te kagi te Timanem gebii si Elias. Eg-ikagi heman se menge doma otaw te sikandin se sebad telekeliwat te kagi te Timanem gebii neantay den lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Meneng minikagi si Herod, “Kenà niyan si Juan, so impesipal ko se lieg din. Sinu lay sikandin? So dinineg ko den te doen kepelahan eg-inangen din.” Penga niyan, ibeg i Herod megkità ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nayan, peg-olì te menge sogounun i Cristo doton kandin, mig-indan dan diyà kandin tepad te kedita te ininang dan. Penga niyan, tinenanan dan se doma otaw aw inibing dan i Jesus doton te sebad lonsod iningedanan Bitsayda. ");
INSERT INTO mbs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Meneng pegketaga-taga te kedita te otaw te dinotonan i Jesus, timelokon dan heman. Neluba si Jesus so nengemahà dan kandin. Penga niyan, mig-indan si Jesus diyà kandan tepad te peglowan te Timanem. Migpegolì heman sikandin te kedita te otaw doen mesakit. ");
INSERT INTO mbs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pegkeapon, dimoton se sempolò teg dowa tinoledaan i Jesus kandin, aw minikagi dan, “Pekeseyowi se kedita te otaw doton te lonsod aw kedepagan niyan amon midegà dan aw mengabat dan te kànen dan kidoen, so ontò ini kebigtilan.” ");
INSERT INTO mbs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Meneng minikagi si Jesus, “Pemekàni niyo dan.” Minikagi dan, “Meneng doen olò lima se pan, aw didowa se ikan. Kenà iyan botong kànen singed aw isogò kay nikaw mayad te doma kànen, so ontò medita se otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Menge lima melalan se meama netipon kidoen, aw doen heman menge bayi aw mengisù. Minikagi si Jesus diyà te menge tinoledaan din, “Peonsadi niyo se menge otaw teg keliman se sebad ebong.” ");
INSERT INTO mbs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Timolò dan, aw impeonsad dan se kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Penga niyan, inabat i Jesus se lima pan aw didowa ikan. Limengag sikandin doton te langit aw migpesiontong diyà te Timanem kenyan. Penga niyan, binelà-belà din iyan aw imbegay din diyà te menge tinoledaan din amon iteped dan diyà te menge otaw netipon. ");
INSERT INTO mbs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kimaen se kedita dan aw nebesog dan. Penga niyan, inimon dan se samà te pan kinaen dan, aw sempolò teg dowa se buun nepenò. ");
INSERT INTO mbs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nayan, doen sebad aldaw migtawal-tawal si Jesus sebad din, aw medapag heman kidoen se menge tinoledaan din. Penga niyan, mig-insà si Jesus diyà kandan, kagi din, “Eden lay se kagi te kedita te otaw tepad kanak? Sinu a lay ekon?” ");
INSERT INTO mbs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Timaba dan, “Medita se otaw eg-ikagi te sikona si Juan Memonyagay. Meneng doen heman eg-ikagi te sikona si Elias. Doen heman eg-ikagi te sikona se sebad telekeliwat te kagi te Timanem gebii neantay den lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mig-insà si Jesus, “Meneng eden lay se kenyo aneng-aneng tepad kanak? Sinu a lay?” Timaba si Pedro, “Sikona se Misiyas insogò te Timanem dini kenami.” ");
INSERT INTO mbs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Penga niyan, ontò migpunù si Jesus te keilangan eked dan indani diyà te doma otaw te sikandin se Misiyas. ");
INSERT INTO mbs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Minikagi heman si Jesus, “Pengkey Timanem a Migpekeotaw, meneng metoman a ontò elegen, aw kuluwan a te menge obanen te Judiyo aw menge pengolo te simbahan aw menge menenoladà te punù. Imetayan a, meneng penga niyan te iketelo te aldaw, meantay a lekat te nematay.” ");
INSERT INTO mbs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nayan, minikagi si Jesus diyà te kedita dan nenenalan kandin, kagi din, “Aw meibeg se otaw tomaking kanak, keilangan megsagda sikandin te ibeg te pedowan din, aw tomayod te kelimahan te kelikit te aldaw pengkey imetayan sikandin, aw keilangan ontò tomaking kanak. ");
INSERT INTO mbs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pengkey ibeg te otaw megkelayat se omol din dini te keneyonan, meneng kunù din gayed matay. Meneng aw mepakay diyà te otaw pengkey imetayan sikandin tandà te pegtaking din kanak, begayan sikandin te kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Simpana tig-epoen te otaw se kedakel te keneyonan, aw penga niyan matay sikandin aw ipelumun doton te kilot, wedad ontong din. ");
INSERT INTO mbs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aw eked ikagi se otaw te sikandin se sakop ko, aw eked heman tolò te kagi ko, yan se otaw eked ko heman ikegihi te sikandin se sakop ko te peglikò ko dini. Siak se Timanem Migpekeotaw, aw lomikò a pa dini tekingan te keanyag ko, aw keanyag te Amay ko, aw keanyag te menge anghil te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eneng-enengi niyo se kagi ko seini. Doen otaw dini kenyo eked kematay singed aw onà dan komità te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nayan, penga te sebad simana lekat te peg-ikagi i Jesus kenyan, impetaking din si Pedro, si Juan, aw si Santiago, aw timikedeg dan doton te bontod amon megtawal-tawal dan. ");
INSERT INTO mbs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dalem te pegtawal-tawal i Jesus, netodà se bawa din, aw ontò migkepotì se kedakel te penenaktun din. ");
INSERT INTO mbs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pegketà doen dowa otaw migbalaw-balaw kandin, si Moises aw si Elias. ");
INSERT INTO mbs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pegpekità dan, minanyag dan heman. Migpebelaw-belaway se telo dan tepad te pegkematay i Jesus, so yan se tomanen din te eked kenamay doton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ontò neketedogi si Pedro aw doma din. Meneng pegkeloka dan, kinità dan se anyag i Jesus aw sìyan dowa otaw doma din. ");
INSERT INTO mbs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dalem te pegkesayo i Moises aw si Elias lekat ki Jesus, minikagi si Pedro diyà ki Jesus, “Pengolo, mèpiya so dini kay. Ibeg day meg-inang kay den te telo balay amon doen ogpaan te teg sebad-sebad kenyo si Moises aw si Elias.” Pengkey yan se inikagi i Pedro, meneng wedà din kelebeti aw eden se inikagi din. ");
INSERT INTO mbs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Telobo pa minikagi si Pedro, doen labon dimateng diyà kandan aw wedà dan ebey kità kandan. Pegkeselibeng te labon kandan, ontò nelemitan si Pedro aw doma din. ");
INSERT INTO mbs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Penga niyan, dinineg dan se kagi te Timanem lekat te labon, “Seini se Batà ko, aw pinemallì ko sikandin amon tomanen din se ibeg ko. Keilangan sikandin se penenelanen niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Penga te pegdineg dan kenyan, kinità dan si Jesus olò sebad din. Wedà dan peg-indan diyà te doma otaw tepad te kinità dan kidoen lamig ontò nenamay. ");
INSERT INTO mbs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Keeldawan niyan, timopang dan lekat te bontod aw nesongonan dan te ontò medita otaw. ");
INSERT INTO mbs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nayan, doen sebad otaw timawal ki Jesus, kagi din, “Sir, keidowi bag se batà ko, so sikandin se temisa batà ko. ");
INSERT INTO mbs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Melikit sikandin egdetengan te bosaw, aw egpuypuy. Egpemekeseg iyan kandin, aw egbohak se bahà din. Ontò melima se pegpelowà te bosaw lekat kandin, so eked kesayo singed aw onà din peelegen se batà. ");
INSERT INTO mbs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nemoyò a diyà te menge tinoledaan no te ipelowà dan se bosaw lekat kandin, meneng wedà dan iyan kebatog.” ");
INSERT INTO mbs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Minikagi si Jesus, “Tay law, sikiyo menge otaw. Ontò kolang se aneng-aneng niyo, so wedà kaw pa salig diyà kanak. Eked den kenamay se pegdoma ko kenyo, meneng keilangan tomayod a pa pengkey eked kaw pemenal. Na, pedinihi se batà nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pegpesalo te batà doton ki Jesus, binadas sikandin te bosaw aw impekeseg din. Meneng sinagda i Jesus se bosaw aw impelowà din iyan lekat te batà. In-olì din se batà sìyan negolian diyà te amay din. ");
INSERT INTO mbs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ontò nepela se kedita te otaw kidoen, so netegahan dan te ontò melangkaw se Timanem. Dalem te nepela pa se kedita te otaw tandà te ininang i Jesus, minikagi sikandin diyà te menge tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Keilangan ontò kaw menenalan te kagi ko kenyo seini. Seini se metoman domateng diyà kanak Timanem Migpekeotaw. Metoman a itolok aw ibegay a diyà te belad te doma otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Meneng wedà dan ketegahi aw eden se kedegdagan te inikagi din sìyan, so wedà iyan keinang mebangal amon eked dan iyan kelebeti. Meneng wedad otaw mig-insà kandin tepad kenyan, so neyàyà dan. ");
INSERT INTO mbs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nayan, migpedindilay se menge tinoledaan i Jesus aw sinu se ontò melangkaw diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Meneng pegketaga-taga i Jesus aw eden se pigdindilan dan, tinawal din se sebad batà, aw impetindeg din iyan kidoen te tangkil din. ");
INSERT INTO mbs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Penga niyan, minikagi si Jesus, “Aw megsagman se otaw te batà seini tandà te pegpesakop din kanak, pineokit kenyan segmanen a din heman. Aw megsagman se otaw kanak, segmanen din heman se Amay ko simogò kanak. Se otaw ontò megpedanà kidoen kenyo, yan se ontò melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nayan, minikagi si Juan, “Pengolo, doen otaw kinità day migpelowà te bosaw lekat te menge otaw pineokit te ngadan nikaw. Meneng sinagda day sikandin so wedà pekeakop diyà kenitadon.” ");
INSERT INTO mbs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Meneng minikagi si Jesus, “Ikà niyo egsagda kandin, so se otaw kenà poon niyo, meinang sikandin doma niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sagwa agpet den domateng se aldaw te pegkeengat i Jesus doton te langit, miglalang sikandin domoton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Doen menge otaw insogò din minonà diyà kandin. Nesayo dan aw dimoton dan te sebad lonsod sakop te Samarya amon megpetagad dan te ogpaan din aw mapit kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kenà Judiyo se menge otaw eg-ogpà kidoen, aw yan se doun te wedà dan peepiti si Jesus, so netegahan dan te domeleg sikandin doton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pegketaga-taga i Santiago aw si Juan te eked dan segmani te tege Samarya, minikagi dan, “Pengolo, meibeg ka lay aw ipedagdag day se apoy lekat te langit amon megelà dan?” ");
INSERT INTO mbs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Meneng miniling si Jesus diyà kandan aw sinagda din dan. ");
INSERT INTO mbs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Penga niyan, dimeleg dan doton te doma lonsod. ");
INSERT INTO mbs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dalem te peg-ipanaw dan, doen otaw minikagi diyà ki Jesus, “Pengkey kenan ka pesalo, gayed a tomaking kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Meneng minikagi si Jesus, “Mèpiya pa se menge menenanap te kebenesan, so doen ogpeanan dan. Mèpiya pa heman se menge manok, so doen heman embonganan dan. Meneng melima aw tomaking ka kanak Timanem Migpekeotaw, so wedad palos ibatan ko te delem.” ");
INSERT INTO mbs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Minikagi si Jesus diyà te doma otaw kidoen, “Taking ka kanak.” Meneng timaba sikandin, “Pengolo, eked a taking kamno singed aw onà matay se amay ko aw ilebeng ko.” ");
INSERT INTO mbs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Meneng minikagi si Jesus, “Mèpiya aw otaw wedad kaling pedowan se meglebeng te menge doma dan nematay. Meneng aw doen kaling pedowan no, keilangan megtoladà ka den te doma otaw tepad te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Doen heman doma otaw minikagi diyà ki Jesus, “Pengolo, tomaking a diyà kamno. Meneng molì a onà amon megpetaga-taga a te menge kedomaan ko.” ");
INSERT INTO mbs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Minikagi si Jesus, “Ikà eg-iling te otaw megdaro gayed eglingì, so kolang se inangen din. Iling heman kenyan se otaw kenà melobos se pedowan din tomaking kanak, so eked kepakay aw megpesakop sikandin diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Penga niyan, pinemallì te Pengolo se kepitowan teg dowa otaw, aw insogò din dan teg dowa-dowa doton te kedita te lonsod aw ogpeanan agpet dotonan din, amon megpeketagad se kedita te otaw te pegdateng din. ");
INSERT INTO mbs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Minikagi si Jesus diyà kandan, “Ontò dakel se geniyenen, aw pilabok se otaw meglegani. Timanem se tig-apò te pawà, aw keilangan megtawal-tawal kaw diyà kandin amon isogò din se menge doma otaw meglegani. ");
INSERT INTO mbs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, kesayo kaw den. Meneng peg-ahà kaw amon eked kaw pemilangi te mededaet otaw, so iling kaw te ayam-ayam karniro egbenganan te menenanap te kebenesan iningedanan lobo. ");
INSERT INTO mbs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ikà niyo egpengibing te kwarta, aw kelepì, aw sepatos ekasan niyo. Aw doen otaw kitaen niyo doton te dalan, ikà niyo egsempetanun kandan amon eked kaw keanggà. ");
INSERT INTO mbs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aw domateng kaw doton te balay, onà kaw ikagi diyà te otaw eg-ogpà kidoen, ‘Begayan se kedita niyo te kelinaw.’ ");
INSERT INTO mbs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na, aw mèpiya se pedowan te otaw eg-ogpà kidoen, begayan sikandin te kelinaw pineokit te kagi niyo. Meneng aw wedad otaw kidoen mèpiya se pedowan din, lomikò diyà kenyo se inikagi niyo. ");
INSERT INTO mbs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikà niyo eg-alin-alin, meneng peg-ogpà kaw kidoen te sebad olò balay. Kaen kaw aw inem kaw te pengkey eden se lemaken dan kenyo, so keilangan togpoan se otaw egterbaho. ");
INSERT INTO mbs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pengkey kenan kaw doton, aw segmanen kaw te otaw kidoen, kaen kaw te pengkey eden se ipekaen dan kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pegpegolì kaw te otaw doen mesakit. Ikagi kaw diyà kandan, ‘Medapag den se peglowan te Timanem diyà kenyo.’ ");
INSERT INTO mbs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Meneng aw eked kaw segmani te otaw doton te lonsod dotonan niyo, doton kaw te dalan aw ikagi kaw, ");
INSERT INTO mbs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pengkey napò te tanà niyo dimeket diyà te benis day, tektaken day den, amon ketegahan niyo te doen salà niyo. Keilangan metaga-taga kaw te medapag den se peglowan te Timanem diyà kenyo, meneng kimulu kaw kenyan.’ ");
INSERT INTO mbs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eneng-enengi niyo se kagi ko kenyo. Pengkey ipelumun te Timanem se tege Sodoma te modi aldaw tepad te salà dan ontò medaet, meneng labi din pa ipelumun se otaw eked pegsagman kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mekelelayò kaw tege Korasin. Mekelelayò kaw heman tege Bitsayda, so wedà kaw pegselsel. Aw impekità diyà te tege Tiro aw tege Sidon gebii se inang metolos impekità ko kenyo, nenaol den dan peden te sako aw migbodbod den dan peden te abo diyà te olo dan amon ipetaga-taga dan te migselsel dan te salà dan ontò medaet. ");
INSERT INTO mbs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pengkey ipelumun te Timanem se tege Tiro aw tege Sidon, meneng labi kaw din pa ipelumun so wedà kaw pemenal kanak. ");
INSERT INTO mbs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sikiyo tege Kapirnaom, pengkey meibeg kaw megpelangkaw-langkaw taman te langit, meneng idagdag kaw doton te kilot.” ");
INSERT INTO mbs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Minikagi heman si Jesus diyà te menge tinoledaan insogò din, “Aw menenalan se otaw diyà kenyo, siak heman se penenelanen din. Aw eked penenalan se otaw diyà kenyo, siak heman se eked din penenelani. Aw eked penenalan se otaw diyà kanak, eked din heman penenelani se Amay ko simogò kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nayan, penga te peg-olì te kepitowan teg dowa tinoledaan insogò i Jesus doton te kedita te lonsod, neluba dan, aw minikagi dan, “Pengolo, pengkey bosaw nebatog day impelowà pineokit te pegtawal day te ngadan nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Minikagi si Jesus, “Dimaeg kaw kandan so kinità ko se pegkedagdag i Satanas lekat te langit iling te kilem. ");
INSERT INTO mbs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ikà niyo egkelibel kani. Doen tolos imbegay ko kenyo amon domaeg kaw te kedita te sakop i Satanas. Pengkey gìtan niyo se memokan aw doma mekeilo, meneng eked kaw elegi, so wedad palos meleg kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Meneng pengkey egdaeg kaw te menge bosaw, kenà niyan se ingkeluba niyo, meneng keilangan meluba kaw so insolat den te Timanem se ngadan niyo kidoen te langit.” ");
INSERT INTO mbs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nayan, dakel se luba imbegay te Espiritu Santo ki Jesus, aw yan se doun te migtawal-tawal sikandin, kagi din, “Amà, Pengolo te kedita doton te langit aw dini heman te tanà, egpesiontong a diyà kamno, so wedà no petega-tegahi se kebenalan diyà te otaw biyasa aw dakel netegahan, meneng impetaga-taga no den iyan diyà te otaw medanà. Iduyun ta Amà, so lekat iyan te ibeg nikaw ontò mèpiya.” ");
INSERT INTO mbs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Penga niyan, minikagi si Jesus, “Insalig te Amay ko se kedita diyà kanak. Se Amay ko, yan olò se netaga-taga te kedita tepad kanak, so Batà a din. Siak olò heman se netaga-taga te kedita tepad te Amay ko, aw eked ketaga-taga se otaw tepad kandin singed aw ipetaga-taga ko iyan diyà kandan.” ");
INSERT INTO mbs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Penga niyan, minikagi si Jesus diyà te menge tinoledaan din te wedad doma otaw dimineg kandin, “Doen den keluba niyo tandà te ininang ko kinità niyo. ");
INSERT INTO mbs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pengkey medita se telekeliwat te kagi te Timanem aw menge selotan gebii ibeg komità te inang ko kinità niyo, meneng wedà dan kità kenyan. Pengkey ibeg dan domineg te kagi ko dinineg niyo, meneng wedà dan dineg kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nayan, timindeg se sebad menenoladà te menge punù ingkeliwat i Moises. Ibeg din megtandà ki Jesus, aw yan se doun te mig-insà sikandin, kagi din, “Sir, eden lay se keilangan inangen ko amon metoman a kominawà te kaling pedowan wedad temanan?” ");
INSERT INTO mbs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Minikagi si Jesus, “Eden lay se binasa no kidoen te kagi te Timanem tepad kenyan?” ");
INSERT INTO mbs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Timaba sikandin, “Binasa ko se kagi seini, ‘Kedekeli niyo te pedowan se Pengolo niyo Timanem te ontò melobos se pedowan niyo kandin, aw aneng-aneng niyo, aw keseg niyo. Kedekeli niyo heman te pedowan se doma otaw iling te peg-aneng-aneng niyo te kenyo pegkeotawun.’” ");
INSERT INTO mbs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Minikagi si Jesus, “Benal se taba nikaw. Aw yan se inangen no, metoman ka kominawà te kaling pedowan wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Meneng ibeg te otaw sìyan, ipetaga-taga din te metòlid se eg-inangen din, aw yan se doun te mig-insà sikandin, “Sinu lay se doma otaw keilangan kedekelan ko te pedowan?” ");
INSERT INTO mbs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Timaba si Jesus, “Doen sebad Judiyo nesayo lekat te Jerusalem pesalo doton te Jeriko. Peg-ipanaw din, nesàban sikandin te megdedempasay. Inabat dan se kedakel te kedònan din, aw binadas dan sikandin. Penga niyan, tinenanan dan sikandin iling te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nayan, wedà kenamay, dimateng se pengolo te simbahan te Judiyo. Meneng pegkità din te otaw sìyan nepelian, migpekediyò sikandin aw limaklak. ");
INSERT INTO mbs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Penga niyan, dimateng heman se sebad Judiyo sakop te pongan i Levi. Pegkità din te otaw sìyan nepelian, migpekediyò heman sikandin aw limaklak. ");
INSERT INTO mbs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Penga niyan, doen mepanaw tege Samarya kenà Judiyo dimateng doton te Judiyo sìyan nepelian. Pegkità din kandin, ontò din neidowan. ");
INSERT INTO mbs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dimoton aw binolong din se palì te lana aw bino, aw binagkes din. Penga niyan, impesakay din diyà te kodà din, aw inibing din doton te balay eg-ogpaan te mepanaw, aw inipat din kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Keeldawan niyan, imbegay din se kwarta diyà te tig-apò te balay sìyan aw minikagi sikandin, ‘Ipati sikandin. Aw labi pa dakel se gasto din, beyadan ko iyan aw lomikò a dini.’ ");
INSERT INTO mbs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nayan, eden lay se kamno aneng-aneng? Pengkey telo se otaw kimità te otaw nepelian te megdedempasay, meneng sinu lay se migpetaga-taga te dakel se pedowan din diyà te doma otaw?” ");
INSERT INTO mbs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Timaba se menenoladà, “Sìyan tege Samarya doen keido din.” Minikagi si Jesus, “Pengkey kenan ka pesalo, keilangan iling heman kenyan se inangen nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nayan, dimeleg dan aw minokit dan doton te sebad lonsod. Doen bayi si Marta kidoen migpeapit ki Jesus doton te balay din. ");
INSERT INTO mbs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Dalem te peg-inang i Marta te kànen, gayed nenenoo se adi din si Maria diyà te dapag i Jesus amon menenalan te itoladà din. ");
INSERT INTO mbs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Meneng ontò nebuyung si Marta, so sebad din se mig-inang te kànen. Penga niyan, dimoton si Marta ki Jesus, aw minikagi, “Pengolo, sebad ko se mig-inang te kànen, so wedà pegtelaban se adi ko. Aw doen keido no kanak, sogoi sikandin megtelaban kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Meneng timaba se Pengolo, “Tay law, Marta. Pelaban ka netetana tepad te medita eg-inangen nikaw. ");
INSERT INTO mbs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Meneng sebad olò se kolang nikaw. Labi pa mèpiya se ininang i Maria, aw eked ko segdahi se pegpenenalan din kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nayan, doen sebad aldaw migtawal-tawal si Jesus. Penga te pegtawal-tawal din, minikagi se sebad tinoledaan din, “Pengolo, toledai kay megtawal-tawal iling te pegtoladà i Juan Memonyagay diyà te menge tinoledaan din.” ");
INSERT INTO mbs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Minikagi si Jesus, “Iling kani se itawal-tawal niyo. ‘Amà, ibeg day iduyun ka te kedita te otaw. Ibeg day lomowan ka diyà te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Begayi kay te kànen botong te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pegwedadi se salà ininang day diyà kamno, so egwedad kay te salà eg-inangen te doma otaw diyà kenami. Ikà egpeokit kenami diyà te peg-akal.’” ");
INSERT INTO mbs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Migtoladà heman si Jesus kandan tepad te pegtawal-tawal, kagi din, “Simpana domateng se mepanaw diyà te balay te sigalak din, meneng wedad ipekaen te tig-apò te balay kandin. Seini se inangen din. Pengkey tengà te delem, domoton se otaw sìyan te simbalay, aw memoyò diyà te sigalak din, kagi din, ‘Elew, tebangi a bag, so doen sigalak ko dimateng lekat te mediyò, meneng wedad ipekaen ko kandin.’ ");
INSERT INTO mbs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Simpana tomaba se otaw lekat didalem, ‘Ikà egsamok kanak. Netakep den se lelebangan ko, aw timedogi a den sipat menge mengisù ko. Eked a den enaw amon memegay a kamno.’ ");
INSERT INTO mbs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nayan, eneng-enengi niyo ini. Pengkey eked peden sikandin enaw amon megtabang kandin so sigalak din, meneng aw eked lengà se otaw memoyò, yan se doun te keilangan menaw sikandin amon memegay kandin te pengkey eden se kepulukan din. ");
INSERT INTO mbs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eneng-enengi niyo ini. Aw memoyò kaw diyà te Timanem, begayan kaw din. Aw mengemahà kaw, doen kitaen niyo. Aw tomawal kaw doton te lelebangan, ipeawop kaw. ");
INSERT INTO mbs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kominawà se kedita te otaw memoyò. Komità heman se kedita te otaw mengemahà. Ipeawop heman se kedita te otaw tomawal. ");
INSERT INTO mbs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aw doen batà niyo memoyò te ikan, eked kaw pemegay kandin te memokan. ");
INSERT INTO mbs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aw memoyò se batà niyo te batà te manok, eked kaw heman pemegay kandin te inenipit. ");
INSERT INTO mbs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nayan, pengkey doen medaet eg-inangen niyo, meneng gayed mèpiya se ipegpemegay niyo diyà te menge batà niyo. Labi pa se Amay niyo Timanem kidoen te langit, so egpemegay sikandin te Espiritu Santo diyà te kedita te otaw memoyò diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Doen sebad aldaw migpelowà si Jesus te bosaw migpeomo te otaw dinetengan din. Penga te pegpelowà din te bosaw, nekeikagi den se otaw, aw yan se doun te ontò nepela se doma otaw kimità kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Meneng eg-ikagi se doma otaw, “Binegayan sikandin te tolos lekat te pengolo te bosaw si Belsebul, se doma ngadan i Satanas, aw yan se doun te egpelowà sikandin te bosaw lekat te otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Doen heman menge doma otaw migtandà peden ki Jesus aw doen pengilala ipekità din diyà kandan amon ketegahan dan te ontò sikandin insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Meneng netaga-taga si Jesus aw eden se aneng-aneng dan, aw yan se doun te minikagi sikandin, “Simpana megbebolaw se sakop te sebad lonsod, aw megbebolaw se otaw migsebad te balay, kebàtan se lonsod dan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nayan, eg-ikagi kaw te egpelowà a te bosaw lekat te otaw pineokit te tolos imbegay i Satanas diyà kanak. Meneng simpana megbolaw si Satanas diyà te menge sakop din, kebàtan se peglowan din. ");
INSERT INTO mbs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aw sinila niyo se pegpelowà ko te bosaw so aneng-aneng niyo pineokit iyan te tolos i Belsebul, sinila niyo heman se kenyo tinoledaan, so egpelowà dan heman te bosaw lekat te otaw. Yan se doun te sikandan se megpetaga-taga kenyo te kolang se pegsila niyo kanak. ");
INSERT INTO mbs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Meneng aw pineokit te tolos imbegay te Timanem se pegpelowà ko te bosaw lekat te otaw, yan ketegahan niyo te dimateng den dini kenyo se peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Aw megbantay se otaw te balay din, aw magsen sikandin, aw doen kekamang din, eked keagaw se kedònan din. ");
INSERT INTO mbs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Meneng aw domateng se otaw labi pa magsen diyà kandin, yan se domaeg te tig-apò te balay aw meg-agaw te kedita te kekamang sineligan din, aw iteped heman se kedònan din diyà te menge doma otaw. ");
INSERT INTO mbs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Se kedita te otaw eked pegpesakop diyà kanak, yan se egpoon kanak. Aw se kedita te otaw kenà egtelaban kanak, yan se egpekadas te doma otaw lekat kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Aw ipelowà se bosaw lekat te otaw, meglegeb se bosaw doton te kebigtilan amon mengemahà te mèpiya ogpeanan din. Aw wedad ketelaan din, mikagi sikandin, ‘Mèpiya pa aw lomikò a doton te otaw tapay ko eg-ogpaan.’ ");
INSERT INTO mbs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lomikò se bosaw doton kandin, aw kitaen din se otaw tapay din inogpaan te mèpiya den, iling te balay melinis aw mèpiya pegkesawol. ");
INSERT INTO mbs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Penga niyan, mangay se bosaw te doma pito bosaw labi pa medaet. Domoton se kedita dan te otaw sìyan aw meg-ogpà dan diyà kandin. Yan labi pa medaet se pegkesawol te otaw sìyan diyà te tapay pegkesawol din.” ");
INSERT INTO mbs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pegtoladà i Jesus te otaw netipon, doen bayi timawal diyà kandin, kagi din, “Doen ontò keluba te bayi migbatà aw migpesoso kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Meneng minikagi si Jesus, “Labi pa meluba se kedita te otaw domineg te kagi te Timanem aw tomolò dan heman kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sagwa labi pa medita se otaw netipon diyà ki Jesus, minikagi sikandin, “Medaet se ibeg te kedita te otaw songkani, so gayed kaw egkeibeg te ipekità ko diyà kenyo se pengilala. Meneng sebad olò se pengilala ipekità te Timanem diyà kenyo, aw yan se iling te neinang ki Jonas gebii. ");
INSERT INTO mbs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pineokit te neinang ki Jonas, netaga-taga se tege Niniba te ontò sikandin insogò te Timanem. Iling heman kenyan, doen heman meinang diyà kanak Timanem Migpekeotaw amon metaga-taga se kedita niyo te ontò a insogò te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aw domateng se aldaw te peg-okom te Timanem te kedita te otaw, tomindeg heman se selotan bayi limowan doton te Siba gebii, aw mikagi sikandin te keilangan ipelumun kaw so wedà kaw penenalan kanak. Pengkey mediyò se ogpeanan din, meneng dimoton sikandin ki Solomon amon menenalan te kebiyasa ipegtoladà din. Na, pengkey melangkaw si Solomon, meneng doen den dimini labi pa melangkaw diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aw domateng se aldaw te peg-okom te Timanem te kedita te otaw, mikagi heman se tege Niniba te keilangan ipelumun kaw so wedà kaw pegselsel te salà, so pegdineg te tege Niniba te intoladà i Jonas, migselsel dan te salà. Na, pengkey melangkaw si Jonas, meneng doen den dimini kenyo labi pa melangkaw diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Aw menemtem se otaw te solò, eked din iyan elesi kidoen te awang te tanà. Eked din heman sengkobi te gentangan. Meneng mèpiya aw isawol din iyan diyà te kelengkawan amon keenyagan se didalem te balay. ");
INSERT INTO mbs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Komità se otaw pineokit te mata. Aw mèpiya se mata te otaw, melowa se pegtengteng din. Meneng aw medaet se mata, iling te mengitngit se pegtengteng din pengkey aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iling heman kenyan, keilangan megpekeimanday kaw amon kenà medaet se pedowan niyo pengkey aneng-aneng niyo mèpiya se pedowan. ");
INSERT INTO mbs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Meneng aw meleseb se pedowan niyo, wedad medaet inangen niyo, so tomalag mèpiya se meinang niyo. Melowa iyan kitaen te doma otaw iling te solò eg-anyag.” ");
INSERT INTO mbs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Penga te pegtoladà i Jesus, doen sakop te menge Parisiyo migpekaen kandin. Pegdateng i Jesus doton te balay din, minawop aw kimaen doma din. ");
INSERT INTO mbs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Meneng ontò nepela se Parisiyo ki Jesus, so wedà sikandin taking te ketanem te menge Judiyo tepad te peg-onaw te belad te wedà pa kaen. ");
INSERT INTO mbs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Meneng minikagi se Pengolo, “Sikiyo menge Parisiyo, gayed kaw eg-ingà aw eglalang te medaet. Iling kaw te otaw olò eg-onaw te lowà te baso aw lipong pengkey melipà pa se didalem niyan. ");
INSERT INTO mbs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wedad inenengen niyo. Ininang kaw te Timanem, aw ibeg din, tomalag mèpiya se pedowan niyo aw eg-inangen niyo. ");
INSERT INTO mbs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Keilangan lekat te keido te pedowan niyo se pegpemegay niyo diyà te otaw nelimahan, aw yan meinang kaw ontò mèpiya. ");
INSERT INTO mbs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mekelelayò kaw menge Parisiyo, so pengkey egpemegay kaw diyà te Timanem te ikesempolò ketengà te kedita te geniyen niyo pengkey menge enagay, meneng wedà niyo beling inangi se keilangan inangen tepad te metòlid inang diyà te doma otaw, aw kedakel te pedowan niyo diyà te Timanem. Yan se keilangan inangen niyo, meneng pedeleg kaw heman te pegpemegay niyo diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mekelelayò kaw menge Parisiyo, so ibeg niyo menenoo kidoen te onsedanan impetagad kenyo doton te simbahan te Judiyo amon ipelangkaw kaw te doma otaw. Ibeg niyo heman segmanen kaw te doma otaw doton te pedyanan. ");
INSERT INTO mbs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mekelelayò kaw, so medaet se awop te pedowan niyo. Iling kaw te lebeng eked kilelai te otaw mokit kidoen.” ");
INSERT INTO mbs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Doen sebad menenoladà te punù ingkeliwat i Moises minikagi diyà ki Jesus, “Sir, peg-ikagi no kenyan diyà te menge Parisiyo, sinila kay heman doma dan.” ");
INSERT INTO mbs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Minikagi si Jesus, “Mekelelayò kaw heman menenoladà te punù ingkeliwat i Moises, so gayed niyo egdogangan se punù ontò melima toloen te otaw, meneng kenà kaw egtelaban te otaw meibeg tomolò kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mekelelayò kaw, so pengkey egpelasan niyo se menge lebeng te telekeliwat te kagi te Timanem gebii, meneng sikandan se inimetayan te kenyo kemonaan. ");
INSERT INTO mbs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pineokit te pegpalas niyo te lebeng dan, ipetaga-taga niyo te egtandù kaw te pegpengimatay te kemonaan niyo kandan. Kemonaan niyo se nengimatay te menge telekeliwat te kagi te Timanem, aw sikiyo se egpalas te menge lebeng dan. ");
INSERT INTO mbs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yan se doun te minikagi se Timanem, ‘Isogò ko doton kandan se menge telekeliwat te kagi ko aw menge sogounun ko. Meneng doen imetayan dan, aw pemilangen dan heman se doma.’ ");
INSERT INTO mbs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nayan, ipelumun te Timanem se kedita niyo songkani tandà te pegpengimatay te kemonaan niyo te menge telekeliwat te kagi din lekat te keteboan te keneyonan lamig seini, ");
INSERT INTO mbs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","lekat te peg-imatay dan ki Abel taman te peg-imatay dan ki Zacarias kidoen te dowangen te dakel simbahan medapag te sonoganan te ayam-ayam ibegay diyà te Timanem. Mikagi a den diyà kenyo te metoman ipelumun te Timanem se kedita niyo songkani tandà te pegpengimatay kandan. ");
INSERT INTO mbs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mekelelayò kaw menge menenoladà te punù ingkeliwat i Moises. Iling kaw te otaw mig-eles te konsì te balay amon wedad mekeawop, so wedà kaw keibeg aw doen otaw mekelabet te kagi te Timanem insolat. Wedà kaw pemenal te kagi din, aw egbelebagan niyo heman se menge otaw egkeibeg memenal kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nayan, nesayo si Jesus lekat te balay sìyan. Meneng se menge Parisiyo aw menenoladà te punù, gayed dan mig-insà diyà kandin so medaet se pedowan dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ibeg dan peden ketelaan dan se kemalì diyà te kagi din amon doen idimanda dan tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nayan, dalem te pegtoladà i Jesus, minelalan se otaw netipon diyà kandin igsà migpegìtay dan te benis. Onà minikagi si Jesus diyà te menge tinoledaan din, “Peg-ahà kaw amon eked kaw ketini te salà te menge Parisiyo, so eden dan aw egpenimanem dan. ");
INSERT INTO mbs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Meneng kitaen se kedita te salà dan te modi aldaw, so ipekità te Timanem se kedita pengkey in-eles den seini. ");
INSERT INTO mbs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pengkey eden se inikagi te wedad doma otaw dimineg, yan se dinegen te kedita te otaw. Pengkey eden se inggomod-gomod doton didalem te tambì niyo, yan se iindan diyà te kedita te otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Menge sigalak ko, penenalan kaw te kagi ko seini. Ikà niyo egkelemitan te otaw, so olò lawa niyo se mebatog dan imetayan, aw penga niyan wedad doma medaet mebatog dan inangen diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Meneng sebad se keilangan kelemitanan niyo, aw yan se Timanem, so aw mepenga se otaw matay, mebatog te Timanem ipedeleg sikandin doton te kilot. Yan se doun te keilangan Timanem se kelemitanan niyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Meneng ontò heman egkeido se Timanem te otaw. Pengkey iling te wedad keelagà te lima manok te kebenesan aw beyadan niyo, meneng wedad palos manok te kebenesan egkelibelan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","So eg-ipaten te Timanem se kedita te manok te kebenesan pengkey iling te wedad keelagà dan, ontò kaw din ipaten, so meelagà kaw pa diyà te kedita te manok te kebenesan. Pengkey logay niyo, netegahan te Timanem aw pila se kedita niyan. Yan ikà niyo egkelemitan.” ");
INSERT INTO mbs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Penenalan kaw te kagi ko seini. Aw mikagi se otaw diyà te doma te ontò sikandin migpesakop diyà kanak Timanem Migpekeotaw, mikagi a heman diyà te menge anghil te Timanem te sakop ko sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Meneng aw mikagi se otaw te kenà sikandin sakop ko, eked a heman ikagi diyà te menge anghil te Timanem te sakop ko sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Aw mikagi se otaw te medaet tepad kanak Timanem Migpekeotaw, pegwedaden iyan te Timanem aw iselsel din. Meneng aw megtompuyus se otaw te Espiritu Santo, eked pegwedadi se salà din sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aw ibingen kaw doton te menge obanen te simbahan te Judiyo aw menge opisyal te gobirno amon okomen kaw dan tandà te pegtaking niyo kanak, ikà niyo egketetana tepad te itaba niyo, aw ikegiyen niyo diyà kandan, ");
INSERT INTO mbs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","so toledaan kaw te Espiritu Santo aw eden se ikegiyen niyo kandan te aldaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Doen otaw kidoen minikagi diyà ki Jesus, “Sir, pegpunù ka diyà te kakay ko te keilangan ibegay din kanak se tengà te kedònan aw tanà tinenanan te amay day te pegkematay din.” ");
INSERT INTO mbs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Meneng minikagi si Jesus, “Tay law. Kenà a howis meg-osay kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Minikagi heman si Jesus diyà te otaw netipon, “Ikà niyo eg-ingà te kedònan te doma otaw. Pengkey ontò dakel se kedònan te otaw, meneng eked pegkelayat se omol din pineokit kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Penga niyan, mig-indan si Jesus te tegdeyanan, kagi din, “Doen otaw meyaman nekegani te ontò dakel. ");
INSERT INTO mbs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Penga niyan, mig-aneng-aneng sikandin, ‘Megmeno a? So wedad den keombaan te pol solanan te ginani ko. ");
INSERT INTO mbs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na, seini se inangen ko. Gobalen ko se tapay pol, aw penga niyan inangen ko se pol labi pa dakel, aw yan se solanan ko te kedakel te ginani ko aw kededònan ko. ");
INSERT INTO mbs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Penga niyan, aneng-aneng ko, botong den se kepulukan ko te pengkey pila se omay. Mepakay den aw eked a pegterbaho. Olò a den komaen, aw minem a, aw gayed a meluba.’ ");
INSERT INTO mbs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Meneng minikagi se Timanem, ‘Wedad palos inenengen nikaw. Matay ka den te delem seini. Pengkey dakel den se kededònan no, meneng ibegay se kedakel niyan diyà te doma otaw.’ ");
INSERT INTO mbs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iling heman kenyan se meinang diyà te otaw egkeyaman, meneng wedad aneng-aneng din diyà te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Minikagi si Jesus diyà te menge tinoledaan din, “Yan se doun te mikagi a den diyà kenyo, ikà niyo egketetana tepad te keogpà niyo aw eden se kànen niyo. Ikà niyo heman egketetana tepad te lawa niyo aw eden se ekasan niyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","So binegayan kaw den te Timanem te ontò meelagà, sìyan pedowan niyo aw lawa niyo, yan ikà niyo egketetana tepad te kànen aw ekasan niyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Eneng-enengi niyo tepad te menge owak. Kenà dan egpenanem. Kenà dan heman eglegani. Wedad heman pol egsolan dan te kànen. Meneng gayed dan egbegayan te Timanem te kànen. So eg-ipaten te Timanem se kedita te manok te kebenesan pengkey iling te wedad keelagà dan, ontò kaw din ipaten, so meelagà kaw pa diyà te kedita te manok te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pengkey metetana kaw, meneng eked pegkelayat se omol niyo pineokit te ketetana niyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aw eked kaw pekeinang te dedeitek, ikà niyo egketetana tepad te labi pa dakel. ");
INSERT INTO mbs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Eneng-enengi niyo se bolak te kebenesan. Gayed dan egtilles pengkey kenà dan egterbaho, aw kenà dan heman egpengabel te penenaktun. Meneng eneng-enengi niyo se kagi ko seini. Pengkey mèpiya se bawa te penenaktun te selotan si Solomon gebii, meneng labi pa mèpiya se bawa te bolak te kebenesan. ");
INSERT INTO mbs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","So ininang te Timanem mèpiya se bawa te bolak te kebenesan pengkey sonogen iyan te eked kenamay, labi pa metoman se peg-ipat din kenyo. Meneng wedà pa kedì kelobos se pegsalig niyo kandin. ");
INSERT INTO mbs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ikà niyo egketetana tepad te kànen niyo aw inemen niyo. Ikà niyo heman egdowa-dowa. ");
INSERT INTO mbs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Se kedita te otaw kenà egsalig te Timanem, gayed dan egketetana tepad te keogpà dan. Meneng netegahan den te Timanem se kepulukan niyo. ");
INSERT INTO mbs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yan pelowani niyo se Timanem diyà te kenyo pegkeotawun, aw yan begayan kaw din heman te keilangan niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ikà niyo egkelemitan. Pengkey pilabok kaw, meneng pinemallì kaw te Timanem amon megpesakop kaw diyà te peglowan din. ");
INSERT INTO mbs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Keilangan ibeligyà niyo se kededònan niyo, aw ipemegay niyo se kwarta diyà te otaw nelimahan. Aw yan se inangen niyo, metipon kidoen te langit se ontong niyo eked palos pegkedaet, so eked iyan ketakaw kidoen, aw eked iyan heman kebàti. ");
INSERT INTO mbs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aw kenan ketipon se ontong niyo, yan heman se keeneng-enengan niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Keilangan megpeketagad kaw te pengkey eden se domateng. Mèpiya aw iling kaw te menge sineligan egtagad te pegdateng te amo dan lekat te pista. Pengkey delem, gayed dan egpelegdeg te solò aw egpenaol dan amon somongon dan kandin te pegdateng din. ");
INSERT INTO mbs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aw domateng se amo dan, ontò dan meluba aw wedà dan tedogi aw neketagad dan. Eneng-enengi niyo se kagi ko seini. Mèpiya se inangen din diyà kandan. Meg-ekas se amo dan, aw sikandin se megpepenenoo kandan kidoen te lemisa aw megpekaen kandan. ");
INSERT INTO mbs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pengkey domateng se amo dan te tengà te delem, aw pengkey mata-mata te iselem, ontò dan meluba aw meketagad dan te pegdateng din. ");
INSERT INTO mbs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Meneng ikà niyo eg-iling te tig-apò te balay timedogi aw wedà peketagad te pegdateng te menenakaw, so aw ketegahan din aw kano dateng se menenakaw, yan meketagad sikandin, aw eked ketekawi se balay din. ");
INSERT INTO mbs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yan se doun te keilangan gayed kaw megpeketagad, so domateng a Timanem Migpekeotaw te eked niyo ketegahi aw kano.” ");
INSERT INTO mbs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mig-insà si Pedro, kagi din, “Pengolo, sinu lay se inikegiyan no te tegdeyanan sìyan? Diyà olò kenami, aw diyà te kedita te otaw?” ");
INSERT INTO mbs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Minikagi si Jesus, “Se otaw egkeseligan aw biyasa eg-inang te kedita, yan se inangen te amo din egpengibing te kedita te doma otaw doton te balay din, amon memegay kandan te kànen te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aw domateng se amo din, ontò meluba se sineligan aw gayed egtolò te impunù te amo din. ");
INSERT INTO mbs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eneng-enengi niyo se kagi ko kenyo seini. Aw yan se inangen din, meinang sikandin egpengibing te kedita doton te balay te amo din. ");
INSERT INTO mbs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Meneng aw meg-aneng-aneng se sineligan te menamay pa se pegdateng te amo din, aw egbedasen din se doma sineligan pengkey meama aw bayi, aw gayed sikandin egpengaen aw eg-inem aw egkelasing, medaet iyan, ");
INSERT INTO mbs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","so domateng se amo din te aldaw wedà din pelimani. Ipelumun sikandin te amo din, aw eked heman todà keseligi, so wedà tolò. ");
INSERT INTO mbs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nayan, aw metaga-taga se sineligan aw eden se ibeg te amo din, meneng eked tolò kenyan, ontò sikandin ipelumun. ");
INSERT INTO mbs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Meneng aw doen salà inangen te sineligan wedà ketaga-taga aw eden se ibeg te amo din, ipelumun heman sikandin, meneng kenà ontò. Se otaw binegayan te dakel, keilangan ontò mèpiya se pegpengibing din kenyan. Se otaw dakel se insalig te doma otaw kandin, keilangan ontò sikandin egkeseligan.” ");
INSERT INTO mbs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Dimini a amon ibingen ko se iling te apoy dini te tanà, aw ibeg ko peden mekelegeb iyan diyà kenyo seini. ");
INSERT INTO mbs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Meneng keilangan onà a kelimahan. Ontò melima se pegtagad ko kenyan. Ibeg ko peden mepenga den. ");
INSERT INTO mbs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ikà niyo eg-aneng-aneng te dimini a amon doen kelinaw te otaw dini lanto te tanà. Meneng penenalan kaw te kagi ko diyà kenyo. Labi pa megpedàtay se otaw te pedowan tandà te pegdateng ko, ");
INSERT INTO mbs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","so lekat seini, eked pegsebad se otaw eg-ogpà diyà te sebad balay. Aw lima dan, telo besi se megpelenged kanak, aw dowa se megpoon kanak. ");
INSERT INTO mbs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pengkey telebatà, eked dan pegsebad. Pengkey teleogangan, megpedàtay dan te pedowan tepad kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Minikagi heman si Jesus diyà te otaw netipon, “Aw kitaen niyo te domelem se egselepan te aldaw, ketegahan niyo te modan te eked kenamay, aw penga niyan metoman modan. ");
INSERT INTO mbs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aw mebandes se kelamag lekat te polò, ketegahan niyo te meinit kwani se aldaw, aw penga niyan metoman iyan. ");
INSERT INTO mbs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tay law. Eden niyo aw egpenimanem kaw, so pengkey egpengilala kaw te ledyawan kidoen te tanà aw langit, meneng wedà niyo kilelai aw eden se meinang seini.” ");
INSERT INTO mbs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nepela a kenyo so wedà kaw ketaga-taga aw eden se inang metòlid. ");
INSERT INTO mbs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pegselsel kaw den dalem te doen pa aldaw. Aw doen otaw megdimanda tepad kenyo, mèpiya aw megselsel kaw kandin kidoen pa te dalan, amon eked kaw din peibingi doton te howis, aw ibegay kaw diyà te belad te polis amon kelebosowen kaw. ");
INSERT INTO mbs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aw kelebosowen kaw, eked kaw palos pekelowà singed aw beyadan niyo se kedakel te salà.” ");
INSERT INTO mbs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, penga niyan, doen otaw kidoen mig-indan diyà ki Jesus te doen menge sakop te probinsya te Galiliya impeimatay i Pilato dalem pa te pegsonog dan te ayam-ayam imbegay dan diyà te Timanem kidoen te dakel simbahan doton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Minikagi si Jesus diyà kandan, “Ikà niyo eg-aneng-aneng te inimetayan dan so labi pa medaet se salà dan diyà te menge doma dan menge sakop te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Penenalan kaw te kagi ko kenyo. Aw eked kaw pegselsel te salà niyo, matay se kedita niyo iling kandan. ");
INSERT INTO mbs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eneng-enengi niyo se sempolò teg walo otaw netonganan te melangkaw kotà kidoen te Siloam. Pengkey negelà dan, meneng ikà niyo eg-aneng-aneng te labi pa medaet se salà dan diyà te kedita te tege Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Penenalan kaw te kagi ko kenyo. Aw eked kaw pegselsel te salà niyo, matay se kedita niyo iling kandan.” ");
INSERT INTO mbs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nayan, mig-indan si Jesus te tegdeyanan seini. “Doen kayo igira kidoen te tanà te sebad otaw. Dimoton sikandin amon mengabat te pongo niyan, meneng wedad palos kinità din. ");
INSERT INTO mbs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Penga niyan, minikagi sikandin diyà te otaw impetonggò te tanà din, ‘Na, telo pa se omay gayed a migpeliman te doen pongo te kayo seini, meneng wedad palos. Pilayi iyan, amon doen ontong ko te tanà seini.’ ");
INSERT INTO mbs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Meneng timaba se teletonggò, ‘Sir, pebeyai pa iyan te sebad mendad se omay, so ebwaban ko pa aw solan ko te tai te baka. ");
INSERT INTO mbs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mèpiya peden aw mongo iyan te modi omay. Meneng aw eked pongo, mepakay diyà kanak aw pilayen nikaw.’” ");
INSERT INTO mbs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nayan, migtoladà si Jesus kidoen te simbahan te Judiyo te Sebado aldaw te peg-etod dan. ");
INSERT INTO mbs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Doen heman bayi kidoen impeeleg te bosaw te sempolò teg walo se omay, so nebongkog sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pegkità i Jesus kandin, timawal sikandin, kagi din, “Tiyà, kegolian ka den.” ");
INSERT INTO mbs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Penga niyan, pinemàdan sikandin i Jesus, aw pegketà negolian sikandin aw dimuyun te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Meneng ontò neopal se obanen te simbahan so aldaw te peg-etod se pegpegolì i Jesus te bayi sìyan. Yan se doun te minikagi sikandin diyà te kedita te otaw kidoen, “Kelikit te simana, enem se aldaw mepakay megterbaho se otaw, aw yan se aldaw mepakay aw kegolian kaw. Meneng eked kepakay aw seini, so aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Minikagi si Jesus diyà kandin, “Tay law. Eden niyo aw egpenimanem kaw. Pengkey aldaw te peg-etod, gayed niyo eg-elinen se baka aw kodà niyo, aw eg-ibingen niyo dan doton te wayeg amon ipeinem niyo. ");
INSERT INTO mbs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aw mepakay tebangan se ayam-ayam te aldaw te peg-etod, mepakay heman aw kegolian se bayi seini sebad bowad-bowad i Abraham aw impeeleg i Satanas te sempolò teg walo se omay. Keilangan tebangan sikandin pengkey aldaw te peg-etod.” ");
INSERT INTO mbs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Peg-ikagi din kenyan, ontò neyàyà se kedita dan migpoon kandin. Meneng ontò neluba se kedita te otaw so medita se kepelahan eg-inangen din. ");
INSERT INTO mbs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nayan, minikagi heman si Jesus, “Meg-indan a den kenyo te tegdeyanan tepad te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iling iyan te ontò deitek benì intanem te otaw kidoen te pawà din. Timobò iyan aw timilles lamig neinang ontò dakel kayo, aw migsalag se manok kidoen.” ");
INSERT INTO mbs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Minikagi heman sikandin, “Seini se doma tegdeyanan tepad te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iling iyan te yist, so aw isanged iyan diyà te dakel arina, lomebag se kedakel niyan.” ");
INSERT INTO mbs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pegpesalo i Jesus doton te Jerusalem, minapit sikandin kidoen te teg sebad-sebad lonsod inokitan din amon megtoladà. ");
INSERT INTO mbs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Doen otaw mig-insà kandin, kagi din, “Sir, pilabok lay se otaw mekelowà lekat te salà?” Timaba si Jesus, ");
INSERT INTO mbs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pegpekagsen kaw mokit te lelebangan mesigpit. Penenalan kaw kanak. Medita se otaw meibeg mokit kidoen pesalo doton te peglowan te Timanem te modi aldaw, meneng eked dan peopi. ");
INSERT INTO mbs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aw megtakep se tig-apò te balay, pengkey tomawal kaw doton te lowà, eked kaw din peopi. Pengkey mikagi kaw, ‘Sir, owangi bag se tetakep nikaw.’ Meneng tomaba sikandin, ‘Wedà ko ketegahi aw kenan kaw lekat.’ ");
INSERT INTO mbs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mikagi kaw heman, ‘Meneng kimaen kay doma no, aw migtoladà ka heman kidoen te lonsod day.’ ");
INSERT INTO mbs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Meneng mikagi sikandin, ‘Wedà ko ketegahi aw kenan kaw lekat. Kesayo kaw, kedita niyo eg-inang te medaet.’ ");
INSERT INTO mbs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aw domateng se aldaw te peglowan te Timanem, ontò kaw megkelag aw megyangget-yangget se ngipen niyo tandà te kegemakan niyo, so kitaen niyo si Abraham, aw si Isaac, aw si Jacob, aw kedita te telekeliwat te kagi te Timanem gebii impeawop din. Meneng sikiyo se ipekesayo aw eked kaw peopi. ");
INSERT INTO mbs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Medita se otaw domateng lekat te kedita te ogpeanan te keneyonan, pengkey kenà dan Judiyo, aw ipeakop dan diyà te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, doen menge otaw medanà songkani, meneng meinang dan melangkaw kidoen te peglowan te Timanem. Doen heman menge otaw melangkaw songkani, meneng meinang dan kwani medanà.” ");
INSERT INTO mbs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nayan, doen menge Parisiyo dimoton ki Jesus, aw minikagi dan diyà kandin, “Kesayo ka den lekat dini, so ibeg ekon i Herod imetayan ka.” ");
INSERT INTO mbs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Minikagi si Jesus, “Pengkey biyasa sikandin eg-akal, doton kaw kandin, aw ikegihi niyo sikandin te eked a kelemitan kandin. Gayed a pa egpelowà te bosaw lekat te otaw, aw egpegolì a te otaw doen mesakit te seini aldaw aw kealdaw heman. Meneng ipengahen ko olò se inangen ko te iketelo aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nayan, keilangan domeleg a pa te seini aldaw aw kealdaw aw sebad aldaw lamig domateng a doton te Jerusalem, so gayed eg-imetayan se menge telekeliwat te kagi te Timanem kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mekelelayò kaw tege Jerusalem. Gayed niyo eg-imetayan se kedita te telekeliwat te kagi te Timanem, aw egbontogan niyo te bato se kedita te otaw insogò te Timanem dini kenyo amon matay dan. Melikit a peden megtipon kenyo amon meg-ipat a kenyo, iling te omagak lomemlem diyà te menge onsoy din. Meneng wedà kaw keibeg. ");
INSERT INTO mbs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, pinebeyaan den se ogpeanan niyo. Penenalan kaw kanak. Aw mesayo a, eked kaw kità kanak singed aw mikagi kaw, ‘Iduyun se insogò te Pengolo tadon Timanem.’” ");
INSERT INTO mbs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nayan, sebad aldaw te peg-etod, dimoton si Jesus te balay te sebad obanen te Judiyo migpelenged te Parisiyo, so impekaen din sikandin kidoen. Ontò timengteng se doma otaw kandin aw eden se inangen din. ");
INSERT INTO mbs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na, kidoen heman se otaw limebag se lawa din. ");
INSERT INTO mbs_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mig-insà si Jesus diyà te menge Parisiyo aw menenoladà te punù ingkeliwat i Moises, kagi din, “Aw megpegolì se otaw te sebad otaw te aldaw te peg-etod, mekelàpang lay sikandin te punù ingkeliwat i Moises?” ");
INSERT INTO mbs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Meneng wedad palos intaba dan. Penga niyan, nemaed si Jesus kandin, aw migpegolì kandin. Penga niyan, impeolì din sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Penga niyan, minikagi si Jesus, “Aw doen batà niyo aw baka medagdag kidoen te sokian medalem, seini indà se inangen niyo. Ayas kaw megtabang amon mekelowà pengkey aldaw te peg-etod. Sinu lay diyà kenyo se eked pegtabang?” ");
INSERT INTO mbs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Meneng wedad palos intaba dan kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pegpenenoo dan kidoen te lemisa, kinità i Jesus te gayed migpeonà-onà se menge otaw amon menenoo dan diyà te bangkò impetagad te otaw melangkaw. Yan se doun te mig-indan sikandin te tegdeyanan diyà te kedita dan, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Aw ipetanod kaw te peipid, ikà niyo onà egpenenoo diyà te bangkò impetagad te otaw melangkaw, so doen besi doma otaw ipetanod labi pa melangkaw diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aw tapay kaw den nenenoo, domateng se tigbatà aw mikagi diyà kenyo, ‘Tindeg kaw den, so ipepenenoo ko se otaw sida.’ Aw yan ontò kaw meyàyà, so modi kaw ipekaen. ");
INSERT INTO mbs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Meneng labi pa mèpiya aw seini se inangen niyo. Aw ipetanod kaw te peipid, ikà niyo egpenenoo diyà te bangkò impetagad te otaw melangkaw. Aw komità se tigbatà kenyo, mikagi peden sikandin, ‘Elew, penenoo kaw dini te onsedanan te otaw melangkaw.’ Yan kebegayan kaw te dengeg kidoen te kedita te doma niyo. ");
INSERT INTO mbs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aw megpelangkaw-langkaw se otaw, meinang sikandin medanà. Meneng aw megpedanà se otaw te kandin pegkeotawun, meinang sikandin melangkaw.” ");
INSERT INTO mbs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Minikagi heman si Jesus diyà te otaw migpetanod kandin, “Aw meg-inang ka te dakel kànen, pengkey alas dosi aw delem, ikà egpetanod te menge sigalak no, aw kedowa no, aw menge gaked no, aw simbalay no meyeyaman. Aw yan se menge otaw ipetanod no, onawa se inangen dan kwani, so ipekaen ka dan heman iling te ininang no kandan. ");
INSERT INTO mbs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Meneng aw meg-inang ka te kànen, mèpiya aw ipetanod no se otaw sagkep, aw nepantig, aw kapig, aw bota. ");
INSERT INTO mbs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aw iling kenyan se otaw ipetanod no, ontò ka meluba, so eked dan keinang se ininang no diyà kandan. Meneng Timanem se memegay kamno te ontong te aldaw te peg-antay din lekat te nematay te kedita te otaw mig-inang te metòlid.” ");
INSERT INTO mbs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nayan, sagwa dimineg se sebad otaw kimaen doma din, minikagi sikandin, “Aw lomowan se Timanem, ontò kidon meluba aw ipetanod kidon din te peg-inang din te dakel kànen.” ");
INSERT INTO mbs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Meneng minikagi si Jesus, “Doen otaw mig-inang te ontò dakel kànen, aw medita se otaw inindanan din. ");
INSERT INTO mbs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pegdateng te aldaw te pegkaen, doen sineligan insogò din mangay te kedita te otaw inindanan din, so integilan din den se kedakel te kànen. ");
INSERT INTO mbs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Meneng mig-eked se kedita dan. Doen otaw minikagi, ‘Minayad a den te tanà, aw keilangan domoton a amon tomengteng a kenyan. Keidowi a bag, so eked a peketanod.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Minikagi se doma otaw, ‘Minayad a den te sempolò se baka eglegoyod te daro, aw domoton a den amon telemanen se peglegoyod dan te daro. Keidowi a bag, so eked a peketanod.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Minikagi heman se doma otaw, ‘Kaling a pa nengognan, aw yan se doun te eked a peketanod.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Penga niyan, minolì se sineligan aw mig-indan kenyan diyà te amo din. Pegdineg te otaw kenyan, neopal sikandin, aw minikagi, ‘Kegaen ka doton te menge kersada aw menge dalan te lonsod, aw petekingi dini se otaw ketelaan no pengkey sagkep, aw nepantig, aw otaw bota, aw kapig.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wedà kenamay, minikagi se sineligan, ‘Sir, timolò a den te impunù no kanak, meneng doen pa keombaan.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Minikagi heman se amo din, ‘Doton ka heman te ogpeanan mediyò te lonsod, aw ontò ka ikagi diyà te otaw amon tomanod dan, so ibeg ko mepenò se balay ko te otaw ipekaen ko. ");
INSERT INTO mbs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Meneng se otaw tapay ko tinawal, eked ko dan palos pekàni te dakel kànen seini.’” ");
INSERT INTO mbs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nayan, ontò medita se otaw timaking ki Jesus kidoen te dalan. Miniling sikandin aw minikagi diyà kandan, ");
INSERT INTO mbs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Aw meibeg se otaw tomaking kanak, eked ko sikandin inangi tinoledaan ko singed aw sebad ko se tekingan din. Eked kepakay aw tekingan din heman se amay din, aw inay din, aw esawa din, aw batà din, aw menge kedowa din, aw pengkey ibeg te pedowan din. ");
INSERT INTO mbs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eked ko heman inangi tinoledaan ko se otaw eked tayod te kelimahan pengkey imetayan sikandin tandà te pegtaking din kanak. ");
INSERT INTO mbs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Keilangan onà meg-aneng-aneng se otaw aw meketayod sikandin tomaking kanak. Iling sikandin te otaw meg-inang te balay. Onà din eneng-enengen aw pila se keelagà niyan, aw botong se ibayad din amon mepenga iyan. ");
INSERT INTO mbs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Simpana kenà botong se kwarta din, eked kepenga se balay din. Penga te pegtollok din, aw eked deleg, mebebayat se kedita te otaw komità kenyan, aw somila dan kandin, ");
INSERT INTO mbs_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kagi dan, ‘Pengkey migtebò sikandin mig-inang te balay, meneng wedà din kepenga.’ ");
INSERT INTO mbs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Se otaw meibeg tomaking kanak, iling heman sikandin te selotan doen sempolò melalan sondalo din. Meneng aw kelowan melalan se sondalo te poon din, keilangan onà sikandin meg-aneng-aneng aw botong se keseg te sondalo din amon mekedaeg dan te medita sondalo te poon din. ");
INSERT INTO mbs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Simpana aneng-aneng din eked pekedaeg, pengkey mediyò pa se poon din, doen otaw isogò din somongon kandan amon megsebad dan aw wedad gira. ");
INSERT INTO mbs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iling heman kenyan, keilangan onà meg-aneng-aneng se otaw meibeg tomaking kanak. Aw eked tanan se otaw te kedakel te kedònan din amon tomaking kanak, eked ko inangi tinoledaan ko.” ");
INSERT INTO mbs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nayan, isanged se asin diyà te kànen amon mèpiya se nanam. Meneng simpana megkewedad se kepait te asin, eked iyan ketodà. ");
INSERT INTO mbs_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pengkey isawol iyan doton te pawà, aw isanged iyan diyà te bebolong te tanà, wedad den kekemowan kenyan, so keilangan iagbel. Keilangan menenalan se kedita niyo doen telinga.” ");
INSERT INTO mbs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nayan, medita se iskribinti aw doma otaw nelegeb te salà migpedapag diyà ki Jesus amon domineg dan te itoladà din. ");
INSERT INTO mbs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yan se doun te migtindaet se menge Parisiyo aw menenoladà te punù, aw minikagi dan, “Medaet se eg-inangen din, so egsigelaken din se menge otaw egpekesalà aw eglàpang te punù ingkeliwat i Moises. Medaet so egpengaen sikandin doma dan.” ");
INSERT INTO mbs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pegketaga-taga i Jesus te eg-ikegiyen dan, mig-indan sikandin te tegdeyanan seini, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Aw doen otaw doen sebad gatos ayam-ayam din karniro, aw metalon se sebad, tenanan din se kesyaman teg siyam doton te tanà doen sagbet, aw pemehaen din se sebad netalon lamig kitaen din. ");
INSERT INTO mbs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pegkità din, ontò sikandin meluba aw ibingen din molì. ");
INSERT INTO mbs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aw molì sikandin, tewalen din se menge sigalak din aw simbalay din, kagi din, ‘Keilangan meluba kaw heman, so kinità ko den se karniro netalon.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nayan, penenalan kaw te kagi ko. Iling heman kenyan, pengkey sidebok se otaw nelegeb te salà, aw megselsel sikandin, doen keluba doton te langit labi pa dakel diyà te keluba tepad te kesyaman teg siyam otaw wedà pegselsel so eg-inang dan te metòlid.” ");
INSERT INTO mbs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aw doen sempolò se kwarta te bayi plata meelagà, aw metalon se sebad, temteman din se solò, aw ponasan din heman se balay, aw ontò din pemehaen lamig kitaen din. ");
INSERT INTO mbs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aw kitaen din iyan, tewalen din se menge sigalak din aw menge simbalay, kagi din, ‘Keilangan meluba kaw heman, so kinità ko den se kwarta netalon.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Penenalan kaw te kagi ko. Iling heman kenyan, meluba se menge anghil te Timanem pengkey olò sebad se otaw megselsel te salà din.” ");
INSERT INTO mbs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Minikagi heman si Jesus, “Doen otaw dowa se batà din meama. ");
INSERT INTO mbs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Minikagi se adi diyà te amay din, ‘Amà, ibeg ko ibegay no den kanak se ketengà te tanà aw kedònan tenanan no kenami aw matay ka.’ Penga niyan, tinengà te amay se tanà din, aw imbegay din iyan diyà te didowa batà din. ");
INSERT INTO mbs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Penga niyan te wedà kenamay, imbeligyà te adi se tanà imbegay kandin, aw nesayo sikandin nengibing te kwarta din. Dimoton sikandin te ontò mediyò ogpeanan, aw pigbàtan din se kwarta din kidoen pineokit te medaet eg-inangen din wedad ontong. ");
INSERT INTO mbs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pegkeamin te kwarta din, dimateng se ontò medaet bayil, aw ontò den sikandin nelidò. ");
INSERT INTO mbs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Penga niyan, migpeido-ido sikandin diyà te sebad otaw doen tanà kidoen, aw impetonggò sikandin te menge osa. ");
INSERT INTO mbs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ontò sikandin binallos, aw kànen din peden se egpengànen te osa, so wedad doma kànen din. Wedad otaw neido kandin, aw wedad heman kànen imbegay kandin. ");
INSERT INTO mbs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Meneng mig-aneng-aneng sikandin, ‘Se kedita te otaw egterbaho kidoen te amay ko, ontò dakel se kànen dan. Meneng siak, agpet a matay dini tandà te ballos ko. ");
INSERT INTO mbs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mèpiya aw molì a den doton te amay ko, aw megselsel a diyà te Timanem aw diyà te amay ko. ");
INSERT INTO mbs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mikagi a heman diyà kandin te mepakay aw eked a din peden tewali batà din, meneng inangen a din iling te otaw egtendanan din.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Penga niyan, timindeg sikandin aw minolì. “Pengkey mediyò pa se balay, meneng kinità sikandin te amay din aw neidowan din. Kimagnan se amay doton te batà din, aw kimeles kandin, aw nengadek kandin. ");
INSERT INTO mbs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Minikagi se batà din, ‘Amà, doen salà ininang ko diyà te Timanem aw diyà heman kamno. Eked a no peden tewali batà nikaw.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Meneng timawal se amay din diyà te menge sineligan, kagi din, ‘Kegaen kaw. Ibingi niyo se ontò mèpiya saol ekasan din. Pepeningsingi niyo heman sikandin, aw pesepetosi niyo. ");
INSERT INTO mbs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Engayi niyo se nati te baka melambò amon iyawen, so meg-inang kidon te dakel kànen tandà te luba tadon. ");
INSERT INTO mbs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eden ko aw nematay den se batà ko seini, meneng neantay pa kedì. Netalon sikandin, meneng kinità.’ Penga niyan, migtebò dan se migpista. ");
INSERT INTO mbs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nayan, te peg-olì te adi, doton pa te pawà se kakay din. Meneng pegkedapag te kakay din diyà te balay, dinineg din se menge otaw migdelangan aw simayaw. ");
INSERT INTO mbs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pegdineg din kenyan, tinawal din se sebad sineligan aw mig-insà aw eden se neinang. ");
INSERT INTO mbs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Timaba sikandin, ‘Minolì den se adi no, aw impeiyaw te amay niyo se nati te baka melambò, so nekeolì den se adi no aw wedad mesakit.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pegdineg din kenyan, ontò neopal se kakay igsà wedà penayit diyà te balay. Penga niyan, timenà se amay din amon ipepenayit. ");
INSERT INTO mbs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Meneng minikagi se kakay batà din, ‘Tay law. Pengkey pila se omay, gayed a pa timolò kamno, aw wedad palos punù no linèpangan ko. Meneng wedad palos imbegay no kanak, pengkey kambing deitek, amon lelahen ko se menge sigalak ko. ");
INSERT INTO mbs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Meneng se doma batà no sida, pigbàtan din den se kwarta no imbayad din te bayi. Meneng peg-olì din, impeiyaw no ekon se melambò nati te baka amon meluba sikandin.’ ");
INSERT INTO mbs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Minikagi se amay din, ‘Atò, gayed ki egpetekingay, aw pengkey eden se kanak, kamno heman iyan. ");
INSERT INTO mbs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Meneng keilangan megpelelahay kidon aw megpelubahay kidon, so eden ko aw nematay den se adi no, meneng neantay pa kedì. Netalon sikandin, meneng kinità.’” ");
INSERT INTO mbs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mig-indan heman si Jesus te tegdeyanan seini diyà te menge tinoledaan din, kagi din, “Doen otaw impetonggò te datò diyà te kedakel te keyemanan din. Nayan, dinineg te datò te pigbàtan te teletonggò se keyemanan din. ");
INSERT INTO mbs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Penga niyan, tinawal te datò se otaw sìyan, aw minikagi, ‘Medaet se dinineg ko tepad kamno. Ibingi dini se kedita te libro tepad te kwarta insalig ko diyà kamno, so eked a den salig kamno.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nayan, mig-aneng-aneng se sineligan, ‘Agpet den wedad otaw megtandan kanak. Megmeno a? So kenà botong se keseg ko amon meg-inang a te pawà, aw meyàyà a aw meinang a metipemoyò. ");
INSERT INTO mbs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na, netegahan ko den aw eden se inangen ko. Aw metoman iyan, pengkey ipekesayo a te amo ko, meneng medita pa se sigalak ko megsagman kanak kidoen te balay dan.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Penga niyan, tinawal din se kedita te otaw teg sebad-sebad doen salà dan diyà te amo din. Tinawal din se tagnà aw minikagi, ‘Pila lay se kedakel te salà no diyà te amo ko?’ ");
INSERT INTO mbs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Timaba sikandin, ‘Sebad gatos lata se lana.’ Minikagi se sineligan, ‘Seini se papil tapay no pigpirmahan. Penenoo ka den aw solat ka te keliman olò lata. Kegaen ka.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Penga niyan, tinawal din se doma otaw, aw minikagi sikandin, ‘Pila lay se kedakel te salà nikaw?’ Timaba sikandin, ‘Sebad gatos sako se omay trigo.’ Minikagi se sineligan, ‘Seini se papil tapay no pigpirmahan. Solat ka den te kewelowan olò sako.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nayan, pengkey migtostos se sineligan te salà te otaw diyà te amo din, meneng dimuyun se amo kandin, so biyasa sikandin miglalang te kèpiyaan. Pengkey biyasa se menge sakop te Timanem egpengabat te ontong, meneng labi pa biyasa egpengabat te ontong se menge otaw kenà egtaking te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Minikagi heman si Jesus, “Seini se punù ko diyà kenyo. Tebangi niyo se menge doma otaw te kwarta niyo dini te keneyonan. Yan aw meamin iyan, ipeogpà kaw te Timanem doton te langit aw matay kaw. ");
INSERT INTO mbs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aw keseligan se otaw pengkey deitek se isalig diyà kandin, keseligan heman sikandin aw dakel se isalig diyà kandin. Meneng aw eked keseligi se otaw aw deitek se isalig diyà kandin, eked heman sikandin keseligi te dakel. ");
INSERT INTO mbs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nayan, aw eked kaw keseligi dalem te pegpengibing niyo te kwarta dini te keneyonan, eked kaw heman keseligi te Timanem te ontò keyemanan doton te langit. ");
INSERT INTO mbs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aw eked kaw keseligi dalem te pegtonggò niyo te kedònan insalig te doma otaw diyà kenyo, eked kaw heman begayi te Timanem te ontong niyo doton te langit. ");
INSERT INTO mbs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wedad sineligan meketolò te dowa amo din. Aw megpelenged sikandin diyà te sebad, eked sikandin tolò te sebad. Sebad olò se tekingan din, aw eked din segmani se sebad. Iling heman kenyan, eked pegsebad se pegpenimanem niyo aw pegpengewarta niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nayan, pegdineg te menge Parisiyo te intoladà i Jesus, pigbàtan-bàtan dan sikandin, so egkeibegan dan se kwarta. ");
INSERT INTO mbs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Meneng minikagi si Jesus, “Sikiyo se egpelingo-lingo te metòlid se eg-inangen niyo, meneng netaga-taga se Timanem te medaet se pedowan niyo. Pengkey megpelangkaw-langkaw kaw, meneng ontò iyan medaet diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Te wedà pa pegtoladà si Juan Memonyagay, keilangan toloen se punù ingkeliwat i Moises aw menge telekeliwat te kagi te Timanem. Meneng lekat te pegtebò te pegtoladà i Juan lamig seini, gayed ipegtoladà se Mèpiya Indan tepad te peglowan te Timanem, aw medita se otaw ontò meibeg megpesakop diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pengkey megkewedad se langit aw tanà, meneng eked palos pegkewedad se punù te Timanem te eked pa iyan ketoman. ");
INSERT INTO mbs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aw somibwan se meama te esawa din, aw mengognan diyà te doma bayi, mekelakad sikandin. Aw mengognan se otaw diyà te bayi sinibwanan te esawa din, mekelakad heman sikandin.” ");
INSERT INTO mbs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Doen otaw meyaman egpenaol te ontò meelagà, aw egpengaen te ontò mèpiya te kelikit te aldaw. ");
INSERT INTO mbs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Doen heman otaw sagkep ngadan din si Lazaro. Nelegeb se lawa din te palì, aw gayed sikandin ipegpeibat kidoen te lowà te balay te otaw meyaman. ");
INSERT INTO mbs_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ibeg din peden komaen olò te momò lekat te lemisa te otaw sìyan meyaman. Gayed heman egdilaan te menge toyang se menge palì din. ");
INSERT INTO mbs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nayan, nematay se otaw sagkep, aw inibing sikandin te menge anghil doton te tangkil te kemonaan din si Abraham kidoen te langit. Penga niyan, nematay heman se otaw meyaman aw inlebeng. ");
INSERT INTO mbs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Inibing sikandin doton te ogpeanan te otaw nematay, aw ontò sikandin ineleg kidoen. Limengag sikandin aw timengteng diyà ki Abraham ontò mediyò aw kidoen si Lazaro te tangkil din. ");
INSERT INTO mbs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Timawal sikandin, ‘Apò Abraham, keidowi a bag. Sogoi si Lazaro megbawog te intetodò din diyà te wayeg amon ipetedak diyà te dilà ko, so ontò a ineleg dini te apoy seini.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Meneng minikagi si Abraham, ‘Atò, eneng-enengi ini. Te wedà ka pa kematay, wedad palos lidò no so dakel se kedònan no mèpiya, meneng gayed doen kelimahan i Lazaro. Nayan, ontò den sikandin neluba dini, aw sikona den se ineleg kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Doen pa sebad mendad egpekeanggà. Doen medalem awang kidoen te tengà-tengà ta eked keokiti te otaw megpesalo peden doton kamno, aw wedad heman mekedini lekat kamno.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Minikagi se otaw meyaman, ‘Apò, aw eked no sogoi si Lazaro dini, sogoi sikandin doton te balay te menge kedowa ko. ");
INSERT INTO mbs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Doen pa lima kedowa ko, aw ibeg ko indanan din dan te keilangan megselsel dan te salà, amon eked dan heman peibingi dini te kededàtan.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Meneng minikagi si Abraham, ‘Gayed doen punù ingkeliwat i Moises aw menge telekeliwat te kagi te Timanem egbesahen dan. Mèpiya aw menenalan dan kenyan.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Minikagi se otaw meyaman, ‘Apò, eked dan penenalan kenyan. Meneng aw doen otaw meantay lekat te nematay isogò no doton kandan, metoman dan megselsel te salà dan.’ ");
INSERT INTO mbs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Minikagi si Abraham, ‘Aw eked dan penenalan te punù ingkeliwat i Moises aw menge telekeliwat te kagi te Timanem, eked dan heman pemenal pengkey doen meantay lekat te nematay.’” ");
INSERT INTO mbs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Minikagi si Jesus diyà te menge tinoledaan din, “Doen gayed mekebaet te pegpemenal te kedita te otaw, meneng mekelelayò se otaw eg-inang kenyan, so ontò sikandin ipelumun. ");
INSERT INTO mbs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Labi pa mèpiya aw iketan se lieg din te dakel bato aw idagdag doton te lawod, amon eked din kebàti se pegpemenal te mengisù migpesakop diyà kanak, pengkey sebad. ");
INSERT INTO mbs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Keilangan megpekeimanday kaw. “Na, aw doen otaw meg-inang te salà diyà kenyo, ikagi kaw diyà kandin tepad te salà ininang din. Aw megselsel sikandin, pegwedadi niyo se salà ininang din. ");
INSERT INTO mbs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pengkey mekepito sikandin peg-inang te medaet diyà kenyo dalem te sebad olò se aldaw, kelikit te pegselsel din kenyan, keilangan pegwedaden niyo se kedita te salà din.” ");
INSERT INTO mbs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Minikagi se menge sogounun i Cristo, “Lobosi se pegsalig day diyà kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Minikagi se Pengolo, “Mikagi a den diyà kenyo te pengkey deitek pa se pegsalig niyo diyà kanak iling te kedeitek te benì te mostasa, mekebatog kaw mikagi diyà te dakel kayo te pispisen din se lawa din aw malin doton te dagat, aw tomolò iyan kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Simpana doen sineligan egdaro aw egtonggò te karniro te amo din. Aw mepenga se pegterbaho din doton te pawà, aw domoton te balay, eked kepakay aw sikandin se monà ipekaen te eked pa kaen se amo din. ");
INSERT INTO mbs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Meneng onà megpunù se amo te keilangan meg-inang se sineligan te kànen aw meglamak kenyan. Penga te pegkaen te amo, yan mepakay aw komaen se sineligan. ");
INSERT INTO mbs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mepakay heman aw eked pesiontongi te amo se sineligan timolò te punù din, so yan se terbaho din. ");
INSERT INTO mbs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iling kaw heman te sineligan sìyan, so penga te pegtolò niyo te kedita te punù te Timanem diyà kenyo, eked kaw pesiontongi, meneng keilangan mikagi kaw diyà kandin, ‘Eked kay nikaw duyuni, so olò day ininang se keilangan toloen day.’” ");
INSERT INTO mbs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pegpesalo i Jesus doton te Jerusalem, minokit sikandin diyà te pigkitaan te probinsya te Samarya aw Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pegdateng din doton te sebad baryo, nesongonan sikandin te sempolò otaw tompigun. Pengkey mediyò dan pa, ");
INSERT INTO mbs_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","meneng timawal dan, “Jesus, Pengolo, keidowi kay bag.” ");
INSERT INTO mbs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pegkità din kandan, minikagi sikandin, “Doton kaw te menge pengolo te simbahan aw pegpekità kaw diyà kandan te lawa niyo.” Pegdoton dan, negolian se kedita dan te wedà dan pa dateng. ");
INSERT INTO mbs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Doen sebad otaw kidoen kandan, pegkità din te negolian den, dimuyun sikandin te Timanem te dakel se kagi din, aw limikò sebad din diyà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Limongken diyà ki Jesus, aw migpesiontong heman sikandin. Tege Samarya se otaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Penga niyan, minikagi si Jesus, “Pengkey sempolò se kedita dan pinegolian ko, meneng sidebok se otaw limikò amon domuyun te Timanem, aw kenà sikandin Judiyo. Nepela a, so wedà heman likò se siyam Judiyo doma din.” ");
INSERT INTO mbs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Minikagi heman si Jesus diyà te otaw sìyan negolian den, “Tindeg ka den, aw mepakay ka den mesayo. Negolian ka so simalig ka diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Doen menge Parisiyo mig-insà ki Jesus aw kano pegtebò se Timanem lomowan. Timaba sikandin, “Aw megtebò se Timanem lomowan, wedad pengilala ipekità din diyà kenyo. ");
INSERT INTO mbs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wedad otaw mekeikagi, ‘Dini den se peglowan din.’ Wedad heman otaw mekeikagi, ‘Kidoen se peglowan din.’ Eneng-enengi niyo ini. Eglowan den se Timanem dini kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Penga niyan, minikagi si Jesus diyà te menge tinoledaan din, “Doen aldaw domateng aw meibeg kaw peden te megtebò a lomowan Timanem Migpekeotaw, meneng keilangan megtagad kaw pa kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Doen kwani otaw mikagi, ‘Kidoen se Misiyas.’ Doen heman doma otaw mikagi, ‘Dini den sikandin.’ Meneng peg-ogpà kaw. Ikà niyo egtaking kandan, ");
INSERT INTO mbs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","so ontò metaen se peglikò ko iling te kilem ontò somiblat doton te kebelad te langit aw kitaen te kedita te otaw. Iling heman kenyan se pegdateng ko Timanem Migpekeotaw. ");
INSERT INTO mbs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Meneng eked a likò singed aw ontò a elegen, aw onà a kuluwan te menge otaw te aldaw seini. ");
INSERT INTO mbs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aw lomikò a Timanem Migpekeotaw, medita se otaw eked peketagad te pegdateng ko, iling te otaw gebii wedà penenalan ki Noe. ");
INSERT INTO mbs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Gayed dan egpengaen, aw eg-inem dan, aw egpepengognanay dan, lamig te aldaw te pegsakay i Noe aw pamilya din diyà te arka. Meneng negelà se menge doma otaw so nesàban dan te pegkelinep te tanà te wayeg, aw nelemes se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wedà heman peketagad se otaw gebii dalem te peg-ogpà i Lot doton te Sodoma. Gayed dan heman egpengaen, aw eg-inem dan, aw egbayad dan, aw egpemeligyà dan, aw egpenanem dan, aw eg-inang dan te balay. ");
INSERT INTO mbs_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Meneng aldaw te pegkesayo i Lot lekat te Sodoma, negelà se kedita te doma tege Sodoma, so nematay dan te apoy aw esopri nedagdag lekat te langit. ");
INSERT INTO mbs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kesàban heman iling kenyan se otaw kenà egpeketagad te aldaw aw ipekità a Timanem Migpekeotaw. ");
INSERT INTO mbs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Aw domateng se aldaw sìyan, eked awop diyà te balay din se otaw doton te lowà amon ebaten din se kedònan, meneng keilangan tenanan din se kedita. Eked heman olì se otaw egterbaho doton te pawà, meneng keilangan komadas. ");
INSERT INTO mbs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Eneng-enengi niyo te nebaloy asin se esawa i Lot te peglingì din diyà te lonsod tinenanan dan. ");
INSERT INTO mbs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pengkey ibeg te otaw megkelayat se omol din, meneng kunù din gayed matay. Meneng aw mepakay diyà te otaw pengkey imetayan sikandin, begayan sikandin te kaling pedowan wedad temanan. ");
INSERT INTO mbs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Penenalan kaw te kagi ko. Aw domateng se aldaw sìyan, pengkey tomedogi se dowa otaw kidoen te sebad ikam, meneng ipetaking se sebad, aw tenanan se sebad. ");
INSERT INTO mbs_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pengkey meglegiling se dowa bayi, meneng ipetaking se sebad, aw tenanan se sebad.  ");
INSERT INTO mbs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pengkey megterbaho se dowa meama doton te pawà, meneng ipetaking se sebad, aw tenanan se sebad.” ");
INSERT INTO mbs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mig-insà se menge tinoledaan din, kagi dan, “Pengolo, kenan lay iyan keinang?” Minikagi si Jesus, “Pengkey kenan se lawa te nematay, yan se ketiponan te menge manok egpengaen te lawa te nematay.” ");
INSERT INTO mbs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mig-indan si Jesus te tegdeyanan amon ketoledaan dan te keilangan gayed dan megtawal-tawal amon eked dan lengà. ");
INSERT INTO mbs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Minikagi sikandin, “Kidoen te sebad lonsod, doen howis kenà egpenimanem aw kenà heman egkeido te doma otaw. ");
INSERT INTO mbs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Doen heman bayi balo eg-ogpà kidoen gayed egdoton te howis aw egpemoyò, kagi din, ‘Tebangi a amon dàgen ko se otaw egpemilang kanak.’ ");
INSERT INTO mbs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Meneng wedà pegtabang se howis kandin. Nayan, pegkenamay, mig-aneng-aneng se howis, ‘Pengkey kenà a egpenimanem aw kenà a heman egkeido te doma otaw, ");
INSERT INTO mbs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","meneng keilangan tebangan ko se bayi balo seini, so gayed a din egbuyungen. Megkelomay a kwani aw gayed sikandin meglikò-likò.’” ");
INSERT INTO mbs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Minikagi heman se Pengolo, “Na, eneng-enengi niyo se inikagi te howis, so pengkey kenà egpenimanem, meneng tebangan din se otaw gayed egpemoyò. ");
INSERT INTO mbs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Labi pa metoman se Timanem egpenabang te otaw pinemallì din aw egpengenganay dan diyà kandin te kelikit te aldaw aw delem. Eked sikandin peg-alà-alà, ");
INSERT INTO mbs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","meneng metoman menabang kandan te eked kenamay. Yan, ikà niyo eglengà te pegtawal-tawal niyo diyà kandin. Metoman a lomikò Timanem Migpekeotaw, aw ibeg ko kitaen se medita otaw egsalig diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nayan, mig-indan si Jesus te tegdeyanan seini diyà te menge otaw eden dan aw metòlid se eg-inangen dan, aw gayed dan eglindò te doma. ");
INSERT INTO mbs_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Minikagi si Jesus, “Doen dowa otaw dimoton te dakel simbahan te Jerusalem amon megtawal-tawal dan. Parisiyo se sebad, aw iskribinti se sebad. ");
INSERT INTO mbs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Timindeg kidoen se Parisiyo aw migtawal-tawal, kagi din, ‘E Timanem, egpesiontong a diyà kamno, so labi a pa mèpiya diyà te menge doma otaw, so kenà a iling te otaw eg-akal, aw eglàpang te punù, aw eglakad. Egpesiontong a so kenà a medaet otaw iling te iskribinti sida. ");
INSERT INTO mbs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kelikit te simana, mekedowa a egpowasa. Gayed ko ipegbowang se ikesempolò ketengà te kwarta eg-ebaten ko.’ ");
INSERT INTO mbs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Meneng pegtawal-tawal te iskribinti, migpekediyò sikandin diyà te menge doma otaw so neyàyà. Wedà heman lengag doton te langit, meneng timikelong sikandin aw dinapì din se kagpa din tandà te pegselsel din, aw minikagi, ‘Timanem, keidowi a bag, so nelegeb a te salà.’ ");
INSERT INTO mbs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na, penenalan kaw te kagi ko. Peg-olì te iskribinti sìyan, pigwedad den te Timanem se salà din. Meneng se Parisiyo, wedà pegwedadi te Timanem se salà din. Inangen te Timanem medanà se kedita te otaw egpelangkaw-langkaw, meneng inangen din melangkaw se kedita te otaw egpedanà te kandan pegkeotawun.” ");
INSERT INTO mbs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nayan, doen menge otaw nengibing te dedeitek mengisù doton ki Jesus amon pemàdan din dan, aw megtawal-tawal te begayan dan te Timanem te mèpiya. Meneng pegkità te menge tinoledaan din kenyan, migsagda dan kandan. ");
INSERT INTO mbs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Meneng tinawal i Jesus se kedita dan diyà kandin, aw minikagi sikandin, “Ikà niyo egsagda kandan, so lomowan se Timanem diyà te otaw ontò somalig diyà kandin iling te pegsalig te mengisù diyà te amay aw inay dan. ");
INSERT INTO mbs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eneng-enengi niyo se kagi ko seini. Aw eked salig se otaw diyà te Timanem iling te pegsalig te mengisù diyà te amay dan, eked sikandin sekopi te Timanem diyà te peglowan din.” ");
INSERT INTO mbs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Doen sebad obanen te Judiyo mig-insà diyà ki Jesus, kagi din, “Sir, ontò ka mèpiya otaw. Eden lay se keilangan inangen ko amon mekinawà ko se kaling pedowan wedad temanan?” ");
INSERT INTO mbs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Minikagi si Jesus, “Nepela a so minikagi ka te mèpiya a otaw. Meneng wedad otaw ontò mèpiya, so olò Timanem se ontò mèpiya. ");
INSERT INTO mbs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Netegahan no besi se menge punù ingkeliwat i Moises. Ikà eglakad. Ikà egbonò. Ikà egpenakaw. Ikà egkebolalaw tepad te doma otaw. Keilangan memasa ka te amay aw inay nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Timaba se obanen, “Gayed ko egtoloen se kedita niyan lekat te pegkebatà ko lamig seini.” ");
INSERT INTO mbs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pegdineg i Jesus kenyan, minikagi sikandin, “Sebad mendad se keilangan inangen nikaw. Beligyai se kedakel te kedònan no, aw iteped se kwarta no diyà te menge otaw nelimahan. Aw yan se inangen no, doen ontong kinewaen no doton te langit. Penga te pegteped no te kedakel niyan, likò ka dini aw taking ka kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Meneng pegdineg te obanen kenyan, nepuluk se pedowan din, so ontò sikandin meyaman. ");
INSERT INTO mbs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pegkità i Jesus te nepuluk se obanen, minikagi sikandin, “Ontò melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pengkey ontò melima se peg-okit te ayam-ayam kamilo diyà te awang te dagem, meneng labi pa melima se pegpesakop te otaw meyaman diyà te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Minikagi se menge doma otaw dimineg kenyan, “Aw iling kenyan, wedad palos otaw mekelowà lekat te pelumun te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Timaba si Jesus, “Betogen te Timanem se eked kebatog te otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Minikagi si Pedro, “Meneng sikami, tinenanan day den se kedakel te kedònan day amon tomaking kay kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Minikagi si Jesus, “Eneng-enengi niyo se kagi ko seini. Se otaw timanan den te kedònan din, aw esawa din, aw kedowa din, aw amay din, aw inay din, aw batà din, amon megtoladà te doma otaw tepad te peglowan te Timanem, ");
INSERT INTO mbs_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yan se metoman kominawà te ontong labi pa dakel diyà te tinenanan din dalem te eked pa kematay, aw penga niyan, begayan heman sikandin te kaling pedowan wedad temanan te modi aldaw.” ");
INSERT INTO mbs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nayan, migtipon si Jesus te sìyan sempolò teg dowa tinoledaan din, aw minikagi sikandin, “Na, domoton kidon den te Jerusalem amon metoman se kedita te pakang insolat te menge telekeliwat te kagi te Timanem tepad kanak Timanem Migpekeotaw. ");
INSERT INTO mbs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Metoman a ibegay diyà te belad te menge otaw kenà Judiyo. Kebebeyatan a, aw pemilangen a, aw teptepan a. ");
INSERT INTO mbs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bedasen a dan, aw penga niyan imetayan a dan. Meneng meantay a lekat te nematay te iketelo te aldaw.” ");
INSERT INTO mbs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Meneng wedà pekelabet se tinoledaan din te sìyan inikagi i Jesus. Wedà petega-tegahi se kedegdagan niyan diyà kandan, aw yan se doun te wedà dan pekelabet. ");
INSERT INTO mbs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pegkedapag i Jesus doton te lonsod te Jeriko, doen otaw bota nenenoo kidoen te kilid te dalan aw egpemoyò. ");
INSERT INTO mbs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pegdineg din te medita otaw limaklak, mig-insà sikandin aw eden se neinang. ");
INSERT INTO mbs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Minikagi se menge doma, “Minokit dini si Jesus tege Nasarit.” ");
INSERT INTO mbs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Penga niyan, timawal sikandin, “Jesus, bowad-bowad i David, keidowi a bag.” ");
INSERT INTO mbs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Migsagda kandin se menge otaw nekeonà ki Jesus, aw migpunù dan te keilangan mepenek sikandin. Meneng labi beling sikandin timawal, “Bowad-bowad i David, keidowi a bag.” ");
INSERT INTO mbs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pegdineg i Jesus te pegtawal din, simagked sikandin aw impeangay din se otaw bota. Pegdateng din doton, mig-insà si Jesus, ");
INSERT INTO mbs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Eden lay se ibeg no inangen ko kamno?” Timaba se bota, “Pengolo, ibeg ko, todà a komità.” ");
INSERT INTO mbs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Minikagi si Jesus, “Kimità ka den. Negolian ka den so simalig ka diyà kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pegketà, kimità sikandin, aw timaking ki Jesus. Gayed din pinesiontongan se Timanem. Dimuyun heman te Timanem se kedita te otaw kimità te pegpegolì kandin. ");
INSERT INTO mbs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nayan, minokit si Jesus kidoen te lonsod te Jeriko. ");
INSERT INTO mbs_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Doen tege Jeriko ngadan din si Sakeo. Sikandin se pengolo te kedita te iskribinti aw ontò meyaman. ");
INSERT INTO mbs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ibeg din tomengteng ki Jesus, meneng wedà din kebatog, so medita se otaw netipon, aw ontò sikandin mebabà otaw. ");
INSERT INTO mbs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Na, kimagnan sikandin doton te monà kidoen te dalan okitan i Jesus, aw nenayit diyà te dakel kayo amon komità ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pegdateng i Jesus doton te kayo pinenitan i Sakeo, limengag sikandin aw minikagi, “Sakeo, ayas ka tenà, so keilangan meg-ogpà a kidoen te balay no te aldaw seini.” ");
INSERT INTO mbs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ayas timenà si Sakeo, aw inibing din si Jesus doton te balay din, aw migsagman kandin, aw neluba se pedowan din. ");
INSERT INTO mbs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Meneng simila se kedita te otaw kimità kenyan, kagi dan, “Medaet iyan, so midegà sikandin kidoen te balay te otaw nelegeb te salà.” ");
INSERT INTO mbs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Migpedapag si Sakeo diyà ki Jesus aw minikagi, “Pengolo, seini se inangen ko. Ibegay ko se ketengà te kedònan ko diyà te menge otaw nelimahan. Aw migleges a te otaw memegay kanak te kwarta, yan se lintapan ko te mekeepat.” ");
INSERT INTO mbs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Minikagi si Jesus, “Aldaw seini, mekelowà ka den lekat te salà, so nemenal ka den kanak iling te pegpemenal i Abraham gebii. ");
INSERT INTO mbs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dimini a te tanà Timanem Migpekeotaw amon tewalen ko se otaw nelegeb te salà, aw ipelowà ko dan.” ");
INSERT INTO mbs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gayed egpenenalan se kedita te otaw diyà ki Jesus, aw mig-indan sikandin te tegdeyanan, so medapag den sikandin te Jerusalem, aw eden dan aw agpet den megtebò se Timanem lomowan diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yan se doun te minikagi sikandin, “Doen melangkaw otaw dimoton te mediyò ogpeanan amon inangen sikandin selotan te lonsod din, aw penga niyan molì amon lomowan. ");
INSERT INTO mbs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te wedà pa kesayo, tinawal din se sempolò sineligan din, aw imbegay din diyà kandan se kwarta, sebad gatos diyà te teg sebad-sebad kandan. Minikagi sikandin, ‘Seini se kwarta gemiten niyo te pegnigosyo dalem te iyogan ko.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nayan, se doma otaw eg-ogpà kidoen te lonsod sìyan, wedà dan keibeg aw meinang sikandin selotan lomowan diyà kandan. Penga te pegkesayo din, doen otaw insogò dan mikagi diyà te gobirno te eked dan keibeg aw otaw sìyan se lomowan diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Meneng gayed sikandin neinang selotan. Peg-olì din, impeangay din se sempolò sineligan din, sìyan binegayan din te kwarta, so ibeg din ketegahan aw pila se kedakel te gamad dan. ");
INSERT INTO mbs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dimateng se tagnà aw minikagi, ‘Sir, se sebad gatos imbegay no diyà kanak, neinang iyan sebad melalan.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Minikagi se selotan, ‘Mèpiya se ininang nikaw. Pengkey deitek se imbegay ko diyà kamno, meneng keseligan ka, aw yan se doun te inangen ta den gobirnador lomowan diyà te sempolò lonsod.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dimateng se ikedowa sineligan aw minikagi, ‘Sir, se sebad gatos imbegay no diyà kanak, neinang iyan lima gatos.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Minikagi se selotan, ‘Inangen ta den gobirnador lomowan diyà te lima lonsod.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Penga niyan, doen sineligan dimateng aw minikagi, ‘Sir, iolì ko den diyà kamno se sebad gatos imbegay no diyà kanak, so intagò ko iyan diyà te kelobaw aw in-eles ko. ");
INSERT INTO mbs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wedà ko iyan gemiti, so nelemitan a kamno, so mebolot ka otaw. Eg-ebaten no se wedà no kepegodi, aw eglegeniyen no se intanem te doma otaw.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Minikagi se selotan, ‘Ontò medaet se ininang nikaw. Pineokit te inikagi no sìyan, impetaga-taga no den te keilangan ipelumun ta. Minikagi ka te ontò a mebolot, so eg-ebaten ko se wedà ko kepegodi, aw eglegeniyen ko se intanem te doma otaw. Aw netegahan no iyan, ");
INSERT INTO mbs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","keilangan ipebeles no peden se kwarta ko diyà te doma otaw amon iolì iyan diyà kanak te peg-olì ko sipat batà niyan.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Penga niyan, minikagi se selotan diyà te menge doma otaw kidoen, ‘Ebati niyo se sebad gatos imbegay ko diyà kandin, aw begayi niyo iyan diyà te otaw doen sebad melalan.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Meneng minikagi dan, ‘Pengolo, eked iyan kepakay, so tapay den doen sebad melalan diyà kandin.’ ");
INSERT INTO mbs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Timaba se selotan, ‘Penenalan kaw te kagi ko. Se otaw egkeseligan, yan se begayan ko te labi pa dakel. Meneng se otaw kenà egkeseligan, yan se ebatan ko te imbegay ko diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Meneng labi pa medaet se pelumun ko diyà te menge poon ko, sìyan wedà keibeg te peglowan ko diyà kandan. Ibingi niyo dan dini kanak, aw imetayi niyo se kedita dan.’” ");
INSERT INTO mbs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Penga te peg-ikagi i Jesus kenyan, nekeonà sikandin te doma otaw pesalo doton te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pegkedapag din kidoen te lonsod te Bitpahi aw Bitanya doton te ongan te bontod te Olibo, insogò din se dowa tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kagi din, “Onà kaw doton te lonsod sida peselowan tadon. Aw domateng kaw, ketelaan niyo se nati te kodà. Iniketan iyan, meneng wedà iyan lumun kesekayi te otaw. Lebadi niyo, aw ibingi niyo dini. ");
INSERT INTO mbs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aw doen otaw meg-insà kenyo te nengà lay linebad niyo iyan, ikegihi niyo te keilangan sekayan iyan te Pengolo niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nesayo se didowa dan insogò din, aw netelaan dan iyan iling te inikagi din diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Peglebad dan te lobid in-iket te nati, mig-insà se tig-apò, “Nengà lay linebad niyo iyan?” ");
INSERT INTO mbs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Timaba dan, “Keilangan sekayan iyan te Pengolo day.” ");
INSERT INTO mbs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Penga niyan, inibing dan se nati doton ki Jesus. Menge saol dan se in-ampal dan diyà te getan te nati, aw impesakay dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pegsakay din, inladlad te menge doma otaw se saol dan doton te dalan peselowan din, so yan se ketanem dan aw segmanen dan se otaw meinang selotan. ");
INSERT INTO mbs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pegkedapag i Jesus te lonsod te Jerusalem, te wedà pa topang te bontod te Olibo, migtebò se kedita te otaw timaking kandin dimuyun te Timanem te dakel se kagi dan. Ontò dan neluba aw migpesiontong dan diyà te Timanem so medita se kepelahan ininang i Jesus tapay dan kinità. ");
INSERT INTO mbs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Migpegais dan, “Iduyun se Selotan seini insogò te Pengolo tadon Timanem. Begayan kidon din te kelinaw te pedowan lekat te langit. Iduyun den se Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Doen heman menge Parisiyo timaking ki Jesus, aw minikagi dan diyà kandin, “Sir, segdahi se peg-ikagi dan kenyan.” ");
INSERT INTO mbs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Meneng minikagi si Jesus, “Penenalan kaw kanak. Simpana mepenek se menge otaw seini, metoman somelilin kandan se menge bato megpegais aw domuyun kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pegkedapag i Jesus te lonsod te Jerusalem, kinità din iyan aw migkelag tandà te keido din te otaw eg-ogpà kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Minikagi sikandin, “Mekelelayò kaw tege Jerusalem. Ibeg ko peden mekeabat kaw den te kelinaw te pedowan. Meneng wedà niyo kitai se keokit niyan. ");
INSERT INTO mbs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Metoman kaw pa kelimahan, so lomibed se menge sondalo te poon niyo kidoen te lonsod niyo, aw ontò dan megbangan kenyo amon eked kaw palos pekelowà. ");
INSERT INTO mbs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Imetayan kaw dan, aw ontò dan heman pegbàtan se kedakel te lonsod niyo aw gobalen dan heman se kedita te balay niyo. Yan se metoman domateng diyà kenyo so wedà niyo ketegahi te seini se aldaw te pegpelowà te Timanem kenyo.” ");
INSERT INTO mbs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pegdateng i Jesus doton te Jerusalem, dimoton sikandin te dakel simbahan, aw impekadas din se kedita te otaw egpemeligyà te ayam-ayam kidoen te dowangen niyan. ");
INSERT INTO mbs_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Minikagi sikandin, “Doen kagi te Timanem impesolat din gebii, ‘Se balay te Timanem, yan se ingedanan balay te pegtawal-tawal.’ Meneng ininang niyo den ini iling te ogpeanan te megdedempasay.” ");
INSERT INTO mbs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Migtoladà si Jesus kidoen te dakel simbahan te Jerusalem te kelikit te aldaw. Meneng se kedita te pengolo te simbahan, aw menenoladà te punù ingkeliwat i Moises, aw menge dakel otaw, miglalang dan te imetayan dan si Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Meneng wedà dan peketoman, so ontò egpenenalan se kedita te otaw diyà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pegtoladà i Jesus te menge otaw netipon kidoen te dakel simbahan, migtoladà sikandin tepad te Mèpiya Indan. Dalem te pegtoladà din, dimateng se menge pengolo te simbahan aw menenoladà te punù aw menge obanen te Judiyo. ");
INSERT INTO mbs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Minikagi dan, “Indani kay te nengà lay eg-inang ka te kedita nini. Sinu lay se simogò kamno?” ");
INSERT INTO mbs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Timaba si Jesus, “Doen heman insà ko kenyo. Na, indani a niyo. ");
INSERT INTO mbs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sinu lay se simogò ki Juan amon memonyag? Timanem, aw otaw se simogò kandin?” ");
INSERT INTO mbs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Penga niyan, migpebelaw-belaway dan aw eden se itaba dan kandin. Minikagi dan, “Simpana tomaba kidon te Timanem se simogò ki Juan, silahen kidon din, so wedà kidon pemenal ki Juan. ");
INSERT INTO mbs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Meneng simpana tomaba kidon te olò otaw se simogò ki Juan, bontogan kidon te kedita te otaw te bato lamig matay kidon, so nenamay dan mig-aneng-aneng te ontò telekeliwat te kagi te Timanem si Juan.” ");
INSERT INTO mbs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yan se doun te timaba dan ki Jesus te wedà dan ketegahi aw sinu se simogò ki Juan. ");
INSERT INTO mbs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Minikagi si Jesus, “So wedà kaw taba te insà ko, eked a peg-indan diyà kenyo aw sinu se simogò kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nayan, mig-indan si Jesus te tegdeyanan seini diyà te medita otaw netipon kidoen, kagi din, “Doen otaw migpawà aw nenanem te paras. Penga niyan, impetonggò din iyan te menge doma otaw, aw dimoton sikandin te mediyò ogpeanan amon meg-ogpà te ontò menamay. ");
INSERT INTO mbs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pegdateng te aldaw te peglegani, doen sineligan insogò te tig-apò amon doen talad te paras ebaten din lekat te otaw impetonggò din. Meneng pegdateng te sineligan doton kandan, binadas dan sikandin aw impekesayo dan te wedad palos imbegay kandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Penga niyan, doen doma sineligan insogò te tig-apò. Meneng binadas dan heman sikandin, aw ontò dan pigyàyà, aw impekesayo dan te wedad palos imbegay kandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Penga niyan, doen iketelo sineligan insogò te tig-apò. Meneng ontò dan sikandin impeeleg, aw ginoyod dan doton te lowà te pawà. ");
INSERT INTO mbs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Penga niyan, mig-aneng-aneng se tig-apò, ‘Megmeno a? Mèpiya aw isogò ko se batà ko egkedekelan ko te pedowan, so keilangan segmanen dan sikandin.’ ");
INSERT INTO mbs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Meneng pegdateng te batà din doton kandan, migpebelaw-belaway dan, ‘Seini se meketig-apò te tanà seini aw matay se amay din. Mèpiya aw imetayan tadon sikandin amon sikitadon se meketig-apò te tanà seini.’ ");
INSERT INTO mbs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Penga niyan, ginoyod dan sikandin doton te lowà te pawà aw inimetayan dan sikandin. “Nayan, meg-indan a den diyà kenyo aw eden se inangen te tig-apò diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Domoton sikandin aw imetayan din se kedita dan. Penga niyan, ipetonggò din se pawà din te doma otaw.” Nayan, pegdineg te menge otaw te tegdeyanan sìyan, minikagi dan, “Eked iyan peden ketoman.” ");
INSERT INTO mbs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Meneng timengteng si Jesus diyà kandan aw minikagi, “Meneng keilangan iyan metoman, so doen kagi te Timanem insolat, ‘Doen bato in-agbel te menge otaw mig-inang te balay, so eden dan aw wedad kekemowan niyan. Meneng yan se bato ontò salig te balay.’ ");
INSERT INTO mbs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aw mekedogsò se otaw kidoen te bato sìyan, melosek se menge tòlan din. Meneng aw kedegdagan se otaw te bato sìyan, mepolpog sikandin.” ");
INSERT INTO mbs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na, se menge menenoladà te punù aw pengolo te simbahan, netegahan dan te sikandan se nesogatan te tegdeyanan sìyan in-indan i Jesus, aw yan se doun te ibeg dan megdakep peden kandin te aldaw sìyan. Meneng wedà dan peketoman, so nelemitan dan te menge otaw gayed egpenenalan kandin aw domapit dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yan olò dan migtagad te mèpiya aldaw. Doen heman menge otaw insogò dan migpelingo-lingo te tomaking kandin, meneng olò dan nengemahà aw doen kemalì te ikegiyen din amon doen idimanda dan tepad kandin aw ipedakep te gobirnador. ");
INSERT INTO mbs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Minikagi dan diyà kandin, “Sir, netegahan day te ontò benal se eg-ikegiyen no aw ipegtoladà nikaw. Pengkey sinu se otaw toledaan no, gayed ka egtoladà te kebenalan tepad te ibeg te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nayan, indani kay den. Lomàpang kidon lay te menge punù ingkeliwat i Moises aw mayad kidon te mihoras diyà te gobirno te Roma? Mepakay lay aw eked?” ");
INSERT INTO mbs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Meneng netegahan i Jesus te medaet se tod dan te peg-insà dan kenyan. Yan minikagi sikandin, ");
INSERT INTO mbs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pekitai niyo kanak se kwarta ipegbayad niyo te mihoras. Sinu lay bawa se insawol kidoen? Sinu lay ngadan se insolat kidoen?” Timaba dan, “Selotan te Roma.” ");
INSERT INTO mbs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Minikagi si Jesus, “Yan begayi niyo diyà te selotan se keilangan ibegay niyo diyà kandin, aw begayi niyo heman diyà te Timanem se keilangan ibegay niyo diyà kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pengkey ibeg dan doen kemalì te kagi din diyà te otaw netipon kidoen, meneng wedad palos kemalì kinità dan. Nepela dan tandà te pegtaba din kenyan, aw nepenek dan. ");
INSERT INTO mbs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Doen heman menge Sadusiyo dimoton ki Jesus. Yan se menge otaw egtoladà te eked palos keantay se otaw lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mig-insà dan diyà ki Jesus, kagi dan, “Sir, doen impunù i Moises kenitadon tepad te inangen te telekedowa meama. Aw matay se meama te wedad pa batà te esawa din, keilangan mengognan se kedowa te nematay diyà te nayi din nebalo, amon doen peden batà te kedowa din nematay. ");
INSERT INTO mbs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nayan, doen ekon pito telekedowa meama. Nengognan se kakay dan, aw nematay sikandin te wedad pa batà dan. ");
INSERT INTO mbs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Penga niyan, nengognan se ikedowa meama te nayi din nebalo, meneng nematay heman sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Penga niyan, nengognan heman kandin se iketelo meama. Migpetibos-tibosay se pito telekedowa nengognan te bayi sìyan, meneng nematay se kedita dan te wedad pa palos batà dan. ");
INSERT INTO mbs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Penga niyan, nematay heman se bayi. ");
INSERT INTO mbs_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nayan, indani kay. Aw meantay se otaw lekat te nematay, sinu lay lebò diyà kandan se ontò esawa te bayi sìyan? So migpetibos-tibosay dan se pito nengognan kandin.” ");
INSERT INTO mbs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Minikagi si Jesus, “Gayed pa egpengognan se otaw dini te keneyonan. ");
INSERT INTO mbs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Meneng kidoen te langit, eked den pengognan se otaw pinemallì te Timanem aw entayen din dan lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eked dan todà kematay, so iling dan te menge anghil. Meinang dan menge batà te Timanem, so entayen din dan lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Metoman dan meantay lekat te nematay, so impetaga-taga iyan heman i Moises. Pegsolat din tepad te pegpekità te Timanem diyà kandin kidoen te sagbet limegdeg, tinawal din se Pengolo ‘Timanem gayed egseligan i Abraham, aw si Isaac, aw si Jacob.’ ");
INSERT INTO mbs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kenà otaw wedad pedowan se egsalig te Timanem, meneng otaw doen pedowan se egsalig kandin. Yan se doun te keilangan ketegahan tadon te doen keentayan te lawa te otaw nematay, so binegayan dan te Timanem te kaling pedowan wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Doen kidoen menge menenoladà te punù, aw minikagi dan, “Sir, ontò mèpiya se intaba no kandan.” ");
INSERT INTO mbs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Penga niyan, wedad palos otaw migtelaman mig-insà kandin. ");
INSERT INTO mbs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Minikagi si Jesus, “Pengkey benal se ipegtoladà dan te bowad-bowad i David se Misiyas isogò te Timanem dini kenyo, ");
INSERT INTO mbs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","meneng minikagi si David te Pengolo din se Misiyas, so simolat si David kidoen te libro te Delangan, ‘Minikagi se Timanem diyà te Pengolo ko, Penenoo ka dini te tangkil ko ");
INSERT INTO mbs_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","lamig dàgen ko se menge poon no aw ipetolò ko dan kamno.’ ");
INSERT INTO mbs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, aw minikagi si David te Pengolo din se Misiyas, kenà olò bowad-bowad din se Misiyas, meneng Pengolo din heman.” ");
INSERT INTO mbs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dalem te pegpenenalan te medita otaw ki Jesus, minikagi sikandin diyà te menge tinoledaan din, ");
INSERT INTO mbs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Peg-ahà kaw te menge menenoladà te punù ingkeliwat i Moises. Gayed dan egpenaol te melayat, aw ibeg dan segmanen dan te doma otaw doton te pedyanan. Ibeg dan heman menenoo doton te mèpiya onsedanan kidoen te simbahan te Judiyo. Ibeg dan heman, aw doen dakel kànen, sikandan se monà ipekaen. ");
INSERT INTO mbs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Meneng sikandan se eg-agaw te kedònan te bayi balo, aw penga niyan menamay se pegtawal-tawal dan amon megpelingo-lingo dan te melobos se pedowan dan diyà te Timanem. Meneng metoman dan ontò ipelumun labi pa diyà te doma otaw.” ");
INSERT INTO mbs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pegtoladà i Jesus kidoen te dakel simbahan te Jerusalem, kinità din se menge otaw meyaman egsawol te kwarta diyà te solanan te ibowang diyà te Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Penga niyan, kinità din heman se sagkep bayi balo migsawol te dowa kedakò kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Minikagi si Jesus, “Eneng-enengi niyo se kagi ko seini. Pengkey dakel se imbowang te kedita te doma otaw, meneng labi pa meelagà se imbowang te bayi balo sida. ");
INSERT INTO mbs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dakel se kwarta te doma aw eked dan kelimahi tandà te pegpemegay dan. Meneng se bayi sida sagkep, tinigkan din imbowang se kedakel te kedònan din, pengkey nelimahan sikandin.” ");
INSERT INTO mbs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Doen otaw kidoen migpebelaw-belaway tepad te dakel simbahan sìyan, so ininang iyan te bato mèpiya se bawa, aw dakel heman se kwarta imbowang amon pelasan iyan. Minikagi si Jesus, ");
INSERT INTO mbs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Doen aldaw domateng te pegbàtan se dakel simbahan induyun niyo seini. Tigkan iyan kebàtan, aw wedad palos bato ketenanan diyà te lanto te doma bato.” ");
INSERT INTO mbs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Doen otaw mig-insà, “Sir, kano lay ketoman se in-indan nikaw? Eden lay se pengilala kitaen day aw agpet iyan metoman?” ");
INSERT INTO mbs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Minikagi si Jesus, “Peg-ahà kaw amon eked kaw keekali, so doen kwani medita otaw megpelingo-lingo te insogò ko dan. Mikagi dan te sikandan se Misiyas. Mikagi heman se doma te agpet den domateng se aldaw pinelimanan niyo. Meneng ikà niyo egtaking kandan. ");
INSERT INTO mbs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aw domineg kaw te doen gira aw menge samok, ikà niyo egkelemitan. Keilangan onà iyan meinang, meneng kenà pa niyan se temanan te keneyonan.” ");
INSERT INTO mbs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Minikagi heman sikandin, “Medita se otaw meggira, so doen pongan megbolaw diyà te doma pongan, aw doen heman menge sakop te sebad selotan megbolaw diyà te menge sakop te doma selotan. ");
INSERT INTO mbs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Doen heman linog ontò medaet, aw megelà se otaw te medita ogpeanan tandà te bayil aw mesakit domateng diyà kandan. Ipekità heman te Timanem se kepelahan mekelelamit kidoen te langit. ");
INSERT INTO mbs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Meneng te eked pa iyan ketoman, dekepen kaw, aw pemilangen kaw. Okomen kaw doton te menge simbahan te Judiyo, aw kelebosowen kaw heman. Ipeibing kaw doton te menge selotan aw gobirnador tandà te pegpesakop niyo diyà kanak, ");
INSERT INTO mbs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","amon meg-indan kaw te kebenalan tepad kanak. ");
INSERT INTO mbs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ikà niyo egketetana aw megpeketagad kaw tomaba kandan, ");
INSERT INTO mbs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","so dalem te aldaw sìyan, ibegay ko kenyo se kebiyasa amon meketaba kaw kandan. Yan se doun te wedad poon niyo mekedaeg te kenyo kagi. ");
INSERT INTO mbs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pengkey amay niyo, aw inay niyo, aw kedowa niyo, pengkey doma gaked niyo aw sigalak niyo, doen heman diyà kandan megtolok kenyo. Doen heman kenyo ipeimatay dan. ");
INSERT INTO mbs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kebensihan kaw te keditaan te otaw tandà te pegpesakop niyo diyà kanak. ");
INSERT INTO mbs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Meneng wedad megkedaet kenyo pengkey sebad. ");
INSERT INTO mbs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pineokit te pegtayod niyo te kedita te kelimahan, metoman kaw kominawà te kaling pedowan wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aw komità kaw te nelibedan te medita sondalo se lonsod te Jerusalem, yan ketegahan niyo te pegbàtan iyan te eked kenamay. ");
INSERT INTO mbs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Keilangan komadas se kedita te otaw lekat te Judiya pesalo doton te bontod. Keilangan komadas se kedita te otaw lekat te Jerusalem. Keilangan eked doton te Jerusalem se otaw doton te lowà. ");
INSERT INTO mbs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Metoman ipelumun te Timanem se otaw medaet, aw tomanen din se kedita te pakang din insolat. ");
INSERT INTO mbs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mekelelayò se menge bayi mebedes aw egsosowan te aldaw sìyan. Ontò medaet se kelimahan domateng dini te keneyonan, aw ontò ipelumun te Timanem se menge sakop te Judiya. ");
INSERT INTO mbs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Medita se otaw megelà tigbasen. Medita heman se doma dekepen aw ibingen doton te kedita te doma lonsod mediyò. Ontò pegbàtan te menge otaw kenà Judiyo se lonsod te Jerusalem lamig mepenga se peglowan dan.” ");
INSERT INTO mbs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Doen pengilala ipekità te Timanem kidoen te aldaw aw bolan aw menge bitoen. Dini heman te tanà, metetana aw melemitan se kedita te otaw, so ontò megbalud aw domaging se dagat. ");
INSERT INTO mbs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Megketetapì se medita otaw tandà te lamit dan, so eked dan ketaga-taga aw eden se domateng dini te keneyonan. Pengkey menge bitoen kidoen te langit, mebilit se kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Penga niyan, kitaen te kedita te otaw se pegdateng ko, so lomikò a Timanem Migpekeotaw tekingan te labon. Komità dan te metolos a aw ontò a melangkaw. ");
INSERT INTO mbs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, aw kitaen niyo se pegketoman niyan, keilangan meluba kaw, so ipelowà kaw te Timanem te eked kenamay.” ");
INSERT INTO mbs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nayan, mig-indan si Jesus te tegdeyanan seini, kagi din, “Tengtengi niyo se kayo igira aw menge doma kayo heman. ");
INSERT INTO mbs_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aw kitaen niyo se kayo tomobed aw domawen, ketegahan niyo te agpet den domateng se aldaw te pegpemongo niyan. ");
INSERT INTO mbs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iling heman kenyan, aw kitaen niyo te metoman se inikagi ko diyà kenyo, yan ketegahan niyo te agpet den lomowan se Timanem. ");
INSERT INTO mbs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Eneng-enengi niyo se kagi ko seini. Doen menge otaw komità te pengilala sìyan eked kematay singed aw metoman se kedita niyan. ");
INSERT INTO mbs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Doen temanan te langit aw tanà, meneng gayed metoman se kagi ko te wedad temanan.” ");
INSERT INTO mbs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Peg-ahà kaw amon meketagad kaw te aldaw sìyan. Eked kaw peketagad aw egpengemahà kaw te keluba, aw eg-inem kaw, aw gayed kaw eg-aneng-aneng tepad te peg-ogpà niyo, so metoman domateng se aldaw sìyan pengkey eked kaw peketagad. ");
INSERT INTO mbs_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Metoman iyan domateng diyà te kedita te otaw dini lanto te tanà. ");
INSERT INTO mbs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yan se doun te keilangan gayed kaw meg-ahà, aw megtawal-tawal kaw te begayan kaw te Timanem te kagsen te pedowan amon meketayod kaw te kedita te kelimahan sìyan. Aw meketayod kaw, eked kaw keyàyà aw domateng a Timanem Migpekeotaw.” ");
INSERT INTO mbs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gayed egtoladà si Jesus kidoen te dakel simbahan te Jerusalem te kelikit te aldaw. Meneng te delem, gayed egdoton te bontod te Olibo aw minidegà kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gayed eglapos se medita otaw netipon kidoen te dakel simbahan amon menenalan dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nayan, agpet den se pista te menge Judiyo iningedanan dan Pista te Pegpelowà. Yan se pegpengaen dan te pan kenà eglebag. ");
INSERT INTO mbs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gayed mig-aneng-aneng se menge pengolo te simbahan aw menenoladà te punù aw eden se inangen dan amon imetayan dan si Jesus te eked dan keopali te kedita te otaw gayed egpenenalan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Penga niyan, dimateng si Satanas diyà ki Judas Iscariote. Sikandin se sebad diyà te sempolò teg dowa tinoledaan i Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dimoton si Judas te menge pengolo te simbahan aw menge kapitan te otaw egtonggò te dakel simbahan te Jerusalem. Migpebelaw-belaway dan tepad te pegtolok din ki Jesus amon dekepen dan. ");
INSERT INTO mbs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neluba dan, aw minikagi dan te doen kwarta ibegay dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Migsebad dan, aw yan migtagad si Judas te mèpiya aldaw amon itolok din si Jesus te wedad otaw metipon, amon wedad samok. ");
INSERT INTO mbs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nayan, dimateng se aldaw te pegpengaen te menge Judiyo te pan kenà eglebag. Yan heman se aldaw te pegpengiyaw dan te nati te karniro kànen dan te Pista te Pegpelowà. ");
INSERT INTO mbs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Simogò si Jesus ki Pedro aw si Juan, kagi din, “Peg-inang kaw den te kànen tadon te Pista te Pegpelowà.” ");
INSERT INTO mbs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mig-insà dan, “Kenan kay lay peg-inang?” ");
INSERT INTO mbs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Minikagi sikandin, “Eneng-enengi niyo ini. Aw domateng kaw doton te Jerusalem, kitaen niyo se otaw neniang te sibolan nepenò te wayeg. Taking kaw kandin. Aw domateng sikandin doton te balay, ");
INSERT INTO mbs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ikagi kaw diyà te tig-apò, ‘Insogò kay te Pengolo amon meg-insà kay kamno aw kenan se kànan te kedita day te Pista te Pegpelowà.’ ");
INSERT INTO mbs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Penga niyan, ipekità din diyà kenyo se dakel gibelayan kidoen diatas te balay tapay doen telepagan niyan. Peg-inang kaw te kànen tadon kidoen.” ");
INSERT INTO mbs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Penga niyan, dimoton dan aw kinità dan se kedita iling te tapay inikagi i Jesus diyà kandan. Penga niyan, mig-inang dan te kànen. ");
INSERT INTO mbs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pegdateng te oras te pegkaen, dimoton si Jesus aw menge sogounun din, aw kimaen dan. ");
INSERT INTO mbs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Minikagi si Jesus, “Ontò a neibeg komaen te pista seini doma niyo, so agpet a den imetayan. ");
INSERT INTO mbs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Penenalan kaw te kagi ko. Eked a todà kaen te Pista te Pegpelowà singed aw metoman se kedegdagan niyan kidoen te peglowan te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Penga niyan, inabat din heman se tabò, aw migpesiontong sikandin diyà te Timanem, aw minikagi, “Tepedi niyo ini amon mekeinem se kedita niyo. ");
INSERT INTO mbs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Penenalan kaw kanak. Eked a todà inem te ininem tadon seini singed aw metoman lomowan se Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nengabat heman sikandin te pan. Penga te pegpesiontong din, binelà-belà din iyan, aw inteped din diyà kandan, aw minikagi, “Se pan seini, yan se lawa ko imetayan amon mekelowà kaw. Inangi niyo iling kani amon gayed a niyo keeneng-enengan.” ");
INSERT INTO mbs_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Penga te pegkaen dan, inabat din heman se tabò aw minikagi sikandin, “Se meinem seini, yan se pengilala te doen kaling peokit ininang te Timanem pineokit te dipanog ko amon tebangan kaw. ");
INSERT INTO mbs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Meneng eneng-enengi niyo ini. Migdoma kanak dini se otaw megtolok kanak. ");
INSERT INTO mbs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Imetayan a Timanem Migpekeotaw, so yan se ibeg te Amay ko. Meneng mekelelayò se otaw megtolok kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Penga niyan, migpeinsaay se menge tinoledaan din aw sinu se megtolok kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nayan, migpedindilay heman se menge tinoledaan din aw sinu se ontò melangkaw diyà te kedita dan. ");
INSERT INTO mbs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yan minikagi si Jesus, “Gayed egleges se menge selotan te menge sakop dan, aw ibeg dan iduyun dan tandà te keido dan. ");
INSERT INTO mbs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Meneng eked kepakay aw meg-iling kaw kandan, so se melangkaw otaw diyà kenyo, yan se keilangan meinang iling te adi niyo. Se pengolo niyo, yan se keilangan meinang iling te sogounun niyo. ");
INSERT INTO mbs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aw doen otaw komaen kidoen te lemisa, aw doen heman otaw egtelaban kandin meglamak te kànen, netegahan niyo te labi pa melangkaw se otaw egpenenoo. Meneng pengkey siak se Pengolo niyo, meneng iling a te otaw egsogoen niyo. ");
INSERT INTO mbs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Pengkey medita se kelimahan ko, meneng sikiyo se gayed timaking kanak. ");
INSERT INTO mbs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Migpunù se Amay ko te siak se lomowan, aw megpunù a den heman te sikiyo ");
INSERT INTO mbs_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","se megdoma kanak te pegkaen ko kidoen te peglowan ko. Sikiyo heman se isawol ko lomowan diyà te sempolò teg dowa pongan te menge bowad-bowad i Israel.” ");
INSERT INTO mbs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Penga niyan, minikagi si Jesus diyà ki Pedro, “Simon, penenalan ka kanak. Pinemoyò i Satanas diyà te Timanem amon megtandà kenyo, iling te inangen te otaw meg-etap te omay trigo. ");
INSERT INTO mbs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Meneng migtawal-tawal a diyà te Amay ko tepad kamno amon gayed ka somalig diyà kanak. Pengkey tominàyog ka kanak te eked kenamay, meneng aw todà ka tomaking kanak, meketabang ka te menge doma no tinoledaan ko.” ");
INSERT INTO mbs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Minikagi si Pedro, “Pengolo, neketagad a den tomaking kamno pengkey kelebosowen a aw imetayan a.” ");
INSERT INTO mbs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Minikagi si Jesus, “Pedro, penenalan ka kanak. Te eked pegkolaak se manok kealdaw iselem, ibolon no se pegtaking no kanak te meketelo.” ");
INSERT INTO mbs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nayan, minikagi si Jesus diyà te menge tinoledaan din, kagi din, “Kedengan, insogò ko sikiyo megtoladà, meneng doen impunù ko te wedad kedònan ibingen niyo, pengkey kwarta aw kelepì, aw sepatos ekasan niyo. Indani a niyo. Nelimahan kaw lay so wedad kedònan niyo?” Timaba dan, “Wedà kay palos kelimahi.” ");
INSERT INTO mbs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Minikagi si Jesus, “Meneng lekat seini, aw doen kwarta niyo aw kelepì, ibingi niyo. Aw wedad ibayad niyo te podok, keilangan ibeligyà niyo se saol amon mekebayad kaw. ");
INSERT INTO mbs_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Metoman den se kagi te Timanem insolat tepad kanak, ‘Ipelumun sikandin iling te otaw dakel se salà.’ Agpet a den imetayan, so yan se insolat tepad kanak.” ");
INSERT INTO mbs_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Minikagi dan, “Meneng Pengolo, doen dowa podok tadon seini.” Meneng so wedà dan pekelabet, minikagi si Jesus, “Pebeyai niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nayan, nesayo si Jesus aw dimoton te bontod te Olibo, so melikit sikandin egdoton. Timaking heman se menge tinoledaan din. ");
INSERT INTO mbs_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pegdateng din doton, minikagi sikandin, “Pegtawal-tawal kaw amon eked kaw keboyo.” ");
INSERT INTO mbs_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Penga niyan, dimeleg si Jesus te kenà mediyò. Limongken sikandin aw migtawal-tawal, kagi din, ");
INSERT INTO mbs_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amà, aw mepakay diyà kamno, eked a no peokiti te kelimahan seini. Meneng ibeg ko, kamno ibeg se metoman, kenà kanak.”  ");
INSERT INTO mbs_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Penga niyan, doen anghil insogò lekat te langit amon megpekagsen te pedowan din. ");
INSERT INTO mbs_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ontò mebegat se pedowan din, aw yan se doun te ontò sikandin migtawal-tawal. Ontò sikandin pig-etingan iling te pegtedak te dipanog. ");
INSERT INTO mbs_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Penga te pegtawal-tawal din, dimoton sikandin te menge tinoledaan din, aw timedogi den dan, so migkelomay dan tandà te lidò dan. ");
INSERT INTO mbs_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Linoka din dan aw minikagi sikandin, “Tay law. Nepela a so timedogi kaw. Enaw kaw den. Pegtawal-tawal kaw amon eked kaw keboyo.” ");
INSERT INTO mbs_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Telobo pa minikagi si Jesus, dimateng se medita otaw kidoen. Inibing dan i Judas, sìyan tinoledaan i Jesus. Migpedapag sikandin diyà ki Jesus amon mengadek kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Meneng minikagi si Jesus diyà kandin, “Tay law, elew. Mengadek ka kedì kanak amon itolok a no Timanem Migpekeotaw.” ");
INSERT INTO mbs_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pegketaga-taga te menge tinoledaan i Jesus te dekepen sikandin, minikagi dan, “Pengolo, tigbasen day sikandan aw isogò kay nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pegketà nenigbas se sebad tinoledaan diyà te sineligan te ontò pengolo te simbahan, aw nepalot se telinga din lenged te kowanan. ");
INSERT INTO mbs_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Meneng minikagi si Jesus, “Ikà niyo.” Penga niyan, nemaed sikandin te telinga te sineligan, aw negolì iyan. ");
INSERT INTO mbs_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Se menge otaw dimoton amon megdakep dan ki Jesus, yan se menge pengolo te simbahan, aw menge kapitan te otaw egtonggò te dakel simbahan, aw menge obanen te Judiyo. Minikagi si Jesus diyà kandan, “Kolang se pegkekamang niyo te podok aw batota amon megdakep kaw kanak, so eden niyo aw megdedempasay a. ");
INSERT INTO mbs_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gayed a migtoladà kidoen te dakel simbahan, meneng wedà a niyo dekepi doton. Meneng mekedakep kaw den kanak, so seini se aldaw pinemallì te Timanem aw meg-inang si Satanas te medaet.” ");
INSERT INTO mbs_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Penga niyan, dinakep dan si Jesus aw inibing dan sikandin doton te balay te ontò pengolo te simbahan. Timelokon heman si Pedro meneng migpekediyò. ");
INSERT INTO mbs_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Doen apoy kidoen te dowangen inantay te menge otaw migtonggò, aw migdoma heman si Pedro te menge otaw mig-ingadang kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Peg-anyag te apoy diyà te bawa din, doen bayi kimità kandin aw minikagi, “Egdoma se otaw seini te otaw sida dinakep.” ");
INSERT INTO mbs_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Meneng migbolon si Pedro, aw minikagi sikandin, “Tay law, atà. Wedà ko sikandin kilelai.” ");
INSERT INTO mbs_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Penga niyan te wedà kenamay, doen heman doma otaw kimità kandin, aw minikagi, “Sikona heman se tinoledaan din.” Meneng minikagi si Pedro, “Kenà ko, elew.” ");
INSERT INTO mbs_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Penga te sebad oras minokit, doen heman doma otaw migtedò kandin, aw minikagi, “Benal sikandin se egdoma te otaw sida, so sikandin heman se tege probinsya te Galiliya.” ");
INSERT INTO mbs_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Meneng minikagi si Pedro, “Tay law, elew. Wedà ko ketegahi se inikagi nikaw.” Nayan, dalem pa te peg-ikagi i Pedro, migkolaak se manok. ");
INSERT INTO mbs_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Miniling si Jesus aw timengteng diyà ki Pedro. Yan neeneng-enengan din se tapay inikagi te Pengolo te ibolon din sikandin te meketelo te eked pa pegkolaak se manok te iselem. ");
INSERT INTO mbs_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Penga niyan, nesayo si Pedro aw ontò migkelag. ");
INSERT INTO mbs_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nayan, se otaw migtonggò ki Jesus, gayed dan nebebayat kandin aw nemadas dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sinempengan dan heman se mata din, aw minikagi dan, “Etoki aw sinu se nenombag kamno.” ");
INSERT INTO mbs_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Gayed dan migtompuyus kandin aw minikagi dan te medaet. ");
INSERT INTO mbs_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nayan, peglibtak te aldaw sìyan, netipon se kedita te obanen te Judiyo, aw menge pengolo te simbahan, aw menenoladà te punù ingkeliwat i Moises. Impeangay dan si Jesus, aw minikagi dan, ");
INSERT INTO mbs_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Sikona ekon se Misiyas egpelimanan day. Indani kay den aw benal iyan.” Meneng minikagi si Jesus, “Pengkey indanan ko sikiyo te kebenalan, meneng eked kaw pemenal kanak. ");
INSERT INTO mbs_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pengkey doen peden insà ko kenyo, meneng eked kaw heman taba kenyan. ");
INSERT INTO mbs_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Meneng te eked kenamay, menenoo a Timanem Migpekeotaw kidoen te tangkil te Timanem metolos amon lomowan a doma din.” ");
INSERT INTO mbs_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mig-insà se kedita dan, “Aw iling kenyan, Batà ka kedì te Timanem?” Timaba sikandin, “Benal se inikagi niyo te Batà a te Timanem.” ");
INSERT INTO mbs_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yan migpebelaw-belaway dan, “Wedad den kekemowan te peg-indan te doma otaw diyà kenitadon tepad kandin, so kandin den kagi se dinineg tadon.” ");
INSERT INTO mbs_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Penga niyan, timindeg se kedita dan netipon, aw nengibing dan ki Jesus doton te gobirnador si Pilato. ");
INSERT INTO mbs_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Migdimanda dan tepad ki Jesus, kagi dan, “Kinità day se otaw seini megsamok peden te pongan day, so migtoladà sikandin te eked kepakay aw mayad kay te mihoras diyà te gobirno te Roma. Migpelingo-lingo heman sikandin Misiyas, sìyan selotan lomowan kenami.” ");
INSERT INTO mbs_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mig-insà si Pilato diyà kandin, “Sikona lay se Selotan te menge Judiyo?” Timaba si Jesus, “Ee. Benal se kagi nikaw.” ");
INSERT INTO mbs_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Minikagi si Pilato diyà te menge pengolo te simbahan aw doma otaw netipon kidoen, “Wedad palos salà te otaw seini kinità ko.” ");
INSERT INTO mbs_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Meneng labi dan pa migleges kandin, kagi dan, “Gayed sikandin egsamok te kedita te otaw, so yan se ipegtoladà din kidoen te kebelad te Judiya, lekat te Galiliya taman dini.” ");
INSERT INTO mbs_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pegdineg i Pilato kenyan, mig-insà kandan aw si Jesus se sakop te probinsya te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pegketaga-taga din te lekat si Jesus te probinsya nesekopan i Herod, impeibing din doton kandin, so kidoen heman si Herod te Jerusalem te aldaw sìyan. ");
INSERT INTO mbs_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pegkità i Herod ki Jesus, ontò neluba, so tapay den sikandin dimineg tepad ki Jesus, aw nenamay den te ibeg din komità kandin aw menge kepelahan inangen i Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yan se doun te medita se in-insà i Herod diyà ki Jesus, meneng wedà palos taba. ");
INSERT INTO mbs_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Migpedapag se menge pengolo te simbahan aw menenoladà te punù, aw neopal dan migdimanda tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gayed nebebayat si Herod aw kedita te sondalo din, aw migpelingo-lingo dan te pegsagman dan kandin iling te pegsagman dan te selotan. Penga niyan, pineseolan i Herod si Jesus te ontò mèpiya saol iling te ekasan te selotan, aw impelikò din doton ki Pilato. ");
INSERT INTO mbs_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pineokit kenyan, migpesigelakay si Herod aw si Pilato, so tapay dan egpedindilay. ");
INSERT INTO mbs_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nayan, migtipon si Pilato te kedita te pengolo te simbahan, aw menge obanen te Judiyo aw otaw netipon kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Minikagi sikandin, “Pegpengibing niyo te otaw seini dini kanak, minikagi kaw te migsamok sikandin te kedita te otaw. Na, kinità niyo den te mig-insà a kandin, meneng wedad palos salà din kinità ko iling te indimanda niyo tepad kandin. ");
INSERT INTO mbs_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wedad heman salà din kinità i Herod, so impelikò din sikandin dini kenitadon. Na, eneng-enengi niyo ini. Wedad palos ininang din te mepakay sikandin ipelumun aw imetayan. ");
INSERT INTO mbs_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yan se doun te olò ko sikandin ipebadas, aw penga niyan ipelowà.”  ");
INSERT INTO mbs_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nayan, kelikit te Pista te Pegpelowà, gayed ipelowà din diyà kandan se sebad otaw kineleboso. ");
INSERT INTO mbs_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Meneng migbelobansag se kedita dan, “Imetayi se otaw seini. Pelowai si Barabas.” ");
INSERT INTO mbs_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na, si Barabas se nekeleboso pa, so sikandin se pengolo te otaw minato te gobirno kidoen te Jerusalem, aw doen heman otaw inimetayan din. ");
INSERT INTO mbs_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ibeg i Pilato megpelowà ki Jesus, aw yan todà din dan inikegiyan. ");
INSERT INTO mbs_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Meneng migbelobansag dan, “Imetayi sikandin. Lensangi diyà te kros.” ");
INSERT INTO mbs_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Te iketelo peg-ikagi i Pilato, minikagi sikandin, “Meneng wedad palos medaet ininang din. Wedad palos salà din kinità ko te mepakay sikandin ipelumun aw imetayan. Yan se doun te olò ko sikandin ipebadas, aw penga niyan ipelowà.” ");
INSERT INTO mbs_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Meneng gayed dan migbelobansag te dakel se kagi dan, so ontò dan ibeg te keilangan ilansang sikandin diyà te kros amon matay. Yan dinaeg dan si Pilato, so ontò dakel se kagi dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Penga niyan, minikagi si Pilato te tomanen din se ibeg dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yan impelowà din lekat te keleboso se otaw pinemallì dan, sìyan otaw minato te gobirno aw nemonò. Meneng si Jesus se impeibing din amon imetayan, so yan se ibeg dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Penga niyan, inibing te sondalo si Jesus lekat te balay i Pilato. Kidoen te dalan, kinità dan se tege Sirene ngadan din si Simon kaling dimateng lekat te saka. Lineges dan sikandin neniang te kros aw timetondog ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ontò medita se otaw timaking ki Jesus, aw medita heman se bayi ontò migkelag tandà te lano dan kandin. ");
INSERT INTO mbs_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Meneng miniling si Jesus aw minikagi, “Sikiyo bayi tege Jerusalem, ikà niyo egkelag tandà te kelimahan domateng diyà kanak. Meneng keilangan megkelag kaw tandà te kelimahan metoman domateng diyà kenyo aw menge batà niyo. ");
INSERT INTO mbs_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Penenalan kaw kanak. Doen aldaw domateng aw mikagi se otaw te labi pa meluba se menge bayi wedad palos batà dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te aldaw sìyan, tomawal se otaw diyà te menge bontod, kagi dan, ‘Bonboni kay niyo. Imetayi kay niyo.’ ");
INSERT INTO mbs_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aw medaet se kelimahan dimateng den diyà kanak pengkey wedad salà ko, labi pa medaet se kelimahan domateng diyà te otaw doen salà te modi aldaw.” ");
INSERT INTO mbs_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dowa heman se doma otaw inibing dan amon imetayan doma din, so ontò medaet se ininang dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pegdateng dan doton te bontod iningedanan Tòlan te Olo, inlansang dan sikandin diyà te kros. Inlansang heman se dowa otaw medaet kidoen te tangkil din, aw si Jesus diyà te tengà-tengà. ");
INSERT INTO mbs_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Migtawal-tawal si Jesus tepad te menge otaw miglansang kandin diyà te kros, kagi din, “Amà, pegwedadi se salà dan, so wedà dan ketegahi aw eden se ininang dan seini.” Penga te peglansang dan ki Jesus diyà te kros, pigtalad-talad dan se penenaktun linowas din, aw migbonot dan aw eden se penenaktun meabat te teg sebad-sebad kandan. ");
INSERT INTO mbs_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Timengteng kandin se kedita te otaw netipon kidoen. Meneng se menge obanen te Judiyo, migbaet-baet dan kandin, kagi dan, “Migtabang sikandin te doma otaw netigdaan amon eked dan pa kematay. Kitaen tadon den aw meketabang sikandin te kandin pegkeotawun amon eked kematay. Kitaen tadon heman aw benal sikandin se Misiyas insogò te Timanem, sìyan tapay pinemallì din.” ");
INSERT INTO mbs_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Migtompuyus heman se menge sondalo kandin. Dimoton dan kandin amon ipeinem dan kandin se bino sinengedan te wayeg. ");
INSERT INTO mbs_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Minikagi dan, “Aw ontò ka Selotan te menge Judiyo, tebangi se kamno pegkeotawun.” ");
INSERT INTO mbs_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Doen heman solat insawol doton diatas te olo din, kagi niyan, “Seini se Selotan te menge Judiyo.” ");
INSERT INTO mbs_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Se sebad otaw medaet impetangkil ki Jesus, migtompuyus sikandin, kagi din, “Petega-tegahi kay te ontò ka Misiyas. Tebangi se kamno pegkeotawun, aw tebangi kay heman.” ");
INSERT INTO mbs_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Meneng migsagda se sebad, kagi din, “Ikà egtompuyus te Timanem. Keilangan megselsel ka diyà te Timanem, so onawa se pelumun dimateng den diyà kenitadon. ");
INSERT INTO mbs_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Keilangan ipelumun ki den, so yan se detengan te medaet ininang ta. Meneng wedad palos medaet ininang te doma ta seini.” ");
INSERT INTO mbs_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Penga niyan, minikagi sikandin diyà ki Jesus, “Keidowi a bag aw lomowan ka.” ");
INSERT INTO mbs_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Minikagi si Jesus, “Eneng-enengi se kagi ko kamno. Kwani seini, megdoma ka kanak doton te langit.” ");
INSERT INTO mbs_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pegkealas dosi te aldaw, migkengitngit se langit aw tanà lamig alas tris te meapon, ");
INSERT INTO mbs_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","so wedà senang se aldaw. Tigkan heman nelisì se kayad kidoen te tengà-tengà te dakel simbahan te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Penga niyan, timawal si Jesus te dakel se kagi din, “Amà, isalig ko den se pedowan ko diyà kamno.” Penga te peg-ikagi din kenyan, nematay sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kinità te kapitan te sondalo se kepelahan neinang te pegkematay i Jesus, aw dimuyun sikandin te Timanem, kagi din, “Ontò mèpiya se otaw sìyan.” ");
INSERT INTO mbs_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nayan, se kedita te otaw netipon kidoen, pegkità dan te kedita niyan neinang, migsiolì dan aw dinapì dan se kagpa dan tandà te lano dan. ");
INSERT INTO mbs_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Meneng se kedita te sigalak i Jesus aw menge bayi timaking kandin lekat te Galiliya, timindeg dan te kenà mediyò te kros, aw kinità dan se ininang kandin. ");
INSERT INTO mbs_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nayan, doen otaw si Jose tege Arimatiya sakop te probinsya te Judiya. Mèpiya otaw sikandin, aw gayed eg-inang te metòlid, aw egpeliman te peglowan te Timanem. Pengkey sikandin se sebad obanen diyà te menge obanen eglowan diyà te menge Judiyo, meneng wedà tandù diyà te medaet piglalang te menge doma din obanen, sìyan ininang den dan diyà ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dimoton sikandin ki Pilato aw pinemoyò din se lawa i Jesus amon ilebeng din. ");
INSERT INTO mbs_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Penga niyan, inabat din se lawa lekat te kros, aw ginakes din iyan te sapot, aw inlebeng din kidoen te lebeng kaling ininang diyà te pangpang, aw wedad pa palos inlebeng. ");
INSERT INTO mbs_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Agpet den somallep se aldaw, aw keeldawan niyan se Sebado aw aldaw te peg-etod. ");
INSERT INTO mbs_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Peglebeng i Jose ki Jesus, timelokon heman se menge bayi timaking ki Jesus lekat te Galiliya. Kinità dan heman se lebeng aw pegsawol te lawa din kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Penga niyan, minolì dan aw migtegilan dan te menge kemolò te lana metinadeg isawol dan diyà te lawa te nematay. Aldaw te Sebado, mig-etod dan, so yan se punù ingkeliwat i Moises. ");
INSERT INTO mbs_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Meneng pegkeiselem te Linggo, limapos se menge bayi nengibing te metinadeg integilan dan, aw dimoton dan te linebengan ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pegdateng dan doton, kinità dan se lebeng neowang, so tapay den nekelid se dakel bato insampeng. ");
INSERT INTO mbs_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Peg-awop dan diyà te lebeng, kinità dan te wedad den lawa i Jesus kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Migkebulung dan aw eden se neinang. Penga niyan, kinità dan se didowa anghil kidoen, aw ontò mepotì se penenaktun dan. ");
INSERT INTO mbs_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Timikelong se menge bayi, so ontò dan nelemitan. Minikagi se menge anghil, “Ikà niyo egpengemahà te otaw neantay lekat te nematay dini te lebenganan. ");
INSERT INTO mbs_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wedad sikandin dini, so neantay den lekat te nematay. Eneng-enengi niyo se inikagi din diyà kenyo kedengan dalem te pegtoladà din kidoen te Galiliya. ");
INSERT INTO mbs_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Inikegiyan kaw din te keilangan ibegay sikandin Timanem Migpekeotaw diyà te belad te menge otaw nelegeb te salà amon imetayan dan sikandin ilansang diyà te kros, aw penga niyan, meantay sikandin lekat te nematay te iketelo te aldaw.” ");
INSERT INTO mbs_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yan neeneng-enengan dan te yan se inikagi i Jesus diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Penga niyan, minolì dan, aw mig-indan dan te kedakel niyan diyà te sempolò tegusà tinoledaan i Jesus aw diyà te menge doma dan kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Se menge bayi sìyan, yan si Maria tege Magdala, si Juana, si Maria inay i Santiago, aw menge bayi doma dan. Peg-indan dan kenyan diyà te menge sogounun i Cristo, ");
INSERT INTO mbs_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","wedà dan pemenal te neantay den si Jesus, so eden dan aw kenà benal se inikagi dan. ");
INSERT INTO mbs_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Meneng kimagnan si Pedro pesalo doton te lebeng. Pegdateng din doton, simelib sikandin aw timengteng doton didalem. Kinità din olò se sapot tapay inggakes diyà te lawa, meneng wedad lawa kinità din. Penga niyan, minolì sikandin gayed mig-aneng-aneng tepad te neinang, so nepela sikandin. ");
INSERT INTO mbs_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te aldaw sìyan, doen didowa tinoledaan i Jesus minipanaw pesalo doton te Imaos, sebad lonsod menge sempolò tegusà kilomitro lekat te Jerusalem. ");
INSERT INTO mbs_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Gayed dan migpebelaw-belaway tepad te kedita te neinang ki Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dalem pa te pegpebelaw-belaway dan, migpedapag si Jesus aw migdoma kandan. ");
INSERT INTO mbs_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pengkey kinità dan sikandin, meneng wedà dan kilala kandin. ");
INSERT INTO mbs_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Peg-ipanaw dan, minikagi si Jesus, “Eden lay se egbelaw-belewayen niyo gina?” Simagked se didowa dan aw ontò nelidò se pedowan dan. ");
INSERT INTO mbs_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Penga niyan, timaba se sebad si Cleopas, kagi din, “Tay law, elew. Nepela a, so pengkey gimemaw ka doton te Jerusalem, meneng wedà ka kedì ketaga-taga aw eden se neinang kidoen te menge aldaw seini.” ");
INSERT INTO mbs_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Minikagi sikandin, “Eden lay se neinang kidoen?” Minikagi dan, “Doen telekeliwat te kagi te Timanem ngadan din si Jesus tege Nasarit. Insogò sikandin te Timanem, aw ontò mèpiya se ininang din aw inikagi din kinità te kedita te otaw. ");
INSERT INTO mbs_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Meneng se menge pengolo te simbahan aw menge obanen te Judiyo, impedakep dan sikandin te gobirno, aw penga niyan inimetayan dan sikandin inlansang diyà te kros. ");
INSERT INTO mbs_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tapay kay migpeliman te sikandin se megpelowà te menge bowad-bowad i Israel. Meneng inimetayan dan sikandin te netelowan pa. ");
INSERT INTO mbs_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Meneng pengkey nematay sikandin, nepela kay, so doen menge kedomaan day bayi limapos doton te lebeng din gina iselem, ");
INSERT INTO mbs_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","meneng wedad lawa din kinità dan kidoen. Peg-olì dan, mig-indan dan diyà kenami te doen menge anghil migpekità diyà kandan, aw minikagi dan ekon heman te neantay den si Jesus lekat te nematay. ");
INSERT INTO mbs_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Doen menge doma day dimoton heman te lebeng din, aw kinità dan te benal se in-indan te menge bayi. Meneng wedà dan kitai si Jesus.” ");
INSERT INTO mbs_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Penga niyan, minikagi si Jesus, “Tay law. Nepela a kenyo, so wedà kaw pa pemenal te kedita te inikagi te menge telekeliwat te kagi te Timanem gebii. ");
INSERT INTO mbs_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nepela a so wedà niyo ketegahi te eked lowan se Misiyas singed aw onà sikandin imetayan iling te neinang den seini.” ");
INSERT INTO mbs_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Penga niyan, miglebad-lebad si Jesus diyà kandan te kedita te insolat kidoen te kagi te Timanem tepad te pegkeotawun din, lekat te insolat i Moises aw kidoen te insolat te kedita te telekeliwat te kagi te Timanem gebii. ");
INSERT INTO mbs_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pegkedapag dan doton te lonsod dinotonan te didowa tinoledaan sìyan, domeleg peden si Jesus. ");
INSERT INTO mbs_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Meneng ontò dan sikandin tinemengan, kagi dan, “Idegà ka den dini kenami, so ontò den meapon aw agpet den delem.” Penga niyan, timaking si Jesus kandan. ");
INSERT INTO mbs_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Peg-iyambong dan, inabat din se pan, aw migpesiontong sikandin diyà te Timanem, aw binelà-belà din, aw imbegay din diyà kandan. ");
INSERT INTO mbs_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Penga niyan, kinilala den dan te sikandin si Jesus. Meneng pegketà, migkewedad sikandin kidoen. ");
INSERT INTO mbs_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Migpebelaw-belaway dan, “Yan kedì se doun te neantag se pedowan ta te peg-ikagi din diyà kenita kidoen te dalan, aw peglebad-lebad din te kagi te Timanem diyà kenita.” ");
INSERT INTO mbs_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Penga niyan, nesayo dan aw limikò dan doton te Jerusalem. Pegdateng dan doton, tapay netipon se sempolò tegusà tinoledaan i Jesus aw menge doma dan. ");
INSERT INTO mbs_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Minikagi se otaw tapay netipon, “Ontò benal neantay se Pengolo lekat te nematay, so migpekità sikandin diyà ki Simon.” ");
INSERT INTO mbs_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Penga niyan, mig-indan se didowa dan kaling dimateng tepad te neinang kandan kidoen te dalan, aw pegkilala dan kandin te pegbelà-belà din te pan. ");
INSERT INTO mbs_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dalem pa te peg-indan dan te kinità dan, dimateng si Jesus timindeg kidoen te tengà-tengà dan. Minikagi sikandin, “Ibeg ko melinaw se pedowan niyo.” ");
INSERT INTO mbs_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Meneng nelemitan dan, so eden dan aw along din. ");
INSERT INTO mbs_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Minikagi si Jesus, “Ikà niyo egkebulung. Ikà niyo heman egdowa-dowa. ");
INSERT INTO mbs_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tengtengi niyo se menge palì diyà te belad ko aw benis ko. Ontò siak. Pemaed kaw kanak amon ontò kaw metaga-taga te kenà a olò along. Wedad lawa te along, meneng seini kitaen niyo den te doen lawa ko.” ");
INSERT INTO mbs_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Penga niyan, impekità din kandan se belad din aw benis din. ");
INSERT INTO mbs_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Neluba dan, meneng iling te wedà dan peme