﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbjNT_vpl;
CREATE TABLE mbjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbjNT_vpl WRITE;
INSERT INTO mbjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesus Kristo, Dawi panaa, Abaraãm panaa. Hahỹ ta wahë makũ sa häd heen n'aa kerih doo: ");
INSERT INTO mbjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraãm t'aah, Isak. Isak t'aah, Jakóh. Jakóh taah, Judah, ta hỹỹj daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah t'aah, Peres. Peres taah, Eserõm Serah daheeh. Tamar mä sa ỹỹn makũ häd. Eserõm t'aah, Rãm. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rãm t'aah, Aminadab. Aminadab t'aah, Nasõm. Nasõm t'aah, Saramon. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramon t'aah, Buwas. Buwas ỹỹn Rahab häd näng doo. Buwas t'aah, Obed. Obed ỹỹn mä Rut häd näng doo. Obed t'aah, Jesé. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesé t'aah kä, Dawi, ër wahë makũ sa wahë n'aa paah. Dawi t'aah, Saromãw. Saromãw ỹỹn Urija häd näng do ỹỹm paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromãw t'aah, Reoboãm. Reboãm t'aah, Abijah. Abijah t'aah, Asah. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asah t'aah, Josapa. Josapa t'aah, Jorãw. Jorãw panaa seeh, Usijah. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usijah t'aah, Jotãw. Jotãw t'aah, Akas. Akas t'aah, Esekijah. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekijah t'aah, Manaséh. Manaséh t'aah, Amom. Amom t'aah, Josijah. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josijah panaa kä, Jekonija, ta hỹỹj daheeh. Babirõn buuj, Judah buuj majĩĩ, sa häj n'aa hẽnh Judah buuj ramahũũm noo gó Jekonija rababok. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babirõn häj n'aa bä rabaj'eenh do jawén paa bä henäk do hahỹ Jesus wahë makũ sa häd: Jekonija t'aah, Saratijéw. Saratijéw t'aah, Sorobab. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobab t'aah, Abijuh. Abijuh t'aah, Erijakĩm. Erijakĩm t'aah, Asor. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor t'aah, Sadok. Sadok t'aah, Akĩh. Akĩh t'aah, Erijud. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Erijud t'aah, Erejasa. Erejasa t'aah, Matãn. Matãn t'aah, Jakóh. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakóh t'aah, Joséh kä. Marija häd näng do patug ti Joséh. Marija t'aah kä, Jesus, ramaneëënh do Kristo, P'op Hagä Do H'yyb Däng Doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","14 Jesus wahë makũ sa häd ketsén do Abaraãm du doo bä naa, Dawi bä kä tagadäk. 14 sa häd ketsén do Dawi häd bä naa, Judah buuj Babirõn häj n'aa hẽnh ramahũũm bä kä. 14 kä m' Jesus Kristo wahë makũ sa häd ketsén do Babirõn häj n'aa hẽnh rabeboo nä do jawén paa bä naa, Kristo benäng bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hahỹỹ da Jesus Kristo benäng do ky n'aa. Jesus ỹỹn pan'aa Marija häd näng doo. Joséh gatëë do pan'aa m' ti Marija. Ti m' Marija beta däk, dooh Joséh awäd bä ta wë. Marija wén eta däk, P'op Hagä Do Sahee hejój hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Baad ub, P'op Hagä Do karẽn doo da Joséh, ta patug pan'aa bawät. Ti hyb n'aa m' dooh takarẽn bä Marija taky n'aa tapa bä hajõk do sa matym gó. Dooh takarẽn bä Marija tanu meby bä ta wób sa hã. Ti hyb n'aa tahyb n'aa newë däk, ta h'yyb gó, Marija tamejõ hõm taganat'ëë wät hyb n'aa. Dooh m' takarẽn bä ta wób tamaher'ood bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ti m', ta ti tahyb n'aa newë däk do jawén paa bä Tak'ëp Hyb N'aa Jawyk Do ããs kas'ee wät ta hã ta s'ëë gó. Ti m' ta s'ëë gó ããs ky hadoo ta hã. Hahỹỹ da ta kyyh: —Joséh, Dawi panaa, —näng mäh —mahyb n'aa p'eed manäh. Magat'ëë né hẽ Marija. Ajãn ta wog gó hasuun doo, P'op Hagä Do Sahee hejój hanaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aj'yy da ta t'aah. Mahäd n'oo da Jesus, P'op Hagä Do karapee tabed'ëëp hyb n'aa da nesaa do ramoo bok do mahǟnh —näng mä ããs kyyh Joséh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sahõnh hẽ tii d' tawén hadoo, Tak'ëp Hyb N'aa Jawyk Do kyyh ta ky n'aa rod Isajas häd näng do erii wät do paa kaja däk hyb n'aa. Hahỹỹ da taky däng do paah: ");
INSERT INTO mbjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Etaah da maruus aj'yy manepäh nä doo. Enyy däk da aj'yy ta t'aah. Ramaneëënh da ta häd Imanuéw”, näng mäh. “Ër mahang P'op Hagä Do bawät”, tahanäng pé ti Imanuéw. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ti m' Joséh ty gawëëj däk bä, ããs mejũũ doo da né hẽ taky daheeh. Marija tagat'ëë däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tagat'ëë däk né hẽ, dooh ta wë tawäd bä Marija t'aah nenäng nä bä. Ti m' Marija t'aah benäng do jawén paa bä Joséh häd n'oo däk mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ti m' panang Berẽnh häd näng doo bä, Judah häj n'aa bä Jesus benäng sa wahë n'aa Eróts häd näng do bag'ããs noo gó. Tabenäng do jawén paa bä ajyy tak'ëp ma kamet'ëëk doo, sagõõh ky n'aa ma kamahet'ëëk do kaj'aa Jerusarẽnh bä. Sa häj n'aa papỹỹj hana hẽnh rahana. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ti m' rakajaa bä kä rabeaanh: —Nyy bä tabadäg däk Judah buuj sa wahë n'aa nag'aap hẽ henäng doo? —näk mäh. —Ãã hapäh sagõõh tabenyy däk do heen n'aa. Papỹỹj nu ganyy hẽnh tahana. Ãã wén na bë wahë n'aa nag'aap hẽ henäng do ãã weh'ëëh hyb n'aa —näk mä sagõõh ky n'aa ma kamahet'ëëk do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ti m' tak'ëp mä Judah buuj sa wahë n'aa Eróts häd näng do hyb n'aa tón mä taky n'aa napäh bä sagõõh ky n'aa ma kamahet'ëëk do raher'oot doo. Sahõnh hẽ Jerusarẽnh panang buuj na-ããj hẽ m' rahyb n'aa tón mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti m' Eróts mejũũ ranaëënh hyb n'aa ta wë sahõnh hẽ Judah buuj sa rod n'aa P'op Hagä Do wë wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ. Ti m' tabeaanh mä sa hã nyy bä P'op Hagä Do kyy kerih do ky däng Kristo, P'op Hagä Do H'yyb Däng Do benäng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ti m' raky hadoo: —Berẽnh panang bä, Judah häj n'aa bä tabenäng da —näk mäh. —Hahỹỹ da P'op Hagä Do ky n'aa rod see erii wät paa ta ti ky n'aa —näk mäh: ");
INSERT INTO mbjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Panang Berẽnh, Judah häj n'aa bä badäk doo, õm ky n'aa netsëëh do nado panang ky n'aa etsëëh do sa mahang, Judah häj n'aa bä. Ky n'aa etsëëh da õm, a babuuj mahang ganyyh do hyb n'aa ta bagã n'aa, Isaraéw buuj, karapé haa h'yyb mahũũm doo.” —Tii d' né hẽ P'op Hagä Do kyyh, ta ky n'aa rod see erih do paah —näk mä Mosees ky n'aa jaw'yyk do ma mehetëk do sa kyyh Eróts hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ti m' Eróts mejũũ rabats'yyt ta wë kejën doo gó sagõõh ky n'aa ma kamahet'ëëk doo. Ti m' tabeaanh mä sa hã ny noo gó ti sagõõh ganyyh. Ti m' rabaher'oot ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ti m' Eróts mejũũ mä Berẽnh hẽnh rabahõm hyb n'aa. Ti m' ky ken'yym doo gó m' taky hadoo sa hã: —Bë ahõm, baad bë esóts karapee —näng mäh. —Karapee bë awyyd bä, nayyw hẽ ỹ karẽn ỹ bë maher'ood, karapee ỹ weh'ëëh hyb n'aa bë nemuun —näng mä Eróts kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ti m' sa hã Eróts maher'oot do jawén paa bä, ratsyym kasog kän mäh. P'aa hẽnh mä sagõõh rabahapäh ẽnh ramahõm me. Sa pooj jé m' sagõõh bahõm. Ti m' sagõõh bayyw kä kän tób karapee t'aah yt sooh do pong jó. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tak'ëp mä ratsebee bong sagõõh rabahapäh bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ti m' tób gó rabajëë p'ëë bä kä rabawyyd kän mä karapee Marija moo gó kä. Ti m' rabehyy b'ëëh tũũ sa taron nu paa me karapee t'aah wë. Ti m' rawehëë kän ta hã. Ti m' raban'oo däk ta hã ta matym n'aa tak'ëp hanäm doo, ky n'aa gebah doo. K'ããts tëg gabarëëh do s'ëëb, b'aa täg buu benyym do s'ëëb in-sijẽẽn häd näng doo, b'aa täg buu benyym do s'ëëb miir häd näng do raban'oo kän ta matym n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ti m' sa s'ëë gó kä P'op Hagä Do maher'oot ranabaaj hõm hyb n'aa Eróts magä doo me, Eróts ramanaher'oot hyb n'aa. Ti m' ta tyw n'aa see me m' rababaaj hõm kän sa häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ti m' sagõõh ma kamahet'ëëk do ratsyym kasok do jawén paa bä, Tak'ëp Hyb N'aa Jawyk Do ããs kasee mä Joséh hã ta s'ëë gó. Ti m' ta s'ëë gó taky hadoo ta hã: —As'ëëg g'ëëd! —näng mäh. —Mamahũũm wäd karapee t'aah ta ỹỹn daheeh Esit häj n'aa hẽnh, t'ĩĩ hẽnh bë kejën hõm hyb n'aa. Eróts mejũũ da resoos karapee t'aah tadaj'ëëp hyb n'aa. Ti hyb n'aa da Esit bä bë ayyw dó, õm ỹ maher'oot bä kä da mabana —näng mä ããs kyyh Joséh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ti m' nayyw hẽ Joséh ty gawëëj däk. Ti m' atsëm né hẽ Joséh bado däk karapee t'aah, ti m' karapee ỹỹn daheeh ratsyym kasog kän Esit hẽnh hah'ũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ti m' Esit häj n'aa bä rabajeej kän Eróts bedëp nä bä. Tii d' tawén hadoo P'op Hagä Do kyyh ta ky n'aa rod see her'oot do paa kaja däk hyb n'aa. Hahỹỹ d' mä P'op Hagä Do kyyh ta ky n'aa rod erih do paah: “Ỹ naëëj wät tah ỹỹ, Esit bä naa tabanyyh hyb n'aa”, näng kerih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ti m' Eróts h'yy kadaw'uuh sagõõh ky n'aa ma kamahet'ëëk do rawadii doo. Ti hyb n'aa tak'ëp mä takawajããn. Ti m' tamejũũ mä radej'ëëp hyb n'aa Berẽnh panang bä, panang nedaa bä na-ããj hẽ, sahõnh hẽ karepé ajyy pawóp hẽ ta baab n'aa hedo padëëk doo, ti yd jé ta baab n'aa hedoo do na-ããj hẽ. Tii d' tawén d'oo, pawóp däg mä ta baab sagõõh ky n'aa ma kamahet'ëëk do pooj jé rabahapäh sagõõh karapee henäng do heen n'aa ganyyh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tii d' né kä m' kaja däk P'op Hagä Do kyyh ta ky n'aa rod Jeremiij häd näng do erih do paa kä. Hahỹỹ da paa m' ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Panang Rama häd näng doo bä naa maa enä tak'ëp ha'oot doo. Tak'ëp h'yy kat'oon do sa kyyh ji maa napäh da. Rakéw panaa kyyh né hẽ tii, sa taah p'ãã 'oot doo. Dooh wäd sa taah. Ti hyb n'aa dooh rakarẽn bä ta wób rah'yyb enäw bä sa hã”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ti m' Eróts dajëp do jawén paa bä, ta s'ëë gó m' ããs kas'ee wät Joséh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hahỹỹ da ããs kyyh ta hã: —As'ëëg g'ëëd! —näng mäh. —Mamabaj hõm karapee t'aah ta ỹỹn daheeh Isaraéw häj n'aa hẽnh kä. Dejëp karapee majĩĩ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ti m' Joséh bas'ëëg gëët mäh, tado däk karapee t'aah, ti m' karapee ỹỹn daheeh ratsyym kasog kän Isaraéw häj n'aa hẽnh hah'ũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ti m' Joséh ky n'aa napäh bä Akeraw häd näng do bag'ããs mä Judah häj n'aa bä ta yb jawén buuj, eỹỹm mä t'ĩĩ hẽnh tahõm bä kä. Ti m' ta s'ëë see gó P'op Hagä Do ããs maher'oot mä t'ĩĩ hẽnh tanahõm hyb n'aa. Ti hyb n'aa kä m' Isaraéw häj n'aa bód Garirej häd näng doo hẽnh mä tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ta tii bä, panang Nasaréh häd näng do bä rabajeej kän. Tii b' mä kaja kän hahỹ P'op Hagä Do ky n'aa rod raher'oot do paa P'op Hagä Do ky däng do ky n'aa hã: “Ramaneëënh da Nasaréh buuj”, näk paa sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti m' ta see pé noo gó, nu gemuun do paah, Jowãw häd näng do bahõm kän Judah häj n'aa bä tabanawäng hẽnh. T'ĩĩ hẽnh mä tamaher'oot maa new'ëë do sa hã P'op Hagä Do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hahỹỹ d' mä ta kyyh: —Edaa däk hỹ pong jé hawät do ji tabag'ããs doo. Ti hyb n'aa bë eréd hõm nesaa doo, P'op Hagä Do wë bë h'yy kawareem hyb n'aa —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jowãw né hẽ ti aj'yy ta ky n'aa P'op Hagä Do ky n'aa rod Isajas häd näng do her'oot do paa hahỹ tabaher'oot noo gó: “Hahỹỹ da tabanawäng bä her'oot do kyyh: Bë tyw n'aa bak'ood däg da Tak'ëp Hyb N'aa Jawyk Doo. Baad ub da bë tyw n'aa daj'aah”, näng mä takerii däk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jowãw saroor mä kameer wii s'ëëb, ta pan'aa. Ta baa wyd paa m', ta byyh. Sabakar paa m' tawëh ta tä, mabaa bëëh paa m' ta waa. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ti m' hajõk Jerusarẽnh babuj n'aa, Judah häj n'aa buuj, tamii Joradãn nabyy me habong do na-ããj né hẽ m' rabahõm Jowãw wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nesaa do rakawoom bä, Jowãw nu gemuun hõm tamii Joradãn häd näng doo me. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ti m' hajõk Pariséw ramaneëënh doo, hajõk Saduséw ramaneëënh do na-ããj hẽ ta wë, tanu gemuun doo bä rabana Jowãw bahapäh bä, taky hadoo mä sa hã: —Aw'yy p'yym näng do taah hadoo bëëh! —näng mäh. —Nyy da bë ed'oo bë kejën nesaa do bë hã P'op Hagä Do banoo do mahǟnh? J'ooj madäk doo me bë ed'oo bë nu kemuun nesaa do mahǟnh? ");
INSERT INTO mbjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Taw'ããts hẽ pooj jé bë metäh te hub tado bä nesaa do bë eréd hõm bä. Bë metäh hanäm do bë moo bok do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bë daab yb manä Abaraãm panaa bë hanäk do hã. Bë edoo manäh: “Ãã P'op Hagä Do gadoo Abaraãm panaa ãã bahadoo do hyb n'aa.” P'op Hagä Do karẽn bä tahajaa hahỹ pä tawareem bä, Abaraãm panaa rado padäg bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Edaa däk h'yy kawanereem do P'op Hagä Do ky n'aa etyy doo. Aj'yy myym joom kóm pa tadahëë däk do tabagëëm hyb n'aa hadoo tii. Sahõnh hẽ joom tëëg neaak do tagëëw jat da, ti tabaju hõm da —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ti m' Jowãw ky hadoo ẽnh: —Ỹ ti hỹỹh, bë ỹ nu gemuun naëng me, baad hadoo do wë bë h'yy kawareem do metëë n'aa. Ti awät da jawén ỹỹ tak'ëp hyb n'aa jawyk do bahǟnh ỹỹ. Hã ỹỹ, ỹ hyb n'aa sakog its ta hã. Ti hyb n'aa dooh ỹ haja bä ta tsyym suun ỹ patsä bä —näng mäh. —Tii kä P'op Hagä Do Sahee tabajëë suun bë h'yyb tym gó, bë tah'yyb mahũũm hyb n'aa. Tëëg hõõ hadoo doo me bë d' tametyy baad tabanäw däk hyb n'aa bë h'yyb tym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tsyt hẽ tabetyn hõm da P'op Hagä Do karẽn do moo heb'ook doo, tsyt hẽ ta wób. P'op Hagä Do karẽn do moo b'ook doo, banäm doo hẽnh tabetyn hõm, tabanesaa hẽnh ta wób, aj'yy ta nahëë me tetyn hõm do hadoo tiriig ta bóg mahǟnh. Ta joom ag tiriig tabataa ta tób n'aa yt hã. Ta bóg taju toonh tëëg hõõ me, nadëëk doo me —näng mä Jowãw kyyh Kristo ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ti m' ti noo gó Garirej häj n'aa bä naa Jesus bawëënh tamii Joradãn häd näng doo hẽnh, Jowãw nu gemuun hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ti m' Jowãw geǟm paawä, ti m' taky hadoo: —Hëd n'aa wë ỹ mabana õm ỹ nu gemuun hyb n'aa? Ỹ paawä ti manu gemuun —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ti m' Jesus ky hadoo ta hã: —Taw'ããts hẽ ta tii da dó. Ỹ manu gemuun né hẽ. Taw'ããts hẽ ër bad'oo sahõnh hẽ ër hã P'op Hagä Do karẽn doo —näng mäh. Ti m' tii d' taky hadoo do hyb n'aa m', Jowãw nu gemuun kän Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus nu kemuun wät do jawén paa bä, nayyw hẽ tabanyyh tame naa. Tabanä sii hẽ m' wë kabasëëts hõm. Ti m' tahapäh mä P'op Hagä Do Sahee ahyng mä ta wë. Gurii-i bahyng doo da P'op Hagä Do Sahee bahyng. Ta hã m' tabadäng. ");
INSERT INTO mbjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ti m' hỹ pong jé naa tamaa ena kän P'op Hagä Do kyyh. Hahỹỹ da m' ta kyyh: —Hahỹ tah ỹỹ, tak'ëp ỹ kamahǟn up doo. Baad ỹ h'yy gadajang tan'oo bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ti m' P'op Hagä Do Sahee mahũũm kän Jesus tabanawäng hẽnh, rabanabok hẽnh, Dijab metyy hyb n'aa Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ti m' 40 ta ǟ noo gó dooh m' Jesus awa bä, dooh m' tawëë bä. Ti jawén mä Jesus basa däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tii bä Dijab, ji h'yyb tahet'uuk doo, ana ta wë, ti m' taky hadoo: —P'op Hagä Do T'aah mado bä, —näng mäh —mamejõ hahỹ pä rakawereem padëëk pãw —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ti m' Jesus ky hadoo: —Dooh. Hahỹỹ da P'op Hagä Do kyy kerih doo: “Ji waa hã had'yyt nado ji bedëp. Sahõnh hẽ P'op Hagä Do kyyh hyb n'aa ji bedëb heh'äät” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ti m' Jesus Dijab mahũũm kän Jerusarẽnh hẽnh, panang tsyt hẽ P'op Hagä Do wë kasëëw däk doo hẽnh. Ti m' tabatsyyd hõm P'op Hagä Do tób n'aa jó p'op nu däk doo hẽnh tabasëëk hyb n'aa. Ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—P'op Hagä Do T'aah mado bä, —näng mäh —keréd hyy tũũ. Hahỹỹ da P'op Hagä Do kyy kerih doo —näng mä Dijab kyyh: “P'op Hagä Do mejũũ da ta ããs, baad õm rabahag'ããs hyb n'aa. Õm da ragadoo p'op pä hã a tsyym taganadas hyb n'aa”, näng P'op Hagä Do kyyh —näng mä Dijab. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ti m' Jesus ky gadoo: —Hahỹỹ da na-ããj hẽ P'op Hagä Do kyy kerih doo: “Mamety manä P'op Hagä Doo, a hagã n'aa” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ti m' Jesus Dijab masäk waëë p'op nu däk do jó. Tii b' naa m' tametëëh ta hã sahõnh hẽ badäk hahỹỹ hã hanäng do häj n'aa rabag'ããs doo, sahõnh hẽ hanäm doo, hetsooh do badäk hahỹỹ hã hanäng do na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ti m' taky hadoo ta hã: —Sahõnh hẽ ta ti ỹ anoo da a hã, wë ỹỹ, tũũ a taron nuu me ỹ mawehëë bä —näng mä Dijab kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ti m' Jesus ky hadoo: —Ahõm mahǟnh ỹỹ, Nesaa Do Yb! —näng mäh. —Hahỹỹ da P'op Hagä Do kyy kerih doo: “Jããm hẽ P'op Hagä Doo, bë hagã n'aa, bë wehëë. Jããm hẽ ta ti bë hyb n'aa jew'yyk, bë ky daheeh”, näng kerih doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ti m' Dijab bahõm kän Jesus mahǟnh. Ti m' ããs rabana, rahag'ããs mä Jesus, ranoo mä ta hã ta waa kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ti m' Jowãw nu gahem'uun do radawäts gëët do Jesus ky n'aa napäh bä m', tababaaj hõm kän mä Garirej häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ti m' panang Nasaréh bä tabaym dó jawén paa bä m', takahỹỹd gä panang Kapar-Naũm häd näng doo hẽnh. Karaj'aa Garirej häd näng do nabyy me Kapar-Naũm badäk, Seburũn, Napatawi sa häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tii da tawén d'oo, P'op Hagä Do ky n'aa rod Isajas häd näng do her'oot do paa takaja däk hyb n'aa. Hahỹỹ d' paa m' Isajas kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Seburũn, Napatawi häj n'aa babuuj, karaj'aa nabyy me, tamii Joradãn tamyyj däk hã badäk do buuj. Garirej sa häj n'aa häd, hajõk do Judah buuj nadoo do rabaj'eenh bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ta tii bä, gadagyp do hadoo doo gó habok doo, P'op Hagä Do nahap'ëëh doo, rahapëë däg kän ta bag ty eh do hadoo doo. Dajëb bawät bä habok do sa hã ganä wät ta bag”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti m' ti noo gó Jesus du do däk tamaher'oot sahõnh hẽ sa hã. Hahỹỹ d' mä ta kyyh: —Edaa däk hỹ pong jé hawät do ji tabag'ããs doo. Ti hyb n'aa bë eréd nesaa doo, P'op Hagä Do wë bë h'yy kawareem hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ti m' karaj'aa Garirej häd näng do nabyy me Jesus bawät bä m', tabahapäh mä pawóp hẽ ajyy. Simaw, Peed ramaneëënh doo, ta hỹỹj Ãn-Deréh daheeh. Tah'ỹỹb mä res'aak karahi me. Tah'ỹỹb sag né hẽ m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ti m' Jesus ky hadoo sa hã: —B'ëëp bë ana, si ỹỹ bë abooh. Tah'ỹỹb sag nado boo da bë hỹỹ kä. Ajyy, ỹỹj sag hadoo da bë hỹỹ kä P'op Hagä Do hã rah'yy ka'eeh hyb n'aa —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ti m' nayyw hẽ m' raberéd hõm karahi. Ah'ũũm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ti bahǟnh mä Jesus bahapäh ajyy Tsijaag, Jowãw daheeh, Sebedew häd näng do taah. Marakate gó m' rabat'oonh, sa yb mä sa hata. Karahi m' renäm. Ti m' Jesus bats'yyt ta sii rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ti m' nayyw hẽ m' ragatsëg n'yyh pong hẽnh. Ti m' raberéd hõm sa yb, marakate. Ti m' Jesus sii rabahõm kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ti m' jé pad'yyt hẽ Garirej häj n'aa bä, tób P'op Hagä Do panyyg rayd naherot do yt hã, Jesus ma metëëk mäh, tamaher'oot mä sa hã P'op Hagä Do ji tabag'ããs do ky n'aa hanäm doo. Jé pad'yyt hẽ m' tabaheso hõm sahõnh hẽ sa nahëëh. Tabaheso hõm na-ããj hẽ h'yyb nahejooj padëëk do nahëë haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ti hyb n'aa, Sirija häd näng do häj n'aa bä na-ããj hẽ raky n'aa napäh mä Jesus mo haj'aa hã. Ti hyb n'aa ramena kän ta wë nahëë enäh doo. Hajõng mä ramenaa do sa nahëëh. Tak'ëp datés do hahoop do ta wób, karap'aar h'yyb nesaa do pahadëëk do ta wób, mera do kaj'uun do ta wób, nabong do ta wób. Ta ti sahõnh hẽ sa nahëë Jesus hahëën hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hajõk mä Jesus jawén hah'ũũm. Ta s'ee hẽnh naa m' hena ta jawén hah'ũũm doo. Garirej häj n'aa bä naa m' ta wób, Dekaporis häd näng do häj n'aa hẽnh naa ta wób, Jerusarẽnh bä naa m' ta wób, Judah häj n'aa bä naa m' ta wób, hëëj Joradãn häd näng do tamyyj däk hẽnh naa m' ta wób kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ti m' hajõk do ta jawén han'aa do Jesus bahapäh bä m', tabasëëk waëë hã m', ti m' tabahyy sooh. Ti m' ta ma metëëk do rabana ta wë, ");
INSERT INTO mbjNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ti m' tadu doo tama metëëk do sa hã. Hahỹỹ d' mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—P'op Hagä Do ky n'aa edëng sa hã hẽ daab na'yyp doo, sa h'yyb gó jããm hẽ P'op Hagä Do hã daab 'yyp doo. Rawén ky n'aa kedëng, hỹ pong jé hawät do bag'ããs do karapee rabahadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Ky n'aa kedëng da jé ha'oot do hah'oop doo, P'op Hagä Do h'yyb en'yym do hyb n'aa da sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—P'op Hagä Do ky n'aa edëng kaja hẽ sa h'yyb mahũũm doo, sa hejój hã h'yy kana'eeh doo. Rawén ky n'aa kedëng, hëëj papuuj P'op Hagä Do ky n'aa enooh do danäh rabahadoo do hyb n'aa da. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—P'op Hagä Do ky n'aa edëng takarẽn doo da ji bawät do hã tak'ëp h'yyb pad'ëëk doo. Rah'yyb pahadëëk do kan'oo däk da sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—P'op Hagä Do ky n'aa edëng ta wób t'yyd mehĩĩn doo. P'op Hagä Do t'yyd mehĩĩn da sa hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—P'op Hagä Do ky n'aa edëng baad hedoo do had'yyt hẽ h'yyb enäh doo. Ky n'aa kedëng da tii, rahapäh do hyb n'aa da P'op Hagä Doo sa matym me. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—P'op Hagä Do ky n'aa edëng h'yyb nyyw gó habok do du n'aa doo. Ta ti hedoo doo ramaneëënh da P'op Hagä Do taah. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—P'op Hagä Do ky n'aa edëng da P'op Hagä Do karẽn do ramoo bok do hyb n'aa rarahejãã do hah'oop doo. Rawén ky n'aa kedëng, hỹ pong jé bag'ããs do karapee rabahadoo do hyb n'aa da. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Ky n'aa kedëng bëëh, hëp ỹ n'aa bë raky n'aa rejã bä, bë rarahejã bä, daap hẽ nesaa do bë ky n'aa ran'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Baad had'op do P'op Hagä Do anoo da bë hã ta säm hỹ pong jé. Ti hyb n'aa da bë h'yy gadejah, bë tsebee da, tii d' bë hã radoo bä né paawä! Tii d' né paa sa wahë makũ rabad'oo P'op Hagä Do ky n'aa rod sa hã, rarahejãã né paa sa hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ti m' Jesus ky hadoo: —Jukiir hadoo bëëh, badäk hahỹỹ hã habong do sa mahang. Jukiir nadah'ëëd wäd bä, dooh ji haja bä ji an'oo bä p'aa hẽnh tadah'ëëd däg bä. Tanadah'ëëd wäd bä, dooh hyb n'aa ji karẽn wät péh. Ji aw'oong hõm tii. Jé tabës pé tsab'eep da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Badäk hahỹỹ hã habong do sa bag hadoo bëëh. Dooh ji haja bä ji jejën bä panang waëë jó badäk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dooh ta bag ji gataa so bä ji waa hood yt hã ji dasooh hyb n'aa. Dooh. Ta bag ji dasooh ta tyng jó, sahõnh hẽ tób yt hã haj'eenh do rabag enä hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ti hadoo ẽnh bë hã. Bë metäh, rabahapäh hyb n'aa, baad hedoo do bë babok doo, baad hadoo do bë moo bok doo, bë Yb hỹ pong jé hawät do hã raj'aa etsë hyb n'aa kä bë hã rahapäh do hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ti m' Jesus ky hadoo: —Ỹ ahyng babä ỹ gawats'iik hyb n'aa nado P'op Hagä Do ky n'aa jaw'yyk doo, P'op Hagä Do ky n'aa rod rerih do paa na-ããj hẽ. Tii d' bë edoo manäh. Ỹ wén hyng P'op Hagä Do ky n'aa jaw'yyk doo, P'op Hagä Do ky n'aa rod rerih do paa na-ããj hẽ, takaja däk hyb n'aa, hã ỹ kametëëh hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Baad bë ỹ maher'oot. Wë, badäk hahỹ hëëj bawät nä bä, P'op Hagä Do ky n'aa jaw'yyk do dooh tagawatsig bä. Dooh ta bód had'os pé gawatsik péh, sahõnh hẽ ta hã kerih do kametëëh bä kä. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Jé P'op Hagä Do ky n'aa jaw'yyk do bód t'aats ky nadaheeh doo, ta wób tama met'ëëg bä ta nemuun raky nadaheeh hyb n'aa, jããm hẽ ky n'aa nets'äs da ta ti hedoo do hỹ pong jé hawät do tabag'ããs do mahang. Jé P'op Hagä Do ky n'aa jaw'yyk do ky daheeh doo, ta wób hã tama met'ëëg bä na-ããj hẽ, ky n'aa etsä däk tii, hỹ pong jé hawät do tabag'ããs do mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—Baad bë ỹ maher'oot. Baad ub Pariséw red'oo raky daheeh P'op Hagä Do karẽn do ji hã. Ti hadoo ẽnh P'op Hagä Do ky n'aa jaw'yyk do ma mehetëk doo. Ti hado né paawä, baad bë nado bä sa bahǟnh, dooh tabad'op hẽ bë haja bä hỹ pong jé hawät do bag'ããs do karapee bë hado bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Bë maa napäh né hẽ p'ooj ub ër wahë makũũ hã kamejũũ doo: “Manaboh manä a da hadoo doo. Nesaa do hã ky n'aa kety däk da jé ta da hadoo do daj'ëëp doo”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ỹỹ kä, ỹ her'oot hahỹ bë hã: Jé ta da hadoo do wë kawajããn do sii hẽ ky n'aa kety däk da. Jé ta da hadoo do ky n'aa rejãã péh, taw'ããts hẽ ër wahë n'aa hedoo do raky n'aa etyy tii. Jé “h'yy gatamaa its õm!”, hanäng pé ta da hadoo do hã, p'eets hẽ tabanesaa hẽnh, tëëg hõõ gó da tabahoop —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Ti hyb n'aa kä, P'op Hagä Do hã mama ejuu bä mahyb n'aa es'ee bä a hã a da hadoo do ganen'aak doo, baad nadoo do ta hã mamoo wät do hyb n'aa, ");
INSERT INTO mbjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tii bä taw'ããts hẽ meréd dó mama ejuu do pan'aa ji ma ejuu do tyng pa. Tii bä ahõm a da hadoo do wë. Mets'ẽẽ õm tahyb n'aa mabaan hyb n'aa, p'aa hẽnh bë h'yyb enyyw padëëk hyb n'aa. Tii bä maju kä P'op Hagä Do wë mamanaa doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Taw'ããts hẽ nayyw hẽ mah'yyb enäw a wë kawajããn doo, hyb n'aa jawyk do wë õm tamahũũm bä õm taky n'aa tapaa hyb n'aa paawä. Bë mahõm me, ta hõõ bä, mah'yyb enäw, hyb n'aa jawyk do ji hã ky n'aa etyy do hã, õm taky n'aa tapa mahǟnh. Tii d' manadoo bä, hyb n'aa jawyk do õm tabahaëënh da warahén hã, õm tadawäts gëët hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dooh d' manä bä kä tii bä, sahõnh hẽ manepaag bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ti m' Jesus ky hadoo ẽnh: —Bë maa napäh hahỹ kamejũũ doo: “Aǟ manä ta seeh ỹỹm sii”, näng kerih do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ỹỹ kä, ỹ her'oot hahỹỹ d' bë hã: Ỹỹnh wë ty gadäk doo, ta sii haỹỹh do hyb n'aa newë däk doo, baad nado däg ta h'yyb tym hã kä. Nesaa do tamoo wäd däg kän, dooh né ta sii taǟ bä paawä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A matym hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä a matym mado nyyh. Madawäts hõm. Taw'ããts hẽ sét a hã hanäng do kaw'oong hõm, tabanesaa hẽnh õm P'op Hagä Do aw'oong hõm mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A moo hub hadäk do hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä magakyd hõm a mooh. Madawäts hõm. Taw'ããts hẽ sét a hã hanäng do kaw'oong hõm, tabanesaa hẽnh õm P'op Hagä Do aw'oong hõm mahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Hahỹỹ da kamejũũ do paah: “Jé ta ỹỹm heréd hõm doo, taw'ããts hẽ taban'oo däk né hẽ ta heen n'aa kerih do ta hã”, näng kerih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ỹỹ kä, ỹ her'oot hahỹỹ d' bë hã: Jé daap hẽ ta ỹỹm heréd hõm doo, ta ỹỹm wadii do hyb n'aa tanado bä, ỹỹnh ta patug nadoo do sii he'ỹỹh do hado däk tan'oo bä ta ỹỹm paah. Aj'yy see gat'ëë däg bä ta ti ỹỹnh, nesaa doo, P'op Hagä Do ganadoo do tamoo wät. Ta see ỹỹm sii he'ỹỹh do hado däk tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Bë maa napäh né hẽ p'ooj ub ër wahë makũũ hã kamejũũ doo: “Maky kahỹỹd manä Tak'ëp Hyb N'aa Jawyk Do hã maky däng doo. Mamoo wäd né hẽ ta hã maky däng doo”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ỹỹ kä, ỹ her'oot hahỹỹ d' bë hã: Bë ky dëë manä da. P'op Hagä Do bag'ããs do tyng hadoo hỹ pong jé. Ti hyb n'aa bë ky dëë manä hỹ pong jé hã, bë ehub né hẽ bë ky däng do bë metëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","P'op Hagä Do tsyym tyng hadoo badäk hahỹ hëëj. Ti hyb n'aa, bë ky dëë manä badäk hahỹ hëëj hã, bë ehub né hẽ bë ky däng do bë metëëh hyb n'aa. Bë ky dëë manä Jerusarẽnh panang hã, bë ehub né hẽ bë ky däng do bë metëëh hyb n'aa. P'op Hagä Doo, sahõnh hẽ bag'ããs do panang ti Jerusarẽnh. Ta ma tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bë ky dëë manä bë nuu hã. Dooh ji haj'as pé ji hã hẽ ji ahỹỹd bä. Ji sëën na-ããj hẽ dooh ji haja bä ji ahỹỹd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ti hyb n'aa kä, “ỹỹ” bë noo bä, taw'ããts hẽ “ỹỹ” né hẽ bë h'yyb gó. “Dooh” bë noo bä, “dooh” né bë h'yyb gó. Jããm ti bë kyyh. Dooh hyb n'aa tak'ëp bë ky n'aa h'ũũm pé bë metëëh hyb n'aa ta ti bë ehub né hẽ. Nesaa Do Yb hanaa sahõnh hẽ ti bahǟnh tak'ëp ky n'aa h'ũũm doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ti m' Jesus ky hadoo ẽnh: —Bë maa napäh né hẽ hahỹ kamejũũ doo: “Ta da hadoo do matym rejãã doo, ta ti mo haj'aa näng do matym na-ããj ji rejãã. Ta da hadoo do tëg see gatëh hõm doo, ta ti mo haj'aa näng do tëg see na-ããj hẽ ji rejãã”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ỹỹ kä, ỹ her'oot hahỹỹ d' bë hã: Bë mahũũm manä hyb n'aa jewyk do sa wë nesaa do bë hã moo wät doo, tamoo wät do säm tagadoo hyb n'aa paawä. Õm rapa ewyh bä manu mebyng hyb n'aa paawä, mamabaaj manäh. Man'oo a ta pa s'ee hẽnh rabewyyh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hyb n'aa jewyk do sa wë a da hadoo do õm taky n'aa tapa bä a saroor hyb n'aa, man'oo ta hã a hatsë a hã hadäk do na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Õm ramejõ bä sa ma mas'ëëd bä raky n'aa jaw'yyk do anoo do pénh, tii bä mamahǟj manä ta ti ramejũũ doo. Taw'ããts hẽ raky däng do bahǟnh mas'ëëd. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Man'oo a da hadoo do ets'ẽẽ bä a hã. A h'ëëd see a da hadoo do ets'ẽẽ bä tab'aanh doo, man'oo né hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ti m' Jesus ky hadoo ẽnh: —Bë maa napäh né hẽ hahỹ ramejũũ do paah: “Makamahǟn a da hadoo doo. Mahyb n'aa wareem a majĩĩ.” ");
INSERT INTO mbjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ỹỹ kä, ỹ her'oot hahỹỹ d' bë hã: Bë kamahǟn bë majĩĩ. Bë ky n'aa ets'ẽẽ bë hã rejãã doo, ");
INSERT INTO mbjNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bë Yb hỹ pong jé hawät do taah né bëëh, bë metëëh hyb n'aa ta tii hã. Bë Yb hỹ pong jé hawät do anoo papỹỹj bag tapahuunh doo, baad habok do sa hã, baad nabok do sa hã na-ããj hẽ. Baad habok do rababong bä tabanoo naëng badoos hyb n'aa, baad nabok do rababong bä na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bë gadoo bë ed'oo g'eeh hanäm do P'op Hagä Do hanaa, jããm né hẽ bë kamahǟn bä bë hã kamahǟn doo? Dajẽẽr Roma buuj hã ji hepak do taa n'aa, bë ty n'aa ges'yyk doo, ti na-ããj rakamahǟn sa hã kamahǟn doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jããm hẽ bë wakããn hedoo do bë edëë bä, ta wób bad'oo do bahǟnh nado bë bad'oo. Jé P'op Hagä Do sa h'yyb gó nahapäh do na-ããj né hẽ redëng sa wakããn, sa najiis. ");
INSERT INTO mbjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ti hyb n'aa, taw'ããts hẽ baad had'yyt hẽ bë babok, bë Yb hỹ pong jé hawät do baad had'yyt hẽ tabawät doo da —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ti m' Jesus ky hadoo: —Baad hedoo doo, P'op Hagä Do karẽn do bë moo bok bä, taw'ããts hẽ bë moo boo bë raj'aa etsë hyb n'aa nado. Baad hedoo do bë moo boo bä bë hã raj'aa etsë hyb n'aa, ti bä dooh bë gado wäd bä hanäm do ta säm bë Yb hỹ pong jé hawät do hanaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Ti hyb n'aa kas'uut do matym n'aa mabanoo bä, magamehǟ manä torõm-bet, õm ramanatakëë hyb n'aa, j'ooj madäk doo me ky ken'yym do rabahed'oo doo da panang tyw n'aa bä, tób P'op Hagä Do panyyg rayd naherot do yt hã, sa hã ta wób raj'aa etsë hyb n'aa. Baad bë ỹ maher'oot: Ta ti hedoo doo, sa hã raj'aa etsë doo me né hẽ ragado däk ta säm. Dooh ragado wäd bä hanäm do P'op Hagä Do hanaa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kas'uut do matym n'aa mabanoo bä, maher'ood manä ta wób sa hã, ");
INSERT INTO mbjNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta wób ranahapäh hyb n'aa mamasa doo. Tii bä kä, a Yb hỹ pong jé hawät doo, hapäh do ranahapäh bä manoo doo, anoo da a hã ta säm baad hadoo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Bë ky n'aa ets'ẽẽ bä, j'ooj madäk doo me ky ken'yym do rabahed'oo doo da bë adoo manä da. Panang tyw n'aa kajatsëk bä, hajõk do rababok bä, tób P'op Hagä Do panyyg rayd naherot do yt hã na-ããj ti ragen'aak raky n'aa etsẽẽ rabë bä, ta wób rabahapäh hyb n'aa. Baad bë ỹ maher'oot: Ta ti hedoo doo, sa hã raj'aa etsë doo me ragado däk ta säm. Dooh ragado wät pé hanäm do P'op Hagä Do hanaa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ti hyb n'aa, maky n'aa ets'ẽẽ bä, ajëë suun a tób gawakõ gó, manoo gatsëë däg ta gawakõ, ti bä maky n'aa ets'ẽẽ a Yb, hỹ pong jé hawät do ji nahapäh do hã. Tii bä kä, a Yb hỹ pong jé hawät doo, kejën doo gó maky n'aa etsẽẽ do hapäh doo, anoo da a hã ta säm baad hadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bë ky n'aa ets'ẽẽ bä, bë ky n'aa jebaaj manä bë etsẽẽ doo, P'op Hagä Do sa h'yyb gó nahapäh do rabahed'oo doo da. Rah'yy kaha'eeh do maa napäh raky n'aa etsẽẽ doo, hajõng do sa kyyh hyb n'aa red'oo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bë ky n'aa ets'ẽẽ pooj jé bë Yb hapäh bë wë badoh doo. Ti hyb n'aa bë ky n'aa ets'ẽẽ manä nanäng raky n'aa etsẽẽ doo da. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Taw'ããts hẽ hahỹỹ da d' bë kyyh bë ky n'aa ets'ẽẽ bä: “Ee, hỹ pong jé hawät doo, ãã karẽn sahõnh hẽ õm rahyb n'aa jew'yyk. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ãã etsẽẽ a hã, sahõnh hẽ mabag'ããs do nayyw hẽ takajaa hyb n'aa ãã wë. Ãã karẽn sahõnh hẽ badäk hahỹỹ hã habong do ramoo bok makarẽn doo, hỹ pong jé ramoo bok doo da makarẽn doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Man'oo had'yyt hẽ ãã waa. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mamabaan hõm nesaa do ãã moo bok do paah, ãã mabaan hõm doo da ãã wë moo bong do nesaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Man'oo manä nesaa do ãã tah'yyb tatuk. Ãã mamo n'aa jesu Nesaa Do Yb mahǟnh. Õm né ti sahõnh hẽ bagãã had'yyt doo. Õm né ti hejooj had'yyt doo. Õm né ti ji j'aa etsëë had'yyt doo. Ti né hẽ. Taw'ããts hẽ”, näk da bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ti m' Jesus ky hadoo ẽnh: —Bë hyb n'aa mabaan bä nesaa do bë wë ramoo boo bä, tii bä bë Yb hỹ pong jé hawät do hyb n'aa mabaan da na-ããj hẽ bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bë hyb n'aa manabaan bä nesaa do bë wë ramoo bok doo, tii bä dooh na-ããj hẽ bë Yb hyb n'aa mabaan bä bë hã nesaa do bë moo bok doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ti m' Jesus ky hadoo: —P'op Hagä Do bë weh'ëëh hyb n'aa bë kas'aah bä, bë metä manä bë h'yy gajëng doo, j'ooj madäk doo me habok doo, ky ken'yym do gó habok do rabahed'oo doo da. Ta ti rah'ỹỹt sa mamets rakas'aah ta wób rabahapäh hyb n'aa. Baad bë ỹ maher'oot: Ta ti hed'oo doo, sa hã raj'aa etsë doo me, ragado däk ta säm sahõnh hẽ. Dooh ragado wät pé hanäm do P'op Hagä Do hanaa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ti hyb n'aa, kas'aah doo me P'op Hagä Do maweh'ëëh bä, taw'ããts hẽ mahetsyyd a mamets, mahawug ta syyj buu benyym do a nuu gó ji bahed'oo doo da ");
INSERT INTO mbjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kas'aah doo me P'op Hagä Do maweh'ëëh do ta wób ranahapäh hyb n'aa. Jããm hẽ a Yb, hỹ pong jé hawät doo, ji nahapäh do hapäh hyb n'aa. Tii bä kä, a Yb hỹ pong jé hawät doo, kejën doo gó makas'aah do hapäh doo, anoo da a hã ta säm baad hadoo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ti m' Jesus ky hadoo ẽnh: —Bë ata manä bë ma takah'ũũm hyb n'aa badäk hahỹỹ bä, kamera hedoo do ji ma rejãã doo bä, ji ma hetõt bä, hets'ëëk do bë tób ranoo eë hõm doo bä bë ma rabets'ëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Taw'ããts hẽ bë moo boo had'yyt hẽ ti P'op Hagä Do bë hã takarẽn doo. Tii bä da bë gadoo da hỹ pong jé ta säm P'op Hagä Do hanaa. Hỹ pong jé dooh kamera hedoo do rejã bä ta säm P'op Hagä Do hanaa ji gadoo doo. Ta tii bä dooh tahetõd bä ta säm, ta tii bä dooh retsëëg bä P'op Hagä Do hanaa ji gadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta tii d' ỹ wén her'oot, tak'ëp bë kamahǟn do banäng bä, tii bä bë h'yyb bawät —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Ji bag hadoo ji matym. Baad tado bä ji matym, ta bag hado däk sahõnh hẽ ji hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Baad tanado bä ji matym, badagyp hadoo sahõnh hẽ ji hã. Ti hyb n'aa, ta bag hadoo bë hã hanäng do paawä, badagyp do tado bä, tak'ëp tabadagyp tii bä bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Dooh hajaa pé pawóp hẽ ta kariw n'aa sii moo wät pé séd noo gó. Tii d' tahado bä, ta kariw n'aa see dooh takamahǟn bä, ta see ti takamahǟn. Ta see wë da baad tamoo wät da, ta see taty n'aa ges'yyk da. Ti hadoo bë hã. Dooh bë haja bä bë h'yy keséj bä. Dooh bë haja bä P'op Hagä Do hã bë h'yyb däg bä, dajẽẽr hã na-ããj bë h'yyb däng bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Ti hyb n'aa bë ỹ maher'oot hahỹỹh: Bë hyb n'aa tón had'yyt manä bë babok do hã, bë waa hã, bë eëëk do hã, bë saroor hã. Tii d' ỹ wén edoo, ji awa do bahǟnh ti ji edëp doo. Ji saroor bahǟnh ji. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bë hegãã taw'ëëd. Dooh rejoom bä joom tym. Dooh rata bä joom ag sa waa tób n'aa yt hã. Ti hado né paawä, P'op Hagä Doo, bë Yb, anoo sa waa. Taw'ëëd P'op Hagä Do kamahǟn do bahǟnh bë takamahǟn. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tak'ëp bë hyb n'aa newë had'yyt né paawä, dooh bë haja bä bë aboo dawëd bä ta tii da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Hëd n'aa bë hyb n'aa tón bë saroor bë padedëëk do pan'aa hã? Bë hegãã tabawä n'aa ts'ooh joom banäng bä hawäng doo —näng mäh. —Dooh né paawä ramoo boo bä, dooh né paawä sa saroor rages'yyb bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Saromãw saroor anyyw né paawä, gabar'ëëng né paawä, ti bahǟnh tabanäm ti tabawä n'aa ts'ooh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tii da baad ub P'op Hagä Do adoo bä tabawä n'aa hã, nayyw hẽ tsawyy jëng do hã, ji gatang do hã, dooh g'eeh ti bahǟnh baad ub tabahag'ããs bëëh? Tanoo né da bë hã bë saroor. H'ëëd hyb n'aa P'op Hagä Do hã baad bë h'yy kana'eeh? ");
INSERT INTO mbjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ti hyb n'aa kä, bë hyb n'aa tón manäh. “H'ëëd g'ee d' ãã awa? H'ëëd g'ee d' ãã eëëk? H'ëëd g'ee d' ãã dadäk?”, bë an'oo manäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","P'op Hagä Do sa h'yyb gó nahapäh do ti tii, ti hã h'yyb padëëk doo. Bë ti dooh tii d' bë adoo bä. Bë Yb hỹ pong jé hawät do hapäh bë wë bedoh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Taw'ããts hẽ pooj jé baad bë h'yyb padäg bë Yb bag'ããs do hã, baad hedoo do ji hã takarẽn do hã na-ããj hẽ. Tii bä kä, tanoo da bë hã sahõnh hẽ bë wë bedoh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ti hyb n'aa kä, naga hẽ bë hyb n'aa tón manä bë pooj jé hawät do hã. Jat'iip hadoo na-ããj hẽ ti anäng ji h'yy katón doo. Ti hyb n'aa taw'ããts hẽ jati pé bë hyb n'aa newë nyy d' bë bad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ti m' Jesus ky hadoo: —Baad nadoo do hã bë ky n'aa ety manä had'yyt hẽ ta wób, P'op Hagä Do ky n'aa netyy hyb n'aa bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tii d' ỹ wén edoo, ta wób bë ky n'aa etyy doo da, bë da P'op Hagä Do ky n'aa etyy. Ta wób bë ky n'aa etyy do pénh, ti pénh da P'op Hagä Do ky n'aa etyy da bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Hëd n'aa mamatakëë b'aa hyyj its a da hadoo do matym me hahop doo, b'aa haeh do a matym gó anäng? ");
INSERT INTO mbjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hëd n'aa, “Na b'aa hyyj a matym gó hatu do ỹ ado hõm”, mabanäng, dooh b'aa haeh do mamatakä bä a matym gó hanäng doo? ");
INSERT INTO mbjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","J'ooj madäk do ti a h'yyb. Mado nä pooj jé b'aa haeh do a matym gó hakëë doo. Tii bä da mabahapäh baad ub mabado hõm hyb n'aa a da hadoo do matym gó hatu do b'aa hyyj —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Bë an'oo manä awaar hã tsyt hẽ P'op Hagä Do wë kasëëw däk doo. Bë da regës. Bë an'oo manä too yb hã majoor gabarëëh do perora häd näng do s'ëëb. Ratsab'eep da bë majoor —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ti m' Jesus ky hadoo: —Bë ets'ẽẽ, tii bä P'op Hagä Do anoo bë hã. Bë esóts, tii bä bë aw'yyt da. Bë naëëj tób noo bä naa, tii bä da ta danäh noo gas'ëës. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jé hetsẽẽ doo, gadoo da P'op Hagä Do hanaa. Jé hesoos péh, taw'yyt P'op Hagä Do hanaa. Jé tób noo bä naa naëënh péh, tób noo kas'ëës da ta hã P'op Hagä Do hanaa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Pãw bë t'aah ets'ẽẽ bä ta waa, pä bë anoo g'eeh ta hã? ");
INSERT INTO mbjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tah'ỹỹb bë hã tets'ẽẽ bä ta tä, aw'yy g'eeh bë anoo ta hã? Dooh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nesaa do moo heb'ook do né paawä bëëh, baad hadoo do bë heno bë taah hã. Ti bahǟnh bë Yb hỹ pong jé hawät do anoo da baad hadoo do ta hã hetsẽẽ do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Ti hyb n'aa kä, sahõnh hẽ bë bad'oo do hã, bë moo boo ta wób sa hã baad hadoo doo, bë karẽn do bë hã ramoo bok doo. Tii d' tahanäng pé P'op Hagä Do ky n'aa jaw'yyk do hã, P'op Hagä Do ky n'aa rod rerii bong do hã kerih doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ti m' Jesus ky hadoo sa hã: —Noo maeh ta tyw n'aa, maeh ta tyw n'aa banesaa hẽnh, ji karejãã doo hẽnh hahõm doo. Hajõk maeh doo me hah'ũũm. Ti hyb n'aa, taw'ããts hẽ bë majëë suun noo nad'ëëd is do hadoo doo me P'op Hagä Do wë, ji edëb had'yyt doo hẽnh ji tamahũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Noo manad'ëëd its, manad'ëëd its ta tyw n'aa ji edëb had'yyt doo hẽnh hahõm doo. Dooh tahajõõ bä ta ti ta tyw n'aa haw'yyt doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ti m' Jesus ky hadoo: —Baad bë hyb n'aa matakä, P'op Hagä Do ky n'aa rod oow bë rawanadii hyb n'aa. B'éé anyyw is do hadoo kawanajããn do hadoo da rababok bë mahang. J'ooj madäk doo me tii. T'õp, sa h'yyb gó, tabanas'aa b'éé hek'ook do hadoo tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ramoo bok do hã, raher'oot do hã na-ããj hẽ bë da h'yy genäh sa hã, joom ag hã ji bahapäh do hadoo joom ỹỹn hã. Dooh ji awyyd bä uwa ag sasëng tëëg hedoo do hã. Dooh na-ããj hẽ ji awyyd bä wiigo ag hetëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Joom baad hadoo doo, baad ub ta ag. Joom seeh, baad nadoo doo, ta hẽnh hẽnh ta ag hahõm, dooh baad hadoo do ta ag. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Joom baad hadoo doo, dooh teag bä baad nadoo doo. B'aa p'yym näng doo, dooh tahaja bä baad hadoo do teag bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","B'aa baad nadoo do heaak doo, ji agëëm, ji tëëg hado däk tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Joom ag hã bë hapäh doo da ta ỹỹn, ti hadoo da, ramoo bok do hã, rababok do hã bë da h'yy genäh P'op Hagä Do ky n'aa rod oow sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Dooh sahõnh hẽ “Tak'ëp Hyb N'aa Jawyk Doo”, ỹ ramaneëënh doo, hỹ pong jé hawät do bag'ããs do karapee rabahadoo da. Jããm hẽ Yp ỹ hỹ pong jé hawät do karẽn do moo b'ook doo, ta bag'ããs bä tagadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sahõnh hẽ P'op Hagä Do ky n'aa etyy noo gó, hahỹỹ da hajõk do sa kyyh hã ỹỹ: “Tak'ëp Hyb N'aa Jawyk Doo, a kyy gó nado g'eeh a ky n'aa ãã baher'oot? A kyy gó nado g'eeh karap'aar h'yyb nesaa do sa hã padëëk do ãã habëë hõm? A kyy gó nado g'eeh hajõng ãã pehuunh doo?”, näk da. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tii bä kä, hahỹỹ da da këh ỹ sa hã: “Dooh noo gó bë ỹ hapëë bä. Bë anä matym ỹỹ gó naa, nesaa do moo heb'ook doo!”, näng da këh ỹ sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Ti hyb n'aa kä, hahỹ këh ỹ maa newëë doo, ky daheeh doo, aj'yy h'yy ganäng do hadoo, tababang bä, pä banäng bä, ta tób tatamaa sooh do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Adots né paawä naëng, tamii agyyb né paawä ta tób hã, bah'ood ahëm né paawä ta hã, dooh tatë hyy bä, tababang bä ta tób tu n'aa baad tabejëh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Këh ỹ maa newëë doo, ky nadaheeh doo, aj'yy h'yy gatamah do hadoo, hood jó ta tób tatamaa sooh do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Adoos naëng, ag'yyp tamii ta tób hã, bah'ood ahëm ta hã. Tii bä tabatë hyng. Sahõnh hẽ takarejãã ta tób —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ti m' Jesus bahajaa bä sahõnh hẽ ta ti taher'oot doo, maa new'ëë do rahyb n'aa meuunh mä tama metëëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Rawén meuuj bong mä tama metëëk mä hyb n'aa jawyk do ky n'aa me. Sa ma matëg, Mosees ky n'aa jaw'yyk do ma mehetëk do rama metëëk doo da nahado m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ti m' waëë bä naa Jesus bahyng bä kä hajõk mä had'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ti m' aj'yy rog manahuuh do ana mä ta wë. Ti m' tabahyy häng mä ta taron nu paa me, ti m' taky hadoo mä Jesus hã: —Wahëh ỹ n'aa, —näng mäh —makarẽn bä tii, mahajaa né hẽ nahäh ỹ mado hõm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ti m' Jesus moo däg ta hã. Ti m' taky hadoo: —Ej. Ỹ karẽn —näng mäh. —Has'oo däg! —näng mä ta kyyh. Ti m' nayyw hẽ kä m' ta nahëë badoo wät. Has'oo däg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ti m' Jesus baher'oot ta hã: —Maher'ood manä ta wób sa hã —näng mäh. —Ahõm jajé naga hẽ P'op Hagä Do tób n'aa yt hã moo wät do wë. Mametä ta hã õm has'oo däk doo. Mamoo wäd Mosees mejũũ do paah, ta ti hedoo doo pé ji nahëë badoo wät do heen n'aa, õm has'oo däk do baad sahõnh hẽ rabahapäh hyb n'aa —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ti m' panang Kapar-Naũm häd näng doo bä Jesus kajaa bä kä, Roma buuj warahén n'aa sa wahë n'aa see ana kän ta wë, ta karom Jesus masa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ti m' Jesus hã taky hadoo: —Tak'ëp Hyb N'aa Jawyk Doo, —näng mäh —tak'ëp karom ỹ nahëë näng. Ti asooh tób hẽnh. Dooh tahaja bä tawäd wäd bä. Tak'ëp tabahoop —näng mä warahén. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ti m' Jesus ky hadoo: —Taw'ããts hẽ. T'ĩĩ hẽnh ỹ bahõm ỹ bahaso däk hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ti m' warahén wahë n'aa ky hadoo: —Wahëh ỹ n'aa, hã ỹỹ, ỹ hyb n'aa sakog its a hã, tóp ỹỹ gó mabajëë suun hyb n'aa. Taw'ããts hẽ babä naa mamejũũ ta nahëë hã, tii bä karom ỹ bahas'oo däk da. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tii d' ỹ wén edoo, ỹ na-ããj né hẽ ỹ ky daheeh wahëh ỹ n'aa ramejũũ do ỹỹh. Ỹ na-ããj hẽ warahén ỹ n'aa ỹ mejũũ, ỹ raky daheeh. Ta see ỹ mejõ bä, “Ahõm”, ỹ noo bä, ahõm né hẽ. Ta see ỹ mejõ bä “Ana”, ỹ noo bä, ana né hẽ. Karom ỹỹ ỹ mejõ bä, “Hahỹ mamoo wäd”, ỹ noo bä, ỹ taky daheeh né hẽ —näng mä warahén kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ti m' Jesus hyb n'aa meuunh mä warahén her'oot do tamaa napäh bä. Ti m' taky hadoo hajõk do ta sii han'aa do hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: P'op Hagä Do hã rah'yy ka'eeh sa noo né paawä, dooh ỹ hapäh nä pé Isaraéw buuj sa mahang tak'ëp hã ỹ h'yy ka'eeh do hahỹ aj'yy, Isaraéw buuj nadoo do h'yy ka'eeh do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Baad bë ỹ maher'oot hahỹỹh: Badäk hahỹỹ hã jé pad'yyt hẽ naa rabena da hỹ pong jé hawät do bag'ããs doo bä ratsebé do jäm n'aa tyng n'aa jó rabat'oonh hyb n'aa Abaraãm, Isak, Jakóh sa sii. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ti nuuj jé, pooj jé kats'yyt do ta karapee rabahadoo hyb n'aa paawä, kaw'oong bong da ta w'oo hã, gadagyp doo bä. A'oot da tii bä. Sa tëg kamegëëj däk da tak'ëp nesaa do rahoop do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ti m' warahén hã Jesus ky hado kän: —Abaaj hõm. Mah'yy ka'eeh do hyb n'aa metsẽẽ do ỹ moo wät —näng mäh. Ti m' ti noo gó né hẽ ta karom bahas'oo däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ti m' Peed tób bä Jesus bajëë suun bä, tahapäh mä Peed mayyn hasooh doo. Oom ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti m' Peed mayyn moo hã tamoo däng, ti m' nayyw hẽ oom keréd hõm. Ti m' tabas'ëëg gëët, ti m' tamoo wäd däk Jesus waa. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tug bä kä m', ramenaa ta wë hajõk karap'aar h'yyb nesaa do pahadëëk doo. Ti m' karap'aar h'yyb nesaa do tahebëë bong, ta ky haj'aa. Nahëë enäh do ahub padëëk mä Jesus an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tii da tawén d'oo hahỹ P'op Hagä Do ky n'aa rod Isajas häd näng do her'oot do paa takaja däk hyb n'aa: “Ãã tedëëb wät ãã h'yyb nahejoonh do mahǟnh. Tado hõm ãã nahëëh”, näng paa Isajas. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ti m' hajõk do ta w'oo hã kat'aa do Jesus bahapäh bä kä, taky hadoo mä tama metëëk do sa hã: —Hamäh, ër atsëg hõm karaj'aa tamyyj jé —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do see ky hadoo ta hã: —Ma matëg, —näng mäh —õm ỹ hadaa had'yyt hẽ mahahõm hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ti m' Jesus ky hadoo ta hã: —Kanari tób näng, taw'ëëd maag enäh. Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, dooh tóp ỹỹ pé ỹ yd kameh'ããk péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ti m' Jesus sii hawät do see ky hadoo ta hã: —Õm da ỹ hada. Pooj jé dó ỹ abaaj hõm Ee wë ỹ bahag'ããs hyb n'aa. Tadajëp jawén paa bä kä, ỹ dakä jëng jawén paa bä kä õm ỹ bahadaa kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ti m' Jesus ky hadoo ta hã: —Na hã ỹ h'yy kana'eeh doo, dejëp do hadoo doo, dakëë sa da hadoo doo —näng mäh. —Õm tii, ỹ mahadaa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tii kä, Jesus gatsëg so kän marakate gó, karaj'aa tamyyj jé rabatsëg hõm hyb n'aa. Ta sii m' ta ma matëg ragatsëg tooj kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ti m' nayyw hẽ m' bah'ood bana kän tak'ëp. Tewëëp mä maadaka. Marakate m' tetaa m'. P'eets mä marakate bagyyb jëë paawä. Jesus mä aǟ sooh ti nuuj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ti m' ta ma matëg ramebëë nyyh, ti m' raky hadoo: —Tak'ëp Hyb N'aa Jawyk Doo! Ãã medëëb! Ër da ag'yyp! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ti m' taky hadoo sa hã: —Hëd n'aa tak'ëp bë beỹỹm? Kanahën d'os hẽ ub h'yy ka'eeh do bëëh! —näng mäh. Ti m' tabas'ëëg gëët, ti m' bah'ood, maadaka tameduuk. Ti m' bah'ood badoo wät. Badatih däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ti m' tak'ëp rameuuj bong bä m' raky hadoo: —Ny hadoo do aj'yy ti hỹỹ eh? Bah'ood, maadaka sii hẽ raky daheeh! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ti m' karaj'aa tamyyj jé, Geras buuj sa häj n'aa bä rakajaa bä kä, pawóp hẽ ajyy mera doo, karap'aar h'yyb nesaa do pahadëëk do ramamuun Jesus. Kamag pä gó naa m' rabana. Tak'ëp rakawajããn do hyb n'aa, dooh m' t'ĩĩ hẽnh tabës péh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ti m' tak'ëp mä sa kyyh: —H'ëëd makarẽn ãã wë, P'op Hagä Do T'aah? P'op Hagä Do ky däng do ji tarejãã do pooj jé makarẽn ãã marejãã? —näk mä mera do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hajõng mä too yb dawë péj habëëh. Sa waa rabahew'aa tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ti m' karap'aar h'yyb nesaa do rabetsẽẽ Jesus banoo hyb n'aa rabajëë pëë too yb hã. Hahỹỹ d' mä sa kyyh: —Ãã mahabëë nä bä, man'oo ãã bajëë pëë too yb hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ti m' Jesus ky hadoo: —Bë anäh! —näng mä Jesus sa hã. Ti m' karap'aar h'yyb nesaa do benä kän ajyy sa hã hanäng do paah, too yb hã m' rabajëë pä kän. Ti m' too yb rapah'uud bong, rameraa bong, ti m' rawaj'aa wëënh tame wajapëm doo hẽnh, tame m' rakejäg bëënh. Ti m' t'õp mä rapehǟs. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti m' too yb hagã n'aa rawaj'aa jëk panang hẽnh. T'ĩĩ hẽnh ramaher'oot mä sahõnh hẽ rahapäh doo, ajyy karap'aar h'yyb nesaa do pahadëëk do paa sa ky n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ti m' sahõnh hẽ panang buuj rabana Jesus rabaheg'ããs hyb n'aa. Ti m' Jesus rabahapäh bä m', rabetsẽẽ ta hã tabahõm hyb n'aa sa häj n'aa bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ti m' Jesus gatsëg sooh marakate gó, ti m' ta panang hẽnh, karaj'aa tamyyj jé tabatsëg hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ti m' ajyy wób ramanaa mä nahëë näng doo, nawät doo, ratóg nä ta tyng jó. Ti m' Jesus h'yyb hapäh bä m' hat'ook do rah'yy ka'eeh do ta hã, taky hadoo nawät do hã: —Mahyb n'aa tón manäh, tah ỹỹ. Nesaa do a h'yyb tym gó hanäng do kado hõm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do raky hadoo sa h'yyb gó: —P'op Hagä Do taky n'aa rejãã hahỹỹ hã —näk mä sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus h'yyb hapäh mä sa h'yyb, ti hyb n'aa m' taky hadoo sa hã: —Hëd n'aa nesaa do bë hyb n'aa newëë bë h'yyb gó? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Nyy da nahejooj bë hã? “Kado hõm nesaa do a h'yyb tym gó hanäng do paah”, ji noo bä? “As'ëëg g'ëëd, awäd däg”, ji noo bä? ");
INSERT INTO mbjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hỹỹ kä da, —näng mäh —bë bahapäh hyb n'aa ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ hajaa sa h'yyb gó hanäng do nesaa do ỹ ado hõm bä, ỹ haso däk da nahëë näng doo —näng mä Jesus kyyh. Tii bä m' k'yy gadów däk do hã taky hadoo: —As'ëëg g'ëëd, mado däg a tyng, ahõm kä a tób hẽnh —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti m' tabas'ëëg gëët, ahõm kän mä ta tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sahõnh hẽ hap'ëëh do rameuuj bong mäh. P'op Hagä Do hã raj'aa etsë, ta ti hadoo do hejój ajyy sa hã tabanoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ti m' tii b' n'aa Jesus bahõm bä kä, tabahapäh Matew häd näng doo, sa wahë n'aa Roma buuj ky gabuuj dajẽẽr tagahed'aak bä hasooh doo. Ti m' Jesus ky hadoo ta hã: —B'ëëp ana wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa —näng mäh. Ti m' Matew bas'ëëg gëët, ahõm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ta jawén, Matew tób bä Jesus bawëh bä m', hajõk dajẽẽr gahed'aak doo, Matew hep'ëëh doo, ta wób sa hã pé nesaa do moo heb'ooh do na-ããj hẽ rabana rabawëh hyb n'aa Jesus sii, Jesus ma matëg sa sii. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ti m' Pariséw rabahapäh bä ta tii, rabeaanh Jesus ma matëg sa hã: —Hëd n'aa bë ma matëg bawëh dajẽẽr gahed'aak do sa sii, ta wób na-ããj hẽ nesaa do moo heb'ooh do sa sii? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ti m' reaanh do Jesus maa napäh bä, panyyg gó taky gadoo: —Nahëë temah doo, dooh rahõm bä mediko wë. Nahëë enäh do ti hah'ũũm ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Taw'ããts hẽ baad bë hyb n'aa newë nyy da P'op Hagä Do hanäng pé hahỹỹ da ta kyy kerih doo gó taher'oot do hã: “Dooh rama ejuu do had'yyt hẽ tado bä ti ỹ karẽn doo. Ỹ gahëën sa hã, rat'yyd mehĩĩn sa da hadoo doo”, näng kerih doo. Ti m' Jesus ky hado kän: —Dooh ỹ ahyy bä hỹ pong jé naa P'op Hagä Do karẽn doo da habok red'oo do ỹ naëënh hyb n'aa. Ỹ ahyng, nesaa do moo heb'ooh do ỹ naëënh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ti m' Jowãw nu gahem'uun do ma matëg rabana Jesus wë, ti m' reaanh ta hã: —Ta see pé noo gó ããh, Pariséw na-ããj hẽ, noo kanawa doo me ãã weh'ëëh P'op Hagä Doo. Hëd n'aa a ma matëg tii d' ranad'oo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ti m' panyyg ky n'aa gó Jesus ky gadoo. Hahỹỹ d' mä ta kyyh: —Ket'ëë do jäm n'aa hẽnh ji ats'yyt doo, dooh ratabëëj bä rahyb n'aa tón do heen n'aa ta patug pan'aa sa mahang tag'ëëd bä. Ti awät da ti noo gó sa najiis, ta patug pan'aa, rado hõm sa mahǟnh. Ti noo gó da ratay kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ti m' panyyg wób ky n'aa gó Jesus ky gadoo nä reaanh doo. Hahỹỹ d' mä ta kyyh: —Dooh ji gas'yyb bä pããn papuuj bäh me saroor säg noo eh doo. Tii d' ji adoo bä, papuuj bäh tsawyy däg bä, ta säg tanes'ëëm, kawah'oob hõm tii bä. Ti bahǟnh tanoo ee däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ti hadoo né hẽ uwa bëë hã. Dooh ji gedu bä uwa bëëh papuuj hegän sooh do pan'aa ta hood b'éé byy säg gó. Tii d' ji adoo bä, uwa bëëh egän so bä, ta hood säg ganabäh hõm. Tii bä kä, uwa bëë waho bëëh da, ta hood kä karejã kän —näng mäh. —Uwa bëëh papuuj ji geduuh ta hood papuuj gó. Uwa bëëh egän so bä, ta hood papuuj keh'ũũs nä. Tii bä uwa bëëh, ta hood na-ããj hẽ dooh takarejã bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ti m' ta ti Jesus baher'oot nä bä, aj'yy hyb n'aa jawyk doo, Judah buuj sa wahë n'aa see ana Jesus wë. Ti m' ta taron nuu me m' tabahyy häng ta wë. Ti m' taky hadoo ta hã: —Tok ỹ h'yy gakog hõm —näng mäh. —Ti hadoo né hẽ b'ëëp si ỹỹ, ta hã moo dëë, tii bä da tok ỹ awäd däk da p'aa hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ti m' Jesus ta ma matëg daheeh rabahõm kän ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tamahõm me m' ỹỹnh nahëë näng do ta jó gadäk hẽnh tabana ta wë. Majyyw mä ta nahëëh. 12 m' ta baab ta nahëë badäk. Ti m' ta jó gadäk hẽnh mä tabana ta wë, Jesus saroor noo hã m' tamoo däng. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tii d' tawén d'oo mä ta h'yyb gó m' taky hadoo: “Ta saroor hã ỹ moo dëë bä, ỹ d' ahub däk tii bä”, näng mä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ti m' Jesus ty kaw'õõd däk ta wë, ti m' taky hadoo: —Eỹỹm manäh, tok ỹỹ —näng mäh. —Õm has'oo däk, P'op Hagä Do hã mah'yy ka'eeh do hyb n'aa —näng mäh. Tii bä kä m', nayyw hẽ tabahas'oo däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ti m' Jesus kajaa bä m' hyb n'aa jawyk do tób bä, tabajëë suun bä m', tabahapäh bä m' manarapéw hadoo do ragamehỹỹh doo, séd dó m' raräb bä rabë bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","taky hadoo mä sa hã: —Bë anäh! Karapee dooh tadajëb bä. Aỹỹh tii —näng mäh. Tii bä m' rakawew'aam ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ti m' hajõk do raban'yyh tan'oo bä do jawén paa bä, Jesus bajëë suun tób gawakõ gó, ti m' karapee tamoo maso däk, ti m' nayyw mä karapee bas'ëëg gëët. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ti m' jé pad'yyt hẽ m' ta ti häj n'aa bä rapanyyg enä hõm kän mä ta tii bä tamoo wät do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ti m' tii b' naa Jesus tsyym kadoo bä, pawóp hẽ ajyy ty temaa bok do ta jawén rabana. Ti m' rageëëj bong. Hahỹỹ da m' sa kyyh: —Mat'yyd mehĩĩn ããh, Jesus, Dawi panaa! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ti m' ta tób gó tabajëë suun bä m', ty temah do rabana ta wë, ti m' Jesus beaanh sa hã: —Bë ky daheeh g'eeh ỹ haja bä bë ty enä padëëk doo? —näng mäh. Ti m' raky hadoo: —Ỹỹ. Ãã ky daheeh né hẽ, Tak'ëp Hyb N'aa Jawyk Doo —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ti m' Jesus moo däng sa matym hã, ti m' taky hadoo: —Bë heso padäg, bë h'yy ka'eeh do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ti m' nayyw hẽ m' p'aa hẽnh mä rabahapëë padëëk. Ti m' Jesus ge'ỹỹm sa hã ranaher'oot hyb n'aa sa hã tamoo wät doo. Hahỹỹ d' mä ta kyyh: —Bë her'ood manä ta wób sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ti m' ta ky geǟm né paawä m', jé pad'yyt hẽ rapanäk Jesus moo wät do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ty temaa bok do paa ratsyym kasog sii hẽ m', ramanaa Jesus wë aj'yy karap'aar h'yyb nesaa do hadäk doo, ner'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Karap'aar h'yyb nesaa do Jesus habëë hõm jawén paa bä, aj'yy er'ood däg kän p'aa hẽnh. Hajõk do t'ĩĩ hẽnh kat'aa do rahyb n'aa meuunh mäh. Ti m' raky hadoo: —Dooh noo gó hapäh pé hahỹ hadoo pé Isaraéw buuj mahang —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pariséw kä m' raky hadoo: —Dooh. Karap'aar h'yyb nesaa do wahë n'aa kyy gó ti tabahebë karap'aar h'yyb nesaa doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ti m' sahõnh hẽ sa panang bä Jesus bewäd nä. Sa tób P'op Hagä Do panyyg rayd naherot do yt hã tama metëëk P'op Hagä Do bag'ããs do ky n'aa hanäm doo. Sahõnh hẽ hedoo pé sa nahëë Jesus hahëën hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ti m' hajõk do tabahapäh bä, tat'yyd mehĩĩn mä sa hã. B'éé hagã n'aa tamah do hadoo mä ta hã. Hajõng baad nadoo do rahoop. Dooh rad'oo péh, dooh masa pé sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ti m' panyyg gó m' tamaher'oot mä ta ma matëg sa hã. Hahỹỹ d' mä ta kyyh: —Hajõng ti anyy däg paawä joom ag wah'ëë däk do ji ataa do pan'aa, pawóp its ta taa n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","—Ti hyb n'aa taw'ããts hẽ joom danäh hã, P'op Hagä Do hã, bë ky n'aa ets'ẽẽ tamejõ nä ta wób joom hã ramoo bok hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ti m' Jesus naëënh 12 hedoo do ta ma matëg ta wë. Ti m' tabanoo mä sa hã karap'aar h'yyb nesaa do rabahajaa rabahebë hyb n'aa, sahõnh hẽ hedoo pé sa nahëë rahehëën hõm hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hahỹỹ m' 12 tamejũũ do sa häd: Simaw mäh, Peed ramaneëënh doo. Ta jawén mä Ãn-Deréh, Simaw hỹỹj. Ta jawén mä Sebedew taah, Tsijaag, Jowãw häd enäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ta jawén Pirip, Batoroméw, Toméh, Matew (Roma buuj hã Judah buuj rahepak do gedaag n'aa paah), Tsijaag Aw-Pew t'aah, Tadéw, ");
INSERT INTO mbjNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simaw Serot, Judas Ikarijot kä m', Jesus haëëj däk do majĩĩ hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ti m' Jesus mejũũ ta wób sa panang hẽnh rabahõm hyb n'aa. Hahỹỹ d' mä tamejũũ sa hã: —Bë ahõm manä Judah buuj nadoo do wë. Bë ajëë pä manä Samarija buuj sa panang bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Taw'ããts hẽ Isaraéw buuj sa h'yyb gó dawëë P'op Hagä Do mahǟnh habong do wë bë ahõm, b'éé kanapëë bong do hadoo do sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bë mahõm me hahỹ panyyg bë maher'ood sa hã: “Edaa däk hỹ pong jé hawät do ji tabag'ããs doo”, näk da bë kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Taw'ããts hẽ sa nahëë bë hahëën hõm, dejëp do ragenä bong bë an'oo bä, rog manahuuh do sa nahëë bë ado hõm, karap'aar h'yyb nesaa do sa hã padëëk do bë hebëë hõm. Bag hẽnh ỹ ban'oo däk bë hã ta ti bë bahajaa hyb n'aa. Ti hyb n'aa bag hẽnh bë masaa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dooh d' bë mahũũm pé ta säm hadoo péh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dooh d' bë mahũũm ta hood hadoo péh, tatu hadoo péh, bë tsyym suun see hadoo péh, bë saroor see hadoo péh. Dooh bë mahũũm pé ỹ wén näng, moo bok do sa hã ramoo bok do säm ji banoo do hyb n'aa. Bë masa do bë hã ranoo da bë wë badoh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Panang bä bë kajaa bä, bë esóts jé ky en'yym doo, bë gad'oo doo. Tii bä ta ti hedoo do tób bä bë ayyw panang bë beréd hõm bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta tób bä bë ajëë pä bä, bë ky n'aa edëë ta yt hã haj'eenh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta tii bä haj'eenh do ky en'yym do rado bä, hanäm gó bë ragado bä, bë ky n'aa edëng do aym da sa wë. Hanäm gó bë raganado bä, bë ado hõm sa hã bë ky n'aa edëng do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bë raganado bä, bë ramaa nanewë bä bë her'oot doo, bë tsyym suun bë tepyng padäg k'ããts, ta ti tób bä naa, ta ti panang bä naa bë tsyym kasok bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Baad bë ỹ maher'oot. Sahõnh hẽ badäk hahỹỹ hã habong do P'op Hagä Do ky n'aa etyy noo gó kä, Sodoma panang buuj, Gomoha panang buuj ta säm bahǟnh P'op Hagä Do anoo da nesaa doo, bë ganadoo do panang buuj hã. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Sa mahang bë ỹ mejũũ b'éé tabanas'aa mahang habëëh do hadoo. Ti hyb n'aa taw'ããts hẽ baad bë matakä sa hã, aw'yy matakëë do hadoo. Taw'ããts hẽ na-ããj hẽ kaja hẽ denaa hẽ bë h'yyb bë mahũũm sa mahang bë aboo bä. Hanäm gó bë aboo sa wë, gurii-i bawät do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Baad bë kanä sa mahǟnh. Bë da rahaëënh panang enäh do sa wahë n'aa sa moo gó, bë raky n'aa etyy hyb n'aa. Tób P'op Hagä Do panyyg rayd naherot doo gó bë da rahewyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hëp ỹ n'aa bë da ramahũũm sa wahë n'aa wë, hëëj bagã n'aa sa wë na-ããj hẽ, sa matym gó bë raky n'aa tapaa hyb n'aa. Këh ỹ n'aa bë her'ood kän da tii bä sa hã, Judah buuj, Judah buuj nadoo do na-ããj hẽ, raky n'aa napäh hyb n'aa këh ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bë ramoo maso däg bä, bë hyb n'aa tón manä bë her'oot do pan'aa hã, nyy da bë her'oot do hã. Ti noo gó kan'oo däk da bë hã bë her'oot do pan'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bë nado ti noo gó her'oot doo. Bë Yb hỹ pong jé hawät do Sahee er'oot da bë her'oot do hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ti m' taky hadoo ẽnh: —Hỹỹj näng doo, ta hỹỹj tan'oo däk da ta wób sa moo gó radaj'ëëp hyb n'aa. Ti hadoo né da t'aah näng do bad'oo ta t'aah hã. Sa taah da h'yy kawereem sa yb wë, sa ỹỹn wë. Rahaëënh da sa yb sa ỹỹn ta wób sa moo gó radej'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tak'ëp da sahõnh hẽ rakawajããn da bë wë hëp ỹ n'aa. Ti hadoo né da, jé h'yy kanerét do hã ỹỹ, tadajëb bä kä, edëb had'yyt hẽ da hỹ pong jé P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Panang s'ee hẽnh bë rarejã bä, bë kejën hõm panang s'ee hẽnh. Baad bë ỹ maher'oot hahỹỹh: Bë bahajaa do pooj jé panang haw'ããts hẽ Isaraéw häj n'aa bä bë moo bok bë ỹ mejũũ doo, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do matëëh da. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Dooh ma kametëëk do ta ma matëg bahǟnh tado bä. Dooh na-ããj hẽ sa karom sa kariw n'aa bahǟnh rado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sa ma matëg hajaa do pénh ma kamet'ëëk do rahaja däg bä kä, taw'ããts hẽ ratsebé. Sa kariw n'aa pénh sa karom rahyb n'aa jewyg däg bä kä, taw'ããts hẽ ratsebé. Hahỹỹ d' ỹ hanäng pé ti ta tii: Ỹỹh, bë wahë n'aa hadoo doo, “Beresebu, karap'aar h'yyb nesaa do wahë n'aa” ỹ ramaneëëj bä, ti bahǟnh tii bä bë da raky n'aa rejãã karapé haa bë bahadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tii d' radoo né paawä bë hã, bë jeỹỹm manä sa hã. Sahõnh hẽ ta wób nahapäh nä doo, sahõnh hẽ sa hã kejën doo, ta jawén rabahapäh da. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta wób ramaa nanapäh bä bë hã ỹ her'oot doo, sahõnh hẽ maa napäh bä bë her'ood. Kaja hẽ bë ỹ hesëënh doo, tak'ëp bë her'ood da sahõnh hẽ ramaa napäh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bë jeỹỹm manä ji majĩĩ ji daj'ëëp do hã. Jããm né ji hub rahajaa radaj'ëëp. Ji h'yyb tym dooh rahaja bä. Taw'ããts hẽ bë jeỹỹm P'op Hagä Doo. Ti ti hajaa tarejãã ji hub ji h'yyb tym na-ããj hẽ tabanesaa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pawóp hẽ taw'ëëd taah, kanahën d'os hẽ rabesëëm is, ky n'aa ganebats. Ti hado né paawä, dooh sa see dajëp pé bë Yb hỹ pong jé hawät do nan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ti hyb n'aa bë eỹỹm manäh. Hajõng taw'ëëd takamahǟn do bahǟnh bë P'op Hagä Do kamahǟn. Sahõnh hẽ ji sëën sii hẽ P'op Hagä Do betsén. Baad ji tabahag'ããs ỹ hanäng péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Këh ỹ n'aa najejën pé ta wób sa hã, ỹ na-ããj hẽ dooh ỹ ky n'aa jejën bä ta tii, Ee hỹ pong jé hawät do matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Këh ỹ n'aa jejën péh, ỹ na-ããj hẽ da ỹ ky n'aa jejën tii d' ẽnh, Ee hỹ pong jé hawät do matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Ỹ ahyy wät babä, bë ed'oo apäh, h'yyb nyyw gó badäk hahỹỹ hã habong do rababok hyb n'aa sa da hadoo do wë ỹ an'oo bä do hyb n'aa. Tii d' bë edoo manäh. Ti hyb n'aa nado ỹ wén hyng. Wawẽẽ hẽ ỹ bahyy wät do hyb n'aa ta wób rakamaj'ĩĩ da ta wób sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ỹ ahyy wät do hyb n'aa, ajyy wób rah'yy kawereem da sa yb wë. Ỹ ahyy wät do hyb n'aa, sa toog wób rah'yy kawereem da sa ỹỹn wë, sa takaanh wób rah'yy kawereem da sa mayyn wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tii bä da sa wakããn sa tób yt hã haj'eenh do sa majĩĩ däg da. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ỹ bë kamahǟn do bahǟnh bë yb, bë ỹỹn bë kamahǟn bä, dooh bë haja bä hëp ỹ hata bë do bä. Ỹ bë kamahǟn do bahǟnh bë taah, bë toog bë kamahǟn bä, dooh bë haja bä hëp ỹ hata bë do bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jé hëp ỹ n'aa tamo n'aa tahoop do tajeỹỹm bä, h'yyb nahedoo do nemon ỹỹ, dooh tahaja bä hëp ỹ hata tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jé badäk hahỹỹ hã ji hawät do hã tak'ëp kamahǟn doo, dooh da tanu dëë bä P'op Hagä Do wë. Hëp ỹ n'aa, hã ỹ taky daheeh do hyb n'aa dajëp péh, baad tabawäd had'yyt da P'op Hagä Do wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ti m' Jesus ky hadoo ẽnh: —Jé bë gadoo doo, ỹ na-ããj né tagadoo. Ỹ gadoo doo, hã ỹ mejũũ do tagadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jé P'op Hagä Do ky n'aa rod gadoo doo, P'op Hagä Do ky n'aa taher'oot do hyb n'aa, tagadoo da P'op Hagä Do hanaa ta ky n'aa rod hã tanoo do pénh ta säm. Jé ta da hadoo do gadoo doo, baad hawät do ta da hadoo do bahadoo do hyb n'aa, tagadoo da P'op Hagä Do hanaa baad hawät do hã tanoo do pénh ta säm. ");
INSERT INTO mbjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jé naëng dagäp do hanyy is pé hanoo pé hahỹ hyb n'aa sakog is do see hã tabeëëk hyb n'aa, hata ỹỹ tabahadoo do hyb n'aa, ta ti tagadoo né hẽ da baad hadoo do ta säm P'op Hagä Do hanaa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ti m' Jesus bahajaa bä kä 12 hedoo do ta ma matëg hã tamaher'oot doo, tatsyym kadoo mä tii b' naa, panang haw'ããts hẽ Garirej häj n'aa bä, panyyg hanäm do tama metëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti m' Kristo moo wät do radawäts gëët bä Jowãw nu gahem'uun do ky n'aa napäh bä, tamejũũ mä ta ma matëg Jesus wë rabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hahỹỹ da bë eaaj Jesus hã —näng mäh: “Õm né hẽ tii, P'op Hagä Do Ky Däng Do ta wë hana doo, ta see ti ãã gada?”, denoo da —näng mä Jowãw nu gahem'uun doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ti m' Jowãw mejũũ do hã Jesus ky hadoo: —Bë ahõm nä, bë maher'ood Jowãw hã hahỹ bë maa newëë doo, hahỹ bë bahapäh do na-ããj hẽ: ");
INSERT INTO mbjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ty temah do paah, rahapëë padëëk. Nabong do paah, aboo padëëk p'aa hẽnh. Rog manahuuh doo, ahub padëëk p'aa hẽnh. Nabuuj gatemah do paah, ramaa napëë padëëk. Dejëp do wób genä bong ỹ an'oo bä. P'op Hagä Do panyyg hanäm do na-ããj hẽ kaher'ood däk kas'uut do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ky n'aa kedëng da jé ỹ moo wät do hyb n'aa, ỹ her'oot do hyb n'aa tah'yy kaneréd bä hã ỹ tah'yy ka'eeh doo. Tii d' bë her'ood Jowãw hã —näng mä Jesus kyyh Jowãw nu gahem'uun do mejũũ do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ti m' Jowãw mejũũ do rababaaj hõm bä kä, hajõk do hã Jesus her'ood kän Jowãw nu gahem'uun do ky n'aa. Hahỹỹ da m' ta kyyh: —H'ëëd ti bë heg'ããs paa tabanawäng hẽnh? Jawii bah'ood ahëm do g'eeh bë heg'ããs? ");
INSERT INTO mbjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ti tanado bä, h'ëëd ti bë heg'ããs t'ĩĩ hẽnh? Aj'yy saroor ky n'aa gebah do dadäk do bë heg'ããs t'ĩĩ hẽnh? Dooh. Saroor ky n'aa gebah do dadäk do dooh raboo bä tabanawäng bä. Sa wahë n'aa tób hanäm doo gó rababok tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ti tanado bä, h'ëëd ti bë heg'ããs t'ĩĩ hẽnh? P'op Hagä Do ky n'aa rod bë heg'ããs? Ỹỹ. Ti né hẽ ti bë heg'ããs. P'op Hagä Do ky n'aa rod bahǟnh tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta ti né hẽ ta ti aj'yy ky n'aa näng do P'op Hagä Do kyy kerih do hã. Hahỹỹ da ta ky n'aa: “Ỹ mejũũ da panäk ỹ n'aa a pooj jé, a tyw n'aa tabenyyw däk hyb n'aa a pooj jé”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Badäk hahỹỹ bä habong do sa mahang, dooh Jowãw bahǟnh nu gadäk péh. Ti tahado né paawä, hỹ pong jé hawät do bag'ããs do karapee hedoo do sa mahang, jããm hẽ hyb n'aa sakog its né paawä, Jowãw bahǟnh tanu gadäk hỹỹ kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jowãw nu gahem'uun do du doo noo gó naa tanu gemuun doo, da hẽ kä na-ããj hẽ, hỹ pong jé hawät do bag'ããs do tak'ëp takah'ũũm. Tak'ëp ta wób h'yyb hedoo, P'op Hagä Do bag'ããs do karapee rabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jowãw nu gahem'uun do kajaa do pooj jé Mosees ky n'aa jaw'yyk doo, P'op Hagä Do ky n'aa rod na-ããj hẽ raher'oot mä P'op Hagä Do bag'ããs do ky n'aa, takajaa do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bë gado bä, bë gadoo né hẽ hahỹ bë ỹ maher'oot doo: Jowãw né hẽ ti Eriij, kajaa da P'op Hagä Do ky däng do paa ta kyy kerih doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Nyy gó da ỹ baher'oot da, da hẽ badäk hahỹỹ hã habong do panyyg ky nadah'eeh do sa ky n'aa? Hahỹ hadoo tii: Karepé wahoo gó hab'ëëh do ramas'uunh do hadoo. Hahỹỹ da karepé wób sa kyyh ta wób sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Raketëë do pud n'aa ãã gamehỹỹh bë tsebé hyb n'aa paawä, dooh masunh do bë as'ããw bä. Tii bä dajëp do heen n'aa ãã wareem, masuuj gó bë h'yy ketón hyb n'aa paawä. Ti na-ããj dooh bë karẽn bä. Dooh h'yy katón gó bë masuuj bä”, näk karepé ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ti hadoo né hẽ da hẽ habong doo —näng mäh. —Tabad'op hẽ ji raky dahé bä. Jowãw nu gahem'uun doo, dooh uwa s'ëëb mahỹỹnh do teëg bä. Ta see pé noo gó noo kanawa doo me P'op Hagä Do tah'yyb en'yym. Ti hyb n'aa, “Karap'aar h'yyb mahũũm mä tii”, näk sa kyyh Jowãw ky n'aa hã. Dooh Jowãw ragado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ỹỹ kä, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ eëëk, ỹ awa. Ti hyb n'aa ỹ ramaneëënh, tahawaa, heëëk do men, dajẽẽr gahed'aak doo, nesaa do moo heb'ooh do sa najiis. Ãã raganado né paawä, P'op Hagä Do né hẽ tii, ỹỹh, Jowãw na-ããj hẽ h'yy gan'yyh doo. Ãã ma met'ëëg wät do ky dah'eeh do baad rababok do hã takametä däk tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ta wób sa panang bä tapehuuj wät do bahǟnh Korasĩn, Betsaj-Da häd enäh doo bä Jesus pehuuj wät. Ti hado né paawä dooh rah'yy kawereem bä ta ti panang häd enäh do buuj. Ti hyb n'aa Jesus ky n'aa tapaa mä sa hã. Hahỹỹ d' mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Nesaa do P'op Hagä Do anoo da bë hã Korasĩn, Betsaj-Da panang buuj. Hajõng ỹ pehuunh do paa bë mahang. Dooh ỹ bë ky dahé bä. Panang Tiir, Sidõn häd enäh doo bä ỹ pehuuj wäd bä paawä rababong noo gó bë mahang ỹ pehuuj wät doo, p'ooj ub paawä ti buuj nesaa do hã rat'yyd kamehĩĩn paawä, P'op Hagä Do hã rah'yy kawereem paawä. P'ooj ub paawä saroor hebaan doo, hejooh doo, rapadadäg däg paawä, rehaa paawä sa nuu hã tëëg ooj rat'yyd kamehĩĩn do heen n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bë ỹ maher'oot hahỹỹh: Sahõnh hẽ badäk hahỹỹ hã habong do P'op Hagä Do ky n'aa etyy noo gó kä, Tiir Sidõn buuj p'ooj ub habong doo, nesaa do ta säm bahǟnh P'op Hagä Do banoo da bë hã nesaa doo, bë t'yyd kamanehĩĩn do hyb n'aa, bë h'yy kawanereem do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Bëëh, Kapar-Naũm panang buuj, hỹ pong jé has'ëëk do bë ed'oo g'eeh bëëh? Dooh. Tabanesaa hẽnh bë bahyk da P'op Hagä Do an'oo bä. Panang Sodoma häd näng doo bä ỹ pehuuj wäd bä paawä rababong noo gó bë mahang ỹ pehuuj wät doo, da hẽ ti badäk nä paawä panang Sodoma. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bë ỹ maher'oot hahỹỹh: Sahõnh hẽ badäk hahỹỹ hã habong do P'op Hagä Do ky n'aa etyy noo gó kä, Sodoma buuj p'ooj ub habong doo, nesaa do ta säm bahǟnh P'op Hagä Do banoo da bë hã nesaa doo, bë t'yyd kamanehĩĩn do hyb n'aa, bë h'yy kawanereem do hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti noo gó kä m' Jesus ky hadoo: —Ee, P'op Hagä Doo, a hã ỹ j'aa etsë. Sahõnh hẽ hỹ pong jé, badäk hahỹỹ hã hanäng do na-ããj hẽ mabag'ããs. Majejën hahỹ mamoo wät do haj'ap do sa mahǟnh, tak'ëp ma kamet'ëëk do sa mahǟnh. Mametä wät sa h'yyb gó karapee hadoo pé hã, baad h'yy ka'eeh pé hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ta tii da magen'aak Ee —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti m' taky hadoo: —Sahõnh hẽ Ee banoo ta hejój hã ỹỹ. Dooh baad hapäh pé ỹỹh, P'op Hagä Do T'aah. Jããm né Ee hapäh ỹỹh. Dooh Ee, P'op Hagä Doo, baad hapäh péh. Jããm né ỹỹh, ta T'aah hapäh. Jããm né hẽ sa hã ỹ metëëh do hapäh Ee —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ti m' taky hado kän: —B'ëëp wë ỹ sahõnh hẽ bëëh, hakaaj padëëk do hedoo doo, h'yy ketón do hedoo doo, tii bä da ỹ anoo bë kameh'ããk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kaja hẽ hëp ỹ mahũũm. Hanäm gó ỹ bawät sahõnh hẽ sa wë. Dooh ỹ h'yy kasabé bä. Ti hyb n'aa taw'ããts hẽ bë ky dahé ỹỹh. Taw'ããts hẽ bë ma kamet'ëëg hã ỹ bë hapäh doo. Tii bä da bë baw'yyt da bë h'yyb kameh'ããk doo, bë h'yyb näw. ");
INSERT INTO mbjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nahejooj bë hã ỹ ma metëëk doo. Tahajaa bë ky dahé bä. Nahejooj bë ỹ mejũũ doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti noo gó m', Saab hã m', Judah buuj rakamehehãk do noo gó m', Jesus ta ma matëg sa sii joom tiriig banäng doo me m' ratabës. As'aah mä ta ma matëg, ti hyb n'aa m' tiriig ag mä rateh'yyp rabawa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ti m' rateh'yyp do Pariséw wób rabahapäh bä, raky hadoo Jesus hã: —Mahegãã! Dooh a ma matëg raky dahé bä ër ky n'aa jaw'yyk do Saab ky n'aa hã. Saab hã ramoo bok —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ti m' Jesus ky hadoo sa hã: —Dooh bë ner'ood bä g'eeh nyy da ër wahë makũ Dawi bad'oo, tii, ta hataa rabas'aah bä? ");
INSERT INTO mbjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawi ajëë suun mä P'op Hagä Do sa hã kahesé do tób n'aa yt hã, ti m' ta hataa daheeh rabawa pãw P'op Hagä Do sa hã kahesé do tób n'aa yt hã hatoonh doo, jããm hẽ né paawä ta ti tób yt hã moo heb'ooh do haw'aa ta ti pãw Mosees ky n'aa jaw'yyk do hyb n'aa. Dawi dooh rahaja bä paawä rawa bä ta ti pãw. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dooh bë ner'ood bä g'eeh ër ky n'aa jaw'yyk do hã, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa ky n'aa? Saab hã ramoo bok né paawä ta tób n'aa yt hã, dooh P'op Hagä Do ky n'aa tapa bä sa hã. P'op Hagä Do tób n'aa yt hã moo heb'ooh doo, rahajaa Saab hã ramoo boo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hỹỹ kä, baad bë ỹ maher'oot hahỹỹh: P'op Hagä Do tób n'aa ky n'aa jawyg né paawä, ti bahǟnh hyb n'aa jawyk do kajaa bë mahang. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hahỹỹ da P'op Hagä Do kyyh: “Dooh rama ejuu do had'yyt tado bä ti ỹ karẽn doo. Ỹ gahëën sa hã rat'yyd mehĩĩn sa da hadoo doo”, näng kerih doo. Bë hapëë bä paawä nyy d' tahanäng pé ta tii, dooh daap hẽ bë ky n'aa ety bä paawä nesaa do hã moo nahadoo doo. Dooh daap hẽ bë ky n'aa ety bä paawä ma matëk ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta ti ỹ wén her'oot, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ né hẽ ti Saab ky n'aa hã mejũũ doo —näng mä Jesus Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ti m' tii b' naa Jesus tsyym kado kän. Tób P'op Hagä Do panyyg rayd naherot doo hẽnh tabajëë suun. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti yt hã m' tabasooh aj'yy moo gadóm doo. Ti m' ta wób rakarẽn paawä m' Jesus raky n'aa tapaa, Jesus ky nadaheeh do hyb n'aa Mosees ky n'aa jaw'yyk doo. Ti hyb n'aa m' rabeaanh ta hã: —Ër ky n'aa jaw'yyk do anoo Saab hã ji haso däg bä nahëë näng doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ti m' Jesus ky hadoo sa hã: —Bë mas'ãã b'éé tadëë hyy bä t'õp gadarong doo gó Saab hã, dooh g'eeh nayyw hẽ bë ej'ooj nä bä, Saab hã né paawä? ");
INSERT INTO mbjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ji masããh ji kamahǟn do bahǟnh tak'ëp ji kamahǟn ji da hadoo doo! Ti hyb n'aa ër ky n'aa jaw'yyk do anoo né hẽ baad hadoo do ji moo wäd bä Saab hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ti m' aj'yy hã kä taky hadoo: —Madajoow a mooh! —näng mäh. Ti m' ta moo tadajoow däk. Ahub däg kän mäh, baad däg mä ta moo kä. Hahup doo, ta moo see hado däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti m' nayyw hẽ m' Pariséw raban'yyh. Ti m' rahyb n'aa newëë mäh, kaner'oot mäh, nyy d' rabad'oo Jesus radaj'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus h'yyb hap'ëëh mä rakarẽn radaj'ëëp doo. Ti hyb n'aa ta s'ee hẽnh tabahõm kän. Hajõk mä ta jawén hah'ũũm. Ti m' sahõnh hẽ sa mahang habong do nahëë enäh do sa nahëë tasog hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesus ky ge'ỹỹm mä sa hã ranaher'oot hyb n'aa ta ky n'aa ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tii d' tawén mejũũ, P'op Hagä Do ky n'aa rod Isajas häd näng do her'ood wät do paa kametä däk hyb n'aa ta hã. Hahỹỹ da tii, P'op Hagä Do kyyh Isajas erii wät do paah: ");
INSERT INTO mbjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hahỹ karom ỹỹ, ỹ asëëw däk doo, ỹ kamahǟn doo. Baad ỹ h'yy gadajang ta wë. Ỹ anoo da Sahé ỹỹ, ta h'yyb gó tabawät hyb n'aa. Tamaher'oot da sahõnh hẽ badäk hahỹỹ hã habong do hã nyy da ỹ bad'oo baad had'op rabahadoo hyb n'aa matym ỹỹ gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dooh da taky gedag bä. Tak'ëp nado da ta kyyh. Dooh da tak'ëp ter'ood bä hajõk do sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Baad hadoo doo me da tagadoo sa h'yyb gó nahejoonh doo. Dooh da tahajẽẽw bä h'yyb nahed'oo doo. Tii da tabad'oo da sa hã baad had'op do j'aa ketsë bä kä nesaa do hã tan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta hã badäk hahỹỹ hã habong do radaab yyp, rabedëp hyb n'aa nesaa do mahǟnh.” ");
INSERT INTO mbjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ti m' ramanaa mä Jesus wë aj'yy karap'aar h'yyb nesaa do hadäk doo, ty tamah doo, ner'oot doo. Ti m' Jesus habëë hõm karap'aar h'yyb nesaa do aj'yy hã hadäk do paah. Ti m' aj'yy er'ood däg kän p'aa hẽnh. P'aa hẽnh mä tabahapëë däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hajõk doo, ta ti hap'ëëh doo, rahyb n'aa meuunh mäh. Ti m' raky hadoo: —Hahỹ g'eeh Dawi panaa P'op Hagä Do Ky Däng Doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ti m' reaanh do Pariséw ramaa napäh bä, raky hadoo: —Beresebu, karap'aar h'yyb nesaa do wahë n'aa kyy gó ti hỹỹ tabahebë karap'aar h'yyb nesaa doo! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus hapäh mä sa h'yyb, ti m' panyyg ky n'aa me taky hadoo sa hã: —Sa da hadoo do wë sa häj n'aa babuuj rahyb n'aa wareem bä, gawatsik tii bä sahõnh hẽ —näng mäh. —Panang buuj sa hã hẽ rah'yy kawereem bä, sa wakããn na-ããj hẽ sa hã hẽ rahyb n'aa wareem bä, sahõnh hẽ kahäj jëng tii bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","—Ti hadoo ẽnh Nesaa Do Yb hã kä. Ta daaj hẽ takahabëë bä, ta hã hẽ paawä ti tah'yy kawareem däk. Te hub tado bä paawä ta tii, nayyw hẽ tabahëëj jëë paawä Nesaa Do Yb bag'ããs doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bë her'oot doo da tado bä, Beresebu kyy gó ỹ hebëë bä paawä karap'aar h'yyb nesaa doo, jaa ky gabuuj bë karapee hebë do karap'aar h'yyb? Bë karapee né da bë raky n'aa etyy daap bë menyyh do hyb n'aa bë her'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","P'op Hagä Do Sahee hejój gó né hẽ ti ỹ hebë do karap'aar h'yyb nesaa doo. P'op Hagä Do ji tabag'ããs do kaja doo kä bë wë, ta ti metëëh bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Panyyg see gó bë ỹ metëëh: Dooh aj'yy hejoonh do tób gó hajëë suun pé ta ma tado hõm hyb n'aa, pooj jé tób danäh moo tamanaw'yyd bä. Ta moo kamaw'yyd bä tahajaa ta ma tado hõm bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ti m' Jesus ky hadoo: —Hëp ỹ hata nadoo doo, majẽ ỹ tii. Ỹ manasa do P'op Hagä Do wë ỹ ataa doo, dawëë rabehũũm tii bä tan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ti hyb n'aa bë ỹ maher'oot hahỹỹh: Sahõnh hẽ nesaa do ji moo wät do P'op Hagä Do mabaan né paawä, ta hã ji ky n'aa rejãã do P'op Hagä Do mabaan né paawä na-ããj hẽ ji hã, dooh P'op Hagä Do mabaan bä P'op Hagä Do Sahee ky n'aa rejãã pé kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jé Aj'yy Hadoo Do Hỹ Pong jé Hana Do ky n'aa rejãã péh, P'op Hagä Do mabaan ti ta hã. P'op Hagä Do Sahee ky n'aa rejãã pé kä, dooh P'op Hagä Do mabaan bä. Badäk hahỹỹ bä rababok nä bä, ta jawén na-ããj hẽ, dooh P'op Hagä Do mabaan bä tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Joom baad hadoo do tado bä, baad ta ag. Baad nadoo do tado bä joom, baad nado na-ããj hẽ ta ag. Ta ti ỹ wén her'oot, joom ag hã ji bahapäh joom ỹỹn. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aw'yy p'yym näng do taah hadoo bëëh! Baad nadoo do bëëh. Ti hyb n'aa dooh bë haja bä baad hadoo do bë her'ood bä. Ji h'yyb tym gó ji hyb n'aa newë had'yyt doo, ti né ji her'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Baad hawät doo, baad hadoo do ta h'yyb gó hanäng do taher'oot. Baad nawät doo, baad nadoo do ta h'yyb gó hanäng do taher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Baad bë ỹ maher'oot hahỹỹh: Sahõnh hẽ ta säm baj P'op Hagä Do banoo noo gó da, P'op Hagä Do matym gó ji kawoom da sahõnh hẽ ji her'oot do paa daap hadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Baad tado bä ji her'oot do paah, dooh P'op Hagä Do ji taky n'aa ety bä nesaa do hã. Baad tanado bä ji her'oot do paah, ji P'op Hagä Do ky n'aa etyy da nesaa do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ti m' Pariséw wób, Mosees ky n'aa jaw'yyk do ma mehetëk do wób na-ããj mä raky hadoo ta hã: —Ma matëg, —näk mäh —ãã karẽn ãã bahapäh mapahuunh doo, ãã matym haj'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ti m' Jesus ky hadoo sa hã: —Da hẽ badäk hahỹỹ hã habong doo, nes'aa sa h'yyb. P'op Hagä Do hã rahyb n'aa eréd hõm ta see hã rah'yy kawereem hyb n'aa. Tii d' né paawä sa h'yyb, ỹ ramejũũ ỹ pahuunh hyb n'aa sa matym haj'aa. Dooh da ỹ metä bä sa hã. Jããm né da P'op Hagä Do ky n'aa rod Jonas häd näng do ta metëë n'aa hadoo sa hã kametëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tamawoob hẽ adëb bä, tamawoob hẽ ta ǟh, tah'ỹỹb yb wog gó Jonas basuun doo da, ti hadoo, tamawoob hẽ adëb bä, tamawoob hẽ ta ǟh, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do bakëë da k'ããts gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niniwéh buuj raky n'aa tapaa da P'op Hagä Do matym gó da hẽ badäk hahỹỹ hã habong doo, sahõnh hẽ P'op Hagä Do ky n'aa etyy noo gó kä. Jonas maher'oot noo gó, rat'yyd kamehĩĩn nesaa do ramoo bok do hã. Nesaa do reréd hõm. Jonas bahǟnh ỹ ti hỹỹh. Ti hado né paawä, dooh bë t'yyd kamehĩĩn bä nesaa do bë moo bok do hã, dooh bë eréd bä, ti hyb n'aa né hẽ Niniwéh buuj bë da raky n'aa tapaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Seba häd näng do häj n'aa sa wahë n'aa ỹỹnh, da hẽ badäk hahỹỹ hã habong do taky n'aa tapaa da P'op Hagä Do matym gó, sahõnh hẽ P'op Hagä Do ky n'aa etyy noo gó kä. Dawëë naa paa m' tabana tii, tamaa newëë hyb n'aa Saromãw hajaa doo, P'op Hagä Do anoo do ta hã. Saromãw bahǟnh ỹ ti hahỹ bë hapäh doo. Ti hado né paawä, dooh bë karẽn bä bë maa newë bä hahỹỹh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ti m' Jesus ky hadoo ẽnh: —Karap'aar h'yyb nesaa do ta hã hadäk do paa ahõm wäd bä ta mahǟnh, tabanawäng hẽnh tabahew'ëët, ta tób tabesoos takameh'ããk hyb n'aa. Ti dooh tawyyd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ti ta h'yyb gó taky hadoo: “Ỹ abaaj hõm p'aa hẽnh ỹ hadäk do paa hã, tóp ỹỹ hẽnh”, näng. Tii bä ta tób paa bä takajaa bä, dooh ta yt hagä péh, yd kabak'ood däk tabahapäh, baad takabenäm ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tii bä tats'yyt 7 karap'aar h'yyb nesaa do wób ta hataa, ta bahǟnh nesaa doo. Tii bä rabajëë pëë ta tób paa gó. Tii bä rabanyy kän ta hã kä. Ta hã hanäng do paa bahǟnh tii kä. Tak'ëp tii kä ta hã kä nesaa doo kä. Tii da né da bë hã kä, bëëh, nesaa do moo heb'ooh doo —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ti m' hajõk do hã Jesus maher'oot nä bä ta ỹỹn kajaa, ta wakããn sii hẽ m'. Ta w'oo hã m' rababë däk. Rakarẽn paawä ta sii raber'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ti m' rë tanyy ky hadoo ta hã: —A ỹỹn, a wakããn ta w'oo hã rabab'ëëh. Rakarẽn mä õm rasii er'oot —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ti m' her'oot do hã Jesus ky hadoo: —Jaa ti ëën, jaa ti wakãn haa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ti m' teheet mä ta ma matëg sa wë, ti m' taky hadoo: —B'ëëh hahỹỹh, ǟn ỹ hedoo doo, wakãn haa hedoo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","—Sahõnh hẽ Ee hỹ pong jé hawät do karẽn do moo heb'ooh doo, ti né hẽ wakãn haa hadoo, ti né hẽ ǟnh ỹ hadoo, ti né hẽ ëën hadoo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti m' ti noo gó né hẽ Jesus banyyh tób bä naa, ti m' karaj'aa hẽnh tabawëënh. Ta nabyy me tabahyy sooh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hajõk kata b'ëëh ta hã. Ti hyb n'aa m' marakate gó tagatsëg sooh. Hajõk doo m' ayyw b'ëëh ta takëën hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ti m' hajõõ m' tama metëëk mä sa hã panyyg ky n'aa me m'. Hahỹỹ d' mä ta kyyh: —Hỹ hadoo joom hejóm do bejoom joom tym. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tatsawyh hõm joom tym. Joom tym tatsawyh hõm do wób ta tyw n'aa me takajäk, ti taw'ëëd rabajóh jëng. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Joom tym wób kajäk pä ta yt hẽ tabahadoo do jó. Kanahën its k'ããts tii bä. Ti nayyw hẽ taganyyh, kanahën d'os do k'ããts ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tabajuu bä nayyw hẽ tatsawyy jëng, dooh ta kóm ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta tym wób kajäk sasëng kóm banäng bä. Sasëng gajewäng bä kä, dooh tawëë wäd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ta tym wób kajäg kän baad tabadoo bä. Taganyyh, baad tabawäng, baad tabeaak. 100 nuu me tabejoom do bahǟnh tabeag kän baad tabadoo bä kajäk do ta tym wób. 60 nuu me tabejoom do bahǟnh tabeag kän ta tym wób. 30 nuu me tabejoom do bahǟnh tabeag kän baad tabadoo bä kajäk do ta tym wób kä —näng mä Jesus, panyyg ky n'aa me m' tabaher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ti m' taky hadoo: —Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ti m' ta ma matëg rabana Jesus wë ti m' rabeaanh ta hã: —Hëd n'aa mamaher'oot sa hã panyyg ky n'aa me? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ti m' taky hadoo sa hã: —Bë hã P'op Hagä Do an'oo däk bë bahapäh hyb n'aa pooj jé ji nahapäh do hỹ pong jé hawät do bag'ããs do ky n'aa hã, ta wób sa hã dooh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jé h'yy ganyy däk doo, ti bahǟnh P'op Hagä Do banoo nä ta hã ta h'yy ganäng doo. Baad tabahapëë kän tii bä. Jé kanahën d'os hẽ h'yy ganäng doo, P'op Hagä Do ado hõm da ta hã kanahën had'os doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rahegãã né paawä m', dooh m' rah'yy genä bä. Ramaa newë né paawä m', dooh m' ramaa napëë bä, dooh m' tagah'ood bä sa hã. Ti hyb n'aa né hẽ ỹ wén her'oot sa hã panyyg ky n'aa me. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sa hã kametä däk hahỹ P'op Hagä Do ky n'aa rod Isajas häd näng do erii wät do paa P'op Hagä Do kyyh Judah buuj sa hã: “Bë maa newë had'yyt hẽ né paawä, dooh da tagah'ood bä bë hã. Bë hegãã had'yyt hẽ né paawä, dooh bë h'yy ganyy bä.” ");
INSERT INTO mbjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“Ta ti ỹ wén her'oot Judah buuj sa ky n'aa hã”, näng mä P'op Hagä Do Isajas hã, “Dooh rah'yy kadawuung wäd bä baad hadoo do hã, hajõõ nuu me raky nadaheeh do hyb n'aa. Sa nabuuj ragetsëë hõm do hadoo. Raty gatsëë däk sa matym ranahapäh hyb n'aa. Tii d' tanado bä paawä rahapäh né paawä, ramaa napäh né paawä, h'yy kadewuung né paawä, wë ỹ rah'yy kawereem né paawä hã ỹ rah'yy ka'eeh hyb n'aa. Tii d' radoo bä paawä ỹ h'yyb wareem paawä baad rababok hyb n'aa kä.” ");
INSERT INTO mbjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ti m' ta ma matëg hã Jesus ky hadoo: —Ky n'aa kedëng bëëh, bë matym kä rahapäh do hyb n'aa, bë nabuuj kä ramaa napäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Né hup ỹ né hẽ hahỹ bë hã ỹ her'oot doo: Rababong noo gó, hajõk P'op Hagä Do ky n'aa rod makũũh, hajõk baad habok do makũũh, rakarẽn paawä raheg'ããs bë hapäh doo, dooh paa rahapëë bä. Rakarẽn paawä ramaa newëë bë maa newëë doo, dooh paa ramaa napëë booh —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ti m' taky hadoo: —Bë maa newë nyy d' tahanäng pé joom tym parar'aah do panyyg: ");
INSERT INTO mbjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","P'op Hagä Do bag'ããs do hã rah'yy ganenä bä ta ky n'aa ramaa newëë bä, tii bä Nesaa Do Yb asog hõm sa h'yyb tym gó kejoom do hadoo doo. Joom tym ta tyw n'aa me takajäk hadoo do tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Joom tym pä banäng bä kajäk doo, P'op Hagä Do panyyg maa new'ëë doo, h'yy gadajaa gó gad'oo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","H'yy gadajaa gó ragado né paawä, nayyw hẽ rah'yy gejë hõm, joom kóm nanäng nä do hadoo sa hã. Hejoonh do kametä bä sa hã, sa hã rarahejã bä na-ããj hẽ P'op Hagä Do panyyg metëëk doo da rababok do hyb n'aa, nayyw hẽ rah'yy gejë hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Joom tym sasëng mahang kajäk doo, P'op Hagä Do panyyg maa new'ëë do wób. P'op Hagä Do kyyh ramaa napëë né paawä, rahyb n'aa newë had'yyt hẽ badäk hahỹỹ hã ji bawät do hã. Dajẽẽr hã, sa ma ji tawadii do hã rahyb n'aa h'ũũm. Ti hyb n'aa P'op Hagä Do panyyg sa h'yyb gó hadäk do tawén nahõm. Joom neaak do hedo padëëk tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Joom tym baad tabadoo bä kajäk doo, P'op Hagä Do panyyg maa new'ëë doo, P'op Hagä Do panyyg hã h'yy gah'oot doo. P'op Hagä Do karẽn do baad ramoo bok tii kä. Joom 100 nuu me, 60 nuu me, 30 nuu me takejoom do bahǟnh tabeaak do hadoo do tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ti m' panyyg see ky n'aa me Jesus maher'oot mä sa hã. Hahỹỹ da ta kyyh: —Hahỹ panyyg ky n'aa hadoo hỹ pong jé hawät do bag'ããs do ky n'aa: Ti awät aj'yy joom tym baad hadoo do ta gëëw gó hejoom doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tii kä, sahõnh hẽ raba'ỹỹh bä, ta majĩĩ bana. Jawii tym tatsawyyh mä tiriig mahang. Ti tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ti tiriig tym ganyyh. Ti tiriig ag ganyyh bä, raty gepëë kän jawii mahang tabahëë däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ti joom danäh karom rabahõm ta wë, ti raky hadoo ta hã: —Kariw n'aa, —näk —baad hadoo do joom tym mabejoom wät. N'yy hẽnh naa jawii ta mahang ganyyh doo? —näk sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tii bä sa kariw n'aa ky hadoo sa hã: —Majẽ ỹ see tii, ti tsawyh häng doo —näng. Ti ta karom rabeaanh: —Makarẽn ãã asog hõm jawii? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Dooh —näng sa kariw n'aa. —Jawii bë basok bä, tiriig tëëg wób bë asog hõm ta mahang —näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","—Na mabëë dó tiriig mahang, tiriig ji bataa bä kä. Tiriig ag ji bataa noo gó ỹ mejũũ da tiriig ag hat'aa do sa hã, jawii pooj jé rasiip, ta natuu hã ramaw'yyd däk hyb n'aa ji ajuu hyb n'aa. Tii bä ỹ mejũũ tiriig ag rabataa, joom tób n'aa yt hã rabenäm —näng joom danäh ta karom sa hã —näng mä Jesus panyyg gó tabeh'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ti m' panyyg see ky n'aa gó Jesus maher'oot mä sa hã. Hahỹỹ da ta kyyh: —Joom motaad häd näng do tym nad'ëëd is do aj'yy ejoom do ky n'aa hadoo, hỹ pong jé hawät do bag'ããs do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jããm nad'ëëd its né paawä motaad tym bë joom tym mahang, ji waa ty gamabuuj see bahǟnh tabawäng. P'op tanu däk. Tii bä kä, taw'ëëd batooj kän ta hã kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ti m' panyyg see ky n'aa me Jesus maher'oot mä sa hã. Hahỹỹ da ta kyyh: —Pãw makuj n'aa ỹỹnh ado däk doo, hajõng tiriig s'ëëb mahang tamekuuj däk do ky n'aa hadoo hỹ pong jé hawät do bag'ããs do ky n'aa. Baad ỹỹnh bajõõts däk, baad takamekuuj wät bä kä sahõnh hẽ tiriig s'ëëb mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sahõnh hẽ ta ti Jesus her'ood wät sa hã panyyg ky n'aa me m'. Sahõnh taher'oot do sa hã, panyyg ky n'aa me né hẽ m' tamaher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tii da tawén d'oo hahỹ P'op Hagä Do kyyh ta ky n'aa rod erii wät do paa kametä däk hyb n'aa: “Ỹ maher'oot da panyyg ky n'aa me. Ỹ maher'oot da sa hã badäk hahỹ tadu dahäng do noo gó naa kejën wät do paah.” ");
INSERT INTO mbjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ti m' hajõk do hã Jesus kedëë hõm. Ti m' tób gó tabajëë suun mäh. Ti m' ta ma matëg rabana ta wë ti m' raky hadoo: —Nyy d' mahanäng pé jawii joom mahang hawäng do panyyg n'aa hã? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ti m' Jesus ky hadoo: —Joom tym baad hadoo do hejoom doo, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Joom banäng bä, badäk hahỹỹ hã habong doo. Joom tym baad hadoo doo, P'op Hagä Do bag'ããs do karapee. Jawii, Nesaa Do Yb karapee. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Joom danäh majĩĩ, jawii tym tsawyyh doo, Dijab tii. Tiriig ag rabataa noo gó, badäk hahỹỹ hã ji bawät do gawatsig hõm noo gó tii. Tiriig ag taa n'aa, ããs tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jawii rasok doo da, tëëg hõõ gó kadawäts toonh do hadoo da, badäk hahỹỹ hã ji bawät do gawatsig hõm noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ti noo gó Aj'yy Hadoo Do Hỹ Pong Jé Hana Do mejũũ da ta ããs rasog hõm hyb n'aa tabag'ããs doo bä naa sahõnh hẽ nesaa do wë ji tah'yyb tatuk doo, nesaa do ji moo wät hanoo doo, sahõnh hẽ nesaa do moo heb'ook doo na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tëëg hõõ gó, tak'ëp haju doo gó da radawäts toonh tii. A'oot da tii bä. Sa tëg kamegëëj padëëk da tak'ëp nesaa do rahoop do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tii bä da baad habok do tak'ëp rakawehëë däk da sa Yb bag'ããs doo bä. Papỹỹj bag däk doo da, hanäm do sa hã. Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ti m' Jesus ky hadoo: —Tak'ëp ky n'aa gebah doo, joom banäng bä kejën këë do ky n'aa hadoo hỹ pong jé hawät do bag'ããs do ky n'aa. Tak'ëp ky n'aa gebah do aj'yy see baw'yyt joom banäng doo bä. Ti p'aa hẽnh tajeh'aa këë. Tii bä, sahõnh hẽ tabesëëm hõm ta wë hanäng doo, tak'ëp tah'yy gadajang do hyb n'aa. Tii kä, ta ma paa säm me tametsẽẽ joom banäng doo, ky n'aa gebah do bakëë bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Aj'yy hetsẽ doo, hesäm doo, tak'ëp nu gabarëëh do perora häd näng do hesoos do ky n'aa hadoo na-ããj hẽ hỹ pong jé hawät do bag'ããs do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Perora tak'ëp hetsooh doo, ky n'aa gebah do tabaw'yyt bä kä ta ti hedoo do hes'ëëm do sa wë, tabahõm, tabesëëm hõm sahõnh hẽ ta ma ta wë hanäng doo. Tii kä ta säm me tametsẽẽ perora tak'ëp hetsooh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ti m' Jesus ky hadoo ẽnh: —Karahi me tah'ỹỹb rames'aak do ky n'aa hadoo na-ããj hẽ, hỹ pong jé hawät do bag'ããs do ky n'aa. Karaj'aa me radatu karahi. Hajõng hedoo pé sa mo haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ramo haj'aa enäh bä kä, rej'ooj nä kän ta takëën hã. Ahyy t'oonh mäh. Tii bä arook gó rabataa rasëëw hõm doo. Baad nadoo doo, ji nawëh doo, radewäts bëënh tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ti hadoo da badäk hahỹỹ hã ji bawät do gawatsig hõm noo gó ããs rabad'oo da. Ããs rabana, tii bä rasëëw hõm da badäk hahỹỹ hã habong doo. Tsyt hẽ rabasëm da nesaa do moo bok doo, P'op Hagä Do karẽn doo da habok do sa mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tii kä tëëg hõõ gó, tak'ëp haju doo gó radewäts bëënh da nesaa do moo bok doo. A'oot da tii bä. Sa tëg kamegëëj padëëk da tak'ëp nesaa do rahoop do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ti m' Jesus eaanh mäh: —Bë maa napäh sahõnh hẽ ta ti ỹ her'ood wät doo? —näng mäh. —Ãã maa napäh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ti m' Jesus ky hadoo sa hã: —P'op Hagä Do ky n'aa jaw'yyk do ma mehetëk doo, hỹ pong jé hawät do bag'ããs do ky n'aa hã na-ããj hẽ ma kamet'ëëg wät doo, tób danäh ta tób bä naa ky n'aa gebah do manyyh do hadoo ta wób hã tametëëh hyb n'aa. Ta gawakõ gó naa, aj'yy manyyh ky n'aa gebah do tenäm do paah. Ky n'aa gebah do papuuj hedoo do tamanyyh ta mahang, ky n'aa gebah do pooj nä ta mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ti m' Jesus bahajaa bä kä panyyg gó tama metëëk doo, tatsyym kado kän ta tii bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ti m' panang tabawäng do paa bä takajaa bä, ta du doo mä tama metëëk tób panang bä hasooh do P'op Hagä Do panyyg rayd naherot do yt hẽ. Maa new'ëë do rahyb n'aa meuunh mä taher'oot do sa hã. Ti m' raky hadoo: —N'yy hẽnh naa hahỹ aj'yy tah'yy ganäng doo? N'yy hẽnh naa ta hejój tamapehuunh doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—B'aa bäh gaheh'õõk do t'aah nado ti hahỹỹh? Marija nado ta ỹỹn? Tsijaag, Joséh, Simaw, Judas nado ta wakããn? ");
INSERT INTO mbjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sahõnh hẽ ta ǟnh, bä ab'ëëh ër pa. N'yy hẽnh naa tahapäh doo, ta hejój? —näk mä tabawäng do babuj n'aa sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ti m' rakawajããn ta wë. Raty n'aa gesyyg däk mäh. Ti m' Jesus ky hadoo sa hã: —Sahõnh hẽ sa panang bä raweh'ëëh P'op Hagä Do ky n'aa rod. Jããm hẽ tabawäng do panang bä, ta tób bä, dooh rawehëë bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ti m', ta hã rah'yy kana'eeh do hyb n'aa, dooh denaa hẽ m' Jesus pehuuj bä ta tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti m' ti noo gó né hẽ Garirej häj n'aa wahë n'aa, Eróts häd näng doo, taky n'aa napäh mä Jesus moo wät doo, Jesus ma metëëk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ti m' ta masa n'aa hã taky hadoo: —Jowãw nu gahem'uun do paa né tii. Ganä wät dejëp do paa mahang! Ti hyb n'aa tawén kabaj'aa —näng mä Eróts. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eróts mejũũ paa ramoo maso däk, ramoo maw'yyd däk, radawäts gëët Jowãw nu gahem'uun doo. Tii d' Eróts wén d'oo mä Erodija, ta hỹỹj Pirip häd näng do ỹỹm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hahỹỹ d' paa Jowãw kyyh Eróts hã: —Dooh P'op Hagä Do ky n'aa jaw'yyk do an'oo bä magat'ëë bä a hỹỹj ỹỹm —näng paa Jowãw nu gahem'uun do kyyh Eróts hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eróts karẽn né paawä m' tadaj'ëëp Jowãw, tajeỹỹm mä hajõk doo. Hajõk do tawén jeỹỹm, P'op Hagä Do ky n'aa rod ti Jowãw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ti m' Eróts ta yd enäng do heen n'aa noo gó, jäm ta heen n'aa ramoo bok noo gó, Erodija toog bajäm sa matym gó. Ti m' tak'ëp mä Eróts tsebee kän ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ti hyb n'aa taky däng tabanoo maruus hã, maruus karẽn do né hẽ. P'op Hagä Do häd gó m' ta ky däng, dooh taky kahỹỹd bä maruus bahapäh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ti m' maruus ỹỹn ta hã taky mejũũ do hyb n'aa taky hadoo: —Na, ỹ karẽn ta hood gó mabanoo hã ỹỹ Jowãw nu gahem'uun do nu gabóg —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ti m' tak'ëp mä sa wahë n'aa hyb n'aa tón wät. Ti hadoo né hẽ, ta ky bajawaa hyb n'aa m', tatsyyd bong do taky däng do ramaa napäh do hyb n'aa tagadoo maruus ets'ẽẽ wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ti m' tamejũũ tadawäts gëët doo gó ranu gahõg hõm hyb n'aa Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ti m' ta hood gó ramanaa ta nu gabóg maruus wë. Ti m' maruus an'oo däg kän mä ta ỹỹn hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ti m' Jowãw ma matëg rabana rabehëën hyb n'aa ta hub. Ti m' radakä jëng. Ti m' Jesus rapanäk. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ti m' Jowãw radaj'ëëp Jesus ky n'aa napäh bä m', ta m'aa hẽnh mä ta ma matëg daheeh rabahõm kän marakate gó ta wób rabedoh hẽnh paawä. Ta wób, hajõk do raky n'aa napäh bä m' n'yy hẽnh Jesus rabah'ũũm, sa jawén mä rabah'ũũm sa panang bä naa ta takëën hã. Sa pooj jé m' rakajaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ti m' Jesus basoop bä, hajõk do tabahapäh bä m', tat'yyd mehĩĩn mä sa hã. Nahëë enäh do sa mahang habong do taheso hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tũũh däg kä m', ta ma matëg rabana ta wë, ti m' raky hadoo ta hã: —Tũũh däg —näk mäh. —Dawëë hỹỹh. Mamejõ hajõk do panang banäng hẽnh rabahõm sa waa retsẽẽ hyb n'aa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ti m' Jesus ky hadoo: —Dooh. Na mayw babä. Bë né hẽ hanoo sa waa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ti m' raky hadoo: —Jããm hẽ ti hanyy is ãã wë ji ma poo oow pé pãw, pawóp its tah'ỹỹb —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Na b'ëëp. Bë mana wë ỹỹ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ti m' Jesus mejũũ hajõk do rabehyy b'ëëh hyb n'aa jawii jó. Ti m' tabasog däk mä pãw, tah'ỹỹb na-ããj mäh. Hỹ pong jé taty däng bä m', P'op Hagä Do hã taky hadoo: —Õm taw'ããts hẽ Ee. Man'oo däk ãã tä, man'oo däk ãã waa —näng mäh. Ti m' pãw taganebäh bong, tets'ëë hõm mä ta ma matëg sa hã, rabets'ëë hõm hyb n'aa hajõk do hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tii bä kä m', sahõnh hẽ m' rabawëë bong. Wog enä hõm mä sahõnh hẽ. Ti m' mad'aak do ta ma matëg rata hõm kawaju gó. 12 m' kawaju gedẽ hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hawëë bong doo, 5 miw mä ajyy. Ỹỹj, karepé na-ããj hẽ, dooh m' taketsén bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ti m' nayyw hẽ ta ma matëg Jesus mejũũ ragatsëg t'oonh marakate gó, ta pooj jé tamyyj däk hẽnh rabatsëg hõm hyb n'aa. Ti nuuj jé m' takedëë hõm hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Takedëë hõm do jawén paa bä m', tabasëëk ta mab hẽ waëë jó, P'op Hagä Do sii taber'oot hyb n'aa. Tabadajuu däk bä m', ta mab hẽ m' Jesus bayyw gëët. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dawëë péj mä ta ma matëg rababoo däg kän mä ti nuuj jé karaj'aa me. Tak'ëp maadaka betaam marakate hã. Dooh m' tahõm rahëë doo. Bah'ood ty gahëm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ti m' tapaj'ëë pooj jé Jesus bahõm kän sa wë tamii pong jó. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ti m' rabahapäh tamii pong jó hana doo, tak'ëp mä rabeỹỹm bong. —Wät ta ti dajëp do saw'ëëng paah! —näk mäh. Awaaw bong mäh, tak'ëp rabeỹỹm bong do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ti m' nayyw hẽ m' Jesus ky hadoo sa hã: —Bë eỹỹm manäh! Ỹ ti hỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ti m' Peed ky hadoo: —Tak'ëp Hyb N'aa Jawyk Doo, õm tado bä, ỹ mamejõ tamii pong jó a wë ỹ bahõm hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Ej. B'ëëp ana —näng mä Jesus ta hã. Ti m' Peed gatsëg nyyh, ti m' tamii pong jó tabahõm kän mä Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ti m' tak'ëp bah'ood bahëm do tabahapäh bä m', tabeỹỹm wät mäh. Ti m' ta du doo bä m' tadasug jëng bä, tak'ëp mä tageëënh Jesus hã: —Ỹ medëëb Tak'ëp Hyb N'aa Jawyk Doo! —näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti m' nayyw hẽ m' Jesus moo maso däk Peed. Ti m' taky hadoo: —Kanahën d'os hẽ h'yy ka'eeh do õm! —näng mäh. —Hëd n'aa mah'yy ganahoot? —näng mä ta kyyh Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ti m' marakate gó ragatsëg t'oonh bä m', bah'ood badoo wät. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ti m' marakate gó hat'oonh do Jesus mä raj'aa etsë. Hahỹỹ d' mä sa kyyh: —P'op Hagä Do T'aah né hẽ õm —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Rabatsëg hõm bä m', Genesaréh häj n'aa bä m' marakate badëë jad kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti m' ta ti babuj n'aa rabahapäh bä Jesus né ti kajaa doo, ramejũũ jé pad'yyt hẽ hëëj ta ti w'oo hã hanäng doo bä rapanäk hyb n'aa. Ti m' ramenaa nahëë enäh do sa mahang habong do Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ti m' rabetsẽẽ ta hã tabanoo nahëë enäh do ramoo kejäk hyb n'aa ta saroor noo byyh hã. Ti m' sahõnh hẽ nahëë enäh do ta hã moo kajäk doo, heso padäg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ti m' Pariséw wób, Mosees ky n'aa jaw'yyk do ma mehetëk do wób na-ããj mäh, Jerusarẽnh bä naa han'aa do rabana Jesus wë, ti m' rabeaanh ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—H'ëëd hyb n'aa a ma matëg raky nadaheeh ër wahë makũ metëëk doo? Rawa do pooj jé, dooh ramoo ketsyyd bä ër wahë makũ rabahed'oo doo da! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ti m' Jesus ky hadoo sa hã: —Ỹ eaanh bë hã —näng mäh. —Tii ẽnh bë ky nadaheeh ẽnh P'op Hagä Do mejũũ doo? Bë wahë makũ mejũũ do bë ky daheeh? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—Hahỹỹ da P'op Hagä Do kyyh: “Bë wehëë bë yb, bë wehëë bë ỹỹn.” “Ji daj'ëëp ta yb, ta ỹỹn ky n'aa wasee doo.” ");
INSERT INTO mbjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tii d' né paawä ta kyyh, ta see hado däk bë metëëk doo —näng mä Jesus. —Hahỹỹ da bë kyyh: “Jé ta yb, ta ỹỹn hã taky hado bä, ‘Hã ỹ naa magadoo do pan'aa paawä, P'op Hagä Do matym n'aa däg tii. Dooh bë hã ỹ an'oo wäd bä’, taky hado bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tii bä, ta tii d' ky hadoo doo, dooh ji mejõ wäd bä ta tii me ta yb taweh'ëëh hyb n'aa”, näk bë kyyh. Bë wahë makũ ma metëëk do bë ky sũũt do hyb n'aa bë eréd hõm P'op Hagä Do mejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","J'ooj madäk doo me ky ken'yym do bëëh! Baad né paa hahỹ P'op Hagä Do ky n'aa rod Isajas häd näng do kyyh bë ky n'aa: ");
INSERT INTO mbjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“J'ooj madäk doo me ỹ raweh'ëëh. Sa kyyp tii. Dawëë sa h'yyb bawät mahǟnh ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dooh këh ỹ tado bä ti rama metëëk doo. Raky n'aa jawyyg ub tii. Ti hyb n'aa daap hẽ ti ta ti ỹ rahyb n'aa jew'yyk doo” —näng mä Jesus Isajas her'oot do paa P'op Hagä Do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ti m' hajõk do ta tii bä hab'ëëh do Jesus naëënh ta wë. Ti m' taky hadoo sa hã: —Bë maa newë da, bë h'yy genä da ỹ her'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ji noo me hajëng do hyb n'aa nado ji nas'aa däk P'op Hagä Do hã. Ji noo me hanyyh do tii, hanoo ji nas'aa däk do P'op Hagä Do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ti m' badah peej ta ma matëg raky hadoo ta hã: —Mahapäh a kyyh, dooh taw'ããts hẽ tado Pariséw sa hã? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ti m' panyyg gó m' Jesus ky gadoo: —Kasog hõm da sahõnh hẽ joom Ee hỹ pong jé hawät do nejoom hõm doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","—Na manäh. Na kamawejãn. Ta wób sa h'yyb mahũũm n'aa ty temah do tii. Ty tamah do ta da ty hadoo do tamahũũm bä, gadarong doo hẽnh rakajäk séd hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ti m' Peed ky hadoo: —Ãã mamaher'ood. Nyy d' mahanäng pé ta ti ji noo me hajëng do panyyg? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ti m' Jesus ky hadoo sa hã: —Bë h'yy ganah'ood nä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","—Ji hã hajëng doo, ji wog gó ti tabajëng, ta jawén anyyh p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tii d' nado ji noo me henyyh do hã. T'õp naa, ji h'yyb tym gó tabana tii. Ti né hẽ ti P'op Hagä Do hã ji nas'aa däg hanoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ji h'yyb tym gó naa tabana nesaa do ji hyb n'aa newëë doo. Ji h'yyb gó naa né hẽ tabana ji da hadoo do ji daj'ëëp doo. Ji h'yyb gó naa tabana ji karẽn do ji bagä do ji ỹỹm nadoo do sii, ji patug nadoo do sii. Ji h'yyb gó naa né hẽ tabana ti ji ets'ëëk doo, daap hẽ ji da hadoo do ji ky n'aa tapaa doo, ji da hadoo do ji ky n'aa rejãã doo kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ta ti hadoo do hyb n'aa P'op Hagä Do hã ji nas'aa däg. Ji moo kanets'yyt doo me ji awa do hyb n'aa nado ji nas'aa däg P'op Hagä Do hã —näng mä Jesus kyyh ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ti m' ta tii b' naa Jesus bahõm hëëj panang Tiir häd näng doo, Sidõn häd näng do nedaa bä badäk doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ti m' ỹỹnh, Kanaãh buuj, Isaraéw buuj nado, ta tii bä hawät do ana kän Jesus wë. Ti m' tak'ëp mä ta kyyh Jesus hã tabetsẽẽ bä. Hahỹỹ d' mä ta kyyh: —Tak'ëp Hyb N'aa Jawyk Doo, —näng mäh —Dawi makũ panaa, —näng mäh —ỹ mat'yyd mehĩĩn! Tak'ëp nesaa do tok ỹ bahoop karap'aar h'yyb nesaa do ta hã hadäk do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ti m' dooh Jesus ky gado bä. Ti m' ta ma matëg rabana ta wë, ti m' tak'ëp mä rabetsẽẽ ỹỹnh tamejõ hõm hyb n'aa. Hahỹỹ d' mä sa kyyh: —Mamejõ hõm. Ër jawén tabana. Tageëëj had'yyt hẽ —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ti m' ỹỹnh hã Jesus ky hadoo: —Jããm hẽ Isaraéw buuj dawëë P'op Hagä Do mahǟnh habong do sa wë ỹ P'op Hagä Do mejũũ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ti m' Jesus wë ta taron nu paa me ỹỹnh bahyy häng. Ti m' taky hadoo: —Ỹ mamasaa, Tak'ëp Hyb N'aa Jawyk Doo! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ti m' panyyg ky n'aa gó Jesus ky gadoo: —Taw'ããts hẽ nado karepé sa waa ji ado hõm bä ji banoo hyb n'aa sa masããh awaar taah hã —näng mä Jesus kyyh ỹỹnh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ti m' ỹỹnh ky gadoo. Jesus kyy gó né hẽ m' taky hõm: —Ehub né hẽ õm Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Ti hado né paawä, awaar sii hẽ rabawa sa danäh waa hyyj tũũ kajäk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ti m' Jesus ky hado kän ta hã: —Tak'ëp né hẽ mah'yy ka'eeh! Ti hyb n'aa ỹ an'oo däk hã ỹ metsẽẽ doo —näng mä Jesus ta hã. Ti m' ti noo gó né hẽ tabahub däk ỹỹnh toog. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ti m' Jesus tsyym kado kän. Karaj'aa Garirej häd näng do nabyy me tatabës. Ti m' tabasoop. Waëë hã m' tabasëëk, ti m' tabahyy sooh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hajõk rabana ta wë. Ramenaa ta wë nabong doo, ty temah doo, moo gedóm doo, tsyym gedóm doo, nabuuj gatemah doo, hajõk nahëë enäh do wób. Ti m' sa nahëë Jesus basog hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ti m' tsyym gedóm do aboo padëëk, nabong do paa aboo padëëk, ty temah do paa ty enä padëëk, ner'oot do paa er'ood padëëk, ta tii bä hab'ëëh do rabahapäh bä, rahyb n'aa meuuj kän mäh. Ti m' raj'aa etsëë kän P'op Hagä Doo, Isaraéw buuj h'yy kaha'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ti m' Jesus naëëj nä ta ma matëg, tamaher'oot hyb n'aa. Ti m' taky hadoo: —Ỹ t'yyd mehĩĩn hahỹ ër wë kata pad'ëëk doo. Tamawoob däg ta ǟh si ỹ rababok. Dooh sa waa péh. Dooh ỹ karẽn bä sah me rabaaj hõm bä. Naheba padäg da, degõn jëng da sah mahỹỹj ta hõõ bä —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ti m' ta ma matëg raky hadoo: —Hajõk né hahỹỹh. Nyy bä ãã baw'yyt babä sa waa? Dawëë bä. Dooh ta nawaa babä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ti m' Jesus beaanh: —Nyy hẽ pãw bë wë? —näng mäh. —Ti anäng setsi pãw, pawóp its tah'ỹỹb ned'ëëd is doo —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ti m' Jesus mejũũ hajõk do rabehyy b'ëëh tũũ. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ti m' tabasog däk pãw, tah'ỹỹb na-ããj mäh. Ti m' taky n'aa etsẽẽ sa waa hyb n'aa. Tii bä m' taganebäh boo kän, tets'ëë hõm mä ta ma matëg sa hã, rabets'ëë hõm hyb n'aa hajõk do sa hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tii bä kä m', sahõnh hẽ m' rabawëë bong. Wog enä hõm mä sahõnh hẽ. Ti m' rabawëh do jawén paa bä m' mad'aak do ta ma matëg rabata däk arook gó. Setsi m' arook gedẽ hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","4 miw mä ajyy ti hawëë bong doo. Ỹỹj, karepé na-ããj hẽ m', dooh m' taketsén bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ti m' hajõk do hã Jesus kedëë hõm jawén paa bä, tagatsëg sooh mä marakate gó. Ti m' tabahõm kän hëëj panang Magadãn häd näng do nedaa bä badäk doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ti m' Pariséw, Saduséw daheeh rabana Jesus wë. Ti m' Jesus rametyy hyb n'aa ramejũũ mä tapahuuj bä sa matym haj'aa wë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ti m' Jesus ky hadoo: —Papỹỹj badëë hyng bä, “Jati d' banäm”, bë ky hetëg, bahiin do hyb n'aa wë puh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bäp paah, “Ti awät da bah'ood. Adoos da”, näk bë kyyh, tabahiin do hyb n'aa naëng pooh. Bë h'yy genä né paawä naëng hadoos do heen n'aa hã, banäm do heen n'aa hã wë hã kametëëh doo, dooh bë h'yy genä bä da hẽ ta heen n'aa bë hã kametëëh do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Da hẽ badäk hahỹỹ hã habong doo, nes'aa sa h'yyb. P'op Hagä Do hã rahyb n'aa eréd hõm ta see hã rah'yy kawereem hyb n'aa. Tii d' né paawä sa h'yyb, ỹ ramejũũ ỹ pahuunh hyb n'aa ta metëë n'aa sa matym haj'aa. Dooh da ỹ metä bä sa hã. Jããm né da P'op Hagä Do ky n'aa rod Jonas häd näng do ta metëë n'aa hadoo sa hã kametëëh da —näng mä Jesus. Ti m' Jesus bahõm kän sa mahǟnh. Panang s'ee hẽnh mä tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ti m' karaj'aa ta ma matëg rabatsëg hõm bä, ramabaan sa waa pãw. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ti m' Jesus ky hadoo sa hã: —Baad bë hyb n'aa matakä da. Baad bë kanä da Pariséw, Saduséw sa pãw makuj n'aa mahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ti m' ta ma matëg rakaner'ood bong Jesus her'oot do ky n'aa. Hahỹỹ d' mä sa kyyh: —Dooh ër mana pãw. Tii d' tawén edoo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ti m' Jesus hapäh ti raky n'aa hajẽm doo. Ti m' tabeaanh sa hã: —Kanahën d'os hẽ h'yy ka'eeh do bëëh. H'ëëd hyb n'aa bë hyb n'aa tón pãw bë mabaan doo? ");
INSERT INTO mbjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Dooh tagah'ood nä bä bë hã? Bë mabaan hõm 5 pãw ỹ etyn bong do 5 miw sa hã? Bë mabaan hõm nyy hẽ kawaju bë gedẽ hõm mad'aak doo? ");
INSERT INTO mbjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bë mabaan hõm setsi pãw ỹ etyn bong do 4 miw sa waa? Nyy hẽ arook bë gedẽ hõm mad'aak doo? ");
INSERT INTO mbjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hëd n'aa bë h'yy ganenä nä pãw ky n'aa nado bë ỹ maher'oot doo? “Bë hyb n'aa matakä da Pariséw, Saduséw sa pãw makuj n'aa”, näng këh ỹỹ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ti m' rah'yy kadawuung kän nyy d' tahanäng péh. Dooh pãw makuj n'aa mahǟnh rakan'yyh do pan'aa tado bä. Dooh. Pariséw, Saduséw rama metëëk do mahǟnh Jesus karẽn rakan'yyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ti m' hëëj panang Sesareja Pirip häd näng do nedaa badäk doo hẽnh Jesus kajaa bä, tabeaaj kän mä ta ma matëg sa hã: —Jaa m' ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, sa nooh? ");
INSERT INTO mbjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ti m' raky hadoo: —Ta wób noo m' õm mä Jowãw nu gahem'uun do paah. Ta wób noo m' õm mä Eriij makũũh. Ta wób noo m' õm mä Jeremiij makũũh. Ta wób noo m' õm mä P'op Hagä Do ky n'aa rod p'ooj ub dejëp do see paah —näk mä sa kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Bë hã ẽnh? Jaa ỹ bë hã ẽnh? —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ti m' Simaw Peed ky hadoo: —Õm ti Kristo, P'op Hagä Do H'yyb Däng Doo. P'op Hagä Doo, hedëb had'yyt do T'aah õm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ti m' Jesus ky hadoo: —P'op Hagä Do ky n'aa edëng do õm, Simaw, Jonas t'aah. Õm wén ky n'aa kedëng, dooh aj'yy tado bä a hã metëëh do ta ti maher'oot doo. Ee, hỹ pong jé hawät do né tii, ta ti a hã metä wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ti hyb n'aa ỹ ti her'oot hahỹỹh: Õm Peed, pä tahanäng doo. Pä tób ta jó ji tama sooh do hadoo da õm. Õm da hã ỹ h'yy ka'eeh do du n'aa doo. Dooh da Ades häd näng doo, dajëb hejój, haja bä hã ỹ h'yy ka'eeh doo, kahũũm had'yyt da. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ỹ anoo da a hã hỹ pong jé hawät do bag'ããs doo gó mabag'ããs hyb n'aa. Badäk hahỹỹ bä mananoo doo, hỹ pong jé P'op Hagä Do nanoo do né tii. Badäk hahỹỹ bä manoo doo, hỹ pong jé P'op Hagä Do anoo do né tii —näng mä Jesus kyyh Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ti m' Jesus mejũũ ranaher'oot hyb n'aa ta wób sa hã Kristo tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti m', ti noo gó naa Jesus du doo tamaher'oot ta ma matëg sa hã nesaa do tabahoop do pan'aa ky n'aa. Hahỹỹ d' mä ta kyyh: —P'op Hagä Do karẽn Jerusarẽnh hẽnh ỹ bahõm ër wahë n'aa moo gó, P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa moo gó, Mosees ky n'aa jaw'yyk do ma mehetëk do sa moo gó na-ããj hẽ hajõng ỹ bahoop hyb n'aa, ỹ radaj'ëëp hyb n'aa, tamawoob hẽ ta ǟh tabado däk bä ỹ ganä wät p'aa hẽnh hyb n'aa —näng mä ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ti m' Peed naëënh dawë hã. Ti m' taky ge'ỹỹm Jesus, tii d' tanaher'oot hyb n'aa. —Dooh. Tii d' edo manäh, Hyb N'aa Jawyk Doo! Dooh ỹ karẽn tii d' a hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ti m' Jesus ty kaw'õõd däk ta wë. Ti m' Peed taky geǟm wät: —J'eep! Ahõm mahǟnh ỹỹ, Nesaa Do Yb! —näng mäh. —Ỹ mah'yyb panas'ëëh. Dooh mah'yyb dëë bä P'op Hagä Do karẽn do hã. Ajyy rakarẽn do hã ti mah'yyb däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ti m' sahõnh hẽ ta ma matëg hã Jesus ky hadoo: —Jé karẽn pé hëp ỹ hata tabahadoo hyb n'aa, taw'ããts hẽ teréd hõm ta hã hẽ tah'yy ka'eeh doo, taw'ããts hẽ teréd hõm ta hã hẽ tahyb n'aa newëë doo. Taw'ããts hẽ da tagado had'yyt hẽ tahoop do hëp ỹ n'aa. Taw'ããts hẽ tagadoo hëp ỹ n'aa radajëëb bä na-ããj hẽ. Taw'ããts hẽ ỹ taky daheeh, taw'ããts hẽ ỹ bawät doo da da ti bawät. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tii d' ỹ wén edoo, badäk hahỹỹ hã ji hawät do tak'ëp kamahǟn doo, jé tahoop do hëp ỹ n'aa jeỹỹm doo, dooh da P'op Hagä Do wë tanu dëë bä. Jé hëp ỹ n'aa tahoop do gadoo péh, hëp ỹ n'aa tadajëb bä, ta h'yyb tym P'op Hagä Do wë da tanu däng. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hëd n'aa ji karẽn sahõnh hẽ badäk hahỹ ji ta danäh, ji h'yyb tym banesaa hẽnh tahõm bä? Dooh ta säm ji ad'oo pé ta s'ee hẽnh ji h'yyb tym nahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta ti ỹ wén her'oot, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ bahyng da Ee bag tak'ëp gabarëëh doo gó, ta ããs sa daheeh. Tii bä da ramoo bok do pénh da ỹ banoo sahõnh hẽ sa hã ta säm. ");
INSERT INTO mbjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Baad bë ỹ maher'oot. Ta wób babä ër mahang habong doo, rahapäh nä da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ỹ du doo noo gó ỹ bag'ããs do hã ỹ bag'ããs doo. Radejëp do pooj jé rahapäh nä da tii. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ti m' ji moo oow see pé sa ǟ jawén paa bä m', Jesus mahũũm ta sii Peed, Tsijaag, Jowãw daheeh. Tsijaag hỹỹj mä ti Jowãw. Ti m' rabas'ëëg kän waëë p'op nu däk do hã. Sa mab hẽ m' rabasëëk. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ti m' Jesus kawareem däk sa matym gó. Ta see hado däk mäh. Papỹỹj bag hadoo mä Jesus mamets gabar'ëëng däk. Tak'ëp mä ta saroor bahawag däk, ta bag hadoo mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti m' p'ooj ub habong do paa Eriij, Mosees häd enäh do rakas'ee b'ëëh sa matym gó. Jesus sii m' raber'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ti m' Peed ky hadoo Jesus hã: —Tak'ëp Hyb N'aa Jawyk Doo, —näng mäh —taw'ããts hẽ babä ër hã! —näng mäh. —Makarẽn bä tamawoob hẽ ta tób n'aa ỹ temaa toonh. Sét hẽ a tób, sét hẽ Mosees tób, sét hẽ Eriij tób —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ti m' Peed ber'oot nä bä nayyw mä wë puh gabarëëh do tabadäng sahõnh hẽ sa hã. Wë puh gó m' P'op Hagä Do ber'oot. Hahỹỹ d' mä ta kyyh: —Hahỹ tah ỹỹ, tak'ëp ỹ kamahǟn doo. Baad ỹ h'yy gadajang ta wë. Bë maa newë, bë ky dahé ta kyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","P'op Hagä Do kyyh Jesus ma matëg ramaa napäh bä m', tũũ m' rabehyy b'ëëh tak'ëp rabe'ỹỹm do hyb n'aa. Tũũ m' sa maboor me rabehyy b'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ti m' Jesus bana sa wë, ti m' sa hã tamoo däng bä m' taky hadoo: —Bë as'ëëg bëh! Bë eỹỹm manäh! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ti m' rabaheg'ããs bä m', jããm hẽ Jesus rahapäh. Dooh boo m' Jesus pa hab'ëëh do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ti m' rabahyk bä m' Jesus mejũũ ranaher'oot hyb n'aa rahapäh doo. Hahỹỹ d' mä ta kyyh: —Bë her'ood manä ta wób hã bë hapäh doo, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ganä wät bä kä dejëp do mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ti m' rabeaanh ta hã: —Hëd n'aa, Kristo kajaa do pooj jé Eriij m' matëëh Mosees ky n'aa jaw'yyk do ma mehetëk do raher'ood bä? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ti m' Jesus ky gadoo: —Se hub né hẽ. Eriij matëëh né da sahõnh hẽ tabenäm hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","—Ti hadoo né hẽ, bë ỹ maher'oot hahỹỹh: Eriij ewäd hyng né hẽ. Ewäd hyy né paawä, dooh rah'yy genä bä ta hã, dooh ramepëë bä. Rah'yy kajäk doo da né hẽ rabad'oo paa ta hã. Ta hã rabad'oo doo da, sa moo gó ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ ahoop da na-ããj hẽ —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tii bä m' ta ma matëg rah'yy kadawuung kän: Jowãw nu gahem'uun do paa ky n'aa Jesus her'oot wät. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ti m' Jesus rakajaa bä kä m' hajõk do rabab'ëëh bä, sa see ana ta wë. Ta taron nu paa me m' tabahyy häng ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ti m' taky hadoo: —Hyb N'aa Jawyk Doo —näng mäh. —Mat'yyd mehĩĩn tah ỹỹ —näng mäh. —Mera. Tũũ takepëëd had'yyt hẽ, tsanamäts däk. Tak'ëp nesaa do tabahoop. Ta hã ta nahëë adëë bä, hajõõ nuu me tëëg hõõ gó takadewëës. Ta me tabahop na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","—Ỹ mana wät a ma matëg sa wë. Dooh rahaja bä rado hõm bä ta nahëëh —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ti m' Jesus ky hadoo: —Baad P'op Hagä Do hã h'yy kana'eeh do bëëh, da hẽ badäk hahỹỹ bä habok doo! Baad nado bë h'yyb tym —näng mäh. —Hajõõ nuu me ỹ bawät nä g'eeh bë mahang bë ky dahé däk hyb n'aa kä? Ỹ hãd h'yyb napan däg bë hã, hã ỹ bë h'yy kanasadä nä do hyb n'aa —näng mäh. —Bë mana b'ëëp pahëëw —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ti m' karap'aar h'yyb nesaa doo, pahëëw hã hadäk doo, Jesus geǟm wät tabanyyh hyb n'aa. Ti m' karap'aar h'yyb banä kän pahëëw hã hadäk do paah. Ti noo gó né hẽ karapee bahas'oo däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ti m' sa m'aa hẽnh mä ta ma matëg rabeaanh ta hã: —H'ëëd hyb n'aa ãã wén nahajaa ãã habëë hõm bä karap'aar h'yyb nesaa doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ti m' Jesus ky hadoo sa hã: —Dooh baad P'op Hagä Do hã bë h'yy kae nä do hyb n'aa bë wén nahajaa —näng mäh. —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Motaad häd näng do tym nu nad'ëët do ta tym. Ti tahanyy bä paawä bë h'yy ka'eeh doo, tii b' bë haja paawä hahỹ waëë bë mejũũ takahỹỹd häng hyb n'aa. Bë paawä taky daheeh. Kanahën d'os hẽ né paawä baad bë h'yy kae bä, dooh paawä bë nahajaa péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","—Jããm hẽ P'op Hagä Do hã ji ky n'aa etsẽẽ doo me, ji noo kanawa doo me, ta ti hadoo pé karap'aar h'yyb nesaa do banyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta jawén mäh, Garirej häj n'aa bä m' rakataa bä m', Jesus ky hadoo sa hã: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da ran'oo däk da ta wób sa moo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ỹ radaj'ëëp da. Tamawoob hẽ ta ǟ jawén paa bä, ỹ ganä wät da p'aa hẽnh —näng mä Jesus ta ma matëg sa hã. Ti m' rah'yy ketón bong mä taher'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tii kä m', Kapar-Naũm bä Jesus rakajaa do jawén paa bä m', P'op Hagä Do tób n'aa dajẽẽr n'aa Judah buuj rahepak do taa n'aa rabana Peed wë, ti m' rabeaanh: —Äkä? Dooh bë ma matëg epaag bä P'op Hagä Do tób n'aa dajẽẽr n'aa ër hepak doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Tahepak né hẽ —näng mä Peed kyyh sa hã. Ti m' badah, tób gó Peed bajëë suun bä kä, Peed ky ganyyh do pooj jé, Jesus eaanh mä ta hã: —Nyy da a hã, Simaw? —näng mäh. —Sa wahë n'aa hedoo do häj n'aa bä, jaa hã ramejũũ rabep'aak häj n'aa wahë n'aa hã kahepak doo? Sa taah hã ramejũũ rep'aak, ta wób ta s'ee hẽnh naa ramejũũ g'eeh hep'aak? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ti m' Peed ky hadoo: —Ta s'ee hẽnh naa ti hep'aak —näng mäh. Ti m' Jesus ky hadoo: —Tii d' tado bä, sa taah, sa karapee, dooh rep'aak péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ti hado né paawä, hahỹỹ d' mabad'oo dajẽẽr gedaag n'aa rakawanaj'ããn hyb n'aa: Awëëj karaj'aa majat bä. Tah'ỹỹb matakyg. Mado däg pooj jé a mo haj'aa tah'ỹỹb, manoo gegãã, tii b' ta noo gó maw'yyt da moweed tëg hawak do s'ëëb. Tii me mepaag sa hã, hã ỹ naa, a hanaa rakarẽn doo —näng mä Jesus kyyh Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti m' ti noo gó ta ma matëg rabana Jesus wë ti m' rabeaanh: —Ny hadoo do sa bahǟnh hyb n'aa jawyk doo, hỹ pong jé hawät do bag'ããs doo bä? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ti m' karapee t'aah Jesus naëënh, ti m' tamaher'oot mä sa mahang tabag'ëëd däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ti m' taky hadoo: —Bë h'yyb bë wanereem bä, hahỹ karapee hadoo bë bahadoo hyb n'aa bë h'yyb gó, dooh tabad'op hẽ bë haja bä hỹ pong jé hawät do bag'ããs do karapee bë do bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ti hyb n'aa jé ta daaj hẽ kadaduu doo, hahỹ karapee hyb n'aa sakog is doo da tabahadoo hyb n'aa, ti né hẽ ti sahõnh hẽ sa bahǟnh hyb n'aa jawyk do hỹ pong jé hawät do bag'ããs doo bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ti m' ahõm nä ta kyyh: —Hät ỹỹ gó hahỹ karapee t'aah hadoo do see gadoo péh, ỹ né ti tagadoo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ti m' taky hado kän: —Baad nado né paawä pä ta jawyyg n'aa ji hã ranu hũũ däg bä, ji radawäts tu tame t'õp ji pahǟs hyb n'aa, ti bahǟnh tak'ëp baad nado ji hã da, ky n'aa netsëëh do seeh, hahỹ karapee hedoo doo, hã ỹ h'yy ka'eeh do ji h'yyb tatug bä nesaa do tamoo wät hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Tak'ëp da rabahoop nesaa do ta säm, badäk hahỹỹ hã habong doo, nesaa do ta wób ramoo bok do du n'aa doo! Tanyy had'yyt né hẽ nesaa do hã ji tah'yyb tatuk doo. Ti hado né paawä da, tak'ëp nesaa do ahoop da nesaa do hã h'yyb tatuk do du n'aa doo! ");
INSERT INTO mbjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ti hyb n'aa, a moo hyb n'aa, a tsyym hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä magakyd hõm a mooh. Madawäts hõm. Taw'ããts hẽ mabasëëk hỹ pong jé P'op Hagä Do wë sét a mooh, sét hẽ a tsyym, tëëg hõõ gó, nadëëk doo gó, õm P'op Hagä Do aw'oong hõm mahǟnh, pawóp hẽ tado bä a mooh, a tsyym. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A matym hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä a matym mado nyyh. Madawäts hõm. Taw'ããts hẽ mabasëëk hỹ pong jé P'op Hagä Do wë sét hẽ a matym, tabanesaa hẽnh tëëg hõõ gó, õm P'op Hagä Do aw'oong hõm mahǟnh, pawóp hẽ tado bä a matym —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ti m' Jesus ky hadoo: —Baad bë ỹ maher'oot hahỹỹh: Ee hỹ pong jé hawät do wë had'yyt hẽ rahajaa rakajaa ããs, hahỹ hyb n'aa sakog is do sa hagã n'aa. Ti hyb n'aa bë ty n'aa gesyyg manä hahỹ hyb n'aa sakog is do seeh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo ỹ ahyng babä ỹ bed'ëëp hyb n'aa ta s'ee hẽnh habong do paa P'op Hagä Do mahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ti m' panyyg gó tamaher'oot mäh: —100 b'éé aj'yy masããh see takanapëë wäd bä, dooh g'eeh ta danäh eréd dó 99 hadoo do ta masããh waëë hẽnh, kanapëë wät do tabesoos hyb n'aa? ");
INSERT INTO mbjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ti tabaw'yyt bä kä, tak'ëp da tatsebé ta mas'ãã kanapëë wät do paa hyb n'aa. B'éé 99 hadoo do hyb n'aa tatsebee né paawä, ta bahǟnh tatsebé kanapëë wät do paa hyb n'aa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Masããh danäh bad'oo doo da, dooh bë Yb hỹ pong jé hawät do karẽn bä dawëë ta mahǟnh hahỹ hyb n'aa sakog is do see tawäd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—A hỹỹj ky n'aa hadoo doo, a nemuun P'op Hagä Do hã h'yy ka'eeh doo, baad nadoo do tamoo wäd bä a wë, ahõm ta wë a mab hẽ. Tsyt hẽ, bë m'aa hẽnh mamaher'ood baad nadoo do tamoo wäd wät doo. Õm taky dahé bä, bë h'yyb hata däg p'aa hẽnh ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Õm taky nadahé bä, takanarẽn bä tamaa newë bä ta hã maher'oot doo, matsyyd tii bä P'op Hagä Do hã h'yy ka'eeh do seeh. Makarẽn bä, sét hẽ matsyyd, makarẽn bä pawóp hẽ matsyyd, a sii rabahõm hyb n'aa ta wë, pawóp hẽ, tamawoob hẽ ky n'aa maa napäh do tabanäng hyb n'aa sahõnh hẽ ta ti hedoo pé ji kaner'oot bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A sii mamahũũm do sa kyyh na-ããj hẽ takanarẽn bä tamaa newë bä, taky nadahé bä, tii bä mamaher'ood sahõnh hẽ hã ỹ h'yy ka'eeh do sa hã. Hajõk do sa kyyh tamaa nanewë bä, taky nadahé nä bä, tii bä P'op Hagä Do sa h'yyb gó nahapäh do see hado däk bë hã bë hỹỹj ky n'aa hedoo do paah. Ër uuh dajẽẽr gedaag n'aa Roma buuj hã ji hepak doo, raty n'aa ges'yyk do hado däk tii bä bë hã bë hỹỹj ky n'aa hedoo do paah —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ti m' taky hadoo ẽnh ta ma matëg sa hã: —Baad bë ỹ maher'oot hahỹỹh: Badäk hahỹỹ bä bë nanoo doo, hỹ pong jé P'op Hagä Do nanoo do né hẽ tii. Badäk hahỹỹ bä bë anoo doo, hỹ pong jé P'op Hagä Do anoo né tii d' ẽnh. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ti m' Jesus ky hadoo ẽnh: —Ta see bë ỹ maher'oot nä: Badäk hahỹỹ bä, pawóp hẽ bë wób séd hã bë h'yyb hedo bä bë ky n'aa etsẽẽ do hã, Ee hỹ pong jé hawät do anoo né da bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bë hã tawén noo, pawóp hẽ, tamawoob hẽ hëp ỹ n'aa rakahet'aa bä, sa mahang ỹ bawät do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ti m' Peed bana kän Jesus wë, ti m' teaanh mäh: —Ma matëg, nyy hẽ nuu me makarẽn ỹ hyb n'aa mabaan hǟj ỹ ky n'aa hedoo doo, baad nadoo do tamoo wäd bä hã ỹỹ? Setsi nuu me apäh ỹ hyb n'aa mabaan? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ti m' Jesus ky gadoo: —Setsi nuu me nado mamabaan —näng mäh. —Taw'ããts hẽ hahỹỹ d' mabad'oo: Mahyb n'aa mabaan hõm had'yyt hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Ta tii da ỹ wén mejũũ, hahỹ panyyg ky n'aa hadoo do hyb n'aa hỹ pong jé hawät do bag'ããs do ky n'aa: Ti awät hëëj bagã n'aa. Kũũt enäh ta karom ta wë. Tii bä tanaëënh ta wë ta karom sa kũũt rabep'aak hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tii bä, tadu doo bä sa sii taber'oot doo, ramanaa ta wë ta karom see tak'ëp kũũt eh doo. 10 miw moweed tak'ëp ky n'aa gebah do ta kũũt. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tanahajaa do hyb n'aa tepaag bä, tak'ëp ta bahǟnh haeh do hyb n'aa ta kũũt, ta kariw n'aa mejũũ rabesëëm hõm hyb n'aa ta ti ta karom, ta karom ỹỹm, ta taah, sahõnh hẽ ta wë hanäng do na-ããj hẽ, ta kũũt säm hata. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—Tii bä, ta taron nu paa me ta karom bahyy häng ta wë, ti m' tak'ëp tabetsẽẽ ta hã. Hahỹỹ d' ta kyyh: “Nayyw hẽ kawaj'ããn manä wë ỹỹ”, näng. “Magadaa bä, sahõnh hẽ kũt ỹỹ ỹ ep'aak da a hã”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ti ta kariw n'aa t'yyd mehĩĩn kän. Ti tabawug hõm sahõnh hẽ ta kũũt, ti m' tabanoo baad tabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Ti ta karom anyyh ta kariw n'aa tób bä naa. Tamahõm me takataa ta da hadoo do see ta wë kũũt näng doo. 100 moweed its ta kũũt. Ti tamaso däk ta da hadoo doo, ta garagoor gamaso däk, ti taky hadoo: “Nayyw hẽ mepaag a kũũt!”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Ti ta taron nu paa me ta da hadoo do bahyy häng ta wë, ti tak'ëp tabetsẽẽ ta hã: “Nayyw hẽ kawaj'ããn manä wë ỹỹ”, näng. “Magadaa bä, sahõnh hẽ kũt ỹỹ ỹ ep'aak da a hã”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Tii bä, tak'ëp tabets'ẽẽ né paawä, dooh takarẽn bä tamaa newë bä ta da hadoo do etsẽẽ doo. Ti tamejũũ ta da hadoo do radawäts gëët hyb n'aa ta kũũt tabep'aak bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ti tak'ëp häj n'aa wahë n'aa karom wób rah'yy kawaj'ããn bong nyy da ta ti karom bad'oo ta da hadoo do wë rabahapäh bä. Tii bä rabahõm kän sa kariw n'aa wë, ti ramaher'oot ta ti karom ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","—Tii bä sa kariw n'aa mejũũ ranaëënh ta ti ta karom. Ti taky hadoo ta hã: “Karom ky nesaa do õm!”, näng. “Sahõnh hẽ a kũũt ỹ bawug hõm tak'ëp hã ỹ mabetsẽẽ do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Taw'ããts hẽ mat'yyd mehĩĩn wäd paawä a da hadoo doo, õm ỹ t'yyd mehĩĩn wät doo da”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tii bä kawaj'ããn gó ta kariw n'aa bahaëëj däk ta karom ragadahew'ëës doo bä hagã n'aa sa hã, karom rarejãã hyb n'aa sahõnh hẽ ta kũũt tabepaag hõm bä kä —näng mä Jesus. Panyyg gó tabeh'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ti m' taky hado kän: —Sa kariw n'aa bad'oo doo da, tii da Ee hỹ pong jé hawät do bad'oo da sahõnh hẽ bë hã, bë h'yyb gó naa bë hyb n'aa manabaan bä bë hỹỹj ky n'aa hedoo doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ti m' Jesus bahajaa bä kä ta ti taher'oot doo, teréd hõm Garirej häj n'aa. Ti m' Judah häj n'aa hẽnh tabahõm, tamii Joradãn tamyyj däk hã hadäk do hëëj. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hajõk mä ta jawén hah'ũũm. Nahëë enäh do sa mahang habok do taheso hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ti m' Pariséw wób rabana ta wë rametyy hyb n'aa m'. Hahỹỹ da m' rake'aanh: —Ër ky n'aa jaw'yyk do anoo g'eeh daap hẽ né hẽ aj'yy eréd hõm bä ta ỹỹm, dooh hyb n'aa pé né paawä? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ti m' Jesus ky hadoo: —Dooh bë ner'ood bä g'eeh P'op Hagä Do kyy kerih do hã, nyy da sahõnh hẽ tadu dahäng noo gó P'op Hagä Do aj'yy ỹỹnh daheeh tapehuunh? ");
INSERT INTO mbjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hahỹỹ da takerih P'op Hagä Do kyyh: “Ti hyb n'aa kä aj'yy kä ta yb, ta ỹỹn mahǟnh kä sa m'aa hẽnh kä, tagatëë hyb n'aa ta ỹỹm kä. Takatëë jawén paa bä sét rabahado padëëk ta ỹỹm daheeh”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ti hyb n'aa pawóp hẽ ranado bong. Sét hado däg kän. Ti hyb n'aa séd hã P'op Hagä Do ata däk doo, dooh tahaja bä ji etyn bä —näng mä Jesus kyyh Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ti m' raky hadoo: —Tii d' tado bä, h'ëëd hyb n'aa Mosees mejũũ ji erii däk ji ỹỹm ji eréd hõm do heen n'aa, tii b' ji mejõ hõm tabahõm hyb n'aa? —näk mä Pariséw sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ti m' Jesus ky hadoo: —Ta tii da Mosees wén n'oo däk bë hã, bë nabuj keh'ũũm do hyb n'aa. Tadu dahäng noo gó dooh ta tii da tahado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ti hyb n'aa bë ỹ maher'oot hahỹỹ da: Jé ta ỹỹm heréd hõm doo, dooh né paawä ta patug tawad'ii bä, tii bä ỹỹnh see hã takat'ëë däg bä, nesaa do tamoo wät, ta ỹỹm h'yyb tarejãã tii kä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ti m' ta ma matëg raky hadoo ta hã: —Tii d' tahado bä ji ỹỹm ji patug ky n'aa hã, taw'ããts hẽ dooh ji kat'ëë bä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ti m' Jesus ky gadoo: —Dooh sahõnh hẽ rahaja bä ragado bä tii. Jããm né hẽ P'op Hagä Do anoo do gadoo rakanetëë doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ajyy wób dooh tahaja bä rakat'ëë bä pooj jé rabenäng bä ta nyy né hẽ tii. Ajyy wób dooh rahaja bä rakat'ëë bä ta wób ramoo bok do hyb n'aa sa hã. Ta wób rakanetëë hỹ pong jé hawät do bag'ããs do hyb n'aa. Jé hajaa do ji kanatëë do tagado bä, taw'ããts hẽ tagadoo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ti m' ta wób ramenaa karepé ned'ëëd is do Jesus wë, sa hã Jesus moo däng hyb n'aa, P'op Hagä Do hã taky n'aa etsẽẽ hyb n'aa sa hyb n'aa. Ti m' ta ma matëg rage'ỹỹm mä karepé men'aa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ti m' Jesus ky hadoo: —Na ramena karepé wë ỹỹ. Bë geǟm manäh. Hahỹ karepé h'yy ka'eeh do hadoo, ti né hẽ hỹ pong jé hawät do bag'ããs do karapee hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tii bä m' sa nu gad'oo bä m' tamoo däng, ta ky n'aa edëë bong mäh. Ti m' tatsyym kadoo, tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ti m' aj'yy see bana Jesus wë, teaanh Jesus hã: —Ma matëg! —näng mäh. —H'ëëd baad hadoo do ỹ moo wät da edëb had'yyt do ỹ gadoo hyb n'aa, P'op Hagä Do pa ỹ bawät hyb n'aa kä? —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ti m' Jesus ky hadoo ta hã: —Hëd n'aa baad hadoo do ky n'aa, hã ỹ meaanh? —näng mäh. —Jããm hẽ sét hẽ baad hadoo doo, P'op Hagä Doo. Taw'ããts hẽ maky dahé ta ky n'aa jaw'yyk doo, makarẽn bä magadoo edëb had'yyt doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Ny hadoo doo? —aj'yy eaanh mäh. Ti m' Jesus ky hadoo: —“Manaboh manä a da hadoo doo. Aǟ manä a ỹỹm nadoo do sii, a patug nadoo do sii. Etsëëg manäh. Daap hẽ maky n'aa tapa manä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mawehëë a yb, mawehëë a ỹỹn. Makamahǟn a da hadoo doo, a hã makamahǟn doo da” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ti m' aj'yy ky hadoo: —Ỹ panyyg kadeheeh né hẽ tii hã —näng mäh. —H'ëëd ti hawät ỹ moo wät? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ti m' Jesus ky hadoo: —Makarẽn bä baad had'op doo da mawäd bä P'op Hagä Do matym gó, abaaj hõm, mesëëm hõm a wë hanäng doo. Man'oo ta säm paa kas'uut do sa hã. Tii d' madoo bä hỹ pong jé magadoo da tak'ëp baad hadoo do P'op Hagä Do hanaa. Ti jawén ana kä wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa kä —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ti m' aj'yy maa napäh bä Jesus her'oot doo, ahõm kän Jesus mahǟnh. H'yy katón wät mäh, tak'ëp tawekãp do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ti m' Jesus ky hadoo ta ma matëg sa hã: —Hejoonh né hẽ wekãp do sa hã hỹ pong jé hawät do bag'ããs do karapee n'aa rabahadoo hyb n'aa. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Hejooj né paawä kameer hã tatabëëj bä gats'uus doo gó, ta bahǟnh tabahejoonh wekãp do sa hã P'op Hagä Do bag'ããs do karapee n'aa rabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta ti ta ma matëg ramaa napäh bä m', tak'ëp mä rameuuj bong, ti m' raky hadoo: —Jaa ẽnh ti P'op Hagä Do wë hasëëk ẽnh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ti m' Jesus ty gadäg däk sa wë, ti m' taky hadoo: —Ji daaj hẽ dooh né ji haja bä P'op Hagä Do wë ji as'ëëg bä. Ti hadoo né hẽ, dooh P'op Hagä Do nahajaa péh. Ti hajaa ta wë ji tamasäk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ti m' Peed ky hadoo: —Sahõnh hẽ ãã beréd hõm a hataa ãã bahadoo hyb n'aa. H'ëëd da ãã gadoo ta säm? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ti m' Jesus ky hadoo sa hã: —Sahõnh hẽ papuuj tabahadoo bä kä, sa wahë n'aa heh'äät do tyng n'aa jó, tak'ëp hetsooh do jó, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do basooh bä kä, tadu doo bä kä tabag'ããs doo, bëëh, 12 hedoo doo, hëp ỹ hata hadoo doo, bë na-ããj da bë at'oonh da 12 bagã n'aa tyng n'aa jó, 12 Isaraéw taah panaa bë bag'ããs hyb n'aa, bë ky n'aa etyy hyb n'aa. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hëp ỹ n'aa heréd hõm pé ta tób, heréd hõm do ta wakããn, ta ǟnh, ta yb, ta ỹỹn, ta taah, ta joom banäng doo, 100 nuu me bahǟnh do hajõng do tagadoo da baad hadoo do ta mabaj. Ta jawén kä, hỹ pong jé kä tagadoo da edëb had'yyt doo. P'op Hagä Do pa tabawäd had'yyt da. ");
INSERT INTO mbjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hajõk babä hyb n'aa jewyk do wób, ta jawén kä hyb n'aa sekog padäg its da hỹ pong jé. Hajõk babä hyb n'aa sekog is do wób kä ti noo gó kä hyb n'aa jewyg kän da —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ti m' Jesus ky hadoo: —Ta ti ỹ wén her'oot, joom danäh bad'oo doo da hahỹ panyyg hã, ti hadoo hỹ pong jé hawät do bag'ããs doo bä —näng mäh. —Bäp paa joom danäh bahõm kän ajyy tabats'yyt hyb n'aa ta joom uwa häd näng do mahang ramoo bok hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sét hẽ moweed denaari häd näng do taky däng sa hã ta säm, sét adëb bä ramoo bok do säm. Baad ub mä ti sa hã. Tii bä ta joom banäng hẽnh tamejũũ ramoo bok. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Tii bä, p'op däg papỹỹj, p'aa hẽnh tabahõm kän rabahesäm hẽnh ajyy wób tabats'yyt hyb n'aa. Tii bä tabahapäh moo nabok doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ti taky hadoo sa hã: “Bë na-ããj hẽ bë ahõm jóm ỹ uwa mahang bë moo bok hyb n'aa. Baad hadoo do ỹ bep'aak bë hã”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ti rabahõm kän. Ti p'aa hẽnh tabahõm wasyk, tug bä na-ããj hẽ, ta wób tabats'yyt hyb n'aa ta wë ramoo bok hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Edah papỹỹj badëë hyng bä kä, sét nuu me tabewäd nä. Ti anäng nä ta wób moo nabok doo. Ti tabeaanh sa hã: “Hëd n'aa adëb yd jé dooh bë moo boo bä?”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Dooh ãã hats'yyt pé sa sii ãã moo bok hyb n'aa”, näk sa kyyh. Ti joom danäh ky hadoo: “Bë na-ããj hẽ bë ahõm jóm ỹ uwa mahang bë moo bok hyb n'aa”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Tii, papỹỹj badëë hyng bä kä, joom danäh ky hadoo moo bok do sa wahë n'aa hã: “Manaëëj sahõnh hẽ moo bok doo. Man'oo sa hã ramoo bok do säm. Pooj jé manoo tagadëëg ub kajaa do ramoo bok do säm. Tagadëëg ub mabanoo pooj jé kaj'aa do ramoo bok do säm”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Ti tanaëënh tagadëëg ub kaj'aa doo. Sét ken'yyh ragadoo sét hẽ moweed denaari häd näng do ramoo bok do säm. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tii bä kä, pooj jé kaj'aa doo, ti bahǟnh red'oo ragadoo. Ti hadoo né hẽ, séd pénh né hẽ ragadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ragadoo do jawén paa bä kä, raky n'aa hajẽm. Baad nado sa hã ta danäh bad'oo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hahỹỹ d' sa kyyh: “Hahỹ ajyy tagadëëg ub matsyyd hõm doo, jããm hẽ sét hẽ oor its ti ramoo bok”, näk. “Ãã tak'ëp ãã moo boo paawä, tabajuu bä, ãã gadoo do pénh ragadoo”, näk sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Tii d' né paawä sa kyyh, ti sa kariw n'aa ky hadoo sa kanatëë hã: “Najis ỹỹ”, näng, “dooh õm ỹ wad'ii bä. Sét denaari né paa maky däng mamoo wät do säm”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Magado däg, ahõm kä. Tagadëëg ub ỹ ats'yyt doo, magadoo do pénh né hẽ ỹ karẽn ỹ anoo ta hã”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Dooh g'eeh ỹ haja bä ỹ karẽn doo da ỹ adoo bä dajẽr ỹỹ me? Mahyb n'aa jewës apäh ỹ betsëëh do hyb n'aa?”, näng joom danäh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Ti hyb n'aa kä —näng mä Jesus —hyb n'aa sekog is doo, hyb n'aa jewyg kän da. Hyb n'aa jewyk doo, ta jawén kä hyb n'aa sekog padäg its —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ti m' Jerusarẽnh hẽnh Jesus rabahõm bä, sa m'aa hẽnh Jesus naëënh 12 hedoo do ta ma matëg. Ti m' taky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ër ah'ũũm Jerusarẽnh hẽnh —näng mäh. —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da rahaëëj däk da P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa sa moo gó, Mosees ky n'aa jaw'yyk do ma mehetëk do sa moo gó na-ããj da. Dajëb hã raky n'aa etyy da ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ỹ rahaëëj däk da Judah buuj nadoo do sa moo gó, ỹ raky n'aa ej'ees hyb n'aa da, ỹ rabahewyyh hyb n'aa da, b'aa kajatsëk do hã ỹ rabepëëm däk hyb n'aa kä ỹ dajëp hyb n'aa. Tii bä, tamawoob hẽ ǟh ỹ tabahadoo bä da, ỹ d' ganä wäd kän —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ti m' aj'yy Sebedew häd näng do taah ỹỹn ana Jesus wë. Ta sii ta taah rabana. Ti m' ta taron nuu me m' sa ỹỹn bahyy häng ta wë, ti m' tetsẽẽ Jesus banoo hyb n'aa tetsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ti m' Jesus eaanh ta hã: —H'ëëd ti makarẽn? —näng mäh. Ti m' ỹỹnh ky hadoo: —Ỹ karẽn paawä, a hub hadäk hẽnh tah ỹ see basooh man'oo bä, s'ỹỹ me ta seeh, mabag'ããs doo bä kä —näng mä Tsijaag Jowãw sa ỹỹn kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ti m' Jesus ky hadoo ỹỹnh taah hã: —Dooh bë hapëë bä ti bë etsẽẽ doo —näng mäh. —Bë hajaa da bë ahob bä ỹ ahoop doo? —näng mä Jesus sa hã. —Ãã hajaa! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ti m' Jesus ky hadoo sa hã: —Bë ahoop né da ỹ d' ahoop do hadoo doo —näng mäh. —Hỹỹ kä, ta ti bë etsẽẽ do hã ỹỹ, ỹ nado ti hanoo. Ee anoo da hup ỹỹ hẽnh, sǟ ỹỹ hẽnh rabat'oonh, ta pooj jé tabenäm do tah'yyb däng do sa hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ti m' ta ma matëg wób, ji moo sahõnh hẽ hadoo do raky n'aa napäh bä retsẽẽ doo, rah'yy kawaj'ããn bong ta hỹỹj daheeh sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ti m' Jesus naëëj nä ta wë sahõnh hẽ ta ma matëg. Ti m' taky hadoo sa hã: —Bë hapäh né hẽ, ta ti Judah buuj nadoo do sa wahë n'aa, tak'ëp ramejũũ sa hã. Bë hapäh né hẽ ti hyb n'aa jew'yyk doo, tak'ëp ramejũũ sa karapee n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","—Bë mahang taw'ããts hẽ dooh tii d' tado bä. Bë mahang karẽn pé kaweh'ëëh péh, taw'ããts hẽ da ta wób sa karom hadoo tabahado däk, ta wób tamasa. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bë mahang karẽn pé ta wób sa bahǟnh nu gadäk péh, taw'ããts hẽ bë wë takadad'uuh. Taw'ããts hẽ da bë masa n'aa, bë karom kanep'aak do hado däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Taw'ããts hẽ ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, bad'oo doo da tabad'oo. Ỹ ahyng babä ỹ rahyb n'aa jew'yyk do jawén nado. Ỹ ahyng babä ỹ masa hyb n'aa ta wób, ỹ ky n'aa en'yym hyb n'aa ta wób sa hã, ỹ dajëp hyb n'aa hajõk do nesaa do sa mo haj'aa säm hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ti m' panang Jerikó häd näng doo bä naa Jesus ratsyym kasok bä, hajõk ta jawén hah'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ti m' ti ab'ëëh mä ta tyw n'aa nabyy me pawóp hẽ ajyy ty temaa bong doo. Ti m' ta tii bä Jesus tabës do raky n'aa napäh bä m', tak'ëp mä rageëëj bong: —Tak'ëp Hyb N'aa Jawyk Doo, Jesus, Dawi panaa, mat'yyd mehĩĩn ããh! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti m' hajõk do Jesus sii hah'ũũm do raky ge'ỹỹm mäh, bag hẽnh rabab'ëëh hyb n'aa. Raky geǟm né paawä m', tak'ëp rageëëj magyys hẽ: —Tak'ëp Hyb N'aa Jawyk Doo, Jesus, Dawi panaa, mat'yyd mehĩĩn ããh! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ti m' Jesus baym. Ti m' tanaëënh ta wë. Ti m' tabeaanh sa hã: —H'ëëd ti bë karẽn ỹ moo wät bë hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Tak'ëp Hyb N'aa Jawyk Doo —näk mäh. —Ãã karẽn p'aa hẽnh ãã begãã padëëk —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus t'yyd mehĩĩn mä sa hã. Ti m' sa matym hã tamepaa. Ti m' nayyw hẽ rabahapëë padëëk p'aa hẽnh. Ti m' Jesus rabahadaa kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ti m' Jerusarẽnh bedaa däk bä m', panang Betapagéh häd näng doo hẽnh rakajaa bä, waëë joom oriib häd näng do banäng bä, pawóp hẽ ta ma matëg Jesus mejũũ sa pooj jé m' rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Hahỹỹ d' mä ta kyyh sa hã: —Bë ahõm panang hẽnh bë pooj jé badäk doo hẽnh ti nuuj jé. Bë kajaa bä da, nayyw hẽ da bë baw'yyt jumeto ỹỹnh. Ta pa d' ta t'aah bahäng. Ta tyd hã d' rababëëh. Bë asood hõm da, séd hã bë manaa wawẽẽ hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—“Hëd n'aa ti bë as'oot jumeto?”, raky hado bä, tii bä hahỹỹ da bë kyyh: “Tak'ëp Hyb N'aa Jawyk Do karẽn. Badah takatajooh p'aa hẽnh da”, näk da bë kyyh —näng mä Jesus pawóp hadoo do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tii d' taher'oot, Tak'ëp Hyb N'aa Jawyk Do kyyh ta ky n'aa rod hã taher'ood wät do paa kaja däk hyb n'aa. Hahỹỹ da paa m' ta ky n'aa rod kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hahỹỹ da d' mamaher'ood Sijõn buuj: Bë hegãã! Bë wahë n'aa ti awät da. Kaja hẽ da ta h'yyb tamahũũm sahõnh hã. Jumeto t'aah jó d' tabana, näng da a kyyh.” Ti né hẽ P'op Hagä Do kyyh ta ky n'aa rod hã, Jerusarẽnh buuj hã tamaher'oot do pan'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ti m' pawóp hadoo do ta ma matëg rabahõm kän. Jesus mejũũ doo da né hẽ m' rabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ti m' ramanaa mä jumeto ỹỹnh, ta t'aah daheeh Jesus wë. Ti m' sa hatsë sa hã padëëk do paa radatoonh jumeto sa jó. Ti m' Jesus bas'ëëg so kän jumeto t'aah jó hatsë jó. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hajõk ta tii bä. Ti m' hajõk do sa hatsë sa hã padëëk do paa rat'ëëg hõm ta tyw n'aa me tamahõm doo me, raweh'ëëh hyb n'aa. Ta wób mä ragekyyt mä bag'aad, rat'ëëg hõm mä ta tyw n'aa me. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ti m' sahõnh hẽ pooj jé hah'ũũm doo, duu hẽnh han'aa do na-ããj mä tak'ëp mä sa kyyh: —Õm ãã j'aa etsë, Dawi panaa! Ky n'aa kedëng tii, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo! Hỹ pong jé hawät do hã ãã j'aa etsë! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ti m' Jerusarẽnh bä Jesus bajëë suun bä kä, tak'ëp mä sahõnh hẽ panang buuj ratsebee kän, sa wób reaanh mäh: —Jaa ti hỹỹ? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ti m' hajõk doo, Jesus sii kaj'aa do raky gadoo: —Jesus ti hỹỹh, P'op Hagä Do ky n'aa rod Nasaréh panang bä naa, Garirej häj n'aa bä naa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ti m' Jesus bajëë suun mä P'op Hagä Do tób n'aa w'oo hã, kahadë doo gó, wahoo gó. Ti m' tabahabëë bong hes'ëëm doo, hets'ẽẽ do na-ããj mäh. Ti m' tabaũũj bëëh dajẽẽr rabaheb'aanh do tyng n'aa. Gurii-i hes'ëëm do tyng n'aa na-ããj mä taũũj bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ti m' taky hadoo: —Hahỹỹ da takerii däk P'op Hagä Do kyyh: “Tóp ỹỹ ji maneëënh da P'op Hagä Do hã ji ky n'aa etsẽẽ do tób n'aa” —näng mäh. —Hỹỹ kä baretsëg tób n'aa hado däk bë an'oo bä! —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti m' ty temah doo, nabong do na-ããj hẽ ramenaa ta wë, P'op Hagä Do tób n'aa hẽnh. Ti m' sa nahëë Jesus basog hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ti m' P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ rakawajããn mäh, baad hadoo do Jesus moo wät do rabahapäh bä. Rawén kawajããn na-ããj hẽ karepé sa kyyh P'op Hagä Do tób n'aa kahadë doo gó hab'ëëh do ramaa napäh bä. Hahỹỹ d' mä karepé sa kyyh: —Õm ãã j'aa etsë, Dawi panaa! —näk mäh, hajõõ nuu me rageëënh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ti m' P'op Hagä Do tób n'aa yt hẽ moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ rahajẽm mä Jesus, karepé sa kyyh hyb n'aa. Hahỹỹ d' mä sa kyyh: —Dooh mamaa napëë bä karepé a hã raj'aa etsë doo? —näk mäh. —Ỹỹ. Ỹ maa napäh —näng mä Jesus. —Dooh g'eeh bë ner'ood nä bä hahỹ P'op Hagä Do kyyh hahỹ ky n'aa hã? Hahỹỹ d' paa ta kyyh: “Karepé, karepé taah its na-ããj hẽ õm raj'aa etsë man'oo bä” —näng mä Jesus kyyh P'op Hagä Do hã Dawi her'oot do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ti m' Jesus bahõm sa mahǟnh. Taberéd däk mä Jerusarẽnh. Panang Betanija häd näng doo hẽnh tabahõm. T'ĩĩ hẽnh mä tabaỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ti m' jati pé bäp paa Jerusarẽnh hẽnh tamatëëh bä, asa däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ti m' ta tyw n'aa nabyy me tahapäh mä joom wiigo häd näng doo. Taheg'ããs mä teag bä. Dooh m' ta hã ta ag. Ta g'aad had'yyt hẽ m'. Ti m' joom hã taky hadoo: —Dooh da meag wäd bä! —näng mäh. Ti m' nayyw hẽ joom tsawyy häng. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ti m' nayyw hẽ tatsawyy häng do ta ma matëg rabahapäh bä, raky hadoo: —Nyy da nayyw hẽ joom wén tsawyy häng? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ti m' Jesus ky gadoo mäh: —Baad bë h'yy kae bä, P'op Hagä Do ky däng do bë ky nasëëw bä, bë na-ããj hẽ bë hajaa bë moo boo bä hahỹ joom hã ỹ moo wäd wät doo. Ti bahǟnh bë hajaa bë moo boo bä. Hahỹỹ da bë hajaa tii bä bë mejõ bä hahỹ waëë hã: “Ahõm, ahob tame”, bë d' taky daheeh tii bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Baad bë ky dahé bä, bë ky nasëëw bä, bë gadoo né da P'op Hagä Do hã bë ky n'aa etsẽẽ doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ti m' Jesus bajëë suun kahadë doo gó, P'op Hagä Do tób n'aa basooh bä. Ti m' tama metëëk bä kä, rakajaa mä ta wë P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa, Judah buuj sa wahë n'aa hedoo do sii hẽ. Ti m' raky hadoo ta hã: —Jaa kyy gó mabad'oo hahỹ mabad'oo doo? Jaa ky gabuuj? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti m' Jesus ky hadoo sa hã: —Ỹ eaanh bë hã ẽnh. Bë her'ood bä, tii bä ỹ baher'oot bë hã jaa ky gabuuj hahỹ ỹ moo wät doo, hahỹ ỹ bad'oo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Jaa ky gabuuj Jowãw nu gahem'uun do nu gemuun paah? Hỹ pong jé hawät do kyy gó, sa ky gabuuj hẽ paah? —näng mäh. Tii bä m' sa m'aa hẽnh mä raky n'aa hajẽẽw bong. Hahỹỹ d' mä sa kyyh: —Hỹ pong jé hawät do kyy gó ër noo bä, teaanh da ër hã tii bä: “Hëd n'aa paa ti bë ky nadaheeh ẽnh?”, näng da. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ajyy kyy gó ër noo bä, hajõk do kawaj'ããn da tii bä ër wë, hajõk do hã m' P'op Hagä Do ky n'aa rod paa m' sa h'yyb Jowãw —näk mä sa kyyh sa m'aa hẽnh raky n'aa hajẽm bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ti hyb n'aa m' raky hadoo Jesus hã: —Dooh ãã hapëë bä —ken'ooh mäh. Ti m' Jesus ky hadoo sa hã: —Ỹ na-ããj né hẽ dooh ỹ her'ood bä ky gabuuj näng do hã ỹỹ, tii da ỹ bad'oo doo —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ti m' Jesus eaanh sa hã: —Nyy d' bë hã hahỹ panyyg? —näng mäh. —Ti awät aj'yy pawóp hẽ taah näng doo. Ta see pé noo gó wah'ëëh hadoo do hã tamejũũ sa joom uwa häd näng do mahang tamoo wät hyb n'aa ta ti noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ti wah'ëëh hadoo do ky hadoo: “Dooh. Dooh ỹ ahõm bä”, näng. Tii d' né paawä ta kyyh, nayyw hẽ ta h'yyb tabah'ỹỹt, ti tabahõm tamoo wät hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tii bä ta gad'oo hadoo do wë sa yb bahõm. Tamejũũ sa joom mahang tamoo wät hyb n'aa. Ti ta gad'oo hadoo do ky hadoo: “Ej. Ỹ né ahõm”, näng. Tii d' né paawä ta kyyh, dooh tahõm bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ti m' Jesus beaanh: —Ny hadoo do ky daheeh ta yb karẽn doo? —näng mäh. Ti m' raky gadoo: —Pooj jé tamejũũ doo —näk mäh. Ti m' Jesus ky hadoo sa hã: —Roma buuj hã kahepak do gahed'aak doo, ỹỹj hajõk do sii haỹỹh do na-ããj hẽ, bë pooj jé da rabajëë p'ëë da P'op Hagä Do bag'ããs doo hẽnh. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta tii d' ỹ wén edoo ta tii hã, Jowãw kajaa bä, nyy da baad ji bahado däk P'op Hagä Do matym gó bë tametëëh hyb n'aa, dooh bë ky dahé bä ta hã. Roma buuj hã kahepak do gahed'aak doo, ỹỹj hajõk do sii haỹỹh do na-ããj hẽ, ti ti ky dah'eeh. Bë hapëë né paawä nyy da ti raky daheeh, dooh bë h'yy kawareem bä bë ky daheeh hyb n'aa paawä Jowãw metëëk doo —näng mä Jesus kyyh P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa sa hã, Judah buuj sa wahë n'aa sa hã na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ti m' Jesus ky hadoo sa hã: —Bë maa newë hahỹ panyyg seeh —näng mäh. —Hỹ hadoo aj'yy bejoom hõm uwa häd näng do ta joom. Tahedëë hõm. Ti tagagoos uwa bëëh hood tagatsi hyb n'aa. Ti tamoo wäd sooh p'op nu däk do joom hagã n'aa tyng. Tii b' tabahaëëj däk ta joom banäng do ta kaser n'aa sa hã. Ti ta danäh bahõm dawëë. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","P'eets hẽ joom ag wah'ëë däk bä kä, ta danäh mejũũ ta sii moo heb'ook do wób ta kaser n'aa sa wë, tagadoo hyb n'aa paawä ta joom ag. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ti rakajaa bä kä, ta danäh mejũũ do ta kaser n'aa rameso padëëk. Ta mejũũ do see rahewyh wät, ta see radaj'ëëp, ta see radaj'ëëp pä me ramakut do haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tii bä ta karom wób joom danäh mejũũ, pooj jé tamejũũ do hawób bahǟnh. Ti hadoo né hẽ, tii d' né rabad'oo tii d' ẽnh sa hã. Rarahejãã né tii d' ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tii bä, tagadëëg ub tamejũũ ta t'aah. “Tah ỹ raweh'ëëh da”, näng mä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—Tii bä ta t'aah ta kaser n'aa rabahapäh bä, raky hadoo: “Ta danäh t'aah hahỹỹh. Tii d' ta danä däg ta yb jawén buuj däg”, näk mäh. “Ti bä, ër dajëëb! Ër ado hõm ta ma pan'aa paah”, näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tii d' né kä, ramejõ hõm joom bahǟnh, ti ranaboh jad kän —näng mä Jesus. Panyyg gó m' tabeh'ũũm sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ti m' teaanh sa hã: —Nyy da joom danäh bad'oo sa hã takajaa bä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti m' raky gadoo: —Tadej'ëëp da ta kaser n'aa ky nes'aa doo. Dooh d' tat'yyd mehĩĩn bä sa hã. Tii bä, ta kaser n'aa wób hã tabahaëënh da ta joom, joom wah'ëë däk bä kä ta ag wób ta hã hanoo do sa hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ti m' Jesus ky hadoo sa hã: —Dooh noo gó g'eeh bë ner'ood bä hahỹ P'op Hagä Do kyy kerih doo? “Pä tób n'aa tehem'aa do raty n'aa ges'yyk doo, hỹỹ kä pä ta ba n'aa, mesoo n'aa däg. Tak'ëp Hyb N'aa Jawyk Do mo haj'aa né tii. Taw'ããts hẽ ër hã tii”, näng kerih doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Ti hyb n'aa —näng mä Jesus —bë ỹ maher'oot hahỹỹh: P'op Hagä Do bag'ããs do kado hõm da bë mahǟnh. Kan'oo däk da ta wób sa hã, ta ag hadoo hanoo do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sahõnh hẽ hahỹ pä hadoo do ty n'aa ges'yyk péh, rahoop da nesaa doo. Ji jó ta ti pä tadëë bä, sahõnh hẽ ji gawatsik —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ti m' P'op Hagä Do tób n'aa yt moo heb'ooh do sa wahë n'aa, Pariséw na-ããj hẽ ramaa napäh bä panyyg gó Jesus metëëk doo, rah'yy genäh mä Jesus pes'ããp mä panyyg ky n'aa gó sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ratyw n'aa esoos mä ramaso däk hyb n'aa m' Jesus. Ti hadoo né hẽ, e'ỹỹm mä hajõk do Jesus maa new'ëë do sa hã. Rawén e'ỹỹm, P'op Hagä Do ky n'aa rod ti Jesus hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ti m' panyyg ky n'aa gó Jesus maher'oot mä sa hã. Hahỹỹ d' mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Hahỹ panyyg ky n'aa hadoo hỹ pong jé hawät do bag'ããs do ky n'aa —näng mäh. —Ti awät hëëj bagã n'aa ta t'aah katëë do waa n'aa, ta tä n'aa tamoo wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sahõnh hẽ ta waa n'aa ta tä n'aa tabahajaa bä, tamejũũ ta karom wób rabahõm hyb n'aa pooj jé tatsyyd bong do rabats'yyt hyb n'aa. Ratsyyd né paawä, dooh rakarẽn bä rana bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—Tii bä ta karom pooj jé tamejũũ do hawób bahǟnh tamejõ kän. Hahỹỹ d' ta kyyh sa hã: “Bë maher'ood ỹ atsyyd bong do sa hã, kaja toonh ta tä n'aa, ta waa n'aa. Bë maher'ood, masãh ỹ booj yb ajyy, booj yb tak'ëp hesynh do na-ããj hẽ ỹ naboh jat jäm tä n'aa. Sahõnh hẽ takaja däk. Bë maher'ood ỹ ats'yyt do sa hã, tah ỹ katëë do jäm n'aa hẽnh rabana hyb n'aa”, näng häj n'aa bagã n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Tii bä, rapanäg né paawä, dooh rah'yy kap'eed bä. Kats'yyt do paa ah'ũũm ta s'ee hẽnh. Ta joom banäng hẽnh ta see bahõm, tamoo wät doo hẽnh ta see bahõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kats'yyt do wób rameso padëëk häj n'aa bagã n'aa karom, rarahejãã, ti radejëëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tii bä, tak'ëp hëëj bagã n'aa kawaj'ããn kän ta ti taky n'aa napäh bä. Tii b' tamejũũ ta warahén sa wë. Ti ragawats'iik ta ti ji da hadoo do dahej'ëëp doo. Ti ragatang sa panang paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—Ti taky hado kän ta karom wób sa hã: “Kaja däg né paawä tah ỹ katëë do tä n'aa ta waa n'aa, pooj jé ỹ atsyyd wät doo, dooh ỹ gado wäd bä jäm hẽnh. Ta ti hedoo do dooh né hẽ ji atsyyd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hỹỹ kä, bë ahõm panang tyw n'aa kajatsëk doo hẽnh hajõk do rabab'ëëh hẽnh. Bë atsyyd nä sahõnh hẽ bë aw'yyt doo”, näng hëëj bagã n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tii bä ta karom rabahõm kän panang tyw n'aa me, ti rabats'yyt sahõnh hẽ ta tii bä raw'yyt doo. Baad habok do rats'yyt, baad nabok do na-ããj hẽ. Tii bä kä, gabad'ẽẽ däk jäm tób n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Tii bä kä, hëëj bagã n'aa, jäm noo gana do bajëë suun, rats'yyt do tabedëng hyb n'aa. Tii bä tabahapäh aj'yy jäm katëë do saroor n'aa nadadäk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ti taky hadoo ta hã: “Najis ỹỹ”, näng, “dooh paawä ta tii da majëë suun bä manadadäk do hyb n'aa jäm saroor n'aa”, näng. Bag hẽnh aj'yy maa new'ëp. Dooh ta kyy péh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tii bä ta karom hã hëëj bagã n'aa ky hadoo: “Bë moo maw'yyd däg, bë tsyym maw'yyd däg hahỹ aj'yy. Bë dawäts nä gadagyp doo hẽnh. A'oot da tii bä. Sa tëg kamegëëj däk da tii bä tak'ëp nesaa do rahoop do hyb n'aa”, näng hëëj bagã n'aa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ti m' Jesus ky hado kän: —Hajõõ né paawä P'op Hagä Do ats'yyt doo, pawóp its ta wób tasëëw hõm doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ti m' Pariséw rakata padëëk raky n'aa her'oot hyb n'aa nyy da rabad'oo Jesus rano n'aa masoo taher'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ti m' ramejũũ mä Jesus wë sa ma matëg, Judah buuj sa wahë n'aa Eróts häd näng do karapee sii hẽ, ky ken'yym doo gó rake'aanh hyb n'aa. Hahỹỹ d' mä sa kyyh Jesus hã: —Ma matëg! —näk mäh. —Ãã hapäh õm. Baad ub mabawät. Dooh daap mamenä bä. Ehub né hẽ P'op Hagä Do karẽn do hã mama metëëk doo —näk mäh. —Dooh mahyb n'aa p'eed bä ky n'aa etsëëh do hã, hyb n'aa jawyk do hã mama metëëk bä. Dooh maky n'aa ehỹỹd bä sa hyb n'aa ma metëëk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ti hyb n'aa, —näk mäh —ãã mamaher'ood nyy da a hã. Taw'ããts hẽ a hã ji epaag bä Roma buuj sa wahë hã rahepak doo, Sesa hã? Nyy d' a hã? Ji ep'aak g'eeh ta tii? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus hapäh mä sa h'yyb nesaa doo. Ti m' taky hadoo sa hã: —J'ooj madäk doo me ky ken'yym do bëëh! Hëd n'aa tii da bë ke'aanh, këh ỹ hyb n'aa ỹ bë no n'aa maso paawä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Bë metäh hã ỹỹ moweed ji mahepak doo —näng mäh. Ti m' raban'oo däk ta hã moweed denaari häd näng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ti m' tabeaanh sa hã: —Jaa heen n'aa hahỹỹh? Jaa häd hahỹ kerih do ta hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ti m' raky hadoo: —Sesa heen n'aa, Sesa häd —näk mäh. Ti m' Jesus ky hado kän sa hã: —Bë an'oo Sesa hã ta no n'aa, ta heen n'aa hadäk doo. Bë an'oo P'op Hagä Do hã ta no n'aa hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ti m' rahyb n'aa meuunh mä Jesus her'oot do ramaa napäh bä m'. Ti m' rabahõm kän mä ta mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti m', ti noo gó né hẽ rakajaa Jesus wë Saduséw häd enäh doo, ta hã rake'aanh hyb n'aa m'. Sa hã m' dooh m' ji ganä wäd bä ji dajëb bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Hahỹỹ d' mä sa kyyh: —Ma matëg! —näk mäh. —P'ooj ub Mosees mejũũ ër hã, aj'yy dajëb bä, ta ỹỹm teréd wäd bä tanetaa nä bä, tii bä m' ta hỹỹj mä gat'ëë däk tii, ta hỹỹj makũ panaa näng hyb n'aa m' —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","—Panyyg gó õm ãã maher'oot —näk mäh. —Hỹ hadoo aj'yy 6 ta hỹỹj ãã mahang habok do paah. Tagat'ëë däk mä ta ỹỹm. Dooh m' teta nä bä, aj'yy dajëp. Ti hyb n'aa ta hỹỹj seeh, ta jawén näh, gat'ëë däk mä ta hỹỹj makũ ỹỹm paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ti na-ããj mä dajëp né tii d' ẽnh. Dooh m' reta nä bä tadajëp. Ti hadoo né m' ta wób ẽnh. Sahõnh hẽ m' raget'ëë bok ta ti ỹỹnh. Sahõnh hẽ m' dooh reta nä bä radejëp. Tagadëëg ub ta gad'oo hadoo do kat'ëë däk ta hã. Ti na-ããj hẽ dajëp. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tii kä m' ỹỹnh dajëb kän —näk mä Saduséw. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ti m' rabeaaj kän Jesus hã: —Ji genyyh bä kä ẽnh, dejëp do paa ji? —näk mäh. —Ny hadoo do ỹỹm kä ta ti ỹỹnh ti noo gó kä? Sahõnh hẽ paa ta ti ta pat'uuk —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ti m' Jesus ky hadoo sa hã: —Dooh bë h'yy genä bä baad hadoo do hã, P'op Hagä Do kyy kerih do bë nahapäh do hyb n'aa, P'op Hagä Do hejój bë nahapäh do hyb n'aa na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","—Dejëp do ragenyyh bä kä, dooh ji kat'ëë wäd bä. Ããs hỹ pong jé habong do kanetëë do hadoo da ji tii bä kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Dejëp do genyyh doo kä, dooh bë ner'ood bä hahỹ bë hã P'op Hagä Do her'oot doo? ");
INSERT INTO mbjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abaraãm hagã ỹỹh, Isak hagã ỹỹh, Jakóh hagã ỹỹh.” Dooh, “Abaraãm makũ hagã, Isak makũ hagã, Jakóh makũ hagã”, tanoo bä. Dejëp do hagã n'aa nado P'op Hagä Doo. Hedëp do sa hagã n'aa tii —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ti m' hajõk do ramaa napäh bä ta ti taher'oot doo, rahyb n'aa meuunh mä tama metëëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ti m', Pariséw raky n'aa napäh bä, dooh m' Saduséw sa kyy wät pé sa hã Jesus her'oot do hyb n'aa, séd hã m' rakata padëëk nyy d' rabad'oo rahyb n'aa newëë hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ti m' sa seeh, baad Mosees ky n'aa jaw'yyk do hapäh do metyy mä Jesus teaanh doo me. Hahỹỹ d' mä teaanh doo: ");
INSERT INTO mbjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ma matëg —näng mäh. —P'op Hagä Do ky n'aa jaw'yyk do mahang, ny hadoo do tak'ëp ji hyb n'aa jaw'yyk? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ti m' Jesus ky hadoo: —“Taw'ããts hẽ tak'ëp bë kamahǟn Tak'ëp Hyb N'aa Jawyk Doo, P'op Hagä Doo, bë h'yy kaha'eeh doo. Taw'ããts hẽ tak'ëp bë h'yyb padäg ta hã. Taw'ããts hẽ bë h'yyb tym gó naa né hẽ bë kamahǟn ta hã.” ");
INSERT INTO mbjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ti né hẽ P'op Hagä Do ky n'aa jaw'yyk do tak'ëp ji hyb n'aa jaw'yyk doo. Ti né hẽ P'op Hagä Do ky n'aa jaw'yyk doo, tak'ëp ky n'aa jawyk do ta wób bahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hahỹ ta ky n'aa jaw'yyk do seeh, ta ti hadoo né hẽ: “Makamahǟn a da hadoo doo, a hã makamahǟn doo da” —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","—Ji kamahǟn do hã tabana né hẽ sahõnh hẽ P'op Hagä Do ky n'aa jaw'yyk doo, P'op Hagä Do ky n'aa rod raher'oot do paa na-ããj né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Séd hã m' Pariséw rakataa nä bä, Jesus eaanh sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Nyy da bë hã Kristo, P'op Hagä Do H'yyb Däng Doo? Jaa t'aah bë hã? —näng mäh. —Dawi t'aah, Dawi panaa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ti m' Jesus ky hadoo sa hã: —Tii d' tado bä, h'ëëd hyb n'aa, P'op Hagä Do Sahee hejój gó Dawi ber'oot noo gó, ta wahë n'aa tamaneëënh ti Kristo? Ti ỹ wén eaanh, hahỹỹ d' paa Dawi kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Wahë ỹ n'aa hã Tak'ëp Hyb N'aa Jawyk Do ky hadoo: ‘Aso hup ỹỹ hẽnh, si ỹ mabag'ããs hyb n'aa a majĩĩ ỹ nes'ëëm bä kä.’” ");
INSERT INTO mbjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hỹỹ kä, “Wahë ỹ n'aa” Dawi maneëëj bä ti Kristo, nyy da ti ta t'aah tabahadoo? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dooh m' sa kyy péh. Dooh m' reaaj boo bä kä ti bahǟnh kä. H'yyb e'ỹỹm mä reaaj bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ti m' hajõk do sa hã, ta ma matëg hã na-ããj hẽ Jesus ky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Mosees ky n'aa jaw'yyk do ma mehetëk doo, Pariséw na-ããj né hẽ rama metëëk ky n'aa jawyk do ky n'aa ji hã. Ji ramaher'oot ta ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ti hyb n'aa, taw'ããts hẽ bë ky daheeh sahõnh hẽ bë hã ramejũũ doo. Ramejũũ do bë ky dahé né paawä, rabad'oo doo da bë adoo manäh. Ta ti ỹ wén her'oot, dooh rama metëëk doo da rabooh, ta see da rababok. Dooh né raky dahé bä ta wób hã ramejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tak'ëp ramejõ né paawä ji hã, P'op Hagä Do ji h'yyb en'yym hyb n'aa sa hã, tabad'op pé hẽ ji ramasa ramejũũ do ji bahajaa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Ta wób raj'aa etsë hyb n'aa sa hã ti sahõnh hẽ rabahed'oo doo. Gaeh ran'oo bä P'op Hagä Do kyy kerih do bód hood ji maboor hã, ji moo hã ji ahũũ däk doo, ta wób rabahapäh hyb n'aa. Dawëët ran'oo bä ta tyd sa saroor noo hã ragasyyp doo. Rakametëëh do hyb n'aa tii da rawén d'oo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ratsebé do tä n'aa noo gó, ragen'aak ky n'aa etsëëh do rabahetonh bä ratooj bä. Tób P'op Hagä Do panyyg rayd naherot doo bä ragen'aak ratooj bä hyb n'aa jewyk do rabahetonh bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Rakarẽn ji bedëng hajõk do mahang rabahesäm bä. Rakarẽn ji maneëënh “ãã ma matëg”. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Bëëh, bë an'oo manä bë ramaneëënh sa “ma matëg”. Ta tii d' ỹ wén her'oot, jããm né hẽ sét ub bë Wahë N'aa. Bë tii, bë hỹỹj had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Ee” bë maneëëj manä ta wób. Jããm hẽ sét ub bë yb. Hỹ pong jé tabawät tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bë an'oo manä sa h'yyb mahõm n'aa bë tii d' ramaneëëj bä. Ta tii d' ỹ wén her'oot, sét hẽ bë h'yyb mahõm n'aa do hyb n'aa: Kristo, P'op Hagä Do H'yyb Däng Doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bë mahang karẽn pé ta wób sa mahǟnh ky n'aa etsëëh péh, taw'ããts hẽ sa karom hadoo da tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tii d' tawén d'oo, jé kaweh'ëëh doo, kadad'uu däk da P'op Hagä Do an'oo bä. Jé ta daaj hẽ kadaduu doo, kawehëë däk da tii, P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do hã, Pariséw hã na-ããj hẽ Jesus ky hadoo: —Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —Bë gatsë hỹ pong jé hawät do bag'ããs doo, ta bag'ããs do karapee ta wób ranadoo hyb n'aa. Bëëh, dooh bë karẽn bä tabag'ããs do karapee bë do bä. Jé karẽn do hã bë gatsë sa mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do bë h'yyb. Patug tema bong do sa wë hanäng do bë esok. Ti bäp peej hadoo doo me bë ky n'aa etsẽẽ, bë hã ta wób raj'aa etsë hyb n'aa. Ti hyb n'aa ta bahǟnh tak'ëp P'op Hagä Do rajãã da bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —Dawëë, jé pad'yyt hẽ bë ahõm, sét ub né paawä Judah buuj nadoo do bë h'yyb wareem do hyb n'aa, bë ma metëëk do tagadoo hyb n'aa. Tii bä, bë karapee tabahado däk bä kä, tak'ëp nes'aa däg, bë nesaa do bahǟnh däg bë an'oo bä. Bë nemuun tabanesaa hẽnh tabahõm bë an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Baad nado bë hã, sa h'yyb mahõm n'aa ty temah do hadoo! Hahỹỹ da bë ky hetëg: “P'op Hagä Do tób n'aa hã ta see ky dëë bä, te hub né hẽ taky däng do tametëëh hyb n'aa, dooh ji gado bä ti ta tii. K'ããts tëg gabarëëh do P'op Hagä Do tób n'aa yt hã hanäng do hã ji ky dëë bä kä, tii bä dooh tahaja bä ji ky kahỹỹd bä. Ji moo wät né hẽ ji ky däng doo”, näk bë kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","H'yy gatamah doo, ty temah do hadoo na-ããj hẽ bëëh! P'op Hagä Do tób n'aa tak'ëp ji hyb n'aa jaw'yyk k'ããts tëg gabarëëh do ta gó hanäng do bahǟnh. Tii d' tawén hadoo, P'op Hagä Do tób n'aa né hẽ tii, tsyt hẽ P'op Hagä Do wë kasëëw däk hanoo do hyb n'aa k'ããts tëg gabarëëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hahỹỹ d' bë kyyh seeh: “P'op Hagä Do ji ma ejuu do tyng hã ta see ky dëë bä, te hub né hẽ taky däng do tametëëh hyb n'aa, dooh ji gado bä ta tii. P'op Hagä Do ji ma ejuu do tyng jó kan'oo däk do hã ji ky dëë bä kä, tii b' dooh tahaja bä ji ky kahỹỹd bä ji ky däng doo. Ji moo wät né hẽ ji ky däng doo”, näk bë kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","H'yy ganehot do né hẽ bëëh! P'op Hagä Do ji ma ejuu do tyng tak'ëp ji hyb n'aa jaw'yyk ta jó kanoo do bahǟnh. Tii d' tawén hadoo, P'op Hagä Do hã ji ma ejuu do tyng hyb n'aa tsyt hẽ P'op Hagä Do wë takasëëw däk ta jó kan'oo däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","P'op Hagä Do hã ji ma ejuu do tyng hã ky däng doo, sahõnh hẽ ta jó kan'oo däk do hã na-ããj hẽ taky däng. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","P'op Hagä Do tób n'aa hã ky däng doo, ta gó hanäng do hã, P'op Hagä Do hã na-ããj hẽ taky däng né hẽ tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hỹ pong jé hã ky däng doo, P'op Hagä Do bag'ããs do tyng hã taky däng tii. P'op Hagä Do hã, tabag'ããs do tyng jó hasooh do hã na-ããj hẽ taky däng né hẽ tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —Bë waa ty gamabuuj men-ta, anis, komino häd enäh do uuh sii hẽ né paawä bë banoo P'op Hagä Do matym n'aa, dooh paawä bë ky dahé bä tak'ëp ky n'aa jaw'yyk do P'op Hagä Do mejũũ doo. Dooh baad hadoo do bë moo boo bä bë da hadoo do hã. Dooh bë t'yyd mehĩĩn bä bë da hadoo doo. Dooh baad had'yyt hẽ bë h'yy kae bä P'op Hagä Do hã, ỹ hanäng pé tii. Taw'ããts hẽ né paawä P'op Hagä Do hã bë banoo bë wë hanäng do uuh, taw'ããts hẽ dooh bë mabaan bä tak'ëp ky n'aa jaw'yyk do tamejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sa h'yyb mahõm n'aa ty temah do hadoo bëëh! Bë asõõ né paawä bë eëëk doo, ta babo n'aats bë karëëb jëë mahǟnh, nepäh bë hã bë karëëb jëng kameer —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —Ji waa hood ta gó hasus doo, ta jó ub ji hets'yyt do hadoo bëëh. Baad bë babok P'op Hagä Do matym gó ji ed'oo. J'ooj madäk doo me tii. T'õp, bë h'yyb gó, tak'ëp bë karẽn do jawén bë babok. Ta wób sa ma hã bë h'yyb pad'ëëk. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","H'yy ganehot do bë Pariséw. Taw'ããts hẽ paawä pooj jé ta gó bë benäm baad ub bë kanek. Tii bä kä, sahõnh hẽ baad däg —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —Kamag hood hawak doo me rahewyk do hadoo bëëh. J'ooj hẽ tabanäm. T'õp, ta gó, séd dó dajëp do k'yy. Séd dó hasaats jëng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ti hadoo bëëh. J'ooj hẽ, P'op Hagä Do ky n'aa jaw'yyk do ky dah'eeh do bëëh, ji ed'oo. Bë h'yyb gó, j'ooj madäk do had'yyt hẽ bëëh. Heh'äät nado bë h'yyb. P'op Hagä Do ky n'aa jaw'yyk do ky nadah'eeh do bëëh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Baad nado bë hã Mosees ky n'aa jaw'yyk do ma mehetëk doo. Baad nado bë hã Pariséw. J'ooj madäk do ky ken'yym do bëëh! —näng mäh. —P'op Hagä Do ky n'aa rod p'ooj ub habong do sa kamag n'aa hood pä s'ëëb bë tema. Ta hetsó n'aa bë moo bok baad habok do makũ sa kamag n'aa paa bakëë bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hahỹỹ da bë kyyh, ta tii d' bë wén d'oo: “Ãã wahë makũ rababong noo gó ãã aboo bä paawä, dooh paawä ãã masaa bä ãã wahë makũ sa hã P'op Hagä Do ky n'aa rod dej'ëëp doo”, näk bë kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta ti bë her'oot do hã bë hã hẽ bë ky n'aa katepaa. P'op Hagä Do ky n'aa rod dahej'ëëp do sa panaa bëëh, bë nooh. Bë daaj hẽ bë kaher'oot ta ti ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ti b' hãã éh. Bë hajaa nesaa doo, bë wahë makũ du doo do paah! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Aw'yy hadoo bëëh! Aw'yy taah né hẽ bëëh! Nyy da bë ed'oo bë ked'ëëp tabanesaa doo hẽnh bë P'op Hagä Do ky n'aa etyy do mahǟnh? ");
INSERT INTO mbjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Taw'ããts hẽ bë maa newë hahỹỹh: Ỹ mejũũ da bë mahang P'op Hagä Do ky n'aa rod. Ỹ mejũũ da ajyy tak'ëp hajaa doo. Ỹ mejũũ da P'op Hagä Do kyyh ma mehetëk doo. Sa wób bë dej'ëëp da, sa wób bë epëëm da b'aa kajatsëk do hã. Ỹ mejũũ do wób bë hewyyh da tób P'op Hagä Do panyyg bë yd naherot do yt hã. Sa wób bë no n'aa masoo da badäk hahỹ haw'ããts hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ti hyb n'aa bë hã kä P'op Hagä Do anoo da sahõnh hẽ baad habok do badäk hahỹỹ hã radej'ëëp do paa säm baj. Abéw ranabooh noo gó du däk do né hẽ tii. Tii kä tagadëëg ub Sakarija, Berekija t'aah, radaj'ëëp doo kä. Ti bë daj'ëëp paa m' ji ma ejuu do tyng, P'op Hagä Do tób n'aa ganahaang gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Bë hã kä, da hẽ habong do sa hã, P'op Hagä Do anoo da sahõnh hẽ radej'ëëp do säm baj nesaa doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ti m' taky hado kän: —Jerusarẽnh, Jerusarẽnh! A babuuj ranaheb'ooh P'op Hagä Do ky n'aa rod. Pä me ramahek'uut bë wë P'op Hagä Do mejũũ doo, radejëp hyb n'aa. Hajõõ nuu me ỹ karẽn paawä ỹ bataa a babuuj nesaa do mahǟnh ỹ mo n'aa jesuu hyb n'aa sa hã, karaak ta taah ỹỹn ta këg yt hã tata bëëh do mo n'aa me. Tii da ỹ badoo paawä sa hã, dooh tii d' rakarẽn bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","—Bë hegãã da Jerusarẽnh buuj, P'op Hagä Do beréd hõm bë panang. P'op Hagä Do mak'yyts däk bë panang. ");
INSERT INTO mbjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hahỹ hyb n'aa ỹ wén her'oot ta tii: Dooh da ỹ bë hapëë wäd bä kä. Jããm né da p'aa hẽnh ỹ bë bahapäh da bë h'yy kawareem bä, hahỹỹ da bë her'ood bä: “Ky n'aa kedëng tii, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo!” ");
INSERT INTO mbjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ti m' Jesus ratsyym kasok bä m' P'op Hagä Do tób n'aa bä naa, ta ma matëg rabana ta wë, ti m' rametëëh mä ta hã P'op Hagä Do tób n'aa. Anäm mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ti m' Jesus ky hadoo: —Bë hapäh sahõnh hẽ hahỹỹh? Dooh da hahỹ pä ta see jó haso wät pé da. Sahõnh hẽ da rabakud bëëh tũũ. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ti m' waëë joom oriib banäng doo hẽnh Jesus rabahõm kän. Ta tii bä Jesus bahäng bä, sa m'aa hẽnh ta ma matëg rabana ta wë, ti m' raky n'aa eaanh: —Ny noo gó da ti tii d' maher'oot do tadu däk? H'ëëd hado da õm kajaa do heen n'aa, badäk hahỹ bahëëj jëng do heen n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ti m' Jesus ky hadoo sa hã: —Baad bë matakä da bë rawanadii hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hajõk da han'aa ji hã wad'ii doo. Hät ỹỹ gó rabana, sa nooh. “Ỹ Kristo, P'op Hagä Do H'yyb Däng Doo”, näk da sa kyyh. Hajõk da rawedii. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaneb'ooh do ky n'aa bë ky n'aa napäh da. Ti hadoo né hẽ bë eỹỹm manäh. Ti awät né da ta ti hedoo doo. Ti hadoo né hẽ, dooh takaja nä bä badäk hahỹ bahëëj jëng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Häj n'aa see babuuj rakaneb'ooh da häj n'aa see babuuj sa daheeh. Häj n'aa sa wahë n'aa, rah'yy kawereem da häj n'aa see sa wahë n'aa wë. Hajõng häj n'aa bä as'aah da. Hajõng häj n'aa bä k'ããts katajuus da. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sahõnh hẽ tii, badäk hahỹ bahëëj jëng do du däk do metëë n'aa. Ajãn pooj jé ta mahỹỹj ganyyh do hadoo da tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Ti noo gó bë da rahaëënh bë majĩĩ moo gó bë rarejãã, bë radej'ëëp hyb n'aa. Tak'ëp da sahõnh hẽ häj n'aa buuj rakawajããn da bë wë hëp ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hajõk da ti noo gó h'yy gejë hõm doo. Dooh hã ỹ rah'yy kae boo bä da. Ta ti hedoo doo, rahaëënh da sa da hadoo do sa majĩĩ moo gó. Tak'ëp da rakawajããn sa da hadoo do wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hajõk da ti anäng ti noo gó daap men'yyh doo, “P'op Hagä Do ky n'aa rod ỹỹh”, hanäk doo. Hajõk da rawedii. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tak'ëp däg do hyb n'aa nesaa do ti noo gó, hajõk dooh rakamahǟn wäd bä sa da hadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ti hadoo né da, jé h'yy kanerét do hã ỹỹ, tadajëb bä kä, edëb had'yyt hẽ da hỹ pong jé P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hahỹ ji P'op Hagä Do bag'ããs do panyyg hanäm doo, jé pad'yyt hẽ da rabaher'ood hõm, sahõnh hẽ badäk hahỹỹ hã habong do raky n'aa napäh hyb n'aa. Tii bä kä, badäk hahỹ bahëëj jëng do kaja kän da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","—Ti hyb n'aa, nanäng tak'ëp nasaa doo, P'op Hagä Do tób n'aa rejãã doo, P'op Hagä Do tób n'aa rahyb n'aa eréd hõm hanoo doo, tsyt hẽ P'op Hagä Do wë kasëëw däk doo bä tahëë däg bä bë hapëë bä, ta ky n'aa P'op Hagä Do ky n'aa rod Daniéw häd näng do erii wät do paa bë hapëë bä, taw'ããts hẽ Judah häj n'aa bä haj'eenh do rakejën hõm da waëë banäng hẽnh. (Bë hyb n'aa matakä Daniéw erii wät do hã.) ");
INSERT INTO mbjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta ti bë bahapäh bä, taw'ããts hẽ jajé p'op tób gadäk do jó hasooh péh, nayyw hẽ da takejën hõm, dooh da pooj jé tób gó tehëën péh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ti hadoo né da ta joom hood hẽnh hawät doo. Taw'ããts hẽ dooh da tajëë bä ta hatsë tabehëën hyb n'aa paawä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—Tak'ëp tanesaa het'aah doo, sa taah nebii do sa hã kä ti noo gó kä! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—Taw'ããts hẽ bë ky n'aa ets'ẽẽ P'op Hagä Do hã, bë kejën hõm do tabahahëëm noo gó, tak'ëp naëng badoos noo gó tanadoo hyb n'aa, Saab hã tanadoo hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tak'ëp né da ji bahoop ti noo gó. Badäk hahỹ du däk noo gó naa, dooh nä paa ti hadoo pé tak'ëp rabahoop. Ti jawén kä dooh ti tahado wäd bä kä. Ti hyb n'aa da taw'ããts hẽ bë ky n'aa ets'ẽẽ P'op Hagä Do hã, tabahahëëm noo gó, Saab noo gó ta ti tanadoo hyb n'aa, ỹ wén näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","P'op Hagä Do bód gakog hõm da nanäng ji ahoop doo. Tii d' tanado bä paawä, dooh paawä hedëp péh. Ta wë tasëëw hõm do sa hyb n'aa tawén bód gakog hõm ti noo gó rahoop doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Ti noo gó, “Wät hahỹ Kristo, P'op Hagä Do H'yyb Däng Doo”, “Jajé tahawät”, ranoo bä, bë ky dahé manä da raher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta ti ỹ wén her'oot, ti abok da hajõk “Ỹ Kristo” ken'ooh do hyb n'aa. Ti abok né da “P'op Hagä Do ky n'aa rod ỹỹh” ken'ooh doo, noo kanesa doo. Tak'ëp hadoo do ta heen n'aa rametëëh da, rapehuunh da, ta wë P'op Hagä Do asëëw hõm do sii hẽ rawedii hyb n'aa paawä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bë hyb n'aa matakä! Ta pooj jé ỹ baher'ood däk bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Ta wób daap bë rapanäg bä, “Tabanawäng bä tabawät”, ranoo bä, bë ahõm manä t'ĩĩ hẽnh. “Gëët nanäng, tób gawakõ gó”, ranoo bä, bë ky dahé manäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hawyp do wë hã naa jé pad'yyt hẽ ji hapäh do hadoo da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa doo. Sahõnh hẽ da rabahapäh ỹ kajaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wyt ta maab hẽ da ỹ kajaa doo, dajëp do bajat bä wyt ta maab hẽ hadoo doo, kuruj-du ta tii bä rakataa do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ti m' Jesus ky hadoo ẽnh: —Ti noo gó tak'ëp rabahoop do jawén paa bä né hẽ, nayyw hẽ, papỹỹj da badagyb däk. Kamarab da, dooh ta bag nyy wäd bä. Sagõõh wë hã naa kejäk da. Wë hã habong do ta bag keh'ỹỹt da jé pad'yyt hẽ, ta see hedo hõm da P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ti noo gó kä da sahõnh hẽ rabahapäh da Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kaja hyng do metëë n'aa wë puh mahang. Tii bä rah'yy ketón bong da sahõnh hẽ badäk hahỹỹ hã habong doo. Rahapäh da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ỹ bahyng bä wë puh mahang, P'op Hagä Do hejój me, ta bag tak'ëp gabarëëh do hadoo doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ti noo gó ỹ mejũũ da ãs ỹỹ, torõm-bet häd näng do tak'ëp ragamehỹỹh hyb n'aa, ta naëj n'aa. Tii bä da rabataa jé pad'yyt hẽ badäk hahỹỹ hã habong do ỹ asëëw hõm doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ti m' Jesus ky hadoo ẽnh: —Bë hyb n'aa matakä joom wiigo häd näng do ky n'aa hã —näng mäh. —Wiigo tëëg tadu doo bä tagajewäng doo, bë hapäh tabanyyw edaa däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ti hadoo né da, sahõnh hẽ ta ti bë ỹ maher'ood wät do kaja däk bä bë bahapäh bä, edaa däk ỹ kajaa do bë bahapäh da. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Da hẽ habong do rahapäh nä da sahõnh hẽ ỹ her'ood wät do bawäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Badäk hahỹỹh, wë na-ããj da, ahëëj jëë né paawä, këh ỹỹ da dooh tahëëj bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ti m' ahõm nä Jesus her'oot doo: —Dooh d' hapäh pé ny noo gó ta ti bawät. Ããs, hỹ pong jé habok do dooh rahapëë bä. Ỹỹh, P'op Hagä Do T'aah, na-ããj hẽ dooh ỹ hapëë bä. Jããm né hẽ Ee hapäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","P'ooj ub, Nowéh häd näng do hawät noo gó habong doo da né hẽ da rababok da, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sahõnh hẽ tabag'yyp do pooj jé, h'yy kanap'eed gó rababok. Ratsebé do waa n'aa rawa, ratsebé do waa n'aa reëëk. Rakehet'ëë doo da raketëë. Dooh rahyb n'aa peet péh. Tii d' né rabad'oo marakate gó Nowéh rabajëë p'ëë bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dooh rahapëë bä sa pooj jé hawät doo, hag'yyp do kaja kän. Ti m' hag'yyp do kaja kän, dejëb kän sahõnh hẽ. Ti hadoo da Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti noo gó, pawóp hẽ hedoo pé ajyy gëëw gó moo bok doo, sa see da ỹ mahũũm si ỹỹ, ta see da keréd hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pawóp hẽ hedoo pé ỹỹj tiriig ramoo bok doo, sa see da ỹ mahũũm si ỹỹ, ta see da ỹ eréd gëët. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—Ti hyb n'aa baad bë hyb n'aa matakä da, baad bë gadaa. Dooh bë hapëë bä ny noo gó Tak'ëp Hyb N'aa Jawyk Doo, bë h'yy kaha'eeh do kajaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bë hyb n'aa newë hahỹ panyyg gó bë ỹ maher'oot doo: Tób danäh hapëë bä paawä nyy b' akëë atsëm hets'ëëk do kajaa, baad paawä tamatakëë, baad paawä tagada. Dooh paawä tan'oo bä hets'ëëk do ta tób tanoo eë nä bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ti hadoo bë hã. Taw'ããts hẽ baad bë hyb n'aa matakä, baad bë gadaa ta pooj jé. Ta ti ỹ wén her'oot, bë ganadaa bä Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa da p'aa hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Ti hyb n'aa, jaa bë mahang ta kaser n'aa baad had'yyt hẽ ta kariw n'aa mejũũ do moo wät do hadoo? Jaa bë mahang ta kaser n'aa h'yy ganäng do hadoo doo, ta hã ta kariw n'aa hanoo do ta wób tabahag'ããs hyb n'aa, ta ǟh had'yyt hẽ baad ta wób sa waa tabetsëëh hyb n'aa sa hã, ta s'ee hẽnh ta kariw n'aa awäd nuuj jé? ");
INSERT INTO mbjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Taw'ããts hẽ ta kaser n'aa hã, ta kariw n'aa awyyd bä tamejũũ do hã moo wät doo, ta kariw n'aa matëëh bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta kariw n'aa weh'ëëh da ta ti hadoo doo. Sahõnh hẽ tahaëënh ta hã ta ma, ta ma hagã n'aa tabahado däk hyb n'aa kä. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hỹỹ kä, baad ta kaser n'aa moo nawäd bä paawä, ta h'yyb gó taky hado bä: “Dooh nayyw hẽ kariw ỹ n'aa kaja bä”, tanoo bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","karom wób tahewyh had'yyt bä kä, tadu do bä jarakë he'ëëk do sii tawa bä, teëg bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ti taganada bä né kä ta kariw n'aa kajaa da. Tahyb n'aa napeet bä kä takajaa. ");
INSERT INTO mbjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tii bä tak'ëp da ta kariw n'aa rejã kän da. Tanoo da ta kaser n'aa paa ahoop j'ooj madäk doo me, ky ken'yym doo gó habok do nesaa do rabahoop doo da. A'oot da tii bä. Sa tëg kamegëëj däk da tii bä tak'ëp nesaa do rahoop do hyb n'aa —näng mä Jesus takajaa do pooj jé ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ti m' Jesus ky hadoo ẽnh: —Hahỹ panyyg ky n'aa hadoo hỹ pong jé hawät do bag'ããs do ky n'aa Aj'yy Hadoo Do Hỹ Pong Jé Hana Do matëëh noo gó: Atsëm ji moo sahõnh hẽ maruus rabahõm sa najiis patug pan'aa hã rakataa hyb n'aa ta ỹỹm pan'aa tabehëën hẽnh. Sa moo gó sa bag rapatsëë. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sa wób, ji ma poo oow péh, h'yy gatemah. Ta wób h'yy genäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","H'yy gatemah doo, sa bag ramahũũm né paawä, dooh m' ramahũũm ta syyj sa bag waa. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","H'yy genäh do ti ramahũũm sa bag waa. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tii bä, nayyw hẽ sa najiis patug pan'aa kanajaa do hyb n'aa, ji moo sahõnh hẽ hadoo do raty jewyk, tii b' rabaǟ jëk. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Tii bä atsëm ub rë tanyy naëënh: “Wät ta ti ta patug pan'aa!”, näng. “B'ëëp, bë gado!”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Tii bä maruus raty gewëëj padëëk. Ti raty enäm sa bag hõ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ti h'yy gatemah do raky hadoo h'yy genäh do sa hã: “Na bë bag waa uuh. P'eets hẽ tabahänh ãã bag waa”, näk. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—“Dooh”, näk ta wób, “ãã bag waa uuh ãã an'oo bä bë hã, dooh da tahaja bä tii bä”, näk. “Bë ahõm nä ji bag waa rabahesäm hẽnh ta waa bë betsẽẽ hyb n'aa” —näk. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Ti rabahõm nuuj jé sa bag waa hets'ẽẽ doo, takajaa sa najiis patug pan'aa. Tii bä maruus baad gad'aa do rabahõm kän ta sii. Ket'ëë do jäm hẽnh rabahõm ta sii. Tii bä noo gatsëë däk jäm tób n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Ta jawén rakaja kän hets'ẽẽ doo. “Ãã wahë n'aa, manoo gasëëts tób ãã bajëë p'ëë hyb n'aa”, näk. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Tii bä jäm noo gana do ky gadoo: “Né hup ỹ né hẽ tii, dooh bë ỹ hapëë bä”, näng jäm noo gana doo —näng mä Jesus panyyg gó teh'ũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ti m' Jesus ky hado kän: —Ti hyb n'aa, baad bë gadaa ta pooj jé, bë nahapäh do hyb n'aa ny noo gó ỹ matëëh. Dooh bë hapëë bä nyy b' akëë ỹ kajaa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ti m' Jesus ky hadoo ẽnh: —Hahỹ panyyg ky n'aa hadoo na-ããj hẽ hỹ pong jé hawät do bag'ããs do ky n'aa, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa noo gó. Aj'yy dawëë tabahõm do pooj jé ta dajẽẽr ta karom hã tets'ëë hõm do rabahag'ããs hyb n'aa ta s'ee hẽnh tawäd nuuj jé hadoo tii. Tabahõm do pooj jé, aj'yy naëënh ta karom ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ta see hã tabanoo ji ma poo oow pé ta hood moweed k'ããts tëg gabarëëh do s'ëëb. Ta see hã tabanoo pawóp hẽ ta hood, ta see hã sét hẽ. Rahajaa do pénh ramoo bok doo, tets'ëë däk sa hã. Ti tabahõm kän dawëë. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tii bä nayyw hẽ ji ma poo oow pé gadoo do du do kän ta tii me tamoo wät doo, dajẽẽr kah'ũũm hyb n'aa. Ti hyb n'aa, ji ma poo oow pé jó tagadoo ji ma poo oow pé wób. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tii d' né hẽ pawóp hẽ dajẽẽr hood gadoo do bad'oo. Pawóp hẽ hadoo do jó tagadoo pawóp hẽ ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tii d' nado sét gadoo doo. Ta kariw n'aa dajẽẽr tagadoo do jawén paa bä tabahõm, ti tadakä jëng ta dajẽẽr. Séd debaa hẽ tabado nyyh ta kariw n'aa matëëh bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Tii bä hajõõ ta baab jawén paa bä sa kariw n'aa kaja kän. Tii b' tanaëënh ta wë ta karom dajẽẽr tahanoo do paah, tabahapäh hyb n'aa nyy da rabad'oo ti dajẽẽr kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ji ma poo oow pé dajẽẽr hood gadoo do ky hadoo ta hã: “Kariw ỹ n'aa”, näng, “ji ma poo oow pé ta hood man'oo däk hã ỹỹ, ta tii me ỹ moo wät hyb n'aa”, näng. “Mahegãã. Ta jó ỹ gado däk ji ma poo oow pé ta hood wób gedẽ hõm doo”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Ti ta kariw n'aa ky hadoo: “Taw'ããts hẽ mamoo wät doo. Karom baad hadoo do õm. Baad had'yyt hẽ maban'yyh a hã ji anoo doo”, näng. “Kanahën d'os hẽ né paawä, baad maban'yyh. Ti hyb n'aa ti bahǟnh ỹ anoo a hã hỹỹ kä mabag'ããs hyb n'aa kä. B'ëëp, tsebee si ỹỹ”, näng ta kariw n'aa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Tii bä pawóp hẽ dajẽẽr hood gadoo do ky hadoo: “Kariw ỹ n'aa”, näng, “pawóp hẽ ta hood man'oo däk hã ỹỹ, ta tii me ỹ moo wät hyb n'aa”, näng. “Mahegãã. Ta jó ỹ gado däk pawóp hẽ ta hood wób gedẽ hõm doo”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Ti ta kariw n'aa ky hadoo: “Taw'ããts hẽ mamoo wät doo. Karom baad hadoo do õm. Baad had'yyt hẽ maban'yyh a hã ji anoo doo”, näng. “Kanahën d'os hẽ né paawä, baad maban'yyh. Ti hyb n'aa ti bahǟnh ỹ anoo a hã hỹỹ kä mabag'ããs hyb n'aa kä. B'ëëp, tsebee si ỹỹh”, näng ta kariw n'aa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Ti ta karom seeh, sét dajẽẽr hood gad'ẽẽ däk do gadoo do tabana, ti taky hadoo: “Kariw ỹ n'aa”, näng, “tak'ëp mamejũũ ji hã, hëp ỹỹ. Manu gekãã joom ag manejoom doo. Joom ag manejoom do mataa. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ti hyb n'aa õm ỹ jeỹỹm”, näng. “Tii bä k'ããts gó ỹ jeh'aa këë a dajẽẽr”, näng. “Hỹỹh, a dajẽẽr hã ỹ manoo do paah”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—Ti ta kariw n'aa ky hadoo: “Karom nesaa do õm! Moo nahũũj õm!”, näng. “Mahapäh mä a nooh, joom ag ỹ nejoom do ỹ nu gekãã, näng a kyyh. Joom ag ỹ nejoom do ỹ bataa, näng a kyyh”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Hëd n'aa dajẽẽr manan'oo däk dajẽẽr me moo heb'ooh do sa hã? Tii bä kä, ỹ kajaa bä kä, ta bahǟnh ỹ gadoo paawä dajẽr ỹỹ”, näng ta kariw n'aa ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Ti sa kariw n'aa ky hadoo: “Bë ado hõm sét hadoo do ta wë hanäng doo. Bë an'oo ji moo sahõnh hẽ wë näng do hã”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Jé wë näng do hã, ti bahǟnh takan'oo däk ta hã. Hajõng da anäng ta wë. Kanahën d'os hẽ wë näng doo, kanahën d'os do ta wë hanäng do kado hõm da ta mahǟnh”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Bë dawäts nä ta w'oo hã gadagyp doo hẽnh karom nahũũnh doo. A'oot da tii bä. Sa tëg kamegëëj däk da tak'ëp nesaa do rahoop do hyb n'aa”, näng sa kariw n'aa kyyh —näng mä Jesus panyyg gó teh'ũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ti m' Jesus ky hadoo ẽnh: —Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ta kabaj'aa doo gó, ta bag tak'ëp gabarëëh doo gó sahõnh hẽ ããs sa daheeh tabahyng bä kä, sa wahë wahë tyng n'aa jó, tsyt hẽ kasëëw däk do tyng n'aa jó tabasooh da. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tii bä sahõnh hẽ badäk hahỹỹ hã habong do rakata padëëk da ta wë tan'oo bä. Tii bä tsyt hẽ tabasëëw hõm da sa mahang, b'éé hagã n'aa tsyt hẽ tabasëm doo da b'éé kabara mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hub hẽnh tabasëëw hõm da b'éé, s'ỹỹ hẽnh da kabara. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tii bä ta bagã n'aa ky hadoo da ta hub hadäk hẽnh hab'ëëh do sa hã: “B'ëëp bëëh, Ee ky n'aa edëng doo. Bë gado badäk hahỹ tadu dahäng noo gó naa bë hyb n'aa tenyyw hõm doo, ta bag'ããs doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bë ỹ wén ts'yyt, ỹ paa asaah, wa ỹ paa bë anoo hã ỹỹ. Ỹ paa hoo kaanh, bë anoo paa naëng ỹỹ. Ta s'ee hẽnh naa paa ỹỹh, bë gadoo paa ỹ bë tób bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ỹ paa saroor tamaah, bë anoo paa saror ỹỹ. Ỹ paa nahëë näng, bë heg'ããs paa ỹỹh. Ragadahew'ëës doo gó paa ỹ bagëët, ỹ paa bë hehëën”, näng da ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Tii bä baad habok do reaanh da ta hã: “Tak'ëp Hyb N'aa Jawyk Doo, ny noo gó ãã bahapäh mabasaah doo, ny noo gó a waa ãã banoo? Ny noo gó mahoo kaanh, a naëng ãã banoo? ");
INSERT INTO mbjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ny noo gó ta s'ee hẽnh naa õm ãã bahapäh, õm ãã gadoo? Ny noo gó õm saroor tamaah, õm ãã saroor noo? ");
INSERT INTO mbjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ny noo gó õm ãã bahapäh manahëë näng doo, radawäts gëët do õm? Ny noo gó õm ãã bahehëën?”, näk da baad habok do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Tii bä ta bagã n'aa ky hadoo da hahỹỹ da: “Baad bë ỹ maher'oot hahỹỹh: Sahõnh hẽ hǟj ỹ hedoo do hã, hã ỹ h'yy ka'eeh do hã bë bad'oo do paah, rahyb n'aa sekog its né paawä, hã ỹ né hẽ ti tii d' bë bad'oo doo. Né hup ỹ né hẽ ta ti ỹ her'oot doo”, näng da ta bagã n'aa baad habok do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Tii bä ta s'ỹỹ hẽnh hab'ëëh do sa hã taky hadoo da: “Bëëh, ky n'aa kawas'ee bong doo, bë ahõm mahǟnh ỹỹ tëëg hõõ nadëëk doo hẽnh, Dijab, ããs nesaa do Dijab karom sa daheeh sa hyb n'aa P'op Hagä Do benyyw däk doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","T'ĩĩ hẽnh bë wén hõm, ỹ né asaah paah, dooh paa wa ỹ bë an'oo bä. Ỹ paa hoo kaanh, dooh paa naëng ỹ bë an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ta s'ee hẽnh naa paa ỹỹh, dooh paa ỹ bë gado bä bë tób bä. Ỹ paa saroor tamaah, dooh paa saror ỹ bë an'oo bä. Ỹ paa nahëë näng, ragadahew'ëës doo gó paa ỹ bagëët, dooh paa ỹ bë hegãã bä”, näng da ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Tii bä kä, ti na-ããj da reaanh da. Hahỹỹ da da sa kyyh: “Tak'ëp Hyb N'aa Jawyk Doo, ny noo gó paa õm ãã bahapäh mabasaah doo, mahoo kaanh doo, ta s'ee hẽnh naa do õm, saroor tamah do õm, manahëë näng doo, ragadahew'ëës doo gó mabagëët doo? Ny noo gó õm ãã manasa?”, näk da sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tii d' taky hadoo: “Baad bë ỹ maher'oot hahỹỹh: Hahỹ hyb n'aa sakog its do see hã bë manasa doo, ỹ né hẽ ti bë manasa. Né hup ỹ né hẽ ta ti ỹ her'oot doo”, näng da ta bagã n'aa baad nabok do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Tii bä, ah'ũũm da rahoop do had'yyt doo hẽnh. Baad habok doo, dooh t'ĩĩ hẽnh rahõm bä. Hỹ pong jé ji edëb had'yyt do ragadoo tii hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ti m' Jesus bahajaa bä sahõnh hẽ ta ti taher'oot doo, taky hadoo mä ta ma matëg sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Bë hapäh, edaa däk Pas-kowa. Pawóp nä ta ǟh. Ti noo gó Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ran'oo däk da ta majĩĩ sa moo gó b'aa kajatsëk do hã takepëëm däk hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj sa wahë n'aa na-ããj mä séd hã m' rakata padëëk P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do tób bä. Kajapas mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do häd. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ti m' ratyw n'aa esoos mä Jesus ramoo maso hõm hyb n'aa ta wób raky n'aa nanapäh bä m', radaj'ëëp hyb n'aa kä m'. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rakaner'oot bä m' raky hadoo: —Dooh da ër dajëëb bä Pas-kowa noo gó, hajõk do ër wë rah'yy kawereem mahǟnh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ti m' panang Betanija häd näng doo bä m', Simaw saraa hã däk do paa tób bä, ");
INSERT INTO mbjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","sa waa tyng hã m' Jesus basooh bä m', ana mä ta wë ỹỹnh. Buu benyym do hood mä ta moo gó m' tabadäk. Pä s'ëëb mä ta hood. Tak'ëp mä taky n'aa gebah ta ti gó hanäng do buu benyym doo. Ti m' Jesus nuu gó m' tabahah'ook. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dooh m' Jesus ma matëg ragenaag bä ta ti tabad'oo doo. —Hëd n'aa tarejãã tii? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—Taw'ããts hẽ paawä takes'ëëm. Tak'ëp paawä ji ky n'aa geb'aah. Ta säm ji an'oo paawä kas'uut do sa hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus maa napäh bä sa kyyh, taky hadoo: —Bë hajẽẽw manä hahỹ ỹỹnh! Tak'ëp baad hadoo do tamoo wäd wät hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kas'uut do aboo had'yyt hẽ bë mahang. Ỹ ti hỹỹh, dooh bë mahang had'yyt hẽ ỹ awäd wäd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ỹ radakä jëng noo gó buu benäw n'aa tii d' nuh ỹỹ gó tah'ook doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Jé pad'yyt hẽ badäk hahỹỹ hã P'op Hagä Do T'aah panyyg hanäm do rabaher'ood hõm bä, raher'oot da na-ããj hẽ hã ỹ tamoo wäd wät do ky n'aa, ji hyb n'aa esee hyb n'aa ta hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ti m' 12 hedoo do Jesus ma matëg seeh, Judas Ikarijot häd näng do bahõm P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ti m' taky hadoo sa hã: —Nyy hẽ ta säm bë anoo da hã ỹỹ, Jesus ỹ haëëj bä bë hã? —näng mäh. Ti m' ranoo ta hã 30 moweed k'ããts tëg hawak do s'ëëb ta säm. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti m', ti noo gó naa Judas Ikarijot tyw n'aa esóts kän tabahaëënh hyb n'aa kä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti m' pãw makuj n'aa tamah do rataheb'ëës do du däk noo gó m', Jesus ma matëg rabana ta wë, ti m' rabeaanh ta hã: —Nyy bä makarẽn ãã benäm Pas-kowa tä n'aa, matab'ëës hyb n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ti m' taky hadoo: —Bë ahõm nä panang hẽnh, aj'yy tób hẽnh. Hahỹỹ da da bë maher'ood ta hã: “Hahỹỹ da ãã ma matëg kyyh a hã, ‘Kaja däk ỹ hajaa do noo gó ỹ jawén hyng doo. A tób hẽnh da ỹ tab'ëës Pas-kowa tä n'aa ma matëk ỹ sa daheeh’”, näk da bë kyyh —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesus mejũũ doo da né hẽ m' ta ma matëg rabad'oo. Ti m' ramoo boo kän tii bä kä Pas-kowa tä n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Papỹỹj badëë hyng bä kä, Jesus bahyy sooh mä 12 hedoo do sii hẽ sa waa tyng pa. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa tä rabawëh bä kä m' taky hadoo sa hã: —Bë see ỹ tahaëënh da majĩĩ moo gó. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ti m' rah'yy ketón bong. Ti m' sét ken'yyh mä raky hadoo: —Hã ỹỹ, dooh ỹ tado bä Tak'ëp Hyb N'aa Jawyk Doo! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ti m' Jesus ky hadoo: —Bë see né da. Nemon ỹ hehoots wät do pãw, ti né da ỹ haëënh doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da dajëp P'op Hagä Do kyy kerih do her'oot doo da né hẽ —näng mäh. —Ti hadoo né hẽ, baad nado da aj'yy hã, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do majĩĩ moo gó han'oo däk do hã! Taw'ããts hẽ paawä ta ti aj'yy hã tanenyyts bä paawä! —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ti m' Judas, Jesus haëëj däk do pan'aa, ky hadoo ta hã: —Hã ỹỹ, dooh ỹ tado bä ma matëg! —näng mäh. Ti m' Jesus ky gadoo: —A daaj hẽ ti makaher'ood däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ti m' rabawëh bä, Jesus bado däk pãw, ti m' P'op Hagä Do hã taky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk pãw ãã hã —näng mäh. Ti m' taganabäh däk pãw, tan'oo däk mä ta ma matëg sa hã. Ti m' taky hadoo: —Bë gado däg, bë awa. Hup ỹ heen n'aa hahỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ti m' Jesus bado däk uwa bëëh hood, ti m' P'op Hagä Do hã ta ky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk uwa bëëh ãã hã —näng mäh. Ti m' tan'oo däk mä sa hã, ti m' taky hadoo: —Bë sahõnh hẽ, bë eëg ta uuh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","—Majyw ỹỹ ỹ anoo do ỹ dajëp noo gó heen n'aa hahỹỹh. Papuuj sahõnh hã P'op Hagä Do ky n'aa enooh do tii kä. Hỹ jawén majyw ỹ hyb n'aa ji tagadoo P'op Hagä Do ky däng. Hajõk do sa hyb n'aa takan'oo däk majyw ỹỹ, ỹ dajëp noo gó, nesaa do sa h'yyb gó hanäng do kawug hõm hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Hahỹỹ d' bë ỹ maher'oot: Hỹ jawén dooh ỹ eëg wäd bä hahỹ uwa s'ëëb. Jããm hẽ p'aa hẽnh papuuj däg ỹ eëëk da bë sii Ee bag'ããs doo bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ti m' Saaw-Mo hã hanäng do see me P'op Hagä Do rama ejäm do jawén paa bä m', rabahõm kän waëë joom oriib häd näng do banäng hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ti m' Jesus ky hadoo sa hã: —Badah, atsëm, hã ỹ rabad'oo do bë bahapäh bä, bë sahõnh hẽ da ỹ bë beréd hõm —näng mäh. —Hahỹỹ da takerii däk P'op Hagä Do kyy kerih do hã ti ky n'aa: “B'éé hagã ỹ daj'ëëp da. Tii bä da jé pad'yyt hẽ b'éé rabehũũm bong” —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ti m' Jesus ky hadoo ẽnh: —Ta tii d' né paawä da hã ỹỹ, ỹ ganä wät jawén paa bä da, bë pooj jé da ỹ bahõm Garirej hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ti m' Peed ky hadoo: —Sahõnh hẽ õm reréd hõm bä, a wë ramoo bok do rabahapäh bä, ỹ ti dooh noo gó õm ỹ eréd bä —näng mä Peed. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ti m' Jesus ky hadoo ta hã: —Badah né hẽ, atsëm, karaak bahỹỹh do pooj jé, tamawoob nuu me da ỹ maky n'aa jejën da. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ti m' Peed ky kah'ũũm mä ta hã: —Dooh! —näng mäh. —Ỹ radajëëb bä na-ããj hẽ a sii, dooh noo gó da õm ỹ hyb n'aa eréd bä! —näng mäh. Ti ky hedoo né hẽ m' Jesus ma matëg wób. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ti m' ta ma matëg daheeh Jesus bahõm joom banäng hẽnh Getsemani häd näng doo hẽnh. Ti m' taky hadoo sa hã: —Babä bë ayyw dó jajé ỹ ky n'aa ets'ẽẽ nuuj jé —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ti m' Peed, Sebedew taah pawóp hadoo do daheeh tamahũũm ta sii dawë hã. Ti m' Jesus h'yyb gó tak'ëp mä tah'yy katón wät. Dooh baad tado wäd bä ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ti m' tamawoob hẽ hadoo do sa hã taky hadoo: —Tak'ëp ỹ h'yy katón. Ỹ h'yyb dajëp do hadoo —näng mäh. —Babä bë ayyw. Bë matakä si ỹỹ. Bë aǟ manä da! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ti m' tabahõm dawë hã. Ti m' ta taron nu paa me tabahyy häng, tũũ m' ta maboor hyy jat, ti m' taky n'aa etsẽẽ P'op Hagä Do hã. Hahỹỹ da m' ta kyyh: —Ee —näng mäh. —Tahaja bä paawä, mado hõm mahǟnh ỹỹ wät hahỹ ỹ ahoop do pan'aa. Ta tii d' né ỹ bets'ẽẽ paawä, makarẽn doo d' né hẽ mabad'oo, ỹ karẽn doo da nado —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tabana bä m' ta ma matëg tamawoob hẽ hadoo do rahab'ëëh hẽnh, taheg'ããs mäh, aǟ b'ëëh mäh. Ti m' Peed hã tabeaanh: —Dooh bë haja bä kanahën d'os hẽ bë ty gapadäg bä si ỹỹ? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—Bë matakä, P'op Hagä Do hã bë ky n'aa ets'ẽẽ, nesaa do h'yyb natatuk hyb n'aa bëëh, ỹ bë eréd hõm mahǟnh —näng mäh. —Ji h'yyb karẽn né paawä baad hadoo do ji moo wät, nahejooj ji, ti hyb n'aa bë ky n'aa ets'ẽẽ ỹ wén näng —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ahõm ẽnh mä p'aa hẽnh, ti m' taky n'aa etsẽẽ ẽnh p'aa hẽnh. Hahỹỹ d' mä ta kyyh: —Ee —näng mäh. —Tanahaja bä ỹ ahoop do pan'aa kado hõm mahǟnh ỹỹ, ỹ mamo n'aa najesu bä ta mahǟnh, tii bä, makarẽn doo da né hẽ ỹ karẽn hã ỹ kametëëh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ti m' p'aa hẽnh tabana bä ẽnh, aǟ b'ëëh ẽnh mäh, tak'ëp mä raty jewyk sa h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ahõm ẽnh p'aa hẽnh, taky n'aa etsẽẽ do paa taky n'aa etsẽẽ ẽnh p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ti m' tamatëëh ta ma matëg tamawoob hẽ hadoo do wë, ti m' taky hadoo sa hã: —Bë kameh'ããk nä? Bë aǟ magyys hẽ? —näng mäh. —Bë hegãã. Edaa däk Aj'yy Hadoo Do Hỹ Pong Jé Hana Do nesaa do moo heb'ooh do sa moo gó rabahaëëj däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bë as'ëëg bëh! Hamäh, ër ah'ũũm! Wät ta ti ỹ han'oo däk do majẽ ỹỹ hã —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus ber'oot nä bä m', takajaa Judas, 12 hedoo do see paah. Hajõk mä han'aa ta sii. Sẽn-jeer yt hã m', boh yt hã m' rabana. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa kyy gó m', Judah buuj sa wahë n'aa hedoo do sa kyy gó m' na-ããj hẽ ti rabana. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Haëënh doo, baad ub mä taky n'aa her'ood däk. Hahỹỹ da m' ta kyyh sa hã: —Ta ti ỹ tapa tsanetsup doo da, ti né hẽ tii. Tii d' bë maso däk, bë maso hõm —tii da m' ta kyyh dó sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ti m' nayyw hẽ Judas bana Jesus wë, ti m' tedëng: —Taw'ããts hẽ õm, ma matëg? —näng mäh. Ti m' ta tapa tsanetsup mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ti m' Jesus ky hadoo Judas hã: —Ti bä, mamoo wäd ti majawén na doo, najis ỹỹ —näng mäh. Ti m' ta hã rakajäk, ramaso däg kän mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ti m' Jesus hata see bado däk ta sẽn-jeer, tekyyt mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom. Ta nabuuj gakyd hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ti m' Jesus ky hadoo ta hã: —Menyyw däg a sẽn-jeer —näng mäh. —Sẽn-jeer me ta wób hekyyt doo, sẽn-jeer me tadajëp. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ỹ nahaja med'oo, ỹ karẽn bä paawä, Ee hã ỹ ky n'aa etsẽẽ 12 ken'yyh kata däk do tak'ëp kanekan do ããs nayyw hẽ tamejũũ hyb n'aa, ỹ ramo n'aa jesuu hyb n'aa? ");
INSERT INTO mbjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tii d' tado bä paawä, ỹ ramo n'aa jesu bä paawä, dooh paawä takaja bä tii bä P'op Hagä Do kyy kerih doo, hahỹ né hẽ kametëëh doo kä hã ỹ taher'oot doo —näng mä Jesus ta ma matëg hã, sẽn-jeer hado däk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ti m' hajõk do hã kä Jesus ky hadoo: —Ër wahë n'aa wë h'yy kawereem do sa h'yyb mahũũm n'aa bë ed'oo g'eeh ỹỹh, bë wén n'aa wë ỹỹ sẽn-jeer yt hã, boh yt hã, ỹ bë masoo hyb n'aa? —näng mäh. —P'op Hagä Do tób n'aa wahoo gó ỹ awäd had'yyt hẽ ỹ ma metëëk bä. Dooh ẽnh ỹ bë maso bä tii bä ẽnh? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","—Hỹỹ kä, taw'ããts hẽ —näng mäh. —Ỹ hapäh, sahõnh hẽ tii da tawén hadoo, P'op Hagä Do ky n'aa rod rerii bong do paah, hã ỹ kametä däk hyb n'aa —näng mä Jesus. Ti m' sahõnh hẽ kä ta ma matëg rawaj'aa bong. Reréd hõm mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti m' Jesus ramaso däk do ramahũũm kän Kajapas häd näng do tób hẽnh. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do ti Kajapas. Kata b'ëëh mä ta tii bä Mosees ky n'aa jaw'yyk do ma mehetëk doo, Judah buuj sa wahë n'aa hedoo do sii hẽ m'. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peed bahõm mä Jesus sa jawén. Dawëë m' tagadäk. Ajëë suun mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do tób w'oo hã. Ti m' warahén sa pa m' tabahyy häng, tabaheg'ããs hyb n'aa nyy d' rabad'oo Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa hedoo doo, sahõnh hẽ Sinedirijo häd näng do ajyy n'aa sii hẽ m' resoos mä Jesus hã rap'ãã daj'ëëp péh. Resoos mä daap hẽ Jesus raky n'aa tapaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hajõõ né paawä m' daap ramenyyh Jesus ky n'aa hã, dooh m' raw'yyt pé rap'ãã daj'ëëp pé Jesus. Ti m' tagadëëg ub kä pawóp hẽ han'aa, ");
INSERT INTO mbjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ti m' raky hadoo: —Hahỹỹ da hahỹ aj'yy kyyh: “Ỹ hajaa ỹ gawatsiig hõm bä P'op Hagä Do tób n'aa”, näng. “Tamawoob hẽ ta ǟh, ỹ tamaa sooh p'aa hẽnh”, näng ta kyyh —näk mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do p'op mä tabas'ëëg gëët. Ti m' taky hadoo mä Jesus hã: —Dooh maher'oot pé õm raky n'aa tapaa do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dooh m' Jesus ky gado bä. Bag hẽnh mä tabagëët. Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do ky hadoo ẽnh mä ta hã: —P'op Hagä Do hedëb had'yyt do matym gó kä õm ỹ mejũũ, ãã mamaher'oot hyb n'aa ti Kristo, P'op Hagä Do H'yyb Däng Doo, P'op Hagä Do T'aah mado bä! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ti m' Jesus ky hadoo: —Õm né tii, ti tii d' her'oot —näng mäh. —Ti hadoo né hẽ, hahỹỹ da bë sahõnh hã ỹ maher'oot: Hỹ jawén bë hapäh né da Aj'yy Hadoo Do Hỹ Pong Jé Hana Do, Sahõnh Sa Bahǟnh Hado Do hub hẽnh tabasooh bä, ta hã P'op Hagä Do weh'ëëh doo bä. Bë hapäh né da ẽnh tabahyng bä wë puh mahang —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do kawaj'ããn gó tawén s'ẽẽd hõm ta daaj hẽ ta saroor. Ti m' taky hadoo: —P'op Hagä Do taky n'aa rejã däk! Jããm hẽ. Dooh hyb n'aa wät pé ta ky n'aa her'oot péh. Bë maa napäh né hẽ ta kyyh, P'op Hagä Do taky n'aa rejãã doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nyy da bë hã? —näng mäh. —Taw'ããts hẽ tadajëp! —näk mä ta wób sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ti m' ta mamets rabahetsoos, ti m' rabetuu sa moo me. Ta wób ratapa ewyyh mäh, ");
INSERT INTO mbjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ti m' raky hadoo ta hã: —Maher'ood mahapëë bä, Kristo, jaa mo haj'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ti noo gó, tób w'oo hã Peed bahäng bä, tób danäh karom ỹỹnh ana ta wë, ti m' taky hadoo: —Õm na-ããj hẽ Jesus Garirej buuj sii hawät doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ti m' Peed ky n'aa jejën wät sahõnh hẽ sa matym gó. —Dooh ỹ heen n'aa nyy bä ta ti maher'oot doo —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ti m' Peed bahõm ta hadë noo bä. T'ĩĩ hẽnh tób danäh karom ỹỹnh see bahapäh bä m', taky hadoo sa pa hab'ëëh do sa hã: —Jesus Nasaréh buuj sii hawät do hahỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ti m' Peed jejën ẽnh mä p'aa hẽnh. P'op Hagä Do hã m' taky däng, raky daheeh hyb n'aa paawä: —Dooh ỹ hapëë bä ta ti aj'yy —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ti noo gó né hẽ badawëd däk mäh, ta pa hab'ëëh do p'op raky hadoo ta hã: —Sa hata see né hẽ õm —näk mäh. —Garirej buuj raber'oot doo da né hẽ ti maber'oot —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ti m' Peed ta daaj hẽ taky n'aa kawas'ee kän. Ti m' P'op Hagä Do hã taky däng: —Dooh ỹ hapëë bä ta ti aj'yy! —näng mä ta kyyh sa hã. Ti m' nayyw hẽ m' karaak bah'ỹỹ kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tii bä m' Peed hyb n'aa newë däk Jesus her'oot do paa kä ta hã: “Karaak bahỹỹh do pooj jé, tamawoob nuu me ỹ maky n'aa jejën da.” Ti né paa kä m' Jesus her'oot do paa kä ta hã. Ti m' Peed banyyh wahoo gó naa. Tak'ëp tabaód g'ëëd kän mä taky n'aa jejën do hyb n'aa Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bäp paa m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj wahë n'aa wób, rahyb n'aa eno däk Jesus radaj'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ramoo maw'yyd däk, ramahũũm Pirato häd näng do wë, Roma buuj Judah häj n'aa bä bag'ããs doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ti m' dajëb hã Jesus raky n'aa ety däk do Judas, Jesus haëëj däk do ky n'aa napäh bä m', t'yyd kamehĩĩn wät mä tamoo wät do paa hã. Ti m' moweed k'ããts tëg hawak do s'ëëb tabaj hõm P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, sa wahë n'aa wób hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Nesaa do ỹ moo wäd wät —näng mä sa hã. —Mo haj'aa kad'oo do nado dajëb hã ỹ haëëj däk doo —näng mä Judas kyyh sa hã. Ti m' sa wahë n'aa hedoo do raky gadoo: —Dooh hyb n'aa ãã hyb n'aa peet pé ta tii. A ky gabuuj hẽ ti ta tii —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ti m' Judas dawäts bëëh tũũ moweed P'op Hagä Do tób n'aa yt hã, ti m' tabahõm kän, nu kasagĩĩw däk mä tyd me. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa rabata däk moweed tũũ kajäk doo, ti m' raky hadoo: —Dooh ër ky n'aa jaw'yyk do an'oo bä P'op Hagä Do tób n'aa dajẽẽr n'aa tabahado däk hyb n'aa hahỹ dajẽẽr. Majyyw dajẽẽr n'aa ti hỹỹh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ti hyb n'aa m' rahyb n'aa newë däk ramametsẽẽ hyb n'aa hew'yyt do joom banäng doo, Judah buuj nadoo do kamag kadebong do pan'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ti hyb n'aa, da hẽ na-ããj nä ta häd ramaneëënh “ta majyyw hood”, hew'yyt do joom hood paah. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tii d' né kä m' kametä däk P'op Hagä Do ky n'aa rod Jeremiij häd näng do erih do paa kä. Hahỹỹ d' paa m' ta kyyh: “Rado däk 30 hedoo do moweed k'ããts tëg hawak do s'ëëb. Sa moo gó rahaëëj däk do säm Isaraéw buuj raky kajäk do tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta säm me rabets'ẽẽ hõm hew'yyt do joom banäng doo. Tii d' né hẽ Tak'ëp Hyb N'aa Jawyk Do mejũũ hã ỹỹ”, näng paa Jeremiij erii wät do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ti nuuj jé m' Roma buuj Judah häj n'aa bä bag'ããs do pooj jé m' Jesus bagëët. Ti m' Jesus hã ta bagã n'aa eaanh mäh: —Õm né Judah buuj sa wahë n'aa? —näng mäh. Ti m' Jesus ky hadoo: —Ỹỹ. Tii d' né hẽ, maher'oot doo d' né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj wahë n'aa wób Jesus raky n'aa tapaa bä kä Pirato hã, dooh m' Jesus ky gedag bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ti m' Pirato ky hadoo ta hã: —Nepäh a hã õm raky n'aa tapaa doo? —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dooh né paawä Jesus kawaj'ããn bä, dooh m' taky gedag bä raky n'aa tapaa doo. Ti hyb n'aa m' tak'ëp Pirato hyb n'aa meuuj wät. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pas-kowa noo gó m' Pirato bahed'oo doo da taberéd hõm radewëës do seeh. Teréd hõm hajõk do retsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti noo gó m' ragadahew'ëës doo gó m' tabagëët Jesus Barabas häd näng doo, moo nesaa do ky n'aa etsëëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ti m' hajõk do rakat'aa bä kä ta tób hẽnh, Pirato beaanh sa hã: —Ny hadoo do bë karẽn ỹ eréd hõm: Jesus Barabas, Jesus ramaneëënh do P'op Hagä Do H'yyb Däng Doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tii d' tawén eaanh, tahapäh mäh, ta hã rahaëëj däk Jesus, rah'yy kajew'ëës do hyb n'aa ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ti m' ti noo gó né hẽ m', ji ky n'aa etyy n'aa tyng jó Pirato basooh bä kä m', Pirato ỹỹm mejũũ mä Pirato rapanäk hyb n'aa. Hahỹỹ d' mä ta kyyh: —Marejã manä ta ti aj'yy mo haj'aa kanadoo doo. Ta ti hyb n'aa tak'ëp ỹ bahob wät säh ỹỹ gó naga hẽ atsëm —näng mä ta ỹỹm kyyh Pirato panäk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ti nuuj jé m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj sa wahë n'aa na-ããj hẽ m' ramejũũ mä hajõk doo, Barabas rabetsẽẽ hyb n'aa Pirato hã. Ramaher'oot na-ããj hẽ Pirato ramejũũ Jesus tadaj'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ti m' Pirato beaanh sa hã: —Ny hadoo do bë karẽn ỹ eréd hõm? —näng mäh. —Barabas —näk mä hajõk do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ti m' Pirato ky hadoo: —Tii d' tado bä, nyy da ỹ bad'oo Jesus hã, Kristo ramaneëënh do hã? —näng mäh. —Mepëëm däg b'aa kajatsëk do hã! —näk mä sahõnh hẽ sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—Hëd n'aa? —näng mä Pirato. —Dooh mo haj'aa kad'oo do tado bä —näng mäh. Taher'ood né paawä m' tak'ëp rageëëj bong tii bä: —Mepëëm däg! Mepëëm däg! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pirato bahapäh bä m' sa h'yyb rawanareem doo, Pirato hapäh mä rah'yy kawereem do ta wë, tado däk naëng, ti m' ta moo tabahetsyyd wät hajõk do matym gó. —Hëp ỹ n'aa nado hahỹ aj'yy dajëp doo —näng mäh. —Bë né hẽ ti ta tii d' karẽn doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Taw'ããts hẽ —näk mä sahõnh hẽ. —Ããh, ãã panaa na-ããj hẽ, ãã gadoo ta majyyw hyb n'aa ãã raky n'aa tapa bä —näk mä Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ti m' Pirato beréd hõm Barabas häd näng doo. Ti m' tamejũũ rabahewyyh Jesus. Ti m' tahaëëj däk warahén sa hã rabepëëm däk hyb n'aa b'aa kajatsëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ti m' bag'ããs do warahén n'aa ramahũũm Jesus sa wahë n'aa tób wahoo hẽnh. Tii bä m' ranaëëj nä sahõnh hẽ sa hataa, séd hã rakata padëëk hyb n'aa Jesus w'oo hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ti m' rakabo nyyh ta saroor, ti m' radasuun jëng ta hã ta hatsë hahiin doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ti m' hetëk do moo m' ramap'õõd däk, ta nuu gó m' radasooh. Ti m' ranoo ta tatu hub hẽnh tamasoo hyb n'aa. Ti m' sa taron nuu me m' ramehyy bëëh ta wë. Raweh'ëëh doo gó m' raky n'aa mes'uunh. Ti m' raky n'aa ej'ees. Hahỹỹ da m' sa kyyh: —Kaweh'ëëh Judah buuj sa wahë n'aa! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ti m' rabahetsoos sa matsós me. Hajõõ nuu me m' ranu gewyyh tatu me. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Raky n'aa ej'ees jawén paa bä m' rado nyyh mä ta hatsë hahiin doo, radasuun jëng mä ta saroor hẽ. Ti m' ramahũũm rabepëëm däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Panang bä naa raban'yyh bä m' rakataa aj'yy panang Sirené häd näng doo bä naa, Simaw häd näng do hã. Ti m' warahén ramejũũ mä tabes'ooh hyb n'aa b'aa Jesus rahepëëm däk do b'aa n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ti m' rakajaa Gogota häd näng doo bä. (Gogota häd näng doo m' ji nu gabóg k'yy rahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ti m' ramenoo ta hã joom uwa häd näng do s'ëëb hejoonh doo. Kamekuunh mä ti datsäng doo me. Ti m' tameëëk kanahën d'os hẽ, dooh teëg bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ti m' rabepëëm däk do jawén paa bä m', ramoo bong ramas'uunh doo, rabahapäh hyb n'aa ta saroor uuh wë ym doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ti m' rabehyy b'ëëh Jesus rabahag'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","P'op, ta nu gad'oo pong jé m', warahén rabepëëm däk kerih do Jesus moo p'ãã tadajëp do heen n'aa. Hahỹỹ da m' kerih do hã: “Jesus hahỹỹh, Judah buuj sa wahë n'aa”, näng mä kerih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","B'aa kajatsëk do wób hã rabepëëm padëëk na-ããj hẽ pawóp hẽ ajyy baretsëk doo. Hub hẽnh ta see hahäng, s'ỹỹ hẽnh ta see hahäng. Hõõ gó Jesus kahepëëm däk do bahäng. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta tii me teb'ëës do raky n'aa rejãã mä Jesus, sa nuu m' rewõnh Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Hahỹỹ d' m' sa kyyh: —Magawats'iik mäh, a nooh, P'op Hagä Do tób n'aa. Tamawoob mä ta ǟh mamoo wäd sooh p'aa hẽnh, a nooh. A daaj kedëëb! Ahyy b'aa hã hadäk do õm, P'op Hagä Do T'aah mado bä! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, Judah buuj sa wahë n'aa na-ããj hẽ raky n'aa ej'ees mäh: ");
INSERT INTO mbjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ta wób ted'ëëp —näk mäh. —Dooh tahaja bä ta daaj hẽ takedëëb bä! Isaraéw buuj sa wahë n'aa m', tanooh. Taw'ããts hẽ tabahyng b'aa kajatsëk do hã tahadäk do hã naa, tii bä ãã ky daheeh da! ");
INSERT INTO mbjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","P'op Hagä Do hã m' tah'yy kasadä, tanooh. Na P'op Hagä Do edëëb hãã, P'op Hagä Do genaag bä ta hã. P'op Hagä Do T'aa m', tanooh —näk mä sa wahë n'aa sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baretsëk do ta pa pad'ëëk do ti na-ããj raky n'aa rejãã mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wasyk mä ta bag badoo wät, badagyb däk mä badäk hahỹỹ hã. Jããm hẽ tug bä tabawag däk p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tug bä m', tak'ëp mä Jesus geëëj wät: —Eroj, Eroj, rama sabakatani? —näng mäh. “P'op Hagä Doo, ỹ h'yy kasahadä doo, hëd n'aa ỹ mamakyys?”, tahanäng pé m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta tii bä p'eets hẽ hab'ëëh do wób ramaa napäh bä m' ta kyyh, raky hadoo: —Eriij ti tanaëënh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ti m' nayyw hẽ sa see waj'aa däk, sapum do tehoots däk uwa s'ëëb oow me, b'aa hã m' tagadahäng, tamenoo mä Jesus hã tabeëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ti m' ta wób raky hadoo: —Na madëëg! —näk mäh. —Ti b' ër heg'ããs Eriij ana bä tabed'ëëp hyb n'aa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ti m' tak'ëp mä Jesus geëëj wät, ti m' h'yy keréd hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tii bä m', P'op Hagä Do tób n'aa t'õp ta gó noo gatsë hebaan do kas'ẽẽd hyng mäh. Hëëj katajus wät mäh, pä ganebäh bong P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Noo kesëëts hõm mä kamag hood. Hajõk mä baad habok do paa genä bok mäh. Edëb bë kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Genä bok do raban'yyh sa kamag hood paa bä naa. Ti m' Jesus ganä wät do jawén paa bä, rabajëë p'ëë panang Jerusarẽnh hẽnh. Kas'ee bok mä hajõk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ti m' hëëj katajuus doo, sahõnh hẽ hawäd wät do warahén sa wahë n'aa, ta warahén n'aa Jesus hag'ããs do rabahapäh bä m', raky hadoo: —P'op Hagä Do T'aah né paa ti hỹỹh! —näk mä sa kyy kä. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hajõk ỹỹj tii b' hab'ëëh. Dawëë naa m' rabaheg'ããs. Garirej häj n'aa bä naa rahada mä Jesus. Jesus karẽn do hã, ta waa hedoo do hã m' ramasa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sa mahang mä rabab'ëëh Marija Madarẽn häd näng doo, Marija see Tsijaag Joséh sa ỹỹn, Sebedew taah sa ỹỹn. Tamawoob hẽ ỹỹj. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Tũũh däg bä m' papỹỹj, aj'yy tak'ëp ma näng do bahõm Pirato wë. Joséh mä ta häd. Arimatsija hẽnh naa m' tii. Jesus ma matëg see hado däk mäh. Ti m' tabahõm Pirato wë. Tetsẽẽ mä Jesus kamag n'aa tabado hyng hyb n'aa. Ti m' Pirato mejũũ rahaëëj däk ta hã tadakä jëng hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ti m' Joséh bado hyy kän Jesus kamag n'aa, ti m' tahabën däk mä pããn hanäm doo me, rino häd näng do s'ëëb. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ti m' tadasuun jëng pä gabaho doo gó. Papuuj mä ta ti kamag hood pan'aa. Joséh kamag hood paawä ti ragagots däk doo. Ti m' pä gatsabak do tepëëd nä, taty gatsëë däk mä ta me. Ti m' tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Marija Madarẽn, Marija see Jesus kamag hood pa m' rabat'oonh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti m' jati péh, Saab hã, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Pariséw sa daheeh rabahõm Pirato wë. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Hyb n'aa jawyk doo —näk mä Pirato hã. —Ãã hyb n'aa es'ee däk ta ti aj'yy noo kanesa do ky hadoo do paah. Hahỹỹ d' paa ta kyyh: “Tamawoob hẽ tabahado däk bä kä ǟh ỹỹ, ỹ d' ganä wät p'aa hẽnh”, näng paa ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ti hyb n'aa ãã karẽn paawä mamejũũ warahén rabahag'ããs hyb n'aa ta kamag hood tamawoob hẽ ta ǟh. Ta kamag hood ranahagãã bä, ta ma matëg an'aa da ta kamag rabado nyyh hyb n'aa. Jesus ganä wät, näk da tii bä. Hajõk paa tawedii. Jesus makũ ganä wät ranoo bä, ti bahǟnh kawad'ii padëëk hajõk do tii bä —näk mä sa kyyh Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ti m' Pirato ky hadoo: —Taw'ããts hẽ bë mahũũm warahén kamag hood rabahag'ããs hyb n'aa. Baad bë enyyw. Bë hapäh né hẽ nyy d' bë bad'oo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ti m' ta kamag hood noo bä rabats'aa däk ky n'aa jaw'yyk do heen n'aa, ta ma matëg ranoo gasëëts hõm mahǟnh. Ti m' ramejũũ warahén rabahag'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ti m', Saab bahëëj jëng bä m', bäp paah, met'uuh hã, papỹỹj ty ganä këë bä, Marija Madarẽn, Marija see daheeh rabahõm Jesus kamag hood rabaheg'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ti m' nayyw hẽ, tak'ëp k'ããts katajus këë. Tak'ëp tawén katajus wät P'op Hagä Do ããs bahyng do hyb n'aa, ti m' pä kepëëd hõm ta noo gatsë paah, ti m' ta jó tabaso däk. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tak'ëp mä ããs gabarëëh, hawyp do gabarëëh doo da. Tak'ëp mä ta saroor bahawak. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tak'ëp mä warahén, Jesus kamag hood hag'ããs do paah, rajeỹỹm bong mä ããs. Kajajãn b'ëëh mä ỹỹm haj'aa, dejëp do hedo padëëk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ti m' ããs ky hadoo ỹỹj sa hã: —Bë eỹỹm manäh! —näng mäh. —Ỹ hapäh, Jesus repëëm däk do paa bë esoos. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dooh wäd bä. Ganä wät, bë tamaher'ood wät doo da né paah! B'ëëp, bë hegãã nyy bä takadasuun jëng do paa bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Nayyw hẽ bë ahõm, ta ma matëg bë maher'oot hyb n'aa. Hahỹỹ da d' bë kyyh: “Ganä wät dejëp do sa mahang. Ahõm da bë pooj jé Garirej hẽnh. Bë hapäh da t'ĩĩ hẽnh”, näk da bë kyyh. Tii d' këh ỹ bë hã —näng mä ããs kyyh ỹỹj sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ti m' rawaj'aa jëk ta ma matëg ramaher'oot hyb n'aa. Rajeỹỹm né paawä m' tseb'ee mä ti hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ti m' rabajëk bä m', nayyw hẽ m' Jesus kas'ee wät sa hã, ti m' takedëng sa hã. Ti m' ta wë rabana, ti m' rabehyy b'ëëh tũũ, ta tsyym hã ramoo kajäk ta hã raweh'ëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ti m' Jesus ky hadoo sa hã: —Bë eỹỹm manäh. Bë ahõm, bë maher'ood hǟj haa sa hã Garirej hẽnh rabahõm hyb n'aa. Tii bä da ỹ rabahapäh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ti m' Jesus ma matëg wë ỹỹj rahõm nuuj jé m', warahén wób rabajëk mä panang hẽnh P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wë. Ti m' ramaher'oot mä sa hã sahõnh hẽ rahapëë wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa rakataa Judah buuj sa wahë n'aa hedoo do sa sii, rahyb n'aa newëë nyy d' rabad'oo hyb n'aa. Ti m' hajõng dajẽẽr rabanoo warahén sa hã, ");
INSERT INTO mbjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ti m' raky hadoo sa hã: —Taw'ããts hẽ hahỹỹ da bë maher'ood ta wób sa hã: “Atsëm, ãã aǟ nuuj jé ta ma matëg rabana, tii b' retsëëg hõm ta kamag”, näk da bë kyyh —näk mä sa wahë n'aa hedoo do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ti m' raky hadoo ẽnh: —Pirato, babä bagã n'aa ky n'aa napäh bä panyyg bë her'ood hõm doo, ãã h'yyb en'yym da, dajëb hã bë taky n'aa ety mahǟnh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ti m' warahén ragado däk dajẽẽr, ti m' sa hã ramejũũ doo da né hẽ m' ramaher'ood hõm daap men'yyh do panyyg. Ti m' jé pad'yyt hẽ m' Judah buuj mahang kaher'ood däk ta ti panyyg. Da hẽ na-ããj nä kaher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ti m' 11 hedoo do rabahõm kän Garirej hẽnh, waëë hẽnh, Jesus mejũũ do paa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ti m' Jesus rabahapäh bä, raj'aa etsëë kän mä ta hã. Ti hadoo né hẽ dooh baad tagah'ood nä bä ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ti m' Jesus bana kän p'eets hẽ sa wë. Hahỹỹ d' mä ta kyyh sa hã: —Sahõnh hã, hỹ pong jé hawät do hã, badäk hahỹỹ bä hawät do hã na-ããj hẽ P'op Hagä Do an'oo däk ỹ mejũũ hyb n'aa. Sahõnh hẽ sa bahǟnh ỹ hyb n'aa jawyg däk tan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ti hyb n'aa, bë ahõm. Ma matëk ỹỹ rabahado padëëk bë an'oo bä sahõnh hẽ häj n'aa babuuj. Bë nu gemuun hõm da ta ti Ee häd gó, ta T'aah häd gó, P'op Hagä Do Sahee häd gó. ");
INSERT INTO mbjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bë ma met'ëëg sa hã sahõnh hẽ bë ỹ mejũũ do paa raky daheeh hyb n'aa. Hahỹ ỹ ky däng bë hã: Ỹ awäd had'yyt hẽ da bë sii badäk hahỹ gawatsik bä kä. Jããm hẽ kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hahỹ tadu doo Jesus Kristo, P'op Hagä Do T'aah panyyg hanäm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hahỹỹ da takerii däk P'op Hagä Do ky n'aa rod Isajas häd näng do mo haj'aa hã: “Ỹ mejũũ da panäk ỹ n'aa a pooj jé, a tyw n'aa tabenyyw däk hyb n'aa a pooj jé.” ");
INSERT INTO mbjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Hahỹỹ da tabanawäng bä her'oot do kyyh: Bë tyw n'aa bak'ood däg da Tak'ëp Hyb N'aa Jawyk Doo. Baad ub da bë tyw n'aa daj'aah”, näng mä takerii däk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nanäng panäk doo, Jowãw nu gahem'uun do paa m' tii. Tabanawäng bä paa m' tabawät. Tanu gemuun hõm paa m' hajõk. Taher'oot sa hã raberéd hõm hyb n'aa nesaa doo, ranu kemuun hõm hyb n'aa nesaa do raberéd hõm do heen n'aa, P'op Hagä Do awug hõm hyb n'aa nesaa do sa h'yyb tym gó hanäng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ti m' hajõk Judah häj n'aa buuj, panang Jerusarẽnh häd näng do babuj n'aa na-ããj né hẽ m' rabahõm Jowãw wë. Nesaa do rakawoom bä, Jowãw nu gemuun hõm tamii Joradãn häd näng doo me. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jowãw saroor mä kameer wii s'ëëb ta pan'aa. Ta baa wyd paa m' ta byyh. Sabakar paa m' tawëh ta tä, mabaa bëëh paa m' ta waa. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hahỹ d' paa ta kyy sa hã: —Ti awät da jawén ỹỹ tak'ëp hyb n'aa jawyk do bahǟnh ỹỹ. Hã ỹỹ, ỹ hyb n'aa sakog its ta hã. Ti hyb n'aa dooh ỹ haja bä ta tsyym suun kabo n'aa ỹ do bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","—Ỹ ti hỹỹh, bë ỹ nu gemuun naëng me. Tii kä P'op Hagä Do Sahee tabajëë suun bë h'yyb tym gó, bë tah'yyb mahũũm hyb n'aa —näng mä Jowãw nu gahem'uun do kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ti noo gó kä m' Jesus bana panang Nasaréh häd näng doo bä naa. Garirej häj n'aa bä ta ti Nasaréh panang. Jesus Jowãw nu gemuun wät doo kä tamii Joradãn häd näng doo me. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ti m' Jesus nu ganä däk bä m' tabaheg'ããs wë hã, wë kabasëëts däk. Ti m' P'op Hagä Do Sahee tabahapäh, ahyng mä ta wë gurii-i hadoo mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti m' hỹ pong jé naa tamaa ena kän P'op Hagä Do kyyh. Hahỹỹ d' mä ta kyyh: —Õm tah ỹỹ, tak'ëp ỹ kamahǟn up doo. Baad ỹ mah'yyb n'yym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti m' nayyw hẽ tabanawäng hẽnh, rabanabok hẽnh, Jesus P'op Hagä Do Sahee mahũũm kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","T'ĩĩ hẽnh mä Jesus baym 40 m' ta ǟh. Tii bä m' Nesaa Do Yb, Satanas häd näng doo, mety paawä m'. Ta tii bä m', Jesus baym bä, ti abong mä tababo n'aa. Ããs rahag'ããs mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ti m', Jowãw nu gahem'uun do radawäts gëët do jawén paa bä kä m', Jesus bahõm kän Garirej häj n'aa hẽnh kä. T'ĩĩ hẽnh kä P'op Hagä Do panyyg hanäm do tamet'ëëg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hahỹỹ da m' ta kyyh: —Kaja däg kän ji P'op Hagä Do bag'ããs doo. Ti hyb n'aa taw'ããts hẽ bë eréd hõm nesaa doo. P'op Hagä Do hã bë h'yy kawareem. Bë ky dahé ti panyyg hanäm doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ti noo gó m', tabawät bä m' karaj'aa Garirej häd näng do nabyy me, tabahapäh mä pawóp hẽ ta hỹỹj daheeh habok doo. Simaw, Ãn-Deréh mä sa häd. Tah'ỹỹb mä res'aak karahi me. Tah'ỹỹb sag né hẽ m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ti m' Jesus ky hadoo sa hã: —B'ëëp bë ana, si ỹ bë abooh. Tah'ỹỹb sag nado boo da bë hỹỹ kä. Ajyy, ỹỹj sag hadoo da bë hỹỹ kä P'op Hagä Do hã rah'yy ka'eeh hyb n'aa —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ti m' nayyw hẽ m' raberéd hõm karahi. Ah'ũũm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ti bahǟnh mä tabahapäh Sebedew häd näng do taah, Tsijaag, Jowãw daheeh. Marakate gó m' rabat'oonh. Karahi m' renäm. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus ats'yyt né m' tii d' ẽnh. Ti m' nayyw hẽ m' raberéd sooh sa yb sa hataa sii hẽ m'. Ti m' Jesus sii rabahõm kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ti m' Jesus bahõm panang Kapar-Naũm häd näng doo hẽnh. Ti m' Saab, Judah buuj rakamehehãk do hã, tób P'op Hagä Do panyyg rayd naherot doo hẽnh tabahõm. Tii bä m' tama metëëk P'op Hagä Do panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti m' maa new'ëë do rahyb n'aa meuunh mäh. Rawén meuuj bong mäh, hyb n'aa jawyk do ky n'aa me tama metëëk do hyb n'aa m'. Mosees ky n'aa jaw'yyk do ma mehetëk do ky n'aa nahado m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tii bä m' tabasooh sa mahang aj'yy karap'aar h'yyb nesaa do hadäk doo, mera doo. Ti m' tak'ëp mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—H'ëëd makarẽn ãã wë Jesus, Nasaréh buuj? Ãã marejãã mawén na! —näng mäh. —Ỹ hapäh õm baad ub. Õm P'op Hagä Do hanaa, tak'ëp hanäm doo, baad hadoo do moo wëëd õm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti m' Jesus ky geǟm wät mä karap'aar h'yyb nesaa doo. Ti m' taky hadoo: —Er'ood manäh! Bag hẽnh! Ahõm aj'yy mahǟnh! —tah'eed hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tii bä m' aj'yy tak'ëp karap'aar h'yyb nesaa do behats wät. Tii bä m' awaaw wät mäh, ti m' tabahõm kän ta mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ti m' ta wób rameuuj bong mäh, raky n'aa jõg bong mäh. Ti m' raky hadoo: —H'ëëd hỹỹ éh? Ta see ky n'aa hadoo hỹỹh. Tametëëk mä hyb n'aa jawyk do ky n'aa me. Karap'aar h'yyb nesaa do sii hẽ tamejũũ. Raky daheeh né hẽ —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti hyb n'aa m' dawëë Jesus ky n'aa däg däk Garirej häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tii kä m' Jesus raban'yyh tób P'op Hagä Do panyyg rayd naherot doo bä naa. Ti m' Tsijaag, Jowãw daheeh Jesus bahõm kän Simaw, Ãn-Deréh sa tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Asooh mä Simaw mayyn. Oom ta hã. Ti m' Jesus hã rabaher'oot taoom. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ti m' Jesus bajëë suun tahasooh hẽnh, tamoo ej'ooj sëëk mäh. Ti m' oom keréd hõm. Nayyw hẽ m' Peed mayyn moo wäd däk sa waa. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tug bä kä, papỹỹj badëë hyng jawén paa bä, Kapar-Naũm buuj ramenaa sahõnh hẽ nahëë enäh doo, karap'aar h'yyb nesaa do pahadëëk do sii hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hajõk Kapar-Naũm buuj kata padëëk Simaw tób w'oo hã, Jesus yt gä do w'oo hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hajõk mä sa nahëë Jesus hahëën hõm. Hajõõ m' nahëëh. Hajõng mä karap'aar h'yyb nesaa do tahebëë bong mera do sa hã hanäng doo. Dooh m' Jesus an'oo bä karap'aar h'yyb nesaa do rer'ood bä, rahapäh do hyb n'aa, Jesus P'op Hagä Do T'aah né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ti m' jati péh, bäp paah, badajung nä, tabas'ëëg gëët, ti m' tabahõm dawë hã, ranabok hẽnh, P'op Hagä Do sii taber'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ti m' Simaw ta hataa daheeh raty gawëëj padëëk bä m' rabahõm Jesus rabesoos hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ramamuun bä m' raky hadoo ta hã: —Hajõk õm hes'oos! —näk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ti m' Jesus ky hadoo sa hã: —Hamäh! Ta s'ee hẽnh ër bahõm, ta wób panang hẽnh ỹ baher'oot hyb n'aa P'op Hagä Do panyyg hanäm do sa hã na-ããj né hẽ. Ti hyb n'aa né hẽ ỹ wén na —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tii d' paa tabawät jé pad'yyt hẽ Garirej häj n'aa bä. Sahõnh hẽ m' tób P'op Hagä Do panyyg rayd naherot do hã tabaher'oot, tametëëk P'op Hagä Do ky n'aa. Tahebë mä karap'aar h'yyb nesaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ti m' aj'yy rog manahuuh do hanäng do ana mä Jesus wë. Ti m' tabahyy häng mä ta taron nu paa me, tetsẽẽ mä Jesus bado hõm hyb n'aa ta nahëëh. Hahỹỹ d' mä ta kyyh: —Makarẽn bä mahajaa né hẽ nahäh ỹ mado hõm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ti m' Jesus t'yyd mehĩĩn mäh. Ti m' tamoo däng ta hã, ti m' taky hadoo: —Ej. Ỹ karẽn —näng mäh. —Has'oo däg! —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ti m' nayyw hẽ kä m' ta nahëë badoo wät. Has'oo däg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ti m' baad tabaher'oot ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Maher'ood manä ta wób sa hã —näng mäh. —Ahõm jajé naga hẽ P'op Hagä Do tób n'aa yt hã moo wät do wë. Mametä ta hã õm has'oo däk doo. Mamoo wäd Mosees mejũũ do paah, ta ti hedoo pé ji nahëë badoo wät do heen n'aa, p'aa hẽnh baad mabahadoo hyb n'aa P'op Hagä Do matym gó, baad sahõnh hẽ rabahapäh hyb n'aa õm has'oo däk doo —näng mä Jesus ta hã. Ti m' tamejõ hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tii d' né paawä Jesus maher'oot, dooh m' taky dahé bä. Taher'oot mä tamahõm me. Jé pad'yyt hẽ rapanyyg enä hõm mäh. Ti hyb n'aa kä m' dooh Jesus haja wäd bä sa panang hẽnh tahõm bä rabahapäh bä kä. Dawë hã kä m' takan'oo kän. Ti hadoo né hẽ m' jé pad'yyt hẽ naa rabena ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ti m' pawóp hẽ ta ǟ jawén paa bä, Jesus matëëh p'aa hẽnh panang Kapar-Naũm häd näng doo hẽnh. Tii bä m' rapanyyg enä däk, p'aa hẽnh mä Jesus bagëë däk tób ta yd nu hed'ëëh bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hajõk mä t'ĩĩ hẽnh hah'ũũm. Hajõk mä rakata padëëk tób bä. Du daa m' ta tyw n'aa wät pé tób w'oo hã na-ããj hẽ. Ti m' Jesus met'ëëg kän P'op Hagä Do panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ti m' ji meheet pé ajyy ramanaa mä nahëë näng doo, nawät doo, ratóg nä ta tyng jó. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Du daa m' rakad'oo pé ramajë suun paawä m' Jesus wë, gatag'uu däk do hyb n'aa m' hajõk doo. Ti m' p'op ramasäk. Ratyw n'aa gas'ëës mä Jesus bagëët nemuun. Ti m' ramahy kän Jesus wë kä ta tyng jó. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti m' Jesus h'yyb hapäh bä m' hat'ook do rah'yy ka'eeh do ta hã, taky hadoo nawät do hã: —Tah ỹỹ, nesaa do a h'yyb tym gó hanäng do kado hõm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ti m' rabat'oonh sa mahang Mosees ky n'aa jaw'yyk do ma mehetëk doo. Ti m' sa h'yyb gó raky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Hëd n'aa m' ti hỹỹ ti d' tabaher'oot? P'op Hagä Do taky n'aa rejãã ti hỹỹh —näk mä sa h'yyb gó. —Jããm né hẽ P'op Hagä Do hajaa nesaa do ji h'yyb tym gó hanäng do tado hõm bä —näk mä sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nayyw hẽ m' Jesus h'yyb hapäh mä sa h'yyb, ti hyb n'aa m' taky hadoo sa hã: —Hëd n'aa tii da bë hyb n'aa newëë bë h'yyb gó? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—Nyy da nahejooj bë hã? “Kado hõm nesaa do a h'yyb tym gó hanäng do paah”, ji noo bä? “As'ëëg g'ëëd, mado däg a tyng, awäd däg”, ji noo bä nawät do hã? —näng mäh. Ti m' taky hadoo ẽnh sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","—Hỹỹ kä da —näng mäh. —Bë bahapäh hyb n'aa ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ hajaa sa hã hanäng do nesaa do ỹ ado hõm bä, ỹ haso däk da nahëë näng doo —näng mä Jesus kyyh. Tii bä m' k'yy gadów däk do hã taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—As'ëëg g'ëëd, mado däg a tyng, ahõm kä a tób hẽnh —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti m' tabas'ëëg gëët, tabado däk mä ta tyng, ahõm kän mä hajõk do matym gó. Tii bä kä m', rameuuj kän sa h'yyb gó. Ti m' P'op Hagä Do hã raj'aa etsë. Hahỹỹ d' mä sa kyyh: —Dooh ãã hapäh pé hỹ hedoo péh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ti m' Jesus bahõm ẽnh karaj'aa Garirej häd näng doo hẽnh. Hajõk mä han'aa ta wë. Ti m' Jesus ma metëëk sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ti m' ta jawén, Jesus bawät bä kä, tabahapäh Rewi häd näng doo, sa wahë n'aa Roma buuj ky gabuuj dajẽẽr tagahed'aak bä hasooh doo. Aw-Pew t'aa m' ti Rewi. Ti m' Jesus ky hadoo ta hã: —B'ëëp ana wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa —näng mäh. Ti m' Rewi bas'ëëg gëët, ahõm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ta jawén, Rewi tób bä Jesus bawëh bä m', hajõk dajẽẽr gahed'aak doo, Matew hep'ëëh doo, ta wób sa hã pé nesaa do moo heb'ooh do na-ããj hẽ rabana rabawëh hyb n'aa Jesus sii, Jesus ma matëg sa sii. Hajõk né hẽ m' Jesus sii heb'ooh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti m' Pariséw wób, Mosees ky n'aa jaw'yyk do ma mehetëk do rabahapäh bä m' ta ti hedoo do sa sii Jesus bawa doo, Jesus ma matëg hã rabeaanh: —Hëd n'aa dajẽẽr gahed'aak do sa sii, ta wób na-ããj hẽ nesaa do moo heb'ooh do sa sii tabawëh? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ti m' reaanh do Jesus maa napäh bä, panyyg gó taky gadoo: —Nahëë temah doo, dooh rahõm bä mediko wë. Nahëë enäh do ti hah'ũũm ta wë. Dooh ỹ ahyy bä hỹ pong jé naa P'op Hagä Do karẽn doo da habok red'oo do ỹ naëënh hyb n'aa. Ỹ ahyng, nesaa do moo heb'ooh do ỹ naëënh hyb n'aa —näng mä Jesus kyyh Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ti anäng paa m' ta heen n'aa Jowãw nu gahem'uun do ma matëg, Pariséw na-ããj mäh, ranoo kanawa doo me raweh'ëëh P'op Hagä Doo. Ti m' ta wób reaanh mä Jesus hã: —Jowãw ma matëg, Pariséw ma matëg na-ããj hẽ ranawa P'op Hagä Do rahyb n'aa esee hyb n'aa. Hëd n'aa a ma matëg tii d' ranad'oo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ti m' panyyg ky n'aa gó Jesus ky gadoo. Hahỹỹ d' mä ta kyyh: —Ket'ëë do jäm n'aa hẽnh ji ats'yyt doo, dooh ratabëëj bä ranoo kanawa do heen n'aa ta patug pan'aa sa mahang tag'ëëd bä. Jäm bawät nä bä rawëë had'yyt hẽ. Dooh ratay bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ti awät da ti noo gó sa najiis, ta patug pan'aa, rado hõm sa mahǟnh. Ti noo gó da ratay kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ti m' panyyg wób ky n'aa gó Jesus ky gadoo nä reaanh doo. Hahỹỹ d' mä ta kyyh: —Dooh ji gas'yyb bä saroor säg noo eh do pããn papuuj bäh me. Tii d' ji adoo bä, papuuj bäh tsawyy däg bä, ta säg tanes'ëëm, kawah'oob hõm tii bä. Ti bahǟnh tanoo ee däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ti hadoo né hẽ uwa bëëh hã. Dooh ji gedu bä uwa bëëh papuuj hegän sooh do pan'aa ta hood b'éé byyh säg gó. Tii d' ji adoo bä, uwa bëëh egän so bä, ta hood säg ganabäh hõm. Tii bä kä, uwa bëë waho bëëh da, ta hood kä karejã kän —näng mäh. —Uwa bëëh papuuj ji geduuh ta hood papuuj gó, keh'ũũs doo gó —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Saab hã m', Judah buuj rakamehehãk do noo gó m', Jesus ta ma matëg sa sii joom tiriig banäng doo me m' ratabës. Ramahõm me m', ta ma matëg tiriig ag mä rateh'yyp rabawa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ti m' Pariséw sa sii habong do raky hadoo Jesus hã: —Mahegãã! Hëd n'aa a ma matëg raky nadaheeh ër ky n'aa jaw'yyk do Saab ky n'aa hã? Saab hã ramoo bok —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ti m' Jesus ky hadoo sa hã: —Dooh bë ner'ood bä g'eeh nyy da ër wahë makũ Dawi bad'oo, tii, ta hataa rabas'aah bä, sa waa tamah bä? ");
INSERT INTO mbjNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abijatah P'op Hagä Do sa hã kahesé do tób n'aa yt moo heb'ooh do sa wahë n'aa heh'äät do tabahadoo noo gó, Dawi ajëë suun P'op Hagä Do sa hã kahesé do tób n'aa yt hã, ti m' tabawa ti pãw P'op Hagä Do sa hã kahesé do tób n'aa yt hatoonh doo. Ti m' tanoo mä ta hataa rabawa. Jããm né paawä ta ti tób yt hã moo heb'ooh do haw'aa ta ti pãw Mosees ky n'aa jaw'yyk do an'oo bä —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ti m' taky hadoo ẽnh: —Ji kameh'ããk do hyb n'aa P'op Hagä Do wén pahuuj wät paa ji kameh'ããk do heen n'aa. Dooh ji tapahuuj bä ji kameh'ããk do heen n'aa hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","—Ti hyb n'aa, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, Saab ky n'aa hã sii hẽ ỹ mejũũ —näng mä Jesus Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ta see pé noo gó Jesus bahõm ẽnh tób P'op Hagä Do panyyg rayd naherot doo hẽnh. Ti yt hã m' tabasooh aj'yy moo gadóm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tii bä m' ta wób ramatakëë mä Jesus aj'yy moo tahaso däg bä Saab hã. Ta moo tahaso däg bä, Jesus moo wät né hẽ Saab hã kä sa hã. Rakarẽn paawä m' Jesus raky n'aa tapaa Jesus ky nadaheeh do Mosees ky n'aa jaw'yyk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ti m' Jesus ky hadoo aj'yy hã: —Ag'ëëd däg sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ti m' taky hadoo ta wób sa hã: —Nyy da ër ky n'aa jaw'yyk do metëëk Saab ky n'aa hã? H'ëëd ti taw'ããts hẽ ji moo wät Saab hã? Baad hadoo do ji moo wät, nesaa do ji moo wät? Ji da hadoo do ji ed'ëëp Saab hã, ji da hadoo do ji daj'ëëp Saab hã? —näng mä Jesus kyyh sa hã. Rahapëë né paawä m', dooh m' raky gado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ti m' kawaj'ããn gó Jesus ty kawõõt sa wë. Tahyb n'aa tón mä sa h'yyb tym ganahoot do hyb n'aa m'. Ti m' aj'yy hã kä taky hadoo: —Madajoow a mooh! —näng mäh. Ti m' ta moo tadajoow däk. Ahub däg kän mäh, baad däg mä ta moo kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ti m' nayyw hẽ m' Pariséw raban'yyh. Eróts karapee sii hẽ m' rakaner'oot mä nyy d' rabad'oo Jesus radaj'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ti m' karaj'aa hẽnh Jesus ta ma matëg sii hẽ m' rabawëëj kän. Hajõk mä Garirej häj n'aa hẽnh naa Jesus jawén hah'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Raky n'aa napäh bä m' sahõnh hẽ Jesus moo wät doo, rabana Judah häj n'aa hẽnh naa, panang Jerusarẽnh häd näng doo hẽnh naa, Idumeej häj n'aa hẽnh naa, tamii Joradãn tamyyj däk hẽnh naa. Ta wób mä Tiir, Sidõn panang häd enäh do häj n'aa hẽnh naa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hajõk do hyb n'aa m', Jesus mejũũ ta ma matëg rabenäm hyb n'aa marakate ta pooj jé, ragatatug däk do hyb n'aa ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hajõk sa nahëë heso hõm do hyb n'aa m', nahëë enäh do rawén gatatug kän ta wë. Rakarẽn mä ramoo kajäk ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jesus karap'aar h'yyb nesaa do hã hadäk do rabahapäh bä m', tũũ m' rakajäk ta matym gó. Tak'ëp mä rageëënh: —Õm P'op Hagä Do T'aah! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus ky ge'ỹỹm mä karap'aar h'yyb nesaa doo, ranaher'oot hyb n'aa m' ta ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ti m' Jesus basëëk waëë jó. Tanaëënh mä ta wë tah'yyb däng doo. Ti m' rabahõm ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sa mahang tasëm mä 12 ta hataa, ta sii rababok hyb n'aa, tamejũũ hyb n'aa ta ky n'aa rabaher'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tanoo mä sa hã karap'aar h'yyb nesaa do rabahajaa rabahebë hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hahỹỹ m' 12 hedoo do tamejũũ doo: Simaw mäh, “Peed” ta häd n'oo däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ta jawén mä Sebedew taah, Tsijaag, Jowãw häd enäh doo, “Darung Do Taah” tamaneëënh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ta jawén mä Ãn-Deréh, Pirip, Batoroméw, Matew, Toméh, Tsijaag see Aw-Pew t'aah, Tadéw, Simaw Serot, ");
INSERT INTO mbjNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Ikarijot kä m', Jesus haëëj däk do majĩĩ hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ti m' Jesus ta ma matëg sii hẽ rabajëë p'ëë tób gó. P'aa hẽnh mä rakata padëëk hajõk doo. Du daa m' rabawa pé hajõk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta ỹỹn, ta wakããn rapanyyg enä däg bä m', rabahõm t'ĩĩ hẽnh rahahëën paawä m'. Sa hã m' baad nado wäd Jesus h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do Jerusarẽnh hẽnh naa han'aa doo, hajõk do mahang hab'ëëh doo, raky hadoo ta wób sa hã: —Beresebu, karap'aar h'yyb nesaa do wahë n'aa ti adäk ta hã. Ti kyy gó ti tabahebë karap'aar h'yyb nesaa doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ti m' tii d' ky hedoo do Jesus naëënh ta wë. Ti m' panyyg ky n'aa gó tabaher'oot sa hã. Hahỹỹ d' mä ta kyyh: —Ta daaj hẽ g'eeh Nesaa Do Yb takahabë? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Sa da hadoo do wë sa häj n'aa babuuj rahyb n'aa wareem bä, gawatsik tii bä sahõnh hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","—Sa wakããn sa hã hẽ rahyb n'aa wareem bä, kahäj jëng tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ti hadoo ẽnh Nesaa Do Yb hã kä. Ta hã hẽ takawareem bä, ta karapee hã tahyb n'aa wareem bä, ahëëj jëng né hẽ tii bä ta hejój. Gawatsik da tii bä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ti m' taky hadoo ẽnh: —Dooh aj'yy hejoonh do tób gó hajëë suun pé ta ma tado hõm hyb n'aa, pooj jé tób danäh moo tamanaw'yyd bä. Ta moo kamaw'yyd bä, tahajaa ta ma tado hõm bä —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ti m' taky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Sahõnh hẽ nesaa do ji moo wät doo, sahõnh hẽ P'op Hagä Do ji ky n'aa rejãã do na-ããj hẽ P'op Hagä Do mabaan hõm da ji hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","P'op Hagä Do Sahee ky n'aa rejãã doo kä, dooh P'op Hagä Do mabaan bä tii. Ta ti hedoo péh, dooh tahëëj bä nesaa do ta hã. Tadajëp jawén paa bä na-ããj hẽ nesaa do adäg had'yyt hẽ ta hã —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tii d' tawén edoo mä sa hã, P'op Hagä Do Sahee kyy gó tawén hebë. Sa hã m' Nesaa Do Yb ky gabuuj mäh. Raher'oot do hã P'op Hagä Do Sahee raky n'aa rejãã. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ti m' Jesus ỹỹn, ta wakããn sii hẽ m' rakajaa. Ta w'oo hã m' rababë däk. Ti m' ramejũũ ranaëënh Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hajõk mä ta pa hat'oonh. Ti m' raky hadoo ta hã: —A ỹỹn, a wakããn, ta w'oo hã rabab'ëëh. Õm mä resoos —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—Jaa ti ëën, jaa ti wakãn haa? —teaanh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ti m' taty kawõõt ta w'oo gadäk hẽnh rahat'oonh hẽnh. Ti m' taky hadoo: —T'oonh hahỹ ǟn ỹỹ, wakãn haa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Sahõnh hẽ P'op Hagä Do karẽn do moo heb'ooh doo, ti né hẽ wakãn haa hadoo, ti né hẽ ǟnh ỹ hadoo, ti né hẽ ëën hadoo —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ti m' Jesus ma metëëk ẽnh karaj'aa Garirej häd näng do nabyy me. Hajõk do nu sabuk mä ta hã. Ti hyb n'aa m' marakate gó tagatsëg sooh. Hajõk do ayyw b'ëëh mä ta takëën nabyy me. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ti m' hajõõ m' tama metëëk mä sa hã panyyg ky n'aa me m'. Hahỹỹ d' mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Bë hyb n'aa matakä hahỹ panyyg! Hỹ hadoo joom hejóm do bejoom joom tym. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tatsawyh hõm joom tym. Joom tym tatsawyh hõm do wób ta tyw n'aa me takajäk, ti taw'ëëd rabajóh jëng. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Joom tym wób kajäk pä ta yt tabahadoo do jó. Kanahën its k'ããts tii bä. Ti nayyw hẽ taganyyh, kanahën d'os do k'ããts ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tabajuu bä, nayyw hẽ tatsawyy jëng, dooh ta kóm ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta tym wób kajäk sasëng kóm banäng bä. Sasëng gajewäng bä kä, dooh tawëë wäd bä. Ti hyb n'aa dooh teag bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta tym wób kajäg kän baad tabadoo bä. Taganyyh, baad tabawäng, baad tabeaak. 30 nuu me tabejoom do bahǟnh tabeag kän baad tabadoo bä kajäk do ta tym wób. 60 nuu me tabejoom do bahǟnh tabeag kän ta tym wób. 100 nuu me tabejoom do bahǟnh tabeag kän baad tabadoo bä kajäk do ta tym wób kä —näng mä Jesus. Panyyg gó m' tabeh'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ti m' taky hadoo: —Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ta jawén kä m', ta mab hẽ 12 hedoo do ta ma matëg hẽ kä, ta wób hẽ kä, rabeaanh ta hã nyy d' tahanäng pé m' ti panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti m' taky hadoo sa hã: —Bë hã P'op Hagä Do an'oo däk bë bahapäh hyb n'aa pooj jé ji nahapäh do P'op Hagä Do bag'ããs do ky n'aa hã. Ta wób sa hã, sa h'yyb gó naa maa new'ëë kanarẽn doo, sahõnh hẽ takaher'oot da panyyg ky n'aa me —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","—Tii d' tawén hadoo, —näng mäh —“Rahegãã had'yyt né paawä m', dooh m' rah'yy genä bä. Ramaa newë had'yyt hẽ né paawä m', dooh m' tagah'ood bä sa hã. Dooh né rakarẽn bä P'op Hagä Do hã rah'yy kawereem hõm, P'op Hagä Do nawug hõm hyb n'aa nesaa do sa h'yyb gó hanäng doo” —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ti m' Jesus ky hadoo ẽnh: —Taganah'ood bä bë hã hahỹ panyyg, nyy d' tagahoot panyyg wób bë hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—P'op Hagä Do kyyh herot doo, aj'yy joom tym hejóm do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Joom tym ta tyw n'aa me kajäk do hadoo P'op Hagä Do panyyg maa new'ëë do wób sa hã. Ramaa newë sii hẽ, nayyw hẽ, P'op Hagä Do panyyg Nesaa Do Yb asog hõm sa h'yyb gó naa. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","P'op Hagä Do panyyg maa new'ëë do wób, pä banäng bä kajäk do hadoo sa hã. P'op Hagä Do panyyg ramaa newë sii hẽ, nayyw hẽ, h'yy gadajaa gó ragadoo. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","H'yy gadajaa gó ragado né paawä, nayyw hẽ rah'yy gejë hõm, joom kóm nanäng nä do hadoo sa hã. Hejoonh do kametä bä sa hã, sa hã rarahejã bä na-ããj hẽ P'op Hagä Do panyyg metëëk doo da rababok do hyb n'aa, nayyw hẽ rah'yy gejë hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","P'op Hagä Do panyyg maa new'ëë do wób, joom tym sasëng mahang kajäk do hadoo sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","P'op Hagä Do panyyg ramaa napëë né paawä, rahyb n'aa newë had'yyt hẽ badäk hahỹỹ hã ji bawät do hã. Dajẽẽr hã, sa ma ji tawadii do hã rahyb n'aa h'ũũm. Rah'yy karẽn do jawén rababok. Ti hyb n'aa P'op Hagä Do panyyg sa h'yyb gó hadäk do tawén nahõm. Joom neaak do hado däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","P'op Hagä Do panyyg maa new'ëë do wób, joom tym baad tabadoo bä kajäk do hadoo sa hã. Ti ramaa newëë P'op Hagä Do panyyg, baad ragadoo, baad rabenäm sa h'yyb gó. P'op Hagä Do karẽn do baad ramoo bok tii kä. Joom 30 nuu me, 60 nuu me, 100 nuu me takejoom do bahǟnh tabeaak do hadoo tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ti m' taky hadoo ẽnh: —Bë gataa sooh bë bag, ji waa hood yt hã, ji jó ỹỹh do yt hã bë bejën hyb n'aa apäh? Dooh. Ta bag bë dasooh ta tyng jó, baad ta bag däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ti hadoo da ỹ ma metëëk do hã: Sahõnh hẽ sa hã da hẽ kejën nä doo, sahõnh hẽ rah'yy ganenäh nä doo, kametä däk né da sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti m' taky hadoo ẽnh: —Taw'ããts hẽ baad bë matakä ti bë maa newëë doo. Bë matakëë do pénh, bë maa newëë do pénh, bë da P'op Hagä Do h'yy gan'yyh. Ti bahǟnh baad bë da tah'yy gan'yyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jé h'yy ganyy däk doo, ti bahǟnh P'op Hagä Do banoo nä ta hã ta h'yy ganäng doo. Jé kanahën d'os hẽ h'yy ganäng doo, P'op Hagä Do ado hõm da ta hã kanahën had'os doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ti m' taky hadoo: —Aj'yy joom tym hejóm do ky n'aa hadoo né hẽ P'op Hagä Do bag'ããs do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta ǟh tatebëj nuuj jé, adëb bä, atsëm, ta ti joom tym ganyyh, tabawäng. Dooh joom hejóm do hapëë bä nyy da tabawäng ti joom. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta daaj né hẽ joom k'ããts baw'ëëh. Pooj jé tagajewäng, tii b' tabaee däk, tii b' tabeag kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ta ag wah'ëë däk bä kä, ta heen n'aa hã, tii bä kä joom näng do bak'ããd kän ta joom, joom ji nu gekãã do nahëë me —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ti m' Jesus ky hadoo ẽnh: —Panyyg see ky n'aa me ỹ her'oot bë hã P'op Hagä Do bag'ããs do ky n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Joom motaad häd näng do tym nad'ëëd is do hadoo né hẽ P'op Hagä Do bag'ããs doo, tadu doo noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jããm nad'ëëd its né paawä ta tym, ji waa ty gamabuuj see bahǟnh tabawäng. Tak'ëp ta moo bawäng. Tii hã kä taw'ëëd batooj kän ta hã kä, tabadahẽẽm bä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hajõng ta ti hedoo pé panyyg ky n'aa gó Jesus baher'oot sa hã P'op Hagä Do panyyg n'aa. Jesus her'oot mä sa hã rahyb n'aa hajaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sahõnh taher'oot do sa hã, panyyg ky n'aa me m' tamaher'oot. Sa mab hẽ, rabedoh bä m', Jesus baher'oot ta ma matëg sa hã nyy d' tahanäng pé panyyg gó teh'ũũm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ti noo gó m', tug bä kä m', Jesus ky hadoo ta ma matëg sa hã: —Hamäh, ër atsëg hõm karaj'aa tamyyj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ti m' raberéd b'ëëh hajõk doo, ti m' ragatsëg t'oonh marakate gó Jesus gasooh doo gó. Ti m' rabatsëg kän. Marakate wób an'aa sa jawén. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ti m' tak'ëp bah'ood bana. Tewëëp mä maadaka. Marakate tetaa m'. P'eets mä marakate bagyyb jëë paawä. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Marakate duu hẽnh mä Jesus baỹỹh. Ta nu tyng jó m' ta nu sooh. Ti m' ta ma matëg ramebëë nyyh, ti m' raky hadoo: —Ma matëg! Õm h'yy kanap'eed! Ër da ag'yyp! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ti m' tabas'ëëg gëët, ti m' bah'ood tameduuk. Ti m' maadaka hã taky hadoo: —Bag hẽnh! Ti m' bah'ood badoo wät. Badatih däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ti m' taky hadoo sa hã: —Hëd n'aa tak'ëp bë beỹỹm? Dooh P'op Hagä Do hã bë h'yy kae nä bä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ti m' tak'ëp mä rabeỹỹm bong, ti m' rakaner'oot sa mab hẽ: —Jaa ti hỹỹ éh? Bah'ood, maadaka sii hẽ raky daheeh! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ti m' rakajaa Geras buuj sa häj n'aa bä, karaj'aa tamyyj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ti m' Jesus gatsëg nyyh jawén paa bä m', aj'yy karap'aar h'yyb nesaa doo, mera doo, nayyw hẽ m' tabana ta wë. Pä gabaho doo gó, panang buuj dejëp do sa kamag n'aa radebong doo bä naa tabana. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tii b' né hẽ m' tabahe'ỹỹh. Dooh m' hajaa pé moo mawyyt péh. Haak sapuuw hadoo doo me né hẽ m' ramoo maw'yyd né paawä m', dooh m' rahaja bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hajõõ nuu me m' haak sapuuw hadoo doo me ramoo mawyyt, ratsyym maw'yyd paawä m'. Ti m' tagahet'ëëh mä haak sapuuw hadoo doo. Sapaar ta tsyym pëm tagahet'ëëh né m' tii d' ẽnh. Dooh ta hã hajaa meduuk péh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adëb bä, atsëm na-ããj mä tabahew'ëët kamag habong hẽnh, waëë jó na-ããj hẽ. Tak'ëp mä tageëënh, ta daaj hẽ m' takahej'ooh pä bäh me. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dawëë naa m' Jesus tabahapäh bä m', waj'aa däk mä ta wë. Ti m' ta taron nuu me m' tabahyy häng Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ti m' tak'ëp mä ta kyyh: —H'ëëd makarẽn wë ỹỹ, Jesus, P'op Hagä Do T'aah, Sahõnh hẽ Bahǟnh Hadoo Do T'aah? Maky dëë P'op Hagä Do häd gó, dooh da ỹ marejã bä! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tii d' tawén edoo mäh, karap'aar h'yyb nesaa do Jesus ah'eed hõm do hyb n'aa m'. Hahỹỹ da m' Jesus kyyh: —Meréd hõm hahỹ aj'yy! —näng mä karap'aar h'yyb nesaa do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti m' Jesus beaanh ta hã: —Nyy d' a häd? —näng mäh. —“Hajõk Doo” ãã häd, —näng mäh —hajõk do hyb n'aa ããh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ti m' tets'ẽẽ had'yyt mä Jesus hã tanah'eed hõm hyb n'aa dawëë karap'aar h'yyb nesaa do ta tii bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hajõng mä too yb tii b' habëëh karaj'aa takëën hã, wajapëm doo bä. Ta tii b' mä sa waa rabahew'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ti m' karap'aar h'yyb nesaa do rabetsẽẽ Jesus hã: —Man'oo ãã ajëë pëë too yb hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ti m' Jesus banoo tii d' sa hã. Ti m' karap'aar h'yyb nesaa do benä kän aj'yy hã hanäng do paah, too yb hã m' rabajëë pä kän. Hajõng mä ti too yb. 2 miw mäh. Ti m' rameraa bong, ti m' rawaj'aa wëënh tame, tame m' rakejäg bëënh. Ti m' t'õp mä rapehǟs. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti m' too yb hagã n'aa waj'aa bong mäh. Sa panang bä, panang nedaa bä na-ããj mä ramaher'oot sahõnh hẽ rahapäh doo. Ti m' panang buuj raban'yyh t'ĩĩ hẽnh, rabaheg'ããs hyb n'aa ky n'aa näng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ti m' Jesus wë rakajaa bä kä, rabahegãã kän aj'yy hajõng do karap'aar h'yyb nesaa do hanäng do paah. Asooh mäh, saroor näng mäh, baad däg mä ta h'yyb tym. Ti m' rabeỹỹm bong. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti m', ta ti hap'ëëh do paa rabaher'ood kän han'aa do sa hã kä ta ti aj'yy karap'aar h'yyb nesaa do hanäng do paa ky n'aa. Too yb ky n'aa na-ããj mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ti m' han'aa do rabetsẽẽ Jesus hã, tabahõm hyb n'aa sa häj n'aa bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti m' Jesus gatsëg sooh bä m', aj'yy karap'aar h'yyb nesaa do hanäng do paa betsẽẽ Jesus hã, Jesus sii tabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dooh m' Jesus karẽn bä ta sii aj'yy ahõm bä. Hahỹỹ d' mä Jesus kyyh ta hã: —Ahõm nä a yb, a ỹỹn, a wakããn wë. Maher'ood sa hã sahõnh hẽ taw'ããts hẽ hadoo do a hã Tak'ëp Hyb n'aa Jawyk Do bad'oo doo. Maher'ood sa hã nyy da õm tat'yyd mehĩĩn doo —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ti m' aj'yy bahõm kän. Hëëj bód, Dekaporis häd näng doo bä taher'oot mä tak'ëp hanäm do Jesus bad'oo do ta hã. Ti m' sahõnh hẽ maa nap'ëëh do rahyb n'aa meuunh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ti m' Jesus batsëg hõm bä p'aa hẽnh karaj'aa ta myyj jé, tabag'ëëd däk bä ta takëën hã, hajõk nu sabug däk. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ti m' aj'yy Jaj-Ro häd näng do bana Jesus wë. Tób P'op Hagä Do panyyg rayd naherot do sa wahë n'aa see m' tii. Ti m' Jesus tabahapäh bä, ta taron nuu me m' tabahyy häng ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ti m' tak'ëp mä tabetsẽẽ ta hã. Hahỹỹ da m' ta kyyh: —Edah tok ỹ tadajëp. B'ëëp ỹ karẽn paawä. Moo dëë ta hã tabahub däk hyb n'aa, tabedëp hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ti m' Jesus bahõm ta sii. Tabahõm bä hajõk mä hah'ũũm ta sii, gatat'uuk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sa mahang ti awät mä ỹỹnh. Majyyw mä ta nahëëh. 12 m' ta baab ta nahëë badäk. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hajõk mä mediko hegãã bong do ta nahëëh. Mediko moo m' tahoop. Dooh m' rahaja bä. Ta wë hanäng do tahäj jëë né paawä m', dooh m' tahas'oo däg bä. Teg'yys mä tii bä ta nahëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesus taky n'aa napäh bä m', ta jó gadäk hẽnh mä tabana ta wë hajõk do mahang. Ta saroor hã m' tamoo däng. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tii d' tawén d'oo mäh, ta h'yyb gó m' taky hadoo: “Ta saroor hã ỹ moo dëë bä, ỹ d' ahub däk tii bä”, näng mä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tii bä kä m', nayyw hẽ m' dooh wäd mä ta hã ta nahëëh. Ta hã m' tahegãã bä, ta h'yyb gó, has'oo däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tii bä m' nayyw hẽ m' Jesus hegãã bä m' ta hã naa anyyh ta ky gabuuj. Ti m' ta jawén p'aa hẽnh tabegãã wät hajõk do mahang, ti m' teaanh: —Jaa saror ỹỹ hã moo däng? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ti m' ta ma matëg raky hadoo: —Nepäh a hã hajõk gatat'uuk do a hã? —näk mäh. —Hëd n'aa ti meaanh? ");
INSERT INTO mbjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ti m' ty kaneréd had'yyt hẽ hajõk do sa wë, tabaheg'ããs hyb n'aa jaa ti ta hã moo däng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ti m' ỹỹnh hegãã bä kä m' ta hã has'oo däk mäh, ana mä Jesus wë, ti m' tabahyy häng mä ta taron nuu me ta wë. Kajajãn mä ta ǟm n'aa. Ti m' sahõnh hẽ m' tabaher'ood jëng ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ti m' Jesus ky hadoo ta hã: —Tok ỹỹ, õm has'oo däk P'op Hagä Do hã mah'yy ka'eeh do hyb n'aa. Ahõm kä h'yyb näm doo me. Dooh wäd a nahëë kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus ber'oot nä bä m', rakajaa ajyy Jaj-Ro tób bä naa. Ti m' raky hadoo Jaj-Ro hã: —A toog h'yy gakog hõm —näk mäh. —Hëd n'aa ti mah'yyb panas'ëëh ma matëg? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dooh m' Jesus hyb n'aa p'eed bä panäk do sa kyy hã. Hahỹỹ d' mä ta kyyh Jaj-Ro hã: —Mahyb n'aa tón manäh. Hã ỹ h'yy kasadëë! ");
INSERT INTO mbjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ti ta bahǟnh mä dooh m' tan'oo bä hajõk do rahõm ta sii. Jããm mä takarẽn Peed, Tsijaag, Tsijaag hỹỹj Jowãw häd näng doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesus rakajaa bä m' Jaj-Ro tób bä kä tahapäh mä séd dó m' raräb bä rabë bä. A'oot mä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti m' tabajëë suun tób gó, ti m' taky hadoo sa hã: —H'ëëd ti bë haräp? H'ëëd ti bë ha'oot? Karapee dooh tadajëb bä. Aỹỹh tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tii bä m' Jesus raky kawew'aam. Jesus mejũũ raban'yyh jawén paa bä m', tats'yyt mä karapee yb, karapee ỹỹn, ta ma matëg ta sii han'aa doo, ti m' rabajëë p'ëë karapee hasooh hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti m' tamoo maso däk, ti m' taky hadoo ta hã: —Tabita kũm —näng mä ta kyyh. (“Maruus, as'ëëg g'ëëd!”, tahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tii bä m', nayyw mä tabas'ëëg gëët, awäd däk mäh. (12 m' ta baab n'aa.) Tii bä m', tak'ëp mä rameuuj bong. ");
INSERT INTO mbjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ti m' tak'ëp Jesus mejũũ sa hã ranaher'oot hyb n'aa ta ti ky n'aa. Ti m' tamaher'oot sa hã rabanoo hyb n'aa maruus awa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ti m' ta tii bä naa Jesus ta ma matëg daheeh rabahõm panang tabawäng do paa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Saab hã kä m' tama metëëk tób P'op Hagä Do panyyg rayd naherot do yt hẽ. Hajõk maa new'ëë do rahyb n'aa meuunh mä taher'oot do sa hã. Ti m' raky hadoo: —N'yy hẽnh naa taher'oot do P'op Hagä Do ky n'aa? —näk mäh. —N'yy hẽnh naa tah'yy ganäng doo? —näk mäh. —Nyy da tabad'oo tapehuunh doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—B'aa bäh gaheh'õõk do nado ti hahỹỹh? Marija t'aah nado ti hỹỹh? Tsijaag, Josés, Judas, Simaw nado ta wakããn? Ta ǟnh, bä ab'ëëh ër pa —näk mä sa kyyh. Ti m' rakawajããn ta wë. Raty n'aa gesyyg däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ti m' Jesus ky hadoo sa hã: —Sahõnh hẽ sa panang bä raweh'ëëh P'op Hagä Do ky n'aa rod. Jããm hẽ tabawäng do panang bä, ta wakããn mahang, ta tób bä, dooh rawehëë bä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dooh denaa hẽ m' Jesus pehuuj bä ta tii bä. Jããm né hẽ m' pawóp its nahëë enäh do hã ta moo tadasooh rabaheso padëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tahyb n'aa meuunh mäh, dooh panang buuj rah'yy kae bä tahegãã bä. Ti m' sét panang ken'yyh bä m' Jesus ma metëëk. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ti m' tanaëënh 12 hedoo do ta ma matëg ta wë. Ti m' Jesus anoo mä sa hã karap'aar h'yyb nesaa do rabahajaa rabahebë hyb n'aa. Pawóp hẽ ken'yyh mä tamejũũ rabahõm Jesus bad'oo doo da rabad'oo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hahỹỹ da m' tamejũũ: —Dooh d' bë mahũũm péh, pãw hadoo péh, ta hood hadoo péh, ta säm hadoo péh. Jããm hẽ da bë mahũũm tatu —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","—Jããm ub da bë saroor bë hã hadäk do bë gahõm. Bë tsyym suun hẽ kä bë padedëëk —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bë nu kajäg bä ta wób tób bä, tii bä da bë ayyw dó sa panang bë beréd hõm bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jé bë raganado bä, bë ramaa nanewë bä bë her'oot doo, bë ahõm sa mahǟnh. Sa panang bä naa bë ahõm bä bë tsyym suun bë tepyng padäg k'ããts. Tii da bë bad'oo, rabahapäh hyb n'aa dooh baad tado bä P'op Hagä Do panyyg raky nadaheeh doo —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ti m' rabahõm kän. Raketyn hõm. Jé pad'yyt hẽ m' rabaher'oot reréd hõm hyb n'aa nesaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hajõng karap'aar h'yyb nesaa do rahebëë hõm mäh. Hajõk nahëë enäh do ta syyj me m' ratahed'yyd hõm, heso hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti m' Garirej häj n'aa wahë n'aa, Eróts häd näng doo, taky n'aa napäh tii. Dawëë m' Jesus raky n'aa napëë däk. Hahỹỹ d' mä ta wób sa kyyh: —Jowãw nu gahem'uun do paa né tii, dejëp do mahang ganä wät doo. Ti hyb n'aa tawén kabaj'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","—Ta ti Eriij p'ooj ub hawät do paah —näk mä ta wób sa kyyh. Ti m' ta wób hẽ raky hadoo: —P'op Hagä Do ky n'aa rod p'ooj ub habong do paa hadoo pé ta tii —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eróts ky n'aa napëë däk bä kä ta wób her'oot doo, taky hadoo: —Jowãw nu gahem'uun do tii, ỹ mejũũ do paa ranu gahõg hõm. Ganä wät dejëp do paa mahang! —näng mä Eróts kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eróts né ti mejũũ do paa ramoo maso däk, ramoo maw'yyd däk, radawäts gëët Jowãw nu gahem'uun doo. Tii d' Eróts wén d'oo mäh, Erodija, ta hỹỹj Pirip häd näng do ỹỹm hyb n'aa. Eróts gat'ëë däk mä Erodija, ta hỹỹj ỹỹm. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti hyb n'aa m' Jowãw ky hadoo paa ta hã: —Dooh P'op Hagä Do ky n'aa jaw'yyk do an'oo bä magat'ëë bä a hỹỹj ỹỹm. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jowãw kyyh hyb n'aa m' Erodija ty n'aa gesyyg kän, tawén kawaj'ããn kän ta wë. Takarẽn paawä m' tamejũũ radaj'ëëp Jowãw. Du daa m'. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eróts mo n'aa jesuu mä Jowãw. Eróts mä eỹỹm Jowãw hã. Tahapäh mäh, baad ub né hẽ ti Jowãw bawät P'op Hagä Do matym gó. Tsyt hẽ P'op Hagä Do wë Jowãw bawät tahapäh. Eróts maa newëë bä m' Jowãw her'oot doo, dooh m' baad tado ta h'yyb gó. Ti hadoo né hẽ, tamen mä Jowãw her'oot do tamaa newë bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tii bä kä m', ti bahǟnh kä m', Erodija bawyyd kän nyy d' tabad'oo. Eróts ta yd enäng do heen n'aa noo gó m' Eróts moo wät jäm. Tatsyyd bong mä ta karapee sa wahë n'aa, ta warahén sa wahë n'aa, sahõnh hẽ m' ky n'aa etsëëh do Garirej häj n'aa bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti m', jäm noo gó m', Erodija toog bana tabajäm hyb n'aa sa matym gó. Baad mä maruus sa matym gó, Eróts matym gó na-ããj mäh. Ti hyb n'aa m' Eróts ky hadoo ta hã: —Mets'ẽẽ hã ỹ makarẽn péh. Ỹ anoo né da a hã —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","P'op Hagä Do häd gó m' ta ky däng: —Metsẽẽ pé hã ỹỹ, ỹ anoo né da a hã. Wë ỹ hanäng do uuh ỹ anoo da a hã, makarẽn bä. Né hup ỹ né hẽ tii —näng mä Eróts kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ti m' maruus banyyh ta ỹỹn wë tabeaanh hyb n'aa tetsẽẽ pé Eróts hã. Ti m' ta ỹỹn ky hadoo: —Mets'ẽẽ Jowãw nu gahem'uun do nu gabóg —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ti m' nayyw hẽ m' maruus matëëh p'aa hẽnh. Ti m' tabets'ẽẽ kän: —Na, ỹ karẽn nayyw hẽ mabanoo hã ỹỹ Jowãw nu gahem'uun do nu gabóg ta hood gó —näng mä maruus kyyh Eróts hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ti m' tak'ëp sa wahë n'aa hyb n'aa tón wät mäh. Ti hadoo né hẽ, ta ky bajawaa do hyb n'aa m', tatsyyd bong do taky däng do ramaa napäh do hyb n'aa m', tawén wanadii. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ti m' nayyw hẽ m' tamejũũ warahén see Jowãw tadaj'ëëp hyb n'aa, tamanaa hyb n'aa ta nu gabóg. Ti m' warahén bahõm Jowãw ragadahew'ëës doo hẽnh, tadaj'ëëp mä Jowãw, tanu gahõg hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tamanaa mä ta hood gó, tan'oo däk mä maruus hã. Ti m' maruus gado däk, tan'oo däg kän mä ta ỹỹn hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti m' Jowãw ma matëg ky n'aa napëë däk bä m', rabana rabehëën ta hub. Ti m' ti m' radasuun jëng gabaho doo gó, kamag hood n'aa gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ti m' 12 hedoo do Jesus mejũũ do rababaaj nä Jesus wë. Ti m' rabaher'oot ta hã sahõnh hẽ rametëëk doo, ramoo bok doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta tii bä m' séd dó m' ta wë heg'ããs doo. Séd bä m' ranu kejäk do hyb n'aa, du daa m' Jesus ta hataa daheeh rabawa péh. Ti hyb n'aa m' Jesus ky hadoo ta hataa sa hã: —Hamäh, ër ah'ũũm ta wób rabedoh hẽnh, bë kameh'ããk hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ti m' sa mab hẽ m' rabahõm marakate gó ta wób rabedoh bä paawä. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta wób mä rahapäh raban'yyh. Ti m' sahõnh hẽ panang bä naa rabahõm ta takëën hã sa pooj jé. Sa pooj jé m' rakajaa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ti m' Jesus basoop bä, hajõk do tabahapäh bä m', tat'yyd mehĩĩn mä sa hã. B'éé hagã n'aa tamah do hadoo mä ta hã. Ti m' hajõng ky n'aa tama met'ëëg kän sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tũũh däg bä kä m' ta ma matëg rabana ta wë, ti m' raky hadoo ta hã: —Tũũh däg —näk mäh. —Dawëë hỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mamejõ hõm hajõk doo, panang tabanäng bä, sét ken'yyh rabaj'eenh hẽnh na-ããj hẽ, sa waa rabetsẽẽ hyb n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ti m' Jesus ky hadoo: —Bë né hẽ hanoo sa waa —näng mäh. Ti m' raky hadoo: —Ta ti 8 kamarab ji moo wät ta säm —näk mäh. —Ãã né hẽ g'eeh ti hets'ẽẽ ta ti sa waa pãw? —reaanh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ti m' Jesus beaanh: —Nyy hẽ ti hanäng bë wë pãw? Bë hegãã —näng mä ta kyyh. Ti m' rabaheg'ããs, ti m' raky hadoo: —Ti anäng ji ma poo oow pé pãw. Pawóp its tah'ỹỹb —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti m' Jesus mejũũ ramejũũ hajõk do rabehyy b'ëëh hyb n'aa jawii jó. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ti m' rabehyy b'ëëh, 50 ken'yyh mä ta wób, 100 ken'yyh mä ta wób ketyn hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ti m' Jesus basog däk pãw, tah'ỹỹb na-ããj mäh. Hỹ pong jé taty däng bä m', P'op Hagä Do hã taky hadoo: —Õm taw'ããts hẽ Ee. Man'oo däk ãã tä, ãã waa —näng mäh. Ti m' pãw taganebäh bong, tets'ëë hõm mä ta ma matëg sa hã, rabets'ëë hõm hyb n'aa hajõk do sa hã kä. Tah'ỹỹb na-ããj né hẽ m' pawóp had'os do tetyn hõm né hẽ m' tii d' ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tii bä kä m', sahõnh hẽ m' rabawëë bong. Wog enä hõm mä sahõnh hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ti m' mad'aak do ta ma matëg rata hõm kawaju gó. 12 m' kawaju gedẽ hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hawëë bong doo, 5 miw mä ajyy. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ti m' nayyw hẽ ta ma matëg Jesus mejũũ ragatsëg t'oonh marakate gó, ta pooj jé rabahõm hyb n'aa Betsaj-Da häd näng do panang nemuun. Ti nuuj jé m' takedëë hõm hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Takedëë hõm do jawén paa bä m' tabasëëk mä waëë jó P'op Hagä Do sii taber'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tabadajuu däk bä m', karaj'aa hoo gad'oo bä kä m' ta ma matëg rababoo däk. Ta mab hẽ m' Jesus bayyw gëët. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ti m' tabaheg'ããs, dooh m' tahõm rahëë doo. Bah'ood ty gahëm mäh. Ti m' tapaj'ëë pooj jé Jesus bahõm kän sa wë tamii pong jó. Jesus tabëëj paawä m', ");
INSERT INTO mbjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","rabahapäh tamii pong jó hana doo. Tak'ëp mä rabeỹỹm bong. Awaaw bong mäh. Dajëp do saw'ëëng paa red'oo mäh. Ti m' nayyw hẽ m' Jesus ber'oot sa sii: —Bë eỹỹm manäh! Ỹ ti hỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ti m' tagatsëg sooh sa sii. Ti m' bah'ood badoo wät. H'yy gabedo bong mäh. Rameuuj bong mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dooh rah'yy gah'ood nä bä Jesus hã, pãw tapehuuj né paawä. Dooh rah'yy genä bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Rabatsëg hõm bä m', Genesaréh häj n'aa bä m' marakate badëë jad kän. Tii bä m' rabahũũ jad kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ragatsëg bë sii hẽ m' pong hẽnh, ti babuj n'aa rabahapëë kän Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tak'ëp mä raty gapedäg bong ramenaa hyb n'aa nahëë enäh do Jesus wë. Jé pad'yyt hẽ hëëj Genesaréh w'oo hã hanäng doo bä naa ramenaa nahëë enäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jé pad'yyt hẽ Jesus nu kejäk bä m', panang rakahet'aa bä m' ramena bëëh nahëë enäh doo. Ti m' rabetsẽẽ nahëë enäh do ramoo kejäk hyb n'aa ta saroor noo byyh hã. Ti m' sahõnh hẽ nahëë enäh do moo kejäk doo, heso padäg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ti m' Pariséw wób, Mosees ky n'aa jaw'yyk do ma mehetëk do wób na-ããj mä rakajaa Jerusarẽnh hẽnh naa. Ti m' rakata däk Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ti m' rabahapäh, Jesus ma matëg wób rawëh mä ta si n'aa hẽ. Dooh m' ramoo ketsyyd wäd rabahed'oo doo da. Sa hã m' nesaa do ta ti P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Pariséw, sahõnh hẽ Judah buuj wób na-ããj hẽ, dooh rawëë bä, dooh rawa bä, sa wahë makũ mahetëk doo da ramoo kanetsyyd pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rabana bä jé sa waa hets'ẽẽ do paah, dooh rawa bä, dooh rawëë bä, ramoo kanetsyyd bä, rabahed'oo doo da. Hajõõ tamo n'aa tii da rabahed'oo doo. Sarej ragejõs, sa waa hood ragets'yyt sa wahë makũ mahetëk doo da.) ");
INSERT INTO mbjNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ti m' Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj mä rabeaanh Jesus hã: —Hëd n'aa a ma matëg ranad'oo ãã wahëh metëëk doo da? Hëd n'aa dooh ramoo ketsyyd bä ër wahë makũ rabahed'oo doo da? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ti m' Jesus ky hadoo sa hã: —J'ooj madäk doo me ky ken'yym do bëëh! Baad né paa ti P'op Hagä Do ky n'aa rod Isajas häd näng do kyyh, bë ky n'aa. Hahỹỹ d' paa m' takerii däk P'op Hagä Do kyyh bë ky n'aa: “J'ooj madäk doo me ỹ raweh'ëëh. Sa kyyp tii. Dawëë sa h'yyb bawät mahǟnh ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dooh këh ỹ tado bä ti rama metëëk doo. Raky n'aa jawyyg ub tii. Ti hyb n'aa daap hẽ ti ta ti ỹ rahyb n'aa jew'yyk doo” —näng mä Jesus, Isajas her'oot do paa P'op Hagä Do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ti m' taky hadoo ẽnh: —Bë eréd hõm P'op Hagä Do mejũũ doo. Bë wareem däg bë wahë makũ metëëk do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ti m' Jesus ej'ees sa hã: —Baad né ta ti bë hã P'op Hagä Do mejũũ do bë eréd hõm doo, bë wahë makũ mejũũ doo da bë bad'oo hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hahỹỹ da Mosees metëëk do paa P'op Hagä Do mejũũ doo: “Bë wehëë bë yb, bë wehëë bë ỹỹn.” “Ji daj'ëëp ta yb, ta ỹỹn ky n'aa wasee doo.” ");
INSERT INTO mbjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tii d' né paawä ta kyyh, ta see hado däk bë metëëk doo —näng mä Jesus. —Hahỹỹ da bë kyyh: “Jé ta yb, ta ỹỹn hã taky hado bä, ‘Hã ỹ naa magadoo do pan'aa paawä, P'op Hagä Do matym n'aa däg tii. Dooh bë hã ỹ an'oo wäd bä’, taky hado bä, ");
INSERT INTO mbjNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","tii bä, ta tii d' ky hadoo doo, dooh ji mejõ wäd bä ta ỹỹn, ta yb tamasa”, näk bë kyyh. Hajõng nä tii d' bë bad'oo doo —näng Jesus. —Bë wahë makũ ma metëëk do bë ky sũũt do hyb n'aa bë eréd hõm P'op Hagä Do mejũũ doo —näng mä Jesus Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ti m' p'aa hẽnh hajõk do ta tii bä hab'ëëh do Jesus naëënh ta wë. Ti m' taky hadoo sa hã: —Bë sahõnh hẽ, bë maa newë da, bë h'yy genä da ỹ her'oot do hã: ");
INSERT INTO mbjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ji noo me hajëng pé hyb n'aa nado ji nas'aa däk P'op Hagä Do hã. T'õp ji h'yyb gó naa hanyyh do ti hanoo ji nas'aa däk do P'op Hagä Do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ti m' Jesus kedëë hõm hajõk do sa hã. Ti m' tób gó tabajëë suun jawén paa bä ta ma matëg rabeaanh ta hã ta ti taher'oot do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ti m' Jesus baher'oot sa hã: —B'ës h'yy ganah'ood éh? —näng mäh. —Ji hã hajëng pé hyb n'aa nado ji nas'aa däk P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta ti dooh tajëë bä ji h'yyb tym gó. Ji wog gó ti tabajëng, ta jawén anyyh p'aa hẽnh. Ti hyb n'aa dooh ji nas'aa bä P'op Hagä Do hã ji noo gó hejëng do hyb n'aa —näng mäh. (Ta ti m' Jesus her'oot do ky n'aa m', taw'ããts mä sahõnh hẽ baad ub ji waa. Dooh m' ti haj'aa tado bä ji nas'aa bä.) ");
INSERT INTO mbjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ti m' taky hadoo ẽnh: —Ta ti ji h'yyb gó naa henyyh do hyb n'aa ji nas'aa däk P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tii d' ỹ wén her'oot, t'õp naa, ji h'yyb tym gó naa tabana do hyb n'aa nesaa do ji hyb n'aa newëë doo. Ji h'yyb gó naa tabana ji karẽn do ji bagä do ji ỹỹm nadoo do sii, ji patug nadoo do sii. Ji h'yyb gó naa tabana ti ji ets'ëëk doo. Ji h'yyb gó naa né hẽ tabana ji da hadoo do ji daj'ëëp doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ji h'yyb gó naa né hẽ tabana ti ji hyb n'aa h'ũũm do ji ma, sahõnh hẽ ji moo nesaa doo, ji noo kanesa doo, nu meby n'aa näng doo, ji hyb n'aa jewës doo, ji da hadoo do ji ky n'aa rejãã doo, ji kasab'ee doo, daap hadoo do ji moo wät doo kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sahõnh hẽ ta ti hedoo doo, ji h'yyb gó naa had'yyt tabana. Ta ti hyb n'aa ti ji wén nas'aa däk P'op Hagä Do hã —näng mä Jesus kyyh ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ti m' ta tii b' naa Jesus bahõm panang Tiir häd näng do nemuun. Ajëë suun mä tób gó. Dooh m' takarẽn raky n'aa napëë bä tii b' tabagä doo. Ti hadoo né hẽ, dooh m' tahaja bä tajejën bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ti m' ỹỹnh, Gereg buuj, Siro-Penisija bä m' henäng doo, ky n'aa napäh Jesus. Judah buuj nadoo do m' tii. Ỹỹnh toog hã mera do badäk. Ti m' tabana Jesus wë. Ti m' ta taron nu paa me tabahyy häng Jesus wë. Ti m' tak'ëp mä tabetsẽẽ Jesus bahabëë hõm hyb n'aa karap'aar h'yyb nesaa do ta toog hã hadäk doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ti m' Jesus ky hadoo: —Na rawa dó sa waa rakarẽn do sa taah hã —näng mäh. —Taw'ããts hẽ nado sa waa ji ado hõm bä ji banoo hyb n'aa sa masããh awaar taah hã —näng mä Jesus kyyh ỹỹnh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ti m' ỹỹnh ky gadoo Jesus. Jesus kyy gó né hẽ m' taky hõm: —Ehub né hẽ õm, Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Ti hado né paawä, awaar sii hẽ rawa sa taah waa hyyj sa noo m' kejäk doo —näng mä ỹỹnh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ti m' Jesus ky hadoo ta hã: —Abaaj hõm. H'yy ka'eeh doo me ỹ maky gadoo do hyb n'aa, dooh wäd karap'aar h'yyb nesaa do a toog hã —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ỹỹnh babaaj hõm bä kä m', takajaa ta toog wë, ahub däk ta toog. H'yy kamehããg sooh mäh. Karap'aar h'yyb nesaa do ahõm ta hã hadäk do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ti m' Jesus raberéd hõm Tiir häj n'aa. Sidõn häd näng do hëëj, Dekaporis häd näng do häj n'aa na-ããj hẽ ratabës. Ti m' karaj'aa Garirej häd näng doo hẽnh rabaw'ëënh. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jesus rakajaa bä m', ramanaa mä ta wë aj'yy nabuuj gatamah doo, hebä doo. Ti m' rabetsẽẽ Jesus moo däng ta hã tabahub däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti m' Jesus mahũũm mä dawë hã, hajõk do sa mahǟnh. T'ĩĩ hẽnh kä m' ta nabuuj gó m' tamoo jëë pëë. Ti m' ta mo poo hã Jesus betsós wät, tii bä kä m' aj'yy nag'aad hã m' tamoo däng. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hỹ pong jé m' taty dëë wät, tak'ëp mä tah'yy kawabaag wät, ti m' taky hadoo: —Epata! —näng mäh. (“Genä däg”, tahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tii bä m' nayyw hẽ m' aj'yy nabuuj genä padëëk, ta nag'aad na-ããj mä nahejooj wäd mäh. Baad ub mä taber'ood däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ti m' Jesus mejũũ ranaher'oot hyb n'aa ta wób sa hã. Nabuj keh'ũũm mä tii. Tak'ëp mä Jesus mejõ paawä ranaher'oot hyb n'aa, tak'ëp mä tii bä rabaher'oot Jesus mo haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sahõnh hẽ m' rameuunh Jesus mo haj'aa hã. Ti m' raky hadoo: —Baad sahõnh hẽ tamo haj'aa —näk mäh. —Nabuuj gatemah do sii hẽ nabuuj genä padëëk, ner'oot do sii hẽ er'ood padëëk tan'oo bä —näk mä sa kyyh Jesus mo haj'aa ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti m' ta see pé noo gó hajõk do rakata padëëk p'aa hẽnh ẽnh. Dooh m' sa waa péh. Ti hyb n'aa m' Jesus naëënh ta ma matëg, sa sii taber'oot hyb n'aa. Ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ỹ t'yyd mehĩĩn hahỹ ër wë kata pad'ëëk doo. Tamawoob däg ta ǟh si ỹ rababok. Dooh sa waa péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","—Dawëë naa ta wób rabana. Ỹ mejõ bä rababaaj hõm sa gó, naheba padäg da, degõn jëng da sah mahỹỹj ta hõõ bä —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ti m' ta ma matëg raky hadoo: —Nyy bä ji baw'yyt babä sa waa? Dawëë bä. Dooh ta nawaa babä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ti m' Jesus beaanh: —Nyy hẽ pãw bë wë? —näng mäh. —Ti anäng setsi —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ti m' Jesus mejũũ hajõk do rabehyy b'ëëh tũũ. Ti m' tabasog däk pãw, ti m' taky n'aa etsẽẽ sa waa hyb n'aa. Tii bä m' taganebäh boo kän, tets'ëë hõm mä ta ma matëg sa hã, rabets'ëë hõm hyb n'aa hajõk do sa hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tah'ỹỹb na-ããj mä ti anäng mä sa wë. Ned'ëëd its mä ti tah'ỹỹb. Tii da né hẽ m' taky n'aa d'oo ẽnh tii. Ti m' tamejũũ ta ma matëg rabets'ëë hõm hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tii bä kä m', sahõnh hẽ m' rabawëë bong. Wog enä hõm mä sahõnh hẽ. Ti m' rabawëh do jawén paa bä m' mad'aak do ta ma matëg rabata däk arook gó. Setsi m' arook gedẽ hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","4 miw mä ajyy tahyb n'aa pé ti hawëë bong doo. Hajõk do hã Jesus kedëë hõm jawén paa bä m', ");
INSERT INTO mbjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tagatsëg sooh mä marakate gó ta ma matëg sa sii hẽ m'. Ti m' rabahõm Daramut häd näng do häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Rakajaa bä m', Pariséw rabana ta wë. Hajõng mä reaanh ta hã. Jesus rametyy hyb n'aa ramejũũ mä tapahuuj bä sa matym haj'aa wë hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ti m' tak'ëp mä tah'yy kawabaag wät, j'ooj madäk doo me ramejũũ do hyb n'aa m'. Ti m' taky hadoo: —Daap hẽ da hẽ habong do rabetsẽẽ hã ỹỹ ỹ pahuunh hyb n'aa sa matym haj'aa —näng mäh. —Dooh ỹ metëëh pé ta heen n'aa hahỹ sa hã. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tii bä m' Pariséw taberéd b'ëëh, ti m' p'aa hẽnh tagatsëg sooh marakate gó, ti m' rabatsëg hõm karaj'aa ta myyj jé. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta ma matëg ramabaan mä ramahũũm sa waa pãw. Jããm hẽ sét its mä pãw marakate gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ti m' Jesus ky hadoo sa hã: —Baad bë hyb n'aa matakä da. Baad bë kanä da Pariséw, Eróts sa pãw makuj n'aa mahǟnh —paa tamaher'oot mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ti m' ta ma matëg rakaner'ood bong Jesus her'oot do ky n'aa. Hahỹỹ d' mä sa kyyh: —Dooh ër wë pãw. Tii d' tawén edoo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ti m' Jesus hapäh ti raky n'aa hajẽm doo. Ti m' tabeaanh sa hã: —H'ëëd hyb n'aa pãw bë mabaan hõm bë banäng? —näng mäh. —Dooh tagah'ood nä bä bë hã? Dooh bë h'yy kadawuung nä bä? —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","—Bë matym enä né paawä, dooh bë hapëë bä. Bë nabuuj genä né paawä, dooh bë maa napëë bä. Bë mabaan ");
INSERT INTO mbjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","5 pãw ỹ etyn bong do 5 miw sa hã? Nyy hẽ kawaju bë gedẽ hõm mad'aak doo? —12 kawaju mad'aak —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ti m' Jesus eaanh ẽnh: —Setsi pãw ỹ etyn bong do 4 miw sa waa, nyy hẽ arook bë gedẽ hõm mad'aak doo? —Setsi arook mad'aak —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ti m' Jesus bedoo sa hã: —Dooh bë h'yy genä nä bä? —näng mä ta kyyh ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ti m' Jesus rakaja kän Betsaj-Da häd näng doo bä panang bä. Ti m' ramanaa mä ta wë aj'yy ty gadajuu däk doo. Retsẽẽ mä Jesus moo däng ta hã tabahub däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ti m' Jesus maso däk ta moo hã, tamahũũm mä dawë hã panang bahǟnh. Ti m' Jesus ty hetsós wät, ti m' tamoo däng ta hã. Ti m' tabeaanh ta hã: —Äkä, mahapëë däk? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti m' tabeg'ããs, ti m' taky hadoo: —Dooh baad ỹ hapëë nä bä. Ỹ hapäh habong doo. B'aa hadoo hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ti m' p'aa hẽnh Jesus moo däng ta matym hã ẽnh. Ti m' ta matym baad däg kä. Baad mä tabahapäh tii kä. Dooh m' taty gadajuu wäd bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ti m' Jesus mejũũ tababaaj hõm ta tyw n'aa see me ta tób hẽnh. Dooh m' takarẽn myyj hẽnh tajëë wäd. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ti m' Jesus rabahõm panang wób Sesareja Pirip panang häd näng nedaa badäk doo hẽnh. Ti m' ramahõm me tabeaanh ta ma matëg sa hã: —Jaa m' ỹỹh, sa nooh? ");
INSERT INTO mbjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ti m' raky hadoo: —Ta wób noo m', õm mä Jowãw nu gahem'uun do paah. Ta wób noo m', õm mä Eriij makũũh. Ta wób noo m', õm mä P'op Hagä Do ky n'aa rod p'ooj ub dejëp do paa seeh —näk mä sa kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Bë hã ẽnh? Jaa ỹ bë hã ẽnh? —näng mä Jesus sa hã. Ti m' Peed ky hadoo: —Õm ti Kristo, P'op Hagä Do H'yyb Däng Doo —näng mä Peed kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ti m' Jesus mejũũ ranaher'oot hyb n'aa ta wób sa hã ta ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ti m' Jesus du doo tama metëëk do ta hataa. Tama metëëk bä m' taky hadoo: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, hajõng da ỹ ahoop. Ër wahë n'aa, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa na-ããj da, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ, ỹ da rahyb n'aa wareem. Ỹ da dajëp ran'oo bä. Tamawoob hẽ ta ǟ jawén paa bä, ỹ ganä wät da p'aa hẽnh —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Baad mä ta ky n'aa tabaher'oot. Ti m' Peed naëënh dawë hã. Ti m' taky ge'ỹỹm, Jesus tii d' tanaher'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ti m' Jesus ty kaw'õõd däk ta ma matëg wób sa wë. Ti m' Peed taky geǟm wät. —J'eep! Ahõm mahǟnh ỹỹ, Nesaa Do Yb —näng mäh. —Dooh mah'yyb dëë bä P'op Hagä Do karẽn do hã. Ajyy rakarẽn do hã ti mah'yyb däk —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ti m' hajõk do ta wë kata däk doo, ta ma matëg na-ããj hẽ Jesus naëëj wät ta wë. Ti m' taky hadoo sa hã: —Jé karẽn pé hëp ỹ hata tabahadoo hyb n'aa, taw'ããts hẽ teréd hõm ta hã hẽ tah'yy ka'eeh doo, taw'ããts hẽ teréd hõm ta hã hẽ tahyb n'aa newëë doo. Taw'ããts hẽ da tagado had'yyt hẽ tahoop do hëp ỹ n'aa. Taw'ããts hẽ tagadoo hëp ỹ n'aa radajëëb bä na-ããj hẽ. Taw'ããts hẽ ỹ taky daheeh, taw'ããts hẽ ỹ bawät doo da da ti bawät. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tii d' ỹ wén edoo, badäk hahỹỹ hã ji hawät do tak'ëp kamahǟn doo, jé tahoop do hëp ỹ n'aa jeỹỹm doo, dooh da P'op Hagä Do wë tanu dëë bä. Jé hëp ỹ n'aa, panyyg hanäm do hyb n'aa na-ããj hẽ, tahoop do gadoo péh, hëp ỹ n'aa tadajëb bä, panyyg hanäm do hyb n'aa tadajëb bä, ta h'yyb tym P'op Hagä Do wë da tanu däng —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ti m' taky hadoo ẽnh: —Hëd n'aa ji karẽn sahõnh hẽ badäk hahỹ ji ta danäh, ji h'yyb tym banesaa hẽnh tahõm bä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","—Dooh ta säm ji ad'oo pé ta s'ee hẽnh ji h'yyb tym nahõm hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Hëp ỹ n'aa, ỹ ma metëëk do hyb n'aa na-ããj hẽ nu mebyng pé P'op Hagä Do hã hyb n'aa eréd hõm do sa matym gó, nesaa do moo heb'ooh do sa matym gó, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ d' nu mebyng ẽnh ta hyb n'aa, Ee hejój gó, ta bag tak'ëp gabarëëh doo gó ỹ bahyng noo gó ããs tak'ëp baad hedoo do sa daheeh —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti m' taky hadoo ẽnh: —Ta wób babä ër mahang habong do rahapäh nä da ỹ du doo noo gó sahõnh hẽ ỹ bag'ããs P'op Hagä Do hejój me. Radejëp do pooj jé rahapäh nä da tii. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ti m' ji moo oow see pé sa ǟ jawén paa bä m', Jesus mahũũm ta sii Peed, Tsijaag, Jowãw daheeh. Ti m' rabas'ëëg kän waëë p'op nu däk do hã. Sa mab hẽ m' t'ĩĩ hẽnh rabaym dó. Ti m' Jesus kawareem däk sa matym gó. Ta see hado däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tak'ëp mä ta saroor gabar'ëëng däk, tak'ëp mä tabahawag däk. Dooh m' badäk hahỹỹ bä hajaa pé saroor ti hadoo pé tak'ëp hawak péh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ti m' p'ooj ub habong do paa Eriij, Mosees häd enäh do rakas'ee b'ëëh sa matym gó. Jesus sii m' raber'oot. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ti m' Peed ky hadoo Jesus hã: —Ma matëg! —näng mäh. —Taw'ããts hẽ babä ër hã! —näng mäh. —Taw'ããts hẽ tamawoob hẽ ta tób n'aa ãã temaa toonh. Sét hẽ a tób, sét hẽ Mosees tób, sét hẽ Eriij tób —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Dooh m' tadoo wät pé tak'ëp rabeỹỹm bong do hyb n'aa m', tii d' tawén edoo.) ");
INSERT INTO mbjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ti m' nayyw mä wë puh ganyyh, sahõnh hẽ sa hã m' tabadäng. Wë puh gó m' P'op Hagä Do ber'oot. Hahỹỹ d' mä ta kyyh: —Hahỹ tah ỹỹ, tak'ëp ỹ kamahǟn doo. Bë maa newë, bë ky dahé ta kyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ti m', nayyw hẽ m', raty kaw'õõd bong bä m', rabaheg'ããs bä m', jããm hẽ Jesus rahapäh. Dooh boo m' Jesus pa hab'ëëh do paah. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ti m' rabahyk bä m' Jesus mejũũ ranaher'oot hyb n'aa rahapäh doo, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ganä wät bä kä dejëp do mahang. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ti m' sa h'yyb gó m' rabenäm. Sa mab hẽ m' rakaner'ood bong. Hahỹỹ da m' sa kyyh: —H'ëëd ky n'aa tii, dajëp do ganä wät do taher'oot doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ti m' rabeaanh ta hã: —Hëd n'aa Kristo kajaa do pooj jé Eriij m' matëëh, Mosees ky n'aa jaw'yyk do ma mehetëk do raher'oot? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ti m' Jesus ky hadoo: —Se hub né hẽ. Eriij matëëh né da sahõnh hẽ tabenäm hyb n'aa —näng mäh. —Ti hadoo né hẽ, bë ỹ maher'oot hahỹỹh: Eriij ewäd hyng né hẽ. Tii bä rah'yy kajäk doo da né hẽ rabad'oo paa ta hã. Tii d' né hẽ takerii däk ta ky n'aa P'op Hagä Do kyy kerih do hã —näng mäh. Ti m' taky hadoo ẽnh: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ky n'aa ẽnh? Nyy da këh ỹ n'aa kerih do P'op Hagä Do kyyh? Ỹ na-ããj da hajõng ỹ ahoop da. Ỹ rahyb n'aa wareem da na-ããj hẽ —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ti m' Jesus rakajaa bä kä m' ta ma matëg wób rabab'ëëh bä, hajõk mä ranu sabug däk sa pa rabahapäh. Mosees ky n'aa jaw'yyk do ma mehetëk do ky ked'aak mä sa daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tii bä m', nanäng nu sabuk do rabahapäh bä m' Jesus, raty ge-ee bong. Ti m' rawaj'aa nä ta wë rabedëng hyb n'aa m' Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ti m' Jesus ky hadoo ta ma matëg wób sa hã: —H'ëëd p'ãã ti bë ky ked'aak sa wë? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tii bä m' hajõk do see ky ganyyh. Ti m' taky hadoo: —Ma matëg! —näng mäh. —Ỹ manaa a wë paawä tah ỹỹ. Karap'aar h'yyb nesaa do ta hã adäk —näng mäh. —Dooh ter'ood wäd tan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta hã tabadäng bä, tũũ tadewëës. Ti tah ỹ gadów däk, tëg kamatsëë däk, tsanamäts däk tan'oo bä —näng mäh. —Ỹ eaaj wät a ma matëg sa hã rabahabëë hõm hyb n'aa. Dooh rahaja bä —näng mä ta kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ti m' Jesus ky hadoo: —Baad P'op Hagä Do hã h'yy kana'eeh do bëëh, da hẽ badäk hahỹỹ bä habok doo! —näng mäh. —Hajõõ nuu me ỹ bawät nä g'eeh bë mahang bë ky dahé däk hyb n'aa kä? Ỹ hãd h'yyb napan däg bë hã, hã ỹ bë h'yy kanasadä nä do hyb n'aa —näng mäh. —Bë mana b'ëëp pahëëw —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ti m' pahëëw ramanaa ta wë. Ti m' karap'aar h'yyb nesaa do bahapäh bä m' Jesus, pahëëw tabahehats wät. Ti m' tadawäts jat tũũ. Tũũ m' takawereem, kawereem, kawereem jat mäh. Tsanamäts jat mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ti m' Jesus beaanh ta yb hã: —H'ëëd pénh tabadäk ta hã? —näng mäh. —P'ooj ub takarapee noo gó tadäg né hẽ ta hã —näng mä ta yb kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hajõõ nuu me karap'aar h'yyb nesaa do dahew'ëës tũũ tëëg hõõ me, tame na-ããj hẽ. Takarẽn tadaj'ëëp. Mahaja bä, mado hõm. Mat'yyd mehĩĩn ããh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Ỹ haja bä? —näng mä Jesus kyyh. —Dooh hejoonh pé P'op Hagä Do hã h'yy ka'eeh pé hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ti m' nayyw hẽ pahëëw yb ky hadoo: —Ỹ h'yy ka'eeh né hẽ —näng mäh. —Man'oo tak'ëp ỹ h'yy ka'eeh hyb n'aa, ỹ ky nasëm hyb n'aa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ti m' hajõk waj'aa padëëk sa wë rabaheg'ããs hyb n'aa Jesus hapäh bä m', nayyw hẽ m', hajõk do kaj'aa do rabaheg'ããs do pooj jé, karap'aar h'yyb nesaa do tageǟm wät tabanyyh hyb n'aa. Ti m' taky hadoo ta hã: —Karap'aar h'yyb nesaa doo, ky tamah doo, nabuuj gatamah doo, anä pahëëw hã hadäk doo! Dooh da ta hã madëë wäd bä! —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ti m' tak'ëp mä karap'aar h'yyb nesaa do geëëj wät. Ti m' tak'ëp tabahehats wät, ti m' tabanä kän pahëëw hã hadäk do paah. Ta wób sa hã m' pahëëw dajëp. Bag hẽnh mä tabajad hõm, ti hyb n'aa m' dajëp rawén ed'oo. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ti m' Jesus moo takyg sëëk. P'op mä tabag'ëëd däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ti m' Jesus tób gó tabajëë suun jawén paa bä, sa m'aa hẽnh mä ta ma matëg rabeaanh ta hã: —H'ëëd hyb n'aa ãã wén nahajaa ãã habëë hõm bä karap'aar h'yyb nesaa doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ti m' Jesus ky hadoo sa hã: —Jããm hẽ P'op Hagä Do ji ky n'aa etsẽẽ doo me, ji noo kanawa doo me na-ããj hẽ ta ti hadoo pé karap'aar h'yyb nesaa do tabanyyh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ti m' ratsyym kasok ta tii b' naa. Garirej häj n'aa me m' ratabës. Dooh m' Jesus karẽn bä ta wób raky n'aa napëë bä rabaym doo, ");
INSERT INTO mbjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta ma matëg tama metëëk do hyb n'aa m'. Ti m' taky hadoo sa hã: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da ran'oo däk da ta wób sa moo gó. Ỹ radaj'ëëp da. Tamawoob hẽ ta ǟ jawén paa bä ỹ ganä wät da p'aa hẽnh —näng mä Jesus ta ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dooh m' rah'yy genä bä ti taher'oot do sa hã. H'yyb e'ỹỹm mä rawén neaanh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ti m' rakajaa Kapar-Naũm häd näng panang bä. Tób bä tabajëë suun bä m' teaanh mä ta ma matëg sa hã. Ti m' taky hadoo: —H'ëëd p'ãã ti bë ky ked'aak ta tyw n'aa me, ër mana me? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dooh m' raky gado bä. Raky n'aa meb'yyh mäh. Tyyw me rababoo däk bä raky kedag bong ny hadoo do sa mahang hyb n'aa jawyk ta wób sa bahǟnh. Ti hyb n'aa m' rawén ky n'aa meb'yyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ti m' Jesus bahyy sooh, ti m' ta ma matëg tanaëënh ta wë. Ti m' taky hadoo sa hã: —Jé karẽn pé ta wób sa bahǟnh hadoo doo, taw'ããts hẽ da sa yd jé tanu gadäk. Taw'ããts hẽ sahõnh hẽ sa karom hadoo tabahadoo —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ti m' karapee t'aah ta moo takyg gëët sa mahang, ti m' tabado däk, ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Hëp ỹ n'aa hahỹ karapee t'aah hadoo pé gadoo péh, ỹ né ti tagadoo —näng mäh. —Ỹ gadoo péh, ỹ had'yyt nado tagadoo, hã ỹ mejũũ do ti na-ããj né hẽ tagadoo —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ti m' Jowãw ky hadoo: —Ma matëg! —näng mäh. —Ãã hapäh aj'yy a häd tabesok bä tahebë karap'aar h'yyb nesaa doo. Ër h'yyb hata nado tii, ti hyb n'aa ãã ge'ỹỹm tii d' tanad'oo hyb n'aa —näng mä Jowãw kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti m' Jesus ky hadoo sa hã: —Bë geǟm manäh! —näng mäh. —Dooh hät ỹỹ gó pahuunh pé ta jawén ỹ tanu mer'oot tii bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","—Ti hyb n'aa, ër wë h'yy kawanereem doo, ër h'yyb hata tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ti m' taky hadoo ẽnh: —Jé naëng han'oos pé hät ỹỹ gó bë hã, hata ỹỹ bë bahadoo do hyb n'aa, ta ti gadoo né da ta säm baad hadoo do P'op Hagä Do hanaa. Né hup ỹ né hẽ ti ỹ her'oot doo —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ti m' Jesus ky hadoo ẽnh: —Baad nado né paawä pä ta jawyyg n'aa ji hã ranu hũũ däg bä ji radawäts tu tame t'õp ji pahǟs hyb n'aa, ti bahǟnh tak'ëp baad nado ji hã da, ky n'aa netsëëh do seeh, hahỹ karapee hedoo doo, hã ỹ h'yy ka'eeh do ji h'yyb tatug bä nesaa do tamoo wät hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ti m' taky hadoo ẽnh: —A moo hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä magakyd hõm a mooh. Taw'ããts hẽ mabasëëk hỹ pong jé P'op Hagä Do wë sét a mooh, mahõm mahǟnh ta s'ee hẽnh, tabanesaa hẽnh, pawóp hẽ tado bä a mooh. T'ĩĩ hẽnh mahõm bä, tëëg hõõ nadëëk do mahoop da had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","T'ĩĩ hẽnh madoh-ro ji hawëh doo, dooh radejëb bä. T'ĩĩ hẽnh tëëg hõõ dooh tadäg bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","—A tsyym hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä magakyd hõm. Taw'ããts hẽ matsyym gahet mabasëëk hỹ pong jé P'op Hagä Do wë, ta s'ee hẽnh, tabanesaa hẽnh, õm P'op Hagä Do aw'oong hõm mahǟnh, pawóp hẽ tado bä a tsyym. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","T'ĩĩ hẽnh madoh-ro ji hawëh doo, dooh radejëb bä. T'ĩĩ hẽnh tëëg hõõ dooh tadäg bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—A matym hyb n'aa nesaa do mamoo wäd bä, taw'ããts hẽ paawä a matym mado nyyh. Taw'ããts hẽ mabasëëk hỹ pong jé, P'op Hagä Do ji tabag'ããs doo hẽnh, sét a matym, jé ta s'ee hẽnh, tabanesaa hẽnh, õm P'op Hagä Do aw'oong hõm mahǟnh pawóp hẽ tado bä a matym. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“T'ĩĩ hẽnh madoh-ro ji hawëh doo, dooh radejëb bä. T'ĩĩ hẽnh tëëg hõõ dooh tadäg bä” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ti m' taky hadoo ẽnh: Sahõnh hẽ ma matëk ỹỹ P'op Hagä Do metyy da ji ahoop do hã, sa h'yyb tym banyyw däk hyb n'aa ta hã, ta dab P'op Hagä Do hã ji ma ejuu do jukiir me ji enyyw däk doo da. ");
INSERT INTO mbjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ti m' taky hadoo ẽnh: —Taw'ããts hẽ ti jukiir. Ti hadoo né hẽ, tanadah'ëëd wäd bä, taw'ããts hẽ nado wäd. Ti hadoo né da bë hã. Taw'ããts hẽ baad had'yyt hẽ bë babok bë da hadoo do wë. Baad bë babok do bë da hadoo do wë gawatsiig bä, taw'ããts hẽ nado wäd —näng mäh. —Taw'ããts hẽ h'yyb nyyw gó bë baboo had'yyt hẽ bë da hadoo do wë —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ti m' Jesus raberéd däk Kapar-Naũm, atsëg hõm mä tamii Joradãn häd näng doo. Tamyyj däk hã m', ta tyw n'aa me m' ramahyk Judah häj n'aa hẽnh. Ti m' p'aa hẽnh hajõk mä ta wë han'aa. Ti m', tabahed'oo doo d' né hẽ m' tama metëëk mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ti m' Pariséw wób rabana ta wë rametyy hyb n'aa m'. Hahỹỹ da m' rake'aanh: —Ër ky n'aa jaw'yyk do anoo g'eeh aj'yy eréd hõm bä ta ỹỹm? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ti m' Jesus ky hadoo: —Nyy da Mosees ky n'aa jaw'yyk do her'ood bä ẽnh? —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ti m' raky hadoo: —Mosees anoo ji erii däk ji ỹỹm ji eréd hõm do heen n'aa, tii b' ji mejõ hõm tabahõm hyb n'aa —näk mä Pariséw sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ti m' Jesus ky hadoo: —Bë nabuj keh'ũũm do hyb n'aa tii d' Mosees wén erii wät ta ti ky n'aa jawyk do ky n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","—P'ooj ub dooh ta tii da tahado bä. Sahõnh hẽ tadu dahäng noo gó P'op Hagä Do pahuunh aj'yy ỹỹnh daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Ti hyb n'aa kä, aj'yy kä, ta yb, ta ỹỹn mahǟnh kä, sa m'aa hẽnh kä, tagatëë hyb n'aa ta ỹỹm kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Takatëë jawén paa bä sét rabahado padëëk ta ỹỹm daheeh”, näng mäh. Ti hyb n'aa pawóp hẽ ranado bong. Sét hado däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ti hyb n'aa séd hã P'op Hagä Do ata däk doo, dooh tahaja bä ji etyn bä —näng mä Jesus kyyh Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tób bä kä m' ta ma matëg rabeaanh ta ti ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ti m' Jesus ky hadoo sa hã: —Jé ta ỹỹm heréd hõm doo, tii bä ỹỹnh see hã takat'ëë däg bä, nesaa doo, P'op Hagä Do ganadoo do tamoo wät. Ta see ỹỹm sii he'ỹỹh do hado däk tii. Ta ỹỹm paa tah'yyb rejãã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","—Jé ta patug heréd hõm do ta see tagat'ëë däg bä, nesaa doo, P'op Hagä Do ganadoo do tamoo wät. Ta see patug sii he'ỹỹh do hado däk tii —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ti m' ta wób ramenaa karepé ned'ëëd is do Jesus wë, sa hã Jesus moo däng hyb n'aa, taky n'aa edëng hyb n'aa. Ti m' ta ma matëg rage'ỹỹm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ti m' dooh Jesus genaag bä ta ma matëg rabad'oo doo. Ti m' taky hadoo sa hã: —Na ramena karepé wë ỹỹ. Bë geǟm manäh! Hahỹ karepé h'yy ka'eeh do hadoo, ti né hẽ P'op Hagä Do bag'ããs do karapee hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ti m' taky hadoo ẽnh: —Karapee t'aah ky daheeh do hadoo ky nadaheeh péh, dooh P'op Hagä Do bag'ããs do karapee tado bä da. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ti m' karepé tabasog däk ta hã, tii bä m' sa nu gad'oo bä m' tamoo däng, taky n'aa edëë boo kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ti m' ta tii b' naa Jesus tsyym kadoo bä m', ana mä aj'yy ta wë. Ta taron nuu me m' tabahyy häng ta wë. Ti m' taky hadoo: —Baad õm, ma matëg! —näng mäh. —Nyy da ỹ bad'oo edëb had'yyt do ỹ gadoo hyb n'aa, P'op Hagä Do pa ỹ bawät hyb n'aa kä? —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti m' Jesus ky hadoo ta hã: —Hëd n'aa baad ub hã ỹ mabanäng? —näng mäh. —Jããm hẽ P'op Hagä Doo, baad hadoo doo. Dooh ta see pé baad hadoo péh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mahapäh hahỹ P'op Hagä Do ky n'aa jaw'yyk doo: “Manaboh manä a da hadoo doo. Aǟ manä a ỹỹm nadoo do sii, a patug nadoo do sii. Etsëëg manäh. Daap hẽ maky n'aa tapa manä ta wób. Mawad'ii manäh. Mawehëë a yb, mawehëë a ỹỹn” —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Ma matëg! —näng mä aj'yy kyyh. —P'ooj ub, ỹ karapee noo gó ỹ panyyg kadeheeh né hẽ ta tii hã —näng mä ta kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ti m' Jesus ty däng ta wë, takamahǟn wät mäh. Ti m' taky hadoo ta hã: —Sét hẽ ti hawät a hã —näng mäh. —Abaaj hõm, mesëëm hõm sahõnh hẽ a wë hanäng doo. Man'oo ta säm paa kas'uut do sa hã. Tii d' madoo bä hỹ pong jé magadoo da tak'ëp baad hadoo do P'op Hagä Do hanaa. Ti jawén ana wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa kä —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ti m' aj'yy h'yy katón gëët. Ti m' ahõm mä Jesus mahǟnh. H'yy katón wät mäh, tak'ëp tawekãp do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ti m' Jesus ty däg ta ma matëg sa wë, ti m' taky hadoo: —Hejoonh né hẽ wekãp do sa hã P'op Hagä Do bag'ããs do karapee n'aa rabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ti m' sa h'yyb gó ta ma matëg rameuunh mä Jesus her'oot do hyb n'aa. Ti m' p'aa hẽnh Jesus ky hadoo sa hã: —Tah haa —näng mäh. —Hejoonh né hẽ ji hã P'op Hagä Do bag'ããs do karapee ji bahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","—Hejooj né paawä kameer hã tatabëëj bä gats'uus doo gó, ta bahǟnh tabahejoonh wekãp do sa hã P'op Hagä Do bag'ããs do karapee n'aa rabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ti m' ti bahǟnh mä ta ma matëg rameuuj bong mäh. Sa mab hẽ m' rakaner'oot. Hahỹỹ da m' sa kyyh: —Jaa ẽnh ti P'op Hagä Do wë hasëëk ẽnh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ti m' Jesus ty gadäg däk sa wë, ti m' taky hadoo: —Ji daaj hẽ dooh né hẽ ji haja bä P'op Hagä Do wë ji as'ëëg bä. Ti hadoo né hẽ, dooh P'op Hagä Do nahajaa péh. Ti hajaa ta wë ji tamasäk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ti m' Peed ky hadoo: —Sahõnh hẽ ãã beréd hõm a hataa ãã bahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ti m' Jesus ky hadoo sa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Hëp ỹ n'aa, P'op Hagä Do panyyg hanäm do hyb n'aa na-ããj hẽ heréd hõm pé ta tób, heréd hõm do ta wakããn, ta ǟnh, ta yb, ta ỹỹn, ta taah, ta joom banäng doo, ");
INSERT INTO mbjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ta bahǟnh hajõng tagadoo da badäk hahỹỹ bä ta mabaj. Tagadoo da tób, ta wakããn, ta ǟnh, ta ỹỹn, ta taah, ta joom banäng doo. Ta no n'aa na-ããj da tagadoo. Ta jawén kä, hỹ pong jé kä, tagadoo da edëb had'yyt doo. P'op Hagä Do pa tabawäd had'yyt da. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hajõk babä hyb n'aa jewyk do wób, ta jawén kä hyb n'aa sekog padäg its da hỹ pong jé. Babä hyb n'aa sekog is do wób kä ti noo gó kä hyb n'aa jewyg kän da —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ti m' Jesus rabahõm Jerusarẽnh hẽnh. Jesus mä sa pooh. Ti m' ta ma matëg rahyb n'aa newëë mä t'ĩĩ hẽnh Jesus bahõm doo. Ta wób mä sa sii hah'ũũm do e'ỹỹm mäh. Ti m' sa m'aa hẽnh Jesus naëënh ẽnh 12 hedoo do ta ma matëg. Ti m' tamaher'oot sa hã ta mo n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ti m' taky hadoo: —Ër ah'ũũm Jerusarẽnh hẽnh —näng mäh. —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da rahaëëj däk da P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa sa moo gó, Mosees ky n'aa jaw'yyk do ma mehetëk do sa moo gó na-ããj da. Dajëb hã raky n'aa etyy da ỹỹh. Ỹ da rahaëëj däk Judah buuj nadoo do sa moo gó —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","—Ta ti ỹ da raky n'aa ej'ees, ỹ da rahetsoos. Ỹ da rahewyyh. Ỹ da radajëëb kän —näng mäh. —Tamawoob hẽ ǟh ỹ jawén paa bä, ỹ d' ganä wäd kän —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ti m' Sebedew taah hedoo doo, Tsijaag, Jowãw daheeh, rabana Jesus wë. Ti m' raky hadoo ta hã: —Ãã karẽn paawä manoo ãã etsẽẽ do a hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ti m' Jesus ky hadoo sa hã: —H'ëëd ti bë karẽn hã ỹỹ? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ti m' raky hadoo: —Ãã karẽn paawä tak'ëp makabaj'aa doo me mabag'ããs doo bä, a hub hadäk hẽnh ãã see basooh man'oo bä, s'ỹỹ me ãã see —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti m' Jesus ky hadoo sa hã: —Dooh bë hapëë bä ti bë etsẽẽ doo —näng mäh. —Bë hajaa da ỹ ahoop do bë ahob bä? Bë hajaa da bë dajëb bä ỹ dajëp doo da? —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ãã hajaa! —näk mäh. Ti m' Jesus ky hadoo: —Bë ahoop né da ỹ ahoop do hadoo doo. Ỹ dajëp do hadoo né da bë dejëp —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","—Hỹỹ kä, ta ti bë etsẽẽ do hã ỹỹ, ỹ nado ti hanoo. P'op Hagä Do anoo da hup ỹỹ hẽnh, sǟ ỹỹ hẽnh rabat'oonh, ta pooj jé tabenäm do tah'yyb däng do sa hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ti m' ta ma matëg wób, ji moo sahõnh hẽ hadoo do raky n'aa napäh bä retsẽẽ doo, rah'yy kawaj'ããn bong Tsijaag Jowãw sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ti m' Jesus naëëj nä ta wë sahõnh hẽ ta ma matëg. Ti m' taky hadoo sa hã: —Bë hapäh né hẽ, ta ti Judah buuj nadoo do sa wahë n'aa ky n'aa hedoo doo, tak'ëp ramejũũ sa hã. Bë hapäh né hẽ ti hyb n'aa jew'yyk doo, tak'ëp ramejũũ sa karapee n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","—Bë mahang taw'ããts hẽ dooh tii d' tado bä. Bë mahang karẽn pé kaweh'ëëh péh, taw'ããts hẽ da ta wób sa karom hadoo tabahado däk, ta wób tamasa. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bë mahang karẽn pé ta wób sa bahǟnh nu gadäk péh, taw'ããts hẽ takadad'uuh sahõnh hẽ sa wë. Taw'ããts hẽ sahõnh hẽ sa masa n'aa, sa karom kanep'aak do hado däk tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","—Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ na-ããj né hẽ. Ỹ ahyng babä ỹ rahyb n'aa jew'yyk do jawén nado. Ỹ ahyng babä ỹ masa hyb n'aa ta wób, ỹ ky n'aa en'yym hyb n'aa ta wób sa hã, ỹ dajëp hyb n'aa hajõk do nesaa do sa mo haj'aa säm hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ti m' rakajaa panang Jerikó häd näng doo bä. Ti m', ta jawén, panang bä naa Jesus, ta ma matëg, hajõk do wób ratsyym kasok bä, ta tyw n'aa nabyy me m' tabahäng ty tamah doo. Baritsiméw mä ta häd. Tsiméw häd näng do t'aa m' tii. Ta tyw n'aa me tabahäng dajẽẽr tetsẽẽ hyb n'aa m' ta tii me tebës do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti m', Jesus, Nasaréh buuj ramaneëënh do né hẽ ti ta tii bä tabës taky n'aa napäh bä m', tak'ëp mä tageëëj wät. Hahỹỹ da m' ta kyyh: —Mat'yyd mehĩĩn ỹỹh, Jesus, Dawi panaa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ti m' ta wób raky ge'ỹỹm mäh, bag hẽnh tabahäng hyb n'aa. Raky geǟm né paawä m', tak'ëp tageëëj wät tii bä: —Mat'yyd mehĩĩn ỹỹh, Dawi panaa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ti m' Jesus baym. —Bë naëëj! —näng mäh. Ti m' raky hadoo Baritsiméw hã: —Tsebee wäd! P'op as'ëëg g'ëëd! Õm tanaëënh! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ti m' ta hatsë taw'oong jat mäh, gatsëg gëët, ahõm mä Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ti m' Jesus beaanh ta hã: —H'ëëd ti makarẽn ỹ moo wät a hã? —näng mäh. —Ma matëg! Ỹ karẽn ỹ begãã däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ti m' Jesus ky hadoo ta hã: —Ahõm nä. Hã ỹ mah'yy ka'eeh do hyb n'aa õm has'oo däk —näng mäh. Ti m' nayyw hẽ m' tabahapëë däk. Ti m' tabahõm Jesus sa jawén. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ti m' Jesus rabahõm. Ti m' Jerusarẽnh bedaa däk bä m', panang Betapagéh, Betanija häd enäh do w'oo hã rakajaa bä, waëë joom oriib häd näng do banäng bä, pawóp hẽ ta ma matëg Jesus mejũũ sa pooj jé m' rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Hahỹỹ d' mä ta kyyh sa hã: —Bë ahõm panang hẽnh bë pooj jé badäk doo hẽnh ti nuuj jé. Bë kajaa bä, bë hapäh da jumeto t'aah ji najasooh nä doo. Ta tyd hã da tabahäng —näng mäh. —Bë asood hõm da, bë manaa wawẽẽ hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—“Hëd n'aa ti bë as'oot?”, ranoo bä, “Tak'ëp Hyb N'aa Jawyk Do karẽn, bada m' tamejũũ rababaj nä”, näk da bë kyyh —näng mä Jesus pawóp hadoo do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ti m' rabahõm, ti m' jumeto t'aah rabawyyd kän tób w'oo hã. Tób noo hã m' takahõ. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ti m' rabas'oot bä m', p'eets hẽ hab'ëëh do rabeaanh: —H'ëëd ti bë hab'ëëh? Hëd n'aa ti bë as'oot? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ti m' Jesus ma matëg raky hadoo Jesus bedoo doo d' né hẽ m'. Ti m' rabanoo ramahũũm. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ti m' Jesus ma matëg ramana kän Jesus wë. Ti m' sa hatsë sa hã padëëk do paa radatoonh jumeto jó. Ti m' Jesus bas'ëëg sooh ta jó. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hajõk mä sa hatsë sa hã padëëk do paa rat'ëëg hõm ta tyw n'aa me, tamahõm doo me, raweh'ëëh hyb n'aa. Ta wób mä ragekyyt mä bag'aad, rat'ëëg hõm mä ta tyw n'aa me. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ti m' sahõnh hẽ pooj jé hah'ũũm doo, duu hẽnh han'aa do na-ããj mä tak'ëp mä sa kyyh: —P'op Hagä Do ãã j'aa etsë! —näk mäh. —Ky n'aa kedëng tii, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—P'op Hagä Do ky n'aa edëng da ër wahë makũ Dawi bag'ããs do paa hadoo bag'ããs doo —näk mäh. —Hỹ pong jé hawät do hã ãã j'aa etsë! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ti m' Jerusarẽnh bä Jesus bajëë suun kän. Ti m' tabahõm P'op Hagä Do tób n'aa hẽnh. Tabegãã däk mäh. Tug bä däg do hyb n'aa m', 12 hedoo do sa sii hẽ m' tabahõm ta s'ee hẽnh, Betanija häd näng doo hẽnh, raba'ỹỹh hyb n'aa m' tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti m' jati péh, Betanija bä naa ratsyym kasok bä, Jesus asa däk. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dawëë naa m' tabahapäh joom wiigo häd näng doo. Taheg'ããs mä teag bä. Dooh m' ta hã, ta ag noo gó nado m' ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ti m' joom hã taky hadoo: —Dooh da meag wäd bä! Dooh d' a ag repoo wäd bä! —näng mäh. Ta ma matëg ramaa napäh mä ta kyyh joom hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ti m' rakajaa bä kä m' p'aa hẽnh Jerusarẽnh bä, Jesus bajëë suun mä P'op Hagä Do tób n'aa w'oo hã, kahadë doo gó, wahoo gó. Ti m' Jesus bahabëë bong tii bä hes'ëëm doo, hets'ẽẽ do na-ããj mäh. Ti m' tabaũũj bëëh dajẽẽr rabaheb'aanh do tyng n'aa. Gurii-i hes'ëëm do tyng n'aa na-ããj mä taũũj bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dooh m' tan'oo bä ramatabëj bä wak'ããb ta tii me, P'op Hagä Do tób n'aa wahoo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sa hã tama metëëk bä m' taky hadoo: —Nepäh bë hã kerih do P'op Hagä Do kyyh? —näng mäh. —Hahỹỹ da takerih P'op Hagä Do kyyh: “Tóp ỹỹ ji maneëënh da sahõnh hẽ badäk hahỹỹ bä habong do P'op Hagä Do hã raky n'aa etsẽẽ do tób n'aa” —näng mä Jesus. —Hỹỹ kä, baretsëg tób n'aa hado däk bë an'oo bä! —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj mä raky n'aa napëë kän mä ta tii. Ti m' ratyw n'aa esoos mä radaj'ëëp hyb n'aa m' Jesus, Jesus rajeỹỹm do hyb n'aa m'. Rawén jeỹỹm mäh, hajõk mä gen'aak Jesus metëëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ti m' tug bä kä m' Jerusarẽnh Jesus raberéd däg kän, ah'ũũm kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jati pé bäp paa m', Jerusarẽnh hẽnh rabahõm bä m', joom wiigo häd näng doo me m' ratabës. Tsawyy häng mä sahõnh hẽ m' rabahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ti m' Peed hyb n'aa newë däk mä Jesus ky hadoo do paa joom hã. Ti m' taky hadoo: —Ma matëg! Mahegãã! —näng mäh. —Tsawyy häng joom mawas'ee häng doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ti m' Jesus ky hadoo: —Taw'ããts hẽ P'op Hagä Do hã bë h'yy ka'eeh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Hahỹ waëë hã ky hadoo péh: “Ahõm, ahob tame”, hanäng péh, P'op Hagä anoo ti ta hã, ta hã baad tah'yy kae bä, P'op Hagä Do ky däng do taky nasëëw bä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ti hyb n'aa bë ỹ maher'oot hahỹỹ da: Bë gadoo né da sahõnh hẽ P'op Hagä Do hã bë ky n'aa etsẽẽ doo, baad bë ky dahé bä, bë ky nasëëw bä bë hã tanoo do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","—Bë ky n'aa ets'ẽẽ bä, tanyy bä bë h'yyb gó baad nadoo do bë da hadoo do wë, taw'ããts hẽ pooj jé bë hyb n'aa mabaan hõm tii, bë Yb hỹ pong jé hawät do hyb n'aa mabaan hyb n'aa nesaa do bë hã na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bë hyb n'aa manabaan hõm bä, dooh na-ããj hẽ bë Yb hỹ pong jé hawät do hyb n'aa mabaan bä nesaa do bë moo bok do paah —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ti m' rakajaa Jerusarẽnh hẽnh. Jesus bawät bä m' P'op Hagä Do tób n'aa wahoo gó, kahadë doo gó, kajaa mä ta wë P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, Judah buuj sa wahë n'aa hedoo do sii hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti m' raky hadoo ta hã: —Jaa kyy gó mabad'oo hahỹ mabad'oo doo? Jaa ky gabuuj gó hahỹ mamoo wät doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ti m' Jesus ky hadoo sa hã: —Ỹ eaanh bë hã ẽnh. Bë her'ood bä, tii bä ỹ baher'oot bë hã jaa ky gabuuj hahỹ ỹ moo wät doo, hahỹ ỹ bad'oo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Jaa ky gabuuj Jowãw nu gahem'uun do nu gemuun paah? Hỹ pong jé hawät do kyy gó, sa ky gabuuj hẽ paah? Bë her'ood hã ỹỹ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tii bä m' sa m'aa hẽnh mä raky n'aa hajẽẽw bong. Hahỹỹ d' mä sa kyyh: —Hỹ pong jé hawät do kyy gó ër noo bä, teaanh da ër hã tii bä: “Hëd n'aa paa ti bë ky nadaheeh ẽnh?”, näng da. ");
INSERT INTO mbjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ajyy kyy gó ër noo bä, hajõk do kawaj'ããn da ër wë —näk mä sa kyyh sa m'aa hẽnh raky n'aa hajẽm bä. (Rawén jeỹỹm mäh, hajõk do hã m' P'op Hagä Do ky n'aa rod né hẽ paa m' sa h'yyb Jowãw.) ");
INSERT INTO mbjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ti hyb n'aa m' raky hadoo Jesus hã: —Dooh ãã hapëë bä —ken'ooh mäh. Ti m' Jesus ky hadoo sa hã: —Ỹ na-ããj né hẽ, dooh ỹ her'ood bä ky gabuuj näng do hã ỹỹ, tii da ỹ bad'oo doo —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ti m' Jesus baher'oot panyyg ky n'aa me sa hã. Hahỹỹ da m' tabaher'oot: —Hỹ hadoo aj'yy bejoom hõm uwa häd näng do ta joom. Tahedëë hõm. Ti tagagoos uwa bëëh hood tagatsi hyb n'aa. Ti tamoo wäd sooh p'op nu däk do joom hagã n'aa tyng. Ti tabahaëëj däk ta joom banäng do ta kaser n'aa sa hã. Ti ta danäh bahõm dawëë. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Joom ag wah'ëë däg bä kä, ta danäh mejũũ ta sii moo heb'ooh do see ta kaser n'aa sa wë, tagadoo hyb n'aa paawä joom ag wób. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ti takajaa bä kä, ramaso däk, rahewyyh, ramejõ hõm p'aa hẽnh bag hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tii bä ta danäh mejũũ ẽnh ta seeh. Tii kä ranu ganabooh, rarahejãã tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ti tamejũũ ẽnh ta seeh. Radajëëb kän tii. Ti ta danäh mejũũ nä hajõk. Tii b' sa wób rahewyh bong, sa wób raneboh bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sét hẽ mad'aak ta pa. Ta t'aah takamahǟn do tii. Ti tamejũũ. Ta h'yyb gó m' taky hadoo: “Tah ỹ raweh'ëëh da”, näng mä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ti ta kaser n'aa rabahapäh bä raky hadoo: “Ta danäh t'aah hahỹỹh. Ti d' ta danä däg ta yb jawén buuj däg”, näk mäh. “Ti bä, ër dajëëb! Ër ma däg da tii bä kä hahỹ joom banäng doo”, näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tii d' né kä, ranaboh jad kän. Dawëë radawäts hõm joom bahǟnh —näng mä Jesus. Panyyg gó m' tabeh'ũũm sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ti m' teaanh sa hã: —Nyy da joom danäh bad'oo hỹỹ kä? —näng mäh. —Ana da, tadej'ëëp da ta kaser n'aa, ta wób hã da tabahaëënh tii bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ti m' Jesus ky hadoo ẽnh sa hã: —Dooh bë ner'ood bä g'eeh hahỹ P'op Hagä Do kyy kerih doo? “Pä tób n'aa tehem'aa do raty n'aa ges'yyk doo, hỹỹ kä pä ta ba n'aa, mesoo n'aa däg. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tak'ëp Hyb N'aa Jawyk Do mo haj'aa né tii. Taw'ããts hẽ ër hã tii”, näng kerih doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tii bä kä m', P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ, Judah buuj sa wahë n'aa hedoo do na-ããj mäh, ratyw n'aa esoos mä ramaso däk hyb n'aa m' Jesus. H'yy genäh mä Jesus pes'ããp mä panyyg ky n'aa me sa hã. Ti hadoo né hẽ, e'ỹỹm mä hajõk do Jesus maa new'ëë do sa hã, ti hyb n'aa m' Jesus mahǟnh rabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta jawén kä m' ramejũũ Pariséw wób, Judah buuj sa wahë n'aa Eróts häd näng do karapee wób na-ããj mä Jesus wë. Rakarẽn paawä rano n'aa masoo taher'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ti hyb n'aa m' ky ken'yym doo gó rake'aanh: —Ma matëg! —näk mäh. —Ãã hapäh õm. Baad ub mabawät. Dooh daap mamenä bä. Dooh mahyb n'aa p'eed bä ky n'aa etsëëh do hã, hyb n'aa jawyk do hã mama metëëk bä. Dooh maky n'aa ehỹỹd bä sa hyb n'aa ma metëëk doo. Ehub né hẽ P'op Hagä Do karẽn do hã mama metëëk doo —näk mäh. —Ti hyb n'aa —näk mäh —ãã mamaher'ood. Taw'ããts hẽ a hã, ji epaag bä Roma buuj sa wahë hã rahepak doo, Sesa hã? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","—Ji ep'aak g'eeh, dooh apäh ji epaag bä? Nyy da a hã? —näk mä sa kyyh. Jesus hapäh mä ti sa h'yyb, j'ooj madäk doo me ti raky hadoo. Ti m' taky hadoo sa hã: —Hëd n'aa tii da bë ke'aanh, këh ỹ hyb n'aa ỹ bë no n'aa maso paawä? —näng mäh. Ti m' taky hadoo sa hã: —Na moweed denaari ramaneëënh doo. Ỹ megãã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ti m' raban'oo däk ta hã. Ti m' tametëëh, ti m' tabeaanh sa hã: —Jaa heen n'aa hahỹỹh? Jaa häd hahỹ kerih do ta hã? —näng mäh. Ti m' raky hadoo: —Sesa heen n'aa, Sesa häd —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ti m' Jesus ky hadoo: —Bë an'oo Sesa hã ta no n'aa, ta heen n'aa hadäk doo. Bë an'oo P'op Hagä Do hã ta no n'aa hẽ —näng mäh. Ti m' sa h'yyb gó rameuuj b'ëëh ta kyyh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ti m' rakajaa Jesus wë Saduséw häd enäh doo, rake'aanh hyb n'aa m'. Sa hã m' dooh m' ji ganä wäd bä ji dajëb bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ti m' raky hadoo Jesus hã: —Ma matëg! —näk mäh. —P'ooj ub Mosees erii däk do paa ër hã, aj'yy dajëb bä, ta ỹỹm teréd wäd bä tanetaa nä bä, tii bä m' ta hỹỹj mä gat'ëë däk tii, ta hỹỹj makũ panaa näng hyb n'aa m' —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Panyyg gó õm ãã maher'oot —näk mäh. —Hỹ hadoo aj'yy, 6 ta hỹỹj. Tagat'ëë däk mäh. Dooh m' teta nä bä, aj'yy dajëp. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tii bä ta hỹỹj seeh, ta jawén näh, gat'ëë däk mä ta hỹỹj makũ ỹỹm paah. Ti na-ããj mä dajëp né tii d' ẽnh. Dooh m' reta nä bä tadajëp. Ti hadoo né m' ta wób ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sahõnh hẽ m' raget'ëë bok ta ti ỹỹnh. Sahõnh hẽ m' radejëp ranetaa nä bä. Tagadëëg ub kä ỹỹnh dajëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ti m' rabeaaj kän Jesus hã: —Ji genyyh bä kä ẽnh, dejëp do paa ji? —näk mäh. —Ny hadoo do ỹỹm kä ta ti ỹỹnh ti noo gó kä? Sahõnh hẽ paa m' ta ti ta pat'uuk —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ti m' Jesus ky hadoo sa hã: —Dooh bë h'yy genä bä baad hadoo do hã, P'op Hagä Do kyy kerih do bë nahapäh do hyb n'aa, P'op Hagä Do hejój bë nahapäh do hyb n'aa na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","—Dejëp do ragenyyh bä kä, dooh ji kat'ëë wäd bä. Ããs hỹ pong jé habong do kanetëë do hadoo da ji tii bä kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ti m' taky hadoo ẽnh: —Dejëp do genyyh doo kä, dooh bë ner'ood bä Mosees mo haj'aa kerih do hã, b'aa kadoo do panyyg n'aa gó, ji ganä wäd do ky n'aa? —näng mäh. —Tii gó naa P'op Hagä Do ber'oot Mosees hã. Hahỹỹ d' mä ta kyyh: “Abaraãm hagã ỹỹh, Isak hagã ỹỹh, Jakóh hagã ỹỹh”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","—Dooh, “Abaraãm makũ hagã, Isak makũ hagã, Jakóh makũ hagã”, tanoo bä. Dejëp do hagã n'aa nado P'op Hagä Doo. Hedëp do sa hagã n'aa tii —näng mäh. —Tak'ëp bë h'yy gatemah —näng mä Jesus kyyh Saduséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do see bana. Tamaa napäh mä raky kedag bong do Jesus daheeh. Ta hã m', baad mä Jesus ky gadoo sa hã rake'aanh doo. Ti hyb n'aa m' teaanh mäh: —Ny hadoo do P'op Hagä Do mejũũ do see tak'ëp ji hyb n'aa jaw'yyk tamejũũ do wób bahǟnh? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti m' Jesus ky hadoo ta hã: —Hahỹ tak'ëp ji hyb n'aa jaw'yyk: “Bë maa newë da hahỹỹh, Isaraéw buuj. Tak'ëp Hyb N'aa Jawyk doo, P'op Hagä Doo, ër hagã n'aa, sét né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Taw'ããts hẽ tak'ëp bë kamahǟn Tak'ëp Hyb N'aa Jawyk Doo, P'op Hagä Doo, bë h'yy kaha'eeh doo. Taw'ããts hẽ tak'ëp bë h'yyb padäg ta hã. Taw'ããts hẽ bë h'yyb tym gó naa né hẽ bë kamahǟn ta hã, sahõnh hẽ bë hajaa doo me”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Hahỹ ta seeh: “Makamahǟn a da hadoo doo, a hã makamahǟn doo da” —näng mäh. Ti m' Jesus ky hadoo ẽnh: —Dooh tak'ëp ky n'aa jawyk pé ta ti pawóp hadoo do bahǟnh —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do ky hadoo: —Baad ti a kyyh, ma matëg —näng mäh. —Sét né hẽ ti P'op Hagä Doo. Dooh ta see péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","—P'op Hagä Doo tak'ëp ji kamahǟn, tak'ëp ji h'yyb däk ta hã. Ji h'yyb tym gó naa né hẽ, sahõnh hẽ ji hajaa doo me né hẽ ji kamahǟn ta hã. Ji kamahǟn né hẽ ji da hadoo, ji hã ji kamahǟn doo da —näng mäh. —Ji ajuu doo, ji anoo do P'op Hagä Do hã bahǟnh ti ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ti m' Jesus h'yyb hapäh bä baad ta kyyh, ta h'yy ganäng doo me tabedoo, ti m' taky hadoo: —P'eets hẽ paawä P'op Hagä Do hã mah'yy ka'eeh takarẽn doo da. P'eets hẽ paawä P'op Hagä Do bag'ããs do karapee n'aa mabahadoo —näng mäh. Ti bahǟnh kä m' dooh m' reaaj boo bä kä. H'yyb e'ỹỹm mä reaaj bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ti m' P'op Hagä Do tób n'aa wahoo gó Jesus ma metëëk bä m' taky hadoo: —Dawi panaa m' ti Kristo, P'op Hagä Do H'yyb Däng Doo, Mosees ky n'aa jaw'yyk do ma mehetëk do sa nooh. Nyy da tii? ");
INSERT INTO mbjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hahỹỹ d' mä P'op Hagä Do Sahee hejój gó Dawi baher'oot paa m' Kristo ky n'aa: “Wahë ỹ n'aa hã Tak'ëp Hyb N'aa Jawyk Doo ky hadoo, ‘Aso hup ỹỹ hẽnh, si ỹ mabag'ããs hyb n'aa a majĩĩ ỹ nes'ëëm bä kä’”, näng paa Dawi. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hỹỹ kä, “Wahë ỹ n'aa” Dawi maneëëj bä ti Kristo, nyy d' ti ta t'aah tabahadoo? —näng mä Jesus. Baad mä hajõk do sa hã Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus ma metëëk bä m' taky hadoo: —Baad da bë kanä ta ti Mosees ky n'aa jaw'yyk do ma mehetëk do sa mahǟnh —näng mäh. Baad ub raken'yym, baad rakametëëh saroor henyym doo me, ky n'aa gebah doo me —näng mäh. —Rakarẽn ji bedëng hajõk do sa mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","—Tób P'op Hagä Do panyyg rayd naherot doo bä ragen'aak ratooj bä hyb n'aa jewyk do rabahetonh bä. Ratsebé do tä n'aa noo gó, ragen'aak ky n'aa etsëëh doo bä rabahetonh bä ratooj bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","—Patug tema bong do radajẽẽr esok, rama esok. Tii bä h'yy kamep'ëëh, bäp péj hadoo doo me raky n'aa ets'ẽẽ bä —näng mäh. —Ta ti hedoo do tak'ëp P'op Hagä Do rejãã da —näng mä Jesus kyyh Mosees ky n'aa jaw'yyk do ma mehetëk do sa ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ti m' Jesus bahyy sooh dajẽẽr radahet'oonh do dawëë bä. Ti m' tabaheg'ããs hajõk do radatoonh do dajẽẽr tób P'op Hagä Do rahyb n'aa esee do dajẽẽr n'aa. Hajõk mä dajẽẽr enäh doo, hajõng mä radatoonh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ti m' tabana patug tamaa wäd is doo, tadatooj is mä pawóp its moweed. Kanahën its mä tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ti m' Jesus naëënh ta ma matëg ta wë, ti m' taky hadoo sa hã: —Hahỹ ỹỹnh patug tamaa wäd is doo, sa bahǟnh tabanoo. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","—Sahõnh hẽ ta wób ranoo sa wë mad'aak do uuh —näng mäh. —Hahỹ ỹỹnh, kasuud its né paawä, sahõnh hẽ taban'oo däg is ta wë hanäng do paats —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ti m' Jesus ratsyym kasok bä m' P'op Hagä Do tób n'aa bä naa, ta ma matëg see ky hadoo ta hã: —Mahegãã, ma matëg! Ewëëh hỹ pä tób pan'aa. Anäm hahỹ tatama n'aa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ti m' Jesus ky hadoo: —Mahapäh hahỹ tób yb —näng mäh. —Dooh da hahỹ pä ta see jó haso wät pé da. Sahõnh hẽ da rabakud bëëh tũũ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ti m' waëë joom oriib banäng doo hẽnh Jesus rabahõm kän. P'op Hagä Do tób n'aa nu masee me tii. Ta tii bä Jesus bahäng bä, sa m'aa hẽnh Peed, Tsijaag, Jowãw, Ãn-Deréh rabana ta wë, ti m' raky n'aa eaanh: ");
INSERT INTO mbjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ny noo gó da ti tii d' maher'oot do tadu däk? H'ëëd hado da tabedaa däk do heen n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ti m' Jesus ky hadoo sa hã: —Baad bë matakä da bë rawanadii hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hajõk da han'aa ji hã wad'ii doo. Hät ỹỹ gó rabana, sa nooh. “Ỹ Kristo”, näk da sa kyyh. Hajõk da rawedii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Bë eỹỹm manä da kaneb'ooh do bë ky n'aa napäh bä. Ti awät né da ta ti hedoo doo. Ti hadoo né hẽ, dooh takaja nä bä badäk hahỹ bahëëj jëng doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","—Häj n'aa see babuuj rakaneb'ooh da häj n'aa see babuuj sa daheeh. Häj n'aa sa wahë n'aa, rah'yy kawereem da häj n'aa see sa wahë n'aa wë. Hajõng häj n'aa bä k'ããts katajuus da, sah na-ããj da anäng. Badäk hahỹ bahëëj jëng do du däk do metëë n'aa d' tii. Ajãn pooj jé ta mahỹỹj ganyyh do hadoo da tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ti m' taky hadoo ẽnh: —Baad bë kanä sa mahǟnh —näng mäh. —Bë da rahaëënh panang enäh do sa wahë n'aa sa moo gó, bë raky n'aa etyy hyb n'aa. Bë da rahewyyh tób P'op Hagä Do panyyg rayd naherot doo gó. Hëp ỹ n'aa bë da ramahũũm sa wahë n'aa wë, hëëj bagã n'aa sa wë na-ããj hẽ, sa matym gó bë raky n'aa tapaa hyb n'aa. Këh ỹ n'aa bë her'ood kän da tii bä sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","—Badäk hahỹ gawatsig pooj jé, P'op Hagä Do T'aah panyyg hanäm do jé pad'yyt hẽ da rabaher'ood hõm sahõnh hẽ häj n'aa babuuj sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Bë ramoo maso hõm bä, bë raheaaj bä bë raky n'aa etyy hyb n'aa, bë hyb n'aa tón manä bë her'oot péh. Bë her'oot bä, bë her'ood bë hã P'op Hagä Do anoo do ti noo gó. Bë h'yyb gó naa nado da ti bë her'oot doo. P'op Hagä Do Sahee da ti her'oot doo —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti m' taky hadoo ẽnh: —Hỹỹj näng do ta hỹỹj tan'oo däk da ta wób sa moo gó, radaj'ëëp hyb n'aa. Ti hadoo né da t'aah näng do bad'oo ta t'aah hã. Sa taah da h'yy kawereem da sa yb wë, sa ỹỹn wë. Rahaëënh da ta wób sa moo gó radej'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tak'ëp da sahõnh hẽ rakawajããn da bë wë hëp ỹ n'aa. Ti hadoo né da, jé h'yy kanerét do hã ỹỹ, tadajëb bä kä, edëb had'yyt hẽ da hỹ pong jé P'op Hagä Do pa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ti m' taky hadoo ẽnh: —Tak'ëp nasaa doo, P'op Hagä Do tób n'aa rejãã doo, P'op Hagä Do tób n'aa rahyb n'aa eréd hõm hanoo doo, P'op Hagä Do tób n'aa bä tahëë däg bä bë hapëë bä, taw'ããts hẽ Judah buuj häj n'aa bä haj'eenh do rakejën hõm da waëë banäng hẽnh. (Sahõnh hẽ hahỹ ner'oot doo, taw'ããts hẽ ramatakëë tagahoot hyb n'aa sa hã nyy d' Jesus hanäng pé ti tak'ëp nesaa doo.) ");
INSERT INTO mbjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta ti bë bahapäh bä, taw'ããts hẽ jajé p'op tób gadäk do jó hasooh péh, nayyw hẽ da takejën hõm, dooh da pooj jé tób gó tehëën péh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ti hadoo né da ta joom hood hẽnh hawät doo. Taw'ããts hẽ dooh da tajëë bä ta hatsë tabehëën hyb n'aa paawä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Tak'ëp tanesaa het'aah doo, sa taah nebii do sa hã kä ti noo gó kä! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Ti m' taky hadoo ẽnh: —Tak'ëp né da ji bahoop ti noo gó. Badäk hahỹ P'op Hagä Do pahuuj wät noo gó naa, dooh nä paa ti hadoo pé tak'ëp rabahoop. Ti jawén kä dooh ti tahado wäd bä kä. Ti hyb n'aa da, bë ky n'aa ets'ẽẽ P'op Hagä Do hã, bë kejën hõm do tabahahëëm noo gó, tak'ëp naëng badoos noo gó, tanahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","—P'op Hagä Do bód gakog hõm da nanäng ji ahoop doo. Tii d' tanado bä paawä, dooh paawä hedëp péh. Ta wë tasëëw hõm do sa hyb n'aa tawén bód gakog hõm ti noo gó rahoop doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Ti noo gó, “Wät hahỹ Kristo, P'op Hagä Do H'yyb Däng Doo”, “Jajé tahawät”, ranoo bä, bë ky dahé manä da raher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta ti ỹ wén her'oot, ti abok da hajõk “Ỹ Kristo” ken'ooh do hyb n'aa. Ti abok né da “P'op Hagä Do ky n'aa rod ỹỹh” ken'ooh doo, noo kanesa doo. Tak'ëp hadoo do ta heen n'aa rametëëh da, rapehuunh da, ta wë P'op Hagä Do asëëw hõm do rawedii hyb n'aa paawä. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ti hyb n'aa, bë hyb n'aa matakä! Ta pooj jé ỹ baher'ood däk bë hã —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ti m' Jesus ky hadoo ẽnh: —Ta ti rahoop do jawén paa bä, papỹỹj da badagyb däk, kamarab da dooh ta bag nyy wäd bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sagõõh wë hã naa kejäk da. Wë hã habong do ta bag keh'ỹỹt da jé pad'yyt hẽ, ta see hedo hõm da P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti noo gó kä da sahõnh hẽ da rabahapäh ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ bahyng bä kä wë puh mahang. Ỹ ahyng da tak'ëp P'op Hagä Do hejój me, ta bag tak'ëp gabarëëh do hadoo doo me. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ti noo gó ỹ mejũũ da ãs ỹỹ rabata hõm hyb n'aa jé pad'yyt hẽ badäk hahỹỹ hã habong do ỹ asëëw hõm doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ti m' Jesus ky hadoo ẽnh: —Bë hyb n'aa matakä joom wiigo häd näng do ky n'aa hã —näng mäh. —Wiigo tëëg tadu doo bä tagajewäng doo, bë hapäh tabanyyw edaa däk. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ti hadoo né da, sahõnh hẽ ta ti bë ỹ maher'ood wät do kaja däk bä bë bahapäh bä, edaa däk ỹ kajaa do bë bahapäh da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ti m' taky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Da hẽ habong do rahapäh nä da sahõnh hẽ ỹ her'ood wät do bawäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Badäk hahỹỹh, wë na-ããj da, ahëëj jëë né paawä, këh ỹỹ da dooh tahëëj bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ti m' Jesus ky hado kän: —Dooh d' hapäh pé ny noo gó ta ti bawät. Ããs, hỹ pong jé habong doo, dooh rahapëë bä. Ỹỹh, P'op Hagä Do T'aah, na-ããj hẽ dooh ỹ hapëë bä. Jããm né hẽ Ee hapäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dooh da bë hapëë bä ny noo gó ta ti bawät. Ti hyb n'aa baad ub da bë gadaa ta pooj jé, baad ub da bë matakä. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aj'yy karom näng do ta s'ee hẽnh hahõm do hadoo tii. Tabahõm pooj jé tamejũũ ta karom sahõnh hẽ rabahag'ããs hyb n'aa. Tamaher'ood hõm sa hã ramoo bong do hã. Tamejũũ na-ããj hẽ tób noo hag'ããs doo, baad tabahag'ããs hyb n'aa. Dooh raheen n'aa enä bä ny noo gó sa kariw n'aa matëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ti hadoo bë hã kä. Taw'ããts hẽ baad da bë gadaa, baad bë hyb n'aa matakä da. Dooh da bë hapëë bä ỹ matëëh bä, tób danäh matëëh do ta karom nahapäh do hadoo da. Dooh ji hapëë bä tób danäh kajaa bä, tug bä, atsëm, atsëm ub, tapaj'ëë bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dooh taw'ããts hẽ tado bä bë h'yy gatemah bä tób danäh nayyw hẽ takaja bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","—Ti hyb n'aa ỹ bedoo bë hã, sahõnh hẽ sa hã: Baad bë gadaa, baad bë matakä! —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ti m' pawóp nä m' ta ǟh Pas-kowa häd näng do bawät, pãw makuj tamah do rabawa noo gó. Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj mä ratyw n'aa esoos mä Jesus ramoo maso hõm hyb n'aa ta wób raky n'aa nanapäh bä m', radaj'ëëp hyb n'aa kä m'. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Rakaner'oot bä m' raky hadoo: —Dooh da ër dajëëb bä Pas-kowa noo gó, hajõk do ër wë rah'yy kawereem mahǟnh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ti m' panang Betanija häd näng doo bä m', Simaw saraa hã däk do paa tób bä, sa waa tyng hã m' Jesus basooh bä m', ana mä ta wë ỹỹnh. Buu benyym do hood mä ta moo gó m' tabadäk. Pä s'ëëb mä ta hood. Tak'ëp mä taky n'aa gebah, joom nah-do häd näng do s'ëëb heh'äät ta ti gó hanäng do buu benyym doo. Ti m' tanoo gatëh hõm, ti m' tabahah'ook Jesus nuu gó m'. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ti m' Jesus pa hat'oonh do wób rakawaj'ããn bong, ti m' raky hadoo sa da hadoo do sa hã: —Hëd n'aa tarejãã tii? ");
INSERT INTO mbjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Taw'ããts hẽ paawä takes'ëëm. Tak'ëp paawä ji ky n'aa geb'aah. Ta säm ji anoo paawä kas'uut do sa hã —näk mäh. Ti m' rabahajẽẽw wät ti ỹỹnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ti m' Jesus ky hadoo: —Bë hajẽẽw manäh! Na magëd ti ỹỹnh —näng mäh. —Tak'ëp baad hadoo do tamoo wäd wät hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kas'uut do aboo had'yyt hẽ bë mahang. Bë h'yy kajäk bä bë banoo sa hã. Ỹ ti hỹỹh, dooh bë mahang had'yyt hẽ ỹ awäd wäd bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","—Tahajaa do né hẽ ti tamoo wät hã ỹỹ. Ỹ radakä jëë pooj jé buu benäw n'aa tii d' nuh ỹỹ gó tah'ook doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ti m' taky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Jé pad'yyt hẽ badäk hahỹỹ hã P'op Hagä Do T'aah panyyg hanäm do rabaher'ood hõm bä, raher'oot da na-ããj hẽ hã ỹỹ hahỹ ỹỹnh moo wäd wät do ky n'aa, ji hyb n'aa esee hyb n'aa ta hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ti m' Judas Ikarijot häd näng doo, 12 hedoo do ta ma matëg sa seeh, bahõm P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wë, Jesus tahaëënh hyb n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ti m' rah'yy gadejah Judas Ikarijot kyy hã. Ti m' ta säm raky kajäk mä ta hã. Ti m' Judas Ikarijot tyw n'aa esóts kän tabahaëënh hyb n'aa kä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti m' pãw makuj n'aa tamah do rataheb'ëës do du däk bä m', b'éé t'aah aj'yy P'op Hagä Do matym n'aa ranaheb'ooh noo gó m', Jesus ma matëg rabeaanh ta hã: —Nyy bä makarẽn ãã benäm Pas-kowa tä n'aa, matab'ëës hyb n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ti m' tamejũũ pawóp hẽ ta ma matëg, ti m' taky hadoo sa hã: —Bë ahõm nä panang hẽnh. Bë kajaa bä, bë kataa da aj'yy hã naëng hes'ooh do hã. Ta jawén bë ahõm da. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti bajëë suun bä tób gó, bë eaaj da tób danäh hã hahỹỹ da: “Ãã ma matëg mejũũ ãã beaanh nyy bä tagadäk ta gawakõ, tatab'ëës hyb n'aa Pas-kowa ta ma matëg sa daheeh”, denoo da. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tii bä da ta gawakõ gaeh doo, p'op gadäk doo, tametëëh da bë hã. Ta tii bä tyng n'aa näng da. Kabenyyw däk da —näng mäh. —Ta tii bä bë moo boo ta tä n'aa, ta waa n'aa ër tab'ëës hyb n'aa —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ti m' pawóp hẽ ta ma matëg rabahõm panang hẽnh. Rakajaa bä m' panang bä, Jesus her'oot do hadoo né kä m'. Ti m' ramoo boo kän tii bä kä Pas-kowa tä n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Papỹỹj badëë hyng bä kä Jesus kajaa 12 hedoo do sa sii. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sa waa tyng pa rabat'oonh bä kä m', rabawëh bä kä m', taky hadoo sa hã: —Bë see ỹ tahaëënh da majĩĩ moo gó. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ti m' rah'yy ketón bong. Ti m' sét ken'yyh mä raky hadoo: —Hã ỹỹ, dooh ỹ tado bä! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ti m' Jesus ky hadoo: —Bëëh, 12 hedoo do see né da, nemon ỹ heh'oos do pãw né da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da dajëp P'op Hagä Do kyy kerih do her'oot doo da né hẽ —näng mäh. —Ti hadoo né hẽ, baad nado da aj'yy hã, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do majĩĩ moo gó han'oo däk do hã! Taw'ããts hẽ paawä ta ti aj'yy hã tanenyyts bä paawä! —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ti m' rabawëh bä, Jesus bado däk pãw, ti m' P'op Hagä Do hã taky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk pãw ãã hã —näng mäh. Ti m' taganabäh däk, tan'oo däk mä ta ma matëg sa hã. Ti m' taky hadoo: —Bë gado däk. Hup ỹ heen n'aa hahỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ti m' Jesus bado däk uwa bëëh hood, ti m' P'op Hagä Do hã ta ky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk uwa bëëh ãã hã —näng mäh. Ti m' taban'oo däk sa hã. Ti m' rabeëg pëë uwa bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ti m' taky hadoo sa hã: —Majyw ỹỹ, ỹ anoo do ỹ dajëp noo gó hajõk do sa hyb n'aa heen n'aa hahỹỹh. Papuuj sahõnh hã P'op Hagä Do ky n'aa enooh do tii kä. Hỹ jawén majyw ỹ hyb n'aa ji tagadoo P'op Hagä Do ky däng —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ti m' taky hadoo ẽnh sa hã: —Dooh ỹ eëg wäd bä hahỹ uwa s'ëëb. Jããm hẽ p'aa hẽnh papuuj däg ỹ eëëk da P'op Hagä Do bag'ããs doo bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ti m' Saaw-Mo wób me P'op Hagä Do rama ejäm do jawén paa bä m', rabahõm kän waëë joom oriib häd näng do banäng hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ti m' Jesus ky hadoo sa hã: —Bë sahõnh hẽ ỹ bë beréd hõm da —näng mäh. —Hahỹỹ da takerii däk P'op Hagä Do kyy kerih do hã ti ky n'aa: “B'éé hagã ỹ daj'ëëp da. Tii bä da jé pad'yyt hẽ b'éé rabehũũm bong” —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ti m' Jesus ky hadoo ẽnh: —Ta tii d' né paawä da hã ỹỹ, ỹ ganä wät jawén paa bä da, bë pooj jé da ỹ bahõm Garirej hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ti m' Peed ky hadoo ta hã: —Sahõnh hẽ õm reréd hõm bä, ỹ dooh õm ỹ eréd bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ti m' Jesus ky hadoo ta hã: —Badah né hẽ, atsëm, pawóp nuu me karaak bahỹỹh do pooj jé ỹ maky n'aa jejën da. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ti m' Peed ky kah'ũũm mä ta hã: —Dooh! —näng mäh. —Ỹ radajëëb bä na-ããj hẽ a sii, dooh noo gó da õm ỹ hyb n'aa eréd bä! —näng mäh. Ti ky hedoo né hẽ m' ta ma matëg wób. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ti m' Jesus rabahõm joom banäng hẽnh Getsemani häd näng doo hẽnh. Ti m' taky hadoo sa hã: —Babä bë ayyw dó ỹ ky n'aa ets'ẽẽ nuuj jé —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ti m' Peed, Tsijaag, Jowãw daheeh tamahũũm ta sii dawë hã. Ti m' Jesus h'yyb gó tak'ëp mä tah'yy katón wät. Dooh baad tado wäd bä ta h'yyb. Ti m' taky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Tak'ëp ỹ h'yy katón. Ỹ h'yyb dajëp do hadoo —näng mäh. —Babä bë ayyw, bë matakä. Bë aǟ manä da! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ti m' tabahõm dawë hã. Ti m' ta taron nu paa me tabahyy häng, ti m' taky n'aa etsẽẽ P'op Hagä Do hã tanahoop hyb n'aa tamo n'aa, tahaja bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hahỹỹ da m' ta kyyh: —Ee —näng mäh. —Dooh hejoonh pé a hã. Ti hyb n'aa ỹ karẽn paawä mado hõm mahǟnh ỹỹ wät hahỹ ỹ ahoop do pan'aa. Ta tii d' né ỹ bets'ẽẽ paawä, makarẽn doo d' né hẽ mabad'oo, ỹ karẽn doo da nado —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tabana bä m' ta ma matëg tamawoob hẽ hadoo do rahab'ëëh hẽnh, taheg'ããs mäh, aǟ b'ëëh mäh. Ti m' tanaëëj nyyh Peed ta häd heh'äät doo me: —Simaw! —näng mäh. —Õm aǟ jëng? —näng mäh. —Dooh mahaja bä kanahën d'os hẽ maty gadäg bä si ỹỹ? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—Bë matakä, P'op Hagä Do hã bë ky n'aa ets'ẽẽ, nesaa do h'yyb tatug mahǟnh bëëh, ỹ bë eréd hõm mahǟnh —näng mäh. —Ji h'yyb karẽn né paawä baad hadoo do ji moo wät, nahejooj ji, ti hyb n'aa bë ky n'aa ets'ẽẽ ỹ wén näng —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ahõm ẽnh p'aa hẽnh, taky n'aa etsẽẽ do paa taky n'aa etsẽẽ ẽnh p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti m' p'aa hẽnh tabana bä ẽnh, aǟ b'ëëh ẽnh mäh, tak'ëp mä raty jewyk sa h'yyb. Dooh m' sa kyyh pé ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tamawoob nuu me m' tabahado däk bä m' taky hadoo sa hã: —Bë kameh'ããk nä? Bë aǟ magyys hẽ? Jããm hẽ dó! —näng mäh. —Kaja däk ỹ ran'oo däk doo. Bë hegãã. Aj'yy Hadoo Do Hỹ Pong Jé Hana Do nesaa do moo heb'ooh do sa moo gó rabahaëëj däk hỹỹ kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","—Bë as'ëëg bëh! Hamäh, ër ah'ũũm. Wät ta ti ỹ han'oo däk do majẽ ỹỹ hã —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus ber'oot nä bä m', takajaa Judas, 12 hedoo do see paah. Hajõk mä han'aa ta sii. Sẽn-jeer yt hã m', boh yt hã m' rabana. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa kyy gó m', Mosees ky n'aa jaw'yyk do ma mehetëk do sa kyy gó m', Judah buuj sa wahë n'aa hedoo do sa kyy gó m' na-ããj hẽ ti rabana. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Haëënh do baad ub mä taky n'aa her'ood däk. Hahỹỹ da m' ta kyyh sa hã: —Ta ti ỹ tapa tsanetsup doo da, ti né hẽ tii. Tii d' bë maso däk, bë maso hõm baad ub —tii da m' ta kyy dó sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ti m' nayyw hẽ Judas bana Jesus wë, ti m' taky hadoo: —Ma matëg! —näng mäh. Ti m' ta tapa tsanetsup mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ti m' ta hã rakajäk, ramaso däg kän mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ti m' Jesus pa hagëët do seeh, bado däk ta sẽn-jeer, tekyyt mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom. Ta nabuuj gakyd hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ti m' han'aa do hã Jesus ky hadoo: —Ër wahë n'aa wë h'yy kawereem do sa h'yyb mahũũm n'aa bë ed'oo g'eeh ỹỹh, bë wén n'aa wë ỹỹ sẽn-jeer yt hã, boh yt hã, ỹ bë masoo hyb n'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","—P'op Hagä Do tób n'aa wahoo gó ỹ awäd had'yyt hẽ bë sii ỹ ma metëëk bä. Dooh ẽnh ỹ bë maso bä tii bä ẽnh? —näng mäh. —Hỹỹ kä, taw'ããts hẽ —näng mäh. —Ỹ hapäh, tii da tawén hadoo, P'op Hagä Do kyy kerih do hã ỹ kaja däk hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ti m' sahõnh hẽ kä ta hata rawaj'aa bong. Reréd hõm mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jããm hẽ sét hẽ wanajaah, pahëëw. Sét mä tadadäk ta hatsë pããn rino s'ëëb. Jesus jawén paawä tabahõm, ti m' ramaso däg bä paawä m', ");
INSERT INTO mbjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","teréd däk mä ta hatsë. Hahót mä tawaj'aa hõm. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ti m' Jesus ramahũũm kän P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do wë kä. Ti m' rakata padëëk t'ĩĩ hẽnh sahõnh hẽ P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, Judah buuj sa wahë n'aa hedoo do sii hẽ m'. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ti m' Peed bahõm mä Jesus sa jawén. Dawëë m' tagadäk. Ajëë suun mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do tób wahoo gó. Ti m' warahén sa pa m' tabahyy häng. Katëng mä sa nemuun tëëg me. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa hedoo doo, sahõnh hẽ Sinedirijo häd näng do ajyy n'aa sii hẽ m' resoos mä Jesus hã rap'ãã daj'ëëp péh. Resóts né paawä m' Jesus raky n'aa tapaa doo, dooh m' raw'yyt pé rap'ãã daj'ëëp péh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hajõõ né paawä m' daap ramenyyh Jesus ky n'aa hã, dooh m' séd gó rer'ood bä. Raky n'aa eh'ỹỹt mäh. Ta see ky n'aa hadoo mä ta see an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ti m' p'op mä ta wób rabes'ëëg b'ëëh, ti m' daap ramenyyh Jesus ky n'aa hã. Hahỹỹ d' mä sa kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ãã maa napäh taher'oot doo. Hahỹỹ da ta kyyh: “Ỹ gawatsiig hõm da hahỹ P'op Hagä Do tób n'aa, ajyy sa mo haj'aa. Tii bä, tamawoob hẽ ta ǟh, ỹ moo wäd sooh P'op Hagä Do tób n'aa seeh, ajyy mo haj'aa nadoo doo”, näng ta kyyh —näk mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tii d' né paawä m' sa kyyh, ti na-ããj mä dooh m' séd gó rer'ood bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do p'op mä tabas'ëëg gëët sa mahang. Teaanh Jesus hã: —Dooh maher'oot pé õm raky n'aa tapaa do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dooh m' Jesus ky gado bä. Bag hẽnh mä tabagëët. Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do beaaj kän ta hã: —Õm ti Kristo, P'op Hagä Do H'yyb Däng Doo? Õm P'op Hagä Do T'aah? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Ỹỹ. Ỹ né hẽ —näng mä Jesus. —Bë hapäh né da Aj'yy Hadoo Do Hỹ Pong Jé Hana Do Sahõnh Sa Bahǟnh Hado Do hub hẽnh tabasooh bä, ta hã P'op Hagä Do weh'ëëh doo bä. Bë hapäh né da ẽnh tabahyng bä wë puh mahang —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do kawaj'ããn gó tawén s'ẽẽd hõm ta daaj hẽ ta saroor. Ti m' taky hadoo: —Jããm hẽ. Dooh hyb n'aa wät pé ta ky n'aa her'oot péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","—Bë maa napäh né hẽ ta kyyh, P'op Hagä Do taky n'aa rejãã doo —näng mäh. —Nyy da bë hã? —näng mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do kyyh. Ti m' sahõnh hẽ raky hadoo: —Taw'ããts hẽ tadajëp! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ti m' ta wób rabahetsoos, ti m' raty maw'yyd däk tanahapäh hyb n'aa, ti m' rabetuu sa moo me, ti m' rabeaanh ta hã: —Maher'ood mahapëë bä! Jaa mo haj'aa? —näk mäh. Ti m' P'op Hagä Do tób n'aa warahén n'aa ramahũũm kän, ti m' rahewyyh mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti m' Peed bahäng bä m' tób w'oo hã, tabës mä tii bä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom ỹỹnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tahapäh bä m' Peed katëng tëëg noo pa, tabaheg'ããs ta hã. Ti m' taky hadoo ta hã: —Õm na-ããj hẽ Jesus Nasaréh buuj sii hawät do paa õm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ti m' Peed ky n'aa jejën wät. —Dooh ỹ hapëë bä ta ti maher'oot doo. Dooh ỹ heen n'aa nyy bä —näng mäh. Ti m' Peed bahõm ta hadë noo bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","T'ĩĩ hẽnh ỹỹnh bahapäh bä m', taky hadoo sa pa hab'ëëh do sa hã: —Hahỹ sa hata see né hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ti m' Peed jejën ẽnh mäh. Badah peej hadoo mä kä, ta pa hab'ëëh do p'op, raky hadoo ta hã: —Sa hata see né hẽ õm —näk mäh. —Garirej hẽnh naa né hẽ õm —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ti m' Peed ta daaj hẽ taky n'aa kawas'ee kän. Ti m' P'op Hagä Do hã taky däng: —Dooh ỹ hapëë bä ta ti aj'yy bë ky n'aa her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ti m' nayyw hẽ m' karaak bah'ỹỹ kän pawóp nuu me däg kä. Tii bä m' Peed hyb n'aa newë däk Jesus her'oot do paa ta hã kä: “Pawóp nuu me karaak bahỹỹh do pooj jé, tamawoob nuu me ỹ maky n'aa jejën da.” Ti né paa kä m' Jesus her'oot do paa kä ta hã. Ti m' tak'ëp Peed baód kän taky n'aa jejën do hyb n'aa Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bäp paa m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, Judah buuj sa wahë n'aa, sahõnh hẽ Sinedirijo ajyy n'aa sii hẽ m' rahyb n'aa n'oo däk Jesus. Ramoo maw'yyd däk, ramahũũm Pirato häd näng do wë. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ti m' Pirato beaanh Jesus hã: —Õm né Judah buuj sa wahë n'aa? —näng mäh. —Ỹỹ. Tii d' né hẽ, maher'oot doo d' né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa hajõng mä Jesus raky n'aa tapaa Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ti m' Pirato ky hadoo ta hã: —Dooh maky gado bä? Hajõng do hã õm raky n'aa tapaa —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dooh m' Jesus ky gedag bä. Ti hyb n'aa m' Pirato hyb n'aa meuuj wät. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pas-kowa noo gó m' Pirato bahed'oo doo da taberéd hõm radewëës do seeh. Teréd hõm hajõk do retsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti noo gó m' ragadahew'ëës doo gó m' tabagëët Barabas häd näng doo, ta hataa sa daheeh. Ta see tadaj'ëëp paa ta wób sa sii m' Roma buuj wë rah'yy kawereem noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ti m' hajõk do rabana Pirato wë, ti m' rabetsẽẽ ragadahew'ëës doo gó hab'ëëh do see tamanyyh hyb n'aa, Pas-kowa noo gó tabahed'oo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti m' Pirato beaanh sa hã: —Bë karẽn ỹ ado nyyh bë matym n'aa Judah buuj wahë n'aa ramaneëënh doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tii d' tawén eaanh, tahapäh mäh, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa ta hã rahaëëj däk Jesus, Jesus hã rah'yy kajew'ëës do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa ky mejũũ mä hajõk do rabetsẽẽ hyb n'aa Pirato hã Barabas häd näng do Jesus jawén buuj. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ti m' Pirato ky hadoo: —Tii d' tado bä, nyy da ỹ bad'oo hỹ Judah buuj sa wahë n'aa bë maneëënh do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tii bä m' tak'ëp rageëëj bong: —Mepëëm däg b'aa kajatsëk do hã! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Hëd n'aa? —näng mä Pirato. —Dooh mo haj'aa kad'oo do tado bä —näng mäh. Taher'ood né paawä m' tak'ëp rageëëj bong tii bä: —Mepëëm däg! Mepëëm däg! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hajõk do Pirato h'yyb en'yym hyb n'aa m' taberéd hõm mä Barabas häd näng doo. Ti m' tamejũũ rabahewyyh Jesus. Ti m' tahaëëj däk warahén sa hã rabepëëm däk hyb n'aa b'aa kajatsëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ti m' warahén ramahũũm Jesus sa wahë n'aa tób wahoo hẽnh. Tii bä m' ranaëëj nä sahõnh hẽ sa hataa, séd hã rakata padëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ti m' radasuun jëng ta hã ta hatsë hahiin doo. Ti m' hetëk do moo m' ramap'õõd däk, ta nuu gó m' radasooh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tii bä m' radu doo raky n'aa ej'ees do ta hã. Hahỹỹ da m' sa kyyh: —Kaweh'ëëh Judah buuj sa wahë n'aa! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hajõõ nuu me m' ranu gewyyh tatu me, rabahetsoos sa matsós me. Ti m' sa taron nuu me m' ramehyy b'ëëh ta wë, raweh'ëëh doo gó m' raky n'aa mes'uunh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ti m' raky n'aa ej'ees jawén paa bä m' rado nyyh mä ta hatsë hahiin doo, radasuun jëng mä ta saroor hẽ. Ti m' ramanyyh rabepëëm däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ti m' ramanyyh bä m', aj'yy Simaw häd näng doo, panang hẽnh hajëng doo, tabëëj paawä m' sa hã. Panang Sirené häd näng doo bä naa m' tii. Aresãn, Rupu häd enäh do sa yb tii. Jerusarẽnh panang hẽnh tabajëë paawä. Ti m' warahén ramejũũ mä tabes'ooh hyb n'aa b'aa Jesus rahepëëm däk do b'aa n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ti m' Jesus ramahũũm Gogota häd näng doo hẽnh. (Gogota häd näng doo m', ji nu gabóg k'yy rahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ti m' ramenoo ta hã joom uwa häd näng do s'ëëb hejoonh doo. Kamekuunh mä ti datés do biin me, miir häd näng do s'ëëb. Dooh Jesus eëg bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tii bä kä m', repëëm däg kän mäh. Ti m' ramoo bong ramas'uunh doo, rabahapäh hyb n'aa ta saroor uuh wë ym doo. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","P'op däg mä papỹỹj, 9 oor däg mä ti rabepëëm däk. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hahỹỹ da m' takerii däk Jesus moo p'ãã tadajëp do heen n'aa hã: “Judah buuj sa wahë n'aa hahỹỹh”, näng mä kerih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","B'aa kajatsëk do wób hã rabepëëm padëëk na-ããj hẽ pawóp hẽ ajyy baretsëk doo. Hub hẽnh ta see hahäng, s'ỹỹ hẽnh ta see hahäng. Hõõ gó Jesus kahepëëm däk do bahäng. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ta tii hã kaja däk P'op Hagä Do kyy kerih do paa hahỹỹ d' her'oot doo: “P'op Hagä Do ky n'aa jaw'yyk do ky nadah'eeh do h'yyb hata däk ran'oo bä P'op Hagä Do H'yyb Däng Doo.” ");
INSERT INTO mbjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta tii me teb'ëës do raky n'aa rejãã mä Jesus, sa nuu m' rewõnh Jesus wë. Hahỹỹ d' m' sa kyyh: —Magawats'iik mäh, a nooh, P'op Hagä Do tób n'aa. Tamawoob mä ta ǟh mamoo wäd sooh p'aa hẽnh, a nooh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ahyy b'aa hã hadäk do õm! A daaj kedëëb! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ raky n'aa ej'ees mäh. Sa daaj hẽ m' rakaner'oot: —Ta wób ted'ëëp —näk mäh. —Dooh tahaja bä ta daaj hẽ takedëëb bä! ");
INSERT INTO mbjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hahỹ Kristo, P'op Hagä Do H'yyb Däng Do hanäng doo, Isaraéw buuj sa wahë n'aa hanäng doo, taw'ããts hẽ tabahyng b'aa kajatsëk do hã tahadäk do hã naa, ãã baheg'ããs hyb n'aa, ãã ky daheeh hyb n'aa! —näk mä sa kyyh. Ta pa habëëh do b'aa hã pad'ëëk doo, ti na-ããj hẽ raky n'aa rejãã mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wasyk mä ta bag badoo wät, badagyb däk mä badäk hahỹỹ hã. Jããm hẽ tug bä tabawag däk p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tug bä m', tak'ëp mä Jesus geëëj wät: —Eroj, Eroj, rama sabakatani? —näng mäh. “P'op Hagä Doo, ỹ h'yy kasahadä doo, hëd n'aa ỹ mamakyys?”, tahanäng pé m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta tii bä p'eets hẽ hab'ëëh do wób ramaa napäh bä m' ta kyyh, raky hadoo: —Bë maa newë! —näk mäh. —Eriij ti tanaëënh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ti m' sa see waj'aa däk, sapum do tehoots däk uwa s'ëëb oow me, b'aa hã m' tagadahäng, tamenoo mä Jesus hã tabeëëk hyb n'aa. Ti m' ti ky hadoo: —Na madëëg! —näng mäh. —Ti b' ër heg'ããs Eriij ana bä tamahyyh hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ti m' tak'ëp mä Jesus geëëj wät, ti m' tadajëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tii bä m', P'op Hagä Do tób n'aa t'õp ta gó noo gatsë hebaan do kas'ẽẽd hyng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ti m' warahén sa wahë n'aa Jesus ty gadäk hẽnh hab'ëëh doo, tamaa napäh bä Jesus geëëj wät doo, tahapäh bä m' nyy da Jesus dajëp doo, taky hadoo: —P'op Hagä Do T'aah né paa ti hỹ aj'yy! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dawëë naa m' ỹỹj wób rabaheg'ããs. Sa mahang mä ab'ëëh Marija Madarẽn häd näng doo, Sarome häd näng doo, Marija seeh. Tsijaag, ta jawén nä ramaneëënh doo, Josés ta hỹỹj daheeh sa ỹỹn ti Marija. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesus hep'ëëh né hẽ m' ti ta tii. Garirej häj n'aa bä Jesus hataa né paa m' tii. Sa tä moo bo n'aa né paa m' tii. Hajõk mä ỹỹj ta sii han'aa do Jerusarẽnh hẽnh, ti na-ããj mä tii bä m' rabab'ëëh ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Saab pooj jé m' ti tabahadoo. Saab pooj jé né hẽ m' ta ti Judah buuj rabahenyyw hõm Saab hã rakamehehãk hyb n'aa. Tug bä kä m', ");
INSERT INTO mbjNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joséh, panang Arimatsija häd näng do buuj, bahõm Pirato wë. Sinedirijo ajyy n'aa see ky n'aa etsëëh do m' ti Joséh. Tagada né hẽ m' P'op Hagä Do bag'ããs do du däk. Ti m' tabahõm Pirato wë. Dooh m' tah'yyb eỹỹm bä. Tetsẽẽ mä Jesus kamag n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ti m' Pirato hyb n'aa meuuj wät mä Jesus nayyw hẽ dajëp tahanäng doo. Ti m' tamejũũ ranaëënh warahén sa wahë n'aa tabeaanh hyb n'aa ta hã te hub tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ti m' ta heen n'aa nyy däk bä warahén sa wahë n'aa her'oot doo, ti m' tabahaëëj däg kän Joséh hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ti m' Joséh etsẽẽ mä pããn hawak doo, rino häd näng do s'ëëb. Ti m' tabado hyy kän Jesus kamag n'aa, ti m' tahabën däk mä hawak doo me. Ti m' tadasuun jëng pä gabaho doo gó, kamag hood n'aa ragagots däk doo gó. Ti m' pä gatsabak do tepëëd nä, taty gatsëë däk mä ta me. ");
INSERT INTO mbjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marija Madarẽn, Marija see Josés ỹỹn raheg'ããs. Rahapäh mä ragadasuun jëng do Jesus kamag n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ti m' papỹỹj badëë hyng jawén paa bä, Saab bahëëj jëng bä, Marija Madarẽn, Sarome, Marija Tsijaag ỹỹn ah'ũũm mä buu benyym doo m' retsẽẽ. Jesus kamag n'aa hahog pan'aa m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ti m' bäp paah, met'uuh hã, papỹỹj ty ganä këë bä, rabahõm kän pä gabaho doo hẽnh, Jesus kamag n'aa radasuun jëng hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ramahõm me, tyyw me, rakaner'oot: —Jaa da pä jawyk do ty gas'ëës? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti m' raty kajäk, pä kepëëd hõm taty gatsë. Aeh mä ti pä. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ti m' rabajëë p'ëë gabaho doo gó. Ti m' rabahapäh, asooh mä pahëëw hadoo. Hawak mä ta saroor tagasooh. Hub tabanäng hẽnh mä tabasooh. Ti m' rah'yyb e'ỹỹm bong. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ti m' taky hadoo sa hã: —Bë eỹỹm manäh! —näng mäh. —Bë esoos Jesus Nasaréh buuj, repëëm däk do paah. Dooh wäd bä. Ganä wät! B'ëëp, bë hegãã radasuun jëng do paa bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","—Bë ahõm nä, bë maher'ood ta ma matëg sa hã, Peed hã sii hẽ. Hahỹỹ da da bë kyyh: “Ahõm da bë pooj jé Garirej hẽnh. Bë hapäh da t'ĩĩ hẽnh, bë tamaher'oot do paa da” —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ti m' rawaj'aa hõm, kaj'uun mäh, h'yyb manepëë boo m'. Dooh m' raher'ood bä sa hã rabeỹỹm bong do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ti m' met'uuh hã bäp paah, Jesus ganä wät. Pooj jé Marija Madarẽn hã m' takas'ee wät. Ta ti m' Marija setsi karap'aar h'yyb nesaa do hanäng do tahebëë bong do paa m'. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ti m' tabahõm Jesus sii habok do paa wë. A'oot mä tii. H'yy ketón bong mä Jesus hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ti m' Marija Madarẽn baher'oot bä m' sa hã Jesus ganä wät doo, Jesus tahapäh doo, dooh m' raky dahé bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta jawén kä Jesus kas'ee wäd kän ta see hado däk mä pawóp hẽ ajyy panang s'ee hẽnh hah'ũũm do sa hã, ta tyw n'aa me rababok bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ti m' ajyy mat'ëëh p'aa hẽnh, raher'oot mä ta wób sa hã. Ti sa hã na-ããj mä dooh raky dahé bä. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tii bä kä m', Jesus kas'ee wäd kän 11 hedoo do ta ma matëg sa hã kä sa tä rabawëh bä m'. Ti m' taky hadoo sa hã: —Hëd n'aa ti bë nabuj keh'ũũm bë ky nadaheeh ỹ hap'ëëh do ỹ ganä wät jawén paa bä? —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ti m' taky hadoo ẽnh: —Bë ahõm jé pad'yyt hẽ badäk hahỹỹ hã. Bë maher'ood hõm sahõnh sa hã hanäm do panyyg këh ỹ n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","—Panyyg ky dah'eeh doo, nu kemuun bong doo, P'op Hagä Do ed'ëëp da ta wë. Panyyg ky nadah'eeh doo, P'op Hagä Do ky n'aa etyy da banesaa hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Ti m' taky hadoo ẽnh: —Panyyg këh ỹ n'aa ky dah'eeh do hã P'op Hagä Do anoo da hahỹ tak'ëp rahajaa doo: Karap'aar h'yyb nesaa do rahebë da hät ỹỹ gó. Ta wób kyyh rer'oot da. Aw'yy rameso bä da, p'yym reëg bä da, dooh da ramahỹỹj hob bä. Sa moo radatoonh da nahëë enäh do nu gad'oo bä, heso padëëk da nahëë enäh doo. Ta heen n'aa ti ta tii, te hub né hẽ këh ỹ n'aa ta wób rabahapäh hyb n'aa —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus, Tak'ëp Hyb N'aa Jawyk Doo, ber'oot jawén paa bä sa sii, P'op Hagä Do masäg kän hỹ pong jé. P'op Hagä Do hub hẽnh, takaweh'ëëh doo bä tabaso däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ti m' ta ma matëg rabahõm kän, ti m' jé pad'yyt hẽ rabaher'ood hõm kän mä Jesus ky n'aa kä. Jesus, p'op naa né hẽ tamasa sa hã tapehuunh doo me, sahõnh hẽ rabahapäh hyb n'aa te hub né hẽ ta ti ta ky n'aa. Jããm né hẽ hahỹ Jesus P'op Hagä Do T'aah panyyg kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Õm ỹ ma erih hahỹỹh, Teopiro. Hajõk herii bong ãã häj n'aa bä hawäd wät do ky n'aa, Jesus ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sahõnh hẽ tadu däk bä hap'ëëh doo, P'op Hagä Do panyyg hanäm do her'ood hõm do raher'oot sa hã raberih hyb n'aa. Tii d' né paa raberih. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hỹỹ kä, Teopiro, hyb n'aa jawyk doo, sahõnh hẽ baad ỹ ma kamet'ëëg wät jawén paa bä ta ti ky n'aa, ỹ na-ããj hẽ hỹỹ kä ỹ erih ta ky n'aa. Sét ken'yyh ỹ ma erih doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ta tii da ỹ wén erih, õm rama met'ëëg wät do Jesus ky n'aa hã, se hub né hẽ baad mabahapäh hyb n'aa ỹ erii wät do hã maner'ood bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti m' sa wahë n'aa Eróts häd näng do Judah häj n'aa bä tabag'ããs noo gó, ti awät mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do seeh. Sakarija m' ta häd. P'op Hagä Do tób n'aa yt hã moo heb'ooh do wahë n'aa see Abijah makũ panaa né m' tii. Ta ỹỹm häd mä Isabew. Sa ky n'aa rod P'op Hagä Do wë wahë n'aa makũ Arãw häd näng do panaa né m' tii ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Baad ub mäh, P'op Hagä Do karẽn doo da rababok. Baad ub né hẽ raky daheeh sahõnh hẽ P'op Hagä Do mejũũ doo, ta ky n'aa jaw'yyk do kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dooh m' rataah nyy bä. Dooh m' Isabew eta bä. Wehëh padäg mä ta patug daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ti m' ta see pé noo gó, P'op Hagä Do tób n'aa yt hã moo heb'ooh do wób, Abijah makũ karapee, P'op Hagä Do tób n'aa yt hã ramoo bok noo gó, Sakarija moo wät mä tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sakarija hã m' rah'yy kajäk t'õp gadäk doo gó tabajëë suun hyb n'aa, buu benyym do in-sijẽẽn häd näng do tabajuu hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti m' buu benyym do tabajuu bä m', hajõk mä ta noo bä hab'ëëh. P'op Hagä Do hã m' raky n'aa etsẽẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ti m' P'op Hagä Do ããs kasee Sakarija hã m'. Buu benyym do rabahej'uu do tyng hẽnh, hub hẽnh mäh, ããs bag'ëëd däk. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tak'ëp mä Sakarija beỹỹm wät. H'yy gabadoo wät mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ti m' ããs ky hadoo ta hã: —Eỹỹm manäh, Sakarija —näng mäh. —P'op Hagä Do maa napäh metsẽẽ do ta hã —näng mäh. —Etaah da a ỹỹm. Aj'yy da bë t'aah. Man'oo da ta häd Jowãw —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Tak'ëp da bë h'yyb tsebé ta hyb n'aa. Hajõk ratsebé tabenäng bä, ");
INSERT INTO mbjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","hyb n'aa jawyk P'op Hagä Do matym gó tabahadoo do hyb n'aa da —näng mäh. —Taw'ããts hẽ dooh d' teëg da uwa bëëh hejoonh doo, ta wób na-ããj hẽ mahỹỹnh doo. P'op Hagä Do Sahee h'yyb mahũũm da a t'aah ta ỹỹn wog gó tabasuun nä bä na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—Hajõk da Isaraéw buuj tah'yyb wapëën hõm p'aa hẽnh P'op Hagä Do wë, sa hagã n'aa wë, ta hã rah'yy ka'eeh hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Tak'ëp Hyb N'aa Jawyk do pooj jé da Jowãw bawäd däk da, Isaraéw buuj sa h'yyb tym tabenäm hyb n'aa Tak'ëp Hyb N'aa Jawyk Do wë. P'op Hagä Do Sahee hejój gó tabawät da, P'op Hagä Do ky n'aa rod Eriij makũ hawäd wät do paa hadoo da, sa yb sa taah rah'yyb en'yym hyb n'aa sa wë, nabuj keh'ũũm do rah'yy kawapëën hyb n'aa, rah'yy genäh hyb n'aa kä baad P'op Hagä Do karẽn doo da habok do rah'yy genäh doo da —näng mä ããs kyyh Sakarija hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ti m' Sakarija ky hadoo: —Nyy d' ỹ bahapäh ta ti te hub tado bä? —näng mäh. —Wah'ëë däg ỹ ti hỹỹh. Wah'ëë däg ǟm ỹ né tii ẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ti m' ããs ky hadoo Sakarija hã: —Gabirijéw häd näng do ỹ ti hỹỹh —näng mäh. —P'op Hagä Do pa hegët do ỹ hỹỹh. Ta ti né hẽ ti ỹ tamejũũ hahỹ hanäm do ky n'aa õm ỹ maher'oot hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","—Hỹỹ kä, —näng mä —dooh d' mer'ood wäd bä a t'aah benäng bä kä, ỹ maky nadaheeh do hyb n'aa. P'op Hagä Do h'yyb däng noo gó da ti awät né da a hã ỹ her'oot do a t'aah ky n'aa —näng mä ããs kyyh Sakarija hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti nuuj jé m' P'op Hagä Do tób n'aa noo bä kata b'ëëh doo, ky n'aa ets'ẽẽ doo, ragada mä Sakarija banyyh. “H'ëëd hyb n'aa ti tabadoh?”, näk mä sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ti m' tabanyyh bä kä m', dooh m' tahaja wäd ter'ood bä. Ta moo me m' tameh'eed däg up. Ti hyb n'aa rah'yy genäh. P'op Hagä Do metëëh do tahapäh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ti m' P'op Hagä Do tób n'aa gó tamoo wät do bahänh bä kä, tababaaj hõm kän mä ta tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti m' nayyw hẽ denaa hẽ kä m', ta ỹỹm Isabew häd näng do beta däg kän mäh. Ji ma poo oow pé kä m' ta kamarab n'aa ta ỹỹm gada ta tób bä, dooh m' tawäd bä ta s'ee hẽnh. Ti m' Isabew ky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Hahỹ P'op Hagä Do anoo hã ỹỹ —näng mäh. —Ỹ tat'yyd mehĩĩn. Tado hõm hã ỹỹ ỹ nu mebyng doo, ỹ netaah doo —näng mä Isabew kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","6 kamarab tabahado däk bä m', P'op Hagä Do mejũũ ããs, Gabirijéw häd näng doo, tabahõm hyb n'aa panang Nasaréh häd näng doo hẽnh, Garirej häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tamejũũ mä tabeg'ããs hyb n'aa maruus wë, Joséh häd näng do ỹỹm pan'aa wë. Dawi panaa né m' ti Joséh. Dooh m' aj'yy tamepëë nä bä ti maruus. Ta häd mä Marija. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ti m' ããs bahõm ta wë, ti m' taky hadoo: —Ỹ ana a wë õm ỹ panäk hyb n'aa. P'op Hagä Do ky enyym a wë. A hã hẽ tabawät —näng mä ããs Gabirijéw häd näng do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ti m' Marija hyb n'aa tón gëët mä ããs her'oot do hã. Ti m' tahyb n'aa newëë. Ta h'yyb gó m' tabedoo: —H'ëëd ky n'aa ti hỹỹ éh? —näng mä Marija ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ti m' ããs ky hadoo ta hã: —Eỹỹm manä Marija! —näng mäh. —A hã P'op Hagä Do h'yyb däng. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Õm da eta däk, enyy däg da a t'aah. Mahäd n'oo däk da Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ky n'aa etsëëh da. P'op Hagä Doo, Sahõnh Hẽ Sa Bahǟnh Hadoo Do T'aah da ramaneëënh —näng mäh. —P'op Hagä Do anoo da ta wahë makũ Dawi häd näng do jawén buuj tabahadoo hyb n'aa, sa wahë n'aa tabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jakóh panaa sa wahë pan'aa da had'yyt da. Tabagãã had'yyt da —näng mä ããs kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ti m' Marija ky hadoo ããs hã. Teaanh mäh: —Nyy d' mä tii? Dooh aj'yy ỹ mepëë bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ti m' ããs ky hadoo: —P'op Hagä Do Sahee da ahyng a wë —näng mäh. —P'op Hagä Doo, Sahõnh Hẽ Sa Bahǟnh Hadoo Do hejój a hã da tabadäng. Ti hyb n'aa da hahỹ karapee hã P'op Hagä Do h'yyb däng. Ramaneëënh da P'op Hagä Do T'aah —näng mä ããs kyyh Marija hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ti m' taky hadoo ẽnh: —A wakããn, Isabew häd näng doo, ti na-ããj hẽ etaah ta wah'ëë gó. Raher'oot né paa ti netah. Hỹỹ kä eta däk —näng mäh. —Ji ma poo oow see pé däg ta kamarab n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dooh hejoonh pé P'op Hagä Do hã —näng mä ããs kyyh Marija hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ti m' Marija ky hadoo: —P'op Hagä Do karom né ỹỹh. Tamejũũ do ỹ moo wät da —näng mäh. —Taw'ããts hẽ ta ti tahado bä, maher'oot do hã ỹỹ —näng mäh. Ti m' ããs ahõm kän mä p'aa hẽnh ta mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ti m' nayyw hẽ denaa hẽ Marija bahõm kän mä panang hẽnh, Isabew hagä hẽnh, waëë habëë hẽnh, Judah häj n'aa bä. Ta tsym n'aa kaw'aat mä tabahõm. Ti m' tób gó m' tabajëë suun. Isabew mä tedëng. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti m' takedëë sii hẽ m' ajãn Isabew wog gó hasuun do kahasyyg wät mä ta wog gó. Baad mä P'op Hagä Do Sahee badäg däk Isabew h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ti m' Isabew ky hadoo Marija hã, tak'ëp mä ta kyyh: —Baad õm P'op Hagä Do ky n'aa edëng ỹỹj wób sa mahǟnh. Ajãn hã na-ããj né hẽ baad hadoo do tah'yyb däng —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ti m' Isabew ky hadoo ẽnh: —Tak'ëp Hyb N'aa Jawyk Doo, ta hã ỹ h'yy kaha'eeh do ỹỹn pan'aa mabahado né paawä mabana ỹ mabaheg'ããs. Ỹ maweh'ëëh ta ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ỹ medëë sii hẽ, wok ỹỹ gó ajãn kahasyyg wäd is, tsebee wät —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","—Baad õm P'op Hagä Do ky n'aa edëng maky daheeh do hyb n'aa a hã taher'oot doo —näng mä Isabew kyyh Marija hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ti m' Marija ky hadoo: —Hëp ỹ tym P'op Hagä Do taj'aa etsë. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Hëp ỹ tym tsebee kän P'op Hagä Doo, hëp ỹ tym dëëb wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ta wë hëp ỹ tym wén tsebé, ỹ ta karom its tahyb n'aa esee do hyb n'aa. Hỹ jawén sahõnh hẽ ỹ ramaneëënh da ỹỹnh ky n'aa kedëng doo, ");
INSERT INTO mbjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tak'ëp baad hadoo do P'op Hagä Doo, sahõnh haj'ap do banoo do hyb n'aa hã ỹỹ. Tsyt hẽ, sahõnh hẽ nesaa do mahǟnh né tii. Baad had'op do né tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sahõnh hẽ badäk hahỹỹ hã habong doo, sa panaa na-ããj né hẽ, ta hã hyb n'aa jew'yyk doo, P'op Hagä Do t'yyd mehĩĩn had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tak'ëp hejoonh do P'op Hagä Do mo haj'aa. Hahỹỹ da tamo haj'aa: Jé pad'yyt hẽ dawë hã tabetyn hõm h'yy kasab'ee doo gó sa hã hẽ h'yy kasadä doo, P'op Hagä Do karẽn do raty n'aa ges'yyk doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tasog hõm hyb n'aa jewyk do sa hejój, ti taban'oo kän hyb n'aa sakog is do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Baad taban'oo kän sa tä, sa waa, has'aah do sa hã. Tan'oo kän ta si n'aa hẽ rababaaj hõm tak'ëp ma enäh do paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tamasaa wät Isaraéw buuj, ta karom. Ta t'yyd mehĩĩn had'yyt sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dooh tamabaan bä Abaraãm hã, Abaraãm panaa hã taky n'aa enooh doo. Nahëëj sa hã taky n'aa enooh do paah —näng mä Marija kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ti m' tamawoob hẽ kamarab Marija bayyw kän mä Isabew tób bä. Ti m' tababaaj hõm kän ta tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti m' Isabew t'aah benyy däk bä kä, enäng mä kä aj'yy. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Isabew pa haj'eenh doo, ta wakããn na-ããj mä rapanyyg enä hõm bä kä, ratsebee kän mä ta sii. Isabew P'op Hagä Do t'yyd mehĩĩn, rahegãã bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ti m' ta t'aah 8 ta ǟh tabahado däk bä, sa wakããn, sa pa haj'eenh do na-ããj hẽ rabana ta t'aah masuuj noo byyh kahõg hõm do raheg'ããs. Rakarẽn mä ta häd ramaneëënh Sakarija, ta yb häd. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ti m' Isabew ky hadoo: —Dooh —näng mäh. —Ta häd da Jowãw —näng mäh. Ti m' raky hadoo ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Hëd n'aa ta tii d' ta häd? —näk mäh. —Dooh ta tii da Jowãw häd näng pé bë wakããn —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ti m' sa moo me rameaanh ta yb hã nyy da ta t'aah häd. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti m' ta moo me Sakarija metsẽẽ ta hã rabanoo raher'iih doo. Ti m' rahyb n'aa meuuj bong terih do hã. “Jowãw” mä terii däk. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tii bä kä m', taber'ood däg kän p'aa hẽnh kä. Ti m' Sakarija j'aa etsëë kän mä P'op Hagä Doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ti m' sa pa haj'eenh do rahyb n'aa meuuj bong mä tak'ëp. Jé pad'yyt hẽ waëë habëëh hẽnh mä Judah häj n'aa bä ta ky n'aa raher'ood hõm kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sahõnh hẽ ta ti maa new'ëë do panyyg hã, rahyb n'aa newëë, rahyb n'aa tón. Sa h'yyb gó m' raky hadoo: —Hyb n'aa jawyk da ta ti karapee —näk mä sa h'yyb gó. Tii da sa h'yyb gó rawén her'oot, P'op Hagä Do hejój karapee hã tabawät do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ti m' baad mä Sakarija h'yyb gó P'op Hagä Do Sahee badäng. Ti m' tadu doo tabaher'oot ta jawén hawät doo, P'op Hagä Do metëëh doo. Ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Taw'ããts hẽ Tak'ëp Hyb N'aa Jawyk Do hã, Isaraéw buuj rah'yy kaha'eeh do ër j'aa etsë. Tabahyng ta karapee tabed'ëëp hyb n'aa nesaa do mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","P'ooj ub, ta ky n'aa rod tsyt hẽ ta wë kasëëw bong do hã taky n'aa enooh doo, tii da P'op Hagä Do bad'oo hỹỹ kä. Tamejõ kän hỹỹ kä ër mahang tak'ëp ta hejój me ër hed'ëëp doo, ta karom Dawi makũ panaa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ër da ted'ëëp ër majĩĩ mahǟnh, ër wë h'yy gaẽẽnh do mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tat'yyd mehĩĩn paa ër wahë makũũh. Tahyb n'aa esee baad had'op do sa hã taky däng do paah, ");
INSERT INTO mbjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abaraãm makũũ hã taky n'aa enooh do paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ër ted'ëëp da ër majĩĩ mahǟnh, h'yyb neỹỹm doo me ër moo bok hyb n'aa P'op Hagä Do wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tsyt hẽ nesaa do mahǟnh, takarẽn doo da ër baboo had'yyt hyb n'aa ta matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ti m' ta t'aah hã Sakarija ky hadoo: —Õm da ramaneëënh P'op Hagä Doo, Sahõnh Hẽ Sa Bahǟnh Hadoo Do ky n'aa rod. Tak'ëp Hyb N'aa Jawyk Do kajaa do pooj jé panäg n'aa da õm. Õm da henäm sa h'yyb tym, baad ragadoo hyb n'aa takajaa bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","P'op Hagä Do karapee hã mamaher'oot da nyy da sa h'yyb tym tabed'ëëp hỹ pong jé ta pa rababoo had'yyt hyb n'aa, nesaa do sa h'yyb tym gó hanäng do tabawug hõm do hyb n'aa da. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tii da P'op Hagä Doo, ër h'yy kaha'eeh do wén d'oo, taky enyym do hyb n'aa. Ji tat'yyd mehĩĩn. Ti hyb n'aa Tah'yyb Däng Doo, ta bag hadoo ër hã, papỹỹj bag hadoo doo, p'op tabana ër hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ta bag tanoo da gadagyp do hadoo doo gó habok do sa hã, dajëb gó habok do sa hã. Ër hã tanoo da h'yyb nyyw gó ër babok hyb n'aa —näng mä Sakarija kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ti m' karapee bawëë gëët. H'yyb hejooj g'ëëd kän. Tabanawäng bä kä tabawäd had'yyt hẽ. Tii bä kä, tadu do kän tama metëëk do Isaraéw buuj. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti noo gó m', hajõng häj n'aa sa wahë n'aa Aw-Kus häd näng do tamejũũ rabetsén hyb n'aa sahõnh hẽ ta karapee jé pad'yyt hẽ habok doo, sa häj n'aa had'yyt bä habok doo, Roma buuj ramejũũ doo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jããm né hẽ ti pooj jé rabetsén doo. Kirinijo häd näng doo, hëëj Sirija häd näng do babuuj sa wahë n'aa noo gó m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tii bä m' sahõnh hẽ rabebanh sa wahë makũ panang p'aa hẽnh, ta heen n'aa hã sa häd raberih hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ti hyb n'aa m' panang Nasaréh, Garirej häj n'aa bä badäk doo bä naa Joséh ratsyym kasog kän, Judah häj n'aa hẽnh, panang Berẽnh häd näng doo hẽnh rabahõm hyb n'aa. Dawi häd näng do panang paa né hẽ m' ti Berẽnh. Dawi panaa see m' Joséh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","T'ĩĩ hẽnh tawén hõm mä Marija, ta ỹỹm pan'aa daheeh, retsén do heen n'aa hã sa häd raberih hyb n'aa m'. Etaah mä ti Marija. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta tii bä rabajeej bong noo gó kä m' karapee benyy däg kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ti m' pooj jé ta t'aah, aj'yy m'. Ti m' tabahabën däk. Ta wób sa masããh tób n'aa yt hã m', b'éé waa hood gó m' tadasooh. Du daa m' dawëë hena do tób ranu kahej'ëëk doo bä m', gabad'ẽẽ däk do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti noo gó kä m', atsëm, b'éé hagã n'aa rabaj'eenh p'eets hẽ. B'éé mä rahag'ããs. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ti m' P'op Hagä Do ããs kasee sa hã. Ti m' P'op Hagä Do hejój tametëëh sa pa. Ta bag tak'ëp gabarëëh do hadoo mäh. Ti m' b'éé hagã n'aa tak'ëp mä rabeỹỹm bong. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ti m' ããs ky hadoo sa hã: —Bë eỹỹm manäh! Ỹ manaa tak'ëp ji tsebé do panyyg, sahõnh hẽ panyyg pan'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","—Naga hẽ enyy däk bë mahang, Dawi panang paa bä, bë h'yyb tym dëëb. Kristo, P'op Hagä Do H'yyb Däng Doo, Tak'ëp Hyb N'aa Jawyk Do tii —näng mä ããs kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ti m' taky hadoo ẽnh: —Hahỹỹ da da bë heen n'aa: Bë aw'yyt da kahabën is karapee. B'éé waa hood gó da tabasooh —näng mä ããs kyyh b'éé hagã n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ti bä m' nayyw hẽ m' ragenä b'ëëh hajõk do ããs ta see pa. Tii bä m' P'op Hagä Do hã rama ejäm. Hahỹỹ da m' sa kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Taw'ããts hẽ hỹ pong jé tak'ëp raweh'ëëh, tak'ëp rahyb n'aa jew'yyk P'op Hagä Doo. Badäk hahỹỹ bä, ta hã habong do hã, takamahǟn do hã, P'op Hagä Do anoo da h'yyb näw n'aa —näk mä ããs sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ããs rabedo bong bä m', p'aa hẽnh hỹ pong jé rabasëëk bä m', b'éé hagã n'aa rakaner'ood kän, ti m' raky hadoo: —Hamäh, Berẽnh hẽnh ër hegãã ti P'op Hagä Do her'oot do ããs hã. Hamäh, hamäh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ti m' nayyw hẽ m' rah'yy kabawaad bong. Resoos mäh. Ti m' rabawyyd kän Joséh, Marija, karapee kä. Karapee basooh mä b'éé waa hood gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Karapee rabahapäh jawén paa bä kä m', jé pad'yyt mä rabaher'ood hõm karapee t'aah ky n'aa, sa hã ããs panäk doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sahõnh hẽ maa nap'ëëh do rameuunh mä ta ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ti m' Marija enyyw hõm mä ta ti ta h'yyb gó. Ta h'yyb gó m' tahyb n'aa newëë mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti m' b'éé hagã n'aa rababaaj hõm. P'op Hagä Do raky n'aa ejäm hõm mäh. P'op Hagä Do raj'aa etsë mäh. Ti rawén ky hadoo rahapäh mäh, ramaa napäh mä sa h'yyb. Baad né hẽ m', ããs her'oot doo d' né hẽ kä m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","8 ta ǟh tabahado däk bä m' karapee, ta masuuj noo byyh kahõg hõm bä kä m', rahäd n'oo däk mä Jesus, tabasuun däk do pooj jé ããs häd n'oo däk doo d' né hẽ ta häd karapee hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ti m' takaja kän mä ti noo gó Marija ta patug daheeh sa h'yyb rabenäm hyb n'aa P'op Hagä Do matym gó, Mosees ky n'aa jaw'yyk do mejũũ doo da ji t'aah benäng do jawén paa bä. Ti m' ramahũũm Jesus Jerusarẽnh hẽnh, P'op Hagä Do wë rametëëh hyb n'aa ta tób n'aa gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tii da rawén d'oo, hahỹỹ da m' P'op Hagä Do ky n'aa jaw'yyk do kerih do tamejũũ do hyb n'aa: “Taw'ããts hẽ pooj jé ji t'aah wah'ëëh ji ky n'aa enooh P'op Hagä Do hã tsyt hẽ.” ");
INSERT INTO mbjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","T'ĩĩ hẽnh rabahõm na-ããj hẽ, P'op Hagä Do hã rama ejuu hyb n'aa pawóp hẽ taw'ëëd, h'ooh its hadoo doo, gurii-i hadoo doo. Tii d' né hẽ ta ky n'aa jaw'yyk do mejũũ rabad'oo sa h'yyb rabenäm hyb n'aa P'op Hagä Do matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti m' ti awät mä Jerusarẽnh bä aj'yy wah'ëë däk doo, P'op Hagä Do karẽn doo da hawät doo, P'op Hagä Do ky n'aa jaw'yyk do ky daheeh doo. Simijãw mä ta häd. Baad mä P'op Hagä Do Sahee h'yyb mahũũm. Tagada mä Isaraéw buuj hed'ëëp doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","P'op Hagä Do Sahee metëëh mä ta hã, Kristo, P'op Hagä Do H'yyb Däng Doo, tahapäh nä né hẽ m' tadajëb pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ti m' ti noo gó né hẽ m' P'op Hagä Do Sahee mahũũm mä Simijãw P'op Hagä Do tób n'aa hẽnh. Ti m' P'op Hagä Do tób n'aa hẽnh Marija Joséh daheeh ramanaa bä m' karapee t'aats, Jesus, sa ky n'aa jaw'yyk do mejũũ doo da ramoo bok hyb n'aa ta hyb n'aa, ");
INSERT INTO mbjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ti agëët mä Simijãw tób w'oo hã. Ti m' karapee tabado däk ta moo gó, ti m' P'op Hagä Do taj'aa etsë. Hahỹỹ da m' ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Hỹỹ kä Tak'ëp Hyb N'aa Jawyk doo, sahõnh hẽ mabag'ããs doo, man'oo ỹỹh, a karom, h'yyb näm doo me ỹ dajëp. Man'oo däk maky däng do ỹ bahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hỹỹ kä matym ỹỹ me baad ỹ bahapäh ji h'yyb tym dëëb, ");
INSERT INTO mbjNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","sahõnh hẽ badäk hahỹỹ hã habong do sa matym gó manoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Judah buuj nadoo do sa h'yyb bag hadoo, sa h'yyb kadawuung n'aa P'op Hagä Do hã. Isaraéw buuj ky n'aa etsëëh da ta hyb n'aa —näng mä Simijãw kyyh karapee t'aah ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Marija Joséh daheeh rahyb n'aa meuuj bong mä Simijãw her'oot do sa t'aah ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ti m' Simijãw taky n'aa edëë bong sa hã. Ti m' Marija hã, Jesus ỹỹn hã, ta ky hadoo: —Hajõk Isaraéw buuj wób raty n'aa ges'yyk da hahỹ karapee tawah'ëë däk bä. Ti hyb n'aa banesaa hẽnh rabahõm da P'op Hagä Do an'oo bä. Ta wób da baad ragadoo. P'op Hagä Do ed'ëëp ta tii —näng mäh. —Ta heen n'aa hadoo da hahỹ karapee. Tametëëh da P'op Hagä Do gen'aak doo. Ti hyb n'aa hajõk da h'yy kawereem ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tii bä da kametä däk da rahyb n'aa newëë doo —näng mäh. —Õm da Marija, tak'ëp da mah'yy katón da ta hã ramoo bok do hyb n'aa da —näng mä Simijãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ti noo gó né hẽ m' ti agëët mä t'ĩĩ hẽnh ỹỹnh P'op Hagä Do ky n'aa rod. Ãn mä ta häd. Wah'ëë däg né m' tii. Panuéw mä ta yb makũ häd, Aseer makũ panaa see m'. Patug tamaa wäd, marahud wäd mäh. Raket'ëë däk do jawén paa bä, 7 ta baab tabahado däk bä m' Ãn patug maa badoo wät mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wah'ëë däk mäh. 84 däg mä ta baab n'aa. P'op Hagä Do tób n'aa hẽnh had'yyt mä tabeheh'ũũm. Adëb bä, atsëm na-ããj mä P'op Hagä Do tahyb n'aa jaw'yyk. Ta hã taky n'aa etsẽẽ mäh. Kas'aah mä taky n'aa etsẽẽ hyb n'aa P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti m' Marija, Joséh wë tabana bä m', taky n'aa tsebee wäd kän P'op Hagä Doo. Ti m' Jesus ky n'aa taher'ood kän t'ĩĩ hẽnh hab'ëëh do mahang Isaraéw buuj P'op Hagä Do ed'ëëp do gad'aa do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ti m' Joséh Marija rabahajaa bä kä m' sahõnh hẽ P'op Hagä Do ky n'aa jaw'yyk do mejũũ doo, rababaaj hõm kän sa panang hẽnh Nasaréh häd näng doo, Garirej häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Awëë däg kän mä karapee. Hejooj däg kän mäh. P'op Hagä Do h'yy gan'yyh. Baad P'op Hagä Do hag'ããs ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ta heen n'aa hẽ had'yyt hẽ Jesus ỹỹn ta patug daheeh rabahõm Jerusarẽnh hẽnh, Pas-kowa häd näng do ratab'ëës hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","12 m' Jesus ta baab däg rabahõm Pas-kowa ratab'ëës hyb n'aa rabahed'oo doo da. Jesus ahõm sa sii. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pas-kowa ratab'ëës do tabahëëj jëng bä m', rababaaj nä sa panang hẽnh. Jesus mä aym Jerusarẽnh bä. Dooh m' rahapëë bä ta ỹỹn hã tabaym. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sa wakããn mahang hawät red'oo mäh. Ti m' tug bä kä rabaheg'ããs, dooh m' Jesus. Resoos mä sa wakããn mahang. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dooh m' rawyyd bä. Ti m' rabaheg'ããs p'aa hẽnh Jerusarẽnh hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tamawoob däg kän mä sa ǟh Pas-kowa jawén paa bä m', rabawyyd kän P'op Hagä Do tób n'aa yt hã m'. Mosees ky n'aa jaw'yyk do ma mehetëk do mahang mä tabasooh. Tamaa newëë mäh, teaanh mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sahõnh hẽ Jesus maa napäh do rahyb n'aa meuunh mä tahapäh do hã m', tah'yy ganäng do hã m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti m' ta ỹỹn ta patug daheeh rabahapäh bä m' rah'yy gabedo bong mäh. Ti m' ta ỹỹn ky hadoo: —Hëd n'aa tii d' mabahadoo ãã hã, tah ỹỹ? —näng mäh. —Õm ãã esoos, õm ãã hyb n'aa tón —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ti m' Jesus ky hadoo: —Hëd n'aa ỹ bë esoos? Nepäh bë hã Ee tób bä né paawä ti ỹ bë baw'yyt? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dooh m' ta ỹỹn rah'yy genä bä tii d' tahanäng do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ti m' tababaaj hõm kän sa sii. Baad mä taky daheeh sa hã. Baad mä Marija benäm ta ti ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Awëë gëët mä Jesus. Anäng mä ta hã kä tahapäh doo. P'op Hagä Do kamahǟn ta hã, ta wób na-ããj rakamahǟn. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ti m' 15 ta baab tabahado däk bä m' Tiberijo häd näng do Roma bä tabag'ããs noo gó, tabanawäng hẽnh P'op Hagä Do ban'oo kän mä ta panyyg Jowãw hã, ta wób tamaher'oot hyb n'aa. Sakarija m' Jowãw yb. Ti noo gó, Judah häj n'aa bä Pon-Sijo Pirato häd näng do sa wahë n'aa. Garirej häj n'aa bä, Eróts häd näng do sa wahë n'aa. Eróts hỹỹj mä Pirip häd näng doo, Itureej, Tarakonit häd enäh do häj n'aa bä m' sa wahë n'aa. Risããn häd näng doo, Abirẽn häj n'aa bä sa wahë n'aa. Anas, Kajapas häd enäh doo, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do ti noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ti m', P'op Hagä Do panyyg Jowãw gado däk jawén paa bä kä m', tamaher'ood hõm mä sahõnh hẽ tamii Joradãn nabyy me habong doo. Taher'oot sa hã raberéd hõm hyb n'aa nesaa doo, ranu kemuun hõm hyb n'aa nesaa do raberéd hõm do heen n'aa, P'op Hagä Do awug hõm hyb n'aa nesaa do sa h'yyb tym gó hanäng doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hahỹỹ da P'op Hagä Do ky n'aa rod Isajas häd näng do erih do paa Jowãw ky n'aa: “Hahỹỹ da tabanawäng bä her'oot do kyyh: Bë tyw n'aa bak'ood däg da Tak'ëp Hyb N'aa Jawyk Doo. Baad ub da bë tyw n'aa daj'aah. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bë geh'aa hõm gaderoh doo. Bë epug hõm wajau doo, waëë na-ããj hẽ. Bë deja hõm ta tyw n'aa gajeroh doo. Bë benyyw däg baad ta tyw n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tii bä da sahõnh hẽ badäk hahỹỹ hã habong do rahapäh da nyy da P'op Hagä Do ji tabed'ëëp nesaa do mahǟnh.” ");
INSERT INTO mbjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ti m' hajõk rakata däk Jowãw wë ranu kemuun hyb n'aa. Ti m' Jowãw ky hadoo sa hã: —Aw'yy p'yym näng do taah hadoo bëëh! —näng mäh. —Nyy da bë ed'oo bë kejën nesaa do bë hã P'op Hagä Do banoo do mahǟnh? J'ooj madäk doo me bë ed'oo bë nu kemuun nesaa do mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Taw'ããts hẽ pooj jé bë metäh te hub tado bä nesaa do bë eréd hõm bä. Bë metäh hanäm do hã bë moo bok do hã. Bë daab yb manä Abaraãm panaa bë hanäk do hã. Bë edoo manäh: “Ãã P'op Hagä Do gadoo Abaraãm panaa ãã bahadoo do hyb n'aa.” P'op Hagä Do karẽn bä, tahajaa hahỹ pä tawareem bä Abaraãm panaa rado padäg bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Edaa däk h'yy kawanereem do P'op Hagä Do ky n'aa etyy doo. Aj'yy myym joom kóm pa tadahëë däk do tabagëëm hyb n'aa hadoo tii. Sahõnh hẽ joom tëëg neaak do tagëëw jat da, ti tabaju hõm da —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ti m' rabeaanh ta hã: —Nyy d' ãã bad'oo hỹỹ kä? ");
INSERT INTO mbjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ti m' Jowãw ky hadoo: —Pawóp hẽ saroor näng péh, sét tanoo saroor tamah pé hã. Waa näng doo, tanoo waa tamah do waa ta waa uuh —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ti m' sa wahë n'aa dajẽẽr n'aa gedaag n'aa an'aa mä Jowãw wë tanu gemuun hyb n'aa. —Ma matëg —näk mäh. —Ãã ẽnh, nyy d' ãã bad'oo? ");
INSERT INTO mbjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ti m' Jowãw ky hadoo sa hã: —Bë wad'ii manä ta wób —näng mäh. —Dooh ta bahǟnh bë ets'ẽẽ sa hã dajẽẽr. Jããm hẽ bë ets'ẽẽ Roma buuj ky kajäk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ti m' warahén reaanh: —Ãã ẽnh? Nyy d' ãã bad'oo? —näk mä warahén sa kyyh. Ti m' Jowãw ky hadoo: —Bë eǟm manä ta wób dajẽẽr rabanoo hyb n'aa bë hã. Bë ky n'aa tapa manä daap hẽ ta wób. Bë h'yy gadeja dajẽẽr bë wahë n'aa bë hã rep'aak do hã, bë hyb n'aa hũũm manä ti bahǟnh —näng mä Jowãw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ti m' hajõk do t'ĩĩ hẽnh kat'aa do rah'yy kahas'ããp Jowãw hyb n'aa. Sa h'yyb gó m' rahyb n'aa newëë. Sa h'yyb gó m' raky hadoo: “Hahỹ né g'eeh P'op Hagä Do H'yyb Däng Doo, Kristo häd näng doo?” ");
INSERT INTO mbjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ti m' Jowãw ky hadoo sa hã: —Ỹ ti hỹỹh, bë ỹ nu gemuun naëng me. Ti awät da tak'ëp hyb n'aa jawyk do bahǟnh ỹỹ. Hã ỹỹ, ỹ hyb n'aa sakog its ta hã. Ti hyb n'aa dooh ỹ haja bä ta tsyym suun kabo n'aa ỹ do bä —näng mäh. —Tii kä P'op Hagä Do Sahee tabanoo da bë hã, tabajëë suun hyb n'aa bë h'yyb tym gó, bë tah'yyb mahũũm hyb n'aa. Tëëg hõõ hadoo me baad tabanäw däk bë h'yyb tym, bë d' tametyy —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tsyt hẽ tabetyn hõm da P'op Hagä Do karẽn do moo heb'ook doo, tsyt hẽ ta wób. P'op Hagä Do karẽn do moo b'ook doo, banäm doo hẽnh tabetyn hõm, tabanesaa hẽnh ta wób, aj'yy ta nahëë me tetyn hõm do hadoo tiriig ta bóg mahǟnh. Ta joom ag tiriig tabataa ta tób n'aa yt hã. Ta bóg taju toonh tëëg hõõ me, nadëëk doo me —näng mä Jowãw kyyh Kristo ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hajõng mä Jowãw her'oot sa hã. Panyyg wób gó tabeh'ũũm. Baad tametëëk sa hã. Panyyg hanäm do taher'oot mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ti m' Jowãw nabuuj gedoo mä Garirej häj n'aa wahë n'aa Eróts häd näng doo, ta hỹỹj ỹỹm, Erodija, tagat'ëë däk do hyb n'aa. Hajõng baad nadoo do wób Eróts moo wät do hyb n'aa na-ããj hẽ Jowãw nabuuj gedoo mä Eróts. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ti m' ti bahǟnh tabegyyts wät. Tamejũũ mä Jowãw radawäts gëët ragadahew'ëës doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ti m' ragadahew'ëës doo gó radawäts g'ëëd pooj jé m', hajõk do Jowãw nu gemuun bong bä m', Jesus na-ããj mä tanu gemuun wät. Tanu gemuun bä m', Jesus ky n'aa etsẽẽ bä m', wë kabasëëts wät. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ti m' P'op Hagä Do Sahee ahyng mä ta wë gurii-i hadoo mäh. Ti m' hỹ pong jé naa tamaa ena kän P'op Hagä Do kyyh. Hahỹỹ da m' ta kyyh: —Õm tah ỹỹ, tak'ëp ỹ kamahǟn up doo. Baad ỹ mah'yyb n'yym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","30 ta baab Jesus bahado däk bä m' tadu doo tamoo wät do sa mahang. Joséh t'aah red'oo mä Jesus. Joséh yb makũ häd Eri. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eri yb makũ häd Matat. Matat yb makũ häd Rewi. Rewi yb makũ häd Mew-Ki. Mew-Ki yb makũ häd Janaj. Janaj yb makũ häd Joséh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséh yb makũ häd Matatijas. Matatijas yb makũ häd Amos. Amos yb makũ häd Naũm. Naũm yb makũ häd Eseri. Eseri yb makũ häd Nakaj. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaj yb makũ häd Maat. Maat yb makũ häd Matatijas. Matatijas yb makũ häd Semej. Semej yb makũ häd Josek. Josek yb makũ häd Jodah. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodah yb makũ häd Jowanan. Jowanan yb makũ häd Resa. Resa yb makũ häd Serubab. Serubab yb makũ häd Saratijéw. Saratijéw yb makũ häd Neri. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yb makũ häd Mew-Ki. Mew-Ki yb makũ häd Adih. Adih yb makũ häd Kosãn. Kosãn yb makũ häd Ew-Madãn. Ew-Madãn yb makũ häd Eer. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eer yb makũ häd Josuwéh. Josuwéh yb makũ häd Erijés. Erijés yb makũ häd Jorĩm. Jorĩm yb makũ häd Matat. Matat yb makũ häd Rewi. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rewi yb makũ häd Simijãw. Simijãw yb makũ häd Judah. Judah yb makũ häd Joséh. Joséh yb makũ häd Jonam. Jonam yb makũ häd Erijakĩm. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Erijakĩm yb makũ häd Mereja. Mereja yb makũ häd Mena. Mena yb makũ häd Matatah. Matatah yb makũ häd Natãn. Natãn yb makũ häd Dawi. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawi yb makũ häd Jesé. Jesé yb makũ häd Obed. Obed yb makũ häd Buwas. Buwas yb makũ häd Saramon. Saramon yb makũ häd Nasõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasõm yb makũ häd Aminadab. Aminadab yb makũ häd Adimih. Adimih yb makũ häd Rãm. Rãm yb makũ häd Eserõm. Eserõm yb makũ häd Peres. Peres yb makũ häd Judah. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah yb makũ häd Jakóh. Jakóh yb makũ häd Isak. Isak yb makũ häd Abaraãm. Abaraãm yb makũ häd Terah. Terah yb makũ häd Nahóh. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahóh yb makũ häd Serug. Serug yb makũ häd Rakaw. Rakaw yb makũ häd Pereg. Pereg yb makũ häd Eber. Eber yb makũ häd Serah. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Serah yb makũ häd Kaj-Nan. Kaj-Nan yb makũ häd Apasad. Apasad yb makũ häd Sẽm. Sẽm yb makũ häd Nowéh. Nowéh yb makũ häd Ramék. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramék yb makũ häd Metusarẽm. Metusarẽm yb makũ häd Enók. Enók yb makũ häd Jaréd. Jaréd yb makũ häd Marareew. Marareew yb makũ häd Kenan. ");
INSERT INTO mbjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan yb makũ häd Enós. Enós yb makũ häd Seet. Seet yb makũ häd Adãw. P'op Hagä Do t'aah hadoo Adãw makũũh, P'op Hagä Do pahuunh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ti m' Jesus basoop pong hẽnh tamii Joradãn häd doo me naa. Baad mä P'op Hagä Do Sahee h'yyb mahũũm. Ti m' P'op Hagä Do Sahee mahũũm kän Jesus tabanawäng hẽnh, rabanabok hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","40 m' ta ǟh Dijab metyy mä Jesus. Tabanawäng hẽnh tabaym bä, dooh Jesus awa bä. 40 ta ǟh tabahado däk bä m' Jesus mä asa däk tak'ëp. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ti m' Dijab ky hadoo ta hã: —P'op Hagä Do T'aah mado bä, mamejõ hahỹ pä takawareem däk pãw —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ti m' Jesus ky hadoo: —Dooh. Hahỹỹ da P'op Hagä Do kyy kerih doo: “Ji waa hã had'yyt nado ji bedëp” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ti m' Jesus Dijab masäk waëë jó. Tii b' naa m' nayyw hẽ tametëëh ta hã sahõnh hẽ badäk hahỹỹ hã hanäng do häj n'aa rabag'ããs doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ti m' taky hadoo ta hã: —Mahegãã! —näng mäh. —Sahõnh hẽ ta ti ỹ anoo da a hã. Sa wahë wahëh mabahadoo ỹ an'oo bä. Sahõnh hẽ hanäm doo, hetsooh do ta hã hanäng do ỹ anoo da a hã —näng mäh. —Ỹ ti ta ti gadoo. Ỹ ta danäh. Ti hyb n'aa ỹ anoo ỹ karẽn pé hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","—Sahõnh hẽ ỹ banoo a hã, wë ỹỹ, tũũ, a taron nuu me ỹ mawehëë bä —näng mä Dijab kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ti m' Jesus ky hadoo: —Hahỹỹ da P'op Hagä Do kyy kerih doo: “Jããm hẽ P'op Hagä Doo, bë hagã n'aa, bë wehëë. Jããm hẽ ta ti bë hyb n'aa jew'yyk, bë ky daheeh” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ti m' Jesus Dijab mahũũm kän Jerusarẽnh hẽnh. Ti m' tabatsyyd hõm P'op Hagä Do tób n'aa jó p'op nu däk doo hẽnh tabasëëk hyb n'aa. Ti m' taky hadoo: —P'op Hagä Do T'aah mado bä, —näng mäh —keréd hyy tũũ babä naa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hahỹỹ da P'op Hagä Do kyy kerih doo —näng mä Dijab kyyh: “P'op Hagä Do mejũũ da ta ããs baad õm rabahag'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Õm da ragadoo p'op pä hã a tsyym taganadas hyb n'aa”, näng P'op Hagä Do kyyh —näng mä Dijab. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ti m' Jesus ky gadoo: —Hahỹỹ da na-ããj hẽ P'op Hagä Do kyy kerih doo: “Mamety manä P'op Hagä Doo, a hagã n'aa” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ti m' Dijab bahajaa bä kä Jesus tametyy doo, tabahõm dó Jesus mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ti m' Garirej häj n'aa hẽnh Jesus babaaj hõm kän. Baad mä P'op Hagä Do Sahee h'yyb mahũũm mä Jesus. Jé pad'yyt hẽ Garirej häj n'aa bä rapanyyg enä hõm kän mä ta ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tób P'op Hagä Do panyyg rayd naherot do yt hã tama metëëk mäh. Sahõnh hẽ m' raj'aa etsë ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ti m' panang Nasaréh hẽnh tabahõm, tabawäng do paa hẽnh. Saab hã kä m' tabahõm tób P'op Hagä Do panyyg rayd naherot doo hẽnh, tabehed'oo doo da. Ti m' tabas'ëëg gëët P'op Hagä Do kyy kerih do taner'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ran'oo däk mä ta hã P'op Hagä Do ky n'aa rod, Isajas makũ erii wät do paah, ta heen n'aa. Kapõõs mä ta ti ma kahé bäh. Tii b' mä tabapyn, taw'yyt mä ta hã kerih doo. Hahỹỹ da m' takerih: ");
INSERT INTO mbjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hã ỹ P'op Hagä Do Sahee banäng. Ỹ tasëëw hõm tsyt hẽ, P'op Hagä Do Panyyg Hanäm Do kasuud is do sa hã ỹ maher'oot hyb n'aa. Ỹ tamejũũ ỹ bed'ëëp hyb n'aa ta wób moo gó naa. Ỹ tamejũũ ty temah do ỹ matym nä padëëk hyb n'aa. Ỹ tamejũũ tak'ëp rarejãã do ỹ bed'ëëp hyb n'aa sa moo gó naa, rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ỹ tamejũũ hahỹỹ da ỹ maher'oot hyb n'aa sahõnh hẽ sa hã: Kaja kän P'op Hagä Do ji tat'yyd mehĩĩn doo.” ");
INSERT INTO mbjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ti m' tabahëëj jëng bä taner'oot doo, tap'õõj däk mä p'aa hẽnh kerih doo. Tan'oo däk mä p'aa hẽnh tób kaser n'aa hã. Sahõnh hẽ m' tii b' hat'oonh do baad mä rabahag'ããs Jesus wë. Ragada mä taber'oot. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ti m' taky hadoo: —Naga hẽ, bë hapëë kän tadu dahëë kän kerih do ỹ ner'ood wät doo kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ti m' sahõnh hẽ tii b' hat'oonh do baad mä raj'aa etsë ta hã. Rahyb n'aa meuunh mä baad taher'oot do hã. Ti m' rakaner'oot jé hat'oonh doo. Hahỹỹ da m' sa kyyh: —Nyy d' tii éh? Joséh t'aah nado ti hỹỹh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti m' Jesus ky hadoo sa hã: —Ỹ hapäh né tii, hahỹỹ da bë kyyh bë ky hetëg hã: “A daaj hẽ makebiin mediko mado bä”, näk da bëëh —näng mäh. —Hahỹỹ da d' bë kyyh: “Taw'ããts hẽ mamoo wäd meuj n'aa näng doo, babä, a panang bä, Kapar-Naũm bä mapahuunh doo da, ãã ky n'aa napäh doo da raher'oot doo”, näk da bëëh —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ti m' taky hadoo ẽnh sa hã: —Ta panang bä, tabawäng doo bä, dooh P'op Hagä Do ky n'aa rod ragado bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eriij hawät noo gó m', hajõk mä Isaraéw häj n'aa bä patug tema bong do kas'uut doo, tak'ëp sahõnh hẽ rabas'aah noo gó m', tamawoob hẽ ta baab bahǟnh tanadots wät do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ti hadoo né hẽ m', dooh m' P'op Hagä Do mejõ bä Eriij sa wë tamasa hyb n'aa. Tamejũũ ta s'ee hẽnh ỹỹnh patug tamah do bawät bä. Panang Sarep-Ta häd näng doo bä tabawät. Häj n'aa Sidõn häd näng doo bä tii. Baad mä tamasa tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta jawén mäh, P'op Hagä Do ky n'aa rod seeh, Erisew häd näng do hawät noo gó m', hajõk mä nahëë enäh doo, rog manahuuh do Isaraéw häj n'aa bä. Ti hadoo né hẽ m', dooh m' sa nahëë Erisew ado hõm bä. Jããm né m' sét hẽ tanahëë do hõm, Namah häd näng doo. Sirija häd näng do buuj mä tii —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ti m' tii b' hat'oonh do ramaa napäh bä m', tak'ëp mä rakawaj'ããn kän ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","P'op mä rabes'ëëg b'ëëh. Kawaj'ããn gó m' Jesus ramahũũm panang bä naa, p'op tabadoo hẽnh. Gadarong doo gó m' rakarẽn radawäts hyy paawä tadajëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ti m' Jesus bahõm sa mahǟnh, sa mahang mä tatabës. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ti m' Jesus bahyng panang Kapar-Naũm häd näng doo hẽnh, häj n'aa Garirej häd näng doo bä. Ti m' Saab hã kä tadu doo tama metëëk sa hã P'op Hagä Do panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ti m' maa new'ëë do rahyb n'aa meuunh mäh. Rawén meuuj bong mäh, hyb n'aa jawyk do ky n'aa me tama metëëk do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti m' tób P'op Hagä Do panyyg rayd naherot doo gó m' tabasooh aj'yy karap'aar h'yyb nesaa doo, mera doo. Ti m' tak'ëp mä ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ej! H'ëëd makarẽn ãã wë Jesus Nasaréh buuj? Ãã marejãã mawén na! —näng mäh. —Ỹ hapäh õm baad ub. Õm P'op Hagä Do hanaa, tak'ëp hanäm doo, baad hadoo do moo wëëd õm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ti m' Jesus geǟm wät karap'aar h'yyb nesaa do ta hã hadäk doo. Ti m' taky hadoo: —Er'ood manäh! Bag hẽnh! Ahõm aj'yy mahǟnh —tah'eed hõm mäh. Tii bä m' aj'yy karap'aar h'yyb nesaa do dawäts jat tũũ sahõnh hẽ sa matym gó. Ti m' karap'aar h'yyb nesaa do bahõm kän, ta hã hadäk do paah. Tabanyyh bä dooh tarejã bä aj'yy. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ti m' tii bä kata b'ëëh do rameuuj bong mäh, raky n'aa jõg bong mäh. Ti m' raky hadoo: —H'ëëd pé ti tama metëëk hahỹỹ hã? Hyb n'aa jawyk doo me, hejoonh doo me tamejũũ karap'aar h'yyb nesaa do rabanyyh hyb n'aa. Raky daheeh né hẽ —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ti hyb n'aa m' dawëë Jesus ky n'aa däg däk Garirej häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tii kä m' Jesus banyyh tób P'op Hagä Do panyyg rayd naherot doo bä naa. Simaw tób hẽnh mä tabahõm. Ti m' Simaw mayyn asooh mäh. Tak'ëp oom ta hã. Ti m' Jesus hã rabaher'oot tamasa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ti m' p'eets hẽ tabana gëët Simaw mayyn hasooh hẽnh. Tameduuk mä oom keréd hõm hyb n'aa. Ti m' oom keréd hõm. Nayyw hẽ m' Peed mayyn moo wäd däk sa waa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ti noo gó né hẽ, tug bä kä m', papỹỹj badëë hyng bä kä m', Saab bahëëj jëng jawén paa bä, Kapar-Naũm buuj ramenaa sahõnh hẽ nahëë enäh doo. Hajõk mä sa nahëëh. Ti m' sét ken'yyh hã tamoo däng. Sa nahëë tahehëën hõm mäh. Ahub padëëk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Karap'aar h'yyb nesaa doo, ta wób sa hã hanäng do enä kän mä sa hã hanäng do paah. Raban'yyh bä m' tak'ëp mä sa kyyh: —P'op Hagä Do T'aah né hẽ õm —näk mä karap'aar sa kyyh. Ti m' Jesus ky ge'ỹỹm mäh. Dooh m' Jesus an'oo bä karap'aar h'yyb nesaa do rer'ood bä, rahapäh do hyb n'aa m', Jesus ta ti Kristo P'op Hagä Do H'yyb Däng Doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ti m' jati pé tapaj'ëë bä, Jesus bahõm dawë hã, rabanabok hẽnh. Ti m' Jesus rabesoos jé pad'yyt hẽ. Ti m' Jesus ramamuun bä kä m' retsẽẽ ta hã sa panang bä tabaym hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ti m' taky hadoo sa hã: —P'op Hagä Do bag'ããs do ky n'aa hanäm do ỹ karẽn ỹ her'oot panang wób hẽnh na-ããj né hẽ. Ti hyb n'aa ỹ P'op Hagä Do mejõ hyng —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ti m' tób P'op Hagä Do panyyg rayd naherot do yt hã m', sahõnh hẽ Judah häj n'aa panang bä tama met'ëëg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ti m' ta see pé noo gó m' karaj'aa Genesaréh häd näng do nabyy me Jesus ma metëëk. Hajõk doo, P'op Hagä Do ky n'aa maa new'ëë doo, gatat'uuk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ti m' pawóp hẽ marakate tabahapäh ta nabyy me, tah'ỹỹb h'oo n'aa. Karahi rahets'yyt mä marakate danäh hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ti m' tagatsëg sooh marakate see gó. Simaw mä marakate danäh. Ti m' tabetsẽẽ taũũj hõm hyb n'aa dawë hã marakate. Tii b' naa m' tama met'ëëg kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ti m' tabahajaa bä kä tama metëëk doo, tamejũũ Simaw tabadajong hẽnh marakate t'ĩĩ hẽnh radatu hyb n'aa tah'ỹỹb nahëëh. —T'ĩĩ hẽnh bë mo haj'aa enäh da —näng mä Jesus Simaw hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ti m' Simaw ky hadoo: —Wahëh ỹỹ, —näng mäh —atsëm had'yyt hẽ ãã baboo paawä, dooh ãã mo haj'aa péh. Ti hadoo né hẽ, mamejũũ do hyb n'aa ỹ datu p'aa hẽnh karahi —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ti m' tii d' rabad'oo bä kä m', hajõng mä tah'ỹỹb karahi gó. Tak'ëp hajõng do hyb n'aa karahi gekog bong. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ti m' marakate see gó hat'oonh do ranaëënh ramasa hyb n'aa. Ti m' tah'ỹỹb rabata tooj kän marakate gó. Pawóp hẽ marakate gad'ẽẽ däk mäh. P'eets hẽ paawä m' tabagyyb paawä marakate tah'ỹỹb jawyg hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ti m' Simaw Peed bahapäh bä m' Jesus ky haj'aa, ta taron nu paa me tabahyy häng mä Jesus wë. Ti m' taky hadoo: —Ahõm mahǟnh ỹỹ, wahë ỹỹ. Dooh ỹ haja bä a matym gó ỹ ag'ëëd bä, nesaa do moo hew'ëët do hyb n'aa ỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simaw ta hataa daheeh rameuuj bong mä hajõng do hyb n'aa tah'ỹỹb. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedew taah, Tsijaag, Jowãw häd enäh doo, Simaw kanatëë, ti na-ããj mä rameuuj bong. Ti m' Jesus ky hadoo Simaw hã: —Eỹỹm manäh —näng mäh. —Ajyy, ỹỹj sag hadoo da õm hỹỹ kä, P'op Hagä Do hã rah'yy ka'eeh hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ti m' hood jó kä ratakyg jat marakate kä. Sahõnh hẽ raberéd hõm. Ah'ũũm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ti m' panang s'ee hẽnh Jesus mamuun mä aj'yy rog manahuuh do hanäng doo. Tak'ëp mä ta hã däg ta rog. Jesus tabahapäh bä m', ahyy häng mä tũũ, tetsẽẽ mä Jesus bado hõm hyb n'aa ta nahëëh: —Tak'ëp Hyb N'aa Jawyk Doo, —näng mäh —makarẽn bä mahajaa né hẽ nahäh ỹ mado hõm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ti m' Jesus moo däg ta hã. Ti m' taky hadoo: —Ej. Ỹ karẽn —näng mäh. —Has'oo däg! —näng mä ta kyyh. Ti m' nayyw hẽ kä m' ta nahëë badoo wät. Has'oo däg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ti m' Jesus baher'oot ta hã: —Maher'ood manä ta wób sa hã —näng mäh. —Ahõm jajé naga hẽ P'op Hagä Do tób n'aa yt hã moo wät do wë. Mametä ta hã õm has'oo däk doo. Mamoo wäd Mosees mejũũ do paah, ta ti hedoo pé ji nahëë badoo wät do heen n'aa, p'aa hẽnh baad mabahadoo hyb n'aa P'op Hagä Do matym gó, baad sahõnh hẽ rabahapäh hyb n'aa õm has'oo däk doo —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ti m' Jesus mejõ né paawä m' ta wób tamanaher'oot hyb n'aa, jé pad'yyt hẽ nayyw hẽ rapanyyg enä hõm mä Jesus ky n'aa hã. Ti hyb n'aa m' hajõk han'aa ta wë ramaa newëë hyb n'aa tama metëëk doo. Ta wób nahëë enäh do na-ããj hẽ an'aa ta wë tabaheso hõm hyb n'aa sa nahëëh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ti m' Jesus, ta see pé noo gó, tabehũũm takabanawät hẽnh taky n'aa etsẽẽ hyb n'aa P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hỹ hadoo mäh, ta see pé noo gó, tób gó Jesus ma metëëk bä kä, Pariséw ramaneëënh doo, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj mäh, ti at'oonh mä maa new'ëë do sa mahang. Jé pad'yyt hẽ naa rabena. Garirej, Judah häd enäh do häj n'aa bä naa rabana. Jerusarẽnh hẽnh naa ta wób rabana. Baad ub P'op Hagä Do hejój Jesus h'yyb gó tabawät nahëë enäh do sa nahëë tawén do hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ti m' ajyy wób ramanaa mä nahëë näng doo, nawät doo. Ratóg nä ta tyng jó. Rakarẽn paawä m' ramajëë suun tób gó Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Du daa m' rakad'oo pé gatag'uu däk do hyb n'aa m' hajõk doo. Ti m' p'op ramasäk. Ratyw n'aa gas'ëës mäh, ti m' tii b' naa m' ramahy kän kata däk do mahang Jesus bagëët bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ti m' Jesus h'yyb hapäh bä m' hat'ook do rah'yy ka'eeh do ta hã, nawät do hã taky hadoo: —Najis ỹỹ —näng mäh. —Nesaa do a h'yyb tym gó hanäng kado hõm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ti m' Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ raky hadoo sa h'yyb gó: —Nyy d' mä hỹ ta hã! —näk mäh. —P'op Hagä Do taky n'aa rejãã hahỹỹ hã. Jããm né hẽ P'op Hagä Do hajaa nesaa do ji h'yyb tym gó hanäng do tado hõm bä —näk mä sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus h'yyb hap'ëëh mä sa h'yyb. Ti hyb n'aa m' tabeaanh sa hã: —Hëd n'aa tii da bë hyb n'aa newëë bë h'yyb gó? —näng mäh. —Bë ỹ h'yyb hapäh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Nyy da nahejooj bë hã? “Kado hõm nesaa do a h'yyb tym gó hanäng do paah”, ji noo bä? “As'ëëg g'ëëd, awäd däg”, ji noo bä? —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ti m' taky hadoo ẽnh sa hã: —Hỹỹ kä da —näng mäh. —Bë bahapäh hyb n'aa ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ hajaa sa hã hanäng do nesaa do ỹ ado hõm bä, ỹ haso däk da nahëë näng doo —näng mä Jesus kyyh. Tii bä m' k'yy gadów däk do hã taky hadoo: —As'ëëg g'ëëd, mado däg a tyng, ahõm kä a tób hẽnh —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti m' nayyw hẽ kä tabas'ëëg g'ëëd kän, tabado däk ta tyng kä, ahõm kän sahõnh hẽ m' rabahapëë kän. P'op Hagä Do hã taj'aa etsë mä tababaaj hõm bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sahõnh hẽ hap'ëëh do rameuuj bong mäh. P'op Hagä Do hã m' raj'aa etsë. Ti m' rah'yyb e'ỹỹm bong. Ti m' raky hadoo: —Meuj n'aa näng do ãã hapäh naga hẽ —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ti m' ta jawén Jesus bahõm bä kä panang bä naa, taw'yyt mä Rewi häd näng doo. Roma buuj ky gabuuj dajẽẽr ragahed'aak bä m' tabasooh. Ti m' Jesus ky hadoo ta hã: —B'ëëp ana wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ti m' Rewi bas'ëëg gëët, sahõnh mä taberéd hõm, ti m' ahõm kän mä ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ti m' Rewi moo wät mä ta tób bä sa tä, sa waa Jesus tatsebé do ky n'aa, Jesus taweh'ëëh do ky n'aa. Hajõk dajẽẽr gahed'aak doo, Rewi hep'ëëh doo, ta wób na-ããj mä tatsyyd bong do rabana rabawa hyb n'aa ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ti m' Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do Pariséw wób hedoo doo, hãd kawaj'ããn gó m' rabeaanh Jesus ma matëg sa hã: —Hëd n'aa bë bawëh, bë beëëk dajẽẽr gahed'aak do sa sii, ta wób na-ããj hẽ nesaa do moo heb'ooh do sa sii? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti m' Jesus ky hadoo sa hã: —Nahëë temah doo, dooh rahõm bä mediko wë. Nahëë enäh do ti hah'ũũm ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dooh ỹ ahyy bä hỹ pong jé naa P'op Hagä Do karẽn doo da habok red'oo do ỹ naëënh hyb n'aa. Ỹ ahyng, nesaa do moo heb'ooh do ỹ naëënh hyb n'aa, nesaa do raberéd hõm hyb n'aa, P'op Hagä Do hã rah'yy ka'eeh hyb n'aa kä —näng mä Jesus kyyh, Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ti m' h'yy gaẽẽj gó raky hadoo ta hã: —Jowãw nu gahem'uun do ma matëg ranawa P'op Hagä Do rahyb n'aa esee do heen n'aa, P'op Hagä Do hã raky n'aa etsẽẽ. Tii da na-ããj hẽ Pariséw ma matëg rabad'oo. Tii d' nado a ma matëg. Ti rawa had'yyt hẽ. Reëg had'yyt hẽ —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti m' panyyg ky n'aa gó Jesus ky gadoo. Hahỹỹ d' mä ta kyyh: —Ket'ëë do jäm n'aa hẽnh ji ats'yyt doo, dooh tahaja bä ji mejõ bä ratabëëj bä ranoo kanawa do heen n'aa ta patug pan'aa sa mahang tag'ëëd bä. Jäm bawät nä bä ji ats'yyt do rawëë had'yyt hẽ. Dooh ratay bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ti awät da sa najiis, ta patug pan'aa, rado hõm sa mahǟnh. Ti noo gó da ratay kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ti m' panyyg see ky n'aa gó taky hadoo: —Dooh ji as'ẽẽd bä ji saroor papuuj bäh ta säg hã ji gasyyp hyb n'aa. Tii d' ji adoo bä ji rejãã ji saroor papuuj. Papuuj bäh dooh baad tado bä saroor säg hã —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Ti hadoo né hẽ uwa bëëh hã. Dooh ji gedu bä uwa bëëh papuuj hegän sooh do pan'aa ta hood b'éé byy säg gó. Tii d' ji adoo bä, uwa bëëh egän so bä, ta hood säg ganabäh hõm. Tii bä kä, uwa bëë waho bëëh da, ta hood kä karejã kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","—Uwa bëëh papuuj ji geduuh ta hood papuuj gó, keh'ũũs doo gó —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ti m' taky hadoo ẽnh ta see ky n'aa gó: —Jé uwa bëëh mahỹỹnh do hajõõ ta baab haso däk do heëëk doo, papuuj dooh tagenaag bä. “Taw'ããts hẽ pooj näh”, näk sa kyyh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hỹ hadoo mä Saab, Judah buuj rakamehehãk do noo gó, Jesus ta ma matëg sa sii joom tiriig banäng doo me m' ratabës. Ramahõm me m', ta ma matëg tiriig ag mä raberik ta byyh banyyh hyb n'aa, tiriig rabawa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ti m' Pariséw sa sii habok do raky hadoo sa hã: —Hëd n'aa bë ky nadaheeh ër ky n'aa jaw'yyk do Saab ky n'aa hã? Saab hã bë moo bok —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ti m' Jesus ky hadoo sa hã: —Dooh bë ner'ood bä g'eeh nyy da ër wahë makũ Dawi bad'oo, tii, ta hataa rabas'aah bä? ");
INSERT INTO mbjNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawi ajëë suun P'op Hagä Do sa hã kahesé do tób n'aa yt hã, ti m' tabadoo pãw P'op Hagä Do sa hã kahesé do tób n'aa yt hã hatoonh doo, ti m' tabawa. Ti m' tanoo mä ta hataa rabawa. Jããm né hẽ paawä ta ti tób yt hã moo heb'ooh do haw'aa ta ti pãw Mosees ky n'aa jaw'yyk do an'oo bä —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ti m' Jesus ky hadoo ẽnh sa hã: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ né hẽ ti Saab ky n'aa hã mejũũ doo —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta see pé noo gó m', Saab see hã m', Jesus bahõm ẽnh tób P'op Hagä Do panyyg rayd naherot doo hẽnh. Ti m' tama met'ëëg kän P'op Hagä Do ky n'aa. Ti yt hã m' tabasooh aj'yy moo gadóm doo. Ta hub mä ti gadóm. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ti m' Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ m' ramatakëë mä Jesus aj'yy moo tahaso däg bä Saab hã. Ta moo tahaso däg bä Jesus moo wät né hẽ Saab hã kä sa hã. Rakarẽn paawä m' Jesus raky n'aa tapaa Jesus ky nadaheeh do Mosees ky n'aa jaw'yyk doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus hapäh mä sa h'yyb. Ti m' Jesus ky hadoo aj'yy moo gadóm do hã: —Ag'ëëd däg sa mahang —näng mäh. Ti m' aj'yy as'ëëg g'ëëd kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ti m' Jesus ky hadoo sa hã: —Ỹ eaanh bë hã —näng mäh. —Nyy da ër ky n'aa jaw'yyk do metëëk Saab ky n'aa hã? H'ëëd ti taw'ããts hẽ ji moo wät Saab hã? Baad hadoo do ji moo wät, nesaa do ji moo wät? Ji da hadoo do ji ed'ëëp Saab hã, ji da hadoo do ji daj'ëëp Saab hã? —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ti m' taty kaw'õõd däg kän sa wë. Ti m' aj'yy hã kä taky hadoo: —Madajoow a mooh —näng mäh. Ti m' ta moo tadajoow däk. Ahub däg kän mäh, baad däg mä ta moo kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ti m' tak'ëp mä Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ m' rakawaj'ããn kän Jesus wë. Kaner'oot mä nyy d' rabad'oo ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti m' ta jawén Jesus basëëk waëë jó taky n'aa etsẽẽ hyb n'aa. Taky n'aa ets'ẽẽ had'yyt hẽ m' atsëm. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ti m' tabawag hõm bä kä tanaëënh mä ta wë sahõnh hẽ ta ma metëëk doo. Tasëëw hõm mä 12 sa mahang habong doo, tamejũũ do rabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hahỹỹ d' mä tasëëw hõm do sa häd: Simaw mäh, Peed ta häd n'oo däk doo. Ta jawén mä Ãn-Deréh, Simaw hỹỹj. Ta jawén mä Tsijaag, Jowãw, Pirip, Batoroméw, ");
INSERT INTO mbjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matew, Toméh, Tsijaag Aw-Pew t'aah, Simaw “Serot” ramaneëënh doo, ");
INSERT INTO mbjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Tsijaag t'aah), Judas Ikarijot kä m', Jesus haëëj däk do majĩĩ hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ti m' Jesus ta ma matëg daheeh rabahyng waëë jó naa. Ta hõõ bä m' rabaym dó tabasatẽ bä. Hajõk ta hataa wób tii bä hab'ëëh. Hajõk né hẽ m' ta wób tii bä m' rakata padëëk. Judah häj n'aa bä naa m' rabana ta wób. Jerusarẽnh bä naa m' ta wób. Panang Tiir, Sidõn häd enäh doo, akajar nabyy me badäk doo bä naa m' ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tii bä m' rabana Jesus ma metëëk do ramaa newëë hyb n'aa. Nahëë enäh do na-ããj mä rabena Jesus basog hõm hyb n'aa sa nahëëh. Sa mahang ti abong karap'aar h'yyb hã hadäk doo. Jesus hebëë hõm mä karap'aar h'yyb nesaa do sa hã hanäng do paah. Heso padëëk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","P'op Hagä Do anoo ta hejój tabahajaa hyb n'aa sahõnh hẽ sa nahëë tasog hõm hyb n'aa. Ti hyb n'aa m' sahõnh hẽ rakarẽn mä ta hã ramoo kajäk. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ti m' ta ma matëg wë Jesus ty däng, ti m' taky hadoo sa hã: —P'op Hagä Do ky n'aa edëng bëëh, kas'uut doo, P'op Hagä Do bag'ããs do karapee bë bahadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—P'op Hagä Do ky n'aa edëng bëëh, hỹỹ kä has'aah doo, ta jawén kä bë waa enäh do hyb n'aa. —P'op Hagä Do ky n'aa edëng bëëh, hỹỹ kä h'yy kame'oot doo, ta jawén bë kawew'aam bë tsebé do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—P'op Hagä Do ky n'aa edëng bëëh, hëp ỹ n'aa, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do hyb n'aa, bë wë rah'yy gaẽẽj bä, bë raty n'aa gesyyg bä, bë raky n'aa rejã bä, nesaa do bë ky n'aa ran'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Baad had'op do P'op Hagä Do anoo da bë hã ta säm hỹ pong jé. Ti hyb n'aa taw'ããts hẽ bë tseb'ee tii d' bë hã radoo bä. Bë getsëg da tak'ëp bë tsebé do hyb n'aa. Tii d' né paa sa wahë makũ rabad'oo P'op Hagä Do ky n'aa rod sa hã, rarejãã na-ããj hẽ sa hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Ta wób dooh da rah'yy gadajaa bä. Baad nado da bë hã da hẽ tak'ëp ma näng doo, ta jawén kä dooh bë gado wäd bä do hyb n'aa hanäm doo. Sahõnh hẽ bë gado wät paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Baad nado bë hã da, da hẽ tak'ëp waa enäh doo, ta jawén bë basaah do hyb n'aa da. —Baad nado bë hã da, da hẽ bë kawew'aam doo, ta jawén bë h'yy kame'oot do hyb n'aa da, bë h'yy katón do hyb n'aa da. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Baad nado bë hã da sahõnh hẽ bë hã raj'aa etsëë bä. Tii d' né paa sa wahë makũ raj'aa etsë P'op Hagä Do ky n'aa rod heh'äät nadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ti m' Jesus ky hadoo ẽnh: —Bëëh, ỹ her'oot do maa new'ëë doo, ỹ maher'oot hahỹỹ da: Bë kamahǟn da bë majĩĩ. Bë moo bok baad hadoo do bë wë h'yy gaẽẽnh do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bë ky n'aa edëë bë ky n'aa wasee do hã. P'op Hagä Do hã bë ky n'aa ets'ẽẽ bë hã rejãã doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Õm rapa ewyh bä manu mebyng hyb n'aa paawä, mamabaaj manäh. Man'oo a ta pa s'ee hẽnh rabewyyh hyb n'aa. A hatsë a hã hadäk do rado hõm bä, na ramahũũm a saroor na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Man'oo a hã retsẽẽ doo. A ma rado hõm bä, mamejõ manä ragabaanh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Taw'ããts hẽ bë moo boo ta wób sa hã baad hadoo doo, bë karẽn do bë hã ramoo bok doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Jããm né hẽ bë kamahǟn bä bë hã kamahǟn doo, dooh P'op Hagä Do bë taj'aa etsëë bä tii d' bë bad'oo do hyb n'aa. Nesaa do moo heb'ooh doo, ti na-ããj hẽ rakamahǟn sa hã kamahǟn doo. Ti hyb n'aa bë hã kamahǟn do bë kamahǟn bä, dooh sa bahǟnh bë ado bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Baad hadoo do bë moo boo bä bë hã baad hadoo do moo bok do sa hã, dooh P'op Hagä Do bë taj'aa etsëë bä tii d' bë bad'oo do hyb n'aa. Nesaa do moo heb'ooh doo, tii d' né hẽ rabad'oo ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jããm né hẽ bë an'oo bä bë dajẽẽr uuh hedoo doo, bë waa hedoo doo, p'aa hẽnh hab'aanh do hã, dooh P'op Hagä Do bë taj'aa etsëë bä tii d' bë bad'oo do hyb n'aa. Nesaa do moo heb'ooh doo, ti na-ããj né hẽ tii da né hẽ rabad'oo ẽnh sa da hadoo do hã. Ragahëën p'aa hẽnh rabaj hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dooh tii d' bë adoo bä —näng mäh. —Bë kamahǟn bë majĩĩ. Baad hadoo do bë moo boo sa hã. Bë an'oo retsẽẽ doo. Bë gadaa manä p'aa hẽnh rabaj bä. Tii bä da baad had'op do P'op Hagä Do banoo bë hã ta säm. Sahõnh Hẽ Sa Bahǟnh Hadoo Do taah bë tii bä. P'op Hagä Do ky enyym tamasa do baad ganadoo do sa hã, ky nes'aa do sa hã na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Taw'ããts hẽ ta wób kamahǟn gó bë t'yyd mehĩĩn bë Yb, P'op Hagä Do t'yyd mehĩĩn doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Bë ky n'aa ety manä ta wób, dooh tii bä bë P'op Hagä Do ky n'aa ety bä kä. Baad nadoo do hã bë ky n'aa ety manä bë da hadoo do sa mo haj'aa p'ãã, dooh bë tii bä P'op Hagä Do ky n'aa ety bä bë mo haj'aa p'ãã. Bë hyb n'aa mabaan sa hã taw'ããts hẽ nadoo do sa mo haj'aa hã, tii bä da P'op Hagä Do mabaan nesaa do bë mo haj'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bë an'oo ta wób sa hã, tii bä da P'op Hagä Do banoo bë hã. Baad P'op Hagä Do banoo da bë hã. Panyyg gó bë ỹ maher'oot nyy da P'op Hagä Do banoo bë hã: Ky en'yym doo, baad tiriig tym hes'ëëm doo, baad ta hood gad'ẽẽ däk do hanoo do hadoo P'op Hagä Doo. Baad ub bë hã tabanoo, dooh tabaa es'ĩĩ bä. Ta wób hã bë anoo do pénh da, tii da né da P'op Hagä Do banoo bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ti m' Jesus ky hadoo ẽnh. Panyyg gó m' tabeh'ũũm: —Ty tamah do dooh tahaja bä ta da ty hadoo do tamahũũm bä ta tyw n'aa hẽnh. Ta s'ee hẽnh, gadarong doo hẽnh rakajäk séd hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","—Dooh ma kametëëk do ta ma matëg bahǟnh tado bä. Ma kametëëk do tahaja däk bä tama kametëëk doo, ta ma matëg da hado däk, séd demuun rabahaja padëëk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Hëd n'aa mamatakëë b'aa hyyj its a da hadoo do matym me hahop doo, b'aa haeh do a matym gó anäng? ");
INSERT INTO mbjNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hëd n'aa, “Na b'aa hyyj a matym gó hatu do ỹ ado hõm”, mabanäng, dooh b'aa haeh do mamatakä bä a matym gó hanäng doo? J'ooj madäk do ti a h'yyb. Mado nä pooj jé b'aa a matym gó hakëë doo. Tii bä da mabahapäh baad ub mabado hõm hyb n'aa a da hadoo do matym gó hatu do b'aa hyyj —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ti m' taky hadoo ẽnh: —Joom baad hadoo doo, baad ub ta ag, dooh ta ag nes'aa bä. Ti hadoo né hẽ joom see baad nadoo doo. Ta hẽnh hẽnh ta ag hahõm. Dooh baad hadoo do ta ag. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Joom ag hã ji bahapäh joom ỹỹn. Dooh ji awyyd bä wiigo ag sasëng tëëg hedoo do hã. Dooh na-ããj hẽ ji awyyd bä uwa ag hetëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ti hadoo ji hã. Baad hawät doo, baad hadoo do ta h'yyb gó hanäng do taher'oot. Baad nawät doo, baad nadoo do ta h'yyb gó hanäng do taher'oot. Ji h'yyb tym gó ji hyb n'aa newë had'yyt doo, ti né hẽ ji her'oot —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hëd n'aa ỹ bë maneëënh “Tak'ëp Hyb N'aa Jawyk Doo”, dooh ỹ bë ky dahé bä ẽnh? ");
INSERT INTO mbjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ỹ metëëh da ny hadoo ỹ ma metëëk do maa newëë doo, ky daheeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tób tama do hadoo da tii. T'õp tagagoos ta tu n'aa tyw n'aa tababang bä, pä banäng bä. Tamii bag'yyp bä ta tób hã, wän n'aa hejoonh do badäng bä ta hã, dooh ta tób tatë hyy bä, baad ta tób ta tu n'aa babang bä tabejëh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ti nado këh ỹ maa newëë do ky nadaheeh doo. Tób tama doo, j'ooj ta tu n'aa tabetuu daap hẽ, dooh tahej'oonh péh. Tamii bag'yyp bä ta tób hã, wän n'aa hejoonh do adäng ta hã, tii b' tabatë hyng. Sahõnh hẽ takarejãã ta tób. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ti m' Jesus bahajaa bä kä ta ti sa hã taher'oot doo, tababaaj hõm kän panang Kapar-Naũm häd näng doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tii bä panang bä ti awät mä Roma buuj warahén n'aa sa wahë n'aa seeh. Nahëë näng mä ta karom. P'eets mä tadajëp ta nahëë mahỹỹj. Baad mä ta kariw n'aa kamahǟn tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ti m' ta kariw n'aa, warahén sa wahë n'aa, ky n'aa napäh mä Jesus. Ti m' Judah buuj sa wahë n'aa wób tamejũũ mä Jesus wë, ramaher'oot hyb n'aa tabana hyb n'aa, ta karom tabahaso däk hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ti m' rakajaa bä kä, tak'ëp mä Jesus ramaher'oot rats'yyt doo. Hahỹỹ d' mä sa kyyh: —Taw'ããts hẽ maky dahé õm tats'yyt doo —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Takamahǟn né hẽ ëër, Judah buuj. Taky gabuuj ratama tób P'op Hagä Do panyyg ãã yd naherot doo —näk mä sa kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ti m' Jesus bahõm kän sa sii. Ti m' warahén tób bedaa däk bä m' warahén mejũũ ta najiis wób ragadoo hyb n'aa Jesus, ramaher'oot hyb n'aa. Hahỹỹ da m' rapanäk Jesus hã warahén kyyh: —Wahëh ỹ n'aa, hã ỹỹ ỹ hyb n'aa sakog its a hã. Ti hyb n'aa mahyb n'aa tón manä tóp ỹỹ gó mabajëë suun do hã. Jããm né hẽ mabana. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ỹ hyb n'aa sakog its a hã. Ti hyb n'aa a wë ỹ nahõm. Taw'ããts hẽ babä naa mamejũũ ta nahëë hã, tii bä karom ỹ bahas'oo däk da. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tii d' ỹ wén edoo ỹ na-ããj né hẽ ỹ ky daheeh wahëh ỹ n'aa ramejũũ do ỹỹh. Ỹ na-ããj hẽ, warahén ỹ n'aa ỹ mejũũ, ỹ raky daheeh. Ta see ỹ mejõ bä, “Ahõm”, ỹ noo bä, ahõm né hẽ. Ta see ỹ mejõ bä, “Ana”, ỹ noo bä, ana né hẽ. Karom ỹỹ ỹ mejõ bä, “Hahỹ mamoo wäd”, ỹ noo bä, ỹ taky daheeh né hẽ —tii da m' sa kyyh, warahén kyyh hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ti m' Jesus maa napäh bä m' warahén mejũũ do raher'oot do warahén kyyh, tahyb n'aa meuunh mäh. Ti m' taty kaw'õõd däk hajõk ta sii han'aa do sa wë, ti m' taky hadoo sa hã: —Baad bë ỹ maher'oot —näng mäh. —P'op Hagä Do hã rah'yy ka'eeh sa noo né paawä, dooh ỹ hapäh nä pé Isaraéw buuj sa mahang tak'ëp hã ỹ h'yy ka'eeh doo, hahỹ aj'yy, Isaraéw buuj nadoo doo, h'yy ka'eeh do hadoo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ti m' warahén Jesus wë tamejũũ do rababaaj nä bä m' warahén tób hẽnh, has'oo däg kän mä ta karom kä ta hã rahegãã bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti m' ta jawén kä m' Jesus bahõm kän mä panang Naĩn häd näng doo hẽnh. Ta ma matëg, hajõk ta wób na-ããj hẽ Jesus rahada mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Panang noo bä m' Jesus kajaa bä kä m' tamamuun mä ti buuj. Ramanaa mä dajëp doo. Radakä paawä m'. Jããm né m' sét né hẽ m' ta ti patug tamaa wät do t'aah. Hajõk ta tii bä buuj rahadaa nä ta ỹỹn. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ti m' Jesus baheg'ããs bä m' ta ỹỹn, tat'yyd mehĩĩn mä ta ti ỹỹnh. —Aód manäh —näng mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ti m' Jesus bahõm rabatook hẽnh ta tyng jó, ti m' ta tyng hã tamoo däng. Ti m' kamag hat'ook do rabaym. Ti m' Jesus ky hadoo: —Pahëëw —näng mäh. —A hã ỹ mejũũ: Nu gas'ëëg gahëë! —näng mä Jesus kamag hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ti m' tanu gas'ëëg gahäng dajëp do paah. Ti m' taber'ood däg kän. Ti m' Jesus bahaëëj däg kän ta ỹỹn hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ti m' sahõnh hẽ rameuuj bong mäh, P'op Hagä Do hã m' raj'aa etsë mäh. —P'op Hagä Do ky n'aa rod tak'ëp haj'ap do kas'ee kän ër mahang —näk mä sa kyyh. —P'op Hagä Do bahyng ta karapee tamasa hyb n'aa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ti m' Jesus mo haj'aa hã kä sahõnh hẽ rapanäg hõm ta wób, Judah häj n'aa haw'ããts hẽ m', Judah häj n'aa pa hẽ habong do na-ããj mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti m' Jowãw nu gahem'uun do ma matëg ramaher'oot mä ta hã sahõnh hẽ Jesus moo wät do ky n'aa. Ti m' Jowãw naëënh ta wë pawóp hẽ ta ma matëg. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ti m' tamejũũ mä Jesus wë rabahõm. —Hahỹỹ da bë eaaj Jesus hã: “Õm né hẽ ti P'op Hagä Do Ky Däng Do ta wë hana doo, ta see ti ãã gada?”, denoo da —näng mä Jowãw nu gahem'uun doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ti m' Jesus wë rakajaa bä kä m' raky hadoo ta hã: —Jowãw nu gahem'uun do ãã tamejũũ, õm ãã eaanh hyb n'aa õm né tado bä P'op Hagä Do Ky Däng Do ta wë hana doo, ta see apäh ti ãã gada doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti noo gó né hẽ hajõk sa nahëë Jesus asog hõm doo. Hajõng nahëë Jesus asog hõm doo. Ta see hedoo ta seeh, ta see hedoo ta seeh, ta see hedoo ta seeh. Sahõnh ta ti nahëë tabasog hõm. Karap'aar h'yyb nesaa do ta wób hã hanäng do tahebëë hõm. Ty tsehẽt doo, sahõnh hẽ taty enä hõm, baad rabahapëë padëëk Jesus mo haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ti m' Jowãw mejũũ do hã Jesus ky hadoo: —Bë ahõm nä, bë maher'ood Jowãw babä bë hapäh doo, bë maa newëë doo: Ty temah do paah, rahapëë padëëk. Nabong do paah, aboo padëëk p'aa hẽnh. Rog manahuuh doo, ahub padëëk p'aa hẽnh. Nabuuj gatemah doo, ramaa napëë padëëk. Dejëp do wób genä bong ỹ an'oo bä. P'op Hagä Do panyyg hanäm do na-ããj hẽ kaher'ood däk kas'uut do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ky n'aa kedëng da jé ỹ moo wät do hyb n'aa, ỹ her'oot do hyb n'aa tah'yy kaneréd bä hã ỹ tah'yy ka'eeh doo. Tii d' bë her'ood Jowãw hã —näng mä Jesus kyyh Jowãw nu gahem'uun do mejũũ do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ti m' Jowãw nu gahem'uun do mejũũ do rababaaj hõm jawén paa bä kä, hajõk do hã Jesus her'ood kän Jowãw nu gahem'uun do ky n'aa. Hahỹỹ da m' ta kyyh: —H'ëëd ti bë heg'ããs tabanawäng hẽnh? Jawii bah'ood ahëm do g'eeh bë heg'ããs? ");
INSERT INTO mbjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ti tanado bä, h'ëëd ti bë heg'ããs t'ĩĩ hẽnh? Aj'yy saroor ky n'aa gebah do dadäk do bë heg'ããs t'ĩĩ hẽnh? Dooh. Saroor ky n'aa gebah do hanäm do dadäk doo, sahõnh hẽ rah'yy karẽn do sa wë hanäng doo, dooh raboo bä tabanawäng bä. Sa wahë n'aa tób hanäm doo gó rababok tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ti tanado bä, h'ëëd ti bë heg'ããs t'ĩĩ hẽnh? P'op Hagä Do ky n'aa rod bë heg'ããs? Ỹỹ. Ti né ti bë heg'ããs. P'op Hagä Do ky n'aa rod bahǟnh tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta ti né hẽ ta ti aj'yy ky n'aa näng do P'op Hagä Do kyy kerih do hã. Hahỹỹ da ta ky n'aa: “Ỹ mejũũ da panäk ỹ n'aa a pooj jé, a tyw n'aa tabenyyw däk hyb n'aa a pooj jé”, näng kerih doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Baad bë ỹ maher'oot —näng mä Jesus. —Badäk hahỹỹ bä habong do sa mahang, dooh Jowãw bahǟnh nu gadäk péh. Ti tahado né paawä, P'op Hagä Do bag'ããs do karapee hedoo do sa mahang, jããm hẽ hyb n'aa sakog its né paawä, Jowãw bahǟnh tanu gadäk hỹỹ kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ti m' hajõk doo, dajẽẽr gahed'aak do sii hẽ né hẽ m', ramaa napäh bä m' Jesus her'oot doo, P'op Hagä Do hã m' raky kajäk. Baad ub sa hã P'op Hagä Do moo wät doo. Jesus her'oot do rawén gen'aak, Jowãw nu gemuun hõm do hyb n'aa p'ooj ub sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pariséw, baad Mosees ky n'aa jaw'yyk do hap'ëëh do na-ããj hẽ, dooh m' ragado bä sa hã P'op Hagä Do ky n'aa enooh doo. Rawén ganadoo mäh, dooh paa m' rakarẽn Jowãw nu gahem'uun do nu gemuun. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ti m' Jesus ky hadoo: —Nyy gó da ỹ baher'oot da, da hẽ badäk hahỹỹ hã habong do panyyg ky nadah'eeh do sa ky n'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hahỹ hadoo tii: Karepé wahoo gó hab'ëëh do ramas'uunh do hadoo. Hahỹỹ da karepé wób sa kyyh ta wób hã: “Raketëë do pud n'aa ãã gamehỹỹh bë tsebé hyb n'aa paawä, dooh masunh do bë as'ããw bä. Tii bä dajëp do heen n'aa ãã wareem, masuuj gó bë ba'oot hyb n'aa paawä. Ti na-ããj dooh bë karẽn bä. Dooh h'yy ketón gó bë masuuj bä”, näk karepé ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ti hadoo né hẽ da hẽ habong doo. Tabad'op hẽ ji raky dahé bä, dooh na-ããj hẽ ragenaag bä ji moo wät doo. Jowãw nu gahem'uun doo, dooh uwa s'ëëb mahỹỹnh do teëg bä. Ta see pé noo gó noo kanawa doo me P'op Hagä Do tah'yyb en'yym. Ti hyb n'aa, “Karap'aar h'yyb mahũũm mä tii”, bë nooh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ỹỹ kä, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ eëëk, ỹ awa. Ti hyb n'aa ỹ bë maneëënh, tahawaa, heëëk do men, dajẽẽr gahed'aak doo, nesaa do moo heb'ooh do sa najiis. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ãã raganado né paawä, P'op Hagä Do né hẽ ti ỹỹh, Jowãw na-ããj hẽ h'yy gan'yyh doo. Ãã ma met'ëëg wät do ky dah'eeh do baad rababok do hã takametä däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ti m' Pariséw see Jesus tabats'yyt ta tób hẽnh tabawëh hyb n'aa ta sii. Ti m' Jesus bahõm kän ta tób hẽnh. Ti m' tabahyy sooh ta tyng hã rabahed'oo doo da, ta jawén p'aa hẽnh mä ta tsyym bëëh. Ti m' rabawëë kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti m' ta ti panang bä ti awät mä ỹỹnh nesaa do moo hew'ëët do paah. Ti m' taky n'aa napäh bä m', Pariséw tób hẽnh Jesus bawëh bä m', t'ĩĩ hẽnh mä tabahõm. Buu benyym do ta moo gó. Pä s'ëëb, buu benyym do hood. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ti m' Jesus tsyym hã m' ta taron nu paa me tabahyy häng. Ti m' tabaoot. Ta ty nabëëh Jesus tsyym hã takajäk. Ti m' tabahawuuk ta sëën me. Jesus mä tatsyym tsanetsup, ta hã taweh'ëëh do heen n'aa. Buu benyym do tah'ook mä Jesus tsyym hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ti m' Pariséw Jesus hats'yyt do bahapäh bä m' ta tii, ta h'yyb gó m' taky hadoo: “P'op Hagä Do ky n'aa rod tado bä paawä hahỹ aj'yy, tahapäh paawä jaa ti ta ti ỹỹnh. Tahapäh paawä ti nesaa do moo hew'ëët doo. Tabahapäh bä paawä, dooh tagado bä ỹỹnh ta hã moo wät doo”, näng mä Pariséw ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ti Jesus h'yyb hapäh mä ta ti Pariséw. Ti m' taky hadoo: —Simaw —näng mä ta hã. —Ỹ karẽn paawä õm ỹ maher'oot —näng mäh. —Éj. Ỹ mamaher'ood ma matëg —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ti m' Jesus ky hadoo, panyyg gó m' tabenaa wät: —Ti abong pawóp hẽ ajyy. Kũũt enäh sa kariw n'aa wë. Ta see kũũt 50, ta see kũũt 500. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dooh rahaja bä repaag bä sa kũũt. Ti hyb n'aa sa kariw n'aa bawug hõm sa kũũt. Hỹỹ kä, ỹ eaanh a hã —näng mä Simaw hã. —Ny hadoo do sa kariw n'aa tak'ëp takamahǟn up a hã péh? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ti m' Simaw ky hadoo: —Hã ỹỹ, kũũt eh do paah —näng mäh. —Ti né hẽ —näng mä Jesus. —Baad a kyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ti m' ỹỹnh wë taty kaw'õõd däk. Ti m' Simaw hã ta ky hadoo: —Mahegãã hahỹ ỹỹnh —näng mäh. —A tób gó ỹ bajëë suun bä, dooh naëng ỹ man'oo bä ji bahed'oo doo da, tsym ỹ hetsyd. Hahỹ ỹỹnh kä, tsym ỹ ta ty nabëë me tatsahë däk, ti tabawug hõm ta sëën me —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Ỹ kajaa bä, dooh ỹ matsanetsub bä makedëng do heen n'aa ji bahed'oo doo da. Hahỹ ỹỹnh kä, dooh teréd bä tatsanetsup do tsym ỹỹ hã, ỹ kajaa bä tadu dahäng do né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dooh mahawug bä ta syyj buu benyym do nuh ỹỹ gó ji bahed'oo doo da. Hahỹ ỹỹnh, buu benyym do tahah'ook tsym ỹỹ hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tak'ëp ỹ tawén kamahǟn, hajõng nesaa do ta wë hanäng do paa P'op Hagä Do mabaan hõm do hyb n'aa. Kanahën hadoo do nesaa do hã näng do P'op Hagä Do awug hõm doo, kanahën doo hẽ P'op Hagä Do takamahǟn —näng mä Jesus Simaw hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ti m' ỹỹnh hã kä Jesus ky hadoo: —Nesaa do a hã hanäng do paa kado hõm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ti m' Simaw atsyyd bong do wób sa h'yyb gó m' rabedoo: —Jaa ti hỹỹh? Tahajaa g'eeh nesaa do tado hõm bä? Jããm né hẽ P'op Hagä Do hajaa tii —näk mä sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ti m' Jesus ky hadoo ẽnh ỹỹnh hã: —Õm P'op Hagä Do wén ed'ëëp nesaa do mahǟnh, hã ỹ mah'yy ka'eeh do hyb n'aa. Ahõm kä h'yyb näm doo me —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ti jawén mä sét panang ken'yyh bä m' Jesus her'ood hõm mä P'op Hagä Do bag'ããs do ky n'aa hanäm doo. 12 hedoo do ta ma matëg rahada mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ah'ũũm mä na-ããj hẽ ta sii ỹỹj wób, karap'aar h'yyb nesaa do sa hã padëëk do paa Jesus habëë hõm do sa hã, sa nahëë tado hõm do sa hã. Sa mahang ti awät mä Marija Madarẽn häd näng doo, 7 karap'aar h'yyb ta hã henyyh do paa Jesus habëë hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta see häd mä Jowãn, Kusa häd näng do ỹỹm. Häj n'aa wahë n'aa Eróts häd näng do kaser n'aa m' ti ta patug. Ta see häd mä Susããn. Hajõk mä ỹỹj wób rahada Jesus. Sa dajẽẽr me ramasa Jesus ta ma matëg daheeh sa waa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ti m' hajõk ta wób kata padëëk mä Jesus wë. Jé pad'yyt hẽ naa rabena. Ti m' ta ma matëg hã tamaher'oot hahỹ panyyg: ");
INSERT INTO mbjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Hỹ hadoo joom hejóm do bejoom joom tym. Tatsawyh hõm joom tym. Joom tym tatsawyh hõm do wób ta tyw n'aa me takajäk. Ta wób ratsabeeb hõm, ta wób taw'ëëd rabajóh jëng. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Joom tym wób kajäk pä ta yt tabahadoo do jó. Kanahën its k'ããts tii bä. Ti taganyyh bä nayyw hẽ tatsawyy jëng, dooh tabatsahëë ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta tym wób kajäk sasëng kóm banäng bä. Ta nemuun sasëng gajewäng. Tii bä kä, dooh tawëë wäd bä kä sasëng hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta tym wób kajäg kän baad tabadoo bä. Genyyh, baad tabawäng, baad tabeaak. 100 nuu me tabejoom do bahǟnh tabeag kän baad tabadoo bä kajäk doo —näng mä Jesus, panyyg ky n'aa me m' tabaher'ood kän. Ti m' tabahajaa bä panyyg taher'oot doo, taky hadoo: —Jé karẽn pé ỹ her'oot do tamaa newë bä, taw'ããts hẽ tahyb n'aa matakëë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ti m' ta ma matëg beaanh ta hã nyy d' tahanäng pé m' ti panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ti m' taky hadoo sa hã: —Bë hã P'op Hagä Do an'oo däk bë bahapäh hyb n'aa pooj jé ji nahapäh do P'op Hagä Do bag'ããs do hã. Ta wób sa hã, P'op Hagä Do hã h'yy kana'eeh do sa hã, ỹ maher'oot panyyg ky n'aa me —näng mäh. —Ti hyb n'aa, “rahegãã né paawä m', dooh m' rah'yy genä bä. Ramaa newë né paawä, dooh tagah'ood bä sa hã” —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ti m' Jesus ky hadoo ẽnh: —Hahỹỹ d' tahanäng pé panyyg ky n'aa: Joom tym, P'op Hagä Do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Joom tym wób ta tyw n'aa me kajäk do hadoo P'op Hagä Do panyyg maa new'ëë do wób sa hã. P'op Hagä Do kyyh sa h'yyb gó kajäk do Dijab asog hõm raky nadaheeh hyb n'aa, ranedëp hyb n'aa nesaa do mahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Joom tym wób pä banäng bä kajäk do hadoo P'op Hagä Do panyyg maa new'ëë do wób sa hã. Ramaa newëë bä h'yy gadajaa gó ragado né hẽ paawä, nayyw hẽ rah'yy gejë hõm. Joom kóm nanäng nä do hadoo sa hã. Pooj jé dó raky daheeh. Tii bä, hejoonh doo me P'op Hagä Do metyy bä baad rah'yy kae bä, nayyw hẽ rah'yy gejë hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Joom tym wób sasëng mahang kajäk do hadoo P'op Hagä Do panyyg maa new'ëë do wób sa hã. P'op Hagä Do kyyh ramaa napëë né paawä, rahyb n'aa newë had'yyt hẽ badäk hahỹỹ hã ji bawät do hã. Dajẽẽr hã, sa ma hã, rakarẽn do hã rahyb n'aa hũũm had'yyt hẽ. Ti hyb n'aa P'op Hagä Do panyyg sa h'yyb gó hadäk do tawén nahõm. Joom neaak do hado däk tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Joom tym wób baad tabadoo bä kajäk do hadoo P'op Hagä Do panyyg maa new'ëë do wób sa hã. Baad ub sa h'yyb, t'õp madäk doo me ramaa newëë. P'op Hagä Do kyyh ramaa napäh bä, baad rabenäm sa h'yyb gó. Rahyb n'aa matakä had'yyt hẽ ta hã. Tabad'op hẽ rah'yy gejë hõm. P'op Hagä Do karẽn do baad ramoo bok tii kä. Joom he'aak do hadoo tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ti m' taky hadoo ẽnh: —Ta bag dooh ji gataa so bä ji bejën hyb n'aa manajuu yt hã, ji bejën hyb n'aa ji jó ỹỹh do yt hã. Dooh. Ta bag ji dasooh ta tyng jó, tób gó hajëë pëë do rabahapäh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta ti hadoo da ỹ ma metëëk do hã: Sahõnh hẽ kejën nä doo, ji nahapäh nä doo, ta jawén kä da sahõnh hẽ da rabahapäh, wyt ta maab däg da sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ti hyb n'aa taw'ããts hẽ baad bë hyb n'aa matakä bë maa newëë do hã. Jé h'yy ganyy däk doo, ti bahǟnh P'op Hagä Do banoo nä ta hã ta h'yy ganäng doo. Jé kanahën d'os hẽ h'yy ganäng doo, tahajaa do ted'oo doo, P'op Hagä Do ado hõm da ta hã kanahën d'os hadoo doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ti m' ta see pé noo gó Jesus ỹỹn, ta wakããn sii hẽ m' rabana, Jesus raheg'ããs. Du daa m' rakad'oo pé hajõk do hyb n'aa ta w'oo hã hab'ëëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ti m' rë tanyy ky hadoo ta hã: —A ỹỹn, a wakããn ta w'oo hã rabab'ëëh. Õm mä raheg'ããs —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ti m' Jesus ky hadoo: —Sahõnh hẽ P'op Hagä Do panyyg maa new'ëë doo, ky dah'eeh doo, ti né hẽ ëën hadoo, ti né hẽ wakãn haa hadoo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti m' ta see pé noo gó m' Jesus baher'oot ta ma matëg sa hã: —Ti bä, ër atsëg hõm karaj'aa tamyyj jé. Ti m' ragatsëg t'oonh marakate gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ti m' rabatsëk bä kä m' Jesus aǟ sooh mäh. Ti m' bah'ood bana kän tak'ëp. Tewëëp mä maadaka. Marakate m' tetaa m'. Ǟm n'aa näng. P'eets mä marakate bagyyb jëë paawä. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ti m' ta ma matëg ramebëë nyyh, ti m' raky hadoo: —Ãã Wahë N'aa! —näk mäh. —Ër ag'yyp da! —näk mäh. Ti m' tabas'ëëg gëët, ti m' bah'ood, maadaka tameduuk. Ti m' bah'ood badoo wäd. Badatih däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—Dooh hã ỹ bë h'yy kasadëë bä? —näng mäh. Ti m' tak'ëp mä rabeỹỹm bong, tak'ëp mä rameuuj bong. Ti m' rakaner'oot sa mab hẽ: —Jaa ti hỹỹ éh? Bah'ood, maadaka sii hẽ raky daheeh! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ti m' rakajaa Geras buuj sa häj n'aa bä, karaj'aa tamyyj jé, Garirej häj n'aa nu masee me. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti m' Jesus gatsëg nyyh bä kä m', nayyw hẽ m' tabana ta wë aj'yy mera doo, karap'aar h'yyb hã näng doo, ta tii bä babuuj. Bäp peej mä tabawät ta si n'aa hẽ. Bäp peej däg mä tanaǟ wät tób yt hã. Pä gabaho doo gó, panang buuj dejëp do sa kamag n'aa radebong doo bä tabahe'ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ti m' Jesus tabahapäh bä m' tak'ëp mä tageëëj wät. Jesus matym gó m' tabadëë hyng. Tak'ëp mä ta kyyh: —H'ëëd makarẽn wë ỹỹ, Jesus, P'op Hagä Do T'aah, Sahõnh hẽ Bahǟnh Hadoo Do T'aah? Ỹ d' marejã manäh! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tii d' tawén edoo mäh, karap'aar h'yyb nesaa do Jesus ah'eed hõm do hyb n'aa m'. Hajõõ nuu me m' karap'aar h'yyb bejëng ta hã tamera doo. Haak sapuuw hadoo doo me né hẽ m' ramoo maw'yyd né paawä m', ratsyym mew'yyd hõm paawä m', hagã nyy né paawä m', tagahet'ëëh mä haak sapuuw hadoo doo. Tabanawäng hẽnh daap mä tawajaah karap'aar h'yyb an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ti m' Jesus beaanh ta hã: —Nyy d' a häd? —näng mäh. —“Hajõk Doo” ãã häd —näng mäh. Hajõk karap'aar h'yyb ta hã hanäng, tii d' ta häd tawén hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ti m' karap'aar h'yyb nesaa do rets'ẽẽ had'yyt mä Jesus hã tanah'eed hyng hyb n'aa tabanesaa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hajõng mä too yb tii b' habëëh karaj'aa takëën hã, wajapëm doo bä. Tii b' mä sa waa rabahew'aa. Ti m' karap'aar h'yyb rabetsẽẽ Jesus banoo hyb n'aa rabajëë pëë too yb hã. Ti m' Jesus banoo t'ĩĩ hẽnh sa hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ti m' karap'aar h'yyb nesaa do benä kän aj'yy hã hanäng do paah, too yb hã m' rabajëë pä kän. Ti m' too yb rapah'uud bong, rameraa bong, ti m' rawaj'aa wëënh tame wajapëm doo hẽnh, tame m' rakejäg bëënh. Ti m' t'õp mä rapehǟs. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ti m' too yb hagã n'aa rabahapäh bä m' ta tii, waj'aa bong mäh. Sa panang bä, panang nedaa bä na-ããj mä ramaher'oot sahõnh hẽ rahapäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ti m' t'ĩĩ hẽnh buuj rabana t'ĩĩ hẽnh rabaheg'ããs hyb n'aa ky n'aa näng doo. Ti m' Jesus wë rakajaa bä kä, rabahegãã kän aj'yy hajõng do karap'aar h'yyb nesaa do hanäng do paah. Asooh mä Jesus tsyym pa. Saroor näng mäh, baad däg mä ta h'yyb tym. Ti m' rabeỹỹm bong. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ti m', ta ti hap'ëëh do rabaher'ood kän han'aa do sa hã kä, ta ti aj'yy ky n'aa, Jesus ahub däk do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ti m' ta ti babuuj rabetsẽẽ Jesus hã, tabahõm hyb n'aa sa häj n'aa bä naa. Tak'ëp mä rabeỹỹm bong rawén eaanh tabahõm hyb n'aa. Ti m' Jesus gatsëg so kän marakate gó, ti m' tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aj'yy kä m' karap'aar h'yyb nesaa do hadäk do paa m' betsẽẽ Jesus hã, Jesus sii tabahõm hyb n'aa. Ti m' Jesus baher'oot ta hã tabahõm hyb n'aa. Hahỹỹ da m' taky hadoo ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Abaaj hõm a tób hẽnh, a wakããn rababong hẽnh. Maher'ood sa hã sahõnh hẽ taw'ããts hẽ hadoo do a hã P'op Hagä Do mo haj'aa, õm tahuub däk doo —näng mä Jesus kyyh ta hã. Ti m' aj'yy bahõm kän. Taher'oot mä sahõnh hẽ panang buuj hanäm do Jesus mo haj'aa ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ti m' Jesus batsëg hõm bä p'aa hẽnh karaj'aa tamyyj jé, hajõk baad ragadoo. Jesus mä ragadaa b'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ti m' aj'yy Jaj-Ro häd näng do bana Jesus wë. Tób P'op Hagä Do panyyg rayd naherot do sa wahë n'aa see m' tii. Ti m' ta taron nuu me m' tabahyy häng ta wë. Ti m' tak'ëp mä tabetsẽẽ ta hã ta tób hẽnh tabahõm hyb n'aa ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jããm né m' sét its mä ta toog. P'eets mä tadajëp. 12 m' ta hyb n'aa pé ta baab n'aa. Ti m' Jesus bahõm ta sii. Tamahõm me m', hajõk do ta sii hah'ũũm do gatat'uuk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sa mahang ti awät mä ỹỹnh. Majyyw mä ta nahëëh. 12 m' ta baab ta nahëë badäk. Dooh m' hajaa pé masa pé ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ti m' Jesus jó gadäk hẽnh mä tabana ta wë. Ta saroor noo hã m' tamoo däng. Tii bä kä m', nayyw hẽ m', dooh wäd mä ta hã ta nahëëh. Ti m' Jesus beaanh: ");
INSERT INTO mbjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—Jaa hã ỹ moo däng? —näng mäh. —Ỹ ti dooh —näk mä sahõnh hẽ ta pa hab'ëëh doo. Ti m' Peed ky hadoo: —Ma Matëg —näng mäh. —Hajõk gatat'uuk a hã. Hajõk a hã moo kajäk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ti m' Jesus ky hadoo ta hã: —Dooh. Hã ỹỹ pé ỹ hapäh hã ỹỹ moo däng doo. Hã ỹ naa anyyh hejój ỹ ky gabuuj —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ti m' ỹỹnh hegãã bä kä du daa m' takejën péh, ana mä Jesus wë. Kajajãn mä ta ǟm n'aa gó m', tabahyy häng mä ta wë ta taron nuu me. Sahõnh hẽ ramaa napäh bä m' tamaher'oot h'ëëd hyb n'aa tawén moo däng ta hã. Taher'oot mä nyy d' tabahas'oo däk nayyw hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ti m' Jesus ky hadoo ta hã: —Tok ỹỹ, õm has'oo däk P'op Hagä Do hã mah'yy ka'eeh do hyb n'aa. Ahõm kä h'yyb näm doo me —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus ber'oot nä bä m', takajaa aj'yy Jaj-Ro tób hẽnh naa. Ti m' taky hadoo Jaj-Ro hã: —A toog h'yy gakog hõm —näng mäh. —Dooh mah'yyb panasä wäd bä ma matëg —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus maa napäh bä m' ta kyyh, ta ky hadoo Jaj-Ro hã: —Mahyb n'aa tón manäh. Hã ỹ h'yy kasadëë. Tii bä da a toog da has'oo däk! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ti m' Jaj-Ro tób bä rakajaa bä m', dooh m' Jesus an'oo bä hajõk rabahõm ta sii. Jããm né hẽ m' tanoo hajëë p'ëë Peed, Tsijaag, Jowãw, dajëp do yb, dajëp do ỹỹn. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Séd dó m' tób yt hã raräb bä rabë bä. A'oot mä ta wób. Ti m' Jesus ky hadoo sa hã: —Jããm hẽ ti bë kyyh —näng mäh. —Bë aód manäh. Karapee dooh tadajëb bä. Aỹỹh tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tii bä m' rakawew'aam ta kyyh. Dajëp né hẽ m' sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ti hadoo né hẽ dooh m' Jesus hyb n'aa p'eed bä sa kyy hã. Ti m' karapee hã tamoo maso däk, ti m' taky hadoo ta hã: —As'ëëg g'ëëd tok ỹỹ! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tii bä m' h'yy ganä däk mä p'aa hẽnh. Nayyw mä tabas'ëëg gëët. Ti m' Jesus maher'oot sa hã rabanoo hyb n'aa maruus awa. ");
INSERT INTO mbjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tii bä m' ta yb, ta ỹỹn rameuuj bong mäh. Ti m' tak'ëp Jesus mejũũ sa hã ranaher'oot hyb n'aa ta ti ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ti m' ta see pé noo gó m' Jesus naëënh 12 hedoo do ta ma matëg ta wë. Ti m' tabanoo mä sa hã karap'aar h'yyb nesaa do rabahajaa rabahebë hyb n'aa, nahëë näng do rabaheso hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ti m' tamejũũ mä rabahõm, ji P'op Hagä Do bag'ããs do ky n'aa rabaher'ood hõm hyb n'aa, nahëë enäh do rabaheso hõm na-ããj né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hahỹỹ da m' tamejũũ: —Dooh d' bë mahũũm péh. Ji tatu hadoo péh, pãw hadoo péh, ta hood hadoo péh, ta säm hadoo péh, bë saroor see hadoo péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Bë nu kajäk bä ta wób tób bä, tii bä da bë baym dó panang bë beréd hõm bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bë raganado bä, bë ahõm sa mahǟnh. Sa panang bä naa bë ahõm bä bë tsyym suun bë tepyng padäg k'ããts. Tii da bë bad'oo, rabahapäh hyb n'aa dooh baad tado bä P'op Hagä Do panyyg raky nadaheeh doo —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ti m' rabahõm kän. Sét ken'yyh panang bä m' rabaher'oot mä P'op Hagä Do panyyg hanäm doo. Jé pad'yyt hẽ heso hõm mä nahëë enäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti m' Garirej häj n'aa wahë n'aa, Eróts häd näng doo, taky n'aa napëë däk mä tii. H'yyb manepëë wäd mä Eróts Jesus ky n'aa raher'oot do hã. —Jowãw nu gahem'uun do paa ti ta ti dejëp do mahang ganä wät doo —näk mä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","—Eriij p'ooj ub hawät do paa kas'ee wät do tii —näk mä ta wób. —P'op Hagä Do ky n'aa rod p'ooj ub habok do paa see ganä wät do ti ta tii —näk mä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ti m' Eróts ky hadoo: —Jowãw nu gahem'uun doo, ỹ mejũũ paa ranu gahõg hõm. Jaa ti ta tii, hã ỹ ramaher'oot do ta ky n'aa? —näng mä Eróts kyyh. Takarẽn paawä m' taheg'ããs Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ti m' 12 hedoo do Jesus mejũũ doo, rababaaj nä bä m' Jesus wë, ramaher'oot mä ta hã sahõnh hẽ ramoo bok doo. Ti m' 12 hedoo do Jesus mahũũm sa m'aa hẽnh kä, panang Betsaj-Da häd näng doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ta wób, hajõk doo, raky n'aa napäh bä m' n'yy hẽnh Jesus rabahõm, ah'ũũm mä sa jawén. Rakajaa bä Jesus gadoo mä hajõk doo, ti m' tama metëëk sa hã ji P'op Hagä Do bag'ããs do ky n'aa. Nahëë enäh do heso hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tũũh tabado däk bä kä m' 12 hedoo do rabana Jesus wë, ti m' raky hadoo ta hã: —Mamejõ hõm hajõk do panang tabanäng bä, sét ken'yyh rabaj'eenh hẽnh na-ããj hẽ, sa waa rabetsẽẽ hyb n'aa, t'ĩĩ hẽnh raba'ỹỹh hyb n'aa. Dawëë hahỹ babä —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti m' Jesus ky hadoo: —Bë né hẽ hanoo sa waa —näng mäh. Ti m' raky hadoo: —Dooh tahaja bä —näk mäh. —Jããm hẽ ti hanyys ji ma poo oow pé pãw, pawóp its tah'ỹỹb —näk mäh. —Makarẽn ãã bahõm ãã betsẽẽ hajõk do sa waa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(5 miw ajyy tahyb n'aa pé m' tii bä hab'ëëh doo.) Ti m' Jesus ky hadoo sa hã: —Bë mejõ rabehyy b'ëëh tũũ, 50 ken'yyh ketyn hõm doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ti m' Jesus mejũũ doo da né hẽ m' rabad'oo. Sahõnh hẽ m' rabehyy b'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ti m' Jesus asog däk mä pãw, tah'ỹỹb na-ããj mäh. Hỹ pong jé taty däng bä m', P'op Hagä Do hã taky hadoo: —Õm taw'ããts hẽ Ee. Man'oo däk ãã tä, man'oo däk ãã waa —näng mäh. Ti m' pãw, tah'ỹỹb na-ããj né hẽ taganebäh bong mäh, tets'ëë hõm mä ta ma matëg sa hã, rabets'ëë hõm hyb n'aa hajõk do hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tii bä kä m', sahõnh hẽ m' rabawëë bong. Wog enä hõm mä sahõnh hẽ. Ti m' mad'aak doo m' ta ma matëg rata hõm mä kawaju gó. 12 m' kawaju gedẽ hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti m' ta see pé noo gó ta m'aa hẽnh Jesus ky n'aa etsẽẽ mäh. P'eets hẽ m' ta ma matëg rabab'ëëh. Ti m' tabahajaa bä kä m' taky n'aa etsẽẽ doo, tabeaanh ta ma matëg sa hã: —Jaa m' ỹỹh, sa nooh? ");
INSERT INTO mbjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ti m' raky hadoo: —Ta wób noo m' õm mä Jowãw nu gahem'uun do paah. Ta wób noo m' õm mä Eriij makũũh. Õm mä P'op Hagä Do ky n'aa rod p'ooj ub dejëp do paa see ganä wät do m', ta wób sa nooh —näk mä sa kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Bë hã ẽnh? Jaa ỹ bë hã ẽnh? —näng mä Jesus sa hã. Ti m' Peed ky hadoo: —Õm ti Kristo, P'op Hagä Do H'yyb Däng Doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ti m' Jesus mejũũ tak'ëp sa hã ranaher'oot hyb n'aa ta ti ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ti m' taky hadoo: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, hajõng da ỹ ahoop. Ër wahë n'aa, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa na-ããj da, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ ỹ da rahyb n'aa wareem. Ỹ da dajëp ran'oo bä. Tamawoob hẽ ta ǟh, ỹ ganä wät da p'aa hẽnh —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ti m' taky hadoo sahõnh hẽ sa hã: —Jé karẽn pé hëp ỹ hata tabahadoo hyb n'aa, taw'ããts hẽ teréd hõm ta hã hẽ tah'yy ka'eeh doo, taw'ããts hẽ teréd hõm ta hã hẽ tahyb n'aa newëë doo. Taw'ããts hẽ da tagado had'yyt hẽ tahoop do hëp ỹ n'aa. Taw'ããts hẽ tagadoo hëp ỹ n'aa radajëëb bä na-ããj hẽ. Taw'ããts hẽ ỹ taky daheeh, taw'ããts hẽ ỹ bawät doo da da ti bawät. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tii d' ỹ wén edoo, badäk hahỹỹ hã ji hawät do tak'ëp kamahǟn doo, jé tahoop do hëp ỹ n'aa jeỹỹm doo, dooh da P'op Hagä Do wë tanu dëë bä. Jé hëp ỹ n'aa tahoop do gadoo péh, hëp ỹ n'aa tadajëb bä, ta h'yyb tym da P'op Hagä Do wë da tanu däng. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hëd n'aa ji karẽn sahõnh hẽ badäk hahỹ ji ta danäh, ji h'yyb tym ta s'ee hẽnh tahõm bä? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ti m' Jesus ky hadoo ẽnh: —Hëp ỹ n'aa, ỹ ma metëëk do hyb n'aa na-ããj hẽ nu mebyng péh, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ d' nu mebyng ẽnh ta hyb n'aa hejój ỹỹ hã ỹ bahyng bä ta bag tak'ëp gabarëëh doo gó, Ee hejój gó, ããs tak'ëp baad hedoo do sa hejój gó na-ããj hẽ ỹ bahyng noo gó —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Baad bë ỹ maher'oot. Ta wób babä ër mahang habong do rahapäh nä da ỹ du doo noo gó sahõnh hẽ ỹ bag'ããs P'op Hagä Do hejój me. Radejëp do pooj jé rahapäh nä da tii. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ti m' 8 ta hyb n'aa pé sa ǟ jawén paa bä m', Jesus mahũũm ta sii Peed, Tsijaag, Jowãw daheeh. Ti m' rabas'ëëg kän waëë jó taky n'aa etsẽẽ hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ti m' taky n'aa etsẽẽ bä m', Jesus mamets kawareem däk sa matym gó. Ta see hado däk mäh. Tak'ëp mä ta saroor gabar'ëëng däk, hawyp do gabarëëh doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ti m' pawóp hẽ ajyy, p'ooj ub habong do paah, Eriij, Mosees häd enäh do ");
INSERT INTO mbjNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","rakas'ee b'ëëh sa matym gó, ta bag gabarëëh doo gó. Er'oot mä Jesus sii. Er'oot mä ta sii Jerusarẽnh bä Jesus dajëp do ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ty jaw'yyk mä Peed ta najiis daheeh. Ti hyb n'aa aǟ b'ëëh mäh. Ti m' raty gawëëj padëëk bä m', Jesus bag tak'ëp gabarëëh do rabahapäh. Ti m' ajyy ta pa ab'ëëh mä rabahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti m' ajyy rabahõm bä Jesus mahǟnh, Peed ky hadoo mä Jesus hã: —Ma Matëg! —näng mäh. —Taw'ããts hẽ babä ër hã! —näng mäh. —Taw'ããts hẽ tamawoob hẽ ta tób n'aa ãã temaa toonh. Sét hẽ a tób, sét hẽ Mosees tób, sét hẽ Eriij tób —näng mäh. (Dooh m' tadoo wät pé tak'ëp rabeỹỹm bong do hyb n'aa m', tii d' tawén edoo.) ");
INSERT INTO mbjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti m' Peed ber'oot nä bä m' wë puh ganyyh. Sahõnh hẽ sa hã wë puh hadoo do badäng bä m' Jesus ma matëg rabeỹỹm bong mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wë puh gó m' P'op Hagä Do ber'oot. Hahỹỹ d' mä ta kyyh: —Hahỹ tah ỹỹ, ỹ h'yyb däng doo. Bë maa newë, bë ky dahé ta kyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tii bä m', kyyh hadoo do ky dawuh bä m', rabaheg'ããs, dooh boo m' Jesus pa hab'ëëh doo. Ta mab hẽ m' tabayyw gëët. Ti m' sa h'yyb gó m' rabenäm ta ti rahapäh doo, ramaa napäh doo. Dooh m' raher'ood bä ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti m' jati pé Jesus rabahyk bä kä m' waëë jó naa, hajõk kataa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ti m' hajõk do see ky ganyyh. Ti m' taky hadoo: —Ma matëg! —näng mäh. —Mahegãã tah ỹỹ. Jããm né hẽ sét had'os do tah ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Karap'aar h'yyb nesaa do ta hã adäk. Ta hã tadëë bä tak'ëp tah ỹ geëënh, tak'ëp tameraa wät, tũũ takepëëd had'yyt hẽ, tsanamäts däk tan'oo bä. Dooh tahyb n'aa eréd bä, tak'ëp tarejãã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—Ỹ eaaj wät a ma matëg sa hã rabahabëë hõm hyb n'aa. Dooh rahaja bä —näng mä ta kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ti m' Jesus ky hadoo: —Baad P'op Hagä Do hã h'yy kana'eeh do bëëh, da hẽ badäk hahỹỹ bä habok doo! Baad nado bë h'yyb tym —näng mäh. —Hajõõ nuu me ỹ bawät nä g'eeh bë mahang bë ky dahé däk hyb n'aa kä? Ỹ hãd h'yyb napan däg bë hã, hã ỹ bë h'yy kanasadä nä do hyb n'aa —näng mäh. —Mamana b'ëëp a t'aah —näng mä aj'yy hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ti m' ramanaa bä m', karap'aar h'yyb nesaa do pahëëw tadawäts jat tũũ. Meraa wät mäh. Tũũ m' takawereem, kawereem, kawereem jat mäh. Ti m' karap'aar h'yyb nesaa do Jesus geǟm wät tabanyyh hyb n'aa. Ti m' pahëëw tabahaso däk. Ti m' Jesus bahaëëj gëët ta yb hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tak'ëp mä sahõnh hẽ rameuunh P'op Hagä Do mo haj'aa hã. Jesus mo haj'aa hã sahõnh hẽ rameuuj bong bä m', Jesus ky hadoo ta ma matëg sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Baad bë hyb n'aa matakä da bë ỹ maher'oot doo: Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da ran'oo däk da ta wób sa moo gó —näng mä Jesus ta ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dooh m' rah'yy genä bä ta ti Jesus edoo do sa hã. Dooh m' rahapëë bä ta ti tedoo do sa hã. Kejën do hadoo mä sa hã. H'yyb e'ỹỹm mä rawén neaanh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ti m' ta ma matëg ky ked'aak mä ny hadoo do sa mahang hyb n'aa jawyk ta wób sa bahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus h'yyb hap'ëëh mä sa h'yyb, ti hyb n'aa m' karapee t'aah ta moo takyg gëët ta pa. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ti m' taky hadoo: —Hëp ỹ n'aa hahỹ karapee t'aah gadoo péh, ỹ né ti tagadoo —näng mäh. —Ỹ gadoo péh, hã ỹ mejũũ do tagadoo. Tii d' ỹ wén edoo, tak'ëp hyb n'aa sakog is do bë mahang, ti né da hyb n'aa jawyk P'op Hagä Do matym gó —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ti m' Jowãw ky hadoo: —Ma Matëg! —näng mäh. —Ãã hapäh aj'yy a häd tabesok bä tahebë karap'aar h'yyb nesaa doo. Ër h'yyb hata nado tii, ti hyb n'aa ãã ge'ỹỹm tii d' tanad'oo hyb n'aa —näng mä Jowãw kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ti m' Jesus ky hadoo sa hã: —Bë geǟm manäh! —näng mäh. —Bë wë h'yy kawanereem doo, bë h'yyb hata tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tabedaa däk bä m' p'aa hẽnh Jesus basëëk do hỹ pong jé, Jerusarẽnh hẽnh tabahõm tah'yyb däng mäh, tahapëë né paawä m' rarejãã t'ĩĩ hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ramahõm me m' tamejũũ ta panäg n'aa ta pooj jé, takajaa hyb n'aa ta tii bä. Tamejũũ mä Samarija häj n'aa panang s'ee hẽnh rabenäm hyb n'aa ta pooj jé, takajaa hyb n'aa tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dooh m' panang buuj ragado bä, Jerusarẽnh hẽnh Jesus bahõm do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ti m' Tsijaag Jowãw daheeh raky n'aa napäh bä Jesus raganadoo do ky n'aa, raky hadoo Jesus hã: —Ãã wahë n'aa —näk mäh. —Makarẽn p'op naa tëëg hõõ ãã mejõ hyng ragawatsik hyb n'aa? —näk mäh, reaanh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ti m' duu hẽnh Jesus ty kawareem wät, ti m' taky geǟm bong tii d' rahyb n'aa newëë do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ti m' panang s'ee hẽnh kä Jesus bahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ti m' ta tyw n'aa me ramahõm me aj'yy see ky hadoo ta hã: —Õm ỹ hadaa had'yyt hẽ mahahõm hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ti m' Jesus ky hadoo ta hã: —Kanari tób näng, taw'ëëd maag enäh. Ỹỹh Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, dooh tóp ỹỹ pé ỹ yd kameh'ããk péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ti m' aj'yy see Jesus bats'yyt: —B'ëëp ana si ỹỹ, hëp ỹ hata mabahadoo hyb n'aa —näng mäh. Ti m' aj'yy ky hadoo: —Pooj jé dó ỹ abaaj hõm Ee wë ỹ bahag'ããs hyb n'aa. Tadajëp jawén paa bä kä, ỹ dakä jëng jawén paa bä kä õm ỹ bahadaa kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ti m' Jesus ky hadoo ta hã: —Na hã ỹ h'yy kana'eeh doo, dejëp do hadoo doo, dakëë sa da hadoo doo —näng mäh. —Õm tii kä, ỹ karẽn maher'ood ta wób sa hã P'op Hagä Do bag'ããs do ky n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ti m' aj'yy see ky hadoo: —Õm da ỹ hada wahë ỹ n'aa. Pooj jé ỹ karẽn paawä ỹ babaaj hõm wakãn haa, ee, ëën ỹ kedëë wät hyb n'aa —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti m' panyyg gó m' Jesus ky gadoo: —K'ããts wapën n'aa booj yb takyyk doo me du doo do moo wät doo, ta jawén p'aa hẽnh tahegãã bä, nas'aa däg tamo haj'aa. Ti hadoo né hẽ jé du doo do ỹ hada doo, tii bä ta see hã tahyb n'aa newë bä, dooh tahaja bä tamoo wäd bä P'op Hagä Do bag'ããs do hã —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ti m' ta ti jawén paa bä 72 ta ma matëg wób Jesus asëëw hõm mäh. Pawóp hẽ ken'yyh mä tamejũũ ta pooj jé, ta wób sa panang hẽnh tabahõm doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rabahõm do pooj jé taky hadoo sa hã, panyyg gó m' tamaher'oot: —Hajõng ti anyy däg paawä joom ag wah'ëë däk do ji ataa do pan'aa, pawóp its ta taa n'aa —näng mäh. —Ti hyb n'aa taw'ããts hẽ joom danäh hã, P'op Hagä Do hã, bë ky n'aa ets'ẽẽ tamejõ nä ta wób joom hã ramoo bok hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sa mahang bë ỹ mejũũ, b'éé tabanas'aa mahang habëëh do hadoo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—Dooh d' bë mahũũm dajẽẽr hadoo doo, ta hood hadoo, tsyym suun ta gó bë gawät do jawén buuj hadoo doo —näng mäh. —Bë kehewad manä bë kedëng do hã ta hõõ bä —näng mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ti m' taky hadoo ẽnh: —Bë nu kajäg bä ta wób tób bä, hahỹỹ da bë edëë ta yt hã haj'eenh doo: “Bë P'op Hagä Do h'yyb n'yym”, denoo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tii bä haj'eenh do baad rado bä, hanäm gó bë ragado bä, P'op Hagä Do h'yyb n'yym do aym sa wë bë kedëng doo. Hanäm gó bë raganado bä, dooh da P'op Hagä Do h'yyb enäw bä tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Panang bä bë kajaa bä, bë kahỹỹd manä tób wób hẽnh. Bë ayyw jeej da bë gadoo do tób bä. Taw'ããts hẽ bë eëëk, bë awa, bë awëë bë hã ranoo doo. Taw'ããts hẽ moo bok do sa hã ramoo bok do säm ji banoo. Ti hyb n'aa, bë nu mebyy manä bë gadoo do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Panang bä bë kajaa bä kä, bë ragado bä, bë hyb n'aa sëëw manä bë waa. Taw'ããts hẽ bë awa, bë awëë bë hã ranoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nahëë enäh doo, bë nahëë sog hõm. Hahỹỹ da bë her'oot sa hã: “Edah bë hã P'op Hagä Do bag'ããs doo”, denoo da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Panang bä bë kajaa bä, bë raganado bä, bë ahõm panang tyw n'aa me. Hahỹỹ da bë maher'ood sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ãã tsyym suun ãã tepyng padëëk bë panang k'ããts, P'op Hagä Do bë ganadoo do heen n'aa tii. Bë ãã maher'oot hỹỹ kä: P'eets hẽ paawä P'op Hagä Do bag'ããs do bë wë, dooh paawä bë gado bä.” Tii da bë kyyh sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Baad bë ỹ maher'oot. Sahõnh hẽ badäk hahỹỹ hã habong do P'op Hagä Do ky n'aa etyy noo gó kä, Sodoma panang buuj sa säm bahǟnh P'op Hagä Do anoo da nesaa doo, bë ganadoo do panang buuj hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ti m' panang Korasĩn, Betsaj-Da häd enäh do buuj ky n'aa taher'oot mäh: —Nesaa do P'op Hagä Do anoo da bë hã Korasĩn, Betsaj-Da panang buuj. Hajõng ỹ pehuunh do paa bë mahang. Dooh ỹ bë ky dahé bä. Panang Tiir, Sidõn häd enäh doo bä ỹ pehuuj bä paawä bë mahang ỹ pehuuj wät doo, p'ooj ub paawä ti buuj nesaa do hã rat'yyd kamehĩĩn paawä, P'op Hagä Do hã rah'yy kawereem paawä. P'ooj ub paawä saroor hebaan do hejooh do rapadadäg né paawä. Rehaa paawä sa nuu hã tëëg ooj rat'yyd kamehĩĩn do heen n'aa paawä ti ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sahõnh hẽ badäk hahỹỹ hã habong do P'op Hagä Do ky n'aa etyy noo gó kä, Tiir Sidõn buuj p'ooj ub habong do nesaa do ta säm bahǟnh P'op Hagä Do anoo da bë hã nesaa doo, bë t'yyd kamanehĩĩn do hyb n'aa, bë h'yy kawanereem do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bëëh, Kapar-Naũm panang buuj, hỹ pong jé has'ëëk bë ed'oo g'eeh bëëh? Dooh. Tabanesaa hẽnh bë bahyk da P'op Hagä Do an'oo bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ti m' ta ma matëg sa hã taky hadoo: —Bë her'oot do maa new'ëë doo, ỹ né hẽ ti tamaa newëë. Bë ty n'aa ges'yyk doo, ỹ né hẽ ti taty n'aa ges'yyk. Ỹ ty n'aa ges'yyk doo, hã ỹ mejũũ do taty n'aa ges'yyk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tii bä m' 72 hadoo do rababaaj nä bä m' Jesus wë, h'yyb tseb'ee doo me m' ramaher'oot ta hã rabeboo nä do ky n'aa. —Ma matëg —näk mäh. —Karap'aar h'yyb nesaa do sii hẽ m' ãã raky daheeh a ky gabuuj gó —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—Ỹỹ. Ỹ hapäh —näng mä Jesus. —Matym ỹỹ gó Nesaa Do Yb het'oom do hadoo tabadëë hyng ỹ hegãã bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bë hã ỹ an'oo däk bë bahajaa hyb n'aa aw'yy, sëëj bë tseb'eep hyb n'aa. Bë hã ỹ an'oo däk bë bahajaa bë nes'ëëm hyb n'aa Nesaa Do Yb, ji majĩĩ. Dooh tahaja bä nesaa do tan'oo bä bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Taw'ããts hẽ bë tsebee manä karap'aar h'yyb nesaa do bë raky daheeh do hyb n'aa. Taw'ããts hẽ bë tsebé bë häd kerii däk do hyb n'aa hỹ pong jé, P'op Hagä Do karapee sa häd kerih do heen n'aa hã —näng mä Jesus 72 hadoo do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti noo gó kä m', baad Jesus P'op Hagä Do Sahee h'yyb tsebee kän. Tsebee gó m' taky hadoo: —Ee, P'op Hagä Doo, a hã ỹ j'aa etsë. Sahõnh hẽ hỹ pong jé, badäk hahỹỹ hã hanäng do na-ããj hẽ mabag'ããs. Majejën hahỹ mamoo wät do haj'ap do sa mahǟnh, tak'ëp ma kamet'ëëk do mahǟnh. Mametä wät sa h'yyb gó karapee hadoo pé hã, baad h'yy ka'eeh pé hã. Ta tii da magen'aak Ee —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ti m' taky hadoo sa hã: —Sahõnh hẽ Ee banoo ta hejój hã ỹỹ. Dooh baad hapäh pé ỹỹh, P'op Hagä Do T'aah. Jããm né hẽ Ee hapäh ỹỹh. Dooh Ee, P'op Hagä Do baad hapäh péh. Jããm né hẽ ỹỹh, ta T'aah hapäh. Jããm né hẽ sa hã ỹ metëëh do hapäh Ee —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ti m' ta ma matëg wë taty kawõõt. Ta m'aa hẽnh tamaher'oot: —Ky n'aa kedëng bëëh, hahỹ bë bahapäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Baad bë ỹ maher'oot: Rababong noo gó, hajõk P'op Hagä Do ky n'aa rod makũũh, hajõk sa wahë n'aa hedoo do makũũh, rakarẽn paawä raheg'ããs bë hapäh doo, dooh paa rahapëë bä. Rakarẽn paawä ramaa newëë bë maa newëë doo, dooh paa ramaa napëë booh —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ti m' ta see pé noo gó baad Mosees ky n'aa jaw'yyk do hapäh do as'ëëg gëët mä Jesus tametyy hyb n'aa. —Ma matëg —näng mäh. —Nyy da ỹ bad'oo edëb had'yyt do ỹ gadoo hyb n'aa, hỹ pong jé P'op Hagä Do pa ỹ bawäd had'yyt hyb n'aa ỹ dajëp bä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti m' Jesus ky hadoo ta hã: —Ny hadoo P'op Hagä Do ky n'aa jaw'yyk do hã takerih ti ky n'aa? —näng mäh. —Nyy da ta hã maner'oot doo? —Jesus eaanh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ti m' aj'yy ky hadoo: —Hahỹỹ da takerii däk: “Taw'ããts hẽ tak'ëp bë kamahǟn Tak'ëp Hyb N'aa Jawyk Doo, P'op Hagä Doo, bë h'yy kaha'eeh doo. Taw'ããts hẽ tak'ëp bë h'yyb padäg ta hã. Taw'ããts hẽ bë h'yyb tym gó naa né hẽ bë kamahǟn ta hã, sahõnh hẽ bë hajaa doo me.” Hahỹỹ da na-ããj takerii däk —näng aj'yy: “Makamahǟn a da hadoo doo, a hã makamahǟn doo da” —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ti m' Jesus ky hadoo: —Baad ub a kyyh, baad maky gadoo —näng mäh. —Taw'ããts hẽ tii d' né hẽ madoo, tii bä baad mabawäd kän hỹ pong jé kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ti m' aj'yy karẽn paawä tajejën ta h'yyb j'ooj madäk doo me m' ti takeaj wäd paawä. Ti hyb n'aa m' Jesus hã tabeaanh ta seeh: —Jaa tii da ỹ hadoo doo? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ti m' panyyg ky n'aa me m' Jesus ky gadoo: —Ti awät aj'yy panang Jerikó hẽnh hahõm doo. Jerusarẽnh bä naa tabana. Ta tyw n'aa me tamahõm me takataa moo nes'aa do sa hã. Ramaso däk, rarahejãã mäh. Rasaroor kabo nyyh mäh, rahewyyh mäh. Tii bä m' radejaad hõm ta tyw n'aa noo däk bä. P'eets mä tadajëb paawä sa moo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ti m' aj'yy P'op Hagä Do tób n'aa yt hã moo heb'ooh do see tii me m' tamahõm. Aj'yy tabahapäh bä m', dawëë takenaa wät ta mahǟnh. Ta tyw n'aa nu masee me m' tatabës. Dooh m' tat'yyd mehĩĩn bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ti hadoo né m' ta seeh. Rewi häd näng do panaa né tii. Tii me né m' tamahõm tii d' ẽnh. Ti na-ããj mä dooh tat'yyd mehĩĩn bä aj'yy tyyw me hajad hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ti m' tagadëëg ub aj'yy, Samarija buuj, bana. Ti m' ti t'yyd mehĩĩn kän aj'yy. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta wë m' tabahõm, ti m' ta rog taty mebiin ta syyj hadoo doo me, uwa s'ëëb hadoo doo me. Ti m' ta rog maw'yyd däk mäh. Ti m' aj'yy batóg sooh ta mas'ãã jó. Ti m' tamahũũm kän dawëë hena do tób n'aa bä. Tii bä m' aj'yy tabahagãã kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jati pé kä m' tets'ëë däk mä tób danäh hã pawóp hẽ moweed k'ããts hawak do s'ëëb. Ti m' taky hadoo ta hã: “Mahagãã hahỹ aj'yy. Hỹ ta säm. Ta säm nahaja bä, ỹ matëëh bä sahõnh hẽ ỹ ep'aak a hã”, näng Samarija buuj kyyh tób danäh hã —näng mä Jesus. Panyyg gó m' tabaher'oot ta tii hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ti m' Jesus eaanh: —Ny hadoo do ky enyym a hã, ta ti rarejãã do hã? Ny hadoo do ta da hadoo a hã? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ti m' Mosees ky n'aa jaw'yyk do baad hapäh do ky hadoo: —T'yyd mehĩĩn doo —näng mäh. Ti m' Jesus ky hadoo ta hã: —Ahõm nä, tii d' né hẽ mabadoo kän a da hadoo do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ti m' Jerusarẽnh hẽnh Jesus ramahõm me, panang see bä m' ranu kajäg kän. Ta tii bä m' ỹỹnh Maah-Ta häd näng do gadoo. Tats'yyt mä ta tób hẽnh Jesus ta ma matëg daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maah-Ta ǟnh, Marija häd näng do asooh mäh. Jesus ma metëëk do tamaa newëë mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maah-Ta m' ty kanewaat. Ta waa n'aa m' tamoo wät Jesus rawa do pan'aa. Ti m' Jesus wë tabana ti m' taky hadoo: —Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Nepäh a hã, dooh ǟnh ỹỹ ỹ tamoo masaa bä? Mamaher'ood ỹ tamoo masa hyb n'aa —näng mä Maah-Ta. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ti m' Jesus ky hadoo: —Maah-Ta, —näng mäh —hajõng do hã maty kanewaat. Tii hã mah'yyb däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—Mahyb n'aa tón manä ta tii hã. Jããm né hẽ sét hẽ ti taw'ããts hẽ. Ta tii hã Marija h'yyb däk. Dooh da ỹ mejõ bä ta ti teréd hõm —näng mä Jesus Maah-Ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti m' ta see pé noo gó Jesus ky n'aa etsẽẽ mä P'op Hagä Do hã. Tabahajaa bä kä m' taky n'aa etsẽẽ doo, ta ma matëg see ky hadoo ta hã: —Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Ãã mama met'ëëg nyy da ër ky n'aa etsẽẽ, Jowãw nu gahem'uun do ta ma matëg tama metëëk doo da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ti m' Jesus ky hadoo sa hã: —Bë ky n'aa ets'ẽẽ bä, taw'ããts hẽ hahỹỹ da d' bë kyyh: “Ee, ãã karẽn sahõnh hẽ õm rahyb n'aa jew'yyk. Ãã etsẽẽ a hã, sahõnh hẽ mabag'ããs do nayyw hẽ takajaa hyb n'aa ãã wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Man'oo had'yyt hẽ ãã waa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mamabaan hõm nesaa do ãã moo bok do paah. Ãã na-ããj hẽ ãã mabaan hõm ãã wë moo bong do nesaa doo. Man'oo manä nesaa do ãã tah'yyb tatug”, näk da bëëh, bë ky n'aa ets'ẽẽ bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ti m' panyyg ky n'aa me m' tamaher'oot sa hã ji ky n'aa etsẽẽ do ky n'aa: —Bë see ahõm bä atsëm ub ta najiis tób hẽnh, pãw tets'ẽẽ bä paawä ta wë, ta wë heg'ããs do waa n'aa paawä, hahỹỹ da ta kyyh ta najiis hã: “Na a waa uuh, pãw uuh. Tamawoob hẽ paawä ỹ karẽn. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Najis ỹ kajaa nag'aap hẽ wë ỹỹ atsëm ub. Dooh wë ỹ ta waa péh”, näng da. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tii bä da ta najiis tób gó ta gawakõ gó hagä do ky gedak ta hã: “Ỹ maty hasyyg manäh. Baad tób noo gatsëë däk ta tëg me. Ãã aj'eenh tah haa daheeh. Dooh ỹ haja bä ỹ an'oo bä a hã metsẽẽ doo”, näng da ta najiis ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ti m' Jesus ky hadoo: —Bë ỹ maher'oot —näng mäh. —Tii d' edo né paawä as'ëëg gëët né hẽ, pãw tabanoo hyb n'aa ta najiis hã. Ta najiis tabadoo do hyb n'aa nado ti tabas'ëëg gëët. Tawén s'ëëg g'ëëd kän, tanaëëj had'yyt ta h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ti hyb n'aa bë ỹ maher'oot: Bë ets'ẽẽ, tii bä P'op Hagä Do anoo bë hã. Bë esóts, tii bä bë aw'yyt da. Bë naëëj tób noo bä naa, tii bä da ta danäh noo gas'ëës. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jé hetsẽẽ do gadoo da P'op Hagä Do hanaa. Jé hesoos pé taw'yyt P'op Hagä Do hanaa. Jé tób noo bä naa naëënh péh, tób noo kas'ëës da ta hã P'op Hagä Do hanaa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ti m' Jesus eaanh sa hã: —Bë t'aah ets'ẽẽ bä tah'ỹỹb, bë anoo ta hã aw'yy? ");
INSERT INTO mbjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Karaak tyb bë hã tets'ẽẽ bä, sëëj bë anoo ta hã? Dooh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nesaa do moo heb'ook do né paawä bëëh, baad hadoo do bë heno bë taah hã. Ti bahǟnh bë Yb hỹ pong jé hawät do anoo da ta Sahee, ta hã hetsẽẽ do hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti m' ta see pé noo gó, karap'aar h'yyb nesaa do Jesus habëë hõm ner'oot do hã hadäk do paah. Aj'yy karap'aar h'yyb beréd hõm bä, aj'yy er'ood däg kän p'aa hẽnh. Hajõk do t'ĩĩ hẽnh kat'aa do rahyb n'aa meuunh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta wób raky sëm Jesus. Ti m' raky hadoo: —Beresebu, karap'aar h'yyb nesaa do wahë n'aa kyy gó ti tabahebë karap'aar h'yyb nesaa doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta wób rakarẽn mä Jesus rametyy, P'op Hagä Do hejój me tado bä tamoo wät doo. Ti hyb n'aa rabetsẽẽ mä Jesus hã, tapahuuj bä sa matym haj'aa wë hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus hapäh mä sa h'yyb, ti m' panyyg ky n'aa me taky hadoo sa hã: —Nesaa do Yb kyy gó ỹ hebë karap'aar h'yyb nesaa doo, bë nooh. Nyy d' tii éh? Sa da hadoo do wë sa häj n'aa babuuj rahyb n'aa wareem bä, gawatsik tii bä sahõnh hẽ —näng mäh. —Sa wakããn sa hã hẽ rahyb n'aa wareem bä, sahõnh hẽ kahäj jëng tii bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","—Ti hadoo ẽnh Nesaa Do Yb hã kä. Ta hã hẽ takawareem bä, ta karapee hã tahyb n'aa wareem bä, nayyw hẽ tabahëëj jëë paawä tii bä Nesaa Do Yb bag'ããs doo. Ta ti ỹ wén her'oot, Beresebu kyy gó ỹ hebë karap'aar h'yyb nesaa do bë her'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bë her'oot doo da tado bä, Beresebu kyy gó ỹ hebëë bä paawä karap'aar h'yyb nesaa doo, jaa ky gabuuj bë karapee hebë do karap'aar h'yyb? Bë karapee né da bë raky n'aa etyy, daap bë menyyh do hyb n'aa bë her'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","P'op Hagä Do ky gabuuj gó né hẽ ti ỹ hebë do karap'aar h'yyb nesaa doo. P'op Hagä Do ji tabag'ããs do kaja doo kä bë wë, ta ti metëëh bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ti m' panyyg ky n'aa see me m' Jesus maher'oot sa hã: —Aj'yy hejoonh do hajõng ta kuman yt hã ta tób tahagãã bä, dooh ta ma hado hõm péh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ti aj'yy seeh, ta bahǟnh hejoonh do kajaa bä ta wë, ta säm tam'aah tii, ta hã taj'aa ketsë. Ta kuman paa tasog hõm, ta mejój paah. Tii bä kä, ta ma paa tabasog hõm kän, tets'ëë bong ta wób hã kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Hëp ỹ hata nadoo doo, majẽ ỹ tii. Ỹ manasa doo, P'op Hagä Do wë ỹ ataa doo, dawëë rabehũũm tii bä tan'oo bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ti m' Jesus ky hadoo ẽnh: —Karap'aar h'yyb nesaa do aj'yy hã, ỹỹnh hã hadäk do paa ahõm wäd bä ta mahǟnh, tabanawäng hẽnh tabahew'ëët. Ta tób tabesoos takameh'ããk hyb n'aa. Ti dooh tawyyd bä. Ti ta h'yyb gó taky hadoo: “Ỹ abaaj hõm p'aa hẽnh ỹ hadäk do paa hã, tóp ỹỹ hẽnh”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tii bä ta tób paa bä takajaa bä, yd kabak'ood däk tabahapäh, baad takabenäm ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tii bä tats'yyt 7 karap'aar h'yyb nesaa do wób ta hataa, ta bahǟnh nesaa doo. Tii bä rabajëë pëë ta tób paa gó. Tii bä rabanyy kän ta hã kä. Ta hã hanäng do paa bahǟnh tii kä. Tak'ëp tii kä ta hã kä nesaa doo kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ti m' Jesus ber'oot bä m', hajõk do mahang ỹỹnh see ky ganyyh: —Ky n'aa kedëng ta ti a ỹỹn õm haw'ëëh doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ti m' Jesus ky hadoo: —Ta bahǟnh ky n'aa kedëng, P'op Hagä Do kyyh maa newëë doo, ky daheeh doo —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti m' hajõk do gatat'uuk bä m' ta hã, Jesus ky hadoo: —Da hẽ, badäk hahỹỹ hã habong doo, nes'aa sa h'yyb. Ti hadoo né hẽ, ỹ ramejũũ ỹ pahuunh hyb n'aa sa matym haj'aa. Dooh da ỹ metä bä sa hã. Jããm né da P'op Hagä Do ky n'aa rod Jonas häd näng do ta metëë n'aa hadoo sa hã kametëëh da. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonas hã P'op Hagä Do bad'oo do hã, Niniwéh buuj rah'yy genä hõm, P'op Hagä Do né ti mejũũ. Ti hadoo né da hã ỹỹ, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do hã rah'yy genä hõm da, P'op Hagä Do né hẽ ti ỹ tamejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Seba häd näng do häj n'aa sa wahë n'aa ỹỹnh, da hẽ, badäk hahỹỹ hã habong do taky n'aa tapaa da P'op Hagä Do matym gó, sahõnh hẽ P'op Hagä Do ky n'aa etyy noo gó kä. Dawëë naa paa m' tabana tii, tamaa newëë hyb n'aa Saromãw hajaa doo, P'op Hagä Do anoo do ta hã. Saromãw bahǟnh ỹ ti hahỹỹh, bë hapäh doo. Ti hado né paawä, dooh bë karẽn bä bë maa newë bä hahỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwéh buuj na-ããj da raky n'aa tapaa né tii da ẽnh ti noo gó kä, da hẽ badäk hahỹỹ hã habong doo. P'op Hagä Do ky n'aa rod Jonas sa hã taher'oot noo gó, rat'yyd kamehĩĩn nesaa do ramoo bok do hã. Nesaa do reréd hõm. Hahỹỹh, Jonas bahǟnh ti ỹ hỹỹh. Bë tii, dooh bë t'yyd kamehĩĩn bä nesaa do bë moo bok do hã, dooh bë eréd bä —näng mä Jesus hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ti m' Jesus ky hadoo: —Dooh ji bag ji gataa bä ji jejën hyb n'aa. Dooh ji daso bä ji waa hood yt hã. Dooh. Ta bag ji dasooh ta tyng jó, tób gó hajëë p'ëë do rabahapäh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ji h'yyb bag hadoo ji matym —näng mäh. —Baad tado bä ji matym, ta bag hado däk sahõnh hẽ ji hã. Baad tanado bä ji matym, badagyp hadoo ji hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Baad bë hyb n'aa matakä, ta bag hadoo bë hã hanäng bë ed'oo doo, badagyp do tanadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bë h'yyb tym gó ta bag hadoo do baad tabawag däg bä, badagyp do hadoo do tanado wäd bä, sahõnh hẽ tii bä tabawag däk ji hã, ta bag hadoo do mehǟnh ji hã —näng mä Jesus kyyh. Panyyg gó m' tabeh'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ti m' Jesus baher'oot do bahänh bä kä, Pariséw see ats'yyt mäh, ta tób hẽnh tabawëh hyb n'aa. Ti m' Jesus bahõm kän mä ta tób hẽnh, ti m' tabasooh, sa sii tabawëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ti m' tób danäh hyb n'aa meuunh mä Jesus basooh do hyb n'aa, tabawa hyb n'aa ta si n'aa hẽ. Dooh m' ta moo tahetsyyd bä sa wahë makũ rabahed'oo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ti m' Jesus ky hadoo ta hã: —Bë Pariséw —näng mäh. —Ji waa hood ta gó hasus doo, ta jó ub ji hets'yyt do hadoo bëëh. Baad bë babok P'op Hagä Do matym gó ji ed'oo. J'ooj madäk doo me tii. T'õp, bë h'yyb gó, tak'ëp bë karẽn do jawén bë babok. T'õp bë h'yyb tym gó, hajõng nesaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bë h'yy gatemah —näng mäh. —Ji hub pahuunh doo, ji h'yyb tym na-ããj hẽ tapahuunh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Taw'ããts hẽ bë h'yyb gó naa, t'õp naa, bë masaa kas'uut do sa hã, tii bä kä, P'op Hagä Do hã baad ub tabanäm sahõnh hẽ bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Baad nado bë hã da, Pariséw —näng mäh. —Bë waa ty gamabuuj uuh sii hẽ né paawä bë banoo P'op Hagä Do matym n'aa, dooh paawä baad hadoo do bë moo boo bä bë da hadoo do hã, bë mabaan P'op Hagä Do hã bë kamahǟn doo. Taw'ããts hẽ paawä dooh bë mabaan bä ta tii. Taw'ããts hẽ P'op Hagä Do matym n'aa bë banoo na-ããj hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Baad nado bë hã da, Pariséw —näng mäh. —Bë gen'aak hyb n'aa jewyk do bat'oonh bä bë atooj bä, tób P'op Hagä Do panyyg rayd naherot doo bä. Bë gen'aak bë redëng, bë raweh'ëëh, hajõk do mahang rakahet'aa bä, rabahesäm bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Baad nado bë hã da, Pariséw —näng mäh. —Kamag hood ta jó ji tsab'eep bä ji nahapäh do hadoo bëëh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ti m' Mosees ky n'aa jaw'yyk do baad hapäh do see ky hadoo ta hã: —Ma matëg —näng mäh. —Ta ti mapes'ããp doo, ãã na-ããj hẽ mapes'ããp —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ti m' Jesus ky hadoo: —Baad nado bë hã da Mosees ky n'aa jaw'yyk do baad hap'ëëh doo —näng mäh. —Hajõng hejoonh do bë mejũũ ta wób raky daheeh hyb n'aa. Ti bahǟnh bë bawëëd däk Mosees ky n'aa jaw'yyk doo. Ti hadoo né hẽ, dooh tabad'op hẽ bë masaa bä bë mejũũ do rabahajaa hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Baad nado bë hã —näng mäh. —P'op Hagä Do ky n'aa rod, p'ooj ub habong do bë wahë makũ radej'ëëp do sa kamag n'aa hood pä s'ëëb, bë tema. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ta ti tametëëh, bë wahë makũ h'yyb hadoo bëëh. Bë wahë makũ né hẽ dej'ëëp P'op Hagä Do ky n'aa rod paah. Hỹỹ kä bë temaa toonh ji hyb n'aa esee do heen n'aa sa kamag n'aa hood jó. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hahỹỹ d' né hẽ P'op Hagä Do baher'oot ta hapäh doo gó bë ky n'aa: “Sa mahang ỹ mejũũ da këh ỹ n'aa rod, panäk ỹ na-ããj né hẽ. Sa wób né da radej'ëëp, ta wób da rarejãã”, näng paa m' P'op Hagä Do kyyh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ti m' Jesus ky hadoo ẽnh sa hã: —Ti hyb n'aa da bë hã, da hẽ habong do hã kä, P'op Hagä Do ban'oo kän sahõnh hẽ ta ky n'aa rod radej'ëëp do paa säm kä. P'ooj ub, badäk hahỹ tadu dahäng jawén paa bä radej'ëëp doo, ");
INSERT INTO mbjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abéw Kaĩh nabooh noo gó du däk do né hẽ. Tii kä, tagadëëg ub, Sakarija radaj'ëëp doo kä. Ti radaj'ëëp paa m' rama ejuu do tyng, P'op Hagä Do tób n'aa ganahaang gó. Baad ỹ her'oot bë hã, da hẽ habong do sa hã kä P'op Hagä Do ban'oo kän sahõnh hẽ radej'ëëp do säm kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Baad nado bë hã Mosees ky n'aa jaw'yyk do baad hapäh doo —näng mäh. —Dooh bë karẽn bä ta wób raky n'aa napëë bä P'op Hagä Doo. Tób noo tëg ji jejën do hadoo sa mahǟnh, ranajëë p'ëë hyb n'aa hadoo bëëh. Bë né hẽ, dooh bë karẽn bä bë ajëëh, dooh P'op Hagä Do bë hapëë bä. Ta wób, karẽn do hajëng doo, bë ge'ỹỹm ranajëng hyb n'aa, P'op Hagä Do ranahapäh hyb n'aa —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ti m' Jesus banyyh bä kä m', tak'ëp mä Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ rakawajããn ta wë. Hajõk mä gatatug däk, tak'ëp mä rabeaanh. Kawaj'ããn gó m' rabeaanh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Rakarẽn paawä m' raw'yyt taher'oot do hã raganen'aak doo, raky n'aa tapaa hyb n'aa Mosees ky n'aa jaw'yyk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti noo gó m', hajõk rakata b'ëëh mä Jesus wë. Hajõk né hẽ ti kahet'aa doo. Hajõk do hyb n'aa, ta wób sa tsyym mä rabep. Ti m' ta ma matëg sa hã Jesus ky hadoo: —Baad bë hyb n'aa matakä da. Baad bë kanä da Pariséw sa pãw makuj n'aa mahǟnh, j'ooj madäk doo me ji ky ken'yym do mahǟnh, ỹ hanäng péh tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Dooh ji haja bä ji jejën bä ji h'yyb. Sahõnh hẽ ji h'yyb P'op Hagä Do hapäh. Ti awät da ti noo gó, sahõnh hẽ ji jejën doo P'op Hagä Do metëëh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Atsëm, kejën do hadoo ta wób ramaa nanapäh bä bë her'oot doo, adëb bä kä, sahõnh hẽ maa napäh bä takaher'oot da ta jawén, P'op Hagä Do an'oo bä. Kaja hẽ ta gawakõ gó kahesëënh do ta see hã, tak'ëp da takaher'oot tii kä, sahõnh hẽ ramaa napäh hyb n'aa. Ti hyb n'aa, bë hyb n'aa matakä ti bë her'oot doo! ");
INSERT INTO mbjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Najis haa, bë jeỹỹm manä ji majĩĩ ji daj'ëëp do hã. Jããm né hẽ ji hub rahajaa radajëëb bä. Ji h'yyb tym dooh rahaja bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ỹ maher'oot bëëh, ny hadoo do bë jeỹỹm. Taw'ããts hẽ P'op Hagä Do ji jeỹỹm. Ti ti hajaa ji tadaj'ëëp do jawén paa bä, ji h'yyb tym taw'oong hõm kän tabanesaa hẽnh. Ti hyb n'aa, ji hyb n'aa jaw'yyk, ji jeỹỹm P'op Hagä Doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Ji moo oow pé taw'ëëd taah, kanahën d'os hẽ rabesëëm is, ky n'aa ganebats. Ti hado né paawä, dooh sét had'os do sa see P'op Hagä Do mabaan bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti hyb n'aa, bë eỹỹm manäh. Hajõng taw'ëëd takamahǟn do bahǟnh bë P'op Hagä Do kamahǟn. Sahõnh hẽ ji sëën sii hẽ P'op Hagä Do betsén. Baad ji tabahag'ããs ỹ hanäng péh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ti m' Jesus ky hadoo ẽnh: —Baad bë ỹ maher'oot hahỹỹh: Këh ỹ n'aa najejën pé ta wób sa hã, ỹỹh, Aj'yy Hadoo Do Hỹ Pong jé Hana Doo, ỹ na-ããj hẽ, dooh ỹ ky n'aa jejën bä ta tii, ããs P'op Hagä Do pa hab'ëëh do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Këh ỹ n'aa jejën péh, ỹ na-ããj da ỹ ky n'aa jejën tii d' ẽnh, ããs P'op Hagä Do pa hab'ëëh do sa matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jé Aj'yy Hadoo Do Hỹ Pong jé Hana Do ky n'aa rejãã péh, P'op Hagä Do mabaan ti ta hã. P'op Hagä Do Sahee ky n'aa rejãã pé kä, dooh P'op Hagä Do mabaan bä, dooh tat'yyd mehĩĩn bä kä tii kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Bë ramoo maso däg bä, tób P'op Hagä Do panyyg rayd naherot doo hẽnh bë ramahũũm bä, sa wahë n'aa wób wë bë ramahũũm bä, hyb n'aa jewyk do wë na-ããj né hẽ, bë hyb n'aa tón manä bë her'oot do hã bë ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","P'op Hagä Do Sahee anoo da bë her'oot do pan'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ti m' hajõk do mahang ta see ky ganyyh: —Ma matëg —näng mäh. —Mamaher'ood hǟj ỹỹ, tabetyn hyb n'aa ãã yb wë naa —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ti m' Jesus ky hadoo ta hã: —Najis ỹỹ, ỹ nado ti hetyn bë hã bë yb ma paah —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti m' sahõnh hẽ sa hã Jesus ky hadoo: —Bë hyb n'aa matakä da, bë hyb n'aa nah'ũũm hyb n'aa bë ma, bë dajẽẽr. Ji ma tak'ëp hajõng do nado ji h'yy gadajang hanoo do babä ji awät bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ti m' panyyg ky n'aa gó m' tabeh'ũũm ta ti ky n'aa. Ti m' taky hadoo: —Hỹ hadoo aj'yy tak'ëp wekãp doo. Baad ta gëëw bä. Ti hyb n'aa baad né hẽ ta joom beaak. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ti ta h'yyb gó taky hadoo: “N'yy d' ỹ bad'oo hỹỹ kä?”, näng. “Gedẽ hõm joom ag tób n'aa”, näng ta kyyh. “N'yy hẽnh hỹỹ kä ta wób ỹ bataa?”, näng ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ti taky hado kän: “Ỹ hapäh. Hahỹỹ da ỹ bad'oo”, näng ta kyyh. “Ỹ apyn hõm dó joom ag tób n'aa”, näng ta kyyh. “P'aa hẽnh da ỹ tamaa sooh. Aeh da hỹỹ kä joom s'ëëb tób n'aa, ma ỹ tób n'aa na-ããj né hẽ”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Ỹ bahajaa bä kä”, näng, “hahỹỹ da d' këh ỹỹ hã ỹỹ hẽ”, näng “Hajõng wakãp ỹỹ. Dooh d' nayyw tahëëj bä. Hajõng da ta baab teh'ëënh wakãp ỹỹ hã”, näng. “Taw'ããts hẽ hỹỹ kä, ỹ kameh'ããk hỹỹ kä. Baad ỹ hỹỹ kä. Baad ỹ beëëk hỹỹ kä, baad ỹ bawa hỹỹ kä, ỹ tsebé hỹỹ kä”, näng ta ti aj'yy h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ti P'op Hagä Do ky hadoo ta hã: “H'yy gatamaa õm”, näng. “Badah atsëm da madajëp! Jaa wë tabayyw kän a ma paah?”, näng P'op Hagä Do kyyh aj'yy hã kä —tii d' mä Jesus baher'oot ji ma ky n'aa, ji dajẽẽr ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ti m' Jesus ky hado kän sa hã: —Ti hadoo né kä ta ti tak'ëp sa wak'ããb hyb n'aa h'ũũm do hã, P'op Hagä Do dooh rahyb n'aa es'ee bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ti m' ta ma matëg hã Jesus ky hadoo: —Ti hyb n'aa bë ỹ maher'oot hahỹỹh: Bë hyb n'aa tón had'yyt manä bë babok do hã, bë waa hã, bë saroor hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tii d' ỹ wén edoo, ji awa do bahǟnh ti ji edëp doo. Ji saroor bahǟnh ji. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bë hegãã taw'ëëd. Dooh rejoom bä joom tym. Dooh rata bä joom ag. Dooh sa waa tób n'aa rayd taa péh. Ti hado né paawä P'op Hagä Do anoo sa waa. Taw'ëëd P'op Hagä Do kamahǟn do bahǟnh bë takamahǟn! ");
INSERT INTO mbjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tak'ëp bë hyb n'aa newë had'yyt né paawä, dooh bë haja bä bë aboo dawëd bä ta tii da. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ta ti bë nahaja bä, nahejooj né paawä, h'ëëd hyb n'aa bë hyb n'aa newë had'yyt hẽ ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Bë hegãã tabawä n'aa ts'ooh —näng mäh. —Dooh né paawä ramoo boo bä, dooh né paawä sa saroor rages'yyb bä, Saromãw saroor anyyw né paawä, gabar'ëëng né paawä, ti bahǟnh tabanäm ti tabawä n'aa ts'ooh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tii da baad ub P'op Hagä Do adoo bä tabawä n'aa hã, nayyw hẽ tsawyy jëng do hã, ji gatang do hã, ti bahǟnh da P'op Hagä Do bahag'ããs bëëh. Tanoo né da bë hã bë saroor. H'ëëd hyb n'aa P'op Hagä Do hã baad bë h'yy kana'eeh? ");
INSERT INTO mbjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bë hyb n'aa newë had'yyt manä bë eëëk doo, bë awa doo, bë awëh doo. Bë hyb n'aa tón had'yyt manä ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","P'op Hagä Do sa h'yyb gó nahapäh do ti tii, ti hã h'yyb pad'ëëk doo. Bë ti dooh tii d' bë adoo bä. P'op Hagä Doo, bë Yb, hapäh bë wë bedoh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Taw'ããts hẽ baad bë h'yyb padäg bë Yb bag'ããs do hã. Tii bä kä, tanoo da bë hã sahõnh hẽ bë wë bedoh doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Bë eỹỹm manä b'éé taah nahejooj is doo. Hanäm gó bë Yb, hỹ pong jé hawät do tabanoo bë hã, ta sii bë bag'ããs hyb n'aa. Ti hyb n'aa, bë eỹỹm manäh, ỹ wén näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Taw'ããts hẽ bë esëëm hõm bë wë hanäng doo. Kas'uut do hã bë banoo bë ma paa säm. Tii bä kä, bë ma näng hỹ pong jé kä. Ta ti dooh tahëëj bä. T'ĩĩ hẽnh dooh retsëëg bä kä bë ma. T'ĩĩ hẽnh dooh kamera rejã bä kä bë ma. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta tii d' ỹ wén her'oot, tak'ëp bë kamahǟn do banäng bä, tii bä bë h'yyb bawät —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ti m' taky hadoo: —Taw'ããts hẽ bë h'yy kahasããb bë moo bok hyb n'aa, baad ub da bë gadaa had'yyt da, atsëm na-ããj hẽ bë gada, p'aa hẽnh ỹ bahyng bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Taw'ããts hẽ tób danäh karom, atsëm sa kariw n'aa raket'ëë hẽnh jäm n'aa baad gad'aa do hadoo da bëëh. Ta bag ahõõ had'yyt hẽ ran'oo bä. Ty gapad'ëëk ragada sa kariw n'aa, tanaëënh bä, nayyw hẽ ragas'ëës hyb n'aa tób, sa kariw n'aa bajëë suun hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Baad da gad'aa do sa hã, sa kariw n'aa kajaa bä kä raty gapad'ëëk do hyb n'aa —näng mä Jesus. —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Sa kariw n'aa ats'yyt da, rabat'oonh, rabawëh hyb n'aa. Tii bä da ta saroor see tah'ỹỹt, tii bä sa tä, sa waa taban'oo kän sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Taw'ããts hẽ da sa kariw n'aa awyyd bä ty gapad'ëëk do sa hã, atsëm ub takaja bä, tapaj'ëë bä takaja bä na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ti m' tabaher'oot ẽnh panyyg see ky n'aa me sa hã: —Bë hyb n'aa newë hahỹỹh: Tób danäh hapëë bä paawä hets'ëëk do kajaa bä, dooh paawä tan'oo bä hets'ëëk do ta tób tanoo eë nä bä. Baad paawä tagada. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ti hadoo bë hã. Taw'ããts hẽ baad bë hyb n'aa matakä, baad bë gadaa ta pooj jé. Ta ti ỹ wén her'oot, bë ganadaa bä Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa da p'aa hẽnh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ti m' Peed beaanh ta hã: —Ãã wahë n'aa —näng mäh. —Ãã hã ub ti mabaher'oot ta ti panyyg? Sahõnh hã ti mabaher'oot? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti m' Jesus ky gadoo panyyg see ky n'aa me m': —Ta ti ỹ maher'oot, sahõnh hẽ bë mahang ta kaser n'aa baad had'yyt hẽ ta kariw n'aa mejũũ do moo wät doo, h'yy ganäng do hadoo rabahadoo doo. Ta tii hã ta kariw n'aa banoo, ta karom tabahag'ããs hyb n'aa, sa waa tabetsëëh hyb n'aa sa hã, ta s'ee hẽnh ta kariw n'aa awäd nuuj jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Taw'ããts hẽ ta kaser n'aa hã, ta kariw n'aa awyyd bä ta mejũũ do hã moo wät doo, ta kariw n'aa matëëh bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta kariw n'aa weh'ëëh da ta ti hadoo doo. Sahõnh hẽ tahaëënh ta hã ta ma, ta ma hagã n'aa tabahado däk hyb n'aa kä. Né hup ỹ né hẽ ta ti ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hỹỹ kä, baad ta kaser n'aa moo nawäd bä paawä, ta h'yyb gó taky hado bä: “Dooh nayyw hẽ kariw ỹ n'aa kaja bä”, tanoo bä, karom wób tahewyh had'yyt bä kä, tatsebé do waa n'aa tamoo hewëëd bä, taoom bä jarakë hedoo do mahỹỹj, ");
INSERT INTO mbjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ti taganada bä né kä ta kariw n'aa kajaa da. Tahyb n'aa napeet bä kä takajaa. Tii bä, tak'ëp da ta kariw n'aa rejã kän da. Tanoo da ta kaser n'aa paa ahoop, P'op Hagä Do ky nadah'eeh do nesaa do rahoop doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Jé karom ta kariw n'aa ganada doo, ta kariw n'aa karẽn do tamoo nawät doo, tahapëë né paawä baad ub ta kariw n'aa mejũũ doo, tak'ëp da rabahewyyh ta mabaj. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jé nesaa do moo wät doo, ta kariw n'aa mejũũ do nahapäh doo, dooh denaa hẽ rahewyh ta mabaj. Ti hyb n'aa kä, ji hã P'op Hagä Do anoo do pénh, ti pénh né takarẽn ji moo wät ta wë. Hajõng do hã kahanoo doo, hajõng na-ããj takarẽn tamoo wät ta wë, hajõng takarẽn ta mabaj. Ta bahǟnh kahanoo do hã, ta pénh né ta mabaj. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ti m' Jesus ky hadoo: —Hỹ pong jé naa ỹ bahyng, tëëg hadoo ỹ gahõ jat hyb n'aa, badäk hahỹỹ hã habong do sa mahang tetyn hõm hyb n'aa. Ỹ karẽn paawä nayyw hẽ tabahõõ jat ti tëëg hadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tak'ëp da nesaa do ỹ bahoop da. Tak'ëp ỹ h'yy katón ta ti ỹ bahajaa bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ỹ ahyy wät babä, bë ed'oo apäh, h'yyb nyyw gó badäk hahỹỹ hã habong do rababok hyb n'aa sa da hadoo do wë, ỹ an'oo bä do hyb n'aa. Tii d' bë hyb n'aa newë manäh. Ỹ ahyy wät do hyb n'aa, hëp ỹ n'aa raketyn bong da. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hỹ jawén da, sa wakããn hedoo do ketyn hõm da hëp ỹ n'aa. Sa wakããn tamawoob hẽ hadoo do ragadoo da këh ỹ n'aa. Pawóp hẽ, dooh d' ragado bä. Ky kedak da hëp ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta wób da, sa yb sa taah daheeh ketyn bong da hëp ỹ n'aa. Ti hadoo né da sa ỹỹn sa toog daheeh, raketyn bong da hëp ỹ n'aa. Sa mayyn sa takaanh na-ããj da —näng mä Jesus ta ma matëg hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ti m' hajõk do hã taky hadoo: —Papỹỹj badëë hyng hẽnh naa naëng poo wäd bä, “Badah tabadoos”, näk bë kyyh. Te hub né hẽ, adoos né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta karawaa me tagahëm bä, “Badah banäm”, näk bëëh. Te hub né hẽ, banäm né kä, baju né hẽ kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","J'ooj madäk doo me ky ken'yym do bëëh! Bë h'yy genä né paawä naëng hadoos do heen n'aa hã, banäm do heen n'aa hã, dooh bë h'yy genä bä, da hẽ kä, ta heen n'aa bë hã kametëëh do hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Hëd n'aa bë hyb n'aa nanewëë bë daaj hẽ, baad hadoo do ji moo wät doo? ");
INSERT INTO mbjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bë ky n'aa tapaa pé sii bë ahõm bä, hyb n'aa jawyk do wë õm taky n'aa etyy hyb n'aa, taw'ããts hẽ ta hõõ bä, bë sii hõm do sii baad bë ber'oot, taberéd hõm hyb n'aa ta ti bë ky n'aa tamahũũm do hyb n'aa jawyk do wë. Tii d' bë nadoo bä, bë d' tamahũũm hyb n'aa jawyk do wë. Ta tii kä, warahén hã bë tabahaëënh, bë tadewäts bëëh hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Baad bë ỹ maher'oot: Dooh d' bë anä bä kä tii bä, sahõnh hẽ bë nepaag bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti noo gó m' ta wób rabana Jesus wë. Jesus mä ramaher'oot Pirato häd näng do warahén n'aa radej'ëëp do Garirej buuj wób, P'op Hagä Do hã rama ejuu bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ti m' Jesus ky hadoo sa hã: —Garirej buuj wób sa mahǟnh nesaa do ramoo bok, rawén dejëp, bë ed'oo? ");
INSERT INTO mbjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dooh. Tak'ëp nesaa do sa hã, ta wób sa mahǟnh hyb n'aa nado. Bë hã na-ããj hẽ da tabadäng P'op Hagä Do mo haj'aa nesaa do bë moo bok do säm, nesaa do bë neréd bä. Tabanesaa hẽnh bë da tah'eed hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ta ti 18 hedoo doo, Siroéh häd näng do tób yb sa jó hatëh hyng doo ẽnh? Radejëp bë ed'oo g'eeh, tak'ëp ranesaa do hyb n'aa Jerusarẽnh buuj wób sa mahǟnh? ");
INSERT INTO mbjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dooh. Ti hyb n'aa nado. Bë hã na-ããj hẽ da tabadäng P'op Hagä Do mo haj'aa, nesaa do bë moo bok do säm, nesaa do bë neréd bä. Tabanesaa hẽnh bë da tah'eed hõm —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ti m', panyyg gó m' Jesus baher'oot nyy da P'op Hagä Do bad'oo ji hã, baad hadoo do ji moo nawäd bä. Ti m' taky hadoo: —Hỹ hadoo aj'yy bejoom joom wiigo häd näng doo, uwa tyd mahang. Hajõõ nuu me tabahõm tabaheg'ããs hyb n'aa ta joom teag bä. Dooh tawyyd bä ta ag ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tii kä, tagadëëg ub, ta joom mahang moo wät do hã taky hadoo: “Tamawoob hẽ ta baab ỹ gadaa wät teag bä. Dooh teag bä. Tabad'op hẽ ta ag ỹ aw'yyt péh. Ỹ karẽn mabagëëw jat”, näng mäh. “Daap tabewaat”, näng mäh. “Joom see ër ejoom paawä tabasooh bä”, näng joom danäh ta sii moo wät do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ti m' ta sii moo wät do ky hadoo: “Taw'ããts hẽ sét hẽ ta baab ër gamedaa wät”, näng mäh. “Baad ỹ bahag'ããs hỹỹ kä”, näng mäh. “Baad ỹ w'oo eh'aa këë k'ããts baad hadoo doo me”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Wät hahỹỹ hã ta baab teag bä, taw'ããts hẽ. Taneag bä kä, tii bä kä mamejõ ỹ bagëëw hyng”, näng aj'yy ta kariw n'aa hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti m' Saab hã kä, Judah buuj rakamehehãk bä kä m', tób P'op Hagä Do panyyg rayd naherot do yt hã m' Jesus ma metëëk bä kä m', ");
INSERT INTO mbjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tahapäh mä tii bä ỹỹnh jadatog is doo, karap'aar h'yyb nesaa do ta hã hadäk do haj'aa. Dooh m' tahaja tadajoow bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ti m' ỹỹnh Jesus bahapäh bä, tanaëënh mä ta wë. Ti m' taky hadoo ta hã: —Tok ỹỹ, õm has'oo däk! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ti m' ta hã tamoo däng. Ta hã tamoo dëë sii hẽ m', takadajoow gëët. Tak'ëp mä ỹỹnh j'aa etsëë kän P'op Hagä Doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ti m', dooh m' tób P'op Hagä Do panyyg rayd naherot do wahë n'aa genaag bä Saab hã ỹỹnh nahëë Jesus ado hõm doo. —Ti anäng ji moo oow see pé ji moo wät do pan'aa ta ǟh —näng mä tób hagã n'aa tób gó kahet'aa do sa hã. —Taw'ããts hẽ tii hã bë bana, bë nahëë kado hõm hyb n'aa. Saab hã ti dooh! —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ti m' Jesus ky hadoo ta hã: —J'ooj madäk do ta ti bë h'yyb! —näng mäh. —Bë na-ããj hẽ bë moo bok Saab hã. Dooh g'eeh bë asood hõm bä bë masããh booj yb, jumeto, sa tób n'aa yt hã habëëh do Saab hã, bë mahũũm hyb n'aa rabeheëk doo hẽnh? ");
INSERT INTO mbjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dooh g'eeh taw'ããts hẽ tado bä, Saab noo gó ỹ asood hõm bä hahỹ Abaraãm panaa paa seeh, 18 ta baab takamawyyt do Nesaa Do Yb moo gó? —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ta ti tabedoo bä kä m', ta majĩĩ m' nu mebyy bong. Hajõk do tii bä hab'ëëh do ratsebé mä sahõnh hẽ hanäm doo, Jesus moo wät do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ti m' Jesus ky hadoo: —Panyyg ky n'aa me ỹ her'oot bë hã P'op Hagä Do bag'ããs do ky n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Joom motaad häd näng do tym nad'ëëd is do hadoo né hẽ P'op Hagä Do bag'ããs doo, tadu doo noo gó. Motaad tym aj'yy ejoom ta joom wób babëëh bä. Ti tabawëë kän, ti tabaee hëë kän. Tii hã kä taw'ëëd batooj kän ta hã kä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ti m' Jesus ky hadoo ẽnh: —Panyyg see ky n'aa me ỹ her'oot bë hã P'op Hagä Do bag'ããs do ky n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Pãw makuj ỹỹnh ado däk doo, tiriig s'ëëb hajõng do mahang tamekuuj däk do hadoo né tii. Baad tabajõõts däk, baad takamekuuj wät hyb n'aa sahõnh hẽ tiriig s'ëëb mahang —näng mä Jesus panyyg gó m' tabeh'ũũm. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ti m' Jesus bahõm Jerusarẽnh hẽnh. Ti m' tamahõm me, tama metëëk panang ta hõõ bä habong do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ti m' aj'yy see eaanh ta hã: —Hyb n'aa jawyk doo —näng mäh. —Jããm hẽ pawóp its g'eeh ked'ëëp P'op Hagä Do wë? —näng mä aj'yy kyyh. Ti m' Jesus ky hadoo sa hã. Panyyg gó m' tabeh'ũũm: ");
INSERT INTO mbjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Noo nad'ëëd its do hadoo hỹ pong jé ji bajëë suun doo. Ti hyb n'aa taw'ããts hẽ tak'ëp bë hyb n'aa eréd manäh, bë bahajaa hyb n'aa bë bajëng do t'ĩĩ hẽnh. Ta jawén, hajõk né paawä da karẽn hajëë p'ëë, dooh da rahaja wäd bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tób danäh noo gatsëë däg bä, dooh ji haja wäd bä ji ajëë suun ta gó. Tób w'oo hã bë wób rababë hõm tii bä. Tak'ëp bë wób ranaëënh da tagas'ëës hyb n'aa: “Ãã wahë n'aa, manoo gasëëts a tób, ãã bajëë p'ëë hyb n'aa”, näk da bë wób kyyh ti noo gó. Ti d' taky hadoo: “Jaa bëëh? Dooh bë ỹ hapëë bä”, näng da bë wób hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ti d' bë wób raky gedak: “A sii paa ãã beëëk, a sii paa ãã bawa. Ãã panang bä, ta tyw n'aa me, mama metëëk do paa ããh.” ");
INSERT INTO mbjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ti d' bë wób hã taky hadoo: “Dooh bë ỹ hapëë bä. Bë ahõm mahǟnh ỹỹ, nesaa do moo heb'ooh doo”, näng da ta kyyh —näng mä Jesus ta hã h'yy kana'eeh do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti m' taky hadoo: —Tak'ëp bë wób ba'oot da. Sa tëg kamegëëj däk da. Tak'ëp bë wén oot da, bë hapäh do hyb n'aa da hỹ pong jé P'op Hagä Do bag'ããs bä Abaraãm, Isak, Jakóh, sahõnh hẽ P'op Hagä Do ky n'aa rod, bëë kä, dooh ran'oo bä t'ĩĩ hẽnh kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Badäk hahỹỹ hã jé pad'yyt hẽ naa rabena da, P'op Hagä Do bag'ããs doo bä ratsebé do jäm n'aa tyng n'aa jó rabat'oonh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Babä hyb n'aa sekog is do wób kä, ti noo gó kä, hyb n'aa jewyg kän da. Babä hyb n'aa jewyk do paa wób kä, ti noo gó kä, hyb n'aa sekog padäg its tii kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti noo gó né hẽ m' Pariséw wób rabana Jesus wë. Ti m' raky hadoo: —Ahõm ta s'ee hẽnh. Õm da Eróts daj'ëëp —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ti m' Jesus ky hadoo sa hã: —Bë ahõm nä. Bë maher'ood ta ti aj'yy ji rahejãã do yb. Bë her'ood ta hã, pawóp nä ta ǟh karap'aar h'yyb sa hã hanäng do ỹ bahebë nä. Pawóp nä ta ǟh nahëë enäh do ỹ asog hõm nä sa nahëëh. Tii bä kä, ỹ haja kän da ỹ moo wät doo kä badäk hahỹỹ bä. Tii da bë kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jerusarẽnh bä né hẽ P'op Hagä Do ky n'aa rod ranaheb'ooh. Ti hyb n'aa, t'ĩĩ hẽnh né hẽ ỹ bahõm, ỹ dajëp hyb n'aa sa nemuun —näng mä Jesus ta ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ti m' taky hadoo: —Jerusarẽnh, Jerusarẽnh! A babuuj ranaheb'ooh P'op Hagä Do ky n'aa rod. Pä me ramahek'uut bë wë P'op Hagä Do mejũũ doo, radejëp hyb n'aa. Hajõõ nuu me ỹ karẽn paawä ỹ bataa a babuuj, nesaa do mahǟnh ỹ mo n'aa jesuu hyb n'aa sa hã, karaak ta taah ỹỹn ta këg yt hã tata bëëh do mo n'aa me. Tii da ỹ badoo paawä sa hã, dooh tii d' rakarẽn bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bë hegãã da Jerusarẽnh buuj, P'op Hagä Do beréd hõm da bë panang. P'op Hagä Do mak'yyts däk bë panang. Dooh da ỹ bë hapëë bä kä. Jããm né da p'aa hẽnh ỹ bë bahapäh da, bë h'yy kawareem bä, hahỹỹ da bë her'ood bä: “Ky n'aa kedëng tii, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo!” ");
INSERT INTO mbjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ti m', ta see pé noo gó Saab hã, Pariséw hyb n'aa jawyk do see tób bä Jesus bawëh bä m', baad mä Jesus ramatakëë. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tii bä m' ti anäng mä aj'yy nahëë näng doo. Dehepung bëëh mä ta tsyym, ta mooh. Rakarẽn mä raheg'ããs Jesus ado hõm bä ta nahëë Saab hã, ratayy do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ti m' Pariséw hã, Mosees ky n'aa jaw'yyk do baad hap'ëëh do hã na-ããj mä Jesus beaanh: —Mosees ky n'aa jaw'yyk do anoo, nahëë näng do sa nahëë ji ado hõm Saab hã? Dooh g'eeh tan'oo bä? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dooh m' raky gedag bä. Bag hẽnh mä rabab'ëëh. Ti m' Jesus moo däng nahëë näng do hã. Ta nahëë do hõm. Ti m' tamejũũ tababaaj hõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ti m' tabeaanh ta wób sa hã: —Bë t'aah, bë mas'ãã booj yb t'aah, tadëë hyy bä t'õp naëng gajat doo gó Saab hã, dooh g'eeh nayyw hẽ bë ej'ooj nä bä, Saab hã né paawä? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dooh m' sa kyy péh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ti m', sahõnh hẽ Pariséw atsyyd wät do resoos mä ta tyng n'aa baad hadoo doo bä, ji weh'ëëh do tyng n'aa. Ta ti Jesus bahapäh bä m' taky hadoo, panyyg gó m' tabeh'ũũm: ");
INSERT INTO mbjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ket'ëë do jäm n'aa hẽnh ji ratsyyd bä, bë esóts manä baad hadoo doo, hyb n'aa jawyk do tyng bë tyng. Hyb n'aa jawyk do tyng n'aa bë esóts bä, hyb n'aa jawyk do bë mahǟnh tatsyyd wät do kajaa bä, ");
INSERT INTO mbjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kat'ëë do noo gana do ky hadoo da bë hã: “Man'oo hahỹỹ hã ta tyng majasooh doo”, näng da. Tii bä kä da, sa matym gó da bë da nu mebyy bong. Tii bä kä, bë kahỹỹd kän ky n'aa nets'äs do tyng jó kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bë ratsyyd bä, taw'ããts hẽ bë atooj dawë hã, hyb n'aa najewyk do tyng jó. Ti m' jäm no gana do kajaa bä, hahỹỹ da ta kyyh bë hã: “B'ëëp dana, p'eets hẽ, baad hadoo doo bä bë atooj.” Tii bä kä, tats'yyt do wób sa matym gó bë kawehëë däk da. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jé ta daaj hẽ kaweh'ëëh doo, nu mebyy wät da, ta wób sa yd jé tanu gadäg hõm. Jé ta daaj hẽ kawaneh'ëëh doo, raweh'ëëh da, P'op Hagä Do an'oo bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ti m' tób danäh hã Jesus baher'oot: —A waa, a tä mamoo wäd bä a sii ratsebé, a sii rabawa hyb n'aa, matsyyd manä a najiis hedoo doo, a hỹỹj hedoo doo, a wakããn hedoo doo, a pa haj'eenh do tak'ëp ma enäh doo. Ti matsyyd bä, õm da rats'yyt ta mabaj. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Taw'ããts hẽ matsyyd kasuud is do hedoo doo, k'yy gedóm do hedoo doo, nabong do hedoo doo, ty tsehẽt do hedoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tii bä kä da õm P'op Hagä Do ky n'aa edëng. Dooh né paawä rahaja bä rabaj bä, P'op Hagä Do tii kä hanoo a hã ta mabaj, baad habong do paa ragenä bong noo gó —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ti m' Pariséw ats'yyt do see Jesus her'oot do tamaa napäh bä m', taky hadoo: —Ky n'aa kedëng da jé hỹ pong jé, P'op Hagä Do bag'ããs do jäm n'aa bä ta waa n'aa tawa bä sa sii —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ti m' panyyg ky n'aa gó Jesus ky gadoo: —Hỹ hadoo aj'yy ratsebé do waa n'aa, ta tä n'aa tamoo wät. Hajõk tats'yyt ta sii ratab'ëës hyb n'aa ta ti jäm. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sahõnh hẽ ta waa n'aa, ta tä n'aa, tabahaja däk bä, tamejũũ ta karom tabahõm, pooj jé tatsyyd bong do tabats'yyt hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ti m' sahõnh hẽ tats'yyt do raky kamep'ëëh. Ta see ky hadoo: “Nag'aap hẽ ỹ bets'ẽẽ hõm hëëj. Ỹ karẽn ỹ heg'ããs”, näng. “Dooh ỹ haja bä ỹ ahõm bä”, näng. “Mamaher'ood a kariw n'aa, du daa ỹ bahõm péh”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ti ta see ky hadoo: “Nag'aap hẽ ỹ bets'ẽẽ wät 10 booj yb. Hỹỹ kä ỹ metyy, baad rado bä. Ti hyb n'aa, dooh tahaja bä ỹ ahõm bä”, näng ta kyyh. “Mamaher'ood a kariw n'aa, du daa ỹ bahõm péh”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ti ta see ky hadoo: “Nag'aap hẽ ỹ gat'ëë däk ǟm ỹỹ. Dooh tahaja bä ỹ ahõm bä”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ti ta karom babaaj hõm kän, tamaher'oot mä ta kariw n'aa sa kyyh. Tii bä kä, jäm no gana do kawaj'ããn wäd kän sa wë, ti taky hado kän ta karom hã kä: “Nayyw hẽ, ahõm nä. Panang tyw n'aa me matsyyd hõm kas'uut doo, k'yy gedóm doo, ty tsehẽt doo, nabong do sii hẽ”, näng ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ti tabahajaa bä sahõnh hẽ tamejũũ doo, taky hadoo ta kariw n'aa hã: “Sahõnh hẽ ỹ bahajaa mamejũũ doo da. Ti hadoo né hẽ, ti anäng nä ta tyng n'aa, ti anäng nä ta waa n'aa”, näng ta karom kyyh ta kariw n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ti ta kariw n'aa ky hadoo ta hã: “Ahõm panang bahǟnh. Sahõnh maw'yyt do matsyyd. Ỹ karẽn tóp ỹ gabad'ẽẽ däk. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Baad ỹ her'oot a hã. Pooj jé katsyyd bong doo, dooh da ỹ an'oo bä sa tä, dooh ỹ an'oo bä sa waa”, näng ta kariw n'aa kyyh —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hajõk mä Jesus had'aa doo, Jerusarẽnh hẽnh tabahõm bä. Ti m' ta jawén p'aa hẽnh taty kaw'õõd däk, ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Bë karẽn bä hëp ỹ hata bë hado bä, taw'ããts hẽ bë yb, bë ỹỹn, bë ỹỹm, bë taah, bë hỹỹj, bë ǟnh bë kamahǟn do bahǟnh ỹ bë kamahǟn. Taw'ããts hẽ bë kamahǟn do bë hã bahǟnh ỹ bë kamahǟn. Sahõnh hẽ sa bahǟnh ỹ bë kamanahǟn bä, dooh bë haja bä hëp ỹ hata bë do bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jé hëp ỹ n'aa tamo n'aa tahoop do tajeỹỹm bä, h'yyb nahedoo do nemon ỹỹ, dooh tahaja bä hëp ỹ hata tado bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ti m', panyyg gó m' tabaher'oot, pooj jé m' baad mä ji hyb n'aa newëë, ji haja bä ta h'yyb hata ji ado bä. Ti taky hadoo: —Tób pä s'ëëb haeh do tama doo, pooj jé dó taw'ããts hẽ tahyb n'aa newëë tahaja bä ta wë hanäng do ta säm, sahõnh hẽ tahaja so bä ta tób. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Daap tadu do bä, tanetsén nä bä ta säm, dooh ji hapëë bä ta baa bä tabawäd däk bä, ta säm bahëëj jëng. Tii bä ta wób rawajehëët ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Wät ta ti tób tama doo. Ahëëj jëng ta wë ta säm, kanaja nä tób”, näk da. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hahỹ panyyg see bë maa newëë: Kaneb'ooh do du doo pooj jé, dooh g'eeh sa wahë n'aa hyb n'aa newë, rahaja bä sa majĩĩ hã raj'aa ketsë, sa yd jé né paawä ta warahén n'aa? 20 miw ta majĩĩ warahén n'aa, 10 miw ta warahén tanyy bä? ");
INSERT INTO mbjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tahyb n'aa newë bä tanahajaa doo, nayyw hẽ tamejũũ rapanäk ta majĩĩ wë, dawëë nä rababok nä ta majĩĩ, raky n'aa her'oot rakananeb'ooh hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ti m' taky hadoo: —Ti hyb n'aa, sahõnh hẽ ta wë hanäng doo, hëp ỹ n'aa tanerét doo, dooh tahaja bä hëp ỹ hata tado bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ti m' taky hado kän: —Taw'ããts hẽ ti jukiir. Ti hadoo né hẽ, tanadah'ëëd wäd bä, taw'ããts hẽ nado wäd. ");
INSERT INTO mbjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dooh hyb n'aa ji karẽn wät péh. Ji aw'oong hõm tii. Jé karẽn pé ỹ ma metëëk do tamaa newë bä, taw'ããts hẽ tamatakëë —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ti m' Jesus ma metëëk bä m', sa wahë n'aa dajẽẽr gedaag n'aa, nesaa do moo heb'ooh do na-ããj hẽ rabana, Jesus metëëk do ramaa newëë hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ti hyb n'aa m', Pariséw, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ, raky hadoo: —Hahỹ aj'yy nesaa do moo heb'ooh do tagadoo. Awëh na-ããj hẽ sa sii —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ti m' Jesus baher'oot panyyg sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Bë see tanyy bä 100 b'éé, ta masããh, ti m' 100 hedoo do see takanapëë wäd bä, dooh g'eeh teréd dó 99 hedoo do ta masããh, kanapëë wät do tabesoos hyb n'aa? ");
INSERT INTO mbjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ti tabaw'yyt bä kä, tatsebee wät do hyb n'aa tatóg sooh ta nu k'yy hã, tamajëëh hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tób bä takajaa bä kä, tanaëënh da ta najiis, tanaëënh ta wób ta pa haj'eenh doo, ratsebé hyb n'aa ta sii, ta mas'ãã see taw'yyt do hyb n'aa kä, kanapëë wät do paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bë ỹ maher'oot hahỹỹh —näng mä Jesus: Ti hadoo né da hỹ pong jé P'op Hagä Do pa habong doo, tak'ëp da ratsebé baad nadoo do paa see h'yy kawareem bä P'op Hagä Do hã. 99 hadoo baad habong doo, dooh hyb n'aa rah'yy kawereem pé sa hyb n'aa ratsebee né paawä, ta bahǟnh ratsebé, sét hẽ baad nadoo do paa P'op Hagä Do wë h'yy kawareem do hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ti m' tabaher'oot ẽnh panyyg see gó. Ti m' taky hadoo: —Ỹỹnh see wë tanyy bä 10 moweed k'ããts tëg hawak do s'ëëb, tii bä, ta see badoo wäd bä, tagataa däk ta bag, tabakoot tób, baad tabesoos da. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tabaw'yyt bä kä, tanaëënh ta najiis, tanaëënh ta pa haj'eenh doo, ta sii ratsebé hyb n'aa moweed nepä wät do taw'yyt do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ta ti hadoo, P'op Hagä Do ããs ta pa hab'ëëh do ratsebé nesaa do moo hew'ëët do paa see P'op Hagä Do hã tah'yy kawareem bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ti m' Jesus baher'oot ẽnh panyyg seeh. Ti m' taky hadoo: —Ti awät aj'yy ma näng doo. Pawóp hẽ ta taah. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ta see pé noo gó, ta t'aah tagad'oo hadoo do ky hadoo ta yb hã: “Na ỹ karẽn no n'aa ỹỹ, madajëb nuuj jé no n'aa paah. Nayyw hẽ ỹ karẽn ỹ gadoo”, näng ta t'aah. Tii bä sa yb betyn hõm ta ma ta taah sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dooh tahajõõ nä bä ta ǟh, tagad'oo hadoo do bata hõm kän sahõnh hẽ ta ma, ta yb mo haj'aa kä. Ti tabahõm kän dawëë, hëëj s'ee hẽnh. T'ĩĩ hẽnh kä tabahäj kän sahõnh hẽ ta wë hanäng do paah. Tah'yyb däng do hã tabeh'ëënh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ti bahǟnh kä ta dajẽẽr bahëëj jëë kän. Dooh wäd ta dajẽẽr kä. Tii bä awäd kän sah. Asa kän. Dooh tadoo wät péh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ti ta tyw n'aa esóts kän tamoo wät doo. Ti awät aj'yy too yb masããh näng doo. Ti hã tabetsẽẽ tamoo wät doo. Ti tamoo wäd kän, too yb tahagãã kän. Too yb tanejë kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tak'ëp ta ti aj'yy basa kän. Takarẽn paawä too yb waa tabawa. Dooh hanoo pé ta hã ta waa. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tii bä tat'yyd kamehĩĩn kän. Ta h'yyb gó taky hadoo: “Jajé, sahõnh hẽ ee sii moo bong doo, ee karom, dooh rasa bä. Anäng sa waa. Mad'aak né sa waa. Ti ỹ bas'as babä”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Taw'ããts hẽ ỹ babaaj hõm ee wë”, näng ta kyyh. “Ỹ maher'oot ta ti ee”, näng. “‘Ee’, näng da këh ỹỹ”, näng, “‘nesaa do ỹ moo wäd wät P'op Hagä Do hã, a hã na-ããj hẽ’, näng da këh ỹỹ”, näng ta kyyh ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ti tahyb n'aa newëë ta h'yyb gó: “Ỹ etsẽẽ da ỹ moo wät doo. ‘A karom däg da ỹỹh. Dooh a t'aah ỹ doo wäd bä’, näng da ỹỹh”, näng ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ti tababaaj nä kän p'aa hẽnh kä ta yb wë kä. Takajaa bä kä ta yb wë, dawëë naa ta yb gadoo. Baad ta yb gadoo. Dawëë naa tabahapäh bä, tat'yyd mehĩĩn. Ti tawaj'aa däk ta wë, takedëng hyb n'aa. Tawaké däk, ta tapa tsanetsub wät takedëng do heen n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ti ta t'aah ky hadoo: “Ee”, näng, “nesaa do ỹ moo wäd wät P'op Hagä Do hã, a hã na-ããj hẽ”, näng. “Dooh a t'aah ỹ mamaneëëj wäd bä”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ti ta yb ky hadoo ta karom hã: “Nayyw hẽ, bë mana saroor tak'ëp hanäm doo, ta hã bë dadäg. Ta ma poo heen n'aa, ta tsyym suun sii hẽ bë mana. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bë naboh booj yb t'aah hepuh doo, ër nejë häng doo, ër tsebé do tä n'aa”, näng. “Ër tsebé da, p'aa hẽnh tah ỹ kajaa do hyb n'aa”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Dajëp do hadoo hahỹ tah ỹỹ. Edëb wät p'aa hẽnh hỹỹ kä. Nepä wäd paah. Hỹỹ kä kaw'yyt p'aa hẽnh”, näng ta yb kyyh ta karom hã. Tii kä ratsebee kän, rabajäm kän ta hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ta t'aah seeh, wah'ëëh hadoo do moo wät sa joom banäng bä. Ti nuuj jé takajaa. Wah'ëëh hadoo do bajëng bä kä, tamaa newë däk ketẽn doo, kejäm doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ti tanaëënh sa karom seeh. Tabeaanh hëd n'aa ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“A hỹỹj kaja nä p'aa hẽnh”, näng. “A yb mejũũ ãã naboh jat booj yb t'aah hepuh doo, ër tsebé do tä n'aa, baad takajaa do hyb n'aa”, näng sa karom kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ti wah'ëëh hadoo do kawaj'ããn kän. Dooh takarẽn bä tajëë suun tób gó. Ti ta yb banyyh tamaher'oot hyb n'aa, tabajëë suun hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dooh ta t'aah karẽn bä tamaa newë bä ta ti taher'oot doo. “Hajõõ ta baab tak'ëp ỹ moo wäd wät a sii”, näng ta yb hã. “Dooh noo gó õm ỹ ky nadaheeh péh”, näng. “Dooh noo gó tabad'op hẽ man'oos pé b'éé t'aah, najis ỹ daheeh ãã tsebé do tä n'aa”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“Hỹỹ kä a t'aah mahanäng doo, ỹỹj hajõk sii he'ỹỹh do hã tabahäj jëng do a dajẽẽr tababaaj nä bä kä, mamejũũ ranabooh booj yb hepuh doo!”, näng wah'ëëh hadoo do ta yb hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ti ta yb ky hadoo: “Tah ỹỹ”, näng, “pa ỹ had'yyt ti õm bagä”, näng ta yb kyyh. “Sahõnh hẽ wë ỹ haym doo, a ma had'yyt né hẽ tii”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“A hỹỹj ti hỹ dajëp do paa hadoo. Hỹỹ kä edëb wät p'aa hẽnh. Nepä wät do hadoo, p'aa hẽnh takaw'yyt”, näng. “Ti hyb n'aa, taw'ããts hẽ né hẽ tii d' ër tsebé, taw'ããts hẽ né hẽ jäm ji moo wät”, näng ta yb kyyh wah'ëëh hadoo do hã —näng mä Jesus panyyg ky n'aa me m' tamaher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ti m' ta ma matëg hã Jesus maher'oot hahỹ panyyg: —Ti awät aj'yy tak'ëp ma näng doo. Ta see pé noo gó ramaher'oot ta kaser n'aa ky n'aa. Dooh m' baad tanä ta kariw n'aa ma, tah'ëënh mä ta ma. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ti hyb n'aa tanaëëj kän ta wë. Teaanh ta hã: “Nyy d' ti a ky n'aa ỹ ky n'aa napäh doo?”, näng. “Taw'ããts hẽ maheen n'aa eta hõm dajẽẽr n'aa hã, ma ỹỹ hã na-ããj hẽ. Dooh da kaser ỹ n'aa mado wäd bä”, näng ta kariw n'aa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ti ta h'yyb gó ta kaser n'aa ky hadoo: “Nyy d' ỹ bad'oo hỹỹ kä?”, näng. “Kariw ỹ n'aa dooh da takarẽn wäd bä ỹ moo wäd wät ta sii. Dooh ỹ haja bä tak'ëp hadoo do ỹ moo wäd bä. Ỹ nu mebyng na-ããj ỹ ets'ẽẽ ub bä dajẽẽr”, näng ta kyyh ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ti taky hadoo ẽnh ta h'yyb gó: “Ỹ hapëë däk hỹỹ kä nyy d' ỹ bad'oo, sa tób hẽnh ỹ ragadoo hyb n'aa, ỹ moo wät do bahëëj jëng bä”, näng ta kaser n'aa ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ti tanaëënh ta wë sét ken'yyh ta kariw n'aa wë kũũt enäh doo. Pooj jé kajaa do hã tabeaanh: “Nyy hẽ a kũũt kariw ỹ n'aa wë?”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“100 ta hood joom syyj”, näng aj'yy. Ti ta kaser n'aa ky hadoo: “Hahỹ a kũũt heen n'aa. Nayyw hẽ, merii däg ta heen n'aa papuuj”, näng. “Merii däg a kũũt 50”, näng ta kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta see hã tabeaanh ẽnh: “A kũũt ẽnh kariw ỹ n'aa wë?”, näng ta kaser n'aa. “100 wog tiriig s'ëëb”, näng kũũt näng do see kyyh. Ti ta kaser n'aa ky hadoo: “Hahỹ a kũũt heen n'aa. Papuuj merii däg. 80 wog da merii”, näng ta kyyh. Tii d' had'yyt tabedoo hõm ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tii bä ta kariw n'aa hyb n'aa meuunh ta hã, kamatakëë do hyb n'aa ta kaser n'aa paa kä, ta ma baad nan'yyh do paah —näng mä Jesus her'oot do panyyg. —Te hub né hẽ —näng Jesus. —P'op Hagä Do hã h'yy kana'eeh doo, baad rakamatakëë ta wób sa hã rabahed'oo do hã. P'op Hagä Do hã h'yy ka'eeh do sa mahǟnh rakamatakëë ta tii hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ti m' Jesus baher'ood kän ta ma matëg sa hã panyyg ky n'aa kä: —Bë ỹ maher'oot —näng mäh. —Taw'ããts hẽ badäk hahỹỹ bä hanäng do hã bë wë hanäng doo me ta wób bë masaa, bë najiis rabahadoo hyb n'aa kä. Tii bä da, ta jawén, bë wë hanäng do badoo wät bä kä, ti anyy kän bë gadoo do hỹ pong jé. P'op Hagä Do gadoo da bë t'ĩĩ hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ti m' Jesus ky hadoo: —Kanahën d'os hẽ ji ma hedoo doo, ji dajẽẽr hedoo doo, baad han'yyh doo, hajõng do na-ããj hẽ baad taban'yyh. Kanahën d'os hẽ hadoo do baad nan'yyh doo, hajõng do na-ããj hẽ dooh baad tanä bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti hyb n'aa, badäk hahỹỹ bä bë wë hanäng do baad bë nanä bä, dooh da P'op Hagä Do an'oo bä bë hã bë ma heh'äät do hỹ pong jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Badäk hahỹỹ bä bë hã P'op Hagä Do anoo do baad bë nanä bä, dooh bë ma hanoo pé bë hã hỹ pong jé —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ti m' Jesus ky hado kän: —Dooh sa karom haja bä pawóp ta kariw n'aa sii tamoo wäd bä séd noo gó. Tii d' tahado bä, ta kariw n'aa see dooh takamahǟn bä, ta see ti takamahǟn. Ta see wë da baad tamoo wät da, ta see taty n'aa ges'yyk da. Ti hadoo bë hã. Dooh bë haja bä bë h'yy keséj bä. Dooh bë haja bä P'op Hagä Do hã bë h'yyb däg bä, dajẽẽr hã na-ããj hẽ bë h'yyb däng bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pariséw dajẽẽr mä ragen'aak. Ti hyb n'aa Jesus her'oot do ramaa napäh bä m', raky n'aa rejãã mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti m' Jesus ky hadoo sa hã: —J'ooj madäk doo me bë ky ken'yym ta wób sa matym gó. Ti hado né paawä bë h'yyb, P'op Hagä Do hapäh bë h'yyb tym. P'op Hagä Do mak'yyts däk badäk hahỹỹ bä hanäng do tak'ëp rakamahǟn doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ti m' Jesus ky hadoo: —Jowãw nu gahem'uun do kajaa do pooj jé, Mosees ky n'aa jaw'yyk doo, P'op Hagä Do ky n'aa rod rerih do paa kametëëk paah. Hỹỹ kä, P'op Hagä Do bag'ããs do ky n'aa hanäm do kamet'ëëg däg kän. Hajõk tak'ëp rah'yyb hedoo, P'op Hagä Do bag'ããs do karapee rabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ti hado né paawä, P'op Hagä Do ky n'aa jaw'yyk do dooh tahëëj bä. Wë, badäk hahỹ hëëj gawatsig né paawä, P'op Hagä Do ky n'aa jaw'yyk do dooh tagawatsig bä. Dooh ta bód had'os pé gawatsik péh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ti hyb n'aa, jé ta ỹỹm heréd hõm doo, tii bä ỹỹnh see hã takat'ëë däg bä, nesaa doo, P'op Hagä Do ganadoo do tamoo wät. Ta see ỹỹm sii he'ỹỹh do hado däk tii. Aj'yy see gat'ëë däg bä ỹỹnh ta patug heréd hõm doo, nesaa doo, P'op Hagä Do ganadoo do tamoo wät. Ta see ỹỹm sii he'ỹỹh do hado däk tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ti m' panyyg gó m' Jesus tabeh'ũũm. Ti m' taky hadoo: —Hỹ hadoo aj'yy tak'ëp wekãp doo. Tak'ëp ky n'aa gebah, hetsooh, ta saroor ta hã hadäk doo. Tak'ëp hanäm doo gó tabawäd had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta tób noo bä tabahäng aj'yy kasuud is doo, ta waa hets'ẽs doo. Nahëë nyy is ta tii. Rog manahuuh do tii. Rasaro ta häd. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tak'ëp takarẽn paawä tabawëh, tak'ëp wekãp do tä hyyj kajäk do tũũ. Awaar rahedẽp ta rog, ta tii bä tabahëës bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ti aj'yy hets'ẽs do dajëp bä kä, ããs ramasäg kän ta h'yyb tym hỹ pong jé kä, Abaraãm pa. Ti tak'ëp wekãp do dajëb kän na-ããj hẽ. Ti radakä jëng, tabanesaa hẽnh kä tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tabanesaa hẽnh tak'ëp tabahoop bä kä nesaa doo, dawëë naa tabahapäh Abaraãm, Rasaro häd näng doo kä, ta pa. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ti wekãp do ky hadoo Abaraãm hã, tak'ëp ta kyyh: “Wahëh ỹỹ, Abaraãm”, näng, “ỹ mat'yyd mehĩĩn”, näng ta kyyh. “Mamaher'ood Rasaro ta moo poo tadatu naëng taheh'oos, nagat ỹ tadah'ẽẽm hyb n'aa”, näng. “Tak'ëp ỹ bahoop baju doo, hahỹ tëëg hõõh”, näng wekãp do paa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ti Abaraãm ky hadoo ta hã: “Tah ỹỹ”, näng, “mahyb n'aa es'ee baad mabawät do paah. Sahõnh paa tabanäng makarẽn doo”, näng. “Rasaro paa ti dooh. Nesaa do tagadoo paah. Hỹỹ kä baad ta hã kä. Hỹỹ kä h'yy gadajaa kän. Õm hỹỹ kä hahoop nesaa doo”, näng Abaraãm kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Ti anäng gaeh gadarong doo, t'õp gajëng do ta baa besuu. Babä naa karẽn pé t'ĩĩ hẽnh tahõm bä, dooh tahaja bä. T'ĩĩ hẽnh naa na-ããj hẽ, dooh tahaja bä ẽnh”, näng Abaraãm kyyh tak'ëp ma näng do paa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ti aj'yy betsẽẽ Abaraãm hã tak'ëp, ti m' taky hadoo: “Wahëh ỹỹ”, näng, “mamejõ Rasaro tabahyng ee tób hẽnh”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","“Ti abong nä ji ma poo oow pé wakãn haa tii bä”, näng ta kyyh. “Mamejõ baad tamaher'oot, babä tak'ëp ji ahoop doo bä ranana hyb n'aa nemon ỹỹ”, näng tak'ëp ma näng do paa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tii bä Abaraãm ky hadoo: “Dooh. Ti anäng Mosees erii wät do paah, P'op Hagä Do ky n'aa rod rerii bong do paah. Taw'ããts hẽ ti né ramaa newë raner'oot bä. Tii hã rapanyyg enä kän”, näng Abaraãm. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Dooh, wahë ỹ n'aa”, näng aj'yy. “Sét hẽ dejëp do mahang ganä wäd bä, sa wë tahõm bä, tii bä kä da rah'yy kawereem P'op Hagä Do wë”, näng aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ti Abaraãm ky hadoo: “Mosees erii wät do paah, P'op Hagä Do ky n'aa rod rerii bong do paa ramaa nanewë bä, tii bä na-ããj da dooh ramaa newë bä ganä wät doo”, näng Abaraãm kyyh tak'ëp wekãp do paa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ti m' Jesus ky hadoo ta ma matëg hã: —Tanyy had'yyt né hẽ nesaa do hã ji tah'yyb tatuk doo. Ti hado né paawä da, P'op Hagä Do rejãã da nesaa do hã h'yyb tatuk do du n'aa doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","—Baad nado né paawä pä ta jawyyg n'aa ji hã ranu hũũ däg bä, ji radawäts tu tame t'õp ji pahǟs hyb n'aa, ti bahǟnh tak'ëp baad nado ji hã da, ky n'aa netsëëh do seeh, hahỹ karapee hedoo doo, hã ỹ h'yy ka'eeh doo, ji h'yyb tatug bä, nesaa do tamoo wät hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Ti hyb n'aa, baad bë hyb n'aa matakä, ji h'yyb tanatuk hyb n'aa ta seeh —näng mäh. —A da hadoo doo, hã ỹ h'yy ka'eeh do seeh nesaa do tamoo wäd bä, mageǟm, tamoo nawät hyb n'aa baad nadoo doo. Nesaa do hã tat'yyd kamehĩĩn bä, taw'ããts hẽ mahyb n'aa mabaan hõm ta hã tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Séd noo gó né hẽ 7 nuu me nesaa do a wë tamoo wäd bä, 7 nuu me tets'ẽẽ bä mamabaan hyb n'aa, taw'ããts hẽ baad mahyb n'aa mabaan hõm né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ti m' 12 hedoo do Jesus mejũũ do raky hadoo ta hã: —Tak'ëp man'oo magyys hẽ P'op Hagä Do hã ãã h'yy ka'eeh hyb n'aa —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti m' Jesus ky hadoo: —Motaad häd näng do tym, nu nad'ëët do ta tym. Ti tahanyy bä paawä bë h'yy ka'eeh doo, tii b' bë haja paawä hahỹ b'aa bë mejũũ takadawäts nyyh, takadawäts tu ta me akajar me. Bë paawä taky daheeh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ti m' panyyg gó m' tabeh'ũũm. Ti m' taky hadoo: —Ji karom kanep'aak do gëëw gó tamoo wät do jawén paa bä tabajëng bä kä, b'éé tahagãã wät do jawén paa bä tabajëng bä kä, dooh ta kariw n'aa an'oo nä bä nayyw hẽ ta waa tabawa. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tabawëh pooj jé ta kariw n'aa mejũũ da tamoo wät ta tä n'aa, tii bä tamana kän ta kariw n'aa tä kä. Tii bä kä, ta kariw n'aa bahajaa bä kä tawëh doo, tii bä kä ta karom bawëë kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ta karom moo hew'ëët ub né tii. Ti hyb n'aa, “taw'ããts hẽ” ta kariw n'aa naher'oot ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti hado kän bë hã kä. Sahõnh hẽ bë bahaja däk bä bë P'op Hagä Do mejũũ doo, taw'ããts hẽ hahỹỹ da da bë kyyh: “Ãã moo heb'ooh do né hẽ tii. Dooh ãã gahëën bä ãã hã P'op Hagä Do j'aa etsë doo, tamejũũ do ãã bahajaa do hyb n'aa”, bë noo da —näng mä Jesus ta ma matëg sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ti m' Jerusarẽnh hẽnh Jesus bahõm bä, Samarija häd näng do häj n'aa, Garirej häj n'aa baa besuu n'aa me tamahõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Panang see bä takajaa bä kä, tamamuun 10 ajyy, rog maneh'uuh do sa nahëëh. Dawë mä rabab'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ti m' tak'ëp mä ranaëënh: —Jesus, ãã Wahë N'aa —näk mäh. —Mat'yyd mehĩĩn ããh! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ti m' Jesus bahapäh bä m' taky hadoo sa hã: —Bë ahõm nä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wë, bë hã raheg'ããs hyb n'aa bë heso padäg bä —näng mäh. Ti m' rabahõm. Ramahõm me m' rameheso padëëk. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ti m' sét hẽ m' matëh nä Jesus wë, tahapäh do hyb n'aa has'oo däk doo. Tak'ëp mä ta kyyh. P'op Hagä Do taj'aa etsëë kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tũũ takadawäts hyng Jesus bagëët bä, taweh'ëëh hyb n'aa. Ti m' taky hadoo: —Taw'ããts hẽ Jesus. Ỹ mahaso däk! —näng mäh. Samarija buuj mä ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ti m' Jesus ky hadoo: —N'yy hẽnh ta wób? —näng mäh. —Ỹ heso hõm sahõnh hẽ. Hëd n'aa sahõnh hẽ ranana? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","—Ta wób dooh ramatëh bä. Jããm hẽ hahỹ Judah buuj nadoo do matëëh p'aa hẽnh, P'op Hagä Do hã taj'aa etsë hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ti m' aj'yy hã taky hadoo: —As'ëëg g'ëëd! Õm has'oo däk ỹ maky daheeh do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ti m' ta see pé noo gó, Pariséw reaanh Jesus hã: —Ny noo gó sahõnh hẽ P'op Hagä Do bag'ããs do du däk? —näk mäh. Ti m' Jesus ky hadoo: —Sahõnh hẽ P'op Hagä Do bag'ããs do du däk doo, dooh da ji hapëë bä ji matym me ta heen n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—Dooh da raky hado bä: “Wät nanäng, wät hahỹỹh”, ranoo bä takajaa bä. Ji hapäh do nado ta ti ji matym me. Ji matym me ji wén napäh, ji h'yyb tym gó da P'op Hagä Do bag'ããs do banäng —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ti m' taky hadoo ta ma matëg sa hã: —Ti awät da ti noo gó tak'ëp nesaa do ji wë. Ti noo gó da tak'ëp da bë karẽn ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do bë bahapäh. Sét nuu me hadoo pé da bë karẽn bë baheg'ããs. Dooh da bë haja nä bä bë hegãã bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta wób da daap da bë rapanäk ỹ kajaa doo. “Wät hahỹỹh”, näk da ta wób. “Wät nanäng”, näk da ta wób. Bë ky dahé manä ta ti hedoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa bä, sahõnh hẽ da ỹ rabahapäh. Hawyp doo, wë hã naa jé pad'yyt hẽ sahõnh hẽ tabawag hõm do ji hapäh do hadoo da ỹ kajaa do rabahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ti pooj jé da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, hajõng da tak'ëp ỹ ahoop näh. Badäk hahỹỹ bä da hẽ habong do ỹ raty n'aa ges'yyk da. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","P'ooj ub, Nowéh häd näng do hawät noo gó habong doo da né da rababok da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sahõnh hẽ tabag'yyp do pooj jé, h'yy kanap'eed gó rababok. Ratsebé do waa n'aa reëëk, ratsebé do waa n'aa rawa. Rakehet'ëë doo da raketëë. Dooh rahyb n'aa peet péh. Tii d' né rabad'oo marakate gó Nowéh rabajëë p'ëë bä kä. Ti m' rabagyyb kän, ti m' sahõnh hẽ radejëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ti hadoo né hẽ m' Róh häd näng do hawät noo gó ẽnh. H'yy kanap'eed né hẽ m' ti noo gó ẽnh. Ramoo heb'ooh paa m' ratsebé do wa n'aa, reëëk ratsebé do waa n'aa. Rahesäm paa m', rahetsẽ paa m', rahejóm paa m', ratahem'aa sa tób. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sa panang, Sodoma häd näng do Róh beréd hõm bä kä m', tëëg hõõ, saw'aak do mahỹỹnh doo, kajäk sa jó. Ti mahỹỹj mä sahõnh hẽ ragawatsig hõm Sodoma panang buuj. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti hadoo né da, dooh rah'yy kap'eed bä, ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ti noo gó kä, p'op tób gadäk do jó hasooh péh, taw'ããts hẽ da dooh tajëë suun bä tób gó, ta h'ëëd tabehëën hyb n'aa paawä. Taw'ããts hẽ nayyw hẽ takejën hõm, tabedëp hyb n'aa. Ti hadoo né da ta joom hood hẽnh hawät doo. Taw'ããts hẽ nayyw hẽ da takejën hõm. Taw'ããts hẽ dooh tajëë bä, tehëën bä ta h'ëëd hedoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bë hyb n'aa newë Róh ỹỹm ti noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jé badäk hahỹỹ hã ji hawät do hã tak'ëp kamahǟn doo, ta ma hyb n'aa hawät péh, dooh da P'op Hagä Do wë tanu dëë bä. Jé ta wë hanäng do heréd hõm péh, dooh ta hã tabaa es'ĩĩ bä, edëp da, P'op Hagä Do wë da tanu däng. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ỹ kajaa bä kä, pawóp hẽ ha'ỹỹh do sa see da ỹ mahũũm si ỹỹ, ta see da keréd hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pawóp hẽ hedoo pé ỹỹj tiriig ramoo bok do sa see da ỹ mahũũm si ỹỹ, ta see da ỹ eréd gëët. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pawóp hẽ hedoo pé ajyy gëëw gó moo bok do sa see ỹ mahũũm, ta see dooh ỹ mahũũm bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ti m' ta ma matëg rabeaanh: —Nyy bä ti bawät maher'oot doo? —näk mäh. Ti m' panyyg gó m' Jesus ky hadoo: —Dajëp do bajat bä, tii bä da kuruj-du rakata padëëk —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ti m' panyyg gó m' Jesus ma metëëk ta ma matëg hã, raky n'aa ets'ẽẽ had'yyt hyb n'aa, ranerét hyb n'aa raky n'aa etsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ti m' taky hadoo: —Sa panang bä ti awät aj'yy tak'ëp hyb n'aa jawyk doo, baad hadoo do baad nadoo do rod n'aa. Dooh P'op Hagä Do hã tah'yy kae bä ti aj'yy. Dooh tawehëë bä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti ỹỹnh patug tamah do tets'ẽẽ had'yyt hẽ, tamasa hyb n'aa ta majĩĩ ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pooj jé dó, dooh tahyb n'aa p'eed bä, dooh taky dahé bä ỹỹnh her'oot doo. Ti ta jawén kä, taky hadoo ta h'yyb gó: “Dooh né paawä P'op Hagä Do hã ỹ h'yy kae bä, dooh né paawä ta wób ỹ wehëë bä, ");
INSERT INTO mbjNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ỹ masa dó hỹỹ kä, ỹ mo n'aa jesuu hỹỹ kä. Ỹ mo n'aa najesu bä, ỹ ky nap'eed bä, ỹ d' h'yyb napan däg, ỹ tah'yyb panasä had'yyt do hyb n'aa”, näng aj'yy hyb n'aa jawyk do kyyh ta h'yyb gó —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti m' Jesus ky hadoo: —Bë hyb n'aa newë aj'yy ky n'aa kaher'oot do hã. Bë hyb n'aa newë ta ti kametëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","—Ky nes'aa né paawä ta ti aj'yy hyb n'aa jawyk doo, ta jawén kä tamasaa kän. Ti bahǟnh P'op Hagä Do ky enyym. Baad P'op Hagä Do masa, baad tamo n'aa jesuu ta wë tasëëw hõm doo, ta hã had'yyt hẽ ky n'aa etsẽẽ doo. Dooh bäp peej ji gadaa bä P'op Hagä Do an'oo bä. Nayyw hẽ tagadoo ji ky n'aa etsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nayyw hẽ baad hadoo do tabanoo ji hã —näng mäh. Ti m' tabeaanh: —Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do kajaa bä, ỹ aw'yyt g'ee da badäk hahỹỹ bä hã ỹ h'yy ka'eeh doo? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti m' Jesus ma metëëk do maa new'ëë do mahang ti abong mä ta wób, baad ub, P'op Hagä Do karẽn doo da rababok red'oo doo, sa hã hẽ rahegãã bä. Kasab'ee do me ta wób ramakyys. Sa hã m' Jesus baher'oot hahỹ panyyg: ");
INSERT INTO mbjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ti abong pawóp hẽ ajyy P'op Hagä Do tób n'aa hẽnh hah'ũũm doo, P'op Hagä Do hã raky n'aa etsẽẽ hyb n'aa. Sét hẽ Pariséw, ta see sa wahë n'aa dajẽẽr n'aa gahedak doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ti Pariséw, ta m'aa hẽnh mä tabag'ëëd däk, ti m' taky n'aa etsẽẽ. “P'op Hagä Doo”, näng, “a hã ỹ h'yyb tsebé, dooh ta wób nesaa do moo heb'ooh do ỹ hado bä do hyb n'aa. Dooh wahed'ii do ỹ do bä. Dooh nesaa do moo hed'oo do ỹ do bä. Dooh ta wób sa ỹỹm sii he'ỹỹh do ỹ do bä. Dooh hahỹ dajẽẽr gahedak do hadoo ỹ hado bä”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Pawóp nuu me sét semaan ken'yyh õm ỹ hyb n'aa esee ỹ noo kanawa doo me. Sahõnh hẽ ỹ gadoo do uuh ỹ an'oo had'yyt a hã”, näng Pariséw kyyh P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dajẽẽr gahedak doo, dawëë tabagëët. Dooh hỹ pong jé taty däg bä, rabahed'oo doo da raky n'aa etsẽẽ bä. Ta h'yyb tagedyyk t'yyd kamehĩĩn do ky n'aa. Ti taky hadoo: “P'op Hagä Doo, ỹ mat'yyd mehĩĩn”, näng. “Nesaa do moo hew'ëët do ỹỹh”, näng ta kyyh —näng mä Jesus panyyg gó taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ti m' Jesus ky hadoo: —Bë ỹ maher'oot baad ub —näng mäh. —Sa tób hẽnh rababaaj hõm bä kä, dajẽẽr gahedak do ky n'aa etsẽẽ do P'op Hagä Do gadoo. Ta ti tii, baad hado däk ta h'yyb tym P'op Hagä Do an'oo bä. Pariséw, ti dooh P'op Hagä Do gado bä. Sahõnh hẽ sa daaj hẽ kaweh'ëëh doo, nu mebyy bong da, ta wób sa yd jé da ranu gapadäg hõm. Jé ta daaj hẽ kawaneh'ëëh doo, raweh'ëëh da P'op Hagä Do an'oo bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ti m' ta wób ramenaa sa taah ned'ëëd is do Jesus wë, sa hã Jesus moo däng hyb n'aa, taky n'aa edëng hyb n'aa. Ti m' ta ma matëg rage'ỹỹm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ti m' karepé Jesus naëënh ta wë, ti m' taky hadoo ta ma matëg sa hã: —Na ramena karepé wë ỹỹ. Bë geǟm manäh! Hahỹ karepé h'yy ka'eeh do hadoo, ti né hẽ P'op Hagä Do bag'ããs do karapee hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ti m' taky hadoo ẽnh: —Karapee t'aah ky daheeh do hadoo ky nadaheeh péh, dooh P'op Hagä Do bag'ããs do karapee tado bä da. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ti m' aj'yy sa wahë n'aa see eaanh mä Jesus hã. Ti m' taky hadoo: —Baad õm ma matëg! —näng mäh. —Nyy da ỹ bad'oo edëb had'yyt do gadoo hyb n'aa, P'op Hagä Do pa ỹ bawät hyb n'aa kä? —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ti m' Jesus ky hadoo ta hã: —Hëd n'aa baad ub hã ỹ mabanäng? —näng mäh. —Jããm hẽ P'op Hagä Doo, baad hadoo doo. Dooh ta see pé baad hadoo péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—Mahapäh hahỹ P'op Hagä Do ky n'aa jaw'yyk doo: “Aǟ manä a ỹỹm nadoo do sii, a patug nadoo do sii. Manaboh manä a da hadoo doo. Etsëëg manäh. Daap hẽ maky n'aa tapa manä ta wób. Mawehëë a yb, mawehëë a ỹỹn” —näng Jesus ta hã, P'op Hagä Do ky n'aa jaw'yyk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—P'ooj ub, ỹ karapee noo gó ỹ panyyg kadeheeh né hẽ tii hã —näng mä aj'yy Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ti m' taher'oot do Jesus maa napäh bä kä, taky hadoo ta hã: —Sét hẽ ti hawät a hã —näng mäh. —Mesëëm hõm sahõnh hẽ a wë hanäng doo. Man'oo ta säm paa kas'uut do sa hã. Tii d' madoo bä, hỹ pong jé magadoo da tak'ëp baad hadoo do P'op Hagä Do hanaa. Ti jawén, ana wë ỹỹ, hëp ỹ hata mabahadoo hyb n'aa kä —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ti m' ta hã Jesus her'oot do aj'yy maa napäh bä m', h'yy katón wät mäh, tak'ëp tawekãp do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ti m' Jesus ty gadäk ta wë, ti m' taky hadoo: —Hejoonh né hẽ wekãp do sa hã P'op Hagä Do bag'ããs do karapee n'aa rabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Hejooj né paawä kameer hã tatabëëj bä gats'uus doo gó, ta bahǟnh tabahejoonh wekãp do sa hã, P'op Hagä Do bag'ããs do karapee n'aa rabahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tii bä m', ta ti maa nap'ëëh do raky hadoo: —Jaa ẽnh ti P'op Hagä Do wë hasëëk ẽnh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ti m' Jesus ky hadoo: —Ji daaj hẽ ji nahaja bä paawä P'op Hagä Do wë ji as'ëëg bä, P'op Hagä Do hajaa ta wë ji tamasäk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ti m' Peed ky hadoo: —Sahõnh hẽ ãã wë hanäng do paa ãã beréd hõm, a hataa ãã bahadoo hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ti m' Jesus ky hadoo sa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: P'op Hagä Do bag'ããs do hyb n'aa heréd hõm pé ta tób, heréd hõm do ta ỹỹm, ta wakããn, ta yb, ta ỹỹn, ta taah, ");
INSERT INTO mbjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta bahǟnh hajõng da tagadoo badäk hahỹỹ bä ta mabaj. Ta jawén kä, hỹ pong jé kä tagadoo da edëb had'yyt doo. P'op Hagä Do pa tabawäd had'yyt da —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ti m' sa m'aa hẽnh Jesus naëënh 12 hedoo do ta ma matëg. Ti m' taky hadoo sa hã: —Ër ah'ũũm Jerusarẽnh hẽnh —näng mäh. —Sahõnh hẽ P'op Hagä Do ky n'aa rod rerii bong do paah, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ky n'aa hã, kametä däg kän hỹỹ kä hã ỹỹ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","—Ỹ da rahaëëj däk Judah buuj nadoo do sa moo gó —näng mäh. —Ỹ da raky n'aa ej'ees. Ỹ da raky n'aa rejãã. Ỹ da rahetsoos. Ỹ da rahewyyh. Ỹ da radajëëb kän —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","—Tamawoob hẽ ǟh ỹ jawén paa bä, ỹ d' ganä wäd kän —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dooh m' Jesus ma matëg rah'yy genä bä Jesus her'oot do hã. Kejën Jesus hanäng pé ta ti sa hã. Dooh m' rah'yyb mepëë bä Jesus her'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ti m' panang Jerikó häd näng doo bä Jesus kajaa bä kä m', ti ahäng mä ta tyw n'aa nabyy me ty tamah doo. Tahetsẽ mä dajẽẽr ta tii me tebës do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ti m' hajõk do ta tii me m' tab'ëës do tamaa napäh bä m', teaanh sa hã h'ëëd ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ti m' raky hadoo ta hã: —Jesus, Nasaréh hẽnh naa, ti ti tabës —näk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ti m' tageëëj wät. Hahỹỹ da m' ta kyyh: —Mat'yyd mehĩĩn ỹỹh, Jesus, Dawi panaa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti m' poo hẽnh hah'ũũm do raky ge'ỹỹm, bag hẽnh tabahäng hyb n'aa. Raky geǟm né paawä m', tak'ëp tageëëj wät tii bä: —Mat'yyd mehĩĩn ỹỹh, Dawi panaa! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ti m' Jesus baym. Ti m' tamejũũ ramanaa ta wë. P'eets hẽ Jesus wë tabag'ëëd däk bä m', Jesus beaanh ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—H'ëëd ti makarẽn ỹ moo wät a hã? —näng mäh. —Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Ỹ karẽn ỹ begãã däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ti m' Jesus ky hadoo ta hã: —Mabegãã däg —näng mäh. —Hã ỹ mah'yy ka'eeh do hyb n'aa õm has'oo däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti m' nayyw hẽ m' tabahapëë däk. Ti m' tabahõm kän Jesus sa jawén. P'op Hagä Do hã m' taj'aa etsëë kän. Hajõk do na-ããj mäh, rabahapäh bä m', raj'aa etsë né hẽ m' tii d' ẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ti m' Jesus bajëë suun panang Jerikó häd näng do noo bä. Ti m' panang me m' tatabës. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tii bä m' ti awät mä aj'yy Sakéw häd näng doo. Dajẽẽr gahed'aak do wahë n'aa see m' ta ti Sakéw. Tak'ëp mä ta ma näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Takarẽn paawä m' Jesus taheg'ããs. Dooh m' tahaja bä, tũũ tanu däg is do hyb n'aa, hajõk do raty gasuu do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ti m' sa pooj jé tawaj'aa hõm, b'aa hã m' tabas'ëëg sooh, tabaheg'ããs hyb n'aa baad ub Jesus hana doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","B'aa basooh bä m' Jesus kajaa bä m', tabaheg'ããs p'op b'aa hã, ti m' taky hadoo Sakéw hã: —Nayyw hẽ ahyyh —näng mäh. —Badah a tób bä ỹ nu däng —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ti m' tabahy gëët, h'yyb tsebé doo me tagadoo Jesus ta tób bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sahõnh hẽ m' rabahapäh bä m' ta tii, baad nadoo doo me m' ramaher'oot. Baad nado m' ti sa hã. Hahỹỹ da m' sa kyyh: —Nesaa do moo hew'ëët do tób hẽnh tabajëë suun. Tawëh ta sii —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ti m' Sakéw bas'ëëg gëët, ti m' Jesus hã taky hadoo: —Hyb n'aa jawyk doo —näng mäh. —Ỹ anoo hỹỹ kä wakãp ỹ bód, ỹ gakook kas'uut do sa hã —näng mäh. —Ỹ wad'ii bä ta wób, 4 nuu me ỹ banoo ỹ ab'aanh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ti m' Jesus ky hadoo ta hã: —Naga hẽ hahỹỹ bä tób bä haj'eenh do P'op Hagä Do bed'ëëp, Abaraãm panaa heh'äät, Abaraãm karapee hahỹ aj'yy tabahadoo do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","—Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ ahyng babä ỹ besoos hyb n'aa, ỹ bed'ëëp hyb n'aa ta s'ee hẽnh habong do paa P'op Hagä Do mahǟnh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ti m', ta ti taher'oot do maa napäh do hã Jesus baher'oot panyyg. Edaa däk Jerusarẽnh panang. Nayyw hẽ P'op Hagä Do bag'ããs do tadu doo red'oo mäh. Ti hyb n'aa Jesus baher'oot sa hã hahỹ panyyg: ");
INSERT INTO mbjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Ti awät aj'yy sa wahë n'aa t'aah. Dawëë, häj n'aa s'ee hẽnh takarẽn tabahõm, t'ĩĩ hẽnh hajõng häj n'aa bagã n'aa ta hã tamejũũ hyb n'aa, ta häj n'aa wahë n'aa tabahadoo hyb n'aa. Tii b' naa da tababaaj nä p'aa hẽnh ta häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ti m', tabahõm pooj jé, tatsyyd bong ta wë 10 ta karom wób. Sét moweed k'ããts tëg gabarëëh do tabanoo sét ken'yyh sa hã. Ti tamejũũ ta tii me ramoo bok hyb n'aa, ta dajẽẽr kah'ũũm hyb n'aa ta s'ee hẽnh tawäd nuuj jé. Ti tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ta karapee wób dooh ragenaag bä ta ti aj'yy. Ti hyb n'aa ramejũũ ta rod n'aa, ta jawén rabahõm hyb n'aa, hajõng häj n'aa bagã n'aa hã ramaher'oot hyb n'aa, rakanarẽn do ta ti aj'yy sa wahë n'aa tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tii kä m', ta wób dooh né paawä ragenaag bä, ti né sa wahë n'aa däg. Ti ta häj n'aa hẽnh tababaaj hõm kän. Takajaa bä kä tamejũũ ranaëënh ta wë ta karom, dajẽẽr tahanoo do paah, tahapäh hyb n'aa nyy da rabad'oo ta ti dajẽẽr kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ti m' pooj jé hana do ky hadoo: “Wahë ỹ n'aa”, näng, “a dajẽẽr jó ana 10”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ti ta kariw n'aa ky hadoo: “Baad ub mamoo wäd wät”, näng. “Karom baad hadoo do õm”, näng. “Baad maban'yyh, kanahën d'os hẽ né paawä, ti hyb n'aa da ỹ anoo hỹỹ kä a hã 10 panang mabag'ããs hyb n'aa”, näng ta kariw n'aa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ti ta see bana ta wë, ti taky hadoo: “Wahëh ỹ n'aa”, näng, “a dajẽẽr jó ana 5”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ti ta kariw n'aa ky hadoo: “A hã kä ỹ anoo 5 panang bagã n'aa õm kä”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ti ta see bana ta wë, ti taky hadoo: “Wahë ỹ n'aa”, näng, “hỹ a dajẽẽr hã ỹ manoo do paah”, näng. “Saroor me ỹ bahabën däk, ti ỹ benyyw däk mamatëëh bä kä”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Tak'ëp mamejũũ a karom sa hã. Ti hyb n'aa õm ỹ jeỹỹm”, näng. “Mado hõm a ma nadoo doo. Mataa joom manejoom doo”, näng ta karom kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ti ta kariw n'aa ky hadoo ta hã: “Karom ky nesaa do õm”, näng. “A kyy hyb n'aa õm ỹ ky n'aa etyy hỹỹ kä”, näng. “Mahapäh mä, a nooh, tak'ëp baad ỹ ban'yyh karom ỹ moo bok doo, ma ỹ nadoo do ỹ ado hõm mäh, joom ỹ nejoom do ỹ ataa, a nooh”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Mahapäh mäh, a nooh. Hëd n'aa dajẽẽr manan'oo däk dajẽẽr me moo heb'ooh do sa hã? Tii bä kä, ỹ kajaa bä kä, ta bahǟnh paawä ỹ gadoo dajẽr ỹỹ”, näng ta kariw n'aa ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ti ta pa hab'ëëh do hã taky hadoo: “Bë ado hõm sét hẽ moweed ta wë hanäng doo. Bë an'oo 10 moweed wë näng do hã”, näng ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ti raky hadoo: “Ãã wahë n'aa”, näk. “Ti anyy däk ẽnh 10 ta wë.” ");
INSERT INTO mbjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ti taky hadoo: “Bë ỹ maher'oot”, näng. “Jé wë näng do sa hã, ti bahǟnh takan'oo däk sa hã. Kanahën d'os hẽ wë näng doo, kanahën had'os do sii hẽ ta wë hanäng do kado hõm da”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Hỹỹ kä majẽ ỹỹ hã kä, ỹ rakanarẽn do sa wahë n'aa ỹ nahadoo hyb n'aa, bë manaa babä. Bë dajëëb matym ỹỹ gó”, näng hëëj wahë n'aa kyyh —näng mä Jesus panyyg gó m' tabeh'ũũm sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ti m' Jesus bahajaa bä kä panyyg taher'oot doo, tabahõm kän mä Jerusarẽnh hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti m' tabedaa däk bä panang Betapagéh, Betanija häd enäh doo, waëë joom oriib häd näng do banäng bä, pawóp hẽ ta ma matëg Jesus mejũũ mä sa pooj jé. Hahỹỹ d' mä ta kyyh sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Bë ahõm panang hẽnh bë pooj jé badäk doo hẽnh ti nuuj jé. Bë kajaa bä, bë hapäh da jumeto t'aah ji najasooh nä doo. Ta tyd hã da tabahäng —näng mäh. —Bë asood hõm da, bë mana wawẽẽ hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—“Hëd n'aa ti bë as'oot?”, ranoo bä, “Tak'ëp Hyb N'aa Jawyk Do karẽn”, näk da bë kyyh —näng mä Jesus pawóp hadoo do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ti m' rabahõm, ti m' Jesus maher'oot doo da né hẽ m' rabawyyd kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ti m' rabas'oot bä kä m', ta danäh rabeaaj kän: —H'ëëd ti bë hab'ëëh? Hëd n'aa ti bë as'oot? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ti m' raky hadoo: —Ãã wahë n'aa karẽn —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ti m' ramana kän Jesus wë. Ti m' sa hatsë sa hã padëëk do paa radatoonh jumeto jó. Ti m' ramasa, Jesus bas'ëëg so kän ta jó. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jumeto jó tabahõm me m', hajõk do sa hatsë sa hã padëëk do paa rat'ëëg hõm ta tyw n'aa me, tamahõm doo me, raweh'ëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ti m' ta tyw n'aa waëë Oriib häd näng doo hẽnh naa ta poo hyng bä kä rakajaa bä kä m', hajõk do ta ma matëg h'yyb tsebé doo me P'op Hagä Do hã m' raj'aa etsëë kän. Tak'ëp mä sa kyyh. Raj'aa etsëë kän, sahõnh hẽ Jesus pahuunh do paa rahapäh do hyb n'aa. Hahỹỹ da m' sa kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Ky n'aa kedëng hahỹ ër wahë n'aa, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo! —näk mäh. —Ãã karẽn sahõnh hẽ hỹ pong jé h'yyb nyyw gó raky daheeh P'op Hagä Doo. —Hỹ pong jé hawät do hã ãã j'aa etsë —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ti m' Pariséw, sa mahang habong doo, raky hadoo: —Ma matëg! —näk mäh. —Maky geǟm a ma matëg —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ti m' Jesus ky hadoo: —Bag hẽnh rabë bä paawä, hã ỹ raj'aa netsëë bä paawä, hahỹ pä paawä ỹ raj'aa etsëë kän sa jawén buuj —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ti m' tabedaa däk bä Jerusarẽnh hẽnh, panang tabahapäh bä m', Jesus p'ãã oot mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ti m' taky hadoo: —Tak'ëp ỹ karẽn paawä hahỹỹ hã, a babuj n'aa, rabahapäh hyb n'aa paawä nyy d' rabaw'yyt sa h'yyb näw. Dooh rah'yy genä bä ta hã. Kejën sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—Ti awät da a majĩĩ ramoo bok do a hadë rabehaa doo, tii me ramajëë p'ëë hyb n'aa. Õm da ranu get'ëë däk. Õm da ranoo gatsëë hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Õm da ranes'ëëm, a babuj n'aa radej'ëëp da. Dooh paa a babuj n'aa rakarẽn ragado P'op Hagä Do mejũũ do sa mahang. Ti hyb n'aa a majĩĩ da dooh da a babuuj tób n'aa pä hadoo pé rerét pé ta see jó. Sahõnh hẽ takepyyj hyng —näng mä Jesus Jerusarẽnh hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ti m' Jesus bajëë suun mä P'op Hagä Do tób n'aa w'oo hã, kahadë doo gó, wahoo gó. Ti m' Jesus bahabëë bong tii bä hes'ëëm doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ti m' taky hadoo: —Hahỹỹ da takerii däk P'op Hagä Do kyyh: “Tóp ỹỹ da, P'op Hagä Do hã ji ky n'aa etsẽẽ do tób n'aa da” —näng mäh. —Hỹỹ kä baretsëg tób n'aa hado däk bë an'oo bä! —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti m' tama met'ëëg had'yyt hẽ m' P'op Hagä Do tób n'aa bä. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, ta wób sa wahë n'aa na-ããj mä rakarẽn mä Jesus radaj'ëëp. ");
INSERT INTO mbjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Du daa m' rabad'oo pé hajõk do Jesus manew'ëë do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti m' ta see pé noo gó P'op Hagä Do tób n'aa wahoo gó, kahadë doo gó, panyyg hanäm do Jesus ma metëëk bä kä m', kajaa mä ta wë P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo, na-ããj mä Judah buuj sa wahë n'aa hedoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ti m' raky hadoo ta hã: —Jaa kyy gó mabad'oo hahỹ mabad'oo doo? Jaa ky gabuuj? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ti m' Jesus ky hadoo sa hã: —Ỹ eaanh bë hã ẽnh —näng mäh. —Bë her'ood hã ỹỹ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—Jaa kyy gó Jowãw nu gahem'uun do nu gemuun paah? Hỹ pong jé hawät do kyy gó, sa ky gabuuj hẽ paah? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tii bä m' sa m'aa hẽnh mä raky n'aa hajẽẽw bong. Hahỹỹ d' mä sa kyyh: —Hỹ pong jé hawät do kyy gó ër noo bä, teaanh da ër hã tii bä: “Hëd n'aa paa ti bë ky nadaheeh ẽnh?”, näng da. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ajyy kyy gó ër noo bä, hajõk do ër da rakut pä me ër dejëp hyb n'aa, sa hã m' P'op Hagä Do ky n'aa rod paa m' sa h'yyb Jowãw —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ti hyb n'aa m' raky hadoo Jesus hã: —Dooh ãã hapëë bä jaa kyy gó —ken'ooh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ti m' Jesus ky hadoo sa hã: —Ỹ na-ããj né hẽ dooh ỹ her'ood bä ky gabuuj näng do hã ỹỹ, tii da ỹ bad'oo doo —näng mä ta kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ti m' Jesus baher'ood kän panyyg ky n'aa me sa hã. Hahỹỹ da m' tabaher'oot: —Hỹ hadoo aj'yy bejoom hõm uwa häd näng do ta joom. Tii b' tabahaëëj däk ta joom banäng do ta kaser n'aa sa hã. Ti ta s'ee hẽnh ta danäh bahõm hajõõ ta baab n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Joom ag wah'ëë däk bä kä, ta danäh mejũũ ta sii moo wät do see ta kaser n'aa sa wë, tagadoo hyb n'aa joom ag wób. Ti takajaa bä kä, rabahewyh wät, ramejõ hõm p'aa hẽnh bag hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ti ta danäh mejũũ ẽnh ta seeh. Rahewyh wät né tii d' ẽnh, rarahejãã, ramejõ hõm né tii d' ẽnh bag hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ti tamejõ kän ta seeh. Rog näng sa mo haj'aa tii kä, ti radawäts nyyh joom bahǟnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ti joom danäh ky hadoo ta h'yyb gó: “Nyy d' ỹ bad'oo hỹỹ kä”, näng mäh. “Tah ỹỹ, ỹ kamahǟn do ỹ mejũũ hỹỹ kä. Tah ỹ apäh da raweh'ëëh”, näng mä ta h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ti tamejõ kän. Ta kaser n'aa rabahegãã däk bä kä, sa mab hẽ rakaner'oot. Hahỹỹ da sa kyyh: “Ta danäh t'aah hahỹỹh. Ti d' ta danä däg ta yb jawén buuj däg”, näk mäh. “Ti bä, ër dajëëb! Ër ma däg da tii bä kä hahỹ joom banäng doo”, näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tii d' né kä, ramejõ hõm joom bahǟnh, ti ranaboh jad kän —näng mä Jesus. Panyyg gó m' tabeh'ũũm sa hã. Ti m' teaanh sa hã: —Nyy da joom danäh bad'oo hỹỹ kä sa hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Ana da, tadej'ëëp da ta kaser n'aa, ta wób hã da tabahaëënh tii bä —näng mä Jesus. Ti m' maa new'ëë do raky hadoo: —Dooh paawä tii d' ãã karẽn P'op Hagä Do an'oo bä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ti m' Jesus ty däng sa hã, ti m' tabeaanh: —Nyy da bë hã ẽnh hahỹ P'op Hagä Do kyy kerih doo? “Pä tób n'aa tehem'aa do raty n'aa ges'yyk doo, hỹỹ kä pä ta ba n'aa däg, mesoo n'aa däg” —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ti m' Jesus ky hadoo: —Sahõnh hẽ pä hadoo do ty n'aa ges'yyk péh, rahoop da nesaa doo. Ji jó ta ti pä tadëë bä, sahõnh hẽ ji gawatsik —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tii bä kä m', Mosees ky n'aa jaw'yyk do ma mehetëk doo, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa na-ããj mäh, ratyw n'aa esoos mäh, nayyw hẽ ramaso däk hyb n'aa paawä m' Jesus. H'yy genäh mä Jesus pes'ããp mä panyyg ky n'aa me sa hã. E'ỹỹm mä hajõk do Jesus maa new'ëë do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ti m' baad mä ramatakä had'yyt hẽ Jesus. Ti hyb n'aa m' ramejũũ ta wób ky ken'yym doo gó rake'aanh Jesus hã. Rakarẽn paawä rano n'aa masoo taher'oot do hyb n'aa, rahaëënh hyb n'aa Roma buuj ta tii bä hagã n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ti m' j'ooj madäk doo me raky hadoo Jesus hã: —Ma matëg! —näk mäh. —Ãã hapäh baad hadoo do né hẽ ti mama metëëk, baad hadoo do né hẽ ti maher'oot —näk mäh. —Dooh maky n'aa ehỹỹd bä ta wób sa hã, séd gó mabaher'oot sahõnh hẽ sa hã. Ehub né hẽ P'op Hagä Do karẽn do hã mama metëëk doo —näk mäh. —Ti hyb n'aa —näk mäh —ãã mamaher'ood. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Taw'ããts hẽ a hã ji epaag bä Roma buuj sa wahë hã rahepak doo, Sesa hã? —näk mäh. —Ji ep'aak a hã? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesus hapäh mä ti sa h'yyb. J'ooj madäk doo me ti raky hadoo doo. Ti m' taky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Bë metäh hã ỹỹ moweed denaari ramaneëënh doo —näng mäh. —Jaa heen n'aa hahỹỹh? Jaa häd hahỹ kerih do ta hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ti m' raky hadoo: —Sesa heen n'aa, Sesa häd —näk mäh. Ti m' Jesus ky hadoo: —Bë an'oo Sesa hã ta no n'aa, ta heen n'aa hadäk doo. Bë an'oo P'op Hagä Do hã ta no n'aa hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dooh m' raw'yyt pé ta hã ta s'ee hẽnh taher'oot pé hajõk do maa napäh bä. Rahyb n'aa meuunh mä ta kyyh hyb n'aa, ti hyb n'aa dooh radoo wät péh. Bag hẽnh rababë hõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ti m' rakajaa Jesus wë Saduséw häd enäh do wób, rake'aanh hyb n'aa m'. Sa hã m' dooh m' ji ganä wäd bä ji dajëb bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ti m' raky hadoo Jesus hã: —Ma matëg! —näk mäh. —P'ooj ub Mosees erii däk do paa ër hã, aj'yy dajëb bä, ta ỹỹm teréd wäd bä tanetaa nä bä, tii bä m' ta hỹỹj mä gat'ëë däk tii, ta hỹỹj makũ panaa näng hyb n'aa m' —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Panyyg gó õm ãã maher'oot —näk mäh. —Hỹ hadoo aj'yy 6 ta hỹỹj. Tagat'ëë däk mä ta ỹỹm paah. Dooh m' teta nä bä, aj'yy dajëp. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tii bä ta hỹỹj seeh, ta jawén näh, gat'ëë däk mä ta hỹỹj makũ ỹỹm paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ta jawén mä ta hỹỹj seeh. Ti hadoo né m' ta wób ẽnh. Sahõnh hẽ m' raget'ëë bok ta ti ỹỹnh. Sahõnh hẽ m' dooh reta nä bä radejëp. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tii kä m' ỹỹnh dajëb kän —näk mä Saduséw panyyg gó m' rabeh'ũũm Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ti m' rabeaaj kän Jesus hã: —Ji genyyh bä kä ẽnh, dejëp do paa ji? —näk mäh. —Ny hadoo do ỹỹm kä ta ti ỹỹnh ti noo gó kä? Sahõnh hẽ paa ta ti ta pat'uuk —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ti m' Jesus ky hadoo sa hã: —Ji ketëë badäk hahỹỹ bä tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tii d' nado hỹ pong jé hasëëk do hã. P'op Hagä Do anoo do ragenä bong doo, dooh raket'ëë boo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ããs kanetëë do hadoo da tii kä. P'op Hagä Do anoo ragenä bong hyb n'aa, ti hyb n'aa P'op Hagä Do taah kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Mosees mo haj'aa kerih do hã, b'aa kadoo do panyyg n'aa gó, ji ganä wät Mosees metëëk. Hahỹỹ da Tak'ëp Hyb N'aa Jawyk Do kyyh Mosees erii wät do hã: “P'op Hagä Doo, Abaraãm hagã n'aa, Isak hagã n'aa, Jakóh hagã n'aa ỹ ti hỹỹh.” ");
INSERT INTO mbjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dooh, “Abaraãm makũ hagã, Isak makũ hagã, Jakóh makũ hagã” tanoo bä. P'op Hagä Do hã ti edëp. Dejëp do hagã n'aa nado P'op Hagä Doo. Hedëp do sa hagã n'aa tii —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk do wób raky hadoo: —Baad mabaher'oot, baad a kyyh, ma matëg! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ti bahǟnh kä m' dooh m' reaaj boo bä kä. H'yyb e'ỹỹm mä reaaj bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ti m' Jesus ky hadoo sa hã: —Dawi panaa mä ti Kristo, P'op Hagä Do H'yyb Däng Doo, sa nooh. Nyy da tii? ");
INSERT INTO mbjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hahỹỹ da paa m' Dawi kyyh Saaw-Mo hã: “Wahë ỹ n'aa hã Tak'ëp Hyb N'aa Jawyk Do ky hadoo, ‘Aso hup ỹỹ hẽnh, ");
INSERT INTO mbjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","si ỹ mabag'ããs hyb n'aa a majĩĩ ỹ nes'ëëm bä kä’”, näng paa Dawi. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hỹỹ kä, “Wahë ỹ n'aa” Dawi maneëëj bä ti Kristo, nyy da ti ta t'aah tabahadoo? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ti m' sahõnh hẽ maa new'ëë bä m', Jesus ky hadoo ta ma matëg sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Baad da bë kanä Mosees ky n'aa jaw'yyk do ma mehetëk doo da bë nad'oo hyb n'aa —näng mäh. —Baad ub da raken'yym, baad rakametëëh saroor henyym doo me, ky n'aa gebah doo me —näng mäh. —Rakarẽn ji bedëng hajõk do sa mahang —näng mäh. —Tób P'op Hagä Do panyyg rayd naherot doo bä ragen'aak ratooj bä hyb n'aa jewyk do rabahetonh bä. Ratsebé do tä n'aa noo gó, ragen'aak ky n'aa etsëëh do rabahetonh bä ratooj bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Patug tema bong do sa wë hanäng do bë esok. Ti bäp peej hadoo doo me bë ky n'aa etsẽẽ, bë hã ta wób raj'aa etsë hyb n'aa. Ta ti hedoo do ta bahǟnh tak'ëp P'op Hagä Do rajãã da —näng mä Jesus kyyh Mosees ky n'aa jaw'yyk do ma mehetëk do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ti m' P'op Hagä Do tób n'aa bä Jesus bagëët bä, tahapäh tak'ëp dajẽẽr enäh do radatoonh do dajẽẽr, tób P'op Hagä Do rahyb n'aa esee do dajẽẽr n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ti m' tabana ỹỹnh, patug tamaa wäd is doo. Tadatooj is mä pawóp its moweed. Kanahën its mä tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ti m' Jesus bahapäh bä ta tii, taky hadoo: —Hahỹ ỹỹnh, patug tamaa wäd is doo, sahõnh hẽ sa bahǟnh tabanoo. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","—Sahõnh hẽ ta wób ranoo do tii, hajõng do sa wë mad'aak do uuh —näng mäh. —Hahỹ ỹỹnh, kasuud its né paawä, sahõnh hẽ taban'oo däg is ta wë hanäng do paats —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ti m' Jesus ma matëg wób raher'oot mä pä s'ëëb P'op Hagä Do tób n'aa. Hetsooh mä sa hã. Raher'oot na-ããj mä ta wób sa mo haj'aa ta hetsó wób, P'op Hagä Do matym n'aa retsëëh doo. Ti m' Jesus ky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ti awät da ti noo gó kä, ta ti pä jé pad'yyt hẽ takajäg jëng. Dooh da ta see jó haso wät pé hahỹ bë hapäh do pä. Sahõnh hẽ da rabakud bëëh tũũ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ti m' ta ma matëg rabeaanh: —Ny noo gó da ti tii d' maher'oot do tadu däk? H'ëëd hado da tabedaa däk do heen n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ti m' Jesus ky hadoo sa hã: —Baad bë matakä da, bë rawanadii hyb n'aa. Hät ỹỹ gó rabana, sa nooh. “Ỹ Kristo”, näk da sa kyyh. “Edaa däk sahõnh hẽ tagawatsik doo”, näk da. Bë ky dahé manä tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Bë eỹỹm manä da kaneb'ooh do bë ky n'aa napäh bä, ta wób sa wahë n'aa wë rah'yy kawereem do bë ky n'aa napäh bä na-ããj hẽ. Badäk hahỹ gawatsik do pooj jé, ti hadoo né da. Ti hado né hẽ paawä, dooh nayyw hẽ takaja bä badäk hahỹ bahëëj jëng doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ti m' taky hadoo ẽnh sa hã: —Häj n'aa see babuuj rakaneb'ooh da häj n'aa see babuuj sa daheeh. Häj n'aa sa wahë n'aa, rah'yy kawereem da häj n'aa see sa wahë n'aa wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hajõng häj n'aa hẽnh da tak'ëp né da hëëj katajuus. Sah na-ããj da anäng. Hajõk da tak'ëp ranahëë enäh da. Ǟm n'aa näng do ti awät da. Ǟm n'aa näng do heen n'aa ganyyh da wë hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ti pooj jé da bë da rano n'aa masoo. Bë da rarejãã. Bë da rahaëënh tób P'op Hagä Do panyyg rayd naherot do wahë n'aa sa moo gó, bë raky n'aa etyy hyb n'aa. Bë da radewäts b'ëëh. Bë da ramahũũm hëëj bagã n'aa sa wë, sa wahë n'aa wób wë na-ããj hẽ, bë raky n'aa tapaa hyb n'aa sa hã. Hëp ỹ n'aa tii da rabad'oo da bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","—Këh ỹ n'aa bë her'ood kän da tii bä sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—Bë hyb n'aa tón manäh, bë ky n'aa sa hã bë her'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ỹ anoo da bë hã bë er'oot do pan'aa. Tak'ëp da bë ỹ h'yy gan'yyh. Ti hyb n'aa bë majĩĩ dooh da bë rahaja bä, dooh d' sa kyy péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Bë yb, bë ỹỹn, bë wakããn, bë najiis na-ããj né hẽ bë né rahaëëj padëëk bë majĩĩ sa hã. Radej'ëëp da bë wób. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tak'ëp da sahõnh hẽ rakawajããn da bë wë, hëp ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ti hadoo né hẽ, dooh P'op Hagä Do mabaan bëëh. Sahõnh hẽ bë hã tahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bë h'yy kaneréd bä hã ỹ bë h'yy ka'eeh do hã, P'op Hagä Do wë da bë baboo had'yyt hẽ kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ti m' taky hadoo ẽnh: —Jerusarẽnh nu kat'ëë däk ta majĩĩ warahén n'aa ran'oo bä bë bahapäh bä, edaa däk da bë bahapëë kän tagawatsik doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tii bä da taw'ããts hẽ Judah häj n'aa bä haj'eenh do rakejën hõm da waëë banäng hẽnh. Jerusarẽnh bä haj'eenh do taw'ããts hẽ rakejën hõm sa panang bä naa. Panang bahǟnh habong do taw'ããts hẽ da dooh rana bä p'aa hẽnh panang hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti noo gó da P'op Hagä Do anoo da Isaraéw buuj ta säm baanh. Sahõnh hẽ P'op Hagä Do kyy kerih do kametä kän sa hã kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—Tak'ëp tanesaa het'aah doo, sa taah nebii do sa hã kä ti noo gó kä! Tak'ëp nesaa do rabahoop Isaraéw häj n'aa bä. Tak'ëp da P'op Hagä Do banoo sa hã nesaa doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","—Ta wób da dejëp sa majĩĩ kuman haj'aa. Ta wób da ramoo maw'yyd hõm ta s'ee hẽnh, jé pad'yyt hẽ häj n'aa hẽnh. Panang kä, Jerusarẽnh, rababep da Judah buuj nadoo do hã. Tii da rabad'oo P'op Hagä Do h'yyb däng do peej kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ti m' Jesus ky hadoo ẽnh: —Ta jawén, papỹỹj hã, kamarab hã, sagõõh sa hã ji hapäh da meuj n'aa näng do heen n'aa, ǟm n'aa näng do heen n'aa. Sahõnh hẽ häj n'aa babuuj rahyb n'aa tón da, h'yy gabedo bong da, hewëëh do hyb n'aa akajar maadaka, tak'ëp hadoo do hyb n'aa akajar maadaka kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tak'ëp rajeỹỹm do hyb n'aa da ti noo gó, ta wób degõn jëng da. H'yyb e'ỹỹm bong da, tak'ëp nesaa do ti hawät do hã rahyb n'aa newëë do hyb n'aa. Wë hã habong do ta bag keh'ỹỹt da jé pad'yyt hẽ, ta see hedo hõm da P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ti noo gó kä da sahõnh hẽ rabahapäh da ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo kä, ỹ bahyng bä kä wë puh mahang. Ỹ ahyng da P'op Hagä Do hejój me, ta bag tak'ëp gabarëëh do hadoo doo gó —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","—Bë h'yy kahasããb kä ta ti ta heen n'aa bë bahapäh bä kä, edaa däk do hyb n'aa kä bë P'op Hagä Do ed'ëëp do nesaa do mahǟnh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ti m' panyyg gó m' tabaher'oot sa hã. Ti m' taky hadoo: —Ta heen n'aa ỹ her'oot doo, joom wiigo häd näng doo, joom wób ky n'aa hadoo na-ããj hẽ tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","—Joom tadu doo bä tagajewäng doo, baad bë bahapäh, edaa däk tabanyyw. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti hadoo né da, sahõnh hẽ ta ti bë ỹ maher'ood wät do kaja däk bë bahapäh bä, edaa däk P'op Hagä Do bag'ããs doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ti m' taky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Da hẽ habong do rahapäh nä da sahõnh hẽ ỹ her'ood wät do bawäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Badäk hahỹỹh, wë na-ããj da, ahëëj jëë né paawä, këh ỹỹ da dooh tahëëj bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ti m' Jesus ky hado kän: —Bë hyb n'aa matakä da, ta s'ee hẽnh bë h'yyb nawät hyb n'aa. Bë h'yyb padäg manä jarakë hedoo do hã. Bë an'oo manä badäk hahỹỹ hã ji hyb n'aa tón do bë hyb n'aa hũũm bä, ta s'ee hẽnh bë h'yyb nawät hyb n'aa. Taw'ããts hẽ bë hyb n'aa matakä bë h'yy ganatemah hyb n'aa ỹ kajaa bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ỹ kajaa do heen n'aa, nayyw hẽ da, raganada bä, takajaa sahõnh hẽ badäk hahỹỹ hã habong do sa wë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","—Taw'ããts hẽ bë hyb n'aa matakä had'yyt hẽ. Bë ky n'aa ets'ẽẽ P'op Hagä Do hã, bë ked'ëëp hyb n'aa ta ti ỹ her'oot do paa nesaa do mahǟnh. Bë ky n'aa ets'ẽẽ na-ããj hẽ, bë bahajaa hyb n'aa matym ỹỹ gó, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do matym gó, bë bab'ëëh hyb n'aa, baad bë ỹ gadoo hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesus ma met'ëëg had'yyt mä P'op Hagä Do tób n'aa bä. Tug bä hadoo tabaheh'ũũm panang bahǟnh, waëë Oriib häd näng doo hẽnh, t'ĩĩ hẽnh mä tabahe'ỹỹh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bäp paa m' hajõk do rabaheh'ũũm, ramaa newëë hyb n'aa Jesus P'op Hagä Do tób n'aa yt hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ti m', edaa däk Pas-kowa häd näng do bawät, pãw makuj tamah do rabawa noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj mä ratyw n'aa esoos mä Jesus radaj'ëëp hyb n'aa. Rahyb n'aa newëë nyy d' rabad'oo, hajõk do rakawaj'ããn bä sa wë rajeỹỹm do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ti m' Judas Ikarijot häd näng do h'yyb gó Nesaa Do Yb bajëë suun. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ti m' Judas bahõm P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wë, P'op Hagä Do tób n'aa warahén n'aa sa wahë n'aa wë na-ããj hẽ, séd hã rakaner'oot hyb n'aa nyy da sa hã Jesus tabahaëënh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ti m' rah'yy gadejah Judas Ikarijot kyy hã. Ti m' ta säm raky kajäk ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ti m' Judas Ikarijot tyw n'aa esóts kän, tabahaëënh hyb n'aa kä sa hã rabanahajõk bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ti m' pãw makuj n'aa tamah do rataheb'ëës do du däk. Ti noo gó b'éé t'aah aj'yy ranaheb'ooh P'op Hagä Do matym n'aa, Pas-kowa rahyb n'aa esee do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ti m' Jesus mejũũ Peed Jowãw daheeh, ti m' taky hadoo sa hã: —Bë ahõm nä Pas-kowa tä n'aa bë moo bok hyb n'aa, ër tab'ëës hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ti m' rabeaanh ta hã: —Nyy bä makarẽn ãã benäm Pas-kowa tä n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ti m' Jesus ky hadoo: —Bë ahõm nä panang hẽnh. Panang bä bë kajaa bä, bë kataa da aj'yy hã, naëng hes'ooh do hã. Ta jawén bë ahõm da. Ta ti bajëë suun bä tób gó, ");
INSERT INTO mbjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bë eaaj da tób danäh hã hahỹỹ da: “Ãã ma matëg mejũũ ãã beaanh, nyy bä tagadäk ta gawakõ, tatab'ëës hyb n'aa Pas-kowa, ta ma matëg sa daheeh”, denoo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tii bä da ta gawakõ gaeh doo, p'op gadäk doo, tametëëh da bë hã. Ta tii bä tyng n'aa näng da. Kabenyyw däk da —näng mäh. —Tii bä bë moo boo Pas-kowa tä n'aa, ta waa n'aa —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti m' rabahõm kän. Rakajaa bä m' panang bä, Jesus her'oot do hadoo né kä m'. Ti m' ramoo boo kän tii bä kä Pas-kowa tä n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ti m' Pas-kowa tä n'aa kajaa bä kä m', Jesus bahyy sooh mä 12 hedoo do tamejũũ do sii hẽ sa waa tyng pa. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ti m' Jesus ky hadoo sa hã: —Baad ỹ h'yyb däng né hẽ hahỹ ỹ awëh bë daheeh, ỹ rarejãã do ỹ ahoop do pooj jé —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","—Dooh ỹ awëë wäd bä kä hahỹ ta jawén. Séd debaa hẽ ỹ bawëë kän Pas-kowa heh'äät doo kä hỹ pong jé, P'op Hagä Do bag'ããs bä kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ti m' tabado däk uwa bëëh hood, ti m' P'op Hagä Do hã ta ky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk uwa bëëh ãã hã —näng mäh. Ti m' taky hadoo sa hã: —Bë gadoo, bë ets'ëëh bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","—Hahỹỹ d' bë ỹ maher'oot: Hỹ jawén dooh ỹ eëg wäd bä uwa s'ëëb. Jããm hẽ p'aa hẽnh ỹ eëëk da P'op Hagä Do bag'ããs do kajaa bä kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ti m' tabado däk pãw, ti m' P'op Hagä Do hã taky hadoo: —Taw'ããts hẽ õm, Ee. Man'oo däk pãw ãã hã —näng mäh. Ti m' taganabäh däk, tan'oo däk mä ta ma matëg sa hã. Ti m' taky hadoo: —Hup ỹỹ, bë hyb n'aa ỹ an'oo däk do heen n'aa hahỹỹh —näng mäh. —Hỹ jawén hahỹỹ d' bë bad'oo, ỹ bë hyb n'aa esee do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ti hadoo ẽnh, rabawëh, rabawa do jawén paa bä, Jesus bado däk ẽnh uwa bëëh hood, ti m' taky hadoo: —Majyw ỹỹ, ỹ anoo do ỹ dajëp noo gó bë hyb n'aa heen n'aa hahỹỹh. Papuuj sahõnh hã P'op Hagä Do ky n'aa enooh do tii kä. Hỹ jawén majyw ỹ hyb n'aa ji tagadoo, P'op Hagä Do ky däng —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ti m' taky hadoo ẽnh: —Bë maa newë! —näng mäh. —Ër mahang ti asooh majẽ ỹ moo gó ỹ tahaëënh doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","—Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ da dajëp P'op Hagä Do kyy kerih do her'oot doo da né hẽ —näng mäh. —Ti hadoo né hẽ, baad nado da aj'yy hã, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do majĩĩ moo gó han'oo däk do hã! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ti m' sa mahang rabeaanh: —Jaa g'eeh tii? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ti m' sa bahǟnh hadoo do p'ãã m' raky ked'aak. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti m' Jesus ky hadoo sa hã: —Judah buuj nadoo do sa wahë n'aa, hyb n'aa jewyk hedoo doo, tak'ëp ramejũũ sa karapee n'aa. “Sa masa n'aa” sa daaj hẽ rakamaneëënh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","—Bë mahang taw'ããts hẽ dooh tii d' tahado bä —näng mäh. —Bë mahang karẽn pé ta wób sa bahǟnh hyb n'aa jawyk péh, taw'ããts hẽ da ta wób sa yd jé da tanu gadäk. Bë wahë n'aa hadoo doo, taw'ããts hẽ ta wób sa karom hado däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","—Ny hadoo pé hyb n'aa jawyk? Ta tyng n'aa jó hasooh doo, ta tyng jó hasoo do waa manaa doo? Ny hadoo pé hyb n'aa jawyk? Ta tyng jó hasooh do né hẽ —näng mäh. —Ỹ tii, dooh tii da ỹ adoo bä. Sa karom sa tä manaa do hadoo ỹ bë mahang, ỹ hyb n'aa jawyg né paawä bë bahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Hëp ỹ hata had'yyt hẽ bëëh, nesaa do ỹ ahoop noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ti hyb n'aa hã ỹ Ee banoo do hadoo ỹ bag'ããs doo, tii da ẽnh bë ỹ banoo bë bag'ããs si ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti hyb n'aa bë awëh da, bë eëëk da si ỹỹ, ỹ bag'ããs do noo gó, bë ỹ weh'ëëh do ky n'aa. Bë da at'oonh wahë n'aa tyng jó, 12 hedoo do Isaraéw taah panaa bë bag'ããs hyb n'aa, bë ky n'aa etyy hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ti m' Jesus ky hadoo Peed hã: —Simaw, Simaw —näng mäh. —Nesaa Do Yb ets'ẽẽ wät tak'ëp bë tametyy hyb n'aa. Takarẽn paawä bë beréd hõm hã ỹ bë h'yy ka'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ti hado né paawä, P'op Hagä Do hã ỹ ky n'aa ets'ẽẽ wät õm, manerét hyb n'aa hã ỹ mah'yy ka'eeh doo —näng mäh. —Mah'yy kawareem bä, p'aa hẽnh tak'ëp hã ỹ mah'yy kae bä, mah'yyb enäw ta wób hã ỹ h'yy ka'eeh doo —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ti m' Peed ky hadoo: —Tak'ëp Hyb N'aa Jawyk Doo —näng mäh. —Dooh ỹ h'yy keréd bä a hã —näng mäh. —Ỹ radawäts g'ëëd bä, na radawäts g'ëëd ỹ a sii. Ỹ radajëëb bä, na ỹ radajëëb a nemuun, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ti m' Jesus ky hadoo ta hã: —Baad õm ỹ maher'oot Peed —näng mä —Badah, atsëm, karaak bahỹỹh do pooj jé, tamawoob nuu me da ỹ maky n'aa jejën da —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ti m' Jesus beaanh ta ma matëg sa hã: —Bë ỹ mejũũ noo gó P'op Hagä Do ky n'aa bë baher'ood hõm hyb n'aa, dooh ỹ an'oo bä bë mahũũm pé dajẽẽr hadoo péh, ta hood hadoo péh, bë tsyym suun bë wareem péh. Bedoh bë wë ti noo gó? —näng mäh. —Dooh —näk mäh. —Dooh badoh pé ãã wë —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ti m' Jesus ky hadoo: —Hỹỹ kä bë mahũũm bë wë tanyy bä dajẽẽr, bë h'ëëd hood na-ããj hẽ. Bë wë tananyy bä bë kuman mariij, taw'ããts hẽ bë esëëm hõm bë hatsë bë hã hadäk doo, bë kuman bë betsẽẽ hyb n'aa ta säm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","—Hahỹỹ da P'op Hagä Do kyy kerih do këh ỹ n'aa hã: “P'op Hagä Do ky n'aa jaw'yyk do ky nadah'eeh do h'yyb hata däk ran'oo bä P'op Hagä Do H'yyb Däng Doo”, näng P'op Hagä Do kyy kerih doo —näng mä Jesus. —Sahõnh hẽ këh ỹ n'aa kerih doo gó her'oot doo, ta ti hadoo né kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ti m' ta ma matëg raky hadoo ta hã: —Ma matëg! —näk mäh. —Pawóp hẽ ãã wë kuman mariij —näk mäh. —Jããm tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ti m' tabahed'oo doo da, waëë joom oriib banäng doo hẽnh Jesus bahõm kän. Ta ma matëg had'aa mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Rakajaa bä m' Jesus ky hadoo sa hã: —P'op Hagä Do hã bë ky n'aa ets'ẽẽ, nesaa do h'yyb tatug mahǟnh bëëh, ỹ bë eréd hõm mahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ti m' tabahõm dawë hã. Ti m' ta taron nu paa me tabahyy häng, ti m' taky n'aa etsẽẽ P'op Hagä Do hã. Hahỹỹ da m' ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Ee, —näng mäh —makarẽn bä mado hõm mahǟnh ỹỹ wät hahỹ ỹ ahoop do pan'aa. Ta tii d' né hẽ ỹ bets'ẽẽ paawä, makarẽn doo da né hẽ mabad'oo, ỹ karẽn doo da nado —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ti m' hỹ pong jé naa ããs see kasee ta hã, tah'yyb hej'oonh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ti m' tak'ëp mä taky n'aa etsẽẽ, tak'ëp tah'yy katón do hyb n'aa. Baad nado ta h'yyb tym. Majyyw hadoo mä tahehud. Tũũ m' tabatõõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ti m' tabas'ëëg gëët jawén paa bä m', taky n'aa etsẽẽ do jawén paa bä, tabahõm ta ma matëg rahab'ëëh hẽnh. Aǟ b'ëëh mä tii. Tak'ëp mä raty jewyk rah'yy ketón do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ti m' taky hadoo sa hã: —Hëd n'aa bë ba'ỹỹh? —näng mäh. —Bë as'ëëg bëh! P'op Hagä Do hã bë ky n'aa ets'ẽẽ, bë nesaa do h'yyb tatug mahǟnh, ỹ bë eréd hõm mahǟnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus ber'oot nä bä m', rakaja kän hajõk do ta wë. Judas, ta ma matëg 12 hedoo do see paah, sa pooj jé tabana. Ti m' Jesus wë Judas bana. Ta tapa tsanetsub wät. Kedëng do ky n'aa né paawä tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ti m' Jesus beaanh ta hã: —Judas, —näng mäh —matsanetsup doo me ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do maban'oo däk? —näng mä Jesus Judas hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti m' Jesus sii habok do rabahapäh bä m' hajõk do rakarẽn ramasoo, raky hadoo ta hã: —Makarẽn ër gadoo kuman me? ");
INSERT INTO mbjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ti m' Jesus sa hata see tekyyt mä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom. Ta nabuuj hub hẽnh hadäk do tagakyd hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ti m' Jesus ky hadoo: —Ti moo hado manäh —näng mäh. Ti m' Jesus moo däng aj'yy rog hã. Has'oo däk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa hã, P'op Hagä Do tób n'aa hagã n'aa sa wahë n'aa hã, Judah buuj sa wahë n'aa hã na-ããj hẽ, Jesus ramaso däk hyb n'aa ta no n'aa han'aa do sa hã Jesus ky hadoo: —Ër wahë n'aa wë h'yy kawereem do sa h'yyb mahũũm n'aa bë ed'oo g'eeh ỹỹh, bë wén n'aa wë ỹỹ sẽn-jeer yt hã, boh yt hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","—P'op Hagä Do tób n'aa wahoo gó ỹ awäd had'yyt hẽ bë sii. Dooh ẽnh ỹ bë maso bä tii bä ẽnh? —näng mäh. —Hỹỹ kä, taw'ããts hẽ —näng mäh. —Ỹ hapäh, da hẽ né kä ỹ bë bahajaa. Da hẽ né hẽ Nesaa Do Yb mejũũ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ti m' ramaso däk Jesus, ti m' ramahũũm kän P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do tób hẽnh kä. Peed bahõm sa jawén. Dawëë m' tagadäk. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ti m' warahén ragahõ jat tëëg tób w'oo hã, ti m' rabehyy b'ëëh tëëg noo pa. Sa pa m' Peed bahyy häng. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ti m' ỹỹnh, sa karom, bahapäh Peed tëëg bag hã m' tabahäng bä. Ti m' baad tabaheg'ããs ta hã. Ti m' taky hadoo: —Hahỹ Jesus hata seeh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ti m' Peed ky n'aa jejën wät. —Dooh ỹ hapëë bä ta ti aj'yy —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Badah peej däg kä m', ta see baheg'ããs Peed hã, ti m' taky hadoo: —Ta hata see né hẽ õm —näng mäh. —Dooh. Dooh sa see ỹ do bä —näng mä Peed. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Badah peej däg kä m', sét oor tabahado däk bä m', ta see ky hadoo: —Jesus ma matëg see né ti hỹỹh. Garirej buuj né ti hỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ti m' Peed ky hadoo: —Dooh ỹ hapëë bä ta ti maher'oot doo —näng mäh. Ti m' nayyw hẽ, taher'oot nä bä m', karaak ky ganä kän, tabah'ỹỹ kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ti m' Jesus ty kaw'õõd däk Peed wë. Tii bä m' Peed hyb n'aa newë däg kän Jesus her'oot do paa ta hã kä: “Karaak bahỹỹh do pooj jé da ỹ maky n'aa jejën tamawoob nuu me.” Tii d' né paa kä m', Jesus her'oot do paa kä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ti m' Peed banyyh wahoo gó naa. Tak'ëp tabaód g'ëëd kän mäh, taky n'aa jejën do hyb n'aa Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti m', warahén Jesus hag'ããs do raky n'aa ejeets kän mäh, rarejãã mä tak'ëp. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ti m' raty maw'yyd däk, tanahapäh hyb n'aa. Ti m' rabahewyyh bä m' raky hadoo: —Maher'ood mahapëë bä! Jaa mo haj'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hajõng nä m' sa kyyh, raky n'aa rejãã doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ti m', bäp paa m', rakata padëëk Judah buuj sa wahë n'aa hedoo doo, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk doo. Ti m' ramahũũm kän Jesus sa wë, ");
INSERT INTO mbjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ti m' raky hadoo: —Mamaher'ood ãã hã, õm Kristo, P'op Hagä Do H'yyb Däng Do mado bä —näk mäh. Ti m' Jesus ky hadoo: —Bë ỹ maher'ood bä paawä, dooh paawä ỹ bë ky dahé bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bë ỹ eaaj bä, dooh bë ky gedag bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","—Ti tahado né paawä, hỹ jawén Aj'yy Hadoo Do Hỹ Pong Jé Hana Do asooh da P'op Hagä Doo, Sahõnh Sa Bahǟnh Hado Do hub hẽnh, ta hã P'op Hagä Do weh'ëëh doo bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ti m' sahõnh hẽ kata däk do raky hadoo: —Õm mä P'op Hagä Do T'aah, a nooh? —näk mäh. Ti m' Jesus ky hadoo: —Bë né tii, ti tii d' her'oot. Baad ub ti bë kyyh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ti m' raky hadoo: —Dooh hyb n'aa wät pé ta ky n'aa her'oot péh. Ta daaj né hẽ ti taky n'aa kaher'oot —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ti m', sahõnh hẽ ajyy kata däk do ramahũũm kän Jesus Pirato häd näng do wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ti m' radu doo Jesus raky n'aa tapaa Pirato hã. Hahỹỹ da m' sa kyyh: —Hahỹ aj'yy h'yyb mahũũm Judah buuj, raky nadahé wät hyb n'aa sa wahë n'aa, Roma buuj. Tamoo ge'ỹỹm ranep'aak hyb n'aa Sesa hã ji hepak doo, Roma buuj sa wahë n'aa hã ji hepak doo. “Ỹ Kristo, P'op Hagä Do H'yyb Däng Doo. Häj n'aa wahë n'aa ỹỹh”, näng mä ta kyyh —näk mä ta ti ajyy Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ti m' Pirato beaanh Jesus hã: —Õm né Judah buuj sa wahë n'aa? —näng mäh. Ti m' Jesus ky hadoo: —Ỹỹ. Tii d' né hẽ, maher'oot doo da né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa hã, hajõk do t'ĩĩ hẽnh kat'aa do hã na-ããj mä Pirato ky hadoo: —Dooh ỹ aw'yyt pé ta hã ta säm ỹ anoo péh —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ti m' raky kah'ũũm Pirato hã: —Sahõnh Judah häj n'aa bä, sa wahë n'aa wë rah'yy kawereem tan'oo bä tama metëëk do hã. Garirej häj n'aa bä tadu doo tama metëëk doo. Hỹỹ kä babä Jerusarẽnh bä tama met'ëëg kän —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Garirej häj n'aa bä Jesus du doo paa tama metëëk do Pirato ky n'aa napäh bä m', teaaj wät sa hã: —Garirej häj n'aa babuuj ti hỹ aj'yy? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ti m' Pirato ky n'aa napäh bä m' Jesus t'ĩĩ hẽnh naa, tamejũũ ramahũũm Eróts Ãn-Tipas häd näng do wë, Garirej häj n'aa wahë n'aa tabadoo do hyb n'aa. Jerusarẽnh panang bä Eróts bag'ããs dó ti noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ti m' Eróts tsebee wät Jesus tahapäh bä. P'ooj né hẽ m' takarẽn paawä m' Jesus tabahapäh. Ta ky n'aa napëë däk paa m' Jesus ky n'aa. Ti hyb n'aa m' takarẽn paawä m' tabaheg'ããs Jesus pahuunh doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ti m' Jesus ramanaa bä m', hajõng mä teaanh ta hã. Dooh m' Jesus ky gedag bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ, tak'ëp mä raky n'aa tapaa ta ky n'aa Eróts hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ti m' Eróts, Eróts warahén n'aa sii hẽ m' raky n'aa ej'ees mäh, raky n'aa rejãã mä Jesus. Ti m' radadäk ta hã saroor tak'ëp hanäm doo, sa wahë n'aa hedoo do saroor n'aa, raweh'ëëh doo gó m' raky n'aa manes'uunh hyb n'aa. Ti m' Jesus Eróts mejõ hõm p'aa hẽnh Pirato wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti pooj jé m' Eróts Pirato daheeh ta majĩĩ dó m'. Ti noo gó kä m' ta najiis hado däg kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ti m' Pirato mejũũ P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj sa wahë n'aa, hajõk do na-ããj rakataa hyb n'aa ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ti m' taky hadoo sa hã: —Bë mana wät hahỹ aj'yy wë ỹỹ —näng mäh. —“Hahỹ aj'yy h'yyb mahũũm Judah buuj raky nadahé wät hyb n'aa sa wahë n'aa, Roma buuj”, bë nooh —näng mäh. —Baad ỹ beaaj wät bë matym gó ta ky n'aa bë her'oot doo. Dooh ỹ aw'yyt pé ta hã nesaa do bë her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ti hadoo né hẽ Eróts. Dooh taw'yyt pé nesaa do ta hã, ti hyb n'aa tamejũũ p'aa hẽnh ãã wë —näng mäh. —Dooh tamo haj'aa pé ta p'ãã dajëp péh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ti hyb n'aa ỹ mejũũ da rahewyyh hyb n'aa, ti jawén da ỹ eréd hõm tabahõm hyb n'aa —näng mä Pirato kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pas-kowa noo gó né m' Pirato mahen'yyh radewëës do seeh, hajõk do retsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ti m' hajõk doo, séd hã m' raky hadoo, tak'ëp mä sa kyyh: —Manaboh hỹ aj'yy. Ãã karẽn maberéd hõm Barabas häd näng doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ragadahew'ëës doo gó m' tabagëët ta ti Barabas häd näng doo, Jerusarẽnh panang bä Roma buuj sa hã tah'yy kawareem do hyb n'aa ta h'yyb hataa sa daheeh, ta see tadaj'ëëp do hyb n'aa na-ããj mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pirato karẽn paawä taberéd hõm Jesus, ti hyb n'aa p'aa hẽnh taky kah'ũũm sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ti m' rageëëj bong: —Mepëëm däg! Mepëëm däg! Mepëëm däg! —näk mä hajõk do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti m' tamawoob nuu me däg mä Pirato ky hadoo sa hã: —Hëd n'aa? —näng mäh. —Dooh mo haj'aa kad'oo do tado bä —näng mäh. —Dooh ỹ aw'yyt pé ta hã ta p'ãã dajëp péh. Ti hyb n'aa ỹ mejũũ da rahewyyh hyb n'aa, ti jawén da ỹ eréd hõm tabahõm hyb n'aa —näng mä Pirato kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ti m' raky kah'ũũm Pirato hã. Tak'ëp rageëëj bong, Jesus tabepëëm hyb n'aa. Ti m' sa kyy me m' rahaja kän Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ti hyb n'aa kä m' Pirato ban'oo kän rakarẽn doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tado nyyh mä Barabas, Jerusarẽnh panang bä Roma buuj sa wë tah'yy kawareem do hyb n'aa radawäts gëët do paah, ta see tadaj'ëëp do paah. Ti né m' ti retsẽẽ Pirato hã. Ti m' Pirato mejũũ Jesus rabepëëm däk b'aa hã, rakarẽn doo d' né hẽ m'. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesus warahén ramahũũm bä rabepëëm hyb n'aa, ramaso däk mä aj'yy Simaw häd näng doo. Panang Sirené häd näng doo bä naa m' tii. Jerusarẽnh panang hẽnh tabajëë paawä. Ti m' warahén ramejũũ mä tabes'ooh hyb n'aa b'aa Jesus rahepëëm däk do b'aa n'aa. Ti m' ramejũũ Jesus jawén tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hajõk mä hah'ũũm sa jawén. Ỹỹj na-ããj mä ah'ũũm sa sii. A'oot mäh. Sa h'yyb mä ragedyyk. Rah'yy ketón do ky n'aa m' ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ti m' Jesus ty kaw'õõd däk sa wë, ti m' taky hadoo sa hã: —Ỹỹj, Jerusarẽnh buuj —näng mäh. —Ỹ had'yyt nado bë p'ãã ód. Bë daaj hẽ bë p'ãã kaód, bë taah na-ããj hẽ bë p'ãã ód, tak'ëp nesaa do bë wë hana do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ti awät da ti noo gó hahỹỹ da d' bë kyyh: “Taw'ããts hẽ ỹỹj taah nanäng do hã, ỹỹj netaah do hã, ỹỹj nanebii do hã”, tak'ëp nesaa do taah enäh do rabahoop do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti noo gó Judah buuj raky hadoo da waëë hã: “Keréd hyy ãã jó, nayyw hẽ ër dejëp hyb n'aa.” Wajapëm do hã raky hadoo da: “Ãã jó wamii hyyh”, näk da. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hahỹỹ da hã ỹ ran'oo bä, b'aa tsahë do hadoo do ỹỹh, nesaa do nahanäng doo, ta bahǟnh da ti P'op Hagä Do bad'oo sa hã, b'aa hawoonh do hadoo, hajõng nesaa sa hã hanäng doo. Sahõnh hẽ haooj jëng do hadoo sa hã —näng mä Jesus ỹỹj sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pawóp hẽ ajyy moo nesaa do ramahũũm, Jesus sii rabepëëm padëëk hyb n'aa sa moo p'ãã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti m' rakajaa Ji Nu Gabóg K'yy ramaneëënh doo bä. Ti m' rabepëëm däk Jesus b'aa kajatsëk do hã kä. B'aa kajatsëk do wób hã rabepëëm padëëk moo nesaa do Jesus pa. Ta hub hẽnh ta see hahäng, s'ỹỹ hẽnh ta see hahäng. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti m' Jesus ky hadoo: —Ee, —näng mäh —mamabaan sa hã hahỹ nesaa doo, hã ỹ ramoo bok doo. Dooh rah'yy genä bä ramoo bok do hã —näng mä Jesus. Ti m' warahén ramoo bong ramas'uunh doo, rabahapäh hyb n'aa ta saroor uuh wë ym doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hajõk do rabaheg'ããs bä m', Judah buuj sa wahë n'aa raky n'aa ej'ees mäh, rakawew'aam mä Jesus. Hahỹỹ da m' sa kyyh: —Ta wób ted'ëëp —näk mäh. —Taw'ããts hẽ ta daaj hẽ taked'ëëp Kristo, P'op Hagä Do H'yyb Däng Doo, P'op Hagä Do asëëw hõm do tado bä? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ti ky hadoo né hẽ m' warahén ẽnh. Ramenoo ta hã uwa s'ëëb oow, ramanes'uunh do heen n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ti m' raky hadoo: —A daaj hẽ kedëëb, Judah buuj sa wahë n'aa mado bä! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","P'op, ta nu gad'oo pong jé m', warahén rabepëëm däk kerih doo. Hahỹỹ da m' kerih do hã: “Judah buuj sa wahë n'aa hahỹỹh”, näng mä kerih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ti m' moo nesaa do see Jesus pa hahäng do ky n'aa rejãã mä Jesus. Hahỹỹ da m' taky n'aa ej'ees: —Õm Kristo, P'op Hagä Do H'yyb Däng Do õm? Ti bä, a daaj hẽ kedëëb, ãã na-ããj né hẽ! —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ti m' ta see ky geǟm wät: —Dooh P'op Hagä Do majeỹỹm bä? Õm na-ããj né da dajëp ta nemuun —näng mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","—Taw'ããts hẽ ti ãã radej'ëëp, nesaa do ãã moo bok do hyb n'aa —näng mäh. —Hahỹ aj'yy dooh nesaa pé tamo haj'aa —näng mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ti m' Jesus hã kä taky hadoo: —Mahyb n'aa es'ee ỹỹh, mabag'ããs doo hẽnh, hỹ pong jé makajaa bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti m' Jesus ky hadoo ta hã: —Né hup ỹ né hẽ hahỹ a hã ỹ her'oot doo: Badah mabasëëk da si ỹỹ hỹ pong jé, P'op Hagä Do wë —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wasyg däk mä ti nuuj jé. Ti m' ta bag badoo wät, badagyb däk mä badäk hahỹỹ hã. Jããm hẽ tug bä tabawag däk p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dooh m' papỹỹj bag wät péh. Tii bä m', P'op Hagä Do tób n'aa t'õp ta gó noo gatsë hebaan do kas'ẽẽd hyng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tii bä m' tak'ëp mä Jesus geëëj wät: —Ee, —näng mäh —a moo gó ỹ banoo hëp ỹ tym —näng mäh. Ti m' ta ti taky hadoo bä m', tadajëb kän mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ti m' sahõnh hẽ ta ti warahén sa wahë n'aa hapäh bä m', P'op Hagä Do hã taj'aa etsëë kän. Hahỹỹ d' mä ta kyyh: —Te hub né hẽ, —näng mäh —baad hadoo do né paa ti hỹ aj'yy —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ti m' hajõk doo, kepëëm do heg'ããs doo, sahõnh hẽ ta ti rabahapäh bä m', sa h'yyb ragedyyk rabajëk, rah'yy ketón do heen n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dawëë naa m' Jesus najiis rabaheg'ããs. Sa mahang mä ab'ëëh mä ỹỹj Garirej häj n'aa bä naa, Jesus hataa paah. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ti awät mä aj'yy ky enyym doo, P'op Hagä Do karẽn doo da hawät doo, Judah häj n'aa, panang Arimatsija häd näng doo bä naa. Joséh mä ta häd. Tagada né hẽ m' P'op Hagä Do bag'ããs do du däk. Judah buuj sa wahë n'aa see né paawä m' tii, dooh m' ta h'yyb hedo bä sa sii, Jesus hã rabad'oo do hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ti m' ti Joséh bahõm Pirato wë, Jesus kamag n'aa tabetsẽẽ hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ti m' tabado hyy kän Jesus kamag n'aa, ti m' tahabën däk mä pããn hawak doo me rino häd näng do s'ëëb. Ti m' tadasuun jëng pä gabaho doo gó, kamag hood n'aa ragagots däk doo gó. Papuuj mä ta ti kamag hood. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Saab pooj jé m' ti ta tii. Saab pooj jé né hẽ m' ta ti Judah buuj rabahenyyw hõm, Saab hã rakamehehãk hyb n'aa. Tũũh däg mä papỹỹj. Edaa däk Saab du däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ỹỹj Garirej häj n'aa bä naa, Jesus had'aa do paah, rabahõm Joséh jawén. Rahapäh mä gabaho doo. Rahapäh mä na-ããj hẽ ragadakä jëng do Jesus kamag n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ti m' rabajëk myyj hẽnh. Ti m' rabenyyw däk bag'aad, buu benyym do bëëh, Jesus kamag n'aa hahog pan'aa m'. Rabenyyw däk do rabahajaa bä m', Saab däg mäh. Ti hyb n'aa ragada mä Saab tabëëj hõm hyb n'aa, Mosees ky n'aa jaw'yyk mejũũ doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ti m' bäp paah, met'uuh hã, ỹỹj rabahõm kän pä gabaho doo hẽnh, Jesus kamag n'aa radasuun jëng hẽnh. Buu benyym do renyyw däk do paa ramahũũm. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kepëëd hõm mä pä gabaho do ty gatsë paah, rakajaa bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ti m' rabajëë p'ëë ta gó. Dooh m' tii bä Jesus kamag n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rahyb n'aa newë b'ëëh bä m', nayyw hẽ kasee sa pa pawóp hẽ ajyy. Gabarëëh mä sa saroor, hawyp do gabarëëh doo da. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tak'ëp mä ỹỹj rah'yyb e'ỹỹm bong. Ti hyb n'aa, tũũ rabehyy b'ëëh. Ti m' ããs raky hadoo sa hã: —Hëd n'aa hawät do bë esoos dejëp do mahang? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Dooh wäd bä. Ganä wät! Dooh bë hyb n'aa es'ee wäd bë hã taher'oot do Garirej häj n'aa bä? ");
INSERT INTO mbjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hahỹỹ d' paa ta kyyh bë hã: “Ran'oo däk da Aj'yy Hadoo Do Hỹ Pong Jé Hana Do nesaa do moo heb'ook do sa moo gó, rabepëëm däk hyb n'aa. Tamawoob däg bä kä ta ǟh, ganä wät da p'aa hẽnh”, näng bë hã —näk mä ããs kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ti m' rahyb n'aa es'ee kän Jesus her'oot do paa kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti m' rabajëk, 11 hedoo do Jesus mejũũ do hã, ta wób na-ããj hã, rapanäk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Marija Madarẽn, Jowãn, Marija Tsijaag ỹỹn, ỹỹj wób mä na-ããj hẽ m', ti panäk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dooh m' Jesus ma matëg raky dahé bä. Daap hẽ red'oo mä ti ỹỹj raher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ti hadoo né hẽ m', Peed as'ëëg gëët, ti m' waj'aa hõm Jesus kamag n'aa hood gadäk hẽnh. Gabaho do tageg'ããs bä m', jããm né hẽ m' pããn hawak do rino häd näng do s'ëëb tahapäh. Ti m' tabajëng. Tahyb n'aa newëë mä ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti noo gó né hẽ, pawóp hẽ Jesus ma matëg wób rabahõm panang Emaus häd näng doo hẽnh. Dawëë péj tii, Jerusarẽnh bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ramahõm me raher'oot mä Jesus dajëp do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti bahǟnh mä Jesus kataa sa hã. Sa sii m' tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dooh m' rah'yy genä bä Jesus tado bä, P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ti m' Jesus ky hadoo sa hã: —H'ëëd ti bë her'oot? —näng mäh. Ti m' rabayyw b'ëëh dó. Rahyb n'aa tón mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ti m' sa seeh, Kerew-Pas häd näng do ky hadoo: —Jããm né hẽ õm Jerusarẽnh bä heg'ããs do ky n'aa nanapäh do t'ĩĩ hẽnh hawäd wät doo? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—H'ëëd ky n'aa? —näng mä Jesus. —Nasaréh buuj, Jesus häd näng do ky n'aa —näk mäh. —P'op Hagä Do ky n'aa rod né tii. Tak'ëp ta hejój gó tama metëëk, tapehuunh na-ããj hẽ. Baad ub ti P'op Hagä Do matym gó. Baad ub na-ããj hẽ ta wób sa matym gó —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","—Tii bä P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, ër wahë n'aa wób na-ããj hẽ, raban'oo kän Roma buuj sa moo gó, radaj'ëëp hyb n'aa. Tii bä rabepëëm däk b'aa hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—Kristo, ër majĩĩ moo gó naa ëër, Isaraéw buuj ted'ëëp do paawä, ãã ed'oo. Tamawoob däg mä ta ǟh tadajëp —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","—Ti anäng nä ta ky n'aa —näk mäh. —Bäp paa ỹỹj wób, ãã h'yyb hataa, rabeboo nä Jesus kamag n'aa hood hẽnh. Ãã h'yyb gabedo bong ran'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Dooh wäd mä ta kamag n'aa ta gó, sa nooh. Ããs kas'ee bong mä sa hã, sa nooh. Jesus mä ganä wät ããs her'ood bä, ỹỹj sa nooh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tii bä ãã wób rawaj'aah rabaheg'ããs hyb n'aa. Se hub né hẽ m' ỹỹj sa kyyh. Dooh wäd mä Jesus kamag n'aa tii bä. Dooh né hẽ m' rahapëë bä Jesus —näk mä ajyy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ti m' Jesus ky hadoo sa hã: —H'yy gatemah bëëh! —näng mäh. —Nayyw hẽ nado bë ky daheeh sahõnh hẽ P'op Hagä Do ky n'aa rod raher'oot do paah —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","—Kristo, P'op Hagä Do H'yyb Däng Do ahoop do pan'aa né hẽ sahõnh hẽ ta tii, hỹ pong jé, raweh'ëëh hẽnh, tabasëëk do pooj jé. Baad né hẽ P'op Hagä Do ky n'aa rod rerii bong paa ta tii —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ti m' Jesus ma met'ëëg wät mä sa hã sahõnh hẽ ta ky n'aa, P'op Hagä Do kyy kerih do hã hanäng doo. Mosees erii wät do hã tadu doo ta ky n'aa tama metëëk doo. Sahõnh hẽ P'op Hagä Do ky n'aa rod rerii bong do ta ky n'aa, Jesus her'oot né m' tii kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ti m' edaa däk mä panang Emaus häd näng doo. Panang bahǟnh mä Jesus kateb'ëës. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ti m' tak'ëp rabetsẽẽ sa pa tabaym hyb n'aa, tũũh däg do hyb n'aa papỹỹj. Badajuu däk mäh. Ti m' Jesus bahõm kän sa sii. Sa pa m' tabayyw kän. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rabehyy t'oonh bä kä rabawa hyb n'aa kä, Jesus bado däk pãw, ti m' P'op Hagä Do hã taky n'aa etsẽẽ ta hyb n'aa, ti m' taganabäh hõm, ti m' tabanoo sa hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tii bä kä m', rah'yy kadaw'uuh Jesus hã. Rah'yy kadawuung sii hẽ m' Jesus dawuh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ti m' sa daaj hẽ rakaner'oot. Ti m' raky hadoo: —Mahapäh né hẽ, ti baad ër h'yyb tym tsebé do hadoo ër sii taber'oot bä, P'op Hagä Do kyy kerih do hã ër tamaher'oot bä ër mana me —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ti m' nayyw hẽ kä rabajëë kän Jerusarẽnh hẽnh, 11 hedoo do Jesus ma matëg, ta wób na-ããj hẽ rakata padëëk bä. Rakajaa bä kä m', kata b'ëëh do raky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Se hub né hẽ. Ganä wät né hẽ ër Wahë N'aa! —näk sa kyyh. —Simaw hã takas'ee wät! —näk mä kata b'ëëh do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ti m', panang Emaus häd näng doo hẽnh naa han'aa do rabaher'oot sa hã nyy da Jesus kasee sa hã ta tyw n'aa ramahõm me, nyy da rah'yy kadaw'uuh ta hã pãw taganebëëh bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tii bä kä m', rabaher'oot nä bä m', Jesus ganä g'ëëd kän mä sa mahang. Ti m' takedëng sa hã: —Taw'ããts hẽ bë P'op Hagä Do h'yyb en'yym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ti m' tak'ëp rabeỹỹm bong. H'yy gabedo bong mäh. Maëts red'oo mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ti m' Jesus ky hadoo sa hã: —Hëd n'aa bë beỹỹm? —näng mäh. —Hëd n'aa bë panyyg ky nadaheeh hahỹ bë hapäh do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—Bë hegãã moh ỹỹ, tsym ỹỹ, atapuwa tyw n'aa paah. Ỹ né ti hỹỹh. Maës ỹ nado ti hỹỹh. Bë mep'aa hã ỹỹ, maëts nado ỹỹh, bë bahapäh hyb n'aa. Maëts dooh ta dab nyy bä, dooh ta k'yy nyy bä, baad bë hapäh do ỹỹh —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ti m' tametä däg kän mä sa hã ta mooh, ta tsyym. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dooh m' raky dahé nä bä, tak'ëp rah'yyb tsebé do hyb n'aa, tak'ëp rah'yyb meuunh do hyb n'aa. Ti hyb n'aa Jesus ky hadoo sa hã: —Ti anyy ji awa péh? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ti m' rabanoo tah'ỹỹb dab. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ti m' tabawëë kän sa matym gó. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ti m' taky hadoo sa hã: —Bë mahang ỹ bawät nä bä, ỹ dajëp do pooj jé, “Kametä däk da hã ỹ sahõnh hẽ këh ỹ n'aa Mosees erii wät do paah, P'op Hagä Do ky n'aa rod rerii bong do paah, Saaw-Mo hã kerih do na-ããj hẽ”, bë ỹ maher'ood bong paah —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ti m' rah'yy genä padëëk P'op Hagä Do kyy kerih do hã, Jesus an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ti m' taky hadoo ẽnh sa hã: —Hahỹỹ da P'op Hagä Do kyy kerih do këh ỹ n'aa: Kristo, P'op Hagä Do H'yyb Däng Doo, ahoop né da dajëb. Ta jawén kä da, tamawoob hẽ ta ǟh tabado däk bä, taganä wät da p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kristo ky gabuuj sahõnh hẽ häj n'aa babuuj sa hã rabaher'ood hõm da hahỹ ky n'aa: P'op Hagä Do awug hõm da sahõnh hẽ nesaa do ji moo wät do paah, ta hã ji h'yy kawareem bä. Jerusarẽnh bä naa da radu doo raher'ood hõm doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ti m' taky hadoo ẽnh: —Bë hapäh sahõnh hẽ ta ti nesaa do ỹ ahoop doo, ỹ dajëp doo, ỹ ganä wät doo, ti hyb n'aa ỹ karẽn bë baher'oot ta ti këh ỹ n'aa ta wób sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","—Ỹ mejũũ da bë wë P'op Hagä Do Sahee, Ee ky n'aa enooh doo —näng mäh. —Ti hyb n'aa bë ayyw dó Jerusarẽnh bä, bë gado däk bä kä p'op naa P'op Hagä Do Sahee hejój —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ti m' ta ma matëg Jesus mahũũm kän panang bahǟnh, panang Betanija häd näng doo hẽnh. Ti m', p'op ta moo tagadabë sëëk, ti m' taky n'aa edëë bong sa hã. P'op Hagä Do hã taky n'aa etsẽẽ sa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta ky n'aa edëng bä m', P'op Hagä Do masäg kän hỹ pong jé. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti m', sa taron nu paa me m' ta ma matëg ramehyy b'ëëh, Jesus raweh'ëëh do ky n'aa, Jesus hã raj'aa etsë hyb n'aa. Ti m' tak'ëp rah'yy gadejah doo gó m', rah'yyb tsebé doo gó m' rabajëk. ");
INSERT INTO mbjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","P'op Hagä Do tób n'aa bä m' P'op Hagä Do hã raj'aa etsëë had'yyt hẽ m'. Jããm hẽ kä hahỹ Jesus panyyg. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","P'ooj ub, sahõnh hẽ tadu dahäng do pooj jé, tawäd né hẽ P'op Hagä Do Kyyh häd näng doo. P'op Hagä Do sii tabawät. P'op Hagä Do né hẽ tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sahõnh hẽ tadu dahäng do pooj jé, P'op Hagä Do sii tabawät tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sahõnh hẽ tamo haj'aa hanäng doo. Dooh tapanahuunh péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ji edëb had'yyt up doo, P'op Hagä Do Kyyh häd näng do hã né hẽ tabana. Ji h'yyb tym bag hadoo né hẽ ta ti edëb had'yyt ub doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Badagyp doo gó, nesaa do badäk hahỹỹ hã hanäng doo gó ta ti bag kadaw'uuh. Dooh badagyp do haja bä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ti m' ti awät mä aj'yy P'op Hagä Do kyy gó hana doo. Ta häd mä Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","P'op Hagä Do mejũũ ta hã, ta wób tamaher'oot hyb n'aa ta ti ji h'yyb tym bag ky n'aa, ta tii hã rah'yy ka'eeh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dooh Jowãw tado bä ta ti ji h'yyb tym bag. Ta bag ky n'aa rod ub ti Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ahyy kän badäk hahỹỹ bä, ta bag heh'äät ub doo, Jesus Kristo, sahõnh hẽ badäk hahỹỹ hã habong do sa h'yyb tym bag. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Badäk hahỹỹ bä paa tabawäd wät. Badäk hahỹỹ hã habong do tapehuuj né paawä, dooh ragado bä tii, dooh rah'yy genä bä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta karapee, Isaraéw buuj wë tabahyng, ti hadoo né hẽ, dooh ragado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sahõnh hẽ gad'oo doo, ta hã h'yy ka'eeh do sa hã P'op Hagä Do banoo ta taah rabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","P'op Hagä Do taah ti rawén hedo padëëk, aj'yy karẽn do jawén nado, aj'yy panaa ji bahadoo do hyb n'aa nado. P'op Hagä Do taah rawén hedo padëëk, P'op Hagä Do tii d' tabanoo do hyb n'aa sa hã. Sa yb hado däk P'op Hagä Doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ti m' aj'yy gó P'op Hagä Do Kyyh häd näng do kesok. Ãã mahang paa tabawäd wät. Ãã hapäh né hẽ tak'ëp hadoo do ta hejój, sét ub P'op Hagä Do T'aah tak'ëp hadoo do hejój. Tak'ëp né hẽ taky enyym. Heh'äät ub had'yyt né hẽ ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Baad ub Jowãw nu gahem'uun do paa baher'oot paa ta ti ky n'aa. Hahỹỹ da m' ta kyyh: —Hahỹ ti ỹ ky n'aa her'oot doo, hahỹỹ da ỹ baher'oot bä: “Jawén ỹ hana doo, hyb n'aa jawyk ti bahä̃nh ỹỹ, tawäd däg né hẽ pój ỹỹ jé do hyb n'aa” —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tak'ëp né hẽ P'op Hagä Do Kyyh häd näng do ky enyym. Ti hyb n'aa ër hã taky enyyw had'yyt hẽ. Baad hadoo do ër hã tametä had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosees makũ anoo paa P'op Hagä Do ky n'aa jaw'yyk doo. Jesus Kristo kä metä kän P'op Hagä Do ji takamahä̃n doo, ky n'aa heh'äät ub do na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dooh noo gó hapäh pé P'op Hagä Doo. Tii d' né paawä, jããm né sét hadoo do ta T'aah, ta da hadoo doo, ta pa hawät doo, ër tamaher'oot ta ky n'aa. Ta hã hẽ takametëëh P'op Hagä Doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ti m' Judah buuj sa wahë n'aa panang Jerusarẽnh bä habong do ramejũũ P'op Hagä Do tób n'aa yt hã moo heb'ooh do wób, t'ĩĩ hẽnh ramoo heb'ook do Rewi panaa wób na-ããj hẽ, Jowãw hã rabeaanh hyb n'aa Kristo, P'op Hagä Do Ky Däng Do tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Baad ub mä Jowãw baher'oot sa hã, dooh taky n'aa jejën bä. Hahỹỹ da m' Jowãw kyyh sa hã: —Dooh Kristo, P'op Hagä Do H'yyb Däng Do ỹ do bä —näng mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ti m' rabeaanh: —Õm Eriij, p'ooj ub hawät do paah? —näk mäh. —Dooh —näng mä Jowãw. P'aa hẽnh mä rabeaaj wät ẽnh: —Õm nanäng P'op Hagä Do ky n'aa rod, P'op Hagä Do kyy kerih do ky däng doo? —näk mäh. —Dooh ỹ ti tado bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ti m' tagadëëg ub rabeaanh: —Jaa ti õm? —näk mäh. —Ãã mamaher'ood, ãã panäk hyb n'aa ãã hã mejũũ doo. Jaa õm, a nooh? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ti m' Jowãw ky hadoo, P'op Hagä Do ky n'aa rod, Isajas häd näng do her'oot doo da: —“Ỹ né hẽ hahỹỹ da tabanawäng bä her'oot doo: Baad ub da bë tyw n'aa daj'aah Tak'ëp Hyb N'aa Jawyk Doo.” ");
INSERT INTO mbjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti m' sa wób, Pariséw ramaneëënh doo, ");
INSERT INTO mbjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","rabeaaj wät ta hã: —Hëd n'aa manu gemuun, Kristo, P'op Hagä Do H'yyb Däng Do nadoo do õm? Hëd n'aa manu gemuun Eriij p'ooj ub hawät do paa nadoo do õm, nanäng P'op Hagä Do ky n'aa rod nadoo do na-ããj hẽ õm? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ti m' Jowãw ky hadoo: —Ỹ ti hỹỹh, bë ỹ nu gemuun naëng me —näng mäh. —Ti awät bë mahang bë nahapäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ti né ti jawén ỹ hana doo, tak'ëp hyb n'aa jawyk do bahä̃nh ỹỹ. Hã ỹỹ, ỹ hyb n'aa sakog its ta hã. Ti hyb n'aa dooh ỹ haja bä ta tsyym suun kabo n'aa ỹ do bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ta ti reaanh doo, panang Betanija häd näng doo bä tii, tamii Joradãn häd näng do ta myyj jé. Tii bä m' Jowãw nu gemuun bong mä ta wë han'aa doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ti m' jati péh, Jesus Jowãw nu gahem'uun do hapäh ta wë hana doo. Ti m' Jowãw ky hadoo: —Bë hegãã, —näng mäh —P'op Hagä Do mas'ãã b'éé t'aah hadoo, badäk hahỹỹ hã habong do nesaa do sa hã hanäng do hado hõm doo —näng mä Jowãw Jesus ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Hahỹ né hẽ ta ti ỹ her'oot do paa kä, hahỹỹ da ỹ baher'oot noo gó: “Jawén ỹ hana doo, hyb n'aa jawyk ti bahä̃nh ỹỹ, tawäd däg né hẽ pój ỹỹ jé do hyb n'aa”, ỹ hanäng do paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Dooh paa ỹ hapëë nä bä nanäng hyb n'aa jawyk do hahỹ tado bä. Ỹ wén nu gemuun bong tame, takametëëh hyb n'aa Isaraéw buuj sa hã —näng mä Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ti m' Jowãw ky hado kän: —P'op Hagä Do Sahee ỹ hapäh hỹ pong jé naa tabahyng ta wë gurii-i hadoo. Ta hã tabaym. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pooj jé, dooh ỹ hapëë nä bä ti tado bä. Hahỹỹ da paa ỹ P'op Hagä Do maher'oot, ỹ paa tamejũũ tame ỹ nu gemuun hyb n'aa: “Aj'yy wë Sahé ỹ ahyy bä, ta wë tabaym mabahapäh bä”, näng P'op Hagä Doo, “ti né hẽ tii kä tabanoo sa hã Sahé ỹỹ kä sa h'yyb tym gó tabajëë suun hyb n'aa, Sahé ỹỹ h'yyb mahũũm hyb n'aa kä sa hã”, näng P'op Hagä Do hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ỹ hapäh ta ti Jesus wë kä. Ti hyb n'aa baad ỹ baher'oot ta ky n'aa kä: P'op Hagä Do T'aah né hẽ ti hỹỹh —näng mä Jowãw nu gahem'uun doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti m' jati péh, p'aa hẽnh mä Jowãw nu gahem'uun do tii bä tabawät. Pawóp hẽ m' ta ma matëg rahada. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus tabës bä Jowãw bahapäh bä m', taky hadoo ta ma matëg sa hã: —Bë hegãã! P'op Hagä Do mas'ãã b'éé t'aah hadoo —näng mä Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ti m' ta ma matëg ramaa napäh bä m' Jowãw her'oot doo, Jesus sii m' rababoo kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ta jawén p'aa hẽnh Jesus baheg'ããs bä m', ta jawén han'aa do tabahapäh bä m', tabeaanh sa hã: —H'ëëd bë karẽn? —näng mäh. Ti m' raky hadoo: —Rabi —näk mäh, —nyy bä mabagä? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ti m' Jesus ky hadoo: —B'ëëp, bë hegãã —näng mäh. Ti m' rabahõm ta sii, ti m' rabaheg'ããs tabahe'ỹỹh doo. Ti m' rabaym ta pa, tũũh däg do hyb n'aa papỹỹj, 4 oor m'. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aj'yy Ãn-Deréh häd näng doo, Simaw Peed häd näng do hỹỹj, Jowãw nu gahem'uun do her'oot do maa napäh do seeh, Jesus sii hawäd däk do seeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ti m' nayyw hẽ Ãn-Deréh bahõm ta hỹỹj tesoos, Simaw. Ti m' tabaw'yyt bä kä, taky hadoo ta hã: —Ãã aw'yyt Mesijas rahanäng doo —näng mäh. (Kristo, P'op Hagä Do h'yyb däng doo, tahanäng pé ti Mesijas.) ");
INSERT INTO mbjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ti m' Ãn-Deréh mahũũm kän Simaw Jesus wë kä. Ti m' Jesus begãã däk Simaw wë, ti m' taky hadoo ta hã: —Õm né Simaw. Jowãw häd näng do t'aah õm —näng mäh. —Hỹ jawén Sepas a häd kä —näng mäh. (Peed rahanäng pé ti ta tii, sa kyy me ti Sepas. “Pä” rahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti m' jati pé Jesus h'yyb däng Garirej häj n'aa hẽnh tabahõm. Tabahõm pooj jé tahapäh mä aj'yy Pirip häd näng doo. —Hata ỹ õm hỹỹ kä —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaj-Da panang häd näng doo bä naa ti Pirip. Ti né hẽ na-ããj hẽ Ãn-Deréh Peed sa panang. Sét panang buuj né tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ti m' aj'yy seeh, Natanajéw häd näng do hã Pirip kataa. Ti m' taky hadoo ta hã: —Ãã awyyd kän Mosees erii wät do paa gó kaher'oot doo kä, P'op Hagä Do ky n'aa rod rerii bong do paa gó kaher'oot do na-ããj hẽ —näng mäh. —Jesus né ti ta tii, Nasaréh häd näng do panang hẽnh naa, Joséh t'aah —näng mä Pirip Natanajéw hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Nasaréh hẽnh naa? —näng mä Natanajéw. —Nasaréh bä naa dooh baad hadoo do ana bä —näng mä Natanajéw. Ti m' Pirip ky hadoo ta hã: —Hamäh, ër hegãã —näng mä Pirip. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ti m' rabahõm. Ti m' Jesus bahapäh bä Natanajéw kaja nä bä, taky hadoo: —Wät ta ti Isaraéw buuj heh'äät ub doo. Dooh tawad'ii bä, dooh tajejën bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ti m' Natanajéw ky hadoo: —Nyy d' ỹ mabahapäh? —näng mä Jesus hã. Ti m' Jesus ky hadoo ta hã: —Õm Pirip aw'yyt do pooj jé, õm ỹ bahapäh joom wiigo häd näng do yt hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ti m' Natanajéw hyb n'aa meuuj wät, ti m' taky hadoo: —Ma matëg! —näng mäh —Õm né P'op Hagä Do T'aah. Õm né hẽ Isaraéw buuj sa wahë n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ti m' Jesus ky hadoo ta hã: —Hã ỹ mah'yy ka'eeh, joom wiigo yt hã õm ỹ bahapäh ỹ banäng do hyb n'aa? —näng mäh. —Ti bahä̃nh da mabahapäh da meuj n'aa näng doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ti m' Jesus ky hado kän: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Wë gasëëts hõm do bë bahapäh da. P'op Hagä Do ããs rabehyng rabesëëk Aj'yy Hadoo Do Hỹ Pong Jé Hana Do wë, bë hapäh da —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ti m', jati hawät hadoo hã, panang Kanah häd näng doo bä, Garirej häj n'aa bä, ramoo bong ket'ëë do jäm waa n'aa, ta tä n'aa. Jesus ỹỹn awät tii bä, raket'ëë do jäm noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus, ta ma matëg sii hẽ, rabats'yyt jäm hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti bahä̃nh, tabahëëj jëng uwa bëëh hejoonh doo. Ti m' Jesus ỹỹn ky hadoo Jesus hã: —Ahëëj jëng uwa bëëh hejoonh doo —näng mä Jesus ỹỹn. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ti m' Jesus ky hadoo ta hã: —Hëd n'aa tii hã ỹ mamaher'oot? —näng mäh. —Dooh takaja nä bä hejój ỹỹ ỹ metëëh doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tii bä m', ta ti tób yt moo bo n'aa hã m' Jesus ỹỹn ky hadoo: —Bë moo boo da sahõnh hẽ bë tamejũũ doo —näng mä ta ỹỹn kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tób yt hã ti abëëh ji ma poo oow see pé naëng hood pä s'ëëb. Sa moo hetsyd, sa waa hood getsyd naëng n'aa. Judah buuj raky n'aa jaw'yyk do ky n'aa né tii. Tamawoob hẽ raat ken'yyh tahyb n'aa pé ta ti ta gabuuj. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ti m', tii b' moo heb'ooh do sa hã Jesus ky hadoo: —Bë gedu bëh naëng ta hood gó —näng mä Jesus. Ti m' ragedu bëëh sahõnh hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ti m' Jesus ky hadoo sa hã: —Bë agób ta uuh. Bë mahũũm jäm kaser n'aa wë —näng mä ta kyyh. Ti m' ramahũũm kän ta wë ta uuh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti m' jäm kaser n'aa tameëëk naëng paah, uwa bëëh hejooj däk doo. Dooh tahapëë bä n'yy hẽnh naa tii. Tii bä moo heb'ooh doo, ti rahapäh ta tii. Ti m' dawë hã aj'yy katëë do tanaëënh, ");
INSERT INTO mbjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ti taky hadoo ta hã: —Pooj jé ji heno uwa bëëh hejoonh do baad hadoo doo. Ta jawén, baad rabeëg bong bä kä, rahãd kanahapëë bong bä kä, ji heno baad nadoo doo. Õm tii, dooh tii d' madoo bä. Menyyw hõm baad had'op do tagadëëg ub —näng mä ta kaser n'aa kyyh aj'yy katëë do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pooj jé Jesus du doo do tapahuunh do ta tii. Ta tii hã kä tametä kän tak'ëp hadoo do ta hejój, ti hyb n'aa ta ma matëg ta hã rah'yy kae padäg kän. Panang Kanah häd näng doo bä, Garirej häj n'aa bä ti ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ti jawén mäh, panang Kapar-Naũm häd näng doo hẽnh Jesus rabahõm ta ỹỹn, ta hỹỹj, ta ma matëg sa daheeh. T'ĩĩ hẽnh mä tabaym pawóp hẽ ta ä̃h. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tabedaa däk bä Pas-kowa häd näng do Judah buuj rahyb n'aa esee doo, Jesus bahõm kän mä Jerusarẽnh hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","P'op Hagä Do tób n'aa w'oo hã, kahadë doo gó, wahoo gó, tabahapäh mä booj yb, b'éé, gurii-i hes'ëëm doo. Dajẽẽr meb'aanh doo, tii b' né rabat'oonh, Jesus hapäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ti m' tabarig däk ta tyd tamehewyyh hyb n'aa. Ti m' tabahabëë bong booj yb, b'éé sii hẽ. Ti m' tabaũũj bëëh mä dajẽẽr rabaheb'aanh do tyng n'aa. Jé pad'yyt hẽ taparara bong mä moweed, Jesus mo haj'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ti m' taky hadoo gurii-i hes'ëëm do hã: —Bë manä ti j'eep! —näng mäh. —Ji es'ëëm do tób n'aa bë adoo manä Ee tób! —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ti m' ta ma matëg rahyb n'aa es'ee däg kän P'op Hagä Do kyy kerih do hã kerih doo: “Ỹ gawats'iik da tak'ëp ỹ kamahä̃n do hyb n'aa a tób n'aa.” ");
INSERT INTO mbjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ti m' Judah buuj sa wahë n'aa rabana Jesus wë, ti m' raky hadoo ta hã: —Jaa kyy gó hahỹỹ d' mabad'oo? —näk mä sa kyyh. —Mametä ãã hã meuj n'aa näng do heen n'aa, P'op Hagä Do ky gabuuj tado bä —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Ej —näng mä Jesus. —Bë karẽn bä, bë apyn hõm hahỹ P'op Hagä Do tób n'aa. Tamawoob hẽ tabado däk bä ta ä̃h, ỹ tamaa sooh p'aa hẽnh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Nyy d' ti ta tii? —näk mä Judah buuj wahë n'aa sa kyyh. —46 ta baab ramoo bok rabahaja sooh hyb n'aa. Tamawoob mä ta ä̃h matamaa sooh p'aa hẽnh? —näk mä sa kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dooh P'op Hagä Do tób n'aa Jerusarẽnh bä hasooh do paa tado bä, Jesus hanäng péh. Ta daaj hẽ, ta ky n'aa né hẽ ti taher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ta jawén, Jesus ganä wät jawén paa bä kä m', ta ma matëg rahyb n'aa newë kän ta ti taher'oot doo. Tii bä kä m' raky dahé kän Jesus her'oot do paa kä. Raky daheeh na-ããj hẽ P'op Hagä Do kyy kerih doo kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti m', Pas-kowa rahyb n'aa esee noo gó, Jerusarẽnh bä Jesus baym bä, hajõk h'yy kae kän ta hã, hajõng tapehuunh do rahapäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dooh Jesus h'yyb dahé bä sa hã, baad tabahapäh do hyb n'aa sa h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dooh hyb n'aa rabaher'oot pé Jesus hã badäk hahỹỹ hã habong do sa ky n'aa, baad Jesus bahapäh do hyb n'aa sa h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ti m', ti awät mä aj'yy Nikodẽm häd näng doo, Pariséw sa seeh, Judah buuj sa wahë n'aa see m'. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Atsëm tabana Jesus wë, ti taky hadoo ta hã: —Ma matëg, —näng mäh —ãã hapäh, õm P'op Hagä Do mejũũ, ãã mama metëëk hyb n'aa. Ta ti ãã wén hapäh, dooh hajaa pé ta tii d' mapahuunh doo da P'op Hagä Do nawäd bä ta sii —näng mä Nikodẽm kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ti m' Jesus ky hadoo ta hã: —Dooh hajaa pé P'op Hagä Do bag'ããs do karapee ji do bä, p'aa hẽnh ji nenyy bä. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus Nikodẽm hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ti m' Nikodẽm ky hadoo: —Nyy d' tii? —näng mäh. —Nyy da p'aa hẽnh ji benäng, wah'ëë däk do ji? Ny daa p'aa hẽnh ji bajëë suun ji ỹỹn wog gó, p'aa hẽnh ji benäng hyb n'aa? —näng mä Nikodẽm kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ti m' Jesus ky hadoo: —Dooh ji haja bä P'op Hagä Do bag'ããs do karapee ji do bä, ji h'yyb ji nenyyw bä nesaa do mahä̃nh, P'op Hagä Do Sahee ji h'yyb gó tanajëë suun bä na-ããj hẽ. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","—Aj'yy hã hana doo, ta da hadoo né hẽ tii. P'op Hagä Do Sahee hã hana doo, P'op Hagä Do taah hedo padëëk tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ti hyb n'aa mahyb n'aa meuuj manäh, “Taw'ããts hẽ p'aa hẽnh bë benäng do hadoo”, ỹ hanäng do hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ti m' taky hadoo: —Tabahëm do ky n'aa gó õm ỹ maher'oot p'aa hẽnh ji benäng do ky n'aa. Tabahëm do tabahëm takarẽn hẽnh. Ji maa napëë né paawä ta kyyh, dooh ji hapëë bä n'yy hẽnh tahana, dooh ji hapëë bä nyy bä tabaym. Ti hadoo P'op Hagä Do Sahee gó p'aa hẽnh henäk do sa hã —näng mä Jesus Nikodẽm hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ti m' Nikodẽm ky hadoo: —Nyy d' tii? ");
INSERT INTO mbjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ti m' Jesus ky hadoo ta hã: —Isaraéw buuj sa ma matëg né paawä õm, dooh tagah'ood bä a hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Né hup ỹ né hẽ hahỹ õm ỹ maher'oot doo: Ãã her'oot ãã hapäh do ky n'aa, ãã hapäh do ãã matym me na-ããj hẽ. Ti hadoo né hẽ, dooh bë gado bä ãã her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","—Õm ỹ maher'ood wät badäk hahỹỹ bä ky n'aa, dooh ỹ maky dahé bä. Nyy da da ỹ bë ky daheeh hỹ pong jé ky n'aa ỹ her'ood bä? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Dooh hewäd sëëk pé hỹ pong jé. Dooh ta ky n'aa her'oot péh. Jããm né hẽ hawät t'ĩĩ hẽnh Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","P'ooj ub, tabanawäng bä, aw'yy heen n'aa Mosees gadahäng p'op, b'aa hã, ta wë rahegãã bä ranadejëp hyb n'aa. Ti hadoo né da b'aa hã, p'op, rabepëëm däk da Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ");
INSERT INTO mbjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sahõnh hẽ ta hã h'yy ka'eeh do redëb had'yyt hyb n'aa hỹ pong jé P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tak'ëp badäk hahỹỹ hã habong do P'op Hagä Do kamahä̃n. Ti hyb n'aa taban'oo däg kän sét hadoo do ta T'aah, sahõnh hẽ ta hã h'yy ka'eeh do tabanesaa hẽnh ranahõm hyb n'aa, rabedëb had'yyt hyb n'aa hỹ pong jé P'op Hagä Do pa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taky n'aa etyy hyb n'aa nado nesaa do sa hã P'op Hagä Do wén mejõ hyng ta T'aah badäk hahỹỹ bä. Tawén mejõ hyng, ta hã rabedëp hyb n'aa nesaa do mahä̃nh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ti m' Jesus ky hadoo ẽnh: —Dooh P'op Hagä Do ky n'aa ety bä nesaa doo hẽnh, ta T'aah hã h'yy ka'eeh doo. P'op Hagä Do h'yyb gó tabanyy däk taky n'aa etyy do sa hã nesaa doo hẽnh, ta T'aah hã h'yy kana'eeh do sa hã. Ta wén ky n'aa etyy nesaa doo hẽnh sa hã, sét had'os do ta T'aah hã rah'yy kana'eeh do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","—Hahỹ hyb n'aa P'op Hagä Do rejãã da sa hã: Ta t'aah, ji h'yyb tym bag, baad hadoo do P'op Hagä Do gen'aak do ji hã tametëëh doo, kajaa badäk hahỹỹ hã habong do sa mahang. Ti hado né paawä, dooh rakamahä̃n bä ta ti bag. Rakamahä̃n badagyp do hadoo doo, nesaa do ramoo bong do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nesaa do moo heb'ook doo, dooh rakamahä̃n bä ta bag. Dooh rakarẽn bä ta bag hadoo doo gó rabooh, nesaa do ramoo bok do kamanetëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Baad hadoo do ky n'aa P'op Hagä Do metëëk doo da habok doo, tabawak bä hadoo doo gó rababok, P'op Hagä Do ky gabuuj né ta ti ramoo bong doo, takametä däk hyb n'aa —näng mä Jesus Nikodẽm hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ta jawén mäh, Jesus, ta ma matëg daheeh raberéd hõm mä Jerusarẽnh panang. Panang bahä̃nh, Judah häj n'aa bä tabaym dó ta ma matëg daheeh. Ta tii bä tanu gemuun bong ta wë han'aa doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ti noo gó Jowãw nu gahem'uun do nu gemuun wät panang Anon häd näng doo bä, panang Sarĩm häd näng do nedaa bä, tamii maeh do hyb n'aa tii bä. Hajõk Jowãw wë han'aa ranu kemuun hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jowãw nu gahem'uun do radawäts gëët do pooj jé tii.) ");
INSERT INTO mbjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ti m' Jowãw nu gahem'uun do ma matëg raky ked'aak Judah buuj see sii. Judah buuj raky n'aa jaw'yyk do mejũũ nyy da ji behop ji h'yyb enyyw däk hyb n'aa P'op Hagä Do matym gó. Ti p'ãã raky ked'aak. Ti m' Jowãw nu gahem'uun do ma matëg rabana ta wë, ti m' raky hadoo ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","—Ãã ma matëg —näk mä Jowãw hã. —Aj'yy tamyyj däk hã makahataa doo, maky n'aa her'oot do paah, ta ti na-ããj hẽ nu gemuun hỹỹ kä. Sahõnh hẽ rabahõm kän ta wë. Dooh ãã wë rana boo bä —näk mä Jowãw nu gahem'uun do ma matëg ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ti m' Jowãw ky hadoo: —P'op Hagä Do né hẽ ti hanoo ji hã ji moo wät do pan'aa. P'op Hagä Do ky gabuuj né hẽ ti tamoo wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bë hapäh né hẽ, bë maa napäh né hẽ bë hã ỹ her'oot do paah. P'op Hagä Do H'yyb Däng Do nado ỹ hỹỹh, näng paa ỹỹh. P'op Hagä Do mejũũ ỹ ta pooj jé, näng paa ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Raketëë do jäm n'aa rabajäm noo gó, ta patug pan'aa wë né ta ỹỹm pan'aa bahõm. Aj'yy najiis, jäm h'yyb mahũũm n'aa, tsebee kän katëë do pan'aa kyyh hã. Katëë do najiis tsebé do hadoo ỹ hỹỹh —näng mä Jowãw. —Baad ỹ tsebee kän sahõnh hẽ rabahõm do hyb n'aa ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Taw'ããts hẽ rahyb n'aa jawyyg magyys hẽ ta tii. Ti yd jé taw'ããts hẽ ỹ rahyb n'aa sakog magyys hẽ —näng mä Jowãw. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ti m' Jowãw ky hadoo ẽnh: —Hỹ pong jé hana doo, sahõnh hẽ sa bahä̃nh ta tii. Badäk hahỹỹ bä naa ỹ ti hỹỹh. Badäk hahỹỹ bä naa ti ỹ hajaa ỹ her'ood bä. Hỹ pong jé hana doo, sahõnh hẽ bahä̃nh hadoo doo, ");
INSERT INTO mbjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ti né hẽ sahõnh hẽ tabaher'oot t'ĩĩ hẽnh tahapäh doo, tamaa napäh do ky n'aa. Ti hado né paawä, dooh ragado bä taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ỹ gadoo ti hỹ pong jé hana do her'oot doo. Te hub né hẽ P'op Hagä Doo, baad ỹ ky däng. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ỹ P'op Hagä Do mejũũ ta ky n'aa ỹ baher'oot hyb n'aa. Baad tabanoo hã ỹ ta Sahee. Ti hyb n'aa, te hub né hẽ bë hapäh Jesus ky n'aa ỹ her'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","—P'op Hagä Do kamahä̃n ta T'aah. Sahõnh hẽ bagã n'aa tabahadoo ta Yb an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","P'op Hagä Do T'aah hã h'yy ka'eeh doo, edëb had'yyt da P'op Hagä Do pa hỹ pong jé. Nabuj keh'ũũm doo, ta hã h'yy kana'eeh doo, dooh da t'ĩĩ hẽnh raboo bä. Rahob had'yyt hẽ da nesaa doo, P'op Hagä Do an'oo bä —näng mä Jowãw kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ti m', hajõõ däk Jesus ma matëg, Jowãw nu gahem'uun do ma matëg bahä̃nh däg, Jowãw bahä̃nh däg na-ããj hẽ Jesus ranu gemuun doo, Pariséw raky n'aa napëë kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Dooh m' Jesus nu gemuun bä. Ta ma matëg ti nu gemuun Jesus wë han'aa doo.) ");
INSERT INTO mbjNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesus heen n'aa nyy däk bä m', Pariséw raky n'aa napäh bä kä, teréd hõm Judah häj n'aa. Garirej häj n'aa hẽnh tabahõm kän p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta tyw n'aa Samarija häj n'aa tabës doo me m' tabahõm. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ramahõm me m', rakajaa panang Sikar häd näng doo bä, Samarija häj n'aa bä. Hëëj Jakóh ta t'aah Joséh hã tanoo do paa nedaa hẽnh ti panang. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tii bä ti majat mä naëng Jakóh gagots däk do paah. Jesus akaaj däk mäh, dawëë rababok do hyb n'aa. Ti m' Jesus baso däk naëng majat do pa. Wasyg këë mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ti nuuj jé ta ma matëg rabahõm panang hẽnh, sa waa rabetsẽẽ hyb n'aa. Ti m' naëng majat bä ỹỹnh, Samarija buuj, kajaa mä naëng tabagóp hyb n'aa. Ti m' Jesus ky hadoo ta hã: —Na ỹ eëg naëng uuh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ti m' ỹỹnh hyb n'aa newëë teaanh do hyb n'aa. Dooh Judah buuj raherod bä Samarija buuj sa sii. Ti hyb n'aa m' taky hadoo: —H'ëëd hyb n'aa mabetsẽẽ hã ỹ naëng? —näng mäh. —Õm Judah buuj, ỹ ti Samarija buuj —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ti m' Jesus ky hadoo ta hã: —Mahapëë bä paawä ji matym n'aa P'op Hagä Do anoo do ji hã, mahapëë bä paawä hahỹ naëng hetsẽẽ do a hã, metsẽẽ paawä ta hã naëng. Ji h'yyb ed'ëëp do naëng n'aa paawä tanoo a hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ti m' ỹỹnh ky hadoo: —Ny ta hood? T'õp hahỹ naëng majat. N'yy hẽnh naa mabagóp ti naëng menooh doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—Ër wahë makũ Jakóh gagots jat hahỹ naëng. Ti mo haj'aa paah, ti ti hanoo paa ãã hã. Ti ti heëëk paah, ta taah reëëk paah, ta masããh reëëk paa hahỹ naëng. Ër wahë makũ bahä̃nh g'eeh õm? —näng mä ỹỹnh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ti m' Jesus ky hadoo ta hã: —Majat hahỹ naëng heëëk doo, p'aa hẽnh da tahoo kaaj däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—Naëng ỹ anoo do heëëk doo, dooh da tahoo kaaj wäd bä. Naëng ỹ anoo do tawäd had'yyt hẽ da sa h'yyb tym gó. Tanoo sa hã hỹ pong jé, P'op Hagä Do pa sa h'yyb tym edëb had'yyt hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ti m' ỹỹnh ky hadoo: —Na ta ti naëng ỹ karẽn, ỹ hoo nakaaj wät hyb n'aa, ỹ nana wät hyb n'aa, ỹ nagób wät hyb n'aa hahỹ naëng —näng mä ỹỹnh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ti m' Jesus ky hadoo ta hã: —Abaaj hõm! Mahahëën nä a patug —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Dooh ỹ patug nyy bä —näng mä ỹỹnh kyyh. Ti m' Jesus ky hadoo: —Ehub né hẽ õm, “Dooh ỹ patug nyy bä”, hanäng do õm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","—Ji ma poo oow pé paa a pat'uuk. Hỹỹ kä mapa gä doo, dooh né hẽ a patug tado bä. Ehub né hẽ õm ti hedoo doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ti m' ỹỹnh ky hadoo ẽnh ta hã: —P'op Hagä Do ky n'aa rod ti õm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Sooh nanäng waëë jó ãã wahë makũ rahyb n'aa jew'yyk P'op Hagä Doo. Bëëh, Judah buuj, Jerusarẽnh bä m' ji hyb n'aa jaw'yyk, bë nooh. Nyy da a hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ti m' Jesus ky hadoo ta hã: —Baad ỹ baher'oot a hã, ỹ maky dahé. Ti awät da ti noo gó, dooh da P'op Hagä Do ji Yb ji hyb n'aa jewyyg wäd bä nanäng waëë jó, Jerusarẽnh bä na-ããj né da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","—Bëëh, Samarija buuj, dooh bë hapëë bä ta ti bë hyb n'aa jew'yyk doo. Ãã hahỹ Judah buuj, ãã hapäh ta ti ãã hyb n'aa jew'yyk doo. Ããh, Judah buuj, ãã mahang né hẽ ti taganyyh sahõnh hẽ sa h'yyb tym dëëb —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","—Ti awät da ti noo gó kä, da hẽ né hẽ ta du däk, baad P'op Hagä Do ji Yb hyb n'aa jaw'yyk doo, P'op Hagä Do Sahee hejój gó, tak'ëp baad hadoo doo gó na-ããj hẽ rahyb n'aa jew'yyk da. Ta ti hedoo do P'op Hagä Do ji Yb karẽn. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sahee né hẽ ti P'op Hagä Doo. Ti hyb n'aa taw'ããts hẽ ta hã hyb n'aa jew'yyk doo, ta Sahee hejój gó, tak'ëp baad hadoo doo gó na-ããj hẽ P'op Hagä Do rahyb n'aa jew'yyk —näng mä Jesus ỹỹnh hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ti m' ỹỹnh ky hadoo: —Ỹ ky n'aa napäh ti awät da Mesijas (Kristo, P'op Hagä Do H'yyb Däng Do ramaneëënh doo) —näng mäh. —Takajaa bä, sahõnh hẽ da ër tamaher'oot —näng mä ỹỹnh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ti m' Jesus ky hadoo ta hã: —Ỹ né ti hỹ Mesijas, a sii her'oot do né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tii bä kä m', Jesus ma matëg rakajaa. Rahyb n'aa meuunh mä ỹỹnh sii Jesus ber'oot do hyb n'aa. Rahyb n'aa meuuj né paawä, dooh m' reaaj bä ta hã ỹỹnh hã taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ti m' ỹỹnh beréd häng ta naëng hood, myyj hẽnh tabajëng. Takajaa bä m' tabaher'ood kän myyj bä haj'eenh do sa hã. Ti m' taky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Hamäh, ër hegãã aj'yy sahõnh hẽ ỹ moo wät do paa ỹ tamaher'oot doo —näng mäh. —Kristo, P'op Hagä Do H'yyb Däng Do hyb n'aa hadoo ti ta tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ti m' rabahõm kän rabaheg'ããs hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ti nuuj jé Jesus ma matëg ramejõ bong tabawa wät hyb n'aa ta waa: —Mawa wäd a waa, ma matëg! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ti Jesus ky hadoo sa hã: —Ti anäng wa ỹ bë nahapäh doo —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ti m' sa da hadoo do hã ta ma matëg rabeaanh: —Ramana wät g'eeh ta waa? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ti m' Jesus baher'oot sa hã: —Ta ti hã ỹ mejõ hyng do karẽn do ỹ moo wät. Ỹ karẽn ỹ bahajaa hã ỹ tamejũũ doo. Ti né hẽ wa ỹ hadoo doo, ỹ hanäng doo. Ti né hẽ hëp ỹ hejój —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Hahỹỹ da bë ky hetëg: “4 nä ta kamarab n'aa takata däk hyb n'aa joom tym”, bë nooh. —Bë hegãã, bok ta ti hajõk wë ỹ han'aa doo. Joom ag hahõõ däk do hadoo tii. Kaja kän ji ataa P'op Hagä Do wë, joom ag ji ataa do hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta ti wë ỹ hataa do gadoo da tamoo wät do säm. Hỹ pong jé, P'op Hagä Do pa ragadoo da edëb had'yyt doo, wë ỹ hata däk doo. Jé P'op Hagä Do kyyh sa h'yyb tym gó hejoom do hadoo doo, hã ỹ h'yy ka'eeh do taa n'aa na-ããj né hẽ, séd hã da rah'yy gadejah. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Te hub né hẽ hahỹ sa ky hetëg: “Ta see tejóm n'aa, ta see tataa n'aa.” ");
INSERT INTO mbjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tii da da bë hã kä. Bë ỹ mejũũ bë bataa hyb n'aa bë nejoom doo. Ta wób ti moo bong tii. Ta wób ramoo bok do säm bë gado kän —näng mä Jesus ta ma matëg hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ti m', hajõk Samarija buuj, ta ti panang buuj, rah'yy kae padäg kän mä Jesus hã, ỹỹnh maher'oot do hyb n'aa sa hã. Hahỹỹ d' mä ỹỹnh kyyh sa hã: “Sahõnh hẽ ỹ tamaher'oot ỹ moo wät do paah”, näng paa m' ỹỹnh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ti m', Jesus wë panang buuj rakajaa bä, rabetsẽẽ ta hã sa panang bä tabaym hyb n'aa. Tii bä kä, pawóp hẽ ta ä̃h tabayyw wät. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ti bahä̃nh kä, hajõk panang buuj rah'yy kae kän, sa hã Jesus her'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ti m' ỹỹnh hã raky hadoo: —Maher'oot do hyb n'aa nado wäd ãã wén ky daheeh. Ãã wén ky daheeh hỹỹ kä, ta kyyh ãã maa napäh do hyb n'aa. Sahõnh hẽ badäk hahỹỹ hã habong do sa h'yyb tym dëëb né hẽ ti hahỹỹ kä, ãã hapäh hỹỹ kä —näk mä sa kyyh ỹỹnh hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pawóp däg kä m' ta ä̃ kä sa panang bä tatab'ëës doo, Jesus bahõm kän Garirej häj n'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hahỹỹ d' mä Jesus her'oot do paah: “Ta häj n'aa bä dooh ragado bä P'op Hagä Do ky n'aa rod.” ");
INSERT INTO mbjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ti m', Garirej häj n'aa bä takajaa bä, ragadoo Jesus. Rawén gadoo, sahõnh hẽ Jesus pahuunh doo, Pas-kowa Jerusarẽnh bä ratab'ëës noo gó, rabahapäh do hyb n'aa paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","P'aa hẽnh mä Jesus bahõm ẽnh panang Kanah häd näng doo hẽnh, naëng, uwa bëëh matsing do tawareem paa bä. Ti awät aj'yy hyb n'aa jawyk doo, sa häj n'aa wahë n'aa kaser n'aa. Nahëë näng ta t'aah. Kapar-Naũm panang bä m' tabagä ti ta t'aah. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ti m' aj'yy ky n'aa napäh bä Jesus kajaa do Garirej häj n'aa bä, Judah häj n'aa bä naa, panang Kanah hẽnh tabahõm Jesus wë. Ti m' Jesus hã tabetsẽẽ ta sii tabahõm, ta t'aah nahëë tabahahëën hõm hyb n'aa. P'eets mä ta t'aah dajëb paawä. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ti m' Jesus ky hadoo sa hã: —Bë nahapëë bä tak'ëp hadoo do ji pehuunh doo, dooh né da bë ky dahé bä ẽnh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Hyb n'aa jawyk doo, —näng mä aj'yy —hamä si ỹỹ, tah ỹ nadajëp hyb n'aa —näng aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ti m' Jesus ky hadoo ta hã: —Abaaj hõm. Has'oo däk da a t'aah. Nadajëb da a t'aah —näng mä Jesus. Aj'yy ky dahé kän Jesus her'oot doo, ti hyb n'aa tababaaj hõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ti m' ta tyw n'aa me, ta hõõ bä, takata däk mä ta karom sa hã, ta tób hẽnh han'aa doo. —Has'oo däk a t'aah —näk mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ti m' tabeaanh sa hã: —Nyy b' akëë papỹỹj, ta nahëë badoo wät? —näng mäh. —Tsém né hẽ, atëh këë —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ti m' aj'yy hyb n'aa newëë, tii b' akä däk né hẽ m' Jesus baher'oot ta hã: “Has'oo däk da a t'aah”, tabanäng. Ti m' aj'yy, ta tób yt hã haj'eenh do na-ããj mä rah'yy kae padäg kän Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pawóp däg kä m' Jesus pahuunh do Garirej häj n'aa bä takajaa bä, Judah häj n'aa hẽnh naa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ti m', ta jawén Jesus bahõm kän Jerusarẽnh hẽnh, Judah buuj rahyb n'aa esee do ratab'ëës hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kahadë panang Jerusarẽnh häd näng doo. Panang noo seeh, B'éé Sa Tyw N'aa häd näng do pa ti majat karaj'aa bä mahan'yyts its. Betés-Da mä karaj'aa häd. Eberew kyy me tii. Ta w'oo hã 4 tób hatoonh kawõõt doo, sét hẽ ta hoo gad'oo bä hasooh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta ti yt hã hajõk nahëë enäh. Sa mahang ty temah doo, nabong doo, k'yy gedóm doo. Ta tii bä ragada mä naëng ketaam doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ta see pé noo gó m' P'op Hagä Do ããs bahyng mäh, tabetaam hyb n'aa naëng. Tabetaam jawén paa bä, pooj jé tame hahop do has'oo däk mä nahëë näng do paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nahëë enäh do sa mahang ti asooh mä aj'yy, 38 däg ta baab ta nahëëh. Nawäd tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ti m' Jesus bahapäh bä aj'yy hasooh doo, taky n'aa napäh bä p'ooj däg ta nahëëh taky hadoo ta hã: —Makarẽn mabahas'oo däk? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ti m' aj'yy ky hadoo: —Dooh ỹ haja bä —näng mäh. —Dooh ỹ masa pé naëng ketaam jawén paa bä, ỹ bahop hyb n'aa. Ỹ kakoon nuuj jé, ta see bahop pój ỹỹ jé. Ti hedo had'yyt hẽ —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ti m' Jesus ky hadoo ta hã: —As'ëëg g'ëëd! —näng mäh. —Mado däg a tyng. Awäd däg —näng mä Jesus kyyh aj'yy hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nayyw hẽ m' tabas'ëëg g'ëëd kän, tado däk ta tyng kä, awäd däg kän mäh. Saab noo gó m' ta tii, Judah buuj rakamehehãk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ti hyb n'aa Judah buuj sa wahë n'aa raky hadoo aj'yy hã: —Saab naga hẽ. Dooh ër ky n'aa jaw'yyk do an'oo bä ji tyng ji atón bä Saab hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ti m' aj'yy ky hadoo sa hã: —Aj'yy ỹ haso däk do ky hadoo hã ỹỹ: “Mado däg a tyng. Awäd däg”, näng hã ỹỹ —näng mä aj'yy. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ti m' raky hadoo ta hã: —Jaa ti ta ti a hã hedoo doo? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dooh m' aj'yy hapëë bä. Dooh wäd mä tii bä Jesus. Hajõk do mahang tabawäd däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ti noo gó né hẽ m', badawëd däk, Jesus hapëë kän aj'yy P'op Hagä Do tób n'aa bä. Ti m' Jesus ky hadoo ta hã: —Mahegãã. Õm has'oo däk —näng mäh. —Mamoo wäd wäd manä nesaa doo, ti bahä̃nh tanahadoo hyb n'aa nesaa do a hã —näng mä Jesus kyyh aj'yy hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ti m' aj'yy bahõm kän. Tamaher'oot mä Judah buuj sa wahë n'aa sa hã, Jesus ta ti haso däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tii bä kä m' Jesus raky n'aa hajẽẽw kän, ranu mer'ood kän, Saab hã tahaso däk do hyb n'aa aj'yy. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ti m' Jesus ky hadoo sa hã: —Ee moo wäd had'yyt hẽ. Ỹ na-ããj né hẽ ỹ moo wäd had'yyt hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta tii d' tabedoo do hyb n'aa, tak'ëp kä Judah buuj sa wahë n'aa rakarẽn radajëëb kän. Pooj jé, dooh Saab tatay bä sa hã, ta jawén kä P'op Hagä Do m' ta yb mäh, tanooh. Sa hã, P'op Hagä Do hadoo mäh, tanooh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ti m' Jesus ky hadoo Judah buuj sa wahë n'aa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ỹỹh, P'op Hagä Do T'aah, dooh daj ỹỹ hẽ ỹ hajaa péh. Jããm né hẽ ỹ moo wät Ee, P'op Hagä Do moo wät do ỹ hapäh doo. Ee moo wät do né hẽ ti ỹ moo wät. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ee, P'op Hagä Doo, ỹ takamahä̃n. Sahõnh hẽ tamoo wät doo, hã ỹ tametëëh. Hahỹ aj'yy ỹ haso däk do bahä̃nh da, hã ỹ P'op Hagä Do banoo ỹ moo wät hyb n'aa. Bë hyb n'aa meuunh da ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Dejëp do genä bong, Ee an'oo bä. Rabedëb had'yyt doo kä, tanoo. Ti hadoo né ỹỹh, P'op Hagä Do T'aah, ỹ anoo rabedëp, ỹ h'yyb däng do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ee nado ta wób ky n'aa etyy. Hã ỹỹ, T'aah hã, Ee banoo sahõnh hẽ ỹ ky n'aa etyy hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ta tii d' tawén d'oo ỹ raweh'ëëh, ỹ rahyb n'aa jew'yyk hyb n'aa ta hã raweh'ëëh doo da, ta hã rahyb n'aa jew'yyk doo da. P'op Hagä Do T'aah waneh'ëëh doo, dooh né hẽ tawehëë bä ẽnh Ee P'op Hagä Doo, hã ỹ mejõ hyng doo —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ti m' taky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ỹ her'oot do gad'oo doo, hã ỹ mejũũ do hã h'yy ka'eeh doo, edëb had'yyt do ta hã däg, tawäd had'yyt hẽ da hỹ pong jé P'op Hagä Do pa. Dooh nesaa do hã taky n'aa kety däk da. Dooh banesaa doo hẽnh tahõm wäd bä. Edëb had'yyt hẽ kä ta h'yyb tym. P'op Hagä Do pa da tabawäd had'yyt hẽ kä —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ti m' Jesus ky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ti awät da ti noo gó, da hẽ né hẽ tadu däk, P'op Hagä Do hã h'yy gatemah doo, dejëp do hadoo doo, ramaa napäh da këh ỹỹ, P'op Hagä Do T'aah kyyh. Këh ỹ ky dah'eeh doo, edëb had'yyt hẽ da sa h'yyb tym. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ee, P'op Hagä Do hanaa né hẽ ji edëp doo. Ti hadoo né hẽ ta T'aah hã hana doo, P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hã ỹỹ, T'aah hã P'op Hagä Do banoo ỹ hyb n'aa jawyk hyb n'aa, sahõnh hẽ sa hã ỹ ky n'aa etyy hyb n'aa, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ỹ bahadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bë hyb n'aa meuuj manä ta ti ỹ her'oot do hã. Ti awät da ti noo gó, P'op Hagä Do T'aah kyyh sahõnh hẽ dejëp do paa ramaa napäh da. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tii bä da ragenä bong. Baad hadoo do moo heb'ooh do paah, hỹ pong jé da, P'op Hagä Do pa raboo had'yyt hẽ da. Nesaa do moo heb'ooh do paah, tabanesaa hẽnh da raky n'aa kety däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ti m' Jesus ky hadoo ẽnh: —Dooh ỹ hajaa pé ti daj ỹỹ hẽ. P'op Hagä Do ỹ tamaher'oot doo da né hẽ ỹ bad'oo sa hã. Ti hyb n'aa baad ub had'yyt hẽ ta ti sa hã ỹ ky n'aa etyy doo. Hã ỹ mejũũ do karẽn doo da ỹ bad'oo. Ỹ karẽn do jawén nado —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ti m' Jesus ky hadoo ẽnh Judah buuj wahë n'aa sa hã: —Daj ỹỹ hẽ këh ỹ n'aa ỹ her'ood bä paawä, dooh paawä baad tado bä tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ti awät nä ta seeh baad ub këh ỹ n'aa her'oot doo. P'op Hagä Do né tii. Te hub né hẽ këh ỹ n'aa taher'oot doo, ỹ hapäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bë mejũũ paa raky n'aa eaanh Jowãw wë. Baad Jowãw nu gahem'uun do baher'oot sa hã këh ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dooh hyb n'aa ỹ karẽn pé badäk hahỹỹ bä naa këh ỹ n'aa rod, tii d' ỹ wén her'oot. Ỹ wén ky däng Jowãw nu gahem'uun do her'oot do paa hã këh ỹ n'aa, taher'ood wät do bë ky daheeh hyb n'aa, bë h'yyb tym bedëp hyb n'aa nesaa do mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ji bag bawag däk do hadoo Jowãw nu gahem'uun do ma metëëk doo. Pooj jé dó, bë tsebee bong tama metëëk do hã —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ti m' taky hadoo: —Baad ub né paawä Jowãw nu gahem'uun do baher'ood wät këh ỹ n'aa, ti anäng ta bahä̃nh hadoo do këh ỹ n'aa metëëh doo. Hã ỹ Ee P'op Hagä Do anoo do ỹ pehuunh do pan'aa né tii. Ỹ pehuunh do hã ji bahapäh ỹ P'op Hagä Do mejõ hyng do ỹ ti hỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ee, P'op Hagä Doo, hã ỹ mejõ hyng doo, baad ub na-ããj hẽ taher'oot këh ỹ n'aa. Dooh noo gó bë maa napäh pé ta kyyh. Dooh noo gó ta mamets bë ty gahapäh péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dooh bë h'yyb tym gó tayyw bä ta kyyh, tamejũũ do hã bë ky nadaheeh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Baad né paawä bë ma kametëëk P'op Hagä Do kyy kerih do hã. Tii d' bë wén ma kametëëk, tii hã bë aw'yyt bë ed'oo bë edëb had'yyt do P'op Hagä Do wë. Hajõõ nuu me né hẽ bë ner'ood paawä, dooh bë h'yy ganyy bä këh ỹ n'aa hã ta hã taher'oot do hã! ");
INSERT INTO mbjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Këh ỹ n'aa ti taher'ood né paawä, dooh bë ana bä wë ỹỹ, edëb had'yyt do ỹ banoo hyb n'aa bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ti m' taky hadoo: —Ỹ raj'aa etsë do jawén nado ỹ bawät. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ỹ h'yyb hapäh bëëh! Dooh bë kamahä̃n bä P'op Hagä Do bë h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ee kyy gó né paawä ỹ bahyng, dooh ỹ bë gado bä. Ta seeh, ta daaj hẽ ta ky gabuuj gó hana doo, ti paawä bë gadoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bë gen'aak bë da hadoo do bë hã raj'aa etsëë bä. Dooh bë hyb n'aa p'eed bä bë ky n'aa, P'op Hagä Doo, sét had'op do her'oot do hã. Ti hyb n'aa bë nahajaa hã ỹ bë h'yy ka'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Bë ỹ ky n'aa tapaa bë edoo manä Ee, P'op Hagä Do wë. Ỹ nado tii, bë hã ky n'aa tapaa doo. Mosees hã ti bë h'yy kejäg ub. Ti né hẽ da bë taky n'aa tapaa. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosees bë ky dahé bä paawä, ỹ né paawä bë ky daheeh. Mosees né hẽ këh ỹ n'aa herih do paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dooh bë ky dahé bä ti terih do paah. Ti hyb n'aa bë wén ky nadaheeh ỹ her'oot doo —näng mä Jesus kyyh Judah buuj sa wahë n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ta jawén kä m', karaj'aa Garirej häd näng do Jesus batsëg hõm. Tiberijas karaj'aa häd seeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hajõk Jesus jawén habok, hajõng tapehuunh doo, nahëë enäh do taheso padëëk do na-ããj hẽ rabahapäh do paa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ti m', Jesus ta ma matëg daheeh rabasëëk waëë hã. Tii b' rabaym, ti m' rabehyy b'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Edaa däk mä Judah buuj Pas-kowa rataheb'ëës doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ti m' Jesus baheg'ããs, hajõk ti han'aa doo. Ti m' Pirip hã taky hadoo: —N'yy hẽnh da ër betsẽẽ hajõk do sa waa? ");
INSERT INTO mbjNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","—näng mä Jesus, Pirip tametyy hyb n'aa. Jesus hapäh ta h'yyb gó nyy d' tabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ti m' Pirip ky hadoo: —8 kamarab ji moo wät do säm dooh tahaja nä bä sa waa säm —näng mä Pirip. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ti m' ta ma matëg seeh, Ãn-Deréh, Simaw Peed hỹỹj, ky hadoo mäh: ");
INSERT INTO mbjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Gëët hỹ karapee. Ti anäng ta wë its ji ma poo oow pé pãw ned'ëëd is doo, sewada häd näng do s'ëëb. Tah'ỹỹb pawóp hẽ. Tahaj'as mä ti hajõk do hã? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ti m' Jesus ky hadoo: —Bë mejõ rabehyy b'ëëh jawii jó —näng mäh. Baeh jawii tii bä. Ti m' rabehyy b'ëëh. 5 miw ajyy tahyb n'aa pé tii bä hab'ëëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ti m' Jesus basog däk pãw, P'op Hagä Do hã taky hadoo: —Õm taw'ããts hẽ Ee. Man'oo däk ãã waa —näng mäh. Ti m' taban'oo kän hab'ëëh do sa hã. Ti hadoo né tah'ỹỹb ẽnh. Wog enä hõm mä sahõnh hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rabahajaa bä kä rawëh doo, Jesus ky hadoo: —Bë ata däg mad'aak doo, takanerejãã hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ti m' mad'aak do ta ma matëg rata hõm kän kawaju gó. 12 m' kawaju gedẽ hõm doo. Ji ma poo oow hadoo do paa madaag kän hajõng pãw bód. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ti m' hajõk do rabahapäh bä Jesus pahuunh doo, raky hadoo: —Hahỹ né hẽ P'op Hagä Do ky n'aa rod badäk hahỹỹ hẽnh hana doo, kerih do hã taher'oot doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus h'yyb gó tabahapäh bä, tak'ëp rah'yyb tatug paawä sa häj n'aa wahë n'aa tabahadoo hyb n'aa, ta mab hẽ kä p'op tabasëëk waëë jó sa mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tũũh däg kä m', Jesus ma matëg rabawëëj kän karaj'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","H'oo gó m' ragatsëg t'oonh, Kapar-Naũm häd näng do panang nemuun rabatsëg paawä. Badajuu däk mäh. Dooh m' Jesus awëëj nä bä sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ti m', tak'ëp bah'ood ty gahëm. Tewëëp maadaka. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dawëë péj rababoo däk bä kä, Jesus rahapäh. Tamii pong jó tabana sa wë. Ti m' tak'ëp rabeỹỹm bong. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ti m' Jesus ky hadoo sa hã: —Bë eỹỹm manäh! Ỹ ti hỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ti m' rah'yyb tsebee kän tagatsëg sooh bä sa sii. Ti m', nayyw hẽ rakaja kän jajé raty gapad'ëëk hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti m' jati péh, hajõk do tamyyj däk hã ha'yym do Jesus mä resoos. Tsém hadoo, sét né h'oo tii bä hajat. Ti gó né hẽ Jesus ma matëg rabatsëg hõm. Dooh m' Jesus gatsëg so bä sa sii, sa hã. Ti hyb n'aa m' tii bä aym, red'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ti noo gó né hẽ panang Tiberijas häd näng doo bä naa marakate wób ranu kajäk, pãw rabawa p'aa hẽnh tabanäng hẽnh. Tsém hadoo pãw rabawa do paah, Jesus P'op Hagä Do hã taky n'aa etsẽẽ do jawén paa bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ti m' rah'yy kadaw'uuh, dooh né hẽ m' Jesus tii bä, dooh ta ma matëg tii bä. Ti m' ragatsëg tooj kän marakate gó. Panang Kapar-Naũm tabanäng hẽnh rabatsëg hõm kän mäh, t'ĩĩ hẽnh Jesus rabesoos hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Karaj'aa ta myyj jé Jesus rabaw'yyt bä kä m' raky hadoo ta hã: —Ma matëg, —näk mäh —nyy b' akä makajaa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ti m' Jesus ky hadoo sa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ỹ pehuunh do hã bë h'yy genä däk do hyb n'aa nado ỹ bë wén esoos. Ỹ bë wén esoos, pãw hã bë wog enä padëëk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taw'ããts hẽ dooh bë waa hã had'yyt hẽ bë h'yyb padäg. Nayyw hẽ takarejãã tii. Taw'ããts hẽ bë h'yyb padäg had'yyt hẽ ji h'yyb tym edëb had'yyt do hanoo do hã. Kanarejã tii. Ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Doo, ỹ né hẽ bë hã hanoo tii. Ee, P'op Hagä Do ky gabuuj gó ỹ moo wät —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ti m' rabeaanh Jesus hã: —H'ëëd ti P'op Hagä Do karẽn ãã moo bok? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ti m' Jesus ky hadoo: —Hahỹỹ da P'op Hagä Do karẽn bë hã: Takarẽn bë h'yy ka'eeh tamejõ hyng do hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ti m' raky hadoo: —Ãã karẽn mametä ta heen n'aa. Mapahuunh do ãã bahapäh bä kä, õm ãã ky daheeh. H'ëëd mametëëh ãã hã? ");
INSERT INTO mbjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ër wahë makũ na-ããj hẽ rawa paa pãw hadoo do Manah häd näng doo, tabanawäng hẽnh rahabok noo gó. Hahỹỹ da P'op Hagä Do kyy kerih do ta ky n'aa hã: “Tanoo sa hã hỹ pong jé hana do pãw.” Ti bahä̃nh ti ãã karẽn mametëëh —näk mä sa kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti m' Jesus ky hadoo sa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Mosees nado ti hanoo ta ti pãw hỹ pong jé hana doo. Ee mo haj'aa ti ta ti pãw. Ee né hẽ ti hỹỹh, bë hã han'oo kän pãw heh'äät do hỹ pong jé hana doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Badäk hahỹỹ bä hahyng doo, badäk hahỹỹ hã habong do sa h'yyb hed'ëëp doo, ti né kä ta ti Pãw heh'äät kä P'op Hagä Do anoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ti m' raky hadoo Jesus hã: —Man'oo had'yyt hẽ ta ti ãã hã, maky däng doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti m' Jesus ky hadoo sa hã: —Ỹ né ti pãw hadoo do edëb had'yyt hẽ hanoo doo. Wë ỹ hana doo, dooh tasa wäd bä. Hã ỹ h'yy ka'eeh doo, dooh tahoo kaaj wäd bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Ỹ her'ood wät né paa bë hã, dooh hã ỹ bë h'yy kae bä, ỹ bë hapëë né paawä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ti hadoo né hẽ, wë ỹ rabana da sahõnh hẽ Ee anoo do hã ỹỹ. Dooh da ỹ mak'yyts bä wë ỹ han'aa doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Baad ỹ wén gadoo sa hã, P'op Hagä Doo, hã ỹ mejõ hyng do karẽn do ỹ moo wät hyb n'aa. Dooh daj ỹỹ hẽ ỹ karẽn do jawén nado. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hahỹỹ da P'op Hagä Do karẽn hã ỹỹ: Dooh takarẽn bä hã ỹ tanoo do see tabanesaa hẽnh tahõm bä, ỹ an'oo bä. Takarẽn ỹ genyy bong sahõnh hẽ hã ỹ tanoo doo, hỹ pong jé, P'op Hagä Do pa rababoo had'yyt hyb n'aa, sahõnh hã ta säm tabanoo noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee P'op Hagä Do karẽn sahõnh hẽ ta T'aah hã h'yyb padëëk doo, ta T'aah hã ky dah'eeh doo, redëb had'yyt hẽ kä hỹ pong jé ta pa. Sahõnh hẽ ta säm ragadoo bä kä, ỹ genyy boo kän P'op Hagä Do wë, hã ỹ h'yy ka'eeh doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ti m' hajõk do raky n'aa hajẽm, “Ỹ pãw hadoo doo, hỹ pong jé naa hahyng doo”, tahanäng do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hahỹỹ d' mä sa kyyh rabaher'oot bä: —Hahỹ ta see nado ti hỹỹh. Joséh t'aah né hẽ ti hỹỹh —näk mäh. —Ãã hep'ëëh ti ta yb, ãã hep'ëëh ti ta ỹỹn. H'ëëd hyb n'aa, “Hỹ pong jé naa ỹỹh”, tabanäng? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ti m' Jesus ky hadoo sa hã: —Jããm ti bë kyyh, bë ky kak'ëë doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Dooh hajaa pé wë ỹ hana péh, hã ỹ h'yy ka'eeh péh, Ee, mejõ hyng do ỹỹh, wë ỹ tanatsyyd bä sa h'yyb tym. Jããm hẽ hajaa wë ỹ rana bä, Ee h'yyb tatug bä wë ỹỹ. Hã ỹ h'yy ka'eeh do ỹ genyy bong da, P'op Hagä Do wë ranu kajäk hyb n'aa, sahõnh hã ta säm ỹ banoo noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hahỹỹ da P'op Hagä Do ky n'aa rod rerii bong paa ji ta h'yyb tatuk do ky n'aa: “Sahõnh hẽ sa hã P'op Hagä Do ma metëëk da.” Ti hyb n'aa, sahõnh hẽ Ee ma metëëk do maa new'ëë doo, sa h'yyb gó renäm doo, wë ỹỹ da rabana, hã ỹỹ da rah'yy ka'eeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dooh hapäh pé Ee, P'op Hagä Doo. Jããm né hẽ ỹỹh, P'op Hagä Do wë naa hahyng do hapëë wät —näng mä Jesus hajõk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ti m' Jesus ky hadoo ẽnh: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Hã ỹ ky dah'eeh do redëb had'yyt da hỹ pong jé, P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ỹ né ti pãw hadoo do edëb had'yyt hẽ hanoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tabanawäng hẽnh pãw hadoo Manah häd näng do bë wahë makũ rawa né paawä, dejëp né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hahỹ pãw hadoo do hỹ pong jé naa hahyng do hawa doo, dooh tadajëb bä ta h'yyb tym, dooh tabanesaa hẽnh tahõm bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ỹ né hẽ ta ti pãw hadoo do ji hed'ëëp doo, hỹ pong jé naa hahyng doo. Sahõnh hẽ hahỹ pãw hawa doo, raboo had'yyt hẽ da hỹ pong jé P'op Hagä Do pa. Hup ỹ ta ti pãw ỹ anoo do ỹ dajëp bä, badäk hahỹỹ hã habong do hỹ pong jé rabedëb had'yyt hyb n'aa P'op Hagä Do pa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ti m' tak'ëp Judah buuj raky kakä bong, tii da Jesus edoo do hyb n'aa. Hahỹỹ d' mä sa kyyh: —Nyy da hahỹ aj'yy banoo ër bawëh hyb n'aa ta dab? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti m' Jesus ky hadoo: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Aj'yy Hadoo Do Hỹ Pong Jé Hana Do dab bë nawëë bä, ta majyyw bë neëg bä, dooh bë haja bä hỹ pong jé bë nu kajäg bä P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jé dap ỹ hawëh doo, majyw ỹ heëëk doo, hỹ pong jé edëb had'yyt da P'op Hagä Do pa. Ỹ ganyy wät da P'op Hagä Do wë, sahõnh hã ta säm ỹ banoo noo gó kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tanawë heh'äät hadoo dap ỹỹ. Ji heëk do heh'äät hadoo majyw ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jé dap ỹ hawëh doo, majyw ỹ heëëk doo, séd hã däg ta h'yy kata däk hã ỹỹ. Ỹ na-ããj da ta h'yyb gó ỹ bawäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ee hã tabana hedëp doo. Ti né hẽ ỹ tamejũũ. Ta hyb n'aa ỹ bedëp. Ti hadoo né hẽ, hã ỹ h'yy kamasoo doo, edëp da hëp ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gëët hahỹ pãw hadoo do hỹ pong jé hana doo. P'ooj ub bë wahë makũ rawa do paa nahado ti hỹỹh. Rawa né paawä ti dejëp. Hahỹ pãw hawa doo, tawäd had'yyt hẽ da P'op Hagä Do pa ");
INSERT INTO mbjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","—näng mä Jesus, tób P'op Hagä Do panyyg rayd naherot do yt hã tama metëëk noo gó, Kapar-Naũm panang bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ta ti Jesus her'oot do ramaa newë däk bä, hajõk Jesus ma matëg wób raky hadoo mäh: —Ti bahä̃nh hëëh ta ti taher'oot doo. Dooh ky daheeh pé ta ti hedoo doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ta ma matëg wób kawaj'ããn gó rabaher'oot ta kyyh p'ãã Jesus bahapäh bä m' ta h'yyb gó m', taky hadoo sa hã: —Ỹ her'oot do hã bë h'yy kejä̃g bong? ");
INSERT INTO mbjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bë h'yy kejä̃g bong tan'oo bä, nyy da da bë baher'oot ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do bë bahapäh bä, p'aa hẽnh hỹ pong jé tabasëëk bä? ");
INSERT INTO mbjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","P'op Hagä Do Sahee ti ji h'yyb tym hed'ëëp doo. Ji daaj hẽ ji hejój me dooh ji hajaa péh. P'op Hagä Do Sahee hã naa né hẽ ti ta ti këh ỹỹ, bë hã ỹ her'oot doo, hỹ pong jé, P'op Hagä Do pa ji edëb had'yyt hẽ hanoo doo. Te hub né hẽ këh ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ti hadoo né hẽ, bë mahang dooh raky dahé bä —näng mä Jesus. Ta tii da Jesus wén her'oot, pooj jé Jesus hapëë däk do hyb n'aa ta h'yyb gó sa mahang ky nadah'eeh doo. Tahapëë däk né hẽ ẽnh ta majĩĩ moo gó haëënh do pan'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ti m' Jesus ky hado kän: —Ti hyb n'aa bë hã ỹ bedoo, dooh hajaa pé wë ỹ hana pé Ee natatug bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti noo gó né kä m' hajõk heréd hõm Jesus. Dooh ta sii raboo boo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ti m' 12 hedoo do ta ma matëg hã Jesus beaaj wät: —Bë na-ããj bë karẽn bë bahõm mahä̃nh ỹỹ? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ti m' Simaw Peed häd näng do ky hadoo ta hã: —Hyb n'aa jawyk doo, —näng mäh —jaa sii ãã bahõm kän? Õm ti her'oot ji h'yyb tym hedëb had'yyt do ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Õm né hẽ baad had'op doo, P'op Hagä Do H'yyb Däng Doo, ãã ky daheeh. Ãã hapëë däk né hẽ tii —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ti m' Jesus ky hadoo: —Ỹ né hẽ, bëëh, 12 hedoo doo, wë ỹỹ ỹ asëëw hõm doo. Sét hẽ bë mahang Dijab karom! ");
INSERT INTO mbjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Judas, Simaw Ikarijot häd näng do t'aah ky n'aa ti taher'oot. 12 hedoo do see né tii, ta jawén Jesus taky n'aa her'ood däk do pan'aa kä majĩĩ hã.) ");
INSERT INTO mbjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ta jawén kä Jesus bawäd kän mä Garirej häj n'aa hẽnh. Dooh m' takarẽn tahõm bä Judah häj n'aa hẽnh, ta tii bä wahë n'aa rakarẽn radaj'ëëp do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tabedaa däk bä m', bag'aad me tób Judah buuj rabahemak do rataheb'ëës doo, ");
INSERT INTO mbjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesus hỹỹj raky hadoo mä ta hã: —Ayyw manä babä. Taw'ããts hẽ Judah häj n'aa hẽnh mabahõm, mapahuunh do a hataa rabahapäh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ji karẽn bä ji raky n'aa ets'ëëh, dooh ji jejën bä ji moo wät doo. Taw'ããts hẽ sahõnh hẽ rabaheg'ããs ti mapahuunh doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ta hỹỹj na-ããj hẽ dooh m' rah'yy kae bä ta hã, tii d' rawén edoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ti m' Jesus ky hadoo sa hã: —Dooh takaja nä bä ti noo gó ỹ bahõm doo. Bëëh, bë h'yyb karẽn do noo gó né hẽ bë bahõm. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh doo, dooh bë hã rakamajẽ bä. Wë ỹ rawén kamaj'ĩĩ, nesaa do ramoo heb'ooh do ky n'aa, nesaa do rahyb n'aa nahew'ëë do ky n'aa ỹ her'oot do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bë ahõm ta ti rataheb'ëës hẽnh. Dooh ỹ ahõm nä bä ta t'ĩĩ hẽnh. Dooh takaja nä bä ti noo gó ỹ bahõm doo —näng mä Jesus kyyh ta hỹỹj sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ta ti taher'oot do jawén paa bä m', Jesus baym dó Garirej häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ti m', ta hỹỹj rabahõm jawén paa bä, Jesus bahõm kän. Kejën do hadoo tabahõm, ta wób ranahapäh bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ti m' rahyb n'aa esee do rataheb'ëës hẽnh Judah buuj sa wahë n'aa resoos mä Jesus. Rabesoos bä m' rabeaanh n'yy hẽnh Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jé pad'yyt hẽ hajõk do wób raher'oot mä Jesus ky n'aa hã. —Ky enyym —näk mä ta wób. —Dooh —näk mä ta wób. —Ji tawadii tii —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kaja hẽ m' rabahesëënh ta ky n'aa, sa wahë n'aa rajeỹỹm do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Rataheb'ëës do hõõ bä, 4 ta ä̃ däg, Jesus bahõm kän mä P'op Hagä Do tób n'aa hẽnh. Tii bä tama met'ëëg kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ti m' Judah buuj sa wahë n'aa rahyb n'aa meuunh, ti m' raky hadoo: —Nyy d' hajõng tabahajaa, ma kamanet'ëëg né paawä hahỹ aj'yy? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ti m' Jesus ky hadoo sa hã: —Hã ỹ naa nado ti ỹ ma metëëk doo. Hã ỹ mejũũ do hanaa né tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","P'op Hagä Do gen'aak do karẽn moo wät doo, ti tahapäh da ta h'yyb gó, P'op Hagä Do hanaa tado bä, hana ỹ tado bä ỹ ma metëëk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jé ta daaj hẽ, ta ky gabuuj her'oot doo, ta hã raweh'ëëh do hyb n'aa tii. Ti hadoo nado ta hã mejũũ do raweh'ëëh karẽn doo. Dooh ji tawad'ii bä ta tii hã. Dooh j'ooj madäk do tado bä ta h'yyb. Baad had'op do tii —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ti m' Jesus ky hadoo ẽnh: —Mosees né hẽ bë hã hanoo P'op Hagä Do ky n'aa jaw'yyk doo. Ti hado né paawä, dooh bë ky dahé bä. H'ëëd hyb n'aa ti bë karẽn ỹ bë daj'ëëp? Ta ky n'aa bë ky dahé bä paawä, dooh paawä bë karẽn bä ỹ bë dajëëb bä —näng mä Jesus kyyh Judah buuj sa wahë n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ti m' ta wób raky hadoo: —Karap'aar h'yyb nesaa do a hã anäng! Dooh õm daj'ëëp péh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ti m' Jesus ky hadoo: —Sét hẽ ỹ pahuunh do hyb n'aa Saab hã, bë h'yy kejä̃g bong. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bë na-ããj né hẽ Saab hã né bë moo bok. Bë taah masuuj noo byyh kahõk do heen n'aa Saab noo gó tado bä, tii hã né hẽ bë moo bok, Mosees mejũũ do hyb n'aa. (Mosees nado du n'aa tii. Mosees pooj jé habong do paa ër wahë makũũh, ti ti du n'aa.) ");
INSERT INTO mbjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Hỹỹ kä bë hã ỹ beaanh: Saab hã bë an'oo bä ji t'aah masuuj noo byyh ji gahõg bä, Mosees ky n'aa jaw'yyk do ji ky daheeh do hyb n'aa, h'ëëd hyb n'aa ti bë kawajããn wë ỹỹ, Saab hã aj'yy baad ỹ ahub däk do hyb n'aa? ");
INSERT INTO mbjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Daap hẽ ỹ bë ky n'aa ety manäh. Taw'ããts hẽ P'op Hagä Do ky n'aa jaw'yyk do hã bë baheg'ããs ta ky n'aa —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ti m' Jerusarẽnh panang buuj wób raky hadoo: —Hahỹ nado aj'yy radaj'ëëp rahanäng doo? ");
INSERT INTO mbjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ti babä tabagëët ẽnh. Hajõõ mahang tabaher'ood né paawä, dooh sa kyy pé ta hã. Ër wahë n'aa rahyb n'aa newë däk apäh, P'op Hagä Do H'yyb Däng Doo, Kristo häd näng do tado bä tii? ");
INSERT INTO mbjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nyy d' ti hỹỹ éh? Ãã hapäh ti hahỹ aj'yy n'yy hẽnh naa. Kristo häd näng do kajaa bä, dooh ji hapëë bä n'yy hẽnh tahana —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ti hyb n'aa m', P'op Hagä Do tób n'aa bä Jesus ma metëëk bä taky hadoo, tak'ëp mä ta kyyh: —Bë hapäh mä ỹỹ, bë nooh. Bë hapäh mä n'yy hẽnh naa ỹỹ, bë nooh. Dooh këh ỹ gabuuj tado bä hỹ ỹ bahyng. Ti awät né hẽ ta ti hã ỹ mejõ hyng doo. Te hub né hẽ ta tii. Tahajaa ji h'yy kasadëë bä taky däng do hã. Ti dooh bë hapëë bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ỹ ti hapäh. Ỹ wén hapäh, ta wë naa ỹ bahyng. Ỹ tamejõ hyng —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tii d' tabedoo do hyb n'aa m', sa wahë n'aa rakarẽn ramoo maso däg paawä. Dooh hajaa pé ta hã, dooh nä tadajëp do noo gó tado nä bä do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sa wahë n'aa rakarẽn ramaso däg né paawä, hajõk mä ta hã h'yy kae padëëk. Hahỹỹ da m' sa kyyh: —Kristo, P'op Hagä Do Ky Däng Do kajaa bä, dooh tapehuuj da hahỹ pehuunh do bahä̃nh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ti m' Pariséw ramaa napäh bä ta tii da Jesus ky n'aa rabaher'oot bä, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa daheeh ramejũũ, P'op Hagä Do tób n'aa warahén n'aa Jesus ramasoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti m' Jesus ky hadoo: —Ỹ aym nä bë pa, ta jawén ỹ babaaj hõm hã ỹ mejõ hyng do wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ỹ da bë esoos tii bä. Dooh da ỹ bë awyyd bä, bë nahajaa do hyb n'aa bë ahõm bä ỹ hawät hẽnh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ti m' Judah buuj sa wahë n'aa rabaher'oot ta tii d' tedoo do ky n'aa. Dooh tagah'ood nä bä sa hã taher'oot doo. Hahỹỹ da m' sa kyyh: —N'yy hẽnh g'eeh tabahõm ãã naw'yyt, tahanäng doo? Gereg sa panang hẽnh g'eeh ti tahahõm, ër wakããn wób rahabong hẽnh? Gereg buuj g'eeh tama met'ëëg kän? ");
INSERT INTO mbjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nyy d' tahanäng pé ti: “Ỹ da bë esoos tii bä. Dooh da ỹ bë awyyd bä, bë nahajaa do hyb n'aa bë ahõm bä ỹ hawät hẽnh”, tahanäng doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tagadëëg ub rataheb'ëës do ä̃ n'aa, tak'ëp rahyb n'aa jew'yyk. Tii bä kä m', ti noo gó kä m' Jesus bas'ëëg gëët. Ti m' taky hadoo, tak'ëp mä ta kyyh: —Taw'ããts hẽ hoo kaanh do hadoo do ta hã, wë ỹ tabana tabeëëk do hadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hahỹỹ da P'op Hagä Do kyy kerih doo: “Hã ỹ h'yy ka'eeh do h'yyb gó naa ganyyh da ji h'yyb bed'ëëp do naëng n'aa” —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","P'op Hagä Do Sahee tahanäng pé tii, Jesus hã h'yy ka'eeh do ta jawén ragadoo doo kä. Dooh Jesus an'oo nä bä ti noo gó P'op Hagä Do Sahee, dooh tadajëb nä bä, dooh taganä wäd nä bä, dooh P'op Hagä Do wë takawehëë däk doo hẽnh tas'ëëg nä bä do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus her'oot do ta wób ramaa napäh bä m', raky hadoo: —Hahỹ né ti P'op Hagä Do ky n'aa rod, P'op Hagä Do Ky Däng Doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta wób mä raky hadoo: —Hahỹ né hẽ Kristo häd näng doo —näk mä sa kyyh. —Dooh. Garirej häj n'aa hẽnh naa nado Kristo bana —näk mä ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Dawi panaa da ta ti Kristo. Panang Berẽnh häd näng doo bä naa, Dawi panang paa bä naa Kristo bana da, näng P'op Hagä Do kyy kerih do hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sa h'yyb retyn hõm kän mä Jesus ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta wób rakarẽn paawä Jesus ramaso däk. Ti hadoo né hẽ m', dooh ta hã moo däng péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti m' P'op Hagä Do tób n'aa warahén n'aa, ramejõ nä do Jesus ramasoo hyb n'aa paawä, abaaj h'ũũm P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa sa wë, Pariséw sa wë na-ããj hẽ. Ti m' rabeaanh sa hã: —Hëd n'aa bë manana wät? —näk mä sa kyyh warahén sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ti m' warahén raky hadoo: —Dooh noo gó her'oot pé ta ti aj'yy her'oot doo da —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ti m' Pariséw raky hadoo warahén sa hã: —Bë na-ããj hẽ tawadii? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Dooh ër wahë n'aa raky dahé bä ta hã. Ãã Pariséw, ãã na-ããj hẽ dooh ãã ky dahé bä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","H'yy gatemah ti hajõk do ta hã ky dah'eeh doo. Dooh Mosees ky n'aa jaw'yyk do rahapëë bä, ti rawén sũũt. P'op Hagä Do was'ee bong ti ta ti hajõk doo —näk mä Pariséw sa kyyh warahén sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ti m' sa seeh, Nikodẽm häd näng doo, Jesus wë hegãã wät doo, ky hadoo ta wób sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Dooh ër ky n'aa jaw'yyk do an'oo bä daap hẽ ër ky n'aa ety bä ër da hadoo doo. Taw'ããts hẽ pooj jé ër beaanh ta hã tamoo wät doo, tama metëëk doo, ër ky n'aa napäh hyb n'aa —näng mä Nikodẽm. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ti m' ta wób raky n'aa rejã kän, ti m' raky hadoo ta hã: —Õm na-ããj né hẽ apäh Garirej hẽnh naa? —näk mäh. —P'op Hagä Do kyy kerih do hã mahegãã bä, mabahapäh, P'op Hagä Do ky n'aa rod dooh Garirej häj n'aa hẽnh naa tana bä —näk mä sa kyyh Nikodẽm hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ti m' sahõnh hẽ rabahõm sa tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ti m' Jesus baym panang bahä̃nh péj, waëë Oriib häd näng doo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jati péh, bäp paah, Jesus bahõm ẽnh p'aa hẽnh P'op Hagä Do tób n'aa hẽnh. Hajõk kata däk ta wë, P'op Hagä Do tób n'aa w'oo hã. Ti m' tabahyy sooh, ti m' tama met'ëëg kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ti m' Mosees ky n'aa jaw'yyk do ma mehetëk doo, Pariséw sa daheeh, ramanaa ỹỹnh ta patug nadoo do sii haỹỹh doo, ta wób raw'yyt doo. Ti m' ỹỹnh ramejũũ hajõõ gó tabag'ëëd däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ti m' Jesus hã raky hadoo: —Ma matëg, —näk mäh —hahỹ ỹỹnh raw'yyt ta patug nadoo do sii tabaỹỹh bä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","—Ër ky n'aa jaw'yyk do hã ër Mosees mejũũ, pä me ji daj'ëëp ta ti hedoo do hyb n'aa. Nyy da a hã pé ji bad'oo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ta tii da rawén ke'aanh, rakarẽn Jesus kyyh hã rabaw'yyt raky n'aa tapaa do ky n'aa. Ti m' Jesus nu wajakoo sooh, tama poo me tũũ taberih. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Raky n'aa h'ũũm do hyb n'aa, as'ëëg gëët, ti m' taky hadoo sa hã: —Taw'ããts hẽ bë mahang nesaa do h'yyb gó nanäng doo, ti pooj jé hakut pä me —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ti m' p'aa hẽnh tanu wajakoo sooh ẽnh. Tũũ m' taberih p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta tii d' Jesus bedoo bä sa hã, rabahõm kän sét kenäh hõm. Wahëh hedoo do ti pooj jé hah'ũũm. Jããm né hẽ haym Jesus. Ỹỹnh hayyw gëët ta pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ti m' Jesus as'ëëg gëët, ti m' ỹỹnh hã taky hadoo: —N'yy hẽnh ta wób? Dooh õm ky n'aa etyy péh? —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Dooh. Tabad'op hẽ —näng mä ỹỹnh kyyh. Ti m' Jesus ky hadoo ta hã: —Ỹ na-ããj hẽ, dooh õm ỹ ky n'aa ety bä. Ahõm kä. Meréd hõm hỹỹ kä nesaa do sahõnh hẽ —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ti m' p'aa hẽnh Jesus baher'oot kata b'ëëh do sa hã. Hahỹỹ d' mä ta kyyh: —Badäk hahỹỹ hã habong do sa h'yyb bag hadoo ỹỹh. Hã ỹ ky dah'eeh doo, dooh tabad'op hẽ badagyp do hadoo doo gó, nesaa doo gó, raboo bä tii. Ti anäng da sa wë sa h'yyb bag, P'op Hagä Do wë ji ted'ëëp doo, ta pa ji bawäd had'yyt hẽ hanoo doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ti m' Pariséw raky hadoo ta hã: —A mab hẽ, a daaj hẽ maky n'aa her'oot a ky n'aa —näk mäh. —Dooh Mosees ky n'aa jaw'yyk do an'oo bä ji mab hẽ, ji daaj hẽ, ji ky n'aa ji her'ood bä. Ti hyb n'aa taw'ããts hẽ nado ta ti maher'oot doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ti m' Jesus ky hadoo: —Map ỹỹ hẽ, daj ỹỹ hẽ, këh ỹ n'aa ỹ her'ood né paawä, né hup ỹ né hẽ ta ti ỹ her'oot doo. Ỹ hapäh ti n'yy hẽnh ỹ bana, ỹ hapäh ti n'yy hẽnh ỹ bahõm, né hup ỹ né hẽ ỹ wén näng. Bë tii, dooh bë hapëë bä n'yy hẽnh ỹ hana, n'yy hẽnh ỹ bahõm. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ỹ bë ky n'aa tapaa j'ooj hanäng do hã bë hapäh do hã. Ỹ dooh ỹ ky n'aa tapaa péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sa hã ỹ ky n'aa ety bä paawä, baad paawä ỹ ky däng sa hã, map ỹỹ hẽ nadoo do hyb n'aa ỹ ky n'aa etyy. Ti anäng hã ỹ ky masa doo. Ee, hã ỹ mejõ hyng doo, ti né hẽ ỹ taky masa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","—Pawóp hẽ ajyy séd demuun raher'ood bä, baad ub tii, ji ky daheeh sa kyyh, bë ky n'aa jaw'yyk do mejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tii d' né hẽ ãã bad'oo. Ỹ her'oot këh ỹ n'aa. Ee, hã ỹ mejõ hyng doo, ỹ taky masa këh ỹ n'aa hã —näng mä Jesus kyyh Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ti m' rabeaaj kän: —N'yy hẽnh a yb? —näk mäh. Ti m' Jesus ky hadoo: —Dooh ỹ bë hapëë bä. Dooh né hẽ Ee bë hapëë bä ẽnh —näng mäh. —Ỹ bë hapëë bä paawä, Ee na-ããj hẽ paawä bë hapäh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","P'op Hagä Do matym n'aa rabeheno do hood basooh do pa Jesus baher'oot tii, tama met'ëëk bä P'op Hagä Do tób n'aa yt hã. Rakarẽn né paawä ramasoo, dooh ta hã moo däng péh. Rawén moo nadäng, dooh takaja nä bä tadajëp do heen n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ti m' p'aa hẽnh Jesus baher'ood wät sa hã: —Ỹ da ahõm bë mahä̃nh. Ỹ d' bë esoos. Nesaa do anäng nä da bë hã bë dejëp. Ỹ hahõm hẽnh, dooh bë haja bä bë ahõm bä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ta tii d' tabedoo do hyb n'aa rakeaj kän mä sa hã hẽ né hẽ. Hahỹỹ d' mä sa kyyh: —Nyy d' tahanäng pé g'eeh: “Ỹ hahõm hẽnh dooh bë haja bä bë ahõm bä”, tahanäng doo? Ta daaj hẽ g'eeh takadaj'ëëp? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ti m' Jesus ky hadoo ẽnh sa hã: —Babä naa bë ti hỹỹh. P'op naa ỹ ti hỹỹh. Badäk hahỹỹ bä naa bë ti hỹỹh. Ỹ ti dooh. Dooh badäk hahỹỹ bä naa tado bä ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nesaa do anäng nä da bë hã bë dejëp, näng ỹỹh. Ỹ né hẽ ti hawäd had'yyt do bë ky nadahé bä, bë da dejëp né hẽ nesaa do bë h'yyb tym gó anäng nä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ti m' raky gakog hõm: —Jaa ẽnh õm? —näk mä sa kyyh. —Pooj jé bë ỹ maher'oot do né hẽ —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ti m' taky hadoo ẽnh: —Ti anäng nä wë ỹỹ hajõng nä bë ỹ ky n'aa tapaa do pan'aa —näng mäh. —Te hub né hẽ hã ỹ mejõ hyng do her'oot doo. Tahajaa ji h'yy kasadëë bä taky däng do hã. Ỹ tamaher'oot do né hẽ ti ỹ her'oot do badäk hahỹỹ hã habong do sa hã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dooh m' rah'yy genä bä ta Yb ky n'aa Jesus her'oot bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ti hyb n'aa m' Jesus ky hadoo sa hã: —P'op, b'aa hã Aj'yy Hadoo Do Hỹ Pong Jé Hana Do bë basäg häng do jawén paa bä, ỹ né hẽ ti hawäd had'yyt do tii bä bë h'yy genä kän. Dooh daj ỹỹ hẽ ỹ moo wät péh, ỹ her'oot péh, ti noo gó kä bë bahapäh. Ti noo gó kä bë bahapëë kän hahỹỹh: Jããm hẽ ỹ her'oot bë hã, Ee ỹ tama metëëk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hã ỹ mejõ hyng do awäd had'yyt hẽ si ỹỹ. Dooh ỹ teréd bä, tagen'aak do ỹ moo wäd had'yyt do hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta ti tabaher'oot bä m', hajõk h'yy kae padäg kän ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ti m' Judah buuj ta hã h'yy kae padëëk do hã Jesus ky hadoo: —Ỹ ma metëëk do bë ky dahé had'yyt bä, hëp ỹ hata heh'äät padäg bë tii bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bë hapäh da tii bä baad hadoo do ky n'aa. Baad hadoo do ky n'aa bë da ted'ëëp, baad bë babok hyb n'aa kä —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ti m' raky hadoo: —H'ëëd hyb n'aa tii da mabaher'oot? Abaraãm panaa né hẽ ti ããh. Dooh noo gó ta wób sa karom kanep'aak do ãã ado bä. Nyy d' mahanäng pé ta ti maher'oot doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ti m' Jesus ky hadoo: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Nesaa do moo wät doo, nesaa do karom né kä tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dooh da ta kariw n'aa tób yt hã ta karom awäd had'yyt hẽ. Jããm né hẽ ta t'aah hadoo do ti haym ta tób bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ti hyb n'aa, P'op Hagä Do T'aah bë tedëëb bä, baad né tii bä bë baboo kän, nesaa do karom nado boo bëëh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ỹ hapäh, Abaraãm panaa né ti bëëh. Ti hado né paawä, ỹ bë karẽn ỹ bë daj'ëëp, baad takanejäk do hyb n'aa bë h'yyb gó ỹ ma metëëk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Bë ỹ ma metëëk Ee metëëk do hã ỹỹ. Bë tii, bë yb wë bë ma kametëëk doo, ti bë moo bok —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ti m' raky hadoo: —Abaraãm ti ãã wahë makũũh —näk mä sa kyyh. Ti m' Jesus ky hadoo: —Abaraãm panaa bë do bä paawä, Abaraãm bad'oo doo da paawä bë bad'oo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","—Baad hadoo do ky n'aa, hã ỹ P'op Hagä Do an'oo däk do bë ỹ maher'oot. Tii d' né paawä ỹ metëëk bë hã, bë karẽn ỹ bë daj'ëëp. Dooh paa ta tii da Abaraãm adoo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bë yb moo wät do ti ta ti bë moo bok doo —näng mä Jesus sa hã. Ti m' raky hadoo: —Ãã yb daap nado. Jããm né hẽ P'op Hagä Do ãã Yb. Ta taah heh'äät ãã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ti m' Jesus ky hadoo sa hã: —P'op Hagä Do tado bä paawä bë Yb, bë kamahä̃n paawä ỹỹh, P'op Hagä Do wë ỹ bana do hyb n'aa. Dooh këh ỹỹ gó tado bä ỹ bahyng. Ti né hẽ ti hã ỹ mejõ hyng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hëd n'aa ti taganahoot bë hã, ỹ her'oot doo? Bë h'yyb gó tawén ganahoot, këh ỹ bë ganadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dijab taah bëëh. Takarẽn do bë karẽn bë moo bok. P'ooj ub, tadu däk noo gó, dahej'ëëp do né paa tii. Dooh baad hadoo doo, heh'äät ub do ky n'aa tagenaag bä. Dooh baad hadoo do ky n'aa ta h'yyb gó tabawäd bä. Daap tamenyyh bä, ta kyyh né hẽ ti taher'oot doo. Daap menyyh do tii. Daap menyyh do yb né tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Baad hadoo doo, heh'äät ub do ky n'aa ỹ her'oot do hyb n'aa ỹ bë ky nadaheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jaa bë mahang hajaa pé nesaa do hã ỹ taky n'aa tapa bä? Baad hadoo do ky n'aa ỹ her'oot. H'ëëd hyb n'aa ỹ bë ky nadaheeh? ");
INSERT INTO mbjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","P'op Hagä Do taah hedoo do ramaa newëë P'op Hagä Do her'oot doo. Bë tii, dooh P'op Hagä Do taah bë do bä, ti hyb n'aa bë wén maa nanewëë ta kyyh —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ti m' Judah buuj sa wahë n'aa raky hadoo Jesus hã: —Baad né ãã ky kajäk. Samarija buuj né õm! Karap'aar h'yyb nesaa do a hã adäk! —näk mä sa kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ti m' Jesus ky hadoo: —Dooh. Dooh karap'aar h'yyb nesaa do adäg bä hã ỹỹ —näng mäh. Ỹ ti hỹỹh, ỹ weh'ëëh Ee. Bë tii, ỹ bë ky n'aa rejãã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dooh ỹ as'ũũd bä ỹ raweh'ëëh doo. Sét hẽ ti hawät ỹ raweh'ëëh karẽn doo. Ti né hẽ ti taky däng ji hã baad ji hado bä, baad ji nado bä. Bë nado ti ky kajäk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ỹ ma metëëk do ky daheeh doo, dooh tadajëb wäd bä —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ti m' Judah buuj sa wahë n'aa raky hadoo: —Ãã hapäh né hẽ hỹỹ kä, karap'aar h'yyb nesaa do a hã adäk né hẽ —näk mäh. —Abaraãm dajëp paah, P'op Hagä Do ky n'aa rod dejëp né paah, ti hadoo né hẽ, jé mama metëëk do ky daheeh doo, dooh tadajëb bä, näng õm. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ãã wahë makũ Abaraãm bahä̃nh g'eeh õm? Abaraãm dajëp paah, ti hadoo ẽnh P'op Hagä Do ky n'aa rod p'ooj ub habok do paah. Jaa õm a hã péh? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ti m' Jesus ky hadoo: —Daj ỹỹ hẽ ỹ kawehëë bä paawä, dooh taw'ããts hẽ tado bä ta tii. Ee, bë h'yy kaha'eeh bë hanäk doo, ti né ti ỹ taweh'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dooh bë hapëë bä tii. Ỹ ti hapäh. “Dooh ỹ hapëë bä”, ỹ noo bä paawä, ỹ paawä noo kanesa bë nemuun. Ỹ hapäh né hẽ ti P'op Hagä Doo. Ỹ ky daheeh ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abaraãm, bë wahë makũũh, tsebee wät ỹ kajaa noo gó tabahapäh bä. Tahapäh né paah —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—Õm ky kew'oonh ta ti maher'oot do hã —näk mä Judah buuj sa wahë n'aa. —Dooh mawah'ëë nä bä, dooh 50 ta baab mado nä bä, mahapäh mä Abaraãm a nooh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ti m' Jesus ky hado kän: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Abaraãm benäng do pooj jé ỹ awäd däg né hẽ! —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ti m' ta ti ramaa napäh bä, rabasog padëëk pä, ta hã radewëës hyb n'aa paawä, radajëëb paawä. Ti Jesus kejën hõm. Ahõm P'op Hagä Do tób n'aa bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tamahõm me tabahapäh aj'yy ty tamah doo. Ta hã d' né hẽ m' tabenäng bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ti m' ta ma matëg rabeaanh: —Ma matëg —näk mäh. —H'ëëd hyb n'aa hahỹ aj'yy tawén ty tamah tabenäng? Ta yb, ta ỹỹn nesaa do ramoo bok do hyb n'aa, ta daaj hẽ apäh nesaa do tamoo wät do hyb n'aa? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ti m' Jesus ky hadoo: —Dooh, ti hyb n'aa nado ti hahỹ tabahadoo —näng mäh. —Ty tamaa gó tawén enäng, ta hã P'op Hagä Do hejój kametëëh hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","—Taw'ããts hẽ tabawak nä bä ër moo bok, hã ỹ mejõ hyng do karẽn doo. Ti awät tabadajuuh, du daa d' ji moo wät péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Badäk hahỹỹ hã habong do sa h'yyb tym bag hadoo ỹỹh, badäk hahỹỹ hã ỹ bawät nä bä —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta ti taky hadoo do jawén paa bä, tũũ tabetsós wät. K'ããts me tamekuuj wät, ti m' aj'yy matym hã tahawug hõm mä ta uuh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Ahõm kä —näng mä aj'yy hã. —Mahetsyyd a matym naëng majat do Siroéh häd näng doo me —näng mä Jesus aj'yy hã. (“Mejũũ doo”, tahanäng pé ti Siroéh.) Ti m' aj'yy bahõm kän, tahetsyyd wät mäh, tabahapëë däg kän mäh. Ti m' tababaaj hõm kän ta tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ti m', ta tób pa haj'eenh doo, pooj jé dajẽẽr tabehetsẽ bä hep'ëëh do paa m' rahapäh mä aj'yy. Ti m' raky hadoo: —Hahỹ nado dajẽẽr hetsẽ do paah? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ti né m' ta wób sa hã. Ta wób raky hadoo: —Dooh ti tado bä —näk mäh. —Ta da hed'op —näk mäh. —Ỹ né tii —näng mä aj'yy ty tamah do paa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ti m' rabeaaj kän: —Nyy da mabahapëë däk? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ti m' aj'yy ky hadoo: —Aj'yy, Jesus ramaneëënh doo, mekuuj wät k'ããts, tii bä matym ỹỹ hã tahawug hõm ta uuh. Siroéh hẽnh ỹ tamejũũ, ỹ bahets'yyt hyb n'aa. Ỹ ahõm, ỹ hetsyyd wät, ti ỹ bahapëë däg kän —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—Ny tawät ti aj'yy? —näk mä ta hã. —Dooh ỹ hapëë bä —näng mä aj'yy kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ti m' ramahũũm mä aj'yy ty tamah do paa Pariséw sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Saab né hẽ paa m' k'ããts Jesus mekuuj wät, aj'yy taty nä däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ti m' aj'yy hã Pariséw rabeaanh nyy da ta matym nyy däg kän. Ti m' aj'yy ky hadoo: —K'ããts me matym ỹ tabahawug wät. Ỹ hetsyyd wät. Hỹỹ kä ỹ bahapëë däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ti m' Pariséw wób raky hadoo: —Dooh P'op Hagä Do mejũũ do tado bä ta ti aj'yy. Dooh Saab hã ky n'aa kajew'yyk do taky dahé bä —näk mä sa kyyh. Ti m' ta wób raky gadoo: —Nesaa do moo hew'ëët do tado bä paawä, dooh paawä tahaja bä hahỹ hadoo do meuj n'aa näng do tapahuuj bä —näk mä ta wób sa kyyh. Séd h'yyb nehedo boo m' Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ti m' p'aa hẽnh rabeaaj wät aj'yy hã: —Nyy d' mabaher'oot ta ti aj'yy ky n'aa? Õm né ti tamatym nä däk —näk mä sa kyyh. Ti m' aj'yy ky hadoo: —P'op Hagä Do ky n'aa rod né hẽ tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dooh nä Judah buuj sa wahë n'aa raky dahé nä bä aj'yy ty tamah doo, dooh né hẽ m' raky dahé nä bä aj'yy ty nyy däk doo. Ti hyb n'aa m' ta yb, ta ỹỹn ranaëëj kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ti m' rabeaanh sa hã: —Bë t'aah né hahỹỹh? —näk mäh. —Hahỹ né hẽ ti ty tamah do bë hanäk doo, tabenäng noo gó? Nyy da tabahapëë däk hỹỹ kä? —näk mä sa kyyh ta yb sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ti m' ta yb raky hadoo: —Ãã t'aah né ti ta tii. Ta hã d' né hẽ tabenäng —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","—Dooh ãã hapëë bä nyy da taty nyy däk, jaa ty nä däk. Ta hã bë eaaj. Wah'ëë tii, karapee nado. Tahajaa taher'ood bä ta daaj hẽ ta ky n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hahỹỹ d' paa m' Judah buuj sa wahë n'aa sa kyyh: “Ãã ado nyyh da, Jesus ti Kristo, P'op Hagä Do H'yyb Däng Do hanäng doo. Dooh da ãã gado wäd bä tób P'op Hagä Do panyyg ãã yd naherot do yt hã”, näk mä sa kyyh. Ti hyb n'aa m' ta yb tii da rawén edoo. Judah buuj sa wahë n'aa rajeỹỹm. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ti hyb n'aa m', “Wah'ëë däg. Ta daaj hẽ tabaher'oot”, rawén näng. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ti m' p'aa hẽnh ẽnh ranaëënh sa wë ty tamah do paah. Ti m' raky hadoo ta hã: —P'op Hagä Do hã maky dëë te hub tado bä! Baad maher'ood! —näk mäh. —Ãã hapäh né hẽ, nesaa do moo hew'ëët do ti ta ti aj'yy —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ti m' aj'yy ky hadoo: —Dooh ỹ hapëë bä nesaa do moo hew'ëët do tado bä, nesaa do moo hew'ëët do tanado bä. Sét hẽ ti ỹ hapäh: Ty tamaa né paa ỹỹh, ỹ taty nä däk —näng mä aj'yy Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ti m' p'aa hẽnh rabeaanh ẽnh: —Nyy da tabad'oo? Nyy da õm taty nä däk? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Bë ỹ maher'ood wät. Dooh ỹ bë ky dahé bä. Hëd n'aa bë karẽn p'aa hẽnh ỹ baher'oot? Bë na-ããj né hẽ bë karẽn ta ma matëg bë bahadoo? —näng mä aj'yy sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ti m' raky n'aa rejãã aj'yy. Ti m' raky hadoo ta hã: —Õm ti ta ma matëg! Mosees ma metëëk do ãã ti hỹỹh! ");
INSERT INTO mbjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","P'op Hagä Do her'oot paa Mosees hã. Ti ti ãã hapäh, ãã ky n'aa napäh. Ta ti aj'yy, dooh ãã hapëë bä n'yy hẽnh naa tii —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ti m' aj'yy ky hadoo: —B'ës ky kewooj éh. Ỹ né matym nyy däg paawä tamo haj'aa, dooh m' bë hapëë bä, bë nooh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ji hapäh né ti hahỹỹh: Dooh P'op Hagä Do maa newë bä nesaa do moo heb'ooh doo. P'op Hagä Do weh'ëëh doo, takarẽn do moo heb'ooh doo, ti né hẽ ti tamaa newëë. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pooj jé tadu dahäng noo gó, dooh ji ky n'aa napäh pé ty tamah doo gó henäng do hapëë däk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","—P'op Hagä Do wë naa tanado bä paawä, dooh paawä tahajaa péh, tabad'op hẽ —näng mä aj'yy kyyh sa wahë n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ti m' raky gadoo: —Nesaa do a hã anäng mabenäng, ãã mama metëëk? —näk mä sa kyyh aj'yy hã. Ti m' rah'eed nyyh mä P'op Hagä Do panyyg rayd naherot doo bä naa. Dooh m' ran'oo wäd bä tajëë wäd bä p'aa hẽnh t'ĩĩ hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ti m' Jesus ky n'aa napäh aj'yy rah'eed nyyh doo. Aj'yy tamamuun bä, taky hadoo ta hã: —Õm h'yy ka'eeh Aj'yy Hadoo Do Hỹ Pong Jé Hana Do hã? —teaanh mä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ti m' aj'yy ty tamah do paa ky hadoo: —Jaa tii? Ỹ mamaher'ood, ta hã ỹ h'yy ka'eeh hyb n'aa —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ti m' Jesus ky hadoo ta hã: —Mahapäh paah. Ỹ tii, a sii her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ti m' aj'yy ky hadoo: —A hã ỹ h'yy kae däg kän, hyb n'aa jawyk doo —näng mäh. Ti m' ta taron nuu me m' aj'yy bahyy häng Jesus wë, Jesus taweh'ëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ti m' Jesus ky hadoo: —Ỹ wén hyng babä, ỹ ky n'aa etyy hyb n'aa sa hã, ty temah do ỹ ty nä padëëk hyb n'aa, matym enäh do ranahapäh hyb n'aa, rah'yy ganahoot hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ti m' Pariséw wób ta sii habong do ramaa napäh taher'oot doo. Ti m' rabeaanh ta hã: —Nyy d' mahanäng pé tii? Ãã sii hẽ ty temah mahanäng? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ti m' Jesus ky hadoo: —Ty temah do bë hado bä paawä, bë h'yy ganah'ood bä paawä, bë h'yyb haj'aa hẽ nado tii, hã ỹ bë h'yy kana'eeh doo —näng mäh. “Ãã hapäh, ãã h'yy ganäng a hã”, bë hanäk do hyb n'aa, bë h'yyb haj'aa hẽ né hẽ hã ỹ bë h'yy kana'eeh doo —näng mä Jesus kyyh Pariséw sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ti m' Jesus ky hadoo ẽnh, panyyg ky n'aa gó tabenaa wät: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: B'éé hood kahadë do noo me najëë suun doo, ta hadë pong jé gatsëk doo, baretsëk do tii, kamaj'ĩĩ do tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ta noo me hajëë suun doo, ti né hẽ ta masããh b'éé hagã n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","B'éé hagã n'aa kajaa bä kä, ta noo hagã n'aa tagas'ëës ta nooh tabajëë suun hyb n'aa. Ta masããh hã ramaa napäh ta kyyh, sét ken'yyh tanaëënh bä sa häd me. Ti tamahũũm kän ta masããh ta w'oo hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sahõnh hẽ ta masããh tamanyyh do jawén paa bä kä, sa pooj jé tabahõm, tamahũũm kän. Ta masããh ah'ũũm sa hagã n'aa jawén, ta kyyh ramepäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tabad'op hẽ rahõm ramanepäh do jawén. Waj'aa bong ta mahä̃nh, raky manepäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ta ti ky n'aa me Jesus baher'oot sa hã. Dooh m' tagah'ood bä Pariséw sa hã taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ti hyb n'aa m', p'aa hẽnh Jesus ky hadoo sa hã: —Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ỹ né hẽ b'éé hood noo hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sahõnh hẽ pój ỹỹ jé heboo nä doo, ma matëg oow hedoo doo, P'op Hagä Do H'yyb Däng do hanäk do na-ããj, baretsëg paa tii, kamaj'ĩĩ paa tii. Dooh paa raky dahé bä sa kyyh, b'éé ky nadah'eeh do hadoo sa hagã n'aa nadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ỹ né hẽ b'éé hood noo hadoo. Wë ỹ nu däng doo, edëb had'yyt hẽ kä nesaa do mahä̃nh. P'op Hagä Do wë da tanu däng. Baad tabajëng, baad tabanyyh, tawyyd had'yyt hẽ baad hadoo doo, sa waa b'éé raw'yyt do hadoo. H'yyb nyyw gó, neỹỹm doo gó, tabawäd kän P'op Hagä Do matym gó kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hets'ëëk do rabana rabets'ëëk hyb n'aa, radej'ëëp hyb n'aa, ragawats'iik hyb n'aa. Ti no n'aa rabana. Dooh ti ỹ hado bä. Ỹ ahyng babä ỹ bed'ëëp hyb n'aa, baad hadoo doo gó rababoo had'yyt hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ti m' taky hadoo ẽnh: —Ỹ né hẽ b'éé hagã n'aa baad hadoo doo. B'éé hagã n'aa baad hadoo do kan'oo däk da, tadajëp ta masããh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sa karom, b'éé tabahag'ããs ramejũũ doo, ta säm tagadoo hyb n'aa, dooh b'éé hagã heh'äät tado bä. B'éé danäh nado tii. Eỹỹm wät tii, waj'aa wät tabanas'aa b'éé hek'ook do tabahapäh bä. Teréd bëëh b'éé. Tii bä awad japuk b'éé seeh, tii bä ta wób jé pad'yyt hẽ rawaj'aa bong ta ti hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ta säm hyb n'aa paa ti sa karom bahag'ããs b'éé. Dooh b'éé tahyb n'aa p'eed bä. Ti hyb n'aa tawajaah. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ỹ ti hỹỹh, b'éé hagã n'aa heh'äät hadoo. Ee, P'op Hagä Doo, ỹ tamepäh, ỹ na-ããj hẽ ỹ mepäh Ee, P'op Hagä Doo. Ti hadoo né hẽ baad ỹ mepäh masãh haa. Masãh haa na-ããj né hẽ, baad né hẽ ỹ ramepäh. Daj ỹỹ hẽ ỹ kan'oo däk, ỹ dajëp hyb n'aa masãh haa sa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ti abong nä masãh haa hedoo do wób, bong hahỹ wób nado tii. Ti na-ããj né da ỹ manaa wë ỹỹ. Raky daheeh né da ỹỹh. Séd hã däg da rakata padëëk, hã ỹ h'yy ka'eeh doo. Sét né hẽ da ỹỹh, sa hagã n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ỹ Ee kamahä̃n. Ỹ tawén kamahä̃n, daj ỹỹ hẽ ỹ kan'oo däk ỹ dajëp hyb n'aa, p'aa hẽnh ỹ bedëb wät hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dooh hajaa pé ỹ daj'ëëp péh. Daj ỹỹ hẽ ti ỹ kan'oo däk dajëb hã. Ỹ hajaa ỹ kan'oo däg bä dajëb hã. Ỹ hajaa p'aa hẽnh ỹ ganä wät p'aa hẽnh ỹ edëb wät hyb n'aa. Tii d' né hẽ Ee mejũũ ỹ bad'oo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ti m' p'aa hẽnh séd h'yyb nehedo boo Jesus hã, Jesus kyyh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hahỹỹ da hajõk do wób sa kyyh: —Karap'aar h'yyb nesaa do ta hã adäk. Baad h'yyb nado. Hëd n'aa bë maa newëë ti ta kyyh? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ti m' ta wób raky hadoo: —Dooh. Dooh ti taky hado bä karap'aar h'yyb nesaa do hadäk doo. Dooh karap'aar h'yyb ta ti hadoo do taher'ood bä. Dooh karap'aar h'yyb haja bä ty tsehẽt do raty nä padäg bä —näk mä ta wób sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ti m', Jerusarẽnh bä P'op Hagä Do tób n'aa hyb n'aa ratsebé do rataheb'ëës do kajaa. Tabahahëëm bawät noo gó m' tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus awät P'op Hagä Do tób n'aa yt hã, Saromãw häd näng doo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ti m' Judah buuj sa wahë n'aa ranu get'ëë däk Jesus. Ti m' raky hadoo ta hã: —Jããm hẽ, ãã mah'yyb manepä wäd manäh! Baad ub ãã mamaher'ood hỹỹ kä õm P'op Hagä Do H'yyb Däng Do mado bä —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ti m' Jesus ky hadoo: —Bë ỹ maher'ood wät, dooh bë ky dahé bä —näng mäh. —Ee ky gabuuj ta ti ỹ pehuunh doo. Ti ti metëëh këh ỹ n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Baad këh ỹ n'aa rametä né paawä bë hã, dooh bë ky dahé bä. Bë wén ky nadaheeh, dooh masãh haa b'éé wób bë do bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Masãh haa b'éé raky daheeh ỹỹh. Ỹ mepäh masãh haa. Ỹ rahadaa had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sa hã ỹ banoo edëb had'yyt do P'op Hagä Do pa. Tabad'op hẽ rahob bä tabanesaa hẽnh. Dooh hajaa pé masãh haa moh ỹỹ gó naa tado hõm bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ee, masãh haa hanoo doo, tak'ëp takabaj'aa sahõnh hẽ sa bahä̃nh. Ti hyb n'aa, dooh hajaa pé masãh haa tado hõm bä Ee moo gó naa. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ỹỹh, Ee, sét ãã —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ti m', p'aa hẽnh Judah buuj wób, Jesus majĩĩ hedoo doo, rabasog padëëk pä, ta hã radewëës hyb n'aa paawä, tadajëp hyb n'aa paawä. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ti m' Jesus ky hadoo: —Hajõng baad hadoo do Ee ky gabuuj ỹ pehuunh do ỹ metä wät bë hã. Ny hadoo do ỹ pahuunh do p'ãã bë karẽn ỹ bë daj'ëëp? —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ti m' Judah buuj wahë n'aa raky hadoo: —Baad hadoo do mamoo wäd wät do hyb n'aa nado õm ãã daj'ëëp pä me. Õm a wén kut pä me, P'op Hagä Do maky n'aa rejãã do hyb n'aa. Aj'yy né paawä õm, “Ỹ P'op Hagä Doo”, mabanäng —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ti m' Jesus ky hadoo sa hã: —Hahỹỹ da P'op Hagä Do her'oot paa sa hã, bë ky n'aa jaw'yyk do hã takerih: “P'op Hagä Do hadoo bëëh.” ");
INSERT INTO mbjNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ti né hẽ P'op Hagä Do kyyh. Bë hapäh né hẽ, dooh P'op Hagä Do kyy kerih do ji haja bä ji ahỹỹd bä. Ti hyb n'aa, ajyy tamejũũ do hã P'op Hagä Do ky n'aa hadoo ta häd n'oo däg bä, ");
INSERT INTO mbjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","hëd n'aa, “P'op Hagä Do maky n'aa rejãã”, bë banäng hã ỹỹ, “Ỹ P'op Hagä Do T'aah”, ỹ hanäng do hyb n'aa? Ỹ né hẽ, Ee P'op Hagä Do asëëw hõm doo, tah'yyb däng doo, wawẽẽ hẽ tamejõ hyng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ỹ moo nawäd bä paawä Ee, P'op Hagä Do moo wät doo, bë ky dahé manä ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ee moo wät do ỹ moo wäd bä, ỹ bë ky nadahé nä bä, taw'ããts hẽ bë ky daheeh ỹ pehuunh do metëëh do hã, hëp ỹỹ gó Ee bawät, Ee h'yyb gó ỹ bawät, baad bë bahapäh hyb n'aa —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ti m' p'aa hẽnh rakarẽn ramoo maso däk Jesus ta kyyh p'ãã. Dooh m' rahaja bä. Jesus ahõm sa mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ti m' Jesus batsëg hõm p'aa hẽnh tamii Joradãn häd näng do ta myyj jé. Ta myyj däk hã, Jowãw nu gahem'uun do nu gemuun wät paa bä tabaym dó. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hajõk an'aa ta wë. Ti m' raky hadoo: —Dooh né paawä Jowãw nu gahem'uun do pehuuj bä, te hub né hẽ sahõnh hẽ hahỹ aj'yy ky n'aa Jowãw nu gahem'uun do her'oot do paah —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tii bä m', hajõk rah'yy kae däk Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ti m', ti awät aj'yy Rasaro häd näng doo. Nahëë näng mä Rasaro. Panang Betanija häd näng doo bä tabawät ta ä̃nh Maah-Ta, Marija daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta ti né hẽ Marija, Jesus tsyym hah'ook do buu benyym doo me, ta sëën me tahawug hõm doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ti m', Rasaro ä̃nh ramejũũ Jesus rapanäk. Hahỹỹ d' mä sa kyyh: —Mahegãã, Tak'ëp Hyb N'aa Jawyk doo. Nahëë näng a najiis makamahä̃n doo —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ti m' Jesus maa napäh bä kä ta ky n'aa taky hadoo: —Rasaro madajëp do nado ti ta nahëëh. Rasaro wén nahëë näng, P'op Hagä Do kabaj'aa do kametëëh hyb n'aa, P'op Hagä Do T'aah kabaj'aa do kametëëh hyb n'aa na-ããj hẽ da ta hyb n'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maah-Ta, Maah-Ta ä̃nh, Rasaro, Jesus kamahä̃n né paawä, ");
INSERT INTO mbjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","dooh nayyw hẽ tahyb n'aa jóh bä. Pawóp nä ta ä̃h tatab'ëës, Rasaro nahëë näng do taky n'aa napäh bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ta jawén kä Jesus ky hadoo ta ma matëg sa hã: —Hamäh, p'aa hẽnh ër bah'ũũm Judah häj n'aa hẽnh, Rasaro rahabok hẽnh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ti m' Jesus ma matëg raky hadoo ta hã: —Ma matëg, —näk mäh —nag'aap hẽ Judah buuj sa wahë n'aa rakarẽn õm radaj'ëëp. Hëd n'aa t'ĩĩ hẽnh makarẽn mababaaj hõm? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ti m' panyyg gó Jesus ky hadoo: —Badawëët adëb bä tabawag. Adëb bä ji awäd bä, baad ji bawät. Dooh ji tsyym poo däng péh, badäk hahỹ bag n'aa yt ji bawät do hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","—Badagyp doo gó ji awäd bä, daap ji tsyym poo kejäk, ta bag badoh do hyb n'aa ta hã —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ti m', ta ti Jesus her'oot do jawén paa bä, taky hadoo ẽnh: —Ër najiis Rasaro aä̃ jëng. Ỹ ahõm dó t'ĩĩ hẽnh ỹ mebëë nyy hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ti m' ta ma matëg raky hadoo: —Ãã wahë n'aa, —näk mäh —tabaỹỹh bä, has'oo däk da —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Dajëp né hẽ Rasaro, näng Jesus. Aỹỹh ta ma matëg red'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ti m' baad ub Jesus baher'ood kän sa hã: —Dajëp Rasaro ỹ hanäng doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Baad tanyy ỹ badoh t'ĩĩ hẽnh tadajëp do hã, hã ỹ bë h'yy kae kän hyb n'aa kä —näng mäh. —Hamäh, ër ah'ũũm t'ĩĩ hẽnh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ti m', Toméh, “Kawareeh” ramaneëënh doo, ky hadoo ta wób sa hã: —Hamä ta sii, ta sii ër dejëp hyb n'aa —näng mä Toméh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ti m' panang Betanija bedaa däk bä, Jesus ky n'aa napäh, ji meheet pé däg mä ta ä̃h Rasaro pä gabaho doo gó radakä jëng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Edah panang Betanija, Jerusarẽnh bä naa. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ti hyb n'aa hajõk Judah buuj sa wahë n'aa hedoo doo, ta wób na-ããj mä an'aa Maah-Ta wë, Marija wë rah'yyb en'yym hyb n'aa, rahyb n'aa natón hyb n'aa sa hỹỹj makũũh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ti m' Maah-Ta ky n'aa napäh bä Jesus kajaa, anyyh mä ta tób bä naa, ahõm ta wë. Marija ahäng mä sa tób yt hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ti m' Maah-Ta kajaa Jesus wë kä, ti m' taky hadoo ta hã: —Hyb N'aa Jawyk Doo, —näng mäh —babä magëë bä paawä, dooh paawä hä̃j ỹ dajëb bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","—Ti hadoo né hẽ paawä, ỹ hapäh, P'op Hagä Do anoo né da a hã sahõnh hẽ ta hã maky n'aa etsẽẽ doo —näng mä Maah-Ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ti m' Jesus ky hadoo ta hã: —Ganä wät da a hỹỹj —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ti m' Maah-Ta ky hadoo: —Ỹ hapäh, ganä wät né da sahõnh hẽ ragenä bong do hã kä P'op Hagä Do betyn bong do hã kä banäm doo hẽnh, banesaa doo hẽnh —näng mä Maah-Ta. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ti m' Jesus ky hadoo ta hã: —Ỹ né da hanoo ta ti genyy bong doo. Ỹ né ti hedëb had'yyt hanoo doo. Hã ỹ h'yy ka'eeh doo, dajëb né paawä, tawäd had'yyt hẽ da hỹ pong jé P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hahỹ hedëp nä doo, hã ỹ h'yy ka'eeh doo, tabad'op hẽ da tadajëp ta h'yyb tym. P'op Hagä Do pa had'yyt hẽ da tabawäd kän —näng mä Jesus. Ti m' Maah-Ta hã tabeaaj kän: —Maky daheeh ta ti ỹ her'oot doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Ỹỹ, Hyb N'aa Jawyk Doo. Ỹ ky daheeh õm Kristo, P'op Hagä Do H'yyb Däng Doo, P'op Hagä Do T'aah, P'op Hagä Do ky n'aa enooh do paah —näng mä Maah-Ta kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ti m' ta ti tabaher'oot do jawén paa bä kä m' Maah-Ta bahõm, ta ä̃nh Marija tanaëënh hyb n'aa. Ta m'aa hẽnh mä tanaëënh, ti m' taky hadoo: —Ma matëg kajaa. Ta kyy gó õm ỹ naëënh —näng mä Maah-Ta ta ä̃nh hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ti m', Marija maa napäh bä ta tii, nayyw hẽ m' tabas'ëëg gëët, ahõm kän mä Jesus wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Dooh Jesus ajëë suun nä bä panang bä. Ta hã Maah-Ta mamuun doo bä tabagëët nä. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ti m' Judah buuj tób bä hat'oonh doo, Marija h'yyb en'yym doo, rabahapäh bä nayyw hẽ Marija bas'ëëg gëët bä, tabanyyh bä, rabahõm kän ta jawén. Kamag hakëë hẽnh hahõm red'oo mäh. T'ĩĩ hẽnh haoot red'oo mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ti m', Marija kajaa bä kä Jesus bagëët bä, ta taron nu paa me tabahyy häng ta wë. Ti m' taky hadoo: —Hyb N'aa Jawyk Doo, —näng mäh —babä magëë bä paawä, hä̃j ỹ dooh paawä tadajëb bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ti m' Jesus bahapäh bä Marija haoot doo, Judah buuj Marija sii han'aa do na-ããj hẽ ha'oot doo, baad nado wäd ta h'yyb, tak'ëp tahyb n'aa tón wät. Tahyb n'aa esów wät. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ti m' tabeaaj kän: —Nyy bä bë dakä jëng? —näng mäh. Ti m' raky hadoo: —B'ëëp, mahegãã, Hyb N'aa Jawyk Doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ti m' Jesus baód wät. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ti m' Judah buuj raky hadoo: —Bë hegãã, tak'ëp paa takamahä̃n —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ti m' ta wób raky hadoo: —Ty tamah do taty nä däk, tanoo. Hëd n'aa tananoo hahỹ tanadajëp hyb n'aa? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","P'aa hẽnh ẽnh baad nado wäd Jesus h'yyb. Tak'ëp tahyb n'aa tón takajaa bä kamag basuun bä. Pä gabaho doo gó radakä jëng. Pä gatsabak doo me ranoo gatsëë däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ti m' Jesus ky hadoo: —Bë noo gatsë do hõm —näng mäh. Ti m' Maah-Ta, dajëp do ä̃nh, ky hadoo: —Hyb N'aa Jawyk Doo, —näng mäh —buu banes'aa däg. Ji meheet pé däg ta ä̃h tadajëp —näng mä Maah-Ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ti m' Jesus ky hadoo ta hã: —Hã ỹ mah'yy kae bä, mahapäh da P'op Hagä Do kabaj'aa doo —näng mä Jesus Maah-Ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ti m' ranoo gasëëts hõm kän. Ti m', p'op Jesus ty dëë wät taky n'aa etsẽẽ hyb n'aa P'op Hagä Do hã. Ti m' taky hadoo: —Taw'ããts hẽ Ee. Mamaa napäh, maky daheeh ỹ ky n'aa etsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ỹ hapäh né hẽ ỹ mamaa napäh, ỹ maky dahé had'yyt hẽ. Ta tii d' ỹ wén edoo, babä hab'ëëh do sa hyb n'aa, õm né hẽ ti ỹ mejõ hyng do raky daheeh hyb n'aa —näng mä Jesus kyyh P'op Hagä Do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ti m' ta ti tabedoo do jawén paa bä kä, tak'ëp tanaëëj kän mäh: —Rasaro! —näng mäh. —Anäh! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ti m' dajëp do paa anä kän. Kahapõõs ta mooh, ta tsyym sii hẽ pããn hawak doo me. Ta matym na-ããj mä kahabën pããn me. Ti m' Jesus ky hadoo: —Bë apyn hõm pããn, baad tabahõm hyb n'aa kä —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ti m' hajõk Judah buuj Marija heg'ããs do Jesus pahuunh do hapäh doo, ta hã rah'yy kae padäg kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta wób ah'ũũm mä Pariséw sa wë, ramaher'oot mä Jesus mo haj'aa ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Pariséw daheeh ratsyyd bong Sinedirijo ajyy n'aa, Judah buuj sa wahë n'aa hedoo doo, séd hã rakata padëëk hyb n'aa. Rakata däk bä kä m', raky hadoo mäh: —Nyy d' ër bad'oo? Bë hegãã! Hajõng hahỹ aj'yy pehuunh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ër hyb n'aa nap'eed had'yyt bä tapehuunh do hã, sahõnh hẽ da rah'yy kae padëëk ta hã, sa wahë n'aa tabahado däk hyb n'aa. Roma buuj warahén n'aa kamajẽ bong da ãã hã tii bä. Rado hõm da P'op Hagä Do tób n'aa. Rado hõm da ãã häj n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ti m' sa seeh, Kajapas häd näng doo, ti noo gó P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do ky hadoo sa hã: —Dooh bë hapäh péh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—Dooh bë h'yy genä bä? Taw'ããts hẽ ta ti sét né hẽ dajëp, sahõnh hẽ Judah buuj ranadejëp hyb n'aa —näng mä Kajapas kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ta daaj hẽ tahajaa do hyb n'aa nado ta tii d' tabaher'oot. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do tado hyb n'aa, P'op Hagä Do banoo ta hã ti tabaher'oot hyb n'aa, ta pooj jé Jesus ky n'aa hã. Jesus dajëp da Judah buuj sa hyb n'aa tahanäng pé m' tii d' taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tadajëp Judah buuj sa hyb n'aa had'yyt nado. Tata däk séd hã da na-ããj hẽ sahõnh hẽ P'op Hagä Do taah hedoo do jé pad'yyt hẽ habong doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti jawén paa bä kä m', Kajapas her'oot jawén paa bä kä m', Judah buuj wahë n'aa rabaher'ood kän nyy da da Jesus radaj'ëëp. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ti hyb n'aa, dooh Jesus awäd wät bä sahõnh hẽ mahang kä. Ti hyb n'aa ahõm kän mä ta ma matëg sa sii kä panang Eparajĩm häd näng do tabanäng hẽnh, tabanawäng do nab'yy hẽnh kä. T'ĩĩ hẽnh rabaym dó. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tabedaa däk bä Pas-kowa häd näng do Judah buuj rataheb'ëës doo, hajõk hah'ũũm mä Jerusarẽnh hẽnh, t'ĩĩ hẽnh ratab'ëës hyb n'aa. Pas-kowa pooj jé rabahõm, sa h'yyb rabenäm hyb n'aa P'op Hagä Do matym gó, baad ratab'ëës hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesus mä resoos P'op Hagä Do tób n'aa yt hã rabab'ëëh bä. Hahỹỹ d' mä sa kyyh: —Nyy da bë hã? Ana g'eeh da Pas-kowa ër tab'ëës bä? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tii da rawén edoo, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Pariséw sa daheeh ramejũũ do hyb n'aa ramaher'oot hyb n'aa Jesus rahapëë bä. Rakarẽn paawä ramaher'oot ramaso däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ji moo oow see pé ta ä̃h Pas-kowa häd näng do pooj jé, Jesus matëh kän panang Betanija häd näng doo hẽnh, Rasaro taganyy wät do panang bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Takajaa bä kä m', Jesus najiis ramoo bok Jesus raweh'ëëh do tä n'aa. Maah-Ta manaa ti hat'oonh do sa waa, sa tä. Rasaro asooh sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ti m' Marija bado däk buu benyym do hood. Hãd eh ta hood. Tak'ëp ky n'aa gebah, heh'äät, joom nah-do häd näng do s'ëëb ti buu benyym doo. Ti m' tabahah'ook Jesus tsyym hã. Ti m' tatsyym hawug hõm ta sëën me. Jé pad'yyt hẽ däg tób yt hã buu benyym do buu bewäd däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti m' Judas Ikarijot häd näng doo, Jesus ma matëg seeh, ta jawén Jesus tahaëëj däk doo, ky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Hëd n'aa buu benyym do takanes'ëëm? 300 moweed k'ããts tëg hawak paawä ta säm. Ta säm ji an'oo paawä kas'uut do sa hã —näng mä Judas kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kas'uut do tat'yyd mehĩĩn do hyb n'aa nado ta tii da tawén her'oot. Baretsëg tii. Jesus sa dajẽẽr hagã n'aa Judas. Tahes'ook mä ta gó radahep'ëë doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ti m' Jesus ky hadoo ta hã: —Na magëd ti ỹỹnh. Ỹ radakä jëng noo gó buu benäw n'aa tii d' tabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kas'uut do aboo had'yyt hẽ bë mahang. Ỹ ti hỹỹh, dooh bë mahang ỹ awäd wäd bä had'yyt hẽ —näng mä Jesus Judas hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ti nuuj jé m' hajõk Judah buuj raky n'aa napëë däk Betanija bä Jesus bawäd däk doo. Ti m' rabana kän Jesus rabaheg'ããs hyb n'aa. Rasaro, dajëp do paah, Jesus ganyy wät do rabaheg'ããs hyb n'aa na-ããj né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Rasaro hyb n'aa hajõk Judah buuj rahyb n'aa eréd hõm sa wahë n'aa. Jesus hã m' rah'yy kae padäg kän. Ti hyb n'aa P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa Rasaro sii hẽ rakarẽn radaj'ëëp. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti m', jati pé hajõk doo, Pas-kowa hyb n'aa Jerusarẽnh hẽnh han'aa doo, Jesus raky n'aa napäh hana do Jerusarẽnh hẽnh. Ta hõõ bä tabawäd däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Madyyk g'aad hadoo do rakekyyt mäh, an'yyh mä panang bä naa, Jesus ragadoo hyb n'aa. Ti m' raky hadoo, tak'ëp sa kyyh: —P'op Hagä Do ãã j'aa etsë! —näk mäh. —Ky n'aa kedëng tii, Tak'ëp Hyb N'aa Jawyk Do kyy gó hana doo! —näk mäh. —Ky n'aa kedëng, Isaraéw buuj sa wahë n'aa! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ti m' jumeto t'aah jó Jesus baso kän. Tii d' né paa ta ky n'aa, P'op Hagä Do kyy kerih doo. Hahỹỹ da takerih: ");
INSERT INTO mbjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bë eỹỹm manä Sijõn buuj. Bë hegãã! Bë wahë n'aa ti awät da. Jumeto t'aah jó tabana.” ");
INSERT INTO mbjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pooj jé dó, dooh Jesus ma matëg rah'yy genä nä bä ta ti P'op Hagä Do kyy kerih do Jesus hã kametä wät ti noo gó. Ta jawén, Jesus dajëp, Jesus ganä wät, Jesus basëëk do jawén paa bä kä, rahyb n'aa es'ee däg kän ta ti ta ky n'aa kerih doo, ta hã kametëëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ti m' hajõk do wób, hap'ëëh do Rasaro Jesus ganyy wät doo, raher'oot mä ta wób sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ti hyb n'aa kä m', ta ti Jesus pahuunh do raky n'aa napäh do hyb n'aa, hajõk an'yyh panang bä naa Jesus ragadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ti m' Pariséw raky n'aa jõg bong sa da hadoo do hã. Hahỹỹ d' mä sa kyyh: —Bë hegãã! Dooh ãã haja bä hahỹỹh. Sahõnh hẽ ta wë rabahõm kän —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ti m' Pas-kowa noo gó, P'op Hagä Do rahyb n'aa jew'yyk hyb n'aa han'aa do sa mahang ti abong mä Gereg buuj wób. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pirip wë rabana. Betsaj-Da panang bä, Garirej häj n'aa bä naa ti Pirip. Ti m' raky hadoo: —Hyb n'aa jawyk doo, —näk mäh —ãã karẽn Jesus ãã bahegãã paawä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ti m' Pirip ahõm Ãn-Deréh wë, tamaher'oot hyb n'aa. Ti m' Ãn-Deréh bahadaa hõm Pirip. Jesus wë rabahõm ramaher'oot hyb n'aa Gereg buuj rakarẽn doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ti m' Jesus ky hadoo sa hã: —Kaja däk hỹỹ kä ỹỹh, Aj'yy Hadoo Do Hỹ Pong Jé Hana Do dajëp doo, baad ỹ P'op Hagä Do wén weh'ëëh da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","—Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Tiriig ag k'ããts gó takanajäg bä, k'ããts gó ta bóg nadajëb bä, ta mab hẽ, sét hẽ had'yyt hẽ tabaym ti ta ag. Ta bóg dajëb bä, papuuj ganyyh bä, tii bä hajõng ta ag ganä kän ta hanaa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","—Jé badäk hahỹỹ hã ji hawät do hã tak'ëp kamahä̃n doo, dooh da tanu dëë bä P'op Hagä Do wë. Badäk hahỹỹ hã ji hawät do hã kamanahä̃n doo, edëb had'yyt da P'op Hagä Do pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jé karẽn pé wë ỹ moo wät péh, taw'ããts hẽ hëp ỹ hata had'yyt hẽ. Ỹ bawät bä tabawäd had'yyt hẽ da wë ỹ moo wät doo. Ee weh'ëëh da tii —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ti m' taky hadoo ẽnh: —Hỹỹ kä, taw'ããts hẽ nado hëp ỹỹ. Nyy da da këh ỹỹ P'op Hagä Do hã? “Ee, ỹ medëëb nesaa do ỹ ahob mahä̃nh, ỹ dajëb mahä̃nh”, näng g'ee d' ỹỹh? Dooh. Ỹ dajëp hyb n'aa né hẽ ỹ bahyng —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ti m' Jesus ky hadoo P'op Hagä Do hã: —Ee, mametä baad had'op do õm, tak'ëp kabaj'aa do sahõnh hã —näng mä Jesus kyyh. Ti m', hỹ pong jé naa tamaa ena kyyh. Hahỹỹ da m' ta kyyh: —Ỹ metä wät. P'aa hẽnh da ỹ metëëh ẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Darung mä hajõk do tii bä hab'ëëh do sa hã. —Ããs ti her'oot ta sii —näk mä ta wób sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ti m' Jesus ky hadoo: —Hëp ỹ n'aa nado ti kyy ber'oot. Bë hyb n'aa ti taber'oot, bë ky daheeh hyb n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti m' taky hadoo ẽnh: —Hỹỹ kä kajaa däk P'op Hagä Do ky n'aa etyy do badäk hahỹỹ hã habong do ta hã h'yy kana'eeh doo. Da hẽ kä Nesaa Do Yb, badäk hahỹỹ hã habong do hã mejũũ do kahabëë hõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ỹỹ kä, p'op kajatsëk do hã, b'aa hã, ỹ radahëë däk bä, ỹ naëënh da wë ỹỹ sahõnh hẽ badäk hahỹỹ hã habong doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ta tii d' tawén her'oot, tametëëh hyb n'aa nyy da tadajëp. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ti m' hajõk do raky hadoo: —Ãã ky n'aa napäh P'op Hagä Do kyy kerih doo. Kristo häd näng doo, P'op Hagä Do H'yyb Däng Doo, awäd had'yyt hẽ m', dooh tadajëb bä takerih doo gó taher'ood bä. Hëd n'aa Aj'yy Hadoo Do Hỹ Pong Jé Hana Do p'op radahäng, mabanäng? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ti m' panyyg ky n'aa gó Jesus baher'oot sa hã: —Kanahën doo nä ta bag bawät nä bë mahang. Taw'ããts hẽ bë babok tabawak nä bä, badajung do adëë pooj jé bë hã. Ta tii d' ỹ wén her'oot bë hã, tabadajuu gó hawät doo, dooh tabahapëë bä do hyb n'aa n'yy hẽnh tahahõm. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bë mahang ta bag bawät nä bä, taw'ããts hẽ bë h'yy ka'eeh ta hã tabahajaa nä bä, ta bag taah bë bahadoo hyb n'aa —näng mä Jesus hajõk do sa hã. Ta ti taher'oot do jawén paa bä kä m', Jesus bahõm kän hajõk do sa mahä̃nh. Ta m'aa hẽnh mä tabawäd däk, ta ma matëg ta sii. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hajõng ta metëë n'aa Jesus pehuuj né paawä sa matym gó, ta wób dooh rah'yy kae padäg bä ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Rawén h'yy kana'eeh, Isajas, P'op Hagä Do ky n'aa rod makũ her'oot do paa kametëëh hyb n'aa. Hahỹỹ da Isajas baher'oot paa P'op Hagä Do H'yyb Däng Do kyyh: “Tak'ëp Hyb N'aa Jawyk Doo, dooh raky dahé bä ër her'oot doo. Dooh rah'yy genä bä Tak'ëp Hyb N'aa Jawyk do hejój sa hã kametëëh doo.” ");
INSERT INTO mbjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rawén nahajaa rah'yy ka'eeh, hahỹỹ da Isajas erii wät do paa hyb n'aa P'op Hagä Do kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“P'op Hagä Do gatsëë däk sa matym, ranahapäh hyb n'aa. P'op Hagä Do gatsëë däk sa h'yyb tym, rah'yy kanadaw'uuh hyb n'aa, rah'yy kawanareem hyb n'aa. Rah'yy kadawuung bä paawä hã ỹỹ, rah'yy kawereem bä paawä, ỹ h'yyb wareem paawä, baad rababok hyb n'aa kä.” ");
INSERT INTO mbjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ta tii da Isajas wén her'oot paah, Jesus hejój, Jesus bag tak'ëp gabarëëh do tabahapäh do hyb n'aa dawëë naa. Ti m' ta ky n'aa né m' ti taher'oot, Isajas hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dooh né paawä hajõk do raky dahé bä, hajõk Judah buuj wahë n'aa sii hẽ rah'yy kae padäg kän Jesus hã. Dooh raher'ood bä Jesus hã rah'yy ka'eeh doo, Pariséw rajeỹỹm do hyb n'aa. Rahabëë nyyh tii bä sa h'yyb, tób P'op Hagä Do panyyg rayd naherot doo bä naa. Sa h'yyb gó ub rah'yy ka'eeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sa hã baad ub sa da hadoo rawehëë bä sa hã. Dooh denaa hẽ ragenaag bä P'op Hagä Do ji taweh'ëëh do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ti m' Jesus ky hadoo, tak'ëp ta kyyh: —Jé hã ỹ h'yy ka'eeh doo, hã ỹ had'yyt nado tah'yy ka'eeh. Hã ỹ mejũũ do hã né hẽ tah'yy ka'eeh tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ỹ hapäh doo, hã ỹ mejũũ do na-ããj né hẽ tahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hỹ pong jé naa ỹ bahyng, badäk hahỹỹ hã habong do sa h'yyb bag ỹ bahadoo hyb n'aa, sahõnh hẽ hã ỹ h'yy ka'eeh do badagyp doo gó ranaym hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dooh ỹ tado bä hã ỹ ky nadah'eeh do ky n'aa etyy doo. Ỹ wén hyng babä, nesaa do ỹ ky n'aa etyy do jawén nado badäk hahỹỹ hã habong do sa hã. Ỹ wén hyng ỹ bed'ëëp hyb n'aa nesaa do mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ti anäng né hẽ ỹ ty n'aa ges'yyk doo, ỹ her'oot do ganadoo do sa ky n'aa etyy n'aa. Këh ỹỹ, sa hã ỹ her'ood wät do né hẽ ti sa ky n'aa etyy n'aa. Këh ỹỹ, sa hã ỹ her'ood wät do paa ky n'aa etyy sa hã, P'op Hagä Do banoo noo gó sahõnh hã ta säm. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta ti ỹ ma metëëk doo, këh ỹ gabuuj nado. Ee, ỹ mejõ hyng doo, ti né hẽ hanoo hã ỹỹ, ỹ tamejũũ ỹ her'oot doo. Ti hyb n'aa, “sa ky n'aa etyy n'aa däg, ỹ her'ood wät doo”, ỹ wén näng. ");
INSERT INTO mbjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ỹ hapäh né hẽ hahỹỹh: Ee kyyh ji ted'ëëp, ji bawäd had'yyt hẽ hyb n'aa. Ti hyb n'aa ỹ tamejũũ do ỹ her'oot do pan'aa, ti né hẽ ỹ her'ood had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ti m' sét wäd Pas-kowa ratab'ëës do ä̃h. Jesus hapäh ta h'yyb gó, kaja däk ti noo gó taberéd däk hyb n'aa badäk hahỹỹh, ta Yb wë tabasëëk hyb n'aa kä. Jesus kamahä̃n bong né paa ta ma matëg badäk hahỹỹ hã ta sii habok doo. Ta tii d' né kä m' tametëëh sa hã tak'ëp takamahä̃n doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Atsëm mä Pas-kowa tä n'aa rabawëh. Dijab h'yyb tatug däk mä Simaw t'aah, Judas Ikarijot, Jesus tabahaëënh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus hã ta Yb an'oo däk sahõnh hẽ ta hejooj, Jesus hapäh. P'op Hagä Do hã tabana, p'aa hẽnh tamatëëh ta wë Jesus hapäh na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ti m' Jesus bas'ëëg gëët, tado nyyh ta saroor j'ooj hadäk doo. Tawaho däk mä ta baa bä pããn ji kamehewuuk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ti m' naëng tagedu jat ta hood gó, ti m' ta ma matëg sa tsyym tahetsyyd kän. Ti m' tabawug hõm ta hã hadäk doo me. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simaw Peed wë takajaa bä kä m', Peed ky hadoo: —Hyb N'aa Jawyk Doo, —näng mäh —tsym ỹ sii hẽ mabahets'yyt? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ti m' Jesus ky hadoo ta hã: —Dooh mah'yy ganyy nä bä hahỹ ỹ moo wät doo. Ta jawén da mabahapäh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ti m' Peed ky hadoo: —Dooh. Tabad'op hẽ tsym ỹ mahetsyyd —näng mäh. Ti m' Jesus ky hadoo ta hã: —A tsyym ỹ nahetsyyd bä, dooh hëp ỹ hata mado wäd da —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ti m' Simaw Peed ky hado kän: —Tii d' madoo bä, ỹ karẽn paawä sahõnh hẽ ỹ mabahets'yyt! —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti m' Jesus ky hadoo: —Hehob wät doo, baad däg ta hã sahõnh hẽ. Jããm né hẽ ta tsyym tahets'yyt nä. Baad däg bë hã. Jããm né hẽ sét hẽ bë see baad nadoo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus hapäh mä ta hã haëënh doo. Ti hyb n'aa, “Dooh sahõnh hẽ baad tado bä”, tawén näng. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesus bahaja däk bä sa tsyym tahets'yyt doo, p'aa hẽnh tadadäk ta saroor j'ooj hadäk doo, ahyy sooh p'aa hẽnh, ti m' taky hadoo: —Bë hapäh nyy d' tahanäng pé ta ti ỹ moo wät do bë hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—Ỹ bë maneëënh “Ma matëg”, “Hyb N'aa Jawyk Doo”, näk bëëh. Baad né ti bë kyyh. Ti né hẽ ỹỹh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ỹỹh, Tak'ëp Hyb N'aa Jawyk Doo, bë ma matëg né paawä, bë tsyym ỹ hetsyyd wät. Ti hyb n'aa taw'ããts hẽ bë na-ããj hẽ da bë hetsyyd bë h'yy kanatëë tsyym. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Taw'ããts hẽ ỹ metä wät doo da da bë bad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Dooh sa karom sa kariw n'aa bahä̃nh tanu gadäg bä. Dooh sa panäg sa hã mejũũ do sa bahä̃nh tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bë hapëë däg kän ta tii. Ti hyb n'aa P'op Hagä Do bë taky n'aa edëng da ta tii da bë moo hedo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ti m' Jesus ky hadoo ẽnh: —Dooh sahõnh hẽ bë ky n'aa had'yyt tado bä ta ti ỹ her'ood wät doo. Ỹ hapäh ta ti sahõnh hẽ ỹ asëëw däk doo. Hahỹỹ da P'op Hagä Do kyy kerih do ỹ asëëw hõm do see ky n'aa: “Si ỹ hawa do ỹ tahyb n'aa wareem däk.” Kametä kän ta ti kerih doo gó ta ky n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ta pooj jé ta ti bë ỹ maher'oot, kametëëh do pooj jé, takametä däg bä, ỹ né hẽ Hawäd Had'yyt Do bë ky daheeh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jé ỹ mejũũ do gadoo doo, ỹ na-ããj né hẽ tagadoo. Ỹ gadoo doo, hã ỹ mejũũ do tagadoo. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus bahajaa bä kä m' ta ti taher'oot doo, baad nado wäd ta h'yyb. Ti m' baad tabaher'oot sa hã: —Bë see ỹ tahaëënh da majĩĩ moo gó. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ti m' sa daaj hẽ ta ma matëg raky kakä bong. Dooh rahapëë bä jaa ky n'aa ta ti taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sa kanatëë, Jesus tak'ëp kamahä̃n do asooh p'eets hẽ Jesus pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ti m' ta moo me Simaw Peed häd näng do beheet, p'eets hẽ hasooh do hã tabeaanh hyb n'aa ta hã jaa ti tahedoo doo. Ti m' taky hadoo ta hã: —Mameaaj ta hã jaa péh —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ta ti Peed mejũũ doo, p'eets hẽ takatahã däk ta hã, tabeaanh hyb n'aa. Ti m' tabeaanh: —Jaa tii, Hyb N'aa Jawyk Doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ti m' Jesus ky hadoo ta hã: —Hahỹ pãw ỹ heh'oos do ỹ hanoo doo. Ti né kä —näng mä Jesus. Ti m' tabehoots kän, tan'oo kän Judas Ikarijot hã, Simaw t'aah hã kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas gado däg sii hẽ m', Nesaa Do Yb bajëë suun ta h'yyb tym gó. Ti m' Judas hã Jesus ky hadoo: —Nayyw hẽ mamoo wäd mamoo wät doo kä —näng mä Jesus kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tii bä hat'oonh doo, dooh m' rah'yy genä bä tii d' Jesus bedoo do Judas hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sa dajẽẽr wë näng do ta ti Judas. Ti hyb n'aa Jesus mejõ hõm Pas-kowa waa n'aa hata hetsẽẽ, red'oo mäh. Kasuud is do sa hã dajẽẽr tanoo, ta wób red'oo mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ti m', pãw tagadoo do jawén paa bä, Judas bahõm kän. Badajuu däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas banyyh do jawén paa bä kä Jesus ky hadoo ta wób sa hã: —Kametä däg kän hỹỹ kä Aj'yy Hadoo Do Hỹ Pong jé Hana Do tak'ëp hadoo do ta kabaj'aa doo, tak'ëp raweh'ëëh doo. P'op Hagä Do tak'ëp ta kabaj'aa doo, raweh'ëëh doo, kametä däk Aj'yy Hadoo Do Hỹ Pong Jé Hana Do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","P'op Hagä Do tak'ëp ta kabaj'aa doo, raweh'ëëh doo, ta hyb n'aa kametä däg bä, Aj'yy Hadoo Do Hỹ Pong jé Hana Do tak'ëp ta kabaj'aa doo, raweh'ëëh doo, kametä däk da P'op Hagä Do an'oo bä. Nayyw hẽ ỹ P'op Hagä Do weh'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ti m' taky hadoo ẽnh: —Tah haa hedoo doo, dooh tabadawëd wäd bä bë mahang ỹ bawät doo. Bë esóts né paawä da ỹỹh, dooh bë haja nä bä bë ahõm bä ỹ hawät hẽnh. Tii d' né hẽ ti ỹ her'oot do paa Judah buuj sa wahë n'aa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Papuuj ky n'aa jawyk do bë hã ỹ mejũũ: Taw'ããts hẽ bë kamahä̃n ta wób. Taw'ããts hẽ bë ỹ kamahä̃n doo da bë kamahä̃n ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta wób bë kamahä̃n do hã, ma matëk ỹỹ bëëh, tii hã da sahõnh hẽ rabahapäh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ti m' Simaw Peed ky hadoo ta hã: —N'yy hẽnh mabahõm, Hyb N'aa Jawyk Doo? —näng mäh. Ti m' Jesus ky hadoo: —Dooh tahaja nä bä ỹ hahõm hẽnh mahõm bä nag'aap hẽ. Ta jawén da, jawén ỹ mabana kän —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ti m' Peed ky hadoo: —Hyb N'aa Jawyk Doo, —näng mäh —hëd n'aa tanahajaa nayyw hẽ ỹ ahõm bä a sii? —näng mäh. —Ỹ radajëëb bä a hyb n'aa, na madajëëb its ỹỹh. A hyb n'aa né hẽ ỹ kan'oo däk —näng mä Peed. ");
INSERT INTO mbjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Õm dajëp né da hëp ỹ n'aa? —näng mä Jesus. —Karaak bahỹỹh do pooj jé, tamawoob nuu me da ỹ maky n'aa jejën da. Né hup ỹ né hẽ ta ti ỹ her'oot doo —näng mä Jesus kyyh Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ti m' sahõnh hẽ ta ma matëg sa hã Jesus ky hadoo: —Bë hyb n'aa tón manäh. Taw'ããts hẽ bë h'yy kae had'yyt hẽ P'op Hagä Do hã. Hã ỹ na-ããj hẽ taw'ããts hẽ bë h'yy kae had'yyt hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hỹ pong jé, Ee tób bä, tabawät bä, ti anäng hajõng bë baym doo. T'ĩĩ hẽnh ỹ basëëk bë pooj jé, ỹ benäm hyb n'aa bë baym do hood. Tii d' tanado bä paawä ỹ her'oot paawä bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ỹ basëëk bë tyw n'aa ỹ benäm hyb n'aa. Tii bä ỹ matëëh da bë ỹ mahũũm hyb n'aa wë ỹỹ, ỹ bawät bä bë babok hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bë hapäh né hẽ ta tyw n'aa ỹ mahõm doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ti m' Toméh ky hadoo ta hã: —Hyb N'aa Jawyk Doo, —näng mäh —dooh ãã hapëë bä n'yy hẽnh mabahõm. Ti hyb n'aa nyy da ãã bahapäh ta ti ta tyw n'aa? —näng mä Toméh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ti m' Jesus ky hadoo: —Ỹ né hẽ ta tyw n'aa, ỹ né hẽ ta hub her'oot doo, ỹ né hẽ hanoo hedëb had'yyt do P'op Hagä Do pa. Jããm né hẽ hëp ỹ n'aa Ee wë ji nu däng. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Baad ub ỹ bë mepëë bä, bë mepäh na-ããj hẽ Ee. Sét né hẽ ããh. Hỹỹ kä bë mepëë däk, bë ty gepëë däk na-ããj hẽ Ee —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ti m' Pirip ky hadoo: —Mametä ãã hã a Yb. Jããm né ti ãã karẽn, Hyb N'aa Jawyk Doo —näng mä Pirip. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ti m' Jesus ky hadoo: —Bäp peej né paawä ỹ bawäd däk bë sii, dooh ỹ mamepëë nä bä, Pirip? —näng mäh. —Tahapëë däk do ỹỹh, Ee na-ããj hẽ tahapëë däk. H'ëëd hyb n'aa ti mabedoo, “Mametä ãã hã a Yb”, mabanäng? ");
INSERT INTO mbjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Dooh maky dahé bä? Ee h'yyb gó ỹ bawät, hëp ỹỹ gó Ee bawät. Bë hã ỹ her'ood wät doo, këh ỹ gabuuj had'yyt nado tii. Ee kyyh né hẽ tii. Ỹ moo wät doo, Ee, hëp ỹỹ gó had'yyt hawät doo, ti né hẽ moo wät tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taw'ããts hẽ bë ky daheeh, Ee h'yyb gó ỹ bawät, hëp ỹỹ gó Ee bawät, ỹ hanäng doo. Bë ky nadahé nä bä, taw'ããts hẽ bë ky daheeh ỹ pehuunh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Hã ỹ h'yy ka'eeh do tamoo wät da ỹ moo wät do paah. Ỹ moo wät do paa bahä̃nh da tamoo wät tii kä, Ee wë ỹ basëëk do hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sahõnh hẽ hät ỹỹ gó bë etsẽẽ do ỹ moo wät da bë hã, ỹ moo wät do hã Ee kawehëë däk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sahõnh hẽ hät ỹỹ gó hã ỹ bë ets'ẽẽ bä, ỹ ky daheeh né hẽ, ỹ anoo né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ti m' Jesus ky hadoo ẽnh: —Ỹ bë kamahä̃n bä, bë ky daheeh da ỹ mejũũ doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","—Ee hã ỹ etsẽẽ da, tii bä da bë hã taban'oo kän bë masa n'aa seeh, bë sii tabawäd had'yyt hyb n'aa. P'op Hagä Do Sahee, baad hadoo do ky n'aa metëëh do né tii. Badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do dooh rahaja bä ragado bä ta Sahee, ranahapäh do hyb n'aa, ramaa nanapäh do hyb n'aa na-ããj hẽ. Bë ti bë mepäh, bë sii tabawät do hyb n'aa, ta jawén kä bë h'yyb gó tabajëë suun kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Dooh bë ỹ eréd bä. Dooh da kabarii boo bë do bä. P'aa hẽnh da ỹ bana bë wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dooh tabadawëd nä bä, tii bä badäk hahỹỹ hã dawëë P'op Hagä Do mahä̃nh habong do dooh ỹ rahapëë wäd bä. Bë hapäh da ỹ tii. Ỹ awäd had'yyt do hyb n'aa, bë na-ããj hẽ bë aboo had'yyt hẽ da. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ỹ ganä wät noo gó, Sahé ỹỹ ỹ mejũũ noo gó, tii bä da bë bahapäh Ee h'yyb gó ỹ bawät. Hëp ỹỹ gó bë babok, bë h'yyb gó ỹ bawät bë bahapäh na-ããj né hẽ ti noo gó. Séd ër h'yyb hedoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Këh ỹ gadoo doo, ky daheeh doo, ti né hẽ ta ti hã ỹ kamahä̃n doo. Hã ỹ kamahä̃n doo, Ee kamahä̃n da. Ỹ na-ããj hẽ ỹ kamahä̃n tii. Ta hã ỹ banoo, tah'yy gahoot hyb n'aa hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ti m' Judas see (Ikarijot nadoo doo), ky hadoo ta hã: —Hyb N'aa Jawyk Doo, —näng mäh —h'ëëd hyb n'aa ãã hã had'yyt hẽ mabanoo a hã ji h'yy ganäng doo, ta wób sa hã dooh? —näng mä Judas see kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ti m' Jesus ky hadoo ta hã: —Hã ỹ kamahä̃n do ky daheeh né hẽ ỹ ma metëëk doo. Ee kamahä̃n ti ta tii. Ãã an'aa da ta wë. Ta h'yyb tym gó da ãã babok. Jããm hẽ hã ỹ kamahä̃n do hã ỹ banoo tah'yy ganäng hyb n'aa hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hã ỹ kamanahä̃n doo, dooh taky dahé bä ỹ ma metëëk doo. Ti hyb n'aa, dooh sa hã ỹ an'oo bä hã ỹ rah'yy genäh hyb n'aa. Këh ỹ nado ta ti bë maa newëë doo. Ee, hã ỹ mejũũ do kyy né tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ti m' Jesus ky hadoo ẽnh: —Ta ti bë ỹ maher'ood wät, babä bë sii ỹ bawät nä bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bë masa n'aa, P'op Hagä Do Sahee, këh ỹỹ gó Ee P'op Hagä Do mejũũ doo, ti né da bë tama metëëk sahõnh hã. Sahõnh hẽ bë hã ỹ her'ood wät do paah, bë hyb n'aa newëë tan'oo bä bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","H'yyb n'yym do ỹ banoo bë hã. Bë wë da tabaym. Ỹ anoo hëp ỹ näw bë hã. Badäk hahỹỹ hã habong do P'op Hagä Do nahapäh do ranoo do nahado tii. Bë h'yy ketón manäh. Bë eỹỹm manäh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ti m' taky hadoo ẽnh: —Bë maa napëë bok hahỹ bë hã ỹ her'ood wät doo: “Ỹ da ahõm, tii bä p'aa hẽnh ỹ bana bë wë”, näng ỹỹh. Ỹ bë kamahä̃n bä paawä, bë paawä tseb'ee Ee wë ỹ basëëk do hyb n'aa. Ỹ hyb n'aa jawyk do bahä̃nh Ee hyb n'aa jawyk. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ta pooj jé bë ỹ maher'ood wät, tametëëh bä kä bë h'yy ka'eeh hyb n'aa hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","P'eets däg Nesaa Do Yb, badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do hã mejũũ doo. Ti hyb n'aa, dooh tabadawëd wäd bä ỹ her'oot bë hã. Dooh Nesaa Do Yb haja bä hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Daj ỹỹ hẽ ỹ kan'oo däk dajëb hã, sahõnh hẽ hã ỹ Ee mejũũ do ỹ ky daheeh do hyb n'aa, Ee ỹ kamahä̃n do hyb n'aa. Taw'ããts hẽ sahõnh hẽ dawëë P'op Hagä Do mahä̃nh habong do rabahapäh ỹ ky daheeh Ee, ỹ kamahä̃n Ee. Ti m' Jesus ky hado kän: —Hamäh, ër ah'ũũm ta s'ee hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ti m' Jesus ky hadoo: —Joom uwa patuuh heh'äät hadoo ỹỹh. Ee, uwa danäh, ta hã moo wät doo. Uwa tyd hadoo hã ỹ h'yy ka'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uwa tyd, tyt ỹ hadoo do neaak do Ee gakyd hõm da. Uwa tyd, tyt ỹ heaak do baad taban'yyh. Ta poo gekyd hõm, baad tabeaak hyb n'aa ta bahä̃nh kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Baad däg bëëh. Tabenyyw däk bëëh, bë ỹ ma metëëk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ỹ karẽn séd hã bë h'yy kata däg had'yyt hã ỹỹ, tii bä ỹ h'yy kata däg had'yyt hẽ bë hã kä. Dooh uwa tyd haja bä ta m'aa hẽnh teag bä. Taw'ããts hẽ ta patuuh hã tadäg had'yyt hẽ. Ti hadoo bë hã. Dooh bë haja bä joom heaak do bë hado bä, dooh bë haja bä P'op Hagä Do gen'aak do bë moo boo bä, hã ỹ bë h'yy kanata bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Ỹ né hẽ uwa patuuh hadoo. Tyt ỹ hadoo bëëh. Hã ỹ had'yyt h'yy kata däk doo, ta hã ỹ h'yy kata däk doo, ti ti ta ti baad heaak do hadoo. Ta tii d' ỹ wén her'oot, dooh bë daaj hẽ bë hajaa péh. Hã ỹ bë nayyw bä, dooh bë hajaa péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hã ỹ h'yy kanata wät doo, uwa tyd kaw'oong hõm, tsawyy bëëh do hadoo da tii. Ti hedoo do rabataa, tëëg hõõ gó radewäts toonh, tii bä tabahõõ jëng. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hã ỹ had'yyt hẽ bë h'yy kata däg bä, ỹ ma met'ëëg wät do bë h'yyb gó tayyw bä, bë ky dahé bä, bë ky n'aa ets'ẽẽ bë karẽn do né hẽ, tii bä bë gadoo né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Baad bë beaak do hadoo do hã Ee kaweh'ëëh. Bë eaak do hadoo do hã bë kametëëh hëp ỹ hata hadoo bëëh. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","—Ee ỹ takamahä̃n doo da bë ỹ kamahä̃n. Taw'ããts hẽ ỹ kamahä̃n do bë h'yyb gó tabawäd had'yyt hẽ. Bë eréd manä tii hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bë hã ỹ mejũũ do bë ky dahé bä, ỹ kamahä̃n do awäd had'yyt da bë h'yyb tym gó. Dooh bë eréd bä tii bä. Bë gado had'yyt hẽ tii bä bë ỹ kamahä̃n doo. Taw'ããts hẽ ỹ bad'oo doo da bë bad'oo: Hã ỹ Ee mejũũ do ỹ ky daheeh. Ti hyb n'aa Ee kamahä̃n do awäd had'yyt hẽ hëp ỹ tym gó. Ti hyb n'aa, dooh ỹ eréd bä takamahä̃n do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ta ti bë hã ỹ her'ood wät, ỹ tsebé doo da bë tsebé hyb n'aa, baad bë tsebee had'yyt hẽ hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hahỹ ti ỹ mejũũ doo: Bë kamahä̃n bë da hadoo doo, bë ỹ kamahä̃n doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jããm né hẽ tak'ëp kamahä̃n doo, jé ta najiis sa hyb n'aa dajëp doo, ỹ bad'oo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Najis haa né hẽ bëëh, ỹ mejũũ do bë ky dahé bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dooh “karom ỹỹ” ỹ maneëëj wäd bëëh. Dooh sa karom rahapëë bä sa kariw n'aa h'yyb. “Najis haa” bë ỹ wén maneëënh, sahõnh hẽ hã ỹ Ee maher'oot do ỹ tabëj däk do hyb n'aa bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bë nado ti ỹ hasëëw wät doo. Ỹ ti hasëëw bong bëëh. Bë ỹ wén sëëw hõm, ỹ mejũũ joom heaak do hadoo bë bahadoo hyb n'aa. Joom ag kanarejãã do hadoo ti ỹ karẽn bë hã. Tii bä da sahõnh hẽ hät ỹỹ gó bë ky n'aa etsẽẽ doo, Ee anoo da bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bë ỹ mejũũ bë kamahä̃n bë da hadoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ti m' Jesus ky hadoo ẽnh: —Badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do bë wë rakamajẽ bä, bë hyb n'aa es'ee, pooj jé hã ỹ rakamajẽ bong. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do wób bë ado bä paawä, bë paawä rakamahä̃n, sa da hadoo do rakamahä̃n doo da. Dooh sa wób bë ado boo bä. Bë ỹ asëëw hõm sa mahä̃nh. Ti hyb n'aa bë hã rakamaj'ĩĩ. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bë hyb n'aa es'ee bë hã ỹ her'oot do paah. Dooh sa karom ta kariw n'aa bahä̃nh tanu gadäg bä, näng paa ỹ bë hã. Ta wób ỹ rano n'aa masoo paah. Bë na-ããj né da rano n'aa masoo né da. Ta wób, këh ỹ raky dahé wät paah. Bë na-ããj da raky daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hëp ỹ n'aa da bë rano n'aa masoo, hã ỹ mejõ hyng do ranahapäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ỹ nahyy bä paawä, sa hã ỹ naher'ood bä paawä, dooh P'op Hagä Do ky n'aa ety bä sa hã nesaa do sa mo haj'aa hyb n'aa. Hỹỹ kä, ỹ ahyy wät do hyb n'aa, panyyg hanäm do ỹ maher'ood wät do hyb n'aa sa hã, dooh da sa kyy pé sa hã P'op Hagä Do ky n'aa etyy noo gó. Sa h'yyb haj'aa hẽ tii d' rabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hã ỹ kamaj'ĩĩ doo, Ee hã na-ããj hẽ takamaj'ĩĩ. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sa mahang tak'ëp ỹ pehuuj wät. Dooh hajaa pé ta tii da pehuunh péh, ỹ pehuunh doo. Ta ti ỹ panehuuj bä paawä, dooh paawä P'op Hagä Do ky n'aa ety bä sa hã, nesaa do sa mo haj'aa hyb n'aa. Hỹỹ kä, rahapëë wät né hẽ ỹ pehuunh doo. Ti hadoo né hẽ hã ỹỹ, Ee hã na-ããj hẽ rakamajẽ bong. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ta tii da rawén d'oo, P'op Hagä Do kyy kerih do kametä däk hyb n'aa. Hahỹỹ da takerih: “Daap hẽ hã ỹỹ rakamajẽ däk”, näng mä kerih doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ti m' Jesus ky hadoo ẽnh: —Bë masa n'aa, P'op Hagä Do Sahee, baad hadoo do ky n'aa metëëh do kajaa bä kä, taher'oot da këh ỹ n'aa. Ee hanaa ỹ mejũũ da bë wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bë na-ããj hẽ ỹ karẽn bë her'ood hõm këh ỹ n'aa, pooj jé, ỹ du doo noo gó bë baboo had'yyt do hyb n'aa si ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Sahõnh hẽ ta ti bë hã ỹ wén her'oot, bë h'yy kanerét hyb n'aa hã ỹ bë h'yy ka'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bë da rahabëë nyyh tób P'op Hagä Do panyyg rayd naherot doo bä naa. Ta ti bahä̃nh da ti awät nä. Ti awät ti noo gó, P'op Hagä Do rah'yyb en'yym red'oo da bë radejëëb bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ta ti hedoo do ramoo bong da, Ee daheeh ỹ ranahapäh do hyb n'aa sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hahỹ ỹ wén her'ood wät bë hã, takametä wät bä kä, bë hyb n'aa esee hyb n'aa bë ỹ maher'ood wät do paah. Ỹ wén naher'oot nä paah, ỹ awät nä do hyb n'aa bë sii. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ti m' taky hadoo ẽnh: —Hỹỹ kä ỹ basëëk hã ỹ mejõ hyng do wë. Ti hado né paawä, dooh ỹ bë eaaj bä n'yy hẽnh ỹ bahõm. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bë h'yy ketón up ta ti bë hã ỹ her'ood wät do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Né hup ỹ né hẽ hahỹ bë ỹ maher'oot doo: Baad tanyy bë hã Ee wë ỹ basëëk. Ỹ nas'ëëg bä, dooh paawä bë masa n'aa, P'op Hagä Do Sahee ana bä bë wë. Ỹ basëëk bä kä ỹ mejõ hyng bë wë. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Takajaa bä kä, badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do hã baad tametëëh ta s'ee hẽnh rahyb n'aa newëë nesaa do ramoo bok do hã. Tametëëh da ta s'ee hẽnh rahyb n'aa newëë baad had'op do hã. Tametëëh da ta s'ee hẽnh rahyb n'aa newëë sa hã P'op Hagä Do ky n'aa etyy do hã sa mo haj'aa p'ãã. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ta s'ee hẽnh rahyb n'aa newëë nesaa do ramoo bok do hã, hã ỹ rah'yy kana'eeh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","P'op Hagä Do Sahee metëëh da sa hã, ta s'ee hẽnh rahyb n'aa newëë baad had'op do hã, Ee wë ỹ basëëk hyb n'aa, ỹ bë nahapäh hẽnh kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","P'op Hagä Do Sahee metëëh da ta s'ee hẽnh rahyb n'aa newëë sa hã P'op Hagä Do ky n'aa etyy do hã sa mo haj'aa p'ãã, Nesaa Do Yb, sa hã mejũũ do hã, P'op Hagä Do ky n'aa ety däg kän do hyb n'aa nesaa doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ti m' taky hadoo ẽnh: —Hajõng nä paawä ỹ her'oot bë hã, dooh bë haja nä bä bë gado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","P'op Hagä Do Sahee, baad hadoo do ky n'aa metëëh do kajaa bä kä, sahõnh hẽ baad hadoo do ky n'aa bë da tametëëk. Dooh ta ky gabuuj tado bä taher'oot doo. Hana ỹ naa tamaa napäh do bë d' tamaher'oot. Taher'oot na-ããj da ta jawén hana do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ỹ da tahyb n'aa jaw'yyk. Ỹ tawén hyb n'aa jaw'yyk, hana ỹỹ tagadoo, tatab'ëës hyb n'aa bë hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sahõnh hẽ Ee wë hanäng doo, ma ỹ had'yyt hẽ. Ti hyb n'aa P'op Hagä Do Sahee gadoo ma ỹỹ, bë hã tatab'ëës hyb n'aa, ỹ wén näng —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ti m' taky hadoo ẽnh: —Nayyw hẽ denaa hẽ, dooh da ỹ bë hapëë wäd bä kä. Nayyw hẽ denaa hẽ da, p'aa hẽnh ỹ bë bahapäh ẽnh —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ti m' ta ma matëg wób raky hadoo sa da hadoo do sa hã: —Nyy d' tahanäng pé tii éh, “Nayyw hẽ denaa hẽ m', dooh da ỹ bë hapëë wäd bä kä. Nayyw hẽ denaa hẽ da, p'aa hẽnh ỹ bë bahapäh ẽnh”, tahanäng doo? Nyy d' tahanäng péh, “Ee wë ỹ basëëk hyb n'aa”, tahanäng doo? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ti m' sa m'aa hẽnh rakaner'ood kän: —Nyy d' tahanäng pé g'eeh, “Nayyw hẽ denaa hẽ”, tahanäng doo? Dooh ãã h'yyb mepëë bä ti taher'oot do hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus hapäh rakarẽn reaanh ta hã. Ti m' taky hado kän: —Bë karẽn paawä bë eaanh ta ti ỹ her'oot do hã? Hahỹỹ da paawä bë kyy bë h'yyb gó: “Nyy d' tahanäng pé tii éh, ‘Nayyw denaa hẽ dooh da ỹ bë hapëë wäd bä kä. Nayyw hẽ denaa hẽ da p'aa hẽnh ỹ bë bahapäh ẽnh’, tahanäng doo”, näk bë kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Bë da a'oot, bë da h'yy ketón. Badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do tseb'ee da ti noo gó kä. Bë h'yy ketón né paawä da, bë h'yy katón do kawareem da tsebé do hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ỹỹnh wog mahỹỹnh ajãn henäng doo kä, kajaa do hyb n'aa ti noo gó tabenäng doo. Ta t'aah henäng do jawén paa bä kä, tamabaan hõm tak'ëp ta mahỹỹj tahoop do paah, tak'ëp tatsebé do hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ti hadoo né da bë hã: Hỹỹ kä bë d' h'yy ketón. Ỹ bë bahapäh bä p'aa hẽnh kä, tii bä bë tsebee kän. Dooh hado hõm pé ta ti bë tsebé doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti noo gó kä, dooh hã ỹ bë ets'ẽẽ wät péh. Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Ee, P'op Hagä Do banoo da bë hã sahõnh hẽ hät ỹỹ gó bë etsẽẽ doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dooh bë etsẽẽ nä pé hät ỹỹ gó. Bë ets'ẽẽ da. Bë gadoo né hẽ da, tii bä baad da bë tsebee kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ti m' taky hadoo ẽnh: —Panyyg ky n'aa gó bë ỹ maher'ood bong paah. Ti awät da ti noo gó, dooh da bë ỹ maher'ood wäd bä ta tii da. Baad ub, kejën do hadoo nado da bë ỹ maher'ood kän Ee ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti noo gó bë etsẽẽ da hät ỹỹ gó. Dooh hyb n'aa da bë ỹ ky masa pé ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta daaj hẽ bë Ee kamahä̃n. Ti hyb n'aa, dooh hyb n'aa bë ỹ ky masa péh, ỹ wén näng. Bë Ee wén kamahä̃n, ỹ bë kamahä̃n do hyb n'aa, P'op Hagä Do hanaa ỹ bahyng bë ky daheeh do hyb n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ee, P'op Hagä Do wë naa ỹ bahyng badäk hahỹỹ bä. Badäk hahỹỹ hã ỹ bawäd wät. Hỹỹ kä ỹ beréd däk badäk hahỹỹh. Ee wë ỹ basëëk p'aa hẽnh —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ti m' Jesus ma matëg raky hadoo: —Baad hỹỹ kä mabaher'ood wät. Panyyg gó nado wäd. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sahõnh hẽ mabahapäh, ãã hapäh hỹỹ kä. Ji eaanh do pooj jé mabahapëë däk ji karẽn do ji eaanh doo. P'op Hagä Do hanaa õm tii hã ãã bahapäh, ãã wén ky daheeh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ti m' Jesus ky hadoo sa hã: —Bë ky dahé däg né hỹỹ kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ti awät da ti noo gó, kaja kän, bë waj'aa bong doo kä bë tób hẽnh. Map ỹỹ hẽ da ỹ bë beréd wät. Tii d' né paawä, map ỹỹ hẽ nawäd ỹỹh. Ee si ỹ awät. ");
INSERT INTO mbjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ta ti P'op Hagä Do Sahee ky n'aa bë ỹ wén maher'ood wät, h'yyb nyyw gó bë babok hyb n'aa, si ỹỹ séd bë h'yyb hedoo do hyb n'aa. Badäk hahỹỹ hã bë ahoop né da nesaa doo. Ti hado né paawä, bë h'yy gadeja da, badäk hahỹỹ hã habong do P'op Hagä Do hã h'yy kana'eeh do hã ỹ j'aa ketsë do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ti m' Jesus bahajaa bä kä ta ti taher'oot doo, wë hã taty däg, ti m' P'op Hagä Do hã taky n'aa ets'ẽẽ kän: —Ee, —näng mäh —kaja kän ỹ dajëp doo kä sahõnh hẽ sa hyb n'aa. Mametä a T'aah tak'ëp ta makamabaj'aa doo. Ỹ mawehëë, õm a T'aah weh'ëëh hyb n'aa, makabaj'aa do tametëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hã ỹ maban'oo däk sahõnh hẽ badäk hahỹỹ hã habong do ỹ bag'ããs hyb n'aa, ỹ bedëëb had'yyt hẽ hyb n'aa a wë, hã ỹ manoo doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hahỹ hedëb had'yyt hadoo do rawén gadoo: Õm, jããm hẽ sét had'op doo, P'op Hagä Do heh'äät do rabahapäh do hyb n'aa. Jesus Kristo, mamejõ hyng do rabahapäh do hyb n'aa na-ããj né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ỹ haja däk sahõnh hẽ hã ỹ mamejũũ doo. Tii hã õm ỹ wehëë däk badäk hahỹỹ bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hỹỹ kä Ee, man'oo tak'ëp ỹ kabaj'aa hyb n'aa a matym gó, p'ooj ub, badäk hahỹ madu dahäng do pooj jé, a pa ỹ bawät noo gó, ỹ kabaj'aa doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","A ky n'aa ỹ metä wät badäk hahỹỹ hã habong do wób hã, hã ỹ manoo do sa hã. A karapee paa tii, ti man'oo däk do hã ỹỹ. A ky n'aa raky dahé däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sahõnh hẽ hã ỹ man'oo däk doo, a hanaa né ti rabahapëë däk hỹỹ kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ti rawén hapäh, sa hã ỹ tab'ëës do hyb n'aa a kyyh hã ỹ manoo do paah, ti ragadoo. Baad rabahapäh, a wë naa né hẽ ỹỹh. Õm né hẽ ỹ mejõ hyng doo, raky daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A hã ỹ ky n'aa etsẽẽ sa hyb n'aa. Dooh ỹ ky n'aa ets'ẽẽ bä badäk hahỹỹ hã dawëë a mahä̃nh habong do sa hyb n'aa. Hã ỹ manoo do sa hyb n'aa ỹ ky n'aa etsẽẽ, a karapee rabahadoo do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sahõnh hẽ karapé haa, a karapee né tii. A karapee, karapé haa. Sa hyb n'aa ỹ kawehëë däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dooh da badäk hahỹỹ bä ỹ ayyw wäd bä, a wë da ỹ bas'ëëg kän. Ti d' hayyw kän badäk hahỹỹ bä. Ti hyb n'aa, Ee, tsyt hẽ hawät do õm nesaa do mahä̃nh, mamo n'aa jesu da a hejój me, hã ỹ manoo doo me né hẽ, séd hã rah'yyb hedoo hyb n'aa, séd hã ër h'yyb hedoo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sa mahang ỹ hawät noo gó, ỹ mo n'aa jesu bong a hejój me, hã ỹ manoo doo me. Dooh h'yy kawareem pé nesaa do hã. Jããm hẽ sét hẽ nesaa do hã h'yy kawareem. Karejãã do pan'aa né tii. Ti tawén hadoo, a kyy kerih do kametëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hỹỹ kä da, dooh sa mahang ỹ awäd wät bä kä. A wë da ỹ bas'ëëg kän. Badäk hahỹỹ bä ỹ bawät nä bä ỹ her'oot nä ta tii, ỹ tsebé do baad sa h'yyb gó tabawät hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ỹ an'oo däk sa hã a kyyh. Badäk hahỹỹ hã habong do a hã h'yy kana'eeh do kamajẽ däk sa hã, sa wób ranahado bong do hyb n'aa, sa see ỹ nahadoo do hadoo né tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dooh ỹ ets'ẽẽ bä mabasog hõm hyb n'aa badäk hahỹỹ bä habong do sa mahä̃nh. Jããm né hẽ ỹ etsẽẽ a hã, mamo n'aa jesuu hyb n'aa Nesaa Do Yb mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Badäk hahỹỹ hã habong do a hã h'yy kana'eeh do wób nado tii, ta ti see ỹ nahadoo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tsyt hẽ mabetyn däk hanäm do ky n'aa me, magen'aak do ramoo bok hyb n'aa. A kyyh né hẽ ti hanäm do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Badäk hahỹỹ bä mamejõ hyng doo da ỹỹh, tii da ỹ mejũũ sa hã badäk hahỹỹ hã habong do sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sa hyb n'aa ỹ kan'oo däk, tsyt hẽ magen'aak do ỹ moo wät hyb n'aa, ta ti na-ããj hẽ baad tsyt hẽ magen'aak do ramoo bok hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sa hyb n'aa had'yyt nado ỹ ky n'aa etsẽẽ. Ỹ ky n'aa etsẽẽ na-ããj né hẽ ta jawén hã ỹ h'yy ka'eeh do sa hyb n'aa, hahỹ sa kyyh hyb n'aa h'yy ka'eeh do sa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ỹ ky n'aa etsẽẽ sahõnh hẽ hã ỹ h'yy ka'eeh doo, séd hã rah'yyb hedoo hyb n'aa, séd hã ër h'yyb hedoo doo da. Hëp ỹỹ gó mabawät, a h'yyb gó ỹ bawät doo da. Ỹ karẽn séd hã rah'yy kata däk ër hã, badäk hahỹỹ hã habong do rabahapäh hyb n'aa õm né hẽ hã ỹ mejõ hyng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tak'ëp baad hadoo do hã ỹ man'oo däk do paa ỹ an'oo däk né sa hã, séd hã rah'yyb hedoo hyb n'aa, séd hã ër h'yyb hedoo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sa h'yyb gó ỹ bawät. Hëp ỹỹ gó mabawät. Ỹ karẽn baad ub, séd hã rah'yyb hedoo, ỹ mamejõ hyng ta wób rabahapäh hyb n'aa, hã ỹ h'yy ka'eeh do hã makamahä̃n ỹ makamahä̃n do hadoo, ta wób rabahapäh hyb n'aa —näng mä Jesus taky n'aa etsẽẽ bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ti m' taky hado kän ta yb hã: —Ee, —näng mäh —ỹ karẽn ỹ bawät bä rababok hã ỹ manoo doo. Ỹ karẽn rabahapäh ỹ kabaj'aa doo, bak ỹ tak'ëp gabarëëh doo, badäk hahỹ madu dahäng noo gó pooj jé, ỹ makamahä̃n do hyb n'aa hã ỹ man'oo däk do paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ee, baad had'op do had'yyt moo wät do õm. Badäk hahỹỹ hã dawëë a mahä̃nh habong doo, dooh né paawä õm rahapëë bä sa h'yyb gó, ỹ ti hapäh õm. B'ëëh hahỹ rahapäh ỹ mamejõ hyng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A ky n'aa ỹ metä wät sa hã. A ky n'aa ỹ metä had'yyt hẽ da sa hã, ỹ makamahä̃n do sa h'yyb gó tabawät hyb n'aa, ỹ na-ããj hẽ sa h'yyb gó ỹ bawät hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ti m', Jesus bahajaa bä kä taky n'aa etsẽẽ doo, ahõm kän mä ta ma matëg sa daheeh. Kapỹỹj madarong doo, Kidorõn häd näng do rabatsëg hõm. Tii bä tabanäng joom Oriib häd näng doo. Tii bä, joom banäng bä Jesus baym. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jesus haëëj däk do tahapäh mä Jesus bahe'yym doo. Hajõõ nuu me ta tii bä Jesus bahew'ëët ta ma matëg sa daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ti m' Judas bahõm kän joom banäng bä. Warahén, ta wób P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa ramejũũ doo, Pariséw ramejũũ do na-ããj hẽ tamanaa. Bag enäh rabana. Kuman yt hã m' rabana. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus hapäh ta h'yyb gó sahõnh hẽ ta hã rabad'oo doo. Ti hyb n'aa m' sa wë tabahõm, ti m' tabeaaj kän: —Jaa no n'aa bë ban'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ti m' raky hadoo: —Jesus, Nasaréh buuj no n'aa —näk mä sa kyyh. —Ỹ né hỹỹh —näng mä Jesus sa hã. (Sa mahang Judas, ky ken'yym doo gó haëëj däk do bagëët.) ");
INSERT INTO mbjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ỹ né hỹỹh” Jesus her'ood sii hẽ, sa jawén p'aa hẽnh rakajäk tũũ. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ti m' Jesus beaanh ẽnh p'aa hẽnh: —Jaa no n'aa bë ban'aa? —näng mäh. —Jesus, Nasaréh buuj no n'aa —näk mäh p'aa hẽnh sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ti m' Jesus ky hadoo: —Ỹ né hỹỹh, ỹ hanäng do bë hã —näng mäh. —No na ỹ tado bä, bë an'oo hata haa rabahõm hyb n'aa —näng mä Jesus sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ta tii d' Jesus wén edoo, “Dooh h'yy kawareem pé nesaa do hã”, ta yb hã taher'ood wät do paa kametëëh hyb n'aa.) ");
INSERT INTO mbjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ti m' Simaw, Peed häd näng do bado däk ta sẽn-jeer, ta nabuuj hub hẽnh hadäk do tagakyd hõm mä aj'yy Maw-Kó häd näng doo. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom tii. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ti m' Jesus ky hadoo Peed hã: —Menyyw däg a sẽn-jeer. Dooh g'eeh ỹ gado bä ỹ ahoop doo, Ee anoo doo? —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ti m' warahén sa wahë n'aa, ta warahén n'aa, P'op Hagä Do tób n'aa hagã n'aa sii hẽ ramaso däk Jesus. Ramoo maw'yyd däg kän, ");
INSERT INTO mbjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tii bä pooj jé ramahũũm aj'yy Anas häd näng do wë. Kajapas mayb ti Anas. Ti noo gó P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do ti Kajapas. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ta ti Kajapas né hẽ ta ti her'oot do paa Judah buuj sa wahë n'aa sa hã, “Taw'ããts hẽ sét hẽ dajëp sahõnh sa hẽ hyb n'aa”, hanäng doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simaw, Peed häd näng doo, Jesus ma matëg see sii tabahõm warahén sa jawén. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do hep'ëëh do ta ti ta ma metëëk do seeh. Ti hyb n'aa rabanoo tabajëë suun tób wahoo gó, kahadë doo gó, Jesus ramajë sun doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peed gada ta noo bä. Jesus ma matëg seeh, tób danäh hep'ëëh doo, anyyh p'aa hẽnh maruus ta noo hagã n'aa wë tabetsẽẽ hyb n'aa Peed bajëë suun hyb n'aa. Ti m' tamajë sun kän Peed. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ti m' maruus, ta hadë noo hagã n'aa ky hadoo Peed hã: —Nanäng aj'yy ma matëg see nado õm? —näng mäh. Ti m' Peed ky hadoo: —Dooh ta ma matëg see ỹ do bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tak'ëp tabahahëëm ti atsëm. Ti hyb n'aa tób danäh karom, P'op Hagä Do tób n'aa hagã n'aa sii hẽ ragahõ sooh tëëg sëh. Tëëg noo pa rabab'ëëh rakatëng hyb n'aa. Peed agëët katëng sa pa. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti nuuj jé m', tób gó, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do eaanh mä Jesus ta ma matëg ky n'aa, tametëëk do ky n'aa na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ti m' Jesus ky hadoo: —Sahõnh hẽ ramaa napëë had'yyt hẽ ỹ her'ood wät doo —näng mäh. —Tób P'op Hagä Do panyyg rayd naherot do yt hẽ, P'op Hagä Do tób n'aa yt hẽ na-ããj hẽ ỹ ma met'ëëg wät paah. Dooh kejën gó ỹ her'ood bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","—Hëd n'aa hã ỹ bë beaanh? Bë eaaj këh ỹ maa new'ëë do sa hã. Ta ti rahapäh ỹ her'ood wät doo —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ta tii d' Jesus baher'oot do hyb n'aa, P'op Hagä Do tób n'aa hagã n'aa see Jesus ta tapa ewyh wät, ti taky hadoo: —Tii da ji kyyh P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ti m' Jesus ky hadoo ta hã: —Mametä nesaa do ky n'aa ỹ her'ood bä. Baad hadoo do ỹ her'oot do p'ãã ỹ matapa ewyyh? —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti m' Anas mejũũ mä ramahũũm Jesus, Kajapas, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do wë. Moo kamewyyt nä m' Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti m' tëëg noo pa Peed katëng bä, rabeaaj kän mä ta hã: —Ta ma matëg see nado õm? —näk mäh. Ti m' Peed ky n'aa jejën: —Dooh. Ta ma matëg see nado ỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do karom seeh, Peed nabuuj gakyd hõm do wakããn ky hadoo: —Õm nado ta ti ỹ hapäh do ta sii, joom mahang? —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ti m' p'aa hẽnh Peed ky n'aa jejën ẽnh. Tii bä karaak ky ganä kän, tabah'ỹỹ kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ti m', Kajapas tób bä naa ramahũũm kän Jesus aj'yy Roma buuj Judah häj n'aa bagã n'aa tób hẽnh, Pirato häd näng do wë. Jati pé bäp paa m' tii. Judah buuj wahë n'aa Jesus man'aa doo, dooh rajëë pä bä Roma buuj tób gó. Rakarẽn mä baad ratayy rabawëh nä do hyb n'aa Pas-kowa tä n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ti hyb n'aa Pirato banyyh sa wë, ti m' taky hadoo: —H'ëëd p'ãã bë ky n'aa tapaa hahỹ aj'yy? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ti m' raky hadoo: —Moo nesaa do tanado bä, dooh paawä ãã haëëj bä a hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ti m' Pirato ky hadoo: —Bë né hẽ ky n'aa etyy ta hã bë ky n'aa jaw'yyk do banoo doo da —näng mäh. —Dooh ãã haja bä ãã dajëëb bä. Dooh Roma buuj ky n'aa jaw'yyk do an'oo bä —näk mä sa kyyh Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tii d' tawén hado kän, nyy d' tadajëp Jesus her'ood wät do paa kametä wät hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","P'aa hẽnh Pirato bajëë suun tób gó, Jesus tanaëënh mä ta wë, teaaj kän: —Õm Judah buuj sa wahë n'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ti m' Jesus ky hadoo: —A ky gabuuj hẽ ti meaanh? Õm ta wób ramaher'oot do këh ỹ n'aa hyb n'aa mabeaanh? —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ti m' Pirato ky hadoo: —Judah buuj nado ỹ hỹỹh —näng mäh. —A wakããn, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa ti õm haëënh hã ỹỹ. H'ëëd p'ãã? —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ti m' Jesus ky hadoo: —Badäk hahỹỹ bä nado ỹ bag'ããs doo. Badäk hahỹỹ bä tado bä paawä, karapé haa ỹ ramo n'aa jesu paawä Judah buuj sa wahë n'aa sa mahä̃nh. Badäk hahỹỹ bä nado ỹ bag'ããs doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ti m' Pirato ky hadoo: —Tii d' tado bä, õm né hẽ häj n'aa wahë n'aa? —teaanh mäh. Ti m' Jesus ky hadoo: —Ehub né hẽ õm tii d' hanäng. Baad hadoo doo, heh'äät do ky n'aa ỹ her'oot hyb n'aa ỹ benäng, ti hyb n'aa né hẽ ỹ bahyng badäk hahỹỹ bä. Baad hadoo do ky n'aa gen'aak do ky daheeh ỹ her'oot doo —näng mä Jesus Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ti m' Pirato ky hadoo: —H'ëëd ti baad hadoo do mahanäng? —näng mäh. Ti m' nayyw hẽ Pirato banyyh Judah buuj sa wë. Ti m' taky hadoo sa hã: —Dooh ỹ aw'yyt pé ta hã ky n'aa ketyy doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","—Pas-kowa bë teheb'ëës do hã bë mehejõ ỹ bado nyyh ỹ dawäts gëët do seeh. Bë karẽn ỹ ado nyyh bë matym n'aa Judah buuj wahë n'aa ramaneëënh doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ti m' raky hadoo, tak'ëp mä rageëënh: —Ta ti nado ãã karẽn! —näk mäh. —Barabas häd näng do ti ãã karẽn! —näk mäh. Roma buuj wë h'yy kawereem do see paa ti Barabas. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ti m' Pirato mejũũ Jesus rabahewyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ti m' hetëk do moo m' warahén ramap'õõd däk, ta nuu gó m' radaso kän. Ti m' radasuun jëng ta hã ta hatsë hahiin doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ti m' hajõõ nuu me m' rabena ta wë raky n'aa ej'ees hyb n'aa. Hahỹỹ d' mä sa kyyh: —Kaweh'ëëh Judah buuj sa wahë n'aa! —näk mäh. Ti m' ratapa ewyyh hajõõ nuu me. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ti m' p'aa hẽnh Pirato ber'oot Judah buuj sa sii: —Ỹ manyyh da hỹỹ kä bë wë ta w'oo hã, dooh ỹ aw'yyt pé ta hã ky n'aa ketyy do hã bë bahapäh hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ti m' ta nu gaheen n'aa hetëk do mooh, ta hatsë hahiin doo gó tabanyyh bä, Pirato ky hadoo sa hã: —Bë hegãã! Gëët hahỹ aj'yy —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, P'op Hagä Do tób n'aa hagã n'aa Jesus rabahapäh bä, nayyw hẽ rageëëj bong: —Mepëëm däg, mepëëm däg! —näk mäh. Ti m' Pirato ky hadoo: —Bë né hẽ hepëëm däk. Ỹ ti dooh ỹ aw'yyt pé ta hã ky n'aa ketyy do hã —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ti m' Judah buuj wahë n'aa raky kah'ũũm ta hã: —Ãã ky n'aa jaw'yyk do ky n'aa hyb n'aa taw'ããts hẽ tadajëp né hẽ, P'op Hagä Do T'aah tabanäng do hyb n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pirato maa newë däk bä tii da, tak'ëp mä tabeyym tii bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ti m' p'aa hẽnh tabajëë suun tób gó, ti m' Jesus hã tabeaanh: —N'yy hẽnh naa õm? —näng mäh. Jesus kawanaj'ããn né paawä, dooh m' taky gado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ti m' Pirato ky hadoo ta hã: —Dooh maky gado bä? Mahapäh né hẽ, ỹ hajaa ỹ mejõ bä õm raberéd hõm hyb n'aa, ỹ hajaa na-ããj hẽ ỹ mejõ bä õm rabepëëm däk —näng mä Pirato. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ti m' Jesus ky hadoo ta hã: —Dooh paawä mahaja bä hã ỹỹ, P'op Hagä Do nan'oo bä. Ti hyb n'aa, ỹ haëëj däk do sa hã, a hã hanäng do nesaa do bahä̃nh sa hã —näng mä Jesus Pirato hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti m' ta ti Pirato maa newë däk bä takarẽn paawä taberéd hõm Jesus. Tak'ëp mä Judah buuj rageëëj had'yyt hẽ tii bä: —Ta ti aj'yy meréd hõm bä, dooh Sesa, sahõnh hẽ bä wahë n'aa h'yyb hata mado bä. Häj n'aa wahë n'aa hanäng doo, Sesa tahyb n'aa wareem —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ti m' Pirato maa napäh bä m' ta tii, tamanyyh Jesus, ahyy sooh mä ji ky n'aa etyy n'aa tyng jó. Pä ta yt ta tii bä. (Eberew kyy me ramaneëënh ta ti Gabatah.) ");
INSERT INTO mbjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pas-kowa rataheb'ëës do pooj jé noo gó m' tii. Wasyk mäh. Ti m' Pirato ky hadoo Judah buuj sa hã: —Gëët hahỹ bë wahë n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ti m' raky hadoo tak'ëp: —Mado hõm, mado hõm, mepëëm däg! —näk mäh. —Bë wahë n'aa ỹ epëëm däk g'eeh? —näng mä Pirato. Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa raky hadoo: —Jããm né hẽ sét hẽ ãã wahë n'aa, Sesa! —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ti m' tagadëëg ub kä, Jesus Pirato bahaëëj däg kän sa hã takepëëm däk hyb n'aa. Ti m' warahén sa hã kä takahaëëj däk Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ta daaj hẽ Jesus besoo hõm b'aa rahepëëm däk do pan'aa ta hã. Ji Nu Gabóg K'yy ramaneëënh doo hẽnh ramahũũm. (Eberew kyy me ramaneëënh ta tii bä Gogota.) ");
INSERT INTO mbjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tii bä rabepëëm däk b'aa kajatsëk do hã kä. B'aa kajatsëk do wób hã rabepëëm däk na-ããj hẽ pawóp hẽ ajyy. Hub hẽnh ta see hahäng, s'ỹỹ hẽnh ta see hahäng. Hõõ gó Jesus kahepëëm däk do bahäng. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pirato kyy gó raberii bong ta heen n'aa, ti m' p'op, Jesus nu gad'oo pong jé, rabepëëm däk. Hahỹỹ da m' takerih ta hã: “Jesus, Nasaréh buuj, Judah buuj wahë n'aa hahỹỹh.” ");
INSERT INTO mbjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Edah tii, Jerusarẽnh bä naa. Ti hyb n'aa hajõk ner'ood bong kerih doo. Tamawoob hẽ kyyh takamerih doo: Eberew kyy me, Ratĩn kyy me, Gereg kyy me. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa rabahõm kän Pirato wë, ti m' raky hadoo: —Merii manäh: “Judah buuj sa wahë n'aa”, hanäng doo da. Taw'ããts hẽ merii: “Ta daaj hẽ Judah buuj sa wahë n'aa tabanäng hahỹ aj'yy” —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ti m' Pirato ky hadoo: —Taw'ããts hẽ ỹ erii wät doo. Dooh ỹ ahỹỹd wäd bä —näng mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ti m' Jesus warahén rabepëëm däk do jawén paa bä m', rabasog hõm ta saroor. Retyn hõm ji meheet pé hadoo do sa hã. Sét hẽ, ta hatsë, mad'aak kanasuuh doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ti m' raky hadoo: —Dooh ër as'ẽẽd bä hahỹỹh. Hamäh, masuuj ër moo bong ër bahapäh hyb n'aa jaa wë tabaym —näk mä sa kyyh. Ti tawén hadoo, P'op Hagä Do kyy kerih do kametëëh hyb n'aa. Hahỹỹ da takerih ta ti ky n'aa: “Rabetyn hõm sa hã hẽ saror ỹỹ. Masuuj ramoo bong saror ỹ hyb n'aa.” Tii da né hẽ warahén ramoo boo kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","B'aa kajatsëk do Jesus hadäk do dewë hã, ti ab'ëëh ta ỹỹn, ta kaat, Keropas häd näng do ỹỹm Marija häd näng doo, Marija Madarẽn häd näng do daheeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ti m' Jesus bahapäh bä ta ỹỹn, ta ma matëg seeh, tak'ëp takamahä̃n do rabab'ëëh bä, Jesus ky hadoo ta ỹỹn hã: —Gëët ta ti a t'aah —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ti m' ta ma matëg hã m' taky hadoo: —Gëët ti a ỹỹn —näng mä Jesus ta ỹỹn ky n'aa hã. Tii bä kä, ta ti tagado kän Jesus ỹỹn ta tób bä kä, tabahag'ããs hyb n'aa kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ta jawén kä, sahõnh hẽ tabahaja däk bä kä tamoo wät do paah, P'op Hagä Do kyy kerih do kametëëh hyb n'aa kä taky hado kän: “Ỹ hoo kaanh”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ti asooh tii bä uwa s'ëëb oow. Ti m' raheh'oos sapum doo, Jesus hã rabanoo hyb n'aa. B'aa isop häd näng do hã radadäk, ti rabanoo p'op, Jesus beëëk hyb n'aa ta naëng hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus beëëk do jawén paa bä, taky hadoo: —Jããm né kä ỹ moo wät doo —näng mäh. Ti m' ta nu wakoo däg kän, ti m' h'yy keréd hõm mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Saab pooj jé m' ti ta tii. Saab pooj jé né hẽ m' ta ti Judah buuj rabahenyyw hõm Saab hã rakamehehãk hyb n'aa. Tak'ëp ratayy ti noo gó, Pas-kowa noo gó tabadoo do hyb n'aa. Dooh Judah buuj rakarẽn bä Saab hã rapadäg nä bä kepëëm padëëk doo. Ti hyb n'aa rabetsẽẽ Pirato hã tamejũũ hyb n'aa warahén ragetëh bong hyb n'aa sa tsyym k'yy, nayyw hẽ radejëp hyb n'aa. Rabetsẽẽ rasog hyk hyb n'aa sa kamag Saab du doo do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ti m' Pirato mejũũ warahén sa tsyym k'yy ragetëh bong hyb n'aa. Ti m' Jesus pa hadäk do ragetëh bong ta tsyym k'yy, ta jawén mä ta see tsyym k'yy. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesus tsyym k'yy ragetëh paawä, tii bä rabahapäh Jesus dajëp. Dooh Jesus ratsyym k'yy getëh boo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ti warahén bejóh kän ta baa bä. Ti m' majyyw banyyh naëng mahang. Dajëp né kä m'. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aj'yy ta ti hapäh doo, baad tabaher'oot ta ti ky n'aa. Dooh daap tamenä bä. Ta ti aj'yy hapäh né hẽ, te hub né hẽ taher'oot doo. Ta ti tawén erii wät hahỹỹ hã, bë na-ããj bë ky daheeh hyb n'aa, bë h'yy ka'eeh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jesus tsyym wén ganetëëh, P'op Hagä Do kyy kerih doo gó kerih do kametëëh hyb n'aa. Hahỹỹ d' paa m' takerih ta ky n'aa: “Dooh da ta k'yy gatëh is péh.” ");
INSERT INTO mbjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rawén baa ejooh, hahỹ kerih do paa kametëëh hyb n'aa: “Raheg'ããs da rabaa ejooh do wë.” ");
INSERT INTO mbjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tii bä kä, Jesus kamag n'aa paa Joséh, panang Arimatsija häd näng do buuj hadoo doo, bets'ẽẽ kän Pirato hã. Jesus h'yyb hata ta ti Joséh. Dooh tametä bä ta h'yyb, ta hã tah'yy ka'eeh doo, tajeỹỹm do hyb n'aa Judah buuj sa wahë n'aa wób. Ti m' Pirato bahaëëj däk ta hã. Ti m' Joséh bana, tado hyy kän mä Jesus kamag n'aa paah. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodẽm Joséh hata. Nikodẽm né hẽ tii, p'ooj ub Jesus heg'ããs do atsëm. Nikodẽm manaa mä 35 m' ta nu jawyg b'aa s'ëëb buu benyym doo. Aroé ramaneëënh do s'ëëb, miir ramaneëënh do s'ëëb ta ti buu benyym. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ti m' Jesus kamag n'aa paa rahabën däk pããn me, hawak doo me, rino häd näng do s'ëëb. Buu benyym mä ta hã. Judah buuj rabahed'oo doo da né hẽ rabad'oo Jesus kamag n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesus rabepëëm däk doo bä ti anäng joom. Ti mahang tagadäk papuuj kamag hood, pä gó ragagots däk doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Saab pooj jé, Judah buuj rabahenyyw hõm noo gó tado hyb n'aa, p'eets hẽ ta ti kamag n'aa hood tagadäk do hyb n'aa na-ããj hẽ, tii b' né radasuun jëë kän Jesus kamag n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ti m' bäp paah, met'uuh hã, badajung nä, Marija Madarẽn häd näng do bahõm kän pä gabaho doo hẽnh, Jesus kamag n'aa radasuun jëng hẽnh. Taheg'ããs mäh, noo gasëëts hõm gabaho do ty gatsë. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ti m' tawaj'aa jëng Peed, Jesus ma matëg baad Jesus kamahä̃n do daheeh rabab'ëëh hẽnh. Ti m' taky hadoo pawóp hadoo do sa hã: —Rado nyyh Tak'ëp Hyb N'aa Jawyk Do kamag n'aa. Dooh ãã hapëë bä n'yy hẽnh ramahũũm —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ti m' Peed, Jesus ma matëg see daheeh ah'ũũm mä Jesus kamag n'aa hood gadäk hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Waj'aa h'ũũm. Tak'ëp Jesus ma matëg see wajaah ta pooj jé. Peed pooj jé takajaa. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ta noo bä takajaa bä, dooh tajëë suun bä. Nu hyy däk, tabaheg'ããs ta gó. Tahapäh pããn hewak doo, rino häd näng do s'ëëb. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ti m' Peed, duu hẽnh hana do kaja nä. Gabaho doo gó tabajëë suun. Pããn hewak doo, Jesus kamag n'aa ramahabën däk do paah, tahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pããn hawak doo, ta mamets jesuu n'aa paah, tahapäh na-ããj hẽ. Ti asooh tsyt hẽ, baad takamatëh däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tii bä m' Jesus ma matëg seeh, pooj jé kajaa doo, bajëë suun kän. Ta ti tabahapäh bä kä, Jesus ganä wät do taky dahé kän. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Dooh tagah'ood nä bä sa hã P'op Hagä Do kyy kerih doo gó taher'oot doo, Jesus ganä wät da hanäng doo.) ");
INSERT INTO mbjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ti m' rabajëk sa tób hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Marija Madarẽn baym kamag hood paa noo bä. Aoot mäh. Ta ód gó tanu hyy däk gabaho doo gó tageg'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tii bä m' pawóp hẽ ããs tabahapäh. Hewak mä sa saroor. At'oonh mä Jesus kamag n'aa basooh do paa bä m'. Ta nuu hẽnh tabanäng hẽnh mä ta seeh, ta tsyym tabanäng hẽnh ta seeh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ti m' ããs rabeaanh ta hã: —H'ëëd p'ãã mabaoot? —näk mäh. Ti m' taky hadoo: —Rado hõm wahë ỹ n'aa. Dooh ỹ hapëë bä n'yy hẽnh rahed'oo —näng mä Marija Madarẽn. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ti m' ta jawén p'aa hẽnh tabegãã wät. Taheg'ããs mä Jesus tii bä hagëët. Dooh m' tah'yy ganyy bä Jesus tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ti m' Jesus ky hadoo ta hã: —H'ëëd p'ãã mabaoot? Jaa ta ti mesoos doo? —näng mäh. Ta tii bä joom mahang moo hew'ëët do ted'oo mäh. Ti hyb n'aa taky hadoo ta hã: —Õm tado bä ti hado nyyh, maher'ood hã ỹ n'yy hẽnh mamahũũm, ỹ behëën hyb n'aa ta kamag n'aa —näng mä Marija Madarẽn. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ti m' Jesus ky hadoo ta hã: —Marija! —näng mäh. Ti m' Marija ty kaw'õõd däk ta wë, ti m' Eberew kyy me taky hadoo: —Raboni! —näng mäh. (“Ma matëg”, tahanäng pé m' tii.) ");
INSERT INTO mbjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ti m' Jesus ky hadoo ta hã: —Moo dëë manä hã ỹỹ —näng mäh. —Dooh Ee wë ỹ ewäd s'ëëg nä bä. Ahõm hä̃j haa hedo padëëk do sa wë. Hahỹỹ da maher'ood sa hã këh ỹ n'aa: “Ỹ asëëk Yp ỹ wë, bë Yb na-ããj, P'op Hagä Do ỹ h'yy kaha'eeh doo, bë h'yy kaha'eeh do wë”, tii da a kyyh —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ti m' Marija Madarẽn bajëng Jesus ma matëg sa wë. Tak'ëp Hyb N'aa Jawyk Do tahapäh mä tanooh. Tapanäk sa hã Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ti noo gó né hẽ m', met'uuh hã, atsëm, séd hã Jesus ma matëg rakata padëëk. Baad ranoo gatsëë däk ta tëg me tób nooh, sa wahë n'aa rajeỹỹm do hyb n'aa. Ti m' Jesus kas'ee g'ëëd kän sa mahang, ti m' takedëng sa hã: —Taw'ããts hẽ bë P'op Hagä Do h'yyb en'yym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Takedëng do jawén paa bä tametëëh sa hã ta mooh, ta baa. Tak'ëp ta ma matëg ratsebee bong Jesus Tak'ëp Hyb N'aa Jawyk Do rabahapäh bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","P'aa hẽnh Jesus ky hadoo sa hã: —Bë P'op Hagä Do h'yyb en'yym —näng mäh. —Ee ỹ tamejũũ doo da, bë ỹ mejũũ hỹỹ kä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ti m' tapahuunh sa wë, ti m' taky hadoo: —Bë gado P'op Hagä Do Sahee —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","—Bë hyb n'aa mabaan bä nesaa do sa mo haj'aa, P'op Hagä Do mabaan né sa hã. Bë hyb n'aa manabaan bä sa hã, dooh P'op Hagä Do mabaan bä sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","12 hedoo do sa seeh, Toméh häd näng doo, “Kawareeh” ramaneëënh doo, dooh sa mahang Jesus kasee bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ti m' ta wób rabaher'oot bä Jesus Tak'ëp Hyb N'aa Jawyk Do rahapäh doo, dooh taky dahé bä. —Atapuwa tyw n'aa ỹ nahapëë bä ta moo hã, moh ỹỹ me ỹ manep'aa bä atapuwa tyw n'aa ta moo hã, ta baa rejooh do tyw n'aa na-ããj hẽ, dooh ỹ ky dahé bä! —näng mä Toméh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ti m' met'uuh see hã, p'aa hẽnh ta ma matëg rakata p'ëë tób gó. Toméh sa sii kä. Noo gatsëë né paawä tób, Jesus kas'ee g'ëëd kän sa mahang, ti m' takedëng sa hã: —Bë P'op Hagä Do h'yyb en'yym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ti m' Toméh hã taky hadoo: —Mamep'aa hahỹỹh —näng mäh. —Mahegãã moh ỹỹ. Magadahëë a mooh, mamep'aa bah ỹỹ bä —näng mäh. —Maky sëëw manäh! Maky dahé! —näng mä Jesus Toméh hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ti m' Toméh ky hadoo: —Wahëh ỹ n'aa, P'op Hagä Do ỹ h'yy kaha'eeh do õm! —näng mä Toméh kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ti m' Jesus ky hadoo ta hã: —Ỹ mahapäh do hyb n'aa mawén ky daheeh. P'op Hagä Do ky n'aa edëng da jé ỹ ranahapëë né paawä ky dah'eeh doo —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hajõng nä Jesus pehuunh ta ma matëg rabahapäh bä. Dooh ta ti takerii bä hahỹỹ hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hahỹỹ hã kerih do wén kerii wät, Jesus ti Kristo, P'op Hagä Do H'yyb Däng Doo, P'op Hagä Do T'aah bë ky daheeh hyb n'aa. Ta hã bë h'yy kae bä, bë d' edëb had'yyt hẽ P'op Hagä Do wë Jesus hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ta jawén Jesus kas'ee wät p'aa hẽnh ta ma matëg sa hã karaj'aa Tiberijas häd näng do nabyy me. Hahỹỹ d' paah: ");
INSERT INTO mbjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simaw Peed häd näng doo, Toméh (“Kawareeh” ramaneëënh doo), Natanajéw häd näng doo (panang Kanah, Garirej häj n'aa bä hana doo), Sebedew häd näng do taah, pawóp hẽ Jesus ma matëg wób, séd hã rababoo däk. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ti m' Simaw Peed ky hadoo sa hã: —Tah'ỹỹb ỹ es'aak —näng mäh. —Ej. A sii ãã bah'ũũm —näk mä ta wób sa kyyh. Ti m' rabaw'ëënh. H'oo yb gó ragatsëg t'oonh. Ti m' rabesaag kän. Resaag had'yyt hẽ paawä atsëm, dooh sa mo haj'aa péh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bäp paa Jesus bag'ëëd kän karaj'aa takëën hã. Dooh ta ma matëg rah'yy genä bä Jesus tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ti m', tii b' naa Jesus naëënh: —Najis haa —näng mäh. —Äkä, bë mo haj'aa? —näng mäh. —Tabad'op hẽ ãã mo haj'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ti m' taky hadoo: —Taw'ããts hẽ hub hẽnh tabanäng hẽnh bë datu karahi, tii bä bë mo haj'aa enäh da —näng mäh. Tii d' rabad'oo bä kä, hajõng tah'ỹỹb karahi gó. Dooh rahaja bä rej'ooj nä bä, tak'ëp hajõng do hyb n'aa tah'ỹỹb. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ti m' Jesus ma matëg baad Jesus kamahä̃n do ky hadoo Peed hã: —Jesus, Hyb N'aa Jawyk Do né tii —näng. Ti m' Simaw Peed häd näng do maa napäh bä kä Jesus tii, tahanäng doo, nayyw hẽ tadadäg däk ta hatsë pooj jé tado nyyh dó. Ti tabahop tame, Jesus wë tabatsóm hõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ta wób ah'ũũm ta jawén h'oo gó. Edah ta nabyyh. 100 meet tahyb n'aa péh. Ti hyb n'aa karahi rabejoonh tame naa. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rakajaa bä kä ta nabyy me, tëëg sëh hahõng do rahapäh. Tah'ỹỹb kejä ta jó. Pawóp na-ããj pãw tii b' hatoonh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ti m' Jesus ky hadoo sa hã: —Bë mana tah'ỹỹb bë mo haj'aa wób —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ti m' Simaw Peed gatsëk h'oo gó. Tii b' naa tabej'ooj nä kän karahi. Hajõng tah'ỹỹb hew'äp do ta gó. 153 tah'ỹỹb. Jawyg né paawä, dooh karahi gekog boo bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ti m' Jesus ky hadoo sa hã: —B'ëëp bë ana, bë awëëh —näng mäh. H'yyb e'ỹỹm “Jaa õm?” rawén neaanh. Jesus, Tak'ëp Hyb N'aa Jawyk Do né sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ti m' Jesus bado däk pãw, tah'ỹỹb daheeh, ti m' taban'oo däk sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tamawoob nuu me däg tii, Jesus kasee do sa hã, taganä wät do jawén paa bä. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Rabahaja däk bä rawëh doo, Jesus ky hadoo mä Simaw Peed hã: —Simaw, Jowãw t'aah, ta wób ỹ rakamahä̃n do bahä̃nh ỹ makamahä̃n? —näng mäh. —Ỹỹ —näng mä Peed. —Mahapäh né hẽ õm ỹ gen'aak —näng mäh. Ti m' Jesus ky hadoo: —Mahagãã masãh ỹ b'éé taah hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","P'aa hẽnh Jesus beaanh ta hã: —Simaw, Jowãw t'aah, ỹ né makamahä̃n? —näng mäh. Ti m' Peed ky hadoo: —Ỹỹ —näng mäh. —Mahapäh né hẽ õm ỹ gen'aak —näng mäh. Ti m' Jesus ky hadoo: —Mahagãã masãh ỹ b'éé hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ti m' tamawoob nuu me däg kä tabeaanh ẽnh: —Simaw, Jowãw t'aah, ỹ né magen'aak? —näng mäh. Peed hyb n'aa tón wät mä tamawoob nuu me, “Ỹ makamahä̃n?” tahanäng do hyb n'aa. Ti m' taky hadoo: —Hyb N'aa Jawyk Doo, —näng mäh —sahõnh hẽ mabahapäh. Mahapäh né hẽ õm ỹ gen'aak doo —näng mäh. Ti m' Jesus ky hadoo: —Mahagãã masãh ỹ b'éé hedo padëëk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Né hup ỹ né hẽ hahỹ ỹ her'oot doo: Mapapunh nä bä mabehen'yyh, mabaheh'ũũm mah'yyb däng doo hẽnh. Mawah'ëë däk bä kä, madajoom da a mooh, õm da ramaw'yyd däk, makanarẽn hẽnh õm da ramahũũm —näng mä Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ta tii d' tawén her'oot, tametëëh hyb n'aa nyy da Peed dajëp, tadajëp do hã P'op Hagä Do kawehëë däk hyb n'aa.) Ti m' Jesus ky hadoo Peed hã: —Hamäh, jawén ỹ ahõm —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dawë hã Jesus sii Peed bawät bä kä, ta jawén p'aa hẽnh tabegãã wät. Tahapäh Jesus ma matëg baad Jesus kamahä̃n do sa jawén hana doo. (Ti né hẽ ta ti Jesus ma matëg Pas-kowa tä n'aa rabawëh noo gó p'eets hẽ takatahã däk Jesus hã, “Jaa ti õm haëënh doo, Hyb N'aa Jawyk Doo”, heaanh doo.) ");
INSERT INTO mbjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ta ti Peed bahapäh bä, tabeaanh mä Jesus hã: —H'ëëd hado da ër jawén hana do hã? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ti m' Jesus ky hadoo: —Ỹ karẽn bä paawä tanadajëb bä, p'aa hẽnh hỹ pong jé naa ỹ bahyng bä kä, hëd n'aa ti a hã? Ỹ karẽn ti õm hëp ỹ hata had'yyt hẽ —näng mä Jesus Peed hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ta tii d' Jesus her'oot do hyb n'aa, raher'ood hõm kän Jesus ma matëg sa mahang, dooh m' ta ti Jesus ma matëg dajëb bä. Dooh tii d' Jesus edo bä. Jããm hẽ hahỹỹ da Jesus kyyh: “Ỹ karẽn bä paawä tanadajëb bä, p'aa hẽnh hỹ pong jé naa ỹ bahyng bä kä, hëd n'aa ti a hã”, näng paa m' Jesus ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ỹ né hẽ ti ta ti ta ma matëg. Ỹ né hẽ ta ti Jesus ky n'aa her'oot doo. Ỹ né hẽ hahỹ ta ky n'aa herii wät doo. Baad ỹ bahapäh, te hub né hẽ sahõnh hẽ ta ky n'aa ỹ erii wät doo. ");
INSERT INTO mbjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hajõng Jesus moo wäd wät do ỹ nerii wät doo. Hã ỹỹ, ji erii bä paawä sahõnh hẽ, dooh paawä badäk hahỹ tahaja wäd bä ta tyw n'aa, ji erii bä sahõnh hẽ. Jããm hẽ kä. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teopiro, õm ti ỹ ma erih. Pooj jé ỹ erii wät doo gó, ỹ erii wät sahõnh hẽ Jesus mo haj'aa paah, tama metëëk do paa na-ããj hẽ, hỹ pong jé Jesus bas'ëëg kän P'op Hagä Do an'oo bä. Hỹ pong jé tabasëëk do pooj jé, P'op Hagä Do Sahee kyy gó, tamejũũ do sa hã, tasëëw hõm do sa hã, Jesus maher'ood hõm nyy d' rabad'oo da. Sahõnh hẽ ti ỹ erii wät, pooj jé ỹ erih do hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ti m' Jesus dajëp jawén paa bä kä m', Jesus kas'ee wät sa hã. Baad takas'ee wät sa hã. Baad tametëëh sa hã rah'yy kadaw'uuh hyb n'aa, edëb wät né hẽ rabahapäh hyb n'aa. Hajõõ nuu me takametëëh sa hã. 40 m' ta ä̃h takas'ee wät sa hã. Taher'oot mä sa hã ji P'op Hagä Do bag'ããs do ky n'aa, ji tah'yyb mahũũm do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ti m', ta see pé noo gó m', sa sii tabawëh noo gó m', hahỹỹ d' mä tamejũũ sa hã: —Panang Jerusarẽnh bä bë ayyw dó. T'ĩĩ hẽnh da bë gada Ee ky n'aa enooh doo, ta Sahee, bë hã ỹ her'oot do paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Hahỹ né hẽ ti ỹ her'oot do paah: “Jowãw nu gahem'uun do nu gemuun wät naëng me. Dooh ta ä̃h hajõõ bä, bë hã P'op Hagä Do banoo ta Sahee bë h'yyb tym gó, bë tah'yyb mahũũm hyb n'aa” —näng mä Jesus ta mejũũ do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ti m' ta see pé noo gó, rakata padëëk bä séd hã, tamehej'ũũ do reaanh Jesus hã. Hahỹỹ d' mä sa kyyh: —Hahỹỹ hã mabanoo ãã hã, Isaraéw buuj hã, ãã wahë n'aa, ãã tabahag'ããs hyb n'aa? —näk mä sa kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ti m' Jesus ky hadoo sa hã: —Dooh bë panyyg enäh do jawén tado bä, Ee ky däng do heen n'aa ta hejój hã. Dooh ti hyb n'aa tado bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","P'op Hagä Do Sahee bajëë suun bä bë h'yyb tym gó, tii bä da bë h'yyb tym hejoonh, këh ỹ n'aa bë baher'oot hyb n'aa. Këh ỹ n'aa bë her'ood da panang Jerusarẽnh bä, Judah häj n'aa bä, Samarija häj n'aa bä na-ããj da. Badäk hahỹ haw'ããts hẽ da bë baher'oot këh ỹ n'aa —näng mä Jesus kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ti m' ta ti taher'oot do jawén paa bä kä m', P'op Hagä Do masäg kän hỹ pong jé. Sa matym gó né hẽ tabasëëk. Wë puh ejën wät mä rawén nahapëë wäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Rabahag'ããs bä Jesus hasëëk doo, nayyw hẽ m' rakasee pawóp hẽ ajyy sa pa. Hewak mä sa saroor. Ããs mä tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ti m' ããs raky hadoo sa hã: —Hëd n'aa babä bë bab'ëëh, wë hã bë baheg'ããs, Garirej buuj? —näk mäh. —Ti né hẽ Jesus bë mahang hawät doo, hỹ pong jé hasëëk doo, ti né hẽ da paa me hahyng. Bë hapäh do hadoo tabasëëk, ti hadoo né da tabahyng p'aa hẽnh —näk mä ããs sa kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ti m', tii b' naa, waëë joom oriib banäng doo bä naa, rababaaj nä Jerusarẽnh panang hẽnh. Dawëë nado m' tii. Judah buuj sa hã Mosees ky n'aa jaw'yyk do tanoo do rabeheb'ooh do Saab hã, ti pénh mä tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti m' rakajaa bä m', rabajëë p'ëë mä ta gawakõ p'op gadäk doo gó, rabahej'eenh doo hẽnh. Hahỹỹ d' paa m' kata j'eenh do sa häd: Peed, Jowãw, Tsijaag, Ãn-Deréh, Pirip, Toméh, Batoroméw, Matew, Tsijaag Aw-Pew t'aah, Simaw Serot, Judas Tsijaag t'aah. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sahõnh hẽ ta ti rakahet'aa, Jesus wakããn, Marija (Jesus ỹỹn), ỹỹj wób sa sii, séd hã raky n'aa etsẽẽ hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Ti m', ta see pé noo gó Jesus hã h'yy ka'eeh do rakataa séd hã. (120 hyb n'aa hadoo mä ti kata pad'ëëk doo.) Ti m' Peed bas'ëëg gëët sa mahang, ti m' taky hadoo sa hã: —Bë maa newë këh ỹỹ, wakãn haa —näng mäh. —P'ooj ub ër wahë makũ Dawi häd näng doo, P'op Hagä Do Sahee kyy gó taher'oot Judas Ikarijot makũ ky n'aa, P'op Hagä Do kyy kerih do paa gó. Dawi erih do paah, P'op Hagä Do kyy kerih doo gó, ti d' né paa Judas ky n'aa. Jesus maso däk do metëë n'aa ti Judas Ikarijot. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ãã see paa né tii, ãã kanatëë paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jesus majĩĩ sa moo gó tan'oo däk do säm n'aa me tamets'ẽẽ hõm tób hood pan'aa. Ti m' ta jawén tabadëë hyng p'op naa ta nuu paa me. Sahõnh mä taganabäh hõm. Ta j'aa tyd mä gatsëk. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ti m' sahõnh hẽ Jerusarẽnh buuj raky n'aa napäh bä m', ta häd ramaneëënh “ta majyyw hood” ta tób hood paah. Sa kyy me ramaneëënh Akaredãm) —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ti m' taky hadoo ẽnh: —P'op Hagä Do kyy kerih do paa hã, Saaw-Mo hã, takerii däk Judas Ikarijot ky n'aa. Hahỹỹ da takerii däk: “Ta tób paah, dooh ta yt hagëë wät pé.” Saaw-Mo see hã takerii däk hahỹỹ da: “Taw'ããts hẽ ta see ta jawén buuj”, näng mä Peed kyyh, P'op Hagä Do kyyh taher'oot do Saaw-Mo hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ti m' Peed ky hadoo: —Ti hyb n'aa, taw'ããts hẽ ër esoos hapäh do seeh, Jesus Jowãw nu gahem'uun do nu gemuun noo gó, Jesus hawät noo gó ãã mahang, tabasëëk jawén paa bä hapäh doo. Ti né hẽ da ãã ky hata. Ãã sii her'oot do pan'aa, Jesus ganä wät do tadajëp jawén paa bä ky n'aa —näng mä Peed kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ti m' rah'yy kajäk pawóp hẽ ajyy. Hahỹỹ d' paa m' sa häd: Joséh, Bar-Saba ramaneëënh doo (ta häd see ramaneëënh Jus-To). Ta see häd mä Matsijas. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ti m' hahỹỹ da Jesus hã h'yy ka'eeh do raky n'aa etsẽẽ: —Jesus, baad mah'yyb hapäh ãã sahõnh hẽ —näk mäh. —Mametä jaa ta ti masëëw däk do Judas jawén buuj, mamejũũ do see tabadoo hyb n'aa ta jawén buuj. Dooh Judas makũũ mamejũũ do see tado wäd bä. Ahõm nesaa do tamoo wät do säm tagadoo hẽnh —näk mä sa kyyh Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ti m' pä taah hã raberii padëëk sa häd. Ti m' ramekuuj bong pä taah, ti m' pä t'aah adëë hyng tũũ. Ti m' rabaheg'ããs. Matsijas häd mä ta hã. Ti hyb n'aa 12 rabado däg kän p'aa hẽnh Jesus mejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ti m', jäm Pẽn-Tekos häd näng do noo gó m', séd hã m' sahõnh hẽ Jesus hã h'yy ka'eeh do rakata padëëk sét tób yt hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ti m' nayyw hẽ, hỹ pong jé naa ky ganä däk bah'ood tak'ëp hana do ky hadoo mäh. Tób rayd t'oonh do haw'ããts hẽ m' maa ena ta ti kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ti m' rabahapäh, tëëg hõõ hadoo mä tabehũũm sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ti m' sahõnh hẽ kat'aa do sa h'yyb tym gó P'op Hagä Do Sahee bajëng, tabanyy däk hyb n'aa. Baad mä sa h'yyb tamahũũm. Ti m' radu doo ta wób sa kyy me rer'oot doo. P'op Hagä Do Sahee anoo do hadoo sa hã, ti hadoo né m' rer'oot. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti noo gó m' ti abong mä Jerusarẽnh panang bä Judah buuj, P'op Hagä Do hyb n'aa jew'yyk doo, badäk hahỹ haw'ããts hẽ häj n'aa bä naa han'aa doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ti m' bah'ood hadoo do kyyh ramaa napäh bä m', séd hã m' rakata padëëk. Ramaa napäh Jesus hã h'yy ka'eeh do ramer'oot mä sa kyy me. Sahõnh hẽ häj n'aa s'ee hẽnh han'aa do sa kyy me m' ramer'oot. Ti hyb n'aa m' rameuuj bong. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tak'ëp rameuuj bong mäh. Ti m' raky hadoo: —H'ëëd hado hỹỹ éh? —näk mäh. —Sahõnh hẽ her'oot doo, Garirej häj n'aa buuj né ti hỹỹh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","—H'ëëd hyb n'aa ti rabahajaa sahõnh hẽ ër kyyh rer'ood bä? Ër maa napäh rer'oot do ër kyyh —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","—Ër mahang ti abong Par-Tos häj n'aa babuj n'aa, Medija häj n'aa bä naa, Mesopotãm babuj n'aa, Judah häj n'aa bä naa, Kapados häj n'aa babuuj, Põn-Tus häj n'aa babuuj, Asija häj n'aa babuuj, ");
INSERT INTO mbjNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirikija häj n'aa bä naa, Pam-Pirija häj n'aa bä naa, Esit häj n'aa bä naa, Ribija häj n'aa Sirené nedaa bä naa ta wób —näk mäh. —Ti abong na-ããj hẽ panang Roma häd näng doo bä naa ta wób. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Ër mahang ti abong Judah buuj heh'äät ub doo. Ta wób Judah buuj nadoo do né paawä, Mosees ky n'aa jaw'yyk do raky daheeh Judah buuj rabahed'oo doo da.) Tsyt dëëg hã, Keret häd näng doo bä naa ta wób. Arab häj n'aa babuuj ta wób. Ër sahõnh hẽ ër maa napäh ër kyy me P'op Hagä Do tak'ëp haj'ap do mo haj'aa rer'oot doo —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ti m' sahõnh hẽ rah'yyb manepëë bong. Rameuuj bong mäh. Ti m' sa da hadoo do hã rabeaanh: —H'ëëd hado hahỹỹ éh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dooh. Ti a'oom sa h'yyb —näk mä ta wób. Raky n'aa ej'ees mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ti m' Peed, 11 hedoo do Jesus mejũũ do wób, sa sii tabas'ëëg gëët. Ti m' kata pad'ëëk do sa hã tabaher'oot. Tak'ëp mä ta kyyh. Ti m' taky hadoo: —Judah buuj, wakãn haa, Jerusarẽnh buuj na-ããj hẽ, baad bë maa newë bë ỹ maher'oot doo —näng mäh. —Ỹ her'oot bë hã hahỹ bë hapäh do ky n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","—Ha'oom doo, bë ed'oo hahỹ ajyy. Dooh raoom bä. Bäp paa nä. Dooh ji aoom bä nayyw hẽ bäp paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hahỹ bë hapäh doo, P'op Hagä Do ky n'aa rod Jowéw häd näng do her'oot do paah. Hahỹỹ da m' ta kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Sahõnh hẽ tagawatsig pooj jé, näng mä P'op Hagä Doo, ỹ anoo da Sahé ỹỹ sahõnh hẽ badäk hahỹ haw'ããts hẽ habong do sa hã. Bë taah, bë toog na-ããj hẽ raher'oot da ta jawén ganyyh do ky n'aa. S'ëëh hadoo da pahëëw sa hã. Wahëh s'ëëh enäh da. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wë ỹ moo bok do sa hã né da ỹ banoo da ti noo gó Sahé ỹỹ. Ỹ anoo ajyy sa hã, ỹỹj sa hã na-ããj hẽ. Ti hyb n'aa ta jawén ganyyh do pan'aa raher'oot da. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Wë hã ỹ pehuunh da tak'ëp had'op doo. Tũũ ta heen n'aa ỹ metëëh da. Majyyw, tëëg hõõh, atsyg na-ããj hẽ ỹ metëëh da. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tak'ëp Hyb N'aa Jawyk Do ahyng do pooj jé, ti noo gó né hẽ, papỹỹj badagyb däk da. Kamarab ty hahiin majyyw hado däk da. Tak'ëp da tabanäm, hetsooh né hẽ da, gabarëëh do bag hadoo, Tak'ëp Hyb N'aa Jawyk Do hahyng noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sahõnh hẽ Tak'ëp Hyb N'aa Jawyk Do hã ky n'aa etsẽẽ doo, wë ỹỹ da sa h'yyb tym edëp ỹ an'oo bä.” ");
INSERT INTO mbjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ti m' Peed ky hadoo ẽnh: —Isaraéw buuj, bë maa newë hahỹỹh —näng mäh. —Jesus Nasaréh buuj pehuunh tak'ëp hadoo doo. Tametëëh P'op Hagä Do hejój. P'op Hagä Do né hẽ ti hanoo ta ti ta hã, baad P'op Hagä Do h'yyb däng ta hã ji bahapäh hyb n'aa. Bë hapäh né hẽ tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ti né hẽ Jesus ran'oo däk do bë moo gó, p'ooj ub P'op Hagä Do h'yyb däng do hadoo né hẽ. Ti né hẽ Jesus bë daj'ëëp doo, bë epëëm däk doo. Ajyy P'op Hagä Do ky n'aa jaw'yyk do ky nadah'eeh do bë mejũũ repëëm däk. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tii da bë badoo né paawä, Jesus ganä wät dejëp do mahang P'op Hagä Do an'oo bä. Tadajëp jawén paa bä, edëb wät P'op Hagä Do an'oo bä. Tii d' tawén d'oo, dooh dajëb haja bä taj'aa ketsëë bä Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hahỹỹ da ër wahë makũ Dawi her'ood däk do paa Jesus ky n'aa: “Matym ỹỹ gó Tak'ëp Hyb N'aa Jawyk Do ỹ hapäh had'yyt hẽ, pój ỹỹ jé tabahõm. Hup ỹỹ hẽnh tabawät do hyb n'aa, dooh ỹ h'yyb eỹỹm bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ti hyb n'aa ỹ h'yy gadajang, ti hyb n'aa ỹ ma ejäm ỹ tsebé do hyb n'aa. Dooh kamak ỹ n'aa meréd bä ỹ radakä jëng doo hẽnh. Dooh man'oo bä a karom tsyt hẽ a wë moo wät do ta kamag n'aa karejã bä. Ti hyb n'aa, dooh ỹ eỹỹm bä ỹ dajëb né paawä. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hã ỹ mametëëh ta tyw n'aa hỹ pong jé hahõm doo, ji awäd had'yyt doo hẽnh. Tak'ëp ỹ tsebé a matym gó man'oo bä”, näng mä Dawi Jesus ky n'aa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ti m' Peed baher'oot ẽnh sa hã: —Wakãn haa —näng mäh. —Wyt ta maab hẽ ti ỹ her'oot do bë hã. Ër wahë makũ Dawi, ta ti her'oot do paah, dajëp. Radakä jëng. Da hẽ ti anäng nä ër panang bä ta kamag n'aa paa hood. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Noo ese ti Dawi makũũh, P'op Hagä Do ky n'aa rod seeh. Dooh ta daaj hẽ ta ky n'aa taher'ood bä. Tahapäh né hẽ ky kaneh'ỹỹt doo me P'op Hagä Do ky n'aa enooh do paa ta hã. Ti awät, P'op Hagä Do ky n'aa enooh ta hã, Dawi panaa see ër wahë pan'aa tabahadoo hyb n'aa ta jawén buuj. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta jawén hawät do tahapäh do hyb n'aa Dawi makũ wén her'ood däk, Kristo, P'op Hagä Do H'yyb Däng Do ky n'aa, Kristo dajëp do jawén paa bä ganä wät do ky n'aa. Dooh P'op Hagä Do H'yyb Däng Do radakä jëng doo hẽnh tayyw bä, tanooh. Dooh ta kamag n'aa karejã bä, tanooh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ta ti Jesus, ta ky n'aa bë hã ỹ her'oot doo, ti né hẽ P'op Hagä Do an'oo bä edëb wät p'aa hẽnh. Taganä wät jawén paa bä, ãã sahõnh hẽ ãã bahapäh, ta ky n'aa ãã wén maher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hỹ pong jé tabasëëk P'op Hagä Do an'oo bä. P'op Hagä Do hub hẽnh tabasooh P'op Hagä Do an'oo bä, ta sii tabag'ããs hyb n'aa. Tii bä ta Yb an'oo däk ta Sahee ta hã, ër hã taky n'aa enooh do paah. Ti né hẽ hỹỹ kä tanoo do ãã hã kä. Ti né hẽ ti bë maa newëë doo, babä bë hapäh doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dooh Dawi makũ hỹ pong jé hasëëk do tado bä. Ti hadoo né hẽ hahỹỹ da ta kyyh: “Wahëh ỹỹ hã P'op Hagä Do ky hadoo: ‘Aso hup ỹỹ hẽnh, si ỹ mabag'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tii bä kä da a majĩĩ da ỹ nes'ëëm, õm da raky daheeh ỹ an'oo bä.’” Tii da né Peed kyyh Dawi erih do paa hã P'op Hagä Do kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ti m' Peed ky hado kän sa hã: —Isaraéw buuj, wakãn haa, bë ỹ maher'oot baad ub, bë sahõnh hẽ baad bë bahapäh hyb n'aa ti hahỹỹh: Ta ti Jesus, bë epëëm däk doo, P'op Hagä Do an'oo däk tak'ëp hyb n'aa jawyk tabado däk hyb n'aa, Kristo, P'op Hagä Do H'yyb Däng Do tabado däk hyb n'aa na-ããj hẽ —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ti m' kat'aa do ramaa napäh bä m' Peed kyyh, tak'ëp mä rah'yy ketón bong. Ti m' rabeaanh Peed sa hã: —Wakãn haa, —näk mäh —nyy da ër bad'oo hỹỹ kä? ");
INSERT INTO mbjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ti m' Peed ky hadoo: —Taw'ããts hẽ bë h'yy kawareem P'op Hagä Do wë. Taw'ããts hẽ Jesus Kristo häd gó bë ranu gemuun hõm, ta ti heen n'aa. Tii da nesaa do bë h'yyb tym gó hanäng do P'op Hagä Do awug hõm da. Tii bä da tanoo da ta Sahee bë hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","—Bë hã, bë panaa hã, ta wób hã na-ããj hẽ dawëë habong do P'op Hagä Do mahä̃nh taky n'aa enooh paa ta Sahee. Sahõnh hẽ tanaëënh do sa hã taky n'aa enooh ta tii —näng mä Peed kyyh kata padëëk do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ti m' hajõng Peed her'oot nä sa hã. Tak'ëp tabetsẽẽ sa hã rah'yy kawereem hyb n'aa. Hahỹỹ da ta kyyh: —Bë kedëëb, ky nes'aa do sa nemuun bë P'op Hagä Do narejãã hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ti m' ranu gemuun hõm mä Peed her'oot do gad'oo doo. Kata däg kän mä P'op Hagä Do hã h'yy ka'eeh do sa hã. Kata däk doo kä ti noo gó tahyb n'aa pé 3 miw. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Baad mä rahyb n'aa matakëë 12 hedoo do Jesus mejũũ do rama metëëk do hã. Séd hã had'yyt hẽ rababong. P'op Hagä Do sii raber'oot, ta hã raky n'aa etsẽẽ. Raganebäh hõm pãw, sahõnh hẽ rabawa, Jesus sa hyb n'aa dajëp do rahyb n'aa esee hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hajõk do rameuuj bong mä Jesus mejũũ do rametëëk doo, rapehuunh do hyb n'aa. Tak'ëp né hẽ rapehuunh mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Séd hã rababok Jesus hã h'yy ka'eeh doo. Sahõnh hẽ sa ma sa hã né hẽ rabetyn. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ti m' res'ëëm sa ma sa wë hanäng doo. Ta säm retyn hõm mä sahõnh hã, wë bedoh do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","P'op Hagä Do tób n'aa wahoo gó, séd hã Jesus hã h'yy ka'eeh do rakahet'aa had'yyt hẽ. Sa tób yt hã séd hã sa tä rabawëh, sa waa rabawa, rah'yyb tsebé do hyb n'aa, baad tabahadoo do hyb n'aa sa h'yyb. ");
INSERT INTO mbjNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","P'op Hagä Do rama ejäm, P'op Hagä Do raj'aa etsë do ky n'aa raher'oot. Sahõnh hẽ ta wób ragen'aak Jesus hã h'yy ka'eeh doo. Ti m' Jesus an'oo bä ta hã h'yy ka'eeh do kahũũm magyys hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ti m' ta see pé noo gó, tug bä, Peed Jowãw daheeh rabah'ũũm P'op Hagä Do tób n'aa hẽnh, P'op Hagä Do hã Judah buuj raky n'aa hetsẽ do heen n'aa gó m'. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tób wahoo n'aa hadë noo bä aj'yy k'yy gadóm do bahäng. Ta hã d' né hẽ tahenäng noo gó. Ta noo “Hanäm Doo” ramaneëënh doo bä tabahäng. T'ĩĩ hẽnh ramana had'yyt hẽ, dajẽẽr tabetsẽẽ hyb n'aa hejëng do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ti m' tabahapäh bä Peed Jowãw daheeh hajëë p'ëë doo, tetsẽẽ mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ti m' rabaheg'ããs ta hã, ti m' Peed ky hadoo: —Mahegãã ãã wë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ti m' aj'yy hyb n'aa matakä däk mäh. Ranoo ted'oo dajẽẽr ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ti m' Peed ky hadoo ta hã: —Dooh wë ỹ hanäng pé k'ããts tëg gabarëëh doo, hewak do na-ããj hẽ. Wë ỹ hanäng do ỹ anoo da Jesus Kristo, Nasaréh buuj ky gabuuj: Awäd däg! —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tii bä m' Peed moo ej'ooj sëëk mäh. Ta hub me m' tamoo ej'ooj sëëk. Ti m' nayyw hẽ ta tsyym bahub däk. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tabas'ëëg gëët bä getsëg wät mäh. Ti m' tadu doo tabawäd däk. Ajëë suun kän mä sa sii P'op Hagä Do tób n'aa wahoo gó, awäd däk mäh, getsëk mä tawäd bä. P'op Hagä Do m' taj'aa etsëë wät. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ti m' sahõnh hẽ rabahapäh bä hawäd däk doo, P'op Hagä Do taj'aa etsëë däk bä, ");
INSERT INTO mbjNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","raky hadoo: —Ti né paa ër hep'ëëh doo, tób noo bä “Hanäm Do” häd näng doo bä hahäng doo, dajẽẽr hetsẽ doo —näk mä sa kyyh. Ti m' rahyb n'aa meuuj bong mä hawäd däk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ti m' ta tii kä aj'yy hawäd däk doo, dooh m' teréd bä Peed Jowãw daheeh. Ti m' sahõnh hẽ t'ĩĩ hẽnh rawaj'aa padëëk, raheg'ããs hyb n'aa. Saromãw häd näng doo bä rabab'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ti m' Peed rabab'ëëh bä m' ranu sabug däk. Ti hyb n'aa m' Peed ky hadoo sa hã: —Isaraéw buuj —näng mäh. —H'ëëd hyb n'aa bë meuunh? H'ëëd hyb n'aa ãã wë bë baheg'ããs? Ãã ky gabuuj bë ed'oo, baad P'op Hagä Do hã ãã h'yy kasadä do hyb n'aa bë ed'oo, ti aj'yy bawäd däk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","—P'op Hagä Doo, Abaraãm, Isak, Jakóh rah'yy kaha'eeh doo, ër wahë makũ rah'yy kaha'eeh doo, ti hanoo tak'ëp Jesus kawehëë däk hyb n'aa. Ti né hẽ bë an'oo däk paa ta wób sa moo gó tadajëp hyb n'aa. Baad né paawä Pirato beréd hõm tabahõm, bë ty n'aa ges'yyk. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bë h'yy kawareem baad had'op do wë, P'op Hagä Do karẽn doo da hawät do wë. Bë mejũũ Pirato beréd hõm ta da hadoo do dahej'ëëp doo, Jesus jawén buuj. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bë daj'ëëp paa ji hed'ëëp doo. Ti hadoo né hẽ, P'op Hagä Do an'oo bä taganä wät p'aa hẽnh. Ãã sahõnh hẽ, baad ub ãã bahapäh ta tii, ta ky n'aa ãã wén maher'oot. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesus häd gó ãã h'yy ka'eeh do hyb n'aa, hahỹ aj'yy bë hep'ëëh do wén k'yy hub däk. Ji h'yy ka'eeh do hyb n'aa Jesus häd gó né hẽ tawén has'oo däk, baad ub bë bahapäh doo kä —näng mä Peed sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ti m' taky hadoo ẽnh: —Wakãn haa —näng mäh. —Ỹ hapäh, dooh bë h'yy ganyy bä, bë wahë n'aa na-ããj hẽ, tii da bë bad'oo do paa Jesus bë rejãã noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tii da né hẽ takaja däk P'op Hagä Do an'oo bä, ta pooj jé sahõnh hẽ ta ky n'aa rod raher'oot do paa Kristo ky n'aa hã. Kristo, P'op Hagä Do H'yyb Däng Doo, ahoop mä da dajëb, raher'oot paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ti hyb n'aa, taw'ããts hẽ bë t'yyd kamehĩĩn bë bad'oo do hã. Bë h'yy kawareem, P'op Hagä Do hã bë h'yy ka'eeh, nesaa do bë h'yyb tym gó hanäng do tabawug hõm hyb n'aa, Tak'ëp Hyb N'aa Jawyk Do bë tah'yyb en'yym hyb n'aa, ");
INSERT INTO mbjNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jesus, Kristo, p'ooj ub bë hyb n'aa tasëm do P'op Hagä Do mejũũ hyb n'aa bë mahang —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ti m' Peed ky hadoo ẽnh: —Hỹ pong jé Jesus bagä nä, takajaa bä kä sahõnh hẽ P'op Hagä Do benäm doo. Tii da né hẽ p'ooj ub taky däng tabad'oo ta ky n'aa rod tsyt hẽ ta wë kasëëw bong do raher'oot do hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hahỹỹ da m' taky n'aa enooh do Mosees her'oot do hã: “P'op Hagä Do ky n'aa rod ỹ hadoo doo da Tak'ëp Hyb N'aa Jawyk Doo, P'op Hagä Do bë h'yy kaha'eeh do an'oo bä bë mahang ganyyh da. Bë ky dahé da ta kyyh taher'oot doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jé ta hã ky nadaheeh doo, dooh né hẽ P'op Hagä Do gado wäd bä ta karapee mahang”, näng Mosees kyyh —näng mä Peed. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ti m' Peed ky hadoo ẽnh: —Sahõnh hẽ P'op Hagä Do ky n'aa rod, Samuéw, P'op Hagä Do ky n'aa rod wób na-ããj hẽ Samuéw jawén her'oot doo, raher'oot paah, da hẽ ër mahang Jesus bad'oo doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bë né hẽ ti gadoo do pan'aa P'op Hagä Do ky n'aa enooh do paa ta ky n'aa rod sa hã. Bë né hẽ ti gadoo do pan'aa ër wahë makũ sii P'op Hagä Do kaner'oot doo. Hahỹỹ da P'op Hagä Do ky däng do paa ër wahë makũ Abaraãm hã: “Sahõnh hẽ badäk hahỹỹ hã habong do raky n'aa kedëng da a panaa see hyb n'aa”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ti m' taky hado kän: —Ta t'aah P'op Hagä Do ganyy wät jawén paa bä, pooj jé tamejũũ bë wë, bë taky n'aa edëng hyb n'aa, bë tah'yyb wareem hyb n'aa nesaa do bë moo bok do mahä̃nh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ti m', P'op Hagä Do tób n'aa yt hã moo heb'ooh doo, P'op Hagä Do tób n'aa hagã n'aa sa wahë n'aa, Saduséw häd enäh do na-ããj hẽ, an'aa Peed Jowãw daheeh rabaher'oot bä hajõk do mahang. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tii kä m', han'aa do tak'ëp mä rakawajããn, Peed Jowãw daheeh rama metëëk do hyb n'aa ti Jesus edëb wät dajëp do paa P'op Hagä Do an'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ti m' rameso padëëk Peed Jowãw daheeh. Tũũh däg mä papỹỹj rawén dewäts bëëh dó, jat'iip hadoo rabaher'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ti hadoo né hẽ, hajõk raky daheeh Jesus ky n'aa Peed raher'oot doo. Kahũũm magyys hẽ Jesus hã h'yy ka'eeh doo. 5 miw däk mä tahyb n'aa péh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ti m' jati pé Judah buuj sa wahë n'aa, sa wahë n'aa wób, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ, Jerusarẽnh bä rakata padëëk rabaher'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ti abok sa mahang P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do Anas häd näng doo, Kajapas, Jowãw, Aresãn, ajyy wób na-ããj hẽ P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wakããn. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ti m' ramejũũ ramena b'ëëh Peed Jowãw daheeh sa wë. Ti m' radu doo reaanh doo. Hahỹỹ da m' sa kyyh: —H'ëëd hejój me, jaa kyy gó aj'yy k'yy gadóm do bë haso däk? —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ti m' baad mä Peed P'op Hagä Do Sahee h'yyb mahũũm. Ti m' Peed ky gadoo: —Bëëh, Judah buuj bag'ããs doo, bëëh, sa wahë n'aa hedoo doo —näng mäh ");
INSERT INTO mbjNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—ãã bë eaanh nahëë näng do hã baad ãã moo bok do ky n'aa. Bë karẽn mä bë bahapäh nyy da tabahas'oo däk. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ỹ her'oot baad ub bë hã, baad bë bahapäh hyb n'aa, sahõnh hẽ Isaraéw buuj na-ããj hẽ: Jesus Kristo, Nasaréh buuj, bë epëëm däk do paah, P'op Hagä Do an'oo bä ganä wät do hejój gó né hẽ tabahas'oo däk hahỹ aj'yy bë mahang hag'ëëd däk doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","—Jesus né hẽ ti pä hadoo, bëëh, tób n'aa tehem'aa do hedoo do ty n'aa ges'yyk doo, hỹỹ kä pä ta ba n'aa, mesoo n'aa hado däk doo —näng mä Peed kyyh, P'op Hagä Do kyy kerih do paa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ti m' taky hadoo ẽnh: —Jããm hẽ Jesus häd gó ji P'op Hagä Do bed'ëëp nesaa do mahä̃nh ta wë ji basëëk hyb n'aa. Dooh ta see pé badäk hahỹ haw'ããts hẽ ji h'yyb tym hed'ëëp doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ti m' sa wahë n'aa rameuuj bong, h'yyb neỹỹm doo me Peed Jowãw daheeh raher'oot rabahapäh bä, dooh né paawä tak'ëp rama kamet'ëëg bä, ky n'aa netsä né paawä. Peed raher'oot do hã, Jesus sii rababong do paa sa wahë n'aa rahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sa mahang né hẽ aj'yy has'oo däk do bagëët. Baad rabahapäh ti has'oo däk né hẽ, ti hyb n'aa dooh sa kyy péh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ti m' ramejũũ Peed Jowãw daheeh raban'yyh dó. Ti m' sa wahë n'aa rakaner'oot nyy d' rabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ti m' raky hadoo: —Nyy d' ër bad'oo sa hã? Sahõnh hẽ Jerusarẽnh buuj raheen n'aa enä hahỹ baad rapahuunh doo. Dooh tahaja bä ër ky n'aa jejën bä —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","—Taw'ããts hẽ ër meduuk sa hã, ranaher'ood bong hyb n'aa ta wób sa hã Jesus häd gó, rapahuunh do ky n'aa kanah'ũũm hyb n'aa —näk mä Judah buuj sa wahë n'aa sa kyyh, sa daaj hẽ rakaner'ood bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ti m' ramejũũ Peed Jowãw daheeh rabajëë p'ëë p'aa hẽnh. Ti m', tak'ëp ramejũũ sa hã ranaher'oot hyb n'aa, rama manetëëk hyb n'aa Jesus häd gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ti m' Peed raky hadoo: —Bë daaj hẽ bë hyb n'aa newë baad hadoo do P'op Hagä Do matym gó. Bë mejũũ do hã ãã ky daheeh, P'op Hagä Do mejũũ do hã ãã ky daheeh? ");
INSERT INTO mbjNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dooh ãã haja bä ãã ky n'aa eréd bä ãã her'oot do ãã maa napäh do hã, ãã hapäh do hã —näk mä Peed sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ti m' p'aa hẽnh rage'ỹỹm sa hã. Rage'ỹỹm jawén paa bä m', raberéd hõm rabah'ũũm hyb n'aa. Dooh rahapëë bä nyy d' rabad'oo Peed Jowãw daheeh rarejãã hyb n'aa, hajõk do P'op Hagä Do raj'aa etsë do hyb n'aa, aj'yy has'oo däk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aj'yy has'oo däk doo, 40 bahä̃nh däg ta baab n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ti m' Peed Jowãw daheeh raberéd hõm jawén paa bä kä m', rabahõm sa najiis hedoo do sa wë, Jesus hã h'yy ka'eeh do sa wë. Ti m' rabaher'oot sa hã sahõnh hẽ P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa, Judah buuj sa wahë n'aa wób sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ti m' raky n'aa napäh bä m', séd hã m' raky n'aa etsẽẽ P'op Hagä Do hã. Hahỹỹ da m' sa kyyh: —Tak'ëp Hyb N'aa Jawyk Doo, sahõnh hẽ mabag'ããs doo —näk mäh. —A mo haj'aa sahõnh hẽ badäk hahỹỹh, wë, akajar na-ããj hẽ, sahõnh hẽ ta hã habong do na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hahỹỹ da maher'ood wät paa a Sahee kyy gó, a karom kyy hã, Dawi, ãã wahë makũ kyy hã, a wë rah'yy kawapëën do ky n'aa: “H'ëëd hyb n'aa badäk hahỹ haw'ããts hẽ habong doo, Judah buuj nadoo doo, rakawajããn? H'ëëd hyb n'aa daap hẽ rahyb n'aa newëë nyy d' rah'yy kawereem P'op Hagä Do wë, ta hã raky nadaheeh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Badäk hahỹ haw'ããts hẽ häj n'aa sa wahë n'aa rakataa séd hã, Tak'ëp Hyb N'aa Jawyk Do wë, Kristo, Tah'yyb Däng Do wë na-ããj hẽ, rakamaj'ĩĩ hyb n'aa.” ");
INSERT INTO mbjNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Te hub né hẽ —näk mäh. —Babä panang bä, ãã wahë n'aa Eróts häd näng do kataa Pirato sii, Isaraéw buuj nadoo do sii, Isaraéw buuj sii na-ããj hẽ rah'yy kawapëën hyb n'aa a karom tsyt hẽ a wë kasëëw däk do wë, Jesus wë, mah'yyb däng do wë. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","P'ooj ub maky däng do paa hadoo doo da né hẽ rabad'oo. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mahapäh né hẽ ãã rage'ỹỹm doo. A karom né hẽ ããh. Man'oo baad ub, h'yyb neỹỹm doo me, a ky n'aa ãã baher'oot hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Man'oo ãã hã a hejój, nahëë enäh do ãã baheso hyb n'aa, ãã pehuunh hyb n'aa, ãã moo bok hyb n'aa ji hyb n'aa meuunh doo, Jesus a karom tsyt hẽ a wë kasëëw däk do häd gó —näk mä sa kyyh raky n'aa etsẽẽ bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Rabahajaa bä raky n'aa etsẽẽ doo, rabab'ëëh bä katajus wät mä k'ããts. Tii bä kä m', P'op Hagä Do Sahee sahõnh hẽ sa hã tak'ëp mä sa h'yyb tamahũũm. Ti m' h'yyb neỹỹm doo me rabaher'ood kän P'op Hagä Do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti m', séd rah'yyb hedoo sahõnh hẽ Jesus hã h'yy ka'eeh doo. Jé ma enäh do ky en'yym ta wób sa hã. Dooh sa mab hẽ sa ma tado bä, sahõnh hẽ sa ma hadoo. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tii kä m' 12 hedoo do Jesus mejũũ doo, P'op Hagä Do hejój me raher'oot mä Jesus, Hyb N'aa Jawyk Do ganä wät do ky n'aa. Baad P'op Hagä Do moo wät sa hã, baad tabahag'ããs sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dooh kas'uut pé sa mahang. Ta see pé noo gó ken'yyh, jé tób see enäh doo, tób hood pan'aa enäh do na-ããj hẽ, resëëm hõm mä tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ta säm ramanaa Jesus mejũũ do sa wë, rabets'ëë hõm hyb n'aa wë bedoh do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sa mahang ti awät Rewi panaa, tsyt dëëg hã Tsi-Peré häd näng doo bä henäng doo. Joséh mä ta häd. Jesus mejũũ do rahäd n'oo däk Béh-Nabéh. (“Ji h'yyb en'yym doo”, tahanäng pé ti Béh-Nabéh.) ");
INSERT INTO mbjNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Béh-Nabéh besëëm hõm tób hood pan'aa ta ma paah, ti m' ta säm tamanaa Jesus mejũũ do sa wë, rah'yyb däng doo da rabad'oo hyb n'aa ta me. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sa mahang ti awät mä aj'yy seeh. Ta häd mä Ananijas. Ta ỹỹm Sapira häd näng do daheeh resëëm hõm mä na-ããj hẽ tób hood pan'aa, sa ma paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ta ỹỹm daheeh rakaner'oot jawén paa bä m', Ananijas manaa mä ta säm uuh Jesus mejũũ do sa wë. Ta uuh sa wë tabaym. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ti m' Peed ky hadoo ta hã: —Ananijas, —näng mäh —ny hadoo Satanas, Nesaa Do Yb, õm tah'yyb mahũũm P'op Hagä Do Sahee mawadii hyb n'aa paawä? A wë tabaym tób hood pan'aa a ma paa säm, a hã rep'aak do uuh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","A h'ëëd né hẽ paa ti tób hood pan'aa. Ta säm, mesëëm hõm do jawén paa bä, a ma né hẽ paawä. H'ëëd hyb n'aa, sahõnh hẽ a hã rep'aak do mets'ëë däk maken'ooh? Dooh ãã tado bä ti mawadii doo, P'op Hagä Do ti mawad'ii paawä —näng mä Peed kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananijas maa napäh bä m' Peed her'oot doo, adëë hyng mä tũũ, dajëp mäh. Ti m' sahõnh hẽ raky n'aa napäh bä m' ta tii, rajeỹỹm bong mä tak'ëp. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ti m' pahëëw wób rabana, rahabën däk mä ta hub, ti m' radakä jëng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nayyw hẽ denaa hẽ Ananijas makũ ỹỹm bajëë suun mä tób gó, Peed rabab'ëëh bä. Dooh m' ta heen n'aa nyy bä ta patug dajëp doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ti m' Peed eaanh ta hã: —Baad maher'ood hã ỹỹ —näng mäh. —Jããm né hẽ hahỹ tób säm, a patug daheeh bë gadoo doo? —näng mäh. —Ỹỹ. Ti né hẽ ta säm —näng mä ỹỹnh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ti m' Peed ky hadoo ta hã: —H'ëëd hyb n'aa bë kaner'oot bë metyy hyb n'aa P'op Hagä Do Sahee? —näng mäh. —Mahegãã, bok ta ti a patug dakä jëk doo. Õm da ramahũũm hỹỹ kä —näng mä Peed Sapira hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti m' Sapira badëë hyng Peed bagëët bä, dajëp mäh. Pahëëw hedoo do rabajëë p'ëë bä, rahapäh mä Sapira dajëp doo. Ti m' ramanyyh, radakä jëng ta patug makũ pa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ti m' sahõnh hẽ Jesus hã h'yy ka'eeh doo, ta wób heen n'aa enäh do na-ããj hẽ rajeỹỹm bok mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ti m' Jesus mejũũ doo, 12 hedoo doo, hajõng mä rapehuunh. Meuj n'aa näng do ramoo bok hajõk do sa mahang. Jesus hã h'yy ka'eeh do rakahet'aa mä tób P'op Hagä Do rayd hyb n'aa esee do yt hã, Saromãw häd näng doo bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta wób, ragenaag né paawä Jesus hã h'yy ka'eeh doo, dooh sa sii rakata bä, h'yyb e'ỹỹm do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ti hadoo né hẽ m' ajyy, ỹỹj, Jesus hã h'yy ka'eeh do ka'oot. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ti m' nahëë enäh do ramenaa tyw n'aa hahãd hã. Sa tyng jó m' radatoonh, Peed tabës bä, ta wób sa hã ta maëts badäng hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hajõk panang Jerusarẽnh nedaa bä haj'eenh do han'aa. Ramenaa nahëë enäh doo, karap'aar h'yyb nesaa do pahad'ëëk do na-ããj hẽ. Ti m' sahõnh hẽ rabaheso hõm. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät doo, Saduséw häd enäh do ta sii habong do na-ããj hẽ rah'yy kajewëëts kän Jesus mejũũ do sa wë. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ti m' rameso padëëk, ti m' ragadahew'ëës doo gó m' radewäts b'ëëh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ti m' atsëm, Tak'ëp Hyb N'aa Jawyk do ããs tanoo gasëëts nyyh mä Jesus mejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ti m' taky hadoo sa hã: —Bë ahõm nä P'op Hagä Do tób n'aa w'oo hã. T'ĩĩ hẽnh bë her'ood hajõk do sa hã hahỹ ji bawät do papuuj ky n'aa, ji h'yyb näm do Jesus an'oo däk do ky n'aa. Sahõnh hẽ bë her'ood sa hã —näng mä ããs kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ti m' tabawag hõm bä kä rabahõm P'op Hagä Do tób n'aa w'oo hã, ããs mejũũ doo da sa hã. Ti m' radu doo rama metëëk doo. Ti nuuj jé m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät doo, ta sii habong doo, ranaëënh sahõnh hẽ Isaraéw buuj sa wahë n'aa, séd hã rakata padëëk hyb n'aa. Sahõnh hẽ sa wahë n'aa ramaneëënh Sinedirijo. Tii bä m' ramejũũ rahahëën Jesus mejũũ do radewäts b'ëëh do paa bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ti m' warahén rakaja hõm bä t'ĩĩ hẽnh, dooh m' rawyyd bä. Ti m' rababaaj nä, raky n'aa manaa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ti m' raky hadoo: —Ãã kaja hõm bä, baad tanoo katsë. Ta noo bä warahén rabab'ëëh. Ãã noo gasëëts hõm bä, dooh ta gó hab'ëëh péh! —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","P'op Hagä Do tób n'aa hagã n'aa sa wahë n'aa, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa wób raky n'aa napäh bä m' tii, h'yyb manepëë boo m'. Ti m' rakaner'oot: —Nyy d' tii éh? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ti nuuj jé m' ta see kajaa, ti m' taky hadoo: —Ajyy bë dewäts b'ëëh do paa ti ab'ëëh P'op Hagä Do tób n'aa w'oo hã. Hajõk do hã rama metëëk —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ti m' P'op Hagä Do tób n'aa hagã n'aa sa wahë n'aa, ta sii moo bok do daheeh rahahëën mä 12 hedoo do Jesus mejũũ doo. Rakaja hõm bä, baad raber'oot sa sii, dooh m' rarahejã bä. Rajeỹỹm hajõk doo, Jesus mejũũ do sa kyyh maa new'ëë doo. Pä me ramakut red'oo do hyb n'aa, 12 hedoo do rarahejã bä paawä. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ti m' rakaja hõm bä, ramenaa Sinedirijo ajyy n'aa rabat'oonh bä, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do beaanh hyb n'aa sa hã. Ti m' ta ti ky hadoo sa hã: ");
INSERT INTO mbjNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Tak'ëp bë ãã mejũũ paa ãã ky n'aa jaw'yyk doo me, bë ma manetëëk hyb n'aa ta ti aj'yy ky n'aa. “Tabad'op hẽ da bë her'ood”, näk paa ãã kyyh bë hã. Ti hadoo né hẽ bë nabuj keh'ũũm. Sahõnh hẽ Jerusarẽnh buuj sa hã bë met'ëëg hõm nanäng Jesus ky n'aa. Ãã daj'ëëp ta ti aj'yy bë ky n'aa h'ũũm. Ãã hã bë ky n'aa tapaa —näng mä ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ti m' Peed, ta wób Jesus mejũũ do na-ããj hẽ raky hadoo: —Taw'ããts hẽ P'op Hagä Do kyyh ti ãã ky daheeh. Dooh tahaja bä ajyy sa kyyh ãã ky dahé bä, ãã hã ramejũũ do baad tanu nadëë bä P'op Hagä Do mejũũ do hã —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","—P'op Hagä Doo, ër wahë makũ rah'yy kaha'eeh doo, Jesus ganä wät dejëp do sa mahang tan'oo bä. Ti d' né hẽ Jesus bë epëëm däk do paa b'aa kajatsëk do hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","P'op Hagä Do wehëë däk tii. Hỹ pong jé tabasëëk tan'oo bä. P'op Hagä Do hub hẽnh tabasooh ta sii sahõnh hẽ tabag'ããs hyb n'aa tan'oo bä. Ji h'yyb tym dëëb tabahadoo P'op Hagä Do an'oo bä, P'op Hagä Do hã Isaraéw buuj rah'yy kawereem hyb n'aa Jesus an'oo bä, nesaa do sa h'yyb gó hanäng doo tabasog hõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ãã sahõnh hẽ ãã bahapäh ta tii. P'op Hagä Do Sahee, ta hã ky dah'eeh do sa hã P'op Hagä Do an'oo däk doo, ti na-ããj hẽ tahapäh sahõnh hẽ tii —näk mä Peed sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ti m' ramaa napäh bä m' Peed raher'oot doo, tak'ëp mä rakawajããn. Rakarẽn mä radej'ëëp. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ti m' Pariséw see sa mahang hawät do as'ëëg gëët mäh. Ti m' tabaher'oot sa hã. Gamarijéw mä ta häd. Mosees ky n'aa jaw'yyk do ma mehetëk do seeh. Hyb n'aa jawyk Isaraéw buuj sa mahang. Ti m' tamejũũ 12 hedoo do raman'yyh dó. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ti m' taky hadoo ta da hadoo do sa hã: —Bë maa newë këh ỹỹ, Isaraéw buuj —näng mäh. —Baad bë hyb n'aa newë bë bad'oo do sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","—Bë hyb n'aa newë p'ooj ub du n'aa doo, Tew-Das häd näng doo. Ky n'aa etsëëh paa m', tanooh. 400 ajyy tahyb n'aa pé ta sii habok do paah. Ti m' radajëëb kän. Radaj'ëëp jawén paa bä m', ta sii habok do paa ketyn bong. Tadajëp bä, ahëëj jëng sahõnh hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ta jawén, sahõnh hẽ häj n'aa babuuj rabetsén noo gó, du n'aa do ta see Judas häd näng doo, Garirej buuj. Ti hadoo né hẽ tii. Ta wób ta sii rababok. Ti na-ããj hẽ radajëëb kän. Ti m' ta sii habok do paa ketyn bong mä na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ti hyb n'aa ỹ baher'oot bë hã: Na maboh. Bë eréd rabahõm hyb n'aa. Aj'yy du n'aa do tado bä ti rametëëk doo, ti ramoo bok doo, tii b' gawatsik da —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","—P'op Hagä Do du n'aa do tado bä, dooh bë haja bä bë medug bä sa hã —näng mäh. —Baad bë matakä, ji hapäh mä ti P'op Hagä Do hã bë kamaj'ĩĩ —näng mä Gamarijéw kyyh sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ti m' raky daheeh ta kyyh. Ti hadoo né hẽ, 12 hedoo do ramenaa, ti m' ramejũũ rabahewyyh. Ti m' ramejũũ mä sa hã ranaher'oot hyb n'aa Jesus ky n'aa. Ti m' raberéd hõm rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti m' Jesus mejũũ do raban'yyh Sinedirijo sa mahang hab'ëëh do paah. Tseb'ee mä rabahewyyh jawén paa bä, P'op Hagä Do hyb n'aa gadoo rabahoop hyb n'aa Jesus hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ti m', P'op Hagä Do tób n'aa yt hã, sa tób hẽnh na-ããj hẽ raher'oot ta ä̃h hã had'yyt hẽ, rama metëëk Jesus, P'op Hagä Do H'yyb Däng Do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti noo gó Jesus hã h'yy ka'eeh do kah'ũũm. Sa mahang ti abong mä Judah buuj, ta s'ee hẽnh hena doo, Gereg kyyh her'oot doo. Ta ti m' ramaher'oot mä Jesus mejũũ do sa hã ta tii bä babuuj sa ky n'aa. Hahỹỹ da m' sa kyyh: —Patug tema bong do sa waa rabahetsëh doo bä, dooh ran'oo bä ãã sii habok do sa hã —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ti m' 12 hedoo do ramejũũ sahõnh hẽ Jesus hã h'yy ka'eeh do rakata padëëk séd hã, sa hã rabaher'oot hyb n'aa. Ti m' raky hadoo: —Dooh baad tado bä ãã eréd bä P'op Hagä Do kyyh ãã metëëk doo, sa waa ãã betsëëh hyb n'aa paawä. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ti hyb n'aa, wakãn haa, ãã karẽn bë esoos bë mahang ajyy bë hep'ëëh do h'yy genäh doo, P'op Hagä Do Sahee h'yyb mahũũm doo. Ti ãã mejũũ sa hã rabetsëëh hyb n'aa sa waa. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ãã né hẽ, ãã ky n'aa etsẽẽ, P'op Hagä Do sii ãã ber'oot. Ãã né hẽ ãã ma metëëk P'op Hagä Do ky n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ti m' baad mä sa hã raher'oot doo. Tii bä m' rasëm mä Es-Tew häd näng doo. Tak'ëp paa m' tah'yy ka'eeh P'op Hagä Do hã. Baad P'op Hagä Do Sahee h'yyb mahũũm mä tii. Hahỹỹ d' mä rasëm do wób sa häd: Pirip, Porokoro, Nikanóh, Timom, Paramenas, Nikoraw. Ãn-Tijoka panang häd näng doo hẽnh naa ta ti Nikoraw. Jesus hã tah'yy ka'eeh do pooj jé, Judah buuj nado né paawä, Mosees ky n'aa jaw'yyk do taky dahé däk Judah buuj rabahed'oo doo da. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ti m' rabasëm jawén paa bä, ramehũũm kän mä Jesus mejũũ do sa wë. Tii bä kä m', Jesus mejũũ do sa moo radatoonh sa nuu gó, raky n'aa etsẽẽ sa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ti m' P'op Hagä Do ky n'aa kah'ũũm. Nayyw hẽ Jerusarẽnh bä takah'ũũm Jesus hã h'yy ka'eeh doo. Hajõk P'op Hagä Do tób n'aa yt hã moo heb'ooh do wób rah'yy kae kän Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ti m', baad mä P'op Hagä Do hejój awät Es-Tew häd näng do h'yyb gó. Baad mä P'op Hagä Do ky n'aa edëng. Es-Tew pehuunh, meuj n'aa näng do heen n'aa tamoo wät hajõk do sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ti m' Judah buuj wób, ta wób sa karom paah, radu doo Es-Tew raky gedak. Ti asooh tsyt hẽ sa tób P'op Hagä Do panyyg ti rayd naherot do yt hã. Sa sii ti abong Sirené panang buuj wób, Aresãn-Dirija panang buuj wób, Siris häj n'aa buuj wób, Asija häj n'aa buuj wób. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Es-Tew mä raky hũũm paawä, dooh m' rahaja bä. Es-Tew P'op Hagä Do Sahee h'yy gan'yyh do hyb n'aa rawén nahajaa. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ti m' ramaher'oot ajyy wób sa hã, daap ramenyyh hyb n'aa Es-Tew ky n'aa. —Hahỹỹ da bë her'ood —näk mäh. —“Ãã maa napäh Mosees, P'op Hagä Do na-ããj hẽ Es-Tew ky n'aa rejãã doo”, denoo da —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ti m' Judah buuj, Judah buuj sa wahë n'aa, Mosees ky n'aa jaw'yyk do ma mehetëk do na-ããj hẽ rakawajããn Es-Tew wë ta ti ajyy sa kyyh hyb n'aa. Ti m' ramaso däk, ti m' ramahũũm Sinedirijo ajyy n'aa sa wë, sa wahë n'aa wë. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ti m' ramejũũ ta wób, noo kanesa doo, daap ramenyyh hyb n'aa Es-Tew ky n'aa sa wahë n'aa hã. Ti m' daap mehen'yyh do raky hadoo: —Dooh hahỹ aj'yy eréd bä taky n'aa rejãã do P'op Hagä Do tób n'aa, Mosees ky n'aa jaw'yyk do na-ããj hẽ —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","—Ãã maa napäh ta kyyh. P'op Hagä Do tób n'aa Jesus Nasaréh buuj ahäj jëng da, tanooh. Ky n'aa jaw'yyk do Mosees metëëk do Jesus ahỹỹd hõm da, tanooh —näk mä noo kanesa do sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ti m' sahõnh hẽ Sinedirijo ajyy n'aa, t'ĩĩ hẽnh hat'oonh doo, baad mä raty padëëk Es-Tew wë. Ta mamets, ããs mamets hado däk mä sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ti m' P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do eaanh Es-Tew hã: —Äkä, se hub né hẽ ta ti raher'oot do a ky n'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ti m' Es-Tew ky hadoo: —Wakãn haa, yp ỹ hyb n'aa hed'oo doo, bë maa newë këh ỹỹ —näng mäh. —P'op Hagä Doo, sahõnh hẽ sa bahä̃nh hadoo doo, kas'ee wät ër wahë makũ Abaraãm hã, Mesopotãm häd näng do häj n'aa bä Abaraãm bawät nä bä, Arãn panang hẽnh takahỹỹd gä do pooj jé. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Hahỹỹ d' paa m' P'op Hagä Do kyyh ta hã: “Maberéd däg mabawät do paah, a wakããn, a yb tób paah. Ahõm da hëëj s'ee hẽnh, õm ỹ metëëh hẽnh”, näng mä P'op Hagä Do ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ti m' taberéd däk Kaw-Dew sa häj n'aa, Mesopotãm häd näng doo, ti m' tabahõm Arãn panang häd näng doo hẽnh. Ta yb dajëp do jawén paa bä, P'op Hagä Do manaa wawẽẽ hẽ ër babong do häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dooh P'op Hagä Do an'oos pé ta hã, hëëj uuh hadoo pé paawä, taky n'aa enooh né hẽ paawä hahỹ hëëj ta panaa pan'aa sa häj n'aa pan'aa, Abaraãm dajëp jawén paa bä. Tii d' taky n'aa enooh ta hã, dooh nä né paawä Abaraãm t'aah nyy nä bä ti noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Hahỹỹ da P'op Hagä Do kyyh ta hã: “Sa häj n'aa nadoo hẽnh da a panaa rababok da. Tak'ëp da ramejũũ sa hã 400 ta baab noo gó. Ta si n'aa hẽ da ramoo bok da t'ĩĩ hẽnh. Rarahejãã da t'ĩĩ hẽnh a panaa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ỹ abaanh da ta säm ta tii d' moo hed'oo do sa hã. Ỹ rahejãã da. Ti jawén paa bä, tii b' naa a panaa rababaaj nä bä wawẽẽ hẽ. Babä ỹ rahyb n'aa jew'yyk da”, näng mä P'op Hagä Do kyyh Abaraãm hã —näng mä Es-Tew kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ti m' taky hadoo ẽnh: —Ti m' Abaraãm P'op Hagä Do mejũũ sa taah ramasuuj noo byyh ehõk, P'op Hagä Do karapee rabahadoo do heen n'aa. Ti hyb n'aa m' Abaraãm t'aah, Isak häd näng doo, 8 tabado däk bä ta ä̃h, Abaraãm masuuj noo byyh hõg hõm. Tii d' né hẽ kä Isak Jakóh yb. Jakóh kä, ta häd see Isaraéw, 12 hedoo do radu na do Isaraéw buuj sa panaa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ti né hẽ Jakóh taah, ër wahë makũũh, rahyb n'aa jewës do sa hỹỹj Joséh. Ti hyb n'aa rabesëëm hõm Esit häj n'aa hẽnh, ta si n'aa hẽ tamoo wät hyb n'aa t'ĩĩ hẽnh. Ti hadoo né hẽ, P'op Hagä Do hagãã had'yyt hẽ Joséh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Joséh P'op Hagä Do ed'ëëp sahõnh hẽ nesaa do mahä̃nh. Tah'yy gan'yyh. Baad Esit häj n'aa wahë n'aa, Paraóh ramaneëënh do gadoo, P'op Hagä Do an'oo bä. Ti hyb n'aa Paraóh an'oo bä kä sahõnh hẽ Esit häj n'aa hagã n'aa, ta tób hagã n'aa na-ããj hẽ tabahadoo hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ta jawén ji hasaah do bawäd kän Esit häj n'aa bä, Kanaãh häj n'aa bä na-ããj hẽ. Sahõnh hẽ m' rabahoop sah. Dooh m' ër wahë makũ sa waa rawyyd bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tii bä kä, Jakóh ky n'aa napäh bä joom s'ëëb Esit bä hanäng doo, tamejũũ ër wahë makũ t'ĩĩ hẽnh sa waa rabetsẽẽ hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti m', ta jawén, p'aa hẽnh t'ĩĩ hẽnh rabahõm bä kä sa waa hets'ẽẽ doo, Joséh baher'ood kän sa hã sa hỹỹj né hẽ. Tii bä Paraóh na-ããj hẽ heen n'aa nyy däk Joséh wakããn hã, Joséh yb hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tii bä kä m', Joséh mejũũ ramanaa ta yb, ta wakããn had'yyt hẽ Esit hẽnh. 75 sahõnh hẽ han'aa do paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ti m' Jakóh rakahỹỹd j'eenh Esit bä. T'ĩĩ hẽnh tadajëb kän. Tii b' né paa m' ër wahë makũ radejëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Sa kamag paa ramahũũm p'aa hẽnh Sikẽm panang hẽnh. Gabaho doo gó, Sikẽm bä Amoor taah sa hã Abaraãm ets'ẽẽ hõm do paa radaboo jëng sa kamag n'aa —näng mä Es-Tew kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ti m' taky hadoo ẽnh: —Tabedaa däk bä kä Abaraãm hã P'op Hagä Do ky n'aa enooh do kajaa doo, tak'ëp ër wahë makũ panaa rakaood bong Esit häj n'aa bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti m' ta see pé noo gó Esit häj n'aa wahë n'aa see tadu doo tabag'ããs doo. Dooh m' ta ti ky n'aa napëë bä Joséh makũũh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ta ti sa wahë n'aa tawedii ër wahëh makũũh, tarejãã na-ããj hẽ. Tamejũũ sa taah papuuj henyys do raberéd is, radejëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti noo gó m' tabenäng Mosees häd näng doo. Anäm ti karapee. Ta yb, ta ỹỹn rawä wät, rejën sa tób bä tamawoob hẽ kamarab. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ranahaja wäd bä rejën doo, raberéd tu ta hood gó jawii mahang. Tii bä kä, Paraóh toog rabawyyd kän, taw'ëëh mäh, ta t'aah hadoo tan'oo bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sahõnh hẽ Esit buuj rahajaa do rama metëëk ta hã. Tak'ëp tii bä kä tahyb n'aa jawyk taher'oot do hã, tamoo wät do hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","40 ta baab Mosees bahado däk bä, takarẽn tabaheg'ããs ta wakããn, Isaraéw buuj. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Takajaa bä, tahapäh ta wakããn see Esit buuj see rejãã. Ti hyb n'aa ta säm baanh. Tanaboh jat Esit buuj. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta h'yyb gó Mosees ed'oo, ta wakããn raheen n'aa enäh P'op Hagä Do ti mejũũ tabed'ëëp sa hã Esit buuj sa moo gó naa. Dooh rah'yy genä bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jat'iip hadoo tabahapäh pawóp hẽ Isaraéw buuj kep'uuk doo. Mosees karẽn paawä dooh ti d' radoo bä. “Wakããn haa”, näng, “bë wakããn had'yyt hẽ. H'ëëd hyb n'aa bë kamaj'ĩĩ?”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ta see rejãã do aũũj hõm mä Mosees, ti m' taky hadoo ta hã: “Jaa g'eeh hanoo ãã wahë n'aa, baad hadoo do baad nadoo do rod n'aa mabahadoo hyb n'aa? ");
INSERT INTO mbjNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ỹ makarẽn manaboh jat Esit buuj tsém hẽ manaboh jat doo da?”, näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ti m' aj'yy kyyh Mosees maa napäh bä, kejën hõm Midijãn häj n'aa hẽnh. T'ĩĩ hẽnh tabag'ëëd däg kän ta wakããn nadoo do sa mahang. T'ĩĩ hẽnh takat'ëë däk. Pawóp hẽ ta taah. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ti m' Es-Tew ky hadoo ẽnh: —40 ta baab jawén paa bä P'op Hagä Do ããs kasee Mosees hã tëëg hõõ gó, b'aa tũũ nu däg is do kadoo doo gó naa. Banawäng bä, waëë Sinaih häd näng do nedaa bä tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","B'aa kado né paawä, dooh m' taooj jëë bä Mosees bahapäh bä, tahyb n'aa meuunh mäh. T'ĩĩ hẽnh tabahõm bä, p'eets hẽ tabaheg'ããs hyb n'aa, tamaa napäh mä Tak'ëp Hyb N'aa Jawyk Do kyyh her'oot do ta hã: ");
INSERT INTO mbjNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ỹ né hẽ P'op Hagä Doo, a yb h'yy kaha'eeh doo. Ỹ né hẽ P'op Hagä Doo, Abaraãm, Isak, Jakóh rah'yy kaha'eeh doo”, näng mäh. Mosees kajajãn wät mä tak'ëp tabeỹỹm wät do hyb n'aa. Dooh tahegãã bä t'ĩĩ hẽnh, eỹỹm wät do hyb n'aa m'. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ti m' P'op Hagä Do ky hadoo ta hã: “Makabo nä a tsyym suun, majó gëët do k'ããts ma ỹ hadoo do hyb n'aa, tsyt hẽ takasëëw däk ti wë ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ỹ hapäh né hẽ ny hadoo karapé haa rarejãã do Esit häj n'aa bä. Ỹ maa napäh sa kyyh rah'yy kame'oot doo. Ti hyb n'aa hỹ pong jé naa ỹ bahyng ỹ bed'ëëp hyb n'aa Esit buuj sa moo gó naa. Ti hyb n'aa kä, Esit hẽnh õm ỹ mejũũ, karapé haa t'ĩĩ hẽnh naa mabasog nyyh hyb n'aa”, näng mä P'op Hagä Do kyyh Mosees hã, näng mä Es-Tew. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ti m' Es-Tew ky hadoo ẽnh: —Ti né hẽ ti Mosees ta wakããn raty n'aa ges'yyk do paah. “Jaa hanoo ãã wahë n'aa, baad hadoo do baad nadoo do rod n'aa mabahadoo hyb n'aa?”, näk paa sa kyyh ta hã. Ããs b'aa kadoo doo gó Mosees hã kasee do kyyh hã P'op Hagä Do mejũũ sa wahë n'aa pan'aa Mosees bahadoo hyb n'aa, Esit buuj sa moo gó naa ta wakããn tabed'ëëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ti né hẽ Mosees ër wahë makũ manyyh do Esit häj n'aa bä naa. Tapahuunh paa m', hyb n'aa meuj n'aa näng do tametëëh Esit bä, akajar Hahiin Do häd näng doo bä, tabanawäng bä na-ããj hẽ 40 ta baab noo gó m'. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ti né hẽ ti Mosees hahỹỹ da Isaraéw buuj hã ky hadoo doo: “P'op Hagä Do ky n'aa rod ỹ hadoo do P'op Hagä Do an'oo bä bë mahang ganyyh da.” ");
INSERT INTO mbjNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ti né hẽ ti Mosees Isaraéw buuj sa mahang hawät do paa tabanawäng bä rakata padëëk noo gó, waëë Sinaih häd näng doo bä ããs her'oot do gadoo doo. Ti né hẽ ti ër wahë makũ sa mahang hawäd wät doo. Ti né hẽ gadoo do paa P'op Hagä Do kyyh ji edëb had'yyt hẽ hanoo doo, ër wahë makũ sa hã tama metëëk hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ti hadoo né paa m', dooh paa m' ër wahë makũ raky dahé bä Mosees. Raty n'aa gesyyg wät mä Mosees. Rakarẽn mä rababaaj hõm p'aa hẽnh Esit hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ti m' ta hỹỹj hã, Arãw häd näng do hã ramejũũ: “Mamoo wäd ër h'yy kaha'eeh do pan'aa, ër pooj rababok hyb n'aa. Dooh ji hapëë bä h'ëëd hado ta ti aj'yy Mosees hã, Esit häj n'aa bä naa ër manyyh doo”, näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ti noo gó m' ramoo wäd kän kabariih, booj yb t'aah heen n'aa. Tii bä m' sa masããh wób raneboh bëëh, raju toonh kabarii sa mo haj'aa raweh'ëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ti hyb n'aa m' dawë hã P'op Hagä Do wén kanä däk sa mahä̃nh. Tanoo mä wë hã habong do rahyb n'aa jew'yyk. Ti hadoo né hẽ takerii däk P'op Hagä Do kyyh ta ky n'aa rod rerih do hã: “Isaraéw buuj, hã ỹ g'eeh ti bë banoo ta ti bë ejuu doo 40 ta baab banawäng hẽnh bë babok noo gó? ");
INSERT INTO mbjNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hã ỹ nado ti bë banoo. Bë kabarii Morók häd näng do tób n'aa its ti bë mahang bë manaa doo. Kabarii Repã häd näng do sagõõh n'aa hã bë h'yy kaha'eeh. Ta ti né hẽ kabarii bë mo haj'aa, sa hã bë h'yy ka'eeh hyb n'aa. Ti hyb n'aa bë ỹ ah'eed n'yyh da bë häj n'aa bä naa. Bë ỹ mejũũ da Babirõn panang bahä̃nh.” Tii da né hẽ P'op Hagä Do kyyh ta ky n'aa rod rerih do hã —näng mä Es-Tew kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ti m' Es-Tew ky hadoo ẽnh: —Tabanawäng bä ër wahë makũ rababok noo gó, P'op Hagä Do sa hã kahesé do tób n'aa ramahũũm mä sa sii. P'op Hagä Do mejũũ doo da Mosees hã, P'op Hagä Do metëëh do hadoo ta hã waëë hã, tii d' né paa ratama. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Josuwéh sa wahë n'aa tabahadoo noo gó, ër wahë makũ ramanaa sa sii ta ti tób hahỹ häj n'aa bä. Ti noo gó Josuwéh bado hõm ta wób sa häj n'aa, P'op Hagä Do habëë n'yyh do sa häj n'aa. Tii bä kä, ta ti tób ër häj n'aa bä aso had'yyt hẽ. Asooh nä paa m' na-ããj hẽ Dawi ër wahë makũ sa wahë n'aa tabahadoo noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Baad P'op Hagä Do hyb n'aa gadoo mä Dawi. Ti tetsẽẽ mä P'op Hagä Do hã, tanoo hyb n'aa P'op Hagä Do Jakóh panaa rah'yy kaha'eeh do tób n'aa pä s'ëëb tatamaa sooh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tii d' Dawi karẽn né paawä, ta t'aah Saromãw häd näng do tii, P'op Hagä Do tób n'aa tatamaa sooh doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ta tób n'aa tamoo wäd né paawä, dooh P'op Hagä Do Sahõnh Hẽ Sa Bahä̃nh Hadoo Do agëë bä tób ji tamaa sooh do yt hã. Tii d' né hẽ ta ky n'aa rod see her'oot paa P'op Hagä Do kyyh: ");
INSERT INTO mbjNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Wë, ỹ bag'ããs do tyng. Badäk hahỹ hëëj, tsym ỹ tyng hadoo. Tii d' tahadoo do hyb n'aa, ny hadoo pé tóp ỹ pan'aa ti bë karẽn ti bë tamaa sooh doo? Ny yt hã bë ed'oo ỹ kameh'ããk? ");
INSERT INTO mbjNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ỹ né hẽ sahõnh hẽ mo haj'aa näng doo”, näng mä P'op Hagä Do kyyh, näng mä Es-Tew. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ti m' Es-Tew ky hado kän Sinedirijo ajyy n'aa sa hã: —Nabuj keh'ũũm bëëh! Ganah'ood bë hã. P'op Hagä Do hã h'yy kana'eeh do h'yyb hadoo bë h'yyb. P'op Hagä Do hã h'yy kana'eeh doo, ta kyyh maa nanapäh do hadoo bëëh. Bë wahë makũ hadoo né bëëh. P'op Hagä Do Sahee hã bë kamaj'ĩĩ, bë wahë makũ rabad'oo do paa hadoo né hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sahõnh hẽ P'op Hagä Do ky n'aa rod p'ooj ub habong do bë wahë makũ rarejãã. P'op Hagä Do ky n'aa rod, P'op Hagä Do karẽn doo da hawät do kajaa do ky n'aa her'oot doo, bë wahë makũ radej'ëëp paah. Hỹỹ kä, Baad Had'op Do kajaa bä kä, bë h'yy kawareem ta wë, bë dajëëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ããs an'oo däg né paawä bë hã P'op Hagä Do ky n'aa jaw'yyk doo, dooh bë ky dahé bä —näng mä Es-Tew kyyh Sinedirijo ajyy n'aa sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ti m' Es-Tew kyyh ramaa napäh bä m', tak'ëp mä rah'yy gaẽẽj bong. Kawaj'ããn bong mä ta wë. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ti m' Es-Tew P'op Hagä Do Sahee baad tah'yyb mahũũm. Ti m' wë hã tabaheg'ããs, ti m' tabahapäh P'op Hagä Do hejój, ta bag tak'ëp gabarëëh do hadoo doo. Tahapäh Jesus hagëët do P'op Hagä Do hub hẽnh, takaweh'ëëh doo bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ti m' taky hadoo: —Bë hegãã! —näng mäh. —Wë kas'ëës do ỹ hapäh. Aj'yy Hadoo Do Hỹ Pong Jé Hana Do ỹ hapäh na-ããj hẽ, P'op Hagä Do hub hẽnh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ti m' sa nabuuj ragetsëë padëëk sa moo me. Tak'ëp mä rageëënh. Ta wë m' rawaj'aa padëëk. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ti m' Es-Tew rabado nyyh panang bä naa. Ti m' rabakut pä me, tadajëp hyb n'aa. Ti m' Es-Tew ky n'aa daap menyyh do sa hatsë hebaan doo, sa hã padëëk doo, rakebo bëëh rabakut hyb n'aa pä Es-Tew hã. Aj'yy wanehëh nä doo, Saw-Ru häd näng doo, enäm ti nuuj jé sa saroor hebaan doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ti m' rabakut bä, Es-Tew ky n'aa etsẽẽ mäh. Hahỹỹ d' mä ta kyyh: —Jesus, Hyb N'aa Jawyk Doo, magado hëp ỹ tym —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ti m' ta taron nu paa me tabahyy häng. Ti m' tak'ëp mä taky hadoo: —Jesus hyb n'aa jawyk doo, säm ỹ mabaaj manä sa hã —näng mäh. Ti m' tadajëb kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Taw'ããts mä Saw-Ru hã Es-Tew dajëp doo. Ti noo gó né hẽ m' radu doo rarejãã do Jesus hã h'yy ka'eeh doo, Jerusarẽnh panang bä. Ti hyb n'aa m', sahõnh hẽ Jesus hã h'yy ka'eeh do raketyn bong Judah häj n'aa bä, Samarija häj n'aa bä na-ããj hẽ. Jããm hẽ Jerusarẽnh bä ha'yym 12 hedoo do Jesus mejũũ doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ti m', Es-Tew radaj'ëëp jawén paa bä m', ta wób P'op Hagä Do weh'ëëh do rabahõm, radakä jëng hyb n'aa Es-Tew kamag n'aa. Tak'ëp mä rabaód bong ta hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saw-Ru kä, tarahejãã Jesus hã h'yy ka'eeh doo. Sahõnh hẽ tabaheg'ããs tób yt hã, Jesus hã h'yy ka'eeh do tabesoos hyb n'aa. Tamejũũ mä radewëës Jesus hã h'yy ka'eeh doo, ajyy ỹỹj sii hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ti m' ketyn bok do rabaher'oot Jesus ky n'aa ramahõm me. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ti m' sa seeh, Pirip häd näng doo, bahõm kän panang hẽnh Samarija häd näng do häj n'aa bä. T'ĩĩ hẽnh tabaher'oot sa hã Kristo, P'op Hagä Do H'yyb Däng Do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti m' panang buuj rabahapäh bä Pirip pehuunh doo, baad mä ramatakëë ta kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pirip hebë karap'aar h'yyb nesaa do sa h'yyb gó hanäng doo. Rabenyyh bä sa hã hanäng doo, tak'ëp mä rageëënh. Hajõk k'yy gedóm doo, seä̃k do heso hõm. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ti hyb n'aa tak'ëp panang buuj ratsebé. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pirip kaja pooj jé sa mahang ti awät aj'yy Simaw häd näng doo, mehëm do paah. Hajõk mä tawahed'ii Samarija buuj. Ta daaj hẽ, ta hã hẽ takasab'ee, ta hã hẽ tahyb n'aa jawyk do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sahõnh hẽ, hyb n'aa jewyk doo, hyb n'aa sekog is do na-ããj hẽ raky daheeh mä ta kyyh. Hahỹỹ d' mä sa kyyh ta ky n'aa: —Ta ti aj'yy gó P'op Hagä Do hejój tak'ëp hadoo do kametëëh —sa nooh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bäp peej däg tamehëm doo me panang buuj Simaw wedii, rawén ky sũũt. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pirip kajaa bä kä, taher'oot mä sa hã P'op Hagä Do ji tabag'ããs do ky n'aa hanäm doo, Jesus Kristo ky n'aa hanäm do na-ããj hẽ. Ti m' raky daheeh bä Jesus ky n'aa, ranu gemuun hõm ajyy ỹỹj na-ããj hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mehëm do paa na-ããj hẽ taky daheeh Jesus ky n'aa. Ti sii hẽ ranu gemuun wät. Ti m' jé pad'yyt hẽ tabawäd däg kän Pirip sii. Tameuunh tak'ëp Pirip pehuunh doo, hyb n'aa meuj n'aa näng do tahapäh do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ti m' Jesus mejũũ do Jerusarẽnh bä haj'eenh do raheen n'aa enäh bä m' Samarija buuj raky daheeh do P'op Hagä Do ky n'aa, ramejũũ mä Peed Jowãw daheeh, t'ĩĩ hẽnh rabaheg'ããs hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Rakaja hõm bä t'ĩĩ hẽnh, raky n'aa etsẽẽ Samarija buuj Jesus hã rah'yy ka'eeh do sa hyb n'aa, P'op Hagä Do banoo hyb n'aa ta Sahee sa h'yyb gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Dooh nä P'op Hagä Do Sahee sa h'yyb gó, ranu gemuun up Jesus, Hyb N'aa Jawyk Do häd gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ti m' Peed Jowãw daheeh moo tooj wät mä sa nuu gó. Ti m' P'op Hagä Do Sahee bajëë suun kän mä sa h'yyb tym gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ti m' Simaw mehëm do paa bahapäh bä P'op Hagä Do Sahee sa h'yyb tym gó hajëng do ramoo toonh bä sa nuu gó, takarẽn paawä m' tanoo sa hã dajẽẽr, tii d' ranoo tabahajaa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Hahỹỹ d' mä ta kyyh Peed sa hã: —Bë an'oo hã ỹỹ, tii da ỹ bahajaa hyb n'aa, ỹ moo sooh bä sa nuu gó, P'op Hagä Do Sahee bajëng hyb n'aa sa h'yyb tym gó —näng mä mehëm do paa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ti m' Peed ky hadoo: —Taw'ããts hẽ paawä õm a dajẽẽr daheeh P'op Hagä Do aw'oong hõm baad tanadoo hẽnh, ji matym n'aa ji hã P'op Hagä Do anoo do makarẽn metsẽẽ do hyb n'aa dajẽẽr me —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Baad nado a h'yyb tym P'op Hagä Do matym gó. Ti hyb n'aa dooh ãã sii mamoo wäd bä —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","—Meréd hõm ta ti nesaa doo, tii d' mabahed'oo doo da. Maky n'aa ets'ẽẽ P'op Hagä Do hã. Tii bä da apäh õm tat'yyd mehĩĩn, tii bä da apäh nesaa do mahyb n'aa newëë do tado hõm. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ỹ hapäh né hẽ a h'yyb gó hanäng doo. Õm h'yy gaẽẽnh mah'yy kajew'ëës do hyb n'aa. Nesaa do õm tah'yyb mahũũm. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ti m' Simaw ky hadoo: —Ỹ karẽn paawä bë ky n'aa ets'ẽẽ hëp ỹ n'aa, bë her'oot do tanadäng hyb n'aa hã ỹỹ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ti m' Jesus ky n'aa raher'oot jawén paa bä, P'op Hagä Do kyyh rametëëk jawén paa bä, Peed Jowãw daheeh rababaaj hõm kän Jerusarẽnh hẽnh. Samarija buuj sa panang bä ramabaaj hõm me, ranu kejäk doo bä, raher'oot Jesus panyyg hanäm doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ti m', ta jawén Tak'ëp Hyb N'aa Jawyk Do ããs see her'ood kän mä Pirip hã. Ti m' ããs ky hadoo: —Ahõm banawäng do tyw n'aa me Gasa hẽnh hahyng do Jerusarẽnh bä naa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ti m' Pirip bahõm kän. Ta tyw n'aa me takataa mä aj'yy hã, Etsijop häj n'aa buuj. Hyb n'aa jawyk ti aj'yy. Etsijop buuj sa wahë n'aa ỹỹnh, Kãn-Das häd näng do kaser n'aa. Sa wahë n'aa dajẽẽr hagã n'aa ti aj'yy. Jerusarẽnh hẽnh tahewäd nä, P'op Hagä Do tahyb n'aa esee do hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tamabaaj nä me kä, ta hood gó kawaaro takyyk doo gó tabasooh bä, taner'oot P'op Hagä Do ky n'aa rod Isajas häd näng do erih do paah. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ti m' P'op Hagä Do Sahee ber'oot Pirip h'yyb gó: —Ahõm nä ta wë —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ti m' takata däk bä ta hã, tamaa napäh taner'oot do Isajas erih do paah. Ti m' tabeaanh ta hã: —Äkä, mamaa napäh ti maner'oot doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ti m' aj'yy hadoo do ky hadoo Pirip hã: —Nyy da ti ỹ maa napäh? Dooh metëëk pé hã ỹ ta ky n'aa —näng mäh. Ti m' tabatsyyd kän Pirip gatsëg sooh hyb n'aa ta pa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hahỹỹ d' ti aj'yy ner'oot doo: “B'éé radaj'ëëp do hadoo ta tii. B'éé t'aah hadoo, dooh ta kyy pé ta wii ragekãã bä. Ti hadoo tii. Dooh ter'ood bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Rarejãã, rej'ees ta ky n'aa. Sahõnh hẽ tak'ëp baad nadoo do ramoo bok ta hã. Dooh P'op Hagä Do ky n'aa jaw'yyk doo da tado bä ti ramoo bok ta hã. Dooh da her'oot pé ta panaa ky n'aa, radaj'ëëp do hyb n'aa.” ");
INSERT INTO mbjNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ti m' aj'yy beaanh Pirip hã: —Jaa ky n'aa Isajas her'oot? Ta daaj hẽ ta ky n'aa, ta see ky n'aa apäh? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ti m' Pirip du doo taher'oot do taner'oot do hã, P'op Hagä Do kyyh see hã, sahõnh hẽ Jesus panyyg hanäm do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ti m' ratabës bä naëng banäng bä aj'yy ky hadoo: —Babä ti majat naëng —näng mäh. —Tahajaa ỹ manu gemuun? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ti m' Pirip ky hadoo: —Tak'ëp mah'yy kae bä, tahajaa —näng mäh. Ti m' aj'yy ky hadoo: —Ỹ ky daheeh. P'op Hagä Do t'aah né hẽ Jesus Kristo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ti m' aj'yy mejũũ ta sii habok do rabaym hyb n'aa. Tii bä kä m', rabawëëj bëëj kän tame. Ti m' Pirip nu gemuun wäd kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ti m' rabas'oob n'yyh bä tame naa Pirip P'op Hagä Do Sahee mahũũm kän. Dooh aj'yy hapëë wäd bä. Ahõm kän mä tahahõm hẽnh. Tsebé mä tahõm bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ti m' Pirip ganä wät panang Asot häd näng doo bä. Ti m' tabahõm kän Sesareja hẽnh. Tamahõm me m' taher'oot Jesus panyyg hanäm do sahõnh hẽ panang bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ti noo gó né hẽ Saw-Ru h'yy kaneréd tahehõ Jesus hã h'yy ka'eeh doo, tadej'ëëp hyb n'aa. Ti hyb n'aa P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa heh'äät do hã ");
INSERT INTO mbjNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tetsẽẽ rerih do raky n'aa jaw'yyk doo, tabahõm hyb n'aa panang Damas-Ko häd näng doo hẽnh. T'ĩĩ hẽnh takarẽn paawä tametëëh kerih doo, tób P'op Hagä Do panyyg rayd naherot do yt hã, tamoo mesoo hyb n'aa paawä, tamanaa hyb n'aa paawä Jesus hã h'yy ka'eeh do Jerusarẽnh hẽnh. Takarẽn paawä tamanaa ajyy ỹỹj sii hẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ti m' tabedaa däk bä Damas-Ko, tii bä gabarëëh do ta bag p'op naa gabar'ëëng wät ta hahãd hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tũũ m' tabadëë jat tii bä. Ti m' tamaa napäh kyyh ta hã her'oot doo: —Saw-Ru, Saw-Ru, h'ëëd hyb n'aa ỹ marejãã? ");
INSERT INTO mbjNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Jaa õm Tak'ëp Hyb N'aa Jawyk Doo? —näng mä Saw-Ru. —Ỹ né hẽ, Jesus marejãã doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","—As'ëëg g'ëëd! Ahõm nä panang hẽnh. T'ĩĩ hẽnh rabaher'oot a hã nyy da mabad'oo do pan'aa —näng mä Jesus kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ta sii habok do ramaa napëë né paawä ta ti kyyh, dooh m' rahapäh péh. Ti hyb n'aa rah'yyb panado bong. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tii bä m' Saw-Ru as'ëëg gëët. Tahegãã paawä, dooh tahapëë wäd bä. Ti hyb n'aa ramoo maso hõm tabawät hyb n'aa. Ti m' ramahũũm kän Damas-Ko panang hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","T'ĩĩ hẽnh nawa wäd, neëg wäd, ty tamaa wäd, tamawoob hẽ m' ta ä̃h. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ti m', Damas-Ko bä ti awät mä Jesus hã h'yy ka'eeh do seeh, Ananijas häd näng doo. Ti m' Jesus kasee ta hã ta s'ëëh hadoo doo gó. Ti m' Jesus ky hadoo ta hã: —Ananijas —näng mäh. —H'ëëd? Bä agëët ỹỹh, Jesus, Hyb N'aa Jawyk Doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ti m' Jesus ky hadoo ta hã: —Ahõm aj'yy Judas häd näng do tób hẽnh. Ta tyw n'aa “Dajang Doo” häd ramaneëënh do hahãd hã ta tób basooh. T'ĩĩ hẽnh mameaaj aj'yy Saw-Ru häd näng doo, Tas hẽnh naa. P'op Hagä Do hã taky n'aa etsẽẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ta s'ëëh hadoo doo gó tahapäh aj'yy Ananijas häd näng do hajëë suun doo, ta nuu gó ta mooh tadasooh doo, p'aa hẽnh tabahapëë däk hyb n'aa —näng mä Jesus Ananijas hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ti m' Jesus kyyh tamaa napäh bä m', Ananijas ky hadoo: —Wahëh ỹ n'aa, hajõng ta ky n'aa raher'oot hã ỹỹ. Sahõnh hẽ ỹ ky n'aa napäh nesaa do tamoo wät do Jerusarẽnh bä, a hã h'yy ka'eeh do sa hã —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","—Wawẽẽ hẽ tabana hỹỹ kä. P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa raky n'aa jaw'yyk doo me tabana, tadewäts bëëh hyb n'aa a häd gó h'yy ka'eeh doo —näng mä Ananijas kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ti m' Jesus ky hadoo ta hã: —Ahõm nä. Ahõm né hẽ t'ĩĩ hẽnh. Ỹ asëëw däk panäk ỹ n'aa tabahadoo hyb n'aa, këh ỹ n'aa tabaher'oot hyb n'aa Judah buuj nadoo do sa hã, sa wahë n'aa sa hã, Isaraéw buuj sa hã na-ããj hẽ —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","—Ỹ metëëh da ta hã tak'ëp tabahoop do pan'aa hëp ỹ n'aa —näng mä Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ti m' Ananijas bahõm kän Saw-Ru yt gä doo hẽnh. Tabajëë suun jawén paa bä m', ta moo tadasooh Saw-Ru nuu gó. Ti m' taky hadoo ta hã: —Saw-Ru, wakãn ỹ hado däk õm hỹỹ kä —näng mäh. —Jesus, Hyb N'aa Jawyk Doo, ta tyw n'aa me a hã kasee doo, ti né hẽ ỹ tamejũũ a wë ỹ bana hyb n'aa, p'aa hẽnh mabahapëë däk hyb n'aa, P'op Hagä Do Sahee a h'yyb tym gó tabajëng hyb n'aa —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ti m' nayyw hẽ m' Saw-Ru matym gó naa kajäg bëëh tah'ỹỹb päd hadoo. Ti m' p'aa hẽnh tabahapëë däg kän. Ti m' tabas'ëëg gëët, ti m' ranu gemuun wät. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ti m' tabawëh jawén paa bä m', h'yyb hejooj däg kän p'aa hẽnh. Ti m' Damas-Ko panang bä tabaym dó Jesus hã h'yy ka'eeh do sa mahang. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ti m', nayyw hẽ Saw-Ru du doo taher'oot do tób P'op Hagä Do panyyg rayd naherot do yt hã. P'op Hagä Do T'aah né hẽ Jesus, tamaher'oot mä kat'aa do sa hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sahõnh hẽ maa new'ëë do rahyb n'aa meuunh mäh. Hahỹỹ d' mä raky n'aa her'ood bong: —Ti né pa doo aj'yy Jesus häd gó h'yy ka'eeh do rejãã do Jerusarẽnh bä. Ti né paa wawẽẽ hẽ hana doo, Jesus hã h'yy ka'eeh do Jerusarẽnh hẽnh tamahũũm hyb n'aa, P'op Hagä Do tób n'aa yt hã moo heb'ooh do sa wahë n'aa sa moo gó tahaëënh hyb n'aa? —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ky n'aa jawyk doo me Saw-Ru her'ood magyys hẽ tii bä sa hã. Jesus né hẽ ti P'op Hagä Do Ky Däng Doo, baad ub tametëëh sa hã. Ti hyb n'aa Judah buuj Damas-Ko bä haj'eenh do h'yyb manepëë bong ta kyyh hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ti m', hajõõ ta ä̃ jawén paa bä Judah buuj rakaner'oot radaj'ëëp hyb n'aa Saw-Ru. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ti hadoo né hẽ, Saw-Ru ky n'aa napäh rakaner'oot doo. Adëb bä, atsëm na-ããj hẽ ta majĩĩ ragada sa panang tyw n'aa noo bä, radaj'ëëp hyb n'aa paawä m'. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ti m' Saw-Ru Jesus hã h'yy ka'eeh do rabah'yyh ta hadë n'aa hã naa arook gó. Tii bä kä m' tabahõm kän. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Takaja hõm bä Jerusarẽnh hẽnh, takarẽn paawä m' Jesus hã h'yy ka'eeh do sa mahang tabawäd däk. Sahõnh hẽ Jesus hã h'yy ka'eeh do rajeỹỹm mä ta hã. Dooh raky dahé bä te hub tado bä Jesus hã Saw-Ru h'yy ka'eeh doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ti m' Jesus hã h'yy ka'eeh do seeh, Béh-Nabéh häd näng doo, mahũũm mä Saw-Ru, tametëëh hyb n'aa Jesus mejũũ do sa hã. Béh-Nabéh her'oot sa hã Jesus kasee do Saw-Ru hã ta tyw n'aa me Damas-Ko hẽnh tahahõm noo gó ky n'aa, Saw-Ru hã Jesus her'oot do ky n'aa na-ããj hẽ. Béh-Nabéh her'oot na-ããj hẽ sa hã, nyy da h'yyb neỹỹm doo me Jesus ky n'aa Damas-Ko bä Saw-Ru her'ood wät. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ti m' Saw-Ru bayyw kän Jerusarẽnh hẽnh. Jesus hã h'yy ka'eeh do sa mahang tabawäd däg kän. Neỹỹm doo me Tak'ëp Hyb N'aa Jawyk do häd gó tabaher'oot Jesus ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ti m' tabaher'oot Judah buuj ta s'ee hẽnh hena doo, Gereg kyyh her'oot do sa hã. Ky kedak sa sii. Ti m' rakarẽn paawä m' radaj'ëëp. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ti m' Jesus hã h'yy ka'eeh do raky n'aa napäh bä radaj'ëëp rakarẽn doo, ramahũũm kän Saw-Ru panang Sesareja häd näng doo hẽnh. Tii b' naa ramejũũ panang Tas häd näng doo hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ti m' baad rababok Jesus hã h'yy ka'eeh doo, Judah häj n'aa bä, Garirej häj n'aa bä, Samarija häj n'aa bä habong doo. Dooh rarejã bä. Ti m' baad rah'yy kae kän, dooh rah'yyb eỹỹm bä P'op Hagä Do Sahee an'oo bä. Jesus hã h'yy ka'eeh do kah'ũũm P'op Hagä Do Sahee an'oo bä. P'op Hagä Do hã raweh'ëëh baad rababok do hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ti m' sahõnh hẽ panang Peed beg'ããs, Jesus hã h'yy ka'eeh do tabahehëën hyb n'aa. Tamahõm me tabeg'ããs Jesus hã h'yy ka'eeh doo, panang Rida häd näng do bä habong doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","T'ĩĩ hẽnh tamamuun aj'yy Enejas häd näng doo. K'yy gadóm mä tii. 8 ta baab tabasooh ta tyng jó. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ti m' Peed ky hadoo ta hã: —Enejas, Jesus Kristo õm tahaso däk —näng mäh. —As'ëëg g'ëëd, menyyw a tyng majasooh doo —näng mäh. Ti m' nayyw hẽ Enejas bas'ëëg gëët. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ti m' Rida panang buuj, Sarõn panang buuj na-ããj hẽ, rabahapäh bä kä Enejas has'oo däk doo, rah'yy kae kän Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ti noo gó, panang Jopéh häd näng doo bä, ti awät ỹỹnh Jesus hã h'yy ka'eeh doo. Ta häd mä Tabita. Gereg kyyh ramaneëënh mä Doh-Kas. Baad mä tamoo wät, tamasaa had'yyt hẽ kas'uut doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ti noo gó kä ta nahëë näng, ti tadajëp. Ti m' rabahets'yyt ta kamag n'aa paah, ti m' ramasäg kän ta gawakõ p'op gadäk doo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ti m' Rida panang bä Peed bawät Jopéh buuj Jesus hã h'yy ka'eeh do raky n'aa napäh bä, ramejũũ pawóp hẽ ajyy Peed rabats'yyt hyb n'aa. Jopéh nedaa bä ti Rida panang. Ti m' rakajaa bä raky hadoo Peed hã: —Nayyw hẽ ãã karẽn mabahõm Jopéh hẽnh —näk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ti m' Peed bahõm kän sa sii. Takajaa bä m' ramasäg kän kamag hasooh hẽnh. Ti m' ỹỹj patug tema bok do Peed hã ranu sabug däk. Raba'oot bä m' rametëëh ta hã tamo haj'aa paa sa saroor tahedëp noo gó. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ti m' Peed mejũũ mä raban'yyh dó. Ta taron nu paa me m' tabahyy häng, taky n'aa etsẽẽ mäh. Taheg'ããs kamag wë, ti m' taky hadoo: —Tabita, as'ëëg g'ëëd! —näng mä Peed. Tabita begãã däk mä tii bä. Peed tabahapäh bä, nu gas'ëëg sooh. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ti m' Peed moo ej'ooj sëëk. Ti m' tanaëëj kän mä Jesus hã h'yy ka'eeh doo, patug tema bok doo. Tametëëh sa hã tabedëb däk bä kä. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jé pad'yyt hẽ Jopéh panang bä raky n'aa napäh ta tii, ti hyb n'aa m' hajõk rah'yy kae kän mä Jesus hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ti m' Peed bayyw g'ëëd kän hajõng ta ä̃h ta ti panang bä, Simaw, sa masããh byyh s'ëëb tahem'aa do tób bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Panang Sesareja häd näng doo bä m' ti awät mä aj'yy Kóh-Nerijo häd näng doo. Isaraéw buuj nado m' tii. Roma buuj warahén n'aa 100 hadoo do sa wahë n'aa. Itarija warahén n'aa t'ĩĩ hẽnh kat'aa do sa häd. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","P'op Hagä Do hã Kóh-Nerijo h'yy ka'eeh, Judah buuj rah'yy ka'eeh do hadoo. Sahõnh hẽ ta tób yt haj'eenh do rah'yy ka'eeh na-ããj hẽ P'op Hagä Do hã. Kóh-Nerijo heno mä dajẽẽr kas'uut do Judah buuj sa mahang habong do sa hã. P'op Hagä Do hã m' taky n'aa hetsẽ. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ti m', ta see pé noo gó m', tug bä m', ta s'ëëh hadoo do tabahapäh. Ta s'ëë gó baad mä tabahapäh P'op Hagä Do ããs ta wë hana doo. Hahỹỹ d' ããs kyyh ta hã: —Kóh-Nerijo —näng mäh. Ti m' h'yyb eỹỹm doo me Kóh-Nerijo heg'ããs ããs wë, ti m' taky hadoo: —H'ëëd, tak'ëp hyb n'aa jawyk doo? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ti m' ããs ky hadoo: —P'op Hagä Do gadoo a kyyh ta hã maky n'aa hetsẽ doo. Tahapäh na-ããj hẽ kas'uut do sa matym n'aa sa hã maheno doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","—Mamejõ a sii moo heb'ooh do wób Jopéh hẽnh rabahõm hyb n'aa, aj'yy Simaw Peed häd näng do ramanaa hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simaw, sa masããh byy s'ëëb tahem'aa do tób bä tabagä. Akajar nabyy me ta tób basooh —näng mä ããs kyyh ta hã. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ti m' ããs dawuh jawén paa bä kä m', Kóh-Nerijo naëënh pawóp hẽ ta sii moo heb'ook doo, warahén see sii hẽ P'op Hagä Do hã h'yy ka'eeh doo. Ta karom see né hẽ m' ti warahén. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ti m' taher'oot sa hã sahõnh hẽ tahapäh doo. Ti m' tamejũũ Jopéh panang hẽnh rabahõm hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ti m' jati péh, Kóh-Nerijo mejũũ do rabedaa däk bä Jopéh hẽnh, Peed basëëk tób jó, basatẽ doo bä, taky n'aa etsẽẽ hyb n'aa. Wasyk mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Asa däk mäh. Takarẽn paawä m' ta tä tabawëh. Ta tä ramoo boo nuuj jé m' s'ëëh hadoo tahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ti m' ta s'ëëh hadoo doo gó m' tahapäh wë noo kas'ëës doo. Ti m' hỹ pong jé naa ta hood pããn hadoo do bahyng tabagëët bä. Ta sasu hã ta hood pããn kamewyyt. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ta gó tabanäng mä har'ëëng, tababo n'aa, taw'ëëd sii hẽ. Ta mahang ti anäng Judah buuj raky n'aa jaw'yyk do hyb n'aa ranawëh doo. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ti m' tamaa napäh kyyh her'oot do ta hã: —As'ëëg g'ëëd. Manaboh a tä —näng mäh. Ti m' Peed ky hadoo: ");
INSERT INTO mbjNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Dooh Tak'ëp Hyb N'aa Jawyk Doo. Dooh ỹ hewë bä nesaa doo, maganen'aak doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ti m' kyyh ber'oot p'aa hẽnh: —Mamaneëëj manä nesaa doo me, baad tabahado däk P'op Hagä Do anoo doo —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tamawoob nuu me m' ta ti kyy ber'oot ta hã. Ti m' nayyw hẽ hỹ pong jé pããn hadoo do basëëk p'aa hẽnh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ti m' Peed hyb n'aa newëë nyy d' tahanäng pé ti ta s'ëëh. Ti nuuj jé né hẽ m' Kóh-Nerijo mejũũ do rakajaa Simaw häd näng do tób noo bä. Ramana me m' rabeaanh Simaw tób. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ti m' rabeaaj kän Peed tagëë bä. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ti m' Peed hyb n'aa newëë nä bä ta s'ëëh hadoo doo, P'op Hagä Do Sahee ky hadoo ta hã ta h'yyb gó: —Tamawoob hẽ ajyy õm resoos —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","—As'ëëg g'ëëd, ahyy sa wë. Ahõm né hẽ sa sii, ỹ né hẽ mejũũ a wë rabana hyb n'aa —näng mä P'op Hagä Do Sahee. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ti m' Peed bahyy kän sa wë. Ti m' taky hadoo sa hã: —Ỹ né hẽ bë eaanh doo —näng mäh. —H'ëëd hyb n'aa bë wén n'aa? —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ti m' ajyy raky hadoo: —Kóh-Nerijo häd näng doo, 100 hedoo do warahén sa wahë n'aa seeh, ãã tamejũũ —näk mäh. —P'op Hagä Do hã tah'yy ka'eeh. Baad hadoo do moo hew'ëët do ta ti aj'yy. Sahõnh hẽ Judah buuj raj'aa etsë ta hã. P'op Hagä Do ããs see kas'ee wät mä ta hã. Ta hã tamejũũ mä õm ranaëënh hyb n'aa, ta tób hẽnh mabeg'ããs hyb n'aa, ta hã mabaher'oot hyb n'aa P'op Hagä Do ky n'aa —näk mä sa kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ti m' Peed batsyyd kän tób hẽnh, t'ĩĩ hẽnh rabawëh, raba'ỹỹh hyb n'aa. Ti m' jati pé Peed bahõm kän sa sii. Jesus hã h'yy ka'eeh do wób, Jopéh panang bä habong do rahada mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ti m' jat'iip hadoo rakajaa Sesareja panang bä. T'ĩĩ hẽnh Kóh-Nerijo, ta wakããn, ta najiis tats'yyt do ragada mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ti m' Peed kajaa bä Kóh-Nerijo tób bä, Kóh-Nerijo ahyy häng tũũ ta taron nu paa me, Peed taweh'ëëh hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ti m' Peed mejũũ tabas'ëëg gëët hyb n'aa, ti m' taky hadoo ta hã: —As'ëëg g'ëëd! —näng mäh. —Aj'yy ỹỹh. A da hadoo do né hẽ ỹỹh. P'op Hagä Do nado ỹ hỹỹh —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ti m' Peed ber'oot bä m' ta sii, ajëë suun mä tób gó. Ti m' hajõk do t'ĩĩ hẽnh kat'aa do tabahapäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ti m' taky hadoo sa hã: —Bë hapäh né hẽ, Judah buuj raky n'aa jaw'yyk do dooh tan'oo bä Judah buuj nadoo do mahang Judah buuj raboo bä. Dooh tan'oo bä sa tób yt hã Judah buuj ajëë suun bä. Ti hadoo né hẽ, s'ëëh hadoo doo gó ỹ P'op Hagä Do metëëk ỹ mananeëënh hyb n'aa baad nadoo doo, P'op Hagä Do ganadoo doo, ta wób —näng mäh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","—Ti hyb n'aa ỹ ranaëëj bä, ỹ gadoo ỹ rats'yyt doo. Nayyw hẽ ỹ bana —näng mäh. —Maher'ood h'ëëd hyb n'aa ỹ maneëënh —näng mä Peed kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ti m' Kóh-Nerijo ky hadoo: —Ji meheet pé ta ä̃ däg, da hẽ, tug bä ỹ ky n'aa etsẽẽ bä, tii bä pój ỹỹ jé takasee aj'yy. Gabarëëh ta saroor. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ti taky hadoo hã ỹỹ: “P'op Hagä Do maa napäh a kyyh ta hã maky n'aa hetsẽ doo. Tahapäh na-ããj hẽ kas'uut do sa matym n'aa sa hã maheno doo”, näng. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","“Mamejõ a sii moo heb'ooh do wób Jopéh hẽnh rabahõm hyb n'aa, aj'yy Simaw Peed häd näng do ramanaa hyb n'aa. Simaw, sa masããh byy s'ëëb tahem'aa do tób bä tabagä. Akajar nabyy me ta tób basooh”, näng ããs kyyh hã ỹỹ. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ti hyb n'aa nayyw hẽ ỹ mejũũ õm ranaëënh hyb n'aa. Baad tanyy né hẽ ti mabana —näng mäh. —Sahõnh hẽ ãã kata däk P'op Hagä Do matym gó, ãã matakëë hyb n'aa P'op Hagä Do mejũũ do maher'oot do ãã hã —näng mä Kóh-Nerijo kyyh. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Ti m' Peed du do kän taher'oot do sa hã: —Baad ỹ bahapäh hỹỹ kä, sahõnh hẽ badäk hahỹ haw'ããts hẽ häj n'aa babuuj ta hã h'yy ka'eeh doo, baad hadoo do moo b'ook do P'op Hagä Do gadoo. Séd hã ji P'op Hagä Do gadoo —näng mä Peed. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ti m' taky hadoo ẽnh: —Bë ky n'aa napäh P'op Hagä Do taher'oot do ãã hã, Isaraéw buuj sa hã: Jesus Kristo dajëp ji hyb n'aa. Ti hyb n'aa dooh P'op Hagä Do majĩĩ ji do boo bä. Tahajaa ta najiis ji hado däg bä hỹỹ kä. Sahõnh hẽ badäk hahỹỹ hã habong do sa wahëh ti Jesus. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bë ky n'aa napäh né hẽ Jesus moo wäd wät do Judah häj n'aa bä, Jowãw nu gahem'uun do her'oot do jawén paa bä Garirej häj n'aa bä ji nu gemuun hõm do ky n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","P'op Hagä Do hejój, ta Sahee na-ããj hẽ Jesus Nasaréh buuj tah'yyb mahũũm, P'op Hagä Do an'oo bä. Jé pad'yyt hẽ baad hadoo do Jesus moo wäd wät. Taheso sahõnh hẽ Dijab rejãã doo. Sahõnh hẽ ta ti Jesus bahajaa, ta sii P'op Hagä Do bawät do hyb n'aa. Bë ky n'aa napäh né hẽ ta tii. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Baad ãã bahapäh sahõnh hẽ Jesus moo wäd wät do Judah buuj sa häj n'aa bä, Jerusarẽnh panang bä na-ããj hẽ. Ti hyb n'aa ãã wén her'oot ãã hapäh doo. Ta jawén kä rabepëëm däk b'aa hã kajatsëk do hã, tadajëp hyb n'aa. ");
INSERT INTO mbjNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tadajëp jawén paa bä, tamawoob däg ta ä̃h, taganä wät P'op Hagä Do an'oo bä. Ta jawén takas'ee kän ãã hã P'op Hagä Do 