﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbi_vpl;
CREATE TABLE mbi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbi_vpl WRITE;
INSERT INTO mbi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ini se guhud te kepuun ni Hisu Kristu, kevuwaran ni David wey kevuwaran dema ni Abraham. ");
INSERT INTO mbi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham ke amey ni Isaac, ne si Isaac ne amey ni Jacob, si Jacob ne amey ni Hudah wey ke menge suled din. ");
INSERT INTO mbi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne si Hudah ne amey en ni Paris ki Sara, (si Tamar ke iney ran); ne si Paris ne amey ni Iserum, ne si Iserum ne amey ni Aram; ");
INSERT INTO mbi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ne si Aram ne amey ni Aminadab, ne si Aminadab ne amey ni Naasun, ne si Naasun ne amey ni Salmun, ");
INSERT INTO mbi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ne si Salmun ne amey ni Buus (si Rahab ke iney rin), si Buus ne amey ni Ubid (si Ruth ke iney rin), si Ubid ne amey ni Isai, ");
INSERT INTO mbi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ne si Isai ne amey ni Datù David. Si David ke amey ni Salomon (ke iney rin ne esawa rengan ni Uriya); ");
INSERT INTO mbi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Salomon ne amey ni Rubuam, si Rubuam ne amey ni Abiyas, si Abiyas ne amey ni Asa, ");
INSERT INTO mbi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","si Asa ne amey ni Husapat, si Husapat ne amey ni Huram, si Huram ne amey ni Usiyas, ");
INSERT INTO mbi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","si Husiyas ne amey ni Hutam, si Hutam ne amey ni Akas, si Akas ne amey ni Isikyas, ");
INSERT INTO mbi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","si Isikyas ne amey ni Manasis, si Manasis ne amey ni Amun, si Amun ne amey ni Husyas, ");
INSERT INTO mbi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ne si Husyas ne amey ni Hikunyas wey ke menge suled din. Ini se hewii ne neviyag ke menge Israyil diyà te inged ne Bebilunya. ");
INSERT INTO mbi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Guna su diyà dan en te inged ne Bebilunya ne nevuwad si Hikunyas ne iyan din anak ne si Selatil, si Selatil ne amey ni Serubabil, ");
INSERT INTO mbi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","si Serubabil ne amey ni Abiyud, si Abiyud ne amey ne Iliyakim, si Iliyakim ne amey ni Asur, ");
INSERT INTO mbi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","si Asur ne amey ni Saduk, si Saduk ne amey ni Akim, si Akim ne amey ni Iliyud, ");
INSERT INTO mbi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","si Iliyud ne amey ni Iliasar, si Iliasar ne amey ni Matan, si Matan ne amey ni Jacob, ");
INSERT INTO mbi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","si Jacob ne amey ni Jose, ke esawa ni Maria ne iney ni Hisus ne ed-ingaranan ki Mesiyas, ne iyan din meana ne impasad te Eleteala ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ketà be ne igenat ki Abraham taman te kineanak ki David ne sepulù wey epat ne lapis. Ne igenat ki David taman te kinekeviyag dan diyà te inged ne Bebilunya ne sepulù wey epat ded ne lapis. Ne igenat te kinekeviyag dan taman te kineanak ki Hisu Kristu ne sepulù ded dema wey epat ne lapis. ");
INSERT INTO mbi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iring kayi se ned-ulaula te kineanak ki Hisu Kristu. Nepesaran en se ed-esawaen ke iney rin ne si Maria ni Jose, ugaid ne warà den pà mekedtimpung ne netuenan ni Maria te mehingey sikandin egenat te gehem te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose ini ne egkeesawa rin ne metidtu ne etew, ugaid ne warà din metueni ke engkey se amey rut te vatà. Tembù be nepegitung din se kenà din edleusan te ed-esawa si Maria asal ed-usayen dà te meeles su apey kenà meyeyai si Maria. ");
INSERT INTO mbi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ne gewii rin te ebpegpegitung kayi ne nekelipereng sikandin ne mibpekita ke suluhuen te Kerenan kayi te tehinep din se egkahi te, “Jose, sikuna ne kevuwaran ni David, kenà ka egkeandek ne ebpengesawa ki Maria su arà se ibmehingey rin ne egenat te gehem dut te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne ed-anak sikandin te meama ne iyan nu id-ingaran ne si Hisus su sikandin ke ebpelihaun te menge etew rin dut te menge salà dan,” ke se suluhuen. ");
INSERT INTO mbi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Langun kayi ne ned-ulaula su apey metuman ke impekahi rengan te Kerenan dut te ebpelambas te lalag din ne egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ebmehingey ini se raha ne warà pà mebeyugi ne ed-anak te meama ne iyan id-ingaran ne si Imanwil” (ne iyan din meana ne “Ke Eleteala ne kayi en te kenitew”). ");
INSERT INTO mbi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Guna su nekehimerat si Jose ne midtuman din ke insuhù dut te suluhuen te Kerenan ne mid-esawa rin si Maria. ");
INSERT INTO mbi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ugaid ne warà din pà uvaya si Maria taman te warà pà mid-anak. Guna su mid-anak en ne mid-ingaranan ni Jose ini se batà ne meama ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Diyà in-anak si Hisus te inged ne Bitlihim lusud te Hudiya te gewii te iyan egkamal te inged ne datù ne ed-ingeranan ki Hirudis. Warà meuhet ne ruen menge etew ne metau te bituen riyà ebpuun te Edsilaan ne nekeuma riyà te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nekeuma ran ne mid-insà dan se egkahi te, “Endei ke behu pà ne in-anak ne vatà ne midtendù ne edetuen te menge etew ne Hudiyanen? Su nekita rey ke bituen ne edlepew riyà te inged dey ne rapit te Edsilaan ne tuus te in-anak en sikandin, tembù be mibpengkayi key su ebpengarap key kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Guna su nerineg ni Hirudis ini ne warà meupiya ne itungan din, ne iring ded dema ketà ke langun ne menge etew te inged ne Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ketà ne miburun din ke langun ne menge mepurù te terebpelengesa te menge Hudiyanen wey ke menge meyterù te penduan dan ne mid-insaan din sikandan te, “Endei igkeanak ke Impasad te Eleteala rengan ne Ebperetuen te langun?” ");
INSERT INTO mbi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Diyà te inged ne Bitlihim lusud kayi te Hudiya,” ke sikandan, “su ini ke impesurat dut te ebpelambas te Lalag te Eleteala rengan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikiyu ne menge etew te inged ne Bitlihim lusud te Hudiya, misan deisek ke inged niyu ne kenà sikiyu ke mewri dut te menge inged ketà; su riyà te keniyu ne ruen edlepew ne ebpeneheewit dut te menge sakup ku ne menge kevuwaran ni Israyil.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Guna su nerineg ni Hirudis ini ne midtawag din ke behu pà ne nekeuma ne riyà ebpuun te Edsilaan te in-eles din ne mid-insaan din sikandan ke keenu medlepew ini se bituen ne nekita ran, ne netuenan din ketà te kandan. ");
INSERT INTO mbi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ketà ne impependiyà din en sikandan te Bitlihim se egkahi te, “Pendiyà kew en ne ey-eyari niyu te ebpemengà arà se vatà. Ne embiya egketuen niyu ne lived kew kayi ne peketueni niyu kedì su apey a mekependiyà su ebpengarap a rema.” ");
INSERT INTO mbi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nerineg den dà ini ne mid-ipanew ran en. Ne gewii te ed-ipanew ran ne ketà en maa ke bituen ne nekita ran te riyà dan pà te Edsilaan su mid-una kandan taman te edrenged en ketà te neubpaan te batà. ");
INSERT INTO mbi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nekita ran dà ke bituen ne nehalew ran nevenar. ");
INSERT INTO mbi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Midlusud dan ketà te valey ne nekita ran ke vatà wey ke iney rin ne si Maria ne midlumpeng dan se ebpengarap kandin. Ne ketà ne mibukaan dan ke midtehuan te ibehey ran kandin ne indenà dan diyà te kandin ke bulawan, mepurù ne rukut, wey periyemut ne ed-ingaranan te mira. ");
INSERT INTO mbi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne guna su ed-ulì dan en ne impesabut kandan te Eleteala impepevayà te tehinep te kenà dan en medlived diyà te ki Hirudis. Ne ketà ne riyà dan en mibpevayà te seveka ne ralan te kineulì dan en. ");
INSERT INTO mbi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Guna su migenat en ke menge meama ne riyà ebpuun te Edsilaan ne mibpetehinep en ke suluhuen te Kerenan ki Jose se egkahi te, “Enew ke en ne kua nu ke vatà wey ke iney rin ne pelahuy kew riyà te inged ne Ihiptu. Ne kenà kew awà diyà taman te kenà ku ebpeulien sikiyu su ebpemengaan ni Hirudis ayan se vatà su ed-imetayan din.” ");
INSERT INTO mbi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ne arà dà ne mid-enew si Jose ne mid-ewit din ke vatà wey ke iney rin te arà dà ne kerukileman te ebpendiyà te inged ne Ihiptu. ");
INSERT INTO mbi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne riyà dan mid-ubpà taman te minatey en si Hirudis. Ned-ulaula ini su apey metuman ke impekahi te Kerenan rengan dut te ebpelambas te Lalag din ne si Husiyas ne egkahi te, “Impeulì ku ke Anak ku riyà ebpuun te inged ne Ihiptu.” ");
INSERT INTO mbi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Guna su netuenan ni Hirudis te negaga rà sikandin te itungan dut te menge meama ne riyà ebpuun te Edsilaan ne neregreg sikandin te langet din. Ne insuhù din te ebpeimetayan ke langun ne menge vatà ne meama diyà te inged ne Bitlihim wey ketà te nekelingut ne menge inged ne egenat te deruwa pà ne rahun taman te behu pà ne in-anak su mid-antap din dut te nerineg din ketà te menge etew ne riyà ebpuun te Edsilaan ne nekederuwa en ne rahun igenat dutun te nekita ran ke bituen. ");
INSERT INTO mbi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ne ketà ne netuman en ke impekahi rut te ebpelambas te Lalag te Eleteala rengan ne si Jeremias ne egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Duen nerangkub ne egkerineg diyà te inged ne Rama, ne edsinehew wey ebpenderawit. Su ebpenderewitan ni Raquel ke menge anak din, ne kenè en egkelangan ke hinawa rin su warè en ke menge anak din.” ");
INSERT INTO mbi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Guna su minatey en si Hirudis ne mibpetehinep en maa ke suluhuen te Kerenan ki Jose diyà te inged ne Ihiptu, ");
INSERT INTO mbi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ne migkahi te, “Enew ka ne kua nu ke vatà wey ke iney rin ne ulì kew en diyà te inged ne Israyil su minatey en ke menge etew ne egkiyug ne ebpeimatey rut te vatà.” ");
INSERT INTO mbi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ne mid-enew si Jose ne migkuwa rin ke vatà wey ke iney rin ne mid-ulì dan en diyà te inged te Israyil. ");
INSERT INTO mbi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ugaid ne guna su nerineg ni Jose te si Arkilew se egkamal dut te inged ne Hudiya nekesambì dut te amey rin ne si Hirudis ne neandek sikandin ne ed-ulì ketà. Ne mibpetehinep ma ke Eleteala ne mibaag kandin ne ketà ne riyà dan mibpesinaru te lusud te Geliliya, ");
INSERT INTO mbi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ne mid-ubpà dan ketà te inged ne ed-ingaranan te Nesarit. Ned-ulaula rin ini su apey metuman ke impekahi rut te ebpelambas te Lalag te Eleteala rengan ne egkahi te, “Ed-ingeranan sikandin te etew te Nesarit.” ");
INSERT INTO mbi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ketà ne hewii ne nekeuma si Juan ne Ebpembunyag kayi te tanà ne kenà egkeubpaan te menge etew diyà te lusud te Hudiya, ne impesabut din ke Lalag te Eleteala riyà te menge etew ne ed-uvey kandin. ");
INSERT INTO mbi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Migkahi sikandin diyà te menge etew te, “Pemedsendit kew ne engkeri niyu ke menge meraat ne ulaula niyu su mehaan en Edatù ke Eleteala kenitew.” ");
INSERT INTO mbi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan ini ke nekahi ni Isayas ke mibpelambas te Lalag te Eleteala rengan se egkahi te, “Duen etew riyà te tanà ne kenà egkeubpaan te menge etew ne ebpenawag dut te menge etew ne ed-uvey kandin, ke sikandin te, ‘Mehaan ebpekeuma ke Kerenan, ne ihewani niyu ke ralan, ne tidtuwa niyu ke ibayà din, ne iyan din meana ne tilaka niyu ke hinawa niyu su apey kew egkepenehana te kebpekeuma rin.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Si Juan ini ne iyan din belegkas ne mid-avel ne bulvul te binatang ne ed-ingeranan te kemilu, ne iyan din insebitan ne lundis ded dut te binatang. Ne iyan din keuyehan se tepurì wey teneb. ");
INSERT INTO mbi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne merakel ne menge etew ne mibpendiyà su ebpemineg kandin ne riyà ebpemuun te inged ne Hirusalim, ne riyà ebpemuun te lusud te tivuuk ne inged te Hudiya, wey langun ne menge inged ne nekepesuvà te wayig ne Hurdan. ");
INSERT INTO mbi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne intarem dan te nekedsendit dan dut te langun ne meraat ne ulaula ran ne arà pà ne mibpebunyag dan ki Juan diyà te wayig ne Hurdan. ");
INSERT INTO mbi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Guna su nekita ni Juan ke merakel ne Peresiyu wey Sadusiyu ne mibpengkayi su ebpebunyag ne migkehiyan din sikandan te, “Iring kew te menge uled ne ebpelahuy dut te apuy! Mehaan en egkeuma ke kedusa te Eleteala keniyu. Engkey se midtarem keniyu te ebpekeliyu kew ketà te ebpebunyag kew? ");
INSERT INTO mbi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Embiya benar ne mid-engkeran niyu ke meraat ne ulaula niyu, ne ipekita niyu kayi te ulaula niyu. ");
INSERT INTO mbi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne kenà kew egkahi te sikiyu ne kenà edusaan te Eleteala su geina te kevuwaran kew ni Abraham. Su igkahi ku keniyu,” ke si Juan, “misan ini se menge batu ne egkepebaluy te Eleteala ne etew ne tuney ne kevuwaran ni Abraham ne igkesambì keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ne sikiyu ne iring te menge kayu ne kenà ebahas te meupiya, tembù be ebpilayen. Ne iring te nekekayew en ke adsa su ebpemilayen su idtimbag diyà te apuy. ");
INSERT INTO mbi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Wayig se ibunyag ku keniyu ne tuus te mid-engkeran niyu ke meraat ne ulaula niyu,” ke si Juan. “Ugaid ne ruen ebpeketundug kediey ne mepurù pà kediey, su misan ke telumpà din ne kenà a edait ne ebitbit. Ne iyan din ibunyag keniyu ke Kedesenan ne Ebpetuntul te Menusiyà ne ebunyahan din ke ruma te apuy. ");
INSERT INTO mbi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Geina te ibpesivey rin ke menge etew ne ebperetiyaya rut te menge etew ne kenà ebperetiyaya,” ke si Juan, “ne iring sikandin te etew ne ruen teluung din su ed-ukap ne ibpelayap din ke ukap rut te rimahas. Ke rimahas ne idtahù din diyà te patil, ne ke ukap ne ebinsulan din te apuy ne kenà egkeevukan.” ");
INSERT INTO mbi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Warà meuhet ne nekeuma en si Hisus kayi te wayig ne Hurdan se riyà ebpuun te lusud te Geliliya su ebpebunyag ki Juan. ");
INSERT INTO mbi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ugaid ne kenà perem ebunyag si Juan kandin, ke sikandin te, “Meambe ke ebpengkayi ka te kedì se ebpebunyag? Su iyan edait ne ebpebunyag a kenikew.” ");
INSERT INTO mbi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ne midtavak si Hisus kandin te, “Ed-iringen ta en kayi ne bunyahi ad nikuna su apey ta metuman ke langun ne insuhù te Eleteala.” Ne ketà ne migkiyug si Juan ne mibunyahan din en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Guna su nebunyahan en si Hisus ne migaun en ketà te wayig. Ne nevukaan ke langit ne nekita rin ke Kedesenan ne Ebpetuntul te Menusiyà ne midragid te melepati ne mibpehunrerenà ne midlatun kayi te kandin. ");
INSERT INTO mbi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ketà ne ruen suwara ne riyà ebpuun te langit ne nerineg din se egkahi te, “Sikew ke Anak ku ne igkelimù ku nevenar, ne utew en ne ingkesuatsuat ku sikew.” ");
INSERT INTO mbi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ne ketà ne mid-ewit en si Hisus dut te Kedesenan ne Ebpetuntul te Menusiyà diyà te tanà ne kenà egkeubpaan te menge etew su ebpenggeraman dut te datù te pekaid. ");
INSERT INTO mbi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne lusud te epat nepulù ne andew wey kerukileman ne warà bulug mekekaan sikandin, ne nevitil nevenar. ");
INSERT INTO mbi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ne mid-uvey kandin si Setanas ke datù te pekaid ne mibpenggeraman din se egkahi te, “Embiya sikuna en ke Anak te Eleteala ne pebeluya nu ini se menge batu ne pan ne egkekaan.” ");
INSERT INTO mbi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ne migkahi si Hisus te, “Iyan insurat ne Lalag te Eleteala ne egkahi te, ‘Kenà egkeenen dà se igkeuyag te etew, ugaid ne iyan ebpekeuyag kandin ne uman senge tahà ne lalag te Eleteala.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ne ketà ne mid-ewit dut te datù te pekaid si Hisus diyà te inged ne Hirusalim ne ed-ingaranan te Berekat ne Siyudad ne rutun ne miduma rin si Hisus diyà te migketikangan dut te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne migkahi ke datù te pekaid te, “Embiya benar ne sikew ke Anak te Eleteala ne umpak ka ruen. Su ruen impesurat ne Lalag te Eleteala ne egkahi te, ‘Edsuhù ke Eleteala te menge suluhuen din ne ebpetugenuren keykew. Ne edsepirawen ka nikandin su apey kenà egkerudruri ke paa nu te batu.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ne migkahi si Hisus te, “Ugaid ne ruen dema Lalag ne impesurat te Eleteala ne egkahi te, ‘Kenà kew baal te ralan ne ibpenggeram te gehem dut te Kerenan ne Eleteala niyu.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Neipus ketà ne mid-ewit maa si Hisus dut te datù te pekaid diyà te metmetikang ne buvungan ne impekita rin ki Hisus ke langun ne menge inged kayi te ampew te dunya wey ke kekewesai ran. ");
INSERT INTO mbi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ini se kebayàbayà kayi te langun ne inged ini ne ibehey ku keykew,” ke se datù te pekaid, “wey langun ini ne kekewesai embiya ebpenimbuel ka ne ed-arap ka kedì.” ");
INSERT INTO mbi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne migkahi si Hisus te, “Awà ka kayi, Setanas! Duen impesurat ne Lalag te Eleteala ne egkahi te, ‘Iyan niyu rà erapa ne Kerenan ne Eleteala niyu, ne sikandin dà se edsenguren niyu.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ne ketà ne mid-ewaan en dut te datù te pekaid sikandin ne nekeuma en ke menge suluhuen te Eleteala ne midtuganur kandin. ");
INSERT INTO mbi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Guna su nerineg ni Hisus te impevilanggù en si Juan ke Ebpembunyag ne mibpendiyà sikandin te inged ne Geliliya. ");
INSERT INTO mbi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nekeuma sikandin diyà te inged ne Nesarit ugaid ne warà ketà mid-ubpà su mibpendiyà sikandin te inged ne Kapirnawum diyà te beyvey te ranew te Geliliya diyà te tanà ne imbehey rengan dut te keep-epuan ni Sibulun wey Neptali. ");
INSERT INTO mbi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ned-ulaula rin ini su apey metuman ke impesurat ki Isayas ke mibpelambas te Lalag te Eleteala rengan ne egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tanà te Sibulun wey tanà te Neptali diyà te beyvey te rahat, diyà te ripag te wayig ne Hurdan, ne ed-ingeranan te Geliliya ne ed-ubpaan te kenà Hudiyanen! ");
INSERT INTO mbi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ke menge etew ne ed-ubpà ketà ne rengan ne iring te nerusireman, ugaid ne nekekita en te mesmesihey ne rayag. Uya, ini se riyà te merusirem ne mid-ubpà te alung te kepepatey, ugaid ne mid-endlahan en te rayag!” ");
INSERT INTO mbi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ne igenat ketà ne midrudsù en si Hisus se ebpesabut te menge etew, ke sikandin te, “Pedsendit kew en ne engkeri niyu en ke meraat ne ulaula niyu su mehaan en ebpekeuma ke Kedatù te Eleteala keniyu.” ");
INSERT INTO mbi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gewii te mid-ip-ipanew si Hisus diyà te beyvey te Ranew te Geliliya ne nekita rin ke deruwa ne teleari, si Simon (ne ed-ingeranan ki Pedro) wey si Andres ke ari rin. Ebpemiyala ran diyà te ranew su arà ke helevek dan. ");
INSERT INTO mbi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne migkehiyan dan ni Hisus te, “Pengkayi kew en ne duma kew kediey,” ke sikandin, “su serà se ebpemiyalaan niyu guntaani, ugaid ne ebpenuruen ku pà sikiyu te iyan niyu mulà egkeutel ne menge etew ne eduma kedì.” ");
INSERT INTO mbi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Arà dà ne mid-ewaan dan en ke biyala ran su miduma ran en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Guna su midlevundus en si Hisus ne nekita rin se deruwa pà maa ne teleari ne si Santiago wey ke ari rin ne si Juan, ke menge anak ni Sibidiyu. Diyà dan te avang dan ne elin ke amey ran ne ebpengumbayà te biyala ran. Midtawag dan ni Hisus, ");
INSERT INTO mbi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ne arà dà ne mid-ewaan dan en ke amey ran dutun te avang ne miduma ran en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ne mid-eneb-eneb en si Hisus dut te langun ne menge inged diyà te lusud te inged ne Geliliya se ebpenurù ketà te menge valey ne ebpengedian te menge Hudiyanen te penduan dan. Impesabut din te menge etew ke Meupiya ne Tudtul mekeatag te Kedatù te Eleteala kandan, ne nengeulian din ke piya engkey en ne sakit wey menge daru te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ne nekeeneb en ke bantug ni Hisus diyà te tivuuk ne inged te Siriya ne mibpeneheewit te menge etew diyà te kandin ke langun ne egkerasey te piya engkey ne sakit wey daru, menge midsuukan te vusew, menge ebevuyen, wey menge etew ne minatey se lawa rin, ne nengeulian ni Hisus ke langun dan. ");
INSERT INTO mbi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ne medmerakel ne menge etew ne miduma kandin egenat te lusud te inged ne Geliliya, lusud te inged ne Dikapulis, inged ne Hirusalim, lusud te inged ne Hudiya wey menge inged diyà te ripag te wayig ne Hurdan. ");
INSERT INTO mbi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Guna su nekita ni Hisus ke denda ne menge etew ne miduma kandin ne midtekereg sikandin diyà te buvungan ne rutun mibpinuu. Ne mid-uvey kandin ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne mibpenurù din sikandan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dayirayi ke menge etew ne netuenan dan te kenà dan ebpekeulaula te meupiya ke kenà dan edtevangan te Eleteala, su sikandan ke ebpekeamung dut te Edetuan te Eleteala! ");
INSERT INTO mbi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dayirayi ke menge egkemutuwan, su edlenganen te Eleteala ke hinawa ran! ");
INSERT INTO mbi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dayirayi ke menge mepeembavà te hinawa rin, su ebpeketelimà dan te impasad te Eleteala! ");
INSERT INTO mbi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dayirayi ke menge ebpeuna te hinawa ran se kedtuman te kiyug te Eleteala, su edtevangan dan te Eleteala te kedtuman kayi! ");
INSERT INTO mbi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dayirayi ke menge iiruwen te menge ruma ran, su egkeyruwan dan dema te Eleteala! ");
INSERT INTO mbi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dayirayi ke menge kenà egkereruwa se hinawa rin, te kedtumana ran te metidtu ne ulaula, su sikandan se ebpekekita te Eleteala keuremà! ");
INSERT INTO mbi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dayirayi ke menge ebpemedtuntey te menge etew, su sikandan ke ed-engkunan te Eleteala ne anak din! ");
INSERT INTO mbi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dayirayi ke menge ebpekesekitan te kedtuman dan te engkey se metidtu diyà te etuvangan te Eleteala, su sikandan ke ebpekelusud dut te Edetuan te Eleteala! ");
INSERT INTO mbi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dayirayi kew ke ebpenempelaen kew, wey ebpekesekitan kew, wey edtevuan kew te langun ne edsusunan te mereatey ne ulaula su sabap te keduma niyu kediey. ");
INSERT INTO mbi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kehalew kew misan iring kayi te ini kew te ampew te dunya su dekelà se idlalew keniyu diyà te langit. Su iring ded dema ke impekaid dan dut te menge mibpelambas te Lalag te Eleteala rengan.” ");
INSERT INTO mbi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikiyu ne eduma kedì,” ke si Hisus, “ne iring kew te timus ne ibmeupiya te nanam te egkeenen su iyan kew ibmeupiya dut te langun ne menusiyà. Ugaid ne upama ke egkeawà en ke nanam din, ne warà en dalan te kebmetimus din pà maa. Warà egkeetahan din, tembù be idtimbag dà ne egiekan dà te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ne iring kew te sulù ne ebpeketeyew diyà te langun ne menusiyà. Su ruen beseanan ne egkahi te, ‘Ke inged ne riyà meketahù te puntur te buvungan ne kenà ebpekeeles.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Su warà etew ne midtemtem te sulù ne ebpelengkevan din etawa ibperalung din, ugaid ne riyà din ibpeluukluuk te saag su apey egkerayahan ke etew ne edlusud. ");
INSERT INTO mbi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ne iring ded te sulù ne impeluukluuk te saag ne ebpekerayag te langun ne menge etew ketà te lusud te baley, ne pekereyaha niyu ke sulù niyu riyà te menge etew su apey ran mekita ke meupiya ne ed-ul-ulaan niyu ne ebpekereyù dan dut te Amey niyu ne Eleteala diyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kenà niyu pegitunga,” ke si Hisus, “te iyan ku impengkayi te ampew te dunya ne apey egkeawà ke penduan ne intelau ni Moises rengan wey ke impenurù te menge mibpelambas te Lalag te Eleteala rengan. Kenà ku iyan impengkayi se id-awà ku ini, ugaid ne mibpengkayi a su apey ku meup-upiani metuman ke langun ne nekahi. ");
INSERT INTO mbi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tentenuri niyu ini, su taman te duen pà langit wey tanà ne warà senge tahà ne egkeawà dut te penduan. Su egkeawà ke langit wey tanà ne warà pà meawà ke penduan. ");
INSERT INTO mbi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tembù be piya entei ne etew ne edsurang te misan deisek dà dut te penduan ne ibpenurù din te ruma se edsurang iring kandin, ne sikandin ke egkevaluy ne kevevaan ne etew diyà te menge etew ne Edetuan te Eleteala diyà te langit. Ugaid ne ke etew ne edtuman dut te penduan ne ibpenurù din te ruma se kedtuman, ne egkevaluy sikandin ne mepurù ne etew diyà te menge etew ne Edetuan te Eleteala diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Su idtarem ku keniyu,” ke si Hisus, “wey kew rà ebpekeamung diyà te menge etew ne Edetuan te Eleteala diyà te langit embiya iyan kew pà metidtu diyà te etuvangan din dut te menge meyterù te penduan wey menge Peresiyu.” ");
INSERT INTO mbi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ne migkahi pà maa si Hisus te, “Iyan niyu nerineg ne impenurù te menge lukes tew rengan ne egkahi te, ‘Kenà kew ed-imatey, su ke etew ne ed-imatey ne egkesuhat te kukuman.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ugaid ne igkahi ku keniyu te piya entei ne egkeepes te ruma rin ne egkesuhat dema te kukuman. Ne piya entei ne egkahi te ruma rin te, ‘Warà itungan nu!’ ne ebpeneheewitan sikandin diyà te punggus en dut te kukuman. Ne piya entei ne egkahi te ruma rin te, ‘Buneg ka ne warà rantek nu!’ ne dait ne ebpekednerakà sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tembù be embiya diyà ke en te edenaan su ebehey ka te Eleteala ne netenuran nu te ruen nesakit se hinawa rin kenikew, ");
INSERT INTO mbi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne itahak nu pà arà se ibehey nu ne beyai nu pà ne pekid-ulit ka pà ketà te ruma nu, ne arà pà ne lived ka su ebehey ke en diyà te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ne embiya ruen etew ne edwagib kenikew ne ed-ewiten ka riyà te kukuman, ne gaangaan ke en pekidtuntey kandin te kenà ka pà ebpekeetuvang diyà te kukuman. Su embiya ebpekeetuvang ka en diyà te kukuman, ne ibehey ka en diyà te uwis, ne ibehey ka riyà te menge pulis ne ke menge pulis ne ebilanggù keykew. ");
INSERT INTO mbi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Idtarem ku keniyu,” ke si Hisus, “kenà kew ebpekelihawang ketà taman te kenà niyu egkevayaran ke langun ne keselaan nu.” ");
INSERT INTO mbi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ne migkahi pà maa si Hisus te, “Iyan niyu nerineg dema ne impenurù dengan te, ‘Kenà kew edlanglangkad te esawa nu.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ugaid ne igkahi ku keniyu te piya entei ne meama se edtengteng te meritan ne kenà din esawa ne igkeerihi rin, ne timbang te nepengingniyuhan din en arà se meritan. ");
INSERT INTO mbi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Su embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke kewanan ne mata nu, ne lesika nu ne itimbag! Su iyan pà tumù ne dibdivaluy rà se mata nu tumin dè be ke langun ne lawa nu ne igkeantug diyà te apuy nerakà. ");
INSERT INTO mbi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke kewanan ne belad nu, ne tempera nu ne itimbag nu! Su iyan pà tumù ne egkesarir ka tumin dè be ke langun ne lawa nu ne igkeantug diyà te apuy nerakà.” ");
INSERT INTO mbi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ne migkahi maa si Hisus te, “Impesurat rema dengan te, ‘Embiya ruen meama ne ebpekid-engked te esawa rin, ne edsurat pà te ebpeketuenan te ebpekid-engked en sikandin.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ugaid ne igkahi ku keniyu embiya ruen meama ne ebpekid-engked te esawa rin, misan kenà edlangkadlangkad ini se esawa rin kandin, ne ini se meama se puunan te salà te esawa rin su embiya edsaup ed-esawa ke meritan ne timbang te nekelangkadlangkad en sikandin. Ne engketà ded dema timbang te nekelangkadlangkad en ke meama ne ed-esawa kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ne migkahi pà maa si Hisus te, “Nerineg niyu red dema se impenurù te menge lukes tew dengan, ‘Kenà niyu perisa ke impasad niyu, su embiya ruen impasad niyu te Kerenan ne tumana niyu iya.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ugaid ne igkahi ku keniyu, embiya ruen ibpasad niyu ne kenà kew sesapà. Kenà kew sesapà te langit su arà ke ubpaan te Eleteala, ");
INSERT INTO mbi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ne kenà kew sesapà kayi te ampew te dunya su ini ne iring te edtembaran te paa rin. Ne kenà ka sesapà te inged ne Hirusalim su arà ke inged dut te pinekemepurù ne Datù. ");
INSERT INTO mbi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne kenà kew rema sesapà te ulu niyu su warà gehem niyu te ebpekeputì te misan senge waru rà ne bulvul niyu etawa ebpekeitem. ");
INSERT INTO mbi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Embiya iyan netahù te hinawa niyu se ‘uya’ ne kehiya niyu te ‘uya’, ugaid embiya iyan netahù te hinawa niyu se ‘kenà’ ne kehiya niyu rà te ‘kenà’. Su embiya ed-umanan niyu pà te sapà ne riyan en arà ebpuun te datù te pekaid.” ");
INSERT INTO mbi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nerineg niyu rema,” ke si Hisus, “ke impenurù dengan se egkahi te, ‘Embiya ruen etew ne ebpekereraat te mata te ruma rin, ne edereetan dema ke mata rin. Ne embiya ruen ebpekehevang te ngipen te ruma rin ne egevangen dema te ngipen din.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ugaid ne igkahi ku keniyu te kenà kew edsulì dut te etew ne mid-ulaula te mereatey keniyu. Upama ke ruen edtabpì te buked nu, ne kenà nu ivangen ke edtebpien din ke divaluy. ");
INSERT INTO mbi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne embiya ruen ed-ewit keykew riyà te kukuman ne edlugkasan ka rin en te kemisita nu, ne kenà nu ivangen kandin te egkuwa ketà, ugaid ne ivehey nu kandin ke kumbalà nu rema. ");
INSERT INTO mbi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne embiya ruen sundaru ne ebpehes keykew te ebpevava te kesengkapan din taman te senge kilumitru se keriyù din, ne bevaa nu misan taman te deruwa ne kilumitru. ");
INSERT INTO mbi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ne embiya ruen ebuyù keykew, ne behayi nu. Ne embiya ruen edsambey keykew, ne pesembaya nu.” ");
INSERT INTO mbi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nerineg niyu rema,” ke si Hisus, “ke nekahi ran dengan te, ‘Limui nu ke menge sepakat nu ne keepesi nu ke menge kunterà nu.’ ");
INSERT INTO mbi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ugaid ne igkahi ku keniyu te limui niyu ke menge kunterà niyu, ne ipengeningeni niyu te ebpeneuven te Eleteala ke menge etew ne ebpekesakit kenikew. ");
INSERT INTO mbi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Su embiya ini se ed-ul-ulaan niyu, ne egkekita kayi te keniyu te sikiyu ne menge anak en te Amey niyu ne Eleteala diyà te langit. Su ini se Eleteala ne kenà iyan din dà ebpesilaan te andew ke menge metidtu rà su elin ded dema ke menge etew ne meraat se ulaula rin. Ne ebpeuranan din ded dema ke menge metidtu wey ke menge etew ne ed-ulaula te meraat. ");
INSERT INTO mbi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Su embiya iyan niyu rà igkelimù ke menge etew ne egkelimù keniyu, ne meambe ke ebpenareng kew te kebpenaub te Eleteala keniyu? Misan ke ebpevayad te buwis ne limbungan ne igkelimù dan dema ke menge etew ne egkelimù kandan. ");
INSERT INTO mbi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne embiya iyan niyu rà edsehipaan ke menge sepakat niyu, ne engkey se kegkereyui keniyu? Warà! Su misan ke menge etew ne kenà ebperetiyaya te Eleteala ne ed-ulaula red dema te iring ketà. ");
INSERT INTO mbi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tembù be sikiyu ne pekeimpit kew te ulaula niyu riyà te menge etew, su ke Amey niyu riyà te langit ne impit ke langun ne ulaula rin.” ");
INSERT INTO mbi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Migkahi pà maa si Hisus te, “Itahù niyu ini te itungan niyu te kenà iyan niyu kebpengeningeni te Eleteala ne apey kew mekita te menge etew. Su embiya ini se ed-ul-ulaan niyu ne kenà niyu egketelimà ke idlalew ketà dut te Amey niyu riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tembù be embiya ruen ibehey niyu te egkeayuayu ne kenà niyu ibpekitakita te menge etew iring dut te menge etew ne egkiyug ne ebpekita te keupiya ran. Su sikandan ini ke ebehey ran ne riyà den dà ibehey te lusud te valey ne ebpengedian te penduan dan wey riyà te ralan su apey egkekita ne egkereyù dan te menge etew. Ugaid ne igkahi ku keniyu te ini se mid-ulaula ran ne nekuwa ran en ke lalew ran. ");
INSERT INTO mbi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ugaid ne embiya ruen ibehey niyu te egkeayuayu, ne kenà niyu peketueni te misan sepakat niyu, ");
INSERT INTO mbi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","su apey ini se ibehey niyu ne warà ruma ne egketau. Ne ke Amey niyu rà se nekekita dut te mid-ulaula niyu ne iyan edlalew keniyu.” ");
INSERT INTO mbi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ne embiyà ebpengeningeni ka,” ke si Hisus, “ne kenà ka ed-iring te engkungkun ne metidtu. Su embiya ebpengeningeni ran ne egkiyug dan ne ed-itindeg diyà te lusud te valey ne ebpengedian te menge Hudiyanen te penduan dan wey riyà te lirig te kelesada su apey egkekita te menge etew. Ugaid ne igkahi ku keniyu te ini se mid-ulaula ran ne nekuwa ran en ke lalew ran. ");
INSERT INTO mbi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ugaid ne sikiyu, ke ebpengeningeni kew ne lusud kew riyà te sungkù niyu ne lelekeb kew ne pengeningeni kew riyà te Amey niyu ne Eleteala ne kenà egkekita. Ne ke Amey niyu ne iyan dà ebpekekita keniyu ne iyan edlalew keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ne kayi te kebpengeningeni niyu,” ke si Hisus, “ne kenà niyu edlumlumbayi ke pengeningeni niyu iring dut te menge etew ne kenà ebperetiyaya te Eleteala. Su iyan dan kunaan ke ebpeminehen te Eleteala ke pengeningeni ran ke ebpekelayaten dan. ");
INSERT INTO mbi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kenà kew ve ed-iring kandan! Su sikiyu, ne netuenan en te Amey niyu ke kurang niyu te warà kew pà mebuyù. ");
INSERT INTO mbi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Embiya ebpengeningeni kew ne iringa niyu kayi, ‘Ah, Amà diyà te langit, berekat ne edati te menusiyà ke ngaran nu. ");
INSERT INTO mbi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne berekat ne ebayàbayà ka rut te langun ne menusiyà, su apey metuman ke kiyug nu kayi te ampew te dunya iring dut te diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Behayi key te sesangan ne egkekaan dey te ini ne andew. ");
INSERT INTO mbi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ne pesehara nu ke salà dey iring dut te nepesehad dey en ke nekedsalà kenami. ");
INSERT INTO mbi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne ipekeriyù key nikuna dut te menge mevaher ne penggeram, ne pekelangi key dut te datù te pekaid.’ ");
INSERT INTO mbi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Su embiya ebpeseharen niyu ke menge etew ne nekedsalà keniyu,” ke si Hisus, “ne egkepesehad kew rema te Eleteala ne Amey niyu ne riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ugaid ne embiya kenà niyu egkepesehad ke menge etew ne nekedsalà keniyu, ne kenà dema ebpeseharen ke salà niyu dut te Amey niyu ne riyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne migkahi pà maa si Hisus te, “Embiya edlimpas kew te egkaan su ebpengeningeni, ne kenà kew ebpekerumbahat te paras niyu iring dut te menge etew ne engkungkun ne metidtu. Su sikandan ke edlimpas dan te egkaan ne ebpebparas dan te merupaas su apey mekita te edlimpas dan te egkaan. Ne igkahi ku keniyu te kayi te ini se mid-ulaula ran ne nekuwa ran en ke lalew ran. ");
INSERT INTO mbi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ugaid ne iyan meupiya ke edlimpas kew te egkaan ne pendapug kew ne penuwat kew, ");
INSERT INTO mbi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","su apey kenà metueni te menge etew te edlimpas kew te egkaan. Ne iyan dà netau ke Amey niyu ne Eleteala ne kenà egkekita. Ne iyan sikandin edlalew kenikew dut te mid-ulaula nu te sebseveka nu.” ");
INSERT INTO mbi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kenà kew edlimud te kekewesai niyu kayi te ampew te dunya,” ke si Hisus, “su kayi ne ruen egketketen, ne ruen edtengisen, ne ruen menge tekawen ne edlusud te menge valey niyu su ebpemenakew. ");
INSERT INTO mbi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ugaid ne iyan meupiya,” ke si Hisus, “ne edtuman kew te kiyug te Eleteala ne egkevaluy ne ruen kekewesai niyu riyà te langit ne kenà egketketen, ne kenà edtengisen, ne warà tekawen ne edlusud su ebpemenakew. ");
INSERT INTO mbi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Su piya endei niyu idtahù ke kekewesai niyu, ne ketà dema ke hinawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ne migkahi pà maa si Hisus te, “Ke mata te etew ne iring te sulù dut te lawa rin su embiya merayag se kedtengteng din ne iyan din meana ne metidtu se ulaula rin, ne iring te egkerayahan ke langun ne lawa rin. ");
INSERT INTO mbi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ugaid ne embiya edsehulepunen se kedtengteng din ne iyan din meana ne mereatey se ulaula rin, ne iring te egkerusireman ke langun ne lawa rin!” ");
INSERT INTO mbi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Warà edsugsuhuen,” ke si Hisus, “ne deruwa se edtehiuripen kandin. Su embiya deruwa se ebpengunguripen kandin, ne egkeepesan din ke seveka ne ed-edatan din ke seveka. Etawa ebperumaduma sikandin dut te seveka ne kenà din edsehipaan ke seveka. Su iring be kayi embiya iyan dekelà te hinawa nu ne kureta, ne kenà ka ebpeketuman te kiyug te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tembù be iyan ku igkahi keniyu,” ke si Hisus, “kenà kew meuru te egkekaan wey ed-inumen ne igkeuyag niyu etawa ke engkey se ibevelegkas niyu. Su ke hinawa wey lawa niyu ne imbehey te Eleteala, ne maa kenà belielehà pà arà dut te egkekaan niyu wey belegkas niyu? ");
INSERT INTO mbi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Keniyan niyu rè ma te menge uwak, warà kebpemula ran, ne warà ked-ehani ran, ne warà edtehuan dan te egkekaan dan, ugaid ne ke Amey nu ne riyà te langit se ebpesavud kandan! Ne meambe, kenà belielehà kew pà dut te menge pepenuk? ");
INSERT INTO mbi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ne engkey keniyu se nekesumpat te umur din te impepevayà te kegkeuru rin? ");
INSERT INTO mbi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Embiya kenà ka ebpekegaga kayi, ne meambe ke egkeuru ka te ibevelegkas nu? Keniyan niyu rè ma te kevukaran ke engkey se kedtuvù dan. Kenà dan egelevek ne kenà dan ed-avel. ");
INSERT INTO mbi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ne misan iring ketà ne igkahi ku keniyu te misan ke kewasa ne datù dengan ne si Salomon, ne ke keupiya te belegkas din ne warà dà mekesusuluwan dut te keupiya te seveka keniyan ne kevukaran. ");
INSERT INTO mbi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Embiya Eleteala se ebpebparas te kevukaran te sagbet iring ketà, misan mehaan dà se kedtuvù din su egkekita niyu guntaan ne keremà ne nehangu en ne egkevinsulan en, ne maa iyan kew pè be kenà behayi te ibevelegkas niyu? Sikiyu ne deisek se kedsarig niyu! ");
INSERT INTO mbi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ketà be ne kenà kew meuru se egkahi te, ‘Engkey se egkekaan wey egkeinum dey? Ne engkey se ibevelegkas dey?’ ");
INSERT INTO mbi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Su ini imbe ke layun intahù te hinawa rut te menge etew ne kenà ebperetiyaya te Eleteala.) Ugaid ne sikiyu, ne kenà kew meuru su netuenan dut te Amey niyu ne Eleteala ke engkey se kurang niyu. ");
INSERT INTO mbi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iyan niyu ipeuna te hinawa niyu ke kiyug te Eleteala wey ke Kedatù din keniyu, ne arà pè be ne ebehayan kew te Eleteala dut te langun ne kurang niyu. ");
INSERT INTO mbi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tembù be kenà kew meuru ke engkey se egketemanan niyu dut te menge hewii ne egkeuma. Su uman hewii ne idsengebias ke kerehenan din, ugaid ne wey niyu en pegitunga ke egkeuma en.” ");
INSERT INTO mbi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne migkahi pà maa si Hisus te, “Kenà kew edsawey te ruma ne etew apey kenà kew edsewayan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Su edtimbangtimbangen kew te Eleteala iring te kedtimbangtimbang niyu te ruma ne etew. Ne iyan din meana ne taman ne kerekelà te kedtimbangtimbang niyu te ruma ne etew, ne arà en dema ke kerekelà ne kedtimbangtimbang te Eleteala keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Engketà be,” ke si Hisus, “ne meambe ke edturikan nu ke salà te ruma nu ne iring te pesek, ugaid ne warà ma te hinawa nu te ruen salà nu ne iring te gedgeran kerekelà din? ");
INSERT INTO mbi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Engkey se kedtikà nu te egkahi riyà te ruma nu te id-awà nu ke pesek din, ugaid ne ruen ma nekepesek kenikew ne iring te gedgeran kerekelà din ne kenà nu egketuusan? ");
INSERT INTO mbi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Engkey en ayan ne kedtarùtarù nu! Unai nu pà te ed-awà ke nekepesek kenikew ne iring te gedgeran, ne an pà ne ebpekekita ke en ne ebpengawà te pesek te ruma nu.” ");
INSERT INTO mbi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kayi te kebpenurù niyu ne kenà niyu ibpehes te ebpepemineg dut te menge etew ne warà adat din. Su ebpekeiring kew te idtimbag niyu riyà te asu ke kearen ne egkeedatan te Eleteala, ne eberiyung dan ne ebuntalen kew. Ne kenà niyu idtimbag ke pirlas niyu riyà te menge bavuy su egiekan dan dà ini.” ");
INSERT INTO mbi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Migkahi si Hisus te, “Embiya ebpengeningeni kew riyà te Eleteala ne buyù kew ne ebehayan kew rin. Pemengà kew ne ruen arà egketuen niyu. Penehetiat kew ne ebpuwasan kew rin. ");
INSERT INTO mbi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Su langun ne ebuyù diyà te Eleteala ne ebehayan, ne ke etew ne ebpemengà ne ebpeketuen, ne ke etew ne ebpenehetiat ne ebpuwasan ke lekeb kandin. ");
INSERT INTO mbi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Menu sikiyu ne menge lukes, embiya ebuyuan ka te anak nu te pan, maa batu se ibehey nu? ");
INSERT INTO mbi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Etawa ebuyuan ka rin te serà, maa uled se ibehey nu? ");
INSERT INTO mbi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sikiyu ne menusiyà ne kenà metidtu ne metau kew ne ebehey te meupiya riyà te anak niyu, na iyan pè be ke Amey niyu ne Eleteala ne riyà te langit kenà mebehey keykew te meupiya embiya ebuyù kew riyà te kandin. ");
INSERT INTO mbi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ne misan engkey ne egkiyuhan niyu ne ibped-ulaula te menge etew keniyu, ne iring ketà dema se ul-ulaa niyu riyà te kandan. Su ini se meana dut te penduan ne intelau ni Moises wey ke menge penurù dut te menge ebpelamabas te Lalag te Eleteala rengan.” ");
INSERT INTO mbi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Lusud kew riyà te melihet ne gumawan,” ke si Hisus, “ne ebpependiyà te umur ne kenà edtaman. Su meluag ke gumawan ne merayun ke dalan ne ebpependiyà te apuy nerakà, ne merakel ke edtuntul ketà. ");
INSERT INTO mbi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ugaid ne melihet ke gumawan wey mepasang ne ibayà ke dalan ne ebpependiyà te umur ne kenà edtaman, ne merelag dà se ebpeketuen ketà.” ");
INSERT INTO mbi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Uram kew dut te menge etew ne engkungkun ne ebpelambas te Lalag te Eleteala. Su ebpendiyà dan te keniyu ne iring te paras te bilibili ne meamuk, ugaid ne riyà te hinawa ran ne iring dan te mewalew ne asu ne ebpekekaid. ");
INSERT INTO mbi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Egkekilala niyu ke kenà benar ne ebpelambas te Lalag te Eleteala kayi te ulaula ran. Su iring te kayu, kenà ebahas ke sepinit te paras ne kenà ebahas ke degiyangas te igira. ");
INSERT INTO mbi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iring din ded dema ke kayu ne meupiya se kegueyhuey rin ne iyan din dà bahas ne meupiya. Ugaid ne ke kayu ne ruen sakit din ne iyan din bahas ne meraat. ");
INSERT INTO mbi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Su ke kayu ne meupiya se kegueyhuey rin ne kenà ebehas te mereatey, ne ke kayu ne ruen sakit din ne kenà ebahas te meupiya. ");
INSERT INTO mbi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ne langun ne menge kayu ne kenà ebahas te meupiya ne ebpilayen ne idrapug su ebinsulan. ");
INSERT INTO mbi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tembù be igkahi ku keniyu te egkekilala niyu ke kenà benar ne ebpelambas te Lalag te Eleteala kayi te ed-ul-ulaan dan.” ");
INSERT INTO mbi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ne migkahi si Hisus te, “Kenà langun te menge etew ne edtawag kedì te ‘Is Kerenan, Kerenan’ ne ebpekelusud dut te menge etew ne Edetuan te Eleteala ke kenà sikandan dà arà se edtuman dut te kiyug te Amey ku ne Eleteala ne riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Su embiya egkeuma arà se hewii te kegkukum te Eleteala ne merakel se ebpeyiruwiru kedì se egkahi te, ‘Is Kerenan, Kerenan, mibpesabut key te Lalag te Eleteala impepevayà te gehem te ngaran nu, ne mibpenegseg dey ke vusew ne ed-amung-amung te menge etew, ne merakel pà se mekegeyip ne neveelan dey!’ ");
INSERT INTO mbi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ugaid ne iyan ku igkahi kandan te, ‘Sikiyu ne meraat se ulaula, kenà ku egketuenan sikiyu. Awà kew kayi!’ ” ");
INSERT INTO mbi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tembù be,” ke si Hisus, “langun dut te nekerineg te lalag ku ne mibperumaruma, ne ebpekeiring dan te bereitungan ne etew ne riyà mebevaley te meresen. ");
INSERT INTO mbi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ne midadsang ke uran ne midalem ke wayig ne nesuhat te keramag ini se valey, ugaid ne warà ini mepiley su riyà mekeitindeg te meresen. ");
INSERT INTO mbi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ugaid ne langun ne menge etew,” ke si Hisus, “ne nekerineg te lalag ku ne kenà dan ebperumaruma, ne iring dan te etew ne warà itungan din ne mebevaley riyà te pantad. ");
INSERT INTO mbi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne midadsang ke uran ne midalem ke wayig ne nesuhat te keramag ini se valey, ne arà dà ne nerundus en su neawet dà dut te keramag.” ");
INSERT INTO mbi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nekeipus si Hisus se ebpenurù te menge etew ne neinuinu ran nevenar, ");
INSERT INTO mbi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su kenà iring dut te kebpenurù te menge etew ne ebpenurù te penduan te menge Hudiyanen su ruen gehem din ini se penurù din. ");
INSERT INTO mbi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Guna su midtupang si Hisus ketà te buvungan ne mibpenuruan din te menge etew, ne medmerakel se miduma kandin. ");
INSERT INTO mbi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne ruen etew ne egkevuwaen ne muna pà te it-it ne mid-uvey ki Hisus. Ne midlumpeng en sikandin diyà te sineruwan ni Hisus se ebpemuyù te, “Mama, embiya perem egkiyug ke rà ne egkeulian nu ini se meredsik ne sakit ku.” ");
INSERT INTO mbi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ne midampen ni Hisus sikandin se egkahi te, “Uya, egkiyug a,” ke sikandin. “Meulii ka!” Arà dà ne neawà en ke sakit dut te meama su neulian en. ");
INSERT INTO mbi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ne migkahi si Hisus kandin te, “Kenà nu ve imbe kegkehiya ini te misan endei en, ugaid ne riyà ka tilandeng te terebpelengesa ne ibpekita nu kandin te neulian ke en. Ne ivehey nu te Eleteala ke ibpelengesa ne insuhù dengan ni Moises su apey metueni te langun te neulian ka.” ");
INSERT INTO mbi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Guna su nekeuma si Hisus diyà te inged ne Kapirnawum, ne ruen kepitan ne kenà Hudiyanen ne egkamal te menge sundaru ne mid-uvey kandin se ebpemuyù te tavang din. ");
INSERT INTO mbi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mama,” ke sikandin, “duen edsugsuhuen ku ne ederaru riyà te valey ku su minatey ke divaluy ne lawa rin ne merasey nevenar se egeramen din.” ");
INSERT INTO mbi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ne migkahi si Hisus te, “Ebpendiyan a su apey ku meulii sikandin.” ");
INSERT INTO mbi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Mama,” ke se kepitan, “misan kenà ke en edlaus diyà te valey ku, su kenà a dait ne ebpemeneyikan nu. Su dekelà se gehem nu ne misan igkahi nu te, ‘Meulii sikandin,’ ne egkeulian ini se edsugsuhuen ku. ");
INSERT INTO mbi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nesebutan ku ini su siaken ne ruen mepurù ku ne meperumaruma a kandin. Ne ruen menge sundaru ne egkemalan ku ne meperumaruma ran kediey. Su egkahi e rà te, ‘Diyà kew,’ ne iring dan te ebelesiken. Ne engketà ded ke egkahi a te, ‘Kayi kew,’ ne seperek mata ne kayi ran en. Ne embiya edsuhuen ku ini se edsugsuhuen ku te, ‘Ul-ulaa nu ini,’ ne arà en iya rema se ed-ul-ulaan din. Iring de be kayi,” ke se kepitan, “misan edlelehan nu rà ne egkeulian ini se edsugsuhuen ku.” ");
INSERT INTO mbi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nerineg ni Hisus ini ne neinuinu nevenar sikandin ne migkehiyan din ke menge etew ne miduma kandin te, “Sevenarbenar ne igkahi ku keniyu te warà e pà mekeuma te etew ne iring kayi kerekelà se sarig din kediey misan kayi te langun ne kevuwaran ni Israyil. ");
INSERT INTO mbi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ini ve se idtarem ku keniyu ne merakel se menge etew ne egenat te edsilaan taman te edsenlepan ne ebpekeuma su ebpekepinuu te egkaan duma en ni Abraham wey ke anak din ne si Isaac wey ke apù din ne si Jacob diyà te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ugaid ne merakel ne menge kevuwaran ni Israyil ne mibpenehenaan perem te Eleteala dut te Edetuan din ne ibpependiyà te merusirem, ne ketà ne ebpekependerawit wey ebpekengingitel.” ");
INSERT INTO mbi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne migkahi si Hisus dut te kepitan te, “Ulì ke en. Su ke sarig nu kedì ne netuman en.” Ne ketà dà dema ne ke edsugsuhuen din diyà te valey ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ne mibpendiyà si Hisus te baley ni Pedro ne ketà ne nekita rin ke enuhang ni Pedro ne meritan ne ed-id-irehà su edetengen. ");
INSERT INTO mbi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne midampen ni Hisus ke velad din ne neawà en ke rateng din, ne mid-enew sikandin ne mid-ilutù en te ibpekaan kandan. ");
INSERT INTO mbi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Guna su midsanlep en ke andew ne ruen merakel ne menge etew ne midsuukan te vusew ne mibpeneheewit dan kayi te ki Hisus. Ne mibpenegseg ni Hisus ke menge vusew te impepevayà dà te lalag din, ne nengeulian din langun ne ebpenderaru. ");
INSERT INTO mbi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mid-ulaula rin ini su apey metuman ke impesurat ki Isayas ne ebpelambas te Lalag te Eleteala rengan se egkahi te, “Sikandin en iya ke nekeulì te daru tew, ne nekeawà te menge sakit tew.” ");
INSERT INTO mbi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Guna su nekita ni Hisus ke medmerakel ne menge etew ne edlingut kandin ne migkehiyan din ke edumdumaan din te, “Kuwa kiyu en su ed-apet kiyu riyà te ripag te ranew.” ");
INSERT INTO mbi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ketà ne ruen senge etew ne mibpenurù te penduan ni Moises ne mid-uvey kandin ne migkahi te, “Meyterù, eduma a kenikew misan ebpependei ka.” ");
INSERT INTO mbi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne migkahi si Hisus kandin te, “Ke menge laku ne ruen takub ne ed-ul-ulian dan, ke menge pepenuk ne ruen kandan ne salag, ugaid ne ke Impeanak te Menusiyà ne misan endei en memekeirehà su warà ubpaan din.” ");
INSERT INTO mbi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne ruen dema senge etew ne edumdumaan ni Hisus ne migkahi te, “Mama, ed-ulì e pà ne embiya egkepupusan en te ebpeneytayen ke amey ku ne arà pà ne eduma a kenikew, su siaken ded se edleveng kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Kenà,” ke si Hisus, “su duma ka kedì. Ne iyan nu pelevenga rut te minatey ke menge ruma nu ne kenà ebperetiyaya kediey.” ");
INSERT INTO mbi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ketà maa ne mid-untud si Hisus te avang ne miduma ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ne midtekewtekew se mevaher ne keramag ne nekesuhat ketà te ranew ne nelikuvungan en te baleg ini se avang dan. Ugaid ne nekelipereng si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne mid-uvey ran si Hisus ne mibpukew ran en se egkahi te, “Tevangi key, Kerenan, su egkekahem ini se avang ne egkeherà ki en!” ");
INSERT INTO mbi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ne migkahi si Hisus te, “Meambe ke nengeandek-andek kew? Kurang kew te sarig kedi!” Ne mid-enew en ne pineengked din en ke keramag wey menge baleg, ne midlengen en ke ranew. ");
INSERT INTO mbi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ne neinuinu ke menge edumdumaan din se egkahi te, “Engkey ini ne etew? Su misan ke keramag wey menge baleg ne ebperumaruma rut te lalag din!” ");
INSERT INTO mbi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nekerunggù en ensi Hisus diyà te ripag te ranew riyà te sakup te inged te Gadara, ne ketà ne ruen midsinuhung kandin ne deruwa ne etew ne riyà ebpuun te menge surung ne penlelevengan. Midsuukan te vusew ini se deruwa ne etew ne laus ne ebpekekaid ne igkeandek en sikandan te menge etew ne warà en edtikà ne ebpevayà ketà te ralan. ");
INSERT INTO mbi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ne migkuleyì dan te, “Sikuna ke Anak te Eleteala, ne engkey ma se kememeniyà nu kediey? Maa mibpengkayi ka su ebpemekeiran key nu misan kenà pà ini ke timpu?” ");
INSERT INTO mbi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ruen ketà te uvey ran medmerakel ne bavuy ne ebpememenumal. ");
INSERT INTO mbi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne mibpemuyù ke menge vusew ki Hisus te, “Embiya edsegsehen key nikuna ne ketà key nu ipeawuk te menge bavuy.” ");
INSERT INTO mbi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Migkahi si Hisus kandan te, “Kuwa kew en!” Ketà dà ne mid-ewaan dan en ke meama ne mibpengasuk dan en dut te menge bavuy, ne mibpemelelahuy en ke menge bavuy se ed-umpak diyà te dempilas ne nengelened dan en diyà te ranew. ");
INSERT INTO mbi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nekita ini rut te menge etew ne edtuganur ketà te menge bavuy ne mibpemelelahuy ran en diyà te inged su impemenudtul dan ini wey ke ned-ulaula rut te menge etew ne midsuukan te vusew. ");
INSERT INTO mbi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Guna su netuenan dut te menge etew ketà te inged ne midsamasama ran mibayà ki Hisus. Guna su nekeuma ran ne mibpemuyù dan kandin te menu ke med-awà sikandin ketà te inged dan. ");
INSERT INTO mbi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ne mid-untud en maa si Hisus te avang ne mid-apet dut te ranew ne mid-ulì diyà te inged din. ");
INSERT INTO mbi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne ruen menge etew ne nekeuma ne ed-ewit te etew ne mid-irehà diyà te duyanà ne minatey se tevì ne lawa rin. Guna su netuenan ni Hisus te rekelà ke sarig dan kandin ne migkehiyan din en ke minatey se tevì ne lawa rin te, “Kenà ka egkeuru, Mama. Nepesehad en ke keberedusaan nu.” ");
INSERT INTO mbi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ketà ne ruen dema ebpinpinuu ne menge etew ne ebpenurù te penduan ne guna su nerineg dan ini ne iyan netahù te hinawa ran te, “Ini ne etew ne edsumpalit te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ugaid ne netuenan en ni Hisus ke netahù te itungan dan, ne migkahi en sikandin diyà te kandan te, “Meambe ke netahù te itungan niyu se iring keniyan ne meraat? ");
INSERT INTO mbi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Endei rapit se melemu,” ke si Hisus, “te egkahi riyà te minatey se lawa rin te, ‘Ke menge salà nu ne nepesehad en’ etawa ve ke egkahi te, ‘Enew ka ne luluna nu ke ikam nu na ipanew ke en’ ”? ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Ugaid ne guntaani ne ibpekita ku keniyu te ruen gehem dut te Impeanak te Menusiyà te ebpesahad te salà kayi te ampew te dunya.” Ketà ne migkehiyan din ke etew ne minatey ke lawa rin te, “Mama, enew ke en ne luluna nu ke ikam nu ne ulì ke en!” ");
INSERT INTO mbi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne mid-enew en ke etew, ne midlulun din ke ikam din ne mid-ulì en. ");
INSERT INTO mbi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Guna su nekita rut te langun ne menge etew ketà ne nengeandek dan, ne nereyù dan ke Eleteala su imbehey rin te menusiyà ini se gehem ne iring kayi. ");
INSERT INTO mbi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ne mid-awà en si Hisus ketà, ne gewii rin te ed-ipanew ne nekita rin ke senge etew ne meama ne ebpevayad te buwis ne ed-ingaranan ki Mateo ne ebpinuu riyà te upisinà din. Ne migkehiyan ni Hisus sikandin te, “Duma ka kediey.” Arà dà ne mid-itindeg si Mateo ne miduma en kandin. ");
INSERT INTO mbi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ne senge hewii ne pinekaan si Hisus wey ke menge edumdumaan din diyà te valey ni Mateo, ne merakel ne ebpevayad te buwis wey ke menge kenè en birang ne menge etew ne nekeuma ne elin dan ki Hisus se migkaan ketà. ");
INSERT INTO mbi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Guna su nekita rut te menge Peresiyu ne dutun te uvey te valey ne nevurunan te ini se menge etew su egkaan, ne netegtehaad ne mibpendiyà dan te menge edumdumaan ni Hisus ne mid-insà te, “Meambe ke edseveka sikandin se egkaan ketà te menge etew ne ebpevayad te buwis wey ke menge kenè en birang ne menge etew?” ");
INSERT INTO mbi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nerineg dà ni Hisus arà ne migkehiyan din en sikandan te sempità te, “Ke menge etew ne warà daru rin ne kenà dan ebpendiyà te terevawì, ugaid ne ke menge etew rà ne duen daru rin. ");
INSERT INTO mbi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ne iring din ded be rema kayi ini se menge etew su kenà iyan ku kinepengkayi se iyan ku ebpeuveyen ke menge metidtu kun se ulaula rin, ugaid ke menge etew ne kenà en birang apey ran mekedsendit,” ke si Hisus. “Ne ketà ne pegpegitunga niyu ke engkey se meana rut te impesurat ne Lalag te Eleteala ne egkahi te, ‘Kenà ku iyan egkiyuhan ke menge binatang ne ibehey niyu kedì ne ibpelengesa, ugaid ke kegkeyru niyu rut te menge ruma niyu.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ne ruen menge edumdumaan ni Juan ke Ebpembunyag ne nekeuma kayi te ki Hisus ne mid-insà te, “Sikami wey ke menge Peresiyu ne layun edlimpas te egkaan, ugaid ne ke menge edumdumaan nu ne kenà edlimpas te egkaan. Ne meambe ini?” ");
INSERT INTO mbi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ne midtavak si Hisus te, “Embiya ruen egkewingen, maa edlimpas ves maa te kegkaan ke menge etew ne pinetelavuk te ini pà ke ibpengesawa te kandan? Kenà en iya! Ugaid ne ruen hewii ne egkeuma ne egkeawà ke ibpengesawa diyà te kandan, ne ketà dan pà edlimpas te egkaan.” ");
INSERT INTO mbi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne migkahi maa si Hisus te, “Kenà edait ne idapi nu ke behu ne saput ketà te neredit en ne velegkas, su embiya ebpedepiyen nu ne ketà te kebpìpii nu ne egkenseng ke vehu ne saput ne egkevindas ke redit en ne velegkas ne tuwas pà te keluag te bisey rin. ");
INSERT INTO mbi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne iring din ded dema,” ke si Hisus, “ke behu ne tebà su kenà egkepakey ne riyà nu idtahù te raan en ne edtehuan ne mibeelan ne lundis. Su embiya arà se ed-ul-ulaan nu ne edsevu ke tebà ne ebetu ke lundis ne midtehuan, ne edturayas ke tebà ne egkereetan, ne egkereetan dema ke midtehuan ne lundis. Tembù be iyan nu iya tehui te behu pà ne tebà ini se edtehuan ne behu pà ne mibeelan apey kenà egkereetan arà se tebà wey ke midtehuan.” ");
INSERT INTO mbi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gewii te edlalag pà si Hisus kayi ne nekeuma se senge etew ne egkeunutan te menge Hudiyanen ne midlumpeng en diyà te etuvangan ni Hisus se egkahi te, “Behu pà ne minatey ke anak ku ne meritan, ugaid ne pengkayi ke en apey nu dempena sikandin ne egkeuyag ded.” ");
INSERT INTO mbi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ne mid-itindeg si Hisus ne midumaan kandin te ed-ulì abpeg ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ne ruen meritan ketà dema ne nerasey nevenar su nekedsepulù en wey deruwa ne rahun se kebpemundasa rin te lengesa ne kenà egkeengked. Mibpenelektelek en sikandin diyà te uriyan ni Hisus ne mid-amì din dà ke belegkas ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Su kehingginawa rin te, “Embiya egkeamì ku rà misan ke belegkas din ne egkeulian en ini se sakit ku.” ");
INSERT INTO mbi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Midlingì si Hisus ne nekita rin ini se meritan ne migkahi te, “Bayi, kenà ka egkeuru! Neulian ke en su sabap dut te kinesarig nu kediey.” Arà dà ne neulian en ke meritan. ");
INSERT INTO mbi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ketà ne mibpendiyan en si Hisus te baley te egkeunutan te menge Hudiyanen. Guna su nekita rin ke menge ebpememulendag te ediyaga te minatey, ne nerineg din en se ebpemenderawit, ");
INSERT INTO mbi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ne migkehiyan din sikandan te, “Awà kew langun! Warà minatey ayan se vatà su nekelipereng dà sikandin!” Nerineg dan dà ini ne mid-engitan dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Guna su mibpengawà en ke menge etew ne midlusud en si Hisus diyà te mibpereyasan dut te vatà ne migeweran din ke velad te vatà ne mid-enew en se ed-ipanew. ");
INSERT INTO mbi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne nekeeneb en ke tudtul mekeatag dut te ini ne ned-ulaula diyà te langun ne nekeerivey ne inged ketà. ");
INSERT INTO mbi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ne mid-awà si Hisus ketà ne gewii rin te ed-ipanew ne ruen deruwa ne etew ne pisek ne edtundug kandin. Midtawag dan kandin se ebpemuyù te, “Ey, sikuna ne kevuwaran ni David, ikeyru key nikuna!” ");
INSERT INTO mbi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Guna su nekepemenayik en si Hisus diyà te valey ne mid-uvey ke deruwa ne etew ne nepisek. Ne mid-insaan din sikandan te, “Menu, ebperetiyaya kew ve te egkeulian ku sikiyu?” “Uya, Mama, ebperetiyaya key,” ke se menge pisek. ");
INSERT INTO mbi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ne midampen ni Hisus ke mata ran ne migkahi te, “Sabap te kebperetiyaya niyu ne meulii kew en!” ");
INSERT INTO mbi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Arà dà ne nekekita ran en. Ne mid-il-ilutan ni Hisus te egkahi kandan te, “Kenà niyu penudtula ini te misan entei!” ");
INSERT INTO mbi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ugaid ne mid-awà dan ketà ne nasì dan en in-eneb ke tudtul mekeatag ki Hisus diyà te langun ne nekeerivey ne inged ketà. ");
INSERT INTO mbi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gewii te ed-awà en ke menge etew ne ruen maa menge etew ne nekeuma kayi te ki Hisus ne ed-ewit te senge etew ne neemew su midsuukan te vusew. ");
INSERT INTO mbi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ugaid ne guna su midsegseg en ni Hisus ke vusew ne mibpemekaid, ne nekelalag en ini se meama. Ne negeyip nevenar ke langun ne menge etew ketà ne mibpein-inseey ran te, “Taman te taman en ne warà tew pà mekita se iring kayi kayi te bansa tew te Israyil.” ");
INSERT INTO mbi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ugaid ne migkahi ke menge Peresiyu ketà te, “Ke unuten te menge vusew se mibehey kandin te gehem te kebpenegseg te menge vusew.” ");
INSERT INTO mbi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ne mid-eneb ni Hisus te ebayà ke langun ne reisek dekelà ne menge inged. Mibpenurù diyà te menge valey ne ebpengedian te menge Hudiyanen te penduan dan, ne impesabut din kandan ini se Meupiya ne Tudtul te Kedetui te Eleteala te menge etew, wey nengeulian ke menge etew ne ebpenderaru te misan engkey en ne ebpenggeramen. ");
INSERT INTO mbi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ne uman din mekita ke medmerakel ne etew ketà ne egkeyruwan din sikandan su merungkug dan wey mekeyruwiru su iyan dan neiringan ne menge bilibili ne warà tumetuganur. ");
INSERT INTO mbi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne migkahi si Hisus diyà te menge edumdumaan din te, “Medmerakel se menge etew ne warà pà meketelimà dut te Meupiya ne Tudtul mekeatag te Eleteala. Iring dan te nelutuan ne parey. Meluag nevenar ini se pareyanan, ugaid ne warà utew ruma ne ebpengehani. ");
INSERT INTO mbi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pemuyù kew riyà te kemuney te pareyanan te medsuhù pà sikandin te ruma ne ed-ehani diyà te pareyanan din.” ");
INSERT INTO mbi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ne miburun ni Hisus ke sepulù wey deruwa ne edumdumaan din ne mibehayan din te gehem te kebpekesegseg te vusew ne ed-amung-amung te menge etew, wey gehem ne ebpekeulì te misan engkey ne daru wey sakit. ");
INSERT INTO mbi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ini ke menge ngaran dut te sepulù wey deruwa ne edumdumaan din ne mid-ingaranan ni Hisus te epustulis: ke egkeuna ne si Simon (ke ed-ingaranan dema ki Pedro) wey ke ari rin ne si Andres; si Santiago wey ke ari rin si Juan ke menge anak ni Sibidiyu; ");
INSERT INTO mbi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Si Felipe wey si Bartolome; si Tomas wey si Mateo ke ebpevayad te buwis; si Santiago ke anak ni Alpiyu, wey si Tediyu; ");
INSERT INTO mbi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon ke Patriat ne iyan din meana ne diralem se lengesa rin dut te inged din, wey si Hudas Iskeriyuti ke ed-ulug ki Hisus te ked-imetayi. ");
INSERT INTO mbi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ini se sepulù wey deruwa ne impeipanew ni Hisus ne midteleenan din te, “Kenà kew ebpendiyà te menge inged te menge etew ne kenà Hudiyanen wey menge inged te Semeriya. ");
INSERT INTO mbi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ugaid ne diyà kew te menge ruma tew ne menge kevuwaran ni Israyil ne iring te menge bilibili ne nelaag. ");
INSERT INTO mbi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Diyà kew pesabut kandan te mehaan en ebpekeuma ke Kedetui te Eleteala te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bewii niyu ke menge ederaru, benawa niyu ke menge minatey, bewii niyu ke menge kevuwaen, wey penegseha niyu ke menge vusew ne ed-amung-amung te menge etew. Ini se netelimà niyu ne riyà ebpuun te Eleteala ne warà niyu mevayari, ne kenà niyu rema buyui ke egketevangan niyu. ");
INSERT INTO mbi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kenà kew ewit te bulawan, pirak etawa pelatà kayi te kemuyut nu. ");
INSERT INTO mbi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kenà kew ewit te kempiru te ked-ipanew niyu, etawa idsambì ne belegkas wey telumpà, wey misan tuked. Su ke egelevek ne dait ne ebehayan te igkeuyag din. ");
INSERT INTO mbi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Piya endei ne inged ne egkeumaan niyu, misan dekelà ne inged etawa deisek dà, ne pemengà kew te etew ne ebpepemenayik keniyu, ne ketà kew rà rateng taman te ked-awà niyu ketà te inged. ");
INSERT INTO mbi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Embiya ebpemenayik kew te valey ne penubtuvari niyu ke ed-ubpà ketà te valey te, ‘Ebpeneuven kew te Eleteala!’ ");
INSERT INTO mbi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne embiya edtelimaen kew rut te etew ketà te valey, ne ke kinepenuvadtuvad niyu ne egketuman ketà te kandan. Ugaid ne embiya kenà dan edtelimà keniyu, ne ke kinepenuvadtuvad niyu ne keniyu red. ");
INSERT INTO mbi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne embiya ruen inged ne warà ketà ne edtelimà keniyu etawa kenà dan ebpemineg dut te ibpesabut niyu, ne ewai niyu sikandan wey pendegdeha niyu ke lipupuk diyà te menge paa niyu. ");
INSERT INTO mbi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sevenarbenar ini se idtarem ku keniyu,” ke si Hisus, “muna pà ke kedusai te Eleteala kandan ketà te hewii ne kedtimbang din te menusiyà dut te kinerusa rin te menge mehinged ketà te Sudum wey Gemura.” ");
INSERT INTO mbi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pemineg kew,” ke si Hisus, “su edsuhuen ku sikiyu riyà te menge etew ne ebpekekaid, ne iring kew te menge bilibili ne ebpekeseruk diyà te senge ingeren en ne mewalew ne asu. Tembù be ingat kew ne pekeibpes kew iring te uled, ugaid ne kayi te ulaula niyu ne iring kew te melepati ne meamuk. ");
INSERT INTO mbi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Uram kew su ebpenigkemen kew te menge etew ne ibpepemenayik kew diyà te kukuman. Ne ebpenruuhen kew riyà te valey ne ebpengedian te penduan te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne edtuyuken kew riyà te menge egkeunutan wey menge mepurù su atag dut te kedsarig niyu kediey, ugaid ne ini en imbe ke ralan te kebpesabut niyu kandan wey ke menge kenà Hudiyanen dut te Meupiya ne Tudtul mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ketà te ibpepemenayik kew riyà te kukuman, ne kenà kew meuru ke ebmenmenuwen niyu se kedlalag niyu te kedtindeg te hinawa niyu wey engkey se ralan te kegkahi niyu, su ketà ne iyan niyu egkekahi ne lalag ne ibpekahi keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Su iyan niyu egkekahi ne kenà keniyu ne lalag, ugaid ne lalag ne riyà ebpuun te Kedesenan ne Ebpetuntul te Menusiyà ne midsuhù te Amey tew ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Su ketà ne hewii ne ruen menge etew ne misan ke temperà dan te pused ne ed-uluhen dan su ebpeimetayan, ne iring din ded dema ke ed-ul-ulaan te amey dut te menge anak din. Ne ruen menge anak ne ebpekid-atu te menge lukes dan su ebpeimatayan dan. ");
INSERT INTO mbi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ne egkunteraan kew te langun su atag te keduma niyu kediey, ugaid ne ke etew ne kenà edsuwey te keduma rin kediey taman te kayi pà sikandin te ampew te dunya ne ebpekehaked te umur ne kenà edtaman. ");
INSERT INTO mbi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Embiyà ebpekesekitan kew nikandan diyà te senge inged su sabap te kebpesabut niyu ne pelahuy kew riyà te ruma pà ne inged. Su sevenarbenar ne igkahi ku keniyu te kenà niyu pà egkepasad ke helevek niyu riyà te langun ne menge inged te Israyil ne edlived en ke Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Su warà etew,” ke si Hisus, “ne ebpepenurù pà ne iyan en mepurù dut te ebpenurù kandin, ne warà uripen ne iyan en mepurù dut te mibpengunguripen kandin. ");
INSERT INTO mbi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tembù be ebmehalew ke etew ne ebpepenurù pà ke egketamat din en ke ibpenurù kandin su apey ebpekeiring en sikandin dut te ebpenurù kandin. Ne iring din ded dema ke uripen ke ebpekeiring en dut te mibpengunguripen kandin. Ne embiya ke pengulu dut te telteleanak ne ed-ingaranan ki Bilsibul ke egkeunutan te busew ne iyan pè be kenà tuwas pà ne meraat ke id-ingaran dut te menge anak din.” ");
INSERT INTO mbi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Iyan se kenà kew meandek,” ke si Hisus, “dut te menge etew. Su langun te netelevan guntaani, ne ebpekepehawahawa red keuremà. Ne langun ne impegelesà, ne egkepayahan ded. ");
INSERT INTO mbi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ini se ingkahi ku keniyu te merusirem, ne ipenudtul niyu en diyà te kerayahan. Ne ini se lalag ku ne sikiyu rà se nekerineg, ne ibpesabut niyu riyà te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne kenà kew meandek dut te menge etew ne iyan dà egkepatey se lawa niyu, ugaid ne kenà dan ebpekepatey te himukud niyu. Ugaid ne iyan niyu ikeandek ne Eleteala, su kenà lawa niyu rà se egkepatey rin su ruen gehem din te kebpekeantug te himukud niyu riyà te apuy nerakà. ");
INSERT INTO mbi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Su ruen deisek ne pepenuk ne egkepemasa te lelima ne timan ne deruwa rà ne tumbaha. Ne misan iring ketà se kevavà te elehà din, ne warà seveka kandan ne egkeulug diyà te tanà embiyà kenà egkiyug ke Amey niyu ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne iyan kew pè be melipati te Eleteala su misan ke edtiweruwan te bulvul niyu ne nevirang din en. ");
INSERT INTO mbi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Engketà be ne kenà kew meandek su iyan kew pà belielehà diyà te kandin dut te merakel ne pepenuk.” ");
INSERT INTO mbi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Piya engkey ne etew,” ke si Hisus, “se ebpayag diyà te menge etew se ebpesakup kediey, ne iyan ku rema ibpayag diyà te suluhuen te Amey ku ne Eleteala diyà te langit ne ed-engkunen ku sikandin te kediey ne sakup. ");
INSERT INTO mbi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ugaid,” ke si Hisus, “piya engkey ne etew se ebparew riyà te menge etew te sakup ku sikandin, ne kenà ku rema ed-engkunen te sakup ku sikandin diyà te menge suluhuen te Amey ku ne Eleteala diyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Maa, iyan niyu kunaan,” ke si Hisus, “ke ini se kinepengkayi ku ne ed-ewit a te kebmelinew kayi te kelibutan? Kenà iring ketà! Su idtarem ku keniyu te kenà kebmelinew, ugaid ne kayi ebpuun te kinepengkayi ku ne ebpekunkuntereey ke itungan dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Su sabap te mibpengkayi a ne egkunterà ke menge anak ne meama dut te amey ran, ne egkunterà ke menge anak ne meritan dut te iney ran, ne egkunterà ke enuhang ne meritan dut te ambey ran, ");
INSERT INTO mbi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ne iyan mepasang ne egkekunterà te menge etew ke megeget ne sikandan ded ne ebpenusuled. ");
INSERT INTO mbi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Embiyà ruen etew ne iyan pà dekelà se limù din dut te amey rin wey iney rin kenà siaken, ne kenà edait sikandin ne edumdumaan ku. Iring din ded dema ke etew ne iyan pà dekelà se limù din dut te anak din kenà siaken, ne kenà edait sikandin ne edumdumaan ku. ");
INSERT INTO mbi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ke etew ne egkiyug ne eduma kediey ne iyan iya se lipati rin ke kandin ne kiyug ne tianga rin ke kandin ne pinebelavag ne kayu ne ed-ingaranan te krus ne iyan din meana ne tumana rin ke menge suhù ku misan ibpatey rin. Su embiya kenà, ne kenà edait sikandin ne edumdumaan ku. ");
INSERT INTO mbi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Su ke etew ne egkenuhun te umur din, ne ebpatey lavew. Ugaid ke etew ne iyan din ibpatey se keduma rin kediey te kebpemesabut dut te Meupiya ne Tudtul, ne ruen umur ne ibehey kandin ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Piya entei ne etew,” ke si Hisus, “ne edtelimà keniyu, ne midtelimà dema kediey. Ne misan entei ne etew ne edtelimà kediey, ne kenà siak dà se midtelimà din su ke Amey ku rema ne Eleteala ne midsuhù kediey ne midtelimà din ded. ");
INSERT INTO mbi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ne piya entei ne etew ne edtelimà te etew ne ebpelambas te Lalag te Eleteala su midtendù te Eleteala ini se etew ne ebpelambas te lalag din, ne egkevehayan te Eleteala arà se etew te lalew iring dut te lalew te midtendù din ne ebpelambas te lalag din. Ne iring din ded dema ke etew ne edtelimà te metidtu ne etew su sabap te ketidtu rin, ne egkevehayan te Eleteala te lalew iring te lalew dut te metidtu ne etew. ");
INSERT INTO mbi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne benar ini se egkehiyen ku keniyu, misan meadsil dà ne wayig se ibpeinum dut te senge etew ne edumdumaan ku su atag dut te keduma rin kediey, ne ruen lalew rin. Misan ke kevevaan en dut te edumdumaan ku ini se pineinum din.” ");
INSERT INTO mbi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nekepasad si Hisus te kebpenurù din dut te sepulù wey deruwa ne edumdumaan din, ne mid-awà sikandin ketà ne mibpendiyà te menge sepiring ded ne inged su ebpenurù wey ebpesabut te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ugaid ne riyan en te bilengguan si Juan ke Ebpembunyag. Ne guna su nerineg din ke mekegeyip ne mid-ulaula ni Hisu Kristu, ne ruen menge edumdumaan din ne midsuhù din diyà te ki Hisus te ebpeinsaen. ");
INSERT INTO mbi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nekeuma ran ne migkahi ran te, “Menu, sikuna ke impesabut ni Juan ne ibpepengkayi te Eleteala etawa ruen duma pà ne egkepenareng dey?” ");
INSERT INTO mbi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ne midtavak si Hisus te, “Ulì kew en diyà te ki Juan ne penudtula niyu kandin ini se nekita niyu ne mid-ulaula ku wey ini se nerineg niyu ne migkahi ku. ");
INSERT INTO mbi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iyan niyu peketueni kandin ne kayi ebpuun te kediey ne nekeulit en se kebpekekita rut te menge pisek, nekeipanew en ke menge pungkù, neulian en ke menge kevuwaen, nekerineg en ke menge bengel, neuyag en ke menge minatey wey impesabut ku ke Meupiya ne Tudtul diyà te menge ayuayu,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Ne peketueni niyu kandin te dayirayi nevenar ke etew ne kenà eduwaruwa kediey.” ");
INSERT INTO mbi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Guna su nekehenat en ke menge edumdumaan ni Juan, ne midlalag en si Hisus mekeatag ki Juan diyà te denda ne menge etew ne nevurun, ke sikandin te, “Ketà te kinependiyà niyu te ki Juan diyà te tanà ne kenà egkeubpaan te menge etew, ne engkey se mibpenareng niyu? Maa, ebpenareng kew te ebpekekita kew te etew ne iring te karan ne edsemsemberen te keramag? ");
INSERT INTO mbi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Engkey ve iya, etew ne mibevelegkas te nepenù te rayandayan? Kenà buwa, su ke etew ne mibevelegkas te iring ketà ne riyà niyu rà egkekita te turuhan te menge ratù. ");
INSERT INTO mbi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na, engkey ve iya se mid-intengan niyu? Engkey, etew ne ebpelambas te Lalag te Eleteala? Arà imbe! Ugaid ne igkahi ku keniyu te arà se nekita niyu ne labi pà dut te etew ne ebpelambas te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Su si Juan ini ke nekahi te Eleteala rut te impesurat ne Lalag din rengan se egkahi te, ‘Duen edsuhuen ku ne ibpeuna ku keykew te kebpekepenehana rut te menge etew te kebpekeuma nu.’ ");
INSERT INTO mbi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sebenarvenar ini,” ke si Hisus, “warà pà etew ne in-anak kayi te ampew te dunya ne ebpekerepeng ki Juan ke Ebpembunyag. Ugaid ne misan ke kevevaan en ne etew dut te langun ne Edetuan te Eleteala diyà te langit keuremà ne muna pà sikandin ki Juan. ");
INSERT INTO mbi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Igenat dut te kebpesabut ni Juan taman guntaani ne mibpekepesangan ini se menge Edetuan te Eleteala riyà te langit, ne ruen menge etew ne edtehel ed-ahew te Kedatù. ");
INSERT INTO mbi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Su ini se Edetuan te Eleteala ne impesabut dengan dut te langun ne ebpelambas te Lalag te Eleteala wey riyà te penduan ni Moises taman te hewii ne migemew en si Juan. ");
INSERT INTO mbi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne impesabut dan dema te edlived ded si Elias, senge etew ne ebpelambas te Lalag te Eleteala rengan. Ne embiya egkiyug kew ne ebperetiyaya dut te impesabut dan, ne si Juan ne si Elias ded. ");
INSERT INTO mbi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tembù be,” ke si Hisus, “itaan niyu ke telinga niyu kayi te migkahi ku ini!” ");
INSERT INTO mbi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ugaid ne ini se menge etew te huntaani en,” ke si Hisus, “engkey se ebpeiringan ku? Iring dan en iya te menge vatà ne ebpemimpinuu riyà te kevurunan. Ed-umew ini se senge puntuk diyà te menge ruma ran te, ");
INSERT INTO mbi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Midlebpad key, ugaid ne warà kew medsayew! Mibminudar key, ugaid ne warà kew medsinehew!’ ");
INSERT INTO mbi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iring din ded dema ke kebpekeuma ni Juan, su nekita niyu te edlimpas te kegkaan si Juan ne kenà dema ed-inum te piya engkey ne ebpeketevereg ne iyan niyu migkahi se, ‘Midsuukan sikandin te vusew!’ ");
INSERT INTO mbi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ne mibpengkayi ke Impeanak te Menusiyà ne nekita niyu te migkaan sikandin wey med-inum ne iyan niyu maa migkahi se, ‘Tengtengi niyu ma ayan se midelungan te bitil! Ne metehel ne ed-inum! Ne teleduma kayi te ebpevayad te buwis wey misan ke menge etew ne kenà en birang.’ Ugaid, ke si Hisus, ketà te menge ulaula te menge etew ne tidtu ne mibperetiyaya te Eleteala ne nekeheram te limù din, ne egkekita te utew metau ke Eleteala te langun ne petiralan din.” ");
INSERT INTO mbi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ne midsewayen ni Hisus ke menge etew ketà te inged ne merakel se impekita rin ne menge mekegeyip, su warà dan engkeri ke menge meraat ne ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Sikiyu ne menge etew riyà te inged ne Kurasin,” ke si Hisus, “mekeandek-andek se egketemanan niyu! Ne sikiyu riyà te inged ne Bitsaida, mekeandek-andek dema se egketemanan niyu! Su embiya ke menge etew rà diyà te menge inged ne Tiru wey Sidun se nekekita kayi te menge mekegeyip ne mid-ulaula ku riyà te keniyu, ne neuhet dà ne mid-ewaan dan en ke meraat ne ulaula ran ne mibevelegkas dan en te sakù ne mid-evuwan dan ke ulu ran su tuus te nekedsendit dan. ");
INSERT INTO mbi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tentenuri niyu ini su ketà te hewii ne kedtimbang te Eleteala te menusiyà ne iyan pà dekelà se kedusa te Eleteala keniyu rut te menge mehinged te Tiru wey Sidun. ");
INSERT INTO mbi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne sikiyu rema ne menge etew riyà te inged ne Kapirnawum,” ke si Hisus, “egkesuat kew perem ne ebpekesugkur diyà te langit, ugaid ne ibpeantug kew riyà te apuy nerakà. Su ini se mekegeyip ne mid-ulaula ku ne impekita ku keniyu ne embiya ingkepekita ku rà ini riyà te inged ne Sudum, ne warà dan dereeti te Eleteala ne kemulu ran pà guntaani. ");
INSERT INTO mbi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tembù be tentenuri niyu ini su ketà te hewii ne kedtimbang te Eleteala te menusiyà, ne muna pà se kedusai rin keniyu rut te mehinged diyà te Sudum!” ");
INSERT INTO mbi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ne ketà ne mibpengeningeni si Hisus se egkahi te, “Ew Amà, sikuna ke Kerenan diyà te langit wey kayi rema te ampew te dunya. Dekelà se kebpeselamat ku kenikew su impayag nu ke ketau nu rut te menge etew ne warà egketùtuenan din, ne in-eles nu ini se ketau nu rut te menge etew ne dekelà se netuenan din. ");
INSERT INTO mbi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Uya, dekelà se kebpeselamat ku kenikew, Amà, su ini se mid-ulaula nu ne ini ke kiyug nu.” ");
INSERT INTO mbi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ne migkahi si Hisus diyà te menge etew te, “Ke Amey ku se mibpesarig kediey te langun taman. Warà netau kedì te Anak a te Eleteala liyu rà te Amey ku ne Eleteala. Ne warà netau te Amey ku ne Eleteala liyu rà te siaken ne Anak din wey ke menge etew ne egkiyuhan ku te ebpayag mekeatag dut te Amey ku.” ");
INSERT INTO mbi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Pengkayi kew te kediey,” ke si Hisus, “langun niyu ne nengeluhat wey nengevehatan, su ebpeimelayen ku sikiyu. ");
INSERT INTO mbi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Isangan niyu ke ingkul ku diyà te keniyu ne iyan din meana ne guru kew kayi te kedì ne tumana niyu ke penurù ku, ne ebpekeimeley kew su siaken ne metmetulanged wey dekelà se kegkeyru ku. ");
INSERT INTO mbi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Su ini se penurù ku ne melemu ne edtumanen, ne meagkap ini se ibpevava ku keniyu.” ");
INSERT INTO mbi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Senge hewii te Sepetu, ke Hewii ne Id-imeley, ne midtarà en si Hisus diyà te pareyanan. Nevitil ini se menge edumdumaan ni Hisus ne mibpengetu ran ke tiugkayan ne mibpengurib su idsungit dan. ");
INSERT INTO mbi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nekita rà ini dut te menge Peresiyu ne migkehiyan dan en si Hisus te, “Tengtengi nu ma ayan se menge edumdumaan nu su nekesurang en ayan se ed-ul-ulaan dan dut te Penduan tew ne egkahi te warà egelevek te Andew te Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ne migkehiyan ni Hisus sikandan te, “Maa, warà niyu ves mevasa ke impesurat te Eleteala mekeatag te mid-ulaula ni David, ke ratù tew rengan? Su ruen hewii ne sikandin wey ke menge sundaru rin ne nengevitil dan. ");
INSERT INTO mbi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ne midlusud si David diyà te Valey te Eleteala ne migkuwa rin ke egkeenen ne indenà diyà te Eleteala ne migkaan din ne mibehayan din ke menge ruma rin. Ugaid ne kayi te Penduan tew ne kenà arà egkekaan te piya entei ne etew su ke menge terebpelengesa rà te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nevasa niyu red ura kayi te Penduan tew ne impesurat ki Moises ne egelevek ded ke menge terebpelengesa riyà te Nekebpuru ne Valey te Eleteala ketà te Hewii ne Id-imeley misan ebpekesurang dut te Penduan tew te arà ne hewii, ugaid ne warà mekedsalà. ");
INSERT INTO mbi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Benar ini se igkahi ku keniyu,” ke si Hisus, “te ruen nekeuma en kayi ne muna pà se gehem din dut te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Su ruen impesurat ne Lalag te Eleteala ne egkahi te, ‘Kenà ku iyan egkiyuhan ke menge binatang ne ibehey niyu kedì ne ibpelengesa, ugaid ke kegkeyru niyu rut te menge ruma niyu.’ Embiya nesebutan niyu ke meana kayi te impesurat ini,” ke si Hisus, “ne warà kew mekekahi geina te nekedsalà ini se menge etew ne warà meraat ne mid-ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Su ke Impeanak te Menusiyà ke ebayàbayà se egkahi te engkey se edait ne ed-ul-ulaan dut te Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mid-awà si Hisus ketà ne mibpendiyà te baley ne ebpengedian te menge Hudiyanen te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne ruen ketà senge etew ne meama ne nekeyengkeng se belad din. Duen dema ketà menge Peresiyu ne ebpenipat ki Hisus su ebpemengà dan te kebpekesurang din te penduan dan kayi te Hewii ne Id-imeley apey ruen id-isuhat dan kandin ne kevenar. Ne mid-insà dan ki Hisus te, “Kayi te penduan tew menu, idtuhut be kenitew se ebpemawì te Hewii ne Id-imeley?” ");
INSERT INTO mbi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne migkahi en si Hisus kandan te, “Embiya ruen senge etew keniyu ne ruen bilibili rin ne neulug diyà te meralem ne kalut te Hewii ne Id-imeley, ne maa kenà niyu edegdehawan te ebpehaun su geina ne Hewii ne Id-imeley? ");
INSERT INTO mbi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne muna pà ne belielehà ke etew dut te bilibili! Tembù be kayi te penduan tew ne kenà ki ebpekesurang ke edtevangan ta te ruma ta misan Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ne migkehiyan en ni Hisus ke meama ne nekeyengkeng ke velad din te, “Mama, ketenga nu ayan se velad nu.” Ne ketà ne migketeng dut te meama ke velad din ne neulian en, ne warà ded bira rin dut te divaluy ne velad din. ");
INSERT INTO mbi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ketà ne mid-awà ke menge Peresiyu ne mibpemengà dan se ralan te kegkeimetayi ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Guna su nerineg ni Hisus ini se netahù te itungan rut te menge Peresiyu, ne mid-awà sikandin ketà te inged ne denda ne menge etew se miduma kandin. Ne neulian din ke langun ne ebpenderaru, ");
INSERT INTO mbi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ugaid ne mibenduan ni Hisus sikandan te kenà dan peketueni te ruma ne etew ini se mid-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iyan din kinekahi kayi su apey metuman ke impesurat te Lalag te Eleteala ne impekahi ki Isayas te, ");
INSERT INTO mbi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ini ke sugsuhuen ku ne mibpemilì ku, sikandin ke igkelimù ku, ne ebpekesuhat sikandin te hinawa ku. Ebpelumunan ku sikandin dut te Kedesenan ne Ebpetuntul te Menusiyà, ne ini se metidtu ne kukuman ku ne ibpesabut din diyà te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ugaid ne kenà sikandin ebpekidlawan etawa ebpemensag, ne kenà sikandin edwaakwaak en se edlalag diyà te kevurunan te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Embiya idsempità ta ke ulaula rin kayi te menusiyà, ne kenà din ebedtien en ke etew ne iring te subpang ne migerì en, ne edtulengeran din ke etew ne iring te ebmelatmelat ne sulù ke sarig din, ne kenà ed-engked ke tavang din taman te egketalew rin langun ne kenà metidtu. ");
INSERT INTO mbi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne kayi te kandin ne ebpekesarig ke langun ne menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne ruen menge etew ne mid-ewit kayi te ki Hisus te etew ne nepisek wey neemew su midsuukan te vusew. Midsegseg ni Hisus ke vusew kayi te meama ne neulian en, ne nekelalag wey nekekita en. ");
INSERT INTO mbi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nengegeyip ke menge etew ketà ne ke sikandan te, “Menu, sikandin be buwa ini ke nekahi te Eleteala ne kevuwaran ni David ke datù tew rengan?” ");
INSERT INTO mbi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Guna nerineg ini rut te menge Peresiyu ketà ne migkahi ran te, “Si Bilsibul ke unutan te menge vusew se mibehey kandin te gehem te kebpenegseg te menge vusew.” ");
INSERT INTO mbi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ugaid ne netuenan ni Hisus ke netahù te itungan dan ne migkahi en te, “Upama ke ruen datù te inged ne iyan ded ed-uney ebpevunuey ke menge sakup din, ne egketunggad arà se inged din. Ne iring din ded dema ke ruen pehinged etawa telteleanak ne iyan ded ed-uney egkewaha, ne warà ebpengkusan din ke kenà egkevurahey. ");
INSERT INTO mbi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iring din ded be ketà ke midetuan ni Setanas ke unuten te menge vusew. Embiya iyan ded ed-uney ebpevunuey ke sakup din ne kenà meuhet se kedatù din su egketunggad arà se edetuan din. ");
INSERT INTO mbi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Embiya benar ne iyan ku ibpenegseg te vusew ke gehem ni Bilsibul, ne endei ve ebpuun ke gehem dut te edumaruma keniyu te ebpenegseg te vusew? Sikandan be ayan se ebpekekahi te warà mekesuhat ke egkehiyen niyu. ");
INSERT INTO mbi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ugaid ne iyan benar ne riyà ebpuun te Kedesenan ne Ebpetuntul te Menusiyà ini se gehem ku te ebpenegseg te vusew. Sabap kayi ne egketuenan niyu te neuma en ke hewii te Kedatù te Eleteala keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ugaid ne netalew ku en si Setanas ke unuten te menge vusew,” ke si Hisus, “tembù be ebpekesegseg a te menge sakup din. Su warà etew ne ebpekelusud te valey te etew ne mevaher apey ebpenakew te menge kearen din embiya kenà din ed-unaan pà te ebakù arà se etew ne mevaher. Ugaid ne embiya nevakù din en, ne arà pà ne ebpekekuwa sikandin dut te kearen. ");
INSERT INTO mbi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Su ke etew ne kenà ku ruma ne kunterà ku,” ke si Hisus. “Ne ke etew ne kenà ed-amung kediey te eburun kayi te menge etew, ne ebpemburahey. ");
INSERT INTO mbi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tembù be igkahi ku keniyu,” ke si Hisus, “te egkepesahad te Eleteala ke langun ne menge salà te menge etew ne misan engkey ne meraat ne edlelehan dan kandin. Ugaid ke etew ne edlalag te meraatey mekeatag dut te Kedesenan ne Ebpetuntul te Menusiyà, ne kenà en vulug egkepesahad te Eleteala ke salà din. ");
INSERT INTO mbi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ne misan engkey en ne etew ne edlalag te meraatey mekeatag dut te Impeanak te Menusiyà ne egkepesahad te Eleteala te salà din, ugaid ne misan engkey ne etew ne edlalag te meraatey mekeatag dut te Kedesenan ne Ebpetuntul te Menusiyà, ne kenà en vulug egkepesahad te Eleteala ke salà din taman te taman.” ");
INSERT INTO mbi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Upama ke iring te kayu,” ke si Hisus, “embiya meupiya se kegueyhuey rin ne kayu, ne kenà ebahas te meraatey. Ne engketà ded maa ke kayu ne ruen sakit din, ne kenà ebahas te meupiya. Ketà be ne egketuenan ta embiya meupiya ke kayu kayi te bahas din. ");
INSERT INTO mbi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Engketà ded dema te sikiyu. Iring kew te menge uled ne ebpekekaid, ne warà meupiya ne egkekahi niyu geina te memeraatey ini se netahù te hinawa niyu. Su piya engkey se intahù te etew te hinawa rin, ne ini se egemew te bèbà din. ");
INSERT INTO mbi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Su ke etew ne meupiya se ulaula rin, ne meupiya rema se kedlalag din su meupiya se intahù te hinawa rin. Ugaid ke etew ne meraatey se ulaula rin, ne meraatey rema se kedlalag din su iyan din intahù te hinawa rin ne meraatey. ");
INSERT INTO mbi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tentenuri niyu ini su ketà te hewii ne kedtimbang te Eleteala te menusiyà, ne ibpetavak te Eleteala te menge etew ke uman senge tahà ne nelalag dan ne warà rantek din. ");
INSERT INTO mbi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Su ke langun ne menge lalag niyu ne migemew te bèbà niyu, ne ketà kew edtimbanga ke edusaan kew ve etawa kenà.” ");
INSERT INTO mbi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ketà te menge etew ne nevurun ne ruen menge meyterù te penduan wey menge Peresiyu ne migkahi te, “Meyterù, egkiyug key ne ed-inteng te mekegeyip ne ed-ul-ulaan nu tuus te gehem nu.” ");
INSERT INTO mbi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ugaid ne migkahi si Hisus te, “Sikiyu ne menge etew te guntaani en, meraatey nevenar se ed-ul-ulaan niyu su warà kebperetiyaya niyu te Eleteala! Ugaid ne warà en ma tuus ne ibpekita keniyu liyu rà ketà te netemanan ni Jonas ne mibpelambas te Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Su mid-iveleng te dekelà ne serà si Jonas ne taman te tetelu ne hewii ne riyà dà sikandin te hetek te rekelà ne serà. Ne engketà ded dema ke Impeanak te Menusiyà ne riyà sikandin te diralem te tanà lusud te tetelu ne hewii. ");
INSERT INTO mbi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Su ketà te akir din ne hewii te kedtimbang te Eleteala te menusiyà ne ed-itindeg ini se menge etew ne riyà ebpuun te Niniva rengan su ed-isuhat keniyu te kewagib. Su sikandan mulà ne nerineg dan dà ke Lalag te Eleteala ne impesabut ni Jonas kandan ne nekedsendit dan en ne mid-ewaan dan en ke meraat ne mid-ulaula ran. Guntaan ne ruen mepurù pà ki Jonas ne kayi te keniyu, ugaid ne kenà niyu edtelimaan ke penurù din ne kenà kew ebpedsendit te meraat ne ulaula niyu. ");
INSERT INTO mbi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Su ketà te akir din ne hewii te kedtimbang te Eleteala te menusiyà,” ke si Hisus, “ne duen Bai ne riyà ebpuun te inged ne Siba ne ed-itindeg ne ed-isuhat te kewagib dut te sikiyu ne menge etew guntaan. Su mibpengkayi sikandin se riyà ebpuun te divaluy te pehiliran su apey mekerineg dà ki Salomon ke Ratù dengan ne metmetau. Ne ruen en guntaan seveka ne mepurù pà ki Salomon ne ini en te keniyu!” ");
INSERT INTO mbi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ne migkahi pà maa si Hisus te, “Embiya ruen busew ne edsuuk te etew ne ed-awà en, ne riyà ebpevayà te memara ne tanà su ebpemengà te ubpaan din. Ne embiya warà egketuen din, ");
INSERT INTO mbi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ne iyan egketahù te hinawa rin se, ‘Edliveran ku red ke mid-ubpaan ku.’ Nekeuma ini se busew, ne nekita rin te metilak en wey nekeulit en ke langun ketà te lusud. ");
INSERT INTO mbi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ne midlihawang pà sikandin su mid-ewit te pitu ne vusew ne tuwas pà kandin keraat, ne langun dan ne ketà dà mid-ubpà. Ne ini se egketemanan dut te etew ne muna pà se kepasang din dut te neuna. Engketà ded dema se egketemanan dut te menge meraat ne etew te guntaani en.” ");
INSERT INTO mbi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Edlalag pà si Hisus ne nekeuma en ke iney rin wey ke menge ari rin ne meama. Ne riyà dan dà te luwal meketaman ne mibpesuhuan dan dà si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne senge etew ketà se migkahi ki Hisus te, “Ke iney nu wey ke menge ari nu ne riyà te lihewangan su ebpekibalak dan keykew.” ");
INSERT INTO mbi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ne migkahi si Hisus te, “Duen pà ibpekita ku keniyu ne iring te iney ku wey ke menge suled ku.” ");
INSERT INTO mbi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne interù din ke menge edumdumaan din ne ke sikandin te, “Sikandan ini ke iney ku wey ke menge suled ku! ");
INSERT INTO mbi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Su misan engkey se ebperumaruma te kiyug te Eleteala, ne sikandan en imbe ke menge suled ku ne meama, ke menge etevey ku, wey ke iney ku.” ");
INSERT INTO mbi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Arà ne hewii ne mid-awà si Hisus ketà te valey ne mibpendiyà te beyvey te ranew, ne ketà mibpinuu su ebpenurù. ");
INSERT INTO mbi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne geina te medmerakel ne menge etew ne midlingut kandin ne mid-untud sikandin te avang diyà te gebgevasan su ebpenurù. Ne riyà dà te beyvey te ranew ke menge etew ne ebpemineg kandin. ");
INSERT INTO mbi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne merakel se impenurù din kandan ne impepevayà te sempità. “Ruen etew,” ke si Hisus, “ne mibpendiyà te pengengewiran din su edsawed te benì. ");
INSERT INTO mbi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ne ketà te kinesawed din ne ruen benì ne nengeulug diyà te kilid te ralan ne midtuktuk en te menge pepenuk. ");
INSERT INTO mbi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ruen ruma ne insawed din ne riyà nengeulug te kebetuwan ne mevavew se tanà din. Ne geina te mevavew ini se tanà din, ne mehaan dà se kinetuvù din. ");
INSERT INTO mbi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ugaid ne guna su mid-endawan en ne petuluy ne migkuley ke dawun din geina te warà meketuneb ke ralid din, ne neebmas en. ");
INSERT INTO mbi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ke ruma pà ne riyà nengeulug te sepinitan ne guna su midtuvù en ini ne migkubmusan en dut te sepinit. ");
INSERT INTO mbi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ugaid ne ruen ruma pà ne riyà nengeulug te meupiya ne tanà, ne midreteb ne meselinuvù se tuvù din, ne nekevahas te meupiya su ruen mibpengupiya nevenar se bahas din, ne ruen migkakey, ne ke ruma pà ne ruen ded neehani. ");
INSERT INTO mbi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Itaan niyu ke telinga niyu,” ke si Hisus, “kayi te migkahi ku ini.” ");
INSERT INTO mbi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ne mid-uvey ki Hisus ke menge edumdumaan din ne migkahi ran te, “Meambe ke ibpepevayà nu ke lalag nu te sempità ke ebpenurù ka kayi te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Migkahi si Hisus te, “Sikiyu ne edurumaruma kediey, ne ebpesebutan en te Eleteala rut te in-eles dengan mekeatag te Kedatù te Eleteala te menge etew, ugaid ke ruma ne menge etew ne ibpenurù kandan te ibpepevayà te menge sempità. ");
INSERT INTO mbi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Su ke etew ne idtahù din te hinawa ke ibpesabut kandin te Eleteala, ne ed-umanan pà te Eleteala ini se kebpekesabut din su apey mehaked din ke muna pà dut te ebpegingewaan din. Ugaid ke etew ne kenà din idtahù te hinawa ke ibpesabut kandin te Eleteala ne egkeawà arà se reisek ne nesebutan din. ");
INSERT INTO mbi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tembù be ebpenurù a kandan ne ibpepevayà te sempità su apey ran mekesabut. Su edtengteng dan, ugaid ne kenà dan ebpekekita; ne ebpemineg dan, ugaid ne iring be te warà dan mekerineg. ");
INSERT INTO mbi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne netuman en kayi te kandan ke impekahi te Eleteala ki Isayas ne egkahi te, ‘Lelayun dan ebpemineg, ugaid ne kenà dan egkesebutan. Ne lelayun dan edtengteng, ugaid ne kenà dan ebpekekita. ");
INSERT INTO mbi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Su ini se menge etew ne meresen se ulu ran, ne timbang te midsabpeng dan ke telinga ran, wey midlipereng dan ke mata ran. Su embiya kenà, ne ebpekekita ran en, ne ebpekerineg dan en, ne ebpekesabut dan en, ne ke hinawa ran ne edlived en kayi te kediey, ne ibpekepeliyu ku en sikandan dut te salà dan.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ne migkahi pà maa si Hisus te, “Ne sikiyu, dayirai kew nevenar su nesebutan niyu ini se nekita niyu wey ini se nerineg niyu. ");
INSERT INTO mbi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sebenarvenar ne ini se egkehiyen ku keniyu te kenà pira rà se ebpelambas te Lalag te Eleteala wey menge metidtu ne etew te Eleteala rengan ne ed-inteng perem kayi te nengekita niyu te guntaani en, ugaid ne warà dan en mekita. Ne ebpemineg dan perem kayi te nengerineg niyu te guntaani en, ugaid ne warà dan en mekerineg.” ");
INSERT INTO mbi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na pemineg kew” ke si Hisus, “su apey niyu mesebuti ke engkey se meana keniyan te sempità ku mekeatag te etew ne midsawed te benì. ");
INSERT INTO mbi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Su ini se benì ne insawed din ne ini ke lalag mekeatag te Edetuan te Eleteala. Ne ke ralan ne neuluhan te benì ne arà ke menge etew ne nekerineg te Lalag te Eleteala, ugaid ne warà dan mesebuti ne warà meketahù te hinawa ran. Nekeuma si Setanas ke datù te pekaid ne midegdehawan din te ed-ahew ke lalag ne nerineg dan. ");
INSERT INTO mbi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne ke kebetuwan ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala ne ingkehalew ran te ebpemineg ne mibperetiyaya ran. ");
INSERT INTO mbi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ugaid ne mehaan dà su warà mekedalid diyà te hinawa ran. Ne wey ran penggerami ni Setanas dut te peretiyaya ran te Lalag te Eleteala, ne midlekà dan en. ");
INSERT INTO mbi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne ke sepinitan ne neuluhan te benì, ne arà ke menge etew ne nekerineg te lalag te Eleteala, ugaid ne gewii ran te ebpetindalan ne merakel se egkubmus dut te Lalag ne nerineg dan, iring te kemutuwan dan te ked-ubpà-ubpà wey ke kegkelilingey ran dut te kearen dan, ne warà en mekeuma te kebehas dan. ");
INSERT INTO mbi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne ke meupiya ne tanà ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala ne impetuneb dan te hinawa ran su nesebutan dan. Ne mibahas dan su ruen mibpengupiya nevenar se bahas din, ne ruen migkakey, ne ke ruma pà ne ruen ded neehani.” ");
INSERT INTO mbi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ne mibpenurù si Hisus te seveka maa ne sempità, ke sikandin te, “Ke Kedatù te Eleteala rut te menge etew ne iring te etew ne mibpesawed te meupiya ne benì diyà te pengengewiran din. ");
INSERT INTO mbi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Senge kerukileman ketà te nekelipereng dan langun, ne nekeuma ini se kunterà din ne midsawed te utan ketà te pengengewiran din ne mid-awà en. ");
INSERT INTO mbi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Guna su midtuvù ke pinemula ne ebmemehingey en, ne midtuvù en dema ke utan. ");
INSERT INTO mbi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ne mid-uvey ke edsugsuhuen kayi te kemuney ne migkahi en te, ‘Mama, meupiya ne benì ke impesawed nu riyà te pengengewiran nu, ne endei ve ebpuun arà se menge utan ne midtuvù ketà?’ ");
INSERT INTO mbi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“ ‘Riyà ebpuun ini te kunterà ku,’ ke se kemuney kayi te tanà. “Ke se menge edsugsuhuen din te, ‘Menu, Mama, ibpevarut nu kenami ayan se utan?’ ");
INSERT INTO mbi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Kenà,’ ke se kemuney, ‘su gewii te kebarut niyu te utan ne kema ke ebpekeragkes ke meupiya ne pinemula. ");
INSERT INTO mbi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ebeleharen tew pà taman te egkeuma en ke ked-ehani, ne ebpeunaan ku pà te ebpepemarut rut te ebpengehani ne ibpepemagkes ku kandan su ebinsulan. Ne anpà ne ibpeehani ku ini se pinemula ku ne ibpetahù ku kayi te kemalig ku.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne mibpenurù maa si Hisus te ruma pà ne sempità. “Ini se Kedatù te Eleteala kayi te menge etew,” ke sikandin, “ne ebpekeiring te merimet nevenar ne lahas ne ed-ingeranan te Mustasa ne ibpemula te etew. ");
INSERT INTO mbi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ini ke pinekemerimet ne lahas kayi te ampew te dunya, ugaid ne embiya ibpemula ini ne ebpeketuvù ne egkevaluy ne iyan dekelà dut te langun ne pinemula. Ne edsubpang te derekelà, ne rutun ebpenesalag ke menge pepenuk.” ");
INSERT INTO mbi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne mibpenurù pà lavew si Hisus te ruma pà ne sempità. Ke sikandin te, “Ini se Kedatù te Eleteala kayi te menge etew ne iring te ibpelevag te pan. Migkuwa ini te meritan ne insawug din dut te senge asad ne tapung su apey ebpeketuvù ke mibawug din ne tapung.” ");
INSERT INTO mbi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Langun ini ne impesabut ni Hisus diyà te denda ne menge etew ne impepevayà din te sempità. Warà misan engkey en ne impemenudtul din kandan ke kenà impenempità din. ");
INSERT INTO mbi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mid-ulaula rin ini su apey metuman ke impesurat ne Lalag te Eleteala dut te ebpelambas te lalag din rengan ne egkahi te, “Ebpenurù a kandan te kayi ibpepevayà te menge sempità; ibpenudtul ku kandan arà se warà pà mepayahi igenat dut te kinelimbaha kayi te kelibutan.” ");
INSERT INTO mbi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ketà ne mid-ewaan ni Hisus ke denda ne menge etew ne mibpemenayik sikandin diyà te baley. Midtundug kandin ini se menge edumdumaan din ne ke sikandan te, “Ibpayag nu kenami ke engkey se meana dut te sempità nu mekeatag te utan ne insawed diyà te pengengewiran.” ");
INSERT INTO mbi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Migkahi si Hisus te, “Ke meama ne midsawed te meupiya ne benì ne sikandin ke Impeanak dut te Menusiyà; ");
INSERT INTO mbi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ne ke pengengewiran ne ini se kelibutan. Ne ke meupiya ne benì ne arà ke menge etew ne Edetuan dut te Eleteala. Ke utan ne arà ke menge etew ne sakup ni Setanas ke egkeunutan te menge vusew, ");
INSERT INTO mbi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ini se kunterà dut te kemuney te pengengewiran su midsawed te utan, ne sikandin ke egkeunutan te menge vusew. Ke hewii te ked-ehani ne arà ke ketepusan kayi te kelibutan, ne ke ebpengehani ne sikandan ke menge suluhuen te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ne arà se utan ne ebpemeruten ne ebinsulan dan, ne arà ke egketemanan dut te sakup te egkeunutan te busew kayi te ketepusan te kelibutan. ");
INSERT INTO mbi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Su kayi te ketepusan te kelibutan ne edsuhuen dut te Impeanak te Menusiyà ke menge suluhuen din su ibpeawà ketà te Edetuan din ke langun ne mibpeneheewit te kebpekedsalà te ruma ran wey langun ne mid-ulaula te meraat ");
INSERT INTO mbi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ne ibpeantug diyà te apuy nerakà. Ne ketà dan ebpekependerawit wey ebpekengingitel. ");
INSERT INTO mbi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ugaid ne ke menge metidtu ne etew su sakup te Eleteala, ne ed-anlag dan iring te andew diyà te Edetuan te Amey ran ne Eleteala. Ne itaan niyu ke telinga niyu kayi te nerineg niyu.” ");
INSERT INTO mbi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Migkahi pà maa si Hisus te, “Ini se Kedatù te Eleteala ne iring te kearen ne in-eles diyà te pengengewiran. Netuen ini te senge etew ne nesuatsuat nevenar sikandin, ne midtelevan din ne mid-ulì en. Ne mibpasa rin ke langun taman ne kearen din, ne midlived sikandin ne mibpemasa rin arà se pengengewiran.” ");
INSERT INTO mbi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ini se Kedatù te Eleteala,” ke si Hisus, “ne ebpekeiring dema te etew ne ebpemengà te menge pirlas ne ebpemesaan din. ");
INSERT INTO mbi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Guna su neketuen sikandin te seveka ne pirlas ne mepmepurù nevenar, ne arà dà ne mibpasa rin ke langun taman ne kearen din ne mibpemasa rin arà se pirlas.” ");
INSERT INTO mbi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ne seveka rema ne ebpekeiring te Kedatù te Eleteala,” ke si Hisus, “ne ini se biyala ne id-antug diyà te ranew su apey ebpekeutel te langun ne edsusunan te serà. ");
INSERT INTO mbi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Guna su nepenuen ini se biyala, ne midtuyuk dan en diyà te geunan. Ne mibpinuu ran su ebpengeraman dan ke serà. Su ke meupiya ne serà ne id-awuk diyà te ambung su ibpendehang dan, ne ke kenà meupiya ne idtimbag dan. ");
INSERT INTO mbi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iring be ketà dema se egketemanan kayi te menge etew ketà te kegkepupus te ini se kelibutan su ebpemenkayi ke menge suluhuen te Eleteala ne ibpedsivey ran ke menge etew ne meraat se mid-ulaula rin dut te menge etew ne metidtu. ");
INSERT INTO mbi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne ini se menge meraat ne etew ne ibpeantug diyà te apuy nerakà, ne ketà dan ebpekependerawit wey ebpekengingitel.” ");
INSERT INTO mbi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ne mid-insaan ni Hisus ke edumdumaan din te, “Menu, egkesebutan niyu ini se langun ne mibpengahi ku?” “Uya,” ke se menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ketà ne migkahi maa si Hisus te, “Ne geina te nesebutan niyu en arà, ne misan engkey ne etew ne ebpenurù te penduan ne miduma kayi te Kedatù te Eleteala ne iring sikandin dut te senge etew ne kemuney te valey ne merakel se kearen din megidsan se raan wey behu. Iring sikandin ketà su metau ne ebpenurù te raan ne penurù wey igkepenurù din dema ke behu.” ");
INSERT INTO mbi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Guna su nekepasad en si Hisus te kebpenurù din te ibpepevayà te menge sempità, ne mid-awà en sikandin ketà te inged ");
INSERT INTO mbi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ne mid-ulì en diyà te inged din ne mibpenurù diyà te baley ne ebpengedian te menge Hudiyanen te penduan dan. Ne nengegeyip ke menge etew ne nekerineg te penurù din. Ke sikandan te, “Endei rin be buwa mekuwa ini se ketau rin? Ne ebmenuwen din te ebaal ini se menge mekegeyip? ");
INSERT INTO mbi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Maa, kenà uvag sikandin ke anak te pandey? Ne maa, kenà si Maria ke iney rin wey si Santiago, si Jose, si Simon wey si Hudas ke menge ari rin? ");
INSERT INTO mbi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne maa,” ke sikandan, “kenà ini red dema med-ubpà ke langun ne etevey rin? Endei rin be buwa mehuruwi ini se ketau rin?” ");
INSERT INTO mbi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ketà ne mid-engkenà dan kandin. Ne migkehiyan ni Hisus sikandan te, “Ke etew ne ebpelambas te Lalag te Eleteala ne egkeedatan te piya endei sikandin egketahù, liyu rà dut te muney ne inged din wey ke kereremigey rin.” ");
INSERT INTO mbi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tembù be kenà utew merakel ne mekegeyip ne ingkepekita ni Hisus ketà te inged din su warà mibperetiyaya ke menge etew kandin. ");
INSERT INTO mbi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nerineg ne Hirudis ini se tudtul mekeatag te mid-ulaula ni Hisus su arà ne hewii ne sikandin ke egkeunutan ketà te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Migkahi sikandin kayi te menge kedserihan din te, “Neuyag ded maa si Juan ke Ebpembunyag, tembù be ruen gehem din te kebpekevaal te menge mekegeyip.” ");
INSERT INTO mbi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ini se nekahi ni Hirudis su sikandin en iya ke mibpeimatey ki Juan su sikandin pà ke mibpesigkem, ne mibpevakù ne mibpevilanggù. Iyan din kineul-ulaa kayi su mid-esawa rin si Hirudiyas ke ipag din misan si Hirudiyas ne esawa rut te tuney ne suled din ne si Felipe. ");
INSERT INTO mbi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Su uman dà ebpengegkehiyi ni Juan si Hirudis te, “Kenà meupiya ne ed-esawaan nu ke ipag nu su esawa en te tuney ne suled nu!” ke si Juan. ");
INSERT INTO mbi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ne ebpeimetayan perem ni Hirudis sikandin, ugaid ne neandek sikandin te menge Hudiyanen su migkahi ran te ebpelambas te Lalag te Eleteala si Juan. ");
INSERT INTO mbi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ugaid ne guna su neuma ke hewii te kineanaka ki Hirudis ne ruen kevurunan, ne ketà ne pinesayew ke anak ni Hirudiyas ne raha. Ne ingkesuatsuat ni Hirudis ini, ");
INSERT INTO mbi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tembù be mibpesaran din ke midsayew te, “Langun tew te nevurun kayi ne titihus te misan engkey se ebuyuen nu ne ibehey ku keykew!” ");
INSERT INTO mbi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ne intelaan en neraan te iney kayi te raha ne midsayew te ibpevuyù diyà te ki Hirudis ke ulu ni Juan ke Ebpemunyag. Tembù be migkahi sikandin te, “Iyan ku ebuyuen te guntaani ne ivehey nu kediey ke ulu ni Juan ke Ebpemunyag!” ");
INSERT INTO mbi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nerineg dà ni Hirudis ne nekebmutu sikandin, ugaid ne tehaad te ingkepasad din en diyà te etuvangan te pinetelavuk din, ne impetuman din en ke mibuyù dut te raha. ");
INSERT INTO mbi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ketà be ne mibpepungelan din en si Juan diyà te bilengguan. ");
INSERT INTO mbi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ne impetahù din en te pelatu ke ulu ni Juan ne mibpeneheneewit en ini ne imbehey en diyà te raha, ne imbehey en dema dut te raha diyà te iney rin. ");
INSERT INTO mbi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Guna su nerineg ini dut te menge edumdumaan ni Juan, ne mibayaan dan diyà te bilengguan ke bangkey rin ne inleveng dan. Neipus dan ne mibpendiyà dan te ki Hisus su impenudtul dan ini se netamanan. ");
INSERT INTO mbi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Guna su nerineg eni Hisus ke tudtul dut te netemanan ni Juan, ne mid-awà dan ketà ne mid-untud dan te avang te sikandan dà se ebpendiyà te warà etew rin. Guna su netuenan dut te menge etew te mid-avang-avang en ensi Hisus ne mibpenggenat dan en se ebpemeyvey ran su edtelukun kandin. ");
INSERT INTO mbi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Guna su nekerunggù en ensi Hisus ne iyan dan nekita se merakel ne menge etew ne nevurun, ne neyruwan din nevenar sikandan ne neulian din ke ebpenderaru. ");
INSERT INTO mbi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Guna su meapun en nevenar ne mid-uvey en kandin ke menge edumdumaan din se egkahi te, “Meapun en ini ne warà dè be menge etew kayi te inged ini. Iyan tumù ne ibpeipanew nu en ke menge etew su apey ran ebpekependiyà te endei se ruen menge valey ne ebpekepemasa ran te egkekaan dan.” ");
INSERT INTO mbi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ne migkehiyan dan ni Hisus te, “Kenà dan en ebpeipanewen,” ke sikandin, “su sikiyu se ebpekaan kandan.” ");
INSERT INTO mbi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ini se kuwa tew,” ke sikandan, “ne lelima rà ne timan ne pan wey deruwa ne timan ne serà.” ");
INSERT INTO mbi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne migkahi si Hisus te, “Ewita niyu kayi.” ");
INSERT INTO mbi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ketà ne pinepinuu rin diyà te gumegebà ke menge etew. Ne migkuwa rin ke lelima ne timan ne pan wey ke deruwa ne timan ne serà, ne midlingakà sikandin diyà te langit ne impeselamat din te Eleteala. Ne mibpenevìtevì din en ke pan ne imbehey rin en dut te menge edumdumaan din su ibpetukid diyà te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Migkaan dan langun ne nengevulung dan. Guna su nekeipus dan en se egkaan, ne mibpunpun dut te sepulù wey deruwa ne edumdumaan din ke nesamà ne iyan din nepunpunan ne sepulù wey deruwa ne binevey ne nengepenù. ");
INSERT INTO mbi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne ke menge etew ne migkaan ketà ne menge lelima nengivu ke meama, liyu pà ke menge meritan batà. ");
INSERT INTO mbi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ne pineuntud en ni Hisus te avang ke menge edumdumaan din su ibpeuna rin en sikandan te ed-apet te ranew su ibpepeulì din pà ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Guna su impeipanew rin en ke menge etew, ne midtekereg en sikandin te sebseveka rin diyà te buvungan su ebpengeningeni. Guna su egkesagkup en ne ketà pà si Hisus te sikandin dà. ");
INSERT INTO mbi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ugaid ke menge edumdumaan din ne meriyù en se ebpengavang-avang ne diyan en te kalud te ranew ne nesuhat te mevaher ne baleg su egkesurang dan ke mevandes ne keramag. ");
INSERT INTO mbi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Egkepkepawà ketà ne midtelukun en si Hisus kandan se ed-ip-ipanew riyà te divavew te wayig. ");
INSERT INTO mbi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Guna su nekita sikandin dut te menge edumdumaan din se ed-ip-ipanew riyà te divavew te wayig, ne nengeandek dan nevenar. “Gimukud!” ke sikandan, ne migkuleyì dan te kegkeandek dan. ");
INSERT INTO mbi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ketà ne migkahi si Hisus kandan te, “Pedtihel kew te hinawa niyu su siaken ini! Kenà kew meandek!” ");
INSERT INTO mbi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ne migkahi en si Pedro te, “Kerenan, embiya benar ne sikuna ayan, ne peipenawa a kayi te divavew te wayig te ebpeengkeniyan te kenikew.” ");
INSERT INTO mbi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Pengkayi ke en!” ke si Hisus. Ne ketà ne midrenà si Pedro dut te avang ne mid-ipanew en diyà te divavew te wayig se ebpendiyà te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ne guna su neheram din ke mevandes ne keramag ne netekew sikandin meandek ne idteledted en sikandin. “Kerenan, tevangi a!” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Arà dà ne migeweran ni Hisus sikandin ne migkahi en te, “Kurang bes ke kebperetiyaya nu kediey! Meambe ke ruen keduwaruwa nu?” ");
INSERT INTO mbi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ne mid-untud dan ketà te avang ne mid-engked en ke keramag. ");
INSERT INTO mbi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Guna su diyan dan en te avang, ne mibpengarap ini se menge edumdumaan din kandin. “Benar iya ne Anak ka te Eleteala!” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Guna su mid-apet dan en te ranew ne iyan dan nerungguan ne inged ne Hinisarit, ");
INSERT INTO mbi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ne petuluy ne nekilala dut te menge etew si Hisus. Tembù be pinesugkew ran ke menge etew ne ebpenderaru ketà te nekeerivey ne inged, ne mibpeneheewit dan kayi te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne ini se mibpeneheewit te ebpenderaru ne mibuyù ki Hisus te menu ma ke mekeamì ke ebpenderaru misan dut te belegkas din dà, ne langun ne nekeamì ketà ne neulian. ");
INSERT INTO mbi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Senge hewii ne ruen menge Peresiyu wey menge meyterù te penduan ne riyà ebpuun te Hirusalim ne mibpengkayi te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ne migkahi ran te, “Meambe ke kenà edtuman ini se menge edumdumaan nu rut te impenurù ne betasan ne intelau dut te keep-epuan tew? Su matag dan en migkaan ne warà dan tumana ke edtenuran te kedlùlù!” ");
INSERT INTO mbi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“Ne sikiyu,” ke si Hisus, “meambe ke iyan niyu edtumanen ke betasan ne intelau keniyu rut te menge keep-epuan niyu, ne midsurang kew ma rut te penurù te Eleteala? ");
INSERT INTO mbi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Su migkahi te Eleteala te, ‘Edati niyu ke amey niyu wey ke iney niyu.’ Ne ingkahi rema te, ‘Misan engkey ne etew ne edlalag te meraatey dut te amey rin etawa iney rin ne ibpeimetayan.’ ");
INSERT INTO mbi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ugaid ne sikiyu,” ke si Hisus, “ne iyan niyu ibpenurù ne embiya ruen etew ne ruen igketavang din dut te amey rin etawa iney rin ne egkepakey ne egkehiyen din te ‘Imbehey ini te Eleteala’ ");
INSERT INTO mbi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ne ketà ne kenè en sikandin ebpeketavang dut te amey rin wey iney rin. Kayi ve te penurù niyu ini ne mid-iniyuhan niyu ke Lalag te Eleteala su iyan niyu ibpeiseg ke betasan ne intelau dut te keep-epuan niyu. ");
INSERT INTO mbi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikiyu ne uvag en kun ne ebperetiyaya! Benar iya ke lalag mekeatag keniyu ne impesurat te Eleteala ki Isayas ne mibpelambas te Lalag te Eleteala rengan su migkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ini se menge etew, ne kayi rà te bivig dan se ked-arap dan kediey, ugaid ne ke hinawa ran ne medmeriyù kediey. ");
INSERT INTO mbi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Warà ded be lalew rin se kebpengarap dan kediey, su ke ibpenurù dan ne mibèbeelan dà te etew, ugaid ne egkehiyen dan ne kayi ebpuun te penduan ku.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ne pineuvey en ni Hisus ke menge etew se egkahi te, “Pemineha niyu ve ini,” ke sikandin, “se edlelehan ku su apey niyu egkesebuti. ");
INSERT INTO mbi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kenà iyan ebpekeredsik te etew ini se egkeenen ne ebpekeawuk te bèbà din, ugaid ne iyan ebpekeredsik te etew ini se netahù te hinawa rin ne ebpekelihawang kayi te bèbà din.” ");
INSERT INTO mbi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ne mid-uvey kandin ke menge edumdumaan din ne migkahi te, “Maa, netuenan nu red te neepesan ka te menge Peresiyu dut te migkahi nu geina?” ");
INSERT INTO mbi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ne migkahi si Hisus te impepevayà te sempità te, “Langun ne pinemula ne warà ipemula te Amey ku ne riyà te langit ne eberuten. ");
INSERT INTO mbi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Belehara niyu sikandan! Su iring dan te menge pisek ne edtuyuk te pisek ded dema. Ne embiya ruen pisek ne edtuyuk te pisek ded dema, ne elin dan egkeulug diyà te lepak.” ");
INSERT INTO mbi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ne migkahi si Pedro te, “Ipayag nu kenami ke meana rut te sempità nu geina.” ");
INSERT INTO mbi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ne migkahi si Hisus kandan te, “Iring kew rà dut te ruma ne etew ne mevavew se kebpekesabut dan. ");
INSERT INTO mbi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Meambe, warà niyu ves mesebuti te ini se egkeenen ne ebpekeawuk te bèbà te etew ne ebpevayà te hetek din ne an pà ne edlihawang diyà te kandin? ");
INSERT INTO mbi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ugaid iyan ebpekeredsik te etew ne ini se netahù te hinawa rin ne ebpekelihawang te bèbà din. ");
INSERT INTO mbi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Su ini se neketahù te hinawa rin ke ebpuunan te meraat ne itungan ne ebpekepeneheewit kandin te meraat ne ed-ul-ulaan iring te ked-imatey, kedlangkadlangkad te esawa rin, ne ruma pà ne meredsik ne ed-ul-ulaan, kebpenakew, kedtarùtarù wey kedlalag te ebpekereraat te pekinegan te ruma ne etew. ");
INSERT INTO mbi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Langun din ini ne ebpekeredsik te etew, ugaid ne kenà ebpekeredsik te etew ke egkaan sikandin te warà mekepenlùlù ne ayan ke betasan te menge Peresiyu.” ");
INSERT INTO mbi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ne mid-awà si Hisus ketà ne mibpendiyà te inged ne uvey te menge inged ne Tiru wey Sidun. ");
INSERT INTO mbi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne ruen nekeubpà ketà ne meritan ne riyà ebpuun te inged ne Kenaan ne midtelavuk ki Hisus. “Kerenan, sikuna ne inenakan ni David,” ke sikandin, “igkeyru a nikuna! Su ruen anak ku ne meritan ne midsuukan te busew ne egkepesangan nevenar.” ");
INSERT INTO mbi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ugaid ne warà kegkehiyan ni Hisus. Ne ketà ne mid-uvey ki Hisus ke menge edumdumaan din ne mibpemuyù te, “Ipeulì nu ayan se meritan su edtundugtundug kenitew ne ebpekeuringer.” ");
INSERT INTO mbi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne migkahi si Hisus te, “Midsuhù a te Eleteala te iyan dà ebpetevangan ke menge kevuwaran ni Israyil ne iring te menge bilibili ne nengelaag.” ");
INSERT INTO mbi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Guna su nerineg ini kayi te meritan ne mid-uvey rin en si Hisus ne midlumpeng en diyà te sineruwan din se ebpemuyù te, “Kerenan, tevangi a nikuna!” ");
INSERT INTO mbi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ne mibpenempità si Hisus kandin te, “Kenà edait ne egkuan ta ke ibpekaan te menge vatà ne idsavud te menge asu.” ");
INSERT INTO mbi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Benar ayan, Kerenan,” ke se meritan, “ugaid ne misan ke menge asu ne ebpenelisim dut te mumu te menge vatà ne ebpengeulug diyà te lemisaan dut te ebpengemuney.” ");
INSERT INTO mbi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ne migkehiyan ni Hisus ke meritan te, “E, Bayi, mevaher nevenar se kedsarig nu te Eleteala! Ini se mibpemuyù nu ne ibehey ku keykew.” Arà dà ne neulian en ke anak dut te meritan. ");
INSERT INTO mbi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mid-awà si Hisus ketà ne mibpemeyvey te Ranew te Geliliya. Ne midtekereg diyà te buvungan ne mibpinuu. ");
INSERT INTO mbi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne denda ne menge etew se mibpengkayi te kandin se ebpeneheewit te menge pungkù, menge pisek, menge nekeyengkeng, menge emew, wey ruma pà ne ebpenderaru. Ne riyà dan indenà te etuvangan ni Hisus, ne neulian din ke langun dan. ");
INSERT INTO mbi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne nengegeyip ke menge etew ketà te nekita ran te nekelalag en ke menge emew, neketidtu en ke nekeyengkeng, nekeipanew en ke menge pungkù wey nekekita en ke menge pisek. Ne ketà nekereyù dan te Eleteala ne iyan ebpengerapan dut te bansa ne Israyil. ");
INSERT INTO mbi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ne pineuvey ni Hisus ke menge edumdumaan din ne migkahi te, “Igkeyruwi ku nevenar ini se menge etew,” ke si Hisus, “su nekedtetelu en ne hewii se kinepekiduma ran keytew ne warà en egkekaan dan. Kenà meupiya ne ebpeulien te kenà dan ebpekekaan su kalu ke ruen edlunusan diyà te ralan.” ");
INSERT INTO mbi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Migkahi ke menge edumdumaan ni Hisus te, “Endei ki mulà ebpekekuwa te egkekaan ne ibpekaan tew kayi te merakel ne menge etew se ini kiyu te inged ne warà bulug etew rin?” ");
INSERT INTO mbi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Engkey ma taman ne kerakel te lutù tew?” ke si Hisus. “Pitu rè be ne timan ini se lutù tew ne pan,” ke sikandan, “ne ruen pipira ne timan ne serà.” ");
INSERT INTO mbi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne pinepinuu ni Hisus ke menge etew diyà te tanà. ");
INSERT INTO mbi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne migkuwa rin ke pitu ne timan ne pan wey menge serà ne impeselamat din en diyà te Eleteala. Ne mibpenevìtevì din en ke pan, ne imbehey rin en dut te menge edumdumaan din su ibpetukid diyà te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Langun dan ne migkaan, ne nengevulung. Ne ketà ne mibpunpun dut te edumdumaan din ke nengesamà ne iyan din nepunpunan se pitu ne binevey. ");
INSERT INTO mbi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ne epat nengivu ke menge etew ne migkaan ketà liyu ke meritan batà. ");
INSERT INTO mbi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Arà pà ne impeulì ni Hisus ke menge etew. Ne mid-untud en ensi Hisus te avang ne mid-avang-avang dan en se ebpendiyà te inged ne Magadan. ");
INSERT INTO mbi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ne ruen menge Peresiyu wey menge Sadusiyu ne mibpendiyà te ki Hisus se ebpekidlewanà kandin su ebeelan dan te litag si Hisus. Tembù be mibuyù dan te mebaal si Hisus te mekegeyip ne tuus te midsuhù sikandin te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Migkahi si Hisus te, “Embiya edsanlep ke andew ke ebpemurawag ne egkahi kew te, ‘Ebpengupiya ke hewii.’ ");
INSERT INTO mbi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne embiya egkepkepawà ke ruen pemurawag wey kivel ne egkahi kew te, ‘Ed-uran.’ Embiya edtengteng kew diyà te langit ne metau kew nevenar ne ebpenipat te hewii, ugaid ne kenà niyu egkekilala ke menge tuus mekeatag kediey guntaan. ");
INSERT INTO mbi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sikiyu ne menge etew te guntaani en, ne meraatey nevenar se ed-ul-ulaan niyu su warà kebperetiyaya niyu te Eleteala! Menu, ebuyù kew te ebaal a te mekegeyip ne tuus te gehem ku? Kenà, su warà en tuus ne ibpekita keniyu liyu rà ketà te netemanan ni Jonas ne mibpelambas te Lalag te Eleteala rengan.” Ketà ne mid-ewaan din sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mid-apet ke menge edumdumaan ni Hisus te ranew, ugaid ne nelipat dan ne ed-ewit te lutù dan ne pan. ");
INSERT INTO mbi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne mibpenempità si Hisus kandan te, “Andam kew,” ke sikandin, “ne ingati niyu te kenà kew egkepeneheewit te ibpelevag te pan dut te menge Peresiyu wey Sadusiyu.” ");
INSERT INTO mbi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ugaid ne geina te warà dan mesebuti ne mibpelelelahey ran te, “Iyan din kinepekekahi kayi ne geina te warà kiyu mekeewit te lutù tew ne pan.” ");
INSERT INTO mbi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ne netuenan ni Hisus ke engkey se ibpelelelahey ran ne migkehiyan din en sikandan te, “Meambe ke iyan niyu egkepengasak se warà niyu kebpekeewit te pan? Kurang nevenar ke kedsarig niyu kediey? ");
INSERT INTO mbi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Maa, warà kew pè bes mekesabut? Maa, kenà niyu en egketenuran ke kinepenevìtevì ku rut te lelima ne timan ne pan ne impekaan ku rut te lelima nengivu ne menge etew? Maa, pira ne binevey se nepenù te nengesamà ne nepunpun niyu? ");
INSERT INTO mbi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne menu, kenà niyu en egketenuran ke kinepenevìtevì ku rut te pitu ne timan ne pan ne impekaan ku rut te epat nengivu ne menge etew? Maa, pira ne binevey se nepenù te nengesamà ne nepunpun niyu? ");
INSERT INTO mbi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Meambe ke warà niyu mesebuti te kenà ini se pan ne warà niyu meewit se egkehiyen ku? Su ingati niyu te kenà kew egkepeneheewit te ibpelevag te pan dut te menge Peresiyu wey Sadusiyu.” ");
INSERT INTO mbi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Arà pà ne nekesabut ke menge edumdumaan din te iyan din ebpeingatan kandan ne kenà arà se ibpelevag te pan, ugaid ne arà se ibpenurù te menge Peresiyu wey Sadusiyu. ");
INSERT INTO mbi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ketà ne mibpendiyà en ensi Hisus te inged uvey te inged ne Sisariya Pilipus. Guna su nekeuma ran en ne mid-insaan ni Hisus ke menge edumdumaan din te, “Engkey kun ke Impeanak te Menusiyà riyà te pegitungan te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Ruen egkahi te sikuna si Juan ke Ebpembunyag,” ke sikandan. “Ne ruen duma ne egkahi te sikuna si Elias ke mibpelambas te Lalag te Eleteala rengan. Ne ruen pà ruma ne egkahi te sikuna si Jeremias etawa seveka ne mibpelambas te Lalag te Eleteala rengan.” ");
INSERT INTO mbi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ne menu sikiyu,” ke si Hisus, “engkey e ma diyà te pegitungan niyu?” ");
INSERT INTO mbi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ne midtavak si Pedro te, “Sikuna ke Impasad ne Ebperetuen te langun ne menge etew dut te Eleteala ne warà kemetayan din, ne sikuna ke Anak din.” ");
INSERT INTO mbi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Mibpenaub ka, Simon ne anak ni Juan!” ke si Hisus. “Su benar ini se migkahi nu, ugaid ne kenà etew se mibpayag kayi te kenikew su ke Amey ku riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tembù be ebpeketuenan ku kenikew te ed-ingeranan ku sikew ki Pedro (ne iyan din meana ne ‘batu’). Iring ka te batu ne ebpeunsaran ku te simbaan ku su ini ke langun ne menge etew ne mibperetiyaya kediey. Ne misan ke gehem dut te kemetayen ne kenà ebpeketunggad kandan. ");
INSERT INTO mbi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ibehey ku kenikew ke ketau te kebpemenudtul diyà te langun ne menusiyà dut te Meupiya ne Tudtul mekeatag dut te Kedatù te Eletela ne embiya idsempità ta ini ne iring te ibehey ku kenikew ke gunsì te gumawan ne ebpependiyà te lusud te Edetuan te Eleteala. Ne ini se idawey nu kayi te kelibutan ne arà se indawey en dema te Eleteala riyà te langit. Engketà ded dema ke idtuhut niyu kayi te kelibutan ne arà ke intuhut en dema te Eleteala riyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne mid-il-ilutan ni Hisus te egkahi kandan te kenà dan ibpenudtul te misan engkey ne etew te sikandin ke Impasad te Eleteala ne Ebperetuen te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Igenat dè be ketà ne mibpehayan en ni Hisus ke menge edumdumaan din mekeatag te egketemanan din. Ke sikandin te, “Iyan iya se ebpekependiyan a te inged ne Hirusalim ne edresayen a nevenar su ebpeheweran a te menge pekilukesen te Hudiyanen, menge mepurù te terebpelengesa, wey ke menge meyterù te penduan. Ed-imetayan a, ugaid ne ketà te iketelu ne hewii ne egkevanew e red.” ");
INSERT INTO mbi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nerineg ni Pedro ne impesivey rin si Hisus ne pineengked din se egkahi te, “E Kerenan, berekat ne ibpemekeriyù dà ini te Eleteala! Kenà ayan med-ulaula kenikew!” ");
INSERT INTO mbi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ugaid ne midlingì si Hisus ne migkehiyan din si Pedro te, “Awà ka su iring ka ki Setanas! Maa, ebengenen a nu kayi te ibpetuman kediey? Su ke itungan nu ne kenà diyà ebpuun te Eleteala, ugaid ne kayi rà te itungan te menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ne migkahi si Hisus dut te menge edumdumaan din te, “Embiya ruen etew ne egkiyug ne eduma kediey, ne iyan iya se pekelipati rin ke kandin ne kiyug wey tianga rin ke kandin ne pinebelavag ne kayu ne ed-ingaranan te krus ne iyan din meana ne tumana rin ke menge suhù ku misan ibpatey rin pà se keduma rin kediey. ");
INSERT INTO mbi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Su ke etew ne egkenuhun te umur din ne ebpatey lavew, ugaid ke etew ne iyan din ibpatey se keduma rin kediey ne ruen umur ne ibehey kandin ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Menu, embiya ruen etew ne ebpekehaked te langun taman kayi te ampew te dunya, maa engkey se rantek din embiya egkerasey ke himukud din diyà te apuy nerakà? Warà! Su warà misan engkey ne kearen ne igkevehey te etew apey rin meawì ke gimukud din. ");
INSERT INTO mbi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Su sikandin ke Impeanak te Menusiyà ne mehaan ne edlived kayi te ampew te dunya ne edumaan te menge suluhuen din wey ruen raman din ne iring te raman te Amey rin ne Eleteala. Ne ketà ne eberasan din ke menge etew dut te mid-ulaula ran kayi te ampew te dunya ke meupiya etawa meraat. ");
INSERT INTO mbi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tentenuri nu ini,” ke si Hisus, “ruen ruma niyu kayi ne kenà pà ebpatey taman ketà te hewii ne egkekita ran ke Impeanak te Menusiyà ne ebpekeuma su Edatù te menusiyà kayi te ampew te dunya.” ");
INSERT INTO mbi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Guna su neked-enem en new hewii, ne pineruma ni Hisus ensi Pedro wey ke teleari ne si Santiago wey si Juan ne midtekereg dan diyà te mehantur ne buvungan te sikandan dà. ");
INSERT INTO mbi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Guna su ketà dan en ne midtengtengan dan si Hisus ne netekew nedsalin ke kebpeparas din su mid-anlag ini se buked din iring te andew. Ne mibpeneringsing ke velegkas din te keputì. ");
INSERT INTO mbi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Netekew ran dema nekita se deruwa ne etew se ebpekidlalag ki Hisus, si Moises wey si Elias, ke menge mibpelambas te Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ne migkahi en si Pedro ki Hisus te, “Kerenan, meupiya su kayi ki! Embiya egkiyug ka ne edsesabung a kayi te tetelu, seveka te keykew, seveka te ki Moises, wey seveka rema te ki Elias.” ");
INSERT INTO mbi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Edlalag pà si Pedro, ne ruen mermerayag ne sehulapun ne nekelikuvung kandan ne ruen suwara ne ketà ebpuun te sehulapun ne migkahi te, “Ini ke Anak ku ne igkelimù ku nevenar, ne ebpekesuhat nevenar sikandin te hinawa ku. Pemineha niyu ke edlelahen din!” ");
INSERT INTO mbi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Guna su nerineg kayi te menge edumdumaan ni Hisus ke suwara ne nekelumpeng dan su neandek dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ne mid-uvey ran ni Hisus ne migeweran din se egkahi te, “Enew kew, ne kenà kew meandek!” ");
INSERT INTO mbi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Guna su midlingakà dan ne warà duma ne nekita ran su si Hisus dà. ");
INSERT INTO mbi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Gewii ran te edtupang ne mibenduan dan ni Hisus te, “Ini se nekita niyu ne kenà niyu imbe ibpenudtul te misan entei taman te egkevanew en ke Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ne ketà ne mid-insà kandin ke menge edumdumaan din te, “Meambe ke egkehiyen te menge meyterù te penduan te iyan ed-una ebpengkayi ne si Elias ke etew ne mibpelambas te Lalag te Eleteala rengan, ne arà pà ke Impasad te Eleteala ne Edatù?” ");
INSERT INTO mbi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Benar ne ed-una ebpengkayi si Elias,” ke si Hisus, “su ed-endamen din ke langun te kebpekeuma dut te Impasad te Eleteala ne Edatù. ");
INSERT INTO mbi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ugaid ne igkahi ku keniyu te nekeuma en si Elias asal warà dan mekilala, ne nasì dan midrasey sikandin te endei se kiyug dan. Engketà ded dema te kedresaya ran dut te Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Arà pà ne nekesabut ke menge edumdumaan ni Hisus te iyan din egkehiyen ne mekeatag ki Juan ke Ebpembunyag. ");
INSERT INTO mbi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Guna su midlived en ensi Hisus diyà te merakel ne etew ne ruen ketà mid-uvey ki Hisus, ne midlumpeng diyà te sineruwan din, ");
INSERT INTO mbi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ne migkahi te, “Mama, igkeyru nu ke anak ku! Ebevuyen sikandin ke edsuuk en ke busew ne egkerasey nevenar su ruen ke egkepiley riyà te apuy wey ruen ke riyà te wayig. ");
INSERT INTO mbi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne mid-ewit ku en sikandin kayi te menge edumdumaan nu su ebpevewian ku, ugaid ne warà dan megaga.” ");
INSERT INTO mbi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Migkahi si Hisus te, “Sikiyu ne menge etew guntaan, ne warà kebperetiyaya niyu te Eleteala wey menge suer kew!” ke sikandin. “Neuhet en se kebpekiduma ku keniyu, ne engkey pà se taman ne kebperetiyaya niyu? Engkey pà taman se keuhet din se kedtigkeri ku keniyu? Ipengkayi niyu ayan se vatà!” ");
INSERT INTO mbi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ne pineawà ni Hisus ke vusew ne mid-awà en diyà te kandin, ne arà dà dema ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ne mid-uvey ki Hisus ke menge edumdumaan din te sikandan dà ne mid-insà te, “Meambe ke warà dey megaga te edsegseg ke vusew ne midsuuk ketà te vatà?” ");
INSERT INTO mbi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Warà niyu megaga,” ke si Hisus, “su kurang nevenar ke kedsarig niyu te Eleteala. Tentenuri niyu ini su embiya ruen kebperetiyaya niyu te Eleteala ne reisek, misan iring dà dut te reisek ne lahas te mustasa ne ebpekegaga kew te merehen ne egketemanan. Su embiya idsempità ta ne ebpekegaga ka ne ebpearat te buvungan ke egkehiyan niyu te, ‘Meawà ka.’  ");
INSERT INTO mbi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Migkahi maa si Hisus te, ‘Ayan ne vusew ne kenà egkesegseg embiya kenà kew ed-una ebpengeningeni wey edlimpas te egkaan.’” ");
INSERT INTO mbi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Guna su nevurun en ke langun ne edumdumaan ni Hisus diyà te Geliliya ne migkahi si Hisus kandan te, “Mehaan en ibpalad ke Impeanak te Menusiyà diyà te menge kunterà din ");
INSERT INTO mbi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne ed-imetayan sikandin, ugaid ne ketà te iketelu ne hewii ne ebenawen ded sikandin.” Ne ketà ne nekebmutu nevenar ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Guna su nekeuma en si Hisus wey ke menge edumdumaan din diyà te inged ne Kapirnawum, ne mid-uvey ki Pedro ke menge ebpevayad te buwis dut te Nekebpuru ne Valey te Eleteala, ne mid-insà dan te, “Menu, ebayad ayan se meyterù niyu te buwis dut te Nekebpuru ne Valey te Eleteala?” ");
INSERT INTO mbi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Uya,” ke si Pedro. Guna su mibpemenayik en si Pedro diyà te baley ne mid-unaan en ni Hisus te egkahi te, “Diyà te itungan nu, Pedro, entei se ebayad te buwis diyà te egkamal te inged kayi te ampew te dunya? Engkey, ke mehinged kayi te inged din etawa ke riyà ebpuun te meriyù?” ");
INSERT INTO mbi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Ke riyà ebpuun te meriyù,” ke si Pedro. “Embiya iring ketà,” ke si Hisus, “ne kenà ki ebpekevayad diyà te Nekebpuru ne Valey te Eleteala su iyan ebpengemuney ketà ne ke Amey ta ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ugaid ne kenà meupiya,” ke si Hisus, “ke ebmeraat ke hinawa rut te ebpevayad te buwis keyta. Pendiyà ka te ranew ne pemunuwit ka ne ke egkeuna ne edtugtug diyà te bunuwit nu ne bigkata nu en. Ne ketà te bèbà te neutel nu ne egkekita nu ke kureta ne ereg ne ibayad ta te buwis. Kua nu ini ne pendiyà ka te Nekebpuru ne Valey te Eleteala su ivayad nu ini te buwis ta.” ");
INSERT INTO mbi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ketà ne hewii ne mid-uvey ki Hisus ke menge edumdumaan din se egkahi te, “Engkey se mepurù diyà te menge etew ne Edetuan te Eleteala riyà te langit?” ");
INSERT INTO mbi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ketà ne mid-umew si Hisus te senge etew ne vatà ne impeitindeg din kayi te etuvangan dan ");
INSERT INTO mbi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne migkahi te, “Tentenuri niyu ini embiya kenà kew edsambì te itungan niyu iring te itungan kayi te vatà ini ne kenà ebpegitung te kebmepurù din, ne kenà kew ebpekelusud dut te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Su ke etew ne mepurù diyà te Edetuan te Eleteala ne sikandin ke mepeembavà se hinawa rin iring kayi te vatà. ");
INSERT INTO mbi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Su misan engkey ne etew ne edtelimà te kevevaan en ne etew iring kayi te vatà su atag te keduma rin kediey ne iring te siaken se midtelimà din.” ");
INSERT INTO mbi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ne mekeatag be te ini se menge vatà ne mibperetiyaya kediey,” ke si Hisus, “ne embiya ruen etew ne ebpekevelavag dut te sarig te vatà ne iring kayi ne iyan pà meupiya ne ebperiwetuwan ke lieg din te mevehat ne batu ne id-antug diyà te rahat tumin dè be ke egkevelevahan ke sarig te vatà kediey. ");
INSERT INTO mbi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Keyru nevenar te menge etew kayi te ampew te dunya su ruen kebpenggeram kandan te ebpekedsalà. Kenà egkepakey ne kenà egkeuma ini se kebpenggerami te menge etew, ugaid ne ke etew ne ebpenggeram te ruma rin su apey ebpekedsalà ne mekeyruwiru nevenar! ");
INSERT INTO mbi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke belad nu etawa paa nu, ne tempera nu ne itimbag nu! Su iyan pà tumù ne egkesarir ka tumin dè be ke deruwa red ke velad nu wey paa nu ne igkeantug ka diyà te apuy nerakà. ");
INSERT INTO mbi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke mata nu, ne lesika nu ne itimbag! Su iyan pà tumù ne dibdivaluy se mata nu tumin dè be ke deruwa red ke mata nu ne igkeantug ka riyà te apuy nerakà.” ");
INSERT INTO mbi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Urami niyu,” ke si Hisus, “te kenà kew edsudì kayi te eduma kediey ne iring te vatà se kedsarig dan. Su ke menge suluhuen ne ebantey kandan ne layun diyà te etuvangan te Eleteala ne Amey ku diyà te langit.  ");
INSERT INTO mbi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Su mibpengkayi te ampew te dunya ke Impeanak te Menusiyà su apey ebpeliyu te menusiyà ne nelaag. ");
INSERT INTO mbi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Engkey se pegitungan niyu ne ed-ul-ulaan te senge etew ne ruen mehatus ne bilibili rin ne seveka se nelaag? Ini imbe se ed-ul-ulaan din, ed-ewaan din arà te siyew nepulù wey siyew ne ebpemenabtab su ebpenuntulen din arà se seveka ne nelaag taman te egketuen din. ");
INSERT INTO mbi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Igkahi ku keniyu,” ke si Hisus, “te embiya egketuen din en arà se nelaag ne dekelà pà se kegkehalew rin kayi te seveka ne netuen din dut te siyew nepulù wey siyew ne warà nelaag. ");
INSERT INTO mbi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ne engketà ded dema ke Amey tew ne Eleteala su kenà din egkiyuhan ne misan seveka dut te mibpesakup kandin ne egkelaag.” ");
INSERT INTO mbi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Embiya ruen duma nu ne nekedsalà kenikew,” ke si Hisus, “ne pendiyà ka te kandin ne kehiya nu ke salà din te deruwa kew rà. Embiya ebpevenar sikandin ne netevangan nu sikandin su ebpeked-uliey kew te meupiya ne itungan. ");
INSERT INTO mbi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ugaid ne embiya kenà ebpehimbenar sikandin, ne kuwa ka te senge etew etawa deruwa ne etew ne ebpeketitihus te kebitiyara niyu apey niyu egkerumai ke impesurat ne Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne embiya kenà sikandin ebpemineg kandan, ne peketueni nu en dut te langun ne egkevurun ne ebperetiyaya te Eleteala. Ne embiya kenà sikandin ebpemineg kandan, ne iringa niyu en sikandin te kenà niyu ruma te ebperetiyaya te Eleteala etawa iringa niyu en sikandin dut te tenlimbungen ne ebpevayad te buwis. ");
INSERT INTO mbi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tembù be igkahi ku ini keniyu,” ke si Hisus, “te ini se idawey nu kayi te kelibutan ne arà se indawey en dema te Eleteala riyà te langit. Engketà ded dema arà se idtuhut niyu kayi te kelibutan ne arà ke intuhut en dema te Eleteala riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ne igkahi ku maa keniyu: embiya duen deruwa keniyu kayi te ampew te dunya ne egkeseveka ne ebpemuyù te Eleteala te misan engkey en, ne ibehey kandan dut te Amey ku ne Eleteala riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Su embiya ruen deruwa etawa tetelu ne etew ne egkevurun su atag dut te kedsarig dan kediey, ne ketà a red dema te kandan.” ");
INSERT INTO mbi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ketà ne mid-uvey si Pedro ki Hisus ne mid-insà te, “Kerenan, kepipira a ebpesahad ke ebpekesalà ke ruma ku kediey? Maa, kepipitu rè be?” ");
INSERT INTO mbi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Kenà kepipitu rà,” ke si Hisus, “su egngivuwan. ");
INSERT INTO mbi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Su ke Kedatù te Eleteala dut te menge etew ne ebpekeiring kayi. Duen senge etew ne datù ne ebpevayad en te menge utang kandin dut te menge edsugsuhuen din. ");
INSERT INTO mbi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Guna su nekerudsù en se ebpevayad, ne ruen senge etew kandan ne mid-ewit kayi te ratù ne nekeutang kandin te egngivungivuwan ne pirak. ");
INSERT INTO mbi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tehaad te kenà sikandin ebpekevayad, ne migkahi en dut te datù te ibpepasa sikandin, iring te uripen abpeg ke esawa rin wey menge anak din wey ke langun taman ne kearen din, su apey mevayari ke utang din. ");
INSERT INTO mbi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ne midlumpeng sikandin kayi te etuvangan dut te datù se ebpemuyù te, ‘Kenà e pà nikuna sesawi su edlahud e pà,’ ke sikandin, ‘ne ebayaran ku sikuna te langun.’ ");
INSERT INTO mbi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ne neyruwan sikandin dut te datù, ne warà din en peveyari ke utang din ne pineulì din en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Guna su mid-ipanew en ini se edsugsuhuen ne nesinuhung din en ke ruma rin te edsugsuhuen ne nekeutang kandin te deisek dà. Ne migeweran din en su ebpekelen din en se egkahi te, ‘Beyari nu en ke utang nu kediey!’ ");
INSERT INTO mbi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ne midlumpeng en ini se duma rin te edsugsuhuen se ebpemuyù te, ‘Kenà e pà nikuna sesawi su edlahud e pà,’ ke sikandin, ‘ne ebayaran ku sikuna te langun.’ ");
INSERT INTO mbi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ugaid ne warà migkiyug, nasì pà te impevilanggù din ne kenà sikandin ebpekelihawang taman te kenà din egkevayaran ke langun ne utang din. ");
INSERT INTO mbi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Guna su nekita ini dut te ruma pà ne edsugsuhuen ne nengeepes dan ne mibpendiyà dan en te datù ne intarem dan ke langun. ");
INSERT INTO mbi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ne impetawag sikandin dut te datù ne migkehiyan din te, ‘Warà rantek nu ne edsugsuhuen! Warà ku en pevayari keykew su in-awà ku en te itungan ku ke langun ne utang nu kediey su atag dà dut te mibpemuyù ka kediey. ");
INSERT INTO mbi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne meambe ke warà ka meyru dut te ruma nu ne edsugsuhuen te iring dut te kinekeyru ku keykew?’ ");
INSERT INTO mbi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Neepes nevenar ke datù ne impevilanggù din en ini se edsugsuhuen ne kenà ebpekelihawang sikandin taman te kenà ebpekevayad te langun ne utang din. ");
INSERT INTO mbi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ne engketà imbe rema,” ke si Hisus, “ke ed-ul-ulaan keniyu dut te Amey ku ne diyà te langit ke kenà niyu ebpeseharen ke menge ruma niyu se edlipatan en ke meraat ne mid-ulaula ran keniyu su iawà niyu en iya te pegitungan niyu.” ");
INSERT INTO mbi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nekeipus si Hisus te ebpenurù ne mid-awà ketà te pruvinsiya te Geliliya ne mibpendiyà te pruvinsiya ne Hudiya. ");
INSERT INTO mbi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne mibpenduma kandin ke denda ne menge etew, ne nengeulian din ke ebpenderaru. ");
INSERT INTO mbi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ne ruen menge Peresiyu ne mibpengkayi te ki Hisus su ebaal dan te idseligkat kandin. “Menu, idluhut be te penduan tew,” ke sikandan, “se ebpekid-engked ke meama te esawa rin te misan engkey ne ibpuun din?” ");
INSERT INTO mbi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Migkahi si Hisus te, “Meambe, warà niyu ves mevasa ke impesurat ne Lalag te Eleteala ne egkahi te, ‘Inggenat te aney en ne midlimbag te Eleteala ke meama wey meritan?’ ");
INSERT INTO mbi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ne migkahi ke Eleteala te, ‘Tembù ed-ewaan dut te meama ke amey rin wey iney rin su riyà ebpekidseveka sikandin te esawa rin, ne ini se teled-esawa ne nevaluy ne seveka.’ ");
INSERT INTO mbi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ketà ne kenà dan en deruwa ne etew su neseveka rà. Tembù be ini se deruwa ne midseveka te Eleteala ne kenà egkepebelag dut te piya entei ne etew,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ne mid-insà ke menge Peresiyu te, “Embiya iring ketà ne meambe ke inluhut ni Moises dut te meama ne ebpekid-engked te esawa rin embiya ed-una edsurat te kesebenaran te ebpekid-engked en sikandin, ne arà pà ne egkeengkeran din ke esawa rin?” ");
INSERT INTO mbi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne midtavak si Hisus kandan te, “Inluhut ini ni Moises se kebpekid-engked niyu su meresen ke ulu rut te menge keep-epuan niyu su warà dan mebpemineg te kebpenurù din, ne engketà kew red dema. Ugaid ne kenà arà ke kiyug te Eleteala rut te pehaney en ne midlimbag din ke meama wey meritan. ");
INSERT INTO mbi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tembù be igkahi ku keniyu embiya ruen meama ne ebpekid-engked te esawa rin, misan kenà edlangkadlangkad ini se esawa rin kandin, ne edsaup ded maa ed-esawa ne nekelangkadlangkad te esawa rin.” ");
INSERT INTO mbi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Migkahi ke menge edumdumaan ni Hisus te, “Embiya iring ketà se egketemanan te teled-esawa, ne iyan tumù ne kenà ebpees-eseweey te etew.” ");
INSERT INTO mbi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Migkahi si Hisus te, “Duen menge etew, meama wey meritan, ne intandà kandan te Eleteala se kenà ebpeesewaan ne meupiya arà kandan, ugaid ne kenà meupiya arà dut te ruma. ");
INSERT INTO mbi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Su merakel ke puunan te meambe ke kenà dan ed-esawa. Duen kenà ebpekeesawa su ketà te kineanak kandan ne netuenan en te kenà dan ebpekeesawa. Ne ruen duma ne kenà ebpekeesawa su migkapun dan te menge etew. Ne ruen duma pà ne kenà ed-esawa su apey ran ebpekepesabut dut te Lalag te Eleteala mekeatag te Kedatù din dut te menge etew. Piya entei se ebpeketuman kayi te penurù ku ini, ne tumana rin en iya.” ");
INSERT INTO mbi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ne ruen ketà menge etew ne mibpemava te menge anak dan diyà te ki Hisus su ibperampen dan kandin su ebpepenubtuvaran dan, ugaid ne midawey ini dut te menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ugaid ne migkahi si Hisus te, “Kenà niyu dewaya sikandan! Ugaid ne ibpepengkayi niyu te kediey ke menge vatà, su ke menge etew ne Edetuan te Eleteala ne iring ke sarig dan kediey kayi te menge vatà ini.” ");
INSERT INTO mbi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ketà ne midampen din sikandan su ebpenubtuvaran din, ne mid-awà en. ");
INSERT INTO mbi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Duen senge etew ne kenakan ketà ne mibpendiyà te ki Hisus. “Meyterù,” ke sikandin, “engkey iyan se meupiya pà ne ed-ul-ulaan ku apey a mekekuwa te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ne midtavak si Hisus te, “Meambe ke id-insà nu kedì ke engkey se meupiya pà ne ed-ul-ulaan nu?” ke si Hisus. “Su sebseveka rà ke meupiya se ed-ul-ulaan din ne Eleteala rà. Embiya egkuwa ka te umur ne warà edtemanan din, ne tumana nu ke langun te penduan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ke se kenakan te, “Engkey ne menge penduan?” Ne midtavak si Hisus te, “Ke penduan ne iring te, ‘Kenà ka ed-imatey, kenà ka edlangkadlangkad te esawa nu, kenà ka ebpenakew, kenà ka edtarùtarù, ");
INSERT INTO mbi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","edati nu ke amey nu wey ke iney nu, wey ikelimù nu ke ruma nu iring te kegkelimù nu te hinawa nu,’ ” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Langun keniyan ne midumaan ku,” ke se kenakan, “engkey pè ma se kurang ne ed-ul-ulaan ku?” ");
INSERT INTO mbi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“Embiya iyan nu kiyug ne warè en kurang te ed-ul-ulaan nu,” ke si Hisus, “ne ulì ka ne pesaa ke langun ne kearen nu ne ipemehey nu ve ke elehà din diyà te menge ayuayu su apey ruen kekewesai nu riyà te langit ne muna pà dut te kearen nu kayi. Ne arà pà ne pengkayi ka te eduma kedì.” ");
INSERT INTO mbi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nerineg ini rut te kenakan ne mid-ipanew en se merungkug su kewasa nevenar. ");
INSERT INTO mbi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ketà ne migkahi si Hisus kayi te edumdumaan din te, “Benar ini te merehen nevenar dut te kewasa ne etew se kebpesakup din te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ne igkahi ku pà lavew keniyu te embiya id-upama ta ne iyan pà melemu ne ebpevayà diyà te vudsi te rahum ini se binatang ne kemilu tumin dè be ke kebpesakup te etew ne kewasa dut te menge etew ne Edetuan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Guna su nerineg ini kayi te menge edumdumaan din ne ingkegeyip dan nevenar ne mid-insà dan te, “Embiya iring ketà se kerehen din te etew ne kewasa te kebpesakup din dut te menge etew ne ebeyveyaan te Eleteala, ne engkey rè be buwa se ebpekehaked te umur ne warà edtemanen din?” ");
INSERT INTO mbi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ne midtengteng si Hisus kandan ne migkahi en te, “Embiya etew rà ne kenà dan ebpekegaga ne egaked te umur ne warà edtemanan din, ugaid ne Eleteala se ebpekegaga ne ebehey kandan su egkegaga te Eleteala ke langun taman.” ");
INSERT INTO mbi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ketà ne migkahi si Pedro te, “Netuenan nu te mid-ewaan dey ke langun taman dey su miduma key keykew. Ne engkey ve se lalew rey?” ");
INSERT INTO mbi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ne migkahi si Hisus kandan te, “Sebenarvenar ne ini se egkehiyen ku keniyu te embiya egkeuma ke hewii te egkevehu en ini se kelibutan, ne Sikandin ke Impeanak te Menusiyà ne ebpinuu en diyà te ebpinuuwan te punggus ne datù se Edatù te langun. Ne sikiyu ke sepulù wey deruwa ne edumdumaan ku ne ebpepinuuwan ku sikiyu se egkamal dut te sepulù wey deruwa ne bansa te inenakan ni Israyil. ");
INSERT INTO mbi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne misan entei ne etew se neewaan din ke ubpaan din, menge suled din, menge etevey rin, ke amey rin etawa iney rin, menge anak din etawa ke tanà din su atag dut te keduma rin kediey, ne ebpeketelimà sikandin te kemehatus egketakep se neewaan din ne ebehayan pà te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ugaid ne merakel ne menge etew guntaan,” ke si Hisus, “ne mepurù se ketengdanan din ne ketà te akir din ne hewii ne sikandan ke pinekemevavà te langun. Ne ruen menge etew guntaan ne mevavà dan nevenar, ne ketà te akir din ne hewii ne sikandan se pinekebmepurù se ketengdanan din.” ");
INSERT INTO mbi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ne mibpenempità si Hisus se egkahi te, “Ini se Kedatù te Eleteala te menge etew ne iring kayi. Ruen senge etew ne meluag se impemula rin ne wahed ne ed-ingaranan te paras. Mibpaneypaney ini se kemuney se ebepemengà te edsukeyan din ne egelevek kayi te pemulaan din. ");
INSERT INTO mbi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Guna su ruen en nekita rin ne in-upakat din en te edsukeyan din te senge elad ne pelatà su arà ke nelayaman ne sukey te senge hewii, ne pinehelevek din en kayi te pemulaan din. ");
INSERT INTO mbi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Guna su edluuk en ebpemenayik ke andew ne midlived pà ke kemuney diyà te pedian ne ruen nekita rin ne ebpimpinuu su warà helevek din. ");
INSERT INTO mbi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tembù be migkahi ini se kemuney te, ‘Gelevek kew rema diyà te pemulaan ku ne edsukeyan ku sikiyu te sesangan.’ ");
INSERT INTO mbi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ne mibpendiyà dan en. “Guna su neudtu en ke andew ne midlived pà maa se ebpemengà te ruma ne egelevek kandin, ne engketà ded ke mid-ulaula rin te edluuk en ebpemenaug ke andew. ");
INSERT INTO mbi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Guna su meapun en nevenar ne midlived pà sikandin diyà te pedian ne ruen ruma ne nekita rin ne ebpimpinuu rà. ‘Meambe ke ebpimpinuu kew rà kayi ne kenà niyu ebpekinuhunan ke hewii?’ ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“‘Su warà ebpehelevek kenami,’ ke sikandan. “Ne migkahi sikandin kandan te, ‘Gelevek kew rema diyà te pemulaan ku.’ ");
INSERT INTO mbi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ketà te ebpengirum-irum en ne migkahi ini se kemuney ketà te kedserihan din te, ‘Tewaha nu ke mibpenggelevek ne sukayi nu en. Unai nu te edsukey ke mewri ne pinelusud ku, ne arà pà ke neuna.’ ");
INSERT INTO mbi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ne ini se menge etew ne pinelusud din te egelevek te meapun en ne midsukeyan te sukey te senge hewii. ");
INSERT INTO mbi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Guna su edsukayen en ini se neuna ne pinelusud din, ne iyan dan pegitungan ne labi pà ke egkekuwa ran su migelevek dan te neep-epunan. Ugaid ne andang ded ne sukey te senge hewii ke nekuwa ran. ");
INSERT INTO mbi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nekuwa ran ke sukey ran ne mibpemivig dan dut te kemuney. ");
INSERT INTO mbi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ke sikandan te, ‘Meambe ke neked-iring dà ke sukey rey dut te mewri ne pinelusud nu te senge uras dà se kinehelevek dan? Ugaid ne sikami,’ ke sikandan, ‘ne kayi en minatey ke andew te peka rey.’ ");
INSERT INTO mbi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ne migkahi en ini se kemuney te, ‘Suleren, warà a midlimbung keniyu, su migkiyug kew ma ne egelevek dut te andang ne sukey te senge hewii. ");
INSERT INTO mbi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, telimaa niyu en ini se sukey niyu, ke se kemuney, ne ulì kew en. Su kediey ne kiyug ini se mewri ne pinelusud ku ne edsukayan ku te iring ded dut te insukey ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Meambe, kenà ku egkeveyveyaan ke kedì ne kureta? Maa, egkeima kew su metulanged a dut te menge etew?’ ");
INSERT INTO mbi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ne migkahi pà maa si Hisus te, “Duen merakel ne menge etew ne mepurù se ketengdanan din guntaan ne ketà te akir din ne hewii ne sikandan ke pinekemevavà. Ne ruen merakel ne menge etew ne kevevaan guntaan, ne ketà te akir din ne hewii sikandan se pinekemepurù se ketengdanan din.” ");
INSERT INTO mbi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ketà ne mibpendiyan en ensi Hisus te Hirusalim. Ne impesivey ni Hisus ke sepulù wey deruwa ne edumdumaan din ne gewii ran te ed-ip-ipanew ne migkehiyan din sikandan te, ");
INSERT INTO mbi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Netuenan niyu en,” ke si Hisus, “ne ebpendiyà kiyu te Hirusalim ne ketà sikandin ke Impeanak te Menusiyà ne ibpalad en diyà te menge mepurù te terebpelengesa wey ke menge meyterù te penduan. Ne ebpegumpung dan en te kukuman te ed-imetayan sikandin, ");
INSERT INTO mbi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ne arà ne ibpalad dan diyà te menge etew ne kenà Hudiyanen, ne ed-undaunda kandin, ebpenlambit kandin, arà pà ne ed-imetayan. Ugaid ne ketà te iketelu ne hewii ne egkevanew red sikandin.” ");
INSERT INTO mbi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ne mibpengkayi te ki Hisus ke esawa ni Sibidiyu abpeg ke deruwa ne anak din ne meama ne midlumpeng sikandin kayi te sineruwan ni Hisus su ruen ebpemuyuen din. ");
INSERT INTO mbi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne mid-insà si Hisus te, “Engkey se ebpemuyuen nu?” “Ini se ebpemuyuen ku,” ke sikandin, “ne ketà te akir din ne hewii te kedatù nu en ne pepinuuwa nu ini se deruwa ne anak ku ne ruma nu te edatù, seveka riyà te egkekewanan nu ne seveka riyà te egkehivang nu.” ");
INSERT INTO mbi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Matag niyu en ini ebuyua,” ke si Hisus, “ne warà niyu mesebuti an se ebuyuen niyu. Maa, ebpeketigker kew ve dut te kemeresayan ne mehaan ku en ibpevayà?” “Uya,” ke sikandan, “egketigkeran dey.” ");
INSERT INTO mbi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Benar iya ne edresayen kew iring dut te kemeresayan ku,” ke si Hisus, “ugaid ne warà ketengdanan ku te ebpemilì ke engkey se ebpepinuuwen ku kayi te egkekewanan ku wey kayi te egkehivang ku. Su ini ne intail dut te Amey ku ne Eleteala dut te mibpemilì din.” ");
INSERT INTO mbi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Guna su nerineg kayi te sepulù ne edumdumaan ni Hisus arà se ebuyuen dut te esawa ni Sibidiyu, ne nengeepes dan kayi te deruwa ne teleari. ");
INSERT INTO mbi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tembù be midtawag dan langun ni Hisus se egkahi te, “Netuenan tew se ini te menge pengulu te inged kayi te ampew te dunya ne metehel ne edsuhù te langun ne menge etew, ne ini se menge unuten ne kandan dà ne kiyug se edumaan. ");
INSERT INTO mbi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ugaid ne sikiyu,” ke si Hisus, “ne kenà kew ed-iring ketà. Su embiya ruen seveka keniyu ne egkiyug ne ebmepurù, ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà dut te menge ruma rin; ");
INSERT INTO mbi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ne embiya ruen seveka keniyu ne egkiyug te sikandin se ebpekeuna te langun niyu, ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà dut te menge ruma rin. ");
INSERT INTO mbi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Med-iring sikandin dut te Impeanak te Menusiyà te kenà iyan din kinepengkayi te ampew te dunya ne apey metevangi te menusiyà. Ugaid ne iyan din kinepengkayi ne apey rin metevangi sikandan, ne egkeimetayan su apey merakel se egkevelukasan.” ");
INSERT INTO mbi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Guna su ed-awà en ensi Hisus te inged ne Hiriku ne ruen merakel ne menge etew ne mibpenduma kandan. ");
INSERT INTO mbi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne diyà te kilid te ebpevayaan dan ne ruen deruwa ne meama ne pisek ebpimpinuu. Guna su nerineg kayi te deruwa ne pisek te edsahad si Hisus ne midtawag dan te, “Igkeyru key nikuna! Su sikuna ke inenakan dut te datù tew rengan ne si David!” ");
INSERT INTO mbi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ke merakel ne menge etew ketà se midawey kandan te mebpeeneng-eneng dan ugaid ne lemban en ne egkeilut se ebpemensag te, “Kerenan, igkeyru key nikuna! Su sikuna ke inenakan dut te datù tew rengan ne si David!” ");
INSERT INTO mbi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Guna su nerineg ni Hisus ne mid-itindeg pà ne midtawag din sikandan se egkahi te, “Engkey ma se ebpetevangan niyu kediey?” ");
INSERT INTO mbi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ne migkahi ke menge pisek te, “Kerenan, kiyug dey ne mekekita key red perem!” ");
INSERT INTO mbi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Neyru si Hisus kandan ne midampen din ini se menge mata ran. Arà dà iya ne nekekita ran en, ne miduma ran en ki Hisus te ked-ip-ipanew ran. ");
INSERT INTO mbi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Guna su ebpelundani ran en te Hirusalim ne nekeuma ran en te inged ne Bitpahi ne egkelingakà ke buvungan ne ed-ingaranan te Ulivuwen. Midsuhù en ni Hisus ke deruwa ne edumdumaan din te ebpeunaan dan, ");
INSERT INTO mbi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ke sikandin te, “Una kew en be ketà te inged ne an te unaan ta, ne ketà te kebpekeuma niyu ne egkekita niyu se in-iket ne kudà wey ke nati rin. Ekari niyu be ne ewita niyu kayi,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Ne embiya ruen ed-insà keniyu ke maan ke ed-ekaran niyu ne iyan niyu kehiya te, ‘Ke Kerenan dey se ebpegingawà kayi te egkeunturan din’ ne seguguneey ne ibehey rin keniyu.” ");
INSERT INTO mbi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ne ned-ulaula ini su apey metuman ke impesurat te Eleteala dut te senge etew ne mibpelambas te lalag din rengan ne egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kehiya niyu diyà te menge etew te Hirusalim te, ‘Ebpekeuma en ke datù niyu! Meamuk sikandin ne ed-untud te nati te kudà, uya, ed-untud te anak te kudà, ke binatang ne eduranan.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tembù mid-una mid-ipanew ini se deruwa ne edumdumaan din ne midtuman dan ke migkahi ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ne mid-ewit dan en ini se kudà wey ke nati rin kayi te ki Hisus, ne midebpasan dan te kumbalà dan ne mid-untud en ketà si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Merakel ne menge etew ketà se midtulid te menge kumbalà dan te ebpepevayaan ki Hisus, ne ke ruma ne mibpenibpù dan te menge subpang ne rawunen su intulid dan diyà te ralan su ini ke tuus te adat te menge Hudiyanen dut te menge mepurù dan. ");
INSERT INTO mbi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne ke menge etew ne mid-una ki Hisus wey engketà ded ke midtundug kandin ne migkerag te, “Edeyuen tew ke inenakan ni David! Menu ma ke ebpeneuven te Eleteala ini se midtendù din ne edatù te langun! Edeyuen tew ke Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ketà te kedlusud en ni Hisus te Hirusalim, ne mibmehurub ke langun ne menge etew dutun. “Engkey ini etawa?” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Midtavak ini se menge miduma ki Hisus te, “Si Hisus ini ne ebpelambas te Lalag te Eleteala ne riyà ebpuun te Nesarit diyà te lusud te Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Guna su nekeuma en si Hisus diyà te Hirusalim, ne midlusud sikandin diyà te Nekebpuru ne Valey te Eleteala ne mibpemenegseg din en ke menge etew ne ebpememasa wey ke menge ebpemendehang ketà. Ne mibpenunggad din ke menge lemisaan dut te menge etew ne ebpenambì te kureta wey ke menge ebpeminuuwan dut te menge etew ne ebpemendahang te menge melepati ne ibpemelengesa rut te menge Hudiyanen diyà te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne migkehiyan din sikandan te, “Duen en ura impesurat ne Lalag te Eleteala ne egkahi te, ‘Ini se baley ku ne ed-ingaranan te baley ne ebpengeningeniyan te menge etew.’ Ugaid ne sikiyu,” ke si Hisus, “ne mibaluy niyu en ini ne ubpaan te menge tenlimbungen!” ");
INSERT INTO mbi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ne gewii te diyà si Hisus te Nekebpuru ne Valey te Eleteala ne mid-uvey kandin ke menge pisek wey menge pungkù ne neulian din. ");
INSERT INTO mbi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne nengeepes nevenar ki Hisus ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan te nekita ran ini se mekegeyip ne mid-ulaula ni Hisus wey ke menge vatà ne egkerag te kedeyù dan kandin te, “Edeyuen tew ini se inenakan dut te datù tew rengan ne si David!” ");
INSERT INTO mbi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tembù be migkehiyan dan si Hisus te, “Menu, nerineg nu red ayan se migkahi ran?” “Nerineg ku,” ke si Hisus. “Ne maa, warà niyu bes mevasa ke impesurat ne Lalag te Eleteala ne egkahi te, ‘Misan ke deisek ne menge vatà ne mibpenurù te Eleteala te edeyù kandin.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ketà ne mid-awà en si Hisus se ebpependiyà te inged ne Bitanya ne dutun en mid-irehà. ");
INSERT INTO mbi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nepawà ketà te kedlived dan diyà te Hirusalim, ne nevitil si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ne nekekita sikandin te kayu ne igira uvey te ibpevayà dan. Mid-uvey rin su ed-inteng sikandin ke ruen bahas din, ugaid ne warà nekita rin su tibal rawun. Ne migkehiyan ni Hisus ke kayu te, “Igenat guntaani ne kenà ke en imbe ebpekevahas!” Arà dà ne nehangu en ke kayu. ");
INSERT INTO mbi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nekita ini rut te menge edumdumaan din ne negeyip dan. Ke sikandan te, “Meambe ke megmehaan nehangu ke kayu?” ");
INSERT INTO mbi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Sebenarvenar ne ini se egkehiyen ku keniyu,” ke si Hisus, “embiya edsarig kew te Eleteala te warà keduwaruwa te hinawa niyu, ne ebpekegaga kew te iring kayi te mid-ulaula ku ini kayi te kayu. Ne kenà ketà dà taman su misan ke kenà egkegaga te menusiyà ne egkegaga niyu iring te egkehiyan niyu ini se buvungan te, ‘Awà ka keniyan ne riyà ka te rahat,’ ne egketuman ini se egkehiyen niyu. ");
INSERT INTO mbi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tembù be,” ke si Hisus, “idtarem ku keniyu te embiya ruen ebuyuen niyu te Eleteala, ne eheta niyu ke hinawa niyu te warà keduwaruwa rin ne egketelimà niyu ini.” ");
INSERT INTO mbi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Guna su nekeuma ran en maa diyà te Hirusalim, ne midlived en maa si Hisus ketà te Nekebpuru ne Valey te Eleteala. Gewii rin te ebpenurù kayi te lusud ne ruen menge mepurù te terebpelengesa wey menge pekilukesen te Hudiyanen ne mid-uvey kandin ne mid-insaan dan si Hisus te, “Ini se mid-ulaula nu kayi te Nekebpuru ne Valey te Eleteala, engkey se kewagib nu te ed-ulaula te iring kayi? Ne engkey se mibehey keykew te kewagib?” ");
INSERT INTO mbi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Midtavak si Hisus te, “Duen seveka rà ne id-insà ku keniyu, ne embiya egketavak niyu ne idtarem ku keniyu ke engkey se mibehey kedì te kewagib kayi te mid-ulaula ku. ");
INSERT INTO mbi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Entei se mibehey ki Juan ke Ebpembunyag te kewagib te ebpembunyag, diyà be te Eleteala etawa kayi rà dè duen te menusiyà?” Ne mibpein-inseey ran te, “Engkey se idtavak tew? Su embiya iyan tew egkehiyen se, ‘Riyà ebpuun te Eleteala,’ ne ed-insà maa sikandin te, ‘Meambe ke warà kew mebperetiyaya ki Juan?’ ");
INSERT INTO mbi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ugaid ne embiya egkahi ki te, ‘Kayi red ebpuun te menusiyà,’ ne egkekeiran ki su mibperetiyaya ke langun ne menge etew te mibpelambas te Lalag te Eleteala si Juan.” ");
INSERT INTO mbi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ketà be ne midtavak dan ki Hisus te, “Kenà dey egketuenan.” Ne migkahi rema si Hisus kandan te, “Embiya iring ketà, ne kenà ku rema egkehiyen ke engkey se mibehey kedì te kewagib te mid-ulaula kayi.” ");
INSERT INTO mbi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mibpenurù pà maa si Hisus te, “Peg-pegitunga niyu ke engkey se meana rin ini se sempità ku. Duen senge etew ne deruwa se anak din me meama. Mid-uvey rin ini se kakey ne migkahi te, ‘Gelevek ka, Mama, diyà te pemulaan ta.’ ");
INSERT INTO mbi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“‘Ah, kenà a!’ ke se anak din. Ugaid ne nekepegpegitung ded ne ketà ne mibpendiyà te pemulaan dan. ");
INSERT INTO mbi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ne mid-uvey rut te meama ini se ari ne anak din ne engketà ded maa ke migkahi rin. ‘Uya, Amà,’ ke se anak din, ‘ebpendiyan a.’ Ugaid ne warà medtuman. ");
INSERT INTO mbi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Na, endei ve rapit kayi te deruwa ne teleari,” ke si Hisus, “se midtuman dut te suhù te amey ran?” “Ke kakey,” ke sikandan. “Idtarem ku keniyu,” ke si Hisus, “te ini se menge etew ne kenà meupiya kayi te etuvangan niyu iring te menge ebpevayad te buwis wey menge meritan ne warà en keeleran din ne ebpekeiring dut te kakey dut te teleari su edtuman dan guntaan te Lalag te Eleteala ne tembù be egkeuna ran keniyu ne ebpekelusud dut te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Su mibpengkayi te keniyu si Juan ke Ebpembunyag,” ke si Hisus, “su ebpenurù te metidtu ne ralan diyà te Eleteala, ne warà kew mebperetiyaya. Ugaid ne ini se ebpevayad te buwis wey ke menge meritan ne warà en keeleran din ne mibperetiyaya ran mulà. Ne sikiyu, misan nekita niyu en te nesembian dan ke ulaula ran su sabap te kebperetiyaya ran, ne warà kew mebpedsendit wey mebperetiyaya kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pemineg kew pà,” ke si Hisus, “te ruma pà ne sempità ku. Ruen senge etew ne ruen tanà din ne mibpemulaan din te wahed ne ed-ingaranan te paras. Ne mid-alad din arà, ne mibaal te edtehuan dut te egkekeres ne bahas te paras, ne midsebungan din te ebpeubpaan dut te ebpeventayen din. Ne ruen pinekamal din dut te impemula rin, ne arà pà ne mid-ipanew se ebpendiyà te meriyù ne inged. ");
INSERT INTO mbi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Guna su midsabpet en ke pinemula rin, ne midsuhù din ke menge edsugsuhuen din su ibpekuwa ke kandin ne umun. ");
INSERT INTO mbi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ugaid ne nekeuma ini se midsuhù din, ne migeweran dut te pinekemal din ne mibedasan dan ne ruen mid-imetayan dan ne ruen mibpenrumbag dan te vatu. ");
INSERT INTO mbi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ne misan iring ketà, ne ruen pà maa midsuhù din ne merakel pà dut te neuna. Nekeuma ran ketà ne engketà ded lavew ke imped-ulaula rut te pinekamal te pemulaan. ");
INSERT INTO mbi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ketà te ketepusan en ne iyan din en midsuhù ne ke anak din. Ke hingginawa rin te, ‘Kenà egkepakey ne kenà dan ed-edatan ini se anak ku.’ ");
INSERT INTO mbi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ugaid ne guna su nekeuma ini se anak din ne mibpeleglelahey ke menge pinekamal din te, ‘Ini en bes ke anak dut te kemuney kayi te tanà. Kuwa kew en su ed-imetayan tew su apey sikitew en se ebpekegkemuney kayi te tanà.’ ");
INSERT INTO mbi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Arà dà ne migeweran dan ne miguyud dan diyà te luwal dut te pemulaan ne mid-imetayan dan en. ");
INSERT INTO mbi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na,” ke si Hisus, “ketà te ked-ulì dut te kemuney te tanà, ne engkey ve se ibped-ulaula rin dut te pinekamal din?” ");
INSERT INTO mbi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Midtavak dan te, “Ebeyaan din arà se menge meraat ne etew ne ebpengimetayan din ne ebpekemalan din te ruma ne etew ne ebehey kandin te umun din ke egkeuma te kedsebpet.” ");
INSERT INTO mbi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ne migkahi pà maa si Hisus te, “Maa, warà niyu ves mevasa ke impesurat ne Lalag te Eleteala mekeatag te ini? Su nekahi ketà te, ‘Ke pelaus ne mid-eng-engkeran dut te menge etew ne ebpemevaley su kunaan dan ke warà rantek din, ne iyan en iya ini nepemilì ne segkad te valey. Ini se mid-ulaula te Kerenan, ne mekegeyip nevenar!’ ");
INSERT INTO mbi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Igkahi ku keniyu,” ke si Hisus, “te ini se umun niyu kayi te Edetuan te Eleteala ne id-awà kayi te keniyu ne ibehey diyà te ruma ne menge etew ne ebperumaruma te Lalag te Eleteala.  ");
INSERT INTO mbi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne geina te siaken ini se segkad ne egkerupet ke langun ne egkeulug ketà, ugaid ne egkepipinì ke langun ne egkepilayan din.” ");
INSERT INTO mbi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Guna su nerineg dut te menge mepurù te terebpelengesa wey ke menge Peresiyu ini se sempità ni Hisus, ne netuenan dan te sikandan ke nesuhat ketà, ");
INSERT INTO mbi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","tembù be ibpesigkem dan perem si Hisus. Ugaid ne neandek dan dut te merakel ne etew su mibperetiyaya ini se menge etew te ebpelambas te Lalag te Eleteala si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mibpenempità pà maa si Hisus te kebpenurù din kayi te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ke Kedatù te Eleteala dut te menge etew,” ke si Hisus, “ne iring kayi. Duen senge etew ne datù ne mibair te kevurunan te kegkawing te anak din ne meama. ");
INSERT INTO mbi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ne midsuhù din ke menge edsugsuhuen din diyà te menge etew ne mid-inggat din te ebpesabut kandan te ibpetelavuk dan te kevurunan. Ugaid ne warà dan sehipaa ke menge edsugsuhuen. ");
INSERT INTO mbi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ketà ne midsuhù pà maa te ruma ne edsugsuhuen din se egkahi te, ‘Kehiyi niyu ke menge etew ne neinggat ku te ebpehendad en su nelutù en ke sapì wey menge nati. Kuwa kew en su ebpekaan en!’ ");
INSERT INTO mbi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ugaid ne warà dan medsehipà su iyan dan midsinaru ke kandan ne ed-ul-ulaan. Ini se senge etew ne mibpendiyà te pengengewiran din, ne ke senge etew ne diyà te tindà din, ");
INSERT INTO mbi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ne ruma pà dut te neinggat te datù ne migawed dut te menge edsugsuhuen din ne mibedasan ne mid-emetayan dan. ");
INSERT INTO mbi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nerineg ini dut te datù ne neepes nevenar sikandin ne midsuhù din ke menge sundaru rin ne mibpeimetayan din arà se mid-imatey rut te edsugsuhuen din ne mibpevinsulan din ke inged dan. ");
INSERT INTO mbi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ne midtawag din ini se menge edsugsuhuen din ne migkahi te, ‘Nekepehendad en ke ibpekaan ku te kevurunan te kegkawing te anak ku, ugaid ne arà se menge etew ne mid-inggat ku ne kenà dan ebpekekaan su mid-engkenà dan dut te kineinggat ku kandan. ");
INSERT INTO mbi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pekehaan kew tuntula niyu ke menge meluag ne dalan ne ebpevayaan te merakel ne etew ne inggata niyu ke langun ne menge etew ne egkeuma niyu te ibpetelavuk kayi te kevurunan.’ ");
INSERT INTO mbi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ketà ne mibpendiyà ke menge edsugsuhuen ne midtuntul dan ke dalan, ne langun ne neumaan dan ne meupiya se ulaula rin etawa meraat ne mid-inggat dan te edtelavuk te kevurunan. Guna su nekeuma ran, ne nepenù en ke baley dut te egkewingan. ");
INSERT INTO mbi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Midlusud ini se datù ne mibair te kevurunan su ed-intengan din ke menge etew ne midtelavuk ne nekita rin ini se senge etew ne warà mekebevelegkas te belegkas ne idtelavuk te kewingan. ");
INSERT INTO mbi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Mama,’ ke se datù, ‘engkey se kinepekelusud nu kayi te warà ka mibevelegkas te idtelavuk te kewingan?’ Ugaid ne warà migkahikahi ke meama. ");
INSERT INTO mbi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ketà ne migkehiyan dut te datù ke menge edsugsuhuen din te, ‘Bekua niyu ke belad din wey ke paa rin ne iantug niyu riyà te kerusireman. Ne ketà ne ebpekependerawit wey ebpekengingitel.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ne migkahi pà maa si Hisus te, “Merakel ne menge etew se ed-inggaten te edlusud kayi te Edetuan te Eleteala, ugaid ne merelag se egkepemilì din.” ");
INSERT INTO mbi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ketà ne mid-awà ke menge Peresiyu ne mid-upakat dan te edseligkaten dan te menge insà si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ne ruen en midsuhù dan diyà te ki Hisus ne menge edumdumaan dan wey menge sakup ni Hirudis. “Meyterù,” ke sikandan, “netuenan dey te edlalag ka te benar. Ne ibpenurù nu ke benar mekeatag te kiyug te Eleteala rut te menge etew. Ne kenà ka egkepeneheewit dut te lalag te menge etew su warà etew ne ebpelebiyen nu. ");
INSERT INTO mbi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kehiya nu kenami ke engkey se pegitungan nu kayi te id-insà dey kenikew. Maa ibpekerimpas kiyu ve dut te penduan tew embiya ebayad ki te buwis riyà te ratù tew diyà te inged ne Ruma, etawa kena?” ");
INSERT INTO mbi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ugaid ne netuenan ni Hisus ini se meraat ne netahù te itungan dan ne migkahi te, “Sikiyu ne uvag kun ne ruen id-insà niyu kedi! Ugaid ne iyan se ebaal kew rà te ralan te kegkelitag niyu kediey! ");
INSERT INTO mbi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Peintenga a niyu kun te kureta ne ibayad te buwis!” Impekita ran kandin ke kureta, ");
INSERT INTO mbi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ne migkahi sikandin te, “Engkey ki paras wey ngaran kayi?” ");
INSERT INTO mbi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Paras wey ngaran dut te ratù tew kayi te inged ne Ruma,” ke sikandan. “Embiya iring ketà,” ke si Hisus, “ne ivehey niyu diyà te datù ayan se buwis kandin, ne ivehey niyu riyà te Eleteala ke endei rema ke kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nerineg dan ini se migkahi ni Hisus ne ingkeinuinu ran nevenar, ne mid-ewaan dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Arà ne hewii ne ruen menge Sadyusiyu ne mibpengkayi te ki Hisus. (Ini se menge Sadyusiyu ke menge etew ne warà mebperetiyaya te egkevanew pà te Eleteala ke menge minatey.) ");
INSERT INTO mbi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Meyterù,” ke sikandan, “impenurù dengan ni Moises te, ‘Embiya ruen meama ne ebpatey ne neketahak te esawa rin ugaid ne warà anak dan, ne ebpemeluwen dut te suled din ne meama su apey ruen ded anak dut te minatey ne ebpekesumpat.’ ");
INSERT INTO mbi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Su ruen nekeubpà kayi,” ke sikandan, “pitu ne meama ne telteleari ne mid-esawa en ke kakey, ugaid ne minatey te warà dan med-anak. Ne mibpemalu en dut te nesikupu rin arà se ipag dan. ");
INSERT INTO mbi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ugaid ne minatey red dema te warà dan med-anak. Ne engketà ded dema ke iketelu. Ne engketà ded ke nesamà, langun dan te pitu ne etew se nekepemalu ketà te ipag dan, ugaid ne warà dan med-anak. ");
INSERT INTO mbi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Netaman ne minatey en ini se meritan. ");
INSERT INTO mbi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ne ini ve se id-insà day keykew,” ke se menge Sadyusiyu. “Embiya benar ne egkevanew red te Eleteala ke menge minatey keuremà, ne entei ve rapit kandan se tehiesawa ketà te meritan? Su langun dan te pitu ne telteleari ne nekedtundug se nekeesawa kandin.” ");
INSERT INTO mbi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ne migkahi si Hisus kandan te, “Warà en iya ebpekesuhat ne itungan niyu! Su warà niyu mesebuti ke impesurat ne Lalag te Eleteala, ne warà niyu mesebuti ke rekelà ne gehem din. ");
INSERT INTO mbi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Su ketà te hewii ne kegkevanew te menge minatey, ne warà en kebpees-eseweey su iyan dan en egkeiringan ke menge suluhuen te Eleteala riyà te langit ne kenà ebpees-eseweey. ");
INSERT INTO mbi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ne ini se id-insà niyu mekeatag te kegkevanew te menge minatey, ne maa warà niyu ves mevasa ke migkahi te Eleteala keniyu kayi te impesurat din? Su migkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Siaken ke Eleteala ne ebpengerapen ni Abraham, ni Isaac, wey si Jacob.’ Tembù be netuenan tew,” ke si Hisus, “te misan minatey ran en ne biviyag dan pà diyà te etuvangan te Eleteala su iyan dà ebpekepengarap te Eleteala ke biviyag, kenà ke minatey.” ");
INSERT INTO mbi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Guna su nerineg ini dut te menge etew, ne negeyip dan nevenar dut te kebpenurù din. ");
INSERT INTO mbi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Guna su nerineg kayi te menge Peresiyu te nekepeeneng-eneng ke menge Sadyusiyu dut te penurù ni Hisus, ne mibpengkayi ran te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Senge etew kandan se edlitag ki Hisus dut te menge insà din su metmetau sikandin ne meyterù te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Meyterù,” ke sikandin, “engkey ma rut te penduan tew se pinekemepurù te langun?” ");
INSERT INTO mbi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ne midtavak si Hisus te, “ ‘Iamin nu ke hinawa nu te edlimù te Kerenan ne Eleteala nu, ne iamin nu ke baher nu wey ke itungan nu te ed-ulaula ke engkey se ebpekesuhat te hinawa rin.’ ");
INSERT INTO mbi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ini ke pinekemepurù ne penduan ne egkeuna rut te langun. ");
INSERT INTO mbi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne ini ke ikeruwa ne pinekemepurù dut te langun: ‘Ikelimù nu ke ruma nu iring te kegkelimù nu te hinawa nu.’ ");
INSERT INTO mbi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ne langun te penduan ne intelaan ni Moises kenitew wey ke impenurù dut te mibpelambas te Lalag te Eleteala rengan ne kayi ebpuun se deruwa ini.” ");
INSERT INTO mbi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ketà te kinekevurun te menge Peresiyu ne mid-insaan dan ni Hisus te, ");
INSERT INTO mbi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Menu, engkey se pegitungan niyu mekeatag dut te Mesiyas, ini se Impasad te Eleteala rengan ne Ebperetuen te langun? Engkey ki inenakan sikandin?” “Inenakan sikandin dut te ratù tew rengan ne si David,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Benar,” ke si Hisus, “ne geina te iring ketà ne meambe ke migkahi si David te arà se Impasad te Eleteala ne Ebperetuen te langun ne Kerenan din? Su midlumunan te Kedesenan ne Ebpetuntul te Menusiyà si David ne impesurat din te, ");
INSERT INTO mbi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Migkahi ke Eleteala ketà te Kerenan ku te, Kayi ka pinuu te rapit te egkekewanan ku taman te ebpenggiekan ku ke menge kunterà nu.’ ");
INSERT INTO mbi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na,” ke si Hisus, “embiya ini ke nekahi ni David te arà se Impasad te Eleteala ne Ebperetuen te langun ne Kerenan din, ne maa egkepakey ve ne kayi red ini te inenakan din?” ");
INSERT INTO mbi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne warà etew ne ebpekekahi ketà. Ne inggenat dè be ketà ne warà en ebpeketikà ne ed-insà ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne migkehiyan ni Hisus ke denda ne etew wey ke menge edumdumaan din te, ");
INSERT INTO mbi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ini se menge meyterù te penduan wey ke menge Peresiyu te ruen ketenged din te edseysey rut te Penduan ne intelaan ki Moises. ");
INSERT INTO mbi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iyan iya se medtuman kew te langun ne penurù dan, ugaid ne kenà kew ed-iring dut te ed-ul-ulaan dan su kenà dan edtumanen ke ibpenurù dan te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ebpekevahatan dan ke menge etew te penduan ne kenà dan egkegaga te edtuman, ugaid ne warà misan deisek dà ne idtavang dan te edtuman ketà. ");
INSERT INTO mbi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Langun ne ed-ul-ulaan dan ne iyan dan ked-ulaula ne ibpereyùdeyù dan dut te menge etew. Intengi niyu ma ke derekelà ne imbevengkeleng dan wey ke imbagkes te velad dan ne midtehuan te insurat ne Lalag te Eleteala! Ne engketà ded ayan se melayat ne peyapey te belegkas dan! ");
INSERT INTO mbi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Embiya edtelavuk dan te kevurunan ne riyà dan ebpinuu te insivey ne meupiya ne ebpepinuuwan te egkeedatan, ne embiya riyà dan en te valey ne ebpengedian te penduan dan ne ebpemilì dan te meupiya ne ebpepinuuwan diyà te sineruwan. ");
INSERT INTO mbi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iyan dan kiyug ne ed-edatan dan te menge etew riyà te kevurunan, ne kiyug dan dema ne ed-ingaranan te ‘Meyterù.’ ");
INSERT INTO mbi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ugaid ne sikiyu ve ne kenà kew peingaran te ‘Meyterù,’ su langun niyu ne iring te ebpenusuled su seveka rà ke Meyterù. ");
INSERT INTO mbi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Liyu rà te tuney ne amey niyu, ne kenà kew ed-amey te piya entei kayi te ampew te dunya su seveka rà ke amey niyu ne Eleteala riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne kenà kew rema peingaran te Pengulu su seveka rà ke pengulu niyu ne arà dà se Mesiyas ke Impasad te Eleteala ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ne embiya ruen seveka keniyu ne egkiyug ne ebmepurù ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà dut te langun. ");
INSERT INTO mbi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Su piya engkey ne etew ne ebpepurùpurù te hinawa rin ne ibpevavà te Eleteala, ugaid ne piya engkey ne etew ne mepeembavà te hinawa rin ne ibpepurù sikandin te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ne migkahi pà maa si Hisus te, “Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew dut te Eleteala! Uvag en kun ne eduma kew te kiyug te Eleteala! Ugaid ne ebelevahan niyu ke ibayà te menge etew ne ebpesakup perem te Eleteala. Sikiyu ne kenà kew ebpesakup dut te Kedatù te Eleteala, ne ed-alang kew pà maa dut te menge etew ne edlusud perem.  ");
INSERT INTO mbi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag en kun ne eduma kew te kiyug te Eleteala! Ne ebpeedleyedley kew te kebpengeningeni niyu te Eleteala su uvag kun se rekelà se sarig niyu te Eleteala. Ugaid ne kayi te ed-ul-ulaan niyu ne misan iring te edtavang kew te menge valu ne meritan, ne iyan niyu ma kedtavang su apey niyu meahew ke kearen dan. ");
INSERT INTO mbi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag en kun ne eduma kew te kiyug te Eleteala! Medmeriyù se ed-ipanewan niyu te tanà wey edlayag kew te rahat su ed-eneb te penurù niyu apey ruen ebpekeperumaruma keniyu. Ne embiya ruen ebpekeperumaruma keniyu, ne nasì en be maa ne warà pelahuy rin te ebpekependiyà te apuy nerakà dut te sikiyu. ");
INSERT INTO mbi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mekeyruwiru kew! Su iring kew te pisek ne edtuyuk te pisek ded dema! Mibpenurù kew te, ‘Embiya ruen etew ne edsesapà te edreviten din ke Nekebpuru ne Valey te Eleteala, ne misan kenà din edtumanen ne warà kereetayan din. Ugaid ne embiya edsesapà te edreviten din ke bulawan ketà te lusud te Nekebpuru ne Valey te Eleteala, ne iyan iya se medtuman sikandin te ini se insapà din.’ ");
INSERT INTO mbi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Warà itungan niyu su kayi te ini se ed-ul-ulaan niyu ne iring kew te pisek! Meambe, endei rapit se mevahat ne idsesapà niyu, ke bulawan etawa ke Nekebpuru ne Valey te Eleteala? Su ini se Nekebpuru ne Valey te Eleteala ne berekat, ne nevaluy ne berekat ke bulawan su kayi intahù. ");
INSERT INTO mbi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne impenurù niyu rema te, ‘Embiya ruen etew ne edsesapà te edreviten din ke edenaan te ibpelengesa te Eleteala, ne misan kenà din edtumanen ne warà kereetayan din. Ugaid ne embiya ruen etew ne edsesapà te edreviten din ke indenà ne ibpelengesa, ne iyan iya se medtuman sikandin te ini se insapà din.’ ");
INSERT INTO mbi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Benar iya ne iring kew te pisek! Meambe, endei rapit se mevahat ne idsesapà niyu, ke indenà ne ibpelengesa etawa ke edenaan te ibpelengesa? Su ini se edenaan se ibpelengesa ne berekat, ne nevaluy ne berekat ke langun ne idenà ne ibpelengesa ketà. ");
INSERT INTO mbi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tembù be embiya ruen etew ne edsesapà te edreviten ke edenaan te ibpelengesa, ne ebpekeragkes en ke langun ne indenà ne ibpelengesa ketà. ");
INSERT INTO mbi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Engketà ded dema ke ruen etew ne edsesapà ne edreviten ke Nekebpuru ne Valey te Eleteala, kenà ke Nekebpuru rà ne Valey te Eleteala ke idsesapà din su elin dema ke Eleteala ne ed-ubpà ketà. ");
INSERT INTO mbi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne engketà ded dema ke ruen etew ne edsesapà ne edreviten din ke langit, ne kenà ke langit dà ke idsapà din su elin dema ke Eleteala su ketà ebpinuu se edatù te langun. ");
INSERT INTO mbi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag kun ne eduma kew te kiyug te Eleteala! Ebehey kew te Eleteala te kandin ne umun ne ikesepulù dut te pinemula niyu ne peninù iring te tandlad wey bawing, ugaid ne warà niyu tumana ke didis en dut te Penduan. Su kenà metidtu ke ulaula niyu ne kenà kew egkeyru te menge ruma niyu, ne kenà kew egkeserihan. Benar ne ebehey kew te Eleteala te kandin ne umun, ugaid ne warà niyu ma tumana ke didis en dut te Penduan. ");
INSERT INTO mbi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne iring kew te pisek ne edtuyuk te pisek ded dema! Embiya idsempità ta ne iring te id-awà niyu ke rengit diyà te ed-inumen niyu kayi te betasan niyu te edtuman te kenà utew benar ne penurù te Penduan. Ugaid ne iring te ed-iveleng kew te dekelà ne binatang ne kemilu kayi te warà niyu kedtuman dut te didis en te Penduan. ");
INSERT INTO mbi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag en kun ne eduma kew te kiyug te Eleteala! Su iring kew te menge basu wey pelatu ne midlinisan diyà te luwal, ugaid ne kayi te diralem niyu ne meredsik su iyan niyu ed-ul-ulaan ne edlimbung kew te menge ruma niyu ne ed-ahew kew te menge kearen dan. ");
INSERT INTO mbi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikiyu ne menge Peresiyu, benar iya ne iring kew te pisek! Unai niyu te edlinis ini se meredsik ne kenà egkekita ne kayi te diralem niyu su apey ebmetidtu ini se ed-ul-ulaan niyu! ");
INSERT INTO mbi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag en kun ne eduma kew te kiyug te Eleteala! Iring kew ma te simintù ne edtehuan te lungun ne mibintulaan te meputì su apey meupiya ne edtengtengan, ugaid ne diyà te lusud ne nepenù te menge tulan wey sahu. ");
INSERT INTO mbi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne iring kew ve ketà! Su iyan niyu ibpekita te menge etew ne metidtu kew, ugaid ne diyà te diralem niyu ne nepenù kew te meredsik su uvag en kun ne eduma kew te kiyug te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mekeyruwiru kew ne menge meyterù te Penduan wey menge Peresiyu su edusaan kew te Eleteala! Uvag en kun ne eduma kew te Eleteala! Su mibpengumbeyaan niyu ke simintù ne edtehuan te lungun dut te menge mibpelambas te Lalag te Eleteala rengan, ne mideyreyanan niyu ke menge pantyun dut te menge metidtu. ");
INSERT INTO mbi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ugaid ne egkahi kew te, ‘Embiya ketà key en te gewii rut te keep-epuan dey, ne kenà dey ed-ul-ulaan ke mid-ulaula ran ne kenà dey ed-imetayan ke menge mibpelambas te Lalag te Eleteala.’ ");
INSERT INTO mbi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ew, na tembù pà nekahi niyu arà su telimà niyu te sikiyu iya ke menge inenakan dut te mid-imatey ketà te menge mibpelambas te Lalag te Eleteala rengan! ");
INSERT INTO mbi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na kua niyu en be, imesara ke meraat ne ulaula te menge keep-epuan niyu! ");
INSERT INTO mbi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Iring kew te pispis te uled! Ebmemenu kew te ed-elihu te kedusa keniyu diyà te apuy nerakà? ");
INSERT INTO mbi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne ebpeketuenan ku keniyu te ruen etew ne edsuhuen ku kayi te keniyu ne ebpelambas te Lalag te Eleteala, menge etew ne dekelà se netuenan din mekeatag te Eleteala, wey menge etew ne ebpenurù. Ugaid ne ruen ed-imetayan niyu, ne ruen idlansang niyu riyà te kayu, ne ebpembedasan niyu ke ruma diyà te lusud te baley ne ebpengedian te penduan niyu, wey ke ruma ne ebpenuntulen niyu riyà te menge inged su ebpemekeiran niyu. ");
INSERT INTO mbi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tembù be edusaan kew te Eleteala atag dut te kineimatey te langun ne menge etew ne kenà egkevenaran igenat dut te kineimatey ki Abel taman en dut te kineimatey ki Zacarias ke anak ni Berekiyas ne mid-imetayan te keep-epuan niyu diyà te elet te edenaan te ibpelengesa te Eleteala wey ke mibpeheletan diyà te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sebenarvenar ne ini se egkehiyen ku keniyu,” ke si Hisus, “sikiyu ne menge etew guntaan, ne igkeragkes kew te Eleteala te kedusa rin dut te kinepengimatey ran dengan.” ");
INSERT INTO mbi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ey, igkerurunù ku sikiyu ne menge mehinged te Hirusalim! Su sikiyu ke mibpengimatey te menge etew ne mibpelambas te Lalag te Eleteala, wey mibpenrumbag niyu te batu ke menge etew ne midsuhù te Eleteala keniyan te keniyu! Kenà kepipira ku rà perem eburuna sikiyu su edtugenuren ku sikiyu ebpekeiring te upa ne edlekup te anak din, ugaid ne kenà kew ebpelekup kediey! ");
INSERT INTO mbi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na guntaan ne ed-ewaan en te Eleteala ke inged niyu. ");
INSERT INTO mbi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ne ini se igkahi ku keniyu, igenat guntaani ne kenà a niyu en egkekita taman te egkeuma arà se hewii ne ebpekekahi kew te, ‘Edeyuen tew ini se nekeuma, ne midsuhù te Eleteala ke Kerenan tew.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Guna su mid-awà en si Hisus ketà te Nekebpuru ne Valey te Eleteala ne mid-uvey ke menge edumdumaan din ne midterù dan ke menge pengawid dut te melmeluag ne Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Uya,” ke si Hisus, “intengi niyu ma ini se rekelà ne valey ne batu ke pengengawid din. Su idtarem ku keniyu te ruen hewii ne egkeuma ne ini se egkekita niyu ne egkerundus ne warà seveka rà ne vatu ne egkesamà su egkevurahey an langun.” ");
INSERT INTO mbi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Guna su riyan dan en te buvungan ne ed-ingaranan te Ulivuwen ne mibpinuu si Hisus, ne mid-uvey kandin ke menge edumdumaan din te sikandan dà. “Ikahi nu kenami,” ke sikandan, “ke keenu egketuman ini se migkahi nu ne kegkerundus dut te Nekebpuru ne Valey te Eleteala. Ne engkey se idtuus dey su apey rey egketueni ke mehaan en egkepupus ini se kelibutan ne egkeuma arà ke hewii ne edlived ka kayi te ampew te dunya?” ");
INSERT INTO mbi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ne migkahi si Hisus te, “Uram kew su apey kew kenà meekali dut te menge etew ne metau ne edliyuk. ");
INSERT INTO mbi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Su merakel se edlepew ne engkungkun ne siaken en ne egkahi ran te, ‘Siaken en ini ke Impasad te Eleteala ne Edatù te langun ne menge etew!’ Ne ketà,” ke si Hisus, “ne merakel ne menge etew se ebpekeperetiyaya te tarù dan. ");
INSERT INTO mbi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne egkerineg niyu se ebpevunbunuey diyà te meriyù merani, ugaid ne kenà kew meandek. Su ini pà iya se egkeuna ne egked-ulaula, ugaid ne warà pà meuma ke hewii te kebpupusa kayi te kelibutan. ");
INSERT INTO mbi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ebpemekebunuey pà ke idsenge inged ne engketà ded dema ke idsenge retuan. Ne egetab se bitil wey edlinug te mevaher te piya endei en. ");
INSERT INTO mbi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ugaid ne rudsuan dà ini dut te keresayan ne egeramen niyu, iring dut te belilit te meritan ne ed-anak. ");
INSERT INTO mbi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Egkeepesan kew te langun ne menusiyà su atag te keduma niyu kediey. Ebpenigkemen kew ne ibpalad kew riyà te ruen ketengdanen din ne edresayen kew nikandan wey ruen pà ebpengimetayan. ");
INSERT INTO mbi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ketà te arà ne hewii ne merakel se edlekà te kebperetiyaya ran kediey, ne ebpemeked-epesey ran wey ebpeul-uluhey ran diyà te ruen ketengdanen din. ");
INSERT INTO mbi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ne merakel se edlepew ne engkungkun ne ebpelambas te Lalag te Eleteala, ne merakel se menge etew ne ebpekepehimbenar dut te tarù dan. ");
INSERT INTO mbi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne tehaad te ed-iseg ke meraat ne ulaula kayi te ampew te dunya, ne edlugkà ke limù dut te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ugaid ke etew ne misan egkerasey en sikandin ne kenà edsuwey dut te keduma rin kediey taman te ini pà sikandin te ampew te dunya, ne ebpekehaked te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne iyan pà ibpeuna ibpesabut kayi te tivuuk ne kelibutan ini se Meupiya ne Tudtul mekeatag te Kedatù te Eleteala dut te menge etew ne arà pà ne egkeuma ke hewii te kebpupusa kayi te kelibutan.” ");
INSERT INTO mbi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ne migkahi pà maa si Hisus te, “Ruen migkahi ni Daniel rengan, senge etew ne mibpelambas te Lalag te Eleteala, te ruen ebpekeuma ne ‘Ebpekekaid’ ne ebpekelusud diyà te Nekebpuru ne Valey te Eleteala su edsevuen din ke ed-edatan. (Sikiyu ne ebpekevasa kayi te insurat din ne pegpegitunga niyu ke meana rin.) ");
INSERT INTO mbi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ketà te egkeuma arà ne hewii ne ke menge etew ne riyà te pruvinsiya te Hudiya ne mebpelahuy ran diyà te buvungan. ");
INSERT INTO mbi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne ke etew ne riyà te ruwangen te valey rin ne kenà din en lilingaya ke keleglahan din su mebpelahuy en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne ke etew ne riyà te pengengewiran din, ne kenè en med-ulì se egkuwa te kumbalà din. ");
INSERT INTO mbi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ne egkeyruwan ke menge meritan ne mehingey te arà ne hewii wey ke menge meritan ne edseruru. ");
INSERT INTO mbi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipengeningeni niyu te Eleteala te kenà ini med-ulaula te hewii te kedrengreng etawa Hewii te Id-imeley! ");
INSERT INTO mbi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Su ini se kemeresayan ne ebpekeuma ne warà repeng din igenat dà dut te aney en limbaha ini se kelibutan, ne kenà en egkerepengan te misan keenu. ");
INSERT INTO mbi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ugaid ne sabap dut te raat te nanam te Eleteala ne migkurangan din en ke menge hewii rut te kemeresayan su embiya warà, ne warà egkesamà ne biviyag. Uya, su geina ne rekelà te limù din dut te menge etew ne mibpemilì din, ne migkurangan din ke hewii rut te kemeresayan. ");
INSERT INTO mbi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Su ketà ne hewii embiya ruen egkahi te, ‘Ini en ke Impasad te Eleteala ne Ebperetuen te langun ne menge etew!’ etawa ruen egkahi te, ‘Ayan en sikandin!’ ne kenà kew peretiyaya su apey kew kenà egkelimbungi. ");
INSERT INTO mbi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Su ruen ebpenlepew ne menge etew ne engkungkun te sikandan ke Impasad te Eleteala ne Ebperetuen etawa sikandan ke ebpelambas te Lalag te Eleteala. Ne ebpekita ran te mekegeyip ne ed-ul-ulaan su apey ran perem meekali ini se menge etew ne mibpemilì te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tembù be idtarem ku keniyu ini,” ke si Hisus, “su apey niyu meingati te kenà pà ini egked-ulaula. ");
INSERT INTO mbi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Su embiya ruen egkahi keniyu te, ‘Diyan en te tanà ne kenà egkeubpaan te menge etew ini se Impasad te Eleteala ne Ebperetuen,’ ne kenà kew peretiyaya ne kenà kew pendiyà. Etawa ruen egkahi te, ‘Kayi en sikandin ed-eles-eles su warà pà mibpepayag,’ ne kenà kew peretiyaya. ");
INSERT INTO mbi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Su ketà te kedlived te Impeanak te Menusiyà kayi te ampew te dunya ne iring te kehaan din te kilat ne ebpeketayew te langun ne linengkevan egenat te edsilaan taman te edsenlepan. ");
INSERT INTO mbi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Su iring dut te besaanan ne egkahi te, ‘Piya endei se ruen minatey rin, ne ketà eburun ke menge uwak.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ne ketà ke egkeipus en arà ne menge hewii te kemeresayan,” ke si Hisus, “ ‘Ne ebmerusirem ke andew, ne kenà en edsilà ke vulan, ne ebpengeulug ke menge bituen genat te langit, ne egkeparin en dut te netehuan din ke edtenuran ne menge bituen.’ ");
INSERT INTO mbi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ne ketà ne edlepew riyà te langit ke tuus te edlived en ke Impeanak te Menusiyà. Ne egkekita te langun ne menusiyà te ebpekeuma en sikandin ne egkerumaan te sehulapun, ne egkekita rema ke gehem din wey raman din ne ed-anlag, ne ketà ne ebpeninehew ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne ibperahing en ke budyung ne edsuhuen din ke menge suluhuen din diyà te epat ne pediyulu te dunya su apey ran egkevurun ke langun ne mibpemilì te Eleteala igenat te pehiliran taman te binunsuran.” ");
INSERT INTO mbi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Keniyan niyu rè ma te kayu ne igira,” ke si Hisus, “su ruen ibpenurù din keyta. Embiya nekepasad en te edrawrew ne ed-umbus en wey ebpenlumbey, ne tuus te ed-andew en. ");
INSERT INTO mbi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ne engketà ded dema embiya egkekita niyu en se netuman en ke langun ne tuus ne impenurù ku keniyu, ne egketuenan niyu te mehaan en se kedlived dut te Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tentenuri niyu ini se egkehiyen ku keniyu su ruen pà kayi te keniyu guntaani ebpekesaut pà ketà te kegketuman din ini. ");
INSERT INTO mbi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Su egkeawà ini se langit wey tanà ugaid ne ini se migkahi ku ne kenà bulug ebperis.” ");
INSERT INTO mbi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ugaid ne ini se idtarem ku keniyu,” ke si Hisus, “warà netau te hewii etawa endei egketahù ke andew ke kedlived kayi ke Impeanak te Menusiyà su ke Amey ku rà ne Eleteala. Misan ke suluhuen te Eleteala diyà te langit wey misan dema siaken ke Anak te Eleteala ne warà netau ke keenu se edlived din. ");
INSERT INTO mbi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Su ketà te kedlived dut te Impeanak te Menusiyà kayi te ampew te dunya, ne ebpekeiring ke menge ed-ul-ulaan te menge etew rut te ed-ul-ulaan te menge etew rengan te gewii pà ni Noa. ");
INSERT INTO mbi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Su rengan te warà pà ke dalem, ne warà sanggel dan se ebpengevurun su egkaankaan dan ne ebpenginum wey ebpees-eseweey taman te arà en ne hewii te midlusud en ensi Noa ketà te rekelà ne avang ne ed-ingaranan te arka. ");
INSERT INTO mbi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ugaid ke menge etew ne warà utew mekesabut ke engkey se egketemanan dan taman te netekew en ke dalem ne neherà dan langun. Ne iring din ded be ketà ke edlived ke Impeanak te Menusiyà kayi te ampew te dunya. ");
INSERT INTO mbi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Su ketà ne hewii ke ruen deruwa ne meama ne ebpeemungey diyà te pengengewiran, ebpekeruma kedì ke senge etew ne egketahak ke seveka. ");
INSERT INTO mbi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Engketà ded dema ke ruen deruwa ne meritan ne ebpeemungey te egaling, ne ebpekeruma kedì se senge etew ne egketahak ke seveka. ");
INSERT INTO mbi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Uram kew ve ne ebpenehana kew en, su warà niyu metueni ke hewii ne edlived ke Kerenan niyu. ");
INSERT INTO mbi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ugaid ne ini se idtahù niyu te hinawa,” ke si Hisus, “embiya ebpekeingat ke kemuney te valey ke keenu ebpekeuma ke tekawen, ne ebpenehana neraan sikandin su apey kenà ebpekelusud te valey rin ke ebpenakew. ");
INSERT INTO mbi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ne engketà kew red dema, penehena kew neraan su ebpekeuma ke Impeanak te Menusiyà dut te endei se netehuan te andew ne kenà niyu ebpenerengen.” ");
INSERT INTO mbi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ne ketà ne mibpenempità si Hisus te, “Ke edsugsuhuen ne egkedserihan wey metmetau su edtuman dut te edsuhù kandin, ne ebpekemalen en dut te ruma ne edsugsuhuen. Ne sikandin se ebehey te egkekaan dut te ruma ne edsugsuhuen ketà te kegkaan dan. ");
INSERT INTO mbi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Meupiya nevenar se hinawa dut te edsugsuhuen ne ebpekemalen ke ebpekeuma ke ebpengemuney kandin ne iyan din egkekita se midtuman din ke langun ne insarig kandin. ");
INSERT INTO mbi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Idtarem ku keniyu,” ke si Hisus, “te ini se edsugsuhuen ne ebpekemalen ne midtuman te langun ne insarig kandin, ne sikandin en se ebpekekamal dut te langun ne kearen te ebpengemuney kandin. ");
INSERT INTO mbi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ugaid ne embiya kenà meupiya ne edsugsuhuen su warà te hinawa rin ke insuhù kandin ne kehingginawa rin te, ‘A kalu ke meuhet pà ebpekeuma ke ebpengemuney kenami,’ ");
INSERT INTO mbi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne ketà ne mibpemedasan din en ke ruma ne edsugsuhuen ne migkaankaan dè be sikandin wey ebpenginum elin dut te menge hubug. ");
INSERT INTO mbi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ne ketà ne netekew mekeuma ini se ebpengemuney kandin te hewii ne warà din penerenga su warà din metueni ke endei egketahù ke andew te kedlived din. ");
INSERT INTO mbi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ne ebpekepesangan sikandin te edrasey dut te ebpengemuney kandin su idragkes sikandin dut te menge meraat ne etew ne engkungkun ne eduma te kiyug te Eleteala. Ne ketà ne ebpekependerawit wey ebpekengingitel.” ");
INSERT INTO mbi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne mibpenempità pà maa si Hisus te, “Ketà te edlived ku kayi te ampew te dunya, ne ke menge etew ne egkiyug ne ebpekiduma dut te menge etew ne Edetuan te Eleteala ne iring kayi. Ruen sepulù ne etew ne menge raha ne ebpengemkem te sulù dan su edtelevuken dan ini se kenakan ne ibpengesawa. ");
INSERT INTO mbi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lelima kandan se lengab wey lelima red maa se bereitungan ebpenehana. ");
INSERT INTO mbi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ini se lelima ne lengab ne migkuwa ran te sulù, ugaid ne warà lana ne mid-ewit dan ke egkeibperan ke sulù dan. ");
INSERT INTO mbi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ugaid ke lelima ne bereitungan ne mid-ewit dan mulà te edtehuan te lana. ");
INSERT INTO mbi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne nelangan se kebpekeuma rut te kenakan ne ibpengesawa, ne edtureturen en ke menge raha ne edtahad ne nekelipereng dan en. ");
INSERT INTO mbi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ne ketà te edluuk en ke kerukileman ne ruen migkerag te, ‘Ini en ke kenakan ne ibpengesawa! Pengkayi kew en su sinuhunga niyu en sikandin! ");
INSERT INTO mbi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nekehimerat ini se sepulù ne menge raha ne mibpengumbayaan dan ke sulù dan. ");
INSERT INTO mbi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na, neibperan en te lana ini se sulù dut te lelima ne lengab ne migkahi ran en diyà te menge ruma ran te, ‘Behayi key pà te lana su egkeevukan en ini se sulù dey.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“‘Kenà egkepakey,’ ke se bereitungan ne menge raha, ‘su kenà ebpekegaga kenitew ini. Pendiyà kew te tindà ne pemasa kew.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ketà ne mibpendiyan en te tindà ke lelima ne menge lengab. Ne lius dan dà ne nekeuma en ke kenakan ne ibpengesawa. Tembù be ke lelima rà ne etew ke nekepenehana ne nekeruma dut te kenakan diyà te baley ne egkewingan. Guna su nekepemenayik dan en ne mibpintuan en ke gumawan. ");
INSERT INTO mbi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ne iseg-iseg ne nekeuma en ini se lelima ne menge raha ne lengab ne mibpenehetiat dan en se egkahi te, ‘E, Mama, pelusura key.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ugaid ne migkahi ke kenakan ne ibpengesawa te, ‘Kenà, su kenà ku egketuenan sikiyu.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Iring kayi,” ke si Hisus, “ke ed-ul-ulaan te menge etew ketà te kedlived ku kayi, tembù be layun kew pempenehana su warà niyu metueni ke hewii etawa endei egketahù ke andew te kebpekeuma ku.” ");
INSERT INTO mbi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ne mibpenempità pà maa si Hisus te, “Ini se kedlived ku kayi te ampew te dunya ne ebpekeiring te senge etew ne mibpendiyà te meriyù ne inged. Ne ketà te warà pà mekehenat ne midtawag din ke menge edsugsuhuen din ne insarig din kandan ke kearen din. ");
INSERT INTO mbi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uman senge etew kandan ne mibehayan din te endei se taman ne egkegaga rin. Kayi te senge etew ne dekelà se egkegaga rin, ne mibehayan din te lelima nengivu. Kayi te ruma ne mibehayan din te deruwa nengivu su arà se egkegaga rin. Ne ketà te iketelu ne mibehayan din te sengivu su arà dema ke egkegaga rin. Ne ketà ne mid-ipanew en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ini se edsugsuhuen ne nekekuwa te lelima nengivu, ne midahewrahew en migkuwa te dehangan din ne netaman ne nekeuntung en sikandin te lelima pà nengivu. ");
INSERT INTO mbi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne engketà ded dema ke edsugsuhuen ne nekekuwa te deruwa nengivu, su nekeuntung sikandin te deruwa pà nengivu. ");
INSERT INTO mbi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ugaid ne ini se edsugsuhuen ne migkuwa te sengivu, ne migkekalut dà ne inleveng din ke kureta ne insarig kandin. ");
INSERT INTO mbi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Guna su neuhet en ne mid-ulì en ke ebpengemuney kayi te menge edsugsuhuen. Ne midtawag din sikandan su ed-intengan din ini se insarig din kandan. ");
INSERT INTO mbi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nekeuma ini se edsugsuhuen ne midserihan te lelima nengivu ne migkahi te, ‘Kerenan, ini en ke lelima nengivu ne insarig nu kedì, ne ruen pà ini lelima nengivu ne neuntung ku keniyan te kureta nu ne impemuunan ku te kedtitindàtindà ku.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Migkahi ini se ebpengemuney te, ‘Ara be! Meupiya ka su mibpegelep ke ves su midtinidtuwanan nu ini se insarig ku keykew. Geina te egkeserihan ka te deisek ne kureta, ne ed-umanan ku pà ke idsarig ku kenikew te rekelà pà. Pengkayi ka su apey ka ebpekeamung te kegkehalew ku! ");
INSERT INTO mbi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ne midlusud en maa ke edsugsuhuen ne midserihan te deruwa nengivu ne migkahi te, ‘Kerenan, ini en ke deruwa nengivu ne insarig nu kedì, ne ruen pà ini deruwa nengivu ne neuntung ku keniyan te kureta nu ne impemuunan ku te kedtitindàtindà ku.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Migkahi ini se ebpengemuney te, ‘Arà be! Meupiya ka su mibpegelep ke ves su midtinidtuwanan nu ini se insarig ku keykew. Geina te egkeserihan ka te deisek ne kureta, ne ed-umanan ku pà ke idsarig ku kenikew te rekelà pà. Pengkayi ka su apey ka ebpekeamung te kegkahalew ku!’ ");
INSERT INTO mbi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ne midlusud en maa ke edsugsuhuen ne midserihan te sengivu ne migkahi te, ‘Kerenan, warà ku ipemuunan ke kureta nu te kedtitindàtindà su netuenan ku te mepasang ka ne etew. Ebpepemulaan nu ke menge edsugsuhuen nu su apey ka ebpekekuwa kayi te helevek dan. Ne ed-untung ka te kenà keykew ne helevek ke midtitindàtindà. ");
INSERT INTO mbi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Neandek a kenikew ne inleveng ku rà ini se kureta nu. Ini red ke kureta ne insarig nu kediey.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ ‘Warà rantek nu ne pehulen ne edsugsuhuen!’ ke se ebpengemuney. ‘Netuenan nu ves te ebpepemulaan ku ke menge edsugsuhuen ku su apey a ebpekekuwa te helevek dan, ne ed-untung a te kenà kedì ne helevek te edtitindàtindà. ");
INSERT INTO mbi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne meambe ke warà nu intahù diyà te bangkù ini se kureta ne insarig ku kenikew su apey ketà te kedlived ku ne egketelimà ku ke kureta ku te ruen iseg din?’ ");
INSERT INTO mbi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ne migkahi ke pengemuney kayi te ruma ne edsugsuhuen din te, ‘Kua niyu arà se kureta ne keniyan te kandin ne ivehey niyu ketà te edsugsuhuen ne mibpeiseg te sepulù nengivu ini se kureta rin. ");
INSERT INTO mbi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Su ke etew,’ ke si Hisus, ‘ne egkeserihan dut te insarig kandin, ne ed-umanan pà apey edsawadsawad pà ke kandin. Ugaid ke etew ne kenà egkeserihan, ne ed-ewien pà misan ke reisek ne insarig kandin. ");
INSERT INTO mbi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne ini se edsugsuhuen ne warà rantek din ne iantug niyu ipekeriyù diyà te merusirem, ne ketà ebpekependerawit wey ebpekengingitel.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ketà te edlived kayi te ampew te dunya,” ke si Hisus, “ke Impeanak te Menusiyà ne edumaan te langun ne menge suluhuen din, ne ebpinuu sikandin ketà te ebpinuuwan te punggus ne ratù su edatù te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ne eburunen din ke langun ne menusiyà diyà te etuvangan din, ne ketà ne ebpedsivayen din te deruwa ne puntuk ne ebpekeiring dut te tumetuganur ne ebpemilien din ke bilibili ne idsivey rin ke kambing. ");
INSERT INTO mbi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne ke menge etew ne ebpekeiring te bilibili su metidtu ne kayi rin idtahù te egkekewanan din, ne ke menge etew ne ebpekeiring te kambing ne kayi rin te egkehivang din. ");
INSERT INTO mbi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ne egkahi en ini se punggus ne ratù kayi te menge etew te egkekewanan din te, ‘Sikiyu ne mibehayan te keupianan dut te Eleteala ne Amey ku, ne lusud kew dut te Kedetuan te Eleteala ne impenehana keniyu igenat dut te kinelimbaha te kelibutan. ");
INSERT INTO mbi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Su ketà te nevitil a ne mibehayan a niyu te egkekaan, ne nemeraan a ne pineinum a niyu. Ne ketà te nekeuma a riyà te keniyu ne misan kenà a niyu egkekilala ne pinepemenayik a niyu. ");
INSERT INTO mbi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne ketà te warà belegkas ku, ne mibehayan a niyu te belegkas. Ne nekedaru a, ne midtuganur a nikiyu. Ne nevilanggù a, ne midlauy a nikiyu.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ne egkahi ini se menge metidtu kayi te egkekewanan te, ‘Kerenan, keenu ka nevitil ne pinekaan dey sikuna, etawa nemeraan ka ne pineinum dey sikuna? ");
INSERT INTO mbi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Keenu ka mibpengkayi te kenami ne misan warà dey mekilala sikuna ne pinepemenayik dey sikew? Ne keenu ka mewerai te belegkas ne mibehayan day sikuna? ");
INSERT INTO mbi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Keenu ka medaru etawa nevilanggù ne midlauy rey sikuna?’ ");
INSERT INTO mbi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ne egkahi ke punggus ne ratù te, ‘Sebenarvenar ne ini se egkehiyen ku, ketà te mid-ulaula niyu ini diyà te misan engkey dut te kevevaan en ne eduma kedì ne iring te mid-ulaula niyu ini kayi te kediey!’ ");
INSERT INTO mbi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ne ketà ne egkehiyan din ke menge etew kayi te egkehivang din te, ‘Sikiyu ne mibpenrewakan te Eleteala su nesuhat kew te sakit te hinawa rin, awà kew kayi te kediey! Pendiyà kew te apuy nerakà ne kenà egkeevukan ne impenehana ki Setanas ke datù te pekaid wey ke menge sakup din. ");
INSERT INTO mbi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Su nevitil a ne warà a niyu behayi te egkekaan, ne nemeraan a ne warà a niyu peinuma. ");
INSERT INTO mbi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne ketà te nekeuma a riyà te keniyu, ne warà a niyu pepemenayika. Ne warà belegkas ku, ne warà a niyu behayi. Nekedaru a, ne warà a niyu tugenura. Nevilanggù a, ne warà a niyu leuya.’ ");
INSERT INTO mbi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ne ketà ne egkahi ini se menge etew kayi te egkegivang te, ‘Kerenan, keenu ka nevitil etawa nemaaran, etawa nekeuma ka kayi te kenami, etawa warà velegkas nu, etawa nekedaru ka, etawa nevilanggù ka ne warà key medtavang keykew?’ ");
INSERT INTO mbi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ne egkahi ke punggus ne ratù te, ‘Sebenarvenar ne ini se egkehiyen ku keniyu, uman kew warà medtavang dut te kevevaan en ne eduma kedì ne iring te mid-ulaula niyu ini kayi te kediey!’ ");
INSERT INTO mbi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Tembù be,” ke si Hisus, “ini se menge etew ne ibpependiyà te apuy nerakà su edusaan te warà edtemanan din. Ne ini se menge metidtu ne ibpependiyà te surugà su ruen umur dan ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Guna su nekeipus si Hisus se ebpenurù ne migkehiyan din ke edumdumaan din te, ");
INSERT INTO mbi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Netuenan niyu te deruwa rà ne hewii ne kegkeuma ke Pista ne edtenuran tew te Kedsehari te Suluhuen dut te menge apù tew rengan. Ne arà en ke kebpalad dut te Impeanak te Menusiyà diyà te menge etew ne ibpelansang en diyà te pinebelavag ne kayu.” ");
INSERT INTO mbi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne arà dema ne hewii ne miburun ke menge mepurù te terebpelengesa wey ke menge pekilukesen te Hudiyanen diyà te turuhan ni Kayipas, ke pinekemepurù dut te langun ne terebpelengesa ");
INSERT INTO mbi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","su ebpemengà dan te ralan te kedsigkem dan ki Hisus te kenà egketuenan dut te menge etew su apey ran ebpeimetayi. ");
INSERT INTO mbi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ugaid ne iyan be kayi se kenà ta ini ed-ul-ulaan te ebpekeatuk dut te pista,” ke sikandan, “su kema ke egkekita rut te menge etew ne egkeepes dan keytew ne egkehuvut en ketà.” ");
INSERT INTO mbi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Guna su riyà si Hisus te inged ne Bitanya ne riyà sikandin te valey ni Simon, senge etew ini ne kevuwaen muna pà te it-it ne neulian. ");
INSERT INTO mbi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Gewii te egkaan si Hisus ne nekeuma en ini se meritan ne mid-ewit te pelenaan ne mibeelan te elibastru ne midtehuan te periyemut ne mepurù nevenar. Ne mid-uvey en kandin ne imbusbus din en ke periyemut kayi te ulu ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nekita ini rut te edumdumaan din ne neepes dan. “Babeba! Meambe ke midereetan din dà ini se periyemut?” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Iyan tumù ne indahang din ini ne ruen dekelà ne kureta ne igkepemehey pà diyà te menge ayuayu.” ");
INSERT INTO mbi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nesehipà ni Hisus ke edlelahen dan ne migkehiyan din sikandan te, “Meambe ke edsewayan niyu sikandin? Su meupiya nevenar ini se mid-ulaula rin kediey. ");
INSERT INTO mbi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Su ke menge ayuayu ne egketevangan niyu su lelayun kew red ebpemekeduma, ugaid ne siaken ne kenà ad meuhet kayi te keniyu. ");
INSERT INTO mbi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Su iyan din kinevusbus te periyemut kayi te lawa ku ne ibpenehana te kedleveng kediey. ");
INSERT INTO mbi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sebenarvenar ne ini se egkehiyen ku keniyu,” ke si Hisus, “te misan endei kayi te ampew te dunya ibpesabut ini se Meupiya ne Tudtul mekeatag kediey, ne egkepenudtul ded dema ini se mid-ulaula rin kediey ne kenà sikandin egkelipatan.” ");
INSERT INTO mbi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ne senge etew rut te sepulù wey deruwa ne edumdumaan ni Hisus, si Hudas Iskeriyuti, se mibpendiyà te menge mepurù te terebpelengesa ");
INSERT INTO mbi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ne migkahi te, “Pira se ibehey niyu kediey embiya ibpalad ku si Hisus diyà te keniyu?” Ne nesebutan dan en te tetelu nepulù ne pirak ne pelatà se imbehey ran en ki Hudas. ");
INSERT INTO mbi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","In-awà dè be ketà ne ebpemengaan en ni Hudas te ralan te kegkeulug din ki Hisus su apey ran mesigkem en. ");
INSERT INTO mbi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ne ketà te egkeuna ne andew te Pista te menge Hudiyanen te Egkaan te Pan ne Warà Insawug ne Ibpelevag ne mid-uvey ki Hisus ke menge edumdumaan din se egkahi te, “Endei rey ve ini ebpegetura se idlavung te Pista te kedtanud tew te Kedsehari te Suluhuen dut te menge apù tew rengan?” ");
INSERT INTO mbi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne migkahi si Hisus te, “Pendiyà kew te inged ketà te senge etew ne meama ne kehiya niyu kandin te, ‘Kiyug te meyterù tew te ini se baley nu ke edlevungan din wey ke menge edumdumaan din te ini se Pista su mehaan en ed-awà kayi te kelibutan.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne midtuman en dut te menge edumdumaan ni Hisus ke migkahi rin, ne mibpegatur dan en te idlavung dan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Guna su merukilem en ne nekeuma en ensi Hisus ne mibpinuu en sikandin wey ke menge edumdumaan din su egkaan dan. ");
INSERT INTO mbi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne gewii ran te egkaan ne migkahi si Hisus te, “Benar ini se egkehiyen ku keniyu, ruen senge etew kayi te keniyu se ed-ulug kediey.” ");
INSERT INTO mbi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ne ketà ne mibmerungkug ini se menge edumdumaan din ne uman senge etew ne mid-insà te, “Entei, Kerenan, kenà ma siaken?” ");
INSERT INTO mbi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ne migkahi si Hisus te, “Ini se ebpekidtuhen ne edeluwit en te pan din ke ed-ulug kediey. ");
INSERT INTO mbi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Su egkeimetayan ke Impeanak te Menusiyà iring dut te nekahi te impesurat ne Lalag te Eleteala rengan, ugaid ne meraat nevenar se egketemanan din ini se etew ne ed-ulug kandin. Iyan pà tumù ne warà ianak sikandin.” ");
INSERT INTO mbi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne si Hudas ke ebpesigkem ki Hisus ne migkahi te, “Entei, Meyterù, kenà ma siaken?” Ne migkahi si Hisus te, “Na, wey migkahi nu en iya.” ");
INSERT INTO mbi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Gewii te egkaan dan ne migkuwa ni Hisus ini se egkeenen dan ne pan ne impeselamat din te Eleteala, ne mibpenevìtevì din ne imbehey rin diyà te menge edumdumaan din se egkahi te, “Kua niyu ini ne keena niyu, su ini ke lawa ku.” ");
INSERT INTO mbi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne ketà ne migkuwa ni Hisus ke ed-inumen ne impeselamat din te Eleteala ne imbehey rin kandan se egkahi te, “Inum kew kayi, langun niyu. ");
INSERT INTO mbi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ini ke lengesa ku,” ke si Hisus, “ne ebpeketudà ne ibavas te menge etew, su tuus ini te egketuman en ke impasad te Eleteala rengan te ebpekepelihaun en ke menge etew dut te keberedusaan dan. ");
INSERT INTO mbi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Egkehiyen ku ini keniyu te kenà ad maa ed-inum kayi te ed-inumen ini taman te kenà egkeuma ke hewii keuremà te ebpekeamung kew en te Edetuan te Amey ku ne Eleteala ne ketà ne egkevehu en ke ed-inumen tew.” ");
INSERT INTO mbi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nekepasad dan ketà ne migkanta ran te kedeyù dan te Eleteala ne riyà dan en mebpesinaru te buvungan ne ed-ingaranan te Ulivuwen. ");
INSERT INTO mbi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ne migkahi pà maa si Hisus dut te edumdumaan din te, “Ini ne kerukileman ne langun niyu ne ebpelahuy ne edtehaken a niyu su ruen Lalag te Eleteala ne impesurat din ne egkahi te, ‘Ebpeimetayan ku ke tumetuganur rut te menge bilibili, ne egurunsuwey ke menge bilibili rin.’ ");
INSERT INTO mbi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ugaid,” ke si Hisus, “ne embiya egkevanew ad, ne ed-una ad keniyu riyà te inged ne Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ne migkahi si Pedro te, “Misan edtehaken ka rut te langun dan, ne siaken ne kenà!” ");
INSERT INTO mbi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ugaid ne migkehiyan sikandin ni Hisus te, “Tentenuri nu ini te kenà pà ed-ukarà ke manuk te ini en ne kerukileman ne ketetelu a nu en ibparew te kenà a nu ruma.” ");
INSERT INTO mbi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ugaid ne migkahi si Pedro te, “Kenà a ebpekekahi te iring ketà te kenà ki teleduma misan ebpekeunung a keykew te ed-imetayan!” Ne langun dut te menge edumdumaan ni Hisus, ne engketà ded dema se migkahi ran. ");
INSERT INTO mbi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ne ketà ne midlevundus en si Hisus wey ke menge edumdumaan din diyà te inged ne ed-ingaranan te Gitsimani. Guna su riyà dan en ne migkehiyan din sikandan te, “Pinuu kew rè be kayi su ebpengeningeni a keniyà te ubpu.” ");
INSERT INTO mbi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne miduma rin si Pedro wey ke teleari, ke menge anak ni Sibidyu. Ne nemutu nevenar sikandin wey nerurunù ke hinawa rin. ");
INSERT INTO mbi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne migkahi sikandin kandan te, “Merasey nevenar ini se hinawa ku su iring te egkevidtew en. Kayi kew rè be ne unung kew kediey.” ");
INSERT INTO mbi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne midlaus pà sikandin diyà te unaan dan ne midlangkeb en se ebpengeningeni te Eleteala te, “E, Amà, embiya egkepakey keniyan te kenikew, ne ipesahad nu en kediey ini se keresayan ku! Ugaid ne misan iring en ketà se kiyug ku, ne iyan nu tumana ke keykew ne kiyug.” ");
INSERT INTO mbi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Neiseg-iseg ketà ne midliveran din ke tetelu ne etew ne edumdumaan din ne iyan din neumaan se nekelipereng dan. Ne migkehiyan din si Pedro te, “Meambe ke kenà kew ebpekektigker te ed-unung kediey te senge uras dà? ");
INSERT INTO mbi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kenà kew lipereng, ugaid ne pengeningeni kew,” ke si Hisus, “su apey kew kenà ebpekeruma kayi te ebpenggeram keniyu. Su meveher perem ke hinawa niyu te eduma te lalag ku, ugaid ne midtaman dè be te kenà eduma ke lawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne mid-awà en maa si Hisus ne midsaup mibpengeningeni se egkahi te, “E, Amà, embiya kenà egkepakey ne ibpesahad kediey ini se keresayan ku, ne metuman en.” ");
INSERT INTO mbi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ne ketà ne midlived en maa sikandin kayi te tetelu ne edumdumaan din ne iyan din neumaan se nekelipereng dan su midseharan dan en te turug. ");
INSERT INTO mbi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ne mid-awà en maa si Hisus ne mibpengeningeni en maa te iketelu te arà ded ne pengeningeni rin. ");
INSERT INTO mbi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne midliveran din maa ke menge edumdumaan din te iketelu en ne migkahi te, “Maa, nekelipereng kew pè bes lavew? Ini en ke kebpalad dut te Impeanak te Menusiyà diyà te menge etew ne beniyagà. ");
INSERT INTO mbi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enew kew en,” ke si Hisus, “su ini en ke etew ne ed-ulug kediey. Kuwa kiyu en su edtelavuk ki.” ");
INSERT INTO mbi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gewii te edlalag pà si Hisus ne nekeuma en si Hudas, senge etew ini rut te sepulù wey deruwa ne edumdumaan din. Ne nerumaan dut te denda ne menge etew ne mibmemetarem dan te menge sundang wey menge behuval, su midsuhù dan dut te menge mepurù te terebpelengesa, ke menge meyterù te penduan, wey ke menge pekilukesen te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ugaid ne ketà te warà dan pà med-ipanew ne ruen ingkahi ni Hudas kandan te, “Ke etew ne ed-uvayen ku ne ed-erekan ku ne arà imbe ke ebpemengaan niyu. Sigkema niyu!” ");
INSERT INTO mbi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nekeuma rà si Hudas ne mid-uvey rin en si Hisus se egkahi te, “Mebmelinew se egketemanan nu, Meyterù!” Ne arà pà ne mid-erekan din. ");
INSERT INTO mbi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ne migkahi si Hisus te, “Suled, degdehawi nu en ini se impengkayi nu!” Ketà ne migeweran dan en si Hisus ne midsigkem dan en, ne midesdesenan dan te egawed. ");
INSERT INTO mbi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ugaid ne ruen senge etew dut te ruma ni Hisus se mid-ulavut te sundang din ne midtibas din en ke sugsuhuen dut te pinekebmepurù te terebpelengesa ne nesempingan en te telinga rin. ");
INSERT INTO mbi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Ilipi nu ke sundang nu,” ke si Hisus, “su ke etew ne ebpengimatey te sundang ne sundang ded dema ke id-imatey kandin. ");
INSERT INTO mbi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Maa, warà nu ves metueni te egkepakey ne ebuyù a te tavang diyà te Amey ku ne Eleteala, ne seguguneey ne ibpepengkayi rin ke egngivuwan ne suluhuen din? ");
INSERT INTO mbi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ugaid,” ke si Hisus, “ne kenà a su embiya ed-ul-ulaan ku arà ne memenu ve se kegketuman dut te impesurat ne Lalag te Eleteala ne egkahi te iyan iya se metuman te iring kayi?” ");
INSERT INTO mbi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ne migkehiyan ni Hisus ke menge etew ne edsigkem kandin te, “Maa, tulisan a ne ebmetereman niyu te sundang wey behuval te edsigkem kediey? Su uman ded ma hewii ne riyan a te Nekebpuru ne Valey te Eleteala se ebpenurù, ne warà e ma nikiyu sigkema ketà. ");
INSERT INTO mbi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ugaid ne egked-ulaula ini langun su apey egketuman en ke Lalag te Eleteala ne impesurat dut te menge etew ne mibpelambas te lalag din dengan.” Arà dà ne mibpelahuy en ke menge edumdumaan din ne intahak dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ne mid-ewit si Hisus dut te menge etew ne midsigkem kandin diyà te baley ni Kayipas, ke Pinekemepurù te langun ne menge Terebpelengesa. Su rutun nevurun ke menge meyterù te penduan wey ke menge pekilukesen te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ugaid ne si Pedro, ne midtundugtundug ded kandan taman te nekeuma sikandin diyà te lama te valey dut te pinekemepurù te menge terebpelengesa. Ne rutun ne midlusud sikandin dut te lama ne mibpekid-amur en mibpinuu dut te menge bantey te baley su edtengtengan din ke engkey se ibped-ulaula ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne ini se menge mepurù te terebpelengesa wey langun ne Perekukum ne mibpegelep dan mibpemengà ke engkey se id-isuhat dan ne kewagib ki Hisus misan kenà benar, su apey ran egkeimetayi. ");
INSERT INTO mbi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ne misan duen merakel ne etew ne midtitihus te kenà benar, ne warà netuen dan ne dait ne id-imatey ki Hisus. Netaman ne ruen en deruwa ne etew ne mid-etuvang ki Hisus ");
INSERT INTO mbi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne migkahi te, “Nerineg dey,” ke sikandan, “se egkahi ini se etew te, ‘Egkerundus ku ini se Nekebpuru ne Valey te Eleteala ne mibeelan te etew, ugaid ne ketà te tetelu ne hewii ne igkepeitindeg ku en ke behu ne valey ne kenà bineelan te etew.’ ” ");
INSERT INTO mbi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ketà ne mid-itindeg en ke Pinekemepurù te menge terebpelengesa ne migkehiyan din si Hisus te, “Engkey ve se keykew ne egkekahi? Engkey, benar ini se id-isuhat dan ne kewagib keykew?” ");
INSERT INTO mbi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ugaid ne mibpeeneng-eneng dà si Hisus. Ne migkahi pà maa ini se Pinekemepurù dut te menge terebpelengesa te, “Ini ka te etuvangan te Eleteala ne sesapà ka embiya sikuna ke Anak din ne Impasad din ne Ebperetuen te langun.” ");
INSERT INTO mbi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ne migkahi si Hisus te, “Benar ayan se nekahi nu su siaken en iya. Ne sebenarvenar ini se egkehiyen ku keniyu te kenà meuhet ne egkekita niyu ke Impeanak te Menusiyà ne ebpekepinuu riyà te egkekewanan te Eleteala ne warà repeng te gehem din. Ne ketà te edlived sikandin kayi ne egkekita niyu te edumaan te sehulapun.” ");
INSERT INTO mbi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nerineg dà dut te Pinekemepurù te Terebpelengesa ke migkahi ni Hisus ne mibisey rin en ke kumbalà din te kegkeepes din. Ne migkahi te, “Nekesumpalit en sikandin te Eleteala kayi te lalag din. Kenà ki en ebpemengà te ruma pà ne titihus su nerineg niyu en ini se kedsumpalit din! ");
INSERT INTO mbi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ne engkey en se keniyu ne kukuman?” Ne midtavak dan te, “Egkewegiban sikandin ne ed-imetayan en.” ");
INSERT INTO mbi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ne ketà ne mibpengilevan dan ke buked ni Hisus, ne mibedasan dan. Ne ruen midtabpì kandin ");
INSERT INTO mbi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne migkahi te, “Na, embiya sikuna ke Impasad te Eleteala ne Ebperetuen te langun, ne kehiya nu ke entei se midtabpì keykew.” ");
INSERT INTO mbi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ne kayi pà lavew te lama kayi te valey te Pinekemepurù te Terebpelengesa si Pedro, ne ruen meritan ne edsugsuhuen ketà te valey ne mid-uvey kandin. Ne migkahi te, “Sikuna rema ne ruma ka ni Hisus ke ebpuun te Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ugaid ne mibparew si Pedro ketà te etuvangan te langun ne menge etew se egkahi te, “Kenà ku egkesebutan ayan se egkehiyen nu.” ");
INSERT INTO mbi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ne mid-ip-ipanew en sikandin se ebpependiyà te bengawan te lama. Nekita en maa si Pedro te senge etew ne meritan ne edsugsuhuen ketà ne migkahi diyà te menge etew ne nevurun te, “Ayan se etew ne teleduma ki Hisus ne riyà ebpuun te Nesarit.” ");
INSERT INTO mbi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nerineg ni Pedro, ne mibparew rin ded maa se egkahi te, “Mekahat e pà te sapà ku ke teleduma key!” ");
INSERT INTO mbi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Neiseg-iseg manen ne mid-uvey ketà ke menge etew ki Pedro ne migkahi te, “Benar iya ne teleduma kew,” ke sikandan, “su kayi rà te lalag nu ne egketuusan en!” ");
INSERT INTO mbi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Dusa kedì,” ke si Pedro, “ke embiya teleduma key keniyan te etew ne egkehiyen niyu!” Arà dà iya ne mid-ukarà en ke manuk. ");
INSERT INTO mbi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ne ketà ne netenuran ni Pedro ke migkahi ni Hisus kandin te, “Kenà pà ed-ukarà ke manuk te ini en ne kerukileman, ne ketetelu a nu en ibparew te kenà ki teleduma.” Ne midlihawang si Pedro ne midrahukrahuk te kedsinehew rin. ");
INSERT INTO mbi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mesmeselem pà ne nevurun en ke langun ne menge mepurù te terebpelengesa wey ke menge pekilukesen te Hudiyanen ne neumpung dan en ke engkey se ed-ul-ulaan dan te ked-imatey ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne mibakù dan te kedina si Hisus ne mibpeneheewit dan sikandin diyà te ki Pilatu, ke gubinedur ne Rumanu. ");
INSERT INTO mbi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Guna su netuenan ni Hudas, ini se senge etew ne mid-ulug ki Hisus, te riyan en si Hisus te etuvangan ni Pilatu su egkukumen en te ebpeimetayan ne nekedsendit nevenar sikandin kayi te mid-ulaula rin. Ne mibpendiyà te menge mepurù te terebpelengesa wey menge pekilukesen te menge Hudiyanen ne in-ulì din ke tetelu nepulù ne pirak ne pelatà. ");
INSERT INTO mbi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nekesalà a,” ke sikandin, “su impesigkem ku arà se etew ne warà salà din!” Ne migkahi ran te, “Engkey se kenami ketà? Keykew rà ayan!” ");
INSERT INTO mbi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne insewirà din ke kureta diyà te lusud te Nekebpuru ne Valey te Eleteala, ne mid-ipanew en se ed-ehet te lawa rin ne mid-iket te lieg din ne mid-umpak. ");
INSERT INTO mbi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ne mibpemurut dut te menge mepurù te terebpelengesa ini se kureta se egkahi te, “Ini se kureta ne imbayad te ibpeimatey te etew ne ebpekesurang ki te Penduan tew embiya idtahù ta ini kayi te edtehuan te kureta kayi te Nekebpuru ne Valey te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na geina te iring ketà ne mibpengasak dan ke engkey se ebpeetahan dan kayi te kureta, ne neumpungan dan te ibpemasa te tanà dut te etew ne ediyun te kuren su ebeluyen ne penlelevengan te menge etew ne ebpekevehu ne ebpatey ketà. ");
INSERT INTO mbi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tembù be igenat ketà ne hewii ne mid-ingaranan arà se tanà te “Tanà ne Mibayaran te Lengesa” ne iyan din meana ne nepemasa te imbayad te ebpeimatey. ");
INSERT INTO mbi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ne ini se ned-ulaula ne netuman ke impesurat te Eleteala ki Jeremias senge etew rengan ne mibpelambas te Lalag din se egkahi te, “Migkuwa ran ke tetelu nepulù ne kureta ne pelatà, ini se mid-umpungan te menge etew te Israyil ne ibayad te ebpeimatey kandin, ");
INSERT INTO mbi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ne arà se impemasa ran te tanà te etew ne ediyun te kuren. Ini se impesabut kediey te Kerenan,” ke si Jeremias rengan. ");
INSERT INTO mbi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ne mibpeneheewit dan si Hisus diyà te ki Pilatu ke gubinedur ne impeetuvang dan ki Pilatu su ed-insaan. “Menu,” ke si Pilatu, “sikuna en iya ke ratù te menge Hudiyanen?” “Uya, ayan iya se migkahi nu,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ugaid ne langun ne in-isuhat dan kandin ne kewagib dut te menge mepurù te terebpelengesa wey ke menge pekilukesen te menge Hudiyanen ne warà din tevaka. ");
INSERT INTO mbi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ne ketà ne migkahi en maa si Pilatu ki Hisus te, “Menu, kenà ke en be edtavak kayi te langun ini ne in-isuhat dan kenikew?” ");
INSERT INTO mbi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ugaid ne warà en megkahikahi si Hisus te misan senge tahà dà, ne ketà ne neinuinu nevenar si Pilatu. ");
INSERT INTO mbi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne iyan nelayaman ni Pilatu te uman egkeuma ke Pista te Kedsehari te Suluhuen ne ruen ibpelihawang din ne senge etew ne vilanggù ne ebuyuen dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ketà dema ne hewii ne ruen senge etew ne nevilanggù ne ed-ingaranan ki Barabas su nevantug te meraat ne mid-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Guna su ruen en denda ne menge etew ne nevurun ne mid-insà si Pilatu te, “Menu, endei rapit se ibpelihawang ku, Si Barabas etawa si Hisus ke Impasad te Eleteala ne Ebperetuen te langun?” ");
INSERT INTO mbi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iyan din migkahi ini su netuenan din se ini se id-isuhat ne kewagib ki Hisus dut te menge mepurù te terebpelengesa ne sabap dut te kegkesihi ran kandin. ");
INSERT INTO mbi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ikeruwa rin ne gewii te kebpinuu diyà te kukuman ne ruen nekeuma ne telaan te esawa rin ne egkahi te, “Kenà ka ebpekid-ubpu dut te meraat ne idwagib dan keniyan te etew ne warà salà din. Su geina te merukilem ne ruen tehinepen ku mekeatag kandin ne nepesangan a.” ");
INSERT INTO mbi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ugaid ne ini se menge mepurù te terebpelengesa wey ke menge pekilukesen te Hudiyanen ne mibpemitiyeraan dan ke menge etew te iyan dan buyua ki Pilatu ne ibpelihawang si Barabas ne ebpeimetayan si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ne migkahi en maa si Pilatu ke gubinedur te, “Menu, endei rapit kayi te deruwa ini se egkiyuhan niyu ne ibpelihawang ku?” “Si Barabas!” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Embiya iring ketà se egkiyuhan niyu,” ke si Pilatu, “ne ebmemenuwen ku be si Hisus ini se Impasad te Eleteala ne Ebperetuen te langun?” “Ibpelansang nu riyà te ebpebelevahen ne kayu!” ke se menge etew. ");
INSERT INTO mbi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Meambe?” ke si Pilatu. “Engkey se meraat ne mid-ulaula rin?” Ugaid ne nasì en ne mid-iseg se kebpemensag dan te, “Ibpelansang nu sikandin diyà te ebpebelevahen ne kayu!” ");
INSERT INTO mbi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Guna su nesebutan ni Pilatu te kenà en egkepakey ne ibpeengked ke menge etew su deisek dà ne egkehuvut en, ne migkuwa sikandin te wayig ne mibpenlùlù sikandin te velad din dutun te etuvangan te menge etew su tuus ini te kenà sikandin ebpekid-ubpu dut te ked-imetayi ki Hisus. Ke sikandin te, “Warà kediey ke egkevudsi te lengesa keniyan te etew! Keniyu rà ayan!” ");
INSERT INTO mbi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne migkahi ke langun ne menge etew te, “Dusai key en abpeg ke menge kevuwaran dey ke egkevudsi ke lengesa rin!” ");
INSERT INTO mbi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ketà ne impelihawang en ni Pilatu si Barabas. Ne si Hisus embe ke imperuug din ne imbehey rin en kandan te ibpelansang diyà te pinebelavag ne kayu. ");
INSERT INTO mbi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ne impelusud en te menge sundaru si Hisus dut te turuhan te gubinedur, ne miburun ketà ke langun ne menge sundaru. ");
INSERT INTO mbi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne midluungan dan te velegkas din ne pinelelembung dan te merihà su uvag kun ne ratù. ");
INSERT INTO mbi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ruen impetengkulu kandin ne mibeelan dan ne ruhiyen ne wahed, ne ruen kayu ne mibpeheweran dan kayi te kewanan din. Ne ketà ne mibpenimbuel dan kayi te sineruwan din su uvag kun ed-adat dan kandin se egkahi te, “Mebereumur ka ne ratù te menge Hudiyanen!” ");
INSERT INTO mbi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne mibpengilevan dan sikandin, ne migkuwa ran ke kayu kayi te velad din ne imbadas dan dut te ulu rin. ");
INSERT INTO mbi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Guna su neipus ke kedsumpalit dan kandin, ne midluung dan en ke merihà ne impelelembung kandin ne inseluub dan ded ke kandin ne belegkas ne mid-ewit dan en sikandin diyà te ebpelensangan kandin. ");
INSERT INTO mbi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Guna su riyà dan en te ralan te kebpeneheewita ran en kandin ne ruen etew ne ed-ingaranan ki Simon ne riyà ebpuun te Sirini ne nesinuhung dan, ne mibpehes dan te ibpetiang ke pinebelavag ne kayu ne edtiangen ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nekeuma ran diyà te dapit ne mid-ingaranan te Gulguta, ne iyan din meana ne “Tulan te Ulu.” ");
INSERT INTO mbi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ne ketà ne ebpeinumen dan perem si Hisus te binu ne midsewuhan dan te mepait ne vawì, ugaid ne guna su neheraman din ne warà din inuma. ");
INSERT INTO mbi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Arà dà ne inlansang dan en si Hisus diyà te pinebelavag ne kayu. Neipus dan ne mibunutbunutan dan ke velegkas din ke entei se ebpekegkemuney kandan. ");
INSERT INTO mbi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ne mibpinuu ran se ebantey kandin. ");
INSERT INTO mbi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne riyà te divavew te ulu rin ne impikit dan ke midsuratan te in-isuhat dan ne kewagib ki Hisus se egkahi te, “Si Hisus ini Ke Ratù te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ne ruen deruwa ne tulisan ne inlansang dan dema duma ki Hisus, seveka kayi te egkekewanan din, ne seveka kayi te egkehivang din. ");
INSERT INTO mbi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ke menge etew ne midsahad kandin ne mibpendungkàdungkà dan te ked-undaunda ran kandin se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Na, endei embe ke migkahi nu ne egkerundus nu ini se Nekebpuru ne Valey te Eleteala ne ketà te tetelu ne hewii ne igkepeitindeg nu manen ke vehu pà? Embiya benar ne Anak ka te Eleteala, ne ibpelihaun nu ke hinawa nu! Pemenaug ke en keniyan te midlensangan keykew!” ");
INSERT INTO mbi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ne engketà ded dema ke ked-undaunda rut te menge mepurù te terebpelengesa, menge meyterù te penduan wey ke menge pekilukesen te Hudiyanen se ebpelelelahey ran te, ");
INSERT INTO mbi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nekepelihaun kun sikandin te menge ruma rin, ugaid ne ke kandin ne hinawa ne kenà din egkegaga. Menu, kenà sikandin ke ratù te menge Hudiyanen? Embiya ebpekepemenaug sikandin keniyan te midlensangan kandin, ne ebpekeperetiyaya ki te sikandin ke Impasad te Eleteala ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Migkahi rin te Eleteala se edserihan din ne migkahi rin pà te Anak sikandin te Eleteala. Na ed-intengan ta ve ke Eleteala se edtavang kandin!” ");
INSERT INTO mbi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne misan dema ke deruwa ne tulisan ne inlansang diyà te idsengeriveluyà din ne elin en ne ed-undaunda kandin. ");
INSERT INTO mbi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ne ketà te neudtu en ke andew ne mibmerusirem en ke tivuuk ne kelibutan lusud te tetelu ne uras. ");
INSERT INTO mbi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ketà te tetelu ne uras ne migkuleyì si Hisus te merahing se egkahi te, “Ili, ili, lama sebaktani?” Ne iyan din meana se, “Ey, Eleteala ku, Eleteala ku, meambe ke mid-ewaan a nu?” ");
INSERT INTO mbi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne ruen menge etew ne nekeitindeg ketà ne nekerineg kandin ne migkahi te, “Pemineha niyu ma su ebpengumawen din en si Elias.” ");
INSERT INTO mbi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Senge etew ketà se midahewrahew migkuwa kayi te in-ered te tebà ne midtiyuk din en te deisek ne terekayu ne insugkar din diyà te bèbà ni Hisus su ibpeesep. ");
INSERT INTO mbi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ugaid ne ruen migkahi te, “Na ed-intengan tew ve ke edlepew si Elias se ebpeawà kandin ketà!” ");
INSERT INTO mbi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ne migkuleyì en maa si Hisus te merahing ne nependusan en sikandin te hinawa. ");
INSERT INTO mbi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Diyà te Nekebpuru ne Valey te Eleteala ne ruen mekepal ne saput ne impehelet dut te insivey ne ed-ubpaan te Eleteala, ne ketà te kinepatey ni Hisus ne nevindas kayi te luuk ini igenat te divavew taman te diralem. Ne midlinug ne nengetevì ke derekelà ne vatu. ");
INSERT INTO mbi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ne ruen menge penlelevengan ne surung ne nengepuwasan, ne merakel ke minatey ne mibperetiyaya ki Hisus ne nengevanew en. ");
INSERT INTO mbi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne mibpenlihawang dan dut te leveng dan ne ketà te nevanew en si Hisus ne mibpendiyà dan te inged ne Hirusalim ne riyà dan mekita te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ne ini se kepitan wey ke menge ruma rin ne sundaru ne ebantey ki Hisus, ne nengeandek dan nevenar dut te neheram dan ke linug wey nekita ran ke langun ne ned-ulaula ketà. Ke sikandan te, “Benar ini ne Anak te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ne ruen dema ketà merakel ne menge meritan ne miduma ki Hisus ne egenat te Geliliya ne midtavang kandin. Ed-it-itindeg dan ini diyà te malù meriyù su edtengteng kandin. ");
INSERT INTO mbi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ne elin ketà si Maria Magdalina, si Maria ke iney ni Santiago ki Jose, wey ke esawa ni Sibidiyu. ");
INSERT INTO mbi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Guna su malù en edsanlep ke andew ne ruen nekeuma ne senge etew ne meama ne kewasa ne riyà ebpuun te Eremetiya. Iyan din ngaran ne si Jose ne sakup dema sikandin ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mibpendiyà sikandin te ki Pilatu ne mibuyù din ke bangkey ni Hisus, ne insuhù en ni Pilatu te ibpevehey. ");
INSERT INTO mbi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne migkuwa rin en ke vangkey diyà te midlensangan kandin, ne mibukusan din te behu ne malung ne meputì, ");
INSERT INTO mbi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne in-awuk din en ketà te behu pà ne leveng ne imbangbang diyà te dempilas ne intail ne kandin ne leveng. Ne ruen dekelà ne batu ne midlilid din ne inlekeb ketà te bengawan te leveng ne mid-ewaan din en. ");
INSERT INTO mbi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne si Maria Magdalena wey senge etew pà ne Maria ne mibpinuu ketà se edsinaru dut te leveng. ");
INSERT INTO mbi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ne ketà te neketundug ne andew, ne Sepetu ini, ne mibpendiyà te ki Pilatu ke menge mepurù te terebpelengesa wey ke menge Peresiyu, ");
INSERT INTO mbi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne migkahi kandin te, “Datù, netenuran dey te biviyag pà arà se teruen ne migkahi te, ‘Egkevanew e red ketà te iketelu ne hewii.’ ");
INSERT INTO mbi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tembù be peventayi nu nevenar ke leveng din lusud te tetelu ne hewii, su kalu ke penekawa ke vangkey rin dut te menge edumdumaan din ne ebpenudtulan dan ke menge etew te nevanew sikandin. Ne embiya arà se egkehiyen dan ne ebpehimbenaren dut te menge etew ne egkeumanan pà ke kegkelimbungi rut te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Kuwa kew en te menge sundaru,” ke si Pilatu, “ne peventayi niyu nevenar ke leveng.” ");
INSERT INTO mbi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ne ketà ne mibayaan dan en ke leveng ne midtehuan dan te tuus ke batu ne inlekeb su apey ran egketueni ke newaleng te misan deisek dà, ne mibpeventayan dan en te menge sundaru. ");
INSERT INTO mbi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Guna su neipus ke Hewii te Id-imeley ne mehaan en egkepawà te hewii te Akad ne mibpendiyà si Maria Magdalina wey ke senge etew ne Maria su ed-intengan dan ke leveng ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ne ketà ne ruen midtekew ne linug, ne ruen mibpehunrerenà ne suluhuen te Eleteala ne midlilid din ke batu ne inlekeb dut te leveng ne mibpinuuwan din en. ");
INSERT INTO mbi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ne ke paras din ne egkinrab iring te kilat, ne mibpeneringsing te keputì te velegkas din. ");
INSERT INTO mbi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne migkerker ini se menge ebantey te kegkeandek dan ne nevidtawan dan iring te minatey en. ");
INSERT INTO mbi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ugaid ne migkahi ke suluhuen kayi te menge meritan te, “Kenà kew meandek!” ke sikandin. “Su netuenan ku te ebpemengà kew ki Hisus ke inlansang dan diyà te pinebelavag ne kayu. ");
INSERT INTO mbi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ugaid ne warè en kayi su nevanew en iring dut te migkahi rin. Pengkayi kew ne intengi niyu ini se midtehuan dan kandin. ");
INSERT INTO mbi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ne pekehaan kew se ed-ipanew ne penudtula niyu riyà te menge edumdumaan din te nevanew en sikandin ne mid-una en sikandin keniyu riyà te Geliliya ne riyà kew ebpemekegkita. Na kenà niyu lipati ini se migkahi ku keniyu.” ");
INSERT INTO mbi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Arà dà ne migaangaan mid-awà ke menge meritan dut te leveng. Nengeandek dan ugaid ne netehuan dan te dekelà ne kegkehalew ne mibpelelahuy ran se ebpenudtul diyà te menge edumdumaan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ugaid ne gewii ran te ed-ipanew ne midtekew mibalak si Hisus kandan ne migkahi en te, “Mebmerinew se egketemanan niyu!” Ne mid-uvey ran kandin ne midlumpeng dan se egawed te paa rin te ebpengarap kandin. ");
INSERT INTO mbi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Kenà kew meandek!” ke si Hisus. “Beyai niyu ke menge edumdumaan ku ne pependiyana niyu sikandan te Geliliya ne diyan a nikandan egkekita.” ");
INSERT INTO mbi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ne ketà te kineipanew en dut te menge meritan se ed-awà kayi te leveng, ne mibpendiyan en te Hirusalim ke menge sundaru ne ebantey te leveng su mibpenudtulan dan ke menge mepurù te terebpelengesa te langun ne ned-ulaula kayi. ");
INSERT INTO mbi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Arà dà ne miburun en dut te menge mepurù te terebpelengesa ke menge pekilukesen te Hudiyanen ne mibpengasak dan ke engkey se ed-ul-ulaan dan. Guna su neupakat dan en ne mibehayan dan te dekelà ne pirak ke menge sundaru ");
INSERT INTO mbi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne migkahi ran te, “Penudtula niyu diyà te menge etew te mibpenakew dut te menge edumdumaan ni Hisus ke bangkey rin te merukilem te gewii niyu te nekelipereng. ");
INSERT INTO mbi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne embiya egkerineg ini dut te gubinedur,” ke sikandan, “ne kenà kew egkeuru su sikami rà se ebpetuntey kandin su apey kew kenà ed-isuhata.” ");
INSERT INTO mbi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ne midtelimà dut te menge sundaru ini se kureta ne midtuman dan arà se insuhù kandan. Tembù be taman te ini en ne hewii ne ini red ke ebpemenudtulen te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ne ini se sepulù wey seveka ne edumdumaan ni Hisus, ne mibpendiyà dan te Geliliya ketà te buvungan ne migkahi ni Hisus kandan. ");
INSERT INTO mbi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Guna su nekita ran sikandin ne mibpengarap dan kandin, misan duen kandan eduwaruwa se hinawa ran ke si Hisus ini se nekita ran. ");
INSERT INTO mbi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ugaid ne mid-uvey si Hisus kandan ne migkahi te, “Langun ne gehem te kebayàbayà diyà te langit wey kayi te ampew te dunya ne imbehey en kediey.” ");
INSERT INTO mbi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Na, pendiyà kew te langun ne menge etew kayi te ampew te dunya ne penurua niyu sikandan ke memenu se kebpesakup dan kediey. Ne pembunyahi niyu ke menge etew ne ebpesakup kediey te tuus te keduma ran te Eleteala, wey siaken ke Anak din, wey ke Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne penurua niyu sikandan te kedtuman dut te langun ne impenurù ku keniyu. Ne ini se idtahù niyu te hinawa te layun a eduma keniyu taman te taman.");
INSERT INTO mbi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ini ve ke Meupiya ne Tudtul mekeatag ki Hisu Kristu, ke Anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iyan din ini rudsuan ne nekedsuhatey dut te impesurat te etew ne mibpelambas te Lalag te Eleteala ne si Isaias su impesurat kandin te Eleteala se egkahi te, “‘Duen edsuhuen ku ne ibpeuna ku keykew,’ ke se Eleteala, ‘te kebpekepenehana rut te menge etew te kebpekeuma nu.’ ");
INSERT INTO mbi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Su riyà sikandin te tanà ne kenà egkeubpaan te etew ne ebpenawag dut te menge etew ne ed-uvey kandin, ke sikandin te, ‘Mehaan ne ebpekeuma ke Kerenan, ne ihewani niyu ke ralan, ne tidtuwa niyu ke ibayà din, ne iyan din meana ne tilaka niyu ke hinawa niyu su apey kew egkepenehana te kebpekeuma rin!’” ");
INSERT INTO mbi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ne netuman en ini ke impesurat te Eleteala ki Isaias mekeatag ki Juan su riyà sikandin mid-ubpà te tanà ne kenà egkeubpaan te etew se ebpembunyag wey ebpeketuenan dut te menge etew, ke sikandin te, “Pedsendit kew ne ewai niyu ke meraat ne betasan niyu ne pebunyag kew en,” ke sikandin “ne egkepesahad en te Eleteala ke salà niyu,” ke si Juan. ");
INSERT INTO mbi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne merakel ne menge etew ne mibpendiyà su ebpemineg kandin ne riyà ebpemuun te lusud te inged ne Hudiya wey riyà ebpuun te inged ne Hirusalim. Ne intarem dan te nekedsendit dan dut te langun ne meraat ne ulaula ran ne arà pà ne mibpebunyag dan ki Juan diyà te wayig ne Hurdan. ");
INSERT INTO mbi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Si Juan ini ne iyan din belegkas ne mid-avel ne bulvul te binatang ne ed-ingaranan te kemilu, ne iyan din insebitan se lundis ded dut te binatang. Ne iyan din keuyehan se tepurì wey teneb. ");
INSERT INTO mbi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne migkahi sikandin diyà te menge etew te, “Duen ebpeketundug kediey ne mepurù pà kediey, su misan ke telumpà din ne kenà a edait ne ed-ekar dà. ");
INSERT INTO mbi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ebunyahan ku sikiyu te wayig, ugaid ne sikandin ne ebpeketundug kediey ne ibunyag din keniyu te ked-ulin dut te Kedesenan ne Ebpetuntul te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ne warà dà meuhet ne nekeuma en si Hisus se riyà ebpuun te inged ne Nasarit lusud te inged ne Geliliya, ne mibunyahan sikandin ni Juan diyà te wayig ne Hurdan. ");
INSERT INTO mbi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Guna su egemew en si Hisus diyà te wayig ne nekita rin en ke langit ne nevukaan ne mibpehunrerenà en kayi te kandin ke Kedesenan ne Ebpetuntul te Menusiyà ne midragid te melepati. ");
INSERT INTO mbi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ketà ne ruen suwara ne riyà ebpuun te langit ne nerineg din se egkahi te, “Sikew ke Anak ku ne igkelimù ku nevenar, ne ebpekesuhat ka nevenar te hinawa ku.” ");
INSERT INTO mbi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Arà dà se nerineg din ne seguguneey ne impependiyà sikandin dut te Kedesenan ne Ebpetuntul te Menusiyà diyà te tanà ne kenà egkeubpaan te etew. ");
INSERT INTO mbi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne rutun mid-ubpà sikandin taman te neked-epat nepulù ne hewii, ne mibpenggeraman sikandin ni Setanas ke datù te pekaid, ke ebpekedsalà. Ne ruen dema mehintelunan ne binatang ketà ne ebpekekaid, ugaid ne ruen ma menge suluhuen te Eleteala ne mibpendiyà te ki Hisus su edtuganur kandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Guna ve su impevilanggù en si Juan ni Hirudis, ke ratù dut te inged din, ne midlived en si Hisus diyà te lusud te inged ne Geliliya se ebpesabut dut te Meupiya ne Tudtul te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke sikandin te, “Netuman en ke hewii ne impasad dut te keep-epuan tew,” ke sikandin, “su neuma en ke hewii te kedetui te Eleteala keniyu.” “Engkeri niyu en ke meraat ne ulaula niyu ne peretiyayaa niyu en ke Meupiya ne Tudtul,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Senge hewii ketà ne mid-ip-ipanew si Hisus diyà te veyvey te Ranew te Geliliya ne nekita rin si Simon wey ke ari rin ne si Andres se ebpemiyala riyà te veyvey te ranew su arà ke helevek dan. ");
INSERT INTO mbi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne migkehiyan en ni Hisus sikandan te, “Pengkayi kew en ne duma kew kediey,” ke sikandin, “su serà se ebpemiyalaan niyu guntaani, ugaid ne ebpenuruen ku pà sikiyu te iyan niyu mulà egkeutel ne menge etew ne eduma kedì.” ");
INSERT INTO mbi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Arà dà ne mid-ewaan dan en ke biyala ran su miduma ran en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Guna su neketantal en si Hisus ne nekita rin en si Santiago wey ke ari rin ne si Juan, ke menge anak ni Sibidyu, se riyà te avang dan ne ebpengumbayà te biyala ran. ");
INSERT INTO mbi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nekita ran dà ni Hisus ne mid-umew rin en te ebperumaan dan kandin. Arà dà ne mid-ewaan dan en ke amey ran ne si Sibidyu abpeg ke menge etew ne midsukayan dan te ebpemiyala su miduma ran en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nekeuma ran diyà te inged ne Kapirnawum ne guna su neuma en ke Hewii te Id-imeley rut te menge Hudiyanen ne mibpendiyan en si Hisus dut te valey ne ebpengedian te menge Hudiyanen te penduan dan ne mibpenurù. ");
INSERT INTO mbi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Guna su nerineg dut te menge etew se kebpenurù din ne neinuinu ran nevenar, su kenà iring dut te kebpenurù te menge etew ne ebpenurù te penduan te menge Hudiyanen su ruen gehem din ini se penurù din. ");
INSERT INTO mbi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ketà ne ruen meama ne midlusud te kevurunan dan ne midsuukan te vusew ne migkuleyì te, ");
INSERT INTO mbi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hisus ne riyà ebpuun te Nesarit, engkey se kememeniyà nu kayi te sikami ne vusew? Maa, edereetan key nikuna? Egkekilala ku sikuna su sikuna ke Berekat ne Midsuhù te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ne migkehiyan en ni Hisus ke vusew te, “Engked ka rà, ne awà ka keniyan te meama ayan!” ");
INSERT INTO mbi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Arà dà ne pinekerker en te mevaher dut te vusew ke meama ne pinekuleyì din te merahing, ne mid-ewaan din en ke meama. ");
INSERT INTO mbi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne rekelà se kinekegeyip dut te langun ne menge etew ketà ne mibpein-inseey ran te, “Engkey ve vuwa ini? Kema ke ini en ke behu ne penurù. Su utew rekelà se gehem din su ebpeawà te menge vusew ne ebpemineg dan kandin.” ");
INSERT INTO mbi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Arà dà iya ne nekeeneb en ke bentuhan dut te mid-ulaula ni Hisus diyà te lusud te langun ne inged te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Guna su mid-awà en si Hisus wey ke edumdumaan din ketà te valey ne ebpengedian te menge Hudiyanen te penduan dan ne diyà dan en medturedu te valey enni Simon ki Andres, ne miduma rema ensi Santiago ki Juan. ");
INSERT INTO mbi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Seretà din ketà ne mid-irehà ke enuhang ni Simon ne meritan su edetengen. Nekeuma rà si Hisus ne migkehiyan dan en sikandin mekeatag dut te ederaru. ");
INSERT INTO mbi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mid-uvey en si Hisus diyà te kandin, ne migeweran din en ke velad din, ne pineenew rin en. Arà dà ne neawà en ke rateng din, ne mid-ilutù en sikandin te ibpekaan kandan. ");
INSERT INTO mbi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Guna su midsanlep en ke endew ne mibpeneheewit en kayi te ki Hisus te menge etew ke langun ne ebpemekedaru, wey ke menge midsuukan te vusew. ");
INSERT INTO mbi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne langun te menge etew ketà te inged ne nevurun kayi te lama te valey ne midtumpaan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne merakel se ebpenderaru ne nengeulian ni Hisus, ne mibpenegseg din ke menge vusew ne midsuuk dut te menge etew. Ugaid ne warà din pekegkehiya ke menge vusew su nekilala ran en ma ke engkey sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Guna su egkepkepawà en, ne mid-enew en si Hisus ne mibpemenaug en ne mibpendiyà te endei se warà etew rin ne ketà sikandin mibpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ne mibpemengà en ni Simon wey ke menge ruma rin ke endei en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Guna su netuen dan en si Hisus ne migkahi ran en te, “Ebpemengaan ka te langun ne menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ugaid ne migkahi si Hisus kandan te, “Ebpependiyà kiyu pà te ruma ne inged kayi se ebpesabut kandan dema, su arà ke kinekepengkayi ku,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne mid-eneb-eneb en si Hisus dut te langun ne inged kayi te lusud te Geliliya se ebpesabut ketà te menge valey ne ebpengedian te menge Hudiyanen te penduan dan, ne mibpenegseg din ke menge vusew ne midsuuk te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Senge hewii ne ruen etew ne egkevuwaen ne muna pà te it-it ne mid-uvey ki Hisus. Mibpenimbuel en sikandin diyà te sineruwan ni Hisus se ebpemuyù te, “Embiya perem egkiyug ke rà, ne egkeulian nu ini se meredsik ne sakit ku,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ne ingkeyru ni Hisus sikandin ne midampen din en se egkahi te, “Uya, egkiyug a, meulii ka!” ");
INSERT INTO mbi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Arà dà se nekahi rin, ne neawà en ke sakit dut te meama su neulian en. ");
INSERT INTO mbi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ketà ne impeipanew en ni Hisus sikandin te mid-il-ilutan din te egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kenà nu ve imbe kegkehiya ini te misan endei en, ugaid ne riyà ka tilandeng te terebpelengesa ne ibpekita nu kandin te neulian ke en. Ne ivehey nu ve kandin ke ibpelengesa te Eleteala ne insuhù dengan ni Moises dut te menge etew ne neulian te sakit dan ne kevuwa apey metueni te langun ne menge etew te neulian ke en,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ugaid ne mid-awà dà arà se etew ne nasì din en impenudtul te misan engkey en ne etew ke ned-ulaula rin. Ne ketà dà puunan te kebpemenudtul din ne kenà en ebpekeliglihawang si Hisus diyà te ruma ne inged su egkevurunburun ke menge etew. Ketà be ne riyà dà med-ubpà sikandin te warà etew rin, ugaid ne mid-ebpet en kandin ke menge etew ne riyà ebpuun te ruma pà ne inged. ");
INSERT INTO mbi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nengepiraan be ketà ne mid-ulì en si Hisus diyà te inged ne Kapirnawum, ne nerineg en dut te menge etew te nekeulì en. ");
INSERT INTO mbi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ne ketà ne midasek se merakel ne etew su warà dan en meamin diyà te valey, misan diyà te edsempawan en. Ne gewii te ebpesabut si Hisus dut te Meupiya ne Tudtul kandan, ");
INSERT INTO mbi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ne ruen nekeuma ne epat ne etew ne edyayung te etew ne minatey ke tevì ne lawa rin. ");
INSERT INTO mbi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ugaid ne geina te merakel ne menge etew ne warà dan mekeuvey ki Hisus. Ketà be ne iyan dan mid-ulaula ne midlekatan dan ke atep ne renged ni Hisus, ne ketà ne midtuntun dan en ke ederaru kayi te ed-irehaan din diyà te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Guna su netuenan ni Hisus te rekelà ke sarig dan kandin, ne migkehiyan din en ke minatey se tevì ne lawa rin te, “Mama, nepesehad en ke menge salà nu.” ");
INSERT INTO mbi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ketà ne ruen dema ebpinpinuu ne menge etew ne ebpenurù te penduan, ne guna su nerineg dan ke migkahi ni Hisus ne iyan netahù te hinawa ran te, ");
INSERT INTO mbi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Meambe ke egkahi ini se etew te iring sikandin te ebpekepesehad te salà? Edsumpalit sikandin te Eleteala su warà etew ne ebpekepesehad te salà embiya kenà ke Eleteala rà!” ke hingginawa ran. ");
INSERT INTO mbi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Arà dà ne netuenan en ni Hisus ke netahù te itungan dan, ne migkahi en sikandin diyà te kandan te, “Meambe ke netahù te itungan niyu se iring keniyan? ");
INSERT INTO mbi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Endei rapit se melemu,” ke si Hisus, “te egkahi riyà te minatey se lawa rin te, ‘Ke menge salà nu ne nepesehad en’ etawa ve egkahi te, ‘Enew ke en ne luluna nu ke ikam nu ne ipanew ke en’? ");
INSERT INTO mbi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ugaid ne guntaani ne ibpekita ku keniyu te ruen gehem rut te Impeanak te Menusiyà te ebpesehad te salà kayi te ampew te dunya.” Ketà ne migkehiyan din ke etew ne minatey ke tevì ne lawa rin te, ");
INSERT INTO mbi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mama, enew ke en ne luluna nu ke ikam nu ne ulì ke en.” ");
INSERT INTO mbi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ne mid-enew en ke etew, ne arà dà ne midlulun din ke ikam din, ne mibpemehilanggilang en se ed-ipanew kayi te etuvangan dan langun. Guna su nekita rut te langun ne menge etew ketà, ne rekdekelà se kinekegeyip dan ne nereyù dan ke Eleteala se egkahi te, “Taman te taman ne warà tew pà mekita se iring kayi!” ");
INSERT INTO mbi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Neipus arà ne midlived en maa si Hisus diyà te beyvey te ranew te Geliliya. Ne ruen migkuludkulud ne menge etew ne mibpendiyà te kandin ne mibpenurù din en sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Guna su nekeipus sikandin se ebpenurù ne midlaus en sikandin se ed-ipanew, ne gewii te ked-ipanew rin ne nekita rin ke senge etew ne meama ne ebpevayad te buwis ne si Levi, ke anak ni Alfeo, ne ebpinuu riyà te upisinà din. Ne migkehiyan din en te, “Duma ka kediey.” Arà dà ne mid-itindeg si Levi ne miduma en kandin. ");
INSERT INTO mbi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ne senge hewii ne pinekaan si Hisus wey ke menge edumdumaan din diyà te baley ni Levi ne ruen merakel ne ebpevayad te buwis wey ke menge kenè en birang ne menge etew ne midtundug ki Hisus ne elin dan ki Hisus se migkaan ketà. ");
INSERT INTO mbi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne dutun te uvey te baley ne ruen menge Peresiyu ne ebpenurù te penduan ne nekita ran te egkaan si Hisus ne duma te menge etew ne ebpevayad te buwis wey ke menge kenè en birang ne menge etew. Ne netegtehaad ne mibpendiyà dan te menge edumdumaan ni Hisus ne mid-insà te, “Meambe ke edseveka sikandin se egkaan ketà te menge etew ne ebpevayad te buwis wey ke menge kenè en birang ne menge etew?” ");
INSERT INTO mbi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nerineg dà ni Hisus arà ne migkehiyan din en sikandan te sempità te, “Ke menge etew ne warà daru rin ne kenà dan ebpegungayà te terebawì, ugaid ne ke menge etew rà ne duen daru rin. Ne iring din ded be rema kayi ini se menge etew su kenà iyan ku kinepengkayi se iyan ku ebpeuveyen ne ke menge metidtu kun se ulaula ran, ugaid ne ke menge kenà en birang ne menge etew apey ran mekedsendit,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Senge hewii ne midlimpas te kegkaan ke menge edumdumaan ni Juan ke Ebpembunyag wey ke menge Peresiyu su edtumanen dan ke betasan dut te keep-epuan dan. Ne ruen menge etew ne mibpendiyà te ki Hisus ne migkahi te, “Edlimpas te kegkaan ke menge edumdumaan ni Juan ke Ebpembunyag wey ke menge edumdumaan dut te menge Peresiyu ne meambe ke kenà edlimpas te kegkaan ke menge edumdumaan nu?” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ne midtavak si Hisus te sempità, ke sikandin te, “Embiya ruen egkewingen, maa edlimpas ves maa te kegkaan ke menge etew ne mid-inggat te ini pà ke ibpengesawa te kandan? Kenà en iya! Ne iring din ded dema kayi te edumdumaan ku su taman te ini e pà te kandan ne kenà dan arà ed-ul-ulaan. ");
INSERT INTO mbi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ugaid ne ruen hewii ne egkeuma ne egkeawà ke ibpengesawa diyà te kandan, ne ketà dan pà edlimpas te kegkaan.” ");
INSERT INTO mbi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ne ketà maa ne insempità ni Hisus te kenà egkepakey ne ebpegembiten ke behu ne penurù din wey ke raan ne betasan te keep-epuan dan, ke sikandin te, “Kenà edait ne idapi nu ke behu ne saput ketà te neredit en ne velegkas, su embiya ebpedepiyen nu ne ketà te kebpìpii nu ne egkenseng ke vehu ne saput ne egkevindas ke redit en ne velegkas ne tuwas pà ke keluag te bisey rin. ");
INSERT INTO mbi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne iring din ded dema,” ke si Hisus, “ke behu pà ne tebà su kenà egkepakey ne riyà nu idtahù te raan en ne edtehuan ne mibeelan ne lundis. Su embiya arà se ed-ul-ulaan nu ne edsevu ke tebà ne ebetu ke lundis ne midtehuan, ne edturayas ke tebà ne egkereetan, ne egkereetan dema ke midtehuan ne lundis. Tembù be iyan din kemeyidan ne ke behu pà ne tebà ne riyà nu itahù te edtehuan ne behu pà ne mibeelan,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Senge hewii te Sepetu, ke Hewii ne Id-imeley, ne midtarà si Hisus wey ke menge edumdumaan din diyà te pareyanan. Ne arà se kebpetindalan dan ketà te pareyanan ne mibpengetu te tiugkayan ini se menge edumdumaan ni Hisus ne mibpengurib su idsungit dan. ");
INSERT INTO mbi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nekita rà ini dut te menge Paresiyu ne migkehiyan dan en si Hisus te, “Tengtengi nu ma ayan se menge edumdumaan nu su nekesurang en ayan se ed-ul-ulaan dan dut te Penduan tew ne egkahi te warà egelevek te Andew te Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ne migkehiyan ni Hisus te, “Maa, warà niyu mevasa ke impesurat te Eleteala mekeatag te mid-ulaula ni David, ke ratù tew rengan? Su ruen hewii ne mibpelahuy si David wey ke menge ruma rin dut te menge kunterà dan ne nengevitil dan. ");
INSERT INTO mbi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ketà ne hewii ne iyan pà mepurù dut te menge terebpelengesa ne si Abiyatar ne midlusud si David diyà te insivey ne Baley te Eleteala ne migkuwa rin ke egkeenen ne indenà diyà te Eleteala ne migkaan sikandin ne mibehayan din ke menge ruma rin. Ugaid ne kayi te Penduan tew ne kenà arà egkekaan te piya engkey ne etew su ke menge terebpelengesa rà te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne migkahi en maa si Hisus diyà te menge Paresiyu te, “Ini se Hewii te Id-imeley ne mibeelan te keupianan dut te menge etew te kebpekeimeley ran, ugaid ne warà beeli ke menge etew te keupianan dut te Hewii ne Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tembù be ke Impeanak te Menusiyà ne iyan ebayàbayà te egkahi te engkey se edait ne ed-ul-ulaan dut te Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ne ruen maa Hewii te Id-imeley ne midlived si Hisus diyà te valey ne ebpengedian te menge Hudiyanen te penduan dan, ne ruen ketà senge etew ne meama ne nekeyengkeng se seveka ne velad din. ");
INSERT INTO mbi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ruen dema ketà menge Peresiyu ne egkunterà ki Hisus ne ebpenipat nevenar ki Hisus ke embiya ebewian din ini se etew kayi te Hewii ne Id-imeley apey ruen id-isuhat dan kandin ne kevenar. ");
INSERT INTO mbi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ne migkehiyan ni Hisus ke etew ne nekeyengkeng se velad din te, “Mama, pengkayi ka te etuvangan.” ");
INSERT INTO mbi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne mid-insaan din en ke menge etew ne nevurun ketà te, “Engkey ma se nekahi te penduan tew ne idtuhut ne ed-ul-ulaan tew te Hewii ne Id-imeley? Maa, edtevangan tew ke menge ruma ta etawa ebpemekeiran tew sikandan? Maa, edsumpatan tew ke umur te menge ruma ta etawa ed-imetayan tew?” ke si Hisus. Ugaid ne warà den ma medtavak. ");
INSERT INTO mbi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ne neepes si Hisus ne insihid din ke mata rin dut te menge etew ugaid ne ingkeuru rin ded manen su netuenan din te meresen se ulu ran su warà kegkeyru ran dut te menge ruma ran. Ne migkehiyan din manen ke etew ne nekeyengkeng se velad din te, “Mama, ketenga nu ayan se velad nu.” Arà dà ne migketeng en dut te meama ke velad din, ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nekita rà dut te menge Peresiyu ne midlihawang dan en ketà te valey ne ebpengedian te menge Hudiyanen, ne mibpeing-inggumaey ran en dut te menge sakup ni Hirudis su ebpemengaen dan se ralan te kegkeimetayi ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Guna su mid-awà en si Hisus ketà ne diyan en maa mibpesinaru sikandin wey ke menge edumdumaan din te beyvey te Ranew te Geliliya. Ne midtundug kandin ke medmerakel ne menge etew ketà te lusud te inged ne Geliliya wey riyà ebpuun te lusud te inged ne Hudiya, ");
INSERT INTO mbi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ne ruen dema riyà ebpuun te inged ne Hirusalim, wey riyà ebpuun te lusud te inged ne Idumea, wey riyà ebpuun te inged ne ripag te wayig ne Hurdan, wey ke menge inged ne nekeuvey te menge inged ne Tiru wey Sidun. Mibpendiyà te ki Hisus ke merakel ne menge etew su nerineg dan ke tudtul mekeatag te ed-ul-ulaan din ne mekegeyip. ");
INSERT INTO mbi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ne geina te denda ke menge etew ne midsuhù ni Hisus ke edumdumaan din te ebpenehana te avang ne ed-unturan din su apey kenà melipit sikandin dut te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Su merakel se nengeulian din, ne langun dut te egkereruwan ne ebpesinsinumahey ran se ed-uvey ki Hisus su apey ran merampen en nikandin ne egkeulian. ");
INSERT INTO mbi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne embiya egkekita si Hisus dut te menge etew ne mibpenuukan te menge vusew ne midlumpeng dan en diyà te sineruwan din se ebensag te, “Sikuna ke Anak te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ugaid ne mibenduan ni Hisus ke menge vusew te kenà dan ebpeketuenan te menge etew ke engkey sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ketà ne midtekereg si Hisus diyà te buvungan ne midtawag din en ke menge meama ne egkiyuhan din ne nekeuma ran en. ");
INSERT INTO mbi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ne midtendù din en ke sepulù wey deruwa ne edumdumaan din ne ed-ingeranan te Apustulis ne migkehiyan din sikandan te, “Midtendù ku sikiyu ne ebpekiduma kediey,” ke sikandin, “ne edsuhuen ku sikiyu te ebpemesabut dut te Meupiya ne Tudtul, ");
INSERT INTO mbi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ne ebehayan kew te gehem te kebpekesegseg dut te menge vusew ne ebpenuuk te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ini ke menge ngaran dut te sepulù wey deruwa ne midtendù din: si Simon (ke mid-ingaranan din ki Pedro), ");
INSERT INTO mbi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago wey ke ari rin si Juan (ke mid-ingaranan ni Hisus te Buwanirgis ne iyan din meana ne “Menge etew ne iring te Ruhung”) ini se deruwa ne menge anak ni Sibidyu. ");
INSERT INTO mbi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ne elin dema si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago ke anak ni Alpiyu, si Tediyu, si Simon ke Patriat ne iyan din meana ne diralem se lengesa rin dut te inged din, ");
INSERT INTO mbi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","wey si Hudas Iskeriyuti ke ed-ulug ki Hisus te ked-imatey. ");
INSERT INTO mbi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Guna su netendù din en sikandan ne mid-ulì dan en. Ne ketà ne merakel en maa se menge etew ne nevurun ne kenà dan en ebpekeselet te kegkaan dan. ");
INSERT INTO mbi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nerineg dà ini dut te menge suled din, ne mibeyaan dan su ed-engayen dan sikandin su ruen migkahi te, “Nevuneg sikandin!” ");
INSERT INTO mbi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne ruen menge meyterù te penduan ne riyà ebpuun te inged ne Hirusalim ne migkahi te, “Midsuukan en si Hisus ini ni Belsibul!” Ne ruen ruma pà ne migkahi te, “Uya, ke egkeunuten te menge vusew se mibehey kandin te gehem te kebpekesegseg din dut te menge vusew ne edsuuk te menge etew,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Guna su nerineg ini ni Hisus ne impeuvey rin ke menge etew ne migkehiyan din te sempità te, “Kenà egkepakey ne edsegseg si Setanas ke egkeunuten te menge vusew te ruma rin ne vusew! ");
INSERT INTO mbi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Su upama ruen datù te senge inged ne ed-uney ebpevuneey ke menge sakup din ne egketunggad arà se inged din. ");
INSERT INTO mbi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne embiya ruen telteleanak ne ed-uney egkewaha, ne warà ebpengkusan din ke kenà egkevurahey. ");
INSERT INTO mbi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iring din ded be ketà ke midetuan ni Setanas ke egkeunuten te menge vusew, embiya ed-uney ebpevuneey ke sakup din ne kenà meuhet se kedatù din su egketunggad arà se edetuan din. ");
INSERT INTO mbi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ugaid ne netalew ku en si Setanas ke egkeunuten te menge vusew, tembù be ebpekesegseg a te menge sakup din, su warà etew ne ebpekelusud te valey te mevaher ne etew su ebpenakew te menge kearen din embiya kenà din ed-unaan pà te ebakù arà se mevaher ne etew. Ugaid ne embiya nevakù din en, ne arà pà ne ebpekekuwa sikandin dut te kearen din. ");
INSERT INTO mbi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Idtahù niyu imbe ini te hinawa,” ke si Hisus, “te egkepesahad te Eleteala ke langun ne menge salà te menge etew ne misan engkey en ne meraat ne edlelehan dan kandin. ");
INSERT INTO mbi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ugaid ke etew ne edlalag te meraatey mekeatag dut te Kedesenan ne Ebpetuntul te Menusiyà, ne kenà en vulug egkepesahad ke salà din su nekevaal sikandin te salà taman te taman.” ");
INSERT INTO mbi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Migkahi ni Hisus ini geina te ruen migkahi te ke gehem din ne riyà ebpuun te vusew ne midsuuk kandin.) ");
INSERT INTO mbi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nekeuma en ke iney ni Hisus wey ke menge ari rin ne meama, ne riyà dan dà te luwal meketaman ne mibpesuhuan den dà si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Su neterektek te merakel ne etew si Hisus, ne migkahi ran en kandin te, “Ke iney nu wey ke menge ari nu ne riyà te lihewangan ne ebpekibalak keykew.” ");
INSERT INTO mbi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Migkahi si Hisus te, “Duen pà ibpekita ku keniyu,” ke sikandin, “ne iring te iney ku wey menge suled ku.” ");
INSERT INTO mbi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne insihid din ke mata rin dut te menge etew ne nekelingut kandin, ne ke sikandin te, “Sikandin ini ke iney ku wey ke menge suled ku! ");
INSERT INTO mbi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Su misan engkey en se ebperumaruma te kiyug te Eleteala ne sikandan en imbe ke menge suled ku ne meama, ke menge etevey ku, wey ke iney ku,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Senge hewii maa ketà ne riyà si Hisus te veyvey te ranew se ebpenurù te menge etew. Ne geina te merakel ne menge etew se nevurun ketà, ne mid-untud sikandin diyà te avang te gebgevasan te ranew se ebpenurù. Ne riyà dà te beyvey te ranew ke menge etew ne ebpemineg kandin. ");
INSERT INTO mbi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ne merakel se impenurù din kandan ne impepevayà te sempità, ke sikandin te. ");
INSERT INTO mbi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Itaan niyu ve ke telinga niyu, su ruen etew ne mibpendiyà te pengengewiran din su edsawed te benì. ");
INSERT INTO mbi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ne ketà te kinesawed din ne ruen benì ne nengeulug diyà te kilid te ralan ne midtuktuk en te menge pepenuk. ");
INSERT INTO mbi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ruen ruma ne insawed din ne riyà nengeulug te kebetuwan ne mevavew se tanà din. Ne geina te mevavew ini se tanà din, ne mehaan dà se kinetuvù din. ");
INSERT INTO mbi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ugaid ne guna su mid-endawan en ne petuluy ne migkuley ke dawun din ne geina te warà meketuneb ke ralid din ne neebmas en. ");
INSERT INTO mbi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ne ruma pà ne riyà nengeulug te sepinitan ne guna su midtuvù en ini ne migkubmusan en dut te sepinit ne warà en mekevahas. ");
INSERT INTO mbi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ugaid ne ruen ruma pà ne riyà nengeulug te meupiya ne tanà, ne midreteb, ne meselinuvù se tuvù din, ne nekevahas te meupiya su ruen mibpengupiya nevenar se bahas din, ne ruen migkakey, ne ke ruma pà ne ruen ded neehani. ");
INSERT INTO mbi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Tembù be,” ke si Hisus, “itaan niyu ke telinga niyu kayi te migkahi ku ini.” ");
INSERT INTO mbi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Guna su mid-awà en ke menge etew ne nevurun ketà ne ruen menge etew ne nekerineg dut te impenurù din ne mid-uvey ran kandin abpeg ke sepulù wey deruwa ne edumdumaan din ne mibuyù dan kandin te ibpesabut kandan ke meana te sempità. ");
INSERT INTO mbi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne migkahi si Hisus te, “Sikiyu ne edurumaruma kediey, ne ebpesebuten en te Eleteala rut te in-eles dengan mekeatag te kedatù te Eleteala te menge etew, ugaid ke ruma ne menge etew ne ibpenurù kandan te ibpepevayà te menge sempità, ");
INSERT INTO mbi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","su apey ‘Misan edtengteng dan, ne kenà dan ebpekekita; ne misan ebpemineg dan, ne kenà dan ebpekesabut. Su embiya nesebutan dan, ne edlived dan ke hinawa ran diyà te Eleteala ne egkepesehad din sikandan.’” ");
INSERT INTO mbi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne migkahi si Hisus kandan te, “Maa warà niyu ves mesebuti ayan se sempità ku? Embiya warà niyu mesebuti ini, ne engkey embe se ralan te kebpekesabut niyu rut te ruma pà ne idsempità ku? ");
INSERT INTO mbi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Su iyan ku midsempitaan ketà te etew ne edsawed te benì ne ke etew ne ebpemenudtul dut te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ne ini se ralan ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala, ugaid ne midegdehawan ni Setanas ke datù te pekaid te ed-ahew ini nerineg dan su apey kenà dan mekeperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne ke kebetuwan ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala ne ingkehalew ran te ebpemineg ne mibperetiyaya ran. ");
INSERT INTO mbi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ugaid ne mehaan dà su warà mekedalid te hinawa ran. Ne embiya ebpekedtarà dan te kemerehenan sabap dut te kedtuman dan te Lalag te Eleteala ne nerineg dan, ne ed-engked dan su edlived dan diyà te andang ne ed-ul-ulaan dan. ");
INSERT INTO mbi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ne ke sepinitan ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala, ");
INSERT INTO mbi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ugaid ne gewii ran te ebpetindalan ne merakel se egkubmus dut te lalag ne nerineg dan iring te kemutuwan dan te ked-ubpà-ubpà, ne kegkelilingey ran dut te menge kearen dan, wey ke pegungayà te kebpatà te nanam, ne ketà ne kenà dan ebpekevehas. ");
INSERT INTO mbi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ugaid ne ke meupiya ne tanà ne neuluhan te benì ne arà ke menge etew ne nekerineg dut te Lalag te Eleteala, ne midtelimà dan, ne mibahas dan su ruen mibpengupiya nevenar se bahas din, ne ruen migkakey, ne ke ruma pà ne ruen ded neehani,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ne migkahi en maa si Hisus te sempità kandan te, “Warà etew ne edtemtem te sulù ne ebpelengkevan din etawa ibperalung din. Ugaid ne riyà din ibpeluukluuk te saag su apey egkerayahan ke langun. ");
INSERT INTO mbi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iring din ded dema,” ke si Hisus, “langun te netelevan guntaani ne ebpekepehawa red keuremà. Ne langun ne impegelesà ne egkepayahan ded. ");
INSERT INTO mbi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Itaan niyu ve ke telinga niyu kayi te migkahi ku ini,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne migkahi pà maa si Hisus te, “Uya, pemineha niyu ve imbe ini su apey niyu egkesebuti! Su endei taman se id-isuhat nu te ruma nu, ne engketà ded dema ke id-isuhat te Eleteala kenikew, ne ebpeseharan din pà. ");
INSERT INTO mbi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Su ke etew ne idtahù din te hinawa ke ibpesabut kandin te Eleteala, ne ed-umanan pà te Eleteala ini se kebpekesabut din. Ugaid ke etew ne kenà din idtahù te hinawa ke ibpesabut kandin te Eleteala, ne egkeawà arà se reisek ne nesebutan din.” ");
INSERT INTO mbi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ne migkahi en maa si Hisus te kebpenurù din te, “Ke kedatù te Eleteala rut te menge etew ne iring te etew ne midsawed te benì diyà te pengengewiran din. ");
INSERT INTO mbi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Neipus din dà te edsawed ne mid-ewaan din en, ne gewii rin te egelevek dut te ruma pà ne helevek din te uman gewii ne edtuvù en lavew ini se insawed din. Ugaid ne warà din mesebuti ke memenumenu se kebpeketuvù din. ");
INSERT INTO mbi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iyan ebpetuvù te benì ne ke tanà su apey mekevehas. Iyan ed-una ke lawa, ne edtundug ne ebpenlesut, ne arà pà ke tiugkayan. ");
INSERT INTO mbi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne embiya ve egkelutuan en ke bahas din ne ed-eheniyen dut te kemuney su timpu en te kebpengehani,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne migkahi pà maa si Hisus te, “Engkey ma se edait ne ebpeiringan ta te kedatù te Eleteala dut te menge etew? Engkey ma se meupiya ne sempità ta te kedseyseya ketà? ");
INSERT INTO mbi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Su ini se kedtuvù te kedatù te Eleteala te menge etew ne ebpekeiring dut te merimet nevenar ne lahas ne ed-ingeranan te Mustasa. Ini ke pinekemerimet ne lahas kayi te ampew te dunya. ");
INSERT INTO mbi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ugaid ne embiya ibpemula ini ne ebpeketuvù ne egkevaluy ne iyan dekelà dut te langun ne pinemula. Ne edsubpang te derekelà, ne rutun ebpenesalag ke menge pepenuk,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mibpesabut si Hisus te Lalag te Eleteala diyà te menge etew te impepevayà din te sempità iring kayi, te endei taman se netuenan din ne egkesebutan dan. ");
INSERT INTO mbi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Warà sikandin mibpenurù kandan ke kenà ibpepevayà te menge sempità. Ugaid ne embiya iyan din dà dumà ke menge edumdumaan din, ne impesabut din kandan ke langun ne meana rin. ");
INSERT INTO mbi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Guna su merukilem en te arà ne hewii ne migkehiyan ni Hisus ke menge edumdumaan din te, “Kuwa kew en su ed-apet kiyu riyà te ripag,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Arà dà ne mid-ewaan dan en ke merakel ne menge etew, ne mid-untud dan en ketà te avang ne mibpinuuwan ni Hisus ne mibpuridtas dan en ki Hisus. Ne ruen duma ne avang ne eduma rema kandan. ");
INSERT INTO mbi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Guna su ed-avang-avang dan en, ne midtekewtekew en se mebmevandes ne keramag ne egkelikuvungan dan en te menge baleg ne egkesimbuhan en te wayig ke avang dan ne deisek samà ne egkekahem dan en. ");
INSERT INTO mbi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne si Hisus ne riyà te ulinan su nekelipereng diyà te ulunan din. Ne mibpemukew en dut te menge edumdumaan din se egkahi te, “Meyterù, egkeherà ki en! Maa, warà te hinawa nu se kegkeherà tew?” ");
INSERT INTO mbi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nepukew si Hisus ne mid-enew en ne pineengked din en ke keramag wey baleg ne migkahi te, “Engked kew!” Arà dà ne mid-eneng-eneng ke keramag, ne midlengen en ke ranew. ");
INSERT INTO mbi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne migkehiyan din en ke menge edumdumaan din te, “Meambe ke nengeandek-andek kew? Maa, kenà kew edsarig kediey?” ");
INSERT INTO mbi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ne neandek-andek dan nevenar ne mibpein-inseey ran te, “Engkey ini ne etew? Su misan ke keramag wey menge baleg ne ebperumaruma rut te lalag din,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ne nekerunggù en ensi Hisus diyà te ripag te ranew te Geliliya riyà te sakup te inged te menge Gerisiyanu. ");
INSERT INTO mbi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Guna su mibpemenaug en si Hisus ketà te avang ne midsinuhung en sikandin te senge etew ne riyà ebpuun te menge surung ne penlelevengan te minatey. ");
INSERT INTO mbi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Su ini se etew ne midsuukan te vusew, tembù be diyan en mid-ubpà sikandin te menge surung ne penlelevengan te minatey. Ne kenà en egkeehenan sikandin misan pà egkedinaan. ");
INSERT INTO mbi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ne kenà kepipira rà bekua ke paa rin wey ke velad din, ugaid ne ebpengevidtew rin ded ke kedina ne ebpengetamped din ke putew ne impatung te paa rin. Warà etew ne ebpekeehen kandin su mevaher. ");
INSERT INTO mbi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Merukilem meandew ne edlauglaug sikandin diyà te menge surung ne penlelevengan te minatey wey riyà te menge buvungan se ebpulung ebpengulayì, ne ebpemelian din pà ke lawa rin te menge vatu. ");
INSERT INTO mbi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Guna su nesandeng din si Hisus ne mibpelelahuy rin en te edsinuhung, ne midlumpeng en sikandin diyà te sineruwan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ne mibensag en sikandin se egkahi te, “Sikuna ini si Hisus ke Anak te Eleteala ne warà repeng din. Engkey ma se kememeniyà nu kediey? Isapà nu te etuvangan te Eleteala te kenà a nu pemekeiri,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ini se mibuyù din geina te migkehiyan en ni Hisus sikandin te, “Sikuna ini se vusew, ewai nu en ayan se etew!”) ");
INSERT INTO mbi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ketà ne mid-insaan ni Hisus ke meama te, “Engkey ma se ngaran nu?” Ne midtavak ke vusew te, “Iyan ku ngaran ne si Selasà su medmerakel dey,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne mibpemuyù te mevaher ki Hisus te kenà din ebpepeewaan sikandan ketà te inged. ");
INSERT INTO mbi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne ruen ketà te uvey ran medmerakel ne bavuy ne ebpemenumal diyà te kelendihan. ");
INSERT INTO mbi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ne mibpemuyù en ke menge vusew ki Hisus se egkahi te, “Ibpependiyà key nu te menge bavuy arà su apey key ketà mekeawuk te kandan.” ");
INSERT INTO mbi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne midtuhutan en ni Hisus sikandan. Arà dà ne mid-awà en ke menge vusew rut te meama ne riyan dan en mibpengasuk te menge bavuy. Ne mibpemelelahuy en ke menge bavuy se ed-umpak diyà te dempilas ne nengelened dan en diyà te ranew su ruen en buwa menge deruwa ne ngivu se kerakel dan. ");
INSERT INTO mbi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Guna su nekita ini rut te menge etew ne edtuganur ketà te menge bavuy ne mibpemelelahuy ran en su impemenudtul dan ini diyà te inged dan wey ke nekeerivey ne pengengewiran. Nerineg ini rut te menge etew, ne mibayaan dan en su midsusi ran. ");
INSERT INTO mbi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nekeuma ran ketà te ki Hisus ne nekita ran en te ebpinuu ke meama ne midsuukan te medmerakel ne menge vusew pehaney, ne duen en belegkas din ne nekeulit en ke itungan din. Ketà ne nengeandek dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne ini se menge etew ne nekekita rut te mid-ulaula ni Hisus ne impenudtul dan en dut te ruma pà ne etew ke kegkeulii rut te meama ne midsuukan te menge vusew wey ke ned-ulaula rema rut te menge bavuy. ");
INSERT INTO mbi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne mibpemuyù dan ki Hisus te menu med-awà sikandin ketà te inged dan. ");
INSERT INTO mbi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne midlived en ensi Hisus diyà te avang dan, ne guna su ed-untud en sikandin te avang ne migkahi en ini se meama ne neulian en te, “Egkiyug a ne ebpekiduma kenikew,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ugaid ne warà megkiyug si Hisus te ebpekeruma sikandin ne iyan din migkahi se, “Ulì ke en diyà te keniyu ne ipenudtul nu ini se meupiya ne mid-ulaula te Kerenan kenikew wey ke kinekeyru rin kenikew.” ");
INSERT INTO mbi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Arà dà ne mid-ulì en ini se meama ne mibpemenudtul en diyà te langun ne menge inged diyà te lusud te inged ne Dikapulis ini se meupiya ne mid-ulaula ni Hisus kandin. Ne langun ne menge etew ne nekerineg kandin ne nengegeyip dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Guna su mid-apet en maa si Hisus diyà te ranew ne midunggù dan ne merakel se menge etew ne nengevurun ne midlingut kandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Duen ketà meama ne ed-ingaranan ki Jairo, su seveka sikandin ne egkeunutan te baley ne ebpengedian te menge Hudiyanen te penduan dan. Guna su nekita rin si Hisus ne midlumpeng en diyà te etuvangan din, ");
INSERT INTO mbi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne midsebenar mibpemuyù en sikandin se egkahi te, “Ruen deisek ne anak ku ne meritan ne edaru ne edtiviltivil te kepatey,” ke sikandin, “kuwa ki en be su apey nu mesamsam sikandin ne egkeulian.” ");
INSERT INTO mbi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ne miduma en si Hisus kandin te ed-ulì. Ne mid-eguyut en kandan ke merakel ne menge etew, ne ketà ne egkelipitlipit en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne ruen meritan ketà dema ne nerasey nevenar su nekedsepulù en wey deruwa ne rahun se kebpemundasa rin te lengesa ne kenà egkeengked. ");
INSERT INTO mbi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Misan mibpevewian din en te merakel ne terevawì ne warà dan megaga. Neamin din en ke kureta rin su apey egkeulii, ugaid ne lemban en ne ed-iseg. ");
INSERT INTO mbi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nerineg din ke meupiya ne ulaula ni Hisus, ne mibpenelektelek en sikandin diyà te uriyan din. ");
INSERT INTO mbi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Su kehingginawa rin te, “Misan egkeamì ku rà ke velegkas din, ne egkeulian en ini se sakit ku,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Guna su neamì din en ke velegkas ni Hisus ne netibpek en ke kebpemundasa rin, ne netuenan din te warà en ke sakit din. ");
INSERT INTO mbi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Arà dà ne neheram ni Hisus te ruen gehem te kebpekeulì ne midlihawang kandin, ne mid-itindeg sikandin se ebpenlangulangu. “Engkey ma se mid-amì te velegkas ku?” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Migkahi ke menge edumdumaan din te, “Ey, netuenan nu en se merakel ne menge etew ne ebpekelipit kenikew, ne meambe ke ed-insà ka ke engkey se mid-amì te velegkas nu?” ");
INSERT INTO mbi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ugaid ne mibpenlangulangu pà manen si Hisus ke entei arà se mid-amì dut te velegkas din. ");
INSERT INTO mbi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne ini se meritan ne netau te ned-ulaula rin ne mid-uvey en ki Hisus se egkerkeren te kinekeandek din. Ne midlumpeng en diyà te sineruwan ni Hisus ne impenudtul din en langun ke ned-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne migkehiyan en ni Hisus sikandin te, “Bayi, neulian ke en su sabap dut te kinesarig nu kediey. Ulì ke en be ne barasbaras ka su neulian ke en dut te keresayan nu,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ne gewii te ebpekidlalag pà si Hisus dut te meritan ne ruen en nekeuma ne ibpetundug ki Jairo se egkahi te, “Ke anak nu ne nekerudtanà en. Kenà ta en ebengenen si Hisus,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ugaid ne warà impememantag ni Hisus ke nerineg din ne lalag dan inemulà se iyan din migkahi diyà te ki Jairo te, “Kenà ka egewhewana kayi te anak nu, ugaid ne sarig ke rà kediey.” ");
INSERT INTO mbi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Arà dà ne iyan din dà pineruma kandan ki Jairo ne si Pedro, wey ke teleari si Santiago ki Juan. ");
INSERT INTO mbi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Guna su nekeuma ran diyà te valey ni Jairo ne nekita ni Hisus se egkehisaweg ke menge etew, ne nerineg din en se ebpemenderawit. ");
INSERT INTO mbi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Guna su midlusud en si Hisus ketà te valey ne migkehiyan din en sikandan te, “Meambe ini se egkehisaweg kew? Ne meambe ke ebpemenderawit kew? Warà minatey ayan se vatà su nekelipereng dà.” ");
INSERT INTO mbi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nerineg den dà ke migkahi ni Hisus ne mid-engitan den dà sikandin. Arà dà ne impeawà dan en ni Hisus diyà te valey, ne midtawag din en ke amey wey iney rut te batà wey ke tetelu ne edumdumaan din ne midlusud dan en diyà te mibpereyasan dut te vatà. ");
INSERT INTO mbi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Guna su nekelusud dan ketà ne migeweran ni Hisus ke velad din ne migkahi te, “Talita kumi,” ne iyan din meana se, “Payi, enew ke en.” ");
INSERT INTO mbi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Arà dà ne mid-enew en ke vatà ne mid-ipanew en. Ini se vatà ne edraharaha en su sepulù wey deruwa se rahun din. Guna su nekita ini rut te menge etew ne nengegeyip dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ugaid ne mibenduan dan ni Hisus te kenà ibpepenudtul ini se ned-ulaula te misan entei en. Ne migkahi rema sikandin te pekeena ran ke vatà. ");
INSERT INTO mbi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mid-awà en si Hisus wey ke edumdumaan din ketà te arà ne inged, ne mid-ulì en diyà te inged din ne Nesarit. ");
INSERT INTO mbi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Guna su neuma en ke Hewii te Id-imeley, ne mibpendiyan en si Hisus te baley ne ebpengedian te menge Hudiyanen te penduan dan se ebpenurù, ne merakel se menge etew ne nevurun ketà. Guna su nerineg dan se kebpenurù din ne neinuinu ran nevenar se egkahi te, “Endei rin be buwa mehuruwi ini?” ke sikandan. “Engkey ini se ketau rin ne nekuwa rin? Ne ebmenuwen din te ebaal ini se menge mekegeyip? ");
INSERT INTO mbi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Maa, kenà uvag ayan ke pandey, ne anak ni Maria, ne kakey en ni Santiago, ki Jose, ki Hudas wey ki Simon? Maa, kenà be ke menge etevey rin ne ini red dema med-ubpà?” ke sikandan. Ne ketà ne mid-engkenà dan kandin. ");
INSERT INTO mbi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ne migkahi si Hisus kandan te, “Ke etew ne ebpelembas te Lalag te Eleteala ne egkeedatan te piya endei en sikandin egketahù, liyu rà dut te muney ne inged din wey ke kereremigey rin.” ");
INSERT INTO mbi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tembù be warà mekegeyip ne ingkepekita ni Hisus ketà te inged din. Ne merelag dà se mibpendampen din ne ebpenderaru ne neulian. ");
INSERT INTO mbi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne ingkeinuinu nevenar ni Hisus su warà mebperetiyaya ke menge etew kandin. Ne mid-ipanew rin ke langun ne nekeerivey ne menge inged diyà te lusud te inged ne Nesarit su ebpenurù sikandin dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Miburun ni Hisus ke sepulù wey deruwa ne edumdumaan din ne impeipanew rin sikandan te igihiruwa. Ne mibehayan din te gehem te kebpenegseg te menge vusew ne ebpenuuk dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne intelaan din kandan te, “Kayi te ked-ipanew niyu ne iyan niyu rà peneheewita ne ke tuked niyu, kenà kew ewit te lutù, kenà kew ewit te kemuyut etawa kureta. ");
INSERT INTO mbi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ne tetelumpà kew, ugaid ne kenà kew ewit te belegkas ne idsambì niyu.” ");
INSERT INTO mbi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Intelaan din kandan dema te, “Embiya ebpekeuma kew riyà te inged ne riyà kew rateng te baley ne ruen ebpepemenayik keniyu, ne ketà kew rà rateng taman te ked-awà niyu ketà te inged. ");
INSERT INTO mbi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ugaid ne embiya ebpekeuma kew te inged ne warà edtelimà keniyu etawa kenà dan ebpemineg dut te ibpesabut niyu, ne levundus kew ne pendegdaha niyu ke lipupuk diyà te paa niyu gewii te ed-awà kew ketà te inged dan. Su tuus ini te baag kandan te kenè en be kilid keniyu ketà te hewii ne kedtimbang te Eleteala kandan.” ");
INSERT INTO mbi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Arà dà ne mid-ipanew ran en se ebpemesabut diyà te menge etew se med-engked dan en te meraat ne menge ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ne mibpenegseg dan ke menge vusew ne mibpenuuk te menge etew, ne midsepuwan dan te lana ke menge ebpenderaru ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nekeeneb en ini se tudtul mekeatag te ed-ul-ulaan ni Hisus taman te nekeuma en diyà te ki Hirudis, ke egkeunutan kayi te inged ne Geliliya, su nevantug en si Hisus diyà te langun ne inged ketà. Ruen menge etew ne migkahi te, “Neuyag ded maa si Juan ke Ebpembunyag, tembù be ruen gehem din te kebpekevaal din te menge mekegeyip.” ");
INSERT INTO mbi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ruen duma ne migkahi te, “Si Elias ded ini, ke mibpelambas te Lalag te Eleteala rengan.” Ruen duma pà ne migkahi te, “Sikandin ini ke ebpelambas te Lalag te Eleteala iring te senge etew rut te menge mibpelembas te Lalag te Eleteala rengan.” ");
INSERT INTO mbi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Guna su nerineg ni Hirudis ini se lalag dan ne iyan din migkahi se, “Ini red si Juan ke Ebpembunyag. Impepungel ku en ke ulu rin, ugaid ne neuyag ded sikandin.” ");
INSERT INTO mbi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ini se nekahi ni Hirudis su sikandin en iya ke mibpeimatey ki Juan, su sikandin pà ke mibpesigkem, ne mibpevakù ne mibpevilanggù kandin. Iyan din kineul-ulaa kayi su mid-esawa rin si Hirudiyas ke ipag din misan si Hirudiyas ne esawa rut te tuney ne suled din ne si Felipe. ");
INSERT INTO mbi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ne uman dà ebpengegkehiyi ni Juan si Hirudis te, “Kenà meupiya ne ed-esawaan nu ke ipag nu su esawa en te tuney ne suled nu!” ");
INSERT INTO mbi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Arà be ke ingkeepes ni Hirudiyas ki Juan, ne ebpeimetayan din perem, ugaid ne warà din med-ulaula ini su warà megkiyug si Hirudis. ");
INSERT INTO mbi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Su neandek si Hirudis ki Juan su netuenan din ne metidtu sikandin ne iyan ebpelupandù kandin ne Eleteala. Tembù be kenà din ebpeimetayan si Juan. Ne ingkesuati rin te ebpemineg ke penurù ni Juan misan ebpekevehey te kemutuwan te hinawa rin. ");
INSERT INTO mbi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ugaid ne guna su neuma en ke hewii te kineanaka ki Hirudis ne ketà metuen ni Hirudiyas se ralan te kegkeimetayi ki Juan. Su mibaal si Hirudis te kevurunan dut te langun ne menge mepurù ne egkeunutan, wey ke menge mepurù dut te sundaru rin, wey ke menge etew ne egkamal kayi te lusud te inged dan ne Geliliya. ");
INSERT INTO mbi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ketà te kevurunan ne pinesayew ke anak ni Hirudiyas ne raha, ne ingkesuatsuat ni Hirudis wey ke menge etew ne impetelavuk din. Tembù be migkahi si Hirudis dut te raha te, “Engkey ma se egkiyuhan nu? Su misan engkey en ne egkekuwa nu, ne ibehey ku keykew.” ");
INSERT INTO mbi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne impasad din te mevaher te, “Misan pà engkey se ebpentunen nu ne ibehey ku keykew, misan egketengà pà ke langun ne kearen ku.” ");
INSERT INTO mbi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Arà dà ne midlihawang en ke raha su ebpendiyà te iney rin ne mid-insà te, “Engkey se ebuyuen ku?” Ne midtavak ke iney rin te, “Iyan nu buyua ke ulu ni Juan ke Ebpemunyag.” ");
INSERT INTO mbi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ne midahewrahew en midlived ke raha riyà te egkeunutan ne si Hirudis ne migkehiyan din en te, “Iyan ku ebuyuen te guntaani ne ivehey nu kediey ke ulu ni Juan ke Ebpembunyag ne edsenaren te pelatu.” ");
INSERT INTO mbi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nerineg dà ni Hirudis ne nekebmutu nevenar sikandin, ugaid ne kenà din arà egkeparew su ingkepasad din en diyà te etuvangan te langun ne pinetelavuk din. ");
INSERT INTO mbi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ketà be ne midsuhù din en se sundaru rin te ibpekuwa ke ulu ni Juan, ne mibpendiyà en ke sundaru te bilengguan ne mibpungelan din en si Juan. ");
INSERT INTO mbi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ne intahù din en te pelatu ke ulu ni Juan ne mibpeneheewit din en ne imbehey rin diyà te raha, ne imbehey en dema dut te raha diyà te iney rin. ");
INSERT INTO mbi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Guna su nerineg ini dut te menge edumdumaan ni Juan, ne mibayaan dan diyà te bilengguan ne migkuwa ran ke lawa ni Juan ne inleveng dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Guna su mibpengulì ke menge edumdumaan ni Hisus kayi te kandin ne mibpenudtul dan kandin ke langun ne mid-ulaula ran wey ke impemenurù dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ketà ne misan ke kegkaan dan ne kenà dan ebpekeselet su ebpemekedsuvar se merakel ne menge etew ne ebpekeuma kayi te kandan. Tembù be migkehiyan ni Hisus ke edumdumaan din te, “Kuwa kew en su ebpendiyà kiyu pà te endei se warà etew rin su apey kew ebpekeimeley pà.” ");
INSERT INTO mbi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ketà be ne mid-erà dan en te avang ne mid-avang-avang dan en se ebpependiyà te endei se warà etew rin. ");
INSERT INTO mbi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ugaid ne guna su ed-ipanew ran en ne merakel ded ne etew se nekekita kandan ne nekilala ran. Ketà be ne mibpemelelahuy ke merakel ne menge etew ne ebpetiuna en ketà te inged ne ebpesineruwan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Guna su nekerunggù en ensi Hisus ne iyan dan en nekita se merakel ne menge etew ne nevurun, ne neyruwan nevenar ni Hisus sikandan su iyan dan neiringan ne menge bilibili ne warà tumetuganur. Ketà be ne merakel se impenurù din kandan. ");
INSERT INTO mbi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Guna su meapun en nevenar ne mid-uvey en kandin ke menge edumdumaan din se egkahi te, “Meapun en ini ne warà dè be menge etew kayi te inged ini. ");
INSERT INTO mbi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iyan tumù ne ibpeipanew nu en ini se merakel ne etew su apey ran ebpekependiyà te endei se ruen menge valey rin ne ebpekepemasa ran te egkekaan dan.” ");
INSERT INTO mbi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ugaid ne migkehiyan dan ni Hisus te, “Sikiyu se ebpekaan kandan.” Ne migkahi ran te, “Maa, sikami pè be se ebpepemasaan nu te ibpekaan kandan? Misan buwa duen kureta tew ne ed-elehà te deruwa nehatus ne denariyu ne ibpemasa te egkekaan, ne kurang pà.” ");
INSERT INTO mbi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ne migkahi en si Hisus te, “Engkey ma taman se kerakel te lutù tew? Intengi niyu kun.” Guna su mid-intengan dan ne migkahi ran en te, “Ruen lelima ne timan se pan wey deruwa ne timan se serà.” ");
INSERT INTO mbi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nerineg din dà ne migkehiyan en ni Hisus ke sepulù wey deruwa ne edumdumaan din te, “Pemepinuuwa niyu sikandan te idsengepuntuk keniyan te gumegebà.” ");
INSERT INTO mbi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Arà dà ne mibpepinuu ran en te igihilima nepulù etawa ibmehatus ne etew te idsenge puntuk. ");
INSERT INTO mbi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ne migkuwa ni Hisus ke lelima ne timan ne pan wey ke deruwa ne timan ne serà, ne midlingakà sikandin diyà te langit ne impeselamat din te Eleteala. Ne mibpenevìtevì din en ke pan ne imbehey rin en dut te menge edumdumaan din su ibpetukid dut te merakel ne etew. Ne iring din ded dema ke serà, mibpenevìtevì din ne impetukid din dut te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Migkaan dan langun ne nengevulung dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Guna su nekeipus dan en se egkaan ne mibpunpun dut te sepulù wey deruwa ne edumdumaan din ke nengesamà, ne iyan din nepunpunan ne sepulù wey deruwa ne binevey ne nengepenù. ");
INSERT INTO mbi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ne ke menge etew ne migkaan ketà ne lelima nengivu ke meama, liyu pà ke menge meritan batà. ");
INSERT INTO mbi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nekeipus dan dà ketà, ne impeuntud en ni Hisus te avang ke menge edumdumaan din su ibpeuna rin en sikandan te ed-apet te ranew riyà te inged ne Bitsaida, su ibpepeulì din pà ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Guna su impeipanew rin en ke menge etew ne midtekereg en sikandin te buvungan su ebpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Guna su egkesagkup en ne riyan en ke edumdumaan ni Hisus te kalud te ranew se ed-avang-avang, ne kayi pà te buvungan si Hisus se ebpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne nesandeng ni Hisus se egkepesangan ke menge edumdumaan din te ebpemura su egkesurang dan ke mevandes ne keramag. Guna su egkepkepawà en ne midtelukun en si Hisus kandan se ed-ip-ipanew riyà te rivavew te wayig, ne iring te edsahad dà kandan. ");
INSERT INTO mbi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ne guna su nekita sikandin dut te menge edumdumaan din se riyà ed-ip-ipanew te rivavew te wayig ne kunaan dan ke angkal sikandin, ne migkuleyì dan te kegkeandek dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Su langun dan ne nekekita kandin ne nengeandek dan nevenar. Ketà ne migkahi si Hisus kandan te, “Pedtihel kew te hinawa niyu, su siaken ini! Kenà kew meandek!” ");
INSERT INTO mbi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Arà dà ne mid-erà en si Hisus te avang dan ne netekew en mid-engked ke keramag. Ketà ne nengeinuinu nevenar ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Su misan nekita ran en ke mekegeyip ne mid-ulaula ni Hisus te kinepekaan din te merakel ne etew, ne warà den pà mesebuti ke benar ne meana rut te nekita ran, su warà metegkad dut te itungan dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Guna su mid-apet dan te ranew ne iyan dan nerungguan ne inged ne Hiniserit, ne ketà ne migaun dan en ne in-iket en ke avang dan. ");
INSERT INTO mbi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Guna su nekehaun dan en ne petuluy ne nekilala dut te menge etew si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Arà dà ne mibpelelahuy ran en se ebpesabut dut te menge etew ne ebpenderaru riyà te menge inged ne nekeerivey. Ne misan endei ran egkerineg se egketehuan ni Hisus ne edyeyungen en ke menge ebpenderaru su ebpeneheewiten dan diyà te kandin. ");
INSERT INTO mbi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne misan endei ebpesinaru si Hisus te menge pengengewiran etawa riyà te lihewangan sikandin, ne edyeyungen dan maa ke menge ebpenderaru riyà te kandin. Su ebpeneheewiten dan diyà te menge pedian su ebpemuyuen dan ki Hisus te menu mà ke mekeamì ke ebpenderaru misan dut te velegkas din dà, ne ketà ne langun ne nekeamì ne neulian. ");
INSERT INTO mbi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Senge hewii ne ruen menge Peresiyu wey menge meyterù te penduan ne riyà ebpuun te Hirusalim ne mibpengkayi te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nekita ran te ruen edumdumaan ni Hisus ne nekerimpas dut te betasan ne edtenuran dut te menge Peresiyu su migkaan dan ne warà dan dumai ke edtenuran ne kebpenlùlù te menge belad dan. ");
INSERT INTO mbi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Su ke menge Peresiyu wey ruma pà ne menge Hudiyanen ne kenà dan ebpekekaan embiya kenà iyan dan ibpeuna ke kedtumana te edtenuran ne betasan te kedlùlù te velad ne impenurù dut te keep-epuan dan. ");
INSERT INTO mbi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Misan ed-ulì dan ke riyà ebpuun te pedian ne kenà dan ebpekekaan embiya kenà dan ed-unaan te edtuman ke edtenuran ne betasan te kedlùlù. Ne ruen pà ruma ne betasan ne edtumanen dan iring te edtenuran ne kedlùlù te menge sangkap te egkaan, menge kelalew, menge halang ne kendidu, wey menge ed-irehaan. ");
INSERT INTO mbi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ketà be ne mid-insaan dut te menge Peresiyu wey ke menge meyterù te penduan si Hisus te, “Meambe ke kenà edtuman ini se menge edumdumaan nu rut te impenurù ne betasan dut te keep-epuan tew? Su matag dan en migkaan ne warà dan tumana ke edtenuran te kedlùlù!” ");
INSERT INTO mbi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ne midtavak si Hisus kandan te, “Benar iya ke lalag mekeatag keniyu ne impesurat te Eleteala ki Isaias ne mibpelambas te Lalag te Eleteala rengan. Su sikiyu ne uvag en kun ne ebperetiyaya iring dut te insurat din ne egkahi te, ‘Ini se menge etew, ke se Eleteala, ne kayi rà te bivig dan se ked-arap dan kediey, ugaid ne ke hinawa ran ne medmeriyù kediey. ");
INSERT INTO mbi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Warà ded be lalew rin se kebpengarap dan kediey, su ke impenurù dan ne mibèbeelan dà te etew, ugaid ne iyan dan migkahi ne kayi ini ebpuun te penduan ku,’ ” ke se impesurat ki Isaias. ");
INSERT INTO mbi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ne iring din ded dema te sikiyu,” ke si Hisus, “su mid-lekaan niyu ke penduan te Eleteala, ne iyan niyu egeweran ke betasan ne bineelan dà te menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ne migkahi pà maa si Hisus te, “Metau kew nevenar te ralan te ked-engked niyu te penduan te Eleteala su apey niyu metuman ke keniyu rà dè duen ne betasan. ");
INSERT INTO mbi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Su,” ke si Hisus, “ruen penduan te Eleteala ne impesurat din ki Moises dengan ne egkahi te, ‘Edati niyu ke amey niyu wey ke iney niyu.’ Ne ingkahi rema te, ‘Misan engkey en ne etew ne edlalag te meraatey riyà te menge lukes din ne ebpeimetayan,’ ke se impesurat ki Moises. ");
INSERT INTO mbi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ugaid ne sikiyu,” ke si Hisus, “ne iyan niyu ibpenurù ne embiya ruen etew ne ruen igketavang din dut te menge lukes din ne egkepakey ne egkehiyen din se ‘Kurban ini’ ne iyan din meana ne ‘Eleteala se kemuney kayi’. ");
INSERT INTO mbi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne ketà,” ke si Hisus, “ne kenà en sikandin ebpeketavang rut te amey rin wey iney rin. ");
INSERT INTO mbi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kayi ve te penurù niyu ini ne mid-iniyuhan niyu ke Lalag te Eleteala su iyan niyu ibpeiseg ke betasan ne intelau dut te keep-epuan niyu. Ne ruen merakel pà ne iring kayi ne ed-ul-ulaan niyu.” ");
INSERT INTO mbi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Arà dà ne pineuvey en ni Hisus ke merakel ne menge etew se egkahi te, “Pemineha niyu ve ini,” ke sikandin, “se edlelehan ku su apey niyu egkesebuti. ");
INSERT INTO mbi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kenà iyan ebpekeredsik te etew ini se egkeenen ne ebpekeawuk te bèbà din, ugaid ne iyan ebpekeredsik te etew ini se netahù te hinawa rin ne ebpekelihawang kayi te bèbà din.  ");
INSERT INTO mbi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Itaan niyu ve ke telinga niyu kayi te migkahi ku ini!” ");
INSERT INTO mbi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nekeipus te edlalag si Hisus ne mid-ewaan din ke merakel ne etew ne midlusud en diyà te valey, ne mid-insaan en dut te menge edumdumaan din ke engkey se meana ketà te sempità din. ");
INSERT INTO mbi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne migkahi si Hisus te, “Iring kew rà dut te ruma ne etew ne mevavew se kebpekesabut din. Meambe warà niyu ves mesebuti te kenà iyan ebpekeredsik te etew ini se egkeenen ne ebpekeawuk te bèbà din? ");
INSERT INTO mbi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Su kenà ini edlusud te hinawa rin, ugaid ne kayi ebpevayà te hetek din ne edlihawang en diyà te kandin.” (Ne ini se lalag ni Hisus ne iyan din ibpesabut ne egkepakey ne egkeenen se misan engkey en ne egkekaan.) ");
INSERT INTO mbi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne impelevundus ni Hisus se kegkahi rin te, “Iyan ebpekeredsik te etew ne ini se netahù te hinawa rin ne ebpekelihawang te bèbà din. ");
INSERT INTO mbi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Su ini se kayi ebpuun te lusud te diralem te etew, ini se neketahù te hinawa rin, ke ebpuunan te meraat ne itungan ne ebpeneheewit kandin te meraat ne ed-ul-ulaan iring te ed-ulaula te meredsik, kebpenakew, ked-imatey, ");
INSERT INTO mbi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kedlangkadlangkad te esawa rin, kegkeima, kereatey te itungan mekeatag te ruma rin, kebpenlimbung, kedimayà, kebpengelikud, kebpenerupet, kebmeperayù, wey kerupangan. ");
INSERT INTO mbi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Langun din ini ne menge meraat ne ulaula ne kayi ebpuun te lusud te hinawa te etew ne ebpekeredsik kandin.” ");
INSERT INTO mbi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ne mid-awà si Hisus ketà te lusud te inged ne Geliliya ne mibpendiyà te inged ne Tiru. Guna su nekeuma en ne mibpemenayik sikandin dutun te valey su kenà din egkesuatan ne egketendekan te menge etew ke valey ne midetengan din, ugaid ne kenà ma iya ebpekeeles sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ne ruen meritan ketà te inged ne ruen anak din ne meritan ne midsuukan te vusew. Guna su nerineg din se nekeuma en si Hisus ne mibayaan din ne midlumpeng en diyà te sineruwan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ne mibpemuyù kandin te ibpesegseg ke vusew ne midsuuk te anak din. Ini se meritan ne kenà Hudiyanen su etew te inged ne Punisiya, lusud te inged ne Siriya, ne iyan din kedlalag ne Gerisiyanu. ");
INSERT INTO mbi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ugaid ne midsempità si Hisus kandin te, “Ed-unaan ta te ebpekaan ke menge vatà su kenà edait ne egkuan ta ke ibpekaan te menge vatà ne idsavud te menge asu.” ");
INSERT INTO mbi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Benar ayan, Kerenan,” ke se meritan, “ugaid misan ke menge asu ne ebpenelisim dut te mumu te menge vatà ne ebpengeulug diyà te lemisaan.” ");
INSERT INTO mbi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne migkahi si Hisus te, “Geina te iring ketà se lalag nu, ne ebpekeulì ke en su mid-awà en ke vusew ne midsuuk te anak nu!” ");
INSERT INTO mbi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Arà dà ne mid-ulì en ke meritan, ne iyan din nekita ne ed-id-irehà ke anak din su mid-awà en iya ke vusew ne midsuuk kandin. ");
INSERT INTO mbi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Guna su mid-awà si Hisus kayi te inged ne Tiru ne riyà pà mibpevayà te inged ne Sidun, ne arà pà ne mibetikù kayi te ranew ne Geliliya ne midlusud en te inged ne Dikapulis. ");
INSERT INTO mbi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne ruen menge etew ketà ne mibpeneheewit te etew ne bengel, ne timalù te egkeemew kayi te ki Hisus. Ne mibpemuyù dan ki Hisus te ibperampen kandin su apey meulii. ");
INSERT INTO mbi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Arà dà ne migkuwa en ni Hisus ini se etew ne impesivey rin en dut te merakel ne etew, ne intiyuk en ni Hisus ke terù din dut te telinga te bengel. Ne an pà ne mid-ames din te ileb ke terù din ne impendaras din dut te rilà ketà te etew. ");
INSERT INTO mbi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Midlingakà si Hisus diyà te langit ne merahing se kinepeudsur din te hinawa rin se egkahi te, “Ipata!” ne iyan din meana se “Mepuwasi!” ");
INSERT INTO mbi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Arà dà iya ne nekerineg en ini se vengel, ne mepayag en ke kebpekelalag din su nekeulit en. ");
INSERT INTO mbi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ketà ne imbandù ni Hisus dut te menge etew te kenà dan penudtula ini se nekita ran te misan entei en. Ugaid ne makin ne impemees ni Hisus ne lemban en be ne in-eneb-eneb dan ini se nekita ran. ");
INSERT INTO mbi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne langun ne nekerineg ketà ne negeyip nevenar su iyan dan nekahi se, “Meupiya nevenar ini se langun ne vaal din! Misan ke bengel ne ebpekerineg en, ne ke emew ne ebpekelalag en!” ");
INSERT INTO mbi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Senge hewii ketà ne nevurun maa ke merakel ne menge etew. Guna su neeminan dan en te egkekaan, ne pineuvey ni Hisus ke menge edumdumaan din se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Igkeyruwi ku nevenar ini se menge etew,” ke si Hisus, “su nekedtetelu en ne hewii se kinepekiduma ran keytew ne warè en egkekaan dan. ");
INSERT INTO mbi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Embiya ebpeulien ku sikandan te kenà dan ebpekekaan, ne edlunusan dan diyà te ralan te kegkevitil su ruen duma ne meriyù se ed-ulian din.” ");
INSERT INTO mbi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Migkahi ke menge edumdumaan ni Hisus te, “Endei ki mulà ebpekekuwa te egkekaan ne ibpekaan tew kayi te merakel ne menge etew se ini kiyu te inged ne warà bulug etew rin?” ");
INSERT INTO mbi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Engkey ma taman ke kerakel te lutù tew?” ke si Hisus. Ne migkahi ran te, “Pitu rè be ne timan ini se lutù tew ne pan.” ");
INSERT INTO mbi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ne pinepinuu ni Hisus ke menge etew diyà te tanà. Ne migkuwa rin ke pitu ne timan ne pan ne impeselamat din en diyà te Eleteala. Arà dà ne mibpenevìtevì din en ke pan, ne imbehey rin en dut te menge edumdumaan din su ibpetukid diyà te menge etew. Ne arè en iya rema ke mid-ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne ruen dema ketà pira ne timan ne reisek ne serà. Ne migkuwa ini ni Hisus ne impeselamat din diyà te Eleteala, ne imbehey rin diyà te edumdumaan din su ibpemehey ran dema riyà te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Langun dan ne migkaan ne nengevulung, ne ruen menge epat ne ngivu se menge etew ne nevurun ketà ne migkaan. Guna su nekeipus dan se ebpengaan, ne mibpunpun dut te edumdumaan din ke nengesamà ne iyan din nepunpunan se pitu ne binevey. Ne pineulì ni Hisus ke menge etew, ");
INSERT INTO mbi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ne arà dà ne mid-untud en sikandin te avang wey ke menge edumdumaan din ne mid-avang-avang dan en se ebpendiyà te inged ne Delmanuta. ");
INSERT INTO mbi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Guna su nekerunggù dan, ne ruen en menge Peresiyu ne mibpengkayi te ki Hisus se ebpekidlewanà kandin su ebeelan dan te litag si Hisus. Ne mibuyuan dan sikandin te mebpekita te mekegeyip ne tuus te sikandin ke benar ne midsuhù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ketà ne mibmerahing se kinepeudsur ni Hisus te hinawa rin se egkahi te, “Sikiyu ne menge etew te guntaani en, meambe ke ed-inteng kew pà te menge mekegeyip ne arà pà ne ebperetiyaya kew? Ugaid ne igkahi ku keniyu ke benar te warà ibpekita ku keniyu ne mekegeyip ne tuus!” ");
INSERT INTO mbi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Arà dà ne mid-ewaan din en sikandan ne mid-erà te avang se ed-apet diyà te ranew. ");
INSERT INTO mbi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ne nelipat ke edumdumaan ni Hisus te ed-ewit te lutù dan ne pan, ugaid ne senge timan dè be ne pan se kayi te avang dan. ");
INSERT INTO mbi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ne midsempità si Hisus kandan se egkahi te, “Andam kew,” ke sikandin, “ne ingati niyu te kenà kew egkepeneheewit te ibpelevag te pan dut te menge Peresiyu, abpeg ki Hirudis.” ");
INSERT INTO mbi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ugaid ne geina te warà dan mesebuti ne mibpeleglelahey ran te, “Iyan din kinepekekahi kayi ne geina te warà kiyu mekeewit te lutù tew ne pan.” ");
INSERT INTO mbi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ne netuenan ni Hisus ke engkey se ibpeleglelahey ran ne migkehiyan din en sikandan te, “Meambe ke iyan niyu egkepengasak se warà niyu kebpekeewit te pan? Maa, warà kew pè bes mekasabut? Maa mevavew pè be se itungan niyu? ");
INSERT INTO mbi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duen ded ura mata niyu, ne meambe ke kenà niyu egkekita? Ne duen ded ura telinga niyu, ne meambe ke kenà niyu egkerineg? Maa kenà niyu en egketenuran ke mid-ulaula ku? ");
INSERT INTO mbi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ketà te kinepenevìtevì ku rut te lelima ne timan ne pan ne impekaan ku rut te lelima ne ngivu ne menge etew, ne pira ne binevey se nepenù te nengesamà ne nepunpun?” “Sepulù wey deruwa ne binevey,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ne migkahi pà maa si Hisus te, “Arà se kinepenevìtevì ku rut te pitu ne timan ne pan ne impekaan ku rut te epat ne ngivu ne menge etew,” ke si Hisus, “ne pira ne binevey se nepenù te nengesamà?” “Pitu ne binevey,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Maa warà kew pè be lavew mekesabut te ini se penurù ku ne kenà mekeatag te egkeenen tew?” ");
INSERT INTO mbi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nekerunggù dan kayi te inged ne Betsaida, ne ruen menge etew ne mibpeneheewit te pisek kayi te ki Hisus ne mibpemuyù dan te ibperampen kandin su apey meulii. ");
INSERT INTO mbi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Arà dà ne mibpikit en ni Hisus ke pisek ne midlihawang dan en dut te inged. Nekelihawang den dà ne mid-ilevan en ni Hisus ke mata ketà te pisek, ne midampen din se egkahi te, “Maa, ruen en egkekita nu?” ");
INSERT INTO mbi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ne midlingakà ke pisek ne migkahi te, “Egkekita ku en ke menge etew, ugaid ne iring dan te menge kayu ne ebpengip-ipanew.” ");
INSERT INTO mbi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ne midampen en maa ni Hisus ke mata rut te pisek ne ketà ne mibutatek din te edtengteng ke meama, ne nekeulit en ke kedtengteng din su mepayag en se kebpekekita rin. ");
INSERT INTO mbi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne pineulì ni Hisus sikandin se egkahi te, “Kenà ke en be awet kayi te inged ini.” ");
INSERT INTO mbi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ketà ne mid-ipanew en si Hisus wey ke menge edumdumaan din te ebpendiyà te menge inged uvey te inged ne Sisariya Pilipus. Gewii ran te ed-ip-ipanew ne mid-insaan ni Hisus ke menge edumdumaan din te, “Engkey a kun ma riyà te pegitungan te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Ruen egkahi te sikuna si Juan ke Ebpemunyag,” ke sikandan. “Ne ruen duma ne egkahi te sikuna si Elias ke mibpelambas te Lalag te Eleteala rengan. Ne ruen pà ruma ne egkahi te sikuna ke seveka ne mibpelambas te Lalag te Eleteala rengan.” ");
INSERT INTO mbi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ne menu sikiyu,” ke si Hisus, “engkey a ma diyà te pegitungan niyu?” Ne midtavak si Pedro te, “Sikuna si Kristu ke midtendù te Eleteala ne ebperetuen dut te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne mid-il-ilutan ni Hisus te egkahi kandan te kenà dan ibpenudtul ini te misan entei ne etew. ");
INSERT INTO mbi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ketà ne impesabut en ni Hisus dut te menge edumdumaan din te, “Iyan iya se edresayen nevenar ini se Impeanak te Menusiyà su ebpeheweran diyà te menge egkeunutan te Hudiyanen wey ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan. Ed-imetayan, ugaid ne ketà te iketetelu ne hewii ne egkevanew red.” ");
INSERT INTO mbi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mibpeketuenan ni Hisus kandan ke langun ne ibped-ulaula kandin. Nerineg ni Pedro ne impekeriyù din si Hisus ne migkehiyan din te kenà en ebpeisehen te edlalag te iring ketà. ");
INSERT INTO mbi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ugaid ne midlingì si Hisus se edtengteng diyà te menge edumdumaan din ne midawey rin si Pedro se egkahi te, “Awà ka su iring ka ki Setanas. Su ke itungan nu ne kenà diyà ebpuun te Eleteala, ugaid ne kayi rà ebpuun te itungan te menusiyà!” ");
INSERT INTO mbi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ne miburun en ni Hisus ke menge etew abpeg dut te menge edumdumaan din ne migkahi te, “Embiya ruen etew ne egkiyug ne eduma kediey ne iyan iya se pekelipati rin ke kandin ne kiyug, ne tianga rin ke kandin ne pinebelavag ne kayu ne ed-ingaranan te krus ne iyan din meana ne tumana rin ke menge suhù ku misan ibpatey rin pà se keduma rin kediey. ");
INSERT INTO mbi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Su ke etew ne egkenuhun te umur din ne ebpatey lavew, ugaid ke etew ne iyan din ibpatey se keduma rin kediey te kebpemesabut dut te Meupiya ne Tudtul ne ruen umur ne ibehey kandin ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Menu, ke ruen etew ne ebpekeangkun te langun taman kayi te ampew te dunya, maa engkey se rantek din embiya egkerasey ke himukud din diyà te apuy ne rakà? Warà! ");
INSERT INTO mbi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Su warà misan engkey ne kearen ne igkevehey te etew apey rin meawì ke gimukud din. ");
INSERT INTO mbi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Embiya ruen etew ne igkeyeyai a rin wey ini se ibpenurù ku kayi te ini ne timpu ne merakel ne menge etew ne mekesesalà wey edsumpalit te Eleteala, ne ke Impeanak te Menusiyà ne igkeyeyai rin dema sikandin ketà te kedlived din kayi te ampew te dunya. Su ketà ne hewii ne ruen raman din ne riyà ebpuun te Amey rin ne Eleteala, ne edumaan sikandin dema rut te menge berekat ne suluhuen diyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne migkahi pà maa si Hisus te, “Tentenuri niyu ini, ruen ruma tew kayi ne kenà pà ebpatey taman ketà te hewii ne egkekita ran ke kedetui te Eleteala te menge etew rut te gehem din.” ");
INSERT INTO mbi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Guna su neked-enem en ne hewii, ne miduma en ni Hisus ensi Pedro, si Santiago wey si Juan ne midtekereg dan en te mehantur ne buvungan te sikandan dà. Guna su ketà dan en ne midtengtengan dan si Hisus ne netekew nedsalin ke paras din. ");
INSERT INTO mbi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne mibpeneringsing ke velegkas din te keputì su warà misan engkey ne kayi te ampew te dunya ne ebpekemeputì iring kayi. ");
INSERT INTO mbi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Netekew ran en dema nekita se deruwa ne etew se ebpekidlalag ki Hisus, si Elias wey si Moises, ke menge mibpelambas te Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne migkahi en si Pedro ki Hisus te, “Meyterù, meupiya su kayi ki! Edsesabung key te tetelu, seveka keykew, seveka ki Moises, wey seveka rema ki Elias,” ke sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ugaid ne matag be migkahi si Pedro te iring ketà ne warà din metueni ke engkey se egkehiyen din su neandek dan. ");
INSERT INTO mbi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Arà dà ne ruen sehulapun ne nekelikuvung kandan ne ruen suwara ne ketà ebpuun te sehulapun ne migkahi te, “Ini ke Anak ku ne egkelimù ku nevenar. Pemineha niyu ke edlelahen din!” ");
INSERT INTO mbi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ne mibpenlangulangu ran ketà, ugaid ne warà en etew ne nekita ran liyu rà ki Hisus ke ruma ran. ");
INSERT INTO mbi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Gewii ran te edtupang ne mibenduan dan en ni Hisus te, “Kenà niyu ve imbe ibpenudtul te misan entei en ini se nekita niyu taman te egkevanew en ke Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ne midtuman dan ini se ingkahi ni Hisus, ugaid ne mibpein-inseey ran te, “Engkey se meana rin ini se ebenawen?” ");
INSERT INTO mbi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne mid-insaan dan si Hisus te, “Meambe ke egkehiyen te menge meyterù te penduan te iyan ed-una ebpengkayi ne si Elias ke etew ne mibpelambas te Lalag te Eleteala rengan, ne arà pà ke midtendù te Eleteala ne edatù?” ");
INSERT INTO mbi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ne midtavak si Hisus te, “Benar ne ed-una ebpengkayi si Elias su ed-endamen din ke langun te kebpekeuma dut te midtendù te Eleteala ne edatù. Ugaid ne maa,” ke sikandin, “ke ruen dema impesurat ne Lalag te Eleteala rengan te merakel se kemeresayan dut te Impeanak te Menusiyà ne idumilì dan sikandin? ");
INSERT INTO mbi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ugaid ne igkahi ku keniyu te nekeuma en si Elias. Nasì dan midrasey sikandin te endei se kiyug dan iring dut te impesurat dengan ne Lalag te Eleteala mekeatag kandin.” ");
INSERT INTO mbi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Guna su nekeuma en ensi Hisus kayi te ruma ne edumdumaan din, ne nekita ran te midlingutan dan te merakel ne menge etew. Ruen kayi menge meyterù te penduan ne ebpekidlewanà kandan. ");
INSERT INTO mbi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Guna su nekita rut te menge etew se ebpelingguma en si Hisus ne nengeinuinu ran nevenar su warà kebpenareng dan kandin, ne mibpemelelahuy ran en su midsinuhung dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne mid-insaan ni Hisus ke menge edumdumaan din te, “Engkey se ibpelewaney niyu?” ");
INSERT INTO mbi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne ruen ketà te nevurun senge etew ne meama ne midselet se egkahi te, “Meyterù, ruen ini se anak ku ne mibpeneheewit ku kayi te keykew su midsuukan te vusew ne kenè en ebpekelalag. ");
INSERT INTO mbi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Embiya edsuukan sikandin te vusew ne ebpekebadas sikandin diyà te tanà, eburvuraan ke bèbà din, edyengketen ke ngipen din, ne egkereg ke lawa rin. Ne mibpemuyù ku rut te edumdumaan nu te ibpesegseg ini se vusew ne midsuuk kayi te anak ku, ugaid ne warà dan ma megaga.” ");
INSERT INTO mbi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Migkahi si Hisus te, “Sikiyu ne menge etew guntaan, warà kebperetiyaya niyu te Eleteala! Neuhet en se kebpekiduma ku keniyu, ne engkey pà taman te kebperetiyaya niyu? Engkey pà taman se keuhet din se kedtigkeri ku keniyu? Ipengkayi niyu ayan se vatà!” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne mid-ewit dan en ke vatà riyà te ki Hisus. Guna su nekita rut te vusew si Hisus ne midsuukan din en ke vatà te nehurivid, ne nekebadas en diyà te tanà, ne midteltelilid en, ne miburàburà ke bèbà din. ");
INSERT INTO mbi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mid-insaan ni Hisus ke amey rut te vatà te, “Keenu rudsui sikandin kayi te egeraman din ini?” Midtavak ke amey rin te, “Inggenat dà te vatà pà sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Su kenà kepipira rà ed-imetayi perem kayi te vusew su ruen ke riyà ebpeketimbag sikandin te apuy wey ruen ke riyà te wayig. Keyruwi key nikuna ne tevangi key embiya egkegaga nu.” ");
INSERT INTO mbi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Ne meambe ke id-insà nu pà embiya egkegaga ku?” ke si Hisus. “Su langun ne egkegaga te etew embiya ruen peretiyaya rin te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Arà dà ne nekekahi ke amey rut te vatà te, “Duen peretiyaya ku, ugaid ne kurang pà. Ebuyuen ku ne umani nu pà!” ");
INSERT INTO mbi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nekita ni Hisus te edadseg en kandan ke merakel ne menge etew ne migkehiyan din en ke vusew ne midsuuk dut te vatà te, “Sikew ne vusew ne igkeemew wey igkevengel te menge etew,” ke sikandin, “ewai nu ayan se vatà ne kenà ke en be imbe edlived!” ");
INSERT INTO mbi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Arà dà ne migkulayì en ke vusew ne mibidbid din en ke vatà, ne mid-awà en diyà te kandin. Ne iring en te minatey ini se vatà su warà en mekewaleng, ne migkahi en ke menge etew ketà te, “Minatey en!” ");
INSERT INTO mbi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ugaid ne migewaran ni Hisus ke velad dut te vatà ne pineenew rin, ne mid-itindeg en ke vatà. ");
INSERT INTO mbi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Guna su riyà en ensi Hisus te lusud te valey ne mid-insaan en dut te edumdumaan din te, “Meambe ke warà dey megaga te edsegseg ke vusew ne midsuuk ketà te vatà?” ");
INSERT INTO mbi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne migkahi si Hisus kandan te, “Warà duma ne ebpekegaga te kedsegseg te iring keniyan ne vusew embiya kenà kayi rà te kebpengeningeni.” ");
INSERT INTO mbi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ne mid-awà dan ketà ne midlaus dan en se ed-ipanew diyà te lusud te Geliliya. Ne kenà egkiyug si Hisus ne egketuenan te menge etew ke endei sikandin egketahù, ");
INSERT INTO mbi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","su apey warà ebpekesambar te kebpenurù din dut te menge edumdumaan din. Migkahi sikandin diyà te kandan te, “Ini se Impeanak te Menusiyà ne ed-uluhen dut te menge egkunterà kandin ne ebpeimetayan dan, ugaid ne ketà te iketelu ne hewii ne egkevanew red.” ");
INSERT INTO mbi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne warà dan mesebuti ke meana rut te migkahi ni Hisus kandan, ugaid ne neandek dan te ed-insà kandin. ");
INSERT INTO mbi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nekeuma ran diyà te inged ne Kapirnawum ne guna su diyan dan en te lusud te valey ne mid-insaan en ni Hisus ke menge edumdumaan din te, “Engkey ma se ibpelewlewaney niyu riyà te ralan?” ");
INSERT INTO mbi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ugaid ne warà senge etew kandan ne neketekab su iyan dan ibpelewlewaney ke engkey kandan se mepurù. ");
INSERT INTO mbi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne mibpinuu si Hisus, ne miburun din en ke sepulù wey deruwa ne edumdumaan din ne midlalag en kandan se egkahi te, “Misan engkey ne etew ne egkiyug ne ebmepurù, ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà sikandin dut te langun ne menge ruma rin.” ");
INSERT INTO mbi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ketà be ne migkuwa si Hisus te senge etew ne vatà ne midsepipi rin ne impeitindeg din diyà te etuvangan dan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Misan engkey ne etew se edtelimà te vatà iring kayi su atag te keduma rin kediey, ne midtelimà dema sikandin kediey. Ne misan engkey ne etew ne edtelimà kediey, ne kenà siak dà se midtelimà din su ke Amey ku rema ne Eleteala ne midsuhù kediey ne midtelimà din ded.” ");
INSERT INTO mbi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne migkahi en si Juan diyà te ki Hisus te, “Meyterù, duen neuma rey ne etew ne ebpenegseg te menge vusew te ibpepevayà dut te gehem te ngaran nu. Ne midawey rey sikandin su kenà tew ma ruma.” ");
INSERT INTO mbi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ne migkahi si Hisus te, “Kenà niyu sikandin edewaya su warà etew ne ebpekevaal te mekegeyip te ibpepevayà te ngaran ku ne melemu ne edlalag te mereatey mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Su ke etew ne kenà tew kunterà ne ruma tew. ");
INSERT INTO mbi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Benar ini se egkehiyen ku, piya engkey ne etew ne ebpeinum keniyu te wayig su sabap te kineruma niyu kediey, ne ebpeketelimà en iya sikandin te idlalew te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ne mekeatag be te ini se menge vatà ne mibperetiyaya kediey, embiya ruen etew ne ebpekepeengked te sarig dan kediey, ne iyan pà meupiya,” ke si Hisus, “ne ebperiwetuwan ke lieg din te mevehat ne vatu ne id-antug diyà te rahat tumin dè be ke ebpekepeengked ke sarig te vatà. ");
INSERT INTO mbi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke belad nu, ne tempera nu! Su iyan pà tumù ne egkesarir ka ne ebpekeangkun ka te umur ne kenà edtaman tumin dè be ke deruwa red ke velad nu ugaid ne riyà ka ma ebpesinaru te apuy nerakà ne warà igkeevuki rin.  ");
INSERT INTO mbi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Su ketà ne ruen menge tagkey rin ne kenà ebpatey, ne ke apuy ne kenà egkeevukan. ");
INSERT INTO mbi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke paa nu, ne tempera nu! Su iyan pà tumù ne egkesarir ka ne ebpekeangkun ka te umur ne kenà edtaman, tumin dè be ke deruwa red ke paa nu ugaid ne igkeantug ka diyà te apuy nerakà.  ");
INSERT INTO mbi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Su ketà ne ruen menge tagkey rin ne kenà ebpatey, ne ke apuy ne kenà egkeevukan. ");
INSERT INTO mbi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne embiya iyan ebpekepeneheewit keykew te kebpekedsalà nu ke mata nu, ne lesika nu! Su iyan pà tumù ne kebpekelusud nu rut te edetuan te Eleteala ne dibdivaluy rà ke mata nu, tumin dè be ke deruwa red ke mata nu ugaid ne igkeantug ka riyà te apuy nerakà.  ");
INSERT INTO mbi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Su ketà ne ruen menge tagkey rin, ne kenà ebpatey, ne ke apuy ne kenà egkeevukan. ");
INSERT INTO mbi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Su uman senge etew ne eduma kediey ne egkepenedsal pà te apuy wey timus ne iyan din meana ne ebpekeheram pà te kemeresayan su apey mebmevag-et ke kedsarig din kediey. ");
INSERT INTO mbi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ne meupiya ini se timus su ibmeupiya te nanam dut te egkeenen tew, ugaid ne embiya egkeawà en ke nanam kayi te timus ne warà en dalan te kebmetimus din pà maa. Ne iring te timus ini se ed-ul-ulaan te menge etew ne mibperetiyaya kediey,” ke si Hisus, “tembù be iyan iya se pelimlimuey kew ne peup-upianey kew.” ");
INSERT INTO mbi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mid-awà si Hisus ketà te inged ne Kapirnawum ne mibpendiyan te lusud te inged ne Hudiya ne mid-apet diyà te wayig ne Hurdan. Ketà ne ruen en maa merakel ne menge etew ne nevurun diyà te kandin ne mibpenurù din en maa sikandan su arà ke tatap ne ed-ul-ulaan din. ");
INSERT INTO mbi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ne ruen menge Peresiyu ne mibpengkayi te ki Hisus su ebaal dan te idseligkat kandin. “Menu, idluhut be te penduan tew,” ke sikandan, “se ebpekid-engked ke meama te esawa rin?” ");
INSERT INTO mbi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ugaid ne in-insà ni Hisus kandan te, “Engkey ma se nekahi rut te impesurat ni Moises ne penduan tew mekeatag te kebpeked-engked te esawa?” ");
INSERT INTO mbi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ke sikandan te, “Inluhut ni Moises ini, ugaid ne ed-una edsurat te kesebenaran te ebpekid-engked en sikandin ne an pà ne egkeengkeran din ke esawa rin.” ");
INSERT INTO mbi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ne migkahi si Hisus kandan te, “Inluhut ini ni Moises se kebpekid-engked niyu geina te meresen ke ulu niyu te kebpemineg niyu te kebpenurù din. ");
INSERT INTO mbi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ugaid ne rut te kinelimbaha kayi te dunya, ‘Ne midlimbag te Eleteala ke meama wey meritan. ");
INSERT INTO mbi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tembù be ed-ewaan dut te meama ke amey rin wey iney rin su riyà ebpekidseveka sikandin te esawa rin, ");
INSERT INTO mbi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ne ini se teled-esawa ne nevaluy ne seveka.’ Ketà ne kenà dan en deruwa ne etew su neseveka rà. ");
INSERT INTO mbi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tembù be ini se deruwa ne etew ne midseveka te Eleteala, ne kenà egkepebelag dut te etew,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Guna su riyan dan en te valey ne mid-insà maa ki Hisus ke menge edumdumaan din mekeatag te ked-engked te esawa. ");
INSERT INTO mbi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne migkahi en si Hisus kandan te, “Embiya ruen meama ne ebpekid-engked te esawa rin ne edsaup ded maa ed-esawa, ne nekelangkad te esawa rin. ");
INSERT INTO mbi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Engketà ded dema ke meritan, embiya ruen ebpekid-engked te esawa rin ne edsaup ded maa ed-esawa, ne nekelangkad ded dema te esawa rin.” ");
INSERT INTO mbi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne ruen menge etew ketà ne mibpemava te menge anak dan diyà te ki Hisus su ibperampen dan kandin su ebpepenubtuvaran, ugaid ne midawey ran dut te menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Guna su nekita ini ni Hisus ne ingkeepesi rin ne ke sikandin te, “Kenà niyu dewaya sikandin! Ugaid ne ipepengkayi niyu te kediey ke menge vatà, su ke menge etew ne iring te menge vatà se kedsarig dan kediey ne sikandan ke ebpekeamung te Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sebenarvenar ini se egkehiyen ku, ke etew ne kenà edtelimà te Kedetui kandin te Eleteala iring te kedtelimà kayi te reisek ne vatà, ne kenà sikandin ebpekelusud dut te menge etew ne Edetuan te Eleteala,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Arà dà ne mibpenikupu rin ke menge vatà ne midampen din sikandan su ebpenubtuvaran. ");
INSERT INTO mbi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Guna su ed-ipanew en maa ensi Hisus ne ruen meama ne mibpelelahuy se ebpendiyà te kandin. Ne midlumpeng en diyà te sineruwan ni Hisus se egkahi te, “Meyterù, langun ne ed-ul-ulaan nu ne meupiya! Engkey iyan se ed-ul-ulaan ku apey a mekekuwa te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ne midtavak si Hisus te, “Meambe ke nekahi nu te meupiya ke langun ne ed-ul-ulaan ku? Su seveka rà se meupiya se ed-ul-ulaan din ne Eleteala rà. ");
INSERT INTO mbi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ugaid ne embiyà arà se id-insà nu mekeatag te umur ne kenà edtaman, ne netuenan nu en ke penduan ne egkahi te: ‘Kenà ka ed-imatey, kenà ka edlangkadlangkad te esawa nu, kenà ka ebpenakew, kenà ka edtarùtarù, kenà ka edlimbung, ne edati nu ke amey nu wey ke iney nu.’” ");
INSERT INTO mbi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ne midtavak ke meama ki Hisus te, “Meyterù, igenat te vatà e pà ne langun keniyan ne midumaan ku.” ");
INSERT INTO mbi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nerineg dà ni Hisus ne midtengtengan din ke meama su neyruwan din se egkahi te, “Duen pà lavew kurang nu. Iyan be se ulì ka ne pesaa nu ke langun ne kearen nu ne ipemehey nu ve ke elehà din diyà te menge ayuayu su apey ruen kekewesai nu riyà te langit ne muna pà dut te kearen nu kayi. Ne arà pà ne pengkayi ka te eduma kedì,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nerineg din dà ke lalag ni Hisus ne mibmerumbahat ke buvuked din ne mid-ipanew en se merungkug su kewasa nevenar. ");
INSERT INTO mbi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ne mibpenlangulangu si Hisus diyà te menge edumdumaan din se egkahi te, “Merehen nevenar te kewasa ne etew se kebpesakup din dut te Edetuan te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ne nengegeyip ke menge edumdumaan ni Hisus ketà te lalag din. Ugaid ne migkahi en maa si Hisus kandan te, “Menge anak, merehen nevenar te etew se kebpesakup din dut te Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Iyan pà melemu ne ebpevayà diyà te vudsi te rahum ini se binatang ne kemilu tumin dè be ke kebpesakup te etew ne kewasa dut te Edetuan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nerineg dà dut te menge edumdumaan din ne ingkegeyip dan nevenar ne mibpein-inseey ran te, “Embiya iring ketà se kerehen din te etew ne kewasa te kebpesakup din dut te Edetuan te Eleteala, ne engkey rè be buwa se ebpekekuwa te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ne midtengteng si Hisus kandan ne migkahi en te, “Embiya etew rà ne kenà dan ebpekegaga te eboejejywa te umur ne warà edtemanan din, ugaid ne Eleteala se ebpekegaga ne ebehey kandan su egkegaga te Eleteala ke langun.” ");
INSERT INTO mbi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ne midlalag en si Pedro te, “Netuenan nu te mid-ewaan dey ke langun taman dey su miduma key keykew.” ");
INSERT INTO mbi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne migkahi si Hisus kandan te, “Benar ayan, ugaid ne sebenarvenar ini se egkehiyen ku keniyu te misan engkey ne etew se neewaan din ke ubpaan din, menge suled din, menge etevey rin, ke iney rin wey amey rin, menge anak din, wey ke tanà din su atag dut te keduma rin kediey wey ke kebpesabut din dut te Meupiya ne Tudtul, ");
INSERT INTO mbi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ne ebpeketelimà sikandin te kemehatus egketakep se neewaan din ne ubpaan din, menge suled din, menge etevey rin, ke iney rin wey amey rin, menge anak din, wey ke tanà din te biviyag pà sikandin kayi te ampew te dunya, ne ebpekepevayà pà rema te kemeresayan. Ne ketà te akir din ne hewii ne egketelimà din ke umur ne kenà edtaman. ");
INSERT INTO mbi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ugaid ne merakel ne menge etew guntaan,” ke si Hisus, “ne mepurù se ketengdanan din, ugaid ne riyà te akir din ne hewii ne sikandan ke pinekemevavà. Ne ruen menge etew guntaani ne mevavà dan nevenar, ugaid ne ketà te akir din ne hewii ne sikandan se pinekemepurù se ketengdanan din.” ");
INSERT INTO mbi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Gewii te ed-ip-ipanew ensi Hisus wey ke menge edumdumaan din te ebpependiyà te Hirusalim ne mid-unauna si Hisus, ne neipeng dan nevenar su ebpependiyà sikandin te Hirusalim. Ne ke menge etew ne midtinundug kandan ne nengeandek dan. Ne impesivey en ni Hisus ke menge edumdumaan din ne impesabut din en maa kandan ke ibped-ulaula kandin. ");
INSERT INTO mbi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ke sikandin te, “Netuenan niyu en ne ebpendiyà kiyu te Hirusalim ne riyà ne sikandin ke Impeanak te Menusiyà ne ibpalad en diyà te menge mepurù te terebpelengesa wey ke menge meyterù te penduan. Ne ebpegumpung dan en te kukuman dan te ed-imetayan sikandin ne ibpalad sikandin diyà te menge etew ne kenà Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ne ed-unda-unda ran kandin, ne ebpengileb, ebpenlambit, wey ed-imatey ran kandin, ugaid ne ketà te iketelu ne hewii ne egkevanew sikandin.” ");
INSERT INTO mbi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ne ketà ne mid-uvey en ki Hisus ke menge anak ni Sibidiyu, si Santiago wey si Juan, se egkahi te, “Meyterù, ruen ebuyuen dey keykew.” ");
INSERT INTO mbi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Engkey ma se ebuyuen niyu?” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ke sikandan te, “Ketà te akir din ne hewii te kedatù nu en, ne ebuyuen dey keykew te pepinuuwa key ne ruma nu, seveka se riyà te egkekewanan nu, ne seveka ne riyà te egkehivang nu.” ");
INSERT INTO mbi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne migkahi ni Hisus kandan te, “Matag niyu en ini ebuyua ne warà niyu mesebuti an se ebuyuen niyu. Maa, ebpeketigker kew ve dut te kemeresayan ne mehaan ku en ibpevayà? Ne maa, ebpeketikà kew ve ne ebpevayà te kemetayen iring te ibpekepevayà ku?” ");
INSERT INTO mbi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Uya,” ke sikandan, “egketigkeran dey.” Ne migkahi si Hisus kandan te, “Benar iya ne edresayen kew iring te kemeresayan ku. Ne iring ded dut te ked-imetayi kediey se kedresaya rema keniyu. ");
INSERT INTO mbi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ugaid ne mekeatag te ayan se ebuyuen niyu, ne warà ketengdanan ku te ebpemilì te engkey se ebpepinuuwen kayi te egkekewanan ku wey kayi te egkehivang ku. Su ini ne intail dut te Amey ku ne Eleteala dut te mibpemilì din.” ");
INSERT INTO mbi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Guna su nerineg kayi te sepulù ne edumdumaan ni Hisus arà se ebuyuen enni Santiago ki Juan, ne nengeepes dan. ");
INSERT INTO mbi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tembù be impeuvey ran langun ni Hisus se egkahi te, “Netuenan tew ne ini se menge pengulu te inged kayi te ampew te dunya ne metehel ne edsuhù te langun ne menge etew, ne ini se menge unuten dan ne kandan dà ne kiyug se edumaan. ");
INSERT INTO mbi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ugaid ne kenà kew ed-iring ketà, su embiya ruen seveka keniyu ne egkiyug ne ebmepurù, ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà dut te langun. ");
INSERT INTO mbi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne embiya ruen seveka keniyu ne egkiyug te sikandin se ebpekeuna te langun niyu, ne iyan iya se mebpeembavà te hinawa rin wey ebpevayàbayà dut te langun. ");
INSERT INTO mbi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Su misan ke Impeanak te Menusiyà ne kenà iyan din kinepengkayi te ampew te dunya ne apey sikandin metevangi te menge etew. Ugaid ne iyan din kinekepengkayi ne apey rin metevangi ke langun ne menge etew, ne egkeimetayan sikandin su apey egkevelukasi ke langun ne menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nekeuma en si Hisus wey ke menge edumdumaan din diyà te Hiriku. Ne guna su ed-awà dan en ne merakel ne menge etew se mibpenduma kandan, ne kayi te kelid te ebpevayaan dan ne ruen meama ne pisek ne ebpinpinuu su ebpemuyù ne ed-ingaranan ki Bertimeo, anak ni Timiyu. ");
INSERT INTO mbi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Guna su nerineg din te edsahad en si Hisus ne riyà ebpuun te Neserit ne mibensag en te, “Hisus, ke inenakan ni David rengan, igkeyru a nu nevenar!” ");
INSERT INTO mbi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ne merakel ne menge etew ketà se midawey kandin te ebpeen-enengen ugaid ne lemban en ne egkeilut se ebpemensag te, “Sikuna ne inenakan ni David rengan, igkeyru a nu nevenar!” ");
INSERT INTO mbi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Guna su nerineg ni Hisus ne mid-itindeg pà sikandin se egkahi te, “Pikita niyu ayan kayi!” Arà dà ne mid-umew ran en ke pisek se egkahi te, “Kehalew ka en, ne itindeg ka, su ed-umawen ke en nikandin.” ");
INSERT INTO mbi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Arà dà ne mibpelis din ke kumbalà din, ne mid-itindeg en, ne mid-uvey en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Engkey ma se ebpetevangan nu kediey?” ke si Hisus. Ne migkahi ke pisek te, “Meyterù, kiyug ku ne mekekita a red perem!” ");
INSERT INTO mbi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Su kenà duwaruwa se kedsarig nu kediey,” ke si Hisus, “ne ebpekeulit en ke kebpekekita nu. Ipanew ke en.” Arà dà iya ne nekekita en ini se meama, ne miduma en ki Hisus te ked-ip-ipanew ran. ");
INSERT INTO mbi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Guna su ebpelundani ran en te Hirusalim ne neuma ran en ke buvungan ne ed-ingaranan te Ulivuwen, elet te inged ne Bitpahi wey inged ne Bitaniya. Midsuhù en ni Hisus ke deruwa ne edumdumaan din te ebpeunaan dan, ");
INSERT INTO mbi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ke sikandin te, “Una kew en be ketà te inged ne an te unaan ta, ne ketà te ebpekeuma kew ne egkekita niyu ke nati ne kudà ne in-iket ketà ne warà pà bulug meunturi. Ekari niyu be ne ewita niyu en kayi. ");
INSERT INTO mbi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne embiya ruen ed-insà keniyu te, ‘Meambe ke ed-ekaran niyu ke nati ne kudà?’ ne iyan niyu kehiya te, ‘Ke Kerenan dey se ebpegin-awà kayi te egkeunturan din ne mehaan dà id-ulì.’” ");
INSERT INTO mbi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Arà dà ne mid-ipanew en ke deruwa ne etew. Guna su nekeuma ran ne nekita ran en ke nati ne kudà diyà te uvey te ralan ne in-iket diyà te bengawan te valey. ");
INSERT INTO mbi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne gewii te ed-ekaran dan en ne ruen menge etew ketà ne mid-insà kandan te, “Ebmenuwen niyu ve ayan se nati ne kudà?” ");
INSERT INTO mbi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne midtavak dan dut te ingkahi ni Hisus kandan, ne ketà ne pineipanew ran en. ");
INSERT INTO mbi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ne mid-ewit dan en ini se nati ne kudà kayi te ki Hisus, ne midebpasan dan en te kumbalà dan ke nati ne kudà, ne mid-untud en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Merakel ne menge etew ketà se midtulid te menge kumbalà dan te ebpepeveyaan ki Hisus, ne ruma pà ne mibpenguwa te menge rasang ne rawunen su intulid dan su ini ke tuus te adat te menge Hudiyanen dut te menge mepurù dan. ");
INSERT INTO mbi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ke menge etew ne mid-una ki Hisus wey engketà ded dema ke midtundug kandin ne migkerag te, “Edeyuen tew ke Eleteala! Menu ma ke ebpeneuven te Eleteala ini se midtendù din ne edatù te langun! ");
INSERT INTO mbi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Menu ma ke ebpeneuven te Eleteala ini se nekeuma ne edatù keykew su sikandin ke insambì dut te ratù tew si David, ke keep-epuan tew rengan! Edeyuen tew te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Guna su nekeuma en si Hisus kayi te Hirusalim ne mibpendiyan en sikandin te Nekebpuru ne Valey te Eleteala ne mid-usug-usug din ke langun ne diyà te lusud, ne midlihawang en. Ne geina te meapun en ne mibpendiyà sikandin te inged ne Bitaniya se midumaan dut te edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nepawà ketà ne mid-awà dan en te inged ne Bitanya su edlived dan maa kayi te Hirusalim, ne gewii te ini ran pà te ralan ne nevitil si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ne ruen en nesandeng din ne merapung ne kayu ne ed-ingaranan te igira, ne mid-uvey rin su ed-intengan din ke ruen bahas din. Guna su nekeuma sikandin diyà te levut ne warà nekita rin ne bahas su tibal rawun su kenà ma ini ke gewii te kebpemehas din. ");
INSERT INTO mbi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne migkahi en si Hisus ketà te kayu te, “Igenat guntaani ne kenà ke en imbe egkekeenan te bahas nu!” Ini se lalag ni Hisus ne nerineg dut te menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Guna su nekeuma ran en diyà te Hirusalim ne midlusud en si Hisus ketà te Nekebpuru ne Valey te Eleteala ne mibpemenegseg din en ke menge etew ne ebpememasa wey ke menge ebpemendehang ketà. Ne mibpemelintuad din ke menge lemisaan dut te menge etew ne ebpenambì te kureta wey ke menge ebpeminuuwan dut te menge etew ne ebpemendahang te menge melepati ne ibpemelengesa rut te menge Hudiyanen diyà te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne kenà din idluhut ne ruen ed-ewit te rehangan dan ne kayi ebpevayà te lamalama te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne mibpenurù din ke menge etew ketà se egkahi te, “Duen en ura impesurat ne Lalag te Eleteala ne egkahi te, ‘Ini se baley ku ne ed-ingaranan te valey ne ebpengeningeniyan dut te langun ne menge etew te misan endei en.’ Ugaid ne sikiyu,” ke si Hisus, “ne mibaluy niyu en ini se baley ne ubpaan te menge tenlimbungen!” ");
INSERT INTO mbi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Guna su nerineg dut te menge mepurù te terebpelengesa wey ke menge meyterù te penduan ini se mid-ulaula ni Hisus ne mibpemengà dan te ralan te kegkeimetayi ran ki Hisus su neandek dan kandin geina te merakel ne menge etew ne negeyip rut te penurù din. ");
INSERT INTO mbi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Guna su midsanlep en ke andew ne mid-awà en si Hisus wey ke menge edumdumaan din kayi te inged ne Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Guna su nepawà en ne edlived dan en maa riyà te Hirusalim, ne kayi te ibayà dan ne nekita ran en ke kayu ne igira ne nehangu en taman te ralid din. ");
INSERT INTO mbi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ne netenuran ni Pedro ke midlalag ni Hisus ketà te kayu ne migkehiyan din si Hisus te, “Meyterù, tengtengi nu ma arà se kayu ne mibpendrawakan nu gevii ne nehangu en.” ");
INSERT INTO mbi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ne migkahi si Hisus te, “Tentenuri niyu ini ne sarig kew te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Su sevenarbenar ini se egkehiyen ku keniyu ne embiya meilut se kedsarig niyu te Eleteala te warà keduwaruwa rin, ne misan ke kenà egkegaga te menusiyà ne egkegaga niyu iring te ne misan egkehiyen niyu ini se buvungan te, ‘Awà ka kayi ne riyan ka te rahat,’ ne egketuman ini se egkehiyen niyu. ");
INSERT INTO mbi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tembù be idtarem ku keniyu te embiya ruen ebpemuyuen niyu te Eleteala, ne eheta niyu ke hinawa niyu te warà keduwaruwa rin ne egketelimà niyu ini. ");
INSERT INTO mbi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne embiya ebpengeningeni kew riyà te Eleteala ugaid ne ruen meraat ne neketahù te hinawa niyu mekeatag te ruma niyu, ne pesehara niyu sikandin su apey egkepesehad kew rema te Eleteala ke Amey niyu riyà te langit.  ");
INSERT INTO mbi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Su embiya kenà niyu egkepesehad ke ruma niyu, ne kenà kew rema egkepesehad dut te Amey niyu ne Eleteala riyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Guna su nekeuma ran en maa diyà te Hirusalim, ne midlived en maa si Hisus ketà te Nekebpuru ne Valey te Eleteala. Gewii rin te ed-ip-ipanew kayi te lusud ne ruen menge mepurù te terebpelengesa, menge meyterù te penduan, wey menge egkeunutan te Hudiyanen ne mid-uvey kandin. ");
INSERT INTO mbi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne mid-insaan dan si Hisus te, “Ini se mid-ulaula nu kayi te nekebpuru ne valey te Eleteala, ne engkey se kewagib nu te ed-ulaula te iring kayi? Ne engkey se mibehey keykew te kewagib?” ");
INSERT INTO mbi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Midtavak si Hisus te, “Ruen dema id-insà ku keniyu ne embiya egketavak niyu ne idtarem ku keniyu ke engkey se mibehey kedì te kewagib kayi te mid-ulaula ku. ");
INSERT INTO mbi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Engkey ke mibehey ki Juan ke Ebpembunyag te kewagib te ebunyag, diyà be te Eleteala etawa kayi rà dè duen te menusiyà? Kehiya niyu kediey.” ");
INSERT INTO mbi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ne mibpein-inseey ran en te, “Engkey se idtavak tew? Su egkehiyen embiya iyan tew se, ‘Riyà ebpuun te Eleteala,’ ne ed-insà maa sikandin te, ‘Meambe ke warà kew mebperetiyaya ki Juan?’ ");
INSERT INTO mbi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ugaid ne embiya egkahi ki te, ‘Kayi red ebpuun te menusiyà,’ ne egkeepesan kiyu te menge etew.” (Ini se impein-inseey ran su nengeandek dan dut te menge etew su langun ne mibperetiyaya te si Juan ne mibpelambas te Lalag te Eleteala.) ");
INSERT INTO mbi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ketà be ne midtavak dan ki Hisus te, “Kenà dey egketuenan.” Ne migkahi si Hisus kandan te, “Embiya iring ketà, na kenà ku rema egkehiyen ke engkey se mibehey kedì te kewagib ku te ed-ulaula kayi.” ");
INSERT INTO mbi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ne mibpenurù din en sikandan te impepevayà te sempità, ke sikandin te, “Ruen senge etew ne ruen tanà din ne mibpemulaan din te wahed ne ed-ingaranan te paras. Ne mid-alad din arà, ne mibaal din te edtehuan dut te egkekeres te bahas te paras, ne midsebungan din te ebpeubpaan dut te ebpeventayen din. Ne ruen pinekamal din dut te impemula rin, ne arà pa ne mid-ipanew en se ebpendiyà te meriyù ne inged. ");
INSERT INTO mbi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Guna su midsabpet en ke pinemula rin ne ruen senge etew ne edsugsuhuen din ne midsuhù din su ibpekuwa ke kandin ne umun. ");
INSERT INTO mbi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ugaid ne nekeuma ini se midsuhù din, ne migeweran dut te pinekamal ne mibedasan dan ne impeulì dan te warè en iya imbehey kandin. ");
INSERT INTO mbi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ne misan iring ketà, ne midsuhù en maa se senge etew. Ugaid ne nekeuma ini ne mibedasan ded maa ke ulu rin dut te pinekamal, ne pinegkeyà dan. ");
INSERT INTO mbi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nekita maa kayi te kemuney ini, ne midsuhù pà lavew te senge etew. Nekeuma maa ini, ne mid-imetayan dan. Ne iring din ded dema se imped-ulaula ran dut te ruma pà ne midsuhù su ruen en se mibpenruug, ne ruen se mid-imetayan dan. ");
INSERT INTO mbi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Guna su iyan dè be nesamà ke tuney en ne anak din ne igkelimù din nevenar, ne iyan din en midsuhù diyà te kandan su iyan netahù te itungan din ne ke sikandin te, ‘Kenà en be iya maa egkepakey ne kenà dan ini ed-edatan.’ ");
INSERT INTO mbi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ugaid ne guna su nekeuma ini se anak din ne mibpeleglelahey ke menge pinekamal din te, ‘Ini en bes ke anak dut te kemuney kayi te tanà. Kuwa kew en su ed-imetayan tew su apey sikitew en se ebpekegkemuney kayi te tanà.’ ");
INSERT INTO mbi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Arà dà ne migeweran dan en sikandin ne mid-imetayan dan en, ne intimbag dan ke bangkey rin diyà te luwal dut te pemulaan. ");
INSERT INTO mbi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na geina te iring kayi,” ke si Hisus, “se mid-ulaula rut te pinekamal dut te pemulaan, engkey ve se ed-ul-ulaan dut te kemuney ketà te pinekamal din? Idtarem ku keniyu te ebayaan din arà se menge etew ne ebpengimetayan din, ne ebpelemalan din te ruma pà ne menge etew.” ");
INSERT INTO mbi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne migkahi pà maa si Hisus te, “Nevasa niyu red ura ke impesurat ne Lalag te Eleteala ne egkahi te, ‘Ke pelaus ne mid-eng-engkeran dut te menge etew ne ebpemevaley, su kunaan dan ke warà rantek din ne iyan en iya ini nepemilì ne segkad te valey. ");
INSERT INTO mbi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ini se mid-ulaula te Kerenan ne mekegeyip nevenar!’” ");
INSERT INTO mbi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ne edsigkemen en perem si Hisus dut te menge egkeunutan te menge Hudiyanen su netuenan dan te sikandan ke nesuhat ketà te sempità din. Ugaid ne neandek dan dut te merakel ne etew ne egkiyug ne ebpemineg ki Hisus, ne arà dà ne mid-ewaan dan en sikandin ne mid-ipanew ran en. ");
INSERT INTO mbi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Guna su mid-awà en ke menge egkeunuten te menge Hudiyanen, ne ruen en maa ruma pà ne menge Peresiyu wey menge etew ni Hirudis ne midsuhù dan te ebaal te menge penginsà su apey ruen dalan ne idlitag dan ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Guna su nekeuma ran ne migkahi ran en te, “Meyterù, netuenan dey te edlalag ka te benar ne kenà ka egkepeneheewit dut te lalag te menge etew. Su misan ke mepurù mevavà ne menge etew ne warà ebiraan te kebpenurù nu, ugaid ne ebpenurù ka te benar dut te kiyug te Eleteala ne ed-ul-ulaan tew. Tembù be ruen. Ed-insà dey keykew. Maa, ebpekerimpas kiyu ve dut te penduan tew embiya ebayad ki te buwis diyà te ratù tew te inged ne Ruma, etawa kenà? Engkey, ebayad ki etawa kenà?” ");
INSERT INTO mbi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ugaid ne netuenan en ni Hisus se ebpemengaan den dà se ralan te igkeisuhat dan kandin ne ke sikandin te, “Meambe ke ebaal kew te ralan te kegkelitag niyu kediey? Peintenga a niyu kun te pelatà.” ");
INSERT INTO mbi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Impekita ran kandin ke pelatà ne migkahi sikandin te, “Engkey ki paras wey ngaran kayi?” Midtavak dan te, “Paras wey ngaran dut te ratù tew kayi te inged ne Ruma.” ");
INSERT INTO mbi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Embiya iring ketà,” ke si Hisus, “ne ivehey niyu diyà te datù ayan se bayad te buwis ne kandin, ne ivehey niyu riyà te Eleteala ke endei rema ke kandin.” Ne ingkeinuinu ran nevenar ini se migkahi ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ne ruen dema menge etew ne ed-ingaranan te Sedyusiyu ne mibpendiyà te ki Hisus. (Ini se menge Sedyusiyu ke menge etew ne warà mebperetiyaya te egkevanew pà te Eleteala ke menge minatey.) ");
INSERT INTO mbi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ke sikandan te, “Meyterù, ruen penduan ne insurat ni Moises dengan ne egkahi te, ‘Embiya ruen meama ne ebpatey ne neketahak te esawa rin ugaid ne warà anak dan, ne ebpemeluwen dut te suled din ne meama su apey ruen ded anak dut te minatey ne ebpekesumpat.’ ");
INSERT INTO mbi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Su ruen dengan,” ke sikandan, “pitu ne meama ne telteleari ne mid-esawa en ke kakey, ugaid ne minatey te warà dan med-anak. ");
INSERT INTO mbi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne mibpemalu en dut te nesikupu rin arà se ipag dan, ne minatey red dema te warà dan med-anak. Ne iring din ded dema ke iketelu. ");
INSERT INTO mbi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne engketà ded ke nesamà, langun dan te pitu ne etew se nekepemalu ketà te ipag dan, ugaid ne warà dan med-anak. Netaman ne minatey en ini se meritan. ");
INSERT INTO mbi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ne ini ve se id-insà dey keykew,” ke se menge Sedyusiyu, “embiya benar ne egkevanew red te Eleteala ke menge minatey keuremà, ne endei rapit kandan se tehiesawa ketà te meritan? Su langun dan te pitu ne telteleari ne nekedtundug se nekeesawa kandin.” ");
INSERT INTO mbi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Midtavak si Hisus te, “Warè en iya ebpekesuhat ne itungan niyu! Su warà niyu mesebuti ke impesurat ne Lalag te Eleteala, ne warà niyu mesebuti ke rekelà ne gehem din. ");
INSERT INTO mbi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Su ketà te hewii ne egkevanew ke menge minatey ne warè en kebpees-eseweey su iyan dan en egkeiringan ke menge suluhuen te Eleteala riyà te langit ne kenà ebpees-eseweey. ");
INSERT INTO mbi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ne ini se id-insà niyu mekeatag te kegkevanew te menge minatey, ne maa warà niyu ves mevasa ke impesurat ne lalag ni Moises dengan mekeatag te kinepekidlalag te Eleteala kandin ne riyà ebpuun te neregreg ne sagbet? Su misan neuhet en ne minatey en si Abraham, si Isaac, wey si Jacob ne migkahi ke Eleteala ki Moises te, ‘Siaken ke Eleteala ne ebpengerapan ni Abraham, ni Isaac, wey si Jacob,’ ke se Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tembù be netuenan tew,” ke si Hisus, “ne misan minatey ran en, ne viviyag den pà diyà te etuvangan te Eleteala su iyan dà ebpekepengarap te Eleteala ne viviyag, kenà ke minatey. Warè bulug ebpekesuhat ne itungan niyu!” ");
INSERT INTO mbi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ruen ketà meyterù te penduan ne ebpemineg te lalag ni Hisus dut te menge Sedyusiyu. Guna su netuenan din te metau nevenar ne ebpenavak si Hisus dut te menge Sedyusiyu ne midubpù en sikandin ne mid-inseen te, “Engkey ma rut te penduan tew se ebpekeuna te langun?” ");
INSERT INTO mbi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne midtavak ni Hisus te, “Ini ke ebpekeuna te langun: ‘Sikiyu ne inenakan ni Israyil ne pemineha niyu ini! Ke Kerenan ne Eleteala tew ne iyan dà iya Kerenan! ");
INSERT INTO mbi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Iamin nu ke hinawa nu te edlimù te Kerenan ne Eleteala nu, ne iamin nu ke baher nu wey ke itungan nu te ed-ulaula ke engkey se ebpekesuhat te hinawa rin.’ ");
INSERT INTO mbi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne ini ke ikeruwa ne pinekemepurù dut te langun: ‘Ikelimù nu ke ruma nu iring te kegkelimù nu te hinawa nu.’ Warà en be,” ke si Hisus, “ruma pà ne penduan ne pinekemepurù pà kayi te ini se deruwa.” ");
INSERT INTO mbi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Benar arà, Meyterù, se migkahi nu,” ke se meyterù te penduan, “su sebseveka rà ke Eleteala, ne warè en duma. ");
INSERT INTO mbi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne ini se lalag nu ne id-amin ta ke hinawa ta te edlimù te Eleteala, ne iyan ta ibpeuna sikandin te itungan ta wey rut te langun ne ed-ul-ulaan ta, ne igkelimù ta ke ruma ta iring dut te kegkelimù ta kayi te keytew ne hinawa,” ke se meyterù, “ne iyan pà ini meupiya ne edtumanen ta tumin dè be rut te langun ne binatang ne edtutungen wey ruma pà ne ibpelengesa ne ibehey tew te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Guna su nerineg ni Hisus te neketidtu ke tavak din ne migkahi en sikandin te, “Benar imbe ayan, deisek dà ne ebpekelusud ka rut te Edetuan te Eleteala.” Ne igenat dè be ketà ne warà en ebpeketikà ne ed-insà ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gewii te ebpenurù si Hisus ketà te Nekebpuru ne Valey te Eleteala ne mid-insaan din sikandan te, “Menu ne egkahi ke menge meyterù niyu te arà se Impasad te Eleteala ne Ebperetuen dut te langun ne etew ne inenakan sikandin ni David? ");
INSERT INTO mbi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Su mid-ulinan te Kedesenan ne Ebpetuntul te Menusiyà si David ne impesurat din te, ‘Migkahi ke Eleteala ketà te Kerenan ku te: Kayi ka pinuu te rapit te egkekewanan ku taman te ebpenggiekan ku ke menge kunterà nu.’” ");
INSERT INTO mbi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ne migkahi pà maa si Hisus te, “Embiya ini ke nekahi ni David te arà se Impasad te Eleteala ne Ebperetuen te langun ne Kerenan din, ne maa egkepakey ve ne kayi red ini te inenakan din?” Ne ketà ne nengesuatsuat ke merakel ne menge etew ne ebpemineg dut te kebpenurù ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Gewii ni Hisus te ebpenurù kandan ne migkahi te, “Uram kew su apey kenà kew egkepeneheewit dut te menge meyterù te penduan ne ebpengip-ipanew se ebevelegkas te lembung ne sida ne melayat su ebpeadat te menge etew diyà te menge pedian. ");
INSERT INTO mbi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne embiya riyà dan en te valey ne ebpengedian te penduan te menge Hudiyanen ne ebpemilì dan te meupiya ne ebpinuuwan diyà te sineruwan, etawa ke edtelavuk dan te kevurunan ne riyà dan ebpinuu te insivey ne meupiya ne ebpinuuwan te egkeedatan. ");
INSERT INTO mbi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ne ebpeey-eyunan dan ke menge kearen dut te menge valu ne meritan, ne ebpeedleyedley ran te kebpengeningeni ran diyà te Eleteala su uvag kun se rekelà se sarig dan te Eleteala. Ugaid ne keuremà ne labi pà ne mekeandek-andek ke ibadas ne kerusaan kandan te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Senge hewii ne riyà si Hisus te Nekebpuru ne Valey te Eleteala, ne mibpinuu sikandin diyà te uvey te edtegtehuan te kureta ne midtengtengan din ke menge etew ne ed-ulug dut te ibehey ran te Eleteala. Duen ketà menge kewasa ne rekelà se imbehey ran. ");
INSERT INTO mbi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ugaid ne ruen nekeuma ketà ne valu ne meritan ne ayuayu nevenar, ne iyan din dà neulug se deruwa ne tumbaha. ");
INSERT INTO mbi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Arà dà ne impeuvey en ni Hisus ke menge edumdumaan din ne migkahi en te, “Benar ini se egkehiyen ku keniyu ne riyà te etuvangan te Eleteala ne iyan pà rekelà se imbehey kayi te ini se valu ne meritan dut te langun ne imbehey te menge kewasa. ");
INSERT INTO mbi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su ke ruma ne menge etew ne iyan dan imbehey ne sawad dà dut te kekewesai ran, ugaid ne ini se ayuayu ne valu ne imbehey rin te Eleteala ke namànamà ne kureta rin ne edserihan te hinawa rin.” ");
INSERT INTO mbi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Guna su mid-awà en si Hisus ketà te Nekebpuru ne Valey te Eleteala ne ruen seveka ne edumdumaan din ne migkahi te, “Meyterù, tengtengi nu ma ini se menge vatu ne derekelà ne pengawid kayi, ne kebperasan nevenar ke kineveeli!” ");
INSERT INTO mbi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ne midtavak si Hisus te, “Uya, intengi nu ma ini se rekelà ne valey ne iyan din pengawid ne vatu! Su ruen gewii ne egkeuma ne ini se egkekita niyu ne egkerundus ne warà misan seveka rà ne vatu ne egkesamà su egkevurahey langun.” ");
INSERT INTO mbi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Guna su riyan dan en te buvungan ne ed-ingaranan te Ulivuwan ne mibpinuu si Hisus ne egkesineruwan din ke Nekebpuru ne Valey te Eleteala. Ne mid-uvey kandin si Pedro, si Santiago, si Juan, wey si Andres te sikandan dà se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ikahi nu kenami ke keenu egketuman ini se langun ne migkahi nu ne kegkerundus dut te Nekebpuru ne Valey te Eleteala, ne engkey se idtuus dey su apey rey egketueni te neuma en ke hewii te kegketuman din.” ");
INSERT INTO mbi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ne migkahi si Hisus kandan te, “Uram kew su apey kenà kew meekali dut te menge etew ne metau ne edliyuk. ");
INSERT INTO mbi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Su merakel se edlepew ne engkunkun te siaken en ne egkahi ran te, ‘Siaken en ini ke Impasad te Eleteala ne Ebperetuen te langun ne menge etew!’ Ne ketà,” ke si Hisus, “ne merakel ne menge etew se ebpekeperetiyaya te tarù dan. ");
INSERT INTO mbi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ne embiya egkerineg niyu se ebpevunbunuey riyà te meriyù merani ne kenà kew meandek. Su ini pà iya se egkeuna ne egked-ulaula, ugaid ne warà pà meuma ke hewii te kebpupusa kayi te dunya. ");
INSERT INTO mbi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Su ebpemekebunuey pà ke idsenge inged, ne engketà ded dema ke idsenge retuan. Ne edlinug te mevaher te piya endei en, ne egetab se bitil. Ugaid ne rudsuan dà ini dut te keresayan ne egeramen niyu, iring dut te belilit te meritan ne ed-anak. ");
INSERT INTO mbi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ne sikiyu, ne ingat kew nevenar su ebpenigkemen kew te menge etew ne ibpepemenayik kew riyà te valey te kukuman. Ne ebpenruuhen kew riyà te valey ne ebpengedian te penduan te menge Hudiyanen, ne ebpeneheewiten kew riyà te menge egkeunutan wey harì te inged su atag dut te kedsarig niyu kediey, ugaid ne ini en imbe ke ralan te kebpekepesabut niyu kandan dut te Meupiya ne Tudtul mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Su iyan pà ibpeuna ibpesabut ini se Meupiya ne Tudtul dut te langun ne menge etew kayi te ampew te dunya te kenà pà egkeuma ke hewii te kebpupusa kayi te dunya. ");
INSERT INTO mbi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne ketà te edsigkemen kew ne ebpeneheewiten kew riyà te kukuman, ne kenà kew meuru ke ebmemenuwen niyu se kedlalag niyu te kedtindeg te hinawa niyu su ketà ne iyan niyu rà egkekahi ne lalag ne ibpekahi keniyu su riyà ebpuun te Kedesenan ne Ebpetuntul te Menusiyà ne kenà kayi rà ebpuun te itungan niyu rà dè duen. ");
INSERT INTO mbi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Su ketà ne hewii ne ruen menge etew ne misan ke temperà dan te pused ne ed-uluhen dan su ebpeimetayan, ne iring din ded dema ke ed-ul-ulaan te amey dut te menge anak dan. Ne ruen menge anak ne ebpekid-atu te menge lukes dan su ebpeimetayan dan. ");
INSERT INTO mbi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ne egkeepesan kew dut te langun ne menge etew su atag te keduma niyu kediey. Ugaid ke etew ne misan egkerasey sikandin ne kenà edsuwey dut te keduma rin kediey taman te ini pà sikandin te ampew te dunya, ne ebpekehaked te umur ne kenà edtaman.” ");
INSERT INTO mbi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ne embiya egkekita niyu en ini se “Ebpekekaid ne Kunterà ku” diyà te lusud te Nekebpuru ne Valey te Eleteala ke warà iluhut kandin, ne sikiyu riyà te pruvinsiya te Hudiya ne pelahuy kew riyà te buvungan. (Sikiyu ke ebpekevasa kayi ne pegpegitunga niyu ke meana rin ini.) ");
INSERT INTO mbi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ne ke etew ne riyà te ruwangen te valey rin ne kenà din en lilingaya ke keleglahan din su mebpelahuy en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ne ke etew ne riyà te pengengewiren din, ne kenà en med-ulì se egkuwa te kumbalà din. ");
INSERT INTO mbi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ne egkeyruwan ke menge meritan ne mehingey te arà ne hewii wey ke menge meritan ne edseruru. ");
INSERT INTO mbi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipengeningeni niyu te Eleteala te kenà ini med-ulaula te hewii te kedrengreng. ");
INSERT INTO mbi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Su ini se kemeresayan ne ebpekeuma ne warà repeng din igenat dut te aney en limbaha te Eleteala ini se dunya, ne kenà en egkerepengan te misan keenu. ");
INSERT INTO mbi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ugaid ne sabap dut te raat te nanam te Eleteala ne migkurangan din en ke menge hewii rut te kemeresayan su embiya warà, ne warà en egkesamà ne biviyag. Uya, su geina te rekelà ke limù din dut te menge etew ne mibpemilì din, ne migkurangan din ke menge hewii rut te kemeresayan. ");
INSERT INTO mbi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Su ketà ne hewii embiya ruen egkahi keniyu te, ‘Ini en ke Impasad te Eleteala ne Ebperetuen din te langun ne menge etew!’ etawa ruen egkahi te, ‘Ayan en sikandin!’ ne kenà kew peretiyaya su apey kenà kew egkelimbungi. ");
INSERT INTO mbi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Su ruen ebpenlepew ne menge etew ne engkunkun te sikandan ke Impasad te Eleteala ne Ebperetuen etawa sikandan ke ebpelambas te Lalag te Eleteala. Ne ebpekita dan te mekegeyip ne ed-ul-ulaan su apey ran perem meekali ayan se menge etew ne mibpemilì te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tembù be idtarem ku ini,” ke si Hisus, “su apey niyu meingati te kenà pà ini egked-ulaula.” ");
INSERT INTO mbi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ne ebpeketundug be ketà te egkeipus ke hewii te kemeresayan,” ke si Hisus, “‘Ne ebmerusirem ke andew, ne kenà en edsilà ke vulan, ");
INSERT INTO mbi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ne ebpengeulug ke menge bituen diyà te langit, ne egkeparin dut te netehuan dan ke edtenuran ne menge bituen.’ ");
INSERT INTO mbi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ne ketà be ne egkekita niyu se kedlived dut te Impeanak te Menusiyà, ne egkerumaan te sehulapun, ne egkekita niyu ke gehem din wey raman din ne ed-anlag. ");
INSERT INTO mbi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne edsuhuen din diyà te epat ne pediyulu kayi te dunya ini se menge suluhuen din su apey ran egkevurun ke langun ne menge etew ne mibpemilì te Eleteala igenat te pehiliran taman te binunsuran.” ");
INSERT INTO mbi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Keniyan niyu rè ma te kayu ne Igira,” ke si Hisus, “su ruen ibpenurù din keyta. Embiya nekepasad en te edrewrew ne ed-umbus en wey ebpeneringsing, ne tuus te ed-andew en. ");
INSERT INTO mbi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ne iring din ded dema embiya egkekita niyu en se netuman en ke langun ne tuus ne impenurù ku keniyu, ne egketuenan niyu te mehaan en se kedlived dut te Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tentenuri niyu ini se egkehiyen ku keniyu, su ruen pà kayi te keniyu guntaani ebpekesaut pà ketà te kegketuman din ini. ");
INSERT INTO mbi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Su egkeawà ini se langit wey tanà, ugaid ne ini se migkahi ku ne kenà bulug ebperis.” ");
INSERT INTO mbi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ugaid ne ini se idtarem ku keniyu,” ke si Hisus, “warà netau te hewii etawa endei egketahù ke andew ke edlived kayi ke Impeanak te Menusiyà su ke Amey ku rà ne Eleteala. Misan ke suluhuen te Eleteala diyà te langit wey misan dema siaken ke Anak te Eleteala ne warà netau ke keenu se kedlived din. ");
INSERT INTO mbi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Uram kew ve ne penehana kew en, su warà niyu metueni ke hewii ne egkeuma ini. ");
INSERT INTO mbi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Su ini se hewii te kedlived din kayi ne iyan ta ed-upamaan ne etew ne mid-ipanew riyà te meriyù ne inged ne warà din kehiya ke keenu ed-ulì. Ne ruen sugsuhuen din ne pinetuganur din te valey rin te warà pà migenat, ne ruen helevek ne imbehey rin te uman seveka. Ne migkehiyan din ke tumetameng te eheran te mebpekevantey nevenar. ");
INSERT INTO mbi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ne sikiyu,” ke si Hisus “ne iring kew rut te tumetameng te eheran ne pekevantey kew su warà niyu metueni ke hewii te edlived din ini se kemuney te baley, ke embiya meapun be, ke edluuk be se kerukileman, ke ebpengelet en be ke manuk, etawa ve ke edsilà en ke andew. ");
INSERT INTO mbi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tembù be uram kew, su embiya ebpeketekew ebpekeuma sikandin ne iyan din kemeyidan ne kenà kew nikandin egkeumaan se edlipereng. ");
INSERT INTO mbi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ini se egkehiyen ku keniyu ne igkahi ku red dema diyà te langun ne menge etew te mebpekevantey ran te kedlived ku kayi.” ");
INSERT INTO mbi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Deruwa pà ne hewii ne egkeuma ke kevurunan ne edtenuran tew ne ed-ingaranan te Pista te Kedsehari te Suluhuen dut te menge apù tew rengan wey ke Pista te Kegkaan dan te Pan ne Warà Idsawug ne Ibpelevag. Ne ebpemengà ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan te ralan te kedsigkem dan ki Hisus te kenà egketuenan dut te menge etew apey ebpeimetayan dan en. ");
INSERT INTO mbi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne mibpelelelahey ran te, “Kenà ta ini ed-ul-ulaan dut te kevurunan te pista su kema ke egkekita rut te menge etew ne egkeepes dan keytew ne egkehuvut en ketà.” ");
INSERT INTO mbi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Guna su riyà si Hisus te inged ne Bitanya ne riyà sikandin te valey ni Simon, senge etew ini ne kevuwaen muna pà te it-it ne neulian. Gewii te egkaan si Hisus ne nekeuma en ini se meritan ne mid-ewit te pelenaan ne mibeelan te elibastru, ne midtehuan te periyemut ne mepurù nevenar su mibeelan dut te lunsey ne Nardu. Ne mid-uvey en kandin, ne imbusbus din en ke periyemut kayi te ulu ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne ruen menge etew ketà ne neepes ne mibpelelelahey ran te, “Babeba! Meambe ke midereetan din dà ini se periyemut? ");
INSERT INTO mbi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iyan tumù ne indahang din ini ne igkepemehey pà diyà te menge ayuayu su labi tetelu nehatus ne pirak se elehà din!” ke sikandan. Ne nesewayan dan ini se meritan. ");
INSERT INTO mbi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ugaid ne migkahi si Hisus te, “Pedteraya niyu sikandin! Meambe ke edsewayan niyu sikandin? Su meupiya nevenar ini se mid-ulaula rin kediey! ");
INSERT INTO mbi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Su ke menge ayuayu ne lelayun kew red ebpemekeduma ne egketevangan niyu sikandan, ugaid ne siaken ne kenà ad meuhet kayi te keniyu. ");
INSERT INTO mbi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Su ini se meritan,” ke si Hisus, “ne mid-ulaula rin en ke taman ne egkegaga rin, su mibperiyemutan din en ke lawa ku te kebpenehana te kedleveng kediey. ");
INSERT INTO mbi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sevenarbenar ini se egkehiyen ku keniyu,” ke si Hisus, “te misan endei kayi te ampew te dunya ibpesabut ini se Meupiya ne Tudtul mekeatag kediey, ne egkepenudtul ded dema ini se mid-ulaula rin kediey ne kenà egkelipatan.” ");
INSERT INTO mbi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ne ketà ne si Hudas Iskeriyuti, seveka rut te sepulù wey deruwa ne edumdumaan ni Hisus, ne mibpendiyà te menge mepurù te terebpelengesa su igkahi rin kandan te egkeulug en si Hisus diyà te kandan. ");
INSERT INTO mbi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Guna su nerineg dan ne nengesuatsuat dan nevenar, ne impasad dan kandin te ebehayan te pirak. In-awà dè be ketà ne ebpemengaan en ni Hudas ke ralan te kegkeulug din ki Hisus su apey mesigkem dan en. ");
INSERT INTO mbi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne ketà te egkeuma ne hewii te Pista te menge Hudiyanen te kegkaan dan te Pan ne Warà Insawug ne Ibpelevag, ne edsusumbalì dan te nati te bilibili ne egkeenen dan te kedtenuri ran dut te hewii rengan te Kedsehari te Suluhuen dut te menge Apù dan. Ne mid-insaan si Hisus dut te menge edumdumaan din te, “Endei rey ve ini ebpegetura se idlavung tew te Pista te Kedsehari te Suluhuen?” ");
INSERT INTO mbi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne ketà ne midsuhù ni Hisus se deruwa rut te menge edumdumaan din se egkahi te, “Una kew en be riyà te inged ne ruen ne edsinuhung keniyu ne meama ne ed-utuk te kelalew ne ruen wayig din. ");
INSERT INTO mbi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tundug kew en be kandin, ne embiya ebpekeuma kew riyà te ed-ubpaan din ne kehiyi niyu ve ke kemuney te valey te, ‘Ibpeinsà dut te meyterù tew te, Endei ne ruhu ke edlevungan ku wey ke menge edumdumaan ku dut te Pista te Kedsehari te Suluhuen?’ ");
INSERT INTO mbi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne ketà ne ibpekita rin keniyu ke meluag ne ruhu diyà te ikeruwa ne pangkat ne saag ne nepegediran en, ne ketà kew be pegatur te idlavung tew.” ");
INSERT INTO mbi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Arà dà se nerineg dan ne mid-ipanew en ini se deruwa ne edumdumaan ni Hisus se ebpendiyà te inged, ne langun dut te ingkahi kandan ni Hisus ne arè en iya rema se nekita ran. Ne ketà dan en mibpegatur te idlavung dan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Guna su merukilem en ne nekeuma en si Hisus wey ke sepulù wey deruwa ne menge edumdumaan din ketà te valey. ");
INSERT INTO mbi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ne gewii ran te egkaan ne migkahi si Hisus te, “Benar ini se egkehiyen ku keniyu, ruen senge etew kayi te keniyu se ed-ulug kediey su apey a meimetayi.” ");
INSERT INTO mbi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Guna su nerineg dut te menge edumdumaan din ini, ne mibmerungkug dan ne uman senge etew ne mid-insà te, “Entei, kenà ma siaken?” ");
INSERT INTO mbi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Midtavak si Hisus te, “Senge etew keniyu rut te sepulù wey deruwa ne ebpekidtuhen te edeluwit te pan din kayi ke ed-ulug kediey. ");
INSERT INTO mbi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Su egkeimetayan ke Impeanak te Menusiyà iring dut te nekahi te impesurat ne Lalag te Eleteala rengan, ugaid ne meraat nevenar se egketemanan din ini se etew ne ed-ulug kandin su iyan pà tumù ne warà sikandin ianak.” ");
INSERT INTO mbi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gewii te egkaan dan ne migkuwa ni Hisus ini se egkeenen dan ne pan ne impeselamat din te Eleteala, ne mibpenevìtevì din ne imbehey rin diyà te menge edumdumaan din se egkahi te, “Kua niyu ini, su ini ke lawa ku.” ");
INSERT INTO mbi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne ketà ne migkuwa ni Hisus ke ed-inumen ne impeselamat din te Eleteala ne imbehey rin kandan, ne langun dan ne mid-inum ketà. ");
INSERT INTO mbi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Ini ke lengesa ku,” ke si Hisus, “ne ebpeketudà ne ibavas te menge etew, su tuus ini te egketuman en ke impasad te Eleteala rengan te ebpekepelihaun en ke menge etew dut te keberedusaan dan. ");
INSERT INTO mbi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Benar ini se egkehiyen ku keniyu te kenà ad maa ed-inum kayi te ed-inumen ini taman te kenà egkeuma ke hewii keuremà te kedatù te Eleteala ne egkevehu en ke ed-inumen tew.” ");
INSERT INTO mbi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Arà dà ne mideyù dan ke Eleteala te kanta ran ne midlihawang dan en ne riyà dan en mebpesinaru te buvungan ne ed-ingaranan te Ulivuwen. ");
INSERT INTO mbi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ne migkahi pà maa si Hisus dut te edumdumaan din te, “Langun niyu ne ebpelahuy ne edtehaken a niyu su ruen Lalag te Eleteala ne impesurat din ne egkahi te, ‘Ebpeimetayan ku ke tumetuganur dut te menge bilibili, ne egerunsuwey ke menge bilibili rin.’ ");
INSERT INTO mbi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ugaid,” ke si Hisus, “embiya egkevanew ad, ne ed-una ad keniyu riyà te inged ne Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ne migkahiy si Pedro te, “Misan edtehaken ka rut te langun dan, ne siaken ne kenà!” ");
INSERT INTO mbi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ugaid ne migkehiyan sikandin ni Hisus te, “Tentenuri nu ini te kenà pà ed-ukarà ke manuk te kereruwa te ini en ne kerukileman, ne ketetelu nu en ibparew te kenà a nu ruma.” ");
INSERT INTO mbi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ugaid ne warà mebpehimbenar si Pedro se egkahi te, “Kenà a ebpekekahi te iring ketà te kenà ki teleduma misan ebpekeunung a keykew te ed-imetayan.” Ne iring ded dema ketà ke migkahi rut te menge ruma rin. ");
INSERT INTO mbi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nekeuma ran en diyà te inged ne ed-ingaranan te Gitsimani ne migkehiyan ni Hisus ke menge edumdumaan din te, “Pinuu kew rè be kayi gewii ku te ebpengeningeni.” ");
INSERT INTO mbi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne miduma rin si Pedro ki Santiago wey ki Juan diyà te unaan. Ne nemutu nevenar sikandin wey nerurunù ke hinawa rin. ");
INSERT INTO mbi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne migkahi sikandin kandan te, “Merasey nevenar ini se hinawa ku su iring te egkevidtew en. Kayi kew rè be ne kenà kew lipereng kediey.” ");
INSERT INTO mbi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne midlaus pà sikandin diyà te unaan dan ne midlangkeb en se ebpengeningeni te Eleteala te embiya egkepakey rà ne kenà ibpepevayà kandin ini se kemeresayan. ");
INSERT INTO mbi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne ini se migkahi rin te kebpengeningeni rin, “Amà, su sikew se Amey ku, netuenan ku te egkegaga nu ke langun! Ne embiya egkiyug ke rà ne iawà nu ini se keresayan ku, ugaid ne misan iring en ketà se kiyug ku ne iyan nu tumana ke keykew ne kiyug.” ");
INSERT INTO mbi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Neiseg-iseg ketà ne midliveran din ke tetelu ne etew ne edumdumaan din ne iyan din neumaan se nekelipereng dan. Ne migkehiyan din en si Pedro te, “Simon, maa nekelipereng ke ves? Maa, kenà ka ebpeketigker misan mehaan dà? ");
INSERT INTO mbi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kenà kew edlipereng, ugaid ne pengeningeni kew,” ke si Hisus, “su apey kenà kew ebpekeruma kayi te ebpenggeram keniyu. Su mevaher perem ke hinawa niyu te edtuman te lalag ku, ugaid ne midtaman dè be te kenà eduma ke lawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne mid-awà en maa si Hisus se ebpengeningeni te iring ded ketà te neuna ne pengeningeni rin. ");
INSERT INTO mbi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ne ketà ne midlived maa sikandin kayi te tetelu ne edumdumaan din ne iyan din neumaan se nekelipereng dan su midseharan dan te turug. Ne warà dan metau ke engkey se egkehiyen dan. ");
INSERT INTO mbi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Guna su midlived en sikandin kayi te menge edumdumaan din te iketelu rin en te ebpengeningeni ne migkahi en te, “Maa, nekelipereng kew pè bes lavew? Sesangen en ayan! Su ini en ke ked-uluha dut te Impeanak te Menusiyà diyà te palad te menge etew ne beniyagà. ");
INSERT INTO mbi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enew kew,” ke si Hisus, “su ini en ke etew ne ed-ulug kediey. Kuwa kew en su edtelavuk ki.” ");
INSERT INTO mbi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gewii te edlalag pà si Hisus ne nekeuma en si Hudas, senge etew ini rut te sepulù wey deruwa ne edumdumaan din. Ne nerumaan dut te merakel ne menge etew ne midmemetarem dan te menge sundang wey menge behuval, su midsuhù dan dut te menge mepurù te terebpelengesa, ke menge meyterù te penduan, wey ke menge egkeunutan te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ugaid ketà te warà den pà med-ipanew ne ruen ingkahi ni Hudas kandan te, “Ke etew ne ed-uveyan ku ne ed-erekan ku ne arà imbe ke ebpemengaan niyu. Sigkema niyu ne pekeventayi niyu nevenar te ked-ewit niyu.” ");
INSERT INTO mbi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nekeuma rà si Hudas, ne mid-uvey rin si Hisus se egkahi te, “Na Meyterù!” Ne arà pà ne mid-erekan din. ");
INSERT INTO mbi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ketà ne migeweran dan en si Hisus ne midsigkem dan en. ");
INSERT INTO mbi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ugaid ne ruen senge etew diyà te uvey ran ne mid-ulavut te sundang din ne midtibas din en ke sugsuhuen dut te Pinekebmepurù te Terebpelengesa ne nesempingan en te telinga rin. ");
INSERT INTO mbi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ne migkahi si Hisus dut te menge etew ne midsigkem kandin te, “Maa, tulisan a ne ebmetereman niyu te sundang wey behuval te edsigkem kediey? ");
INSERT INTO mbi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Su uman ded ma hewii ne riyan a te Nekebpuru ne Valey te Eleteala se ebpenurù,” ke si Hisus, “ne warà a ma nikiyu sigkema ketà. Ugaid ne egked-ulaula ini su apey egketuman en ke Lalag te Eleteala ne impesurat dengan.” ");
INSERT INTO mbi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Arà dà ne mibpelahuy en ke menge edumdumaan din ne mintahaky dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ne ruen kenakan ketà ne migkukumbung te malung dà se edtundugtundug ki Hisus. Gewii te ked-ewita ran ki Hisus ne idragkes dan perem te edsigkem sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ugaid ne mibpelahuy sikandin te warà seseberen din su neluung ke malung din te kineheweri ran kandin. ");
INSERT INTO mbi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ne mid-ewit dan si Hisus diyà te baley te pinekemepurù dut te menge terebpelengesa su rutun egkevurun ke menge mepurù te terebpelengesa, ke menge egkeunutan te menge Hudiyanen, wey ke menge meyterù te penduan. ");
INSERT INTO mbi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ne midtutundugtundug en si Pedro kandan taman te nekeuma sikandin diyà te lama te valey dut te pinekemepurù te menge terebpelengesa. Na kayi mibpekid-amur en mibpinuu dut te menge bantey te valey se ed-inarang. ");
INSERT INTO mbi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne ini se menge mepurù te terebpelengesa wey ke menge egkeunutan te menge Hudiyanen ne nevurun kayi, ne mibpegelep dan mibpemengà ke engkey se id-isuhat dan ne kewagib ki Hisus su apey ran egkeimetayi, ugaid ne warà netuen dan. ");
INSERT INTO mbi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Merakel se in-isuhat dan ne kewagib kandin, ugaid ne warà memeked-ayun su mibèbeelan dan dè ma. ");
INSERT INTO mbi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne ruen en maa menge etew ne mid-etuvang ki Hisus su ed-isuhat kandin te kenà benar se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nerineg dey,” ke sikandan, “se egkahi ini se etew te, ‘Egkerundus ku ini se Nekebpuru ne Valey te Eleteala ne mibeelan te etew, ugaid ne ketà te tetelu ne hewii ne igkepeitindeg ku en ke behu ne valey ne kenà bineelan te etew.’” ");
INSERT INTO mbi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ugaid ne misan engkey en kandan se egkahi ne kenà ebpemeked-ayun. ");
INSERT INTO mbi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ketà ne mid-itindeg en ke pinekemepurù te menge terebpelengesa ne migkehiyan din si Hisus te, “Engkey ve se keykew ne egkekahi? Engkey, benar ini se id-isuhat dan ne kewagib keykew?” ");
INSERT INTO mbi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ugaid ne mibpeeneng-eneng dà si Hisus. Ne migkahi pà maa ini se pinekemepurù dut te menge terebpelengesa te, “Maa, sikuna en iya ini ke Anak te Eleteala ne midtendù din ne ebperetuen din?” ");
INSERT INTO mbi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ne midtavak si Hisus te, “Uya, siaken en iya. Ne egkekita niyu red keuremà ke Impeanak te Menusiyà ne ebpekepinuu riyà te egkekewanan te Eleteala ne warà repeng te gehem din. Ne ketà te kedlived din a kayi ne egkekita niyu en te edumaan te sehulapun.” ");
INSERT INTO mbi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nerineg dà dut te pinekemepurù te menge terebpelengesa ke migkahi ni Hisus ne mibisey rin ke velegkas din te kegkeepes din ne migkahi en te, “Kenà ki en ebpemengà te ruma pà ne titihus! ");
INSERT INTO mbi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Su nerineg niyu en ini se kedsumpalit din! Ne engkey en be se keniyu ne kukuman?” Ne langun dan ne mid-isuhat kandin te kewagib ne ebpeimetayan. ");
INSERT INTO mbi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ne ruen en ketà se mibpengileb ki Hisus, ne ruen duma ne mibegkesan ke mata rin ne midsuntuk dan en se egkahi te, “Entuka nu ke entei se midsuntuk keykew.” Ne migkuwa sikandin dut te menge sundaru ne ebantey kandin ne mibpenabpì dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ne riyà pà lavew te lama te valey te Pinekemepurù te Terebpelengesa si Pedro, ne ruen meritan ne edsugsuhuen ketà te valey ne mid-uvey kandin. ");
INSERT INTO mbi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nekita rin si Pedro se ed-in-inarang ne mibpeut-utengan din te edtengteng se egkahi te, “Sikuna rema ne ruma ka ni Hisus ke ebpuun te Nasarit.” ");
INSERT INTO mbi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ugaid ne mibparew sikandin se egkahi te, “Kenà ku egketuenan, kenà ku egkesebutan ayan se egkehiyen nu.” Ne mid-ip-ipanew sikandin se ebpependiyà te bengawan te lama ne arà dà ne ruen mid-ukarà ne manuk. ");
INSERT INTO mbi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nekita en maa si Pedro dut te meritan ne migkahi en sikandin diyà te menge etew ne nevurun ketà te, “Ayan se etew ne teleduma ki Hisus.” ");
INSERT INTO mbi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nerineg ni Pedro ne mibparew rin ded maa. Neiseg-iseg manen ne migkahi ke menge etew ketà ki Pedro te, “Benar iya ne teleduma kew su egketuusan te riyà ka ebpuun te Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne migkahi si Pedro te, “Dusa kedì te Eleteala embiya teleduma key keniyan te etew ne egkehiyen niyu!” ");
INSERT INTO mbi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Arà dà iya ne mid-ukarà en ke manuk te ikeruwa. Ketà ne netenuran ni Pedro ke migkahi ni Hisus kandin te, “Kenà pà ed-ukarà ke manuk te kereruwa te ini en ne kerukileman ne ketetelu a nu en ibparew te kenà ki teleduma.” Ne midrahukrahuk en si Pedro te kedsinehew rin. ");
INSERT INTO mbi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Guna su mesmeselem pà ne nevurun en ke menge mepurù te terebpelengesa, ke menge egkeunutan te menge Hudiyanen, ke menge meyterù te penduan, wey ke ruma pà ne egkedserihan dan te menge Hudiyanen ne neumpung dan en ke engkey se ed-ul-ulaan dan ki Hisus. Ne mibakù dan si Hisus ne mibpeneheewit dan sikandin diyà te ki Pilatu, ke gubinedur te Ruma. ");
INSERT INTO mbi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ne mid-insaan en ni Pilatu si Hisus te, “Menu, sikuna en iya ke ratù te menge Hudiyanen?” Midtavak ni Hisus te, “Uya, ayan iya se migkahi nu.” ");
INSERT INTO mbi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne merakel se in-isuhat ne kewagib dut te menge mepurù te terebpelengesa ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ne ketà ne migkahi en maa si Pilatu ki Hisus te, “Menu, kenà ke en be edtavak kayi te in-isuhat dan kenikew? Su merakel ini!” ");
INSERT INTO mbi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ugaid ne warè en megkahikahi si Hisus, ne ketà ne neinuinu nevenar si Pilatu. ");
INSERT INTO mbi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ne iyan nelayaman ni Pilatu te uman egkeuma ke Pista te Kedsehari te Suluhuen ne ruen ibpelihawang din ne senge etew ne vilanggù ne ebuyuen dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne ketà ne hewii ne ruen senge etew ne nevilanggù ne ed-ingaranan ki Barabas su mid-amung sikandin te ebpekidkunterà te gubirnu ne ruen nepatey rin. ");
INSERT INTO mbi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Guna su mid-uvey en ke menge etew ki Pilatu su ebuyuen dan te ibpelihawang din ini se senge etew ne vilanggù iring dut te raan ne betasan din. ");
INSERT INTO mbi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne mid-insà si Pilatu te, “Menu, egkiyug kew ve te ibpelihawang ku ini se ratù niyu te menge Hudiyanen?” ");
INSERT INTO mbi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iyan din migkahi ini su netuenan din se ini se id-isuhat ne kewagib ki Hisus dut te menge mepurù te terebpelengesa ne sabap dut te kegkesihi ran kandin. ");
INSERT INTO mbi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ugaid ne migkumbida dut te menge mepurù te terebpelengesa ke menge etew te iyan dan ibpevuyù ne ibpelihawang si Barabas, kenà si Hisus. Ne arà en iya rema ke mibuyù dan. ");
INSERT INTO mbi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne migkahi en maa si Pilatu te, “Embiya arà se egkiyuhan niyu, ne ebmemenuwen ku be ini se ed-ingeranan niyu ne ratù niyu te menge Hudiyanen?” ");
INSERT INTO mbi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne mibpemensag den dà te, “Ibpelansang nu sikandin diyà te ebpebelevahen ne kayu!” ");
INSERT INTO mbi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Meambe?” ke si Pilatu. “Engkey se meraat ne mid-ulaula rin?” Ugaid ne nasì en be ne mid-iseg pà se kebpemensag dan te, “Ibpelansang nu sikandin diyà te ebpebelevahen ne kayu!” ");
INSERT INTO mbi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ketà ne impelihawang en ni Pilatu si Barabas su apey igkesuat sikandin dut te menge etew. Ne si Hisus embe ke imperuug din en ne imbehey rin en kandan te ibpelansang diyà te pinebelavag ne kayu. ");
INSERT INTO mbi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ne mid-ewit en te menge sundaru si Hisus diyà te lamalama te turuhan te gubinedur ne midtawag dan ke langun ne menge sundaru. ");
INSERT INTO mbi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne pinelelembung dan si Hisus te merihà su uvag kun ne ratù, ne ruen impetengkulu kandin ne mibeelan dan ne ruhiyen ne wahed. ");
INSERT INTO mbi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne uvag kun ed-adat dan kandin se egkahi te, “Mebereumur ka ne ratù te menge Hudiyanen!” ");
INSERT INTO mbi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne mibedasan dan ke ulu rin, ne mibpengilevan dan sikandin, ne midlangkeb dan diyà te etuvangan din su uvag kun se ebpengerap dan. ");
INSERT INTO mbi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Guna su neipus ke kedsumpalit kandin, ne midluung dan en ke merihà ne impelelembung kandin ne inseluub dan ded ke kandin ne belegkas ne mid-ewit dan en sikandin diyà te ebpelensangan kandin. ");
INSERT INTO mbi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Guna su riyà dan en te ralan te kebpeneheewita ran en kandin, ne ruen etew ne ed-ingaranan ki Simon ne nesinuhung dan ne iyan pà ebpekeuma ne riyà ebpuun te taneb, ne mibpehes dan te ibpetiang ke pinebelevag ne kayu ne edtiangen ni Hisus. (Si Simon ini ne riyà ebpuun te Sirini, ke amey ni Alejandro ki Rufo.) ");
INSERT INTO mbi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne mid-ewit dan en si Hisus diyà te rapit ne ed-ingaranan te Gulguta, ne iyan din meana ne “Tulan te Ulu.” ");
INSERT INTO mbi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne ketà ne ebpeinumen dan perem si Hisus te binu ne midsewuhan dan te vawì ne ed-ingaranan te mira, ugaid ne warà din inuma. ");
INSERT INTO mbi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Arà dà ne inlansang dan en si Hisus diyà te pinebelavag ne kayu. Neipus dan ne mibunutbunutan dan ke velegkas din ke entei se ebpekegkemuney kandan. ");
INSERT INTO mbi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ne ketà ne menge siyew en ne uras te keseleman te kedlansang dan ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne insurat dan ke in-isuhat dan ne kewagib ki Hisus se egkahi te, “Ke ratù te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ne ruen deruwa ne tulisan ne inlansang dan dema duma ki Hisus, seveka kayi te egkekewanan din, ne seveka kayi te egkehivang din.  ");
INSERT INTO mbi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ini se ned-ulaula apey metuman ke impesurat ne Lalag te Eleteala rengan ne egkahi te, “Iyan dan pegitungan ne ruma sikandin te menge tulisan.” ");
INSERT INTO mbi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ke menge etew ne midsahad kandin ne mibpendungkàdungkà dan te ked-undaunda ran kandin se egkahi te, “Na, endei embe ke migkahi nu ne edrundusen nu ini se Nekebpuru ne Valey te Eleteala, ne ketà te tetelu ne hewii ne igkepeitindeg nu manen te vehu pà? ");
INSERT INTO mbi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na ed-intengan ta kun imbe ke ruen ketehel nu, ibpelihaun nu ke hinawa nu ne pemenaug ke en keniyan te midlensangan keykew.” ");
INSERT INTO mbi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne iring ded dema ketà ke ked-undaunda rut te menge mepurù te terebpelengesa wey ke menge meyterù te penduan se ebpelelelahey ran te, “Nekepelihaun kun sikandin te menge ruma rin, ugaid ne ke kandin en ne hinawa ne kenà din egkegaga. ");
INSERT INTO mbi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na kun be imbe embiya sikuna ke Impasad te Eleteala ne Ebperetuen, ke ratù te menge Hudiyanen, ne pemenaug ke en keniyan te midlensangan keykew su apey key ebpekeperetiyaya.” Ne misan dema ke deruwa ne inlansang diyà te idsengeriveluyà din ne elin en ne ed-undaunda. ");
INSERT INTO mbi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ketà te neudtu en ke andew ne mibmerusirem en ke tivuuk ne dunya lusud te tetelu ne uras. ");
INSERT INTO mbi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Guna su tetelu en ne uras ne migkuleyì si Hisus te merahing se egkahi te, “Ili, ili, lama sebaktani?” Ne iyan din meana se, “Ey, Eleteala ku, Eleteala ku, meambe ke mid-ewaan a nu?” ");
INSERT INTO mbi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Duen menge etew ketà ne nekerineg kandin ne migkahi te, “Pemineha niyu ma su ebpengumawen din en si Elias.” ");
INSERT INTO mbi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Senge etew ketà se midahewrahew migkuwa kayi te in-ered te tebà ne midtiyuk din en te deisek ne terekayu. Ne ketà ne insugkar din diyà te bèbà ni Hisus su apey rin meesep ne midlalag, sikandin kayi te menge ruma rin te, “Na ed-intengan tew ve ke edlepew si Elias se ebpeawà kandin ketà.” ");
INSERT INTO mbi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne migkuleyì en maa si Hisus te merahing ne nependusan en sikandin te hinawa. ");
INSERT INTO mbi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Diyà te Nekebpuru ne Valey te Eleteala ne ruen mekepal ne saput ne impehelet dut te insivey ne ed-ubpaan te Eleteala, ne ketà te kinepatey ni Hisus ne nevindas kayi te luuk ini igenat te divavew taman te diralem. ");
INSERT INTO mbi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ne ini se kepitan te sundaru ne ed-it-itindeg kayi te egkesineruwan ni Hisus, ne guna su nerineg din ke kegkuleyì ni Hisus wey nekita rin ke ned-ulaula te kebpatey en ni Hisus ne nekekahi sikandin te, “Benar ini ne Anak te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ne ruen dema ketà menge meritan ne nekeitindeg diyà te malù meriyù su edtengteng ki Hisus, elin ketà si Maria Magdalina, si Salumi, wey si Maria ke iney ni Jose ki Santiago ke ari rin. ");
INSERT INTO mbi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mibpekiduma ran en ki Hisus su edtavang dan kandan gewii te riyà dan pà te Geliliya. Ne ruen pà ruma ne menge meritan ne mibpekiduma kandan te kebpendiyà dan en te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ne ini se kinepatey ni Hisus ne meapun te Diyemaat ne ini ke hewii te menge Hudiyanen te kebpenehana ran dut te Hewii ne Id-imeley ran. Guna su malù en edsanlep ke andew, ne nekeuma en si Jose ke ebpuun te Eremetiya. ");
INSERT INTO mbi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Senge etew ini ne egkeedatan dut te menge egkeunutan te menge Hudiyanen, ne seveka red dema sikandin ne ebpenareng dut te kegketuman te impesurat ne Lalag te Eleteala mekeatag te kedetui rin te menge etew kayi te ampew te dunya. Mibpengarew en se ebpendiyà te ki Pilatu ne mibuyù din ke vangkey ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Guna su mibuyù en ni Jose ke vangkey ni Hisus, ne neinuinu si Pilatu su kunean din ke warà pà minatey si Hisus. Ketà ne midtawag din ke mepurù te menge sundaru su id-insà din ke minatey en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Guna su nerineg ni Pilatu ke migkahi rut te mepurù te sundaru, ne migkehiyan din en si Jose te egkepakey ne egkuan din ke vangkey ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Arà dà ne mid-ipanew en si Jose su ebpemasa te meputì ne saput ne ibukus dut te bangkey ni Hisus te kedleveng kandin, ne migkuwa rin en ke vangkey ne mibukusan din en ketà te saput. Nepasad din ne inleveng din en ketà te imbangbang ne leveng diyà te dempilas. Dutun ne ruen dekelà ne vatu ne midlilid din ne inlekeb ketà te bengawan te leveng. ");
INSERT INTO mbi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ne nekita en ni Maria Magdalena wey si Maria ke iney ni Jose ke langun ne mid-ulaula rin wey endei rin inleveng ke bangkey ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Guna su neipus en ke Hewii te Id-imeley ne mibpemasa ensi Maria Magdalena, si Salumi, wey si Maria ke iney ni Santiago te periyemut su ebpendiyà dan te midlevengan ki Hisus su ebperiyemutan dan ke lawa rin. ");
INSERT INTO mbi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mesmeselem pà te hewii ne Akad ne mibpendiyà dan en te midlevengan ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Gewii ran te ed-ip-ipanew ne mibpengasak dan te, “Engkey se ebpeliliren tew rut te batu ne inlekeb dut te leveng din?” ");
INSERT INTO mbi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(Su dekelà nevenar ini se vatu.) Nekeuma ran ne nekita ran te nelilid en ke vatu ketà. ");
INSERT INTO mbi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne mid-awuk dan en ne iyan dan nekita ne menguwed ne meama ne mibevelegkas te meputì ne riyà mebpinuu te egkekewanan dan, ne nengeandek dan. ");
INSERT INTO mbi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne migkahi en ini se suluhuen te, “Kenà kew meandek!” ke sikandin. “Ebpemengà kew ki Hisus ne ebpuun diyà te Nasarit ne inlansang dan te pinebelevag ne kayu, ugaid ne warè en kayi su nevanew en. Intengi niyu ma ini se midtehuan dan kandin. ");
INSERT INTO mbi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, ipanew kew en ne penudtula niyu ve riyà te menge edumdumaan din abpeg ki Pedro te, ‘Si Hisus ne ed-una en keniyu riyà te Geliliya, ne riyà niyu en egkekita sikandin su arà ke impasad din rengan keniyu.’” ");
INSERT INTO mbi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Arà dà ne midlihawang dan en se ebpelelahuy su nekiyab se atey ran te kegkeandek dan. Ne warà dan kegkehiya te misan entei en su neandek dan.  ");
INSERT INTO mbi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Guna su nevanew en si Hisus ne mesmeselem pà te hewii ne Akad, ne riyà mid-una mibpekita sikandin te ki Maria Magdalena. Ini ke meritan ne midsuukan te pitu ne vusew ne midsegseg ni Hisus dengan. ");
INSERT INTO mbi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nekita rà ni Maria ne mid-ipanew sikandin su ebeyaan din ke menge edumdumaan ni Hisus. Neuma rin sikandan ne ebpeninehew ran te kegkemutu ran te kinepatey ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Guna su mibpenudtulan dan en ni Maria te nekita rin en si Hisus su nevanew en, ne warà dan mebperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Neipus ini se kinepekita ni Hisus ki Maria Magdalena, ne mibpekita maa sikandin te nesalin ke paras din diyà dut te deruwa ne edumdumaan din gewii te ed-ipanew ran se ebpendiyà te taneb. ");
INSERT INTO mbi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ne midlived dan kayi te Hirusalim su ebpenudtulan dan ke menge ruma ran te nekita ran en si Hisus, ugaid ne warà dan mibperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ketepusan be ne mibpekita si Hisus dut te sepulù wey seveka ne edumdumaan din gewii te egkaan dan. Midseweyan din sikandan su kurang ke sarig dan ne merehen te hinawa ran te kebperetiyaya rut te lalag te menge etew ne nekekita kandin te nevanew en. ");
INSERT INTO mbi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Migkehiyan din sikandan te, “Pendiyà kew te langun ne menge inged kayi te ampew te dunya ne ibpesabut niyu ke Meupiya ne Tudtul mekeatag kediey riyà te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ne piya engkey ne etew ne ebperetiyaya wey ebpebunyag dan ne ebpeketelimà te umur ne kenà edtaman, ugaid ne ke etew ne kenà ebperetiyaya ne ebetetayan te salà te kepatey. ");
INSERT INTO mbi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne ke menge etew ne ebperetiyaya kediey ne egkevehayan ku te gehem su apey ran ebpekevaal te mekegeyip. Su kayi te gehem ne ibehey ku kandan ne ebpekegaga ran ne ebpenegseg te menge vusew, ne ebpekelalag dan te menge lalag ne kenà kandan ne kinehiyen; ");
INSERT INTO mbi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ne embiya ebpekehawed dan te uled etawa ebpekeinum dan te ed-ilu, ne kenà dan egkekeiran; ne edsamsam dan te ebpenderaru ne ebpengeulian.” ");
INSERT INTO mbi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guna su nekeipus si Hisus ke Kerenan se edlalag kayi te menge edumdumaan din ne nevatun en diyà te langit, ne mibpinuu en diyà te egkekewanan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne mid-ipanew en dema ini se menge edumdumaan din se ebpesabut dut te Meupiya ne Tudtul mekeatag kandin diyà te langun ne menge inged. Ne Eleteala se midtavang kandan su nekevaal dan te menge mekegeyip apey mekeperetiyaya ke menge etew te benar ini se ibpesabut dan.  (9) Mibpendiyà ke menge meritan te enki Pedro ne intarem dan ke langun ne nerineg dan. (10) Neipus ini ne pineipanew ni Hisus ke menge edumdumaan din egenat te edsilaan ne ebpependiyà te edsenlepan su ebpesabut dan te berekat ne lalag mekeatag te umur ne warà edtaman din.");
INSERT INTO mbi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Diyà te ki Teofilo: Merakel en se menge etew ne migeram midsurat te guhud mekeatag te ned-ulaula ni Hisus kayi te kenami. ");
INSERT INTO mbi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iyan dan insurat ke nengeguhud kandan dut te menge etew ne nekekita en iya kayi te ned-ulaula igenat te rudsuan wey iyan dan dema mibpesabut te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na Teofilo, langun ini ne ned-ulaula ne midsusi ku up-upiani, tembù be netahù te itungan ku se edsuratan ku sikuna kayi te ned-ulaula endei se kegkeatur din. ");
INSERT INTO mbi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Idsurat ku ini su apey nu metueni en iya te benar ini langun se impenurù keykew. ");
INSERT INTO mbi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Iyan ku egkepengguhud ne timpu te iyan pà edatù si Hirudis dut te pruvinsiya te Hudiya ne ruen etew ketà ne ed-ingaranan ki Zacarias. Si Zacarias ini ne senge etew ne terebpelengesa rut te kevuwaran te keep-epuan dan dengan ne ed-ingeranan ki Ebiha su ke kevuwaran te Ebiha se menge terebpelengesa te Eleteala. Iyan din esawa ne ed-ingeranan ki Elisabet ne kevuwaran te bansa te Arun ne terebpelengesa rema te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ne ini se senge tiwelayan ne metidtu se hinawa ran diyà te etuvangan te Eleteala ne warà igkesawey kandan dut te kedtuman dan te langun ne suhù wey penduan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ugaid ne warà anak dan su kenà ed-anak si Elisabet su elin dan en nelukes. ");
INSERT INTO mbi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ne neuma en ke menge gewii te iyan ebpekepelengesa ne si Zacarias wey ke menge ruma rin ne kevuwaran ni Ebiha diyà te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na duen betasan dut te menge terebpelengesa te Eleteala ne engkey ki ngaran se egemew ne sikandin se edlusud diyà te Nekebpuru ne Valey te Eleteala su edtutung te rukut. Ne arà ne hewii ne ki Zacarias se migemew ne midlusud en sikandin diyà te Nekebpuru ne Valey te Eleteala su edtutung te rukut. ");
INSERT INTO mbi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ne gewii rin te edtutung te rukut kayi te lusud, ne riyà te luwal ebpengeningeni ke merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kemulu pà ne ed-ulaula si Zacarias kayi ne ruen suluhuen te Eleteala ne mibpekita kandin, kayi nekeitindeg te rapit te egkekewanan dut te edtutungan te rukut. ");
INSERT INTO mbi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nekita rà ni Zacarias ne netekawen sikandin ne neandek-andek nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ugaid ne migkahi ke suluhuen te Eleteala te, “Kenà ka meandek, Zacarias, su nerineg te Eleteala ke pengeningeni nu ne ke esawa nu ne ebpekeanak te meama, ne iyan nu iingaran ne si Juan. ");
INSERT INTO mbi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Egkehalew ka nevenar kandin, ne kenà ketà dà taman su kehelawan dema dut te ruma ne etew ketà te ked-enaka kandin. ");
INSERT INTO mbi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Su egkevaluy sikandin ne mepurù ne etew diyà te etuvangan te Eleteala. Kenà sikandin ed-inum te piya engkey ne ebpeketevereg ne ed-inumen. Ne misan igenat te kenà pà sikandin id-anak ne edlumunan en sikandin dut te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne kayi te kebpenurù din ne ebpekepelilived te merakel ne Hudiyanen riyà te Kerenan dan ne Eleteala ne andang ne ebpengeningeniyan dan. ");
INSERT INTO mbi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ini se anak nu si Juan,” ke se suluhuen te Eleteala, “ne edsuhuen te Eleteala ne ibpeuna te ebpeketuenan te mehaan ne ebpekeuma ke Kerenan. Ne ebehayan sikandin te baher wey edlumunan dut te Kedesenan ne Ebpetuntul te Menusiyà iring ki Elias ke etew ne mibpelambas te Lalag te Eleteala rengan. Kayi ebpuun te kebpenurù ni Juan ne ebpemeked-ulitey ke hinawa rut te menge amey wey ke menge anak. Ne ke menge etew ne warà mebperumaruma te suhù te Eleteala ne ebpekedsendit ne arà pà ne ebpekeulit te metidtu ne itungan. Ne kayi te penurù din ne ebpekepenehana ke menge etew dut te kebpekeuma ni Hisus ke Kerenan.” ");
INSERT INTO mbi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mighahi si Zacarias diyà te suluhuen te Eleteala te, “Maan engkey ve se idtuus ku te benar ini se migkahi nu? Su siaken ne lukes en, ne lukes en dema ke esawa ku.” ");
INSERT INTO mbi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Migkahi ke suluhuen te Eleteala maa te, “Siak imbe si Gabriel ke suluhuen te Eleteala ne layun diyà te etuvangan din. Sikandin iya se midsuhù kedì su ebpeketuenan keykew ini se meupiya ne egked-ulaula. ");
INSERT INTO mbi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ne warà ke ma mibpehimbenar dut te migkahi ku, Zacarias,” ke se suluhuen te Eleteala, “ugaid ne egkeuma ke enget ne hewii ne egketuman imbe iya. Na geina te warà ka mibpehimbenar, ne egkeemew ka taman te egked-ulaula ini se migkahi ku.” ");
INSERT INTO mbi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ne ini se menge etew ne mibpulung midtahad ki Zacarias diyà te luwal, ne neinuinu ran su malù neuhet sikandin diyà te lusud te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Guna su midlihawang en si Zacarias ne kenà en ebpekekahi riyà te menge etew su ebpenguyew-uyew rè be ne ketà ne neemew en sikandin. Ne netuenan dut te menge etew te ruen en impekita kandin te Eleteala diyà te lusud te valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Neipus ni Zacarias ke kandin ne hewii te egelevek diyà te Nekebpuru ne Valey te Eleteala ne mid-ulì en. ");
INSERT INTO mbi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Warà meuhet ne mibpenehipuun en ke esawa ni Zacarias, ne nekedlelima ne vulan ne mid-ubpaubpà sikandin te valey. ");
INSERT INTO mbi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ne ini pè be ne ingkeyru a te Eleteala su ebpekeanak ad,” ke sikandin. “Ne ebpekeengked en ke menge etew ne edtekudì kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Guna su ikeenem en ne vulan te kehingeyan dut te esawa ni Zacarias ne midsuhù te Eleteala ke suluhuen din ne si Gabriel diyà te inged ne Nesarit lusud te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iyan mibpeveyaan kandin ne riyà te senge etew ne raha ne nepesaran en se ed-esawaen te kenakan ne ed-ingeranan ki Jose, ke kevuwaran dut te ratù dan dengan ne si David. ");
INSERT INTO mbi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nekeuma ke suluhuen te Eleteala riyà te ki Maria ne migkahi en te, “Na kehalew ka, Maria! Bebegian ka ne etew su kayi en ke Eleteala te kenikew.” ");
INSERT INTO mbi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Guna su nerineg ni Maria ke lalag dut te suluhuen te Eleteala ne neliveg nevenar sikandin, ne mibpegpegitung din te engkey vuwa se meana rin. ");
INSERT INTO mbi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne migkahi ke suluhuen te Eleteala kandin te, “Kenà ka meandek, Maria, su midtuvaran ka te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ebmehingey ka ne ed-anak ka te meama ne iyan nu iingeran ne si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ebmepurù sikandin ne iyan duma ne id-umew kandin ne Anak en iya te Eleteala ne pinekemepurù te langun. Iyan ebpepurù kandin ne Eleteala,” ke se suluhuen, “su ibehey rin kandin ke edetuan dut te apù din dengan ne si David. ");
INSERT INTO mbi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne ini se anak nu ne edatù te langun ne menge Hudiyanen, ke menge kevuwaran ni Jacob. Uya, ini se kegkeratù din ne warà ketepusan din.” ");
INSERT INTO mbi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Migkahi si Maria riyà te suluhuen te, “Egkemenumenu be buwa ini? Su siaken ne matag nepasad se selenggunì ne warà key pà mepakey ketà te meama.” ");
INSERT INTO mbi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Migkahi maa ke suluhuen te Eleteala te, “Iyan ma edalandalan keykew ke Kedesenan ne Ebpetuntul te Menusiyà, ne ke gehem te Eleteala ne ini en te keykew. Tembù be ini se igkeanak nu ne berekat ne vatà ne iyan id-ingaran kandin ke Anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne kenà ini rà se tudtul ku,” ke se suluhuen te Eleteala, “su arà se ayà nu si Elisabet ne kenà kun ed-anak ne ikeenem din en ne vulan te kehingeyan din misan lukes en sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Su embiya Eleteala, ne egkeveelan din ke misan engkey en.” ");
INSERT INTO mbi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nerineg dà ni Maria ne migkahi en te, “Berekat ne ed-ul-ulaan din en ini se migkahi nu kayi te kedì. Su siaken, ne Eleteala se ebayàbayà kedì.” Arà dà ne mid-ewean en dut te suluhuen te Eleteala si Maria. ");
INSERT INTO mbi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Warà meuhet ne mibpenines si Maria ne migaangaan migenat su ebpendiyà te senge inged diyà te buvungan lusud te Hudiya. ");
INSERT INTO mbi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nekeuma si Maria riyà te valey en ni Zacarias ki Elisabet ne mibpenehetiat sikandin ki Elisabet. ");
INSERT INTO mbi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Guna su nerineg ni Elisabet ke penehetiat ni Maria ne midwaleng ke vatà kayi te hetek din. Ne ke Kedesenan ne Ebpetuntul te Menusiyà se midlumun ki Elisabet. ");
INSERT INTO mbi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne ruen impekahi rin ki Maria ne mibmerahing ke suwara rin te nekepemensag sikandin su kegkehalew rin se egkahi te, “Warà idsan nu ne meritan ne midtuvaran te Eleteala ne iring kayi! Ne engketà ded se kedtuvari dut te egkeanak nu! ");
INSERT INTO mbi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maan buwa ke midekdekelà a te hinawa te Eleteala se iyan en ebpeengkayi te kedì ke iney rut te Kerenan ku? ");
INSERT INTO mbi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Su nerineg ku rà sikew se ebpenehetiat ne midlehuwat te kegkehalew rin ini se kayi te hetek ku. ");
INSERT INTO mbi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tembù be midtuvaran ka, Maria,” ke si Elisabet, “su mibperetiyaya ka te egketuman iya ke impesabut kenikew dut te suluhuen te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Migkahi si Maria te, “Mesarig se kedeyù ku rut te Kerenan ku, ");
INSERT INTO mbi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ne dekelà se kegkehalew ku dut te Eleteala ne ebpeliyu kedì; ");
INSERT INTO mbi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Su mibpemilì a nikandin ne edtuvaran din, misan engkayi te kevevaan a ne edsugsuhuen din. Igenat guntaani ne ini se kevuwaran, ne idtitinudtulà dan te siaken kun se midtuvaran te Eleteala dut te langun ne memeritan, ");
INSERT INTO mbi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","su mekegeyip ke menge mid-ulaula dut te Eleteala kediey. Su Eleteala ne mekegegehem ne warà repeng din ke ngaran din. ");
INSERT INTO mbi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Igenat dut te pehaney ne kevuwaran taman te ketepusan ne kevuwaran, ne ibpekita rin ke kegkeyru rin dut te langun ne ebperumaruma kandin. ");
INSERT INTO mbi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impekita rin ke gehem din dut te mid-ulaula rin, ne miburehey rin ke menge etew ne mepereyù su apey kenà dan en metuman ke intahù te itungan dan. ");
INSERT INTO mbi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ruen menge ratù ne metehel ne mibpekevavà din, ne ke mepeembavà ne menge etew ne mibpekepurù din. ");
INSERT INTO mbi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ke menge etew ne layun en neirui, ne mibehayan te Eleteala te kurang dan; ugaid ke menge etew ne kewasa, ne pineulì din te kuyaskuyas. ");
INSERT INTO mbi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Warà melipati te Eleteala ke pasad din dengan dut te keep-epuan tew si Abraham wey ke menge kevuwaran din. Su midtevangan kiyu rin, ini se menge sugsuhuen din ne kevuwaran ni Israyil. Egkeyruwan kiyu rin dema te warà edtemanan din,” ke si Maria, “ini se menge kevuwaran ni Abraham ne nepemilì din.” ");
INSERT INTO mbi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nekedtetelu buwa ne vulan se ked-ubpà ni Maria riyà te engki Elisabet ne arà pà ne mid-ulì sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Neuma ke hewii ne mid-anak si Elisabet ne iyan din anak ne meama. ");
INSERT INTO mbi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Guna su nerineg dut te menge etew riyà te menge valey ne uvey ran wey ke menge suled dan ini se keupiya te Eleteala ki Elisabet ne nengehalew ran dema. ");
INSERT INTO mbi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Neuma ke ikewalu ne hewii ne miburun dan kayi te valey su edtumanen dan ini se betasan dan te menge Hudiyanen te ed-etus. Iyan dan perem id-ingaran kayi te vatà ne si Zacarias, idsangey red dut te amey rin, ");
INSERT INTO mbi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ugaid ne migkahi ke iney rin te, “Kenà egkepakey! Si Juan se ngaran din!” ");
INSERT INTO mbi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne migkahi ran kayi te ki Elisabet te, “Ini se id-ingaran nu ne warà suled nu ne egkesangayan.” ");
INSERT INTO mbi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne mid-uyawan dan ke amey rin ke engkey se kandin ne id-ingaran. ");
INSERT INTO mbi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mid-uyew rema si Zacarias te ebpevehey sikandin te egkesuratan te ngaran, ne iyan din insurat se “Si Juan se ngaran din.” Guna su insurat din arà ne neinuinu nevenar ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Arà dà iya ne nekelalag en si Zacarias ne nereyù din ke Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Langun dut te ruma rin ne neandek, ne nekeeneb en ke tudtul dan dut te langun ne menge etew ne mid-ubpà ketà te buvungan lusud te Hudiya. ");
INSERT INTO mbi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Langun te nekerineg ne neketahù te itungan dan ne mid-insà te, “Engkey buwa se ebuwatan kayi te batà ini?” Su mepayag nevenar se Eleteala se mibpengelintau kayi te vatà. ");
INSERT INTO mbi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Midlumunan dut te Kedesenan ne Ebpetuntul te Menusiyà si Zacarias ne ini se impelambas din ne lalag din, ke sikandin te, ");
INSERT INTO mbi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Edeyù kiyu te Kerenan, ke Eleteala tew te menge kevuwaran ni Israyil. Su mibpengkayi sikandin te edtavang dut te sikitew ne menge etew rin, ne ebehey kenitew te kebpekepeliyu kenitew. ");
INSERT INTO mbi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ibpepengkayi rin en te keytew arà se mekegehem ne ebpelihaun keytew, ne kayi egketuntun te kevuwaran dut te edsugsuhuen din ne ratù tew rengan ne si David. ");
INSERT INTO mbi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ini ve ke migkahi rin rengan impepevayà dut te menge etew ne ebpelambas te lalag din. ");
INSERT INTO mbi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Su migkahi rin te ibpelihawang kiyu rut te menge kunterà tew wey riyà te edtingkungan te palad dut te menge etew ne egkeepes kenitew. ");
INSERT INTO mbi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Migkahi rin dema te igkeyru rin ke menge keep-epuan tew, ne kenà din edlipatan ke pasad din kandan dengan. ");
INSERT INTO mbi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mevaher ke pasad din dengan dut te keep-epuan tew ne si Abraham, ");
INSERT INTO mbi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","su impasad din te ibpeliyu kiyu rut te palad te menge kunterà tew, su apey edtuman kiyu te kiyug din te warà kegkeandek, ");
INSERT INTO mbi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","su apey egkelunsey se ked-erapa tew kandin wey metidtu kiyu riyà te etuvangan din taman te biviyag kiyu pà.” Ne migkahi maa si Zacarias kayi te anak din te, ");
INSERT INTO mbi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ne sikew ini ne anak ku, iyan idtawag keykew ne ebpelambas te Lalag te Eleteala ne warà repeng din. Su edsuhuen ka nikandin te ibpeuna dut te Kerenan tew, su ebpeketuenan te menge etew te ebpenehana rut te kebpekeuma rin. ");
INSERT INTO mbi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sikuna ke ebpesabut te menge kevuwaran ni Israyil te igkepeliyu dan dut te kedusai kandan embiya ebuyù dan te Eleteala te kebpesehad te menge salà dan. ");
INSERT INTO mbi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Su ke Eleteala tew ne iiruwen wey melimù. Ne ini se kebpeliyu rin kenitew te kerusaan tew, ne iring te kedsilà te andew ne egkesilaan ke kerusireman. ");
INSERT INTO mbi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ebpekereyahen te Eleteala ke kerusireman tew su apey kenà kiyu en ed-elungen te kepepatey; su apey langun tew ne melintad se kegingginawa.” ");
INSERT INTO mbi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ne nekeiseg-iseg en ke kerekelà te anak en ni Zacarias ne mid-iseg en dema ke ketau rin mekeatag te Eleteala. Guna su dekelà en sikandin ne mibpendiyan en te tanà ne kenà egkeubpaan te etew, ne ketà mid-ubpà taman te neuma ke hewii te kebpenurù din te menge kevuwaran ni Israyil mekeatag te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Guna su iyan pà mepurù si Agustu rut te inged ne Ruma ne ruen suhù din te langun te menge etew ne ed-ubpà kayi te menge inged ne egkekemalan din ne ebpesurat te ngaran dan. ");
INSERT INTO mbi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini pà ke neuna ne kebpesurat dan te ngaran dan gewii te iyan midtendù ni Agustu ne gubinedur diyà te inged ne Siriya ne si Cirenio. ");
INSERT INTO mbi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ne langun ne menge etew ne mibpendiyà te uman inged ne mid-enakan kandan su ebpesurat te ngaran din. ");
INSERT INTO mbi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tembù be mibpendiyà si Jose kayi ebpuun te inged ne Nesarit lusud te Geliliya diyà te inged ne Bitlihim lusud te Hudiya su ini se inged ne Bitlihim ke mid-enakan dut te keep-epuan din ne datù dengan, si David. ");
INSERT INTO mbi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ne miduma ni Jose si Maria ini se raha ne nepenelenggunian din en su ebpesurat si Jose te ngaran din. Ne edrendayan en si Maria. ");
INSERT INTO mbi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Guna su diyan dan en te Bitlihim ne neuma en ke hewii te ked-anak din. ");
INSERT INTO mbi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne iyan din anak ne meama ne penganey rin pà ini. Ne midsemputan din ini se vatà ne impeirehà din diyà te ebpekeenan te kudà su warà neirehaan dan diyà te valey ne ed-eranan su nepengkeg en te etew. ");
INSERT INTO mbi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ne arà ne kerukileman ne ruen menge etew ne ebantey te menge bilibili ran diyà te ebpemetebtavan dan uvey te Bitlihim. ");
INSERT INTO mbi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ne netekew se ruen mibpekita kandan ne suluhuen te Kerenan riyà ebpuun te langit, ne mibpesilaan te Kerenan sikandan te raman din. Ne nengeandek dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ne migkahi ke suluhuen kayi te kandan te, “Kenà kew meandek! Su midsuhù a ini te ebpepenudtulen keniyu te meupiya ne tudtul ne ebpekehalew te langun ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Su ini ne kerukileman diyà te Bitlihim ke inged ni David rengan ne in-anak ke ebpeliyu keniyu dut te salà niyu. Su sikandin si Kristo ke Kerenan ne Impasad te Eleteala rengan ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ini se idtuus niyu te benar ini se migkahi ku keniyu te ebpekeuma kew riyà ne egkekita niyu ini se vatà ne midsemputan ne impeirehà riyà te ebpemekeenan te kudà.” ");
INSERT INTO mbi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne seguguneey ne ruen mibpekita ne ruma rut te suluhuen ne medmerakel riyà ebpuun te langit ne mideyù dan ke Eleteala se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Edeyù kiyu te Eleteala riyà te lesang te langit. Ne kayi te ampew te dunya ne mebmelintad ke hinawa rut te menge etew ne ebpekesuhat te hinawa rin.” ");
INSERT INTO mbi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Guna su mid-ulì en diyà te langit ini se menge suluhuen ne mibpelelehahey ke menge ebantey te bilibili te, “Kuwa kew en su ebpendiyà kiyu te Bitlihim su apey tew egkekita ini se ned-ulaula ne mibpeketuenan te Kerenan keytew.” ");
INSERT INTO mbi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Arà dà ne midahewrahew ran en mid-ipanew ne netuen dan en si Maria ki Jose ne nekita ran en ini se vatà ne impeirehà diyà te ebpemekeenan te kudà. Ne nekita ran dema si Maria wey si Jose ketà. ");
INSERT INTO mbi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Guna su nekita en kayi te ebantey te bilibili ini se vatà ne impenudtul dan en kandan ke migkahi rut te suluhuen mekeatag kayi te vatà. ");
INSERT INTO mbi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Langun te nekerineg kayi te tudtul dut te ebantey te bilibili ne nengegeyip dan dut te nerineg dan. ");
INSERT INTO mbi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ne si Maria, ne kenà egkeawà te itungan din ini se tudtul dan su mibpegpegitung din up-upiani. ");
INSERT INTO mbi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ne ini se ebantey te bilibili, ne mid-ulì en. Ne wey ran mideyù te Eleteala rut te langun ne nerineg dan wey nekita ran su netuman en langun ke impenudtul kandan dut te suluhuen te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Guna su neume en ke ikewalu ne hewii ne mid-etusan dan en ini se vatà, su arà ke betasan te menge Hudiyanen, ne mid-ingaranan dan en ki Hisus. Su ini ke ngaran ne impenudtul ki Maria rut te suluhuen te Eleteala te misan warà pà sikandin mibpengeraring. ");
INSERT INTO mbi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Neuma ke hewii ne edtumanen ni Jose ki Maria ini se betasan dan te ebehey te ibpelengesa riyà te Nekebpuru ne Valey te Eleteala riyà te Hirusalim su edumaan dan ke penduan ne intahak ni Moises rengan mekeatag te meritan ne behu pà ne mid-anak. Ne mibpeneheewit dan ke vatà diyà te Hirusalim su apey ran idtepeney te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Su edtumanen dan ke penduan ne impesurat te Eleteala rengan ne egkahi te, “Langun ne penganey ne meama ne idtepeney niyu te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne ibehey ran dema ke ibpelengesa ne nekahi rut te penduan te Kerenan ne “deruwa ne timan ne limuken etawa deruwa ne timan ne melepatì.” ");
INSERT INTO mbi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Duen senge etew ne meama ne ed-ubpà ketà te Hirusalim ne ed-ingaranan ki Simeon. Metidtu se ulaula rin wey in-amin din ke hinawa rin te egelevek te Eleteala. Ne ebpemematì sikandin ke keenu ibpeliyu te Eleteala ke menge etew rin ne menge kevuwaran ni Israyil. Ne ke Kedesenan ne Ebpetuntul ne Menusiyà ne midlumun en ki Simeon. ");
INSERT INTO mbi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ne daan en ne mibpeketuenan kandin dut te Kedesenan ne Ebpetuntul te Menusiyà te kenà pà ebpatey sikandin taman te kenà din mekita ke Mesiyas arà se Impasad te Eleteala ne Kerenan dengan ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ketà te hewii ne mibpeneheewit dut te lukes din si Hisus te edlusud kayi te Nekebpuru ne Valey te Eleteala su edtumanen ini se nekahi rut te penduan ne ketà en te lusud si Simeon su impelusud sikandin dut te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ne midsepipi ni Simeon ke vatà ne mideyù en te Eleteala se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Is Kerenan, midtuman nu en iya ke impasad nu kedì. Ne misan keenu nu ebugkuta se niyawa ku ne egkepakey en, su mibmelintad en se hinawa ku. ");
INSERT INTO mbi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Su nebentangan en iya kayi te mata ku ini se midtendù nu ne ebpeliyu kenami rut te keberedusaan dey. ");
INSERT INTO mbi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Su mibpenehana nu sikandin su apey langun ne menge bansa ne ebpekekita. ");
INSERT INTO mbi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iring sikandin te rayag dut te menge etew ne kenà Hudiyanen su apey ebmerayag ke tidtu ne ibayà dan te ebpendiyà te kenikew. Uya, ini ve se vatà se ralan te kegkereyù dut te sikami ne menge kevuwaran ni Israyil ne nepemilì nu.” ");
INSERT INTO mbi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Neselekawan ini se menge lukes dut te vatà kayi te migkahi ni Simeon mekeatag te anak dan. ");
INSERT INTO mbi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Impengeningeni ni Simeon te ebpeneuven dan te Eleteala, ne migkahi en sikandin kayi te ki Maria ke iney ni Hisus te, “Ini se batà ne daan en ne mibpemilì te Eleteala ne tuus te Eleteala kayi te menge kevuwaran ni Israyil. Ke menge etew ne ed-engkenà kandin ne edusaan, ne ke menge etew ne edtelimà kandin ne ibpeliyu te Eleteala. Sikandin iya ke tuus ne riyà ebpuun te Eleteala kayi te sikandan, ugaid ne merakel se ed-engkenà kandin. ");
INSERT INTO mbi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne kayi te menge ulaula ran ne egkepeyahan ke intahù te itungan dan, ini se itungan dan ne in-eles dan dut te ruma ran. Ne sikuna, Maria,” ke si Simeon, “ne egkerupet se hinawa nu iring te nesuhat ka te meharang ne sundang.” ");
INSERT INTO mbi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ne ruen dema meritan ne mibpelambas te Lalag te Eleteala ne ed-ingaranan ki Ana, anak ni Panuwil, ne kevuwaran ni Asir. Lukes en nevenar ini se meritan ne nekeesawa taman te pitu rà ne rahun ");
INSERT INTO mbi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ne nevalu en, ne nekedwalu nepulù en wey epat ne rahun se kegkevalu rin. Warà mid-awà sikandin kayi te Nekebpuru ne Valey te Eleteala. Merukilem meandew ne mideyù din ke Eleteala, ne ruen menge hewii ne kenà sikandin egkaan su apey rin meilut se kebpengeningeni rin te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Neseretaan dema sikandin te kinepeneheewit dut te vatà kayi te Nekebpuru ne Valey te Eleteala ne mid-uvey sikandin engki Maria ne mideyù ke Eleteala mekeatag ketà te vatà. Ne igenat ketà ne impesabut din en mekeatag kayi te vatà diyà te langun ne ebpenareng te Eleteala te kebpekepeliyu te menge kevuwaran ni Israyil. ");
INSERT INTO mbi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Guna su nepasad en ni Jose ki Maria te kedtuman dut te langun ne nekahi kayi te penduan te Kerenan ne mid-ulì dan en diyà te inged dan ne Nesarit, lusud te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ne mid-iseg en ini se vatà ne mekaherkaher se lawa rin ne metautau sikandin, ne dekelà se penaub te Eleteala kandin. ");
INSERT INTO mbi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Uman rahun ne ebpendiyà ke lukes ni Hisus te Hirusalim su edtelavuk te Pista te Kedsehari te Suluhuen te Eleteala dut te menge apù dan dengan. ");
INSERT INTO mbi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Guna su sepulù en wey deruwa ne rahun si Hisus, ne mibpendiyà dan en te Pista maan. ");
INSERT INTO mbi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Guna su neipus en ke menge hewii te pista ne migenat dan en se ed-ulì, ugaid ne mibpelintetahak si Hisus diyà te Hirusalim te warà metueni rut te menge lukes din. ");
INSERT INTO mbi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iyan dan kunaan ke kayi red sikandin te menge ruma ran ne midlevundus dan en se ed-ipanew te neep-epunan. Ne arà pà ne mibpemengà dan si Hisus kayi te menge suled dan wey menge ruma ran. ");
INSERT INTO mbi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ugaid ne warà dan metuen, ne ketà ne midlived dan diyà te Hirusalim se ebpemengà. ");
INSERT INTO mbi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ne iketelu rin ne andew ne arà pà ne netuen dan diyà te Nekebpuru ne Valey te Eleteala. Su riyà ebpemekibitiyara sikandin te menge meyterù te Hudiyanen se ebpemineg te lalag dan wey ebpenginginsaan din sikandan. ");
INSERT INTO mbi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Langun dan te ebpemineg ki Hisus ne negeyip dut te ketau rin te edtavak te menge insà kandin. ");
INSERT INTO mbi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nekita rà dut te menge lukes din ne neinuinu ran nevenar ne migkahi ke iney rin kayi te ki Hisus te, “Anak ku, maan ke mid-ulaula nu ini kenami? Neipeng-ipeng key te amey nu se ebpemengà kenikew.” ");
INSERT INTO mbi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ne migkahi si Hisus kandan te, “Meambe ke mibpemengà kew pà kediey? Maa warà niyu metueni se kayi a mulà te valey te amey ku?” ");
INSERT INTO mbi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ugaid ne warà dan mekesabut dut te meana kayi te migkahi rin. ");
INSERT INTO mbi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne miduma en si Hisus kandan te ed-ulì diyà te Nesarit ne mibperumaruma sikandin kandan. Ne si Maria mulà ne intahù din langun ini te itungan din. ");
INSERT INTO mbi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne nekeiseg en se kerekelà te lawa ni Hisus ne ke itungan din ne mid-iseg dema. Ne mid-iseg-iseg en se kebpekesuhat din te hinawa te Eleteala, ne engketà ded dema ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Midsahadsahad en se menge rahun ne ini en ke ikesepulù en wey lelima ne rahun te kegkamal ni Tibiriyu rut te inged ne Ruma. Si Punsiyu Pilatu se midtendù din ne gubinedur dut te pruvinsiya ne Hudiya, si Hirudis se migkamal te pruvinsiya ne Geliliya, ne ke ari rin ne si Felipe se migkamal te menge pruvinsiya te Ituriya wey Terekunita, wey iyan migkamal te pruvinsiya te Ebeliniya ne si Lisanyas. ");
INSERT INTO mbi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ne iyan menge mepurù dut te langun ne terebpelengesa te Eleteala rut te menge Hudiyanen ne si Anas wey Kayipas. Si Juan be ini, ke anak ni Zacarias, ne riyà pà te tanà ne kenà egkeubpaan te etew ne diyan en meumai sikandin te lalag te Eleteala te ebperudsuen te helevek din. ");
INSERT INTO mbi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ketà ne migemew en si Juan ne mibayaan din ke langun ne menge inged uvey te wayig ne Hurdan. Ne mibpemesabut din ke menge etew se egkahi te, “Pemedsendit kew ne engkeri niyu ke meraat ne menge ulaula niyu, ne pemebunyag kew su apey ebpeseharen te Eleteala ke menge keberedusaan niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ini se impenurù ni Juan ne netuman en ke impesurat ki Isayas ke mibpelambas te Lalag te Eleteala rengan se egkahi te, “Duen etew riyà te tanà ne kenà egkeubpaan te etew ne ebpenawag dut te menge etew ne ed-uvey kandin, ke sikandin te, ‘Mehaan ebpekeuma ke Kerenan, ihewani niyu ke ralan ne tidtuwa niyu ke ibayà din, ne iyan din meana ne tilaka niyu ke hinawa niyu su apey kew egkepenehana te kebpekeuma rin. ");
INSERT INTO mbi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Langun te netempag ne edtembakan, ne langun ne ebpenuhartuhar ne ebpetahen. Ke dalan ne ebpenikùtikù ne ebpeketidtuwen ne ke mibuketur ne ralan ne edtilaken. ");
INSERT INTO mbi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne ketà ne ibpekita te Eleteala te langun ne menusiyà ke edsuhuen din ne ebpeliyu kandan.’” ");
INSERT INTO mbi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Migkuludkulud ma se menge etew ne mibpengkayi te ki Juan su ebpemebunyag. Migkehiyan din sikandan te, “Iring kew te menge uled ne ebpelahuy dut te apuy! Mehaan en egkeuma ke kedusa te Eleteala keniyu. Engkey se midtarem keniyu te ebpekeliyu kew ketà ke ebpebunyag kew? ");
INSERT INTO mbi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Embiya benar ne mid-engkeran niyu ke meraat ne ulaula niyu, ne ipekita niyu kayi te ulaula niyu. Ne kenà kew egkahi te sikiyu ne kenà edusaan te Eleteala su kevuwaran kew ni Abraham. Su igkahi ku keniyu,” ke si Juan, “misan ini se menge batu ne egkepebaluy te Eleteala ne etew ne tuney ne kevuwaran ni Abraham ne igkesambì keniyu. ");
INSERT INTO mbi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ne sikiyu ne iring te menge kayu ne kenà ebahas te meupiya, tembù be ebpilayen. Ne iring te nekekayew en ke adsa su ebpemilayen en ne edtimbag diyà te apuy.” ");
INSERT INTO mbi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mid-insà ke menge etew kandin te, “Engkey en be se ed-ul-ulaan dey su apey key mekeliyu keniyan te egkehiyen nu?” ");
INSERT INTO mbi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne migkahi si Juan te, “Ini se ul-ulaa nu, ke etew ne deruwa se velegkas din ne mebehey te etew ne warà velegkas din. Engketà ded maa ke egkekaan, ke etew ne ruen egkekaan din ne mebehey dut te etew ne warà kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duen menge ebpevayad te buwis ne mibpengkayi te ki Juan su ebpembunyag. Ke sikandan te, “Meyterù, engkey en be se kenami ne ed-ul-ulaan?” ");
INSERT INTO mbi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne migkahi si Juan te, “Embiya ebpevayad kew te buwis, ne kenà niyu ed-umani ke ibpevayad niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ne ruen dema menge sundaru ne mid-insà kandin, ke sikandan te, “Nemenu sikami? Engkey se kenami ne ed-ul-ulaan?” Ne migkahi si Juan te, “Engkeri niyu ini se kebpenguwa te pirak te kebpemehes niyu wey ini se kebpenguwa te pirak te etew ne edtevuan niyu. Kenà kew ebpeuman te sukey niyu kayi te kedlimbung niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gewii rut te menge etew ne ebpemineg ki Juan ne mid-ilut se kebpenareng dan su iyan dan pegitungan ne si Juan ini ke Impasad te Eleteala dengan ne Ebperetuen te langun ne ed-ingeranan te Mesiyas. ");
INSERT INTO mbi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tembù migkahi si Juan diyà te kandan te, “Duen ebpeketundug kediey ne mepurù pà kedì su misan ke telumpà din ne kenà a edait ne ed-ekar. Wayig se ibunyag ku keniyu, ne sikandin ke migkahi ku ne ebpeketundug kedì ne ebunyag dema keniyu. Ke menge ebperetiyaya ne ebunyahan din te Kedesenan ne Ebpetuntul te Menusiyà, ne ke kenà ebperetiyaya ne iyan din ibunyag ne apuy. ");
INSERT INTO mbi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Geina te ibpesivey rin ke menge etew ne ebperetiyaya rut te menge etew ne kenà ebperetiyaya, ne iring sikandin te etew ne ruen teluung din su ed-ukap ne ibpelayap din ke ukap rut te rimahas. Ke rimahas ne idtahù din diyà te patil, ne ke ukap ne ebinsulan din te apuy ne kenà egkeevukan.” ");
INSERT INTO mbi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Gewii te ibpesabut ni Juan te menge etew ini se Meupiya ne Tudtul te Eleteala ne inlehetlehet din kandan te mebpenehana ran ketà te migkahi rin ne ebpekeuma. ");
INSERT INTO mbi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ugaid ne si Hirudis ke egkamal kayi te inged ne Geliliya ne mibpengegkehiyan ni Juan su mid-ahew ni Hirudis ke ipag din ne si Hirudiyas ke esawa te ari rin ne si Felipe. Ne kenà arà dà se meraat ne mid-ulaula ni Hirudis ne impengahikahi ni Juan kandin su merakel pà lavew se meraat ne mid-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Huna su nerineg ini ni Hirudis, ne midruntuwan din pà lavew ke meraat ne ulaula rin su impevilanggù din si Juan. ");
INSERT INTO mbi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Guna su langun dut te etew ne nebunyehan en ni Juan ne arà pà ne mibpengkayi si Jesus te ki Juan su ebpebunyag kandin. Ne ketà ne mibpengeningeni si Hisus te Eleteala, ne gewii rin te ebpengeningeni ne iring te nevukaan ke langit ");
INSERT INTO mbi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ne midudsuk ke Kedesenan ne Ebpetuntul te Menusiyà kayi te ki Hisus ne midragid te melepati. Ne ruen suwara ne riyà ebpuun te langit ne migkahi te, “Sikew ke anak ku ne igkelimù ku nevenar, ne nekesuhat ka nevenar te hinawa ku.” ");
INSERT INTO mbi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Guna su menge tetelu en nepulù se rahun ni Hisus ne midrudsù te helevek din ne mibpeveelan kandin te Eleteala. Iyan itungan te menge etew ne tuney ne anak sikandin ni Jose. Si Jose ini ne anak ni Heli, ");
INSERT INTO mbi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","si Heli ne anak ni Matat, si Matat ne anak ni Levi, si Levi ne anak ni Milki, ne si Milki ne anak ni Hani, si Hani ne anak ni Jose, ");
INSERT INTO mbi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","si Jose ne anak ni Matatiyas, si Matatiyas ne anak ni Amos, si Amos ne anak ni Nahum, si Nahum ne anak ni Isli, si Isli ne anak ni Nagey, ");
INSERT INTO mbi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","si Nagey ne anak ni Maat, ne si Maat ne anak ni Matatiyas, si Matatiyas ne anak ni Simi, si Simi ne anak ni Jose, si Jose ne anak ni Huda, ");
INSERT INTO mbi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","si Huda ne anak ni Huwana, si Huwana ne anak ni Risa, si Risa ne anak ni Surubabil, si Surubabil ne anak ni Selatil, si Selatil ne anak ni Niri, ");
INSERT INTO mbi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","si Niri ne anak ni Milki, si Milki ne anak ni Adi, si Adi ne anak ni Kusam, si Kusam ne anak ni Ilmudam, si Ilmudam ne anak ni Iyir, ");
INSERT INTO mbi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","si Iyir ne anak ni Josue, si Josue ne anak ni Eliezer, si Eliezer ne anak ni Hurim, si Hurim ne anak ni Matat, si Matat ne anak ni Levi, ");
INSERT INTO mbi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Levi ne anak ni Simeon, si Simeon ne anak ni Huda, si Huda ne anak ni Jose, si Jose ne anak ni Hunan, si Hunan ne anak ni Iliyakim, ");
INSERT INTO mbi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","si Iliyakim ne anak ni Miliya, si Miliya ne anak ni Meinan, si Meinan ne anak ni Matata, si Matata ne anak ni Natan, si Natan ne anak ni David, ");
INSERT INTO mbi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","si David ne anak ni Isai, si Isai ne anak ni Obid, si Obid ne anak ni Buus, si Buus ne anak ni Salmun, si Salmun ne anak ni Naasun, ");
INSERT INTO mbi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","si Naasun ne anak ni Aminadab, si Aminadab ne anak ni Admin, si Admin ne anak ni Arni, si Arni ne anak ni Isrum, si Isrum ne anak ni Piris, si Piris ne anak ni Huda, ");
INSERT INTO mbi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","si Huda ne anak ni Hakub, si Hakub ne anak ni Isaac, si Isaac ne anak ni Abraham, si Abraham ne anak ni Tiri, si Tiri ne anak ni Nakur, ");
INSERT INTO mbi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","si Nakur ne anak ni Serug, si Serug ne anak ni Ragaw, si Ragaw ne anak ni Peleg, si Peleg ne anak ni Ibir, si Ibir ne anak ni Sala, ");
INSERT INTO mbi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","si Sala ne anak ni Kainan, si Kainan ne anak ni Erpaksad, si Erpaksad ne anak ni Sim, si Sim ne anak ni Noe, si Noe ne anak ni Lamic, ");
INSERT INTO mbi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamic ne anak ni Matusalin, si Matusalin ne anak ni Enok, si Enok ne anak ni Harid, si Harid ne anak ni Mehelelil, si Mehelelil ne anak ni Kainan, ");
INSERT INTO mbi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","si Kainan ne anak ni Inus, si Inus ne anak ni Sit, si Sit ne anak ni Adan, si Adan ne anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Guna su nebunyehan en si Hisus diyà te wayig te Hurdan, ne mid-awà dutun ne midlumunan nevenar dut te Kedesenan ne Ebpetuntul te Menusiyà ne mid-ewit en sikandin diyà te tanà ne kenà egkeubpaan te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne ketà ne lusud te neked-epat nepulù ne hewii ne mibpenggeraman en si Hisus ni Setanas ke datù te pekaid. Ne ini ne menge hewii ne warà bulug mekekaan sikandin ne ketà ne nevitil nevenar si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne migkehiyan ni Setanas ke datù te pekaid si Hisus te, “Embiya sikuna en ke Anak te Eleteala ne pebeluya nu ini se batu ne pan.” ");
INSERT INTO mbi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ne migkahi si Hisus te, “Iyan insurat ne Lalag te Eleteala ne egkahi te, ‘Kenà egkeenen dà se igkeuyag te etew.’” ");
INSERT INTO mbi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ne ketà ne mid-ewit ni Setanas si Hisus te edtegkereg ne seperek mata ne impekita rin ki Hisus ke langun ne inged kayi te ampew te dunya. ");
INSERT INTO mbi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Ini se kebayàbayà kayi te langun ne inged ini ne ibehey ku keykew,” ke se datù te pekaid, “wey langun ini ne kekewesai, su langun imbe kayi ne imbehey kedì ne igkevehey ku te piya engkey ne egkesuatan ku. ");
INSERT INTO mbi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Langun din ini ne kenikew en embiya ed-arap ka kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne migkahi si Hisus te, “Ruen impesurat ne Lalag te Eleteala ne egkahi te, ‘Iyan niyu rà erapa ne Kerenan ne Eleteala niyu, ne sikandin dà se ebperumdumaan niyu.’” ");
INSERT INTO mbi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne ketà maa ne mid-ewit dut te datù te pekaid si Hisus diyà te inged ne Hirusalim dutun te migketikangan dut te Nekebpuru ne Valey te Eleteala ne migkahi sikandin te, “Embiya benar ne sikew ke Anak te Eleteala ne umpak ka ruen. ");
INSERT INTO mbi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Su ruen impesurat ne Lalag te Eleteala ne egkahi te, ‘Edsuhù ke Eleteala te menge suluhuen din ne ebpetugenuren keykew.’ ");
INSERT INTO mbi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ne ruen dema ketà ne egkahi te, ‘Edsepirawen ka nikandan su apey kenà egkerudruri ke menge paa nu te batu.’” ");
INSERT INTO mbi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ne migkahi si Hisus te, “Ugaid ne ruen dema Lalag ne impesurat te Eleteala ne egkahi te, ‘Kenà kew baal te ralan ne ibpenggeram niyu te gehem dut te Kerenan ne Eleteala niyu.’” ");
INSERT INTO mbi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Guna su netuenan dut te datù te pekaid te kenà din egkepenggeraman si Hisus ne mid-ewaan din pà. ");
INSERT INTO mbi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mid-ulì en si Hisus diyà te Geliliya ne ke gehem te Kedesenan ne Ebpetuntul te Menusiyà ne ini en te kandin. Ne nekeeneb en dut te langun ne nekelingut ne inged ke tudtul mekeatag ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mibpenurù sikandin diyà te menge valey ne ebpengedian te menge Hudiyanen ne nekereyù kandin ke langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ne arà pà ne midlaus si Hisus diyà te Nesarit, ke inged ini ne kayi en mibukelid sikandin. Neuma se Hewii ne Id-imeley ne mibpendiyà sikandin te valey ne ebpengedian te Hudiyanen te penduan dan su ini se kandin ne ulaula. Guna su nevurun dan en ne mid-itindeg en si Hisus su ebasa te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Induwal dan en kandin ke insurat ni Isayas, senge etew ne mibpelambas te Lalag te Eleteala rengan. Ne mibekar ni Hisus ini se insurat ketà te egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ke Kedesenan ne Ebpetuntul te Menusiyà ne riyà ebpuun te Kerenan ne Eleteala ne midlumun en kediey, ne mibpemilì a te Kerenan ne Eleteala su apey ku ibpesabut dut te menge etew ne ayuayu ke Meupiya ne Tudtul. Ne mibpeveyaan din kedì apey ku mepenudtuli te egkevelukasan ke menge etew ne nevakù ni Setanas; ne ebpengeulian ke menge pisek su apey ran ebpekekita; ne ebpelihawang dut te menge edtekutaken. ");
INSERT INTO mbi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Midsuhù a rin dema su apey ku mepenudtul te ini en ke timpu te kebpeliyu te Kerenan ne Eleteala te kandin ne menge etew.” ");
INSERT INTO mbi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ne midlulun ni Hisus ke ebesaan ne in-ulì din diyà te mibehey kandin ne mibpinuu sikandin se ebpenurù kandan. Ne langun ne menge etew ketà ne rutun dà mepuhuy ke mata ran te kandin su ebpemineg. ");
INSERT INTO mbi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne migkahi sikandin kayi te kandan te, “Ini se nekahi rut te impesurat te Eleteala ne mibasa ku ne netuman en gunteani te ini ini en iya ne nerineg niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Langun dut te nevurun ketà ne nevenaran dut te kebpenurù din, ne negeyip dan dut te keupiya te kedlalag din, ke sikandan te, “Maa, kenà anak ni Jose ayan?” ");
INSERT INTO mbi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Migkahi si Hisus te, “Ruen beseenan tew ne igkesuati niyu ves te egkahi kayi te kedì ini se egkahi te, ‘Embiya ebpemawì ka ne etew, ne bawii nu ke lawa nu.’ Ne seveka maa buwa ne egkekahi niyu te, ‘Ruen nerineg dey ne mid-ulaula nu riyà te inged ne Kapirnawum, ne kun imbe ul-ulaa nu rema kayi te keykew ne inged.’ ");
INSERT INTO mbi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ugaid,” ke si Hisus, “ini se igkahi ku keniyu, warà etew ne ebpelambas te Lalag te Eleteala ne ebpeminehen te menge etew diyà te kandin ne inged. ");
INSERT INTO mbi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Benar ini se egkehiyen ku keniyu, iring ini se ed-ul-ulaan niyu guntaani rut te timpu rengan ne biviyag pà si Elias ke mibpelambas te Lalag te Eleteala. Su nekedtetelu ne rahun wey enem ne vulan ne warà uran, ne nesuhat te bitil ke langun ne inged din, ne merakel se menge ruma tew ne Hudiyanen ne nevalu ne meritan ne ebpengerehenan ketà te bitil. ");
INSERT INTO mbi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ugaid ne warà ma suhua te Eleteala si Elias te ebpetevangan te senge etew kandan, nasì ne impependiyà si Elias te senge etew ne valu ne ed-ubpà te Seripta, lusud te Sidun. ");
INSERT INTO mbi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne ruen pà maa,” ke si Hisus, “gewii rema ni Eliseo te mibpelambas te Lalag te Eleteala ne merakel se menge Hudiyanen ne mibpendaru te kevuwa ne muna te it-it. Ugaid ne warà seveka kandan ne mibpevawian te Eleteala ki Eliseo, nasì ne impependiyà si Eliseo te senge etew ne kenà Hudiyanen ne si Naaman lusud te inged ne Siriya.” ");
INSERT INTO mbi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nerineg dut te menge etew ne nevurun ketà se migkahi ni Hisus te edtavang ke Eleteala te kenà Hudiyanen, ne neepes-epes dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mid-itindeg dan ne migeweran dan si Hisus ne midtuyuk dan se ebpependiyà te puntur te tuhar su ketà metahù ke inged dan, ne idtimbag dan perem si Hisus diyà te dempilas. ");
INSERT INTO mbi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ugaid ne mibpeniyuksiyuk si Hisus diyà te kandan ne midlevundus en se ed-ipanew. ");
INSERT INTO mbi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ne midlaus si Hisus diyà te Kapirnawum, inged ne lusud te Geliliya. Ne neuma ke Hewii ne Id-imeley ne mibpenurù din ke menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nerineg dan ke kebpenurù din, ne neinuinu ran nevenar su ruen gehem te kebpenurù din. ");
INSERT INTO mbi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ketà te valey ne ebpengedian dan te penduan dan ne ruen senge etew ne midsuukan te vusew. Nekita rin dà si Hisus ne migkuleyì te, ");
INSERT INTO mbi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hey Hisus ne riyà ebpuun te Nesarit, engkey se kememeniyà nu kayi te sikami ne vusew? Maa, edereetan key nikuna? Egkekilala ku sikuna su sikuna ke Berekat ne Anak te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ne pineengked en ni Hisus ke vusew se egkahi te, “Engked ka rà, ne awà ka keniyan te meama ayan!” Ne intimbag pà dut te vusew ini se meama kayi te etuvangan te menge etew, ne mid-awà sikandin ugaid ne warà din mekeiri ini se meama. ");
INSERT INTO mbi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ne rekelà se kinekegeyip dut te langun ne menge etew ketà ne mibpein-inseey ran te, “Engkey ve vuwa ini? Su utew rekelà se gehem din te ebpeawà te menge vusew, ne ebpemineg dan kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Arà dà ne nekeeneb en ke tudtul te mid-ulaula ni Hisus diyà te langun ne nekelingut ne inged. ");
INSERT INTO mbi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Guna su mid-awà si Hisus kayi te valey ne ebpengedian te menge Hudiyanen te penduan dan, ne mibpendiyà te valey ni Simon. Seretà din ketà ne edetengen ke enuhang ni Simon ne meritan, ne mibuyù dan ki Hisus te bawii rin. ");
INSERT INTO mbi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mid-uvey si Hisus dut te meritan ne pineawà din ke rateng. Arà dà ne neawà en ke rateng din ne mid-enew sikandin ne mid-ilutù en te ibpekaan kandan. ");
INSERT INTO mbi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Guna su ebpengirum-irum en ne langun ne menge etew ne ruen duma ran ne ebpenderaru te misan engkey en ne daru ne mibpeneheewit dan kayi te ki Hisus. Ne midampen din ke uman senge etew ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne misan ke menge vusew ne impeawà din dut te menge etew ne edteverehen dan. Ne embiya ebpeewaen en ini se vusew ne egkuleyì dan te, “Sikuna ke Anak te Eleteala!” Ugaid ne pineengked ni Hisus sikandan su kenà din idluhut ne edlalag dan su netuenan dan te sikandin ke Impasad te Eleteala rengan ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Guna su egkeriwaswas en ne mid-awà si Hisus ketà te inged ne mibpendiyà sikandin te sibsiveyan. Mibpemengà sikandin dut te menge etew ne guna su netuen dan sikandin ne imbangen dan perem su apey kenà mekeawà diyà te kandan. ");
INSERT INTO mbi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ugaid ne migkahi si Hisus kandan te, “Kenà egkepakey ne kenà ku ibpendiyà te menge etew diyà te ruma ne inged su ibpesabut ku rema kandan ini se Meupiya ne Tudtul mekeatag dut te Impasad te Eleteala ne Ebperetuen te langun su ini ke insuhù kediey te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ketà ne midlevundus en mebpenurù si Hisus diyà te menge valey ne ebpengedian te Hudiyanen diyà te lusud te Hudiya. ");
INSERT INTO mbi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Senge hewii ne riyà si Hisus te beyvey te ranew ne ed-ingaranan te Ginisarit, ne merakel se etew ne egkeasek su ed-uvey ran su ebpemineg dan te Lalag te Eleteala ne ibpenurù din. ");
INSERT INTO mbi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nekekita si Hisus te deruwa ne avang ne in-ampil diyà te gebgevasan su mid-ewaan pà te menge kemuney su ebpenggasgas te biyala ran. ");
INSERT INTO mbi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mid-erà si Hisus diyà te seveka ne avang ne avang ni Simon, ne migkehiyan din si Simon te, “Ibpetulud pà arà se avang din te malù ebpekeriyù dut te beyvey.” Ketà ne mibpinuu si Hisus se ebpenurù dut te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nekeipus si Hisus se ebpenurù ne migkehiyan din si Simon te, “Purai niyu en be ini se avang nu riyà te kalud ne pemiyala kew en su apey kew ebpekeutel.” ");
INSERT INTO mbi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Migkahi si Simon te, “Nepewpewaan key en se ebpemiyala ne warà key en iya mekeutel, ugaid embiya arà se kahi nu ne ebpemiyala key maa.” ");
INSERT INTO mbi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","In-antug dan ke biyala ran ne nevenbenaran dan te serà ne neutel dan su reisek samà ne egkereetan ke biyala ran. ");
INSERT INTO mbi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ne nekekapey ran dut te menge ruma ran diyà te senge evangan su ebpeamung dan. Nekeuma ran ne wey ran intahù kayi te deruwa ne avang ini se serà ne neutel dan ne reisek dà ne egkeered dan en su elin nepenùpenù. ");
INSERT INTO mbi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nekita rà ni Simon Pedro ini se ned-ulaula ne nekepenimbuel sikandin diyà te etuvangan ni Hisus se egkahi te, “Kenà ka ed-uvey kedì, Kerenan, su beredusa a ne etew.” ");
INSERT INTO mbi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iyan din kinekahi ketà ne negeyipgeyip nevenar sikandin abpeg ke menge ruma rin dut te neutel dan. ");
INSERT INTO mbi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne neinuinu rema ini se menge ruma ni Simon te ebpemiyala ne en si Santiago wey si Juan, ke menge anak ni Sibidyu. Ne migkehiyan ni Hisus si Simon te, “Kenà ka meandek! Engkayi kew en ne duma kew kediey su serà se ebpemiyalaan niyu guntaani, ugaid ne ebpenuruen ku pà sikiyu te iyan niyu mulà egkeutel ne menge etew ne eduma kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne in-ampil dan ke menge avang dan diyà te gebgevasan ne mid-ewaan dan en ini langun su miduma ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Senge hewii ne riyà si Hisus te inged ne ruen meama ne nelumbus ke lawa rin te kevuwa ne muna pà te it-it. Nekita rin si Hisus ne midnunutnunut en se ed-uvey kandin ne mibpemuyù en se egkahi te, “Mama, embiya perem egkiyug ke rà ne egkeulian nu ini se meredsik ne sakit ku.” ");
INSERT INTO mbi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Arà dà ne midampen ni Hisus ke meama se egkahi te, “Uya, egkiyug a, meulii ka!” Arà dà se nekahi rin ne neawà en ke sakit dut te meama su neulian en. ");
INSERT INTO mbi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ne mid-il-ilutan en ni Hisus te egkahi dut te meama te, “Kenà nu ve imbe kegkehiya ini te misan endei en, ugaid ne riyà ka tilandeng te terebpelengesa ne ibpekita nu kandin te neulian ke en. Ne ivehey nu ve kandin ke ibpelengesa te Eleteala ne insuhù dengan ni Moises dut te menge etew ne neulian te sakit dan ne kevuwa su apey metueni te langun te neulian ke en.” ");
INSERT INTO mbi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ugaid ne nasì en ne nekeeneb ke tudtul mekeatag te mid-ulaula ni Hisus, ne migkuludkulud se menge etew ne mibpengkayi te kandin su ebpemineg te penurù din wey ebpemevawì te menge raru ran. ");
INSERT INTO mbi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ugaid ne mid-ewaan din ke merakel ne menge etew su mibpendiyà sikandin te tanà ne warà etew rin ne ketà mibpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Senge hewii ne ebpenurù si Hisus ne ruen menge Peresiyu wey menge meyterù te penduan te Hudiyanen ne midtelavuk ketà. Riyà dan ebpuun te uman inged lusud te Geliliya, ne uman inged lusud te Hudiya, wey diyà dema ebpuun te inged ne Hirusalem. Ne ruen gehem te Eleteala te kebpemawì te raru ne riyà te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ne ruen nekeuma ne menge etew ne ed-ewit te meama ne ed-id-irehà dà diyà te duyanà ne minatey se tevì ne lawa rin. Edlusud perem ini se menge etew ne edyayung su apey ran igkerenà diyà te sineruwan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ugaid ne geina te merakel ne etew ne warà egkepeveyaan dan diyà te kandin. Ketà be ne mibatun dan ne midlekatan dan ke atep ne midtuntun dan ini se meama diyà te luuk te menge etew diyà te sineruwan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Guna su netuenan ni Hisus te rekelà ke sarig dan kandin ne migkehiyan din ke ederaru te, “Mama, nepesehad en ke keberedusaan nu.” ");
INSERT INTO mbi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Guna su nerineg dut te menge meyterù te penduan te Hudiyanen wey ke menge Peresiyu ne ebpinuu ketà ne kehingginawa ran te, “Engkey uvag etawa ini se edsumpalit te Eleteala? Warà etew ne ebpekepesahad te salà embiya kenà ke Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ugaid ne netuenan ni Hisus ke netahù te itungan dan ne migkehiyan din sikandan te, “Meambe ke netahù te itungan niyu se iring keniyan? ");
INSERT INTO mbi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Endei rapit se melemu,” ke si Hisus, “te egkahi riyà te minatey se lawa rin te, ‘Ke menge salà nu ne nepesehad en’ etawa ve egkahi te, ‘Enew ke en ne luluna nu ke ikam nu ne ipanew ke en’? ");
INSERT INTO mbi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Guntaani ne ibpekita ku keniyu,” ke si Hisus, “te ruen gehem dut te Impeanak te Menusiyà te ebpesehad te salà kayi te ampew te dunya.” Ne migkehiyan din en ke meama ne minatey se tevì ne lawa rin te, “Mama, enew ke en ne luluna nu ke ikam nu ne ulì ke en.” ");
INSERT INTO mbi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Arà dà iya ne mid-enew en ke meama ne midlulun din ke ikam din ne mid-ulì en se edeyù te Eleteala dut te keupiya rin kandin. ");
INSERT INTO mbi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Langun dan ne netemenengan dan kayi te nekita ran. Ne mideyù dan te Eleteala se egkahi te, “Mekegeyip iya nevenar ini se nekita tew guntean!” ");
INSERT INTO mbi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Guna su neipus ini ne mid-ipanew en si Hisus ne nekita rin ini se senge etew ne meama ne ebpevayad te buwis ne ed-ingeranan ki Levi ne ebpinuu riyà te upisinà din. Ne migkehiyan ni Hisus sikandin te, “Duma ka kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Arà dà ne mid-itindeg si Levi ne mid-ewaan din ke langun su miduma ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne senge hewii ne mibair si Levi te kevurunan diyà te baley rin su ed-inggaten din si Hisus. Merakel se midtelavuk, ne menge ruma ni Levi ne ebpevayad te buwis wey merakel pà ne etew rema se mibpengaan ne ruma ran. ");
INSERT INTO mbi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Guna su nekita rut te menge Peresiyu wey ruma ne menge sakup dan ne menge meyterù te penduan ne dutun te uvey te valey ne nevurunan te ini se menge etew ne ebpemeked-erungut ki Hisus ne netegtehaad ne mibpendiyà dan te menge edumdumaan ni Hisus se ebpemivig te, “Meambe ke edseveka kew se egkaan kayi te menge etew ne ebpevayad te buwis wey ini se menge etew ne mekesesalà?” ");
INSERT INTO mbi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Migkahi si Hisus te, “Ke menge etew ne warà daru ran ne kenà dan ebpegungeyà te terebawì, ugaid ne ke menge etew rà ne duen daru ran. ");
INSERT INTO mbi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iring din ded be rema kayi te ini se menge etew su kenà iyan ku kinepengkayi se iyan ku ebpeuveyen ne ke menge metidtu kun se ulaula ran, ugaid ne apey ebpekedsendit ke menge etew ne meraat se ulaula ran.” ");
INSERT INTO mbi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Duen menge etew ne mibpengkayi te ki Hisus ne migkahi te, “Duen hewii dut te menge edumdumaan ni Juan ne edlimpas dan te egkaan su apey kenà dan egkevangan dut te kebpengeningeni ran. Ne iring din ded dema ke menge edumdumaan te menge Peresiyu. Ugaid ne keykew ne menge edumdumaan ne kenà edlimpas se egkaan wey ed-inum.” ");
INSERT INTO mbi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne midsempità si Hisus te, “Embiya ruen egkewingan, maa edlimpas be te egkaan ke menge etew ne mid-inggat te ini pà ke ibpengesawa te kandan? Kenà en iya! ");
INSERT INTO mbi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ugaid ne ruen hewii ne egkeuma ne egkeawà ke ibpengesawa diyà te kandan, ne ketà pà sikandan edlimpas te egkaan.” ");
INSERT INTO mbi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne ketà maa ne insempità ni Hisus te kenà egkepakey ne ebpegembiten ke behu ne penurù din wey ke raan ne betasan te keep-epuan dan, ke sikandin te, “Warà etew ne ebisey te behu pà ne belegkas su idapi te belegkas ne redit en. Su embiya ini se ed-ul-ulaan din ne midereetan din ke behu ne belegkas, ne ini se dapi ne behu pà ne kenà edait dut te redit en ne velegkas. ");
INSERT INTO mbi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne iring din ded dema,” ke si Hisus, “ke behu pà ne tebà su kenà egkepakey ne riyà idtahù ini te raan en ne edtehuan ne lundis te kambing. Su embiya ini se ed-ul-ulaan din ne edsevu ke tebà ne ebetu ke raan ne lundis ne midtehuan, ne edturayas ke tebà ne egkereetan dema ke midtehuan ne lundis. ");
INSERT INTO mbi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tembù be iyan be kemeyidan ne ke behu pà ne tebà ne idtahù te edtehuan ne behu pà ne mibeelan. ");
INSERT INTO mbi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne warà etew,” ke si Hisus, “ne nekeinum en te raan en ne tebà ne egkiyug ne ed-inum pà te behu ne tebà su egkahi sikandin te, ‘Ke raan en se meupiya ne teba.’” ");
INSERT INTO mbi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Senge hewii ne Sepetu, ke Hewii ne Id-imeley, ne midtarà si Hisus wey ke menge edumdumaan din diyà te pareyanan. Ne gewii ran te edtarà ne ebpengurib ke menge edumdumaan ni Hisus te parey ne idsungit dan. ");
INSERT INTO mbi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ne ruen ketà menge Peresiyu ne migkahi te, “Meambe ke ed-ul-ulaan niyu ini se ebpekesurang te Penduan tew ne egkahi te warà egelevek te hewii ne id-imeley?” ");
INSERT INTO mbi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne migkahi si Hisus te, “Maa, warà niyu mevasa ke impesurat te Eleteala mekeatag te mid-ulaula ni David, ke datù tew rengan? Su ruen hewii ne sikandin wey ini se menge sundaru rin ne nengevitil dan. ");
INSERT INTO mbi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ne midlusud si David diyà te insivey ne Valey te Eleteala ne migkuwa rin ke egkeenen ne indenà diyà te Eleteala ne migkaan sikandin ne mibehayan din ke menge ruma rin. Ugaid ne kayi te penduan tew ne kenà arà egkekaan te piya engkey ne etew su ke menge terebpelengesa rà te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne migkahi pà maa si Hisus te, “Ke Impeanak te Menusiyà ke ebayàbayà te egkahi te engkey se edait ne ed-ul-ulaan dut te Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Senge Hewii maa ne Id-imeley ne mibpendiyà si Hisus te valey ne ebpengedian te menge Hudiyanen ne mibpenurù. Ne ruen ketà senge etew ne meama ne nekeyengkeng se kewanan ne velad din. ");
INSERT INTO mbi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Duen dema ketà menge Peresiyu wey menge meyterù te penduan ne ebpenipat ki Hisus embiya egkeulian din ini se etew te arà ne hewii ne id-imeley su ebpemengaan dan ke engkey se kegkesuhat dan ki Hisus te kevenar. ");
INSERT INTO mbi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ugaid ne netuenan en ni Hisus ke netahù te itungan dan ne migkehiyan din en ke meama ne nekeyengkeng se velad din te, “Mama, itindeg ka kayi te uvey ku.” Ne mid-itindeg en ke meama ne mid-uvey en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne migkahi en si Hisus dut te menge etew ne nevurun ketà te, “Duen id-insà ku keniyu: Engkey ma se nekahi te penduan tew ne idtuhut ne ed-ul-ulaan tew te hewii ne id-imeley? Maa, edtavangan tew ke menge ruma tew etawa ebpemekeiran tew sikandan? Maa, edsumpatan tew ke umur te menge ruma tew etawa ed-imetayan tew?” ");
INSERT INTO mbi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne insihid din ke mata rin dut te langun ne menge etew ne migkehiyan din ke meama ne nekeyengkeng se velad din te, “Mama, ketenga nu ayan se velad nu.” Ne ketà ne migketeng dut te meama ke velad din, ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ketà ne neregreg te langet dan ke menge Peresiyu wey ke menge meyterù te penduan ne mibpein-inseey ran en ke engkey se ed-ul-ulaan dan ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nengepiraan ketà ne midtekereg si Hisus diyà te buvungan su ebpengeningeni, ne nepewpewaan se kebpengeningeni rin te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nepawà ne miburun din ke langun ne menge etew ne edurumaruma kandin ne mibpemilì sikandin te sepulù wey deruwa ne edumdumaan din ne mid-ingeranan din te Apustulis. ");
INSERT INTO mbi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iyan dan ngaran ini se nepemilì din ne si Simon (ke ed-ingaranan dema ki Pedro) wey ke ari rin ne si Andres, si Santiago wey si Juan, si Felipe wey si Bartolome, ");
INSERT INTO mbi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo wey si Tomas, si Santiago ne anak ni Alfeo, wey si Simon (ne ed-ingaranan dema te Patriat ne iyan din meana ne diralem se lengesa rin dut te inged din), ");
INSERT INTO mbi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Hudas ne anak ni Santiago wey si Hudas Iskeriyuti ne ed-ulug ki Hisus diyà te menge kunterà din. ");
INSERT INTO mbi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne midtupang si Hisus wey ke menge nepemilì din ne mid-engked dan ketà te malù mepatag. Ne ketà ne ruen nevurun ne merakel ne etew ne edurumaruma kandin wey menge etew ne riyà ebpuun te langun ne menge inged lusud te Hudiya, ne riyà ebpuun dema te Hirusalim, wey riyà ebpuun te menge inged ne Tiru wey Sidun diyà te beyvey te rahat. ");
INSERT INTO mbi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mibpengkayi ran su ebpemineg te kebpenurù ni Hisus wey ebpevawì dema te menge raru ran. Duen kayi te menge etew ini midtevereg te vusew ne neulian ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ne langun ne menge etew ne migeram midsinagkew ki Hisus su ruen gehem din ne ketà ebpuun te kandin ne ebpekeulì te menge raru dut te langun dan. ");
INSERT INTO mbi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ne midtengtengan ni Hisus ke menge edumdumaan din ne migkahi en te, “Dayirayi kew ne menge ayuayu, su sikiyu ke edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dayirayi kew ne menge egkevitil guntaan, su ebpekevulungan kew te Eleteala keuremà. Dayirayi kew ne menge egkemutu guntaan, su egkehalewhalew kew keuremà. ");
INSERT INTO mbi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dayirayi kew ke egkeepesan kew te menge etew ne kenà kew nikandan edsehipaan, ne ebpenempelaen kew, wey egkahi ran te mereatey kew su kayi egenat dut te keduma niyu ke Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Su iring kayi ke imped-ulaula te keep-epuan dan dut te menge etew ne mibpelambas te Lalag te Eleteala rengan. Egkehalew kew ke ini se egketemanan niyu ne id-idangdang kew su dekelà se lalew ne ebpenerengen niyu diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ugaid ne mekeruanduan kew ne menge kewasa guntaan, su nepehinlelawan niyu ke meupiya ne egketemanan niyu kayi. ");
INSERT INTO mbi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mekeruanduan kew ne ebpengevulung guntaan, su ruen timpu ne egkevitil kew keuremà. Mekeruanduan kew ne nengehalew guntaan, su ruen timpu ne egkemutu kew wey ebpekesinehew kew keuremà. ");
INSERT INTO mbi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mekeruanduan kew ke edeyuen dut te langun ne menge ruma niyu, su ini se mid-ulaula te keep-epuan dan dengan, su mibpendeyù dan ke mibèbeelan dà ne mibpelambas te Lalag te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ne migkahi pà maa si Hisus te, “Iyan ku igkahi keniyu, langun niyu ne edtaan te telinga niyu, ne limui niyu ke menge kunterà niyu, ne upiani niyu ke hinawa niyu rut te egkengeepes keniyu. ");
INSERT INTO mbi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ipengeningeni niyu te ebpeneuven te Eleteala ke menge etew ne ebpenrawak keniyu, ne ke menge etew ne ed-ayuaya keniyu ne ipengeningeni niyu sikandan. ");
INSERT INTO mbi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Embiya ruen etew ne edtabpì te naping niyu ne kenà kew bangen ke edtebpien din ke divaluy. Embiya ruen etew ne ed-ahew te kumbalà niyu ne kenà kew bangen ke egkuan din ke belagkas niyu ne kemisita. ");
INSERT INTO mbi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Embiya ruen etew ne ebuyù keniyu ne behayi niyu, ne embiya ruen etew ne egkuwa te keleglehan niyu ne kenà niyu en ewia. ");
INSERT INTO mbi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ne misan engkey ne egkiyuhan niyu ne ibped-ulaula te menge etew keniyu, ne iring ketà dema se ul-ulaa niyu riyà te kandan. ");
INSERT INTO mbi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Embiya iyan niyu rà igkelimù ke menge etew ne egkelimù keniyu, ne meambe ke ebpenareng kew te kebpenaub te Eleteala keniyu? Su misan ke menge beredusa ne igkelimù dan dema ke menge etew ne egkelimù kandan. ");
INSERT INTO mbi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne embiya iyan niyu rà ed-upianan ke menge etew ne ed-upiya keniyu, ne meambe ke ebpenareng kew te kebpenaub te Eleteala keniyu? Su misan ke menge beredusa ne ed-upiya ran dema rut te menge etew ne ed-upiya kandan. ");
INSERT INTO mbi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne embiya iyan niyu rà ebpeutangen ke menge etew ne kenà duwaruwa ne ebpekevayad, ne meambe ke ebpenareng kew te kebpenaub te Eleteala? Su misan ke menge beredusa ne ebpeutang dema rut te menge beredusa embiya kenà duwaruwa ne ebpekevayad. ");
INSERT INTO mbi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ugaid ne sikiyu, iyan ku igkahi keniyu ne limui niyu ke menge kunterà niyu ne upiani niyu ke ed-ul-ulaan niyu kandan. Embiya ebpeutang kew ne kenà niyu pegitunga te kebpevayad ne ketà ne rekelà se idlalew keniyu. Su embiya ini se ed-ul-ulaan niyu, ne egkekita kayi te keniyu te sikiyu ne menge anak en te Eleteala ke mepmepurù te langun. Su melimù ke Eleteala misan diyà te menge etew ne warà te hinawa ran ke tavang din wey ke menge etew ne meraat se ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tembù be keyru kew te ruma ne etew iring dut te kegkeyru te Amey niyu riyà te langit kayi te langun niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ne migkahi pà maa si Hisus te, “Kenà kew edsawey te ruma ne etew, ne kenà kew edsewayan te Eleteala. Kenà niyu imesara te egkahi te nevenaran ke ruma ne etew ne kenà ed-imasad ke Eleteala te egkahi te nevenaran kew. Pesehara niyu ke salà te ruma ne etew ne ebpeseharen te Eleteala ke salà niyu. ");
INSERT INTO mbi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Behayi niyu ke ruma ne menge etew ne ebehayan kew rema te Eleteala. Ne iyan din ibehey keniyu ne ed-ip-ipenuen din ne ed-es-eseken din ne arà pà ne eberundtuwan din ke ibusbus ketà te edtehuan niyu. Su ke kerekelà te ibehey niyu te ruma ne etew ne iyan ded kerekelà te ibehey te Eleteala keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ne mibpenempità si Hisus te, “Embiya ruen etew ne pisek, ne kenà egkepakey ne edtuyuk te etew ne pisek ded dema. Su embiya elin dan pisek ne ebpeked-unung dan se egkeulug diyà te lepak. ");
INSERT INTO mbi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ne warà etew ne ebpepenurù pà ne iyan en mepurù dut te ebpenurù kandin, ugaid ne embiya netamat din en ke langun ne impenurù kandin ne ebpekeiring en dut te mibpenurù kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ne ruen pà maa migkahi ni Hisus, ke sikandin te, “Meambe ke edturikan nu ke salà te ruma nu ne iring te pesek, ugaid ne warà ma te hinawa nu te ruen salà nu ne iring te gedgeran kerekelà din? ");
INSERT INTO mbi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Engkey se kedtikà nu te egkahi riyà te ruma nu te id-awà nu ke pesek din, ugaid ne ruen ma nekepesek kenikew ne iring te gedgeran kerekelà din ne kenà nu egketuusan? Engkey en ayan ne kedtarùtarù! Unai nu pà te ed-awà ke nekepesek kenikew ne iring te gedgaran ne an pà ne ebpekekita ke en ne ebpengawà te pesek te ruma nu.” ");
INSERT INTO mbi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Duen pà maa migkahi ni Hisus, ke sikandin te, “Ke kayu ne meupiya se kegueyhuey rin, ne kenà ebahas te meraatey. Ne iring ded maa ke kayu ne ruen sakit din, ne kenà ebahas te meupiya. ");
INSERT INTO mbi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Su piya engkey ne kayu ne kayi nu egketueni te bahas din. Su kenà ebahas ke sepinit te paras, ne kenà ebahas ke merevuaya te igira. ");
INSERT INTO mbi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ne engketà ded dema se menge etew,” ke si Hisus, “su ke etew ne meupiya se ulaula rin, ne meupiya rema se kedlalag din su meupiya se intahù te hinawa rin. Ugaid ke etew ne mereatey se ulaula rin, ne mereatey rema se kedlalag din su iyan din intahù te hinawa rin ne mereatey. Su piya engkey se intahù te etew te hinawa rin ne ini se egemew te bèbà din.” ");
INSERT INTO mbi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ne ruen pà lavew migkahi ni Hisus, ke sikandin te, “Meambe ke layun a niyu ed-ingerani te ‘Kerenan’, ugaid ne kenà kew ma eduma rut te igkahi ku keniyu? ");
INSERT INTO mbi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Idtarem ku keniyu ke engkey se egkeiringan dut te menge etew ne ed-uvey kedì ne ebpemineg te lalag ku ne ebperumdumaan dan. ");
INSERT INTO mbi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Embiya idsempita ta ne iring sikandin te etew ne riyà mebevaley te mevaher. Pehaney ne migkekalut sikandin te meralem ne midtehuan din te rekelà ne batu ne arà pà ne imbunsud din ke pelaus. Nepasad ini se valey ne midalem ke wayig ne nerumpak te wayig ini se valey, ugaid ne warà mekugal ke valey su midtegtehaman ma. ");
INSERT INTO mbi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ugaid ne ke etew,” ke si Hisus, “ne ebpemineg kedì ne kenà din ebperumdumaan ke lalag ku ne iring sikandin te etew ne riyà mebevaley te ebpengesal-esalen dà diyà te pantad. Nepasad ini se valey ne nerumpak te dalem, ne arà dà ne nerundus en ne newahey en.” ");
INSERT INTO mbi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nekeipus si Hisus se ebpenurù te menge etew ne mibpendiyà sikandin te inged ne Kapirnawum. ");
INSERT INTO mbi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Duen ketà te inged kepitan ne kenà Hudiyanen ne egkamal te menge sundaru ne ruen edsugsuhuen din ne meama ne egkepesangan su iyan deruwa se kebpatey. Ne dekelà te hinawa te kepitan ini se edsugsuhuen din. ");
INSERT INTO mbi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Guna su nerineg dut te kepitan se kebpemawì ni Hisus te daru ne midsuhù sikandin te menge pekilukesen ne Hudiyanen su ebpeengayen ki Hisus su apey meulii ini se edsugsuhuen din. ");
INSERT INTO mbi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nekeuma ran kayi te ki Hisus ne midsebenar dan mibpemuyù kandin se egkahi te, “Metidtevangi arà se kepitan ne dait ne edtevangan nu sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ne kenà deisek dà ke hinawa rin kayi te langun tew ne menge Hudiyanen, su sikandin se mibpeitindeg ketà te valey ne ebpengedian tew.” ");
INSERT INTO mbi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ne miduma en si Hisus kandan. Iyan dan kebpelingguma riyà te valey te kepitan ne impesinuhung en dut te kepitan te menge ruma rin ne ini se impekahi rin dut te midsinuhung ki Hisus, “Mama,” ke sikandin, “misan kenà ke en edlaus diyà te valey ku su kenà a dait ne ebpemenayikan nu. ");
INSERT INTO mbi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tembù be warà a medsinuhung keykew su kenà a rema edait. Dekelà se gehem nu ne misan igkahi nu te, ‘Meulii sikandin,’ ne egkeulian ini se edsugsuhuen ku. ");
INSERT INTO mbi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nesebutan ku ini su siaken ne ruen mepurù ku ne meperumaruma a kandin. Ne ruen menge sundaru ne egkemalan ku ne meperumaruma ran kediey. Su egkahi e rà te, ‘Diyà kew,’ ne iring dan te ebelesiken. Ne engketà ded ke egkahi a te, ‘Kayi kew,’ ne seperek mata ne kayi ran en. Ne embiya edsuhuen ku ini se edsugsuhuen ku te, ‘Ul-ulaa nu ini,’ ne arà en iya rema se ed-ul-ulaan din. Iring de be kayi misan edlelehan nu rà ne egkeulian ini se sugsuhuen ku.” ");
INSERT INTO mbi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nerineg ni Hisus ini, ne neinuinu nevenar sikandin. Ne mibengkiring sikandin dut te merakel ne etew ne ed-eguyut kandin ne migkahi en te, “Igkahi ku ini te warà pà mekeuma te etew ne iring kayi kerekelà se sarig din kediey misan kayi te langun ne kevuwaran ni Israyil!” ");
INSERT INTO mbi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mid-ulì en ini se impesinuhung ki Hisus, ne guna su nekeuma ran diyà te valey te kepitan ne neulian en ini se edsugsuhuen. ");
INSERT INTO mbi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nengepiraan be maa ketà ne mibpendiyà si Hisus te inged ne ed-ingaranan te Nain. Ne denda se menge etew ne miduma kandin abpeg ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Guna su ebpelingguma ran ketà te belvelakan te inged ne nekesinuhung dan te merakel ne etew ne ebelanting te minatey. Ini se ebelentingen ne minatey ne budtung ne anak ne meama te meritan ne valu, ne merakel se menge etew riyà ebpuun te inged ne miduma kayi te valu te edleveng. ");
INSERT INTO mbi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nekita ni Hisus ke iney rut te minatey ne neyru nevenar sikandin ne migkahi en te, “Kenà ka edsinehew, Ayà.” ");
INSERT INTO mbi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne mid-uvey en si Hisus ne migeweran din ke lungun ne mid-itindeg ke menge meama ne ebelanting. Ne migkehiyan ni Hisus ke minatey te, “Mama, enew ka!” ");
INSERT INTO mbi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Arà dà ne mid-enew en ke minatey ne midlalag en. Ne migkahi en si Hisus kayi te iney rin te, “Ini en, Ayà, ke anak nu.” ");
INSERT INTO mbi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Langun dan te nekekita ne netemenengan, ne nekereyù dan te Eleteala se egkahi te, “Ini pè be ne neumaan ki te metmetehel ne ebpelambas te Lalag te Eleteala. Benar, impekita te Eleteala ke kedtavang din te ebpeliyu dut te menge etew ne mibpemilì din.” ");
INSERT INTO mbi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nekeeneb en ini se mid-ulaula ni Hisus kayi te lusud te Hudiya wey riyà dema te nekelingut ne inged. ");
INSERT INTO mbi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Guna su nerineg dut te menge edumdumaan ni Juan ke Ebpembunyag ini se langun ne mid-ulaula ni Hisus ne imperineg dan ki Juan diyà te bilengguan. Ne midtawag si Juan te deruwa rut te edumdumaan din, ");
INSERT INTO mbi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ne midsuhù din diyà te ki Hisus te ebpeinsà kandin te, “Menu, sikuna ke impesabut ni Juan ne ibpepengkayi te Eleteala etawa ruen duma pà ne egkepenareng dey?” ");
INSERT INTO mbi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nekeuma ran ne migkahi ran te, “Iyan dey lakew te mibpengkayi ne midsuhù key ni Juan ke Ebpembunyag su ibpeinsà kenikew ke embiya sikuna en iya ke impesabut din ne ibpepengkayi te Eleteala etawa ruen ruma pà ne egkepenareng dey?” ");
INSERT INTO mbi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ne arà dema ne hewii ne ruen merakel ne etew ne neulian ni Hisus dut te menge daru ran wey menge sakit. Mibpenegseg din ke menge vusew ne edamung-amung kandan, ne impeulit din ke kebpekekita rut te menge pisek. ");
INSERT INTO mbi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne migkahi si Hisus diyà te menge suhù ni Juan te, “Ulì kew en diyà te ki Juan ne penudtula niyu kandin ini se nekita niyu ne mid-ulaula ku wey ini se nerineg niyu ne migkahi ku. Iyan niyu peketueni kandin ne kayi ebpuun te kediey ne nekeulit en se kebpekekita rut te menge pisek, nekeipanew en ke menge pungkù, neulian en ke menge kevuwaen, nekerineg en ke menge bengel, neuyag en ke menge minatey wey impesabut ku ke Meupiya ne Tudtul diyà te menge ayuayu. ");
INSERT INTO mbi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ne peketueni niyu kandin,” ke si Hisus, “te dayirayi nevenar ke etew ne kenà eduwaruwa kediey.” ");
INSERT INTO mbi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Guna su mid-ulì en ke menge suhù ni Juan ne midlalag en si Hisus mekeatag ki Juan diyà te denda ne menge etew ne nevurun, ke sikandin te, “Ketà te kinependiyà niyu te ki Juan diyà te tanà ne kenà egkeubpaan te menge etew, ne engkey se mibpenareng niyu ne egkekita niyu? Maa, ebpenareng kew te ebpekekita kew te etew ne iring te karan ne edsemsemberen te keramag? ");
INSERT INTO mbi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Engkey ve iya, etew ne mibevelegkas te nepenù te rayandayan? Kenà buwa su ke etew ne mibevelegkas te iring ketà ne meupiya nevenar se egketemanan din ne riyà niyu rà egkekita te turuhan te menge ratù. ");
INSERT INTO mbi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Engkey ve iyan se mid-intengan niyu? Engkey, etew ne ebpelambas te Lalag te Eleteala? Arà imbe! Ugaid ne igkahi ku keniyu te arà se nekita niyu ne labi pà dut te etew ne ebpelambas te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Su si Juan ini ke impeuna kediey ne nekahi te Eleteala rut te impesurat ne Lalag din rengan ne egkahi te, ‘Duen edsuhuen ku ne ibpeuna ku keykew te kebpekepenehana rut te menge etew te kebpekeuma nu.’” ");
INSERT INTO mbi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne migkahi pà maa si Hisus te, “Tentenuri niyu ini, warà pà etew ne in-anak kayi te ampew te dunya ne ebpekerepeng ki Juan ke Ebpembunyag. Ugaid ne misan ke kevevaan en ne etew dut te langun ne Edetuan te Eleteala diyà te langit ne labi pà ki Juan.” ");
INSERT INTO mbi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ini se migkahi ni Hisus ne nerineg en dut te langun ne etew ketà misan ke menge ebpevayad te buwis ne egkehiyen ne mekebeberedusa. Ne mibpehimbenar dan te metidtu ke menge petiralan te Eleteala ne mibpebunyag dan ki Juan. ");
INSERT INTO mbi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ugaid ke menge Peresiyu wey ke menge meyterù te penduan te Hudiyanen ne mid-engkenà dan dut te ibpetuman te Eleteala kandan, ne warà dan mebpebunyag ki Juan. ");
INSERT INTO mbi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ne migkahi pà maa si Hisus te, “Ini se menge etew te huntaani en, engkey se ebpeiringan ku? ");
INSERT INTO mbi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iring dan en iya te menge vatà ne ebpemimpinuu riyà te kevurunan. Ed-umew ini se senge puntuk diyà te menge ruma ran te, ‘Midlebpad key, ugaid ne warà kew medsayew! Mibminudar key, ugaid ne warà kew medsinehew!’ ");
INSERT INTO mbi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iring din ded dema ke kebpekeuma ni Juan ke Ebpembunyag, su nekita niyu te edlimpas te kegkaan si Juan ne kenà dema ed-inum te piya engkey ne ebpeketevereg ne iyan niyu migkahi se, ‘Midsuukan sikandin te vusew!’ ");
INSERT INTO mbi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ne mibpengkayi ke Impeanak te Menusiyà ne nekita niyu te migkaan sikandin wey mid-inum ne iyan niyu maa migkahi se, ‘Tengtengi niyu ma ayan se midelungan te bitil! Ne metehel ne ed-inum! Ne teleduma kayi te ebpevayad te buwis wey misan ke menge etew ne kenè en birang.’ ");
INSERT INTO mbi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ugaid,” ke si Hisus, “ketà te menge ulaula te menge etew ne tidtu ne mibperetiyaya te Eleteala ne nekeheram te limù din ne egkekita te utew metau ke Eleteala te langun ne petiralan din.” ");
INSERT INTO mbi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Duen senge etew ne Peresiyu ne mid-inggat ki Hisus diyà te valey rin su riyà din ebpekeena. Ne miduma si Hisus kandin ne nekeuma ran ne mibpeer-erungutey ran en se egkaan. ");
INSERT INTO mbi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ketà te inged ne ruen senge etew ne meritan ne warà keeleran din. Nerineg din se riyà egkaan si Hisus te valey te Peresiyu ne mibpendiyà sikandin se ed-ewit te pelenaan ne mibeelan te elibastru ne midtehuan te periyemut ne mepurù nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ne mid-uvey ki Hisus dapit te paa rin se edsinehew ne nengeulug se luwà din kayi te paa ni Hisus. Ketà ne mibpunasan din en te bulvul din, ne mid-erekan din, ne mibusbusan din en kayi te lana ne meemut nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nekita kayi te Peresiyu ne mid-inggat ki Hisus, ne ke hingginawa rin te, “Embiya benar ne ebpelambas te Lalag te Eleteala si Hisus ne egketuenan din ke engkey ini se meritan ne edsapu kandin wey ini se warà keeleran din!” ");
INSERT INTO mbi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ketà ne migkahi en si Hisus kandin te, “Simon, duen igkahi ku kenikew.” “Ew, engkey?” ke si Simon. “Kehiya nu en.” ");
INSERT INTO mbi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne mibpenempità si Hisus kandin, ke sikandin te, “Duen deruwa ne etew ne nekeutang diyà te etew ne ebpemeutang te kureta ne lelima nehatus se mid-utang dut te senge etew, ne mid-utang ke seveka te lelima nepulù ne pirak. ");
INSERT INTO mbi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne guna su kenè en ebpekevayad ini se deruwa ne mid-utang ne migkahi ke mid-utangan dan te, ‘Beleharen en ke utang niyu.’ Ne mid-insà si Hisus ki Simon te, ‘Endei rapit kandan ini te deruwa se egkelimù nevenar ketà te meama ne mibpeutang kandan?’” ");
INSERT INTO mbi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ke si Simon te, “Arà buwa se dekelà se utang din ne warà din en peveyari.” Ke si Hisus te, “Arà iya!” ");
INSERT INTO mbi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Midsineruwan ni Hisus ke meritan ne migkehiyan din si Simon te, “Iring ded be imbe kayi te meritan ini. Su mibpemenayik a kayi te valey nu ne warà a nu behayi te ibpepenlùlù te paa ku misan ini ke betasan tew. Ugaid ne sikandin mulà ne midlùluan din te luwà din ke paa ku ne mibpunasan din te bulvul din. ");
INSERT INTO mbi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Warà a nu en iya gelhelawa te ked-arek dut te kebpemenayik ku te valey nu misan ini ke betasan tew. Ugaid ne ini mulà se meritan ne mibpulungpulung en mid-arek te paa ku igenat te kebpekeuma ku. ");
INSERT INTO mbi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Warà nu petehisi ke ulu ku te lana misan ini ke betasan tew te kebpeed-edatey. Ugaid ne sikandin mulà ne mibusbusan din ke menge paa ku te belielehà ne periyemut. ");
INSERT INTO mbi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tembù migkahi ku ini,” ke si Hisus, “su misan dekdekelà se salà din ne mibpesahad en te Eleteala su dekdekelà se limù ne impekita rin kediey. Ugaid ke etew ne reisek se keberedusaan din ne mibpesahad te Eleteala, ne reisek dema se limù ne ibpekita rin.” ");
INSERT INTO mbi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne migkahi en si Hisus ketà te meritan te, “Mibpesahad en te Eleteala ke keberedusaan nu.” ");
INSERT INTO mbi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ne ruen netahù te hinawa rut te menge etew ne migkaan ketà ki Hisus, ke hingginawa ran te, “Engkey ini ne etew se ebpekepesehad te keberedusaan te etew?” ");
INSERT INTO mbi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ne migkahi pà maa si Hisus ketà te meritan te, “Nekeliyu ke en te kedusa te Eleteala te salà nu su kenà duwaruwa ke kedsarig nu te Eleteala. Na, ulì ke en, ne menu ma ke edumaan ka te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nengepiraan ne hewii ketà ne mibpendiyà si Hisus te ruma ne menge inged, dekelà wey deisek, ne mibpesebutan din dut te menge etew ketà ke Meupiya ne Tudtul mekeatag te Kedetui te Eleteala te menge etew. Ne miduma kandin ke sepulù wey deruwa ne edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Duen dema ketà menge meritan ne miduma kandan ne nengeulian te menge daru ran, ne ruma kandan ne pehaney ne mid-em-emungan te vusew ugaid ne midsegseg ni Hisus. Senge etew kandan ne si Maria (ne mid-ingaranan dema ki Magdalena) ne mibpenegsehan ni Hisus te pitu ne vusew. ");
INSERT INTO mbi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ne ruen dema ketà si Juana ke esawa ni Kusa, ne midserihan ni Hirudis ke mepurù dan diyà te turuhan din. Si Susana rema wey merakel pà ne meritan ne miduma engki Hisus su edtuganur kandan te egenat te pentiyari ran. ");
INSERT INTO mbi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iring ma te edtevur se menge etew ne mibpengkayi te ki Hisus ne kayi egenat te ebalàbalà ne menge inged. Guna su merakel se nevurun ketà ne mibpenempità si Hisus kandan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ruen etew ne mibpendiyà te pengengewiran din su edsawed te benì. Ne ketà te kinesawed din ne ruen benì ne nengeulug diyà te kilid te ralan ne nengehiekan te etew ne midtuktuk en te menge pepenuk. ");
INSERT INTO mbi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Duen ruma ne insawed din ne riyà nengeulug te kebetuwan. Midtuvù ini ugaid ne mehaan dà ne neebmas su edsahad dà ke wayig. ");
INSERT INTO mbi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Duen dema insawed din ne riyà nengeulug te sepinitan. Ne midtuvù ini ugaid ne migkubmusan en dut te sepinit. ");
INSERT INTO mbi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Duen ded dema insawed din ne riyà nengeulug te meupiya ne tanà ne midtuvù ini ne nekevahas te meupiya su mibpengupiya nevenar se bahas din.” Ne migkahi pà maa si Hisus te, “Itaan niyu ve ke telinga niyu kayi te nerineg niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ne mid-insà ke menge edumdumaan din te, “Engkey se meana rin ini se sempità ne imperineg nu kenami?” ");
INSERT INTO mbi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne migkahi si Hisus kandan te, “Sikiyu en imbe se ebpesebuten te Eleteala rut te warà din pà impayag te piya engkey ne etew mekeatag dut te kedatù din te menge etew. Ugaid ke ruma ne menge etew ne ibpepevayà te sempità su apey, misan edtengteng dan, ne kenà dan ebpekekita; ne misan egkerineg dan, ne kenà dan egkesebutan ke meana rin.” ");
INSERT INTO mbi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ne migkahi pà maa si Hisus dut te edumdumaan din te, “Ini se meana rin arà se sempita ku: Ke benì ne insawed dut te etew ne arà ke Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ke ralan ne neuluhan te benì ne arà ke menge etew ne nekerineg te Lalag te Eleteala, ugaid ne midegdehawen ni Setanas ke datù te pekaid te ed-ahew ke lalag su apey kenà dan mekeperetiyaya ne kenà dan egkepeliyu. ");
INSERT INTO mbi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ne ke kebetuwan ne neuluhan te benì ne arà ke menge etew ne nekerineg te Lalag te Eleteala ne ingkehalew ran te ebpemineg ne mibperetiyaya ran, ugaid ne mehaan dà se kineperetiyaya ran su warà mekedalid te hinawa ran. Ne wey ran penggerami ni Setanas dut te peretiyaya ran ne midlekà dan en. ");
INSERT INTO mbi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ne ke sepinitan ne neuluhan te benì ne arà ke menge etew ne nekerineg te Lalag te Eleteala, ugaid ne gewii ran te ebpetindalan ne merakel se egkubmus dut te lalag ne nerineg dan iring te kemutuwan dan te ked-ubpà-ubpà, ne kegkelilingey ran dut te menge kearen dan, wey ke pegungayà te kebpatà te nanam, ne warà dan en mekeuma te kebehas dan. ");
INSERT INTO mbi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne ke meupiya ne tanà ne neuluhan te benì, ne arà ke menge etew ne nekerineg te Lalag te Eleteala ne midtelimà dan ne warà dan midsanggel se ebperetiyaya. Ne mibpenemtemanan dan te edtuman taman te nekeuma ran te kebehas.” ");
INSERT INTO mbi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ne migkahi en maa si Hisus te sempità kandan te, “Warà etew ne midtemtem te sulù ne ebpelengkevan din etawa ibperalung din. Ugaid ne riyà din ibpeluukluuk te saag su apey egkerayahan ke etew ne edlusud. ");
INSERT INTO mbi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Iring din ded dema,” ke si Hisus, “langun te netelevan guntaani ne ebpekepehawahawa red dut te akir din ne hewii. Ne langun ne impegelesà ne egkepayahan ded. ");
INSERT INTO mbi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Itaan niyu ve ke telinge niyu,” ke si Hisus. “Su ke etew ne idtahù din te hinawa ke ibpesabut kandin te Eleteala, ne ed-umanan pà te Eleteala ini se kebpekesabut din. Ugaid ke etew ne kenà din idtahù te hinawa ke ibpesabut kandin te Eleteala, ne egkeawà arà se reisek ne kunaan din ne nesebutan din en.” ");
INSERT INTO mbi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nekeuma en ke iney ni Hisus wey ke menge ari rin ne meama, ugaid ne warà dan mekeuvey ki Hisus su neterektek te etew sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne ruen migkahi ki Hisus te, “Ke iney nu wey ke menge ari nu ne riyà te lihewangan su ebpekibalak dan keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ugaid ne migkahi si Hisus dut te menge etew ketà te, “Iyan ku iney wey menge ari ne ke menge etew ne ebpemineg te Lalag te Eleteala wey ebperumdumaan dan.” ");
INSERT INTO mbi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Senge hewii ketà ne migkehiyan ni Hisus ke edumdumaan din te, “Kuwa kiyu en su ed-apet kiyu riyà te ripag te ranew.” Arà dà ne mid-untud dan te avang ne mibpuridtas dan en. ");
INSERT INTO mbi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Guna su ed-avang-avang dan en ne midsaharan si Hisus te turug. Ne midtekewtekew en se mevandes ne keramag kayi te ranew ne nesimbuhan en te wayig ke avang dan, ne reisek samà ne egkeherà dan en. ");
INSERT INTO mbi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mid-uvey ran si Hisus ne mibpukew ran en se egkahi te, “Meyterù, egkeherà ki en!” Ne mid-enew si Hisus ne pineengked din en ke keramag wey ke dekelà ne baleg. Arà dà ne mid-eneng-eneng en ke keramag wey baleg ne seguguneey ne midlengen ke ranew. ");
INSERT INTO mbi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ne migkehiyan din en ke menge edumdumaan din te, “Meambe ke nengeandek-andek kew? Maa kenà kew ves edsarig kediey?” Ne neandek-andek dan ne neinuinu ran su mibpein-inseey ran te, “Engkey ini ne etew? Su misan ke keramag wey menge baleg ne ebperumaruma rut te lalag din!” ");
INSERT INTO mbi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ne nekerunggù en ensi Hisus dut te telipag te pruvinsiya te Geliliya, diyà te sakup te inged te menge Gerisiyanu. ");
INSERT INTO mbi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Guna su migaun en si Hisus ketà te avang ne midsinuhung en sikandin te senge etew ne midsuukan te vusew ne andang ne mehinged ketà te Gerisiyanu. Ugaid ne neuhet en ne warà mid-ulì sikandin te ubpaan din su kayi en mid-ubpà te menge surung ne penlelevengan ne warà en seseberen din. ");
INSERT INTO mbi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nekita rin dà si hisus ne midrawak en ne midlumpeng diyà te sineruwan ni Hisus ne mibensag en se egkahi te, “Sikuna ini si Hisus ke Anak te Eleteala ne warà repenge din. Engkey ma se kememeniyà nu kediey? Isapà nu te etuvangan te Eleteala te kenà a nu pemekeiri!” ");
INSERT INTO mbi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ini se mibuyù din su migkehiyan ni Hisus arà se vusew te ibpeawà diyà te meama. Su kenà kepipira rà ewita arà se meama dut te vusew ne ebpemekaid kandin. Ne misan ebekuen ke paa rin wey ke velad din te kedina ne ebentayan te menge etew ne ebpengevidtew rin ded ne ed-ewiten en maa sikandin dut te vusew diyà te tanà ne kenà egkeubpaan te etew. ");
INSERT INTO mbi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ne migkehiyan en ni Hisus sikandin te, “Engkey ma se ngaran nu?” Ne midtavak te, “Iyan ku ngaran ne si Selasà.” Tembù nekahi rin ini su medmerakel ne vusew se midsuuk kandin. ");
INSERT INTO mbi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne mibpemuyù dan ki Hisus te kenà dan ibpeawà ni Hisus se ibpependiyà te egkembusan ne warà edtemanan te keralem din. ");
INSERT INTO mbi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne ruen ketà te uvey medmerakel ne bavuy ne ebpemenumal diyà te kelendihan, ne mibpemuyù ke menge vusew ki Hisus te dutun dan ibpepeawuk te menge bavuy ne midtuhutan dema ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ketà dà ne mid-ewaan dan en ke meama ne mibpengasuk dan en dut te menge bavuy, ne mibpemelelahuy en ke menge bavuy se ed-umpak diyà te dempilas ne nengelened dan en diyà te ranew. ");
INSERT INTO mbi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Guna su nekita ini rut te menge etew ne edtuganur ketà te menge bavuy ne mibpemelelahuy ran en su impemenudtul dan ini diyà te inged dan wey ke nekeerivey ne pengengewiran. ");
INSERT INTO mbi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nerineg ini rut te menge etew, ne mibayaan dan en su midsusi ran. Nekeuma ran ketà te ki Hisus ne nekita ran en ke meama ne midsuukan te merakel ne vusew pehaney ne riyà mibpinuu te rengdengaan ni Hisus, ne mibevelegkas en ne nekeulit en ke itungan din. Ketà ne nengeandek dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ne ini se menge etew ne nekekita rut te mid-ulaula ni Hisus ne impenudtul dan en dut te ruma pà ne etew ke ned-ulaula rut te meama ne midsuukan te menge vusew. ");
INSERT INTO mbi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ne langun ne mehinged ketà te Gerisiyanu ne mibpemuyù ki Hisus te menu med-awà sikandin su neandek dan nevenar. Arà dà ne midlived en si Hisus diyà te avang din su ed-awà en. ");
INSERT INTO mbi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ne mibuyù ini se meama ne neulian en diyà te ki Hisus te, “Egkiyug a ne ebpekiduma kenikew.” Ugaid ne warà imperuma ni Hisus su impeulì din se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ulì ke en diyà te keniyu ne ipenudtul nu ini se meupiya ne mid-ulaula te Eleteala kenikew.” Arà dà ne mid-ulì en ini se meama ne mibpemenudtul en diyà te langun ne mehinged ini se meupiya ne mid-ulaula ni Hisus kandin. ");
INSERT INTO mbi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nekeampil be maa si Hisus kayi te mibpuunan din ne migalewhalew kandin ke merakel ne menge etew ne nevurun ketà su daan dan en ne edtahad kandin. ");
INSERT INTO mbi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Duen ketà meama ne ed-ingaranan ki Jairo, senge etew ne egkeunutan diyà te valey ne ebpengedian te menge Hudiyanen te penduan dan. Mid-uvey sikandin ki Hisus ne midlumpeng diyà te etuvangan din se ebpemuyù ki Hisus te ebperuma riyà te valey rin. ");
INSERT INTO mbi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Su ruen budtung ne anak din ne sepulù buwa wey deruwa se rahun din ne edaru ne edtiviltivil te kepatey. Miduma si Hisus kandin ne gewii ran te ed-ipanew ne egkeasek kayi te ki Hisus ke merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ne ruen ketà meritan ne nerasey nevenar su nekedsepulù en wey deruwa ne rahun se kebpemundasa rin te lengesa ne kenà egkeengked. Misan mibpevewian din en te merakel ne terevawì ne warà dan megaga. ");
INSERT INTO mbi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mibpenelektelek en sikandin diyà te uriyan ni Hisus ne mid-amì din dà ke belegkas ni Hisus ne netibpek en ke kebpemundasa rin. ");
INSERT INTO mbi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ne migkahi si Hisus te, “Engkey ma se mid-amì kediey?” Guna su mibparew ran langun ne migkahi si Pedro te, “Engkey se kegketueni nu, Meyterù, te merakel ne etew ne ebpekelipit kenikew?” ");
INSERT INTO mbi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ne migkahi si Hisus te, “Duen iya mid-amì kediey su neheram ku ke gehem ku te kebpemawì ne midlihawang kediey.” ");
INSERT INTO mbi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Guna su nerineg kayi te meritan ne mid-amì ki Hisus te netuenan din, ne inlayanglayang ma sikandin te kerker. Ne mid-uvey rin si Hisus ne midlumpeng en diyà te sineruwan din ne intarem din en ketà te merakel ne etew ke maan ke mid-amì sikandin ki Hisus wey arà dà ne neulian en ke daru rin. ");
INSERT INTO mbi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ketà ne migkahi si Hisus kandin te, “Bayi, neulian ke en su sabap dut te kinesarig nu kediey. Ulì ke en be ne barasbaras ka dut te keresayan nu.” ");
INSERT INTO mbi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ne gewii te ebpekidlalag pà si Hisus dut te meritan ne ruen en nekeuma ne ibpetundug ki Jairo, ne migkahi te, “Ke anak nu ne nekerudtanà en. Kenà ta en ebpengenen si Hisus.” ");
INSERT INTO mbi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Guna su nerineg ini ni Hisus ne migkehiyan din si Jairo te, “Kenà ka kelagew kayi te anak nu, ugaid ne sarig ke rà kediey ne egkeuyag ded sikandin.” ");
INSERT INTO mbi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Guna su nekeuma ran diyà te valey ni Jairo ne iyan din dà impelusud ne si Pedro, wey ke teleari si Santiago ki Juan, wey ke menge lukes dut te vatà. ");
INSERT INTO mbi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ne langun ne menge etew ketà te valey ne ebpeninehew wey ebpemenderawit dut te vatà. Ne migkahi si Hisus kandan te, “Kenà kew pè ma edsinehew. Warà minatey ayan se vatà su nekelipereng dà.” ");
INSERT INTO mbi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nerineg den dà ke migkahi ni Hisus ne mid-engitan den dà sikandin su netuenan dan te minatey en ke vatà. ");
INSERT INTO mbi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mid-uvey rin ke vatà ne migeweran din ke velad din ne migkahì te, “Payi, enew ke en.” ");
INSERT INTO mbi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Arà dà ne nekesunggud ke hinawa rin ne mid-enew en. Ne migkehiyan ni Hisus ke menge lukes din te pekeena ran ke anak dan. ");
INSERT INTO mbi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ne nengegeyip nevenar ke menge lukes dut te vatà, ugaid ne mibenduan dan ni Hisus te kenà ibpepenudtul ini se ned-ulaula te misan entei en. ");
INSERT INTO mbi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Miburun ni Hisus ke sepulù wey deruwa ne edumdumaan din ne mibeheyan din sikandan te gehem te ebpekeulì te menge daru wey ebpekesegseg dan te menge vusew ne ebpenuuk dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne impeipanew rin sikandan su ebpesabut te menge etew mekeatag te kedatù te Eleteala kandan wey apey ran mekevawì dema te misan engkey en ne daru. ");
INSERT INTO mbi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne intelaan din kandan te, “Kayi te ked-ipanew niyu ne kenà kew ed-ewit te misan engkey en, kenà kew ewit te tuked, kemuyut, lutù, kureta etawa belegkas te idsambì niyu. ");
INSERT INTO mbi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ne endei se valey ne ruen edtelimà keniyu ne ketà kew rà rateng taman te ked-awà niyu ketà te inged. ");
INSERT INTO mbi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ugaid ne embiya ruen menge etew ne warà edtelimà keniyu, ne levundus kew ne pendegdaha niyu ke lipupuk diyà te paa niyu gewii te ed-awà kew ketà te inged dan. Su tuus ini te baag kandan ne kenè en be kilid keniyu ketà te hewii ne kedtimbang te Eleteala kandan,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ne mid-ipanew en ke menge edumdumaan ne mid-eneb dan te menge inged se ebpesabut te Meupiya ne Tudtul mekeatag te Eleteala wey mibpemawì dan dema te menge etew diyà te langun ne menge inged. ");
INSERT INTO mbi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nekeeneb en ini se tudtul mekeatag te ed-ul-ulaan ni Hisus taman te nekeuma en diyà te ki Hirudis, ke egkeunutan dan diyà te Geliliya. Guna su nerineg ni Hirudis ne neliveg sikandin su ruen menge etew ne migkahi te nevanew red si Juan ke Ebpemunyag. ");
INSERT INTO mbi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ruen duma ne migkahi te si Elias ini ke mibpelambas te Lalag te Eleteala rengan ne neuyag ded. Duen ruma pà maa ne migkahi te sikandin ini ne senge etew rut te menge mibpelambas te Lalag te Eleteala rengan ne neuyag maa. ");
INSERT INTO mbi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ugaid ne iyan migkahi ni Hirudis te, “Embiya si Juan, ne impepungel ku en ke ulu rin. Ugaid ne engkey ve etawa ini se egkehiyen dan?” Ketà ne mibpemengà ni Hirudis se ralan te kegkekita rin ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Guna su mibpengulì ke sepulù wey deruwa ne edumdumaan ni Hisus ne mibpenudtul dan kandin ke langun ne mid-ulaula ran. Ne pineruma rin ke edumdumaan din te sikandan dà diyà te inged ne ed-ingaranan te Betsaida. ");
INSERT INTO mbi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nerineg kayi te merakel ne etew ne nevurun se mid-ipanew en si Hisus ne midtelukun dan. Nekeuma ran ne migalàhalà dan ni Hisus ne mibpesebutan din kandan mekeatag te kedatù te Eleteala kandan, wey mibpemawian din ke menge etew ketà ne ruen daru rin. ");
INSERT INTO mbi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Guna su meapun en nevenar ne mid-uvey en ki Hisus ke sepulù wey deruwa ne edumdumaan din se egkahi te, “Meapun en ini ne warà dè be menge etew kayi te inged ini. Iyan tumù ne ibpeipanew nu en ini se merakel ne etew su apey ran ebpekependiyà te endei se ruen menge valey rin ne ebpekekuwa ran te egkekaan wey egkeirehaan dan.” ");
INSERT INTO mbi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ugaid ne migkahi si Hisus te, “Sikiyu se ebpekaan kandan.” Ne migkahi ran te, “Ini se keytew ne lelima rà ne timan ne pan wey deruwa rà ne timan ne serà. Etawa ebpepemasaen key nu te ibpekaan kayi te denda ne etew?” ");
INSERT INTO mbi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Su ketà ne ruen menge lelima nengivu ne meama liyu pà ke meritan batà.) Ne migkahi si Hisus dut te sepulù wey deruwa ne edumdumaan din te, “Pemepinuuwa niyu sikandan te idsenge puntuk te igkarang se menge lelima nepulù.” ");
INSERT INTO mbi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne ketà ne impepinuu ran en ke langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne migkuwa ni Hisus ke lelima ne timan ne pan wey ke deruwa ne timan ne serà ne midlingakà sikandin diyà te langit ne impeselamat din te Eleteala. Ne mibpenevìtevì din ne imbehey rin en dut te menge edumdumaan din su ibpetukid dut te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Migkaan dan langun ne nengevulung dan. Guna su nekeipus dan se egkaan ne mibpunpun dut te sepulù wey deruwa ne edumdumaan din ke nengesamà, ne iyan din nepunpunan ne sepulù wey deruwa ne binevey se nengepenù. ");
INSERT INTO mbi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Senge hewii maa ne mibpengeningeni si Hisus te sebseveka rin ne riyà te uvey rin ke menge edumdumaan din. Ne mid-insaan din sikandan te, “Engkey a kun ma riyà te pegitungan te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne midtavak dan te, “Ruen egkahi te sikuna si Juan ke Ebpemunyag, ne ruen duma ne egkahi te sikuna si Elias ke mibpelambas te Lalag te Eleteala rengan, ne ruen pà ruma ne egkahi te sikuna ke seveka ne mibpelambas te Lalag te Eleteala rengan ne nevanew maa.” ");
INSERT INTO mbi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ne menu sikiyu?” ke si Hisus. “Engkey e ma diyà te pegitungan niyu?” Ne midtavak si Pedro te, “Sikuna si Kristu ke midtendù te Eleteala ne ebperetuen dut te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ne migkehiyan ni Hisus tegtehami sikandan te kenà dan ibpenudtul ini te misan entei ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne migkahi maa si Hisus dut te menge edumdumaan din te, “Ke Impeanak te Menusiyà ne edresayen nevenar. Su ebpeheweran din dut te menge egkeunutan te Hudiyanen, ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan. Ed-imetayan sikandin ugaid ne ketà te iketelu ne hewii ne egkevanew red.” ");
INSERT INTO mbi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne migkahi pà maa si Hisus kandan langun te, “Embiya ruen etew ne egkiyug ne eduma kediey ne iyan iya se pekelipati rin ke kandin ne kiyug, ne tianga rin ke kandin ne pinebelavag ne kayu ne ed-ingaranan te krus ne iyan din meana ne tumana rin ke menge suhù ku misan ibpatey rin pà se keduma rin kediey. ");
INSERT INTO mbi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Su ke etew ne egkenuhun te umur din ne ebpatey lavew, ugaid ke etew ne iyan din ibpatey se keduma rin kediey te kebpemesabut dut te Meupiya ne Tudtul, ne ruen umur ne ibehey kandin ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Su misan duen etew ne ebpekeangkun te langun kayi te ampew te dunya, ne warà lalew rin embiya egkerasey ke himukud din diyà te apuy ne rakà. ");
INSERT INTO mbi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Embiya ruen etew ne igkeyeyai a rin wey ini se ibpenurù ku kayi te ini ne timpu ne merakel ne menge etew ne mekesesalà wey edsumpalit te Eleteala, ne igkeyeyai rema sikandin dut te Impeanak te Menusiyà ketà te kedlived din kayi te ampew te dunya. Su ketà ne hewii ne ruen raman din ne riyà ebpuun te Amey rin ne Eleteala, ne edumaan din dema rut te menge berekat ne suluhuen diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tentenuri niyu ini, ruen ruma tew kayi ne kenà pà ebpatey taman ketà te hewii ne egkekita ran ke Kedetui te Eleteala rut te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Guna su nekedsenge pedian en igenat te kinekahi ni Hisus ketà, ne pineruma rin en ensi Pedro, si Juan, wey si Santiago te edtekereg diyà te buvungan su ebpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gewii ni Hisus te ebpengeningeni ne nesalin ke paras dut te buked din. Ne mibpeneringsing ke velegkas din te keputì su warà misan engkey ne kayi te dunya ne ebpekemeputì iring kayi. ");
INSERT INTO mbi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Netekew ran en dema nekita se deruwa ne etew ne ebpekidlalag ki Hisus, si Moises wey si Elias, ke menge mibpelambas te Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ne mibpengandlag ke kesihey ran dema ne iyan dan edlelahen ki Hisus ne mehaan din en edtumana ke suhù kandin te Eleteala te ebpebpatey diyà te inged ne Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ugaid ne si Pedro wey ke menge ruma rin ne nekelipereng dan, ne guna su nekehimerat dan en ne nekita ran ke kesihey ni Hisus wey ke deruwa ne etew ne uvey rin. ");
INSERT INTO mbi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ne gewii te ed-awà ke deruwa ne etew riyà te ki Hisus ne migkahi si Pedro te, “Meyterù, meupiya su kayi ki! Edsesabung key te tetelu, seveka keykew, seveka ki Moises, wey seveka rema ki Elias.” (Ugaid ne matag be migkahi si Pedro te iring ketà ne warà din metueni ke engkey se egkehiyen din.) ");
INSERT INTO mbi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ketà te edlalag pà si Pedro ne ruen sehulapun ne nekelikuvung kandan ne neandek dan te nesukub dan en te sehulapun. ");
INSERT INTO mbi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne ruen suwara ne ketà ebpuun te sehulapun ne migkahi te, “Ini ke Anak ku ne mibpemilì ku. Pemineha niyu ke edlelahen din.” ");
INSERT INTO mbi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Neipus ke suwara ne iyan den dà nekita ne si Hisus. Ketà te arà ne hewii te kebpekeruma pà ni Hisus kandan ne warà dan kegkehiya ini se nekita ran te misan senge etew rà. ");
INSERT INTO mbi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ne midtundug ketà ne hewii ne midtupang dan ketà te buvungan ne merakel se menge etew ne mid-alew ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Duen senge etew ne meama ketà te menge etew ne nevurun ne midtawag ki Hisus se egkahi te, “Meyterù, menu ke intengi nu pà ini se anak ku ne meama su budtung dà ini. ");
INSERT INTO mbi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ne ruen busew ne edsuuk kandin ne embiya egkeumaan sikandin ne edtekew ne egkuleyì ne egkehurivid ke lawa rin taman te eburvuraen ke bèbà din. Merasirasi edsuuk ke vusew kandin ne egkekeiran en sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne mibpemuyù ku rut te edumdumaan nu te ibpesegseg ini se vusew, ugaid ne warà dan ma megaga.” ");
INSERT INTO mbi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Migkahi si Hisus te, “Sikiyu ne menge etew guntaan, warà kebperetiyaya niyu te Eleteala wey menge suer kew!” ke sikandin. “Neuhet en se kebpekiduma ku keniyu, ne engkey pà taman se kebperetiyaya niyu? Wey engkey pà taman se keuhet din se kedtigkeri ku keniyu?” Ne migkahi si Hisus dut te amey te vatà te, “Ipengkayi nu ke anak nu.” ");
INSERT INTO mbi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ne gewii te ed-ewiten dan ke batà kayi te ki Hisus ne midsuuk en maa ke vusew kandin ne nepiley sikandin ne nehurivid en ke lawa rin. Ugaid ne midsegseg ni Hisus ke vusew, ne neulian din ke vatà, ne in-ulì din diyà te amey rin. ");
INSERT INTO mbi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ne negeyip ke langun ne menge etew ketà dut te mid-ulaula ni Hisus su nekita ran ke gehem te Eleteala. Kemuluwan pà ne egkegeyip ke langun ne menge etew rut te mid-ulaula ni Hisus ne migkahi si Hisus diyà te edumdumaan din te, ");
INSERT INTO mbi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Itaan niyu ke telinga niyu kayi te ini se egkehiyen ku keniyu, ebpuliren ke Impeanak te Menusiyà dut te menge kunterà din.” ");
INSERT INTO mbi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ugaid ne warà dan mesebuti ke meana rut te migkahi ni Hisus kandan, ne neandek dan te ed-insà. ");
INSERT INTO mbi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ne mibpelewlewaney ke menge edumdumaan ni Hisus ke engkey kandan se mepurù. ");
INSERT INTO mbi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ugaid ne netuenan ni Hisus ke menge pegitungan dan, ne ketà ne migkuwa rin se vatà ne impeitindeg din diyà te uvey rin. ");
INSERT INTO mbi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne migkahi en te, “Misan engkey ne etew se edtelimà te vatà iring kayi su atag te keduma rin kediey, ne midtelimà dema sikandin kediey. Ne misan engkey ne etew ne edtelimà kediey, ne kenà siak dà se midtelimà din su misan ke Amey ku ne Eleteala ne midsuhù kediey ne midtelimà din dema. Su misan engkey en keniyu se kevevaan su sabap te egkesuhùsuhù te menge ruma rin, ne sikandin ke tidtu ne mepurù keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ne migkahi si Juan ki Hisus te, “Meyterù, duen etew ne neuma rey ne ebpenegseg te vusew te ibpepevayà dut te gehem te ngaran nu, ne midawey rey sikandin su kenà tew ma ruma.” ");
INSERT INTO mbi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ugaid ne migkahi si Hisus kandin te, “Kenà niyu sikandin edewaya su warà etew ne ebpekevaal te mekegeyip te ibpepevayà te ngaran ku ne melemu ne edlalag te mereatey mekeatag kediey. Su ke etew ne kenà ebpekidkunterà keytew ne ruma tew.” ");
INSERT INTO mbi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Guna su egkereniyan en ke hewii te kebpekeawà ni Hisus kayi te ampew te dunya su ed-ulì en diyà te langit ne mibpedtihel din ke hinawa rin te ebpendiyà te inged ne Hirusalim ne ketà ne migenat dan en. ");
INSERT INTO mbi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Duen menge etew ne pineuna rin su ebpemengà te egkeretengan dan ne migenat dan en. Mibpendiyà dan te seveka ne inged lusud te Semeriya su ebpenehana te kebpekeuma en ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ugaid ne ke mehinged ketà ne warà midtelimà ki Hisus su netuenan dan se riyà edsinaru sikandin te inged ne Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Guna su nekita ini rut te edumdumaan ne si Santiago wey si Juan se warà bes edtelimà kandan ne migkehiyan dan si Hisus te, “Menu, egkiyug ka, Meyterù, ne ebuyù key te apuy riyà te langit ne ibpetanà kandan su apey langun dan ne egkeherà?” ");
INSERT INTO mbi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ugaid ne midlilingey si Hisus kandan ne midawey rin, ");
INSERT INTO mbi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ne midlevundus dan en diyà te ruma ne inged. ");
INSERT INTO mbi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gewii ran te ed-ipanew ne ruen etew ne migkahi ki Hisus te, “Eduma a kenikew misan ebpependei ka.” ");
INSERT INTO mbi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ne migkahi si Hisus kandin te, “Ke menge laku ne ruen takub ne ed-ul-ulian dan, ke menge pepenuk ne ruen kandan ne salag, ugaid ne ke Impeanak te Menusiyà ne misan endei ad memekeirehà su warà ubpaan din.” ");
INSERT INTO mbi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne migkahi maa si Hisus diyà te senge etew te, “Duma ka kediey.” Ugaid ne migkahi ini se meama te, “Ed-ulì e pà ne embiya egkepupusan en te ebpeneytayen ke amey ku ne arà pà ne eduma a kenikew, su siaken ded se edleveng kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ne migkahi si Hisus te, “Iyan nu pelevenga rut te minatey ke menge ruma nu ne kenà ebperetiyaya kediey, ugaid ne iyan ku ibpehelevek kenikew ne ebpesabut dut te Meupiya ne Tudtul mekeatag te Kedatù te Eleteala te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne ruen pà maa senge etew ne migkahi te, “Mama, eduma a kenikew, ugaid ne ebpemehetew e pà diyà te bevelayan ku.” ");
INSERT INTO mbi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne migkahi si Hisus te, “Embiya ruen etew ne edadu ne ebpulung edlilingey, ne kenà meupiya arà. Ne iring din ded dema,” ke si Hisus, “ke etew ne eduma kediey, embiya ebpulung edlilingey dut te netehak din ne kenà sikandin edait ne egelevek dut te menge etew ne edetuan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Guna su neipus arà ne ruen pitu nepulù ne ruma pà ne menge meama ne mibpemilì te Kerenan ne impeipanew rin ini te igeheruwa riyà te langun ne menge inged ne mehaan din ebayai. ");
INSERT INTO mbi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne migkehiyan din sikandan te, “Medmarkel se menge etew ne warà pà meketelimà dut te Meupiya ne Tudtul mekeatag te Eleteala. Iring sikandan te melutuen ne pareyanan. Meluag nevenar ini se pareyanan, ugaid ne warà utew ruma rut te ebpengehani. Pemuyù kew riyà te Eleteala ke kemuney rut te pareyanan te medsuhù pà sikandin te ruma ne ed-ehani diyà te pareyanan din. ");
INSERT INTO mbi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, genat kew en, ugaid uram kew su edsuhuen ku sikiyu riyà te menge etew ne ebpekekaid, ne iring kew te nati te bilibili ne ebpekeseruk diyà te senge ingeren en ne mewalew ne asu. ");
INSERT INTO mbi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kenà kew ewit te kureta, kempiru, etawa telumpà ne idsambì. Ne kenà kew edlanganlangan te ebpekibpengasak dut te langun ne menge etew ne egkeuma niyu riyà te ralan. ");
INSERT INTO mbi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ne piya engkey ki baley se egkepemenayikan niyu ne penehetiat kew se egkahi te, ‘Menu ma ebpeneuven te Eleteala ke langun ne ed-ubpà kayi te valey ini!’ ");
INSERT INTO mbi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Embiya ruen ketà te valey ebperetiyaya wey egalàhalà keniyu ne dekelà se penaub te Eleteala kandan. Ugaid ne embiya kenà kew ran egelhelaan ne kenà edlaus kandan ke kebpenaub te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ubpà kew ketà te valey ne ruen migalàhalà keniyu taman te egkeuma ke ked-awà niyu ketà te inged dan. Kenà kew ed-arat-arat te ked-ubpà niyu. Ne telimaa niyu misan engkey se idsaru ran wey ibpeinum dan keniyu su mehelalew ran en keniyu. Su ke etew ne egelevek ne dait ne edsukayan. ");
INSERT INTO mbi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Piya endei ne inged se egkeumaan niyu ne ruen egalàhalà keniyu, ne telimaa niyu misan engkey se idsaru ran keniyu. ");
INSERT INTO mbi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pemawii niyu ke menge ebpenderaru ketà te inged. Ne kehiya niyu rut te menge etew ketà te inged te mehaan en ke hewii te Kedatù te Eleteala kandan. ");
INSERT INTO mbi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ugaid ne embiya ebpekeuma kew riyà te inged ne warà egalàhalà keniyu, ne pendiyà kew te ralan ne kahi kew riyà te menge etew te, ");
INSERT INTO mbi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mibpemunas dey en ini se lipupuk te inged niyu ne mideket te paa rey su tuus ini te kenà en kilid kenami ketà te hewii ne kedtimbang te Eleteala keniyu. Ugaid ne iyan niyu tentenuri ne mehaan en ke gewii te Kedatù te Eleteala dut te menge etew.’ ");
INSERT INTO mbi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ugaid ne idtarem ku keniyu,” ke si Hisus, “muna pà ke kedusai te Eleteala kandan ketà te hewii ne kedtimbang din te menusiyà dut te kinerusa rin te menge mehinged riyà te Sudum.” ");
INSERT INTO mbi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ne migkahi maa si Hisus te, “Sikiyu ne menge etew riyà te inged ne Kurasin, mekeandek-andek se egketemanan niyu! Ne sikiyu te inged ne Bitsaida, mekeandek-andek dema se egketemanan niyu! Su embiya ke menge etew rà diyà te menge inged ne Tiru wey Sudum se nekekita kayi te mekegeyip ne mid-ulaula ku riyà te keniyu ne neuhet dà ne mid-ewaan dan en ke meraat ne ulaula ran ne mibevelegkas dan en te sakù ne mid-evuwan dan ke ulu ran su tuus te nekedsendit dan. ");
INSERT INTO mbi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ketà te hewii ne kedtimbang te Eleteala te menusiyà ne iyan pà dekelà ke kedusa te Eleteala keniyu rut te mehinged te Tiru wey Sidun. ");
INSERT INTO mbi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne sikiyu rema ne menge etew diyà te inged ne Kapirnawum,” ke si Hisus, “egkesuat kew perem ne ebpekesugkur diyà te langit, ugaid ne ibpetimbag kew riyà te apuy ne rakà.” ");
INSERT INTO mbi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne migkehiyan ni Hisus ke pitu nepulù ne ebpeipenawen din te, “Ke menge etew ne ebpemineg te ibpenurù niyu ne iring te iyan a ran ebpeminehen. Ne engkey se kenà edtelimà keniyu ne iring te iyan a rin warà telimaa. Ne engkey se kenà edtelimà kediey ne iyan din warà telimaa ke Eleteala ne midsuhù kediey.” ");
INSERT INTO mbi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Guna su mid-ulì ke pitu nepulù wey deruwa ne midsuhù ni Hisus, ne nengesuatsuat dan nevenar! Migkahi ran diyà te ki Hisus te, “Kerenan, misan ke vusew ne mibperumaruma te lalag dey ke ibpeawà dey te ibpepevayà te ngaran nu.” ");
INSERT INTO mbi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne migkahi si Hisus kandan te, “Nekita ku si Setanas ke datù te pekaid ne neulug diyà ebpuun te langit ne iring te kilat se kegkeulug din. ");
INSERT INTO mbi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tentenuri niyu te mibehayan ku en sikiyu te gehem su apey misan ebpekehiek kew te uled etawa awa ne kenà kew egkevisaan. Kenà kew egketalew rut te kevaher te datù te pekaid, ne warè en ebpekekaid keniyu. ");
INSERT INTO mbi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ugaid ne kenà iyan niyu igkehalew se ebperumaruma ke vusew keniyu,” ke se Hisus, “ugaid ne iyan niyu ikehalew ne impesurat en te Eleteala ke menge ngaran niyu riyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ketà ne hewii ne mibpehalew si Hisus dut te kedlumun te Kedesenan ne Ebpetuntul te menusiyà ne mideyù din ke Eleteala se egkahi te, “Ew Amà, sikuna ke Kerenan diyà te langit wey kayi rema te ampew te dunya. Dekelà se kebpeselamat ku kenikew su impayag nu ke ketau nu rut te menge etew ne warà egketùtuenan dan, ne in-eles nu ini se ketau nu rut te menge etew ne dekelà se netuenan dan. Uya, dekelà se kedeyù ku keykew, Amà, te ini se mid-ulaula nu su ini ke kiyug nu.” ");
INSERT INTO mbi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ne migkahi maa si Hisus dut te menge etew te, “Ke Amey ku se mibpesarig kediey te langun taman. Warà netau kedì te Anak a te Eleteala liyu rà te Amey ku ne Eleteala. Ne warà netau te Amey ku ne Eleteala liyu rà te siaken ne Anak din wey ke menge etew ne egkiyuhan ku te ebpayag mekeatag dut te Amey ku.” ");
INSERT INTO mbi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne midsinaru si Hisus dut te menge edumdumaan din te sikandan dà se midlelehan din te, “Dayirayi kew su nekita niyu ini se ibpehelevek te Eleteala kedì. ");
INSERT INTO mbi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Su benar ini se egkehiyen ku keniyu te kenà pira rà se ebpelambas te Lalag te Eleteala wey ke menge mepurù dengan ne egkesuat perem ne ed-inteng kayi te nengekita niyu te gunteani en, ugaid ne warà dan en mekita. Ne egkesuat dan perem ne ebpemineg kayi te nengerineg niyu te gunteani en, ugaid ne warà dan en mekerineg.” ");
INSERT INTO mbi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ne senge hewii maa ne ruen senge etew ne meyterù te penduan se mibpengkayi te ki Hisus su edseligkat perem te menge insà din. Ke sikandin te, “Meyterù, engkey se ed-ul-ulaan ku su apey a mevehayi te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ne migkahi si Hisus te, “Engkey se impesurat ne penduan te Eleteala ne intelaan ni Moises? Engkey se egkesebutan nu rut te kebasa nu ketà?” ");
INSERT INTO mbi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne migkahi ke meama te, “ ‘Iamin nu ke hinawa nu te edlimù te Kerenan ne Eleteala nu, ne iamin nu ke baher nu wey itungan nu te ed-ulaula ke engkey se ebpekesuhat te hinawa rin’ wey ‘Ikelimù nu ke ruma nu iring te kegkelimù nu te hinawa nu.’” ");
INSERT INTO mbi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ne migkahi si Hisus te, “Benar ini se migkahi nu. Ul-ulaa nu ve ini ne egkevehayan ka te umur ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ugaid ne kenà egkiyug ini se meyterù te penduan ne egkepilayan te pengasak ne ketà ne mid-insà en maa te, “Engkey se ruma ku?” ");
INSERT INTO mbi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne midtavak si Hisus te impepevayà te sempità, ke sikandin te, “Duen senge etew ne Hudiyanen ne riyà ebpuun te Hirusalim ne ebpetupang kayi te inged ne Hiriku. Kayi te ralan ne ruen neuma rin ne menge tulisan ne midruug kandin ne pinegkedew ran sikandin ne wey ran ewai ne igelimbeka rè be se hinawa rin. ");
INSERT INTO mbi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Guna su mid-ewaan en dut te menge tulisan ne ruen senge etew ne Hudiyanen ne terebpelengesa te Eleteala ne mibpevayà ketà te ralan. Ugaid ne nekita rin dà ini se etew ne nekeid-irehà dutun te ralan, ne mid-elihu rin ne midlevundus en se ed-ipanew. ");
INSERT INTO mbi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ne engketà ded maa se senge etew ne mibpevayà ketà te ralan ne Hudiyanen ded dema, ne kevuwaran ni Levi ne iyan din helevek ne ed-amung dut te menge terebpelengesa diyà te Nekebpuru ne Valey te Eleteala. Nekeuma ne nekita rin ded dema ini se etew ne nekeid-irehà dutun te ralan, ne mid-elihu rin ded dema ne midlevundus en se ed-ipanew. ");
INSERT INTO mbi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Warà dà meuhet ne ruen en maa senge etew ne nekeuma ne mibpevayà ketà te ralan ne kenà Hudiyanen su mehinged te Semeriya. Nekita rin dà ini se meama ne nekeid-irehà ketà te ralan ne midaat se nanam din. ");
INSERT INTO mbi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mid-uvey rin en ne mibawian din ke menge palì te lana wey vinu ne mibagkes din. Nepasad din te ebawì ne midsepuwat din diyà te kudà din ne mibpeneheewit din diyà te valey ne ed-eranan ne rutun din maa tugenura. ");
INSERT INTO mbi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nepawà ne mibehey sikandin te kureta rut te kemuney te valey se egkahi te, ‘Tugenura nu pè be kedì ini se meama. Embiya ruen pà igkegastu nu kandin ne id-ulì ku rà kenikew ketà te kedlived ku.’” ");
INSERT INTO mbi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne migkahi si Hisus ketà te meyterù te penduan te, “Endei rapit kayi te tetelu ne meama se meupiya ne ruma ketà te meama ne midruug te tulisan?” ");
INSERT INTO mbi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne migkahi ke meyterù te, “Arà se neyru kandin se meupiya ne ruma rin.” Ne migkahi si Hisus te, “Ini ve se iringi nu.” ");
INSERT INTO mbi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Gewii te edlevundus en ensi Hisus te ked-ipanew ran ne nekeuma ran ketà te senge inged. Ne ruen ketà meritan ne ed-ingaranan ki Marta ne mibpepemenayik kandan diyà te baley rin. ");
INSERT INTO mbi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Duen ari rin ne ed-ingaranan ki Maria. Ne mibpinpinuu si Maria ini riyà te uvey ni Hisus su ebpemineg te penurù din. ");
INSERT INTO mbi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne si Marta ne warà kebpinuu rin su sikandin dè be se ed-elugan te kegkaan dan. Ne ketà ne mid-uvey rin si Hisus se egkahi te, “Menu warà nu metuusi, Mama, te ebpedterayen e rà keniyan te ari ku se egelevek kayi te avu? Kehiyi nu pà si Maria te ebpeemungen kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ugaid ne migkahi si Hisus te, “Sikuna, Marta, merakel utew se igkeuru nu ne kenà beripantag. ");
INSERT INTO mbi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ugaid ne seveka rà se beripantag. Ne iyan nepemilì ni Maria ini se meupiya ne kenà egkeawà kayi te kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Senge hewii ne mibpengeningeni si Hisus ketà te andang ne ebpengeningeniyan din. Nekeipus sikandin se ebpengeningeni ne migkahi ini se senge etew ne edumdumaan din te, “Mama, penurua key te ebpengeningeni iring ki Juan te mibpenurù din ke menge edumdumaan din.” ");
INSERT INTO mbi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ne migkahi si Hisus kandan te, “Kayi te kebpengeningeni niyu ne iringa niyu kayi, ‘Ah, Amà, berekat ne edati te menusiyà ke ngaran nu. Ne berekat ne edatù ka rut te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Behayi key te sesangen ne egkekaan dey te uman andew. ");
INSERT INTO mbi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne pesehara nu ke salà dey, su ebpesaharen dey rema ke langun ne nekedsalà kenami. Ne ipekeriyù key nikuna dut te menge mevaher ne penggeram.’” ");
INSERT INTO mbi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne migkahi maa si Hisus dut te edumdumaan din te, “Upama ke ruen senge etew keniyu se ebpendiyà te sepakat din te metaneb ne kerukileman se egkahi te, ‘E, Mama, pesembaya e pà nikuna te egkekaan, ");
INSERT INTO mbi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","su ruen meheliyug ku ne riyà ebpuun te meriyù ne mid-aran kayi te kenami ne warà idsaru ku kandin.’ ");
INSERT INTO mbi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ne ketà ne edtavak sikandin diyà te lusud te valey te, ‘Ebpekelipereng ad mulà ini. Mibpintuan ku en ini se gumawan ku wey nekelipereng en ini se menge anak ku kayi te ulid ku. Kenà ad ebpekeenew te ebehey keykew.’ ");
INSERT INTO mbi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Idtarem ku keniyu,” ke si Hisus, “te misan sepakat ka rin ne kenà ed-enew sikandin se ebehey keykew. Ugaid ne embiya kenà ka ed-engked se ebuyù, ne ebpekeenew red sikandin se ebehey keykew te ebuyuen nu. ");
INSERT INTO mbi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Tembù be,” ke si Hisus, “ibpesabut ku ini keniyu, pemuyù kew riyà te Eleteala ne ebehayan kew rin. Pemengà kew ne ruen arà egketuen niyu. Penehetiat kew ne ebpuwasan kew rin. ");
INSERT INTO mbi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Su langun ne ebpembuyù diyà te Eleteala ne ebehayan, ne sika ebpemengà ne ebpeketuen, ne sika ebpenehetiat ne ebpuwasan te Eleteala kandin. ");
INSERT INTO mbi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Menu sikiyu ne menge lukes,” ke si Hisus, “embiya ebuyuan ka te anak nu te serà, maa uled se ibehey nu? ");
INSERT INTO mbi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Etawa ebuyuan ka rin te etelug, maa awa se ibehey nu? ");
INSERT INTO mbi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sikiyu ne menusiyà ne kenà metidtu ne metau kew ne ebehey te meupiya riyà te anak niyu, na iyan pè be ke Amey niyu ne Eleteala riyà te langit kenà mebehey keykew te kedlumun dut te Kedesenan ne Ebpetuntul te Menusiyà embiya ebpembuyù kew riyà te kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ruen hewii ne midsegseg ni Hisus ke vusew ne mibpemekaid te etew te kegkeemew rin. Guna su neawà en ke vusew ne arà dà ne nekelalag en ke meama, ne negeyip nevenar ke menge etew ne nevurun ketà. ");
INSERT INTO mbi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ugaid ne ruen migkahi te, “Si Belsibul, ke unuten te menge vusew se mibehey kandin te gehem te kebpenegseg te menge vusew.” ");
INSERT INTO mbi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne ruen pà ruma ne ebpenggeram ki Hisus ne mibuyuan dan si Hisus te mebpekita kandan te mekegeyip su apey ran egketueni ke riyà ebpuun si Hisus te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ugaid ne netuenan ni Hisus ke netahù te itungan dan ne migkahi en te, “Upama ke ruen datù te inged ne ed-uney ebpevuneey ke menge sakup din, ne egketunggad arà se inged din. Ne iring din ded dema ke ruen telteleanak ne ed-uney egkewaha, ne warà ebpengkusan din ke kenà egkevurahey. ");
INSERT INTO mbi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iring din ded be ketà ke midetuan ni Setanas ke unuten te menge vusew, embiya ed-uney ebpevunuey ke sakup din ne kenà meuhet se kedatù din su egketunggad arà se edetuan din. Migkahi niyu te iyan ku kebpenegseg te vusew ne mibehayan a ni Belsibul ke unuten te menge vusew te gehem din. ");
INSERT INTO mbi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Embiya benar ne iyan ku ibpenegseg te vusew ke gehem ni Belisbul, ne endei ve ebpuun ke gehem dut te edumaruma keniyu te ebpenegseg te vusew? Sikandan be ayan se ebpekekahi te warà mekesuhat ke egkehiyen niyu. ");
INSERT INTO mbi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ugaid ne iyan benar ne riyà ebpuun te Eleteala ini se gehem ku te ebpenegseg te vusew. Ne kayi ve ne egketuenan niyu te neuma en ke hewii te Kedatù te Eleteala keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Migkahi si Hisus te, “Upama ke ruen mevaher ne etew ne ruen metarem din ne ebentayan en ke valey rin, ne warà etew ne ebpekelusud te valey rin su ebpenakew te kearen din. ");
INSERT INTO mbi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ugaid ne embiya ruen mevaher pà ne etew ne edsulung ne ebpeketalew kandin wey egkeahew en ke metarem ne edserihan dut te etew ketà te valey, ne langun dut te netavan din ne egkepengumun-umun din en dut te menge ruma rin.” ");
INSERT INTO mbi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ne migkahi maa si Hisus te, “Ke etew ne kenà ku ruma ne kunterà ku, ne ke etew ne kenà ed-amung kediey te eburun kayi te menge etew ne ebpemburahey.” ");
INSERT INTO mbi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne migkahi pà maa si Hisus te, “Embiya ruen busew ne edsuuk te etew ne ed-awà en, ne riyà ebpevayà te memara ne tanà su ebpemengà te ubpaan din. Ne embiya warà egketuen din ne iyan egketahù te hinawa rin se, ‘Edliveran ku red ke mid-ubpaan ku.’ ");
INSERT INTO mbi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nekeuma ini se vusew, ne nekita rin te metilak en wey nekeulit en ke langun ketà te lusud. ");
INSERT INTO mbi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ne midlihawang pà sikandin ne med-ewit te pitu ne vusew ne tuwas pà kandin keraat, ne langun dan ne ketà dà mid-ubpà. Ne ini se egketemanan ketà te etew ne muna pà se kepasang din dut te neuna.” ");
INSERT INTO mbi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nekeipus si Hisus se edlalag kayi, ne ruen meritan ketà te nevurun ne merahing se kinekahi rin te, “Dekelà se kehelawan dut te meritan ne mid-anak wey mibpesusu keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ugaid ne iyan migkahi ni Hisus se, “Iyan pè be dekelà se kehelawan dut te etew ne ebpemineg te Lalag te Eleteala wey ebperumdumaan din.” ");
INSERT INTO mbi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gewii te egkeasek en ke merakel ne etew riyà te ki Hisus ne migkehiyan din sikandan te, “Sikiyu ne menge etew te guntaani en, mereatey nevenar se menge ulaula niyu ne warà kebperetiyaya niyu te Eleteala! Iyan niyù ebpemengaan se mekegeyip ne tuus te gehem ku. Ugaid ne warà en ma tuus ne ibpekita keniyu liyu rà ketà te netemanan ni Jonas ne mibpelambas te Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Su iring te nekeuma si Jonas diyà te inged ne Ninivi rengan ne impekita rin dut te menge etew ketà ke tuus te kedusa te Eleteala, ne iring din ded dema te sikandin ne Impeanak te Menusiyà ke tuus kayi te keniyu ne menge etew te guntaani en. ");
INSERT INTO mbi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ketà te akir din ne hewii te kedtimbang te Eleteala te menusiyà,” ke si Hisus, “duen Bai rengan ne riyà ebpuun te inged ne Siba ne ed-itindeg ne ed-isuhat te kewagib dut te sikiyu ne menge etew guntaan. Su mibpengkayi sikandin se riyà ebpuun te divaluy te pehiliran su apey mekerineg dà ki Salomon ke Ratù dengan ne metmetau. Ne ruen en guntaan seveka ne mepurù pà ki Salomon ne ini en te keniyu, ugaid ne kenà niyu edtelimaan ke penurù din. ");
INSERT INTO mbi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Uya, ketà te akir din ne hewii ne kedtimbang te Eleteala te menusiyà,” ke si Hisus, “ne ed-itindeg ini se menge etew ne riyà ebpuun te Niniva rengan su ed-isuhat keniyu te kewagib. Su sikandan mulà ne nerineg dan dà ke Lalag te Eleteala ne impesabut ni Jonas kandan ne nekedsendit dan ne mid-ewaan dan en ke meraat ne mid-ulaula ran. Ne guntaan ne ruen mepurù pà ki Jonas ne kayi te keniyu, ugaid ne kenà niyu edtelimaan ke penurù din ne kenà kew ebpedsendit te meraat ne ulaula niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne migkahi maa si Hisus te sempità kandan te, “Warà etew ne edtemtem te sulù ne ebpelengkevan din etawa ibperalung din. Ugaid ne riyà din ibpeluukluuk te saag su apey egkerayahan ke langun. ");
INSERT INTO mbi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ke mata te etew ne iring te sulù dut te lawa rin su embiya merayag se kedtengteng din ne iyan din meana ne metidtu se ulaula rin, ne iring te egkerayahan ke langun ne lawa rin. Ugaid ne embiya edsehulepunen se kedtengteng din ne iyan din meana ne mereatey se ulaula rin, ne iring te egkerusireman ke langun ne lawa rin. ");
INSERT INTO mbi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tembù be uram kew ke ini se egkehiyen nu ne kerayag te lawa nu ne kerusirem bes. ");
INSERT INTO mbi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Su embiya egkerayahan ke langun ne lawa nu ne warà misan deisek dà ne kerusireman, ne medmerayag nevenar ke lawa nu iring te egketeyawan ka te sulù.” ");
INSERT INTO mbi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nekeipus en si Hisus se edlalag ne ruen senge etew ne Peresiyu ne mid-inggat kandin te egkaan diyà te valey rin. Ne miduma en rema si Hisus ne mibpinuu en se egkaan. ");
INSERT INTO mbi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nekita dut te menge Peresiyu te warà midlùlù si Hisus te warà pà sikandin mekekaan ne neinuinu ran nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ne migkahi si Hisus kandan te, “Sikiyu ne menge Peresiyu, iring kew te menge basu wey pelatu ne migkulisungan su apey melinis kew kayi te egkekita, ugaid ne kayi te diralem niyu ne meredsik su nepenù te kegkeeram-am wey kereatey! ");
INSERT INTO mbi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Menge warà eperu niyu!” ke si Hisus. “Maa, warà niyu metueni te kenà iyan dà midlimbag te Eleteala ke egkekita kayi te lihewangan su misan ini se kayi te lusud ne kenà egkekita ne midlimbag din ded dema. ");
INSERT INTO mbi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ugaid ne umuni niyu ke menge ayuayu dut te intahù niyu te menge basu wey pelatu niyu ne ebmelinis kew te kenà kayi rà te lihewangan su kayi rema te lusud te hinawa niyu. ");
INSERT INTO mbi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Iyan kew rà mekeyruwiru ne menge Peresiyu!” ke si Hisus. “Su ebehey kew te Eleteala te kandin ne umun ne ikesepulù dut te pinemula niyu ne peninù iring te tandlad wey bawing, ugaid ne warà te hinawa niyu ke egkiyuhan te Eleteala ne ketidtu te ulaula niyu riyà te menge ruma niyu wey ke kedlimù niyu te Eleteala. Benar ne ebehey kew te Eleteala te kandin ne umun ugaid ne warà niyu ma iya tumana ke didis en dut te penurù te Penduan. ");
INSERT INTO mbi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Iyan kew rà mekeyruwiru ne menge Peresiyu!” ke si Hisus. “Su riyà te baley ne ebpengedian te penduan te Hudiyanen ne ebpemilì kew te ebpinuuwan te sineruwan, ne embiya riyà kew te pedian ne iyan niyu igkesuat ne ed-edatan kew. ");
INSERT INTO mbi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Iyan kew rà mekeyruwiru! Su iyan niyu egkeupamaan ne leveng ne warà kudal din ne egiekan te etew te warà dan metuusi ne ebpekereraat kandan su ebpekehuru ran dut te meraat ne ulaula niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Duen senge etew ketà ne meyterù te penduan ne migkahi ki Hisus te, “Meyterù, arà se lalag nu ne nesuhat key red dema.” ");
INSERT INTO mbi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne migkahi si Hisus kandin te, “Ne sikiyu rema ne menge meyterù te penduan, mekeyruwiru kew rema! Ebpekevehatan niyu ke menge etew te menge penduan ne kenà dan en egkegaga ne edtuman, ugaid ne sikiyu ne warà misan deisek dà ne idtavang niyu kandan te edtuman ketà. ");
INSERT INTO mbi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Iyan kew rà mekeyruwiru! Su mideyreyanan niyu ke menge leveng dut te mibpelambas te Lalag te Eleteala rengan, ugaid ne keniyu ma ne keep-epuan ke mid-imatey kandan. ");
INSERT INTO mbi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ini se mid-ulaula niyu ne tuus te seveka kew red dut te ulaula te keep-epuan niyu rengan. Su sikandan ke mid-imatey dut te menge mibpelambas te Lalag te Eleteala rengan ne sikiyu ke midayandayan dut te leveng dan. ");
INSERT INTO mbi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ne geina te metmetau ke Eleteala ne ruen migkahi rin dengan mekeatag ini, ke sikandin te, ‘Edsuhù a te menge etew diyà te kandan te ebpelembasen ku te Lalag ku wey kedserihan ku te ebpemenudtul mekeatag kediey, ne ruen duma ne ed-imeteyan dan ne ruen duma ne ebpendreseyan dan.’ ");
INSERT INTO mbi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tembù be sikiyu ne menge etew guntaan ne igkeragkes kew te Eleteala te kedusa rin dut te kineimatey ran dengan te menge etew ne mibpelambas te Lalag din, igenat te rudsuan te kelibutan. ");
INSERT INTO mbi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Edusaan kew te Eleteala dut te kineimatey dengan te langun ne menge etew ne mibpelambas te lalag din igenat dut te kineimatey ki Abel taman en dut te kineimatey ki Zacarias ke mid-imetayan diyà te elet te edenaan te ibpelengesa te Eleteala wey ke mibpeheletan diyà te Nekebpuru ne Valey te Eleteala. Uya, benar ini se egkehiyen ku,” ke si Hisus, “sikiyu se menge etew guntaan, igkeragkes kew te Eleteala te kedusa rin dut te kinepengimatey ran dengan. ");
INSERT INTO mbi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Iyan kew rà mekeyruwiru ne menge meyterù te penduan! Su ed-elangan niyu ke menge etew su apey ran kenà mekesabut te benar ne ralan dan diyà te Eleteala. Sikiyu ne kenà kew edlusud dut te benar ne ibayà diyà te Eleteala, ne ed-alang kew pà maa rut te etew ne egkesuat ne edlusud ketà.” ");
INSERT INTO mbi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Guna su mid-awà si Hisus ketà te valey te Peresiyu, ne midligpitan en sikandin dut te menge Peresiyu wey ke menge meyterù te penduan, ne merakel se in-insà dan ki Hisus, ");
INSERT INTO mbi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","su ebpemengaan dan se kegkesaut dan ki Hisus su apey ruen idwagib dan kandin. ");
INSERT INTO mbi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Keta ne hewii ne denda ne menge etew se nevurun su ebpemekedtekutakey ran en. Ne rutun ne migkahi si Hisus, ugaid ne iyan din edlelehan ke menge edumdumaan din, ke sikandin te, “Ingati niyu te kenà kew egkepeneheewit rut te menge ulaula te menge Peresiyu su ibpekitakita ran dà ke ulaula ran diyà te etuvangan te menge etew su iring ini rut te ibpelevag te pan ne ed-eneb. ");
INSERT INTO mbi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Langun te netelevan guntaani, ne ebpekepehawahawa red keuremà. Ne langun ne impegelesà, ne egkepayahan ded. ");
INSERT INTO mbi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Langun ne impeleglelahey niyu te merusirem ne igkepayag ded te meandew. Ne misan engkey se impevutbutehey niyu te sikiyu rà ne egkevukayat ded diyà te kerekelan te etew.” ");
INSERT INTO mbi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Menge suled ku,” ke si Hisus, “iyan ku igkahi keniyu ne kenà kew meandek dut te menge etew ne iyan dà egkepatey se lawa niyu, ugaid ne warà en ubpu te ed-ul-ulaan dan su kenà dan egkepatey ke himukud niyu. ");
INSERT INTO mbi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ugaid, ne idtarem ku keniyu ke engkey se ikeandek niyu. Iyan niyu ikeandek ne Eleteala su kenà lawa niyu rà se egkepatey rin su ruen gehem din te kebpekeantug te himukud niyu riyà te apuy ne rakà. Uya, iyan niyu iya ikeandek sikandin.” ");
INSERT INTO mbi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Migkahi pa maa si Hisus te, “Ruen deisek ne pepenuk ne egkepemasa te lelima ne timan ne deruwa rà ne tumbaha. Ne misan iring ketà se kevavà te elehà din, ne warà seveka rà kandan ne egkelipatan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne iyan kew pè be melipati te Eleteala su misan ke edtiweruwan te bulvul niyu ne nevirang din en. Engketà be ne kenà kew meandek su iyan kew pà belielehà diyà te kandin dut te merakel ne pepenuk.” ");
INSERT INTO mbi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ne ruen idtarem ku keniyu,” ke si Hisus, “piya engkey en ne etew se ebpayag diyà te menge etew se ebpesakup kediey ne iyan ibpayag dut te Impeanak te Menusiyà diyà te suluhuen te Eleteala diyà te langit ne ed-engkunen sikandin ne kandin ne sakup. ");
INSERT INTO mbi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ugaid,” ke si Hisus, “piya engkey ne etew se ebparew diyà te menge etew te sakup ku sikandin, ne kenà rema ed-engkunen ne sakup dut te Impeanak te Menusiyà diyà te menge suluhuen te Eleteala diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ne misan engkey en ne etew se edlalag te meraat mekeatag te Impeanak te Menusiyà, ne egkepesahad pà te Eleteala. Ugaid,” ke si Hisus, “piya engkey ne etew ne edlalag te meraat mekeatag te Kedesenan ne Ebpetuntul te menusiyà ne kenè en egkepesehad te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ne embiya ibpemenayik kew nikandan te kukuman diyà te menge valey ne ebpengedian te penduan dan etawa ibpelaus ke pà diyà te menge gubinedur wey egkeunutan dan ne kenà kew meuru ke ebmemenuwen niyu se kedlalag niyu te kedtindeg te hinawa niyu wey engkey se ralan te kegkahi niyu. ");
INSERT INTO mbi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Su iyan ebpenurù keniyu gewii niyu ketà ne ke Kedesenan ne Ebpetuntul te Menusiyà su ebpeketahù te hinawa niyu ke engkey se ibpekahi rin.” ");
INSERT INTO mbi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Duen senge etew ne meama ketà te nevurun se migkahi diyà te ki Hisus te, “Meyterù, kehiyi nu ke kakey ku te ebpeumunan a dut te aren ne intavun te amey rey.” ");
INSERT INTO mbi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Migkahi si Hisus te, “Ey, Mama, warà kewagib ku te egkukum keniyu, ne warà kewagib ku te ebaad ketà te aren ne intavun te amey nu.” ");
INSERT INTO mbi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne midlalag en si Hisus ketà te merakel ne etew te, “Uram kew wey inteng kew te ulaula niyu te warà kegkeeram-am niyu. Su ke tidtu ne puunan te kegkeuyag te etew ne kenà diyà te kearen ne egeweran din.” ");
INSERT INTO mbi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne intarem en ni Hisus ini se impepevayà te sempita: “Duen senge etew ne kewasa nevenar ne ruen tanà din ne egkepekeyan te keuyahan. ");
INSERT INTO mbi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne kehingginawa kayi te etew te, ‘Engkey se ed-ul-ulaan ku kayi te langun ne egkepakey ku? Su kenà egkeamin kayi te balungbalung ne warè en edtehuan. ");
INSERT INTO mbi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A, ini ves,’ ke sikandin, ‘edrundusen ku pà ini se menge balungbalung ne ebelayan ku te rekelà pà su apey ruen egketehuan ku te langun ne egkeehani ku wey ruma pà ne kearen ku. ");
INSERT INTO mbi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne arà pè be imbe ne egkehiyen ku te: Bebegian a ne meama! Su neketahù a te rekelà ne keuyahan taman te pipira pà ne rahun. Ne ketà ne edsinendangan a se egkaan, ed-inum, wey ebpatà dà imbe te nanam.’ ");
INSERT INTO mbi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ugaid ne migkehiyan sikandin te Eleteala te ‘Merupangdupang ka nevenar! Ini rà ne kerukileman ne kayi rà taman se ked-ubpàubpà nu kayi te ampew te dunya. Ne engkey ve vuwa se kemuney keniyan te kearen ne intahù nu?’” ");
INSERT INTO mbi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ne migkahi pà maa si Hisus te, “Ini ve imbe ke egketemanan dut te piya entei ne etew ne ed-umanan din te edtehuan te kearen din, ugaid ne warà te hinawa rin ke egkiyuhan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne migkahi en si Hisus diyà te menge edumdumaan din te, “Ini imbe ke igkahi ku keniyu, kenà kew meuru te egkekaan ne igkeuyag niyu etawa ke engkey se ibelegkas te lawa niyu. ");
INSERT INTO mbi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Su ke hinawa niyu ne imbehey keniyu te Eleteala ne belielehà pà te egkekaan, ne ke lawa niyu rema ne imbehey keniyu te Eleteala ne belielehà pà te velegkas. ");
INSERT INTO mbi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Keniyan niyu rè ma te menge uwak, warà kebpemula ran ne warà ked-ehani ran, ne warà edtehuan dan te egkekaan dan, ugaid ne Eleteala se ebpesavud kandan! Ne iyan kew pè be se belielehà kew pà dut te menge pepenuk! ");
INSERT INTO mbi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Misan engkey en se kegkenuhun te etew te umur din, ne kenà din egkesumpatan te misan deisek dà te ralan te kegkeuru rin. ");
INSERT INTO mbi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Embiya kenà niyu egkegaga ini se reisek dà, ne maa engkey ve se pantag din se kegkeuru niyu te ruma pà? ");
INSERT INTO mbi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Keniyan niyu rè ma te kevukaran ke engkey se kedtuvù dan. Kenà dan egelevek ne kenà dan ed-avel. Ne misan iring ketà ne igkahi ku keniyu te misan ke kewasa ne datù dengan ne si Salomon ne ke keupiya te velegkas din ne warà dà mekesusuluwan dut te keupiya te seveka keniyan ne kevukaran. ");
INSERT INTO mbi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Embiya Eleteala se ebpebparas te kevukaran te sagbet iring ketà misan mehaan dà se kedtuvù dan su egkekita niyu guntaan ne keremà ne nehangu en ne egkevinsulan en, ne iyan kew pè be kenà mevehayi te igkevevelegkas niyu. Sikiyu ne deisek se kedsarig niyu! ");
INSERT INTO mbi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ketà be ne kenà kew meuru, ne kenà iyan niyu rà idtahù te hinawa niyu ke engkey se egkekaan wey egkeinum niyu. ");
INSERT INTO mbi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Su ini imbe ke layun intahù te hinawa rut te menge etew ne warà mebperetiyaya rut te benar ne Eleteala. Ugaid ne sikiyu ne kenà kew meuru su netuenan dut te Amey niyu ne Eleteala te engkey se kurang niyu. ");
INSERT INTO mbi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ne iyan niyu ipeuna te hinawa niyu ke kiyug te Eleteala wey ke kedatù din keniyu, ne arà pà ne ebehayan kew te Eleteala te langun te kurang niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sikiyu ini se menge edumdumaan ku,” ke si Hisus, “kenà kew meandek, su misan deisek kew rà ne ke Amey niyu riyà te langit ne egkiyug ne egkeratù kew dut te menge etew ne Edetuan din. ");
INSERT INTO mbi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pesaa niyu en ke langun ne kearen niyu ne ipemehey niyu ve ke elehà din diyà te menge ayuayu. Embiya ini se ed-ul-ulaan niyu ne egkevaluy ne ruen kekewesai niyu riyà te langit su iring te ruen intahù te keletidà niyu riyà te langit ne kenà egkereving, ne kenà egkeamin ke kekewesai niyu su warà ebpenakew ne warà rumpew ne egketket. ");
INSERT INTO mbi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Su piya endei niyu idtahù ke kekewesai niyu ne ketà dema ke hinawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne mibpenempità si Hisus se egkahi te, “Sesebitan kew neraan ne iyan din meana ne andam kew te misan engkey ne egketemanan, ne kenà niyu ed-evuki ke sulù niyu, ");
INSERT INTO mbi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","su iring kew te menge edsugsuhuen ne edtahad te kebpekeuma te ebpengemuney kandan ne riyà ebpuun te egkewingan ne midtelavuk din. Su embiya layun kew ebpenehana neraan, ne ebpekeuma ke ebpengemuney keniyu ne ebpenehetiat, ne mehaan kew ebpekebukà te lekeb. ");
INSERT INTO mbi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Meupiya nevenar se hinawa rut te menge edsugsuhuen ne neumaan dut te ebpengemuney kandan ne warà midlipereng su mid-andam neraan. Igkahi ku keniyu ini,” ke si Hisus, “se ini se ebpengemuney ne edsembian din ke belegkas din ne ebpepinuuwen din sikandan diyà te egkeenan ne ebpehendaran sikandan. ");
INSERT INTO mbi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Meupiya nevenar se hinawa rut te menge edsugsuhuen ne neumaan dut te ebpengemuney kandan ne mid-andam neraan misan ebpekeuma sikandin te edluuk se hewii te merukilem etawa egkepkepawà en. ");
INSERT INTO mbi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ugaid ne ini se idtahù niyu te hinawa,” ke si Hisus, “embiya ebpekeingat ke kemuney te valey ke keenu ebpekeuma ke tekawen ne ebpenehana neraan sikandin su apey kenà ebpekelusud te valey rin ke ebpenakew. ");
INSERT INTO mbi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ne engketà kew red dema, penehana kew neraan su ebpekeuma ke Impeanak te Menusiyà dut te kenà niyu ebpenerengen ne egketehuan te andew.” ");
INSERT INTO mbi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Guna su nerineg dan ini se midlalag ni Hisus ne migkahi si Pedro te, “Ini se impepevayà nu te sempità nu ne engkey, sikami se egkesuhat etawa abpeg ded ke ruma ne etew?” ");
INSERT INTO mbi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne midtavak si Hisus ke Kerenan te sempita ded, ke sikandin te, “Ke edsugsuhuen ne egkedserihan wey metmetau su edtuman te idsuhù kandin, ne ebpekemalen en dut te ruma ne edsugsuhuen. Ne sikandin se ebehey te egkekaan dut te ruma ne edsugsuhuen ketà te kegkekaan dan. ");
INSERT INTO mbi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Meupiya nevenar se hinawa ketà te edsugsuhuen ne ebpekemalen ke ebpekeuma ke ebpengemuney kandin ne iyan din egkekita se midtuman din ke langun ne insarig kandin! ");
INSERT INTO mbi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Idtarem ku keniyu,” ke si Hisus, “ini se edsugsuhuen ne ebpekemalen ne midtuman te langun ne insarig kandin, ne sikandin en se ebpekekamal dut te langun ne kearen te ebpengemuney kandin. ");
INSERT INTO mbi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ugaid ne embiya iyan netahù te hinawa kayi te edsugsuhuen ne ebpekemalen se, ‘A, kalu ke meuhet pà ebpekeuma ke ebpengemuney kenami,’ ke sikandin, ne ketà ne mibpemedasan din en ke ruma ne edsugsuhuen ne meama abpeg ke menge meritan ne migkaankaan dè be sikandin wey ebpenginum taman te egketevereg en, ");
INSERT INTO mbi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ne ketà ne netekew mekeuma ini se ebpengemuney kandin te hewii ne warà din penerenga su warà din metueni ke endei egketahù ke andew te kedlived din. Ne ed-imetayan dut te ebpengemuney kandin ne ebpeheramen sikandin dut te egketemanan te menge etew ne kenà meperumaruma te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ke edsugsuhuen ne netuenan din ke insarig kandin ne helevek,” ke si Hisus, “ugaid ne warà mebpenehana wey warà medtuman dut te insarig kandin ne ebpeketimaran te ebadas. ");
INSERT INTO mbi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ugaid ne ke edsugsuhuen ne warà din metueni neraan ke engkey se ibpehelevek te ebpengemuney kandin ne ruen mid-ulaula rin ne dait ne ibedasi kandin, ne ebedasan sikandin ugaid ne kenà dà utew ebpeketimaran. Su ke etew,” ke si Hisus, “ne rekelà se insarig kandin ne rekelà dema se egkepenareng kandin. Ne embiya dekdekelà pà se insarig kandin ne iyan pè be kenà dekelà pà se egkepenareng kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Migkahi maa si Hisus te, “Iyan ku kinepengkayi te ampew te dunya su ed-ewit a te apuy ne iyan din meana ne egkukumen ku ke menge etew. Ne kiyug ku perem ne mehaan en egkeretemi. ");
INSERT INTO mbi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dekelà pà se kemeresayan ne ibpevayà ku ne warà pà mekeuma kediey. Iring a te ebpekeutuk te langit taman kenà ku mepasad ini. ");
INSERT INTO mbi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Maa, iyan niyu kunaan ke ini se kinepengkayi ku ne ed-ewit a te kebmelinew kayi te kelibutan? Kenà en iya! Su idtarem ku keniyu te kenà kebmelinew, su ini se kinepengkayi ku ne ruen kebpemekedsingey te hinawa dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Igenat gunteani ne embiya ruen lelima ne telteleanak, ne ebpemekedsingey ke hinawa ran. Ne tetelu se egkunterà dut te deruwa, ne iring din ded dema ke deruwa ne egkunterà dut te tetelu mekeatag te keduma ran kediey. ");
INSERT INTO mbi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ke amey ne egkunterà dut te anak din ne meama, ne ini se anak din ne egkunterà dut te amey rin. Ne ke iney ne egkunterà dut te anak din ne meritan, ne ini se anak ne egkunterà dut te iney rin. Ne ke enuhang ne meritan ne egkunterà dut te ambey rin, ne ini se ambey ne egkunterà dut te enuhang din ne meritan.” ");
INSERT INTO mbi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne migkahi si Hisus diyà te merakel ne menge etew te, “Embiya egkekita niyu te kivel diyà te edsenlepan ne arà dà ne egkahi kew te, ‘Mehaan en ed-uran.’ Ne ed-uran iya rema. ");
INSERT INTO mbi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne embiya egketuusan niyu te ebpependiyà ke keramag te diraya ne ke sikiyu te, ‘Meinit ini.’ Ne ed-andew iya rema. ");
INSERT INTO mbi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sikiyu ne menge etew ne uvag kun warà sesabut niyu te egketemtemanan guntaani! Embiya edtengteng kew te tanà wey langit ne metau kew nevenar ne ebpenipat te hewii, ne meambe ke kenà niyu egkesebutan ke tuus kayi te egketemtemanan guntaan?” ");
INSERT INTO mbi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ne migkahi maa si Hisus te, “Meambe ke kenà niyu ebpegpegitungen ke engkey se edait ne ed-ul-ulaan? ");
INSERT INTO mbi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Upama ke ruen edwagib kenikew ne ed-ewiten ka riyà te kukuman, ne pekidtuntey ka nevenar kandin gewii te keniyan ka pà te ralan su apey kenà ka ibpelaus diyà te uwis. Su embiya ebpekeetuvang ka riyà te uwis ne ibehey ka riyà te menge pulis, ne ke menge pulis se ebilanggù keykew. ");
INSERT INTO mbi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Idtarem ku keniyu,” ke si Hisus, “kenà ka ebpekelihawang ketà taman te kenà nu egkevayaran ke langun ne keselaan nu.” ");
INSERT INTO mbi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ne ruen menge etew ne nekeuma ketà su mibpenudtul ki Hisus mekeatag te menge etew riyà te Geliliya ne mibpeimetayan ni Gubinedur Pilatu gewii te ebpelengesa ran diyà te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ne migkahi si Hisus kandan te, “Geina te mibpeimetayan ini se menge etew te iring ketà, ne maa iyan niyu kunaan ke muna pà se keselaan dan dut te ruma ne menge etew te Geliliya? ");
INSERT INTO mbi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kenà arà! Ugaid ne ini se igkahi ku keniyu te embiya kenà kew ebpemedsendit wey ed-engkeran niyu ke meraat ne ulaula ne ebpematey kew red dema iring kandan. ");
INSERT INTO mbi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ne menu arà se sepulù wey walu ne menge etew riyà te Siluwi,” ke si Hisus, “ne mibpematey ne nepilayan te metmetikang ne valey, maa iyan niyu kunaan ke muna pà se keselaan dan dut te ruma ne menge etew te Hirusalim? ");
INSERT INTO mbi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kenà arà! Ugaid ne igkahi ku keniyu te embiya kenà kew ebpemedsendit wey ed-engkeran niyu ke meraat ne ulaula ne ebpematey kew red dema iring kandan.” ");
INSERT INTO mbi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne ruen maa ruma ne sempità ne imperineg ni Hisus kandan, ke sikandin te, “Duen senge etew ne meama ne ruen kayu rin ne ed-ingaranan te igira ne impemula riyà te pemulaan din. Senge hewii ne midlauy rin su ebpenareng en sikandin ke ruen bahas din, ugaid ne warà. ");
INSERT INTO mbi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ketà dà ne migkehiyan din ke meama ne ed-ihawan ketà te, ‘Egkemenu ini se senge puun ne kenà pà lavew ebahas? Su nekedtetelu en ne rahun se kebpemematì ku te ebehas ne warà pà lavew bahas din. Pilaya nu en! Su ebpekeenget dà kayi te ruma pà ne pinemula.’ ");
INSERT INTO mbi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ne migkahi ini se meama ne ed-ihawan te, ‘Kenà te pà, Anggam, ebpileyan. Ebpememetien te pà te senge rahun, su ed-ihewanan ku pà ke ebpekelingut wey ebukbukan ku pà te ibpelambù. ");
INSERT INTO mbi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne embiya ebahas ded kayi te edtundug ne rahun ne meupiya. Ugaid ne embiya kenà ne arà pà ne ibpepiley nu en.’” ");
INSERT INTO mbi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Senge Hewii ne Id-imeley ne riyà si Hisus te Baley ne Ebpengedian te Hudiyanen te penduan dan su ebpenurù. ");
INSERT INTO mbi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Duen ketà meritan ne nevekut su mibpemekeiran te vusew. Nekedsepulù en wey walu ne rahun ini se kinekevekut din, ne kenà din en iya egkeketeng te misan deisek dà. ");
INSERT INTO mbi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Guna su nekita ni Hisus ini se meritan ne migkahi sikandin te, “Bayi, egkeulian ke en te raru nu.” ");
INSERT INTO mbi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne midampen ni Hisus ke peka rin, ne arà dà ne netidtu en dut te meritan ke peka rin ne nekereyù nevenar sikandin te Eleteala! ");
INSERT INTO mbi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ne neepes ini se egkeunutan dut te valey ne ebpengedian te Hudiyanen te penduan dan su mibawì si Hisus te Hewii ne Id-imeley. Ke sikandin te, “Enem be ne hewii ke igelevek tew. Ne lusud be kayi ne pengkayi kew se ebpemevawì, kenà te ini se Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Migkahi si Hisus kandan te, “Sikiyu ne engkungkun ne edtuman te suhù te Eleteala! Menu, kenà uman senge etew keniyu ne ed-ekar te sapì din etawa kudà din ne edtuyuken din diyà te wayig su ibpeinum din misan Hewii ne Id-imeley? ");
INSERT INTO mbi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ne ini se meritan ne kevuwaran dut te keep-epuan tew rengan ne si Abraham ne nekedsepulù en wey walu ne rahun se kinevakù kandin ni Setanas ke ratù te pekaid. Kenà egkepakey ne kenà ed-ekaran sikandin dut te kinekevakù din misan Hewii ne Id-imeley.” ");
INSERT INTO mbi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Langun dut te egkunterà ki Hisus ne nengeyeyaan dut te migkahi ni Hisus kandan, ugaid ne ke ruma ne menge etew ne nesuatsuat su nekita ran ke mekegeyip ne mid-ulaula ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne migkahi maa si Hisus te, “Engkey ma se edait ne ebpeiringan ta te Kedatù te Eleteala dut te menge etew? Engkey ma se meupiya ne upama ta? ");
INSERT INTO mbi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ini se kedtuvù te Kedatù te Eleteala te menge etew ne ebpekeiring dut te merimet nevenar ne lahas ne ed-ingaranan te Mustasa ne impemula riyà te pengengewiran. Edtuvù ini ne ebaluy ne kayu, ne rutun ebpenesalag ke pepenuk te subpang din.” ");
INSERT INTO mbi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ne migkahi maa si Hisus te, “Engkey se id-upama ta te Edetuan te Eleteala rut te menge etew? ");
INSERT INTO mbi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ini se Edetuan te Eleteala te menge etew ne id-upama ta te ibpepelevag te pan ne migkuwa te meritan ne idsawug dut te senge asad ne tapung su apey ebpeketuvù ke mibawug ne tapung.” ");
INSERT INTO mbi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nekeipus si Hisus ketà ne migenat en se ebpendiyà te Hirusalim, ne ketà te ked-ipanew rin ne mibpengawet-awet sikandin te menge inged su ebpenurù. ");
INSERT INTO mbi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Duen senge etew ne mid-insà kandin te, “Mama, maa kenà be utew merakel ne etew se egkepeliyu te Eleteala?” Midsempità si Hisus kandan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pegelep kew nevenar te kedlusud niyu ketà te melihet ne gumawan te kenà pà egkelekevan, su idtarem ku keniyu ini,” ke si Hisus, “te merakel se egkesuat ne edlusud ugaid ne kenà dan en ebpekelusud. ");
INSERT INTO mbi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Su ke kemuney te valey se ebpendiyà te gumawan su ebpintuan din ne riyà kew rà te liyu se edtawag te, ‘Mama, bukai key pà te lekeb.’ “Ugaid ne iyan din egkehiyen se, ‘Kenà ku egketuenan ke endei kew ebpuun.’ ");
INSERT INTO mbi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ne iyan niyu maa egkekahi se, ‘Kenà nu egketenuran te rengan ne mibpeer-erungutey ki pà se egkaan ne mibpenurù key pà nikuna diyà te inged dey?’ ");
INSERT INTO mbi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ugaid ne edtavak maa sikandin te, ‘Kenà ku iya egketuenan ke endei kew ebpuun. Awà kew kayi te kediey, sikiyu ne menge etew ne meraat se ulaula niyu!’ ke se kemuney te valey. ");
INSERT INTO mbi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ne ebpekependerawit kew se ebpekengingitel kew su egkekita niyu riyà te lusud dut te menge etew ne Edetuan te Eleteala arà se keep-epuan niyu rengan, ne en si Abraham wey ke anak din ne si Isaac wey ke apù din ne si Jacob abpeg dema ke langun ne menge etew ne mibpelambas te Lalag te Eleteala, ugaid ne sikiyu ne kayi kew rà te luwal su kenà kew ebpekelusud ketà. ");
INSERT INTO mbi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne merakel dema se menge etew ne egenat te epat ne pediyulu kayi te kelibutan ne ebpekeuma su ebpekepinuu te egkaan ketà te kevurunan dut te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ugaid ne ruen menge etew guntaan ne mepeembavà se hinawa ran wey ebpesuhùsuhù dan te ruma ran, ugaid ne egkeuma arà se hewii ne sikandan ke mepurù se ketengdanan din. Ne ruen menge etew guntaan ne mepurù se ketengdanen din, ugaid ne egkeuma arà se hewii ne sikandan se pinekemevavà.” ");
INSERT INTO mbi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ketà te arà ne menge hewii ne ruen menge Peresiyu ne mid-ingguma ki Hisus ne migkahi ran te, “Levundus ke en diyà te ruma ne inged su ed-imetayan ka kun ni Hirudis.” ");
INSERT INTO mbi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ne migkahi si Hisus te, “Si Hirudis ayan se metau te edliyuk ne kehiya niyu kandin te, ‘Kenà a ed-awà kayi su guntaani wey keremà ne edlevundusan ku pà ini se helevek ku te ebpenegseg te vusew ne ebpemekaid te menge etew wey ebpemawì a te menge daru ran, ne ketà te iketelu ne hewii ne egkeipus ku ini.’ ");
INSERT INTO mbi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ugaid ne ed-ip-ipanew ad ma guntaan wey keremà abpeg te ikeruwa pà ne hewii su warà ebpekekaid kedì kayi su langun ne ebpelambas te Lalag te Eleteala ne riyà ed-imetayi te lusud te inged ne Hirusalim.” ");
INSERT INTO mbi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ne ketà ne netenuran ni Hisus ke menge ulaula rut te menge etew te Hirusalim ne migkahi sikandin te, “Ey, igkerurunù ku sikiyu ne menge mehinged te Hirusalim! Su sikiyu ke mibpengimatey te menge etew ne mibpelambas te Lalag te Eleteala, wey mibpenrumbag niyu te batu ke menge etew ne midsuhù te Eleteala keniyan te keniyu! Kenà kepipira ku rà perem eburuna sikiyu su edtugenuren ku sikiyu ebpekeiring te upa ne edlekup te anak din, ugaid ne kenà kew ebpelekup kediey! ");
INSERT INTO mbi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na guntaan ne ed-ewaan en te Eleteala ke inged niyu. Ne ini se igkahi ku keniyu, igenat guntaani ne kenà a niyu en egkekita taman te egkeuma arà se hewii ne ebpekekahi kew te, ‘Edeyuen tew ini se nekeuma, ne midsuhù te Eleteala ke Kerenan tew.’” ");
INSERT INTO mbi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Seveka maa ne Hewii ne Id-imeley ne ruen senge etew ne egkeunutan te menge Peresiyu ne mid-inggat ki Hisus te egkaan diyà te valey rin. Ne ketà ne ebpenipaten si Hisus dut te menge etew ke ebpemawì sikandin te Hewii ne Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne ruen ketà meama ne ebpekedaru su midlevag ke velad din wey paa rin. ");
INSERT INTO mbi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mid-insà si Hisus dut te menge meyterù te penduan wey ke menge Peresiyu te, “Kayi te penduan tew, ne menu idtuhut be kenitew se ebpemawì te Hewii ne Id-imeley?” ");
INSERT INTO mbi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ugaid ne langun dan ne mibpeeneng-eneng. Ne migeweran ni Hisus ke meama ne ebpekedaru ne arà dà ne neulian en, ne impeulì din en. ");
INSERT INTO mbi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne migkahi en si Hisus kandin te, “Embiya ruen senge etew keniyu ne ruen anak din etawa sapì din ne neulug diyà te meralem ne kalut te Hewii ne Id-imeley, ne maa kenà niyu edegdehawan te ebpehaun su geina ne Hewii ne Id-imeley?” ");
INSERT INTO mbi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ne ketà ne warà dan meketavak. ");
INSERT INTO mbi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Netuusan ni Hisus te ini se menge etew ne mid-inggat ketà te Peresiyu te egkaan diyà te valey rin ne mibpemilì dan te menge ebpinuuwan te egkeedatan, ne mibpenempità sikandin, ke sikandin te, ");
INSERT INTO mbi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Embiya egkeinggat kew riyà te kevurunan te egkewing, kenà kew ed-una ebpinuu rut te ebpinuuwan te egkeedatan su kema ke ruen mepurù pà keykew ne ebpekeuma. ");
INSERT INTO mbi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne ed-uvey keniyu ini se mibair te kevurunan se egkahi te, ‘Sikandin se pepinuuwa nu keniyan.’ Ne ketà ne egkeyeyaan ka su riyà kew ibpepinuu te iniyuhan. ");
INSERT INTO mbi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ini se meupiya ne ed-ul-ulaan niyu embiya egkeinggat kew riyà te kevurunan, diyà kew pinuu te iniyuhan. Su embiya ve ed-uvey ke mibair te kevurunan ne egkehiyan kew te, ‘Kenà kew ma ruen dà pinuu su kayi kew pinuu te sineruwan ebpinuuwan.’ Ne ketà ne egkeedatan kew rutun te merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Su ke etew ne ebpepurùpurù te hinawa rin ne ibavà te Eleteala, ugaid ke etew ne mepeembavà te hinawa rin ne ibpepurù sikandin te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne migkahi si Hisus dut te etew ne mibair te kevurunan te, “Ne sikuna rema, Mama, embiya ebair ka te kevurunan ne kenà iyan nu rà inggata ke menge sepekat nu wey ke menge suled nu, etawa ke menge etew riyà te uvey nu ne egkewasa. Su embiya ini se ed-ul-ulaan nu, ne ed-inggaten ka red nikandan ne ketà ne nekebayarey kew en. ");
INSERT INTO mbi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ugaid ne embiya ebair ka te kevurunan ne iyan nu inggata ke menge ayuayu, ke menge etew ne sarir, ke menge pungkù wey ke menge pisek. ");
INSERT INTO mbi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ne embiya ini se ed-ul-ulaan nu ne dekelà se kegkehalew nu. Su kenà ke ma nikandan egkevayaran, ugaid ne Eleteala se ebales keykew ketà te akir din ne hewii te kegkevanew te menge etew ne metidtu se ulaula.” ");
INSERT INTO mbi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Duen senge etew ketà te uvey ni Hisus ne nekerineg te migkahi ni Hisus ne migkahi te, “Meupiya nevenar se hinawa rut te ebpeketelavuk ketà te kevurunan te Eleteala dut te menge etew ne Edetuan din.” ");
INSERT INTO mbi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne ketà ne ruen insempità ni Hisus kandin te, “Duen senge etew ne meama ne mibair te dekelà ne kevurunan ne merakel se mid-inggat din. ");
INSERT INTO mbi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Guna su ini en ke bungkà te kevurunan din ne midsuhù din ke edsugsuhuen din diyà te menge etew ne mid-inggat din te ebpesabut kandan te, ‘Kuwa kew en su ebpekaan en.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ugaid ne langun te mig-inggat din ne mibaal te sumbuwan. Ke se neuna kayi te edsugsuhuen te, ‘Kenà dà mebmeraat se hinawa nu su kenà a ebpekependiyà su ruen tanà ne mibpemasa ku ne ed-intengan ku pà.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Senge etew maa se migkahi te, ‘Kenà dà mebmeraat se hinawa nu su kenà a ebpekependiyà su ruen sepulù ne sapì ne mibpemasa ku ne ini pà ne igeram ku te edadu.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ne senge etew pà lavew se migkahi te, ‘Behu e pà ne nekeesawa ne kenà a ebpeketelavuk.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mid-ulì ini se edsugsuhuen ne mibpenudtulan din ke ebpengemuney kandin dut te langun ne menge lalag te menge etew. Ne neepes ini se ebpengemuney kandin ne migkahi maa sikandin dut te edsugsuhuen din te, ‘Pekehaan ka se ebpendiyà te inged ne tuntula nu ke kelesada wey ke menge ralan ne pendumaa nu ke menge ayuayu, ke menge sarir, ke menge pisek wey ke menge pungkù.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Huna su mid-ulì ini se edsugsuhuen ne migkahi sikandin dut te ebpengemuney kandin te, ‘Netuman ku en ke insuhù nu kedì ne ini ran en, ugaid ne warà pà mepengkeg ini se valey.’ ");
INSERT INTO mbi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ne migkahi pà ke ebpengemuney kandin te, ‘Tuntula nu ke merampal wey ke merimun ne menge ralan ne il-iluti nu te ebpepengkayi ke menge etew su apey egkepengkeg ini se valey ku. ");
INSERT INTO mbi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne ini se igkahi ku keniyu, warà senge etew rà dut te neuna ne mid-inggat ku se ebpekeheram dut te elugan ku misan deisek dà.’” ");
INSERT INTO mbi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ne mid-ipanew maa si Hisus ne merakel nevenar ne etew ne miduma kandin. Ne midsineruwan ni Hisus sikandan se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Embiya ruen etew ne egkiyug ne eduma kediey ugaid ne iyan pà dekelà se limù din dut te amey rin wey iney rin, esawa rin, menge anak din, menge suled din, etawa misan ke hinawa rin, ne kenà benar sikandin ne edumdumaan ku. ");
INSERT INTO mbi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Su ke etew ne egkiyug ne eduma kediey ne iyan iya se lipati rin ke kandin ne kiyug ne tianga rin ke kandin ne pinebelavag ne kayu ne ed-ingaranan te Krus ne iyan din meana ne tumana rin ke menge suhù ku misan ibpatey rin pà se keduma rin kediey. ");
INSERT INTO mbi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Upama ke ruen senge etew keniyu,” ke si Hisus, “ne egkesuat ne ebpeitindeg te metmetikang ne baley, ne ed-unaan din pà te ebpegpegitung ke pira se igkegastu rin su apey rin egketueni ke ebpekegaga sikandin etawa kenà. ");
INSERT INTO mbi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Su embiya kenà din ebpegitungen ke pira se igkegastu rin, ne kalu ke iyan din dà egketemanan se matag igkevunsud ke menge pelaus. Ne egkekita rut te langun ne menge etew ini ne ed-un-undaan su warà din meimasad. ");
INSERT INTO mbi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ne ebpeleglelahey ran te, ‘Iyan tumù ne warà mibulug sikandin ke kenà din bes egkepasad.’” ");
INSERT INTO mbi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ne migkahi maa si Hisus te, “Iring ded dema te ratù ne ebpekibunù te senge etew ne ratù, su ed-unaan din pà te ebpegitung ke ebpekegaga sikandin ne ebpekibunù dut te senge etew ne ratù ne ruen deruwa nepulù nengivu se sakup din, ugaid ne sepulù dà nengivu se kandin ne sakup. ");
INSERT INTO mbi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Embiya egkeantap din te kenà ebpekeatu ke menge sakup din, ne ruen edsuhuen din te ebpendiyà te senge etew ne ratù te meriyù pà ini se kunterà din su ebpekidtuntey te warà pà mekebunù. ");
INSERT INTO mbi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ne iring din ded dema,” ke si Hisus, “dut te menge etew ne eduma kediey, kenà kew benar ne edumdumaan ku embiya kenà niyu edtehaken ke langun ne igkenuhuni niyu te kedumaruma niyu kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ne midsempità maa si Hisus te, “Meupiya ini se timus, su ebpekevehey te nanam dut te egkeenen tew ugaid ne embiya egkeawà en ke nanam te timus ne warà en dalan te kebmetimus din pà maa. ");
INSERT INTO mbi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Warà en iya pantag din su kenà egkehamit te misan ebunu ne ibpelambù te tanà, ne idtimbag dà lavew. Na,” ke si Hisus, “ini se migkahi ku ne itaan niyu ke telinga niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Senge hewii ne merakel se menge etew ne ebpevayad te buwis wey menge etew ne mekesesalà dema ne mid-uvey ki Hisus su ebpemineg te penurù din. ");
INSERT INTO mbi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nekita ini rut te menge Peresiyu wey menge meyterù te penduan ne mibpemivig dan se egkahi te, “Si Hisus ini ne ebpemekiduma kayi te menge etew ne mekesesalà ne ebpekidtuhen pà dema kandan.” ");
INSERT INTO mbi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ne ketà be ne mibpenempità si Hisus kandan te, ");
INSERT INTO mbi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Embiya ruen senge etew keniyu ne ruen mehatus ne bilibili rin ne seveka se nelaag, ne engkey se ed-ul-ulaan din? Ini imbe se ed-ul-ulaan din, ed-ewaan din imbe ke siyew nepulù wey siyew ne ebpemenabtab su ebpenuntulen din arà se seveka ne nelaag taman te egketuen din. ");
INSERT INTO mbi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne embiya egketuen din ini ne egkehalewhalew nevenar sikandin, ne ketà ne edsepipiyen din, ");
INSERT INTO mbi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ne ed-ulì en. Embiya ebpekeuma riyà te valey rin ne ebpenenawag sikandin dut te menge ruma rin se egkahi te, ‘Kehalew kew su netuen ku red ini se nelaag ne bilibili ku.’ ");
INSERT INTO mbi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne igkahi ku keniyu,” ke si Hisus, “te iyan pà dekelà ne kehelawan diyà te langit embiya ruen senge etew ne mekesesalà ne ebpekedsendit ne ed-engked te meraat ne ulaula rin, tumin dè be kayi te siyew nepulù wey siyew ne menge etew ne kenè en mulà ebpemedsendit su metidtu kun.” ");
INSERT INTO mbi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ne midsempità maa si Hisus te, “Upama ruen senge etew ne meritan ne ruen sepulù din ne pirak ne elin-elin pelatà ne neterinan te senge elad. Engkey se ed-ul-ulaan din? Ini imbe se ed-ul-ulean din, edtemteman din ke sulù ne arà pà ne ebpenepung sikandin te valey su ebpemengaan din taman te egketuen din ded. ");
INSERT INTO mbi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne embiya egketuen din ded ne ebpenenawag sikandin te menge ruma rin se egkahi te, ‘Kehalew kew su netuen ku red ini se kureta ku ne netarin.’ ");
INSERT INTO mbi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne igkahi ku keniyu,” ke si Hisus, “ne engketà ded be imbe ke kehelawan dut te menge suluhuen te Eleteala riyà te langit ke ruen senge etew ne mekesesalà ne ebpekedsendit ne ed-engked te meraat ne ulaula rin.” ");
INSERT INTO mbi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ne midsempità pà maa si Hisus te, “Duen meama ne deruwa se anak din ne elin meama. ");
INSERT INTO mbi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Migkahi ini se ari riyà te amey rin te, ‘Amà, behayi ad nikew te kediey ne umun kayi te menge aren nu.’ Arà dà ne mibaad en dut te amey ke aren din dut te deruwa ne anak din. ");
INSERT INTO mbi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Warà dà meuhet ne mibpasa en dut te ari ke kandin ne umun ne migkuwa rin ke langun ne kureta rin ne mid-awà en. Diyà mibpesinaru sikandin te medmeriyù ne inged ne rutun din be emina ke kureta rin te warà pantag din. ");
INSERT INTO mbi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Guna su neeminan en sikandin ne migetuk se bitil ketà te inged, ne ini se kenakan ne warà egkepesineruwan din. ");
INSERT INTO mbi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ketà be ne mibuyù sikandin te helevek dut te etew ketà ne iyan imbehey kandin ne helevek ne edtuganur te bavuy riyà te taneb. ");
INSERT INTO mbi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tuus te kegkevitil din ne egkeiveg en sikandin dut te savud te bavuy, ugaid ne warà ma ebpekaan kandin. ");
INSERT INTO mbi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Guna su neuhet ne nekemuhudmuhud sikandin ne kehingginawa rin te, ‘Langun dut te menge etew ne egelevek ki Amà ne edsawadsawad se egkekaan dan, ugaid ne siaken kayi ne ebpatey ad te bitil. ");
INSERT INTO mbi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iyan tumù se ed-ulì e red diyà te ki Amà ne ini se egkehiyen ku, “Amà, dekelà se salà ku diyà te Eleteala wey kayi te sikuna ne amey ku. ");
INSERT INTO mbi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kenà ad edait ne anak a nu pà, ugaid ne peheleveka a nu rà iring dut te edsugsuhuen nu.” ’ ");
INSERT INTO mbi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Arà dà ne mid-ulì en ini se kenakan diyà te amey rin. “Ne riyà pà sikandin te meriyù ne nesandeng en dut te amey rin. Ne midaat nevenar se nanam dut te amey rin kandin ne mibpelelahuy en se edtalavuk kayi te anak din ne midrakep din ne ereki ini se anak din. ");
INSERT INTO mbi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Amà,’ ke se anak din, ‘dekelà en se salà ku riyà te Eleteala wey kayi te sikuna ne amey ku ne kenà ad edait ne anak a nu pà.’ ");
INSERT INTO mbi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ugaid ne midtawag dut te amey rin ke menge edsugsuhuen din se egkahi te, ‘Pekehaan kew ne ipengkayi niyu ke mèmeupiya ne velegkas ne iseluub niyu kandin’. Sisingi niyu sikandin wey telumpai niyu pà sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Engaya niyu ve arà se nati te sapì ne pinelambù ne sumbelia niyu su ebair ki te kevurunan. ");
INSERT INTO mbi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‘Su ini se anak ku ne iring iya te minatey en, ne guntaani ne neuyag maa. Su iring te nelaag en, ne guntaani ne mid-ulì ded.’ Arà dà ne midrudsuan dan en ke kegkevurun dan. ");
INSERT INTO mbi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ne ini se kakey ne anak dut te lukes ne riyà te pengengewiran. Guna su ed-ulì en ne ebpelpelingguma en sikandin kayi te valey ne nekerineg sikandin te edlebpad wey edsayew. ");
INSERT INTO mbi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne midtawag din se senge etew ne edsugsuhuen dut te amey rin ne mid-insàan din te, ‘Engkey ayan se ed-ul-ulaan niyu keniyan te valey?’ ");
INSERT INTO mbi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Midtavak ke sugsuhuen te, ‘Ke ari nu ne mid-ulì en, ne impesumbalì dut te amey nu ke pinelambù ne nati su warà ded nekekaid dut te ari nu.’ ");
INSERT INTO mbi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ugaid ne neepes ini se kakey ne kenà en ebpemenayik diyà te baley ran. Ketà ne mibpemenaug ke amey rin ne midneyneyuan din te ebpepemenayik. ");
INSERT INTO mbi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ugaid ne iyan din migkahi kayi te amey rin te, ‘Tentenuri nu, Amà, te kenà pira rà ne rahun se kinehelhelevek ku keykew iring dut te edsugsuhuen nu, ne warà a keenu midsuer keykew. Ne misan iring ketà ne warà a nu behayi te misan kambing dà su apey a mekehalewhalew rut te menge sepekat ku. ");
INSERT INTO mbi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ugaid ne guna su mid-ulì en ayan se anak nu ne mideraat te kearen nu su indumaruma rin te meritan ne midsumbalì nu mulà ke pinelambù ne nati.’ ");
INSERT INTO mbi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ ‘Mama,’ ke se amey rin, ‘warà ka mekevelag kediey ne langun te kearen ku ne keykew. ");
INSERT INTO mbi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ugaid ne iyan din kemeyidan ne egalewhalew ki, su ini se ari nu ne iring iya te minatey en, ne guntaani ne neuyag maa. Su iring te nelaag en, ne guntaani ne mid-ulì ded.’” ");
INSERT INTO mbi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne ruen ruma pà ne sempità ne migkahi ni Hisus dut te edumdumaan din. “Duen senge etew ne kewasa,” ke sikandin, “ne ruen midserihan din dut te kearen din. Ne ruen mibpenudtul kandin te ini se midserihan din ne ederaat dà dut te kekewesai rin. ");
INSERT INTO mbi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nerineg din arà ne midtawag din arà se kedserihan din ne migkahi te, ‘Engkey ini se nerineg ku mekeatag kenikew? Isurat nu en ke langun ne kegkuwinta nu kayi te ini se helevek ne insarig ku kenikew su kenà ke en egkepakey ne kedserihan ku.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ne kehingginawa rut te meama ne kedserihan te, ‘Ibpeawà e bes dut te mepurù ku. Engkey en be se ed-ul-ulaan ku? Su kenà a ebpekegaga ne egkekalut wey egkeyeyaan a ne ebpememuyù. ");
INSERT INTO mbi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, ini ves se ed-ul-ulaan ku,’ ke hingginawa rin, ‘su apey ruen egkepesineruwan ku ke ibpeawà ad nikandin kayi te helevek ku.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ketà ne midtawag din te idsenge etew ke langun ne ruen utang din ketà te mepurù din. Ke neuna ne mid-insaan din te, ‘Pira pà ke utang nu rut te mepurù ku?’ ");
INSERT INTO mbi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ne midtavak ini se meama te, ‘Mehatus ne latà te lana.’ “Ne migkahi ini se kedserihan te, ‘Ini red ke listaan te utang nu, ne pinuu ka ne degdehawi nu te edsambì te lelima nepulù dà.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ne mid-insaan din maa ke senge etew te, ‘Pira pà ke utang nu?’ “Ne migkahi ini se meama te, ‘Sengivu ne sakù te parey.’ “Migkahi maa ini se kedserihan te, ‘Ini ke listaan te utang nu, ne iyan nu rà isurat se walu nehatus.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Guna su nerineg kayi te mepurù te kedserihan ne nekekahi sikandin te, ‘Hey, metautau sikandin ne ebpenehana te keuyahan din keuremà!’” Ne migkahi en maa si Hisus te, “Ke menge etew ne kayi rà te ampew te dunya ne kenà sakup te Eleteala ne metau ne ebpekiduma rut te ruma ran su apey ruen egkekuwa ran. Ugaid,” ke si Hisus, “ke menge etew ne sakup te Eleteala ne kenà dan bes metau ne ebpenehana te akir din ne hewii riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tembù be igkahi ku keniyu,” ke si Hisus, “te gemita niyu ini se kekewesai niyu kayi te ampew te dunya te edtavang dut te menge ayuayu su embiya ebpatey ke en ne kenà nu en egemiten ke kekewesai nu ne edtelimaan ka te Eleteala riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Su ke etew ne egkeserihan te reisek ne kearen,” ke si Hisus, “ne egkeserihan dema te rekelà ne kearen. Ne iring din ded dema ke etew ne edlimbung te misan deisek dà ne kearen ne wey pè be kenà medlimbung ke rekelà en ne kearen. ");
INSERT INTO mbi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Su embiya kenà ka egkeserihan ne ebpeheweren te kearen kayi te ampew te dunya ne kenà ke en iya ebpeheweren te Eleteala rut te tidtu ne kearen diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne embiya kenà ka egkeserihan ne ebpeheweren te kearen ne kenà keykew, ne kenà ka ebeheyan te Eleteala te tidtu ne kearen nu riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Warà edsugsuhuen,” ke si Hisus, “ne deruwa se edtehiuripen kandin. Su embiya deruwa se ebpengunguripen kandin, ne egkeepesan din ke seveka ne ed-edatan din ke seveka. Etawa ebperumdumaan din ke seveka, ne kenà din edsehipaen ke seveka. Ne iring din ded dema,” ke si Hisus, “embiya iyan dekelà te hinawa nu ne kureta, ne kenà ka ebpeketuman te kiyug te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Duen ketà menge Peresiyu ne iyan den dà dekelà te hinawa ne kureta ran. Nerineg dan dà ini se migkahi ni Hisus ne mid-undaunda ran dà. ");
INSERT INTO mbi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ne migkahi si Hisus kandan te, “Sikiyu ne engkungkun ne menge metidtu kew kayi te sineruwan te menge etew, ugaid ne netuenan te Eleteala ke netahù te hinawa niyu. Su ini se rekelà te hinawa te menge etew ne warà pantag din diyà te etuvangan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ke penduan ni Moises,” ke si Hisus, “wey ke menge impesurat te Eleteala rut te menge etew ne mibpelambas te Lalag din, ini se impesabut dan taman dà te nekeuma en si Juan ke Ebpembunyag. Igenat dè be ketà te nekeuma si Juan ne impesabut en ke Meupiya ne Tudtul mekeatag te Kedatù te Eleteala te menge etew, ne edtehel ke menge etew te kedlusud dan ketà. ");
INSERT INTO mbi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ugaid ne ke penduan ni Moises ne kenà egkeawà, su iyan pà melemu ne egkeawà ini se langit wey tanà tumin dè be ke meawà te senge tahà dà dut te penduan ni Moises. ");
INSERT INTO mbi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Arà se meama ne ebpekid-engked te esawa rin ne edsaup maa ed-esawa,” ke si Hisus, “ne nekepengingniyug en sikandin diyà te etuvangan te Eleteala. Ne engketà ded maa ke meama ne mid-esawa kayi te meritan ne mibpekid-engked dut te esawa rin, ne nekepengingngiyug en dema sikandin diyà te etuvangan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ne migkahi pà maa si Hisus te, “Duen senge etew ne kewasa nevenar ne mibevelegkas te mepurù nevenar se elehà din, ne ini se ked-ubpàubpà din ne warà egkepemengà din. ");
INSERT INTO mbi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne ruen dema senge etew ne ayuayu ne mid-ingaranan ki Lazaro ne nelumbus se lawa rin te padel. Ne uman gewii ne id-ated sikandin te menge ruma rin diyà te pesuran te eheran ketà te kewasa ne meama. ");
INSERT INTO mbi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Su ebpekeinam ke ruen samà dut te kewasa ne meama. Ne gewii rin te ed-id-irehà ketà ne ruen menge asu ne edilà te padel din. ");
INSERT INTO mbi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ne neuma se hewii ne minatey si Lazaro, ne mibpeneheewit sikandin dut te menge suluhuen te Eleteala diyà te uvey ni Abraham diyà te langit. Ne minatey en dema ini se meama ne kewasa ne inleveng dan en sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ne nekependiyà sikandin te apuy ne rakà ne nerasey nevenar sikandin! Ne midlingakà sikandin ne nekita rin diyà te medmeriyà si Abraham. Ne nekita rin dema ketà si Lazaro diyà te uvey rin. ");
INSERT INTO mbi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ne midtawag din en si Abraham se egkahi te, ‘Apù Abraham, ikeyru a nevenar nikuna! Ipepengkayi nu pà si Lazaro su apey rin egkepetihisi ini se bèbà ku te wayig su egkerasey ad nevenar kayi te apuy.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ugaid ne migkahi si Abraham te, ‘Menge anak, tentenuri nu te nekuwa nu en ke langun ne keupiyanan nu te gewii rut te biviyag ke pà, ugaid ne si Lazaro mulà ne neamin-amin din se keresayan. Ugaid ne guntaani ne si Lazaro ne meupiya en se egketemanan din kayi, ne sikuna en se egkerasay. ");
INSERT INTO mbi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne kenà ketà dà taman su ruen egkembusan te tanà keniyan te elet tew, ne misan duen kayi ne egkiyug ne ed-apet keniyan te keniyu ne kenà ebpekeapet. Engketà ded maa ke keniyan te keniyu, kenà dan ebpekeapet kayi.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ne ketà ne migkahi pà maa ke kewasa te, ‘Embiya iring ketà, Apù Abraham, ne ebuyuen ku keykew te ipependiyà nu pà si Lazaro riyà te baley ni Amà, ");
INSERT INTO mbi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","su ruen lelima ne ari ku ne elin meama. Ibpevaag nu sikandan apey kenà dan ebpekepengkayi te ini se ubpaan ne keresayan.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Migkahi si Abraham te, ‘Duen diyà te kandan impesurat ki Moises te Eleteala wey ke impesurat te Eleteala rut te menge etew ne mibpelambas te lalag din, ne arà dè be se upiani ran pemihena.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ne migkahi en maa ke kewasa te, ‘Kenà dan ebpemineg ketà, Apù Abraham, ugaid ne embiya ruen minatey ne egkevanew ne ed-ulì diyà te kandan ne arà pà ne ebpemedsendit dan.’ ");
INSERT INTO mbi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ne migkahi si Abraham te, ‘Embiya kenà dan ebpemineg dut te impesurat te Eleteala ki Moises wey ke impesurat dut te menge etew ne mibpelambas te Lalag te Eleteala, ne iyan dan pè be pemineha ke ruen egkevanew ne ed-ulì diyà te kandan.’” ");
INSERT INTO mbi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ne ruen migkahi ni Hisus diyà te edumdumaan din te, “Kenà egkepakey ne kenà egkeuma ini se kebpenggerami te menge etew, ugaid ne ke etew ne ebpenggeram te ruma rin su apey ebpekedsalà ne mekeyruwiru nevenar! ");
INSERT INTO mbi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iyan pà tumù ne ebperiwetuwan ke lieg din te mevehat ne batu ne id-antug diyà te rahat su apey kenà sikandin se puunaan te kebpekedsalà dut te mevavà ne etew ne edsarig kediey. ");
INSERT INTO mbi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tembù be uram kew! “Embiya ruen duma nu ne nekedsalà kenikew,” ke si Hisus, “ne kehiya nu kandin ne ibpetidtu nu sikandin, ne embiya ebpekedsendit ne ed-engkeran din ke salà din ne pesehara nu. ");
INSERT INTO mbi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Embiya ebpekedsalà sikandin kenikew te kepipitu te lusud te senge keandew ne kepipitu rema sikandin ebuyù kenikew te, ‘Nekedsendit a te mid-ulaula ku, menu ke pesehara a nu,’ ne pesahara nu rema sikandin.” ");
INSERT INTO mbi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ne migkahi ke menge edumdumaan diyà te ki Hisus ke Kerenan te, “Umani nu ke kebperetiyaya rey.” ");
INSERT INTO mbi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne migkahi si Hisus te, “Embiya ruen kebperetiyaya niyu te Eleteala ne reisek misan iring dut te reisek ne lahas ne mustasa ne ebpekekahi ka kayi te ini se rekelà ne kayu te, ‘Awà ka kayi ne arat ka riyà te rahat,’ ne arà dà ne ebpekeperumaruma keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Migkahi maa si Hisus te, “Upama ke ruen senge etew keniyu ne ruen edsugsuhuen din te edadu etawa edtuganur te menge bilibili nu ne mid-ulì sikandin te meapun ne engkey, ebpekekahi ka te, ‘Una ke en kaan su wey ad?’ ");
INSERT INTO mbi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kenè en iya! Su iyan nu mulà egkekahi se, ‘Sambì ka te belegkas nu ne elugan ke en su apey a mekekaan en. Ne wey ka kaan ke ebpekeipus ad.’ ");
INSERT INTO mbi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ne menu, edeyuen nu ke edsugsuhuen nu su midtuman dut te insuhù nu? Kenà en iya! ");
INSERT INTO mbi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ne engketà kew red dema,” ke si Hisus, “embiyà netuman niyu en ke langun ne ibpehelevek te Eleteala keniyu ne kahi kew rà te, ‘Menge edsugsuhuen kiyu rà te Eleteala, ne kenà edait ne edeyuen kiyu su midtuman tew rà ke insuhù din kenitew.’” ");
INSERT INTO mbi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Guna su ebpependiyan en si Hisus te Hirusalim ne riyà mebayà sikandin te eletan te pruvinsiya ne Semeriya wey Geliliya. ");
INSERT INTO mbi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ketà te ebpelpelinggume en sikandin te senge inged ne ruen sepulù ne meama ne midtelavuk kandin ne ruen kevuwa ran muna te it-it. Ugaid ne geina te ruen kevuwa ran ne riyà dan mid-itindeg te malù dà meriyù ki Hisus ");
INSERT INTO mbi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne midtawag dan en se egkahi te, “Hisus, Meyterù, ikeyru key nikuna!” ");
INSERT INTO mbi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nekita rin sikandan ne migkahi en te, “Pendiyà kew te menge terebpelengesa te Eleteala ne peintengi niyu ke lawa niyu te nengeulian en.” Ne mid-ipanew ran ne gewii te riyà dan en te ralan ne nengeulian dan en. ");
INSERT INTO mbi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne senge etew kandan se nekekita te neulian sikandin ne midlived kayi te ki Hisus se egkulkuleyì en se edeyù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne mid-uvey sikandin ki Hisus ne midlumpeng en sikandin kayi te sineruwan ni Hisus se ebpeselamat kandin. Ne ini se etew ne kenà Hudiyanen su riyà ebpuun te inged ne Semeriya. ");
INSERT INTO mbi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ne migkahi si Hisus te, “Maa kenà sepulù niyu beneng ke nengeulian? Endei en be ke siyew ne etew? ");
INSERT INTO mbi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Meambe ke sikuna rà ini se tegeSemeriya se midlived su ebpeselemat te Eleteala?” ");
INSERT INTO mbi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne migkahi en si Hisus te, “Itindeg ke en, Mama, ne levundus ke en su ke sarig nu te Eleteala se nekeulì keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Senge hewii maa ne ruen menge Peresiyu ne mid-insà ki Hisus te, “Keenu egkeuma arà se Kedatù te Eleteala te menge etew?” Midtavak si Hisus kandan te, “Kenà niyu egkekita se kebpekeuma rut te Kedatù te Eleteala te menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Warà ebpekekahi te, ‘Ini en ke Kedatù din,’ etawa ebpekekahi te, ‘Ediyan en.’ Su ini se Kedatù te Eleteala te menge etew ne kenà egkekita su kayi red te hinawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne migkahi en si Hisus kayi te edumdumaan din te, “Duen gewii ne egkeuma ne rekelà se kiyug niyu te metuman ke hewii te edlived ke Impeanak te Menusiyà, ugaid ne kenà pà egked-ulaula. ");
INSERT INTO mbi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Duen egkahi keniyu te, ‘Ediyan en ke Ebperetuen te Eleteala te menge etew,’ etawa egkahi ran te, ‘Ini en.’ Ugaid ne kenà kew eduma kandan. ");
INSERT INTO mbi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Su ketà te kedlived te Impeanak te Menusiyà kayi te ampew te dunya ne iring kehaan din te kilat ne ebpeketayew te langun ne linengkevan igenat te pehiliran taman te binunsuran. ");
INSERT INTO mbi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ugaid te kenà pà ini egked-ulaula ne iyan iya se egkerasey pà sikandin wey ed-engkenà kandin ini se menge etew guntaani. ");
INSERT INTO mbi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ketà te akir din ne hewii ke edlived sikandin kayi te ampew te dunya, ne ebpekeiring ke ed-ul-ulaan te menge etew rut te ed-ul-ulaan te menge etew rengan te gewii pà ni Noa. ");
INSERT INTO mbi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Su rengan te hewii pà ni Noa, ne warà sanggel dan se ebpengevurun su egkaankaan dan ne ebpenginum wey ebpees-eseweey taman te arà en ke hewii ne midlusud en ensi Noa ketà te rekelà ne avang ne ed-ingaranan te arka. Ne arà ne nekeuma en ke dalem ne neherà dan en langun. ");
INSERT INTO mbi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ebpekeiring ded dema rut te hewii ni Lut. Su warà sanggel dan se ebpengevurun su egkaankaan dan ne ebpenginum, ebpememasa wey ebpemendahang, ebpememula wey ebpemevaley. ");
INSERT INTO mbi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ugaid ne arà se hewii ne kinepeawà ki Lut ketà te inged din ne ed-ingaranan te Suduma ne imperadsang te Eleteala ini se regreg wey esupri ne riyà ebpuun te langit ne neherà dan langun. ");
INSERT INTO mbi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Iring ded be ketà se kehaan din ke edlived kayi ke Impeanak te Menusiyà su kenà ebpenerengen te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ketà ke egkeuma arà ne hewii,” ke si Hisus, “ne embiya ruen etew riyà te ruwangen te baley rin ne kenà din en lilingaya ke keleglehan din. Ne engketà ded dema ke riyà sikandin te pengengewiran, kenè en med-ulì diyà te valey su egkuwa te piya engkey en. ");
INSERT INTO mbi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tentenuri niyu ke engkey se netemanan dut te esawa ni Lut te midlilingey sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Su ke etew ne egkenuhun te umur din ne ebpatey lavew, ugaid ke etew ne iyan din ibpatey se keduma rin kediey te kebpemesabut dut te Meupiya ne Tudtul ne ruen umur ne ibehey kandin ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne ini se tendai nu nevenar, embiya merukilem se kedlived din kayi ne ruen ebpeulirey ne deruwa ne etew, ne ebpekeruma ke senge etew kandin ne egketahak ke seveka. ");
INSERT INTO mbi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Engketà ded dema ke meandew se kedlived din kayi, embiya duen deruwa ne meritan ne ebpeemungey te egaling, ne ebpekeruma ke senge etew kandin ne egketahak ke seveka.  ");
INSERT INTO mbi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Engketà ded dema ke ruen deruwa ne etew ne ebpeemungey riyà te pengengewiran, ebpekeruma ke senge etew kandin ne egketahak ke seveka.” ");
INSERT INTO mbi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ne ketà ne mid-insà ke menge edumdumaan ni Hisus kandin te, “Endei ve ini egketuman?” Ne midtavak din te tatap ne beseanan, ke sikandin te, “Piya endei se ruen minatey rin ne ketà eburun ke menge uwak.” ");
INSERT INTO mbi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Duen maa insempità ni Hisus dut te edumdumaan din su apey ran egketenuri se layun dan ebpengeningeni ne kenà dan egkevungas. ");
INSERT INTO mbi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ke sikandin te, “Duen senge etew ne egawed te kukuman diyà te senge inged ne warà andek din te Eleteala etawa warà adat din te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ne ketà te inged ne ruen dema senge etew ne meritan ne valu ne layun ebpengkayi te kandin su ebuyù te tavang din. ‘Tevangi a nu,’ ke se meritan, ‘su apey kenà meahew te kunterà ku ini se kearen.’ ");
INSERT INTO mbi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ne neuhet nevenar ne warà sehipaa kayi te egawed te kukuman ini se meritan, ugaid ne neperaan te kedlivedlived te meritan ne kehingginawa rin te, ‘Misan warà andek ku te Eleteala etawa warà adat ku te menge etew, ");
INSERT INTO mbi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ne geina te edlingasa ini se meritan kediey ne idtindeg ku sikandin kayi te kunterà din su apey ed-engked en su embiya kenà ne egkepupusan ad te tigker.’” ");
INSERT INTO mbi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne migkahi en maa si Hisus te, “Pegpegitunga niyu arà se midlalag dut te egawed te kukuman ne kenà metidtu ne midtindeg dut te meritan. ");
INSERT INTO mbi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ne menu kenà be edtindeg ke Eleteala dut te kandin ne menge etew embiya ebpengeningeni ran diyà te kandin te merukilem meandew? Maa edlanganlangan pè bè sikandin se edtavang kandan? ");
INSERT INTO mbi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Igkahi ku keniyu,” ke si Hisus, “mehaan se kedtindeg din keniyu. Kenà egkevungas ke Eleteala ne edtavang dut te etew rin, ugaid ne ketà te edlived kayi ke Impeanak te Menusiyà ne menu duen pè be egkeumaan din ne edsarig kandin?” ");
INSERT INTO mbi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ne ruen impenempità ni Hisus ne ebpekesuhat dut te menge etew ne iyan dan kunaan ke menge metidtu ran ne edsudì dan ke langun ne menge ruma ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ke si Hisus te, “Duen deruwa ne etew ne mibpendiyà te Nekebpuru ne Valey te Eleteala su ebpengeningeni. Senge etew ne Peresiyu ne ini se seveka ne ebpevayad te buwis. ");
INSERT INTO mbi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Guna su ketà dan en te lusud ne mid-itindeg ini se Peresiyu ne mibpengeningeni te hinawa rin, ke sikandin te, ‘Is Eleteala, ebpenelamat a kenikew ne Eleteala su kenà a iring keniyan te ruma ne menge etew ne tenlimbungen, menge etew ne meraatey se ulaula ran, wey menge etew ne ebpengingniyug. Uya, ebpenelamat a te kenà a iring keniyan te etew ne ebpevayad te buwis. ");
INSERT INTO mbi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Uman senge pedian ne ke reruwa a edlimpas se egkaan ne ebehey a kenikew te ikesepulù ne umun dut te langun ne egkevatunbatun ku.’ ");
INSERT INTO mbi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ugaid ne ini se etew ne ebpevayad te buwis ne mibpekeriyù sikandin ne midurungul ne mibpenempak din se kumeng din te kegkebmutu rin ne mibpengeningeni se egkahi te, ‘Is Eleteala, ikeyru a nevenar nikuna su mekesesalà a.’ ");
INSERT INTO mbi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Igkahi ku keniyu,” ke si Hisus, “ketà te kineulì kayi te ebpevayad te buwis ne kenè en ebpenunduhen te Eleteala ke salà din, ugaid ne kenà iring ketà te mepereyù ne Peresiyu. Su piya entei ne etew ne ebpepurùpurù te hinawa rin ne ibpevavà te eleteala, ugaid ne piya entei ne etew ne mepeembavà te hinawa rin ne ibpepurù sikandin te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na ruen menge etew ne mibpemava te anak dan diyà te ki Hisus su ibperampen dan kandin su ebpepenubtuvaran, ugaid ne midawey ran dut te menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Guna su nekita ini ni Hisus ne midtawag din ke menge vatà ne migkehiyan din ke menge edumdumaan din te, “Kenà niyu dewaya sikandin! Ugaid ne ibpepengkayi niyu te kediey ke menge vatà su ke menge etew ne iring te menge vatà se kedsarig dan kediey ne iyan ebpekeamung te Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sebenarvenar ini se egkehiyen ku, ke etew ne kenà edtelimà te Kedetui kandin te Eleteala iring te kedtelimà kayi te reisek ne vatà ne kenà ebpekelusud sikandin dut te menge etew ne Edetuan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Duen hewii ne ruen mibpengkayi te ki Hisus ne senge etew ne egkeunutan te menge Hudiyanen ne mid-insà te, “Meyterù, langun ne ed-ul-ulaan nu ne meupiya! Engkey se ed-ul-ulaan ku su apey a mekekuwa te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ne midtavak si Hisus te, “Meambe ke nekahi nu te meupiya ke langun ne ed-ul-ulaan ku? Su seveka rà sa meupiya se ed-ul-ulaan din ne Eleteala rà. ");
INSERT INTO mbi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ugaid ne embiya arà se id-insà nu mekeatag te umur ne warà edtemanan, ne netuenan nu en ke penduan te Eleteala ne egkahi te: ‘Kenà ka ebpengingniyug, kenà ka ed-imatey, kenà ka ebpenakew, kenà ka edtarùtarù, ne edati nu ke amey nu wey ke iney nu.’” ");
INSERT INTO mbi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ne migkahi ke meama te, “Meyterù, igenat te batà e pà ne langun keniyan ne midumaan ku.” ");
INSERT INTO mbi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nerineg dà ni Hisus ini ne migkahi en sikandin te, “Duen pà lavew kurang nu. Iyan be se ulì ka ne pesaa nu ke langun ne kearen nu ne ipemehey nu ve ke elehà din diyà te menge ayuayu su apey ruen kekewesai nu riyà te langit ne muna pà dut te kearen nu kayi. Ne arà pà ne pengkayi ka te eduma kedì.” ");
INSERT INTO mbi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nerineg din dà ke lalag ni Hisus ne neuru nevenar sikandin su kewasa nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nekita ni Hisus te neuru ke meama ne migkahi sikandin te, “Merehen nevenar te kewasa ne etew se kebpesakup din dut te menge etew ne Edetuan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Iyan pà melemu ne ebpevayà diyà te vudsi te rahum ini se rekelà ne binatang ne kemilu tumin dè be ke kebpesakup te etew ne kewasa dut te menge etew ne Edetuan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ke menge etew ne nekerineg kayi ne mid-insà te, “Embiya iring ketà se kerehen din te etew ne kewasa te kebpesakup din dut te menge etew ne Edetuan te Eleteala, ne engkey rè be buwa se ebpekeangkun te umur ne warà edtemanan din?” ");
INSERT INTO mbi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne migkahi si Hisus te, “Embiya etew rà ne kenà dan ebpekegaga te ed-angkun te umur ne warà edtemanan din ugaid ne Eleteala se ebpekegaga ne ebehey kandan su egkegaga te Eleteala ke langun.” ");
INSERT INTO mbi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne migkahi si Pedro te, “Netuenan nu te mid-ewaan dey ke langun taman dey su miduma key keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ne migkahi si Hisus kandan te, “Sebenarvenar ini se egkehiyen ku keniyu te misan entei ne etew se neawaan din ke ubpaan din, esawa rin, menge suled din, menge lukes din, wey menge anak din su atag te kebpesakup din dut te menge etew ne Edetuan te Eleteala, ");
INSERT INTO mbi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ne ebpetelimaan sikandin te Eleteala misan kayi pà sikandin te ampew te dunya te labi pà kerakel din dut te neewaan din, ne ketà te akir din ne hewii ne ebpeketelimà sikandin te umur ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ne ketà ne impesivey ni Hisus ke sepulù wey deruwa ne edumdumaan din ne migkahi te, “Netuenan niyu en ne ebpendiyà kiyu te Hirusalim ne ketà ne egketuman en langun ne impesurat te Eleteala dut te menge mibpelambas te Lalag din dengan mekeatag te sikandin ne Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ne ibpalad sikandin diyà te menge etew ne kenà Hudiyanen ne ed-un-undaen sikandin, ebpegkeyaen sikandin, wey ebpengilevan sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ebpenlembiten dan sikandin wey ed-imetayan. Ugaid ne ketà te iketelu ne hewii ne ebenawen ded te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ugaid ne ini se edumdumaan din ne warà dan mekesabut te misan deisek dà kayi te migkahi ni Hisus. Su in-eles kandan ke meana rin, ne warà dan metueni ke engkey se edlelehen din. ");
INSERT INTO mbi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Guna su ebpelundani en ensi Hisus diyà te inged ne ed-ingaranan te Hiriku, ne ketà te kilid te ebpevayaan dan ne ruen meama ne pisek ne ebpinpinuu su ebpemuyù. ");
INSERT INTO mbi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Guna su nerineg din te merakel ne etew se edsahad ne mid-insà sikandin te, “Engkey ini?” ");
INSERT INTO mbi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne ruen midtarem kandin te, “Si Hisus ne riyà ebpuun te Neserit se edsahad.” ");
INSERT INTO mbi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Guna su nerineg din ini ne midtawag en te, “Hisus, ke inenakan ni David dengan, igkeyru a nu nevenar!” ");
INSERT INTO mbi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ne neepes ke menge etew ne riyà te unaan ni Hisus ne midawey kandin ne migkahi te ebpeen-enengen sikandin, ugaid ne lemban en ne egkeilut se ebpemensag te, “Sikuna ne inenakan ni David dengan, igkeyru a nu nevenar!” ");
INSERT INTO mbi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Guna su nerineg ni Hisus ne mid-itindeg pà sikandin ne midsuhù te ibpepikit ke pisek kayi te kandin. Nekeuvey ki Hisus ke meama ne pisek ne mid-insaan din te, ");
INSERT INTO mbi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Engkey ma se ebpetevangan nu kediey?” Ne migkahi ke pisek te, “Meyterù, kiyug ku ne mekekita a red perem!” ");
INSERT INTO mbi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne migkahi si Hisus te, “Su kenà duwaruwa ke kedsarig nu kediey, ne ebpekeulit en ke kebpekekita nu.” ");
INSERT INTO mbi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Arà dà iya ne nekekita en ini se meama, ne miduma en ki Hisus se edeyù te Eleteala. Ne ke menge etew ne nekekita kayi ne mideyù dan dema ke Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nekeuma en ensi Hisus diyà te inged ne Hiriku ne ketà dan mibpevayà te luuk te inged te kedlaus dan en. ");
INSERT INTO mbi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne ruen ketà senge etew ne ed-ingaranan ki Sekiyu. Senge etew ini ne meama ne mepurù dut te menge etew ne ebpevayad te buwis ne kewasa nevenar. ");
INSERT INTO mbi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Egkesuatan din te edtengteng si Hisus, ugaid ne kenà din egkekita su nelingutan si Hisus te merakel ne etew ne mevavà ne etew si Sekiyu. ");
INSERT INTO mbi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ketà be ne mibpelelahuy sikandin diyà te unaan te merakel ne etew ne mid-ambak diyà te kayu ne ed-ingaranan te sikumuru ne egkeseharan ni Hisus su apey rin mekita si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Guna su nekeuma en si Hisus ketà te levut te kayu ne mid-embakan ni Sekiyu ne midlingakà ne migkahi te, “E Sekiyu, dahew ke en se edurus keniyan su ebpekeawet a diyà te baley nu guntaani.” ");
INSERT INTO mbi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Arà dà ne midahurahu midurus si Sekiyu ne migalàhalà din si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nerineg kayi te merakel ne etew ini se migkahi ni Hisus ki Sekiyu ne mibpemeviyig dan se egkahi te, “Meambe ke miduma si Hisus diyà te valey te etew ne mekesesalà?” ");
INSERT INTO mbi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nekeuma ran diyà te valey ni Sekiyu ne mid-itindeg sikandin ne migkahi diyà te ki Hisus te, “Na, ibehey ku ini se tengà te kekewesai ku diyà te menge etew ne ayuayu. Ne embiya ruen etew ne nelimbungan ku ne ed-ulian ku te keepat egketakep ke nekuwa ku kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ne migkahi si Hisus kandin te, “Sikiyu ne telteleanak kayi ne nekeliyu kew en te kedusa te Eleteala te salà niyu. Ne sikiyu ini ne tuney kew en ne keep-epuan ni Abraham su mibperetiyaya kew en. ");
INSERT INTO mbi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Su iyan din impengkayi ke Impeanak te Menusiyà te ampew te dunya su ebpemengà te langun ne menge etew ne nekesuwey ketà te tidtu ne ibayà te Eleteala su apey ran ebpekeliyu rut te keberedusaan dan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ne mibpenempità si Hisus dut te menge etew ne ebpemineg kandin. Su merani ran en diyà te inged ne Hirusalim ne iyan kunaan dut te menge etew ke embiya ebpekeuma ran diyà ne edrudsuen Edatù ke Eleteala te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tembù be midsempità si Hisus kandan se egkahi te, “Duen senge etew ne berebansa ne mibpendiyà te meriyù ne inged su edsempayatan te gelal te kegkeratù, ne ketà be te ked-ulì din ne edatù en kayi te inged din. ");
INSERT INTO mbi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne ketà te warà pà mekehenat ne midtawag din te sepulù ne etew ne edsugsuhuen din ne uman senge etew kandan ne mibehayan din te kureta ne neked-iring ke kerakel din. Ne migkehiyan din sikandan te, ‘Ini se kureta ne idsarig ku keniyu ne sikiyu en se ebpeiseg taman te kenà e pà ebpekeulì.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ugaid ne ini se mehinged te inged din ne neepes kandin, ne guna su mid-ipanew sikandin ne ruen midsuhù dan te ebpesabut ketà te etew ne edsempayat te gelal kandin se egkahi te, ‘Kenà key egkiyug ne sikandin se edatù kenami.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ugaid ne misan iring ketà ne sikandin ded se midsempayatan te kegkeratù ne mid-ulì en. Nekeuma rà ne midtawag din en ke sepulù ne edsugsuhuen din ne midserihan din te kureta su ed-intengan din ke pira se kinepeiseg dan dut te kureta rin. ");
INSERT INTO mbi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Nekeuma ke neuna ne edsugsuhuen ne migkahi te, ‘Datù, sepulù se neisahan din ke kureta ne insarig nu kedì.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Migkahi ini se meama ne behu pà ne edatù te, ‘Arà be! Meupiya ka su mibpegelep ke ves iya rema! Geina te egkeserihan ka te deisek ne kureta ne iyan ku idsarig kenikew ne ebpekemalen ku sikuna te sepulù ne inged.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nekeuma ke ikeruwa ne edsugsuhuen din ne migkahi te, ‘Lelima, Datù, se neisehan din dut te kureta ne insarig nu kedì.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ne migkahi ke datù te, ‘Arà be! Ne lelima ne inged se ebpekemalan ku keykew.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nekeuma ke iketelu ne edsugsuhuen ne migkahi te, ‘Ini red ke kureta ne insarig nu kedì. Midtegtehaman ku te edtenges ne intahù ku, ");
INSERT INTO mbi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","su neandek a su netuenan ku te mepasang ka ne etew. Ebpenareng ka te kebpekeiseg ke ruen idsarig nu te edsugsuhuen nu; ne engketà ded dema ke ruen ibpepemula nu kandan su ebpenerengen nu.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ke se datù te, ‘Mereatey ke ves ne edsugsuhuen! Ayan dà se nengelalag nu ne neisuhat ku en sikew te kewagib. Netuenan nu ves te taman te nekahi ku ne idtehel ku, ne ebpenareng a te iseg ke ruen idsarig ku te ruma ku, ne engketà ded ke ruen ibpepemula ku te ruma ku, ebpenerengen ku red. ");
INSERT INTO mbi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Meambe ke warà nu ipemeutang arà se kureta ku ne insarig ku keykew su apey ku metelimà ke kureta ku te ruen iseg din ke edlived a?’ ");
INSERT INTO mbi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ne migkahi en ke datù ketà te menge etew ne ebpengit-itindeg te, ‘Kua niyu arà se kureta keniyan te kandin ne ivehey niyu ketà te edsugsuhuen ne mibpeiseg te sepulù.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ne migkahi ran te, ‘Ne ruen en ma kandin su sepulù ke iseg dut te kureta rin.’ ");
INSERT INTO mbi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ne migkahi ke datù te, ‘Igkahi ku keniyu te ke etew ne egkeserihan dut te insarig kandin ne ed-umanan pà. Ugaid ke etew ne kenà egkeserihan ne ed-ewien pà misan ke reisek ne insarig kandin. ");
INSERT INTO mbi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na ini se menge etew ne egkunterà kedì su kenà dan egkiyug ne edatù a kandan, ne ipepengkayi niyu ne imetayi niyu kayi te etuvangan ku.’” ");
INSERT INTO mbi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nekeipus si Hisus se edlalag kayi ne mid-ipanew ran en se ebpendiyà te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nekeuvey ran diyà te deruwa ne inged ne Bitpahi wey inged ne Bitanya diyà te buvungan ne ed-ingaranan te Ulivuwen. Ne mibpeuna sikandin te deruwa rut te edumdumaan din se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Una kew en ketà te inged ne an te unaan ta, ne ketà te ebpekeuma kew ne egkekita niyu ke nati ne kudà ne in-iket ketà ne warà pà bulug meunturì. Ekari niyu be ne ewita niyu en kayi. ");
INSERT INTO mbi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne embiya ruen ed-insà keniyu te, ‘Meambe ke ed-ekaran niyu ke nati ne kudà?’ ne iyan niyu kehiya te, ‘Ke Kerenan dey se ebpegingawà te egkeunturan din ne mehaan dà id-ulì.’” ");
INSERT INTO mbi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nekeuma ini se midsuhù din ne nekita ran ke nati te kudà ne iring iya rema ketà te migkahi ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Gewii ran te ed-ekar dut te nati ne migkahi ke menge kemuney te, “Meambe ke ed-ekaran niyu ayan se nati?” ");
INSERT INTO mbi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ke sikandan te, “Si Hisus ke edlingekaan dey se ebpeginawà kayi te egkeunturan din ne mehaan dà id-ulì.” ");
INSERT INTO mbi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne arà dà ne mid-ewit dan en ini se nati ne kudà kayi te ki Hisus, ne midebpasan dan en te kumbalà dan ke nati ne kudà ne arà pà ne pineerà dan si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gewii rin te egkukudà ne midtulid ke menge etew te kumbalà dan te ebpepevayaan ki Hisus su tuus ini te adat te menge Hudiyanen te mepurù dan. ");
INSERT INTO mbi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Guna su nekeuvey en sikandin te Hirusalim ketà dapit te dalan ne idtupang ketà te buvungan ne Ulivuwen ne langun dut te menge etew ne midurumaruma kandin ne migkerag se egalewhalew te kedeyù dan te Eleteala su atag te langun ne nekita ran ne mekegeyip ne mid-ulaula ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ke sikandan te, “Menu ma ke ebpeneuven te Eleteala ini se datù ne nekeuma su impepengkayi te Eleteala. Ne melinew en ke kebpekiduma tew te Eleteala, ne edeyuen tew ke Eleteala diyà te langit!” ");
INSERT INTO mbi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ketà te menge etew ne miduma ki Hisus ne ruen menge Peresiyu ne migkahi riyà te ki Hisus te, “Peengkera nu ayan se edumdumaan nu se edeyù keykew su ebpekesahad en utew!” ");
INSERT INTO mbi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Igkahi ku keniyu,” ke si Hisus te, “embiya ebpeeneng-eneng dan ne langun keniyan te menge batu ne iyan dan egkerag.” ");
INSERT INTO mbi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Guna su ebpekeuvey en sikandin kayi te Hirusalim ne impelayap din ke mata rin kayi te inged ne midsinehewan din su ingkeyru rin nevenar ke menge mehinged ketà. ");
INSERT INTO mbi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ke sikandin te, “Embiya perem netuenan niyu rà ke engkey se benar ne kebmetidtu su apey melinew se inged niyu, ugaid ne guntaani ne kenà niyu egketuenan. ");
INSERT INTO mbi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Duen gewii ne egkeumaan kew te menge kunterà ne edtengkalen kew nikandan wey edtelikupan kew ne warà en iya egensik. ");
INSERT INTO mbi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Edereetan dan ke menge valey niyu ne ebeluyan dan ne tapung ke inged niyu su warà seveka rà ne batu ne egketahak dut te netehuan din. Ne langun niyu ne egkeherà. Ini se egketemanan niyu su warà kew medsehipà te ini en ke hewii te kinepepengkayi te Eleteala kedì su apey kew ebpekeliyu.” ");
INSERT INTO mbi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nekeuma si Hisus diyà te Hirusalim ne midlusud sikandin diyà te Nekebpuru ne Valey te Eleteala ne mibpenegseg din en ke menge etew ne ebpemasa wey ke menge ebpemendahang ketà. ");
INSERT INTO mbi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne migkahi sikandin te, “Duen en ura impesurat ne Lalag te Eleteala ne egkahi te, ‘Ini se baley ku ne ed-ingaranan te baley ne ebpengeningeniyan.’ Ugaid ne sikiyu,” ke si Hisus, “ne mibaluy niyu en ini se baley ne ubpaan te menge tenlimbungen.” ");
INSERT INTO mbi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Igenat dè be ketà ne uman andew ne ebpenurù sikandin ketà te Nekebpuru ne Valey te Eleteala. Ugaid ne ini se menge mepurù te terebpelengesa te Eleteala, ke menge meyterù te penduan wey ke menge unuten dut te menge etew ne mibpemengà dan te ralan te kegkeimetayi ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ugaid ne warà dan mekevaluy su langun ne menge etew ne egkevenbenaran te penurù din. ");
INSERT INTO mbi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Senge hewii ne mibpenurù ni Hisus ke menge etew riyà te Nekebpuru ne Valey te Eleteala su ibpesabut din ke Meupiya ne Tudtul. Ne ketà ne mibeyaan sikandin dut te menge mepurù te terebpelengesa te Eleteala, ke menge meyterù te penduan wey ke menge unuten te Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne mid-insaan dan si Hisus te, “Ini se mid-ulaula nu kayi te Nekebpuru ne Valey te Eleteala ne engkey se kewagib nu te ed-ulaula te iring kayi? Ne engkey se mibehey keykew te kewagib?” ");
INSERT INTO mbi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ne midtavak si Hisus te, “Duen dema id-insà ku keniyu ne tevaka a nu. ");
INSERT INTO mbi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Entei ke mibehey ki Juan ke Ebpemunyag te kewagib te ebunyag, diyà be te Eleteala etawa kayi rà dè duen te menusiyà?” ");
INSERT INTO mbi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne mibpein-inseey ran en te ke sikandan te, “Engkey se idtavak tew? Su embiya egkehiyen tew se, ‘Riyà ebpuun te Eleteala,’ ne ed-insà maa sikandin te, ‘Meambe ke warà kew mibperetiyaya ki Juan?’ ");
INSERT INTO mbi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ugaid ne embiya egkahi ki te, ‘Kayi red ebpuun te menusiyà,’ ne ebpenrumbahen ki rut te menge etew te batu su langun dan ne mibperetiyaya te si Juan ne mibpelambas te Lalag te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ketà be ne iyan dan intavak ki Hisus te, “Kenà dey egketuenan ke endei ebpuun.” ");
INSERT INTO mbi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne migkahi si Hisus kandan te, “Embiya iring ketà ne kenà ku rema egkehiyen ke enta se mibehey kedì te kewagib ku te ed-ulaula kayi.” ");
INSERT INTO mbi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne ruen sempità ne imperineg ni Hisus riyà te menge etew, ke sikandin te, “Duen senge etew ne ruen tanà din ne mibpemulaan din te wahed ne ed-ingaranan te paras. Ne ruen pinekamal din dut te impemula rin, ne arà pà ne mid-ipanew en se ebpendiyà te meriyù ne inged ne ketà pà ed-ubpà te meuhet. ");
INSERT INTO mbi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Guna su midsabpet en ke pinemula rin, ne ruen senge etew ne edsugsuhuen din ne midsuhù din su ibpekuwa ke kandin ne umun. Ugaid ne nekeuma ini se midsuhù din, ne mibedasan dut te pinekamal ne impeulì dan te warà en iya imbehey kandin. ");
INSERT INTO mbi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ne misan iring ketà, ne midsuhù en maa se senge etew. Ugaid ne nekeuma ini ne mibedasan dan ded maa, ne pinegkeyà dan ne impeulì dan te warà ded dema imbehey ran. ");
INSERT INTO mbi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nekita maa kayi te kemuney ini ne midsuhù pà lavew te iketelu ne edsugsuhuen din. Nekeuma maa ini ne midruug dut te pinekamal taman te nengepelian en, ne arà pà ne impeawà dan. ");
INSERT INTO mbi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ne ketà ne migkahi ke kemuney te pemulaan te, ‘Engkey se ed-ul-ulaan ku? Iyan tumù ne iyan ku en edsuhuen ini se tuney en ne anak ku ne igkelimù ku nevenar. Su kenà egkepakey ne kenà dan ini ed-edatan.’ ");
INSERT INTO mbi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ugaid ne guna su nekeuma ini se anak din ne mibpeleglelahey ke menge pinekamal din te, ‘Ini en bes ke anak dut te kemuney kayi te tanà. Kuwa kew en su ed-imetayen tew su apey sikitew en se ebpekegkemuney kayi te tanà.’ ");
INSERT INTO mbi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Arà dà ne migeweran dan ne miguyud dan diyà te luwal dut te pemulaan ne mid-imetayan dan en. “Na,” ke si Hisus, “geina te iring kayi se mid-ulaula ketà te menge etew ne pinekamal te pemulaan, ne engkey se ibped-ulaula kandan dut te kemuney? ");
INSERT INTO mbi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Idtarem ku keniyu te ebeyaan din arà se menge etew ne ebpengimetayan din, ne ebpekemalan din te ruma pà ne menge etew.” Nerineg dut te menge etew ini se migkahi ni Hisus ne ke sikandan te, “Ipekeriyù te Eleteala arà!” ");
INSERT INTO mbi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ne mibpeut-utengan ni Hisus te mata sikandan ne migkahi en te, “Na embiya iring ketà se pegitungan niyu ne engkey ve se ibpesabut kayi te impesurat te Eleteala rengan ne egkahi te, ‘Ke pelaus ne mid-eng-engkeran dut te menge etew ne ebpemevaley su kunaan dan ke warà rantek din ne iyan en iya ini nepemilì ne segkad te valey.’” ");
INSERT INTO mbi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ne migkahi maa si Hisus te, “Ne geina te siaken ini se segkad ne egkerupet ke langun ne egkeulug ketà, ugaid ne egkepipinì ke langun ne egkepilayan din.” ");
INSERT INTO mbi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Edsigkemen perem si Hisus dut te menge meyterù te penduan wey ke menge unuten te terebpelengesa su netuenan dan te sikandan ke nesuhat te sempità din dut te menge etew ne pinekamal te pemulaan. Ugaid ne neandek dan dut te merakel ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Igenat dà ketà ne mibpenipat dan sikandin su ebpemengà dan te kegkesigkem dan ki Hisus. Ne ruen menge etew ne mibpenukayan dan ne ibpesirib ki Hisus ne ebpeinsaen ne engkungkun ne tidtu se insà dan. Ne embiya ruen lalag ni Hisus ne ebpekesurang te penduan ne ibpesigkem dan ne ibehey ran diyà te bayàbayà te gubinedur su ibpekukum en. ");
INSERT INTO mbi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Migkahi ini se menge etew ne edsirib ki Hisus te, “Meyterù, netuenan dey te langun ne egkehiyen nu wey langun ne penurù nu ne metidtu nevenar. Ne warà ebpelebiyen nu ne etew, ugaid ne ebpenurù ka te benar dut te kiyug te Eleteala ne ed-ul-ulaan tew. ");
INSERT INTO mbi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tembù be ruen id-insà dey keykew. Maa ebpekerimpas kiyu ve dut te penduan tew embiya ebayad ki te buwis diyà te ratù tew te inged ne Ruma etawa kenà?” ");
INSERT INTO mbi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ugaid ne netuenan en ni Hisus ke lakew te ked-insà dan su edselingkepen dan dà sikandin ne migkahi en sikandin te, ");
INSERT INTO mbi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Peintenga a niyu kun te pelatà.” Ne mid-insà sikandin te, “Entei ki tuluran kayi? Ne enta ki ngaran kayi?” ");
INSERT INTO mbi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne midtavak dan te, “Tularan wey ngaran dut te ratù tew kayi te inged ne Ruma.” Ne migkehiyen ni Hisus sikandan te, “Embiya iring ketà ne ivehey niyu diyà te datù ayan se bayad te buwis ne kandin, ne ivehey niyu riyà te Eleteala ke endei rema ke kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne warè en iya neselingkep dan kandin ketà te lalag din diyà te etuvangan te merakel ne menge etew. Ketà ne mibpeeneng-eneng dan su negeyip dan dut te tavak din. ");
INSERT INTO mbi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Duen menge etew ne ed-ingaranan te Sedyusiyu ne mibpendiyà te ki Hisus. (Ini se menge Sedyusiyu ke menge etew ne warà mebperetiyaya te egkevanew pà te Eleteala ke menge minatey.) Iyan dan impengkayi te ki Hisus ne ed-insà dan. ");
INSERT INTO mbi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Meyterù,” ke sikandan, “ruen penduan ne insurat ni Moises dengan ne egkahi te, ‘Embiya ruen meama ne ebpatey ne neketahak te esawa rin ugaid ne warà anak dan, ne ebpemeluwen dut te suled din ne meama su apey ruen ded anak dut te minatey ne ebpekesumpat.’ ");
INSERT INTO mbi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Su ruen dengan,” ke sikandan, “pitu ne meama ne telteleari ne mid-esawa en ke kakey, ugaid ne minatey te warà dan med-anak. ");
INSERT INTO mbi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne mibpemalu en dut te nesikupu rin arà se ipag dan, ne minatey red dema te warà dan med-anak. ");
INSERT INTO mbi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ne iring din ded dema ke iketelu. Ne engketà ded ke nesamà, langun dan te pitu ne etew se nekepemalu ketà te ipag dan, ugaid ne warà dan med-anak. ");
INSERT INTO mbi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Netaman ne minatey en ini se meritan. ");
INSERT INTO mbi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ne ini ve se id-insà dey keykew,” ke se menge Sedyusiyu, “embiya benar ne egkevanew red te Eleteala ke menge minatey keuremà, ne entei ve rapit kandan se tehiesawa ketà te meritan? Su langun dan te pitu ne telteleari ne nekedtundug se nekeesawa kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ne migkahi si Hisus kandan te, “Ini se menge etew kayi te ampew te dunya ne ebpees-eseweey. ");
INSERT INTO mbi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ugaid ne ke menge etew ne ebirangan te Eleteala ne dait ne ebenawen ne ebpeubpaen diyà te langit, ne kenà en ebpees-eseweey. ");
INSERT INTO mbi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iyan dan kenà kebpees-eseweey ne iring dan en te suluhuen te Eleteala ne kenè en ebpatey. Menge anak dan en te Eleteala su nevanew ran en. ");
INSERT INTO mbi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ne mekeatag ketà te egkevanew red te Eleteala ke menge minatey,” ke si Hisus, “mepayag en ini ketà te impesurat ni Moises dengan mekeatag te kinepekidlalag te Eleteala kandin diyà ebpuun te neregreg ne sagbet. Su ketà ne nekahi ni Moises te ini se Eleteala ‘ne iyan ded Eleteala ne ebpengerapen ni Abraham, si Isaac wey si Jacob,’ misan ketà ne hewii ne neuhet dan en ne minatey. ");
INSERT INTO mbi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Su ini ne ebpesabut te misan minatey ran en ne biviyag dan pà diyà te etuvangan te Eleteala su iyan dà ebpekepengarap te Eleteala ne biviyag, kenà ke minatey.” ");
INSERT INTO mbi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ne ruen ketà menge meyterù te penduan ne migkahi ki Hisus te, “Benar ayan se migkahi nu, Meyterù.” ");
INSERT INTO mbi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne warà dan en medtikà ne ed-insà pà maa ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ne migkahi si Hisus kandan te, “Meambe ke nekahi ran te ke Mesiyas arà se Impasad te Eleteala rengan ne Ebperetuen te langun ne inenakan sikandin ni David? ");
INSERT INTO mbi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Su riyà te riberù ne ed-ingaranan te Salmo ne si David en iya se edlalag ketà te, ‘Migkahi ke Eleteala ketà te Kerenan ku te: Kayi ka pinuu te rapit te egkekewanan ku ");
INSERT INTO mbi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","taman te ebpenggiekan ku ke menge kunterà nu.’ ");
INSERT INTO mbi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na,” ke si Hisus, “embiya ini ke nekahi ni David te arà se Impasad te Eleteala ne Ebperetuen te langun ne Kerenan din, ne mepmepurù pà sikandin dut te inenakan dà ni David.” ");
INSERT INTO mbi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ebpemineg pà ke merakel ne etew ki Hisus ne migkahi en sikandin kayi te edumdumaan din te, ");
INSERT INTO mbi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Uram kew su apey kenà kew egkepeneheewit dut te menge meyterù te penduan ne ebpengip-ipanew se ebevelegkas te lembung ne sida ne melayat su ebpeadat te menge etew diyà te menge pedian. Ne embiya riyà dan en te valey ne ebpengedian te penduan te menge Hudiyanen ne ebpemilì dan te meupiya ne ebpinuuwan diyà te sineruwan, etawa ke edtelavuk dan te kevurunan ne riyà dan ebpinuu te insivey ne meupiya ne ebpinuuwan te egkeedatan. ");
INSERT INTO mbi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne ebpeey-eyunan dan ke menge kearen dut te menge valu ne meritan, ne ebpeedleyedley ran te kebpengeningeni ran diyà te Eleteala su uvag kun se rekelà se sarig dan te Eleteala. Ugaid ne keuremà ne labi pà ne mekeandek-andek ke ibadas ne kerusaan kandan te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Senge hewii ne riyà si Hisus te Nekebpuru ne Valey te Eleteala, ne nekita rin ke menge etew ne kewasa ne id-ulug dan ini se ibehey ran te Eleteala ketà te edtegtehuan te kureta. ");
INSERT INTO mbi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nekita rin dema ini se senge etew ne balu ne meritan ne ayuayu nevenar ne ed-ulug te deruwa ne tumbaha. ");
INSERT INTO mbi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nekita rin ini ne migkahi en sikandin kayi te menge ruma rin te, “Benar ini se egkehiyen ku keniyu, ini se valu ne meritan diyà te etuvangan te Eleteala ne iyan pà dekelà se imbehey rin dut te langun ne imbehey te menge kewasa. ");
INSERT INTO mbi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Su ke ruma ne menge etew ne iyan dan imbehey ne sawad dà dut te kekewesai ran, ugaid ne ini se ayuayu ne valu ne imbehey rin en te Eleteala ke namànamà ne kureta rin ne edserihan te hinawa rin.” ");
INSERT INTO mbi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Duen menge edumdumaan ni Hisus ne mibpengasak mekeatag te kineup-upiani te ebaal dut te menge kebperasan ne batu kayi te Nekebpuru ne Valey te Eleteala. Ne langun kayi ne mepurù nevenar ne imbehey te menge etew riyà te Eleteala. Nerineg ni Hisus ne migkahi sikandin te, ");
INSERT INTO mbi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Langun kayi te edtengtengan niyu guntaani ne egkereetan. Su ruen gewii ne egkeuma ne ini se edtengtengan niyu guntaani ne egkerundus ne warà misan seveka rà ne batu ne egkesamà kayi te netehuan din su egkevurahey langun.” ");
INSERT INTO mbi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ne mid-insaan dan si Hisus te, “Meyterù, keenu ve ini egketuman se kegkerundus dut te Nekebpuru ne Valey te Eleteala? Ne engkey se idtuus dey su apey rey egketueni te mehaan en ini egketuman?” ");
INSERT INTO mbi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ne migkahi si Hisus te, “Uram kew su apey kenà kew meekali dut te menge etew ne metau ne edliyuk. Su merakel se edlepew ne engkungkun ne siaken en ne egkahi ran te, ‘Siaken en ini ke Impasad te Eleteala ne Ebperetuen te langun!’ Ne egkahi ran te, ‘Ini en ke ketepusan ne hewii,’ ugaid ne kenà kew eduma kandan. ");
INSERT INTO mbi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ne embiya egkerineg niyu se ebpevunbunuey riyà te meriyù merani ne kenà kew meandek. Su ini pà iya ke egkeuna ne egked-ulaula, ugaid ne warà pà meuma ke hewii te kebpupusa kayi te dunya.” ");
INSERT INTO mbi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ne migkahi en si Hisus kandan te, “Ebpemekebunuey pà ke idsenge inged, ne engketà ded dema ke idsenge retuan. ");
INSERT INTO mbi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne edlinug te mevaher, ne ruen mepmepasang ne bitil wey ruen sakit ne ed-eneb kayi te piya endei ne inged. Ne ruen egked-ulaula ne mekeandek nevenar wey ruen dekelà ne tuus ne egkekita niyu riyà te langit ne ebpekeinuinu wey ebpekeandek. ");
INSERT INTO mbi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ugaid ne kayi te kenà pà ini egketuman, ne edsigkemen kew ne edreseyen kew ran. Ne ibpepemenayik kew riyà te baley ne ebpengedian te menge Hudiyanen te penduan dan su egkukumen kew ne ebilengguen kew en. Ne ebpeneheewiten kew riyà te menge harì wey riyà te egkeunutan te inged su atag dut te kedsarig niyu kediey. ");
INSERT INTO mbi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ugaid ne ini en imbe ke ralan te kebpekepesabut niyu kandan dut te Meupiya ne Tudtul mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Es-eseka niyu neraan ke hinawa niyu ne kenà kew egkeuru ke engkey se idtavak niyu kandan. ");
INSERT INTO mbi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Su siaken dà se ebpekahi keniyu ne ebehayan ku sikiyu te ketampas te itungan su apey ke menge kunterà niyu ne kenà ebpeketavak ne kenà dan egkeliyu ke benar ne egkelalag niyu. ");
INSERT INTO mbi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne misan ke lukes niyu, ke temperà niyu te bituka, ke menge suled niyu wey ke menge sepakat niyu ne ebpulid keniyu riyà te egawed te kukuman, ne ruen en ebpeimetayan kayi te sikiyu. ");
INSERT INTO mbi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Egkunteraan kew dut te langun su atag te edumdumaan ku sikiyu. ");
INSERT INTO mbi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ugaid ne warà egkeawà misan seveka ne bulvul nu ne iyan din meana ne misan ed-imatayan kew ne kenà kew ran en egkesikep diyà te palad te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Itindehi niyu ve te mevaher ke sarig niyu kediey su kayi kew ve ebpekeangkun te umur ne kenà edtaman.” ");
INSERT INTO mbi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ne migkahi en maa si Hisus te, “Embiya egkekita niyu en ini se inged ne Hirusalim ne edtelikupan en te kunterà niyu ne sundaru ne kenà kew en duwaruwa te mehaan en se kegkereeti rin. ");
INSERT INTO mbi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na ke menge etew kayi te pruvinsiya te Hudiya ne mebpelahuy en diyà te buvungan. Ne ke menge etew kayi te Hirusalim ne mebpelahuy dema. Ne ke menge etew ne kayi te nekeerivey ne inged ne kenà dan en iya mebpengkayi te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Su arà en ke hewii ne edusaan te Eleteala ke menge etew ne egkunterà kandin, ne langun te nekahi rin kayi te impesurat ne Lalag te Eleteala rengan ne egketuman en. ");
INSERT INTO mbi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Egkeyruwan ke menge meritan ne mehingey te arà ne hewii wey ke menge meritan ne edseruru. Su ruen kemeresayan ne ebpekedabak kayi ne inged, ne ed-isuhaten en te Eleteala te kegkeepes din ke menge Hudiyanen ne egkunterà kandin. ");
INSERT INTO mbi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Duen kayi te sikandan ebpenundangen, ne ruen ebpembiyahen ne ed-ewiten diyà te langun ne menge inged kayi te ampew te dunya. Ne ini se inged ne Hirusalim ne edtekutaken te menge etew ne kenà Hudiyanen taman te idtuhut pà kandan te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ne migkahi en maa si Hisus te, “Duen egkekita niyu riyà te andew, bulan, wey bituen ne menge tuus. Ne kayi te ampew te dunya ne egkekiyab se atey te menge etew rut te egkerineg dan ke ebpekesahad ne egkenegkeneg ne rahat wey ke ebpeteltelukuney ne baleg. ");
INSERT INTO mbi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ebpengevidtawan ke menge etew te andek dan su egkeuru ran ke engkey se egketemanan dan. Su langun te netehuan te edtenuran diyà te langit ne egkeparin. ");
INSERT INTO mbi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ne ketà ne egkekita ran ke kedlived, te Impeanak te Menusiya, su eduma dut te sehulapun. Ne egkekita ran ke gehem din wey ke ed-andlag ne raman din. ");
INSERT INTO mbi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Embiya edrudsùrudsù en ini se migkahi ku te kegketuman din ne kenà kew kelugkai ugaid ne kehalew kew su mehaan kew en ebpekeliyu.” ");
INSERT INTO mbi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne mibpenempità si Hisus kandan te, “Keniyan niyu rè ma te kayu ne igira wey ruma pà ne menge kayu. ");
INSERT INTO mbi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Embiya egkekita niyu ne nekepasad en te edrewrew wey ebpeneringsing en, ne tuus te ed-andew en. ");
INSERT INTO mbi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ne iring din ded dema embiya egkekita niyu en se netuman en ke langun ne tuus ne intarem ku keniyu, ne egketuenan niyu te mehaan en ke Kedatù te Eleteala te menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tentenuri niyu ini se egkehiyen ku keniyu su ruen pà kayi te keniyu guntaani ebpekesaut pà ketà te kegketuman din ini. ");
INSERT INTO mbi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Su egkeawà ini se langit wey tanà, ugaid ne ini se migkahi ku ne kenà bulug ebperis.” ");
INSERT INTO mbi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ne migkahi en maa si Hisus te, “Uram kew ve su apey kenà kew kayi rà egketaman te kebpengevurunan, ebpenginum te ebpeketevereg, wey ke kegkeuru niyu te ked-ubpàubpà niyu. Su embiya kenà kew ed-uram ne egkesaut kew te hewii ne kegkukum te Eleteala te menusiyà ne iring kew te rumat ne egketelebpì. ");
INSERT INTO mbi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Su iring te telivekasen se kehaan din te kebpekeuma ketà kayi te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tembù be,” ke si Hisus, “pekevantey kew nevenar ne layun kew pengeningeni su apey kew ebehera te Eleteala te ked-etuvang niyu kayi te langun ne egketemanan. Pengeningeni kew su apey warà igkeyeyai niyu ketà te ked-itindeg niyu kayi te etuvangan ku, ke Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uman gewii ne mibpenurù si Hisus diyà te Nekebpuru ne Valey te Eleteala, ne uman merukilem ne mibpendiyà sikandin te buvungan ne ed-ingaranan te Ulivuwen su riyà ed-ubpà. ");
INSERT INTO mbi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne mibpaneypaney ke menge etew ne ebpendiyà te Nekebpuru ne Valey te Eleteala su ebpemineg te penurù din. ");
INSERT INTO mbi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mehaan en egkeuma arà se hewii te kevurunan ne edtenuran dut te menge Hudiyanen ne ed-ingaranan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ne ebpemengà ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan te ralan te kedsigkem dan ki Hisus te kenà egketuenan te menge etew su egkeandek dan te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ne ketà ne mid-awuk en si Setanas ke datù te pekaid ki Hudas, ini se ed-ingaranan dema te Iskeriyuti ne senge etew sikandin dut te sepulù wey deruwa ne edumdumaan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne midlihawang sikandin se ebpendiyà te menge mepurù te terebpelengesa wey ke menge kepitan dut te ebantey te Nekebpuru ne Valey te Eleteala su ebpekidsabut kandan ke memenu se kebpulid din ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ne nengesuatsuat dan nevenar, ne impasad dan kandin te ebehayan te pirak. ");
INSERT INTO mbi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ne migkiyug en si Hudas ne in-awà dà ketà ne ebpemengaan din en ke ralan te kegkeulug din ki Hisus su apey mesigkem dan en te kenà egketuenan dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Neuma en ke hewii rut te kevurunan dan te Pista te Kegkaan dan te Pan ne Warà Insawug ne Ibpelevag. Ne ini se neuna ne hewii ne idsumbalì te menge Hudiyanen te ibpelengesa ran ne nati ne bilibili ne egkeenen dan te kedtenuri ran dut te hewii rengan te kedsehari te menge apù dan dut te suluhuen te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ne midsuhuen ni Hisus si Pedro wey si Juan ne migkehiyan din sikandan te, “Una kew en be ne pegatur kew en te Kedlavung tew te Pista te Kedsehari te Suluhuen.” ");
INSERT INTO mbi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne mid-insà dan ki Hisus te, “Endei rey ve ini ebpegetura?” ");
INSERT INTO mbi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne migkahi si Hisus te, “Embiya ebpekeuma kew en diyà te inged ne ruen meama ne ed-utuk te kelalew ne ruen wayig din ne edsinuhung keniyu. Tundug kew en be kandin, ne embiya ebpekeuma kew riyà te ed-ubpaan din, ");
INSERT INTO mbi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ne kehiyi niyu ve ke kemuney te valey te, ‘Ibpeinsà rut te meyterù tew te: Endei ne ruhu ke edlevungan ku wey ke menge edumdumaan ku dut te Pista te Kedsehari te Suluhuen?’ ");
INSERT INTO mbi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne ketà ne ibpekita rin keniyu ke meluag ne ruhu diyà te ikeruwa ne pangkat ne saag ne pegediran en, ne ketà kew be pegatur te idlavung tew.” ");
INSERT INTO mbi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mid-ipanew ran ne nekeuma ran ketà te inged ne langun dut te ingkahi kandan ni Hisus ne arà en iya rema se nekita ran. Ne ketà dan en mibpegatur te idlavung dan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Guna su arà en ke kedlavung dan ne mibpinuu si Hisus wey ke menge edumdumaan din ne ed-ingaranan te apustulis su egkaan. ");
INSERT INTO mbi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne migkahi si Hisus te, “Dekelà te hinawa ku se egkeseveka kiyu se egkaan te ini ne Pista te Kedsehari te Suluhuen te kenà e pà ebpatey. ");
INSERT INTO mbi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Su ini se idtarem ku keniyu te egkepasad ini ne kenà ad maa egkaan te Pista te Kedsehari te Suluhuen taman te egketuman en ke tidtu ne pista ketà te menge etew ne Edetuan te Eleteala keuremà.” ");
INSERT INTO mbi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne ketà ne migkuwa ni Hisus ke ed-inumen ne impeselamat din te Eleteala ne migkahi sikandin te, “Pesemsemeey kew ve se ed-inum kayi. ");
INSERT INTO mbi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Su idtarem ku keniyu te kenà ad maa ed-inum kayi te ed-inumen ini taman te kenà egkeuma ke hewii keuremà te Kedetui te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne migkuwa rin ke egkeenen dan ne pan ne impeselamat din te Eleteala, ne mibpenevìtevì din ne imbehey rin diyà te menge edumdumaan din se egkahi te, “Ini ke lawa ku ne ibeliwas keniyu. Ul-ulaa niyu ini su apey a niyu egkepegpegitung.” ");
INSERT INTO mbi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Guna su nekeipus dan se edlavung ne migkuwa maa ni Hisus ke ed-inumen se egkahi te, “Ini se lengesa ku ne ebpeketudà ne ibavas te langun ne menge etew, su tuus ini te egketuman en ke impasad te Eleteala rengan te ebpekepelihaun en ke langun ne menge etew te keberedusaan dan. ");
INSERT INTO mbi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ugaid ne kegketueni niyu te sikandin ini se ed-ulug kediey ne kayi red te sikitew ini ne mibpinuu. ");
INSERT INTO mbi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Su ed-imetayan ke Impeanak te Menusiyà su rengan ne intandà te Eleteala ini, ugaid ne mekeyruwiru arà se etew ne ed-ulug kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ne ketà ne mibpein-inseey ke menge edumdumaan din ke endei rapit buwa kandan se ed-ulaula kayi te migkahi rin. ");
INSERT INTO mbi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne mibpelewlewaney ke menge edumdumaan ni Hisus ke engkey kandan se mepurù te langun. ");
INSERT INTO mbi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Migkahi si Hisus kandan te, “Kayi te ampew te dunya ini se menge pengulu te inged ne metehel ne edsuhù te menge sakup dan, ne ini se menge unuten ne egkiyug ne egelalan te sikandan ke Ebpesineruwan te Menge Etew. ");
INSERT INTO mbi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ugaid ne kenà kew ed-iring ketà, su embiya ruen seveka keniyu ne egkiyug ne ebmepurù ne iyan din kemeyidan ne mebpeembavà te hinawa rin iring te ineriyan en. Ne embiya ruen egkiyug ne egkeunutan ne medlila te hinawa rin te edsugsuhuen te menge ruma rin. ");
INSERT INTO mbi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Maa entei se mepurù,” ke si Hisus, “ke etew ne edsendaran su egkaan etawa ke etew ne edsendad kandin? Idtarem ku keniyu te arà se midsendaran. Ugaid ne misan siaken se edlingekaan niyu ne gewii ku te kayi te keniyu ne iring te siaken se edsugsuhuen niyu.” ");
INSERT INTO mbi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ne migkahi si Hisus te, “Langun te kemerehenan ku ne mid-unung kew kedì. ");
INSERT INTO mbi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mibehayan a te Amey ku ne Eleteala te kewagib te edatù, ne engketà ded ebehayan ku rema sikiyu te kewagib te kedatù. ");
INSERT INTO mbi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Keuremà te Kedatù ku ne ketà kew ebpinuu te uvey ku su edseveka kiyu egkaan wey ed-inum. Ne ebpepinuuwan ku sikiyu se edatù dut te sepulù wey deruwa ne bansa ne inenakan ni Israyil.” ");
INSERT INTO mbi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Migkahi si Hisus kayi te ki Simon Pedro te, “E, Simon, duen idtarem ku keykew. Midtuhutan te Eleteala si Setanas ke datù te pekaid su ebpenggeraman kew ke embiya ebpekedsalà kew. Ini se kebpenggeram din ne iring te ed-ukapan din ke sarig nu. ");
INSERT INTO mbi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ugaid ne impengeningeni ku en sikuna, Simon, su apey kenà egkeawà ke sarig nu kediey. Ibparew a nikuna, ugaid embiya ebpekeulit en ke sarig nu kediey ne behera nu ke sarig te menge ruma nu.” ");
INSERT INTO mbi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ne migkahi si Pedro te, “Kenà a ebpitas kenikew, Kerenan, misan egkevilanggù ka ne ketà ad dema. Embiya ebpatey ka ne ebpekid-unung a kenikew.” ");
INSERT INTO mbi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ne migkahi si Hisus te, “Tentenuri nu ini, Pedro, te kenà pà ed-ukarà ke manuk te ini en ne kerukileman, ne ketetelu a nu en ibparew te kenà a nu ruma.” ");
INSERT INTO mbi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne migkahi maa si Hisus kandan te, “Ketà te kinesuhù ku keniyu rut te kengkeniyà ne indawey ku keniyu se ed-ewit te kureta, kempiru etawa telumpà, ne maa ruen be nepemengà niyu?” Ne migkahi ran te, “Warà.” ");
INSERT INTO mbi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ne migkahi si Hisus te, “Ugaid ne guntaani ne embiya ruen kureta etawa kempiru niyu ne ewita niyu en te ked-ipanew niyu. Ne ke etew ne warà sundang din ne pesaa rin en ke kumbalà din ne mebpemasa te seveka. ");
INSERT INTO mbi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Su igkahi ku keniyu ne arà se impesurat ne Lalag te Eleteala mekeatag kediey ne iyan iya se metuman en. Su ruen nekahi ketà mekeatag kediey te, ‘Inragkes sikandin te menge etew ne belisalà’ ne ke kegketuman din ini ne mehaan en egkeuma.” ");
INSERT INTO mbi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ne migkahi ke menge edumdumaan din te, “Intengi nu ma, Meyterù, su duen en deruwa ne sundang dey.” “Sesangen en ayan,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Midlihawang en si Hisus ketà te valey ne midlevungan dan ne mibpendiyà maa sikandin te buvungan ne ed-ingaranan te Ulivuwen su arà ke andang ne ebpesineruwan din. Ne miduma kandin ke menge edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nekeuma ran ketà ne migkehiyan din sikandan te, “Pengeningeni kew su apey kenà kew mepeneheewit dut te ebpenggeram keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mid-ewaan ni Hisus sikandan te egkeuma red te edtimbag, ne mibpenimbuel sikandin se ebpengeningeni te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ke sikandin te, “Amà, netuenan ku te egkegaga nu ke langun! Ne embiya egkiyug ke rà ne iawà nu ini se keresayan ku, ugaid ne misan be engketà ke kiyug ku ne ipelevundus nu se keykew ne kiyug.” ");
INSERT INTO mbi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gewii rin te ebpengeningeni ne ruen suluhuen te Eleteala ne riyà ebpuun te langit ne mibpengkayi te kandin su ebaher te hinawa rin. ");
INSERT INTO mbi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne gaina te nepenù en si Hisus te kemutuwan ne mid-ilut pà se kebpengeningeni rin te Eleteala, ne ketà ne edtehaktak diyà te tanà ke rimuseng din ne iring en te lengesa. ");
INSERT INTO mbi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mid-itindeg sikandin ketà te ebpengeningeniyan din ne midliveran din ke menge edumdumaan din, ne neumaan din ne nekelipereng dan su neewaan dan te baher dut te kemutuwan dan. ");
INSERT INTO mbi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Migkahi en si Hisus kandan te, “Meambe ke edlipereng kew? Enew kew ne pengeningeni kew te Eleteala su apey kew kenà mepeneheewit dut te ebpenggeram keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gewii te edlalag pà si Hisus ne nekeuma en se merakel ne etew. Ne si Hudas ke senge etew rut te sepulù wey deruwa ne edumdumaan din ne iyan en iya ebpengunaan kandan. Mid-uvey rin si Hisus su ed-erekan din. ");
INSERT INTO mbi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ugaid ne migkahi si Hisus kandin te, “Maa, Hudas, ini embe se ked-arek nu kayi te Impeanak te Menusiyà se ked-ulug nu en kandin keniyan te menge ruma nu?” ");
INSERT INTO mbi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nekita rà kayi te menge edumdumaan ni Hisus se iring bes kayi ne migkahi ran te, “Menu, Meyterù, edtibas key en su sundang ded ini?” ");
INSERT INTO mbi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne senge etew kandan se mid-ulavut din se sundang din ne midtibas din en ke edsugsuhuen dut te pinekebmepurù te terebpelengesa ne nesamping en ke kewanan ne telinga rin. ");
INSERT INTO mbi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne ketà ne migkahi si Hisus te, “Suhati nu en!” Ne in-ulit ni Hisus ke telinga rut te edsugsuhuen ne neulian en. ");
INSERT INTO mbi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne migkehiyan ni Hisus ke menge etew ne edsigkem kandin, ini se menge mepurù te terebpelengesa, ke menge kepitan te ebantey rut te Nekebpuru ne Valey te Eleteala, wey ke menge egkeunutan te menge Hudiyanen, ke sikandin te, “Maa, tulisan a ne ebmetereman niyu te sundang wey behuval te kedsigkem kediey? ");
INSERT INTO mbi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Su uman gewii ne diyan a te Nekebpuru ne Valey te Eleteala se ebpenurù, ne warà e ma nikiyu sigkema ketà. Ugaid ne keniyu en ini ne hewii te kedsigkem kediey, ne ebpepayag en ke kevaher ni Setanas ke datù te pekaid se ebayàbayà keniyu.” ");
INSERT INTO mbi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ne ketà ne midsigkem dan si Hisus ne mibpeneheewit dan en diyà te baley te pinekemepurù dut te menge terebpelengesa. Ne midtundugtundug en dema si Pedro. ");
INSERT INTO mbi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nekeuma ran ne ketà te lama ne ruen midtetemeg te apuy ne mibpinuu ran se ed-inarang. Ne mibpekid-amur en si Pedro kandan. ");
INSERT INTO mbi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ne ruen ketà senge etew ne raha ne edsugsuhuen ne nekekita ki Pedro te nesilaan te rayag dut te apuy. Midtengtengan din si Pedro ne migkahi en te, “Ini ne meama ne ruma red ketà te midsigkem dan.” ");
INSERT INTO mbi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ugaid ne mibparew si Pedro se egkahi te, “E, Bayi, kenà ku egketuenan ke entei sikandin.” ");
INSERT INTO mbi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Neiseg-iseg ne ruen en maa senge etew ne nekekita ki Pedro ne migkahi te, “Benar iya ne ruma ke red ketà te nesigkem.” Ne migkahi si Pedro te, “E Mama, kenà.” ");
INSERT INTO mbi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ne neiseg-iseg maan ne ruen maa senge etew ne nekekita ki Pedro ne migkahi te, “Benar iya ne ruma red sikandin ketà te nesigkem su riyà ebpuun sikandin te Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne migkahi si Pedro te, “E, Mama, kenà ku egkesebutan ayan se egkehiyen nu.” Arà dà ne gewii te edlalag pà si Pedro ne mid-ukarà en ke manuk. ");
INSERT INTO mbi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ketà ne midlilingey ni Hisus si Pedro. Ne arà pà ne netenuran ni Pedro ke migkahi ni Hisus kandin te, “Kenà pà ed-ukarà ke manuk guntaani te ini en ne kerukileman ne ketetelu a nu en ibparew te kenà a nu ruma.” ");
INSERT INTO mbi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ne midlihawang si Pedro ne midrahukrahuk en te kedsinehew rin. ");
INSERT INTO mbi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ne mid-undaunda en wey mibedasan si Hisus dut te menge etew ne mibantey kandin. ");
INSERT INTO mbi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne mibegkesan dan ke mata rin ne migkahi ran te, “Entuka nu ke enta se mibadas keykew.” ");
INSERT INTO mbi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne merakel pà se kinepegkeyà dan ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Guna su mesmeselem pà ne langun dut te egkeunutan te menge Hudiyanen, ke menge mepurù te terebpelengesa, wey ke menge meyterù te penduan ne impeetuvang dan en si Hisus su sikandan ke egkukum. ");
INSERT INTO mbi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Embiya sikuna ke Anak te Eleteala,” ke sikandan, “ne Impasad din ne Ebperetuen din ne kehiya nu kenami.” Ne migkahi si Hisus te, “Misan egkehiyen ku keniyu ne kenà kew ebperetiyaya kediey. ");
INSERT INTO mbi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne misan duen id-insà ku keniyu ne kenà kew rema edtavak. ");
INSERT INTO mbi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ugaid ne igkahi ku keniyu te mehaan en egketuman ke hewii ne ebpekepinuu en ke Impeanak te Menusiyà diyà te rapit te egkekewanan te Eleteala ne warà repeng te gehem din.” ");
INSERT INTO mbi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne langun dan ne migkahi te, “Embiya ves arà se kahi nu, ne maa sikuna en iya ini ke Anak te Eleteala ne Impasad din ne Ebperetuen din?” Ne midtavak si Hisus te, “Uya, siaken en iya.” ");
INSERT INTO mbi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne migkahi ran te, “Kenà ki en ebpemengà te ruma pà ne titihus su nerineg tew en ayan se lalag din ne mibpevayà te bèbà din.” ");
INSERT INTO mbi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ketà ne langun ne menge etew ne mibpengukum ki Hisus se mid-ewit kandin diyà te gubinedur ne si Pilatu su apey rin mepasad en ke kukuman. ");
INSERT INTO mbi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nekeuma ran ne imperineg dan ki Pilatu ke id-isuhat dan kandin se egkahi te, “Nesepenan dey ini se meama ne ebpesuwey rut te menge etew kayi te inged tew su impeengked din ke menge etew ne ebayad te buwis diyà te mepurù tew ne si Cesar. Ne migkahi rin te sikandin kun ke midtendù te Eleteala ne ebperetuen.” ");
INSERT INTO mbi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne mid-insaan ni Pilatu si Hisus te, “Menu sikuna en iya ke ratù te menge Hudiyanen?” Ne midtavak si Hisus te, “Uya, ayan iya se migkahi nu.” ");
INSERT INTO mbi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne migkahi si Pilatu riyà te menge mepurù te terebpelengesa wey ke merakel ne menge etew ne nevurun ketà, ke sikandin te, “Warà netuen ku ne salà ne id-isuhat ku kayi te etew ini.” ");
INSERT INTO mbi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ugaid ne nasì dan en ne mibpemensag se egkahi te, “Ini se menge penurù din se puunan te ebpeetuwen din ke menge etew ketà te mepurù tew. Midrudsù se kebpenurù din diyà te lusud te Geliliya ne neeneb din ke menge inged diyà te lusud te Hudiya taman te ini en te Hirusalim.” ");
INSERT INTO mbi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nerineg ni Pilatu ini ne mid-insà sikandin te, “Meambe, etew ves ini te Geliliya?” ");
INSERT INTO mbi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Uya,” ke sikandan, “etew ayan te Geliliya.” Guna su netuenan ni Pilatu te riyà bes ne etew si Hisus te Geliliya ne inged ne egkemalan ni Hirudis, ne impependiyà din si Hisus te ki Hirudis. Su seretà din ketà ne kayi rema si Hirudis te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nekita ni Hirudis si Hisus ne nesuatsuat sikandin su neuhet en ne ed-ing-ingitaen din si Hisus. Su uman din dà egkerineg ke mekegeyip ne ed-ul-ulaan ni Hisus, ne ed-inteng dema perem sikandin. ");
INSERT INTO mbi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ketà be ne mibpenginsaan ni Hirudis si Hisus, ugaid ne warà midtavak si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nekeipus sikandin ne mid-uvey ke menge mepurù te terebpelengesa wey ke menge meyterù te penduan ne mid-uluhan dan nevenar si Hisus te kewagib. ");
INSERT INTO mbi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ne mid-undaunda ni Hirudis wey ke menge sundaru rin si Hisus ne pinegkeyà dan. Ne pinelelembung dan te velegkas te datù su uvag kun ne ratù ne impelived dan en maa riyà te ki Pilatu. ");
INSERT INTO mbi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ne arà ne andew ne neked-upiyaney en si Pilatu wey si Hirudis su pehaney ne telegkunterà dan. ");
INSERT INTO mbi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Guna su kayi en maa si Hisus te ki Pilatu ne miburun ni Pilatu ke menge mepurù te terebpelengesa, ke menge egkeunutan wey ke merakel ne etew. ");
INSERT INTO mbi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne migkehiyan din sikandan te, “Mid-ewit niyu ini se etew kayi te kedì ne egkehiyen niyu ne ebpeatu sikandin kayi te menge etew rut te mepurù tew. Ugaid ne mid-insaan ku en sikandin kayi te etuvangan niyu ne warà netuen ku ne salà din iring dut te idwagib niyu. ");
INSERT INTO mbi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Engketà ded dema si Hirudis, warà dema netuen din su tembù impelived din ded kayi te kenitew. Warà salà kayi te etew ini ne rait ne id-imetayi kandin. ");
INSERT INTO mbi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ugaid ne ibpelambit ku rà sikandin ne ibpelihawang ku en.” ( ");
INSERT INTO mbi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iyan kinekahi ni Pilatu kayi su ruen betasan din te embiya egkeuma ke kevurunan te Pista te Kedsehari te Suluhuen ne ruen ibpelihawang din ne senge etew ne bilanggù ne ebuyuen te menge etew.) ");
INSERT INTO mbi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nerineg dut te menge etew ini se migkahi ni Pilatu ne nasì dan ne mibpemensag se egkahi te, “Peimatayi nu ayan ne etew! Ne ipelihawang nu kayi te kenami si Barabas!” ");
INSERT INTO mbi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Si Barabas ini ne nevilanggù su mid-amung sikandin te ebpekidkunterà te gubirnu ne ruen nepatey rin.) ");
INSERT INTO mbi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Duen kiyug ni Pilatu te iyan ibpelihawang ne si Hisus ne ketà ne mid-insà maa sikandin dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ugaid ne mibpememensag se egkahi te, “Ipelansang nu! Ipelansang nu riyà te ebpebelevahen ne kayu!” ");
INSERT INTO mbi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne migkahi en maa si Pilatu te iketelu en te, “Meambe? Engkey se meraat ne mid-ulaula rin? Su warà netuen ku ne salà din ne dait ne id-imetayi kandin. Ibpelambit ku rà sikandin ne ibpelihawang ku en.” ");
INSERT INTO mbi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ugaid ne mid-ilut dan pà se ebpememensag se egkahi te ebpeimetayan sikandin, ne warè en mekeehen si Pilatu. ");
INSERT INTO mbi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Geina te mibpulung dan mibpememensag ne imbehey en ni Pilatu ke kiyug dan. ");
INSERT INTO mbi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Impelihawang en ni Pilatu si Barabas, ini se etew ne nevilanggù su mid-amung te ebpekidkunterà te gubirnu wey ruen nepatey rin. Ugaid ne si Hisus ne impalad en ni Pilatu diyà te kandan te misan ebmenumenuwen dan. ");
INSERT INTO mbi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ne ketà ne mibpeneheewit dan en si Hisus diyà te ed-imetayan dan kandin. Ne gewii ran te ed-ipanew ne ruen etew ne nesinuhung dan ne iyan pà ebpekeuma ne riyà ebpuun te taneb, ne mibpehes dan te ebpetiang ke pinebelavag ne kayu ne edtiangen ni Hisus. Etew ini ne ed-ingaranan ki Simon riyà ebpuun te inged ne Sirin. ");
INSERT INTO mbi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne denda ne menge etew se miduma ki Hisus abpeg ke menge meritan ne ebpeninehew su ebpenderawit dan en kandin. ");
INSERT INTO mbi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne midlilingey si Hisus kandan ne migkahi en te, “Sikiyu ne menge meritan kayi te Hirusalim, kenà a niyu sinehewi, ugaid ne iyan niyu sinehewi ke egketemanan niyu wey ke menge anak niyu. ");
INSERT INTO mbi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Su ruen hewii ne egkeuma,” ke si Hisus, “ne egkahi ke menge etew te, ‘Meupiya ke meritan ne kenà ed-anak, ke meritan ne warà med-anak, wey ke meritan ne wara edseruruwen din!’ ");
INSERT INTO mbi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Egkeuma arà se hewii ne egkehiyan te menge etew ayan se buvungan te, ‘Ketempahi key en ne buvungan!’ wey egkahi ran keniyan te menge tuhar te, ‘Kevunbuni key en ne tuhar.’ ");
INSERT INTO mbi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Su,” ke si Hisus, “embiya ini se ibped-ulaula ran kedì te iring te kayu ne meilew pà su warà salà ku, ne tuwas pà imbe ke ibped-ulaula ran keniyu te sikiyu ne iring te kayu ne nehangu.” ");
INSERT INTO mbi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ne ruen dema mid-ewit dan ne deruwa ne etew ne tulisan su ibperuma ki Hisus te ed-imetayan. ");
INSERT INTO mbi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nekeuma ran ketà te rapit ne ed-ingaranan te “Tulan te ulu” ne inlansang dan en si Hisus diyà te pinebelavag ne kayu ne inlansang ded dema ini se deruwa ne tulisan, seveka kayi te egkekewanan ni Hisus ne seveka kayi te egkehivang din. ");
INSERT INTO mbi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gewii ran te edlansang kandin ne mibpengeningeni si Hisus te, “Amà, pesehara nu sikandan su warà dan metueni ini se ed-ul-ulaan dan.” Ne ketà ne ini se menge sundaru ne midlansang kandin ne mibunutbunutan dan se velegkas ni Hisus ke entei se ebpekegkemuney kandan. ");
INSERT INTO mbi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ke denda ne etew ne mid-itindeg ketà se edtengteng, ne ini se menge egkeunutan te Hudiyanen ne mid-undaunda ki Hisus, ke sikandan te, “Nekepelihaun sikandin te menge ruma rin. Ne intengan tew ve ke igkepelihaun din ke hinawa rin embiya benar ne sikandin en ke midtendù te Eleteala ne ebperetuen ne ed-ingaranan te Mesiyas.” ");
INSERT INTO mbi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ne mid-amung ke menge sundaru mid-undaunda kandin. Mid-uvey ran si Hisus ne pineinum dan te daan en ne tebà. ");
INSERT INTO mbi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne migkahi ran te, “Embiya sikuna en ke ratù dut te menge Hudiyanen ne ibpeliyu nu ke hinawa nu.” ");
INSERT INTO mbi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne ruen surat ne riyà dan intahù te divavew te ulu rin ne egkahi te, “Ini ke Ratù te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ne senge etew rut te imbitin ne tulisan ketà se mid-undunda ki Hisus se egkahi te, “Menu, kenà sikuna ke Impasad te Eleteala ne Ebperetuen? Ipeliyu nu ke hinawa nu wey sikami rema.” ");
INSERT INTO mbi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ugaid ne midawey sikandin dut te ruma rin se egkahi te, “Engkey ka ini? Maa, kenà ke ves egkeandek te Eleteala te langun tew ini te tetelu ne ebpedulung en te kepepatey? ");
INSERT INTO mbi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dait ta ini te deruwa se ed-imetayen su id-ulì dà keyta ke kereatey te ulaula ta. Ugaid ne ini se etew ne egkeimetayan te warè en iya meraat ne ulaula rin.” ");
INSERT INTO mbi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne migkahi sikandin kayi te ki Hisus te, “E, Hisus, tentenuri a nu rà ketà te Edetuan nu keuremà.” ");
INSERT INTO mbi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ne migkahi si Hisus kandin te, “Igkahi ku kenikew te ini en ne andew ne ebpekeruma ka kedì riyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Neudtu en ini ke andew ne midtekew mibmerusirem ketà te langun ne inged taman te edluuk en ebpemenaug ke andew su midlekep. ");
INSERT INTO mbi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ne riyà te Nekebpuru ne Valey te Eleteala ne newaswas kayi te luuk ini se mekepal ne saput ne impehelet dut te insivey ne ruhu te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ne ketà ne migkulayì si Hisus se egkahi te, “Amà, ebpeheweran ku kenikew ke gimukud ku.” Nelalag din dà ini ne nependusan en sikandin te hinawa. ");
INSERT INTO mbi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nekita rut te kepitan te menge sundaru ne ini se ned-ulaula ne nekereyù sikandin te Eleteala se egkahi te, “Benar ves iya ne metidtu ini ne etew.” ");
INSERT INTO mbi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne langun kayi te menge etew ne nevurun ketà su edtengteng, ne nekekita kayi te ned-ulaula ne mid-ulì dan se ebpenempak te kumeng dan su dekelà se kemutuwan dan. ");
INSERT INTO mbi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Langun ne edkekilala ni Hisus abpeg ke menge meritan ne miduma kandin igenat te Geliliya ne mid-it-itindeg diyà te malù meriyù se edtengteng kayi te langun ne ned-ulaula. ");
INSERT INTO mbi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Duen senge etew ketà ne ed-ingaranan ki Jose ne riyà ebpuun te inged ne Eremetiya lusud te Hudiya. Meupiya ne etew sikandin wey metidtu se ulaula rin. Senge etew sikandin dut te menge Hudiyanen ne edtahad dut te kebpekeuma te Edetuan te Eleteala kayi te ampew te dunya. Senge etew rema sikandin dut te menge egkeunutan te Hudiyanen te Perekukum, ugaid ne warà meeyuni sikandin dut te kineimasad en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mibpendiyà si Jose ini te ki Pilatu su ebuyuen din ke lawa ni Hisus ne inluhut dema ni Pilatu. ");
INSERT INTO mbi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ne mibperus en ni Jose ke lawa ni Hisus ne mibukusan din en te meputì ne saput. Ne inleveng din en ketà te imbangbang ne leveng diyà te dempilas ne warà pà melevengi te minatey. ");
INSERT INTO mbi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Meapun en ini te Diyemaat ne edsanlep ke andew ne ini se rudsuan te Hewii ran te Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ke menge meritan ne miduma ki Hisus igenat diyà te Geliliya ne miduma ki Jose te edleveng, ne nekita ran ke midlevengan wey ke kinetahù en ki Hisus diyà te leveng din. ");
INSERT INTO mbi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ne mid-ulì dan en ne mibpenehana ran ke meemut ne menge rawun wey periyemut su idsapu te lawa ni Hisus. Ne ketà te midrudsù ke Hewii te Id-imeley ran ne mid-imeley ran en su edtuman dan dut te insuhù te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mesmeselem pà te hewii ne Akad ne mibpendiyà ke menge meritan te leveng ni Hisus ne imbangbang diyà te dempilas ne mid-ewit dan ke menge meemut ne idsapu ne mibpenehana ran. ");
INSERT INTO mbi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nekeuma ran ne nekita ran te nelilid en ke vatu ketà. ");
INSERT INTO mbi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mid-awuk dan ne mibpenlangulangu ran, ugaid ne warà dan mekita ke lawa ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Gewii ran te ed-it-itindeg ketà se neliveg, ne neketekew en nekeitindeg se deruwa ne meama ne ebpeneringsing se velegkas dan. ");
INSERT INTO mbi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ne nekelumpeng ke menge meritan te kegkeandek dan. Ne migkahi ini se deruwa ne meama te, “Meambe ke ebpemengaan niyu kayi te edlevengan te minatey arà se etew ne biviyag? ");
INSERT INTO mbi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Warà en sikandin kayi su nevanew en. Tentenuri niyu rè ma ke migkahi rin keniyu rut te riyà kew pà te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Su migkahi rin te ibpalad ke Impeanak te Menusiyà diyà te kebayàbayà te menge etew ne mekesesalà ne idlansang dan sikandin, ugaid ne ketà te iketelu ne hewii ne egkevanew en.” ");
INSERT INTO mbi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne arà pà ne netenuran dan ke migkahi ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mid-ulì dan ne mibpenudtulan dan ke sepulù wey seveka ne edumdumaan ni Hisus wey ke menge ruma pà ketà. ");
INSERT INTO mbi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ini ke menge meritan ne mibpenudtul te lalag te suluhuen: Si Maria ne riyà ebpuun te Magdala, si Juana, si Maria ne iney ni Santiago, wey ruen pà menge ruma ran. Sikandan be ini ke mibpenudtul dut te menge edumdumaan ni Hisus ne ed-ingaranan te Apustulis. ");
INSERT INTO mbi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ugaid ne warà mibperetiyaya ke menge edumdumaan ni Hisus dut te tudtul te menge meritan su iyan dan kunaan ke menge kesembaran dà. ");
INSERT INTO mbi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ugaid ne mid-itindeg si Pedro ne mibpelelahuy en se ebpendiyà te leveng. Nekeuma ne midsiniling din en ne iyan din nekita ke meputì ne saput ne imbukus dan ne netahak ketà. Ne mid-ulì sikandin ne neinuinu nevenar sikandin ke engkey se ned-ulala. ");
INSERT INTO mbi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Arà ne hewii ne ruen deruwa ne etew rut te midumaruma ki Hisus ne ebpendiyà te inged ne ed-ingaranan te Emaus. Ini se inged ne Emaus ne iyan din keriyù te Hirusalim ne menge sepulù wey seveka ne kilometro. ");
INSERT INTO mbi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ketà te ked-ipanew ran ne iyan dan egkepengpengasak ne mekeatag te langun dut te ned-ulaula ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gewii ran te ebpengasak ne midlambag si Hisus kandan ne mibpekiduma en. ");
INSERT INTO mbi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nekita ran sikandin ugaid ne warà mebpekilala sikandin kandan. ");
INSERT INTO mbi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Migkahi si Hisus kayi te kandan te, “Engkey ini se egkepengasak niyu te ed-ip-ipanew?” Mid-itindeg dan se paras te egkemutuwan. ");
INSERT INTO mbi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Midtavak ini se senge etew ne ed-ingaranan ki Keliyupas te, “Maa iyan ka mid-ubpà kayi te Hirusalim ne warà pà metau kayi te ned-ulaula ketà?” ");
INSERT INTO mbi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Maa,” ke si Hisus, “engkey se ned-ulaula ketà?” Ne midtavak dan te, “Engkey ve iya? Iyan arà ne mekeatag ki Hisus ne riyà ebpuun te Nesarit. Su si Hisus ini ne benar ne mibpelambas te Lalag te Eleteala diyà te etuvangan din wey kayi rema te etuvangan te menge etew. Duen gehem din te kebpenurù din wey kayi rema te langun te mid-ulaula rin ne mekegeyip. ");
INSERT INTO mbi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ugaid ne ini se menge mepurù tew te terebpelengesa wey ke menge egkeunutan tew ne impemenayik dan diyà te gubinedur su impekukum ne mid-imasad dan te ebpeimetayan, ne inlansang dan en sikandin diyà te pinebelavag ne kayu. ");
INSERT INTO mbi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ne iyan netahù te hinawa rey ne sikandin en iyan ke midsuhù te Eleteala ne ebpeliyu te langun ne inenakan ni Israyil. Ugaid ne ini en ke iketelu ne hewii te kineimetayi ran kandin. ");
INSERT INTO mbi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ne ruen dema ned-ulaula te menge meritan ne ruma ta ne igkeinuinu rey. Su geina ne mibpemanepaney ran diyà te leveng din, ");
INSERT INTO mbi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ugaid ne warà dan mekita ke lawa rin ketà. Ne midlived dan kayi te kenami ne mibpenudtul dan te ruen deruwa ne suluhuen te Eleteala ne mibpekita kun kandan ne migkahi kandan te neuyag en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne ruen menge duma rey ne midsuvar mibpendiyà te leveng ne iring ded iya ketà se nekita ran te migkahi rut te menge meritan, ugaid ne warà dan mekita ke lawa ni Hisus.” ");
INSERT INTO mbi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne migkahi en si Hisus kandan te, “Warà bes itungan niyu! Meambe ke warà kew mebperetiyaya rut te langun ne impesurat te menge mibpelambas te Lalag te Eleteala rengan? ");
INSERT INTO mbi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Su migkahi ke menge mibpelambas te Lalag te Eleteala ne egkerasey pà ini se Impasad te Eleteala ne arà pà ne Ebperetuen din te langun ne imbehey kandin.” ");
INSERT INTO mbi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ketà ne midseysey en ni Hisus kandan ke meana rut te langun ne impesurat te mibpelambas te Lalag te Eleteala rengan mekeatag kandin. Kayi rin imperudsù te impesurat ki Moises taman en dut te mewri ne mibpelambas te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Guna su ebpelundani ran en dut te inged ne edtemanan dan, ne iring te edlevundus pà si Hisus. ");
INSERT INTO mbi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ugaid ne mibangen dan sikandin se egkahi te, “Kayi kiyu pà su meapun en, ne edsanlep en ayan se andew.” Ne arà dà ne mibpekiduma en si Hisus kandan. ");
INSERT INTO mbi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Neiseg-iseg ketà ne mibpinuu ran se egkaan, ne migkuwa ni hisus ke egkeenen dan ne pan ne impeselamat din te Eleteala ne mibpenevìtevì din ne imbehey rin en kandan. ");
INSERT INTO mbi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ketà dan pè be mekilala si Hisus su arà pà ne iring te nevukaan ke mata ran. Ugaid ne miduma rà sikandin te peraan dan. ");
INSERT INTO mbi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne mibpelelahey en ini se deruwa ne etew te, “Tembù bes neinesa ki te ebpemineg kandin te edseysey te menge impesurat te Eleteala te mibpelambas te lalag din gewii te kebpemengasak tew te ed-ipanew.” ");
INSERT INTO mbi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Arà dà ne mid-itindeg dan ne mid-ulì dan en diyà te Hirusalim. Ne iyan dan neumaan ketà ke sepulù wey seveka ne edumdumaan ni Hisus wey ruma pà ne nevurun. ");
INSERT INTO mbi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iyan dan egkepenudtul se, “Benar iya ne nevanew si Hisus ne mibpekita en ki Simon.” ");
INSERT INTO mbi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne ketà ne mibpenudtul en kandan ini se deruwa ne etew ne riyà ebpuun te Emaus ke engkey se ned-ulaula ran diyà te ralan te kinepekiduma ran ki Hisus. Ne mibpenudtul dan dema ke engkey se kinepekekilala ran en ki Hisus ketà te kebpenevìtevì din en dut te egkeenen dan ne pan. ");
INSERT INTO mbi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gewii te ebpenudtul dan kayi ne netetau ran te kayi en mekeitindeg si Hisus te teliwarà dan. Ne migkahi en te, “Na, mebmelintad ke hinawa niyu!” ");
INSERT INTO mbi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nekita ran dà si Hisus ne neandek dan nevenar su iyan dan kunaan ke gimukud din se nekita ran. ");
INSERT INTO mbi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ugaid ne migkahi sikandin kandan te, “Meambe ke egkeandek kew maa kedì? Meambe ke duwaruwa se hinawa niyu kedì? ");
INSERT INTO mbi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Intengi niyu ma ini se palad ku wey paa ku su siaken ded iyan ini! Geweri a niyu ma su apey niyu egketueni te kenà a gimukud. Su embiya gimukud,” ke si Hisus, “ne warà sapù din wey tulan din, ugaid ne egkekita niyu ma te ruen kediey.” ");
INSERT INTO mbi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nekahi rin dà ini ne impekita rin en ke palad din wey paa rin. ");
INSERT INTO mbi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne ruen pà lavew keduwaruwa te hinawa ran te si Hisus ini se nekita ran ugaid ne nengehalew ran wey nengeinuinu. Ne ketà ne mid-insà si Hisus kandan te, “Menu ruen ded egkekaan tew kayi?” ");
INSERT INTO mbi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne mibehayan dan sikandin te in-anag ne serà. ");
INSERT INTO mbi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ne migkuwa rin ke serà ne migkaan din kayi te sineruwan dan. ");
INSERT INTO mbi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne migkahi si Hisus kandan te, “Pehaney te kayi e pà te keniyu ne ini iya ke migkahi ku keniyu: Langun te impesurat mekeatag kediey ketà te penduan ni Moises wey ke impesurat te menge mibpelambas te Lalag te Eleteala wey arà se insurat ketà te riberù ne ed-ingaranan te Salmu ne langun din ne metuman iya kayi te kedì. Na guntaani ne netuman en arà kayi te netemanan ku.” ");
INSERT INTO mbi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne arà pà ne mibukaan din ke itungan dan su apey ran ebpekesabut dut te impesurat ne Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne migkahi en kandan te, “Ini se impesurat dut te mibpelambas te Lalag te Eleteala rengan ne: Ebpekepevayà pà te kegkerasey arà se Impasad te Eleteala ne Ebperetuen ne ed-ingaranan te Mesiyas, ugaid ne ketà te iketelu ne hewii ne ebenawen ded. ");
INSERT INTO mbi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ne kayi te kebpatey rin wey kayi te kebanew te Eleteala kandin,” ke se impesurat ne Lalag te Eleteala, “ne kayi ve imbe ne ruen kebpesahad te Eleteala te keberedusaan dut te menge etew ne ebpedsendit ne ed-engkenà te meraat ne ulaula ran. Ini se ieneb niyu te ebpesabut diyà te langun ne menge inged kayi te ampew te dunya. Kayi niyu irudsù te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Su geina te nemetmetaan niyu en,” ke si Hisus, “te netuman en ini kayi te kedì, ne sikiyu en ke edtitihus. ");
INSERT INTO mbi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Duen ibpepengkayi ku te keniyu ke Kedesenan ne Ebpetuntul te menusiyà ne impasad keniyu te Amey ku rengan. Engketà be ne kenà kew pà awà kayi te inged ne Hirusalim taman te edlumun en keniyu ke gehem din ne riyà ebpuun te langit.” ");
INSERT INTO mbi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ne ketà ne mibpeneheewit din sikandan diyà te liyu te inged ne Hirusalim uvey te inged ne Biteniya. Nekeuma ran ne ingkayew rin ke belad din ne impenuvadtuvad kandan. ");
INSERT INTO mbi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gewii rin te ibpenuvadtuvad din sikandan ne mid-ewaan din en sikandan ne mibatun en diyà te langit. ");
INSERT INTO mbi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne mibpengarap dan kandin, ne memehalew ran nevenar te mid-ulì dan diyà te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne merukilem meandew ne riyà dan te Nekebpuru ne Valey te Eleteala se edeyù te Eleteala.");
INSERT INTO mbi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Rengan te warà pà limbaha ini se misan engkey en, ne raan en ketà ke mid-ingaranan te Lalag. Ne iyan kineingarani kandin ne Lalag su igkepayag din ke langun ne netahù te itungan te Eleteala. Ne raan sikandin ne ruma te Eleteala su Eleteala red dema sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dut te warà pà melimbag ini se misan engkey en ne duma en sikandin te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ne impepevayà kandin ne midlimbag te Eleteala ke langun taman, ne warà misan seveka rut te nelimbag ke kenà impepevayà kandin. ");
INSERT INTO mbi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sikandin ke ebpuunan te umur te menusiyà, ne ke umur din se ebpekerayag te itungan te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ne nekeandlag ke kerayag din diyà te kerusireman, ne ke kerusireman ne warà mekeevuk dut te kerayag. ");
INSERT INTO mbi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Duen senge etew ne mid-ingaranan ki Juan ne midsuhù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iyan din kinesuhua ki Juan ne ebpepemenduen din mekeatag dut te kerayag ne si Hisus su apey ke langun ne ebpekerineg dut te penduan ne ebpekeperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Si Juan ini ne kenà ke kerayag, ugaid ne sikandin ke edseysey mekeatag kayi te kerayag. ");
INSERT INTO mbi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Su ini ke benar ne kerayag ne mibpebaluy ne etew, ne nekeuma en kayi te ampew te dunya su edrayag dut te itungan te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nekeuma en sikandin kayi te ampew te dunya, ugaid ne warà mekekilala kandin ke menge etew misan impepevayà kandin ke kinelimbag dut te dunya. ");
INSERT INTO mbi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nekeuma sikandin kayi te inged din, ne misan ke kereremigey rin ne Hudiyanen ne warà midtelimà kandin. ");
INSERT INTO mbi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ugaid ne misan engkey ne etew se midtelimà wey mibperetiyaya en kandin ne mibehayan din te ketenged te egkevaluy ran ne tuney ne menge anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ne iyan dalan te kinekevaluy ran ne menge anak te Eleteala ne kenà bineelan dà te menusiyà, etawa impenganak te menge etew rà ne amey, su iyan dan Amey ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ne ke mid-ingaranan te Lalag ne mibpebaluy en ne menusiyà ne mid-ubpà en kayi te keytew. Ne lilimuen nevenar sikandin, wey ke langun ne egkehiyen din ne benar. Nekita rey ke geyip ne gehem din ne imbehey kandin te Eleteala su sikandin ke budtung ne Anak te Amey rin ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne mibpenurù si Juan mekeatag kandin ne impenawag din se egkahi te, “Ini ve ke etew ne impenudtul ku keniyu te, ‘Duen senge etew ne ebpeketundug kediey, ugaid ne misan ebpeketundug dà kediey ne sikandin se muna pà ne mepurù kediey, su ketà te warà e pà in-anak ne raan en ketà sikandin.’” ");
INSERT INTO mbi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Geina te dekelà ke limù din ne sikitew langun ne mibehayan din te penaub, ne ini se penaub ne warà kegkepupus din. ");
INSERT INTO mbi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Su si Moises ke nekepeneheewit te penduan te Eleteala kayi te langun tew ne menge menusiyà, ugaid ne si Hisu Kristu ke mibpepayag ne limù te Eleteala wey ke benar mekeatag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Warà senge etew rà ne nekekita te Eleteala, liyu rà dut te budtung ne Anak din ne si Hisu Kristu, su iyan dan layun teleduma. Ne sikandin ke mibpesabut keytew mekeatag dut te Eleteala ne Amey rin. ");
INSERT INTO mbi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Duen menge etew ne mibpendiyà te ki Juan su riyà sikandin te ripag te wayig ne Hurdan se ebpembunyag te menge etew. Ini se nekeuma ne menge terebpelengesa wey menge inenakan ni Levi su midsuhù dan dut te egkeunutan te menge Hudiyanen te ebpeinsaan dan si Juan te, “Entei ka?” ");
INSERT INTO mbi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne mepeyag ini se intavak ni Juan su warà din in-eles se egkahi te, “Kenà siaken si Hisu Kristu, ke Impasad te Eleteala ne Ebperetuen din.” ");
INSERT INTO mbi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Engkey ke ve, si Iliyas ka?” ke sikandan. “Kenà,” ke si Juan. “Ne engkey ke ve iya? Maa sikuna en iya ayan ke ebpelambas te Lalag te Eleteala ne impasad din?” ke sikandan. “Kenà,” ke si Juan. ");
INSERT INTO mbi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Ne idtarem nu kenami,” ke sikandan, “ke engkey ka su apey rey egkepenudtul diyà te midsuhù kenami. Engkey se egkekahi nu mekeatag keykew?” ");
INSERT INTO mbi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Midtavak si Juan ne ke migkahi rin ne iring dut te impesurat ne Lalag te Eleteala ki Isayas ke mibpelambas te Lalag te Eleteala rengan ne migkahi sikandin te, “Siaken ke etew riyà te tanà ne kenà egkeubpaan te etew ne ebpenawag dut te menge etew ne ed-uvey kedì, ne migkahi a te, ‘Mehaan ebpekeuma ke Kerenan, ne tidtuwa niyu ke ibayà din, ne iyan din meana ne tilaka niyu ke hinawa niyu su apey kew egkepenehana te kebpekeuma rin.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ne ayan se ebpenginsà ki Juan ne menge suhù te menge Peresiyu, ");
INSERT INTO mbi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mid-insà dan maa te, “Embiya kenà sikuna si Hisu Kristu, ne kenà sikuna rema si Iliyas etawa ke mibpelambas te Lalag te Eleteala, ne meambe ke ebpembunyag ka te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Midtavak si Juan te, “Siak ne iyan ku ibunyag se wayig, su apey ran egkeandam te kedtelimà ketà te senge etew ne riyà te keniyu ne kenà niyu egkekilala,” ke si Juan. ");
INSERT INTO mbi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","“Ebpekeuma sikandin se ebpeketundug kedì, ugaid ne misan ke telumpà din ne kenà a edait ne ed-ekar.” ");
INSERT INTO mbi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Langun kayi ne riyà med-ulaula te inged ne Bitanya riyà te ripag te wayig ne Hurdan su riyà si Juan se ebpembunyag. ");
INSERT INTO mbi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Midtundug be maa ne hewii ne nekita ni Juan si Hisus se ebpelingguma ne migkahi en sikandin dut te menge etew ne uvey rin te, “Ayan de be ke etew ne iring te ibpelengesa ne nati te bilibili ne imbehey te Eleteala apey ke langun ne salà te menusiyà ne egkeawà. ");
INSERT INTO mbi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ini ve ke etew ne impenudtul ku keniyu te, ‘Duen senge etew ne ebpeketundug kediey, ugaid ne misan ebpeketundug dà kediey ne sikandin se mepurù pà kedì, su raan en ketà sikandin te warà e pà in-anak.’ ");
INSERT INTO mbi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pehaney en,” ke si Juan, “ne warà ku pà mekilala ke engkey an sikandin, ugaid ne mibpengkayi a te ebpembunyag te menge etew te wayig su apey egketueni rut te menge kevuwaran ne Israyil se ebpekeuma en sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne mibpenudtul pà maa si Juan mekeatag ki Hisus te, “Nekita ku ke Kedesenan ne Ebpetuntul te Menusiyà ne midragid te melepati ne riyà ebpuun te langit ne mibpehunrerenà diyà te kandin, ne warà din ewai.” ");
INSERT INTO mbi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Ne warà ku pà lavew metueni te sikandin en bes iya ke midsuhù te Eleteala,” ke si Juan, “ugaid ne ke Eleteala ne midsuhù kedì te ebunyag te wayig ne ingkahi rin kedì te, ‘Embiya egkekita nu en arà se Kedesenan ne Ebpetuntul te Menusiyà ne ebpehunrerenà diyà te etew ne kenà din ed-ewaan, ne egketuenan nu be imbe te sikandin ke ebpembunyag ibpepevayà dut te kedlumun te Kedesenan ne Ebpetuntul te Menusiyà diyà te menge etew ne mibperetiyaya.’ ");
INSERT INTO mbi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne nekita ku en iya ini,” ke si Juan, “ne egkehiyen ku en keniyu te sikandin en iya ke Anak te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ne ke neketundug ne hewii ne ketà en maa si Juan se ebpekidlalag dut te deruwa ne edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nekita rà ni Juan se edsahad si Hisus, ne migkahi en te, “Ayan de be ke etew ne iring te ibpelengesa ne nati te bilibili ke mid-andam te Eleteala ne ibehey rin!” ");
INSERT INTO mbi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne wey merineg dut te deruwa ne edumdumaan din ke lalag ni Juan ne midtundug dan en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ne midteren si Hisus ne midlilingey ne nekita rin ke deruwa ne etew ne edtundug kandin ne mid-insà te, “Meambe ke edtundug kew kedì?” Ne migkahi ran te “Rabi, (ne iyan din meana ne Meyterù) endei ka ed-ubpà?” ");
INSERT INTO mbi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ne midtavak si Hisus te, “Duma kew en kedì su apey niyu egkekita.” Ne mibpekiduma ran en kandin te ed-inteng dut te ed-ubpaan din. Ne meapun en dutun ne wey ran med-ulì ne merukilem en. ");
INSERT INTO mbi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ne senge etew kayi te deruwa se nekerineg te nekahi ni Juan ne miduma ki Hisus ne mid-ingaranan ki Andres, su teleari ran ki Simon Pedro. ");
INSERT INTO mbi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Arà dà ne mid-awà en sikandin se ebpemengà ki Simon ke suled din. Nekita rin dà ne migkahi te, “Netuen dey en ke ed-ingaranan te Mesiyas.” (Seveka ne ngaran ini ni Hisu Kristu, ke Impasad te Eleteala ne Ebperetuen din.) ");
INSERT INTO mbi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne mibperuma din en si Simon diyà te ki Hisus. Nekeuma ran dà ne midtengtengan en ni Hisus si Simun ne migkahi en te, “Sikuna si Simon, ke anak ni Juan, ugaid ne edsembian ku ke ngaran nu ki Sipas.” (Ayan se ngaran ne Sipas ne neked-iring ded te Pedro su ke meana rin ne “Batu”.) ");
INSERT INTO mbi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne ke neketundug ne hewii ne nepegitung ni Hisus ne ebpendiyà te pruvinsiya ne Geliliya. Ketà ne nevalak din si Felipe ne migkehiyan din en te, “Duma ka kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe ne etew ne riyà ebpuun te inged ne Bitsaida, ke inged en ni Andres wey si Pedro. ");
INSERT INTO mbi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ketà ne mibeyaan ni Felipe si Natanael ne migkehiyan din en te, “Nekita rey en ke etew ne ingkesurat ni Moises diyà te riberù te menge penduan te Eleteala, wey ingkesurat ded dema dut te menge etew ne mibpelembas te Lalag te Eleteala rengan. Si Hisus ke ngaran din, ke anak ni Husi ne riyà ebpuun te Neserit.” ");
INSERT INTO mbi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne rutun ne migkahi en si Natanael te, “Maa, ruen bes etew ne riyà ebpuun te Neserit ne ruen egkegaga rin?” Midtavak si Pilipi te, “Iyan tumù se pengkayi ka su intengi nu.” ");
INSERT INTO mbi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Guna su nekita ni Hisus si Natanael se ebpelingguma kayi te kandin ne migkahi te, “Ayan be ke tidtu ne inenakan ni Israyil su warà edtelevan din.” ");
INSERT INTO mbi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mid-insà si Natanael te, “Meambe ke egkekilala a nikuna?” Midtavak si Hisus te, “Nekita ku sikuna ketà te levut te kayu ne ed-ingaran te igira te warà pà med-ipanew si Felipe te edtawag keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Meyterù,” ke si Natanael, “sikuna ves iya ke Anak te Eleteala! Sikuna en iya ke Edatù keytew ne menge kevuwaran ni Israyil!” ");
INSERT INTO mbi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Migkehiyan ni Hisus si Natanael te, “Maa iyan nu rè bes kebperetiyaya kediey, Natanael, se nekahi ku te nekita ku sikuna se riyà te medmeriyù ne levut te kayu ne igira? Ugaid ne muna pà se kebpekeperetiyaya nu ke egkekita nu en ke mekegeyip ne ed-ul-ulaan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne migkahi en si Hisus kandan te, “Benar ini se egkehiyen ku keniyu te egkekita niyu ke lesang te langit ne egkevukaan, ne ke suluhuen te Eleteala ne egkekita niyu se mekepemenayik ne mekepemenaug se ebpengkayi te ke Impeanak te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Guna su nekederuwa ne hewii ketà ne ruen kewingan diyà te inged ne Kana ne lusud te inged ne Geliliya. Ne midtelavuk ke iney ni Hisus ketà te kewingan. ");
INSERT INTO mbi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ne ketà dema si Hisus wey ke edumdumaan din su neinggat dan te edtelavuk ketà te kewingan. ");
INSERT INTO mbi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Guna su neamin en ke inumen dan ne binu su kurang pà kandan ne mibeyaan en te iney ni Hisus se egkahi te, “Warà en duma ne binu.” ");
INSERT INTO mbi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Tebiyà dà keykew, Inà,” ke si Hisus, “te kenà a nu uyawi te ed-ul-ulaan ku. Su warà pà meuma ke hewii te kebpekita ku te gehem ku riyà te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne migkahi en ke iney ni Hisus dut te menge sugsuhuen te, “Dumai niyu te misan engkey se idsuhù din.” ");
INSERT INTO mbi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ne ruen enem ne timan ne kelalew ne edtehuan te wayig su ruen edtenuran ne betasan te menge Hudiyanen mekeatag te kebpenlùlù. Ne uman seveka ne kelalew ne egketehuan te epat etawa enem ne latà ne wayig. ");
INSERT INTO mbi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne migkehiyan en ni Hisus ke menge sugsuhuen te, “Pengipenua niyu ini se kelalew te wayig,” ke sikandin. Ne mibpengipenù dan en iya rema ke menge kelalew. ");
INSERT INTO mbi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Neipus dan te ebpenekeru ne migkahi en si Hisus te, “Sekilut kew be keniyan te wayig ne ewita niyu en diyà te egkamal te egkeenen.” Ne mid-ewit dan en diyà te kandin, ");
INSERT INTO mbi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ne migeraman din ke wayig ne nevaluy en ne binu. Warà din metueni ke endei ebpuun ini se binu (ugaid ne ke menge sugsuhuen ne midsekilut ketà se netau). Dutun ne midtawag din en ke meama ne ebpengesawa ");
INSERT INTO mbi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne migkahi te, “Iyan tew nelayaman ne betasan te embiya ruen kevurunan tew ne iyan tew id-una te ebpeinum ke meupiya ne binu, ne embiya ve su ebpengevulung dan en ne arà pà ne ibpeinum ke binu ne mekurangkurang se nanam din. Ugaid ne sikuna,” ke se meama “ne ke meupiya ne binu ne impememewri nu te ebpehendad su ini pà ne impelepew nu.” ");
INSERT INTO mbi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ini se mid-ulaula ni Hisus diyà te inged ne Kana, lusud te inged ne Geliliya, se neuna ne mekegeyip ne mibeelan din. Impekita rin ke gehem din, ne ketà be ne nekeperetiyaya iya ke edumdumaan din kandin. ");
INSERT INTO mbi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Neipus arà se kewingan ne mibpendiyà si Hisus, ke iney rin, ke menge ari rin, wey ke edumdumaan din te inged ne Kapirnawum. Nekeuma ran ketà ne mid-ubpà dan te nekebpipira ne hewii. ");
INSERT INTO mbi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ne rutun ne mehaan en ne egkeuma ke hewii te kegkevurun te menge Hudiyanen diyà te Hirusalim te kedtumana ran dut te Pista te Kedsehari te Suluhuen te Eleteala, ne arà be ne mibpendiyà si Hisus diyà te Hirusalim. ");
INSERT INTO mbi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Guna su nekeuma ran ne midlusud en si Hisus diyà te Nekebpuru ne Valey te Eleteala, ne nekita rin ke ebpemendehang te menge sapì, menge bilibili, wey menge melepati, su ini se menge binatang ne impemendehang dan ne iyan din egkeetehan ne ibpelengesa. Ne ruen dema ketà menge etew ne ebpesemsembiey te pirak te idsenge vevansa ne inged kayi te pirak te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nekita rà ni Hisus sikandan ne midsuvid en sikandin te idlambit din kandan, ne midsegseg din en langun te kebpeluwal kandan, abpeg ke menge bilibili wey sapì. Misan ke lemisaan dut te menge etew ne ebpenambì te pirak ne mibpemunggad din, abpeg dut te pirak dan ne insivurak ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne migkehiyan din en ke menge etew ne ebpemendehang te melipati te, “Ipengawà niyu ayan! Kenà niyu beeli ne pedian ini se Baley te Amey ku ne Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ne netenuran dut te edumdumaan din ke impesurat ni David ke mibpelambas te Lalag te Eleteala rengan se egkahi te, “Na Eleteala ku, iring te apuy ne edrugrugkayew kayi te diralem ku ini se kegkenuhun ku te ini se valey nu ne egkeedatan.” ");
INSERT INTO mbi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ne rutun ne mid-insaan si Hisus te egkeunutan te menge Hudiyanen te, “Engkey ve se mekegeyip ne ibpekita nu ne tuus te mibehayan ka te gehem te Eleteala te iring ketà ne mid-ulaula nu?” ");
INSERT INTO mbi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ne midtavak si Hisus te, “Rundusa niyu ini se Baley te Eleteala ne lusud te tetelu ne hewii ne ibpeitindeg ku en manen ini se valey.” ");
INSERT INTO mbi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Epat ne pulù wey enem ne rahun se kineveeli kayi te valey! ke sikandan. Maa, ibpeitindeg nu maa te lusud te tetelu rà ne hewii?” ");
INSERT INTO mbi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ugaid ne warà dan mesebuti se ini se valey ne migkahi ni Hisus ne ke lawa rin. ");
INSERT INTO mbi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Guna su neuma en ke hewii te nevanew en si Hisus, ne arà pà ne netenuran dut te edumdumaan din ini se nekahi rin. Ne mibperetiyaya ran ke impesurat ne Lalag te Eleteala mekeatag te kegkevanew ni Hisus abpeg dut te nekahi rin mekeatag te sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gewii pà ni Hisus diyà te Hirusalim te kedtuman dan te Pista te Kedsehari te Suluhuen, ne merakel se mibperetiyaya kandin su nekita ran ke geyip ne mid-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ugaid ne warà midsarig si Hisus dut te nelalag dan ne kebperetiyaya ran kandin su netuenan din ke engkey se netahù te itungan te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Su misan warà midtarem kandin te engkey se metahù te itungan te menge etew, ne netuenan din en ke engkey ke netahù te itungan dan. ");
INSERT INTO mbi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Duen senge etew ne egkeunutan te menge Hudiyanen ne mid-ingaranan ki Nikudimu. Senge etew ini ne sakup te neumpungan ne ed-ingaranan te Peresiyu. ");
INSERT INTO mbi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Senge kerukileman ne mibpendiyà sikandin te ki Hisus ne migkahi te, “Meyterù, netuenan dey se midsuhù ka te Eleteala te ebpenurù kenami, su warà etew ne ebpekevaal te mekegeyip embiya kenà duen gehem te Eleteala riyà te kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Migkahi si Hisus te, “Sebenarvenar ini se igkahi ku keykew te warà senge etew rà ne ebpekelusud diyà te Edetuan te Eleteala embiya kenà sikandin edsaup pà ebpeanak.” ");
INSERT INTO mbi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Migkahi si Nikudimu te, “Menu ve ke lukes en ne etew te ebpesaup ebpeanak? Engkey, edlived pà maa sikandin dut te hetek te iney rin su apey igkesaup igkeanak sikandin?” ");
INSERT INTO mbi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Sebenarvenar ini se igkahi ku keykew,” ke si Hisus, “te warà senge etew rà ne ebpekelusud diyà te Edetuan te Eleteala embiya kenà sikandin edsaup pà ebpeanak te ibpepevayà te wayig wey ke gehem dut te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Su ke id-anak te menusiyà ne menusiyà dà iya, ugaid ne embiya igkesaup en sikandin te igkeanak ibpepevayà dut te gehem te Kedesenan ne Ebpetuntul te Menusiyà ne egkevaluy en sikandin ne anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kenà nu ve igkeselekawi,” ke si Hisus, “te kinelalag ku te, ‘Mebpesaup kew pà langun mebpeanak.’ ");
INSERT INTO mbi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Embiya idsempità ta ne edsamber ke keramag ne misan endei egkesuat ne ebpevayà. Embiya edsamber ne egkerineg nu, ugaid ne warà nu metueni ke endei ebpuun etawa endei ebpesinaru. Iring ded dema ketà ke langun ne mibpeanak te Kedesenan ne Ebpetuntul te Menusiyà, su egketuenan dan iya misan kenà dan egkesebutan.” ");
INSERT INTO mbi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Egkememenu ve ini?” ke si Nikudimu. ");
INSERT INTO mbi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Midtavak si Hisus te, “Mevantug ka ura ne ebpemandù dut te menge kevuwaran ni Israyil, ne meambe ke kenà nu egkesebutan ini se migkahi ku? ");
INSERT INTO mbi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Benar iya ini se egkehiyen ku su netuenan dey te benar ini se impesabut dey keniyu, ne netitihusan dey ke nekita rey en, ugaid ne warà niyu peretiyayaa ke migkahi rey. ");
INSERT INTO mbi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Embiya kenà ka ebperetiyaya te ini se ibpenurù ku kenikew mekeatag te ulaula kayi te ampew te dunya,” ke si Hisus, “ne iyan nu pè be peretiyayaa ke iyan ku en ibpenurù mekeatag te ulaula riyà te langit. ");
INSERT INTO mbi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Su warà pà duma ne nekependiyà te langit liyu rà dut te sikandin arà ne riyà ebpuun te langit ne mibpepengkayi ne Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Rengan te kemulu pà ensi Moises diyà te tanà ne kenà egkeubpaan te etew,” ke si Hisus, “ne ruen mibeelan din ne uled ne galang ne intampak din diyà te kayu ne intunggul rin. Na,” ke si Hisus, “diyà te keuhetan din ne hewii ne ibpeketunggul dema ini se Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Iyan din kebpekevitin diyà te kayu su apey langun ne ebperetiyaya kandin ne ebpeketelimà te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Su kayi ebpuun te rekelà ne limù te Eleteala rut te langun ne menge etew kayi te ampew te dunya ne warà din ingkenuhuni ke budtung ne anak din, ugaid ne midsuhù din te ebpatey riyà te pinebelavag ne kayu su apey langun te ebperetiyaya kandin ne kenà edusaan te Eleteala ugaid ne ebpeketelimà dan te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Su iyan kinesuhù te Eleteala rut te Anak din kayi te ampew te dunya su apey kenà edusaan ke menge etew, ugaid ne apey ran igkepeliyu. ");
INSERT INTO mbi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ne misan engkey ne mibperetiyaya rut te Anak te Eleteala ne kenà en egkesuhat te kedusa te Eleteala, ugaid ne langun ne warà mebperetiyaya kandin ne insivey en te Eleteala ne edusaan su warà dan medtelimà ki Hisus ke budtung ne Anak te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyan kedusa te Eleteala te menge etew su nekeuma en kayi te ampew te dunya si Hisus ke ed-ingaranan te Kerayag su ebpekerayag dut te itungan te langun ne menusiyà, ugaid ne iyan dan midtumù ke kerusireman tumin dè be dut te rayag su meraat ke ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ne misan engkey en ne etew ne ed-ulaula te meraat ne kenà egkesuat te merayag wey kenà dan ed-uvey te merayag su apey kenà egkepayahan ke ulaula ran ne meraat. ");
INSERT INTO mbi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ugaid ke etew ne metidtu se ulaula rin ne ed-uvey dut te merayag su apey egkepayahi ke ulaula rin, su apey egkekita ke ulaula rin ne riyà ebpuun te gehem te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Netaman ketà ne mibpendiyà si Hisus wey ke edumdumaan din te inged ne Hudiya. Ne mid-ubpà dan ketà te nekebpipira ne hewii su ebpembunyag si Hisus te menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ne si Juan dema ne ebpembunyag te menge etew riyà te inged ne Inun uvey te inged ne Salim su merakel ne wayig diyà. Ne ruen menge etew ne ebpemekeuma su ebpebunyag dan kandin. ");
INSERT INTO mbi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Su arà ne hewii ne warà pà bilenggua si Juan.) ");
INSERT INTO mbi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ne ruen menge edumdumaan ni Juan ne ebpekidlewanà te senge etew ne Hudiyanen. Iyan dan ibpelewaney ne atag te edtenuran ne betasan te menge Hudiyanen te kedlùlù. ");
INSERT INTO mbi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ketà ne mibpendiyan en ke edumdumaan ni Juan te kandin se egkahi te, “Meyterù, netenuran nu ves ke ruma nu riyà te ripag te wayig ne Hurdan ne arà se nekahi nu! Riyà guntaani sikandin se ebpembunyag ne iyan pà merakel ne menge etew ne ebpendiyà te kandin su ebpebunyag.” ");
INSERT INTO mbi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Migkahi si Juan te, “Warà etew ne ebpekekuwa te ketengdanen embiya kenà ebehayan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ne sikiyu en iya ke menge titihus te migkahi ku te, ‘Kenà siaken si Hisu Kristu ke Impasad te Eleteala ne Edatù kayi te menge etew, ugaid ne pineuna e rà kandin su apey ku egkepenehana ke ibpevayà din.’ ");
INSERT INTO mbi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Embiya idsempità ta,” ke si Juan, “ke ruen egkewingan ne ke meama ne ed-esawa ne ini se ebpekehaked dut te meritan, kenà ke egkuyug dut te egkewingen; ugaid ne ketà dema sikandin te uvey. Ne embiya egkerineg din en ke meama ne neked-esawa en ne ebpekidlalag en dut te esawa rin, ne dekdekelà se kegkehalew rin. Ini ve imbe ke sempità ku,” ke si Juan, “mekeatag ki Hisus wey siaken. Nehalew ad nevenar su nekekuyug a kandin te ebpenehana dut te netandang ku en ke ibayà din te ebpekeuma. ");
INSERT INTO mbi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ketà be ne ebpekeiseg pà se bentuhan ni Hisus, ugaid ne siaken ne ebpekeembavà.” ");
INSERT INTO mbi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Riyà ebpuun te langit si Hisus ne sikandin ke mepurù pà dut te langun. Ugaid ke etew ne kayi rà ebpuun te dunya ne menusiyà dà sikandin, ne iyan din dà edlelahen ke ulaula kayi te dunya. Ugaid sikandin arà se riyà ebpuun te langit se mepurù pà dut te langun. ");
INSERT INTO mbi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iyan din edlelahen ne ke nekita rin wey ke nerineg din diyà, ugaid ne warà utew etew ne ebpemineg kandin. ");
INSERT INTO mbi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ugaid ne ke etew ne mibperetiyaya te penurù din, ne ibpekepekita rin te iyan dà edlelahen te Eleteala ne benar. ");
INSERT INTO mbi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Si Hisus ke midsuhù te Eleteala ne iyan ibpepenudtul ne ke Lalag te Eleteala dut te ebpelumunan sikandin te Kedesenan ne Ebpetuntul te Menusiyà ne imbehey kandin te Amey rin ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Su igkelimù nevenar te Eleteala ini se anak din ne midsuhù din, ne imbehey rin kandin ke gehem te ebayàbayà te langun taman. ");
INSERT INTO mbi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ne langun ne ebperetiyaya dut te Anak te Eleteala ne egkevehayan te umur ne warà edtemanan din; ugaid ne langun ne kenà ebperetiyaya dut te Anak te Eleteala ne kenà egkevehayan te umur ne warà edtemanan din, nasì pà te iyan igkevehey kandan ke kedusai te Eleteala te warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nerineg dut te menge Peresiyu ke tudtul te iyan pà merakel ne menge etew se ebpendiyà te ki Hisus su ebpebunyag wey ebpesakup kandin dut te menge etew ne ebpendiyà te ki Juan. ");
INSERT INTO mbi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ugaid ne iyan benar ne kenà si Hisus ke ebunyag te menge etew su ke edumdumaan din dà.) ");
INSERT INTO mbi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Guna su nerineg ni Hisus te nepenudtulan, ne mid-awà en diyà te inged ne Hudiya ne mid-ulì en sikandin diyà te inged ne Geliliya. ");
INSERT INTO mbi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ugaid ne ini se ralan ne ibpevayà din te ed-ulì ne kayi ebayà te inged ne Semeriya. ");
INSERT INTO mbi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne guna su ebpevayà en sikandin te inged ne Semeriya ne nekeuma en sikandin te senge inged ne lusud ded te Semeriya ne ed-ingaranan te Sikar, inged ini ne uvey te tanà ne imbehey ni Hakub dengan dut te anak din ne si Jose. ");
INSERT INTO mbi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne kayi te tanà ini ne ruen ne ingkalut ni Hakub dengan. Nekeuma si Hisus ketà ne mibpinuu dut te uvey te kalut su neluhat sikandin te kineipanew rin, su ketà ne neudtu en ke andew. ");
INSERT INTO mbi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Guna su ebpinpinuu en sikandin ne ruen meritan ne nekeuma su edsekeru ne riyà ebpuun te inged ne Semeriya. Ne migkahi en si Hisus kandin te, “Bayi, peinuma a nu.” ");
INSERT INTO mbi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Iyan din kinevuyù te wayig diyà te kandin su mibpendiyà ke edumdumaan din te senge inged su ebpemasa te egkekaan dan.) ");
INSERT INTO mbi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Ey,” ke se meritan, “siaken ne etew a te Semeriya, ne meambe ke egnganey ka kedì te ked-inum nu su Hudiyanen ke ma?” (Iyan din kebpekelalag te iring kayi su kenà ebpemegayun ke menge Hudiyanen dut te menge etew te Semeriya.) ");
INSERT INTO mbi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Midtavak si Hisus te, “Bayi, embiya perem egketuenan nu rà ke engkey ke ibehey te Eleteala, ne embiya perem egkekilala nu rà ke engkey a ini se ebuyù keykew te egkeinum, ne sikuna pà nasì se ebuyù te egkeinum nu kayi te kedì,” ke si Hisus. “Ne igkevehey ku keykew ke wayig ne ebpekevehey te kegkeuyag.” ");
INSERT INTO mbi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Mama,” ke se meritan, “memenuwen nu ve se kebpekekuwa nu keniyan te wayig ne ebehey te kegkeuyag? Su warà ma idsekilut nu ne meralem pà maa ini se wayig! ");
INSERT INTO mbi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Su maa,” ke se meritan, “muna ke pà ki Hakub ke keep-epuan dey? Su sikandin ke midtabun kenami kayi te kalut ini ne kayi mid-inum sikandin wey ke menge anak din, abpeg dut te menge ayam din ne pineinum kayi dema.” ");
INSERT INTO mbi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Migkahi si Hisus manen te, “Ke menge etew ne ed-inum kayi te wayig te ini ne kalut ne edsaup pà lavew ebpekeinum. ");
INSERT INTO mbi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ugaid ke etew ne ed-inum te wayig ne ibehey ku kandin, ne kenà en edsaup ebpekeinum. Su ini se wayig ne ibehey ku kandin ne iring te sebseb ne edtevur diyà te lusud te hinawa rin su puunan te kegkeuyag din, ne ebehey te umur ne warà edtamanan din.” ");
INSERT INTO mbi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Mama,” ke se meritan, “peinuma e ves nikuna keniyan te wayig su apey kenà ad edsaup ebpekeinum, ne kenà ad ebpekepengkayi se edsekeru.” ");
INSERT INTO mbi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Na, ulì ke pà,” ke si Hisus, “ne engaya nu ve ke esawa nu su lived kew kayi.” ");
INSERT INTO mbi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Warà ma esawa ku,” ke se meritan. “Benar an se lalag nu ne warà esawa nu,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Su kelelima ke en mekesawa, ugaid ne ayan se ebpeniwaley guntaani keykew ne kenà nu esawa. Ini se ingkahi nu en kedì ne benar.” ");
INSERT INTO mbi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Mama,” ke se meritan, “netuenan ku te ayan se lalag nu ne lalag te etew ne ebpelambas te Lalag te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne ruen id-insà ku,” ke se meritan. “Mekeatag te keep-epuan dey te Semeriya ne kayi ran imbe ebpengarap te Eleteala te ini ne buvungan. Ugaid ne sikiyu ne menge Hudiyanen ne iyan niyu nekahi se riyà dà te inged ne Hirusalim se ed-ubpaan te ebpengarap te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","“Tenuri nu ini, Bayi,” ke si Hisus, “su ruen hewii ne egkeuma ne kenà en kayi rà ne buvungan etawa riyà dà te Hirusalim ebpengerapa te menge etew ke Amey tew ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Su sikiyu ne menge etew te Semeriya ne matag kew en edsimba ne warà niyu metueni ke engkey se edsimbaan niyu. Ugaid ne sikami se menge Hudiyanen, ne netuenan dey mulà ke edsimbaan dey su kayi ebpuun te kenami ne menge Hudiyanen ne ruen ebpekehemew ne ebpeliyu te menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na,” ke si Hisus te, “neuma en ke hewii te embiya benar ne edsimba ke menge etew te Eleteala ne Amey tew ne med-arap dan ibpepevayà te Kedesenan ne Ebpetuntul te Menusiyà dut te Eleteala wey kayi ebpuun te tidtu te hinawa ran, wey kayi te keduma ran te benar ne penurù ne impayag dut te Eleteala. Ini ve se egkiyuhan te Eleteala ne ulaula rut te menge etew ne edsimba kandin. ");
INSERT INTO mbi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ke Eleteala ne warà lawa rin, tembù be kenà egkekita sikandin. Ke menge etew ne edsimba te Eleteala ne medsimba te ibpehenat te tidtu ne hinawa wey sebenarvenar te keduma ran dut te penurù ne impayag te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ke se meritan, “Netuenan ku te ruen ebpekeuma ne Impasad te Eleteala ne Ebperetuen din te langun ne ed-ingaranan ki Kristu ke Mesiyas. Ketà te kebpekeuma rin, ne ibpesabut din keytew ke langun.” ");
INSERT INTO mbi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ke si Hisus te, “Siaken en iya ini se ebpekidlalag keykew arà se migkahi nu ne si Kristu.” ");
INSERT INTO mbi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kemulu pà ne ebpekidlalag si Hisus dut te meritan ne nekeuma en ke edumdumaan din, ne nengeinuinu ran se ebpekidlalag si Hisus ketà te meritan. Ugaid ne warà seveka rà kandan ne nekeinsà dut te meritan ke engkey se lakew rin ki Hisus, ne warà dan mekeinsà ki Hisus ke engkey arà se ebpengesaken dan. ");
INSERT INTO mbi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Arà dà ne intelau en dut te meritan ke idsekeru rin ne mid-ulì en. Nekeuma rà sikandin ne impemenudtul din en dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pengkayi kew su intengi niyu eyè se etew su intarem din kedì ke langun ne mid-ulaula ku. Engkey, eyè en buwa ke Impasad te Eleteala ne Edatù te langun ne ebpenerengen tew?” kahi rut te meritan. ");
INSERT INTO mbi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nerineg den dà ne migenat dan en se ebpendiyà te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ketà te warà pà mekeuma ke menge etew ne migkahi en ke edumdumaan ni Hisus te, “Mama, iyan tumù ne kaan ke pà.” ");
INSERT INTO mbi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Kaan kew en,” ke si Hisus, “su ruen egkeenen ku ne warà niyu metueni.” ");
INSERT INTO mbi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ne rutun ne mibpein-inseey ran te egkahi te, “Maa, ruen bes buwa mibehey kandin te nekaan din?” ");
INSERT INTO mbi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“Iring te egkeenen ku,” ke si Hisus, “ini se kedtumana ku te kiyug te Eleteala ne midsuhù kedì te ed-imasad dut te helevek ne imbehey rin kedì. ");
INSERT INTO mbi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kenà bes duen besaanan niyu ne egkahi te, ‘Epat pà ne vulan ne arà pà ne egkeuma ke ked-ehani.’ Ugaid,” ke si Hisus, “ne idtarem ku keniyu te sendenga niyu ma ayan se menge etew ne ebpelingguma en, su embiya idsempità ta ne iring dan te melutù ne parey ne ed-eheniyen su kenà meuhet ne ebperetiyaya ran kedì. ");
INSERT INTO mbi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Su ke etew ne ed-ehani ne ebeyaran, ne embiya id-upama ta ne ke etew ne ebpesabut mekeatag kedì ne ruen ded dema egkeehani rin, ugaid ne iyan din egkeehani ke merakel ne ebpeketelimà te umur ne warà edtamanan din. Ketà ne ke mibuvur te Lalag te Eleteala, wey ke mid-ehani te bahas dut te kebpemenudtul te Lalag te Eleteala ne elin dan egkehalew. ");
INSERT INTO mbi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Benar iya ke besaanan dut te keep-epuan ne egkahi te, ‘Ruen ebuvur, ne ke ruma se ed-ehani.’ ");
INSERT INTO mbi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sikiyu,” ke si Hisus, “ne midsuhù ku te ed-ehani rut te warà niyu geleveka te kebuvur. Su duma ne etew se migelevek te kebuvur ketà, ugaid ne sikiyu en maa ke ed-ehani rut te gelevek dan.” ");
INSERT INTO mbi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gewii te kayi pà te ralan ini se menge etew te Semeriya ne ebpendiyà te ki Hisus, ne merakel dut te sikandan se nekeperetiyaya kandin su sabap dut te nekahi te meritan kandan te, “Intarem din kedì ke langun ne mid-ulaula ku.” ");
INSERT INTO mbi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Guna su nekeuma en ini se menge etew te Semeriya ne mibuyù dan ki Hisus te kenà pà bevayà medlaus, ne ketà dema ne mid-ubpà si Hisus te nekederuwa ne hewii. ");
INSERT INTO mbi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne merakel pà lavew ne menge etew se mibperetiyaya kandin su nerineg dan ke penurù din. ");
INSERT INTO mbi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Migkehiyan dan ke meritan te, “Mibperetiyaya key en ne kenà ma ketà dà ebpuun dut te nekahi nu kenami, ugaid ne kayi te nerineg dey en dema ke penurù din ne netuenan dey se benar en iya ne sikandin ke netendù te Eleteala ne ebpeliyu te menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Guna su nepupus en se deruwa ne hewii, ne midlaus en ensi Hisus diyà te inged ne Geliliya. ");
INSERT INTO mbi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Su ruen ketà pehaney ne nekahi ni Hisus te, “Ke etew ne ebpelambas te Lalag te Eleteala ne kenà ed-edatan te menge etew diyà te muney ne inged din.” ");
INSERT INTO mbi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Guna su nekeuma ran diyà te inged ne Geliliya ne nengehalew ke menge etew ketà su neketelavuk dan te kevurunan diyà te Hirusalim dut te Pista te Kedsehari te Suluhuen, ne nekita ran ke langun ne mid-ulaula ni Hisus diyà. ");
INSERT INTO mbi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Netaman ketà ne midlived si Hisus kayi te inged ne Kana lusud te Geliliya, ke inged ne ruen wayig ne pinebaluy rin ne binu. Ketà ne ruen etew ne mepurù se ketengdanan din diyà te gubirnu te inged ne Kapirnawum ne ruen anak din ne meama ne ebpekedaru. ");
INSERT INTO mbi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nerineg dut te mepurù se nekeuma en si Hisus kayi te Geliliya te riyà ebpuun te inged ne Hudiya, ne mibayaan din en ne mibpemuyù kandin te ebperumaan din diyà te Kapirnawum su ebpevawian ke anak din ne egkerandung te kemetayen. ");
INSERT INTO mbi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nerineg dà ni Hisus ne migkehiyan din en te, “Embiya kenà kew ebpekekita te tuus ne ebpekegeyip ne kenà kew ebperetiyaya.” ");
INSERT INTO mbi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Mama,” ke se mepurù te ketengdanan din, “duma ke pà kedì te kenà pà ebpatey ke anak ku.” ");
INSERT INTO mbi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ke si Hisus te, “Na, ulì ke en su neulian en ke anak nu.” Ne mibperetiyaya ke meama rut te migkahi ni Hisus kandin, ne mid-ulì en. ");
INSERT INTO mbi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Guna su nepawà te riyan dan pà te ralan ne nesinuhung dan en ke menge sugsuhuen din ne migkahi ran te, “Neulian en ke anak nu ne ederaru.” ");
INSERT INTO mbi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne mid-insaan din en sikandan te, “Keenu neulii ke anak ku?” “Gevii te nepulid en ke andew ne mid-engked ke kedetenga rin,” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nerineg din arà ne netenuran din en te gevii te nepulid ke andew ke kinekahi ni Hisus kandin te, “Neulian en ke anak nu ne ederaru.” Arà dà ne mibperetiyaya en ki Hisus, abpeg dut te langun ne sikandan kayi te lusud te valey rin. ");
INSERT INTO mbi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ini ve ke ikeruwa ne mekegeyip ne mid-ulaula ni Hisus kayi te lusud te inged ne Geliliya gewii te kineulì din te riyà ebpuun te inged ne Hudiya. ");
INSERT INTO mbi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ne warà dà utew meuhet maa ketà ne mibpendiyà si Hisus te Hirusalim su ruen pista te menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Diyà te Hirusalim ne ruen bengawan ne ebpevayaan te menge etew ne ebpeneheewit te menge bilibili ne ibpelengesa, ne uvey ketà te bengawan ne ruen linew ne ed-ingaranan te kinehiyan ne Hudiyanen te Bitsaida. Ruen lelima ne ed-elungan ne nekelingut kayi te kilid en te wayig. ");
INSERT INTO mbi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Merakel ne menge etew ne ederaru ne ebpengirehà ketà te ed-elungan, ruen pisek, ruen pungkù, ne ruen en midtibas te ayew. (Su edtahad dan te kedsevu ketà te wayig. ");
INSERT INTO mbi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Su ruen andew ne ebpehunrerenà ke suluhuen te Eleteala te kebpesevu rin ketà te wayig. Ne arà be ne ke egkeuna ne etew ne ederaru ne ebpeketiher te edsevu pà ke wayig ne egkeulian ke misan engkey en ne sakit din.) ");
INSERT INTO mbi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne ruen ketà meama ne nekedtetelu en nepulù wey walu ne rahun se kederaru rin. ");
INSERT INTO mbi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nekita ni Hisus sikandin se ed-id-irehà ketà ne netuenan din se neuhet en nevenar ini se daru rin. Ne mid-insaan ni Hisus te, “Maa, egkiyug ka ne egkeulian?” ");
INSERT INTO mbi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Mama,” ke se meama ne ederaru, “warà ruma ku ne ebpekesepuwat kedì te ebpetiher keniyan te wayig ke embiya edsevu. Su embiya seveka ku rà se ebpengkeniyan te wayig, ne ruen ebpekeuna kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ne migkahi si Hisus te, “Enew ka, luluna nu ke ikam nu, ne ipanew ke en.” ");
INSERT INTO mbi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Arà dà iya ne neulian en ini se etew, ne midlulun din en se ikam din ne mid-ipanew en. Ini ne hewii ne Sepetu, ke Hewii te Ked-imeley ran. ");
INSERT INTO mbi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Guna su nekita rut te menge egkeunutan te Hudiyanen ke mibawian ni Hisus ne migkahi ran te, “Meambe ke ebava ka te ikam nu gunteani? Maa kenà ka edtanud te ini ke Hewii ne Id-imeley ne ebpekerimpas ka dut te penduan tew ke ed-ewit ka te ikam nu?” ");
INSERT INTO mbi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Midtavak ini se meama te, “Su ke etew ne nekeulì kedì ne iyan migkahi te, ‘Luluna nu ke ikam nu ne ipanew ke en.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Engkey arà ne etew,” ke se menge Hudiyanen, “se migkahi keykew te ibpelulun ke ikam nu ne ibpeipanew ka?” ");
INSERT INTO mbi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ugaid ne warà metueni rut te meama ke enta se mibawì kandin su ruen merakel ne etew ketà te uvey te wayig ne mid-awà en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Warà dà meuhet ketà ne nekita en ni Hisus ini se meama riyà te lusud te Nekebpuru ne Valey te Eleteala. “Intengi nu ve,” ke si Hisus, “neulian ke en te daru nu! Na, kenà ke en be baal te salà su apey ka kenà egkerasey te tuwas pà dut te daru nu ne ebpekesuhat keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Arà pà ne midlihawang ke meama su ebpendiyà te menge egkeunutan te menge Hudiyanen su idtarem din kandan te si Hisus bes iya ke nekevawì kandin. ");
INSERT INTO mbi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne ketà puunan ne neepes ke menge egkeunutan te Hudiyanen ki Hisus su mibawì sikandin ketà te Hewii ne Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tembù be migkahi si Hisus kandan te, “Taman guntaani ne warà med-imeley ke Amey ku ne Eleteala te egelevek, ne iyan e pè be rema kenà megelevek.” ");
INSERT INTO mbi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nerineg den dà ke migkahi ni Hisus, ne neisab dan se ebpemengà te ralan te ked-imetayi ki Hisus su nekerimpas sikandin dut te penduan ne egkahi te kenà egkapakey ne egelevek dut te Andew ne Id-imeley, ne ikeruwa rin ne mibpekidrepeng sikandin te Eleteala su migkahi rin se Eleteala ke Amey rin. ");
INSERT INTO mbi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ketà ne migkahi si Hisus kandan te, “Sebenarvenar ini se egkehiyen ku te siak ke Anak te Eleteala ne warà egkeveelan ku te kediey rà ne kiyug. Iyan dà ebeelan ku ne arà se nekita ku riyà te ulaula te Amey ku, su ini se ebeelan din ne iyan dema se edumaan ku. ");
INSERT INTO mbi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Su ke Amey ku ne Eleteala ne rekelà se limù din kedì ne Anak din, ne ibpekita rin kedì ke langun ne ed-ul-ulaan din. Ne ruen muna pà ne ibpekita rin kedì ne ed-ul-ulaan ku ne igkegeyip niyu. ");
INSERT INTO mbi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Su ke Amey ku ne Eleteala se ebanew te menge etew ne minatey ne ed-uyahen din maan, ne iring ded dema ketà te siaken ne Anak din su ed-uyag a te piya engkey ne egkiyuhan ku,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kenà ke Amey ku ne Eleteala se egkukum te menge etew, ugaid ne imbehey rin kedì ke Anak din ke gehem te kegkukum te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Iyan din kinesarig kedì su apey siaken ne Anak din ne egkereyrey rut te langun ne menge etew, iring te kedeyreya ran te Amey ku. Su misan engkey en ne etew ne kenà edeyrey kedì ne kenà dema edeyrey dut te Amey ku ne Eleteala ke midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sebenarvenar ini se egkehiyen ku ne misan engkey ne etew ne ebpemineg te lalag ku wey ebperetiyaya rut te midsuhù kedì, ne ebpeketelimà dut te umur ne warà edtemanan din. Ne kenà en edusaan su nekepeliyu en sikandin te kepepatey ne warà edtemanan din, ne ebpekeubpà en diyà te Eleteala taman te taman. ");
INSERT INTO mbi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sebenarvenar ini se egkehiyen ku, misan ke menge etew ne iring te minatey en su sabap dut te salà dan ne neuma en ke hewii ne egkerineg dan ke lalag ku, ke Anak te Eleteala, ne arà se ebpemineg ne egkevehayan te behu ne umur. ");
INSERT INTO mbi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ke Amey ku se ebpuunan te umur su sikandin se ebpekevehey te umur, ne iring ded be ketà ke kedì ne Anak din su ke gehem din ne imbehey rin kediey ne ebpekevehey e red dema te umur. ");
INSERT INTO mbi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne kenà ketà dà taman, su imbehey rin lavew kedì ke gehem te kegkukum te menge etew su siaken iya ke Impeanak te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kenà kew ve meselekawi kayi su ruen hewii ne ebpekeuma ne langun ne riyà te menge leveng ne egkerineg dan ke suwara ku, ");
INSERT INTO mbi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ne ketà ne egemew ran dut te leveng dan. Ne langun te metidtu ne egkevanew ran su riyà ebpekeubpà te Eleteala su neketelimà dan te umur ne warà edtamanan din, ugaid ne langun be rut te nekevaal te meraat ne ulaula ne egkevanew red su edusaan.” ");
INSERT INTO mbi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne migkahi manen si Hisus te, “Embiya kenà ke gehem te Eleteala ne imbehey rin kedì ne warà egkeveelan ku, su iyan ku rà kegkukum ne endei se igkahi rin kedì ne arà se edumaan ku te kegkukum. Tembù be ke kegkukum ku ne metidtu. Su kenà kedì ne kiyug se edtumanen ku, ugaid ne ke kiyug dut te midsuhù kedì se edtumanen ku. ");
INSERT INTO mbi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Upama ini, embiya siaken dà se ebpekehiyen te kedì ne hinawa, ne kenà egkepehimbenar te ruma ne etew. ");
INSERT INTO mbi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ugaid ne ke Amey ku ne ebpeninindeg kediey ne netuenan ku te egkererihan se kebpenitihus din kediey. ");
INSERT INTO mbi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Duen midsuhù niyu riyà te ki Juan su ebpeinsaan niyu ke engkey se siak, ne benar ke migkahi rin mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kenà a ebpegungeyà te etew rà se edtitihus kediey, ugaid ne ebpetenuran ku keniyu ke kedtitihus ni Juan su apey kew ebpekeperetiyaya wey egkepeliyu dut te keberedusaan. ");
INSERT INTO mbi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Su si Juan ne iring te sulù ne midsilà, ne nehalew kew ne ebpemineg dut te mehaan dà ne penurù din. ");
INSERT INTO mbi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ugaid ne ruen mevaher pà dut te kedtitihus ni Juan mekeatag kedì. Ini se helevek ne imbehey kedì dut te Amey ku ne Eleteala, ne ini se ebpesabut keniyu te siak ke midsuhù din kayi. ");
INSERT INTO mbi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne ke Amey ku ne midsuhù kedì ne ebpeketitihus dema mekeatag kedìey. Warà niyu merineg ke suwara rin wey warà niyu mekita sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne warà niyu telimaa ke lalag din su warà kew ma mibperetiyaya kediey ke midsuhù din. ");
INSERT INTO mbi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mibpengedian niyu ke lalag te Eleteala ne impesurat dengan su iyan niyu kunaan ke ketà kew ebpekehaked te umur ne warà edtemanan din. Ne langun ne impesurat ketà ne edlalag mekeatag kedì. ");
INSERT INTO mbi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ugaid ne kenà kew egkiyug ne ebpengkayi te kedì su apey kew perem ebpekehaked te umur ne warà edtamanan din. ");
INSERT INTO mbi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kenà iyan ku ebpemengaan se kegkereyù kedì te menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ugaid ne netuenan ku te warà te hinawa niyu se kedlimù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iyan ku impengkayi ne ibpepevayà te gehem dut te Amey ku ne Eleteala, ne warà kew medtelimà kedì. Ugaid ne embiya ruen ebpekeuma ne ebpemandù keniyu te kandin dà ne gehem, ne edtelimaan niyu mulà sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Memenu ma se kebperetiyaya niyu embiya iyan niyu rà ebpemengaan se kegkereyù keniyu te menge ruma niyu, ugaid ne warà niyu pemengaa ke ralan te kegkereyù ne riyà ebpuun te budtung ne Eleteala? ");
INSERT INTO mbi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Iyan niyu kunaan ke siaken se ed-isuhat keniyu te kevenar diyà te etuvangan te Amey ku ne Eleteala, ugaid ne kenà en iya. Su ruen seveka ne ed-isuhat te kevenar keniyu ketà te hewii te kegkukum ne si Moises su dekelà ke sarig niyu te penduan ne intahak din. ");
INSERT INTO mbi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Embiya benar ne mibperetiyaya kew rut te impesurat ki Moises dengan, ne ebperetiyaya kew kedì dema su ke impesurat kandin ne mekeatag kedì. ");
INSERT INTO mbi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ne ketà be embiya warà kew mibperetiyaya te lalag ne impesurat din,” ke si Hisus, “ne memenu ve se kebperetiyaya niyu kayi se egkehiyen ku?” ");
INSERT INTO mbi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Guna su neipus ini, ne midlived en si Hisus diyà te ripag te Ranew te Geliliya (ne ed-ingaranan dema te Ranew te Tibiriya). ");
INSERT INTO mbi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ne ruen denda ne menge etew ne mid-eguyut kandin su nekita ran ke mekegeyip ne mid-ulaula rin te kebpemawì din dut te menge etew ne ebpenderaru. ");
INSERT INTO mbi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ne midtekereg en si Hisus wey ke menge edumdumaan din diyà te buvungan ne mibpinuu ran en. ");
INSERT INTO mbi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Su ketà ne hewii ne edanirani en ke hewii ne edtenuran te menge Hudiyanen ne ed-ingaranan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Midsandeng si Hisus ne nekita rin ke denda ne menge etew ne ebpelingguma, ne migkehiyan din si Felipe te, “Endei kiyu ebpekekuwa te egkekaan ne ibpekaan tew keniyan te renda ne menge etew?” ");
INSERT INTO mbi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Migkahi rin ini su ebpenggeraman din si Felipe, ugaid ne netuenan din ma ke engkey se ed-ul-ulaan din.) ");
INSERT INTO mbi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Midtavak en si Felipe te, “Misan pipira pà ne hatus ne pirak se ibpemasa ta te egkeenen te iring keniyan se kerakel dan ne kenà pà ebpeketukid kandan misan idsenge sungit dà.” ");
INSERT INTO mbi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne senge etew ne edumdumaan ni Hisus ne ed-ingaranan ki Andres, ke ari ni Simon Pedro, ne migkahi te, ");
INSERT INTO mbi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Duen ini batà ne meama ne midlulutù te lelima ne timan ne pan wey deruwa ne timan se serà. Ugaid ne ebmemenuwen dè be ayan se engkayi ne kerakel te menge etew?” ");
INSERT INTO mbi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Migkahi si Hisus te, “Ibpemepinuu niyu en ayan se menge etew.” (Ne ruen gumegebà ketà ne meluag.) Ne rutun dan en mebpinuu, ne menge lelima ne ngivu se meama liyu ke meritan batà. ");
INSERT INTO mbi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Arà dà ne migkuwa ni Hisus ke lutù te batà, ne mibpeselamatan din te Eleteala, ne mibpenevìtevì din ne imbehey rin dut te edumdumaan din te idtukid diyà te menge etew ne mibpinuu. Iring din ded dema ke serà, ne migkaan dan langun taman te nevulung dan. ");
INSERT INTO mbi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Guna su nevulung dan en ne migkahi en si Hisus dut te edumdumaan din te, “Punpuna niyu ke langun ne samà su apey kenà egkereeti.” ");
INSERT INTO mbi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Arà dà ne mibpunpun dan en ke samà dut te pan, ne ruen sepulù wey deruwa ne binevey se netimuan te samà dut te lelima ne timan ne pan. ");
INSERT INTO mbi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Guna su nekita rut te menge etew ke mekegeyip ne mid-ulaula ni Hisus ne migkahi ran te, “Ini en ke ebpelambas te Lalag te Eleteala ne ibpepengkayi rin te ampew te dunya.” ");
INSERT INTO mbi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Netuenan ni Hisus se mid-uvey ran kandin su ebeelan dan sikandin ne ratù dan misan kenà egkiyug sikandin. Tembù be mid-ewaan dan ni Hisus ne midtekereg diyà te buvungan te sikandin dà. ");
INSERT INTO mbi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Guna su meapun en, riyà en midtupang ke menge edumdumaan din te beyvey te ranew. ");
INSERT INTO mbi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne mid-untud dan en te avang su ed-apet dan te edlived diyà te inged ne Kapirnawum. Guna su mibmerusirem en ne warà pà lavew si Hisus, ne midlaus dan en te ed-apet. ");
INSERT INTO mbi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Netekew ne mibmevaher ke keramag, ne midekelà ke baleg te wayig. ");
INSERT INTO mbi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Guna su neketantal dan en te menge lelima ne kilù, ne arà pà ne nekita ran si Hisus se ebpelingguma ne ed-ipanew kayi te divavew te wayig. Ne nengeandek dan nevenar! ");
INSERT INTO mbi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Kenà kew meandek!” ke si Hisus, “su siaken ini.” ");
INSERT INTO mbi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nerineg dan ke suwara rin ne nengehalew ran ne impeuntud dan en si Hisus kayi te avang. Guna su nekeuntud en sikandin te avang, ne segugunà ne nekerunggù dan en dut te inged ne ebayaan dan. ");
INSERT INTO mbi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nepawà ketà ne ke menge etew ne pinekaan ne riyà pà lavew te ripag te ranew ne netuenan dan te seveka rà ke avang ne diyà te beyvey te ranew. Netuenan dan dema te si Hisus ne warà pà mekeruma dut te edumdumaan din su ke edumdumaan din dà ke mibpenguntud te avang. ");
INSERT INTO mbi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ne rutun te uvey te mibpekeenan kandan ne mibpeselamat si Hisus te Eleteala ne ruen midunggù ne menge avang ne riyà ebpuun te Tibiriya. ");
INSERT INTO mbi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Guna su nekita rut te denda ne menge etew te warà en si Hisus wey misan ke edumdumaan din, ne mibpenguntud dan en te menge avang se ebpendiyà te inged ne Kapirnawum su ebpemengaan dan si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Guna su nekerunggù dan ne netuen dan en si Hisus. “Meyterù,” ke sikandan “keenu ka mekeuma kayi?” ");
INSERT INTO mbi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Midtavak si Hisus te, “Sebenarvenar ini se egkehiyen ku, ebpemengà kew kedì su nekekaan kew te pan ne nengevulung kew, ugaid ne warà kew mekesabut ke engkey se meana kayi te mekegeyip ne ed-ul-ulaan ku. ");
INSERT INTO mbi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kenà niyu iyan pegelepi ke egkeenen kayi te ampew te dunya su edsahad dà. Ugaid,” ke si Hisus, “ne iyan benar ne pegelepi niyu ke egkeenen ne ebpekevehey te umur ne warà edtemanan din. Ini se egkeenen ne siaken ke Impeanak te Menusiyà ke ebehey keniyu, su ruen gehem ku ne imbehey kedì te Amey ku ne Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Migkahi ke menge etew te, “Engkey se ed-ul-ulaan dey su apey key ebpeketuman te kiyug te Eleteala?” ");
INSERT INTO mbi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ne midtavak si Hisus te, “Ini se ul-ulaa niyu su apey kew ebpeketuman te kiyug te Eleteala, peretiyaya kew kedì ke midsuhù te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ne migkahi ran en te, “Engkey pà se ruma ne mekegeyip ne ed-ul-ulaan nu ne ibpekita nu kenami su apey key ebpekeperetiyaya? ");
INSERT INTO mbi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Su ke menge keep-epuan tew rengan ne iyan dan migkaan ne ed-ingeranan te mana te riyà dan pà te tanà ne kenà egkeubpaan te menge etew, iring dut te impesurat ne Lalag te Eleteala ne egkahi te, ‘Ke egkeenen ne riyà ebpuun te langit se imbehey kandan ni Moises.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“Sebenarvenar ini se egkehiyen ku,” ke si Hisus, “ke egkeenen ne imbehey ni Moises te keep-epuan niyu ne kenà ke tidtu ne egkeenen ne riyà ebpuun te langit, su ke Amey ku ne Eleteala se ebehey te tidtu ne egkeenen ne riyà ebpuun te langit. ");
INSERT INTO mbi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Su ke egkeenen ne ibehey te Eleteala, ne sikandin arà se mibpengkayi te ampew te dunya su ebehey te menge etew te umur ne warà edtemanen din.” ");
INSERT INTO mbi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Mama,” ke sikandan, “behayi key en keniyan te egkeenen ne nekahi nu ne kenà edsahad dà su warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne migkahi si Hisus te, “Siaken arà se egkeenen ne ebehey te umur ne warà edtemanan din. Ke etew ne eduma kedì su ebperetiyaya ne iring te etew ne kenà en egkevitil. Uya, ke etew ne edsarig kedì ne iring te etew ne kenà en ebpekeinum. ");
INSERT INTO mbi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na iring te intarem ku en keniyu,” ke si Hisus, “ne misan nekita niyu en ke ed-ul-ulaan ku, ne kenà kew pà lavew iya ebperetiyaya kedì. ");
INSERT INTO mbi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ke langun ne menge etew ne ibehey kedì te Eleteala ne sikandan ke eduma kedì, ne langun ne eduma kedì ne warà senge etew rà kandan ne kenà ku edtelimaan. ");
INSERT INTO mbi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Su mid-ewaan ku ke langit ne mibpengkayi a te ampew te dunya su apey ku egketuman ke kiyug dut te midsuhù kedì, kenà kedì ne kiyug. ");
INSERT INTO mbi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Su ini ke kiyug te Eleteala ne midsuhù kedì te langun ne etew ne imbehey rin kedì ne eduma kedì, ne warà senge etew rà kandan ne kenà egkevehayan te umur ne warà edtemanan din, ne ebenawen ku pà sikandan langun ketà te ketepusan ne hewii te kegkukum,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Su ini ve ke kiyug te Amey ku ne Eleteala te langun ne nekesabut te siaken ke Anak din ne ebperetiyaya ran kedì ne ebpeketelimà dan te umur ne warà edtemanan din, ne siaken se ebanhew kandan ketà te ketepusan ne hewii te kegkukum.” ");
INSERT INTO mbi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Arà be ne neepes ke menge egkeunutan te Hudiyanen dut te nelalag ni Hisus te, “Siaken ke egkeenen ne riyà ebpuun te langit.” ");
INSERT INTO mbi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne mibpemengasak dan te, “Maa, kenà si Hisus ded ini ke anak ni Jose? Su egkekilala tew ke amey rin wey ke iney rin dema. Na meambe ke nekahi rin se riyà sikandin ebpuun te langit?” ");
INSERT INTO mbi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Midtavak si Hisus te, “Engked kew en te ebpemivig. ");
INSERT INTO mbi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Su warà senge etew rà ne eduma kediey ke kenà ke Amey ku ne Eleteala ke midsuhù kedì se ebpenehana te hinawa rin te ebperetiyaya, ne ebenawen ku sikandin dutun te akir din ne hewii te kegkukum. ");
INSERT INTO mbi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Duen impesurat te menge etew ne mibpelembas te Lalag te Eleteala rengan ne egkahi te, ‘Langun ne menge etew ne ebpesebuten te Eleteala,’” ke si Hisus, “ne langun ne ebpemineg te ibpesabut kandin dut te Amey ku ne Eleteala ne eduma kedì. ");
INSERT INTO mbi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kenà iyan ku kegkahi ne ruen etew ne nekekita te Amey ku ne Eleteala su siaken dà ke riyà ebpuun te Eleteala se nekekita kandin su riyan a mibpuun te kandin. ");
INSERT INTO mbi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sebenarvenar ini se egkehiyen ku ne ke etew ne mibperetiyaya kediey ne egkevehayan te umur ne warà edtemanen din. ");
INSERT INTO mbi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Su siaken arà ke egkeenen ne ebpekevehey te umur ne warà edtemanan din,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Benar ne nekekaan ke keep-epuan niyu te egkeenen ne ed-ingeranan te mana rut te riyà dan te tanà ne kenà egkeubpaan te etew, ugaid ne minatey ran ded lavew. ");
INSERT INTO mbi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ugaid ne ini se tidtu ne egkeenen ne riyà ebpuun te langit, ne piya engkey ne etew ne egkaan ketà ne ebpeketelimà te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Siaken ke tidtu ne egkeenen ne riyà ebpuun te langit ne ebpekevehey te umur. Ke etew ne egkaan kayi ne warà kemetayen te himukud din. Su ke egkeenen ne ibehey ku ne ini en iya se lawa ku su apey ebpeketelimà ke langun ne etew kayi te ampew te dunya te umur ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Guna su nerineg dut te menge egkeunutan te Hudiyanen ke migkahi ni Hisus ne nekedlewanà dan te, “Ebmemenuwen din te ebehey ke lawa rin keytew te ebpekaan?” ");
INSERT INTO mbi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne midtavak si Hisus te, “Sebenarvenar iya ini se egkehiyen ku keniyu, embiya kenà kew egkaan te lawa ku wey embiya kenà kew ed-inum te lengesa ku ne kenà kew egkevehayan te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Su ke etew ne egkaan te lawa ku wey ed-inum te lengesa ku ne egkevehayan te umur ne warà edtemanan din, ne ebenawen ku sikandin ketà te hewii ne kebpupusa te dunya. ");
INSERT INTO mbi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Su ini se lawa ku ke tidtu ne egkeenen, ne ini se lengesa ku ke tidtu ne ed-inumen ne ebpekevehey te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ne misan engkey ne etew se egkaan te lawa ku ne ed-inum te lengesa ku ne sikandin ne kayi ebpekeubpà te kedì, ne siaken dema ne diyan a ebpekeubpà te kandin. ");
INSERT INTO mbi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ke Amey ku ne Eleteala ne midsuhù kedì ne ruen umur din ne warà edtemanan din ne ketà ebpuun ne ruen kedì ne umur. Ne iring dema ketà ke etew ne egkaan kediey, egkevehayan sikandin te umur su kayi ebpuun te kediey. ");
INSERT INTO mbi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ini ve ke egkeenen ne riyà ebpuun te langit, ne kenà ini iring dut te egkeenen ne ed-ingaranan te mana ne nekaan dut te keep-epuan niyu su mibpematey ran. Su ke etew ne egkaan kayi te egkehiyen ku ne egkeenen ne egkeuyag sabap kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ini ke migkahi ni Hisus te kebpenurù din diyà te valey ne ebpengedian te menge Hudiyanen te penduan dan diyà te inged ne Kapirnawum. ");
INSERT INTO mbi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Merakel dut te menge etew ne eduma kandin se nekerineg kayi te impenurù din ne migkahi ran te, “Merehen ne egkerumaan ini se impenurù din. Engkey rà buwa iya se ebpemineg kayi?” ");
INSERT INTO mbi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Netuenan ni Hisus te ebpemekedlewanà dan su atag dut te impenurù din ne migkahi en te, “Maa, ebmelugkà ini te hinawa niyu? ");
INSERT INTO mbi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Upama ke embiya egkekita niyu ke Impeanak te Menusiyà ne ebpekelesed su ed-ulì diyà te ebpuunan din, ne engkey ve se pegitungan niyu, muna pà buwa se kegkelugkai te hinawa niyu? ");
INSERT INTO mbi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iyan dà ebpekevehey te umur ne warà edtemanan din ne ke Kedesenan ne Ebpetuntul te Menusiyà, su warà egkegaga te etew rà dè duen. Ini se migkahi ku keniyu ne riyà ebpuun te Kedesenan ne Ebpetuntul te Menusiyà ne ebpekevehey te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ugaid ne ruen ruma niyu ne warà mebperetiyaya kediey.” (Migkahi ini ni Hisus su netuenan din en neraan ke engkey se warà mebperetiyaya kandin wey ke ed-ulug kandin diyà te kunterà din.) ");
INSERT INTO mbi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne midsaup maa sikandin migkahi te, “Tembù be migkahi ku keniyu te warà senge etew rà ne ebpekeruma kediey embiya kenà egkepenehana ke hinawa rin dut te Amey ku ne Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Arà dà iya ne merakel en dut te menge etew ne eduma kandin se mibpekidsuwey en, ne kenà dan en eduma kandin. ");
INSERT INTO mbi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ketà ne nekehiyan ni Hisus ke sepulù wey deruwa ne edumdumaan din te, “Menu sikiyu, ebpekidsuwey kew en rema kediey?” ");
INSERT INTO mbi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Migkahi si Simon ke mid-ingaranan ki Pedro te, “Sikuna ke Kerenan dey ne endei key pè be ebpesinaru? Su sikuna rè ma ke ebpenurù te ralan te kebpeketelimà te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ne mibperetiyaya key en keykew su netuenan dey se sikuna ke Berekat ne midsuhù te Eleteala ne ebpekemalen.” ");
INSERT INTO mbi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Migkahi en si Hisus dut te edumdumaan din te, “Maa, kenà ke sepulù niyu wey deruwa se mibpemilì ku? Ugaid ne seveka keniyu se sakup ni Setanas ke datù te pekaid.” ");
INSERT INTO mbi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iyan din ini egkehiyen ne si Hudas ke anak ni Simon Iskeriyuti. Su misan senge etew si Hudas dut te sepulù wey deruwa, ne sikandin se ed-ulug ki Hisus diyà te menge kunterà din. ");
INSERT INTO mbi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Guna su nekeipus si Hisus te kebpenurù din ne midlauglaug en sikandin kayi te menge inged lusud te Geliliya. Kenà sikandin egkiyug ne ebpendiyà te lusud te inged ne Hudiya su ruen ketà menge egkeunutan te Hudiyanen ne egkiyug ne ed-imatey kandin. ");
INSERT INTO mbi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ne mehaan en dema ketà egketuman ke kevurunan te menge Hudiyanen ne ed-ingeranan te Pista te Menge Sabung. ");
INSERT INTO mbi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tembù be migkehiyan si Hisus dut te menge ari rin te, “Iyan tumù ne awà ka kayi ne telavuk ka te kevurunan diyà te inged ne Hudiya su apey mekekita ke menge etew ne eduma keykew te mekegeyip ne ed-ul-ulaan nu. ");
INSERT INTO mbi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Su warà etew ne ed-eles te ed-ul-ulaan din embiya egkiyug sikandin ne egkevantug. Geina te ed-ul-ulaan nu ini se mekegeyip ne iyan tumù ne ibpekita nu riyà te langun ne menge etew.” ");
INSERT INTO mbi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Migkahi ini rut te menge ari ni Hisus su misan sikandan ne kenà dan ebperetiyaya kandin.) ");
INSERT INTO mbi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Midtavak si Hisus kandan te, “Warà pà mekeuma ke dait ne hewii te kebpayag ku rut te ed-ul-ulaan ku. Ugaid ne sikiyu, ne piya engkey ne hewii ne neked-iring dà diyà te keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Su kenà ma egkeepes keniyu ke menge etew ne egkunterà te Eleteala, ugaid ne egkeepes dan kedì su layun a edsawey kandan dut te meraat ne ulaula ran. ");
INSERT INTO mbi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Una kew en pendiyà te kevurunan,” ke si Hisus “su warà pà mekeuma ke dait ne hewii te kebpayag ku rut te menge ulaula ku.” ");
INSERT INTO mbi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Arà dà ke migkahi ni Hisus ne mibpelintetahak en sikandin kayi te Geliliya. ");
INSERT INTO mbi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Guna su mid-ipanew en ke menge ari ni Hisus ne edtelavuk dut te kevurunan ne midtundug ded dema sikandin, ugaid ne ed-eles-eles dà sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ne ketà te pista, ne mibpemengà si Hisus dut te menge egkeunutan te Hudiyanen. “Endei en be sikandin?” ke sikandan. ");
INSERT INTO mbi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Duen merakel ne ebpevutbutehey mekeatag kandin ketà te menge etew ne nevurun. Ruen egkahi te, “Si Hisus ne meupiya ne etew.” Ne ruen ruma pà ne egkahi te, “Kenà, su ibpesuwey rin ke menge etew.” ");
INSERT INTO mbi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ne geina te egkeandek dan dut te menge egkeunutan te Hudiyanen ne kenà dan utew ibperineg te menge ruma ran ke kedlalag dan. ");
INSERT INTO mbi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Guna su edluukanan en ke kevurunan ne mibpendiyan en si Hisus te Nekebpuru ne Valey te Eleteala su ebpenurù dut te menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne ruen ketà menge egkeunutan te Hudiyanen ne midtelavuk ne nengeinuinu ran. “Endei ebpuun ini se ketau rin” ke sikandan “su warà ma sikandin mekepengadì?” ");
INSERT INTO mbi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nerineg ni Hisus ke migkahi ran ne migkahi en kandan te, “Ini se ibpenurù ku ne kenà kayi ebpuun te ketau ku su riyà ebpuun te Eleteala ne midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ke etew ne egkiyug ne edtuman te kiyug te Eleteala ne egketuenan din ke penurù ku ke embiya egenat te Eleteala etawa kayi rà dèduen te hinawa ku. ");
INSERT INTO mbi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Su ke etew ne ebpenurù te kandin dà dèduen ne hinawa, ne ebpemengà dà te kegkevantug din. Ugaid ne ke etew ne iyan din ebpemengaan se kegkevantug dut te midsuhù kandin, ne egkeserihan ke lalag din su kenà tarù ini se ibpenurù din. ");
INSERT INTO mbi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Maa, kenà ke apù niyu rengan ne si Moises,” ke si Hisus “ke mibehey keniyu te menge penduan? Ugaid ne netuenan ku te warà seveka rà keniyu ne midtuman dut te penduan din. Ne meambe ke egkiyug kew ne ed-imatey kediey?” ");
INSERT INTO mbi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Ed-em-emungan ke ves buwa te vusew!” ke se menge etew. “Su enta ma se egkiyug ne ed-imatey keykew?” ");
INSERT INTO mbi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ne migkahi si Hisus te, “Duen seveka ne mid-ulaula ku ne mekegeyip ne langun niyu ne nengeselekawan su ketà te Hewii ne Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ruen seveka ne penduan ne intahak ni Moises dengan ne insuhù din keniyu te ed-etus te behu pà ne in-anak embiya meama (asal kenà diyà dà ebpuun te ki Moises ini se betasan niyu ne ed-etus su raan en ini ne betasan te keep-epuan niyu), ne ed-etus kew misan ketà te Hewii ne Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ne embiya egkepakey ne ed-etusan se meama te Hewii ne Id-imeley su apey egketuman ke penduan ni Moises, ne meambe ke egkeepes kew kedì ketà te neulian ku te kinebawì ku arà se meama ne ederaru dut te Hewii ne Id-imeley? ");
INSERT INTO mbi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kenà kew ed-isuhat te kukuman te kayi rà te egkekita niyu, ugaid ne ed-isuhat kew te kukuman te ibpeunsad dut te benar.” ");
INSERT INTO mbi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Duen menge etew ketà te inged ne Hirusalim ne nekerineg dut te migkahi ni Hisus ne migkahi te, “Engkey, kenà ini iya ke etew ne ebpemengaan dut te menge egkeunutan te Hudiyanen su ed-imetayan dan? ");
INSERT INTO mbi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Intengi niyu ma se ebpenurù ded sikandin kayi te merakel ne etew. Kema ke benar ded buwa ne netuenan dut te menge egkeunutan tew te sikandin iya ke nekahi ne Impasad te Eleteala ne Ebperetuen din, su warà peengkera sikandin se ebpenurù. ");
INSERT INTO mbi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ugaid ne ini se kebpekeuma rut te Impasad te Eleteala ne Ebperetuen din, ne warà kun egketau ke endei ebpuun sikandin, ugaid ne ini ne netuenan tew red ke mibpuunan din.” ");
INSERT INTO mbi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Gewii ni Hisus te ebpenurù diyà te Nekebpuru ne Valey te Eleteala ne nerineg din arà se lalag dan ne migkahi sikandin te impekerahing din te, “Kunaan niyu ke nekilala a niyu wey netuenan niyu ke endei a ebpuun, ugaid ne idtarem ku keniyu te warà a mibpengkayi te kediey rà ne kiyug su iyan midsuhù kedì ne ke Eleteala ne benar, ugaid ne warà niyu metueni ke entei sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ugaid ne netuenan ku mulà sikandin su riyan a ebpuun te kandin, ne iyan dema sikandin se midsuhù kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ne edsigkemen dan en perem si Hisus ketà, ugaid ne warà neketikà ne egawed kandin su warà pà ma mekeuma ke intail ne hewii te Eleteala te kegkesigkem kandin. ");
INSERT INTO mbi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Merakel se mibperetiyaya te sikandin en ke nekahi ne Ebperetuen ne Impasad te Eleteala, ke sikandan te, “Ini en iya ke egkepenareng tew ne Edatù su warà en ebpekelawan dut te menge mekegeyip ne ed-ul-ulaan din.” ");
INSERT INTO mbi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nerineg te menge Peresiyu ke menge etew ne ebpebutbutehey mekeatag ki Hisus ne tembù be sikandan wey ke menge mepurù te terebpelengesa se midsuhù te menge gurudyà dut te Nekebpuru ne Valey te Eleteala te ibpesigkem si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Migkahi si Hisus te, “Kenà utew meuhet ne ed-ewaan ku sikiyu su ed-ulì ad diyà te midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ne ebpemengà kew kedì, ugaid ne kenà a niyu egketuen su kenà kew ma ebpekependiyà te ebpesineruwan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ketà ne mibpein-inseey ke menge egkeunutan te Hudiyanen te, “Endei ve buwa ebpesinaru sikandin se kenà tew egketuen? Ebpendiyà buwa sikandin te inged te menge etew ne kenà Hudiyanen ke mid-ulian te menge ruma tew ne Hudiyanen, su ebpenurù sikandin te menge etew ne kenà Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Su meambe,” ke se menge egkeunutan te Hudiyanen, “ke nekahi rin se, ‘Ebpemengà kew kedì, ugaid ne kenà a niyu egketuen.’ Ne nekahi rin pà se, ‘Kenà kew ebpekependiyà te ebpesineruwan ku.’ Engkey ve buwa se meana rut te nekahi rin?” ");
INSERT INTO mbi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ketà te mewri ne hewii te pista, su arà ke pinekerekelà ne hewii te menge Hudiyanen te kedtanud dan, ne mid-itindeg en si Hisus ne pinekerahing din se egkahi te, “Ke etew ne ebpekeinum ne mebpengkayi te kedì ne med-inum. ");
INSERT INTO mbi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Su embiya ed-inum en sikandin kayi te kedì,” ke si Hisus, “ne iring dut te impesurat ne Lalag te Eleteala ne egkahi te, ‘Ke etew ne mibperetiyaya kediey,’ embiya idsempità ta, ‘ne riyà ebpuun te hinawa rin ne ruen wayig ne edtudà ne ebpekevehey te umur ne warà edtemanan din.’” ");
INSERT INTO mbi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Ini se impesabut ni Hisus mekeatag dut te Kedesenan ne Ebpetuntul te Menusiyà ne mehaan en ebpekeubpà diyà te menge etew ne ebperetiyaya kandin. Ugaid ne ketà ne hewii ne warà pà ingkevehey ni Hisus ke Kedesenan ne Ebpetuntul te Menusiyà ne ibpeubpà din kandan su warà pà nevanew si Hisus dut te Amey rin ne Eleteala te kebpekeulì din diyà te langit te kedeyù kandin te Amey rin.) ");
INSERT INTO mbi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Guna su nerineg dut te merakel ne etew ne nevurun ketà ne ruen migkahi te, “Ini en iya ke ebpelambas te Lalag te Eleteala ke ebpenerengen tew.” ");
INSERT INTO mbi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne ruen duma ne migkahi te, “Sikandin en iya ke Impasad te Eleteala ne Ebperetuen din.” Ugaid ne ruen ruma pà ne migkahi te, “Kenà, su kenà diyà ebpuun te lusud te inged ne Geliliya ke Ebperetuen te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Su impesabut te insurat ne Lalag te Eleteala te ini se Impasad din ne Ebperetuen ne kayi ebpuun dut te inenakan ni David ne riyà kun id-anak te inged ne Bitlihim ke inged dengan ni Dabid.” ");
INSERT INTO mbi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ketà be ne warà meseveka ke itungan dut te menge etew mekeatag ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Duen ketà egkiyug en ne edsigkem ki Hisus, ugaid ne warà ebpeketikà ne egawed kandin. ");
INSERT INTO mbi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Guna su mid-ulì en ke menge gurudyà te Nekebpuru ne Valey te Eleteala ne mid-insaan dan en dut te menge mepurù te terebpelengesa wey ke menge Peresiyu te, “Meambe ke warà niyu meewit sikandin kayi?” ");
INSERT INTO mbi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ne midtavak ke menge gurudyà te, “Iyan dey warà kedsigkema kandin ne warà key pà mekerineg te etew ne ebpasal iring ketà te kebpasal din.” ");
INSERT INTO mbi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ne migkehiyan dan en maa dut te menge Peresiyu te, “Maa, sikiyu ves dema ne nelimbungan din en? ");
INSERT INTO mbi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maa, ruen misan seveka kayi te sikami ne egkeunutan te Hudiyanen ne ebperetiyaya kandin, abpeg te menge Peresiyu? Warà en iya! ");
INSERT INTO mbi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ini se merakel ne etew ne miduma en kandin ne warà dan mekesabut dut te penduan ni Moises ne intahak keytew, ne igkeantug dan diyà te apuy nerakà.” ");
INSERT INTO mbi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ne dutun si Nikudimu ke senge etew ne Peresiyu ne mibpekidlalag ki Hisus se migkahi te, ");
INSERT INTO mbi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kayi te penduan tew ne kenà egkepakey ne ebpedselaan ke etew ke kenà ibpepinuu pà te kukuman su ebpenginsaan pà sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","“Meambe,” ke se menge ruma rin, “ebpeninindeg ka kandin su riyà ka rema ebpuun te inged ne Geliliya? Besaa nu ke impesurat ne Lalag te Eleteala ne ketà nu egketueni te warà ebpelambas te Lalag te Eleteala ne egemew riyà te lusud te inged ne Geliliya.” ");
INSERT INTO mbi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Neipus ketà ne mibpengulien ke langun ne menge etew, ugaid ne si Hisus ne midtekereg sikandin diyà te buvungan ne ed-ingaranan te Ulivu. ");
INSERT INTO mbi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Guna su nepawè en ne mibpaneypaney si Hisus se edlived kayi te Nekebpuru ne Valey te Eleteala. Miburun maa ke langun ne menge etew kayi te kandin, ne mibpinuu en sikandin se ebpenurù kandan. ");
INSERT INTO mbi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ketà ne ruen menge meyterù te penduan wey menge Peresiyu se mibpengkayi te ki Hisus su mid-ewit dan ini se meritan ne nehumangan ne midlangkadlangkad te esawa rin, ne impeitindeg dan ke meritan kayi te etuvangan te menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Meyterù,” ke se menge etew ne mid-ewit te meritan, “nesempenan dey ini se meritan ne midlangkadlangkad te esawa rin. ");
INSERT INTO mbi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kayi te penduan ni Moises ne edumaan tew, embiya ruen etew ne iring kayi ne edrumbahen te vatu taman te ebpatey. Na, engkey en be se keykew ne kegkukum kayi te meritan ini?” ");
INSERT INTO mbi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iring ketà se migkahi ran ki Hisus su ebpemengaan dan se ralan te id-isuhat dan ne kewagib dut te idtavak din. Ugaid ne midungkug si Hisus ne midsurat te terù din kayi te tanà. ");
INSERT INTO mbi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gewii ran te ed-insà ki Hisus ne midtenggak en sikandin se egkahi te, “Embiya ruen keniyan te keniyu ne warà mekevaal te meraat ne ulaula ne iyan med-una medtimbag kandin te vatu.” ");
INSERT INTO mbi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nekahi rin dà arà ne midungkug en maa sikandin ne midsurat kayi te tanà. ");
INSERT INTO mbi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ne nerineg den dà arà se intavak ni Hisus ne mid-awà dan en te idseveka te egenat dut te lukes taman te iyan dà nesamà si Hisus wey ke meritan ne ed-it-itindeg kayi te etuvangan din. ");
INSERT INTO mbi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ne midtenggak en maa si Hisus se egkahi te, “Na, Bayi, endei embe sikandan? Maa, warà embe seveka kandan ne nesamà ne ed-isuhat keykew te kewagib?” ");
INSERT INTO mbi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Warà en, Mama,” ke se meritan. “Na,” ke si Hisus te, “siak dema ne warà id-isuhat ku keykew ne kewagib. Ulì ke en be ugaid ne kenà ke en maa baal te meraat ne ulaula.” ");
INSERT INTO mbi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ne migkahi pà maa si Hisus diyà te menge etew te, “Siaken ke sulù ne ebpekerayag te itungan te langun ne menge etew kayi te ampew te dunya. Piya engkey ne eduma kedì ne kenà en ed-ipanew diyà te kerusireman su egkereyahan en ke itungan dan kayi te rayag te sulù ne ebehey te umur ne warà edtemanan din.” ");
INSERT INTO mbi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Guna su nerineg te menge Peresiyu ne migkahi ran te, “Sikuna red se edtitihus te keykew rà ne hinawa. Tembù be ini se migkahi nu ne kenà tidtu ne titihus ini.” ");
INSERT INTO mbi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ne migkahi si Hisus kandan te, “Piya edtitihusan ku ke kedì ne hinawa ne egkedserihan niyu ke lalag ku ne benar. Su netuenan ku ke endei a ebpuun ne endei a ebpesinaru, ugaid ne sikiyu mulà ne kenà niyu egketuenan ke endei a ebpuun etawa ke endei a ebpesinaru. ");
INSERT INTO mbi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Embiya egkukum kew te ulaula te menge etew ne kenà egkedserihan se kegkukum niyu su kayi rà dèduen te kememenusiyai ne itungan, ugaid ne siaken ne kenà a egkukum te misan engkey en. ");
INSERT INTO mbi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ugaid ne embiya egkukum a,” ke si Hisus pè maa, “ne egkeperetiyaya niyu ne benar su kenà siaken dà su deruwa rey rut te Amey ku ne Eleteala ne midsuhù kedì se egkukum. ");
INSERT INTO mbi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Su ruen nekesurat te penduan niyu ne egkahi te, ‘Embiya egkeseveka se bitiyara rut te deruwa ne etew ne edtitihus, ne benar se lalag dan.’ ");
INSERT INTO mbi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Edtitihusan ku ke kedì ne hinawa, ne ke Amey ku ne Eleteala ne midsuhù kedì se edtitihus dema mekeatag kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nerineg dà dut te menge Peresiyu ne migkahi ran en te, “Endei ma ke Amey nu?” “Warà a niyu metueni ke entei a etawa ke Amey ku,” ke si Hisus. “Su embiya netuenan a nikiyu ne egketuenan niyu rema ke Amey ku.” ");
INSERT INTO mbi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ini ke migkahi ni Hisus dut te kebpenurù din diyà te Nekebpuru ne Valey te Eleteala uvey te edtehuan te ibehey te Eleteala. Ne warà midsigkem kandin su warà pà ma metuman ke hewii ne intail te Eleteala kandin. ");
INSERT INTO mbi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ne migkahi pà maa si Hisus diyà te menge egkeunutan te Hudiyanen te, “Ed-ewaan ku en sikiyu ne ebpemengà kew kediey su apey kew ebpekepeliyu, ugaid ne kenà e ma nikiyu egketuen ne ebpematey kew red keniyan te salà niyu ne kenà egkepesahad. Su kenà kew ebpekependiyà te ebpesineruwan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ne mibpein-inseey ke menge unutan te Hudiyanen te, “Migkahi sikandin te, ‘Kenà kew ebpekependiyà te ebpesineruwan ku.’ Engkey se ibpesabut din, ed-ehet buwa sikandin?” ");
INSERT INTO mbi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne midtavak si Hisus te, “Sikiyu ne ini kew rà te ampew te dunya, ugaid ne siaken ne riyan a ebpuun te divavew. Uya, sikiyu ne kayi kew ebpuun te kelibutan, ugaid ne siaken ne diyan a ebpuun te langit. ");
INSERT INTO mbi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tembù be intarem ku en keniyu,” ke si Hisus, “te ebpematey kew red keniyan te salà niyu ne kenà egkepesahad. Uya embiya kenà kew ebperetiyaya te siaken arà ke intarem ku keniyu ne riyà ebpuun te Eleteala ne ebpematey kew red keniyan te salà niyu ne kenà egkepesehad.” ");
INSERT INTO mbi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Engkey ke ma iya?” ke se menge Peresiyu. Ne midtavak si Hisus te, “Intarem ku en keniyu ke entei a igenat dut te aney en ne kebpenurù ku taman en gunteani. ");
INSERT INTO mbi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Merakel pà se igkekahi ku wey igkeisuhat ku mekeatag te menge ulaula niyu. Ugaid ne iyan ku rà ibpesabut te menusiyà ne endei rà ke nerineg ku rut te midsuhù kedì, ne egkedserihan nevenar sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Warà mekesabut ke menge Hudiyanen te migkahi rin mekeatag te Amey rin ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ne geina te warà dan mesebuti ne migkahi en maa si Hisus te, “Ketà te hewii ne kedlensanga niyu ke Impeanak te Menusiyà diyà te pinebelevag ne kayu ne ketà niyu egkesebuti te siaken arà se intarem ku keniyu ne riyà ebpuun te Eleteala. Ne ketà ne egketuenan niyu rema te warà ebeelan ku te kedì dà ne hinawa, ugaid ne iyan ku rà igkahi ne endei rà ke ibpekahi kedì dut te Amey ku ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne ke Amey ku ne midsuhù kedì,” ke si Hisus, “ne eduma kedì. Kenà a rin ebpedtedayan su iyan ku rà edtumanen ke ebpekesuhat te hinawa rin.” ");
INSERT INTO mbi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ne merakel dut te nekerineg te lalag ni Hisus se mibperetiyaya kandin. ");
INSERT INTO mbi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ne migkehiyan ni Hisus ke menge Hudiyanen ne mibperetiyaya en kandin te, “Embiya ibperayun niyu ke keduma niyu rut te menge penurù ku keniyu ne benar kew en ne edumdumaan ku. ");
INSERT INTO mbi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne egkesebutan niyu ke benar ne penurù mekeatag te Eleteala ne ketà puunan ne egkevelukasan kew.” ");
INSERT INTO mbi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nerineg den dà ne migkahi ran en te, “Sikami ne menge inenakan ni Abraham ne warà key pà keenu meuripen te misan entei en. Ne meambe ke nekahi nu se egkevelukasan key?” ");
INSERT INTO mbi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","“Sebenarvenar ini se egkehiyen ku keniyu,” ke si Hisus, “te misan entei ne ebaal te meraat ne egkeuripen te salà. ");
INSERT INTO mbi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ini se uripen ne kenà ebpekeubpà ketà te baley te kerenan din taman te taman, ugaid ne ke tuney ne anak se ebpekeubpà ketà taman te taman. ");
INSERT INTO mbi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Geina te siak se Anak te Eleteala, ne embiya egkevelukasan ku en sikiyu ne kenà kew en egkepengunguripen. ");
INSERT INTO mbi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Netuenan ku,” ke si Hisus, “te inenakan kew ni Abraham, ugaid ne iyan niyu ebpemengaan se kebpatey ku su kenà kew ma ebpemineg te penurù ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iyan ku egkehiyen ne endei rà ke ibpekahi kedì dut te Amey ku, ugaid ne sikiyu ne iyan niyu ed-ul-ulaan ke netuenan niyu rut te amey niyu.” ");
INSERT INTO mbi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ne migkahi ran te, “Iyan dey keep-epuan si Abraham.” Ne migkahi si Hisus te, “Embiya ma benar kew ne inenakan ni Abraham, ne iyan niyu ma ebeelan ke mibeelan din dengan. ");
INSERT INTO mbi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ugaid ne kenà ma ayan ke ulaula niyu su ebpemengà kew te ked-imatey niyu kedì misan iyan ku rà migkahi keniyu ke benar ne ibpekahi kedì dut te Amey ku ne Eleteala. Ne kenà be iring ketà ke ulaula ni Abraham dengan. ");
INSERT INTO mbi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sikiyu, ne iyan niyu ebeelan ne endei rema ke mibeelan dut te amey niyu.” Migkahi ran te kegkeepes dan te, “Kenà key ini menge anak dà te ingkehingey! Netuenan dey ke engkey se amey rey, su ke sebseveka ne Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","“Na,” ke si Hisus “embiya ke Eleteala iya maa ke amey niyu, ne igkelimù a nikiyu su diyan a mibpuun te kandin. Ne kenà kedì ne kiyug se kinepengkayi ku su sikandin ke midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Meambe ke kenà niyu egkesebutan ke egkehiyen ku? Iyan iya se kenà kew egkiyug ne eduma te ibpenurù ku. ");
INSERT INTO mbi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Su ke datù ma te pekaid se amey niyu ne iyan niyu edumaan ke kandin ne kiyug. Terebunù sikandin te aney en, ne edsungkanger dut te benar su iyan dè ma nekepenù te bèbà din ne tarù. Embiya edlalag sikandin ne tarù su edumaan din ke kandin ne kiyug, su teruen ma sikandin ne apù sikandin te tarù. ");
INSERT INTO mbi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ugaid ne sebenarvenar mulà ini se lalag ku,” ke si Hisus, “ne kenà kew ebperetiyaya kediey. ");
INSERT INTO mbi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na, engkey keniyu se ebpeketitihus te ruen meraat ne ed-ul-ulaan ku? Warà! Ne embiya benar se lalag ku ne meambe ke kenà kew ebperetiyaya kedì? ");
INSERT INTO mbi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Arà se etew ne benar ne anak te Eleteala ne ebpemineg te menge lalag te Eleteala. Ugaid ne sikiyu ne kenà din menge anak, tembù kenà kew ebpemineg.” ");
INSERT INTO mbi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne midtavak ke menge Hudiyanen ki Hisus te, “Benar iya vuwa ke nekahi rey geina ne riyà ka ebpuun te inged ne Semeriya ne midsuukan ka te vusew.” ");
INSERT INTO mbi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Warà a ini suuki te vusew,” ke si Hisus. “Su iyan ku ed-ul-ulaan ini ne pekinegan dut te Amey ku, ugaid ne ebpegkeyà kew kedì. ");
INSERT INTO mbi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kenà ku iyan ebpenemaran ke kebantug kedì te menge etew, ugaid ne Eleteala se metau ne edtuganur te kegkevantug ku, wey sikandin se edtampil kedì. ");
INSERT INTO mbi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sebenarvenar ne ini se idtarem ku keniyu te piya entei en se eduma te ibpenurù ku ne kenè en ebpatey.” ");
INSERT INTO mbi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Na benar iya ne midsuukan ka te vusew,” ke se menge Hudiyanen. “Su misan si Abraham wey ke langun ne mibpelembas te Lalag te Eleteala rengan ne mibpematey ran ded ma. Ne meambe ke migkahi nu te, ‘Misan entei en ne eduma te penurù ku ne kenè en ebpatey?’ ");
INSERT INTO mbi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ke keep-epuan dey ne si Abraham ne minatey en, ne engkey, muna ke pà bes kandin? Wey ke mibpemelambas te Lalag te Eleteala ne mibpematey ran ded lavew. Engkey ke ma te keykew ne kebpegpegitung?” ");
INSERT INTO mbi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne midtavak si Hisus te, “Embiya ebantug a te hinawa ku ne warà pantag din ke bentuhan ku. Ugaid ne iyan ebantug kedì ke Amey ku ne Eleteala, ke iyan egkehiyen niyu ne Eleteala niyu. ");
INSERT INTO mbi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Warà niyu metueni ke entei sikandin, ugaid ne siaken mulà ne netuenan ku sikandin,” ke si Hisus. “Embiya ve migkahi ku te warà ku metueni sikandin, ne teruen a iring keniyu. Ugaid ne netuenan ku nevenar sikandin ne edtumanen ku ke menge lalag din kediey. ");
INSERT INTO mbi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nehalew si Abraham ke keep-epuan niyu rengan su netuenan din te ibpepengkayi a su ebpebaluy ne menusiyà, tembù be nehalew sikandin su ebpenerengen a rin.” ");
INSERT INTO mbi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ne migkahi ke menge Hudiyanen te, “Engkey en se kinepekekita nu ki Abraham te warà pà melelima nepulù se rahun nu?” ");
INSERT INTO mbi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Sebenarvenar ne ini se egkehiyen ku keniyu,” ke si Hisus, “te warà pà in-anak si Abraham ne raan ad.” ");
INSERT INTO mbi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Arà dà ne mibpurut en ke menge Hudiyanen te vatu su idrumbag dan ki Hisus, ugaid ne mibpeniyuksiyuk si Hisus ne mid-awà ketà te Nekebpuru ne Valey ne te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ketà te ked-ip-ipanew ni Hisus ne nekita rin ini se etew ne neketakin kandin se nepisek en. ");
INSERT INTO mbi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","“Mama,” ke se menge edumdumaan ni Hisus, “meambe ke midtakin ayan ne kegkepisek din? Engkey ki salà, kandin be etawa ke menge lukes din?” ");
INSERT INTO mbi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne migkahi en si Hisus te, “Kenà kayi ebpuun te kandin ne salà etawa riyà te menge lukes din. Nepisek sikandin su apey egkekita kayi te kegkeulii rin ke gehem te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Taman te meandew pà,” ke si Hisus, “ne iyan iya se egelevek ki pà dut te gelevek te midsuhù kedì. Su egkeuma ke merukilem ne warà en ebpekehelevek. ");
INSERT INTO mbi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Taman te kayi e pà te ampew te dunya ne siaken ke sulù ne ebpekerayag te itungan te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Neipus din te egkahi ini, ne mid-ileb en diyà te tanà ne intevuley rin en ke ileb din te tanà su apey ebudtà. Ne indekudas din en ke vudtà diyà te mata rut te nepisek. ");
INSERT INTO mbi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne migkahi en sikandin te, “Pendiyà ke be te linew ne ed-ingaranan te Siluan ne pendapug ke ve ketà.” (Iyan meana te Siluan ne “Midsuhù”.) Arà dà ne mibpendiyà en ke pisek ne mibpendapug en ketà sikandin. Nekeipus ne midlived sikandin ne ebpekekita en. ");
INSERT INTO mbi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Guna su nekita rut te menge etew riyà te sepiring din wey ke menge etew ne nekekita kandin te kebpememuyù din ne mibpein-inseey ran te, “Maa, kenà ini red ke meama ne ebpinpinuu su ebpememuyù?” ");
INSERT INTO mbi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ruen migkahi te, “Ayan ded iya sikandin!” Ne ruen ruma ne migkahi te, “Kenà, su nekedrahid dà ke paras dan.” Ne migkahi en ke meama ne nepisek pehaney te, “Siaken iya ini ke nepisek.” ");
INSERT INTO mbi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Ne meambe,” ke sikandan, “engkey ma se kegkeulii te mata nu?” ");
INSERT INTO mbi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Midtavak sikandin te, “Iyan nekeulì te mata ku arà se etew ne ed-ingaranan ki Hisus. Su mid-ilevan din ke tanà ne intevuley rin ke ileb din su apey mebudtà, ne arà ke indekudas din te mata ku. Ne migkehiyan a rin te, ‘Pendiyà ka te linew ne ed-ingaranan te Siluan ne pendapug ke ve ketà.’ Ne mibpendiyan a rema te linew ne guna su nekeipus a se ebpendapug ne ebpekekita ad.” ");
INSERT INTO mbi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Na endei be sikandin?” ke sikandan. Ne midtavak en sikandin te, “Idita en.” ");
INSERT INTO mbi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ne miduma ran en ke neulian ne pisek diyà te menge Peresiyu. ");
INSERT INTO mbi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ne arà ne hewii se kinevaal ni Hisus te budtà ne nekeulì dut te pisek ne Hewii te Id-imeley. ");
INSERT INTO mbi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nekeuma ran diyà te menge Peresiyu ne mid-insaan en maa sikandin ke engkey se imped-ulaula ni Hisus kandin te kegkeulii te mata rin. Ke sikandin te, “Indekudas din ke budtà kayi te mata ku ne pinependapug a rin, ne ketà ne nekekita ad.” ");
INSERT INTO mbi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nerineg dà dut te menge Peresiyu ne ruen migkahi te, “Ini se etew ne mibawì keykew ne kenà ebpuun te Eleteala su kenà edtanud sikandin dut te Hewii ne Id-imeley.” Ne ruen ruma pà ne migkahi te, “Engkey, duen belisalà ne etew ne ebpekevaal te menge ulaula ne mekegeyip?” Ketà ne kenà dan en ebpemegayun. ");
INSERT INTO mbi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne mid-insaan dan en manen ke etew ne neulian te, “Na sikew, nekahi nu te sikandin se kineulii te mata nu, engkey ve se nepegitung nu mekeatag kandin?” Ke sikandin te, “Ebpelambas sikandin te Lalag te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ugaid ne warà peretiyayaa te menge egkeunutan te Hudiyanen te nepisek ini se etew neraan, tembù be impetawag dan ke menge lukes dut te pisek, ");
INSERT INTO mbi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ne mid-insà dan dut te menge lukes te, “Engkey, ini iya ke anak nu? Maa, daan en iya ne pisek sikandin te kineanak kandin? Ne memenu ve se kinekeulii te mata rin?” ");
INSERT INTO mbi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne midtavak ke lukes din te, “Uya, anak dey iya sikandin ne intakin kandin ayan se kegkepisek din. ");
INSERT INTO mbi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ugaid ne warà dey metueni ke engkey se kinepekekita rin en, ne warà dey metueni ke engkey se nekeulì kandin. Iyan tumù ne sikandin en se insai niyu ne igketarem din ma su egketau en sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ini ke intavak dut te menge lukes din su neandek dan dut te menge egkeunutan te Hudiyanen. Su ruen neumpungan te menge egkeunutan te embiya ruen etew ne ebperetiyaya te si Hisus ke Impasad te Eleteala ne Ebperetuen, ne ibpeawà sikandin dut te baley ne ebpengedian te menge Hudiyanen te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tembù be migkahi ke menge lukes din te, “Iyan niyu en insai sikandin su egketau en ma sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ne rutun ne mid-umew ran en maa te ebpelived ke neulian ne pisek ne migkahi ran te, “Na iyan nu rà kehiya ke benar su ini ka te etuvangan te Eleteala. Su netuenan dey te ini ne etew se nekeulì keykew ne belisalà ne etew.” ");
INSERT INTO mbi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Kenà ku egketuenan embiya belisalà sikandin etawa kenà,” ke se neulian ne pisek, “ugaid ne iyan ku netuenan te pehaney ne nepisek a ne huntaani ne ebpekekita ad.” ");
INSERT INTO mbi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Ne engkey ve se imped-ulaula rin keykew?” ke sikandan. “Ne mibmenumenu rin be se kegkeulii te mata nu?” ");
INSERT INTO mbi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Migkahi ku en ura keniyu,” ke se neulian ne pisek, “ne warà kew ma mebpehimbenar. Ne meambe maa ke ibpesulit niyu pà kedì? Maa egkiyug kew rema ne eduma kandin?” ");
INSERT INTO mbi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Neepes dan ketà ne meraat se lalag dan kandin, ke sikandan te, “Ew, edumdumaan ke ves nikandin, ugaid ne sikami mulà ne edumdumaan key rut te ebpelambas te Lalag te Eleteala rengan ne si Moises. ");
INSERT INTO mbi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Netuenan dey nevenar te mibpekidlalag ke Eleteala ki Moises, ugaid ne ini se etew ini ne warà dey metueni ke endei sikandin nekepuun.” ");
INSERT INTO mbi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Migkahi ini se neulian te, “Asal mekegeyip! Warà niyu metueni ke endei sikandin ebpuun misan ruen gehem din ne nekeulì te kegkepisek ku. ");
INSERT INTO mbi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Netuenan tew te kenà ebpemineg ke Eleteala rut te etew ne belisalà, ugaid ne iyan din ebpeminehen ke etew ne ed-adat kandin wey edtuman te kiyug din. ");
INSERT INTO mbi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Su aney en te kinelimbaha te dunya ne warà pà nerineg tew ne etew ne ebpekeulì te etew ne nekeraan kandin se kegkepisek din. ");
INSERT INTO mbi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Embiya kenà suhù te Eleteala ini se etew,” ke se neulian ne pisek, “ne warà igaga rin te ebpekevaal te iring kayi.” ");
INSERT INTO mbi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Migkahi ke menge egkeunutan te, “In-anak ka te mekesesalà, ne meambe ke ebpenunganunga ka ebpenurù kenami?” Arà dà ne impeawà dan en sikandin ne migkehiyan dan te kenà en ebpelusuren dut te baley ne ebpengedian te menge Hudiyanen te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Guna su nerineg ni Hisus ke imped-ulaula ran dut te etew ne neulian din, ne mibpemengà din. Guna su netuen din ne mid-insaan din te, “Maa, mibperetiyaya ke en be rut te Impeanak te Menusiyà?” ");
INSERT INTO mbi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne midtavak ke meama te, “Kehiya nu kedì ke entei sikandin, Mama, su apey a ebperetiyaya kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Nekita nu en,” ke si Hisus, “su sikandin en iya ini ke ebpekidlalag keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Embiya sikuna ves,” ke se meama, “ebperetiyaya a keykew.” Arà dà ne mibpengarap en ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Migkahi si Hisus te, “Iyan ku impengkayi te ampew te dunya su edtimbangen ku ke menge etew su apey ke menge etew ne nerusireman te kegkepisek dan ne edtelimà kedì ne ebehayan ku te kerayahan. Ugaid ne ke kenà edtelimà kedì su engkungkun ne nekita ran ke kerayahan ne ebpelekapan ku ke mata ran.” ");
INSERT INTO mbi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ruen menge Peresiyu ne nekerineg dut te lalag ni Hisus ne migkahi ran en te, “Engkey se migkahi nu, menge pisek key rema?” ");
INSERT INTO mbi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne midtavak si Hisus te, “Embiya nepisek kew iring dut te etew ne warà pà nevehayi te kerayahan, ne warà perem kegkeisuhat keniyu. Ugaid ne geina te migkahi kew te, ‘Ebpekekita key en,’ ne arà se kegkeisuhat keniyu te kewagib su kenà kew ma eduma.” ");
INSERT INTO mbi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ne ruen insempità ni Hisus te, “Sebenarvenar ini se egkehiyen ku keniyu, embiya ruen etew ne edlusud te tudilan te menge bilibili ugaid ne kenà ebpevayà te humawan su ed-ambak, ne tekawen sikandin etawa tulisan. ");
INSERT INTO mbi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ugaid ke etew ne edlusud te humawan, ne sikandin ke tumetuganur dut te bilibili. ");
INSERT INTO mbi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Embiya edlusud sikandin ne ebpuwasan dut te ebantey ke humawan. Ne ebpekekilala ke bilibili te suwara rin ke ed-umawen din dut te ngaran dan su ibpelihawang dan. ");
INSERT INTO mbi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne embiya ve nekelihawang dan en ne ed-una en ke tumetuganur, ne edtundug en ke menge bilibili su egkekilala ran ke kandin ne suwara. ");
INSERT INTO mbi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kenà dan edtundug te selakew ne etew, inemulà se ebpelahuy ran kandin su kenà den ma egkekilala ke kandin ne suwara.” ");
INSERT INTO mbi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ini ke insempità ni Hisus kandan, ugaid ne warà dan mesebuti ke meana rin. ");
INSERT INTO mbi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne migkahi maa si Hisus kandan te, “Sebenarvenar ini se egkehiyen ku keniyu: ne iyan a ke gumawan te tudilan ne ibpevayà dut te menge bilibili. ");
INSERT INTO mbi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Langun ne mid-una kedì su ebpenurù ne egkahi te midsuhù te Eleteala ne iring dan te menge tekawen wey tulisan. Ugaid ne ke menge bilibili ne timbang te menge etew ne warà dan mebpemineg kandan. ");
INSERT INTO mbi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Siaken ke humawan, ne misan engkey se edlusud kayi te kedì ne igkepeliyu sikandin. Iring sikandin te bilibili ku ne medlusud wey medluwal se ebpemengà te kegkaan din su egkeventayan ku ma sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ke tekawen ne iyan din kedlusud dut te tudilan su ebpenakew, ed-imatey wey ederaat. Ugaid,” ke si Hisus, “ne iyan ku kinepengkayi su apey ku igkepeliyu ke menge etew ne ebpeketelimà dan te penaub te Eleteala igenat guntaani abpeg dut te umur ne warà edtamanan din. ");
INSERT INTO mbi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Siak ke meupiya ne tumetuganur,” ke si Hisus, “su andam a ne ebpebpatey apey kenà mekeiri ini se menge bilibili ku. ");
INSERT INTO mbi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ke etew ne edsukayan dà ne ebantey te bilibili ne kenà tidtu ne tumetuganur, ne warà kegkenuhun din kandan su kenà ma kandin ne bilibili. Ne ed-ewaan din su ebpelahuy ke ruen egkekita rin ne leew ne asu ne ebpekeuma. Ketà be ne warè en ebpekevantey kayi te bilibili, ne igketangag en te leew ne asu ini se bilibili ne ke ruma ne egurunsuwey en. ");
INSERT INTO mbi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iyan kebpelahuy rut te edsukayan dà ne ebantey su kenà tidtu ne tumetuganur, ne warà kegkenuhun din ketà te menge bilibili. ");
INSERT INTO mbi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Siaken,” ke si Hisus, “ke meupiya ne tumetuganur ne ke menge etew ne iring te menge bilibili ku. Netuenan ku ke Amey ku, ne netuenan a rin dema. Ne iring ded dema kayi te menge bilibili ku ne eduma kedì su egkekilala ku sikandan ne egkekilala a ran dema, ne andam a ne ebpebpatey te selidig kandan. ");
INSERT INTO mbi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ruen pà ruma ne menge bilibili ku,” ke si Hisus “ne warà pà kayi te lusud te tudilan. Ed-ewiten ku ve sikandan kayi te tudilan ini ne ebpemineg dan kedì, ne egkevaluy ran ne senge luyuran dà ne seveka rà dema se tumetuganur kandan su siaken dà. ");
INSERT INTO mbi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Igkelimù a te Amey ku ne Eleteala su andam a ne ebpebpatey kandan. Iyan ku kebpebpatey su apey ku metelimà ded ketà te kegkevanew ku. ");
INSERT INTO mbi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Warà a tehela te misan entei en ne etew te ebpebpatey, ugaid ne kedì en ne kiyug. Su ruen gehem ku te edselidig te umur ku, ne ruen gehem ku te ed-awì maa ketà te kegkevanew ku. Su ini ke insuhù kedì te Amey ku ne Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Guna su nerineg dut te menge Hudiyanen ini se impenurù ni Hisus ne warà dan meseveka. ");
INSERT INTO mbi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Merakel kandan se migkahi te, “Midsuukan sikandin te vusew! Ebunehen! Meambe ke ebpemineg kew kandin?” ");
INSERT INTO mbi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ugaid ne ruen duma ne migkahi te, “Embiya ma midsuukan te vusew sikandin, ne kenà iring kayi se kebpenurù din! Ne ebmemenu ve se vusew te ebpekekità ke pisek?” ");
INSERT INTO mbi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ne neuma en ke hewii te kevurunan te menge Hudiyanen ne ed-ingaranan te Edtepeney diyà te Nekebpuru ne Valey te Eleteala diyà te inged ne Hirusalim, ne arà ne hewii ne ed-uran-uran. ");
INSERT INTO mbi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ne riyà si Hisus ed-ip-ipanew te palàpalà te Nekebpuru ne Valey te Eleteala ne ed-ingeranan te Palàpalà ni Datù Salomon. ");
INSERT INTO mbi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ne rutun ne miburun ke menge egkeunutan te Hudiyanen diyà te ki Hisus su mid-insaan dan te, “Keenu key pà nikuna edteremi ke entei ka? Embiya maa sikuna en ke Edetuen ne Impasad te Eleteala, ne ikahi nu en kenami.” ");
INSERT INTO mbi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Midtavak si Hisus te, “Nekahi ku en keniyu, ugaid ne warà kew ma mebperetiyaya. Ini se mekegeyip ne ulaula ku ne insuhù kedì te Amey ku ne Eleteala ne iyan tuus te sikandin ke midsuhù kedì, ");
INSERT INTO mbi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ugaid ne warà kew ma mebperetiyaya su warà kew ma mekelusud kayi te tudilan te bilibili ku. ");
INSERT INTO mbi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Su ke menge etew ku ne timbang te bilibili ku,” ke si Hisus “ne ebpemineg dan kedì su egkekilala ren ma ke suwara ku. Egkekilala ku sikandan ne eduma ran kedì. ");
INSERT INTO mbi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ebehayan ku sikandan te umur ne warà edtamanan din wey kenà en ebpatey ke gimukud dan, ne warà senge etew rà ne ebpekeahew kandan dut te edtingkungan te palad ku,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Su iyan mibehey kandan kedì ne ke Amey ku ne Eleteala ne warà repeng se gehem din, ne warà senge etew rà ne ebpekeahew kandan dut te edtingkungan te palad din. ");
INSERT INTO mbi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Su seveka key rà dut te Amey ku ne Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Guna su nerineg te menge Hudiyanen ke lalag ni Hisus ne mibpemurut dan en maa te menge batu su idrumbag dan kandin. ");
INSERT INTO mbi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ne migkahi si Hisus te, “Merakel se impekita ku keniyu ne meupiya ne ulaula ku ne insuhù kedì te Amey ku ne Eleteala. Ne endei ve rapit ne ulaula ku ke rait ne idrumbeha niyu kedì te batu?” ");
INSERT INTO mbi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Kenà iyan dey idrumbag keykew te batu,” ke se menge Hudiyanen “ne ayan se meupiya ne ulaula nu, ugaid ne ayan se kedsumpalit nu te Eleteala. Su egkahi ka te Eleteala ka, ugaid ne etew ke rà ma!” ");
INSERT INTO mbi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne migkahi si Hisus kandan te, “Ruen impesurat diyà te keniyu ne penduan te migkahi ke Eleteala, ‘Ragid kew kedì ne Eleteala.’ ");
INSERT INTO mbi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Netuenan tew,” ke si Hisus, “ke impesurat ne Lalag te Eleteala ne benar ne warà kegkesembii rin taman te taman su migkahi rin te imperagid dan te Eleteala ke menge keep-epuan tew ne mibehayan din dut te lalag din. ");
INSERT INTO mbi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Su siaken, ne mibpemilì a te Amey ku ne Eleteala ne impepengkayi a te ampew te dunya, ne meambe ke egkekahi niyu se edsumpeliten ku ke Eleteala embiya egkehiyen ku te Anak a te Eleteala? ");
INSERT INTO mbi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iyan ku ebeelan ne arà se insuhù kedì te Amey ku ne Eleteala, ugaid ne embiya kenà ne kenà a niyu peretiyayaa. ");
INSERT INTO mbi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ugaid ne embiya iyan ku ebeelan ne arà se insuhù din kedì, ne misan kenà kew ebperetiyaya te menge lalag ku ne peretiyaya kew kayi te menge baal ku ne mekegeyiip ne ebpuun te gehem din. Su kayi niyu egketueni te seveka key rà, siaken wey ke Amey ku, su kayi sikandin te kedì, ne riyan e rema te kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nerineg den dà ke lalag ni Hisus ne edsigkemen dan en maa perem, ugaid ne nekelihawang ma sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ketà be ne mid-awà en si Hisus kayi te inged ne Hirusalim ne mid-apet te wayig ne Hurdan ne mibpendiyà te inged ne mipebunyahan ni Juan dengan, ne ketà mid-ubpà sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Merakel ne menge etew se mibpendiyà te kandin ne ebpeleglelahey ran te, “Warà mekegeyip ne mid-ulaula rengan ni Juan, ugaid ne langun ne migkahi rin mekeatag te ini ne etew ne benar iya.” ");
INSERT INTO mbi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne merakel ne etew se mibperetiyaya kandin. ");
INSERT INTO mbi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Duen meama ne edaru ne ed-ingaranan ki Lasaru ne riyà ed-ubpà te inged ne Bitanya. Duen deruwa ne etevey rin ne dutun ded dema ed-ubpà ne ed-ingaranan ki Maria wey si Marta. ");
INSERT INTO mbi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Si Maria ini ke meritan ne mibùbù te periyemut diyà te paa ni Hisus ne mibpunas din te bulvul din. Ne meeman din arà se ederaru ne si Lasaru.) ");
INSERT INTO mbi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mibpesuhuan kayi te deruwa ne etevey ni Lasaru si Hisus ne iyan dan intelaan se, “Mama, ebpekedaru ini se sepekat nu ne igkelimù nu nevenar.” ");
INSERT INTO mbi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Guna su nerineg ni Hisus ne migkahi te, “Ini se daru ni Lasaru ne kenà pà ini ke ibpatey rin, ugaid ne iyan din kebpekedaru su apey iyan egkereyù ne ke Eleteala wey siak dema ke Anak din ne egkereyù.” ");
INSERT INTO mbi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Dekelà te hinawa ni Hisus ensi Marta ki Maria wey si Lasaru. ");
INSERT INTO mbi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ugaid ne misan iring ketà, ne nerineg din te edaru si Lasaru ne mid-ubpà pà lavew sikandin te nekederuwa ne hewii. ");
INSERT INTO mbi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nepupus pè be arà ne migkehiyan din ke edumdumaan din te, “Kuwa kew en su edlived kiyu maa diyà te lusud te inged ne Hudiya.” ");
INSERT INTO mbi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Meyterù,” ke se menge edumdumaan din, “warà pà utew meuhet se kedrumbaha ran perem keykew te batu. Ne meambe ke edlived ke en maa?” ");
INSERT INTO mbi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ne migkahi si Hisus te sempità din te, “Maa, kenà sepulù wey deruwa ne uras te senge keandew? Ne embiya ed-ipanew ki te meandew ne kenà ki ebpekesiud su ruen ma rayag ne ebpeketayew keyta. ");
INSERT INTO mbi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ugaid ne embiya ed-ipanew ki te merukilem ne ebpekesiud ki su merusirem en ma ne kenà ki en ebpekekita.” ");
INSERT INTO mbi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iring ketà se nekahi ni Hisus te sempità din ne migkahi en maa te, “Nekelipereng en arà se sepekat tew ne si Lasaru, ugaid ne ebpendiyan a su apey ku mepukew sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Midtavak ke edumdumaan din te, “Embiya nekelipereng dà sikandin ne meupiya su egkeulian ded sikandin.” ");
INSERT INTO mbi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iyan meana te migkahi ni Hisus ne minatey en si Lasaru, ugaid ne kunaan dan ke andang dà ne kedlipereng arà se egkehiyen din. ");
INSERT INTO mbi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Arà dà ne impayag ni Hisus kandan te, “Minatey en si Lasaru, ");
INSERT INTO mbi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ugaid ne apey kew mekeperetiyaya ketà te ked-uyaha ku kandin, ne meupiya su warà a ketà te kinepatey rin. Kuwa kew embe su ebpendiyà kiyu te kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dutun ne senge etew ne edumdumaan din ne ed-ingaranan ki Tomas (ne mid-ingaranan dan dema te Seping) se migkahi riyà te menge ruma rin te, “Eduma kiyu kandin su apey ki ebpekeunung kandin te ebpatey.” ");
INSERT INTO mbi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Guna su nekeuma en si Hisus diyà te Bitanya ne nerineg din en te neked-epat en ne hewii se kineleveng ki Lasaru. ");
INSERT INTO mbi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ini se inged ne Bitanya ne uvey red te inged ne Hirusalim su menge tetelu buwa ne kilù se elet din. ");
INSERT INTO mbi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne merakel ne Hudiyanen se riyà ebpuun te Hirusalim ne mibpendiyà te engki Marta wey ki Maria su edlenganen dan dut te kinepatey te meeman dan. ");
INSERT INTO mbi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Guna su nerineg ni Marta se ebpekeuma en si Hisus ne midsinuhung din en, ugaid ne si Maria ne riya ded te valey. ");
INSERT INTO mbi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne migkahi si Marta diyà te ki Hisus te, “Mama, embiya kayi ke rà perem ne kenà ded ebpatey ke meeman ku. ");
INSERT INTO mbi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ugaid ne netuenan ku te misan guntaani ke ruen ebuyuen nu te Eleteala ne ibehey rin keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Egkevanew red arà se meeman nu,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Uya,” ke si Marta, “netuenan ku se egkevanew red sikandin keuremà dut te kebenawa te menge minatey ketà te mewri ne hewii.” ");
INSERT INTO mbi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ne migkahi si Hisus te, “Iyan a imbe ke ebpembanhew ne iyan a imbe ebpuunan te umur ne warà edtamanan din. Ke etew ne ebperetiyaya kedì ne misan ebpatey sikandin ne biviyag ded ke gimukud din ne ed-ubpà diyà te Eleteala taman te taman. ");
INSERT INTO mbi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Su ke etew ne ebperetiyaya kedì,” ke si Hisus, “ne ruen umur din ne warà edtemanan din wey kenà en ebpatey ke himukud din. Menu, Bayi, ebperetiyaya ke en be kayi?” ");
INSERT INTO mbi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ne midtavak si Marta te, “Uya, mibperetiyaya a te sikuna ke Impasad te Eleteala ne Ebperetuen, ke Anak din ne impepengkayi rin te ampew te dunya.” ");
INSERT INTO mbi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Guna su nekahi arà ni Marta ne mid-ulì en ne midnènaasan din si Maria te, “Keniyan en si Hisus ne in-insà ka rin.” ");
INSERT INTO mbi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nerineg dà ni Maria ne mid-itindeg ne migaangaan se edsinuhung ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Warà pà mekeuma si Hisus kayi te inged dan su diyà pà lavew sikandin te nesinehungan ni Marta.) ");
INSERT INTO mbi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Guna su nekita dut te menge Hudiyanen ne edlangan ki Maria te kayi pà te valey te nekeitindeg su edlihawang ne midtundug dan su iyan dan kunaan ke ebpendiyà te leveng su riyà sikandin edsinehew. ");
INSERT INTO mbi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nekeuma rà si Maria riyà te ki Hisus ne mid-uvey rin en ne midlangkeb sikandin se edsinehew. Ke sikandin te, “Mama, embiya kayi ke rà perem ne kenà ded perem ebpatey ke meeman ku.” ");
INSERT INTO mbi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Guna su nekita ni Hisus se edsinehew si Maria, wey midsinehew dema ke menge Hudiyanen ne miduma kandin, ne mibmeraat ke nanam din te kegkeyru rin. Ne ed-eleg-ehen en sikandin se egkahi te, ");
INSERT INTO mbi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Endei niyu ileveng?” Ne midtavak dan te, “Kayi ke en, Mama, su ebayaan tew.” ");
INSERT INTO mbi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ketà ne nekesinehew en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","“Intengi niyu ma,” ke se menge Hudiyanen, “igkelimù nevenar ni Hisus si Lasaru.” ");
INSERT INTO mbi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ugaid ne ruen migkahi te, “Maa, kenà ini ke etew ne nekeulì te pisek ne meama? Embiya nekeulì sikandin te pisek, ne meambe ke warà din bawii si Lasaru su apey warà mebpatey?” ");
INSERT INTO mbi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ne mibmeraat en maa ke nanam ni Hisus te kegkeyru rin ketà te nekeuvey en sikandin dut te leveng. Ini se leveng ne riyà te surung, ne ruen dekelà ne batu ne in-alang dut te humawan. ");
INSERT INTO mbi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Iawà niyu ayan se batu!” ke si Hisus. Ne migkahi si Marta ke etevey dut te minatey te, “Mama, memawù en su neked-epat en ne andew ini se kineleveng kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Migkahi ku en keykew te embiya ebperetiyaya ka ne egkekita nu arà se ebpekereyù te Eleteala,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ketà ne midlilid dan en ke batu ne in-alang ne midlingakà en si Hisus diyà te langit se ebpengeningeni te, “Dekelà se kegkereyù ku keykew, Amey ku, su ebpeminehen nu ini se ebuyuen ku. ");
INSERT INTO mbi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Netuenan ku te lelayun ka ebpemineg kedì, ugaid ne iyan ku kebpengeningeni guntaani su apey ebpekeperetiyaya ke menge etew ne ini te uvey ku te sikuna ke midsuhù kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nekeipus sikandin se egkahi ne mid-umew rin te merahing ne suwara te, “E, Lasaru, lihawang ke en.” ");
INSERT INTO mbi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Arà dà ne migemew en ke minatey su nevanew en. Ne nevukusan te saput ke lawa rin abpeg ke velad din wey ke paa rin, ne misan ke vuked din ne nevukusan dema te saput. “Ewai niyu sikandin te bukus,” ke si Hisus, “su apey ebpekewaleng.” ");
INSERT INTO mbi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Merakel dut te menge Hudiyanen ne miduma ki Maria se nekekita rut te mid-ulaula ni Hisus ne mibperetiyaya kandin. ");
INSERT INTO mbi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ugaid ne ruen duma kandan ne mibpendiyà te menge Peresiyu su ebpenudtul dut te mid-ulaula ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Arà dà ne mibpendiyà ke menge mepurù te terebpelengesa wey ke menge Peresiyu su eburun diyà te menge pekilukesen te Hudiyanen. Guna su nevurun dan en ne migkahi ran te, “Engkey se ed-ul-ulaan tew? Su merakel se mekegeyip ne ed-ul-ulaan ni Hisus! ");
INSERT INTO mbi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Embiya ebpedterayen tew sikandin ne langun ne menge etew ne ebperetiyaya en te sikandin ke Impasad te Eleteala ne Ebperetuen. Ne embiya iring en ketà, ne egkerineg dut te egkeunutan tew ne riyà te Ruma ne ebpeveyaan ki te menge sundaru ran ne edereetan dan ini se Nekebpuru ne Valey te Eleteala wey ini se pehinged tew te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ketà ne migkahi ini se senge etew ne mepurù te terebpelengesa ne ed-ingaranan ki Keyipas, su ketà ne hewii ne sikandin ke pinekemepurù te langun ne menge terebpelengesa, ke sikandin te, “Warà menge itungan niyu! ");
INSERT INTO mbi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Warà niyu ves mesebuti te iyan dà tumù ne senge etew rà se ebpatey tumin dè be ke langun ne menge Hudiyanen su apey kenà mereeti ini se pehinged tew te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Migkahi rin ini te kenà kandin dà ne itungan, ugaid ne geina te sikandin ke pinekemepurù dut te langun ne menge terebpelengesa te arà ne hewii ne nekekahi sikandin neraan te si Hisus se ebpatey ne idselidig te langun ne menge Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne kenà ke menge Hudiyanen dà se egkeselidigan te kebpatey rin, ugaid ne apey langun ne nevaluy ne anak te Eleteala ne egkevurun te egkeseveka misan endei ne menge inged.) ");
INSERT INTO mbi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ne igenat dè be ketà ne andew ne mibpemengà en te menge egkeunutan te Hudiyanen te ralan te ked-imatey ran ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tembù be warà en mebpekitakita si Hisus dut te merakel ne etew ketà te inged ne Hudiya, ugaid ne mibpendiyà sikandin te inged ne ed-ingaranan te Ipraim uvey te tanà ne kenà egkeubpaan te etew. Ne ketà sikandin med-ubpà wey ke edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ne ebpelundani en ke kevurunan te menge Hudiyanen ne ed-ingaranan te Pista te Kedsehari te Suluhuen. Ne merakel en ne menge etew ne ebpuun te ebalàbalà ne menge inged se ebpenekereg dan diyà te Hirusalim su edtumanen dan ke betasan te menge Hudiyanen mekeatag te kebpenlùlù su apey ran ebpekeamung dut te kevurunan. ");
INSERT INTO mbi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mibpemengà dan si Hisus ne gewii ran te egkevurun diyà te Nekebpuru ne Valey te Eleteala ne mibpein-inseey ran te, “Engkey se antap niyu, ebpengkayi red buwa si Hisus etawa kenà?” ");
INSERT INTO mbi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ruen insuhù te menge mepurù te terebpelengesa wey ke menge Peresiyu te piya engkey se egketau ke endei si Hisus ne igkahi kandan su apey ran igkepesigkem. ");
INSERT INTO mbi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Enem pà ne hewii ne egkeuma ke kevurunan ne ed-ingaranan te Pista te Kedsehari te Suluhuen ne mibpendiyà si Hisus te inged ne Bitanya, ke inged ni Lasaru ke mibanew rin. ");
INSERT INTO mbi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ketà te valey ni Lasaru ne mibair dan te kevurunan su igalewhalew ran ki Hisus. Si Marta se ebpenendad ne elin ketà si Lasaru wey si Hisus se ebpengaan. ");
INSERT INTO mbi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ne migkuwa ni Maria ini se dekelà ne pelenaan te periyemut ne mepurù nevenar su mibeelan dut te ed-ingaranan te Nardu. Ne mid-uvey rin si Hisus ne imbùbù din diyà te paa rin, ne mibpunasan din te bulvul din. Ne nekeeneb kayi te lusud te baley te keemut din. ");
INSERT INTO mbi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne seveka rut te edumdumaan ni Hisus, si Hudas Iskeriyuti ke ed-ulug kandin, se midlalag ki Hisus te, ");
INSERT INTO mbi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Babeba!” ke sikandin. “Nerèdeetan ini su pira buwa nehatus se elehà din? Iyan tumù ne indehang ini se periyemut ne ke elehà din ne igkepemehey riyà te menge etew ne ayuayu.” ");
INSERT INTO mbi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kenà iyan din kinekahi te iring ketà ne ke kegkeyru rin dut te menge ayuayu, ugaid ne tekawen sikandin. Su sikandin ke ebpetugenuren dut te edtehuan te kureta en ni Hisus, ugaid ne ebpengpenguan din mulà. ");
INSERT INTO mbi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ugaid ne migkahi si Hisus te, “Pedteraya niyu sikandin! Ne ibpetahù ded kandin ke samà ne periyemut su apey ruen idsapu rin te lawa ku ketà te idleveng ad. ");
INSERT INTO mbi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Su ke menge ayuayu ne lelayun kew red ebpemekeduma ne egketevangan niyu sikandan, ugaid ne siak ne kenà ad meuhet kayi te keniyu.” ");
INSERT INTO mbi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nerineg dut te merakel ne menge Hudiyanen te riyà si Hisus te inged ne Bitanya ne mibpemendiyà dan. Ne kenà iyan dan dà kinependiyà ne mekeatag ki Hisus, ugaid ne iyan dan dema ed-intengan ne si Lasaru ke mibanew rin. ");
INSERT INTO mbi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ne iyan netahù te itungan te menge unuten te terebpelengesa ne ebpeimetayan dema si Lasaru. ");
INSERT INTO mbi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Su atag te kinekevanew kandin ne merakel ne Hudiyanen se midsuwey en dut te ibpenurù dan su kayi ran en mibperetiyaya ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Guna su nepawè en ne nerineg dut te merakel ne menge etew ne edtelavuk te kevurunan te Hirusalim se ebpekeuma kun si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne mibpenguwa ran te dawun te menge niyug ne midsinuhung dan si Hisus se egkerag te, “Edeyuen tew ke Eleteala! Ne menu ma ke ebpeneuven te Eleteala ini se ebpekeuma, su midsuhù din te ralan te ketengdanan din. Menu ebpeneuven te Eleteala ini se nepemilì ne Ebperetuen te menge kevuwaran ni Israyil!” ");
INSERT INTO mbi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ne migkuwa ni Hisus se nati ne kudà ne mid-untud sikandin iring dut te impesurat ne Lalag te Eleteala ne egkahi te, ");
INSERT INTO mbi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sikiyu ne mehinged te Hirusalim, kenà kew meandek! Su ebpekeuma en ini ke ratù niyu ne ed-untud te nati te kudà.” ");
INSERT INTO mbi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ketà ne hewii ne warà mesebuti ini rut te edumdumaan din. Ugaid ne guna su nevanew en si Hisus wey nevantun en diyà te langit, ne netenuran dan arà se kedlusud ni Hisus diyà te Hirusalim ne netuman ke impesurat ne Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ini se menge etew ne nekekita ki Hisus te ked-umawa rin wey kebenawa rin ki Lasaru ne mibpemenudtul. ");
INSERT INTO mbi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tembù be mibpenelavuk ke merakel ne etew ki Hisus su nerineg dan ini se ulaula rin ne mekegeyip. ");
INSERT INTO mbi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Guna su nekita rut te menge Peresiyu ke denda ne etew ne edtelavuk ki Hisus ne mibpeleglelahey ran te, “Tengteng kew be, warà en bes egkegaga tew! Su ke denda ne etew ne eduma en kandin!” ");
INSERT INTO mbi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ne ruen menge Gerisihanun ne mibpekiduma te menge Hudiyanen te ebpendiyà te Hirusalim su edtelavuk dan dema te pista ne ebpengarap dan te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mibpendiyà dan te ki Felipe, senge etew ne ruma ni Hisus ne riyà ebpuun te inged ne Bitsaida lusud te inged ne Geliliya, ke sikandan te, “Egkesuat key ne ebpekibalak ki Hisus.” ");
INSERT INTO mbi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ne intarem ini ni Felipe riyà te ki Andres. Ne rutun ne mibperumeey ran en se ebpendiyà te ki Hisus ne mibpenudtul dan kandin. ");
INSERT INTO mbi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Migkahi si Hisus te, “Neuma en ke hewii te ebpekeulì ke Impeanak te Menusiyà diyà te Amey rin su ebeheyan rut te kandin ne bentuhan. ");
INSERT INTO mbi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sebenarvenar ini se egkehiyen ku keniyu: embiya kenà ibpemula ini se senge lahas ne venì diyà te tanà ne kenà egkeumanan su senge lahas dè ma. Ugaid ne embiya ibpemula en, ne edtuvù ne ebehas te merakel. Iring ded dema ketà te siak,” ke si Hisus, “su embiya igkeleveng ad ne merakel se egkevehayan te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Embiya ruen etew ne iyan din ebpekinuhunan se umur din ne kayi te ampew te dunya, ne nasì ne egkewarà kandin. Ugaid ne ke etew ne edtuman te kiyug ku su warà kebpekinuhun din te umur din kayi te ampew te dunya, ne ebpeketelimà te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Su ke etew ne egkiyug ne eduma te penurù ku,” ke si Hisus, “ne iyan din ibpeuna te hinawa rin te ked-iniyug din te kandin ne kiyug su apey mekeruma kedì, ne piya endei a ne ketà dema ke edsugsuhuen ku. Ne ke etew ne edtuman te penurù ku, ne egkereyù te Amey ku ne Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ne migkahi pà maa si Hisus dut te edumdumaan din te, “Egkevehatan nevenar se hinawa ku guntaani. Engkey vuwa se egkehiyen ku te kebpengeningeni ku ki Amà? Maa, iyan ku ebuyuen kandin te kenà a meked-ulaula te ini se merasey ne ebpekeuma? Kenà! Su iyan ku impengkayi te ampew te dunya ne ed-etuvangen ku iya ini se merasey.” ");
INSERT INTO mbi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne ketà ne migkahi en sikandin dut te amey rin te, “Amà, ipekita nu ke bentuhan nu kayi te menge etew!” Ne ruen en suwara ne riyà ebpuun te langit ne migkahi te, “Impekita ku en ke kegkevantug ku ketà te mid-ulaula nu, ne ibpekita ku pà maa ini se kegkevantug ku kayi te ed-ul-ulaan nu.” ");
INSERT INTO mbi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ne ketà ne merakel se menge etew ne nekerineg te suwara ne ruen migkahi te, “Miduruhung!” Ne ruen ruma ne migkahi te, “Suluhuen te Eleteala ne mibpekidlalag ki Hisus.” ");
INSERT INTO mbi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ne migkahi si Hisus te, “Kenà iyan kinekahi te Eleteala ne ruen ibpayag din kedì, ugaid ne apey niyu egketueni te ebpeminehen a rin. ");
INSERT INTO mbi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ini en ke hewii te kegkukum te Eleteala te langun ne menusiyà kayi te ampew te dunya ne kunterà din. Egketalew en si Setanas ke datù te pekaid ne midatù kayi te ampew te dunya. ");
INSERT INTO mbi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ne siak, embiya idtunggul ad diyà te pinebelavag ne kayu ne ebpuyuken ku ke langun ne menge etew te ebpengkayi te kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ini se migkahi ni Hisus ne impayag din ke ralan te ked-imetayi kandin.) ");
INSERT INTO mbi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Migkahi ke merakel ne etew te, “Iyan tew nesebutan kayi te impesurat ne Lalag te Eleteala ne kenà ebpatey ke Impasad te Eleteala ne Ebperetuen din. Ne meambe maa ke migkahi ka te sikuna ke Impeanak te Menusiyà ne idtunggul ka riyà te pinebelavag ne kayu? Embiya iring ketà, ne engkey ma ini se Impeanak te Menusiyà?” ");
INSERT INTO mbi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne midtavak ni Hisus te sempità ne, “Ke sulù ne ebpekerayag te itungan niyu ne kayi en te keniyu, ugaid ne kenà en meuhet ne ed-awà. Ne taman te kayi pà te keniyu ke sulù ne rumai niyu su apey kew kenà meuma te merusirem, su ke etew ne ed-ipanew diyà te merusirem ne kenà ebpeketuntul te ibayà din. ");
INSERT INTO mbi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Taman te kayi pà te keniyu ke sulù, ne serihi niyu su apey kew ebpekehemew te kerayahan.” Neipus ni Hisus se kinelalag din ketà ne mid-awà en ne mid-eles kandan. ");
INSERT INTO mbi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Misan merakel en ne mekegeyip ne mid-ulaula rin ne nekita ran ne warà dan mebperetiyaya kandin, ");
INSERT INTO mbi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","su apey egketuman en ke migkahi ni Isayas ke ebpelambas te lalag te Eleteala rengan ne egkahi te, “Eleteala, warà utew mibperetiyaya te impesabut dey! Warà utew midsabut rut te gehem ne impekita nu kandan!” ");
INSERT INTO mbi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ne ruen dema ingkahi ni Isayas mekeatag te kenà dan kebpekeperetiyaya, ke sikandin te, ");
INSERT INTO mbi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mibpelekapan dan te Eleteala su apey kenà dan ebpekekita. Ne mibpekeresen ke itungan dan su apey ran kenà ebpekesabut. Ne iyan pè be se ked-uvey ran kedì te ebperetiyaya su apey ku igkepeliyu sikandan!” ");
INSERT INTO mbi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Migkahi ini ni Isayas su netuenan din dengan ke rekelà ne gehem ni Hisus ke Ibpeanak te Menusiyà ne ini se edlalag din mekeatag kandin. ");
INSERT INTO mbi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Misan iring ketà se lalag ni Isayas ne ruen ded lavew merakel ne menge egkeunutan te Hudiyanen ne mibperetiyaya ki Hisus. Ugaid ne warà dan mebpepayag su neandek dan dut te menge Peresiyu ke ibpeawà dan na kenà dan ebpekelusud dut te baley ne ebpengedian te menge Hudiyanen te penduan dan. ");
INSERT INTO mbi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Su iyan dan pinedlabi ke kedeyù kandan te menge etew, tumin dè be ke kedeyù te Eleteala kandan. ");
INSERT INTO mbi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ne impekerahing ni Hisus se kegkahi rin te, “Entei se mibperetiyaya kedì, ne kenà siaken dà se ebperetiyayaen din su elin ded dema ke midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne entei se nekekita kediey ne nekekita red dema sikandin dut te Amey ku ne Eleteala ne midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mibpengkayi a ne kerayag kayi te ampew te dunya su apey ku egkereyahi ke itungan dut te menge etew su apey ke langun ne ebperetiyaya kedì ne kenè en egkerusireman ke itungan dan. ");
INSERT INTO mbi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Piya entei ne nekerineg te menge lalag ku ugaid ne kenà din edtumanen,” ke si Hisus, “ne kenà siaken se ed-isuhat kandin te kerusaan. Su kenà iyan ku impengkayi ne ed-isuhat te kerusaan kandan, ugaid ne apey ran ebpekepeliyu dut te kerusaan dan. ");
INSERT INTO mbi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ugaid ne ruen ed-isuhat te kerusaan dut te menge etew ne mid-engkenà kedì wey warà medtelimà te menge lalag ku. Su ini se menge lalag ku ne warà dan telimaa ne ini red se ed-isuhat te kerusaan kandin ketà te mewri ne hewii. ");
INSERT INTO mbi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uya, su ini se menge lalag ku ne kenà kayi ebpuun te kediey rà,” ke si Hisus, “ugaid ne insuhù kedì te ibpelalag dut te Amey ku ne Eleteala ne iyan midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Su netuenan ku te ini se insuhù din kedì te ibpelalag ne ini en iya ke ebpekevehey te umur ne warà edtemanan din. Ketà ne iyan ku rà egkehiyen ne engkey se ibpelalag din kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Senge hewii pà ne egketuman ke kevurunan te menge Hudiyanen ne ed-ingaranan te Pista te Kedsehari te Suluhuen. Netuenan ni Hisus se neuma en ke hewii ne ked-awà din kayi te ampew te dunya su ed-ulì en diyà te Amey rin ne Eleteala. Dekdekelà ke limù din dut te langun ne menge etew kayi te ampew te dunya ne midtelimà kandin, ugaid ne guntaani ne impekita rin kandan ke rimahas te limù din kandan. ");
INSERT INTO mbi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Guna su meapun en ne edlavung pà ensi Hisus wey ke edumdumaan din, ne neketahù en si Setanas ke datù te pekaid diyà te itungan ni Hudas ke anak ni Simon Iskeriyuti te ed-ulug ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ugaid ne netuenan ni Hisus te imbehey en kandin dut te Amey rin ke kebayàbayà te langun taman. Netuenan din dema se riyà ebpuun sikandin te Eleteala, ne riyà ded lavew ed-ulì. ");
INSERT INTO mbi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ne mid-itindeg si Hisus ketà te egkeenan dan ne midluung din ke kumbalà din ne impipinding din ke tuwalya. ");
INSERT INTO mbi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Neipus din arà ne migkuwa rin se pelenggana ne mibusbusan din te wayig, ne mibpenlùluan din ke menge paa te edumdumaan din ne mibpemunasan din dut te tuwalya rin. ");
INSERT INTO mbi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mid-uvey sikandin ki Simon ne mid-ingaranan ki Pedro, ne migkahi en si Pedro te, “Sikuna se Kerenan dey, na engkey sikuna ves maa se edlùlù te paa ku?” ");
INSERT INTO mbi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne midtavak si Hisus te, “Ini se ed-ul-ulaan ku guntaani ne kenà nu pà iya egkesebutan, ugaid ne iseg-iseg ne egkesebutan nu red.” ");
INSERT INTO mbi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ke si Pedro te, “Kenà egkepakey ne iyan ka ebpenlùlù te paa ku!” Ne migkahi si Hisus te, “Embiya kenà ku edlùluan ke paa nu, ne kenà ke en ruma dut te edumdumaan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne nekekahi si Pedro te, “Embiya ves iring ketà, ne kenà iyan nu rà lùlui ini se paa ku su misan ini se velad ku wey ulu ku rema.” ");
INSERT INTO mbi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Migkahi si Hisus te, “Ke etew ne nekepemihù en ne metilak en, ne iyan dà edlùluan ke menge paa rin su ruen lipupuk din. Iring ded dema te sikiyu su langun niyu ne netilak en ke itungan niyu liyu ketà te senge etew keniyu.” ");
INSERT INTO mbi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Su netuenan din en ke engkey arà se ed-ulug kandin tembù be migkahi sikandin te, “Langun niyu ne metilak en liyu ketà te senge etew.”) ");
INSERT INTO mbi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Guna su nekeipus si Hisus te edlùlù te paa ran ne inseluub din en maa ke kumbalà din ne midlived sikandin ketà te ebpinuuwan din te egkaan. Ne mid-insaan din ke edumdumaan din te, “Maa, nesebutan niyu ve ini se mid-ulaula ku keniyu? ");
INSERT INTO mbi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iyan niyu id-umew kedì ne ke Meyterù niyu wey ke Kerenan niyu, ne benar ma iya arà. ");
INSERT INTO mbi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Su embiya siaken ke Kerenan niyu wey ke Meyterù niyu se mibpenlùlù te paa niyu ne dait ne pelùlùluey kew rema te menge paa niyu. ");
INSERT INTO mbi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Su ini se impekita ku keniyu,” ke si Hisus, “ne ledawan keniyu su apey niyu egkeiringi riyà dut te menge ruma niyu. ");
INSERT INTO mbi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Sebenarvenar ini se egkehiyen ku, warà uripen ne iyan en mepurù dut te ebpengunguripen kandin. Iring ded dema dut te edsugsuhuen, kenà iyan mepurù sikandin dut te edsuhùsuhù kandin. ");
INSERT INTO mbi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Embiya egkesebutan niyu en ini se penurù ku keniyu, ne igkehalew niyu nevenar ke egkerumaan niyu! ");
INSERT INTO mbi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kenà langun niyu se egkesuhat kayi te edlelehan ku,” ke si Hisus, “su netuenan ku ke engkey se netahù te hinawa te uman seveka keniyu ne mibpemilì ku, ne netuenan ku ke engkey se ebpulid kedì te menge kunterà ku. Ugaid ne ruen impesurat ne Lalag te Eleteala rengan ne egketuman en ne egkahi te, Ke etew ne mibpekidtuhen kedì ne iyan ded nevaluy ne kunterà ku. ");
INSERT INTO mbi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Tembù be ebpeketuenan ku ini keniyu te warà pà med-ulaula su apey ketà te hewii te kegkeuma rin ne ebpekeperetiyaya kew te siaken iya ke intarem ku keniyu ne impasad te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sebenarvenar ini se egkehiyen ku,” ke si Hisus, “misan entei ne etew se edtelimà dut te edsuhuen ku, ne siaken se midtelimà din dema. Ne ke etew ne edtelimà kediey ne midtelimà din dema ke Amey ku ne midsuhù kediey.” ");
INSERT INTO mbi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nekeipus si Hisus se edlalag ne mibmerungkug nevenar sikandin ne impayag din dut te menge edumdumaan din te, “Sebenarvenar ini se egkehiyen ku keniyu te ruen senge etew kayi te keniyu ne ed-ulug kediey su apey a meimetayi.” ");
INSERT INTO mbi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nerineg dut te menge edumdumaan din ne nekedsirà dan su warà dan metueni ke engkey ini se ibpesabut din. ");
INSERT INTO mbi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ne ruen durug ni Hisus te ebpinuu ne seveka rut te edumdumaan din ne igkelimù din nevenar. ");
INSERT INTO mbi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Arà be ke mid-uyewan ni Simun Pedro te, “Insai nu si Hisus ke entei ini se egkehiyen din.” ");
INSERT INTO mbi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ne midsandig sikandin ki Hisus ne mid-insaen din en te, “Entei ma se ed-ulug keykew, Kerenan?” ");
INSERT INTO mbi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Midtavak si Hisus te, “Ideluwit ku ini se pan kayi te savew ne endei ve ketà se ebehayan ku ne arà imbe sikandin.” Arà dà ne indeluwit din en ke pan dut te savew ne imbehey rin en ki Hudas ke anak ni Simon Iskeriyuti. ");
INSERT INTO mbi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Guna su migkuwa ni Hudas ke pan, ne mid-awuk en kandin si Setanas ke datù te pekaid. Ne migkehiyan en ni Hisus sikandin te, “Ini se ed-ul-ulaan nu ne gègeeni nu en!” ");
INSERT INTO mbi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Langun dut te edumdumaan ni Hisus ne warà dan mesebuti ke migkahi rin. ");
INSERT INTO mbi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne geina te si Hudas ke ebpetugenuren rut te edtehuan te kureta ran ne ruen edumdumaan din ne nekepegitung te midsuhù ni Hisus sikandin te ebpepemasa te igastu ran te pista etawa ebpevehayen ni Hisus diyà te menge ayuayu. ");
INSERT INTO mbi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Migkaan ni Hudas ke pan ne midlihawang en, ne merukilem en ketà. ");
INSERT INTO mbi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Guna su migenat en si Hudas ne migkahi en si Hisus dut te edumdumaan din te, “Mehaan en egkekita ke memenu kerekelà ke gehem dut te Impeanak te Menusiyà. Ne kayi ebpuun te kedtuman din te kiyug te Amey rin ne egkekita red dema ke kerekelà te gehem te Amey rin ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne embiya egkekita ke kerekelà ne gehem te Eleteala kayi te kedtuman te Anak din te kiyug din, ne ibpekita rema te Amey rin ke kerekelà te gehem ku, ne ini ne mehaan en egked-ulaula. ");
INSERT INTO mbi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Sikiyu se edumdumaan ku,” ke si Hisus, “ne iring te menge anak ku, ne kenè en meuhet ne warà ad kayi te keniyu. Ketà ne ebpemengà kew kedì, ne ini se egkehiyen ku keniyu guntaani ne iring dut te intarem ku rut te menge Hudiyanen te, ‘Kenà kew ebpekependiyà te ebpesineruwan ku.’ ");
INSERT INTO mbi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Na, ruen behu ne suhù ne ibpetuman ku keniyu te iyan iya se pelimlimuey kew. Iring dut te kegkelimù ku keniyu ne arà se iringi niyu te kebpelimlimuey niyu. ");
INSERT INTO mbi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Embiya ebpelimlimuey kew,” ke si Hisus, “ne egkekita te langun ne menge etew te sikiyu ne menge edumdumaan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mid-insà si Simon Pedro ki Hisus te, “Ebpendei ke ma?” Midtavak si Hisus te, “Kenà ke pà ebpekeruma diyà te ebpesineruwan ku, ugaid ne egketaman ne ebpeketelukun ke red.” ");
INSERT INTO mbi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Kerenan,” ke si Simon Pedro, “meambe ke kenà a ebpekeruma keykew guntaani? Kenà ku sikew ed-ewaan su ebpekid-unung a kenikew te ebpatey.” ");
INSERT INTO mbi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Migkahi si Hisus te, “Maa, ebpekid-unung ka kedì te ebpatey? Sebenarvenar ini se egkehiyen ku keykew te kenà pà ed-ukarà ke manuk, ne ketetelu nu en ibparew te kenà a nu egkekilala.” ");
INSERT INTO mbi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne migkahi pà maa si Hisus dut te edumdumaan din te, “Kenà kew egkeuru. Sarig kew te Eleteala wey sarig kew red dema kediey. ");
INSERT INTO mbi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Merakel se egkeubpaan diyà te baley te Amey ku, ne ebpendiyan a su ebpenehana a te egkeubpaan niyu. Su kenà ku egkehiyen ini keniyu embiya kenà benar. ");
INSERT INTO mbi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne embiya ebpekependiyan ad,” ke si Hisus, “ne egkepenehenaan ku en sikiyu te ubpaan niyu, ne edlived a kayi su ebpeneheewiten ku sikiyu su apey misan endei a ne ketà kew red dema. ");
INSERT INTO mbi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Netuenan niyu en ke ibayà diyà te ebpesineruwan ku.” ");
INSERT INTO mbi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Migkahi si Tomas te, “Kerenan, warà dey metueni ke endei ka ebpesinaru! Ne memenu ve se kegketueni rey te ralan ketà?” ");
INSERT INTO mbi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Midtavak si Hisus te, “Siaken ke ralan te Eleteala, siaken ke ebpuunan te benar, ne siaken ded ke ebpuunan te umur ne warà edtemanan din. Warà etew ne ebpekependiyà te Amey ku embiya kenà kayi ebpevayà te kediey. ");
INSERT INTO mbi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Geina te netuenan a niyu en,” ke si Hisus “ne egketuenan niyu en rema ke Amey ku. Ne egenat guntaani ne egketuenan niyu en sikandin su nekita niyu en.” ");
INSERT INTO mbi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Migkahi si Felipe te, “Kerenan, ipekita nu kenami ke Amey nu ne Eleteala, ne nesesangan en kenami.” ");
INSERT INTO mbi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ne migkahi si Hisus te, “Neuhet en se kebpekiduma ku keniyu ne maa Felipe, warà nu pè bes metueni ke entei a? Su piya entei ne nekekita kediey ne nekita rin en dema ke Amey ku. Ne meambe ke migkahi nu te, ‘Ipekita nu kenami ke Amey nu’? ");
INSERT INTO mbi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Meambe Felipe, warà ke pè bes mebperetiyaya te ini te kedì ke Amey ku, ne siaken ne riyan a te kandin? Ini se menge lalag ku keniyu ne kenà kayi rà ebpuun te kedì ne itungan su ke Amey ku ne ini med-ubpà te kedì ne kandin ne vaal ini. ");
INSERT INTO mbi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Peretiyayaa niyu nevenar ini se egkehiyen ku te riyan a te Amey ku, ne ini sikandin te kediey. Ne embiya merehen kew ne ebperetiyaya te egkehiyen ku, ne iyan niyu peretiyayaa ke menge tuus ne impekita ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sebenarvenar ini se egkehiyen ku,” ke si Hisus, “misan entei en ne edsarig kediey ne ebpekevaal iring dut te mibeelan ku. Uya, muna pà se egkeveelan din su geina te ed-ulì ad diyà te Amey ku. ");
INSERT INTO mbi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne misan engkey se ebuyuen niyu diyà te Eleteala kayi sabap dut te kedsarig niyu kediey ne ibehey ku keniyu su apey egkekita ke gehem te Amey ku ebpapevayà dut te ulaula ku ne Anak din. ");
INSERT INTO mbi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Su misan engkey se ebuyuen niyu sabap dut te kedsarig niyu kediey, ne ibehey ku keniyu.” ");
INSERT INTO mbi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Embiya egkelimù kew kediey,” ke si Hisus, “ne edtumanen niyu ini se menge suhù ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne ebuyù a riyà te Amey ku su apey rin igkevehey keniyu ke Edtavang keniyu ne ebpekesambì kedì, ne kenà edsuwey keniyu taman te taman. ");
INSERT INTO mbi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sikandin ini ke Kedesenan ne Ebpetuntul te Menusiyà ke ebpesabut keniyu te benar mekeatag te Eleteala,” ke si Hisus. “Kenà ini egketelimà te menge etew kayi te ampew te dunya ne warà medtelimà kedì su kenà dan egkekilala sikandin ne kenà dan ebpekesabut ke entei sikandin. Ugaid ne nesebutan niyu en ke entei sikandin su ebpekiduma sikandin keniyu wey diyà mid-ubpà sikandin te keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ne kenà ku sikiyu ed-ewaan,” ke si Hisus, “iring te menge ilu su edliveran ku red sikiyu. ");
INSERT INTO mbi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kenà en utew meuhet ne kenà ad egkekita rut te menge etew kayi te ampew te dunya ne warà medtelimà kedì, ugaid ne egkekita e red nikiyu su siaken ne egkeuyag a, ne egkeuyag kew red dema. ");
INSERT INTO mbi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ketà te hewii te egkevanew a ne ketà niyu egketueni te siak wey ke Amey ku ne egkeseveka key rà, ne egkesebutan niyu rema te ini kew te kedì ne riyan a dema te keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Misan entei ne etew se edtelimà te menge suhù ku ne edtumanen din,” ke si Hisus, “ne sikandin ke egkelimù kediey. Ne igkelimù dema dut te Amey ku arà se etew ne egkelimù kediey. Ne igkelimù ku rema sikandin, ne ibpayag ku kandin te siaken ke ruma rin.” ");
INSERT INTO mbi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Migkahi en si Hudas (kenà si Hudas ne anak ni Simon Iskeriyuti) te, “Kerenan, ne meambe ke kayi ke rà ebpepayag te kenami ne kenà ka diyà ebpepayag dut te menge etew ne warà medtelimà keykew?” ");
INSERT INTO mbi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Midtavak si Hisus te, “Uya, su kenà dan egkelimù kediey su ke etew ne egkelimù kediey ne iyan din edtumanen ke menge suhù ku. Ne igkelimù sikandin dut te Amey ku, ne sikami ki Amà ne riyà key te kandin su ed-ubpà. ");
INSERT INTO mbi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ugaid ne ke etew ne kenà egkelimù kediey, ne kenà din dema edtumanen ke menge suhù ku. Ini se lalag ku ne imperineg ku keniyu ne kenà kayi rà ebpuun te itungan ku, ugaid ne riyà ebpuun te Amey ku ke midsuhù kediey. ");
INSERT INTO mbi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nekahi ku en ini keniyu te ini e pà te keniyu,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","“Ugaid ne misan ed-ewaan ku en sikiyu ne ruen en edsuhuen te Amey ku ne ebpekesambì kediey ne edtavang keniyu. Ini se edtavang keniyu ne ke Kedesenan ne Ebpetuntul te Menusiyà su sikandin se ebpenurù keniyu te langun taman, ne ebpetenuran din dema keniyu ke langun ne migkahi ku. ");
INSERT INTO mbi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Uya, misan ed-ewaan ku en sikiyu, ne edtahakan ku sikiyu te kebmelintad te hinawa niyu. Ini se kebmelintad te hinawa niyu ne ibehey ku keniyu ne kayi ebpuun te kediey. Ke menge etew kayi te ampew te dunya ne kenà ebpekevehey te kelintad ne iring kayi, ketà be ne kenà kew meuru, ne kenà kew meandek.” ");
INSERT INTO mbi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nerineg niyu en ke migkahi ku te, ‘Ed-ewaan ku sikiyu, ugaid ne edliveran ku red sikiyu,’ ” ke si Hisus. “Embiya benar ne igkelimù a nikiyu ne igkehalew niyu su ed-ulì a riyà te Amey ku su sikandin ke mepurù pà kediey. ");
INSERT INTO mbi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Idtarem ku en ini keniyu guntaan te warà pà med-ulaula su embiya egked-ulaula en ini ne ebpekeperetiyaya kew red misan warà ad. ");
INSERT INTO mbi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kenà en utew meuhet se kebitiyara ku keniyu su ebpekeuma en si Setanas ke datù te pekaid ne egkamal kayi te ampew te dunya,” ke si Hisus. “Ne warà ma bayàbayà din kediey, ");
INSERT INTO mbi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ugaid su apey metueni te menge etew kayi te ampew te dunya te igkelimù ku ke Amey ku ne tembù be edtumanen ku ke langun ne insuhù kediey te Amey ku. Na, kuwa kiyu en su ed-awà ki en kayi.” ");
INSERT INTO mbi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne mibpenempità si Hisus dut te edumdumaan din te, “Siaken ke benar ne lawa te pinemula ne iyan be edtuganur dut te pinemula ne ke Amey ku ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Embiya ruen subpang ku ne kenà ebahas, ne id-awà din. Ne langun ne menge subpang ku ne ebpemehas ne ebpenemperan din su apey merapung ke bahas din. ");
INSERT INTO mbi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne iring kew en dut te menge subpang ne mibpenemperan su sabap dut te Lalag te Eleteala ne impemula ku riyà te itungan niyu rut te impenurù ku. ");
INSERT INTO mbi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ketà be ne kenà kew ebpitas kediey,” ke si Hisus, “ne kenà a rema ebpitas keniyu. Su ke subpang ne egkepitas dut te lawa te pinemula ne kenà ebpekevahas, ne iring kew rema te subpang su kenà kew ebpekevahas embiya ebpitas kew rut te kebperetiyaya niyu kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne migkahi maa si Hisus te, “Siaken ke lawa te pinemula ne sikiyu ve ke menge subpang. Ke subpang ne kenà ebpitas kediey ne diyan a rema te kandin ne ebpemehas te merapung. Ugaid ne embiya ebpitas kew kediey, ne warè egkeveelan niyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Su ke etew ne ebpitas kediey,” ke si Hisus, “ne igketimbag sikandin iring dut te subpang ne idtimbag su egenguwen. Embiya nehangu en, ne eburunen ne idtimbag diyà te apuy su ebinsulan. ");
INSERT INTO mbi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ugaid ne embiya kenà kew ebpitas kediey su intahù niyu te hinawa ke penurù ku,” ke si Hisus, “ne misan engkey se ebuyuen niyu kediey ne ibehey ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Su embiya ebpemehas kew te merapung ne egkereyù ke Amey ku ne Eleteala, ne iring ketà se kegketueni te sikiyu ne benar ne edumdumaan ku. ");
INSERT INTO mbi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ini se kegkelimù ku keniyu,” ke si Hisus, “ne iring te kegkelimù dut te Amey ku kediey, ne kenà kew pitas dut te limù ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Embiya edtumanen niyu ini se menge suhù ku keniyu ne kenà kew egkepitas kayi te limù ku keniyu, iring ded dema kedì te midtuman ku ke menge suhù te Amey ku kediey ne kenà a rema egkepitas diyà te limù din kediey. ");
INSERT INTO mbi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mibpeketuenan ku ini keniyu su apey niyu igkehalew te kebpeneheewita niyu te menge suhù ku iring dut te kegkehalew ku te kebpeneheewit ku te suhù kedì te Amey ku,” ke si Hisus. “Ne ketà ne egkehalew kew nevenar! ");
INSERT INTO mbi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne ini ve ke suhù ku keniyu te pelimlimuey kew iring dut te limù ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Embiya ruen etew ne ebpebpatey su limù din dut te ruma rin, ne arà en imbe ke punggus te limù. ");
INSERT INTO mbi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ne sikiyu ke menge sepakat ku embiya edtumanen niyu ini se menge suhù ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kenà en be edsugsuhuen ke id-umew ku keniyu su kenà egketuenan dut te edsugsuhuen ke ebeelan dut te edsuhùsuhù kandin. Ugaid ne iyan ku en mulà id-umew keniyu ne menge sepekat ku su langun te nerineg ku riyà te Amey ku ne Eleteala ne impayag ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kenà sikiyu se mibpemilì kediey ugaid ne siaken se mibpemilì keniyu, ne midtendù ku sikiyu te ebpemenudtul dut te Meupiya ne Tudtul su apey kew mekepemehas te ulaula ne ebpekesuhat te hinawa te Eleteala su ebpekeperayun ke keupiya rin. Embiya iring ketà ne misan engkey ne ebuyuen niyu riyà te Amey ku ne Eleteala sabap dut te kebperetiyaya niyu kediey, ne ibehey rin keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ini ve ke suhù ku keniyu,” ke si Hisus, “te pelimlimuey kew.” ");
INSERT INTO mbi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Embiya edèdeetan kew te menge etew kayi te ampew te dunya ne egkunterà te Eleteala,” ke si Hisus, “ne kenà kew meinuinu su tentenuri niyu te siak ke neuna ne ingkeepes dan. ");
INSERT INTO mbi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Embiya ruma kew ran te egkunterà te Eleteala kayi te ampew te dunya, ne kenà kew ran edèdeetan. Ugaid ne geina te mibpemilì ku sikiyu ne kenà kew en duma nikandan, tembù be egkeepes dan keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tentenuri niyu iya ke migkahi ku te, ‘Warà uripen ne iyan en mepurù dut te ebpengunguripen kandin,’ ” ke si Hisus. “Ne embiya midrasey a ran, ne iyan kew pè be kenà resaya ran. Embiya midtuman dan ke penurù ku, ne edtuman dan dema dut te penurù niyu. ");
INSERT INTO mbi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iyan dan kedresaya keniyu ne sabap dut te kebperetiyaya niyu kediey su warà dan metueni ke Eleteala ne midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Embiya warà a mebpengkayi te ampew te dunya,” ke si Hisus, “te ebpayag dut te lalag ku kandan, ne warà igkeisuhat kandan te salà. Ugaid ne geina te impayag ku en ini kandan ne warà en liwahì dan. ");
INSERT INTO mbi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ketà be ne misan entei se egkeepes kediey, ne igkeepes din rema ke Amey ku ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Duen mid-ulaula ku ne nekita ran ne mekegeyip ne warà meveeli te misan entei ne menusiyà, ne embiya ve perem warà dan ini mekita ne ruen igkeliwahì dan te salà dan,” ke si Hisus. “Ugaid ne nekita ran en ini, ne ingkeepes key ran ki Amà. ");
INSERT INTO mbi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ugaid ne iyan ebpuun te kegkeepes dan kedì ne egketuman ke impesurat diyà te penduan dan ne egkahi te, ‘Neepes dan kedì misan warà puunan din.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ne migkahi pà maa si Hisus te, “Ibpepengkayi ku te keniyu arà se ed-ingeranan te Edtavang ne riyà ebpuun te Amey ku su sikandin ke Kedesenan ne Ebpetuntul te Menusiyà ne ebpesabut keniyu te benar mekeatag te Eleteala. Ne embiya ebpekeuma en sikandin kayi ne ebpesabut sikandin mekeatag kediey. ");
INSERT INTO mbi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ne ebpesabut kew rema mekeatag kediey su igenat te rudsuan te kinepenurù ku kayi te ampew te dunya ne telteleduma kiyu en.” ");
INSERT INTO mbi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Langun kayi ne migkahi ku keniyu,” ke si Hisus, “su apey kew kenà edsuwey kedì ketà te hewii ne egked-ulaula ini. ");
INSERT INTO mbi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Su ke menge etew ne mid-engkenà kedì ne ebpeawà keniyu rut te baley ne ebpengedian te menge Hudiyanen te penduan dan. Uya, su egkeuma ke hewii ne ke etew ne ed-imatey keniyu ne iyan din kunaan ke netuman din ke kiyug te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iring ketà se ed-ul-ulaan dan keniyu su warà dan metueni ke Amey ku ne Eleteala wey warà a ran dema metueni. ");
INSERT INTO mbi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ugaid ne egkehiyen ku ve ini keniyu neraan,” ke si Hisus, “su embiya egked-ulaula en ini ne egketenuran niyu te ingkekahi ku en keniyu. Ini ne warà ku kehiya keniyu te aney en,” ke si Hisus, “su geina te ebpemekeduma kiyu pà.” ");
INSERT INTO mbi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ugaid ne guntaan te ed-ulì ad diyà te Amey ku ke midsuhù kedì, ne warà senge etew rà keniyu ne mid-insà kediey te, ‘Endei ka ebpesinaru?’ ");
INSERT INTO mbi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Guntaan te migkehiyan ku sikiyu, ne egkemutuwan kew en. ");
INSERT INTO mbi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sebenarbenar ini se egkehiyen ku keniyu,” ke si Hisus, “iyan pà meupiya ne egkeewaan ku sikiyu, su embiya kenà ne kenà ebpengkayi se Edtavang keniyu. Ugaid ne embiya egenat ad ne ibpepengkayi ku sikandin kayi te keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne ketà te kebpekeuma rin ne ibpesabut din dut te menge etew kayi te ampew te dunya ke ulaula ne meraat, ne ibpesabut din dema ke ulaula ne metidtu wey ibpesabut din dema mekeatag te kedusa te Eleteala te menge etew ne warà mebperetiyaya kandin. ");
INSERT INTO mbi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ibpesabut din kandan te meraat ke ulaula ran su warà dan mebperetiyaya kediey,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Ibpesabut din kandan ke ulaula ne metidtu su ketà te ked-ulì ku diyà te Amey ku ne egketuenan dan se netuman ku en ke langun ne insuhù din kediey, ne id-anew ad nikiyu te mata. ");
INSERT INTO mbi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne ibpesabut din dema ke kedusai kandan te Eleteala su neisuhat en te kukuman si Setanas ke datù te pekaid ke unuten dan te egkunterà te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Merakel pà perem,” ke si Hisus, “se egkehiyen ku keniyu, ugaid ne kenà niyu pà egketegkad. ");
INSERT INTO mbi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ugaid ne ketà te kebpekeuma dut te Kedesenan ne Ebpetuntul te Menusiyà kayi te keniyu, ne sikandin en ke ebpetuntul keniyu te langun ne benar. Ne ini se ibpesabut din ne kenà kayi rà te kandin ne itungan, ugaid ne iyan din ibpesabut ne endei rà ke nerineg din diyà te Amey ku ne Eleteala. Ne ibpesabut din ded lavew keniyu ke egked-ulaula ne ebpelingguma,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Ne ebentuhen a rin su ibpesabut din ke menge lalag ku keniyu wey ke ulaula ku. ");
INSERT INTO mbi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Langun ne riyà te Amey ku ne kediey red dema, tembù be migkahi ku keniyu ne ibpesabut din keniyu ini se menge lalag ku su ke lalag te Amey ku ne kedì ded dema ne lalag.” ");
INSERT INTO mbi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kenè en utew meuhet ne id-anew a niyu te mata, ugaid ne iseg-iseg ne egkekita a niyu red,” ke si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Duen edumdumaan din ne mibpein-inseey te, “Engkey se meana kayi te migkahi rin te, ‘Kenè en utew meuhet ne id-anew a niyu te mata, ne iseg-iseg ne egkekita a niyu red.’ Ne migkahi pà maa sikandin te, ‘Su ed-ulì ad diyà te Amey ku.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne mibpein-inseey ran maan te, “Engkey ve vuwa ini se kinekahi rin te ‘kenà utew meuhet’? Kenà tew egkesebutan ayan.” ");
INSERT INTO mbi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Netuenan ni Hisus te ruen id-insà dan kandin ne migkahi en sikandin te, “Geina ne migkahi a te, ‘Kenè en utew meuhet ne id-anew a niyu te mata, ne iseg-iseg ne egkekita a niyu red.’ Maa, ini ve arà se ibpein-inseey niyu? ");
INSERT INTO mbi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sebenarvenar ini se egkehiyen ku, ebpekesinehew kew kayi te egketemanan ku, ugaid ne ke menge etew ne ed-engkenà kediey ne egkehalew ran. Ne misan egkemutu kew, ne iyan din egkeveluyan ne egkehalew kew. ");
INSERT INTO mbi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iring ded dema te meritan ne ebpelelesut en te ked-anak din su neuma en ke kegkerasey rin. Ugaid ne embiya nekehemew en ke vatà, ne egkelipatan din en ke mesakit su nehalew sikandin dut te behu pà ne in-anak din. ");
INSERT INTO mbi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ne iring kew re be rema ketà su guntaani ne egkemutu kew, ugaid ne ebpekidbalak e red maa keniyu ne egkehalew kew nevenar, ne warà misan entei ne ebpekeawà kayi te kehelawan niyu. ");
INSERT INTO mbi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Embiya egkeuma en arà se hewii,” ke si Hisus, “ne warà en kemeyidan te ebuyù kew kediey. Sebenarvenar ini se egkehiyen ku te misan engkey se ebuyuen niyu riyà te Amey ku, embiya sabap dut te kebperetiyaya niyu kediey ne ibehey rin keniyu. ");
INSERT INTO mbi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taman guntaani ne warà kew pà mibuyù diyà te kandin sabap dut te kebperetiyaya niyu kediey. Buyù kew en kandin sabap dut te kebperetiyaya niyu kediey, na egketelimà niyu se rekelà ne kehelawan niyu.” ");
INSERT INTO mbi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ini se impesabut ku keniyu ne ralan te sempità,” ke si Hisus. “Ugaid ne ruen hewii ne egkeuma ne kenà ad ebpenempità su iyan ku kebpekidlalag keniyu mekeatag te Amey ku ne metidtu rà ne lalag. ");
INSERT INTO mbi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Embiya egkeuma en arà se hewii ne iyan kew en buyù riyà te Amey ku su sabap te kebperetiyaya niyu kediey, su kenà en siaken se ebuyù keniyu diyà te Amey ku. ");
INSERT INTO mbi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Su igkelimù kew nevenar te Amey ku ne Eleteala geina te igkelimù a niyu sabap geina te mibperetiyaya kew te riyan a ebpuun te kandin. ");
INSERT INTO mbi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uya,” ke si Hisus, “diyan a mebpuun te Amey ku su mibpengkayi a te ampew te dunya, ne guntaani ne ed-ewaan ku en ini se dunya su ed-ulì ad diyà te Amey ku.” ");
INSERT INTO mbi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ketà ne migkahi ke edumdumaan ni Hisus te, “Kenà en sempità se lalag nu kenami guntaani su metidtu rà ke lalag nu guntaani. ");
INSERT INTO mbi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Netuenan dey en te netuenan nu ke langun, su misan ke menge insà ne warà pà ingkeinsà keykew ne netuenan nu. Tembù be mibperetiyaya key en te riyà ka ebpuun te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ne migkahi si Hisus kandan te, “Maa, mibperetiyaya kew en be guntaani? ");
INSERT INTO mbi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mehaan en egkeuma ke hewii ne egurunsuwey kew su ed-ulì kew riyà te ed-ubpaan niyu, ne egkeewaan a niyu en. Ugaid ne misan egkeewaan a niyu en ne kenà ma sebseveka ku rà, su iyan ku ruma ne ke Amey ku ne Eleteala. ");
INSERT INTO mbi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Langun kayi ne migkahi ku keniyu,” ke si Hisus, “su apey ebmelintad ke hinawa niyu te kebpekidseveka niyu kediey. Su kayi te ampew te dunya ne edresayen kew te menge etew ne ed-engkenà kediey. Ugaid ne misan iring ketà ne kenà niyu ebpilaya ke hinawa niyu, su netalew ku en ke datù te pekaid ne migkamal kayi te ampew te dunya!” ");
INSERT INTO mbi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Guna su nepasad ni Hisus te egkahi diyà te edumdumaan din, ne midlingakà diyà te langit se ebpengeningeni te, “Amà, ini en ke hewii te kedtumana nu ke kiyug nu. Ipekita nu te menge etew ke raman ne kenà egkeseupama dut te Anak nu apey ku ibpekepekita ke raman nu ne kenà egkeseupama. ");
INSERT INTO mbi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Su imbehey nu kediey se kebayàbayà dut te langun ne menusiyà apey ke menge etew ne imbehey nu kediey ne egkevehayan te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Su ke ralan te kebpeketelimà te umur ne warà edtemanan din ne arà se kegkesebuti te menge etew te sikew rà iya ke benar ne Eleteala, wey egkesebutan dan dema te siaken si Hisu Kristu ke Anak nu ne midsuhù nu. ");
INSERT INTO mbi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Su kayi te dunya ne impekita ku en ke kerekelà te gehem nu kayi te ulaula ku, ne ke insuhù nu kediey ne nepasad ku en. ");
INSERT INTO mbi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na guntaani, Amà, te ed-ulì ad diyà te etuvangan nu ne iulì nu en kediey ke raman ku ne kenà egkeseupama iring dut te aney en ne raman ku te riyan e pà te keykew te warà pà limbaha ini se dunya. ");
INSERT INTO mbi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ini se menge etew kayi te dunya ne imbehey nu kediey, Amà,” ke si Hisus, “ne impesabut ku en kandan mekeatag te sikew ne Eleteala. Su andang dan ne keykew te warà nu pà imbehey kediey, ne midtuman dan en ke insuhù nu kandan. ");
INSERT INTO mbi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne netuenan dan en uman te ini se langun ne egkeveelan ku ne riyà dà ebpuun te keykew. ");
INSERT INTO mbi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Su impenudtul ku en kandan ke impesabut nu kediey ne mibperetiyaya ran en ini. Su netuenan dan te riyà a iya ebpuun te keykew, ne mibperetiyaya ran te sikuna ke midsuhù kedì. ");
INSERT INTO mbi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ketà be, Amà, ne ibpengeningeni ku sikandan,” ke si Hisus. “Kenà ku iyan ebuyuen diyà te keykew se tevangi nu ke menge etew ne warà medtelimà kedì, ugaid ne iyan ku ebuyuen ne tevangi nu ke menge etew ne imbehey nu kediey su keykew red ma sikandan. ");
INSERT INTO mbi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Su langun kayi ne menge etew ne kediey ne keykew red, ne ke langun ne menge etew ne keykew ne kediey red dema. Ne kayi te kandan se puunan te egkereyù a. ");
INSERT INTO mbi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne guntaani ne ed-ulì ad diyà te keykew ne kenà ad ed-ubpà kayi te dunya, ugaid ne ini se menge etew ta ne kayi ran ded te ampew te dunya. Is, Amà ne berekat,” ke si Hisus, “ipata nu sikandan te ralan te kerekelà te gehem te ngaran nu ne imbehey nu kediey su apey meseveka sikandan iring dut te kegkeseveka ta. ");
INSERT INTO mbi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Su gewii te ini e pà te kandan ne mid-ipat ku sikandan te ralan te kerekelà te gehem te ngaran nu ne imbehey nu kediey. Uya, mid-ipat ku sikandan su warà seveka rà kandan ne neawà liyu rà ketà te senge etew ne iyan dà nekahi neraan ne ed-ulug kediey. Neawà sikandin su apey egketuman ke impesurat ne Lalag nu. ");
INSERT INTO mbi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ne guntaani,” ke si Hisus, “ne ed-ulì ad diyà te keykew, Amà, ugaid ne geina te kayi e pà te ampew te dunya ne ebuyuen ku te menu ma ke egkehalew ran iring dut te dekelà ne kegkehalew ku. ");
INSERT INTO mbi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Su langun ne menge lalag nu ne impesabut ku en kandan, ugaid ne ingkeepesi ran dut te menge etew kayi te ampew te dunya ne migkunterà keykew su geina te mibpekidsuwey ran dut te menge kunterà nu, iring te siaken ne warà a mebpekid-amur te menge kunterà nu. ");
INSERT INTO mbi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kenà ku iyan ebuyuen keykew ne iawà nu ini se menge etew ta kayi te dunya, ugaid ne iyan ku ebuyuen keykew te ipata nu sikandan su apey ran kenà meahew ni Setanas ke datù te pekaid. ");
INSERT INTO mbi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Su sikandan ne kenà duma rut te menge etew kayi te ampew te dunya ne egkunterà kenikew,” ke si Hisus, “iring kedì te kenà a ruma dut te menge etew ne egkunterà kenikew. ");
INSERT INTO mbi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Su geina te ke lalag nu ke ebpuunan te langun ne benar, ne kayi puunan ne beluya nu sikandan ne tuney ne sugsuhuen nu su apey idtepeney ran ke hinawa ran diyà te keykew. ");
INSERT INTO mbi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Su iring te kinesuhù nu kediey kayi te ampew te dunya, ne edsuhuen ku rema sikandan su apey ran ikepesabut ke lalag nu dut te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Su atag dut te limù ku kandan ne idrumakan ku keykew ini se hinawa ku su apey ran dema idrumakan nevenar ke hinawa ran keykew. ");
INSERT INTO mbi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kenà ku iyan dà ebuyuen keykew,” ke si Hisus, “ne ini se menge etew ta guntaani, ugaid ne ke langun ne ebperetiyaya kediey keuremà sabap dut te kebpemesabut dan. ");
INSERT INTO mbi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Su apey langun te sikandan ne meseveka, Amà, iring te ini ka te kedì wey riyan a rema te keykew. Uya, meseveka ran perem kayi te keyta su apey ebpekeperetiyaya ke menge etew kayi te ampew te dunya te midsuhù a nu. ");
INSERT INTO mbi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne ini se kegkevantug ku ne imbehey nu kedì ne imbehey ku rema diyà te kandan, su apey egkeseveka ke itungan dan iring te kegkeseveka ta. ");
INSERT INTO mbi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Su riyan a te kandan iring dut te ini ka rema te kediey, apey egkeseveka rà ke itungan dan. Ne ketà ne egketuenan te langun ne menusiyà te midsuhù a nikuna, ne egketuenan dan dema te igkelimù nu sikandan iring dut te limù nu kediey. ");
INSERT INTO mbi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Is, Amà, ini se menge etew ne imbehey nu kediey,” ke si Hisus, “ne iyan ku kiyug ne riyà dan te kediey ne ed-ubpaan su apey ran egkekita ke mekegeyip ne raman ku. Su ini se raman ku ne imbehey nu kediey su ingkelimù a nikuna rengan te warà pà limbaha ini se dunya. ");
INSERT INTO mbi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Is, Amey ku ne metidtu,” ke si Hisus, “ini se menge etew kayi te ampew te dunya ne egkunterà kenikew, ne warà dan metueni ke entei ka. Ugaid ne netuenan ku sikew wey ini se menge etew ne imbehey nu kedì ne netuenan dan te sikuna ke midsuhù kediey. ");
INSERT INTO mbi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impesabut ku en kandan ke entei ka, Amà, ne ini ne ibperayun ku pà te ebpesabut kandan apey ebmeilut ke kebpelimlimuey ran iring dut te limù nu kediey su apey riyan a rema te kandan.” ");
INSERT INTO mbi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Guna su nekeipus si Hisus te ebpengeningeni ne mid-awà en sikandin abpeg dut te edumdumaan din, ne mid-apet dan te beuhan ne ed-ingaranan te Kidrun. Su ruen pemulaan dutun ne mibpemulaan te menge kayu ne ketà dan be midseruk. ");
INSERT INTO mbi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ne si Hudas, ke ed-ulug ki Hisus te ked-imatey, ne neketuntul ketà su tatap ne egkevurunan eni Hisus dut te edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ketà ne nekeuma en kayi te pemulaan si Hudas se midumaan te menge sundaru wey ke menge gurudyà rut te Nekebpuru ne Valey te Eleteala se midsuhù dut te menge mepurù te terebpelengesa wey ke menge Peresiyu. Nekeuma ran en se ebpenusulù ne sangkap dan nevenar te metarem. ");
INSERT INTO mbi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ugaid ne netuenan ni Hisus ke langun ne egketemanan din ne midsinuhung din en sikandan se egkahi te, “Engkey ma ini se ebpemengaan niyu?” ");
INSERT INTO mbi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Midtavak dan te, “Si Hisus ne ebpuun te Nesarit.” “Siak ini ke ebpemengaan niyu,” ke si Hisus. Ne elin en dema dut te menge sundaru si Hudas, ke ed-ulug ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Guna su nekahi ni Hisus te, “Siaken en iya ini,” ne nekesunud dan ne nengepiley ran. ");
INSERT INTO mbi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ne mid-insà maa si Hisus te, “Entei iya ini se ebpemengaan niyu?” Ne midtavak dan maa te, “Si Hisus ne ebpuun te Nesarit.” ");
INSERT INTO mbi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Migkahi en maa si Hisus te, “Migkahi ku en ura keniyu te siaken en ini iya. Embiya ve siaken ke ebpemengaan niyu, ne kenà niyu rà iamung te edsigkem ini se menge ruma ku.” ");
INSERT INTO mbi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Iring ketà se kinekahi rin te kenà ibpeamung te edsigkem ke menge ruma rin su apey ini se nekahi rin dut te kinepengeningeni rin geina ne egketuman te, “Warà seveka rà, Amà, ne egkeawà dut te langun ne menge etew ne imbehey nu kediey.”) ");
INSERT INTO mbi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nekita rà ni Simon Pedro se iring ketà ne mid-ulavut din ke sundang din ne midtibas din en ke sugsuhuen dut te pinekebmepurù te terebpelengesa, ne nesamping en ke kewanan ne telinga rin. Ini se edsugsuhuen ne ed-ingaranan ki Malco. ");
INSERT INTO mbi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ne midawey ni Hisus si Pedro se egkahi te, “Ilipi nu ayan se sundang nu! Su engkey, iyan nu kunaan ke kenà ku egkegaga te edtigker ke kemeresayan ne imbehey kedì te Amey ku?” ");
INSERT INTO mbi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ketà ne midsigkem dan en si Hisus ne mibakù dan en dut te menge sundaru wey ke unuten dan abpeg dut te menge gurudyà ne Hudiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ne riyà dan unai te ed-ewit si Hisus te ki Anas, ke enuhang ni Kayipas ke pinekemepurù dut te langun ne terebpelengesa te arà ne rahun. ");
INSERT INTO mbi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayipas ke nekekahi rut te menge Hudiyanen te iyan dà tumù se senge etew rà se ebpatey ne ebpekeselidig dut te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Guna su neewit dan en si Hisus, ne midteltelukun en si Simon Pedro wey senge etew pà ne edumdumaan ni Hisus. Ini se senge etew ne edumdumaan ni Hisus ne andang ne nekilala dut te keunutan te terebpelengesa, ne ketà be ne nekeruma sikandin ki Hisus te edlusud diyà te lamalama rut te valey te keunutan te terebpelengesa. ");
INSERT INTO mbi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ugaid ne si Pedro ne riyà dà te luwal te humawan. Ne ketà ne mibpelilived diyà te gumawan ini se seveka ne edumdumaan ni Hisus ne nekilala rut te egkeunutan te terebpelengesa ne midlelehan din en ke meritan ne ebantey rutun te gumawan te ebpelusuren si Pedro, ne arà dà ne impelusud din en. ");
INSERT INTO mbi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ne ketà ne mid-insà ke meritan ne ebantey te humawan ki Pedro te, “Maa, kenà ka senge etew ne edumdumaan keniyan te etew ne midsigkem?” Midtavak si Pedro te, “Kenà, kenà siak!” ");
INSERT INTO mbi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ne rutun te lamalama ne mid-uyag dan te apuy te uring ke menge sugsuhuen kayi te valey elin dema ke menge bantey rut te nekebpuru ne valey te Eleteala su ebpenginarang dan su meadsil. Ne arà dà dema ne mid-uvey en si Pedro su ed-inarang dema sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ne mibpenginsaan ni Anas ke Pinekemepurù te menge Terebpelengesa si Hisus mekeatag dut te edumdumaan din wey ke penurù din. ");
INSERT INTO mbi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne midtavak si Hisus te, “Ini se penurù ku ne warà mekeeles su riyà te merakel ne etew. Su riyan a layun mibpenurù te menge valey ne ebpengedian te Hudiyanen te penduan dan wey riyà dema te Nekebpuru ne Valey te Eleteala su arà ke egkevurunan te langun ne menge Hudiyanen. Warà impenurù ku ne nekeeles. ");
INSERT INTO mbi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ne meambe ke iyan a nu ed-insaan? Iyan nu insai,” ke si Hisus, “ke nekerineg kediey su netuenan dan ke migkahi ku kandan.” ");
INSERT INTO mbi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Guna su nekahi ini ni Hisus ne midtabpì en sikandin te seveka ne gurudyà. Ke se gurudyà te, “Sikuna pè be iya se ebpeketikàtikà ne ebpenumpan te iring keniyan kayi te Pinekemepurù te menge Terebpelengesa!” ");
INSERT INTO mbi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Migkahi si Hisus kandin te, “Embiya meraatey ini se migkahi ku, ne kehiya nu ke engkey se meraat kayi te etuvangan te merakel. Ugaid ne embiya warà meraat din, ne meambe ke midtabpì a nu?” ");
INSERT INTO mbi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Neipus ni Anas te ed-insà si Hisus ne impelaus din en diyà te ki Kayipas ke enuhang din ne iyan Pinekemepurù te langun ne menge terebpelengesa. Si Hisus ini ne nevakù pà lavew. ");
INSERT INTO mbi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ne ketà te lamalama te Pinekemepurù te menge Terebpelengesa ne ed-inarang pà lavew si Pedro. Mid-insaan te menge etew sikandin te, “Kenà ka senge etew ne edumdumaan keniyan te etew an?” Ugaid ne mibparew si Pedro, “Kenà, kenà siaken!” ");
INSERT INTO mbi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ne ruen ketà seveka ne edsugsuhuen te Pinekemepurù te menge Terebpelengesa ne megeget din arà se nesempingan ni Pedro te telinga rin. Ne migkehiyan din en si Pedro te, “Iring te nekita ku sikuna geina riyà te kedsigkema rey ki Hisus, ne engkey, duma ka nikandin?” ");
INSERT INTO mbi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ne mibparew en maa ni Pedro te, “Kenà!” Ne arà dà iya ne mid-ukarà en ke manuk. ");
INSERT INTO mbi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ed-awà ketà te valey ni Kayipas ne mid-ewit dan si Hisus se ebpendiyà te turuhan ni Pilatu ke gubinedur ne Rumanu, ne mesmeselem pà. Ugaid ne ke menge egkeunutan te Hudiyanen ne kenà edlusud ketà te turuhan su apey ran kenà mekesurang dut te edtenuran ne betasan mekeatag te ebpenlùlù. Su embiya edlusud dan te valey te menge etew ne kenà eduma te edtenuran dan ne betasan dan te kedlùlù, ne kenà dan ebpekeamung dut te kevurunan dan te Pista te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Geina te arà ke betasan dan ne midlihawang si Pilatu su edsinuhung kandan ne ke sikandin te, “Engkey ma se id-isuhat niyu ne kukuman kayi te etew ini?” ");
INSERT INTO mbi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Midtavak ke menge egkeunutan te, “Embiya warà salà din ini ne kenà dey ebpeneheewiten kayi te keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne migkahi si Pilatu kandan te, “Kua niyu sikandin ne iyan kew en kukum kandin su ruen ma penduan niyu ne egkerumaan.” Ne migkahi ke menge egkeunutan te, “Geina te sikami ne Hudiyanen ne egkekemalan dut te sikiyu ne menge Rumanu ne warà ketau rey te kebpeimatey kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ned-ulaula ini su apey metuman ke nekahi ni Hisus se idlansang sikandin diyà te pinebelavag ne kayu te kebpeimetayi kandin.) ");
INSERT INTO mbi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ne midsurì medlusud si Pilatu diyà te turuhan ne mid-umew rin si Hisus ne mid-insaan te, “Maa, datù ke ves ini te menge Hudiyanen?” ");
INSERT INTO mbi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Midtavak si Hisus te, “Maa, keykew rà ayan ne itungan se in-insà nu kedì te ratù a etawa riyà nu merineg ini te ruma ne etew?” ");
INSERT INTO mbi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Migkahi si Pilatu te, “Meambe, Hudiyanen a? Su keykew red ne menge ruma ne Hudiyanen wey ke menge mepurù te terebpelengesa ke mibpeneheewit keykew kayi te kedì. Ne engkey se mid-ulaula nu?” ");
INSERT INTO mbi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Midtavak si Hisus te, “Ini se kedì ne edetuan ne kenà kayi te ampew te dunya, su embiya ma kayi ne mibpekibunù en ke menge sakup ku apey kenà a mesigkem te menge Hudiyanen. Ugaid ne ini se edetuan ku ne kenà kayi te ampew te dunya.” ");
INSERT INTO mbi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ketà ne migkahi si Pilatu te, “Engkey, ratù ke ves?” Midtavak si Hisus te, “Benar ayan se nekahi nu ne ratù a! Su iyan ku kinepengkayi te ampew te dunya ne impeanak te menusiyà su ebpesabut a rut te benar. Ne misan entei en ne etew se edtampil dut te benar, ne ebpemineg kediey.” ");
INSERT INTO mbi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Arà dà ne mid-insà si Pilatu te, “Engkey se meana te benar?” Nekahi rin dà arà ne midlihawang en maa si Pilatu riyà te menge Hudiyanen ne migkahi te, “Warà egketuen ku ne id-isuhat ku kandin. ");
INSERT INTO mbi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ugaid ne kayi te keniyu ne ruen betasan niyu te embiya egkeuma en ke Pista te Kedsehari te Suluhuen ne ibpelihawang ku se senge etew ne bilanggù ne ebuyuen niyu. Maa, egkesuatan niyu ve ne ibpelihawang ku ini se ratù niyu te menge Hudiyanen?” ");
INSERT INTO mbi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nerineg den dà arà ne mibpemensag dan te, “Kenà, kenà sikandin! Iyan tumù ne si Barabas!” (Si Barabas ini ne tulisan.) ");
INSERT INTO mbi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nerineg dà arà ni Pilatu ne midlusud en maa sikandin te turuhan din ne migkuwa rin en si Hisus ne imperuug din en. ");
INSERT INTO mbi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Guna su neipus dan te edruug sikandin ne ruen impetengkulu kandin ne mibeelan te menge sundaru ne ruhiyen ne wahed, ne pinelelembung dan te merihà su uvag kun datù. ");
INSERT INTO mbi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ne mid-uvey ran sikandin te kedsumpelita ran te, “Mebereumur ka, ne ratù te menge Hudiyanen!” Ne arà pà ne midtabpì dan sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ne midlihawang en manen si Pilatu riyà te menge etew ne migkahi te, “Ibpelihawang ku en maa sikandin kayi te keniyu su apey niyu metueni te warà iya netuen ku ne kewagib ne idselaa kandin.” ");
INSERT INTO mbi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ne ketà ne midlihawang en si Hisus se impetengkulu te ruhiyen wey midlelembung te merihà. Ke si Pilatu te, “Tengtengi niyu en be sikandin su ini en!” ");
INSERT INTO mbi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Guna su nekita rut te menge mepurù te terebpelengesa wey ke menge gurudyà si Hisus ne mibpemensag dan en te, “Idlansang sikandin diyà te ebpebelevahan ne kayu!” Ne migkahi si Pilatu te, “Iyan kew en lansang kandin diyà te pinebelavag ne kayu, su warà egketuen ku ne arus ne ibpatey rin.” ");
INSERT INTO mbi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ne migkahi ke menge Hudiyanen te, “Kayi te penduan dey ne iyan iya se ebpeimetayan ini se etew su edsumpalit sikandin su egkahi te Anak te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Guna su nerineg ni Pilatu ini ne mid-iseg se kegkeandek din. ");
INSERT INTO mbi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Midlusud maa si Pilatu riyà te turuhan din ne med-insà maa si Hisus te, “Endei ke ma ebpuun?” Ugaid ne warà medtavak si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ne migkahi en maa si Pilatu te, “Meambe ke kenà ka edtavak? Warà nu ves metueni se siaken se ebayàbayà te kebpeliyu keykew etawa kebpelansang ku keykew riyà te kayu!” ");
INSERT INTO mbi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ne midtavak si Hisus te, “Warà bayàbayà nu kediey embiya kenà Eleteala se mibehey keykew. Tembù ke etew ne mibpeewit kediey kayi te keykew ne muna pà ke salà din dut te keykew.” ");
INSERT INTO mbi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Guna maa su nerineg ni Pilatu arà ne neilut nevenar ke hinawa rin te kebpemengà din te ralan te kebpeliyu din ki Hisus. Ugaid ne mibpemensag maa ke menge Hudiyanen te, “Embiya iyan nu ibpeliyu ini se etew, ne egkunterà ka dut te ratù tew riyà te Ruma ne si Cesar. Su iring kayi ne etew se edatùdatù ne egkunterà ki Cesar.” ");
INSERT INTO mbi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nerineg dà ini ni Pilatu ne mibpeneheewit din en si Hisus te edlihawang ne mibpinuu sikandin te ebpinuuwan din te egkukum diyà te mid-ingeranan te Saag ne Simintu. (Ne kayi te kinehiyan te Hibruhanen ne “Gebata.”) ");
INSERT INTO mbi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ne ketà ne ed-ikeremaen dà ke Pista te Kedsehari te Suluhuen ne malù en egkeudtu ke andew. Ne migkahi si Pilatu dut te menge Hudiyanen te, “Ini en ke datù niyu!” ");
INSERT INTO mbi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ne mibpemensag ke menge Hudiyanen te, “Id-awà su ed-imetayan! Ibpelansang nu sikandin diyà te kayu!” Migkahi si Pilatu te, “Maa, ibpelansang ku ve ini se ratù niyu riyà te pinebelavag ne kayu?” Ne mibpemensag ke menge mepurù te terebpelengesa te, “Seveka rà se ratù dey ne si Cesar dà.” ");
INSERT INTO mbi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Arà dà ne imbehey en kandan ni Pilatu si Hisus diyà te kandan te ibpelansang sikandin diyà te kayu. Ketà ne mid-ewit dan en si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ne midlihawang en si Hisus se edtiang dut te pinebelavag ne kayu su ebpendiyà dan en te dapit ne ed-ingaranan te menge “Tulan te Ulu.” (Ne riyà te kinehiyan te Hibruhanen ne ed-ingaranan te “Gulguta.”) ");
INSERT INTO mbi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne rutun dan inlansang si Hisus diyà te pinebelavag ne kayu, ne ruen deruwa ne etew ne inlansang dan dema diyà te kayu te idsenge riveluyà ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ne ruen insurat ni Pilatu ke gubinedur ne impetahù diyà te divavew rut te pinebelavag ne kayu. Ne ini se insurat din ne egkahi te, “Si Hisus ne riyà ebpuun te Nesarit, ke Ratù te menge Hudiyanen.” ");
INSERT INTO mbi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Merakel ne menge Hudiyanen se nekevasa ketà su ini se midlensangan dan ki Hisus ne uvey red ma te inged ne Hirusalim. Ne ini se insurat ne kinehiyan te Hibruhanen, Latin ke kinehiyan te menge etew te Ruma, wey ke kinehiyan te menge Gerisiyanen. ");
INSERT INTO mbi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Migkahi ke menge mepurù te terebpelengesa riyà te ki Pilatu te, “Warà nu perem insurat ‘Ke Datù te menge Hudiyanen,’ ugaid ne iyan nu rà perem insurat ne ‘Migkahi rin te Siaken ke Datù te menge Hudiyanen.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ne migkahi si Pilatu te, “Ke insurat ku en ne arà dà iya!” ");
INSERT INTO mbi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Guna su neipus te menge sundaru te kedlansang dan ki Hisus diyà te pinebelavag ne kayu ne migkuwa ran ke menge belegkas din ne mibaadbaad dut te epat ne sundaru. Migkuwa ran dema ke inlelembung din ne mid-avel ne warà penai rin. ");
INSERT INTO mbi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Migkahi ke menge sundaru te, “Kenà tew ini ebpenebtevasen, ugaid ne ebunutbunut ki su apey tew egkekita ke engkey se ebpekegkemuney.” Ini ke mid-ulaula ran su apey egketuman ke impesurat ne Lalag te Eleteala rengan ne egkahi te, “Mibaadbaad dan ke velegkas ku, ne mibunutbunutan dan ke inlelembung ku.” Ne ini iya ke mid-ulaula te menge sundaru. ");
INSERT INTO mbi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ne uvey ketà te pinebelavag ne kayu ne mid-it-itindeg ke iney ni Hisus, elin ke ayà din ne suled te iney rin, ne si Maria ke esawa ni Kelupas wey si Maria ne ebpuun te Magdala. ");
INSERT INTO mbi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Guna su nekita ni Hisus ke iney rin wey ke edumdumaan din ne ibpengelimù din nevenar, ne migkehiyan din ke iney rin te, “Inà, ini ke anak nu.” ");
INSERT INTO mbi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne migkehiyan din dema ke edumdumaan din te, “Ini en ke iney nu.” Ne in-awà dè be ketà ne andew ne diyan en med-ubpà ke iney ni Hisus te edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ketà ne netuenan ni Hisus te langun ne insuhù kandin ne nepasad din en ne migkahi en sikandin te, “Ebpekeinum a.” Migkahi rin ini su apey egketuman ke impesurat ne Lalag te Eleteala rengan. ");
INSERT INTO mbi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ruen ketà kelalew ne netehuan te tebà. Ne ruen migkuwa ran ne in-ered kayi te tebà, ne intahù dan diyà te reisek ne subpang ne ed-ingaranan te “isupu” ne arà be ke insugkar dan diyà te bèbà ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mid-esep ni Hisus ini se tebà ne migkahi en sikandin te, “Nepasad en ke langun ne insuhù kediey.” Ne midungul dà sikandin ne minatey en. ");
INSERT INTO mbi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ne mibpendiyà ke menge Hudiyanen te ki Pilatu su ebuyuen dan te ebpenlepuan dan ke paa rut te menge etew ne impenlansang diyà te kayu su apey ran ebpatey te mehaan ne egkeawà en ke bangkey ran. Ini ke ed-ul-ulaan dan su arà en ke keepunan te Diyemaat ne ebpekesurang dut te penduan dan embiya ruen bangkey riyà te pinebelavag ne kayu dut te hewii te Sepetu ke Hewii te Id-imeley ran. Ne ini ne Sepetu ne edtenuran dan nevenar su egketuman ke Pista ran te Kedsehari te Suluhuen. ");
INSERT INTO mbi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Migkiyug en si Pilatu ne mibpendiyan ke menge sundaru ne mibpenlepuan dan ke menge paa rut te deruwa ne etew ne inlansang diyà te idsengeriveluyà ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ugaid ne guna su kayi ran en te ki Hisus ne nekita ran se minatey en ne warà dan en penlepui sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ugaid ne ruen seveka ketà ne sundaru ne mibpilak din ke tengkiliran ni Hisus, ne arà dà ne ruen midtudà ne lengesa ne nekedsawug te wayig. ");
INSERT INTO mbi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Su siaken ini ke midsurat kayi ne edtitihusan ku te benar ini su nekita ku en iya. Uya, netuenan ku te benar ini, tembù be insurat ku su apey kew ebpekeperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ned-ulaula ini su apey egketuman ke impesurat ne Lalag te Eleteala rengan ne egkahi te, “Warà misan seveka ne tulan din ne egkelepù.” ");
INSERT INTO mbi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne ruen pà ruma ne Lalag ne impesurat te Eleteala ne egkahi te, “Edtengtengan dan ini se etew ne mibpilak dan.” ");
INSERT INTO mbi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nepasad ini ne ruen senge etew ne ed-ingaranan ki Husi riyà ebpuun te Eremetiya se mibpendiyà te ki Pilatu su ebuyuen din ke bangkey ni Hisus. (Si Husi ini ne eduma rema ki Hisus, ugaid ne in-eles din dà su egkeandek sikandin dut te menge egkeunutan te menge Hudiyanen.) Ne migkiyug si Pilatu te egkuan ni Husi ke bangkey ni Hisus, ne arà dà ne mibayaan en ni Husi ke bangkey ni Hisus ne mid-ewit din en. ");
INSERT INTO mbi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Si Nikudimu, ke etew ne mibpekibalak ki Hisus te senge kerukileman, se miduma kandin. Ne mid-ewit sikandin te menge lelima nepulù ne kilù ne periyemut pined-amut ke deruwa ne susun, mira wey alus. ");
INSERT INTO mbi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ne migkuwa ran en ke bangkey ni Hisus ne mibukusan dan te meputì ne saput, ne inragkes dan en ketà ke periyemut su arà ke betasan te menge Hudiyanen te kedleveng. ");
INSERT INTO mbi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne diyà te uvey te midlensangan ki Hisus ne ruen pemulaan te menge kayu. Ne ketà ne ruen leveng ne edlevengan, ugaid ne warà pà melevengi. ");
INSERT INTO mbi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ne geina te Diyemaat en arà ne mehaan en egkeuma ke Hewii te Ked-imeley ran wey merani rema ini se edlevengan, ne ketà dan en inleveng si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Guna su mesmeselem te Akad ne mibpendiyà si Maria Megdelina te midlevengan ki Hisus te merusirem pà. Nekeuma ketà sikandin ne nekita rin te neawè en ke vatu ne inlekeb dut te gumawan te leveng. ");
INSERT INTO mbi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nekita rin dà ne mibpelelahuy en se ebpendiyà te ki Simon Pedro wey arà se edumdumaan ni Hisus ne igkelimù din utew. Ne migkahi en si Maria kandan te, “In-awà dan en dut te midlevengan ki Hisus ke Kerenan tew, ne warà dey metueni ke endei ran ewita.” ");
INSERT INTO mbi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nerineg dà ni Pedro wey arà se ruma rin ne edumdumaan ni Hisus ne mibpendiyan dan en te leveng. ");
INSERT INTO mbi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mibpelelahuy ran se deruwa ne etew, ugaid ne neunaan dut te ruma rin si Pedro te kebpekeuma riyà te leveng. ");
INSERT INTO mbi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Midsiniling din en ne iyan din nekita ke meputì ne saput ne imbukus, ugaid ne warà medlusud sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ne si Simon Pedro ke neketundug kandin, ne midlusud en mulà, ne nekita rin ke saput ne meputì ");
INSERT INTO mbi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","wey ke saput ne imbukus dut te ulu ni Hisus. Nengelempì en ini, ugaid ne nekedsivey se kinekesavuk din. ");
INSERT INTO mbi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne arà pà ne midlusud ke neuna ne nekeuma ne edumdumaan ni Hisus. Nekita rin dà arà ne mibperetiyaya sikandin te nevanhew si Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Misan warà dan pà lavew mekesabut dut te impesurat ne Lalag te Eleteala ne egkahi te egkevanew si Hisus.) ");
INSERT INTO mbi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ketà dà ne mid-ulì en ke deruwa ne edumdumaan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ugaid ne si Maria ne diyà te lihewangan te leveng ed-it-itendeg se edsinehew. Gewii rin te edsinehew ne midsiniling din ke leveng, ");
INSERT INTO mbi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ne rutun te leveng ne nekita rin se deruwa ne suluhuen te Eleteala ne utew mèmeputì se velegkas dan. Diyà dan mibpinuu te nesevukan te bangkey ni Hisus, seveka riyà te egkeulunan din, ne seveka kayi te egkeiwaran din. ");
INSERT INTO mbi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mid-insà dan ki Maria te, “Bayi, engkey ma ini se idsinehew nu?” Ke si Maria te, “Migkuwa ran ke bangkey rut te Kerenan tew ne warà ku metueni ke endei ran ewita!” ");
INSERT INTO mbi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nekeipus dà te edlalag ne midlilingey ne iyan din nekita si Hisus se ed-it-itindeg, ugaid ne warà din mekilala sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Bayi,” ke si Hisus, “engkey ma ini se idsinehew nu? Engkey se ebpemengaan nu?” Iyan kunaan ni Maria ke arà se etew ne edtuganur ketà te pemulaan, tembù be migkahi sikandin te, “Mama, embiya iyan ka migkuwa rut te bangkey rin ne kehiya nu kedì ke endei nu ewita sikandin su apey ku egkekuwa.” ");
INSERT INTO mbi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria,” ke si Hisus. Nerineg din dà arà ne midsinaru en si Maria ne migkehiyan din en te kinehiyan te Hibruhanen te, “Ew, Rebuni!” (Su riyà te kinehiyan te Hibruhanen ne iyan din meana ne “Meyterù.”) ");
INSERT INTO mbi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ne migkahi en si Hisus kandin te, “Kenà a nu pà geweri su warà e pà mekeulì diyà te Amey ku. Ugaid ne beyai nu ke menge suled ku ne penudtuli nu ve sikandan te, ‘Ed-ulì a riyà te Amey ku ne ke Amey nu red dema, ke Eleteala ku ne ke Eleteala nu red rema.’ ” ");
INSERT INTO mbi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Arà dà ne mibayaan en ni Maria Megdelina ne mibpenudtulan din en ke edumdumaan ni Hisus te nekita rin si Hisus ne mibpenudtul din dema kandan ke langun ne lalag ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ne ketà te hewii te Akad te merukilem en ne nevurun en ke menge edumdumaan ni Hisus diyà te senge baley, ne mibpemintù dan su egkeandek dan dut te menge egkeunutan te Hudiyanen. Ne netetau ran te kayi en mekeitindeg si Hisus te teliwarà dan. Ke sikandin te, “Na, mebmelilintad ke hinawa niyu!” ");
INSERT INTO mbi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nekeipus te edlalag ne impekita rin kandan ke menge velad din ne nepelian dut te lansang, ne impekita rin ded dema ke tengkiliran din ne mibpilak. Ne arà iya ne nengehalewhalew nevenar ke edumdumaan din te kebpekekita ran dut te Kerenan dan. ");
INSERT INTO mbi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne migkahi en maa si Hisus te, “Na, mebmelilintad ke hinawa niyu! Ne iring dut te midsuhù a te Amey ku ne Eleteala,” ke si Hisus, “ne edsuhuen ku rema sikiyu.” ");
INSERT INTO mbi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Neipus din te egkahi ini ne mibperiyupan din sikandan se egkahi te, “Na, ebpelumunan kew en dut te Kedesenan ne Ebpetuntul te Menusiyà!” ");
INSERT INTO mbi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Embiya ebpeseharen niyu ke menge salà te etew ne egkepesehad ini, ugaid ne embiya kenà niyu ebpeseharen ke menge salà din ne kenà dema ini egkepesehad.” ");
INSERT INTO mbi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ketà te kinepekitakita ni Hisus dut te menge edumdumaan din ne warà ketà si Tomas (ne mid-ingaranan te Seping). ");
INSERT INTO mbi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Guna su neuma rut te edumdumaan ni Hisus si Tomas ne mibpenudtulan dan te, “Nekita rey ke Kerenan tew.” Ne migkahi si Tomas te, “Kenà a ebperetiyaya keniyan te nevanew sikandin taman te egkekita ku ke mibpevayaan te lansang diyà te menge velad din wey taman pà te edtiyuken ku wey edsepuwen ku ke nepelian te bangkew riyà te tengkiliran din.” ");
INSERT INTO mbi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nekedsenge pedian maa ketà ne nevurun ke menge edumdumaan ni Hisus diyà te senge valey ne rutun en dema si Tomas. Ne mibpemintù dan, ugaid ne misan iring ketà ne neketekew en maa si Hisus nekeitindeg diyà te teliwarà dan. Ke sikandin te, “Na, mebmelilintad ke hinawa niyu.” ");
INSERT INTO mbi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Arà dà ne migkahi en sikandin diyà te ki Tomas te, “Tengtengi nu ini se velad ku, ne tiyuka nu ini se palad ku abpeg dut te palì te tengkiliran ku ne sepuwa nu rema! Engked ka te keduwaruwa nu, ne peretiyaya ka!” ");
INSERT INTO mbi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Migkahi si Tomas te, “Sikuna ke Kerenan ku, ne Eleteala ku!” ");
INSERT INTO mbi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Migkahi si Hisus kandin te, “Maa, arà pè be ne mibperetiyaya ka su nekita ad nikuna! Ugaid ne idtarem ku ini, egkehalew nevenar ke menge etew ne ebperetiyaya kedì misan warà dan mekekita kediey!” ");
INSERT INTO mbi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Merakel pà se mid-ulaula ni Hisus ne mekegeyip ne nekita rut te edumdumaan din ne warà ikesurat en kayi te riberù ini. ");
INSERT INTO mbi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ugaid ne ini se mekegeyip ne ulaula ne ingkesurat kayi su apey kew ebpekeperetiyaya te Anak te Eleteala si Hisus, ne ebpekeperetiyaya kew rema te sikandin ke Impasad te Eleteala ne Ebperetuen, su embiya ebperetiyaya kew kandin ne ebpeketelimà kew te umur ne warà edtemanan din. ");
INSERT INTO mbi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Guna su nekesahad en se pipira ne hewii ne mibpekitakita maa si Hisus dut te edumdumaan din diyà te beyvey te ranew ne ed-ingaranan te Tibiriyas. Ne iring kayi se ned-ulaula te kinepekitakita rin. ");
INSERT INTO mbi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nengevurun ketà ensi Simon Pedro, si Tomas (ne ed-ingaranan te Seping), si Natanael (ne ebpuun te inged ne Kana lusud te Geliliya), ne elin dema ke deruwa ne anak ni Sibidiyu, wey ruen pà ketà deruwa ne edumdumaan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne migkahi en si Simon Pedro te, “Ebpenginsedà e pad.” Migkahi en ke menge ruma rin te, “Eduma key keykew.” Arà dà ne mibpendiyan dan en te wayig ne mid-untud dan en te avang se ebpenginsedà, ugaid ne nepewpewaan dan se ebpenginsedà ne warà dan mekeutel. ");
INSERT INTO mbi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Guna su nepawà en ne riyan en si Hisus mid-it-itindeg te beyvey te wayig, ugaid ne warà mekilala dut te edumdumaan din. ");
INSERT INTO mbi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne migkahi si Hisus kandan te, “Na engkey, menge suled, nekeutel kew red?” Midtavak dan te, “Warà en iya!” ");
INSERT INTO mbi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Migkahi si Hisus te, “Iantug niyu ayan se biyala niyu keniyan te egkekewanan te avang niyu su apey kew ebpekeutel.” Arà dà ne in-antug dan en ke biyala ran ne wey ran gelengkena ne kenà dan en egkegaga su merakel ke neutel. ");
INSERT INTO mbi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nekita ran ini ne migkehiyan en dut te edumdumaan ni Hisus ne igkelimù din si Pedro te, “Sikandin ayan ke Kerenan tew!” Guna su nerineg ni Pedro te si Hisus bes arà ne ingkeseluub din maa ke kumbalà din (su mibpenluung ma sikandin) ne midlumbuk en sikandin diyà te wayig se ebpeebpet diyà te ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ne mid-untud te avang ke menge ruma rin se ebpeketundug kandin ne eguyud dut te biyala ran ne nekeutel te merakel ne serà. Ne kenà dan utew meriyù dut te tebtevasan te wayig su warà dà buwa mebmehatus ne meyterù. ");
INSERT INTO mbi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Guna su nekerunggù dan en ne iyan dan nekita se mid-ug-uhanga ne baha ne ruen ketà serà ne intuug ne ruen dema pan ne in-init. ");
INSERT INTO mbi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne migkahi si Hisus kandan te, “Ewita niyu kayi ke duma ne serà ne neutel niyu.” ");
INSERT INTO mbi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ne midlived si Simon Pedro riyà te avang ne miguyud din en ke biyala ne midsipek te derekelà ne serà, su iyan din kerakel ke neutel ne mehatus wey lelima nepulù wey tetelu. Ne misan iring ketà se kerakel din, ne warà mevindas ke biyala. ");
INSERT INTO mbi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Migkahi en si Hisus te, “Kuwa kew en ne ramag kew en!” Ne warà senge etew rà kandan ne neketikà ne ed-insà te, “Entei ka?” su netuenan dan en ma te si Hisus iyan ini ke Kerenan dan. ");
INSERT INTO mbi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ne migkuwa ni Hisus ke pan diyà te apuy ne mid-umun-umun din kandan, ne iring ded dema ketà ke serà. ");
INSERT INTO mbi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iketelu en ini te kebpekitakita ni Hisus dut te edumdumaan din te nevanew en sikandin. ");
INSERT INTO mbi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nekeipus dan se egkaan ne migkahi en si Hisus diyà te ki Simon Pedro te, “Simon, sikuna ini ke anak ni Juan, maa igkelimù a nu ve te muna pà dut te kegkelimù te ruma?” “Uya, Kerenan,” ke si Simon, “netuenan nu en se igkelimù ku sikuna.” Ne migkahi si Hisus te, “Tugenura nu ini se menge etew ku ne iring te nati te bilibili.” ");
INSERT INTO mbi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ne migkahi pà maa si Hisus te, “Simon, sikuna ini ke anak ni Juan, maa igkelimù a nu?” “Uya, Kerenan,” ke si Simon, “netuenan nu en se igkelimù ku sikuna.” Ne migkahi en maa si Hisus te, “Tugenura nu ini se menge etew ku ne iring te bilibili.” ");
INSERT INTO mbi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne migkahi pà maa si Hisus te, “Simon, sikuna ini ke anak ni Juan, maa igkelimù a nu?” Nerineg dà ni Pedro ne nemutu se hinawa rin su iketelu en ini te kedsulit ni Hisus te ed-insà kandin ke ruen limù din. Arà be ne migkahi en sikandin te, “Netuenan nu ke langun, Kerenan, ne netuenan nu en se igkelimù ku sikuna!” Migkahi en si Hisus te, “Tugenura nu ini se menge etew ku ne iring te menge bilibili ku. ");
INSERT INTO mbi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sebenarvenar ini se idsempità ku keykew ne embiya ke menguwed pà ne iyan ka edsesebitan, ne misan endei ka egkiyug ne riyà ka ebpesinaru. Ugaid ne embiya egkelukes ke en ne ebpekererepa ka ne ruen ruma ne ebpesebitan keykew ne edtuyuken ka riyà te kenà nu egkiyuhan.” ");
INSERT INTO mbi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iring ketà se kinekahi ni Hisus su idtarem din ke ralan te kemetayen ni Pedro ne ebpekereyù te Eleteala.) Ne migkahi en si Hisus kandin te, “Duma ka kediey!” ");
INSERT INTO mbi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Guna su nerineg ni Pedro se lalag ni Hisus ne midlilingey sikandin ne iyan din nekita ne edtundug kandan ke edumdumaan ni Hisus ne igkelimù din iya. Sikandin ini ke midsandig ki Hisus dut te kinelavung dan te warà pà mebpatey si Hisus, ne sikandin ini ke mid-insà ki Hisus te, “Entei ma se ed-ulug keykew, Kerenan?” ");
INSERT INTO mbi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Guna su nekita ni Pedro sikandin ne migkahi en diyà te ki Hisus te, “Kerenan, engkey ve rema se egketemanan kayi te ruma ta ini?” ");
INSERT INTO mbi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne midtavak si Hisus te, “Embiya iyan ku egkesuatan se biviyag pà sikandin taman ketà te kedlived ku kayi te ampew te dunya, ne maa engkey ve se keykew ketà? Kenà merakel se pegitunga nu, ugaid ne ruma kew kedì.” ");
INSERT INTO mbi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ketà ne nekeeneb ke tudtul dut te langun ne eduma ki Hisus te kenà en ebpatey ini se senge etew rut te edumdumaan din. Ugaid ne kenà ma arà ke migkahi ni Hisus se kenè en ebpatey su iyan din migkahi te, “Embiya iyan ku egkesuatan se biviyag pà sikandin taman ketà te kedlived ku kayi te ampew te dunya, ne maa engkey ve se keykew ketà?” ");
INSERT INTO mbi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ne ini se senge etew ne edumdumaan din ne migkahi ni Hisus ne warà duma ke kenà siaken iya ke midsurat kayi. Ne langun kayi te nekesurat ini ne nemetmetaan ku, ne edtitihusan ku te langun kayi ne benar. ");
INSERT INTO mbi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ruen pà lavew merakel ne mid-ulaula ni Hisus ne warè en ikesurat. Su embiya id-amin te edsurat ne antap ku ne misan ini se lusud te linengkevan ne kurang pà ne edtehuan.");
INSERT INTO mbi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Diyà te ki Teofilo: Ketà te neuna ne surat ku kenikew ne miguhud ku mekeatag te langun ne mid-ulaula ni Hisus wey ke langun ne kebpenurù din igenat te kinerudsù din te helevek din ");
INSERT INTO mbi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taman en te kebetuna kandin te Eleteala diyà te langit. Ugaid ne ketà te warà pà betuna sikandin ne midteleenan din ke menge etew ne mibpemilì din ne kedserihan din, ne ini se intelaan din ne egenat te Kedesenan ne Ebpetuntul te Menusiyà. ");
INSERT INTO mbi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guna su mid-imetayan sikandin ne nevanew en maa ne mibpekitakita sikandin dut te menge kedserihan din. Ne merakel ne tuus ne impekilala rin kandan su titihus te biviyag en sikandin. Su lusud te epat nepulù ne hewii ne kemerakel sikandin mibpekitakita kandan wey mibpengasak sikandin mekeatag dut te Kedatù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Keseveka te nevurun dan ne intelaan din kandan se egkahi te, “Kenà kew ed-awà kayi te inged ne Hirusalim, ugaid ne tehari niyu taman te ibehey en keniyu ini se Impasad te Amey ku ne nekahi ku en keniyu neraan. ");
INSERT INTO mbi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Su si Juan, ne wayig se imbunyag din te menge etew. Ugaid ne menge pipira pà ne hewii ne ebunyahan kew te edlumunan dut te Kedesenan ne Ebpetuntul te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Senge hewii ne nevurun ensi Hisus wey ke menge kedserihan din ne mid-insaan dan sikandin se egkahi te, “Kerenan, menu ini en be ke hewii ne ibpeulit nu ke sikami ne menge kevuwaran ni Israyil ke andang ne kedatù te sikami?” ");
INSERT INTO mbi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ne midtavak si Hisus te, “Ke Amey ku rà se ebayàbayà dut te egketemanan kayi te ampew te dunya wey keenu egked-ulaula, ne kenà ini idtuhut ne egketuenan niyu. ");
INSERT INTO mbi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ugaid ne embiya ebpekeuma en kayi te keniyu ke kedlumun dut te Kedesenan ne Ebpetuntul te Menusiyà,” ke si Hisus, “ne ebpeketelimà kew en te gehem ne sikiyu en ke ebpesabut mekeatag kediey kayi te inged ne Hirusalim, ne ieneb niyu en ini kayi te lusud te pruvinsiya te Hudiya, wey riyà dema te pruvinsiya te Semeriya, wey taman en diyà te epat ne pediyulu kayi te kelibutan.” ");
INSERT INTO mbi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Neipus din ini te edlalag ne mibatun en sikandin se ebpendiyà te langit. Ne kemulu ran pà ne edlingakà su edtengtengan dan sikandin, ne neelangan si Hisus te sehulapun ne in-anew ran en te mata. ");
INSERT INTO mbi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Edlingakà dan pà diyà te langit se edtengteng te kebetuneen kandin, ne netekew en se deruwa ne meama ne mibevelegkas te meputì ne nekeitindeg diy te uvey ran ");
INSERT INTO mbi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ne migkahi ran te, “Sikiyu ne menge riyà ebpuun te Geliliya, maan ke ed-itindeg kew kayi se edlingakà diyà te langit? Si Hisus ini ne nekita niyu ne mibatun diyà te langit ne edlived ded kayi, ne ini se kedlived din ne iring ded dut te nekita niyu sikandin ne mibatun diyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ketà ne mid-awà en ke menge kedserihan dutun te buvungan ne ed-ingaranan te Ulivuwen, ne mid-ulì dan en diyà te Hirusalim ne iyan din keriyù ne menge senge kilù. ");
INSERT INTO mbi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nekeuma ran diyà te Hirusalim ne mid-ulì dan diyà te sungkù dan diyà te divavew ne mid-ubpaan dan. Mesì dan ini ne si Pedro, si Juan, si Santiago, si Andres, si Felipe, si Tomas, si Bartolome, si Mateo, si Santiago ke anak ni Alfeo, si Simon ke Patriat (ne iyan din meana ne diralem se lengesa rin dut te inged din), wey si Hudas ke anak ni Santiago. ");
INSERT INTO mbi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Langun dan ne lelayun eburun su ebpengeningeni diyà te Eleteala, ne mid-amung dema ke menge meritan, elin dutun si Maria ke iney ni Hisus wey ke menge meama ne ari ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Senge hewii ketà ne ruen kevurunan te menge mibperetiyaya ne menge mehatus dan wey deruwa nepulù se miburun, ne mid-itindeg si Pedro se edlalag. ");
INSERT INTO mbi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Menge suled,” ke sikandin, “kenà egkepakey ne kenà edtumanen ke Lalag te Eleteala ne impesurat te Kedesenan ne Ebpetuntul te Menusiyà ki David dengan. Su impekahi rin neraan te si Hudas se ebpalad ki Hisus diyà te menge etew ne edsigkem kandin. ");
INSERT INTO mbi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Hudas ne senge etew ne ruma tew su netail ma sikandin ne ed-amung te helevek tew.” ");
INSERT INTO mbi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ne impemasa ni Hudas te tanà ke kureta ne impevayad din dut te meraat ne ulaula rin te ebpalad ki Hisus. Ne ketà sikandin neulug ne nekelangkeb ne minatey en, ne mibetu ke hetek din ne nevukayat ke bituka rin. ");
INSERT INTO mbi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nerineg ini dut te langun ne menge etew te Hirusalim, ne mid-ingaranan dan ini se tanà te Ekildama te kinehiyan dan ne iyan din meana ne “Tanà ne Mibayaran te Lengesa.”) ");
INSERT INTO mbi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Su ruen impesurat,” ke si Pedro, “diyà te riberù ne ed-ingaranan te Salmu ne egkahi te, ‘Berekat ne meewai ke ed-ubpaan din, ne warà be med-ubpà dutun,’ ne ruen dema impesurat ne egkahi te, ‘Ini se impehelevek kandin ne ibpehelevek en te ruma.’ ");
INSERT INTO mbi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ketà be,” ke si Pedro, “ne iyan iya se duen senge etew ne egkepemilì ne ebpekeamung kenitew te kedtitihus tew te nevanew en si Hisus ke Kerenan tew. Ebpemilien tew ini dut te menge ruma tew te hewii te kebpekiduma tew ki Hisus ke Kerenan tew igenat te kebpesabut ni Juan mekeatag te kebpembunyag taman te kinekevatun en ni Hisus diyà te langit.” ");
INSERT INTO mbi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ne mid-ingaran dan te deruwa ne etew ne ebpedsemilien dan ke endei rapit, si Jose ne ed-ingaranan ded ki Barsabas (ne ed-ingaranan ded maa ki Justo), ne senge etew ne si Matias. ");
INSERT INTO mbi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ketà ne mibpengeningeni ran se egkahi te, “Kerenan, netuenan nu ke engkey se netahù te hinawa te langun ne menge etew. Ne guntaani ne ipekita nu kenami ke endei se nepemilì nu kayi te deruwa ini ");
INSERT INTO mbi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","se egelevek dut te helevek ne intail nu rut te kedserihan nu. Su si Hudas ne mid-ewaan din ini se impehelevek kandin, ne mibpendiyà te egkeubpaan ne edait kandin.” ");
INSERT INTO mbi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nekeipus dan te ebpengeningeni ne mibunutbunut dan ne ke ngaran ni Matias se migemew, ne ketà ne ingkeuman sikandin dut te sepulù wey seveka ne kedserihan. ");
INSERT INTO mbi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Guna su neuma en ke hewii te pista ne ed-ingaranan te Pintikusti, ne langun ne mibperetiyaya ki Hisus ne nevurun diyà te seveka ne valey. ");
INSERT INTO mbi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ne takin ne ruen utew merahing ne nerineg dan ne riyà ebpuun te langit ne iring te mevandes ne keramag ne egkenegkeneg. Ne arà se dahing ne nekeeneb ketà te lusud te valey ne nevurunan dan. ");
INSERT INTO mbi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne ketà ne nekita ran se iring te regreg te apuy ne nekelayap ne mibpenrenà dut te uman senge etew kandan. ");
INSERT INTO mbi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne mid-lumun kandan ke Kedesenan ne Ebpetuntul te Menusiyà ne nekelalag dan te menge kinehiyan ne kenà dan egketuenan ibpepevayà dut te gehem te Kedesenan ne Ebpetuntul te Menusiyà ne mibpelalag kandan. ");
INSERT INTO mbi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ketà ne hewii ne ruen menge Hudiyanen ne mid-ubpà diyà te Hirusalim ne riyà ebpuun te idsengelulumpuk ne inged kayi te ampew te dunya ne laus ne edtuman te suhù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Guna su nerineg dan arà se merahing, ne denda ran se nevurun ketà. Ne neinuinu ran nevenar su uman seveka kandan ne nerineg din ke kinehiyan din ketà te lalag te menge mibperitiyaya ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Neinuinu ran ne negeyip dan se egkahi te, “Engkey ve vuwa ini? Su menge etew ini ne riyà ebpuun te Geliliya ne edlalag! ");
INSERT INTO mbi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ne meambe ke iyan ta egkerineg ne ebpekelalag dan te kinehiyan te uman seveka kenita? ");
INSERT INTO mbi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Su sikami ini ne riyà ebpuun te idsenge inged su ruen ebpuun te inged ne Partya, ruen ebpuun te Midya, wey ebpuun te Ilam. Ne ruen ebpuun te Misuputamya, ebpuun te Hudiya, ebpuun te Kepedusya, ne ebpuun te Puntu wey Asya. ");
INSERT INTO mbi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Duen ruma tew ne riyà ebpuun te Prigiya, ebpuun te Pempilya, ebpuun te Ihiptu wey ebpuun te menge inged ne lusud te Libya ne uvey te inged ne Sirini. Duen dema ebpuun te inged ne Ruma ");
INSERT INTO mbi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ne menge Hudiyanen wey kenà menge Hudiyanan ne edruyud te menge penduan te Hudiyanen. Duen dema riyà ebpuun te inged ne Krita wey riyà ebpuun te inged ne Erabiya. Ne misan warà memeked-iring ke kinehiyan ta, ne nesebutan tew langun su nerineg tew ne nekelalag dan dut te langun ne kinehiyan tew mekeatag te mekegeyip ne mid-ulaula te Eleteala.” ");
INSERT INTO mbi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ne neinuinu ran su warà dan mesebuti ini se ned-ulaula ne mibpein-inseey ran te, “Engkey ve vuwa ini?” ");
INSERT INTO mbi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ugaid ne ruen duma diyà te kandan ne edsumpeliten dan ini se menge mibperetiyaya se egkahi te, “Netevereg ini se menge etew!” ");
INSERT INTO mbi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ketà ne mid-itindeg si Pedro elin ke menge ruma rin ne sepulù wey seveka ne kedserihan ne mibpekerahing te lalag din se egkahi te, “Sikiyu ne menge ruma ku ne Hudiyanen wey langun niyu ne menge etew kayi te Hirusalim, pemineha niyu ini se egkehiyen ku su ruen egkepenudtul ku keniyu. ");
INSERT INTO mbi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Iyan niyu kunaan ne netevereg en ini se menge ruma ku, ugaid ne kenà egkepakey su edluuk pà ebpemenayik ke andew. ");
INSERT INTO mbi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ini se nekita niyu guntaani,” ke si Pedro, “ne impekahi en dengan te Eleteala ki Joel, senge etew ne ebpelambas te Lalag te Eleteala, su migkahi rin te, ");
INSERT INTO mbi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ne ibpelumun ku te langun ne menusiyà ke Kedesenan ne Ebpetuntul te Menusiyà ketà te mehaan en egkeuma ke mewri ne hewii. Ne ke inenakan niyu ne menge meama wey meritan ne ibpesabut te menge etew ini se lalag ku. Ke menguwed ne menge meama ne ruen ibpekita ku kandan, ne ke lukes ne menge meama ne ruen ibpetehinep ku kandan. ");
INSERT INTO mbi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uya,’ ke se Eleteala, ‘iring din ded dema ke menge sugsuhuen ku, ne menge meama wey meritan, ne ibpelumun ku kandan ke Kedesenan ne Ebpetuntul te Menusiyà ketà keuremà, ne ibpesabut dan te menge etew ini se lalag ku. ");
INSERT INTO mbi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne ruen ulaula ne mekegeyip ne ibpekita ku diyà te langit wey mekeinuinu ne ed-ul-ulaan ku kayi te tanà, su ruen egkekita ne lengesa, apuy, wey mekepal ne evel. ");
INSERT INTO mbi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Duen hewii,’ ke se Eleteala, ‘ne ebmerusirem ke andew, ne ebmerihà ke vulan iring te lengesa, embiya mehaan en ebpekeuma ini se mevantug ne hewii ne kedtimbang te Kerenan dut te langun ne menusiyà. ");
INSERT INTO mbi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne ketà ne hewii ne piya engkey ne etew ne ebpeiruiru se egkahi te, “Ipelihaun a te menge salà ku, Kerenan,” ne egkepelihaun dut te keberedusaan din.’ ");
INSERT INTO mbi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Sikiyu ne menge ruma ku ne Hudiyanen,” ke si Pedro, “pemineha niyu ini se egkehiyen ku. Si Hisus ne riyà ebpuun te Nesarit, ne mepayag ne impepengkayi sikandin te Eleteala, ne ruen gehem te Eleteala ne riyan en te kandin su nekita ini dut te langun ne mibpeveelan kandin te Eleteala ne mekegeyip wey ke mid-ulaula rin ne mekeinuinu. Netuenan niyu ini su kayi mid-ulaula ini te keniyu. ");
INSERT INTO mbi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Daan en ne netuenan te Eleteala te ibpalad si Hisus keniyu su ini ke intahù te itungan din. Ne mibpeimetayan niyu sikandin rut te menge etew ne mekesesalà ne inlansang dan sikandin diyà te pinebelavag ne kayu. ");
INSERT INTO mbi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ugaid ne impeliyu te Eleteala si Hisus dut te inged ne Iveyaan su mibanew rin, su kenà egkepakey ne egkeveyveyaan si Hisus te kemetayen. ");
INSERT INTO mbi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Su ruen impesurat ni David rengan mekeatag ki Hisus ne egkahi te, ‘Layun edumà kedi ke Kerenan tew; uya, ini en te uvey ku sikandin, tembù kenà a egkeandek. ");
INSERT INTO mbi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Engketà arà ne mehalew nevenar ini se hinawa ku, ne misan kayi te lalag ku ne egketuusan nevenar. Ne misan ebpatey a ne idsarig ku kandin ini se lawa ku, ");
INSERT INTO mbi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","su netuenan ku te kenà din idtahak ini se gimukud ku diyà te inged ne Iveyaan; siaken ne laus ne edtuman te suhù din, ne kenà din idtahak ini se lawa ku te egkeredak dà. ");
INSERT INTO mbi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impekita rin kediey ke ibayà te ebpendiyà te umur ne warà edtemanan din; wey mehalew a nevenar su ini en te kedì sikandin.’ ");
INSERT INTO mbi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Na, menge suled ku,” ke si Pedro, “kenà ku idsanggel te egkehiyen ku keniyu mekeatag dut te tipewna ne datù tew rengan ne si David, ne neuhet en ne minatey ne inleveng ne kemulu red lavew ini se leveng din taman guntaani. ");
INSERT INTO mbi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Senge etew si David ne ebpelambas te Lalag te Eleteala rengan, ne netuenan din ke impasad te Eleteala kandin. Su iyan impasad kandin te Eleteala ne mevaher ne ruen senge etew ne kevuwaran ni David ne egkevaluy ne ratù keuremà iring kandin. ");
INSERT INTO mbi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Netuenan neraan ni David ini se ed-ul-ulaan te Eleteala ketà te akir din ne hewii, tembù be nelalag din mekeatag dut te kegkevanew ni Hisus, ke Impasad te Eleteala rengan ne Ebperetuen te langun, su migkahi si David te, ‘Warà sikandin intahak diyà te inged ne Iveyaan; ne warà neredak ke lawa rin diyà te leveng.’ ");
INSERT INTO mbi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ne ini se nekahi ni David ne iyan iya si Hisus,” ke si Pedro, “ne mibanew te Eleteala, ne langun dey ne neketitihus ne benar ini su nekita kayi te mata rey. ");
INSERT INTO mbi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mibatun te Eleteala si Hisus ne riyà impepinuu te rapit te egkekewanan te Amey rin ne Eleteala, ne imbehey kandin dut te Amey rin ke Kedesenan ne Ebpetuntul te Menusiyà ne impasad kandin. Ne imbehey red kandin lavew ke ketengdanan te ibpepengkayi rin ke Kedesenan ne Ebpetuntul te Menusiyà dut te sikami. Ne ini se nekita niyu wey nerineg niyu ne ini se mekegeyip ne mid-ulaula dut te Kedesenan ne Ebpetuntul te Menusiyà ne imbehey rin kenami. ");
INSERT INTO mbi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, kenà si David ini se mibatun diyà te langit ugaid ne ruen migkahi rin te, ‘Migkahi ke Eleteala ketà te Kerenan ku te: Kayi ka pinuu te rapit te egkekewanan ku ");
INSERT INTO mbi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","taman te ebpenggiekan ku ke menge kunterà nu.’ ");
INSERT INTO mbi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Tembù be,” ke si Pedro, “langun te sikita ne menge kevuwaran ni Israyil ne iyan iya se edsebuten tew te si Hisus ini ne inlansang niyu diyà te pinebelavag ne kayu ne sikandin ke netendù te Eleteala ne Kerenan tew wey ke Impasad ne Ebperetuen te langun.” ");
INSERT INTO mbi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nerineg ini rut te menge etew ne iring te migkeres ke atey ran ne migkehiyan dan si Pedro wey ke ruma ne menge kedserihan te, “Menge suled, engkey en buwa se ed-ul-ulaan dey?” ");
INSERT INTO mbi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ne migkahi si Pedro te, “Engkeri niyu ke meraat ne ed-ul-ulaan niyu ne pebunyag kew, uman seveka keniyu, su tuus te mibpesakup kew en ki Hisu Kristu. Ne ebpeseharen te Eleteala ini se meraat ne ulaula niyu ne ke Kedesenan ne Ebpetuntul te Menusiyà ne ibpeubpà din kayi te keniyu. ");
INSERT INTO mbi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Su ini ke impasad te Eleteala keniyu wey ke menge kevuwaran niyu abpeg te langun ne menge etew ne ed-ubpà diyà te meriyù, langun ne ibpeuvey dut te Kerenan tew ne Eleteala ne eduma kandin.” ");
INSERT INTO mbi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ne merakel pà se lalag ni Pedro te edneyùneyù kandan ne meilut se kebuyù din se egkahi te, “Pekeriyù kew dut te menge etew te guntaani ne ed-ulaula te meraat su edusaan dan te Eleteala!” ");
INSERT INTO mbi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne merakel se mibperetiyaya dut te lalag ne impesabut ni Pedro ne mibpebunyag dan tuus te ebperetiyaya ran en ki Hisus. Ne arà ne hewii ne menge tetelu ne ngivu se menge mibperetiyaya ne nekeuman dut te menge etew ne mibperetiyaya ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Uman gewii ne ebpemineg dan dut te ibpenurù te menge kedserihan, ne neseveka ke hinawa dut te langun ne menge mibperetiyaya ki Hisus. Langun dan ne mid-amung te egkaan te pan su kedtenuri ran dut te kinepatey ni Hisus, ne mid-amung dan lavew te kebpengeningeni te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne merakel se mibeelan ne mekegeyip wey mekeinuinu ne ulaula dut te menge kedserihan ni Hisus, ne ketà ne neandek ke langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne langun ne menge mibperetiyaya en ki Hisus ne meilut se kegkeseveka ran, ne piya engkey se kearen dan ne ibpevegbehayi ran dut te menge ruma ran. ");
INSERT INTO mbi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ne mibpasa ran ke menge kearen dan wey tanà dan ne ke elehà din ne mid-umun-umun dan diyà dut te langun ne menge ruma ran su atag dut te kurang kandan. ");
INSERT INTO mbi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uman gewii ne langun dan ne eburun diyà te Nekebpuru ne valey te Eleteala. Ne egkeseveka ran lavew ne egkaan diyà te menge valey ran, ne mehalew nevenar se hinawa ran, ne mibehey ran te ruma ran te lila ne hinawa ran. ");
INSERT INTO mbi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ne mideyù dan te Eleteala, ne egkeedatan dan dut te langun ne menge etew. Ne uman gewii ne ruen menge etew ne mibperetiyaya ki Hisus ke Kerenan tew ne ini ne menge etew ne ingkeuman te Kerenan dut te langun ne mibperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Senge hewii ne mibpendiyà si Pedro ki Juan te Nekebpuru ne Valey te Eleteala ketà ne edluuk en ebpemenaug ke andew su ini se netahù ne hewii te kebpengeningeni. ");
INSERT INTO mbi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ne diyà te Nekebpuru ne Valey te Eleteala, ketà te bengawan ne ed-ingaranan te Mekempet ne Bengawan, ne ruen meama ne ebpememuyù ne nepungkù igenat dà te ked-enaka kandin. Uman gewii ne id-ated sikandin ketà te bengawan su ebpememuyù te kureta dut te menge etew ne edlusud dut te Nekebpuru ne Valey te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Guna su nekita rin ne edlusud en si Pedro ki Juan, mibuyuen sikandin te kureta. ");
INSERT INTO mbi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Midtengtengan sikandin ni Pedro ki Juan ne migkahi si Pedro te, “Tengtengi key nikuna!” ");
INSERT INTO mbi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Midlingakà din sikandan su kunaan din ke ruen kureta ne ibehey kandin. ");
INSERT INTO mbi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ugaid ne migkahi si Pedro te, “Warà en kureta ku, ugaid ne ini se ruen kayi te kedì ne ivehey ku keykew. Ipepevayà dut te gehem te ngaran ni Hisu Kristu ne riyà ebpuun te Nesarit, ne ipanew ka!” ");
INSERT INTO mbi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ketà ne migeweran ni Pedro ke belad din ne kewanan su ibpeitindeg din. Arà dà ne mibmeveher en ke menge paa dut te meama. ");
INSERT INTO mbi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ne mid-umbetut se ed-itindeg ne mid-ipanew. Ketà ne miduma kandan te edlusud dut te Nekebpuru ne Valey te Eleteala ne midlinglingketew se ed-ipanew ne edeyù te Eleteala te keupiya rin. ");
INSERT INTO mbi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nekita rut te menge etew ketà ne ed-ipanew ne edeyù te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Guna su nekilala ran te sikandin ke pungkù ne ebpimpinuu riyà te bengawan ne ed-ingaranan te Mekempet, ne neinuinu ran nevenar wey negeyip dan dut te ned-ulaula rin. ");
INSERT INTO mbi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ketà te egawed pà ke meama ki Pedro wey ki Juan diyà te palàpalà ne ed-ingaranan te Palà-palà ni Salomon, ne mibpelelahuy ke menge etew se eburun ketà su negeyip dan nevenar. ");
INSERT INTO mbi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Guna su nekita ni Pedro ne nevurun en ke menge etew ne migkehiyan din sikandan te, “Menge ruma ku ne kevuwaran ni Israyil, meambe ke negeyip kew kayi te ini ne ned-ulaula? Ne meambe ke edtengtengan key nikiyu? Maa, kunaan niyu ke kenami rà ne gaga se nekeipanew ini se meama etawa mekeatag te ketidtu rey ne nekeipanew en ini? Kenà! ");
INSERT INTO mbi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ugaid ne ke Eleteala ne iyan ed-erapen dut te menge keep-epuan tew ne si Abraham, si Isaac wey si Jacob,” ke si Pedro, “ne impepurù din ke sugsuhuen din ne si Hisus su mibatun din. Ugaid te kayi pà sikandin te ampew te dunya, ne impalad niyu sikandin diyà te menge egkeunuten niyu diyà te gubirnu niyu su ebpeimetayan. Ini se mid-ulaula niyu misan ibpeliyu perem sikandin ni Pilatu ke gubinedur, ugaid ne warà kew medtuhut su mid-engkenà kew kandin diyà te etuvangan ni Pilatu. ");
INSERT INTO mbi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Metilak nevenar se atey ni Hisus wey metidtu sikandin, ugaid ne warà niyu tuhuti ne ibpeliyu sikandin ni Pilatu su nasì niyu pà buyua te iyan din ibpeliyu rut te bilengguan ke senge etew ne terevunù. ");
INSERT INTO mbi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ne mibpeimetayan niyu sikandin, ke ebpuunan te umur ne warà edtemanan din; ugaid ne mibanew te Eleteala sikandin. Ne ebpeketitihus key ketà te nevanew en sikandin su nekita rey. ");
INSERT INTO mbi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na mekeatag te ini se pungkù ne behu pà ne nekeipanew,” ke si Pedro, “ne mibmevaher en ke menge paa rin su egenat dut te gehem ne ibpepevayà te ngaran ni Hisus. Su ini se etew ne egkekilala niyu wey ini se ned-ulaula rin ne nekita niyu ne mid-ulaula ini ni Hisus atag dut te kebperetiyaya rey kandin. Uya, ke kebperetiyaya rey ki Hisus se ingkeulii rin iring kayi te nekita niyu en langun. ");
INSERT INTO mbi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na, menge suled,” ke si Pedro, “netuenan ku te sikiyu wey ke menge unuten niyu ne ini se mid-ulaula niyu ki Hisus ne mibeelan niyu ini su warà niyu mesebuti ke meana rut te mid-ulaula niyu kandin. ");
INSERT INTO mbi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ugaid ne ini se mid-ulaula niyu ne ini ke ralan te kegketuman din ke Lalag te Eleteala ne impesurat din dengan dut te langun ne menge etew ne ebpelambas te lalag din, su ruen nekahi rin neraan mekeatag dut te Impasad din ne Ebperetuen te langun, ne edresayen sikandin. ");
INSERT INTO mbi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na,” ke si Pedro, “pemedsendit kew wey engkeri niyu ini se meraat ne ed-ul-ulaan niyu, ne ibehey niyu ke hinawa niyu te Eleteala su apey egkepesahad din ke menge meraat ne ed-ul-ulaan niyu. Embiya ini se ed-ul-ulaan niyu, ");
INSERT INTO mbi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ne egkeuma ke hewii ne ebeg-eten ke hinawa niyu te Eleteala ne ibpepengkayi rin te ampew te dunya si Hisus, ini ke midtendù din neraan ne Impasad din ne Ebperetuen keniyu. ");
INSERT INTO mbi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ugaid ne riyà pà ed-ubpà si Hisus te langit taman te kenà pà egkeuma ke hewii ne ebehuwen dut te Eleteala ke langun taman. Ne an pà ne edlived sikandin kayi te ampew te dunya iring dut te impesabut te Eleteala rengan dut te menge etew ne ebpemelambas te Lalag din. ");
INSERT INTO mbi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Su iyan migkahi ni Moises dengan dut te keep-epuan tew ne menge Hudiyanen ne, ‘Ruen edsuhuen dut te Eleteala ne Kerenan tew ne ibpepengkayi rin te keniyu ne ebpelambas te Lalag din iring dut te siaken, ne senge etew sikandin dut te ruma niyu ne Hudiyanen. Iyan iya se tumana niyu ke langun ne egkehiyen din keniyu. ");
INSERT INTO mbi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ne piya engkey ne etew ne kenà edtuman te lalag din ne edereetan sikandin su kenà ragkes dut te menge etew te Eleteala,’ ke se impesurat ni Moises dengan. ");
INSERT INTO mbi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na,” ke si Pedro, “ke menge etew ne ebpelambas te Lalag te Eleteala rengan igenat ki Samuel wey ke ebpeketundug kandin, langun dan ne pinekahi te Eleteala mekeatag te ini ne mibpayag neraan mekeatag ke engkey se egked-ulaula guntaan. ");
INSERT INTO mbi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ne ini ke impasad te Eleteala rengan ne impepevayà din dut te menge etew ne ebpelambas te lalag din ne ini ne pasad din keniyu, su sikiyu ne nekeuman dut te impasad te Eleteala rut te menge keep-epuan niyu. Su ruen impasad te Eleteala dut te keep-epuan tew ne si Abraham se egkahi te, ‘Kayi ibpepevayà te kevuwaran niyu ne ebpeneuven ku ke langun ne menusiyà kayi te ampew te dunya.’ ");
INSERT INTO mbi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tembù be,” ke si Pedro, “mibpemilì te Eleteala si Hisus ne sugsuhuen din ne impeuna rin impepengkayi te kenitew ne menge Hudiyanen su apey ki ebpeneuva te Eleteala su ibpeengked ki rin dut te meraat ne ed-ul-ulaan tew.” ");
INSERT INTO mbi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ne ketà te kemulu pà edlalag si Pedro wey si Juan te menge etew, ne mid-uvey en kandan ke menge terebpelengesa, ke mepurù dut te menge ebantey kayi te Nekebpuru ne Valey te Eleteala, wey ke menge Sadyusiyu. ");
INSERT INTO mbi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nengeepes dan dut te impenurù eni Pedro te kegkevanew ni Hisus se tuus te egkevanew red keuremà ke menge etew ne minatey ne mibperetiyaya ki Hisus. ");
INSERT INTO mbi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ketà ne midsigkem dan si Pedro ki Juan ne geina te meapun en arà ne mibilanggù dan taman te nepawà. ");
INSERT INTO mbi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ugaid ne merakel se mibperetiyaya ki Hisus dut te menge etew ne nekerineg te lalag ni Pedro, ne arà ne mid-iseg ke kerakel dut te meama rà ne menge lelima ne ngivu. ");
INSERT INTO mbi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ketà te neketundug ne hewii, ne nevurun dut te inged ne Hirusalim ke menge egkeunutan te Hudiyanen, ke menge pekilukesen, wey ke menge meyterù te penduan. ");
INSERT INTO mbi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Elin dema rutun ne si Anas ke Pinekemepurù dut te menge Terebpelengesa, si Keyipas, si Juan wey si Alejandro, wey ruen duma ne menge suled dut te Pinekemepurù ne Terebpelengesa. ");
INSERT INTO mbi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ne impeetuvang dan si Pedro wey si Juan ne mibpenginsaan dan te, “Engkey ki gehem kayi te ingkeulii rin ini se etew? Ne endei kew megkuwa te ini ne gehem?” ");
INSERT INTO mbi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ne midlumun ki Pedro ke Kedesenan ne Ebpetuntul te Menusiyà ne midtavak se egkahi te, “Sikiyu ne menge egkeunutan dey wey menge pekilukesen dey, ");
INSERT INTO mbi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","embiya iyan niyu id-insà kenami mekeatag kayi se meupiya ne ned-ulaula te ini ne etew ne daan ne pungkù wey embiya iyan niyu id-insà ke engkey ki gehem se ingkeulii rin, ");
INSERT INTO mbi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ne sikiyu wey langun ne menge etew te Israyil ne sebuta niyu te iyan kebpekeitindeg kayi te meama ne ini se etuvangan niyu ne neulian en su atag dut te gehem ne ibpepevayà dut te ngaran ni Hisu Kristu ne riyà ebpuun te Nesarit. Si Hisus ini ke impelansang niyu riyà te pinebelavag ne kayu, ugaid ne mibanew en te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Hisus ini se nekahi dut te Lalag te Eleteala ne impesurat din dengan se egkahi te, ‘Ke pelaus ne mid-engkeran dut te sikiyu ne ebpemevaley su kunaan niyu ke warà rantek din, ne iyan en iya ini nepemilì ne segkad te valey.’ ");
INSERT INTO mbi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne sikandin dà se ebpekepeliyu keytew rut te keberedusaan tew,” ke si Pedro, “su warà duma ne kayi te ampew te dunya ne imbehey te Eleteala ne ebpekegaga ne ebpekepeliyu keytew su sikandin dà.” ");
INSERT INTO mbi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ne guna su nekita rut te menge Perekukum te kenà egkeandek si Pedro wey si Juan ne edlalag ne negeyip dan su netuenan dan te mevavà se nepengedian kayi te deruwa su menge etew rà dè duen. Ne ketà ne netenuran dan te midumdumaan dan ni Hisus. ");
INSERT INTO mbi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne warà dan mekekahikahi su nekita ran ini se meama ne daan ne pungkù ne neulian ne ed-itindeg ketà te uvey ni Pedro ki Juan. ");
INSERT INTO mbi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tembù be impeluwal dan en ketà te egkukuman te mibpein-inseey ini se menge Perekukum te, ");
INSERT INTO mbi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Engkey se ed-ul-ulaan tew kayi te menge etew ini?” ke sikandan. “Su netuenan te langun ne menge etew kayi te Hirusalim te mibaal dan te ulaula ne mekegeyip nevenar, ne kenà tew igkeparew. ");
INSERT INTO mbi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ugaid,” ke sikandan, “ne ibaag tew kandan te kenà dan en maa ebpekelalag te misan engkey ne etew mekeatag dut te ngaran ni Hisus su apey kenà pà ebpekeeneb ini rut te menge etew.” ");
INSERT INTO mbi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ketà ne mid-umew ran si Pedro ki Juan ne imbaag dan kandan ne migkahi te, “Kenà niyu en be igkepenurù etawa ibpekelalag ini mekeatag ki Hisus.” ");
INSERT INTO mbi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ugaid ne migkahi si Pedro wey si Juan te, “Pegpegitunga niyu ke endei rapit te metidtu riyà te etuvangan te Eleteala te ebperumaruma key keniyu etawa ebperumaruma key te Eleteala. ");
INSERT INTO mbi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Su kenà egkepakey ne ebpekeengked key se ebpemenudtul dut te nekita te mata rey wey nerineg dey.” ");
INSERT INTO mbi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Meilut nevenar se kinebaag kandan dut te menge Perekukum, ne ketà ne impeliyu ran en. Warà dan metikà te ebpekesakit si Pedro ki Juan su neandek dan dut te langun ne menge etew ne edeyù te keupiya te Eleteala su atag dut te ini ne ned-ulaula. ");
INSERT INTO mbi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ne ini se nepungkù ne etew ne neulian dut te mekegeyip ne ulaula ne labi en epat nepulù se rahun din. ");
INSERT INTO mbi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Guna su impeliyu ran en si Pedro ki Juan ne mid-ulì dan en diyà te menge ruma ran ne mibperetiyaya, ne mibpenudtul dan en ke langun ne migkahi dut te menge terebpelengesa wey menge pekilukesen. ");
INSERT INTO mbi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nerineg dà dut te menge mibperetiyaya ne nevurun dan te neseveka se hinawa ran te ebpengeningeni te Eleteala. “Is, ke Eleteala ne ebayàbayà te langun, sikuna ke midlimbag te langit wey tanà wey ke rahat wey langun ne tahù ketà. ");
INSERT INTO mbi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Su impekahi nu rut te keep-epuan dey ne si David ne sugsuhuen nu ibpepevayà dut te Kedlumun te Kedesenan ne Ebpetuntul te Menusiyà ne migkahi te, ‘Meambe ke neepes ke menge etew ne kenà Hudiyanen? Ne meambe ke netahù te itungan dut te menge etew se ed-ulaula ran te ed-atu ki Hisus su ini ne ulaula ne kenà dan egketuman. ");
INSERT INTO mbi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Su mibpenehana en ke menge datù kayi te ampew te dunya, ne nevurun en ke menge egkeunutan su ed-atu dut te Eleteala ne Kerenan; uya, egkunterà dut te Impasad din ne Ebperetuen te langun.’ ");
INSERT INTO mbi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Is, Eleteala,” ke sikandan, “ini se impekahi nu ki David dengan ne netuman en su nevurun en ke menge Hudiyanen wey ke kenà menge Hudiyanen diyà te engki Hirudis wey si Gubinedur Punsiyu Pilatu kayi te inged ne Hirusalim su neseveka ran en ne egkunterà ki Hisus, ini se sugsuhuen nu ne meputì nevenar se atey rin, ini se Impasad nu ne Ebperetuen te langun. ");
INSERT INTO mbi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iyan dan mid-ulaula ne ini se raan en ne netahù te itungan nu ne egked-ulaula. Netuenan nu ini su ruen gehem nu wey ini se kiyug nu ne egked-ulaula. ");
INSERT INTO mbi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na guntaani, Kerenan, netuenan nu ini se mevaher ne menge imbaag dan kenami. Behera nu ke hinawa rey ke sikami ne menge sugsuhuen nu, su apey key kenà egkeandek te kebpenudtul dut te lalag nu. ");
INSERT INTO mbi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipayag nu ke gehem nu su apey egkeulii ke menge ederaru wey ipekita nu ke ebeelan nu ne mekeinuinu wey ulaula nu ne mekegeyip ibpepevayà dut te ngaran ni Hisus ke sugsuhuen nu ne meputì nevenar se atey rin.” ");
INSERT INTO mbi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Guna su nekeipus dan se ebpengeningeni ne neheram dan ne migkugel te Eleteala ini se baley ne nevurunan dan. Ne langun dan ne midlumunan dut te Kedesenan ne Ebpetuntul te Menusiyà, ne ketà ne mibmevaher en ke hinawa ran te ebpemenudtul dut te Lalag te Eleteala te warà kegkeandek dan te piya engkey ne etew. ");
INSERT INTO mbi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Langun dan ne mibperetiyaya ki Hisus ne egkeseveka ke itungan dan wey hinawa ran. Warà seveka kandan ne nekepegitung dut te kandin ne menge aren ne kandin dà, ugaid ne mibpevegbehayà dan te langun ne kearen dan. ");
INSERT INTO mbi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne ini se menge kedserihan, ne dekelà se gehem dan te ebpesabut te nevanew en si Hisus ke Kerenan tew. Ne rekelà se penaub te Eleteala dut te langun dan. ");
INSERT INTO mbi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tembù be warà seveka kandan ne ruen kurang din dut te keuyehan, su embiya ruen seveka ne ruen kurang din ne ke menge ruma rin ne ebpasa te tanà etawa baley ran ne ke elehà din ");
INSERT INTO mbi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne ibehey ran dut te menge kedserihan su apey ed-um-umunen dut te langun atag dut te kurang kandan. ");
INSERT INTO mbi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ketà ne hewii ne ruen senge etew ne ed-ingaranan ki Jose ne diyà in-anak te Sipru. Hudiyanen sikandin ne kevuwaran ni Levi, ne iyan in-ingaran kandin dut te menge kedserihan ne si Bernabe (ne iyan din meana ne “Ke Ebag-et te Hinawa te Ruma Rin”). ");
INSERT INTO mbi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ne ruen tanà ni Bernabe ne mibpasa rin ne ke elehà ketà ne imbehey rin dut te menge kedserihan. ");
INSERT INTO mbi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ne ruen meama ketà ne ed-ingaranan ki Ananias ne ke esawa rin ne ed-ingaranan ki Sapira. Duen tanà dan ne mibpasa ran, ");
INSERT INTO mbi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ugaid ne ruen duma dut te elehà ne intahak din ki Sapira ne warà din ipayag su kiyug ded dema dut te esawa rin. Ne ini se nesamà imbehey rin dut te menge kedserihan se egkahi te ini en imbe ke langun ne elehà din. ");
INSERT INTO mbi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ne migkehiyan sikandin ni Pedro te, “Ananias, meambe ke midtuhut ka ne ke datù te pekaid se ebayàbayà te hinawa nu su midtarùtarù ka rut te Kedesenan ne Ebpetuntul te Menusiyà? Su ruen intahak nu ne elehà dut te mibpasa nu ne tanà. ");
INSERT INTO mbi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Gewii te warà nu pà mebpasa ke tanà nu, ne keykew ayan. Ne guna su mibpasa nu en, ne sikuna red lavew se ebayàbayà dut te elehà din. Na, meambe ke nepegitung nu se ini ne ulaula ne meraat te iring kayi? Su kenà etew rà se edterùteruan nu, ugaid ne ke Kedesenan ne Ebpetuntul te Menusiyà.” ");
INSERT INTO mbi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nerineg dà ini ni Ananias, ne nepiley en sikandin su minatey en ne langun dut te nekerineg te ini ne ned-ulaula dan ne nengeandek nevenar. ");
INSERT INTO mbi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ketà ne mid-uvey ke menge menguwed ne meama ne mibukusan dan ke bangkey rin ne mid-ewit dan su idleveng. ");
INSERT INTO mbi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nekesahad te menge tetelu ne uras ne nekeuma en ke esawa ni Ananias, ugaid ne warà din metueni ini se netemanan ni Ananias. ");
INSERT INTO mbi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne migkehiyan sikandin ni Pedro te, “Menu, ini rè be iya ke langun ne elehà dut te mibpasa niyu ne tanà? Idtarem nu kedì!” “Uya,” ke se meritan, “ayan dà iya langun.” ");
INSERT INTO mbi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ne migkahi en maa si Pedro te, “Meambe ke sikew wey ke esawa nu ne neupakat te ebpenggeraman niyu ke Kedesenan ne Ebpetuntul te Menusiyà? Su ayan en maa ke menge meama ne midleveng dut te esawa nu, ne ed-ewiten ke red dema nikandan su idleveng ka!” ");
INSERT INTO mbi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Arà dà ne nepileyen sikandin ketà te sineruwan ni Pedro su minatey en. Guna su midlusud en ini se menge menguwed ne meama ne nekita ran ne minatey en sikandin, ne mibinting dan en diyà te liyu ne inleveng dan en maa diyà te uvey te leveng te esawa rin. ");
INSERT INTO mbi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ketà ne neandek nevenar ke langun ne menge mibperetiyaya ki Hisus abpeg dut te langun ne nekerineg dut te ini ne ned-ulaula. ");
INSERT INTO mbi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ne merakel se ulaula ne mekegeyip wey mekeinuinu ne ned-ulaula ne mibeelan dut te menge kedserihan ni Hisus diyà dut te menge etew. Ne langun dut te menge mibperetiyaya ki Hisus ne lelayun egkevurun diyà te ed-ingaranan te “Palàpalà ni Salomon”. ");
INSERT INTO mbi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ne ke menge etew ne warà pà mibperetiyaya ki Hisus, ne warà dan meketikà ne ed-amur ketà te kandan, misan dekelà se ked-adat kandan dut te langun ne menge etew. ");
INSERT INTO mbi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ugaid ne nasì ne mid-iseg ke kerakel te menge meama wey menge meritan ne mibperetiyaya ki Hisus ne nekeuman dut te langun ne mibperetiyaya. ");
INSERT INTO mbi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne geina te ruen neveelan ne mekegeyip dut te menge kedserihan, ne mid-ewit dan ke menge etew ne ederaru diyà te kilid te ralan ne ibpeirehà diyà te kama wey diyà te ikam su apey egketerapes dan dut te alung ni Pedro embiya ebpevayà sikandin. ");
INSERT INTO mbi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne denda ne menge etew se nekeuma ne riyà ebpuun te nekeer