﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbcNT_vpl;
CREATE TABLE mbcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbcNT_vpl WRITE;
INSERT INTO mbcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sîrîrî wanî penaronkon Jesus Cristo rawîronkon pî' teeseurîmasen pe. Jesus Cristo wanî Abraão nurî'tî pa'rî pe moropai Davi nurî'tî pa'rî pe ekareme'nen pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pena Abraão wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Moropai Judá wanî'pî monoi' pe esenpo'san yun pe, to' ese' wanî'pî Perez moropai Zerá. Inkamoro yankon wanî'pî itese' Tamar. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Moropai Arão wanî'pî Aminadabe yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Moropai Salmom wanî'pî Boaz yun pe. Mîîkîrî yan wanî'pî Raabe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Moropai Jessé wanî'pî Davi yun pe, pata esa' pe tîwe'sen. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Moropai Salomão wanî'pî Roboão yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Moropai Asa wanî'pî Josafá yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Moropai Uzia wanî'pî Jotão yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Moropai Ezequias wanî'pî Manassés yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Moropai Josias wanî'pî Jeconias yun pe moropai itonpayamî' yun pe. Mîrîrî yai Babilônia pata pona Israelponkon yaapîtî'pî Babilônia ponkonya tîpoitîrîkon pe to' e'to'pe itarumai'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilônia pona to' yarî'pî to'ya tanne Jeconias wanî'pî. Mîîkîrî Jeconias wanî'pî Salatiel yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Moropai Zorobabel wanî'pî Abiúde yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Moropai Azor wanî'pî Sadoque yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Moropai Eliúde wanî'pî Eleazar yun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Moropai Jacó wanî'pî José yun pe. Mîîkîrî José wanî'pî Jesus Cristo yan Maria niyo pe. Mîîkîrî Jesus wanî Paapa nîmenka'pî pe, Cristo pe tesa'sen pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sîrîrî warantî Abraão nurî'tî payanî'san wanî'pî. Inkamoro wanî'pî asakîrîrî pu' pona tîîmo'tai (14) kaisarî. Moropai Davi nurî'tî payanî'san wanî'pî Babilônia pata pona Israelyamî' yarî to'ya pîkîrî to' wanî'pî asakîrîrî pu' pona tîîmo'tai (14) kaisarî nîrî. Moropai mîrîrî tîpo Cristo esenpoto' weiyu pîkîrî asakîrîrî pu' pona tîîmo'tai (14) kaisarî nîrî to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Cristo esenpoto' wanî'pî sîrîrî warantî. Maria tîîse maasa tîniyotapa tînyo ton José yarakkîrî. Tîîse irawîrî more yan pe eenasa' wanî'pî Morî Yekaton Wannî winîpai. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mîîkîrî José yarakkîrî Maria e'to' warayo' wanî'pî Paapa maimu yawîrî tîîko'mansen pe. Mîrîrî ye'nen yarakkîrî tîwanî namai José esenumenka'pî teesepanto'kon yaretî'ka pî', tîîse anî'ya epu'tî pra yu'se awanî'pî. Maasa pra tewasirî Maria winîkîi imakui'pî pe anî' eseurîma namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mîrîrî pî' José esenumenka ko'mannîpî tanne Uyepotorîkon narima'pî inserî esenpo'pî José pia iwe'ne'. Moropai ta'pîiya ipî': —José, Davi nurî'tî paarî'pî, eranne' pe pra e'kî. Ano'pî pe Maria yapi'kî. Maasa pra mîîkîrî more yan pe Maria wanî manni', mîîkîrî man Morî Yekaton Wannî winîpainon pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Moropai mîîkîrîya more warayo' yenpo pe man. Moropai mîîkîrî ese'tîya pe nai Jesus pe itese'. Maasa pra mîîkîrîya tîpemonkonoyamî' pîika'tî pe man, to' nîkupî'pî imakui'pî winîpai —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tamî'nawîrî mîrîrî e'kupî'pî maasa pra awe'kupî kupî sîrîrî ta'pî Uyepotorîkonya tîmaimu ekareme'nen profeta nurî'tî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta'pîiya see warantî: Aurîno'pî, warayo' yarakkîrî si'pî pepîn ena pe man more yan pe. Moropai tînre ton yenpoiya warayo' pe. Mîîkîrî ese'tî to'ya pe man Emanuel kai'ma ta'pîiya. Uurî'nîkon yarakkîrî Paapa wanî taato' mîrîrî Emanuel. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Moropai José paka'pî tîwetun ye'ka pe. Moropai î' kai'ma ta'pî Uyepotorîkon narima'pî inserîya yawîrî ikupî'pîiya. Moropai Maria yarî'pîiya tewî' ta tîno'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tîîse yarakkîrî awanî pra José wanî'pî. Tînre yenpoiya tîpose aako'mamî'pî yarakkîrî tîwe'se pra. Moropai Joséya mîîkîrî inre ese'tî'pî Jesus kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus esenpo'pî Judéia pata po tîwe'sen cidade itese' Belém po. Mîrîrî yai Judéia pata ponkon ko'mannî'nen pe Herodes wanî'pî. Miarî ya warayo'kon epu'nenan pe tîwe'sanon wîtî'pî kaiwano' era'ma tîuya'nîkon wenairî wei epa'kapî'to' winîpai Jerusalém pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Moropai miarî teerepansa'kon pe ekaranmapo'pî to'ya: —O'non pata Judeuyamî' yepotorî pe esenpo'pî more nai? —ta'pî to'ya. —Anna yi'nî pî' man yapurîi maasa pra kaiwano', manni' Uyepotorîkon esenpo ekareme'nen era'ma pî' anna man wei epa'kapî'to' winîkîi —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mîrîrî taa to'ya eta tîuya ye'nen, pata esa' Herodes atasi'sirunpa'pî. Moropai tamî'nawîronkon pemonkonyamî' Jerusalém ponkon esi'nîpî'pî mîrîrî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Taatasi'sirunpai tîwanî ye'nen, mîîkîrîya teepîremasanon esanon muurukuntî'pî. Moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon eperepî'pî. Moropai inkamoro ekaranmapo'pîiya o'non pata mîîkîrî Cristo, Paapa nîmenka'pî esenpo e'painon kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mîîkîrî maimu yuuku'pî to'ya: —Judéia pata po tîwe'sen Belém po. Maasa pra mîrîrî warantî Paapa maimu ekareme'nen profeta nurî'tîya imenukasa' man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—See warantî awe'menukasa' man: “ ‘Judéia pata po tîwe'sen, Belém wanî si'mîrikkî pe. Mîîwîni tîîse ipîkku pe pu'kuru awanî tiaronkon cidade yentai. Maasa pra mîrîrî Belém cidade winîpai ipîkku pe tîwe'sen esenpo pe man pemonkonyamî' esa' ton. Mîîkîrî wanî pe man upemonkonoyamî' Judeuyamî' ye'mai'norî pe’ ta'pî Paapaya” ta'pî profeta nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mîrîrî eta tîuya tîpo, pata esa' Herodesya aminke pai iipî'san yanno'pî tîîpia, tamî'nawîronkonya epu'tî pra tîîse. Moropai to' ekaranmapo'pîiya: —Î' pensa pu'kuru see mîrîrî kaiwano' esenposa' era'ma'pîya'nîkon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Moropai to' yaipontî'pîiya to' wîtîto'pe Belém pona. Ta'pîiya to' pî': —Atîtî moropai mîîkîrî more mîwatîi morî pe epu'tîkonpa. Moropai mîîkîrî more esenposa' eposa'ya'nîkon ya, upî' ekareme'se maai'tîi, uurî nîrî uttîto'pe yapurîi —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mîrîrî taasa' pata esa'ya tîpo inkamoro epu'nenan wîtî'pî. E'ma taawîrî tuutîkon ye'ka pe, inkamoroya wei epa'ka winî tînera'ma'pîkon kaiwano' era'ma'pî. Mîrîrî kaiwano' wîtî'pî to' rawîrî, moropai eemî'pamî'pî wîttî, ita mîîkîrî more e'to' yepoi. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Inkamoro wanî'pî mararî pra taatausinpai mîrîrî kure'nan kaiwano' era'masa' tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Teerepansa'kon pe to' ewomî'pî wîttî ta moropai mîîkîrî more eporî'pî to'ya. Isan Maria pia awanî'pî. To' e'sekunka'pî irawîrî moropai mîîkîrî yapurî'pî to'ya. Mîrîrî tîpo iipia tîntîrîkon pe tînarî'pîkon yettapurîka'pî to'ya. Mîrîrîkon wanî'pî ouro pe moropai a'pusin pe moropai kara' pe. Mîrîrîkon tîrî'pî to'ya iipia. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Moropai Paapaya ta'pî inkamoro epu'nenan pî' to' we'ne'pî'to' ya', to' wetun tanne. Tîwenna'pokon pe pata esa' Herodes poro to' enna'po namai. Mîrîrî ye'nen inkamoro enna'po'pî tîpatakon ya' tiaron e'ma taawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Inkamoro epu'nenan, aminke pai iipî'san enna'po'pî tanne Uyepotorîkon narima'pî inserî esenpo'pî José pia, iwetun tanne iwe'ne'. Moropai ta'pîiya ipî': —Epekî more isan yarakkîrî epekî Egito pata pona. Miarî mako'mamîi, apî' î' tauya pîkîrî. Maasa pra Herodesya mîîkîrî more yuwa pe man iwîpa kai'ma —ta'pî inserîya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mîrîrî ye'nen José paka'pî moropai more isan yarakkîrî eepe'pî ewaron ya' Egito pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Moropai to' ko'mamî'pî miarî Herodes sa'manta tîpose. Mîrîrî e'kupî'pî pena awe'kupî kupî sîrîrî ta'pî Uyepotorîkonya yawîrî, tîmaimu ekareme'nen profeta nurî'tî pî'. Uurîya unmu yanno'pî Egito pata poi eepa'kato'pe ta'pî profeta nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Inkamoro epu'nenan aminke pai iipî'san warayo'konya tenku'tîsa' epu'tî tîuya ye'nen pata esa' Herodes ekore'ma'pî mararî pra. Mîrîrî ye'nen tamî'nawîronkon moreyamî' warayo'kon tî'ka me'po'pîiya asakî'ne kono' ma'rankon Belém po. Moropai iwoi tîîko'mansenon. Inkamoro moreyamî' asakî'ne kono' ma'rankon tî'ka me'po'pîiya maasa pra inkamoro warayo'kon aminke pai iipî'sanya, î' pensa kaiwano' era'ma'pî tîuya'nîkon ekareme'sa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mîrîrî warantî awe'kupî'pî pena Paapa maimu ekareme'nen profeta Jeremias nurî'tîya ta'pî yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Entaimepî'nîto' eseta pe man Ramá pata po. Mîrîrî wanî karawannîto'. Mîrîrî wanî Raquel nurî'tî payanî'san karau tînmukuyamî' sa'manta pî'. Mararî pra to' karau pe man anî'ya to' tî'napannîpî eserîke pra. Maasa pra tamî'nawîronkon to' munkîyamî' e'tî'ka'pî ye'nen ta'pî Jeremiasya. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pata esa' Herodes sa'mantasa' tîpo Uyepotorîkon narima'pî inserî esenpo'pî José pia iwe'ne' Egito pata po. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Moropai ta'pîiya: —Apakakî, enna'pokî. More isan yarakkîrî tarîpai enna'pokî Israel pata pona. Maasa pra manni'kan more wîî yu'se si'san sa'manta'pî man. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mîrîrî ye'nen José paka'pî. More moropai isan yarakkîrî to' enna'po'pî Israel pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tîîse itekare eta'pîiya Herodes munmurî'pî Arquelau wanî Judéia pata ko'mannî'nen pe tîyun pata'pî ya'. Mîrîrî ye'nen eranne' pe awanî'pî, miarî ya iko'manse itîîpai pra. Moropai tîwe'ne' inî'rî Paapa eseurîma eta'pîiya attî namai Judéia pata pona. Mîrîrî ye'nen José wîtî'pî Galiléia pata pona Judéia pata pona pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Moropai mîîkîrî ko'mamî'pî Galiléia pata pon cidade itese' Nazaré po. Mîrîrî warantî awe'kupî'pî maasa pra pena awe'kupî kupî sîrîrî ta'pî Paapa maimu ekareme'nenya. Mîîkîrî profeta nurî'tîya ta'pî yawîrî awe'kupî'pî. See warantî ta'pîiya: Mîîkîrî esatî to'ya pe man Nazaré pon kai'ma ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mîrîrî yai Jesus arentasa' tanne, João Batista nurî'tî erepamî'pî keren pona Judéia pata po. Miarî Paapa maimu ekareme'pîtî'pî João Batistaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ta'pîiya: —Paapa yeseru yapisî pî' esenumenkatî imakui'pî ayeserukon tîrumakai. Maasa pra aminke pra tamî'nawîronkon esa' pe Paapa ii'to' weiyu eseponî pî' man! Tîpemonkonoyamî' pîika'tîiya kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mîîkîrî João pî' pena Paapa maimu ekareme'nen Isaías nurî'tî eseurîma'pî. Moropai mîîkîrîya imenuka'pî see warantî: Pemonkon entaimepî'nî pî' man keren po. Taiya: “Uyepotorîkon erepamî ye'marî ton konekatî. E'ma yarakkanmokatî to'sarî eerepanto'pe”, taiya ta'pî Isaíasya. Mîrîrî warantî Joãoya ta'pî pemonkonyamî' ekonekato'pe Jesus Cristo erepamî rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mîîkîrî João pon wanî'pî camelo si'potî'pî pe. Moropai iworomî wanî'pî paaka pi'pî pe. Mîîkîrî João ya're' wanî'pî. Moropai ito' wanî'pî kaira pe. Moropai wan wanî'pî iwuku pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mîrîrî yai Jerusalém po tîîko'mansenon moropai tamî'nawîronkon Judéia pata po tîîko'mansenon, moropai iren Jordão rî'pîkîrî tîîko'mansenon wîtîpîtî'pî João pia imaimu etai. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inkamoroya imakui'pî pe tîwe'to'kon ekaremekî'pî miarî. Moropai inkamoro yenpatakona'pî Joãoya iren Jordão ka. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mîrîrî yai Joãoya mararî pra fariseuyamî' moropai saduceuyamî' iipî era'ma'pî tîîpia esenpatakonai. Inkamoro pî' ta'pî Joãoya: —Amîrî'nîkon wanî nari' îkîiyamî' ye'katonkon warantî. Maasa pra imakui'pî pe awe'to'kon ayeserukon tîrumakai pra Paapa ekore'mato' yapai e'pîika'tîpai awanîkon. Tîîse mîrîrî warantî awe'pîika'tîkon eserîke pra naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mîrîrî ye'nen ayeserukon imakui'pî pe awe'to'kon rumakatî. Morî ayeserukon ton yapi'tî tamî'nawîronkonya ayeseru rî'pîkon rumakasa'ya'nîkon epu'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Moropai kîkatî Paapaya utaruma'tîkon pepîn ipemonkono pe anna wanî ye'nen, maasa pra Abraão payanyamî' pe anna wanî kîkatî. Î' pe pra rî mîrîrî taaya'nîkon manni' wanî. Maasa pra Abraão payanî'san pe Paapaya seeni' tî', miakanma e'painon ayentakon. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A'kî, wa'ka moro man, yei ya'tîto' ton ikara kî'pî yapî'. Manni' yei morî pe teperu tîînen pepîn ya'tîto' ton tamî'nawîrî. Moropai mîrîrî yenumî to'ya apo' ya' aaranto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tîîse uurîya amîrî'nîkon yenpatakona sîrîrî tuna ke neken, ayeserukon imakui'pî ku'to'ya'nîkon rumakasa'ya'nîkon ekareme'nen pe. Tîîse uye'ma'pî pî' tiaron iipî. Mîîkîrî wanî uurî yentai meruntî ke. Ipîkku pe awanî ye'nen mîîkîrî pisa'sa' yewa yeukauya eserîke pra awanî, uyentai awanî ye'nen. Mîîkîrîya amîrî'nîkon yenpatakona pe man ayesa'kon pe Morî Yekaton Wannî e'to'pe moropai apo' ke amîrî'nîkon yenpatakona pe man. ˻Mîrîrî warantî ikupîiya tamî'nawîrî imakui'pî mo'kapa kai'ma.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Maasa pra mîîkîrî yenya' trigo sururukato' wanî. Mîrîrî ke isururukaiya. Ipi'pî kore'tapai imenkaiya. Mîrîrî sururukasa' tîuya yara'tîiya itense' ya'. Mîrîrî pi'pîrî'pî yannukuiya moropai ipo'tîiya apo' ya' eesi'nîpî neporîton pepîn ya' —ta'pî Joãoya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mîrîrî yai Jesus wîtî'pî Galiléia poi iren Jordão ka, João Batistaya tenpatakonato'pe kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tîîse Joãoya teseru miakanma'pî ka'ne' pe. Ta'pîiya: —Uurî neken yenpatakonaya e'pai tîîse uyenpatakonakî taaya mîrîrî upî' —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tîîse Jesusya imaimu yuuku'pî: —Tîwîrî mîrîrî warantî ikupî e'pai awanî. Maasa pra mîrîrî warantî ikupîya yairî itu'se Paapa e'to' yawîrî awanî. Moropai —Î' wani' pra man —ta'pî João Batistaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mîrîrî pe rî tenpatakonasai'ya tîpo, tuna kapai Jesus eseu'ka pe, ka' esettapuruka'pî. Moropai Jesusya Paapa winîpainon Morî Yekaton Wannî autî era'ma'pî tîpona waku'ka warantî. Moropai tîpona eereuta era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Moropai ka' poi Paapa eseurîmato' eta'pîiya. Ta'pî Paapaya: —Mîserî unmu, uwakîri pu'kuru. Kure'ne ipî' uurî atausinpa —ta'pî Paapaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mîrîrî tîpo Jesus yarî'pî Morî Yekaton Wannîya keren pona Makuiya yonpato'pe kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mîîkîrî ko'mamî'pî miarî keren po. Asakî'ne pemonkon wei (40) moropai asakî'ne pemonkon ewaron kaisarî Jesus epîremapîtî'pî Paapa pî' tekkari tonpai pra. Mîrîrî tîpo Jesus wanî'pî emi'ne. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mîrîrî tanne Makui, pemonkonyamî' yeka'nunkanen, iipî'pî iipia. Moropai ta'pîiya ipî': —Innape see Paapa Munmu pe awanî. Mîrîrî ye'nen seeni' tî' miakanmakî ayu pe —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusya mîîkîrî maimu yuuku'pî: —Paapa maimu e'menukasa' man see warantî: “Tiyu pî' neken pemonkon ko'mamî pepîn. Tîîse tamî'nawîrî î' taasa' Paapaya manni' yawîrî aako'mamî”, taasai'ya man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mîrîrî tîpo Makuiya Jesus yarî'pî Jerusalém cidaderî pona. Moropai yanu'nîpî'pîiya kawînan panpî' epîremanto' yewî' neka'ta pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Moropai ta'pîiya Jesus pî': —Innape Paapa munmu pe awanî ye'nen, arapunkî tarîpai. Maasa pra Paapa maimuya taasa' man: “Paapaya inserîyamî' yarima amîrî pîika'tîi to' ii'to'pe. Inkamoroya ayapisî tenyakon ke tî' pona a'pu pa'tîya namai”, taasai'ya man —ta'pî Makuiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusya imaimu yuuku'pî: —A'kî, Paapa maimu e'menukasa' man see warantî: “Ayepotorî Paapa tonpai pra e'kî”, taasa' Paapa maimuya man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Moropai inî'rî Makuiya Jesus yarî'pî kawînan wî' pona. Miarî si'ma tamî'nawîron patakon yenpo'pîiya, morî pe pata wanî moropai ipîkku pe awanî yenpo'pîiya Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Moropai ta'pîiya Jesus pî': —Tamî'nawîrî sîrîrî tîrîuya e'painon aapia amîrî pe ipîkku pe awanîpa, sîrîrî uyapurîi awe'sekunka ya —ta'pî Makuiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesusya mîîkîrî maimu yuuku'pî. Ta'pîiya Makui pî': —Uyeyaton, atarimakî uupiapai. Maasa pra Paapa maimu e'menukasa' man see warantî: “Ayepotorî neken Paapa yapurîkî. Mîîkîrî maimu yawîrî neken ako'mankî”, taasai'ya man —ta'pî Jesusya Makui pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mîrîrî tîpo Makuiya Jesus rumaka'pî. Moropai inserîyamî' iipî'pî Jesus pia. Inkamoroya ipîika'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","João Batista yarakkansa' to'ya yekare etasa' tîuya pe, Jesus wîtî'pî Galiléia pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaré po aako'mamî pra awanî'pî. Tîîse Cafarnaum cidaderî pona iko'manse attî'pî. Mîrîrî wanî'pî Galiléia ku'pî ena po tîwe'sen pe. Zebulom pata po tîwe'sen pe, moropai Naftali pata pon pe nîrî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mîrîrî poro attî'pî maasa pra pena attî pe man ta'pî Paapa maimu ekareme'nen profeta Isaías nurî'tîya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Miarî Zebulom pata pona moropai Naftali pata pona moropai iku'pî rî'pîkîrî pata pona moropai iren Jordão ratai pata, manni' pata Judeuyamî' pepîn pata'se' pona a'ka erepamî kupî sîrîrî. Mîrîrî patakon wanî Galiléia pe itese'. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Miarî pemonkonyamî' ko'mamî ewaron ta. Tîîse inkamoroya kure'nan a'ka era'ma kupî sîrîrî. Eranne' pe inkamoro ko'mamî tîîsa'mantato'kon pî', tîîse kure'nan a'ka erepamî kupî sîrîrî to' pia ta'pî Paapa maimu ekareme'nen Isaías nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mîrîrî pata pai Jesusya Paapa maimu ekaremekî pia'tî'pî. Taapîtî'pîiya see warantî to' pî': —Paapa yeseru yapisî pî' esenumenkatî, imakui'pî ankupî'pîkon tîrumakai sîrîrî pata pai. Maasa pra aminke pra tamî'nawîronkon esa' pe Paapa ii'to' eseponî pî' man. Tîpemonkonoyamî' pîika'tîiya kupî sîrîrî —ta'pî Jesusya pemonkonyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mîrîrî yai Galiléia ku'pî rî'pîkîrî tuutî ye'ka pe, asakî'nankon takon yarakkîronkon moro'yamî' yapi'nenan era'ma'pî Jesusya. Tarrafa ke inkamoro wanî'pî Simão, tiaron itese' Pedro. Moropai itakon André wanî'pî. Moro'yamî' yapisî pî' to' wanî'pî mîrîrî iku'pî ka. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesusya ta'pî to' pî': —Aase'nîkon upîkîrî ayenupato'peuya'nîkon. Î' kai'ma upemonkono pe pemonkonyamî' kupîkonpa. Moro'yamî' yapisîya'nîkon manni' warantî to' maakonpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Inkamoroya ka'ne' pe teesemi'tapai moro'yamî' yapi'to' tîuya'nîkon rumaka'pî moropai to' wîtî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Inî'rî miarî ya panpî' tuutîi, tiaronkon takon yarakkîronkon nîrî era'ma'pî Jesusya. Inkamoro wanî'pî Zebedeu munkîyamî' pe. Tiago moropai itakon João, inkamoro wanî'pî tîyunkon pokonpe kanau ya'. Tîtarrafarikon rumentannî'pîtî pî' to' tîîse Jesusya to' yanno'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Moropai inkamoroya tîyunkon nîmî'pî moropai tîkanaukon nîmî'pî to'ya. Moropai to' wîtî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mîrîrî yai Jesus asarî'pî tamî'nawîrî Galiléia pata poro to' epere'to'kon yewî' tapî'. To' yenupa pinunpa'pîiya morî itekare pî'. Tamî'nawîronkon esa' pe Paapa iipî kupî ekareme'pîtî'pîiya. Moropai pri'yawonkon pepîn yepi'tî pinunpa'pîiya tamî'nawîron to' yeparankon yapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mîrîrî warantî ikupî Jesusya yekare eseta'pî tamî'nawîrî Síria pata poro. Mîrîrî ye'nen pemonkonyamî'ya tonpakon pri'ya pra tîwe'sanon enepî'pî to'ya. Tîmoronkon epu'nenan tamî'nawîron pî' o'ma'kon yarakkîrî tîwe'sanon moropai asakoi'kon pepîn eke'nepamî'san enepî'pî to'ya to' yepi'tîto'pe Jesusya kai'ma. Moropai inkamoro yepi'tî'pîiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Arinîkon pemonkonyamî' wîtîpîtî'pî Jesus pîkîrî Galiléia pata ponkon Decápolis pata ponkon Jerusalém pata ponkon Judéia pata ponkon moropai iren Jordão ratai ponkon wîtîpîtî'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Arinîkon pemonkonyamî' era'ma tîuya pe Jesus enuku'pî wî' pona. Moropai eereuta'pî. Eereutasa' tanne inenupa'san ipemonkonoyamî' iipî'pî iipia aminke pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Moropai inkamoro yenupa pia'tî'pîiya. Ta'pîiya to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Morî pe pu'kuru mannankan î' ton pra tîwe'sanon wanî. Mannankan Paapa pia tîntîrîkon ton pra awanî epu'nenan. Morî pe to' wanî maasa pra inkamoro esa' pe Paapa wanî moropai ipemonkono pe to' ko'mamî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Morî pe pu'kuru mannankan tîkaruwasenon wanî. Imakui'pî pî' to' karau tanne, Paapaya to' pîika'tî taatausinpai to' e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Morî pe pu'kuru mannankan moo tîwe'sanon, tiwinarî teekore'masanon pepîn wanî. Morî pe to' wanî maasa pra sîrîrî pata tîrî Paapaya to' pata'se' ton. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Morî pe pu'kuru mannankan wanî kure'ne Paapa yeseru anku'pai tîwe'sanon. Inkamoro wanî mannankan emi'ne tîwe'sanon moropai tuna aninnîpai tîwe'sanon warantî. Maasa pra kure'ne yairî e'pai to' wanî ye'nen. Morî pe to' wanî maasa pra inkamoro pia Paapaya teseru ku'to'pe to'ya itîrî to' pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Morî pe pu'kuru mannankan pemonkonyamî' sa'namanenan wanî, maasa pra to' sa'nama Paapaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Morî pe pu'kuru mannankan imakui'pî ton pra tîwe'sanon wanî, maasa pra inkamoroya Paapa era'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Morî pe pu'kuru mannankan pemonkonyamî' ekore'ma'san mana'pokanenan wanî. Maasa pra inkamoro mana'pokanenan esatî to'ya Paapa munkî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Morî pe pu'kuru mannankan tîwe'taruma'tîsanon wanî. Yairî Paapa yeseru kupî to'ya wenai to' taruma'tî to'ya. Inkamoro awanî taatausinpai maasa pra Paapa, tesa'kon pia to' ko'mamî ipemonkono pe, —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Morî pe pu'kuru amîrî'nîkon wanî teuren amu'tunpakon to'ya tanne. Moropai awinîkîi'nîkon to' eseurîma seru'ye' pe. Moropai tu'ke imakui'pî kupî to'ya awinîkîi'nîkon upemonkono pe awanîkon wenai. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mîrîrî ye'nen taatausinpai pu'kuru e'tî mararî pra. Maasa pra aapia'nîkon tîntîrî ton konekasa' Paapaya man ka' po. Mîrîrî warantî nîrî pena amîrî'nîkon rawîronkon Paapa maimu ekareme'nenan profetayamî' nurî'san taruma'tî'pî to'ya, ataruma'tîuya'nîkon manni' warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesusya to' yenupa ko'mannîpî'pî. Ta'pîiya: —Amîrî'nîkon yeseru wanî pan warantî morî pe pemonkonyamî' pîika'tîton pe. Tîîse inî'mîra pan enasa' ya, morî pe awanî pepîn. Ipo'mîra awanî. Pan pe awanî pepîn. Moropai mîrîrî wanî î' pe pra rî. Moropai mîrîrî papo to'ya poro pona pemonkonyamî'ya mîrîrî yaki'tapapîtî tuutîkon kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Moropai tiaron ekaremekî'pîiya. Ta'pîiya: —Amîrî'nîkon yeseru wanî pata weiyu warantî tamî'nawîronkon nera'maton pe. A'kî, cidade konekasa' wî' po tîwe'sen era'ma tamî'nawîronkonya e'painon. Teesera'masen pepîn eena eserîke pra awanî, kawîne tîwanî ye'nen aronne eesera'ma ko'mannîpî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Moropai anî'ya tî'kuma'tu yawittanîpî pepîn e'painon waikîra'pî yo'koi itîrîpa. Tîîse yawittanîpîiya itaponse' pe tînkoneka'pî pona itîrîpa. Tamî'nawîronkon wîttî ta tîwe'sanonya era'mato'pe to' weiyu'mato'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mîrîrî warantî nîrî amîrî'nîkon yeseru e'pai awanî aweiyukon warantî. Tiaronkonya ayeserukon era'mato'pe morî pe pu'kuru. Moropai mîrîrî ayeserukon wenai inkamoroya nîrî Paapa ka' pon yapurîto'pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Inî'rî Jesus eseurîma'pî. Ta'pîiya: —Moisés nurî'tîya ayenupato'kon moropai penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'tîya ayenupato'kon yaretî'kai uui'sa' kai'ma kîsenumenkatî. Mîrîrî yaretî'kai uui'sa' pra wai. Tîîse uuipî'pî î' taato'pe awanî ekareme'se apî'nîkon. Moropai mîrîrî unkupî ekareme'sai'ya yawîrî iku'to'peuya uuipî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maasa yairon pî' tauya etatî. Ka' moropai pata ataretî'ka pîkîrî, Moisésya yenupanto' ataretî'ka pepîn. Tîîse tamî'nawîrî aako'mamî itonpa emo'ka pepîn. Tîîse tamî'nawîrî taasai'ya yawîrî awe'kupî e'to' yawîrî tamî'nawîron ataretî'ka pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tîîse anî'ya Moisésya yenupanto' yawîrî ikupî tanne tîîse tiwin mîrikkî ipureme'sai'ya ya, moropai mîrîrî ke tiaron yenupaiya ya, ikupî tîuya manni' warantî. Paapa pia mîîkîrî wanî tiaronkon ipemonkonoyamî' ma're awanî. Tîîse anî'ya Moisésya yenupanto' yawîrî pu'kuru ikupî ya moropai mîrîrî ke tiaronkon yenupaiya ya innape kupî tîuya manni' warantî, mîîkîrî wanî ipîkku pe pu'kuru Paapa pia, tiaronkon ipemonkonoyamî' yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Maasa pra tauya sîrîrî apî'nîkon. Morî ayeserukon awanî ya, manni'kan Moisés nurî'tîya yenupanto' pî' yenupatonkon yeseru kaisarî moropai fariseuyamî' yeseru kaisarî, ipemonkono pe aako'mamîkon pepîn Paapa pia. Tîîse morî panpî' to' yeseru yentai ayeserukon e'pai awanî aako'mamîkonpa Paapa pia ipemonkono pe —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesusya ta'pî: —Pena atamokon rî'san pî' î' ta'pî epu'tî pî' naatî? Ta'pî see warantî: “Pemonkon kî'wîtî. Anî'ya pemonkon wîîsa' ya mîîkîrî yarî e'pai awanî ipîkku tîwe'sen juiz pia”. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tîîse uurîya taa sîrîrî apî'nîkon. Anî' ekore'masa' ya tonpa yarakkîrî mîîkîrî yarî to'ya e'pai awanî ipîkku pe tîwe'sen juiz pia. Moropai anî'ya taa ya tonpa winîkîi “Î' epu'nen pepîn amîrî”, taiya ya ipî', mîîkîrî yarî to'ya ipîkku pe tîwe'sanon to' yepurukon pia itaruma'tîto'pe to'ya. Moropai anî'ya tonpa esatî ya, “Imakui'pî amîrî, pakko”, taiya ya, nari' pe awanî. Tîwarî e'pai awanî mîîkîrî yenumî Paapaya namai apo' ya' aaranto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mîrîrî ye'nen Paapa yapurî pe antîrî tîrîya yai tîîse awenpenata ayonpa awinîkîi ekore'ma'pî moro awanî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mîrîrî tanne, moro antîrî nîmîkî moropai atîkî e'mai' pe ayonpa pia. Yarakkîrî ayeseru konekata. Moropai tamî'nawîrî morî pe teekonekai enna'pokî Paapa yapurî pe antîrî tîrîpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mîrîrî warantî ayeyatonya ayarî ya juiz pia, ka'ne' pe ayeserukon konekatî ayeyaton yarakkîrî apî' eeseurîma rawîrî. Mîrîrî kupîya pra awanî ya, ayarîiya ipîkku pe tîwe'sen pia. Moropai mîîkîrî juizya amîrî rumaka surara yenya'. Moropai mîîkîrîya ayarakkamo atarakkannîto' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tauya sîrîrî apî' mîrîrî atarakkannîto' tapai eepa'ka pepîn ka'ne' pe. Tamî'nawîrî mîrîrî ankupî'pî ye'maya pîkîrî aako'mamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Î' taasa' to'ya epu'tî pî' naatîi. “Tîno'pî ke si'ma wîri'sanyamî' yarakkîrî tîwe'se pra e'tî. Moropai tînyo ke si'ma tiaron warayo' yarakkîrî tîwe'se pra e'tî”. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tîîse uurîya taa sîrîrî apî'nîkon anî'ya wîri' era'ma ya, moropai yarakkîrî e'pai tîwanî pî' eesenumenka ya, yarakkîrî mîîkîrî e'sa' mîrîrî tewan ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mîrîrî ye'nen wîri' era'maya ya ayenu meruntî winon ke imakui'pî kupîya emapu'tîiya. Mîrîrî namai imo'kakî, yenunkî imakui'pî kupîya namai. Maasa pra asakî'ne ayenu tîîse, imakui'pî ku'sa'ya ya, attî apo' ya' ankupî'pî wenai. Mîrîrî ye'nen morî pe panpî' awanî itenu pra aako'mamî ya imakui'pî tîku'se pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Moropai ayenya meruntî winonya imakui'pî kupîya emapu'tî ya, mîrîrî merenkî'kî moropai yenunkî imakui'pî kupîya namai. Maasa pra ayenya merenkî'sa'ya ya, aako'mamî enen ipatîkarî. Mîrîrî wanî morî pe panpî', asakî'ne ayenya tîîse apo' ya' attî yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Taasa' to'ya man nîrî see warantî: “Anî'ya tîno'pî rumaka ya, irumaka tîuya kaaretarî tîrîiya e'pai awanî iipia”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tîîse uurîya taa sîrîrî apî'nîkon, anî'ya tîno'pî rumaka ya tiaron warayo' yarakkîrî awe'sa' pra tîîse, mîîkîrîya imakui'pî kupî tîno'pîya emapu'tî mîrîrî. Maasa pra tiaron warayo' yarakkîrî awanî emapu'tîiya aaniyotasa' ya. Moropai manni' warayo' yarakkîrî awanî manni'ya nîrî imakui'pî kupî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Epu'nenan nîrî amîrî'nîkon pena atamokon nurî'tî pî' î' kai'ma ta'pî. “Î' taasa'ya'nîkon ya Paapa pî', ta'pîya'nîkon yawîrî iku'tî, seru'ye' pe tîwe'se pra”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tîîse uurîya taa sîrîrî apî'nîkon. Amîrî'nîkon esenumenka see warantî. Paapa winîkîi pra tauya ya, î' wani' awanî pepîn î' ta'pîuya yawîrî pra ikupîuya, taaya'nîkon. Tîîse ka' winîkîi teeseurîmai pra e'tî. Maasa pra Paapa yaponse' pe awanî mîrîrî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Moropai pata winîkîi tîkai pra e'tî. Maasa pra Paapa puu yaponse' pe awanî mîrîrî mîîto'pe. Moropai Jerusalém cidaderî winîkîi tîkai pra e'tî. Maasa pra Paapa pata'se' pe awanî mîrîrî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Moropai apu'pai winîkîi tîkai pra e'tî. Maasa pra apu'pai si'po miakanmaya pepîn e'painon aimutun pe awe'to'pe. Moropai aimutun miakanmaya pepîn îrikkutun pe awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mîrîrî ye'nen î' winîkîi takai pra e'tî, innape amaimukon wanî ekaremekîkonpa. Tîîse amaimukon e'pai awanî see warantî: Inna, kaane, kai'ma. Maasa pra tu'kan î' taato'ya'nîkon amaimukon wanî makui winîpai tui'sen pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesusya ta'pî: —Î' ta'pî to'ya epu'nenan amîrî'nîkon: “Anî'ya ayenu pona apa'tî ya, mîîkîrî ayenu yai apa'tîtîponya tîmoron epu'tî e'pai awanî akaisarî. Moropai mîrîrî warantî aye pona apa'tîtîponya tîmoron epu'tî e'pai awanî akaisarî aye'mapa”, taa Moisés nurî'tîya yenupanto'. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tîîse uurîya taa sîrîrî apî'nîkon, amîrî winîkîi imakui'pî ku'nen pî' teese'mai pra e'kî. Anî'ya ayenpata pona apa'tî ya, iratai winî era'tîkî apa'tîto'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Moropai anî'ya ayarî ya ipîkku tîwe'sen juiz pia apon ke ye'mapa, tîwî apon mo'kaiya. Tîwî aya'san nîrî yarîiya î' rî kî'kupîi mîîkîrî yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Moropai anî'ya taa ya apî': “Uyemanne yaakî aminke pu'kuru pra tiwin quilómetro kaisarî”, taiya ya, itîîpai pra awanî tanne, tîîse yaakî asakî'ne quilómetros kaisarî yarîya e'pai awanî, tu'se awanî'pî yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moropai anî' erepamî ya aapia î' rî esa'se. Mîîkîrî pia inesatî'pî tîîkî. Moropai anî' erepamî ya aapia tîniru esa'se, a'noko'pî pe era'makî tîwî tîku'se pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Î' ta'pî to'ya epu'nenan amîrî'nîkon: “Ayonpa awakîrikon pu'kuru sa'nama e'pai awanî. Moropai ayeyaton ku'tî ayewanma pe”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tîîse uurîya taa sîrîrî apî'nîkon, anî' ayeyatonkon pe tîwe'sen wanî ya, mîîkîrî sa'namatî kure'ne. Moropai epîrematî mîîkîrî ataruma'tînenkon pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mîrîrî warantî ikupîya'nîkon ya, ayunkon ka' pon munkîyamî' pe awanîkonpa. Maasa pra mîîkîrîya tamî'nawîronkon ton pe wei tîrî, morîkon ton pe moropai imakui'san ton pe. Mîîkîrîya kono' tîrî, morî ku'nenan ton pe moropai imakui'pî ku'nenan ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tîîse amîrî'nîkonya awakîrikon neken ayonpakon sa'nama ya tiaronkon tîsa'namai pra. Tîîse î' ton pe mîrîrî warantî si'ma “Paapa winîpainon yapisîuya”, kai'ma eesenumenkakon? A'kî, mîrîrî warantî nîrî imakui'sanya, tîniru yapisî pî' teesenyaka'masanonya ikupî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Moropai eeseurîmakon ya awakîrikon neken ayonpakon yarakkîrî, tiaronkon yarakkîrî teeseurîmai pra, î' pe pra rî awanî. Mîrîrî warantî Paapa epu'nenan pepînya nîrî ikupî. ");
INSERT INTO mbcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mîrîrî ye'nen yairî pu'kuru e'tî e'to' yawîrî. Yairî pu'kuru ayunkon Paapa, ka' pon awanî manni' warantî awanîkonpa —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesusya taa ko'mannîpî: —Aka! tîwarî panpî' e'tî Paapa yapurî yeseru pî'. Tiaronkonya ayera'mato'kon pe pra neken. Mîrîrî warantî ikupîya'nîkon ya, Paapa, ayunkon ka' pon nîtîrî, iwinîpainon yapisîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mîrîrî ye'nen anî' tîwe'taruma'tîsen pia î' rî tîîsa'ya'nîkon ya, “Mîrîrî kin tîrî pî' wai koo iipia rî”, kîkatî, manni'kan seru'ye' pe teesenku'tîsanonya ikupî warantî pra. Maasa pra inkamoroya iku'pîtî Judeuyamî' epere'to'kon yewî'kon kaisarî. Moropai pemonkonyamî' wîtîto'kon, e'makon kaisarî pemonkonyamî'ya tapurîto'kon pe kai'ma. Ayenku'tîuya'nîkon pepîn, maasa Paapa winîpainon yapisî to'ya pepîn. Maasa pra aasîrî pemonkonyamî' piapai yapisî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tîîse amîrîya î' rî tîrî ya, tîwe'taruma'tîsen pia itîîkî ama' pe, anî' ayonpa pî' teekareme'se pra, î' ku'sa'ya epu'tîiya namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mîrîrî antîrî'pî epu'tî anî'ya e'pai pra man. Tîîse ayun, tamî'nawîron era'manenya î' ku'sa'ya era'ma. Mîrîrî wenai aapia tîntîrî tîrîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Eepîremakon ya, manni'kan seru'ye' pe tîwe'sanonya ikupî warantî kî'ku'tîi. Maasa pra inkamoro epîremapîtî Judeuyamî' epere'to'kon yewî'kon tapî' satippe si'ma. Moropai to' epîremapîtî e'makon, pemonkonyamî' wîtîto', e'makon era'tîto'kon ta pî' si'ma. Tamî'nawîronkon pemonkonyamî'ya tera'mato'kon pe kai'ma, mîrîrî kupî to'ya. Ayenku'tîuya'nîkon pepîn. Inkamoroya tamî'nawîrî tînapisîkon yapisî'pî pemonkonyamî' winîpai, Paapa winîpai î' yapisî to'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tîîse mîrîrî warantî pra amîrî'nîkonya ikupî e'pai man. Eepîremakon ya, ayewî'kon ta ewontî. Moropai ayewî'kon mana'ta yarakkantî, anî'ya ayera'makon namai. Moropai epîrematî, manni' anî' nera'ma pepîn, Paapa pî'. Moropai mîîkîrî tamî'nawîrî î' konekaya'nîkon era'manenya tîntîrî tîrî aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Eepîremato'kon yai, eepîremakon ya, se' tapairî mai tinna'popî'se pra e'tî, manni'kan Paapa epu'nenan pepînya ikupî manni' warantî. Maasa pra inkamoro epîrema kusan pe tiwinan mana'popîtî pî' to' ko'mamî. Mîrîrî warantî neken Paapaya teepîremanto'kon eta kai'ma to' esenumenka. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mîrîrî ye'nen tauya sîrîrî, inkamoro warantî pra e'tî. Maasa pra Paapa ayunkonya tamî'nawîron î' itu'se awe'to'kon epu'tî pî' man, maasa esatîya'nîkon rawîrî epu'tî pî' man. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mîrîrî ye'nen tauya sîrîrî, epîrematî see warantî: “Paapa anna yunkon, amîrî ka' po tîîko'mansen. Tamî'nawîronkonya morî pe pu'kuru amîrî wanî epu'tî yu'se wai. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Amîrî wanî tamî'nawîronkon esa' pe. Asi'kî anna pia, anna esa' pe awanîpa. Itu'se awe'to' yawîrî ikupî annaya yu'se wai, tarîni' sîrîrî non pona, morî pe pu'kuru ka' po awanî manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sîrîrîpe itu'se anna e'to' tîîkî, anna yekkari ton. Itîîkî anna pia î' ton pra anna wanî namai, Paapa. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Moropai Paapa, anna nîkupî'pî imakui'pî awinîkîi iku'kî aawanmîra, anna wanmîra tamî'nawîronkon nîkupî'pî imakui'pî anna winîkîi kupî annaya warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Moropai anna pîika'tîkî, imakui'pî ena namai anna yentai. Moropai Makui mo'kakî anna piapai, Paapa. Maasa pra amîrî wanî anna esa' pe. Meruntî ke amîrî wanî tamî'nawîronkon yentai ipatîkarî. Morî pe aako'mamî ikî'pî ton pra. Mîrîrî warantî awanî pe man”. Sîrîrî warantî epîrematî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—A'kî, tauya sîrîrî apî'nîkon. Anî'kan nîkupî'pî imakui'pî awinîkîi'nîkon kupîya'nîkon ya aawanmîra'nîkon, Paapa ka' ponya nîrî tîîwanmîra ikupî, imakui'pî ankupî'pîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tîîse aawanmîra'nîkon imakui'pî to' nîkupî'pî kupîya'nîkon pra awanî ya, mîrîrî warantî nîrî Ayunkonya ankupî'pîkon imakui'pî kupî pepîn tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Moropai ayekkarikon tonpai pra eepîremakon ya, yairî ma're ayenpatakon tîku'se pra e'tî, manni'kan teesenku'tîsanonya ikupî manni' warantî. A'kî inkamoroya mîrîrî warantî ikupî maasa pra tamî'nawîronkonya tekkarikon tonpai pra teepîremakon era'mato'pe kai'ma. Ayenku'tîuya'nîkon pepîn, aasîrî tamî'nawîronkon pemonkonyamî' tera'matîpono'san winîpai yapisî'pî to'ya. Inî' panpî' yapisî to'ya pepîn Paapa piapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tîîse amîrî'nîkon epîrema ya, ayekkarikon tonpai pra, ayenpatakon ronatî. Moropai apu'paikon yakinatî, ");
INSERT INTO mbcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tiaronkonya ayekkarikon tonpai pra eepîremakon epu'tî namai. Tîîse Ayunkon neken, Paapa anî' nera'ma pepînya ayepu'tîkon ayekkarikon tonpai pra eepîremakon. Moropai mîîkîrîya, ama' pe î' kupîya'nîkon era'manenya tîntîrî tîrî aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Moropai ta'pîiya: —Tarî non po ipîkku pe awanîkon pî' teesenumenkai pra e'tî. Maasa pra tarî mîrîrî ayemannekon, aponkon yaku o'ma'konya. Moropai tarî ama'ye'konya ayama'runpakon. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mîrîrî warantî awanî namai, ayemannekon ton konekaya'nîkon yuwatî ka' po. Miarî o'ma'ya aponkon yaku pepîn. Miarî ayemannekon karau pepîn, aataretî'ka pepîn. Moropai miarî ama'ye'konya ayama'runpakon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Miarî ikonekatî, maasa pra o'non pata po ayemannekon konekasa'ya'nîkon ya, manni' pata eesenumenkato'kon wanî aako'mamîkon pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesusya ta'pî: —A'kî, î' kai'ma esenumenkan wenai yairî, yairî pra uyeserukon wanî epu'tî, u'kuma'tuya itu'na uweiyu'makon warantî. Yairî esenumenkan ya, anne' pe pra si'ma esenku'tîn pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tîîse yairî pra esenumenkan ya, anne' pe e'nî ye'nen, esenku'tîn mîrîrî. Mîrîrî ye'nen uuwarîrî'nîkon esenku'tînsa' ya, kure'ne pu'kuru esenku'tînsa' mîrîrî, ewaron ta e'nî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Moropai inî'rî ta'pî Jesusya: —Anî' wanî eserîke pra man, asakî'ne tîkaraiwarî ke. Maasa pra tiaron yapurîiya morî pe tiaron yentai. Moropai tiaron mu'tunpaiya tiaron maimu yawîrî awanî. Tîîse tiaron pîinamaiya pepîn. Mîrîrî warantî Paapa poitîrî pe e'nî eserîke pra man, inî' panpî' tîniru yu'se eseka'nunkan ya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Mîrîrî ye'nen tauya sîrîrî apî'nîkon, ayekkarikon ton pra awanî pî' teesenumenkai pra e'tî, moropai awukukon ton pra awanî pî'. Moropai aponkon ton pra awanî pî' kîsenumenkatî. Maasa pra tauya sîrîrî apî'nîkon, ipîkku pe panpî' Paapa nîtîrî'pî uuko'mannîto'kon wanî uyekkarikon yentai. Moropai intîrî'pî uyesa'kon wanî ipîkku pe panpî' uponkon yentai. ˻Manni' ipîkku pe tîwe'sen tîîsai'ya ya, ima're tîrîiya nîrî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Maasa esenumenkatî toronyamî' pî'. To' esenyaka'ma pepîn tekkarikon ton pîmî pî'. Moropai tekkarikon mo'ka pî' to' esenyaka'ma pepîn. Moropai tekkarikon yewî' ton koneka to'ya pepîn. Tîîse Ayunkonya inkamoro ko'mannîpî mîrîrî. To' ya're' ton tîrîiya. Amîrî'nîkon kanan? Î' kai'ma eesenumenkakon? Inkamoro toronyamî' ko'mannîpî tîuya yentai aako'mannîpîkon Paapaya, maasa pra toronyamî' yentai awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mîrîrî warantî teesenumenka wenai anî'ya inî' panpî' tîîko'manto' ton kupî pepîn tarî non po. Mîrîrî ye'nen kîsenumenkatî mîrîrî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tîîse î' ton pe aponkon ton pra awanî pî' eesenumenkakon mîrîrî? Maasa esenumenkatî parî' yari'ku, kono' waiyi keren pon pî'. To' esenyaka'ma pepîn mîrîrî eporîpa moropai tîponkon ton si'pîmî to'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tîîse tauya sîrîrî apî'nîkon, to' yari'kukon wanî morî pe pu'kuru. To' warantî anî' epontî pepîn. Teuren Salomão nurî'tî ipîkku pe tîwe'sen epontî morî tîpon ya'. Teuren tîîse to' warantî awanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Paapaya parî' keren pon yari'kutannîpî. Tîîse manni' parî' ko'mamî pepîn kure'ne. Sîrîrîpe eesera'ma moropai penane awa'pi'ta. Mîrîrî kupî tîuya yentai pu'kuru Paapaya amîrî'nîkon epontî morî pe awanîkonpa. Î' ton pe mararî mîrikkî innape ikupîya'nîkon mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mîrîrî ye'nen tauya sîrîrî, mîrîrî aako'manto'kon pî' teesenumenkai pra e'tî. Kîkatî aawarîrî'nîkon: “O'non pata uya're' ton moropai uwuku ton moropai upon ton eporîuya e'painon?” kîkatî. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Manni'kan Paapa epu'nenan pepînya mîrîrî warantî taa ko'mannîpî maasa pra itu'se tîwe'to'kon pî' to' esenumenka kure'ne. Mîrîrî warantî pra amîrî'nîkon e'pai awanî. Maasa pra ayunkon Paapa ka' ponya tamî'nawîrî î' itu'se awe'to'kon epu'tî pî' man. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tîîse e'mai' pe Paapa yenya' eturumakatî, ayepotorîkon pe awe'to'pe. Moropai î' itu'se Paapa e'to' yawîrî iku'tî. Mîrîrî kupîya'nîkon ya, tamî'nawîrî manni' itu'se awe'to'kon tîrîiya aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mîrîrî ye'nen penanan wei pî' teesenumenkai pra e'tî. Tîîse sîrîrîpan pî' neken esenumenkatî. Maasa pra penanan weiyu yainon ton moro man. Moropai wei kaisarî moro man mîrîrî weiyu yainon ton. Mîrîrî ye'nen eerepamî rawîrî kîsenumenkatî mîrîrî pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesusya ta'pî: —Tiaronkon nîkupî'pî pî' taatako'menkai pra e'tî, anî' atako'menka namai ankupî'pîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Maasa pra tiaronkon pî' aatako'menkakon warantî tiaron atako'menka apî'nîkon. Tiaronkon pî' ankupî'pîkon warantî ikupîiya apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Moropai ta'pîiya inî'rî: —Î' wani' awanî ye'nen kin ayonpa nîkupî'pî, iteseru era'maya mîrîrî morî pe, ayeseru itentai ankupî'pî nura tera'mai pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tîîse î' ton pe mîrîrî warantî taaya ayonpa pî'. “Maasa ayenu yawon mo'kato'peuya”, taaya si'mîrikkî pe tîwe'sen pî'. Tîîse î' wani' awanî ye'nen kure'nan yei warantî tîwe'sen ayenu ya' era'maya pepîn? ");
INSERT INTO mbcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Amîrî'nîkon seru'ye'kon teesenku'tîsanon aawarîrî'nîkon. E'mai' pe ayeserukon era'matî, ikonekatî morî pe. Mîrîrî ayeseru tîkonekai ayonpa yeseru konekai attîpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Moropai ta'pîiya: —Paapa maimu etatîponkon tîîse innape iku'nenan pepîn, inkamoro ye'ka pî' kîsekareme'tî. Inkamoro wanî sokoro' pe arinmarakayamî' warantî. Mîrîrî yu'se pra tîwanîkon wenai awinîkîi'nîkon to' ekore'ma. Moropai morî epe'ke pe tîwe'sen diamante itese' yenumî e'pai pra awanî porcoyamî' kore'ta. Maasa pra inkamoroya yaki'tapapîtî. Mîrîrî warantî inkamoro Paapa maimu yu'sankon pepîn pemonkonyamî' wanî porcoyamî' warantî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Tîîse tauya sîrîrî apî'nîkon esatî pî' ako'mantî teeseta'kai pra, moropai yapisîya'nîkon. Moropai yuwa pî' aako'mantî moropai eporîya'nîkon. Moropai mana'ta pa'tî pî' ako'mantî moropai wîttî esa'ya yarakkanmoka. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maasa pra tamî'nawîronkon esa'nenanya tînesatî'pîkon yapisî. Moropai yuwanenanya tînuwakon eporî. Moropai mana'ta pa'tînen pia mana'ta atarakkanmoka. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","A'kî, anmukukonya tiyu ton esatî ya apî'nîkon, inesatî'pî pepîn tî' tîrîya'nîkon e'painon iipia, ikei esa'sai'ya tanne? ");
INSERT INTO mbcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Moropai tiyo' ton moro' esa'sai'ya tanne, inesatî'pî pepîn îkîi tîrîya'nîkon pepîn iipia? Kaane, inesatî'pî tîrîya'nîkon e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Amîrî'nîkon wanî imakui'pî ku'nenan pe teuren. Tîîse anmukukon pia morî tîînenan amîrî'nîkon, imakui'pî tîînenan pepîn. Mîrîrî morî tîrîya'nîkon manni' yentai, Paapa ka' ponya manni'kan tîpî' esa'nenan pia morî tîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Mîrîrî ye'nen tiaronkon yarakkîrî morî ku'tî, inkamoroya nîrî morî kupî yu'se awanîkon yawîrî. Mîrîrî warantî iku'to'pe Moisés nurî'tîya yenupanto' wanî mîrîrî. Moropai penaronkon Paapa maimu ekareme'nenan profetayamî'ya yenupanto' wanî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Moropai ta'pî Jesusya: —E'ta'ka mana'ta yai ewontî. Maasa pra awene' mana'ta moropai awene' e'ma, mîrîrî wanî ataka'manto' ya' yaaton pe. Mîrîrî wanî sa'me pra. Mîrîrî ye'nen tu'kankon pemonkonyamî' esenku'tîsa' wîtî mîrîrî ataka'manto' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tîîse mana'ta e'ta'ka tauya manni' moropai e'ma siiruru mîrîrî wanî yaaton pe ipatîkarî ko'mannîto' pata pona. Mîrîrî wanî sa'me. Mîrîrî ye'nen tu'kankon pepîn pemonkonyamî' wîtî mîrîrî e'ma taawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Moropai Jesusya ta'pî: —Tîwarî panpî' e'tî seru'ye' pe yenupatonkon pî'. Inkamoro iipî Paapa pemonkonoyamî' yenku'tîi innape tîmaimukon wanî kai'ma to' e'to'pe. Tîîse mîrîrî to' yeseru to' nîkupî wanî kaikusiyamî' yeseru warantî nari' uurî'nîkon pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mîrîrî ye'nen amîrî'nîkonya epu'tî to' nîkupî wenai. Maasa sîrîrî epu'tî —ta'pîiya. —Mî'nî ye' epeta pepîn e'painon uva pe. Moropai figo pe mî'nî ye' epeta pepîn e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tîîse tamî'nawîron yei morîya morî pe teperu tîrî. Moropai yei pakkori'tasa'ya teperu tîrî imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mîrîrî ye'nen yei morîya imakui'pî pe teperu tîrî pepîn. Moropai yei pakkori'tasa'ya morî pe teperu tîrî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mîrîrî ye'nen tamî'nawîrî yei morî pe pra teperu tîînen ya'tî to'ya. Moropai mîrîrî yenumî apo' ya' aaranto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mîrîrî warantî inkamoro seru'ye' pe tîwe'sanon yeseru epu'tîya'nîkon î' to' nîkupî wenai. Mîrîrî warantî to' epu'tîya'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ta'pî Jesusya: —Tamî'nawîronkonya taa kupî sîrîrî upî': “Anna yepotorî”, taa to'ya. Tîîse tamî'nawîrî inkamoro mîrîrî taatîpono'san wîtî pepîn Paapa pia. Tîîse manni'kan neken î' itu'se uyun Paapa e'to' manni' yawîrî ikonekanenan, inkamoro neken wîtî iipia, ipemonkono pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Î' pensa mîrîrî taa to'ya weiyu erepamî yai, tu'kankon pemonkonyamî'ya taa kupî sîrîrî. “Anna yepotorî, anna eseurîma'pî Paapa maimu ekaremekî pî' ayese' wenai tiaronkon pî'. Moropai amîrî anna yepotorî ese' pî' pemonkonyamî' ya' ewomî'san imariwa'yamî' yenpa'ka'pî annaya tu'ke. Moropai tu'ke ite'ka anî' nîkupî eserîkan pepîn ku'pîtî'pî annaya ayese' pî'”, taa to'ya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Inkamoro maimu yuukuuya kupî sîrîrî see warantî: “Anî'kan pe awanîkon epu'tîuya pra wai. Atarimatî uupiapai. Umaimu yu'nenan pepîn amîrî'nîkon. Imakui'pî kupî pî' tîîko'mansenon amîrî'nîkon”, tauya to' pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tamî'nawîrî mîrîrî taa yaretî'ka tîuya pe, Jesusya ta'pî: —Mîrîrî ye'nen o'non ye'ka pe umaimu etanen neken pepîn tîîse iku'nen wanî? Mîîkîrî wanî epu'nen pe pu'kuru. Awanî manni' warayo' epu'nen pe tîwe'sen warantî. Mîîkîrîya tewî' ton koneka'pî sa'man po eesenumî namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tewî' konekasai'ya tanne, kono' rena'pî mararî pra. Tuna kuma'pî kure'ne ipona eerepamî'pî. Moropai a'situn erepamî'pî ipona yenumîpa kai'ma. Tîîse yenumîiya pra awanî maasa pra sa'man pona ikonekasa' pe awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tîîse manni' umaimu etanen tîîse iku'nen pepîn pemonkon wanî, manni' yairî pra teesenumenkasen warantî. Yairî pra teesenumenka ye'nen, tewî' ton koneka'pîiya sa'man pepîn kasapan pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tewî' konekasai'ya tanne, kono' rena'pî mararî pra. Tuna kuma'pî kure'ne ipona. Moropai a'situn erepamî'pî meruntî ke ipona. Aapîtato' ton pra awanî ye'nen yenumî'pîiya tamî'nawîrî. Î' e'nîmî pra awanî'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mîrîrî warantî teeseurîmato' yaretî'ka Jesusya tanne tu'kankon pemonkonyamî' esenumenka'pî mararî pra teesewankono'mai tenupatoi'ya'nîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Maasa pra mîîkîrî yeseru era'ma'pî to'ya Moisés nurî'tîya yenupanto' pî' yenupatonkon warantî pra. Tîîse epu'nen pe tenupatoi'ya'nîkon epu'tî'pî to'ya, meruntî ke tîwe'to' ke tenupaiya'nîkon epu'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mîrîrî tîpo Jesus autî'pî wî' poi. Moropai arinîkon pemonkonyamî' wîtî'pî ipîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mîrîrî ya pri'ya pra tîwe'sen e'rennuku'pî iipia. Mîîkîrî sa'ne wanî'pî paran, ere' pî' tîwe'sen pe. Moropai mîîkîrî e'sekunka'pî Jesus rawîrî. Mîîkîrîya ta'pî Jesus pî': —Yepi'tîton amîrî, Uyepotorî. Uurî anepi'tîpai awanî ya, uyepi'tîkî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mîrîrî taiya ye'nen, Jesusya tenya kainumî'pî yapîpa kai'ma. Moropai ta'pî Jesusya ipî': —Inna, esepi'tîn pî' nai. Mîrîrî taa Jesusya pe rî, eesepi'tî'pî. Inî'rî ere' ton pra eena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mîîkîrî pî' ta'pî Jesusya: —A'kî, esepi'tîn pî' nai tîîse anî' pî' eesepi'tîsa' kîsekaremekîi —ta'pîiya. —Tîîse atîkî teepîremasen pia î' kai'ma amîrî esepi'tîsa' era'mato'peiya iipia matîi. Moropai mîrîrî tîpo, Moisés nurî'tîya yenupanto' yawîrî teepîremasen pia antîrî ton marîi, î' kai'ma eesepi'tîsa' ekaremekîpa tamî'nawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pemonkonyamî' yeurîma yaretî'ka tîpo, Jesus wîtî'pî Cafarnaum cidaderî pona. Miarî Cafarnaum po surarayamî' yepotorî wanî'pî Roma pata pon. Mîîkîrî poitîrî kure'ne inapurî enasa' wanî'pî pri'ya pra. Aasa'manta eserîke awanî'pî. Mîrîrî ye'nen Jesus ponaya attî'pî eporîpa kai'ma. Moropai eposa' tîuya pe ta'pîiya Jesus pî' tîpoitîrî yepi'tîto'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ta'pîiya Jesus pî': —Uyepotorî, upoitîrî sa'ne man mararî pra pri'ya pra uyewî' ta. E'mî'sa'kakoi pepîn kure'ne tîmoron epu'tî pî' aako'mamî mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mîîkîrî maimu yuuku'pî Jesusya: —Uutî moriya yepi'tîi —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mîrîrî yuuku'pî surarayamî' esa'ya: —Kaane Uyepotorî, uurî sa'ne wanî Judeu pepîn. Mîrîrî ye'nen uyewî' ta eewomî eserîke pra nai, Judeu pe awanî ye'nen. Tîîse amaimu ke neken taaya yu'se wanî sîrîrî upoitîrî enato'pe pri'ya, eewomî pra tîîse —ta'pî surarayamî' esa'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Epu'tî pî' wai seru' pepîn. Kure'ne uurî wanî tîîse uyesanon moro to' man, uyentainokon. Inkamoro maimu yawîrî tîwe'sen uurî. Moropai mîrîrî warantî nîrî upemonkonoyamî' moro to' man, surarayamî', umaimu yawîrî tî'we'sanon. Tauya ya tiwinan pî' “atîkî” tauya ya, attî umaimu pe. Tiaron pî' “Asi'kî” tauya ya, aaipî uupia umaimu pe. Moropai “seeni' ku'kî” tauya ya upoitîrî pî', umaimu pe ikupîiya. Mîrîrî warantî nîrî ikupîya ya, epu'tî pî' wai awe'kupî sîrîrî. Uyentai pu'kuru awanî ye'nen, amaimu pe awe'kupî sîrîrî —ta'pî surarayamî' yepotorîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mîrîrî warantî taa surarayamî' yepotorîya pî' Jesus esenumenka'pî mararî pra teesenumenkai. Moropai ta'pîiya tîpîkîrî tîwe'sanon pemonkonyamî' pî': —Tauya sîrîrî apî'nîkon, kure'ne innape ukupî pî' nai. Mîrîrî ye'ka eporîuya pra wai Paapa pemonkonoyamî' Judeuyamî' kore'ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Enpenatatî maasa sîrîrî pî'. Maasa tamî'nawîronkon esa' pe tîwanî Paapaya yenpoto' weiyu erepansa' yai, tu'kankon pemonkonyamî' iipî kupî sîrîrî wei epa'ka winîpai, moropai wei ewomî winîpai. Inkamoro Judeuyamî' pepîn ereuta kupî sîrîrî Abraão nurî'tî, Isaque nurî'tî, moropai Jacó nurî'tî yarakkîrî kure'nan entamo'kanto' ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tîîse Judeuyamî', Paapa pemonkono pe awanîtonkon teuren, ereuta e'pai tîîse Paapaya to' yenumî kupî sîrîrî ewaron ta. To' ewomî pepîn Paapa pia. Iipiapai to' ko'mamî. Miarî to' karau mararî pra. “Ane” taapîtî to'ya teekon tîpa'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Moropai ta'pî Jesusya surarayamî' esa' pî': —Enna'pokî ayewî' ta, innape pu'kuru uku'to'ya yawîrî awe'kupî sîrîrî —ta'pî Jesusya. Moropai surarayamî' esa' poitîrî esepi'tî'pî ka'ne' pe Jesus maimu pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mîrîrî tîpo Jesus wîtî'pî Pedro yewî' ta. Moropai mîîkîrî yawo'pî era'ma'pîiya tette' ta pri'ya pra. Eekomi'masa' awanî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mîîkîrî yenya pî' Jesusya yapisî'pî moropai mîrîrî pe rî eekomi'makapî'pî, pri'ya eena'pî. Moropai mîîkîrî e'mî'sa'ka'pî moropai mîîkîrî yekkari ton koneka pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ko'mamîiya pata enasa' tanne, pemonkonyamî'ya o'ma' yarakkîrî tîwe'sanon pemonkonyamî' yarî'pî Jesus pia o'ma'kon yenpa'kato'peiya. Moropai tîmaimu ke neken to' yenpa'ka'pîiya. Moropai tamî'nawîrî insamoro pri'yawonkon pepîn yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesusya ikupî'pî mîrîrî warantî, maasa pra awe'kupî sîrîrî ta'pî penaro' Paapa maimu ekareme'nen Isaías nurî'tîya yawîrî. Ta'pîiya see warantî: Mîîkîrîya uyeparankon yaasa' man tîpona, moropai ne'ne' pe e'nîto' mo'kasai'ya man ta'pî Isaías nurî'tîya pena. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mîrîrî taa tîpo, Jesus era'tî'pî tu'kankon pemonkonyamî' tîwoi tîwe'sanon era'mai moropai tîmenka'san yaipontî'pîiya to' wîtîto'pe iku'pî ratai pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mîrîrî taa Jesusya tanne, Moisés nurî'tîya yenupanto' pî' yenupaton erepamî'pî Jesus pî' kai. Moropai ta'pîiya: —Uyenupanen, uurî wanî sîrîrî tarî, o'non pata attî ya, awenairî uttî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mîîkîrî maimu yuuku'pî Jesusya. Ta'pîiya: —A'kî, maikanyamî' yeutta mororon, to' yewî'. Moropai toronyamî' tî'moikon yenpo yaponse' nîrî mororon. Tîîse uurî, ka' poi iipî'pî pemonkon pe uyewî' ton pra man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Moropai tiaron Jesus wenairî tuutîsenya ta'pî ipî': —Uyepotorî, maasa awenairî uutîto'pe e'mai' pe enna'po tanne uyun pia aasa'manta pîkîrî —ta'pî tiaronya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesusya imaimu yuuku'pî: —Tîwî inkamoro innape umaimu ku'nenan pepînya isa'manta'san yu'na'tîi —ta'pîiya. —Tîîse amîrî wîtî yu'se wai upîkîrî —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mîrîrî tîpo Jesus asara'tî'pî kanau ya' moropai attî'pî tînenupa'san pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","To' wîtî tanne tiwinarî ka'ne' pe kure'nan sipa sipa erepamî'pî, a'situn wanî'pî mararî pra. To' kanau yeuronkaiya eserîke sipa sipa wanî'pî nari' pe. Mîrîrî tanne Jesus we'nasa' ko'mamî'pî miarî kanau ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mîîkîrî yenpakai inkamoro imenka'san wîtî'pî ka'ne' pe teesi'nî'se. Ta'pî to'ya: —Uyepotorî, apakakî e'tî'kan pe man. Î' pî' awetun mîrîrî anna pîika'tîkî —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Moropai Jesus e'mî'sa'ka'pî moropai ta'pîiya to' pî': —Î' wani' awanî ye'nen eranne' pe awanîkon mîrîrî? Innape ukupîya'nîkon pepîn mîrîrî? —ta'pî Jesusya to' pî'. Mîrîrî taa tîpo awe'mî'sa'ka'pî moropai ta'pîiya a'situn pî' moropai tuna pî': —Atî'napankî. Moropai tamî'nawîrî aatî'napamî'pî Jesus maimu pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mîrîrî warantî Jesusya ikupî era'ma tîuya'nîkon ye'nen, tamî'nawîronkon wanî'pî kure'ne teesenumenkai. Moropai inkamoroya ta'pî tîîwarîrî'nîkon: —O'non ye'ka see warayo' mîserî imaimu yawîrî a'situn moropai tuna e'to' —ta'pî to'ya tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Moropai Jesus wîtî'pî Galiléia ku'pî rataipon pata Gadara pona. Miarî Jesus eseu'ka tanne, kanau yapai asakî'nankon imariwa'ka'pankon warayo'kon wîtî'pî Jesus ponaya epose. Inkamoro iipî'pî uuruwai kore'tapai maasa pra inkamoro ko'manto' wanî'pî uuruwai kore'ta. Inkamoro e'pîtî'pî meruntî ke o'non ye'ka pe ikupî eserîke pra nari' pe to' wanî'pî. To' rî'pîkîrî e'ma taawîrî wîtîn eserîke pra to' e'pîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Inkamoro entaime'pî. Ta'pî to'ya: —Amîrî Paapa ka' pon munmu. Î' ku'se aai'sa' sîrîrî anna pî'? Anna taruma'tîi ka'rî aai'sa'? Anna kî'taruma'tîi maasa e'taruma'tînto' weiyu erepamî pra tîîse —ta'pî warayo'konya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Miarî, aminke panpî' porcoyamî' wanî'pî tu'kankon, tekkarikon yena'nenan. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","O'ma'konya Jesus pî' esatî'pî teeseka'nunkai inkamoro porcoyamî' ya' teewomîkonpa kai'ma. —Anna yenpa'kaya ya, inkamoro porcoyamî' ya' anna ewonto'pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Inna moriya, atîtî —ta'pî Jesusya to' pî'. Mîrîrî ye'nen inkamoro o'ma'kon epa'ka'pî warayo' yapai. Moropai to' ewomî'pî porcoyamî' ya'. Tîîse mîrîrî pe rî porcoyamî' eka'tumî'pî irama yai, to' e'soroka'pî tuna ka, moropai to' e'tî'ka'pî tîîna'se. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Warayo'kon porcoyamî' pî' teesenyaka'masanonya mîrîrî e'kupî era'ma'pî. Mîrîrî ye'nen inkamoro e'tîrîka'pî, moropai to' wîtî'pî cidade pona. Miarî mîrîrî tînerama'pîkon ekaremekî'pî to'ya tamî'nawîrî. Moropai inkamoro asakî'nankon warayo'kon imariwa'ka' pe si'san esepi'tîsa' yekare pî' nîrî to' eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mîrîrî yekare eta tîuya'nîkon ye'nen, tamî'nawîronkon mîrîrî cidade po tîîko'mansenon wîtî'pî Jesus epose. Moropai mîîkîrî eposa' tîuya'nîkon pe, tîpatakon yapai Jesus wîtîto'pe esatî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Moropai Jesus asara'tî'pî kanau ya' tuutîpa iku'pî ratai pona. Moropai attî'pî, eerepamî'pî tîpata ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mîrîrî yai tiaronkon pemonkonyamî'ya Jesus pia pri'yawon pepîn warayo' asakoi pepîn enepî'pî tette' ta tîîse. Jesusya innape pu'kuru tîkupî to'ya epu'tî'pî. Mîrîrî ye'nen ta'pîiya mîîkîrî pri'yawon pepîn pî': —Mooyi, meruntî ke e'kî. Maasa pra imakui'pî ankupî'pî kupî pî' wai uuwanmîra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mîrîrî warantî taa Jesusya eta tîuya'nîkon ye'nen, warayo'kon Moisés nurî'tîya yenupanto' pî' yenupatonkon eseurîma'pî tîîwarîrî'nîkon. —Iseruku mîrîrî. Anî'ya imakui'pî pe warayo' e'to' mo'ka pepîn, Paapa pe pra si'ma. Tîîse Paapaya neken imo'ka —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mîrîrî warantî tewankon ya' to' esenumenka epu'tî'pî Jesusya. Mîrîrî ye'nen ta'pîiya to' pî': —Î' ton pe see mîrîrî warantî eesenumenkakon mîrîrî imakui'pî pe? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Imakui'pî ankupî'pî rona pî' wai taa pî' wai mîserî pri'yawon pepîn pî'. Tîîse innape iku'sau'ya epu'tîya'nîkon eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mîrîrî ye'nen uurîya, pemonkon pe ka' poi iipî'pîya anera'makon ton kupî sîrîrî. Meruntî ke wai imakui'pî ronato'peuya, seru' pe pra eseurîma epu'tîkonpa, mîîkîrî pri'yawon pepîn yepi'tîuya. I'mî'sa'kauya, tette' yanmako'mato'peiya aasato'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mîrîrî pe rî mîîkîrî warayo' e'mî'sa'ka'pî. Moropai attî'pî tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mîrîrî warantî ikupî Jesusya era'ma tîuya'nîkon ye'nen, pemonkonyamî' esi'nîpî'pî mararî pra ipî'. Moropai Paapa yapurî'pî to'ya inamai'ma mararî pra. —Tîîse sîrîrî warantî meruntî tîîsa' Paapaya era'ma sîrîrî pemonkon pia —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mîrîrî tîpo Jesus epa'ka'pî moropai attî'pî. Tuutî ye'ka pe e'ma taawîrî warayo' era'ma'pî Jesusya itese' Mateus. Mîîkîrî ereutasa' wanî'pî tîniru tîrî to'ya yaponse' pia. Maasa pra mîîkîrî wanî'pî tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masen pe. Mîîkîrî pî' ta'pî Jesusya: —Aase uwenairî —ta'pîiya. Mîrîrî ye'nen Mateus e'mî'sa'ka'pî moropai attî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mîrîrî yai tu'kan entamo'kanto' wanî'pî Mateus yewî' ta. Miarî Jesus entamo'ka tanne, tiaronkon tîniru yapi'nenan erepamî'pî to' kore'ta. Moropai tiaronkon pemonkonyamî' Moisésya yenupanto' yawîrî pra tîwe'sanon nîrî erepamî'pî. Inkamoro wanî'pî to' entamo'kato' yaponse' pia Jesus pokonpe moropai Jesus nenupa'san pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mîrîrî yai tiaronkon fariseuyamî'ya to' yeseru era'ma'pî. Mîrîrî ye'nen Jesus nenupa'san ekaranmapo'pî to'ya: —Î' wani' awanî ye'nen kin amîrî'nîkon yenupanenya tekkari yonpa mîrîrî, inkamoro Moisésya yenupanto' yawîrî pra tîwe'sanon pemonkonyamî', moropai tîniru yapisî pî' teesenyaka'masanon pokonpe si'ma? ");
INSERT INTO mbcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Inkamoro tînenupa'san ekaranmapo to'ya eta'pî Jesusya. Moropai yuuku'pîiya: —A'kî, pri'yawon pemonkonya tepi'tînen ton yuwa pepîn. Tîîse pri'ya pra tîwe'senya tepi'tînen ton yuwa e'painon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Moropai ta'pîiya: —Paapa maimuya taasa' see warantî: “Paapa yapurî pe anpo'tîkon po'tîya'nîkon yu'se pra wai. Tîîse eetî'noko'mato'kon yu'se wai anpo'tîkon yentai”, ta'pîiya. Mîrîrî ye'nen î' taato'pe awanî epu'tî. Maasa pra uui'sa' pra wai morî pe tîwe'ku'sanon yannoi, tîîse imakui'pî pe tîwanîkon epu'nenan pemonkonyamî' yannoi uui'sa' sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mîrîrî tîpo João Batista nenupa'san erepamî'pî Jesus pia ekaranmapoi. Inkamoroya ta'pî ipî': —Î' wani' awanî ye'nen anna moropai fariseuyamî' nenupa'san epîremapîtî tu'ke ite'ka tekkarikon tonpai pra, tîîse anenupa'sanya mîrîrî warantî ikupî pra awanî? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Inkamoro maimu yuuku'pî Jesusya: —Tîneta'san pokonpe tîwe'marimasen wanî tanne ta're'kon tonpai pra to' wanî pepîn. Tîîse to' entamo'ka moropai to' atausinpa mararî pra. Tîîse tiwin wei mîîkîrî tîwe'marimasen mo'kato' weiyu erepamî kupî sîrîrî. Mîrîrî yai tekkarikon yonpa to'ya pepîn kupî sîrîrî teesewankono'makon ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Inî'rî to' nepu'tî ton ekaremekî'pî Jesusya. Ta'pîiya: —A'kî, anî'ya amenan kamisa wanî poi'pî iipia'pî ya'tî pepîn e'painon, ipoi'pî pon e'karakasa' irumentanî'to'pe. Maasa pra amenan emo'ka ipoi'pî poi moropai inî' panpî' awe'karaka. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Moropai ta'pîiya inî'rî: —Anî'ya amenan wo' yara'tî pepîn e'painon, ipoi'pî pe tîwe'sen itense' ya'. Maasa pra wo' mai'taya tense' ya'morikka. Moropai wo' eti'kamo, aama'ta. Mîrîrî namai wo' amenan yara'tî e'pai awanî amenan itense' ya' —ta'pî Jesusya. ˻Mîrîrî ta'pîiya amenan esenupanto' pî' tenupaiya'nîkon epu'to'pe to'ya.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Miarî Jesus eseurîma ko'mannîpî tanne pemonkonyamî' pî', to' epere'to'kon esa' Judeu erepamî'pî Jesus pia. Moropai awe'sekunka'pî irawîrî. Moropai ta'pîiya Jesus pî': —Uyensi sa'mantan pî' man. Mîrîrî ye'nen aase uyewî' ta uyensi pona ayenya tîîtane'kî awennapanto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mîrîrî ye'nen Jesus wîtî'pî iwenairî moropai inenupa'san nîrî wîtî'pî ipîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mîrîrî yai wîri' wanî'pî asakî'ne pu' pona tîîmo'tai kono' kaisarî mîn i'kamo pî' tîîko'mansen. Mîîkîrî iipî'pî Jesus mopai winî moropai mîîkîrîya Jesus pon ye'pi pî' yapî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mîîkîrî wîri' esenumenkasa' wanî'pî see warantî: —Ipon ye'pi pî' yapîsau'ya ya, esepi'tî —kai'ma eesenumenkasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus era'tî'pî mîîkîrî wîri' era'mai, moropai ta'pîiya ipî': —Eranne' pe pra e'kî, ma'non. Innape ukupîya ye'nen esepi'tîn pî' nai —ta'pîiya. Moropai mîrîrî pe rî eesepi'tîsa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mîrîrî tîpo Jesus wîtî'pî to' epere'to'kon esa' yewî' ta. Teerepamî pe, pemonkonyamî'ya wîri' sa'mantasa' yeremu ye'nunpa eta'pîiya. Moropai pemonkonyamî'ya mararî pra “waawa” ta'pî, tîkaraukon ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Inkamoro pî' ta'pî Jesusya: —Tamî'nawîrî epa'katî tarîpai. Maasa pra mîserî more sa'mantasa' pra man iwe'nasa' neken man —ta'pîiya. Mîrîrî warantî taasai'ya ye'nen, Jesus pî' to' o'ma'ta pia'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Miarî pai inkamoro pemonkonyamî' epa'ka'pî tanne, Jesus ewomî'pî, o'non pata mîîkîrî wîri' isa'manta'pî e'to' ta. Moropai mîîkîrî yenya pî' Jesusya yapisî'pî, moropai mîîkîrî e'mî'sa'ka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mîrîrî ku'sa' Jesusya mîîkîrî wîri' yarakkîrî yekare eta'pî tamî'nawîronkon pemonkonyamî'ya, mîrîrî pata ponkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Moropai Jesus wîtî'pî mîrîrî pata poi. Attî tanne, e'ma taawîrî asakî'nankon warayo'kon enkaru'nankon iipî'pî ite'ma'pî pî', tîwentaimepîtîkon ye'ka pe. Ta'pî to'ya ipî': —Amîrî Davi paarî'pî, pemonkonyamî' pîika'tîton, anna era'makî a'noko'pî pe sa'ne —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wîttî ta Jesus ewomî'pî, moropai inkamoro enkaru'nankon erepamî'pî Jesus pia aminke pra. Moropai inkamoro ekaranmapo'pî Jesusya: —Innape ayepi'tîuya'nîkon kupî pî' naatî? —ta'pîiya. —Inna, anna yepotorî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesusya to' yenukon yapî'pî. Moropai ta'pîiya: —Innape pu'kuru ukupîya'nîkon ye'nen, ayepi'tîuya'nîkon sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Moropai inkamoro yenu esepi'tîsa' wanî'pî. Inkamoro pî' ta'pî Jesusya: —Anî'kan pî' sîrîrî eesepi'tîsa'kon manni' kîsekareme'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tîîse inkamoro esepi'tîsa' wîtî'pî. Moropai inkamoroya tepi'tîsa'kon Jesusya ekaremekî'pî tamî'nawîronkon mîrîrî pata poronkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Inkamoro wîtî'pî tanne, tiaronkon pemonkonyamî'ya warayo' eseurîmakoi pepîn yarî'pî, Jesusya yepi'tîto'pe. Mîîkîrî wanî'pî ya' o'ma' tîwe'sen pe. Mîrîrî ye'nen eeseurîma pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mîîkîrî o'ma' yenpa'ka'pî Jesusya pata'pî pe warayo' eseurîma pia'tî'pî. Mîîkîrî eseurîmakoi pepîn era'ma tîuya'nîkon ye'nen tamî'nawîronkon pemonkonyamî' wanî'pî kure'ne teesenumenkai mîrîrî pî'. Inkamoroya ta'pî: —Sîrîrî ye'ka e'kupî era'masa' pra man tarî Israel pata po. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tîîse fariseuyamî'ya ta'pî: —Mîîkîrî wanî mîrîrî o'ma'kon yepuru pe tîwe'sen winîpai meruntî yapi'nen pe. Mîrîrî ye'nen ikupîiya mîrîrî meruntî ke. Maasa pra mîîkîrî o'ma'kon yepuruya iipia meruntî tîîsa' iku'to'peiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus asarî'pî cidadekon poro tamî'nawîrî moropai pemonkonyamî' ko'manto'kon poro aasarî'pî. To' yenupa pinunpa'pîiya Judeuyamî' epere'to'kon yewî'kon tapî'. Moropai morî itekare ekaremekî'pîiya, tamî'nawîronkon esa' pe Paapa iipî kupî ekaremekî'pîiya. Moropai tamî'nawîronkon pemonkonyamî' yepi'tî'pîiya. Tu'kan parankon winîpai to' yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Arinîkon pemonkonyamî' era'ma tîuya pe, Jesusya tî'noko'pî pe to' era'ma'pî. Maasa pra inkamoro pemonkonyamî' wanî'pî itesa' pînon carneiroyamî', ata'ka'ma'san warantî to' era'ma'pîiya. To' e'taruma'tîsa', to' pîika'tînen ton pra era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mîrîrî ye'nen ta'pîiya tînenupa'san pî': —Maasa era'matî. Esenyaka'manto' man mararî pra, tîîse teesenyaka'masen ton pra man. Tu'ke pra teesenyaka'masanon man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","—Mîrîrî ye'nen Paapa pî' esa'tî inî' panpî' teesenyaka'masanon tonkon yarimato'peiya, mararî pra esenyaka'manto' pî' to' esenyaka'mato'pe —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesusya warayo'kon asakî'ne pu' pona tîîmo'tai'nîkon yanno'pî tîîpia. Moropai inkamoro pia meruntî tîrî'pîiya, o'ma'kon yarakkîrî tîwe'sanon yapai to' yenpa'kato'pe to'ya tîmaimu ke. Moropai tamî'nawîron paran winîpai to' yepi'tîto'pe to'ya to' yeparankon winîpai. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inkamoro asakî'ne pu' pona tîîmo'tai'nîkon ese' wanî'pî see warantî. E'mai'non wanî'pî Simão, tîîse Pedro kai'ma esatî'pî to'ya moropai itakon André. Tiago moropai itakon João Zebedeu munkîyamî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Moropai Filipe moropai Bartolomeu moropai Tomé moropai Mateus manni' tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masen. Moropai Tiago Alfeu munmu moropai Tadeu. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Moropai Simão, manni' teepîsen Zelote taato', moropai Judas Iscariotes manni' Jesus rumakatîpon iteyatonon pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Inkamoro warayo'kon yaipontî'pî Jesusya to' wîtîto'pe. Tîmaimu tîrî'pîiya to' pia see warantî: —Attîkon ya, katîtî Judeuyamî' pepîn pata ya'. Moropai Samaria cidaderî pona kewontî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Tîîse aminke Paapa piapainokon Israel ponkon kore'ta itesa' pînon carneiro warainonkon muwatîi —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—Atîtî inkamoro pî' “Aminke pra tamî'nawîronkon esa' pe Paapa ii'to' man”, makatîi to' pî'. “Tîpemonkonoyamî' pîika'tîiya kupî sîrîrî”, makatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Moropai ere'kîpankon mepi'tîtîi, moropai tiaron paran pî' tîwe'sanon mepi'tîtîi. Moropai isa'manta'san mi'mî'sa'katîi. Moropai o'ma'kon yarakkîrî tîwe'sanon yapai menpa'katîi. Mîrîrî warantî mîku'tîi te'mai pra. Maasa pra te'mai pra sîrîrî meruntî yapisî'pîya'nîkon. Mîrîrî warantî nîrî itîîtî antîrîkon itepe'pî tuwai pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Attîkon ya î' rî kîsatî asakunikon ya'. Ouro moropai prata moropai tîniru ena'pî kîsatî itense' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Attîkon ya aponkon ton kîsatî moropai a'sa'sakon ton kîsatî. Moropai ame'sipukon kîsatî aapîtato'kon ton. Maasa pra teesenyaka'masanonya ta're'kon ton yapisî e'pai awanî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Eerepamîkon ya cidade pona pemonkonyamî' kore'ta, eewomîkon ya amîrî'nîkon anapi'pai tîwe'sen pemonkon muwatîi. Moropai mîîkîrî pia mako'mantîi attîkon pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mîîkîrî pemonkon yewî' ta eewomîkon ya makatîi tîîwanmîra e'nîto' wanî pe man sîrîrî wîttî ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anî' amîrî'nîkon yapi'nen wanî ya morî pe mîîkîrî pia morî tîîwanmîn wanî yarakkîrî. Tîîse amîrî'nîkon yapisîiya pra awanî ya, atîtî iipiapai, iipia tîwe'se pra. Mîrîrî ye'nen tîîwanmîn wanî pepîn iipia, tîîse aapia'nîkon neken awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Moropai miarî tewî'kon ta cidade po ayapisîkon to'ya pra to' wanî ya morî pe, moropai amaimukon anetapai pra to' wanî ya, miarî pai mepa'katîi to' kore'tapai. Moropai eepa'kakon pe miarîpai a'sa'sakon pî' atapisî'pî non pa'tîya'nîkon e'pai awanî. Mîrîrî kupîya'nîkon ya, Paapa pia morî pe pra to' wanî, amaimukon anetapai pra to' wanî ekaremekîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ayenku'tîuya'nîkon pepîn. Î' pensa pemonkonyamî' yenumî Paapaya weiyu erepamî yai to' e'taruma'tî pe man. Mîrîrî yai to' e'taruma'tî pe man mararî pra, manni'kan Sodoma cidaderî ponkon nurî'tî moropai Gomorra cidaderî ponkon e'taruma'tî'pî yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Maasa î' tauya etatî. Amîrî'nîkon yarimauya sîrîrî nari'kon kaikusiyamî' warainonkon kore'ta attîkonpa. Amîrî'nîkon wanî carneiroyamî' warantî. Mîrîrî ye'nen tîwarî e'tî, epu'nen pe eesenku'tîkon namai. Tîîse eranmîra e'tî tiaronkon pî' î' imakui'pî tîku'se pra nari' pe pra waku'kaimîyamî' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Moropai tepu'se e'tî, ayarîkon to'ya ya to' epere'to' yewî'kon ta, apî'nîkon teeseurîmakonpa. Mîrîrî yai tiaronkonya apo'pîtîkon mîrîrî to' epere'to'kon yewî' tapî' po'pînnîto' ke. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Uurî wenai mîrîrî warantî akupîkon to'ya. Pata esa' pia ayarîkon to'ya moropai pata esanon esa' pia ayarîkon to'ya. Mîrîrî yai inkamoro pî' umaimu ekaremekîya'nîkon. Moropai manni'kan Judeuyamî' pepîn pî' nîrî umaimu ekaremekîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Î' pensa amîrî'nîkon yarî to'ya yai e'taruma'tînto' ya', kîsewankono'matî î' kai'ma amaimu ton pra awanî pî'. Maasa pra uurîya amaimukon ton tîrî î' kai'ma epu'nen pe awanîkonpa. To' maimu yu'to'yakon ton tîrîuya mîrîrî pe rî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","—Mîrîrî amaimukon yu'to'ya'nîkon wanî pepîn aawarîrî'nîkon aneporî'pîkon pe. Tîîse awanî Paapa yekaton winîpainon pe. Mîrîrî ye'nen mîîkîrî eseurîma amîrî'nîkon pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mîrîrî ye'nen tepu'se e'tî maasa pra amîrî'nîkon rumaka tiaronkon pepîn rî ayonpakonya aasa'mantakonpa. Moropai to' yunkonyamî'ya tînmukukon rumaka to' sa'mantato'pe nîrî. Moropai to' munkîyamî' ena tîyunkon yeyaton pe moropai tîyunkon wîî me'po to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Moropai tamî'nawîronkon pemonkonyamî' yewanma pe amîrî'nîkon ena uyese' wenai. Tîîse anî'ya yapîtanîpî ya, e'taruma'tînto' meruntî ke tîîsa'manta pîkîrî, mîîkîrî e'pîika'tî pe man. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","O'non pata amîrî'nîkon yewanmîrî to'ya ya, moropai amu'tunpakon to'ya ya, cidade poi mepetîi tiaron pata pona. Maasa pra tauya sîrîrî apî'nîkon. Eesenyaka'mato'kon yaretî'kasa'ya'nîkon eserîke pra naatîi, tamî'nawîrî cidadekon poro Judeuyamî' pata poro, uurî, ka' poi iipî'pî erepamî rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A'kî, teesenupasen wanî pepîn tenupanen yentai. Moropai tîkaraiwarî yentai ipoitîrî wanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tîîse teesenupasen wanî ya tenupatîpon kaisarî, morî pe awanî. Moropai tîkaraiwarî kenan poitîrî wanî ya tîkaraiwarî kaisarî, morî pe awanî. Itentai awanî eserîke pra. Mîrîrî ye'nen Belzebu winîpai meruntî yapisîiya taa to'ya ya upî' itentai panpî' taa to'ya awinîkîi'nîkon, maasa pra uwenaironkon pe awanîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Mîrîrî ye'nen eranne' pe pra e'tî inkamoro ye'kakon warayo'kon seru'ye'kon pî'. Maasa pra tamî'nawîrî uyeserukon teesera'mai pra si'pî, esera'ma kupî sîrîrî aronne. Moropai tamî'nawîrî î' ta'pî uurî'nîkonya ama' pe, umaimukon esepu'tî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mîrîrî warantî î' tauya manni' apî'nîkon tiaronkonya eta pra tîîse mîrîrî mekareme'tîi tamî'nawîronkon pî' epu'to'pe to'ya. Moropai uwinîpai aneta'pîkon tiaronkon neta'pî pepîn, mîrîrî mekareme'tîi aronne tamî'nawîronkonya epu'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Eranne' pe pra e'tî manni' amîrî'nîkon wîînen pî'. Awîtîpo'nokon ayekatonkon wîiya eserîke pra man. Tîîse tauya sîrîrî eranne' pe e'tî Paapa pî'. Maasa pra mîîkîrîya awîkon tarî moropai ayekatonkon yenumîiya e'painon apo' ya' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Moropai ta'pîiya: —A'kî, îrîwo'yamî' ke to' e'repa epe'mîra tiwin prata ena'pî. Tîîse inkamoro kore'ta tiwin ena ya non pona, Paapa, Uyunkonya epu'tî. Iwanmînon pepîn inkamoro. To' ko'mannîpîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mîrîrî warantî amîrî'nîkon pu'pai si'po wanî tu'ke teuren, tamî'nawîrî Paapaya epu'tî, maasa pra iku'ne'tîsai'ya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mîrîrî ye'nen eranne' pe pra e'tî. Maasa pra inkamoro toronyamî' ko'mannîpî tîuya yentai Paapaya amîrî'nîkon ko'mannîpî tamî'nawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Pemonkonyamî'ya taa ya aronne tiaronkonya eta tanne, upemonkono pe tîwanî taiya ya. Mîrîrî warantî nîrî tauya Paapa ka' pon rawîrî si'ma upemonkono mîserî tauya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tîîse anî'ya tiaronkon rawîrî si'ma “Uurî kaane, ipemonkono pepîn uurî”, taiya ya, uurîya nîrî mîrîrî warantî taa Paapa ka' pon rawîrî si'ma. “Upemonkono pepîn mîîkîrî”, tauya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Tîîse kîsenumenkatî morî tîwanmîn enepîuya kai'ma sîrîrî non pona uuipî pî'. Tîîse tauya sîrîrî apî'nîkon, morî tîwanmîn ene'sau'ya pra wai. Eseyaton pî' pemonkonyamî' wanî kupî sîrîrî uwenai. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Maasa pra tîyunkon yarakkîrî to' munkîyamî' wanî pe man teekore'mai. Moropai to' munkîyamî' wîri'sanyamî' wanî pe man tîsankon yarakkîrî teekore'mai. Moropai to' pa'setonon wanî pe man tawo'pîkon yarakkîrî teekore'mai. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mîrîrî warantî ayonpakon rî wanî pe man ayeyatonkon pe, tiaronkon pepîn —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Anî'ya tîyun, tîsan yapurî ya, uyapurî tîuya yentai mîîkîrî wanî eserîke pra awanî upemonkono pe. Moropai anî'ya tînmukuyamî' yapurî ya, uyapurî tîuya yentai, mîîkîrî wanî eserîke pra awanî upemonkono pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Manni' uyapurînen wanî ya, mîîkîrîya uwenai tamî'nawîrî tîwe'taruma'tîto' yapîtanîpîiya pra awanî ya, upemonkono pe eserîke pra awanî. Moropai uwenairî aaipî eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Anî'ya tîwe'taruma'tîto' yapîtanîpî pra awanî ya, kure'ne tîîko'manto' pînînmaiya ye'nen tarî non po, mîîkîrîya ipatîkarî tîîko'manto' ton eporî pepîn tîîse aasa'manta pe man. Tîîse anî'ya tîwe'taruma'tîto' nama pra awanî ya uwenai, mîîkîrîya enen tîîko'manto' ton eporî ipatîkarî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—A'kî, anî'ya amîrî'nîkon yapisî morî pe, mîîkîrî ayapisîtîponkonya morî pe uyapisî nîrî. Moropai mîîkîrî uyapisîtîponya uyarimatîpon Paapa yapisî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Moropai morî pe Paapa maimu ekareme'nen yapi'sa' anî'ya ya tewî' ta, morî eporîya pe man. Maasa pra yapisî'pîiya Paapa maimu ekareme'nen pe awanî ye'nen. Mîîkîrî repa Paapaya, tîmaimu ekareme'nen repa tîuya warantî. Moropai anî'ya morî ku'nen yapisî ya tewî' ta, morî eporîiya pe man. Maasa pra yapisî'pîiya, morî pe mîîkîrî wanî ye'nen. Moropai mîîkîrî repa Paapaya, morî ku'nen repa tîuya warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Anî'ya tuna tîrî ya, i'nî' kenan tiwin copo kaisarî upemonkonoyamî' ya'mi'pî pia, si'mîrikkî pe tîîse iwo'paiya ya, mîîkîrî wanî upemonkono pe. Ayenku'tîuya pepîn, mîîkîrî nîrî repa Paapaya. Iwa'kaiya pepîn —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mîrîrî warantî tînenupa'san yeurîma tîpo, Jesus epa'ka'pî miarî pai. Moropai attî'pî. Pemonkonyamî' yenupa pia'tî'pîiya. Paapa maimu ekaremekî pinunpa'pîiya mîrîrî cidadekon poro aminke pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mîrîrî yai João Batista wanî'pî atarakkannîto' yewî' ta. Miarî si'ma Cristoya î' kupî yekare eta'pî Joãoya. Mîrîrî ye'nen tînenupa'san yarima'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesus ekaranmapoi to' wîtîto'pe taato'pe to'ya: —Amîrî manni' tarîwaya aaipîton anna nînîmîkî, kaane ka'rî tiaron moro nai aaipîton? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusya inkamoro maimu yuuku'pî: —Enna'potî moropai João pî' anera'ma'pîkon moropai aneta'pîkon mekareme'tîi —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Tarî enkaru'nankonya era'ma pî' man. Moropai asakoi'kon pepîn asanî pe man. Moropai pri'yawonkon pepîn erekî'pankon esepi'tîsa' man. Moropai pana'tî'pankonya eta pî' man. Moropai isa'manta'san e'mî'sa'kan pî' man. Moropai Paapa maimu esekareme'nî pî' man manni'kan pemonkonyamî' tîwe'taruma'tîsanon pî'. Tamî'nawîrî mîrîrî makatîi João pî'. ˻Pena Paapa nîmenka'pî pî' teeseurîmasen profeta warantî eesekareme'sa' man.˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","—Taatausinpai pu'kuru manni' innape pu'kuru uku'nen, tîwî tîku'se pra moropai teesenumenka yawîrî pra unkupî pî' teesewankono'mai pra mîîkîrî wanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Inkamoro João nenupa'san wîtî'pî tanne, tîîpiapai Jesusya pemonkonyamî' yeurîma pia'tî'pî, João Batista yekare pî': —Keren pona attîsa'kon yai, João yarakkîrî esepose Î' era'ma'pîya'nîkon? Konoi' yepu yarimapîtî a'situnya ka'rî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—Î' era'ma'pîya'nîkon kin, warayo' morî pe epontî'pî ka'rî morî tîpon ya' era'ma'pîya'nîkon? A'kî, tauya sîrîrî apî'nîkon. Warayo' morî pe tîpon ya' epontî'pî wanî ya, mîîkîrî ko'mamî e'painon morî pu'kuru wîttî ta, ipîkku pe tîwe'sen yewî' ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—Moriya ka'tî upî' î' era'ma'pîya'nîkon? Paapa maimu ekareme'nen penaron profeta ka'rî? Inna, seru' pepîn tauya sîrîrî apî'nîkon. Paapa maimu ekareme'nen profeta yentainon era'ma'pîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Maasa pra mîîkîrî João wanî manni' Paapaya ta'pî yawîrî. “A'kî mîserî umaimu ekareme'nen yarimauya kupî sîrîrî arawîrî attîto'pe. Aye'marî ton konekai e'mai' pe attîto'pe”, ta'pî Paapaya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Ayenku'tîuya pepîn. Mîîkîrî João wanî tamî'nawîronkon pemonkonyamî' yentai tîwe'sen pe. Tîîse anî' wanî ya innape uurî ku'nen ipîkku pe pra si'ma, mîîkîrî esa' Paapa wanî moropai mîîkîrî wanî João yentai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jesusya taa ko'mannîpî'pî: —Joãoya pemonkonyamî' esa' pe Paapa ii'to' ekaremekî pia'tî'pî patapai, sîrîrî tîpose Paapa pemonkono pe enapai arinîkon pemonkonyamî' wanî'pî. Mîrîrî anetapai to' wanî kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maasa pra tamî'nawîronkon Paapa maimu ekareme'nenan profetayamî' nurî'san moropai Moisés nurî'tîya yenupanto'ya taasa' pîikatîton iipî pe man. Moropai mîrîrî ekareme'se João iipî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mîîkîrî João wanî mîrîrî Elias pe, manni' Paapa maimu ekareme'nen profetaya aaipî ta'pî. Mîîkîrî ku'tî innape anku'pai awanîkon ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sîrîrî itekare anepu'pai awanîkon ya, etatî morî pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mîrîrî ye'nen ta'pî Jesusya: —Anî'kan warantî see sîrîrî pankon pemonkonyamî' kupîuya e'painon? Inkamoro wanî moreyamî' poroyi'pî po si'ma tîsu'minansenon warantî. Tiaron moreyamî' entaimepîtî to' pî' to' pokonpe tîsu'minkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ta'pî to'ya: “Tîwe'marimasen waiyi ye'nunpa'pî annaya amananukonpa tîîse amanunukon pra awanî'pîkon. Moropai isa'manta'pî kararunpato' yeremu kupî'pî annaya, tîîse akaraukon pra awanî'pîkon”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tonpakonya ikupî warantî pra João Batistaya tekkari yonpa pra awanî'pî tui'sa' yai. Moropai tîwuku enîrîiya pra awanî'pî. Mîîkîrî pî' tamî'nawîronkonya o'ma' yarakkîrî tîwe'sen pe awanî mîrîrî ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Moropai uurî, ka' poi iipî'pî entamo'ka pî' moropai uwuku enîrîuya pî' taa to'ya upî': “A'kî mîîkîrî warayo' wanî kure'ne ta're' yonpanen pe moropai kure'ne tîwuku enî'nen pe awanî”, taa to'ya. “Moropai tesanonkon pia to' nîtîrî tîniru yapi'nenan yonpa pe awanî mîrîrî”, taa to'ya. “Imakui'san pemonkonyamî' yonpa pe awanî”, taa to'ya. Tîîse tauya anî'ya Paapa winîpainon epu'nen yapisî ya, mîîkîrî yeseru wanî morî pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mîrîrî yai Jesusya mîrîrî cidadekon po, eserîkan pepîn kupî tîuya era'matîponkon yeka'nunka'pî mararî pra, maasa pra tîmakuyikon rumakasa' to'ya pra to' wanî ye'nen. Mîrîrî ye'nen ta'pîiya to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Aka sa'ne, amîrî'nîkon Corazim cidaderî po tîîko'mansenon. Aka sa'ne, amîrî'nîkon Betsaida cidaderî po tîîko'mansenon. Maasa pra mîrîrî ikupî eserîkan pepîn apatakon ya' e'kupî e'ku'sa' ya, Tiro cidaderî po moropai Sidom po, miarî tîîko'mansenonya imakui'pî pe tîwe'to'kon rumaka'pî to'ya e'painon pena. Moropai imakui'pî rumaka tîuya'nîkon ekaremekî'pî to'ya e'painon, moropai saaku ya' yeka'ma'pî to'ya e'painon, urunu'pî tîrî'pî to'ya e'painon tîpu'paikon pona, teesewankono'makon ekaremekîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ayenku'tîuya'nîkon pepîn. Tamî'nawîronkon yenumî Paapaya weiyu yai, eesewankono'makon kupî sîrîrî mararî pra, Tiro cidaderî ponkon pemonkonyamî' esewankonoma'pî yentai. Moropai Sidom ponkon e'taruma'tî'pî yentai, amîrî'nîkon e'taruma'tî kupî sîrîrî. Maasa pra innape imaimu ku'sa'ya'nîkon pra awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amîrî'nîkon kanan Cafarnaum ponkon, ka' pona attîkon kai'ma eesenumenkakon. Tîîse ka' pona ayanu'nîpîkon Paapaya pepîn amakuyikon wenai. Tîîse Paapaya atî'kakon kupî sîrîrî. Maasa pra mîrîrî î' ikupî eserîkan pepîn apatakon ya' e'kupî'pî e'ku'sa' ya Sidom cidaderî po, moro tîîko'mansenon tî'ka'pî Paapaya pepîn e'painon sîrîrî tîpose —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Ayenku'tîuya'nîkon pepîn. Paapaya amîrî'nîkon taruma'tî kupî sîrîrî mararî pra, Sodoma ponkon taruma'tî tîuya yentai, pemonkonyamî' yenumî tîuya yai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mîrîrî yai Jesus epîrema'pî Paapa pî': —Paapa, tamî'nawîron yepotorî amîrî. Ka' konekatîpon amîrî, moropai non konekatîpon. Morî pe man tauya apî'. Maasa pra epu'nen pe awe'to' anenomî'pî yenposa'ya epu'nenan pepînya ayepu'to'pe. Epu'nen pe tîwe'sanonya epu'tî namai yenomî'pîya moropai pakko pe tîwe'sanon pia yenposa'ya epu'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Inna Paapa. Sîrîrî kupî'pîya itu'se awanî yawîrî ikupî'pîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Inî'rî ta'pî Jesusya: —Uyunya tamî'nawîron tîîsa' man uupia. Anî'ya uurî, Paapa munmu epu'tî pra man tîîse uyunya neken epu'tî. Moropai anî'ya uyun epu'tî pra man. Tîîse uurî, inmuya neken epu'tî. Moropai manni'kanya nîrî epu'tî, epu'tî to'ya yu'se uurî e'to'ya. Inkamoro pî' ekaremekîuya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Moropai ta'pîiya to' pî': —Asi'tî uupia tamî'nawîronkon amîrî'nîkon apî'kapî'san. Amîi'ne pe imakui'pî wanî ye'nen aapî'ka'sa'kon. Eturumakatî uupia moropai ipata'pî ya' eerî'ka'to'kon ton tîrîuya. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uurîya ayenupato'kon yapi'tî. Esenupatî uyeseru pî' maasa pra uurî eranmîra tîwe'sen mîîpan pepîn. Mîrîrî warantî eerî'ka'to'kon eporîya'nîkon uupia. ");
INSERT INTO mbcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maasa pra sa'me pra uyeseru wanî, ikupîkonpa. Moropai aapia'nîkon meruntî tîrîuya amîi'mîra awe'to'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tîîse tîîko'manse pu'kuru pra erî'ka'nîto' weiyu yai Jesusya mararon pepîn trigo ye'ka rukku'nîtî'pî iratai winîpai tiaron iratai pona tînenupa'san pokonpe si'ma. Mîrîrî yai emi'ne to' wanî'pî kure'ne. Mîrîrî ye'nen inkamoroya trigo pikka pia'tî'pî moropai mîrîrî yaku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mîrîrî kupî to'ya era'ma'pî fariseuyamî'ya. Inkamoroya ta'pî Jesus pî': —A'kî, anenupa'san esenyaka'man pî' man erî'ka'nîto' weiyu yai. Moisés nurî'tîya uyenupa'pîkon yawîrî pra, yairî pra to' wanî mîrîrî. Erî'ka'nîto' weiyu yai to' esenyaka'ma —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Inkamoro maimu yuuku'pî Jesusya. Ta'pîiya to' pî': —Awenpenatakon pra naatî, pena e'menuka'pî kaareta pî', î' kai'ma Davi nurî'tî pî' teeseurîmasen? Pena emi'ne awanî'pî moropai itonpayamî' nîrî wanî'pî emi'ne. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mîrîrî ye'nen mîîkîrî ewomî'pî Paapa yewî' ta. Moropai Paapa pia to' nîtîrî'pî trigo puusa' mo'ka'pîiya Moisésya yenupanto' yawîrî pra. Moropai tonpayamî' pia itîrî'pîiya. Mîrîrî yaku'pî to'ya. Teepîremasanon neken naku to' nîtîrî'pî yaku'pî to'ya. ˻Tîîse mîrîrî pî' Paapa ekore'masa' pra awanî'pî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moropai Moisés nurî'tî kaaretarîya taasa' erenkasa'ya'nîkon pra naatî? Erî'ka'nîto' weiyu yai teepîremasanon esenyaka'ma Paapa pia tîntîrîkon po'tî pî' epîremanto' yewî' ta. Mîîwîni tîîse Moisés nurî'tîya yenupanto' yawîrî pra to' wanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tauya sîrîrî apî'nîkon. Mîrîrî epîremanto' yewî' era'maya'nîkon manni' yentainon tarî man —ta'pî Jesusya. ˻Tîpî' eeseurîma'pî epîremanto' yewî' yentai tîwanî pî'.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—Paapa maimu e'menukasa' see warantî: “Uurî wanî sîrîrî itu'se morî pe e'sa'namanto'kon tiaronkon yarakkîrî anpo'tîkon pe antîrîkon yu'se wanî yentai,” ta'pî Paapaya. Mîrîrî epu'tîya'nîkon ya, î' taato'pe awanî, î' ku'nenan pî' aatako'menkakon pepîn e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maasa pra uurî ka' poi iipî'pî wanî erî'ka'nîto' weiyu yai, tamî'nawîronkon nîkupî ton ekareme'nen pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus epa'ka'pî miarî pai moropai attî'pî to' epere'to'kon yewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Miarî to' epere'to'kon yewî' ta tiwin warayo' wanî'pî pri'yawon pepîn itenya apîta'pî. Mîrîrî yai miarî manni'kan fariseuyamî' wanî'pî î' kupî Jesusya anepu'pai, teserukon yawîrî pra, “A'kî, yairî pra awanî,” taakonpa kai'ma. Mîrîrî ye'nen ekaranmapo'pî to'ya: —Morî pe awanî e'painon? Moisés nurî'tîya yenupanto' yawîrî pra pemonkon yepi'tîto'pe erî'ka'nîto' weiyu yai? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Inkamoro maimu yuuku'pî Jesusya. Ta'pîiya to' pî': —Amîrî'nîkon kore'ta tekîn kenan wanî ya, itekîn carneiro enasa' ya, itu'nakan ya' erî'ka'nîto' weiyu yai, itesa'ya kin imo'ka pepîn e'painon, erî'ka'nîto' weiyu pe awanî ye'nen? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—Moriya pemonkon wanî mîrîrî ipîkku pe, carneiro yentai. Mîrîrî ye'nen Moisés nurî'tîya yenupanto' yawîrî pemonkonyamî' pîika'tîto'pe awanî mîrîrî erî'ka'nîto' weiyu yai. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Moropai Jesusya ta'pî mîîkîrî warayo' pî': —Ayenya kainunkî —ta'pîiya. Moropai temekon kainumî'pîiya. Mîîkîrî esepi'tî'pî. Tiaron itenya ratai warantî, morî pe eena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tîîse mîrîrî tîpo fariseuyamî' epa'ka'pî to' epere'to'kon yewî' tapai. Moropai inkamoroya teserukon koneka'pî î' kai'ma Jesus wîî tîuya'nîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mîrîrî warantî taasa' to'ya yekare epu'tî tîuya pe, Jesus wîtî'pî miarîpai. Arinîkon pemonkonyamî' wîtî'pî ipîkîrî. Tamî'nawîronkon pri'yawonkon pepîn yepi'tî'pîiya miarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Moropai inkamoro pî' ta'pî Jesusya teesepi'tîsa'kon ekaremekî to'ya namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sîrîrî warantî awe'kupî'pî maasa pra awe'kupî pe man taasa' Paapa maimu ekareme'nen profeta Isaías nurî'tîya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ta'pî Paapaya: —Mîseni' upoitîrî wanî umenka'pî pe, unsa'nama pe. Kure'ne uurî atausinpasa' pu'kuru wanî ipî'. Mîîkîrî pia uyekaton tîrîuya. Moropai mîîkîrîya î' kai'ma Judeuyamî' pepîn pîika'tî kupî yekare ekaremekî, yairî to' e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mîîkîrî wanî teesiyu'pî'sen pe pra tiaron yarakkîrî, moropai tîwentaimepî'sen pe pra. Moropai e'ma tapî' mîîkîrî maimu eta pemonkonyamî'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Itarumai'san pemonkonyamî' wanî a'tu'mîra mana ye' yaki'tapapî'sa' warantî to' wanî. Tîîse iwaikî' tu'kaiya pepîn. Moropai apo' iparu e'tî'ka'pî ye'nen a'tu'mîra tîwe'sen yi'nîpîiya pepîn. Tîîse inkamoro yapîtanîpîiya pemonkonyamî' yenumî Paapaya pîkîrî. Mîrîrî yai yairî ku'nenan wanî imakui'pî ku'nenan yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mîrîrî yai Judeuyamî' pepînya innape ikupî pe man. Moropai mîîkîrî winî tîwe'pîika'tîto'kon nîmîkî pî' to' ko'mamî pe man, ta'pî Isaías nurî'tîya pena. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mîrîrî yai warayo' enkaru'nan moropai imaimu pîn yarî'pî to'ya Jesus pia. Maasa pra imariwa'ka' pe awanî'pî. Mîîkîrî yepi'tî'pî Jesusya moropai mîîkîrîya era'ma pia'tî'pî moropai eeseurîma'pî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mîrîrî kupî Jesusya era'masa' tîuya'nîkon pî', arinîkon pemonkonyamî' wanî'pî mararî pra teesewankono'mai. Moropai inkamoro esekaranmapo'pî. Ta'pî to'ya: —Pîika'tîton, Davi nurî'tî paarî'pî, Paapa nîmenka'pî manni' pepîn kin mîserî warayo'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mîrîrî taa to'ya eta tîuya'nîkon ye'nen, fariseuyamî'ya yuuku'pî: —Inkamoro ye'kakon imariwa'yamî' yenpa'kaiya, meruntîri ton tîîsa' imariwa'yamî' yepotorîya mîrîrî iipia Belzebuya, maasa pra makui mîîkîrî Belzebu —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tîîse î' kai'ma tîpî' to' esenumenkato' epu'tî'pî Jesusya. Moropai ta'pîiya: —A'kî, tiwinan pata ya' tîîko'mansenon wanî ya eseyaton pî', inkamoro eseya'nama. Moropai to' e'tî'ka tamî'nawîrî. Moropai tonpakon pokonpe tîmurukun pe tiwinan wîttî ta tîîko'mansenon wanî ya, inkamoro ko'mamî teesiyu'pîtîkon pî' morî ton pra. Moropai to' ekore'ma tu'ka. To' e'tî'ka tamî'nawîrî. Mîrîrî warantî meruntî ke to' wanî pepîn e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mîrîrî warantî makui ko'mamî ya, tîpemonkonoyamî' pokonpe teesiyu'pîtî pî'. Meruntî ke awanî pepîn tîpemonkonoyamî' pokonpe. Mîrîrî ye'nen Makuiya tîpoitîrîtonon yenpa'ka pepîn pemonkonyamî' yapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tîîse taaya'nîkon upî': “Belzebu meruntîri ke o'ma'kon yenpa'kaiya mîrîrî”, taaya'nîkon upî' —ta'pîiya. —Tîîse mîrîrî warantî awanî ya, anî'ya meruntî tîrî anenupa'sankon pia o'ma'kon yenpa'kato'pe to'ya? Inkamoroya taa e'painon apî'nîkon: “Esenku'tî'san pe awanîkon”, taa to'ya, ˻Maasa pra inkamoroya meruntî yapisî warantî yapisîuya nîrî —ta'pîiya.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Tîîse Paapa yekaton meruntîri ke o'ma'kon yenpa'kauya ya, Paapa ii'sa' man epu'tîya'nîkon ayesa'kon pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A'kî, tauya anî' ewomî pepîn e'painon, warayo' tîyurapai kenan tewî' era'manen pe tîwe'sen yewî' ta yama'runpai. Maasa pra meruntî ke awanî ye'nen. Tîîse e'mai' pe mîîkîrî yewa'tîpîtî yu'se wanî moropai î' rî itemanne yama'runpato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mîrîrî ye'nen ta'pî Jesusya: —Anî'ya innape ukupî pra awanî ya, uyeyaton pe awanî mîrîrî. Moropai anî' esenyaka'ma pra awanî ya uurî ton pe, uurî esenyaka'mato' taruma'tîiya mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Mîrîrî wenai tauya sîrîrî apî'nîkon. Î' rî imakui'pî warayo'kon nîkupî'pî mîrîrî kupî Paapaya tamî'nawîrî tîîwanmîra. Moropai imakui'pî pe Paapa winîkîi to' eseurîmato'kon, mîrîrî kupîiya tîîwanmîra. Tîîse anî' eseurîma ya Morî Yekaton Wannî winîkîi, Makui pe awanî mîrîrî kai'ma, imakui'pî pe mîrîrî kupî Paapaya pepîn tîîwanmîra. Tîîse aako'mamî ipatîkarî imakui'pî pe Paapa winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Moropai ta'pîiya: —Anî' eseurîma ya uurî ka' poi iipî'pî winîkîi imakui'pî pe, mîrîrî imakui'pî inkupî'pî kupî Paapaya tîîwanmîra. Tîîse anî' eseurîma ya Morî Yekaton Wannî winîkîi imakui'pî pe, mîrîrî kupî Paapaya pepîn tîîwanmîra sîrîrî pata po tîîse aako'mamî ipatîkarî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Moropai Jesusya ta'pî: —A'kî, amîrî'nîkon pî' tauya î' kai'ma yei, teperu tîînen wanî esepu'tî iteperu wenai. Morî pe iteperu wanî ya, eesepu'tî morî pe ite wanî. Moropai imakui'pî pe iteperu wanî ya, eesepu'tî imakui'pî pe ite wanî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amîrî'nîkon wanî imakui'pî pe îkîiyamî' munkîyamî' wanî imakui'pî pe warantî. Tîîse o'non ye'ka pe morî pe eeseurîmakon, imakui'pî pe si'ma? Maasa pra ayewankon tîwe'sen yawîrî eeseurîmakon. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tîîse warayo' morî pe tîwe'sen eseurîma morî pe, maasa pra morî pe itewan wanî ye'nen. Mîrîrî warantî nîrî warayo' imakui'pî pe tîwe'sen eseurîma imakui'pî pe, maasa pra imakui'pî pe itewan wanî ye'nen, —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Mîrîrî pî' tauya —ta'pî Jesusya. —Tiwin wei Paapaya tamî'nawîronkon yenumî yai î' ta'pî tîuya'nîkon ekareme'se to' e'mî'sa'ka kupî sîrîrî Paapa rawîrî. Mîrîrî tamî'nawîrî î' ta'pî tîuya'nîkon, se' tapairî ekareme'to'pe to'ya Paapa pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","—Maasa pra amaimu'pîkon wenai Paapaya taa kupî sîrîrî: “Imakui'pî pe naatîi. Ayenumîuya'nîkon sîrîrî”, taiya. Mîîwîni pra awanî ya, morî amaimu'pîkon wenai Paapaya taa kupî sîrîrî apî'nîkon: “Î' wani' pra man, morî pe naatîi”, taiya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mîrîrî yai tiaronkon Moisés nurî'tîya yenupato' pî' yenupatonkonya, moropai fariseuyamî'ya ta'pî Jesus pî': —Anna yenupanen, anna nera'maton anî' nîkupî eserîkan pepîn kupîya yu'se anna man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tîîse inkamoro maimu yuuku'pî Jesusya: —Î' warantî see sîrîrî pankon pemonkonyamî' wanî sîrîrî imakui'pî pe pu'kuru. Anera'makon ton esatîya'nîkon innape uurî kupîkonpa. Tîîse ikupîuya pepîn anera'makon ton. Tîîse penaron Paapa maimu ekareme'nen Jonas nurî'tî yekare neken epu'tîya'nîkon yu'se wai. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maasa pra Jonas ko'mamî'pî seurîwî'ne wei moropai seurîwî'ne ewaron kaisarî kure'nan moro' ro'ta ya'. Mîrîrî warantî nîrî uurî ka' poi iipî'pî ko'mamî kupî sîrîrî seurîwî'ne wei moropai seurîwî'ne ewaron kaisarî non ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A'kî, tiwinano'pî wei yai, Paapaya apo' ya' pemonkonyamî' yenumî yai Níniveponkon pemonkonyamî' nurî'tî e'mî'sa'ka pe man. Moropai inkamoroya taa kupî sîrîrî apî'nîkon: “Î' wani' awanî ye'nen amakuyikon rumakaya'nîkon pra awanîkon?” taa to'ya. “Maasa pra pena Jonasya itekare ekaremekî yai, umakuyikon rumaka'pî annaya,” taa to'ya. Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Uurî tarî awanî manni' akore'ta'nîkon, uurî wanî Jonas yentai, tîîse amakuyikon rumakaya'nîkon pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Inî'rî ta'pîiya: —Mîrîrî yai nîrî pata esa' pe tîwe'sen nurî'tî wîri' Sabá poinon e'mî'sa'ka kupî sîrîrî. Moropai mîîkîrîya taa kupî sîrîrî apî'nîkon: “Î' wani' awanî ye'nen innape ikupîya'nîkon pra awe'sa'kon”, taiya. Maasa pra mîîkîrî wîri' nurî'tî ii'pîtî'pî aminke pai epu'nen pe tîwe'sen Salomão nurî'tîya tenupato'pe kai'ma etai. Mîrîrî ye'nen tauya sîrîrî apî'nîkon. A'kî, uurî wanî akore'ta'nîkon manni' Salomão epu'nen pe si'pî yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus eseurîma'pî. Ta'pîiya: —Pemonkon yapai teepa'ka tîpo, o'ma' asarî ko'mannîpî tuna ton pîn yapî', teerî'ka'to' ton yuwa pî'. Tîîse eporî tîuya pra tîwanî ya, taiya: ");
INSERT INTO mbcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Kaane, enna'poi ya'ta yapai epa'ka ne'tîkini ya'rî” taiya. Moropai mîîkîrî enna'po. Mîîkîrîya yapai teepa'ka'pî eporî yawon pra tîîse, morî yeka'maiya pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Moropai mîîkîrî o'ma' wîtî iipiapai tiaronkon o'ma'kon etai tarakkîrî to' ko'manto'pe kai'ma. Mîîkîrîya tiaronkon o'ma'kon enepî asakî'ne mia' pona tîîmo'tai kaisarî. Inî' panpî' imakui'san enepîiya mîîkîrî warayo' ya' inkamoro ko'manto'pe. Inkamoroya mîîkîrî taruma'tî mararî pra. Pena e'mai' pe imakui'pî tîwanî'pî yentai mîîkîrî warayo' yeseru wanî. Maasa pra inkamoro wanî ye'nen itewan ya'. Mîrîrî warantî awanî pe man, imakui'pî sîrîrî pankon pemonkonyamî' yarakkîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mîrîrî yai Jesus eseurîma ko'mannîpî tanne pemonkonyamî' pî', isan moropai itonpayamî' ita'mi'san erepamî'pî. Inkamoroya poro po si'ma yanno me'po'pî yarakkîrî teeseurîmakonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tiaronya ta'pî ipî': —A'kî, asanya moropai ayakontononya ayanno pî' man, ayarakkîrî eseurîmapai to' wanî —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mîrîrî taiya yuuku'pî Jesusya: —Anî' ye'ka see pemonkon pî' maama' moropai mooyi tauya e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Moropai tînenupa'san winîkîi era'ma'pîiya, moropai ta'pîiya: —Tarî tiaronkon man uupia —ta'pîiya. —Insamoro pî' maama' moropai mooyi tauya e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uyun Paapa ka' pon yeseru ku'nenan pî' mooyi moropai ma'non moropai maama' tauya. Maasa pra Paapa maimu yawîrî tîwe'sanon wanî uyonpa pe pu'kuru —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mîrîrî weiyu yai Jesus wîtî'pî wîttî tapai Galiléia ku'pî yena pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Arinîkon pemonkonyamî' ii'sa' wanî'pî tîpatakon yapai. Inkamoroya mararî pra Jesus woima'tîsa' wanî'pî. Mîrîrî ye'nen Jesus asara'tî'pî kanau ya'. Mîîkîrî e'tukka'pî tuna ka. Moropai eereuta'pî. Moropai pemonkonyamî' e'nîmî'pî kasapan po. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mîîkîrîya to' yenupa pia'tî'pî tu'kan panton ke. Ta'pîiya: —Warayo' wîtî'pî tînmîri pînse. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tînmîri ya' tînpîmî pîmî'pîiya tîsorokai'ma. Moropai tiaron inpîmî'pî yonpa ena'pî e'ma ena po. Mîrîrî era'ma'pî toronyamî'ya moropai yenno'mapîtî'pî to'ya tamî'nawîrî, maasa aaro'ta pra tîîse —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Moropai tiaron inpîmî'pî yonpa ena'pî mararon non ya' tî' parappa pe tîwe'sen pona. Moropai ka'ne' pe aaro'ta'pî tîîse aakaratato' pata'se' ton pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mîrîrî inpîmî'pî yonpa aro'ta'pî tîîse a'ne' pe pu'kuru wei a'na'pî. Mîrîrîya ya'pi'tanîpî'pî maasa pra kure'nan ikara wîtîto' ton pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Moropai tiaron inpîmî'pî yonpa ena'pî mî'nî ye'kon kore'ta. Mîrîrî aro'ta'pî mî'nî ye' pokonpe. Mîrîrî mî'nî ye'ya itaruma'tî'pî teperu tîrîiya pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Moropai tiaron inpîmî'pî yonpa ena'pî morî pe tîwe'sen non pona. Mîrîrî aro'ta'pî, aarenta'pî moropai eepeta'pî. Tiaron epeta'pî 30 kaisarî moropai tiaron epeta'pî 60 kaisarî. Moropai tiaron epeta'pî 100 kaisarî. Sîrîrî warantî morî non pona ena'pî epeta'pî, mararî pra e'mai' pe awanî'pî yentai pu'kuru —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Moropai Jesusya ta'pî to' pî': —Anepu'pai awanîkon ya, etatî, epu'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mîrîrî pe rî Jesus nenupa'san erepamî'pî iipia. Inkamoroya ekaranmapo'pî. —Î' wani' awanî ye'nen pemonkonyamî' yenupaya mîrîrî panton pe —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesusya to' maimu yuuku'pî: —Paapa yekare anî' nepu'tî pepîn ekaremekîuya sîrîrî apî'nîkon. Î' kai'ma pemonkonyamî' esa' pe Paapa iipî ekaremekîuya sîrîrî epu'tîkonpa. Tîîse inkamoro Paapa yu'sankon pepîn pî' aronne ekaremekîuya pepîn. Tîîse panton pe neken ekaremekîuya epu'tî to'ya namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tîîse mararî Paapa maimu epu'tî anî'ya ya, inî' panpî' epu'nen tîrî Paapaya iipia. Moropai epu'tîiya itu'se tîwanî pîkîrî. Tîîse Paapa maimu yu'san pepîn awanî ya, tamî'nawîrî imo'ka Paapaya iipiapai. Mararî epu'tî tîuya kai'ma mîîkîrî esenumenka. Tîîse Paapaya imo'ka iipiapai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ta'pî Jesusya: —Mîrîrî ye'nen panton pe neken to' yenupapîtîuya. Maasa pra uyera'ma to'ya tîîse anî' pe wanî epu'tî to'ya pepîn. Moropai umaimu eta to'ya tîîse î' taasai'ya pe awanî epu'tî to'ya pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","—Mîrîrî ye'nen to' wanî Paapa maimuya taasa' yawîrî, penaro' Paapa maimu ekareme'nen profeta Isaías nurî'tî kaaretarîya taasa' yawîrî. Ta'pî Paapaya pena: “Etaya'nîkon apanakon ke tîîse î' aneta'pîkon epu'tîya'nîkon pepîn. Moropai era'maya'nîkon ayenukon ke. Tîîse î' anera'ma'pîkon epu'tîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maasa pra inkamoro pemonkonyamî' yewan ena'pî sa'man pe pu'kuru. Tu'ke î' eta to'ya tîpanakon ke. Tîîse epu'tî to'ya pepîn. Moropai tenukon yenpinnuku'pî to'ya, mîrîrî ye'nen î' era'ma to'ya pepîn. Tîîse eta to'ya ya, moropai era'ma to'ya ya, epu'tî to'ya e'painon. Mîrîrî wenai tîmakuyikon rumaka to'ya e'painon. Moropai inkamoro pîika'tîuya e'painon”, ta'pî Paapaya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Tîîse amîrî'nîkon wanî taatausinpai pu'kuru epu'tîya'nîkon ye'nen. Maasa pra era'maya'nîkon. Moropai etaya'nîkon ye'nen, epu'tîya'nîkon —ta'pîiya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","—Ayenku'tîuya'nîkon pepîn. Inna pî' pu'kuru tauya sîrîrî. î' anera'ma'pîkon uwinîpai, anera'mapai arinîkon penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'tî wanî'pî. Moropai yairî tîwe'sanon arinîkon pemonkonyamî' wanî'pî nîrî. Tîîse mîrîrî yai uyera'ma to'ya eserîke pra awanî'pî. Moropai î' aneta'pîkon uwinîpai anetapai nîrî to' wanî'pî. Tîîse eta to'ya eserîke pra to' wanî'pî nîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesusya ta'pî to' pî': —Maasa etatî. Î' taa mîserî warayo' tînmîri pînnen pantoniya ekaremekîuya sîrîrî apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Inpîmî yonpa enasa' e'ma ena pona warantî pemonkonyamî' wanî. Paapa maimu eta to'ya. Î' kai'ma Paapa iipî tesa'kon pe kupî yekare eta to'ya. Tîîse mîrîrî pîinama to'ya pra awanî. Mîrîrî ye'nen Makui iipî ka'ne' pe itekare to' neta'pî mo'kai. Mîîkîrîya to' neta'pî itekare mo'ka inî'rî ipî' to' esenumenka namai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Moropai tiaronkon pemonkonyamî' wanî tî' parappa pona ena'pî warantî. Itekare eta to'ya moropai inkamoroya yapisî mararî pra taatausinpai. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tîîse inkamoroya sa'me pu'kuru yapisî pepîn tewankon ya'. Tîîse Paapa maimu yapi'sa' to'ya wenai tiaronkonya tîmu'tunpakon ya, irumaka to'ya ka'ne' pe. Maasa pra ikara ton pra, yei wanî manni' warantî tî' parappa po to' apîtato' ton pra awanî. Mîrîrî wenai itekare etato' tîuya'nîkon rumaka to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Moropai tiaronkon wanî mî'nî ye'kana' ena'san warantî. Itekare eta to'ya. Mîrîrî pî' to' atausinpa. Tîîse tiaron pensa Paapa maimu yawîrî ikupî to'ya pepîn. Maasa pra kure'ne inkamoro esenumenka tarîron non yeseru pî'. Moropai inkamoroya teesenku'tîi kure'ne temannekon yapurî Paapa yapurî tîuya'nîkon yentai. Mîrîrî ye'nen inkamoro arenta pepîn Paapa munkîyamî' pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Moropai tiaronkon wanî morî non pona ena'san warantî. Inkamoroya Paapa maimu eta to'ya moropai epu'tî to'ya. Î' kai'ma inpîmî epeta'pî warantî eepeta'pî. Mararî panpî' eepeta'pî warantî tiaronkonya Paapa maimu kupî mararî. Kure'ne panpî' eepeta'pî warantî tiaronkonya Paapa maimu kupî kure'ne panpî'. Moropai tiaron epeta'pî mararî pra warantî tiaronkonya innape Paapa maimu kupî mararî pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusya inî'rî panton ekaremekî'pî. Î' kai'ma tamî'nawîronkon esa' pe Paapa ii'to' wanî ekaremekî'pîiya. Ta'pîiya: —See warantî awanî, warayo'ya tekkari yena'pî pîmî'pî ipapoi'ma tînmîri ya. Moropai ipîmî tîpo eemikku'pî tewî' ta. Moropai iwe'na'pî ewaron ya' teseru ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tîîse tamî'nawîronkon wetun tanne, iteyaton wîtî'pî inmîri ya'. Mîîkîrîya inpîmî'pî trigo ye' kore'ta kansipu'kurai ena'pî pîmî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Inpîmî'pî arenta'pî moropai eepeta winîkîi kansipu'kurai ye' nîrî arenta'pî ipokonpe. Ikore'ta awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mîrîrî ye'nen umî esa' poitîrîtonon wîtî'pî iipia. Moropai ta'pî to'ya ipî': “Anna karaiwarî, amîrîya morî pîmî'pîya innape nai?” ta'pî to'ya ipî'. Inkamoro maimu yuuku'pî to' karaiwarîya. “Inna morî pîmî'pîuya”, ta'pîiya. “Tîîse o'non pata pai kin kansipu'kurai erepansa' mîrîrî ikore'ta?” ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Moropai to' maimu yuuku'pî warayo' umî esa'ya. “Uyeyatonya mîrîrî ku'sa'” ta'pîiya. Moropai ipoitîrîtononya ta'pî ipî': “Mîrîrî kansipu'kurai yaroka annaya yu'se nan?” ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Kaane kîsarokatî maasa” ta'pîiya. “Maasa pra yarokaya'nîkon ya trigo ye' yarokaya'nîkon nîrî ipokonpe” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Tîwî narentai tîmurukun pe. Trigo ya'tîto' weiyu eseposa' yai, tauya ya'tînenan pî'. E'mai' pe kansipu'kurai ya'tîtî moropai mîrîrî yaironpî'tî apo' ya' aaranto'pe. Tîîse trigo konekatî uyewî' ta aako'manto'pe tauya to' pî'”, ta'pî warayo'ya —ta'pî Jesusya. —Mîrîrî warantî awanî, tamî'nawîronkon esa' pe Paapa iipî yai. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Moropai tiaron panton ekaremekî'pî Jesusya tînenupa'san pî'. Ta'pîiya: —Î' kai'ma tamî'nawîronkon esa' pe Paapa ii'to' wanî ekaremekîuya sîrîrî. Awanî see warantî: Warayo'ya tînpîmî mostarda ena'pî pîmî'pî tînmîri ya' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","—A'kî, mîrîrî inpîmî mostarda ena'pî wanî si'mîrikkî pe pu'kuru. Tiaronkon umî ya' tîpînsenkon yena'pî ma're awanî. Tîîse aarenta yai, kure'ne aarenta tiaronkon yentai. Mîrîrî ena kure'ne yei pe. Mîrîrî ye'nen tu'ke toronyamî' erepamî ipona. Inkamoroya taponse'kon ton konekapîtî ipanta pona —ta'pî Jesusya. —Mîrîrî warantî awanî, tamî'nawîronkon esa' pe Paapa iipî yai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tiaron panton ekaremekî'pî Jesusya î' kai'ma tamî'nawîronkon esa' pe Paapa iipî ekaremekîpa kai'ma. Ta'pîiya: —See warantî awanî. Wîri'ya kîsere'na kore'ta fermento tîrî'pî moropai mîrîrî yai'me'pîiya. Mîrîrî ye'nen tamî'nawîrî kîsere'na sa'mo'pî fermentoya —ta'pî Jesusya. —Mîrîrî warantî awanî, tamî'nawîronkon esa' pe Paapa iipî yai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tamî'nawîrî mîrîrî ekaremekî'pî Jesusya panton pe. Î' rî ekaremekîiya pra awanî'pî panton pe pra. Tîîse panton pe neken to' yeurîma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mîrîrî warantî awe'kupî'pî maasa pra penaro' Paapa maimu ekareme'nen profeta nurî'tîya taasa' yawîrî awe'ku'to'pe. Pena ta'pî profeta nurî'tîya: Paapa maimu ekaremekîuya panton pe. Pena sîrîrî pata koneka'pî tîuya pata pai anî' nepu'tî'pî pepîn ekaremekîuya kupî sîrîrî ta'pî profeta nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mîrîrî tîpo arinîkon pemonkonyamî' nîmî'pî Jesusya. Moropai attî'pî wîttî ta. Miarî tîîse inenupa'san erepamî'pî iipia. Inkamoroya ta'pî ipî': —Î' taato'pe mîrîrî kansipu'kurai pantoni wanî ekareme'kî anna pî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesusya to' maimu yuuku'pî: —Uurî ka' poi iipî'pî wanî tînpîmî morî pînnen pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Mîrîrî umî wanî tamî'nawîrî pata pe sîrîrî non po. Inpîmî wanî Paapa pemonkonoyamî' pe, manni'kan tesa'kon pe awe'to'pe Paapa pia eturumaka'san pe. Tîîse kansipu'kurai wanî Makui pemonkonoyamî' pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","—Moropai kansipu'kurai pînnen wanî Makui pe. Trigo ya'tîto' weiyu tauya manni' wanî tamî'nawîron ataretî'kasa' pe. Inkamoro ya'tînenan wanî inserîyamî' pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","—Umî esa' poitîrîtononya kansipu'kurai ya'tî'pî moropai apo' ya' yenumî'pî to'ya aaranto'pe. Mîrîrî warantî ikupî inserîyamî'ya kupî sîrîrî tiwinano'pî weiyu yai tamî'nawîron ataretî'kasa' yai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Mîrîrî weiyu yai uurî, ka' poi iipî'pîya inserîyamî' yarima upemonkonoyamî' kore'ta. Tiaronkonya imakui'pî kupî emapu'tînenan menka to'ya. Moropai pemonkonyamî' imakui'pî ku'nenan menka inserîyamî'ya tamî'nawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","—Moropai inkamoro imakui'pî ku'nenan pemonkonyamî' yenumî inserîyamî'ya apo' kure'nan ya'. Miarî apo' ya' si'ma to' karau mararî pra teekon tîpa'tîi ne'ne' pe apo' wanî ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—Tîîse manni'kan yaironkon Paapa maimu yawîrî si'san wanî kupî sîrîrî ipîkku pe, Paapa, to' yunkon pata ya'. Ipîkku pe weiya tamî'nawîron weiyu'ma warantî to' wanî kupî sîrîrî —ta'pîiya. —Umaimu anepu'pai awanîkon ya, mîrîrî epu'tîya'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tiaron panton ekaremekî'pî Jesusya. Ta'pîiya: —Î' kai'ma tamî'nawîronkon esa' pe Paapa ii'to' wanî see warantî: Pena epe'ke tîwe'sen yenonsa' eporî'pî warayo'ya umî ya'. Mîrîrî eposa' tîuya ya, inî'rî yenomî'pîiya. Moropai taatausinpai attî'pî. Tamî'nawîron temanne ke awe'repa'pî. Moropai mîrîrî yepe'pî ke manni' umî, o'non pata epe'ke tîwe'sen yenomî tîuya ya, mîrîrî yenna'pîiya —ta'pî Jesusya. Moropai ta'pîiya: —Mîrîrî warantî awanî, tamî'nawîronkon esa' pe Paapa ii'to' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Moropai tiaron panton ekaremekîuya sîrîrî, î' kai'ma tamî'nawîronkon esa' pe Paapa iipî epu'tîkonpa —ta'pî Jesusya. —Awanî see warantî: Warayo' wanî'pî diamante yennanen. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kure'nan diamante, epe'ke eposa' tîuya ya, tamî'nawîrî temanne ke mîîkîrî e'repa'pî, mîrîrî yepe'pîkon ke kure'nan diamante epe'ke pu'kuru eposa' tîuya yennapa —ta'pî Jesusya. —Mîrîrî warantî awanî, tamî'nawîronkon esa' pe Paapa iipî ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesusya ta'pî: —Inî'rî tiaron panton ekaremekîuya sîrîrî, î' kai'ma pemonkonyamî' esa' pe Paapa iipî epu'tîkonpa. See warantî awanî: Moro'yamî' atawî'to'pe iku'sa' yenumî'pî warayo'konya iku'pî ka. Inkamoroya moro'yamî' yapisî'pî tu'ke si'ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","—Mîrîrî moro'yamî' yapi'to' ya' moro'yamî' atapi'sa' yai tu'ke intapîkîrî. Mîrîrî woroka warayo'konya a'mun pona. Mîrîrî yai warayo'kon ereuta moro'yamî' era'mai. Moropai inkamoroya morîkon moro'yamî' menka. To' yense' ya' to' yara'tî to'ya. Tîîse tiaronkon moro'yamî' morîkon pepîn inkamoro papo to'ya poro pona —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","—Mîrîrî warantî awanî pe man, tiwin wei tamî'nawîron ataretî'ka ya. Mîrîrî yai moro'yamî' yapi'nenan warayo'kon warantî ikupî inserîyamî'ya kupî sîrîrî. Inkamoro wîtî imakui'pî ku'nenan pemonkonyamî' menkai yairî tîwe'sanon kore'tapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Moropai inkamoro tîmenka'sankon yenumî inserîyamî'ya kure'nan apo' ya'. Miarî inkamoro imakui'pî ku'nenan karau ko'mannîpî mararî pra teekon tîpa'tîi ne'ne' pe tîwanîkon ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesusya tînenupa'san ekaranmapo'pî: —Tamî'nawîrî umaimu epu'tî pî' naatî, mîrîrî tauya manni'? —ta'pî Jesusya tînenupa'san pî'. —Inna, epu'tî pî' anna man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mîrîrî yai ta'pî Jesusya to' pî': —Moisés nurî'tîya yenupanto' pî' esenupa'san esenupa ya, uyesa'kon pe Paapa iipî kupî yekare pî' esenupa'san, inkamoro wanî unekaremekî pî' esenupa'san wanî wîttî esa' pe tîwe'sen warantî. Maasa pra mîîkîrîya miarî pai temannekon amenan pe tîwe'sen mo'ka. Moropai amenan pe pra tîwe'sen mo'kaiya nîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Moropai mîrîrî pantonkon ekaremekî tîpo, Jesus epa'ka'pî moropai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mîrîrî yai Jesus enna'po'pî tarenta'pî pata pona. Miarî pemonkonyamî' yenupa'pî Jesusya to' epere'to'kon yewî' ta. Moropai arinîkon imaimu etanenan esenumenka'pî kure'ne teesewankono'mai. Inkamoro esekaranmapopîtî'pî. Ta'pî inkamoroya: —O'non pata epu'nen pe tîwanîpa Jesus esenupa'pî mîrîrî ye'ka anî' nîkupî eserîkan pepîn ku'to'peiya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—Maasa pra mîîkîrî Jesus wanî pepîn kin manni' wîttî konekanen munmu pe? Maria more pepîn kin mîîkîrî Jesus? Moropai Tiago, José, Simão, Judas ruinankon pepîn mîîkîrî? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","—Moropai iwîrisitonon tarî to' man tîîse î' kai'ma tamî'nawîrî ikupî mîîkîrî Jesusya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mîrîrî wenai Jesus maimu anetapai pra miarîronkon pemonkonyamî' wanî'pî. Tîîse ta'pî Jesusya to' pî': —Morî pe pu'kuru tamî'nawîronkonya Paapa maimu ekareme'nen eseurîma eta. Tîîse tonpayamî' ipata yawonkon neken wanî imaimu anetapai pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mîrîrî yai Jesusya tu'ke anî' nîkupî eserîkan pepîn kupî eserîke pra awanî'pî miarî Nazaré po. Maasa pra innape ikupî miarîronkon pemonkonyamî'ya pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mîrîrî yai Galiléia pata esa' pe Herodes wanî'pî. Mîîkîrîya tamî'nawîrî î' kupî Jesusya yekare eta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Moropai mîîkîrîya ta'pî tîpemonkonoyamî' teesenyaka'masanon pî': —Seru' pepîn see João Batista nurî'tî mîîkîrî. Awe'mî'sa'kasa' mîrîrî. Mîrîrî wenai mîîkîrîya anî' nîkupî eserîkan pepîn ku'pîtî mîrîrî meruntî ke —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mîrîrî ta'pî mîîkîrî pata esa' Herodesya maasa pra João yarakkamo me'posa' tîuya ye'nen atarakkannîto' ta. Mîrîrî kupî'pî Herodesya, maasa pra takon Filipe no'pî Herodias yarakkîrî awanî pî' João eseurîmasa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tu'ke ite'ka João Batistaya taapîtî'pî pata esa' Herodes pî': —Paapa nekaremekî'pî unkupîkon ton pe yairî pra, imakui'pî ku'sa'ya mîrîrî, ayakon no'pî Herodias yarakkîrî tîwe'se —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mîrîrî wenai pata esa' Herodes ekore'ma'pî. João Batista anwîpai awanî'pî. Tîîse eranne' pe awanî'pî Judeuyamî' pî'. Maasa pra Paapa maimu ekareme'nen pe awanî kai'ma to' esenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tîîse pata esa' Herodesya teesenpo'pî weiyu yai, entamo'kanto' mararon pepîn koneka'pî. Moropai pemonkonyamî' eta'pîiya mararî pra entamo'kai to' wîtîto'pe. Mîrîrî yai Herodias more, maasaron wîri' aurîno'pî mananu'pî, tamî'nawîronkonya tera'ma tanne. Mîîkîrî mana'to' pî' pata esa' Herodes atausinpa'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mîrîrî ye'nen ta'pîiya mîîkîrî maasaron wîri' pî': —Seru' pe pra tauya sîrîrî apî'. Upî' î' rî itu'se awe'to' esatîya ya, tamî'nawîrî itîrîuya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Moropai wîri' wîtî'pî tîsan Herodias pia. Ekaremekî'pîiya. Moropai ta'pî isanya João pu'pai mesatîi. Ta'pî tîsanya yawîrî esatî'pîiya. —João Batista pu'pai'pî yu'se wai sunpa po —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mîrîrî taiya ye'nen, pata esa' Herodes ena'pî yairî ma're. Tîîse tamî'nawîronkon tîneta'sanya eta tanne, î' itu'se awe'to' esatîya ya itîrîuya, taasa' tîuya ye'nen, maasaron wîri' nesatî tîrî tîuya ta'pîiya, seru' pe tîwanî namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mîrîrî ye'nen João Batista pu'paraikkîtî me'po'pîiya atarakkannîto' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mîîkîrî pu'pai'pî enepî'pî to'ya sunpa po. Mîrîrî tîrî'pî to'ya maasaron aurîno'pî wîri' pia. Moropai mîîkîrîya tîsan pia yarî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mîrîrî yekare etasa' tîuya'nîkon pe João Batista nurî'tî nenupa'san iipî'pî iipia itesa'rî'pî era'mai. Moropai mîîkîrî yu'na'tî'pî to'ya. Moropai mîrîrî ekareme'se to' wîtî'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tamî'nawîron mîrîrî e'ku'sa' yekare etasa' tîuya tîpo, Jesus moropai inenupa'san wîtî'pî kanau ya' miarîpai keren pona tuutîpa tiwinsarî. Tîîse o'non pata awanî epu'tî'pî arinîkonya. Mîrîrî ye'nen to' epa'ka'pî tîîko'manto'kon yapai. Moropai to' wîtî'pî a'mun poro Jesus epose. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Moropai miarî Jesusya to' yeporî'pî. To' erepansa' wanî'pî irawîrî, kanau yapai tawautî pe. Jesusya kure'ne to' era'ma'pî tî'noko'pî pe, inkamoro itî'san. Mîrîrî ye'nen pri'yawonkon pepîn sa'ne yepi'tî'pîiya, miarî tîwe'sanon. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pata ko'mamî tanne, Jesus nenupa'san erepamî'pî iipia. Moropai inkamoroya ta'pî ipî': —Insamoro arinîkon pemonkonyamî' wîtîto'pe ka'kî wîttîkon ta. Maasa pra ko'mamîiya pata enasa' man, î' ton pra e'nî tanne tarî keren po. To' wîtîsa' ya, morî pe awanî tekkarikon ton yennato'pe to'ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tîîse Jesusya to' maimu yuuku'pî: —Insamoro pemonkonyamî' wîtî e'pai pra man —ta'pîiya. —Tîîse amîrî'nîkonya to' yekkari'tî e'pai man —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tîîse inkamoroya yuuku'pî. Ta'pî to'ya: —Î' kai'ma see, anna pia mia'taikin neken pão man. Moropai asakî'ne neken moro'yamî' man —ta'pî to'ya. —Tamî'nawîronkon pia itîrîiya pepîn —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Ene'tî moriya uupia —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Moropai pemonkonyamî' ereutato'pe parî' pona ta'pîiya to' pî'. Moropai mîîkîrîya mia'taikinan pão yapisî'pî moropai asakî'nankon moro'yamî'. Moropai tenu yanumî'pîiya ka' ekaya. Moropai eepîrema'pî yekkari wanî pona. —Morî pe pu'kuru man Paapa —ta'pîiya. Mîrîrî tîpo pão pirikkapîtî'pîiya. Mîrîrî tîrî'pîiya tînenupa'sanya itîîto'pe pemonkonyamî' pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mîrîrî pî' tamî'nawîronkon esekkari'tî'pî itu'se tîwanîkon pîkîrî. Moropai inkamoro yekkari yonparî'pî yannuku'pî Jesus nenupa'sanya asakî'ne pu' pona tîîmo'tai waikara'pî kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inkamoro pemonkonyamî' esekkari'tî'san wanî'pî 5.000 yairî warayo'kon, wîri'sanyamî' moropai moreyamî' tîku'ne'tîi pra to' tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mîrîrî tîpo Jesusya tînenupa'san pî' ta'pî kanau ya' to' asara'tîto'pe. Moropai to' wîtîto'pe tîrawîrî iku'pî ratai pona. To' wîtî tanne Jesusya arinîkon yaipontî'pî to' emi'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pemonkonyamî' emi'to'pe to' yaipontî tîpo Jesus enuku'pî wî' pona epîremai tiwinsarî. Miarî tîîse pata ewaronpamî'pî tiwinsarî tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mîrîrî tanne, inenupa'san wanî'pî iku'pî arakkita kanau ya'. Miarî to' tîîse a'situn pe eena'pî. Mararî pra sipa sipa pe awanî'pî. Kanau pona eerepamî'pî meruntî ke. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Anoinna pata tîîse, maasa erenmapî rawîrî, tuna poro Jesus asarî era'ma'pî inenupa'sanya tîponaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tuna poro mîîkîrî asarî era'ma tîuya'nîkon pe, inenupa'san wanî'pî mararî pra teesi'nî'se. Inkamoroya ta'pî: —Katonpî mîîkîrî! To' entaime'pî teesi'nî'se mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Inkamoro pî' Jesus e'pamî'pî ka'ne' pe. Ta'pîiya to' pî': —Meruntî ke e'tî, eranne' pe pra. Uurî mîîkîrî, Jesus —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Moropai Pedroya ta'pî ipî': —Uyepotorî, amîrî pe pu'kuru awanî ya, o'non pata awanî manni' pata uutîto'pe ka'kî tuna poro —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Asi'kî see —ta'pî Jesusya Pedro pî'. Moropai Pedro autî'pî kanau yapai moropai mîîkîrî asarî'pî tuna poro Jesus ekaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mîîkîrî asarî tanne, a'situnya ipuma'pî. Mîrîrî ye'nen eranne' pe eena pia'tî'pî. Moropai eeseuronka pia'tî'pî. Mîrîrî ye'nen teesi'nîpî pe awentaime'pî Jesus pî'. —Uyepotorî, upîika'tîkî! —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka'ne' pe Jesusya tenya kainumî'pî Pedro yapisîpa moropai ta'pîiya Pedro pî': —Innape ukupîya pra awanî mîrîrî. Î' wani' awanî ye'nen innape uurî kupîya pepîn? ");
INSERT INTO mbcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mîrîrî tîpo inkamoro asara'tî'pî kanau ya'. Moropai kure'nan a'situn atî'napannîpî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Moropai inenupa'sanya Jesus yapurî'pî. Yapurî ye'ka pe inkamoroya ta'pî: —Innape see, Paapa munmu pe amîrî wanî sîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iku'pî ratai pona teerepansa'kon pe, inkamoro autî'pî. Genesaré pata pona to' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Miarî mîrîrî pata po, mororonkon pemonkonyamî'ya Jesus epu'tî'pî. Moropai inkamoroya pri'yawonkon pepîn, tamî'nawîrî mororonkon moropai tîwoi'nîkon tîîko'mansenon ene'to'pe to'ya to' yepi'tîto'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Moropai pri'yawonkon pepînya Jesus pon ye'pi pî' yapîto'pe to'ya esatî'pî to'ya. Maasa pra ipon ye'pi pî' yapîtîponkon esepi'tîsa' wanî'pî mîîto'pe. Mîrîrî warantî to' esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mîrîrî yai fariseuyamî' moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon wîtîsa' wanî'pî Jerusalém poi Jesus yarakkîrî eseurîmai. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Inkamoroya ta'pî Jesus pî': —Î' wani' awanî ye'nen kin anenupa'san wanî pepîn utamokonya uyenupa'pîkon yawîrî pra to' wanî? Tenyakon rona to'ya pepîn tekkarikon yonpa tîuya'nîkon rawîrî. Mîrîrî yawîrî kupî to'ya pra awanî ye'nen upanama'pîkon utamokonya yawîrî pra to' wanî mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesusya to' maimu yuuku'pî. Moropai ta'pîiya to' pî': —Î' wani' kin awanî ye'nen Paapa maimuya taasa' yawîrî ikupîya'nîkon pra, atamokonya ayenupa'pîkon yawîrî ikupî pî' aako'mamîkon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—Maasa pra Paapaya ta'pî ankupîkon ton pî'. “Ayunkon yapurîtî moropai asankon yapurîtî”, ta'pîiya. Moropai ta'pîiya nîrî: “Anî' eseurîma ya imakui'pî pe tun winîkîi moropai tîsan winîkîi, mîîkîrî wîî e'pai awanî”, ta'pî Paapaya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—Tîîse tiaronkon yenupaya'nîkon yairî pra. Amîrî'nîkonya taa to' pî'. Tiaron moro awanî tîyun anpîika'tîpainon tîîse taaya'nîkon: “ ‘Kaane, untîrî ton pra man uyun pia ipîika'tîto' ton, maasa pra Paapa pia untîrî pe seeni' mo'kasau'ya sîrîrî’ taato'pe to'ya”, taaya'nîkon seru' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Moriya mîrîrî warantî taaya'nîkon ya, ayunkon yapurîya'nîkon pepîn mîrîrî. Mîrîrî warantî Paapa maimu yu'se pra awanîkon esera'ma mîrîrî, ayeserukon neken yawîrî ikupîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Seru'ye'kon teesenku'tîsanon tîîwarîrî'nîkon. Apî'nîkon penaro' Paapa maimu ekareme'nen profeta Isaías nurî'tî eseurîma'pî yairî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Morî pe eseurîmakoi'kon insanan pemonkonyamî' upî'” taa Paapaya. “Tîîse to' yewan wanî aminke upî'” taiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Mîrîrî ye'nen uyapurîto' to'ya wanî î' pe pra rî. Penaronkonya tîpanama'pîkon yawîrî tonpakon yenupa to'ya, uurîya tîpanama'pîkon pe tîku'se” ta'pî Paapaya, ta'pî profeta Isaías nurî'tîya —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mîrîrî taa tîpo Jesusya arinîkon yanno'pî moropai ta'pîiya to' pî': —Maasa umaimu etatî moropai epu'tîya'nîkon yuwatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Imakui'pî pe e'nî pepîn uya're'kon unenapîkon wenai. Tîîse imakui'pî pe e'nî imakui'pî pe eseurîma wenai, imakui'pî pî' esenumenkan wenai. Mîrîrîya imakui'pî pe ukupîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mîrîrî taasai'ya tîpo, Jesus nenupa'san wîtî'pî iipia. Moropai inkamoroya ta'pî ipî': —Uyepotorî, î' taaya manni' pî' fariseuyamî' atasi'sirunpasa' man amaimu pî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesusya ta'pî: —Tamî'nawîronkon tînpîmî'pî pepîn aro'tasa' yaroka umî esa'ya. Mîrîrî warantî tamî'nawîronkon Paapa pemonkono pe pra tîwe'sanon mo'kaiya tîpemonkonoyamî' kore'tapai —kai'ma to' maimu yuuku'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","—Inkamoro ye'kakon tîpîinamai pra e'tî. Maasa pra to' wanî enkaru'nankon warantî. Mîrîrî ye'nen tiaronkon yenupa to'ya eserîke pra to' wanî. Enkaru'ne si'ma enkaru'nanya tiaron yarî eserîke pra awanî. Yarî yu'se tîwanî ya to' e'soroka itu'nakan ya' sa'nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mîrîrî taiya ye'nen, Pedroya Jesus pî' esatî'pî. —Mîrîrî panton ekareme'kî anna pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusya ta'pî: —Sîrîrî tîpose pakko pe aako'mamîkon mîrîrî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","—A'kî, uya're'kon unenno'makonya imakui'pî pe ukupîkon pepîn. Maasa pra uyewankon ya' eewomî pepîn, uro'takon ya' neken yenno'ma moropai yenpa'ka. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tîîse eseurîmanto' wanî uyewankon yapai teepa'kasen esenumenkanto' wenai. Mîrîrîya ukî'pakon imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maasa pra uyewankon ya' tîîko'mansen imakui'pî wenai esenumenkan imakui'pî pe, pemonkon anwîpai e'nî, moropai tiaron no'pî yarakkîrî e'nî, moropai se' tapairî wîri'sanyamî' yarakkîrî e'nî. Moropai ama' pe e'nî, moropai seru'ye' pe e'nî, imakui'pî pe eseurîman tiaronkon winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sîrîrîkon imakui'pî uyewankon ya' tîîko'mansen wenai, imakui'pî kupî pî' ko'mannî. Mîrîrî tîîse uyenyakon tîronai pra uya're'kon yonpasa' wenai, imakui'pî pe e'nî pepîn —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mîrîrî pata yapai Jesus ese'ma'tî'pî. Attî'pî Tiro pata poro aminke pra cidade pî'. Moropai Sidom pata poro attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Miarî wîri' wanî'pî Cananeu pon, Judeupa' pepîn. Jesus erepansa' tanne, mîîkîrî iipî'pî iipia. Moropai ta'pîiya tîwentaimepîtî ye'ka pe: —Uyepotorî, amîrî wanî Davi nurî'tî paarî'pî pe. Pîika'tîton amîrî. A'noko'pî pe sa'ne uyera'makî. O'ma' ewonsa' man unre wîri' ya'. Mîîkîrîya tone' ikupî pî' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tîîse Jesusya imaimu yuuku pra awanî'pî. Mîrîrî tanne, inenupa'san erepamî'pî iipia aminke pra. Moropai inkamoroya ta'pî: —Mîîkîrî wîri' wîtîto'pe ka'kî, uwenairî'nîkon aaipî ko'mannîpî mîrîrî taa enepîiya. Moropai awentaimepîtî ko'mannîpî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesusya yuuku'pî: —Paapaya uyarimasa' man upemonkonoyamî' neken pîika'tîto'peuya, Judeuyamî' ataka'ma'san, carneiro wanî itesa' pra warantî tîwe'sanon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tîîse mîîkîrî wîri' iipî'pî Jesus rawîrî moropai awe'sekunka'pî moropai mîîkîrîya ta'pî: —Uyepotorî, upîika'tîkî sa'ne —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—A'kî —ta'pî Jesusya ipî'. —More ya're' tîrî ya arinmaraka pia, morî pe pra awanî. Mîrîrî warantî awanî apîika'tî tîuya ya, Judeupa' pe pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tîîse wîri'ya ta'pî Jesus pî': —Innape man, Uyepotorî. Mîrîrî ye'ka pe tîîse tesa'kon ya're' ya'punu'pî e'soroka enapî arinmarakayamî'ya itaponse' yo'koi si'ma. Mîrîrî ye'nen mararî mîrikkî itîîkî uupia. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesusya ta'pî ipî': —Mîrîrî taaya ye'nen, innape ukupîya epu'tî pî' wai, ma'non —ta'pî Jesusya. —Mîrîrî ye'nen î' taaya manni' mîrîrî kupîuya. Moropai mîrîrî taa Jesusya pe mîîkîrî wîri' more o'ma' yarakkîron esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Miarî pai Jesus ese'ma'tî'pî moropai attî'pî Galiléia ku'pî rî pîkîrî. Moropai mîîkîrî enuku'pî wî' pona moropai eereuta'pî miarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miarî nîrî arinîkon pemonkonyamî'ya pri'yawonkon pepîn yarî'pî. Asakoi'kon pepîn, moropai ma'tîkî' pankon, moropai enkaru'nankon, moropai imaimu pînon moropai tu'kan paran pî' tîwe'sanon yarî'pî to'ya Jesus pia to' yepi'tîto'peiya kai'ma. Moropai inkamoro yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mîrîrî kupî Jesusya era'ma tîuya'nîkon pî' pemonkonyamî' esenumenka'pî mararî pra teesewankono'mai, maasa pra imaimu pîn eseurîma ye'nen, moropai ma'tîkî' pankon esepi'tîsa' ye'nen, moropai asakoi'kon pepîn asarî ye'nen, moropai enkaru'nankonya era'ma ye'nen. Mîrîrî pî' Judeuyamî' yepotorî Paapa yapurî'pî to'ya mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesusya tînenupa'san yanno'pî tîîpia to' yeurîmapa kai'ma moropai ta'pîiya: —Eseurîwî'ne wei kaisarî insanan pemonkonyamî' ko'mansa' man uupia. U'noko'pî pe to' era'ma pî' wai to' ya're' ton pra tîîse —ta'pîiya. —To' anaipontîpai pra wai tekkarikon yonpa to'ya pra to' tîîse. Maasa pra yai to' wîtî eserîke wanî e'ma taawîrî emi'ne tîwanîkon pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Inenupa'sanya Jesus ekaranmapo'pî: —O'non ye'ka pe insanan mararonkon pepîn pemonkonyamî' yekkari ton eporî e'painon tarî keren po si'ma? Î' ton pîn ya' e'nî tanne —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Inkamoro ekaranmapo'pî Jesusya: —Î' warapo kaisarî trigo puusa' nai? —ta'pîiya. —Asakî'ne mia' pona tîîmo'tai kaisarî moropai moro'yamî' mîrikkî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Moropai tamî'nawîronkon pî' ta'pî Jesusya: —Non pona ereutatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Moropai Jesusya asakî'ne mia' pona tîîmo'tai kaisaron trigo puusa' yapisî'pî, moropai moro'yamî' nîrî. Mîrîrî tîpo eepîrema'pî Paapa pî'. —Morî pu'kuru amîrî, anna ya're' ton tîînen —ta'pîiya Paapa pî'. Mîrîrî tîpo trigo puusa' pirikkapîtî'pîiya. Mîrîrî tîrî'pîiya tînenupa'san pia itîîto'pe to'ya pemonkonyamî' pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mîrîrî pî' tamî'nawîronkon entamo'ka'pî teesepi'tîkon pîkîrî. Mîrîrî yonparî'pî yannuku'pî inenupa'sanya asakî'ne mia' pona tîîmo'tai kaisarî waikara'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Inkamoro Jesus nekkari'tî'san wanî'pî warayo'kon 4.000 kaisarî wîri'sanyamî' tîku'netîi pra moropai moreyamî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mîrîrî tîpo Jesusya pemonkonyamî' yaipontî'pî to' wîtîto'pe. Moropai Jesus asara'tî'pî kanau ya', moropai attî'pî Magadã pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jesus yarakkîrî eseurîmai tiaronkon fariseuyamî' moropai tiaronkon saduceuyamî' wîtî'pî iipia. Jesus anaka'mapai to' wanî'pî mîîto'pe. Paapa winîpaino pe mîîkîrî wanî pepîn kai'ma to' esenumenka'pî. Mîrîrî ye'nen ka' winîpainon, tînera'makon ton esatî'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tîîse Jesusya to' maimu yuuku'pî: —Wei ewomî tanne suuyu pe tîwe'sen ka' pî' era'maya'nîkon ya, taawonan amîrî'nîkon: “Penane morî pe pata wanî pe man. A'kî, ka' pî' suuyu pe awanî”, taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Moropai penane pu'kuru suuyu pe pata wanî ya taaya'nîkon: “Sîrîrîpe kono' rena pe man”, taaya'nîkon. Maasa pra ka' pî' katupuru era'masa'ya'nîkon ye'nen, moropai ewaron pe pata wanî ye'nen. Ka' era'maya'nîkon kaisarî, taapîtîya'nîkon î' e'kupî epu'tîya'nîkon. Tîîse î' wani' awanî ye'nen anera'ma'pîkon ayenukon ke, kupîya'nîkon pepîn innape? Î' e'kupî epu'tîya'nîkon pepîn, î' ikupî eserîkan pepîn era'maya'nîkon tîîse —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","—Î' ye'ka pe amîrî'nîkon sîrîrî pankon wanî imakui'pî pe, innape ukupî ye'ka pe pra. Anera'makon ton esatîya'nîkon upî'. Tîîse î' rî anera'makon ton kupîuya pepîn. Tîîse tiwinan neken Jonas nurî'tî yarakkîrî e'kupî'pî. Mîrîrî epu'tîya'nîkon yu'se wai. Mîrîrî taa tîpo, Jesus epa'ka'pî moropai attî'pî to' piapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus nenupa'sanya iku'pî nuurukku'sa' yai, tîwanmîra'nîkon tekkarikon yaasa' to'ya pra to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mîrîrî yai ta'pî Jesusya: —Enpen panpî' e'tî, fariseuyamî' moropai saduceuyamî' pî' tîwarî e'tî. Aka, tîwî to' piawon trigo sa'moto' to' piawon nîsi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mîrîrî taiya pî' Jesus nenupa'san eseurîma'pî teken si'ma. Ta'pî to'ya: —Mîrîrî taiya maasa pra uyekkarikon ton ene'sa' pra awanî ye'nen —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Inkamoro eseurîmato' eta'pî Jesusya. Mîrîrî ye'nen to' ekaranmapo'pîiya. Ta'pîiya: —Î' ton pe see eeseurîmakon ko'mannîpî mîrîrî, ayekkarikon ton pra awanî pî'? Î' ye'ka pe see mararî innape uku'to'ya'nîkon awanî mîrîrî! ");
INSERT INTO mbcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Uupia Paapa meruntîri wanî epu'tîya'nîkon pra naatî mîîto'pe? Epu'tîya'nîkon pra awanîkon mîrîrî ayewankon ya'. Manni' unkupî pî' awenpenatakon pra naatî? Mia'taikinan trigo puusa' pîrikkapîtî'pîuya 5.000 kaisaronkon warayo'kon yekkari'tî'pîuya. Moropai î' warapo waikara'pî kaisarî itonparî'pî yannuku'pîya'nîkon pî' enpenatatî. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Moropai manni' asakî'nan mia' pona tîîmo'tai kaisaron trigo puusa' mîrîrî ke 4.000 kaisaronkon warayo'kon yekkari'tî'pîuya. Moropai î' warapo waikara'pî kaisarî itonparî'pî yannuku'pîya'nîkon? ");
INSERT INTO mbcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mîrîrî tauya manni' epu'tîya'nîkon pra awanîkon mîrîrî. Maasa pra trigo puusa' pî' eseurîma pepîn sîrîrî. Tîîse fariseuyamî' moropai saduceuyamî' yeseru pî' eseurîma, mîrîrî tîwarî e'tî. Mîrîrî to' yeseru wanî kîsere'na sa'moto' fermento warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mîrîrî Jesus eseurîmato' epu'tî'pî inenupa'sanya. Maasa pra kîsere'na sa'moto' pî' eeseurîma pe pra epu'tî'pî to'ya. Tîîse pemonkonyamî' yenupato' fariseuyamî'ya moropai saduceuyamî'ya pî' eeseurîma epu'tî'pî to'ya. To' yeseru pî' tîwarî tîwanîkonpa epu'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Moropai Jesus wîtî'pî tiaron pata poro, itese' Cesaréia Filipe. Miarî teerepansa'kon pe tînenupa'san ekaranmapo'pîiya: —Anî' kai'ma uurî, ka' poi iipî'pî pî' pemonkonyamî' wanî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inkamoroya yuuku'pî: —Tiaronkonya taa apî': “João Batista nurî'tî mîîkîrî”, taa to'ya. Moropai tiaronkonya taa: “Penaro' Paapa maimu ekareme'nen profeta Elias nurî'tî mîîkîrî”, taa to'ya —ta'pî to'ya. —Moropai tiaronkonya taa: “Penaro' itekare ekareme'nen profeta Jeremias nurî'tî mîîkîrî”, taa to'ya. “Paapa maimu ekareme'nenan nurî'san yonpa pe awanî”, taa to'ya —ta'pî inenupa'sanya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Amîrî'nîkon kanan? Anî' pe ukupî pî' naatî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedroya yuuku'pî: —Amîrî Paapa nîmenka'pî, Cristo. Ipatîkarî tîîko'mansen Paapa munmu pe awanî —ta'pî Pedroya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesusya ta'pî Pedro pî': —Mîrîrî taaya ye'nen, morî pe pu'kuru awanî sîrîrî, Simão, João munmu —ta'pî Jesusya ipî'. —Maasa pra sîrîrî yairon epu'tîya manni' wanî pepîn pemonkon winîpainon pe pu'kuru. Tîîse uyun ka' pon nîtîrî'pî pe awanî aapia —ta'pî Jesusya Pedro pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mîrîrî ye'nen Jesusya ta'pî Pedro pî': —Tauya sîrîrî apî', amîrî Pedro sa'man, tî' warainon. Moropai sîrîrî tî'parappa pona usoosirî konekauya sîrîrî. Mîrîrîya upemonkonoyamî', usoosirî tawonkon ena pe man meruntî ke, tamî'nawîronkon yentai. Sa'mantanto' yentai to' ena pe man, Makuiya to' taruma'tî tîîse —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Sîrîrî meruntî ke uurî e'to' tîrîuya aapia. Î' taaya'nîkon umaimu pe sîrîrî non po, mîrîrî pî' inna taa Paapaya ka' po —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mîrîrî taa tîpo, Jesusya ta'pî tînenupa'san pî': —Tîîse Paapa nîmenka'pî pe uurî wanî kîsekareme'tî anî' pî' —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Moropai mîrîrî pata pai Jesus eseurîma pia'tî'pî tîîsa'manta pî'. Tînenupa'san pî' ta'pîiya: —Uutî e'pai awanî sîrîrî Jerusalém pona moropai miarî Judeuyamî' esanonya moropai teepîremasanon esanonya uyewanmarî kupî sîrîrî. Moropai Moisés nurî'tîya yenupanto' pî' yenupatonkonya nîrî uyewanmarî kupî sîrîrî. Inkamoroya utaruma'tî mararî pra. Inkamoroya uwî me'po kupî sîrîrî. Tîîse uusa'manta tîpo, iteseurîno weiyu yai e'mî'sa'ka kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mîrîrî taiya ye'nen, Pedroya Jesus yarî'pî tiaronkon kore'tapai tarakkîrî teeseurîmapa, imaimu yuwa'tîpa. Moropai ta'pîiya ipî': —Uyepotorî, mîrîrî warantî eeseurîma e'pai pra man. Paapaya mîrîrî kupî e'pai pra man ayarakkîrî —ta'pî Pedroya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus era'tî'pî Pedro winîkîi. Moropai ta'pîiya Pedro pî': —Uupiapai atarimakî, Makui. Uurî ma'nîpa yu'se awanî mîrîrî. Paapa esenumenka warantî eesenumenka pra awanî mîrîrî. Tarî non po tîîko'mansenon esenumenka warantî eesenumenka —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Moropai Jesusya ta'pî tînenupa'san pî'. Ta'pîiya: —Uwanîyakon pe e'pai awanîkon ya, ayeserukon, itu'se awe'to'kon mîrumakatîi moropai itu'se uurî e'to' ku'tî. Uwanîyakon pe e'pai awanîkon ya, e'taruma'tînto' namapai pra e'tî. Moropai uwenairî maai'tîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—Tîîse anî'ya tîîko'manto' pînînma ya kure'ne, tîwe'taruma'tî namaiya. Mîrîrî ye'nen Paapa pia ipatîkarî tîîko'manto' ton eporîiya pepîn. Tîîse aminke aako'mamî Paapa pî'. Tîîse uwenai anî'ya tîîko'manto' pînînma pra awanî ya, tîwe'taruma'tîto' yapîtanîpîiya ya, ipatîkarî enen tîîko'manto' ton eporîiya Paapa pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamî'nawîron sîrîrî non pon yemanne esa' pe anî' ena ya, tîîse ipatîkarî enen tîîko'manto' ton eporîiya pra awanî ya, eporîiya kupî pepîn rî mîrîrî. Aasa'manta yai tekaton yepe' ton eporîiya pepîn. Awe'pîika'tî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maasa pra uurî, ka' poi iipî'pî iipî kupî sîrîrî Paapa meruntîri yarakkîrî, inserîyamî' pokonpe. Moropai mîrîrî yai tamî'nawîronkon pia untîrî tîrîuya kupî sîrîrî to' nîkupî'pî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ayenku'tîuya'nîkon pepîn sîrîrî. Uurî, ka' poi iipî'pî pemonkon pe wanî pe man tamî'nawîronkon esa' pe. Mîrîrî era'ma amîrî'nîkon yonpayamî'ya pe man tîîsa'mantakon rawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tiwin mia' pona tîîmo'tai wei tîpo, Jesus wîtî'pî kawînan wî' pona tînenupa'san yonpa pokonpe. Pedro wîtî'pî moropai Tiago moropai itakon João wîtî'pî ipokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Miarî Jesus yenpata etinyaka'ma'pî to' rawîrî si'ma. Inke' pe awanî'pî, wei warantî moropai ipon wanî'pî aimutun pe pu'kuru, inke' pe apo' ya'karu warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mîrîrîya tiwinarî asakî'nankon warayo'kon, Moisés nurî'tî moropai Elias nurî'tî esenpo'pî to' rawîrî. Moropai Jesus yarakkîrî to' eseurîma era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mîrîrî ye'nen Pedroya ta'pî Jesus pî': —Uyepotorî, morî pe pu'kuru e'nî man tarî. Mîrîrî ye'nen itu'se awanî ya, eseurîwî'ne kaisarî tappîi ton konekauya sîrîrî, tiwin amîrî ton moropai tiwin Elias ton moropai tiwin Moisés ton kai'ma —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mîrîrî warantî Pedro eseurîma ko'mannîpî tanne, katupuru inke'ya to' napontî'pî. Moropai mîrîrî kore'ta Paapa eseurîmato' eta'pî to'ya. Ta'pî Paapaya: —Unmu mîserî uwakîri pu'kuru ipî' atausinpato'. Mîîkîrî unmu yu'san uurî mararî pra. Mîîkîrîya î' taato' etatî —ta'pî Paapaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Paapa eseurîmato' eta tîuya'nîkon pe, Jesus nenupa'san ena'pî mararî pra eranne' pe. Mîrîrîya to' yenkasi'pannîpî'pî. Non pona tenpatakon erennuku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tîîse Jesus iipî'pî to' pia moropai to' yapî'pîiya. Ta'pîiya to' pî': —E'mî'sa'katî, eranne' pe tîwe'se pra e'tî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inkamoro kuranta'pî moropai tîwoi'nîkon era'ma tîuya'nîkon ya, anî' era'ma to'ya pra awanî'pî, tîîse Jesus neken, tiwinsarî era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wî' poi tawautîkon pe, Jesusya ta'pî to' pî': —Anî' pî' anera'ma'pîkon kîsekareme'tî —ta'pîiya. Uusa'manta tîpo, uurî, ka' poi iipî'pî e'mî'sa'kasa' tîpo ekaremekîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mîrîrî ye'nen inenupa'sanya Jesus ekaranmapo'pî: —Î' wani' kin awanî ye'nen Moisés nurî'tîya yenupanto' pî' yenupatonkonya taapîtî mîrîrî? “E'mai' pe penaro' Paapa maimu ekareme'nen Elias nurî'tî iipî pe man. Moropai mîrîrî tîpo Paapa narima'pî Cristo iipî”, taa to'ya —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesusya yuuku'pî: —Inna, seru' pepîn Elias nurî'tî warainon ii'sa' man tamî'nawîron konekai Paapa maimu yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aaipî'pî tîîse tarîronkonya epu'tî pra awanî'pî. Tîîse itaruma'tî'pî to'ya itu'se tîwanîkon pîkîrî. Mîrîrî warantî nîrî uurî ka' poi iipî'pî taruma'tî inkamoro rî pemonkonyamî'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mîrîrî warantî Jesus eseurîma ye'nen, inenupa'sanya imaimu epu'tî tu'ka'pî. João Batista yekare pî' eeseurîma kai'ma to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Arinîkon pemonkonyamî' pia to' erepansa' ya, warayo' iipî'pî Jesus pia. Moropai irawîrî awe'sekunka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Mîîkîrîya ta'pî Jesus pî': —Uyepotorî, unmu sa'ne a'noko'pî pe era'makî. O'ma' ewonsa' man mîîkîrî ya'. Moropai yeporîiya ya, non pona yenumîiya moropai inta arakkunta. Tu'ke ite'ka apo' ya' imasai'ya man. Moropai tuna ka yenunsai'ya man. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mîîkîrî enepî'pîuya anenupa'sanya yepi'tîto'pe kai'ma. Tîîse yepi'tî to'ya eserîke pra to' wanî'pî —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesusya warayo' maimu yuuku'pî: —Amîrî'nîkon, sîrîrîpankonya ukupî pra awanî innape. Imakui'san amîrî'nîkon. Î' pîkîrî ayapîtanîpîuya'nîkon e'pai awanî? Î' pîkîrî amîrî'nîkon yarakkîrî uuko'mamî sîrîrî? —ta'pî Jesusya. Moropai ta'pîiya: —Mîîkîrî warayo' maasaron ene'tî uupia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mîîkîrî epa'kato'pe ta'pî Jesusya. Moropai o'ma' epa'ka'pî mîîkîrî warayo' yapai mîrîrî pe rî. Mîrîrî ye'nen eesepi'tîsa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mîrîrî ku'sa' Jesusya tîpo, inenupa'san erepamî'pî Jesus pia tiwinsarî tîîse. Ekaranmapo'pî to'ya: —Î' wani' awanî ye'nen o'ma' tîrîka annaya eserîke pra awanî mîrîrî? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Moropai Jesusya ta'pî to' pî': —Maasa pra innape ukupîya'nîkon pra awanîkon ye'nen. A'kî, innape ikupîya'nîkon ya, tîwîrî si'mîrikkî pe mîrikkî innape iku'to'ya'nîkon tîîse, manni' mostarda yena'pî warantî tîîse, taaya'nîkon ya seeni' wî' pî': “Seeni' patapai emo'kakî moropai atîkî” taaya'nîkon ya, moropai amaimukon pe mîrîrî wîtî e'painon. Mîrîrî warantî ikupîya'nîkon ya, tamî'nawîron mîrîrî ye'ka kupîya e'painon, innape ikupîya'nîkon ya —ta'pî Jesusya.  ");
INSERT INTO mbcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","—Tîîse mîîkîrî o'ma' yarakkîrî tîwe'sen yepi'tîya'nîkon e'painon eepîremakon ye'ka pe, ayekkarikon tonpai pra tîîse. Mîrîrî warantî neken mîserî o'ma' warainon yenpa'kaya'nîkon e'painon —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tînenupa'san pokonpe teemurukuntîi Galiléia po, Jesusya ta'pî to' pî': —Uurî ka' poi iipî'pî rumaka tiaronkonya kupî sîrîrî uyeyatonon yenya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Moropai inkamoroya uyapisî kupî sîrîrî. Moropai uwî to'ya kupî sîrîrî. Tîîse uwîsa' to'ya tîpo, iteseurîno weiyu yai e'mî'sa'ka kupî sîrîrî —ta'pîiya. Moropai mîrîrî taa Jesusya eta tîuya'nîkon pî', inenupa'san esewankono'masa' wanî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cafarnaum cidaderî po Jesus erepansa' tanne tînenupa'san pokonpe, to' epîremato' yewî' ta tîniru yapisî pî' teesenyaka'masanon wîtî'pî Pedro pia. Inkamoroya Pedro ekaranmapo'pî: —Amîrî'nîkon yenupanenya tîniru tîrî pepîn anna pia? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Inna, aye'maiya'nîkon —ta'pî Pedroya. Mîrîrî taasa' to'ya tîpo, Pedro ewomî'pî wîttî ta, Jesus e'to' ta. Moropai Jesus eseurîma'pî e'mai' pe Pedro eseurîma pra tîîse. Ta'pîiya: —Î' kai'ma esenumenkan pî' nan, Pedro? Anî'kanya ye'ma e'painon manni'kan ipîkkukon pata esanon esanon reiyamî' pia tarîronkonya tiaron pata ponkonya ka'rî? ");
INSERT INTO mbcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Tiaron pata ponkonya ye'ma —ta'pî Pedroya. —Inna —ta'pî Jesusya. —Tîîse tarî tîîko'mansenonya ye'ma pepîn e'painon maasa pra to' yonpayamî' pe to' wanî ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","—Tîîse ye'ma pra awanî ya, ye'ma annaya pepîn taa to'ya namai ye'mapai man —ta'pî Jesusya. —Mîrîrî ye'nen konoi' pî' atîkî iku'pî ka. E'mai'non moro' yeu'kasa'ya ya, mîîkîrî mata ya' tîniru ena'pî eporîya. Mîrîrî e'to'pe uurî tonpe moropai amîrî tonpe, teepîremasanon pia untîrîkon pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Moropai mîrîrî yai inenupa'sanya Jesus ekaranmapo'pî. —Anî' wanî e'painon ipîkku pe panpî' anna kore'ta, Paapa pemonkonoyamî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mîrîrî taa to'ya ye'nen, to' rawîrî si'ma Jesusya more yanno'pî tîîpia. Moropai mîîkîrî tîrî'pîiya to' rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Moropai ta'pîiya: —Ayenku'tîuya'nîkon pepîn, yairî tauya sîrîrî. Tiaron pe eesenumenkakon pra awanîkon ya, moropai tiaronkon ma're e'pai pra awanîkon ya, mîserî more warantî, Paapa wanî pepîn ayesa'kon pe, ipemonkono pe awanîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mîrîrî ye'nen anî' wanî ya tiaronkon ma're e'pai, mîserî more warantî, mîîkîrî wanî ipîkku pe panpî' Paapa pemonkonoyamî' kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Moropai anî'ya mîserî more warainon yapisî ya tîwakîri pe, uyapurî tîuya ye'nen, mîrîrî warantî uurî nîrî yapisîiya tîwakîri pe more yapisî tîuya manni' warantî —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Tîîse anî'ya innape uku'nenan moreyamî' kore'ta tiwinan to' yonpa yenupa ya imakui'pî ku'to'peiya, mîîkîrî imakui'pî kupîiya emapu'tîtîpon taruma'tî Paapaya mararî pra. Morî pe panpî' awanî e'painon, mîîkîrî pîmî pî' kure'nan a' pe ikonekasa' tî' yewa'tî to'ya ya, moropai mîîkîrî yenumî to'ya ya iren ka'. Maasa pra mîrîrî yentai itaruma'tî Paapaya imakui'pî kupî tiaronya emapu'tîsai'ya ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aka, tîwarî e'tî, tamî'nawîronkon pemonkonyamî' sîrîrî pata po tîîko'mansenon. Maasa pra imakui'pî kupî to'ya emapu'tîsanon moro awanî. Mîrîrî e'kupî e'pai awanî, tîîse manni' tiaronya imakui'pî kupî emapu'tînen, mîîkîrî taruma'tî Paapaya pe man mararî pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—A'kî, imakui'pî kupîya emapu'tî ayenya ya, mîrîrî ya'tîkî. Moropai a'puya nîrî imakui'pî kupîya emapu'tî ya, mîrîrî ya'tîkî moropai yenunkî imakui'pî kupîya namai. Morî pe awanî ma'tîkî' si'ma enen aako'manto' ton eporîya ya, morî pe e'to' yawîrî si'ma apo' ya' ayenumî Paapaya yentai, manni' apo' î' pensa eesi'nîpî ton pepîn ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Moropai ayenuya imakui'pî kupîya emapu'tî ya, mîrîrî ayenu ratai mo'kakî moropai mîrîrî yenunkî poro pona imakui'pî kupîya namai. Maasa pra morî pe awanî, taiken ayenu tîîse, aako'manto' ton eporîya ya, sa'nîrî tîîse apo' ya' ayenumî Paapaya yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Mîrîrî ye'nen, aka tîwarî e'tî manni'kan moreyamî' innape uku'nenan kupîya'nîkon namai ayewanmakon pe. Maasa pra tauya sîrîrî apî'nîkon, inkamoro ko'mannî'nenankon pe inserîyamî' wanî aminke pra Paapa pia, î' e'kupî to' yarakkîrî ekareme'nenan pe.  ");
INSERT INTO mbcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Moropai uurî, ka' poi iipî'pî sîrîrî non pona ataka'ma'san pîika'tîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesusya to' nepu'tî ton ekaremekî'pî. Ta'pîiya: —Î' kai'ma eesenumenkakon e'painon. Warayo' wanî ya 100 kaisarî carneiroyamî' esa' pe tîwe'se, tîîse inkamoro yonpa esepu'tî pra awanî ya tiwin, î' kupîiya e'painon? Tîwî inkamoro 99 kaisaronkon nîmîiya tekkarikon yonpa to'ya tanne. Moropai attî eesera'ma pra awanî manni' yuwai, innape nai? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","—Moropai tauya mîîkîrî eposai'ya ya, kure'ne aatausinpa. Inkamoro 99 kaisaronkon pî' aatausinpa yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mîrîrî warantî nîrî Paapa ayunkon ka' pon wanî tiwin mîrikkî more, tîpemonkonoyamî' yonpa ataka'ma yu'se pra, imakui'pî ya' attî namai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Moropai ta'pîiya: —Ayonpaya imakui'pî ku'sa' ya awinîkîi, iipia atîkî imakui'pî inkupî'pî konekata yarakkîrî. “Yairî pra awe'sa' nai, uyonpa”, ka'ta ipî'. Tîîse mîrîrî konekakî sa'nîrî si'ma neken amîrî'nîkon, tiaronkon kore'ta pra si'ma. Morî pe tîpanamato'ya eta ayonpaya ya, morî pe awanî, maasa pra ipîika'tîya ye'nen mîrîrî winîpai. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tîîse tîpanamato'ya anetapai pra awanî ya, tiwin asakî'nankon innape Jesus ku'nenan yaakî ayarakkîrî. Paapa maimu e'menukasa' manni' yawîrî awanîkonpa. Maasa pra see warantî awe'menukasa' man: Asakî'ne eseurîwî'ne etatonkon e'pai awanî innape yairî eseurîmannî'pî e'to'pe, taasai'ya man. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tîîse to' maimu anetapai pra awanî ya, tamî'nawîronkon innape Jesus ku'nenan soosi tawonkon pî' ekareme'tî. Mîrîrî warantî tîîse to' maimu anetapai pra wanî ya, mîîkîrî pî' e'tî Paapa epu'nen pepîn pî' awanîkon warantî iku'tî, imakui'pî pe tîwe'sen warantî iku'tî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Yairî tauya sîrîrî apî'nîkon, mîrîrî amaimukon pî' inna taa Paapaya. Moropai amaimukon anetapainon yapisîya'nîkon ya inî'rî ayonpa pe mîrîrî amaimukon pî' inna taa Paapaya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Moropai inî'rî tauya apî'nîkon î' rî anesatîkon asakî'ne si'ma esatîya'nîkon ya, Paapa pî' eepîremato'kon ke, tamî'nawîrî mîrîrî eta Paapaya. Mîrîrî ye'nen itîrî uyun ka' ponya aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maasa pra o'non pata si'ma uyapurînenan emurukuntîsa' wanî ya, asakî'nankonya eseurîwî'nankonya uyapurî ya uyese' pî' inkamoro kore'ta uurî ko'mamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Moropai Pedro wîtî'pî Jesus pia. Moropai ta'pîiya Jesus pî': —Uyepotorî, î' warapo ite'ka uyonpa nîkupî'pî imakui'pî uwinîkîi ku'to'peuya uuwanmîra? Î' wani' pra man taato'peuya ipî'? —ta'pî Pedroya. —Asakî'ne mia' pona tîîmo'tai ite'ka ka'rî tauya e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusya yuuku'pî: —Asakî'ne mia' pona tîîmo'tai kaisarî tauya pepîn. Tîîse tu'ke ite'ka ka'kî, 77 kaisarî ka'kî —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Maasa pra mîrîrî warantî pemonkonyamî' esa' pe tîwe'sen Paapaya ikupî tîpemonkonoyamî' yarakkîrî. Awanî Reiya epe'mîra to' e'to' era'ma warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","—Mîrîrî kupî pia'tî to' yepuruya epe'mîra tîwe'sanon pî'. Tiaronkon pemonkonyamî'ya tiwin ipoitîrî enepî'pî iipia. Mîîkîrî ipoitîrî wanî'pî tepuru pia mararî pra epe'mîra 400 milhão kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tîîse mîrîrî epe'mîra tîwe'to' ye'maiya eserîke pra ipoitîrî wanî'pî. Mîrîrî ye'nen ta'pî itepuruya surarayamî' pî': “Mîserî warayo' ke e'repatî. Moropai ino'pî ke moropai inmukuyamî' ke. Moropai tamî'nawîrî itewî' ta tî'we'sen itemanne ke e'repatî mîrîrî yepe'pî ke epe'mîra awe'to' ye'makonpa”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mîrîrî taiya ye'nen, mîîkîrî ipoitîrî e'sekunka'pî irawîrî. Moropai ta'pîiya tepuru pî': “Uyepuru, maasa ye'mauya nîmî'pai man. Aye'mauya pra wanî pepîn tîîse aye'mauya tamî'nawîrî” ta'pî ipoitîrîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mîrîrî taiya ye'nen, mîîkîrî tîpoitîrî era'ma'pî itepuruya tî'noko'pî pe sa'ne. Mîrîrî ye'nen ta'pîiya tîpoitîrî pî': “Î' wani' pra man, tîwî natîpamîi uurî kîse'mai”, ta'pîiya ipî'. Moropai attîto'pe ta'pî itepuruya tîîpiapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tîkaraiwarî piapai tuutî pe, tiaron warayo', tepuru pia esenyaka'ma'pî eporî'pîiya. Mîîkîrî sa'ne wanî'pî iipia itarumai'pî pe. Mîîkîrî wanî'pî mararî epe'mîra iipia 300 kaisarî. Mîîkîrî sa'ne yapisî'pîiya i'mî pî' yapisî'pîiya. Moropai ta'pîiya ipî': “Uupia epe'mîra awe'to' ye'makî tarîpai”, ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mîrîrî taiya ye'nen, mîîkîrî sa'ne e'sekunka'pî irawîrî. Moropai ta'pîiya mîîkîrî pî': “Maasa aye'mauya nîmî'pai man. Ye'mato' ton eposau'ya. Aye'mauya pra wanî pepîn tamî'nawîrî aye'mauya” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tîîse, inna î' wani' pra man, taiya pra mîîkîrî iipia epe'mîra awe'to' wanî'pî. Mîrîrî ye'nen mîîkîrî yarî'pîiya ama'ye'kon atarakkanto' yewî' ta. Miarî yarakkamo ye'ka pe ta'pîiya: “Tarî ako'mankî uupia epe'mîra awe'to' ye'maya pîkîrî”, ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tîîse mîrîrî warantî mîîkîrîya ikupî era'ma'pî tiaronkon itepuru poitîrîtononya. Inkamoro ena'pî yairî ma're mararî pra, mîrîrî era'ma tîuya'nîkon ye'nen. Tarîpai mîrîrî ekareme'se to' erepamî'pî tepurukon pia. Moropai mîrîrî ekaremekî'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Moropai itepuruya mîîkîrî tîpoitîrî e'mai'non yanno me'po'pî aai'to'pe tîîpia. Mîîkîrî pî' ta'pî itepuruya: “Amîrî imakui'pî. Teuren uupia epe'mîra awe'to' pî' î' wani' pra man moriya, taasau'ya tanne, esatîya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tîîse î' wani' awanî ye'nen tiaron upoitîrî era'maya pepîn a'noko'pî pe, uurîya u'noko'pî pe ayera'ma'pî warantî?” ta'pî itepuruya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mîrîrî yai mîîkîrî pî' itepuru ekore'ma'pî mararî pra. Mîrîrî ye'nen mîîkîrî tîpoitîrî rumaka'pîiya surarayamî'ya yarakkamoto'pe atarakkannîto' yewî' ta. Mîrîrî warantî awe'taruma'tî'pî tamî'nawîrî epe'mîra tîwe'to' ye'ma tîuya pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sîrîrî warantî uyun ka' po manni'ya ikupî kupî sîrîrî tiwin pî' amîrî'nîkon yarakkîrî, awinîkîi'nîkon imakui'pî ayonpakon nîkupî'pî ku'sa'ya'nîkon pra awanîkon ya, aawanmîra'nîkon —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mîrîrî warantî teeseurîma yaretî'ka tîpo, Jesus wîtî'pî Galiléia pata poi. Awenna'po'pî Judéia pata pona. Iren Jordão ratai poro attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mîrîrî yai arinîkon pemonkonyamî' epere'pîtî'pî iipia. Moropai pri'yawonkon pepîn yepi'tî'pîiya miarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tiaronkon fariseuyamî' erepamî'pî Jesus pia. Jesus anaka'mapai to' wanî'pî iteseru era'makonpa kai'ma. Mîrîrî ye'nen ekaranmapo'pî to'ya: —Warayo'ya tîno'pî rumakasa' ya î' wenai pra, yairî awanî mîrîrî? Moisés nekaremekî'pîya taasa' yawîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Jesusya yuuku'pî: —Paapa maimu erenkasa'ya'nîkon pra naatî, î' kai'ma Paapaya taasa' epu'tîkonpa? Awe'menukasa' see warantî: “Tamî'nawîron koneka tîuya yai, pemonkon koneka'pî Paapaya warayo' pe moropai wîri' pe.” Moropai Paapaya ta'pî: “Mîrîrî ye'nen tîîno'pîta yai, warayo'ya tîsan moropai tîyun rumaka, inî'rî to' pia aako'mamî pepîn. Tîîse tîno'pî yarakkîrî neken aako'mamî. Inkamoro enasa' mîrîrî, tiwinan pemonkon warantî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mîrîrî ye'nen asakî'nankon warantî pra tîîse, tiwinan warantî to' wanî. Mîrîrî warantî to' ku'sa' Paapaya ye'nen, anî'ya to' pantaka e'pai pra man. Tîno'pî rumakaiya eserîke pra man. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mîrîrî taa Jesusya ye'nen, fariseuyamî'ya Jesus ekaranmapo'pî: —Tîîse î' ton pe Moisésya kaareta menuka me'po'pî warayo'ya tîno'pî pia tîîto'pe? “ ‘Tarîpai inî'rî uno'pî pepîn amîrî’ taiya ya, tîno'pî pî' irumakaiya moropai attî”, ta'pî Moisés nurî'tîya —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusya to' maimu yuuku'pî: —Mîrîrî warantî ankupîkon ton menuka'pîiya, maasa pra sa'me pu'kuru ayewankon wanî era'ma tîuya ye'nen. Morî kupîya'nîkon eserîke pra awanîkon ye'nen. Tîîse pena Paapaya pata koneka yai, mîrîrî warantî itu'se pra Paapa wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Warayo'ya tîno'pî rumaka ya tiaron warayo' yarakkîrî awe'sa' pra tîîse, moropai tiaron wîri' yarakkîrî awanî ya, imakui'pî kupî mîîkîrîya, mîrîrî Paapa winîkîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Moropai Jesus nenupa'sanya ta'pî Jesus pî': —Moriya tîno'pî rumaka warayo'ya namai, moropai wîri'ya tînyo rumaka namai, warayo' no'pîta e'pai pra awanî mîrîrî. Moropai wîri' etinyoma e'pai pra awanî nîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tîîse Jesusya yuuku'pî. Ta'pîiya: —Moriya kano'pîtatî taaya'nîkon eserîke pra awanîkon tamî'nawîronkon pî'. Tîîse manni'kan warayo'kon ino'pî pra tîîko'mansenon ton pe neken sîrîrî esenupanto' wanî. Maasa pra Paapaya yapîtanîpî to'ya meruntîri tîîsa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maasa pra inkamoro ye'kakon warayo'kon esenpo mararî, tu'ke pra yemukasa'kon warantî. Mîrîrî ye'nen to' no'pîta eserîke pra to' wanî, maasa pra mîrîrî warantî teesenposa'kon ye'nen. Tîîse tiaronkon warayo'kon yemuka tiaronkonya, mîrîrî warantî ino'pî pra to' e'to'pe. Moropai tiaronkon no'pîta pepîn maasa pra tesa'kon pe Paapa wanî ye'nen, to' eturumaka eesenyaka'mato' kupîkonpa. Anî' wanî ya, sîrîrî esenupanto' yawîrî iko'manpai, yapîtanîpî tîuya eserîke awanî ya, iku'kî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Moropai tiaronkonya moreyamî' yarî'pî Jesus pia tenya tîîto'peiya to' pona moropai to' pîremato'peiya. Tîîse inenupa'sanya ta'pî pemonkonyamî' pî': —Insanan moreyamî' mo'katî Jesus piapai —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tîîse Jesusya ta'pî to' pî': —Tîwî moreyamî' ii'to'pe uupia, to' tîmanenpai pra e'tî —ta'pîiya tînenupa'san pî'. —Maasa pra insamoro moreyamî' warantî Paapa pemonkonoyamî' wanî. Imîrî pe to' wanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Inkamoro pona tenya tîtîse Jesus epîrema'pî. Mîrîrî tîpo attî'pî to' piapai. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Moropai maasaron warayo' ipîkku pe tîwe'sen erepamî'pî tiwin wei Jesus pia. Moropai Jesus ekaranmapo'pîiya: —Uyenupanen, morî pu'kuru amîrî —ta'pîiya. —Î' morî kupîuya e'painon ipatîkarî uuko'manto' ton epoto'peuya Paapa pia? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusya ta'pî ipî': —Î' wani' awanî ye'nen morî amîrî taaya mîrîrî upî'? Tiwinan morî moro man, Paapa neken mîîkîrî, tiaron ton pra man —ta'pîiya. —Mîîkîrî pia pu'kuru aako'manto' ton yu'se awanî ya, î' taasa' Paapa maimuya unkupîkon ton, manni' yawîrî ikonekakî —ta'pî Jesusya warayo' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Î' ye'ka see Paapa maimu yawîrî iku'to'peuya? —kai'ma Jesus maimu yuuku'pîiya. Jesusya yuuku'pî: —Pemonkon kî'wîi moropai se' tapairî wîri'sanyamî' yarakkîrî tîwe'se pra e'kî. Moropai tiaron kîsama'runpai, moropai seru'ye' pe teeseurîmai pra e'kî. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Moropai ayun asan namakî. Moropai ayonpa sa'namakî kure'ne aawarîrî amîrî e'sa'nama manni' warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Warayo'ya yuuku'pî: —Pena more pe wanî'pî patapai sîrîrî tîpose, mîrîrîkon ku'nen uurî tamî'nawîrî —ta'pîiya. —Tîîse î' tiaron kupîuya e'painon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusya yuuku'pî: —Inna, tamî'nawîrî e'to' yawîrî anku'pai awanî ya, tiwinano'pî ankupî ton moro man. Tamî'nawîrî ayemanne ke e'repata, moropai mîrîrî yepe'pî mîrataikkai manni'kan sa'ne î' ton pra tîwe'taruma'tîsanon pia. Mîrîrî warantî ikupîya ya, inî' panpî' ayemanne ton eporîya ka' po. Moropai maaipîi uwenairî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mîrîrî warantî taa Jesusya eta tîuya ye'nen, mîîkîrî maasaron warayo' ipîkku esewankono'ma'pî mararî pra. Maasa pra mîrîrî anku'pai pra tîwanî ye'nen ipîkku pe tîwe'to' pînînma'pîiya. Mîrîrî ye'nen attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mîîkîrî esewankono'masa' era'ma tîuya pe, Jesusya ta'pî tînenupa'san pî': —A'kî, yairî tauya sîrîrî apî'nîkon. Sa'me pu'kuru awanî ipîkku pe tîwe'sen eturumakato'pe Paapa yenya' tesa' pe awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Moropai inî'rî tauya sîrîrî sa'me pu'kuru see awanî ipîkku ewonto'pe Paapa pia, itesa' pe Paapa e'to'pe. Mararî kameru ewomî pepîn akkusa yeutta yai, kure'ne tîwanî ye'nen. Mîrîrî warantî ipîkku pe tîwe'sen ewomî pepîn Paapa pata'se' ya'. ˻Maasa pra kure'ne tewan yapi'sai'ya ye'nen temanne pî'˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mîrîrî taa Jesusya eta tîuya'nîkon pe, inenupa'san wanî'pî teesewankono'mai mararî pra. Mîrîrî ye'nen ekaranmapo'pî to'ya Jesus pî': —Moriya anî'kan e'pîika'tî e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Inkamoro era'ma'pî Jesusya moropai to' maimu yuuku'pîiya: —Anî' e'pîika'tî wanî sa'me pu'kuru, pemonkon pia ikupîiya eserîkan pepîn. Tîîse mîrîrîkon wanî sa'me pra mîîkîrî Paapa pia. Mîrîrî ye'nen ikupîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Moropai Pedroya ta'pî Jesus pî': —Tamî'nawîrî anna ko'manto', anna yewî'kon nîmî'sa' annaya sîrîrî awenairî anna wîtîto'pe kai'ma. Î' kin yapisî annaya e'painon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusya yuuku'pî: —Yairî tauya sîrîrî apî'nîkon. Uurî ka' poi iipî'pî wanî kupî sîrîrî meruntî ke tiwin wei. Moropai Paapaya tamî'nawîron koneka amenan pe. Mîrîrî yai tamî'nawîronkon esa' pe ereuta kupî sîrîrî uyaponse' pona ipîkku pata'se' ya'. Mîrîrî yai amîrî'nîkon, uwenaironkon nîrî ereuta pe naatîi, asakî'ne pu' pona tîîmo'tai'non apono'kon pona, tamî'nawîronkon ayonpakon esa' pe awanîkonpa. Mîrîrî warantî inkamoro Israel ponkon yepuru pe eenakon kupî sîrîrî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jesusya ta'pî: —Manni' tewî' moropai tîno'pî, moropai takon tonpayamî' nîmî'nen wanî ya uwenai, moropai tînmukuyamî' moropai tîyun, tîsan, moropai tîpata nîmî'nen uwenai, Paapaya tannosa' yai, mararî pra mîîkîrîya yapisî kupî sîrîrî inî' panpî' î' nîmî'pî tîuya manni' yentai. Moropai tîîko'manto' ton ipatîkaron eporîiya tiwinano'pî wei yai. ");
INSERT INTO mbcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tarî sîrîrî non po tiaronkon pemonkonyamî' wanî ipîkku pe. Tîîse Paapa pia teerepansa'kon yai, to' wanî pepîn ipîkku pe. Tiaronkon wanî pepîn ipîkku pe sîrîrî pata po, tîîse Paapa pia teerepansa'kon yai, ipîkku pe to' ena kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesusya sîrîrî panton ekaremekî'pî î' kai'ma pemonkonyamî' esa' pe Paapa iipî ekaremekîpa kai'ma. —Tamî'nawîronkon esa' pe Paapa iipî yai, awanî pe nai see warantî: Warayo' wanî'pî tekkari ye' ton uva ye'ka pîmîtîpon pe. Mîîkîrî wîtî'pî penane pu'kuru, maasa wei epa'ka pra tîîse, tîîpia eesenyaka'makon ton yuwai, tînmîri era'makon ton. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Moropai to' eseposa' tîuya pe, to' yarakkîrî eeseurîma'pî. Ta'pîiya to' pî': “Uupia eesenyaka'makon e'painon? Aye'mauya'nîkon. Tiwin wei tîîse tiwin pî' akaisarî'nîkon prata ena'pî ke aye'mauya'nîkon”. Moropai inkamoro yaipontî'pîiya to' wîtîto'pe esenyaka'mai tînmîri ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Moropai 9 horas yairî tîîse attî'pî tiaron pata sararu ke to' e'repato' pata'se' ya'. Moropai miarî tiaronkon warayo'kon era'ma'pî mîîkîrîya, î' pî' pra tîwe'sanon era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Inkamoro pî' ta'pî warayo'ya: “Amîrî'nîkon nîrî unmîri ya' esenyaka'matantî. Uyekkari ye'ka, uva ye'kana' eesenyaka'ma'pîkon ye'mauya morî pe”, ta'pî umî esa'ya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Moropai to' wîtî'pî inmîri ya' esenyaka'mai. Ineka'ta pairî wei tîîse mîrîrî warantî tiaronkon teesenyaka'masanon eporî'pîiya, moropai wei era'tîsa' tanne, 3 horas tîîse ko'mamîiya mîrîrî warantî tiaronkon teesenyaka'masanon yarakkîrî ikupî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Moropai tiaronkon teesenyaka'masanon ton eporî'pîiya ko'mamîiya 5 horas yairî tîîse tîwenna'poi pra'ca pona. Inkamoro ekaranmapo'pîiya. “Î' pî' tarî aako'mamîkon sîrîrî wei tamî'nawîrî î' tîkonekapî'se pra?” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Inkamoroya yuuku'pî: “Anna ko'mamî sîrîrî maasa pra anî' eseurîmasa' pra man anna yarakkîrî”, ta'pî to'ya. Mîrîrî ye'nen mîîkîrî warayo'ya ta'pî to' pî': “Moriya unmîri ya' esenyaka'matantî uva ye'kana'”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Moropai to' esenyaka'mato' weiyu ataretî'kasa' yai, to' karaiwarîya teesenyaka'masanon esanon pe tîwe'sen pî' ta'pî to' yannoto'peiya. Ta'pî umî esa'ya: “To' yannokî moropai to' ye'makî ikînî'pî esenyaka'ma pia'tî'pî patapai. E'mai' pe esenyaka'ma'san pîkîrî to' ye'makî”, ta'pî umî esa'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mîrîrî ye'nen inkamoro 5 horas tîîse ko'mamîiya esenyaka'ma'sanya tiwin pî' prata ena'pî yapisî'pî tîkaisarî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tîîse tiaronkon e'mai' pe esenyaka'ma'san esenumenkasa' wanî'pî, inkamoro yentai tepe'pîkon yapisî tîuya'nîkon kai'ma. Tîîse inkamoroya yapisî'pî kaisarî tiwin pî' prata ena'pî yapisî'pî to'ya tîkaisarî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inkamoroya tîtînirurîkon yapisî'pî moropai inkamoro wo'ma'ta pia'tî'pî tîkaraiwarîkon pî'. Tîkaisarî'nîkon tiaronkon ye'masai'ya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ta'pî to'ya tîîwarîrî'nîkon: “Insamoro warayo'kon esenyaka'ma'pî mararî, tiwin hora kaisarî neken. Uye'ma'pîkon pî' to' erepamî'pî teuren. Tîîse uurî'nîkon pena patapai wei kaisarî a'ne' pe wei moronka'pî. Tîîse inkamoroya yapisî kaisarî yapisî uurî'nîkonya”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tîîse yuuku'pî mîîkîrî umî esa'ya tiwinan teesenyaka'masen pî'. “Uyonpa, maasa etakî, imakui'pî ku'sau'ya pra wai awinîkîi. Maasa pra tiwin prata ena'pî ke aye'mauya tauya yai, inna, morî pe man ta'pîya. Innape nai? ");
INSERT INTO mbcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mîrîrî ye'nen sîrîrî ayepe'pî atînirurî yapi'kî moropai atîkî ayewî' ta. Mîserî warayo', ikînî'pî uneta'pî ye'mapai wai aye'ma pî' wai warantî, se' kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Î' anku'pai e'to' kupîuya uyemannekon ke. Moropai utînirurîkon ke ikupîuya. Tîîse mîrîrî wanî pepîn imakui'pî pe. Tîîse uyemannekon ke morî ku'sau'ya wenai akinmu mîrîrî”, ta'pî warayo'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Moropai Jesusya teeseurîmato' yaretî'ka'pî. Ta'pîiya: —Mîrîrî warantî tîpemonkonoyamî' kupî Paapaya. E'mai' pe e'kupî'san wanî kupî sîrîrî ikînî'pî. Moropai ikînî'pî esi'san wanî kupî sîrîrî e'mai' pe, itu'se Paapa e'to' yawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalém pona tuutîkon pe, Jesusya tînenupa'san yarî'pî tiaron winîkîi. Inkamoro pî' eeseurîma'pî, iponarî to' taase tuutîkon ye'ka pe e'ma taawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ta'pîiya: —Wîtî'nîkon sîrîrî Jerusalém pona. Miarî uurî ka' poi iipî'pî rumaka to'ya kupî sîrîrî teepîremasanon esanonkon pia. Moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon pia. Inkamoroya uwî me'po kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Moropai inkamoroya utîrî kupî sîrîrî Judeuyamî' pepîn pia. Inkamoro wo'ma'ta kupî sîrîrî upî'. U'po'pîtî to'ya. Moropai upokapîtî to'ya pakî'nan pona. Tîîse uusa'manta tîpo, iteseurîno weiyu yai, e'mî'sa'ka kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mîrîrî yai Zebedeu no'pî erepamî'pî tînmukuyamî' pokonpe Jesus pia. Moropai irawîrî si'ma tîpu'pai enu'tî'pîiya non yekaya. Moropai Jesus pî' esatî'pîiya itu'se tîwe'to' ku'to'peiya kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mîîkîrî ekaranmapo'pî Jesusya: —Î' yu'se kin awanî mîrîrî? —ta'pîiya ipî'. Mîîkîrîya yuuku'pî: —Tamî'nawîronkon esa' pe eena yai, insanan unmukuyamî' asakî'nankon ereutato'pe ka'kî, tiwin ameruntîri winî, moropai tiaron kamai' winî. Tamî'nawîronkon esa' pe to' e'to'pe awarantî —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesusya ta'pî inkamoro inmukuyamî' pî': —Anesatîkon kupîuya pepîn e'painon. Anesatîkon epu'tîya'nîkon pra naatîi. Tiaronkonya utaruma'tî kupî sîrîrî, mîrîrî yapîtanîpîuya kupî sîrîrî. Amîrî'nîkon kanan? Uyese' pî' awanîkon wenai tiaronkonya atarumatîkon ya, yapîtanîpîya'nîkon pe naatî? —ta'pîiya. —Inna —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mîrîrî pî' ta'pî Jesusya: —Inna seru' pepîn. Innape uurî e'taruma'tî warantî awe'taruma'tîkon nîrî —ta'pî Jesusya. —Tîîse tauya pepîn apî'nîkon umeruntîri winî ereutakî, moropai kamai' winî ereutakî tauya pepîn apî'nîkon. Maasa pra uyunya taa kupî sîrîrî manni'kan uupia ereutatonkon tîmenka'san pî' to' ereutato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mîrîrî kai'ma Jesusya to' yeurîma eta'pî inenupa'san mia' tamî'nawîronkonya. Mîrîrî pî' to' ekore'ma'pî inkamoro asakî'nankon winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Inkamoro yanno'pî Jesusya tamî'nawîrî tîîpia. Moropai ta'pîiya to' pî': —Sîrîrî non po pata esanonya tîpemonkonoyamî' yaipontî, epu'nenan amîrî'nîkon. Maasa pra to' esa' tîwanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tîîse amîrî'nîkon mîrîrî warantî pra e'tî. Tonpakon yentai e'pai anî' wanî ya, to' ma're e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Moropai anî' esenumenka ya tonpayamî' esa' pe e'pai mîîkîrî wanî e'pai wanî to' poitîrî pe. Mîrîrî warantî neken to' ye'mai'norî pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mîrîrî warantî uurî, ka' poi iipî'pî yeseru wanî. Tîpoitîrî ke e'to'pe kai'ma uui'sa' pra wai. Tîîse to' poitîrî pe e'to'pe moropai tu'kankon pîika'tîto'peuya kai'ma uuipî'pî. Arinîkon nîkupî'pî imakui'pî yepe' pe uusa'mantato'pe kai'ma uuipî'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mîrîrî tîpo Jesus moropai inenupa'san wîtî tanne Jericó pata poi, arinîkon pemonkonyamî' wîtî'pî to' wenairî. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Miarî mîrîrî e'ma taawîrî, to' wîtîto' ena pona asakî'nankon enkaru'nankon ereutasa' wanî'pî. Inkamoroya eta'pî mîrîrî e'ma taawîrî Jesus wîtî yekare. Mîrîrî ye'nen to' entaimepîtî pia'tî'pî: —Uyepotorî, amîrî Davi nurî'tî paarî'pî, pîika'tîton amîrî, a'noko'pî pe sa'ne anna era'makî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mîrîrî pî' arinîkonya ta'pî moo to' e'to'pe. Tîîse yuuku to'ya pra, inî' panpî' to' entaimepîtî'pî. —Anna yepotorî, Davi nurî'tî paarî'pî, a'noko'pî pe sa'ne anna era'makî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Inkamoro maimu eta tîuya pe, Jesus emî'pamî'pî inkamoro pia. Inkamoro pî' ta'pîiya: —Î' kupîuya yu'se awanîkon mîrîrî? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Anna Yepotorî, anna yenu yenponkaya yu'se anna wanî sîrîrî, era'mato'pe annaya —kai'ma yuuku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesusya tî'noko'pî pe sa'ne to' era'ma'pî. Mîrîrî ye'nen to' yenukon yenponka'pîiya, inî'rî era'mato'pe to'ya. Ka'ne' pe to' yenu ekoneka'pî. Moropai inkamoro wîtî'pî Jesus wenairî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalém pona tuutîkon pe, aminke pra rî tîîse to' erepamî'pî pemonkonyamî' ko'manto' pata itese' Betfagé pona, Oliveira kîrî po tîwe'sen pona. Miarîpai Jesusya asakî'ne tînenupa'san yaipontî'pî e'mai' pe tîrawîrî to' wîtîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ta'pîiya to' pî': —Atîtî mîrîrî pata pona e'mai' pe. Moropai miarî eerepansa'kon pe jumenta eporîya'nîkon mîîtî ewa'tîsa' pe tînre kenan. Mîîkîrî meukatîi, moropai to' mene'tîi sa'nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—Anî'ya taa ya: “Î' tonpe mîîkîrî yarîya'nîkon mîrîrî”, taa to'ya ya, “Uyepotorîkon man itu'se”, makatîi ipî'. Mîrîrî warantî taaya'nîkon ya, irumakaiya to' enepîkonpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mîrîrî warantî awe'kupî'pî maasa pra penaro' Paapa maimu ekareme'nen profeta nurî'tîya imenuka'pî yawîrî awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ta'pîiya see warantî: Makatîi Jerusalém ponkon pî' Paapa pemonkonoyamî' pî': “A'kî ayesa'kon iipî pe man jumenta more pona teenu'se. Eranmîra eerepamî pe man” makatîi to' pî'. Mîrîrî warantî penaro' Paapa maimu ekareme'nenya imenuka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Moropai Jesus nenupa'san wîtî'pî e'mai' pe. Moropai inkamoroya î' kai'ma ta'pî Jesusya yawîrî ikupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inkamoroya jumenta enepî'pî inre yarakkîrî. Inkamoroya ta'sankon tîrî'pî ipona. Moropai Jesus enuku'pî ipona. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mîîkîrî iipî era'ma tîuya'nîkon ye'nen, arinîkon pemonkonyamî'ya ta'sankon yarenka'pî non pona, iporo Jesus wîtîto'pe kai'ma. Moropai tiaronkonya yu' yare soroka'pî e'ma ta, irawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yarakkîrî tuutîsanon entaimepîtî'pî irawîrî si'ma, moropai ite'ma'pî pî' si'ma mararî pra: —Yapurîpai'nîkon man Davi parî'pî pe tîwe'sen. Morî pe pu'kuru man, aaipî'pî manni' Uyepotorîkon maimu pe —ta'pî to'ya tîwentaimepî'se. —Paapa ka' pon manni' yapurîpai'nîkon man —taa pî' to' ko'mamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus ewonsa' pe cidade pona, tamî'nawîronkon pemonkonyamî' wanî'pî tataimurunpai mararî pra. Moropai ekaranmapo'pî to'ya: —Anî' pe see mîîkîrî wanî mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mîrîrî taa to'ya yuuku'pî arinîkonya: —Manni' Paapa maimu ekareme'nen profeta Jesus, Galiléia pata pon, Nazaré poinon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Miarî Jerusalém po, epîremanto' yewî' ta teewomî pe, Jesusya pemonkonyamî' eporî'pî. Carneiroyamî' ke moropai paakayamî' ke, waku'kaimîyamî' ke tîwe'repasanon eporî'pîiya. Inkamoro yenpa'ka'pîiya teekore'mai. Tamî'nawîrî inkamoro e'repa yaponse'kon ra'tî'pîiya. To' tînirurî yense' ra'tî'pîiya non pona tîsorokai. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Moropai ta'pîiya to' pî': —Paapa maimu e'menukasa'ya taasa' man see warantî. Paapaya ta'pî: “Uyewî' wanî pe man epîremanto' yewî' pe. Tîîse amîrî'nîkonya uyewî' ku'sa' ama'ye'kon yewî' pe”, ta'pî Paapaya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mîrîrî yai enkaru'nankon moropai ma'tîkî'pankon yarî'pî to'ya iipia, epîremanto' yewî' ta to' esepi'tîto'pe. Inkamoro yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tîîse mîrîrî ikupî eserîkan pepîn kupî Jesusya era'ma tîuya'nîkon pî' teepîremasanon esanon moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon ekore'ma'pî. Moropai epîremanto' yewî' ta moreyamî'ya Paapa yapurî'pî tîwentaimepî'se. —Morî pu'kuru Paapa nîmenka'pî, Davi nurî'tî paarî'pî man yapurîto'pe —ta'pî to'ya Jesus pî'. Mîrîrî pî' to' ekore'ma'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Moropai Jesus pî' ta'pî to'ya: —Î' taa to'ya eta pî' nan? —ta'pî to'ya. Yuuku'pî Jesusya: —Innape awanî —ta'pîiya. —Î' taasa' Paapa maimuya epu'tîya'nîkon pra kin naatî? Ta'pî Paapa maimu ekareme'nenya: Insanan moreyamî' yenupa'pî Paapaya tapurîto'pe to'ya morî pe pu'kuru e'to' yawîrî taasai'ya man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Taa tîpo Jesusya to' nîmî'pî. Eepa'ka'pî to' pata cidade poi. Moropai attî'pî pemonkonyamî' ko'manto' Betânia pona attî'pî. Moropai miarî eewaronpamî'pî moropai eerenmapî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tiaron wei yai, penane pu'kuru cidade Jerusalém pona tîwenna'po pe, Jesus wanî'pî emi'ne. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mîîkîrîya yei, figo ye' era'ma'pî e'ma ena po. Moropai mîîkîrî wîtî'pî itekare pî' iteperu moro wanî kai'ma. Tîîse iteperu eporîiya pra Jesus wanî'pî tîîse yare pe neken awanî'pî. Mîrîrî ye'nen Jesusya ta'pî figo ye' pî': —Ipatîkarî teepetai pra aako'mamî tarîpai —ta'pîiya. Moropai tiwinarî aawa'pi'ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mîrîrî era'ma'pî inenupa'sanya. Mîrîrî kure'ne teesenumenkai to' wanî'pî, mîrîrî taasa' Jesusya pî'. Moropai inkamoroya ta'pî: —Î' kai'ma see aawa'pi'ta mîrîrî ka'ne' pe? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mîrîrî taa to'ya ye'nen, Jesusya ta'pî: —Ayenku'tîuya'nîkon pepîn. Yairî tauya sîrîrî. Innape pu'kuru Paapa ku'to'ya'nîkon wanî ya yairî, mîîkîrî tîmu'tunpai pra, mîrîrî yei figo ye' pî' iku'sau'ya manni' warantî nîrî ikupîya'nîkon e'painon, innape iku'to'ya'nîkon wenai. Mîrîrî neken figo ye' pî' ikupîya'nîkon pepîn, tîîse seeni' wî' pî' taaya'nîkon ya: “Seeni' apata'se' yapai amo'takî, atîkî tuna ka”, taaya'nîkon ya, moropai “Esenunkî”, taaya'nîkon ya, innape iku'to'ya'nîkon wenai, mîrîrî e'kupî e'painon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","—Innape pu'kuru Paapa kupîi'ma esatîya'nîkon ya, eepîremakon pe anesatîkon yapisîya'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mîrîrî tîpo Jesus enna'po'pî Jerusalém pona. Miarî epîremanto' yewî' ta si'ma, pemonkonyamî' yenupaiya tanne, teepîremasanon esanon, moropai Judeuyamî' esanon erepamî'pî iipia. Moropai inkamoroya ekaranmapo'pî: —Anî' maimu pe see ko'manpara manni'kan yenpa'ka'pîya mîrîrî? Anî'ya ikupîpa taasa' mîrîrî apî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Inkamoro maimu yuuku'pî Jesusya: —Uurî nîrî amîrî'nîkon ekaranmapouya sîrîrî. Yairî ayekaranmapoto'konuya yuukuya'nîkon ya, uurî nîrî anî' maimu pe sîrîrî ye'ka unkupî ekaremekîuya apî'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Tarîpai yu'tî. Anî' maimu pe kin Joãoya tamî'nawîronkon yenpatakona'pî? Paapa maimu pe ka'rî, pemonkonyamî' maimu pe ka'rî? O'non ye'ka pe epu'tî pî' naatî? Mîrîrî taiya ye'nen to' eseurîma'pî tîîwarîrî'nîkon. —Inna Paapa maimu pe taasa' ya, uurî'nîkon ekaranmapoiya eserîke awanî. “Tîîse î' tonpe innape João Batista nurî'tî kupîya'nîkon pra awanîkon?” taiya eserîke awanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—Moropai pemonkon maimu pe taasa' ya, arinîkon pemonkonyamî'ya uurî'nîkon taruma'tî eserîke awanî. Maasa pra inkamoroya João Batista nurî'tî epu'tî'pî, Paapa maimu ekareme'nen pe awanî epu'tî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mîrîrî ye'nen inkamoroya Jesus maimu yuuku'pî: —Epu'tî annaya pra man —ta'pî to'ya. —Uurî nîrî anî' maimu pe seeni' ye'ka kupîuya ekaremekîuya pepîn —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesusya tiaron panton ekaremekî'pî. Ta'pîiya: —Î' ye'ka pe sîrîrî pî' eesenumenkakon eserîke awanî? Warayo' wanî'pî asakî'nankon inmukuyamî'. Mîîkîrîya ta'pî tînmu irui pî': “Unmu, sîrîrîpe umî ya' uva ye'kana' esenyaka'mai attî yu'se wanî sîrîrî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tîîse mîîkîrîya tîyun maimu yuuku'pî. “Itîîpai pra wai”, ta'pîiya. Tîîse mîrîrî tîpo awenpenata'pî moropai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Moropai itakon pî' ta'pî itunya irui pî' ta'pî tîuya warantî: “Inna, paapa, uutî”, ta'pîiya tîyun pî'. Tîîse attî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","O'non ye'ka inmuya itu'se tîyun e'to' yawîrî ikupî'pî? —ta'pî Jesusya. Moropai inkamoroya imaimu yuuku'pî: —Manni' iruiya ikupî'pî —ta'pî to'ya. Mîrîrî pî' ta'pî Jesusya: —Ayenku'tîuya'nîkon pepîn. Manni'kan tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masanon, moropai manni'kan wîri'sanyamî' tesa'kon ke tîwe'repasanon se' tapairî. Imakui'san, inkamoro ye'ka esa' pe Paapa iipî pe man amîrî'nîkon rawîrî innape pu'kuru ikupî to'ya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mîrîrî warantî João Batista nurî'tî iipî'pî pena yairon pu'kuru e'ma ekareme'se. Tîîse innape mîîkîrî nekaremekî'pî ku'sa'ya'nîkon pra awanîkon. Tîîse inkamoro tîniru yapi'nenanya innape pu'kuru ikupî'pî. Moropai wîri'sanyamî' se' tapaironkon, itesa' pînonya innape pu'kuru ikupî'pî. Teuren mîrîrî ye'ka era'ma tîpo, amîrî'nîkon enpenata pra aako'mamîkon imakui'pî rumaka pî' innape ikupîkonpa —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesusya ta'pî inî'rî: —Sîrîrî panton ekaremekîuya etatî —ta'pîiya. —Warayo'ya tekkari ye' ton uva ye'ka pîmî'pî mararî pra. Moropai mîrîrî iwatî'pîiya inonkon tî'kon ke. Moropai tî' yai uva yekku asu'kato' ton koneka'pîiya. Moropai kawînan koneka'pîiya ipo si'ma tamî'nawîron era'mato'pe tîpoitîrîtononya kai'ma. Inkamoro tînmîri era'manenan pî' ta'pîiya: “Seeni' uyekkari yonpa ke aye'mauya'nîkon” ta'pîiya. Mîrîrî ye'nen to' wîtî'pî moropai to' karaiwarî wîtî'pî tiaron pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mîrîrî tîpo itekkari emîrî pia'tî'pî. Mîrîrî ye'nen umî esa'ya tîpoitîrîtonon yarima'pî umî era'manenan pia tîmîrî ton tekkari yonpa era'mai. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tîîse inkamoro yapisî'pî umî era'manenanya. Moropai inkamoro taruma'tî'pî to'ya. Moropai tiaron po'pîtî'pî to'ya. Moropai tiaron ipoitîrî wî'pî to'ya. Moropai tiaron pona tî' yenunpîtî'pî to'ya. Mîrîrî warantî ikupî'pî to'ya ipoitîrîtonon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mîrîrî tîpo inî'rî tiaronkon yarima'pî umî esa'ya e'mai' pe to' yarima'pî tîuya yentai. Mîrîrî warantî rî ikupî'pî to'ya inkamoro yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mîrîrî warantî tamî'nawîrî ikupî tîpo umî esa'ya tînmu yarima'pî. Eesenumenka'pî maasa pra “mîserî unmu yarimasau'ya ya, î' kupî to'ya pepîn e'painon. Inama to'ya eserîke awanî”, ta'pî umî esa'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tîîse mîîkîrî umî esa' munmu era'ma tîuya'nîkon pe, inkamoro umî era'manenanya ta'pî: “A'kî, mîserî umî esa' munmu pî' î' ku'pai nai yarakkîrî”, ta'pî to'ya. “Iwîpai'nîkon uurî'nîkon pe sîrîrî umî eturumakato'pe itun sa'manta yai, inmu pe awanî namai”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mîrîrî ye'nen mîîkîrî, umî esa' munmu yapisî'pî to'ya yenpa'ka'pî to'ya umî yapai poro pona, moropai iwî'pî to'ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mîrîrî pî' to' ekaranmapo'pî Jesusya: —Î' pensa mîîkîrî umî esa' enna'po ya, î' kupîiya eserîke awanî inkamoro umî era'matîponkon warayo'kon yarakkîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Inkamoroya yuuku'pî: —Inkamoro warayo'kon tînmu wîîtîponkon tî'kaiya eserîke awanî. Mîrîrî tîpo tiaronkon warayo'kon eporîiya tînmîri era'matonkon. Moropai inkamoroya itekkari yonpa tîrî iipia, emîrî weiyu yai —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Inî'rî Jesusya to' ekaranmapo'pî. Ta'pîiya: —Paapa maimu e'menukasa' erenkasa'ya'nîkon pra kin naatî, î' taasai'ya? Sîrîrî warantî awe'menukasa': Wîttî konekanenanya tî' yenumî'pî, seeni' tî' wanî morî pe pra taa tîuya'nîkon ye'nen. Tîîse mîrîrî to' newanmîrî'pî tî' wanî'pî morî pe pu'kuru tiaronkon tî'kon to' nîmenka'pî yentai. Mîrîrî kupî'pî Uyepotorîkonya. Moropai morî pe pu'kuru awanî anna pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tarîpai tauya sîrîrî amîrî'nîkon Judeuyamî' piapai imo'ka Paapaya tîpemonkono pe pu'kuru awanîkon namai. Moropai tiaronkon esa' pe eena. Manni'kan se' tapairî innape iku'nenan pepîn pia, Paapa maimu yawîrî tîîko'mansenon pia itîrîiya, to' esa' pe tîwe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Anî' atare'mo ya manni' tî' pona, mîîkîrî ma'ta mîrîrî. Tîîse manni' tî' ena ya ipona, mîîkîrî yankaiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mîrîrî taa Jesusya eta'pî teepîremasanon esanonya moropai fariseuyamî'ya. Mîrîrî epu'tî'pî to'ya, tîpî'nîkon Jesus eseurîma pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mîrîrî ye'nen Jesus yapisî tîuya'nîkon pî' to' esenumenka'pî. Tîîse arinîkon rawîrî si'ma ikupî to'ya pra awanî'pî maasa pra eranne' pe to' wanî'pî. Maasa pra pemonkonyamî'ya Jesus epu'tî'pî, Paapa maimu ekareme'nen pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusya inî'rî panton ekaremekî'pî pemonkonyamî' nepu'tî tonpe. Ta'pîiya: ");
INSERT INTO mbcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Tamî'nawîronkon esa' pe Paapa iipî yai awanî pe man sîrîrî panton warantî. Ipîkku pata esa' pe, rei pe tîwe'sen tînmu e'marimato' festarî koneka pî' awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mîîkîrîya tîpoitîrîtonon yaipontî'pî to' wîtîto'pe pemonkonyamî' yannoi to' ii'to'pe tînmu festarî pî'. Tîîse inkamoro to' neta'san iipî pra awanî'pî. Ii'pai pra to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Moropai inî'rî tiaronkon tîpoitîrîtonon yarima'pîiya tîmaimu yaato'pe to'ya to' pia: “Makatîi to' pî'”, ta'pîiya. “ ‘Tamî'nawîrî ekonekasa' man festa yainon tonpe, taa pî' man’, makatîi. ‘Paakayamî' kaiwankon tî'kasau'ya wai, taa pî' man’ makatîi. ‘Tamî'nawîron konekasai'ya man. Mîrîrî ye'nen asi'tî festa pona’, makatîi” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Tîîse innape nai, taa to'ya pra ineta'san wanî'pî. Mîrîrî ye'nen puwana pî' tîwe'to'kon pî' to' wîtî'pî. Tiaron wîtî'pî tekînon pata'se' ya' to' era'mapî'se. Moropai tiaron wîtî'pî temanne yewî' pe tînkoneka'pî ya' ekaya pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Moropai tiaronkonya inkamoro ipîkku poitîrîtonon yapisî'pî moropai to' po'pîtî'pî to'ya. Moropai to' wî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mîrîrî pî' mîîkîrî ipîkku rei ekore'ma'pî mararî pra. Inkamoro tîpoitîrîtonon wîîtîponkon tî'ka me'po'pîiya moropai to' pata cidade po'tî me'po'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mîrîrî tîpo inî'rî tîpoitîrîtonon yanno'pîiya moropai ta'pîiya to' pî': “Manni'kan uneta'san iipî pra man maasa pra î' pe pra rî to' wanî ye'nen” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Tarîpai atîtî seeni' e'makon taawîrî. Moropai tamî'nawîrî pemonkonyamî' eporîya'nîkon pîkîrî to' metatîi” ta'pîiya tîpoitîrîtonon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Moropai ipoitîrîtonon wîtî'pî e'makon taawîrî. Inkamoroya to' eta'pî tamî'nawîrî to' eporî tîuya'nîkon kaisarî. To' muurukuntî'pî to'ya. Morîkon pemonkonyamî' moropai îrirîkon pemonkonyamî'. Inkamoroya mîrîrî to' pata'se' pe ikonekasa' yannîpî'pî. Intapîkîrî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mîîkîrî ipîkku epa'ka'pî inkamoro etasa'kon erepansa' era'mai. Moropai mîrîrî to' pata'se' pe tînkoneka'pî ya' eewomî'pî. Miarî warayo' era'ma'pîiya festa pî' tîwanî pon ya' pra tîwe'sen maasa pra tiwin to' pon wanî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Moropai mîîkîrî yekaranmapo'pîiya: “Uwanîyakon, o'non ye'ka pe eewonsa' sîrîrî tarîwaya, festa pî' awanî pon teka'mai pra?” ta'pîiya. Tîîse imaimu yuukuiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mîrîrî ye'nen mîîkîrî ipîkku reiya ta'pî tîpoitîrîtonon pî': “Mîserî warayo' yewa'tîtî i'pu pî' moropai itenya pî'. Moropai yenuntî poro pona, ewaron pe tîwe'sen ya', o'non pata karawannîto' pata'se' ya'. Mîîkîrî karawato'pe, tee ye'kaiya mararî pra ne'ne' pe tîwanî ye'nen”, ta'pî ipîkkuya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Moropai Jesusya teeseurîmato' yaretî'ka'pî. Ta'pîiya: —Tu'ke etasa'kon pemonkonyamî' wanî sîrîrî Paapa pia aako'mamîtonkon. Tîîse tu'kankon iipî pepîn Paapa pia yairî inkamoro yapi'to'peiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mîrîrî tîpo fariseuyamî' epa'ka'pî moropai inkamoroya teserukon koneka'pî, î' kai'ma Jesus anapi'pai tîwanîkon pî', iiwanmîra teeseurîmakonpa kai'ma ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mîrîrî ye'nen tiaronkon warayo'kon yarima'pî to'ya î' kupî Jesusya era'matonkon. Moropai inkamoro pokonpe pata esa' Herodes pemonkonoyamî' wîtî'pî Jesus ekaranmapopî'se. Ta'pî to'ya: —Anna yenupanen, yairon pe pu'kuru amîrî wanî epu'tî pî' anna man —ta'pî to'ya. —Maasa pra yairon Paapa maimu ke yenupaton pe awanî ye'nen. Moropai tiaronkon pemonkonyamî'ya taa ya apî': “Mîrîrî warantî kîseurîmai”. Mîrîrî taa to'ya pî' tîpîinamai tîwe'sen pepîn amîrî. Maasa pra se' kaisarî pemonkonyamî' pî' tîwe'sen amîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—Mîrîrî ye'nen î' kai'ma epu'tî pî' nan? Yairî awanî ka'rî, kaane ka'rî, yairî pra awanî? Uyesa'kon pe tîwe'sen Romanoyamî' esa' César ye'ma annaya ya? ");
INSERT INTO mbcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tîîse Jesusya î' anku'pai to' wanî tarakkîrî epu'tî'pî. Moropai ta'pîiya to' pî': —Seru'ye'kon amîrî'nîkon. Aawarîrî'nîkon teesenku'tîsanon morî pe tîwanîkon kai'ma. Î' wani' awanî ye'nen uuwanmîra uurî anapi'pai awanîkon mîrîrî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moropai ta'pîiya: —Moriya mîrîrî ye'mato'ya'nîkon ene'tî uupia era'mato'peuya —ta'pîiya. Mîrîrî enepî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Moropai inkamoro yekaranmapo'pîiya: —Anî' ese' mîserî? Anî' yekaton sîrîrî pîrata ena'pî pî'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Inkamoroya yuuku'pî: —Romanoyamî' esa' César ese' —ta'pî to'ya. Mîrîrî taa to'ya ye'nen, Jesusya ta'pî: —Moriya itîîkî iipia, imîrî pe awanî ye'nen, î' ta'pî Césarya yawîrî iku'tî. Moropai î' ku'tî ta'pî Paapaya yawîrî nîrî iku'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mîrîrî taa Jesusya pî' to' esenumenka'pî mararî pra teesenumenkai, î' taiya eta tîuya'nîkon pî'. Mîrîrî ye'nen Jesus piapai to' wîtî'pî. Î' kupî to'ya pra awanî'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mîrîrî yai saduceuyamî' wîtî'pî Jesus pia. Inkamoro esenumenkato' wanî'pî isa'manta'san e'mî'sa'ka pepîn taawonan pe. Mîrîrî ye'nen isa'manta'san e'mî'sa'ka pepîn taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Moropai inkamoroya ta'pî Jesus pî': —Anna yenupanen, pena Moisés nurî'tîya anna yenupa'pî see warantî —ta'pî to'ya. —Tiwin warayo' no'pîta, tîîse tînmu ton tepose pra aasa'manta mîîkîrî no'pîrî'pî e'nîmî. Mîîkîrî yarakkîrî itakono'pî wanî e'pai awanî —ta'pîiya. —Moropai more yan pe tîrui no'pîrî'pî enasa' ya, tînre ton yenpoiya. Mîîkîrî more pî' urui munmu'pî taiya, tînmu pe tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Moro to' man anna kore'ta asakî'ne mia' pona tîîmo'tai kaisarî warayo'kon. To' ruinankon no'pîta'pî, tîîse aasa'manta'pî inmu ton pra si'ma. Mîîkîrî no'pî rî'pî yarakkîrî itakono'pî wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tîîse mîrîrî warantî rî mîîkîrî nîrî sa'manta'pî inmu ton pra tîîse. Moropai to' eseurîno yarakkîrî mîrîrî warantî awanî'pî. Moropai tamî'nawîrî to' sa'manta'pî inmuku pra to' tîîse. Inkamoro sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mîrîrî tîpo wîri' nîrî sa'manta'pî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mîrîrî ekaranmapo'pî saduceuyamî'ya Jesus pî'. Ta'pî to'ya: —Inkamoro warayo'kon e'sa' asakî'ne mia' pona tîîmo'tai kaisarî mîîkîrî wîri' yarakkîrî. Tamî'nawîronkon e'mî'sa'ka yai o'non ye'ka warayo' no'pî pe awanî kupî sîrîrî? —ta'pî to'ya. —Maasa pra tamî'nawîrî yarakkîrî to' e'sa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesusya to' maimu yuuku'pî: —Aka, eesenku'tîsa'kon mîrîrî, î' taasa' Paapa maimu e'menukasa'ya epu'tîya'nîkon pra naatîi. Meruntî ke Paapa wanî epu'tîya'nîkon pepîn mîrîrî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A'kî, isa'manta'san e'mî'sa'ka yai tîno'pî ke anî' wanî pepîn. Maasa pra mîrîrî to' wanî inserîyamî' warantî, ka' ponkon warantî. Mîrîrî ye'nen tîno'pî ke to' wanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tîîse isa'manta'san e'mî'sa'kato' pî' Paapa eseurîmapîtî'pî pena. Mîrîrî erenkasa'ya'nîkon pra naatî? See warantî ta'pî Paapaya: ");
INSERT INTO mbcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Uurî Paapa, Abraão nurî'tî yepotorî, moropai Isaque nurî'tî yepotorî. Moropai Jacó nurî'tî yepotorî pe wanî”, ekaremekî'pîiya. Sa'mantasa' pe inkamoro ko'mamî pepîn ipatîkarî. Paapa wanî enen tîîko'mansenon yepotorî pe. Isa'manta'san yepotorî pe pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mîrîrî taa Jesusya eta tîuya'nîkon pe, arinîkon pemonkonyamî' wanî'pî teesenumenkai mararî pra, î' kai'ma to' yenupatoi'ya pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mîrîrî tîpo fariseuyamî' eperepî'pî Jesus pia. Maasa pra saduceuyamî' tî'napamî emapu'tîsai'ya ye'nen, to' iipî'pî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Warayo' epu'nen Moisés nurî'tîya yenupanto' pî' yenupaton iipî'pî iipia maasa pra seru'ye' pe Jesus eseurîma anepu'pai awanî'pî. Mîrîrî ye'nen Jesus ekaranmapo'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Anna yenupanen, o'non wanî mîrîrî ipîkku pe panpî' unkupîkon ton pe Paapa nekaremekî'pî pe? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusya yuuku'pî: —Ayepotorî Paapa yapurîkî tamî'nawîrî ayewan ke, moropai tamî'nawîrî ayekaton ke. Moropai tamî'nawîrî eesenumenkato' ke —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Mîrîrî wanî e'mai'non, ipîkku pe itu'se Paapa e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Moropai itakon moro wanî manni' e'mai'non warantî rî. Taiya: Ayonpa sa'namakî kure'ne aawarîrî amîrî e'sa'nama manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mîrîrî warantî mîrîrî asakî'nan yawîrî ku'sa'ya'nîkon ya, tamî'nawîron sîrîrî Moisés nurî'tî nekaremekî'pî yawîrî awanîkon. Moropai penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'tî nekaremekî'pîya taasa' yawîrî awanîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Moropai fariseuyamî' emurukuntîsa' tanne, Jesusya to' ekaranmapo'pî: ");
INSERT INTO mbcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Î' kai'ma see eesenumenkakon mîrîrî mîîkîrî Paapa nîmenka'pî pî'? Anî' paarî'pî pe awanî mîrîrî? —ta'pîiya. —Davi nurî'tî paarî'pî mîîkîrî —ta'pî to'ya ipî'. Moropai inî'rî to' ekaranmapo'pî Jesusya: ");
INSERT INTO mbcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Î' wani' awanî ye'nen kin Davi nurî'tî eseurîma'pî Paapa nîmenka'pî pî' pena? Morî Yekaton Wannîya eeseurîma emapu'tî'pî. “Uyepotorî” ta'pîya. Davi nurî'tî maimu rî'pî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Uyepotorî pî' Paapaya ta'pî: “Uupia ereutakî umeruntîri winîkîi ayeyatonon yaretî'kauya pîkîrî” ta'pîiya ta'pî Daviya, sîrîrî imaimu. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","A'kî, Davi paarî'pî pe neken Paapa nîmenka'pî wanî ya. Î' wani' awanî ye'nen Uyepotorî taa Daviya ipî', manni'? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mîrîrî taa Jesusya yuuku to'ya pra to' wanî'pî. Moropai mîrîrî patapai inî'rî Jesus anekaranmapopai pra to' ena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesusya tînenupa'san pî' ta'pî moropai arinîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ta'pîiya: —Insamoro Moisés nurî'tîya yenupanto' pî' yenupatonkon, moropai fariseuyamî' esenyaka'ma amîrî'nîkon yenupa pî', Moisés nurî'tîya ikupî'pî manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mîrîrî ye'nen to' maimu yawîrî e'pai awanîkon. Moropai tamî'nawîrî ayenupato'kon to'ya yawîrî e'pai awanîkon. Tîîse to' nîkupî, to' yeseru kî'ku'tî. Maasa pra ayenupa'pîkon tîuya'nîkon yawîrî pra to' ko'mamî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A'kî, pemonkonyamî' narîton amîi'ne pe pu'kuru tîwe'sen ewa'tî to'ya. Tîîse mîrîrî yarî pî' to' pîika'tî to'ya pepîn, mararî tenyakon yeperu yaretî ke. Mîrîrî warantî to' yenupato' to'ya pî' Jesus eseurîma'pî. ˻Maasa pra ta'pî tîuya'nîkon yawîrî ikupî to'ya pra awanî ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Moropai ta'pîiya: —Mîrîrî ye'ka kupî to'ya maasa pra tamî'nawîronkon pemonkonyamî'ya tera'makon yu'se to' wanî ye'nen. Maasa era'matî, Paapa maimu e'menukasa' menukapîtî to'ya moropai mîrîrî yewa'tî to'ya tepinkon pî' moropai temekonkon pî' eesera'mato'pe kai'ma. Moropai tîponkon sonpan ye'pi kupî to'ya kusan pe, mîî pe tîwanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Moropai inkamoroya festa weiyu yai, teereutato'kon ton morî apono' menka. Moropai epere'nîto' yewî' ta nîrî, morî menka to'ya tapurîto'kon pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Moropai inkamoro wanî tamî'nawîronkon esekaremekî yu'se, aronne panpî'. Moropai uyenupanen kai'ma tesatîkon to'ya yu'se to' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tîîse inkamoro warantî “Uyepotorî” kai'ma ayonpakon esatîya'nîkon e'pai pra man. Maasa pra tamî'nawîronkon amîrî'nîkon wanî se' warantî, e'kaisarî ayonpakon pokonpe. Maasa pra Ayepotorîkon moro man tiwinan. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Moropai tarî non po anî'rî esatîya'nîkon e'pai pra man Paapa anna yunkon kai'ma. Maasa pra amîrî'nîkon yunkon moro man, tiwinan neken ka' pon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","—Moropai anî' esatîya'nîkon e'pai pra man e'mai'non mîîkîrî tamî'nawîronkon ye'mai'norî taaya'nîkon e'pai pra man. Maasa pra amîrî'nîkon ye'mai'norî moro man tiwinan, Cristo mîîkîrî, Paapa nîmenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maasa pra anî' wanî ya amîrî'nîkon kore'ta ipîkku panpî' e'pai awanî apoitîrî pe tiaronkon ma're. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Anî' wanî ya tiaronkon yentai e'pai mîîkîrî kupî Paapaya to' ma're. Moropai anî' wanî ya tiaronkon ma're e'pai, mîîkîrî kupî Paapaya tiaronkon yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Aka tîwarî e'tî, amîrî'nîkon Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai fariseuyamî'. Seru'ye'kon amîrî'nîkon! Pemonkonyamî' ma'nîpanenan pe awanîkon Paapa pemonkono pe to' ena namai. Ayesa'kon pe Paapa kupîya'nîkon pepîn moropai tiaronkonya ikupî tîrîya'nîkon pepîn. Maasa pra to' yenupaya'nîkon yairî pra. Mîrîrî wenai ataruma'tîkon Paapaya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aka tîwarî e'tî, Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai fariseuyamî' morî pe tîwe'ku'senon pe awanîkon seru'ye' pe. Maasa pra inyo isa'manta'san wîri'sanyamî' yama'runpapîtîya'nîkon ama' pe. Moropai mîrîrî si'ma eepîremapîtîkon kure'ne kusan pe tiaronkonya ayera'mato'konpe. Mîrîrî wenai tiaronkon yentai awe'taruma'tîkon kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Aka tîwarî e'tî, Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai fariseuyamî'. Seru'ye'kon teesenku'tîsanon. Attîpîtîkon patakon kaisarî, moropai erenkon ratai poro. Mîrîrî yai tiaronkon anku'pai awanîkon ayeserukon warantî to' e'to'pe. Tîîse ayeserukon ya' eena'pî wanî imakui'pî ku'nen pe ayentai'nîkon. Mîîkîrî yenumî Paapaya apo' ya' emapu'tîya'nîkon mîrîrî warantî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Aka tîwarî e'tî. Maasa pra enkaru'nan warantî si'ma tiaronkon ye'mai'norî pe e'pai awanîkon ye'nen. To' yenupaya'nîkon sîrîrî warantî: “Anî'ya taa ya, ‘Epîremanto' yewî' winîkîi mîrîrî kupîuya pe wai’, taiya ya, tîîse mîrîrî kupîiya pra awanî ya, î' wani' awanî pepîn kai'ma. Moropai taa tiaronya ya ‘Ouro epîremanto' yewî' tawon winîkîi mîrîrî kupîuya’ taiya ya, ikupîiya e'pai awanî mîrîrî”. Kai'ma to' yenupaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pakkokon, î' epu'nenan pepîn, enkaru'nankon amîrî'nîkon. Î' wanî ipîkku pe tîwe'sen, ouro ou epîremanto' yewî' ka'rî ipîkku pe tapurîsen? Epîremanto' yewî' wanî ipîkku pe panpî' maasa pra Paapa yewî' pe awanî ye'nen. Moropai mîrîrî ouro wanî imîrî pe maasa pra itewî' ta awanî ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Moropai amîrî'nîkonya tiaronkon yenupapîtî taapîtîya'nîkon. Anî'ya taa ya, taransen mîrîrî altar winîkîi ikupîuya taiya ya moropai ikupîiya pra awanî ya, î' wani' awanî pepîn kai'ma taaya'nîkon. Tîîse altar po tîwe'sen itîîsa' winîkîi ikupîuya taiya ya, tîwî ikupîiya e'pai pra awanî kai'ma to' yenupaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Epu'nenan pepîn, amîrî'nîkon enkaru'nankon warainonkon. Î' wanî ipîkku pe tîwe'sen? Mîrîrî to' naranî'pî yaponse' ou ipo manni' taransen? Mîrîrî to' naranî'pî yaponse' wanî Paapa yemanne pe, moropai ipo manni' taransen wanî imîrî pe nîrî, itemanne po awanî ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Mîrîrî ye'nen anî'ya taa ya taranse yaponse' altar winîkîi ikupîuya taiya ya. Tamî'nawîron taransen ipo manni' winîkîi taiya nîrî. ˻Mîrîrî ye'nen ikupîiya e'pai awanî mîrîrî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Moropai anî'ya taa ya epîremanto' yewî' winîkîi ikupîuya taiya ya, mîîkîrîya taa nîrî mîrîrî epîremanto' yewî' tawon, Paapa winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Moropai anî'ya taa ya, ka' winîkîi ikupîuya taiya ya, Paapa yaponse' eereutato' winîkîi taiya nîrî moropai Paapa ereutasa' manni' winîkîi taiya nîrî. ˻Mîrîrî ye'nen î' ta'pî tîuya yawîrî ikupîiya e'pai awanî mîrîrî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aka tîwarî e'tî amîrî'nîkon Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai fariseuyamî'. Maasa pra awe'taruma'tîkon kupî sîrîrî. Yairî Paapa yapurîya'nîkon kai'ma tamî'nawîrî antîrîkon ke Paapa repaya'nîkon, ayo'kon wosi yonpa ke nîrî irepaya'nîkon. Tîîse morî panpî' ankupîkon ton pe ta'pî kupîya'nîkon pepîn, tiaronkon winîkîi yairî pra awanîkon ye'nen moropai to' sa'namaya'nîkon pra awanîkon ye'nen. Î' taasa' Paapaya yawîrî kupîya'nîkon pra awanîkon ye'nen. Tîîse tamî'nawîrî mîrîrî kupî'pîya'nîkon e'painon tîwî ankupî'pîkon manni' tîku'se pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tiaronkon ye'mai'norî pe e'pai awanîkon enkaru'nan warantî si'ma. Maasa pra kankî'yamî' enasa' yainonkaya'nîkon awukukon ya' warantî tamî'nawîrî antîrîkon ke Paapa repaya'nîkon si'mîrikkî pe tîwe'sen ke nîrî. Tîîse kankî' yentainon kameru warainon kure'nan yenno'maya'nîkon, maasa pra ipîkku pe panpî' ankupîkon ton Paapa nekaremekî'pî kupîya'nîkon pepîn, tîîse mararî mîrikkî neken kupîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aka tîwarî e'tî, amîrî'nîkon Moisés nurî'tîya yenupanto' pî' yenupatonkon, moropai fariseuyamî'. Seru'ye'kon. Awe'taruma'tîkon pe naatîi. Apisaukon ronapîtîya'nîkon poroporo neken, morî pe eesera'mato'pe kai'ma. Tîîse ita nura awanî tanne. Mîrîrî ta'pî Jesusya to' yeseru ekaremekîpa kai'ma. Maasa pra to' esenumenkato' ya' wanî imakui'pî nura pe awanî mararî pra. Kure'ne temannekon ton yu'se to' wanî moropai itu'se tîwe'to'kon yawîrî e'pai to' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mîrîrî ye'nen fariseuyamî' enkaru'nankon, e'mai' pe apisaukon ronatî ita, morî pe awe'to'pe. Morî pe ita wanî ya, poroporo nîrî morî pe eesera'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aka tîwarî e'tî, fariseuyamî' moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon. Seru'ye'kon amîrî'nîkon wanî penaron uuruwai kî'pasa' iporo aimutun pe warantî. Iporo morî pe pu'kuru eesera'ma. Tîîse ita, itu'na mararî pra pemonkonyamî' ye'pî rî'pî wanî. Moropai mîrîrî wanî ikî pe pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mîrîrî warantî amîrî'nîkon esera'ma morî pemonkon warantî. Tîîse ayewankon ya' nura wanî mararî pra. Seru'ye' wanî moropai tu'kan imakui'pî ku'to'ya'nîkon wanî mararî pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Aka tîwarî e'tî fariseuyamî' moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon. Seru'ye'kon amîrî'nîkonya penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'tî uuruwasi ton koneka'pî morî pe pu'kuru, inkamoro yairî ko'mamî'san yapurîya'nîkon kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Moropai taaya'nîkon: “Pena inkamoro wîîtîponkon anna tamorî'san yai anna e'sa' ya, inkamoro Paapa maimu ekareme'nenan profetayamî' nurî'tî wî'pî annaya pepîn e'painon, to' wî'pî to'ya warantî. Mîrîrî iku'sa' to'ya manni' warantî ikupî'pî annaya pepîn e'painon”, taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Anna tamorî'san taaya'nîkon wenai, inkamoro profetayamî' wîîtîponkon payanî'san anna, taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mîrîrî ye'nen mîrîrî warantî to' yeserurî'pî pî' ako'mantî yaretî'kaya'nîkon pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mîrîrî ye'nen amîrî'nîkon wanî îkîi ye'katon munkîyamî' warantî. Îkîiyamî' pe awanîkon. Tîîse î' kai'ma Paapaya apo' ya' ayenunto'kon winîpai e'pîika'tîpai awanîkon mîrîrî? Awe'pîika'tîkon pepîn tiwin kin. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mîrîrî ye'nen apî'nîkon umaimu ekareme'nenan yarimauya kupî sîrîrî warayo'kon epu'nenan, moropai yenupatonkon. Tîîse inkamoro yonpa wîîya'nîkon kupî sîrîrî. Moropai tiaron pokapîtîya'nîkon kupî sîrîrî pakî'nan pona. Moropai tiaronkon po'pîtîya'nîkon kupî sîrîrî epere'nîto' yewî'kon ta. Moropai to' pokonomaya'nîkon kupî sîrîrî to' patakon cidade kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mîrîrî kupîya'nîkon wenai ataruma'tîkon Paapaya kupî sîrîrî. Tîîse ankupî'pîkon neken wenai pra tîîse penaronkon nîkupî'pî wenai awe'taruma'tîkon, tamî'nawîronkon morîkon to' nîwî'san penaro' Abel nurî'tî wî'pî irui Caimya patapai, moropai Paapa maimu ekareme'nen Baraquias munmu, profeta Zacarias nurî'tî wî'pî to'ya pîkîrî. Manni' anwî'pîkon Paapa ton pe to' nîpo'tî yaponse' yarappana. Paapa yewî' ta teepîremasanon neken wîtîto' pata iwî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ayenku'tîuya pepîn, mîrîrî tamî'nawîron ku'sa' to'ya wenai amîrî'nîkon, sîrîrî pankon pemonkonyamî' taruma'tî Paapaya kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesusya tîmaimu yaretî'ka'pî see warantî Jerusalém ponkon pemonkonyamî' pî': —Amîrî'nîkonya umaimu ekareme'nenan wî'pî. Moropai tî' ke tiaronkon pa'tîpîtî'pîya'nîkon, umaimu ekareme'se unaipontî'san. Î' warapo ite'ka amîrî'nîkon muurukuntî yu'se wanî'pî tamî'nawîrî, kariwanaya tînmukuyamî' muurukuntî tapî'sa' yo'koi warantî. Tîîse itu'se pra awanî'pîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'kî, tarîpai apatakon ena kupî sîrîrî itesa' pra. Yawon pra eena pe man. Maasa pra Paapaya ataruma'tîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tauya sîrîrî apî'nîkon. Sîrîrî patapai inî'rî uyera'maya'nîkon pe pra naatîi. Uyapurîto'ya'nîkon weiyu erepamî pîkîrî aako'mamîkon. Mîrîrî yai neken, taaya'nîkon “Mîîkîrî morî Uyepotorîkon ese' pî' tui'sen yapurîpai'nîkon”, taaya'nîkon kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Epîremanto' yewî' tapai teepa'kakon pe, aasarî tuutîkon ye'ka pe, Jesus nenupa'san erepamî'pî iipia. Moropai inkamoro eseurîma'pî wîttî, epîremanto' yewî' konekasa' pî'. Maasa pra morî pe pu'kuru awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesusya to' maimu yuuku'pî. Ta'pîiya: —Ayenku'tîuya pepîn. Seeni' wîttî kure'nan era'ma pî' naatî? Tîîse aako'mamî pepîn kupî sîrîrî. Maasa pra tiaronkonya yaranka to' weiyu erepamî yai. Tamî'nawîrî isoroka to'ya tiwinan tî' e'nîmî pepîn tonpa po. Tîîse tamî'nawîrî yenumî to'ya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mîrîrî tîpo Oliveira ye'ka kîrî po, Jesus ereutasa' wanî'pî. Mîrîrî tanne inenupa'san erepamî'pî iipia, tiaronkon ton pra tîîse. Moropai Jesus ekaranmapo'pî to'ya: —O'non ye'ka pe mîrîrî e'kupî kupî sîrîrî? O'non ye'ka pe mîrîrî kupî to'ya epu'tî annaya e'painon? Î' esera'ma wenai aminke pra aai'to'pe wanî moropai tamî'nawîron e'tî'ka epu'tî annaya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesusya to' maimu yuuku'pî: —Tîwarî e'tî aka, anî'ya ayenku'tîkon namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maasa pra tu'kankon asarî kupî sîrîrî uyese' pî' teeseurîmasanon pe tîwe'ku'se. Moropai taa to'ya: “Uurî Cristo, Paapa nîmenka'pî”, taa to'ya. Moropai mîrîrî taa to'ya pî' tu'ke pemonkonyamî' esenku'tî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Moropai pemonkonyamî' eseya'namato' etaya'nîkon pî' teesi'nî'se pra me'tîi moropai teepîsanon yekare etaya'nîkon ya. Tamî'nawîrî mîrîrî ye'ka e'kupî kupî sîrîrî, tîîse maasa pata ataretî'ka pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pemonkonyamî' eseya'nama tiaron pata ponkon yarakkîrî. Moropai pemonkonyamî' esanon eseya'nama tiaronkon esanon yarakkîrî. Moropai pata eserentîkî'ma kupî sîrîrî tiaron pata poro. Mîrîrî yai emi'nan wanî kupî sîrîrî pata po. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sîrîrî ye'ka e'kupî kupî sîrîrî manni' e'mai'non ne'ne' epu'tî more yan pe tîwe'sen wîri'ya warantî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Mîrîrî yai tiaronkonya ayapisîkon kupî sîrîrî tesanonkon pia. Ayarîkon to'ya atarumatîto'kon pe to'ya. Moropai inkamoroya amîrî'nîkon wîî. Moropai tamî'nawîronkonya amu'tunpakon uurî yapurîya'nîkon wenai. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mîrîrî yai tu'kankon uyapurînenanya uyapurîto' tîuya'nîkon kupî tîwî. Maasa pra innape ukupî to'ya pra to' enasa' ye'nen, tiaronkon yewanmîrînenan pe to' wanî kupî sîrîrî. Moropai tonpakon rumaka to'ya kupî sîrîrî teeyatonon yenya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mîrîrîya Paapa maimu ekareme'nenan, profetayamî' pe tîwe'ku'sanon seru'ye'kon esenpo kupî sîrîrî pemonkonyamî' yenku'tîi. Inkamoroya tu'ke to' yenku'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mîrîrî warantî imakui'pî e'paraipîka kupî sîrîrî ka'ne' pe. Mîrîrî wenai mararonkon pepîn innape Paapa yapurînenanya Paapa yapurîto' tîuya'nîkon yenomî inî' to' enpenata pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tîîse tamî'nawîron mîrîrî ye'ka yapîtanîpîtîpon wanî ya ikî'pî tîpose, mîîkîrî pîika'tîsa' Paapaya mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Moropai mîrîrî yai î' kai'ma pemonkonyamî' esa' pe Paapa wanî esekaremekî kupî sîrîrî tamî'nawîrî pata poro. Tamî'nawîronkon pemonkonyamî'ya eta kupî sîrîrî uyekare pî'. Moropai mîrîrî yai tamî'nawîron e'tî'ka weiyu erepamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Moropai Jesus eseurîma ko'mannîpî'pî: —Penaro' Paapa maimu ekareme'nen Daniel nurî'tî eseurîma'pî. “Tamî'nawîronkon yewanma pe tîwe'sen imakui'pî, Paapa newanma pe tîwe'sen tîrî tiaronkonya epîremanto' yewî' ta. Mîrîrî ye'ka pata'se' pepîn ya' itîrî to'ya”, ta'pî Daniel nurî'tîya. Mîrîrî era'maya'nîkon yai, epu'tîya'nîkon yu'se wai î' taato'pe awanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mîrîrî ye'nen anî' wanî ya Judéia pata po, ka'ne' pe eepe e'pai awanî wî' pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Moropai anî' wanî ya tewî' po ka'ne' pe awautî e'pai awanî moropai eepe e'pai awanî, tewî' ta temanne era'mai teewonse pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Moropai anî' wanî ya keren po mîîkîrî enna'po e'pai pra wanî tewî' ta tîponkon era'mai, tîîse eepe e'pai awanî ka'ne' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mîrîrî yai aka sa'ne wîri'sanyamî' more yankon moropai mana'pokonkon to' munkîyamî'. Inkamoro e'taruma'tî kupî sîrîrî mararî pra maasa pra ka'ne' pe to' epe eserîke pra to' wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mepîrematîi Paapa pî' maasa pra kono' yai mîrîrî ye'ka e'kupî namai. Moropai erî'ka'nîto' weiyu yai awe'kupî namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maasa pra kure'nan e'taruma'tînto' iipî kupî sîrîrî. Paapaya pata koneka'pî patapai esera'ma'pî pepîn e'kupî kupî sîrîrî ikaisaron ton pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tamî'nawîronkon e'taruma'tî kupî sîrîrî mararî pra. Tîîse Paapaya ipîra to' e'taruma'tîto' yaretî'ka kupî sîrîrî maasa tînku'ne'tî'pî weiyu eseporî pra tîîse. Mîrîrî ku'sai'ya pra awanî ya enen anî' ko'mamî pepîn e'painon. Tîîse Paapaya tînmo'kakon pînînma kure'ne tîpemonkono pe to' wanî ye'nen. To' yaretî'ka e'taruma'tînto'ya tîrîiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mîrîrî ye'nen anî'ya taa ya apî'nîkon: “Paapa nîmenka'pî Cristo tarî man”, taiya ya, innape mîîkîrî maimu kî'ku'tî. Moropai “Siini' pata man”, taa to'ya ya apî'nîkon, innape inkamoro ye'ka maimu kî'ku'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maasa pra seru'ye'kon iipî, uurî pe tîwe'ku'sanon, Paapa maimu ekareme'nenan pe tîwe'ku'se to' iipî. Inkamoroya anî' nîkupî eserîkan pepîn kupî pemonkonyamî' nera'makon ton kupî, to' yenku'tîkonpa kai'ma. Mîrîrî wenai tamî'nawîronkon yenku'tî to'ya e'painon Paapa nîmenka'san nîrî to' yenku'tî to'ya tîrî Paapaya ya. Tîîse itîrîiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tîîse mîrîrî rawîrî apî'nîkon ekaremekî pî' wai epu'tîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Mîrîrî ye'nen anî'ya taa ya apî'nîkon: “A'kî, sinpata man keren po”, taiya ya, era'mai katîtî. Inî'rî taa anî'ya ya apî'nîkon: “A'kî, tarî man eesenonsa'”, taa to'ya ya, innape to' maimu kî'ku'tî ayenku'tîkon to'ya pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maasa pra uurî ka' poinon ii'to' wanî kupî sîrîrî aronne ama' pe pra. E'winî pairî ka' pî' wara'napi e'sisiuka esera'ma manni' warantî tamî'nawîronkonya era'ma uuipî yai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","—A'kî, o'non pata anî' sa'mantasa' ya, mîîkîrî pî' watunaiyamî' emurukuntîsa' wanî. Mîrîrî warantî uurî iipî inkamoro imakui'pî ku'nenan kore'ta apo' ya' to' yenunto'peuya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesusya ta'pî inî'rî: —Mîrîrî yai tamî'nawîronkon e'taruma'tî'pî tîpo, wei esi'nîpî kupî sîrîrî. Moropai kapoi ena kupî sîrîrî a'ka pe pra. Moropai siirikkîyamî' e'soroka kupî sîrîrî. Moropai tamî'nawîrî ka' pî' tîwe'sanon e'tîtîtî'ka kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mîrîrî tîpo ka' poi iipî'pî pemonkon pe era'ma tamî'nawîronkon pemonkonyamî'ya. Uuipî katupuru kore'ta a'ka pe ka' winîpai. Mîrîrî yai tamî'nawîrî pata ponkon karau kupî sîrîrî mararî pra. Maasa pra meruntî ke uuipî a'ka pe, wei warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mîrîrî yai kure'nan usinarî ye'nunpa pe upoitîrîtonon inserîyamî' yarimauya upemonkono pe umenka'san muurukuntîi. Tamî'nawîrî patakon kaisarî to' wîtîto'pe upemonkono pe umo'ka'san era'mai sîrîrî non po —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Moropai inî'rî ta'pî Jesusya: —Sîrîrî figo ye' yekare pî' esenupatî. E'mai' pe aarenta. Moropai eepantakasa' ya, aareta. Mîrîrî pî' taaya'nîkon aminke pra kono'pîtî wanî sîrîrî taawonan amîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mîrîrî warantî nîrî ekaremekîuya manni' e'kupî era'maya'nîkon yai, Cristo enna'po kupî sîrîrî ka' poi, taaya'nîkon. Mîrîrî warantî aminke pra uui'to' wanî epu'tîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ayenku'tîuya'nîkon pepîn. Sîrîrî ye'ka e'kupî kupî sîrîrî seru'ye' pe pra. Tamî'nawîronkon sîrîrî pankon enenankon sa'manta pepîn sîrîrî e'kupî rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tauya sîrîrî, tamî'nawîron ataretî'ka kupî sîrîrî ka' moropai non, pata, tîîse umaimu ataretî'ka pepîn tiwin kin, ipatîkarî aako'mamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Î' pensa moropai î' weiyu yai uuipî inî'rî sîrîrî non pona epu'tîya'nîkon eserîke pra naatîi. Moropai inserîyamî' ka' ponkonya nîrî epu'tî pra man. Moropai uurî, Paapa munmuya epu'tî pepîn. Tîîse uyunya neken iweiyu epu'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A'kî, pena Noé nurî'tî wanî yai, awe'kupî'pî warantî, uurî ka' poi iipî'pî sîrîrî non pona enna'poto' wanî pe man. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maasa pra mîrîrî e'kupî rawîrî pemonkonyamî' wanî'pî teserukon yawîrî. To' entamo'ka'pî mararî pra moropai tîwukukon enîrî'pî to'ya. Moropai mîrîrî yai warayo'kon no'pîtapîtî'pî, moropai wîri'sanyamî' etiyomapîtî'pî teserukon yawîrî. Mîrîrî kupî'pî to'ya tîkanau ya' Noé nurî'tî asara'tî pîkîrî, ikupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mîrîrî kupî pî' to' ko'manpîtî'pî maasa pra î' e'kupî epu'tî tîuya'nîkon pra tîwanîkon ye'nen. Mîrîrî kupî pî' to' ko'mamî tanne, Paapaya pata ma'tînîpî'pî tuna ke. Moropai tamî'nawîrî inkamoro tî'ka'pîiya. Mîrîrî warantî nîrî uurî ka' poinon ii'to' weiyu wanî pe man. Inîmîkî to'ya pra tîîse uuipî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mîrîrî yai asakî'nankon warayo'kon wanî teesenyaka'makon pî' tînmîri ya'. Tîîse iwanîyakon yarîuya tiwin moropai tiaron e'nîmî. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Moropai asakî'ne wîri'sanyamî' wanî teesenyaka'makon pî'. To' esenyaka'ma a'nai ye'pa pî' a' yai. Mîîkîrî wanîyakon yarîuya tiwin moropai tiaron e'nîmî. Mîrîrî warantî awe'kupî pe man. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mîrîrî namai tîwarî panpî' ako'mantî maasa pra î' pensa uurî ayepotorîkon erepanto' weiyu sîrîrî non pona, epu'tîya'nîkon pra naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Maasa esenumenkatî sîrîrî pî': A'kî, manni' wîttî esa'ya sîrîrîpe ama'ye' erepamî epu'tî ya tewî' yama'runpai, mîîkîrîya eerepamî nîmîkî e'painon, tewî' yama'runpaiya namai, innape nai? ");
INSERT INTO mbcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mîrîrî warantî nîrî amîrî'nîkon ko'mamî e'pai awanî tîwarî. Maasa pra uurî ka' poinon enna'poto' weiyu sîrîrî non pona epu'tîya'nîkon pra naatîi. Enpen e'tî unîmîkîya'nîkon pra awanîkon tanne, ayeporîuya'nîkon namai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Inî'rî Jesus eseurîma'pî. Ta'pîiya: —O'non ye'ka mîîkîrî tîkaraiwarî maimu yawîrî tîwe'sen yairon moropai epu'nen? Manni' mîîkîrî ikaraiwarîya tewî' ko'mannî'nen pe itîrî'pî. Moropai tiaronkon teesenyaka'masanon esa' pe itîrî'pî. Moropai to' ya're' ton tîînen pe itîrî'pîiya. Moropai tamî'nawîrî ta'pî tîkaraiwarîya yawîrî iku'nen pe awanî'pî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","—Taatausinpai pu'kuru mîîkîrî ipoitîrî wanî î' pensa tîkaraiwarî erepanto' weiyu yai, maasa pra î' ta'pî tîkaraiwarîya yawîrî iku'sa' tîuya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yairî tauya sîrîrî apî'nîkon. Mîrîrî warantî tîkaraiwarî nîtîrî'pî ko'mannî'sai'ya ye'nen. Ikaraiwarîya mîîkîrî tîpoitîrî pia inî' panpî' tamî'nawîron temanne tîrî iipia iko'mannî'to'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tîîse mîrîrî warantî pra ipoitîrî wanî ya imakui'pî pe. Maasa pra taiya: “Ka'ne' pe ukaraiwarî iipî pe pra man”, taiya. Tîîwarîrî si'ma eeseurîma. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mîrîrî ye'nen tiaronkon tîkaraiwarî poitîrîtonon tonpayamî' taruma'tî pia'tîiya. To' po'pîtîiya to' ya're' ton tîrîiya pepîn. Moropai mîîkîrîya ta're' yonpa mararî pra, moropai eetîmî mai' enî'nenan pokonpe. Mîrîrî kupîiya maasa pra tîkaraiwarî iipî pra awanî ye'nen ka'ne' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Moropai mîrîrî tîpo, tîîko'manse pu'kuru pra ikaraiwarî erepamî. Mararî enpen pra tîîse tîpoitîrî eporîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mîrîrî yai inkupî'pî era'ma tîuya pe, ikaraiwarîya itaruma'tî mararî pra. I'po'pîtîiya, moropai yenumîiya tîmaimu yawîronkon pepîn, seru'ye'kon pata'se' ya', tîmoron epu'to'peiya. Inkamoro seru'ye'kon pokonpe mîîkîrî karau pe man, mararî pra tee tîpa'tîi, ne'ne' pe tîwanî ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Inî'rî Jesusya panton ekaremekî'pî: —Î' kai'ma tamî'nawîronkon esa' pe Paapa ii'to' wanî pe man, sîrîrî e'marimato' warantî —ta'pîiya. —Mia' tamî'nawîronkon wîri'sanyamî' maasaronkon wanî'pî. Inkamoroya tî'kuma'tukon ton lamparinha yapisî'pî moropai to' wîtî'pî tîwe'marimasen ponaya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tîîse to' yonpayamî' wanî'pî mia'taikin kaisarî tîwe'ne'nokon. Moropai mia'taikin to' wanî'pî tîwe'ne' pra, epu'nenan pe to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mîrîrî ye'nen inkamoro wîri'sanyamî' tîwe'ne'nokonya tî'kuma'tukon paru ton yarî to'ya pra to' wanî'pî itense' ya', maasaron ton. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tîîse tiaronkon epu'nenan wîri'sanyamî'ya tî'kuma'tukon lamparinha paru ton yarî'pî itense' ya' maasaron ton. Inkamoroya tîwe'marimasen iipî nîmîkî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tîîse tîwe'marimasen erepamî pra aako'mamî'pî. Moropai iwe'nunpai to' ena'pî. Moropai inkamoro we'na'pî ka'ne' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","To' we'nasa' tanne, anoinna tîwe'marimasen erepamî'pî. Mîîkîrî erepamî ye'nen, to' entaime eta'pî wîri'sanyamî'ya. Ta'pî to'ya: “Tîwe'marimasen erepannî pî' man! Asi'tî iipia ka'ne' pe erepantî”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mîrîrî taa to'ya pe, inkamoro mia' tamî'nawîronkon maasaronkon wîri'sanyamî' paka'pî. Moropai inkamoroya tî'kuma'tukon lamparinha yawittanîpî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tîîse inkamoro mia'taikinankon tîwe'ne'nokonya ta'pî tiaronkon epu'nenan pî': “Anna kuma'tu paru ton ke anna repatî maasa pra anna kuma'tu esi'nî'nî pî' man”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tîîse inkamoroya yuuku'pî: “Kaane, anna kuma'tu paru man anna pe neken”. Tîîse ta'pî to'ya to' pî': “A'kuma'tukon paru ton yu'se awanîkon ya, tîwe'repasanon pia anennatantî”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mîrîrî ye'nen inkamoro epu'nenan pepîn tîwe'ne'nokon wîri'sanyamî' wîtî'pî tî'kuma'tukon paru ton yennai. Maasa inkamoro tîîse poro po tîwe'marimasen erepamî'pî. Mîrîrî ye'nen mia'taikinankon epu'nenan wîri'sanyamî' ewomî'pî yarakkîrî tîwe'marimasen festarî pî'. Moropai mîrîrî tîpo mana'ta yarakkamo'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tîko'man pe pu'kuru pra, inkamoro wîri'sanyamî' erepamî'pî. Moropai inkamoro entaimepîtî pia'tî'pî. Ta'pî to'ya: “Anna yepotorî, anna ewonto'pe mana'ta yarakkanmokakî”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tîîse tîwe'marimasenya yuuku'pî. Ta'pîiya: “Anî'kan amîrî'nîkon? Ayepu'tîuya'nîkon pra wai”, ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Moropai Jesusya teeseurîmanto' yaretî'ka'pî see warantî: —Mîrîrî ye'nen tîwarî panpî' ako'mantî. Maasa pra î' pensa, î' weiyu yai, erepamî weiyu epu'tîya'nîkon pra naatîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Inî'rî tiaron panton ekaremekî'pî Jesusya: —Tamî'nawîronkon esa' pe Paapa ii'to' wanî pe man see warantî. Warayo' tiaron pata pona tuutîsen wanî'pî. Tuutî rawîrî tîpoitîrîtonon yanno'pîiya moropai tîpata rumaka'pîiya iko'mannî'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Moropai mîîkîrîya tiwin pî' to' tîîse to' nenyaka'ma ton tîniru tîrî'pî yenyaka'ma to'ya eserîke era'ma tîuya ye'nen. E'mai'non warayo' pia itîrî'pîiya 5.000 pîrata ena'pî kaisarî. Moropai tiaron pia itîrî'pîiya 2.000 kaisarî, pîrata ena'pî. Moropai tiaron pia itîrî'pîiya 1.000 kaisarî, pîrata ena'pî. Mîrîrî tîpo mîîkîrî wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mîîkîrî e'mai'non warayo' 5.000 kaisarî pîrata ena'pî yapisîtîpon epa'ka'pî yenyaka'mai moropai mîîkîrîya mîrîrî ke tiaron 5.000 kaisarî eporî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mîrîrî warantî nîrî mîîkîrî 2.000 kaisarî yapisîtîponya yenyaka'ma'pî. Moropai tiaron eporî'pîiya mîrîrî ke 2.000 kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tîîse tiaron warayo' 1.000 kaisarî pîrata ena'pî yapisîtîpon epa'ka'pî. Moropai a'ta yaka'pîiya non yai. Moropai mîrîrî tîkaraiwarî tîniru yu'na'tî'pîiya non ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Moropai kure'ne tîîko'mamî tîpo, to' karaiwarî enna'po'pî. Moropai to' nîkupî'pî anepu'pai awanî'pî, to' eesenyaka'ma'pî konekapa kai'ma to' yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mîrîrî ye'nen mîîkîrî e'mai'non 5.000 kaisarî pîrata ena'pî yapisîtîpon erepamî'pî iipia, moropai 10.000 kaisarî tînirurî'pî rumaka'pîiya. Ta'pîiya: “Seeni' manni' uupia itîrîya ne'tîkini, 5.000 pîrata ena'pî ke tiaron eporî'pîuya 5.000 kaisarî”, ta'pîiya tîkaraiwarî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mîîkîrî pî' ta'pî ikaraiwarîya: “Morî pe pu'kuru man, innape yairî pu'kuru ikonekasa'ya nai”, ta'pîiya. “Mîrîrî ye'nen aapia tu'kan anko'mannîpî ton tîrîuya, morî pe eesenyaka'masa' ye'nen. Mararon tîrî'pîuya aapia, tîîse morî pe yenyaka'masa'ya nai. Mîrîrî ye'nen asi'kî uyarakkîrî aatausinpapa”. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Moropai tiaron ipoitîrî 2.000 kaisarî pîrata ena'pî yapisîtîpon erepamî'pî iipia. Moropai ta'pîiya tîkaraiwarî pî': “Uupia 2.000 pîrata ena'pî tîrî'pîya. Mîrîrî ke seeni' eposau'ya sîrîrî inî' panpî' 2.000 kaisarî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mîîkîrî pî' ikaraiwarîya ta'pî: “Morî pe pu'kuru man, upoitîrî”, ta'pîiya. “Morî pe mararî untîrî'pî yenyaka'masa'ya nai. Mîrîrî ye'nen inî' panpî' aapia tu'kan tîrîuya, anko'mannîpî ton. Mîrîrî ye'nen asi'kî uyarakkîrî aatausinpapa”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mîrîrî tîpo tiaron ipoitîrî 1.000 kaisarî pîrata ena'pî yapisîtîpon erepamî'pî iipia moropai ta'pîiya: “Ukaraiwarî, ayeseru epu'tî pî' wai, ari'ke' pe awanî. Mararî eesenyaka'ma tanne tu'ke î' eponen pe. Moropai o'non pata î' tîpînse pra miarî imo'kanen amîrî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mîrîrî ye'nen uurî wanî'pî eranne' pe amîrî pî'. Sa'man amîrî. Mîrîrî ye'nen seeni' pîrata ayemanne yu'na'tî'pîuya itî'kauya namai. Mîrîrî mana'pouya sîrîrî aapia yapisî'pîuya warantîrî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mîîkîrî pî' ta'pî ikaraiwarîya: “Amîrî wanî mîrîrî imakui'pî pe, moropai enya'ne pe awanî mîrîrî. Anenyaka'ma pe itîîsa' yenyaka'masa'ya pra awanî. Epu'nen amîrî uyeseru, mararî esenyaka'ma tanne, tu'ke î' eponen pe uurî wanî. Moropai î' tîpînse pra î' mo'kanen pe uurî wanî mararî pra”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Tîîse î' wani' awanî ye'nen mîrîrî utînirurî pîrata ena'pî tîrîya pra awanî'pî itewî' ta itaponse' pona? Sîrîrî itîîsa'ya ya enna'posa' yai, inî' panpî' eepansa' tanne eporîuya e'painon” ta'pî ikaraiwarîya. Mîrîrî taa tîpo tiaronkon tîpoitîrîtonon winîkîi eera'tî'pî moropai ta'pîiya: ");
INSERT INTO mbcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Mîîkîrî pia manni' pîrata ena'pî mo'katî. Mîrîrî tîîtî manni' mia' tamî'nawîron pîrata ena'pî yarakkîron pia”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tîîse ta'pî to'ya: “Î' ton pe see mîîkîrî mia' tamî'nawîronya inî' panpî' yapisî?” ta'pî to'ya. Moropai to' maimu yuuku'pîiya: “Inna, tauya sîrîrî apî'nîkon. Manni' tu'ke panpî' yapisîtîponya yapisî e'pai awanî sîrîrî tu'ke panpî'. Tîîse anî' wanî ya mararon yarakkîrî, mîrîrî konekasai'ya pra awanî ye'nen iipiapai imo'ka e'pai awanî, î' ton pra awe'to'pe”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Moropai ta'pîiya: “Tarîpai mîîkîrî enya'ne imakui'pî pe tîwe'sen yenumî e'pai awanî ewaron ta awe'taruma'tîto'pe. Mîîkîrî karau mararî pra miarî teekon tîpa'tîi”, ta'pîiya to' pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesusya teeseurîmato' yaretî'ka'pî see warantî: —Î' pensa uurî ka' poinon iipî'pî erepamî ya inî'rî, ipîkku pe, rei pe, tamî'nawîronkon upoitîrîtonon inserîyamî' pokonpe uuipî. Uyaponse' pona teereutai uuipî pe man pemonkonyamî' esa' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mîrîrî yai tamî'nawîronkon pemonkonyamî' pata ponkon emurukuntî kupî sîrîrî urawîrî. Uurîya pemonkonyamî' menka pe man, manni' carneiroyamî' era'manenya bodeyamî' menka carneiroyamî' kore'tapai teken to' e'to'pe warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","To' menkauya yai carneiroyamî' tîrîuya umeruntîri winî. Moropai bodeyamî' tîrîuya kamai' winî to' e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tarîpai mîrîrî yai, uurî, ipîkku ayepurukonya taa kupî sîrîrî inkamoro meruntî winonkon pî': “Asi'tî uupia amîrî'nîkon Paapa nîpîika'tî'san asi'tî. Aapia'nîkon tîntîrî pe Paapa nîkoneka'pî yapi'tane'tî. Pena sîrîrî koneka'pî Paapaya maasa pata koneka tîuya rawîrî, apata'se'kon ton koneka'pîiya, aapia'nîkon itîrîpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maasa pra emi'ne wanî tanne uya're' ton tîrî'pîya'nîkon. Moropai tuna aninnîpai wanî tanne uwo'pa'pîya'nîkon. Moropai ayewî'kon ta erepamî'pî, anepu'tîkon pe pra si'ma tîîse uyapisî'pîya'nîkon ayewî'kon ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Moropai ipon pra uurî wanî'pî tîîse upon ton tîrî'pîya'nîkon. Moropai pri'ya pra wanî tanne upî' eesenyaka'ma'pîkon. Moropai ama'ye'kon atarakkanto' ta wanî tanne, uyera'mapî'se attî'pîkon”. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mîrîrî taiya manni' ekaranmapo inkamoro morîkonya. Taa to'ya: “Anna yepotorî, î' pensa see emi'ne awanî tanne, aya're' ton tîrî'pî annaya? Moropai tuna aninnîpai awanî tanne awo'pa'pî annaya? ");
INSERT INTO mbcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Anna yepotorî, î' pensa see ka'ran pe awanî tanne, anna nepu'tî pe pra awanî tanne, ayapisî'pî annaya anna yewî' ta? Moropai î' pensa ipon pra awanî era'ma'pî annaya apon ton tîrî'pî annaya?” taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Moropai î' pensa see amîrî era'ma'pî annaya pri'ya pra apî' anna esenyaka'mato'pe? Moropai î' pensa ama'ye'kon atarakkanto' yewî' ta awanî tanne ayera'mapî'se anna wîtî'pî?” ");
INSERT INTO mbcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mîrîrî yai ayepurukonya yuuku: “Tauya sîrîrî apî'nîkon, mîrîrî kupî'pîya'nîkon manni'kan uya'mi'san pî' moropai uyonpayamî' pî'. Tîîse inkamoro pî' pra ikupî'pîya'nîkon tîîse upî'” taiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mîrîrî yai taa ayepurukonya kupî sîrîrî, manni'kan kamai' winonkon pî': “Uupiapai atarimatî amîrî'nîkon Paapa nîtîrî anapi'pai'nîkon pepîn, atîtî itu'se awanî'pîkon apo' ya'. Mîrîrî apo' Paapa nîkupî'pî makui moropai ipemonkonoyamî' itansuriyamî' pata'se' pe. Mîrîrî ya' atîtî”, tauya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","“Maasa pra emi'ne wanî tanne, uya're' ton tîîsa'ya'nîkon pra naatîi. Moropai tuna aninnîpai wanî tanne uwo'pasa'ya'nîkon pra naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Moropai uyapi'sa'ya'nîkon pra naatîi ayewî'kon ta ka'ran pe wanî ye'nen. Moropai ipon pra e'taruma'tî tanne, upon ton tîîsa'ya'nîkon pra naatîi. Moropai pri'ya pra wanî tanne, moropai ama'ye'kon atarakkanto' ta wanî tanne, uyera'mapî'se attîsa'kon pra naatîi”. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mîrîrî pî' ekaranmapo to'ya kupî sîrîrî: “Anna Yepotorî, î' pensa see emi'ne awanî era'ma'pî annaya? Moropai tuna aninnîpai awanî era'ma'pî annaya? Moropai î' pensa anna yewî' ta eerepamî'pî anna nepu'tî pe pra si'ma? Moropai î' pensa ipon pra awanî era'ma'pî annaya? Moropai î' pensa pri'ya pra awanî'pî, î' pensa ama'ye'kon atarakkanto' ta awanî tanne, ayera'mapîtî annaya pra awanî'pî?” taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ayepurukonya yuuku pe man: “Yairî tauya sîrîrî amîrî'nîkon pî'. Tu'ke ite'ka insanan pemonkonyamî' ipîika'tîpainokon pîika'tîsa'ya'nîkon pra naatîi, nem tiwinan ipîkku pepîn pîika'tîsa'ya'nîkon pra naatîi. Inkamoro pepîn neken tîîse uurî pîika'tîsa'ya'nîkon pepîn mîrîrî”. ");
INSERT INTO mbcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sîrîrî warantî Jesusya teeseurîmato' yaretî'ka'pî. —Mîrîrî ye'nen insamoro wîtî pe man uupiapai, ipatîkarî to' e'taruma'tîto'pe. Tîîse morîkon wîtî pe man uupia ipatîkarî enen to' ko'mannîto'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sîrîrî warantî pemonkonyamî' yenupa tîpo, Jesusya ta'pî tînenupa'san pî': ");
INSERT INTO mbcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Epu'tî pî' naatî tarîpai asakî'ne wei tîpo entamo'kanto' weiyu wanî, itese' páscoa —ta'pîiya. —Mîrîrî yai uurî, ka' poi iipî'pî rumaka to'ya uyeyatonon pia, pakî'nan pona ipokapî'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mîrîrî tanne teepîremasanon esanon moropai Judeuyamî' ye'mai'norî'san eperepî'pî tepotorîkon Caifás yewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Inkamoroya ta'pî: —Ama' pe Jesus yapi'pai awanî sîrîrî iwîto'pe, era'ma arinîkonya pra tîîse —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Tîîse festa weiyu yai, sîrîrî ku'pai pra awanî sîrîrî. Maasa pra mîrîrî yai ikupî'nîkon ya, pemonkonyamî' ekore'ma eserîke man uwinîkîi'nîkon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus wanî'pî pemonkonyamî' ko'manto' pata Betânia po leproso itese' paran pî' si'pî Simão yewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Miarî wîri' erepamî'pî Jesus pia. Mîîkîrî e'rennuku'pî aminke pra iipia. Mîîkîrîya kara' a'pusin yense' ene'sa' wanî'pî tenya', non ka'sa' itese' alabastro. Mîrîrî ya' a'pusin wanî'pî intapîkîrî. Mîrîrî wanî'pî epe'ke pe pu'kuru moropai Jesus entamo'ka tanne, wîri'ya i'kanpîtî'pî ipu'pai pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mîrîrî kupî wîri'ya era'ma tîuya'nîkon pe, Jesus nenupa'san ekore'ma'pî ipî'. Moropai mîîkîrî ekaranmapo'pî to'ya: —Î' ton pe see mîrîrî a'pusin kanpîtîya mîrîrî, î' pe pra rî? ");
INSERT INTO mbcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mîîkîrî wîri' pî' ta'pî to'ya: —Mîrîrî i'kanpîtîya manni' a'pusin, mîrîrî ke awe'repa e'painon se' tapairî tîma'tînî'se pra. Tîniru yapisîya e'painon mararî pra, moropai mîrîrî ke tîwe'taruma'tîsanon pîika'tî e'painon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tîîse mîrîrî taa to'ya epu'tî'pî Jesusya. Moropai ta'pîiya to' pî': —Î' wani' wanî ye'nen yairî ma're wîri' kupî yu'se awanîkon mîrîrî? Mîrîrî ikupîiya manni' wanî mîrîrî morî pe pu'kuru uurî ton pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Î' ton pînon sa'ne wanî mîrîrî wei kaisarî aapia'nîkon. ˻Inkamoro anpîika'tîpai awanîkon ya, morî tîrîya'nîkon e'painon.˼ Tîîse uurî kaane, aapia'nîkon uuko'mamî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mîrîrî iku'sai'ya manni' wanî mîrîrî Judeuyamî'ya isa'manta'pî karapaima manni' warantî. Mîrîrî epu'tî pî' naatîi. Ukarapaimasai'ya mîrîrî uusa'mantasa' yu'na'tî to'ya rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ayenku'tîuya'nîkon pepîn. O'non pata Paapa maimu ekaremekî to'ya eseta ya mîserî wîri' nîkupî'pî nîrî yekare eseta. Moropai mîîkîrî pî' to' enpenata —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mîrîrî tîpo asakî'ne pu' pona tîîmo'tai'nîkon Jesus nenupa'san yonpa wîtî'pî itese' Judas Iscariotes eseurîmai teepîremasanon esanon yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Moropai mîîkîrîya ta'pî to' pî': —Î' warapo kaisarî uye'maya e'painon aapia'nîkon Jesus rumakauya ya? —ta'pîiya. Teepîremasanon esanonya ta'pî: —30 prata ena'pî kaisarî aye'ma annaya —ta'pî to'ya. Moropai mîrîrî tîrî'pî to'ya iipia. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mîrîrî patapai î' kai'ma Jesus yapisî tîuya ama' pe yuwa'pî Judasya inkamoro pia irumakapa. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E'mai'non wei yai, isa'moto' ton pîn trigo puusa' yaku tîuya'nîkon rawîrî, Jesus nenupa'san erepamî'pî iipia ekaranmapoi. —O'non pata see entamo'kanto' páscoa koneka annaya e'painon? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesusya inkamoro maimu yuuku'pî moropai ta'pîiya: —Atîtî cidade pona. Miarî eerepansa'kon pe, warayo' wîttî esa' mîwatîi. Moropai makatîi ipî': “Uyenupanenkonya anna yarimasa' sîrîrî upata'se' ton yu'se wai ayewî' ta, moro unenupa'san yarakkîrî entamo'kato'pe páscoa pî', maasa pra uweiyu eseposa' man, taa pî' uyenupanenkon man”, makatîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Moropai inenupa'sanya tîwentamo'kato'kon ton koneka'pî miarî ta'pî Jesusya yawîrî. Páscoa koneka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Moropai pata ewaronpamî pe, Jesus moropai inenupa'san ereuta'pî mesa pona tîwentamo'kakonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mîrîrî pe rî tîwentamo'kakon ye'ka pe, Jesusya ta'pî tînenupa'san pî': —Yairî tauya sîrîrî apî'nîkon. Amîrî'nîkon kore'tawonya uyekaremekî pe man uyeyatonon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mîrîrî taa Jesusya ye'nen, inenupa'san ena'pî yairî ma're mararî pra. Mîrîrî ye'nen tîîwarîrî'nîkon to' esekaranmapopîtî'pî tiwin pî'. Moropai ta'pî to'ya Jesus pî': —Uurîya mîrîrî kupî pepîn e'painon? Innape nai? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tîîse Jesusya yuuku'pî. Ta'pîiya: —Tiwinan ayonpakon uyarakkîrî tiwinan pratopon yanîiya, manni'ya uyekaremekî kupî sîrîrî uyeyatonon pî', mîîkîrî uyarakkîrî tekkari yonpaiya manni'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mîrîrî warantî uurî, ka' poi iipî'pî sa'manta e'pai awanî sîrîrî. Paapa maimu e'menukasa'ya taasa' yawîrî. Tîîse aka mîîkîrî uurî ka' poi iipî'pî rumakatîpon uyeyatonon yenya'. Mîîkîrî sa'ne yenposa' isanya pra awanî ya, morî pe panpî' awanî e'painon. Maasa pra awe'taruma'tî pepîn e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mîrîrî taiya ye'nen mîîkîrî Judasya Jesus ekaranmapo'pî: —Yai pra uurî pî' taaya, uyenupanen, innape nai? —Amîrî pe awanî ye'nen taaya mîrîrî —ta'pî Jesusya Judas pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tîwentamo'kakon ye'ka pe, Jesusya trigo puusa' yapisî'pî tenya' moropai eepîrema'pî. Ta'pîiya: —Morî pu'kuru amîrî, uyun. Anna yuu ton tîrî pî' nai —ta'pîiya Paapa pî'. Mîrîrî tîpo ipîrikkapîtî'pîiya. Moropai itîrî'pîiya to' kaisarî. Itîrî tîuya pe ta'pîiya: —Maa, sîrîrî yapi'tî. Moropai ya'tî, maasa pra sîrîrî wanî upun pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Moropai mîrîrî tîpo uva yekku yense' pisa yapisî'pîiya. Moropai eepîrema'pî. —Morî pu'kuru amîrî, uyun. Anna wuku ton tîrî pî' nai —ta'pîiya Paapa pî'. Mîrîrî tîpo itîrî'pîiya to' kaisarî. Ta'pîiya to' pî': —Sîrîrî enî'tî tamî'nawîrî si'ma. Moropai tamî'nawîronkonya enîrî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jesusya ta'pî: —Sîrîrî wanî sîrîrî umînî. Tu'kankon nîkupî'pî imakui'pî yepe' pe i'kamouya kupî sîrîrî. Mîrîrî wenai Paapaya tu'kankon nîkupî'pî kupî e'painon tîîwanmîra, ekaremekî'pî tîuya yawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Tauya sîrîrî apî'nîkon. Inî'rî uva yekku enîrîuya pepîn kupî sîrîrî apokonpe'nîkon tamî'nawîron esa' pe tîwanî Paapaya yenpo pîkîrî. Mîrîrî yai amenan uva yekku enîrîuya apokonpe'nîkon inî'rî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mîrîrî tîpo to' eserenka'pî Paapa yapurî pe. Moropai to' wîtî'pî Oliveira ye'ka kîrî pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Moropai Jesusya ta'pî to' pî': —Sîrîrîpe ewaron ya, eranne' pe awanîkon wenai, tamî'nawîrî eepekon pe naatîi. Moropai urumakaya'nîkon pe naatîi, Paapa maimu e'menukasa'ya taasa' yawîrî. Pena Paapaya ta'pî: “Carneiroyamî' era'manen wîuya yai, inera'makon carneiroyamî' e'paraipîka kupî sîrîrî,” ta'pî Paapaya pena. Tîpî' Jesus eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Tîîse uusa'manta tîpo, Paapaya u'mî'sa'kasa' yai, arawîrî'nîkon uutî Galiléia pona —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mîrîrî taa Jesusya yuuku'pî Pedroya: —Tamî'nawîronkonya arumaka e'painon eranne' pe tîwanîkon wenai, tîîse uurîya arumaka pepîn, Uyepotorî. Tîîse tiaronkonya neken ikupî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tîîse Jesusya ta'pî ipî': —Kaane Pedro, ayenku'tîuya pepîn. Sîrîrîpe ewaron ya, maasa e'mai' pe kariwana yunkon etun rawîrî taaya pe nai. Ayekaranmapo to'ya ya, seurîwî'ne ite'ka “unepu'tî pepîn”, taaya pe nai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tîîse Pedroya yuuku'pî: —Unepu'tî pepîn mîîkîrî Jesus tauya pepîn. Awî to'ya ya, uurî nîrî tîwî uwî to'ya —ta'pîiya. Moropai tamî'nawîronkonya nîrî mîrîrî warantî ta'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Moropai Jesus wîtî'pî inenupa'san pokonpe. Eewomî'pî jardim itese' Getsêmani ya' moropai ta'pîiya: —Maasa tarî e'tî, epîremai uutî tanne sinpata —ta'pîiya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mîîkîrîya Pedro yarî'pî moropai Zebedeu munkîyamî' yarî'pî takon yarakkîrî. Mîrîrî yai Jesus esewankono'ma'pî mararî pra. Ipîra yairî ma're awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Moropai ta'pîiya: —Esewankono'mato'ya uyewan yannî'sa' man. Mîrîrîya uwî pe man —ta'pîiya. —Maasa tarî e'tî tîwarî panpî' e'tî unîmîkî pî' ako'mantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Inkamoro piapai mîîkîrî atarima'pî mararî. Moropai non ekaya tenpata enu'tî'pîiya, eepîrema'pî. Ta'pîiya: —Uyun, tamî'nawîron kupîya e'painon. Upîika'tîkî e'taruma'tî namai. Tîîse itu'se wanî yawîrî kî'kupîi. Itu'se awanî yawîrî neken iku'kî —ta'pîiya Paapa pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Moropai awenna'po'pî inkamoro eseurîwî'nankon pia. Inkamoro tînenupa'san wetun tanne, to' eporî'pîiya. Moropai ta'pîiya Pedro pî': —Awetunkon mîrîrî tîwarî aako'mamîkon eserîke pra naatî? Mararî rî tiwin hora kaisarî aako'mamîkon eserîke pra naatî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—Tîwarî ako'mantî moropai epîrematî. Paapa yarakkîrî eseurîmatî, makuiya imakui'pî kupîya'nîkon emapu'tî namai. Ayewankon ya' Paapa maimu yawîrî iko'manpai awanîkon. Tîîse ikupîya'nîkon eserîke pra awanîkon a'tu'mîra awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Moropai inî'rî itakon ite'ka pe, attî'pî epîremai, Paapa yarakkîrî eseurîmai. Ta'pîiya: —Paapa, e'taruma'tî namai upîika'tîkî. Tîîse mîrîrî yu'se pra awanî ya, î' itu'se awanî manni' yawîrî iku'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mîîkîrîya tîwenna'posa' pe, inî'rî to' wetun tanne to' eporî'pî. Maasa pra mararî pra iwe'nunpai to' wanî'pî mîîto'pe. Mararî ipokonpe to' wanî eserîke pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iteseurîno ite'ka pe, Jesus wîtî'pî to' piapai epîremai. Moropai e'mai' pe teepîrema'pî warantî ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Moropai awenna'po'pî inî'rî to' pia. Inkamoro ekaranmapo'pîiya: —Sîrîrî tîpose awetunkon ko'mannîpî mîrîrî? Aasîrî man, aase'nîkon, wîtî'nîkon. Sîrîrî pu'kuru uurî, ka' poi iipî'pî rumakato' to'ya weiyu eseponî pî' man imakui'san yenya'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","E'mî'sa'katî aase'nîkon wîtîn. A'kî, mîîkîrî warayo' iipî era'matî uyeyatonon pia utîrî ton —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus eseurîma tanne, tiwinan inenupa'san yonpa, Judas, erepamî'pî. Teepîremasanon esanonkon moropai Judeuyamî' panamanenan narima'san erepamî'pî ipokonpe. Arinîke pemonkonyamî' erepamî'pî tetawaraikon, moropai tîtaikapukon yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mîîkîrî Judasya taasa' wanî'pî inkamoro Jesus yeyatonon pî'. Manni' warayo' yu'nauya era'maya'nîkon ya, mîîkîrî anapisîkon ton. Mapi'tîi taasai'ya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Moropai teerepamî pe, Judas wîtî'pî Jesus pia. Moropai ta'pîiya: —Uyenupanen, tîwanmîn wanî mîîtî aapia —taa ye'ka pe, Jesus yu'na'pîiya itenpata yai. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusya imaimu yuuku'pî. Ta'pî Jesusya: —Uyonpa, î' anku'pai awanî ya uyarakkîrî iku'kî ka'ne' pe. Moropai Judas ponkon pe iipî'sanya Jesus yapisî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mîrîrî kupî to'ya era'ma tîuya'nîkon pe, Jesus nenupa'san yonpaya tetawarai mo'ka'pî. Moropai teepîremasanon esanon yepotorî poitîrî pana ya'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tîîse Jesusya ta'pî: —Kaane, mîrîrî warantî pra, ayetawarai yeka'makî iwon ya'. Maasa pra etawara ke epîpainon wanî ya, mîîkîrî sa'manta e'pai awanî etawara kamo pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—Uyun pî' upîika'tînenkon ton esatîuya ya, yarimaiya pra awanî kai'ma eesenumenkakon mîrîrî? To' esatîuya e'painon ipî'. Moropai ka'ne' pe arinîkon inserîyamî' yarima uyunya e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tîîse esatîuya e'pai pra awanî. Maasa pra sîrîrî warantî awe'kupî pe man kai'ma, Paapa maimu e'menukasa' ye'nen. Mîrîrî e'kupî pe man taasai'ya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Moropai Jesusya ta'pî inkamoro pemonkonyamî' pî': —Uyapi'se aai'sa'kon sîrîrî akasuparaikon moropai akaitapukon yarakkîrî, manni' pemonkon wîîtîpon yapisî to'ya warantî. Teuren wei kaisarî akore'ta'nîkon wanî tanne, ayenupakon pî' epîremanto' yewî' ta, mîrîrî ku'sa'ya'nîkon pra naatîi uyapisîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tîîse tamî'nawîrî sîrîrî e'kupî sîrîrî maasa pra penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'sanya imenuka'pî yawîrî. Mîrîrî taa Jesusya pe, inenupa'sanya Jesus rumaka'pî moropai iipiapai to' wîtî'pî. To' epe'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Inkamoro Jesus yapisîtîponkonya yarî'pî teepîremasanon esanon yepotorî Caifás pia. Miarî to' epere'sa' wanî'pî. Moisés nurî'tî yenupato' pî' yenupatonkon moropai Judeuyamî' panamanenan inkamoro epere'sa' wanî'pî moro. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tîîse Pedro wîtî'pî aminke Jesus pî' to' ye'ma'pî pî'. Teepîremasanon esanon yepotorî yewî' eporî tîuya pîkîrî. Mîîkîrî e'nîmî'pî poro po surarayamî' pokonpe miarî si'ma î' kupî to'ya era'mapa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imakui'pî pe Jesus winîkîi teeseurîmasen ton pemonkon yuwa'pî teepîremasanon esanonya, moropai tamî'nawîronkon ipîkkukon Judeuyamî' yepotorîtononya. Innape Jesus nîkupî'pî ekaremekî to'ya ya, iwîkonpa kai'ma yuwa'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tîîse mîrîrî warantî to' eseurîma pra awanî'pî Jesus winîkîi. Teuren arinîkon eseurîma'pî seru' pe iwinîkîi. Tîîse asakî'nankonya î' ta'pî Jesusya ekaremekî tu'ka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Moropai ta'pî to'ya: —See warantî ta'pîiya epîremanto' yewî' pî': “Seeni' epîremanto' yewî' koneka'pî pemonkonyamî'ya. Tîîse yarankauya kupî sîrîrî. Moropai i'mî'sa'kauya inî'rî eseurîwî'ne wei tîpo”, ta'pîiya —ta'pî to'ya teepîremasanon esanon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mîrîrî ya, Jesus eseurîmasa' eta tîuya pe, teepîremasanon esanon yepotorî e'mî'sa'ka'pî. Moropai Jesus ekaranmapo'pîiya: —A'kî imakui'pî pe insanan warayo'kon eseurîman pî' man apî', î' kai'ma awanî pe nan? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tîîse Jesus wanî'pî moo î' taiya pra. Inî'rî teepîremasanon esanon yepotorîya Jesus ekaranmapo'pî: —Inna, Paapa ka' pon ese' pî' taaya yu'se wanî sîrîrî. Amîrî Paapa nîmenka'pî Cristo, Paapa munmu amîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusya yuuku'pî: —Inna, amîrîya taa mîrîrî. Tîîse tauya sîrîrî apî'nîkon, maasa amîrî'nîkonya uurî ka' poi iipî'pî ereutasa' era'ma kupî sîrîrî Paapa meruntîri winî. Î' pensa sîrîrî non pona uuipî yai, katupuru po autî era'maya'nîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mîrîrî taa Jesusya eta tîuya pe, teepîremasanon esanon yepotorî ekore'ma'pî mararî pra. Mîrîrî ye'nen tîpon karaka'pîiya teesewankono'masa' warantî tîwe'ku'se. Moropai ta'pîiya: —Innape man. Paapa pe e'ku'nî pî' man. Inî'rî anî' yuwapai pra man iteseru pî' teeseurîmasen ton. Maasa pra aasîrî imakui'pî pe eseurîman pî' man Paapa winîkîi. Eeseurîma eta pî' naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Î' ye'ka pe mîserî ku'pai nai? —ta'pîiya to' pî'. Yuuku'pî to'ya: —Iwîpai awanî mîrîrî, enen awanî e'pai pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Moropai mîrîrî taa tîpo, tiaronkonya tetakukon yenumî'pî itenpata pona. Moropai ipa'tîpîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ipa'tîpîtî ye'ka pe ta'pî to'ya: —Anî'ya apa'tîsa' pe awanî epu'kî, innape Paapa nîmenka'pî pe awanî ya —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mîrîrî tanne Pedro ereutasa' wanî'pî poro po wîttî iwa'to' pona. Moro tîîse teepîremasanon esanon poitîrîpa' iipî'pî iipia. Moropai ta'pîiya ipî': —Amîrî nîrî wanî'pî mîîkîrî Jesus Nazaré poinon yarakkîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tîîse Pedroya iwapu'tî'pî tamî'nawîronkon rawîrî si'ma. Ta'pîiya: —Anî' pî' eeseurîmakon epu'tîuya pra wai. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Moropai Pedro mo'ta'pî wîttî iwa'to' mana'ta pia. Inî'rî tiaron to' poitîrîpa'ya era'ma'pî moropai ta'pîiya moro tîwe'sanon pî', warayo'kon pî': —Mîîkîrî wanî'pî Jesus Nazaré pon yarakkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mîrîrî pî' Pedroya ta'pî itakon te'ka pe: —Unepu'tî pepîn mîîkîrî. Useruku pepîn sîrîrî, Paapaya uyera'ma pî' man. Seru'ye' pe pra wanî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mararî tîîko'mamîkon tîpo, moro tîwe'sanon e'rennuku'pî inî'rî Pedro pia. Moropai ta'pî to'ya: —Maasa pra eeseurîmato'ya mîîkîrî yonpa pe awanî ekaremekî, iwarantî eeseurîma ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mîrîrî pî' ta'pî Pedroya: —Seru' pe pra tauya sîrîrî, unepu'tî pepîn mîîkîrî warayo'. Seru' pe eseurîma ya, Paapaya utaruma'tî e'painon. Mîrîrî taiya tanne, kariwana yunkon e'na'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Moropai Pedro enpenata'pî î' kai'ma ta'pî Jesusya pî'. Maasa pra ta'pîiya: —E'mai' pe kariwana yunkon etun rawîrî, unepu'tî pepîn mîîkîrî, taaya kupî sîrîrî eseurîwî'ne ite'ka —ta'pîiya ipî'. Mîrîrî tîpo Pedro epa'ka'pî miarî pai. Mararî pra tîkarau ye'ka pe attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pata erenmapî pe, tamî'nawîronkon teepîremasanon esanon, moropai Judeuyamî' panamanenan emurukuntî'pî. Î' kai'ma Jesus kupî tîuya'nîkon pî' eseurîmai iwîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Moropai inkamoroya surarayamî' yaipontî'pî Jesus yaironpîtîto'pe to'ya. Moropai mîîkîrî rumaka'pî to'ya pata esa' Pilatos pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mîrîrî warantî Jesus wîî to'ya epu'tî tîuya pe, Judas, Jesus rumakatîpon esewankono'ma'pî mararî pra. Moropai mîrîrî wenai Jesus rumaka'pî tîuya iteyatonon pia yepe'pî tîniru 30 prata ena'pî tînapisî'pî mana'po'pî teepîremasanon esanon pia moropai Judeuyamî' panamanenan pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta'pîiya: —Kure'ne imakui'pî ku'sau'ya sîrîrî. Maasa pra î' konekatîpon pepîn warayo' tîrumakai aasa'mantato'pe —ta'pî Judasya to' pî'. Imaimu yuuku'pî to'ya: —Î' wani' kin nai, î' ton pra man anna yarakkîrî. Tîîse amîrî yarakkîrî neken. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mîrîrî taa to'ya ye'nen, Judasya tîniru papo'pî epîremanto' yewî' ta, moropai eepa'ka'pî. Moropai attî'pî, mîîkîrî e'mutunuku'pî moropai aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mîrîrî tîniru yapisî'pî teepîremasanon esanonya moropai mîrîrî pî' ta'pî to'ya: —Sîrîrî tîniru wanî pepîn morî pe, uurî'nîkonya itîrî ya epîremanto' yewî' pratarî kore'ta. Maasa pra sîrîrî wanî tîîsa'mantasen yepe'pî pe itîîsa' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tamî'nawîrî mîrîrî pî' teeseurîmakon tîpo mîrîrî tîniru ke tiwin pata yenna'pî to'ya, kamote ka'nen pata'se'. Mîrîrî pata ya' ka'ranyamî' sa'mantasa' yu'na'tîto' ton yenna'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mîrîrî ye'nen mîrîrî pata to' nenna'pî esatî to'ya sîrîrî tîpose mîn pata'se' kai'ma. Maasa pra anî' sa'mantato' wenai yenna'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sîrîrî warantî penaro' Paapa maimu ekareme'nen profeta Jeremias nurî'tîya taasa' yawîrî awe'kupî'pî. Inkamoroya tîniru yapisî'pî 30 prata ena'pî kaisarî. Mîrîrî warapo aye'ma annaya ta'pî Judeuyamî'ya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Moropai mîrîrî ke pata yenna'pî to'ya, kamote ka'nen pata'se'. Î' kai'ma ta'pî Uyepotorîya yawîrî iku'to'peuya ta'pî profeta Jeremias nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mîrîrî tanne, pata esa' Pilatos rawîrî Jesus wanî yai, Pilatosya ekaranmapo'pî. Ta'pîiya: —Amîrî, mîîkîrî Judeuyamî' esa' pe tîwe'sen? —ta'pîiya. —Inna, amîrîya taa mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tîîse inkamoro teepîremasanon esanon, moropai Judeuyamî' panamanenan maimu yuuku Jesusya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Moropai Pilatosya ta'pî: —To' maimu yuukuya pepîn. “Mararon pepîn imakui'pî ku'sai'ya”, taa pî' to' man apî'. Mîrîrî etaya pra nan? ");
INSERT INTO mbcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tîîse Jesus eseurîma pra awanî'pî. Moropai mîrîrî pî' pata esa' Pilatos wanî'pî mararî pra teesenumenkai ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pilatosya festa, itese' Páscoa kaisarî, tînarakkamo'pî rumaka e'pîtî'pî atarakkannîto' tapai. Manni' pemonkonyamî' nesatî'pî teseru ya', mîîkîrî rumakaiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mîrîrî yai atarakkannîto' ta, tiwin warayo' wanî'pî tamî'nawîronkon nepu'tî Barrabás. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mîrîrî yai arinîkon pemonkonyamî' emurukuntî'san ekaranmapo'pî mîîkîrî pata esa' Pilatosya. —Anî' rumakauya yu'se naatî, Jesus Paapa nîmenka'pî, Barrabás ka'rî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ipî' tîkinmukon ye'nen, Jesus ene'sa' to'ya epu'tî'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Moropai ipîkku pe tîwe'to' yaponse' pona Pilatos ereutasa' tanne, ino'pîya tîmaimu yarima'pî taato' see warantî: —Mîîkîrî warayo' winîkîi î' kî'kupîi, maasa pra morî pu'kuru mîîkîrî, î' kupîtîpon pepîn. Maasa pra sîrîrîpe uwe'ne' e'taruma'tî pî' wai mararî pra, mîîkîrî wenai —taasai'ya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tîîse teepîremasanon esanonya ta'pî moropai Judeuyamî' panamanenanya tamî'nawîronkon pî': —Barrabás rumakaya yu'se anna man ka'tî ipî' —ta'pî to'ya. —Moropai Jesus wîî me'poto'peiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Inî'rî pata esa'ya tamî'nawîronkon pemonkonyamî' ekaranmapo'pî: —O'non ye'ka rumakauya yu'se naatî? Yuuku'pî to'ya: —Barrabás rumakakî —kai'ma imaimu yuuku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Inî'rî Pilatosya ta'pî to' pî': —Moriya î' kin kupîuya e'painon mîserî Jesus manni' Cristo tesa'sen yarakkîrî? —Pakî'nan pona ipokapîtî me'pokî —ta'pî tamî'nawîronkonya Pilatos pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatosya ta'pî inî'rî to' pî': —Î' kin imakui'pî inkupî'pî moro nai mîîto'pe? —taiya ye'nen, tamî'nawîronkon entaimepîtî'pî —Pakî'nan pona ipokapîtî me'pokî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mîrîrî warantî î' koneka tîuya eserîke pra tîwanî Jesus yarakkîrî epu'tî'pî Pilatosya. Moropai Pilatosya tîpî' pemonkonyamî' ekore'ma epu'tî'pî. Mîrîrî ye'nen tuna enepî me'po'pîiya. Moropai mîrîrî ke tenya rona'pîiya, î' ton pra tîwanî ekaremekîpa mîîkîrî yarakkîrî, arinîkon pemonkonyamî' rawîrî si'ma. Moropai ta'pîiya: —Uurî wanî pepîn mîserî warayo' sa'mantanto' esa' pe. Tîîse amîrî'nîkonya ikupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Moropai tamî'nawîronkonya yuuku'pî: —Mîîkîrî sa'mantato' wenai, tîwî anna pona e'taruma'tînto' nenai, moropai anna munkîyamî' pona eena —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mîrîrî taasa' to'ya pe, Pilatosya Barrabás rumaka'pî atarakkannîto' tapai. Tîîse Jesus po'pî'to'pe to'ya ta'pî Pilatosya pemonkon po'pî'to' ke, moropai irumaka'pîiya pakî'nan pona ipokapî'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Moropai surarayamî'ya Jesus yarî'pî pata esa' Pilatos yewî' ta. Moropai tamî'nawîronkon surarayamî' emurukuntî'pî iwoi. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inkamoroya Jesus pon mo'ka'pî ipokon moropai ipata'pî ya' tiaron ta'sankon suuyu yeka'ma'pî to'ya, ipon ton. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Moropai Jesus yarakko ton koneka'pî to'ya mî'nî ye' ke rei yarakko, coroa warantî. Ipî' tîwo'ma'takon ye'nen, rei pe ikupî'pî to'ya. Moropai rei me'sipu ye'ka tîrî'pî to'ya itenya' meruntî winî. Mîrîrîkon tîrî tîpo, to' e'sekunka'pî irawîrî. Moropai inkamoro wo'ma'ta pia'tî'pî ipî'. Ta'pî to'ya: —Anna yepuru pe awanî, Jesus. Amîrî wanî Judeuyamî' esa' pe pu'kuru awanî rei pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mîrîrî taa ye'ka pe, ipona tetakukon yenumî'pî to'ya. Moropai manni' me'sipu mo'ka'pî to'ya, moropai mîrîrî ke ipa'tîpîtî'pî to'ya ipu'pai pona. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ipî' tîwo'ma'takon tîpo, ipon tîneka'ma'pîkon suuyu mo'ka'pî to'ya. Moropai ipon pu'kuru tîmo'ka'pîkon yeka'ma'pî to'ya inî'rî. Mîrîrî tîpo Jesus yarî'pî to'ya pakî'nan pona ipokapî'se. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Miarî pai teepa'kakon pe, warayo' eporî'pî to'ya Simão itese', Cirene cidaderî pon. Moropai mîîkîrî pî' ta'pî to'ya pakî'nan yaato'peiya mîrîrî Jesus narî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Moropai to' erepamî'pî pata'se' itese' Gólgota. Mîrîrî Gólgota, pemonkon pu'pai rî'pî yepin, taato' mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Miarî Jesus wuku ton tîrî'pî to'ya, vinho yai'mesa' mai' ke enî'to'peiya kai'ma. Tîîse yonpasa' tîuya pe, itu'se pra Jesus wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Miarî ipokapîtî'pî to'ya. Moropai Jesus pon pantakapîtîkonpa kai'ma tî' more'san pî' to' su'mina'pî. Anî' pia tî' ena epu'tî'nîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mîrîrî tîpo to' ereuta'pî, moropai inkamoroya Jesus koneka'pî miarîpai anî'ya imo'ka namai. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Inkamoroya Jesus pu'pai yepoi imenuka'pî î' wani' awanî ye'nen ipokapîtî tîuya'nîkon kai'ma. Taato' see warantî: MÎSERÎ JUDEUYAMÎ' ESA' REI kai'ma imenuka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Moropai Jesus pokonpe asakî'ne ama'ye'kon pokapîtî'pî to'ya iratai winî, tiwin meruntî winî moropai tiwin kamai' winî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","E'ma taawîrî tuutîsanon wo'ma'ta'pî ipî' tuutîkon kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Taapîtî'pîya: “Epîremanto' yewî' yarankauya tamî'nawîrî. Moropai mîrîrî pîmî'sa'kauya seurîwî'ne wei tîîse”, ta'pîya. Innape see Paapa munmu pe awanî ya, maasa kin see autîkî pakî'nan poi. Aawarîrî e'pîika'tîkî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Teepîremasanon esanon moropai Moisés nurî'tîya yenupato' pî' yenupatonkon moropai Judeuyamî' panamanenan pokonpe si'ma to' wo'ma'ta'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ta'pî to'ya: —Tiaronkon pîika'tîpîtî'pîya tîîse î' wani' awanî ye'nen aawarîrî awe'pîika'tî pepîn! Moriya Judeuyamî' esa' pe awanî pepîn mîrîrî. Seru'ye' pe awanî. Maasa see autîkî mîrîrî pakî'nan poi, innape awautîsa' era'ma annaya ya, innape akupî annaya —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—Pena “Paapa narima'pî uurî”, taapîtî'pîiya, innape Paapaya ipîika'tî tîku'se. Moropai “Paapa munmu uurî”, ta'pîiya. Maasa kin see, Paapa munmu pe awanî ya, tîwî Paapaya ipîika'tî sîrîrîpe, era'mato'pe annaya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Moropai mîrîrî warantî inkamoro ama'ye'kon Jesus ratai winî ipokapî'sa'kon wo'ma'ta'pî nîrî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mîrîrî tîpo ineka'ta pairî wei tîîse, pata ewaronpamî'pî. Tamî'nawîrî pata wanî'pî ewaron pe, 3 horas kaisarî aako'mamî'pî ewaron pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Moropai ko'mamîiya 3 horas tîîse, Jesus entaime'pî meruntî ke: —Eloi, Eloi lamá sabactâni? —ta'pîiya tîmaimu ta. Paapa, uyun, î' wani' awanî ye'nen urumaka pî' nan? taato' mîrîrî umaimukon ta. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mîrîrî taa Jesusya eta'pî tiaronkon pemonkonyamî'ya. Moropai ta'pî to'ya: —A'kî, Elias, taiya —kai'ma to' esenumenka'pî tîîse yairî pra etasa' to'ya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ka'ne' pe tiwin yonpa eka'tumî'pî tuna yu'nanen esponja era'mai. Mîrîrî yeuronka'pîiya uva yekku ka. Moropai mîrîrî tîrî'pîiya, yei po'tî pî' tasi'tîi inta pona, Jesusya yu'nato'pe kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tîîse tiaronkonya ta'pî ipî': —Kaane, tîwî mîîkîrî nîsi. Maasa Elias iipî era'mapai'nîkon pakî'nan poi imo'kai, ipîika'tîpa —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Moropai Jesus entaime'pî meruntî ke tiwin kano'pî pe moropai tekaton eeturumaka'pî, aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mîrîrî yai epîremanto' yewî', Paapa pata'se' yuwa'to' kamisa e'karaka'pî arakkita pairî, kakîsiya pai mai winîkîi non ekaya. Moropai non eserentîkî'ma'pî, moropai sa'man pe tîwe'sen tî'kon e'rataika'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mîrîrî yai tu'kankon Paapa pemonkonoyamî' e'tî'ka'san uuruwasikon atarakkanmoka'pî. Moropai inkamoro isa'manta'san e'mî'sa'ka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Moropai inkamoro epa'ka'pî uuruwai yapai. Moropai tîîsa'manta tîpo Jesus e'mî'sa'kasa' yai inkamoro ewomî'pî Jerusalém cidaderî pona, o'non pata tu'kankonya to' era'ma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Surarayamî' yepotorî Romanoya, moropai mîîkîrî yarakkîrî tîwe'sanonya, Jesus era'ma pî' tîwe'sanon anî'ya imo'ka namai, inkamoroya pata eserentîkî'ma era'ma'pî tamî'nawîrî mîrîrî tîwe'ku'sen. Mîrîrî ye'nen eranne' pe to' ena'pî mararî pra. Moropai ta'pî to'ya: —A'kî, innape Paapa munmu pe awe'sa' man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Miarî wîri'sanyamî' wanî'pî aminke si'ma, Jesus era'ma pî' tîwe'sanon. Inkamoro wîri'sanyamî' wanî'pî Jesus wenairî itî'san Galiléia poi ipîika'tîi itu'se awe'to' pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inkamoro wanî'pî Maria Madalena, moropai Maria, Tiago moropai itakon José yankon, moropai Zebedeu munkîyamî' yankon wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pata ewaronpamî kupî tanne, ipîkku warayo', José itese', Arimatéia cidaderî pon erepamî'pî. Mîîkîrî wanî'pî innape Jesus ku'nen pe. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mîîkîrî José wîtî'pî Pilatos pia Jesus esa'rî'pî esa'se yu'na'tîpa, moropai Pilatosya itîîto'pe to'ya ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mîrîrî ye'nen Jesus esa'rî'pî yapisî'pîiya. Moropai iwontî'pîiya amenan ita'san morî pu'kuru kamisa linho ke. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Moropai mîîkîrî yara'tî'pîiya ituruwasi pe ikonekasa', sa'man tî' yai, amenrî to' nîkoneka'pî ya'. Moropai mîrîrî uuruwai yettapuru pe ikonekasa' kure'nan tî' ke yettapurî'pîiya. Moropai mîrîrî tîpo attî'pî miarî pai. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mîrîrî kupîiya era'ma'pî Maria Madalenaya moropai tiaron Maria nîrî wanî'pî miarî. Mîrîrî uuruwai pia to' ereutasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tiaron wei yai, sexta feira esuwa'kasa' tanne, teepîremasanon esanon moropai fariseuyamî' emurukuntî'pî pata esa' Pilatos pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Moropai inkamoroya ta'pî pata esa' governador pî': —Anna yepotorî, anna enpenatan pî' man manni' seru'ye'ya ta'pî pî'. Pena enen tîwanî yai, ta'pîiya: “Eseurîwî'ne wei tîpo e'mî'sa'ka kupî sîrîrî”, ta'pîiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","—Mîrîrî ye'nen uuruwai era'manenan tonkon surarayamî' yarimakî, morî pe era'mato'pe to'ya iteseurîno wei pîkîrî neken. Maasa pra inenupa'sanya itesa'rî'pî yama'runpa namai. Moropai yama'runpa tîpo taa to'ya: “Mîîkîrî e'mî'sa'kan pî' man”, taa to'ya seru'ye' pe. E'mai' pe seru' pe Jesus wanî'pî yentai, seru' pe to' wanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mîrîrî pî' ta'pî Pilatosya: —Insamoro surarayamî' yaatî, uuruwai erasi'tîi. Atîtî uuruwai era'mai. Morî pe mera'matîi, era'maya'nîkon pîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Moropai inkamoro wîtî'pî. Inkamoroya uuruwai yettapuru koneka'pî moronpî ke, selo pe tîku'se aatarakkanmoka namai. Moropai era'manenan tonkon nîmî'pî to'ya, morî pe uuruwai era'mato'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judeuyamî' erî'ka'to' weiyu esuwa'kasa' tanne, e'mai'non wei yai, domingo yai, maasa pata erenmapî pra tîîse, Maria Madalena moropai tiaron Maria pokonpe to' wîtî'pî uuruwai pona era'mai. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mîrîrî yai ka'ne' pe kure'ne pata e'tînka'pî. Uyepotorîkon narima'pî inserî erepamî'pî ka' poi. Mîîkîrîya uuruwai yettaputo' tî' mo'ka'pî moropai mîrîrî pona eereuta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mîîkîrî wanî'pî wara'napiya sisiu taato' warantî. Moropai ipon wanî'pî aimutun pe, imu warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mîrîrî pî' mîrîrî uuruwai era'manenan surarayamî' ena'pî eranne' pe. Mararî pra tîtîtî pe to' esi'nî'sa' wanî'pî. Inkamoro esenumî'pî non pona, isa'manta'san warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mîrîrî ye'nen inserîya ta'pî inkamoro wîri'sanyamî' pî': —Eranne' pe pra e'tî. Jesus yuwaya'nîkon epu'tî pî' wai seru' pepîn, manni' pakî'nan pona to' nîpokapîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tîîse tarî anî' ton pra man. Mîîkîrî e'mî'sa'kan pî' man, ta'pî tîuya ne'tîkini yawîrî. Maasa ipata'pî era'matane'tî o'non pata itîrî'pî to'ya pata'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tarîpai ka'ne' pe atîtî ekareme'se inenupa'san pî'. “Mîîkîrî e'mî'sa'kan pî' man”, ka'tantî. Moropai “Mîîkîrî wîtî pe man arawîrî'nîkon Galiléia pona. Miarî era'maya'nîkon kupî sîrîrî”, ka'tantî to' pî'. Mîrîrî yekare ekaremekî pî' wai apî'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Inkamoro wîtî'pî ka'ne' pe teeka'tunse uuruwai poi. Maasa pra mararî pra to' esi'nî'sa' wanî'pî. Tîîse to' atausinpasa' wanî'pî nîrî mararî pra. Mîrîrî ye'nen Jesus nenupa'san pî' ekareme'se to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","To' wîtî tanne, ka'ne' pe Jesusya to' eporî'pî. Moropai ta'pîiya: —Tîwamîn wanî aapia'nîkon! Mîrîrî taiya pe to' erepamî'pî aminke pra iipia. Inkamoro e'sekunka'pî irawîrî. Inkamoroya Jesus puu pî' tapi'se yapurî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Moropai Jesusya ta'pî: —Eranne' pe pra e'tî, tîîse atîtî uyonpayamî' pî' ekareme'se to' wîtîto'pe Galiléia pona. Miarî uyera'mato'pe to'ya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Inkamoro wîri'sanyamî' tîîse e'ma ta, tiaronkon, uuruwai era'manenan surarayamî' enna'po'pî cidade pona. Moropai inkamoroya teepîremasanon esanon pî' tamî'nawîrî î' kai'ma awe'ku'sa' ekaremekî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Inkamoro emurukuntî'pî teserukon pî' teeseurîmakonpa Judeuyamî' panamanenan pokonpe si'ma. Inkamoroya ikoneka'pî. Mîrîrî ye'nen surarayamî' pia tîniru tîrî'pî to'ya mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Moropai to' yaipontî'pî to'ya: —Ka'tantî “Inenupa'san iipî'pî man, mîrîrî pe ewaron ya' anna wetun tanne. Inkamoroya Jesus esa'rî'pî yama'runpa'pî man”, makatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mîrîrî etasa' pata esa'ya ya, “Inna to' seruku pepîn mîrîrî”, taa annaya ipî'. Mîrîrî warantî awanî'pî man, seru' pîn taato'pe annaya. Mîrîrî ye'nen î' e'kupî pepîn amîrî'nîkon yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Inkamoro surarayamî'ya tîniru yapisî'pî. Moropai î' kai'ma teepîremasanon esanonya ta'pî yawîrî ikupî'pî to'ya. Mîrîrî seru' pe to' e'to' eseta'pî Judeuyamî' kore'ta pî' mîrîrî yai. Sîrîrî pe rî seru' pe to' e'to' ko'mamî sîrîrî tîpose. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inkamoro Jesus nenupa'san tiwin pu' pona tîîmo'tai'nîkon wîtî'pî Galiléia pona. Inkamoro erepamî'pî wî' Jesus nekaremekî'pî pia. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Miarî teerepansa'kon pe, Jesus era'ma'pî to'ya. Moropai yapurî'pî to'ya. Tîîse tiaronkonya innape ikupî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mîrîrî ye'nen Jesus erepamî'pî to' pia aminke pra. Moropai ta'pîiya: —Tamî'nawîron meruntî yapisî'pîuya ka' po moropai non po. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mîrîrî ye'nen ayaipontîuya'nîkon sîrîrî. Atîtî tamî'nawîronkon pemonkonyamî' kore'ta. Moropai inkamoro mîmatîi upemonkono pe tamî'nawîrî. Innape ukupî to'ya wenai to' menpatakonatîi uyun, Paapa ese' pî', moropai uurî, inmu ese' pî', moropai Morî Yekaton Wannî ese' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Moropai inkamoro menupatîi tamî'nawîrî î' ta'pîuya yawîrî to' komanto'pe, umaimu yawîrî. Moropai enpenatatî aapia'nîkon uurî ko'mamî pe wai wei kaisarî. Amîrî'nîkon rumakauya pepîn. Sîrîrî pata ataretî'ka pîkîrî aapia'nîkon uuko'mamî —ta'pî Jesusya.");
INSERT INTO mbcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","E'pîika'tînto' yekare, Jesus, Paapa nîmenka'pî pî' teeseurîmasen ekaremekîuya sîrîrî. Mîîkîrî Jesus Cristo wanî Paapa munmu pe. Sîrîrî warantî penaro' Paapa maimu ekareme'nenya imenuka'pî, Isaías nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Paapaya ta'pî: —A'kî, umaimu ekareme'nen yaipontîuya kupî sîrîrî arawîrî. Mîîkîrîya aye'marî ton koneka kupî sîrîrî keren po. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Uyepotorîkon erepamî ye'marî ton konekatî. To'sarî yarakkanmokatî eerepanto'pe”, taiya kupî sîrîrî —ta'pî Paapaya. Mîrîrî warantî menuka'pî Isaías nurî'tîya yawîrî Joãoya ta'pî pemonkonyamî' ekonekato'pe Jesus Cristo erepamî rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isaíasya imenuka'pî yawîrî João iipî'pî keren pona. Arinîkon pemonkonyamî' eperepî'pî iipia. Tiaronkon yenpatakona'pîiya moro. Paapa maimu ekaremekî'pîiya. —Imakui'pî ankupî'pîkon pî' enpenatatî teesewankono'mai —ta'pîiya. —Moropai irumakatî, imakui'pî ankupî'pîkon ku'to'pe Paapaya tîîwanmîra. Moropai esenpatakonatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judéia pata poro tîîko'mansenon wîtî'pî João pia, tamî'nawîrî. Jerusalém ponkon wîtî'pî nîrî. Imakui'pî tînkupî'pîkon ekaremekî'pî to'ya, moropai to' yenpatakona'pî Joãoya iren Jordão ka'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mîrîrî yai João pon wanî'pî camelo si'potî'pî pe. Moropai iworomî wanî'pî paaka pi'pî pe. Ito' wanî'pî kaira pe. Moropai wan wanî'pî iwuku pe. ˻Penaron Paapa maimu ekareme'nen Elias nurî'tî ko'mamî'pî warantî aako'mamî'pî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Itekare ekareme'pîtî'pîiya: —Uye'ma'pî pî' uyentainon iipî kupî sîrîrî —taapîtî'pîiya. —Ipîkku pe awanî ye'nen i'sa'sa' yewa yeukauya eserîke pra awanî, itarumai'pî pe wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Uurîya ayenpatakonakon tuna ke. Tîîse Mîîkîrîya Morî Yekaton Wannî yarima kupî sîrîrî ayesa'kon pe aako'manto'pe, ayewankon ya' —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Moropai Jesus iipî'pî Nazaré poi. Mîrîrî Nazaré wanî'pî Galiléia pata po tîwe'sen pe. João Batista pia aaipî'pî. Moropai mîîkîrî Joãoya Jesus yenpatakona'pî iren Jordão ka'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tuna kapai teeseu'ka pe, ka' esettapuruka era'ma'pî Jesusya. Moropai Morî Yekaton Wannî autî era'ma'pîiya tîpona, waku'kaimî warantî awautî era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka' po si'ma Paapa eseurîma'pî: —Amîrî unmu, uwakîri pu'kuru kure'ne apî' uurî atausinpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mîrîrî tîpo Morî Yekaton Wannîya Jesus yarî'pî keren pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Moro aako'mamî'pî asakî'ne pemonkon (40) wei kaisarî keren po. Kamoyamî' pata ya' awanî'pî. Imakui'pî kupî Jesusya emapu'tî yonpa'pî Makuiya, pemonkonyamî' yeka'nunkanenya teuren. Tîîse ikupîiya pra awanî'pî. Moropai iipiapai Makui wîtî'pî. Mîrîrîya ka' poi inserîyamî' autî'pî iipia moropai ipîika'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","João Batista yarakkamo me'po'pî iteyatonya. Mîrîrî tîpo Jesus wîtî'pî Galiléia pata pona. Miarî morî Paapa yekare ekaremekî pinunpa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Aminke pra tamî'nawîronkon esa' pe Paapa ii'to' weiyu eseponî pî' man. Tîpemonkonoyamî' pîika'tîiya kupî sîrîrî —ta'pî Jesusya. —Imakui'pî ankupî'pîkon pî' enpenatatî teesewankono'mai. Moropai irumakatî. Innape itekare ku'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galiléia ku'pî rî'pîkîrî Jesus wîtî'pî. Tuutî pe Simão era'ma'pîiya, moropai itakon André yarakkîrî. Moro' yapi'to' tîuya'nîkon yenunpîtî pî' to' wanî'pî, moro' yapisî pî', moro' yapi'nenan pe inkamoro wanî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Aase'nîkon upîkîrî —ta'pî Jesusya to' pî'. —Moro'yamî' yapisî pî' eesenyaka'makon ko'mannîpî sîrîrî. Tarîpai ayenupauya'nîkon pemonkonyamî' maakonpa upemonkono pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Teesemi'tapai moro' yapi'to' tîuya'nîkon nîmî'pî to'ya. To' wîtî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Inî' panpî' tuutîkon ye'ka pe, Zebedeu munkîyamî' era'ma'pîiya, Tiago moropai itakon João. Tîkanaukon ya' to' wanî'pî moro' yapi'to' tîuya'nîkon rumentannî'pîtî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Inkamoro yanno'pîiya. Tunkon Zebedeu nîmî'pî to'ya kanau ya' tîpoitîrîtonon pokonpe tîîse, moropai Jesus pîkîrî to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","To' erepamî'pî Cafarnaum cidaderî pona. Tonpakon Judeuyamî' erî'ka'to' weiyu yai, Jesus ewomî'pî to' epere'to' yewî' ta moropai tamî'nawîronkon yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kure'ne to' esenumenka'pî Jesusya tenupato'kon pî', maasa pra tînepu'tî pî' eeseurîma epu'tî'pî to'ya, Moisés nurî'tîya yenupanto' pî' yenupatonkon warantî pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mîrîrî yai o'ma' yarakkîrî tîwe'sen warayo' wanî'pî. Jesus era'ma tîuya pe mîîkîrî entaime'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesus Nazaré poinon, î' ku'se aai'sa' sîrîrî anna pî'? —ta'pîiya. —Anna taruma'tîi aai'sa' sîrîrî? —ta'pîiya. —Ayepu'nen uurî. Amîrî morî, Paapa piapai iipî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusya ta'pî ipî': —Moo e'kî, mîîkîrî warayo' yapai epa'kakî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","O'ma'ya warayo' perenperenma'pî. Aronne panpî' tîwentaimepîtî ye'ka pe, eepa'ka'pî mîîkîrî yapai. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mîrîrî pî' tamî'nawîronkon esenumenka'pî kure'ne. Tîmurukun pe si'ma to' eseurîma'pî. —Î' taato'pe see awanî mîrîrî? —ta'pî to'ya. —A'kî, uneta'pîkon pepîn pî' uyenupaiya'nîkon mîrîrî. Paapa meruntîri ke o'ma'kon yaipontîiya moropai yuuku to'ya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Moropai pata kaisarî tamî'nawîronkon eseurîma'pî Jesus yekare pî'. Tamî'nawîrî Galiléia pata poro to' eseurîmato' eseta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus epa'ka'pî epere'nîto' yewî' tapai moropai attî'pî Tiago, João pokonpe Simão yewî' ta. Itakon André yewî' pe nîrî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pri'ya pra Simão yawo'pî wanî'pî paran pî'. Jesus erepansa' pe, mîîkîrî pri'yawon pepîn ekaremekî'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iipia Jesus wîtî'pî. Itenya pî' yapisî'pîiya. Moropai i'mî'sa'ka'pîiya. Eekomi'makapî'pî moropai to' yekkari ton koneka pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ko'mamîiya wei ewomî tanne, pri'yawonkon pepîn enepî'pî to'ya Jesus pia. O'ma'kon e'to'kon to' ya' enepî'pî to'ya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tamî'nawîronkon mororonkon epere'sa' wanî'pî mana'ta pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Moropai arinîkon pri'yawonkon pepîn yepi'tî'pîiya. Tu'kan paran pî' tîwe'sanon yepi'tî'pîiya. Moropai tu'kankon o'ma'kon yenpa'ka'pîiya. Inkamoro o'ma'konya Paapa narima'pî pe Jesus wanî epu'tî'pî. Tîîse inkamoroya tekaremekî yu'se pra Jesus wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Penane marî, pata erenmapî pra tîîse, Jesus e'mî'sa'ka'pî, moropai attî'pî wîttîkon tapai keren pona. Miarî eepîrema'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tîwe'mî'sa'kakon pe, Simão moropai yarakkîronkonya Jesus yuwa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eporî'pî to'ya moropai ta'pî to'ya ipî': —Ayuwa pî' tamî'nawîronkon man. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta'pî Jesusya: —Tiaron pata pona wîtînpai'nîkon, miarî nîrî itekare ekareme'to'peuya. Mîrîrî ku'se yi'nî pî' wai —ta'pîiya. Moropai to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galiléia poro Jesus wîtî'pî tamî'nawîrî. To' epere'to' yewî' tapî' itekare ekareme'pîtî'pîiya moropai o'ma'kon yenpa'kapîtî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Moropai ere' pokon warayo' wîtî'pî Jesus pia, paran pokon, leprosia itese'. Awe'sekunka'pî Jesus rawîrî. —Uyepi'tîpai awanî ya, Uyepotorî, uyepi'tîkî —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesusya era'ma'pî tî'noko'pî pe. Tenya tîrî'pîiya ipona. —Inna, ayepi'tîuya —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mîrîrî pe rî erekî' pe pra eena'pî. Eesepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Meruntî ke Jesusya mîîkîrî panama'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Anî' pî' kîsekaremekîi —ta'pîiya. —Atîkî teepîremasanon pia ayera'mato'pe to'ya. Pena Moisés nurî'tîya ta'pî: “Leprosia pokon esepi'tîsa' ya, asakî'ne mayayamî' tîrîiya teepîremasanon pia, teesepi'tîsa' ye'nen”, ta'pîiya. Mîrîrî warantî itîîta, eesepi'tîsa' ye'nen. Atîkî, ka'ne' panpî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tîîse mîîkîrî epa'ka'pî moropai tamî'nawîronkon pî' ekaremekî'pîiya. Mîrîrî pata pai Jesus ewomî pra eena'pî pemonkonyamî' pata ya' maasa pra arinîkon pemonkonyamî' iipî'pî iipia. Poro po aako'mamî'pî, tîîse tamî'nawîron pata yapai arinîkon wîtî'pî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pata poro taasarî tîpo, Cafarnaum pona Jesus enna'po'pî tewî' ta. Tewî' ta awanî eta'pî tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Arinîkon eperepî'pî iipia. To' pata'se' ton pra awanî'pî wîttî ta moropai mana'ta po. Miarî Paapa maimu ekaremekî pî' Jesus wanî'pî to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mîrîrî tanne pemonkonyamî' erepamî'pî. Eke'nepamî'pî warayo' ene'sa' to'ya wanî'pî Jesus pia. Tamî'nawîrî itesa' eke'nepansa' wanî'pî. Asakîrîronkon warayo'konya mîîkîrî yarî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jesus pia mîîkîrî yarî to'ya yentai awanî'pî. Mîrîrî ye'nen wîttî pona to' enuku'pî. Maasa pra se' kaisarî wîttî wanî'pî, ineka'ta ton pra. Moropai yamîka'pî to'ya Jesus kaisarî. Moropai mîîkîrî pri'yawon pepîn yenu'tî'pî to'ya Jesus pia, mîrîrî a'ta yai, tette' ta tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Innape tîkupî to'ya epu'tî'pî Jesusya. Mîrîrî ye'nen ta'pîiya eke'nan pî': —Mooyi, imakui'pî ankupî'pî rona pî' wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisés nurî'tîya yenupanto' pî' yenupanenan ereutasa' wanî'pî moro. Jesus maimu pî' to' esenumenka'pî tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Î' ton pe mîîkîrî eseurîma mîrîrî warantî? Anî'ya imakui'pî pe warayo' e'to' mo'ka pepîn, Paapa pe pra si'ma, tîîse Paapaya neken imo'ka. Mîrîrî ye'nen Paapa pe awe'ku'sa' mîrîrî —kai'ma to' esenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mîrîrî warantî to' esenumenka tîpî' epu'tî'pî Jesusya. Mîrîrî ye'nen to' pî' ta'pîiya: —Î' ton pe mîrîrî warantî eesenumenkakon mîrîrî ayewankon ya'? ");
INSERT INTO mbcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Imakui'pî ankupî'pî rona pî' wai taa pî' wai mîserî pri'yawon pepîn pî'. Tîîse innape iku'sau'ya epu'tîya'nîkon eserîke pra awanî. Mîrîrî ye'nen Uurîya, pemonkon pe ka' poi iipî'pîya anera'makon ton kupî sîrîrî. Meruntî ke wai imakui'pî ronato'peuya —ta'pî Jesusya. —Seru' pe pra eseurîma epu'tîkonpa, mîîkîrî pri'yawon pepîn yepi'tîuya. I'mî'sa'kauya, tette' yanmako'mato'peiya aasato'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Moropai Jesusya pri'yawon pepîn yeurîma'pî: —E'mî'sa'kakî. Ayette' yanmako'makî. Ayewî' ta enna'pokî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Moropai awe'mî'sa'ka'pî. Ka'ne' pe tette' yanmako'ma'pîiya moropai tamî'nawîronkonya tera'ma tanne, eepa'ka'pî. Mîrîrî pî' tamî'nawîronkon esenumenka'pî kure'ne. —Morî pu'kuru, Paapa —ta'pî to'ya. —Mîrîrî ye'ka era'manenan pepîn anna —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mîrîrî tîpo Jesus epa'ka'pî mîrîrî cidaderî yapai. Moropai attî'pî inî'rî Galiléia ku'pî ka'. Miarî arinîkon pemonkonyamî' wîtî'pî iipia. Moropai inkamoro yenupa pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Taasarî ye'ka pe Alfeu munmu eporî'pîiya, itese' Levi. Tîniru yapi'nen pe awanî'pî. Teesenyaka'mato' pata'se' ya' eereutasa' wanî'pî. —Aase upîkîrî, ayenupato'peuya —ta'pî Jesusya ipî'. Moropai attî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mîrîrî tîpo Levi yewî' ta Jesus entamo'ka tanne, arinîkon imposto ton tîniru yapi'nenan entamo'ka'pî ipokonpe moropai tînenupa'san pokonpe. Imakui'san pemonkonyamî' entamo'ka'pî nîrî to' pokonpe. Arinîke to' wanî'pî Jesus pîkîrî itî'san. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisés nurî'tîya yenupanto' pî' yenupanenan moropai fariseuyamî' wanî'pî moro. Inkamoroya Jesus era'ma'pî. Imakui'san pemonkonyamî' moropai imposto yapi'nenan pokonpe awentamo'ka era'ma'pî to'ya. Mîrîrî pî' ta'pî to'ya Jesus nenupa'san pî': —Î' ton pe mîîkîrî entamo'ka imposto yapi'nenan pokonpe, imakui'san pokonpe? ˻Morîkon pemonkonyamî' anna warainîkon entamo'ka pepîn imakui'san pokonpe. Imakui'pî kupîiya mîrîrî˼ —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mîrîrî taa to'ya eta'pî Jesusya. Moropai ta'pîiya to' pî': —Pri'ya pu'kuru e'nî ya, uyepi'tînenkon ton pemonkon yuwa pepîn. Tîîse pri'ya pra e'nî ya, uyepi'tînenkon ton pemonkon yuwa e'painon. Mîrîrî warantî morî pe tîwe'ku'sanon pemonkonyamî' yannoi uui'sa' pra wai. Tîîse imakui'pî pe tîwe'ku'sanon pemonkonyamî' yannoi iipî'pî uurî. ˻Imakui'pî pe tîwanîkon epu'tî tîuya'nîkon ye'nen, tîpîika'tîto'kon ton yu'se to' wanî˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Judeuyamî' yeseru yairî Paapa yapurî ye'ka pe, ta're'kon tonpai pra João Batista pemonkonoyamî' wanî'pî. Tiaronkon wîtî'pî Jesus pia moropai ta'pî to'ya ipî': —Ta're'kon tonpai pra João pemonkonoyamî' man, fariseuyamî' man nîrî mîrîrî warantî. Tîîse apemonkonoyamî' wanî inkamoro warantî pra. Î' wani' awanî ye'nen uyeserukon yairî pra to' wanî mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta'pî Jesusya to' pî': —Tîneta'san pokonpe tîwe'marimasen wanî tanne, ta're'kon tonpai pra ineta'san wanî pepîn. To' pokonpe tîwe'marimasen ko'mamî pîkîrî ta're'kon tonpai pra to' wanî pepîn. To' entamo'ka, moropai to' atausinpa. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Uurî wanî tîwe'marimasen warantî, moropai unenupa'san wanî ineta'san warantî. Maasa umo'ka tiaronkonya kupî sîrîrî unenupa'san piapai. Mîrîrî yai unenupa'sanya ta're'kon yonpa pepîn teesewankono'makon ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Ipoi'pî uponkon rumentannî'pî pepîn e'painon kamisa amenan ke. Irumentanî'pî ya, irumentanî'to' emo'ka ipoi. Amenan emo'ka ipoi'pî poi moropai inî' panpî' awe'karaka. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Moropai amenan wo', mai' pe teenasen tîrî pepîn e'painon penaro' itense' ya', cabra pi'pî konekasa' penaro' ya' —ta'pîiya. —Maasa pra wo', mai' pe teenasen yannîpî, moropai awannî'sa' pe penaro' cabra pi'pî karakaiya, moropai wo' eti'kamo. Mîrîrî epu'tî'nîkon ye'nen, amenan wo' tîrî amenan itense' ya' —ta'pî Jesusya. ˻Mîrîrî ta'pîiya amenan esenupanto' pî' tenupaiya'nîkon epu'to'pe to'ya.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mîrîrî tîpo erî'ka'nîto' weiyu yai, Jesus asarî'pî trigo ye'kana' pî'. Tuutîkon ye'ka pe inenupa'sanya trigo pikka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mîrîrî kupî to'ya era'ma'pî fariseuyamî'ya. —A'kî, to' esenyaka'ma mîrîrî erî'ka'nîto' weiyu yai. Trigo pikka pî' to' man, erî'ka'nîto' weiyu yai. Moisés nurî'tîya uyenupa'pîkon yawîrî pra to' wanî ye'nen, yairî pra to' wanî mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Moropai ta'pî Jesusya to' pî': —Pena Judeuyamî' yepotorî rî'pî Davi nurî'tî wanî'pî î' ton pra. Emi'ne awanî'pî tîpokonpankon pokonpe. Abiatar wanî'pî teepîremasanon yepotorî pe mîrîrî yai. Paapa maimu pe awe'menukasa' mîrîrî, to' nîkupî'pî. Paapa yewî' ta Davi ewomî'pî. ˻Moro awanî'pî trigo puusa' teepîremasanon nîtîrî'pî Paapa pia. Paapaya taasa' wanî'pî mîrîrî tîîto'pe to'ya moropai aako'mamî tîpo, ya'to'pe to'ya. Tîîse teepîremasanonya neken yaku taasa' Paapaya wanî'pî.˼ Tîîse emi'ne tîwanî ye'nen, Daviya yaku'pî moropai itîrî'pîiya nîrî tîpokonpankon pia. ˻Tîîse mîrîrî pî' Paapa ekore'ma pra awanî'pî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pemonkonyamî' koneka'pî Paapaya e'mai' pe. Mîrîrî tîpo erî'ka'nîto' weiyu ekaremekî'pîiya pemonkonyamî' ton pe to' pîika'tîpa kai'ma. Pemonkonyamî' konekaiya pra awanî'pî erî'ka'nîto' weiyu yeseru pî' to' esekatonkato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Moropai uurî, ka' poi iipî'pî, uurî wanî erî'ka'nîto' weiyu yai tamî'nawîronkon nîkupî ton ekareme'nen pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Inî'rî Jesus ewomî'pî epere'nîto' yewî' ta. Moro awanî'pî warayo' apîta'pî itenya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tiaronkon esenumenka'pî Jesus pî'. Erî'ka'nîto' weiyu yai mîîkîrî yepi'tî Jesusya anepu'pai to' wanî'pî, imakui'pî konekaiya taakonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","—Asi'kî uupia —ta'pî Jesusya apîta'pî itenya pî'. —E'mî'sa'kakî tamî'nawîronkonya ayera'mato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tamî'nawîronkon ekaranmapo'pî Jesusya: —Moisés nurî'tîya yenupanto' yawîrî, î' kupîuya e'painon erî'ka'nîto' weiyu yai? Morî kupîuya ya, morî pe awanî? Imakui'pî kupîuya ya, morî pe awanî? Anî' pîika'tîuya ya aasa'manta namai, morî pe awanî? Anî' rî wîuya ya, morî pe awanî? O'non ye'ka pe eporî pî' naatî? Ka'tî upî' —ta'pîiya. Tîîse moo to' wanî'pî, yuuku to'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Teekore'masa' ye'ka pe, Jesus esenumenka'pî tamî'nawîronkon pî'. Eekore'ma'pî maasa pra mîrîrî pri'yawon pepîn sa'nama to'ya pra awanî ye'nen. —Ayenya kainunkî —ta'pîiya apîta'pî itenya pî'. Tenya kainumî'pî warayo'ya moropai eesepi'tîsa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mîrîrî tîpo fariseuyamî' epa'ka'pî epere'nîto' yewî' tapai. Moropai Herodes pemonkonoyamî' pokonpe to' eseurîma'pî Jesus pî', iwîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Moropai Jesus wîtî'pî tîpemonkonoyamî' pokonpe iku'pî ena pona. Arinîkon Galiléia ponkon wîtî'pî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Moropai Judéia ponkon, Jerusalém ponkon, Iduméia ponkon, Jordão ratai ponkon, Tiro moropai Sidom poro tîîko'mansenon wîtî'pî arinîke Jesus wenairî. Pri'yawonkon pepîn yepi'tîpîtî'pîiya yekare etasa' tîuya'nîkon ye'nen to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Arinîkon pri'yawonkon pepîn yepi'tîsai'ya wanî'pî. Tamî'nawîronkon pri'yawonkon pepînya iwoima'tî'pî kîrîppe yapîkonpa, teesepi'tîkonpa kai'ma. Mîrîrî ye'nen Jesusya ta'pî tînenupa'san pî': —Kanau ene'tî, ya' enu'to'pe. Pemonkonyamî'ya uwoima'tî pî' man kîrîppe. Arinîke to' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Moropai imariwa'ka'pankon moropai maawariyamî' poitîrîtononya Jesus era'masa' tîuya'nîkon ye'nen, to' esenunpîtî'pî iipia, tentai'nîkon Jesus wanî epu'tî tîuya'nîkon ye'nen. Aronne panpî' taapîtî'pî to'ya: —Amîrî Paapa munmu —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Moropai Jesusya to' yaipontî'pî. —Uurî kîsekareme'tî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Moropai Jesus epa'ka'pî wî' kîrîkon kore'ta pî'. Itu'se tîwe'to'kon pemonkonyamî' yanno me'po'pîiya. Moropai iipia to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Moropai asakî'ne pu' pona tîîmo'tai pemonkonyamî' mo'ka'pîiya tarakkîrî to' e'to'pe to' yenupapa kai'ma, to' yarimapa kai'ma itekare ekareme'se. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","To' meruntîri ton tîrî'pîiya, imariwa'yamî' moropai maawariyamî' yarimato'pe to'ya pemonkonyamî' piapai. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simão mo'ka'pî Jesusya moropai ese'tî'pîiya Pedro pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago, Zebedeu munmu, mo'ka'pîiya takon João yarakkîrî. Inkamoro ese'tî'pîiya Boanerges pe. Wara'napi warainokon taato' mîrîrî Boanerges. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André, Filipe, Bartolomeu, Mateus, Tomé, Alfeu munmu itese' Tiago, Tadeu, moropai Simão teepîsen Zelote taato', inkamoro mo'ka'pîiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Moropai Judas Iscariotes mo'ka'pîiya nîrî. Manni' Jesus yapisîton iteyatonon pia itîrîpa. ˻Moropai mîrîrî tîpo, Jesus emikku'pî tewî' ta.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mîrîrî warantî inkamoro mo'ka'pîiya tînaipontîkon ton pe. Moropai inî'rî arinîkon pemonkonyamî' eperepî'pî Jesus pia. To' pî' Jesus esenyaka'ma'pî, to' yenupa pî'. Mîrîrî ye'nen Jesus moropai inenupa'san entamo'ka yentai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mîrîrî yekare eta tîuya'nîkon pe, Jesus yonpayamî'ya ta'pî: —Ayawî' pe eena tu'kasa' man. A'kî, awentamo'ka pra awanî era'matî —ta'pî to'ya. Era'mai to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon Jerusalém poi iipî'san eseurîma'pî. —Maawariyamî' yepotorî poitîrî pe Jesus wanî mîrîrî, Belzebu poitîrî pe. (Makui mîîkîrî Belzebu) Maawariyamî' yepotorî meruntîri ke maawariyamî' yaipontîiya mîrîrî, Makui meruntîri ke —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Moropai Jesusya to' yanno'pî tîîpia. Morî panton ke to' yenupa'pîiya. —Makuiya maawariyamî' yarima pepîn pemonkonyamî' piapai, imaimu pe imakui'pî kupî to'ya mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tiwinan pata ya' tîîko'mansenon esiyu'pîtî ya, to' ko'mamî pepîn. To' epantaka. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Moropai tiwinan wîttî ta tîîko'mansenon esiyu'pîtî ya, to' ko'mamî pepîn. To' epantaka. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mîrîrî warantî Makuiya tîpoitîrîtonon yarima ya pemonkonyamî' yapai, tîîwarîrî eesiyu'pîtî e'painon moropai aako'mamî pepîn, awe'tî'ka e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tîîse meruntî yewî' ta ewonpai ama'ye' wanî ya itemanne yama'runpai, e'mai' pe meruntî ke tîwe'sen yaironpîtîiya kapuya ke. Mîrîrî tîpo yama'runpaiya e'painon. ˻Makui yentainon nekenya maawariyamî' yarima.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tamî'nawîron imakui'pî pemonkonyamî' nîkupî'pî moropai imakui'pî pe to' eseurîma'pî Paapa winîkîi kupî Paapaya tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tîîse Morî Yekaton Wannî pî' imakui'pî pe teeseurîmasen wanî ya, inkupî'pî kupî Paapaya pepîn tîîwanmîra. Ipatîkarî imakui'pî pe awanî Paapa pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mîrîrî ta'pî Jesusya, yairî pra tîpî' to' eseurîma ye'nen. Makuiya iku'sa' meruntî ke maawariyamî' yarimato'peiya, imariwa' yarimato'peiya, taasa' to'ya wanî'pî ipî'. Morî Yekaton Wannîya ikupî'pî meruntî ke, tîîse mîrîrî kupî to'ya pra awanî'pî innape. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mîrîrî tîpo Jesus yan moropai ita'mi'san erepamî'pî. Poro po si'ma yanno me'po'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Arinîkon pemonkonyamî' ereutasa' wanî'pî iipia. —A'kî, asan moropai aya'mi'san man poro po. Ayanno pî' to' man —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mîrîrî pî', ta'pî Jesusya: —Î' ye'ka kin pemonkonyamî' pî', maama' moropai mooyi tauya? ");
INSERT INTO mbcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tîîpia ereuta'san pî' eesenumenka'pî. —Tiaronkon tarî to' man. Inkamoro pî' maama' moropai mooyi tauya e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maasa pra itu'se Paapa e'to' ku'nen wanî ya, uyonpa pe awanî. Mîîkîrî pî', mooyi moropai ma'non moropai maama' tauya e'painon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tiaron pensa inî'rî Jesusya pemonkonyamî' yenupa'pî. Iku'pî ena po arinîkon pemonkonyamî' eperepî'pî iipia. Arinîke to' wanî ye'nen, Jesus asara'tî'pî tuna katawon kanau ya' moropai eereuta'pî. Pemonkonyamî' wanî'pî a'mun po, tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Inkamoro yenupa'pîiya morî panton ekaremekî ye'ka pe. Ta'pîiya to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—A'kî, warayo' wîtî'pî tînmîri pînse. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tînmîri ya' tînpîmî pîmî'pîiya isorokai'ma. Mîrîrî inpîmî yonpa ena'pî e'ma ta. Toronyamî' iipî'pî moropai yenno'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Moro nîrî inmîri ya', tî' parappa pon non mararon pona, tiaron inpîmî yonpa ena'pî. Mararî non wanî'pî. Mîrîrî ye'nen ka'ne' pe aaro'ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tîîse wei a'nasa' pe awa'pi'ta'pî. Kure'ne ikara wîtîto' ton pra awanî'pî. Mîrîrî ye'nen awa'pi'ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Moropai tiaron inpîmî yonpa ena'pî mî'nî ta. Mîrîrî kore'ta aaro'ta'pî. Tîîse mî'nî ye'ya itaruma'tî'pî. Mîrîrî ye'nen eepeta pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Moropai tiaron inpîmî yonpa ena'pî morî non pona. Mîrîrî aro'ta'pî, kure'ne eena'pî, moropai eepeta'pî. Tiaron epeta'pî, tîîse mararî iteperu wanî'pî. Tiaron epeta'pî moropai tu'ke panpî' iteperu wanî'pî. Tiaron epeta'pî mararî pra, tu'ke iteperu wanî'pî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Moropai ta'pî Jesusya to' pî': —Anepu'painon wanî ya, etakî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mîrîrî tîpo pemonkonyamî' wîtî'pî. Tîîse asakî'ne pu' pona tîîmo'tai'nîkon Jesus nenupa'san e'nîmî'pî. Tiaronkon e'nîmî'pî to' pokonpe. Mîrîrî yai inkamoroya Jesus ekaranmapo'pî. —Î' taa yu'se awanî sîrîrî morî panton ke anna pî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","—Ekaremekîuya apî'nîkon —ta'pî Jesusya. —Tiaronkon nepu'tî pepîn epu'tîya'nîkon kupî sîrîrî. Î' kai'ma tamî'nawîronkon esa' pe Paapa iipî kupî sîrîrî ekaremekîuya sîrîrî. Tiaronkonya epu'tî pepîn, tepotorîkon pe Paapa kupî to'ya pra awanî ye'nen. Unekaremekî eta to'ya panton pe, tîîse epu'tî to'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mîrîrî pî' Paapa maimu ekareme'nen Isaías nurî'tî eseurîma'pî pena. Isaíasya ta'pî: “Eta to'ya moropai era'ma to'ya, tîîse î' pe awanî epu'tî to'ya pepîn. Mîrîrî ye'nen imakui'pî winîpai to' era'tî pepîn. Imakui'pî to' nîkupî'pî kupî Paapaya pepîn tîîwanmîra,” ta'pî Isaías nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Unekaremekî'pî tînmîri pînnen pantoni epu'tîya'nîkon pra awanî ya, tiaron unekaremekî epu'tîya'nîkon eserîke pra awanî nîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Ipapoi'ma tînmîri pînnen warayo' warantî, ekareme'nenya itekare ekaremekî pata kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","E'ma ta ena'san warantî tiaronkon wanî. Itekare eta to'ya, tîîse ka'ne' pe Makui wîtî moropai itekare, to' neta'pî mo'kaiya, inî'rî to' enpenata namai ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Moropai tî' pon non pona ena'san warantî tiaronkon wanî. Itekare eta tîuya'nîkon pe yapisî to'ya. Mararî pra to' atausinpa. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tîîse sa'me yapisî to'ya pra awanî tewankon ya'. Mîrîrî ye'nen mararî rî to' ko'mamî mîrîrî. Itekare wenai to' e'taruma'tîsa' ya, ka'ne' pe irumaka to'ya. Tiaronkonya to' taruma'tîsa' ya, itekare rumaka to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mî'nî ye'ka kore'ta ena'san warantî tiaronkon wanî. Itekare eta to'ya, ");
INSERT INTO mbcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tîîse to' yewan wanî sîrîrî pata po tînkonekakon pî' pu'kuru. Moropai kure'ne pu'kuru temannekon yapurî to'ya. Moropai inî' panpî' temannekon ton yu'se to' wanî. Mîrîrî ye'kaya itekare taruma'tî. Moropai mîrîrî wenai eepeta pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Moropai yanunsa' non pona ena'san warantî tiaronkon wanî. Itekare eta to'ya moropai yapisî to'ya. Mararî tiaron inpîmî yonpa epeta'pî warantî, tiaronkonya Paapa maimu kupî, tîîse mararî. Tu'ke panpî' tiaron epeta'pî warantî, tiaronkonya Paapa maimu kupî kure'ne panpî'. Mararî pra tiaron epeta'pî warantî, tiaronkonya Paapa maimu kupî mararî pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tiaron morî panton ekaremekî'pî Jesusya: —Uweiyukon enepî pepîn wari'sa' yo'koi itîîto'pe —ta'pîiya. —Itîrî pepîn nîrî we'nannîto' yaponse' yo'koi, tîîse enepî itaponse' pona itîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sîrîrî î' rî esenonsa' ya, mîrîrî esera'ma tiaron pensa. Mîrîrî warantî morî panton unekaremekî epu'tî tiaronkonya pepîn sîrîrî. Tîîse tiaron pensa epu'tî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Anepu'pai awanîkon ya, moo si'ma etatî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","—Morî pe etatî —ta'pîiya to' pî'. —Etaya'nîkon kaisarî inî' panpî' Paapa maimu epu'tîya'nîkon. Moropai etanenanya inî' panpî' epu'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Umaimu anepu'painon wanî ya, Paapaya itîrî inî' panpî' epu'to'peiya. Tîîse anepu'painon pepîn wanî ya, epu'tîiya pepîn. Maasa pra tîneta'pî kupîiya tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Inî'rî morî panton ekaremekî'pî Jesusya. Î' kai'ma awanî pe man tamî'nawîronkon esa' pe Paapa iipî ya epu'to'pe to'ya. See warantî ta'pîiya: —Warayo'ya tekkari yena'pî pîmî'pî ipapoi'ma kawai yena'pî pîmî warantî. Moropai eemikku'pî tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Teseru ta ewaron ya' iwe'napîtî'pî moropai wei epa'ka tanne, aapakapîtî'pî. Mîrîrî tanne, inpîmî'pî aro'ta moropai aarenta. Tîîwarîrî aaro'ta'pî non yapai, aareta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Moropai aarenta'pî. Moropai eepeta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mîrîrî tîpo ya'tî'pîiya ya'tîto' weiyu eseposa' ye'nen. Tîîse î' wani' awanî ye'nen tînpîmî'pî aro'ta epu'tîiya pra awanî'pî. Î' wani' awanî ye'nen eepeta epu'tîiya pra awanî. ˻Mîrîrî warantî tiaronkonya Paapa yapisî tepotorîkon pe, itekare eta tîuya'nîkon ye'nen. Tîîse o'non ye'ka pe Paapa esenyaka'ma epu'tî to'ya pepîn,˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","—Tiaron morî panton ekaremekîuya sîrîrî, î' kai'ma awanî pe man tamî'nawîronkon esa' pe Paapa iipî ya epu'tîkonpa —ta'pî Jesusya. —See warantî arinîkon pemonkonyamî' yepotorî pe Paapa wanî pe man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Mostarda ye' ta'sen yare ena'pî wanî tamî'nawîron ena'pî ma're simonkokon pe itena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tîîse mîrîrî ena'pî pînsa', moropai aarenta, moropai kure'ne eena tamî'nawîron parî' yentai. Mararî pra aapantatapîtî. Toronyamî'ya taponse'kon ton koneka iporo i'nî' ya. E'mai' pe si'mîrikkî pe itena'pî wanî'pî, tîîse maasa kure'ne ite' ena'pî. Mîrîrî warantî mararonkonya Paapa yapisî'pî sîrîrî tepotorîkon pe. Tîîse maasa arinîkonya yapisî kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mîrîrî warantî morî panton ke itekare ekaremekî'pîiya to' pî'. Ekaremekî'pîiya epu'tî to'ya kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Panton pe pra to' yeurîmaiya pra awanî'pî. Tîîse tîpemonkonoyamî' yarakkîrî neken tîwanî yai, tînekaremekî'pî ekareme' tu'ka'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mîrîrî ko'mamîiya yai, ta'pîiya tîpemonkonoyamî' pî': —Iyarî'nîkon. Kuru'nî'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aasîrî kanau ya' awanî'pî. Tamî'nawîronkon nîmî'pî to'ya moropai Jesus yarî'pî inenupa'sanya. Moropai tiaronkon wîtî'pî tîkanaukon ya' ipîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mîrîrî iku'pî nuurukkutî to'ya tanne, kure'nan a'situn iipî'pî tiwinarî. Sipa sipa pe tuna wanî'pî. Tuna ewomî'pî kanau ya. Kanau yannîpî yonpa'pî tunaya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mîrîrî tanne, Jesus we'nasa' wanî'pî kanau maikko ya'. Tî'mî ye'pî ya'santîsai'ya wanî'pî. Moropai mîîkîrî yenpaka'pî to'ya: —Apakakî —ta'pî to'ya. —Î' ton pe sa'mantan tanne, awetun mîrîrî î' kupîya pra? Apakakî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mîrîrîya Jesus paka'pî moropai a'situn tî'napannîpî'pîiya tîmeruntîri ke. A'situn pî' ta'pîiya: —Tî'napankî. Tuna pî' ta'pîiya: —Tî'napankî. Tuna nîrî tî'napannîpî'pîiya tîmeruntîri ke. Se' kaisarî tuna eena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mîrîrî tîpo ta'pîiya to' pî': —Î' ton pe eesi'nî'pîtîkon? Innape ukupîya'nîkon pra awanîkon mîrîrî, aapia'nîkon pu'kuru wanî tanne —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mîrîrî mararî pra to' esenumenka'pî ipî'. Tîmurukun pe si'ma to' eseurîma'pî ipî': —Î' ye'ka Mîîkîrî pemonkon? A'situn tî'napannî'nen tîmeruntîri ke moropai tuna tî'napannî'nen nîrî tîmeruntîri ke. O'non ye'ka pe renamo awanî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","To' erepamî'pî iku'pî ratai pona. Gerasenoyamî' pata pona to' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kanau yapai Jesus eseu'ka pe, uuruwai kore'tapai warayo' iipî'pî iipia. O'ma' ewonsa' wanî'pî mîîkîrî warayo' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uuruwai kore'ta tîîko'mansen pe mîîkîrî wanî'pî, tî' ta, e'pîyamî' kore'ta tîîko'mansen. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tu'ke ite'ka yewa'tîpîtî'pî to'ya sa'man ferro ke itenya pî' moropai i'pu pî'. Tîîse yewa'tî to'ya kaisarî tewa'tîto' ya'tîpîtî'pîiya tiwinarî. Anî'ya yewa'tî yentai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Awentaimepîtî'pî ewaron kaisarî moropai wei kaisarî uuruwai kore'ta si'ma. Aako'manto'pe rî awanî'pî. Awe'pa'tîpîtî'pî nîrî tî' ke. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aminke si'ma Jesus era'ma tîuya pe, eeka'tumî'pî iipia moropai awe'sekunka'pî irawîrî. Tamî'nawîronkon yentainon mîserî, kai'ma eesenumenka'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesusya ta'pî ipî': —Mîîkîrî yapai epa'katî, o'ma'kon —ta'pîiya. Meruntî ke warayo' entaime'pî. —Jesus amîrî ka' po tîîko'mansen munmu. Amîrî Paapa munmu. Î' ku'se aai'sa' uyarakkîrî? Ayeka'nunkauya sîrîrî. Paapaya eta tanne, ataruma'tîuya pepîn ka'kî upî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Moropai Jesusya mîîkîrî ekaranmapo'pî. —Anî' ayese'? —ta'pîiya. —Uyese' tu'kan, maasa pra arinîkon anna —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mararî pra Jesus yeka'nunka'pî o'ma'ya. —Anna kîsaipontîi tiaron pata pona —taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aminke pra ikîrî po arinîkon porcoyamî' wanî'pî tekkarikon ena'nenan. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","O'ma'konya Jesus yeka'nunka'pî. —Anna yaipontîkî porcoyamî' kore'ta anna ewonto'pe to' ya' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Atîtî, moriya —ta'pî Jesusya. O'ma'kon epa'ka'pî mîîkîrî warayo' yapai moropai porcoyamî' ya' to' ewomî'pî. Moropai porcoyamî' eka'tumî'pî ikîrî poi tuna kata. Moropai to' e'soroka'pî tuna ka' moropai to' anarî'pî. Arinîke to' wanî'pî, 2.000 kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mîrîrî era'ma tîuya'nîkon yai, porcoyamî' era'manenan wîtî'pî. Tînera'ma'pîkon ekaremekî'pî to'ya tamî'nawîronkon pî', cidade ponkon pî' moropai poroponkon pî'. Mîrîrî ya pemonkonyamî' wîtî'pî o'non ye'ka pe awanî era'mai. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Moropai Jesus pia to' erepamî'pî. Mîîkîrî warayo' o'ma'kon yenpî' eporî'pî to'ya. Eereutasa' wanî'pî, tîpon ke ayawî' pe pra. Mîîkîrî arinîkon o'ma'kon wanî'pî ya' eporî'pî to'ya mîrîrî. Mîrîrî pî' to' esenumenka'pî. Moropai eranne' pe to' ena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Moropai o'non ye'ka pe eena'pî ekaremekî'pî era'ma tîponkonya, porcoyamî' yekare moropai warayo' o'ma'kon yenpî' yekare ekaremekî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Moropai Jesus yeka'nunka'pî tamî'nawîronkonya attîto'pe tîpatakon yapai. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kanau ya' Jesus asara'tî tanne, mîîkîrî warayo' o'ma'kon yenpî' wîtî'pî iipia. —Uurî nîrî, itîîpai wai apîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Kaane —ta'pî Jesusya. —Ayewî' ta enna'pokî ayonpayamî' pia. Paapa nîkupî'pî apî' ekareme'ta. Tî'noko'pî pe uyera'ma'pîiya ka'ta —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mîîkîrî wîtî'pî. Jesus nîkupî'pî tîpî' ekaremekî pinunpa'pîiya Decápolis poro. Moropai tamî'nawîronkon esenumenka'pî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Moropai inî'rî Jesus enna'po'pî iku'pî ratai pona kanau ya. Eerepansa' tanne, arinîkon pemonkonyamî' eperepî'pî iipia. Iku'pî ena po Jesus wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judeuyamî' epere'to' yewî' era'manen wîtî'pî Jesus pia, itese' Jairo. Jesus era'ma tîuya pe, mîîkîrî Jairo esenumî'pî non pona, Jesus rawîrî moropai yeka'nunka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Aase, uyewî' ta uyensi sa'manta pe man —ta'pî Jairoya Jesus pî'. —Aase uyewî' ta ayenya tîrîpa ipona eesepi'tîto'pe aasa'manta namai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mîrîrî ye'nen Jesus wîtî'pî ipîkîrî. Arinîkon pemonkonyamî' wîtî'pî to' pokonpe. Jesus woima'tî'pî to'ya. Yatunnuku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Arinîkon kore'ta wîri' wanî'pî pri'yawon pepîn, mîn kannen. Asakî'ne pu' pona tîîmo'tai kono' kaisarî aako'mansa' wanî'pî pri'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Arinîkon ne'ne'kon yepi'tîtonkon wanî'pî yepi'tî yu'se. Tîîse yepi'tî to'ya pra awanî'pî. Yepi'tî to'ya tanne inî' panpî' ne'ne' eena tu'ka'pî. Inkamoro ye'matîuya ke temanne tî'ka'pîiya wanî'pî tamî'nawîrî. Tîîse eesepi'tî pra awanî'pî. Inî' panpî' pri'ya pra eena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jesus yekare etasa' mîîkîrî wîri'ya wanî'pî. Mîrîrî ye'nen mîîkîrî wîri' esenumenka'pî Jesus pon ye'pi pî' yapîsau'ya ya esepi'tî e'painon kai'ma, wîri' esenumenka'pî. Jesus poi winî aaipî'pî moropai ipon ye'pi pî' yapî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mîrîrî pe rî mîn asa'tî'pî, yapîiya pe, moropai eesepi'tîsa' epu'tî'pî mîîkîrî wîri'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tîmeruntîri ke tiaron yepi'tîsa' tîuya epu'tî'pî Jesusya. Mîrîrî pe rî eera'tî'pî arinîkon kore'ta. —Anî'ya uyapî pî' nai upon pî'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—Arinîkon pemonkonyamî' kore'ta si'ma, anî'ya upon pî' uyapî pî' nai taaya. Pakko pe awanî mîrîrî —ta'pî Jesus pemonkonoyamî'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tîîse tîwoinokon pî' Jesus esenumenka'pî anî'ya ikupî'pî epu'tîpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Teesepi'tîsa' epu'tî tîuya ye'nen, mîîkîrî wîri' esi'nîpî'pî. Moropai tîwe'kîkî'ma ye'ka pe attî'pî Jesus pia. Eesenumî'pî non pona irawîrî. Moropai tekare ekaremekî'pîiya Jesus pî' tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Ma'non, innape ukupîya ye'nen eesepi'tîsa' mîrîrî —ta'pî Jesusya mîîkîrî wîri' pî'. —Tîwanmîra atîkî. Inî'rî ayeparanya ayeporî pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus eseurîma tanne, tiaronkon warayo'kon erepamî'pî epere'nîto' yewî' era'manen, Jairo yewî' tapai'nîkon. —Ayensi sa'mantan pî' man. Inî' uyenupanenkon kîsarîi —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","—To' eseurîmato' tîpîinamai pra —ta'pî Jesusya epere'nîto' era'manen pî'. —Kesi'nîpîi. Innape neken uku'kî. Kîsewankono'mai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pedro, moropai Tiago, moropai Tiago yakon João, inkamoro neken wîtî tarakkîrî tîrî'pî Jesusya. Tiaronkon wîtî tîrîiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Epere'nîto' yewî' era'manen yewî' ta teerepansa' pe, arinîkon pemonkonyamî' era'ma'pî Jesusya. Tiaronkon karau moropai tiaronkon entaimepîtî eta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wîttî ta teewonsa' pe, ta'pîiya to' pî': —Î' ton pe aronne awentaimepîtîkon mîrîrî? —ta'pîiya to' pî'. —Moropai akaraukon mîrîrî? Ma'non sa'mantasa' pra man. Iwe'nasa' mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Moropai to' siira'pî Jesus pî' mîrîrî taiya ye'nen. Tîîse poro pona to' yenpa'ka'pîiya. Moropai eewomî'pî isa'manta'pî pia itun moropai isan, moropai eseurîwî'nankon tînenupa'san pokonpe eewomî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mîîkîrî isa'manta'pî yenya yapisî'pîiya. —Tarita kumi —ta'pîiya ipî' tîmaimu ta. Ma'non, e'mî'sa'kakî, taato' mîrîrî umaimukon ta. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mîrîrî pe rî wîri' e'mî'sa'ka'pî moropai aasarî'pî. Asakî'ne pu' pona tîîmo'tai kaisarî ikono po awanî'pî. Kure'ne tamî'nawîronkon esenumenka'pî eesepi'tîsa' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesusya ta'pî tamî'nawîronkon pî': —Anî' pî' unkupî'pî kîsekareme'tî —ta'pîiya. Moropai wîri' yun, isan pî' ta'pîiya: —Ma'non yekkari ton antîîtî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Moropai Jesus wîtî'pî mîrîrî pata pai tînenupa'san pokonpe. Tîpata ya eerepamî'pî to' pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Erî'ka'nîto' weiyu yai tamî'nawîronkon yenupa pia'tî'pîiya epere'nîto' yewî' ta. Eta tîuya'nîkon pe arinîkon esenumenka'pî kure'ne ipî': —O'non pata mîrîrî ye'ka esenumenkanto' ku'nen pe tîwanîpa epu'nen eporîiya? O'non ye'ka pe epu'nen pe eena'pî? Anî' winîpai tîmeruntîri ton eporîiya anî'ya ikupî eserîkan pepîn konekapa? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—Mîîkîrî manni' wîttî konekanen, Maria more, innape nai? —ta'pî to'ya. —Tiago, moropai José, moropai Judas, moropai Simão rui mîîkîrî. Tarî iwîrisitonon man —ta'pî to'ya. Moropai Jesus yu'se pra to' ena'pî. Yapurî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesusya to' yeurîma'pî: —Tamî'nawîron pata ya Paapa maimu ekareme'nen yapurî to'ya. Tîîse ipata ya yapurî to'ya pepîn. Itonpayamî'ya yapurî pepîn. Itewî' tawonkonya yapurî pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Anî'ya ikoneka eserîkan pepîn tu'kan konekaiya yentai awanî'pî tîpata ya. Pri'yawonkon pepîn pona tenya tîrî'pîiya, arinîkon pepîn, moropai to' yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kure'ne Jesus esenumenka'pî inkamoro pî', innape tîkupî to'ya pra awanî ye'nen. Moropai aasarî'pî tiaronkon pata yapî' to' yenupa'pîiya mîrîrî rî pata poro to' yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Asakî'ne pu' pona tîîmo'tai'nîkon yanno'pî Jesusya tîîpia. To' yaipontî'pîiya pata kaisarî to' wîtîto'pe asakî'ne'ne. Moropai to' meruntîri ton tîrî'pîiya meruntî ke o'ma'kon maawariyamî' yenpa'kato'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","To' yaipontî'pîiya: —Attîkon pe î' rî kîsatî. Ame'sipukon neken maatîi. Aya're'kon ton kîsatî. Asakunikon kîsatî. Atînirurîkon ton kîsatî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","A'sa'sakon yeka'maya'nîkon moropai aponkon tiwin, apî'nîkon asakî'ne pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pemonkonyamî' pata ya eerepansa'kon ya, eewomîkon to' yewî' ta. Moropai moro pu'kuru mako'mantîi, mîrîrî pata pai attîkon pîkîrî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","—Tiaron pata po ayapisîkon to'ya pra awanî ya, moropai amaimukon anetapai pra to' wanî ya, mîrîrî pata pai matîtîi. Moropai attîkon pe a'pukon pî' non atapi'sa', mîrîrî mîsorokatîi eepa'kakon pe. Mîrîrî kupîya'nîkon ya, Paapa maimu yu'se pra to' wanî ye'nen Paapaya to' taruma'tî pe man ekaremekîya'nîkon mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mîrîrî tîpo to' ese'ma'tî'pî. Inkamoroya itekare ekaremekî'pî to' pî': —Ayeserukon winîpai enpenatatî teesewankono'mai era'tîtî —ta'pî to'ya tamî'nawîronkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Moropai tu'kankon o'ma'kon yenpa'ka'pî to'ya. Pri'yawonkon pepîn pu'pai karapaima'pî to'ya. To' yepi'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tamî'nawîrî Jesus nîkupî'pî yekare eta'pî tamî'nawîronkonya. Mîrîrî yai pata esa' Herodesya eta'pî nîrî. Tiaronkonya taapîtî'pî: —João Batista nurî'tî e'mî'sa'ka'pî man isa'manta'san kore'tapai. Mîrîrî ye'nen anî'ya ikupî eserîkan pepîn kupîiya mîrîrî —taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Moropai tiaronkonya ta'pî: —Elias nurî'tî mîîkîrî. Moropai tiaronkonya ta'pî: —Paapa maimu ekareme'nenan profetayamî' warainon mîîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tîîse itekare eta tîuya pe Herodesya ta'pî: —João mîîkîrî, uni'mîrîkîtî'pî ipu'pai. Tîîse awe'mî'sa'kasa' mîrîrî tîîsa'manta tîpo, isa'manta'san kore'ta pai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maasa pra mîîkîrî rî Herodesya João yarakkamo me'po'pî tîuya ye'nen atarakkannîto' yewî' ta. Mîrîrî kupî'pî Herodesya maasa pra takon Filipe no'pî Herodias yarakkîrî awanî pî' João eseurîmasa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Taapîtî'pî Joãoya ipî': —Ayakon no'pî yarakkîrî awanî Paapa nekaremekî'pî unkupîkon ton pe yairî pra. Imakui'pî ku'sa'ya mîrîrî —taapîtî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mîrîrî wenai Herodes no'pî Herodias ekore'ma'pî ipî'. Moropai João Batista anwîpai awanî'pî. —João Batista wîî me'pokî —ta'pîiya Herodes pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","—Kaane —ta'pîiya. Mîrîrî ta'pîiya maasa pra morî pe Paapa maimu yawîron pe João wanî epu'tî tîuya ye'nen. Moropai inama'pîiya. João maimu eta tîuya pe aataka'ma'pî. Mîîwîni tîîse tîwakîri pe eta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mîrîrî tanne, tîîko'mamî tîpo, Herodias esenumenka'pî teseru koneka pî'. Moropai Herodesya entamo'kanto' koneka'pî teesenpo'pî weiyu yai. Tîpoitîrîtonon eta'pîiya entamo'kai. Surarayamî' yepotorîtonon eta'pîiya. Moropai ipîkkukon tîniru esanon Galiléia ponkon eta'pîiya nîrî entamo'kai. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias more wîri' ewomî'pî to' kore'ta imanunse. Moropai imananu'pî. Herodes wakîri pe awanî'pî. Herodes neta'san wakîri pe nîrî awanî'pî. Mîrîrî ye'nen Herodesya ta'pî wîri' pî': —Î' rî yu'se awanî ya, esa'kî upî' moropai anesatî'pî tîrîuya —ta'pî Herodesya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","—Paapaya uyera'ma pî' man. Ayenku'tîuya pepîn sîrîrî. Î' rî esatîya ya itîrîuya. Itu'se awanî ya, upata tîrîuya arakkita pîkîrî —ta'pîiya wîri' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Moropai wîri' epa'ka'pî. Tîsan pia attî'pî, Herodias pia. —Î' esatîuya yu'se awanî mîrîrî? —ta'pîiya tîsan pî'. —João Batista pu'paraikkî'to'peiya ka'kî ipî' —ta'pî Herodiasya tînre pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Teesemi'tapai mîîkîrî wîtî'pî Herodes pia esa'se: —João Batista pu'paraikkîtîya'nîkon yu'se wai. Sunpa pona ipu'pai'pî enepîya'nîkon yu'se wai uupia era'mato'peuya —ta'pî wîri'ya Herodes pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mîrîrî pî' Herodes esewankono'ma'pî kure'ne. Itîrîuya taasa' tîuya pî' moropai mîrîrî etasa' tîneta'sanya pî' eesewankono'ma'pî. Mîrîrî ye'nen wîri' pî' ani'nînmapai pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Moropai ka'ne' pe Herodesya surara yaipontî'pî: —Atîkî. João pu'pai era'mata —ta'pîiya. Surara wîtî'pî. Atarakkannîto' ta João pu'paraikkîtî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","João pu'pai'pî yarî'pî suraraya sunpa pona moropai itîrî'pîiya wîri' pia. Mîîkîrîya yarî'pî tîsan pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mîrîrî eta tîuya'nîkon pe João nenupa'san wîtî'pî itesa'rî'pî era'mai. Moropai yu'na'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesus naipontî'san enna'po'pî iipia. Tamî'nawîron tînkupî'pîkon moropai pemonkonyamî' yenupa'pî tîuya'nîkon ekaremekî'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Arinîkon pemonkonyamî' erepanpîtî'pî to' pia Jesus era'mapî'se. Jesus moropai inenupa'san entamo'ka eserîke pra awanî'pî. Mîrîrî ye'nen Jesusya ta'pî tînenupa'san pî': —Aase'kon see upokonpe keren pona erî'ka'se'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mîrîrî ye'nen tamî'nawîronkon piapai to' wîtî'pî kanau ya' keren pona, Jesus moropai inenupa'san. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tîîse arinîkonya to' wîtî era'ma'pî. Jesus nenupa'san pe to' epu'tî'pî to'ya. Itîîpai nîrî to' wanî'pî. Tîpatakon yapai to' esemi'tîpa'pî tuutîkonpa. Inkamoro wîtî'pî a'mun poro teeka'tunse keren pona. Jesus moropai inenupa'san rawîrî to' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kanau yapai teeseu'ka pe, mararonkon pepîn pemonkonyamî' era'ma'pî Jesusya. Carneiroyamî' itesa' pînon ataka'ma'san warantî to' era'ma'pîiya. Mîrîrî ye'nen to' sa'nama'pîiya. Tu'kan pî' to' yenupa pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pata ko'mamî pe, Jesus nenupa'san, ipemonkonoyamî' wîtî'pî iipia. —Keren po e'nî tanne, pata ko'mannî pî' man. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tamî'nawîronkon yaipontîkî cidade pona, moropai poro po tîîko'mansenon pia ta're'kon ton yennato'pe to'ya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tîîse to' maimu yuuku'pî Jesusya: —Amîrî'nîkonya neken to' ya're' ton tîrî sîrîrî. —O'non ye'ka pe? —ta'pî Jesus nenupa'sanya. —Trigo puusa' yenna annaya yu'se awanî mîrîrî mararî pra tîniru ke, tu'ke kapoi kaisarî esenyaka'manto' yepe' yentai awanî. Mîrîrî warantî to' yekkari'tî annaya yu'se awanî. Tîîse tîniru ton pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Î' warapo pão moro nai aapia'nîkon? Maasa era'matantî —ta'pî Jesusya. Era'mai to' wîtî'pî. Ekaremekî'pî to'ya Jesus pî': —Pão moro man mia'taikin neken moropai moro'yamî' asakî'ne —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Mîrîrî tîpo Jesusya pemonkonyamî' pantakapîtî'pî tîponarî'ne, tiaronkon 50 kaisarî'ne, tiaronkon 100 kaisarî'ne. To' yaipontî'pîiya parî' pona to' ereutato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mia'taikinan pão moropai asakî'nankon moro'yamî' yapisî'pîiya tenya'. Moropai ka' ekaya tenu tanunse ipîrema'pîiya. Moropai trigo puusa' pirikkapîtî'pîiya. Mîrîrî tîrî'pîiya tîpemonkonoyamî' pia. Inkamoroya itîrî'pî tamî'nawîronkon pemonkonyamî' pia. Moro'yamî' waikapîtî'pîiya nîrî pemonkonyamî' kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tamî'nawîronkon entamo'ka'pî mîrîrî pî' teesepi'tîkon pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Trigo puusa' yonparî'pî moropai moro'yamî' yonparî'pî e'nîmîsa' yara'tî'pî to'ya waikîra'pî ya'. Asakî'ne pu' pona tîîmo'tai waikîra'pî kaisarî itonparî'pî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jesus nîtîrî'pî pî' entamo'ka'san warayo'kon wanî'pî 5.000 kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Teesemi'tapai Jesusya tînenupa'san yaipontî'pî kanau ya to' asara'tîto'pe, tîrawîrî to' wîtîto'pe iratai pona, Betsaida pona. —Attîkon tanne pemonkonyamî' yarimauya to' emi'to'pe —ta'pîiya to' pî'. Jesus nenupa'san ese'ma'tî'pî. Mîrîrî tîpo Jesusya ta'pî e'nîmî'san pî': —Ayewî'kon ta atîtî see. Morî pe enna'potî. Uurî nîrî, uutî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Teesekaremekî tîpo, Jesus wîtî'pî wî' more'pî pona epîremai tiwinsarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pata ewaronpamî tanne, Jesus nenupa'san wanî'pî iku'pî yarakkita kanau ya' moropai mîîkîrî wanî'pî tiwinsarî a'mun po. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mîrîrî yai meruntî a'situn ponaya kanau yawonkon wîtî'pî. Tîmoronkon tepu'se to' e'kura' era'ma'pî Jesusya. Kariwana etun tanne attî'pî to' pia tuna poro tî'si po. To' yuwa'ka yonpa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tîîse aaipî era'ma'pî inenupa'sanya. Tî'si po tuna poro aaipî era'ma tîuya'nîkon pe, o'ma' mîîkîrî kai'ma to' esenumenka'pî ipî'. Mîrîrî pî' to' esi'nîpî'pî. To' entaimepîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","To' esi'nîpî era'ma tîuya pe, ka'ne' pe Jesus eseurîma'pî to' yarakkîrî: —Meruntî ke e'tî, teesi'nî'se pra, maasa pra uurî Jesus —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Moropai Jesus asara'tî'pî to' kanaurî ya'. Mîrîrî pe rî a'situn atî'napamî'pî. Mîrîrî pî' ta'pî inenupa'sanya: —Î' ye'ka see mîîkîrî pemonkon, mîrîrî ye'ka a'situn tî'napannî'nen? ");
INSERT INTO mbcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesus meruntîri era'ma'pî to'ya trigo puusa' pirikkaiya yai. Mîîwîni tîîse iipia Paapa meruntîri wanî epu'tî to'ya pra awanî'pî, pakko pe tîwanîkon ye'nen. Maasa pra ipî' to' esenumenka pra awanî'pî, anî' pe awanî epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iku'pî ratai pona teerepansa'kon pe to' eseu'ka'pî Genesaré pata pona. Mîrîrî iku'pî ka tîkanaukon yewa'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Moropai kanau yapai to' eseu'ka pe Genesaré ponkon pemonkonyamî'ya Jesus epu'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Teeka'tunse to' wîtî'pî iipia, Jesus erepansa' yekare etasa' tîuya'nîkon ye'nen. O'non pata Mîîkîrî wanî etasa' tîuya'nîkon ya, mîîkîrî pia pri'yawonkon pepîn yarî'pî to'ya to' yepi'tîto'peiya kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Moropai o'non pata Jesus erepansa' pia, si'mîrikkî cidade pona, kure'nan cidade pona, cidade po pra tîîko'mansenon pia, moro pu'kuru pri'yawonkon pepîn enepî'pî to'ya iipia, erepanto' pata'se' ya'. Moropai Jesus yeka'nunka'pî to'ya ipon ye'pi yapîkonpa kai'ma. Moropai yapîtîponkon esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseuyamî' epere'sa' wanî'pî Jesus pia Moisés nurî'tîya yenupato' pî' yenupatonkon kore'ta. Inkamoro Moisés nurî'tîya yenupato' pî' yenupatonkon ii'sa' wanî'pî Jerusalém poi. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Fariseuyamî'ya tenyakon rona tu'ke ite'ka tiwin ite'ka tîîse. Mîrîrî tîpo ta're'kon enapî to'ya. Tamî'nawîronkon Judeuyamî' yeseru pe awanî. Tîtamokonya tîpanama'pîkon yawîrî to' wanî mîrîrî. E'repanto' pata'se' yapai teemi'se tîwe'ronakon pra awanî ya, ta're'kon enapî fariseuyamî'ya pepîn. Mîrîrî warantî nîrî teserukon yawîrî tu'ke ite'ka copo ronapîtî to'ya, îinî ronapîtî to'ya, pisa ronapîtî to'ya. Moropai Jesus nenupa'sanya ta're'kon enapî era'ma'pî to'ya. Tîîse fariseuyamî'ya tenyakon rona manni' warantî tenyakon rona to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mîrîrî ye'nen fariseuyamî' moropai Moisés nurî'tîya yenupato' pî' yenupatonkonya ta'pî Jesus pî': —Î' ton pe see utamokonya uyenupa'pîkon yairî pra apemonkonoyamî' wanî mîrîrî? Î' ton pe tenyakon rona tîuya'nîkon rawîrî ta're'kon enapî to'ya? ");
INSERT INTO mbcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusya ta'pî: —Yairî pu'kuru Paapa maimu ekareme'nen Isaías nurî'tî eseurîma'pî apî'nîkon pena. Paapa yapurînen pe pra si'ma Paapa yapurînenan patakaya'nîkon eserîke pra naatîi seru' pe. Sîrîrî Isaías nurî'tî maimu rî'pî inmenuka'pî: “Morî pe eseurîmakoi'kon insanan pemonkonyamî' upî'”, taa Paapaya. “Tîîse aminke to' yewan wanî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Î' pe pra rî uyapurî to'ya mîrîrî. Penaro'konya tîpanama'pîkon yawîrî tonpakon yenupa to'ya, uurîya tîpanama'pîkon pe tîku'se” taa Paapaya. Mîrîrî Isaías maimu rî'pî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Paapaya upanama'pîkon unkupîkon ton pe mîrîrî rumakasa'ya'nîkon. Tîîse atamokonya apanama'pîkon yawîrî awanîkon, irumakaya'nîkon pata pe pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Paapaya upanama'pîkon rumakasa'ya'nîkon atamokonya apanama'pîkon yawîrî awanîkonpa kai'ma. Epu'nen pe awanîkon kai'ma eesenku'tîkon mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","—Moisés nurî'tîya ta'pî: “Ayunkon, moropai asankon yapurîtî. Imakui'pî pe anî' eseurîma ya tîyun winîkîi, moropai tîsan winîkîi, mîîkîrî mîwîtîi,” ta'pîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","—Mîrîrî ye'ka pe pra amîrî'nîkon eseurîma mîrîrî. Amîrî'nîkonya taa: “Uyunkon, moropai usankon pia untîrîkon ton unmo'ka'pîkon tîrî e'painon Paapa pia. Corbã mîrîrî. Paapa pia neken untîrî ton sîrîrî taato' mîrîrî corbã”. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mîrîrî warantî taa ye'ka pe, amîrî'nîkonya taa: “Uyunkon moropai usankon pîika'tî pra wanî ya, î' wani' pra awanî Paapa pî'”. Mîrîrî warantî tamî'nawîronkon yenupaya'nîkon seru' pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","—Atamokonya apanama'pîkon yawîrî awanîkon ye'nen Paapa maimu pîinamaya'nîkon pra awanî. Tamî'nawîronkon panamaya'nîkon ayeserukon yawîrî neken to' ko'manto'pe kai'ma. Tu'ke ayeserukon poi'pî moro awanî mîrîrî ye'ka —ta'pî Jesusya fariseuyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Moropai inî'rî Jesusya tamî'nawîronkon yanno'pî tîîpia. —Umaimu etatî moropai epu'tîya'nîkon yuwatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","—Paapa pia imakui'pî pe e'nî pepîn uya're'kon unenno'makon wenai. Tîîse imakui'pî pe e'nî uyewankon ya tîîko'mansen imakui'pî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Anetapainon wanî ya, etakî, moropai epu'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Poro po tîwe'sanon piapai Jesus ewomî'pî wîttî ta. Mîîkîrî ekaranmapo'pî inenupa'sanya: —Î' pî' eeseurîma manni'? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—Amîrî'nîkonya nîrî epu'tî pra awanîkon mîrîrî? —ta'pî Jesusya. —Uya're'kon unenno'makonya ukupîkon pepîn imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maasa pra uyewankon ya eewomî pepîn. Uro'takon ya' neken eewomî moropai mîrîrî tîpo iwekannîpî. Tamî'nawîron entamo'kanto' wanî morî pe. Tamî'nawîron entamo'kanto' pî' entamo'kan e'painon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Imakui'pî uyewankon ya' tîîko'mansen wanî imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Uyewankon ya' tîîko'mansen imakui'pî wenai imakui'pî pî' esenumenkan, tamî'nawîronkon wîri'sanyamî', warayo'kon poro wîtîn, ama'ye' pe e'nî, tiaron wîî, ");
INSERT INTO mbcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","moropai tiaron no'pî, tiaron niyo yarakkîrî e'nî, moropai tiaron yemanne yu'se e'nî, imakui'pî kupî, tiaronkon yenku'tî, nura pe e'nî, kinmuwan, imakui'pî pe tiaron pî' eseurîman, moropai mîî pe e'nî, eranne' pe pra e'nî imakui'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tamî'nawîrî imakui'pî pe e'nî maasa pra imakui'pî ko'mamî ye'nen uyewankon ya'. Mîrîrî wenai imakui'pî kupî pî' ko'mannî —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mîrîrî tîpo Jesus ese'ma'tî'pî. Tiro pata poro moropai Sidom pata poro attî'pî. Tîîko'manto' yewî' ton eporî'pîiya. Moro tîwanî epu'tî anî'ya yu'se pra awanî'pî. Mîrîrî ye'ka pe tîîse epu'tî'pî tiaronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Moropai wîri' wanî'pî moro. Mîîkîrî wanî'pî Judeupa' pe pra, Siro-fenicia pon mîîkîrî. Imaimu wanî'pî grego pe. Inre wanî'pî wîri'. O'ma' ewonsa' wanî'pî mîîkîrî more ya'. Mîrîrî ye'nen Jesus erepansa' eta tîuya pe, attî'pî iipia. Moropai Jesus puu pia eesenumî'pî, yeka'nunka'pîiya. Ta'pîiya Jesus pî': —O'ma' yenpa'kakî unre yapai. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Moropai Jesusya ta'pî: —Kaane. E'mai' pe upemonkonoyamî' pîika'tîuya, Judeuyamî'. Amîrî Judeu pepîn. Arinmaraka pia more ya're' tîrî ya, yairî pra awanî. Mîrîrî warantî tamî'nawîron Judeuyamî' pîika'tîuya pra tîîse, amîrî pîika'tîuya ya, Judeu pe pra awanî tanne, yairî pra awanî —ta'pî Jesusya. ˻Judeuyamî'ya Judeu pepîn esatî'pî arinmaraka pe tewanmakon pe to' kupî tîuya'nîkon ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tîîse wîri'ya ta'pî: —Innape man, piipi'. ˻Arinmaraka taa Judeuyamî'ya upî', seru' pepîn.˼ Mîrîrî ye'ka pe tîîse moreyamî' ya're' ya'punu'pî e'soroka enapî arinmarakayamî'ya itaponse' yo'koi si'ma. Mîrîrî warantî arinmarakayamî' e'pîika'tî manni' warantî, upîika'tîkî sa'ne —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesusya ta'pî ipî': —Innape ukupîya epu'tî pî' wai, mîrîrî taa pî' nai epu'nen pe. Ayewî' ta enna'pokî. O'ma' wîtîn pî' man anre piapai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Moropai mîîkîrî emikku'pî tewî' ta. Tînre eporî'pîiya tette' ta. O'ma' wîtî'pî wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Moropai Jesus enna'po'pî Tiro pata pai. Tuutî pe Sidom pata pona attî'pî, moropai Decápolis pata poro. Eerepamî'pî Galiléia ku'pî ka. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Miarî tiaronkon pemonkonyamî'ya imaimu pîn moropai pana'tî'pan warayo' yarî'pî Jesus pia. Jesus yeka'nunka'pî to'ya: —Ayenya tîîkî ipona eesepi'tîto'pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Arinîkon pemonkonyamî' piapai Jesusya mîîkîrî mo'ka'pî tiwinsarî. Tenya yeperu tîrî'pî Jesusya mîîkîrî pana ya'. Tetaku ma'pîiya tenya pona. Moropai mîrîrî ke inu yapî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Moropai tî'noko'pî pe era'ma tîuya ye'nen, Jesus yettapusin enuku'pî ka' era'mai'ma. —Epata —ta'pîiya tîmaimu ta. Esettapuruka'kî taato' mîrîrî umaimukon ta. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Moropai ipana esettapuruka'pî. Inu ekoneka'pî. Morî pe eeseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesusya to' yaipontî'pî. —Anî' pî' unkupî'pî kîsekareme'tî —ta'pîiya to' pî'. Tîîse yuuku to'ya pra awanî'pî. Inî' panpî' to' panamaiya tanne, inî' panpî' ekaremekî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mararî pra tamî'nawîronkon esenumenka'pî Jesus pî': —Tamî'nawîron mîrîrî morî panpî' ku'sai'ya. Pana'tî'pankon pana yettapurîkasai'ya moropai imaimu pînon pemonkonyamî' konekasai'ya nîrî to' eseurîmato'pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mararî tîîko'mamîkon tîpo, arinîkon eperepî'pî inî'rî Jesus pia. To' narî'pî, to' ya're' e'tî'ka'pî. Mîrîrî ye'nen Jesusya tînenupa'san yanno'pî tîîpia to' yeurîmapa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Seurîwî'ne wei kaisarî insanan ko'mansa' sîrîrî uupia —ta'pîiya. —Tarîpai to' ya're' e'tî'kan pî' man. Mîrîrî ye'nen to' sa'nama pî' wai. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iwan pe to' tîîse to' yarimauya ya tewî'kon ta, to' enkîsi'panpîtî tuutîkon pe. Aminke pai tiaronkon ii'sa' mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Keren po si'ma to' ya're' ton tîrî eserîke pra awanî —ta'pî inenupa'sanya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—Î' warapo trigo puusa' moro nai aapia'nîkon? —ta'pî Jesusya. —Asakî'ne mia' pona tîîmo'tai kaisarî man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tamî'nawîronkon pî' ta'pî Jesusya: —Maasa non pona ereutatî. Asakî'ne mia' pona tîîmo'tai'non trigo puusa' yapisî'pîiya. Moropai eeseurîma'pî Paapa yarakkîrî: —Morî pu'kuru amîrî, Paapa. Anna ya're' ton tîrî pî' nai —ta'pîiya Paapa pî'. Mîrîrî tîpo trigo puusa' pirikkapîtî'pîiya. Tînenupa'san pia itîrî'pîiya tamî'nawîronkon kaisarî itîîto'pe to'ya. Moropai to' kaisarî itîrî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Moro'yamî' mîrikkî wanî'pî mararî to' pia. Inkamoro nîrî yapisî'pîiya. —Morî pu'kuru amîrî, Paapa. Anna yo' ton tîrî pî' nai —ta'pîiya Paapa pî'. —Maa. Seeni' tîîtî tamî'nawîronkon kaisarî —ta'pîiya tînenupa'san pî'. Moropai itîrî'pî to'ya tamî'nawîronkon kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Moropai inkamoro entamo'ka'pî teesepi'tîkon pîkîrî. Inkamoroya ta're'kon yonpa rî'pî yannuku'pî. Asakî'ne mia' pona tîîmo'tai waikîra'pî kaisarî wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Entamo'ka'san wanî'pî 4.000 kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mîrîrî tîpo tamî'nawîronkon yarima'pî Jesusya to' wîtîto'pe. Moropai to' enuku'pî kanau ya' tînenupa'san yarakkîrî. Dalmanuta itese' pata pona to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Moropai fariseuyamî' wîtî'pî Jesus pia. To' esiyu'pîtî pia'tî'pî yarakkîrî. —Anna nera'ma ton anku'kî innape Paapa winîpai tui'sen pe ameruntîri wanî era'mato'pe annaya —ta'pî to'ya. Mîrîrî ta'pî to'ya maasa pra innape Paapa winîpai imeruntîri iipî kupî tîuya'nîkon pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ne'ne' pe itewan ku'sa' to'ya wanî'pî. —Sîrîrî pankon wanî tînera'makon ton yu'se. Tîîse ayenku'tîuya'nîkon pepîn. Anera'makon ton tîrî Paapaya pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Inkamoro Fariseuyamî' piapai attî'pî. Kanau ya' to' enuku'pî. Moropai tînenupa'san pokonpe eese'ma'tî'pî iratai pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tîîwanmîra'nîkon ta're'kon ton yarî to'ya pra awanî'pî. Trigo puusa' tiwinan neken wanî'pî moro kanau ya'. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Moropai Jesusya to' panama'pî: —Tîwarî panpî' e'tî. Tîwî fariseuyamî' piawon moropai Herodes piawon trigo sa'moto' nîsi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Teepere'se to' eseurîma'pî mîrîrî pî': —Î' pî' taiya manni'? Uya're'kon ton ene'sa' pra awanî ye'nen mîrîrî taa pî' man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","˻Trigo puusa' pî' pra eeseurîma manni'. Fariseuyamî' moropai Herodes yeseru pî' eeseurîma.˼ Tîîse trigo puusa' ton pra tîwanîkon pî' to' eseurîma epu'tî'pî Jesusya. —Î' ton pe aya're'kon ton pra awanîkon pî' eeseurîmakon mîrîrî? Uyeseru pî' eesenumenkakon pepîn. Anepu'pai pra awanîkon mîrîrî. Ayewankon ya unekaremekî'pî enasa' pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tenu kenankon amîrî'nîkon. Tîîse enkaru'nan warantî awanîkon. Tîpana kenankon amîrî'nîkon. Tîîse pana'tî'pan warantî awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mia'taikin trigo puusa' ke manni' 5.000 pemonkonyamî' ya're'tîuya yai, to' ya're' yonpa rî'pî yanumî'pîya'nîkon. Î' warapo waikîra'pî kaisarî awanî'pî? —ta'pîiya. —Asakî'ne pu' pona tîîmo'tai waikîra'pî kaisarî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Moropai asakî'ne mia' pona tîîmo'tai trigo puusa' ke 4.000 kaisaronkon pemonkonyamî' ya're'tîuya yai, to' ya're' yonparî'pî yanumî'pîya'nîkon. Î' warapo waikîra'pî kaisarî awanî'pî? —ta'pîiya. —Asakî'ne mia' pona tîîmo'tai waikîra'pî kaisarî awanî'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Sîrîrî tîpose uyeseru epu'tîya'nîkon pra awanîkon mîrîrî? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Moropai to' erepamî'pî Betsaida itese' pata pona. Miarî enkaru'nan warayo' yarî'pî tiaronkonya Jesus pia. Jesus yeka'nunka'pî to'ya enkaru'nan yapîto'peiya kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Enkaru'nan yarî'pîiya itenya pî' tapi'se pemonkonyamî' pata yapai. Tetaku ma'pîiya enkaru'nan yenu ya'. Moropai tenya tîrî'pîiya itenu pona. Tenya mo'ka'pîiya. —Pata era'ma pî' nan? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Teesenumenka tîpo ta'pîiya: —Inna. Pemonkonyamî' asarî era'ma pî' wai, tîîse morî pe pra. Yei warantî to' era'ma pî' wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inî'rî tenya tîrî'pî Jesusya itenu pona. Tenya mo'ka'pîiya. Tîwoi'nîkon pî' teesenumenka pe, enkaru'nan yenu esepi'tî'pî. Tamî'nawîron era'ma'pîiya morî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Moropai mîîkîrî yarima'pî Jesusya tewî' ta: —To'sarî atîkî. Pemonkonyamî' kore'ta katîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Moropai Jesus wîtî'pî tiaron pata itese' Cesaréia-Filipe poro tînenupa'san pokonpe. Tuutîkon ye'ka pe tînenupa'san ekaranmapo'pîiya: —Anî' pe rî ukupî pî' tarîronkonya? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Tiaronkonya ta'pî: “João Batista yekatono'pî mîîkîrî”. Tîîse tiaronkonya ta'pî: “Pena itekare ekareme'pîtîtîpon Elias yekatono'pî mîîkîrî”. Moropai tiaronkonya ta'pî: “Penaro' Paapa maimu ekareme'nen yekatono'pî mîîkîrî”. Mîrîrî warantî apî' to' eseurîma —ta'pî Jesus nenupa'sanya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Amîrî'nîkon kanan. Anî' pe uyepu'tî pî' naatî? —ta'pî Jesusya to' pî'. Pedroya ta'pî: —Amîrî Paapa nîmenka'pî, Cristo —ta'pîiya. ˻Paapa nîmenka'pî taato' mîrîrî Cristo.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Inna. Tîîse maasa sîrîrî Paapa nîmenka'pî pe wanî kîsekareme'tî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Moropai Jesusya to' yenupa'pî: —Uurî ka' poi iipî'pî. Kure'ne e'taruma'tî kupî sîrîrî. Judeuyamî' panamanenan, moropai teepîremasanon esanon, Moisés nurî'tîya yenupato' pî' yenupatonkon, inkamoro ena kupî sîrîrî uyu'se pra. Uwî to'ya kupî sîrîrî. Uusa'mantasa' ko'mamî kupî sîrîrî asakî'ne wei kaisarî moropai iteseurîno wei yai e'mî'sa'ka —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mîrîrî ta'pîiya aronne, tiaronkonya epu'tî yu'se tîwanî ye'nen. Moropai Pedroya yarî'pî tiaronkon kore'ta pai. —Mîrîrî ye'ka pe teeseurîmai pra e'kî. Mîrîrî warantî aasa'manta e'pai pra man —ta'pî Pedroya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tîîse Jesus era'tî'pî tiaronkon tînenupa'san winîkîi moropai ta'pîiya Pedro pî': —Sinpata atîkî uupiapai. Makui maimu warantî amaimu wanî mîrîrî. Paapa esenumenka warantî eesenumenka pra awanî mîrîrî. Eesenumenka non po tîîko'mansenon esenumenka warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mîrîrî tîpo tînenupa'san pokonpe tamî'nawîronkon yanno'pîiya tîîpia. Ta'pîiya to' pî': —Uwanîyakon pe e'pai anî' wanî ya, iteseru, itu'se tîwe'to' rumaka e'pai awanî. Uwanîyakon pe tîwanî wenai, tîwe'taruma'tîto' namaiya e'pai pra awanî. Uwanîyakon pe tîwanî wenai, tîsa'mantato' namaiya e'pai pra awanî. Moropai uwenairî aaipî e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maasa pra anî'ya tîîko'manto' pînînma ya kure'ne, tîwe'taruma'tî namaiya. Mîrîrî ye'nen Paapa pia ipatîkarî tîîko'manto' ton eporîiya pepîn. Tîîse aminke aako'mamî Paapa pî'. Tîîse uwanîyakon pe tîwanî wenai, tîîko'manto' pînînmaiya pra tîwanî ya, tîwe'taruma'tîto' yapîtanîpîiya ya, ipatîkarî enen tîîko'manto' ton eporîiya Paapa pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamî'nawîron sîrîrî non pon manne esa' pe anî' wanî ya, tîîse ipatîkarî enen tîîko'manto' ton eporîiya pra awanî ya, eporîiya kupî pepîn rî mîrîrî. Aasa'manta yai tekaton yepe' ton eporîiya pepîn, awe'pîika'tî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Î' ton pra awanî sîrîrî pata po, itekaton yepe' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Imakui'san sîrîrî pankon kore'ta uurî pî' moropai umaimu pî' anî' eppepî ya, uurî ka' poi iipî'pî eppepî kupî sîrîrî ipî'. Uurî ka' poi iipî'pî. Inî'rî uuipî pe wai, Paapa pia tîîko'mansenon inserîyamî' pokonpe. Uuipî yai Uyun kaisarî wanî kupî sîrîrî meruntî ke. Mîrîrî yai eppepî kupî sîrîrî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Moropai Jesusya ta'pî to' pî': —Ayenku'tîuya'nîkon pepîn. Tamî'nawîronkon esa' pe Paapa ii'to' eseporî pe man. Mîrîrî yai tamî'nawîronkon yentai meruntî ke pu'kuru awanî epu'tî tamî'nawîronkonya. Mîrîrî era'ma tiaronkon tarîronkonya tîîsa'mantakon rawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tiwin mia' pona tîîmo'tai wei tîpo, Jesus wîtî'pî kawînan wî' pona. Pedro, moropai Tiago, moropai João wîtî'pî yarakkîrî. Inkamoro pokonpe neken awanî'pî. Miarî Jesus etinyaka'masa' wanî'pî to' yenu kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ipon etinyaka'masa' wanî'pî inke' pe pu'kuru. Aimutun pe awanî'pî. Uponkon ronapîtî e'painon mararî pra tîîse mîrîrî kaisarî aimutun pe eena pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Moropai penaronkon era'ma'pî Jesus pokonpe tîwe'sanonya, Elias moropai Moisés. Jesus yarakkîrî to' eseurîma era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mararî pra to' esi'nî'sa' wanî'pî. Î' taa tîuya epu'tîiya pra Pedro wanî'pî. Mîrîrî warantî tîîse eeseurîma'pî. Ta'pîiya tepotorî Jesus pî': —Morî pe tarî e'nî sîrîrî. Seurîwî'ne tappîi koneka annaya sîrîrî, amîrî ton, moropai Moisés ton, moropai Elias ton —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mîrîrî taiya tanne, katupuruya to' napontî'pî. Moropai Paapa eseurîma'pî katupuru kore'ta si'ma. Ta'pî Paapaya: —Unmu mîserî. Unmu yu'san Uurî. Mîserî maimu etatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mîrîrî tîpo tenukon yarî'pî ipokonpankonya tîwoi'nîkon, tîîse Moisés, moropai Elias era'ma to'ya pra awanî'pî. Jesus neken era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wî' poi tawautîkon pe, Jesusya ta'pî to' pî': —Sîrîrî anera'ma'pîkon kîsekareme'tî. Pemonkon pe ka' poi iipî'pî uurî sa'manta tîpo e'mî'sa'ka kupî sîrîrî, mîrîrî tîpo ekaremekîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mîrîrî ye'nen ekaremekî to'ya pra awanî'pî. Tîîse to' eseurîma'pî teepere'se: —Uusa'manta tîpo e'mî'sa'ka taiya manni', î' pî' eeseurîma mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mîrîrî ye'nen Jesus ekaranmapo'pî to'ya. —A'kî. Moisés nurî'tîya yenupato' pî' yenupatonkonya taa: “E'mai' pe Elias, penaro' Paapa maimu ekareme'nen iipî pe man. Mîrîrî tîpo Cristo, Paapa nîmenka'pî iipî ite'ma'pî pî'”, taa to'ya. Î' wani' awanî ye'nen mîrîrî taa to'ya? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Innape Elias warainon iipî yairî panpî' Paapa yapurîto' ku'se. Î' wani' awanî ye'nen sîrîrî menuka'pî penaronkon Paapa maimu ekareme'nenanya? Uurî ka' poi iipî'pî pemonkon pe e'taruma'tî kupî sîrîrî mararî pra. Arinîkonya uyapurî pe pra man. Mîrîrî ye'nen tepotorîkon pe ukupî to'ya pepîn. Mîrîrî nîrî menuka'pî penaronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aasîrî Elias warainon iipî'pî. Penaronkon Paapa maimu ekareme'nenanya imenuka'pî yawîrî imakui'pî kupî'pî tiaronkonya iwinîkîi itu'se tîwe'to'kon yawîrî —ta'pî Jesusya. João Batista pî' eeseurîma mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Moropai tiaronkon Jesus nenupa'san pia teerepamîkon pe, arinîkon epere'sa' era'ma'pî to'ya to' pia. Inenupa'san pokonpe Moisés yeseru rî'pî pî' yenupatonkon esiyu'pîtî era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mîrîrî pe rî Jesus era'ma tîuya'nîkon pe, tamî'nawîronkon esenumenka'pî ipî' mararî pra moropai to' eka'tumî'pî iipia esekareme'se. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—Î' pî' eeseurîmakon manni'? —ta'pî Jesusya tamî'nawîronkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","—Uyenupanen —ta'pî tiaronya ipî'. Unmu enepî pî' wai aapia. imaimu pra iku'sa' o'ma'ya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","O'non pata tîîse eporî tîuya ya, non pona yenumîiya, o'ma'ya. Moropai inta arakkunta. Moropai tee ye'kaiya. Moropai aapîta non po si'ma. Anenupa'san pî' esatî pî' wai o'ma' tîrîkato'pe to'ya teuren, tîîse î' kupî to'ya yentai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Sîrîrî tîpose innape ukupî to'ya pra tamî'nawîronkon wanî —ta'pî Jesusya. —Tîko'man pe uuko'mansa' sîrîrî akore'ta'nîkon tînîn pî' ayenupakon pî'. Mîîwîni tîîse innape ukupîya'nîkon pra awanîkon. Mîîkîrî ene'tî uupia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mîîkîrî more enepî'pî to'ya iipia. Jesus era'ma tîuya pe, o'ma'ya more yenumî'pî non pona. Awe'perenperenma'pî non pona. Inta arakkunta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—Î' pensa eporî pia'tî'pîiya? —ta'pî Jesusya iyun pî'. —More pe tîîse eporî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iko'noro o'ma'ya imapîtî apo' ya', moropai tuna ka' iwîpa kai'ma. Ameruntîri yentai pra awanî ya, a'noko'pî pe anna era'makî. Anna pîika'tîkî —ta'pî iyunya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Umeruntîri moro man tîîse innape Paapa kupî pî' nan? Innape Paapa kupîya ya, anmu yepi'tîuya. Tamî'nawîron e'kupî e'painon innape Paapa ku'nenan ton pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—Innape Paapa kupî pî' wai. Inî' panpî' innape iku'tou'ya ton ke urepakî —ta'pî more yunya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tîîpia tamî'nawîronkon emurukuntî era'ma'pî Jesusya. Mîrîrî ye'nen ka'ne' pe o'ma' pî' ta'pîiya: —Amîrî imaimu pra anna ku'nen, pana'tî' anna ku'nen. Epa'kakî mîserî yapai. Atîkî. Inî'rî kaiipîi mîserî pia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","O'ma' entaimepîtî'pî. Warayo' yenunpîtî'pîiya non pona. Mîrîrî tîpo eepa'ka'pî. Isa'manta'pî warantî warayo' esenunsa' wanî'pî. —A'kî. Aasa'mantasa' man —ta'pî tiaronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tîîse Jesusya i'mî'sa'ka'pî itenya pî' tapi'se. Awe'mî'sa'ka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wîttî ta Jesus ewomî'pî. —Î' wani' awanî ye'nen o'ma' tîrîka annaya yentai awanî mîrîrî? —ta'pî inenupa'sanya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Kure'ne Paapa yarakkîrî eeseurîmakon e'pai awanî mîrîrî mîîkîrî ye'ka o'ma' tîrîkakonpa —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Moropai mîrîrî pata pai to' wîtî'pî Galiléia pata poro. Mîrîrî poro tuutî epu'tî anî'ya yu'se pra Jesus wanî'pî, ");
INSERT INTO mbcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","maasa ma're tînenupa'san yenupa tîuya ye'nen. To' yenupa'pîiya mîrîrî warantî: —Uurî ka' poi iipî'pî pemonkon pe. Tiaronya uyekaremekî kupî sîrîrî uyeyatonon pî'. Inkamoroya uyapisî kupî sîrîrî. Uwî to'ya kupî sîrîrî. Uwî to'ya tîpo, iteseurîno wei yai e'mî'sa'ka kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Î' taiya epu'tî to'ya pra awanî'pî, tîîse anekaranmapopai pra nîrî to' wanî'pî ipî'. Maasa pra eranne' pe to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","To' erepamî'pî Cafarnaum pata pona. Tîîko'manto' wîttî ta teewomî tîpo, Jesusya ta'pî tînenupa'san pî': —Î' pî' eesiyu'pîtîkon manni' e'ma taawîrî yi'nî pe? ");
INSERT INTO mbcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yuuku to'ya pra awanî'pî. Uurî insanan yentaino panpî' kai'ma to' esenumenkasa' wanî'pî tamî'nawîrî. Mîrîrî pî' to' esiyu'pî'sa' wanî'pî tuutîkon pe. Mîrîrî ye'nen yuuku to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus ereuta'pî. Asakî'ne pu' pona tîîmo'tai'nîkon yanno'pîiya tîîpia. —Tamî'nawîronkon yentai e'pai awanîkon ya, to' ma're e'tî. Tamî'nawîronkon poitîrî pe e'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Moropai more yapisî'pîiya itenya pî'. Yarî'pîiya to' kore'ta. Yanumî'pîiya tena'. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Uyapurî tîuya ye'nen, anî'ya ipîkku pepîn yapi'sa' ya, mîserî ye'ka more warantî, uurî nîrî yapisîiya mîrîrî. Moropai uurî yapisîiya ya, uyarimatîpon Paapa yapisîiya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","—Uyenupanen —ta'pî Joãoya ipî'. —Ayese' esatî tîuya ye'ka pe, o'ma'kon yenpa'kanen warayo' era'ma'pî annaya. Tîîse ipî' ta'pî annaya inî' ikupîiya namai, uurî'nîkon pokonpe pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Mîîkîrî pî' mîrîrî kî'kupîi kîkatî —ta'pî Jesusya. —Uyese' esatî ye'ka pe, ikupî eserîkan pepîn konekanen wanî ya, ka'ne' pe eeseurîma eserîke pra awanî upî' imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uyeyatonkon pe pra to' wanî ya, uyonpakon pe to' wanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","—Ayenku'tîuya'nîkon pepîn. Anî'ya awo'pakon ya tuna ke uurî yapurînen pe awanîkon wenai, Paapaya mîîkîrî awo'patîponkon ye'ma —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Moropai ta'pî Jesusya to' pî': —Innape uku'nen more yenupa anî'ya ya, imakui'pî ku'to'peiya kai'ma, mararî pra Paapaya mîîkîrî taruma'tî. A'kî, anî' sa'manta ya tî' tewa'tîi i'mî pî' tuna ka tenunse, imakui'pî pe pu'kuru awanî. Tîîse itentai imakui'pî pe awanî insamoro moreyamî' yonpaya imakui'pî kupî emapu'tîiya ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imakui'pî konekaya emapu'tî ayenya ya, imerenkî'kî. Itenya imerenkî'sa' pe ipatîkarî aako'mamî ya, morî pe panpî' awanî mîrîrî, asakî'ne ayenya tîîse apo' ya' attî yentai, esi'nî'koi pepîn apo' ya' attî yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Miarî ipatîkarî tamî'nawîronkon e'taruma'tî mîrîrî pata ya', moropai î' pensa apo' esi'nîpî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Moropai imakui'pî konekaya emapu'tî a'puya ya, imerenkî'kî imakui'pî kupîya namai. Maasa pra morî pe panpî' awanî mîrîrî ipatîkarî Paapa pia aako'mamî ya i'pu imerenkî'sa' pe, asakî'ne a'pu tîîse apo' ya' attî yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Miarî ipatîkarî tamî'nawîronkon e'taruma'tî mîrîrî pata ya', moropai î' pensa apo' esi'nîpî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Moropai imakui'pî konekaya emapu'tî ayenuya ya, imo'kakî imakui'pî kupîya namai. Maasa pra morî pe panpî' awanî mîrîrî ipatîkarî Paapa pia enen aako'mamî ya tiwin ayenu tîîse, sa'nîrî ayenu tîîse apo' ya' attî yentai. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mîrîrî pî' Paapa maimuya taasa' pena: “Miarî ipatîkarî tamî'nawîronkon e'taruma'tî mîrîrî pata ya' moropai î' pensa apo' esi'nîpî pepîn.” taasai'ya man. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tamî'nawîronkon uyapisîtîponkon e'taruma'tî sîrîrî non po. Mîrîrî wenai, tîwe'taruma'tîkon ye'nen, inî' panpî' Paapa yapurî to'ya. Paapa wakîri pe panpî' to' ena. ");
INSERT INTO mbcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Morî pe pu'kuru pan wanî. Tîîse inî'mîra eenasa' ya, inî'rî inî'ne pe ikupî pepîn e'painon. Morî pan warantî, inî'ne pan wanî warantî e'tî. Inî'ne panya uyo'kon ko'mannîpî warantî ayewankon ko'mannî'tî morî pe, imakui'pî kupîya'nîkon namai. Mîrîrî warantî awanîkon ya ayonpakon pokonpe tîwanmîra aako'mamîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Moropai Jesus wîtî'pî mîrîrî pata poi. Judéia pata poro attî'pî moropai iren Jordão ratai poro. O'non pata arinîkon epere'sa' ya tîîpia, inkamoro yenupa'pî Jesusya. Inî'rî arinîkon eperepî'pî iipia moropai inî'rî teseru warantî rî to' yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseuyamî' wîtî'pî nîrî Jesus pia. Jesus anaka'mapai to' wanî'pî. Ta'pî to'ya ipî': —Tîno'pî rumakasa' warayo'ya ya, yairî awanî mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—Î' ye'ka pe Moisés nurî'tîya ankupîkon ton ekaremekî'pî? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisésya ta'pî: “Warayo'ya taasa' ya tîno'pî pî' kaareta pona tîmenukai, uno'pî pe pra awanî sîrîrî tarîpai, taiya ya, tîno'pî pî' irumakaiya e'painon,” ta'pîiya —ta'pî to'ya Jesus pî' ");
INSERT INTO mbcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tîîse Jesusya ta'pî: —Yairon pepîn mîrîrî. Tîîse mîrîrî warantî ankupîkon ton menuka'pî Moisésya maasa pra morî kupîya'nîkon eserîke pra awanîkon epu'tî tîuya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tîîse tamî'nawîron koneka tîuya yai Paapaya warayo' koneka'pî moropai wîri'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mîrîrî ye'nen warayo' no'pîta yai eemo'ka tun moropai tîsan pia pai moropai tîno'pî yarakkîrî eena. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mîrîrî ye'nen asakî'ne to' tîîse tiwinan warantî to' ena mîrîrî. Mîrîrî ye'nen asakî'nankon warantî pra to' wanî. Tîîse tiwinan warantî to' enasa' mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uyepotorîkonya sa'nîrî to' wanî emapu'tîsa' ye'nen. Anî'ya to' eturumaka emapu'tî yu'se awanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mîrîrî tîpo wîttî ta tîîse, Jesus nenupa'sanya ekaranmapo'pî mîrîrî taiya manni' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusya ta'pî: —Anî'ya tîno'pî rumakasa' ya, moropai tiaron wîri' yarakkîrî awanî ya, imakui'pî kupîiya mîrîrî tîno'pî winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Moropai wîri'ya tînyo rumakasa' ya, moropai tiaron warayo' yarakkîrî awanî ya, imakui'pî kupîiya mîrîrî tînyo winîkîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Moropai tiaronkonya moreyamî' yarî'pî Jesus pia tenya tîîto'peiya to' pona, to' pîremato'peiya. Tîîse inenupa'sanya ta'pî to' pî': —Insamoro ye'kakon moreyamî' kîsene'tî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tîîse epu'tî tîuya pe Jesus ekore'ma'pî. —Tîwî moreyamî' ii'to'pe uupia —ta'pîiya tînenupa'san pî'. —To' tîma'nîpai pra e'tî. Maasa pra Paapa pemonkonoyamî' wanî insanan moreyamî' warantî. Insanan warainokon innape tîku'nenan esa' pe Paapa wanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ayenku'tîuya'nîkon pepîn. Anî' eturumaka pra awanî ya Paapa yenya' tesa' pe awe'to'pe, tesa'kon yenya' moreyamî' eturumaka manni' warantî, Paapa pia tîîko'manto'kon eporî to'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mîrîrî tîpo moreyamî' yapisî'pî Jesusya tena'. Moropai ta'pîiya Paapa pî': —Paapa, insanan moreyamî' ko'mannî'kî morî pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mîrîrî tîpo Jesus ese'ma'tî tanne, teeka'tunse warayo' erepamî'pî iipia. Ikaisarî awe'sekunka'pî inama ye'ka pe. Moropai Jesus ekaranmapo'pîiya: —Uyenupanen, morî amîrî —ta'pîiya. —Î' kupîuya e'painon ipatîkarî enen uuko'manto'pe Paapa pia? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—Î' wani' awanî ye'nen morî amîrî taaya manni' upî'? —ta'pî Jesusya. —Tiwinan morî moro man, Paapa neken. Tiaron ton pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uyeserukon pe Paapa nekaremekî'pî epu'nen amîrî. Pemonkon kî'wîi, moropai tiaron no'pî yarakkîrî tîwe'se pra e'kî, ama'ye' pe pra e'kî, seru'ye' pe teeseurîmai pra e'kî ayonpa pî', ayonpa tenku'tîi pra e'kî, ayun, moropai asan sa'namakî Paapa nekaremekî'pî sîrîrî, tamî'nawîrî unkupîkon pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Inna, uyenupanen —ta'pî warayo'ya. —Mîrîrî yawîron uurî pena pata pai sîrîrî tîpose. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus esenumenka'pî ipî'. Itu'se awanî'pî kure'ne. —Maasa, inî' tiwinano'pî ankupî ton moro man —ta'pîiya. —Ayemanne ke e'repata tamî'nawîrî. Moropai itepe'pî mîtîrîi î' ton pînon sa'ne tîwe'taruma'tîsanon pia. Mîrîrî kupîya ya, ka' po eerepansa' yai, morî pu'kuru tîrî Paapaya aapia. Uyeseru pî' esenupai maaipîi —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mîrîrî taa Jesusya pî' mîîkîrî a'manta'pî. Maasa pra mararon pepîn itemanne mîîto'pe. Temanne yapurî'pîiya kure'ne pu'kuru. Mîrîrî ye'nen kure'ne teesewankono'mai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tîwoi'nîkon pemonkonyamî' era'ma'pî Jesusya. Moropai ta'pîiya tînenupa'san pî': —Sa'me pu'kuru see awanî Paapa pia ipîkku pe tîwe'sen eturumaka tesa' pe awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mararî pra inenupa'san esenumenka'pî imaimu pî'. Tîîse inî'rî Jesusya ta'pî to' pî': —Sa'me pu'kuru tîniru esanon ewonto'pe Paapa pia ipemonkono pe, ˻kure'ne tînirurîkon pînînma to'ya ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A'kî, sa'me awanî camelo ewonto'pe akkusa yeutta yai, itentai tîwanî ye'nen. Mîrîrî warantî ipîkku pe tîwe'senon wanî. Sa'me pu'kuru awanî, inkamoro eturumaka pepîn Paapa pia tesa'kon pe awe'to'pe —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mararî pra to' esenumenka'pî mîrîrî taiya pî'. —Mîrîrî warantî awanî ya, anî' e'pîika'tî e'painon moriya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Inî'rî Jesus esenumenka'pî to' pî': —Tîîwarîrî anî' e'pîika'tî pepîn. Tîîse Paapaya tamî'nawîronkon pîika'tî e'painon. Tamî'nawîron kupî Paapaya e'painon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—A'kî —ta'pî Pedroya Jesus pî'. —Tamî'nawîron rumakasa' annaya moropai awenairî anna ii'sa' sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesusya ta'pî: —Ayenku'tîuya'nîkon pepîn. Uyapurîto' tîuya wenai itekare ekareme'se anî' wîtî ya tonpayamî' piapai, mîîkîrîya, inî' panpî' tonpa ton eporî. Tonpayamî' tîwîrisitonon, tîsan, tîyun moropai tînmukuyamî' piapai attî ya, arinîke tonpa ton eporîiya, takon ton, tîwîrisi ton, tîsan ton, tînre ton. Moropai tewî', tîpata, rumakaiya ya, inî' panpî' tu'ke tewî' ton moropai tîpata ton eporîiya tu'ke. Moropai tiaronkonya itaruma'tî umaimu yawîrî awanî wenai, sîrîrî non po mîrîrî warantî eporîiya. Moropai ka' po ipatîkarî mîîkîrî ko'mamî Paapa pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tiaronkon wanî arinîkon esa' pe sîrîrî non po. Tîîse Paapa pia teerepansa'kon yai, anî' esa' pe to' wanî pepîn. Tiaronkon wanî anî' esa' pe pra sîrîrî non po. Tîîse Paapa pia teerepansa'kon yai, arinîkon esa' pe to' ena —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","34","Jesus nenupa'san wanî'pî Jerusalém pona tuutîsanon pe, moropai Jesus wanî'pî to' rawîrî. Asakî'ne pu' pona tîîmo'tai'nîkon mo'ka'pîiya inî'rî moropai to' yenupa'pîiya tîpî', o'non ye'ka pe tîwanî kupî pî'. —A'kî —ta'pîiya. —Jerusalém pona wîtîn sîrîrî. Uurî ka' poi iipî'pî pemonkon pe. Tiaronya utîrî kupî sîrîrî teepîremasanon esanon moropai Moisés nurî'tîya yenupato' pî' yenupatonkon pia. “Iwî e'pai man,” taa to'ya kupî sîrîrî. Mîrîrî tîpo teepîremasanon esanon, Moisés nurî'tîya yenupato' pî' yenupatonkonya utîrî kupî sîrîrî Judeuyamî' pepîn pia. Inkamoro wo'ma'ta kupî sîrîrî upî'. Tetakukon yenumî to'ya upona. U'po'pîtî to'ya moropai uwî to'ya. Uwîsa' to'ya tîpo, iteseurîno wei yai e'mî'sa'ka kupî sîrîrî —ta'pî Jesusya. Kure'ne inenupa'san esenumenkasa' wanî'pî ipî'. Tiaronkon to' wenairî itî'san wanî'pî eranne' pe Jerusalém pona Jesus wîtî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mîrîrî tîpo Tiago, moropai João wîtî'pî iipia. Zebedeu munkîyamî' inkamoro. —Anna yenupanen —ta'pî to'ya. —Apî' anna nesatî tîrîya yu'se anna man, anna pia —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Î' kupîuya yu'se awanîkon? —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Tamî'nawîronkon esa' pe eena yai, ereutapai anna wanî, tiwin meruntî winî, tiwin kamai' ya' to' esa' pe anna e'to'pe awarantî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusya ta'pî: —Anesatîkon kupîuya pepîn e'painon. Epu'tîya'nîkon pra naatîi. Tiaronkonya utaruma'tî kupî sîrîrî. Mîrîrî yapîtanîpîuya kupî sîrîrî. Amîrî'nîkon kanan? Uyese' pî' awanîkon wenai tiaronkonya ataruma'tîkon ya, yapîtanîpîya'nîkon e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Inna. Yapîtanîpî annaya e'painon —ta'pî to'ya. —Innape e'taruma'tî warantî awe'taruma'tîkon nîrî —ta'pî Jesusya. —Uwî tiaronkonya warantî tiaronkonya awîkon nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tîîse umeruntîri winî moropai kamai' winî ereutatî tauya pepîn apî'nîkon. Uyunya neken taa e'painon tînmo'ka'san pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","To' yonpayamî' mia' tamî'nawîronkonya to' nesatî'pî eta'pî moropai to' ekore'ma'pî Tiago moropai João pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesusya to' yanno'pî tîîpia. —Sîrîrî non po tamî'nawîronkon esanonya tîpemonkonoyamî' yaipontî to' taimerunpai epu'tî pî' naatîi. To' yepotorîtononya to' panama to' teta'kai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","—Tîîse mîrîrî warantî pra e'tî. Ayonpakon yentai e'pai awanîkon ya, to' ma're e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","To' esa' pe e'pai awanîkon ya, to' poitîrî pe e'tî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","—Uurî ka' poi iipî'pî aruinankon ton pe —Jesusya ta'pî. —Tîpoitîrî ke e'to'pe kai'ma uui'sa' pra wai. Tîîse tamî'nawîronkon pîika'tîto'peuya kai'ma uuipî'pî. Arinîkon nîkupî'pî imakui'pî yepe' pe uusa'mantato'pe kai'ma uuipî'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mîrîrî tîpo to' wîtî'pî Jericó pata poro. Jericó pata pai to' ese'ma'tî'pî, Jesus, inenupa'san, moropai tiaronkon arinîkon. Moropai enkaru'nan ereutasa' wanî'pî e'ma ena pona, itese' Bartimeu. Timeu munmu mîîkîrî. Tuutîsanon yeka'nunka pî' aako'mamî'pî tîniru tîîto'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","—Jesus Nazarépon erepansa' man —ta'pî tiaronkonya. Mîrîrî eta tîuya pe, Bartimeu entaimepîtî pia'tî'pî. Ta'pîiya: —Jesus, Davi nurî'tî paarî'pî amîrî, pîika'tîton amîrî. A'noko'pî pe sa'ne uyera'makî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Arinîkon ekore'ma'pî ipî'. —Moo e'kî —ta'pî to'ya ipî'. Tîîse inî' panpî' awentaimepîtî'pî, yuukuiya pra. —Davi nurî'tî paarî'pî, a'noko'pî pe uku'kî sa'ne —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus emî'pamî'pî imaimu eta tîuya ye'nen. —Mîîkîrî yannotî —ta'pîiya. —Ayanno pî' Jesus man —ta'pî to'ya enkaru'nan pî'. —Atausinpakî. E'mî'sa'kakî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sonpan ke awe'wontîsa' wanî'pî. Mîrîrî tîmo'kai awe'mî'sa'ka'pî. Moropai Jesus pia attî'pî. Tiwinarî mîîkîrî yenu esepi'tî'pî. —Ayewî' ta enna'popai awanî ya, tîwanmîra atîkî —ta'pî Jesusya. Tîîse Jesus wenairî attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—Î' kupîuya yu'se awanî apî'? —ta'pî Jesusya ipî'. —Uyenupanen, uyenu konekakî sa'ne —ta'pî enkaru'nanya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Innape uku'sa'ya ye'nen, ayepi'tîuya sîrîrî —ta'pî Jesusya ipî'. Tiwinarî mîîkîrî yenu esepi'tî'pî. —Ayewî' ta enna'popai awanî ya, tîîwanmîra atîkî —ta'pî Jesusya. Tîîse Jesus wenairî attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Oliveira ye'ka kîrî pona to' erepamî'pî. Aminke pra to' wanî'pî Jerusalém pî'. Moro awanî'pî pata mîrikkî pemonkonyamî' ko'manto' Betfagé moropai Betânia mîrikkî aminke pra nîrî. Oliveira kîrî pona teerepamîkon pe, Jesusya asakî'nankon tînenupa'san yarima'pî taponse' ton jumenta era'mai. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","To' yarima tîuya pe ta'pîiya to' pî': —Aminke pra pata mîrikkî man. Mîrîrî pona atîtî. Eerepansa'kon pe jumenta more yewa'tîsa' eporîya'nîkon anî' enuku'pî pepîn ipona. Mîîkîrî meukatîi moropai mene'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Î' ton pe mîîkîrî yarîya'nîkon mîrîrî?” taa anî'ya ya, “Uyesa'kon man itu'se,” makatîi, “Maasa tîîko'manse inna'poiya” makatîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Imaimu pe to' wîtî'pî. Jumenta more yewa'tîsa' eporî'pî to'ya e'ma ta aminke pra mana'ta pî'. Mîîkîrî yeuka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mororonkonya ta'pî: —Î' ton pe jumenta more yarîya'nîkon mîrîrî kai'ma? ");
INSERT INTO mbcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus maimu ekaremekî'pî to'ya, moropai yaato'pe to'ya to' rumaka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jumenta more yarî'pî to'ya Jesus pia. Teerepansa'kon pe, tîponkon tîrî'pî to'ya ipona Jesus enu'to'pe, moropai eenuku'pî ipona. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Arinîkonya tîponkon tîrî'pî e'ma tapî'. Tiaronkonya tîna'tî'pîkon yu' yare tîrî'pî nîrî. ˻Mîrîrî kupî'pî to'ya itekîn wîtîto'pe iporo, Jesus yapurî tîuya'nîkon ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tiaronkon wîtî'pî irawîrî moropai tiaronkon ite'ma'pî pî'. —Morî pe pu'kuru Paapa man —ta'pî to'ya mararî pra tîwentaimepî'se. —Morî pe pu'kuru man taapai'nîkon Paapa narima'pî pî', Jesus pî'. Mîîkîrî yapurîpai'nîkon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—Penaronkon esa' pe Davi nurî'tî wanî'pî warantî upatakon esa' pe mîîkîrî ena kupî sîrîrî uyesa'kon pe. Mîîkîrî yapurîpai'nîkon. “Morî pe pu'kuru man,” taapai'nîkon. Morî pe pu'kuru Paapa man taa ka' po tîîko'mansenonya e'pai awanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mîrîrî tîpo Jesus erepamî'pî Jerusalém pona. Epîremanto' yewî' ta eewomî'pî. Tîîse pata ko'mansa' wanî'pî. Mîrîrî ye'nen, tamî'nawîron era'ma tîuya tîpo eepa'ka'pî. Moropai Betânia pona attî'pî, asakî'ne pu' pona tîîmo'tai'nîkon tînenupa'san pokonpe. Moro to' we'na'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pata erenmapî pe, Betânia poi to' ese'ma'tî'pî. Jerusalém pona to' wîtî'pî. Tuutîkon pe, emi'ne Jesus ena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aminke si'ma figo ye' aretasa' era'ma'pîiya. Mîrîrî yekare pî' attî'pî iteperu pikkai. Tîîse iteperu pra awanî'pî. Yare neken eporî'pîiya maasa pra eepeta yai pra awanî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mîrîrî yei pî' ta'pî Jesusya: —Ipatîkarî teepetai pra ako'mankî tarîpai. Mîrîrî taiya eta'pî inenupa'sanya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mîrîrî tîpo to' erepamî'pî Jerusalém pona. Epîremanto' yewî' ta eewomî'pî. Epîremanto' yewî' ta si'ma tîwe'repasanon moropai yennanenan tîrîka'pîiya. Moropai tîniru miakanmanan yaponse' ra'tî'pîiya. Mayayamî' ke tîwe'repasanon yaponse' ra'tî'pîiya. Inkamoro tîrîka'pîiya imakui'pî kupî to'ya ye'nen epîremanto' yewî' ta, to' e'repa ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Epîremanto' yewî' tapî' temannekon mankanan pî' ta'pîiya: —Sîrîrî poro katîtî. E'ma pepîn sîrîrî. Epîremanto' yewî' sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mîrîrî tîpo tamî'nawîronkon yenupa'pîiya: —Penaro' Paapa maimu ekareme'nenya Paapa maimu menuka'pî. “Tamî'nawîronkon pemonkonyamî' ton pe epîremanto' yewî' pe uyewî' wanî mîrîrî,” ta'pî Paapaya. Mîrîrî warantî imenuka'pî Paapa maimu ekareme'nenya —ta'pî Jesusya. —Tîîse ama'ye'kon yewî' pe iku'sa'ya'nîkon mîrîrî. Tarî epîremai iipî'san yenku'tîya'nîkon awe'repato'kon ke. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mîrîrî eta'pî teepîremasanon esanonya moropai Moisés nurî'tîya yenupato' pî' yenupatonkonya. Tamî'nawîronkon esenumenka kure'ne Jesusya tenupakon pî' epu'tî'pî to'ya. Mîrîrî ye'nen inama'pî to'ya. —Maasa o'non ye'ka pe mîîkîrî wîî'nîkon e'painon? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pata ewaronpamî pe, Jesus moropai inenupa'san enna'po'pî cidade poi Betânia pona. Betânia po to' we'na'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pata erenma'sa' pe, Jerusalém pona to' wîtî'pî inî'rî. Tuutîkon pe, figo ye' era'ma'pî to'ya. Awa'pi'tasa' wanî'pî irupukon pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jesus nîkupî'pî pî' Pedro enpenata'pî. —Uyenupanen, maasa figo ye' era'makî. Anpa'nîpî'pî sa'mantasa' sîrîrî era'makî —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusya ta'pî ipî': —Innape Paapa ku'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ayenku'tîuya'nîkon pepîn. “Seeni' wî' yarimakî parau ka,” taaya'nîkon ya Paapa pî', ikupîiya. Tîîse Paapa tîmu'tunpai pra esatîya'nîkon e'pai awanî. Innape ikupîya'nîkon e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mîrîrî ye'nen mîrîrî warantî apanamauya'nîkon sîrîrî. Paapa yarakkîrî eeseurîmakon pe “Innape unesatî kupîiya pe nai,” makatîi. Imu'tunpa pra awanî ya, ikupîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Paapa yarakkîrî eeseurîmakon yai, awinîkîi'nîkon imakui'pî ayonpakon nîkupî'pî wenai teekore'mai aako'mamîkon ya, mîrîrî ku'tî aawanmîra'nîkon. Awinîkîi'nîkon ayonpakon nîkupî'pî imakui'pî kupîya'nîkon ya aawanmîra'nîkon, ayunkon ka' po tîîko'mansenya tîwinîkîi ankupî'pîkon imakui'pî kupî nîrî tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aawanmîra'nîkon ayonpakon nîkupî'pî awinîkîi'nîkon kupîya'nîkon pra awanî ya, ankupî'pîkon tîwinîkîi kupî Paapa pepîn nîrî tîîwanmîra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus moropai inenupa'san erepamî'pî inî'rî Jerusalém pona. Epîremanto' yewî' ta Jesus asarî tanne teepîremasanon esanon moropai Moisés nurî'tîya yenupato' pî' yenupatonkon wîtî'pî a'yeke'tonon Judeuyamî' panamanenan yarakkîrî iipia eseurîmai. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—Anî' maimu pe insanan tîrîka'pîya sîrîrî epîremanto' yewî' tapai? Anî'ya ayaipontî'pî mîrîrî warantî ikupîpa? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Ayekaranmapouya'nîkon e'mai' pe —ta'pî Jesusya to' pî'. —Apî'nîkon unekaranmapo ekaremekîya'nîkon ya, anî' maimu pe insanan tîrîka'pîuya ekaremekîuya nîrî apî'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Anî' maimu pe João Batistaya tamî'nawîronkon yenpatakonapîtî'pî mîrîrî? Paapa maimu pe ka'rî? Pemonkon maimu pe ka'rî? O'non ye'ka pe epu'tî pî' naatî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mîrîrî taa Jesusya pî' to' eseurîma'pî teepere'se î' ye'ka pe yuuku tîuya'nîkon epu'tîkonpa kai'ma. João Batista nurî'tî eseurîmapîtî'pî Paapa maimu pe kai'ma tamî'nawîronkon esenumenka'pî ipî'. Mîrîrî epu'tî'pî teepîremasanon esanon, Moisés nurî'tîya yenupato' pî' yenupatonkon moropai Judeuyamî' panamanenan a'yeke'tononya. Mîrîrî ye'nen inkamoro João Batista nurî'tî yapurînenan nama'pî to'ya. —Paapa maimu pe Joãoya to' yenpatakona'pî taasa' ya, “Î' wani' awanî ye'nen João kupîya'nîkon pra awanî'pîkon innape moriya?” taa Jesusya eserîke awanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","—Tîîse tiaron pemonkon maimu pe to' yenpatakona'pîiya taasa' ya, tamî'nawîronkon ekore'ma upî'nîkon. Imakui'pî kupî to'ya eserîke awanî upî'nîkon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mîrîrî ye'nen ta'pî to'ya Jesus pî': —Epu'tî annaya pra man. Mîrîrî pî' ta'pî Jesusya: —Moriya anî' maimu pe unkupî kupîuya ekaremekîuya pepîn nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Moropai to' yeurîma pia'tî'pîiya panton pe: —Warayo'ya tînmîri ton ya'tî'pî. Tekkari ton pîmî'pîiya mararon pepîn uva ye'ka. Iwatî'pîiya inonkon tî'kon ke. Kure'nan tî' yai a'ta ton yaka'pîiya uva yekku asu'kato' ton. Tînmîri era'manenan yaponse' ton kawînan koneka'pîiya, ipo si'ma o'ma'kon ewomî era'mato'pe to'ya. Mîrîrî tîpo tiaronkon warayo'kon pî' ta'pîiya: “Umîri pî' eesenyaka'makon ya uyekkari yonpa ke aye'mauya'nîkon. Itonpa wanî uyekkari pe moropai itonpa wanî ayekkarikon pe,” ta'pîiya. “Inna. Î' wani' pra man,” ta'pî to'ya. Moropai attî'pî tiaron pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mîrîrî tîpo itekkari emîrî'pî. Mîrîrî yai tîpoitîrî yarima'pîiya, inkamoro warayo'kon pia tekkari yonpa era'mai. Eerepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tîîse mîîkîrî yapisî'pî to'ya. I'po'pîtî'pî to'ya. Î' rî tîtîse pra tîîse mîîkîrî tîrîka'pî to'ya. Î' ton pra awenna'po'pî tîkaraiwarî pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Moropai tiaron tîpoitîrî yarima'pî umî esa'ya. Mîîkîrî pa'tîpîtî'pî to'ya ipu'pai yai. Imakui'pî kupî'pî to'ya yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Moropai inî'rî tiaron yarima'pîiya. Mîîkîrî wî'pî to'ya. Mîrîrî warantî tiaronkon yarimapîtî'pîiya tiwin pî'. Moropai mîrîrî warantî inkamoro pî' imakui'pî kupî'pî to'ya to' yarakkîrî. Tiaronkon po'pîtî'pî to'ya moropai tiaronkon wî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Moro awanî'pî tiwinano'pî warayo'. Umî esa' munmu mîîkîrî. Kure'ne tînmu yapurî'pîiya. Upoitîrîtonon yapurî to'ya pra awanî'pî. Tîîse mîserî unmu yapurî to'ya kai'ma eesenumenka'pî. Mîrîrî ye'nen tînmu yarima'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tîîse inkamoro warayo'kon pia mîîkîrî erepamî pe, ipî' to' eseurîma'pî teepere'se. “A'kî. Umî esa' sa'manta yai, inmurî'pî pata pe umî ena. Mîrîrî ye'nen iwîpai'nîkon. Mîrîrî tîpo umî esa' sa'manta yai, upatakon pe eena itesa' ton pra awanî ye'nen,” ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mîrîrî ye'nen mîîkîrî umî esa' munmu yapisî'pî to'ya. Moropai iwî'pî to'ya. Itesa' rî'pî yenumî'pî to'ya umî yapai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Mîrîrî epu'tî tîuya pe, î' kupî uva ye'ka esa'ya eserîke awanî? —ta'pî Jesusya to' pî'. —Tînmîri ya' attî moropai inkamoro warayo'kon, inmu wîîtîponkon tî'kaiya eserîke awanî tamî'nawîrî. Mîrîrî tîpo tiaronkon warayo'kon eporîiya tînmîri era'manenan ton —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—Sîrîrî Paapa maimu e'menukasa' epu'nenan amîrî'nîkon. Sîrîrî warantî Paapa eseurîma'pî. Sîrîrî warantî imenuka'pî to'ya: Tî' pe wîttî konekanenanya ta'pî: “Sîrîrî tî' wanî pepîn morî pe, wîttî konekato'pe”, taa to'ya. Moropai yenumî'pî to'ya. Tîîse to' nenumî'pî wanî'pî morî pe pu'kuru tamî'nawîron tî' yentai. Tarîpai wîttî ko'mannîpîiya tamî'nawîron tî' yentai eesenumî namai. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uyepotorîkonya to' nîrumaka'pî kupî'pî tamî'nawîron yentai. Kure'ne esenumenkan inkupî'pî pî'. Mîrîrî warantî Paapa maimu menuka'pî penaro'konya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tîwinîkîi'nîkon Jesus eseurîma panton pe epu'tî'pî teepîremasanon esanon, Moisés nurî'tîya yenupato' pî' yenupatonkon, moropai Judeuyamî' panamanenan a'yeke'tononya. Mîrîrî ye'nen anapi'pai to' wanî'pî. Tîîse tamî'nawîronkon nama'pî to'ya arinîke to' wanî ye'nen. Jesus rumaka'pî to'ya. Moropai to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mîrîrî tîpo fariseuyamî' yarima'pî tiaronkonya Jesus pia Herodes pemonkonoyamî' pokonpe. Jesus anaka'mapai to' wanî'pî. Yairî pra eeseurîma yu'se to' wanî'pî, “A'kî, imakui'pî pe eeseurîma,” taakonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To' erepamî'pî iipia. —Anna yenupanen —ta'pî to'ya ipî'. —Ayeseru epu'nenan anna. Seru'ye' pepîn amîrî. Ipîkkukon pepîn yentai ipîkkukon yapurînen pepîn amîrî. Paapa yeseru ekaremekîya tiaronkon ipîkkukon tînamai pra. Ayekaranmapo annaya sîrîrî. Uyesa'kon César nekaremekî'pî tamî'nawîronkon ne'maton pe, tîîpia ye'ma annaya ya, morî pe awanî? Paapa nekaremekî'pî unkupîkon ton pe yairî anna wanî mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","—O'non ye'ka pe epu'tî pî' nan? Ye'ma annaya ka'rî? Ye'ma annaya pepîn ka'rî? Tîîse seru' pe tenku'tî to'ya epu'tî'pî Jesusya. —Yairî pra amaimukon yuukuuya yu'se awanîkon epu'tî pî' wai eeseurîmakonpa kai'ma —ta'pîiya. —Maasa, tîniru ene'tî era'mato'peuya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tîniru ena'pî enepî'pî to'ya. Jesusya yapisî'pî. —Anî' ese' e'menukasa' sîrîrî? —ta'pîiya to' pî'. —Uyesa'kon César mîîkîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Inna, moriya —ta'pî Jesusya. —Itîîkî iipia, imîrî pe awanî ye'nen. César nekaremekî'pî unkupîkon ton pe ku'tî moropai Paapa nekaremekî'pî unkupîkon ton pe ku'tî nîrî. Mîrîrî taiya pî' ta'pî to'ya: —Akaya, epu'nen mîîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mîrîrî tîpo saduceuyamî' wîtî'pî Jesus pia. Saduceuyamî' inkamoro Judeuyamî'. Tiaron pe rî to' esenumenka. Sa'mantan tîpo ipatîkarî tîpannî kai'ma to' esenumenka. E'mî'sa'kan pepîn sa'mantan tîpo kai'ma to' esenumenka. Inkamoro wîtî'pî Jesus pia. Moropai ekaranmapo'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Anna yenupanen —ta'pî to'ya. —Moisés nurî'tîya uyeserukon ton menuka'pî. Mîrîrî warantî ta'pîiya inmu pîn warayo' sa'manta ya itakono'pîya ino'pî rî'pî yapisî e'pai awanî tîno'pî pe. Mîrîrî tîpo more yan pe irui no'pîrî'pî enasa' ya tînre yenpoiya yai, “Urui munmu'pî mîserî”, taa warayo'ya tînmu pe tîîse. Mîrîrî Moisés nurî'tî nîmenuka'pî uyeserukon ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tarîpai, moro awanî'pî warayo'kon asakî'ne mia' pona tîîmo'tai'nîkon kaisarî. To' ruinankon no'pîta'pî tîîse inmu pra si'ma aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mîrîrî tîpo tîrui no'pî rî'pî yarakkîrî itakono'pî wanî'pî. Tîîse mîrîrî warantî nîrî aasa'manta'pî inmu pra si'ma. Moropai mîîkîrî yakono'pîya tîruinankon nurî'tî no'pî rî'pî yapisî'pî tîno'pî pe mîrîrî warantî. Moropai mîrîrî warantî nîrî inmu pra si'ma aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tamî'nawîrî to' sa'manta'pî, tiwin pî' tîruinankon nurî'tî no'pî rî'pî yarakkîrî tîwanîkon tîpo, to' e'tî'ka'pî. Moropai warayo'kon sa'manta tîpo, mîîkîrî wîri' nîrî sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Asakî'ne mia' pona tîîmo'tai kaisarî warayo'kon e'sa' wanî'pî. Mîîkîrî wîri' yarakkîrî inkamoro wanî'pî inyo pe tamî'nawîrî. Innape isa'manta'san e'mî'sa'ka ya, o'non ye'ka warayo' no'pî pe mîîkîrî wîri' wanî e'painon to' e'mî'sa'ka yai? —ta'pî saduceuyamî'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Paapa maimu epu'tîya'nîkon pra naatîi —ta'pî Jesusya. —Moropai meruntî ke pu'kuru Paapa wanî epu'tîya'nîkon pra naatîi. Mîrîrî ye'nen eesenku'tîkon mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Isa'manta'san e'mî'sa'kasa' yai, anî' wanî pepîn tîno'pî ke. Moropai tînyo ke wîri' wanî pepîn. To' ko'mamî ka' ponkon Paapa maimu ene'nenan inserîyamî' warantî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Maasa isa'manta'san e'mî'sa'kato' pî' ayeurîmauya'nîkon. Moisés nurî'tî nîmenuka'pî itekare epu'nenan amîrî'nîkon. Manni' parî' aramorî'pî aramî ekaremekî tîuya pe, tarakkîrî Paapa eseurîma'pî ekaremekî'pîiya. Paapaya ta'pî: “Uurî Paapa wanî Abraão nurî'tî yepotorî pe, moropai Isaque nurî'tî yepotorî pe, moropai Jacó nurî'tî yepotorî pe,” ta'pîiya. ta'pî Moisés nurî'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ipatîkarî pemonkon tîpamî ya, itesa' pe Paapa wanî pepîn e'painon aatîpansa' ye'nen. Enen tîîpia tîîko'mansenon esa' pe awanî. Mîrîrî ye'nen mîrîrî taa Paapaya manni' wenai enen Abraão nurî'tî wanî, moropai Isaque nurî'tî wanî, moropai Jacó nurî'tî wanî Paapa pia epu'tî mîrîrî. Mararî pra amîrî'nîkon esenku'tîsa' mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés nurî'tîya yenupato' pî' yenupaton warayo' erepamî'pî to' pia. Jesus yarakkîrî saduceuyamî' esiyu'pîtî eta'pîiya. Morî pe Jesusya saduceuyamî' maimu yuuku eta'pîiya. Moropai Jesus ekaranmapo'pîiya. —Uyeserukon ton pe Paapa nekaremekî'pî moro man. Tîîse o'non wanî to' yentai panpî'? O'non yawîrî ko'mannî yu'se Paapa wanî kure'ne panpî'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusya ta'pî: —Sîrîrî to' yentaino panpî'. See warantî awe'menukasa': Etatî, Israel yonparî'san. Ayesa'kon Paapa tiwinan. Tiaron ikaisaron ton pra man. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Paapa yapurîtî tamî'nawîrî ayewankon ke. Mîîkîrî ku'tî ayesa'kon pe. Kure'ne eesenumenkato'kon ke yapurîtî. Moropai tamî'nawîrî ameruntîrikon ke esenyaka'matî iipia. Mîrîrî warantî awe'menukasa' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Itonpa nîrî moro man. Sîrîrî itonpa: Tamî'nawîronkon pînînmatî aawarîrî eetî'nînma manni' warantî. Mîrîrî warantî awe'menukasa' man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Innape man, uyenupanen —ta'pî mîîkîrî Moisés nurî'tîya yenupato' pî' yenupanenya. —Tiwinan Paapa seru' pepîn. Innape ikaisaron ton pra awanî taaya manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kure'ne itu'se e'nî e'pai awanî. Ipî' esenumenkan e'pai awanî mararî pra. Meruntî ke iipia esenyaka'man e'pai awanî. Moropai uuwarîrî'nîkon etî'nînman kaisarî tamî'nawîronkon pînînma e'pai awanî seru' pepîn. Mîrîrî warantî ikupî ya, Paapa wakîri pe panpî' e'nî. Tîwakîri pe ikupîiya iipia untîrîkon pe uyekînkon po'tî yentai, moropai uyekînkon wîî yentai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Epu'nen pe mîîkîrîya tîmaimu yuuku epu'tî tîuya ye'nen, Jesusya ta'pî ipî': —Ayesa' pe Paapa yapisîya eserîke epu'tî pî' wai. Mîrîrî tîpo tamî'nawîronkon ena'pî eranne' pe Jesus pî'. Inî' anekaranmapopai pra to' awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Moropai Jesusya tamî'nawîronkon yenupa'pî epîremanto' yewî' ta. Ta'pîiya to' pî': —Moisés nurî'tîya yenupato' pî' yenupatonkonya taa: “Penaro' Judeuyamî' esa' Davi nurî'tî parî'pî neken mîîkîrî Cristo, Paapa nîmenka'pî,” taa to'ya. Î' wani' awanî ye'nen mîîkîrî taa to'ya? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","—Cristo pî' Davi nurî'tî eseurîma'pî pena. Morî Yekaton Wannîya eeseurîma emapu'tî'pî. Sîrîrî Davi nurî'tî maimu rî'pî: Uyesa' pî' Paapaya ta'pî: “Uupia ereutakî meruntî winî ayeyatonon aretî'kauya pîkîrî” ta'pîiya. Sîrîrî Davi maimu rî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davi paa pe neken Cristo wanî ya, î' wani' awanî ye'nen uyesa' taa Daviya manni' ipî'? —ta'pî Jesusya. Arinîkonya Jesusya tenupakon eta'pî tîwakîrikon pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","To' yenupa tîuya pe Jesusya ta'pî: —Tîwarî panpî' e'tî Moisés nurî'tîya yenupato' pî' yenupatonkonya ayenku'tîkon namai. Kusan panpî' sonpan tîponkon yeka'ma to'ya tîwakîrikon pe tiaronkon yentai tîwanîkon epu'to'pe tamî'nawîronkonya. Tamî'nawîronkon esekaremekî yu'se to' wanî aronne panpî' e'repanto' pata ya tîwanîkon ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Epere'nîto' yewî' ta tîwanîkon yai, tamî'nawîronkon yenu kaisarî ereutapai to' wanî aronne panpî' teesera'makonpa. Arinîkon kore'ta entamo'kai tuutîkon ya, e'mai' pe entamo'kapai to' wanî tamî'nawîronkon rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tîîse inyo isa'manta'san wîri'sanyamî' yemanne moropai to' pata mo'ka to'ya. Mîrîrî tanne kure'ne to' epîrema epîremanto' yewî' ta morî pe tîwanîkon kai'ma tamî'nawîronkon esenumenkato'pe tîpî'nîkon. Mîrîrî warantî inkamoro Moisés nurî'tîya yenupato' pî' yenupatonkon wanî mîrîrî. Mararî pra Paapaya to' taruma'tî kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mîrîrî tîpo Jesus ereuta'pî tîniru yapi'to' yense' pia. Paapa yapurî pe arinîkonya tîtînirurîkon tîrî itense' ya era'ma'pîiya. Mararon pepîn tîniru tîrî'pî arinîkonya tîniru esanonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Inyo isa'manta'pî wîri' iipî era'ma'pîiya. Tîwe'taruma'tîsen mîîkîrî, tîniru esa' pepîn. Mîîkîrîya asakî'ne tîniru ena'pî mîrikkî tîrî'pî itense' ya. Tiwin ite'ka tîwentamo'kato' yepe' kaisaron tîrî'pîiya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mîrîrî era'ma tîuya pe, tînenupa'san pî' ta'pî Jesusya: —Mîîkîrî era'matî. Ayenku'tîuya'nîkon pepîn. Tîwe'taruma'tîsen mîîkîrî wîri' inyo isa'manta'pî. Tîîse tîniru yense' ya tamî'nawîronkon nîtîrî'pî yentai intîrî'pî era'ma Paapaya tîwakîri pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Inkamoro tînirurî wanî kure'ne moropai itonpa pe neken itîîsa' to'ya. Tîîse î' ton pra si'ma wîri'ya tîtînirurî tîrî'pî tamî'nawîrî. Tekkari ye'mato' tîîsai'ya mîrîrî Paapa pia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Epîremanto' yewî' tapai teepa'kakon pe, Jesus nenupa'pî warayo'ya ta'pî ipî': —A'kî, seeni' epîremanto' yewî' konekasa' to'ya morî pe, inonkon panpî' tî' ke era'makî —ta'pîiya tepotorî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesusya ta'pî ipî': —Kure'nan seeni' wîttî era'ma pî' naatîi. Tîîse tiaronkonya seeni' wîttî yaranka kupî sîrîrî tamî'nawîrî. Yaranka to'ya tîpo tonpa po tiwinan tî' e'nîmî pepîn. Yenumî to'ya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mîrîrî tîpo Oliveira kîrî po Jesus ereutasa' wanî'pî tiaronkon yarakkîrî. Moro si'ma epîremanto' yewî' era'ma'pî to'ya. Tonpakon kore'tapai teemo'kai Pedro, moropai Tiago, moropai João, moropai André, inkamoroya ta'pî Jesus pî': ");
INSERT INTO mbcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Maasa, î' pensa mîrîrî taaya manni' kupî to'ya? —ta'pî to'ya. —O'non ye'ka pe mîrîrî kupî to'ya pe awanî epu'tî annaya e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusya to' yeurîma pia'tî'pî. —Tîwarî e'tî, anî'ya ayenku'tîkon namai. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uurî pe arinîkon e'kupî kupî sîrîrî seru' pe. “Uurî Cristo. Paapaya uyarimasa' sîrîrî,” taa to'ya kupî sîrîrî. Mîrîrî warantî arinîkon yenku'tî to'ya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aminkankon pepîn eseya'nama moropai aminkankon eseya'nama yekare etaya'nîkon. Tîîse mîrîrî pî' teesi'nî'se pra me'tîi. Mîrîrî warantî pata wanî pe man. Tîîse maasa tamî'nawîron ataretî'ka pepîn mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pemonkonyamî' eseya'nama tiaron pata po tîîko'mansenon yarakkîrî. Moropai pemonkonyamî' esanon eseya'nama tiaronkon esanon yarakkîrî. Tu'ke ite'ka pata e'tîtîtîkka kupî sîrîrî. Iwan wanî kupî sîrîrî kure'ne pata kaisarî'ne. Mîrîrî warantî tamî'nawîronkon e'taruma'tî pia'tî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tîwarî ako'mantî. Judeuyamî'ya ayapisîkon moropai tesanonkon pia ayarîkon to'ya. Epere'nîto' yewî' ta a'po'pîtîkon to'ya. Pemonkonyamî' esanon governadoryamî' pia moropai pemonkonyamî' esanon reiyamî' pia ayarîkon to'ya upemonkono pe awanîkon wenai. Inkamoro pî' nîrî uyeseru ekaremekîya'nîkon yu'se Paapa wanî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Paapa yekare ekaremekîya'nîkon e'pai awanî tamî'nawîronkon pî' sîrîrî non po. Mîrîrî ekareme'sa'ya'nîkon tîpo, sîrîrî non ataretî'ka. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Moropai tesanonkon pia ayarîkon to'ya yai, “Aka, yu'tou'ya ton epu'tîuya pra wai,” kîkatî. Aawarîrî'nîkon eeseurîmakon e'pai pra awanî. Tîîse Morî Yekaton Wannîya anekaremekîton ekaremekî ya, mîrîrî mekareme'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Warayo'konya takonkon wîî me'po. Tiaronkonya tînmukukon wîî me'po. Tiaronkon ekore'ma tunkon, moropai tîsankon pî'. Tunkon, tîsankon wîî me'po to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Moropai tewanmakon pe tamî'nawîronkonya akupîkon, upemonkono pe awanîkon wenai. Tîîse aasa'mantakon pîkîrî uyapurîya'nîkon ya, Paapaya apîika'tîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Penaro' Paapa maimu ekareme'nen wanî'pî itese' Daniel. Mîîkîrî maimu rî'pî e'menukasa' pî' esenupatî. Mîîkîrîya ta'pî: Tamî'nawîronkon yewanma pe tîwe'sen imakui'pî tîrî tiaronkonya kupî sîrîrî epîremanto' yewî' ta. Mîrîrî ye'ka tîîto' pepîn mîrîrî teuren, tîîse moro itîrî to'ya ta'pî Daniel nurî'tîya. Mîrîrî kupî to'ya yai, wî'kon kore'ta Judéia pata ponkon epe e'pai awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","—Mîrîrî tauya manni' kupî to'ya ya, poro pona teepa'kasa'kon ye'ka pe, ka'ne' pe to' epe e'pai awanî, temannekon era'mai teewonse pra wîttî ta. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tînmîrikon ya teesenyaka'makon yai mîrîrî kupî to'ya ya, ka'ne' pe to' epe e'pai awanî tîponkon tînmo'ka'pîkon tanunse pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aka more yan pe tîwe'sanon moropai mana'pokonkon to' munkîyamî' wîri'sanyamî'. Inkamoro e'taruma'tî kupî sîrîrî mîrîrî yai. To' epe eserîke pra awanî, more yan pe tîwanîkon ye'nen, mana'pokonkon pe to' munkîyamî' wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mepîrematîi kono' yai mîrîrî imakui'pî iipî namai. Maasa pra kono' yai aaipî ya, anî' epe eserîke pra awanî kure'ne tuna wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mîrîrî warantî eena yai, enen tîwe'sanon e'taruma'tî ipîra. Sîrîrî non koneka'pî Paapaya pata pai sîrîrî tîpose anî' e'taruma'tî pra awanî, inkamoro e'taruma'tîto' ton kaisarî. Moropai mîrîrî warantî to' e'taruma'tî tîpo inî' anî' e'taruma'tî pepîn mîrîrî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tîko'man pe tamî'nawîronkon e'taruma'tî ya mîrîrî warantî, enen anî'rî ko'mamî pepîn. Tîîse tînmo'ka'san pînînma Paapaya kure'ne. Inkamoro tînmo'ka'san wenai, kure'ne tîko'man pe tamî'nawîronkon e'taruma'tî tîrîiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mîrîrî yai anî'ya taasa' ya apî'nîkon: “A'kî, Paapa nîmenka'pî tarî man, Cristo,” innape mîîkîrî kî'ku'tî. “A'kî siini' pata Cristo man” taa tiaronya ya, mîîkîrî maimu kî'ku'tî innape. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maasa pra seru' uurî pe tîwe'ku'sanon iipî. “Uurî Cristo,” taa to'ya kupî sîrîrî. Moropai seru' pe Paapa maimu ekareme'nen pe tîwe'ku'sanon iipî kupî sîrîrî nîrî. Ikupî eserîkan pepîn kupî to'ya tamî'nawîronkon nera'ma ton pe. Moropai mîrîrî wenai tiaronkon esenku'tî. “Innape Paapa narima'pî pe man,” taa to'ya. Tîpemonkono pe Paapa nîmo'ka'san anaka'mapai inkamoro seru'ye'kon wanî, mîrîrî kupî tîuya'nîkon eserîke awanî ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mîrîrî namai tîwarî ako'mantî. Maasa mîrîrî warantî eena pra tîîse amîrî'nîkon pî' ekaremekî pî' wai epu'tîkonpa. Mîrîrî ye'nen tîwarî ako'mantî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mîrîrî yai tamî'nawîronkon e'taruma'tî tîpo, wei esi'nîpî pe man. Moropai a'kare pra kapoi ena pe man. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Moropai sirikkîyamî' e'soroka pe man ka' poi. Ka' pî' tîwe'sanon e'tîtî tîkka tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mîrîrî tîpo, pemonkon pe ka' poi iipî'pî uurî era'ma tamî'nawîronkonya katupuru kore'ta. Upî' to' eseurîma mîrîrî yai: “Ikaisaron meruntî ton pra man. Ikaisaron ipîkku ton pra man,” taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mîrîrî yai upoitîrîtonon inserîyamî' yarimauya upemonkono pe unmo'ka'san muurukuntîi. Tamî'nawîrî pata kaisarî to' wîtî upemonkonoyamî' unmo'ka'san era'mai, sîrîrî non po moropai ka' po. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A'kî, arawen ye' yeseru epu'nenan amîrî'nîkon. Arawen ye' ari'kutasa' ya aminke pra, “Kono' pîtî wanî sîrîrî,” taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mîrîrî warantî nîrî mîrîrî ekaremekîuya manni' kupî to'ya era'maya'nîkon yai, “Cristo enna'po kupî sîrîrî ka' poi. Eerepamî kupî sîrîrî,” taaya'nîkon mîrîrî era'maya'nîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ayenku'tîuya'nîkon pepîn. Tamî'nawîrî sîrîrîpe enen tîîko'mansenon sa'manta pepîn mîrîrî tauya manni' iipî rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ka' moropai non e'tî'ka, tîîse umaimu esuwa'ka pepîn. Ipatîkarî yairî pu'kuru aako'mamî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Î' yai moropai o'non poro wei tîîse uuipî inî'rî sîrîrî non pona esepu'tî pepîn. Ka' ponkon inserîyamî'ya epu'tî pepîn. Uurîya nîrî, epu'tî pra man. Uyunya neken tamî'nawîrî epu'tî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tîwarî panpî' ako'mantî. Î' pensa enna'po epu'tîya'nîkon pra naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","See warantî awanî pe man: Tiaron pata pona warayo' wîtî yai, tewî' tapai tîpoitîrîtonon pî' taiya, tewî' era'ma pî' to' ko'manto'pe. To' kaisarî to' esenyaka'mato' ton ekaremekîiya. Moropai tiaron pî' taiya: “Mana'ta po ako'mankî. Morî pe uyewî' era'makî” taiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Uurî wanî wîttî esa' warantî. Amîrî'nîkon wanî ipoitîrîtonon warantî. Î' pensa enna'posa' iipî epu'tîya'nîkon pra naatîi. Yai pra pata ewaronpansa' tanne uuipî. Yai pra anoinna yai, yai pra kariwana etun tanne, yai pra pata erenmapî tanne uuipî. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mîrîrî ye'nen tîwarî ako'mantî, erepamî namai unîmîkîya'nîkon pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Apî'nîkon tauya manni' ekaremekîuya nîrî tamî'nawîronkon pî': Enpen panpî' ako'mantî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kono' kaisarî Judeuyamî' eperepî'pî isa'moto' ton pîn trigo puusa' moropai carneiro pî' entamo'kai. Penane tîîko'manse Judeuyamî' entamo'kato'kon weiyu wanî'pî, itese' Páscoa. Mîrîrî yai teepîremasanon esanon eseurîma'pî Moisés nurî'tîya yenupato' pî' yenupatonkon yarakkîrî. —Ama' pe Jesus yapisî e'pai man iwîto'pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Tîîse entamo'kan yai arinîkon kore'ta si'ma yapisî eserîke pra man. Tamî'nawîronkon epere'sa' tanne yapisî ya, to' ekore'ma eserîke awanî upî'nîkon. Uurî'nîkon yarakkîrî to' epî eserîke awanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betânia po Jesus wanî'pî Simão yewî' ta. Manni' Simão paran pî' si'pî, itese' leprosia. Mîîkîrî yewî' ta Jesus wanî'pî tîwentamo'ka pî'. Moropai awentamo'ka tanne wîri' iipî'pî iipia. A'pusin enepî'pîiya, itese' nardo tî' konekasa' itense', itese' alabastro. Nardo ke isa'manta'san kî'panenan Judeuyamî'. Epe'ke pu'kuru awanî. Itense' pottî waikîtî'pî wîri'ya. Moropai mîrîrî nardo kamo'pîiya Jesus pu'pai pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mîrîrî pî' tiaronkon ekore'ma'pî. —Î' ton mîrîrî a'pusin kanpîtî mîîkîrîya î' pe pra rî? —ta'pî to'ya tonpakon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mîîkîrî wîri' pî' ta'pî to'ya: —Kane kane amîrî. Anna pia mîrîrî tîîsa'ya ya, anna e'repa'pî e'painon. Tiwin kono' warayo' esenyaka'mato' yepe' kaisaron, 300 denari kaisarî ye'ma'pî tiaronkonya e'painon. Mîrîrî tîrî'pî annaya e'painon tîwe'taruma'tîsanon pia teuren —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tîîse Jesusya ta'pî to' pî': —Tîwî mîîkîrî wîri' nîsi. Î' ton pe ipî' eekore'makon? Morî pe pu'kuru inkupî'pî wanî uurî ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wei kaisarî tîwe'taruma'tîsanon tîniru esanon pepîn wanî sîrîrî non po. Inkamoro anpîika'tîpai awanîkon ya, morî tîrîya'nîkon e'painon to' pia. Tîîse uurî, uutî kupî sîrîrî aapiapai'nîkon. Uutî tîpo, morî tîrîya'nîkon pepîn e'painon uupia. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ikupî tîuya eserîkan ku'sai'ya manni', isa'manta'pî karapaima yu'na'tî rawîrî. Mîrîrî warantî ukarapaimasai'ya mîrîrî uyu'na'tî to'ya rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","O'non pata uyekare eseta ya, sîrîrî non po, mîserî wîri' nîkupî'pî yekare eseta nîrî tamî'nawîronkonya inkupî'pî epu'to'pe. Ayenku'tîuya'nîkon pepîn —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mîrîrî tîpo inkamoro asakî'ne pu' pona tîîmo'tai'nîkon kore'tawon, itese' Judas Iscariotes, wîtî'pî teepîremasanon esanon pia. —Jesus anapi'pai awanîkon ya, apîika'tî tîuya'nîkon —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","—Inna, morî pe man —ta'pî to'ya. —Anna pîika'tîya ya tîniru ke aye'ma annaya —ta'pî to'ya. Mîrîrî ye'nen Judas esenumenka'pî kure'ne, o'non ye'ka pe inkamoro pîika'tîto' tîuya ton pî' Jesus yapi'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isa'moto' ton pîn trigo puusa' pî' to' entamo'kato' esippia'tî yai, páscoa pî' tîwanîkonpa carneiroyamî' tî'ka'pî to'ya. Mîrîrî yai Jesus nenupa'sanya ta'pî ipî': —O'non pata entamo'kanto' koneka annaya yu'se awanî? O'non pata páscoa pî' e'nî kupî sîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesusya asakî'ne tînenupa'san mo'ka'pî to' yarimapa kai'ma. —Cidade pona atîtî. Moro tuna mankanen warayo' eporîya'nîkon. Mîîkîrî wenairî matîtîi wîttî ta eerepamî pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wîttî ta eerepamîkon pe wîttî esa' meurîmatîi. “Uyenupanenkonya tîmaimu yarima pî' man aapia. Upata'se' ton yu'se wai, moro unenupa'san yarakkîrî entamo'kato'pe, páscoa pî' anna e'to'pe, taa pî' uyenupanenkon man,” makatîi —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Moropai upata'se'kon ton ekaremekîiya apî'nîkon, kure'nan sala, kawînan. Aasîrî eekonekasa' era'maya'nîkon. Tamî'nawîron î' rî yu'se awanîkon ya moro awanî aasîrî. Moro entamo'kanto' ton mîkonekatîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Moropai Jesus nenupa'san ese'ma'tî'pî. Cidade pona to' wîtî'pî. Taa Jesusya manni' warantî pu'kuru eporî'pî to'ya, tamî'nawîrî. Moro to' entamo'kato' ton koneka'pî to'ya páscoa pî' to' e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Moropai pata ewaronpamî pe, Jesus wîtî'pî to' pia tîîpia e'nîmî'san tînenupa'san yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Entamo'kanto' yaponse' pia tîwentamo'kakon pe Jesusya ta'pî to' pî': —Amîrî'nîkon kore'tawon tarîronya uyekaremekî kupî sîrîrî uyeyatonon pî'. Ayenku'tîuya'nîkon pepîn. Uyarakkîrî tîwentamo'kasenya ikupî kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mîrîrî pî' to' esewankono'ma'pî. —Uurîya ikupî pepîn, innape nai? —ta'pî to'ya ipî' tiwin pî' si'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Unenupa'san amîrî'nîkon, asakî'ne pu' pona'nîkon. Tîîse tiwin akore'tawonkon ayonpakonya uyekaremekî kupî sîrîrî. Uyarakkîrî awentamo'ka manni' tiwinan prato po, mîîkîrîya uyekaremekî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Uurî ka' poi iipî'pî aruinankon pe. Paapa maimu e'menukasa' manni' yawîrî, uusa'manta kupî sîrîrî. Tîîse aka sa'ne mîîkîrî uyekaremekîton. Pena isanya mîîkîrî tînre yenposa' pra awanî ya, morî pe panpî' awanî'pî e'painon. Eesenposa' pra awanî ya, awe'taruma'tî pepîn teuren. Tîîse kure'ne awe'taruma'tî kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tîwentamo'kakon pe Jesusya trigo puusa' yapisî'pî moropai eepîrema'pî. —Morî pu'kuru amîrî, Paapa. Anna yekkari ton tîrî pî' nai —ta'pîiya Paapa pî'. Mîrîrî tîpo ipîrikkapîtî'pîiya moropai itîrî'pîiya to' kaisarî. —Maa. Sîrîrî upun —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mîrîrî tîpo pisa yapisî'pîiya. —Morî pu'kuru amîrî, Paapa. Anna wuku ton tîrî pî' nai —ta'pîiya Paapa pî'. Mîrîrî tîpo itîrî'pîiya to' kaisarî. Tamî'nawîronkonya enîrî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesusya ta'pî to' pî': —Sîrîrî umînî. Umînî eti'kamo kupî sîrîrî arinîkon nîkupî'pî imakui'pî yepe' pe. Mîrîrî wenai Paapaya tamî'nawîron kupî e'painon apîika'tîto'peiya'nîkon ekareme'pîtîuya yawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","—Inî'rî uva yekku enîrîuya pepîn tamî'nawîronkon esa' pe tîwanî yenpo Paapaya pîkîrî. Mîrîrî yai amenan uva yekku enîrîuya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Moropai to' eserenka'pî Paapa yapurî pe. Mîrîrî tîpo to' epa'ka'pî. Oliveira kîrî pona to' wîtî'pî. To' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Moropai Jesusya ta'pî to' pî': —Eranne' pe awanîkon ye'nen urumakaya'nîkon kupî sîrîrî, tamî'nawîrî. Mîrîrî warantî awe'menukasa' Paapa kaaretarî pî'. Paapaya ta'pî: “Carneiroyamî' era'manen wîuya moropai carneiroyamî' e'tîrîka.” Mîrîrî warantî awe'menukasa'. Uwî to'ya kupî sîrîrî moropai amîrî'nîkon e'tîrîka. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tîîse uusa'manta tîpo, Paapaya u'mî'sa'ka. Mîrîrî tîpo Galiléia pata pona uutî arawîrî'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedroya ta'pî ipî': —Tamî'nawîronkonya arumaka ya, eranne' pe tîwanîkon ye'nen, uurîya arumaka pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusya ta'pî ipî': —Kaane, Pedro. Sîrîrî ewarono' ya' itakon ite'ka pe kariwana etun rawîrî amîrîya taa kupî sîrîrî, “Unepu'tî pepîn mîîkîrî Jesus”. Ayenku'tîuya pepîn, seurîwî'ne ite'ka mîrîrî taaya kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mîrîrî pî' Pedro eseurîma'pî meruntî ke. —Awî to'ya yai uurî nîrî wîî to'ya ya, mîîwîni tîîse “Unepu'tî pepîn Jesus,” tauya pepîn —ta'pîiya. Mîrîrî warantî nîrî ta'pî to'ya, tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Moropai Jesus yarakkîrî to' ewomî'pî Oliveira ye'kana' pî'. Oliveira ye'ka ese' Getsêmani. Moropai Jesusya ta'pî tînenupa'san pî': —Tarî ereutatî uyun Paapa yarakkîrî eseurîma tanne. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","To' yonpayamî' piapai Pedro, moropai Tiago, moropai João yarî'pîiya. Eranne' pe eena pia'tî'pî. Ipîra eesewankono'ma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Inkamoro pî' ta'pîiya: —Ipîra esewankono'man pî' wai. Esewankono'mato'ya uwî eserîke man. Maasa, tarî e'tî. Tîwarî e'tî. Pemonkon iipî era'matî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","To' piapai Jesus atarima'pî mararî. Eesenumî'pî non pona epîremai. Paapa pî' esatî'pîiya tîwe'taruma'tî namai. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Paapa —ta'pîiya. —Tamî'nawîron kupîya e'painon. Upîika'tîkî e'taruma'tî namai. Tîîse itu'se wanî yawîrî kî'kupîi. Itu'se awanî yawîrî neken iku'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Moropai inkamoro seurîwî'nankon pia awenna'po'pî. To' we'nasa' eporî'pîiya. To' kurantanîpî'pîiya. Pedro pî' ta'pîiya: —Awetun mîrîrî? Mararî tîwarî aako'mamî yentai awanî mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tîwarî ako'mantî. Paapa yarakkîrî eseurîmatî Makuiya ayenku'tîkon namai. Ayewankon ya Paapa maimu yawîrî iko'manpai awanîkon, tîîse ikupîya'nîkon eserîke pra awanîkon a'tu'mîra pu'kuru awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Moropai inî'rî to' piapai attî'pî Paapa yarakkîrî eseurîmai. E'mai' pe mîrîrî ta'pî tîuya manni' warantî eepîrema'pî inî'rî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","To' pia tîwenna'posa' pe, inî'rî to' we'nasa' eporî'pîiya. Mararî pra iwe'nunpai to' wanî'pî yapîtanî'pî to'ya yentai. To' yenpaka'pîiya inî'rî. To' eppe'sa' wanî'pî tîwe'nasa'kon pî'. Î' taa tîuya'nîkon epu'tî to'ya pra awanî'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iteseurîno ite'ka pe Jesus wîtî'pî to' piapai epîremai. Moropai inî'rî awenna'po'pî to' pia. —Sîrîrî tîpose awetunkon mîrîrî —ta'pîiya to' pî'. —Aasîrî man. Uurî ka' poi iipî'pî era'mai tiaron iipî. Sîrîrî pu'kuru utîrîiya kupî sîrîrî imakui'san warayo'kon pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","E'mî'sa'katî. Wîtîn sîrîrî. A'kî, imakui'san pia utîrîton warayo' yi'nî pî' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Moropai mîrîrî pe rî Jesus eseurîma tanne, tiwin inenupa'pî warayo' Judas erepamî'pî. Teepîremasanon esanon, Moisés nurî'tîya yenupanto' pî' yenupatonkon, moropai Judeuyamî' panamanenan a'yeke'tonon, inkamoro narima'san erepamî'pî Judas pokonpe. Arinîke to' wanî'pî. Tîkasuparaikon moropai tîtaikapukon ene'sa' to'ya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tîîse tuutîkon rawîrî Judasya taasa' wanî'pî tîpokon pe tuutîsanon pî': —Warayo' pî' esekaremekî moropai yu'nauya. Mîîkîrî anapisîkon ton. Mapi'tîi moropai tîwarî si'ma maatîi ayesanonkon pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Moropai teerepamî pe Judas wîtî'pî Jesus pia. —Aapia yi'nî pî' wai —ta'pîiya tepotorî pî'. Moropai Jesus yu'na'pîiya itenpata pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Moropai Judas pokonpe iipî'sanya Jesus yapisî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Moro awanî'pî warayo', Jesus nenupa'pî. Mîîkîrîya teepîremasanon esanon yepotorî poitîrî wîî yonpa'pî tîkasuparai ke. Tîîse ipuremekî'pîiya. Ipana neken ya'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","—Uyapi'se aai'sa'kon tiaronkonya ama'ye' yapisî warantî —ta'pî Jesusya to' pî'. —Akasuparaikon moropai ataikîpukon ene'sa'ya'nîkon mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wei kaisarî epîremanto' yewî' ta akore'ta'nîkon e'pîtî'pî tamî'nawîronkon yenupa pî'. Mîrîrî kupîuya tanne, uyapisî'pîya'nîkon wanî'pî e'painon. Tîîse ikupîya'nîkon pra awanî'pî. Tîîse Paapa maimu e'menukasa' manni' yawîrî eenasa' mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Moropai Jesus nenupa'sanya irumaka'pî. To' epe'pî, tamî'nawîrî iipiapai. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesus yarî'pî to'ya. Tiaron warayo', maasaron wîtî'pî to' pîkîrî. Kamisa tîîsai'ya wanî'pî ta'san pe. Mîîkîrî yapisî'pî inkamoroya ita'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tîîse mîîkîrîya tîpon rumaka'pî. Eeka'tumî'pî ipon pra. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Moropai Jesus yarî'pî to'ya teepîremasanon esanon yepotorî pia. Teepîremasanon esanon, Moisés nurî'tîya yenupanto' pî' yenupatonkon, Judeuyamî' panamanenan a'yeke'tonon, inkamoro epere'sa' wanî'pî moro. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aminke Jesus pî' Pedro iipî'pî ite'ma'pî pî' teepîremasanon esanon yepotorî yewî' poro yi'pîrî pîkîrî. Moro awe'nîmî'pî. Mororonkon surarayamî' pokonpe eereuta'pî. To' atapina'pî apo' pia. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Imakui'pî pe Jesus winîkîi teeseurîmasanon yuwa'pî teepîremasanon esanon moropai Judeuyamî' esanon tiaronkonya. Se' kaisarî asakî'nankon eseurîma yu'se to' wanî'pî imakui'pî inkupî'pî pî' mîrîrî wenai iwîkonpa kai'ma teuren. Tîîse mîrîrî warantî to' eseurîma pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Arinîkon eseurîma'pî ipî' seru' pe. Tîîse se' kaisarî asakî'nankon eseurîma pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tiaronkon e'mî'sa'ka'pî moropai seru' pe to' eseurîma'pî. —Jesus eseurîma'pî epîremanto' yewî' pî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—See warantî ta'pîiya: “Seeni' epîremanto' yewî' koneka'pî pemonkonyamî'ya. Tîîse yarankauya kupî sîrîrî. Moropai seurîwî'ne wei tîpo inî'rî ikonekauya. Wîttî koneka warantî awe'koneka pepîn manni' amenan”, ta'pî Jesusya —ta'pî to'ya. Mîrîrî warantî to' eseurîma'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mîrîrî ye'ka pe tîîse, se' kaisarî asakî'nankon eseurîma pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Teepîremasanon esanon yepotorî e'mî'sa'ka'pî. To' yarakkita attî'pî. Jesus pî' ta'pîiya: —Imakui'pî pe insanan warayo'kon eseurîman pî' man apî'. To' maimu yuukuya pepîn? ");
INSERT INTO mbcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tîîse yuukuiya pra Jesus wanî'pî. Moo awanî'pî. Inî'rî teepîremasanon esanon yepotorî eseurîma'pî: —Cristo amîrî, Paapa munmu, Paapa nîmenka'pî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Inna, Cristo uurî —ta'pî Jesusya. —Ka' poi iipî'pî uurî pemonkon pe. Paapa meruntî winî ereutasa' era'maya'nîkon kupî sîrîrî. Katupuru kore'ta uuipî era'maya'nîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mîrîrî eta tîuya pe, teepîremasanon esanon yepotorî ekore'ma'pî kure'ne. Mîrîrî ye'nen tîpon karaka'pîiya. —Inî'rî imakui'pî inkupî'pî yuwapai pra man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","—Imakui'pî pe eeseurîma Paapa winîkîi eta'nîkon man. O'non ye'ka pe epu'tî pî' naatî? Î' ye'ka pe iku'pai nai? —ta'pîiya. —Iwîpai man —ta'pî tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Moropai tiaronkonya tetakukon yenumî'pî ipona. Itenpata yettapurî tîuya'nîkon tîpo ipa'tîpîtî'pî to'ya. —Anî'ya apa'tî pî' nai? Epu'kî, Cristo pe awanî ya —ta'pî to'ya ipî'. Moropai surarayamî'ya ipa'tîpîtî'pî tenyakon ke. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mîrîrî tanne Pedro wanî'pî poro po. Teepîremasanon esanon yepotorî poitîrîpa' epa'ka'pî poro pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Apo' pia Pedro atapina era'ma'pîiya. Eesenumenka'pî ipî'. —Amîrî nîrî Jesus Nazarépon pokonpan —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Kaane —ta'pî Pedroya. —Unepu'tî pepîn mîîkîrî. Mîrîrî tîpo wîttî iwa'to' mana'ta pia attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mîrîrî poro tuutî pe, inî'rî mîîkîrî wîri'ya era'ma'pî. Mana'ta piawonkon pî' ta'pîiya: —Mîîkîrî Jesus pemonkono —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Iseruku —ta'pî Pedroya inî'rî. Aako'mamî'pî mararî moropai mororonkon warayo'konya ta'pî ipî': —Innape Jesus pemonkono pe awanî eserîke awanî. Galiléia pon mîîkîrî, amîrî nîrî Galiléia pon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mîrîrî pî' Pedroya ta'pî: —Unepu'tî pepîn mîîkîrî ipî' eeseurîmakon manni'. Useruku pepîn Paapaya uyera'ma pî' man. Seru' pe eseurîma ya Paapaya utaruma'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mîrîrî pe rî kariwana e'na'pî itakon ite'ka pe. Mîrîrî eta'pî Pedroya. Moropai awenpenata'pî Jesusya teurîma'pî pî'. “Itakon ite'ka pe kariwana etun rawîrî, unepu'tî pepîn mîîkîrî Jesus, taaya eseurîwî'ne ite'ka,” taasa' Jesusya pî' awenpenata'pî. Moropai tîkauware attî'pî, seru' pe tîwe'sa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pata erenmapî pe, teepîremasanon esanon, Moisés nurî'tîya yenupato' pî' yenupatonkon, Judeuyamî' panamanenan a'yeke'tonon, Judeuyamî' esanon tiaronkon, inkamoro eperepî'pî tamî'nawîrî î' kupî tîuya'nîkon pî' eseurîmai. Teeseurîmakon tîpo tîpoitîrîtononkon surarayamî' pî' ta'pî to'ya: —Jesus yaironpî'tî. Moropai yaatî pata esa' Governador Pilatos pia —ta'pî to'ya. Mîrîrî warantî ikupî'pî surarayamî'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatosya Jesus ekaranmapo'pî. —Tamî'nawîron esa', rei amîrî, Judeuyamî' esa'? —ta'pîiya Jesus pî'. —Amîrîya taa mîrîrî. —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Teepîremasanon esanon eseurîma'pî seru' pe ipî'. —Mararon pepîn imakui'pî ku'sai'ya mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatosya ta'pî: —To' maimu yuukuya pepîn? Mararon pepîn imakui'pî ku'sai'ya taa pî' to' man apî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tîîse inî' Jesus eseurîma pra awanî'pî. “Kaane, imakui'pî ku'sau'ya pra wai,” taiya pra awanî'pî. Mîrîrî pî' Pilatos esenumenka'pî kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatos yeseru wanî'pî Páscoa pî' Judeuyamî' wanî kaisarî tiwin pî' tînarakkamo'san rumakapîtîiya. Tînepu'tîkon esa'pîtî'pî Judeuyamî'ya. Inkamoro rumakapîtî'pîiya tiwin, tiwin kono' tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Atarakkannîto' ta warayo'kon wanî'pî imakui'pî kupîtîponkon. Tamî'nawîronkon esanon pî' teekore'makon yai to' poitîrîtonon wîîsa' to'ya wanî'pî. To' kore'ta warayo' wanî'pî itese' Barrabás. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Arinîkon wîtî'pî pata esa' Pilatos pia. Ipî' ta'pî to'ya: —Tiwin anarakkamo'pî anna yonpa rumakakî. Kono' kaisarî ikupîya manni' warantî irumakakî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—Anî' rumakauya yu'se awanîkon moriya? —ta'pî Pilatosya. —Mîserî Judeuyamî' esa' rei taaya'nîkon manni' ipî', mîserî rumakauya ka'rî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ipî' tîkinmukon ye'nen Jesus ene'sa' teepîremasanon esanonya wanî'pî epu'tî'pî Pilatosya. Mîrîrî ye'nen anrumakapai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tîîse teepîremasanon esanonya ta'pî tamî'nawîronkon pî': —Barrabás rumakaya yu'se anna man, ka'tî ipî' —ta'pî to'ya. Mîrîrî warantî ta'pî tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—Tîîse mîserî kanan, Judeuyamî' esa', rei taaya'nîkon manni' ipî', î' kupîuya yu'se awanîkon ipî'? —ta'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Iwî me'pokî —ta'pî to'ya. —Pakî'nan pona ipokapîtî me'pokî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Î' wenai anwîpai awanîkon mîrîrî? —ta'pî Pilatosya. —Î' see mîrîrî imakui'pî inkupî'pî? Tîîse aronne panpî' to' entaimepîtî'pî: —Pakî'nan pona ipokapîtî me'pokî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tamî'nawîronkon wakîri pe e'pai Pilatos wanî'pî. Mîrîrî ye'nen Barrabás rumaka me'po'pîiya. Jesus po'pîtî me'po'pîiya pemonkon po'pî'to' ke. Mîrîrî tîpo Jesus tîrî'pîiya surarayamî' pia pakî'nan po ipokapî'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Surarayamî'ya Jesus yarî'pî pata esa' Governador Pilatos yewî' ta. Governador yewî' ese' pretório. Tonpakon surarayamî' muurukuntî'pî to'ya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sonpan Jesus pon mo'ka'pî to'ya moropai suuyu sonpan rei pon ye'ka yeka'ma'pî to'ya ipon ton ipî' tîwo'ma'takon pe. Mî'nî kapî'pî to'ya itarako ton, rei yarakko warantî. Ipu'pai pona itîrî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tîwo'ma'takon pe ipî' to' esekaremekî'pî. —Viva Jesus. Judeuyamî' esa' amîrî. Rei amîrî —ta'pî to'ya. Itaruma'tî'pî to'ya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Moropai ipa'tîpîtî'pî to'ya ipu'pai pona yei ke. Tetakukon yenunpîtî'pî to'ya ipona. Tese'mukon pona to' enapîtî'pî ikaisarî yapurî pe, tîîse to' seruku mîrîrî. Ipî' to' o'ma'ta mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kure'ne ipî' tîwo'ma'takon tîpo, sonpan mo'ka'pî to'ya. Sonpan ipon tîrî'pî to'ya ipona. Mîrîrî tîpo yarî'pî to'ya pakî'nan pona ipokapî'se. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tuutîkon pe warayo' eporî'pî to'ya, keren poi tui'sen cidade poro tuutîsen, itese' Simão. Cirene pon mîîkîrî, Alexandre moropai Rufo yun. Mîîkîrî pî' ta'pî to'ya meruntî ke: —Ka'ne' pe panpî' aase sîrîrî pakî'nan yarîpa —ta'pî surarayamî'ya ipî'. Moropai yarî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesus yarî'pî to'ya Gólgota kîrî pona. Pemonkon pu'pai'pî warainon taato' mîrîrî Gólgota. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Moro iwuku ton tîrî'pî to'ya uva yekku yai'mesa' remédio itese' mirra yarakkîrî ˻ne'ne' epu'tîiya namai˼. Tîîse enîrîiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ineka'ta winîkîi wei tîîse ipokapîtî'pî to'ya pakî'nan pona. Tî'kon mîrikkî pî' to' su'mina'pî ipon rî'pî pantakapîtî tîuya'nîkon epu'tîkonpa kai'ma. Mîrîrî warantî ipantaka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","MÎSERÎ JUDEUYAMÎ' ESA', REI, kai'ma kaareta pona itekare menuka'pî to'ya. Moropai itîrî'pî to'ya pakî'nan yepoi tamî'nawîronkonya era'mato'pe. Mîrîrî kupî'pî to'ya î' wani' awanî ye'nen ipokapî'sa' tîuya'nîkon epu'to'pe tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Moropai asakî'ne ama'ye'kon pokapîtî'pî to'ya ipokonpe. Tiwin ipokapîtî'pî to'ya tiaron pakî'nan po, Jesus meruntî winî moropai tiwin ipokapîtî'pî to'ya kamai' winî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mîrîrî warantî pena Paapa maimu e'menukasa' yawîrî ikupî'pî to'ya. Pena Isaías nurî'tîya ta'pî: Mîîkîrî taruma'tî to'ya imakui'san taruma'tî to'ya warantî ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","E'ma taawîrî tuutîsanon o'ma'ta'pî ipî'. —Kane kane amîrî. “Epîremanto' yewî' yarankauya. Inî' ikonekauya. Seurîwî'ne wei tîpo ikoneka aretî'kauya,” ta'pîya seru' pe. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mîrîrî kupîpa kai'ma, meruntî ke awanî ya, aawarîrî e'pîika'tîkî. Autîkî pakî'nan poi —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Teepîremasanon esanon o'ma'ta'pî nîrî ipî', Moisés nurî'tîya yenupato' pî' yenupatonkon pokonpe si'ma. —Tiaronkon pîika'tî'pîiya. Tîîse aawarîrî awe'pîika'tî pra awanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jesus pî' ta'pî to'ya: —Paapa nîmenka'pî pe awanî ya, autîkî pakî'nan poi. Awautî era'ma annaya ya, yai pra innape Israel nurî'tî paa rî'san esa' pe awanî kupî annaya e'painon —ta'pî to'ya. Insanan ipokonpe to' nîpokapîtî'san pakî'nan pona o'ma'ta'pî nîrî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ineka'ta pairî wei tîîse pata ewaronpamî'pî. Ewaron pe aako'mamî'pî wei autî tîpose. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wei autîsa' tanne Jesus entaime'pî aronne. —Eloi, Eloi, lamá sabactâni —ta'pîiya tîmaimu ta. —Paapa, Paapa, î' wani' awanî ye'nen urumakaya sîrîrî? —taato' mîrîrî umaimukon ta. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tiaronkon ipî' teesenumenkakon ye'ka pe mîrîrî taiya eta'pî yairî pra. Elias, Elias, taiya kai'ma to' esenku'tî'pî. Moropai ta'pî to'ya: —A'kî. Elias nurî'tî yannoiya etatî maasa —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tiaron eka'tumî'pî tuna yu'nanen esponja era'mai. Mîrîrî tîrî'pîiya so'ri uva yekku ka' yu'nato'peiya. Mîrîrî tîpo yei yaretî pî' yasi'tî'pîiya. Inta pona irennuku'pîiya yu'nato'peiya kai'ma. Mîrîrî tîpo ta'pîiya: —Maasa, pakî'nan poi imo'kai Elias nurî'tî iipî era'mapai'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Meruntî ke Jesus entaime'pî. Moropai aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Surarayamî' yepotorî wanî'pî moro Jesus era'ma pî'. Mîrîrî warantî aasa'manta era'ma tîuya pe, —Innape Paapa munmu pe mîserî man —ta'pîiya. Mîrîrî tanne epîremanto' yewî' tawon Paapa pata'se' yuwa'to' kamisa e'karaka'pî ineka'ta poi mai winîkîi. Kure'nan soren pe tîwe'sen pe awanî'pî. Ere'sin pe nîrî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wîri'sanyamî' wanî'pî moro nîrî Jesus era'ma pî' aminke si'ma. Moro to' wanî'pî Maria Madalena, Salomé, moropai tiaron Maria, José moropai Tiago maasaron panpî' yan mîîkîrî Maria. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galiléia pata po Jesus asarî yai, inkamoro wîri'sanyamî' wanî'pî ipîkîrî asarî'san pe. Itekkari ton koneka tîpokon pe. Tiaronkon wîri'sanyamî' wanî'pî moro nîrî, Jesus wenairî iipî'san Jerusalém pona. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sábado wanî'pî Judeuyamî' erî'ka'to' weiyu pe. To' yeseru wanî'pî to' ekoneka sexta feira yai sábado yai teerî'kapîkonpa. To' ekonekato' weiyu yai Jesus sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mîrîrî ye'nen José Arimatéia pon wîtî'pî Pilatos pia. José wanî'pî Judeuyamî' panamanen pe. Tamî'nawîronkon esa' pe Paapa iipî nîmîkî pî' tîwe'sen pe awanî'pî nîrî. Eranne' pe pra attî'pî Pilatos pia, pata ewaronpamî tanne. Eerepamî'pî. Pilatos pî' ta'pîiya: —Jesus esa'rî'pî anmo'kapai wai pakî'nan poi yu'na'tîto'peuya. Sábado yai pakî'nan po aako'mamî yu'se pra anna man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","—Aasîrî aasa'mantasa' mîrîrî? —ta'pî Pilatosya. Imu'tunpa'pîiya. Surarayamî' esa' yanno me'po'pîiya. Aaipî'pî. —Aasîrî Jesus sa'mantasa' mîrîrî? —ta'pî Pilatosya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Inna, aasîrî aasa'mantasa' man —ta'pî surarayamî' esa'ya. —Moriya itesa'rî'pî mo'kata —ta'pî Pilatosya José pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mîrîrî tîpo Joséya kure'nan kamisa yenna'pî. Attî'pî tiaronkon yarakkîrî Jesus esa'rî'pî mo'kai. Imoka'pî to'ya. Moropai iwontî'pî to'ya mîrîrî kamisa ke. Ikîrî yai a'ta yakasa' Joséya wanî'pî isa'manta'san yense' ton pe. Kure'ne awanî'pî. Mîrîrî ya' Jesus esa'rî'pî wonnîpî'pî to'ya Judeuyamî' yeseru yawîrî. Moropai a'ta yettapurî'pî to'ya kure'nan tî' ke. ");
INSERT INTO mbcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tamî'nawîrî mîrîrî kupî to'ya era'ma'pî Maria Madalenaya moropai tiaron Mariaya, José yan Mariaya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado esuwa'kasa' tîpo inkamoro wîri'sanyamî' wîtî'pî Salomé pokonpe a'pusin yennai Jesus esa'rî'pî karapaimato' ton, Judeuyamî' yeseru yawîrî ikupîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","E'mai'non wei erenmapî pe, domingo yai to' wîtî'pî a'ta pia itesa'rî'pî karapaimai. Penane marî pu'kuru to' ese'ma'tî'pî wei epa'kasa' tanne. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tuutîkon pe to' eseurîma'pî. —Anî'ya a'ta yettapuru tî' mo'ka ewonnîto'pe? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mîrîrî ta'pî to'ya kure'ne tî' e'sa' ye'nen. Moropai teerepamîkon pe a'ta esettapurukasa' era'ma'pî to'ya. itettapuru era'tîsa' era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","A'ta ya' to' ewomî'pî. Moro warayo' ereutasa' eporî'pî to'ya meruntî winî. Aimutun pe ipon wanî'pî sonpan. ˻Inserî pe awanî'pî.˼ Mîîkîrî pî' to' esi'nîpî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mîîkîrîya ta'pî to' pî': —Teesi'nî'se pra e'tî. To' nîpokapîtî'pî pakî'nan pona yuwaya'nîkon mîrîrî. Jesus Nazarépon yuwaya'nîkon. Tîîse tarî Jesus ton pra man. Awe'mî'sa'ka'pî man. A'kî, ipata'pî era'matî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","—Galiléia pona wîtîn pî' man arawîrî'nîkon. Miarî era'maya'nîkon kupî sîrîrî apî'nîkon ta'pî tîuya manni' yawîrî. Mîrîrî ekareme'tantî Pedro moropai tiaronkon inenupa'san pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","To' epa'ka'pî. To' esi'nî'sa' wanî'pî î' taa yentai. To' e'tîtîtîkka'pî. A'ta piapai to' eka'tumî'pî. Tuutîkon pe anî' yarakkîrî to' eseurîma pra awanî'pî, teesi'nî'sa'kon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo yai Jesus e'mî'sa'ka'pî mîrîrî penane marî pu'kuru. Maria Madalenaya Jesus e'mî'sa'kasa' era'ma'pî domingo yai, penane marî pu'kuru, tiaronkonya era'ma rawîrî. Mîîkîrî Maria Madalena pena o'ma'kon ewonsa' wanî'pî ya', asakî'ne mia' pona tîîmo'tai kaisarî. Inkamoro tîrîka'pî Jesusya. Mîîkîrîya Jesus era'ma'pî tiaronkonya era'ma rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Inenupa'san esewankono'masa' karau tanne, to' pia Maria Madalena erepamî'pî. —Jesus e'mî'sa'kasa' man —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Enen awanî sîrîrî. Uyenu ke era'ma pî' wai —ta'pîiya. Tîîse innape imaimu kupî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mîrîrî tîpo asakî'nankon inenupa'sanya Jesus era'ma'pî cidade poi tuutîkon pe. Tiaron pe eetinyaka'masa' ye'nen, ka'ne' pe epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tepu'tî to'ya emapu'tîsai'ya tîpo, to' enna'po'pî tonpakon pia ekareme'se. Tîîse innape to' maimu kupî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mîrîrî tîpo Jesus era'ma'pî inenupa'sanya, tiwin pu' pona tîîmo'tai'nîkonya. Tîwentamo'kakon yai era'ma'pî to'ya. Jesusya to' panama'pî. —Uyewankono'ma pî' naatîi —ta'pîiya to' pî'. —Î' ton pe see innape e'mî'sa'kasa' kupîya'nîkon pra awanîkon? E'mî'sa'ka tîpo akore'tawonkonya uyera'ma'pî enen. Mîîwîni tîîse innape ikupîya'nîkon pra awanî'pîkon. Innape anku'pai pra awanîkon mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—Pata kaisarî matîtîi. Tamî'nawîronkon pî' Paapa yekare mekareme'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tiaronkonya innape Paapa yekare kupî ya moropai to' yenpatakonaya'nîkon e'pai man. Mîrîrî warantî inkamoro e'pîika'tî. Tîîse tiaronkonya innape Paapa yekare kupî pepîn. Mîrîrî ye'nen inkamoro ye'ka yarima Paapaya apo' ya' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Innape tîku'nenan kupî Paapaya meruntî ke ikupî eserîkan pepîn ku'to'pe to'ya. Mîrîrî kupî Paapaya innape itekare wanî epu'to'pe tamî'nawîronkonya. Umeruntîri ke o'ma'kon tîrîka to'ya. Tiaron to' nepu'tî pepîn tîrîuya to' maimu ton. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","˻Tînepu'tîkon pe pra˼ sokoro'pan îkîi yanunsa' to'ya ya, to' yeparantîiya pepîn. ˻Tînepu'tîkon pe pra˼ tîmai'pato'kon enîrî tîuya'nîkon ya to' emai'pa pepîn. Pri'yawonkon pepîn pona to' epîrema. To' yepi'tî Paapaya. Mîrîrî warantî innape Paapa ku'nenan wanî kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","To' yarakkîrî teeseurîma tîpo, Jesus wîtî'pî ka' pona. Paapaya yarî'pî tîîpia enen tîîse. Paapa meruntîri winî eereuta'pî, ikaisarî tamî'nawîronkon esa' pe tîwanîpa. ");
INSERT INTO mbcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Inenupa'san wîtî'pî pata kaisarî itekare ekareme'se. Uyepotorîkon Jesusya to' pîika'tî'pî. Meruntî ke to' kupî'pîiya ikupî eserîkan pepîn ku'to'pe to'ya. Mîrîrî era'ma tîuya'nîkon wenai arinîkonya to' maimu kupî'pî innape.");
INSERT INTO mbcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Uyonpa Teófilo, tu'kankon pemonkonyamî'ya sîrîrî Jesus yekare menuka'pî ukore'ta'nîkon e'kupî'pî ekareme'nen pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesusya to' yenupa pia'tî'pî pata pai tamî'nawîrî inkupî'pî era'matîponkon winîpai eta'pî uurî'nîkonya, maasa pra mîrîrî itekare ekareme'pîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mîrîrî ye'nen mîrîrî pî' esenupa'pî tamî'nawîrî morî pe epu'to'peuya kai'ma. Eesippia'tî'pî pata pai sîrîrî tîpo see î' e'kupî'pî pî' esenupa'pî. Moropai esenumenka'pî tamî'nawîrî morî pe imenukauya pî', amîrîya epu'tîto'pe. Mîrîrî ye'nen Teófilo, uwanîyakon, aapia imenukauya sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yairî eesenupa'pî wanî epu'tîpa kai'ma imenukauya sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pena Judéia pata esa' pe tîwe'sen pe Herodes wanî yai, teepîremasen wanî'pî itese' Zacarias. Mîîkîrî wanî'pî teepîremasanon Abias ponkon yonpa pe. Mîîkîrî no'pî wanî'pî itese' Isabel. Mîîkîrî nîrî wanî'pî teepîremasen yonpa pe. Arão nurî'tî, teepîremasanon yepotorî, parî'pî pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mîîkîrî ko'manpîtî'pî tîno'pî yarakkîrî morî pe, imakui'pî ton pra. Paapa rawîrî yairî to' ko'manto' wanî'pî. Tamî'nawîrî inekaremekî'pî yawîrî ikupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tîîse mîîkîrî wanî'pî inmu ton pra. Maasa pra ino'pî wanî'pî more yenponen pe pra. Moropai a'yeke'ton pe inyo wanî'pî. Ino'pî wanî'pî no'santon pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Tiwin wei teepîremasen Zacarias pokonpankon esenyaka'ma yai epîremanto' yewî' ta, mîîkîrî Zacarias menka'pî to'ya eewonto'pe a'pusin po'tîi Paapa yapurî pe. Mîîkîrî menka'pî to'ya teserukon yawîrî, tî' yenumî pî'. Mîrîrî tî' ena'pî Zacarias pia. Mîrîrî ye'nen a'pusin po'tîto' weiyu eseporî yai Zacarias ewomî'pî epîremanto' yewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mîrîrî a'pusin aramî tanne, poro po Paapa yapurîi eperepî'san pemonkonyamî' epîrema'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mîrîrî yai Uyepotorîkon narima'pî inserî esenpo'pî Zacarias pia. Inpo'tî yaponse' winî, meruntî winîkîi satippe, o'non pata a'pusin aramî manni' pata'se' ya' eesenpo'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mîîkîrî era'ma tîuya pe, eesi'nîpî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tîîse mîîkîrî pî' ta'pî inserîya: —Eranne' pe pra e'kî, Zacarias! Paapaya eepîremato' etasa' man, moropai amaimu yuukuiya pe man —ta'pîiya. —Ano'pîya tînre yenpo pe man, warayo' pe. Mîîkîrî more ese'tîya e'pai man João kai'ma —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Mîîkîrî esenposa' pî' aatausinpa kure'ne. Moropai tu'kankon pemonkonyamî' ena taatausinpai, mîîkîrî esenposa' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Maasa pra kure'ne mîîkîrî warayo' wanî pe man Paapa pia. Mîîkîrîya mai' enîrî e'pai pra awanî. Tîîse eesenpo pata pai Morî Yekaton Wannî ko'mamî yarakkîrî itesa' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mîrîrî ye'nen mîîkîrîya tu'ke Judeuyamî' enpenata emapu'tî kupî, Paapa tepotorîkon epu'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mîîkîrî wanî pe man meruntî ke, moropai Morî Yekaton Wannî naipontîton pe, penaro' Paapa maimu ekareme'nen Elias nurî'tî wanî'pî warantî. Mîîkîrîya morî pe pemonkonyamî' ena emapu'tî kupî sîrîrî, tîyunkon moropai tînmukukon pokonpe. Mîrîrî warantî Paapa maimu yawîrî pra tîwe'sanon enna'po emapu'tîiya kupî sîrîrî yairî to' e'to'pe Paapa rawîrî. Mîrîrî warantî pemonkonyamî' Judeuyamî' ena yairî emapu'tîiya kupî sîrîrî Uyepotorîkon erepamî yaino ton pe —ta'pî inserîya Zacarias pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mîrîrî ye'nen Zacariasya inserî ekaranmapo'pî. Ta'pîiya: —O'non ye'ka pe see innape sîrîrî kupîuya e'painon? Maasa pra uurî wanî a'yeke'ton pe sa'ne, moropai uno'pî sa'ne wanî no'santon pe nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Moropai mîîkîrî inserîya Zacarias maimu yuuku'pî: —Tîîse uurî Gabriel, Paapa poitîrî, iipia tîîko'mansen. Mîîkîrî Paapaya uyarimasa' sîrîrî ayarakkîrî eseurîmai sîrîrî morî yekare pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","—Innape î' tauya manni' kupîya pra awanî mîrîrî. Tîîse awe'kupî kupî sîrîrî, mîrîrî weiyu eseporî ya. Innape iku'sa'ya pra awanî ye'nen, imaimu pra eena kupî sîrîrî, mîîkîrî anmu esenpoto' weiyu eseporî pîkîrî —ta'pî inserîya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mîrîrî tanne pemonkonyamî'ya Zacarias nîmîkî'pî poro po. Î' wani' awanî ye'nen aako'mamî epîremanto' yewî' ta epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Epîremanto' yewî' tapai teepa'ka pe, eeseurîma pra awanî'pî. Mîrîrî ye'nen epu'tî yonpa'pî to'ya î' rî e'ku'sa' epîremanto' yewî' ta, maasa pra eeseurîma pra awanî'pî. Tîîse tenya ke taapîtî'pîiya. Mîrîrî wenai epu'tî'pî to'ya we'ne'pî'nîto' warainon e'ku'sa' yarakkîrî. (Paapa nenpoto' era'ma'pîiya.) ");
INSERT INTO mbcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Moropai teesenyaka'mato' aretî'kasa' Zacariasya tîpo epîremanto' yewî' tapai awenna'po'pî tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mîrîrî tîpo mararî tîîko'mamî tîpo ino'pî Isabel ena'pî more yan pe. Mîîkîrî asarî pra awanî'pî mia'taikin kapoi kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Moropai Isabelya ta'pî: —Uyepotorîkonya upîika'tî tu'ka pî' man. Mîrîrî ye'nen anî'ya umu'tunpa eserîke pra awanî inî'rî. “Tînre yenponen pepîn mîserî,” taa to'ya pepîn tarîpai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tiwin mia' pona tîîmo'tai kapoi kaisarî more yan pe Isabel tîîse, Paapaya inserî Gabriel yarima'pî Nazaré cidaderî pona Galiléia pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Miarî inserîya itekare yarî'pî maasaron wîri' pia, warayo' yarakkîrî si'pî pepîn. Mîîkîrî niyotasen warayo' itese' José yarakkîrî. Mîîkîrî warayo' wanî'pî penaron rei Davi nurî'tî parî'pî pe. Mîîkîrî wîri' wanî'pî itese' Maria. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mîrîrîya Maria pia mîîkîrî inserî erepamî'pî. Moropai ta'pîiya: —Morî pe ko'mannî pî' nan, Maria? Taatausinpai e'kî. Maasa pra tîwakîri pe Paapaya akupî pî' man. Mîîkîrî Uyepotorîkon ko'mamî aapia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mîrîrî ye'nen î' taa tîuya epu'tîiya pra Maria wanî'pî mîrîrî î' ta'pî inserîya pî'. Teesewankono'mai eesenumenka'pî î' taa yu'se inserî wanî epu'tî yu'se. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tîîse inserîya ta'pî: —Eranne' pe pra e'kî, Maria. Maasa pra Paapa atausinpasa' man kure'ne amîrî pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","—Mîrîrî ye'nen more yan pe eena pe nai. Anre ton yenpoya pe nai warayo' pe. Moropai Mîîkîrî esatîya pe nai Jesus pe itese'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mîîkîrî wanî pe man kure'ne. Mîîkîrî esatî Paapa tamî'nawîronkon yentainonya tînmu pe. Mîîkîrî Paapaya ikupî kupî sîrîrî tamî'nawîronkon esa' pe pata esa' itamo Davi nurî'tî pata'pî ya' taasa' tîuya yawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","—Mîîkîrî ko'mamî tamî'nawîronkon Jacó payanî'san esa' pe ipatîkarî aataretî'ka ton pe pra —ta'pî inserîya Maria pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mîrîrî pî' ta'pî Mariaya inserî pî': —Î' kai'ma see mîrîrî wanî mîrîrî warayo' yarakkîrî pra uurî tîîse? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tîîse inserîya imaimu yuuku'pî. Ta'pîiya: —Morî Yekaton Wannî iipî pe man aapia. Moropai Paapa tamî'nawîron yentainon meruntîri wanî pe man aapia —ta'pîiya ipî'. —Mîrîrî wenai mîîkîrî more, imakui'pî ton pîn teesenposen wanî pe man Paapa munmu pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Enpenatakî maasa ayonpa Isabel pî'. Pena taapîtî'pî to'ya tînre ton yenponen pepîn, taapîtî'pî to'ya ipî'. Tîîse sîrîrî more yan pe eenasa' man. Tiwin mia' pona tîîmo'tai kapoi kaisarî ikapoi wanî, no'santon pe tîîse —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","—Maasa pra Paapa pia sa'man ton pra man. Î' inkupî pepîn ton pra man Paapa pia. Tamî'nawîrî ikonekaiya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mîîkîrî maimu yuuku'pî Mariaya: —Uurî wanî Paapa poitîrîpa' pe. Mîrîrî ye'nen î' rî e'kupî ya uyarakkîrî, Uyepotorîya ta'pî yawîrî, î' taaya manni' î' wani' pra man —ta'pîiya. Mîrîrî tîpo inserî wîtî'pî iipiapai. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mîrîrî tîpo Maria ekoneka'pî wî' pona tuutîpa, Judéia pata pona tonpa Isabel pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Miarî teerepansa' pe Zacarias yewî' ta eewomî'pî. Moropai ino'pî Isabel yarakkîrî to' atapisî'pî tîwakîri pe pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria maimu eta Isabelya pe more iro'ta ya' tîwe'sen eraikka'pî taatausinpai. Mîrîrî yai itesa' pe Morî Yekaton Wannî iipî'pî, imeruntîri ton tîrî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Moropai Isabel eseurîma'pî meruntî ke. Ta'pîiya: —Morî pe amîrî yapurî'pî Paapaya tamî'nawîronkon wîri'sanyamî' yapurî tîuya yentai. Moropai mîîkîrî more yenpoya kupî manni' nîrî yapurî Paapaya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","—Anî' kin uurî Uyepotorî yan ii'to'pe uyera'mapî'se, ipîkku pe pra sa'ne wanî tanne. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uupia eerepamî pe, uyarakkîrî eeseurîma yai, uro'ta yawon unre eraikkan pî' man kure'ne, taatausinpai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","—Amîrîya morî yapisî kupî taatausinpai, maasa pra innape î' e'kupî ta'pî Paapaya kupîya ye'nen —ta'pî Isabelya Maria pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Moropai Mariaya ta'pî Paapa yapurî tîuya pe: —Uyewan wanî kure'ne taatausinpai Uyepotorî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Moropai uyekaton atausinpasa' kure'ne mîîkîrî upîika'tînen Paapa pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Maasa pra uurî sa'ne tîpoitîrîpa' pî' awenpenatasa' ye'nen. Tarîpai sîrîrî patapai tamî'nawîronkon pemonkonyamî'ya taa upî': “Mîîkîrî Maria yapurî'pî Paapaya” taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mîrîrî warantî taa to'ya maasa pra mîîkîrî meruntî Paapaya kure'ne î' ku'sa' uurî ton pe. Mîîkîrî Paapa wanî morî pe pu'kuru imakui'pî ton pra, tamî'nawîronkon yentai. Maasa pra itese' taato' wanî teken morî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mîîkîrî Paapa wanî tamî'nawîronkon pemonkonyamî' i'noko'manen pe, manni'kan innape tînamanenan i'noko'maiya. Moropai manni'kan penaronkon tamokon moropai to' payanî'san nîrî i'noko'maiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Moropai tîmeruntîri ke manni'kan pemonkonyamî' mîîpankon esenumenkato' imakui'pî tîwe'sen yaretî'ka'pîiya tiwinarî, tiaronkon ma're to' kupî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Moropai ipîkkukon reiyamî' e'to' ipîkku pe yaretî'ka'pîiya. Ipîkku pe pra to' ena'pî. Tîîse manni'kan morîkon mîîpankon pepîn pîika'tî'pîiya, tiaronkon esa' pe to' e'to'pe, ipîkku pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Moropai ita're' pînon sa'ne ya're' ton tîrî'pîiya emi'ne to' wanî namai. Tîîse ipîkku pe tîwe'sanon pia î' tîrîiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mîîkîrî Paapaya pena î' ta'pî tîuya yawîrî ikupî'pî penaronkon pokonpe. Moropai tîpemonkonoyamî', Israel ponkon pîika'tî'pîiya to' pîika'tîuya taasa' tîuya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Penaron Abraão nurî'tî pî' awenpenata'pî. Morî kupî'pîiya Abraão ton pe. Moropai tamî'nawîronkon ipayanî'san ton ikupîiya ipatîkarî —ta'pî Mariaya, Paapa yapurî ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mîrîrî tîpo Maria ko'mamî'pî eseurîwî'ne kapoi tonpa Isabel yarakkîrî. Moropai awenna'po'pî tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Moropai Isabelya tînre yenpoto' weiyu eseporî'pî. Tînre yenpo'pîiya warayo' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mîrîrî pî' to' atausinpa'pî. Moropai itonpayamî' moropai iwoi tîîko'mansenon atausinpa'pî nîrî ipokonpe. Maasa pra morî pe Uyepotorîkon e'to' era'ma'pî to'ya Isabel yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mîrîrî tîpo tiwin semana tîîko'mamî tîpo more yarî'pî to'ya imere pi'pî pottî ya'tîi teserukon yawîrî. Mîrîrî yai mîîkîrî ese' ton antîîpai to' wanî'pî itun ese' ya Zacarias kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tîîse isanya ta'pî: —Kaane, itese' wanî pe man João kai'ma —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tîîse ta'pî itonpayamî'ya ipî': —Tîîse ayonpa ton pra man mîrîrî ye'ka itese' —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mîrîrî yai iyun ekaranmapo'pî to'ya, era'mato'peiya ikupî'pî to'ya, mîîkîrî more ese' ton kupî ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mîrîrî taa to'ya ye'nen, Zacariasya tabua esatî'pî ipona imenukapa kai'ma. Mîîkîrîya itese' ton menuka'pî João kai'ma. Mîrîrî pî' tamî'nawîronkon esenumenkasa' wanî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mîrîrî pe rî Zacarias eseurîma pia'tî'pî Paapa yapurî ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mîrîrî etasa' tîuya'nîkon yai, eranne' pe inkamoro iwoi tîîko'mansenon wanî'pî. Moropai mîrîrî yekare eta'pî tamî'nawîrî Judéia pata poronkonya, wî' poronkon tîîko'mansenonkonya. Moropai mîrîrî pî' to' eseurîmapîtî ko'mannîpî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tamî'nawîronkon etatîpono'san esenumenka'pî mîrîrî pî'. Ekaranmapo'pî to'ya: —Anî' pe see mîserî more wanî kupî sîrîrî? —ta'pî to'ya. Mîrîrî warantî to' eseurîma'pî maasa pra Uyepotorîkon meruntîri wanî ye'nen mîîkîrî yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarias esa' pe Morî Yekaton Wannî iipî'pî. Mîrîrî ye'nen eeseurîma pia'tî'pî î' awe'kupî ton pî'. Ta'pîiya: ");
INSERT INTO mbcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Uyepotorîkon Paapa yapurîpai'nîkon maasa pra tîpemonkonoyamî' Judeuyamî' ko'mannîpî'pîiya. Moropai mîîkîrîya to' pîika'tî'pî, to' e'taruma'tîto' yapai to' mo'ka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Paapaya upîika'tînenkon ton esenpo emapu'tî'pî tîpoitîrî Davi nurî'tî paarî'pî yai. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Pena pata pai Paapa eseurîma'pî sîrîrî pî' penaronkon tîmaimu ekareme'nenan profetayamî' winîpai. Sîrîrî pî' to' eseurîma'pî pena.) ");
INSERT INTO mbcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mîîkîrî Paapaya upîika'tîkon tîuya ta'pî uyeyatonkon winîpai. Moropai tamî'nawîronkon manni'kan uurî'nîkon pî' tîwo'ma'tasanon winîpai upîika'tîiya'nîkon ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tî'noko'pî pe utamokon nurî'san era'ma tîuya ta'pîiya. Moropai tîpemonkonoyamî' yarakkîrî teesetato' pî' tîwenpenatai pra mîîkîrî wanî pîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","“Ayeyatonkon winîpai apîika'tî tîuya'nîkon tîîwanmîra uyapurîkonpa umaimu yawîrî, eranne' pe pra” ta'pîiya utamokon Abraão nurî'tî pî'. Mîrîrî tîmaimu tîrî'pîiya tînena'poka tonpe pra tînkupî tonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mîrîrî kupîiya, morî pe pu'kuru, imakui'pî ton pra e'nîto'pe'nîkon kai'ma iipia. Imakui'pî kupî pî' ko'mannî namai sa'mantan pîkîrî —ta'pî Zacariasya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Amîrî unmu, tamî'nawîronkon yentainon Paapa maimu ekareme'nen pe awanî kupî sîrîrî, uyepotorîkon iipî yekare ekaremekîya pe nai. Uyepotorîkon iipî rawîrî e'ma konekaya, Uyepotorîkon ye'marî ton. Tamî'nawîrî konekaya morî pe Uyepotorîkon erepanto'pe ");
INSERT INTO mbcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Maasa pra itekare ekaremekîya pe nai pemonkonyamî' pî', e'pîika'tînto' yekare. Mîrîrî itekare wenai imakui'pî pe tîwe'to'kon rumaka to'ya kupî sîrîrî. Moropai mîrîrî kupî Paapaya tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Maasa pra Paapa wanî Uyepotorîkon pe pu'kuru uurî'nîkon i'noko'manen pe. Erenmapî ya, wei epa'ka warantî, mîîkîrîya upîika'tînenkon ton yarima pe man uupia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mîîkîrî narimaya ewaron ta tîîko'mansenon pemonkonyamî' weiyu'ma. Inkamoro pîika'tîiya to' sa'mantato' winîpai. Moropai morî tîrîiya uurî'nîkon pia, morî pe asanîto'pe tîîwanmîra, teesewankono'mai pra —ta'pî Zacariasya. ");
INSERT INTO mbcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mîrîrî tîpo mîîkîrî Zacarias munmu arenta'pî. Kure'ne aarenta'pî. Moropai meruntî ke itewan ena'pî, itesa' pe Morî Yekaton Wannî wanî ye'nen. Moropai aako'manpîtî'pî keren po. Israel ponkon pî' teesenpo pîkîrî aako'mamî'pî keren po. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mîrîrî yai reiyamî' esa' tîwe'sen Augustoya tamî'nawîronkonya tese'kon menuka me'po'pî. Maasa pra tamî'nawîronkon tîîko'mansenon anepu'pai awanî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mîrîrî wanî'pî e'mai'non tese'kon menukato' to'ya. Mîrîrî yai Quirino wanî Síria pata ko'mannî'nen pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mîrîrî ye'nen tamî'nawîronkon enna'po'pî tîpata'se'kon teesenpo'pîkon ya' tese'kon menukai. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mîrîrî warantî José wîtî'pî Galiléia pata pon Nazaré poi Judéia pata pon Belém pona, Davi nurî'tî esenpo'pî ya'. Miarî ya José wîtî'pî maasa pra Davi paarî'pî pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Attî'pî tawasirî Maria yarakkîrî tese'kon menukai. Mîîkîrî Maria wanî'pî more yan pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mîrîrî yai mîîkîrî Mariaya tînre yenpoto' weiyu eseporî'pî miarî Belém po. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mîîkîrîya e'mai'non tînre yenpo'pî warayo' pe. Mîîkîrî more ya'santî'pîiya moropai itîrî'pîiya paakayamî' ya're' yense' ya'. Maasa pra paakayamî' yewî' ta to' wanî'pî to' pata'se' ton pra awanî'pî wîttî ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Miarî mîrîrî pata po tekînkon carneiroyamî' era'manenan wanî'pî. Keren po si'ma tekînkon ko'mannîpî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mîrîrî tanne, Uyepotorîkon narima'pî inserî esenpo'pî to' pia. Moropai Uyepotorîkon ya'karuya inkamoro weiyu'ma'pî. Mîrîrî pî' to' esi'nîpî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tîîse inserîya ta'pî to' pî': —Eranne' pe pra e'tî. Kesi'nî'tî. Maasa pra morî itekare ekareme'se yi'nî pî' wai kure'ne aatausinpakonpa. Amîrî'nîkon moropai tamî'nawîronkon pemonkonyamî' atausinpato'pe itekare ekaremekîuya sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Maasa pra sîrîrîpe Davi nurî'tî esenpo'pî pata po, pîika'tîton esenposa' man amîrî'nîkon ton pe. Mîîkîrî wanî Cristo, Paapa nîmenka'pî pe, Uyepotorîkon pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","—Sîrîrî warantî eporîya'nîkon yairî pu'kuru awanî epu'tîkonpa. More eporîya'nîkon kupî sîrîrî kamisa ke ya'santîsa' pe awanî, paakayamî' ya're' yense' ya' —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mîrîrî pe rî inserî pokonpe tu'kankon inserîyamî' esenpo'pî, Paapa poitîrîtonon. Inkamoroya Paapa yapurî'pî. Ta'pî to'ya: ");
INSERT INTO mbcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Paapa yapurî e'pai awanî ipata ya' ka' po. Maasa pra tarî non po tîîwanmîn tîîsa' Paapaya man pemonkonyamî' pia, Paapa wakîrikon pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mîrîrî taa tîpo, inserîyamî' enna'po'pî ka' pona. Mîrîrî tîpo inkamoro tekînkon era'manenan eseurîma'pî tîîwarîrî'nîkon. Inkamoroya ta'pî: —Aase'nîkon, wîtî'nîkon Belém pona, î' e'ku'sa' era'mai Uyepotorîkon nekaremekî'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Moropai inkamoro wîtî'pî ka'ne' pe teesemi'tapai. Teerepansa'kon yai eporî'pî to'ya, Maria moropai José. Moropai more era'ma'pî to'ya paakayamî' ya're' yense' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mîîkîrî more era'ma tîuya'nîkon tîpo inkamoro wîtî'pî, î' ta'pî inserîya to' pî' ekareme'se. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mîrîrî ekaremekî to'ya pî' tamî'nawîronkon esenumenka'pî kure'ne teesewankono'mai. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tîîse tamî'nawîrî mîrîrî pî' Maria esenumenka'pî kure'ne. Moropai mîrîrî koneka'pîiya tewan ya', tîwîrî teesenumenkapa. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mîrîrî tîpo inkamoro tekînkon era'manenan enna'po'pî Paapa yapurî ye'ka pe tîneta'pîkon pî' moropai tînera'ma'pîkon pî'. Tamî'nawîrî inserîya ekaremekî'pî yawîrî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Asakî'ne mia' pona tîîmo'tai wei tîpo, teserukon yawîrî more mere pi'pî pottî ya'tîsa' to'ya yai, itese' ton tîrî'pî to'ya Jesus kai'ma, manni' inserî nîtîrî'pî maasa Maria ro'ta ya' awe'kupî pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moropai to' ko'mamî'pî Maria ekoneka pîkîrî teserukon yawîrî. Maasa pra Moisés kaaretarîya taasa' wanî'pî aako'manto'pe asakî'ne pemonkonyamî' (40) wei kaisarî. Mîrîrî tîpo José moropai Mariaya more yarî'pî Jerusalém pona Uyepotorîkon pî' ekaremekîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Maasa pra mîrîrî warantî awe'menukasa' Uyepotorîkon maimu pe, E'mai'ne esenpo'pî warayo' pe tînmukukon mo'kato'pe to'ya Uyepotorîkon ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Moropai Uyepotorîkon pia tîntîrîkon tîîto'pe tîuya'nîkon, asakî'ne waku'kaimîyamî' yarî'pî to'ya, Paapa maimuya taasa' yawîrî. Mîrîrî ton pra awanî ya, asakî'ne wîrîwo'yamî' tîîto'pe to'ya, tînre yenpotîpono'pîkon ekonekato'pe morî pe, taasai'ya. Mîrîrî warantî ikupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mîrîrî yai tîîko'mansen wanî'pî Jerusalém po Simeão itese'. Yairî pu'kuru iteseru e'pîtî'pî moropai Paapa yapurînen pe awe'pîtî'pî. Moropai pena pata pai mîîkîrîya Judeuyamî' e'taruma'tîto' winîpai to' pîika'tînen iipî nîmîkî'pî. Kure'ne anera'mapai awanî'pî. Moropai Morî Yekaton Wannî wanî'pî iipia itesa' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Maasa pra Morî Yekaton Wannîya taasa' wanî'pî ipî': —Aasa'manta rawîrî mîîkîrî pîika'tîton tînmenka'pî yarimasa' Uyepotorîkonya era'maya pe nai —ta'pîiya. Mîrîrî ye'nen inîmîkî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mîrîrî ya Simeão ewomî'pî epîremanto' yewî' ta Morî Yekaton Wannî maimu pe. Mîrîrî yai itunya moropai isanya mîîkîrî Jesus yaasa' wanî'pî epîremanto' yewî' ta, Moisés nurî'tîya yenupanto'ya taasa' yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Era'ma tîuya pe Simeãoya mîîkîrî more yanumî'pî temekon pona. Moropai Paapa yapurî'pîiya. Mîîkîrîya ta'pî: ");
INSERT INTO mbcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","—Paapa, morî pe pu'kuru nai. Amaimu yawîrî iku'sa'ya nai. Pîika'tîton anarima'pî era'ma pî' wai uyenu ke pu'kuru. Mîîkîrî pîika'tîton yarimasa'ya Judeuyamî' pia neken pra tîîse tamî'nawîronkon pemonkonyamî' pia, tîpîika'tînenkon ton yarimasa'ya a'ka pe awe'to'pe, î' kai'ma tîîko'manto'kon wanî epu'to'pe to'ya. Moropai mîîkîrî pîika'tîton wenai apemonkonoyamî' Judeuyamî' yapurî to'ya. Tarîpai uusa'manta pe wai tîîwanmîra maasa pra pîika'tîton era'masau'ya ye'nen —ta'pî Simeãoya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mîrîrî warantî more pî' Simeão eseurîmasa' pî' itun moropai isan wanî'pî kure'ne teesenumenkai. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeãoya ta'pî inkamoro pî': —Paapaya morî tîrî pî' man aapia'nîkon —ta'pîiya. Moropai Maria Jesus yan pî' ta'pîiya: —A'kî, mîserî more wanî sîrîrî Paapa nîmenka'pî pe, tu'kankon Judeuyamî' pîika'tîton pe moropai tu'kankon newanmîrî tonpe. Paapaya imenka'pî î' kai'ma morî pe tîwanî ekareme'to'peiya. Mîrîrî era'ma tîuya'nîkon wenai tu'kankon eseurîma imakui'pî pe iwinîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mîrîrî taa tîuya'nîkon wenai imakui'pî pe tewankon wanî ekaremekî to'ya esera'ma. Mîrîrî warantî eesewankono'mato' wanî kupî sîrîrî, Maria. Kure'ne ne'ne' pe epu'tîya, tauraya ayewan ya'tî warantî —ta'pî Simeãoya Maria pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Moro awanî'pî itekare ekareme'nen no'santon profetisa inyo isa'manta'pî itese' Ana. Mîîkîrî wanî'pî Aser nurî'tî paarî'pî pe, Fanuel yensi pe. Asakî'ne mia' pona tîîmo'tai (7) kono' tîno'pîta tîpo inyo sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tarîpai mîîkîrî wanî'pî 84 kaisarî ikono po. Aako'manpîtî'pî epîremanto' yewî' ta. Mîîkîrîya Paapa yapurîpîtî'pî wei, ewaron kaisarî tekkari tonpai pra eepîremapîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mîîkîrî Ana iipî'pî inkamoro pia Simeãoya taasa' tanne. Mîrîrî yai Paapa yapurî'pîiya mîîkîrî more yarimasai'ya ye'nen. —Morî pe man, Paapa —ta'pîiya. Moropai tamî'nawîronkon pî' ekaremekî'pîiya mîîkîrî more yekare inkamoro Jerusalém ponkon pîika'tînen nîmî'nenan pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mîrîrî tîpo tamî'nawîron Paapa maimuya taasa' yawîrî ikupî tîpo'nîkon, José moropai Maria enna'po'pî Galiléia pata pona, tîpata Nazaré cidaderî pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Miarî mîîkîrî more arenta'pî moropai meruntî ke eena'pî. Epu'nen pe awanî'pî moropai Paapa wanî'pî iipia, iko'mannîpî'pîiya morî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kono' kaisarî Jesus yuntonon wîtîpîtî'pî Jerusalém pona Páscoa Judeuyamî' festarî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mîrîrî warantî to' wîtî'pî festa pî' asakî'ne pu' pona tîîmo'tai (12) Jesus kono po tîîse teserukon ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tamî'nawîrî festa ataretî'kasa' tîpo to' enna'po pia'tî'pî tewî'kon ta. Tîîse Jesus e'nîmî'pî Jerusalém po tuntononya epu'tî pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Itun esenumenka'pî tonpayamî' pokonpe attî kai'ma awanî'pî. Mîrîrî ye'nen to' ese'ma'tî'pî. To' wîtî'pî tiwin wei kaisarî tîîse to' enpenata'pî ipî'. Inkamoroya yuwa'pî itonpayamî' kore'ta pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tîîse eporî to'ya pîn. Mîrîrî ye'nen to' enna'po'pî Jerusalém pona yuwai. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eseurîwî'ne wei kaisarî tîîko'mamîkon tîpo, eporî'pî to'ya epîremanto' yewî' ta. Judeuyamî' yenupanenan kore'ta to' eseurîma eta pî' awanî'pî moropai to' yekaranmapo'pîtî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tamî'nawîronkon mîîkîrî eseurîma etatîponkon esenumenka'pî kure'ne teesewankono'mai. Maasa pra epu'nen pe awe'to' pî' moropai to' maimu yu'toi'ya pî' to' esenumenka'pî kure'ne epu'tî tîuya'nîkon yentai. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mîîkîrî era'ma tîuya'nîkon yai, ituntonon esewankono'ma'pî. Mîrîrî yai isanya ta'pî ipî': —Unre, î' wani' awanî ye'nen mîrîrî warantî awanî? Ayunya moropai uurîya anna esewankono'ma kure'ne ayuwa pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesusya to' maimu yuuku'pî: —Î' ton pe see uyuwaya'nîkon mîrîrî? Epu'tîya'nîkon pra naatî uyun yewî' ta uurî wanî e'pai awanî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tîîse inkamoroya î' taa Jesusya epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mîrîrî tîpo Jesus enna'po'pî tuntonon pokonpe Nazaré pona moropai aako'mamî'pî. Tuntonon maimu yawîrî awanî'pî. Tamî'nawîrî mîrîrî iteseru tînera'ma'pî pî' isan enpenatapîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mîrîrî yai Jesus arenta'pî, kure'ne eena'pî. Moropai epu'nen pe awe'to' nîrî ena'pî kure'ne. Paapa wakîri pe awanî'pî moropai pemonkonyamî' nîrî wakîri pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Reiyamî' esa' pe tîwe'sen Tibério wanî'pî Roma pata esa' pe. Mia' tamî'nawîrî tîîse, mia'taikin kaisarî ipona kono' (15) kaisarî awanî'pî pata esa' pe. Mîrîrî yai Pôncio Pilatos wanî'pî Judéia pata esa' pe. Herodes wanî'pî mîrîrî yai Galiléia pata esa' pe. Moropai Herodes yakon Filipe wanî'pî Ituréia pata esa' pe, moropai Traconites pata esa' pe. Moropai Lisânias wanî'pî Abilene pata esa' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás moropai Caifás wanî'pî teepîremasanon esanon pe. Mîrîrî yai Paapa eseurîma'pî Zacarias munmu, João yarakkîrî keren po. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Moropai Joãoya itekare ekaremekî pinunpa'pî. Tamî'nawîrî Jordão iren ratai poro tîîko'mansenon pî'. Taapîtî'pîiya see warantî: —Morî Paapa yeseru yapi'tî, imakui'pî ankupî'pîkon tîrumakai tamî'nawîrî, Paapaya tîîwanmîra iku'to'pe. Moropai esenpatakona'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mîrîrî warantî ekareme'pîtî'pî Joãoya penaron profeta Isaías nurî'tîya imenuka'pî tîkaaretarî po yawîrî. Awe'menukasa' wanî'pî see warantî: Keren po pemonkon man tîwentaimepîtî pî'. See warantî taapîtîiya: “Uyepotorîkon erepanto' ton konekatî. Morî pe to'sarî ite'marî ton konekatî, eerepanto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tamî'nawîron wî'kon yarappana pî' tîwe'senkon ena kupî sîrîrî yettapusa' pe. Moropai inonkon wî'kon wanî kupî sîrîrî se' kaisarî awe'to'pe. Moropai wayai wayai pe tîwe'sen e'makon wanî kupî sîrîrî to'saron pe moropai e'makon sakîsakîpankon ena kupî sîrîrî se' kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mîrîrî yai tamî'nawîronkon pemonkonyamî'ya pîika'tînto'pe Paapa nîtîrî'pî epu'tî kupî sîrîrî,” taiya kai'ma Isaías nîmenuka'pî. Mîrîrî yawîrî ikupî'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mîrîrî yai arinîkon pemonkonyamî' wîtî'pî esenpatakonai João pia. Tîîse Joãoya taapîtî'pî to' pî': —Îkîiyamî' amîrî'nîkon. Anî'ya ekareme'sa' apî'nîkon, Paapa ekore'mato' yapai awe'pîika'tîkon kai'ma, amakuyikon rumakaya'nîkon pra tîîse? Paapaya atarumatîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mîrîrî ye'nen ayeserukon imakui'pî ku'to'ya'nîkon rumakatî. Moropai amenan morî ayeserukon ton yapi'tî tamî'nawîronkonya ayeserurî'pîkon rumakasa'ya'nîkon epu'to'pe. Tîîse aawarîrî'nîkon rî kîkatî: “Paapa yapurînenan anna maasa pra Abraão payannî'san pe anna wanî ye'nen,” kîkatî. Mîrîrî taaya'nîkonya ya î' pe pra rî awanî, awe'pîika'tîkon pepîn. Tîîse tauya sîrîrî, ayentakon Abraão payannî'san pe tiaronkon kupî Paapaya e'painon seeni' tî'kon ke. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A'kî, wa'ka moro man yei ya'tîto'pe ikara yawîrî teeperu tîînen pepîn. Mîrîrî yenumî to'ya apo' ya' aaranto'pe. ˻Mîrîrî warantî Paapaya ikupî kupî sîrîrî inkamoro imakui'pî teserukon rumakatîponkon pepîn pî'.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mîrîrî ekaranmapo'pî pemonkonyamî'ya João pî': —Moriya î' kin kupî annaya e'painon? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Inkamoro maimu yuuku'pî Joãoya: —Anî' wanî ya asakî'ne ipon mîîkîrîya itakon tîrî e'pai awanî î' ton pîn pia. Moropai anî' wanî ya tekkari ke tiaron yentai, mîîkîrîya irataika e'pai awanî î' ton pîn pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mîrîrî yai João pia tiaronkon tesa'kon ton pe tîniru yapisî pî' teesenyaka'masanon erepamî'pî esenpatakonakai. Moropai João ekaranmapo'pî to'ya. Ta'pî to'ya: —Anna yenupanen, î' kupî annaya e'painon? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Moropai to' maimu yuuku'pî Joãoya: —Tîniru tîînenan winîpai kure'ne tîniru yapisîya'nîkon kai'ma ke'tî. Yapi'to'pe ta'pî yentai yapisîya'nîkon kai'ma ke'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Moropai tiaronkon surarayamî'ya nîrî João ekaranmapo'pî. Ta'pî to'ya: —Anna kanan, î' kupî annaya e'painon? Ta'pî Joãoya: —Anî'rî taruma'tîya'nîkon e'pai pra man, tîniru yu'se awanîkon wenai, seru'ye' pe, î' inkupî'pî ton pra tîîse. Tîîse tauya taatausinpai e'tî ayepe'pîkon anapisîkon pî' inî' panpî' itu'se tîwe'se pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mîrîrî yai pemonkonyamî' esenumenka'pî pîika'tîton pe João yarimasa' Paapaya kai'ma. ˻Maasa pra Paapa nîmenka'pî Cristo nîmîkî pî' to' wanî'pî.˼ —Yai pra Cristo mîîkîrî, Paapa nîmenka'pî pe awanî —taapîtî'pî to'ya João pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mîrîrî epu'tî tîuya ye'nen Joãoya ta'pî tamî'nawîronkon pî': —Uurîya ayenpatakonakon tuna ke neken. Tîîse tiaron yi'nî pî' man uye'ma'pî pî', ipîkku pe tîwe'sen uyentainon. Mîrîrî ye'nen uurîya mîîkîrî pisa'sa' yewa yeuka eserîke pra awanî, itarumai'pî pe wanî ye'nen. Mîîkîrîya amîrî'nîkon ˻imakui'pî rumakatîponkon˼ yenpatakona kupî sîrîrî Morî Yekaton Wannî enato'pe ayesa'kon pe. Moropai apo' ke eesenpatakonakon kupî sîrîrî. ˻Mîrîrî warantî ikupîiya tamî'nawîrî imakui'pî mo'kapa kai'ma.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mîîkîrî yenya trigo sururukato' wanî. Mîrîrî ke isururukaiya. Ipi'pî kore'tapai yaimenkaiya. Morîkon konekaiya itense' ya'. Mîrîrî pi'pîrî'pî po'tîiya apo' ya' eesi'nîpî neporîton pe pra —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mîrîrî warantî itekare ekaremekî tîuya yai, pemonkonyamî' panamapîtî'pîiya tu'ke teeseurîmato' ke. Maasa pra imakui'pî teserukon rumaka to'ya yu'se awanî'pî kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mîrîrî yai pata ko'mannî'nen Herodes panamapîtî'pîiya kure'ne imakui'pî ku'sai'ya wenai. Tîîse Herodes ekore'ma'pî ipî'. Maasa pra takon no'pî Herodias yarakkîrî awanî pî' eeseurîmasa' wenai. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mîrîrî ye'nen inî' panpî' imakui'pî kupî'pîiya. João yarakkamo me'po'pîiya atarakkannîto' ta inî' itekare ekaremekîiya namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tîîse mîrîrî rawîrî pemonkonyamî' yenpatakonasai'ya yai Jesus nîrî yenpatakona'pî Joãoya. Mîrîrî yai Jesus epîrema tanne, ka' esettapuruka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Moropai Morî Yekaton Wannî autî'pî ipona waku'kaimî pe. Moropai mai ka' poinon eseurîma'pî taawon see warantî: —Amîrî unmu, uwakîri pu'kuru amîrî. Kure'ne apî' atausinpa sîrîrî —ta'pî Paapaya. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mîrîrî yai teesenyaka'mato' pia'tî Jesusya yai, ikono po wanî'pî 30 kono' kaisarî. Mîîkîrî pî' to' esenumenkapîtî'pî José munmu pe awanî kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wanî'pî Matã nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José wanî'pî Matatias nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí wanî'pî Máate nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodá wanî'pî Joanã nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri wanî'pî Melqui nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wanî'pî Josué nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi wanî'pî Simeão nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim wanî'pî Meleá nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi wanî'pî Jessé nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassom wanî'pî Aminadabe nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacó wanî'pî Isaque nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor wanî'pî Serugue nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salá wanî'pî Cainã nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque wanî'pî Matusalém nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã wanî'pî Enos nurî'tî munmu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Morî Yekaton Wannî yarakkîrî Jesus enna'po'pî iren Jordão kapai. Itesa' pe mîîkîrî Morî Yekaton Wannî wanî'pî. Mîrîrî ye'nen Jesus yarî'pîiya keren pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Miarî Jesusya imakui'pî kupî yu'se Makui ko'mamî'pî asakî'ne pemonkon wei kaisarî. Mîrîrî yai î' tonpai pra Jesus wanî'pî. Mîrîrî ye'nen emi'ne awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mîrîrî yai Makuiya ta'pî ipî': —Innape Paapa munmu pe awanî. Mîrîrî ye'nen aawarîrî ka'kî tî' pî' eetinyaka'mato'pe ayu pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mîîkîrî maimu yuuku'pî Jesusya. Ta'pîiya: —Paapa maimu e'menukasa' man pena see warantî: “Tiyu pî' neken pemonkon ko'mamî pepîn”, taasai'ya man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mîrîrî tîpo inî'rî Makuiya Jesus yonpa'pî. Moropai yarî'pîiya kawînan wî' pona. Moropai tamî'nawîronkon pemonkonyamî' ko'manto'kon patakon yenpo'pîiya tiwinarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Moropai ta'pî Makuiya Jesus pî': —Tamî'nawîrî sîrîrî morî tîrîuya aapia ipîkku pe awanîpa, pemonkonyamî' esa' pe awanîpa. Mîrîrîya meruntî ke awanî amaimu yawîrî tamî'nawîronkon ko'mamî. Tamî'nawîrî sîrîrî uupia itîîsa' tîrîuya e'painon, anî' itu'se uurî e'to' pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mîrîrî ye'nen tîrîuya aapia, awe'sekunka ya uyapurîi —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesusya mîîkîrî maimu yuuku'pî: —Paapa maimu e'menukasa' man see warantî: “Ayepotorî Paapa yapurîkî. Mîîkîrî maimu yawîrî neken ako'mankî”, taasai'ya man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mîrîrî tîpo inî'rî Makuiya Jesus yarî'pî Jerusalém pona epîremanto' yewî' neka'ta pona, kawînan panpî' pona yanu'nîpî'pîiya. Moropai ta'pîiya Jesus pî': —Innape Paapa munmu pe awanî. Maasa arapunkî tarîpai non pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Maasa pra Paapa maimuya taasa' man: “Paapaya tîpoitîrîtonon inserîyamî' yarima pe man aapia apîika'tîto'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tenyakon ke ayapisî to'ya tî' pona a'pu pa'tîya namai”, taasai'ya man —ta'pî Makuiya ipî'. —Mîrîrî ye'nen arapunkî —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mîîkîrî maimu yuuku'pî Jesusya: —Tîîse Paapa maimu e'menukasa' man see warantî: “Ayepotorî Paapa tonpai pra e'kî”, taasai'ya man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tamî'nawîrî mîrîrî warantî Jesusya imakui'pî kupî emapu'tî yonpa'pî Makuiya, tîîse ikupîiya pra awanî'pî. Imaimu yawîrî Jesus wanî pîn. Mîrîrî ye'nen Makuiya irumaka'pî mararî, moropai tîîko'manse pu'kuru pra iipia tîwenna'popa. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mîrîrî tîpo Jesus enna'po'pî Galiléia pata pona. Moropai Morî Yekaton Wannî meruntîri wanî'pî yarakkîrî. Moropai Jesus yekare eta'pî tamî'nawîronkon mîrîrî pata ponkonya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mîîkîrîya pemonkonyamî' yenupa'pî to' epere'to'kon yewî'kon ta pî'. Moropai mîîkîrî yapurîpîtî'pî tamî'nawîronkonya miarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mîrîrî yai Jesus wîtî'pî Nazaré cidaderî pona. Mîrîrî cidade wanî'pî aarenta'pî pata'pî pe. Miarî teseru warantî rî sábado yai attî'pî Judeuyamî' epere'to' yewî' ta. Moropai miarî mîîkîrî e'mî'sa'ka'pî Paapa maimu e'menukasa' erenkai. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Moropai tiwin warayo'ya penaro' Paapa maimu ekareme'nen profeta Isaías nurî'tî kaaretarî tîrî'pî iipia. Mîîkîrîya kaareta arakkanmoka'pî, moropai mîrîrî kaareta po awe'menukasa' eporî'pî see warantî: ");
INSERT INTO mbcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Uyepotorî yekaton man uupia. Mîrîrî ye'nen mîîkîrîya umo'ka'pî tekare ekareme'to'peuya kai'ma manni'kan sa'ne î' ton pînon pî'. Moropai manni'kan to' e'pîika'tî eserîkankon pepîn, teeyatonon newa'tî'san inkamoro rumakato'peuya umo'ka'pîiya. Moropai enkaru'nankon sa'ne yenu yenponkato'peuya inî'rî era'mato'pe to'ya. Moropai tîwe'taruma'tîi tîîko'mansenon e'taruma'tî namai to' pîika'tîto'peuya umo'ka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Moropai tîpemonkonoyamî' pia uyarima'pîiya î' pensa to' pîika'tî Uyepotorîkonya ekareme'to'peuya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mîrîrî erenkasa' tîuya tîpo, Jesusya mîrîrî kaareta yettapurî'pî. Mîrîrî tîrî'pîiya mîîkîrî warayo' itîrîtîpon pia. Moropai eereuta'pî. Mîîkîrî yenu pîkîrî tamî'nawîronkon pemonkonyamî' wanî'pî mîrîrî epere'to' yewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mîrîrî yai eeseurîma pia'tî'pî: —Innape see mîrîrî Paapa maimuya taasa' yawîrî awe'ku'sa' man sîrîrîpe, mîrîrî etaya'nîkon manni'. ˻Manni' pemonkon yarima tîuya taasa' Paapaya manni' uurî˼ —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mîrîrî yai tamî'nawîronkon pemonkonyamî' eseurîma'pî morî pe Jesus maimu pî'. Mararî pra teesenumenkai to' wanî'pî, morî imaimuya î' taasa' pî'. Tîîse ta'pî to'ya tîîwarîrî'nîkon: —José munmu pepîn kin mîîkîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Moropai Jesusya ta'pî to' pî': —Epu'tî pî' wai, sîrîrî taato' ankapai awanîkon upî'. “Pri'yawonkon pepîn yepi'tînen amîrî. Mîrîrî ye'nen aawarîrî esepi'tîkî, era'mato'pe annaya”, taaya'nîkon. Moropai taaya'nîkon kupî sîrîrî: “Cafarnaum po pemonkonyamî' pri'yawonkon pepîn yepi'tî'pîya yekare eta'pî annaya. Mîrîrî ye'nen mîrîrî warantî iku'kî tarî apata ya'”, taaya'nîkon kupî sîrîrî upî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesus eseurîma ko'mannîpî'pî: —Innape tauya apî'nîkon, Paapa maimu ekareme'nen yapisî to'ya pepîn, itonpayamî'ya morî pe, maasa pra innape ikupî to'ya pra awanî ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Yairon pî' eseurîma etatî. Pena Paapa maimu ekareme'nen Elias nurî'tî wanî yai, kono' rena pra awanî'pî seurîwî'ne kono' arakkita pairî kaisarî. Mîrîrî ye'nen kure'ne iwan wanî'pî miarî Israel po. Moro to' wanî'pî tu'ke pu'kuru wîri'sanyamî' inyo isa'manta'san, Elias pata ya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tîîse inkamoro pia Elias yarimasa' Paapaya pra man to' pîika'tîto'peiya, iwan pe to' wanî tanne. Maasa pra innape ikupî to'ya pra awanî ye'nen. Tîîse tiaron pata pona Sidom pata pon Sarepta itese' yarima'pî Paapaya, wîri' inyo isa'manta'pî pia ipîika'tîto'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mîrîrî warantî awanî'pî nîrî pena Eliseu nurî'tî ko'mamî yai. Tu'ke pri'yawonkon pepîn ere' pokonkon wanî'pî, paran itese' leprosia. Tîîse inkamoro Judeuyamî' yepi'tî Eliseuya pra awanî'pî, innape ikupî to'ya pra awanî ye'nen. Tiwinan neken esepi'tî'pî tiaron pata pon, Síria pata pon, Judeu pepîn Naamã itese' esepi'tî'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mîrîrî taiya eta tîuya'nîkon yai, tamî'nawîronkon mîrîrî epere'to' yewî' tawonkon pemonkonyamî' ekore'ma'pî mararî pra ipî'. ˻Maasa pra epu'tî'pî to'ya, to' pî' Jesus eseurîmasa' ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mîrîrî ye'nen Jesus yapi'se to' e'mî'sa'ka'pî. Yapisî'pî to'ya moropai iworoka'pî to'ya poro pona. Moropai cidade poi yarî'pî to'ya. Mîrîrî kawînan wî' ipo cidade e'to' pona yarî'pî to'ya, mîîkîrî yenumîkonpa kai'ma miarî poi non pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tîîse mîîkîrî epa'ka'pî arinîkon pemonkonyamî' emurukuntî'san kore'tapai. Moropai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mîrîrî tîpo Jesus wîtî'pî Cafarnaum cidaderî pona, Galiléia pata pon. Miarî to' epere'to' yewî' ta pemonkonyamî' yenupa'pîiya erî'ka'nîto' weiyu yai. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mîîkîrî maimu pî' mararî pra pemonkonyamî' esenumenka'pî miarî. Maasa pra eeseurîmato' wanî'pî meruntî ke pu'kuru, Paapa maimu pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Moro to' epere'to' yewî' ta, o'ma' yarakkîrî tîwe'sen warayo' wanî'pî. Jesus eseurîma eta tîuya pe, mîîkîrî o'ma' entaime'pî meruntî ke pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ta'pîiya Jesus pî': —Jesus amîrî, Nazaré pon, î' ku'se aai'sa' sîrîrî anna pî'? Anna tî'kai ka'rî aai'sa'? —ta'pîiya. —Morî pe ayepu'nen uurî, amîrî wanî morî pe pu'kuru. Paapa narima'pî pe awanî —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tîîse Jesusya ta'pî o'ma' pî': —Moo e'kî, kîseurîmai —ta'pî Jesusya. Moropai ta'pîiya: —Mîîkîrî warayo' yapai epa'kakî. Moropai o'ma'ya mîîkîrî warayo' yenumî'pî non pona, tamî'nawîronkonya era'ma tanne. Moropai eepa'ka'pî warayo' yapai tîpa'tîi pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mîrîrî pî' tamî'nawîronkon esenumenkasa' wanî'pî mararî pra. Moropai inkamoroya ta'pî tîîwarîrî'nîkon: —Î' ye'ka see mîserî? Meruntî imaimu —ta'pî to'ya. —Mîserî warayo' wanî meruntî ke pu'kuru. Maasa pra o'ma'kon pî' taiya: “Epa'katî”, taiya moropai to' epa'ka. Imaimu yawîrî to' wîtî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mîrîrî tîpo mîrîrî Jesus nîkupî'pî yekare esekaremekî'pî mîrîrî pata poro. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mîrîrî tîpo Jesus epa'ka'pî to' epere'to' yewî' tapai. Moropai attî'pî Simão yewî' ta. Miarî pri'yawon pepîn Simão yawo'pî wanî'pî. Eekomi'masa' mararî pra. Mîrîrî ye'nen Jesusya ipîika'tîto'pe esatî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mîrîrî ye'nen mîîkîrî camarî pia Jesus e'rennuku'pî. Moropai ta'pîiya paran pî': —Atî'napankî —ta'pîiya. Moropai eekomi'makapî'pî ka'ne' pe. Moropai mîîkîrî e'mî'sa'ka'pî. Moropai to' ya're' ton koneka pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Moropai pata ewaronpamî pe tamî'nawîron pri'yawonkon pepîn tu'kan paran pî' tîwe'sanon yarî'pî to' yonpayamî'ya Jesus pia. Moropai tenya tîrî'pîiya to' pona tiwin pî' tîîse. Moropai inkamoro yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Moropai o'ma'kon yenpa'ka'pîiya tu'kankon pemonkonyamî' yapai. O'ma'kon entaimepîtî'pî teepa'kakon pe. Taapîtî'pî to'ya ipî': —Amîrî wanî Paapa munmu pe pu'kuru —ta'pî to'ya. Paapa nîmenka'pî pe Jesus wanî epu'tî'pî to'ya. Mîrîrî ye'nen tîpî' to' eseurîma tîrî Jesusya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pata erenma'sa' pe, Jesus epa'ka'pî mîrîrî cidade poi. Moropai attî'pî keren pona. Mîîkîrî yuwa pia'tî'pî arinîkon pemonkonyamî'ya. Mîîkîrî eposa' tîuya'nîkon pe tîîpiapai'nîkon attî yu'se pra to' wanî'pî mîrîrî pata poro. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tîîse Jesusya ta'pî to' pî': —Tiaron cidadekon po sîrîrî morî itekare ekaremekîuya e'pai man Paapa pemonkono pe to' e'to'pe. Î' kai'ma Paapa iipî tamî'nawîronkon esa' pe anekareme'pai wai. Maasa pra sîrîrî tîmaimu ekareme'se Paapaya uyarima'pî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mîrîrî warantî sîrîrî itekare Paapa maimu ekaremekî pinunpa'pîiya, to' epere'to'kon yewî'kon tapî' tamî'nawîrî mîrîrî pata poro. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Moropai Jesus wanî'pî kasapan po Genesaré ku'pî ena po itekare ekaremekî pî'. Arinîkon pemonkonyamî' ii'sa' wanî'pî iipia Paapa maimu etai. Kîrîppe to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mîrîrî yai asakî'nan kanaukon era'ma'pî Jesusya mîrîrî iku'pî ka aminke pra mîrîrî kasapan pî'. Mîrîrî kanaukon wanî'pî moro'yamî' yapi'nenan nîrennuku'pî pe moro' worokato' tîuya'nîkon ronakonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mîrîrî kanau yakon ya' Jesus asara'tî'pî Simão e'to' kanau ya'. Moropai Simão pî' ta'pî Jesusya mîîkîrî atarimato'pe mararî kasapan poi. Moropai eereuta'pî kanau ya moropai inkamoro arinîkon pemonkonyamî' yenupa pia'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Teeseurîma aretî'ka tîpo ta'pîiya Simão pî': —Mairon ke tîwe'sen ya' kanau yaakî, moropai ayonpayamî' pokonpe si'ma mîrîrî moro' worokato'ya'nîkon yenuntî moro' yapisîkonpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tîîse Simãoya ta'pî: —Uyenupanen, anna esenyaka'masa' sîrîrî kure'ne ewaron ya' eerenmapî pîkîrî, tîîse anî' yapisî annaya pra man. Tîîse “Yenuntî” taaya ye'nen, amaimu pe yenumî annaya sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mîrîrî moro' worokato' yenumî'pî to'ya tuna ka. Mîrîrî ke moro'yamî' yapisî'pî to'ya mararî pra. To' worokato' to'ya ya moro'yamî' yapîtanîpî yonpa pra awanî'pî. Awe'karaka yonpa'pî tu'ke to' wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mîrîrî ye'nen tiaron kanau ya' tîwe'sanonkon tonpakon yanno'pî to'ya, tîpîika'tîi'nîkon to' ii'to'pe kai'ma. Inkamoro wîtî'pî to' pia. Moropai tîkanaukon, sa'nîrî yannîpî'pî to'ya moro'yamî' ke. Inkamoro kanau eseuronka yonpa'pî amîi'ne pe moro'yamî' wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mîrîrî warantî awe'kupî era'ma tîuya ye'nen, Simão Pedro e'sekunka'pî Jesus pia. Moropai ta'pîiya: —Uyepotorî, uurî sa'ne wanî imakui'pî ku'nen pe. Mîrîrî ye'nen uupiapai atarimakî. ˻Morî pe awe'to' warantî pepîn uurî˼ —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mîrîrî warantî eeseurîma'pî maasa pra moro'yamî' yapi'sa' tîuya'nîkon era'ma'pîiya. Mîrîrî ye'nen Simão moropai tiaronkon ipokonpe tîwe'sanon inkamoro esenumenka'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Moropai Tiago moropai João, Zebedeu munkîyamî' inkamoro Simão pokonpe si'san, nîrî esenumenka'pî mararî pra. Moropai Jesusya ta'pî Simão pî': —Eranne' pe pra e'kî. Sîrîrî pata pai amîrî esenyaka'ma pe nai moro'yamî' yapisî pî' pra. Tarîpai eesenyaka'ma pe nai pemonkonyamî' pî', upemonkono pe to' enato'pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Moropai inkamoroya tîkanaukon yeku'na'pî kasapan pona. Miarî inîmîkî'pî to'ya tamî'nawîrî moropai to' wîtî'pî Jesus wenairî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tiaron pensa Jesus wanî'pî cidade po. Leprosa itese' paran pî' tîwe'sen wanî'pî. Mararî pra itesa' poro ere' pe awanî'pî. Mîîkîrîya Jesus era'ma'pî. Ipîkku pe awanî epu'tî tîuya ye'nen, inama tîuya pe mîîkîrî e'sekunka'pî irawîrî, non pona tenpata tîrennu'se. Moropai mîîkîrîya Jesus yeka'nunka'pî. Ta'pîiya Jesus pî': —Epu'tî pî' wai, amîrî uyepi'tî ton, Uyepotorî. Uurî anepi'tîpai awanî ya, uyepi'tîya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mîrîrî taiya ye'nen Jesusya tenya kainumî'pî. Moropai yapî'pîiya. Moropai ta'pîiya: —Inna, ayepi'tîuya —ta'pîiya. Mîrîrî pe rî iteparan esera'ma pra eena'pî. Eesepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mîîkîrî pî' ta'pî Jesusya: —Anî' pî' mîrîrî eesepi'tîsa' manni' kîsekaremekîi. Tîîse matîi teepîremasen pia, î' kai'ma eesepi'tîsa' era'mato'peiya. Moropai Paapa pia antîrî ton mayayamî' marîi teepîremasen pia Moisés kaaretarîya taasa' yawîrî. Eesepi'tîsa' epu'to'peiya mîrîrî mîkupîi —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tîîse Jesusya mîrîrî ye'ka ku'sa' yekare etasa' tîuya'nîkon pe ekaremekî'pî to'ya, tamî'nawîronkonya epu'tî'pî. Moropai mîrîrî etasa' tîuya'nîkon pe arinîkon pemonkonyamî' iipî'pî iipia, imaimu etai moropai esepi'tîi teparankon winîpai. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tîîse tu'ke ite'ka Jesus atarimapîtî'pî tiaronkon kore'tapai tiwinsarî epîremai. Moro eepîremapîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mîrîrî yai Jesusya pemonkonyamî' yenupa tanne, fariseuyamî' moropai Moisés nurî'tîya yenupato' pî' yenupatonkon nîrî ereutasa' wanî'pî iipia etai. Inkamoro wanî'pî iipî'san pe Galiléia pata poi, moropai Judéia pata poi, moropai Jerusalém cidaderî poi. Jesus pia Uyepotorîkon meruntîri wanî ye'nen, pri'yawonkon pepîn yepi'tîpîtîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mîrîrî yai tiaronkon warayo'kon asakîrîronkonya pri'yawon pepîn eke'nepamî'pî enepî'pî tette' ta tîîse, Jesusya yepi'tîto'pe kai'ma. Mîîkîrî sa'ne anawonnî'pai to' wanî'pî Jesus rawîrî itîrîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tîîse yawonnîpî to'ya eserîke pra awanî'pî. Maasa pra intapîkîrî mîrîrî wîttî ita to' e'to' wanî'pî, to' ewomî yentai. Mîrîrî ye'nen mîîkîrî sa'ne pri'yawon pepîn yanu'nîpî'pî to'ya wîttî neka'ta pona. Moropai Jesus kaisarî wîttî yamî'to' yaranka'pî to'ya. Moropai mîîkîrî sa'ne enu'tî'pî to'ya tette' ta tîîse, pemonkonyamî' kore'ta pî' Jesus rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kure'ne innape tîkupî to'ya epu'tî tîuya ye'nen, Jesusya ta'pî mîîkîrî pri'yawon pepîn eke'nepamî'pî pî': —Uyonpa, imakui'pî ankupî'pî kupî pî' wai uuwanmîra —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mîrîrî taiya eta tîuya'nîkon pe, inkamoro Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai tiaronkon fariseuyamî' eseurîma'pî tîîwarîrî'nîkon. —Anî' see mîserî warayo', Paapa pe tîwe'ku'sen, mîrîrî warantî eeseurîmato'pe. Maasa pra anî'ya imakui'pî pe pemonkon e'to' mo'ka pepîn Paapa pe pra si'ma. Tîîse Paapaya neken ikupî tîîwanmîra —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tewankon ya' to' esenumenka epu'tî'pî Jesusya. Moropai ta'pîiya to' pî': —Î' ton pe see mîrîrî warantî eesenumenkakon mîrîrî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Î' ye'ka pe awanî e'painon sa'me pra mîîkîrî warayo' eke'nepamî'pî pî' tauya ya, “Imakui'pî ankupî'pî kupî pî' wai uuwanmîra” tauya ya, ou “E'mî'sa'kakî moropai asakî” tauya ya —ta'pîiya. —Sa'me pu'kuru awanî uyentai kai'ma eesenumenkakon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Tîîse meruntî man uupia, uurî ka' poi iipî'pî pia. Tarî non po umaimu pe uuwanmîra imakui'pî anî' nîkupî'pî ku'nen pe wanî. Mîrîrî epu'tîkonpa mîserî eke'nepamî'pî pî' tauya sîrîrî, e'mî'sa'kakî moropai ayette' yanmako'makî moropai atîkî ayewî' ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mîrîrî pe rî ka'ne' pe mîîkîrî warayo' e'mî'sa'ka'pî tamî'nawîronkonya era'ma tanne. Tette' yanmako'ma'pîiya. Moropai attî'pî tewî' ta. Mararî pra taatausinpai Paapa yapurî'pîiya tuutî ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mîrîrî era'ma tîuya'nîkon ye'nen, tamî'nawîronkon pemonkonyamî' wanî'pî teesenumenkai mararî pra ipî'. Moropai inkamoroya Paapa yapurî'pî inamai'ma mararî pra. —Sîrîrî ye'ka esenumenkanto' era'masa' pra man tîîse sîrîrîpe era'ma sîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mîrîrî tîpo Jesus epa'ka'pî moropai attî'pî. Tuutî ye'ka pe warayo' Levi itese' ereutasa' era'ma'pîiya teesenyaka'mato' yaponse' po. Tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masen. Mîîkîrî pî' ta'pî Jesusya: —Aase upîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mîîkîrî e'mî'sa'ka'pî moropai tamî'nawîrî teesenyaka'mato' rumaka'pîiya. Moropai attî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tîko'man pe pu'kuru pra kure'ne taatausinpai entamo'kanto' tu'kan koneka'pî Leviya Jesus tonpe tewî' ta. Inkamoro kore'ta arinîke tiaronkon tîniru yapisî pî' teesenyaka'masanon wanî'pî. Moropai tiaronkon pemonkonyamî' nîrî ereutasa' wanî'pî to' kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mîrîrî yai fariseuyamî', moropai Moisés nurî'tî yenupanto' pî' yenupatonkon, itonpayamî' pe tîwe'sanon inkamoro ekore'ma'pî Jesus nenupa'san winîkîi. Moropai ta'pî to'ya: —Î' wani' awanî ye'nen amîrî'nîkonya aya're'kon yonpa, moropai awukukon enîrîya'nîkon inkamoro tîniru yapisî pî' teesenyaka'masanon pokonpe, moropai tiaronkon pemonkonyamî' imakui'san to' yeserukon pokonpe —ta'pî to'ya. ˻Maasa pra teeserukon yawîrî nurakon pemonkonyamî' pokonpe ta're'kon yonpa to'ya pepîn tiwin kin.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","To' maimu yuuku'pî Jesusya: —A'kî, pri'ya pu'kuru tîwe'sanonya tepi'tînenkon ton yuwa pepîn. Tîîse pri'ya pra tîwe'sanonya neken yuwa —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—Mîrîrî warantî morîkon pemonkonyamî' yannoi uui'sa' pra wai. Tîîse imakui'san pemonkonyamî' yannoi uui'sa' sîrîrî, imakui'pî to' nîkupî'pî rumakato'pe to'ya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mîrîrî tîpo inkamoroya ta'pî Jesus pî': —João Batista nenupa'san epîremapîtî e'pîtî tekkarikon tonpai pra. Mîrîrî warantî nîrî fariseuyamî' nenupa'san wanî —ta'pî to'ya. —Tîîse anenupa'san wanî mîrîrî warantî pra, ta're'kon yonpa to'ya moropai tîwukukon enîrî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","To' maimu yuuku'pî Jesusya: —Tîneta'san pokonpe tîwe'marimasen wanî tanne ta're'kon tonpai pra ineta'san wanî pepîn. To' pokonpe tîwe'marimasen wanî pîkîrî ta're'kon tonpai pra to' wanî pepîn. Tîîse to' entamo'ka moropai to' atausinpa mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tîîse tiwin wei mîîkîrî tîwe'marimasen mo'ka tiaronkonya kupî sîrîrî. Uurî wanî tîwe'marimasen warantî, moropai unenupa'san wanî ineta'san warantî. Umo'ka to'ya ya unenupa'sanya ta're'kon yonpa pepîn, teesewankono'makon ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Moropai Jesusya panton ekaremekî'pî. ˻Amenan esenupanto' pî', penaron esenupanto' pî' to' esenumenkato'pe ekaremekî'pîiya.˼ Ta'pîiya: —A'kî, anî'ya amenan kamisa poi i'pia'pî ya'tî pepîn e'painon ipoi'pî pon e'karakasa' rumentannî ton. Maasa pra mîrîrî ku'sai'ya ya, amenan ena a'ta ke. Moropai ipoi'pî pon nîrî ena imakui'pî pe. Mîrîrî pia'pî imo'kasa' e'tîrî pepîn ipoi'pî pon yarakkîrî, imakui'pî pe awanî sa'nîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Moropai anî'ya amenan wo' konekasa' yara'tî pepîn nîrî e'painon penaro' ipoi'pî cabra pi'pî konekasa' ya', wo' yense' pe. Maasa pra amenan wo' yara'tîsa'ya wo' mai'ta ya, ipoi'pî tense' ya'morikkaiya, moropai wo' eti'kamo, aama'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mîrîrî namai amenan wo' konekasa' yara'tî e'pai awanî amenan itense' cabra pi'pî konekasa' ya. Mîrîrî warantî morî pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tîîse penaro' wo' enîrîtîponkonya amenan wo' enîrî pepîn. Maasa pra taa to'ya: “Penaro' wo' wanî morî pe amenan yentai”. Mîrîrî ta'pî Jesusya ˻amenan ke to' yenupa tîuya ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Erî'ka'nîto' weiyu sábado yai Jesus asarî'pî trigo ye'ka kore'ta pî' tînenupa'san pokonpe. Mîrîrî yai tuutîkon ye'ka pe inenupa'san ena'pî emi'ne. Mîrîrî ye'nen trigo pikka'pî to'ya. Mîrîrî pi'ka'pî to'ya tîsikiisiki'mai tenyakon ke. Mîrîrî yaku'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Miarî tiaronkon fariseuyamî' wanî'pî to' kore'ta. Mîrîrî era'ma tîuya'nîkon ye'nen ta'pî to'ya: —Î' ton pe see trigo pikka pî' eesenyaka'makon mîrîrî? Moisés nurî'tîya sîrîrî erî'ka'nîto' weiyu yai esenyaka'manto'pe taasa' pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Inkamoro maimu yuuku'pî Jesusya: —A'kî, î' kai'ma kaareta erenkasa'ya'nîkon pra naatî? Pena rei Davi nurî'tî nîkupî'pî pî' teeseurîmasen? Pena emi'ne awanî'pî moropai ipokonpankon wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mîrîrî ye'nen mîîkîrî ewomî'pî Paapa yewî' ta moropai Paapa pia to' nîtîrî'pî pão mo'ka'pîiya. Moropai yaku'pîiya moropai itîrî'pîiya nîrî tîpokonpankonya ya'to'pe. Mîrîrî pî' Paapa ekore'ma pîn, teepîremasanon neken naku itîîsa' ya'sa' to'ya pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesusya teeseurîmato' yaretî'ka'pî see warantî: —Uurî ka' poi iipî'pî wanî erî'ka'nîto' weiyu yai tamî'nawîronkon nîkupî ton ekareme'nen pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tiaron pensa Jesus ewomî'pî erî'ka'nîto' weiyu yai to' epere'to' yewî' ta. Moropai to' yenupa pia'tî'pîiya. Mîrîrî yai warayo' wanî'pî meruntî winon itemekon atapîmî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mîrîrî yai miarî tiaronkon Moisés yeserurî'pî pî' yenupatonkon wanî'pî moropai fariseuyamî' nîrî wanî'pî. Inkamoro wanî'pî Jesus yenu pîkîrî. Maasa pra erî'ka'nîto' weiyu yai anî' yepi'tîiya era'makonpa kai'ma. Î' ku'sai'ya ya, ipî' teeseurîmakonpa teserukon yawîrî pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tîîse Jesusya to' esenumenkato'kon epu'tî'pî. Mîrîrî ye'nen ta'pîiya mîîkîrî warayo' itemekon atapîmî'pî pî': —E'mî'sa'kakî moropai satippe e'kî inkamoro kore'ta. Moropai warayo' e'mî'sa'ka'pî satippe eena'pî to' kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Moropai ta'pî Jesusya to' pî': —Uurîya ayekaranmapokon sîrîrî. Î' kai'ma uyeserukonya taasa' nai erî'ka'nîto' weiyu yaino pî'? Î' wanî mîrîrî, morî ku'to'pe sábado yai, morî ou imakui'pî? Anî' pîika'tî ou tîwî anî' sa'manta tanne era'mapîtî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","˻Tîmaimu yuuku to'ya pra ye'ka pe˼, Jesusya tamî'nawîronkon tîwoinokon era'ma'pî. Moropai ta'pîiya mîîkîrî warayo' pî': —Ayemekon kainunkî. Moropai warayo'ya temekon kainumî'pî. Mîîkîrî esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mîrîrî era'masa' tîuya'nîkon ya pe to' ekore'ma'pî mararî pra. Moropai teeseurîmakon pia'tî'pî to'ya, î' kupî tîuya'nîkon pî' Jesus winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mîrîrî tîpo mararî tîîko'manse, Jesus enuku'pî wî' pona epîremai. Moropai ewaron iwa'ka'pîiya teepîrema pî' Paapa pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eerenma'sa' pe tînenupatonkon yanno'pîiya tîîpia. Inkamoro menka'pîiya. Asakî'ne pu' pona tîîmo'tai'nîkon menka'pîiya. Inkamoro yarimapa kai'ma itekare ekareme'se to' menka'pîiya. Mîrîrî warantî insamoro asakî'ne pu' pona tîîmo'tai'nîkon wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Awanî'pî Simão. Mîîkîrî ese'tî'pîiya Pedro kai'ma. Moropai itakon André wanî'pî. Tiago moropai João moropai Filipe moropai Bartolomeu. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus moropai Tomé, moropai Afeu munmu itese' Tiago, moropai Simão manni' teepîsen Zelote taato'. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Moropai awanî'pî Tiago munmu, Judas. Moropai Judas Iscariotes manni' Jesus yapisîton iteyatonon pia itîrîpa. Inkamoro menka'pîiya tînaipontîkon ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mîrîrî tîpo Jesus autî'pî wî' poi to' pokonpe wî' parakon pona. Moro to' wanî'pî tu'kankon inenupa'san. Moropai tiaronkon pemonkonyamî' tîpatakon poi iipî'san wanî'pî miarî. Judéia pata ponkon moropai Jerusalém cidaderî ponkon. Moropai Tiro cidaderî ponkon moropai Sidon cidaderî ponkon, tuna rî'pîkîrî tîwe'sanon. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inkamoro wanî'pî iipî'san pe Jesus eseurîma etai. Moropai Jesusya tepi'tîto'kon pe teparankon winîpai. Moropai o'ma' yarakkîrî tîwe'sanon nîrî wanî'pî miarî. Moropai inkamoro yepi'tî'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mîrîrî yai tamî'nawîronkon wanî'pî Jesus anapîpai. Maasa pra imeruntîri wenai pemonkonyamî' esepi'tî'pî. Mîrîrî ye'nen anapîpai tamî'nawîronkon wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mîrîrî yai Jesusya tînenupa'san era'ma'pî moropai ta'pîiya to' pî': —Morî pe awanî amîrî'nîkon î' ton pra tîwe'sanon ton pe. Maasa pra amîrî'nîkon yapisî Paapa ayesa'konya, tîpemonkono pe awe'to'pe'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Morî pe awanî amîrî'nîkon emi'nankon ton pe, maasa pra awore awanîkon kupî sîrîrî. Morî pe awanî amîrî'nîkon tîkauware eesewankono'mato'kon pî'. Maasa pra kure'ne asisikon kupî sîrîrî taatausinpai. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Morî pe awanî amîrî'nîkon, ka' poi iipî'pî pemonkon pe uurî wenai ayewanmîrîkon to'ya ya, ayenpa'kakon to'ya ya tîkore'tapai'nîkon, moropai amu'tunpakon to'ya ya, moropai tamî'nawîrî ataruma'tîkon to'ya ya, morî pe awanî amîrî'nîkon ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mîrîrî ye'nen atausinpatî, arapunpî'tî taatausinpai. Maasa pra mararon pepîn amîrî'nîkon ton konekasa' Paapaya man ka' po. Taatausinpai e'tî, maasa pra mîrîrî warantî inkamoro atarumatîkon to'ya manni'kan tamorî'sanya penaronkon Paapa maimu ekareme'nenan profetayamî' nurî'tî taruma'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tîîse “ekenne” taaya'nîkon pe naatîi, ipîkkukon pe tîwe'sanon. Maasa pra aasîrî itu'se awe'to'kon yapisî'pîya'nîkon tamî'nawîrî. Inî' panpî' yapisîya'nîkon pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—“Ekenne” taaya'nîkon pe naatîi, amîrî'nîkon awore tîwe'sanon. Maasa pra emi'ne awanîkon kupî sîrîrî. “Ekenne” taaya'nîkon pe naatîi, amîrî'nîkon tîsi'rîsanon. Maasa pra akaraukon kupî sîrîrî teesewankono'mai. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ekenne” taaya'nîkon pe naatîi, tamî'nawîronkon pemonkonyamî' napurî'san. Maasa pra pena mîrîrî warantî inkamoro tamorî'sanya seru'ye'kon profetayamî' yapurî'pî. Moropai to' e'taruma'tî'pî warantî amîrî'nîkon e'taruma'tî kupî sîrîrî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Tîîse tauya amîrî'nîkon eseurîma etanenan pî' —ta'pî Jesusya. —Ayeyatonkon sa'namatî. Moropai morî ku'tî ayewanmîrî'nenkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Moropai amu'tunpanenkon yapurîtî, moropai epîrematî inkamoro ye'kakon ataruma'tînenkon pona —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—A'kî, anî'ya ayenpata'mo ya, mîîkîrî pa'tîya kîsuwai. Tîîse iratai winî era'tîkî apa'tîto'peiya inî'rî. Moropai anî'ya aya'san yarî'pî ya, tîwî nîsi, inî' panpî' apon anapai tîwanî ya, yaato'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Î' rî esatî anî'ya ya, iipia itîîkî. Tiaronya î' rî ayemanne mo'ka'pî ya, kîsina'poi iipiapai. Mîrîrî ye'ka pe iku'tî tîwîrî apî'nîkon mîrîrî ku'nenan yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tiaronkon pî' morî kupîya'nîkon e'pai man, inkamoroya amîrî'nîkon pî' mîrîrî warantî ikupî yu'se awanîkon, manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Awakîrikon neken sa'namaya'nîkon ya, î' pe pra rî mîrîrî ku'sa'ya'nîkon wenai î' rî tîrî Paapaya pepîn aapia'nîkon. Maasa pra tiaronkon imakui'pî ku'nenanya nîrî ikupî mîrîrî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Moropai nîrî morî pe awanîkon manni'kan apî'nîkon morî pe tîwe'sanon pî' neken, î' pe pra rî awanîkon. Mîrîrî ku'sa'ya'nîkon pî' Paapaya ayapurîkon pepîn. Maasa pra tiaronkon imakui'pî ku'nenanya nîrî ikupî mîrîrî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mîrîrî warantî ayemanne tîrîya'nîkon ya, ka'ne' pe manni'kan ye'mato' esanon pia î' pe pra rî mîrîrî wanî. Aapia'nîkon Paapaya î' rî tîrî pepîn mîrîrî ku'sa'ya'nîkon wenai. Maasa pra imakui'pî ku'nenanya nîrî ikupî mîrîrî warantî inna'pokonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tîîse mîrîrî warantî pra ikupîya'nîkon e'pai awanî. Ayeyatonkon pe tîwe'sanon inkamoro sa'namatî. Morî ku'tî inkamoro ton pe. Ayemannekon tîîtî inna'poya'nîkon pata pe pra. Mîrîrî kupîya'nîkon ya Paapa nîtîrî kure'ne yapisîya'nîkon. Mîrîrî warantî kupîya'nîkon ya, tamî'nawîronkon yentainon Paapa munkî pe awanîkon. Mîrîrî ye'nen morî ku'tî. Maasa pra Paapa wanî morî pe pu'kuru manni'kan iwinîpai tînapisî'pîkon “Morî pe man” taawonan pepîn pî'. Moropai îrirîkon pî' nîrî morî pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mîrîrî ye'nen tamî'nawîronkon era'matî a'noko'pîkon pe tî'noko'pî pe amîrî'nîkon era'ma Paapa uyunkonya manni' warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Tiaronkon nîkupî'pî pî' taatako'menkai pra e'tî, Paapaya ankupî'pîkon pî' ayako'menkakon namai. “Yairî pra awanîkon” kîkatî tiaronkon pî', mîrîrî warantî Paapaya taa namai apî'nîkon. Tîîse ka'tî to' pî': “Tamî'nawîrî î' rî ankupî'pîkon uwinîkîi kupî pî' wai uuwanmîra, î' wani' pra man”, ka'tî. Mîrîrî taaya'nîkon ya, mîrîrî warantî ankupî'pîkon kupî Paapaya tîîwanmîra. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tiaronkon nesatî antîîtî to' pia. Mîrîrî tîîsa'ya'nîkon ya, to' pia Paapaya nîrî itîrî aapia'nîkon. Mîrîrî tîîtî kure'ne antîîpai awanîkon pîkîrî, anne' pe tîwe'se pra. Mîrîrî tîrîya'nîkon ya mîrîrî tîîtî mararî pra tîsa'mannî'pî'se tu'ke awe'to'pe. Maasa pra mîrîrî warantî rî itîrî Paapaya nîrî aapia'nîkon itîrî'pîya'nîkon kaisarî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusya to' nepu'tîton panton ekaremekî'pî. Ta'pîiya see warantî: —A'kî, enkaru'nan pemonkonya tiaron pemonkon enkaru'nan yarî pepîn e'painon itu'nakan pe tîwe'sen ekaya. Maasa pra mîrîrî warantî to' wîtî ya, itu'nakan ya' to' e'soroka sa'nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Moropai ta'pîiya inî'rî: —A'kî, teesenupasen wanî pepîn ipîkku pe tenupanen yentai. Tîîse teesenupato' yaretî'kasa' tîuya ya tamî'nawîrî tenupanenya tenupato' epu'sai'ya ya iwarantî awanî. Maasa pra teesenupa'pî pîkîrî neken tenupasai'ya ye'nen. Tenupatîpon kaisarî awanî itentai pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Moropai ta'pîiya inî'rî: —Î' wani' awanî ye'nen kin ayonpa nîkupî'pî iteseru era'maya morî pe. Tîîse itentai ikupîtîpon pe si'ma. Ayeseru nura era'maya pepîn ayewan ya' mararî pra tîîse. Si'mîrikkî pe tîwe'sen ayonpa yenu yawon era'maya kure'nan yei warantî, ayenu ya' tîwe'sen tera'mai pra? —ta'pî Jesusya iteseru imakui'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","—Tîîse o'non ye'ka pe ayonpa pî' taa yu'se awanî. “Uyakon maasa ayenu ya' tîwe'sen mo'kato'peuya” taa yu'se awanî? Tîîse mîrîrî kure'nan ayeseru imakui'pî ankupî'pî tera'mai pra aawarîrî. Amîrî seru'ye' pe aawarîrî morî pe tîwe'se awe'ku'sen. E'mai' pe ayeseru imakui'pî ankupî'pî era'makî. Ayeseru konekakî morî pe. Moropai mîrîrî tîpo morî pe tepu'se ayonpa nîkupî'pî imakui'pî pî' pîika'tîpa —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mîrîrî tîpo Jesusya ta'pî: —Morî yeiya, imakui'pî pe teperu tîrî pepîn e'painon. Moropai yei, apakkori'ta'pîya morî pe teperu tîrî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mîrîrî ye'nen tiwin pî' yei tîîse iteperu pî' eesepu'tî. Anî'ya figo yeperu pikka pepîn mî'nî ye' poi. Moropai uva yeperu pikka pepîn mî'nî ye' poi. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tîîse warayo' morî pe tîwe'sen, eseurîma morî pe maasa pra morî pe itewan wanî ye'nen. Mîrîrî warantî warayo' imakui'pî pe tîwe'sen eseurîma imakui'pî pe. Maasa pra tewan ya' tîwe'sen yawîrî eeseurîma —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Î' ton pe see “Uyepotorî” kai'ma uyesatîya'nîkon sîrîrî umaimu yawîrî iku'tî ta'pîuya yawîrî ikupîi'ma pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—Tarîpai anepu'tîkon ton ekaremekîuya sîrîrî. Manni' umaimu etanen moropai ikonekanen wanî morî pe, innape ikupîiya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mîîkîrî wanî manni' warayo' tewî' ton konekanen warantî. Mîîkîrîya non yaka itu'na moropai tî' tîrîiya ite'se' ton, sa'me awe'to'pe tî' pona. Mîrîrî konekasai'ya tanne, tuna yannîpî moropai ipona eerepamî. Tîîse yenumîiya pepîn, sa'man pe awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tîîse manni' umaimu etanen tîîse ikonekanen pepîn, mîîkîrî wanî, manni' warayo' tewî' ton konekatîpon sa'man pepîn non ya' warantî. Î' pensa tuna erepamî ya ipona, yenumîiya ka'ne' pe. Tamî'nawîrî eesenumî, sa'me pra awanî ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pemonkonyamî' yeurîma aretî'ka tîpo, Jesus wîtî'pî Cafarnaum cidaderî pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Miarî Cafarnaum po surarayamî' yepotorî wanî'pî Roma pon, Judeu pepîn. Mîîkîrî poitîrî kure'ne inapurî iwakîri ipoitîrî enasa' wanî'pî pri'ya pra. Mararî pra aasa'manta yonpasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesus pî' to' eseurîma etasa' tîuya yai mîîkîrî surarayamî' esa'ya tiaronkon Judeuyamî' esa' pe tîwe'sanon yarima'pî Jesus pia to' wîtîto'pe. Jesus yanno me'po'pîiya itewî' ta aai'to'pe mîîkîrî sa'ne ipoitîrî yepi'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inkamoro wîtî'pî epose. Moropai eposa' tîuya'nîkon ya yai, attîto'pe taa pî' to' ko'mamî'pî ipî' tîko'man pe mîîkîrî surarayamî' esa' yewî' ta. Ta'pî to'ya: —Mîserî pîika'tîya e'pai awanî, maasa pra morî pe tîwe'sen mîserî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Maasa pra anna yonpayamî' sa'namaiya mararî pra. Moropai mîserîya epere'nîto' yewî' ton koneka me'po'pî anna ton pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","—Inna, moriya. Uttî yepi'tîi —ta'pî Jesusya. Mîrîrî ye'nen Jesus wîtî'pî to' pokonpe. Mîîkîrî erepamî ko'mannîpî tanne, aminke pra surarayamî' esa'ya tonpayamî' yarima'pî Jesus ponaya kai, to' wîtîto'pe. Ta'pî surarayamî' esa'ya to' pî': —Makatîi ipî': “ ‘Uurî sa'ne wanî î' pe pra rî arawîrî maasa pra uyentai amîrî wanî ye'nen, uyewî' ta eewomî eserîke pra nai’, taa pî' man” makatîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Moropai ‘anî' pe pra uurî wanî uutîto'pe aapia. Tîîse taaya yu'se wai miarî si'ma, amaimu ke upoitîrî esepi'tîto'pe ka'kî’, taa pî' man”, makatîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“ ‘Epu'tî pî' wai kure'ne uurî wanî tîîse uyesanon moro to' wanî uyentainonkon inkamoro maimu yawîrî tîwe'sen uurî. Moropai mîrîrî warantî nîrî uurî pemonkonoyamî' moro to' man surarayamî' umaimu yawîrî tîwe'sanon. Tauya ya tiwinan pî': “atîkî”, tauya ya, moropai attî umaimu pe. Tiaron pî': “asi'kî”, tauya ya, moropai aaipî uupia. Moropai tauya ya upoitîrî pî': “seeni' ku'kî”, tauya ya, moropai ikupîiya umaimu pe. Mîrîrî warantî nîrî ikupîya epu'tî pî' wai tamî'nawîrî î' taaya ya, amaimu pe awanî. Itentai pu'kuru awanî ye'nen’, taa pî' man”, makatîi —ta'pîiya to' pî'. Mîrîrî ye'nen to' wîtî'pî Jesus pia. Tamî'nawîrî ekaremekî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mîrîrî taasa' mîîkîrî warayo'ya eta tîuya pî' Jesus esenumenka'pî kure'ne. Mîîkîrî era'tî'pî arinîkon pemonkonyamî' winîkîi. Moropai ta'pîiya to' pî': —A'kî, tauya apî'nîkon. Amîrî'nîkon Israel ponkon, Paapa pemonkonoyamî' kore'ta sîrîrî warantî innape uku'nen era'masau'ya pra wai. Tîîse mîserî esa'ya uku'sa' man innape, ka'ran pe tîwanî tîîse —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mîrîrî tîpo mîîkîrî surarayamî' esa' narima'san enna'po'pî wîttî ta. Moropai inkamoroya mîîkîrî surarayamî' esa' poitîrî eporî'pî miarî pri'ya eesepi'tîsa' wanî'pî Jesus maimu pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tîko'man pe pu'kuru pra tîîko'mamî tîpo, Jesus wîtî'pî Naim cidaderî pona. Inenupa'san moropai tu'kankon pemonkonyamî' wîtî'pî nîrî ipokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mîrîrî cidade pona Jesus erepamî tanne, aminke pra tîîse, pemonkonyamî' epa'ka'pî, isa'manta'pî esa'rî'pî yaanenan. Mîîkîrî wanî'pî tiwinan ye' inyo isa'manta'pî wîri' more pe. Mîîkîrî pîkîrî arinîkon pemonkonyamî' mîrîrî cidade ponkon wîtî'pî uuruwai pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mîîkîrî sa'ne wîri' karau era'ma'pî Uyepotorîkonya tî'noko'pî pe. Mîrîrî ye'nen wîri' pî' ta'pîiya: —Tîkarawai pra e'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mîîkîrî yaponse' pia eerepamî'pî. Moropai itaponse' yapî'pîiya. Mîîkîrî yaanenan emî'pamî'pî. Moropai ta'pî Jesusya maasaron warayo' pî': —E'mî'sa'kakî tauya apî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mîrîrî taiya pe mîîkîrî isa'manta'pî e'mî'sa'ka'pî tîmaikko pona. Moropai eeseurîma pia'tî'pî. Moropai Jesusya isan pia irumaka'pî tepi'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mîrîrî era'ma tîuya'nîkon pî' tamî'nawîronkon pemonkonyamî' esenumenka'pî mararî pra Jesus namai'ma. Moropai inkamoroya Paapa yapurî'pî. Ta'pî to'ya: —Mîserî see kure'nan Paapa maimu ekareme'nen uurî'nîkon kore'ta aai'sa' sîrîrî. Paapa ii'sa' man tîpemonkonoyamî' pîika'tîi —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mîrîrî ku'sa' Jesusya yekare eta'pî mîrîrî Judéia patapon pemonkonyamî'ya. Moropai mîrîrî Judéia woi tîîko'mansenonkonya epu'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","João Batista nenupa'sanya tamî'nawîrî î' ku'sa' Jesusya ekaremekî'pî. Moropai Joãoya asakî'nankon tînenupa'san yanno'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Inkamoro yarima'pîiya Uyepotorîkon pia ekaranmapoi to' wîtîto'pe kai'ma, taato'pe to'ya: —“Amîrî manni' ˻ka' poi˼ tarîwaya aaipî ton anna nînîmîkî, tiaron ka'rî moro nai inîmîkî annaya manni'”, makatîi ipî' —ta'pî Joãoya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mîrîrî ye'nen to' wîtî'pî Jesus pia. Moropai ta'pî to'ya: —João Batistaya anna yarima pî' man ayekaranmapoi. Amîrî manni' tarîwaya eerepamî ton kaane ka'rî? Tiaron moro nai anna nînîmîkî? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mîrîrî taa to'ya tanne, tu'kankon ne'ne'kon pemonkonyamî' paran pokonkon yepi'tî'pî Jesusya. Moropai o'ma' yarakkîrî tîwe'sanonkon yapai o'ma'kon yenpa'ka'pîiya, moropai tu'kankon enkaru'nankon yenu yenponka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Moropai inkamoro maimu yuuku'pîiya. —Enna'potî moropai João pî' anera'ma'pîkon moropai aneta'pîkon mekareme'tîi. Makatîi ipî' see warantî: “Tarîpai enkaru'nankonya era'ma pî' man. Moropai asakoi pepîn asanî pî' man. Moropai erekî'pankon esepi'tîsa' man. Moropai pana'tî'pankonya eta pî' man. Moropai isa'manta'san e'mî'sa'kan pî' man. Moropai itekare Paapa winîpainon esekareme'sa' man î' ton pînon pî'”, makatîi, ˻penaron Isaías nurî'tîya taasa' yawîrî Paapa nîmenka'pî pî'˼ —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—Taatausinpai pemonkonyamî' wanî, manni'kan innape uku'nenan tîwî tîku'se pra. Moropai teesenumenkakon yawîrî pra unkupî pî' teesewankono'mai pra to' wanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","João Batista nenupa'san enna'po'pî tanne, Jesus eseurîma pia'tî'pî pemonkonyamî' pî' João yekare pî': —Keren pona attîsa'kon yai João yarakkîrî epose, î' era'ma'pîya'nîkon? Konoi' yepu ye' yari'mapîtî a'situnya ka'rî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","—Î' era'mai attî'pîkon kin warayo' epontîsa' ka'rî morî pe tîpon ya' era'mai? A'kî, tauya warayo' morî pe epontî'pî morî tîpon ya' mîîkîrî ko'mamî e'painon morî pu'kuru wîttî ta ipîkku pe tîwe'sen yewî' ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","—Ka'tî upî', î' era'ma'pîya'nîkon? Paapa maimu ekareme'nen profeta ka'rî. Inna, tauya sîrîrî apî'nîkon. Tîîse profeta Paapa maimu ekareme'nen yentainon era'ma'pîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Maasa pra mîîkîrî João wanî Paapa nîmenka'pî iipî rawîrî aaipîton pe, manni' Paapaya ta'pî yawîrî. A'kî, mîserî umaimu ekareme'nen yarimauya kupî sîrîrî arawîrî attîto'pe, aye'marî ton konekai e'mai' pe ta'pî Paapaya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Moropai Jesus eseurîma ko'mannîpî'pî: —Tauya amîrî'nîkon pî', mîîkîrî Paapa maimu ekareme'nen João wanî tamî'nawîronkon warayo'kon yentai tîwe'sen pe awanî. Tîîse anî'ya innape uurî kupî ya, mîîkîrî esa' pe Paapa wanî. Mîrîrî ye'nen ipîkku pe mîîkîrî wanî João yentai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mîrîrî taiya eta'pî tîniru yapisî pî' teesenyaka'masanonya moropai tamî'nawîronkon pemonkonyamî'ya. Inkamoro wanî'pî manni'kan yairî Paapa maimu wanî epu'nenan pe. Inkamoro wanî'pî João Batista nenpatakona'san pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tîîse fariseuyamî' moropai Moisés yeseru rî'pî pî' yenupatonkon wanî'pî Joãoya tenpatakonakon yu'se pra. Maasa pra itu'se Paapa e'to' kupî to'ya pra, yewanmîrî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mîrîrî pî' ta'pî Jesusya: —Anî'kan warantî see sîrîrî pankon pemonkonyamî' kupîuya e'painon? Î' kai'ma to' wanî? ");
INSERT INTO mbcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inkamoro wanî moreyamî' tîsu'minansenon warantî. Inkamoro wanî poro yi'pî po. Tiaronkon pî' to' entaimepîtî ko'mannîpî. “Manannîto' waiyi ye'nunpa'pî annaya tîîse amîrî'nîkon mananu pra awanî'pî”, taapîtî'pî to'ya. “Moropai isa'manta'pî kararunpato' kupî'pî annaya tîîse amîrî'nîkon karau pra awanî'pî”, taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Inkamoro moreyamî' ye'kakon amîrî'nîkon, sîrîrî pankon wanî. ˻Awakîrikon pe anî' ku'sa'ya'nîkon pepîn.˼ Maasa pra João Batista ii'sa' yai tekkari yonpa pra awanî'pî tiaronkon pemonkonyamî'ya yonpa warantî pra. Moropai tîwuku vinho enîrîiya pra awanî'pî. Mîîkîrî pî' taaya'nîkon: “O'ma'kon yarakkîrî tîwe'sen pe awanî mîrîrî”, taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Moropai uurî ka' poi iipî'pî entamo'ka ya, moropai uwuku enîrîuya ya taaya'nîkon upî': “A'kî, mîîkîrî warayo' kure'ne ta're' yonpanen. Moropai kure'ne tîwuku enî'nen, teetînsen” taaya'nîkon. “Moropai tîniru yapisî pî' teesenyaka'masanon yonpa mîîkîrî. Moropai pemonkonyamî' imakui'san pokonpe tîwe'sen mîîkîrî”, taaya'nîkon upî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tîîse tauya anî'ya Paapa winîpainon epu'nen yapisî ya mîîkîrîya yairî tîwanî epu'tî mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tiwin fariseuya Jesus eta'pî entamo'kai attîto'pe tewî' ta. Mîrîrî ye'nen Jesus wîtî'pî itewî' ta. Moropai teerepansa' pe eereuta'pî to' yaponse' pona takira' tekkari yonpai mesa pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mîrîrî yai miarî cidade po wîri' wanî'pî imakui'pî kupîtîpon. Mîîkîrîya Jesus entamo'ka yekare eta'pî mîîkîrî fariseu yewî' ta. Mîrîrî ye'nen mîîkîrîya tîkarapa a'pusin kara' yense' yarî'pî moropai attî'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mîîkîrî wanî'pî Jesus pai winî si'ma aminke pra tîkarau pî'. Moropai ikaruwato' ya' Jesus puu yamannîpî'pî itenu paruya. Moropai mîrîrî tîpo tîpu'pai si'po ke Jesus puu yamannî'sa' tîuya ya'mananîpî'pîiya. Moropai mîîkîrîya Jesus puu yu'napîtî'pîiya. Moropai mîrîrî tîkarapa a'pusin tînarî'pî kanpîtî'pîiya Jesus puu pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mîrîrî era'ma tîuya pe fariseu esenumenka'pî tîîwarîrî ta'pîiya: —Mîserî warayo' wanî ya innape profeta pe, anî' pe mîserî wîri' epu'tîiya e'painon. Imakui'pî kupîtîpon pe wanî epu'tîiya ya, ˻yai pra awe'rennuku tîrîiya pepîn e'painon tîîpia˼ —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mîîkîrî fariseu pî' Jesusya ta'pî: —Simão, apî' unekaremekî ton moro man —ta'pîiya. —Ka'kî moriya, uyenupanen —ta'pî Simãoya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Moropai Jesusya ta'pî: —Asakî'nankon warayo'kon wanî epe'mîra tiwinan warayo' pî'. Mîîkîrî tîniru esa'sa'ya itîînen pî' epe'mîra to' wanî'pî. Tiwinan ne'ma ton wanî'pî 500 prata ena'pî kaisarî. Moropai tiaron ne'ma ton wanî'pî 50 prata ena'pî kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tîîse tiwinanya ye'ma pra awanî'pî sa'nîrî si'ma ye'ma'pî to'ya e'painon teuren mîrîrî tînesatîpîkon. Mîrîrî kupî'pî mîîkîrî epe'mîra to' e'to'ya iipia tîwî, ye'ma to'ya namai, ta'pîiya. O'non ye'kaya tîwakîri pe ikupî'pî kure'ne? —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simãoya yuuku'pî: —Uurî pia manni' kure'ne panpî' epe'mîra tîwe'senya tîwakîri pe ikupî'pî, ye'makî taiya pra awanî ye'nen —ta'pî Simãoya. —Innape man, yairî taa pî' nai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mîrîrî taa tîpo Jesus era'tî'pî wîri' ekaya. Moropai ta'pîiya Simão pî': —Mîserî wîri' era'ma pî' nan? Ayewî' ta ewonsa' tanne, amîrîya tuna tîrî pra man u'pu ronato' ton. Tîîse mîserîya u'pu rona sîrîrî tîkarawato' ke, tenu paru ke. Moropai tîpu'pai si'po ke u'pu ya'mananî pî' man. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Moropai amîrîya uyu'na pra man ayewî' ta ewonsa' tanne. Tîîse mîserî wîri'ya yu'napîtî ko'mannîpî u'pu pî', ayewî' ta ewomî'pî pata pai. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Moropai amîrîya upu'pai pona akarapa yonpa tîrî pra man. Tîîse mîserî wîri'ya tîkarapa a'pusin kamo pî' man u'pu pona —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Tauya apî', mîîkîrîya kure'ne uyapurî esera'ma mîrîrî. Maasa pra kure'nan imakui'pî inkupî'pî kupîuya uuwanmîra. Tîîse manni' mararî uyapurînen mîîkîrî nîkupî'pî kupîuya uuwanmîra mararî, mararî uyapurîiya ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mîrîrî yai Jesusya wîri' pî' ta'pî: —Imakui'pî ankupî'pî kupî pî' wai uuwanmîra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mîrîrî eta tîuya'nîkon pe mesa po ereuta'san esekaranmapopîtî pia'tî'pî tîîwarîrî'nîkon. Ta'pî to'ya: —Anî' see mîserî mîîto'pe imakui'pî ku'nen tîîwanmîra kai'ma? ");
INSERT INTO mbcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tîîse Jesusya ta'pî wîri' pî': —Innape pu'kuru ukupîya ye'nen, imakui'pî ankupî'pî kupî pî' wai uuwanmîra. Mîrîrî ye'nen atîkî tîîwanmîra —ta'pî Jesusya wîri' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mîrîrî tîpo Jesus wîtîpîtî'pî patakon kaisarî morî yekare ekaremekî pinunpa'pîiya pemonkonyamî' pî'. Ta'pîiya: —Tîpemonkono pe ayapisîkon Paapaya sîrîrî, ayesa'kon pe tîwe'to'pe kai'ma to' pî' ekareme'pîtî'pîiya. Asakî'ne pu' pona tîîmo'tai'nîkon (12) Jesus nenupa'san wîtî'pî ipokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Moropai arinîkon wîri'sanyamî' Jesus nepi'tî'san wîtî'pî nîrî. Inkamoro wîri'sanyamî' kore'ta awanî'pî Maria Madalena. Mîîkîrî ya' asakî'ne mia' pona (7) kaisaronkon o'ma'kon ewonsa' wanî'pî. Tîîse Jesusya tîmeruntîri ke mîîkîrî yapai o'ma'kon yenpa'kasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Moropai Joana Herodes poitîrî Cuza no'pî nîrî wanî'pî to' kore'ta. Susana nîrî awanî'pî to' kore'ta moropai tiaronkon wîri'sanyamî' wanî'pî. Inkamoroya temannekon yonpa ke Jesus moropai inenupa'san pîika'tîpîtî'pî moropai to' ya're' ton tîrî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Moro to' tîîse arinîkon pemonkonyamî' emurukuntîsa' ko'mamî'pî Jesus eseurîma etakonpa kai'ma. Inkamoro ii'pîtî ko'mannîpî'pî tu'ke patakon yapai. Mîrîrî tanne inkamoro yenupa'pî Jesusya morî panton ke. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ta'pîiya to' pî': —Warayo' wîtî'pî tînmîri pînse. Mîîkîrîya tînmîri pîmî tanne inpîmî yonpa ena'pî e'ma ena pona. Mîrîrî yaki'tapa'pî pemonkonyamî'ya maasa aaro'ta pra tîîse. Moropai mîrîrî era'ma'pî toronyamî'ya moropai yenno'mapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Moropai tiaron inpîmî yonpa ena'pî mararon non tî' parappa po tîwe'sen pona. Mîrîrî aro'ta'pî tîîse aakaratato' pata'se' ton pra awanî'pî. Mîrîrî ye'nen awa'pi'ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Moropai tiaron ena'pî mî'nî ye' kore'ta. Mî'nî ye' pokonpe aarenta'pî. Moropai mîrîrî taruma'tî'pî mî'nî ye'ya. Mîrîrî ye'nen eepeta pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tîîse tiaron ena'pî morî non pona. Mîrîrî aro'ta'pî aarenta'pî, moropai eepeta'pî. Mararî pra eepeta'pî e'mai' pe awanî'pî yentai pu'kuru —ta'pî Jesusya. —Anepu'pai anî' wanî ya, etakî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inenupa'sanya ekaranmapo'pî: —Î' taa yu'se awanî sîrîrî morî panton ke anna pî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesusya yuuku'pî: —Paapa yeseru anepu'tîkon pepîn ekaremekîuya sîrîrî. Î' kai'ma awanî pe nai tamî'nawîronkon esa' pe Paapa iipî yai ekaremekîuya sîrîrî epu'tîkonpa. Tîîse Paapa yu'sankon pepîn pî' ekaremekîuya pepîn aronne. Tîîse panton pe neken ekaremekîuya moropai epu'tî to'ya pepîn ˻itu'se pra tîwanîkon ye'nen˼. Eta to'ya tîpanakon ke tîîse î' tîneta'pîkon epu'tî to'ya pepîn. Moropai era'ma to'ya tenukon ke tîîse î' pe tînera'ma'pîkon wanî epu'tî to'ya pepîn. kai'ma penaron Isaías nurî'tîya ekaremekî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ayeurîmauya'nîkon sîrîrî morî panton pî'. Manni' inpîmî wanî Paapa maimu warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Moropai inpîmî e'ma ena pona ena'san warantî pemonkonyamî' wanî. Paapa maimu eta to'ya tîîse ka'ne' pe Makui erepamî. Itekare to' neta'pî mo'kaiya to' yewan yapai, innape ikupî to'ya namai, moropai to' e'pîika'tî namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Moropai inpîmî tî' parappa pon non pona ena'san warantî tiaronkon pemonkonyamî' wanî. Paapa maimu eta to'ya moropai yapisî to'ya kure'ne taatausinpai. Mîî pîkîrî innape ikupî to'ya. Tîîse to' yewan ya' to' esenumenkato' ton pra awanî. Mîrîrî ye'nen innape iku'to' tîuya'nîkon wenai to' e'taruma'tîto' erepamî yai, tîneta'pîkon rumaka to'ya tiwinarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Moropai inpîmî mî'nî ye' kore'ta ena'san warantî tiaronkon wanî. Itekare eta to'ya tîîse to' yewan wanî kure'ne sîrîrî pata po tînkonekakon pî'. Moropai ipîkku pe pu'kuru temannekon ton yu'se to' wanî. Moropai sîrîrî non po taatausinpato'kon yu'se to' wanî. Mîrîrî ye'nen innape ikupî pî' to' ko'mamî pepîn. Inî' panpî' Paapa yeseru yu'se pra to' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tîîse inpîmî morî non pona ena'san warantî tiaronkon wanî. Itekare eta to'ya moropai innape ikupî to'ya tewankon ke. Inkamoro ko'mamî Paapa maimu yawîrî ikoneka. Mîrîrî ye'nen to' e'taruma'tîto' erepamî yai tîneta'pîkon rumaka to'ya pepîn. To' ko'mamî Paapa maimu yawîrî. Mîrîrî ye'nen to' yeseru wanî morî pe pu'kuru —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Inî'rî Jesusya sîrîrî panton ekaremekî'pî. —Anî'ya tî'kuma'tu yawittanîpî tîpo yenomî pepîn wari'sa' yo'koi —ta'pîiya. —Moropai itîrî pepîn nîrî we'nannîto' yaponse' yo'koi. Tîîse enepî itaponse' pona itîîto'pe aronne panpî' awe'to'pe tewonsenon weiyu'mato'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mîrîrî warantî tamî'nawîrî î' esenomî'pî e'naponka kupî sîrîrî tiwin wei. î' kai'ma epu'sa' pepîn esepu'tî kupî sîrîrî. Esenomî'pî esenpo kupî sîrîrî tamî'nawîronkonya epu'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mîrîrî ye'nen, aka. Tîwarî e'tî Paapa maimu etaya'nîkon pî'. Maasa pra imaimu anepu'painon wanî ya, Paapaya itîrî inî' panpî' epu'to'peiya. Tîîse anepu'painon pepîn wanî ya, epu'tîiya pepîn. Mararî ineta'pî ena kupî sîrîrî iiwanmîra, î' ton pra eena —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus yan moropai ita'mi'san erepamî'pî Jesus era'mapî'se teuren. Tîîse iipia to' e'rennuku eserîke pra awanî'pî maasa pra arinîke pemonkonyamî' wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mîrîrî tiwinanya ta'pî Jesus pî': —A'kî, asan moropai aya'mi'san man poro po ayuwa pî', ayarakkîrî teeseurîmakonpa —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tîîse Jesusya ta'pî tamî'nawîronkonya eta tanne: —Maama' tauya moropai mooyi tauya manni'kan innape Paapa maimu ku'nenan pî' moropai ikonekanenan pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tiaron wei yai Jesus asara'tî'pî tînenupa'san pokonpe kanau ya'. Moropai ta'pîiya to' pî': —Miarî'nîkon ruku'nî iku'pî ratai pona. Mîrîrî ye'nen to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mîrîrî iku'pî nuurukkutî tîuya'nîkon ye'ka pe, Jesus we'na'pî kanau ya'. Mîrîrî pe rî meruntî ke a'situn ata'se'ma pia'tî'pî iku'pî ka. Moropai kanau ya' to' e'to' yannîpî pia'tî'pî tuna ke. Nari' pe eena'pî tamî'nawîronkon mîrîrî kanau yawonkon pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mîrîrî ye'nen Jesus nenupa'sanya Jesus yenpaka'pî iwetun tanne. Ta'pî to'ya teesi'nî'se: —Anna yenupanen, sa'mantan pe man, tîînase. Mîrîrî taa to'ya ye'nen, Jesus e'mî'sa'ka'pî. Moropai ta'pîiya a'situn pî' moropai tuna pî': —Atî'napankî. Aatî'napamî'pî tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mîrîrî yai Jesusya ta'pî tînenupa'san pî': —Innape ukupîya'nîkon pra awanîkon sîrîrî. O'non pata innape uku'to'ya'nîkon nai? ˻Anî' pe wanî epu'tîya'nîkon pra naatî?˼ —ta'pîiya. Tîîse inkamoro esenumenkasa' wanî'pî, teesewankono'mai mararî pra teesi'nî'se. Moropai ta'pî to'ya tîîwarîrî'nîkon: —Î' ye'ka see warayo' mîserî, imaimu yawîrî a'situn moropai tuna e'to'. “Atî'napankî” taiya ya, aatî'napamî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","To' erepamî'pî Galiléia iku'pî ratai po tîwe'sen Gerasa pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Teerepansa'kon pe Jesus eseu'ka tanne kanau yapai, warayo' iipî'pî cidade poi iponaya epose. O'ma'kon ewonsa' wanî'pî mîîkîrî warayo' ya'. Pena pata pai aako'mansa' wanî'pî ipon ton pra. Wîttî ta awanî pra, aako'mansa' wanî'pî. Tîîse aako'manto' e'pîtî'pî uuruwai kore'ta e'tî'ka'san kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus era'ma tîuya pe mîîkîrî warayo' entaime'pî. Moropai awe'sekunka'pî Jesus rawîrî. Moropai ta'pîiya meruntî ke: —Jesus Paapa ka' po tîîko'mansen munmu amîrî. Î' ku'se aai'sa' uurî yarakkîrî? Esatîuya sîrîrî apî', uurî kî'taruma'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mîrîrî ta'pîiya maasa pra Jesusya o'ma' yenpa'kasa' ye'nen yapai. Tu'ke ite'ka yapi'pîtî'pî o'ma'ya. Mîrîrî ye'nen yewa'tîpîtî'pî to'ya i'pu pî' moropai itenya pî' sa'man ferro ke. Tîîse mîrîrî ya'tîpîtî'pîiya to' yentai awanî ye'nen. Moropai o'ma'ya yaapîtî'pî keren pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesusya mîîkîrî ekaranmapo'pî: —Anî' ayese'? —ta'pîiya. Yuuku'pîiya: —Uyese' tu'kan —ta'pîiya. Maasa pra tu'ke o'ma'kon ewomî'pî wanî'pî mîîkîrî warayo' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Moropai o'ma'konya ta'pî Jesus pî' mararî pra teka'nunkai apo' ya' tenumîiya'nîkon namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tu'kankon porcoyamî' wanî'pî tekkarikon yena'nenan ikîrî po aminke pra. Mîrîrî ye'nen o'ma'konya esatî'pî Jesus pî' porcoyamî' ya' teewomîkonpa kai'ma. Moropai inna ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mîrîrî ye'nen o'ma'kon epa'ka'pî mîîkîrî warayo' yapai. Moropai to' ewomî'pî porcoyamî' ya'. Mîrîrî pe rî porcoyamî' eka'tumî'pî irama yai. To' e'soroka'pî tuna ka. Moropai to' naarî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Warayo'kon porcoyamî' pî' teesenyaka'masanonya mîrîrî e'kupî era'masa' yai to' e'tîrîka'pî moropai mîrîrî yekare ekaremekî'pî to'ya cidade po, moropai iwoi tîîko'mansenon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mîrîrî ye'nen tu'kankon pemonkonyamî' wîtî'pî mîrîrî era'mai. Miarî ya teerepamîkon pe Jesus pia, warayo' era'ma'pî to'ya. Yapai o'ma'kon epa'ka'pî. To' esi'nîpî'pî ipî'. Maasa pra Jesus pia eereutasa' wanî'pî. Tîpon ke awanî'pî moropai morî pe, ayawî' pe pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tamî'nawîronkon mîîkîrî era'ma'tîponkonya mîrîrî ekaremekî'pî tiaronkon pemonkonyamî' pî' î' kai'ma warayo' esepi'tîsa'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mîrîrî wenai Gerasa pata ponkon ena'pî kure'ne eranne' pe. Mîrîrî ye'nen Jesus epa'kato'pe esatî'pî to'ya tîpatakon yapai. Moropai Jesus asara'tî'pî kanau ya' moropai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mîîkîrî warayo' o'ma'kon yenpî' esepi'tîsa'ya Jesus yeka'nunka'pî ipîkîrî tuutîpa kai'ma. —Uutî apîkîrî, Uyepotorî —ta'pîiya. Tîîse Jesusya yarima'pî. Ta'pîiya: ");
INSERT INTO mbcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Enna'pokî ayewî' ta. Moropai î' ku'sa' Paapaya mekaremekîi. Mîrîrî ye'nen mîîkîrî warayo' enna'po'pî tamî'nawîrî cidade poro î' ku'sa' Jesusya tîmîrî tonpe ekaremekî'pîiya pemonkonyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Inî'rî iku'pî ratai pona Jesus enna'posa' pe arinîkon pemonkonyamî'ya Jesus yapisî'pî kure'ne taatausinpai. Maasa pra tamî'nawîronkon wanî'pî inîmîkî pî' miarî si'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mîrîrî yai warayo' erepamî'pî itese' Jairo. Mîîkîrî wanî'pî Judeuyamî' epere'to' yewî' esa' pe tîwe'sen pe miarî. Mîîkîrî e'sekunka'pî Jesus pia moropai Jesus wîtîto'pe esatî'pîiya tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Maasa pra tiwinan ye' itensi asakî'nan pu' pona tîîmo'tai (12) kaisaron ikono po sa'manta ko'mannîpî ye'nen yepi'tîi attîto'pe. Jesus wîtî ko'mannîpî tanne e'ma taawîrî arinîkon iipî'pî iwenairî. Inkamoroya yatunnuku'pî arinîke tîwanîkon ye'nen, Jesus era'tî eserîke pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mîrîrî yai wîri' iipî'pî Jesus pia mîn kannen. Asakî'ne pu' pona tîîmo'tai kono' kaisarî mîn kamo pî' aako'mansa' wanî'pî. Tamî'nawîrî temanne tî'kasai'ya wanî'pî yepi'tî tonkon ye'ma pî' tîîse eesepi'tî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mîîkîrî iipî'pî Jesus poi winî pî'. Moropai mîîkîrîya ipon ye'pi pî' yapî'pî. Moropai mîrîrî pe rî mîn teeti'kansen asa'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesusya to' ekaranmapo'pî: —Anî'ya uyapî mîrîrî? —ta'pîiya. Tîîse, —Anî'ya ayapî pra man —ta'pî to'ya. Mîrîrî pî' Pedroya ta'pî: —Uyenupanen, arinîkon pemonkonyamî' man awoi. Tamî'nawîronkonya ayatunnuku pî' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tîîse Jesusya ta'pî: —Tîîse tiwinanya uyapî epu'tî pî' wai. Maasa pra meruntî epa'ka epu'tî pî' wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mîrîrî eta tîuya pe teesenomî eserîke pra awanî epu'tî'pî mîîkîrî wîri'ya. Mîrîrî ye'nen tîwe'kîkî'ma ye'ka pe aaipî'pî. Moropai awe'sekunka'pî Jesus pia. Tamî'nawîronkonya era'ma tanne moropai eesekaremekî'pî. Î' ton pe yapîsa' tîuya ekaremekî'pîiya. Moropai ka'ne' pe teesepi'tî epu'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mîîkîrî pî' Jesusya ta'pî: —Ma'non, innape ukupîya ye'nen eesepi'tîsa' sîrîrî. Tarîpai tîîwanmîra atîkî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Miarî maasa Jesus eseurîma tanne Jairo poitîrî erepamî'pî Jairo yewî' tapai. Moropai mîîkîrîya ta'pî Jairo pî': —Ayensi sa'mantan pî' man. Mîrîrî ye'nen uyenupanenkon wîtî yu'se awanî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mîrîrî eta'pî Jesusya. Moropai ta'pîiya Jairo pî': —Teesi'nî'se pra e'kî. Innape neken uku'kî. Moropai ayensi ennapamî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairo yewî' ta teerepansa' pe, tarakkîrî Pedro, João moropai Tiago ewomî tîrî'pîiya, moropai Jairo moropai wîri' yan, inkamoro neken. Tiaronkon ewomî tîrîiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mîrîrî tanne tamî'nawîronkon wanî'pî moro tîkaraukon pî' tîwentaimepîtîkon pî', mîîkîrî wîri' sa'mantasa' pî'. Inkamoro pî' ta'pî Jesusya: —Tîkauware pra e'tî. Wîri' sa'mantasa' pra man. Iwe'nasa' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mîrîrî taiya eta tîuya'nîkon ye'nen tamî'nawîronkon siira'pî ipî'. Maasa pra aasa'mantasa' epu'tî tîuya'nîkon ye'nen. Ta'pî to'ya: —Î' tonpe aasa'mantasa' era'ma ye'ka pe mîrîrî taiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tîîse Jesus wîtî'pî iipia. Moropai yapisî'pîiya itenya pî'. Moropai ta'pîiya meruntî ke: —Ma'non, e'mî'sa'kakî, kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ka'ne' pe mîîkîrî ennapamî'pî. Enen eena'pî. Moropai awe'mî'sa'ka'pî. Moropai tekkari ton tîîto'pe to'ya ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mîîkîrî yuntonon esenumenkasa' wanî'pî kure'ne. Tîîse Jesusya ta'pî ekaremekî to'ya namai tiaron pî' mîrîrî tînkupî'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mîrîrî tîpo Jesusya tînenupa'san yanno'pî tîîpia. Asakî'ne pu' pona tîîmo'tai'nîkon yanno'pîiya. Moropai inkamoro pia tîmeruntîri tîrî'pîiya tîmaimu pe tamî'nawîrî o'ma'kon pemonkonyamî' ya' tîwe'sanon yenpa'kato'pe to'ya ikupî'pîiya. Moropai pri'yawonkon pepîn yepi'tîto'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Moropai to' yaipontî'pîiya. Tamî'nawîronkon esa' pe Paapa iipî kupî ekareme'to'pe to'ya pemonkonyamî' pî'. Moropai pri'yawonkon pepîn yepi'tîto'pe to'ya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Inkamoro pî' ta'pî Jesusya: —Attîkon pe î' rî kîsatî. Ame'sipukon ton kîsatî. Aya're'kon ton kîsatî, asakunikon ton kîsatî. Moropai atînirurîkon ton kîsatî. Moropai tu'ke aponkon ton kîsatî tîîse tiwin aponkon maatîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Moropai miarî pemonkonyamî' kore'ta eerepansa'kon ya, morî pe ayapisîkon wîttî esa'ya ya, moro mako'mantîi mîrîrî wîttî ta, miarî pai awenna'pokon pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tîîse morî pe ayapisîkon pemonkonyamî'ya pra awanî ya, miarî tîpatakon ya', ka'ne' pe mepa'katîi miarî pai. Moropai eepa'kakon pe a'pukon pî' atapisî'pî non mîsorokatîi. Mîrîrî kupîya'nîkon ya Paapa maimu yu'se pra to' wanî ye'nen Paapaya to' taruma'tî pe man ekaremekîya'nîkon mîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mîrîrî tîpo inenupa'san ese'ma'tî'pî. Moropai tamî'nawîrî cidadekon poro to' wîtî'pî Paapa maimu ekaremekî pinunpa'pî to'ya. Moropai pri'yawonkon pepîn yepi'tî pinunpa'pî to'ya tamî'nawîrî patakon poro. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mîrîrî yai Galiléia pata esa' pe Herodes wanî'pî. Mîîkîrîya tamî'nawîrî î' ku'sa' Jesusya eta'pî miarî. Mîrîrî ye'nen î' kai'ma teesenumenka epu'tîiya pra awanî'pî. Maasa pra tiaronkonya taapîtî'pî ipî': —João Batista nurî'tî e'mî'sa'kasa' —taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Moropai tiaronkonya taapîtî'pî: —Elias nurî'tî esenposa' mîrîrî —taapîtî'pî to'ya. —Manni' mîîkîrî penaron Paapa maimu ekareme'nen profeta nurî'tî e'mî'sa'kasa' mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mîrîrî pî' ta'pî mîîkîrî pata esa' Herodesya: —Tîîse uurî mîîkîrî João pîmîrîkkîtî me'po'tîpon —ta'pîiya. —Tîîse anî' pe mîîkîrî warayo' wanî sîrîrî. Ipî' to' eseurîma eta pî' wai —ta'pîiya. Moropai Jesus anera'mapai pata esa' Herodes wanî'pî kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mîrîrî tîpo Jesus nenupa'san enna'po'pî iipia. Moropai tamî'nawîrî î' ku'sa' tîuya'nîkon ekaremekî'pî to'ya ipî'. Mîrîrî tîpo tînenupa'san pokonpe Jesus wîtî'pî Betsaida itese' pata pemonkonyamî' ko'manto' pona. Arinîkon pemonkonyamî' piapai to' wîtî'pî tîmîrî'nîkon pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tîîse arinîkon pemonkonyamî'ya o'non pata Jesus wîtî'pî epu'tî'pî. Moropai to' wîtî'pî ite'ma'pî pî'. Moropai miarî Jesusya to' yapisî'pî morî pe pu'kuru. Mîîkîrîya to' yeurîma'pî. Î' kai'ma tamî'nawîronkon esa' pe Paapa iipî kupî pî' to' yeurîma'pîiya. Moropai pemonkonyamî' pri'yawonkon pepîn yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mîrîrî tanne pata ko'mamî'pî. Ko'mamîiya eena'pî. Mîrîrî ye'nen asakî'ne pu' pona tîîmo'tai'nîkon inenupa'san wîtî'pî iipia. Moropai ta'pî to'ya ipî': —Insamoro arinîkon pemonkonyamî' yarimakî to' wîtîto'pe wîttîkon ta pemonkonyamî' kore'ta, aminke pu'kuru pra man tarîpai —ta'pî to'ya. —Miarî tîwanîkon ya, ta're'kon ton eporî to'ya e'painon. Moropai tîpata'se'kon ton eporî to'ya nîrî. Maasa pra sîrîrî pata ya' keren po e'nî man. Tarî î' ton pra man —ta'pî inenupa'sanya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesusya inkamoro maimu yuuku'pî: —Amîrî'nîkonya to' yekkari ton tîrî e'pai man —ta'pîiya to' pî'. Tîîse yuuku'pî to'ya: —Tîîse mia'taikin neken anna pia pão man. Moropai asakî'ne neken moro'yamî' man. Tamî'nawîronkon pia itîrîiya pepîn —ta'pî to'ya. —Inî' panpî' to' yekkari ton yennai anna wîtî yu'se awanî mîrîrî? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Inkamoro pemonkonyamî' wanî'pî arinîke, 5.000 yairî warayo'kon. Moropai Jesusya tînenupa'san pî' ta'pî to' ereutato'pe taato'pe to'ya iponarî'ne 50 kaisarî'ne ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesus maimu yawîrî ikupî'pî inenupa'sanya. Moropai tamî'nawîronkon yaipontî'pî to'ya to' ereutato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mîrîrî tîpo Jesusya mia'taikinan pão trigo puusa' yapisî'pî, moropai asakî'nankon moro'yamî'. Moropai ka' ekaya tenu yanumî'pîiya. Moropai mîîkîrî epîrema'pî. Mîrîrî yekkari wanî pona Paapa esatî'pîiya. —Morî pe man —ta'pîiya. Moropai mîrîrî tîpo pão pirikkapîtî'pîiya tînenupa'san pia, mîrîrî tîîto'pe to'ya inkamoro pemonkonyamî' kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mîrîrî pî' tamî'nawîronkon asa're'tî'pî, kure'ne itu'se tîwanîkon pîkîrî. Tîîse to' ya're' yonparî'pî e'kupî'pî. Mîrîrî yannuku'pî Jesus nenupa'sanya asakî'ne pu' pona tîîmo'tai (12) waikara'pî kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tiaron pensa Jesus epîrema tanne tiwinsarî, inenupa'san erepamî'pî iipia. Mîîkîrîya to' ekaranmapopîtî'pî: —Anî' pe rî see ukupî pî' pemonkonyamî' nai? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mîîkîrî maimu yuuku'pî to'ya: —Tiaronkonya taa “João Batista nurî'tî e'mî'sa'kasa' mîîkîrî” taa to'ya. Tiaronkonya taa: “Penaron itekare ekareme'pîtîtîpon Elias e'mî'sa'kasa' mîîkîrî”, taa to'ya. Moropai tiaronkonya taa, “Penaron Paapa maimu ekaremekîtîpon profeta yekatono'pî e'mî'sa'kasa' mîîkîrî”, taa to'ya apî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Moropai Jesusya ta'pî to' pî': —Amîrî'nîkon kanan? Anî' taa pî' naatî upî'? Mîîkîrî maimu yuuku'pî Pedroya: —Amîrî Paapa nîmenka'pî pîika'tîton, Cristo amîrî —ta'pî Pedroya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Inna, seru' pepîn, tîîse maasa Paapa narima'pî pe uurî wanî kîsekareme'tî anî' pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Moropai Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Ka' poi iipî'pî uurî e'taruma'tî e'pai awanî kure'ne. Teepîremasanon esanonya uyewanmarî e'pai awanî moropai Moisés yeserurî'pî pî' yenupatonkonya uyewanmarî e'pai awanî kupî sîrîrî. Inkamoro ena e'pai awanî uyu'se pra, uusa'manta e'pai awanî mîrîrî wenai. Tîîse e'mî'sa'ka e'pai awanî iteseurîno weiyu yai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Moropai Jesusya ta'pî tamî'nawîronkon pî': —Uwanîyakon pe e'pai anî' wanî ya, wei kaisarî itu'se tîwe'to' rumakaiya e'pai awanî, tîîwarîrî teesenumenkai. Moropai uwanîyakon pe tîwanî wenai e'taruma'tînto' namapai pra e'pai awanî, isa'mantato' namapai pra e'pai awanî tîîse uwenairî aaipî e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tîîse anî'ya tîîko'manto' pînînma ya kure'ne, tîwe'taruma'tî namaiya. Mîrîrî ye'nen Paapa pia ipatîkarî tîîko'manto' ton eporîiya pepîn. Tîîse aminke aako'mamî Paapa pî'. Tîîse uwanîyakon pe tîwanî wenai tîîko'manto' pînînma pra awanî ya, tîwe'taruma'tîto' yapîtanîpîiya ya, ipatîkarî enen tîîko'manto' ton eporîiya Paapa pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—A'kî, tamî'nawîron sîrîrî non pon yemanne esa' pe anî' ena ya, tîîse ipatîkarî enen tîîko'manto' ton eporîiya pra awanî ya, eporîiya kupî pepîn rî mîrîrî. Tîîsa'manta yai tekaton yepe' ton eporîiya pepîn. Awe'pîi'ka'tî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jesusya ta'pî: —Anî' eppepî ya upî', moropai umaimu esenupanto' pî', uurî ka' poi iipî'pî eppepî ipî'. Î' pensa inî'rî uuipî weiyu yai uya'karu ke ipîkku pe, Paapa ya'karu ke yarakkîrî uuipî yai, moropai morîkon inserîyamî' pokonpe uuipî yai eppepî ipî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Inna pî' rî tauya apî'nîkon. Tamî'nawîronkon esa' pe Paapa iipî pe man. Î' kupîiya era'ma amîrî'nîkon yonpayamî'ya tîîsa'mantakon rawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tiwin semana teeseurîmasa' tîpo, Jesus wîtî'pî kawînan wî' pona. Tînenupa'san Pedro moropai Tiago moropai João pokonpe attî'pî epîremai. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Miarî eepîrema tanne Jesus yenpata etinyaka'ma'pî. Moropai ipon etinyaka'ma'pî aimutun pe pu'kuru. Moropai inke' pe eena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mîrîrî pe rî asakî'nankon warayo'kon esenpo'pî iipia. Inke' pe inkamoro wanî'pî, ka' ponkon warantî. Inkamoro yarakkîrî eeseurîma'pî. Inkamoro wanî'pî Moisés nurî'tî pe moropai Elias pe. Inkamoro penaronkon eseurîma Jesus yarakkîrî. Î' kai'ma aasa'manta kupî pî' Jerusalém po pena Paapaya ta'pî yawîrî awe'kupî kupî ekaremekî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mîrîrî tanne inkamoro Pedro moropai tiaronkon Jesus nenupa'san wanî'pî iwe'nunpai. Mîrîrî ye'nen to' we'na'pî. Moropai mîrîrî tîpo to' paka'pî. Mîrîrî yai Jesus era'ma'pî to'ya. A'ka pe pu'kuru awanî'pî. Moropai inkamoro asakî'nankon warayo'kon iipia tîwe'sanon nîrî era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mîrîrî tîpo inkamoro wîtî'pî tanne Jesus piapai, Pedroya ta'pî Jesus pî': —Uyenupanen, morî pe pu'kuru e'nî sîrîrî tarî. Mîrîrî ye'nen eseurîwî'ne tappîi ton koneka annaya sîrîrî. Amîrî ton tiwin, moropai Moisés ton tiwin, moropai Elias ton nîrî tiwin —ta'pîiya. Tîîse î' taa tîuya pe awanî epu'tîiya pra Pedro wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eeseurîma tanne katupuruya to' napontî'pî. Inkamoro Jesus nenupa'san ena'pî eranne' pe katupuru iipî ye'nen tîpona'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inkamoroya Paapa eseurîma eta'pî katupuru kore'ta si'ma. Ta'pî Paapaya: —Mîserî unmu wanî unmenka'pî pe pu'kuru. Mîrîrî ye'nen eeseurîmato' imaimu etatî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Paapa eseurîma ataretî'ka pe Jesus era'ma'pî to'ya tiwinsarî. Mîrîrî tînera'ma'pîkon ekaremekî to'ya pra awanî'pî anî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tiaron wei yai wî' poi tîwautîkon pe arinîkon pemonkonyamî' epere'sa' era'ma'pî to'ya. Jesus yarakkîrî esepopai tîwanîkon ye'nen iipî'san. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Miarî tiwin warayo' wanî'pî to' kore'ta. Mîîkîrî entaimepîtî pia'tî'pî. Ta'pîiya: —Uyenupanen, apî' tauya sîrîrî tiwinan ye' sa'ne unmu yepi'tîya yu'se wanî ye'nen —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","—O'ma' ewonsa' man ya'. Moropai eporîiya ya ka'ne' pe more entaime. Moropai yai attî, eesenumî non pona inta arakkunta. Moropai o'ma'ya yenunpîtî yaki'tapapîtîiya. Ka'ne' pe irumakaiya pepîn —ta'pî itunya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—Anenupa'san pî' ta'pîuya o'ma' yenpa'kato'pe to'ya kai'ma tîîse yenpa'ka to'ya eserîke pra awanî'pî. Mîrîrî warantî rî aako'mamî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesusya mîîkîrî maimu yuuku'pî: —Sîrîrî pankon pemonkonyamî', makui nenku'tî'san, innape uku'nenan pepîn. O'non pîkîrî uuko'mamî e'painon akore'ta'nîkon? O'non pîkîrî amîrî'nîkon yapîtanîpîuya e'painon? Moriya ene'kî —ta'pî Jesusya mîîkîrî more yun pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mîîkîrî more enepî itunya tanne, Jesus pia mîîkîrî o'ma'ya yenumî'pî non pona. Moropai awe'perenperenma'pî non pona. Inta arakkunta'pî. Mîîkîrî pî' Jesus eseurîma'pî eepa'kato'pe kai'ma. Eepa'ka'pî moropai more esepi'tîsa' wanî'pî. Mîîkîrî more rumaka'pî Jesusya itun pia pri'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mîrîrî kupî Jesusya era'matîponkon tamî'nawîronkon pemonkonyamî' wanî'pî kure'ne teesenumenkai. Paapa meruntîri ke ikupî Jesusya era'ma tîuya'nîkon ye'nen. Tamî'nawîronkon esenumenkasa' era'ma tîuya ye'nen Jesusya tînenupa'san pî' ta'pî: ");
INSERT INTO mbcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Aawanmîra'nîkon kînanen î' tauya manni' pî'. Ka' poi iipî'pî uurî rumaka to'ya kupî sîrîrî, tesanonkon yenya' uwîto'pe to'ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tîîse î' taa Jesusya epu'tî to'ya pra awanî'pî. Maasa pra eenonsa' pe awanî'pî epu'tî to'ya namai. Mîrîrî ye'nen eranne' pe to' wanî'pî anekaranmapopai pra to' wanî'pî î' taa to'pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus nenupa'san e'ku'pîtî'pî tonpakon yentai tîwanîkon kai'ma. Mîrîrî ye'nen to' eseurîma'pî tîîwarîrî'nîkon mîrîrî pî': —Uurî wanî ipîkku pe panpî' —ta'pî tiaronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tîîse Jesusya mîrîrî to' eseurîmato' epu'tî'pî î' kai'ma to' esenumenkato'. Mîrîrî ye'nen Jesusya si'mîrikkî more yapisî'pî itenya pî' moropai yarî'pîiya tîîpia to' kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Moropai ta'pîiya: —Anî'ya mîserî more yapisî ya, tîwakîri pe pu'kuru uyapurî tîuya ye'nen, uurî nîrî yapisîiya morî pe. Moropai uurî yapisîiya ya, manni' warantî nîrî uyarimatîpon Paapa yapisîiya —ta'pî Jesusya. —Maasa pra mîîkîrî ama're'nîkon tîwe'sen mîîkîrî wanî kupî sîrîrî kure'ne, moropai ipîkku —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Moropai Joãoya ta'pî Jesus pî': —Uyenupanen, warayo' era'ma'pî annaya o'ma'kon yenpa'kanen amaimu pe. Tîîse mîîkîrî pî' ta'pî annaya inî'rî mîrîrî warantî kîkai mîîkîrî ye'ka pî'. Maasa pra anna yonpa pe awanî pepîn, tiaron mîîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Imaimu yuuku'pî Jesusya: —Kaane, mîrîrî kîkakî tîkai pra e'kî. Maasa pra awinîkîi î' rî kupîiya pepîn mîrîrî, tîîse morî kupîiya mîrîrî amîrî'nîkon ton pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka' pona Jesus yaato' Paapaya weiyu eseporî ko'mannîpî tanne Jesus esenumenka'pî Jerusalém pona tuutî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mîrîrî ye'nen e'mai' pe tînenupa'san yonpa yarima'pîiya to' wîtîto'pe kai'ma Samaritanoyamî' pata'se' ya'. Moropai to' erepamî'pî miarî ya Jesus pata'se' ton ekaranmapoi. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tîîse itîrî Samaria ponkonya pra awanî'pî. Maasa pra Jerusalém pona Jesus wîtî epu'tî'pî to'ya mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesus pata'se' ton tîrî to'ya pra awanî ye'nen, Tiagoya moropai Joãoya Jesus pî' ta'pî: —Anna yepotorî, anna epîrema yu'se nan Paapaya apo' yarimato'pe insamoro Samaria ponkon po'tîi? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mîrîrî taa to'ya ye'nen Jesus era'tî'pî to' winîkîi moropai to' maimu iwa'tî'pîiya. —Maasa pra pemonkonyamî' tî'kai uui'sa' pra wai —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mîrîrî tîpo to' wîtî'pî tiaronkon pemonkonyamî' kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mîrîrî tîpo tînenupa'san pokonpe Jesus wîtî tanne e'ma taawîrî, tiwinan warayo'ya ta'pî Jesus pî': —Awenairî uutî o'non poro attî manni' yairî uutî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesusya mîîkîrî maimu yuuku'pî: —A'kî, uwenairî ii'pai awanî ya aaipî tîîse sa'me awanî. Maasa pra maikanyamî' yeutta mororon, mîrîrî ya' to' erî'kapî. Moropai toronyamî'ya tî'moikon yenpoto' yaponse' nîrî mororon. Tîîse uurî ka' poi iipî'pî uyewî' ton pra man —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Moropai Jesusya ta'pî tiaron warayo' pî': —Aase uwenairî —ta'pîiya. Tîîse mîîkîrîya ta'pî: —Uyepotorî, maasa e'mai' pe uyun sa'manta tanne. Yu'na'tîuya tîpo uutî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mîîkîrî maimu yuuku'pî Jesusya: —Tîwî inkamoro innape umaimu ku'nenan pepînya mîîkîrî isa'manta'pî yu'na'tî —ta'pîiya. —Tîîse amîrî wîtî yu'se wai moropai î' kai'ma tamî'nawîronkon esa' pe Paapa wanî ekaremekîya yu'se wai —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Moropai tiaron warayo'ya ta'pî Jesus pî': —Awenairî uutî, Uyepotorî. Tîîse maasa e'mai' pe uyonpayamî' pî' esekareme'se uutî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mîîkîrî maimu yuuku'pî Jesusya. Ta'pîiya: —Anî' esenyaka'ma ya sanpa ke, mîîkîrî esenyaka'ma e'pai awanî tîrumakai pra yaretî'ka tîuya pîkîrî. Mîrîrî warantî mîîkîrî esenyaka'ma ya, Paapa maimu ekaremekî pî' eesenyaka'ma ko'mannîpî e'pai awanî, penaro' teserurî'pî pî' tîwenpenatai pra. Tîîse mîîkîrî enna'po ya, ite'ma'pî pî', î' pe pra rî awanî Paapa itesa' pia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mîrîrî tîpo Uyepotorîkonya tiaronkon 72 kaisarî warayo'kon menka'pî tînaipontîtonkon. Moropai inkamoro yaipontî'pîiya asakî'ne'ne patakon kaisarî. Cidadekon poro to' wîtîto'pe tîrawîrî o'non poro tuutîto' yairî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Moropai inkamoro yaipontî'pîiya. To' yaipontî pe ta'pîiya: —Tu'ke to' man umaimu anetapainokon, tîîse umaimu ekareme'nenan wanî tu'ke pra mararî pra umî yawon emîsa' warantî, tîîse ipî' teesenyaka'masanon man mararî, imo'ka to'ya eserîke pra. Mîrîrî ye'nen esa'tî mîîkîrî umî esa' Paapa pî' tiaronkon teesenyaka'masanontonkon yarimato'peiya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Inkamoro pî' ta'pîiya: —Atîtî see, uurîya ayarimakon sîrîrî. Ayarimauya'nîkon sîrîrî nari'kon kore'ta. Carneiro munkîyamî' yeka'ma warantî kaikusiyamî' kore'ta ayarimauya'nîkon sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Attîkon pe kanan î' rî kîsatî. Ayette'kon yense' asakunikon kîsatî. Moropai a'sa'sakon kîsatî. Moropai anî'rî eposa'ya'nîkon ya e'ma ta, mîîkîrî yarakkîrî kure'ne kîseurîmatî. Tîîse teesemi'tapai matîtîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Miarî ya eerepansa'kon ya wîttî ta eewomîkon pe makatîi e'mai' pe: “Paapaya tîwanmîn tîrî yu'se wai sîrîrî wîttî ta”, makatîi —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","—Morî pe pu'kuru mîrîrî wîttî tawon warayo' wanî ya, tîwanmîn yapisîiya Paapa winîpai. Tîîse morî pe pra mîîkîrî warayo' wanî ya, yapisîiya pepîn. Tîîse amîrî'nîkonya yapisî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Morî pe aako'mamîkon ya mîrîrî wîttî ta. Tîîse moro mako'mantîi aya're'kon monpatîi moro, awukukon menî'tîi moro, î' rî tîrî to'ya ya aapia'nîkon. Maasa pra teesenyaka'masenya teesenyaka'ma'pî yepe'pî yapisî e'pai awanî. Mîrîrî ye'nen moro mako'mantîi tiwinan wîttî ta tiaron ta tîmo'tapî'se pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cidade pona eewomîkon ya, miarî morî pe ayapisîkon to'ya ya, moro aya're'kon monpatîi to' kore'ta, î' rî tîrî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Moropai miarî cidade po pri'yawonkon pepîn mepi'tîtîi. Moropai makatîi miarî ronkon pemonkonyamî' pî': “Aapia'nîkon Paapa nîtîrî erepannî pî' man. Ayesa'kon pe Paapa ko'manto'pe eturumakatî itenya',” makatîi to' pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Tîîse morî pe ayapisîkon to'ya pra awanî ya, miarî cidade po, moriya mepa'katîi e'ma ta. Moropai makatîi: ");
INSERT INTO mbcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Itekare anetapai pra awanîkon ye'nen, anna epa'ka sîrîrî apatakon piapai. A'kî, anna puu pî' atapisî'pî non apatakon yawon pa'tî annaya sîrîrî. Sîrîrî kupî annaya itekare yu'se pra awanîkon ekareme'nen pe. Tîîse sîrîrî epu'tî, Paapaya ataruma'tîkon kupî sîrîrî. Maasa pra aminke pra tamî'nawîronkon esa' pe Paapa ii'to' eseporî kupî sîrîrî. Tîpemonkonoyamî' pîika'tîiya kupî sîrîrî” makatîi to' pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Moropai inî'rî ta'pî Jesusya: —Ayenku'tîuya'nîkon pepîn. Tiwinano'pî wei yai, tamî'nawîronkon yenumî Paapaya yai, mîrîrî cidade ponkon taruma'tîiya kupî sîrîrî kure'ne manni'kan penaronkon Sodoma ponkon taruma'tî'pî tîuya yentai. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesus eseurîma ko'mannîpî'pî: —Aka sa'ne Corazim cidaderî ponkon pemonkonyamî'. Aka sa'ne Betsaida cidaderî ponkon, innape ukupîya'nîkon pra awanîkon sîrîrî tîpose. Teuren kure'ne î' ikupî eserîkan pepîn e'kupî'pî apatakon ya'. Tîîse innape ukupîya'nîkon pra awe'sa'kon. Sîrîrî mîrîrî ye'ka e'ku'sa' ya Tiro cidaderî po, moropai Sidom cidaderî po, miarî ronkon pemonkonyamî'ya tîmakuyikon rumaka'pî e'painon pena. Mararî pra tîmakuyikon pî' to' esewankono'ma e'painon, saaku ya' teepontîi moropai runu'pî ke teekî'pai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Tamî'nawîronkon yenumî Paapaya weiyu yai eesewankono'makon kupî sîrîrî mararî pra. Tiro cidaderî ponkon pemonkonyamî' esewankono'ma'pî yentai. Moropai Sidom ponkon e'taruma'tî'pî yentai amîrî'nîkon e'taruma'tî kupî sîrîrî. Maasa pra innape imaimu ku'sa'ya'nîkon pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aka sa'ne Cafarnaum ponkon pemonkonyamî' ka' pona attîkon kai'ma eesenumenkakon, tîîse attîkon pe pra naatîi amakuyikon wenai. Mîrîrî wenai apo' ya' Paapaya ayenumîkon kupî sîrîrî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Moropai ta'pî Jesusya tînenupa'san 72 kaisaronkon pî': —Anî'kanya amaimukon eta ya, morî pe umaimu eta to'ya mîrîrî. Tîîse anî'kanya ayewanmîrîkon ya, inkamoroya uyewanmîrî nîrî mîrîrî. Moropai uyewanmîrînenanya nîrî Paapa uyarimatîpon yewanmîrî mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Moropai inkamoro 72 kaisaronkon warayo'kon itî'san enna'po'pî Jesus pia kure'ne pu'kuru taatausinpai. Moropai inkamoroya ekaremekî'pî Jesus pî'. —O'ma'kon wanî'pî anna maimu yawîrî. Maasa pra “Jesus maimu pe epa'katî pemonkonyamî' yapai”, ta'pî annaya. Mîrîrî ye'nen to' epa'ka'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mîrîrî yuuku'pî Jesusya: —Inna, mîrîrî warantî awanî maasa pra ka'ne' pe wara'napi e'sisiuka warantî, ka' poi Makui enasa' era'ma'pîuya, ˻imeruntîri yentai Paapa wanî ye'nen˼ —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—Maasa pra Uurîya pu'kuru meruntî tîrî'pî aapia'nîkon, ye'katon îkîi yaki'tapakonpa kai'ma, umaimu pe, moropai yeki'katon mari'tî yaki'tapakonpa. Moropai tamî'nawîron imakui'pî ku'nenan awinîkîi'nîkon yentai pu'kuru awanîkonpa umaimu pe. Amoronkon epu'tîya'nîkon namai meruntî tîrî'pîuya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tîîse mîrîrî pî' taatausinpai pra e'tî. Amaimukon pe o'ma'kon epa'ka pî' katausinpatî. Tîîse tauya apî'nîkon, ka' po ayese'kon menukasa' Paapaya man morî pe aako'mamîkonpa, mîrîrî pî' atausinpatî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mîrîrî tîpo Morî Yekaton Wannî meruntîri yarakkîrî Jesus wanî'pî kure'ne taatausinpai. Mîrîrî ye'nen ta'pîiya: —Uyepotorî Paapa, uyun, amîrî ka' esa' tîwe'sen. Moropai non esa' pe tîwe'sen. Morî pe man tauya apî'. Maasa pra epu'nen awe'to' anonamî'pî yenposa'ya epu'nenan pepînya epu'to'pe. Epu'nen pe tîwe'sanon piapai imo'ka'pîya itîrîpa pakko pe tîwe'sanon pia, moreyamî' warainokon pia. Mîrîrî pî' morî pe man tauya, Paapa. Mîrîrî warantî imenka'pîya moropai mîrîrî kupî'pîya. Maasa pra mîrîrî ku'sa'ya itu'se awanî ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Inî'rî ta'pî Jesusya: —Uyunya tamî'nawîron tîîsa' man uupia. Moropai anî'ya anî' pe wanî epu'tî pra man. Tîîse Uyunya neken epu'tî. Moropai anî'ya uyun epu'tî pra man. Tîîse uurîya neken epu'tî. Moropai anî' pe uyun wanî ekaremekîuya manni'kan epu'tî to'ya yu'se uurî e'to'kon pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mîrîrî taa tîpo, tînenupa'san era'ma'pî Jesusya. Moropai ta'pîiya teken neken to', tîîse arinîkon kore'ta pra. —Amîrî'nîkon nera'ma era'manenan wanî taatausinpai pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Maasa pra tauya sîrîrî apî'nîkon. Tu'kankon Paapa maimu ekareme'nenan profetayamî' nurî'tîya, moropai ipîkkukon pata esanon reiyamî'ya, mîrîrî anera'ma'pîkon anera'mapai to' wanî'pî teuren, tîîse era'ma to'ya eserîke pra awanî'pî. Moropai mîrîrî aneta'pîkon anetapai to' wanî'pî teuren, tîîse eta to'ya pra to' wanî'pî —ta'pî Jesusya tînenupa'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tiaron pensa warayo' Moisés yeserurî'pî pî' yenupaton e'mî'sa'ka'pî moropai Jesus ekaranmapo'pîiya maasa pra epu'nen pe awanî anepu'pai awanî'pî. Mîrîrî ye'nen ta'pîiya: —Uyenupanen, O'non ye'ka pe see ipatîkarî enen uuko'manto' ton eporîuya e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mîîkîrî maimu yuuku'pî Jesusya: —Î' kai'ma see Paapa maimu e'menukasa' mîrîrî epu'tî pî' nan? Î' kai'ma see ekareme'nen amîrî? —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mîîkîrîya ta'pî: —Taiya see warantî: Ayepotorî Paapa yapurîkî ayewan ke, moropai tamî'nawîrî eesenumenkato' ke. Moropai ameruntîri ke yapurîkî. Moropai tamî'nawîrî epu'to'ya ke yapurîkî, Ayonpa sa'namakî awe'sa'nama manni' warantî, taiya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mîîkîrî pî' ta'pî Jesusya: —Inna, yairî taa pî' nai. Moriya mîrîrî ku'kî. Mîrîrî kupîya ya, yairî enen aako'manto' ton eporîya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Moropai warayo'ya Jesus ekaranmapo'pî maasa pra ta'pî tîuya manni' yawîrî pra tîwanî epu'tî tîuya ye'nen. Ta'pîiya: —Anî' kin mîîkîrî uyonpa, isa'namato'peuya? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mîîkîrîya epu'to'pe Jesusya panton ekaremekî'pî see warantî. —A'kî, warayo' wîtî'pî Jerusalém poi Jericó pona. E'ma taawîrî tuutî pe ama'ye'kon eporî'pîiya. Inkamoroya ipa'tîpîtî'pî, iponka'pî to'ya moropai iwî yonpasa' to'ya wanî'pî. Moropai inkamoro wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mîrîrî tîpo teepîremasen iipî'pî inîmîkîiya pra tîîse e'ma taawîrî. Moropai mîîkîrî era'ma'pî teepîremasenya. Tîîse era'ma tîuya yai tiaron e'ma winî iwa'ka'pîiya, iipia tuutî namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Moropai mîrîrî tîpo tiaron iipî'pî Levi paarî'pî, to' epîremato' yewî' ta teesenyaka'masen. Mîîkîrîya era'ma'pî nîrî, moropai mîîkîrîya iwa'ka'pî mîrîrî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mîrîrî tîpo tiaron warayo' iipî'pî Samariapon, ˻Judeuyamî' yeyaton˼. Eporî tîuya pe mîîkîrîya era'ma'pî moropai eemî'pamî'pî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Moropai mîîkîrî pî' ta'pîiya: “Aka, sa'ne”. Mîîkîrî pîika'tî'pîiya ˻iteyaton pe awanî'pî tîîse˼, ipa'tîpî'to' to'ya rona'pîiya. Moropai ite'natî yaika'pîiya óleo ke, vinho ke. Moropai yanumî'pîiya tekîn pona moropai yarî'pîiya. Eerepamî'pî entamo'kanto' ke tîwe'repasen yewî' ta. Moro aako'mamî'pî ipîika'tî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tiaron wei yai mîîkîrîya ta'pî mîrîrî wîttî esa' pî': “A'kî, mîserî konekaya yu'se wai” ta'pîiya. “Ipî' eesenyaka'ma yu'se wanî sîrîrî”. Mîrîrî pîrata ena'pî tîrî'pîiya asakî'ne. Mîîkîrîya ta'pî: “Tamî'nawîrî antî'ka'pî ye'mauya sîrîrî poro uuipî ya”, ta'pîiya. Mîrîrî kupî'pî mîîkîrîya warayo' pri'yawon pepîn pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mîrîrî ekaranmapo'pî Jesusya: —Anî' wanî inkamoro eseurîwî'nankon warayo'kon kore'ta ipa'tîpî'sa' yonpa pe? ");
INSERT INTO mbcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mîrîrî yuuku'pî warayo'ya: —Manni' ipîika'tîtîpon. —Moriya mîrîrî warantî iku'kî —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus moropai inenupa'san wîtî'pî e'ma taawîrî. Moropai to' erepamî'pî pemonkonyamî' ko'manto' pata pona. Miarî to' erepamî'pî. Moropai tiwinan wîri' itese' Martaya tewî' ta to' pata'se' ton tîrî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mîîkîrî yakon wanî'pî Maria itese'. Mîîkîrî ereuta'pî Uyepotorîkon pia. Moropai Jesus eseurîma tanne eta pî' Maria ko'mamî'pî Jesusya yenupanto'. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mîrîrî tanne Marta wanî'pî mararî pra teesenyaka'ma pî' tamî'nawîrî tînkoneka pî'. Mîrîrî yai Marta iipî'pî Jesus pia moropai ta'pîiya: —Uyepotorî tiwinsarî si'ma esenyaka'ma era'ma pî' nai. Uyakonya tiwinsarî unîmîsa' tamî'nawîron konekato'peuya. Upîika'tîi uyakon ii'to'pe ka'kî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mîîkîrî maimu yuuku'pî Uyepotorîkonya. Ta'pîiya: —Marta, eesenyaka'mato' pî' neken awanî mîrîrî. Eesenyaka'mato'ya ayakinpa mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tîîse morî, mîrîrî yentainon moro man. Ayakon Mariaya kure'ne itu'se tîwe'to' mo'kasa' sîrîrî. Morî menkasai'ya sîrîrî. Anî'ya sîrîrî mo'ka eserîke pra man Maria piapai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tiaron pensa Jesus epîrema'pî. Mîîkîrî ataretî'kasa' tanne, tiwinan inenupa'pî yonpaya ta'pî ipî': —Uyepotorî, anna yenupakî anna epîremato'pe. Joãoya tînenupa'san yenupa'pî warantî anna yenupakî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mîîkîrî maimu yuuku'pî Jesusya: —Sîrîrî warantî epîrematî —ta'pîiya. —“Paapa, ka' pon, amîrî neken morî pe pu'kuru wanî. Mîrîrî taa tamî'nawîronkonya yu'se wai apî'. Amîrî wanî tamî'nawîronkon esa' pe. Asi'kî anna pia anna esa' pe awanîpa. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Anna yekkari ton antîîkî wei kaisarî î' ton pra anna wanî namai, Paapa. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Moropai Paapa, anna nîkupî'pî imakui'pî awinîkîi mîrîrî ku'kî aawanmîra. Mîrîrî warantî nîrî tamî'nawîronkon nîkupî'pî anna pî', mîrîrî kupî annaya anna wanmîra, Paapa. Moropai anna pîika'tîkî imakui'pî ena namai anna yentai”. Mîrîrî warantî mepîrematîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Moropai Jesusya ta'pî tînenupa'san pî': —Maasa esenumenkatî. Attîkon ya, ayonpakon yewî' ta anoinna yairî eseurîwî'ne trigo puusa' esa'se ipî'. Moropai taaya'nîkon “Ikei esa'se yi'nî pî' wai apî'”, taaya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Maasa pra uyonpa tuutîsen erepannî pî' man amen pu'kuru. Eemi'nepansa' ipîra, tîîse iipia untîrî ton pra man ita're' ton” taaya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Esenumenkakî, î' kai'ma ayonpaya amaimu yuuku wîttî ta si'ma. “Upî' tîîwo'ma'tai pra e'kî. Asapontîsa' pu'kuru sîrîrî. Unna'ta atarakkanmoka eserîke pra ye'se'tîsau'ya wai. Moropai unmukuyamî' we'nasa' man uyena. Mîrîrî ye'nen e'mî'sa'ka eserîke pra wai trigo puusa' tîîse”, taiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tauya sîrîrî apî'nîkon —ta'pî Jesusya. —Awe'mî'sa'ka pepîn ayonpa pe tîwanî ye'nen. Tîîse teta'kai esatî pî' aako'mamî ya awe'mî'sa'ka tu'ka itu'se tonpa e'to' tîrîpa. Moropai tamî'nawîrî inesatî'pî tîrîiya iipia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Mîrîrî ye'nen tauya apî'nîkon. Paapa esatî pî' ako'mantî teeseta'kai pra. Moropai yapisîya'nîkon iwinîpai. Yuwa pî' ako'mantî moropai eporîya'nîkon. Mana'ta pa'tî pî' ako'mantî moropai wîttî esa'ya yarakkanmoka. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maasa pra Paapa pî' tamî'nawîronkon esa'nenanya tînesatî'pîkon yapisî. Moropai yuwanenanya tînuwakon eporî. Moropai mana'ta pa'tînenan pia mana'ta atarakkanmoka —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Moropai ta'pîiya: —Amîrî'nîkon tînmuku kenankon. Anmukukonya tiyo' ton esatî ya, îkîi tîrîya'nîkon e'painon? Kaane, itîrîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tiyo' ton kariwana pîmoi esatî anmukukonya ya, yeki'katon mari'tî tîrîya'nîkon e'painon? Kaane, itîrîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Amîrî'nîkon wanî imakui'pî ku'nenan pe teuren, tîîse imakui'pî tîrîya'nîkon pepîn anmukukon pia. Morî tîrîya'nîkon. Mîrîrî yentai Paapa ka' ponya morî tîrî aapia'nîkon. Ayesa'kon pe aako'manto'pe Morî Yekaton Wannî tîrîiya anî'ya esatî ya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mîrîrî tîpo arinîkon pemonkonyamî' kore'ta tîwanî ye'ka pe Jesusya o'ma' yenpa'ka'pî tiwinan warayo' yapai. Mîîkîrî o'ma'ya warayo' eseurîma tîrî pra awe'pîtî'pî. Tîîse Jesusya yenpa'kasa' pe ipata'pî ya' warayo' eseurîma'pî. Mîrîrî kupî Jesusya era'masa' tîuya'nîkon pe mararî pra teesenumenkai arinîkon pemonkonyamî' wanî'pî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tîîse tiaronkonya ta'pî: —Maawariyamî' yepotorî Belzebu meruntîri ke maawariyamî' yenpa'kaiya mîrîrî —ta'pî to'ya. ˻Makui mîîkîrî Belzebu.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Moropai tiaronkon wanî'pî ipî' tîwo'ma'tasanon pe. Ta'pî to'ya: —Anna nera'ma ton ku'kî. Ka' poinon Paapa meruntîri ke iku'kî, innape aku'to'pe annaya —ta'pî to'ya tîîwo'ma'tai. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tîîse î' kai'ma to' esenumenkato' epu'tî'pî Jesusya. Mîrîrî ye'nen ta'pîiya: —A'kî, tiwinan pata ya' tîîko'mansenon eseya'nama ya, to' e'tî'ka e'painon tamî'nawîrî. Moropai tonpakon pokonpe tîmurukun pe tîîko'mansenon wanî ya, inkamoro ko'mamî teesiyu'pî'se morî pe pra. Moropai to' ekore'ma, to' e'tî'ka tamî'nawîrî e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mîrîrî warantî Makui ko'mamî ya tîpemonkonoyamî' pokonpe teesiyu'pîtî pî', meruntî ke awanî pepîn. Mîrîrî tauya sîrîrî maasa pra Belzebuya tîmeruntîri tîîsa' o'ma'kon yenpa'kapa, taaya'nîkon upî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Tîîse mîrîrî warantî awanî ya, anî'ya meruntî tîrî e'painon anenupa'san pia, o'ma'kon yenpa'kato'pe to'ya? Inkamoroya taa e'painon apî'nîkon: “Esenku'tî'san pe awanîkon” taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tîîse Paapa meruntîri ke o'ma'kon yenpa'kauya ya, Paapa ii'sa' man akore'ta'nîkon tamî'nawîronkon esa' pe epu'tîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Meruntî warayo' tîyurupai kenanya tewî' era'ma ya, anî'ya itemanne yama'runpa eserîke pra awanî, meruntî ke awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tîîse itentainon moro awanî ya, mîîkîrî iipî. Iturupai mo'kaiya, mîrîrî meruntî ke tîwanî emapu'tînen. Moropai itemanne yama'runpaiya, yarîiya. Moropai mîrîrî pantakaiya tonpayamî' pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Mîrîrî ye'nen —ta'pî Jesusya, —Anî'ya innape ukupî pra awanî ya, uyeyaton awanî mîrîrî. Moropai anî' esenyaka'ma pra awanî ya, uurî ton pe uurî esenyaka'mato' taruma'tîiya mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mîrîrî pî' Jesus eseurîma ko'mannîpî'pî: —Pemonkon yapai teepa'ka tîpo o'ma' asarî ko'mannîpî tuna ton pîn ya pî' tîpata'se' ton yuwa pî' teerî'kapîpa. Tîîse eporî tîuya pra tîwanî ya taiya: “Kaane enna'poi wa'ta uyewî' ta, yapai epa'ka ne'tîkini ya'”, taiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Moropai mîîkîrî o'ma' enna'po inî'rî mîîkîrî pemonkon ya'. Mîîkîrî yeporîiya yawon pra, morî yeka'maiya pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Moropai mîîkîrî o'ma' wîtî iipiapai tiaronkon o'ma'kon yetai tarakkîrî to' ko'manto'pe kai'ma. To' enepîiya asakî'ne mia' pona tîîmo'tai kaisarî inî' panpî' imakui'san enepîiya mîrîrî mîîkîrî warayo' ya'. Moropai tamî'nawîrî inkamoro ko'mamî mîîkîrî ya'. Inkamoroya mîîkîrî taruma'tî mararî pra, pena e'mai' pe imakui'pî pe tîwanî'pî yentai, mîîkîrî warayo' yeseru wanî inkamoro wanî ye'nen ya' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mîrîrî pî' Jesus tanne, tiwin wîri' arinîkon pemonkonyamî' kore'tawon eseurîma'pî aronne. Moropai ta'pîiya: —Paapaya morî tîîsa' wîri' pia, manni' amîrî yenpotîpon pia, tîmannîtî ke awo'patîpon pia —ta'pî wîri'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mîîkîrî maimu yuuku'pî Jesusya: —Mîîkîrî yentai tîwe'sanon manni'kan Paapa maimu etanenan. Moropai yawîrî tîîko'mansenon. Inkamoro wanî morî pe pu'kuru —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Arinîkon pemonkonyamî' tîîse tîîpia tîwoi Jesus eseurîma pia'tî'pî. Ta'pîiya see warantî: —Sîrîrî pankon pemonkonyamî' wanî sîrîrî imakui'pî pe pu'kuru. Anera'makon ton esatîya'nîkon innape Paapa kupî ye'ka pe pra. Tîîse ikupîuya pepîn anera'makon ton. Tîîse tiwin neken Jonas yarakkîrî e'kupî'pî ekaremekîuya anera'makon ton. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Paapa maimu ekareme'nen profeta Jonas nurî'tî era'ma'pî Nínive cidaderî ponkonya enen, aasa'mantasa' kai'ma to' e'sa' tanne. Mîrîrî wenai Paapa meruntîri yai awe'mî'sa'kasa' epu'tî'pî to'ya. Mîrîrî warantî uurî ka' poi esenpo'pî ii'sa' sîrîrî amîrî'nîkon kore'ta, anera'makon ton pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—A'kî, tiwinano'pî wei yai Sabá pata esa' pe tîwe'sen nurî'tî e'mî'sa'ka kupî sîrîrî. Moropai mîîkîrîya taa kupî sîrîrî apî'nîkon: “Î' ton pe innape ikupîya'nîkon pra awanîkon?” Maasa pra pena mîîkîrî wîri' ii'pîtî'pî aminke pai epu'nen pe tîwe'sen Salomão nurî'tîya tenupato'pe kai'ma etai. Moropai innape ikupî'pîiya. Tîîse tauya sîrîrî apî'nîkon. Uurî akore'ta'nîkon manni' uurî wanî mîîkîrî epu'nen pe si'pî Salomão yentai. Tîîse innape ukupîya'nîkon pra awanîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Tiwinano'pî wei yai Nínive ponkon nurî'tî nîrî e'mî'sa'ka kupî sîrîrî. Moropai inkamoroya taa kupî sîrîrî apî'nîkon: “Î' wani' awanî ye'nen amakuyikon rumakaya'nîkon pra awanîkon?” taa to'ya. Maasa pra inkamoroya tîmakuyikon rumaka'pî pena, Jonas nurî'tîya Paapa maimu ekaremekî yai Nínive po. Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Uurî wanî akore'ta'nîkon mîîkîrî Jonas yentai. Mîîwîni tîîse amakuyikon rumakaya'nîkon pra awanîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesus eseurîma ko'mannîpî'pî: —A'kî, anî'ya tî'kuma'tu yawittanîpî pepîn e'painon î' rî yo'koi itîrîpa. Tîîse itîrîiya e'painon itaponse' pona, maasa pra tamî'nawîronkon pemonkonyamî'ya era'mato'pe kai'ma, morî pe a'ka pe awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jesusya ta'pî: —A'kî, ayenukon wanî ayesa'kon weiyu'manen pe morî pe tamî'nawîron ayeserukon era'makonpa. Tîîse imakui'pî pe ayenukon wanî ya, î' era'maya'nîkon pepîn, î' kupîya'nîkon epu'tîya'nîkon pepîn. Ewaron ta tîwe'sen warantî awanîkon, a'ka ta pra. Mîrîrî warantî ayewankon wanî. Morî pe Paapa maimu pî' eesenumenkakon ya, ayewankon ya', tamî'nawîrî aako'manto'kon wanî morî pe. Tîîse imakui'pî pe eesenumenkakon ya ayewankon ya' imakui'pî pe nîrî aako'manto'kon wanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mîrîrî ye'nen tîwarî e'tî eesenumenkato'kon ya imakui'pî ewomî namai, morî pe a'ka pe aako'mamîkon tanne, aama'tanîpîiya'nîkon namai. Mîrîrî warantî ikupîya'nîkon ya ewaron ta awanîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mîrîrî ye'nen tamî'nawîrî ayesa'kon wanî mîrîrî a'ka pe. Maasa pra yairon pî' pu'kuru eesenumenkakon ye'nen. Ewaron ta tîwe'sen warantî pra awanîkon. A'ka ta tîîko'mansen pe awanîkon morî pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus eseurîma ataretî'ka pe tiwinan fariseuya Jesus eta'pî tewî' ta entamo'kai attîto'pe. Moropai Jesus wîtî'pî, mîîkîrî ereuta'pî imesarî pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tîîse mîîkîrî pî' fariseu esenumenka'pî. Maasa pra teserukon yawîrî awe'rona pra awanî ye'nen tîwentamo'ka rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mîrîrî epu'tî tîuya ye'nen, ta'pî Uyepotorîkonya fariseu pî': —Amîrî'nîkon fariseuyamî'ya apisaukon moropai aparaturikon ronapîtî iko'noro tîîse iporo neken. Awe'ronakon morî pe eesera'mato'pe, tîîse itu'na ayewankon ya' nura pe awanîkon tanne. ˻Mîrîrî ta'pîiya to' yeseru ekaremekîpa kai'ma. To' yewan ya' to' esenumenkato'kon wanî imakui'pî pe, nura pe awanî, mararî pra.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Moropai ta'pîiya: —Pakkokon epu'nenan pepîn amîrî'nîkon. Anî'ya kin mîrîrî pisa kupî'pî poroporo. Mîîkîrî poroporo ikupîtîpono'pîya ita ikupî'pî nîrî? Moropai ayesa'kon neken pra ku'sa' Paapaya pra, tîîse ayewankon nîrî kupî'pîiya. Mîrîrî sa'nîrî nura pe pra yu'se Paapa wanî epu'tîya'nîkon pra naatî? ");
INSERT INTO mbcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mîrîrî ye'nen morî pe aako'manto'pe yuwatî. Tîwe'taruma'tîsanon pîika'tîtî. To' pia antîrîkon yonpa tîîtî to' yemanne ton pe. Mîrîrî tîrîya'nîkon ya, morî pe pu'kuru awanîkon, nura pe pra —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Aka tîwarî e'tî amîrî'nîkon, fariseuyamî'. Maasa pra awe'taruma'tîkon pe naatîi. E'to' yawîrî Paapa yapurîya'nîkon kai'ma, antîrîkon ayo'kon wosi yonpa ke Paapa repaya'nîkon. Tîîse morî panpî' antîrîkon pe ta'pî tîrîya'nîkon pra awanîkon. Tiaronkon winîkîi yairî pra awanîkon ye'nen moropai Paapa sa'namaya'nîkon pra awanîkon ye'nen. Mîrîrî kupîya'nîkon e'pai awanî'pî sa'nîrî. Paapa pia antîrîkon tîrîya'nîkon moropai tiaronkon sa'namaya'nîkon e'pai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aka tîwarî e'tî fariseuyamî' maasa pra awe'taruma'tîkon pe naatîi. Maasa pra tiaronkon yentai awanîkon kai'ma eesenumenkakon ye'nen. Morî pe teekonekai eereutakon epere'nîto' yewî' ta. Moropai arinîkon pemonkonyamî' emurukuntîsa' kore'ta awanîkon yai, tiaronkonya ayapurîkon yu'se awanîkon. Mîî pe awanîkon ye'nen awe'taruma'tîkon pe naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aka, tîwarî e'tî. Maasa pra amîrî'nîkon wanî penaro' uuruwai eesepu'tî pra ena'pî warantî. Epu'tî tîuya'nîkon pra nura kore'ta pemonkonyamî' asarî iporo —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mîrîrî taa Jesusya ye'nen, tiwin Moisés nurî'tîya yenupanto' pî' yenupatonya ta'pî Jesus pî': —Uyenupanen, mîrîrî warantî anna pî' nîrî eeseurîma epu'tî pî' anna man. Anna yeseru winîkîi eseurîman pî' nai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesusya imaimu yuuku'pî: —Amîrî'nîkon nîrî tîwarî e'tî, Moisés nurî'tîya yenupanto' pî' yenupatonkon. Maasa pra awe'taruma'tîkon kupî sîrîrî. Maasa pra yairî pra tiaronkon yenupa pî' aako'mamîkon wenai. Tamî'nawîrî sa'me ayeserukon kupî tiaronya yu'se awanîkon. Tîîse amîrî'nîkonya mîrîrî kupîya'nîkon pra awanîkon nem mararî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tîwarî e'tî. Maasa pra awe'taruma'tîkon kupî sîrîrî. Amîrî'nîkonya pena Paapa maimu ekareme'nenan profetayamî' nurî'tî uruwasi ton koneka'pî morî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mîrîrî ye'nen “Inna to' wîîpai man”, ta'pîya'nîkon. Atamokon nurî'sanya inkamoro wîîsa' moropai inkamoro uruwasi ton koneka'pîya'nîkon. Mîrîrî wenai awe'taruma'tîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mîrîrî ye'nen Paapaya ta'pî epu'nen pe tîwanî ye'nen: “Umaimu ekareme'nenan yarimauya kupî sîrîrî to' kore'ta profetayamî'. Tîîse inkamoro yonpayamî' wîî to'ya kupî sîrîrî. Moropai to' yonparî'san taruma'tî to'ya umaimu wenai”, ta'pî Paapaya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","—Mîrîrî kupî'pî penaronkonya umaimu ekareme'nenan tî'ka'pî to'ya. Mîrîrî wenai sîrîrîpe enen tîwe'sanon pemonkonyamî' taruma'tî Paapaya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Penaro' Abel nurî'tî wî'pî irui Caimya patapai. Moropai profeta Zacarias nurî'tî wî'pî to'ya pîkîrî. Manni' anwî'pîkon Paapa ton pe to' nîpo'tî yaponse' yarappana Paapa yewî' ta teepîremasanon neken wîtîto' pata iwî'pî to'ya. Tamî'nawîronkon wî'pî ku'sa' to'ya wenai tamî'nawîronkon sîrîrîpankon pemonkonyamî' taruma'tî Paapaya kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Aka tîwarî e'tî amîrî'nîkon Moisés nurî'tîya yenupanto' pî' yenupatonkon. Maasa pra pemonkonyamî' anenupakonya yairon epu'tî eserîke pra awanî. Maasa morî yairon tekareme'se pra yenomî'pîya'nîkon ayeserukon neken ekaremekîkonpa kai'ma. Mîrîrî wenai to' e'pîika'tî eserîke pra. Amîrî'nîkon e'pîika'tî pepîn moropai inkamoro e'pîika'tî namai to' ma'nîpa pî' aako'mamîkon —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Mîrîrî taa tîpo Jesus epa'ka'pî mîîkîrî fariseu yewî' tapai. Mîîkîrî eseurîmasa' pî' fariseuyamî' moropai inkamoro Moisés nurî'tîya yenupanto' pî' yenupatonkon ekore'ma'pî mararî pra. Mîrîrî ye'nen mîîkîrî yekaranmapopîtî'pî to'ya. Maasa pra yairî pra Jesus eseurîma yu'se to' wanî'pî imakui'pî kupîkonpa kai'ma iwinîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mararî pra iku'ne'tî yentai pemonkonyamî' emurukuntî'pî Jesus eseurîma etakonpa iipia. Mararî pra kîrîppe to' wanî'pî ipata'se' ton pra tiaronkon pona to' erepanpîtî'pî tu'ke tîwanîkon ye'nen. Mîrîrî yai Jesusya ta'pî tînenupa'san pî' e'mai' pe: —Tîwarî e'tî fariseuyamî' yeseru pî', tiaronkon yenku'tî to'ya pî' morî pe tîwanîkon kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tamî'nawîrî to' nîkupî'pî to' yeseru eesera'ma pra si'pî e'naponka kupî sîrîrî aronne. Moropai to' yeseru î' kai'ma teesenonse to' nîkupî'pî esepu'tî kupî sîrîrî mîrîrî yai tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mîrîrî warantî tamî'nawîrî î' ta'pî'nîkon ewaron ta si'ma anî'ya eta pra tîîse, mîrîrî eseta kupî sîrîrî tarîpai ewaron ta pra, tîîse a'ka ta. Moropai ama' pe eeseurîma'pî ayewî' ta si'ma taatarakkanse anî'ya eta nama pe, mîrîrî esekaremekî kupî sîrîrî tamî'nawîronkonya eta tanne ama' pe pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus eseurîma ko'mannîpî'pî to' pî': —Uyonpayamî' tauya sîrîrî apî'nîkon. Eranne' pe ke'tî manni'kan pemonkonyamî' ataruma'tînenkon pî'. Tiaron pensa awîkon to'ya kupî sîrîrî. Mîrîrî pî' eranne' pe pra e'tî. Awîsa'kon to'ya tîpo inî'rî î' kupî to'ya pepîn. Ayesa'kon neken wîî to'ya tîîse ayekatonkon wîî to'ya eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tîîse tauya sîrîrî apî'nîkon. Anî' namaya'nîkon e'pai awanî. Paapa namatî. Maasa pra mîîkîrîya awîkon kupî sîrîrî. Ayesa'kon wîiya moropai ayekatonkon yenumîiya apo' ya'. Mîrîrî ye'nen tauya inî'rî apî'nîkon, Paapa namatî, tiaron pemonkon namaya'nîkon yentai apo' ya' ayenumîiya namai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—˻Pemonkonyamî' pî' eranne' pe pra e'kî. Tîîse Paapa nama e'pai man maasa pra uurî'nîkon ko'mannî'nen pe awanî ye'nen.˼ A'kî, to' e'repa mia'taikin toronyamî' simonkokon ke epe'mîra. Tîîse Paapaya inkamoro toronyamî' epu'tî maasa pra iwanmînonkon pepîn inkamoro. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Inkamoro toronyamî' ma'rankon yentai amîrî'nîkon epu'tîiya. Apu'pai si'po ku'ne'tîsai'ya tamî'nawîrî. Mîrîrî ye'nen eranne' pe pra e'tî. Amîrî'nîkon wanî pepîn iiwanmîra maasa pra tu'kankon toronyamî' yentai amîrî'nîkon wanî Paapa pia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesus eseurîma ko'mannîpî'pî to' pî': —Anî'ya taa ya, “Inna uurî Jesus pemonkono pe wanî”, taiya ya pemonkonyamî' pî', uurî ka' poi iipî'pîya taa nîrî mîrîrî warantî Paapa poitîrîtonon inserîyamî' pî'. “Inna mîserî upemonkono”, tauya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tîîse anî'ya taa ya: “Uurî kaane Jesus pemonkono pepîn uurî. Yapurînen pepîn uurî”, taawon awanî ya, mîîkîrîya uwapu'tî. Mîrîrî warantî nîrî uurî ka' poi iipî'pîya iwapu'tî Paapa poitîrîtonon inserîyamî' pî'. “Upemonkono pepîn mîserî” tauya to' pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Moropai ta'pîiya: —Anî' eseurîma ya uurî ka' poi iipî'pî winîkîi mîrîrî imakui'pî inkupî'pî kupî Paapaya eserîke awanî tîîwanmîra. Tîîse anî' eseurîma ya imakui'pî pe Morî Yekaton Wannî winîkîi, mîrîrî imakui'pî inkupî'pî kupî Paapaya pepîn tîîwanmîra. Tîîse aako'mamî mîrîrî ipatîkarî imakui'pî pe awanî Paapa pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Moropai ta'pîiya tînenupa'san pî': —Tauya sîrîrî apî'nîkon. Amîrî'nîkon yarî to'ya epere'nîto' yewî'kon ta apî'nîkon teeseurîmakonpa. Pata esa' pe tîwe'sen moropai ipîkku pe tîwe'sen rawîrî Paapa maimu ekaremekîya'nîkon wenai. Mîrîrî pî' teesewankono'mai pra e'tî. “Î' see taato'peuya ko'ye” kîkatî aawarîrî'nîkon. “Î' kai'ma see epeto'pe” tîkai pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maasa pra inkamoro ipîkkukon rawîrî si'ma î' kai'ma eeseurîmato'kon ton ke ayenupakon Morî Yekaton Wannîya mîrîrî yai, to' maimu yu'to'yakon ton tîrîiya —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Inkamoro arinîkon yeurîma Jesusya tanne to' kore'ta tîwe'sen warayo' eseurîma'pî. Ta'pîiya Jesus pî': —Uyenupanen, anna yunkon nurî'tî yemannerî'pî innîmî'pî, mîrîrî rataikato'pe uyakonya ka'kî arakkita pairî uurî ton —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Imaimu yuuku'pî Jesusya: —Uyonpa, mîrîrî uurî esenyaka'mato' pepîn. O'non ye'ka pe see mîrîrî kupîuya epu'tî pî' nan? Mîrîrî kupîuya eserîke pra wai —ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mîrîrî yai tamî'nawîronkon pî' eeseurîma'pî. Ta'pîiya: —Tîwarî e'tî, î' itu'se awe'to'kon pî'. Kure'ne î' itu'se awe'to'kon yu'se kîsenumenkatî. Maasa pra kure'ne temanne ke tîwe'sen pe tîwanî wenai, morî pe aako'mamî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mîrîrî yekare pî' to' yenupapa kai'ma Jesusya warayo' ipîkku yekare ekaremekî'pî. Ta'pîiya: —Warayo' wanî'pî yemanne ke. Moropai mîîkîrîya ta're' ton pîmî'pî mararî pra. Moropai eepeta'pî mararî pra moropai imo'ka'pîiya kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mîrîrî pî' mîîkîrî esenumenka pia'tî'pî tîîwarîrî. Ta'pîiya: “Uya're' pata'se' ton pra nai koo. Mararî pra tîîse rî” ta'pîiya. “O'non pata ikonekauya e'painon”, kai'ma eesenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mîîkîrîya ta'pî: “Aa, epu'tî pî' wai tarîpai”, ta'pîiya. Tîîwarîrî eesenumenka'pî. Ta'pîiya: “Seeni' e'mai'non itewî' pe unkoneka'pî yarankauya sîrîrî inî'rî kure'ne panpî' ikonekato'peuya. Mîrîrî ta tamî'nawîrî ikonekato'peuya, mîrîrî e'mai' pe itesa' pe wanî'pî pokonpe, amenan konekato'peuya”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Moropai tauya upî'rî uuwarîrî. Morî pu'kuru warayo' tamî'nawîron esa' amîrî itu'se awe'to' man tamî'nawîrî aapia. Tarîpai tu'ke kono' kaisarî itesa' pe aako'mamî. Tarîpai erî'ka'kî enapî pî' ako'mankî. Moropai enîrî pî' ako'mankî moropai atausinpa pî' ako'mankî tauya” ta'pî warayo' ipîkkuya tîpî'rî, morî pe tîîko'mamî kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tîîse mîîkîrî pî' Paapaya ta'pî: “Pakko, amîrî î' epu'nen pepîn, î' tepu'se pra teeseurîmasen. Maasa pra sîrîrîpe ewaron ya' aasa'manta kupî pe nai. Anî'rî wanî epu'tî pî' nan mîrîrî mararon pepîn aya're' ankoneka'pî yarakkîrî?” ta'pî Paapaya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Moropai ta'pî Jesusya: —Sîrîrî warantî awe'kupî mîrîrî inkamoro ye'kakon ipîkku pe tîwe'sanon. Maasa pra tîmîrî'nîkon pe neken temannekon yannuku pî' to' ko'mannî. Tamî'nawîrî itesa' pe tîwe'to'kon pî' tewankon yapi'sa' to'ya. Tîîse Paapa pia ipîkku pe pra to' wanî. Î' ton pînon inkamoro maasa pra Paapa maimu yawîrî pra to' wanî ye'nen, î' rî yapisî to'ya pepîn iwinîpai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mîrîrî warantî to' yeurîma tîpo, Jesusya ta'pî tînenupa'san pî': —Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Aako'manto'kon pî' teesewankono'mai pra e'tî. Ayekkarikon ton pra awanî pî' aponkon ton pra awanî pî' kîsewankono'matî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maasa pra uurî'nîkon ko'manto' ko'mannîpî Paapaya. Moropai uyesa'kon ko'mannîpîiya. Mîrîrî wanî mîrîrî uya're'kon moropai uponkon yentai. Mîrîrî ye'nen mîrîrî pî' teesenumenkai pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Maasa esenumenkatî. Manni'kan toronyamî' esenyaka'ma pepîn tekkarikon ton pîmî pî'. Moropai imo'ka pî' to' esenyaka'ma pepîn. Moropai itewî'kon ton koneka to'ya pepîn. Tîîse Paapaya inkamoro ko'mannîpî mîrîrî. To' ya're' ton tîrîiya emi'nan moronka to'ya namai. Amîrî'nîkon kanan? î' kai'ma awanîkon? Inkamoro toronyamî' ko'mannîpî tîuya yentai Paapaya aako'mannîpîkon. Maasa pra inkamoro toronyamî' yentainokon amîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Teesenumenkato'kon wenai anî'ya tîîko'manto'kon ton yenka pepîn inî' panpî' tîîko'mamîpa, nem mararî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mîrîrî kupîya'nîkon eserîke pra awanîkon ye'nen î' ton pe aako'mamîkon teesewankono'mai î' itu'se awe'to'kon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Maasa esenumenkatî kono' waiyi pî'. Eesenyaka'ma pepîn tîpon si'pîmî pî'. Mîîwîni tîîse morî pe to' yari'ku wanî. Tauya sîrîrî apî'nîkon, pena Salomão nurî'tîya tîpon ton yeka'ma'pî morî pu'kuru mîrîrî kono' waiyi warainon yeka'ma'pîiya maasa pra itesa' pe tîwanî ye'nen, ipîkku pe tîwanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tîîse mîîkîrî epontîsa' yentai morî pe pu'kuru kono' waiyi wanî. Mîrîrî warantî parî' yari'kutannîpî Paapaya kure'ne aako'mamî pra tîîse. Ka'ne' pe rî aatî'napamî. Mîrîrî yentai uurî'nîkon pontîiya morî pe. Mîrîrî warantî rî tîîse mararî innape ikupîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mîrîrî ye'nen aya're'kon pî' moropai awukukon pî' ayewankon tapi'se pra e'tî. Mîrîrî pî' teesewankono'mai pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Maasa pra manni'kan Paapa epu'nen pepîn yeseru mîrîrî. Moropai tamî'nawîrî î' itu'se awe'to'kon epu'tî pî' Paapa man. Mîrîrî ye'nen mîrîrî pî' teesewankono'mai pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tîîse Paapa yenya' eturumakatî, ayepotorîkon pe awe'to'pe. Moropai itu'se Paapa e'to' kupîya'nîkon yuwatî. Mîrîrî kupîya'nîkon ya, tamî'nawîrî manni' itu'se awe'to'kon tîrîiya aapia'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Moropai ta'pîiya: —Mîrîrî ye'nen unmukuyamî', innape Paapa kupî pî' ako'mantî eranne' pe tîwe'se pra. Maasa pra Paapa, ayunkonya tîwakîri pe tîntîrî tîrî pe man aapia'nîkon. Tesa'kon pe itenya' eturumaka'san pia itîrîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mîrîrî ye'nen î' itesa' pe awe'to'kon ke e'repatî. Moropai mîrîrî yepe'pî tîniru tîîtî manni'kan î' ton pînon pia. Mîrîrî wenai ayemannekon yense' ton eporîya, tîwe'tî'kasen pepîn ka' po. Moropai mîrîrî ya' itesa' pe awe'to'kon konekaya ka' po. Maasa pra miarî aataretî'ka pepîn. Moropai miarî ama'ye'ya yama'runpa pepîn. Moropai miarî ka' po anî'rî o'ma'ya aponkon ayemannekon yaku pepîn. Ipatîkarî morî pe aako'mamî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maasa pra miarî ka' po ayemannekon konekasa'ya'nîkon manni' pata eesenumenkato'kon wanî nîrî miarî aako'mamîkon pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Moropai inî'rî ta'pî Jesusya: —Morî pe teekonekai e'tî tamî'nawîrî ankonekakon ton konekakonpa. Morî pe aponkon yeka'matî. Moropai a'kuma'tukon tawittanî'se e'tî. Î' rî e'kupî era'makonpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","—Manni'kan pemonkonyamî' tîkaraiwarîkon tîwe'marimasen festarî pona itî'pî enna'po nîmîkî pî' tîwe'sanon warantî e'tî. Inîmîkî to'ya tanne, to' karaiwarî erepamî ya, mana'ta pa'tîiya. Ka'ne' pe mana'ta yarakkanmoka to'ya eewonto'pe, maasa pra inîmîkî tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Morî pe pu'kuru inkamoro ipoitîrîtonon wanî. Maasa pra to' karaiwarîya to' eporî to' we'nasa' pra awanî ye'nen, tînîmîkî pî' to' tîîse. Tauya apî'nîkon mîîkîrî to' karaiwarîya tîpon miakanma tîpoitîrîtonon yekkari ton tîrîpa. Moropai taiya to' pî': “Ereutatî mesa pia”, taiya. Moropai inkamoro pî' to' karaiwarî esemi'tîpa to' yekkari ton tîrî pî'. Mîrîrî warantî awanî kupî sîrîrî Uyepotorîkon iipî nîmî'nenan ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mîîkîrî to' karaiwarî erepamî ya, kure'ne tîîko'mamî tîpo, anoinna eerepamî pra awanî ya, eerenmapî ya eerepamî ya, aatausinpa tîpoitîrîtonon pî', inîmîkî pî' to' ko'mamî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Maasa esenumenkatî sîrîrî pî'. Sîrîrîpe ama'ye'ya temanne yama'runpa epu'tî warayo' wîttî esa'ya ya, inîmîkî pî' wîttî esa' ko'mamî e'painon, temanne yama'runpaiya namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Amîrî'nîkon nîrî mîrîrî warantî enpen ako'mantî, maasa pra î' pensa uurî ka' poi iipî'pî pemonkon pe enna'poto' weiyu sîrîrî non pona epu'tîya'nîkon pra naatîi. Enpen e'tî aawanmîra'nîkon unîmîkîya'nîkon pra awanîkon tanne ayeporîuya'nîkon namai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mîrîrî warantî Jesus eseurîma ye'nen Pedroya Jesus ekaranmapo'pî. Ta'pîiya: —Uyenupanen, mîrîrî eeseurîmato' wanî mîrîrî anna anenupa'san neken panamato'ya pe, tamî'nawîronkon ton pe ka'rî? —ta'pî Pedroya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesusya yuuku'pî panton ke. Ta'pîiya: —Eseurîma sîrîrî anî' pî' o'non ye'kakon ikaraiwarî nîmo'ka'pî tewî' ko'mannî'nen pe maasa pra mîîkîrî wanî imaimu yawîrî, morî pe tîwe'sen pe moropai epu'nen pe awanî, manni' mîîkîrî ikaraiwarîya tewî' ko'mannî'nen pe. Moropai tiaronkon tîpoitîrîtonon esa' pe to' ya're' ton tîînen pe. Moropai tamî'nawîrî ta'pî tîkaraiwarîya yawîrî iku'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mîîkîrî tîpoitîrî eporî ikaraiwarîya teerepansa' ya morî pe pu'kuru. Maasa pra tamî'nawîrî tîkaraiwarîya taasa' yawîrî iku'sai'ya ye'nen. Mîîkîrî wanî morî pe pu'kuru iipia. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Mîrîrî warantî tîkaraiwarî nîtîrî'pî ko'mannîpîiya ye'nen inî' panpî' ikaraiwarîya tamî'nawîron tîrî iko'mannî'to'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tîîse mîrîrî warantî pra ipoitîrî wanî ya, tîîse taiya ya: “Ka'ne' pe aaipî pe pra man”. Mîrîrî ye'nen tiaronkon ipoitîrîtonon tîîpia tîkaraiwarî nîrumaka'san taruma'tî pia'tîiya to' po'pîtîiya, moropai to' ya're' ton tîrîiya pepîn emi'ne to' tîîse. Tîîse mîîkîrî ko'mamî ta're' enapî pî' moropai tîwuku enîrî pî' mararî pra. Maasa pra tîkaraiwarî iipî pra awanî ye'nen. Moropai mîîkîrî etîmî pia'tî mararî pra imakui'pî kupîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mîrîrî tîpo tîîko'manse pu'kuru pra, ikaraiwarî erepamî tînîmîkîiya pra tîîse, mararî enpen pra awanî tanne. Mîrîrî yai inkupî'pî era'ma tîuya pe ikaraiwarî ekore'ma mararî pra moropai iwîiya. Moropai yenumîiya imaimu yawîrî iko'mamî'san pepîn pata'se' apo' ya'. Mîrîrî e'kupî Paapa maimu yawîrî pra tîwe'sanon yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ipoitîrîya epu'tî tamî'nawîrî î' inkupî pe ta'pî tîkaraiwarîya tîîse mîrîrî tîku'se pra aako'mansa' ya, teekonekai pra aako'mansa' ya, moropai ta'pîiya yawîrî iku'sai'ya pra ipoitîrî e'sa' ya, mîîkîrî po'pîtî ikaraiwarîya ipîra, tîmoron epu'to'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tîîse manni' ipoitîrî î' ta'pî tîkaraiwarîya epu'nen pepîn. Tîkaraiwarî maimu yawîrî awanî pepîn maasa pra epu'tî tîuya pra tîwanî ye'nen. Tîîse yairî pra mîîkîrî e'to' wanî wenai ikaraiwarîya i'po'pîtî tîîse mararî mîîkîrî tiaron ma're, maasa pra tepu'se pra awe'sa' ye'nen. Sîrîrî warantî uupia'nîkon mararî pra tîntîrî'pî miakanno'pî ekaranmapoiya kupî sîrîrî. Taiya: “Î' kai'ma aapia untîrî'pî yapurî'pîya? Yapurî'pîya ou yewanmîrî'pîya?” taiya kupî sîrîrî upî'nîkon. Maasa pra mararî pra itîîsai'ya ya uupia'nîkon, inî' panpî' epopai awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Uurî iipî'pî apo' ene'to'peuya sîrîrî non pona pemonkonyamî' kore'ta. Aasîrî mîrîrî yawittasa' yu'se wanî sîrîrî teuren. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tîîse kure'ne e'taruma'tî kupî sîrîrî. Tîîse kure'ne e'taruma'tîto' ataretî'kasa' yu'se wanî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tîîse amîrî'nîkon esenumenka morî ene'sau'ya kai'ma sîrîrî non pona. Tîîse tauya sîrîrî apî'nîkon, morî tîwamîn ene'sau'ya pra wai tîîse eseyaton pî' pemonkonyamî' wanî kupî sîrîrî uwenai. To' eseya'nama kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tauya sîrîrî, sîrîrî patapai pemonkonyamî' mia'taikinankon tiwinan wîttî ta tîwe'sanonkon ena kupî sîrîrî eseyaton pî'. Seurîwî'nankon ekore'ma kupî sîrîrî asakî'nankon yarakkîrî. Moropai inkamoro asakî'nankon wanî teekore'mai eseurîwî'nankon yarakkîrî. Uyese' wenai mîrîrî warantî to' ekore'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Moropai tînmukukon winîkîi teekore'mai to' yunkonyamî' innape uku'sa' to'ya wenai, uyese' wenai. Moropai tunkon winîkîi to' munkîyamî' wanî teekore'mai, uyese' wenai. Moropai to' yankonyamî' wanî îri pe tînmukukon wîri'sanyamî' winîkîi, innape uku'sa' to'ya wenai. Moropai to' munkîyamî' nîrî teekore'mai tîsankon winîkîi uyese' wenai. Moropai tîpa'sekon winîkîi to' yawo'pîtonon wanî teekore'mai. Moropai to' pa'setonon wanî teekore'mai tawo'pîkon yarakkîrî. Uyese' wenai tu'kankon ekore'ma kupî sîrîrî. Innape uku'nenan pî' innape uku'nenan pepîn ekore'ma uwenai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesusya pemonkonyamî' panama'pî. Ta'pîiya to' pî': —A'kî, wei epa'ka winî katupuru enuku era'maya'nîkon ya îrikkutun pe. Taawonan amîrî'nîkon, kono' rena pe man sîrîrîpe, taaya'nîkon. Moropai innape aarena ta'pîya'nîkon yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Moropai a'situn ata'se'ma ya, wei ewomî winîpai, mîrîrî pî' taaya'nîkon. Wei pe pata wanî pe man. Innape wei pe awanî, a'ne' pe awanî ta'pîya'nîkon yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amîrî'nîkon pemonkonyamî' teesenku'tîsanon, epu'nenan pe tîwanîkon kai'ma eesenumenkakon! Tamî'nawîrî î' pata po tîwe'ku'sen epu'tîya'nîkon morî pe. Mîrîrî ekaremekîya'nîkon e'to' yawîrî pata po tîwe'ku'sen moropai ka' pî' tîwe'ku'sen. Tîîse î' wani' awanî anera'ma'pîkon ayenukon ke ˻î' ikupî eserîkan pepîn unkupî'pî ayenukon kaisarî˼ mîrîrî kupîya'nîkon pepîn innape. Î' ton pe ekaremekîya'nîkon pepîn? —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Tîîse î' wani' awanî ye'nen aawarîrî'nîkon epu'tîya'nîkon pepîn î' wanî yairon pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A'kî, ayeyaton iipî ya ayarîpa ipîkku pe tîwe'sen juiz pia. E'mai' pe ayarîiya rawîrî î' rî inkupî'pî awinîkîi konekaya yuwakî yarakkîrî, mîîkîrî juiz pia ayarîiya namai. Tîîse ikonekasa'ya pra awanî ya juiz yenya' arumakaiya. Moropai juizya arumaka surarayamî' yenya' moropai surarayamî'ya ayarakkamo atarakkannîto' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tauya sîrîrî apî'nîkon mîrîrî atarakkannîto' tapai eepa'kakon pepîn. Tamî'nawîrî mîrîrî ankupî'pîkon ye'maya'nîkon pîkîrî aako'mamîkon —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Moro to' wanî'pî tiaronkon pemonkonyamî'. Inkamoro eseurîma pia'tî'pî Jesus pî' î' kai'ma Galiléia pataponkon warayo'kon tî'ka me'po'pî Pilatosya pî'. —Paapa pia tîntîrîkon po'tîi to' ii'sa' tanne, to' tî'ka me'po'pîiya —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mîrîrî pî' ta'pî Jesusya: —Î' wani' awanî ye'nen insamoro warayo'kon tî'ka me'po'pîiya mîrîrî warantî. Î' kai'ma to' pî' eesenumenkakon? Tiaronkon yentai imakui'pî ku'sa' to'ya wenai, to' taruma'tî'pî Paapaya taaya'nîkon ka'rî? ");
INSERT INTO mbcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kaane, mîrîrî wenai pra —ta'pî Jesusya. —Tauya sîrîrî apî'nîkon, tamî'nawîrî awanîkon tanne amîrî'nîkon enpenata pra awanîkon ya imakui'pî ankupî'pîkon rumaka pî', inkamoro sa'manta'pî manni' warantî aasa'mantakon kupî sîrîrî tamî'nawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Moropai manni'kan 18 kaisaronkon isa'manta'san Siloé pata'se' winî Jerusalém po. Î' wani' awanî ye'nen inkamoro pona mîrîrî to' nîkoneka'pî kawînan esenumî'pî, moropai to' tî'ka'pîiya. Î' kai'ma to' pî' eesenumenkakon, kure'ne ka'rî imakui'pî ku'sa' to'ya tiaronkon yentai Jerusalém po? ");
INSERT INTO mbcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaane, Mîrîrî wenai pra to' sa'manta'pî. Tîîse tauya sîrîrî apî'nîkon tamî'nawîrî amîrî'nîkon sa'manta kupî sîrîrî. Amakuyikon rumaka pî' eesenumenkakon pra awanîkon ya, inkamoro sa'manta'pî warantî aasa'mantakon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesusya sîrîrî panton ekaremekî'pî. Ta'pîiya: —Warayo'ya tekkari ye' ton, figo ye' itese' pîmî'pî tînmîri ya'. Moropai tîko'man pe tîîko'mamî tîpo, eepetasa' era'mai attî'pî. Tîîse eporîiya pra itesa' wanî'pî. Mîrîrî ye'nen î' kupî tîuya pî' eesenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Moropai mîîkîrî itesa'ya ta'pî mîrîrî tekkari ye'ka era'manen warayo' tîpoitîrî pî': “A'kî, uuipî'pî eseurîwî'ne kono' kaisarî seeni' figo yeperu era'mai eepetasa' kai'ma, tîîse iteperu eporîuya pra uurî e'pîtî'pî. Mîrîrî ye'nen ya'tîkî î' pe pra si'ma ko'mannî pî' man. Tiaronkon pata'se' mo'kasai'ya man teepetai pra. Mîrîrî ye'nen ma'tîi”, ta'pîiya tîpoitîrî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tîîse ipoitîrîya ta'pî tîkaraiwarî pî': “Maasa tîwî nîsi moro, ukaraiwarî, mîrîrî figo ye' sîrîrî neken kono' iwa'kato'peiya. Tiwin kono'pî pe esenyaka'ma irupukon woi yakauya moropai iwî'nî'pannî'nen ton tîrîuya irupukon pona eepetato'pe”, ta'pî ipoitîrîya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Mîrîrî ku'sau'ya tanne sîrîrî kono' pî' eepeta ya, morî pe awanî. Tîîse figo tîrîiya pra awanî ya, mîrîrî ya'tî me'poya”, ta'pî ipoitîrîya tîkaraiwarî pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesusya pemonkonyamî' yenupa'pî Judeuyamî' epere'to' yewî' ta si'ma sábado, erî'ka'nîto' weiyu yai. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Moro awanî'pî pri'ya pra tîwe'sen wîri'. Mîîkîrî ko'mansa' wanî'pî pri'ya pra 18 kono' kaisarî. O'ma'ya pri'ya pra iku'sa' wanî'pî. Mîîkîrî sa'ne asapîtî'pî murui murui pe awe'mî'sa'ka pra. Mîîkîrî esepi'tî eserîke pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mîîkîrî era'ma tîuya pe Jesusya yanno'pî tîîpia. Moropai ta'pîiya wîri' pî': —Ma'non, ayeparan winîpai esepi'tîn pî' nai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Moropai tenya tîrî'pîiya ipona moropai mîîkîrî ekoneka'pî. Inî'rî murui pe pra eena'pî. Moropai mîrîrî tîpo mîîkîrî wîri'ya Paapa yapurî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tîîse mîrîrî kupî Jesusya era'ma tîuya ye'nen Judeuyamî' epere'to' yewî' esa' pe tîwe'sen ekore'ma'pî mararî pra Jesus winîkîi, maasa pra sábado weiyu yai wîri' yepi'tîiya ye'nen. Mîrîrî ye'nen ta'pîiya pemonkonyamî' pî': —Tiwin mia' pona tîîmo'tai wei kaisarî esenyaka'manto'. Mîrîrî yai aaipîkon eesepi'tîkonpa, tîîse sábado, erî'ka'nîto' weiyu yai pra —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mîrîrî yuuku'pî Uyepotorîkonya. Ta'pîiya: —Seru'ye' amîrî, epu'nen pepîn. Sábado yai î' kupî pepîn taaya'nîkon tîîse attîkon sábado yai paakayamî' yewî' ta ayekînkon yeukai, to' yarîkonpa tuna enî'to'pe to'ya. Mîrîrî epu'tîya'nîkon pra awanîkon mîrîrî? Ewa'tîsa' pe si'ma tuna enîrîiya pepîn mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mîrîrî warantî mîserî wîri' wanî sîrîrî yewa'tîsa' pe, Makui newa'tî'pî pe aako'mansa' kure'ne 18 kono' kaisarî. Mîîkîrî wanî Abraão nurî'tî paarî'pî pe, ayonpakon pe Judeupa' pe awanî. Î' wani' awanî ye'nen kin sábado yai mîîkîrî esepi'tî eserîke pra awanî mîrîrî teparan winîpai? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mîrîrî taa Jesusya pî' inkamoro ipî' tîwo'ma'tasanon eppepî mararî pra maasa pra to' yeseru yenpo'pîiya. Tîîse tiaronkon arinîkon pemonkonyamî' wanî'pî taatausinpai kure'ne î' ikupî eserîkan pepîn Jesus nîkupî'pî pî'. Mîrîrî era'ma tîuya'nîkon yai to' atausinpa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Moropai Jesusya panton ekaremekî'pî to' nepu'tî ton. Ta'pîiya: —Î' kai'ma see awanî pe nai Paapa iipî yai tamî'nawîronkon esa' pe? Î' warantî awanî ekaremekîuya e'painon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—See warantî awanî pe man. Seeni' mostarda ena'pî wanî si'mîrikkî pe pu'kuru. Tîîse mîrîrî pîmî'pî warayo'ya tînmîri ya'. Moropai mîrîrî aro'ta'pî, aarenta'pî, kure'ne eena'pî yei pe. Moropai mîrîrî pona toronyamî' erepamî'pî tî'moikon yaponse' ton konekapîtî'pî to'ya, mîrîrî yei panta pona —ta'pîiya. ˻—Mîrîrî warantî Paapa pemonkonoyamî' wanî mararî tîîse to' epamî —ta'pî Jesusya.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Moropai inî'rî Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Î' ye'ka panton ekaremekîuya e'painon? Î' kai'ma awanî pe nai, Paapa iipî yai pemonkonyamî' esa' pe? ");
INSERT INTO mbcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Awanî pe man trigo yai'meto' warantî. Mîrîrî yapisî'pî wîri'ya moropai kîsere'na kore'ta mararî itîrî'pîiya, iku'ne'tîto' yai. Moropai yai'meiya tamî'nawîrî, mîrîrî ye'nen yai'mesa' pe kîsere'na wanî tamî'nawîrî —ta'pî Jesusya. ˻—Mîrîrî warantî Paapa pemonkonoyamî' mararonkon wanî tu'kankon kore'ta sîrîrî non po. Tîîse maasa Paapa pemonkonyamî' epansa' tamî'nawîrî pata po, anî'ya era'ma pra tîîse˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalém pona tuutî Jesus wîtî'pî e'ma taawîrî. Tuutî pe Jesusya pemonkonyamî' yenupa'pî cidade po. Moropai tiaronkon yenupa'pîiya to' pata'se'kon kaisarî to' ko'manto'kon ya' to' yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mîrîrî yai warayo'ya Jesus ekaranmapo'pî. Ta'pîiya: —Uyenupanen, tu'kankon pepîn neken pemonkonyamî' e'pîika'tî kupî sîrîrî? —ta'pîiya Jesus pî'. Mîrîrî ta'pî Jesusya: —Moro man ka' po mana'ta e'ta'ka. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Mîrîrî ye'nen mîrîrî yai eewomîkon yuwatî teeseka'nunkai. Maasa pra tauya apî'nîkon tu'kankon pemonkonyamî' wanî kupî sîrîrî itîîpai ka' pona, tîîse to' ewomî eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maasa pra mîîkîrî wîttî esa' e'mî'sa'kasa' ya moropai mana'ta yarakkamoiya. Moropai amîrî'nîkon wanî poro po eewomîkon eserîke pra Paapa pia ka' pona. Taaya'nîkon mana'ta pa'tîi'ma, “Anna yepotorî, anna yawonnî'kî aapia”, taaya'nîkon. Tîîse mîîkîrîya amaimukon yuuku kupî sîrîrî see warantî: “Anî'kan amîrî'nîkon? Ayepu'tîkonuya pra wai, o'non pata pai'nokon pe awanîkon?” taiya kupî sîrîrî apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Moropai taaya'nîkon: “Anna manni'kan apokonpe anna yekkari yonpa annaya ne'tîkini. Apokonpe anna wuku enîrî'pî annaya. Moropai anna yenupa'pîya anna kore'ta awanî yai cidade po”, taaya'nîkon ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tîîse taiya inî'rî apî'nîkon: “Anî'kan amîrî'nîkon? Ayepu'tîuya'nîkon pra wai. O'non pata pai'nokon pe awanîkon?” Moropai taiya: “Atarimatî tamî'nawîrî amîrî'nîkon imakui'pî kupî pî' tîîko'mansenon”, taiya apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Miarî si'ma Abraão nurî'tî moropai Isaque nurî'tî, moropai Jacó nurî'tî, moropai tamî'nawîronkon Paapa maimu ekareme'nenan profetayamî' nurî'tî era'maya'nîkon kupî sîrîrî Paapa pia. Tîîse amîrî'nîkon poro po, eewomîkon eserîke pra. Inkamoro era'maya'nîkon pî' mararî pra akaraukon kupî sîrîrî ipî', amoron epu'tî kupî sîrîrî, eewomîkon eserîke pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mîrîrî yai tu'kankon pemonkonyamî' erepamî kupî sîrîrî, wei epa'ka winîpai, moropai wei ewomî winîpai. Moropai tamî'nawîrî pata po tîîko'mansenon, inkamoro ewomî entamo'kanto' pî' tîîwanmîra tesa'kon Paapa pia. To' pata'se'kon ton moro awanî Paapa pia. ˻Tîîse amîrî'nîkon ewomî eserîke pra awanî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Maasa pra inkamoro tiaronkon pîkîronkon ipîkkukon pepînon ewomî kupî sîrîrî e'mai' pe iipia. Tîîse ipîkkukon, ˻e'mai' pe Paapa maimu etanenan˼ tiaronkon yentainokon ewomî pepîn. ˻Maasa pra innape imaimu ku'sa' to'ya pra awanî ye'nen˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mîrîrî pe rî tiaronkon fariseuyamî' iipî'pî Jesus pia. Moropai ta'pî to'ya ipî': —Attî e'painon tarîpai maasa pra amîrî wîî tîuya taa pî' Herodes man —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesusya to' maimu yuuku'pî. Ta'pîiya to' pî': —Atîtî iipia mîîkîrî pia. Moropai makatîi mîîkîrî maikan warainon seru'ye' pî', uurîya taa sîrîrî mîrîrî ekareme'tantî ipî'. Uutî eserîke pra wai sîrîrî maasa pra esenyaka'ma sîrîrî. O'ma'kon yarakkîrî tîwe'sanon pemonkonyamî' yepi'tîuya sîrîrî. Moropai pri'ya pra tîwe'sanon yepi'tîuya sîrîrî. Sîrîrîpe mîrîrî pî' uuko'mamî moropai penane. Mîrîrî tîpo neken uweiyu iku'ne'tîsa' yai erepamî miarî Jerusalém pona, mîrîrî makatîi mîîkîrî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Maasa pra mîrîrî kupî pî' uuko'mamî e'pai man. Moropai tarî uwî to'ya eserîke pra man. Maasa pra Paapa maimu ekareme'nenan profetayamî' wîî to'ya Jerusalém po neken —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Moropai Jesus esewankono'ma'pî, ikaruwa'pî Jerusalém ponkon pemonkonyamî' wenai. Moropai ta'pîiya: —Amîrî'nîkon Paapa maimu ekareme'nenan profetayamî' wîîtîponkon. Aapia'nîkon tîmaimu ekareme'nen to' yarimasa' Paapaya tanne iwî'pîya'nîkon tî' ke. Î' warapo ite'ka amîrî'nîkon sa'nama'pîuya tamî'nawîrî awanîkon tanne. Manni' kariwanaya tapîri yo'koi tînmukuyamî' yannuku warantî, uupia amîrî'nîkon eperepî yu'se wanî'pî teuren tîîse yuukuya'nîkon pra awanî'pîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tarîpai apata'se'kon e'nîmî kupî sîrîrî ˻innape ukupîya'nîkon pra awanîkon ye'nen˼. Uutî sîrîrî aapiapai'nîkon. Tarîpai tauya sîrîrî apî'nîkon, sîrîrî patapai inî'rî uyera'maya'nîkon pe pra naatîi. Uyapurîto'ya'nîkon weiyu erepamî pîkîrî aako'mamîkon. Mîrîrî yai neken taaya'nîkon: “Mîîkîrî morî pu'kuru see Uyepotorîkon ese' pî' tui'sen yapurîpai'nîkon”, taaya'nîkon kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tiwin wei sábado yai Jesus eta'pî fariseuyamî' esanon yonpaya tewî' ta entamo'kai attîto'pe kai'ma. Jesus wîtî'pî moropai mîîkîrî pî' to' esenumenka'pî kure'ne, sábado yai î' rî kupîiya anera'mapai tîwanîkon ye'nen, yairî pra iteseru wanî ekaremekîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Miarî Jesus rawîrî tiwin warayo' wanî'pî pri'yawon pepîn. Mîîkîrî wanî'pî i'si moropai itemekon awoipî'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mîîkîrî era'ma tîuya ye'nen Jesusya Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai fariseuyamî' ekaranmapo'pî. Ta'pîiya to' pî': —Moisés nurî'tîya yenupanto' yawîrî pri'yawon pepîn yepi'tîuya erî'ka'nîto' weiyu yai morî pe awanî, kaane ka'rî? Î' kai'ma taasai'ya nai? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tîîse î' kai'ma Jesus maimu yuuku to'ya pra to' wanî'pî. Mîrîrî ye'nen mîîkîrî pri'yawon pepîn warayo' yapisî'pî Jesusya. Moropai yepi'tî'pîiya. Moropai attîto'pe ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Moropai inkamoro pî' ta'pî Jesusya: —Amîrî'nîkon kore'ta tînmu kenan wanî ya, mîîkîrî munmu itekîn enasa' ya, itu'nakan ya' sábado yai, sábado pe awanî ye'nen imo'kai attî pepîn e'painon ka'ne' pe? ");
INSERT INTO mbcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mîrîrî yuuku to'ya eserîke pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mîrîrî taa tîpo entamo'kanto' pî' etasa'kon yako'menka'pî Jesusya. Maasa pra yaponse' wanî ereutanto'kon menka'pî to'ya mesa pia. Morîkon ponarî to' ereuta'pî ipona ipîkku pe tiaronkon yentai to' e'to'pe. Mîrîrî era'ma tîuya ye'nen, Jesusya sîrîrî panton ekaremekî'pî to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ta'pîiya to' pî': —A'kî, anî'ya amîrî'nîkon etasa' ya tîîno'pîtasen festarî pî' tauya sîrîrî kereutatî morî ereutanto' pona. Maasa pra ipîkku pe tîwe'sen ayentai'nîkon etasa' wîttî esa'ya yai pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Moropai taiya apî'nîkon: “Anî'ya amîrî eta'pî tarîni' ereutapa?” taiya e'painon. Moropai taiya apî': “Atarimakî mîseni' ipîkku ereutato'pe”, taiya apî'. Mîrîrî yai aweppepî kure'ne. Tiaronkon rawîrî apono' morî ma're tîwe'sen pona eereuta. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tauya apî'nîkon, etasa' pe apono' morî ma're tîwe'sen pona ereutatî. Moropai mîîkîrî ayetatîponkonya ayera'makon. Moropai taiya apî'nîkon: “Uwanîyakon, tarîwaya ereutatane'kî. Sîrîrî ereutanto' morî pona”, taiya. Mîrîrî warantî kure'ne ayapurî to'ya esera'ma tamî'nawîronkon ipîkkukon etasa'kon rawîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Maasa pra anî' e'ku'sa' ya ipîkku pe moropai mîî pe, mîîkîrî ena kupî sîrîrî tiaronkon ma're. Aweppepî kupî sîrîrî. Tîîse anî' e'sa' ya ipîkku pe pra, moropai mîî pe pra, mîîkîrî yapurî to'ya, ipîkku pe eena —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Moropai ta'pî Jesusya tetatîpono'pî pî': —Î' pensa entamo'kanto' konekaya yai, manni'kan neken ayetatîponkon ayonpakon moropai ayakonkon moropai ayakontarikon ipîkku pe tîwe'sanon neken ketai. Maasa pra inkamoroya mîrîrî ye'ka kupî tîuya'nîkon ya amîrî yeta awentamo'kai attîpa kai'ma. Mîrîrî warantî ankupî'pî ye'ma inkamoroya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tîîse î' pensa mîrîrî ye'ka konekaya yai, manni'kan sa'ne î' ton pînon moropai ma'tîkî'pankon, enkaru'nankon, moropai asakoi'kon pepînon sa'ne etakî to' ii'to'pe entamo'kanto' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mîrîrî warantî ikupîya ya, morî yapisîiya Paapa winîpai. Maasa pra inkamoroya sa'ne mîrîrî ankupî'pî ye'ma pepîn, ye'mato' ton pra tîwanîkon ye'nen. Tîîse Paapaya aapia ye'ma, î' pensa morî yairon pe tîwe'sanon e'mî'sa'ka weiyu yai aye'maiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mîrîrî taa Jesusya eta tîuya pe, mesa pia ipokonpe tîwe'sen warayo' eseurîma'pî. Ta'pîiya: —Paapa, tamî'nawîronkon esa' pia entamo'kanto' pî' teewonsen wanî kupî sîrîrî taatausinpai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mîrîrî ye'nen Jesusya tiaron panton ekaremekî'pî. Ta'pîiya: —Tiwin warayo'ya pemonkonyamî' eta'pî arinîke to' ii'to'pe tewî' ta, maasa pra kure'nan entamo'kanto' tîrî tîuya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Moropai iweiyu eseporî'pî entamo'kanto' weiyu. Mîrîrî ye'nen tîpoitîrî yaipontî'pîiya attîto'pe pemonkonyamî' yannoi. Taato'peiya ka'ne' pe asi'tî entamo'katane'tî entamo'kanto' esenposa' man aasîrî taato'peiya kai'ma etasa'kon pemonkonyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tîîse mîîkîrîya tetakon tanne tiwin pî' si'ma ta'pî to'ya: “Uutî eserîke pra wai.” E'mai'non pemonkonya ta'pî ipî': “Umîri ton yennasau'ya sîrîrî. Mîrîrî ye'nen era'mai uutîto' man. Mîrîrî uutî eserîke pra wai, mîrîrî tauya manni' ku'kî tîwî” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Moropai tiaronya ta'pî: “Uutî eserîke pra wai maasa pra mia' tamî'nawîrî uyekînnon ton paakayamî' yennasau'ya wai. Inkamoro era'mai uutîto' man. Maasa pra morî pe to' esenyaka'ma anera'mapai wai. Mîrîrî ye'nen uutî eserîke pra wanî sîrîrî. Tîîse mîrîrî ku'kî tîwî”, ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Moropai tiaronya ta'pî ipî': “Uurî, uutî eserîke pra wai. Maasa pra amen pu'kuru ino'pîtasen pe wanî sîrîrî. Mîrîrî ye'nen uutî pepîn”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mîrîrî tîpo tîkaraiwarî pia ipoitîrî enna'po'pî. Moropai tamî'nawîrî ekaremekî'pîiya tîkaraiwarî pî'. Mîrîrî pî' ikaraiwarî ekore'ma'pî mararî pra. Moropai ta'pîiya inî'rî: “Ka'ne' pe atîkî tiaronkon etata inî'rî, rua taawîrî cidade poro tîwe'sanon etata. Moropai tamî'nawîrî to' metai to' menepîi manni'kan î' ton pînon, moropai ma'tîkî'pankon moropai enkaru'nankon, moropai asakoi'kon pepînon inkamoro menepîi”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tîîko'manse mararî ipoitîrîya ta'pî tîkaraiwarî pî': “Tamî'nawîrî ta'pîya yawîrî iku'sau'ya sîrîrî. Tîîse tu'ke to' pata'se' ton moro man”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mîîkîrî maimu yuuku'pî ikaraiwarîya. “Moriya, atîkî, aminke e'ma taawîrî to' etata, to' ii'to'pe to' meka'nunkai. Maasa pra uyewî' yannî'sa' to'ya anera'mapai wanî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tauya sîrîrî inkamoro e'mai' pe etasa'konya sîrîrî entamo'kanto' yonpa eserîke pra awanî. Maasa pra tetakon tanne yu'sa' to'ya pra awanî ye'nen”, ta'pîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mîrîrî taa tîpo Jesus wîtî tanne arinîkon pemonkonyamî'ya Jesus wenaima'pî. Inkamoro yeurîmai eera'tî'pî moropai ta'pîiya to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—A'kî, manni' uyapurînen wanî ya mararî, mîîkîrî wanî eserîke pra awanî upemonkono pe, uwanîyakon pe. Maasa pra tîyun moropai tîsan pînînmaiya ya, moropai tîno'pî, moropai tînmukuyamî', moropai tonpayamî' pînînmaiya ya, moropai kure'ne tîîwarîrî eetî'nînma, uurî pînînma tîuya yentai, mîrîrî ye'nen uurî wanîyakon pe eserîke pra awanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Anî' wanî ya uwenai e'taruma'tîpai pra, mîrîrî ye'nen uyapurîiya pepîn yapîtanîpîiya pra tîwanî ye'nen. Itu'se tîwe'to' yawîrî iko'manpai awanî. Mîîkîrî wanî pepîn uwanîyakon pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A'kî, anî' esenumenka ya kawînan ton koneka pî' e'mai' pe î' warapo kaisarî tîtînirurî wanî era'maiya e'pai awanî. Yaretî'ka eserîke awanî epu'tîuya ikonekaiya. Mîrîrî epu'se eesenumenka e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tîîse mîrîrî tepu'se pra mîrîrî kawînan ton koneka tîuya pî' teesenyaka'mato' asara'tîsai'ya ya, moropai itînirurî e'tî'ka eesenyaka'mato' ataretî'ka pra tîîse. Mîrîrî era'ma tîuya'nîkon pî' tamî'nawîronkon atako'menka ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“A'kî see yaretî'kaiya pra awanî era'matî”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Moropai ta'pîiya inî'rî: —A'kî, ipîkku pata esa' pe tîwe'sen rei eseya'nama ya tiaron winîkîi, eesenumenka e'pai awanî teeseya'nama rawîrî. Iipia awanî 10.000 kaisaronkon surarayamî'. Tîîse iteyaton pia to' wanî 20.000. Mîîkîrî ereuta e'pai awanî esenumenkai to' eseya'nama eserîke awanî epu'se, meruntî ke to' wanî epu'se. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Meruntî ke pra to' wanî ya, attî pepîn epîi. Tîîse mîîkîrî tiaron rei pî' kai tîmaimu yarimaiya namai epîn pe pra man kai, morî pe e'nîpai man kai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Mîrîrî warantî teesenumenkai pra amîrî'nîkon wanî eserîke pra awanî upemonkono pe, tamî'nawîrî ayeserukon, ayemannekon rumakaya'nîkon pra awanîkon ya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tiaron ekaremekî'pî Jesusya to' nepu'tî ton. Ta'pîiya: —Pan wanî morî pe, awe'to' yawîrî wanî ya. Tîîse awe'to' yawîrî pra awanî ya, morî pe awanî pepîn. Inî'mîra awanî ipo'mîra. ");
INSERT INTO mbcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Morî pe awanî pepîn yapurîto'pe. Î' ton pe rî yapurî eserîke pra awanî. Î' ye'rî pînsa' wî'nî'pannîpîiya eserîke pra awanî. Mîrîrî ye'nen ipapo. Sîrîrî etaya'nîkon pî' esenumenkatî aneta'pîkon pî' —ta'pî Jesusya. ˻—Mîrîrî warantî awanîkon pe man, tamî'nawîrî ayewankon ke uyapurîya'nîkon pra awanîkon ya,˼ —ta'pîiya tîpemonkonoyamî' pî', inî'mîra pan wanî warantî to' yeseru wanî namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tu'kankon tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masanon iipî'pî Jesus pia eeseurîma etakonpa. Moropai imakui'san pemonkonyamî' iipî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseuyamî' moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon nîrî wanî'pî. Inkamoro wo'ma'ta'pî Jesus winîkîi. Ta'pî to'ya: —Imakui'pî ku'nenan pemonkonyamî' pokonpe tîwe'sen mîserî warayo'. Moropai to' pokonpe ta're' yonpanen —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mîrîrî ye'nen to' nepu'tî ton ekaremekî'pî Jesusya panton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ta'pîiya: —Amîrî'nîkon tiwin pî' si'ma ayekînnan carneiroyamî' esa' pe awanî ya, 100 kaisarî. Tiwin aataka'ma'pî ya, yuwai attî e'painon. Innape nai? —ta'pîiya. —Inkamoro 99 kaisaronkon nîmîya e'painon keren po. Moropai attî mîîkîrî ataka'ma'pî yuwai eporîya pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mîîkîrî eposa'ya ya, kure'ne taatausinpai awanî eposa'ya ye'nen. Moropai mîîkîrî mana'poya amota pona tanunse. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ayewî' ta eerepansa' pe, ayonpayamî' awoinonkon etaya. Moropai taaya ayonpayamî' pî': “Atausinpanpai'nîkon upokon pe. Maasa pra uyekîn ataka'ma'pî eposau'ya ye'nen”, taaya'nîkon e'painon tiwin pî' si'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tauya mîrîrî warantî nîrî Paapa atausinpanto' wanî kupî sîrîrî ka' po. Pemonkon imakui'pî pe tîwe'sen enpenatasa' yai tînkupî'pî imakui'pî rumaka tîuya pî'. Ipî' Paapa atausinpa manni'kan 99 kaisaronkon, yairon pe tîwe'sanon pî' taatausinpa yentai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus eseurîma ko'mannîpî'pî: —Tiwin wîri' wanî'pî mia' tamî'nawîrî prata ena'pî esa' pe. Tîîse tiwin esenumî ya mîrîrî yuwaiya e'painon, innape nai? Mîrîrî eporîpa wîri'ya tî'kuma'tu yawittanîpî, moropai tewî' kuimaiya. Morî pe yuwai'ma tînîn eporî tîuya pîkîrî yuwaiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Moropai eposa' tîuya yai tonpayamî' tîwoinokon etaiya. Moropai taiya to' pî': “Atausinpanpai'nîkon man upokonpe. Maasa pra upîratari esenumî'pî eposau'ya ye'nen”, taiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mîrîrî warantî nîrî Paapa poitîrîtonon inserîyamî' atausinpa kure'ne, tiwinan pemonkon imakui'pî ku'nen enpenata yai imakui'pî pe tîwe'to' rumaka tîuya pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Moropai Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Warayo' wanî'pî asakî'nankon inmukuyamî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tiaron pensa inmu yakon maasaron panpî'ya ta'pî tîyun pî': “Paapa, ayemanne rataikakî uyemanne ton tîrîpa, mîrîrî uurî pia antîrî ton aasa'manta yai. Maasa pra sîrîrî itu'se wai”, ta'pîiya. Moropai itunya temanne rataika'pî irui yemanne yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kure'ne pu'kuru pra wei tîîko'mamî tîpo temanne yannuku'pî mîîkîrî warayo' maasaronya tamî'nawîrî. Moropai attî'pî tamî'nawîrî temanne yarakkîrî tiaron pata pona aminke. Miarî itesa' pe tîwe'to' temanne yaretî'ka'pîiya. Festa pî' tîwanî ke, tîsu'min ke imakui'pî kupî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Moropai tamî'nawîrî yaretî'ka'pîiya tanne, mîrîrî pata ya' emi'nan wanî'pî mararî pra. Moropai mîîkîrîya tîmoron epu'tî pia'tî'pî miarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mîrîrî ye'nen teesenyaka'mato' ton yuwa'pîiya mîrîrî pata ya' tîwe'sen pî' mîrîrî warantî tîwe'pîika'tîpa kai'ma. Mîîkîrîya mîîkîrî yarima'pî tîfazendarî pona tekînon porcoyamî' ko'mannî'se attîto'pe kai'ma, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tîîse miarî mîîkîrî wanî'pî emi'ne ita're' ton pra awanî'pî. Porcoyamî' ya're' anna'pai awanî'pî tîîse anî'ya porcoyamî' ya're' yonpa tîrî pra awanî'pî. Î' tîrî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mîîkîrî esenumenka pia'tî'pî tîîwarîrî. Ta'pîiya: “Î' waraponkon uyun poitîrîtonon teesenyaka'masanon uyun pia tîîse to' ya're' mararon pepîn e'tî'kakoi pepîn. Tîîse î' pî' uurî sa'manta sîrîrî tarî emi'nan pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Enna'po paapa yewî' ta. Moropai tauya paapa pî': ‘Paapa, imakui'pî kupî'pîuya Paapa ka' pon winîkîi, moropai awinîkîi’, tauya paapa pî'”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Mîrîrî ye'nen ‘Anmu pe wanî pepîn sîrîrî, tîîse apoitîrîtonon warantî uku'kî’, tauya paapa pî'”, ta'pî mîîkîrî warayo'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Moropai aataponka'pî miarîpai moropai awenna'po'pî tîyun yewî' ta. Mîîkîrî iipî ko'mannî pe e'ma taawîrî aminke era'masa' itunya wanî'pî. Moropai tî'noko'pî pe era'ma'pîiya mararî pra. Mîîkîrî tînmu ponaya eeka'tumî'pî yapi'se. Yapisî'pîiya tîwakîri pe moropai yu'na'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Moropai mîîkîrîya ta'pî tun pî': “Paapa, imakui'pî kupî'pîuya Paapa ka' pon winîkîi moropai awinîkîi”, ta'pîiya. “Mîrîrî ye'nen anmu pe wanî pepîn sîrîrî tîîse apoitîrîtonon warantî uku'kî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tîîse itunya ta'pî tîpoitîrîtonon pî': “Ka'ne' pe ipon morî ene'tî, moropai yeka'matî itenya pokon nîrî ene'tî, yeka'matî itenya pî'. Moropai i'sa'sa' ene'tî yeka'matî i'pu pî'! ");
INSERT INTO mbcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Moropai kaiwan manni' paaka more ene'tî. Moropai iwîtî. Moropai atausinpanpai'nîkon man mîserî unmu pokonpe entamo'kanto' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Maasa pra mîserî unmu sa'manta'pî kai'ma wanî'pî teuren tîîse awanî sîrîrî. Ataka'ma'pî pe awanî'pî, tarîpai eeseposa' sîrîrî”, ta'pî mîîkîrî warayo' yunya. Mîrîrî ye'nen to' atausinpa'pî entamo'kanto' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mîrîrî e'kupî'pî tiaron inmu irui tîîse tînmîri ya'. Mîîkîrî enna'posa' iipî tanne, aminke pra wîttî pî' eta'pîiya eserenkanto'. Mararî pra awanî'pî to' mananu esetasa'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mîîkîrîya tîyun poitîrî yanno'pî. Moropai ekaranmapo'pîiya. “Î' see mîrîrî?” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mîîkîrî to' poitîrîya yuuku'pî: “Ayakon enna'posa' erepannî pî' man wîttî ta enen, pri'ya. Mîrîrî ye'nen ayunya kaiwan paaka more wîî me'po pî' man”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mîrîrî yekare eta tîuya ye'nen, mîîkîrî inmu irui ekore'ma'pî. Moropai ewonpai pra awanî'pî wîttî ta. Mîrîrî itun epa'ka'pî poro pona iipia. Moropai eewonto'pe taa pî' itun ko'mamî'pî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tîîse tîyun maimu yuuku'pîiya. Ta'pîiya: “Î' warapo kono' kaisarî uuko'mansa' sîrîrî aapia esenyaka'ma pî' apoitîrî warantî. Amaimu tîyu'pî'se pra î' taato'ya ku'sau'ya amaimu yawîrî. Mîrîrî tanne tiwin mîrikkî carneiro more tîîsa'ya pra nai uupia uyonpayamî' pokonpe festa tîkonekai atausinpato' ton”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“Tîîse mîîkîrî anmu, ayemanne tîîsa'ya tî'ka'tîpon, imakui'pî kupî ke wîri'sanyamî' ataka'ma'san yarakkîrî tîwanî ke. Moropai mîîkîrî enna'posa' yo' ton paaka kaiwan wîî me'posa'ya”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mîîkîrî maimu yuuku'pî iyunya. Ta'pîiya: “Unmu, amîrî uupia tîîko'mansen. Mîrîrî ye'nen tamî'nawîron uyemanne wanî sîrîrî ayemanne pe”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Tîîse sîrîrî entamo'kanto' koneka me'pouya emapu'tîsa' sîrîrî atausinpanto' esera'mato'pe kai'ma. Maasa pra mîserî ayakon sa'manta'pî kai'ma e'sa' tanne enen eerepansa' man. Ataka'ma'pî pe awanî'pî tarîpai eeseposa' man”, ta'pîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesusya ta'pî tînenupa'san pî': —Warayo' wanî'pî tîkaraiwarî yemanne ko'mannî'nen pe. Tîîse mîîkîrî pî' to' eseurîma pia'tî'pî morî pe e'to' yawîrî eesenyaka'ma pra awanî ye'nen. Tîkaraiwarî tînirurî yaretî'ka pî' aako'mamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mîrîrî epu'sa' tîuya pe ikaraiwarîya yanno'pî tîîpia aai'to'pe. Moropai mîîkîrî ekaranmapo'pîiya. “Inna pî' rî apî' to' eseurîma manni' ayeseru pî'?” ta'pîiya ipî'. Moropai ta'pî mîîkîrî ikaraiwarîya ipî': “Tarîpai sîrîrî pata pai mîrîrîkon ankupî'pî konekaya yu'se wanî sîrîrî. Tamî'nawîrî yannu'kî morî pe awe'to'pe, tiaron pia irumakapa. Maasa pra mîrîrî warantî awanî ye'ka pe tamî'nawîron uyemanne ko'mannî'nen pe awanî eserîke pra nai”, ta'pî ikaraiwarîya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mîrîrî taasa' tîkaraiwarîya pî' mîîkîrî esenumenka'pî tîîwarîrî. “Epa'kato'pe taa pî' kin ukaraiwarî man koo, î' see ku'to'peuya ko'ye. Maasa pra epa'kasa' ya uuwarîrî esenyaka'ma non yaka pî' eserîke pra wai, meruntî ke pra wai. Moropai esenyaka'ma pra wanî ya tiaronkon pî' tîniru esatîuya eserîke pra eppe'nî pî' wai”, ta'pîiya tîîwarîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Moropai eesenumenka'pî. “Kaane, epu'tî pî' wai tarîpai î' kupîuya”, ta'pîiya. “Uyonpayamî' yausinpauya, î' pensa ukaraiwarîya uyenpa'kasa' yai tewî'kon ta uyapi'to'pe to'ya”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Moropai mîrîrî taa tîpo mîîkîrî tîkaraiwarî pia epe'mîra tîwe'sanon yanno'pîiya, tamî'nawîrî. Moropai tiwin pî' to' ekaranmapo'pîiya. E'mai'non pî' ta'pîiya: “î' warapo kaisarî epe'mîra tîwe'sen amîrî ukaraiwarî pia?” ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Moropai mîîkîrîya yuuku'pî: “100 kaisarî óleo yense'”, ta'pîiya. “Seeni' era'makî epe'mîra awe'to'. Ereutakî moropai imenukakî arakkita pairî 50 kaisarî neken”, ta'pî mîîkîrîya. Mîrîrî warantî yausinpa'pîiya tîwakîri pe mîîkîrîya ikupî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Moropai tiaron pî' ta'pîiya: “Amîrî kanan? Î' warapo kaisarî epe'mîn amîrî?” Moropai mîîkîrîya yuuku'pî. “1.000 waikara'pî kaisarî trigo”, ta'pîiya. “Sîrîrî era'makî epe'mîra awe'to'. Ereutakî moropai imenukakî 800 kaisarî”, ta'pîiya ipî'. Mîrîrî warantî tonpa ton eporî'pîiya î' pensa teepa'kasa' yai to' pia tîwanîpa. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Moropai mîîkîrîya mîrîrî warantî iku'sa' yekare eta'pî ikaraiwarîya. Î' kai'ma tonpayamî' ton yausinpa pî' eesenumenkasa' wenai yapurî'pîiya mararî pra ˻Imakui'pî ku'sai'ya tîîse˼ —ta'pî Jesusya. Mîrîrî pî' Jesus eseurîma'pî. Ta'pîiya: —Pemonkonyamî' sîrîrî pata yeseru yawîronkon wanî epu'nenan pe pu'kuru. Maasa morî eporîkonpa î' ton pra tîwanîkon namai, teserukon koneka to'ya. Manni'kan Paapa maimu yawîronkon, yairî tîwe'sanonya ikoneka yentai ikoneka to'ya. —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Mîrîrî ye'nen tauya sîrîrî apî'nîkon. Tiaronkon pîika'tîya'nîkon yuwatî ipîkku pe awe'to'kon ke. Mîrîrî ku'sa'ya'nîkon tîpo, î' pensa tamî'nawîrî nîmîya'nîkon ye'ka pe aasa'mantakon ya, Paapaya ayapi'to'pe'nîkon ka' po —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—A'kî tauya sîrîrî, anî' wanî mararon mîrikkî tîîse yapurî epu'nen pe tîwe'sen mîrîrî ye'nen mîîkîrîya mararon pepîn yapurî epu'tî yairî. Tîîse anî' wanî ya mararon pî' ama'ye' pe, mîrîrî warantî nîrî mararon pepîn pî' ama'ye' pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tîîse amîrî'nîkonya ipîkku pe awe'to'kon yapurî epu'tî pra awanî ya tarî non po, o'non ye'ka pe see ipîkku pe awe'to'kon tîrî Paapaya e'painon, ka' pon aapia'nîkon? ");
INSERT INTO mbcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Moropai î' kai'ma tiaronkon yemanne ko'mannîpî epu'tîya'nîkon pra awanîkon tanne î' kai'ma Paapaya amîrî'nîkon pia ayemannekon ton tîrî e'painon aapia'nîkon? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Moropai ta'pî Jesusya: —Asakî'nankon tîkaraiwarîtonon poitîrî pe anî' wanî eserîke pra awanî. Maasa pra tiaron yapurîiya morî pe, moropai tiaron mu'tunpaiya. Tiaron maimu yawîrî awanî tîîse, tiaron pîinamaiya pepîn. Mîrîrî warantî Paapa poitîrî pe e'nî tanne, ipîkku pe e'nîto'pe tîniru yu'se eseka'nunkan eserîke pra awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mîrîrî eta tîuya'nîkon pe fariseuyamî' eseurîma'pî imakui'pî pe Jesus winîkîi. Maasa pra kure'ne inkamoroya tîniru yapurî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Inkamoro pî' ta'pî Jesusya: —Amîrî'nîkon e'kupî morî pe tiaronkon rawîrî awanîkon kai'ma. Tîîse Paapaya eesenumenkato'kon epu'tî tanne ayewankon yawon. Mîrîrî amîrî'nîkon atapurîto' wanî pemonkonyamî' pia wanî morî pe, taaya'nîkon tîîse Paapaya yewanmîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moropai ta'pîiya: —Moisés nurî'tî nîmenuka'pî moropai Paapa maimu ekareme'nenan profetayamî' nurî'tî nîmenuka'pî ekaremekî'pî to'ya João Batista nurî'tî erepamî pîkîrî sîrîrî non pona. Mîrîrî pata pai amenan itekare ekaremekî'pî to'ya. Î' kai'ma Paapa pemonkono pe pemonkonyamî' enato'pe ekaremekî to'ya sîrîrî tîpose. Mîrîrî ye'nen tu'ke pemonkonyamî' eseka'nunka Paapa pemonkono pe tîwanîkonpa. Ka'ne' pe Paapa yenya' to' eturumaka tesa'kon pe awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mîrîrî warantî awanî tîîse penaro' Moisés nîmenuka'pî Paapa maimu ko'mamî yairî ipatîkarî. Ka' moropai non ataretî'ka, tîîse Paapa maimu e'tî'ka pepîn, nem tiwin mai ena pepîn yairî pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Moropai ta'pîiya: —Warayo'ya tîno'pî rumaka tîpo tiaron wîri' yarakkîrî awanî ya, kure'ne imakui'pî kupîiya mîrîrî, Paapa maimu yawîrî pra awanî. Moropai anî' wanî ya wîri' tînyo rumakatîpon yarakkîrî, mîîkîrîya imakui'pî kupî mîrîrî Paapa winîkîi, imaimu e'menukasa' yawîrî pra awanî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Moropai Jesusya ta'pî: —Tiwin warayo' wanî'pî ipîkku pe tîwe'sen. Mîîkîrîya tîpon yeka'mapîtî'pî morî epe'ke. Aako'manpîtî'pî morî pe maasa pra tamî'nawîron esa' pe awanî'pî. Wei kaisarî ita're' wanî'pî mararî pra. Mîrîrî ye'nen î' pî' eesenumenka pra aako'mamî'pî ipîkku pe tîwanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mîrîrî yai nîrî tiaron warayo' wanî'pî. î' ton pîn sa'ne, tîwe'taruma'tîsen, sa'ne. Moropai paran pokon, erekî'pan itesa' poro itese' Lázaro. Mîîkîrî sa'ne yaapîtî to'ya e'pîtî'pî mîîkîrî ipîkku pe tîwe'sen yewî' mana'ta pia maasa pra aasarî eserîke pra awanî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Miarî mîîkîrî ipîkku mesari poi ita're' ya'punu'pî e'sorokasa' anonpapai awe'pîtî'pî. Mîîkîrî sa'ne erekî' yame'ka'pî arinmarakayamî'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Moropai mîîkîrî sa'ne sa'manta'pî. Moropai mîîkîrî era'mai inserîyamî' ii'sa' wanî'pî. Yarî'pî to'ya utamokon Abraão nurî'tî pia. Miarî aako'mamî'pî iipia kure'nan entamo'kanto' ta, taatausinpai pu'kuru. Tîîko'manse pu'kuru pra mîîkîrî ipîkku warayo' sa'manta'pî nîrî ite'ma'pî pî'. Mîîkîrî yu'na'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mîîkîrîya tîmoron epu'tî'pî mararî pra isa'manta'san pata'se' ya', apo' ya' si'ma. Miarî si'ma mîîkîrîya tîtamo Abraão nurî'tî era'ma'pî aminke morî pata ya'. Moropai Lázaro nurî'tî era'ma'pîiya iipia morî ya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mîrîrî ye'nen mîîkîrî entaime'pî. Ta'pîiya Abraão pî': “Amoko a'noko'pî pe sa'ne uyera'makî. Mîrîrî ye'nen Lázaro ii'to'pe ka'kî upîika'tîi. Tenya yeperu teuronkai tuna ka moropai aai'to'pe unu pona itîîse. Maasa pra tarî umoron epu'tî pî' wai apo' ya'”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tîîse Abraão nurî'tîya imaimu yuuku'pî. Ta'pîiya: “Upa'ri, enpenatakî non po aako'mamî'pî pî', morî pe pu'kuru aako'mamî'pî tîîwanmîra, tamî'nawîron esa' pe awanî'pî. Morî pe awanî'pî aapia. Tîîse Lázaro sa'ne ko'mamî'pî tîmoron tepu'se miarî. Tarîpai Lázaro nurî'tî man morî pe pu'kuru tamî'nawîron mîrîrî winîpai. Taatausinpai awanî sîrîrî tarî. Tîîse amîrîya amoron epu'tî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mîrîrî tanne kure'nan a'ta moro man uurî'nîkon yarappana. Mîrîrî ye'nen tarîron uupiawon wîtî eserîke pra man miarî ya' aapia. Moropai miarîpoinon iipî eserîke pra man nîrî tarîwaya uupia”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Amoko”, ta'pî ipîkku warayo'ya. “Mîrîrî warantî awanî ya, Lázaro yarimakî uyonpayamî' kore'ta attîto'pe. Maasa pra uyakontonon moro to' man mia'taikinankon inkamoro pî' ekareme'se attîto'pe ka'kî, tarîwaya e'taruma'tînto' ya' to' iipî namai”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tîîse Abraão nurî'tîya ta'pî: “Ayonpayamî'ya itekare eta e'painon. Kaareta Moisés nurî'tî nekaremekî'pî miarî man to' pia. Moropai profetayamî' nurî'tîyamî' nekaremekî'pî miarî man. Mîrîrî winîpai eta to'ya”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tîîse ‘Inna’ taa to'ya pepîn, Amoko”, ta'pî ipîkku warayo' nurî'tîya. “Tîîse isa'manta'pî e'mî'sa'kasa' ya moropai mîîkîrîya ekaremekî ya, ‘inna’ taa to'ya. Imakui'pî tînkupîkon rumaka to'ya e'painon”. ");
INSERT INTO mbcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tîîse yuuku'pî Abraãoya: “Kaane, ‘Inna’ taa to'ya pepîn. Inkamoro itekare ekareme'nenan Moisés nurî'tî moropai profetayamî' nurî'tîyamî' nekaremekî eta to'ya pra awanî ya, mîrîrî warantî nîrî isa'manta'pî e'mî'sa'kasa' eseurîmato' pî' ‘Inna’ taa to'ya pepîn”, ta'pî Abraão nurî'tîya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusya tînenupa'san pî' ta'pî: —Imakui'pî kupî tiaronkonya emapu'tînen ton moro awanî sîrîrî non po tîwîrî. Tîîse imakui'pî kupî tiaronya emapu'tîtîponya “ekenne” taa kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A'kî, anî' sa'manta ya, tî' tewa'tîi i'mî pî' tuna ka tenunse imakui'pî pe awanî. Tîîse itentai imakui'pî pe awanî insamoro moreyamî' yonpaya imakui'pî kupî emapu'tîiya ya, mararî pra awe'taruma'tî mîrîrî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mîrîrî ye'nen tauya, aka, tîwarî e'kî mîrîrî warantî imakui'pî kupîya'nîkon namai. Ayakonya imakui'pî ku'sa' ya, ka'kî ipî': “Imakui'pî mîrîrî, uyakon, kî'kupîi”, taaya ipî'. “Inna” taiya ya, morî pe pu'kuru awanî. Mîrîrî ye'nen aawanmîra inkupî'pî imakui'pî ku'kî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Asakî'ne mia' pona tîîmo'tai (7) ite'ka tiwin wei tîîse imakui'pî ku'sa' ayakonya ya awinîkîi moropai aapia aai'pîtî ko'mannîpî taiya apî': “Kure'ne imakui'pî kupî pî' wai tîîse enpenatasa' sîrîrî mararî pra. Mîrîrî ye'nen aawanmîra unkupî'pî ku'kî”, taiya ya, aawanmîra iku'kî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Inkamoro Jesus nenupa'sanya esatî'pî Jesus pî'. Ta'pî to'ya: —Anna yepotorî, inî' panpî' innape aku'to' annaya ku'kî —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Moropai Jesusya to' maimu yuuku'pî. Ta'pîiya to' pî': —Mîrîrî mostarda ena'pî mîrikkî si'mîrikkî warantî mararî innape Paapa kupîya'nîkonya ya, taaya'nîkon e'painon seeni' yei pî': “atarokakî tamî'nawîrî akara rapairî” moropai attî. “Tuna ka' e'pînta” taaya'nîkon ya moropai attî e'painon amaimukon yawîrî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Moropai Jesusya inî'rî ta'pî tînenupa'san pî': —Amîrî'nîkon wanî ya tîpoitîrî ke taapai'nîkon man. Mîîkîrî esenyaka'ma ya anmîrikon ya', mîrîrî warantî pra awanî ya ayekînkon carneiroyamî' era'maiya keren po si'ma. Mîîkîrî erepansa' pe teesenyaka'mato' yapai taaya'nîkon pepîn e'painon ipî': “Asi'kî, ereutakî awentamo'kapa”, taaya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tîîse taaya'nîkon e'painon: “Ka'ne' pe entamo'kanto' yenpokî mesa pona entamo'kato'pe moropai uwuku enî'to'peuya. Mîrîrî tîpo uye'ma'pî pî' awentamo'kapa”, taaya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Taasa' tîuya yawîrî mîrîrî ku'sai'ya pî' “Morî pe pu'kuru man” taaya'nîkon e'painon ipî'? Kaane, maasa pra eesenyaka'mato' mîrîrî mîîto'pe, amaimukon yawîrî awe'to'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Mîrîrî warantî amîrî'nîkon wanî e'pai awanî. Tamî'nawîrî ankupîkon pe ta'pî kupîya'nîkon ya taaya'nîkon e'pai awanî: “Teesenyaka'masanon anna. Mîrîrî ye'nen anna yapurî anna karaiwarîya yu'se anna wanî pepîn, anna nîkoneka pe ta'pî kupî annaya ye'nen. Mîrîrî ku'sa' annaya pî' mîî pe anna atapurî pepîn anna karaiwarî maimu yawîrî ikupî annaya ye'nen”, taaya'nîkon e'pai awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mîrîrî tîpo Jesus wîtî ko'mannîpî'pî Jerusalém pona. Mîîkîrî wîtî'pî Samaria moropai Galiléia pata kî'pî ya pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Miarî Jesus erepamî tanne pemonkonyamî' ko'manto' ya mia' tamî'nawîronkon pri'ya pra tîwe'sanon warayo'kon wanî'pî. Inkamoro wanî'pî ere' itese' leprosia pokonkon. Inkamoro iipî'pî Jesus ponaya tîîse to' emî'pamî'pî aminke pemonkonyamî' kore'ta to' ewomî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Moropai inkamoro entaimepîtî'pî. Moropai ta'pî to'ya Jesus pî': —Jesus anna yenupanen, a'noko'pî pe sa'ne anna era'makî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","To' era'ma tîuya pe Jesusya ta'pî to' pî': —Atîtî teepîremasen pia. Moropai amîrî'nîkon esepi'tîsa' era'mato'peiya makatîi ipî' —ta'pî Jesusya to' pî'. Jesus maimu yawîrî to' wîtî'pî. E'ma taawîrî to' wîtî tanne to' esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Moropai to' yonpa esepi'tîsa' enna'po'pî. Samariapon mîîkîrî. Teesepi'tîsa' wenai Paapa yapurî ye'ka pe awenna'po'pî. Meruntî ke aatausinpato' maimu wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus pia teerepamî ye'ka pe awe'sekunka'pî irawîrî yapurî tîuya ye'nen. —Morî pe pu'kuru man, Jesus —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Moropai Jesusya ta'pî: —A'kî, mia' tamî'nawîronkon pepîn kin warayo'kon esepi'tî manni'? O'nonkan tiaronkon to' enna'po pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tîîse î' ton pe mîserî ka'ran samariapon enna'posa' sîrîrî Paapa yapurîi? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Moropai ta'pî Jesusya ipî': —E'mî'sa'kakî moropai atîkî. Eesepi'tîsa' nai maasa pra innape uku'sa'ya ye'nen —ta'pî Jesusya Samariapon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tiaronkon fariseuyamî'ya Jesus ekaranmapo'pî. Ta'pî to'ya: —Î' pensa see tamî'nawîronkon esa' pe Paapa ii'to' weiyu eseporî kupî sîrîrî? —ta'pî to'ya. Jesusya to' maimu yuuku'pî: —Tamî'nawîronkon esa' pe Paapa ii'to' weiyu erepamî pepîn, î' rî teera'masanon pokonpe, anî'ya era'mato'pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—Anî'ya taa eserîke pra awanî, a'kî, sîrîrî era'makî, mooni pata man taa pepîn. Maasa pra tamî'nawîronkon esa' pe Paapa e'to' wanî pe man akore'ta'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mîrîrî ye'nen ta'pîiya tînenupa'san pî': —A'kî, tiwin wei uurî ka' poi iipî'pî anera'mapai awanîkon kupî sîrîrî. Pemonkonyamî' esa' pe uurî wanî anera'mapai awanîkon. Tîîse era'maya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Moropai tiaronkonya taa apî'nîkon: “Aasîrî eerepansa' man. Sîrîrî era'makî, miarî man” taa seru'ye'konya apî'nîkon. Inkamoro ye'ka maimu yawîrî katîtî seru'ye' pe yuwai. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maasa pra uurî iipî'pî ka' poi ii'to' weiyu wanî mîrîrî manni' wara'napi e'sisiuka ka' parakon patapai iratai winîkîi eesera'ma manni' warantî. Tamî'nawîronkonya era'ma kupî sîrîrî, ama' pe pra. Mîrîrî warantî awanî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tîîse maasa e'mai' pe uurî ka' poi iipî'pî e'taruma'tî kupî sîrîrî mararî pra. Moropai uurî uyewanmarî to'ya sîrîrî pankonya yewanmîrî uyu'se pra to' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pena Noé nurî'tî wanî yai pemonkonyamî' ko'mamî'pî tîîwanmîra. Mîrîrî warantî pemonkonyamî' ko'mamî uurî ka' poi iipî'pî ii'to' weiyu erepamî pîkîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","—Pena morî pe tamî'nawîronkon wanî'pî. To' entamo'ka'pî moropai tîwukukon enîrî'pî to'ya. Moropai warayo'kon no'pîta'pî, wîri'sanyamî' etinyoma'pî. To' ko'mamî'pî morî pe tîkanau ya' Noé nurî'tî asara'tî weiyu erepamî tîpose to' ko'mamî'pî. Mîrîrî yai kure'nan tuna ke Paapaya pata ma'tanîpî'pî. Moropai inkamoro pemonkonyamî' tî'ka'pîiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mîrîrî warantî nîrî awe'kupî'pî pena Ló ko'manpîtî yai. Tamî'nawîronkon wanî'pî morî pe to' entamo'ka'pî, moropai tîwukukon enîrî'pî to'ya. Moropai to' esennapîtî'pî, to' e'repapîtî'pî, moropai to' e'pîmî'pî. Moropai tewî'kon ton koneka'pî to'ya. Tîîwanmîra to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ló epa'kato' Sodoma poi weiyu erepamî pîkîrî to' ko'mamî'pî morî pe. Moropai mîrîrî tîpo kono' rena'pî ka' poi apo' pe mararî pra moropai ikî pe, enxofre itese' aarena'pî. Mîrîrîya pemonkonyamî' tî'ka'pî tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mîrîrî warantî pemonkonyamî' ko'mamî uurî ka' poi iipî'pî ii'to' weiyu erepamî pîkîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Mîrîrî yai anî' wanî ya tewî' po mîîkîrî autî eserîke pra awanî î' rî temanne yapisîpa. Moropai anî' wanî ya, tînmîri ya, mîîkîrî enna'po pepîn tewî' ta. Tîîse ka'ne' pe eepe e'pai awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","—Maasa enpenatatî Ló nurî'tî no'pî nurî'tî pî'. Te'ma'pî pî' enna'popai tîwanî yai aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Anî' eseka'nunka ya kure'ne isa'mantapai pra tîîko'manto'kon pînînmaiya ya, mîîkîrî sa'manta kupî sîrîrî. Tîîse uwenai anî' e'taruma'tî ya, tîîsa'manta namaiya pra awanî ya, mîîkîrî e'pîika'tî ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tauya sîrîrî yairon pî'. Mîrîrî ewarono' ya, asakî'nankon pemonkonyamî' wetun ya, tiwinan cama po. Tiwinan neken wîtî kupî sîrîrî, iwanîyakon e'nîmî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Moropai asakî'nankon wîri'sanyamî' trigo ye'pa pî' tîwe'sanon sa'nîrî si'ma. Tiwin neken iwanîyakon wîtî kupî sîrîrî. Moropai iwanîyakon e'nîmî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Moropai asakî'nankon warayo'kon wanî ya umî ya, tiwin neken iwanîyakon wîtî kupî sîrîrî moropai iwanîyakon e'nîmî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mîrîrî pî' Jesus nenupa'sanya ekaranmapo'pî. Ta'pî to'ya: —Anna yepotorî, o'non pata awe'kupî kupî sîrîrî? —ta'pî to'ya Jesus pî'. Inkamoro maimu yuuku'pî Jesusya panton ke. Ta'pîiya: —A'kî, o'non pata paaka sa'mantasa' ya tu'ke watunaiyamî' emurukuntîsa' esera'ma. ˻Mîrîrî warantî awe'kupî yai, epu'tîya'nîkon, eesera'ma aronne.˼ —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesusya panton ekaremekî'pî tînenupa'san yenupapa kai'ma tîwîrî teepîremakon to' ko'manto'pe tîrumakai pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta'pîiya to' pî': —Cidade po awanî'pî warayo' juiz ipîkku pe tîwe'sen. Mîîkîrî wanî'pî Paapa namanen pepîn tîîwarîrî itu'se tîwe'to' yawîrî tîîko'mansen, moropai tiaronkon pemonkonyamî' namanen pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Moro rî mîrîrî cidade po wîri' wanî'pî inyo isa'manta'pî. Tiaronya mîîkîrî taruma'tî'pî. Yairî pra mîîkîrî wanî'pî iwinîkîi. Mîrîrî ye'nen mîîkîrî ipîkku pe tîwe'sen juiz pia attîpîtî e'pîtî'pî tîpîika'tîto'peiya kai'ma mîrîrî pî'. Ta'pîiya: “Upîika'tîkî mîîkîrî upî' tîwo'ma'tasen pî' ka'kî inî'rî aawo'ma'ta namai. Tamî'nawîrî ikonekakî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tîîse mîîkîrî sa'ne inyo isa'manta'pî pîinamaiya pra awanî'pî. Aako'mamî'pî mararî pra wei kaisarî tîîse iko'noro esatî pî' mîîkîrî wîri' ko'mamî'pî. Moropai mîrîrî pî' ta'pîiya, teesenumenkai: “Inna seru' pepîn. Paapa namanen pepîn uurî moropai tiaronkon pemonkonyamî' pîinamanen pepîn uurî ipîkku wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tîîse mîserî wîri'ya yeta'ka ko'mannîpî ye'nen iteseru konekauya sîrîrî. Maasa pra iteseru konekauya pra awanî ya mararî pra epu'tîuya yentai uyaka'maiya inî' î' epu'tî ton pe pra”, ta'pî mîîkîrî juizya. Mîrîrî ye'nen ipîika'tî tu'ka'pîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mîrîrî pî' Uyepotorîkonya ta'pî tînenupa'san pî': —Esenumenkatî î' kai'ma manni' juiz yairon pepîn eseurîmato' pî'. Imakui'pî pe tîwanî tîîse imaimu yuuku tu'ka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mîrîrî warantî pra Paapa wanî, tîîse morî pe awanî. Mîrîrî ye'nen morî kupîiya tîmenka'san tîpemonkonoyamî' ton pe, manni'kan tîwe'pîika'tîto'kon esatî pî' tîwe'sanon wei kaisarî moropai ewaron kaisarî. To' pîika'tîpa Paapa ko'mamî ka'rî? Kaane, ikupîiya kupî tîuya taasa' tîuya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tauya sîrîrî apî'nîkon. Ikupî Paapaya tîpemonkonoyamî' ton pe. Mîrîrî kupîiya ka'ne' pe tîîko'manse pra. Tîîse uurî ka' poi iipî'pî erepanto' weiyu yai sîrîrî non pona, innape Paapaya teepîremato'kon yuuku epu'nenan eporîuya, to' e'taruma'tî tîîse? —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tiaronkon yairî tîwanîkon kai'ma tîwe'ku'sanon moropai tiaronkon yentai tîwe'ku'sanon pî' sîrîrî panton ekaremekî'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ta'pîiya: —Asakî'nankon warayo'kon wîtî'pî epîremanto' yewî' ta epîremai. Tiaron wanî'pî fariseu pe. Tiaron wanî'pî tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masen pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Moropai fariseu e'mî'sa'ka'pî satippe epîremai. Moropai eepîrema'pî tîpona see warantî. Ta'pîiya: “Paapa, ayapurî pî' wai kure'ne. Maasa pra uurî wanî pepîn tiaronkon pemonkonyamî' warantî. Tu'ke î' yu'se tîwe'sen pepîn uurî. Moropai seru'ye' pe uurî wanî pepîn. Moropai imakui'pî ku'nen pepîn. Uurî se' tapairî wîri'sanyamî' yarakkîrî tîwe'sen pepîn tiaronkon warayo'kon warantî. Paapa ayapurî pî' wai nîrî maasa pra mîseni' warayo' tîniru yapisî pî' teesenyaka'masen warainon pepîn uurî imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Epîremakoi uurî asakî'ne ite'ka tiwin semana tîîse uyekkari tonpai pra. Moropai aapia untîrî tîînen uurî esuwa'kakoi pepîn, tamî'nawîrî une'ma uyemanne yonpa tîînen uurî”, ta'pîiya teepîrema ye'ka pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tîîse tesanonkon pia to' nîtîrî tîniru yapisî pî' teesenyaka'masen wanî'pî aminke. Moropai kure'ne aweppe'sa' wanî'pî. Mîrîrî ye'nen tenu yanumîiya pra awanî'pî ka' ekaya. Tîîse tîmannîtî mun pa'tî'pîiya kure'ne teesewankono'mai. Moropai ta'pîiya Paapa pî': “Paapa, a'noko'pî pe sa'ne uyera'makî. Maasa pra kure'ne imakui'pî kupîtîpon uurî,” kai'ma eepîrema'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Mîrîrî ye'nen apî'nîkon tauya sîrîrî. Mîîkîrî warayo' teetî'noko'masen maimu eta'pî Paapaya. Moropai mîîkîrî pîika'tî'pîiya. Teetî'noko'masen warayo' enna'po'pî tewî' ta morî pe tîîwanmîra Paapa yarakkîrî. Tîîse tiaron e'mai' pe epîrema'pî pîika'tîiya pra awanî'pî. Maasa pra anî' atapurî ya tîîwarîrî tiaron yentai mîîkîrî eppepî kupî sîrîrî imakui'pî kupî tîuya pî'. Tîîse anî' wanî ya tîweppe'se imakui'pî pe tîwanî wenai, mîîkîrî wanî kupî sîrîrî taatausinpai. Maasa pra Paapaya yapurî kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mîrîrî tîpo tiaronya moreyamî' yarî'pî Jesus pia to' pîremato'peiya kai'ma. Tîîse Jesus nenupa'sanya mîrîrî era'ma tîuya'nîkon pe ta'pî to' pî': —Î' ton pe mîrîrî warantî ikupîya'nîkon, î' ton kon moreyamî' enepîya'nîkon Jesus pia —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tîîse Jesusya inkamoro moreyamî' yanno'pî tîîpia to' ii'to'pe. Moropai ta'pîiya: —Tîwî inkamoro moreyamî' naiipîi uupia. To' tîma'nîpai pra e'tî. Maasa pra Paapa pemonkonoyamî' wanî insamoro moreyamî' warantî. Paapa, tesa'kon winîpai morî eporî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Inna pî' rî tauya apî'nîkon. Anî' wanî Paapa pemonkono pe e'pai, mîî pe pra insanan moreyamî' warantî e'pai awanî, innape Paapa kupîi'ma. Moropai itenya' eeturumaka e'pai awanî tesa' pe awe'to'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Judeuyamî' esa' pe tîwe'senya Jesus ekaranmapo'pî. —Uyenupanen, morî pu'kuru amîrî, —ta'pîiya Jesus pî'. Moropai ta'pîiya: —Î' kupîuya e'painon ipatîkarî enen uuko'manto' ton epoto'peuya Paapa pia? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesusya ta'pî ipî': —Î' wani' awanî ye'nen “Morî amîrî”, taaya mîrîrî upî'? Tiwinan morî moro man, mîîkîrî Paapa, tiaron ton pra man. Mîîkîrî neken morî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moropai Jesusya yuuku'pî. Ta'pîiya: —Paapa nekaremekî'pî unkupîkon ton epu'nen amîrî. Se' tapairî wîri'sanyamî' yarakkîrî tîwe'se pra, moropai pemonkon kî'wîi. Moropai ama'ye' pe tiaronkon kîsama'runpai moropai seru'ye' pe teeseurîmai pra e'kî. Moropai ayun, asan maimu yawîrî e'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Moropai mîîkîrî warayo'ya ta'pî: —More pe wanî'pî patapai sîrîrî tîpose mîrîrî ku'nen uurî tamî'nawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mîrîrî taiya eta tîuya pe ta'pî Jesusya: —Inna seru' pepîn tîîse tiwinano'pî ankupî ton moro man. Tamî'nawîrî ayemanne ke e'repata moropai itepe'pî mîtîrîi manni'kan sa'ne tîwe'taruma'tîsanon pia. Mîrîrî warantî ikupîya ya, inî' panpî' ayemanne ton eporîya mîrîrî ka' po. Moropai mîrîrî tîpo maaipîi uwenairî —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mîrîrî taa Jesusya ye'nen, mîîkîrî warayo' esewankono'ma'pî mararî pra, ipîkku pe pu'kuru tîwanî ye'nen. Mîrîrî anku'pai pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mîîkîrî esewankono'masa' era'ma tîuya ye'nen Jesusya ta'pî: —A'kî, sa'me pu'kuru see awanî Paapa yenya' ipîkku pe tîwe'sen eturumaka tesa' pe awe'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mîrîrî wanî kameru ewomî warantî akkusa yeutta yai, sa'me awanî. Tîîse itentai awanî mîîkîrî ipîkku ewonto'pe Paapa pia, itesa' pe awe'to'pe, ˻maasa pra kure'ne tewan yapi'sai'ya ye'nen temanne pî'.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mîrîrî taiya etatîponkonya ekaranmapo'pî. Ta'pî to'ya: —Moriya anî' kin e'pîika'tî e'painon? ");
INSERT INTO mbcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesusya yuuku'pî: —Î' sa'me tîwe'sen pemonkon pia sa'me pu'kuru, ikupîiya yentai. Tîîse mîîkîrî Paapa pia sa'me pra awanî. Mîrîrî ye'nen ikupîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Moropai Pedroya ta'pî Jesus pî': —A'kî, tamî'nawîron anna ko'manto' rumakasa' annaya sîrîrî, awenairî anna ii'to'pe kai'ma —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Inna seru' pepîn —ta'pî Jesusya. —Moropai apî'nîkon yairî tauya. Tesa' pe Paapa wanî ye'nen tewî' nîmî'nen, moropai tîno'pî nîmî'nen, moropai takon nîmî'nen, moropai tonpayamî' nîmî'nen, moropai tînmuku nîmî'nen, Paapaya tannosa' wenai, ");
INSERT INTO mbcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mîîkîrîya eporî kupî sîrîrî tîîko'manto' ton inî' panpî', tîîko'manto' ton tarî tamî'nawîrî tînnîmî'pî yentai. Moropai tiwinano'pî weiyu yai, ipatîkarî tîîko'manto' ton eporîiya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Moropai mîrîrî tîpo Jesusya tînenupa'san yarî'pî tiaron winîkîi moropai ta'pîiya to' pî': —A'kî, wîtî'nîkon sîrîrî Jerusalém pona. Miarî tamî'nawîrî profetayamî' nurî'san nîmenuka'pî yawîrî awe'kupî pe man, uurî, pemonkon pe ka' poi iipî'pî winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Miarî uurî rumaka to'ya pe man pemonkonyamî' Judeuyamî' pepînon yenya'. Moropai inkamoroya umu'tunpa kure'ne moropai uyewanmarî to'ya. Moropai tetakukon yenumî to'ya upona. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Moropai u'po'pîtî to'ya. Moropai uwî to'ya. Tîîse uwîsa' to'ya tîpo iteseurîno wei yai e'mî'sa'ka kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mîrîrî taiya epu'tî to'ya pra inenupa'san wanî'pî. Maasa pra Jesus eseurîmato' wanî'pî aronne pra epu'tî to'ya yentai. Mîrîrî ye'nen î' taa yu'se Jesus wanî epu'tî to'ya pra inenupa'san wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mîrîrî tîpo Jesus erepamî ko'mannîpî tanne Jericó cidaderî pona, tiwin pemonkon enkaru'nan sa'ne ereutasa' wanî'pî e'ma ena pona. Mîîkîrî sa'ne wanî'pî tîniru esatî pî' tîmîrî ton, ˻teesenyaka'ma eserîke pra awanî ye'nen.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mîîkîrî sa'ne moro tîîse arinîkon pemonkonyamî' wîtî mîrîrî e'ma taawîrî eta'pîiya. Moropai ekaranmapo'pîiya: —Î' see mîrîrî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Moropai ta'pî to'ya ipî': —Manni' Jesus Nazaré poinon wîtî sîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mîrîrî taa to'ya ye'nen mîîkîrî sa'ne enkaru'nan entaimepîtî pia'tî'pî. Ta'pîiya: —Jesus amîrî rei Davi nurî'tî parî'pî pîika'tîton, a'noko'pî pe sa'ne uyera'makî —ta'pî enkaru'nanya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mîîkîrî entaimepîtî ye'nen e'mai' pe tuutîsanonya ta'pî ipî': —Moo e'kî, î' pî' awentaimepîtî —ta'pî to'ya. Tîîse yuukuiya pra inî' panpî' meruntî ke awentaimepîtî'pî. —A'noko'pî pe uyera'makî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Moropai tuutî ye'ka pe Jesus emî'pamî'pî. Moropai —Ene'tî uupia —ta'pî Jesusya. Tîîpia erepannîpî'pî to'ya pe Jesusya ekaranmapo'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Î' kupîuya yu'se awanî ayarakkîrî? —ta'pî Jesusya ipî'. —Uyepotorî, inî'rî anera'mapai wai —ta'pî warayo'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mîîkîrî pî' ta'pî Jesusya: —Era'maya, innape ukupîya ye'nen eesepi'tîsa' sîrîrî —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Moropai mîrîrî pe rî mîîkîrî warayo' enkaru'nanya era'ma'pî. Mîrîrî ye'nen Jesus wenairî attî'pî Paapa yapurî ye'ka pe. Mîrîrî Jesus nîkupî'pî era'ma tîuya'nîkon ye'nen, tamî'nawîronkon pemonkonyamî'ya Paapa yapurî'pî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Moropai mîrîrî tîpo Jesus ewomî'pî Jericó cidaderî poro attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mîrîrî cidade po awanî'pî warayo' ipîkku pe tîwe'sen itese' Zaqueu. Mîîkîrî wanî'pî tesanonkon pia to' nîtîrî tîniru yapi'nenan yepuru pe tîwe'sen pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mîîkîrî wanî'pî anî' pe Jesus wanî anepu'pai. Tîîse era'maiya eserîke pra awanî'pî maasa pra arinîke pemonkonyamî' wanî ye'nen. Moropai nonpairî tîwanî ye'nen era'maiya pîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mîrîrî ye'nen mîîkîrî eka'tumî'pî inkamoro arinîkon pemonkonyamî' rawîrî. Moropai mîîkîrî enuku'pî yei pona Jesus era'mapa kai'ma. Maasa pra mîrîrî poro Jesus wîtîto' wanî'pî mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mîrîrî yei yo'koi teerepamî pe kakîsiya Jesusya era'ma'pî. Moropai ta'pîiya Zaqueu pî': —Zaqueu, ka'ne' pe autîkî maasa pra sîrîrîpe ayewî' ta uutî e'pai awanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mîrîrî taiya ye'nen, Zaqueu autî'pî ka'ne' pe, moropai Jesus yapisî'pîiya tîwakîri pe taatausinpai tewî' ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mîrîrî era'ma'pî tamî'nawîronkon pemonkonyamî'ya. Mîrîrî ye'nen inkamoro eseurîma pia'tî'pî, ipî' tîwo'ma'takon ye'nen. Ta'pî to'ya: —A'kî, î' ton pe see imakui'pî mîserî warayo' yewî' ta Jesus ewomî mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Moropai Zaqueu e'mî'sa'ka'pî eseurîmai. Moropai ta'pîiya Uyepotorîkon pî': —A'kî, sîrîrî patapai ipîkku uwe'to' yemanne yonpa tîrîuya arakkita pairî pemonkonyamî' sa'ne î' ton pînon tîwe'taruma'tîsanon pia. Moropai tauya î' rî yama'runpasau'ya ya, manni'kan pemonkonyamî' unama'runpa'san pia inna'pouya to' yemanne mo'ka'pîuya yentai, saakîrîrî ite'ka to' pia inna'pouya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mîrîrî yai mîîkîrî pî' ta'pî Jesusya: —Sîrîrîpe mîserî warayo' yewî' tawonkon pîika'tî Paapaya sîrîrî, imakui'pî to' nîkupî'pî ku'sai'ya man tîîwanmîra. Mîserî warayo' wanî Abraão paarî'pî pe pu'kuru. Moropai Abraão nurî'tîya innape Paapa kupî'pî warantî, innape ukupîiya. Mîrîrî wenai awe'pîika'tîsa' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","—Maasa pra ka' poi uurî iipî'pî insanan pemonkonyamî' warainokon, ataka'ma'san yuwai. Moropai Paapa pia to' enna'poto'pe to' pîika'tîi iipî'pî uurî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Moropai Jesusya inkamoro teeseurîma etatîpono'san nepu'tî ton pe panton ekaremekî'pî. Maasa pra aminke pra to' erepamî ko'mannîpî Jerusalém pona. Teerepamî pe tamî'nawîronkon esa' pe Paapa iipî ka'ne' pe kai'ma to' esenumenka epu'tî'pîiya mîîto'pe. Mîrîrî ye'nen î' kai'ma awanî pe man epu'to'pe to'ya, ekaremekî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ta'pî Jesusya: —A'kî, warayo' wanî'pî tîpemonkonoyamî' kenan, moropai ipîkku pe tîwe'sen. Mîîkîrî wîtî'pî tiaron pata pona aminke, pata esa' pe teenapa kai'ma, moropai mîrîrî tîpo tîwenna'popa rei pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tîîse maasa tuutî rawîrî tîpoitîrîtonon mia' tamî'nawîronkon warayo'kon yanno'pîiya tîîpia. Moropai inkamoro pia to' kaisarî tiwin pî' pîrata ena'pî tîrî'pîiya. Moropai ta'pîiya to' pî': “A'kî, sîrîrî pîrata ke puwana konekatî inî' panpî' eporîkonpa. Mîrîrî kupî pî' ako'mantî enna'po pîkîrî”, ta'pîiya. Moropai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tîîse mîrîrî patayawonkon pemonkonyamî'ya yewanmîrî'pî. Pata esa' pe eena yu'se pra to' wanî'pî. Mîrîrî ye'nen pemonkonyamî' yarima'pî to'ya ite'ma'pî pî' kai to' wîtîto'pe ipî': “Pata esa' pe amîrî ena yu'se anna wanî pra man, apemonkonoyamî' pe anna wanî pepîn”, taato'pe to'ya kai'ma ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tîîse mîîkîrî warayo' ena'pî pata esa' pe, rei pe, to' maimu yentai. Moropai mîîkîrî enna'po'pî tewî' ta. Moropai mîîkîrîya inkamoro tîpoitîrîtonon to' pia pîrata ena'pî tîntîrî'san yanno'pî to' ii'to'pe. Î' warapo mîrîrî pîrata ke eposa' to'ya anepu'pai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","E'mai'non erepamî'pî iipia moropai ta'pîiya: “Ukaraiwarî, manni' pîrata ena'pî itîrîya ne'tîkini uupia mîrîrî ke inî' panpî' eporî'pîuya mia' tamî'nawîrî kaisaron”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mîîkîrî pî' ta'pî ikaraiwarîya: “Morî pe man. Atausinpan pî' wai. Innape teesenyaka'masen pe awanî epu'tîuya sîrîrî. Maasa pra yairî mîrîrî mararon ku'sa'ya. Mîrîrî ye'nen mia' tamî'nawîron cidadekon esa' pe akupîuya”, ta'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Moropai tiaron ipoitîrî iipî'pî moropai ta'pîiya: “Ukaraiwarî, manni' pîrata ena'pî uupia itîrî ne'tîkini ke inî' panpî' eporî'pîuya mia'taikinan kaisaron”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mîrîrî pî' ikaraiwarî atausinpa'pî. “Morî pe man. Mîrîrî ye'nen mia'taikin cidadekon esa' pe akupîuya”, ta'pî ikaraiwarîya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Moropai tiaron ipoitîrî iipî'pî. Ta'pîiya ipî': “Ukaraiwarî, manni' uupia itîrîya ne'tîkini pîrata ena'pî seeni' iwontîsau'ya kamisa ya'. Enonsau'ya sîrîrî itîpannîpîuya namai. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Maasa pra amîrî wanî teesenyaka'mai pra tu'ke î' eponen pe. Moropai î' tîpînse pra mararî pra mo'kanen amîrî. Mîrîrî ye'nen eranne' pe wanî'pî apî'”. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mîîkîrî maimu yuuku'pî ikaraiwarîya. “Imakui'pî pe amîrî wanî, enya'ne pe. Puwana pî' awanîpa taasa' tanne, ikonekasa'ya pra awanî. Mîrîrî ye'nen mîrîrî amaimu wenai ayu'se pra wai. Epu'tî'pîya sa'man pe pu'kuru uurî wanî teesenyaka'mai pra tu'ke î' eponen uurî, moropai î' tîpînse pra mararî pra mo'kanen uurî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tîîse î' wani' awanî ye'nen mîrîrî untîrî'pî pîrata ena'pî utînirurî tîrîya pra awanî'pî itewî' ta itaponse' pona? Sîrîrî itîîsa'ya ya, inî' panpî' eepansa' tanne eporîuya e'painon”. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Moropai ta'pîiya moro tîîpia tîwe'sanon pî': “Mîîkîrî pia manni' pîrata ena'pî mo'katî iipiapai. Moropai itîîtî mîîkîrî mia' tamî'nawîron yapisîtîpon pia”. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tîîse ta'pî to'ya: “Anna karaiwarî, tîîse mîîkîrî pia man mia' tamî'nawîron pîrata ena'pî”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Inkamoro maimu yuuku'pî to' karaiwarîya. “Tîîse tauya apî'nîkon, manni' tu'ke panpî' eporîtîponya yapisî e'pai awanî inî' panpî' tu'ke. Tîîse anî' wanî ya tu'kan pepîn yarakkîrî mîrîrî konekasai'ya pra awanî ye'nen, mîrîrî mo'ka e'pai awanî iipiapai, î' ton pra awe'to'pe”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Moropai ta'pîiya: “Tarîpai inkamoro uyeyatonon ene'tî tesa'kon pe uurî wanî yu'se pra si'san, inkamoro tî'katî tamî'nawîrî era'mauya tanne”, ta'pî to' karaiwarîya —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","To' yeurîma tîpo Jesus wîtî'pî to' rawîrî Jerusalém pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Inkamoro erepamî'pî Oliveira ye'ka wî' pona. Mîrîrî wanî'pî aminke pra Betfagé moropai Betânia pî'. Miarî pai Jesusya asakî'ne tînenupa'san yaipontî'pî tîrawîrî to' wîtîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tîmaimu tîrî'pîiya to' pî' see warantî. —Atîtî e'mai' pe mîrîrî vila pona, miarî eerepamîkon pe jumenta more mîrikkî eporîya'nîkon ewa'tîsa' pe. Anî' enuku'pî pepîn. Mîîkîrî meukatîi moropai mene'tîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anî'ya amîrî'nîkon yekaranmapo ya: “Î' ton pe mîîkîrî yeukaya'nîkon”, taa to'ya ya apî'nîkon: “Uyesa'kon man itu'se”, makatîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mîrîrî ye'nen inkamoro Jesus naipontî'san wîtî'pî. Moropai tamî'nawîrî Jesusya ta'pî yawîrî jumenta more yewa'tîsa' to'ya eporî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mîîkîrî yeuka to'ya tanne itesanonya to' ekaranmapo'pî: —Î' ton pe mîîkîrî yeukaya'nîkon mîrîrî? —ta'pî to'ya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Inkamoroya ta'pî: —Uyenupanenkon man itu'se. Mîrîrî ye'nen yarî annaya sîrîrî —ta'pî to'ya. Mîrîrî ye'nen yaato'pe to'ya, irumaka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mîrîrî jumenta more yarî'pî to'ya Jesus pia. Moropai inkamoroya tîponkon mo'ka'pî moropai itîrî'pî to'ya jumenta more pona. Moropai Jesus enuku tanne ipîika'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mîîkîrî po Jesus wîtî tanne pemonkonyamî'ya tîponkon mo'kapîtî'pî moropai e'ma taawîrî yarenka'pî to'ya iporo Jesus wîtîto'pe yapurî tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mîrîrî Oliveira ye'ka wî' poi tawautîkon pe, arinîkon pemonkonyamî' inenupa'san atausinpa pia'tî'pî. Moropai Paapa yapurî'pî to'ya aronne tîwentaimepî'se, tamî'nawîron Jesus nîkupî'pî ikupî eserîkan pepîn era'masa' tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inkamoroya taapîtî'pî mararî pra: —Morî pe pu'kuru man. Paapaya uyesa'kon pe yarimasa' sîrîrî. Morî pe Uyepotorîkon maimu pe aaipî mîrîrî. Morî pe pu'kuru Paapa, ka' pon man tîîwanmîra uurî'nîkon yarakkîrî. Paapa yapurîpai'nîkon man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mîrîrî taa to'ya ye'nen, tiaronkon fariseuyamî' to' kore'ta tîwe'sanonya ta'pî Jesus pî': —Anna yenupanen inkamoro ayapurî pî' to' wanî mannan tî'napanto'pe panpî' ka'kî to' pî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Inkamoro maimu yuuku'pî Jesusya: —Tauya sîrîrî apî'nîkon, mîrîrî warantî inkamoroya uyapurî e'pai awanî. To' atî'napamî ya, tî' inta ton pîn entaimepîtî kupî sîrîrî. Eseurîmakoi pepîn eseurîma kupî sîrîrî uyapurî pî' —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Miarî teerepamî pe Jerusalém cidaderî era'ma'pî Jesusya. Era'ma tîuya yai ikaruwa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Moropai ta'pîiya: —Sîrîrîpe anî'ya tîwamîn enepî epu'tîya'nîkon ya, epu'tîya'nîkon e'painon. Tîîse itu'se pra awanîkon. Tarîpai epu'tîya'nîkon eserîke pra naatîi —ta'pîiya Jerusalém ponkon winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—Tarîpai wei erepamî kupî sîrîrî ayeyatonkonya ayuwatîkon kupî sîrîrî. Awoima'tîkon to'ya eepekon eserîke pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Inkamoroya tamî'nawîrî amîrî'nîkon tîîko'mansenonkon tî'ka kupî sîrîrî. Mararî î' e'nîmî pepîn kupî sîrîrî apatakon ya'. Maasa pra apîika'tîi'nîkon Paapa narima'pî epu'tîya'nîkon pra awanîkon ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Moropai Jesus ewomî'pî epîremanto' yewî' ta moropai mîîkîrîya pemonkonyamî' tîwe'repasanon yenpa'ka'pîiya epîremanto' yewî' tapai. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta'pîiya: —Paapa maimu e'menukasa' man see warantî: Paapaya ta'pî: “Uyewî' wanî mîrîrî epîremanto' yewî' pe”, ta'pî Paapaya pena. Tîîse amîrî'nîkonya iku'sa' mîrîrî ama'ye'kon yewî' pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mîrîrî tîpo Jesusya to' yenupa'pî epîremanto' yewî' ta wei kaisarî. Mîrîrî wenai teepîremasanon esanon moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai pemonkonyamî' esanon wanî'pî anwîpai. ");
INSERT INTO mbcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tîîse mîrîrî kupî to'ya eserîke pra awanî'pî. Maasa pra tamî'nawîronkon pemonkonyamî'ya tamî'nawîrî si'ma eeseurîmato' eta'pî mararî pra tîtî'napanse. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tiaron wei yai Jesusya Paapa maimu ke pemonkonyamî' yenupa tanne epîremanto' yewî' ta teepîremasanon esanon moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon, moropai pemonkonyamî' panamanenan iipî'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Moropai inkamoroya Jesus yekaranmapo'pî. —Ka'kî anna pî' epu'to'pe annaya, anî' maimu pe inkamoro tîwe'repasanon yenpa'ka'pîya mîrîrî moropai to' yenupaya mîrîrî? Anî'ya mîrîrî kupîpa taasa' mîrîrî amîrî pî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Inkamoro maimu yuuku'pî Jesusya: —Uurî nîtîrî ayekaranmapouya'nîkon sîrîrî tarîpai umaimu yu'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—Anî'ya kin yenpatakonanto'pe João Batista nurî'tîya ta'pî? Paapaya ka'rî, pemonkonyamî'ya ka'rî? —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mîrîrî taa Jesusya ye'nen tîîwarîrî'nîkon to' eseurîma'pî tiaronkon pokonpe. —Î' kai'ma see imaimu yu'to'pe'nîkon? Maasa pra Paapa maimu pe ta'nîkon ya, uurî'nîkon yekaranmapoiya eserîke wanî. “Moropai î' wani' awanî ye'nen João kupîya'nîkon pra awanîkon innape”? taiya eserîke awanî upî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Moropai pemonkon maimu pe taasa'nîkon ya, arinîkon pemonkonyamî'ya uurî'nîkon taruma'tî. Sa'mantan pîkîrî tî' ke uurî'nîkon pa'tîpîtî to'ya eserîke awanî. Maasa pra inkamoroya innape pu'kuru Paapa maimu ekareme'nen pe João nurî'tî wanî'pî epu'tî kai'ma —ta'pî to'ya tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mîrîrî ye'nen Jesus maimu yuuku'pî to'ya see warantî: —Epu'tî annaya pra man anî' maimu pe Joãoya yenpatakona'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mîrîrî pî' Jesusya nîrî ta'pî: —Uurî nîrî anî' maimu pe inkamoro tîwe'repasanon epîremanto' yewî' ta si'ma yenpa'ka'pîuya moropai to' yenupauya anî' maimu pe ekaremekîuya pepîn —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Moropai Jesusya to' yeurîma pia'tî'pî panton pe: —Warayo'ya tînmîri ton ya'tî'pî. Moropai uva ye'ka pîmî'pîiya mararî pra tekkari ye' ton. Mîrîrî tînmîri era'manenan tonkon eporî'pîiya itesa' to' e'to'pe tuutî ye'nen. Moropai mîrîrî tîpo attî î' tiaron pata pona iko'manse. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Moropai aasîrî itekkari emîrî weiyu eseporî'pî. Mîrîrî ye'nen mîîkîrîya tiwin tîpoitîrî yarima'pî tekkari yonpa era'mai attîto'pe kai'ma moropai attî'pî. Tîîse inkamoro inmîri esa' tîwe'sanonya mîîkîrî ipoitîrî pa'tîpîtî'pî. Moropai mîîkîrî yarima'pî to'ya awenna'poto'pe î' ton pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Moropai inî'rî ikaraiwarîya tiaron tîpoitîrî yarima'pî to' pia attîto'pe. Mîîkîrî nîrî pa'tîpîtî'pî to'ya ipîra imakui'pî kupî'pî to'ya yarakkîrî. Moropai mîîkîrî yarima'pî to'ya awenna'poto'pe î' ton pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Moropai inî'rî tîpoitîrîtonon teeseurîno yarima'pîiya to' pia attîto'pe. Tîîse mîrîrî warantî nîrî ipa'tîpîtî'pî inkamoro umî era'manenanya moropai yenpa'ka'pî to'ya attîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tîpoitîrîtonon pî' mîrîrî ku'sa' to'ya tîpo to' karaiwarî esenumenka'pî. “Î' kupîuya e'painon ko'ye. Kaane epu'tî pî' wai”, ta'pîiya. “Uwakîri pu'kuru unmu yarimauya sîrîrî, mîserî yarimasau'ya ya, î' kupî to'ya pepîn ipî' maasa pra unmu pe awanî ye'nen. Inama to'ya epu'tî pî' wai” kai'ma eesenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tîîse mîîkîrî umî esa'ya tînmu yarimasa' era'ma tîuya'nîkon ye'nen inkamoro umî era'manenya ta'pî: “A'kî mîserî inmu wîîpai'nîkon, maasa pra î' pensa tîyun sa'manta yai mîserî ena umî esa'. Uurî'nîkon pe awe'to'pe iwîpai'nîkon”, ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mîrîrî ye'nen inkamoroya mîîkîrî umî esa' munmu yapisî'pî yenpa'ka'pî to'ya umî yapai poro pona. Moropai iwî'pî to'ya. Mîrîrî ekaranmapo'pî Jesusya to' pî': —Î' kupî mîîkîrî umî esa'ya kupî sîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tînmîri ya attî moropai inkamoro warayo'kon tînmu wîîtîponkon tî'kaiya moropai tiaronkon warayo'kon eporîiya eserîke awanî tînmîri era'manenan ton kon —ta'pîiya. Mîrîrî eta tîuya'nîkon ye'nen ta'pî to'ya: —Paapaya mîrîrî warantî ikupî e'pai pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tîîse Jesusya inkamoro era'ma'pî, moropai ta'pîiya: —Mîrîrî ye'nen î' taato'pe Paapa maimu e'menukasa' awanî mîrîrî? Sîrîrî warantî Paapa eseurîma'pî: Wîttî konekanenanya tî' yenumî'pî morî pe pra seeni' tî' wanî taa tîuya'nîkon ye'nen. Moropai yenumî'pî to'ya. Tîîse mîrîrî tî' to' nenumî'pî wanî morî pe pu'kuru to' nîmenka'pî yentai. Moropai wîttî ko'mannîpîiya eesenumî namai ta'pî Paapaya pena. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Moropai ta'pî Jesusya: —Anî' atare'mo ya, sîrîrî tî' pona mîîkîrî ma'ta mîrîrî. Tîîse sîrîrî tî' ena ya ipona, mîîkîrî yankaiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mîrîrî tîpo Moisés nurî'tîya yenupanto' pî' yenupatonkon moropai teepîremasanon esanonya tîwinîkîi'nîkon Jesus eseurîma pe awanî epu'tî'pî. Mîrîrî ye'nen anapi'pai to' wanî'pî teuren tîîse arinîkon pemonkonyamî' nama'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jesus anarainamapai to' wanî ye'nen î' kupîiya era'ma tonkon warayo'kon ye'ma'pî to'ya. Moropai inkamoro yaipontî'pî to'ya Jesus yekaranmapo'pî'se to' wîtîto'pe. Yairî tîwanîkon kai'ma Jesus yekaranmapo'pî to'ya. Tîîse yairî pra Jesus yeseru anera'mapai to' wanî'pî kinî, mîîkîrî rumakakonpa pata esa' yenya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mîrîrî ye'nen inkamoroya ekaranmapo'pî: —Anna yenupanen, manni' eeseurîmato' wanî epu'tî pî' anna man yairî pu'kuru awanî. Moropai epu'tî pî' anna man nîrî e'sentai pra tiaronkon panamaya tîîse se' kaisarî to' panamaya yairon pe pu'kuru itu'se Paapa e'to' yawîrî warayo'kon panamaya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Moropai ta'pî to'ya Jesus pî': —O'non ye'ka pe awanî e'painon uyesa'kon pe tîwe'sen César romanoyamî' esa' ye'ma annaya ya ka'kî anna pî'. Morî pe awanî, kaane, ka'rî? Uyeserukon yawîrî, Moisés nurî'tîya yenupanto' yawîrî awanî, kaane ka'rî? ");
INSERT INTO mbcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tîîse Jesusya î' anku'pai to' wanî tarakkîrî epu'tî'pî. Mîrîrî ye'nen ta'pîiya to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Mîrîrî pîrata ena'pî ene'tî uupia —ta'pîiya. —Anî' ese' sîrîrî ipokon, anî' yekaton sîrîrî ipokon? —ta'pîiya. Moropai yuuku'pî to'ya: ");
INSERT INTO mbcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—César yekaton mîrîrî —ta'pî to'ya. Moropai Jesusya ta'pî to' pî': —Mîrîrî wanî imîrî pe. Moriya morî ku'tî unkupîkon ton pe mîîkîrî César nekaremekî'pî ku'tî. Moropai morî ku'tî unkupîkon ton pe Paapa nekaremekî'pî ku'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mîrîrî warantî yairî Jesus wanî ye'nen, o'non ye'ka pe yapisî to'ya eserîke pra to' wanî'pî, pemonkonyamî' rawîrî si'ma. Mîrîrî ye'nen inkamoro atî'napamî'pî inî'rî to' eseurîma pra. Kure'ne teesenumenkai to' wanî'pî ipî'. Maasa pra yairî to' maimu yuukuiya ye'nen, epu'nen pe Jesus wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Moropai mîrîrî tîpo saduceuyamî' manni'kan innape isa'manta'san e'mî'sa'ka ku'nenan pepîn erepamî'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Moropai inkamoroya ta'pî Jesus pî': —Anna yenupanen, pena Moisésya unkupîkon ton menuka'pî see warantî anna nîkupî ton. Warayo' inmuku pîn sa'manta ya, itakono'pî wanî e'pai awanî ino'pîrî'pî yarakkîrî inmu ton epoto'peiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Moro awanî'pî asakî'ne mia' pona tîîmo'tai kaisarî itonpayamî'. Inkamoro ruinankon a'yeke'ton panpî' no'pîta'pî. Teuren tîîse aasa'manta'pî tînmu ton pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Moropai itakono'pî wanî'pî ino'pîrî'pî yarakkîrî tîîse aasa'manta'pî mîrîrî warantî inmu pra si'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Moropai to' eseurîno'pî wanî'pî mîîkîrî yarakkîrî tîîse mîrîrî warantî awanî'pî inkamoro asakî'ne mia' pona tîîmo'tai'nîkon yarakkîrî awe'kupî'pî tamî'nawîrî to' sa'manta'pî inmu pra si'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mîrîrî tîpo to' no'pîrî'pî nîrî sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tarîpai inkamoro e'mî'sa'ka yai, o'non ye'ka no'pî pe awanî kupî sîrîrî. Maasa pra tamî'nawîronkon e'sa' yarakkîrî —ta'pî Saduceuyamî'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Inkamoro maimu yuuku'pî Jesusya. Ta'pîiya: —Sîrîrî pata po warayo'kon no'pîta moropai wîri'sanyamî' niyota. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tîîse manni' wei yai Paapaya isa'manta'san, manni'kan tîîpia morîkon pîmî'sa'ka yai inî'rî to' no'pîta pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Moropai ipatîkarî enen to' ko'mamî. Inî'rî to' sa'manta pepîn. Maasa pra inserîyamî' warantî to' wanî. Paapa munkî pe to' wanî maasa pra to' pîmî'sa'kasai'ya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sîrîrî pî' pena Moisésya eseurîmapîtî'pî aronne, isa'manta'san e'mî'sa'ka kupî pe man, taapîtî'pîiya. Enenan pe to' wanî ekaremekîiya maasa pra pena manni' yai apo' taaransen ya' yarakkîrî Paapa eseurîma yai. Mîrîrî menuka'pîiya: Paapa wanî Abraão nurî'tî yepotorî pe moropai Isaque nurî'tî yepotorî pe, moropai Jacó nurî'tî yepotorî pe awanî ekaremekî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mîrîrî ekaremekî'pîiya enenankon yepotorî pe Paapa wanî ekaremekîpa kai'ma. Tîîse isa'manta'san yepotorî pe Paapa wanî pepîn. Maasa pra Paapaya epu'tî enen tamî'nawîronkon inmukuyamî' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mîrîrî pî' tiaronkon Moisés nurî'tîya yenupanto' pî' yenupatonkonya ta'pî Jesus pî': —Morî pe eseurîman pî' nai, anna yepotorî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tîîse inî' panpî' Jesus ekaranmapo to'ya pra to' wanî'pî. Maasa pra eranne' pe to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Moropai mîrîrî pe rî Jesusya to' ekaranmapo'pî: —O'non ye'ka pe Paapa nîmenka'pî wanî mîrîrî Davi nurî'tî paarî'pî pe taaya'nîkon? ");
INSERT INTO mbcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tîîse mîîkîrî Davi nurî'tîya ta'pî Salmo kaaretarî ya' see warantî: Uyepotorîya ta'pî Uyepotorî pî': “Ereutakî umeruntîri winîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","A'pu yo'koi ayeyatonon tîrîuya pîkîrî”, ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mîrîrî warantî Davi nurî'tîya esatî'pî tepotorî pe, tentai awanî ye'nen. Mîrîrî ye'nen o'non ye'ka pe iparî'pî pe neken awanî e'painon? —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mîrîrî pî' Jesus eseurîma eta pî' pemonkonyamî' wanî tanne, ta'pîiya tînenupa'san pî': ");
INSERT INTO mbcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Aka! Tîwarî e'tî inkamoro Moisés nurî'tîya yenupanto' pî' yenupatonkon pî'. Maasa pra morî pe teepontîi to' asarî, morî pe tamî'nawîronkon pemonkonyamî'ya tera'matonkon pe kai'ma. Inkamoro yapurî to'ya pra'ca poro. Mîrîrî warantî ipîkku e'pai to' wanî. Moropai morî ereutanto' pona to' ereuta epere'nîto' yewî'kon ta pî' tiaronkon yentai. Moropai taponse'kon ton menka to'ya tîwentamo'kato'kon weiyu yai ipîkku pe tîwanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mîrîrî kupî to'ya inyo isa'manta'san yenku'tî tîuya'nîkon tîîse, moropai to' yemanne yama'runpa to'ya. Mîrîrî kupî tîuya'nîkon ye'ka pe to' epîrema mararî pra tîko'man pe, morî pe tîwanîkon era'mato'pe tiaronkonya kai'ma. Tîîse mîrîrî wenai to' taruma'tî Paapaya kupî sîrîrî kure'ne pu'kuru —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mîrîrî tîpo Jesusya pemonkonyamî' yako'menka'pî epîremanto' yewî' ta. Moropai ipîkkukonya tîniru tîrî itense' ya' era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Moropai tiwinan wîri' inyo isa'manta'pîya nîrî itîrî era'ma'pîiya. Mîîkîrî sa'ne wanî'pî î' ton pra tîwe'sen. Tîîse asakî'ne pîrata ena'pî mîrikkî tîrî'pîiya tekkari yennato'pan tîrî'pîiya tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mîrîrî pî' Jesusya ta'pî: —Tauya sîrîrî apî'nîkon, a'kî mîserî sa'ne wîri' inyo ton pîn teuren tîîse pîrata ena'pî tîrî pî' man tamî'nawîronkonya itîrî manni' yentai. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maasa pra inkamoro ipîkkukonya itîrî pî' man itonpa pe neken tamî'nawîrî pra. Tîîse mîserî sa'ne wîri'ya tekkari yennato' tîuya pan tîrî pî' man tamî'nawîrî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mîrîrî tîpo tiaronkon pemonkonyamî' eseurîma'pî epîremanto' yewî' pî'. Morî pe awanî pî' to' eseurîma'pî. Tî'kon ikonekasa' wanî'pî morî pe pu'kuru. Morî pe to' nîtîrî'pî era'ma'pî to'ya. Mîrîrî pî' to' eseurîma ye'nen Jesusya ta'pî to' pî': ");
INSERT INTO mbcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—A'kî, seeni' wîttî yaranka to'ya weiyu erepamî kupî sîrîrî tamî'nawîrî seeni' era'maya'nîkon manni'. Yaranka to'ya yai mararî tî' e'nîmî pepîn tiaron tî' pona, tîîse tamî'nawîrî yenumî to'ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mîrîrî pî' inenupa'sanya ekaranmapo'pî: —Î' pensa sîrîrî yaranka to'ya? —ta'pî to'ya. —O'non ye'ka pe awanî kupî sîrîrî mîrîrî e'kupî kupî ya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesusya yuuku'pî: —Tîwarî panpî' e'tî anî'ya ayenku'tîkon namai. Maasa pra tu'ke to' asarî kupî sîrîrî uyese' pî' teeseurîmasanon. Moropai taa to'ya: “Uurî Paapa narima'pî imenkasa' uurî”, taa to'ya. “Mîîkîrî erepansa' sîrîrî”, taa to'ya. Tîîse inkamoro ye'kakon maimu yawîrî pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Moropai teesi'nî'se pra e'tî, teepîsanon yekare etaya'nîkon ya yai tesanonkon yarakkîrî moropai teeyatonon yarakkîrî. Maasa pra e'mai' pe mîrîrî ye'ka e'kupî e'pai awanî mîrîrî. Tîîse mîrîrî neken ikî'pî taa eserîke pra man. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Pataponkon eseya'nama kupî sîrîrî tiaronkon pataponkon yarakkîrî. Tiaronkonya tiaron pataponkon wîî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","—Moropai tiaronkon pata po non eserentîkî'ma kupî sîrîrî mararî pra. Moropai emi'nan, iwan wanî kupî sîrîrî mararî pra. Moropai paran wanî kupî sîrîrî pata po. Mîrîrî ye'ka nari' wanî moropai kure'nan esewankono'manto' ton esenpo kupî sîrîrî ka' pî' tera'masen pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tîîse maasa mîrîrî ye'ka tamî'nawîron e'kupî rawîrî amîrî'nîkon yarî to'ya kupî sîrîrî uyese' wenai. Ataruma'tîkon to'ya kupî sîrîrî. Amîrî'nîkon yarî to'ya to' epere'to'kon yewî' ta apî'nîkon teeseurîmakonpa. Moropai mîrîrî tîpo atarakkannîto' yewî' ta ayarîkon to'ya. Uyese' wenai amîrî'nîkon yarî to'ya ipîkkukon pata esanon pia, moropai pata esanon reiyamî' pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mîrîrî yai uyese' pî' eeseurîmakon kupî sîrîrî. Paapa maimu ekaremekîya'nîkon inkamoro ipîkkukon pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—Mîrîrî ye'nen sîrîrî pata pai teesenumenkai pra e'tî, î' kai'ma inkamoro ye'ka maimu yuukukonpa, imaimu pra eesuwa'kakon namai. Î' kai'ma eseurîmakonpa pî' kîsenumenkatî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maasa pra uurîya amaimukon ton tîrî. Moropai uurîya epu'nen pe awe'to'kon ton tîrî. Inkamoro ayeyatonkonya yapîtanîpî yentai moropai amaimukon wa'ka to'ya yentai mîrîrî kupîuya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Amîrî'nîkon wanî atarakkannîto' yewî' ta tiaronkon pepîn rî ayunkon moropai aruinankon moropai ayonpakonya rî amîrî'nîkon yeka'ma. Inkamoroya rî tiaronkon ayonpakon wîî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Uyese' wenai tamî'nawîronkonya amu'tunpakon kupî sîrîrî. Ayewanmîrîkon to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Mîrîrî ye'nen innape ukupî pî' ako'mantî tîrumakai pra. Mîrîrî warantî ikupîya'nîkonya ya, awe'pîika'tîkon tamî'nawîrî, tiwin kin aama'takon pepîn —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Inî'rî Jesus eseurîma'pî. Ta'pîiya: —Î' pensa Jerusalém cidade woima'tîsa' surarayamî'ya yai mîrîrî epu'tîya'nîkon. Tiwinarî tamî'nawîronkon pemonkonyamî' tî'ka to'ya kupî pe tiwinarî tiwinan tînîmîi pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mîrîrî ye'nen anî' wanî ya Judéia pata po, ka'ne' pe eepe e'pai awanî wî' pona. Moropai anî' wanî ya cidade po, ka'ne' pe eepa'ka e'pai awanî. Moropai anî' wanî ya keren po, awenna'po e'pai pra awanî cidade pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maasa pra mîrîrî wei yai kure'nan e'taruma'tînto' wanî pe man. Mîrîrî e'kupî maasa pra Paapa maimuya taasa' manni' yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aka sa'ne manni'kan wîri'sanyamî' more yankon pia îri pe awanî. Maasa pra to' epe eserîke pra awanî ye'nen. Moropai manni'kan simonkokon to' munkîyamî' mana'pokonkon inkamoro pia îri awanî. Inkamoro e'taruma'tî kupî sîrîrî mîrîrî yai. Mîrîrî yai e'taruma'tînto' wanî kure'nan sîrîrî non po. Sîrîrî warantî tîpemonkonoyamî' Judeuyamî' taruma'tî Paapaya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Moropai mîrîrî yai inkamoro wîî to'ya kupî sîrîrî kasupara ke. Moropai tiaronkon yarî to'ya atarakkannîto' yewî' ta patakon poro. Moropai Judeuyamî' pepînya Jerusalém ponkon tî'ka kupî sîrîrî tamî'nawîrî yaretî'ka to'ya, iku'ne'tî weiyu esuwa'ka pîkîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Moropai inî'rî Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Era'ma ton e'kupî kupî sîrîrî wei pî' moropai kapoi pî' moropai sirikkîyamî' pî', moropai non po, moropai tamî'nawîron pata ponkon ena kupî sîrîrî kure'ne teesewankono'mai, eranne' pe, nari' pe eena kupî sîrîrî. Mararon pepîn sipa sipa pe tuna wanî etun warainon eta tîuya'nîkonya yai to' esi'nîpî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mîrîrî yai tamî'nawîronkon warayo'kon wîtîpîtî kupî sîrîrî yai mararî pra mîrîrî ye'ka e'kupî era'ma tîuya'nîkon yai. Maasa pra tamî'nawîron ka' pî' tîwe'sanon e'soroka mîrîrî yai mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mîrîrî yai uurî ka' poi iipî'pî pemonkon pe iipî era'ma to'ya kupî sîrîrî katupuru po. Meruntî ke pu'kuru wanî mîrîrî yai. Moropai kure'nan morî pu'kuru Paapa ya'karu ta wanî era'ma to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tauya sîrîrî mîrîrî ye'ka e'kupî era'maya'nîkon ya innape uyapurîtî meruntî ke a'tu'mîra teenai pra. Moropai enpen e'tî unîmîkî pî'. Maasa pra mîrîrî warantî awe'kupî ya, awe'pîika'tîkon kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mîrîrî tîpo inî'rî to' nepu'tî ton panton ekaremekî'pî Jesusya. Ta'pîiya: —Arawen ye' yeseru epu'nenan amîrî'nîkon moropai tiaron yei yeseru. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mîrîrî era'maya'nîkon see warantî. Arawen ye' ari'kuta ya, mîrîrî epu'tîya'nîkon mîrîrî aminke pra kono'pîtî wanî, mîrîrî areta ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mîrîrî warantî nîrî mîrîrî tera'masen ton e'kupî era'maya'nîkon ya, epu'tîya'nîkon aminke pra tamî'nawîronkon esa' pe Paapa ii'to' weiyu eseporî kupî sîrîrî epu'tîya'nîkon. Mîrîrî yai tesa'kon pe Paapa wanî tamî'nawîronkonya epu'tî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mîrîrî ye'nen enpenatatî sîrîrî itekare pî'. Mîrîrî e'kupî kupî sîrîrî maasa tamî'nawîronkon sa'manta pra tîîse. Inkamoro enen to' wanî mannan sa'manta pepîn mîrîrî e'kupî rawîrî era'ma to'ya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tamî'nawîron ataretî'ka ka' moropai non ataretî'ka inî' eesera'ma pepîn, tîîse umaimu ataretî'ka pepîn. Ipatîkarî aako'mamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mîrîrî ye'nen ta'pî Jesusya: —Tîwarî panpî' ako'mantî enpen. Sîrîrî non po ankonekakon pî' teesenumenkai pra moropai kure'ne festa pî' tîwe'se pra. Moropai kure'ne mai' pe tîwe'sen tenî'se pra ako'mantî. Kure'ne tarî aako'manto'kon yu'se pra. Awanmîra'nîkon mîrîrî weiyu erepamî namai inîmîkîya'nîkon pra tîîse. Mîrîrî weiyu yai wanî manni' kamo ye'marî ta iwîto' ton tîîsa' warantî. Inîmîkîiya pra tîîse kamo iipî te'marî taawîrî moropai iwîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mîrîrî warantî tamî'nawîronkon e'taruma'tîto' wanî kupî sîrîrî tamî'nawîrî sîrîrî pata po. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mîrîrî ye'nen tîwarî enpen e'tî. Moropai epîrematî tamî'nawîron mîrîrî awe'kupî manni' e'taruma'tînto' yapîtanîpîkonpa. Moropai innape uurî ka' poi iipî'pî pemonkon pe kupî pî' ako'mantî, uuipî yai yairî awanîkonpa —ta'pî Jesusya. Mîrîrî warantî pemonkonyamî' yenupa'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Moropai wei kaisarî Jesusya to' yenupa'pî epîremanto' yewî' ta. Tîîse ewaron ya eepa'kapîtî'pî. Moropai mîîkîrî ko'manpîtî'pî pata erenmapî pîkîrî oliveira ye'ka wî' po. ");
INSERT INTO mbcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Moropai tamî'nawîronkon pemonkonyamî' wîtîpîtî'pî pata erenmapî pra tîîse epîremanto' yewî' ta eeseurîma etai. Mîrîrî warantî Jesusya to' yenupa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Penane tîîko'manse Judeuyamî' entamo'kato' weiyu wanî'pî to' festarî itese' Páscoa. Mîrîrî yai isa'moto' ton pîn trigo puusa' yaku to'ya e'pîtî'pî kono' kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mîrîrî yai teepîremasanon esanon eseurîma'pî Moisés nurî'tîya yenupanto' pî' yenupatonkon yarakkîrî î' kai'ma ama' pe Jesus anwîpai tîwanîkon pî'. Aronne ikupî to'ya pra awanî'pî maasa pra arinîkon pemonkonyamî' nama tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mîrîrî yai Makui ewomî'pî Judas Iscariotes yewan ya'. Mîîkîrî Judas wanî'pî Jesus nenupa'san asakî'ne pu' pona tîîmo'tai'nîkon yonpa pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mîîkîrî Judas wîtî'pî eseurîmai teepîremasanon esanon pia. Moropai to' epîremato' yewî' era'manenan esanon pia. Î' kai'ma Jesus rumaka tîuya to' pia ekareme'se attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mîrîrî taa Judasya ye'nen inkamoro wanî'pî mararî pra taatausinpai. Mîrîrî ye'nen Judas pia tîniru tîrî tîuya'nîkon ta'pî to'ya itepe'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mîrîrî pî' Judasya —Morî pe man —ta'pî. Mîrîrî ye'nen î' kai'ma Jesus anapi'pai tîwanî pî' Judas esenumenka'pî arinîkonya era'ma pra tîîse, to' wanmîra ama' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Isa'moto' ton pîn trigo puusa' pî' to' entamo'ka weiyu erepamî'pî. Mîrîrî yai Judeuyamî'ya carneiroyamî' tî'ka e'pai awanî'pî tîwentamo'kato'kon ton mîrîrî festa itese' Páscoa yai. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mîrîrî yai nîrî Jesusya asakî'ne tînenupa'san yonpa mo'ka'pî to' yarimapa kai'ma. Inkamoro wanî'pî Pedro moropai João. Inkamoro pî' ta'pîiya see warantî: —Atîtî cidade pona Páscoa pî' entamo'kanto' ton konekatantî e'mai' pe —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Inkamoroya Jesus pî' ekaranmapo'pî: —O'non pata'se' entamo'kanto' ton koneka annaya yu'se awanî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesusya yuuku'pî: —Maasa etatî —ta'pîiya. —Cidade pona eewomîkon pe moro warayo' tuna mankanen eporîya'nîkon. Mîîkîrî wenairî matîtîi wîttî ta eerepamî pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Moropai wîttî ta eerepansa'kon pe wîttî esa' pî' makatîi: “Uyenupanenkonya anna yarimasa' sîrîrî tîpemonkonoyamî' pokonpe tîwentamo'ka Páscoa pî' pata'se' ton wîttî ekaranmapoi”, makatîi —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","—Mîîkîrîya kure'nan wîttî ekaremekî apî'nîkon tamî'nawîron mesakon ita tîwe'sen wîttî kawînpan ekaremekîiya. Mîrîrî ta entamo'kanto' ton mîkonekatîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Moropai inkamoro wîtî'pî. Moropai tamî'nawîrî î' kai'ma Jesusya ta'pî yawîrî wîttî eporî'pî to'ya. Moropai miarî entamo'kanto' ton koneka'pî to'ya Jesus ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Moropai mîrîrî tîpo, miarî Jesus ereuta'pî entamo'kai mesa pia tînenupa'san pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Moropai ta'pîiya tînenupa'san pî': —Kure'ne amîrî'nîkon pokonpe sîrîrî Páscoa pî' entamo'kapai uurî wanî'pî uurî e'taruma'tîto' rawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","—Tauya sîrîrî apî'nîkon. Ayenku'tîuya'nîkon pepîn. Sîrîrî entamo'kanto' wanî î' e'kupî ekareme'nen pe. Inî'rî apokonpe'nîkon entamo'ka pepîn î' e'kupî awe'ku'sa' pîkîrî. Mîrîrî yai tamî'nawîronkon tîpemonkonoyamî' esa' pe tîwanî Paapaya yenpo. Tîîse mîrîrî yai uyarakkîrî awentamo'kakon. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mîrîrî tîpo Jesusya pisa yapisî'pî. Moropai eepîrema'pî. —Paapa, morî pu'kuru amîrî. Anna wuku ton tîrî pî' nai —ta'pîiya. Moropai itîrî'pîiya tînenupa'san pia. Ta'pîiya: —Maa, seeni' yapi'tî moropai akaisarî'nîkon ita'nî'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","—Tauya sîrîrî apî'nîkon. Ayenku'tîuya'nîkon pepîn. Uusa'manta rawîrî inî'rî sîrîrî uva yekku enîrîuya kupî pepîn sîrîrî apokonpe'nîkon, tamî'nawîronkon esa' pe tîwe'to' yenpo Paapaya pîkîrî. Tîîse mîrîrî yai inî'rî upokonpe enîrîya'nîkon tarîpai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Moropai mîrîrî tîpo trigo puusa' yapisî'pîiya moropai eepîrema'pî. —Paapa, morî pu'kuru amîrî. Anna yuu ton tîrî pî' nai —ta'pîiya. Moropai mîrîrî pîrikka'pîiya moropai itîrî'pîiya tînenupa'san kaisarî. —Maa, sîrîrî wanî sîrîrî upun pe, uyesa' pe. Sîrîrî warantî uyesa' waikapîtî to'ya kupî sîrîrî amîrî'nîkon nîkupî'pî imakui'pî wenai. Mîrîrî ye'nen upî' awenpenatakon pe sîrîrî ya'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tîwentamo'kakon tîpo mîrîrî warantî nîrî to' wuku ton tîrî'pîiya pisa ya'. Moropai ta'pîiya: —Sîrîrî uva yekku wanî sîrîrî umînî pe. Mîrîrî wanî mîrîrî uurî'nîkon esetato' amenan pe. Maasa pra uusa'manta yai umînî kamouya amîrî'nîkon yepe' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tîîse maasa era'matî. Manni' uyeyatonon pî' uyekaremekî ton tarî man. Uupia eereutasa' entamo'kai uyarakkîrî ayonpakon rî. Mîîkîrîya uyekaremekî pe man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","—Maasa pra uurî ka' poi iipî'pî sa'manta kupî sîrîrî Paapaya ta'pî yawîrî. Tîîse mîîkîrî sa'ne uurî ekaremekîtîpon uyeyaton pî' e'taruma'tî kupî sîrîrî mararî pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mîrîrî pî' inkamoro inenupa'san esekaranmapo'pîtî'pî, tiaronkon tonpakon pokonpe. —Anî' see mîîkîrî ekaremekîton, anî' pî' taiya mîrîrî? —ta'pî to'ya tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mîrîrî tîpo inenupa'san eseurîma'pî mararî pra ipîkku pe anî' wanî anepu'pai tîwanîkon pî' tîkore'ta'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Inkamoro maimu yuuku'pî Jesusya: —A'kî, pata esanon reiyamî' wanî tamî'nawîronkon pemonkonyamî' esa' pe. Moropai pata esanon governadoryamî' wanî pemonkonyamî' yaipontînen pe. Moropai tamî'nawîronkon tapurîkon yu'se to' wanî. Ipîkkukon yeseru mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tîîse amîrî'nîkon kore'ta mîrîrî warantî pra e'tî. Anî' ipîkku pe panpî' tîwe'sen wanî ya akore'ta'nîkon, mîîkîrî e'pai awanî to' ma're panpî'. Moropai anî' to' yaipontînen ipîkku pe tîwe'sen wanî ya, mîîkîrî e'pai awanî to' poitîrî pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Anî' wanî mîrîrî ipîkku pe tîwe'sen warantî? Manni' entamo'ka ereuta'pî ou manni' to' entamo'kato' ton tîrîiya manni'? Inna, ipîkku pe tîwe'sen mesa pona eereutasa' manni'. Tîîse uurî wanî manni' to' ma're tîwanî ye'nen to' yekkari ton tîînen warantî akore'ta'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tîîse amîrî'nîkon kupîuya kupî sîrîrî ipîkkukon pe. Maasa pra amîrî'nîkon ko'mansa' uyarakkîrî. Uurî e'taruma'tî tanne urumakaya'nîkon pra awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mîrîrî ye'nen Uyunya uupia meruntî tîrî'pî tamî'nawîronkon esa' pe ukupî'pî warantî, amîrî'nîkon nîrî kupîuya pemonkonyamî' esa' pe awanîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mîrîrî ye'nen amîrî'nîkon entamo'ka moropai awukukon enîrîya'nîkon kupî sîrîrî uyarakkîrî upata'se' ya', taatausinpai. Moropai amîrî'nîkon ereuta kupî sîrîrî uyaponse' pona. Mîrîrî yai tamî'nawîronkon pemonkonyamî' Judeuyamî' esa' pe eenakon kupî sîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesus eseurîma ko'mannîpî'pî. Ta'pîiya: —Simão, maasa etakî morî pe. Paapaya Makuiya ayonpato' pata'se' ton tîîsa' man ayewankon ya'. Mîrîrî ye'nen ayonpaiya kupî sîrîrî. Apî' eesenyaka'ma manni' trigo pîmîtîponya imenka yare kore'tapai warantî, apî' ayonpaiya imakui'pî kupîpa. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tîîse apona epîrema ko'mansa' sîrîrî kure'ne innape ukupî pî' aako'mamîpa. Moropai î' pensa imakui'pî kupîya yai moropai uupia awenna'po ya, kure'ne ayonpayamî' meruntîtannîpîi —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Moropai Pedroya yuuku'pî: —Î' pensa amîrî e'taruma'tî ya uurî nîrî e'taruma'tî. Moropai aasa'manta ya, ayarakkîrî uusa'manta nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mîîkîrî pî' ta'pî Jesusya: —Apî' tauya, etakî. Sîrîrîpe kariwana etun rawîrî eseurîwî'ne ite'ka unepu'tî pepîn mîîkîrî taaya kupî sîrîrî —ta'pî Jesusya Pedro pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Moropai Jesusya tînenupa'san ekaranmapo'pî: —Manni' yai ayarimauya'nîkon yai isakuni pra moropai abolsarikon ton pra, moropai a'sa'sakon ton pra. Î' itu'se awe'to'kon ton pra awanî'pî? —ta'pî Jesusya. —Kaane, tamî'nawîrî wanî'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mîrîrî pî' ta'pî Jesusya: —Sîrîrî patapai tiaron pe awanî kupî sîrîrî. Anî' wanî ya tîbolsari ke moropai tîsakuni ke yapisîya e'pai awanî mîrîrî. Tîîse anî' ikasuparai ton pîn wanî ya, ta'san ke awe'repa e'pai awanî mîrîrî tîkasuparai ton yennapa. ˻Maasa pra nari' pe awanî kupî sîrîrî.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Maasa pra Paapa maimuya taasa' yawîrî awe'kupî e'pai awanî uyarakkîrî. Taasai'ya see warantî: Mîîkîrî wanî mîrîrî manni'kan pemonkon wîîtîponkon pokonpe iku'sa' to'ya mîrîrî. taasai'ya. Mîrîrî ye'nen apî'nîkon tauya, uyarakkîrî mîrîrî e'kupî pe man. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Moropai inenupa'sanya ta'pî ipî': —Anna yepotorî, asakî'ne kasupara man tarî ukore'ta'nîkon —ta'pî to'ya ipî'. Mîrîrî pî' —Aasîrî man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mîrîrî tîpo Jesus epa'ka'pî moropai attî'pî teserukon yawîrî oliveira ye'ka kîrî pona. Moropai inenupa'san nîrî wîtî'pî ipokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Miarî tîpata'se'kon ya' teerepamîkon pe, ta'pîiya tînenupa'san pî': —Epîrematî meruntî ke imakui'pî ewomî namai ayewankon ya'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mîrîrî taa tîpo to' pî' Jesus atarima'pî to' piapai aminke pu'kuru pra. Moropai mîîkîrî e'sekunka'pî miarî moropai eepîrema'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ta'pîiya: —Uyun, tamî'nawîron kupîya e'painon. Upîika'tîkî e'taruma'tî namai. Tîîse itu'se uurî wanî yawîrî kî'kupîi. Tîîse itu'se awanî yawîrî iku'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Moropai ka' poi inserî iipî'pî iipia. Mîîkîrîya meruntî ke ikupî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kure'ne teesewankono'mai Jesus epîrema'pî inî' panpî'. Mîrîrî yai eepîrema tanne eewaito' atasu'ka'pî mararî pra. Mîn warantî aatasu'ka'pî non pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Miarî teepîrema tîpo awe'mî'sa'ka'pî. Mîîkîrî enna'po'pî o'non pata tînenupa'san wanî manni' pata. Moropai inkamoro tînenupa'san eporî'pîiya to' wetun tanne. Maasa pra inkamoro esewankono'masa' wanî'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Moropai Jesusya ta'pî to' pî': —Î' wani' awanî ye'nen awetunkon pu'kuru mîrîrî? Apakatî moropai epîrematî imakui'pî ena namai ayentai'nîkon. Imakui'pî kupîya'nîkon namai epîrematî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus eseurîma ko'mannîpî tanne, tiwin inenupa'san yonpa Judas pokonpe arinîkon pemonkonyamî' Jesus yapi'se tui'sanon erepamî'pî Jesus pia. Mîîkîrî Judas wanî'pî to' ye'mai'norî pe. Mîrîrî yai Jesus pia emî'pamî'pî yu'napa. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mîîkîrî pî' ta'pî Jesusya: —Judas, mîrîrî warantî uyu'naya ke uurî ka' poi iipî'pî pemonkon pe rumakaya mîrîrî uyeyatonon yenya'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mîrîrî kupî to'ya era'ma tîuya'nîkon yai Jesus pî' inenupa'sanya ta'pî: —Anna yepotorî, anna kasuparai yapisî annaya sîrîrî inkamoro pemonkonyamî' yarakkîrî anna epîto'pe? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Moropai tiwinan to' yonpaya teepîremasanon esanon yepotorî poitîrî pana ya'tî'pî tîkasuparai ke meruntî winon taiken. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tîîse Jesusya ta'pî to' pî': —Kaane, mîrîrî warantî pra —ta'pîiya. Moropai Jesusya mîîkîrî warayo' pana yapisî'pî moropai ipata'pî ya' itîrî'pîiya, yepi'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mîrîrî pe rî teepîremasanon esanon pî' moropai epîremanto' yewî' era'manenan esanon pî' moropai Judeuyamî' esanon inkamoro tapi'se iipî'san pî' ta'pî Jesusya: —Amîrî'nîkon ii'sa' mîrîrî akasuparaikon moropai akaitapukon yarakkîrî uyapi'se manni' pemonkon ama'ye' si'pî yapi'se tui'sen warantî? ");
INSERT INTO mbcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Akore'ta'nîkon uuko'manpîtî'pî wei kaisarî epîremanto' yewî' ta ayenupakon pî'. Tîîse mîrîrî yai uyapisîya'nîkon pra awanî'pîkon. Tîîse sîrîrî imakui'pî kupîya'nîkon weiyu eseposa' sîrîrî. Moropai Makui esenyaka'mato' meruntîri ke mîrîrî kupîya'nîkon sîrîrî ewaron ta si'ma imakui'pî pe awanîkon ye'nen —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Moropai inkamoroya Jesus yapisî'pî. Moropai yarî'pî to'ya teepîremasanon esanon yepotorî yewî' ta. Moropai inkamoro ye'ma'pî pî' aminke si'ma Pedroya to' wenaima'pî, iipia awe'rennuku pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mîrîrî tanne, apo' awittanî'sa' to'ya wanî'pî wîttî poro yi'pîrî po taatapinato'kon ton. Mîrîrî pia Pedro wîtî'pî moropai eereuta'pî apo' pia pemonkonyamî' apo' pia ereuta'san kore'ta. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mîrîrî tanne teepîremasanon poitîrîpa'ya Pedro era'ma'pî apo' pia eereutasa'. Moropai ta'pîiya ipî': —A'kî mîserî warayo' wanî nîrî Jesus yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tîîse Pedroya kaane ta'pî wîri' pî': —Unepu'tî pepîn mîîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mîrîrî tîpo mararî tîîko'manse tiaron warayo'ya era'ma'pî moro rî. Moropai ta'pîiya ipî': —Amîrî itonpa ipokonpe tîwe'sen —ta'pîiya. —Kaane, itonpa pepîn uurî —ta'pî Pedroya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mîrîrî tîpo tiwin hora tîîko'manse tiaronya ta'pî: —Inna, seru' pepîn, mîserî nîrî wanî'pî mîîkîrî yarakkîrî. Maasa pra Galiléia pon mîîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tîîse Pedroya yuuku'pî: —Kaane, uyepu'tî pepîn pî' eseurîman pî' nai, tiwin kin mîîkîrî unepu'tî pepîn —ta'pîiya. Mîrîrî taa Pedroya tanne, kariwana yunkon e'na'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mîrîrî pe rî Uyepotorîkon era'tî'pî Pedro era'mai. Morî pe era'ma'pîiya. Tera'ma Uyepotorîkonya ye'nen Pedro enpenata'pî î' ta'pî Uyepotorîkonya pî'. —Sîrîrîpe maasa kariwana etun pra tîîse eseurîwî'ne ite'ka unepu'tî pepîn mîîkîrî taaya kupî sîrîrî —ta'pî Uyepotorîkonya pî' Pedro enpenata'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mîrîrî pe rî Pedro epa'ka'pî moropai attî'pî tîkarau ye'ka pe mararî pra. Eesewankono'ma'pî î' kai'ma seru'ye' tîwe'sa' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Inkamoro warayo'kon Jesus era'manenanya imu'tunpa'pî mararî pra. Moropai ipa'tîpîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jesus yenpata yettapurî'pî to'ya moropai taapîtî'pî to'ya: —Anî'ya apa'tîsa' epu'tî pî' nan? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mîrîrî warantî tu'ke î' rî see taapîtî'pî to'ya imu'tunpa tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Moropai erenma'sa' pe Judeuyamî' esanon moropai teepîremasanon esanon, moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon pokonpe to' emurukuntî'pî î' kupî tîuya'nîkon pî' eseurîmai. Moropai Jesus enepî me'po'pî to'ya inkamoro ipîkkukon emurukuntîsa' pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Inkamoroya Jesus ekaranmapo'pî: —Ka'kî anna pî'. Amîrî wanî Paapa nîmenka'pî pe, inarima'pî pe awanî? —ta'pî to'ya. To' maimu yuuku'pîiya: —Inna, Paapa narima'pî uurî tauya ya apî'nîkon innape ikupîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Moropai mîrîrî pî' uurîya ayekaranmapokon ya, umaimu yuukuya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tîîse tauya sîrîrî patapai uurî ka' poi iipî'pî pemonkon pe ereuta kupî sîrîrî Paapa meruntîri winî meruntî ke pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mîrîrî taiya ye'nen tamî'nawîronkonya ekaranmapo'pî: —Moriya, amîrî wanî Paapa munmu pe? —Inna, yairî amîrî'nîkonya taa mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Moropai inkamoroya ta'pî: —Inî'rî etapai pra man. Aasîrî iwinîpai eta'nîkon man. Î' kai'ma tîpî' eeseurîma imaimu eta man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mîrîrî tîpo tamî'nawîronkon emurukuntî'san e'mî'sa'ka'pî moropai surarayamî'ya Jesus yarî'pî pata esa' Pilatos pia. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Miarî ipî' tîîwo'ma'takon ye'nen to' eseurîma'pî ipî'. Ta'pî to'ya: —Mîserî warayo' yapisî pî' anna man, pemonkonyamî' panama pî' aako'mamî tanne. Uyesa'kon ye'ma to'ya namai taa pî' aako'mamî to' pî'. Moropai îri to' e'to'pe iwinîkîi. Moropai tîpî'rî eeseurîma Paapa narima'pî pe tîwanî ekaremekî pî' aako'mamî. Ipîkku pe, rei pe tîwanî taiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mîrîrî ye'nen Pilatosya Jesus ekaranmapo'pî: —Inna, amîrî wanî mîrîrî Judeuyamî' yepuru pe, rei pe? —Inna amîrîya taa mîrîrî —ta'pî Jesusya Pilatos pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Moropai Pilatosya ta'pî teepîremasanon esanon pî' moropai arinîkon pemonkonyamî' pî': —A'kî, Î' rî mîserî warayo' nîkupî'pî imakui'pî ton pra man iwinîkîi imakui'pî ku'to'pe —ta'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tîîse inkamoroya inî' panpî' seru' pe ikupî'pî iwinîkîi. —Imakui'pî ku'sai'ya mararî pra. Maasa pra tamî'nawîrî Judéia pata poro pemonkonyamî' panamasai'ya kure'ne imakui'pî ku'to'pe to'ya uyeserukon winîkîi. To' panama pia'tî'pîiya sinpata Galiléia po, tarîpai tarîwaya eerepansa' sîrîrî. Mîrîrî warantî to' panamaiya to' esiyu'pîtîto'pe —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mîrîrî taa to'ya eta tîuya ye'nen Pilatosya to' ekaranmapo'pî: —Galiléia pon mîîkîrî warayo'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mîrîrî pata Galiléia esa' pe Herodes wanî ye'nen Pilatosya Jesus yarî me'po'pî pata esa' Herodes pia. Maasa pra Herodes nîrî wanî'pî Jerusalém po festa pî' aai'sa'. Mîîkîrî pia yarî me'po'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kure'ne taatausinpai mîîkîrî pata esa' Herodes wanî'pî Jesus era'ma tîuya ye'nen. Maasa pra itekare pî' to' eseurîmapîtî etapîtî'pîiya. Mîrîrî ye'nen kure'ne anera'mapai awe'pîtî'pî. Î' ikupî eserîkan pepîn kupî Jesusya anera'mapai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mîîkîrîya tu'kan pî' Jesus ekaranmapopîtî'pî. Tîîse Jesusya imaimu yuuku pra awanî'pî. Inna, kaane taiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Moropai teepîremasanon esanon moropai Moisés nurî'tîya yenupanto' pî' yenupatonkon eseurîma'pî mararî pra iwinîkîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mîîkîrî pata esa' Herodes moropai ipoitîrîtonon surarayamî' wo'ma'ta'pî Jesus pî' tewanmakon pe. Ipî' tîwo'ma'takon ye'nen ipon ton mîî pe tîwanîkon pon yeka'ma'pî to'ya Jesus pon pe. Moropai mîrîrî yarakkîrî yarima'pî to'ya inî'rî pata esa' Pilatos pia attîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mîrîrî rawîrî Herodes wanî'pî Pilatos yeyaton pe. Tîîse mîrîrî yai morî pe to' enasa' wanî'pî inî'rî eseyaton pî' pra to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Moropai pata esa' Pilatosya teepîremasanon esanon, moropai Judeuyamî' esanon moropai tamî'nawîronkon pemonkonyamî' emurukuntî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Moropai ta'pîiya to' pî': —Amîrî'nîkonya mîserî warayo' enepî'pî uupia moropai ta'pîya'nîkon pemonkonyamî' panamasai'ya awinîkîi imakui'pî pe to' e'to'pe ta'pîya'nîkon teuren. Tîîse î' rî imakui'pî inkupî eporîuya pra wai. Tu'ke ite'ka ekaranmapo pî' wai teuren tamî'nawîrî etaya'nîkon tanne. Tîîse eeseurîma'pîkon warantî î' ton pra man iwinîpai —ta'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","—Moropai pata esa' Herodesya nîrî î' eporî pra man iwinîpai. Mîrîrî ye'nen yarimasai'ya sîrîrî uupia. Mîrîrî ye'nen î' kupî eserîke pra man mîserî warayo' winîkîi. Imakui'pî inkupî'pî ton pra tîîse iwî eserîke pra man. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tîîse i'po'pîtî me'pouya neken sîrîrî pemonkon po'pî'to' ke moropai irumakauya attîto'pe —ta'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Maasa pra kono' kaisarî páscoa festa pî' tîwanîkon yai ama'ye' atarakkannîto' tawon rumakato' Pilatosya e'pîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tîîse tamî'nawîronkon entaime'pî: —Kaane, aasa'manta e'pai man kî'rumakai. Tîîse manni' neken anna yonpa Barrabás mîîkîrî atarakkannîto' ta manni' rumakakî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mîîkîrî Barrabás wanî'pî atarakkannîto' ta maasa pra imakui'pî koneka'tîpon pata esa' winîkîi moropai pemonkon wîîtîpon. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesus anrumakapai tîwanî ye'nen inî'rî Pilatosya arinîkon pemonkonyamî' ekaranmapo'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tîîse inî' panpî' arinîkon entaimepîtî'pî. Ta'pî to'ya: —Pakî'nan pona ipokapîtî me'pokî —ta'pî to'ya Pilatos pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mîrîrî taa to'ya ye'nen iteseurîno ite'ka pe Pilatosya ta'pî to' pî': —Î' wenai ipokapîtî yu'se awanîkon. Î' imakui'pî ku'sai'ya pra man. Î' wenai pra rî anwîpai pra wai. Tîîse pemonkon po'pî'to' ke neken i'po'pîtî me'pouya sîrîrî moropai irumakauya —ta'pî Pilatosya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tîîse yuuku to'ya pra inî' panpî' meruntî ke to' entaimepîtî'pî. Pakî'nan pona ipokapî tîuya yu'se to' wanî'pî. To' entaimepî'to' wanî'pî mararî pra, î' taa Pilatosya yentai. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mîrîrî ye'nen Pilatosya Jesus rumaka'pî aasa'mantato'pe pakî'nan po esatî'pî to'ya yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Moropai mîîkîrî warayo' atarakkannîto' tawon to' nesatî'pî rumaka'pî. Manni' imakui'pî kupîtîpon pata esa' winîkîi, moropai pemonkon wîîtîpon. Moropai Jesus rumaka'pîiya to' pia î' itu'se tîwe'to'kon ku'to'pe to'ya yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Moropai surarayamî'ya Jesus yarî'pî. Tuutîkon pe e'ma ta tiwin warayo' eporî'pî to'ya itese' Simão. Cirene cidaderî pon keren poi tui'sen. Mîîkîrî yapisî'pî to'ya. Moropai mîrîrî pakî'nan Jesus narî tîrî'pî to'ya Simãoya yaato'pe Jesus ye'ma'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mîrîrî arinîkon pemonkonyamî' wîtî'pî iwenairî. Inkamoro kore'ta tiaronkon wîri'sanyamî' wanî'pî. Moropai to' karawa'pî mararî pra î' kupî to'ya era'ma tîuya'nîkon ye'nen Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Inkamoro era'mai Jesus era'tî'pî. Moropai ta'pîiya to' pî': —Wîri'sanyamî', Jerusalém ponkon î' pî' akaraukon uwenai? Uwenai pra tîîse apî'nîkon neken akaruntî moropai anmukukon pî' akaruntî. Maasa pra awe'taruma'tîkon pe naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maasa pra e'taruma'tînto' weiyu erepamî kupî sîrîrî. Mîrîrî yai tamî'nawîronkonya taa kupî sîrîrî. Morîkon pu'kuru wîri'sanyamî' manni'kan more yenponenan pepîn, more yenpotîponkon pepîn, more wo'pa'tîponkon pepîn tîmannîtîkon ke. Inkamoro wanî kupî sîrîrî taatausinpai. ˻Maasa pra tînmukukon e'taruma'tî era'ma to'ya pepîn.˼ ");
INSERT INTO mbcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tamî'nawîronkonya taa kupî sîrîrî, e'taruma'tînto' weiyu erepamî yai. Kure'nan wî' pî' taa to'ya kupî sîrîrî: “Anna pona enakî, anna sa'mantato'pe anna e'taruma'tî ye'nen”, taa to'ya. Moropai kawînan ikîrî pî' taa to'ya: “Anna yenonkî anna esera'ma namai”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A'kî, uurî e'taruma'tî tîîse mararî, apo' keme a'pi'ta'pî pepîn aramî mararî warantî. Tîîse amîrî'nîkon wanî apo' keme a'pi'ta'pî aramî warantî awe'taruma'tîkon kupî sîrîrî mararî pra. Mîrîrî ye'nen apî'nîkon akaruntî uwenai pra —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mîrîrî tîpo asakî'ne ama'ye'kon moropai pemonkon wîîtîponkon yarî'pî to'ya Jesus yarakkîrî to' sa'mantato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Moropai to' erepamî'pî pata'se' itese' pemonkon pu'pai pî' taato' pata'se' ya'. Moropai moro Jesus pokapîtî'pî to'ya. Moropai asakî'ne ama'ye'kon tiwin meruntî winî, moropai tiaron kamai' winî, Jesus wanî'pî to' yarakkita. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Moropai Jesusya ta'pî: —Paapa, insanan sa'ne pemonkonyamî' nîkupî ku'kî aawanmîra. Î' kupî tîuya'nîkon epu'tî to'ya pra to' man —ta'pî Jesusya. Mîrîrî tîpo tî'kon simonkokon pî' to' su'mina'pî Jesus pon rî'pî pantakapîtî tîuya'nîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Arinîkon pemonkonyamî' wanî'pî moro era'ma pî'. Judeuyamî' esanon wo'ma'ta ko'mannîpî tanne Jesus pî' ta'pî to'ya: —Tiaronkon pemonkonyamî' pîika'tîpîtî'pîiya tîîse î' wani' awanî ye'nen awe'pîika'tî pepîn. Innape pîika'tîton pe Paapa narima'pî pe tîwanî ya, awe'pîika'tî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Moropai surarayamî' nîrî wo'ma'ta'pî ipî'. Iipia to' erepanpîtî'pî moropai iwuku ton ˻tamî'nawîronkon nenîrî˼ vinho epe'mîn enepî'pî to'ya iipia. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Moropai inkamoroya ta'pî ipî': —Innape see Judeuyamî' yepotorî pe awanî ya, aawarîrî see e'pîika'tîkî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Moropai mîrîrî pakî'nan ipo Jesus e'to' pî' kawîne awe'menukasa' wanî'pî see warantî: MÎSERÎ JUDEUYAMÎ' YEPOTORÎ taato' e'menukasa'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Moropai inkamoro ama'ye'kon ipokonpe pakî'nan po to' nîpokapîtî'san yakon wo'ma'ta'pî ipî'. Ta'pîiya: —Paapa narima'pî pepîn kin amîrî? Pîika'tîton pepîn amîrî? Aawarîrî e'pîika'tîkî moropai anna pîika'tîkî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tîîse tiaron iratai winonya ta'pî mîîkîrî tîîwo'ma'tasen pî': —Moo e'kî. Paapa namaya pra awanî mîrîrî? Tamî'nawîrî uurî'nîkon sa'manta kupî epu'tîya pra nan, ipokonpe? ");
INSERT INTO mbcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Uurî'nîkon e'taruma'tîto' wanî sîrîrî unkupî'pîkon imakui'pî wenai. Tîîse mîserî î' imakui'pî inkupî'pî ton pîn uurî'nîkon warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mîrîrî tîpo mîîkîrî iratai winon, meruntî winonya ta'pî Jesus pî': —Î' pensa tamî'nawîronkon esa' pe eena ya, upî' sa'ne menpenatai, Jesus —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesusya mîîkîrî maimu yuuku'pî: —Ayenku'tîuya pepîn. Apî' tauya sîrîrî. Sîrîrîpe uyarakkîrî awanî pe nai Paapa pia, morî ya', paraíso itese' —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mîrîrî tîpo ineka'ta po eena ko'mannîpî tanne wei esi'nîpî'pî. Inî'rî pata weiyu'maiya pra, eewaronpamî'pî. Aako'mamî'pî 3 horas pîkîrî wei ton pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Moropai epîremanto' yewî' yuwato' Paapa pata'se' yuwa'to' kamisa e'karaka'pî arakkita pairî awe'rataika'pî. Awe'naponka'pî Paapa pata'se'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mîrîrî pe rî Jesus entaime'pî meruntî ke aronne. Ta'pîiya Paapa pî': —Paapa, uyekaton rumakauya sîrîrî aapia —ta'pîiya. Mîrîrî taa tîpo mîîkîrî sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mîrîrî warantî awanî era'ma tîuya ye'nen surarayamî' esa'ya Paapa yapurî'pî. Moropai ta'pîiya: —Innape mîserî warayo' man î' rî imakui'pî kupîtîpon pe pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tamî'nawîronkon mîrîrî kupî to'ya era'mai eperepî'sanya î' e'kupî era'ma'pî. Mîrîrî ye'nen to' enna'po'pî, mararî pra teesewankono'mai tewî'kon ta. Tîmannîtîkon mun pa'tîpîtî ye'ka pe teserukon ta kure'ne teesewankono'masa'kon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tamî'nawîronkon Jesus yonpayamî' moropai wîri'sanyamî' Galiléia pata poi itî'san ipîkîrî inkamoroya era'ma'pî. Aminke si'ma tamî'nawîrî î' e'kupî Jesus yarakkîrî era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mîrîrî yai to' kore'ta tiwin warayo' wanî'pî. Judéia pata po tîwe'sen Arimatéia cidaderî pon itese' José. Morî pe yairî tîwe'sen mîîkîrî. Tamî'nawîronkon esa' pe Paapa iipî nîmîkî pî' tîwe'sen pe mîîkîrî wanî'pî. Mîîkîrî wanî'pî nîrî Judeuyamî' panamanen pe tîwe'sen pe. Tîîse î' kai'ma tiaronkon Judeuyamî' panamanenan eseurîmato' pî' inna taatîpon pe pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mîrîrî ye'nen José wîtî'pî Pilatos pia moropai Jesus esa'rî'pî esatî'pîiya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Moropai imo'ka'pîiya pakî'nan poi. Mîîkîrî wontî'pîiya kamisa ke. Moropai uuruwai tî' yai yakasa' ya' yeka'ma'pîiya. Mîrîrî uuruwai wanî'pî isa'manta'pî yu'na'tî'pî pepîn. Mîrîrî ya' yeka'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mîrîrî kupî'pîiya aminke pra Judeuyamî' erî'ka'to' weiyu e'sara'tî rawîrî, sábado weiyu rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Moropai inkamoro wîri'sanyamî' Galiléia poi Jesus pîkîrî itî'san wîtî'pî uuruwai pona José pokonpe. Inkamoroya uuruwai era'ma'pî. Moropai o'non ye'ka pe Jesus esa'rî'pî tîrî to'ya uuruwai ya' era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Moropai mîrîrî tîpo to' enna'po'pî wîttî ta. Moropai inkamoroya kara' a'pusin yanpuruma'pî moropai óleo teserukon yawîrî Jesus esa'rî'pî karapaimakonpa. Moropai Judeuyamî' erî'ka'to' weiyu yai to' erî'kapî'pî teserukon yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Moropai Judeuyamî' erî'ka'to' weiyu sábado esuwa'kasa' tîpo, domingo yai wîri'sanyamî' wîtî'pî uuruwai pona penane pu'kuru wei epa'ka pra tîîse. Mîrîrî a'pusin yarî'pî to'ya Jesus esa'rî'pî karapaimakonpa tînkoneka'pîkon yarî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Miarî uuruwai pona teerepamîkon pe, inkamoro wîri'sanyamî'ya tî' uuruwai yettapuru pe to' nîtîrî'pî era'ma'pî imo'kasa' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Moropai inkamoro ewomî'pî uuruwai ya' Jesus esa'rî'pî karapaimai. Tîîse Uyepotorîkon Jesus esa'rî'pî eporî to'ya pra to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mîrîrî ye'nen î' kupî tîuya'nîkon epu'tî to'ya pra to' ena'pî. Mîrîrî pe rî ka'ne' pe asakî'nankon warayo'kon esenpo'pî to' rawîrî. Inkamoro pon wanî'pî morî pe pu'kuru inke' awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Moropai inkamoro wîri'sanyamî' esi'nîpî'pî mararî pra. Mîrîrî ye'nen inkamoroya tenpatakon enu'tî'pî non ekaya to' e'muruika'pî. Moropai inkamoro warayo'konya ta'pî to' pî': —Î' wani' awanî ye'nen anî' yuwaya'nîkon mîrîrî isa'manta'san kore'ta aasa'mantasa' pra tîîse? —ta'pî to'ya wîri'sanyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Mîîkîrî ton pra man tarî. Awe'mî'sa'ka pî' man. Awenpenatakon pra naatî î' kai'ma apî'nîkon ta'pîiya pî' Galiléia pata po tîwanî yai? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","—“Uurî ka' poi iipî'pî pemonkon pe rumaka to'ya kupî sîrîrî imakui'san pemonkonyamî' yenya'. Mîrîrî tîpo pakî'nan pona upokapîtî to'ya. Moropai e'mî'sa'ka iteseurînon wei yai”, ta'pîiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mîrîrî taa to'ya ye'nen inkamoro wîri'sanyamî' enpenata'pî î' kai'ma Jesus eseurîma'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Moropai inkamoro enna'po'pî uuruwai poi. Moropai inkamoroya î' tînera'ma'pîkon uuruwai po ekaremekî'pî Jesus nenupa'san pî' 11 kaisaronkon pî' moropai tiaronkon pemonkonyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Inkamoro wîri'sanyamî' wanî'pî itî'san uuruwai pona see warantî: Maria Madalena, moropai Joana, moropai Maria Tiago yan, moropai tiaronkon wîri'sanyamî'. To' pokonpe itî'sanya ekaremekî'pî Jesus naipontî'san pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tîîse innape inkamoro wîri'sanyamî' eseurîmato' kupî to'ya pra Jesus nenupa'san wanî'pî. To' wo'ma'ta kai'ma to' wanî'pî innape ikupî to'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tîîse tiwin to' yonpa, Pedro e'mî'sa'ka'pî. Moropai eeka'tumî'pî ka'ne' pe uuruwai pona. Miarî teerepansa' uuruwai ya' era'mai awe'muruika'pî tîîse kamisa neken Jesus ya'santî'pî neken era'ma'pîiya. Anî' ton pra era'ma'pîiya. Mîrîrî tîpo mîîkîrî enna'po'pî wîttî ta mararî pra teesenumenkai î' kai'ma awe'ku'sa' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mîrîrî yai rî asakî'ne Jesus nenupa'san wîtî'pî pemonkonyamî' ko'manto' mîrikkî itese' Emaús pona. Mîrîrî wanî'pî aminke pu'kuru pra tîwe'sen pe Jerusalém pî' 10 quilómetros kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Inkamoro eseurîma yarî ko'mannîpî'pî tuutîkon e'ma taawîrî î' kai'ma Jerusalém po e'kupî'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mîrîrî pî' to' eseurîma'pî. Mîrîrî tanne Jesus iipî'pî to' pîkîrî, moropai to' pokonpe attî'pî e'ma taawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mîîkîrî tîpîkîrî'nîkon tui'sen era'ma'pî Jesus nenupa'sanya tîîse anî' pe awanî epu'to' to'ya e'tîrî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Inkamoro ekaranmapo'pî Jesusya tuutî ye'ka pe. —Î' pî' eeseurîmakon mîrîrî e'ma taawîrî attîkon ye'ka pe? —ta'pîiya. Moropai inkamoro emî'pamî'pî tuutîkon ye'ka pe teesewankono'mai. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Moropai tiaron iwanîyakon Cléopasya ta'pî ipî': —Amîrî wanî Jerusalém po tîîko'mansen pe pu'kuru tîîse î' e'kupî'pî miarî epu'tîya pra awanî, sîrîrî wei esuwa'ka manni' pî'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Î' kin e'kupî'pî? —ta'pî Jesusya ipî'. —Manni' Jesus Nazaré pon yarakkîrî awe'kupî'pî —ta'pî to'ya. —Mîîkîrî warayo' wanî'pî Paapa maimu ekareme'nen pe profeta pe. Moropai Paapa winîpainon pe tamî'nawîronkon pemonkonyamî'ya epu'tî'pî Paapa meruntîri yarakkîrî awanî. Maasa pra î' ikupî eserîkan pepîn kupî'pîiya tîmaimu ke. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Teepîremasanon esanonya moropai uyesanonkonya irumaka'pî iwîto'pe to'ya kai'ma. Moropai pakî'nan pona ipokapî'to'pe to'ya itîrî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mîîkîrîya uyeyatonon winîpai umo'kakon ko'mannîpî kai'ma anna wanî'pî. Tîîse amenrî mîini ko'manpara ne'rî î' kupî'pî to'ya yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tîîse anna yonpayamî' wîri'sanyamî'ya anna esenumenka emapu'tî pî' man. Maasa pra inkamoro wîtîn pî' man erenmapî ya' uuruwai pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Moropai inkamoroya Jesus esa'rî'pî eporî pra man miarî uuruwai ya'. Tîîse tîwenna'poi inkamoroya inserîyamî' neken era'ma tîuya'nîkon ekaremekî pî' man. Moropai inkamoro inserîyamî'ya taasa' man to' pî'. “Enen mîîkîrî wanî”, taasa' to'ya man. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Moropai tiaronkon anna yonpayamî' wîtîn pî' man innape awanî era'mai uuruwai pona. Moropai innape era'ma pî' to', wîri'sanyamî'ya ekaremekî warantî. Tîîse Jesus era'ma to'ya pra man —ta'pî Cléopasya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mîrîrî pî' ta'pî Jesusya to' pî': —Î' kai'ma see epu'tîya'nîkon pra aako'mamîkon mîrîrî? Innape iku'sa'ya'nîkon pepîn mîrîrî. Î' kai'ma Paapa maimu ekareme'nenan penaronkon profetayamî' eseurîma'pî epu'tîya'nîkon pra awanîkon? ");
INSERT INTO mbcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Maasa pra mîrîrî warantî Paapa narima'pî iwinîpainonya tîmoron epu'tî e'pai awanî'pî. Mîrîrî tîpo neken tîwe'taruma'tî tîpo Paapa pia eereuta e'pai awanî ka' po ipîkku pe, Paapa ya'karu ta —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moropai tamî'nawîrî î' kai'ma Paapa maimu e'menukasa' tîpî' ekaremekî pia'tî'pîiya. E'mai'non Moisés kaaretarî patapai moropai tamî'nawîronkon Paapa maimu ekareme'nenan profetayamî' nîmenuka'pî pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mîrîrî pemonkonyamî' ko'manto' pona teerepamîkon tanne Jesusya tuutî ko'mannîpî warantî ikupî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Moropai inkamoroya yeka'nunka'pî mîrîrî pata ya' aako'manto'pe tîpokon pe'nîkon. Ta'pî to'ya: —Anna pokonpe e'nîpai man. Maasa pra pata ko'mannî pî' man. Ewaron erepannî pî' man —ta'pî to'ya. Mîrîrî ye'nen Jesus ewomî'pî to' pokonpe. Moropai aako'mamî'pî asakî'nankon tînenupa'san pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mîîkîrî ereuta'pî mesa pia to' pokonpe entamo'kai. Moropai mîîkîrîya trigo puusa' yapisî'pî. Moropai eepîrema'pî. —Paapa morî pe man anna yuu ton tîrî pî' nai —ta'pîiya. Moropai mîrîrî trigo puusa' pîrikka'pîiya moropai inkamoro asakî'nankon pia itîrî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mîrîrî kupîiya wenai inkamoroya Jesus pe awanî epu'tî'pî. Epu'to' to'ya erepamî'pî mîrîrî yai. Tîîse inî'rî era'ma to'ya pra to' ena'pî. To' yenu yapai eesenomî'pî ka'ne' pe. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Moropai tîîwarîrî'nîkon to' eseurîma'pî. Tiaronya ta'pî: —A'kî, mîîkîrî pe awanî ye'nen eeseurîmato'ya uyewankon yeurîma ne'tîkini uyeurîmaiya'nîkon tanne e'ma taawîrî. Moropai Paapa maimu pî' uurî'nîkon yeurîma'pîiya aronne. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Moropai inkamoro e'mî'sa'ka'pî ka'ne' pe, moropai to' wîtî'pî Jerusalém pona. Miarî teerepamîkon pe inkamoro Jesus nenupa'san 11 kaisaronkon emurukuntîsa' eporî'pî to'ya tiaronkon pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Moropai inkamoro tiaronya ekaremekî'pî to' pî': —Innape Uyepotorîkon e'mî'sa'ka'pî man. Tîîse Simãoya Uyepotorîkon era'ma pî' man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mîrîrî tîpo inkamoro asakî'nankonya î' e'ku'sa' e'ma taawîrî tarakkîrî'nîkon ekaremekî'pî nîrî to' pî'. Moropai î' kai'ma Uyepotorîkon pe awanî epu'tî tîuya'nîkon ekaremekî'pî to'ya. Maasa pra trigo puusa' pîrikkaiya wenai epu'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mîrîrî tînera'ma'pîkon ekaremekî to'ya tanne Jesus esenpo'pî to' kore'ta ka'ne' pe. Mîîkîrîya ta'pî to' pî': —Tîîwanmîra e'tî teesewankono'mai pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mîrîrî pî' to' wanî'pî teesi'nî'se. Teesi'nî'sa'kon ye'ka pe to' esenumenka'pî ipî' woro'yan kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tîîse mîîkîrîya ta'pî to' pî': —Î' wani' awanî ye'nen eesi'nî'sa'kon mîrîrî? Î' wani' awanî ye'nen innape ukupîya'nîkon pra aako'mamîkon sîrîrî tîpose? ");
INSERT INTO mbcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","A'kî, era'matî maasa uyenya wanî a'ta ke prego yetta'pî. Moropai u'pu era'matî. Moropai uurî era'matî, uurî mîîkîrî manni'rî uurî. Maasa uyapîtî innape ukupîkonpa woro'yan pe pra wanî epu'tîkonpa. Maasa pra woro'yan wanî pepîn tîpun ke, moropai te'pî ke, uurî era'maya'nîkon manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mîrîrî taa tîuya ye'ka pe, tenya moropai tî'pu yenpo'pîiya era'mato'pe to'ya kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tîîse inkamoroya maasa innape wanî kupî pra awanî'pî. Maasa pra kure'ne taatausinpai to' wanî'pî mararî pra teesenumenkakon ye'ka pe Jesus esenposa' pî'. Inkamoro ekaranmapo'pî Jesusya: —Ayekkarikon rî moro nai annapîkon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Moropai inkamoroya moro' puusa' pia'pî tîrî'pî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mîîkîrîya yapisî'pî moropai awentamo'ka'pî era'ma to'ya tanne. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mîrîrî tîpo ta'pîiya to' pî': —Pena akore'ta'nîkon wanî yai eseurîma'pî apî'nîkon ekaremekî'pîuya î' kai'ma uyarakkîrî awe'kupî ton pî'. Moisés kaaretarî eseurîma'pî upî'. Moropai penaronkon Paapa maimu ekareme'nenan profetayamî' nîmenuka'pî eseurîma'pî upî'. Moropai Salmos kaaretarî eseurîma'pî upî'. Tamî'nawîrî mîrîrî ta'pî Paapa maimu yawîrî awe'kupî e'pai awanî'pî uyarakkîrî ta'pî sa'rî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Moropai Jesusya Paapa maimu epu'tî to'ya emapu'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Moropai ta'pîiya: —Mîrîrî awe'menukasa' manni'ya taa mîîkîrî Paapa nîmenka'pî, inarima'pî e'taruma'tî pe man aasa'manta pe man. Moropai iteseurînon wei yai awe'mî'sa'ka kupî sîrîrî —ta'pîiya. Tîpî'rî eeseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","—Moropai inî'rî awe'menukasa' mîrîrî, itekare esekaremekî pata kaisarî. Î' kai'ma imakui'pî tînkupî'pîkon rumaka pemonkonyamî'ya ya, Paapaya tîîwanmîra to' makui kupî. Tamî'nawîronkon pî' itekare ekaremekî e'pai awanî. E'mai' pe isara'tî e'pai awanî Jerusalém cidaderî po. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amîrî'nîkon wanî mîrîrî ekareme'nenan pe maasa pra era'masa'ya'nîkon ye'nen aasîrî. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Moropai uurîya Paapa winîpainon yarima kupî sîrîrî. Yarima tîuya ta'pî Paapaya mîîkîrî yarimauya aapia'nîkon. Tîîse maasa inîmî'tî tarî cidade po si'ma meruntî iipî nîmî'tî ayesa'kon pe aako'manto'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mîrîrî tîpo Jesusya to' yarî'pî cidade poi tiaron pemonkonyamî' ko'manto' Betânia itese' pona. Miarî teerepansa'kon pe Jesusya tenya kainumî'pî kakîsiya, moropai —Morî pe ako'mantî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Inkamoro yarakkîrî teeseurîma ye'ka perî Jesus atarima'pî to' piapai. Moropai Paapaya yanu'nîpî'pî ka' pona. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Inkamoroya yapurî'pî miarî si'ma. Moropai to' enna'po'pî Jerusalém pona mararî pra taatausinpai. ");
INSERT INTO mbcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Inkamoro ko'mamî'pî mîrîrî tîpo epîremanto' yewî' ta tîîko'man pe. Miarî si'ma Paapa yapurî'pî to'ya.");
INSERT INTO mbcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Eesippia'tî yai moro Mai tesa'sen wanî'pî. Mîîkîrî Mai wanî'pî Paapa pia. Moropai mîîkîrî Mai wanî'pî Paapa pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mîîkîrî rî wanî'pî Paapa pia tamî'nawîron esippia'tî yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mîîkîrî wenai tamî'nawîron koneka'pî Paapaya. Î' rî ekoneka pra awanî'pî mîîkîrî ton pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Awanî'pî enen ko'mannîto' esa' pe. Enen ko'mannîto' iipiapainon, mîrîrîya pemonkonyamî' weiyu'ma'pî morî pe Paapa epu'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ewaron ya' pu'kuru awitta pî' aako'mamî tîîse ewaron ta tîîko'mansenon, imakui'sanya mîrîrî a'ka yi'nîpî eserîke pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Paapaya warayo' yarima'pî, itese' João. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mîîkîrî iipî'pî eseurîmai, manni' a'ka pe tîwe'sen pî' eseurîmai, tamî'nawîronkonya a'ka pe tîwe'sen ku'to'pe innape tîmaimu wenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A'ka pe tîwe'sen pepîn mîîkîrî João, tîîse Paapaya yaipontî'pî a'ka pe tîwe'sen yekare ekareme'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mîîkîrî a'ka pe tîwe'sen manni' wanî'pî innape, yenku'tîton pe pra. Mîîkîrî tamî'nawîronkon pemonkonyamî' weiyu'manen iipî'pî sîrîrî pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mîîkîrî asarî'pî sîrîrî non poro, tînkoneka'pî pu'kuru poro, tîîse mîîkîrî pe epu'tî to'ya pra, sîrîrî non po tîîko'mansenon wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tarîwaya tîpata pe tînkoneka'pî pona aaipî'pî. Tîîse ipemonkonoyamî'ya yapisî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tîîse tapisîtîponkon pia itîrî'pîiya Paapa munkî pe to' enato'pe, manni'kan innape tîkupîtîponkon pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Paapa munkî pe inkamoro esenpo'pî, pemonkon pe esenpon warantî pra. Itu'se tîwe'to' yawîrî to' esenpo pra awanî'pî. Moropai itu'se anî'rî e'to' yawîrî pra, tîîse itu'se tîwanî ye'nen, Paapaya ikupî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mîîkîrî Mai esenpo'pî pemonkon pe. Uurî'nîkon kore'ta aako'mamî'pî. Morî pu'kuru iteseru era'ma'pî annaya. Mîrîrî wenai î' kai'ma iyun Paapa yeseru wanî epu'tî'pî annaya. Innape pu'kuru awanî, morî pe pu'kuru mîîkîrî e'to' wanî, tiwinan Paapa munmu yeseru pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João nurî'tî eseurîmapîtî'pî ipî' see warantî: —Mîîkîrî warayo' pî' uurî eseurîmapîtî ne'tîkini —ta'pîiya. —Uye'ma'pî pî' Mîîkîrî iipî, tîîse uyentai awanî, maasa pra uurî ton pra tîîse Mîîkîrî wanî'pî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iwinîpai morî epe'mîn yapi'nenan uurî'nîkon tamî'nawîrî. Kure'ne morî tîîsai'ya. Morî tîîsai'ya morî pe tîwanî ye'nen, morî antîîpai tîwanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés nurî'tî yai Paapaya tîmaimu tîrî'pî unkupîkon ton pe. See warantî ako'mantî awe'taruma'tîkon namai, kai'ma. Tîîse Jesus Cristo yai, yairon Paapa epu'tî moropai î' kai'ma morî epe'mîn tîrîiya epu'tî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Anî'ya Paapa era'masa' pra man sîrîrî tîpose. Tîîse tiwinan Paapa munmu, Paapa pia pu'kuru tîîko'mansen, mîîkîrîya Paapa yeseru ekareme'sa' sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalém poi teepîremasanon moropai tonpakon Levitayamî' yarima'pî Judeuyamî' esanonya João pia ekaranmapoi: —Anî' amîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","See warantî to' maimu yuuku'pîiya. Aronne eesekaremekî'pî. Ta'pîiya: —Uurî Paapa nîmenka'pî, pîika'tîton pepîn. Cristo pepîn uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Moropai ta'pî to'ya: —Anî' kin amîrî moriya? Elias nurî'tî ka'rî amîrî? Joãoya ta'pî: —Kaane. Inî'rî ta'pî to'ya: —Pena Paapa maimu ekareme'nen, manni' Moisés nurî'tî nekaremekî'pî aaipî ton manni' ka'rî awanî? —ta'pî to'ya. —Kaane —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Anî' pe kin awanî mîrîrî? —ta'pî to'ya. —Anna pî' ka'kî ekareme'to'pe annaya anna yarimatîponkon pî'. Î' taa pî' nan anna pî'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Joãoya yuuku'pî: —Uurî keren po eseurîmakoi Isaías nurî'tî nekaremekî'pî. “Uyepotorîkon ye'marî ton konekatî to'sarî pu'kuru tauya tamî'nawîronkon pî'”. Pena Paapa maimu ekareme'nen Isaías nurî'tî nekaremekî'pî ˻pemonkonyamî' ekonekato'pe Uyepotorîkon iipî rawîrî˼ —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Inkamoro João pia erepamî'san wanî'pî fariseuyamî' narima'san pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Inî'rî João ekaranmapo'pî to'ya: —Cristo pe pra awanî, moropai Elias pe pra awanî, moropai manni' Paapa maimu ekareme'nen, Moisés nurî'tî nekaremekî'pî pe pra awanî. Mîrîrî ye'nen î' ton pe pemonkonyamî' yenpatakonaya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","To' maimu yuuku'pî Joãoya: —Inna, pemonkonyamî' yenpatakonauya tuna ke neken, tîîse tiaron man akore'ta'nîkon, anepu'tîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mîîkîrî pî' tauya manni' uye'ma'pî pî' eerepamî, tîîse uyentai awanî. Uyentai pu'kuru awanî ye'nen, i'sa'sa' yewa yeukauya pepîn, itarumai'pî pe pu'kuru wanî ye'nen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tamî'nawîrî sîrîrî esuwa'ka'pî Betânia pata po iren Jordão ratai po, pemonkonyamî' yenpatakona pî' João wanî'pî pata. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mîrîrî tîpo tiaron wei yai, tîîpia Jesus iipî era'ma'pî Joãoya. Jesus era'mai'ma ta'pîiya tamî'nawîronkon pî': —A'kî, manni' Paapa nîmenka'pî aasa'mantato'pe Carneiro era'matî. Mîserîya tamî'nawîronkon nîkupî'pî imakui'pî mo'ka —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Mîserî pî' tauya manni', uye'ma'pî pî' tiaron iipî tîîse uyentai awanî, uurî ton pra tîîse awanî'pî mîîto'pe, tauya ne'tîkini. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mîîkîrî pe mîserî epu'tîuya pra awanî'pî. Tîîse uuipî'pî pemonkonyamî' yenpatakonai Israelponkonya mîserî epu'to'pe —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Moropai João eseurîma'pî Jesus pî': —Ka' poi Morî Yekaton Wannî autî era'ma'pîuya ipona waku'kaimî warantî. Moropai ipo aako'mamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mîîkîrî pe awanî epu'tîuya pra awanî'pî. Tîîse tuna ke pemonkonyamî' yenpatakonai uyarimatîponya ta'pî upî': “Warayo' pona Morî Yekaton Wannî autî moropai ipo aako'mamî era'maya ya, mîîkîrî pe awanî epu'tîya. Mîîkîrîya pemonkonyamî' yenpatakona Morî Yekaton Wannî e'to'pe to' esa' pe”, ta'pîiya upî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Moropai era'ma'pîuya moropai tamî'nawîronkon pî' tauya sîrîrî: “Paapa munmu mîserî” —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Inî'rî tiaron wei yai awanî'pî João moropai inenupa'san asakî'nankon. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mîrîrî poro Jesus wîtî era'ma'pî Joãoya. Ta'pîiya tînenupa'san pî': —A'kî, mîîkîrî carneiro Paapa nîtîrî ton aasa'mantato'pe uurî'nîkon ton pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Moropai mîrîrî eta tîuya'nîkon ye'nen, João nenupa'san asakî'nankon wîtî'pî Jesus pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mîrîrî pe, Jesus era'tî'pî. Te'ma'pî pî' to' iipî era'ma'pîiya. Ta'pîiya to' pî': —Î' yuwaya'nîkon? —ta'pîiya. Yuuku'pî to'ya: —Rabi, (anna yenupanen taato' mîrîrî) —O'non pata tîîko'mansen amîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Aase'nîkon maasa era'mai —ta'pî Jesusya. Mîrîrîya ipîkîrî to' wîtî'pî. Aako'manto' era'ma'pî to'ya moropai iipia to' ko'mamî'pî pata ko'mamî tîpose. To' erepansa' wanî'pî 4 horas yairî tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tiwinan mîîkîrî João maimu etatîpon Jesus pîkîrî itî'pî wanî'pî Simão Pedro yakon itese' André. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesus piapai tuutî tîpo, tîrui yuwai attî'pî. Eporî'pîiya. Ta'pîiya tîrui pî': —Messias pe Paapa nîmenka'pî pîika'tîton eporî pî' anna man. (Messias taa Judeuyamî'ya moropai Cristo taa grego maimu ta) ");
INSERT INTO mbcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Moropai tîrui yarî'pîiya Jesus pia. Jesus esenumenka'pî Pedro pî' moropai ta'pîiya: —Amîrî Simão, João munmu. Tarîpai ayese'tîuya Pedro pe. (Tî' taato' mîrîrî Pedro, grego maimu ta.) ");
INSERT INTO mbcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mîrîrî tîpo tiaron wei yai Jesus ese'ma'tî'pî Galiléia pona. Tuutî pe Filipe eporî'pîiya. —Aase uwenairî —ta'pîiya Filipe pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida po tîîko'mansen mîîkîrî Filipe, André, Pedro cidaderî po. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe wîtî'pî Natanael yuwai. Eporî'pîiya. Ta'pîiya Natanael pî': —A'kî warayo' Moisés nurî'tî moropai penaro'kon Paapa maimu ekareme'nenan profetayamî' nurî'tî nekaremekî'pî tîkaaretarîkon po, manni' mîîkîrî eporî pî' anna man. Jesus mîîkîrî eporî pî' anna man, Jesus mîîkîrî Nazaré poinon, José munmu —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelya yuuku'pî: —Nazaré pata poi morî epa'ka eserîke pra man —ta'pîiya. Filipeya ta'pî: —Maasa aase era'mai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tîîpia Natanael iipî era'ma'pî Jesusya. Tîwoi'nîkon pî' ta'pîiya: —A'kî, Israel pon pu'kuru mîîkîrî warayo' seru'ye' pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mîrîrî eta'pî Natanaelya. —O'non ye'ka pe uyepu'tî pî' nan? —ta'pîiya Jesus pî'. Jesusya yuuku'pî: —Filipe, ayannouya pra tîîse, ayera'ma pî' wai figo ye' yo'koi awanî tanne. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mîrîrî pî' Natanaelya ta'pî: —Uyenupanen, amîrî Paapa munmu. Amîrî anna Israelyamî' yepotorî. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusya ta'pî ipî': —Innape ukupî pî' nai ayera'ma pî' wai figo ye' yo'koi tauya manni' wenai. Tîîse mîrîrî yentainon era'maya pe nai. ");
INSERT INTO mbcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ayenku'tîuya pepîn. Ka' esettapuruka era'maya pe nai, moropai inserîyamî' enuku moropai to' autî era'maya pe nai uurî, pemonkon pe ka' poi iipî'pî pia —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Asakî'ne wei tîpo, e'marimanto' wanî'pî Caná cidaderî po, Galiléia pata ya'. Jesus yan wanî'pî moro. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus moropai inenupa'san yeta'pî to'ya e'marimanto' pona to' wîtîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Moropai miarî to' wuku e'tî'ka'pî. Mîrîrî pî' Jesus yanya ta'pî ipî': —To' wuku e'tî'kan pî' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusya yuuku'pî: —Maama', amîrî mîrîrî uurî pepîn. Maasa uweiyu erepansa' pra man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ta'pî isanya wîttî esa' poitîrîtonon pî': —Î' rî taiya ya apî'nîkon, mîrîrî ku'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Awanî'pî moro tî' konekasa' kamotikon pe tiwin mia' pona tîîmo'tai kaisarî, tuna yense' pe teserukon yawîrî Judeuyamî' e'ronato'pe. Awanî'pî kure'ne tuna yapi'nenan 80, 100 litros kaisarî yapi'nenan. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesusya ta'pî wîttî esa' poitîrîtonon pî': —Tuna ke kamotikon yannî'tî —ta'pîiya. Yannîpî'pî to'ya intapîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta'pîiya to' pî': —Tarîpai imo'katî. Yaatî entamo'kanto' yepuru pia. Mîrîrî kupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mîrîrî enîrî'pî entamo'kanto' yepuruya tuna konekasa' uva yekku pe. Mîrîrî pe awanî epu'tîiya pra awanî'pî, tîîse wîttî esa' poitîrîtononya epu'tî'pî. Warayo' tîwe'marimasen yanno'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ta'pîiya ipî': —Uyonpa, uyeserukon wanî tiaron pe. Entamo'kan yai, morî panpî' wo' yenpo to'ya. Moropai tamî'nawîronkonya enîrî mararî pra. Mîrîrî tîpo itîrî to'ya morî ma'ran. Tîîse mîrîrî warantî pra ikupî pî' nai. E'mai' pe morî ma'ran yenpo pî' nai. Morî panpî' yenpa'ka pî' nai kînnî'pî —ta'pîiya tîwe'marimasen pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mîrîrî anî' nîkupî eserîkan pepîn kupî'pî Jesusya e'mai' pe pu'kuru to' nera'ma ton pe. Galiléia pata po tîwe'sen Caná cidaderî po ikupî'pîiya. Moropai tîmeruntîri yenpo'pîiya. Moropai inenupa'sanya ikupî'pî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mîrîrî tîpo to' autî'pî Caná poi Cafarnaum pona. To' wanî'pî Jesus, isan, itakontonon moropai inenupa'san. Cafarnaum po to' ko'mamî'pî mararî. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aminke pra Judeuyamî' festarî wanî yai, itese' páscoa Jesus wîtî'pî Jerusalém pona, mîrîrî pî' tîwanîpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Moro, epîremanto' yewî' ta pemonkonyamî' eporî'pîiya paakayamî', carneiroyamî', waku'kaimîyamî' ke, tîwe'repasanon moropai tîniru miakanmanenan. Moro teesenyaka'mato'kon pî' to' eporî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mîrîrî ye'nen to' po'pî'to' ton koneka'pîiya e'seusa ke. Mîrîrî ke to' yenpa'ka'pîiya epîremanto' yewî' tapai tekînkon carneiroyamî' paakayamî' pokonpe. Tîniru miakanmanenan tînirurî soroka'pîiya, moropai to' yaponse'kon, to' mesarikon ra'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Waku'kaimîyamî' ke tîwe'repasanon pî' ta'pîiya: —Ayekînkon yaatî tarîpai. Uyun yewî' kî'ku'tî awe'repato'kon yewî' pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mîrîrî kupîiya pî' inenupa'san esenumenka'pî. Pena awe'menukasa' Paapa maimu pî' to' enpenata'pî. Paapa maimuya taa: —Yairî ayewî' ko'mamî yu'se wai kure'ne. Mîrîrî yu'se e'to' enasa' uyesa' pe —taiya. Mîrîrî pî' Jesus nenupa'san enpenata'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mîrîrî kupîiya wenai Judeuyamî'ya ta'pî ipî': —Anî' maimu pe inkamoro yenpa'ka pî' nan? Yairî nai kupî annaya yu'se awanî ya, anna esenumenkato' ton ku'kî, anî'ya ikupî eserîkan pepîn. Î' konekaya innape aku'to'pe annaya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesusya yuuku'pî: —Sîrîrî Paapa yewî', yarankatî moropai seurîwî'ne wei kaisarî tîîse i'mî'sa'kauya inî'rî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judeuyamî'ya yuuku'pî: —46 kono' kaisarî sîrîrî wîttî koneka pî' to' wanî'pî. Mîrîrî ye'nen seurîwî'ne wei kaisarî ikonekaya pepîn tiwin kin. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tîîse to' esenku'tîsa' wanî'pî, wîttî pî' Jesus eseurîma kai'ma, tîîse tîpî' eeseurîma tanne. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Moropai aasa'mantato' yapai awe'mî'sa'ka tîpo, Jesus nenupa'san enpenata'pî mîrîrî ta'pîiya pî'. Moropai innape Paapa maimu e'menukasa' kupî'pî to'ya moropai Jesus maimu nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Moro Jerusalém po páscoa pî' Jesus wanî tanne, arinîkonya ikupî'pî innape anî'ya ikupî eserîkan pepîn kupîiya era'ma tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tîîse Jesus eturumaka pra awanî'pî to' yenya', maasa pra tamî'nawîronkon yewan epu'tî tîuya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anî'ya pemonkon yeseru pî' teurîma yu'se pra awanî'pî, pemonkon yewan ya' tîîko'mansen epu'tîiya mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Moro awanî'pî warayo' itese' Nicodemos. Awanî'pî fariseu pe, Judeuyamî' panamanen pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mîîkîrî wîtî'pî Jesus pia ewaron ya'. Jesus pî' ta'pîiya: —Uyenupanen, yenupaton amîrî Paapa piapainon. Amîrî epu'tî pî' anna man. Ankupî'pî anna nera'ma ton kupî anî'ya eserîke pra awanî, Paapa ton pra awanî ya iipia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesusya yuuku'pî: —Ayenku'tîuya pepîn. Itakon te'ka pe pemonkon esenpo pra awanî ya, itepotorî pe Paapa wanî pepîn. Mîîkîrî pata'se' era'maiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemosya ta'pî: —O'non ye'ka pe pemonkon esenpo inî'rî a'yeke'ton pe si'ma? Inî'rî tîsan ro'ta ya' eewomî itakon te'ka pe teesenpopa ka'rî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mîrîrî pî' Jesusya ta'pî: —Ayenku'tîuya pepîn. Pemonkon esenpo e'pai awanî esenponî'pî warantî moropai Morî Yekaton Wannî yai esenpon nîrî. Asakî'ne ite'ka eesenpo pra awanî ya, Paapa wanî pepîn itesa' pe, ipata ya' eewomî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ipun pe eesenpo'pî wanî ipun pe rî neken. Morî Yekaton Wannî yai eesenpo'pî wanî yekaton awanî pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Inî'rî eesenpo e'pai man tauya manni' pî' teesewankono'mai pra e'kî. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A'kî, a'situn a'ta'se'ma itu'se tîwe'to' yawîrî. A'situn pe awanî epu'tî maasa pra eeseta ye'nen, tîîse o'non pata pai aaipî epu'tî pepîn. Moropai o'non pata poro attî epu'tî pepîn. Mîrîrî warantî epu'tî Morî Yekaton Wannî yai esenpo'pî pemonkon wanî tîîko'manto' ke, eesenpo emapu'tîsai'ya ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ta'pî Nicodemosya: —O'non ye'ka pe awanî mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesusya yuuku'pî: —Israel ponkon yenupanen pe si'ma mîrîrî epu'tîya pra awanî mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ayenku'tîuya pepîn. Anna eseurîma anna nepu'tî pî' moropai anna nera'ma'pî ekaremekî annaya. Tîîse anna maimu kupîya pra awanî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sîrîrî non po ko'mannîto' yeseru pî' ayeurîmauya tanne, innape ikupîya pra awanî ya, ka' ponkon yeseru ekaremekîuya ya, o'non ye'ka pe mîrîrî kupîya e'painon innape? ");
INSERT INTO mbcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Anî' enu'sa' pra man sîrîrî tîpose Paapa pata'se' ya'. Tîîse uurî, pemonkon pe esenpo'pî uurî autî'pî ka' poi. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pena Moisés nurî'tîya bronze konekasa' îkîi pe pîmî'sa'ka'pî keren po. Mîrîrî warantî uurî, ka' poi iipî'pî pîmî'sa'ka to'ya e'pai awanî pakî'nan pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mîrîrî kupî to'ya e'pai awanî innape uku'nenan ko'manto'pe ipatîkarî Paapa pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Maasa pra tamî'nawîronkon pemonkonyamî' yu'se Paapa wanî'pî ipîra teeseka'nunkai. Mîrîrî ye'nen tiwinan tînmu tîrî'pîiya, innape iku'nenan wîtî namai apo' ya', ipatîkarî enen to' ko'manto'pe tîîpia. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tînmu yarimaiya pra Paapa wanî'pî sîrîrî non pona, apo' ya' tamî'nawîronkon yarimai, tîîse yarima'pîiya to' pîika'tîpa kai'ma, tînmu wenai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Innape iku'nen wîtî pepîn apo' ya'. Tîîse innape iku'nen pepîn wîtî ko'mannîpî sîrîrî apo' ya', maasa pra tewan yapisîiya pra awanî, tiwinan Paapa munmu pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","To' wîtî ko'mannîpî apo' ya' maasa pra pemonkonyamî' wanî a'ka yu'se pra, tamî'nawîronkon weiyu'masa' a'kaya tanne. Tîîse ewaron yu'se to' wanî, maasa pra imakui'pî kupî pî' to' ko'mamî. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Imakui'pî pî' tîîko'mansenonya tîweiyu'mato'kon kupî tewanmakon pe. A'ka ya' to' ewomî pepîn, “Imakui'pî kupî pî' naatîi”, taa anî'ya namai tîpî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tîîse Paapa maimu yairon yawîron ewomî a'ka ya', tînkoneka, teseru esera'mato'pe, innape itu'se Paapa e'to' yairî awanî esepu'to'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mîrîrî tîpo Jesus wîtî'pî Judéia pata pona tînenupa'san pokonpe. Moro aako'manpîtî'pî to' pokonpe. Pemonkonyamî' yenpatakona'pîiya moro. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João Batista nîrî wanî'pî pemonkonyamî' yenpatakona pî' Enom pata po, aminke pra Salim pata pî', maasa pra tuna wanî'pî moro mararî pra. Pemonkonyamî' wîtî'pî João pia moropai to' esenpatakona'pî, ");
INSERT INTO mbcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","mîîkîrî João yarakkamo to'ya pra tîîse maasa. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mîrîrî yai João Batista nenupa'san esiyu'pîtî'pî Judeu yarakkîrî Paapa wakîri pe ko'mannîto' yeseru pî', to' ronato' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","To' wîtî'pî João pia. —Anna yenupanen —ta'pî to'ya. —Amîrî pia awanî'pî manni' Jordão ratai po, ipî' eeseurîma ne'tîkini mîîkîrî man nîrî pemonkonyamî' yenpatakona pî'. Moropai tamî'nawîronkon wîtî iipia —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joãoya ta'pî: —Î' rî eporî eserîke pra man Paapaya itîrî pra awanî tanne. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pena Paapa nîmenka'pî pîika'tîton pepîn uurî, taapîtî'pîuya. Irawîrî Paapa narima'pî uurî, taapîtî'pîuya. Mîrîrî epu'tî pî' naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","E'marimanto' yai warayo' awe'mari'maton pia wîri' tîrî to'ya ino'pî pe, tiaron pia pra. Tîîse awe'mari'maton yonpa wanî moro. Tîno'pî pe yapisîiya eta itonpaya. Mîrîrî eta tîuya pî' awe'mari'maton yonpa atausinpa mararî pra. Mîrîrî warantî uurî atausinpan pî' wai kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mîîkîrî Cristo yapurî tamî'nawîronkonya e'pai awanî. Mîrîrî ye'nen urumaka to'ya e'pai awanî —ta'pî Joãoya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Mîîkîrî ka' poi iipî'pî man tamî'nawîron yentai. Tîîse uurî wanî sîrîrî non pon pe. Sîrîrî non po tîîko'mansenon yeseru pî' eseurîma. Tîîse ka' poi iipî'pî man tamî'nawîron yentai. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tînera'ma'pî, tîneta'pî, mîrîrî pî' eeseurîma. Tîîse anî'ya innape imaimu kupî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Anî'ya innape imaimu kupî ya, seru'ye' pe pra Paapa wanî taiya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Maasa pra Mîîkîrî Paapa narima'pîya Paapa maimu ekaremekî mîrîrî. Mararî Tekaton tîrî Paapaya pepîn Mîîkîrî pona tîîse mararî pra itîrîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tînmu pînînma Iyunya mararî pra. Mîrîrî ye'nen tamî'nawîron rumakasai'ya man itenya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mîîkîrî Paapa munmu ku'nen wanî ya innape, ipatîkarî enen tîîko'manto' ton eporîiya. Moropai innape Paapa munmu ku'nen pepînya enen ko'mannîto' era'ma pepîn. Tîîse Paapa ekore'mato' ko'mamî ipo. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","João Batista pemonkonoyamî' yentai tîpemonkonoyamî' ton eporî'pî Jesusya, moropai inkamoro yenpatakona'pî inenupa'sanya. Jesusya anî' yenpatakona pra awanî'pî. Mîrîrî yekare etasa' fariseuyamî'ya epu'tî'pî Uyepotorîkonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mîrîrî epu'tî tîuya pe, Judéia pata poi Galiléia pata pona attî'pî inî'rî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria pata poro attî e'pai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","To' erepamî'pî Samaria pon cidade pona itese' Sicar. Aminke pra awanî'pî José nurî'tî pata'se' iyun Jacó nîtîrî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Moro awanî'pî tuna Jacó nurî'tî naka'pî pena. Jesus eke'nepansa' wanî'pî tuutî ke. Eereuta'pî tuna yakasa' pia. Awanî'pî ineka'ta pairî wei tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wîri' iipî'pî tuna mo'kai, Samaria pon. Ta'pî Jesusya ipî': —Uwuku ton tuna ne'kî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Maasa pra inenupa'san ewonsa' wanî'pî cidade ta tekkarikon ton yennai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mîîkîrî wîri' Samaria ponya ta'pî ipî': —Amîrî Judeu. Uurî sa'ne wîri' Samaria pon. Î' wani' awanî ye'nen awuku ton esatîya upî'? —ta'pî wîri'ya ipî'. (Maasa pra Judeuyamî' yeseru wanî to' eseurîma pepîn Samaria ponkon yarakkîrî). ");
INSERT INTO mbcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesusya yuuku'pî: —Paapa nîtîrî'pî epu'tîya ya, moropai anî' pe tîwuku ton esatîtîpon epu'tîya ya, ipî' awuku ton esatî'pîya e'painon. Moropai itîrî'pîuya e'painon aako'manto' ton tîînen ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mîrîrî pî' wîri'ya ta'pî: —Uyepuru, tuna mo'kato' ton pra awanî aapia. Itu'nakan pe pu'kuru tuna yakasa' man. O'non pata pai aako'manto' ton tîînen, tuna taaya manni' eporîya? ");
INSERT INTO mbcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Penaron utamokon nurî'tî Jacó naka'pî sîrîrî tuna tîmîrî ton pe moropai tînmukuyamî' tekînon ton pe. Moropai sîrîrî tîpose aako'mamî uurî'nîkon ton pe. Amîrî Jacó nurî'tî yentainon? ");
INSERT INTO mbcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesusya yuuku'pî: —Anî'ya sîrîrî tuna enîrî ya, inî'rî tuna aninnîpai eena. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tîîse untîrî tuna enîrî anî'rîya ya, mîîkîrî ko'mamî ipatîkarî tuna aninnîpai teenai pra. Untîrî ko'mamî itekaton ya' moropai ipatîkarî aako'manto' ton tîrîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wîri'ya ta'pî ipî': —Uyepuru, mîrîrî ye'ka tuna ke uwo'pakî, inî'rî tuna aninnîpai ena namai, inî'rî tuna era'mai uuipî namai tarîwaya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesusya ta'pî ipî': —Anyo yannota moriya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wîri'ya yuuku'pî: —Inyo pîn uurî. Jesusya ta'pî: —Yairî eseurîman pî' nai, inyo pîn uurî taa pî' nai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mia'taikin kaisarî anyotonon e'sa' man, moropai sîrîrî anyo pepîn warayo' yarakkîrî awanî. Yairî eseurîman pî' nai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wîri'ya ta'pî ipî': —Uyepuru, Paapa maimu ekareme'nen pe awanî epu'tî pî' wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anna yonpayamî' penaronkonya Paapa yapurî'pî tarî sîrîrî wî' po. Tîîse amîrî'nîkon Judeuyamî'ya taa, Jerusalém po neken pemonkonyamî'ya Paapa yapurî e'pai awanî, taaya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mîrîrî yuuku'pî Jesusya: —Wîri', innape uku'kî. Awanî kupî sîrîrî tarî Paapa yapurîya'nîkon pepîn. Moropai Jerusalém po nîrî uyunkon yapurîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amîrî'nîkon man anî' yapurîya'nîkon epu'tîya'nîkon pra naatîi. Anî' yapurî annaya epu'tî pî' anna man, maasa pra tamî'nawîronkon pîika'tîton iipî ekareme'sa' Paapaya Judeuyamî' winîpai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tîîse awanî kupî sîrîrî moropai sîrîrî pu'kuru awanî see warantî, Uyunkon yapurînenan seru'ye'kon pepînya yapurî tekatonkon ke moropai seru'ye' pe pra. Mîrîrî ye'kakon tapurînenan ton yuwa Paapaya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Paapa man Yekaton Wannî pe. Yapurînenanya yapurî e'pai man tekatonkon ke, seru'ye' pe tîwe'se pra —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wîri'ya ta'pî ipî': —Paapa nîmenka'pî itese' Cristo, mîîkîrî iipî pe man. Mîrîrî epu'tî pî' wai. Teerepamî yai tamî'nawîron ekaremekîiya upî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesusya ta'pî ipî': —Uurî mîîkîrî, amîrî yarakkîrî eeseurîma manni'. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mîrîrî tanne, Jesus nenupa'san erepamî'pî. Kure'ne to' esenumenka'pî wîri' yarakkîrî eeseurîma era'ma tîuya'nîkon pî'. Tîîse Jesus ekaranmapo to'ya pra awanî'pî. Î' esatî pî' nan ipî'? Î' wani' awanî ye'nen mîîkîrî wîri' yarakkîrî eeseurîma manni'? taa to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mîrîrî ya tuna yense' rumaka'pî wîri'ya. Cidade poro attî'pî. Pemonkonyamî' pî' ta'pîiya: ");
INSERT INTO mbcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Maasa aase'kon upîkîrî, tamî'nawîron unkupî'pî ekareme'nen era'mai. Yai pra Cristo pe awanî tai'se —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mîrîrî ye'nen cidade poi to' epa'ka'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mîrîrî tanne Jesus nenupa'san eseurîma'pî yarakkîrî: —Anna yenupanen, esekkari'tîkî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tîîse Jesusya ta'pî to' pî': —Uyekkari man anepu'tîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mîrîrî pî' inenupa'sanya ta'pî tîpî'nîkon: —Itekkari ton tîîsa' tiaronya ka'rî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Moropai Jesusya ta'pî to' pî': —Itu'se uyarimatîpon e'to' ankonekapai uuko'mamî. Inekaremekî'pî esenyaka'mato' ton pe anku'pai wanî. Mîrîrî man uyekkari pe, uyo' pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Amîrî'nîkonya taa: “Maasa asakîrîrî kapoi tîpo aasîrî uyekkarikon emîrî kupî sîrîrî”, taaya'nîkon. Tîîse tiaron perî uurî esenumenkato' wanî. Pata era'matî. Aasîrî pemonkonyamî' man itekare anetapainokon. Manni' uyekkarikon emîsa' mo'ka pî' teesenyaka'masanon warainokon yu'se awanî, inkamoro pemonkonyamî' pî' itekare ekareme'to'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mîrîrî pî' teesenyaka'masenya tepe' ton eporî. Teperu ton eporîiya tîwe'tî'kasen pepîn. Ipatîkarî enen to' ko'mamî. Mîrîrî ye'nen sa'nîrî to' atausinpa. Ipîmîtîpon atausinpa ipikkatîpon yarakkîrî, tiaronkon maasa tîuya'nîkon ye'nen Paapa pemonkono pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","See warantî taawonan amîrî'nîkon, “Warayo'ya tekkari ton pîmî, tîîse tiaron ipîmîtîpon pepînya ipikka”. Innape awanî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Amîrî'nîkon yarima'pîuya pemonkonyamî' pia. Mîrîrî to' pî' amîrî'nîkon esenyaka'masa' pra awanî'pî. Tiaronkon esenyaka'masa' wanî'pî to' pî'. Tîîse amîrî'nîkon maimu pe uyapurî'pî to'ya. Tiaronkon esenyaka'ma pia'tî'pî aretî'ka'pîya'nîkon mîrîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Moropai arinîkon Samaritanoyamî' mîrîrî cidade po tîîko'mansenonya Jesus kupî'pî innape, manni' wîri'ya ekareme'sa' etasa' tîuya'nîkon ye'nen, —Tamî'nawîron unkoneka'pî ekaremekî pî' man taasai'ya ye'nen —ta'pîiya ne'tîkini pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mîrîrî ye'nen iipia teerepamîkon pe yeka'nunka'pî to'ya tîîpia'nîkon aako'manto'pe kai'ma. Moro aako'mamî'pî asakî'ne wei kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Moropai tiaronkonya nîrî Jesus kupî'pî innape imaimu eta tîuya'nîkon wenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Manni' wîri' pî' ta'pî to'ya: —E'mai' pe innape ikupî'pî annaya amaimu wenai. Tîîse tarîpai imaimu eta pî' anna man, anna pe pu'kuru. Innape tamî'nawîronkon pîika'tîton pe awanî epu'tî pî' anna man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Asakî'ne wei tîîko'mamî tîpo, Jesus ese'ma'tî'pî miarî pai Galiléia pata pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tîîko'manto' pata pona tuutî ye'ka pe, ta'pîiya: —Paapa maimu ekareme'nen yapurî tamî'nawîronkonya. Tîîse ipata ya' tîîko'mansenonya yapurî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Moropai Galiléia pona eerepamî'pî. Eerepamî pe Galiléia po tîîko'mansenonya yapisî'pî morî pe, tamî'nawîron inkoneka'pî Jerusalém po era'masa' tîuya'nîkon ye'nen. Inkamoro nîrî wanî'pî itî'san pe Jerusalém pona Judeuyamî' entamo'kato' yapi'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mîrîrî, Caná cidaderî pona eerepamî'pî Galiléia pata ya', moro uva yekku pe tuna miakanma'pî tîuya pata ya'. Moropai Cafarnaum po awanî'pî warayo' ipîkku. Mîîkîrî munmu wanî'pî pri'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judéia poi Galiléia pona Jesus erepansa' yekare eta tîuya pe, iipia attî'pî. Yeka'nunka'pîiya. —Aase uyewî' ta unmu yepi'tîi. Aasa'manta pe man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesusya ta'pî ipî': —Anî'ya ikupî eserîkan pepîn e'kupî era'maya'nîkon pra awanî ya, innape ukupîya'nîkon pepîn, eesenumenkato'kon ton meruntî yenpouya pra awanî ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tîîse mîîkîrî ipîkkuya ta'pî ipî': —Uyepuru, aase see erepannîto'pe unmu sa'manta rawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesusya ta'pî ipî': —Ayewî' ta enna'pokî. Anmu man pri'ya pu'kuru. Mîrîrî taa Jesusya pe, ikupî'pî warayo'ya innape. Tewî' ta awenna'po'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Moropai mîîkîrî wîtî tanne, tîpoitîrîtonon eporî'pîiya, tîîpia tui'sanon. Ta'pî to'ya ipî': —Pri'ya pu'kuru anmu man. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To' ekaranmapo'pîiya: —Î' yai eesepi'tî pia'tî'pî mîrîrî? —ta'pîiya. —Ko'manpara wei era'tî tanne (1 hora) eekomi'makapî'pî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","—Pri'ya pu'kuru anmu man —ta'pî Jesusya yai pu'kuru eekomi'makapî'pî mîrîrî. Mîrîrî epu'tî'pî warayo'ya moropai innape Jesus kupî'pîiya. Itewî' ta tîîko'mansenonya ikupî'pî nîrî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mîrîrî itekare itakon te'ka pe meruntî anî'ya ikupî eserîkan pepîn koneka'pî Jesusya mîrîrî Galiléia pona teerepamî tîpo Judéia poi. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tîko'man pe tîîko'mamî tîpo Jesus wîtî'pî Jerusalém pona, Judeuyamî' festarî weiyu eseporî yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalém cidaderî woima'tîto' mana'ta kure'nan yai awanî carneiroyamî' ewonto'. Aminke pra mîrîrî pî' tuna yense' wanî'pî, itese' Betesda. Tuna yense' woi awanî pemonkonyamî' ko'manto' tappîikon, mia'taikin kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mîrîrî tappîikon ta pemonkonyamî' wanî'pî arinîkon pri'yawonkon pepîn, enkaru'nankon, tîkîipankon, eke'nepamî'san, tamî'nawîrî. Tuna eserentîkî'ma nîmîkî pî' to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Maasa pra tiaron pensa inserî autîpîtî'pî mîrîrî tuna ka, moropai tuna eserentîkî'ma pe e'mai'non pri'yawon pepîn, tuna ka teenasen esepi'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Moro awanî'pî pri'yawonkon pepîn kore'ta warayo', pri'yawon pepîn nîrî. 38 kono' kaisarî aako'mansa' wanî'pî pri'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Moro mîîkîrî esenunsa' era'ma'pî Jesusya. Tîko'man pe aako'mansa' epu'tî'pî Jesusya. Mîrîrî ye'nen ta'pîiya pri'yawon pepîn pî': —Esepi'tîpai nan? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pri'yawon pepînya yuuku'pî: —Uyepotorî, tuna eserentîkî'ma yai, upîika'tînen ton pra awanî, tuna pia uyarî ton, ya' enato'pe. Moropai tînîn pî' uuwarîrî uutî tanne, tiaron ewomî urawîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesusya ta'pî ipî': —E'mî'sa'kakî. Awe'nato' yaponse' konekakî moropai asakî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mîrîrî pe rî mîîkîrî esepi'tî'pî. Tîwe'nato' yaponse' koneka'pîiya moropai aasarî'pî. Erî'ka'nîto' weiyu yai awanî'pî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mîrîrî ye'nen Judeuyamî'ya esepi'tî'pî warayo' panama'pî. —Erî'ka'nîto' weiyu pe man —ta'pî to'ya ipî'. —Yairî pra awe'nato' yaponse' yarî pî' nai sábado yai, uyeserukon yawîrî pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yuuku'pîiya: —Kaane, awe'nato' yaponse' yanunkî, asakî, taa pî' uyepi'tîtîpon man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Anî' see mîîkîrî, awe'nato' yaponse' yanunkî, asakî taatîpon? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tîîse anî'ya tepi'tîsa' epu'tîiya pra mîîkîrî wanî'pî. Yepi'tî tîpo Jesus esonomî'pî moro arinîkon kore'ta mîîto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mîrîrî tîpo Jesusya yeporî'pî epîremanto' yewî' ta. Ta'pî Jesusya ipî': —A'kî, eesepi'tîsa' nai. Inî'rî imakui'pî kî'konekai ayeparanrî'pî yentainonya ayeporî namai. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Moropai mîîkîrî wîtî'pî Judeuyamî' pia. —Jesus mîîkîrî uyepi'tîtîpon —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mîrîrî kupî'pî Jesusya erî'ka'nîto' weiyu yai. Mîrîrî ye'nen Judeuyamî' wanî'pî antaruma'tîpai. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tîîse to' pî' ta'pîiya: —Sîrîrîpe Uyun esenyaka'ma ko'mannîpî. Uurî nîrî esenyaka'mato' pî' uuko'mamî mîrîrî warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Erî'ka'nîto' weiyu yai Judeuyamî' ko'manto' yawîrî Jesus ko'mamî pra awanî'pî. Moropai Paapa pî' eeseurîma'pî tun pe awanî pî', Paapa kaisarî tîwanî pî'. Mîrîrî wenai iwî yu'se Judeuyamî' eseka'nunka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mîrîrî ye'nen Jesusya to' yeurîma'pî: —Ayenku'tîuya'nîkon pepîn. Uuwarîrî î' rî kupîuya eserîke pra awanî. Uyunya ikupî era'mauya ya, uurîya nîrî ikupî. Î' rî ku'nen pe Paapa wanî ya, uurî nîrî inmu iku'nen pe wanî, mîrîrî warantî rî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Paapa wanî tînmu yapurînen pe. Tamî'nawîrî tînkoneka ekaremekîiya tînmu pî'. Moropai anera'ma'pîkon yentai teesenyaka'mato' ekaremekîiya kupî sîrîrî tînmu pî' mîrîrî pî' eesenumenkakonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Paapa wanî isa'manta'san pîmî'sa'kanen pe. Inî'rî enen to' e'to' ton tîrîiya. Mîrîrî warantî nîrî itu'se tîwe'to' yawîrî enen ko'mannîto' ton tîrî inmuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Paapaya taa pra awanî anî'rî pî' “Imakui'pî amîrî. Atîkî apo' ya'”. Mîrîrî ye'ka teesenyaka'mato' rumakasai'ya tînmu pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mîrîrî kupî'pîiya tamî'nawîronkonya tapurî kaisarî tînmu yapurîto'pe to'ya. Anî'ya inmu yapurî pra awanî ya, Paapa nîrî tînmu yarimatîpon yapurîiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ayenku'tîuya'nîkon pepîn. Umaimu yawîrî awanîkon ya, moropai innape uyarimatîpon kupîya'nîkon ya, ipatîkarî aako'mamîkon pe naatîi uupia. “Imakui'san amîrî'nîkon, atîtî apo' ya'”, tauya eserîke pra awanî apî'nîkon. Sa'mantanto' esuwa'kasa', enen aako'mamîkon pe naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ayenku'tîuya'nîkon pepîn. Awanî kupî sîrîrî moropai sîrîrî pu'kuru awanî see warantî. Tiaronkon Paapa winîpai tîîko'manto'kon yapisîtîponkon pepînya Paapa munmu maimu eta pe man. Moropai inkamoroya yapisî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maasa pra tîîwarîrî enen Paapa ko'mamî warantî, enen tînmu ko'mamî nîrî. Mîrîrî ye'nen itîrîuya eserîke awanî inkamoro pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Moropai tînmu pia meruntî tîrî'pî Paapaya pemonkonyamî' repato'peuya morî ke moropai e'taruma'tînto' ke. Maasa pra uurî wanî ka' poi iipî'pî pemonkon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mîrîrî tauya manni' pî' tîmu'tunpai pra e'tî. Awanî kupî sîrîrî, tamî'nawîronkon isa'manta'sanya umaimu eta kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mîrîrî yai to' e'mî'sa'ka kupî sîrîrî. Morî kupîtîponkon e'mî'sa'ka kupî sîrîrî ipatîkarî enen tîwanîkonpa uupia. Moropai imakui'pî kupîtîponkon yenumî Paapaya kupî sîrîrî ipatîkarî to' e'taruma'tîto'pe —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Uuwarîrî î' rî kupîuya pepîn. Paapaya uyaipontî yawîrî pemonkonyamî' repauya. Yairî to' repauya mîrîrî maasa itu'se e'to' kupîuya pepîn mîrîrî. Tîîse itu'se uyarimatîpon e'to' kupîuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Uuwarîrî, tiwinsarî si'ma, uyeseru pî' eseurîmasa' ya, seru'ye' pe wanî e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tîîse moro man tiaron uyeseru pî' teeseurîmasen. Yairî upî' eeseurîmato' man, seru' pe pra. Epu'tî pî' wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","João Batista ekaranmapo me'po'pîya'nîkon upî' moropai yairon ekaremekî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Uurî, pemonkon maimu yapurînen pu'kuru pepîn. Tîîse mîrîrî tauya apî'nîkon pîika'tîto'peuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João e'pîtî'pî u'kuma'tukon warantî ewaron ya'. U'kuma'tukonya uweiyu'makon pî' atausinpan warantî aatausinpa'pîkon João pî' tîko'man pe pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tîîse João maimu yentainon uyeseru ekareme'nen moro wanî. Esenyaka'mato' Paapa nîtîrî'pî, aretî'kato'peuya anera'makon ton kupîuya wenai Paapa narima'pî pe uyepu'tî tamî'nawîronkonya e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Moropai uyarimatîpon Paapa eseurîmasa' nîrî upî', tînmu pe wanî pî'. O'non pata imaimu etatîponkon pepîn amîrî'nîkon. Mîîkîrî era'matîponkon pepîn amîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Moropai imaimu ko'mamî pra awanî ayewankon ya' maasa pra innape inarima'pî kupîya'nîkon pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Paapa maimu pî' eesenupakon ipatîkarî enen aako'manto'kon ton eporî yu'se. Moropai uurî pî' eseurîmakoi Paapa maimu. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tîîse upî' enen aako'manto'kon ton esatîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Morî pe upî' pemonkonyamî' eseurîma yu'se wai, tauya pepîn. Mîrîrî ye'ka yuwauya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tîîse ayewankon ya' Paapa pînînmaya'nîkon pra awanîkon. Mîrîrî epu'tî pî' wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aapia'nîkon uui'sa' sîrîrî Paapa maimu pe, inarima'pî pe, tîîse uyapisîya'nîkon pra awanî'pîkon. Tîîwarîrî tiaron ii'sa' ya, yapisîya'nîkon eserîke awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Apî'nîkon morî pe ayonpakon eseurîma yu'se eeseka'nunkakon tanne, innape ukupîya'nîkon eserîke pra awanî. Morî pe tiwinan Paapa eseurîmato' apî'nîkon yuwaya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Paapa pî' imakui'pî pe pu'kuru to' man tauya pî' kîsenumenkatî. Tauya pepîn. Moro man apî'nîkon eseurîmaton, imakui'pî pe awanîkon ekareme'nen pe. Moisés nurî'tî mîîkîrî, anna napurî ton taaya'nîkon ne'tîkini ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tîîse innape Moisés nurî'tîya yenupanto' kupîya'nîkon awanî ya, uurî nîrî kupîya'nîkon e'pai awanî innape. Maasa pra upî' Moisés nurî'tî eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tîîse innape Moisés nurî'tî yenupato' kupîya'nîkon pra awanî ya, innape umaimu kupîya'nîkon pepîn nîrî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mîrîrî tîpo Jesus wîtî'pî Galiléia ku'pî ratai pona. Mîrîrî iku'pî ese' wanî'pî tiaron pe nîrî, Tiberíades itese'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Moropai arinîkon pemonkonyamî' wîtî'pî ite'ma'pî pî'. Ipîkîrî to' wîtî'pî pri'yawonkon pepîn yepi'tîpîtîiya era'ma tîuya'nîkon ye'nen anî'ya ikupî eserîkan pepîn era'ma tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Moropai Jesus enuku'pî wî' pona tînenupa'san pokonpe. Wî' po to' ereuta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Moropai awanî'pî Judeuyamî' entamo'kato' weiyu aminke pra, itese' páscoa. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Arinîkon pemonkonyamî' erepamî tîîpia era'ma'pî Jesusya. Moropai Filipe pî' ta'pîiya: —O'non pata to' yuu ton yenna e'painon to' entamo'kato'pe? ");
INSERT INTO mbcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tîîse î' taa Filipeya anepu'pai awanî'pî. Aasîrî î' kupî tîuya epu'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipeya ta'pî: —To' yuu yepe' ton pe 200 wei kaisarî esenyaka'mannî'pî yepe'pî tî'kasa' ya, mîîwîni tîîse to' ma're awanî. Tamî'nawîronkonya iipia'pî mîrikkî yapisî eserîke pra awanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Moropai awanî'pî Jesus nenupa'pî itese' André, Simão Pedro yakon. Mîîkîrîya ta'pî Jesus pî': ");
INSERT INTO mbcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Moro man more pia cevada puusa', pão, mia'taikin kaisarî moropai moro'yamî' asakî'ne. Tîîse arinîkon yepi'tîiya eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mîrîrî eta tîpo, Jesusya ta'pî tînenupa'san pî': —Tamî'nawîronkon ereutato'pe non pona ka'tî to' pî'. Parî' pe awanî'pî moro. Mîrîrî ye'nen Jesus maimu pe to' ereuta'pî non pona. Warayo'kon wanî'pî 5.000 yairî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Moropai pão manni' yapisî'pî Jesusya moropai ta'pîiya Paapa pî': —Morî pe man Paapa. Anna yuu ton tîrî pî' nai —ta'pîiya. Moropai to' kaisarî itîîpîtî me'po'pîiya. Mîrîrî warantî nîrî moro'yamî' tîrî'pîiya, itu'se to' e'to' pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Awore tamî'nawîronkon ena'pî. Mîrîrî tîpo tînenupa'san pî' ta'pî Jesusya: —Iipia'san e'nîmî'sa' yannu'tî aama'ta namai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Imaimu yawîrî ikupî'pî to'ya. Mia'taikin kaisarî cevada puusa' yonparî'pî yannuku'pî to'ya. 12 waikara'pî kaisarî itîrî'pîiya, entamo'ka'san yuu yonparî'pîya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mîrîrî kupî Jesusya pî' pemonkonyamî' esenumenka'pî. Ta'pî to'ya: —Mîserî Paapa maimu ekareme'nen pena inekaremekî'pî, sîrîrî non pona tui'sen mîîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mîrîrî ye'nen anapi'pai to' wanî'pî tesa'kon pe awe'to'pe rei pe kai'ma. Mîrîrî to' esenumenkato' epu'tî'pî Jesusya. Mîrîrî yu'se pra tîwanî ye'nen attî'pî inî'rî tiwinsarî wî' pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pata ko'mamî pe Jesus nenupa'san autî'pî iku'pî ena pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kanau ya' to' asara'tî'pî. Moropai to' ese'ma'tî'pî Cafarnaum pona, iku'pî ratai pona. Moropai pata ewaronpamî'pî maasa to' pia Jesus erepansa' pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mîrîrî tanne, a'situn pe eena'pî mararî pra. Sipa sipa pe tuna ena'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aminke ma're to' wîtîsa' tanne, yai pra 5 ou 6 km., tuna poro Jesus asarî era'ma'pî to'ya tîponaya'nîkon. Mararî pra to' esi'nîpî'pî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tîîse Jesusya ta'pî to' pî': —Jesus uurî. Teesi'nî'se pra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eerepamî'pî to' pia. Taatausinpai yapisî'pî to'ya kanau ya'. Mîrîrî pe rî to' erepamî'pî iku'pî ratai pona tuutîto'kon ya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tiaron wei yai arinîkon pemonkonyamî' Jesus ye'ma'pî pî' itî'san e'nîmî'pî iku'pî ena po. Inkamoroya Jesus yuwa'pî. Tiwinan kanau pata'pî neken eporî'pî to'ya kasapan po, Jesus nenupa'san yense' pata'pî. Tînenupa'san pokonpe Jesus asara'tî pra awanî era'ma'pî to'ya. Mîrîrî epu'tî'pî to'ya. Jesus ton pra to' ese'ma'tî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tîîse tiaronkon kanaukon erepansa' wanî'pî aminke pra Jesusya pemonkonyamî' yekkari'tî'pî Paapa yarakkîrî teeseurîma pata', Tiberíades cidaderî poinokon kanaukon. Mîrîrî era'ma'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Anî' ton pra awanî era'ma'pî to'ya, Jesus ton pra moropai inenupa'san ton pra. Mîrîrî ye'nen to' asara'tî'pî kanau ya' nîrî moropai to' wîtî'pî Cafarnaum cidaderî pona Jesus yuwai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iku'pî ratai po Jesus eporî tîuya'nîkon pe, ekaranmapo'pî to'ya: —Anna yenupanen, î' pensa eerepamî'pî tarîni'? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusya ta'pî to' pî': —Ayenku'tîya'nîkon pepîn. Uurî yuwa pî' naatîi awore awanîkon pîkîrî ayekkari'tîsau'ya'nîkon wenai. Mîrîrî anî'ya ikupî eserîkan pepîn ku'sau'ya era'maya'nîkon tanne, tîîse î' taato'pe awanî epu'tîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayekkarikon ton pî' kîseka'nunkatî mîrîrî tîwe'tî'kasen pî'. Tîîse esenyaka'matî untîrî ayekkarikon pî', ipatîkarî enen aako'manto'kon tîînen pî'. Uurî ka' poi iipî'pî pemonkon pe mîrîrî ye'ka tîînen. Maasa pra tîwakîri pe Uyunkon Paapaya uyaipontî'pî itîîto'peuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—Î' kupî annaya yu'se Paapa wanî? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusya ta'pî: —Innape Paapa narima'pî ku'tî. Mîrîrî kupîya'nîkon yu'se Paapa wanî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mîrîrî pî' ta'pî to'ya: —Innape akupî annaya yu'se awanî ya, anna nera'ma ton konekakî. Mîrîrî era'ma annaya moropai innape akupî annaya. Î' konekaya? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","—Anna tamokon Moisés nurî'tî yarakkîronkon entamo'ka'pî Paapa nîtîrî'pî pî' itese' maná, keren po. Paapa kaaretarîya taa: “To' yuu ton tîrî'pîiya ka' poinon, to' entamo'kato'pe”, taiya —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Moropai Jesusya ta'pî to' pî': —Moisés nurî'tî nîtîrî'pî pepîn mîrîrî penaronkon yuu ton, ˻tîîse mîrîrî Paapa nîtîrî'pî˼. Tîîse uyun nîtîrî sîrîrîpe aapia'nîkon yairon, ayukon ton ka' poinon. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mîrîrî ayukon ton Paapa nîtîrî iipî ka' poi moropai enen tîîko'manto'kon ton tîrîiya sîrîrî non po tîîko'mansenon pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Moropai ta'pî to'ya Jesus pî': —Anna yenupanen, anna yuu ton mîrîrî ye'ka tîîkî ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta'pî Jesusya to' pî': —Uurî mîîkîrî, manni' ayukon ton, ipatîkarî aako'manto'kon tîînen. Paapa anepu'painon iipî ya uupia, epu'tîiya. Moropai innape ukupîtîpon ena morî pe, itu'se tîwe'to' pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tauya ne'tîkini uyera'ma pî' naatîi. Mîîwîni tîîse innape ukupîya'nîkon pra naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tîîse Paapa nîtîrî'san pemonkonyamî' iipî uupia tamî'nawîrî. Moropai uupia tui'sen yaipontîuya pepîn uupiapai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Maasa pra itu'se e'to' ku'se uui'sa' pra wai ka' poi. Tîîse itu'se uyarimatîpon e'to' ku'se iipî'pî uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Paapaya uyarima'pî. Tîntîrî'san ko'mannîpîuya yu'se Paapa wanî, tamî'nawîrî, tiwinan ataka'ma namai. Moropai tamî'nawîronkon insanan pîmî'sa'kauya yu'se awanî tîîsa'mantakon tîpo tiwinano'pî wei yai. Mîrîrî yu'se Paapa wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Paapa munmu pe uyera'matîponkon, innape ukupîtîponkon ko'mamî yu'se uyun wanî ipatîkarî. To' pîmî'sa'kauya yu'se Paapa wanî tiwinano'pî wei yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tîîse ipî' Judeuyamî' atako'menka'pî, —Uurî ayukon pe ka' poi iipî'pî —taiya ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Taapîtî'pî to'ya: —José munmu mîserî warayo', Jesus itese' —ta'pî to'ya. —Iyun moropai isan anna nepu'tî. Innape nai? O'non ye'ka pe “Ka' poi iipî'pî uurî”, taiya mîrîrî? —kai'ma to' eseurîmapîtî'pî tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesusya ta'pî to' pî': —Ama' pe kîseurîmatî upî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tîîwarîrî anî' iipî pepîn uupia. Tîîse Paapa uyarimatîponya enepî ya, eerepamî. Moropai i'mî'sa'kauya tiwinano'pî wei yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Penaro'kon Paapa maimu ekareme'nenan maimu rî'pîya taa see warantî: Moropai Paapaya inkamoro yenupa, tamî'nawîronkon. Mîrîrî warantî awe'menukasa' wanî'pî. Mîrîrî ye'nen anî'rîya Paapa maimu etasa' ya, moropai Paapa pî' eesenupasa' ya, uupia aaipî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Anî'ya Paapa era'masa' pra man tîîse uurî, iipiapainon. Uurî Paapa era'matîpon. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ayenku'tîuya'nîkon pepîn. Anî'ya innape uku'sa' ya, ipatîkarî enen tîîko'manto' ton eposai'ya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inna, uurî ayukon, enen ko'mannîto' tîînen. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Atamokon nurî'san Moisés piawonkon entamo'ka'pî ka' poi Paapa nîtîrî'pî pî', maná pî', tîîse to' sa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tîîse sîrîrî man ayukon pe ka' poinon. Mîrîrî pî' entamo'ka'san sa'manta pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Uurî mîîkîrî ayukon, enenan, ka' poi iipî'pî. Uurî pî' anî' entamo'ka ya, ipatîkarî aako'mamî enen. Ayukon pe untîrî wanî upun pe. Upun tîrîuya kupî sîrîrî pemonkonyamî'ya tîîko'manto'kon epoto'pe enen ipatîkarî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mîrîrî pî' Judeuyamî' esiyu'pîtî'pî tîmurukun pe si'ma. —O'non ye'ka pe mîserî warayo'ya tîpun tîrî anna yo' pe? ");
INSERT INTO mbcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Moropai Jesusya ta'pî to' pî': —Uurî ka' poi iipî'pî pemonkon pe, upun pî' awentamo'kakon pra awanî ya, umînî enîrîya'nîkon pra awanî ya, enen awanîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Upun yanîtîpon, umînî enîrîtîpon, mîîkîrîya ipatîkarî enen tîîko'manto' ton eporî moropai i'mî'sa'kauya tiwinano'pî wei yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Upun wanî ayo'kon yairon pe moropai umînî wanî awukukon yairon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Upun pî' entamo'ka'pî, umînî enîrîtîpon ko'mamî uupia moropai uuko'mamî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Paapa, enen tîîko'mansenya uyaipontî'pî moropai enen uko'mannîpîiya. Mîrîrî warantî nîrî upî' entamo'ka'pî ko'mannîpîuya enen. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mîrîrî ye'nen tauya ka' poi iipî'pî uurî wanî awentamo'kakonpa. Atamokon rî'san entamo'ka'pî maná pî' tîîse to' sa'manta'pî. Mîrîrî warantî pra sîrîrî wanî. Sîrîrî tauya uurî pî' entamo'ka'pî ko'mamî ipatîkarî enen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mîrîrî warantî Jesusya to' yenupa'pî Judeuyamî' epere'to' yewî' ta Cafarnaum cidaderî po. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tîîse arinîkon Jesus maimu pî' teesenupasanon esewankono'ma'pî imaimu pî'. —Sa'me pu'kuru imaimu man —ta'pî to'ya. —Anî'ya innape ikupî eserîke pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tîmaimu pî' tînenupa'san atako'menka epu'tî'pî Jesusya. —Mîrîrî pî' eesewankono'makon mîrîrî? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","—Mîrîrî pî' aataka'makon ya, î' kai'ma eesenumenkakon uurî ka' poi iipî'pî pemonkon pe enuku ka' pona era'maya'nîkon ya, manni' uuko'mamî'pî pata pona? ");
INSERT INTO mbcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mîrîrî enen ko'mannîto' pî' eseurîma manni' wanî Morî Yekaton Wannî winîpaino pe. Tîîwarîrî pemonkonya yeporî pepîn. Apî'nîkon unekaremekî'pî wanî ayekatonkon ton pe moropai enen aako'manto'kon tîînen pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tîîse tiaronkon amîrî'nîkonya innape ukupî pra man —ta'pî Jesusya to' pî'. Aasîrî Jesusya innape tîku'nenan pepîn epu'tî'pî moropai anî'ya tekaremekî teyatonon pî' epu'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ta'pîiya to' pî': —Mîrîrî warantî awanî ye'nen anî' iipî pepîn uupia Paapaya enepî pra awanî ya, tauya ne'tîkini. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mîrîrî yai arinîkon Jesus nenupa'sanya irumaka'pî. Inî'rî ipîkîrî to' wîtî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Moropai Jesusya ta'pî tînenupa'san pî' asakî'ne pu' pona tîîmo'tai'nîkon, (12) kaisaronkon pî': —Amîrî'nîkon kanan? Urumakaya'nîkon nîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tîîse Simão Pedroya ta'pî ipî': —Uyepotorî, anî' pia anna wîtî? Amîrî neken ipatîkarî enen anna ko'manto' yekare esa'. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Innape akupî pî' anna man. Cristo pe awanî epu'tî pî' anna man. Enen tîîko'mansen Paapa munmu pe awanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesusya ta'pî: —Unmo'ka'san amîrî'nîkon asakî'ne pu' pona tîîmo'tai'nîkon, (12) kaisaronkon, moropai akore'ta'nîkon man tiwinan Makui poitîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Mîrîrî ta'pîiya Simão munmu Judas Iscariotes pî'. Maasa pra mîîkîrî Judas wanî tîîse asakî'ne pu' pona tîîmo'tai'nîkon, (12) kaisaronkon yonpa pe, mîîkîrîya tekaremekî maasa, mîrîrî epu'tî'pî Jesusya.) ");
INSERT INTO mbcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mîrîrî tîpo Jesus asarî'pî Galiléia pata yapî' tîîse Judéia pata ya' eewomî pra awanî'pî. Maasa pra Judéia ponkon Judeuyamî' wanî'pî Jesus anwîpai. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judeuyamî' festarî weiyu eseporî'pî itese' tîtappîikon festarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mîrîrî yai Jesus yakontononya ta'pî ipî': —Judéia pona matîi ayeseru ankupî era'mato'pe anenupa'sanya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tamî'nawîronkonya tepu'tî yu'san anî' wanî ya, ama' pe î' rî kupîiya pepîn. Anî'ya ikupî eserîkan pepîn ankonekapai awanî ya, aronne mîkonekai tamî'nawîronkon esenumenkato'pe apî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mîrîrî ta'pî to'ya maasa pra innape ikupî tîuya'nîkon pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesusya ta'pî to' pî': —Î' wani' pra amîrî'nîkon wîtî mîrîrî. Tîîse uurî uutî pepîn. Uweiyu erepansa' pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tewanmakon pe tamî'nawîronkonya akupîkon pepîn, tîîse tewanmakon pe uku'sa' to'ya. Imakui'pî pe to' wanî kai'ma to' panamanen uurî to' yewanma pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Entamo'kanto' pona matîtîi. Uurî uutî pepîn sîrîrî maasa. Uweiyu erepansa' pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mîrîrî taa tîpo Jesus ko'mamî'pî moro Galiléia po. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Moropai itakontonon wîtî'pî festa pona. Mîrîrî tîpo Jesus nîrî wîtî'pî to' ye'ma'pî pî', tîîse ama' pe attî'pî anî'ya tepu'tî namai. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jesus yuwa pî' Judeuyamî' wanî'pî entamo'kanto' yai. —O'non pata awanî? —ta'pî to'ya. —Aai'sa' pra ka'rî awanî? ");
INSERT INTO mbcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Arinîkon eseurîmapîtî'pî ipî'. —Morî pe mîîkîrî man —kai'ma tiaronkon eseurîma'pî. Tîîse tiaronkonya ta'pî: —Kaane, morî pepîn mîîkîrî. Pemonkonyamî' yenku'tînen mîîkîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tîîse ama' pe to' eseurîmapîtî'pî ipî'. Aronne to' eseurîma pra awanî'pî tepotorîkon nama tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Moropai festa arakkita pairî tîîse, Jesus ewomî'pî Judeuyamî' epîremato' yewî' ta. Moro pemonkonyamî' yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesusya tenupakon pî' Judeuyamî' esenumenka'pî kure'ne. —O'non ye'ka mîserî warayo' esenupa'pî pepîn teuren, tîîse uurî'nîkon yenupaiya epu'nen ke? —kai'ma to' eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesusya ta'pî to' pî': —Esenumenkato' ke ayenupauya'nîkon pepîn mîrîrî, tîîse uyarimatîpon maimu pî' ayenupauya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Itu'se Paapa e'to' anku'painon wanî ya, mîîkîrîya epu'tî anî' maimu pe eseurîma, uuwarîrî pra, tîîse Paapa maimu pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tîîwarîrî tîpî'rî teeseurîmasen wanî ya, ipîkku pe e'pai awanî mîrîrî. Tîîse uurî, ipîkku pe uyarimatîpon wanî epu'tî yu'se wanî. Mîrîrî ye'nen yairon uurî. Imakui'pî unkupî'pî ton pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Paapa maimu ankupîkon ton ekaremekî'pî Moisés nurî'tîya. Mîrîrî man aapia'nîkon tîîse mîrîrî yawîrî aako'mamîkon pra naatîi. Î' wani' awanî ye'nen uurî anwîpai awanîkon mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mîrîrî yuuku'pî to'ya Jesus maimu: —Imariwa'ka' pe nai. Anî'se mîîkîrî anwîpainon? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusya ta'pî: —Tiwin ikoneka pî' wai, ikupî eserîkan pepîn erî'ka'nîto' weiyu yai. Tîîse mîrîrî pî' eesewankono'makon, erî'ka'nîto' weiyu yai iku'sau'ya pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tîîse erî'ka'nîto' weiyu yai anmukukon mere pi'pî ya'tîya'nîkon, maasa pra Moisés nurî'tîya ayeserukon ton tîrî'pî aapia'nîkon ikupîkonpa. Tîîse mîrîrî wanî Moisés nurî'tî winîpainon pepîn tîîse penaronkon, irawîronkon itamokon nurî'san winîpainon. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mîrîrî warantî Moisés nurî'tîya yenupato' esuwa'ka namai anmukukon mere pi'pî ya'tîya'nîkon erî'ka'nîto' weiyu yai. Î' wani' awanî ye'nen eekore'masa'kon pri'yawon pepîn yepi'tîsau'ya pî'? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","—Teesenumenkai pra “Imakui'pî pe man”, taaya'nîkon e'pai pra man. Morî pe esenumenkatî tînîn pî' eeseurîmakon rawîrî yairî eeseurîmakonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Moropai tiaronkon Jerusalém ponkon eseurîma'pî tonpakon yarakkîrî. —Mîîkîrî naka anwîpai to' wanî manni'? ");
INSERT INTO mbcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A'kî, aronne eeseurîma moropai î' taa to'ya pra awanî ipî'. “Paapa nîmenka'pî Cristo pe awanî” kai'ma uyesa'kon esenumenka ipî' ka'rî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","—Tîîse Cristo pepîn mîîkîrî. Anna nepu'tî mîserî warayo' o'non pata painon. Tîîse Cristo, Paapa nîmenka'pî iipî yai, o'non pata pai aaipî epu'tî anî'ya pepîn —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tamî'nawîronkon yenupa pe epîremanto' yewî' ta, Jesus entaime'pî aronne: —Inna, uyepu'nenan amîrî'nîkon —ta'pîiya. —O'non pata paino pe wanî epu'tî pî' naatîi, tîîse uuwarîrî iipî'pî pepîn uurî. Uyarima'tîpon wanî yairon pe pu'kuru. Mîîkîrî epu'nenan pepîn amîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tîîse uurî epu'nen. Iipiapainon uurî. Inarima'pî uurî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mîrîrî yai Jesus anapi'pai to' wanî'pî, tîîse anî'ya yapisî pra awanî'pî, maasa pra iweiyu erepansa' pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Moropai arinîkonya innape Jesus kupî'pî. —Cristo pe awanî eserîke epu'tî pî' anna man. Maasa pra Cristo, Paapa nîmenka'pî erepamî yai, mîserî warayo' nîkupî'pî yentai konekaiya eserîke pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mîrîrî warantî pemonkonyamî' eseurîma eta'pî fariseuyamî'ya moropai teepîremasanon esanonkonya tîwakîrikon pe pra. Mîrîrî ye'nen epîremanto' yewî' era'manenan yarima'pî to'ya Jesus yapi'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Moropai Jesusya ta'pî tamî'nawîronkon pî': —Mararî uuko'manto' man amîrî'nîkon kore'ta. Mîrîrî tîpo uutî pe wai uyarimatîpon pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uutî'pî pata'pî ya' uyuwaya'nîkon kupî sîrîrî tîîse uyeporîya'nîkon pepîn. Moropai uupia attîkon eserîke pra awanîkon nîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mîrîrî taiya pî' Judeuyamî' eseurîma'pî tîîwarîrî'nîkon. —O'non pata mîîkîrî wîtî mîrîrî anî'ya teporî namai? Yai pra Judeuyamî' Gregoyamî' pata poro e'paraipîka'san kore'ta attî ka'rî Gregoyamî' yenupai. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O'non ye'ka pe awanî koo? Î' pî' eeseurîma esepu'tî pra man. Uyuwaya'nîkon kupî sîrîrî tîîse uyeporîya'nîkon pepîn. Moropai uupia aaipîkon pepîn nîrî taiya manni' —kai'ma to' eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mîrîrî tîpo Judeuyamî' festarî ataretî'ka weiyu yai awanî'pî. Ipîkku panpî' mîrîrî wei wanî'pî to' ataretî'ka ye'nen. Mîrîrî yai Jesus e'mî'sa'ka'pî to' kore'ta. Aronne awentaime'pî. —Tuna aninnîpainon wanî ya, uupia asi'kî moropai awuku ton eporîya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Paapa maimu e'menukasa'ya taasa' yawîrî, innape uku'nen yewan yapai kure'ne teepa'kasen tuna wanî pe man, manni' enen ko'mannîto' tîînen —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tîîse tuna pî' eeseurîma pepîn mîrîrî. Morî Yekaton Wannî pî' eeseurîma. Manni' innape Jesus ku'nenanya yapisî pe man, tewankon ya' aako'manto'pe. Tîîse Morî Yekaton Wannî erepansa' pra awanî'pî. Maasa pra Jesus enna'posa' pra awanî'pî tun pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mîrîrî warantî Jesus eseurîma eta tîuya'nîkon pe arinîkonya innape ikupî'pî. —Mîîkîrî man, Paapa narima'pî tîmaimu ekareme'nen pe, manni' Moisés nurî'tî nekaremekî'pî manni' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tiaronkonya ta'pî: —Mîîkîrî man pîika'tîton Paapa nîmenka'pî pe. Tîîse mîrîrî pî' tiaronkonya ta'pî: —Paapa nîmenka'pî pe pra man. Maasa pra Cristo iipî pepîn Galiléia poi. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Paapa maimuya taa penaro' Davi nurî'tî parî'pî pe Cristo wanî. Moropai Davi nurî'tî ko'mamî'pî Belém po, moroni' Cristo esenpo pe man, taasai'ya man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mîrîrî wenai to' esiyu'pîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tiaronkon wanî'pî Jesus anapi'pai yarakkamokonpa. Tîîse anî'ya yapisî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Epîremanto' yewî' era'manenan enna'po'pî tesanonkon pia, teepîremasanon esanonkon moropai fariseuyamî' pia. —Î' wani' awanî ye'nen enepîya'nîkon pra awanî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—O'non pata morî pe mîîkîrî eseurîma warantî anî' eseurîma etasa' annaya pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—Amîrî'nîkon esenku'tîsa' nîrî ka'rî —ta'pî fariseuyamî'ya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Epu'nenan pepîn amîrî'nîkon. Anna wanî ayesa'kon pe moropai fariseuyamî', epu'nen pe anna wanî. Moropai annaya ikupî pra man innape —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","—Insanan pemonkonyamî' poroponkon Paapa maimu epu'nenan pepîn. E'taruma'tînto' ya' tuutîsanon insanan —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Moropai tiaron to' yonpa wanî'pî to' kore'tawon itese' Nicodemos. Mîîkîrî manni' ewaron ya' Jesus pia iipî'pî pena. Mîîkîrîya ta'pî: ");
INSERT INTO mbcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Uyeserukon wanî e'mai' pe pemonkon maimu eta moropai iteseru pî' esenumenkan. Mîrîrî tîpo imakui'pî pe awanî esepu'tî, morî pe awanî esepu'tî. Tîîse uyeserukon yairî pra imakui'pî mîîkîrî taa pî' uurî'nîkon man, tetai pra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ta'pî to'ya Nicodemos pî': —Amîrî Galiléia pon nîrî ka'rî. Maasa Paapa maimu pî' esenupakî. Galiléia poi tîmaimu ekareme'nen ton yarima Paapaya taasa' pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mîrîrî tîpo to' e'paraipîka'pî tewî'kon kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Moropai Jesus wîtî'pî wî' itese' Oliveira pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tiaron wei yai attî'pî penane marî Judeuyamî' epîremato' yewî' ta. Moro arinîkon pemonkonyamî' eperepî'pî iipia. To' kore'ta eereuta'pî moropai to' yenupa'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mîrîrî pî' awanî tanne, fariseuyamî' moropai Moisés nurî'tîya yenupanto' pî' yenupatonkonya wîri' enepî'pî iipia imakui'pî koneka'tîpon. Mîîkîrî enepî'pî to'ya Jesus pia, tamî'nawîronkonya era'ma tanne. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ta'pî to'ya Jesus pî': —Anna yenupanen, mîseni' wîri' eporî pî' anna man warayo' yarakkîrî tîîse tînyo pepîn. Yarakkîrî awanî tanne eporî pî' anna man. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés nurî'tîya ta'pî: “Tînyo kenan wîri' e'sa' ya tiaron warayo' yarakkîrî mîwîtîi tî' ke”. Tîîse amîrî esenumenkato' anepu'pai anna wanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tîîse Jesus pî' to' o'ma'ta kinî ipî' teeseurîmakonpa kai'ma. Jesus e'muruika'pî moropai kasapan menuka'pîiya tenya yeperu ke. ˻Etaiya pra man kai'ma to' esenumenka'pî ipî'.˼ ");
INSERT INTO mbcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Inî' panpî' ipî' ekaranmapopîtî'pî to'ya. Mîrîrî ye'nen awe'mî'sa'ka'pî. To' pî' ta'pîiya: —Akore'tawonkon anî' wanî ya imakui'pî ton pîn, mîîkîrîya e'mai' pe tî' yenumî yu'se wai iwîpa —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Inî'rî awe'muruika'pî moropai non menuka'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mîrîrî taa Jesusya pî' to' esenumenka'pî. Imakui'pî pe tîwanîkon epu'tî'pî to'ya. Mîrîrî ye'nen to' eppepî'pî. To' wîtî'pî iipiapai tiwin pî'. A'yeke'ton panpî' wîtî'pî e'mai' pe. Ite'ma'pî pî' a'yeke'tonon pu'kuru pepîn wîtîpîtî'pî tiwin pî', tamî'nawîrî. Jesus e'nîmî'pî moropai wîri'. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus e'mî'sa'ka'pî. Wîri' era'ma'pîiya tîîse ipî' eseurîma'san wîtî'pî wanî'pî. Ta'pîiya wîri' pî': —O'nonan see inkamoro imakui'pî ankoneka'pî ekaremekî'tîponkon? Aasa'manta e'pai man taa to'ya pra nai? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Inna, uyepotorî, uwî to'ya pra man —ta'pî wîri'ya ipî'. —Moriya aasa'manta e'pai man tauya pepîn nîrî —ta'pî Jesusya. —Atîkî apata ya'. Tîîse inî' imakui'pî kî'konekai iku'sa'ya manni' warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mîrîrî tîpo Jesusya pemonkonyamî' yeurîma'pî inî'rî. —Uurî wanî non po tîîko'mansenon weiyu'manen pe. Anî' iipî ya uwenairî asarî pepîn ewaron ta, tîweiyu eposai'ya ye'nen, tîîko'manto' ton tîînen. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mîrîrî pî' fariseuyamî'ya ta'pî: —Aawarîrî apî'rî eeseurîma tiaronya taa pra man apî'. Mîrîrî ye'nen anî'ya innape akupî pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mîrîrî yuuku'pî Jesusya. Ta'pîiya: —Innape upî'rî eseurîma, tîîse useruku pepîn. O'non pata pai iipî'pî uurî epu'tî pî' wai. O'non pata pona uutî epu'nen uurî. Tîîse amîrî'nîkonya epu'tî pepîn o'non pata pai uuipî'pî moropai o'non pata pona uutî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amîrî'nîkon esenumenka upî' anepu'tîkon anera'ma'pîkon yawîrî. Mîrîrî wenai seru'ye' wanî kai'ma eeseurîmakon. Tîîse uurîya anî' yako'menka pepîn, anî' yenumîuya pepîn sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tîîse anî' yako'menkauya ya, yairî eseurîma, seru'ye' pra, maasa pra uuwarîrî eseurîma pepîn unepu'tî pe. Uyun nîrî eseurîma, uupia tîîko'mansen, uyarima'tîpon. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés nurî'tîya yenupanto'ya taa: Tiwinan pemonkon eseurîma ya, tiwinsarî si'ma innape ikupî pepîn. Tîîse asakî'nankon eseurîma ya se' kaisarî, innape awanî mîrîrî. Ayeserukon mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uurî eseurîmasa' e'to' pî' anî' pe wanî pî'. Moropai uyarimatîpon Paapa eseurîmasa' upî' eseurîma'pî kaisarî. Mîrîrî ye'nen ayeserukon yawîrî innape awanî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Fariseuyamî'ya ta'pî ipî': —O'non patawon ayun? Jesusya ta'pî: —Uurî epu'nenan pepîn amîrî'nîkon. Uyun epu'nenan pepîn nîrî. Anî' pe wanî epu'nen pe awanîkon ya, anî' pe uyun wanî epu'tî'pîya'nîkon e'painon nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mîrîrî warantî pemonkonyamî' yenupa'pî Jesusya Judeuyamî' epîremato' yewî' ta aminke pra to' nîtîrî yense' pî'. Anapi'pai tiaronkon wanî'pî tîîse yapisî to'ya pra awanî'pî, maasa pra iweiyu eseposa' pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Moropai inî'rî Jesusya to' yeurîma'pî: —Uurî uutî kupî sîrîrî tarîpai. Uutîsa' yai, uyuwaya'nîkon kupî sîrîrî tîîse uyeporîya'nîkon pepîn. Apona'nîkon amakuyikon ko'mamî tanne aasa'mantakon. O'non pata uutî ya attîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mîrîrî taa Jesusya pî' Judeuyamî' esenumenka'pî. —O'non pata pona attî? —kai'ma to' eseurîma'pî. —Amîrî'nîkon wîtî pepîn upîkîrî taiya manni'. Awe'wî ka'rî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Inî'rî Jesus eseurîma'pî to' pî': —Amîrî'nîkon man tarîronkon pe. Sîrîrî non po tîîko'mansenon amîrî'nîkon. Tîîse uurî wanî ka' poino pe. Sîrîrî non pon pepîn uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Uurî mîîkîrî ta'pîuya sa'rî, mîîkîrî pe ukupîya'nîkon pra awanîkon ya innape, aasa'mantakon, amakuyikon e'ronasa' pra tîîse. Mîrîrî ye'nen amakuyikon ko'mamî tanne aasa'mantakon tauya manni' —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jesus pî' ta'pî to'ya: —Anî' kin amîrî, moriya? Jesusya yuuku'pî: —Amîrî'nîkon yeurîma pia'tî'pîuya pata pai, ta'pîuya anî' pe wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mararon pepîn eseurîmato' man amîrî'nîkon pî', imakui'pî pe awanîkon pî'. Uyarimatîpon wanî seru'ye' pepîn. Yairî awanî. Mîîkîrî nekaremekî'pî upî' ekareme'nen pe wanî tamî'nawîronkon pî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tîyun pî' Jesus eseurîma mîrîrî, tîîse epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Moropai Jesusya ta'pî to' pî': —Uurî ka' poi iipî'pî pemonkon pe, uurî pîmî'sa'kaya'nîkon pe naatîi pakî'nan pona. Mîrîrî tîpo Paapa munmu pe uyepu'tîya'nîkon kupî sîrîrî. Uuwarîron pe pra uyepu'tîya'nîkon pe naatîi. Paapaya upanamasa' yawîrî ayeurîmauya'nîkon sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uupia uyarimatîpon man. Urumakaiya pra man. Maasa pra itu'se Uyun e'to' ku'nen pe wanî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mîrîrî warantî Jesus eseurîma eta tîuya'nîkon pe arinîkonya innape ikupî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mîrîrî ye'nen Jesusya ta'pî Judeuyamî' pî', innape tîku'nenan pî': —Umaimu yawîrî aako'mamîkon ya, upemonkono pe awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Moropai yairon epu'tîya'nîkon kupî sîrîrî. Moropai mîrîrî wenai amo'kasai'ya'nîkon, anî' poitîrî pe awanîkon namai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mîrîrî pî' ta'pî to'ya: —Abraão nurî'tî payannî'san anna. O'non pata anî' poitîrî pe anna e'sa' pra man. Î' wani' awanî ye'nen anî' poitîrî pe pra eenakon taaya manni'? ");
INSERT INTO mbcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusya ta'pî to' pî': —Useruku pepîn. Imakui'pî ku'nen pe awanîkon ya, amakuyikon enasa' man ayentai'nîkon, ipoitîrî pe awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ipoitîrî wanî ya, aako'mamî pepîn ipatîkarî tesa' yewî' ta. Ipoitîrî pe neken mîîkîrî wanî. Tîîse inmu wanî ya, mîîkîrî ko'mamî ipatîkarî tîyun yewî' ta, inmu pe tîwanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tîîse uurî Paapa munmuya amo'kakon ya, anî'rî poitîrî pe awanîkon pepîn tarîpai. Imakui'pî yentai awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraão nurî'tî payannî'san amîrî'nîkon seru' pepîn. Tîîse uurî anwîpai awanîkon sîrîrî. Maasa pra awakîrikon pe pra unekaremekî eta pî' naatîi, anku'pai pra awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Uurî, uyunya uyenupa'pî ekaremekîuya apî'nîkon. Moropai amîrî'nîkon nîrî ayunkonya apanama'pîkon yawîrî awanîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta'pî to'ya Jesus pî': —Anna man Abraão nurî'tî payannî'san pe. Jesusya yuuku'pî: —Abraão yonpa pe awanîkon ya, morî ku'nen pe awanîkon morî ku'nen pe Abraão nurî'tî wanî'pî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tîîse uurî anwîpai awanîkon, yairî ayeurîmasau'ya'nîkon tanne, Paapaya uyeurîma'pî yawîrî. Mîrîrî ye'ka ku'nen pe pra Abraão nurî'tî wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Innape ayunkon yeseru yawîrî ayeserukon wanî mîrîrî, tîîse Abraão nurî'tî yeseru yawîrî pra —ta'pî Jesusya. Ta'pî to'ya Jesus pî': —Paapa munkîyamî' anna. Paapa man anna yun pe. Iyun pîn more warantî anna wanî pepîn sîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tîîse Jesusya ta'pî: —Uurî iipî'pî Paapa piapai. Uuwarîrî iipî'pî pepîn tîîse uyarimatîpon maimu pe pu'kuru uuipî'pî. Ayunkon pe Paapa wanî ya, u'nînmaya'nîkon e'painon, uyonpa pe awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Umaimu epu'tîya'nîkon pra awanî. Mîrîrî ye'nen aataka'makon ayeurîmauya'nîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amîrî'nîkon yun wanî Makui pe. Itu'se mîîkîrî e'to' ku'nen pe awanîkon. Pemonkon wîînen pe mîîkîrî e'sa' pena pata pai. Seru'ye' pe awanî, maasa pra yairî awe'to' ton pra awanî ye'nen. Seru'ye' pe awe'sa' ya, teseru ta awanî mîrîrî. Seru'ye' mîîkîrî moropai seru'ye'kon yunkon pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Seru'ye' pe pra ayeurîmauya'nîkon. Tîîse innape umaimu kupîya'nîkon pra awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Imakui'pî ankoneka'pî moro man, epu'nen uurî”, taa anî'ya pepîn upî'. Imakui'pî ku'sau'ya pra wai. Ayenku'tîuya'nîkon pepîn. Î' wani' awanî ye'nen umaimu kupîya'nîkon pra awanî innape? ");
INSERT INTO mbcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Paapa pemonkono wanî imaimu etanen pe moropai yawîron pe. Tîîse amîrî'nîkonya Paapa maimu yapurî pepîn, yawîrî pra awanîkon. Maasa pra Paapa pemonkono pe pra awanîkon ye'nen —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mîrîrî pî' Judeuyamî'ya ta'pî Jesus pî': —Kane kane amîrî, Samaria poinon. O'ma' yense' pe nai —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusya ta'pî: —O'ma' yense' pepîn uurî. Uyun yapurîuya sîrîrî. Tîîse amîrî'nîkonya uyapurî pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Uurî yapurî pemonkonyamî'ya yuwauya pepîn. Tîîse mîrîrî yuwa tiaronya, uyunya. Moropai yairî mîîkîrî wanî pemonkonyamî' yako'menkanen pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ayenku'tîuya'nîkon pepîn. Yairî ayeurîmauya'nîkon. Umaimu yawîrî aako'mamîkon ya, aasa'mantakon pepîn tiwin kin —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judeuyamî'ya ta'pî ipî': —Mîrîrî taaya pî' o'ma' yense' pe ayepu'tî pî' anna man. Abraão nurî'tî sa'manta'pî, moropai penaro' Paapa maimu ekareme'nenan sa'manta'pî nîrî. Tarîpai amîrîya taa: “Umaimu yawîrî anî' ko'mamî ya, aasa'manta pepîn”, kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Anna tamo Abraão nurî'tî yentai awanî kai'ma eesenku'tîsa', Paapa maimu ekareme'nenan yentai awanî kai'ma eesenku'tîsa'. Anî' pe renamo awanî kai'ma eesenku'tîsa' mîrîrî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusya ta'pî: —Uuwarîrî morî uurî tauya ya, î' pe pra rî awanî mîrîrî. Anî'ya uyapurî pepîn mîrîrî pî'. Tîîse uuwarîrî atapurî pepîn. Uyunya ta'pî upî': “Morî Mîîkîrî”. “Mîîkîrî anna yepotorî” taanenan amîrî'nîkon, manni'ya ta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Uyun epu'sa'ya'nîkon pra naatîi. Tîîse uurî mîîkîrî epu'nen pu'kuru. Uurî nîrî epu'nen pepîn kai'ma eseurîma ya, seru'ye' pe awanî, seru'ye' pe awanîkon warantî. Maasa pra mîîkîrî epu'tîuya ye'nen moropai imaimu yawîrî iku'nen uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atamokon Abraão nurî'tî esenumenka'pî uuipî weiyu pî'. Mîrîrî pî' aatausinpa'pî. Kure'ne aatausinpa'pî uuipî epu'tî tîuya pî' —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judeuyamî'ya ta'pî ipî': —Aseruku mîrîrî, pena Abraão nurî'tî sa'manta'pî. Amîrî 50 kono' ma're akonopo man. Abraão nurî'tî era'matîpon pepîn amîrî. Aseruku —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesusya ta'pî to' pî': —Ayenku'tîuya'nîkon pepîn. Abraão nurî'tî ton pra tîîse moro wanî'pî. Ipatîkaron uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mîrîrî taiya pî' to' ekore'ma'pî. Inonkon tî'kon yanumî'pî to'ya, iwîkonpa kai'ma. Tîîse Jesus esonomî'pî arinîkon kore'ta. Eepa'ka'pî Judeuyamî' epîremato' yewî' tapai. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Moropai tuutî pe, warayo' era'ma'pîiya, enkaru'nan. Enkaru'ne eesenpo pe mîîkîrî wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Inenupa'sanya era'ma'pî nîrî. Jesus pî' ta'pî to'ya: —Anna yenupanen, anî' nîkupî'pî imakui'pî wenai mîserî warayo' esenpo'pî enkaru'ne? Tînkoneka'pî wenai ka'rî? Tîsan, tun nîkoneka'pî wenai ka'rî? ");
INSERT INTO mbcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesusya ta'pî: —Anî' nîkoneka'pî imakui'pî wenai mîserî warayo' e'taruma'tî pra man, inkupî'pî wenai moropai itun, isan nîkupî'pî wenai. Paapaya iku'sa' pra man enkaru'ne. Enkaru'ne eesenpo'pî Paapa esenyaka'mato' ipî' era'mato'pe arinîkonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Uyarimatîpon esenyaka'mato' kupî pî' ko'mannî e'pai man wei pe awanî tanne. Ewaron ke eena kupî sîrîrî. Mîrîrî yai anî' esenyaka'ma eserîke pra awanî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sîrîrî non po uuko'mamî pîkîrî pemonkonyamî' weiyu'ma pî' uuko'mamî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mîrîrî taa tîpo, Jesusya tetaku yenumî'pî non pona. Mîrîrî ke non ki'ma'pîiya. Enkaru'nan yenu kî'pa'pîiya mîrîrî ke. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Moropai ta'pîiya enkaru'nan pî': —Tuna yense' itese' Siloé ka' e'pîta —ta'pîiya. (“Yarima'pî” taato' mîrîrî Siloé umaimukon ta.) Attî'pî Jesus maimu pe. Awe'pî'pî moropai eesepi'tî'pî. Enkaru'ne pra eena'pî. Tamî'nawîron era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mîrîrî yai tiaronkonya era'ma'pî, itonpayamî' moropai tiaronkonya. Mîîkîrî epu'tî'pî to'ya enkaru'nan pe. —A'kî mîîkîrî era'makî —ta'pî to'ya. —Mîîkîrî manni' enkaru'nan. Tîpîika'tîto' ton esatî pî' aako'manpîtî'pî manni' tamî'nawîronkon pî' —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mîrîrî pî' tiaronkonya ta'pî: —Inna, mîîkîrî mîîkîrî seru' pepîn. Tîîse tiaronkonya ta'pî: —Kaane, mîîkîrî pepîn. Enkaru'nan warainon seru' pepîn, tîîse tiaron pe man, enkaru'ne pra. Mîrîrî ye'nen mîîkîrî pî' ekaranmapo'pî to'ya. Ta'pîiya to' pî': —Inna, uurî mîîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ta'pî to'ya ipî': —O'non ye'ka pe ayenu esepi'tîsa' mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta'pîiya to' pî': —Warayo' itese' Jesusya non ki'ma pî' man mararî mîrikkî. Moropai uyenu kî'pa pî' man ike. Moropai taa pî' man upî', “E'pîta Siloé itese' tuna ka'”. Mîrîrî ye'nen wîtîn pî' wai. E'pîn pî' wai. Tarîpai tamî'nawîrî era'ma pî' wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—O'non see mîîkîrî ayepi'tîtîpon? —ta'pî to'ya ipî'. —Epu'tîuya pra wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mîrîrî tîpo enkaru'nan esepi'tîsa' yarî'pî to'ya fariseuyamî' pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Maasa pra erî'ka'nîto' weiyu yai Jesusya non ki'ma'pî manni' enkaru'nan yenu yepi'tîpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mîrîrî wenai fariseuyamî'ya ekaranmapo'pî esepi'tî'pî pî': —O'non ye'ka pe aku'sai'ya mîrîrî? —ta'pî to'ya. Ta'pîiya to' pî': —Uyenu kî'pa'pîiya ikuisa' ke. E'pî'pî, tarîpai tamî'nawîrî era'mauya sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseuyamî'ya ta'pî ipî': —Paapa piapainon pepîn mîîkîrî Jesus. A'kî, erî'ka'nîto' weiyu yai eesenyaka'masa' Paapa maimu yawîrî pra era'makî —ta'pî to'ya. Tîîse tiaronkonya ta'pî: —Imakui'pî pe Jesus wanî ya, ikoneka eserîkan pepîn kupîiya pepîn e'painon? Imakui'pî pe awanî pepîn. Se' kaisarî pra to' esenumenka'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Inî'rî enkaru'nan esepi'tîsa' pî' ta'pî to'ya: —Amîrî kanan? Ayepi'tîtîpon mîîkîrî. Î' kai'ma esenumenkan pî' nan ipî'? —ta'pî to'ya. Yuuku'pîiya: —Mîîkîrî man Paapa maimu ekareme'nen pe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Moropai Judeuyamî'ya enkaru'nan esepi'tî'pî mu'tunpa'pî. Innape enkaru'ne tîîko'mamî tîpo eesepi'tîsa' kupî to'ya pra awanî'pî. Mîrîrî ye'nen isan moropai iyun yanno me'po'pî to'ya. Judeuyamî' pia to' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta'pî Judeuyamî'ya tînanno'sankon pî': —Anmukukon pe mîseni' warayo' nai? Yuuku'pî to'ya: —Inna, anna more mîserî. Inî'rî ta'pî Judeuyamî'ya to' pî': —Enkaru'ne esenpo'pî mîserî? —Inna —ta'pî to'ya. —Moriya o'non ye'ka pe itenu esepi'tîsa' mîrîrî? —ta'pî Judeuyamî'ya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Anna munkî pe mîserî epu'tî pî' anna man. Enkaru'ne eesenpo'pî moropai tîko'man pe aako'mansa' enkaru'ne. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tîîse o'non ye'ka pe eesepi'tîsa' epu'tî annaya pra man. Anî'ya yepi'tîsa' epu'tî annaya pra man. Tîîse more pepîn mîserî. Ekaranmapotî see ipî'. Tîîwarîrî ekaremekîiya —ta'pî iyun, isanya Judeuyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mîrîrî warantî to' eseurîma'pî eranne' pe tîwanîkon ye'nen. Maasa pra Judeuyamî' esanon eseurîmasa' wanî'pî, innape Jesus, Paapa nîmenka'pî kupîtîpon yenpa'ka epere'nîto' yewî' tapai kai'ma to' eseurîma'pî. Mîrîrî pî' to' esi'nîpî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mîrîrî wenai ta'pî iyunya: —A'yeke'ton pe man. Ekaranmapotî ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Inî'rî mîîkîrî pî' ta'pî to'ya: —A'kî, Paapaya uyepi'tîsa' ka'kî. Maasa pra mîîkîrî Jesus man imakui'pî ku'nen pe, epu'tî pî' anna man. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yuuku'pîiya: —Imakui'pî pe mîîkîrî wanî epu'tîuya pra wai. Sîrîrî neken epu'tî pî' wai. Enkaru'ne wanî'pî tîîse sîrîrî era'mauya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inî'rî ta'pî to'ya ipî': —Î' koneka'pîiya apî'? O'non ye'ka pe ayenu yepi'tî'pîiya? ");
INSERT INTO mbcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta'pîiya to' pî': —Aasîrî ekaremekî pî' wai apî'nîkon, tîîse innape ikupîya'nîkon pra naatîi. Î' wani' awanî ye'nen anetapai awanîkon inî'rî? Ipemonkono pe enapai awanîkon ka'rî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mîrîrî pî' to' ekore'ma'pî. Esepi'tî'pî pî' to' wo'ma'ta'pî. —Amîrî man ipemonkono pe. Anna kaane. Anna man Moisés nurî'tîya yenupanto' yawîrî esenupa'san pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Innape Paapaya tîmaimu ekaremekî'pî Moisés nurî'tî pî'. Mîrîrî epu'tî pî' anna man. Tîîse mîîkîrî epu'tî annaya pra man, o'non pata paino pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mîrîrî taa to'ya pî' ta'pî warayo'ya: —Esenumenkanto' mîrîrî. O'non pata pai mîîkîrî erepansa' epu'tîya'nîkon pra awanî. Tîîse uurî enkaru'nan yenu yepi'tîsai'ya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Paapaya imakui'pî ku'nenan maimu yuuku pepîn. Tamî'nawîronkonya epu'tî mîrîrî. Tapurînen kupî Paapaya meruntî ke. Itu'se tîwe'to' ku'nen kupîiya meruntî ke. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","More pe esenpo'pî enkaru'ne. A'yeke'ton pe wanî tanne uyenu yepi'tîsai'ya. Sîrîrî pata esippia'tî'pî pata pai eesetasa' pra man, enkaru'nan esepi'tîsa' sîrîrî warantî. Tîîse iku'sai'ya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Paapa piawon pe pra mîîkîrî wanî ya, mîrîrî ye'ka kupî'pîiya pepîn e'painon —ta'pî warayo'ya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ipî' to' ekore'ma'pî. —Kane, kane, amîrî. Imakui'pî amîrî. Imakui'pî ya' pu'kuru esenpo'pî amîrî. Anna panamaya pepîn —ta'pî to'ya ipî'. Moropai yenpa'ka'pî to'ya tîkore'tapai'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mîrîrî eta'pî Jesusya, warayo' yenpa'kasa' to'ya yekare. Moropai yuwai attî'pî. Eporî'pîiya. Ta'pî Jesusya ipî': —Ka' poi iipî'pî pemonkon pe, Paapa narima'pî kupî pî' nan innape? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Anî'se mîîkîrî? Upî' ka'kî innape iku'to'peuya, —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusya ta'pî: —Era'ma pî' nai, ayarakkîrî eeseurîma manni', uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Warayo'ya ta'pî: —Uyepotorî, innape akupî pî' wai. Moropai Jesus yapurî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesusya ta'pî: —Pemonkonyamî' nîkupî'pî imakui'pî yenpoi uuipî'pî sîrîrî non pona, enkaru'nankonya era'mato'pe moropai era'manenan enato'pe enkaru'ne. Tiaronkon wanî enkaru'ne, tîîse to' esenumenkato' wanî enkaru'ne pra. Tewankon ke uyepu'tî to'ya. Tiaronkon wanî pri'ya pu'kuru to' yenu, tîîse teesenumenkato'kon ke uyera'ma to'ya pepîn, innape ukupî tîuya'nîkon pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Moro awanî'pî tiaronkon fariseuyamî' iipia. Mîrîrî taiya eta'pî to'ya. Tîîse —Enkaru'ne pra anna man, Paapa epu'nenan anna —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesusya ta'pî: —Enkaru'ne anna man, epu'tî annaya kai'ma eesenumenkasa'kon ya amakuyikon kupî'pî Paapaya e'painon tîîwanmîra. Tîîse amîrî'nîkonya taa: “Enkaru'ne pra anna man”. Mîrîrî ye'nen Paapaya amakuyikon ku'sa' pra man tîîwanmîra —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Moropai Jesusya sîrîrî panton ekaremekî'pî fariseuyamî' pî': —Ayenku'tîuya'nîkon pepîn. Anî' ewomî ya carneiroyamî' ko'manto' kurarari ta, mana'ta yai pra, mîîkîrî wanî ama'ye' pe. Carneiroyamî' yama'runpai eewomî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tîîse carneiroyamî' esa' ewomî mana'ta yai pu'kuru. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mana'ta era'manenya mana'ta yarakkanmoka carneiroyamî' esa' ewonto'pe. Moropai carneiroyamî' esa'ya tekînon yanno tiwin pî', to' ese' pî'. Imaimu epu'tî to'ya. Iipia to' iipî. Moropai to' yarîiya parî' yuwai. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tekînon yarîiya. To' rawîrî attî moropai ite'ma'pî pî' to' wîtî, imaimu pî' tesa'kon pe epu'tî tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tînepu'tîkon pepîn pemonkon ye'ma'pî pî' to' wîtî pepîn. Imaimu pî' tiaron pe epu'tî to'ya moropai iipiapai to' epe. Mîrîrî warantî Jesusya fariseuyamî' yeurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Mîrîrî carneiroyamî' pantoni ekaremekî'pî Jesusya to' pî' tîîse o'non ye'ka pe tenupaiya'nîkon epu'tî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Inî'rî Jesusya ta'pî: —A'kî, uurî mana'ta, carneiroyamî' ewonto' warainon. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tiaronkon iipî'pî urawîrî Paapa maimu pe pra, tîîse ama'ye'kon iipî warantî. Carneiroyamî' anama'runpapai ama'ye'kon wanî warantî, pemonkonyamî' yaka'mapai to' wanî'pî, inkamoro yenku'tîi. Tîîse Paapa pemonkonoyamî'ya pu'kuru to' maimu eta pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Uurî wanî mana'ta warantî, pemonkonyamî' man carneiroyamî' warantî. Uwenairî anî' ewomî ya, tîpîika'tîto' ton eporîiya î' ton pra awanî pepîn. Morî pe eewomî moropai eepa'ka tîîwanmîra tekkari ton eporîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ama'ye' wanî carneiroyamî' anama'runpapai. To' yama'runpaiya moropai to' tî'kaiya. Mîrîrî warantî pra uui'sa'. Uurî uui'sa' sîrîrî enen upemonkonoyamî' ko'manto' ton tîîse, morî pe to' ko'manto'pe, sîrîrî tîpose tîîko'mamî'pîkon yentai. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Uurî carneiroyamî' era'manen warainon morî. Uurîya uuko'manto' tîrî carneiroyamî' pîika'tîto'peuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tiaron pemonkon wanî ya, carneiroyamî' esa' pe pra, tîîse carneiroyamî' esa' poitîrî pe, teeseka'nunkai carneiroyamî' pîika'tîiya pepîn, imîrî pe pra to' wanî ye'nen. O'ma' carneiro yapi'nen kaikusi iipî era'ma tîuya ya, eepe. Moropai o'ma'ya carneiroyamî' pîrai'pîka moropai tiaron yapisîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Carneiroyamî' era'manen epe maasa pra carneiroyamî' esa' pia teesenyaka'masen pe tîwanî ye'nen. Itekînnan pe pra carneiroyamî' wanî. To' pînînmaiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Uurî man mîrîrî warantî pra. Carneiroyamî' esa' warainon uurî, morî. Upemonkonoyamî' epu'nen uurî tamî'nawîrî. Moropai upemonkonoyamî'ya uyepu'tî tesa'kon pe wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mîrîrî warantî Paapaya uyepu'tî tamî'nawîrî. Moropai Paapa epu'nen uurî. Moropai uuko'manto' tîrîuya upemonkonoyamî' ton pe, inkamoro pîika'tîto'peuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tiaronkon upemonkonoyamî' man tarîronkon pepîn. Moropai inkamoro nîrî enepîuya e'pai awanî uupia, tarîronkon pokonpe. Moropai umaimu eta to'ya kupî sîrîrî. Awanî kupî sîrîrî tiwinan upemonkono pe to' ena moropai tiwinan uurî to' esa'. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Uuwarîrî enen e'to' tîrîuya kupî sîrîrî. Moropai uusa'manta e'mî'sa'kato'pe enen. Mîrîrî wenai uyunya u'nînma. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Anî'ya uwî pepîn itu'se pra wanî tanne. Isa'mantapai wai. Uuwarîrî e'tîrî, uusa'mantato'pe. Moropai uuwarîrî e'mî'sa'ka kupî sîrîrî uusa'manta tîpo. Mîrîrî warantî e'to'pe kai'ma Uyunya uyarima'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judeuyamî' esiyu'pîtî'pî inî'rî Jesusya tenupato'kon pî'. Se' kaisarî pra to' esenumenka'pî Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Î' wani' awanî ye'nen imaimu eta pî' aako'mamîkon —ta'pî tiaronkonya. —Aataka'masa'kon mîrîrî. O'ma' yense' pe man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tîîse tiaronkonya ta'pî: —Kaane, imariwa'ka'pan yeseru yairî pra uyenupaiya'nîkon mîrîrî. Moropai imariwa'ya anî' kupî pepîn meruntî ke enkaru'nan yenu konekato'peiya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mîrîrî tîpo teserukon yawîrî Judeuyamî' eperepî'pî Jerusalém po epîremanto' yewî' ekareme'se inî'rî Paapa yewî' pe teepîremato'kon wenai, kono' yai awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus asarî'pî Judeuyamî' epîremato' iwa'to' ta itese' Salomão pata'se'. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iwoi Judeuyamî' eperepî'pî. Ipî' ta'pî to'ya: —Î' wani' awanî ye'nen anna yaka'ma pî' aako'mamî? Paapa nîmenka'pî pe awanî ya, aronne esekareme'kî innape epu'to'pe annaya —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusya ta'pî: —Aasîrî esekaremekî'pî apî'nîkon, tîîse innape ukupîya'nîkon pra awanî'pîkon. Uyun ese' yai unkoneka'pîya uyekaremekî mîrîrî, anî' pe wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tîîse innape ukupîya'nîkon pra awanî, maasa pra uyekînnon carneiroyamî' kore'tawonkon pepîn amîrî'nîkon. Upemonkono pe pra awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Uyekînnonya umaimu epu'tî tesa'kon maimu pe. To' epu'nen uurî uyekîn pe. Uwenairî to' wîtî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ipatîkarî to' ko'manto' ton tîrîuya. Ipatîkarî to' ko'mamî, to' sa'manta pepîn, Paapa piapai to' ko'mamî pepîn tiwin kin. Uyenya' to' wanî moropai uyenya pai anî'ya to' mo'ka pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Uyunya to' tîrî'pî uupia. Uyun yentainon ton pra man. Uyun yenya' to' wanî moropai itenya pai anî'ya to' mo'ka pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Uurî moropai Uyun tiwinan. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mîrîrî taiya pî' Judeuyamî' ekore'ma'pî. Inkamoroya tî'kon yanumî'pî Jesus wîîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mîrîrî pî' Jesusya ta'pî: —Tu'ke ite'ka morî ku'sau'ya ya Uyun meruntîri ke. O'non unkoneka'pî wenai uwî yu'se awanîkon? ");
INSERT INTO mbcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judeuyamî'ya ta'pî: —Morî konekasa'ya wenai awî annaya pepîn, tîîse imakui'pî pe eeseurîmasa' ye'nen Paapa pî'. Amîrî pemonkon. Tîîse pemonkon pe si'ma Paapa pe awanî kai'ma eeseurîma. Imakui'pî mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusya ta'pî: —Awe'menukasa' man Paapa kaaretarî pî' see warantî. Pemonkonyamî' pî' ta'pîiya: “Yepotorî Wannî warainokon amîrî'nîkon”. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Paapa maimu mîrîrî. Yairî pra man taa pepîn. Mîîkîrî Paapa maimu menukatîponya ta'pî tiaronkon pemonkonoyamî' pî' Paapa warantî awanîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Î' wani' awanî ye'nen imakui'pî pe eseurîman pî' nai, taaya'nîkon upî', uurî Paapa munmu tauya wenai? Paapa nîmo'ka'pî uurî tîmîrî pe, Paapa naipontî'pî uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Uyun nîkupî pî' esenyaka'ma pra awanî ya, umaimu kî'kupîi innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tîîse uyun nîkupî pî' esenyaka'ma era'maya'nîkon ya, innape unkupî'pî ku'tî. Umaimu anku'pai pra awanîkon ya innape, mîîwîni tîîse unkoneka'pî ku'tî innape. Uurî pia Paapa ko'mamî, moropai Paapa pia uuko'mamî ku'tî innape —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mîrîrî pî' to' ekore'ma'pî inî'rî. Yapisî yonpa'pî to'ya. Tîîse to' piapai attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordão ratai pona attî'pî, e'mai' pe João Batistaya pemonkonyamî' yenpatakona'pî pata'pî ya'. Moro aako'mamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Arinîkon pemonkonyamî' wîtî'pî iipia. Ta'pî to'ya: —Anî'ya ikupî eserîkan pepîn konekaiya pra João nurî'tî wanî'pî, tîîse inekaremekî'pî Jesus pî' man innape, tamî'nawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Miarî arinîkonya ikupî'pî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Warayo' wanî'pî pri'ya pra, itese' Lázaro. Mîîkîrî ko'mamî'pî Betânia pata po, manni' Maria, Marta ko'manto' ya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Manni' Maria itenaru, mîîkîrî Jesus puu karapaimatîpon kara' ke moropai i'pu ya'mananîpî'pîiya tîpu'pai si'po ke. Mîîkîrî pii enasa' wanî'pî pri'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro yenaru'tononya tîmaimukon yarima'pî Jesus pia. —Anna yepotorî, tone' anna pii man pri'ya pra, ani'nînma manni' —kai'ma tîmaimukon yarima'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus pia itekare yarî'pî to'ya. Mîrîrî eta tîuya pe Jesusya ta'pî tînenupa'san pî': —Aasa'mantato'pe eeseparantîsa' pepîn mîrîrî. Eeseparantîsa' meruntî ke Paapa wanî epu'to'pe tamî'nawîronkonya, moropai morî pe pu'kuru inmu wanî epu'to'pe to'ya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kure'ne Lázaro pînînma'pî Jesusya. Moropai itenaru'tonon pînînma'pîiya nîrî, Marta moropai itakon. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pri'ya pra Lázaro wanî yekare eta tîpo, Jesus ko'mamî'pî asakî'ne wei. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mîrîrî tîpo tînenupa'san pî' ta'pîiya: —Aase'nîkon see Judéia pata pona inî'rî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mîrîrî pî' inenupa'sanya ta'pî: —Anna yenupanen, amen awî yu'se Judeuyamî' esanon wanî'pî tî' ke Judéia po. Inî'rî itîîpai awanî ka'rî to' kore'ta? ");
INSERT INTO mbcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Panton pe to' maimu yuuku'pî Jesusya. Ta'pîiya: —A'ka pe awanî wei epa'ka pata pai eewomî pîkîrî. A'ka pe awanî tanne asanî ya atare'mon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ewaron ya' pata era'ma pepîn uweiyukon ton pra awanî ya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mîrîrî taa tîpo inî'rî Jesusya ta'pî to' pî': —Uyonpakon Lázaro we'nannî pî' man, tîîse iipia uutî ikurantanî'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Inenupa'sanya ta'pî: —Uyepotorî, morî pe iwe'nasa' ya, eesepi'tî pia'tîsa' mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro erî'kapî kai'ma to' esenumenkasa' mîrîrî, tîîse Lázaro sa'mantasa' pî' Jesus eseurîma kinî tanne. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mîrîrî ye'nen aronne Jesusya ta'pî to' pî': —Lázaro sa'mantasa' man. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Uwakîri pe iipia e'sa' pra wai, mîrîrî wenai inî' panpî' innape ukupîya'nîkon kupî sîrîrî. Iipia wîtînpai'nîkon. Aase'nîkon see —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Moropai Tomé tiaron itese' monoi'ya ta'pî tonpayamî' pî': —Aase'nîkon see ipîkîrî sa'mantai wîtîn ipokonpe —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","To' wîtî'pî. Moropai to' erepamî'pî Betânia pona. Aasîrî Lázaro nurî'tî yu'na'tîsa' to'ya wanî'pî asakîrîrî wei kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aminke pra Betânia wanî'pî Jerusalém cidaderî pî', 3 km. kaisarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mîrîrî ye'nen arinîkon Judeuyamî' wîtî'pî Marta, Maria pia to' pîika'tîi, to' pirankon sa'mantasa' ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus erepansa' yekare eta tîuya pe Marta epa'ka'pî iipia. Tîîse Maria e'nîmî'pî wîttî ta. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ta'pî Martaya Jesus pî': —Uyenupanen, tarî awe'sa' ya, piipi' sa'manta'pî pepîn e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mîrîrî epu'tî pî' wai, sîrîrî pu'kuru î' rî esatîya ya Paapa pî' itîrîiya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusya ta'pî ipî': —Api e'mî'sa'ka pe man. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaya ta'pî: —Epu'tî pî' wai. Tiwinano'pî wei yai, isa'manta'san kore'tapai apemonkonoyamî' e'mî'sa'ka yai, piipi' nîrî e'mî'sa'ka. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesusya ta'pî: —Uurî e'mî'sa'kanto' moropai enen ko'mannîto'. Innape uku'nen sa'mantasa' ya, mîîkîrî ennapamî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Moropai enenankon innape uku'nenan ko'mamî enen ipatîkarî. Innape awanî epu'tî pî' nan? —ta'pî Jesusya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Inna uyepotorî —ta'pîiya. —Paapa nîmenka'pî amîrî. Paapa munmu amîrî, manni' ka' poi aaipî ton tarîwaya. Innape akupî pî' wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mîrîrî taa tîpo awenna'po'pî wîttî ta takon Maria yannoi. Ta'pîiya Maria pî': —Uyenupanenkon erepannî pî' man. Ayanno pî' man —ta'pîiya ipî' ama' pe, tiaronkonya eta namai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mîrîrî eta tîuya pe Maria epa'ka'pî ka'ne' pe Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Poro po Jesus wanî'pî aminke mararî to' ko'manto' pî', Marta yarakkîrî teeseporî'pî pata'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ka'ne' pe Maria epa'ka era'ma tîuya'nîkon pe Judeuyamî' iipia ereuta'san ipîika'tînenan pe wîtî'pî ipîkîrî. —A'kî —ta'pî to'ya, —Uuruwai pona attî moro esewankono'mai ikarunse. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesus pia teerepamî pe Maria esenumî'pî. Moropai ta'pîiya: —Uyepotorî, tarî awe'sa' ya, piipi' sa'manta'pî pepîn e'painon. Ikarawa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria moropai Judeuyamî' Maria yarakkîronkon karau era'ma tîuya pe Jesus esewankono'ma'pî tewan ya. Kure'ne eesewankono'ma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta'pîiya to' pî': —O'non pata yu'na'tî'pîya'nîkon? Aase era'mapî'se, Uyepotorî —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus karawa'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mîrîrî pî' Judeuyamî'ya ta'pî: —A'kî, kure'ne isa'manta'pî pînînmaiya era'makî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tîîse tiaronkonya ta'pî: —Enkaru'nan yenu konekatîpon mîserî warayo'. Î' wani' awanî ye'nen isa'manta'pî pîika'tîiya pra awanî'pî mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Inî'rî Jesus esewankono'ma'pî tewan ya'. Eerepamî'pî uuruwai pia. A'ta pe awanî'pî tî' yai moropai itettapuru wanî'pî tî' pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesusya ta'pî: —Itettapuru mo'katî. Isa'manta'pî yenaru Martaya ta'pî: —Uyepotorî, ikî pe aakatasa' sîrîrî. Asakîrîrî wei kaisarî aako'mansa' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusya ta'pî ipî': —Aasîrî taa pî' wai apî' innape ukupîya ya, Paapa meruntîri era'maya, innape nai? ");
INSERT INTO mbcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mîrîrî uuruwai yettapurîka'pî to'ya. Moropai ka' tera'ma ye'ka pe Jesus epîrema'pî. —Paapa —ta'pîiya, —Uwakîri pe umaimu eta pî' nai. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tîwîrî rî umaimu etanen amîrî. Epu'tî pî' wai. Tîîse uwoi to' mannan wanî epu'tî to'ya pra. Anarima'pî pe wanî epu'to'pe to'ya, taa pî' wai apî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mîrîrî taa tîpo, awentaime'pî aronne: —Lázaro, epa'kakî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mîrîrîya isa'manta'pî epa'ka'pî satippe. Yaironpî'sa' pe awanî'pî, itenya moropai i'pu pîkîrî, isa'manta'pî yaironto' kamisa ke. Itenpata yettapusa' wanî'pî nîrî kamisa ke. Jesusya ta'pî: —Yeukatî. Moropai yeuka'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Arinîkon Judeuyamî' Maria pia iipî'sanya Jesus nîkoneka'pî era'ma'pî. Mîrîrî wenai innape ikupî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tîîse tiaronkon epa'ka'pî. Fariseuyamî' pia to' wîtî'pî. Jesus nîkoneka'pî ekaremekî'pî to'ya fariseuyamî' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fariseuyamî' moropai teepîremasanon esanon eperepî'pî Judeuyamî' panamanenan yarakkîrî Jesus pî' eseurîmai. Ta'pî to'ya: —O'non ye'ka pe ikupî eserîkan pepîn ku'sa' Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tîwî ikupî ya tamî'nawîronkonya innape ikupî tesa'kon pe. Moropai mîrîrî wenai Romanoyamî' iipî. Umeruntîrikon mo'ka to'ya. Epîremanto' yewî' soroka to'ya. Moropai upemonkonokon mo'ka to'ya. Î' kupî e'pai awanî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Moropai Caifás eseurîma'pî. Mîîkîrî wanî'pî teepîremasanon esanon yepotorî pe mîrîrî kono' pî'. Mîîkîrî eseurîma'pî: —Epu'nenan pepîn amîrî'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—Eesenumenkasa'kon pra naatîi. Jesus sa'manta e'pai man. Tiwinan sa'manta e'pai awanî tamî'nawîronkon ton pe, Romanoyamî'ya utî'kakon namai iwenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tîîwarîrî teeseurîma kai'ma eesenumenka'pî. Tîîse teepîremasanon esanon yepotorî pe awanî ye'nen, Paapaya tîmaimu tîrî'pî mîrîrî iipia. Tamî'nawîronkon Judeuyamî' ton pe Jesus sa'manta kupî ekaremekî'pîiya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Moropai teken Judeuyamî' ton pe aasa'manta pepîn mîrîrî, tîîse pata kaisaronkon ton pe. Paapa munkî pe tîwe'sanon e'paraipîka'san muurukuntî Jesusya kupî sîrîrî, tîîpia tiwinan warantî to' e'to'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Moropai mîrîrî warantî Caifás eseurîma tîpo, Judeuyamî' eseka'nunka'pî Jesus wîî yu'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mîrîrî epu'tî tîuya ye'nen Jesus asarî pra eena'pî aronne Judeuyamî' kore'ta. Attî'pî Jerusalém poi keren rî'pîkîron pata pona itese' Efraim. Moro aako'mamî'pî tînenupa'san pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judeuyamî' epere'to' weiyu wanî'pî aminke pra, itese' Páscoa. Mîrîrî pî' enpen tîwanîkon ye'nen arinîkon wîtî'pî Jerusalém pona irawîrî ikonekai, Moisés nurî'tîya yenupanto' yawîrî. Imakui'pî pe teenasa'kon ye'nen to' wîtî'pî e'ronai teserukon yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesus yuwa'pî to'ya moro, tîîse eporî to'ya pra awanî'pî. Ipî' to' eseurîma'pî. —Aaipî pepîn ka'rî —kai'ma to' eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseuyamî' moropai teepîremasanon esanonya tîmaimukon yenpa'ka'pî. O'non pata Jesus ko'mamî epu'nen wanî ya, ekareme'to'peiya, yapisîkonpa kai'ma. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tiwin mia' pona tîîmo'tai wei kaisarî Páscoa weiyu rawîrî, Jesus wîtî'pî Betânia pona Lázaro ko'manto' ya'. Manni' isa'manta'pî pîmî'sa'ka'pî tîuya ko'manto' ya' attî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Entamo'kanto' koneka'pî to'ya moro Jesus ton pe. Marta esenyaka'ma'pî to' yekkari ton pî' moropai Lázaro ereuta'pî tiaronkon pokonpe Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariaya kara' yapisî'pî, morî epe'ke itese' nardo. Jesus puu karapaima'pîiya mîrîrî ke. Mîrîrî tîpo i'pu ya'mananîpî'pîiya tîpu'pai si'po ke. Ipîra kara'pî kin a'pusin pe awanî'pî wîttî ta pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mîrîrî pî' inenupa'pî itese' Judas Iscariotes eseurîma'pî. Teyatonkon pî' Jesus ekaremekîton mîîkîrî. Mîîkîrî eseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Î' wani' awanî ye'nen mîrîrî kara' ke awe'repa pra awanî? —ta'pîiya. —Kure'ne tîniru, tiwin kono' kaisarî esenyaka'man yepe' kaisarî ye'ma'pî to'ya e'painon tîniru ke. Mîrîrî tîîpîtî e'painon î' ton pînon pia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tîîse iseruku mîrîrî. Î' ton pînon pî' eesenumenka pepîn. Tîmîrî ton pe itu'se awanî'pî maasa pra ama'ye' pe tîwanî ye'nen. Jesus nenupa'san tînirurî yense' yaanen pe tîwe'sen pe tîwanî ye'nen imo'kapîtî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","—Tîwî Maria nîsi —ta'pî Jesusya. —Uusa'manta kupî sîrîrî. Mîrîrî ton pe ukarapaimasai'ya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Î' ton pînon man arinîke pu'kuru. Sîrîrî non po to' e'tî'ka pepîn tamî'nawîrî. Tîîse uurî, uutî kupî sîrîrî aapiapai'nîkon —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betânia po Jesus wanî epu'tî'pî arinîkon Judeuyamî'ya. Mîrîrî ye'nen to' wîtî'pî Jesus era'mapî'se moropai isa'manta'pî e'mî'sa'kasa' pî' esenumenkai. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mîrîrî ye'nen teepîremasanon esanon wanî'pî Lázaro wîî yu'se. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Maasa pra iwenai arinîkon Judeuyamî'ya Jesus kupî'pî innape epu'tî tîuya'nîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Arinîkon pemonkonyamî' epere'sa' wanî'pî festa pî' tîwanîkonpa kai'ma Jerusalém pona. Jesus iipî epu'tî tîuya'nîkon pe iponaya to' wîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yu' yare maripa ye' warainon yarî'pî to'ya. Aaipî era'ma tîuya'nîkon pe to' entaimepîtî pia'tî'pî. —Morî pe man —taa pia'tî'pî to'ya. —Morî mîserî, yepuru wanî, Paapa uyepotorîkon naipontî'pî, Israel ponkon yepotorî pe, —taapîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Moropai Jesusya tekîn ton yeporî'pî jumenta more. Ipona eenuku'pî, Paapa maimu e'menukasa' yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","See warantî awe'menukasa' wanî'pî: Teesi'nî'se pra e'tî, Paapa pemonkonoyamî' Sião ponkon, a'kî, ayesa'kon iipî pe man jumenta more po ˻penaronkon ayesa'kon reiyamî' warantî˼ kai'ma Paapa maimu e'menukasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tîîse mîrîrî yawîrî Jesus wanî epu'tî inenupa'sanya pra awanî'pî. Jesus sa'manta'pî moropai awe'mî'sa'kasa' tîpo neken to' enpenata'pî penaronkon nekaremekî'pî pî'. Moropai mîrîrî yai neken innape mîrîrî yawîrî Jesus wanî'pî epu'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Moropai arinîkon pemonkonyamî', manni'kan isa'manta'pî Lázaro pîmî'sa'ka Jesusya era'ma'tîponkon eseurîma ko'mannîpî'pî inkoneka'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mîrîrî wenai tiaronkon epa'ka'pî Jerusalém yapai Jesus epose isa'manta'pî pemonkon pîmî'sa'kasai'ya etasa' tîuya'nîkon ye'nen. Arinîke to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Moropai mîrîrî pî' fariseuyamî' esenumenka'pî tonpayamî' pokonpe. —A'kî, î' ku'sa' pra man —ta'pî to'ya. —Tamî'nawîronkon wîtîn pî' man iipia, uurî'nîkon ton pra. Moropai innape iku'sa' to'ya mîrîrî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Judeuyamî' festarî pî' tîwanîkonpa tiaronkon gregoyamî' ii'sa' wanî'pî Jerusalém pona nîrî Judeuyamî' yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Insanan wîtî'pî eseurîmai Filipe yarakkîrî. Mîîkîrî Filipe wanî'pî Galiléia pata yawon Betsaida cidaderî poinon. Mîîkîrî pia to' wîtî'pî. —Jesus anera'mapai anna wanî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","To' nesatî'pî ekaremekî'pî Filipeya André pî' moropai sa'nîrî to' wîtî'pî ekareme'se Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Moropai Jesusya ta'pî to' pî': —Inna, maasa pra uweiyu erepansa' man. Uurî ka' poi iipî'pî pemonkon pe yapurî Judeuyamî' pepînya kupî sîrîrî. Maasa pra ipîkku pe Paapaya uyenpo kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ayenku'tîuya pepîn. Trigo yena'pî yu'na'tîsa' pra awanî ya, tiwinsarî aako'mamî. Tîîse yu'na'tîsa' ya, moropai ipi'pî katasa' ya, moropai aaro'tasa' ya, kure'ne itîrîiya e'painon. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mîrîrî warantî sîrîrî non po ko'mannîto' pînînma ya tîwîrî e'tî'kan. Tîîse sîrîrî non po ko'mannîto' ti'nînmai pra ka' po ipatîkarî ko'mannîto' eporî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Upoitîrî pe e'pai anî' wanî ya, uwenairî aaipî e'pai awanî. Uuko'manto' ya' upoitîrî ko'mamî nîrî. Upoitîrî pe anî' esenyaka'masa' ya, uyunya nîrî yapurî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesus eseurîma ko'mannîpî'pî: —Uyekaton esewankono'man pî' man. Î' tauya e'painon? Paapa, umo'kakî e'taruma'tîto' winîpai tauya pepîn maasa pra sîrîrî warantî e'taruma'tîi iipî'pî uurî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paapa, ayese' yapurîto'pe tamî'nawîronkonya iku'kî —ta'pî Jesusya. Moropai mai eseta'pî ka' poi. —Aasîrî morî pe uyese' yapurî to'ya awenai moropai inî' panpî' yapurîto'pe to'ya ikupîuya pe wai —ta'pî maiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Moropai arinîkon Jesus piawonkonya eta'pî mai eseurîma. Mîrîrî ye'nen tiaronkonya ta'pî: —Wara'napi pe man. Moropai tiaronkonya ta'pî: —Inserî eseurîman pî' man yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesusya ta'pî to' pî': —Uurî wenai Paapa eseurîmasa' pra man, tîîse eeseurîmasa' amîrî'nîkon ton pe innape ukupîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sîrîrî non po tîîko'mansenon yeseru imakui'pî pe taruma'tîto' weiyu erepansa' man. Moropai sîrîrî imakui'pî yepotorî yenpa'ka Paapaya pe man. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pakî'nan pona u'mî'sa'ka to'ya pe man tîpokapî'se moropai mîrîrî wenai uupia tamî'nawîronkon enepîuya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O'non ye'ka pe tîwî to'ya ekaremekîiya mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tiaronkonya ta'pî ipî': —Paapa kaaretarî po eeseporî ipatîkarî Cristo ko'mamî kai'ma. Tîîse amîrîya taa, “Uurî ka' poi iipî'pî pemonkon pe sa'manta kupî sîrîrî pakî'nan po”. Anî' see amîrî, moriya? —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesusya ta'pî to' pî': —A'kaya aye'marîkon weiyu'ma ko'mannîpî mararî. Innape iku'kî sîrîrî ewaron ya', aataka'makon namai. Ewaron ya' eenakon ya, o'non pata attîkon epu'tîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tarî wanî tanne aweiyu'manenkon pe innape uku'tî upemonkono pe awanîkonpa, a'ka ta tîîko'mansenon pe awanîkonpa, Paapa epu'nenan pe. Mîrîrî taa yaretî'ka tîuya pe, Jesus wîtî'pî to' piapai moropai eesenomî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tamî'nawîrî mîrîrî ekoneka eserîkan pepîn koneka'pîiya to' nera'makon tonpe. Mîîwîni tîîse innape ikupî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mîrîrî warantî awanî'pî Isaías nurî'tî nîmenuka'pî yawîrî. Pena Isaías nurî'tîya ta'pî: Uyepotorî, anî'ya innape unekaremekî'pîkon ku'sa' pra man. Tîmeruntîri yenposa' Paapaya, tîîse ikupî to'ya pra man innape ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Innape ikupî to'ya eserîke pra awanî'pî. Maasa pra Paapaya to' yenu yenkaru'nannîpî'pî Isaías nurî'tîya ta'pî yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Paapaya to' yenu yenkaru'nannîpî'pî. Moropai to' yewan sa'mannî'sai'ya. Mîrîrî kupî'pîiya era'ma to'ya namai tenukon ke. Moropai epu'tî to'ya namai tewankon ya'. Moropai imakui'pî poi to' era'tî namai moropai to' yepi'tîuya pepîn. ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mîrîrî warantî Isaías nurî'tî eseurîma'pî maasa pra ipîkku pe Cristo e'to' yenpo'pî Paapaya ipî'. Jesus Cristo pî' eeseurîma'pî pena. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mîîwîni tîîse arinîkon Judeuyamî' esanonya innape Jesus kupî'pî Paapa nîmenka'pî pe awanî. Tîîse aronne to' esekaremekî pra awanî'pî fariseuyamî'ya tenpa'kakon namai, teepere'to'kon yewî' tapai. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Maasa pra tonpakonya tapurîkon yu'se to' wanî'pî Paapaya tapurîkon yu'se tîwanîkon yentai. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Moropai Jesus entaime'pî: —Innape uku'nen wanî ya, uyarimatîpon kupîiya nîrî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Uyera'maiya ya, uyarimatîpon era'maiya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Pemonkonyamî' weiyu'manen pe uui'sa' sîrîrî non pona Paapa epu'to'pe to'ya. Moropai innape uku'nen ko'mamî namai ewaron ta, Paapa tepu'se pra uui'sa' sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Umaimu etanen wanî ya, yawîrî pra aako'mamî tîîse, mîîkîrî yenumîuya pepîn. Maasa pra pemonkonyamî' taruma'tîi uui'sa' pra wai, tîîse to' pîika'tîi uuipî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tîîse anî'ya taasa' ya, ayu'se pra wai, moropai umaimu kupîiya pra wanî ya innape, yapisîiya pra awanî ya, taruma'tîton moro man. Mîrîrî wanî umaimu, eseurîma'pî manni'ya taruma'tî pe man tiwinano'pî wei yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uuwarîrî eseurîmasa' pra wai. Paapa, uyarimatîponya upanama'pî. “See warantî neken meseurîmai” ta'pîiya upî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Moropai epu'tî pî' wai imaimuya ipatîkarî pemonkon ko'manto' ton ekaremekî. Mîrîrî ye'nen eseurîma ya, Paapa nekaremekî'pî neken upî' ekaremekîuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Moropai entamo'kanto' rawîrî Páscoa itese' Jesusya tîweiyu erepansa' epu'tî'pî. Sîrîrî non poi tuutî Paapa pia epu'tî'pîiya. Tîpemonkonoyamî' sîrîrî non ponkon sa'nama'pîtî'pîiya moropai sîrîrî î' kai'ma inkamoro sa'nama tîuya yenpo'pîiya tîîsa'manta pîkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus wanî'pî tînenupa'san pokonpe entamo'kanto' pî'. Makuiya teesenumenkato' tîîsa' wanî'pî Judas pia, Simão Iscariotes munmu pia. Teyatonon pî' Jesus ekaremekî pî' eesenumenka emapu'tî'pî Makuiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Moropai Jesusya epu'tî'pî tunya tamî'nawîron rumakasa' tenya'. Moropai tuipî'pî Paapa piapai epu'tî'pîiya. Paapa pia tîwenna'po kupî epu'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tamî'nawîrî mîrîrî epu'tî tîuya pe Jesus e'mî'sa'ka'pî, tîpon mo'ka'pîiya, moropai ta'san yewa'tî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mîrîrî tîpo tuna kamo'pîiya pisa ya' moropai tînenupa'san puu rona pia'tî'pîiya moropai ya'mananîpî'pîiya ta'san yewa'tîsa' ke. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Moropai Simão Pedro pia eerepansa' ya, Pedroya ta'pî ipî': —Uyepotorî, u'pu ronaya mîrîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusya yuuku'pî: —Unkupî epu'tîya pra awanî sîrîrî tîîse maasa epu'tîya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedroya ta'pî: —Kane, kane, amîrîya u'pu ronaya e'pai pra man —ta'pîiya. —A'pu ronauya tîrîya pra awanî ya, upemonkono pe awanî pepîn tarîpai —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mîrîrî pî' Simão Pedroya ta'pî: —Uyepotorî, moriya u'pu neken kî'ronai tîîse uyenya, upu'pai nîrî ronakî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesusya ta'pî: —Tîwe'pîsen wanî nura pe pra, inî'rî awe'pî pepîn tî'pu neken ronaiya. Amîrî'nîkon wanî e'pîsanon warantî morî pe, nura pe pra, tîîse tiwinan man imakui'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jesusya epu'tî'pî anî'ya tekaremekî teyatonon pî'. Mîrîrî ye'nen ta'pîiya mîrîrî tiwinan man imakui'pî pe.) ");
INSERT INTO mbcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesusya to' puu rona tîpo, tîpon yeka'ma'pîiya moropai eereuta'pî inî'rî tîpata'pî ya'. Moropai to' pî' ta'pîiya: —Î' ku'sau'ya apî'nîkon epu'tî pî' naatî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—Anna yenupanen, anna yepotorî taa pî' naatîi upî'. Yairî man maasa pra ayepotorîkon pe wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tîîse uurîya, ayepotorîkonya, ayenupanenkonya a'pukon rona pî' man. Mîrîrî warantî ayonpakon puu ronaya'nîkon e'pai awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Anera'matonkon tîrî pî' wai aapia'nîkon, iku'sau'ya warantî ikupîkonpa, ayonpakon yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ayenku'tîuya pepîn, ipoitîrî wanî pepîn tîkaraiwarî yentai. Moropai inarima'pî wanî pepîn tarima'tîpon yentai. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mîrîrî epu'tî pî' naatîi tarîpai. Mîrîrî yawîrî ikupîya'nîkon ya, taatausinpai aako'mamîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Tamî'nawîronkon amîrî'nîkon pî' eseurîma pra wai. Unmenka'san epu'tî pî' wai. Tîîse Paapa kaaretarî e'menukasa' yairî e'pai awanî. See warantî awe'menukasa': Warayo' uyarakkîrî tekkari enapîtîpon enasa' uyeyaton pe. Mîrîrî warantî awe'menukasa' mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","—Mîrîrî ekaremekîuya sîrîrî apî'nîkon awe'kupî pra tîîse. Awe'ku'sa' ya, innape ukupîkonpa anî' pe wanî ta'pîuya manni'. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yairî tauya sîrîrî. Morî pe anî' unarima'pî yapisîtîpon wanî ya, uurî pu'kuru yapisîiya moropai uyapisîtîponya uyarima'tîpon yapisî nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mîrîrî taa tîpo, kure'ne Jesus esewankono'ma'pî moropai aronne ta'pîiya: —Innape taa pî' wai. Tiwinan amîrî'nîkon kore'tawonya uyekaremekî kupî sîrîrî uyeyatontonon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mîrîrî pî' inenupa'san esera'ma'pî, anî' pî' taiya epu'tî to'ya pra awanî'pî. Mîrîrî pî' to' esenumenka'pî kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tiwin inenupa'pî Jesus nîsa'nama ereutasa' wanî'pî Jesus pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mîîkîrî pî' Simão Pedro esenpinîku'pî, anî' pe awanî ekareme'to'pe Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mîrîrî ye'nen aminke pra awe'rennuku'pî Jesus pia moropai ta'pîiya: —Uyepotorî, anî' pe nai? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusya yuuku'pî: —Manni' uyu kipîuya moropai iipia tîrîuya, mîîkîrî —ta'pîiya. Moropai tiyu yapisî'pîiya moropai ikipî'pîiya tuma ka, itîrî'pîiya Judas pia, Simão Iscariotes munmu pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Moropai Judasya yapisî'pî. Mîrîrî yapisîiya tanne Makui ewomî'pî ya'. Jesusya ta'pî Judas pî': —Ankoneka konekata teesemi'tapai. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tiaronkon iipiawonkonya epu'tî pra awanî'pî, î' taiya pe awanî epu'tî to'ya pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tiaronkon esenumenka'pî. Jesus moropai ipemonkonoyamî' tînirurî yense' yaanen pe Judas wanî epu'tî'pî to'ya. Mîrîrî ye'nen Jesusya ekaremekî'pî attîto'pe festa yemanne ton yennai ou î' ton pînon pia tîniru tîîto'peiya kai'ma tiaronkon esenumenka'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Moropai tiyu yapisî tîpo, Judas epa'ka'pî ka'ne' pe to' kore'tapai. Moropai ewaron pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas epa'ka pe, Jesusya ta'pî: —Tarîpai ka' poi iipî'pî pemonkon pe, uurî yapurî pî' pemonkonyamî' man. Moropai Paapa yapurî pî' pemonkonyamî' man uurî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Moropai Paapa yapurî to'ya ya, uurî ekaremekî Paapaya tamî'nawîronkon pî', morî pe wanî ekaremekîiya kupî sîrîrî tîîwarîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Unmukuyamî', aapia'nîkon tîko'man pe uuko'mamî pepîn. Uyuwaya'nîkon kupî sîrîrî, tîîse tauya apî'nîkon. Judeuyamî' esanon pî' unekaremekî'pî, mîrîrî ekaremekîuya sîrîrî apî'nîkon. O'non pata uutî ya, attîkon eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Moropai amenan ankupîkon ton ekaremekîuya sîrîrî. Ayonpakon sa'namatî. Asa'nama'pîuya'nîkon warantî to' sa'namatî. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ayonpakon sa'namaya'nîkon ya, upemonkonoyamî' pe awanîkon epu'tî tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simão Pedroya ta'pî ipî': —Uyepotorî, o'non pata pona attî mîrîrî? —ta'pîiya. Jesusya yuuku'pî: —Upîkîrî attî eserîke pra awanî o'non pata uutî ya. Tîîse maasa uwenairî attî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Uyepotorî, î' wani' awanî ye'nen awenairî uutî eserîke pra awanî? —ta'pî Pedroya. —Amîrî ton pe uusa'manta eserîke wanî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesusya yuuku'pî: —Innape nai? Uurî ton pe naka aasa'manta? Ayenku'tîuya pepîn. Kariwana yunkon etun rawîrî, “Unepu'tî pepîn mîîkîrî”, taaya kupî sîrîrî. Eseurîwî'ne ite'ka taaya kupî sîrîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Moropai Jesusya ta'pî tînenupa'san pî': —Teesewankono'mai pra e'tî. Aasîrî innape Paapa kupî pî' naatîi. Uurî nîrî ku'tî innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Maasa pra tu'ke ko'mannîto' moro man Uyun yewî' ta. Î' ton pra awanî ya, tauya nîrî e'painon. Tîîse uutî sîrîrî aako'manto'kon ton konekai. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Moropai amîrî'nîkon ton pe ikonekasau'ya ya, uuipî inî'rî amîrî'nîkon era'mai, uupia aako'mamîkonpa. O'non pata uuko'mamî ya, miarî nîrî uupia aako'mamîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","O'non pata uutîto' epu'tî pî' naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mîrîrîya Toméya ta'pî Jesus pî': —Uyepotorî, o'non pata pona attî epu'tî annaya pra man. O'non ye'ka pe wîtînto', e'ma epu'to'pe annaya? ");
INSERT INTO mbcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesusya yuuku'pî. —Uurî e'ma, innarî, moropai ko'mannîto'. Anî' wîtî pepîn Paapa pia tîwî uurî tîku'se —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","—Innape uyepu'tîya'nîkon ya, Uyun nîrî epu'tîya'nîkon. Moropai sîrîrî pata pai innape Paapa epu'tîya'nîkon. Maasa pra aasîrî Mîîkîrî era'masa'ya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipeya ta'pî Jesus pî': —Uyepotorî, era'mato'pe annaya Paapa yenpokî. Mîrîrî neken yu'se anna man. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusya ta'pî: —Pena pata pai uurî wanî aapia'nîkon. Mîîwîni tîîse Filipe, uyepu'tîya pra nan? Filipe, anî'ya uyera'masa' ya, Paapa nîrî era'masai'ya. Mîrîrî ye'nen î' ton pe Paapa yenpokî taaya manni'? ");
INSERT INTO mbcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Paapa ya' uurî wanî moropai uurî ya' Paapa wanî kupîya pra nan innape? —ta'pîiya Filipe pî'. Moropai tînenupa'san pî' ta'pîiya: —Mîrîrî tauya manni' uwinîpainon pepîn, tîîse Paapa, uupia tîîko'mansenya itu'se tîwe'to' kupî uurî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Paapa ya' uurî wanî moropai uya' Paapa wanî tauya manni' ku'tî innape. Tîîse sa'me awanî ye'nen innape mîrîrî kupîya'nîkon pra awanî ya, innape uku'tî unkupî wenai. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ayenku'tîuya pepîn. Anî'ya innape ukupî ya, unkupî'pî warantî ikupîiya. Moropai unkupî'pî yentai ikupîiya maasa pra Paapa pia uutî kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mîrîrî wenai umaimu pe î' rî anesatîkon tîrîuya aapia'nîkon. Mîrîrî ye'nen uurî wenai morî pe Paapa yapurî tu'ke pemonkonyamî'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Moropai tauya inî'rî umaimu pe î' rî anesatîkon, mîrîrî kupîuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","U'nînmaya'nîkon ya ayaipontîtou'ya'nîkon yawîrî ako'mantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Moropai Paapa pî' esatîuya sîrîrî, apanamanenkon ton tiaron, yairon pî' teeseurîmasen yarimato'peiya aapia'nîkon aako'manto'pe ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sîrîrî non po tîîko'mansenonya mîîkîrî yapisî eserîke pra awanî maasa pra era'ma to'ya eserîke pra awanî, epu'tî to'ya pepîn. Tîîse amîrî'nîkonya epu'tî maasa pra aako'mamî apokonpe'nîkon, ayewankon ya' awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Uutî ya, tiwinsarî awe'nîmîkon pepîn aako'mannî'nenkon ton pra, tîîse inî'rî enna'po kupî sîrîrî aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Maasa mararî sîrîrî pata po tîîko'mansenonya uyera'ma pepîn inî'rî. Tîîse amîrî'nîkonya inî'rî uyera'ma kupî sîrîrî. Moropai inî'rî enen uuko'mamî ye'nen, amîrî'nîkon ko'mamî nîrî enen ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mîrîrî wei yai, Paapa pia uuko'mamî epu'tîya'nîkon kupî sîrîrî. Moropai uya' aako'mamîkon, amîrî'nîkon ya' uuko'mamî warantî. Tiwin e'nî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Anî' unekaremekî'pî yapisîtîpon, moropai mîrîrî unekaremekî'pî yawîron, mîîkîrî u'nînmanen. Mîîkîrî u'nînmanen sa'nama uyunya. Uurîya nîrî isa'nama moropai iipia uuipî, esekaremekî uyepu'to'peiya, ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mîrîrîya ta'pî Judasya. (Mîîkîrî Judas Iscariotes pepînya, tiaron) Mîîkîrîya ta'pî Jesus pî': —Uyepotorî, o'non ye'ka pe anna pia aaipî tîîse tamî'nawîronkon pemonkonyamî' pia aaipî pepîn? ");
INSERT INTO mbcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusya yuuku'pî: —Anî'ya u'nînma ya, mîîkîrî ko'mamî unekaremekî'pî yawîrî. Uyunya isa'nama, moropai anna erepamî iipia moropai anna ko'mamî iipia —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","—Tîîse u'nînmanen pepîn ko'mamî pepîn unekaremekî'pî yawîrî. Mîrîrî unekaremekî'pî uwinîpainon pepîn tîîse Paapa winîpainon. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mîrîrî ekaremekî'pîuya akore'ta'nîkon wanî yai. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tîîse panamaton, Morî Yekaton Wannî, Paapa narimaton uyenta, mîîkîrîya amîrî'nîkon yenupa kupî sîrîrî tamî'nawîron pî'. Moropai tamî'nawîrî unekaremekî'pî pî' ayenpenatanîpîiya'nîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tîwanmîra awe'to'kon nîmîuya aapia'nîkon. Mîrîrî ke arepauya'nîkon. Mîrîrî untîrî sîrîrî non po tîîko'mansenon nîtîrî warainon pepîn. Mîrîrî ye'nen teesewankono'mai pra e'tî, eranne' pe pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uutî sîrîrî aapiapai'nîkon moropai inî'rî enna'po aapia'nîkon tauya eta pî' naatîi. U'nînmaya'nîkon ya, aatausinpakon e'painon. Maasa pra emikku sîrîrî uyun pia. Mîîkîrî uyun uyentainon. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mîrîrî ekaremekî pî' wai apî'nîkon uutî rawîrî. Mîrîrî yai uutî ya, innape ikupîkonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inî'rî kure'ne eseurîma eserîke pra wai amîrî'nîkon yarakkîrî. Maasa pra sîrîrî pata esa' iipî kupî sîrîrî. ˻Mîîkîrî Makui˼ uyentainon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tîîse î' rî taa Paapaya ya, mîrîrî kupîuya, Paapa yapurîuya epu'to'pe tamî'nawîronkon sîrîrî pata po tîîko'mansenonya. Aase'nîkon sîrîrî pata pai. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mîrîrî tîpo Jesusya ta'pî tînenupa'san pî': —Uurî wanî uva ye' warantî, yairon. Amîrî'nîkon wanî ipantakon warantî. Moropai Uyun wanî iko'mannî'nen warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mîîkîrî Uyunya tamî'nawîrî ipanta epetakoikon pepîn ya'tî moropai ipantakon mararî epetakoikon yapî'kaiya morî pe awe'to'pe, inî' panpî' eepetato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amîrî'nîkon wanî ipanta yapî'kasa' warantî maasa pra aasîrî amîrî'nîkon enasa' man morî pe, ayenupatou'ya'nîkon wenai. Imakui'pî ankupî'pîkon mo'kasa' Paapaya —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","—Ako'mantî uupia, moropai uuko'mamî aapia'nîkon. Irupukon pî' ipanta atapi'sa' pra awanî ya, eepeta pepîn. Tîîse aako'mamî ya irupukon pî' eepeta. Mîrîrî warantî amîrî'nîkon wanî. Upî' aako'mamîkon pra awanî ya, morî pe aako'mamîkon pepîn. Morî pe aako'mamîkon eserîke pra awanîkon, a'tu'mîra awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Uurî uva ye' warainon, amîrî'nîkon ipantakon warainokon. Anî' ko'mamî ya uupia, moropai iipia uuko'mamî ya, mîîkîrîya morî kupî kure'ne umeruntîri wenai. Tîîse uurî ton pra si'ma morî kupîiya eserîke pra awanî tiwin kin. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ipantakon imo'kasa' awa'pi'tasa' yannuku to'ya. Mîrîrî soroka to'ya apo' ya' aaranto'pe. Mîrîrî warantî anî' ko'mamî pra awanî ya uupia, mîîkîrî yenumî Paapaya pe man. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aako'mamîkon ya uupia moropai umaimu ko'mamî ya aapia'nîkon î' itu'se awe'to'kon esatîya'nîkon moropai yapisîya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kure'ne morî kupîya'nîkon ya, amîrî'nîkon wanî upemonkono pe epu'tî tamî'nawîronkonya. Moropai mîrîrî wenai taa to'ya, “Inna, morî pe Paapa man”, taa to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Uyunya u'nînma warantî amîrî'nîkon pînînmauya. Mîrîrî ye'nen ako'mantî uupia, a'nînmatou'ya'nîkon pî' aatausinpakonpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mîrîrî warantî unekaremekî'pî yawîrî aako'mamîkon ya, upî' aatarimakon pepîn. A'nînmatou'ya'nîkon pî' aako'mamîkon taatausinpai. Mîrîrî warantî uyun maimu yawîrî uuko'mamî ye'nen iipia uuko'mamî moropai u'nînmaiya pî' atausinpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mîrîrî ekaremekî pî' wai apî'nîkon aatausinpakonpa uurî atausinpasa' warantî, aatausinpato'kon e'to'pe mîîpîkîrî pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Unekaremekî'pî yawîrî iku'tî. Ayonpakon sa'namatî asa'namauya'nîkon manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Anî' sa'manta ya tonpa ton pe, mîîkîrî wanî tonpa sa'namanen pe kure'ne. Inî' panpî' tonpa sa'namatoi'ya ton pra awanî, mîrîrî yentainon. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Uyonpa pe pu'kuru awanîkon, umaimu yawîrî awanîkon ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Inî'rî upoitîrî tauya pepîn apî'nîkon maasa pra tîkaraiwarîya î' kupî epu'tî ipoitîrîya pepîn. Tîîse uyonpa pe pu'kuru awanîkon maasa pra tamî'nawîrî upî' Paapa nekaremekî'pî ekaremekî'pîuya apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Amîrî'nîkonya uurî menkasa' pra man. Tîîse uurîya amîrî'nîkon menka'pî. Moropai ayaipontî'pîuya'nîkon Paapa yeseru ekaremekîkonpa tamî'nawîronkon pî'. Moropai mîrîrî wenai morî pe to' ko'mamî ipatîkarî. Mîrîrî warantî awanîkon ya, î' rî anesatîkon tîrî Paapaya aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mîrîrî ye'nen ankupîkon ton ekaremekîuya sîrîrî. Ayonpakon sa'namatî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sîrîrî non po tîîko'mansenonya amîrî'nîkon kupî ya tewanmakon pe, mîrîrî warantî uurî kupî'pî to'ya e'mai' pe. Mîrîrî epu'tî pî' naatîi. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sîrîrî non po tîîko'mansenon yonpa pe awanîkon ya, asa'namakon to'ya e'painon, tîîse to' yonpa pe pra awanîkon maasa pra amo'ka'pîuya'nîkon to' kore'ta pai. Mîrîrî ye'nen tewanmakon pe amîrî'nîkon kupî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Unekaremekî'pî pî' enpenatatî. Ipoitîrî wanî pepîn tîkaraiwarî yentai. Mîrîrî warantî utaruma'tî to'ya ya, ataruma'tîkon to'ya nîrî. Umaimu yawîrî to' wanî ya, amaimukon yawîrî nîrî to' wanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tamî'nawîrî mîrîrî kupî to'ya uurî wenai. Maasa pra uyarima'tîpon, uyun epu'tî to'ya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uui'sa' pra awanî ya, moropai to' yarakkîrî eseurîmasa' pra awanî ya, imakui'pî pe tîwanîkon epu'tî to'ya pepîn e'painon. Tîîse epu'tî to'ya. Mîrîrî ye'nen, “Imakui'pî pe anna wanî epu'tî annaya pra man”, taa to'ya eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Anî'ya tewanma pe ukupî ya, Uyun nîrî kupîiya tewanma pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","To' kore'ta anî'ya ikupî eserîkan pepîn ku'sau'ya pra awanî ya, imakui'pî ku'sa' tîuya'nîkon epu'tî to'ya pepîn. Tîîse unkupî'pî era'ma'pî to'ya. Mîîwîni tîîse uurî moropai uyun ku'sa' to'ya tewanmakon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tîîse mîrîrî kupî'pî to'ya Paapa maimu e'menukasa' yawîrî to' e'to'pe. Pena Moisésya Paapa maimu menuka'pî see warantî: Î' rî kupîuya pîn to' winîkîi. Mîîwîni tîîse tewanmakon pe ukupî to'ya. taasai'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Panamaton iipî pe man. Mîîkîrî Yekaton Wannî, Innape teeseurîmasen, Paapa piapai tui'sen. Mîîkîrî yarimauya kupî sîrîrî Paapa piapai aapia'nîkon moropai uyeseru pî' ayenpenatanîpîiya'nîkon kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Moropai amîrî'nîkon nîrî eseurîma kupî sîrîrî uyeseru pî' maasa pra uyarakkîrî aako'manpîtî'pîkon ayenupakon pia'tî'pîuya pata pai sîrîrî tîpose. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Moropai Jesusya ta'pî to' pî': —Mîrîrî ekaremekî'pîuya apî'nîkon innape Paapa ku'to'ya'nîkon kupîya'nîkon namai tîwî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Teepere'to'kon yewî'kon tapai amîrî'nîkon yenpa'ka to'ya kupî sîrîrî. Moropai inî' panpî' ikupî to'ya. Maasa awî tîuya'nîkon yai, Paapa wakîri pe awanî kai'ma to' esenumenka kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mîrîrî warantî ataruma'tîkon to'ya kupî sîrîrî, maasa pra uurî moropai uyun epu'tî tîuya'nîkon pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aasîrî mîrîrî ekaremekî'pîuya apî'nîkon. Moropai mîrîrî koneka to'ya yai, awenpenatakon kupî sîrîrî. E'mai' pe upemonkono pe amîrî'nîkon ena pia'tîsa' pe mîrîrî ekaremekîuya pra wanî'pî. Maasa pra aapia'nîkon uurî wanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tîîse uutî kupî sîrîrî uyarima'tîpon pia. Mîîwîni tîîse uyekaranmapoya'nîkon pra naatîi. Anî'ya “O'non pata pona attî?” taa pra awanî, tiwin kin. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mîrîrî ekaremekîuya ye'nen, eesewankono'masa'kon kure'ne. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tîîse yairî tauya sîrîrî. Uutîsa' ya, morî pe awanî kupî sîrîrî aapia'nîkon. Uutîsa' pra awanî ya, panamatonkon iipî pepîn aapia'nîkon. Tîîse uutîsa' ya, mîîkîrî yarimauya aapia'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mîîkîrî iipî non po tîîko'mansenon pia. Aaipî ya, to' pî' ekaremekîiya. Imakui'pî pe to' wanî ekaremekîiya kupî sîrîrî. Moropai î' pe yairon wanî ekaremekîiya. Moropai Paapaya to' yenumî kupî ekaremekîiya kupî sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Moropai ekaremekîiya yairî pra to' wanî imakui'pî tînkupî'pî pî' maasa pra innape ukupî to'ya pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Moropai ekaremekîiya yairî pra to' esenumenka yairon pî'. Maasa pra ka' pona uutî, tarî uyera'maya'nîkon pepîn inî'rî. Mîrîrî yai Paapaya uyapisî morî pe, iwakîri pe. Mîrîrî wenai yairon pe wanî epu'tî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Moropai Paapaya imakui'pî taruma'tî ekaremekîiya maasa pra aasîrî Paapaya imakui'pî yepotorî, Makui, taruma'tî pe man. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Inî' panpî' anekareme'pai wai apî'nîkon tîîse sîrîrî yapîtanîpîya'nîkon pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tîîse Mîîkîrî, yairon pî' teeseurîmasen erepansa' ya, tamî'nawîrî yairon Paapa piapainon pî' ayenupaiya'nîkon. Tîîwarîrî eeseurîma pepîn tîîse tîneta'pî ekaremekîiya moropai awe'kupîton maasa ekaremekîiya nîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Uyapurîiya, maasa pra uwinîpainon tîneta'pî pî' eeseurîma. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tamî'nawîrî Paapa wanî manni' itesa' pe, uurî nîrî itesa' pe. Mîrîrî ye'nen tauya, uwinîpainon tînapisî'pî, aapia'nîkon itîrî Morî Yekaton Wannîya, unekaremekî ekaremekîiya apî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Maasa mararî tîîko'manse uyera'maya'nîkon pepîn moropai inî'rî mararî tîîko'manse tîpo uyera'maya'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mîrîrîya inenupa'san esekaranmapo'pî tîpî'nîkon: —Î' taiya pe awanî mîrîrî? “Maasa mararî uyera'maya'nîkon pepîn moropai inî' aako'mamîkon tîpo, uyera'maya'nîkon inî'rî,” ta'pîiya sa'rî. Moropai taiya nîrî: “Uutî uyun pia ye'nen uyera'maya'nîkon pepîn.” Î' taiya pe awanî? —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—Maasa mararî tîpo ta'pîiya sa'rî î' taiya pe awanî epu'tî pra man mîrîrî. Mîrîrî warantî to' eseurîma'pî tîîwarîrî'nîkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tîpî' anekaranmapopai to' wanî epu'tî'pî Jesusya. Mîrîrî ye'nen ta'pîiya to' pî': —Maasa mararî uyera'maya'nîkon pepîn taa pî' wai moropai inî'rî maasa uyera'maya'nîkon inî'rî taa pî' wai. Î' taiya pe awanî? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","—Innape taa pî' wai apî'nîkon. Akaraukon kupî sîrîrî tîîse non po tîîko'mansenon atausinpa. Eesewankono'makon tîîse mîrîrî eesewankono'mato'kon era'tî inî'rî aatausinpato'kon pe moropai aatausinpakon. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wîri' mîîkîrî tînre esenpo kupî ya, eesewankono'makoi. Maasa pra tîwe'taruma'tî weiyu eseposa' ye'nen. Tîîse tînre esenposa' tîpo, inî'rî tîwe'taruma'tîto' pî' awenpenata pepîn. Tîîse more esenposa' pî' aatausinpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mîrîrî warantî awanîkon. Esewankono'man pî' naatîi tîîse inî'rî ayera'mauya'nîkon moropai aatausinpakon kupî sîrîrî. Mîrîrî aatausinpato'kon mo'ka anî'ya eserîke pra awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mîrîrî yai uyekaranmapoya'nîkon pepîn. Ayenku'tîuya'nîkon pepîn. Î' rî anesatîkon Paapa pî' itîrîiya aapia'nîkon upemonkono pe awanîkon ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sîrîrî tîpo see Paapa pî' esatîya'nîkon pra awanîkon. Upemonkono pe si'ma esatî moropai yapisîya'nîkon. Mîrîrîya kure'ne aatausinpakon. Aatausinpato'kon wanî tîwîrî, mîîpîkîrî pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mîrîrî ekaremekî pî' wai panton pe, aronne pra. Tîîse maasa uweiyu eseporî kupî sîrîrî. Mîrîrî yai ekaremekîuya pepîn panton pe tîîse aronne ayekaremekîuya'nîkon Paapa pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mîrîrî weiyu yai, Paapa pî' esatîya'nîkon aawarîrî'nîkon uyese' yai upemonkono pe awanîkon ye'nen. Paapa pî' esatîuya pepîn amîrî'nîkon ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Maasa pra Paapaya asa'namakon. Asa'namaiya'nîkon maasa pra uyapurîya'nîkon ye'nen moropai innape ukupî'pîya'nîkon, Paapa winîpainon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Paapa piapai iipî'pî uurî, sîrîrî non pona. Moropai inî'rî sîrîrî non nîmîuya kupî sîrîrî. Enna'po kupî sîrîrî Paapa pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mîrîrî pî' inenupa'sanya ta'pî ipî': —Aronne eseurîman pî' nai tarîpai, panton pe pra —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","—Tamî'nawîron epu'tî pî' nai epu'tî pî' anna man tarîpai. Î' tiaronkon esenumenka epu'tî pî' nai ayekaranmapo to'ya pra tîîse. Mîrîrî wenai Paapa winîpaino pe awanî kupî pî' anna man innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusya to' maimu yuuku'pî: —Tarîpai innape naka ukupî pî' naatî? —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Maasa panpî' amîrî'nîkon e'tîrîka kupî sîrîrî. Maasa pu'kuru pra attîkon kupî sîrîrî ayewî'kon ta, unîmîya'nîkon kupî sîrîrî tiwinsarî. Mîîwîni tîîse tiwinsarî uuko'mamî pepîn maasa pra uyun wanî uupia. ");
INSERT INTO mbcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mîrîrî ekaremekî pî' wai tîîwanmîra awanîkonpa Paapa winîkîi, uponaron pe awanîkon ye'nen. Tarî sîrîrî non po imakui'pîya ataruma'tîkon, tîîse meruntî ke e'tî. Maasa pra imakui'pî yentai wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mîrîrî taa tîpo, Jesusya tenu yanumî'pî ka' yekaya. Moropai eepîrema'pî. Paapa pî' ta'pîiya: —Paapa, uweiyu eseposa' man. Ipîkku pe e'to' yenpokî, ipîkku pe awe'to' yenpoto'peuya. Morî pe pu'kuru awanî, meruntî ke awanî epu'to'pe tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tamî'nawîronkon pemonkonyamî' esa' pe ukupî'pîya. Ukupî'pîya antîrî'pî tîîto'peuya upemonkonoyamî' pia ipatîkarî to' ko'manto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sîrîrî enen ko'mannîto' ipatîkaron wanî amîrî epu'to'pe to'ya. Amîrî tiwinan Paapa, yairon, tiaron ton pîn. Moropai uurî Jesus Cristo epu'to'pe to'ya, anarima'pî sîrîrî non pona. Mîrîrî epu'tî to'ya ya, enen to' ko'mamî ipatîkarî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Esenyaka'mato' pe antîrî'pî aretî'ka'pîuya. Mîrîrî wenai meruntî ke awanî, morî pe awanî yenpo'pîuya tamî'nawîronkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Paapa, aapia wanî tanne morî, meruntî tîîkî uupia itîrî'pîya warantî moro aapia wanî yai, pata ekoneka pra tîîse. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Sîrîrî non po tîîko'mansenon kore'tapai apemonkonoyamî' mo'ka'pîya. Inkamoro tîrî'pîya uupia. To' pî' ayeseru ekaremekî'pîuya ayepu'to'pe to'ya. Moropai amaimu yawîrî to' e'sa' man. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tarîpai epu'sa' to'ya, tamî'nawîrî unekaremekî'pî, tamî'nawîrî unkupî'pî wanî awinîpaino pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Maasa pra upî' anekaremekî'pî ekaremekî pî' wai to' pî'. Moropai etasa' to'ya. Innape see awinîpainon pe wanî epu'tî to'ya. Moropai uyarima'pîya ku'sa' to'ya innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","To' pona epîrema sîrîrî maasa pra apemonkono pe to' wanî ye'nen. Tamî'nawîronkon non po tîîko'mansenon pona epîrema pepîn tîîse manni'kan antîrî'san neken pona epîrema. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tamî'nawîronkon upemonkonoyamî' wanî apemonkono pe moropai apemonkonoyamî' nîrî wanî upemonkono pe. Moropai inkamoro wenai morî pe pu'kuru wanî, meruntî ke wanî epu'tî tamî'nawîronkonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sîrîrî non po uuko'mamî pepîn inî'rî. Uutî kupî sîrîrî aapia. Tîîse inkamoro apemonkonoyamî' ko'mamî tarî. Paapa, morî anî' warainon pepîn, inkamoro ko'mannî'kî. Ameruntîri ke to' ko'mannî'kî, uupia tîîsa'ya manni' ke to' pîika'tîkî tiwin to' ko'manto'pe, tiwin ko'mannî manni' warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","To' yarakkîrî wanî ya, to' ko'mannîpî'pîuya, ameruntîri ke. Mîrîrî ameruntîri antîrî'pî ke to' ko'mannîpî'pîuya. Moropai anî' ataka'ma pra man, tîîse tiwinan neken aataka'maton. Innape awanî'pî, amaimu e'menukasa' yawîrî aataka'ma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tarîpai uutî sîrîrî aapia, moropai mîrîrî warantî tauya tarî si'ma inkamoro upemonkonoyamî' atausinpato'pe kure'ne, mîî pîkîrî pra. Uurî atausinpa warantî to' atausinpato'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anekaremekî'pî ekaremekî'pîuya to' pî'. Moropai non po tîîko'mansenonya tewanmakon pe to' ku'sa', maasa pra tonpakon pe pra to' wanî ye'nen, uurî warantî, tonpakon pe pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sîrîrî pata yapai to' mo'kakî tauya pepîn. Tîîse esatîuya to' ko'mannî'kî Makuiya to' yapisî namai. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Non po tîîko'mansenon yonpa pepîn uurî. Mîrîrî warantî to' yonpa pe pra nîrî upemonkonoyamî' man. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Inkamoro yenupakî amaimu pî', apemonkono pe to' e'to'pe imakui'pî tîku'se pra. Maasa pra amaimu wanî yairon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Uyarima'pîya warantî non pona, to' yarimauya pe wai pata poro. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Insanan ton pe eturumaka sîrîrî aapia. Innape insanan upemonkonoyamî' nîrî eturumakato'pe aapia, to' yaipontîpa apoitîrî pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Insanan pona neken epîrema pepîn, tîîse tiaronkon pona innape akupîtonkon pona, insanan maimu wenai. Inkamoro pona nîrî epîrema sîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Esatîuya tamî'nawîronkon upemonkonoyamî' e'to'pe tiwin. Paapa, uurî ya' amîrî wanî warantî moropai amîrî ya' uurî wanî warantî to' ku'kî uurî'nîkon ya' to' e'to'pe. Tiwin to' ko'manto'pe tamî'nawîronkon non po tîîko'mansenonya uyarima'pîya ku'to'pe innape. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ipîkku pu'kuru e'to', antîrî'pî uupia, mîrîrî ke to' repa'pîuya tiwin to' e'to'pe, tiwin e'nî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Uuko'mamî to' pia moropai aako'mamî uupia. Mîrîrî ya tiwin pu'kuru to' wanî. Mîrîrî warantî non po tîîko'mansenonya epu'tî uyarima'tîpon amîrî moropai upemonkonoyamî' yu'se awanî, uyu'se awanî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Inkamoro antîrî'san. Moropai uupia upata ya' to' ko'mamî yu'se wai. Moropai morî uyeseru antîrî'pî era'ma to'ya. Morî uyeseru tîrî'pîya maasa pra u'nînma'pîya pena pata pai pata ekonekasa' rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Paapa, yairon amîrî. Non po tîîko'mansenonya ayepu'tî pepîn, tîîse ayepu'tî pî' wai. Moropai insanan unenupa'sanya epu'tî uyarima'tîpon pe awanî. ");
INSERT INTO mbcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ayeseru ekaremekî pî' wai to' pî' moropai mîrîrî pî' uuko'mamî tiaronkon sa'namato'pe to'ya u'nînmaya warantî. Moropai uuko'manpîtî inkamoro kore'ta, to' yewan ya' tiwin e'nîto'pe. Mîrîrî warantî Jesus epîrema'pî, Paapa yarakkîrî eeseurîma'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Teepîrema tîpo, Jesus epa'ka'pî tînenupa'san yarakkîrî moropai iwîtî rukku'nîtî'pî to'ya, Cedrom itese'. Moro iratai po Oliveira ye'ka wanî'pî. Miarî tînenupa'san pokonpe eewomî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mîrîrî Oliveira ye'ka epu'tî'pî Judasya iteyatonon pî' Jesus ekareme'nenya. Epu'tî'pîiya maasa pra miarî Jesusya tînenupa'san muurukuntîpîtî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mîrîrî ye'nen moro Oliveira ye'kana' Judas erepamî'pî. Epîremanto' yewî' era'manenan enepî'pîiya moropai tiaronkon enepî'pîiya. Teepîremasanon esanon moropai fariseuyamî' narima'san, arinîke to' wanî'pî. Tîkasuparaikon moropai tîtaikapukon moropai tîweiyukon, tî'kuma'tukon ke to' erepamî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus epa'ka'pî to' ponaya moropai to' ekaranmapo'pîiya, tamî'nawîrî î' kupî to'ya tîpî' epu'tîi'ma. Ta'pîiya to' pî': —Anî' yuwaya'nîkon? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Inkamoroya yuuku'pî: —Jesus, Nazaré pon —ta'pî to'ya. —Uurî mîîkîrî —ta'pîiya. (Judas, iteyatonon pî' Jesus ekareme'nen, mîîkîrî wanî mîrîrî inkamoro pokonpe.) ");
INSERT INTO mbcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Uurî mîîkîrî, taasa' Jesusya pe, inkamoro atarima'pî moropai to' esenumî'pî non pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Moropai inî'rî Jesusya to' ekaranmapo'pî: —Anî' yuwaya'nîkon? —ta'pîiya to' pî'. —Jesus, Nazaré pon —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Uurî mîîkîrî tauya sa'rî. Uurî yuwaya'nîkon ya, moriya tîwî insanan unenupa'san nîtîi —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mîrîrî ta'pîiya tîmaimu yawîrî awe'ku'to'pe manni' Paapa nîtîrî'san ko'mannîpî'pîuya anî' ataka'ma pra man ta'pîiya ne'tîkini. Innape tîmaimu e'to'pe taiya mîrîrî warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mîrîrîya Simão Pedroya tîkasuparai mo'ka'pî moropai teepîremasanon esanon yepotorî poitîrî pana ya'tî'pîiya. Mîîkîrî ipoitîrî ese' Malco. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mîrîrî pî' Jesusya ta'pî Pedro pî': —Tîwî akasuparai nîsi, yeka'makî iwon ya' —ta'pîiya. —Itu'se Paapa e'to' yawîrî e'taruma'tî pepîn naka? Kaane, e'taruma'tî sîrîrî Paapa naipontî'pî pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mîrîrî tîpo Jesus yapisî'pî to'ya, surarayamî'ya moropai to' esa'ya, moropai teepîremasanon esanon narima'sanya yapisî'pî, itenya yewa'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Moropai e'mai' pe yarî'pî to'ya Anás pia. Anás mîîkîrî Caifás yawo. Mîrîrî kono' yai teepîremasanon esanon yepotorî pe Caifás wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mîîkîrî Caifásya Judeuyamî' esanon panamasa' wanî'pî tiwin warayo' sa'manta yu'se wanî tamî'nawîronkon pemonkonyamî' ton pe kai'ma to' panamasai'ya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Moropai Simão Pedro moropai tiaron inenupa'pîya Jesus wenaima'pî. Mîîkîrî tiaron inenupa'pî teepîremasanon esanon yepotorî nepu'tî. Mîrîrî ye'nen attî'pî Jesus pîkîrî itewî' poroyi'pîrî pîkîrî, ");
INSERT INTO mbcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","poro po Pedro ko'mamî tanne wîttî woima'tîto' mana'ta pia. Mîrîrîya tiaron inenupa'pî, manni' teepîremasanon esanon yepotorî nepu'tî'pî, mîîkîrî enna'po'pî mana'ta piawon wîri' yarakkîrî eseurîmai. Eeseurîma'pî moropai Pedro ewomî tîrî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Moropai mîîkîrî mana'ta piawon wîri'ya ta'pî Pedro pî': —Mîîkîrî warayo' nenupa'pî amîrî? —ta'pîiya. —Kaane, uurî pepîn —ta'pî Pedroya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mîrîrîya Pedro wîtî'pî ipoitîrîtonon kore'ta apo' pia tîwe'sanon pia. Moropai teepîremato'kon yewî' era'manenan pia. To' atapina'pî tîntîruka'pîkon pia, komi' pe pata wanî ye'nen. Satippe Pedro atapina'pî to' pokonpe. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mîrîrî tanne teepîremasanon esanon yepotorîya Jesus ekaranmapo'pî inenupa'san pî' moropai inekaremekî'pî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesusya yuuku'pî: —Tamî'nawîronkon pemonkonyamî' yeurîmapîtî'pîuya aronne, ama' pe pra. Epere'nîto' yewî'kon ta, epîremanto' yewî' ta, to' yenupapîtî'pîuya tîmurukun pe awanîkon tanne. Î' tauya pra wanî'pî ama' pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mîrîrî ye'nen î' ton pe uyekaranmapoya? Inkamoro umaimu etatîponkon mekaranmapoi, î' taasau'ya to' pî'. Mîrîrî epu'tî pî' to' man morî pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mîrîrî taasa' Jesusya pe, tiwin epîremanto' yewî' era'manenya Jesus yenpatamo'pî. Moropai ta'pîiya: —Î' ton pe see mîrîrî ye'ka pe eseurîman mîrîrî teepîremasanon esanon yepotorî pî'? —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesusya yuuku'pî: —Yairî pra eseurîmasa' ya, makai tamî'nawîronkon pî' î' kai'ma eseurîmasa'. Tîîse yairî eseurîman pî' wai. Î' wani' awanî ye'nen upa'tîya mîrîrî? —ta'pî Jesusya mîîkîrî pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mîrîrîya Anásya Jesus yarima'pî taironpî'se Caifás pia, teepîremasanon esanon yepotorî pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mîrîrî tanne Simão Pedro atapina ko'mannîpî'pî satippe si'ma. Moropai tiaronkon iipiawonkonya ta'pî ipî': —Mîîkîrî warayo' nenupa'pî nîrî amîrî ka'rî? Tîîse Pedroya ta'pî: —Kaane uurî pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mîrîrîya tiwin teepîremasanon esanon yepotorî poitîrîya ta'pî. Mîîkîrî pana Pedro na'tî'pî yonpa pe awanî'pî. Mîîkîrîya ta'pî Pedro pî': —Amîrî ka'rî ayera'mauya ne'tîkini mîîkîrî yarakkîrî Oliveira ye'kana' e'nî ne'tîkini —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Inî'rî Pedroya ta'pî: —Kaane. Mîrîrî pe rî kariwana yunkon e'na'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Moropai eerenmapî ya Jesus yarî'pî to'ya Caifás yewî' tapai Governador Pilatos yewî' ta. Tîîse Judeuyamî' esanon wanî'pî ewonpai pra, tîwe'kî'pakon namai Judeuyamî' pepîn kore'ta. Maasa pra Páscoa entamo'kanto' pî' e'pai to' wanî'pî. Mîrîrî ye'nen to' ewomî pîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mîrîrî ye'nen poro pona Pilatos epa'ka'pî to' pia. Moropai ta'pîiya to' pî': —Î' imakui'pî inkupî'pî taaya'nîkon mîrîrî, mîserî nîkupî'pî? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yuuku'pî to'ya. —A'kî, imakui'pî ku'sai'ya pra awanî ya, aapia ene'sa' annaya pepîn e'painon. Tîîse imakui'pî kupîtîpon mîserî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mîrîrî ye'nen ta'pî Pilatosya to' pî': —Amîrî'nîkon mîîkîrî yeseru yako'menkatî aawarîrî'nîkon moropai itaruma'tîtî ayeserukon yawîrî. Tîîse yuuku'pî to'ya: —Amîrî'nîkon Romanoyamî'ya anî' wîî me'po annaya tîrî pepîn —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mîrîrî warantî to' eseurîma'pî mîrîrî, Jesus nekaremekî'pî pî' innape awe'to'pe. Maasa pra î' kai'ma tîîsa'manta ekareme'sa' Jesusya wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos ewomî'pî tewî' ta moropai Jesus yanno me'po'pîiya. Mîrîrîya Jesus ekaranmapo'pîiya: —Judeuyamî' esa' amîrî, rei amîrî? —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusya yuuku'pî: —Uyekaranmapoya awinîpai ka'rî ou tiaronkonya ekareme'sa' mîrîrî apî' —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatosya ta'pî: —Judeu pepîn uurî. Amîrî yonpayamî' moropai teepîremasanon esanonya arumakasa' mîrîrî uyenya' —ta'pîiya. —Î' kupî pî' nan? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Sîrîrî non po pemonkonyamî' yaipontîuya pepîn to' esa' pe. Mîrîrî warantî ikupîuya ya, upoitîrîtonon eseya'nama e'painon Judeuyamî' esanonya uyapisî namai. Tîîse mîrîrî ye'ka pe pra kupîuya tarî sîrîrî non po. Maasa pra sîrîrî non winîpainon pepîn uurî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mîrîrî ye'nen Pilatosya ta'pî ipî': —Moriya rei pe awanî mîrîrî? Jesusya ta'pî: —Amîrîya taa mîrîrî, yairon mai. Esenpo'pî moropai uuipî'pî sîrîrî non pona yairon ekareme'se. Mîrîrî ton pe neken erepamî'pî. Moropai yairon anetapainonya umaimu pîinama. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatosya ta'pî: —Î' mîrîrî yairon? —ta'pîiya. Mîrîrî tîpo Pilatos epa'ka'pî pemonkonyamî' pia moropai ta'pîiya to' pî': —Imakui'pî inkupî'pî eporîuya pra wai. Î' wenai pra iwîme'pouya eserîke pra wai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","—Tîîse ayeserukon yawîrî kono' kaisarî Páscoa yai, tiwin unarakkamo'pî rumakauya aapia'nîkon. Mîserî amîrî'nîkon Judeuyamî' rei rumakauya yu'se naatî? ");
INSERT INTO mbcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mîrîrî yuuku'pî to'ya tîwentaimepî'se. —Kaane, mîîkîrî pepîn. Barrabás rumakaya yu'se anna man —ta'pî to'ya. (Barrabás mîîkîrî ama'ye'.) ");
INSERT INTO mbcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mîrîrî tîpo Pilatosya Jesus po'pîtî me'po'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Surarayamî'ya itarako ton koneka'pî mî'nî ke. Moropai yeka'ma'pî to'ya ipu'pai pona, moropai suuyu sonpan rei pon ye'ka yeka'ma'pî to'ya ipî' tîîwo'ma'takon pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Moropai iipia to' erepanpîtî'pî. Taapîtî'pî to'ya ipî': —Viva Jesus, Judeuyamî' esa' amîrî. Rei amîrî —kai'ma taa pî' to' ko'mamî'pî. Moropai mîîkîrî yenpatamopîtî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Moropai inî'rî Pilatos epa'ka'pî moropai ta'pîiya Judeuyamî' pî': —A'kî, mîîkîrî yenpa'ka me'po pî' wai era'makonpa. Imakui'pî inkupî'pî eporîuya pra wai. Î' wenai pra iwî me'pouya eserîke pra wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mîrîrî ye'nen Jesus epa'ka'pî mî'nî ye' tarakko pe tîîse moropai suuyu sonpan tîpon ya'. Mîrîrîya Pilatosya ta'pî to' pî': —A'kî, mîserî warayo' man. Era'matî! —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mîîkîrî era'ma tîuya'nîkon pe teepîremasanon esanon moropai to' poitîrîtonon entaimepîtî'pî. —Iwî me'pokî, iwî me'pokî pakî'nan pona —taapîtî'pî to'ya. Moropai Pilatosya ta'pî to' pî': —Kaane, uurî pepîn. Amîrî'nîkon neken tarîpai. Itu'se awanîkon ya, ipokapîtîtantî pakî'nan pona, iwîtî —ta'pîiya. —Tîîse uurî pia morî pe era'ma pî' wai. Î' wenai pra iwîtî tauya eserîke pra wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tîîse Judeuyamî'ya yuuku'pî: —Moisés nurî'tî nekaremekî'pî yawîrî aasa'manta e'pai awanî. Maasa pra Paapa munmu pe awe'kupî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mîrîrî eta tîuya pe, Pilatos esi'nîpî'pî inî' panpî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Moropai eewomî'pî tewî' ta inî'rî. Moropai Jesus ekaranmapo'pîiya. —O'non pata painon amîrî? —ta'pîiya. Tîîse Jesusya yuuku pîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatosya ta'pî ipî': —Umaimu yuukuya pepîn? Enpenatakî, ayesa' uurî. Arumakauya e'painon, awî me'pouya e'painon —ta'pîiya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusya yuuku'pî: —Aawarîrî uyesa' pe awanî pepîn. Uyesa' pe awanî maasa pra Paapaya itîîsa' mîrîrî aapia. Mîrîrî ye'nen mîîkîrîya, ayenya' urumakatîponya, imakui'pî ku'sa' mîrîrî, imakui'pî ku'sa'ya yentai. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mîrîrî eta tîuya ye'nen, Jesus anrumakapai Pilatos wanî'pî. Tîîse Judeuyamî' entaimepîtî'pî. —Irumakaya ya, César yeyaton pe awanî —ta'pî to'ya. —Anî' e'kupî ya rei pe César yentai e'pai awanî. César pîinamaiya pepîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mîrîrî eta tîuya pe Jesus yenpa'ka me'po'pî Pilatosya. Moropai eereuta'pî taponse' pona miarî pata tî' ka'sa' pona. (Judeuyamî' maimu ta Gabatá). ");
INSERT INTO mbcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Awanî'pî sexta-feira Páscoa konekato' weiyu pe. Moropai wei enu'sa' wanî'pî. Mîrîrî yai Pilatosya ta'pî Judeuyamî' esanon pî': —A'kî, ayesa'kon mîîkîrî, rei mîîkîrî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Moropai to' entaimepîtî'pî. —Iwî me'pokî, iwî me'pokî pakî'nan pona —taapîtî'pî to'ya. —Ayesa'kon wîî me'pouya yu'se naatî? —ta'pî Pilatosya. —Itesa' pînon anna —ta'pî to'ya. —César neken anna esa' —ta'pî teepîremasanon esanonya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mîrîrî tîpo Pilatosya Jesus rumaka tu'ka'pî Judeuyamî' yenya' iwîto'pe to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mîrîrî ye'nen surarayamî'ya yarî'pî. Jesus epa'ka'pî cidade poi. Pakî'nan yarî'pîiya tîwîto' yaponse' ton. Eerepamî'pî pata ese' pemonkon pu'pai'pî warainon. (Judeuyamî' maimu ta Gólgota.) ");
INSERT INTO mbcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Moro ipokapîtî'pî to'ya pakî'nan po. Moropai tiaronkon nîrî asakî'nankon warayo'kon pokapîtî'pî to'ya iratai winî Jesus wanî'pî to' arakkita. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Moropai Pilatosya tabua pona imenuka'pî moropai itîrî me'po'pî pakî'nan pona. JESUS NAZARÉ PON, JUDEUYAMÎ' ESA' taato' e'menukasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mararonkon pepîn Judeuyamî'ya mîrîrî erenka'pî maasa pra Jesus wî'pî to'ya aminke pra cidade pia. Moropai mîrîrî e'menukasa' wanî'pî eseurîwî'nankon maimukon ta. Judeuyamî' maimu ta, romanoyamî' maimu ta, moropai gregoyamî' maimu ta awe'menukasa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Moropai teepîremasanon esa'ya ta'pî Pilatos pî': —Judeuyamî' esa' kai'ma kî'menukai tîîse “Judeuyamî' esa' uurî”, ta'pî mîserîya taato' menukakî —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatosya yuuku'pî: —Î' unmenuka'pî ko'mamî mîrîrî warantî. Tiaron pe imo'tannîpîuya pepîn —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pakî'nan pona Jesus pokapîtî surarayamî'ya tîpo, ipon yanumî'pî to'ya moropai pantaka'pî to'ya tîkaisarî'nîkon, saakîrîronkon. Sonpan nîrî yanumî'pî to'ya. Mîrîrî sonpan morî tiwin ika'sa', iisi'pînto' ton pîn. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mîrîrî ye'nen ta'pî to'ya tîpî'nîkon: —Ipon karaka namai, tî' yenunpai'nîkon anî' yemanne pe sonpan wanî epu'to'pe'nîkon —ta'pî to'ya. Mîrîrî kupî'pî to'ya Paapa maimu e'menukasa' e'to'pe innape. See warantî awe'menukasa': Upon pantaka'pî to'ya tîkore'ta'nîkon moropai sonpan, anî' pon pe awe'nîmî epu'tîkonpa tî' yenumî'pî to'ya. Mîrîrî ye'nen mîrîrî kupî'pî surarayamî'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mîrîrî tanne aminke pra Jesus pakî'nanon pia wîri'sanyamî' wanî'pî satippe. Jesus yan moropai itakon moropai Clopas no'pî, itese' Maria, moropai Maria Magdala pon, inkamoro wanî'pî aminke pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Moropai tîsan era'ma tîuya pe, moropai tînenupa'pî, tîsa'namanen, era'ma tîuya pe, Jesusya ta'pî tîsan pî': —Era'makî, anre mîîkîrî tarîpai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mîrîrî tîpo ta'pîiya tînenupa'pî pî': —Era'makî, asan mîîkîrî tarîpai —ta'pîiya. Moropai mîrîrî pata pai inenupa'pîya isan yarî'pî tewî' ta aako'manto'pe. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tîîko'mamî tîpo, Jesusya tamî'nawîrî aretî'kasa' tîuya epu'tî'pî. Moropai ta'pîiya: —Tuna aninnîpai wai. Mîrîrî ta'pîiya innape Paapa maimu e'menukasa' e'to'pe yairî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Moro pisa wanî'pî intapîkîron uva yekku so'ritasa' yense'. Mîrîrî ye'nen tu'nasen esponja tîrî'pî to'ya wo' ka. Moropai amansa' tanne, esponja mo'ka'pî to'ya. Hissopo ye' pona tîrî'pî to'ya, moropai i'mî'sa'ka'pî to'ya inta ya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mîrîrî yu'na'pî Jesusya moropai ta'pîiya: —Tamî'nawîron ataretî'kasa' man. Mîrîrî taa tîuya yaretî'ka pe awe'muruika'pî moropai aasa'manta'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mîrîrî Páscoa konekato' weiyu yai, moropai penane wanî sábado ipîkku, páscoa pî' to' e'to'. Mîrîrî ye'nen isa'manta'san esa'rî'pî ko'mamî pakî'nan po yu'se pra Judeuyamî' wanî'pî. Mîrîrî ye'nen to' wîtî'pî Pilatos pia. Ta'pî to'ya ipî': —Inkamoro pîsi waikîpîtî me'pokî ka'ne' panpî' to' sa'mantato'pe moropai to' esa'rî'pî mo'kato'pe annaya pakî'nan po to' ko'mamî namai sábado yai —ta'pî to'ya ipî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mîrîrî ye'nen surarayamî' wîtî'pî. E'mai'non pakî'nan pon pîsi waikîpîtî'pî to'ya. Mîrîrî tîpo tiaron pîsi waikîpîtî'pî to'ya Jesus yarakkîronkon. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tîîse Jesus pia teerepamîkon yai, era'ma'pî to'ya aasîrî aasa'mantasa' wanî'pî. Mîrîrî ye'nen i'si waikîpîtî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tîîse tiwin suraraya tîkasuparai ke ya'so'ka'pî Jesus yara'ta yai. Mîrîrî pe rî imînî moropai tuna ti'kamo'pî mararî pra. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mîrîrî era'matîpon uurî. Moropai ekaremekîuya sîrîrî innape ikupîkonpa. Mîrîrî unekaremekî wanî yairî. Moropai mîrîrî wanî innape epu'tîuya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mîrîrî e'kupî'pî Paapa maimu e'menukasa' e'to'pe innape. See warantî awe'menukasa': Tiwin ite'pî waikîpîtî to'ya pepîn tiwin kin taato'. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Moropai inî'rî Paapa maimu e'menukasa' see warantî: Pemonkonyamî'ya tîna'so'ka'pîkon era'ma pe man taato' mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mîrîrî tîpo José Arimatéia ponya Pilatos pî' esatî'pî, Jesus esa'rî'pî yu'na'tîpa kai'ma. Mîîkîrî José wanî'pî Jesus wenaimetîpon pe tîîse ama' pe, maasa pra Judeuyamî' esanon nama'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Moropai Nicodemos, manni' Jesus pia itî'pî ewaron ya'. Mîîkîrî wîtî'pî José yarakkîrî. A'pusin yarî'pîiya 35 quilos kaisarî yai'mei mirra, aloé yarakkîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Moropai Jesus esa'rî'pî wontî'pî to'ya kamisa ke a'pusin teka'mai, Judeuyamî' yeseru yawîrî isa'manta'pî esa'rî'pî konekato' tîuya'nîkon yawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Moropai jardim wanî'pî Jesus wî'pî to'ya pata pia aminke pra. Moro wanî'pî amenan uuruwai, tî' yawon isa'manta'pî ton pînon. ");
INSERT INTO mbcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Moropai Judeuyamî' festarî weiyu ekonekato' wanî ye'nen mîrîrî uuruwai ya' Jesus esa'rî'pî yeka'ma'pî to'ya aminke pra awanî ye'nen. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo erenmapî yai, ewaron ke tîîse Maria Madalena wîtî'pî uuruwai pona. Moropai era'ma'pîiya, tî' kure'nan wanî'pî era'tîsa' inna'ta poi. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mîrîrî era'ma tîuya pe Maria ekatumî'pî Simão Pedro pia moropai tiaron inenupa'pî Jesus nîsa'nama'pî pia. Moropai ta'pîiya to' pî': —Uyepotorîkon yarî'pî to'ya man uuruwai yapai moropai o'non pata yaasa' to'ya epu'tî annaya pra man. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mîrîrî ye'nen Pedro moropai tiaron inenupa'pî wîtî'pî uuruwai pona. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Sa'nîrî to' ekatumî'pî tîîse tiaron inenupa'pî ka'ne' panpî' eeka'tumî'pî Pedro eka'tumî yentai. Mîrîrî ye'nen eerepamî'pî uuruwai pona Pedro rawîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Moropai awe'muruika'pî kamisa era'ma'pîiya tîîse eewomî pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ite'ma'pî pî' Pedro erepamî'pî. Tiwinarî Pedro ewomî'pî uuruwai ya', tî' yawon ya'. Moro kamisa era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Moropai Jesus pu'pai woinon kamisa era'ma'pîiya tiaron kamisa piapai aminke ma're. Yanmako'masa' pe awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mîrîrî tîpo tiaron inenupa'pî ewomî'pî Pedro ye'ma'pî pî'. Era'ma'pîiya, innape Jesus e'mî'sa'kasa' kupî'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Mîîwîni tîîse Paapa maimu e'menukasa' epu'tî to'ya pra awanî'pî, awe'mî'sa'ka e'pai awanî taato'.) ");
INSERT INTO mbcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mîrîrî tîpo to' emikku'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria ko'mamî'pî satippe tîkarawa'pî. Tîkarau ye'ka pe awe'muruika'pî moropai uuruwai ya' era'ma'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Moro inserîyamî' asakî'nankon era'ma'pîiya, aimutun to' pon. To' ereutasa' wanî'pî Jesus pata'pî ya', tiwin ipu'pai pata'pî ya', tiaron i'pu pata'pî ya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Moropai ta'pî to'ya Maria pî': —Wîri', î' pî' akarau mîrîrî? Mariaya yuuku'pî: —Inna, uyepotorî yarî'pî to'ya man moropai o'non pata yarî'pî to'ya epu'tîuya pra wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mîrîrîya eera'tî'pî moropai Jesus era'ma'pîiya. Tîîse Jesus pe awanî epu'tîiya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesusya ta'pî ipî': —Wîri', î' pî' akarau mîrîrî? Anî' yuwaya? —ta'pîiya. Jardim ko'mannî'nen kai'ma Maria esenumenka'pî. Mîrîrî ye'nen ta'pîiya: —Inna, uyonpa, amîrîya ka'rî yaasa' nai ka'kî upî' o'non pata yarî pî' nan uutîto'pe era'mai? —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesusya ta'pî ipî': —Maria —ta'pîiya. Mîrîrî pî' eera'tî'pî iponaya moropai ta'pîiya Judeuyamî' maimu ta: —Rabôni —ta'pîiya. (Uyenupanen taato' mîrîrî.) ");
INSERT INTO mbcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Uurî kîsapisî —ta'pî Jesusya ipî'. —Maasa enuku pra wai uyun pia. Tîîse atîkî uyonpayamî' pia. Makai to' pî' enna'po uyun pia, mîîkîrî wanî to' yun pe nîrî, Paapa unapurîton moropai to' napurîton nîrî pia uutî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mîrîrî ye'nen Maria wîtî'pî inenupa'san pia moropai ekaremekî'pîiya. —Uyepotorîkon era'ma pî' wai, see ye'ka pe taa pî' man —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pata ko'mamî'pî mîrîrî domingo yai. Mîrîrî yai inenupa'san epere'sa' atarakkansa' wanî'pî maasa pra Judeuyamî' esanon pî' eranne' pe to' wanî'pî. Mîrîrî tanne Jesus iipî'pî to' kore'ta satippe awanî'pî. Moropai ta'pîiya to' pî': —Tîîwanmîra e'tî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mîrîrî taa tîuya tîpo, tenya prego yetta'pî moropai tara'ta yaino yenpo'pîiya. Mîrîrî pî' inenupa'san atausinpa'pî tepotorîkon era'ma tîuya'nîkon pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Inî'rî Jesusya ta'pî to' pî': —Tîîwanmîra e'tî. Sîrîrî non pona uyunya uyarimasa' warantî ayarimauya'nîkon —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mîrîrî tîpo to' puma'pîiya. —Morî Yekaton Wannî yapi'tî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","—Anî' nîkupî'pî imakui'pî kupîya'nîkon ya aawanmîra'nîkon, Paapaya nîrî ikupî tîîwanmîra. Tîîse anî' nîkupî'pî imakui'pî kupîya'nîkon pra awanî ya, aawanmîra'nîkon, mîrîrî warantî aako'mamî mîrîrî. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Moropai Tomé, tiwin inenupa'pî tiaronkon inenupa'san yarakkîrî pra awanî'pî Jesus iipî'pî yai. (Mîîkîrî Tomé wanî'pî asakî'ne itese', Tomé moropai monoi'.) ");
INSERT INTO mbcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mîrîrî ye'nen tiaronkon inenupa'sanya ekaremekî'pî. —Uyepotorîkon era'ma pî' anna man —ta'pî to'ya ipî'. Tîîse Toméya ta'pî to' pî': —Innape akupîuya'nîkon pepîn. Uyenya eperu ke itenya pokato' pata'pî ya' yapîuya pra tîîse innape ikupîuya pepîn. Yara'ta ya'so'kasa' ya' uyenya yeka'mauya pra tîîse innape ikupîuya pepîn —ta'pî Toméya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Moropai eseurîwî'ne mia' pona tîîmo'tai (8) wei tîpo, inî'rî inenupa'san epere'sa' wanî'pî wîttî ta. Moropai Tomé wanî'pî to' pokonpe. Mana'takon atarakkansa' wanî'pî. Mîîwîni tîîse Jesus esenpo'pî to' kore'ta, awanî'pî satippe. Moropai ta'pîiya to' pî': —Tîîwanmîra e'tî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Moropai ta'pîiya Tomé pî': —Ayenya yeka'makî uyenya ya', era'makî. Moropai uyara'ta yai ayenya yawonnî'kî innape ukupîpa. Innape pra uurî kî'kupîi —ta'pîiya Tomé pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mîrîrîya Toméya yuuku'pî: —Uyepotorî, Paapa unapurîton —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusya ta'pî ipî': —Innape ukupî pî' nan uyera'maya ye'nen? Tîîse tiaronkon uyera'ma'tîponkon pepîn inkamoro, tîîse innape ukupî to'ya. Mîrîrî wenai to' atausinpa. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Moropai mararî pra anî' nîkupî eserîkan pepîn kupî'pî Jesusya tînenupa'sanya era'ma tanne. Tîîse sîrîrî kaareta pona imenukasau'ya pra wai. ");
INSERT INTO mbcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tîîse unmenuka'san menuka'pîuya innape Jesus wanî Cristo, Paapa nîmenka'pî pe kupîkonpa. Innape Paapa munmu pe Jesus wanî kupîkonpa. Moropai innape ikupîya'nîkon ye'nen, aako'mamîkon enen ipatîkarî iipia. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mîrîrî tîpo, inî'rî Jesus esenpo'pî tînenupa'san pia Tiberíades ku'pîrî ena po to' tîîse. Sîrîrî warantî awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tîmurukun pe to' wanî'pî. Simão Pedro, Tomé, manni' itese' monoi', Natanael, Galiléia pon Caná poinon, Zebedeu munkîyamî', moropai tiaronkon asakî'nankon Jesus nenupa'san wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Moropai Simão Pedroya ta'pî tiaronkon pî': —Tarrafa pî' uutî sîrîrî —ta'pîiya. —Inna iyarî, anna wîtî nîrî —ta'pî to'ya ipî'. Mîrîrî ye'nen to' asara'tî'pî kanau ya'. Tiwin ewaron erenmapî pîkîrî anî' yapisî to'ya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wei epa'ka tanne, Jesus esenpo'pî tuna ena pona satippe. Tîîse Jesus pe awanî epu'tî inenupa'sanya pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Moropai Jesusya ta'pî to' pî': —Uyonpayamî', anî' yapisîya'nîkon pra naatî? —ta'pîiya. —Inna, anî' ton pra man —ta'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesusya ta'pî to' pî': —Tarrafa yenuntî kanau meruntî winî, moro'yamî' yapisîkonpa. Moropai yenumî'pî to'ya moropai inî'rî mîrîrî yeku'na to'ya eserîke pra awanî'pî maasa pra mararî pra moro'yamî' atapi'sa' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Moropai inenupa'pî Jesus nîsa'nama'pîya ta'pî Pedro pî': —Uyepotorîkon mîîkîrî —ta'pîiya. Mîrîrî eta tîuya pe Pedroya tîpon yeka'ma'pî maasa pra tîpon mo'kasai'ya wanî'pî. Moropai aarapumî'pî tuna ka'. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tiaronkon inenupa'san wîtî'pî Pedro pîkîrî tuna ena pona kanau ya', tarrafa yeku'na'pî to'ya. Maasa pra aminke pra tuna ena pona to' wanî'pî. Yai pra 100 metros kaisarî to' wanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tîwautîkon pe apo' era'ma'pî to'ya, moro'yamî' wanî'pî ipo moropai pão. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Moropai Jesusya ta'pî to' pî': —Anapisî'pîkon moro'yamî' yonpa ene'tî —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simão Pedro asara'tî'pî moropai tarrafa ku'na'pîiya. Mararonkon pepîn moro'yamî' wanî'pî. 153 kaisarî wanî'pî. Mîîwîni tîîse tarrafa e'karakasa' pra awanî'pî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Moropai Jesusya ta'pî to' pî': —Asi'tî entamo'kai —ta'pîiya. Moropai “Anî' amîrî?” kai'ma taa anî'ya pra awanî epu'tî'pî to'ya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mîrîrîya Jesus wîtî'pî, pão yanumî'pîiya, to' pia itîrî'pîiya. Mîrîrî warantî moro' yanumî'pîiya itîrî'pîiya nîrî to' pia. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mîrîrî wanî teeseurînon ite'ka pe Jesus esenpo'pî tînenupa'san pia tîwe'mî'sa'ka tîpo. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tîwentamo'kakon tîpo, Jesusya ta'pî Simão Pedro pî': —Simão, João munmu amîrî. Uurî sa'namaya insananya usa'nama yentai? Yuuku'pî Pedroya: —Inna, uyepotorî. Asa'nama pî' wai, epu'tî pî' nai —ta'pîiya. Jesusya ta'pî: —Upemonkonoyamî' ko'mannî'kî, ayekînnan carneiroyamî' ko'mannîpîya warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Moropai itakon te'ka pe Jesusya ta'pî Pedro pî': —Simão, João munmu amîrî. Innape pu'kuru usa'nama pî' nan? —ta'pîiya. —Inna, uyepotorî —ta'pî Pedroya. —Asa'nama pî' wai epu'tî pî' nai. Jesusya ta'pî: —Moriya upemonkonoyamî' ko'mannî'kî ayekînnan ko'mannîpîya warantî. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Teeseurînon te'ka pe Jesusya ta'pî: —Simão, João munmu amîrî. Uurî sa'nama pî' nan? Mîrîrî pî' Pedro esewankono'ma'pî. Maasa pra Jesusya tekaranmapopîtî'pî eseurîwî'ne ite'ka kaisarî, —Uurî sa'nama pî' nan? —taiya ye'nen. Mîrîrî ye'nen ta'pîiya ipî': —Uyepotorî, tamî'nawîron epu'nen amîrî. Asa'nama pî' wai epu'nen amîrî nîrî. Jesusya ta'pî: —Moriya upemonkonoyamî' ko'mannî'kî ayekînnan ko'mannîpîya warantî —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ayenku'tîuya pepîn, pena maasa awanî ya apon ton yeka'mapîtî'pîya moropai itu'se awe'to' ya' attîpîtî'pî. Tîîse a'yeke'ton pe eena ya, ayenya yekainumîya tiaronya ayewa'tîto'pe moropai ayarî to'ya o'non pata itu'se awe'to' pepîn ya'. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mîrîrî taa tîuya pe, Jesus eseurîma'pî î' kai'ma Pedro sa'mantato' pî'. Moropai aasa'mantato' wenai, tiaronkonya Paapa yapurî. Mîrîrî tîpo Jesusya ta'pî ipî': —Upîkîrî aase. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Moropai Pedro era'tî'pî, tiaron inenupa'pî era'ma'pîiya, manni' Jesus nîsa'nama'pî, Jesus pia awanî manni' entamo'kanto' Páscoa itese' weiyu yai, Jesus pî' ekaranmapotîpon —Uyepotorî, anî'ya amîrî ekaremekî ayeyatonon pî'? —taiya ne'tîkini. Mîîkîrî era'ma'pî Pedroya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mîrîrî era'ma tîuya ye'nen Pedroya ta'pî Jesus pî': —Uyepotorî, î' e'kupî mîserî yarakkîrî? ");
INSERT INTO mbcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusya yuuku'pî: —Mîîkîrî ko'mamî yu'se wanî ya uuipî pîkîrî, mîîkîrî yarakkîrî î' ton pra nai. Tîîse amîrî, upîkîrî aase —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mîrîrî ye'nen tiaronkon itonpayamî'ya taa ko'mannîpî'pî manni' inenupa'pî, aasa'manta pepîn kai'ma to' eseurîmapîtî'pî. Tîîse mîrîrî ye'ka pe pra Jesus eseurîma'pî. —Aasa'manta pepîn —taiya pra awanî'pî. Tîîse, —Uuipî pîkîrî aako'mamî yu'se wanî ya, mîîkîrî yarakkîrî î' ton pra nai —ta'pîiya. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Manni' inenupa'pî mîrîrî ekareme'nen mîîkîrî, imenukatîpon nîrî, moropai inekaremekî'pî yairî epu'tî pî' anna man. ");
INSERT INTO mbcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Moropai mararon pepîn Jesus nîkupî'san. Mîrîrî e'menukasa' wanî ya, tu'ke kaareta yannîpîiya e'painon, sîrîrî pata yentai.");
INSERT INTO mbcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiófilo, manni' kaareta aapia unmenuka'pî wanî Jesus yekare ekareme'nen pe. Tamî'nawîrî î' kupî'pî Jesusya teesenyaka'ma pia'tî'pî pata pai ka' pona tarî Paapaya pîkîrî ekareme'nen pe awanî. Î' ikupî eserîkan pepîn ku'pîtî'pîiya, moropai pemonkonyamî' yenupapîtî'pîiya ekareme'nen pe awanî. Moropai tînaipontî'san pia tîmaimu tîrî'pîiya Morî Yekaton Wannî wenai to' nîkupî ton pe. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Inkamoro pia Jesus esenpo'pî enen tîîsa'manta tîpo. Asakî'ne pemonkon (40) wei tîîko'mamî pîkîrî eesenpopîtî'pî to' pia tu'ke ite'ka. Mîîkîrî nîkupî'pî era'ma'pî to'ya. Mîrîrî ye'nen enen awanî epu'tî'pî to'ya aasa'mantasa' pe ikupî to'ya pîn. Moropai tînaipontî'san yarakkîrî eeseurîmapîtî'pî Paapa yeseru pî'. Î' kai'ma Paapa iipî tamî'nawîronkon esa' pe ekareme'pîtî'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Moropai tiwin ite'ka tînaipontî'san pere'sa' tîuya yai tîmaimu tîrî'pîiya to' pia. Ta'pîiya: —Maasa tarî e'tî Jerusalém po Paapa nîtîrî yapisîkonpa. Inîmî'tî. Maasa pra yarima tîuya taasai'ya man apî'nîkon. Mîrîrî warantî rî uurîya nîrî ta'pî —ta'pî Jesusya. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—A'kî, Joãoya imakui'pî tînkupî'pîkon rumakanenan yenpatakona'pî tuna ke pena. Tîîse inî' panpî' yapisîya'nîkon kupî sîrîrî. Mararî tîîko'manse aapia'nîkon Morî Yekaton Wannî erepamî kupî sîrîrî ayesa'kon pe, aako'manto'pe ipatîkarî —ta'pî Jesusya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mîrîrî tîpo Jesus naipontî'san emurukuntî'pî ipokonpe ˻Oliveira kîrî po˼. Mîrîrî yai ekaranmapo'pî to'ya: —Anna Yepotorî, î' pensa anna kupîya kupî sîrîrî anna pata esa' pe anna ko'manto'pe anna warîrî, sîrîrî ka'rî, maasa ka'rî? —ta'pî to'ya Jesus pî'. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesusya yuuku'pî: —Mîrîrî epu'tîya'nîkon yu'se Paapa wanî pra man. Uyun Paapaya neken epu'tî, iweiyu iku'ne'tîsa' tîuya ye'nen —ta'pîiya to' pî'. ");
INSERT INTO mbcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","—Tî