﻿USE sofia;
DROP TABLE IF EXISTS sofia.mbbOT_vpl;
CREATE TABLE mbbOT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mbbOT_vpl WRITE;
INSERT INTO mbbOT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Diyà te puunà midlimbag te Megbevayà is langit wey is kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ne zutun, kenè pa hustu is kegkeveeli te kelibutan ne wazè din taǥù. Ne ziyà te zivavew te utew mezalem he wahig ne utew merusirem, diyà medriǥuriǥu is Mulin-ulin te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ne migkaǥi zutun is Megbevayà te, “Mehimu is kerayag!” Ne nehimu en dutun is kerayag. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ne naahà te Megbevayà he meupiya haazà is kerayag, ne impedsivey zin is kerayag wey is kerusireman. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ne haazà is kerayag, migngezanan te Megbevayà te “maandew”, ne haazà is kerusireman, ne migngezanan din te “mezukilem.” Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is nehuna he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ne migkaǥi zutun is Megbevayà te, “Mehimu is elang dutun te wahig su wey mezezuwa he vahin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ne zutun nehimu is elang ne pinaaǥi kayi impedsivey zin is wahig he ziyà te zizalem wey is wahig he ziyà te zivavew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ne haazà is elang, migngezanan te Megbevayà he “hewhewanan.” Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is ikezuwa he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ne migkaǥi zutun is Megbevayà te, “Mesevaha ziyà te sevaha he lugar is wahig kayi te kelibutan para medlepew is memaza he lugar.” Ne nehimu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ne haazà is memaza, migngezanan te Megbevayà he “tanà” ne haazà is insivey zin he wahig, migngezanan din he “zaǥat.” Ne naahà te Megbevayà he meupiya haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ne zutun migkaǥi is Megbevayà te, “Medtuvù diyà te tanà is migkelingulingu he menge pinemula: is menge pinemula he zuen menge lisu wey is minsan hengkey he kayu he ebpemeǥas sumalà te kelasi zan.” Ne nehimu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Midtuvù dutun te tanà is langun he kelasi te menge sagbet he zuen dan lisu wey is minsan hengkey he kayu he ebpemeǥas he zuen lisu ziyà te menge veǥas dan. Ne naahà te Megbevayà he meupiya zaan haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is iketelu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ne migkaǥi zutun is Megbevayà te, “Mehimu ziyà te langit is menge mesiǥa su wey zuen tuus te maandew wey mezukilem. Egkehimu zaan haazà he tuus te menge timpu te menge tuig wey menge andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Egkehimu haazà he menge idtayew ziyà te langit su wey meteyawi is kelibutan.” Ne nehimu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Su midlimbag dutun te Megbevayà sikan is dezuwa he utew mesiǥa: ne haazà is dekelà, ibpetayew zin te tanà emun maandew, ne haazà daan is sevaha, ne ibpetayew zin te tanà emun mezukilem. Ne midlimbag din daan is menge vituen. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ne heini is langun, insavuk din diyà te langit wey meteyawi is kelibutan, ");
INSERT INTO mbbOT_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ne wey pinaaǥi zutun metapid is maandew wey mezukilem, wey is merayag wey merusirem. Ne naahà te Megbevayà he meupiya zaan haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is ikeepat he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ne migkaǥi zutun is Megbevayà te, “Mehimu ziyà te menge wahig is utew medmezakel he linimbag he egeǥehinawa wey ebpezumdumahà ne mehimu zaan is utew mezakel he menge tagbis he ebpemenlayang diyà te hewhewanan he zivavew te tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Umbe midlimbag te Megbevayà is utew zekelà he menge isdà wey is langun he menge linimbag he egeǥehinawa wey ebpenlayewlayew wey ebpezumdumahà he utew medmezakel ziyà te wahig. Ne midlimbag din daan is minsan hengkey he kelasi te menge tagbis. Ne naahà te Megbevayà he meupiya zaan haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ne midtuvazan heini te Megbevayà ne ke sikandin te, “Mengevuwad kew ne mebmahabet kew utew su wey mepenù is daǥat te menge linimbag ku. Ne mebmahabet kew zaan is menge tagbis diyan te tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is ikelima he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ne migkaǥi en maan is Megbevayà te, “Melimbag he ebpuun diyà te tanà is mezakel he kelasi te menge linimbag he egeǥehinawa. Melimbag is menge langgam he menge ayam wey menge leew wey is menge keranapranap.” Ne nehimu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Su midlimbag dutun te Megbevayà is menge langgam he leew wey ayam wey is menge keranapranap he ebpenanap wey edula zini te tanà, ne naahà dutun te Megbevayà he meupiya zaan haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ne zutun migkaǥi is Megbevayà te, “Edhimuwen tew is menusiyà he iring kenitew su wey zan meveyveyai is menge isdà diyà te zaǥat wey is menge tagbis diyà te hewhewanan wey is menge langgam he ayam wey leew wey is menge keranapranap he ebpenanap wey edula ziyà te tanà. Ebeyveyaan dan is tivuuk he tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ne midlimbag dutun te Megbevayà is menusiyà he iring kandin. Midhimu zin sikandan he mekeiring kandin te Megbevayà. Maama wey vahi is midlimbag din. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ne midtuvazan sikandan te Megbevayà ne migkeǥiyan din sikandan te, “Mevuwad kew ne mebmehabet kew su wey niw meeneb is kelibutan. Iyan kew mebayàbayà dini te tanà. Iyan kew mebayàbayà te menge isdà diyà te zaǥat wey te menge tagbis he ebpemenlayang diyà te hewhewanan wey te menge linimbag he egeǥehinawa he edhipanew zini te tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ne migkaǥi zutun is Megbevayà te, “Idtuǥut ku keniyu he egkeenen niw is minsan hengkey he sagbet he zuen din beǥas wey is minsan hengkey he veǥas te kayu he ebpemeǥas he zuen lisu ziyà te menge veǥas din. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ne haazà is menge langgam he ziyà te tanà, wey is menge tagbis he ebpemenlayang diyà te hewhewanan, wey is menge keranapranap he ebpenanap, wey is minsan hengkey he egeǥehinawa, idtuǥut ku kandan he egkeenen dan is minsan hengkey he menge meilem he sagbet.” Ne nehimu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ne zutun mid-ahà te Megbevayà is langun he nelimbag din, ne utew iyan haazà meupiya. Ne mibmezukilem dutun, ne hein nepawè en, ne nehimu is ikeenem he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ne zutun nepasad te Megbevayà is kedlimbaǥa te langit, te kelibutan, wey te langun he taǥù dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ne zutun te ikepitu he andew, geina te nepasad en te Megbevayà haazà is langun he menge vaal zin, midhimeley sikandin he ebaal. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ne midtuvazan te Megbevayà is ikepitu he andew ne migkaǥi zin daan he segradu haazà su midhimeley sikandin dutun te kedlimbaǥa zin te langun. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iyan heini sikan is keguǥuza te kedlimbaǥa zengan te langit wey kelibutan. Dengan hein midlimbag te Nengazen he Megbevayà is langit wey kelibutan, ");
INSERT INTO mbbOT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wazè pa pinemula kayi te kelibutan wey wazè pa zaan benì he nenuvù, su wazè din pa ipeuzan su wazà etew he ebpekaatur te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Dutun he timpu zuen gapun he ebpuun te tanà ne pinaaǥi zutun egkahames is tivuuk he tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ne zutun midlimbag te Nengazen he Megbevayà is etew, ne iyan inlimbag din dutun is eliyavuk he ebpuun dini te tanà. Ne inhiyup din dutun te izung duen te etew is kandin en he ǥehinawa he ebpekeuyag, ne zutun nehimu is etew he linimbag he ebpekeǥeǥehinawa. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ne zutun mibeelan te Nengazen he Megbevayà is pemuleey ziyà te Eden he ziyà te zapit te edsilaan, ne insavuk din dutun haazà is etew he midlimbag din. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ne zuen menge kayu he impetuvù dutun te Nengazen he Megbevayà. Utew meupiya he ed-ahaan haazà is menge kayu ne meupiya zaan he egkeenen is menge veǥas dan. Ne zutun te teliwazà duen te pemuleey impetuvù din daan is kayu he ebpekeveǥey te untung wey is kayu he ebpekeveǥey te kegketau te meupiya wey mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ne zuen wahig diyà te Eden he ziyà ebayà te pemuleey su wey mevinyaǥi is menge pinemula zutun. Ne zutun nehimu haazà is wahig he ebpuunan duen te heepat he menge wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Is ngazan te nehuna he wahig ne Pishon. Iyan haazà sikan is wahig he ziyà edtudà te tivuuk he tanà he Havila he zutun duen egkaahà he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Lunsey he vulawan is ebpuun dutun, ne zuen daan dutun sikan is mahalen he pehemut he bidilyum wey zuen daan dutun menge mahalen he vatu he uniks. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Is ngazan dutun te ikezuwa he wahig ne Gihon. Diyà heini edtudà te tivuuk he tanà he Cush. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Is ngazan dutun te iketelu he wahig ne Tigris. Diyà heini edtudà te edsilaan te Asiria. Ne is ikeepat he wahig iyan is Eufrates. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ne haazà is etew he midlimbag te Nengazen he Megbevayà, diyè din isavuk te pemuleey he Eden su wey zin maatur wey meventayi haazà is pemuleey. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ne haazà is etew, mibpeketelteleenan te Megbevayà he egkaǥi te, “Idtuǥut ku kenikew he megkaan ka te veǥas te menge kayu zini te pemuleey, ");
INSERT INTO mbbOT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","iyan, sikan is beǥas te kayu he ebpekeveǥey te kegketau te meupiya wey mezaat, utew kinahanglan he kenè nu heeyan keena. Su zutun dà te kegkaan nu keniyan te veǥas din kenà duwazuwa he ebpatey ka.” ");
INSERT INTO mbbOT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ne migkaǥi zutun is Nengazen he Megbevayà te, “Kenà meupiya zuen te etew emun sebsevaha zà sikandin. Umbe ebeelan ku sikandin te zuma zin he zait he ebpeketavang kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ne zutun, puun dutun te tanà, midlimbag te Nengazen he Megbevayà is langun he menge leew he menge langgam wey is langun he menge tagbis he ziyà ebpemenlayang te hewhewanan. Ne impeetuvang din haazà is langun dutun te etew su ed-ahaan din ke hengkey is menge igngazan kandan duen te etew. Ne sumalà is igngazan te etew te uman sevaha zutun te linimbag he egeǥehinawa ne iyan en ngazan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ne migngezanan dutun te etew is langun he menge ayam he langgam dutun, wey is menge tagbis he ziyà ebpemenlayang te hewhewanan wey is langun he menge leew he langgam. Ne minsan pa zutun wazè pa hustu he zuma zutun te etew he ebpeketavang kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ne tenged dutun impelipezeng te Nengazen he Megbevayà haazà is etew ne hein utew en nehurep, migkuwa zin is sevaha zuen te menge ǥusuk kayi ne midlimeng din haazà is ebpuunan duen te ǥusuk. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ne puun dutun te ǥusuk he migkuwa zin puun dutun te maama, midhimu te Nengazen he Megbevayà is bahi. Ne impeehè din haazà is bahi zutun te maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ne zutun migkaǥi kes maama te, “Duen ku en human duma! Is menge tulan din, ne zini ebpuun te tulan ku wey is sapù din daan, ne zini ebpuun te sapù ku. Egngezanan ku sikandin he ‘vahi’ su zini sikandin ebpuun te kedì te maama,” ke sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iyan heini hinungdan ke maan is ed-ewaan te maama is amey zin wey iney zin ne ebpengesawa te vahi, ne zutun egkehimu haazà is maama wey vahi he sevaha zà. ");
INSERT INTO mbbOT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ne lelevas haazà is dezuwa, sikan is maama wey esawa zin, iyan, kenè dan haazà igkeeled. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sikan is uled, ne utew metau he ed-akal te langun he menge langgam he linimbag te Nengazen he Megbevayà. Migkeǥiyan din kes bahi te, “Kenà buwa iyan migkaǥi te Megbevayà is kenè din idtuǥut keniyu is kegkaan te veǥas te minsan hengkey he kayu zini te pemuleey?” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ne midtavak haazà is bahi te, “Intuǥut din kenami is kegkaan te langun he menge veǥas te zuma he kayu kayi te pemuleey, ");
INSERT INTO mbbOT_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","iyan, haazà is beǥas te kayu he ziyà te teliwazà te pemuleey. Indawey kenami te Megbevayà su ke sikandin te, ‘Kenè niw heeyan keena etawa minsan is kedsenggira zà duen. Su emun egkeenen niw heini ne ebpatey kew.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ne migkaǥi kes uled diyà te vahi te, “Kenè kew ebpatey, ");
INSERT INTO mbbOT_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","su netuenan en te Megbevayà he zutun dà te kegkeena niw zuen, egkehimu kew he utew metau ne ebpekeiring kew te Megbevayà su egketuenan niw is meupiya wey mezaat.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ne hein nesavut te vahi he metaam bes he egkeenen haazà is beǥas te kayu, wey meupiya zaan he ed-ahaan wey nesavut din daan he utew haazà egkinehenglana su wey zan mehimu he utew metau, ne midrupù sikandin dutun ne migkaan din. Ne mibeǥayan din daan is esawa zin he zuma zin daan dutun ne migkaan daan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ne zutun te nekepasad dan he egkaan, netuenan dan ke hengkey is meupiya wey mezaat, ne neseǥipè dan human he lelevas dan bes. Umbe mibpenahì dan is menge zahun te kayu he higus su wey zan duen igketambun te lawa zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ne hein mahapun en dutun he ebpengpengeramag, nezineg dan is Nengazen he Megbevayà he edhiphipanew zutun te pemuleey. Ne haazà is maama wey esawa zin, mid-elesan dan is Megbevayà dutun te menge kayu he ziyà te pemuleey. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ne mid-umew te Nengazen he Megbevayà sikan is maama he ke sikandin te, “Hendei ka?” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ne midtavak is maama te, “Nezineg ku sikew is edhiphipanew zini te pemuleey, ne nahandek a, su lelevas a, umbe mid-eles a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ne migkaǥi is Nengazen he Megbevayà te, “Hentei is migkaǥi kenikew he lelevas ka? Migkaan ke ve zuen te veǥas te kayu he indawey ku keniyu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ne midtavak is maama te, “Haazà is bahi he impezuma nu kediey, mibeǥayan e zin ne migkaan a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ne mid-insaan te Nengazen he Megbevayà kes vahi, ke sikandin te, “Hengkey heini is mid-ulaula nu?” Ne midtavak dutun is bahi te, “Mid-ekalan a te uled, umbe migkaan a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ne zutun migkeǥiyan te Nengazen he Megbevayà kes uled, ke sikandin te, “Te langun he menge langgam he ayam wey ke leew ve, iyan ka edrewakan ku tenged te mid-ulaula nu heini. Ebpekelangkeb ke zà ne ebpekezula ka taman te kenè ke pa ebpatey. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Edhimuwen ku he kuntada nu haazà is bahi, ne ebpekigkuntada zaan is kevuwazan din te kevuwazan nu. Edrupeten din is ulu nu ne edkeǥaten nu is palu zin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ne zutun migkeǥiyan din daan is bahi, ke sikandin te, “Tenged te mid-ulaula nu, edhimuwen ku he utew mesakit is kebelilita kenikew ke ed-anak ka. Merasey is ked-enaka nu te menge vatà, ne minsan pa zutun egkeeriǥan ke zed te esawa nu ne iyan sikandin ebayàbayà kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ne zutun migkeǥiyan te Megbevayà is maama te, “Tenged te mibpemineg ka te esawa nu ne migkaan ka zuen te veǥas te kayu he indawey ku he ke siak te, ‘Kenè niw heeyan keena,’ ne edrewakan ku is tanà tenged keniyu. Ne taman te kenè ke pa ebpatey wey ke zà ebpekekaan te veǥas te edtuvù dutun te tanà ke egkerasey ka he edhaǥù. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Su menge meǥarang wey menge zuǥiyen is edtuvù dutun te kebasuk nu. Ne ebpekekaan ka te veǥas te menge pinemula nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ne taman te kenè ke pa idleveng dini te tanà, wey ke zà ebpekekaan ke edrimusengan ka. Is eliyavuk te tanà iyan puunà te lawa nu ne ziyà daan heini keuzemà te eliyavuk ebpekeulì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Sikan is maama, migngezanan din is esawa zin he “Eva” su egkehimu sikandin he iney te tivuuk he menusiyà. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ne zutun mibaal is Nengazen he Megbevayà te visti he lundis te menge langgam ne insun-ud din haazà dutun te ki Adan wey te esawa zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ne migkaǥi zutun is Nengazen he Megbevayà te, “Nehimu en is menusiyà he iring kenitew su egketuusan din en is meupiya wey mezaat. Umbe utew kinahanglan kenè sikandin edtuǥutan he mekekaan dutun te veǥas te kayu he ebpekeveǥey te untung, su emun ebpekekaan sikandin ne kenè en ebpatey te wazà pidtemanan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ne tenged dutun midsegseg te Nengazen he Megbevayà sikan is menusiyà puun dutun te pemuleey he Eden, ne impevasuk din sikandin duen te tanà he zutun sikandin ebpuun. ");
INSERT INTO mbbOT_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ne hein midsegseg din en haazà is etew, impevantey zin dutun te zapit te pemuleey he Eden sikan is menge velinsuǥuen din he kirubin wey zuen daan egkeregreg he ispada he ebiyuviyu su wey wazà minsan hentei he ebpekehendiyà te kayu he ebpekeveǥey te untung. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ne zutun mid-uvayan ni Adan haazà is esawa zin he si Eva, ne mibmeǥingey sikandin ne mid-anak sikandin te maama, ne ke si Eva te, “Midtevangan a te Nengazen he mekeanak a, umbe egngezanan ku sikandin te Cain.” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ne mibmeǥingey en maan si Eva ne mid-anak sikandin te maama, ne mid-ngezanan din te Abel. Ne hein midekelà en si Abel, perevantey sikandin te menge kerehidu, ne si Cain, ne mibasuk mulà. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ne neuma is andew he nemuhat si Cain diyà te Nengazen. Ne iyan impemuhat din is menge veǥas te menge pinemula zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ne si Abel mulà migkuwa sikandin te kinekekayan duen te menge uyaǥen din ne midlapè din, ne impemuhat din is kineupiyahan he vahin diyà te Megbevayà. Nelipey is Nengazen ki Abel wey zuen te pemuhat din, ");
INSERT INTO mbbOT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","piru wazè din mulà dewata si Cain wey is kandin he impemuhat. Ne zutun utew nepauk si Cain ne mibmerembunut is dagwey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ne migkaǥi zutun is Nengazen diyà te ki Cain te, “Maan is utew ka egkepauk wey maan is mibmerembunut is dagwey nu? ");
INSERT INTO mbbOT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Su emun hustu is ed-ul-ulahan nu edewaten ku sikew; ne emun kenà, melemu ka ebpekesalà, su is salà ne iring te kumekaid he langgam he ed-ayan kenikew keniyan te ǥemawan. Utew zin egkesuati he mezaag ke zin, iyan, kinahanglan he iyan ka edaag kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Sevaha zutun he andew, migkaǥi si Cain diyà te hazi zin he si Abel te, “Edhendiyè ki te vevesukà.” Ne hein diyè dan en, midhimetayan ni Cain si Abel. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ne mid-insaan te Nengazen si Cain te, “Hendei is hazi nu he si Abel?” Ne midtavak si Cain te, “Hanew ta. Bantey e ve te hazi ku?” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ne migkeǥiyan te Megbevayà si Cain te, “Utew mezaat is mid-ulaula nu! Is lengesa te hazi nu ne henduen be te ebpehizuhizu he edsilutan ku is etew he midhimatey kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ne ǥuntaan tenged te mid-ulaula nu, edrewakan ku sikew ne edhimuwen ku he kenè ke en ebpekevasuk kayi te tanà su netiǥisan is tanà te lengesa te hazi nu he mibunù nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Minsan duen ibpemula nu kayi te tanà ne ebpengelinteuwan ku he kenè en ebeǥasan heini. Wazè en egketendù he egkeubpaan nu umbe ebpekeriǥuriǥu ke zà te minsan hendei zini te lumpad.” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ne zutun migkaǥi si Cain diyà te Nengazen te, “Utew meveǥat is silut nu kediey. Kenè ku egkaantus. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Midsegseg a kenikew kayi he tanà wey nekepekeziyù ad kenikew. Ne wazè en egketendù he egkeubpaan ku, umbe ebpekeriǥuriǥu a zini te lumpad. Ne egkehimu he edhimetayan a te minsan hentei he egkeuma ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ne midtavak kandin dutun is Nengazen te, “Kenà egkehimu su ebpengelinteuwan ku he ke zuen edhimatey kenikew, Cain, ne kepipitu ku edtekepa is keveǥat te silut ku kandin.” Ne zutun midtuusan si Cain te Nengazen ne zutun ke egkeuma sikandin te minsan hentei ne egkeehè dan haazà is tuus ne kenè dan edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ne mibpekeziyù si Cain te Nengazen, ne ziyà med-ubpà te tanà he Nod he ziyà te zapit te edsilaan te Eden. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ne mid-uvayan ni Cain is esawa zin ne mibmeǥingey ne in-anak din is batà he maama ne migngezanan dan te Enoc. Ne midtukud dutun si Cain te inged ne migngezanan din te Enoc su in-iring din te ngazan te anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ne hein neuǥet nevuwad daan si Enoc ne nehimu sikandin he amey ni Irad. Ne si Irad, amey ni Mehuel; ne si Mehuel amey ni Metushael; ne si Metushael, ne amey ni Lamec. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dezuwa is esawa ni Lamec, is sevaha, ne iyan si Ada, ne is sevaha, ne iyan si Zila. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","In-anak ni Ada si Jabal he iyan nehuna te langun he ed-elima te menge ayam wey ed-ubpà te menge tulda. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Duen hazi ni Jabal he maama ne iyan ngazan din si Jubal, he nehuna te langun he metau he ebpen alpa wey ebpemulalà. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Zila mid-anak daan te maama ne iyan ngazan din si Tubal Cain he iyan dengan utew metau he pandey te ǥalang wey putew. Ne is etevey ni Tubal Cain ne iyan si Naama. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ne zutun he andew migkaǥi si Lamec diyà te menge esawa zin te, “He Ada wey Zila, pemineg kew te egkeǥiyen ku. Midhimetayan ku is kengkenakan he midrasey wey mibpalì kedì. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ne emun kepipitu egketakep is silut te edhimatey ki Cain, ne 77 is kegketakep is silut te edhimatey kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ne mid-umanan ni Adan uvayi is esawa zin he si Eva, ne mid-anak te maama, ne migngezanan din ki Set, he ke và dà egkeǥiya, imbeǥey, su ke sikandin te, “Mibeǥayan a te Megbevayà te anak he ilis ki Abel.” Umbe iyan heini mid-ulaula te Megbevayà su mibunù ni Cain si Abel. ");
INSERT INTO mbbOT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ne hein neuǥet, nevuwad daan si Set te maama ne migngezanan din ki Enosh. Iyan haazà timpu zengan he ebpuunan te menge etew is paaǥi te ked-azap he egemiten is ngazan te Nengazen dutun te kebpengumew-umew zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iyan heini keguǥuza te menge kevuwazan ni Adan. Dutun te kedlimbaǥa te Megbevayà te menusiyà, midhimu zin is etew iring te kandin he zagwey. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Maama wey vahi is midlimbag din. Ne hein nepasad din, midtuvazan din sikandan, ne migngezanan din sikandan he “menusiyà”. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Hein 130 en is penuiǥen ni Adan nevuwad sikandin te maama he utew midsempù kandin ne migngezanan din ki Set. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ne puun dutun te ked-enaka ki Set, 800 pa he tuig is keluǥayad te untung ni Adan, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ne hein 930 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hein 105 en is penuiǥen ni Set nevuwad sikandin ki Enosh. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ne puun dutun te ked-enaka ki Enosh, 807 pa he tuig is keluǥayad te untung ni Set, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ne hein 912 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Hein 90 en is penuiǥen ni Enosh nevuwad sikandin ki Kenan. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ne puun dutun te ked-enaka ki Kenan, 815 pa he tuig is keluǥayad te untung ni Enosh, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ne hein 905 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Hein 70 en is penuiǥen ni Kenan nevuwad sikandin ki Mahalalel. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ne puun dutun te ked-enaka ki Mahalalel, 840 pa he tuig is keluǥayad te untung ni Kenan, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ne hein 910 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Hein 65 en is penuiǥen ni Mahalalel nevuwad sikandin ki Jared. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ne puun dutun te ked-enaka ki Jared, 830 pa he tuig is keluǥayad te untung ni Mahalalel, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ne hein 895 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Hein 162 en is penuiǥen ni Jared nevuwad sikandin ki Enoc. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ne puun dutun te ked-enaka ki Enoc, 800 pa he tuig is keluǥayad te untung ni Jared, ne zuen duma pa zaan he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ne hein 962 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hein 65 en is penuiǥen ni Enoc nevuwad sikandin ki Metusela. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Ne puun dutun te ked-enaka ki Metusela, 300 pa he tuig is keluǥayad te untung ni Enoc, ne zuen duma pa zaan he menge anak din he vahi wey maama. Dutun he timpu utew meupiya is kedepità ni Enoc wey Megbevayà, umbe nekeuma te 365 is keluǥayad te untung din ne nahanew sikandin, su midtulus sikandin te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Hein 187 en is penuiǥen ni Metusela nevuwad sikandin ki Lamec. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ne puun dutun te ked-enaka ki Lamec, 782 pa he tuig is keluǥayad te untung ni Metusela, ne zuen duma pa zaan he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ne hein 969 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hein 182 en is penuiǥen ni Lamec nevuwad sikandin te maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ne migngezanan din ki Noe su ke sikandin te, “Pinaaǥi kayi te vatà malù ebmahagkap is meveǥat he terebahu tew te kebasuk he imbeǥey kenitew tenged te midrewakan dengan te Nengazen is tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ne puun dutun te ked-enaka ki Noe, 595 pa he tuig is keluǥayad te untung ni Lamec, ne zuen duma pa zaan he menge anak din he vahi wey maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ne hein 777 en he tuig is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Hein 500 en is penuiǥen ni Noe nevuwad sikandin ki Shem, ki Ham, wey ki Jafet. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ne hein mibmezakel en utew is menge etew zini te kelibutan wey zuen en menge anak dan he vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Naahà duen te menge anak te Megbevayà he memekempet is menge vahi he anak te menge etew, ne mid-esawa zan dutun is menge vahi sumalà is egkesuatan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ne migkaǥi zutun is Nengazen te, “Haaza is gehinawa ku he imbeǥey ku ziyà te menusiyà, kenè ku idtuǥut he wazà pidtemanan te kedtuvey zin diyà te kandan, su menge etew zà duen sikandan. Ne tenged dutun, edhimuwen ku he puun guntaan, iyan kelugayad te untung din is 120 dà he tuig.” ");
INSERT INTO mbbOT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ne zutun he timpu hein neked-esawa is menge anak te Megbevayà wey is menge vahi he anak te etew, pinaaǥi zutun duen in-anak dini te tanà he menge etew he egngezanan te Nefilim. Ne haazà is menge Nefilim, ne utew menge ǥemhanan he etew ne utew zan nengevantug dengan. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ne naahà te Nengazen he utew mezakel is menge kelelalung he ebeelan te menge etew wey iyan dà layun ed-isipen wey ed-ul-ulahan dan is mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ne neisip din he zeyzey pezem ke wazè din limbaǥa is menusiyà ne utew sikandin dutun neseeng. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Umbe ke sikandin te, “Edlumpiyuwan ku is kelibutan su edlimasen ku zutun is menge etew he linimbag ku. Edhimetayan ku is menge etew, menge langgam, menge keranapranap wey is menge tagbis he ziyà te hewhewanan, su deyzey pa pezem ke wazè ku sikandan limbaǥa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Iyan, si Noe mulà, nekepenunuat sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iyan heini guǥud mehitenged te pemilya ni Noe. Metazeng he etew si Noe. Dutun he timpu iyan dà sikandin etew he wazà igkesawey zuen; utew sikandin mibpekid-emiǥu te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tetelu is anak din he maama: si Shem, si Ham, wey si Jafet. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Naahà te Megbevayà he utew meremerik is menge ulaula te tivuuk he menusiyà wey utew kenà memetazeng is menge vaal zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Neehè din he utew lalung iyan is menge etew su nehimu en is menge ulaula te minsan hentei zini te kelibutan he utew en meremerik, ");
INSERT INTO mbbOT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ne migkaǥi sikandin diyà te ki Noe te, “Neisip ku en he edlimasen ku is tivuuk he menusiyà. Su tenged kandan, nekeeneb te kelibutan is kelelalung, ne tenged dutun id-awè ku sikandan dini te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Baal ka te arka he kayu he sipru. Beeli nu zutun te arka is menge ruǥu ne pezeketi nu te merumiket he sulù is seled din wey is gawas din. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Is paaǥi te kebeeli nu zuen, ne iyan heini: 450 he giek is belavag din, 75 he giek is keluaǥan din, ne 45 he giek is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Beeli nu is sulawà te arka he senge siku is elang din puun dutun te atep ne ziyà te kilid te arka beeli niw is gemawan. Tetelu he endana is dutun te arka; duen diyà te zivavew, duen diyà te zizalem, wey zuen daan diyà te teliwazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Su ibpelapey ku is langun he menge wahig dini te tanà su wey melimas is minsan hengkey he egeǥehinawa zini te kelibutan. Ne egkeǥerà is minsan hengkey zini te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Iyan, sikew mulà, edhimuwen ku is utew melig-en he kebpekid-uyun ku kenikew. Ne ibpeseled ku sikew zuen te arka zuma is menge anak nu wey is esawa nu wey is menge ambey nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ne ibpeseled nu zaan duma keniyu zutun te arka is langun he kelasi te menge linimbag he egeǥehinawa su wey kenè dan daan melimas. Tig-dezuwa te kada kelasi is ibpedparis niw he meemahan wey vehiyan. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Is menge tagbis daan sumalà is kelasi zan wey is menge langgam sumalà daan is kelasi zan wey is menge keranapranap daan sumalà is kelasi zan, tig-dezuwa te langun dutun is edhendiyan te kenikew su wey kenè dan melimas. ");
INSERT INTO mbbOT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ne sikew, kinahanglan he idseled nu zaan is minsan hengkey he kelasi te egkeenen su wey zuen egkeenen niw, wey egkeenen daan te menge langgam wey menge keranapranap.” ");
INSERT INTO mbbOT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ne midtuman ni Noe is langun he insuǥù kandin te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ne zutun migkaǥi is Nengazen diyà te ki Noe te, “Sikew, wey is tivuuk he pemilya nu, seled kew en diyà te arka, su iyan ke zà neehè ku he metazeng he etew te langun he menge etew ǥuntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ipeseled nu zaan dutun is pitu he perisan te langun he menge langgam he lumpiyu. Ne haazà is menge langgam he kenà lumpiyu senge paris dà mulà is ibpeseled nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ne kuwa ka zaan te ebpemenlayang diyà te hewhewanan, he pitu he perisan ne ipeseled nu ziyan su wey zuen egkesamà he egkevuwad diyan te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Su egkepasad is pitu he andew puun guntaan, ibpeuzanan ku is tivuuk he kelibutan, taman te 40 he andew wey 40 he kezukileman, su wey melimas is minsan hengkey he egeǥehinawa he linimbag ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ne sumalà is insuǥù ki Noe te Nengazen iyan daan mibeelan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mibpenuiǥen dutun si Noe te 600 he tuig hein kedlapey te wahig dini te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ne si Noe, is menge anak din, wey is esawa zin, wey menge ambey zin, ne midseled dan dutun te arka su wey zan melibri zutun te kedlapey te menge wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Sumalà te insuǥù te Megbevayà ki Noe, impeseled din diyà te arka is tigsenge perisan te langun he menge langgam he lumpiyu wey kenà lumpiyu he midhendiyà te kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ne hein netuman en haazà is pitu he andew, midlapey is menge wahig diyà te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mibpenuiǥen dutun si Noe te 600 he tuig. Ne hein ike-17 he andew te ikezuwa he vulan, mid-uzan te utew mereǥes wey midlepew zutun is utew zekelà he wahig he edtudà he ebpuun diyà te utew mezalem he zaǥat, ne ingkevusbus daan is utew zekelà he wahig he ziyà ebpuun te hewhewanan. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ne mid-uzanan is kelibutan taman te 40 he andew wey 40 he kezukileman. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ne zutun te andew he mibpuun en is uzan, si Noe wey is esawa zin, duma te menge anak din he si Shem, si Ham, wey si Jafet wey is menge esawa zan, midseled dan dutun te arka. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Elin daan impeseled dutun is langun he kelasi te menge langgam: he edhipanew, ebpemenanap, wey is ebpemenlayang. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Sumalà te insuǥù te Megbevayà ki Noe, impeseled din diyà te arka is tigsenge paris he kelasi te langgam he mid-uvey ziyà te kandin. Ne midlekevan te Nengazen haazà is arka. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Midsigudu med-uzan kayi te kelibutan seled te 40 he andew. Mibmezalem is wahig taman te midletew sikan is arka. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ne mid-iseg pa utew mebmezalem haazà is wahig ne nesapal is langun he memetikang he menge vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ne mid-iseg pa zaan memezalem taman te menge 20 he ǥiek is kezalem din diyà te puntur te utew metikang he vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ne nelimas dutun is minsan hengkey he menge linimbag he egeǥehinawa zini te lumpad. Is menge tagbis, menge ayam, menge leew he langgam, menge keranapranap, wey is tivuuk he menusiyà, nelimas dutun is langun. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mibpatey zutun is minsan hengkey he egeǥehinawa he ed-ubpà dini te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Midlimas te Megbevayà is minsan hengkey he egeǥehinawa he ed-ubpà dini te kelibutan: etew, langgam, keranapranap, wey is menge tagbis. Iyan dà nelibri si Noe wey is menge zuma zin diyà te seled te arka. ");
INSERT INTO mbbOT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ne taman te 150 he andew zutun, wazà tanà he nekelepew su nelapew haazà te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Wazà melipati te Megbevayà si Noe wey is duma zin he menge langgam he zutun te seled te arka. Umbe impepengeramag din kayi te kelibutan ne midnaneynaney mebmevavew is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Mid-engked haazà is kedtudà te wahig he ebpuun te utew mezalem he zaǥat ne mid-engked daan is kegkevusbus te utew zekelà he wahig he ziyà ebpuun te hewhewanan, ne midtikdew haazà is utew mereǥes he uzan. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ne zutun mid-iseg is kebmevavew te wahig taman te neuma is 150 he andew puun te kedlapey. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ne hein ike-17 he andew te ikepitu he vulan, diyà mekesavuk is arka te Buntud he Ararat. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mid-iseg mebmevavew is wahig taman te ike-10 he vulan. Ne zutun te egkehuna he andew te ikesepulù he vulan, egkeehè en is menge puntur te menge vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kedlavey te 40 he andew, mibpuwasan ni Noe is sulawà duen te arka ");
INSERT INTO mbbOT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ne zuen uwak he impelayang din. Ne haazà is uwak wazà medlikù su midtulung dà medlayanglayang taman te wazè pa memezahi is tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ne impelayang en daan ni Noe is limuken su ed-ahaan din ke wazè en wahig diyà te tanà, ");
INSERT INTO mbbOT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","piru wazà naahà duen te limuken he egkeletunan din su kemulu pa is wahig nekeeneb te tivuuk he kelibutan. Umbe midlikù haazà is limuken diyà te ki Noe ziyà te arka. Ne impelatun ni Noe haazà is limuken diyà te velad din. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ne midtaǥad pa si Noe te pitu he andew ne impelayang din en maan haazà is limuken he ebpuun te arka. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ne hein mahapun en dutun, midlikù haazà is limuken he ebangà te mehilew he zahun te kayu he ulibu. Ne netuenan dutun ni Noe he midtighak en is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ne midtaǥad pa maan si Noe te pitu pa he andew zutun, ne impelayang din en maan haazà is limuken, piru wazè en medlikù diyà te kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ne 601 en is penuiǥen ni Noe. Ne zutun te egkehuna he andew te nehuna he vulan, wazè en wahig diyà te tanà. Ne in-awà dutun ni Noe is atep duen te arka ne neehè din he nemezahan en iyan is tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hein iyan en ike-27 he andew zutun te ikezuwa he vulan, nemezahan en is tivuuk he kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ne zutun migkaǥi is Megbevayà diyà te ki Noe, ke sikandin te, ");
INSERT INTO mbbOT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Liǥawang kew en keniyan te arka. Dumaha nu is esawa nu, is menge anak nu, wey is menge ambey nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ipeliǥawang nu zaan haazà is langun he menge linimbag he menge langgam wey menge keranapranap, su wey mengevuwad sikandan wey zan meeneb is tivuuk he kelibutan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ne zutun migawas si Noe duma is menge anak din, wey esawa zin, wey menge ambey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ne migawas daan dutun is kada paris te langun he menge kelasi te egeǥehinawa sumalà is kelasi zan: menge langgam, menge keranapranap, wey menge tagbis. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ne mibaal si Noe te pemuhatà para te Nengazen. Ne migkuwa zin dutun te menge langgam is lumpiyu ragkes daan is kada kelasi te menge lumpiyu he tagbis, ne midtutung din heini zutun te pemuhatà he iyan pemuhat para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ne nahazek te Nengazen is kehemut te evel zutun, ne ke sikandin diyà te ǥehinawa zin te, “Kenè ku en maan edezeetan is menusiyà, minsan netuenan ku en he mekesesalà sikandan puun pa te ked-enaka kandan. Kenè ku en maan ed-umanan edlimasa iring te mibeelan ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Taman en te kenè pa egkehanew is kelibutan, kenà egkehimu he edhelinen ku is menge timpu, kekenà, ibpaaǥi ku zed is timpu te kebpemula wey tiraǥun, is timpu te meǥenew wey meinit, is timpu te ǥulavung wey tipenguzan, is maandew wey mezukilem.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ne zutun midtuvazan te Megbevayà si Noe wey is menge anak din, ne ke sikandin te, “Mevuwad kew ne mebmahabet kew utew su wey meeneb is kelibutan te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Utew egkehandek keniyu is langun he menge langgam: is ebpemenhipanew, is ebpemenlayang, is ebpemenanap, wey is diyà ebpen-ubpà te wahig. Iyan kew ebayàbayà kandan te langun. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Is minsan hengkey he linimbag he ebpekewaleng he egeǥehinawa, ne idtuǥut ku he egkeenen niw su ibeǥey ku en keniyu, iring te kebeǥaya ku zengan keniyu te menge sagbet. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Piru kenè niw keena is langgam he wazè pa maawà dutun is lengesa zin, he iyan igkeuyag din. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ke zuen etew wey minsan langgam he ibpetiǥis din is lengesa niw te menusiyà wey kew mebpatey, ebelesan ku. Ebelesan ku is minsan hentei he ebunù te zuma zin he etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ke zuen etew he edhimatey te zuma zin he etew edhimetayan daan sikandin te zuma zin he etew. Su midlimbag te Megbevayà is etew he iring te zagwey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ne mesigudu kew mevuwad wey kew mebmezakel ne wey kew mekeeneb te tivuuk he kelibutan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ne migkaǥi pa is Megbevayà diyà te ki Noe wey ziyà te menge anak din te, ");
INSERT INTO mbbOT_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Edtukuzen ku en guntaan is kebpekid-uyun ku keniyu wey te menge kevuwazan niw, ");
INSERT INTO mbbOT_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","wey is minsan hengkey he linimbag ku he egeǥehinawa he zuma niw keniyan te arka, is menge tagbis, is menge ayam, is menge leew he menge langgam, wey is minsan hengkey zaan he linimbag ku zini te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ne iyan heini kebpekid-uyun ku keniyu: Kenè ku en maan edlimasen is langun he egeǥehinawa pinaaǥi te wahig. Kenè ku en maan edèdeetan is kelibutan pinaaǥi te wahig.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ne migkaǥi zaan is Megbevayà te, “Duen ibpeehè ku keniyu he egkehimu he tuus te wazà pidtemanan he kebpekid-uyun ku keniyu wey te langun he menge linimbag ku he egeǥehinawa he zuma niw he midlawang keniyan te arka. Ne iyan is: ");
INSERT INTO mbbOT_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Idsavuk ku en is belugtu ziyà te menge ǥapun he iyan tuus te kebpekid-uyun ku keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Emun edhimuwen ku he ebpenggapun ne egkeehè niw zutun is belugtu, ");
INSERT INTO mbbOT_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ne kenè ku edlipatan is kebpekid-uyun ku keniyu wey te langun he menge linimbag ku he egeǥehinawa, Kenè ku en maan ibpelapey is menge wahig para te kedlimasa te langun he menge linimbag he egeǥehinawa. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Emun egkeehè niw is belugtu ziyà te menge ǥapun, ed-ahaan ku zaan, ne edtenuzan ku is wazà pidtemanan he kebpekid-uyun ku keniyu te langun he linimbag ku ziyan te kelibutan he egeǥehinawa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ne migkaǥi zaan is Megbevayà diyà te ki Noe te, “Is belugtu, ne iyan tuus te kebpekid-uyun ku keniyu te langun he egeǥehinawa zini te kelibutan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Is menge anak ni Noe he migawas dutun te arka ne iyan si Shem, si Ham, wey si Jafet. (Nehimu si Ham he amey ni Canaan.) ");
INSERT INTO mbbOT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Iyan heini sikan is tetelu he anak ni Noe ne iyan sikandan menge kepuun te langun he menge etew he nekeeneb te tivuuk he kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Si Noe sevaha te menge te perevasuk, ne iyan sikandin nehuna he nekepemula te paras. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sevaha zutun he andew, mid-inum sikandin te vinu he zutun ebpuun te menge pinemula zin he paras, ne nelangut sikandin ne midhizeǥà he nelevasan diyà te tulda zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Si Ham (is amey ni Canaan), mid-ehè din is amey zin he nelevasan ne midtudtulan din is menge kakey zin he ziyè pa te ǥawas te valey. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Iyan, si Shem wey si Jafet mulà, migkuwa zan te malung ne insinabley zan ne midseled dan dutun is ed-endud ne midtembunan dan is amey zan he nelevasan. Wazè dan tengtengi sikandin su wey kenè dan maahà haazà is amey zan he nelevasan. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ne hein nepukew si Noe zutun te kegkelangut din, ne netuenan din ke hengkey is mibeelan kandin te anak din he hazi, ");
INSERT INTO mbbOT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ke sikandin te, “Berakat he rewaki ka te Megbevayà, Canaan. Mehimu ka he uripen te menge suled nu, ne mehimu he utew minus is pid-etawan nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ne migkaǥi zaan sikandin te, “Berakat daan he zeliǥa is Nengazen he iyan Megbevayà ni Shem! Ne verakat he mehimu he uripen ni Shem si Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Berakat daan he utew meluag is tanà he ebpeubpaan te Megbevayà te menge kevuwazan ni Jafet, ne berakat he ikeǥalew sikandan te menge kevuwazan ni Shem, iyan, uripen dan mulà si Canaan,” ke si Noe. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ne puun dutun te kedlapey te zaǥat, 350 pa he tuig is keluǥayad te untung ni Noe. ");
INSERT INTO mbbOT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ne hein 777 en is penuiǥen din, minatey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Si Shem, si Ham, wey si Jafet, iyan heini guǥud te menge kevuwazan dan he impenganak dutun te timpu hein neipus en is kedlapey te zaǥat. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iyan heini menge anak ni Jafet he menge maama: si Gomer, Magog, Madai, Javan, Tubal, Meshec, wey si Tiras. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Is menge kevuwazan ni Gomer ne iyan si Ashkenaz, Rifat, wey Togarma. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Is menge anak ni Javan ne iyan si Elisha, Tarshish, Kitim, wey si Dodanim. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Iyan heini kevuwazan ni Jafet. Iyan sikandan mibpuunan te menge tribu he ziyà med-ubpà te veyvey te zaǥat. Is kada pemilya zan ne ziyà med-ubpà te keugelingen dan he inged he sakup te nasyun dan, wey zuen dan keugelingen he kineǥiyan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Is menge anak ni Ham he menge maama: si Cush, Mizraim, Put, wey si Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Si Cush ne zuen din menge anak he iyan heini si Sheba, Havila, Sabta, Raama, wey si Sabteca. Ne iyan heini menge anak ni Raama, si Sheba wey si Dedan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Duen pa sevaha he anak ni Cush he iyan ngazan din si Nimrod. Si Nimrod nehimu he gemhanan he etew kayi te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nevantug si Nimrod he mengenganup tenged te intuǥut haazà kandin te Nengazen. Ne tenged dutun, duen layun dan egkekaǥi zengan he ke sikandan te, “Iring ki Nimrod is utew nevantug he mengenganup su iyan intuǥut kandin te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Iyan menge zekelà he inged diyà te ǥinhedian din is Babilonia, is Erec, wey is Acad, he menge inged diyà te tanà he sakup te Shinar. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mid-awà si Nimrod dutun ne midhendiyà te Asiria ne zutun midtukud din is menge inged he Nineve, Rehobot Ir, Cala ");
INSERT INTO mbbOT_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","wey Resen he ziyà te pid-elangan te Nineve wey Cala, he iyan nevantug he inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Mizraim, ne iyan kepuun te menge Ludhanen, menge Anamnen, menge Lihabnen, menge Naftanen, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","menge Patrusnen, menge Caslunen, wey is menge Caftornen he iyan menge kepuun te menge Filistihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Canaan iyan amey ni Sidon wey ni Het. Ne iyan kakey si Sidon. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kepuun daan si Canaan te menge Jebusihanen, menge Amorihanen, menge Girgasihanen, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","menge Hivihanen, menge Erekihanen, menge Sinihanen, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","menge Arbedihanen, menge Simarihanen, wey menge Hamatihanen. Hein neuǥet, nekedsisivey is menge kepuun he menge kevuwazan ni Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Is dulunà te menge tanè dan diyà te zivavà, puun te Sidon pehendiyà te Gerar ne nekeuma heini ziyà te Gasa. Is dulunà diyà te edsilaan nekeuma ziyà te Sodom, Gomora, Adma, wey Zeboyim taman te Lasha. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Iyan heini menge kevuwazan ni Ham. Is kada pemilya zan ne ziyà med-ubpà te keugelingen dan he inged he sakup te nasyun dan, wey zuen dan keugelingen he kineǥiyan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Shem ne kakey ni Jafet he iyan kepuun te langun he menge kevuwazan ni Eber. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Is menge anak ni Shem he menge maama iyan si Elam, si Ashur, si Arfaxad, si Lud, wey si Aram. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Is menge anak ni Aram iyan si Uz, si Hul, si Geter, wey si Meshec. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ne si Arfaxad ne iyan amey ni Shela, ne si Shela ne iyan amey ni Eber. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Dezuwa is menge anak ni Eber. Is sevaha, ne migngezanan ki Peleg, he ke và dà egkeǥiya, “kebpekedsusuwey”, su zutun he timpu nekedsusuwey is menge etew zini te lumpad. Is hazi zin ne migngezanan ki Joktan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joktan ne iyan amey ni Almodad, Shelef, Hazarmavet, Jera, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO mbbOT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, wey Jobab. Heini is langun, ne menge anak ni Joktan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Is netemanan te tanà he mid-ubpaan dan ne puun diyà te inged he Mesha pehendiyà te inged he Sefar he ziyà te menge vuvungan te zapit te edsilaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Iyan heini menge kevuwazan ni Shem. Is kada pemilya zan ne ziyà med-ubpà te keugelingen dan he inged he sakup te nasyun dan, wey zuen dan keugelingen he kineǥiyan. ");
INSERT INTO mbbOT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Iyan heini menge kevuwazan te menge anak ni Noe. Heini sikandan ne nekedsisivey zan te neubpaan he menge nasyun. Tenged kandan, netukud is menge nasyun kayi te tivuuk he kelibutan hein neiwas is kedlapey te zaǥat. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ne zutun he timpu, sebsevaha pa is kineǥiyan te langun he menge etew te tivuuk he kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ne zutun te kedhalinhalin te menge etew pehendiyà te zapit te edsilaan, neehè dan is meluag he menge suǥud diyà te Shinar, ne zutun dan med-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Ne zutun, pesikaǥi zan te, “Ebaal kiw te sevaha he inged he zuen turi he ebpekeuma ziyà te langit, para mehimu kiw he bentuǥan wey para zaan kenè kiw mekedsusuwey kayi te tivuuk he kelibutan.” Umbe mibaal sikandan te brik, ne mid-init dan heini para mebmezesen utew. Brik is migamit dan batu man pezem. Ispaltu is migamit dan wey mekedezeket haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ne zutun, mibulus is Nengazen su ed-ahaan din is mibeelan te etew he inged wey turi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Migkaǥi sikandin te, “Heini he menge etew, nesevaha zan wey sevaha zà is kineǥiyan dan. Ne heini is mibeelan dan ne puunè pa heini. Kenà egkeuǥet ne ebeelan dan is minsan hengkey he egkesuatan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kuwa kew en, edhendiyè kiw, ne ibpedseselekawè tew is kineǥiyan dan su wey zuen mezakel he menge kineǥiyan su wey kenè dan mekedsesevutà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Umbe mibpedsusuwey te sikandan te Nengazen kayi te tivuuk he kelibutan, ne neengkezan dan is kedtukud dan te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Umbe, migngezanan haazà is inged he Babel, he ke và dà egkeǥiya, “Kegkengeliveǥi,” su zutun impedseselekawà te Nengazen is kineǥiyan te tivuuk he menusiyà. Ne puun dutun midhimu te Megbevayà he mekedsusuwey sikandan pehendiyà te minsan hendei zini te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iyan heini guǥud mehitenged te pemilya ni Shem. Hein menge dezuwe en he tuig puun dutun te timpu te kegkeiwas en te kedlapey te zaǥat, 100 en is penuiǥen ni Shem, ne zutun nevuwad sikandin ki Arfaxad. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ne puun dutun te ked-enaka ki Arfaxad, 500 pa he tuig is keluǥayad te untung ni Shem, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Hein 105 en is penuiǥen ni Arfaxad nevuwad sikandin ki Shela. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ne puun dutun te ked-enaka ki Shela, 403 pa he tuig is keluǥayad te untung ni Arfaxad, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Hein 30 en is penuiǥen Shela ne nevuwad sikandin ki Eber. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ne puun dutun te ked-enaka ki Eber, 403 pa he tuig is keluǥayad te untung ni Shela, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Hein 34 en is penuiǥen ni Eber ne nevuwad sikandin ki Peleg. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ne puun dutun te ked-enaka ki Peleg, 403 pa is keluǥayad te untung ni Eber, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Hein 30 en is penuiǥen ni Peleg ne nevuwad sikandin ki Reu. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ne puun dutun te ked-enaka ki Reu, 209 pa he tuig is keluǥayad te untung ni Peleg, ne zuen duma pa he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Hein 32 en is penuiǥen ni Reu ne nevuwad sikandin ki Serug. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ne puun dutun te ked-enaka ki Serug, 207 pa he tuig is keluǥayad te untung ni Reu, ne zuen duma pa zaan he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Hein 30 en is penuiǥen ni Serug ne nevuwad sikandin ki Nahor. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ne puun dutun te ked-enaka ki Nahor, 200 pa he tuig is keluǥayad te untung ni Serug, ne zuen duma pa zaan he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Hein 29 en is penuiǥen Nahor ne nevuwad sikandin ki Tera. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ne puun dutun te ked-enaka ki Tera, 119 pa he tuig is keluǥayad te untung ni Nahor, ne zuen duma pa zaan he menge anak din he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Hein 70 is penuiǥen ni Tera ne nevuwad sikandin ki Abram, Nahor, wey si Haran. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iyan heini guǥud mehitenged te pemilya ni Tera. Si Tera, iyan amey eni Abram, si Nahor, wey si Haran. Ne si Haran, ne nevuwad sikandin ki Lot. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ne hein kemulu pa uuyag si Tera minatey is anak din he si Haran diyà te Ur he iyan inged dan te menge Kildiyanhen he zutun si Haran ianak. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ne mibpengesawa si Abram wey si Nahor. Iyan esawa ni Abram si Sarai, ne iyan esawa ni Nahor si Milca. Anak si Milca ni Haran te amey zaan ni Isca. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ne si Sarai, kenà ed-anak umbe wazè din menge anak. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ne midumahan ni Tera is anak din he si Abram, is ambey zin he si Sarai, wey is apù din he si Lot he anak ni Haran, ne mid-awè dan diyà te Ur he sakup te inged te menge Kildiyanhen su edhendiyè dan pezem te Canaan. Piru hein nekeuma zan diyà te inged he Haran, diyè dan dà med-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ne ziyà en mebpatey si Tera te Haran hein mibpenuiǥen sikandin te 205 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ne migkaǥi is Nengazen diyà te ki Abram te, “Ewai nu is inged nu, wey is menge kezuzumahi nu, wey is menge pemilya te amey nu, ne hendiyà ka te inged he ibpeehè ku kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Edhimuwen ku is menge kevuwazan nu he utew zekelà he nasyun. Ne edtuvazan ku sikew ne edhimuwen ku he utew mevantug is ngazan nu. Ne pinaaǥi zaan kenikew, edtuvazan ku is mezakel he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Is menge etew he edtavang kenikew, edtuvazan ku. Is menge etew he ebpesipala kenikew, edrewakan ku. Ne pinaaǥi kenikew edtuvazan ku te meupiya is langun he menge etew ziyan te kelibutan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ne zutun, migenat si Abram sumalà is insuǥù kandin te Nengazen ne miduma zaan si Lot. Menge 75 is penuiǥen ni Abram dutun te timpu te ked-awè din dutun te Haran. Miduma zin is esawa zin he si Sarai wey is enaken din he si Lot. Elin daan miduma zin is langun he menge etew he nengesakup dan hein diyè dan pa te Haran. Ne mid-uwit dan daan is langun he menge azen dan. Midhipanew sikandan pehendiyà te tanà he Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ne hein nekeuma zan diyà te Canaan midlaus pa ensi Abram taman te zekelà he kayu he More he ziyà te inged he Shekem. (Ne zutun he timpu iyan meǥinged dutun is menge kevuwazan ni Canaan.) ");
INSERT INTO mbbOT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ne mibpaahà is Nengazen ki Abram ne ke sikandin te, “Heini is tanà, ne ibeǥey ku ziyà te menge kevuwazan nu.” Ne zutun mibaal si Abram te pemuhatà su ebpemuhaten din is Nengazen he iyan mibpaahà kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ne midlaus pa ensi Abram pehendiyà te vuvungan he ziyà te zapit te edsilaan te inged he Betel ne zutun din ipehitindeg is tulda zin. Diyà te zapit din te edsenlepan is inged he Betel wey ziyà te zapit te edsilaan is inged he Ai. Ne zutun mid-uman si Abram mebaal te pemuhatà ne mibpengumew-umew zin is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ne zutun migenat en maan ensi Abram ne midlaus dan pa pehendiyà te tanà he egngezanan te Negev. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ne mid-aǥi is bitil zutun te tanà ne tenged dutun midhipanew si Abram pehendiyà te tanà he Ehipto su wey zan mekeubpà diyà. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ne hein meǥaan dan en ebpekeuma ziyà te Ehipto, migkeǥiyan din is esawa zin te, “Sikew, utew ka mekempet he vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ne emun egkeehè ka te menge Ehiptohanen siguradu egkaǥi zan te, ‘Esawa zin bes heini!’ Ne zutun, edhimetayan e zan, iyan, kenè ke zan mulà edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Keǥiya nu he etevey ku sikew su wey e zan mepurungi tenged kenikew ne kenè e zan edhimetayan tenged te etevey ku sikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ne hein nekeuma ensi Abram diyà te Ehipto, naahà iyan te menge Ehiptohanen he utew mekempet he vahi si Sarai. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ne is menge upisyal te hadì te Ehipto, hein neehè dan si Sarai, midtudtulan dan is hadì te utew mekempet sikandin he vahi ne mid-uwit si Sarai ziyà te turuǥan. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tenged ki Sarai mibpurungan dutun te hadì si Abram, ne mibeǥayan din si Abram te menge vaka, kerehidu, menge asnu he vehiyan wey meemahan, wey menge kemilyu, wey menge uripen he vahi wey maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Piru tenged ki Sarai, he esawa ni Abram, duen utew gerabi wey egkein-inuwan he zaru he imbeǥey te Nengazen diyà te hadì te Ehipto wey te langun he menge etew ziyà te turuǥan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ne netuenan duen te hadì te Ehipto, is hinungdan dutun te neulaula kandan, mid-umew zin si Abram ne ke sikandin te, “Utew mezaat is mid-ulaula nu kedì! Maan is wazè nu keǥiya he esawa nu si Sarai? ");
INSERT INTO mbbOT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Migkaǥi nu he etevey nu, ne migkuwa ku sikandin, su mid-esawa ku. Heini zed is esawa nu. Kuwaa nu ne awè kew kayi!” ");
INSERT INTO mbbOT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ne midsuǥù din is menge sundaru zin ne inhated dan si Abram wey esawa zin wey langun te menge azen dan pehendiyà te ǥawas dutun te ǥinhedian. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ne mid-awà ensi Abram dutun te Ehipto ne midlikù diyà te tanà he egngezanan te Negev, duma is esawa zin. Ne mid-uwit dan is langun he ketiǥeyunan dan. Ne miduma zaan kandan si Lot. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Utew en sepian si Abram su utew mezakel is menge ayam din wey mezakel is menge azen din he pelata wey vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ne puun dutun te Negev midhalinhalin sikandin taman te nekeuma en maan diyà te uvey te Betel he iyan sikan is daan he nesevukan te tulda zin he ziyà te pid-elangan te Betel wey Ai. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ne iyan daan haazà inged he zuen pemuhatà he mibeelan din dutun. Ne mid-umanan din dutun pengum-umawa is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ne si Lot daan he edumazuma ki Abram, duen daan menge uyaǥen din wey menge tulda. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ne tenged kayi kenà ereg is tanà he egkepenebtavan te langun he menge ayam dan ki Abram. Ne tenged te utew mezakel is menge sakup dan wey menge ayam dan, kenè en egkehimu he ebpeemurè dan dutun te tanà he ed-ubpaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ne tenged dutun, mibpetebtebekè en is menge bekidu ni Abram wey is menge bekidu ni Lot. (Ne kenà duen dà taman su zuen daan menge tribu he Canaanhen wey menge Pirisihanen he zaan he menge meǥinged dutun.) ");
INSERT INTO mbbOT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ne migkaǥi zutun si Abram diyà te ki Lot te, “Kenè ki edtebek ne kenà kinahanglan he ebpekedtebek is menge bekidu ta su enaken ku sikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Meupiya pa ke ebpesuwayè ki, su mezakel pa is lugar he egkehelinan, ne pilì ka, ke hendei is egkesuatan nu, emun iyan ebpilien nu is dapit te egkeǥivang ne ziyà a edhalin te zapit te egkekewanan. Piru ke iyan ebpilien nu is dapit he egkekewanan, ne ziyà a te zapit te egkeǥivang.” ");
INSERT INTO mbbOT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ne zutun mibpememantew si Lot ne neehè din he utew meupiya haazà is tanà he uvey te Suǥud he Jordan su mezakel is menge wahig dutun te zapit te inged he Zoar. Iring haazà te pemuleey te Eden sikan is pemuleey zengan te Nengazen wey iring daan te tanà he Ehipto. (Ne zutun he timpu wazè pa dèdeeti te Nengazen is menge inged he Sodom wey Gomora.) ");
INSERT INTO mbbOT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ne zutun mibpilì ni Lot haazà is tivuuk he Suǥud te Jordan ne midhipanew en sikandin dutun pehendiyà te zapit te edsilaan. Ne iyan haazà kebpesuwayè dan ki Abram. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ne si Abram, diyà sikandin med-ubpà te tanà he Canaan; ne si Lot mulà, diyà sikandin med-ubpà te menge inged diyà te menge suǥud he uvey te Sodom ne zutun ne ziyè din benguna is menge tulda zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ne is menge meǥinged dutun te Sodom, utew menge mekesesalà. Utew mezaat is menge salè dan he supak te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ne si Abram, hein mid-ewaan en sikandin ni Lot, migkeǥiyan sikandin te Nengazen te, “Pememantew ka puun diyan te edhitindeǥan nu ne ahaa nu is tanà he ziyà te zapit te edsilaan, wey ziyà te zapit te edsenlepan. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Is taman te egkeehè nu he tanà, ibeǥey ku kenikew wey ziyà te menge kevuwazan nu, ne egkaangken dan te taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne is menge kevuwazan nu, edhimuwen ku sikandan he iring te eliyavuk. Emun kenà egkevilang is eliyavuk, kenà egkevilang daan is menge kevuwazan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ne hipanew ka ne susiya nu is tivuuk he tanà su ibeǥey ku en heini kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ne zutun inhalin ni Abram is tulda zin, ne ziyà sikandin med-ubpà te uvey te menge kayu he ulayan ni Mamre he ziyà te Hebron, ne mibaal sikandin te pemuhatà para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ne iyan haazà timpu he iyan si Hadì Amrafel he hadì te Shinar, si Hadì Arioc he hadì te Elasar, si Hadì Kedorlaomer he hadì te Elam, wey si Hadì Tidal he hadì te Goyim. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Heini is menge hadì, ne midtebek dan ki Hadì Bera he hadì te Sodom, ki Hadì Birsha he hadì te Gomora, ki Hadì Shinab he hadì te Adma, ki Hadì Shemeber he hadì te Zeboyim, wey te hadì te Bela he iyan daan inged he Zoar. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Heini is lelima he hadì, ne midsevaha zan is menge sundaru zan diyà te Suǥud he Sidim he iyan guntaan sikan is Daǥat he Minatey. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Su heini is lelima he hadì, dutun he timpu, 12 he tuig, ne menge sakup sikandan ni Kedorlaomer, iyan, dutun te ike-13 he tuig ne midsukul sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ne zutun te ike-14 he tuig, mibpengayew si Kedorlaomer wey is menge zuma zin he hadì, ne midtebek dan wey nengezaag dan is menge Ripanhen diyà te Ashterot Karnaim, is menge Zuzhanen diyà te Ham, is menge Emhanen diyà te menge suǥud te Kiryataim, ");
INSERT INTO mbbOT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","wey is menge Hurhanen diyà te menge vuvungan he Seir taman te inged he El Paran he ziyà te uvey te tanà he sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ne zutun midlikù dan ne midhendiyè dan te inged he En Mishpat (he iyan Kadesh), ne nengezaag dan is menge meǥinged diyà te tivuuk he tanà te menge Amalikanhen ne nengezaag dan daan is menge Amorihanen diyà te inged he Hazazon Tamar. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ne zutun is menge hadì te Sodom, Gomora, Adma, Zeboyim, wey is hadì te Bela, midtiǥum dan is menge sundaru zan diyà te Suǥud he Sidim ");
INSERT INTO mbbOT_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ne nekidtebek dan ki Hadì Kedorlaomer he hadì te Elam, ki Hadì Tidal he hadì te Goyim, ki Hadì Amrafel he hadì te Shinar, wey ki Hadì Arioc he hadì te Elasar. Heepat he hadì is edtebeken te lelima. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ne haazà is Suǥud he Sidim, mezakel is menge vudsi zutun he nepenù te merumiket he espaltu. Ne nengezaag is menge sundaru te hadì te Sodom wey Gomora, ne hein mibpelaǥuy zan, nengeulug is duma kandan diyà te menge vudsi, is duma, ne mibpelaǥuy zan diyà te menge vuvungan. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ne zutun mibpenavan te heepat he hadì is langun he menge azen wey egkeenen te menge meǥinged te Sodom wey Gomora, ne midhipanew zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nevihag dan daan sikan is enaken ni Abram he si Lot ne mid-aǥew zan daan is langun he menge azen din, su ziyà sikandin med-ubpà te Sodom. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Duen sevaha he tig-Sodom he nekepelaǥuy, ne midhendiyà sikandin te Hebriyuhanen he si Abram ne impenudtul zin haazà is langun he neulaula. Dutun he timpu, ziyà si Abram med-ubpà te uvey te menge kayu he ulayan ni Mamre te Amorihanen. Heini si Mamre wey is menge suled din he si Iskul wey si Aner ne neupakat sikandan engki Abram. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ne hein nezineg ni Abram he nevihag is enaken din, midtiǥum din is 318 he sakup din he egkeseriǥan din. Heini sikandan, menge sakup din puun pa te ked-enaka kandan, ne miduma zin sikandan, ne midal-as dan sikan is heepat he hadì taman te inged he Dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ne hein mezukilem, mibahin ni Abram te dezuwa he grupu is menge sundaru zin. Ne zutun midsurung dan is menge kuntada zan, ne nezaag dan heini. Ne haazà is menge kuntada zan ne mibpemelaǥuy midal-as eni Abram taman te inged he Hoba, he ziyà te zapit te egkezizaya te inged he Damascus. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Midhawì ni Abram is langun he menge azen he nengaaǥew te menge kuntada. Ne midhawì din daan si Lot wey is langun he menge azen ni Lot. Elin daan midlibri zin is nengevihag he vahi wey is duma pa he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ne zutun te ed-ulì en si Abram he ebpuun te kedeeǥa zin ki Kedorlaomer wey is menge zuma he hadì, midsinuǥung sikandin te hadì te inged he Sodom. Diyè din sinuǥunga te Suǥud he Shave he egngezanan daan te Suǥud te Hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ne zuen hadì te inged he Salem he si Melkizedek he midsinuǥung daan kandan. Mid-uwit sikandin te supas wey vinu su ibpekaan din wey ibpeinum din ki Abram. Memumuhat si Melkizedek te Utew Lavew he Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mibpenubtuvazan din si Abram te egkaǥi te, “Berakat, Abram, he tuvazi ka te Utew Lavew he Megbevayà he nenlimbag te langit wey tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Deliǥa is Utew Lavew he Megbevayà, su midhimu zin he mekezaag ka te menge kuntada nu.” Ne zutun, imbeǥey kandin ni Abram is ikepulù he vahin te langun he netavan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ne zutun migkeǥiyan si Abram duen te hadì te Sodom te, “Is langun he menge azen dey he nahawì nu ne kenikew en, piru egkuwaan ku zed is langun he menge sakup ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ne midtavak si Abram te, “Ebpenangdù a kayi te etuvangan te Nengazen, te Utew Lavew he Megbevayà he iyan nenlimbag te langit wey tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Minsan tanur zà etawa hiket te sandalyas, ne kenè ku edewaten. Ne kenè ku egkuwaan is minsan hengkey he azen nu su kela ke mekekaǥi ka he iyan ka insepian ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kenè ku edewaten is minsan hengkey he para zà kedì. Iyan dà edewaten ku is nekaan en te menge sakup ku, kenè ku en id-ulì kenikew, ne iveǥey nu zaan is bahin te menge midtavang kediey he si Eshcol, si Aner, wey si Mamre.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ne hein neiwas haazà, mibpekidlalag ki Abram is Nengazen , ke sikandin te, “Abram, kenè ka mahandek, su edlevanan ku sikew wey ebeǥayan ku sikew te utew zekelà he suhul.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ne midtavak dutun si Abram te, “Sikew is Nengazen he Megbevayà, wazà igkeveǥey nu kediey he ibmeupiya te ǥehinawa ku su kenè bes egkehimu he egkevuwad a, ne iyan ebpekepengevilin te menge azen ku si Eliezer he tig-Damascus.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ne impelaus pa ni Abram is egkeǥiyen din, ne ke sikandin te, “Geina te wazè nu himuwa he mevuwad a, iyan ebpekepengevilin te menge azen ku is suluǥuen ku zà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ne zutun midtavak kandin is Nengazen , ke sikandin te, “Kenà iyan heini si Eliezer ebpekepengevilin su iyan dà ebpekepengevilin te menge azen nu is hustu en he anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ne zutun impeǥawas din si Abram ne ke sikandin te, “Lingehè ka ziyà te langit ne vilanga nu is menge vituen emun egkevilang nu.” Ne ke sikandin daan te, “Iring keniyan is menge kevuwazan nu keuzemà su kenà sikandan egkengevilang.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ne zutun, tenged te midtuu si Abram te Nengazen , mid-isip sikandin te Nengazen he metazeng. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ne zutun migkaǥi is Nengazen te, “Iyan a sikan is Nengazen . Umbe impehendini ku sikew he ebpuun te inged he Ur te menge Kildiyanhen su wey ku ikeveǥey kenikew heini is tanà wey nu maangken.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ne zutun migkaǥi si Abram te, “He Nengazen he Megbevayà, hengkey is tuus wey ku metueni he egkaangken ku heini?” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ne midtavak dutun is Nengazen te, “Uwita nu zini is dumeraǥa he vaka, sevaha he vehiyan he kambing, wey sevaha he meemahan he kerehidu, tigtetelu he tuig is penuiǥen te uman sevaha kandan. Uwit ka zaan dini te sevaha he limuken wey sevaha he merepatik.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ne mid-uwit ni Abram haazà diyà te Nengazen , ne mibpemaas heini ni Abram ne imped-atbang din is kedsevuka zin dutun te kada vaas. Iyan dà wazè din baasa sikan is merepatik wey limuken. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ne zutun duen menge dezekelà he zumezaas he menge tagbis he midlatun dutun te mibaas, piru mibuǥew sikandan ni Abram. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ne hein edsanlep en is andew, Nekelipezeng si Abram he utew nehurep. Ne neǥezam din dutun is utew subra he kegkahandek. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ne migkeǥiyan sikandin dutun te Nengazen te, “Tentenuzi nu he is menge kevuwazan nu, ne egkehimu zan keuzemà he menge lumelengyawà ziyà te zuma he nasyun. Egkengeuripen sikandan wey ebpesipelahan sikandan seled te 400 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Piru haazà is nasyun he ed-uripen kandan, edsilutan ku ne zutun ebpekaawè dan, ne utew mezakel is menge azen dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sikew mulà, ebpekeluǥeyazen ku is untung nu; ebpatey ka tenged te keǥuǥurangi nu he melinawen. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ke heepat egkelapis is menge kevuwazan nu ziyà te senge nenasyun, ne human dan ed-ulì dini su wazè pa metuman is timpu te kedsiluti ku te menge Amorihanen tenged te menge salè dan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ne midsanlep en is andew ne mibmerusirem en, ne zuen migkivelat he naahà ni Abram he iring te kuzen he ed-evel wey egkeregreg he ziyà mebayà te pid-elangan dutun te mibaas he imped-aatbang. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ne zutun he andew, midtukud is Nengazen te kebpekid-uyun din ki Abram. Ke sikandin te, “Ibeǥey ku te menge kevuwazan nu heini he tanà. Puun diyà te wahig te Ehipto pehendiyà te zekelà he Wahig he Eufrates. ");
INSERT INTO mbbOT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Heini he tanà iyan guntaan ed-ubpaan te menge Kinhanen, menge Kinisihanen, menge Kidmunihanen, ");
INSERT INTO mbbOT_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","menge Hitihanen, menge Pirisihanen, menge Ripanhen, ");
INSERT INTO mbbOT_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","menge Amorihanen, menge tig-Canaan, menge Girgasihanen, wey menge Jebusihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ne si Sarai, sikan is esawa ni Abram, kenà ed-anak. Duen uripen din he Ehiptohanen he egngezanan ki Hagar. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ne migkaǥi si Sarai ziyà te ki Abram te, “Tenged te wazà ituǥut te Nengazen he mekaanak a, deyzey pa vuwa ke edhulizan nu is uripen ku, su kela ke egkehimu he pinaaǥi kandin duen ku zed menge anak.” Ne mid-uyun dutun si Abram te sambag ni Sarai. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","(Sepulù en he tuig dutun is ked-ubpà eni Abram diyà te tanà he Canaan.) Ne mibeyaan dutun ni Sarai haazà is uripen din he tig-Ehipto he si Hagar ne imbeǥey zin diyà te esawa zin wey zin meesawa. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ne midhulizan ni Abram si Hagar ne mibmeǥingey si Hagar. Ne si Hagar, hein nesavut din he meǥingey sikandin, mibpelevawan din is egalen din he si Sarai. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ne migkaǥi zutun si Sarai ziyà te ki Abram te, “Kenikew he salà heini is kebpelevawi kediey ni Hagar. Minsan pa te iyan a mibeǥey kandin diyan te kenikew, ebpelevawan e zin gihapun hein netuenan din he meǥingey en su kenè nu edewayen. Nesayud is Nengazen ke hentei kenita is ebpekevenar!” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ne midtavak dutun si Abram diyà te ki Sarai te, “Emun iyan heeyan, idlikù ku sikandin diyan te kenikew ne bayèbayè ka ke hengkey is ed-ul-ulahan nu kandin.” Ne puun dutun, kenà meupiya is ebelan ni Sarai ki Hagar, umbe hein neuǥet ne mibpelaǥuy sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ne zutun naahà si Hagar te velinsuǥuen te Nengazen diyà te uvey te serebseb he ziyà te sibsivayan. Iyan haazà sikan is serebseb he ziyà te zalan pehendiyà te inged he Shur. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ne mid-insaan dutun te velinsuǥuen sikandin te, “Hagar he suluǥuen ni Sarai, hendei ka ebpuun wey hendei ka ebpevayà?” Ne midtavak si Hagar te, “Ebpeleǥuyan ku is egalen ku he si Sarai.” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ne zutun migkaǥi ziyà te kandin is belinsuǥuen te Nengazen, ke sikandin te, “Ulì ka ziyà te egalen nu ne pevayàbayè ka kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ne migkaǥi zaan is belinsuǥuen te, “Edhimuwen ku he utew medmezakel keuzemà is menge kevuwazan nu, ne kenè dan egkengevilang.” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ne impelaus din is egkeǥiyen din kandin te, “Meǥingey ka, ne maama is id-anak nu. Ishmael is igngazan nu kandin, su nezineg te Nengazen is menge pengemuyù nu kandin tenged te merasey is egkeulaula nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ne heini is anak nu, iring sikandin keuzemà te asnu he leew su kenà ebpevayàbayà te minsan hentei. Ebpekigkuntada sikandin te minsan hentei ne egkuntedahan daan sikandin te langun. Minsan is langun he menge kezuzumahi zin, egkuntedahan din pa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Umbe migngezanan ni Hagar is Nengazen te, “El-roi,” su ke sikandin te, “Neehè ku ve is Megbevayà, ne kemulu e pa he uuyag guntaan?” ");
INSERT INTO mbbOT_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tenged dutun migngezanan haazà is kalut te Beer Lahai Roi, he ke và dà egkeǥiya, “Kalut te uuyag he Megbevayà he nekaahà kediey.” Kemulu pa haazà is kalut diyà te pid-elangan te inged he Kadesh wey inged he Bered. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ne mid-anak si Hagar te maama pinaaǥi ki Abram. Ne haazà is anak din, migngezanan ni Abram ki Ishmael. ");
INSERT INTO mbbOT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Is penuiǥen ni Abram ne 86 he tuig hein ked-enaka ni Hagar ki Ishmael. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ne hein 99 en is penuiǥen ni Abram, mibpaahà kandin is Nengazen ne migkaǥi kandin te, “Siak, iyan a Megbevayà he Mekeǥeǥehem. Sunuza nu is menge penurù ku ne kinahanglan he wazà igkesewayi kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Edtukuzen ku is kebpekid-uyun ku kenikew: ne edhimuwen ku he utew medmezakel is menge kevuwazan nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ne zutun midlangkeb si Abram diyà te tanà ne migkaǥi en maan kandin is Megbevayà te, ");
INSERT INTO mbbOT_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Iyan kebpekid-uyun ku kenikew is: Egkehimu ka he amey te langun he menge nasyun. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kenè ke en egngezanan ki Abram, kekenà, egngezanan ku en sikew ki Abraham, su edhimuwen ku sikew he kepuun te medmezakel he menge nasyun. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Edhimuwen ku he mepurung mevuwad is menge kevuwazan nu, ne egkehimu sikandan he zekelà he nasyun, ne is duma kandan ne egkehimu he menge hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Edtumanen ku is kebpekid-uyun ku kenikew wey te menge kevuwazan nu te peleebuten he lapis te kevuwazan, ne pedayun a he Megbevayè niw. Heini he kebpekid-uyun ku ne taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ne is tivuuk kayi he tanà te Canaan he mid-ubpaan nu ǥuntaan te lumelengyawà, ibeǥey ku heini kenikew wey ziyà te menge kevuwazan nu. Egkeangken niw heini te taman te taman, ne pedayun he iyan a Megbevayè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ne migkaǥi en maan is Megbevayà diyà te ki Abraham te, “Kenè nu lipati is kebpekid-uyun ku kenikew. Iyan daan heini meupiya he ed-ul-ulahan te menge kevuwazan nu te peleebuten he lapis te kevuwazan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ne mehitenged keniyan he kebpekid-uyun, kinahanglan he ebpesirkunsidar is langun he menge maama ziyan te keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kinahanglan he edsirkunsidaren is langun he menge maama, ne iyan haazà tuus te kebpekid-uyun ku keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Puun guntaan taman te peleebuten he lapis te kevuwazan, kinahanglan he sirkunsidara niw is menge vatà he menge maama zutun te ikewalu he andew puun te ked-enaka kandin. Sirkunsidara niw zaan is menge uripen niw he maama he neetew ziyà te valey niw ragkes is nengepemasa niw he ziyà ebpuun te zuma he menge inged. Heeyan he tuus te lawa niw, iyan tistiǥus he tutuu is kebpekid-uyun ku keniyu, ne kenà heini egkahanew taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ne ke zuen minsan hentei he maama he zuma niw he kenà ebpesirkunsidar, kenè niw en isipa he zuma niw sikandin, su wazè din ilelenged is kebpekid-uyun ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ne elin daan migkaǥi te Megbevayà diyà te ki Abraham is: “Ne haazà is esawa nu he si Sarai, kenè nu en ngezani ki Sarai, kekenà, iyan nu en ingazan kandin si Sara, he ke và dà egkeǥiya, ‘Bai’. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Edtuvazan ku sikandin ne ebmeǥingey ne pinaaǥi kandin ibeǥey ku kenikew is anak he maama. Egkehimu sikandin he kepuun te mezakel he menge nasyun, ne is duma he menge kevuwazan din ne egkehimu he hadì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ne zutun midlangkeb en maan si Abraham diyà te tanà, ne mid-engit su ke sikandin diyà te ǥehinawa zin te, “Egkehimu ves he egkevuwad a, is maama he 100 en is penuiǥen din? Ne egkehimu ves daan he ed-anak si Sara is 90 en is penuiǥen din?” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ne ke sikandin diyà te Megbevayà te, “Emun iyan heeyan egkehitavù, edhengyuen ku he ikeǥaǥew nu zaan is anak ku he si Ishmael.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ne midtavak is Megbevayà te, “Iyan heini tutuu: Si Sara is esawa nu, ed-anak te maama, ne iyan ingazan nu kandin si Isaac, he ke và dà egkeǥiya, ‘Ked-engit’. Ibpelaus ku ziyà te kandin wey ziyà te menge kevuwazan din te wazà pidtemanan sikan is kebpekid-uyun ku kenikew taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ne si Ishmael zaan, ebpemineǥen ku is hangyù nu mehitenged kandin. Edtuvazan ku zaan sikandin ne edhimuwen ku he mezakel is menge kevuwazan din. Egkehimu sikandin he amey te 12 he menge pengulu, ne is menge kevuwazan din egkehimu he utew egkevantug he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Piru haazà is kebpekid-uyun ku kenikew, ibpelaus ku zaan diyà te anak nu he si Isaac he id-anak ni Sara seled te senge tuig pa ǥuntaan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ne hein nekeipus he edlalag is Megbevayà diyà te ki Abraham, nahanew sikandin dutun te ked-ahà ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ne zutun dà he andew, midtuman ni Abraham is insuǥù kandin te Megbevayà. Midsirkunsidar zin is anak din he si Ishmael wey is langun he maama he ziyà te valey zin: is menge uripen he ziyà ianak te valey zin wey is menge uripen he mibpemasa zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ne 99 he tuig is penuiǥen ni Abraham dutun te andew he mibpesirkunsidar sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ne 13 he tuig is penuiǥen ni Ishmael zutun te kedsirkunsidara kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Dutun he andew nesirkunsidar si Abraham, is anak din he si Ishmael, ");
INSERT INTO mbbOT_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","wey is langun he menge uripen din he maama he ziyà ianak te valey zin, wey menge uripen he maama he mibpemasa zin diyà te menge lumelengyawà. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ne mid-uman mebpaahà is Nengazen ki Abraham diyà te uvey te menge kayu he ulayan ni Mamre. Hein ebmeudtu zutun is andew, ebpimpinuu si Abraham diyà te ǥemawan te tulda zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mibpememantew si Abraham ne neehè din is tetelu he maama ziyà te uvey. Ne zutun te kegkaahaa zin, migaanggaan medsinuǥung ne midlangkeb diyà te tanà su edtahud. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ke sikandin te, “Datù, emun meupiya zà te ǥehinawa niw, ne tuluy kew zèpa kayi te kenami. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ituǥut niw he ed-uwit key te wahig wey kew mekepenlùlù te menge paa niw. Himeley kew zèpa kayi te sihung te kayu. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ne ituǥut niw zaan he ibpekaan dey pa sikiyu te zeisek su wey kew meulii te zesen te kenè kew pa edlaus te hipenawan niw su iyan buwa heini ketezengan ke maan is imbanglis kediey is kedhendini niw te kediey te suluǥuen niw.” Ne zutun midtavak dan te, “Uya, meupiya iyan ke egkeulaula haazà is migkaǥi nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ne zutun migaanggaan si Abraham ne midhendiyà te ki Sara he ziyà te tulda ne ke sikandin te, “Ganggaang ka, kuwa ka te menge pitu he ǥantang he herina wey vaal ka te supas.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ne mibpelelaǥuy sikandin pehendiyà te uyaǥen din ne mibpilì te nati he vaka he utew meupiya ne impelapè din duen te betan-en he suluǥuen din ne impehilutù din. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ne hein naandam en is langun, midtangel en ni Abraham haazà is usa wey zuen daan gatas wey kisu. Ne migkaan dan diyà te sihung te kayu ne zutun daan si Abraham is ebpenilbi kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ne zutun mid-insaan dan si Abraham te, “Hendei is esawa nu he si Sara?” Ne midtavak sikandin te, “Diyè ded te seled te tulda.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ne zutun migkaǥi is Nengazen te, “Senge tuig pa ǥuntaan, edlikuan ku sikiyu ne zutun he timpu, si Sara, is esawa nu, id-anak din is maama.” Ne ziyà si Sara te ǥemawan te valey he egkeiniyuǥan dan is ebpemineg te vitiyara zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","(Si Abraham wey si Sara, utew zan en meǥurang ne wazà bahi he ebpekaanak emun is penuiǥen din, iring te penuiǥen ni Sara.) ");
INSERT INTO mbbOT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ne tenged dutun nekeengit si Sara ziyà te ǥehinawa zin, ne neisip din is, “Egkehimu ve he egkeulaula heini is meupiya kediey te nemezahan e en wey utew en meǥurang is esawa ku?” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ne zutun migkaǥi is Nengazen diyà te ki Abraham te, “Maan is mid-engit si Sara he egkaǥi te, ‘Egkehimu ve he ed-anak a is utew en meǥurang?’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ne mid-uman megkaǥi is Nengazen te, “Duen be minsan hengkey he kenà egkehimu te Nengazen? Sumalà is migkaǥi ku, edlikuan ku sikiyu seled te senge tuig ne ed-anak iyan dutun si Sara te maama.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ne mibarew zutun si Sara tenged kegkahandek din he egkaǥi te, “Wazà a med-engit!” Ne midtavak is Nengazen te, “Mid-engit ka iyan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ne migenat en dutun haazà is tetelu he maama. Inhated sikandan ni Abraham taman te nepantew zan is inged he Sodom. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ne migkaǥi is Nengazen diyà te ǥehinawa zin te, “Kenè ku id-eles ki Abraham is ebeelan ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Su kepuun si Abraham te utew zekelà wey mekeǥeǥehem he nasyun wey is kevuwazan din te peleebuten. Pinaaǥi kandin edtuvazan ku is langun he menge nasyun dini te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mibpilì ku si Abraham su wey zin ikepenurù diyà te menge anak din wey menge kevuwazan din he med-ikul zan te ibayè ku te Nengazen pinaaǥi te ked-ul-ulaha zan te metazeng wey hustu. Pinaaǥi kayi, egketuman is menge pesarig ku kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ne migkaǥi zutun is Nengazen diyà te ki Abraham te, “Utew kun mezaat is menge ulaula te menge tig-Sodom wey menge tig-Gomora wey utew kun meveǥat is menge salè dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Umbe edhendiyà a su ed-ahaan ku is menge ulaula zan ke utew subra he mezaat he iring te nezineg ku, su kinahanglan he egketuenan ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ne zutun migenat is dezuwa he menge maama su edhendiyè dan te Sodom, piru si Abraham, diyè ded edhithitindeg te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ne mid-uvayan ni Abraham is Nengazen ne nenginginsà te, “Tutuu ve he idragkes nu is menge metazeng dutun te kedlimasa nu te utew menge mekesesalà he etew? ");
INSERT INTO mbbOT_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Penenglitan ke zuen 50 he menge metazeng he etew ziyà te inged, tutuu ve he edlimasen nu? Ne kenè nu egkehizuwan haazà is menge meǥinged minsan pa te zuen 50 he menge metazeng dutun? ");
INSERT INTO mbbOT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kenà haazà dait he edsilutan nu is menge metazeng duma te menge mekesesalà. Kenà egkehimu he id-iring nu is menge lalung kandan. Iyan ka ebayàbayà te tivuuk kelibutan, kenè be kinahanglan he ebeelan nu ke hengkey is hustu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ne midtavak dutun is Nengazen te, “Emun duen egkeehè ku he 50 he menge metazeng he etew zutun te inged, kenè ku edèdeetan is tivuuk he inged tenged dutun te 50.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ne mid-uman dutun si Abraham megkaǥi te, “Peseyluwa a, su ǥeina te mibpekevurut a he egkaǥi ziyan te kenikew te Nengazen, ibpelaus ku pa is egkeǥiyen ku, minsan pa te kayi te etuvangan nu iring a te eliyavuk dà wey igmuk su utew minus is pid-etawan ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Penenglitan, ke wazà 50 he menge metazeng dutun te inged su 45, edlimasen nu zed be haazà is inged su egkurang te lelima he menge metazeng?” Ne midtavak is Nengazen te, “Emun duen egkeehè ku he 45, ne kenè ku en edlimasen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ne mid-insè pa maan si Abraham te, “Ne emun iyan nu zà egkaahà dutun is 40 he menge metazeng?” Ne midtavak is Nengazen te, “Emun duen egkeehè ku he 40 ne kenè ku edlimasen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ne migkaǥi en maan si Abraham te, “Pekelalaglalag ka, Nengazen, ne kenà a kenikew mepeuki su ebpenginginsè e pa. Penenglitan ke zuen egkeehè nu he 30 he menge metazeng?” Ne midtavak is Nengazen te, “Emun duen egkeehè ku he 30 ne kenè ku zaan edlimasen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ne migkaǥi en maan si Abraham te, “Nengazen, ǥeina te mibpekevurut e pa maan he egkaǥi ziyan te kenikew te, ibpelaus ku pa is egkeǥiyen ku. Ne penenglitan, emun duen 20 he metazeng he egkeehè nu, edlimasen nu zed be?” Ne midtavak is Nengazen te, “Ke zuen minsan 20, kenè ku en edlimasen is inged.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ne migkaǥi pa maan si Abraham te, “Nengazen, Kenà a kenikew mepeuki, ketepusan en heini he id-insè ku. Penenglitan ke zuen 10 he menge metazeng he egkeehè nu zutun?” Ne midtavak is Nengazen te, “Ke zuen egkeehè ku ziyà he minsan 10 dà he menge metazeng, ne kenè kud edlimasen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ne zutun nepasad is kebitiyara zan, nahanew is Nengazen, ne mid-ulì si Abraham diyà te kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ne haazà is dezuwa he menge velinsuǥuen te Nengazen, hein nekeuma zan diyà te inged he Sodom ne mahapun en, diyà si Lot ebpimpinuu te uvey te pultahan dutun te inged. Ne hein neehè din sikandan, midhitindeg sikandin ne midsinuǥung din ne midlangkeb sikandin diyà te tanà te kedtahud, he egkaǥi te, ");
INSERT INTO mbbOT_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Edhengyuan ku sikiyu, menge zatù, tuluy kew pa ziyà te valey ku te suluǥuen niw. Penlùlui niw is menge paa niw wey hulavung kew pa. Keeselem kew en laus te hipenawan niw.” Ne midtavak sikandan te, “Maambe en su zini key zà edhulavung te pelasa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Piru midteǥel sikandan ni Lot, umbe miduma zan diyà te valey zin. Ne mid-andam si Lot te menge inumen wey egkeenen dan, ne mibpevaal zaan sikandin te supas he wazè din tapey, ne midlavung sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ne zutun te wazè dan pa mekehizeǥà, nemekeuma is langun he menge maama zutun te tivuuk he inged he Sodom, menge kengkenakan wey menge meǥurang he maama, ne midlingutan dan is baley ni Lot. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mid-umew zan si Lot, ne mid-insaan dan te, “Hendei sikan is menge maama he meǥeliyug nu he nekeuma ǥeina te mahapun? Ipeǥawas nu su egkesuat key he ebpekidhilavet kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ne migawas dutun si Lot te valey su edlelaǥan din sikandan. Ne hein nekeǥawas en sikandin, ne midlekevan din is gemawan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Migkeǥiyan din sikandan te, “Menge geli ku, kenà haazà egkehimu. Edhangyù a he kenè niw ul-ulaha heeyan is utew mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Heini zed is menge anak ku he raǥa. Wazè pa sikandan meuvayi te maama. Ibpeǥawas ku en sikandan ne egkehimu he ziyè niw ul-ulaha te kandan is egkesuatan niw, iyan, kenè niw pesipelahi heini is dezuwa he maama su menge meǥeliyug ku man ne kinahanglan he ed-elimahan ku sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Piru nasì dan medtavak te, “Lumelengyawè ke zà dini, hentei ka is uvag en ebpelavetlavet kenami. Awè ka keniyan! Kela ke tuwas pa he mezaat is ed-ul-ulahan dey kenikew kenà kandan.” Ne zutun insinumag dan si Lot, ne ed-uvey zan en pezem duen te ǥemawan su egkebrahan dan is lekeb kayi. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Piru haazà is dezuwa he maama he ziyà te seled, mibpuwasan dan is gemawan ne midsengguyud dan si Lot ne inseled dan dutun te valey ne midlelekeb dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ne haazà is menge etew he ziyà te ǥawas, mibpengelinteuwan kayi te zezuwa he melakap sikandan para kenà sikandan meketuredu te ǥemawan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ne migkaǥi haazà is dezuwa ziyà te ki Lot te, “Emun duen nu pa menge zuma kayi, iring te menge anak nu he maama wey vahi, wey menge mekaamung nu, wey is minsan hentei pa he menge sakup nu kayi te inged, kinahanglan he zumaha nu en ne pelaǥuy kew pehendiyà te ǥawas te inged, ");
INSERT INTO mbbOT_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","su edèdeetan dey en heini is inged. Nezineg en te Nengazen is menge riklamu kandan tenged te menge ulaula zan he mezaat. Umbe midsuǥù key zin dini su ibpelimas din kenami heini he inged.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ne zutun mibeyaan ni Lot is menge maama he nekekaǥun te menge anak din, ke sikandin te, “Kuwa kew en su ebpelaǥuy kiw kayi su edlimasen en te Nengazen heini is inged tew.” Piru wazè dan mebpemineg su kunaan dan ke suyat dà haazà ni Lot. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ne hein egkeriwaswas en, impeǥaangaan en si Lot dutun te zezuwa he velinsuǥuen he med-awè dan en dutun te inged, ke sikandan te, “Gaanggaan ka! Genat ke en, dumaha nu is esawa nu wey is menge anak nu he raǥa, su kela ke mekeragkes kew kayi te kedlimasa kayi te inged, tenged te utew meremerik he ulaula te menge etew kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ne minsan pa zutun midlanganlangan pa si Lot. Ne tenged te nehizuwan sikandan te Nengazen, migewezan sikandan duen te menge velinsuǥuen diyà te zezuwa he velad dan, su wey zan mekeǥawas dutun te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ne hein diyè dan en te ǥawas, migkaǥi is sevaha he velinsuǥuen diyà te ki Lot te, “Pelaǥuy kew en! Kenè kew lilingey wey kenè kew teren kayi te menge suǥud. Diyè kew petandang te menge vuvungan para kenè kew meragkes mepatey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Piru midtavak si Lot te, “Egalen ku, kenè ad kenikew epepelaǥuy diyà te vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Utew zekelà is tavang niw kediey te suluǥuen niw ne utew zekelà is gaǥew niw kediey su midlibri a keniyu wey a kenà mebpatey. Utew zà meziyù haazà is buntud; kenà a ebpekepelaǥuy pehendiyà te vuvungan su egkesaut e zed kayi te kedlimas ne ebpatey a ǥihapun. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Neehè nu ve heeyan is deisey he inged keniyan te egkehunaan? Egkesiguru ku he egkeuma ku heeyan su uvey zà. Egkehimu ve he keniyan e zà ebpevayà te zeisey he inged su wey a meluwas?” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ne midtavak dutun is belinsuǥuen te, “Uya, egkehimu; idtuǥut ku heini is hangyù nu. Kenè ku en edèdeetan haazà is inged he egkeǥiyen nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sigi, pelaǥuy kew. Hendiyan kew en, su wazà egkehimu ku taman te kenè kew pa ebpekeuma zutun.” Ne tenged dutun, egngezanan haazà is inged te Zoar, he ke và dà egkeǥiya, “Deisek.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ne hein midsilè en is andew nekeume en ensi Lot diyà te Zoar. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Segugunà mibpeuzan is Nengazen te egkeregreg he esupri ziyà te inged he Sodom wey Gomora. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Pinaaǥi zutun midlimas te Nengazen haazà is dezuwa he inged wey sikan is tivuuk he suǥud. Neǥerà is langun he menge meǥinged dutun wey nezeetan is langun he edtuvù dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Piru midlilingey sikan is esawa ni Lot su ed-ahaan din is neewaan dan, ne mibaluy sikandin he timus he iring te tukud. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ne zutun te sunud he andew, midselem med-enew si Abraham, ne midlikù diyà te zaan he midhitindeǥan din hein mibpekidlaglag kandin is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ne mibpememantew sikandin diyà te Sodom wey Gomora wey ziyà te tivuuk he suǥud. Ne neehè din is dekelà he evel he ebpuun dutun te tanà he iring te evel te selsalan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Wazà melipati te Nengazen is kebpekid-uyun din diyà te ki Abraham, su zutun te kedèdeeti zin te menge inged diyà te suǥud he zutun med-ubpà si Lot, impepelaǥuy zin si Lot su wey kenà meragkes. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ne mid-awà dutun si Lot wey is menge anak din he raǥa te inged he Zoar su egkahandek sikandin dutun he ed-ubpà, ne ziyè dan medhalin te vuntud, ne ziyè dan med-ubpà te surung. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dutun he timpu, migkaǥi is kakey he anak din diyà te hazi zin te, “Utew en meǥurang is amey ta ne wazà kayi zuma pa he maama he ebpekeesawa kenita wey edhulid kenita sumalà is betasan te tivuuk he menusiyà. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Edlenguten ta nasì is amey ta te vinu, ne edhulizen ta sikandin su wey zuen te zed kevuwazan pinaaǥi te amey ta.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ne zutun he kezukileman, midlangut dan is amey zan, ne mibpekidhulid haazà is kakey te amey zan. Tenged te utew nelangut si Lot, wazè din metueni haazà is neulaula. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ne hein nepawà, migkaǥi haazà is kakey ziyà te hazi zin te, “Geina te mezukilem, iyan a midhulid ki amà. Kengkuwan te mezukilem edlenguten te en maan sikandin, ne iyan kad maan hulid kandin su wey zuen te zed kevuwazan pinaaǥi te amey ta.” ");
INSERT INTO mbbOT_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Umbe, zutun he kezukileman, midlangut dan en maan is amey zan, ne iyan maan haazà is hazi mibpekidhulid te amey zan. Tenged te utew nelangut si Lot, wazè din metueni is neulaula. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ne pinaaǥi zutun neǥingey ni Lot haazà is menge anak din he vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mid-anak haazà is kakey, ne maama is anak din, ne migngezanan din ki Moab. Iyan sikandin kepuun te menge Moabitanhen guntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mid-anak daan haazà is hazi, ne maama zaan is anak din, ne migngezanan din ki Ben Ami. Iyan sikandin kepuun te menge Amunihanen guntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ne zutun midlaus medhipanew ensi Abraham ne midhendiyè dan te tanà he Negev. Ne ziyè dan med-ubpà te pid-elangan te inged he Kadesh wey Shur. Ne hein neuǥet midhalin si Abraham diyà te inged he Gerar. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hein dutun dan en, ne migkeǥiyan din is menge etew he etevey zin si Sara. Umbe impaangey ni Hadì Abimelec he hadì te Gerar si Sara su ed-esewaan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Sevaha zutun he mezukilem, mibpeteǥeinep is Nengazen ki Abimelec he egkaǥi te, “Ebpengelinteuwan ku he mebpatey ka, su haazà is bahi he migkuwa nu, duen din en esawa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Piru wazè pa uvayi ni Abimelec si Sara, ne tenged dutun migkaǥi sikandin te, “Nengazen, maan is edhimetayan nu is menge etew ku? Wazà a mekesalà? ");
INSERT INTO mbbOT_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Migkeǥiyan a ni Abraham he etevey zin si Sara, ne si Sara zaan migkeǥiyan e zin he meemahan din si Abraham. Angin ke netuenan ku he esawa zin su wazè ku pezem kuwaa si Sara, iyan, wazè ku metueni.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Midtavak is Nengazen te, “Uya, netuenan ku he wazà mezaat he tuyù nu kandin, umbe mibpengelinteuwan ku he kenè ka mekeuvey kandin, su wey ka kenà mekesalà kedì. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kinahanglan he ilikù nu sikandin diyà te ki Abraham, su ebpeneuven sikandin, ne id-ampù ke zin su wey ka kenà mebpatey. Piru emun kenè nu id-ulì, ebpetizeenan ku sikew he kenè en ebperis ne ebpatey ke en iyan ragkes is langun he menge sakup nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ne hein nepawà dutun te sunud he andew, mid-umew ni Abimelec is langun he menge upisyal zin, ne midtudtulan din sikandan mehitenged te teǥeinep din. Ne utew sikandan nahandek. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ne zutun mid-umew ni Abimelec si Abraham ne mid-insaan din te, “Hengkey ves heini is mid-ulaula nu kenami? Hengkey is salè ku kenikew he iyan inhimuwa nu he mekesalà a wey is tivuuk he ginhedian ku? Kenà hustu heini is mid-ulaula nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ne ke sikandin en maan diyà te ki Abraham te, “Hengkey is tuyù nu kayi te mid-ulaula nu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Midtavak si Abraham te, “Mid-ulaula ku heini, su neisip ku is kela ke wazà minsan sevaha kayi he edtahud te Megbevayà, umbe neisip ku is iring kayi su kela ke himetayi a keniyu ne egkuwaan niw is esawa ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tutuu iyan he etevey ku si Sara, su anak te amey ku, piru selakew is iney zin, ne mid-esawa ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Hein migkeǥiyan a te Nengazen he med-awà a ziyà te inged te amey ku, migkeǥiyan ku si Sara he ipekilala zin he telesuled key minsan hendei key mekepevayà. Pinaaǥi kayi igkepeehè din is dekelà he gaǥew zin kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ne zutun in-ulì ni Abimelec si Sara ziyà te ki Abraham, ne mibeǥayan din si Abraham te menge kerehidu, baka, wey menge uripen he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ne migkeǥiyan ni Abimelec si Abraham te, “Andam a te kebpeubpà keniyu kayi te tanè ku, ne iyan ka pilì ke hendei ka egkesuat he ed-ubpà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ne migkeǥiyan din si Sara te, “1,000 he vuuk he pelata is ibeǥey ku ziyà te meemahan nu. Iyan heini ibpayùpayù ku keniyu su wey metueni te langun he menge zuma niw he wazà a mekesalà wey wazè ka mekepehilavet kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tenged te kegkuwaa ni Abimelec ki Sara, mibpengelinteuwan te Megbevayà he kenà mekaanak is langun he menge vahi zutun te valey zin. Umbe mid-ampù si Abraham diyà te Megbevayà, ne mibpengelinteuwan te Megbevayà he meulii si Abimelec te zaru zin wey is esawa zin wey is menge uripen din he vahi su wey zan mekeuman mekaanak. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Midtentenuzan te Nengazen is migkaǥi zin he edhimuwen din diyà te ki Sara sumalà is insaad din. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Mibmeǥingey si Sara ne in-anak din is maama minsan pa te meǥurang en si Abraham. Is timpu te ked-enaka zuen te vatà, ne iyan en kes timpu he midtelaan he zaan te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ne haazà is batà, migngezanan ni Abraham ki Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ne hein ikewalu he andew puun dutun te ked-enaka ki Isaac, midsirkunsidar sikandin ni Abraham sumalà is insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ne 100 en is penuiǥen ni Abraham dutun te ked-enaka te anak din he si Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ne migkaǥi si Sara te, “Midhimu human te Megbevayà he mekeengit a te kegkelipey ne ebpekeengit daan te kegkelipey is minsan hentei he egketudtulan mehitenged kayi. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hentei vuwa is ebpekekaǥi ki Abraham he ebpekepesusu e pa te vatà? Piru nekaanak e pa minsan meǥurang en sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ne hein malù en dekelà si Isaac, wey hein nelutas en sikandin, midtukud si Abraham te zekelà he keemuran. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ne sevaha he andew, naahà ni Sara si Ishmael (haazà is anak ni Abraham diyà te ki Hagar te Ehiptohanen) is edsudì te anak din he si Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Umbe migkaǥi si Sara ziyà te ki Abraham te, “Segseǥa nu heeyan is uripen he vahi wey is anak din, su kenà egkehimu he ebpekaambit is anak te uripen te egkepenunud te anak ku he si Isaac.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Utew heini ingkeseeng ni Abraham tenged te anak din man daan si Ishmael. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Piru migkaǥi is Megbevayà diyà te ki Abraham te, “Kenè nu ikeseeng si Ishmael wey si Hagar. Tumana nu is egkeǥiyen ni Sara, su pinaaǥi ki Isaac is ebpuunan te menge kevuwazan nu he insaad ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Piru edhimuwen ku zaan he utew zekelà he nasyun is menge kevuwazan ni Ishmael, su anak nu man daan sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Meselem pa utew zutun te sunud he andew, migkuwa si Abraham te egkeenen wey lundis he teleǥuey te wahig, ne imbeǥey zin ki Hagar. Ne impevava zin haazà ne impeǥenat din haazà is bahi wey is batà. Ne migenat en dutun si Hagar ne midriǥuriǥu ziyà te sibsivayan te Beersheba. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hein naamin en is wahig dutun te teleǥuey, intaǥak ni Hagar is anak din diyà te sihung te dezeisey he kayu. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ne mid-awà sikandin, he menge 100 he mitrus is keziyù puun dutun te vatà. Dutun sikandin mebpinuu he edsineǥew, ne egkeisip din is, “Kenè ku egkaantus te ed-ahà is anak ku he ebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Piru nezineg te Megbevayà is ked-erang te vatà. Umbe migkaǥi is belinsuǥuen te Megbevayà diyà te langit te, “Hagar, hengkey is idsineǥew nu? Kenè ka mahandek! Nezineg te Megbevayà is ked-erang keniyan te anak nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hitindeg ka ne enawa nu heeyan is batà, su edhimuwen ku he utew zekelà he nasyun is menge kevuwazan din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ne zutun impeturedu te Megbevayà si Hagar te kalut, ne midhendiyà sikandin ne midsekezu ne impeinum din is anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ne midtuvazan te Megbevayà haazà is batà ne midekelà, ne ziyà med-ubpà te sibsivayan te Paran. Nehimu sikandin he mememanà. Ne zutun impeesawa sikandin te iney zin te vahi he Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ne zutun he timpu, midhendiyà si Abimelec te ki Abraham wey is pengulu te menge sundaru zin he si Ficol. Migkeǥiyan ni Abimelec si Abraham te, “Netuenan dey iyan he edtevangan ka te Megbevayà te langun he ed-ul-ulahan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Umbe penangdù ka kayi te etuvangan te Megbevayà he kenà a kenikew ed-ekalan ragkes is menge kevuwazan ku. Ipeehè nu kediey is gaǥew nu wey te menge meǥinged kayi te tanà he ed ubpaan nu te lumelengyawà, iring te impeehè ku kenikew is gaǥew ku kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ne midtavak si Abraham te, “Ebpenangdù a kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Piru zuen riklamu ni Abraham diyà te ki Abimelec mehitenged te kalut he mid-aǥew te menge sakup din. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ne migkaǥi si Abimelec te, “Wazè ku metueni ke hentei ki vaal heini. Wazè nu keǥiya kediey ne sikan ku pa mezineg.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ne zutun mid-uwit ni Abraham is menge kerehidu wey vaka ne imbeǥey zin ki Abimelec ne midhimu sikandan is dezuwa te kesebutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ne zutun migkuwa ni Abraham is pitu he vehiyan he nati he kerehidu zutun te menge kerehidu ne insivey zin heini. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Mid-insaan sikandin ni Abimelec te, “Ebmenuwen heini is pitu he vehiyan he nati he kerehidu he insivey nu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ne midtavak si Abraham te, “Kuwaa nu heini is pitu he vehiyan he nati he kerehidu he tuus te neketistiǥus ka he iyan a mibangbang kayi te kalut.” ");
INSERT INTO mbbOT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tenged dutun te midhimu zan he kesebutan, migngezanan haazà is kalut te Beersheba su zutun dan himuwa is kesebutan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hein nepasad dan haazà is kesebutan dan diyà te Beersheba, migenat en si Abimelec duma ki Ficol, is pengulu te menge sundaru zin, ne mid-ulì dan diyà te tanè dan te menge Filistihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Mibpemula si Abraham te sengepuun he kayu he tamarisko ziyà te Beersheba ne mid-azap din dutun is Nengazen, he iyan kes wazà pidtemanan he Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Neuǥet pa zutun is ked-ubpà ni Abraham diyà te tanà te menge Filistihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Midlavey is nepipira he tuig ne neuma is timpu he migezaman si Abraham te Megbevayà. Migkeǥiyan sikandin te Megbevayà te, “Abraham!” Ne midtavak si Abraham te, “Hengkey!” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ne migkaǥi zutun is Megbevayà te, “Kuwaa nu is budtung he anak nu he si Isaac he utew nu mibmahal ne hendiyè ka te tanà he Moria. Tekezeg kew zutun te vuvungan he ibpeehè ku kenikew ne ipemuhat nu sikandin kayi te kedì he pemuhat he edtutungen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Umbe, zutun te utew pa meselem te sunud he andew, midselem med-enew si Abraham ne midsilyahan din is asnu zin. Mibpengayu pa sikandin te idtavun dutun te pemuhat he edtutungen ne miduma zin is dezuwa he suluǥuen din wey is anak din he si Isaac ne migenat dan pehendiyà te vuvungan he migkaǥi te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Dutun te iketelu he andew te kedhipanew zan, nepantew ni Abraham haazà is buvungan he malù pa meziyùdiyù. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Migkeǥiyan din is menge suluǥuen din te, “Dini kew zà dèpa taǥad duma is asnu, su edlaus key pa ziyà su ed-azap key te Megbevayà. Edlikù key zè kan dini.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Migkuwa zutun ni Abraham sikan is menge kayu ne impeuwit din ki Isaac ne iyan sikandin migkulang te tigtiǥen wey ubpit. Ne midlaus dan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Dutun te kemulu zan en edhipanew, migkaǥi si Isaac diyà te amey zin he si Abraham te, “Amà!” Ne midtavak si Abraham te, “Hengkey, Mama?” Mid-insà si Isaac te, “Duen ta tigtiǥen wey kayu, piru hendei ta egkekuwa is nati he kerehidu he ibpemuhat he edtutungen?” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ne midtavak dutun si Abraham te, “Is Megbevayà, Mama, iyan ebeǥey kenita te nati he kerehidu he egkehimu he ibpemuhat he edtutungen.” Ne midlaus dan en dutun is dezuwa he edhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ne hein nekeuma zan en dutun te vuvungan he impaahà te Megbevayà ki Abraham, mibaal si Abraham te pemuhatà, ne insavuk din dutun is menge kayu. Mibakus din dutun si Isaac ne insavuk din daan sikandin dutun te zivavew te kayu he ziyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ne migewezan ni Abraham is ubpit su edhimetayan din en is anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mid-umew si Abraham te velinsuǥuen te Nengazen he ebpuun te langit te, “Abraham! Abraham!” Ne midtavak sikandin te, “Hengkey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ne migkaǥi is belinsuǥuen te, “Isavuk nu zà heeyan is ubpit! Kenè nu pelii is batà te minsan deisek dà! Netuenan ku en he iyan a is Megbevayà, utew lavew he ebmahalen nu su minsan is anak nu he utew nu minahal, wazè nu isipa he kenè nu ibeǥey kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Dutun te nekelilingey si Abraham, ne neehè din is kerehidu he meemahan he nekesanggat is sungey zin diyà te dezeisey he kayu. Ne migkuwa ni Abraham haazà ne impemuhat din he pemuhat he edtutungen ilis te anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Migngezanan ni Abraham haazà te, “Iyan Ebeǥey is Nengazen.” Ne zuen pa erubasa ǥuntaan he edhenduen te, “Diyà te Buvungan te Nengazen egkeveǥayan kiw te tavang.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ne zutun mid-uman med-umew is belinsuǥuen te Nengazen he ziyà te langit ki Abraham, ");
INSERT INTO mbbOT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","ke sikandin te, “Iyan heini migkaǥi te Nengazen: Ibpenangdù ku kayi te gehinawa ku he edtuvazan ku iyan sikew tenged te wazè nu ikeleǥezi kedì is namànamà he anak nu. Edhimuwen ku he utew medmezakel is menge kevuwazan nu su iring te menge vituen diyà te langit wey iring te menge pantad diyà te veyvey te zaǥat. Egkeveyveyaan dan is menge inged te menge kuntada zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ne pinaaǥi te menge kevuwazan nu, edtuvazan ku is langun he menge nasyun diyan te kelibutan, tenged te midtuman nu is suǥù ku kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hein nepasad haazà, midlikuan eni Abraham sikan is dezuwa he suluǥuen din, ne midhendiyè dan te Beersheba, ne ziyà si Abraham med-ubpà te Beersheba. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Midlavey zutun is timpu, ne nezineg ni Abraham is tudtul te zuen en menge anak te hazi zin he si Nahor ziyà te ki Milca. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Is kinekekayan he anak dan he maama ne si Uz, is sunud ne si Buz, is sunud pa ne si Kemuel (he nehimu he amey ni Aram), ");
INSERT INTO mbbOT_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Kesed, si Hazo, si Pildash, si Jidlaf, wey si Betuel. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Si Betuel, ne zuen anak din he raǥa he si Rebeka. Sikandan is walu ne menge anak ni Nahor ziyà te ki Milca. ");
INSERT INTO mbbOT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Duen pa menge anak ni Nahor ziyà te sevaha he esawa zin he si Reuma. Iyan ensi Tiba, Gaham, Tahash wey si Maaca. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Is keluǥayad te untung ni Sara 127 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Diyà sikandin mebpatey te inged he Kiriat Arba (he iyan en guntaan inged he Hebron) diyà te tanà he Canaan. Utew inlalew ni Abraham is kebpatey ni Sara. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ne mid-ewaan din dèpa is esawa zin he minatey ne midhendiyà te menge Hitihanen ne migkeǥiyan din sikandan te, ");
INSERT INTO mbbOT_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nekeubpà a kayi te lugar niw he sevaha he lumelengyawè dà, umbe emun egkehimu ipepemsa a keniyu te tanà he edlevengan ku te esawa ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ne midtavak dutun is menge Hitihanen te, ");
INSERT INTO mbbOT_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Datù, pemineǥa nu is egkeǥiyen dey. Migkilala zey sikew he telehuzen he etew, umbe egkehimu he minsan hendei nu idleveng is esawa nu kayi te pinekemeupiya he penlevengè dey. Wazà minsan hentei kenami he kenà ebeǥey kenikew te edlevengan te esawa nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ne zutun, segugunà midluhud si Abraham diyà te etuvangan te menge Hitihanen he iyan tuus te kebpeselamat din. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ke sikandin te, “Emun idtuǥut niw he idleveng ku kayi is esawa ku, edhengyuen ku keniyu he melelaǥi ku si Efron is anak ni Zohar, ");
INSERT INTO mbbOT_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","su wey zin ivelegyà kayi te kedì haazà is surung he kilid te vevesukè din diyà te Macpela. Keǥiyi niw sikandin he ebeyazan ku te hustu he prisyu, kayi te etuvangan niw para egkehimu he penlevengè ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ebpimpinuu zutun si Efron duma te menge zuma zin he menge Hitihanen, umbe midtavak din si Abraham diyà te etuvangan te langun he menge zuma zin he menge Hitihanen he midtiǥum dutun te pultahan te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ke sikandin te, “Kayi te etuvangan te menge zuma ku, ibeǥey ku kenikew is tivuuk he vevesukè ku ragkes sikan is surung. Umbe egkehimu en idleveng nu is esawa nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ne mid-uman si Abraham medluhud he tuus te kebpeselamat din diyà te etuvangan te menge meǥinged dutun, ");
INSERT INTO mbbOT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ne migkaǥi sikandin diyà te ki Efron he nezineg te langun te, “Pemineǥa a. Egkesuatan ku he ebeyazan ku haazà is bevesukà. Dewata nu en is ibayad ku, su wey zutun ku en ikeleveng is esawa ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ne midtavak dutun si Efron ki Abraham te, ");
INSERT INTO mbbOT_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Datù, pemineǥa a zep-a. Is bali zuen te tanà, ne 400 he vuuk he pelata, piru kenà haazà ebpekesamuk kenita te teleemiǥu. Kuwaa nu en is tanà ne igkeleveng nu zutun is esawa nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ne mid-uyun dutun si Abraham sumalà is migkaǥi ni Efron, ne midtimbang din is 400 he vuuk he pelata sumalà is keveǥat he neuyunan he zaan te menge nigusyanti zutun. Ne imbayad din heini ki Efron dutun te etuvangan te menge Hitihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Umbe naangken ni Abraham haazà is bevesukà ni Efron diyà te Macpela, he uvey te inged he Mamre, ragkes is surung wey is menge kayu he nekeelibet dutun te vevesukà. Nepirmahan te langun he menge Hitihanen he nevurun diyà te pultahan te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ne inleveng ni Abraham is esawa zin he si Sara ziyà te surung he ziyà te tanà he Macpela, he sakup te tanà he Canaan. Is Macpela uvey te Mamre he iyan guntaan kes inged he Hebron. ");
INSERT INTO mbbOT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Umbe, is bevesukà ragkes is surung he iyan dengan teǥiǥaked kayi is menge Hitihanen, nehimu en heini he ki Abraham, ne midhimu zin heini he penlevengè din. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Utew en meǥurang dutun si Abraham, ne midtuvazan sikandin te Nengazen diyà te langun he menge vaal zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Sevaha zutun he andew, migkeǥiyan ni Abraham is egalen te menge suluǥuen din he iyan sineriǥan te langun he menge azen din te, “Isavuk nu is belad nu kayi te laang ku. Tuus heini te penaad nu he edtistiǥusan te Nengazen, he iyan dà Megbevayà te langit wey tanà, ne kenè ka mebpilì te ed-esawaan te anak ku he si Isaac te vahi he tig-Canaan he emurè tew kayi te mid-ubpaan tew ǥuntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hendiyè ka te inged he mibpuunan ku, ne ziyè ka pilì te ed-esawaan te anak ku he si Isaac te menge kezuzumahi ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Piru mid-insaan dutun si Abraham te suluǥuen din te, “Na, hengkey ve is ed-ul-ulahan ku emun kenà egkesuat is bahi he eduma kediey ke ed-ulì a zini? Egkesuatan nu ve he edumahan ku ziyà is anak nu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ne midtavak si Abraham te, “Kenè nu zumaha si Isaac diyà! ");
INSERT INTO mbbOT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Is Nengazen, he iyan dà Megbevayà diyà te langit, migkaǥi kedì, he ewai ku is menge kezuzumahi te amey ku wey is inged ku he zutun a meetew. Ne nenangdù sikandin he ibeǥey zin heini is tanà he Canaan diyà te menge kevuwazan ku. Umbe hipanew ke en su ebpezumahan ke zin te menge velinsuǥuen din he ibpehuna kenikew ne iyan edtavang kenikew wey ka mekaahà diyà te egkeesawa te anak ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Piru emun kenà eduma haazà is bahi kenikew, wazè nu en televaken te heini he penangdù nu kediey. Piru kenè nu ziyà dumaha is anak ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Umbe insavuk duen te suluǥuen is belad din diyà te laang ni Abraham te egalen din, ne nenangdù sikandin he edtumanen din is langun he insuǥù kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ne hein nepasad dutun, migkuwa is suluǥuen te sepulù he menge ayam he kemilyu ne migkergahan din te langun he kelasi te menge mahalen he igasa he ebpuun te egalen din he si Abraham. Migenat sikandin pehendiyà te inged he Aram Naharaim, he iyan inged he mid-ubpaan ni Nahor he hazi ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Impeleku zin is menge kemilyu ziyà te uvey te kalut he ǥawas te inged. Mahapun en dutun he iyan uras he edsekezu is menge vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ne zutun mid-ampù haazà is suluǥuen, “Sikew is Nengazen, Megbevayà te egalen ku he si Abraham, tevangi a ǥuntaan ne ipeehè nu is gaǥew nu te egalen ku he si Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kayi a medhithitindeg te uvey te kalut ne ebpekeume en is menge raǥa he menge meǥinged kayi te inged su edsekezu zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Emun ebuyù a te wahig duen te umuy te raǥa, ne emun ebpemineg sikandin he ibpeinum a ragkes is menge kemilyu ku, berakat he iyan sikandin kes mibpilì nu he egkehimu he esawa te suluǥuen nu he si Isaac. Pinaaǥi kayi egketuenan ku he impeehè nu is gaǥew nu te egalen ku he si Abraham.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Wazè pa zutun sikandin mekepasad he ed-ampù, ne nekeuma si Rebeka he edtiang te umuy. Anak si Rebeka ni Betuel, ne si Betuel anak ni Nahor wey ni Milca. Si Nahor suled ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Utew mekempet he raǥa si Rebeka ne wazè pa sikandin meuvayi te maama. Mibpenaug sikandin dutun te kalut ne midteǥuan din is umuy zin te wahig. Ne hein nekepasad ne migaun sikandin dutun ne mid-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ne migaanggaan sikan is suluǥuen te kedsinuǥung kandin ne migkaǥi te, “Ipeinum a, bayi, keniyan te sinekezu nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Midtavak si Rebeka te, “Uya zatù, inum ka.” Impekevavè din is umuy zin ne impeinum din sikan is suluǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Hein nekeinum en haazà is suluǥuen, migkaǥi sikandin te, “Edsekezu e pa su ibpeinum ku zaan is menge kemilyu nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ne ingaanggaan din ivusbus haazà is sinekezu zin diyà te pelungan, ne midlikù en maan sikandin medsekezu taman te nekeinum is langun he menge kemilyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mibpeniid dà haazà is suluǥuen, ne ed-is-isipen din ke ebmenmenuwen te Nengazen te edhimu wey metuman is tuyù din te kedhendutun te haazà he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ne hein nekeinum en is menge kemilyu, midkedkad duen te suluǥuen is uwiten din he ǥalunggalung he vulawan he heenem he gramu is keveǥat din. Midkedkad din daan is dezuwa he rintì he vulawan he 120 he gramu is keveǥat. Ne imbeǥey zin haazà ki Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ne mid-insaan din si Rebeka te, “Hentei ka ki anak? Egkehimu ve he ziyan key edhizeǥà guntaan te valey niw?” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Midtavak si Rebeka te, “Iyan amey ku si Betuel he anak ni Milca wey ni Nahor. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Duen egkehizeǥaan niw ziyà te kenami, wey zekelà daan is menge reǥami he idsamak para te menge kemilyu niw.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ne zutun midluhud is suluǥuen diyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ke sikandin te, “Edeliǥen is Nengazen, he iyan Megbevayà te egalen ku he si Abraham. Impeehè din is kenà egkahanew he ǥaǥew zin te egalen ku. Iyan sikandin migiya kedì wey a mekehendiyà te kezuzumahi te egalen ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ne mibpelelaǥuy si Rebeka is ed-ulì diyà te valey zan, ne midtudtulan din is iney zin te langun he nengeulaula. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Is suled din he si Laban dutun daan is ebpemineg te edtudtulen din, he ebpengeǥiyen duen te etew mehitenged kandin. Naahà ni Laban is galunggalung wey sikan is menge rintì diyà te velad te etevey zin he si Rebeka. Umbe mibpelelaǥuy sikandin pehendiyà te kalut ne midhendiyà te etew he migkaǥi ni Rebeka. Diyè ded haazà is etew medhithitindeg te uvey te kalut, duma te menge kemilyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Migkeǥiyan sikandin ni Laban te, “Iyan ke ves is midtuvazan te Nengazen. Maan is kayi ke zà edhithitindeg? Laus ka ziyà te valey zey, su mid-endaman dey en sikew te edhizeǥaan nu wey lugar para te menge kemilyu nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Miduma sikandin ki Laban. Hein nekeuma zan en diyà te valey, impenaug ni Laban is menge karga zuen te menge kemilyu, ne impekaan din haazà is menge kemilyu te reǥami wey kumpey. Mid-uwitan din daan te wahig haazà is suluǥuen wey is menge zuma zin, para mekepenlùlù dan te menge paa zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Hein netangel en is ibpekaan kandan, migkaǥi haazà is suluǥuen te, “Kenà a egkaan ke kenè ku egketudtul is tuyù ku te kedhengkayi.” Midtavak si Laban te, “Sigi en, tudtuli key en.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Migkaǥi sikandin te, “Suluǥuen a ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Midtuvazan sikandin te Nengazen, ne utew zekelà is ketiǥeyunan din guntaan. Mibeǥayan sikandin te Nengazen te menge kerehidu, menge kambing, menge vaka, menge kemilyu, menge asnu, menge pelata, menge vulawan, wey menge suluǥuen he maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Minsan meritan en si Sara is esawa zin, ne nekaanak pa sikandin. Ne heini is anak dan he maama iyan ebpekepenunud te langun he menge azen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Impenangdù ku te egalen ku he edtumanen ku is suǥù din he egkaǥi te, ‘Kenè ka mebpilì te ed-esewaan te anak ku kayi te menge tig-Canaan he is tanè dan iyan ed-ubpaan tew ǥuntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Pehendiyè ka te pemilya te amey ku, ne ziyè ka pen-ahà te vahi he kezuzumahi ku he ibpeesawa nu te anak ku.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Piru nenginginsà a, ‘Na, hengkey is ed-ul-ulahan ku emun kenà eduma haazà is bahi kedì?’ ");
INSERT INTO mbbOT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Midtavak sikandin te, ‘Is Nengazen he iyan ebpezumdumahan ku layun, edsuǥuen din is belinsuǥuen din he ibpezuma kenikew ne ebpengelinteuwan din para mehimu is tuyù nu ziyan, ne ebpekeehè ka te ed-esawaan te anak ku ziyà te menge kezuzumahi ku he menge kevuwazan te amey ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Emun diyè ka ebpevayà te menge kezuzumahi ku, wazè nu televaken dutun te penangdù nu kedì emun kenè dan ebpemineg he ibpezuma kenikew is bahi.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Umbe, geina te kebpekeuma ku ziyà te kalut, mid-ampù a. Ke siak te, ‘Nengazen, Megbevayà te egalen ku he si Abraham, berakat he ituǥut nu he mehimu is tuyù ku te kedhengkayi ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Guntaan, dini a edhithitindeg te uvey kayi te kalut. Emun duen ebpekeuma he raǥa he edhendini te kedsekezu, ne ebuyù a te zeisey zà he wahig duen te umuy zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Emun ebpemineg sikandin he ipeinum e zin ragkes is menge kemilyu ku, deyzey ke iyan en sikandin mibpilì nu he vahi he egkehimu he egkeesawa te anak te egalen ku.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ne te wazè e pa mekeipus he ed-ampù, nekeuma si Rebeka he edtiang te idsekezu zin he umuy. Midtupang sikandin pehendiyà te kalut su edsekezu. Migkeǥiyan ku sikandin te, ‘Ipeinum e kun.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Impekevavè din haazà is umuy ziyà te pemenayen din, he egkaǥi te, ‘Sigi, inum kad, ne ibpeinum ku zaan is menge kemilyu nu.’ Umbe mid-inum a, ne impeinum din daan is menge kemilyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ne kegkepasad dutun, mid-insaan ku sikandin ke hentei sikandin ki anak. Midtavak sikandin te, ‘Anak a ni Betuel te anak ni Milca he esawa ni Nahor.’ Ne zutun mid-eritisan ku is izung din, ne imperirintì ku sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Midlangkeb a su ed-ezapen ku is Nengazen. Midalig ku is Nengazen, he Megbevayà te egalen ku si Abraham. Iyan sikandin mibpeturedu kedì te hustu he lugar, he zutun ku egkaahà is anak te kezuzumahi te egalen ku he egkehimu he esawa te anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Ne ǥuntaan, egkesuatan ku he metueni ku ke ibpeesawa niw si Rebeka ki Isaac he iyan kebpaahà niw te keupiya niw te egalen ku. Keǥi kew he zaan para metueni ku zaan ke hengkey is ed-ul-ulahan ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ne midtavak dutun si Laban wey si Betuel te, “Tenged te iyan egkesuatan heini te Nengazen, hengkey pa is egkekaǥi zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Heini zed si Rebeka, dumaha niw en sikandin ke ed-ulì kew para egkehimu sikandin he iyan esawa te anak te egalen nu, sumalà is migkaǥi kenikew te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ne hein nezineg duen te suluǥuen ni Abraham haazà is lalag dan midlangkeb en maan sikandin is ed-azap diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ne zutun migkuwa zin haazà is uwiten din he menge elahas he pelata ragkes is menge visti, ne imbeǥey zin ki Rebeka. Mibeǥayan din daan te mahalen he menge gasa he inggasa zin dutun te menge suled wey iney ni Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ne zutun, migkaan haazà is suluǥuen wey sikan is menge zuma zin. Ne zutun dan en mekehizeǥà te haazà he kezukileman. Ne hein nepawà mid-enew zan ne migkaǥi haazà is suluǥuen te, “Ed-ulì ad guntaan diyà te egalen ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ne midtavak dutun is iney wey is meemahan ni Rebeka te, “Deyzey ke kenè nu zèpa zumaha si Rebeka minsan taman dà te sepulù he andew, ne egkeiwas haazà ne human kew ebpekeǥenat.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Piru migkaǥi haazà is suluǥuen te, “Kenà a keniyu senggena. Midhimu en te Nengazen he metuman is tuyù ku kayi, umbe ipeulì e en keniyu ziyà te egalen ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ne midtavak sikandan te, “Ed-umawen tew zèpa si Rebeka, ne ed-insaan tew sikandin ke hengkey is egkesuatan din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Umbe mid-umew zan si Rebeka ne mid-insaan te, “Egkesuat ke ve he eduma kandin guntaan?” Midtavak si Rebeka te, “Uya, egkesuat a he eduma.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Umbe, impezuma zan si Rebeka wey is meritan he ed-elima kandin diyà te suluǥuen ni Abraham wey zuen te menge zuma zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Mibpenubtuvazan dan si Rebeka zutun te kegenat din. Ke sikandan te, “Sikew is etevey zey, berakat he liblibuwen is menge kevuwazan nu. Berakat daan he mezaag te menge kevuwazan nu is menge kuntada zan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ne nepasad dutun, mid-untud si Rebeka wey sikan is menge suluǥuen din he vahi duen te menge kemilyu zan, ne miduma sikandan duen te suluǥuen ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ne si Isaac, diyà sikandin ed-ubpà te Negev, beǥu pa sikandin mekeulì he ebpuun te Beer Lahai Roi. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Duen timpu zutun ne malù en merusirem, migawas sikandin te valey ne midriǥuriǥu. Duen nepantew zin he kemilyu he ebpelingguma. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Hein nepantew ni Rebeka si Isaac, midrenà sikandin dutun te kemilyu zin ");
INSERT INTO mbbOT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ne mid-insaan din sikan is suluǥuen ni Abraham te, “Hentei haazà is edsinuǥung kenitew?” Ne midtavak haazà is suluǥuen te, “Egalen ku sikandin he si Isaac.” Ne zutun migkuwa ni Rebeka is lembung din ne midtembunan din is dagwey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Impenudtul zuen te suluǥuen diyà te ki Isaac is langun he mid-ulaula zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ne miduma ni Isaac si Rebeka ziyà te tulda he mid-ubpaan dengan te iney zin he si Sara. Ne neked-esawa zan ne utew mibmahal ni Isaac si Rebeka. Human maawà is seeng ni Isaac tenged te kebpatey te iney zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ne mid-uman mebpengesawa si Abraham te vahi he migngezanan ki Ketura. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Is menge anak dan iyan ensi Zimran, Jokshan, Medan, Midian, Ishbak, wey si Shua. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jokshan ne iyan anak din si Sheba wey si Dedan. Is menge kevuwazan ni Dedan ne iyan is menge Ashurnen, menge Litushnen, wey Liumnen. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Is menge anak ni Midian ne iyan si Efa, si Efer, si Hanoc, si Abida, wey si Eldaa. Iyan heini sikandan menge kevuwazan ni Ketura. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Iyan si Isaac ibpepengevilin te langun he menge azen ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Piru te wazè pa mebpatey si Abraham, duen daan impemeǥey zin diyà te menge anak din he maama he anak te zuma he menge esawa zin, ne ziyè din sikandan ipeubpà te tanà he zapit te edsilaan, he meziyù te anak din si Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Is keluǥayad te untung ni Abraham 175 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Utew en meǥurang sikandin dutun te kebpatey zin, ne in-amur sikandin te menge kepuun din he nemematey en. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Inleveng sikandin te menge anak din he si Isaac wey si Ishmael ziyà te surung he Macpela, he uvey te Mamre, he vevesukà dengan ni Efron he anak ni Zohar he Hitihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Haazà is tanà, ne mibpemasa ni Abraham dutun te menge Hitihanen. Diyà si Abraham ileveng wey is esawa zin he si Sara. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ne hein minatey en si Abraham, midtuvazan te Megbevayà is anak din he si Isaac, ne ziyà si Isaac med-ubpà te Beer Lahai Roi. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iyan heini guǥud mehitenged te pemilya ni Ishmael he anak ni Abraham diyà te ki Hagar he Ehiptohanen, he uripen ni Sara. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Iyan heini menge ngazan te menge anak ni Ishmael he maama, puun te kinikekayan: si Nebayot, Kedar, Adbeel, Mibsam, ");
INSERT INTO mbbOT_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO mbbOT_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafish, wey Kedema. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Iyan heini sikandan menge anak ni Ishmael, ne nehimu sikandan he pengulu te 12 he tribu he kevuwazan ni Ishmael. Ne is menge ngazan dan, ne iyan daan inngazan te menge inged he mid-ubpaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Is keluǥayad te untung ni Ishmael 137 he tuig. Minatey sikandin ne in-amur sikandin te menge kepuun din he nemematey en. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Diyà med-ubpà is menge kevuwazan din te menge inged he ebpuun te Havila pehendiyà te Shur, he zapit te edsilaan te Ehipto pehendiyà te Asiria. Ne migkuntada zan is langun he menge kezuzumahi zan he kevuwazan ni Ishmael. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iyan heini guǥud mehitenged te pemilya ni Isaac he anak ni Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Menge 40 en is penuiǥen ni Isaac dutun te kebpekeesawa zin ki Rebeka he anak ni Betuel he Aramihanen he tig-Padan Aram. Etevey si Rebeka ni Laban he Aramihanen daan. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tenged te kenà ed-anak si Rebeka, mid-ampù si Isaac diyà te Nengazen he med-anak ded is esawa zin. Midtavak te Nengazen is ked-ampù din, umbe mibmeǥingey zutun si Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Egkeǥezam din is henduen be te ebpezumuǥà haazà is sereping he menge vatà diyà te ǥetek din. Migkaǥi si Rebeka te, “Emun iyan bes heini egkeulaula kandan te huziyan he timpu, deyzey nasì ke mebpatey ad.” Umbe mid-insà sikandin diyà te Nengazen mehitenged kayi. Migkaǥi is Nengazen diyà te kandin te, ");
INSERT INTO mbbOT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","“Iyan heeyan ebpuunan is dezuwa he vatà he keniyan te getek nu te zezuwa he nasyun. Ne heini is dezuwa he grupu te menge etew ne ebpekuntedehey. Mezesen haazà is sevaha kenà haazà is duma zin. Is kakey egkehimu he suluǥuen te hazi zin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ne hein mid-anak en si Rebeka, sereping iyan haazà is in-anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Haazà is kakey, ne meriǥàriǥà wey vulvulen is tivuuk he lawa zin, umbe migngezanan dan ki Esau, he ke và dà egkeǥiya, “Bulvulen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ne hein edlepew en haazà is ikezuwa, ne migewezan din is palu te sereping din, umbe migngezanan dan haazà ki Jacob, he ke và dà egkeǥiya, “Egawed diyà te palu.” Mibpenuiǥen en dutun si Isaac te 60 he tuig te ked-enaka ni Rebeka kayi te sereping. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ne hein midekelè en haazà is menge vatà, utew metau si Esau he ebpenuǥes, ne layun sikandin egketalus. Ne si Jacob mulà ne mevented, diyè dà sikandin te menge tulda ed-ubpàubpà su perevantey te uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Pelanggà ni Isaac si Esau su egkesuat layun sikandin he egkaan te egkengepenganup ni Esau, piru si Jacob ne iyan mulà pinelanggà ni Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ne sevaha he andew, te kemulu en edhilutù si Jacob te menge tilas he meriǥà, ne nekeulì si Esau is nenuǥes ne utew sikandin nevitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ne migkeǥiyan din si Jacob te, “Beǥayi e en kun, ipekaan ad keniyan te sinuba nu he meriǥàriǥà su utew ad egkevitil.” (Ne tenged dutun, egngezanan daan si Esau ki Edom, he ke và dà egkeǥiya, “Meriǥà”.) ");
INSERT INTO mbbOT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ne midtavak si Jacob te, “Wey ku sikew ebeǥayi kayi emun ibeǥey nu kedì is ketenged nu te kegkekakey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ne midtavak si Esau te, “Uya, su hengkey is pulus te ketenged ku emun ebpatey a te kegkeumes.” ");
INSERT INTO mbbOT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Piru midtavak si Jacob te, “Penangdù ka zèpa kedì.” Ne zutun nenangdù si Esau he ibeǥey zin en ki Jacob is ketenged din te kegkekakey. ");
INSERT INTO mbbOT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ne zutun mibeǥayan sikandin ni Jacob te sinevawan he tilas. Nekepasad sikandin he egkaan wey ed-inum, ne zutun migenat sikandin. Ne pinaaǥi zutun mid-engkezan ni Esau is ketenged din, he kegkekakey. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ne mid-aǥi en is bitil zutun te lugar he mid-ubpaan ni Isaac, kenà haazà kes bitil te kaazen pa ni Abraham. Midhendiyà si Isaac te ki Abimelec, sikan is hadì te menge Filistihanen he ziyà te inged he Gerar. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ne mibpaahà is Nengazen kandin, he egkaǥi te, “Kenè ka hendiyà te Ehipto; diyan ke zà ubpà te lugar he ibpeehè ku kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kayi ke zà ubpà dèpa su edumahan ku sikew wey edtuvazan ku sikew. Ibeǥey ku heini kenikew wey ziyà te menge kevuwazan nu heini is langun he tanà. Edtumanen ku is pesarig ku te amey nu he si Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Edhimuwen ku he medmezakel is menge kevuwazan nu iring kezakel te menge vituen diyà te langit, ne ibeǥey ku heini kandan is langun he tanà. Ne pinaaǥi kandan, edtuvazan ku is langun he etew kayi te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ebeelan ku heini su mibpezumazuma si Abraham kedì. Midtuman din is langun he menge suǥù wey penurù ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Umbe ziyà med-ubpà si Isaac te Gerar. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mekempet si Rebeka, umbe emun ebpenginsà haazà is menge tig-Gerar ziyà te ki Isaac mehitenged te esawa zin, ne edtevaken din te etevey zin si Rebeka. Egkahandek sikandin he egkaǥi he esawa zin, su kela ke himetayi zan sikandin para maaǥew zan si Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Malù en neuǥet is ked-ubpà eni Isaac diyà te Gerar. Sevaha he andew zutun, neserengà he midsinulew ziyà te bintanà si Abimelec he hadì te menge Filistihanen, ne neehè din he ebpekepkepà si Isaac wey si Rebeka. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ne zutun impetawag din si Isaac, ke sikandin te, “Esawa nu ves sikandin? Maan is migkaǥi nu he etevey nu sikandin?” Ne midtavak si Isaac te, “Nahandek a, kela ke himetayi a tenged kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ne migkaǥi si Abimelec te, “Kenà meupiya is mibeelan nu kenami. Penenglitan ke zuen kayi te menge sakup ku midhulid kandin, iyan ka pezem egkevasul te egkehimu he salè dey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ne zutun impesavut ni Abimelec is langun he menge sakup din. Ke sikandin te, “Is minsan hentei he ebaal te kenà meupiya kayi te maama wey te esawa zin ne edhimetayan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ne zutun he lugar mid-ezek si Isaac ne nekeraǥun sikandin te ke 100 metakep te haazè dà he tuig, tenged midtuvazan sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mid-iseg sikandin med-uswag taman te utew en sikandin midsepian. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Neima kandin is menge Filistihanen su utew mezakel is menge kerehidu zin, kambing, baka, wey menge suluǥuen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ne tenged te kegkeima te menge Filitihanen ki Isaac, mibumbunan dan te tanà is menge kalut he mibpekelutan te menge suluǥuen dengan te amey zin he si Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ne zutun migkaǥi si Abimelec diyà te ki Isaac te, “Deyzey ke ed-awè kew kayi, su lavew en is keniyu he ǥehem te kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Umbe mid-awè en dutun si Isaac, ne ziyà medhalin te zal-ug te Gerar ne midtutulda sikandin ne ziyà med-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ne mid-umanan din pekeluti haazà is menge kalut te amey zin dengan he si Abraham he mibumbunan te menge Filistihanen hein minatey en si Abraham. Ne is menge inngazan ni Abraham duen te menge kalut, ne iyan daan inngazan ni Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Diyà te zal-ug, mibangbang is menge suluǥuen ni Isaac te beǥu he kalut ne nekeehè dan te serebseb. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Piru mibpekidtebek is menge bekidu he tig-Gerar te menge bekidu ni Isaac su kandan kun haazà he kalut. Umbe migngezanan haazà ni Isaac he kalut te Esek, he ke và dà egkeǥiya, “Tebek,” tenged te mibpekidtebek is menge tig-Gerar kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ne mid-uman mebangbang is menge suluǥuen din te selakew en he kalut, piru midtebekaayan dan ded haazà te menge tig-Gerar. Umbe migngezanan ni Isaac haazà he kelut te Sitna, he ke và dà egkeǥiya, “Tebekaayaan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mid-awà dutun ensi Isaac ne mid-uman mebangbang sikandan te selakew-en maan he kalut. Wazè dan human heini lewenaayi, umbe migngezanan ni Isaac haazà is kalut te Rehobot, he ke và dà egkeǥiya, “Melu-ag.” Su ke sikandin te, “Mibeǥayan kiw en human te Nengazen te melu-ag he ubpaan para med-iseg kiw pa mebmezakel kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ne puun dutun, midhalin si Isaac diyà te Beersheba. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Dutun te haazà he kezukilemi te kebpekeuma zin diyà, mibpaahà kandin is Nengazen he egkaǥi te, “Iyan a kes Megbevayà te amey nu he si Abraham. Kenè ka mahandek su iyan a zuma nu. Edtuvazan ku sikew ne edhimuwen ku he utew medmezakel is menge kevuwazan nu tenged te suluǥuen ku he si Abraham.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Umbe mibaal si Isaac dutun te pemuhatà ne mid-azap te Nengazen. Impehitindeg din dutun he lugar is tulda zin ne impevangbang din is menge suluǥuen din te kalut. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Midhendiyà si Hadì Abimelec he ebpuun te Gerar ne miduma zin is sumesambag din he si Ahuzat wey sikan is egalen te menge sundaru zin he si Picol. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Mid-insaan ni Isaac sikandan te, “Maan is midhengkayi kew te kedì? Egkepeukan e man keniyu, umbe impaawà a keniyu ziyan te lugar niw?” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ne midtavak dan te, “Nesavut dey he is Nengazen eduma kenikew, umbe neisip dey he kinanahanglan he edhimu kiw te kebpekid-uyun duma zutun is penangdù. Penaad ka kenami ");
INSERT INTO mbbOT_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","he kenè key keniyu pesipelahi, su wazè dey man daan sikew pesipelahi hein diyè ka te kenami. Mibpurungan dey sikew, impeǥenat dey sikew he melinawen. Deyzey pezem he tuvazi ke pa te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Umbe midtukud si Isaac te keemuran para kandan, ne migkaan dan wey nemen-inum dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Utew pa meselem dutun te sunud he andew, ne mibpesèsaazè dan. Ne hein nepasad, ne impeǥenat ni Isaac sikandan he melipayen. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Haazà he andew, nekeuma is menge suluǥuen ni Isaac, ne midtudtulan dan sikandin he zuen wahig duen te kalut he mibengbangan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Migngezanan ni Isaac haazà te Siba. Umbe taman en guntaan iyan ngazan dutun is Beersheba. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ne hein 40 en is penuiǥen ni Esau, mid-esawa zin si Judith he anak ni Beeri he Hitihanen, wey si Besemat he anak ni Elon he Hitihanen daan. ");
INSERT INTO mbbOT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Utew ingkeseeng ni Isaac wey ni Rebeka haazà is menge ambey zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Utew en meǥurang si Isaac ne kenè en utew ebpekaahà. Ne mid-umew zin is anak din he kakey he si Esau. Ke sikandin te, “Mama.” Ne midtavak si Esau te, “Hengkey, amà?” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Migkaǥi si Isaac te, “Meǥurang e en utew, ne kenè en egkeuǥet ne ebpatey a. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kuwaa nu is panè nu, ne hendiyè ka te unayan ne penuǥesi a ziyà. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ne hilutua nu kedì is utew ku egkesuati he keenen ne uwita nu kayi te kedì su egkeenen ku. Egkepasad dutun ne ebpenubtuvazan ku sikew te kenè e pa ebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mibpemineg bes dutun si Rebeka te kemulu edlelaǥi ni Isaac si Esau. Umbe hein migenat en si Esau is ebpenuǥes diyà te unayan dan, ");
INSERT INTO mbbOT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","migkeǥiyan ni Rebeka is anak din he si Jacob te, “Nezineg ku ǥeina he migkeǥiyan te amey nu is kakey nu he si Esau te, ");
INSERT INTO mbbOT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Penuǥesi a ne hilutui a te utew ku egkesuati he linutuan. Su ebpenubtuvazan ku sikew kayi te etuvangan te Nengazen te kenè e pa ebpatey.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Umbe mama, pemineg ka te idsuǥù ku kenikew: ");
INSERT INTO mbbOT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hendiyè ka te uyaǥen tew ne kuwa ka te zezuwa he nati he kambing he utew melambeg su edhilutuen ku heini te egkesuatan te amey nu te egkaan he linutuan. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ne uwita nu heini ziyà te kandin su wey iyan ke zin mepenubtuvazi te kenè pa sikandin ebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ne midtavak si Jacob diyà te iney zin te, “Kenà buwa egkehimu, su vulvulen utew si Esau ne siak kenà mulà. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kela ke ǥewezi a ni amà ne egketuenan din he mid-ilad ku sikandin, ne kenè e zin en ebpenubtuvazan kekenà, nasì e zin dà edrewaki.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Midtavak si Rebeka te, “Mama, kediey en he televaken emun edrewakan ke zin. Beeli nu is ebpeelan ku kenikew. Genat ke en ne kuwai a te menge kambing.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ne migenat si Jacob is egkuwa te kambing, ne mid-uwit din diyà te iney zin, ne midhilutù haazà ni Rebeka te utew egkesuati ni Isaac te egkaan he linutuan. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ne zutun migkuwa zin is utew meupiya he visti ni Esau ziyà te valey zan, ne inseluub din heini ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Midsevukan din te lundis dutun te kambing is beklawan ni Jacob wey lieg din. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ne imbeǥey zin ki Jacob haazà is keenen wey supas he midhilutù din. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mid-uwit haazà ni Jacob diyà te amey zin, ke sikandin te, “Amà!” Midtavak si Isaac te, “Hentei ka he anak ku?” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ne midtavak si Jacob te, “Iyan a si Esau, kes kakey he anak nu. Midtuman ku en is insuǥù nu kedì. Enew ka wey ka mekekaan duen te neutel ku su wey a kenikew mepenubtuvazi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ne mid-insà si Isaac te, “Mama, maan is utew ka meǥaan nekeutel?” Midtavak si Jacob te, “Mid-uǥupan a te Nengazen he Megbevayè nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Migkaǥi si Isaac te, “Uvey ka, mama, su wey ku sikew meǥewezi wey ku mesusi ke tutuu ve iyan he iyan ka si Esau he anak ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ne mid-uvey zutun si Jacob, ne mibpanamsam sikandin te amey zin he egkaǥi te, “Is laǥeng nu ne laǥeng ni Jacob, piru is menge velad nu ne ki Esau iyan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wazà ni Isaac mekilala si Jacob, su is menge velad din bulvulen iring te velad ni Esau. Umbe te wazè din pa penubtuvazi, ");
INSERT INTO mbbOT_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","mid-insè pa maan si Isaac te, “Tutuu ve iyan he iyan ka si Esau?” Ne ke si Jacob te, “Tutuu iyan su si Esau a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Migkaǥi zutun si Isaac te, “Na, uwita nu en kayi heeyan is midhilutù nu he netuǥesan nu, ne emun ebpekekaan ad ne epenubtuvazan ku sikew.” Ne zutun imbeǥey ni Jacob haazà is egkeenen wey vinu, ne migkaan sikandin wey mid-inum. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ne migkeǥiyan ni Isaac sikandin te, “Uvey ke kun kayi, mama, ne hezeki a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ne mid-uvey si Jacob diyà te kandin ne midhezekan din. Ne hein nahazek ni Isaac is ngazeg te visti zin, ne mibpenubtuvazan din si Jacob he egkaǥi te, “Heini is ngazeg kayi te anak ku iring te ngazeg te vevesukà he midtuvazan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Berakat he veǥayi ka te Megbevayà te uuzaran he tanà he layun egkahames te zehemug he ibeǥey zin, su wey utew zekelà is keuyaǥan nu wey vinu. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Berakat he mezakel he menge tribu is egkehimu menge suluǥuen nu, wey edtahud dan kenikew. Berakat he iyan ka mehimu he egalen te menge suled nu, wey medtahud kenikew is menge hazi nu. Berakat he is edrawak kenikew ne iyan merewaki, ne tuvazi mulà is ebpenuvadtuvad kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ne hein neipus ni Isaac is kebpenubtuvazi zin ki Jacob, ne migenat si Jacob. Beǥu pa utew zutun mid-awà si Jacob, ne iyan daan kebpekeulì ni Esau te nenuǥes. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Midhilutù daan sikandin te metaam he idsezà ne mid-uwit din diyà te amey zin. Ke sikandin diyà te amey zin te, “Amà, enew ka wey ka mekekaan kayi te netuǥesan ku su wey a kenikew mepenubtuvazi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mid-insà si Isaac kandin te, “Hentei ka?” Midtavak sikandin te, “Si Esau a, is kakey he anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Hein nezineg haazà ni Isaac, migkerker sikandin ne nemensag, “Hentei ves haazà is neketuǥes duen te mid-uwit kayi te kedì he keenen? Beǥu e pa nekepasad he egkaan kayi te kebpekeuma nu. Mibpenubtuvazan ku en sikandin ne kenè ku en egkehimu te edhawì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Hein nezineg haazà ni Esau, nekelelendag is edsineǥew ne migkeǥiyan din is amey zin te, “Amà, penubtuvazi a zaan!” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Midtavak si Isaac te, “Mid-ekalan a te hazi nu ne mid-eǥawan ke zin te ibpenuvadtuvad ku pezem kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ne migkaǥi si Esau te, “Ikezuwe en heini te kebinuangi zin kedì. Umba ves Jacob is inngazan kandin. Mid-eǥawan e zin te ketenged te kegkekakey ku, ne ǥuntaan migkuwa zin pa is kebpenubtuvad he para kedì.” Ne zutun mid-isaan din is amey zin te, “Ama, wazè nu en be igkepenuvadtuvad kediey?” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ne midtavak si Isaac te, “Midhimu ku en he iyan sikandin egalen nu ne is langun he menge kezuzumahi zin ne midhimu ku en he menge suluǥuen din. Impenuvadtuvad ku en diyà te kandin is idsegkayà he egkekaan wey egkeinum. Umbe wazè en egkehimu ku para kenikew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ne mibpehizuhizu pa utew si Esau te amey zin te, “Amà, wazè en be iyan minsan sevaha zà he igkepenuvadtuvad nu? Penubtuvazi a zaan.” Ne zutun midsineǥew en maan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Midtavak si Isaac te, “Diyè ka ebpekeubpà te tanà he kenà uuzaran, wey kenà heini lelayun egkahames te zehemug he tuvad te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Pinaaǥi zà te kebpekidtebek egkekuwa nu is igkeuyag nu, ne egkehimu ka he suluǥuen te hazi nu. Piru emun ed-atu ka kandin, ebpekeǥawas ka te kegkeveyveyai zin kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ne midumutan ni Esau si Jacob tenged te kebpenubtuvazi ki Jacob te amey zin. Nekekaǥi si Esau ziyà te ǥehinawa zin te, “Kenè en utew egkeuǥet ne ebpatey si amà; emun ebpatey en sikandin, edhimetayan ku si Jacob.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Piru netudtulan si Rebeka te egkeisip ni Esau, umbe mid-umew zin si Jacob ne migkeǥiyan din te, “Is kakey nu he si Esau, iyan ebpekepayùpayù te ǥehinawa zin is egkeisip din he edhimetayan ke zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Umbe, mama, pemineǥa nu is egkeǥiyen ku: Pelaǥuy ka ziyà te Haran, diyà te meemahan ku he si Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ne ziyè ka ubpà dèpa taman te egkaawà is pauk kenikew te kakey nu, ");
INSERT INTO mbbOT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ne egkelipatan din en is mibeelan nu kandin. Ebpeveyaan ku zà sikew ziyan emun egkaaween is rerangit din kenikew. Kenè ku egkesuatan he egkaawè kew is dezuwa kayi te kedì te senga andew zà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ne migkeǥiyan dutun ni Rebeka si Isaac te, “Utew ku en igkerasey te ed-isip-isip is tenged kayi te menge esawa ni Esau he menge Hitihanen. Emun iyan ed-esewaan ni Jacob is tig-kayi zed he vahi he Hitihanen, deyzey pa ke ebpatey e en nasì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ne mid-umew zutun ni Isaac si Jacob, ne mibpenubtuvazan din, wey migkeǥiyan din te, “Kenè ka limbe pengesawa te vahi he tig-Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Penines ka, ne pehendiyè ka te Padan Aram, diyà te apù nu he si Betuel he amey te iney nu. Diyè ka pengesawa te sevaha te menge raǥa he anak ni Laban te meemahan te iney nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Berakat he tuvazi ka te Megbevayà he Mekeǥeǥehem, ne veǥayi ke zin te mezakel he kevuwazan, su wey ka mehimu he amey te mezakel he grupu te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Berakat he iveǥey zin kenikew wey te kevuwazan nu is tuvad he imbeǥey zin diyà te apù nu he si Abraham, su wey mehimu heini he kenikew he tanà is neubpaan nu ǥuntaan te sevaha he lumelengyawà. Heini he tanà ne imbeǥey te Megbevayà diyà te ki Abraham.” ");
INSERT INTO mbbOT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ne impehipanew ni Isaac si Jacob pehendiyà Padan Aram, diyà te lugar ni Laban he anak ni Betuel he Aramihanen. Si Laban meemahan ni Rebeka he iney ni Jacob wey ni Esau. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Netuenan ni Esau he mibpenubtuvazan ni Isaac si Jacob wey impehendiyè din te Padan Aram su wey ziyà sikandin mekepengesawa. Ne nezineg din daan he zutun te kebpenuvadtuvad ni Isaac intelaan din ki Jacob he kenà sikandin mebpengesawa te vahi he tig-Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ne netuenan din daan he mibpemineg si Jacob te suǥù te amey zin wey iney zin su migenat en pehendiyà te Padan Aram. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ne human dutun mesavut ni Esau he kenè bes iyan egkesuatan te amey zin he si Isaac sikan is menge vahi he tig-Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ne zutun midhendiyà sikandin te anggam din he si Ishmael he anak ni Abraham diyà te ki Hagar. Gawas dutun te zezuwa he esawa zin, mid-esawa zin daan si Mahalat he anak ni Ishmael wey etevey ni Nebayot. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mid-awà si Jacob dutun te Beersheba ne midhendiyà sikandin te Haran. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ne hein nekeuma sikandin diyà te sevaha he lugar, ne zutun dà sikandin medhizeǥà te haazà he kezukilemi su midsanlep en is andew. Migkuwa sikandin te vatu, ne mid-ulunè din haazà dutun te kedlipezeng din. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ne zutun te kedlipezeng din, neketeǥeinep sikandin te heǥezan he nekehitindeg kayi te tanà ne nekeuma ziyà te langit. Neehè din is menge velinsuǥuen te Megbevayà he ebpememenahik wey ebpemenaug dutun te heǥezan. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ne ziyà te zivavew zutun te heǥezan, neehè din is Nengazen he edhithitindeg ne migkaǥi sikandin te, “Iyan a sikan is Nengazen, is Megbevayà ni Abraham wey ni Isaac. Ibeǥey ku kenikew wey te menge kevuwazan nu heini he tanà is midhizeǥaan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Is menge kevuwazan nu egkehimu he iring kezakel te eliyavuk te tanà. Pinaaǥi kenikew wey te menge kevuwazan nu, edtuvazan ku is langun he menge etew kayi te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tentenuzi nu he layun a eduma kenikew wey ebentayan ku sikew minsan hendei ka ebpevayà. Ibpelikù ku sikew kayi he tanà, ne kenè ku sikew ed-ewaan taman te egketuman ku is menge saad ku kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ne nepukew si Jacob, ne ke sikandin te, “Wazè ku metueni he mibulusan bes te Nengazen heini he lugar.” ");
INSERT INTO mbbOT_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ne nahandek sikandin, ke sikandin te, “Utew a ebpendeǥubduva kayi he lugar! Ubpeey heini te Megbevayà ne kayi ves is gemawan pehendiyà te langit!” ");
INSERT INTO mbbOT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Utew pa zutun meselem te ked-enew ni Jacob. Migkuwa zin haazà is batu he mid-ulunè din, ne impehitindeg din haazà he tedeman din. Mid-itisan din haazà te lana su wey mehimu he segradu. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Migngezanan haazà ni Jacob he lugar te Betel, he ke và dà egkeǥiya, “Baley te Megbevayà.” Piru is inged dutun dengan migngezanan te Luz. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ne mibpenangdù dutun si Jacob he egkaǥi te, “He Megbevayà, emun edumahan a wey ebentayan a kenikew kayi te hipenawan ku wey emun ebeǥayan a kenikew te egkeenen wey igkevisti, ");
INSERT INTO mbbOT_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","wey emun ebpekelikù a ziyà te ubpaan te amey ku he wazà mezaat he egkehitavù kedì, ne sikew is Nengazen, iyan ka Megbevayà he ed-ezapen ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ne heini is batu he impelastar ku kayi he tedeman ku, ebpekepenistiǥus he kayi ka ed-ubpà he lugar. Ne ibeǥey ku kenikew is ikesepulù te langun he ibeǥey nu kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ne midlaus si Jacob te kedhipanew zin, ne nekeuma sikandin diyà te tanà te menge etew he zapit te edsilaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ne zuen neehè din diyà te unayan he sevaha he kalut, ne ziyà te uvey kayi zuen tetelu he leyuzan he kerehidu, su ziyà egkuwa is menge etew zutun te wahig he ibpeinum dan te menge kerehidu zan. Heini he kalut ne midtengevan te zekelà he vatu. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Edteǥan te menge bekidu te kerehidu he egkevurunburun is langun he menge kerehidu zan ne human dan id-awà haazà is batu he intangeb. Emun egkepasad dan te kebpeinum is menge kerehidu zan, ne idlikù dan haazà is batu. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ne mid-insaan ni Jacob haazà is menge bekidu te kerehidu te, “Geli, hendei kew ebpuun?” Midtavak sikandan te, “Tig-Haran key.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ne mid-insè en maan si Jacob te, “Egkekilala niw ve si Laban he apù ni Nahor?” Midtavak dan te, “Uya, egkekilala zey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ne mid-insaan en maan ni Jacob te, “Egkemenumenu en sikandin?” Midtavak dan te, “Meupiya zed man. Ahaa nu, heeyan ded is anak din he si Raquel is ebpelingguma duma te menge kerehidu zin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ne migkeǥiyan en maan ni Jacob te, “Metikang pa is andew, ne kenè pa uras he edtudilen is menge kerehidu, deyzey vuwa ke ibpeinum niw sikandan, ne ipeuman niw pa ipepenabtab.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Midtavak sikandan te, “Kenà egkehimu emun kenè dey pa egkevurunburun is menge kerehidu zey. Emun kayi en is langun he kerehidu ne edlilizen dey haazà is intangeb he vatu su wey mekeinum sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kemulu pa ebpekibitiyara si Jacob kandan dutun kebpekeuma ni Raquel he edtundan te menge kerehidu te amey zin, su sikandin is ed-elima kayi. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ne hein naahà ni Jacob si Raquel, is anak te anggam din he si Laban he edtundan te menge kerehidu, midhendutun sikandin te kalut, ne in-awè din is batu he intangeb dutun, ne impemeinum din is menge kerehidu te anggam din he si Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nepasad haazà, ne midhezekan din si Raquel, ne nekesineǥew sikandin su nehilelaut. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Migkeǥiyan din si Raquel te, “Anak a ni Rebeka, umbe enaken a te amey nu.” Mibpelelaǥuy si Raquel is ed-ulì ne midtudtulan din is amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Hein nezineg ni Laban he zutun si Jacob is enaken din he anak te etevey zin he si Raquel, migègaanan din sinuǥunga. Migkepkepan din ne midhezekan din ne miduma zin diyà te valey zan. Ne ipenudtul ni Jacob ki Laban is langun he nengeulaula. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ne migkeǥiyan sikandin ni Laban te, “Tutuu iyan he mesipeg ku sikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ne hein senge vulan en is ked-ubpà ni Jacob diyà te ki Laban, migkeǥiyan ni Laban sikandin te, “Kenà meupiya he edterebahu ka kayi te kedì he wazè nu suhul minsan pa te enaken ku sikew. Keǥiyi a kenikew ke hengkey is egkesuatan nu he idsuhul ku kenikew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Duen dezuwa he anak ni Laban he raǥa. Iyan ngazan te kakey si Lea ne si Raquel is hazi. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Meupiya he ed-ahaan is mata ni Lea, piru edhuna he mekempet wey mezagwey he ed-ahaan is dagwey ni Raquel. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tenged te egkesuatan ni Jacob si Raquel, migkeǥiyan din si Laban te, “Edterebahu a kayi te kenikew seled te pitu he tuig emun ibpeesawa nu kedì si Raquel.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Migkaǥi si Laban te, “Deyzey pa ke iyan ke zà ebpekeesawa kandin kenà te zuma he maama. Kayi ke zà ubpà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ne zutun, impepeniwakà ni Laban si Jacob taman te pitu he tuig wey zin meesawa si Raquel. Tenged te utew zin nesuati si Raquel henduen te pira zà he andew ziyà te kandin haazà is pitu he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hein netuman en haazà is pitu he tuig, migkeǥiyan ni Jacob si Laban te, “Nepasad-en is kebpeniwakè ku kenikew, iveǥey nu en kediey si Raquel su ebpehulizè key en.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Mid-uyun dutun si Laban, umbe midtukud sikandin te keemuran ne mid-imbita zin is langun he menge meǥinged dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Piru hein mezukilem en, iyan miduma ni Laban si Lea ziyà ki Jacob, he si Raquel man pezem. Ne mibpehulizà si Jacob wey si Lea. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Ne zaan he imbeǥey ni Laban si Zilpa is suluǥuen din he vahi ziyà te ki Lea wey mehimu he suluǥuen din.) ");
INSERT INTO mbbOT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Hein nepawà, netuenan ni Jacob he si Lea ves is hulid din. Ne zutun mibeyaan din si Laban he egkaǥi te, “Maan is mid-ulaula nu heini kediey? Mibpeniwakà a kenikew para meesawa ku si Raquel. Maan is mid-ekalan a kenikew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ne midtavak si Laban te, “Kenà heeyan betasan kayi te kenami he lugar is iyan ibpehuna ibpeesawa is hazi kenà is kakey. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Teǥazi nu zèpa he mepasad heini is pitu he andew he keemuran te eseweey niw ki Lea, su ibpeesawa ku human kenikew si Raquel, emun ebpekeuman ka ebpekepenilbi kedì te pitu pa maan he tuig.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ne mid-uyun dutun si Jacob te migkaǥi ni Laban. Hein nepasad haazà is sengesimana he keemuran te eseweey ni Lea, impeesawa zaan ni Laban kandin si Raquel. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Imbeǥey zaan ni Laban si Bilha is suluǥuen din he vahi ziyà te ki Raquel su wey mehimu he suluǥuen din.) ");
INSERT INTO mbbOT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ne mibpekidhulid si Jacob ki Raquel. Utew minahal ni Jacob si Raquel kenà si Lea. Ne mid-uman en maan si Jacob mebpeniwakà diyà te ki Laban te pitu pa maan he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Naahà te Nengazen he kenà mahal ni Jacob si Lea, umbe mibpengelinteuwan din he mekaanak si Lea, piru si Raquel ne kenà. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Mibmeǥingey si Lea ne mid-anak te maama ne migngezanan din ki Reuben, su ke sikandin te, “Naahà te Nengazen is merasey he egkeulaula ku, guntaan siguradu he ebmahalen ad human te esawa ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ne mid-uman sikandin mebmeǥingey, ne mid-anak en maan sikandin te maama. Migkaǥi sikandin te, “Mid-umanan a veǥayi te Nengazen te sevaha he anak he maama su nezineg din he wazà a mahala te esawa ku.” Umbe migngezanan din haazà is batà te Simeon. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ne mibmeǥingey en maan si Lea, ne mid-anak sikandin te sevaha pa maan he maama. Migkaǥi sikandin te, “Human ad buwa ebmahala te esawa ku su tetelu en is anak dey he maama.” Umbe migngezanan din haazà is batà ki Levi. ");
INSERT INTO mbbOT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mibmeǥingey med-uman si Lea ne mid-anak sikandin te sevaha pa he maama. Migkaǥi sikandin te, “Edeliǥen ku is Nengazen.” Umbe migngezanan din haazà is batà te Juda. Puun dutun, wazè en sikandin med-anak. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hein naahà ni Raquel he kenà sikandin ed-anak, neima sikandin ki Lea. Migkeǥiyan din si Jacob te, “Beǥayi a te anak su emun kenà a kenikew ebeǥayan te vatà ne ebpatey e en!” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ne nepeukan sikandin ni Jacob he egkaǥi te, “Maan, Megbevayè e ve? Kandin he ketau is kenè nu kebpekaanak!” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Migkaǥi si Raquel ziyà te ki Jacob te, “Emun iyan heeyan, pekidhulid ka ki Bilha he uripen ku su minsan pinaaǥi zà kandin is kebpekekuwa ku te vatà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ne imbeǥey ni Raquel ki Jacob si Bilha is uripen din para mehimu he esawa zin daan, ne mibpekidhulid si Jacob kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Mibmeǥingey si Bilha, ne mid-anak te maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ne migkaǥi si Raquel te, “In-awà human te Megbevayà is keelezan ku. Midtavak din is pengemuyù ku, su imbeǥey zin kedì is sevaha he anak he maama.” Umbe migngezanan din haazà is batà ki Dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ne mibmeǥingey en maan si Bilha is suluǥuen ni Raquel, ne mid-anak sikandin te maama, ikezuwe en haazà he anak dan ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Migkaǥi si Raquel te, “Mibpurung a mebpekidlawan te suled ku, ne nezaag ku sikandin.” Umbe migngezanan din haazà ki Naftali. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ne hein kenè en si Lea ebpekaanak, ne impeesawa zin ki Jacob is uripen din he si Zilpa. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mibmeǥingey si Zilpa, ne mid-anak te maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Migkaǥi si Lea te, “Utew meupiya is palad ku!” Umbe migngezanan din haazà is batà ki Gad. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mid-uman med-anak si Zilpa te maama he ikezuwa he anak dan ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Migkaǥi si Lea te, “Utew a nelipey! Ebpekekaǥi is menge zuma ku he vahi he utew ad melipayen.” Umbe migngezanan din haazà is batà ki Asher. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sevaha zutun he timpu he iyan ting-eǥani te trigu, midhendiyà si Reuben te vevesukà, ne zuen neehè din he pinemula he mandaǥura. Mibpenguwa sikandin te veǥas kayi, ne mid-uwit din diyà te iney zin he si Lea. Hein naahà haazà ni Raquel, migkaǥi sikandin te, “Beǥayi ad kun keniyan te mandragura he mid-uwit te anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ne midtavak si Lea te, “Wazè nu pe bes ikesuat is ked-eǥawa nu te esawa ku? Egkuwaan nu pa zaan is mandragura te anak ku?” Migkaǥi si Raquel te, “Emun ebeǥayan a kenikew te mandragura ne ibpehulid ku si Jacob kenikew kengkuwan ke mezukilem.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Hein mahapun en, ne ebpelingguma si Jacob is ebpuun diyà te vevesukà is ed-ulì en, ne midsinuǥung sikandin ni Lea, he egkaǥi te, “Kinahanglan he kayi ka edhulid te kedì guntaan te mezukilem, su mibeyazan ku en sikew ziyà te ki Raquel te mandragura he mid-uwit te anak ku.” Umbe ziyà te ki Lea medhulid si Jacob dutun te kezukilemi. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Midtavak te Megbevayà is pengemuyù ni Lea, ne mibmeǥingey sikandin. Ne mid-anak sikandin te maama he ikelima te anak dan ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Migkaǥi si Lea te, “Midsuhulan a te Megbevayà su impeesawa ku is uripen ku te esawa ku.” Umbe migngezanan din haazà is batà ki Isacar. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Mibmeǥingey en maan si Lea ne mid-anak te maama he ikeenem te anak dan ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Migkaǥi si Lea te, “Utew mahal is imbeǥey kediey te Megbevayà. Edtehuzen ad human te esawa ku su neveǥayan ku en sikandin te heenem he anak he maama.” Umbe migngezanan din haazà is batà te Zebulun. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ne is huziyan he in-anak ni Lea vahi, ne migngezanan din ki Dina. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Si Raquel ne wazà daan melipati te Megbevayà. Midtavak din daan is pengemuyù din he mekaanak daan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mibmeǥingey sikandin ne mid-anak te maama. Migkaǥi sikandin te, “In-awà human te Megbevayà is utew ku igkeeled.” Umbe migngezanan din haazà is batà te Jose, su ke sikandin te, ");
INSERT INTO mbbOT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“Berakat he umani e pa te Nengazen te sevaha pa he anak.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Hein in-anak en ni Raquel si Jose, migkeǥiyan ni Jacob si Laban te, “Tuǥuti e en human he mekeulì a ziyà te inged dey. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Iveǥey nu en kediey is menge esawa ku he mibpenilbiyan ku ziyan te kenikew wey menge anak ku, su ed-ulì e en. Netuenan nu ke hengkey kezekelà is nehimu ku te kebpenilbi ku kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Midtavak si Laban te, “Emun meupiya zà is gehinawa nu, ne zini ke pa ubpà. Su sumalà te kebarè ku, netuenan ku he midtuvazan a te Nengazen pinaaǥi kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Keǥiya nu ke pira is idsuhul ku kenikew, su ebeyazan ku sikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ne midtavak si Jacob te, “Nesavut nu en he utew a midhaǥù dini te kenikew, ne nesavut nu zaan ke hengkey is uswag te menge uyaǥen nu tenged te ked-elima ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Hein nekeuma a keyi pirapira zà is menge uyaǥen nu, piru ǥuntaan utew en mibmezakel, su midtuvazan ka te Nengazen pinaaǥi kedì. Umbe ǥuntaan kinahanglan he edsiguruwen ku is para te keugelingen ku he pemilya.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Nenginginsà si Laban te, “Hengkey is egkesuatan nu he ibayad ku kenikew?” Midtavak si Jacob te, “Kenè e en kenikew suhuli. Emun ebpemineg ka te egkesuatan ku ne kenà a ed-awà kayi, su ed-elimahan ku is menge uyaǥen nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Iyan heini: edsusiyen ku ǥuntaan is menge uyaǥen nu ne egkuwaan ku is meitem he menge kerehidu wey kevangan he menge kambing. Iyan dà haazà suhul ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ne emun egkeuǥet en, egketuenan nu ke egkeseriǥan a wey ke kenà, su edsusiyen nu haazà is menge uyaǥen he insuhul nu kedì. Emun duen egkeehè nu he kambing he kevangan etawa kerehidu he kenà meitem, keǥiya nu he tinakew ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Midtavak si Laban te, “Emun iyan heeyan egkesuatan nu, ebpemineg a.” ");
INSERT INTO mbbOT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Piru te haazà he andew, insivey ni Laban is kevangan he kambing, meemahan wey vehiyan, ragkes is meitem he menge kerehidu. Mibpeelimahan din heini te anak din he maama. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Insivey ni Laban is kandin he menge uyaǥen dutun te menge uyaǥen ni Jacob te keziyù he tetelu he andew emun edhipenawen. Iyan dà nesamà he uyaǥen dutun is mid-elimahan ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ne zutun, migkuwa si Jacob te menge subpang te kayu he alamu, ebilyanu wey platanu ne mibpenluk-itan din. Piru wazè din emini penluk-iti, umbe mibpemelvel-etan din te wazà luk-iti su wey mebeverekà he ed-ehaan haazà is subpang. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Diyè din haazà ipasek te uvey te peinumà te menge uyaǥen para maahà haazà dutun te menge uyaǥen emun ebpekeinum dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Dutun te egkesineruwan te subpang ebpepenpeniwelayà haazà is menge kambing emun edhendutun dan is ed-inum. Emun ed-anak dan, ne kevengan is anak dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Piru is ki Jacob he mibeelan te menge kerehidu: Zutun te kemulu en ebpepenpeniwelayà haazà is menge uyaǥen, ibpesinaru zin sikandan duen te kevangan he kambing wey zuen te menge meitem he kambing ni Laban. Ne pinaaǥi zutun te paaǥi ni Jacob, mibmezakel is kandin he menge uyaǥen, ne insivey zin te menge uyaǥen ni Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Emun ebpepenpeniwelayè en haazà is menge uyaǥen he memeupiya is lawa ziyà te peinumà, ne ibpasek en maan ni Jacob haazà is beverekà he subpang dutun te egkesineruwan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Emun memeluya haazà is menge uyaǥen he ebpepenpeniwelayà, ne kenè din ibpasek haazà is subpang. Umbe egketuusan is ki Laban su memeluya piru is ki Jacob ne memeupiya is menge lawa mulà. ");
INSERT INTO mbbOT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Pinaaǥi kayi, midsepian utew si Jacob. Ne utew midmezakel is menge uyaǥen din ragkes is menge kemilyu wey menge asnu. Mezakel zaan is menge suluǥuen din he menge maama wey vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nezineg ni Jacob is lalag te menge anak ni Laban, ke sikandan te, “Migkuwe en ni Jacob is hapit langun he menge azen te amey tew. Is langun he ketiǥeyunan din ne ebpuun te menge azen te amey tew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Neǥezam ni Jacob he nahalin en is gehinawa ni Laban kandin kenà te nehuna. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Migkeǥiyan te Nengazen si Jacob te, “Ulì ke en diyà te lugar he mid-ubpaan te menge kepuun nu, ziyà te menge kezuzumahi nu, ne iyan a eduma kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ne zutun mibpesuǥuan ni Jacob is menge esawa zin he si Raquel wey si Lea he medhendiyè dan te kandin, diyà te pepenebtavà te menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Migkeǥiyan din sikandan te, “Neǥezam ku he nahalin en is gehinawa zin kedì guntaan kenà te nehuna. Piru is Megbevayà te amey ku iyan edtavang kedì. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Netuenan niw en he mid-amin ku is taman te egkehimu ku te kebpenilbi ku ziyà te amey niw, ");
INSERT INTO mbbOT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","piru midterteruan e zin pa. Kesepulù din en helina is paaǥi zin te kedsuhuli kedì. Piru wazà ituǥut te Nengazen he mezaagdaag e zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Piru emun egkaǥi sikandin te, ‘Iyan suhul ku kenikew is menge uyaǥen he beverekà,’ ne beverekà is langun he anak te menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ne pinaaǥi zutun migkuwa te Megbevayà is menge uyaǥen te amey niw ne imbeǥey zin kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ne mid-uman megkaǥi si Jacob te, “Duen timpu he ebpemelelevag is menge uyaǥen, ne neketeǥeinep a. Neteǥeinep ku he is menge meemahan he kambing ne ebpemeniwaley te menge vehiyan he menge beverekà he kambing. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dutun te teǥeinep ku, migkeǥiyan a te velinsuǥuen te Megbevayà. Ke sikandin te, ‘Jacob!’ Midtavak a te, ‘Heini e zed!’ ");
INSERT INTO mbbOT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ne ke sikandin te, ‘Ahaa nu is langun he menge meemahan he kambing ne nekepeniwaley te menge vehiyan he menge beverekà he kambing. Mid-ulaula ku heini tenged te neehè ku is langun he mibeelan ni Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iyan a sikan is Megbevayà he mibpaahà kenikew ziyà te Betel kes lugar he zutun nu ipelastar kes tedeman nu he vatu he mid-itisan nu te lana. Dutun ka zaan mebpesarig kediey. Ne ǥuntaan, awè ka kayi te inged ne ulì ke en diyà te kenikew en he inged he zutun ka ianak.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ne zutun midtavak si Raquel wey si Lea ziyà te ki Jacob te, “Wazè dey en egkepengevilin te amey zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mid-isip key zin en he iring te kenè din menge anak. Imbelegyè key zin ne mid-amin din en te egastu is ingkepemasa kenami. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Is langun he ketiǥeyunan he midhawì te Megbevayà diyà te amey zey, ne egkeisip dey he iyan egkepengevilin dey wey te menge anak dey. Umbe pemineǥa nu is egkeǥiyen te Megbevayè nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Ne zutun, mibpenines si Jacob su ed-ulì diyà te Canaan, kes lugar te amey zin he si Isaac. Impeuntud din is menge esawa zin wey menge anak din te kemilyu. Mid-uwit din is menge uyaǥen wey is langun he menge azen he netiǥum din diyà te Padan Aram. Neserengà haazà duen te kegenat ni Laban hein mibpen-elutan din is menge kerehidu zin, ne zutun te wazè pa sikandin mekeulì, migkuwa ni Raquel kes ed-ezapen te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Neekalan ni Jacob si Laban is Aramihanen su wazè din keǥiyi he ed-awè dan en dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ne zutun te kegenat eni Jacob, mid-uwit din is langun he keleglaǥan din. Midrapas dan te Wahig he Eufrates ne ziyè dan medtandang te menge vuvungan te Gilead. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tetelu en dutun he andew is midlavey te kebpelaǥuy eni Jacob, ne human metueni ni Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ne zutun midtiǥum din is menge kezuzumahi zin ne midal-as dan. Ne hein ikepitu en he andew te kedal-as dan, ne neseutan dan si Jacob diyà te menge vuvungan te Gilead. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ne zutun he kezukilemi, mibpaahà is Megbevayà ki Laban te Aramihanen pinaaǥi te teǥeinep. Migkeǥiyan sikandin te Megbevayà te, “Kenè nu pesipelahi si Jacob.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mibpehitindeg si Jacob te tulda zin diyà te menge vuvungan te Gilead dutun te kegkeumahi kandin ni Laban. Ne zutun daan mebpehitindeg si Laban wey is menge zuma zin te menge tulda zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ne migkeǥiyan ni Laban si Jacob te, “Maan is mid-ulaula nu heini kedì! Maan is mid-ekalan a kenikew? Mid-uwit nu pa is menge anak ku, he henduen be te nengevihag te tebek. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Maan is mid-ekalan a kenikew ne migenat kew he wazà mebpenanghid kedì? Angin pezem ke migkaǥi kew kedì, minsan pezem mekeǥenat kew ne edlipeylipey kiw he edsunetahan te tamburin wey alpa. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wazè e en ganì kenikew ipehazek te menge apù ku wey menge anak ku te kegenat dan. Kenà meupiya is mid-ulaula nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Duen ku ketezengan pezem te kebpesipala kenikew, piru mibpaahà kedì is Megbevayà geina te mezukilem he ed-ezapen te amey nu, ke sikandin te, ‘Kenè nu pesipelahi si Jacob.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Netuenan ku he utew ka ebulunga ziyà te keniyu, umbe egkesuatan nu en he mekeulì ka. Piru maan is midtakew nu is menge ed-ezapen ku?” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Midtavak si Jacob te, “Wazà ad mebpenanghid kenikew su egkahandek a he kela ke teǥela nu hewia kayi te kedì is menge anak nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Piru emun mehitenged te ed-ezapen nu he netazin, emun egkehè nu heini kayi te minsan hentei kayi te kenami, ne siluti nu sikandin te kemetayen. Kayi te etuvangan te menge kezuzumahi ku he iyan ebpemekepenistiǥus, ahaa nu emun duen egkeehè nu he menge azen nu kayi te kenami, emun duen ne kuwaa nu.” Wazà metueni ni Jacob he si Raquel ves is migkuwa zuen te menge ed-ezapen ni Laban. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ne zutun, mibpen-ahà ni Laban haazà is menge ed-ezapen din dutun te tulda ni Jacob, diyà te ki Lea ragkes is menge tulda zuen te zezuwa he menge uripen he vahi te menge esawa ni Jacob. Piru wazè din maahà haazà is ed-ezapen din. Dutun te kedliǥawang din duen te tulda ni Lea, midseled sikandin daan diyà te tulda ni Raquel. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Piru ingke-eles-en ni Raquel ziyà te bulsavulsa zuen te silya te kemilyu zin, ne mibpinuuwan din heini. Ne midsusi ni Laban is langun he menge taǥù dutun te tulda ne wazè din maahà. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ne migkaǥi si Raquel ziyà te amey zin te, “Amà, kenà a kenikew mepeuki te kenà a ebpekehitindeg su neumahan a te binulan he zaru te vahi.” Wazà mesanggen si Laban he ebpen-ahà piru wazè din iyan maahà sikan is menge ed-ezapen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wazà meeǥen ni Jacob is kegkepauk din, umbe migkeǥiyan din si Laban te, “Hengkey ves is mezaat he neveelan ku? Hengkey utew is salè ku maan is midtelukunan e pa kenikew? ");
INSERT INTO mbbOT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Guntaan te nesusi nu en is langun he azen ku, emun duen azen nu he neehè nu, isavuk nu kayi te etuvangan te menge kezuzumahi ku wey te menge kezuzumahi nu, para meehè dan, ne iyan en sikandan metau ke hengkey is kandan he kukuman para kenita. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Seled te 20 he tuig is ked-ubpè ku ziyan te keniyu, ne wazà merenrani is menge vehiyan he kerehidu wey kambing nu minsan kesevaha. Wazà a zaan mekekaan te menge kerehidu nu he meemahan. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wazè ku en uwita ziyan te kenikew is menge uyaǥen nu he midhimetayan te menge zumezaas he menge langgam; segugunè ku heini ed-ilisi. Mibpeveyazan nu zaan kedì is menge uyaǥen nu he midtakew te timpu te maandew wey te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Iyan heini egkeulaula ku: utew a egkeiniti emun maandew, utew a egkeǥenew emun mezukilem, ne layun a egkepurang. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Menge 20 en he tuig is ked-ubpè ku ziyan te keniyu, 14 he tuig is kebpenilbi ku kenikew para kayi te zezuwa he anak nu he menge vahi. Ne mid-uman e pa medterebahu te heenem he tuig te kebekidu te menge uyaǥen nu. Piru hengkey heini is mibeelan nu? Ne kesepulù nu en helhelina is suhul ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Emun buwa wazà a tevangi te Megbevayà te amey ku he si Isaac, kes Megbevayà ni Abraham, kela ke midsegseg e en kenikew he wazà uwiten he minsan hengkey. Piru naahà te Megbevayà is kedhaǥù ku wey kedterebahu ku, umbe midawey ke zin geina he mezukilem.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Midtavak si Laban te, “Heini is menge vahi he esawa nu ne menge anak ku, is menge anak dan ne menge apù ku. Heeyan is menge uyaǥen nu ne kediey zaan. Langun he egkeehè nu kayi ne kediey. Piru ǥuntaan, kenè ku en egkahawì is menge anak ku wey menge apù ku? ");
INSERT INTO mbbOT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Meupiya vuwa ke edhimu ki te uyun. Edtukud ki te tedeman he vatu he iyan ebpenistiǥus te kebpeked-uyun ta.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Umbe migkuwa zutun si Jacob te zekelà he vatu ne impelastar zin he tedeman. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ne zutun midsuǥù din is menge kezuzumahi zin he medtambù dan te menge vatu. Kebpekepasad dan he edtambù te menge vatu ne zutun dan mebpemengaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Migngezanan haazà ni Laban is intambù he menge vatu te Jegar Sahaduta. Piru migngezanan heini ni Jacob te Galeed. Diyà te Hebreo, he ke và dà egkeǥiya, “Intambù he Ebpeketistiǥus.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Migkaǥi si Laban te, “Heini is intambù he menge vatu, ne iyan ebpenistiǥus te kebpeked-uyun ta te dezuwa.” Iyan heeyan mibpuunan ke maan is migngezanan haazà is intambù he menge vatu te Galeed. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Migngezanan daan te, “Mizpa,” he ke và dà egkeǥiya, “Ebantey,” su migkaǥi si Laban te, “Berakat he iyan ebantey kenitew is Nengazen emun ebpesuwayè kiw. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Emun ebpesipelahan nu is menge esawa nu he menge anak ku, wey emun ebpengesawa ke pa te zuma pa he vahi, tentenuzi nu he minsan ke kenè ku egkaahà, egkeehè ka mulà te Megbevayà he iyan ebpenistiǥus te neuyunan ta.” ");
INSERT INTO mbbOT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ne mid-uman pa megkaǥi si Laban diyà te ki Jacob te, “Heini zed is menge vatu he intambù he iyan tedeman wey ebpenistiǥus te kebpeked-uyun ta. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Iyan menge tuus he ebpeketistiǥus is Megbevayà. Tuus heini is intambù wey tuus daan heini is impelastar he vatu te uyun ta he kenà a edlavey kayi te intambù te kebpesipala kenikew, ne sikew zaan, kenè ka edlavey kayi te kebpesipala kedì. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ne ke edsupaken heini te minsan hentei kenita, berakat he siluti sikandin te Megbevayà ni Abraham wey Megbevayà ni Nahor he iyan daan Megbevayà te amey zan.” Ne mibpesarig daan si Jacob ne mibpetistiǥus te Megbevayà he edtehuzen te amey zin he si Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ne mibpemuhat sikandin dutun te vuvungan ne impekaan din te menge kezuzumahi zin. Ne hein nekekaan dan, dutun dan medhulavung. ");
INSERT INTO mbbOT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ne hein nepawà, midhezekan ni Laban is menge apù din wey menge anak din he esawa ni Jacob ne mibpenubtuvazan din. Ne zutun migenat su ed-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ne migenat en daan dutun ensi Jacob ne neumahan sikandin te menge velinsuǥuen te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ne hein naahà sikandan ni Jacob, ke sikandin te, “Menge sundaru heini te Megbevayà!” Ne migngezanan din haazà is tanà te Mahanaim. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ne zuen menge midsuǥù ni Jacob he impehuna zin diyà te ki Esau ziyà te tanà he Seir, kes lugar he egngezanan daan he Edom. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Mibpenurù din sikandan ke hengkey is egkeǥiyen dan diyà te ki Esau. Migkaǥi si Jacob te, “Keǥiyi niw si Esau te ziyà a med-ubpà te ki Laban ne wazè e pa ganì mekeulì taman guntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ne keǥiyi niw sikandan he zuen ku en menge vaka, menge asnu, menge kerehidu, wey menge kambing, ne zuen ku zaan menge suluǥuen he vahi wey maama. Keǥiyi niw sikandin he midsuǥù ku sikiyu he edhangyù kandin he ikeǥaǥew e zin ded.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ne hein nekelikù is menge midsuǥù ni Jacob, ke sikandan te, “Midhendiyè key te ki Esau, ne migenat en su edsinuǥungen ke zin. Duen din duma he 400 he menge maama.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ne zutun utew nahandek si Jacob ne kenà ebpeketareg, ne mibahin din te zezuwa he grupu is menge sakup din ragkes is menge kerehidu, baka, kambing, wey kemilyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tenged te neisip din is penenglitan ke ebpekeuma si Esau ne edsurungen din haazà is senge grupu ne ebpekepelaǥuy pa haazà is senge grupu. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ne zutun mid-ampù si Jacob te, “He Megbevayà te apù ku he si Abraham wey Megbevayà te amey ku he si Isaac, iyan ka kes Nengazen he migkaǥi kediey he med-ulì a ziyà te menge kezuzumahi ku, diyà te tanà he zutun a ianak, ne edtuvazan a kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ne siak is suluǥuen nu, kenà a zait te zekelà he ǥaǥew nu kediey he kenà egkaamin. Dengan hein midrapas a kayi te wahig he Jordan su edhendiyà a te ki Laban ne iyan dà naazen ku zutun is tuked ku. Ne ǥuntaan utew mezakel is menge azen ku su egkehimu he ebehinen te zezuwa he vahin. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ne tevangi a ǥuntaan kenikew su wey a kenà mekeizi te kakey ku he si Esau su utew ad egkahandek su kela ke edtebeken e zin, ne ebpesipelahan din is menge esawa ku wey menge anak ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Piru mibpesarig ka kedì he edtuvazan a kenikew ne edhimuwen nu is menge kevuwazan ku he iring kezakel te pantad diyà te veyvey te zaǥat su kenè en egkengevilang.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ne ziyà medhulavung ensi Jacob. Ne hein meselem, mibpilì si Jacob te menge uyaǥen he igasa zin ki Esau: ");
INSERT INTO mbbOT_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 he menge vehiyan he kambing wey 20 daan he menge meemahan he kambing, 200 he menge vehiyan he kerehidu wey 20 daan he menge meemahan he kerehidu, ");
INSERT INTO mbbOT_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 he menge vehiyan he kemilyu wey menge nati zan, 40 he vehiyan he vaka wey 10 he menge tudu he vaka, 20 he vehiyan he asnu wey 10 he menge meemahan he asnu. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Mibahin ni Jacob is menge uyaǥen din, ne kada grupu ne zuen dutun impevantey zin. Migkeǥiyan din dutun is menge suluǥuen din te, “Huna kew kedì, ne hipanew kew he kenà utew ebpesundulà is kada grupu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Migkeǥiyan din kes menge suluǥuen he edtundan duen te nehuna he grupu te, “Emun ebpeked-uma kew ki Esau ne ebpenginginsà sikandin ke hentei kew ki suluǥuen wey hendei kew ebpevayà, wey ke hentei ki uyaǥen heeyan is edtundanen niw, ");
INSERT INTO mbbOT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tevaka niw sikandin te kedì heini he menge uyaǥen ne igasa ku heini kandin. Keǥiyi niw zaan sikandin te keniyan en edtundug.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Iyan ded haazà migkaǥi zin dutun te ikezuwa, wey te iketelu wey te langun he menge suluǥuen he edtundan duen te menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ne mibpetizeenan din sikandan he kenè dan lipati he keǥiyi zan si Esau he edtundug en sikandin. Su neisip ni Jacob he, “Ebpeypeyuan ku si Esau kayi te menge igasa ku he ibpehuna ku. Su kela ke meked-ehè key ne ebpeseyluwen e zin ded.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Umbe impehuna zin haazà is menge igasa zin, piru sikandin mulà dutun dà mebpelintetaǥak te haazà he kezukilimi te mid-ubpaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ne hein mezukilem, mid-enew si Jacob ne miduma zin is dezuwa he esawa zin, is dezuwa he menge suluǥuen dan he vahi, wey is 11 he anak din he maama, ne imperapas din sikandan ipehuna te repasan te Jabok. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ne impenlayun daan ni Jacob is langun he menge azen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ne hein iyan dà si Jacob netaǥak dutun, duen nekeuma he sevaha he maama ne mibuteng din si Jacob. Mibuteng sikandan taman te egkepawà. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Hein neisip dutun te etew he kenè din egkezaag si Jacob, migewezan din is seǥang ni Jacob ne nekiluwan haazà is midsuuran te tulan kayi. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ne zutun migkaǥi haazà is etew te, “Lekai a kenikew su egkepawè en.” Ne midtavak si Jacob te, “Kenè ku sikew edlekaan emun kena a kenikew ebpenubtuvazan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ne mid-insaan sikandin dutun te etew te, “Hentei is ngazan nu?” Ne midtavak sikandin te, “Si Jacob.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ne migkaǥi haaza is etew te, “Puun guntaan kenè en maan Jacob is igngazan kenikew, kekenà, Israel en tenged te nekibuteng ka te Megbevayà wey te etew, ne nekezaag ka.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ne migkeǥiyan sikandin ni Jacob te, “Tezemi a kenikew ke hentei is ngazan nu?” Ne midtavak haazà is etew te, “Kenè nu en i-insai ke hentei is ngazan ku.” Ne zutun mibpenubtuvazan din si Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Migngezanan haazà ni Jacob he tanà te Peniel, he ke và dà egkeǥiya, “Neehè ku is dagwey te Megbevayà piru uuyag e zed.” ");
INSERT INTO mbbOT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ne hein midsilà is andew mid-awà si Jacob diyà te Peniel. Ebpiangpiang sikandin tenged te kegkekiluwi te midsuuran te tulan te seǥang din. ");
INSERT INTO mbbOT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Iyan heini hinungdan ke maan is taman guntaan he is menge Israilihanen ne kenà egkaan te uǥat he zutun te tulan he zapit te seǥang. Su keniyan dapit gewezi te Megbevayà si Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ne hein kebpantew ni Jacob, neehè din si Esau is ebpelingguma he edumahan te 400 he menge maama. Ne zutun, impedtetepizè din is menge anak din diyà te menge esawa zin he si Lea wey si Raquel, wey ziyà te menge suluǥuen dan he vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ne hein migenat sikandan, impehuna zin is dezuwa he menge suluǥuen din wey is menge anak dan, ne edtinundug si Lea wey is menge anak din, ne midtinundug si Raquel wey is anak din he si Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ne iyan sikandin midhuna te langun kandan ne kepipitu sikandin medlangkeb diyà te tanà dutun te ked-uvey zin diyà te kakey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ne si Esau mibpelelaǥuy is edsinuǥung ki Jacob ne migkepkepan din ne midhezekan din, ne nekesineǥew zan is dezuwa. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ne hein neehè din is menge vahi wey menge vatà, ne mid-insaan din si Jacob te, “Hentei heini is menge zuma nu?” Ne midtavak si Jacob te, “Iyan heini menge anak ku he imbeǥey kediey te Megbevayà su ingkehizu e zin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ne mid-uvey ziyà te ki Esau haazà is dezuwa he suluǥuen he vahi wey is menge anak dan, ne midluhud sikandan he iyan kedtahud dan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ne midsunud si Lea wey is menge anak din, ne midluhud daan sikandan. Ne iyan nehuziyan he mid-uvey he ed-luhud si Jose wey is iney zin he si Raquel. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ne mid-insaan ni Esau si Jacob te, “Hengkey is ibpesavut dutun te nesinuǥung ku he grupu te menge uyaǥen nu?” Midtavak si Jacob te, “Ibpayùpayù ku kenikew para mezawat a kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ne migkaǥi si Esau te, “Mezakel en is menge azen ku, geli, umbe kenikew zed haazà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Piru midteǥel ni Jacob, ke sikandin te, “Sigi en, dewata nud haazà. Su emun tutuu he igkeǥaǥew a kenikew dewata nu en is gasa ku kenikew. Su hein kedtengtengi ku te zagwey nu ne henduen be te zagwey te Megbevayà. Ne ǥuntaan te midawat a kenikew, ");
INSERT INTO mbbOT_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","dewata nu en is ibeǥey ku kenikew su nehizuwan a te Megbevayà ne wazà a mekurangi te menge penginehenglanen ku.” Midteǥel ni Jacob si Esau taman te nezawat en nasì ni Esau haazà is igasa zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ne migkaǥi si Esau te, “Kuwa kiw en su egenat kiw en. Ebpezumehè kiw en.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Piru midtavak si Jacob te, “Netuenan nu he utew key menaney he edhipanew su memenaney he edhipanew is menge vatà, ne egkesuatan ku zaan he egkepurungan egkeelimahi is menge uyaǥen he edsusuwan. Emun ebpeǥesen ta te kedhipanew is menge uyaǥen te tivuuk he andew ne kela ke mebpematey sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Deyzey ke edhuna ke en kenami. Ednaneynaney key en edsunud kenikew sumalà te kegaan kayi te menge vatà wey te menge uyaǥen he egketundug dey. Diyè kiw en ebpeked-uuma te Seir.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ne migkaǥi si Esau te, “Emun iyan heeyan, idtaǥak ku nasì is duma he menge sakup ku kenikew.” Midtavak si Jacob te, “Kenè en kinahanglan. Is impurtanti ne midawat a kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ne zutun he andew migenat si Esau is ed-ulì diyà te Seir. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Piru ziyà mebpevayà ensi Jacob te Sucot, he ke và dà egkeǥiya, “Helungà,” ne hein nekeuma zan diyà, midlelawig si Jacob te helungà te menge uyaǥen din. Umbe Sucot is inngazan dan dutun te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Hein neuǥet ne nekeuma sikandan diyà te Canaan puun te Padan Aram he wazà mezaat he neulaula kandan. Nekeuma zan diyà te inged he Shekem. Ne impehitindeg dan dutun is menge tulda zan diyà te uvey zutun te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ne haazà is tanà he mibpehitindeǥan dan te tulda ne mibpemasa ni Jacob diyà te menge anak ni Hamor te 100 he vuuk he pelata. Si Hamor ne iyan amey ni Shekem. ");
INSERT INTO mbbOT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ne zutun mibaal si Jacob te pemuhatà he migngezanan din te El Elohe Israel, he ke và dà egkaǥiya, “Utew mekeǥeǥehem is Megbevayà he ed-ezapen ni Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Si Dina, sikan is anak ni Jacob he raǥa he anak ni Lea, mibpenumbaley ziyà te menge vahi he menge meǥinged dutun te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Naahà sikandin ni Shekem he anak ni Hamor he Hivihanen, he pengulu zengan dutun he lugar. Mid-eǥen din si Dina ne midlayug din. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Utew zin nesuati si Dina, ne utew zin mibmahal ne midneyneyuan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ne migkeǥiyan din is amey zin he si Hamor te, “Ipeesawa nu kedì heeyan is bahi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Hein netuenan ni Jacob he midlayug ni Shekem si Dina, wazè din pa ul-ulaha is egkeisip din su wazè pa mekeulì is menge anak din he menge maama he ziyà te unayan su abantey te menge uyaǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Midhendiyà si Hamor wey is anak din he si Shekem te ki Jacob su ebpekidlalag kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ne hein netudtulan is menge anak ni Jacob he menge maama zutun te neulaula, segugunè dan mid-ulì. Utew mibmezaat is gehinawa zan ne utew zan egkepeuki si Shekem tenged te mid-ulaula zin he kenà meupiya he vaal, he nekeveǥey te keelezan te pemilya ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Piru migkeǥiyan sikandan ni Hamor te, “Utew nesuati te anak ku he si Shekem is raǥa niw, umbe edhangyù a he ipeesawa niw en sikandin ki Shekem. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Egkesuatan dey zaan he ebpengesawa kew kayi te kenami. Is menge anak niw he vahi, ne ipeesawa niw kenami ne ibpeesawa zey zaan is menge anak dey keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Egkehimu he ebpekeubpè kew kayi te kenami he tanà su kenè dey keniyu ibarew. Dini kew ubpà; dini kew petiǥayun minsan hendei ne ebpekaangken kew te tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Midhangyù daan si Shekem diyà te amey wey menge suled ni Dina te, “Emun egkehizuwan a keniyu ne ipeesawa niw en kedì si Dina, ne minsan hengkey he ebuyuen niw ibeǥey ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Minsan pira is ibpesunggud niw kediey wey is minsan hengkey he ebuyuen he igasa ku kandin ne ibeǥey ku asal ipeesawa niw kediey si Dina.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tenged te midèdeetan ni Shekem is dengeg ni Dina, mid-ekalan te menge anak ni Jacob si Shekem wey is amey zin he si Hamor. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ke sikandan te, “Kenà egkehimu he ibpeesawa zey is etevey zey te maama he wazà mesirkunsidar, su utew heeyan mekeeled-eled dini te kenami. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ebpemineg key he ibpeesawa kenikew is etevey zey ke ebpekeiring kew kenami. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Emun ebpesirkunsidar kew ne human egkehimu he ibpeesawa zey keniyu is menge anak dey he raǥa. Human egkehimu he zini key ed-ubpà te keniyu ne egkehimu kiw he sevaha zà he tribu. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Piru emun kenè kew ebpesirkunsidar, ne egkuwaan dey is etevey zey ne egenat key.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nesuat dutun si Hamor wey si Shekem. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Umbe tenged te utew nesuati ni Shekem si Dina, wazè en sikandin medlanganlangan ne midtuman din is migkaǥi kandin te menge anak ni Jacob. Si Shekem utew midtahud kandin is pemilya te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Umbe midhendiyè dan te amey zin te pultahan te inged su edlelaǥan dan is menge maama zutun te inged dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ke sikandan te, “Haazà is menge etew, ne ebpekid-emiǥu zan kenitew, umbe meupiya ke kayi tew en sikandan ibpeubpà te kenitew. Meluag daan heini is tanè tew. Ebpekepengesawa kiw te menge anak dan he raǥa ne ebpekepengesawa zan daan te kenitew he menge raǥa. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iyan, wey zan dà ebpekeuyun he zini zan ed-ubpà te kenitew ke ebpesirkunsidar kiw is langun he menge maama iring kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ne emun ebpekeubpè dan en kayi, egkehimu en he is langun he uyaǥen dan wey menge azen dan ne kenitew en daan. Umbe ebpemineg kiw en te egkesuatan dan su wey zan mekeubpà kayi zuma kenitew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ne mid-uyunan te langun he menge maama he meǥinged dutun haazà is sambag ni Hamor wey te anak din he si Shekem. Umbe mibpesirkunsidar is langun he menge maama zutun te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kedlevey zutun te tetelu he andew, zutun te kemulu pa egkesekiti is menge maama te kedsirkunsidara kandan, midseled dutun te inged kes dezuwa he menge anak ni Jacob, si Simeon wey si Levi, is menge kakey ni Dina. Wazà metueni te menge etew zutun he mezaat bes is tuyù dan. Mid-uwit dan te ispada ne mibpenhimetayan dan is langun he menge maama zutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Midhimetayan dan si Hamor wey is anak din he si Shekem, ne migkuwa zan dutun si Dina te valey ni Shekem ne migenat dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ne zutun, nekeuma zaan is duma pa he menge anak ni Jacob dutun te inged ne mibpenavan dan is menge azen dutun te inged. Mid-ulaula zan haazà tenged te midèdeetan is dengeg te etevey zan he si Dina. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Mibpenguwa zan is menge kerehidu, menge vaka, menge asnu, wey is minsan hengkey he menge azen diyà te inged wey minsan is diyà te menge unayan. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Mibpenguwa zan is langun he ketiǥeyunan dutun te inged, ragkes is menge azen he zutun te seled te menge valey. Ne mibpemihag dan is langun he menge vahi wey menge vatà. ");
INSERT INTO mbbOT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ne migkeǥiyan ni Jacob si Simeon wey si Levi te, “Mibeǥayan a keniyu te utew zekelà he samuk. Edumutan kiw en te menge Canaanhen wey menge Pirisihanen he menge meǥinged kayi te tanà. Mezakel zan, kenè kiw, ne emun ebpetebtevangè dan ne edsurungen kiw zan, egkaamin kiw zan te edhimatey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Piru midtavak haazà is dezuwa he anak din te, “Idtuǥut dey ve he ebpesipelahan is etevey zey su id-iring te vahi he ebelegyà te zengeg din?” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ne zutun migkaǥi is Megbevayà diyà te ki Jacob te, “Penines ka ne halin ka ziyà te Betel ne ziyè ka ubpà. Ne vaal ka ziyà te pemuhatà para kediey, kes Megbevayà he mibpaahà kenikew zengan dutun te timpu he ebpeleǥuyan nu is kakey nu he si Esau.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Umbe migkeǥiyan ni Jacob is tivuuk he pemilya zin wey is langun he menge sakup din te, “Ipenimbag niw is menge ed-ezapen niw. Mebpenlumpiyu kew te keugelingen niw ne ilisi niw is bisti niw. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ne edhendiyè kiw te Betel; ne ebaal a zutun te pemuhatà ne ed-ezapen ku is Megbevayà he midtavang kedì te menge kelised ku, wey miduma kedì minsan hendei a ebpevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ne haazà is menge ed-ezapen dan wey menge eritis, imbeǥey zan ki Jacob ne inleveng din diyà te sihung te kayu he ulayan diyà te uvey te Shekem. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ne hein migenat en dutun ensi Jacob, mibpengelinteuwan te Megbevayà he mahandek is menge meǥinged te menge siringan dan he inged, umbe wazè dan mezal-as ensi Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nekeuma ensi Jacob wey is menge zuma zin diyà te inged he Luz he egngezanan daan he Betel ziyà te tanà he Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ne mibeelan din dutun is pemuhatà. Iyan inngazan din dutun he lugar is El Betel, he ke và dà egkeǥiya, “Megbevayà te Betel,” su hein mibpeleǥuyan din is kakey zin he si Esau, dutun mebpaahà kandin is Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ne zutun, minatey si Debora he mid-uyamu zengan ki Rebeka. Ne ziyà ileveng sikandin te sihung te kayu he ulayan he ziyà te alug te Betel. Egngezanan haazà he kayu he Alon Bacut, he ke và egkeǥiya, “kayu he midsineǥawan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ne zutun te timpu he nekeulì ensi Jacob he ebpuun te Padan Aram, mid-uman en maan mebpaahà is Megbevayà diyà te kandin, ne mibpenubtuvazan din si Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Migkeǥiyan sikandin te Megbevayà te, “Jacob is ngazan nu, puun guntaan ne kenè en maan Jacob is igngazan kenikew, kekenà, Israel en.” Umbe Israel en is ngazan ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ne mid-uman megkaǥi is Megbevayà diyà kandin te, “Iyan a sikan is Mekeǥeǥehem he Megbevayà. Edhimuwen ku he mevuwad ka. Egkehimu ka he kepuun te sevaha he nasyun wey te mezakel he menge nasyun, ne egkehimu he hadì is duma he menge kevuwazan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Heini is tanà he imbeǥey ku ziyà te ki Abraham wey ziyà te ki Isaac, ibeǥey ku zaan kenikew wey ziyà te menge kevuwazan nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Ne mid-awà is Megbevayà dutun te tanà he zutun mebpekidlalag ki Jacob. Ne impelastar ni Jacob dutun is batu. Mid-itisan din te vinu wey lana su wey mehimu he segradu. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ne haazà is tanà, migngezanan ni Jacob te Betel, he ke và egkeǥiya, “baley te Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ne mid-awà ensi Jacob dutun te Betel duma is pemilya zin. Meǥaan dutun ed-anak si Raquel. Ne te wazè dan pa mekeuma ziyà te inged he Efrat ne ebeliliten en si Raquel su ed-anak. Ne utew sikandin midlised. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ne zutun te egkeseǥunsun en is belilit, migkaǥi is mengunguyamu te, “Kenè ka meseeng su maama en maan is id-anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ne hein edluwèluwe en te ǥehinawa si Raquel, migngezanan din is anak din ki Ben Oni. Piru migngezanan mulà ni Jacob haazà is batà ki Benjamin. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ne mibpatey zutun si Raquel ne ziyè dan ileveng te uvey te zalan pehendiyà te inged he Efrat. (Ne haazà is inged he Efrat ne iyan guntaan inged he Betlehem.) ");
INSERT INTO mbbOT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ne zuen batu he impelastar ni Jacob diyà te leveng ni Raquel, ne taman en guntaan kemulu pa egketuusi is leveng ni Raquel tenged dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ne midlaus pa medhipanew ensi Jacob ne ziyà dan med-ubpà te tanà he ziyà dapit te inged he Migdal Eder. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ne zutun te timpu he kemulu pa ed-ubpà ensi Jacob dutun, midhulizan ni Reuben is esawa te amey zin he si Bilha. Hein netuenan haazà ni Jacob, utew sikandin nepauk. Duen 12 he menge anak ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Is menge anak din diyà te ki Lea ne iyan si Reuben, is kakey, ne sunud si Simeon, si Levi, si Juda, si Isacar, wey si Zebulun. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Is menge anak din diyà te ki Raquel, ne iyan si Jose wey si Benjamin. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Is menge anak din diyà te ki Bilha, sikan is suluǥuen ni Raquel he vahi, ne iyan si Dan wey si Naftali. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Is menge anak din diyà te ki Zilpa, sikan is suluǥuen ni Lea he vahi, ne iyan si Gad wey si Asher. Iyan heini sikandan langun menge anak ni Jacob he maama he in-anak diyà te inged he Padan Aram. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Mid-ulì si Jacob diyà te amey zin he si Isaac he ziyà te Mamre he uvey te inged he Kiriat Arba (he iyan daan Hebron). Iyan haazà mid-ubpaan dengan ni Abraham wey ni Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Is keluǥayad te untung ni Isaac 180 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Meǥurang en utew sikandin te kebpatey zin, ne in-amur sikandin te menge kepuun din he nemematey en. Inleveng sikandin te menge anak din he si Esau wey si Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iyan heini guǥud mehitenged te pemilya ni Esau (he egngenazan daan te Edom). ");
INSERT INTO mbbOT_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nengesawa si Esau te menge vahi he tig-Canaan. Iyan sikandan si Ada he anak ni Elon te Hitihanen, si Oholibama he anak ni Ana wey apù ni Zibeon te Hivihanen, ");
INSERT INTO mbbOT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","wey si Basemat he suled ni Nebayot te anak ni Ishmael. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Is anak ni Esau ziyà te ki Ada ne iyan si Elifaz. Is anak din diyà te ki Basemat ne iyan si Reuel. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ne is menge anak din diyà te ki Oholibama ne iyan si Jeush, Jalam, wey Kora. Iyan sikandan menge anak ni Esau he neetew ziyà te Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Miduma ni Esau is menge esawa zin, menge anak din, wey is langun he sakup te pemilya zin, wey mid-uwit din is menge azen din wey menge uyaǥen din he nekuwa zin diyà te Canaan, ne midhalin sikandin te sevaha he lugar, he meziyù te mid-ubpaan te suled din he si Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Su kenà sikandan egkehimu he ebpeemurà diyà te sevaha zà he lugar su mahabet is menge azen dan; ne kenà ereg kandan haazà is lugar he mid-ubpaan dan tenged te kahabet te menge uyaǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Umbe, si Esau (he egngenazan daan ki Edom) diyà med-ubpà te menge vuvungan he Seir. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iyan heini guǥud mehitenged te pemilya ni Esau he iyan kepuun te menge Edomanhen he meǥinged diyà te menge vuvungan he Seir. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Is maama he anak ni Esau ziyà te ki Basemat ne iyan si Reuel, ne is anak din he maama ziyà te ki Ada ne iyan si Elifaz. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Is menge anak ni Elifaz he menge maama ne iyan ensi Teman, Omar, Zefo, Gatam, wey Kenaz. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ne zuen daan anak din diyà te esawa zin he si Timna he si Amalek. Iyan sikandan menge apù ni Esau ziyà te esawa zin he si Ada. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Is menge anak ni Reuel he menge maama ne iyan ensi Nahat, Zera, Shama, wey Miza. Iyan sikandan menge apù ni Esau ziyà te esawa zin he si Basemat. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Is maama he menge anak ni Esau ziyà te ki Oholibama ne iyan ensi Jeush, Jalam, wey si Kora (si Oholibama anak ni Ana wey apù ni Zibeon). ");
INSERT INTO mbbOT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iyan heini nehimu he menge pengulu te menge kevuwazan ni Esau: si Teman, si Omar, si Zefo, si Kenaz, ");
INSERT INTO mbbOT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","si Kora, si Gatam, wey si Amalek. Heini sikandan menge pengulu ziyà te lugar he Edom, menge anak sikandan ni Elifaz wey menge apù ni Ada. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nehimu zaan he menge pengulu te Edom is menge anak ni Reuel he iyan ensi Nahat, Zera, Shama, wey Miza. Menge apù sikandan ni Esau ziyà te esawa zin he si Basemat. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nehimu zaan he menge pengulu is menge anak ni Esau ziyà te ki Oholibama te anak ni Ana. Iyan sikandan si Jeush, si Jalam, wey si Kora. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Pudu sikandan menge kevuwazan ni Esau he menge pengulu ziyà te Edom. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Iyan heini menge maama he kevuwazan ni Seir he Hurhanen he meǥinged diyà te Edom: Si Lotan, Shobal, Zibeon, Ana, ");
INSERT INTO mbbOT_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, wey Dishan. Nehimu sikandan he menge pengulu te menge Hurhanen he meǥinged diyà te Edom. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Is menge anak ni Lotan iyan si Hori wey si Hemam. Telesuled si Lotan wey si Timna he sevaha zuen te menge asawa ni Elifaz. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Is menge anak ni Shobal iyan si Alvan, Manahat, Ebal, Shefo, wey si Onam. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Is menge anak ni Zibeon iyan si Aya wey si Ana. Iyan si Ana sikan is neketuredu te serebseb diyà te sibsivayan hein ebantey sikandin te menge asnu te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Is menge anak ni Ana iyan si Dishon wey si Oholibama. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Is menge anak ni Dishon he menge maama, iyan si Hemdan, Eshban, Itran, wey si Keran. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Is menge anak ni Ezer iyan si Bilhan, Zaavan, wey si Akan. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Is menge anak ni Dishan iyan si Uz wey si Aran. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Iyan heini sikandan menge pengulu te menge Hurhanen he midumala te menge lugar ziyà te Seir: Si Lotan, si Shobal, si Zibeon, si Ana, si Dishon, si Ezer, wey si Dishan. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Iyan heini sikandan menge hadì diyà te Edom dutun te timpu he wazè pa menge hadì te menge Israilihanen: ");
INSERT INTO mbbOT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela he tig-Dinhaba he anak ni Beor nehimu he hadì te Edom. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Hein minatey sikandin, iyan mid-ilis kandin si Jobab he anak ni Zera te tig-Bozra. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Hein minatey si Jobab, iyan mid-ilis kandin si Husham he tig-Teman. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ne hein minatey si Husham, iyan mid-ilis kandin si Hadad he tig-Avet he anak ni Bedad. Si Hadad iyan kes nekezaag te menge Midianhen diyà te Moab. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hein minatey si Hadad, iyan mid-ilis kandin si Samla he tig-Masreka. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Hein minatey si Samla, iyan mid-ilis kandin si Shaul he tig-Rehobot he uvey te Wahig he Eufrates. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Hein minatey si Shaul, iyan mid-ilis kandin si Baal Hanan he anak ni Acbor. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Hein minatey si Baal Hanan, iyan mid-ilis kandin si Hadar he tig-Pau. Iyan esawa zin si Mehetabel he anak ni Matred wey apù ni Mezahab. ");
INSERT INTO mbbOT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Si Esau (he migngezanan daan te Edom) iyan kepuun te menge Edomanhen. Ne iyan heini nehimu he menge pengulu te menge kevuwazan ni Esau he is menge tribu zan wey menge inged dan iyan inngazan kandan: Timna, Alva, Jetet, Oholibama, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel, wey Iram. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ne ziyà med-ubpà si Jacob te tanà he Canaan he iyan daan sikan is tanà he mid-ubpaan dengan te amey zin he si Abraham. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iyan heini guǥud mehitenged te pemilya ni Jacob: Hein 17 is penuiǥen ni Jose, mid-uǥup en sikandin te menge kakey zin te kebantey te menge uyaǥen. Haazà he menge kakey zin, ne menge anak ni Bilha wey ni Zilpa he menge esawa te amey zin. Ebpenudtulen ni Jose ziyà te amey zin mezaat he menge ulaula te menge kakey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ne si Jacob, edhuna is kebmahala zin ki Jose kenà haazà is duma he menge anak din, su ǥeina te meǥurang en sikandin te kegkeetew ni Jose. Umbe mibpetehìan din si Jose te meupiya he visti wey melayat. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ne hein nesavut te menge kakey ni Jose he mibmahal si Jose te amey zan, kenà sikandan, nepeukan dan si Jose ne layun en memesakit he lalag dan emun ebpekidlalag dan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sevaha he kezukileman neketeǥeinep si Jose. Hein midtudtul zin haazà is teǥeinep din diyà te menge kakey zin, ne mid-iseg is kegkepeuki zan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Su iyan heini midtudtul zin diyà te menge kakey zin, ke sikandin te, “Neteǥeinep ku ");
INSERT INTO mbbOT_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","he zutun te ziyè kiw te vevesukà is ebpemagkes te ǥinarab, ne netekewtekew kiw te zuen binagkes ku he mid-enew he midhitindeg he midlingutan duen te keniyu he menge vinagkes su edtahud dan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Migkaǥi haazà is menge suled din te, “Hengkey? Egkehimu ka edhadì wey ebayàbayà kenami?” Umbe mid-iseg pa is kegkepeuki zan ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ne nekeuman si Jose meketeǥeinep ne midtudtul zin en maan diyà te menge kakey zin. Ke sikandin te, “Nekeuman a meketeǥeinep, neehè ku is andew, vulan, wey 11 he menge vituen he edtahud kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Midtudtul zaan ni Jose haazà is teǥeinep din diyà te amey zin piru midsawey sikandin te amey zin. Migkaǥi is amey zin te, “Hengkey, mama, is ibpesavut nu? Egkehimu ve he siak wey is iney nu wey is menge suled nu ne ebpekepevayàbayè key kenikew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ne utew neepesi si Jose te menge suled din, piru si Jacob mulà mid-isip-isip din heini he menge hitavù. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sevaha zutun he andew, midhendiyà is menge kakey ni Jose te Shekem su ebpemepenabtab te menge uyaǥen te amey zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ne zutun, migkeǥiyan ni Jacob si Jose te, “Is menge kakey nu ne ziyà te Shekem su ebpemepenabtab dan te menge uyaǥen tew. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Hendiyè ka wey nu melauy ke meupiya ve is egkeulaula te menge kakey nu wey te menge uyaǥen, ne meǥaan ke zà likù kayi wey a metudtuli kenikew.” Midtavak si Jose te, “Uya, amà.” Umbe, puun dutun te Hebron, midhendiyà si Jose te Shekem. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ne hein diyè en sikandin is edriǥuriǥu ziyà te unayan, duen etew he nenginginsà kandin ke hentei is ebpen-ahaan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Midtavak si Jose te, “Ebpen-ahaan ku is menge kakey ku. Netuenan ve ke hendei zan ebpemepenabtab?” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Migkaǥi haazà is etew te, “Mid-awè dan en kayi. Nezineg ku he ebpehendiyè kun sikandan te Dotan.” Ne midtelukun si Jose ziyà, ne neturedu zin sikandan diyà te Dotan. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Hein malù pa meziyù si Jose is ebpelingguma, ne naahà sikandin te menge suled din, ne mibpelenuwan dan en sikandin te edhimatey. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ke sikandan te, “Heeyan en kes meneneǥeinep is ebpelingguma. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kuwa kew en su edhimetayan tew sikandin, ne id-ulug tew sikandin kayi te vudsi he punduwà te wahig. Egkeǥiyen tew zà he midhimetayan sikandin te dumezaas he langgam. Ed-ahaan te kun be ke metuman is menge teǥeinep din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ne hein nezineg heini ni Reuben is pelanu, egkesuatan din he edluwasen din si Jose. Ke sikandin te, “Kenè tew edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Iulug niw zà sikandin te vudsi kayi te sibsivayan, kenè niw sikandin himetayi.” Umbe migkaǥi heini ni Reuben su wey zin melibri si Jose wey zin ikeulì diyà te amey zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ne hein nekeuma si Jose ziyà te kandan, migewezan dan ne midluwas dan sikan is bisti ni Jose he nepurung mezeyzeyani ");
INSERT INTO mbbOT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ne intimbag dan sikandin diyà te vudsi he punduwà te wahig. Ne haazà is budsi ne wazè din taǥù he wahig. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ne te egkaan sikandan, ne zuen dan nepantew he ebpemelingguma he nigusyanti he menge Ismailihanen he ebpuun diyà te Gilead. Duen menge kemilyu zan he migkergahan dan te menge penaket, bawì, wey menge perehemut he ed-uwiten dan diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Migkeǥiyan ni Juda haazà is menge suled din te, “Hengkey is egkepupulus tew ke edhimetayan tew is hazi tew he id-eles tew is kedhimetayi tew kandin? ");
INSERT INTO mbbOT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Deyzey pa vuwa ke ibelegyè tew sikandin keniyan te menge Ismailihanen. Kenè tew edhimetayan su hazi tew man sikandin.” Ne mid-uyunan haazà te menge suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hein midsaǥad haazà is menge nigusyanti he tig-Midian, mibatun dan si Jose puun dutun te vudsi, ne imbelegyè dan sikandin te 20 he vuuk he pelata. Ne mid-uwit dan si Jose ziyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ne hein midlikuan ni Reuben haazà is budsi ne wazè en dutun si Jose, ne mibindas din is bisti zin su utew neseeng. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ne zutun, midlikù sikandin diyà te menge suled din he egkaǥi te, “Wazè en dutun kes hazi tew. Ebmenmenu ad be te ked-ulì ku ziyà te ki amà?” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Midhimatey sikandan te kambing ne midlupit dan te lengesa is bisti ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ne mid-uwit dan is bisti ni Jose ziyà te amey zan, migkaǥi sikandan te, “Neehè dey heini. Ahaa kun heini, ki Jose ve heini etawa kenà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nekilala ni Jacob haazà is bisti. Ke sikandin te, “Kumbalà heeyan ni Jose. Midhimetayan sikandin te kumekaid he langgam! Siguradu he mibpurungan sikandin deesi te langgam.” ");
INSERT INTO mbbOT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ne mibindas ni Jacob is bisti zin ne mibivisti te saku he tuus te kegkeseeng din. Neuǥet is kedlalew zin te anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Midhendutun te kandin is langun he menge anak din su edlenganen dan, piru wazà maawà is kegkeseeng din. Ke sikandin te, “Beleǥaza ad keniyu! Iyan ibpatey ku is kegkeseeng ku tenged te kebpatedany te anak ku.” Ne midsigudu en sikandin medsineǥew tenged ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ne mid-uwit si Jose te menge Midianhen diyà te Ehipto ne imbelegyè dan sikandin diyà te ki Potifar he sevaha he upisyal te hadì te Ehipto, he kepitan te menge vantey te turuǥan. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Dutun he timpu, midsuwey si Juda te menge suled din ne ziyà sikandin med-ubpà te ed-ubpaan ni Hira he tig-Adulam. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ne zutun nekilala ni Juda is anak ni Shua he tig-Canaan ne mid-esawa zin haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ne mibmeǥingey haazà ne mid-anak te maama ne migngezanan haazà ni Juda te Er. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mid-uman sikandin mebmeǥingey ne mid-anak en maan te maama ne migngezanan din te Onan. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ne mid-uman en maan sikandin mebmeǥingey ne mid-anak en maan te maama ne migngezanan din haazà te Shela. In-anak si Shela ziyà te Kezib. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Impeesawa ni Juda is kinekekayan he anak din he si Er te vahi he iyan ngazan din si Tamar. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Piru mezaat is ulaula ni Er ziyà te etuvangan te Nengazen, umbe midhimetayan sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Umbe, migkeǥiyan ni Juda si Onan te, “Esawaa nu is ipag nu su veveluwan nu sikandin su suled nu is minatey he esawa zin, su wey pinaaǥi kenikew egkevuwad is minatey he suled nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Netuenan ni Onan he is egkehimu he anak dan ki Tamar ne kenà heini ed-isipen he keugelingen din he kevuwazan. Umbe kada zin edhileveti si Tamar ne kenè din ibpeseled is similya zin su para kenà sikandin mekaanak para zuen te minatey he suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ne mezaat diyà te etuvangan te Nengazen haazà is mibeelan ni Onan, umbe midhimetayan din si Onan. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ne migkeǥiyan ni Juda haazà is ambey zin he si Tamar te, “Ulì ka zèpa ziyà te amey nu, ne kenè ka mebpeesawa taman te egkenakan en si Shela.” Migkaǥi haazà ni Juda su nahandek sikandin he kela ke mebpatey zaan si Shela iring duen te menge suled din. Umbe mid-ulì dèpa si Tamar ziyà te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ne hein neuǥet en minatey is esawa ni Juda. Ne hein netapus is timpu te kedlalew zin, ne midhendiyà sikandin te menge peraalut te menge kerehidu zin diyà te Timnah. Duma zin te midhendutun is emiǥu zin he si Hira he tig-Adulam. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ne netudtulan si Tamar he edhendiyà is enuǥang din te Timnah su ed-elutan din is menge kerehidu zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kegkezineǥa zutun ni Tamar, mid-ilisan din is bisti zin he visti te valu, ne midtembunan din te lembung is buked din. Ne mibpimpinuu sikandin diyà te pultahan te inged he Enaim, he ziyà te kilid te zalan he ibpehendiyà te Timnah. Iyan diyà te isip din he edlimbungan din si Juda su neseǥipè din he wazà gihapun sikandin ipeesawa ki Shela minsan pa te kenakan en heini. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Ne hein naahà ni Juda si Tamar, wazè din mekilala he iyan kes ambey zin su netembunan man is buked din. Kunaan din ke vahi haazà he ebelegyà te zengeg din. Umbe mid-uvayan din haazà dutun te kilid te zalan he ke sikandin te, “Hendini ka su ebpehilevetè ki.” Ne midtavak si Tamar te, “Hengkey is ibayad nu kedì ke ebpehilavet a kenikew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Migkaǥi si Juda te, “Ebeǥayan ku sikew te kambing he ebpuun diyà te menge uyaǥen ku.” Midtavak si Tamar te, “Edsukul a emun duen idsandè nu he wey nu en egkahawì emun igkepeuwit nu en sikan is kambing.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Mid-insà si Juda te, “Hengkey is ibpesandè nu kedì?” Midtavak si Tamar te, “Iveǥey nu kediey is penmarka nu wey is hiket din he imbevelieg nu, ragkes en is tuked nu.” Umbe imbeǥey haazà ni Juda ne mibpekidhilavet sikandin ki Tamar. Ne hein nepasad haazà mid-ulì si Tamar, ne in-awè din is tambun te vuked din ne mid-uman mebivisti te visti he para te valu. Ne hein malù en neuǥet mibmeǥingey sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Wazè en meuǥet ne impahated en ni Juda zuen te emiǥu zin he si Hira he tig-Adulam sikan is kambing he idlekat duen te menge azen he insandè din diyà te vahi, piru wazè din meturedu haazà is bahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nenginginsà si Hira te menge tig-Enaim ke hendei en sikan is bahi he ebelegyà te zengeg din, he ebpimpinuu ziyà te kilid te zalan. Piru midtavak is menge etew te, “Wazè man bahi kayi he ebelegyà te zengeg din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Umbe, midlikù si Hira ziyà te ki Juda he ke sikandin te, “Wazè ku sikandin meturedu. Ne iyan lalag te menge etew zutun he wazà bahi zutun he ebelegyà te zengeg din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Migkaǥi si Juda te, “Ebey-anan en sikan is menge azen ku he ziyà te kandin, su kela ke và ki zà eengiti te menge etew is edtulung ebpen-ahà te wazà duen. Mibpeuwitan ku en man pezem sikandin te kambing piru wazè nu sikandin meturedu ziyà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Hein midlavey en is tetelu he vulan, netudtulan si Juda he is ambey zin he si Tamar ebpemelegyà te zengeg din ne mibmeǥingey en. Umbe migkaǥi si Juda te, “Uwita niw sikandin diyà te ǥawas te inged ne binsuli niw.” ");
INSERT INTO mbbOT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Piru hein ed-uwiten dan en si Tamar, duen impekaǥi zin diyà te ki Juda he ziyà te kandin is penmarka wey is hiket kayi, ragkes en is tuked. Ne is teǥiǥaked dutun iyan nekeǥingey kandin. Ne kinahanglan he egkilelaan ke hentei is teǥiǥaked dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nekilala ni Juda he kandin haazà he menge azen, umbe migkaǥi sikandin te, “Wazà mekesalà si Tamar. Iyan a nekesalà su wazè ku sikandin ipeesawa te anak ku he si Shela.” Ne wazè en si Juda med-uman medhilavet ki Tamar. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hein hapit en ed-anak si Tamar, netuenan he sereping is keǥingayan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Hein ebeliliten en sikandin, migawas is belad te sevaha he vatà. Ne is mengunguyamu midhiketan din heini te meriǥà he hiket su wey metuusi he iyan kakey. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Piru inseled dutun te vatà is belad din ne iyan midhuna megawas sikan is sereping din. Ne migkaǥi is mengunguyamu te, “Mibpekid-aǥew ka te kegawas.” Umbe migngezanan haazà is batà te Perez. ");
INSERT INTO mbbOT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ne migawas daan sikan is sereping din he midhiketan te meriǥà he hiket is belad din. Ne migngezanan sikandin te Zera. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Hein mid-uwit en duen te menge Ismailihanen si Jose ziyà te Ehipto, imbelegyà sikandin diyà te ki Potifar he sevaha te menge upisyal te hadì te Ehipto he kepitan te menge vantey te turuǥan. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Midumahan te Nengazen si Jose umbe mid-iseg mebmeupiya is kebpekesavuk din. Diyà sikandin med-ubpà te valey te egalen din he tig-Ehipto he si Potifar. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Naahà te egalen din he midumahan si Jose te Nengazen wey midtuvazan is langun he menge vaal zin, ");
INSERT INTO mbbOT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","umbe utew zin ingkeǥaǥew si Jose. Midhimu zin si Jose he sineriǥan din te kedumalaha te langun he menge suluǥuen din diyà te valey zin wey is kebayàbayà te langun he menge azen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ne puun dutun te kedseriǥi ki Jose, midtuvazan te Nengazen is pemilya ni Potifar he Ehiptohanen wey is langun he menge azen din diyà te baley zin wey ziyà te vevesukè din. Midhimu heini te Nengazen tenged ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ne tenged dutun, insarig ni Potifar ki Jose is langun he azen din su emun iyan si Jose edumala ne kenè en sikandin egkesamuk gawas te kegkaan. Metaid si Jose wey meupiya is kedlelawa zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ne wazà meuǥet, neimahan sikandin te esawa te egalen din. Ne midhinggat din si Jose he ebpehulizè dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ne si Jose, wazè din pemineǥa, kekenà, migkeǥiyan din te, “Sikan is egalen ku, wazà igkesamuk din he minsan hengkey tenged te insarig din kediey is langun he menge azen din. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Henduen be te nekedrepeng key kayi te valey, su insarig din is langun kediey kayi ǥawas kenikew su esawa ke zin man. Kenà egkehimu he edlimbungan ku is egalen ku wey ebaal a te salà diyà te Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ne minsan pa te andew-andew is kedhinggata zuen te vahi ki Jose he ebpehulid, wazà si Jose mebpemineg. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Sevaha zutun he andew, midseled si Jose ziyà te valey su zuen din ebeelan, ne wazà dutun is menge zuma zin he menge suluǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Migewezan duen te esawa zuen te egalen ni Jose bisti zin ne migkeǥiyan din te, “Hulid ka kedì.” Piru mibpelaǥuy si Jose pehendiyà te ǥawas, piru netaǥak din is samput din dutun te vahi. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Hein naahà duen te vahi he migawas si Jose ne neǥewezan din is bisti ni Jose, ");
INSERT INTO mbbOT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ne mid-umew zin is menge suluǥuen din, he egkaǥi te, “Ahaa niw man heini! Mid-uwitan kiw kayi te esawa ku te Hebriyuhanen para mepeel-elezi kiw. Kunaan niw vuwa, midseled sikandin kayi te ruǥu ku su edleyuǥen e zin, piru nengulahì a. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ne tenged dutun, mibpelaǥuy sikandin diyà te gawas, piru netaǥak din is samput din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ne intaǥù dutun te vahi haazà is samput ni Jose taman te nekeulì is esawa zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ne midtudtul zin haazà diyà te esawa zin. Ke sikandin te, “Kes Hebriyuhanen he uripen nu he mid-uwit nu zini, egkesuatan din he mepeel-elezi a su midseled geina kayi te ruǥu ku su edleyuǥen e zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Piru hein migkulahì a ne mibpelaǥuy sikandin pehendiyà te gawas, ne netaǥak ganì is samput din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Hein nezineg ni Potifar haazà is tudtul te esawa zin mehitenged ki Jose, utew sikandin nepauk. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ne tenged dutun, impezakep din si Jose ne inseled duen te pirisuan te menge pirisu te hadì. Piru minsan pa te ziyà si Jose te pirisuwan, ");
INSERT INTO mbbOT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","midumahan ded si Jose te Nengazen. Tenged te tuvad te Nengazen, nehizuwan duen te ebantey zuen te pirisuwan si Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ne tenged dutun, insarig duen te ebantey te pinirisu ki Jose is kebayàbayà te langun he menge pirisu ziyà te pirisuwan ne iyan impezumala sikandin te langun he menge vaal zutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Haazà is egalen te pirisuwan, wazè en igkesemuki zin duen te langun he insarig din ki Jose su midtuvazan man si Jose te Nengazen ne mibpengelinteuwan din he layun meupiya is minsan hengkey he ebeelan ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Mibpenlavey is timpu, is pengulu te pereuwit te vinu te hadì wey kes pengulu te mememaal te supas ne nekesalà diyà te kandin. Utew nepeuki te hadì haazà is dezuwa he menge upisyal zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Umbe, impepirisu sikandan diyà te valey te kepitan te menge vantey ziyà te pirisuwan he iyan ded sikan is mibpirisuan daan ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Si Jose is midseriǥan te kepitan te menge vantey he iyan ebeǥey kandan te egkinehenglanen dan. Neuǥet is kegkepirisuwa kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Sevaha zutun he mezukilem, neketeǥeinep kes pereuwit te inumen wey mememaal te supas dutun te kemulu pa sikandan nepirisu. Uman sevaha kandan ne selakew is teǥeinep din wey selakew is kehuluǥan te teǥeinep din. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ne hein nepawà te kedleuya kandan ni Jose, neehè din he utew zan neseeng. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mid-insaan din haazà is dezuwa he upisyal te hadì te Ehipto ke maan is utew zan neseeng. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ne midtavak dan te, “Geina te neketeǥeinep key, iyan, wazà ebpekeseysey ke hengkey is kehuluǥan duen te teǥeinep dey.” Ne migkaǥi zutun si Jose te, “Megbevayè dà is ebpekepezayag kenitew te kehuluǥan te menge teǥeinep. Keǥiya niw kun kediey is teǥeinep niw.” ");
INSERT INTO mbbOT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ne zutun impenudtul ki Jose te egalen te menge pereuwit te inumen is teǥeinep din. Ke sikandin te, “Neteǥeinep ku he zuen gawed diyà te egkesineruan ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ne tetelu is subpang duen te ǥawed. Ne mibpeneringsing ne mibpengevukad ne mibpemeǥas ne nengelutuan is beǥas din. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Migewezan ku kun is tasa te hadì te Ehipto ne midrupù ku haazà is menge paras ne migkeres ku ne midtiǥis is wahig din diyà te tasa. Ne nepasad ne imbeǥey ku haazà is tasa ziyà te hadì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ne migkaǥi si Jose te, “Iyan heini kehuluǥan te teǥeinep nu: Sikan is tetelu he subpang ne iyan kehuluǥan din is tetelu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dutun te kenè pa egkeuma is tetelu he andew, ne ibpeǥawas ke en te hadì kayi te pirisuwan, ne ibpelikù ke zin diyà te zaan he terebahu nu he iyan is ked-uwiti nu kandin te vinu. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Berakat he kenà a kenikew lipati emun meupiya en is kebpekesavuk nu, he iyan kebpaahà a nu te keupiya nu kedì, keǥiya nu ziyà te hadì is ngazan ku su wey a kenikew metevangi wey a mekeǥawas kayi te pirisuwan. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Migebpaan a puun te inged dey te menge Hebriyuhanen, ne wazà salè ku he zait he igkepirisuwa kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Hein nezineg duen te egalen te mememaal te supas he meupiya is kehuluǥan duen te teǥeinep, midtudtul zin daan is teǥeinep din diyà te ki Jose. Ke sikandin te, “Neketeǥeinep a zaan he zuen ku ed-utuken he tetelu he revan he nepenù te supas. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ne is kinezivevawan en utew zutun te revan, ne zuen taǥù he nekedseselekawà he kelasi he supas he para te hadì, piru mibpengaan heini te menge tagbis.” ");
INSERT INTO mbbOT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ne midtavak si Jose te, “Iyan heini kehuluǥan te teǥeinep nu: Sikan is tetelu he revan, ne tetelu zaan he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Seled te tetelu he andew ebpepungelan ka te hadì te ulu ne ibitey ka ziyà te kayu ne ebpengeenen te menge tagbis is sapù nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ne netuman iyan haazà su neketelu pa zutun iyan kedsilibra te ked-enaka te hadì te Ehipto ne midtukud sikandin te keemuran ne impetampu zin is langun he menge upisyal zin. Mid-umew zin is egalen te menge pereuwit te inumen wey is egalen te menge mememaal te supas ne impeetuvang sikandan te menge zuma zan he upisyal. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ne sikan is egalen te menge pereuwit te inumen, impelikù din te zaan he vaal zin ne iyan en maan sikandin eduwal te inumen diyà te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ne sikan is egalen te menge mememaal te supas, impevitey te hadì sumalà is kehuluǥan he midseysey ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Piru sikan is pereuwit te inumen, wazè din tevangi si Jose su nelipatan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ne hein midlavey en is dezuwa he tuig ne neketeǥeinep is hadì te Ehipto he edhithitindeg sikandin diyà te veyvey te Wahig he Nilo. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ne neehè din he zuen egaun diyà te wahig he pitu he vaka he utew memeupiya wey memelambù he mibpemenabtab dan te menge sagbet diyà te veyvey. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ne zuen daan neehè din he pitu he vaka he nekesunud he migaun, he memeǥasà wey memezaat. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ne heini is nengehuziyan he vaka he memeǥasà wey memezaat, migkaan dan haazà is nengehuna he utew memelambù wey memeupiya. Ne zutun nepukew haazà is hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ne midlipezeng en maan sikan is hadì ne nekeuman meketeǥeinep. Ne zutun te teǥeinep din duen neehè din he menge pungu he utew memeupiya wey memetiugkey. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ne huziyan dutun duen mibpenuvù he pitu zaan he pungu he mid-ukap dà he nezeetan te keramag he ziyà ebpuun te edsilaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ne mibpengeveleng duen te nengepis haazà is pitu he utew memerimiǥas. Ne zutun nepukew haazà is hadì ne teǥeinep dè bes. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ne hein nepawà, utew neliveg haazà is hadì tenged dutun te menge teǥeinep din, ne impetawag din is langun he menge selemengkiru wey uluwanen he menge etew ziyà te ǥinhedian din he Ehipto. Ne midtudtulan din sikandan te menge teǥeinep din, piru wazà minsan hentei kandan he ebpekeseysey zutun te hadì ke hengkey is kehuluǥan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ne zutun mid-uvayan duen te egalen te pereuwit te vinu sikan is hadì te Ehipto he egkaǥi te, “Netenuzan ku ǥuntaan is menge salè ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Netenuzan ku is kegkepeuki nu zengan kedì wey zuen te egalen te mememaal te supas, ne impepirisu key kenikew ziyà te valey te kepitan te menge vantey te turuǥan? ");
INSERT INTO mbbOT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Sevaha zutun he kezukileman, neketeǥeinep key is dezuwa, ne nekedselekawà is kehuluǥan te teǥeinep dey. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Duen duma zey ziyà he kenakan he Hebriyuhanen, he suluǥuen te kepitan te menge vantey te turuǥan. Midtudtul zey kandin is menge teǥeinep dey ne midseysey zin kenami is kehuluǥan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ne sumalà is kehuluǥan te kada sevaha ne iyan daan neulaula kenami, su siak, impelikù a kenikew kayi te zaan he terebahu ku ne sikan is sevaha, ne impevitey nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ne zutun mibpeveyaan te hadì si Jose, ne segugunà impeǥawas sikandin duen te pirisuwan. Hein nepesazan sikandin te ed-alut wey ebpemarbas, ne mid-ilis sikandin ne mid-etuvang diyà te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ne migkaǥi is hadì diyà te ki Jose te, “Neketeǥeinep a piru wazà minsan hentei he ebpekeseysey te kehuluǥan din. Duen mibpenudtul kedì he metau ka he edseysey te kehuluǥan te menge teǥeinep.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ne midtavak si Jose te, “Kenà a iyan, Mahal he Hadì, kekenà, iyan dà is Megbevayà ebpekeveǥey te kehuluǥan te menge teǥeinep he meupiya para kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ne migkaǥi zutun te hadì is menge teǥeinep din diyà te ki Jose. Ke sikandin te, “Neteǥeinep ku he ziyà a edhithitindeg te veyvey te Wahig he Nilo. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ne zuen neehè ku he pitu he menge vaka he memeupiya wey memelambù he migaun, ne mibpemenabtab te menge sagbet. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ne netegteǥaad duen migaun daan he pitu he vaka he memezaat wey memeǥasà. Wazà a mekaahà te vaka kayi te tivuuk he ǥinhedian ku he Ehipto te iring dutun te utew mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ne migkaan dutun te memezaat wey memeǥasà haazà is pitu he memelambù he nengehuna he migaun. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Piru hein nekaan dan en, kenà egketuusan he nekaan dan su memeǥasè ded gihapun sikandan. Ne zutun nepukew a. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ne nekeuman a mekelipezeng ne neketeǥeinep ad maan he zutun duen neehè ku he senge puun te parey he trigu he pitu is pungu zin he utew memeupiya wey memetiugkey. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ne zutun midlepew zaan is pitu he pungu he mid-ukap dà he nezeetan te keramag he ziyà ebpuun te edsilaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ne haazà is menge pungu he mid-ukap, ne mid-eveleng dan is pitu he pungu he memeupiya. Ne impenudtul ku heini ziyà te menge selemengkiru, iyan, wazà minsan hentei kandan he nekeseysey kediey te kehuluǥan din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ne migkaǥi zutun si Jose ziyà te hadì te, “Mahal he Hadì, sebsevaha zà is kehuluǥan duen te zezuwa he teǥeinep nu. Impezayag en kenikew te Megbevayà ke hengkey is ed-ul-ulahan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Su haazà is pitu he vaka he memelambù wey kes pitu he memetiugkey he menge parey ne sevaha zà is kehuluǥan din he iyan is pitu he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ne haazà is pitu he vaka he memeǥasà wey memezaat wey haazà is pitu he pungu te parey he mid-ukap ne iyan ibpaalung dutun is pitu he tuig he vitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ne haazà he egkehitavù ne iyan en kes migkaǥi ku kenikew, Mahal he Hadì, he impezayag en kenikew te Megbevayà ke hengkey is ed-ul-ulahan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Puun guntaan ebpekesunud is pitu he tuig he utew zekelà is uzar he parey zini te tivuuk he ǥinhedian te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Piru zuen daan pitu he tuig he vitil he ebpekesunud dutun te egkehuna he pitu he tuig ne tenged dutun egkelipatan en haazà is nehuna he menge tuig he zekelà is egkeenen su haazà is bitil ebpekezezaat kayi te tanà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ne tenged dutun te utew mepait he vitil, ne henduen be te wazà mekesaǥad is tig-Ehipto te zekelà he uzar. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kezezuwa ipeteǥeinep te Megbevayà kenikew, Mahal he Hadì, su ibpesavut din he siguradu he ed-ul-ulahan din haazà wey meǥaan en utew is kegkeul-ulaha zuen. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Umbe, Mahal he Hadì, kinahanglan he ebpen-ahaan nu is sevaha he etew he uluwanen para egkehimu he iyan edumala te tanà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ne kinahanglan daan he zuen ebpilien nu he menge egalen dini te tivuuk he Ehipto para ibpepenukut te ikelima he vahin te langun he egkeraǥun seled te pitu he tuig he zekelà is uzar. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kinahanglan he ibeǥey nu kandan is keǥehem wey zan mekepenguwa te egkeenen dutun te menge tuig he meupiya is menge abut su wey zan ikepezerengdeng wey ikepeventayi kandan seled te menge inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ne haazà is iderengdeng, ne egkehimu he iyan egkeenen te menge meǥinged dini te Ehipto emun ed-aǥi en is pitu he tuig he vitil, su wey kenà sikandan mengevitil.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ne haazà is hadì wey is menge upisyal zin, ingkesuat dan utew heini is sambag ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ne migkaǥi haazà is hadì diyà te menge upisyal zin te, “Wazè en duma pa he egkeehè tew he iring ki Jose su mid-ulinan iyan sikandin te Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ne migkeǥiyan din si Jose te, “Geina te iyan ka kes mibpezayaǥan te Megbevayà te langun kayi, nesavut dey he wazà duma pa he etew he metau wey zuen din kedsavut he iring kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Edhimuwen ku sikew he iyan ebayàbayà te turuǥan ku ne kinahanglan he ebpevayàbayà kenikew is minsan hentei he sakup ku. Iyan e zà lavew kenikew su iyan a hadì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ne mid-uman megkaǥi is hadì diyà te ki Jose te, “Idsarig ku en kenikew ǥuntaan is kebayàbayà te tivuuk he ǥinhedian ku he Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ne mibpul-ut dutun te hadì is sising din he iyan tuus te keǥehem din he insarig din ki Jose. Mibpesun-uzan din si Jose te utew mahal he manggad he meputì ne mibpevelieǥan din sikandin te rantey he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ne insuǥù din he ibpeuntud si Jose te ikezuwa he lavew he kerwahi zin, ne insuǥù din daan he zuen menge etew he edhuna ki Jose wey zan mekevensag te, “Luhud kew!” Ne iyan haazà neulaula hein insarig duen te hadì te Ehipto ki Jose is kebayàbayà te tivuuk he ǥinhedian din he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ne migkeǥiyan te hadì si Jose te, “Minsan pa te iyan a sikan is hadì, wazà minsan hentei he menge sakup ku kayi te tivuuk he ǥinhedian ku he Ehipto he ebpekeulaula te minsan hengkey emun kenè nu idtuǥut.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ne migngezanan dutun te hadì si Jose te si Zafenat Panea, ne impepengesawa zin ki Asenat he anak ni Potifera he iyan lavew he memumuhat diyà te inged he On. Ne nehimu si Jose he gubirnedur te tivuuk he ǥinhedian te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Mibpenuiǥen dutun si Jose te 30 zutun te timpu te kedhimuwa kandin he lavew he upisyal te hadì. Ne mid-awà sikandin dutun te etuvangan te hadì ne midhipanew he midtukid din susiya is langun he menge inged diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ne zutun te netagnà he pitu he tuig he zekelà is uzar, dekelà iyan is menge abut dan diyà te menge tanè dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ne heini he menge tuig, impetiǥum ni Jose is langun he nekulikta he ebpuun te menge neraǥun. Ne impezerengdeng din diyà te kada inged is menge neraǥun he ebpuun te menge vevesukà diyà te pelingut kayi. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Utew zekelà he parey he trigu is impezerengdeng ni Jose; iring kezekelà haazà is parey te pantad diyà te veyvey te zaǥat. Ne ǥeina te utew haazà dekelà mid-engkezan en ni Jose is kedtimbanga wey kebilanga zuen su kenè en egkengevilang. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ne te wazè pa meuma sikan is pitu he tuig he vitil duen dezuwa he anak he maama ni Jose he in-anak te esawa zin he si Asenat, sikan is anak ni Potifera he memumuhat diyà te On. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Is kakey he anak ni Jose, ne migngezanan din ki Manase su ke sikandin te, “Geina te midhimu te Megbevayà he melipati ku is langun he menge keseengan ku wey is kebulunga ku te amey ku wey menge kezuzumahi ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ne haazà is hazi he anak din, migngezanan din ki Efraim su ke sikandin te, “Midhimu te Megbevayà he mebmeuswaǥen a zini te tanà he mezakel is menge kemereǥenan ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ne nepangkus haazà is pitu he tuig he utew zekelà is neraǥun diyà te Ehipto, ");
INSERT INTO mbbOT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ne neume en haazà is pitu he tuig he vitil sumalà is netagnà ni Jose. Mibitil is menge meǥinged te minsan hendei he ǥinhedian, iyan, duen mulà egkeenen diyà te ǥinhedian he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ne hein neǥezam en te langun he menge tig-Ehipto is bitil midhengyuan dan is hadì dan he veǥayi sikandan te egkeenen. Ne migkeǥiyan din sikandan te, “Hendiyè kew te ki Jose ne veeli niw is egkeǥiyen din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ne hein nekeeneb en is bitil ziyà te tivuuk he ǥinhedian, mibpepuwasan ni Jose is menge budiga ne mibelegyà te egkeenen diyà te menge tig-Ehipto su utew en mepait is bitil ziyà te tivuuk he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ne zuen menge etew he ebpuun te langun he menge zuma he ǥinhedian ne midhendiyè dan te Ehipto, su ebpemasa zan te egkeenen diyà te ki Jose, su mepait daan is bitil ziyà te minsan hendei he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Hein nezineg ni Jacob he zuen belegyà he egkeenen diyà te Ehipto, migkeǥiyan din is menge anak din he maama te, “Hengkey pa is edteǥazan niw? ");
INSERT INTO mbbOT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nezineg ku he zuen kun egkeenen diyà te Ehipto. Hendiyè kew ne pemasa kew te egkeenen su wey kiw kenà mebpatey kayi te vitil.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ne zutun midhendiyà te Ehipto is sepulù he kakey ni Jose su ebpemasa zan te egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Wazà ni Jacob ibpezuma si Benjamin is hazi ni Jose te menge kakey zin, su egkahandek si Jacob kela ke zuen mezaat he egkeulaula ki Benjamin. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ne midhendiyà is menge anak ni Jacob te Ehipto, ne zuen menge zuma zan he ziyà te zuma he inged su ebpemasa zaan te egkeenen, su bitil en diyà te tivuuk he Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ne iyan si Jose gubirnedur te tivuuk he ǥinhedian te Ehipto, iyan sikandin ebelegyà te egkeenen diyà te tivuuk he menge meǥinged dutun. Ne zutun te kebpekeuma te menge kakey zin, midluhud dan diyà te etuvangan ni Jose he iyan kedtahud dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","9","Ne zutun te naahà sikandan ni Jose, nekilala zin sikandan, piru henduen be te kenè din uvag egkengekilala ne midhenggeran din sikandan ne ke sikandin te, “Hendei kew ebpuun?” Ne midtavak dan te, “Diyè key ebpuun te Canaan, ne midhengkayi key su ebpemasa key te egkeenen.” Ne netenuzan din is menge teǥeinep din mehitenged kandan ne ke sikandin diyà te kandan te, “Teruen kew! Umbe midhendini kew su ed-ahaan niw is kebpekesavuk dey wey niw metueni ke egkezaag key keniyu!” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ne midtavak dan te, “Es! Es! Kenà iyan, datù, su sikami is menge suluǥuen nu, iyan dey zà inhendini is kebpemasa te egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Su menge anak key pudu te sevaha zà he etew. Kenè key teruen su sikami is menge suluǥuen nu, kenà iyan dey inhendini is kebpeniid!” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“A, teruen kew iyan,” ke si Jose, “su midhendini kew wey niw iyan maahà is kebpekesavuk dey wey niw metueni ke egkezaag key keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ne midtavak dan te, “Sikami, datù, is menge suluǥuen nu, ne sepulù key wey zezuwa he menge anak te sevaha zà he etew. Diyè pa is amey zey te Canaan. Diyà daan te kandin is hazi zey. Duen pa sevaha he hazi zey he minatey en.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ne midtavak si Jose te, “Tutuu ves iyan he kebpeniid dà is inhendini niw. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Egezaman ku sikiyu wey ku metueni ke tutuu ve is migkaǥi niw. Idsesapè ku he mintras uuyag pa is hadì te Ehipto ne kenè kew ebpekaawà kayi emun kenà edhendini is hazi niw. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kinahanglan he ebpeveyaan te sevaha keniyu is hazi niw. Is duma keniyu ne ebpirisuwen ku su egezaman ku sikiyu wey ku metueni ke teruen kew. Su emun kenà tutuu is migkaǥi niw ne egketuenan ku he tutuu ves iyan he iyan inhendini niw is kebpeniid.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ne mibpirisu zin sikandan taman te tetelu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ne zutun te iketelu he andew migkeǥiyan sikandan ni Jose te, “Duen ebpeveelan ku keniyu wey kew melibri su siak, edtahud a te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Emun tutuu is migkaǥi niw, kinahanglan he itaǥak niw is sevaha keniyu te teltelesuled kayi ne ulì kew wey niw ikehated is egkeenen diyà te menge pemilya niw he egkengevitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ne zumaha niw zini sikan is hazi niw su wey ku metueni he wazè kew medtarùtarù para kenè ku sikiyu ebpehimetayan.” Ne mibeelan dan haazà. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ne pesikaǥi zan dutun te, “Umbe egkeulaula en heini kenitew su silut tenged te mid-ulaula tew ziyà te hazi tew he si Jose. Su minsan pa te utew sikandin nerasey wey midhengyuan kiw zin, midtengtengan tew zà ne wazè kiw mebpehangyù. Umbe edlised kiw en guntaan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ne migkaǥi zutun si Reuben te, “Migkeǥiyan ku zengan sikiyu te, ‘Kenè niw pesipelahi is hazi tew? Piru wazè kew mebpemineg kedì. Umbe edsilutan kiw en guntaan tenged te kemetayen din.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wazè dan metueni he egkesavut ni Jose is egkeǥiyen dan, su emun ebpekidlalag sikandin kandan ne zuen tigseysey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mid-awà dèpa si Jose ziyà te kandan su edsineǥew. Ne netetegteǥaad ne midlikù sikandin ne mid-uman mebpekidlalag kandan. Ne zutun mibpilì din si Simeon dutun te kandan ne impevakus din diyà te etuvangan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ne midsuǥù ni Jose is menge suluǥuen din he penua zan te keuyaǥan is menge saku te menge kakey zin ne insuǥù din daan he ieles diyà te saku te kada sevaha is selapì he imbayad din dutun, ne insuǥù din daan he veǥayi sikandan te lutù para te ked-ulì dan. Ne netuman is langun he insuǥù ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ne hein nepasad heini migkergahan dan is menge asnu zan te keuyaǥan, ne migenat dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ne hein mezukilem en midhulavung dan diyà te sevaha he lugar. Ne mibengkasan te sevaha kandan is saku zin su ibpekaan din is asnu zin ne neehè din is selapì he imbayad din. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ne migkeǥiyan din is menge suled din te, “Inlikù is imbayad ku! Su neketaǥù kayi te saku ku.” Ne zutun mibpengguyaan sikandan langun is mibpengulbaan. Mibpein-inseey sikandan te, “Hengkey vuwa heini is mid-ulaula te Megbevayà kenitew?” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ne hein nekeulì dan diyà te amey zan he si Jacob he ziyà te Canaan midtudtulan dan sikandin te langun he neulaula kandan. Ke sikandan te, ");
INSERT INTO mbbOT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Sikan is gubirnedur he impevayàbayà te tivuuk he ginhedian, mid-eǥetan key zin he migkaǥi te iyan inhendiyè dey is kebpeniid kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Piru midtavak dey sikandin te kenè key menge meniniid, ne tutuu is egkeǥiyen dey. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Migkaǥi key zaan he 12 key he teltelesuled he menge anak te sevaha zà he etew. Minatey is sevaha he hazi zey, ne ziyè ded mulà is sevaha te amey zey ziyà te Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Piru migkeǥiyan key zin te, ‘Egezaman ku sikiyu ke tutuu ve iyan is migkaǥi niw. Kinahanglan he itaǥak niw zini is sevaha keniyu ne ulì kew wey niw ikehated is keuyaǥan diyà te menge pemilya niw he egkengevitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ne kinahanglan he edumahan niw is hazi niw kayi su wey ku metueni ke kenè kew teruen wey kenà kebpeniid dà is inhendini niw. Ne idlikù ku is sevaha he suled niw ziyan te keniyu, ne edtuǥutan ku sikiyu te kednigusyu zini te Ehipto.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ne hein imbusbus dan is taǥù te menge saku zan neehè dan diyà te kada saku is selapì he imbayad te kada sevaha. Ne zutun te kegkaahaa ni Jacob wey is menge anak din te selapì dan ne utew zan migkulbai. ");
INSERT INTO mbbOT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ne migkaǥi si Jacob diyà te kandan te, “Pinaaǥi keniyu egkeewaan a te menge anak ku. Su minatey en si Jose, neewaan a ni Simeon, ne egkuwaan niw pe bes si Benjamin? Utew e en nerasey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ne migkaǥi si Reuben diyà te amey zin te, “Amà, iyan e en metau ki Benjamin. Himetayi nu is menge anak ku he zezuwa emun kenè ku sikandin egkezuma te ed-ulì dini te kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Piru midtavak si Jacob te, “Kenà egkehimu he ibpezuma ku keniyu si Benjamin. Minatey en is kakey zin ne iyan dà sikandin nesamà is sebsevaha. Kele ke zuen mezaat he egkeulaula kandin diyà te hipenawan, ne siak meǥurang e en, kela ke iyan ibpatey ku is kegkeseeng ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ne utew en mid-iseg haazà is bitil ziyà te Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ne hein naamin dan en is egkeenen he migkuwa zan diyà te Ehipto migkaǥi si Jacob diyà te kandan te, “Hendiyè kew en maan wey kew mekepemasa te egkeenen tew minsan deisey zà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ne midtavak si Juda te, “Haazà is gubirnedur, mibpeketelteleenan key zin he kenà egkehimu he ebpekeetuvang key ziyà te kandin emun kenè dey egkezuma is hazi zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ne emun ibpezuma nu si Benjamin edhendiyè key ne ebpemasa key te egkeenen tew. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Iyan, emun kenè nu ibpezuma, ne kenè key zaan edhendiyà su migkaǥi sikan is gubirnedur he emun kenè dey egkezuma is hazi zey ne kenà egkehimu he ebpekeetuvang key ziyà te kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ne migkaǥi si Jacob te, “Maan is midhimu niw he utew a meseeng? Maan is migkaǥi niw kandin he zuen niw pa hazi?” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ne midtavak dan te, “Geina te mibpeniguduwan key zin insai mehitenged te pemilya tew. Ke sikandin te, ‘Uuyag pe be is amey niw? Duen niw pe be hazi?’ Umbe intug-an dey su wazè dey isipa he egkeǥiyen din he kinahanglan he edumahan dey pa is hazi zey ziyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ne zutun migkaǥi si Juda ziyà te amey zin he si Israel te, “Isarig nu kediey si Benjamin ne egenat key en guntaan su wey kiw kenà meumes te vitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iyan a ebantey kandin ne iyan a ebpesarig kenikew he emun kenè ku sikandin igkeulì dini te etuvangan nu ne kediey he salà diyà te kenikew te wazà pidtemanan. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Angin ke wazè key mesanggen su kezezuwa key en pezem mekehendiyà wey mekeulì dini.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ne migkaǥi zutun is amey zan te, “Emun iyan en heeyan egkeulaula su wazà duma he paaǥi, ne zeyzey ke zuen edtinesen niw he menge meupiya he igasa he zini ebpuun te kenitew wey niw meuwit diyà te egalen dan. Uwit kew te menge bawì, teneb, penaket, menge perehemut, wey menge veǥas te kayu he pistasyu wey almindru. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tekepa niw is selapì niw wey niw ikeulì haazà is selapì he neketaǥù diyà te menge saku niw su kela ke nesayep dan dà. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ne zumaha niw zaan is hazi niw ne ǥaanggaan kew likù dutun te gubirnedur. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Berakat he pengelinteuwi te Mekeǥeǥehem he Megbevayà he mehizuwi kew zin su wey ituǥut din he mekeulì si Simeon wey si Benjamin. Ne siak, emun iyan imbanglis kediey he egkeewaan e pa te menge anak ku ne kinahanglan he ed-entusen ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ne zutun mibpenines dan is menge igasa zan ne midtakep dan is selapì dan. Migenat dan ne miduma zan si Benjamin pehendiyà te Ehipto, ne mibpekid-ehè dan te ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Hein naahà sikandan ni Jose he nezuma zan si Benjamin, migkeǥiyan din is suluǥuen din te, “Dumaha nu heini is menge etew ziyà te valey ku. Lapè ka te uyaǥen wey susuba ka, su kayi sikandan ebpeniudtu zuma kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ne midtuman dutun te suluǥuen is insuǥù kandin. Ne miduma zin sikandan diyà te valey ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ne utew sikandan nahandek dutun te kedumaha kandan diyà te valey ni Jose su neisip dan is, “Kela ke iyan indumaha kenitew kayi is tenged te selapì he neketaǥù diyà te menge saku tew zutun te nehuna he kedhendini tew. Kela ke edekepen kiw ne ed-uripenen kiw ne egkuwaan dan is menge asnu tew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ne tenged dutun mid-uvayan dan haazà is suluǥuen ni Jose ne mibpekidlalag dan diyà te ǥemawan dutun te valey. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ke sikandan te, “Datù, midhendini key zengan su mibpemasa key te egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Piru hein nezukileman key ne nekehulavung key ziyà te sevaha he lugar, ne mibengkasan dey is menge saku zey, ne neehè dey zutun te menge saku zey sikan is selapì he impemasa zey te egkekaan. Heini zed, id-ulì dey. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ne zuen selakew en maan he selapì dey ǥuntaan he ibpemasa te egkeenen. Wazè dey metueni ke hentei is midtaǥù te selapì diyà te menge saku zey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ne midtavak is suluǥuen te, “Wazà kinahanglan he igkeseeng niw heeyan. Kenè kew mahandek. Is Megbevayè niw he Megbevayà te amey niw, iyan buwa mibeǥey keniyu te selapì diyà te menge saku niw, su nezawat ku man is selapì niw.” Ne mid-uwit din diyà te kandan si Simeon. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Impeseled din dutun sikandan te valey ni Jose ne mibeǥayan din sikandan te wahig he ibpenlùlù te menge paa zan. Ne migkumpayan din daan is menge asnu zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ne mid-andam dan dutun is menge igasa zan ki Jose ke ed-ulì te meudtu su nezineg dan he ziyè din sikandan ibpekaan te valey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ne hein nekeuma si Jose, midluhud dan he iyan kedtahud dan kandin ne imbeǥey zan is menge igasa zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ne nenginginsà si Jose kandan ke egkemenumenu zan en. Ne nenginginsè en maan sikandin te, “Egkemenumenu en is amey niw he meǥurang en he midtudtul niw zengan kedì? Uuyag pe be sikandin?” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ne midtavak dan te, “Uuyag pa is amey zey wey meupiya zed daan sikandin.” Ne mid-uman dan medluhud su ibpeehè dan is kedtahud dan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Hein naahà ni Jose si Benjamin is lumunè din en te ǥetek, ke sikandan te, “Iyan be heini sikan is hazi niw he migkaǥi niw zengan kedì?” Ne migkeǥiyan din si Benjamin te, “Mama, berakat he tuvazi ka te Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ne zutun utew si Jose nerurunù te kebulunga zin te hazi zin. Migaanggaan sikandin med-awà dutun ne midseled diyà te ruǥu zin ne ziyà medsineǥew. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ne hein netegteǥaad, mibpendapug ne midlikuan din is menge suled din ne midtigker zin is gehinawa zin ne ke sikandin diyà te menge suluǥuen te, “Isavuk niw en is egkeenen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Impedsisivey zan is egkeenan: is egkeenan ni Jose, is egkeenan te menge suled din, wey is egkeenan te menge etew zutun he tig-Ehipto. Su is menge tig-Ehipto kenè dan ebpekidtuǥen te menge Hebriyuhanen su utew haazà supak te menge vetasan dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Impemepinuu is menge suled ni Jose sumalà is idad dan puun duen te kakey kandan pehendiyà te hazi ne tenged dutun mibpetengtengtengè dan su utew zan nengeinuinu. ");
INSERT INTO mbbOT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Duen menge idsezà he ebpuun te lemisahan ni Jose he impehated din diyà te kandan ne is imbeǥey ki Benjamin, ne kelelima metakep te kezekelà te imbeǥey ziyà te menge kakey zin. Ne migkaan dan ne mid-inum dan duma ki Jose ne mibmeupiya is gehinawa zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ne zuen insuǥù ni Jose ziyà te suluǥuen din he ebayàbayà diyà te valey zin. Ke sikandin te, “Penua nu is saku te kada sevaha kandan sumalà is egkehenat te menge asnu zan, ne itaǥù nu is selapì he ibpemasa te kada sevaha ziyà te saku zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ne haazà is saku te hazi zan, dutun nu itaǥù is tasa ku he pelata zuma te selapì din he ibpemasa zin te egkeenen.” Ne midtuman din haazà is insuǥù ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ne hein nepawà impeǥenat din en is menge suled ni Jose wey menge asnu zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ne hein kenè pa utew meziyù is imbayè dan migkaǥi si Jose ziyà te suluǥuen din te, “Gègaani nu telukuni haazà is menge etew ne emun egkesaut nu, keǥiyi nu sikandan te, ‘Maan is utew mezaat is imbales niw te ǥaǥew te egalen ku? ");
INSERT INTO mbbOT_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Maan is migkuwa niw kes tasa he inumà te egalen ku he egemiten din te kebpenagnà? Kenà meupiya hini is mid-ulaula niw.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ne nesaut din sikandan ne migkaǥi zin kandan haazà is impekaǥi kandin ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Piru midtavak dan te, “Datù, maan is egkaǥi ka te iring keniyan? Kenà egkehimu he zuen ebeelan dey he iring te migkaǥi nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Netuenan nu en man he puun pa te Canaan, inlikù dey is neehè dey he selapì duen te saku zey ziyan te kenikew. Maan is egkinahanglan key pa te kebpenakew te selapì wey vulawan diyà te valey te egalen nu? ");
INSERT INTO mbbOT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Emun duen kayi te kenami egkaahaan nu keniyan te tasa he nekaǥi nu, himetayi sikandin ne uripena key is duma.” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ne midtavak haazà is suluǥuen ni Jose te, “Uya, emun duen minsan hentei keniyu he egkaahaan ku kayi ne ed-uripenen ku sikandin, ne is duma keniyu ne wazè din mulà televaken.” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ne zutun migègaanan hew-asa te kada sevaha is saku zin ne mibengkasan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ne zutun midsusi te suluǥuen is saku te kada sevaha puun dutun te kakey kandan pehendiyà te kineheziyan, ne ziyè din meturedu is tasa te saku ni Benjamin. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ne hein naahà heini zutun te teltelesuled, mibindas dan is menge ugelingen dan tuus te utew zan kegkeseeng. Migkergahan dan en maan is menge asnu zan ne midlikù dan diyà te inged. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ne hein nekeuma si Juda wey is menge suled din, ne zutun ded si Jose te valey zin. Midseled sikandan dutun te valey ne midluhud dan diyà te etuvangan ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Migkeǥiyan ni Jose sikandan te, “Hengkey heini is mid-ulaula niw? Wazè niw ves metueni he metau a he edtagnà?” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ne midtavak si Juda te, “Datù, wazè dey en igkepengetezengan kenikew, ne kenè dey zaan egkekaǥi he wazè dey salà. Iyan is Megbevayà mibpezayag te salè dey. Sikami is langun ne menge uripen key en kenikew wey kes naahaan nu zuen te tasa.” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iyan, midtavak dutun si Jose te, “Kenà egkehimu he pudu kew ed-uripenen ku su kenà haazà metazeng he kukuman. Iyan dà ed-uripenen ku is sevaha he ziyà te kandin maahà kes tasa ku. Is duma keniyu ne egkehimu he ed-ulì kew ziyà te amey niw te wazà samuk.” ");
INSERT INTO mbbOT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ne zutun mid-uvayan si Jose ni Juda ne ke si Juda te, “Pekelalaglalag ka, datù, ne tuǥuti a kenikew is suluǥuen nu he mekekaǥi a ziyà te kenikew. Ne minsan pa te nekedrepeng kew te hadì te Ehipto ne kenà a kenikew mepeuki. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Dutun te nehuna he kedhendini zey, in-insè nu kenami te menge suluǥuen nu ke zuen dey pa amey wey hazi. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ne midtavak key te duen dey iyan amey he meǥurang en utew wey zuen dey pa hazi he in-anak te meǥurang en utew is amey zey. Iyan dà sikandin nesamà te menge anak te iney zin su minatey en is kakey zin. Ne utew sikandin pinelanggà te amey zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ne migkaǥi nu he kinahanglan he edumahan dey sikandin dini wey nu zaan maahà. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ne migkaǥi key he kenà egkehimu he ed-ewaan din is amey zey su ebpatey is amey zey ke egkeewaan sikandin te hazi zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ne iyan migkaǥi nu is: ‘emun kenè dey edumahan dini is hazi zey ne kenè en egkehimu he ebpekeetuvang key maan kenikew.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ne hein mid-ulì key ziyà te suluǥuen nu he amey zey midtudtul zey kandin haazà is migkaǥi nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ne zuen timpu he migkaǥi is amey zey he kinahanglan he medlikù key kayi te Ehipto wey key mekepemasa en maan te egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ne migkaǥi key zutun he kenè key ebpekelikù. Wey key zà ebpekelikù ke egkezuma zey is hazi zey su migkaǥi key he kenà egkehimu he ebpekeetuvang key kenikew emun kenà ebpekezuma is hazi zey. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ne zutun migkaǥi kenami is suluǥuen nu he amey zey, ke sikandin te, ‘Netuenan niw he zuen dezuwa he maama he in-anak te esawa ku. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Neewaan a te sevaha, ne migkaǥi ku zutun he siguradu midawi sikandin te kumekaid, ne taman en guntaan wazè ku en maan sikandin maahà. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ne emun edumahan niw si Benjamin ne ke zuen mezaat he egkeulaula kandin, siak is uvanen en, tenged keniyu kenè en egkaawà is utew ku kegkeseeng taman te kenè e pa ebpatey.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Ne emun kenà ebpekezuma kenami is hazi zey ke ed-ulì key ziyà te amey zey, ne is amey zey emun kenè din egkaahà is anak din, ebpatey sikandin su iring te untung din heini is anak din. Ne sikami is menge suluǥuen nu, tenged kenami utew en egkeseeng is amey zey he uvanen en ne kenà egkaawà is seeng din taman te kenè pa sikandin ebpatey. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Siak is sevaha he suluǥuen nu, mibpesarig a ziyà te amey zey he wazà mezaat he egkeulaula te anak din he ke siak te, ‘Emun kenè ku sikandin igkeulì kayi ne kediey he salà diyà te kenikew te wazà pidtemanan.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ne pekelalaglalag ka ǥuntaan ne ituǥut nu he iyan a is suluǥuen nu ebpetaǥak kayi su iyan a ed-uripenen he id-ilis te hazi ku ne ipeulì nu zed sikandin duma is menge suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Su kenà a ebpekeulì diyà te amey ku emun kenà ebpekezuma is hazi ku. Kenè ku egkaantus is utew gerabi he kegkeseeng te amey ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kenè en dutun egketigker ni Jose is gehinawa zin, umbe impeliǥawang din is menge suluǥuen din. Hein wazè en dutun menge etew he zuma ni Jose, mibepekilala sikandin te menge suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Midsineǥew zutun si Jose, ne nezineg haazà te menge Ehiptohanen, ne netudtulan dutun is pemilya te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Migkaǥi si Jose ziyà te menge suled din te, “Iyan a si Jose! Uuyag pe be is amey ku?” Piru wazà meketavak dutun is menge kakey zin su utew zan netentani. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ne zutun migkeǥiyan ni Jose is menge suled din te, “Uvey kew kayi te kedì.” Ne hein mid-uvayan dan en, ke sikandin te, “Iyan a sikan is suled niw he si Jose, kes imbelegyè niw ne mid-uwit dini te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kenè kew meseeng, ne kenè kew mebasul te ingkevelegyà a keniyu kayi, su paaǥi heini te Megbevayà is impehuna a kayi para meluwas kew te mereǥen he ked-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dezuwe en he tuig is ked-aǥi te vitil zini te kenitew ne egkeumanan pa heini te lelima he tuig he wazà egkeraǥun te ebasuk. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Piru impehuna a zini te Megbevayà su ebpengelinteuwan din he kenè kew mebpatey te vitil ne zuen samà kenitew zini te kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Umbe, kenè kew iyan mibpuwit kayi kedì, kekenà, iyan is Megbevayà. Midhimu e zin he peresambag te hadì kayi te Ehipto wey ibpezumala te pemilya zin, wey edumala te tivuuk he ginhedian te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ne ǥuntaan, gaanggaan kew ulì diyà te amey tew ne keǥiya niw kandin he is anak din he si Jose ne midhimu te Megbevayà he iyan ebayàbayà te tivuuk he ginhedian te Ehipto. Ne keǥiyi niw sikandin te ibpeǥaanggaan ku ibpehendini. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Keǥiyi niw sikandin he egkehimu he ebpekeubpà sikandin diyà te inged he Goshen duma te menge anak din wey menge apù din, menge uyaǥen, wey is langun he menge azen din, para uvey zà sikandin kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ne emun diyè en sikandin te Goshen, ne ed-elimahan ku sikandin su zuen pa lelima he tuig he vitil he ebpeebuten. Kenè ku egkesuatan he egkeumes sikandin wey is menge pemilya zin ragkes is menge uyaǥen din.” ");
INSERT INTO mbbOT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ne impelaus ni Jose is menge lalag din te, “Guntaan, wazè en mekeeles keniyu, wey te suled ku he si Benjamin he tutuu iyan he iyan a si Jose is ebpekidlalag keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Keǥiya niw ziyà te amey ku is mehitenged te ketengdanan ku kayi te Ehipto wey is langun he neehè niw parti kedì, ne ǥègaani niw sikandin ipehendini te kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ne zutun migkepkepan din is hazi zin he si Benjamin ne midsineǥawan din, ne midsineǥew zaan si Benjamin is egkepkep daan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ne midhezekan ni Jose is langun he menge kakey zin he edsineǥaw sikandin. Ne zutun human mekepekidlalag kandin is menge suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ne hein netudtul haazà diyà te turuǥan te hadì te Ehipto he nemekeuma is menge suled ni Jose, utew nesuat kes hadì ne nesuat daan is menge upisyal zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Migkaǥi haazà is hadì diyà te ki Jose te, “Keǥiyi nu is menge suled nu he iyan ibpeulaula ku kandan is: ‘Kergahi zan is menge asnu zan ne med-ulì dan diyà te Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ne dumaha zan is amey niw wey is menge pemilya zan dini te kediey. Ebeǥayan ku sikandan te utew meupiya he tanà dini te ǥinhedian ku he Ehipto. Ibpekaan ku sikandan te utew meupiya zini te ǥinhedian ku.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Keǥiyi nu sikandan he med-uwit dan te menge kerumata he ebpuun kayi te Ehipto he egkeuntuzan te menge esawa zan wey te menge anak dan wey zan mekahalin dini. Ne uwita zan dini is amey zan. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kenè dan menuǥuni is menge azen dan he egkengetaǥak dan su is menge meupiya he menge azen kayi te tivuuk he Ehipto ne egkaangken dan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Midtuman heini te menge anak ni Jacob. Ne sumalà te suǥù te hadì te Ehipto, impeuwit ni Jose is menge suled din te menge kerumata ne impelulutù din te egkekaan dan te edhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Mibeǥayan ni Jose te ed-ilisan is kada sevaha kandan; piru is imbeǥey zin ki Benjamin ne lelima he ed-ilisan wey 300 he elad he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Mibpeuwitan din daan is amey zin te 10 he asnu he migkergahan te menge meupiya he menge pruduktu te Ehipto, wey 10 he asnu he menge vehiyan he migkergahan te veǥas te trigu, supas, wey edlutuen te amey zan te kedhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ne hein impeǥenat din is menge suled din, ke sikandin te, “Kenè kew mebpeeg-eǥetà diyà te zalan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ne mid-awè dan diyà te Ehipto ne nekeuma zan diyà te amey zan he si Jacob diyà te Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Hein nekeuma zan diyà, midtudtulan dan is amey zan te uuyag pa si Jose, ne iyan sikandin ebayàbayà te tivuuk he ǥinhedian te Ehipto. Ne netentanan dutun si Jacob ne wazà mekekaǥi; henduen te kenà dutun ebpeketuu sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Piru hein midtudtulan dan sikandin te langun he migkaǥi ni Jose ziyà te kandan, wey hein neehè din is menge kerwahi he impeuwit ni Jose he ebpeuntuzan kandin wey mekehalin sikandin diyà te Ehipto, ne nekelikù is hustu he ked-isip-isip din. ");
INSERT INTO mbbOT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ne migkaǥi si Jacob te, “Nevenaran a human! Uuyag pe bes iyan is anak ku he si Jose! Edhendiyà a te kandin wey ku sikandin maahà te kenè e pa ebpatey!” ");
INSERT INTO mbbOT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ne zutun migenat si Jacob duma te pemilya zin, ne mid-uwit dan is langun he menge azen dan. Ne hein nekeuma zan diyà te Beersheba, mibpemuhat din is Megbevayà te amey zin he si Isaac. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ne hein mezukilem, mibpaahà is Megbevayà ki Jacob. Ne mid-umew te Megbevayà si Jacob, ke sikandin te, “Jacob.” Ne midtavak si Jacob te, “Heini e zed.” ");
INSERT INTO mbbOT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ne ke sikandin te, “Megbevayà a; iyan a kes Megbevayà te amey nu. Kinahanglan he kenè ka mahandek he ebpehendiyà te Ehipto, su edhimuwen ku sikiyu he utew zekelà he nasyun. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Eduma a keniyu ke edhendiyè kew te Ehipto ne edhimuwen ku he mekeulì daan keuzemà is menge kevuwazan nu. Ne sikew, emun ebpatey ka ne iyan si Jose edleveng kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ne zutun, migenat en maan ensi Jacob he ebpuun te Beersheba, ne impeuntud dan sikandin te menge kerwahi he imbeǥey te hadì te Ehipto para kandin. Ne impeuntud dan daan is menge esawa zan wey menge anak dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Midtundan dan daan is langun he menge uyaǥen dan wey mid-uwit dan is menge ketiǥeyunan dan he nekuwa zan diyà te tanà he Canaan. Miduma ni Jacob pehendiyà te Ehipto is langun he menge kevuwazan din: is menge anak din wey menge apù din. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Iyan heini menge ngazan te menge Israilihanen he menge kevuwazan ni Jacob he midhendiyà te Ehipto: si Reuben is kinekekayan he anak ni Jacob, ");
INSERT INTO mbbOT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ne is menge anak he maama ni Reuben ne iyan si Hanoc, si Palu, si Hezron, wey si Carmi. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Is menge anak he maama ni Simeon iyan ensi Jemuel, si Jamin, si Ohad, si Jakin, si Zohar, wey si Shaul ne iyan heini anak ni Simeon pinaaǥi te vahi he tig-Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Is menge anak he maama ni Levi ne iyan si Gershon, si Kohat, wey si Merari. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Is menge anak he maama ni Juda ne iyan si Er, si Onan, si Shela, si Perez, wey si Zera (piru si Er wey si Onan, diyè dan dà mebpatey te Canaan), ne zuen menge anak ni Perez he si Hezron wey si Hamul. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Is menge anak he maama ni Isacar ne iyan si Tola, si Pua, si Jashub, wey si Shimron. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Is menge anak he maama ni Zebulun ne iyan si Sered, si Elon, wey si Jaleel. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Iyan heini menge anak wey menge apù ni Jacob he in-anak ni Lea ziyà te inged he Padan Aram. Ne 33 is langun he menge kevuwazan ni Jacob wazà lavet te anak din he vahi he si Dina. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Is menge anak he maama ni Gad ne iyan si Zefon, si Hagi, si Shuni, si Ezbon, si Eri, si Arodi, wey si Areli. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Is menge anak he maama ni Asher ne iyan si Imnah, si Ishva, si Ishvi, si Beria, wey is etevey zan he si Sera. Duen menge anak ni Beria he iyan si Heber wey si Malkiel. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Menge kevuwazan heini ni Zilpa, is suluǥuen he imbeǥey ni Laban diyà te anak din he si Lea. Ne heini is 16 ne menge kevuwazan ded daan ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","20","Is menge anak he maama ni Jacob pinaaǥi te esawa zin he si Raquel ne iyan si Jose wey si Benjamin. Is menge anak ni Jose, ne si Efraim wey si Manase. Diyà sikandan ianak te Ehipto. (In-anak sikandan ni Asenat, sikan is anak ni Potifera he iyan memumuhat diyà te inged he On.) ");
INSERT INTO mbbOT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Is menge anak he maama ni Benjamin ne iyan si Bela, si Beker, si Ashbel, si Gera, si Naaman, si Ehi, si Rosh, si Mupim, si Hupim, wey si Ard. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Iyan sikandan kes 14 he menge anak wey menge apù ni Jacob diyà te ki Raquel. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Is anak he maama ni Dan ne iyan si Hushim. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Is menge anak he maama ni Naftali ne iyan si Jaziel, si Guni, si Jezer, wey si Shilem. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Menge kevuwazan heini ni Bilha, sikan is suluǥuen he imbeǥey ni Laban diyà te anak din he si Raquel. Pitu sikandan he menge kevuwazan daan ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Is kezakel te menge anak wey apù ni Jacob he midhendiyà te Ehipto ne 66 langun, kenà ragkes is menge esawa te menge anak din. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Is menge anak he maama ni Jose he in-anak diyà te Ehipto, ne zezuwa. Ne 70 is langun he menge kevuwazan ni Jacob dutun te timpu te kedseled dan diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Si Jacob, ne impehuna zin si Juda ziyà te ki Jose su wey ikepenurù kandin is ibayà pehendiyà te tanà he Goshen. Ne hein nekeume en ensi Jacob diyà te tanà he Goshen, ");
INSERT INTO mbbOT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","impaandam ni Jose is kerwahi zin, ne mid-untud sikandin su egenat te kedtelavuk te amey zin diyà te Goshen. Ne hein nekeuma si Jose migkepkepan din is amey zin ne utew neuǥet is kedsineǥew zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ne migkaǥi si Jacob diyà te anak din he si Jose te, “Egkehimu en ke ebpatey a su neehè ku en he uuyag ke pa iyan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ne migkaǥi zutun si Jose ziyà te menge suled din wey ziyà te langun he menge sakup te amey zin te, “Edhendiyà a te hadì su kinahanglan he edlelaǥan ku sikandin te, ‘Sikan is menge suled ku wey is langun he menge sakup te amey ku nekeuma zan en dini te kediey he ebpuun te ed-ubpaan dan diyà te Canaan.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Egkeǥiyan ku sikandin te, ‘Is menge maama, ne menge bekidu sikandan te menge uyaǥen, ne mid-uwit dan daan is langun he menge azen dan wey is langun he menge uyaǥen dan.’ ");
INSERT INTO mbbOT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ne emun ibpeumew kew te hadì ne ed-insaan kew zin ke hengkey is terebahu niw, ");
INSERT INTO mbbOT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kinahanglan he medtavak kew, ke sikiyu te, ‘Sikami is menge suluǥuen nu, menge bekidu key; puun dà te kedekdekelè dey su iyan daan heini ulaula te menge ginikanan dey.’ ” Ne ke si Jose te, “Dutun edtuǥutan kew zin he ed-ubpà diyà te tanà he Goshen, su is menge Ehiptohanen utew zan egkeepesi is minsan hentei he menge bekidu te menge uyaǥen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ne midhendiyà si Jose te hadì te Ehipto ne ke sikandin te, “Nemekeume en is amey ku wey menge suled ku he ebpuun te tanà he Canaan, ne uwiten dan is langun he menge azen dan wey menge uyaǥen dan, ne ziyè dan en te Goshen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Impekilala zutun ni Jose te hadì is lelima zuen te menge suled din. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ne mid-insaan sikandan dutun te hadì te, “Hengkey is terebahu niw?” Ne midtavak sikandan te, “Menge bekidu key te menge uyaǥen, iring te menge ginikanan dey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ne migkaǥi zan daan te, “Midhendini key su zini key zèpa ed-ubpà su utew gerabi he vitil ziyà te Canaan, ne wazè en egkepenebtavan te menge uyaǥen dey. Pekelalaglalag ka he tuǥuti key he mekeubpè key ziyà te Goshen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ne migkaǥi haazà is hadì diyà te ki Jose te, “Guntaan te nekeuma en is amey nu wey menge suled nu, ");
INSERT INTO mbbOT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","egkehimu he ebpekeubpà is pemilya nu kayi te Ehipto. Diyè nu ipeubpà sikandan te Goshen, he sevaha te meupiya he tanà te Ehipto. Emun duen nu netuenan kandan he egkeseriǥan, himuwa nu sikandan he menge bekidu te menge uyaǥen ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ne impeetuvang daan ni Jose is amey zin he si Jacob ne impekilala zin dutun te hadì, ne mibpenubtuvazan ni Jacob haazà is hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Mid-insaan dutun te hadì si Jacob, ke sikandin te, “Pira, anggam, is penuiǥen nu?” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ne midtavak si Jacob te, “130 en is penuiǥen ku. Mevavè dà is kedì he untung ne mereǥen is neulaula ku. Is keluǥayad te kedì he untung ne kenà ebpekerepeng te keluǥayad te untung te menge kepuun ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ne zutun, mibpenubtuvazan en maan ni Jacob haazà is hadì ne mid-ewaan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ne mibeǥayan ni Jose is amey zin wey is menge suled din te utew memeupiya he tanà diyà te Ehipto ziyà te tanà he Rameses sumalà is insuǥù kandin dutun te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ne is amey zin, is menge suled din, wey is langun he menge sakup te amey zin ragkes te menge vatà, ne midsupurtar ni Jose te egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ne zutun, mid-iseg pa utew is bitil, umbe wazè en keuyaǥan diyà te minsan hendei he lugar. Is menge meǥinged diyà te Ehipto wey ziyà te Canaan, ne utew zan midlised tenged dutun te vitil. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Midtiǥum ni Jose is langun he selapì te menge tig-Ehipto wey tig-Canaan he ingkepemasa zan te keuyaǥan. Ne haazà is selapì, mid-uwit ni Jose ziyà te turuǥan te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ne hein naamin en is selapì te menge tig-Ehipto wey menge tig-Canaan, midhendiyà te ki Jose is langun he menge tig-Ehipto. Ke sikandan te, “Wazè dey en selapì. Beǥayi key te keuyaǥan su henduen be te ebpatey key en te kegkevitil.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Migkaǥi si Jose te, “Emun wazè niw en selapì, uwita niw zini is menge uyaǥen niw ne egkehimu he idliwè niw te keuyaǥan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ne zutun mid-uwit dan diyà te ki Jose is menge uyaǥen dan he menge kudà, asnu, vaka, wey kerehidu, ne inliwè dan haazà diyà te ki Jose te keuyaǥan. Ne pinaaǥi kayi te kedliwaa zan te menge uyaǥen dan midhimu ni Jose he kenè dan bitila taman te senge tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kedlavey te senge-tuig, midhendiyè en maan is menge etew te ki Jose, ke sikandan te, “Wazà mekeeles kenikew he wazè dey en selapì, ne is menge uyaǥen dey diyan en te kenikew. Wazè en nesamà kenami, gawas te lawa zey wey tanà. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Umbe tevangi key he kenè key mebpatey wey kenè dey mevey-ani is menge tanè dey. Ebpezumazuma key he egkehimu he menge uripen te hadì wey mekuwa zin is menge tanè dey asal zà duen dey keuyaǥan. Beǥayi key en te menge venì he ibpemula zey su wey key kenà mebpematey wey kenè dey mevey-ani is menge tanè dey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Umbe imbelegyà te langun he tig-Ehipto is menge tanè dan diyà te ki Jose tenged te utew mepait he vitil. Ne mibpemasa ni Jose haazà is langun he menge vevesukà diyà te Ehipto su wey meǥaked te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Pinaaǥi zutun midhimu ni Jose he menge suluǥuen te hadì is menge etew ziyà te tivuuk he tanà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iyan dà tanà he wazè din mekuwa sikan is gaked te menge memumuhat su zuen layun idsuhul kandan te hadì ne tenged dutun wazè dan mulà bitila ne wazè dan ikevelegyà is tanè dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ne zuen migkaǥi ni Jose ziyà te menge etew, ke sikandin te, “Guntaan te nepemasa ku en sikiyu wey is menge tanè niw he para te hadì, ebeǥayan ku sikiyu te venì wey kew mekepemula. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ne emun edraǥun kew en, iveǥey niw ziyà te hadì is ikelima he vahin te egkeraǥun niw. Ne keniyu en haazà is nesamà, para zuen niw igkepemula wey zuen daan keuyaǥan te tivuuk he pemilya niw.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ne midtavak dan te, “Datù, utew meupiya is mibeelan nu kenami, su midlibri key kenikew. Ne ebpezumazuma key he egkehimu he menge uripen te hadì.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Umbe midhimu ni Jose is belaud diyà te tanà te Ehipto he is ikelima he vahin te egkeraǥun ne para te hadì. Heini he velaud kemulu pa taman en guntaan. Iyan dà wazà maangken te hadì is tanà te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Is menge kevuwazan ni Israel, ne ziyè dan med-ubpà te tanà he Goshen he sakup te Ehipto. Nekaangken sikandan te menge tanà dutun ne mibmezakel zan utew. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Si Jacob, ne 17 he tuig is ked-ubpè din diyà te Ehipto ne is keluǥayad te untung din, ne 147 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Hein egkeǥezam din he meǥaan en sikandin egkeumuri, mid-umew zin si Jose, ne ke sikandin diyà te kandin te, “Emun egkehimu isavuk nu is belad nu kayi te laang ku, ne penangdù ka he ipeehè nu he kenà egkaawà is gaǥew nu kedì. Kenà a ileveng kayi te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Emun ebpatey ad, ne ileveng a kenikew ziyà te penlevengà te menge kepuun ku.” Ne midtavak dutun si Jose te, “Uya, edtumanen ku is intelaan nu kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ne migkaǥi si Jacob te, “Penangdù ka kediey he edtumanen nu iyan heini.” Ne mibpenangdù si Jose. Ne zutun midlangkeb si Jacob dutun te hizeǥaan din su ebpeselamat te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Neuma is timpu he netudtulan si Jose he edezaru is amey zin he si Jacob. Umbe miduma zin is dezuwa he anak din he si Manase wey si Efraim ne midhendiyà dan te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Hein netudtulan si Jacob he nekeuma is anak din he si Jose, midteǥel sikandin med-enew ne mibpinuu ziyà te hizeǥaan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ne migkaǥi si Jacob diyà te ki Jose te, “Mibpaahà dengan kediey is Mekeǥeǥehem he Megbevayà diyà te inged he Lus he ziyà te Canaan ne zutun midtuvazan e zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ke sikandin te, ‘Ebeǥayan ku sikew te mezakel he menge kevuwazan su wey ka mehimu he amey te mezakel he menge etew. Ne ibeǥey ku heini is tanà te Canaan diyà te menge kevuwazan nu, ne egkehimu heini he kandan te taman te taman.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ne ke si Jacob en maan te, “Ne ǥuntaan, sikan is dezuwa he anak nu he maama he kayi ianak te Ehipto te wazè e pa mekeuma zini, ne egkeragkes sikandan te kediey he menge anak. Kediey en si Efraim wey si Manase, iring te menge anak ku zaan si Reuben wey si Simeon. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ke zuen menge anak nu he wazè pa ianak ne kenikew mulà. Ke zuen menge kevuwazan dan ne elin ebpekepengevilin te menge azen he ebpuun ki Efraim wey ki Manase.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ne zutun migkaǥi pa maan sikandin te, “Egketenuzan ku is kebpatey te iney nu. Ebpuun key zengan diyà te Padan ne midhipanew key pehendiyà te tanà te Canaan. Hein uvey key en diyà te Efrat ne minatey sikandin, umbe ziyè ku zà sikandin ileveng te kilid te zalan pehendiyà te Efrat.” (Ne haazà is inged he Efrat ne iyan guntaan inged he Betlehem.) ");
INSERT INTO mbbOT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ne hein naahà ni Israel is dezuwa he anak ni Jose, mid-insà sikandin te, “Hentei heini?” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ne midtavak si Jose te, “Iyan en heini, amà, sikan is menge anak ku he imbeǥey kediey te Megbevayà.” Ne migkaǥi si Israel te, “Ipeuvey nu sikandan kayi su wey ku sikandan mepenubtuvazi.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Egkezeetan en dutun is menge mata ni Israel su utew en sikandin meǥurang, ne tenged dutun henduen te kenè en sikandin ebpekaahà, umbe impeuvey ni Jose is menge anak din diyà te ki Israel. Ne midhezekan wey migkepkepan sikandan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ne migkaǥi si Israel ziyà te ki Jose te, “Kunaan ku zengan ke kenè ku en sikew egkaahà, piru ǥuntaan intuǥut te Megbevayà he kenà iyan ke zà neehè ku, kekenà, elin daan is menge anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ne migkuwa ni Jose is menge anak din he midsekepu ni Israel, ne midlangkeb sikandin he iyan kedtahud din te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ne zutun impeuvey en maan ni Jose is menge anak din diyà te apù dan su wey mepenubtuvazi sikandan. Ne ziyà si Efraim te egkekewanan ni Jose, ne si Manase ziyà te egkeǥivang ni Jose. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ne si Israel, impedlambid din is menge velad din ne ingkawè din is kewanan he velad din ne indampè din te purù ni Efraim minsan pa te iyan si Efraim hazi. Ne is givang he velad din indampè din diyà te purù ni Manase he iyan sikan is kakey. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ne zutun mibpenubtuvazan din sikandan ke sikandin te, “Berakat he ebpenubtuvazan heini he menge vatà te Megbevayà he ed-ezapen te menge kepuun ku he si Abraham wey si Isaac, kes Megbevayà he mid-elima kedì te tivuuk he untung ku taman en guntaan. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ne verakat he tuvazi zaan sikandan duen te velinsuǥuen he midlibri kedì te langun he menge kezeetan. Berakat he kenà a melipati wey is menge kepuun ku he si Abraham wey si Isaac. Berakat he mebmahabet utew is menge kevuwazan dan dini te kelibutan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ne hein naahà ni Jose he indampè te amey zin is kewanan he velad din diyà te purù ni Efraim, wazè din haazà mesuati umbe migewezan din is kewanan he velad te amey zin su wey iyan din mezampà is purù ni Manase. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Migkaǥi si Jose te, “Amà, kenà haazà hustu. Su iyan heini kakey; kinahanglan he iyan nu sikandin edempaan te kewanan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Piru midtavak is amey zin te, “Uya, mama, netuenan ku. Is menge kevuwazan ni Manase egkehimu he egkevantug ded daan he menge etew. Piru egkelewanan sikandin ni Efraim su egkehimu he utew bentuǥan is menge kevuwazan din, ne egkehimu sikandan he mezakel he menge grupu te menge etew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Umbe midhimu zin he lavew si Efraim ki Manase. Ne zutun he andew, mibpenubtuvazan din sikandan he egkaǥi te, “Egemiten te menge Israilihanen is menge ngazan niw te kebpenuvadtuvad. He egkaǥi te, ‘Berakat he tuvazi kew te Megbevayà he iring ki Efraim wey ki Manase.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ne zutun migkaǥi si Israel ziyà te ki Jose te, “Meǥaan en is kebpatey ku, iyan, edumahan kew zed te Megbevayà, ne ibpeulì din ded keuzemà is menge kevuwazan tew ziyà te tanà he mid-ubpaan te menge kepuun tew. ");
INSERT INTO mbbOT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ne sikew Jose is ebpekepenunud te Shekem kenà is menge suled nu. Heeyan he lugar ne naaǥew ku te kebpekidtebek ku te menge Amorihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ne zutun mid-umew ni Jacob is menge anak din, ne ke sikandin te, “Pen-uvey kew kayi su wey ku sikiyu mekeǥiyi ke hengkey is egkeulaula keniyu keuzemà. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Sikiyu is menge anak ku, uvey kew wey pemineg kew te menge lalag ku te amey niw. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Sikew Reuben, is kinekekayan he anak ku, iyan ka nehuna he veǥas te kegkemaama ku. Edhuna is kegkeventuǥa wey kedtehuza kenikew te menge suled nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Piru iring ka te edìdì he wahig, su kenè nu egkeeǥen is kegkeiveg nu. Umbe mibpekidhilavet ka te esawa ku he suluǥuen, kenè ke en maan lavew te zuma. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Sikiyu Simeon wey Levi, ebpeked-iring kew su egemiten niw is gumaan niw te kebpendaagdaag. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Kenà a edtampu etawa edtelavuk te menge kevurunan niw su tenged te kegkepauk niw ne ebpenhimetayan niw is menge etew, ne emun meupiya is gehinawa niw ne ebpiangan niw is menge vaka. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Edrewakan ku sikiyu tenged te kegkepauk niw he utew subra. Ebpedsusuwayen ku is menge kevuwazan niw kayi te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sikew Juda, edeliǥen wey edtehuzen ka te menge suled nu. Ne egkezaag nu is menge kuntada nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iring ka te nati he erimaung he ebpekaahà te edewiyen din, ne edlikù sikandin diyà te elesè din, ne ziyà sikandin edleku. Ne wazà minsan hentei he ebpekesamuk kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Pedayun ka he edumala, Juda. Ebpuun te kevuwazan nu is egkehimu he menge sineriǥan. Umbe ebeǥey is menge nasyun te vuhis diyà te kenikew wey ebpevayèbayè dan kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ne utew uuzaran is tanè nu; umbe minsan pa ke idtagkes nu is asnu ziyà te ǥawed he paras he utew merapung, ne kenè din pa egkeamin te edtabtab tenged te kehabet din. Ne minsan pa ke ibpemìpì nu pa is binu ne kenè pa heini egkaamin. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Umbe te subra he ked-inum nu te vinu, ne ebmeziǥà is mata nu. Ne tenged daan te subra he ked-inum nu te ǥatas, ne ebmeputì is ngipen nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sikew Zebulun, ed-ubpè ka ziyà te veyvey te zaǥat. Ne is kenikew he lugar ne egkehimu he zungguan te menge untuzà. Ne is kenikew he tanà ne taman diyà te Sidon. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Sikew Isacar, iring ka te utew mezesen he asnu piru edleku ke zà diyà te ubpeey te menge kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ed-entusen nu is ked-uripena kenikew minsan pa ke ibpetiang ka te meveǥat wey ebpeǥesen ka he edterebahu, asal meupiya wey uuzaran is lugar he egkeubpaan nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Sikew Dan, ne metazeng he kukuman is ibeǥey nu ziyà te menge sakup nu he sevaha he tribu te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Egkeiring ka te uled diyà te zalan he ebpemengaǥat te paa te kudà, ne egkeulug is ed-untud dutun.” ");
INSERT INTO mbbOT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ne migkaǥi si Jacob te, “He Nengazen, edteǥad a te kedlibri nu.” ");
INSERT INTO mbbOT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ne impelaus ni Jacob is egkeǥiyen din, ke sikandin te, “Sikew Gad, edsurungen ka te grupu te menge tulisan, piru edel-asen nu sikandan dutun te kebpelaǥuy zan, ne ebelesan nu sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Sikew Asher, egkehimu ka he uuzaran. Ebpekeraǥun ka te menge keenen he para te menge dungganen he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Sikew Naftali, iring ka te impelayud he selazeng he utew memekempet is menge nati zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Sikew Jose, iring ka te meseǥila he asnu he ziyà te kilid te serebseb etawa ziyà te kelendiǥan. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Edumutan ka te menge mememanà. Ne ebpenaan ke zan tenged te kegkeuringer zan, ");
INSERT INTO mbbOT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","piru edsiguduwan nu zaan sikandan ebpenaa. Ne kenà egkeewaan te zesen is beklawan nu, tenged te tavang te Gemhanan he Megbevayè ku he ebantey wey eputà he vatu te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Iyan sikandin kes Mekeǥeǥehem he Megbevayà he ed-ezapen te menge kepuun nu he edtavang wey ebpenuvadtuvad kenikew. Ebeǥayan ke zin te uzan wey wahig diyà te serebseb. Ebeǥayan ke zin daan te mezakel he menge anak wey menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Guntaan, utew pa mezakel is menge ibpenuvadtuvad ku; lavew pa te meupiya he menge vuvungan he utew uuzaran. Berakat he mezawat nu heini he menge penuvadtuvad, Jose–iyan ka lavew te menge suled nu. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Sikew Benjamin, iring ka te zumezaas he asu, he maandew wey mezukilem is kebpenhimatey zin wey kegkaan.” ");
INSERT INTO mbbOT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iyan heini sikan is 12 he anak ni Jacob he menge tribu te Israel. Ne iyan haazà menge petizaan ni Jacob te kada sevaha kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ne zutun duen intelaan ni Jacob diyà te menge anak din, ke sikandin te, “Meǥaan e en ebpekaamur te menge kepuun ku he nemematey en. Ne emun egkehitavù en heini, ne ziyà a keniyu ileveng te surung duma te menge kepuun ku he ziyà te vevesukà ni Efron he Hitihanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Haazà he vevesukà ne ziyà te Macpela, he ebpekesinaru te inged he Mamre, he sakup te Canaan. Mibpemasa ni Abraham haazà is bevesukà diyà te ki Efron he Hitihanen su wey zuen penlevengè din. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Diyà ileveng si Abraham wey is esawa zin he si Sara, ne ziyà daan ileveng is amey ku he si Isaac wey is iney ku he si Rebeka, ne ziyè ku zaan ileveng si Lea. ");
INSERT INTO mbbOT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Iyan haazà sikan is surung wey vevesukà he mibpemasa zengan diyà te menge Hitihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ne hein nepasad ni Jacob is menge idtelaan din te menge anak din, mid-ayun sikandin medhizeǥà diyà te hizeǥaan ne minatey sikandin. Ne nekaamur sikandin te menge kepuun din he nemematey en. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ne zutun midlingketawan ni Jose is amey zin ne midsineǥawan din wey midhezekan din. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ne midsuǥù din dutun is menge perebelsamar he belsemara zan is lawa te amey zin. Umbe mibelsamar zan dutun is lawa ni Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ne 40 he andew is keluǥayad te kebelsemara zan su iyan haazà hustu he keluǥayad te kebelsemar te minatey. Ne 70 he andew is kedlalew te menge Ehiptohanen tenged ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ne hein netapus haazà is timpu te kedlalew zan, midlelaǥan ni Jose is menge upisyal te hadì te Ehipto, ke sikandin te, “Emun egkehimu ne lelaǥi niw is hadì ");
INSERT INTO mbbOT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","he tuǥuti e zin te kedleveng te amey ku ziyà te Canaan. Su zuen intelaan kediey te amey ku, ne impepenangdù e zin he ke sikandin te, ‘Emun ebpatey a kinahanglan he ziyà a kenikew ileveng te penlevengà he zaan he mid-andam ku ziyà te tanà he Canaan.’ Ne emun egkepasad is kedlevenga kandin, ne edlikù e zed dini.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ne hein netuenan duen te hadì, ne midtavak sikandin te, “Tumana nu is impenangdù nu ziyà te amey nu. Ne ǥenat kad ne ileveng nu en sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ne zutun migenat si Jose, ne miduma kandin is mezakel he menge upisyal te hadì te Ehipto, wey is menge lavew he menge sineriǥan din wey is langun he menge ebmeǥurangen te tivuuk he tanà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ne miduma zaan is langun he menge sakup ni Jose, is menge suled din wey is menge sakup te amey zin. Ne iyan dà nesamà diyà te Goshen is menge anak dan wey is menge uyaǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Duen daan mibpemen-untud te kudà wey kerwahi he mibpemenduma, ne utew zan mezakel is midhendiyà. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ne hein nekeuma sikandan diyà te ǥunasà diyà te Atad he uvey te Wahig he Jordan, ne midlalew sikandan para ki Jacob, ne utew subra is kedlelendag dan. Ne midlalew si Jose seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ne is menge tig-Canaan he meǥinged dutun, hein neehè dan is ebpemenlelendag dutun te gunasà diyà te Atad, ne migkaǥi zan te, “Utew neseeng is menge Ehiptohanen.” Ne tenged dutun haazà is inged he uvey te Wahig he Jordan ne migngezanan te Abel Mizraim, he ke và dà egkeǥiya, midlelendaǥan te menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Midtuman te menge anak ni Jacob is intelaan din kandan. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ne mid-uwit dan is lawa zin diyà te Canaan ne inleveng dan diyà te surung he ziyà te vevesukà te Macpela, diyà te edsilaan te Mamre. Heini he vevesukà mibpemasa ni Abraham diyà te ki Efron he Hitihanen, su ebeelan din he penlevengà. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ne si Jose, hein nepasad en haazà is kedlevenga te amey zin, mid-ulì sikandin diyà te Ehipto zuma te menge suled din wey is langun he menge etew he miduma kandin te kedleveng te amey zin. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ne haazà is menge suled ni Jose, dutun te minatey en is amey zan, pesikaǥi zan te, “Kela ke ebelesan kiw en ni Jose tenged te mezaat he mid-ulaula tew zengan kandin.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ne tenged dutun duen surat he impeuwit dan diyà te ki Jose he edhenduen te, “Is amey tew, te wazè pa sikandin mebpatey intelaan din kenami ");
INSERT INTO mbbOT_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","he megkaǥi key ziyan te kenikew te egkeǥiyen din kenikew he iyan is: ‘Edhengyuan ku sikew, mama, he peseyluwa nu is salà wey mezaat he mid-ulaula kenikew te menge kakey nu su mibpesipelahan ke zan,’ ke sikandin. Ne sikami zaan is menge suluǥuen te Megbevayà te amey tew, edhengyuan dey sikew he peseyluwa nu is salè dey kenikew.” Ne hein nekeuma heini is surat diyà te ki Jose, mibpenluluhaan sikandin su nerurunù. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ne zutun nemekeuma is menge suled din ne midlangkeb dan diyà te etuvangan din. Ke sikandan te, “Menge uripen key en kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Piru midtavak si Jose ziyà te kandan te, “Kenè kew mahandek. Kenè ku sikiyu ebelesan su kenà egkehimu he iyan a ed-ilis te Megbevayà! ");
INSERT INTO mbbOT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Su minsan pa te mezaat is tuyù niw kediey, mibpengelinteuwan te Megbevayà he meupiya is pangkus din. Su impelavew e zin su wey kiw is mezakel melibri ne kenà meumes. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Umbe kenè kew mahandek su ed-elimahan ku sikiyu wey is menge anak niw.” Iyan heini menge lalag din kandan he menayù su wey mekesarig dan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ne si Jose wey is langun he menge sakup wey kevuwazan te amey zin, diyè dan med-ubpà te Ehipto. Is keluǥayad te untung ni Jose 110 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Neseutan pa sikandin te menge apù din te veul he menge kevuwazan ni Efraim. Ne neseutan pa zaan sikandin te menge apù din he menge anak ni Makir he anak ni Manase. ");
INSERT INTO mbbOT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Duen timpu he migkaǥi si Jose ziyà te menge suled din te, “Meǥaan en is kebpatey ku, piru kenà egkehimu he kenè kew en edtevangan te Megbevayà. Ne ibpaawè kew zin ded kayi he tanà, ne ibpeulì kew zin diyà te tanà he impesarig din te menge kepuun tew he si Abraham, si Isaac, wey si Jacob.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ne zutun, impepenangdù ni Jose is menge Israilihanen. Ke sikandin te, “Ipenangdù niw he emun ibpeawè kew en te Megbevayà kayi he lugar ne uwita niw is menge tulan ku.” ");
INSERT INTO mbbOT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ne hein 110 en is penuiǥen ni Jose ne minatey sikandin. Mibelsamar zan is lawa zin ne insavuk dan diyà te lungun diyà te Ehipto.");
INSERT INTO mbbOT_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iyan heini menge ngazan te menge maama he anak ni Jacob he miduma kandin diyà te Ehipto, duma te menge pemilya zan: ");
INSERT INTO mbbOT_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Si Reuben, si Simeon, si Levi, si Juda, ");
INSERT INTO mbbOT_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","si Isacar, si Zebulun, si Benjamin, ");
INSERT INTO mbbOT_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","si Dan, si Naftali, si Gad, wey si Asher. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ne 70 langun is kevuwazan ni Jacob he nemenduma kandin diyà te Ehipto, ragkes en si Jose he zaan en he ziyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Neuma is timpu he minatey si Jose wey is langun he menge suled din. Midlavey haazà he lapis te kevuwazan, ");
INSERT INTO mbbOT_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","piru meǥaan dà nevuwad is menge kevuwazan dan, ne utew en subra is kahabet dan, umbe nekeeneb en sikandan dutun te tanà te Ehipto he neubpaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ne zuen beǥu he nehimu he hadì diyà te Ehipto he wazà mesayud mehitenged ki Jose. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ne migkeǥiyan din is menge sakup din te, “Ahaa niw man! Ebpemiligru kiw su utew en subra is kahabet te menge kevuwazan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kinahanglan he zuen tew paaǥi he para kenà sikandan medsigudu mebmahabet, su wey zan kenà mekesukul kenitew pinaaǥi te kedtampu te menge etew he ebpekigira kenitew, su wey zan kenà mekaawà kayì te kenitew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Umbe, duen menge upisyal he midseriǥan te kedlisliseza te menge kevuwazan ni Israel pinaaǥi te kebpeterebehuwa kandan te utew subra, ne zutun netukud dan is menge inged he iyan is Pitom wey Rameses he zutun is menge budiga te hadì te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Iyan, dutun te utew sikandan edèdaaǥa, nasì en sikandan mebmahabet ne mid-iseg en mebmeluag is egkeubpaan dan, ne tenged kayi egkahandek kandan is menge tig-Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Tenged kayi, impeiseg dan pa is kebpesipelahi zan te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wazè dan kegkehizu te menge Israilihanen. Utew zan midlisedlised sikandan pinaaǥi te kebpeterebehuwa kandan te kebaal te menge brik wey kedsimintu. Ne midrasey zan sikandan te kebpeterebehuwa zan diyà te pemuleey zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ne migkeǥiyan duen te hadì diyà te Ehipto si Shifra wey si Pua he menge Hebriyuhanen he mengunguyamu te, ");
INSERT INTO mbbOT_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Emun ebpenguyemuwan niw is ed-anak he Hebriyuhanen, ne himetayi niw emun maama, iyan, emun bahi ne kenè niw en himetayi.” ");
INSERT INTO mbbOT_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ne ǥeina te egkahandek te Megbevayà haazà is menge mengunguyamu, wazè dan tumana haazà is migkaǥi kandan duen te hadì; wazè dan himetayi is menge vatà he maama he neuyemuwan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ne impetawag duen te hadì diyà te Ehipto sikan is menge mengunguyamu ne migkeǥiyan din te, “Maan is midsupak niw is insuǥù ku keniyu? Maan is wazè niw penhimetayi is menge vatà he maama he neuyemuwan niw?” ");
INSERT INTO mbbOT_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ne midtavak dan is hadì te Ehipto he ke sikandan te, “Is menge vahi he Hebriyuhanen ne kenà iring te menge vahi he Ehiptohanen; lelemuwan sikandan umbe edlusazan dan en te kenè pa ebpekeuma is mengunguyamu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mibpurungan te Megbevayà haazà is menge mengunguyamu. Ne mid-iseg pa mebmahabet haazà is menge kevuwazan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ne ǥeina te midtahud dutun te menge mengunguyamu is Megbevayà, mibeǥayan din sikandan te keugelingen dan he menge pemilya. ");
INSERT INTO mbbOT_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ne midsuǥù te hadì te Ehipto is langun he sakup din he itimbag dan diyà te Wahig he Nilo is langun he menge maama he veǥu he id-anak te menge Israilihanen, iyan, kenè dan mulà idtimbag emun bahi. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ne zuen maama he kevuwazan ni Levi he nekeesawa te vahi he kevuwazan ded daan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ne mibmeǥingey haazà is esawa zin ne mid-anak te maama. Ne hein naahà dutun te vahi he meupiya he vatà haazà is in-anak din, in-eles din seled te tetelu he vulan. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Iyan, hein kenè din en egkehimu te ed-eles haazà is batà, migkuwa sikandin te pepirus he teleǥuey ne mibpinsi zin te alkitran su wey kena rehevi te wahig. Ne zutun din itaǥù haazà is batà ne insavuk din diyà te vereesen he veyvey te Wahig he Nilo. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ne is bahi he kakey zutun te vatà, edhithitindeg diyà te malù meziyù su ed-ahaan din ke egkemenumenu haazà is hazi zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ne midhendutun te Wahig he Nilo haazà is bahi he anak te hadì te Ehipto su ebpemeziǥù. Ne hein ebpemenhiphipanew zuen te veyvey is menge suluǥuen din, neehè din sikan is teleǥuey he insavuk duen te vereesen dutun te ebpemeziǥù en sikandin, ne impekuwa zin haazà te vahi he uripen din. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mibpuwasan din haazà ne neehè din sikan is batà. Mid-eerang haazà ne nehizuwan din. Ke sikandin te, “Sevaha heini te menge anak te Hebriyuhanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ne mid-insaan duen te kakey te vatà haazà is anak te hadì te Ehipto, ke sikandin te, “Egkehimu ve ke egkuwaan ku sikew te vahi he Hebriyuhanen su wey zin meelimahi kenikew heeyan is batà?” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Uya,” ke sikandin. Ne zutun mibeyaan dutun te vahi is iney zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ne migkaǥi ziyà te kandin haazà is anak te hadì te Ehipto te, “Uwita nu heini is batà ne ipesusu nu para kediey, ne ebeyazan ku sikew.” Umbe migkuwa zutun te vahi haazà is batà ne mid-uyamu zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ne hein nelutas en haazà is batà, ne inhated din en diyà te anak te hadì te Ehipto ne haazà mid-isip he anak duen te anak te hadì. Migngezanan din te Moises su geina te ziyè din mekuwa te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ne sevaha he andew, hein dekelè en si Moises, midhendiyà sikandin te lugar he zutun is menge zuma zin he menge Hebriyuhanen, ne neehè din is kemereǥenan dan. Neehè din is sevaha he Ehiptohanen he mibuǥel zin is sevaha he Hebriyuhanen he kezuzumahi ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nenlangulangu sikandin ke zuen be ebpekaahà; ne hein wazà duma he etew he neehè din, midhimetayan din sikan is tig-Ehipto ne mibumbunan din te pantad. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ne hein sunud he andew, mid-uman medhipanew sikandin ne neehè din is dezuwa he Hebriyuhanen he ebpetebekà. Ne migkeǥiyan din sikan is mibaal te mezaat te, “Maan is ebpesekitan nu heeyan is duma nu he Hebriyuhanen?” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ne migkaǥi haazà is etew te, “Hentei is mibeǥey kenikew te ketenged te kedatùdatù kayi te kenami? Edhimetayan e ve kenikew iring te kedhimetayi nu zuen te tig-Ehipto?” Ne nahandek si Moises te kegkezineǥa zin dutun su netuenan din he zuen bes netau zuen te mibeelan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Hein nezineg te hadì te Ehipto haazà is mibeelan ni Moises, ebpen-ahaan din te paaǥi he mepatey zin si Moises, piru mibpelaǥuy si Moises diyà te Midian ne zutun med-ubpà. Ne zutun te kebpekeuma zin, mibpinuu sikandin diyà te uvey te kalut. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ne zutun, is pitu he anak he vahi te memumuhat diyà te Midian, midhendiyè dan te kalut su edsekezu te ibpeinum te menge uyaǥen te amey zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ne nemekeuma is duma he ebpemen-elima te kerehidu ne edsegseǥen dan haazà is menge vahi wey is menge uyaǥen dan, iyan, midtevangan sikandan ni Moises, ne impeinum din sikan is menge kerehidu he ed-elimahan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ne hein nekeulì dan en diyà te amey zan he si Reuel, mid-insà si Reuel, ke sikandin te, “Maan is meǥaan kew zà nekeulì?” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ne midtavak sikandan te, “Duen tig-Ehipto he mid-uǥup kenami para kenè key melupiglupig duen te zuma he menge ed-lima te uyaǥen. Mibpenekezuwan key zin pa wey impemeinum din is menge uyaǥen tew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ne migkeǥiyan din haazà is menge anak din te, “Hendei sikandin? Maan is wazè niw zumaha? Ipehendini niw su wey mekekaan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ne mibpezumazuma si Moises ne zutun en med-ubpà te kandan, ne impeesawa kandin ni Reuel is anak din he si Zipora. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ne mid-anak si Zipora te maama, ne haazà migngezanan ni Moises te Gershom, su ke sikandin te, “Lumelengyawà a kayi he inged.” ");
INSERT INTO mbbOT_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ne hein neuǥet en, mibpatey en sikan is hadì te Ehipto. Ne is menge kevuwazan ni Israel kemulu ǥihapun is kegkengereǥeni zan tenged te ked-uripena kandan. Ne nengemuyù sikandan wey zan metevangi, ne nekeuma haazà diyà te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nezineg te Megbevayà is dag-es dan, ne netenuzan din is paaǥi te kebpekid-uyun din diyà te ki Abraham, ki Isaac, wey ki Jacob. ");
INSERT INTO mbbOT_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Naahà sikandan te Megbevayà ne nehizuwan din sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ne sevaha he andew, ebantey si Moises te menge uyaǥen te enuǥang din he si Jetro he memumuhat diyà te Midian. Ne midtundan ni Moises haazà is menge uyaǥen pehendiyà te hunaan te sibsivayan ne nekeuma zan diyà te Horeb, kes buntud te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ne zutun mibpaahà kandin is belinsuǥuen te Nengazen pinaaǥi te egkeregreg he hapuy ziyà te teliwazà te dezeisey he kayu. Naahà ni Moises haazà ne minsan pa te egkeregreg haazà, iyan, kenà egketutung. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ne neisip din is malù din haazà ed-uvayi su wey zin mesusi haazà is sikan din pa maahà su neinuinu sikandin ke maan is kenà egketutung haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ne hein naahà sikandin te Nengazen is malù ed-uvey te kedsusi, nezineg din is ked-umew te Megbevayà he ebpuun dutun te teliwazà te egkeregreg he egkaǥi te, “Moises! Moises!” Ne midtavak si Moises te, “Heini e zed.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Migkaǥi is Megbevayà te, “Kenè ke en utew uvey, pul-uta nu is sandalyas nu su segradu heini is tanà he nehitindeǥan nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ne mid-uman sikandin megkaǥi te, “Iyan a sikan is Megbevayà he ed-ezapen te menge kepuun nu, ed-ezapen a ni Abraham, ed-ezapen a ni Isaac wey ed-ezapen a ni Jacob.” Ne zutun midtembunan ni Moises is dagwey zin su egkahandek he ed-ahà te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Migkaǥi is Nengazen te, “Neehè ku is kemereǥenan te menge etew ku ziyà te Ehipto. Nezineg ku is kebuyù dan te tavang tenged te kebpesipelahi kandan te menge edumala kandan te edterebahu, ne edtevangan ku su egkehizuwan ku sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ne umbe mibulus a su edlibriyen ku sikandan te menge pesipala kandan te menge tig-Ehipto, wey ibpaawè ku sikandan diyà te Ehipto ne ziyè ku sikandan ibpeubpà te tanà he meupiya wey meluag, tanà he egkeerubasa he ebpuunan te edtudà he ǥatas wey teneb he iyan ed-ubpaan te menge Canaanhen, Hitihanen, Amorihanen, Pirisihanen, Hivihanen wey Jebusihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nezineg ku is pengemuyù te menge kevuwazan ni Israel, wey neehè ku is paaǥi te kedèdaaǥa kandan te menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Umbe, edsuǥuen ku sikew ǥuntaan pehendiyà te hadì te Ehipto su wey nu mepenguluwi is menge etew ku he Israilihanen te kegawas dan puun te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Iyan, migkaǥi si Moises diyà te Megbevayà te, “Siak, utew minus is pid-etawan ku; kenà a zait he edhendiyà te hadì wey ebpengulu te menge Israilihanen te kegawas puun te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ne migkaǥi is Megbevayà te, “Eduma a kenikew. Ne is egkehimu he singyal he iyan a midsuǥù kenikew iyan is: Emun igkepeǥawas nu en sikandan puun te Ehipto, ne kayi a keniyu ed-ezapa te vuvungan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ne migkaǥi en maan si Moises diyà te Megbevayà te, “Emun edhendiyà a te menge Israilihanen ne egkeǥiyan ku sikandan te, ‘Midsuǥù a zini te keniyu te Megbevayà he ed-ezapen te menge kepuun niw,’ kela ke egkaǥi sikandan te, ‘Hentei is ngazan din?’ Emun iyan haazà, hengkey ve is egkeǥiyen ku ziyà te kandan?” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ne migkaǥi is Megbevayà diyà te ki Moises te, “Iyan a is Megbevayà he kenà egkahalin. Keǥiyi nu is menge Israilihanen he iyan a is Megbevayà he kenà egkahalin midsuǥù kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Migkaǥi zaan is Megbevayà diyà te ki Moises te, “Keǥiyi nu is menge Israilihanen: ‘Is Nengazen, is Megbevayà he ed-ezapen te menge kebpuun niw he si Abraham, si Isaac, wey si Jacob ne iyan midsuǥù kenikew.’ Kilelaà niw is ngazan ku he Nengazen te wazà pidtemanan. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Genat ke en ne tiǥuma nu is menge edumala te menge kevuwazan ni Israel ne keǥiyi nu sikandan te, ‘Is Nengazen, is Megbevayà he ed-ezapen te menge kebpuun niw he si Abraham, si Isaac, wey si Jacob mibpaahà kediey, ne migkeǥiyan e zin te: Ebpurungan kew zin ebentayi, ne egkeehè din is ed-ulaula keniyu te menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nenangdù sikandin he ibpeǥawas kew zin puun te menge kemereǥenan he nengeseǥazan niw zini te Ehipto, ne ziyè kew zin ed-uwita te tanà te menge Canaanhen, menge Hitihanen, menge Amorihanen, menge Pirisihanen, menge Hivihanen wey menge Jebusihanen–tanà he egkeerubasa he ebpunan te edtudà he ǥatas wey teneb.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ne ebpemineg kenikew is menge edumala te menge Israilihanen. Ne zumaha nu sikandan diyà te hadì te Ehipto ne keǥiyi niw sikandin te, ‘Is Nengazen, is Megbevayà he ed-ezapen te menge Hebriyuhanen, nekidhinguma kenami. Umbe tuǥuti key te kedhipanew seled te tetelu he andew su edhendiyè key te sibsivayan su ebpemuhaten dey is Nengazen he Megbevayè dey.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Iyan, netuenan ku he kenè kew edtuǥutan duen te hadì te Ehipto emun wazà ebpeǥes kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ne tenged te kenè din kedtuǥut ibayew ku is belad ku te kebpigada te menge Ehiptohanen pinaaǥi te menge egkengein-inuwan he ibpezayag ku ziyà te kandan, ne emun egkeuleule en heini ne edtuǥutan kew zin en human te kegenat. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ne ebpengelinteuwan ku he megkelelaǥan is menge Ehiptohanen diyà te keniyu su para zuen niw egkeuwit dutun te kegenat niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Dutun he timpu, is kada vahi keniyu, mebuyù diyà te Ehiptohanen he siringan din he vahi wey meǥeliyug dutun te siringan din te menge elahas he pelata wey vulawan wey manggad he igkepevisti niw te menge anak niw. Pinaaǥi kayi egkepenevanan niw is menge Ehiptohanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ne midtavak si Moises te, “Hengkey is ebeelan ku emun kenà sikandan edtuu kediey etawa kenà sikandan ebpemineg kediey? Su và dan dà egkaǥi te, kenà tutuu he mibpaahà kenikew is Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ne migkaǥi is Nengazen diyà te kandin te, “Hengkey heeyan is egewezan nu?” Ne midtavak sikandin te, “Tuked.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ne migkaǥi is Nengazen te, “Itimbag nu ziyà te tanà.” Ne intimbag ni Moises haazà diyà te tanà ne mibaluy he uled, ne zutun nepeleǥuyan din tenged te kegkahandek din. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ne migkaǥi is Nengazen diyà te kandin te, “Kuwaa nu, ne ziyè nu ǥewazi te ikug.” Umbe migkuwa ni Moises haazà is uled ne te kegkegewezi zin dutun mibaluy zed he tuked. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ne migkaǥi is Nengazen te, “Pinaaǥi keniyan he singyal ebpeketuu zan he, is Nengazen, he Megbevayà he ed-ezapen te menge kepuun dan he si Abraham, si Isaac, wey si Jacob, iyan mibpaahà kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ne mid-uman megkaǥi is Nengazen te, “Isuksuk nu is belad nu ziyà te kumbalè nu.” Midtuman haazà ni Moises, ne hein in-awè din en is belad din, ne utew heini mibmeputì tenged te midletunan heini te melimezang he zaru te lundis. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ne migkaǥi is Nengazen te, “Iuman nu isuksuk diyà te kumbalè nu.” Ne inlikù ni Moises isuksuk is belad din diyà te kumbalè din, ne hein in-awè din ne iring ded te zuma he vahin te lawa zin su neulian en. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ne migkaǥi is Nengazen te, “Emun kenè ke zan edtuuwan etawa kenè ke zan edseǥipaan pinaaǥi zuen te nehuna he singyal, ne egkehimu he edtuuwan ke zan pinaaǥi keniyan te ikezuwa. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Iyan, emun kenè ke zan pa ebpemineǥen pinaaǥi kayi te zezuwa he singyal, kuwa ka te wahig diyà te Wahig he Nilo ne ivusbus nu ziyà te memaza he tanà, ne egkehimu heini he lengesa.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ne migkaǥi si Moises diyà te Nengazen te, “He Nengazen, wazè ku pa meseǥazi is mibmetau a he ebpengaǥikaǥi puun pa zengan taman en guntaan te kebpekidlalag nu kedì te suluǥuen nu. Kenà a metau he epengaǥikaǥi wey ngulit a zaan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ne migkaǥi is Nengazen diyà te kandin te, “Hentei ves is mibaal te vèbà te etew? Hentei is midhimu kandin he vengel etawa emew? Hentei is midhimu kandin he ebpekaahà etawa midhimu kandin he lakap? Kenè be iyan a, is Nengazen? ");
INSERT INTO mbbOT_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Umbe, genat ke en ne ed-uǥupan ku sikew te kegkaǥi wey ibpenurù ku kenikew ke hengkey is egkeǥiyen nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Piru migkaǥi en maan si Moises te, “He Nengazen, iyan nu keniyan ipevaal is sengeeetew en.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Dutun nepeukan si Moises te Nengazen ne migkaǥi te, “Iyan nasì is kakey nu he si Aaron he kevuwazan daan ni Levi. Netuenan ku he metau mulà sikandin he ebpengaǥikaǥi. Guntaan kemulu en sikandin edhipanew te kedsinuǥung kenikew, ne ibmeupiya te ǥehinawa zin is kegkaahaa zin kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Lelaǥi nu sikandin, ne ipenurù nu kandin is egkeǥiyen din. Ne ed-uǥupan ku sikiyu is dezuwa te kegkaǥi, wey ibpenurù ku keniyu is ereg he ebeelan niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Is idlalag nu pezem diyà te menge etew ne si Aaron is egkaǥi. Penurua nu sikandin ke hengkey is idlalag din; kuwinta henduen te iyan ka Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Iyan, uwita nu heeyan is tuked he egewezan nu su pinaaǥi keniyan ebpekehimu ka te menge singyal.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ne mid-ulì si Moises diyà te enuǥang din he si Jetro ne migkeǥiyan din te, “Tuǥuti a kenikew te kedlikù diyà te menge kezumahan ku ziyà te Ehipto te ked-ahà ke menge uuyag ded be sikandan.” Ne midtavak si Jetro te, “Uya, egkehimu he egenat ka, ne verakat he meupiya is hipanew nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ne zutun he timpu te kemulu pa si Moises diyà te Midian ne migkeǥiyan sikandin te Nengazen te, “Likù ke en diyà te Ehipto su pudu en minatey sikan is menge etew he egkesuat he edhimatey kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ne migkuwa ni Moises is esawa zin wey sikan is menge anak din he pudu maama, ne impeuntud din sikandan te asnu su egenat dan en pehendiyà te Ehipto. Ne mid-uwit daan ni Moises sikan is tuked te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Migkaǥi is Nengazen diyà te ki Moises te, “Emun diyè ke en te Ehipto kinahanglan he ipeehè nu te hadì te Ehipto is langun he menge singyal he impeehè ku kenikew. Imbeǥey ku en kenikew is gehem te ked-ul-ulaha zuen. Ne zutun ebpengelinteuwan ku he kenà haazà med-uteng diyà te ǥehinawa zin su wey kew zin kenà metuǥuti te ked-awà puun te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ne zutun keǥiyi nu haazà is hadì te, ‘Iyan heini lalag te Nengazen diyà te kenikew: Ed-isipen ku is menge Israilihanen he iring te kakey he anak ku, ");
INSERT INTO mbbOT_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","umbe, migkeǥiyan ku sikew he tuǥuti nu he mekeǥenat heeyan is anak ku su wey mekaazap kedì. Iyan, wazè nu tuǥuti he mekeǥenat, umbe edhimetayan ku is kakey he anak nu he maama!’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dutun te kedhipanew eni Moises wey is pemilya zin, midhulavung dan diyà te himelayà. Midhinguma si Moises te Nengazen su edhimetayan din pezem. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Piru migkuwa si Zipora te meǥarang he vatu ne midsirkunsidar zin is anak din, ne is lundis he nekuwa zin, indazas din diyà te sineruwan ni Moises. Ne migkaǥi si Zipora te, “Tutuu iyan he esawa ku sikew tenged te lengesa.” (Nekaǥi ni Zipora heini he iyan ibpesavut is kegkesirkunsidara.) Umbe wazà himetayi te Nengazen si Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Migkaǥi is Nengazen diyà te ki Aaron te, “Hipanew ka ne sinuǥunga nu si Moises diyà te sibsivayan.” Umbe midsinuǥung din si Moises diyà te Buntud te Megbevayà ne midhezekan din si Moises tuus te kegkeǥalew zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ne midtudtul ni Moises diyà te ki Aaron is minsan hengkey he ibpekaǥi kandin te Nengazen, wey is langun he menge singyal he ebpeveelan kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Umbe midhendiyè dan is dezuwa, ne midtiǥum dan is langun he ebpemendumala te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ne migkaǥi ni Aaron diyà te kandan is langun he migkaǥi te Nengazen diyà te ki Moises. Wey impaahà ni Moises te menge etew sikan is menge singyal, ");
INSERT INTO mbbOT_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ne midtuu sikandan. Ne hein netuenan dan he igkeseeng sikandan te Nengazen wey naahà te Nengazen is kemeresayan dan, midluhud sikandan te ked-azap kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ne midhendiyà si Moises wey si Aaron te hadì te Ehipto, ne migkeǥiyan dan te, “Iyan heini migkaǥi te Nengazen he Megbevayà te Israel: ‘Tuǥuti nu he mekeǥenat is menge etew ku, su wey zan mekesilibra te pista para kedì diyà te sibsivayan.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ne migkaǥi is hadì te, “Hentei is Nengazen he ebpepezumdumahan niw kedì is lalag din he tuǥuti ku is menge kevuwazan ni Israel te kegenat? Wazè ku mekilala is Nengazen ne kenè ku edtuǥutan is menge kevuwazan ni Israel te kegenat.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ne midtavak si Moises wey si Aaron te, “Nekidhinguma kenami is Megbevayà he ed-ezapen dey te menge Hebriyuhanen. Ne tuǥuti key kenikew te kedhipanew seled te tetelu he andew su edhendiyè key te sibsivayan su ebpemuhaten dey is Nengazen he iyan Megbevayè dey, su emun kenè dey heini ebeelan, ne ebpenhimetayan key zin pinaaǥi te zaru etawa tebek.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Iyan, migkaǥi haazà is hadì te Ehipto te, “Moises wey Aaron, maan is ibpeengked niw is menge etew te terebahu zan? Likui niw is keniyu he menge terebahu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Migkaǥi med-uman sikandin te, “Kenà ereg he ibpeengked niw te kedterebahu is menge etew su utew sikandan mahabet.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ne zutun daan he andew, migkeǥiyan te hadì te Ehipto is menge Ehiptohanen he edumala te ebpemenerebahu he menge Israilihanen wey is impepengulu zin kandan he menge Israilihanen te: ");
INSERT INTO mbbOT_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kenè niw en human beǥayi is menge etew te reǥami he egkaǥamit dan te kebpemaal te menge brik, iyan en human sikandan ibpepen-ahà te reǥami he egkeǥamit dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Piru is kahabet te menge brik he ebpeveelan niw kandan hein iyan kew pa ebeǥey kandan te reǥami, ne iyan ded kahabet te menge brik he ebpeveelan niw kandan minsan pa te kenè niw en sikandan ebeǥayan te reǥami. Ebpemepepeǥul sikandan, pegelitan dan dà is kedhangyù dan he ipeǥenat sikandan su wey zan mepemuhat is Megbevayè dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ipeiseg niw is kereǥen te terebahu zan su para mekepenigudu sikandan he edterebahu su para wazè dan en timpu te kebpemineg te tarù he ebpengeǥiyen diyà te kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ne zutun sikan is menge upisyal te kebantey te ebpemenerebahu wey sikan is menge pengulu zan, midhendiyà te kandan, ne migkaǥi ziyà te kandan te, “Iyan suǥù te hadì is kenè kew en kun human ebeǥayan te reǥami. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Iyan kew en kun pen-ahà ke hendei kew ebpeketuredu, iyan, kenà edterinan is kezakel te ebpeveelan keniyu he menge brik.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Umbe, nekeeneb sikandan diyà te tivuuk he Ehipto is ebpenguwa te tued te reǥami he iyan egemiten dan he ilis te reǥami. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Is menge upisyal he ebantey kandan edsigudu en kandan ebmandar he egkaǥi te, “Kinahanglan he edhimesazen niw te kada andew is iring kahabet te brik he ebpeveelan keniyu hein ebeǥayan kew pa te reǥami.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Mibpenlagkut is menge Israilihanen he mibpilì te menge upisyal te hadì he ibpepengulu te menge zuma zan, su maan kun is wazè dan mehimu zutun he andew wey te midlavey he andew is iring kahabet duen te nehuna. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ne midhendiyà sikandan te hadì ne ke sikandan te, “Maan is ed-iringen key kenikew kayi is menge suluǥuen nu? ");
INSERT INTO mbbOT_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ebpenlegkuten key, piru kenà kenami he sayep is kenè dey kebpekehimu te ebpeveelan kenami, su edteǥelen key keniyu te kebaal te menge brik he iring kahabet duen te nehuna, iyan, wazè key veǥayi te reǥami.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ne migkaǥi is hadì te Ehipto te, “Ebpemepepeǥul kew, umbe layun kew edhangyù he tuǥuti kew te kegenat su ebpemuhaten niw is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Terebahu kew en! Kenè kew ebeǥayan te reǥami piru kinahanglan he ebeelan niw ke sengemenu kahabet is brik he ebpeveelan keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ne zutun te kegkeǥiyi kandan he kenà edterinan is kahabet te menge brik he ebpeveelan kandan te kada andew neisip dan he mereǥen en is kebpekesavuk dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ne hein mid-awè dan en diyà te hadì, neehè dan si Moises wey si Aaron is edtaǥad kandan, ");
INSERT INTO mbbOT_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ne migkeǥiyan dan haazà is dezuwa te, “Berakat he siluti kew te Nengazen, su keniyu he vaal is utew ingkeepesi kenami te hadì wey te menge upisyal zin. Is mibeelan niw ne iyan egkehimu he hinungdan te kedhimetayi zan kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ne mid-uman mebpekidlalag si Moises te Nengazen ke sikandin te, “He Nengazen, maan is ed-uwitan nu te samuk heini is menge etew? Iyan be insuǥua nu kediey is kebeǥey kandan te samuk? ");
INSERT INTO mbbOT_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Su puun dà te kedhendiyè ku te hadì te kegkaǥi ziyà te kandin te menge lalag he ibpekaǥi nu, midlisedlised din en heini is menge etew, ne wazè nu sikandan libriya.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ne migkaǥi is Nengazen diyà te ki Moises te, “Egkeehè nu en human is ed-ul-ulahan ku ziyà te hadì te Ehipto. Pinaaǥi te ǥehem he ibpeehè ku, edtuǥut sikandin he mekeǥenat kew puun te nasyun din. Ne egketeǥel sikandin te kebpeǥenat keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Migkaǥi zaan is Megbevayà diyà te ki Moises te, “Iyan a Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Hein mibpaahà a ki Abraham, ki Isaac, wey ki Jacob, nesavut dan he iyan a is Mekeǥeǥehem he Megbevayà. Iyan, wazà a mekepekilala kandan pinaaǥi te ngazan ku he Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Midhimu ku is kebpekid-uyun ku kandan, he ibeǥey ku kandan is tanà te Canaan he iyan neubpaan dan dutun te kegkelumelengyawè dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ne ǥuntaan nezineg ku en is dag-es te menge Israilihanen he ed-uripenen te menge Ehiptohanen, ne netenuzan ku en haazà is kebpekid-uyun ku kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Umbe, keǥiyi nu is menge Israilihanen: ‘Iyan a Nengazen. Ne ibpeǥawas ku sikiyu te kegkeuripena keniyu te menge Ehiptohanen. Pinaaǥi te ǥehem ku, ebpurungan ku edsiluti is menge Ehiptohanen, ne edlibriyen ku sikiyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ed-isipen ku sikiyu he menge etew ku ne iyan a egkehimu he Megbevayè niw. Ne egketuenan niw he siak is Nengazen he Megbevayè niw, iyan a mibpeǥawas keniyu puun te kegkeuripena keniyu te menge tig-Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ne ziyè ku sikiyu ed-uwita te tanà he insaad ku he ibeǥey ku ziyà te ki Abraham, ki Isaac, wey ki Jacob. Ibeǥey ku haazà keniyu, ne egkaangken niw en. Iyan a sikan is Nengazen.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ne midtultul haazà ni Moises diyà te menge Israilihanen, iyan, wazè dan sikandin pemineǥa tenged te kegkesuǥey zan wey te gerabi he pesipala kandan dutun te ked-uripena kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ne migkeǥiyan si Moises te Nengazen te, ");
INSERT INTO mbbOT_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Genat ka, ne keǥiyi nu is Faraon he hadì te Ehipto he tuǥuti zin en is menge Israilihanen he egawas te nasyun din.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Iyan, migkaǥi si Moises diyà te Nengazen te, “Emun wazà mebpemineg kedì is menge Israilihanen, iyan pe be is hadì? Su kenà a metau he ebpengaǥikaǥi!” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ne migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, “Keǥiyi niw is menge Israilihanen wey is Faraon he hadì te Ehipto he midsuǥù ku sikiyu is dezuwa te kebpeǥawas te menge Israilihanen diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Iyan heini menge kepuun te nepipira he menge pemilya te tribu te Israel: Is menge anak ni Reuben he maama te kinekekayan he anak ni Israel iyan ensi Hanoc, Palu, Hezron wey si Carmi. Ne iyan sikandan wey is menge kevuwazan dan menge pemilya he ebpuun diyà te ki Reuben. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Is menge anak he maama ni Simeon iyan ensi Jemuel, Jamin, Ohad, Jakin, Zohar, wey si Shaul. (Heini si Shaul anak ni Simeon he Canaanhen is iney zin.) Ne iyan sikandan wey is menge kevuwazan dan menge pemilya he ebpuun ki Simeon. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Sumalà is insurat he keguǥuza iyan heini menge ngazan te menge maama he menge anak ni Levi: si Gershon, si Kohat, wey si Merari. Is keluǥayad te untung ni Levi 137 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Is menge anak he maama ni Gershon iyan si Libni wey si Shimei. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Is menge anak he maama ni Kohat iyan si Amram, si Izhar, si Hebron, wey si Uziel. Is keluǥayad te untung ni Kohat 133 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Is menge anak he maama ni Merari iyan si Mali wey si Mushi. Ne iyan heini ebpuunan te menge kevuwazan ni Levi sumalà is keguǥuza te menge kevuwazan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Mid-esawa ni Amram is etevey te amey zin he si Jokebed. Ne iyan menge anak dan he maama si Moises wey si Aaron. Is keluǥayad te untung ni Amram 137 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Is maama he menge anak ni Izhar iyan si Kora, si Nefeg, wey si Zicri. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Is maama he menge anak ni Uziel iyan si Mishael, si Elzafan, wey si Sitri. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Si Aaron, neesawa zin si Elisheba is anak he vahi ni Aminadab wey etevey zaan ni Nashon. Ne in-anak dan si Nadab, si Abihu, si Eleazar, wey si Itamar. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Is maama he menge anak ni Kora iyan si Asir, si Elkana, wey si Abiasaf. Ne iyan sikandan wey is menge kevuwazan dan menge pemilya he ebpuun te ki Kora. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar is anak he maama ni Aaron, neesawa zin is sevaha zuen te menge anak he vahi ni Putiel ne in-anak dan si Finehas. Iyan heini menge kepuun te menge pemilya he Levihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Sikan is Aaron wey Moises he ingkelista kayi te guǥud te menge pemilya iyan en sikan is Aaron wey Moises he migkeǥiyan te Nengazen te, “Dumaha niw is menge Israilihanen pehendiyà te ǥawas te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Iyan sikandan sikan is nekidlalag te Faraon he hadì te Ehipto mehitenged te kedumaha zan te menge Israilihanen pehendiyà te ǥawas te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ne hein nekidlalag is Nengazen ki Moises diyà te Ehipto, ");
INSERT INTO mbbOT_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","migkeǥiyan din si Moises te, “Siak, is Nengazen, edsuǥuen ku sikew. Keǥiya nu ziyà te Faraon he hadì te Ehipto is langun he migkaǥi ku ziyà te kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Iyan, migkaǥi si Moises diyà te Nengazen te, “Kenà ebpemineg kedì is hadì su kenà a metau he ebpengaǥikaǥi.” ");
INSERT INTO mbbOT_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ne migkaǥi is Nengazen diyà te ki Moises te, “Pemineg ka! Edhimuwen ku sikew he iring te sevaha he megbevayà he para te hadì te Ehipto. Pekidlalag ka kandin pinaaǥi te suled nu he si Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Egkeǥiyen nu ziyà te suled nu he si Aaron is minsan hengkey he egkeǥiyen ku kenikew, ne iyan sikandin egkaǥi ziyà te hadì he tuǥuti zin he mekeǥawas is menge Israilihanen puun te nasyun din. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ne ebpengelinteuwan ku he kenà ed-uteng is menge lalag niw ziyà te ǥehinawa te hadì, ne minsan ke mezakel he menge singyal wey egkengein-inuwan he menge vaal is ebeelan ku ziyà te Ehipto, ");
INSERT INTO mbbOT_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","kenè kew zin gihapun ebpemineǥen. Ne ibpeseǥazan ku te menge Ehiptohanen is utew merasey, ne ibpeǥawas ku puun diyà te kandan is langun he tribu te Israel he menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Is menge Ehiptohanen, ne egketuenan dan he iyan a Nengazen emun igkepeseǥazan ku en kandan is utew merasey wey igkepeǥawas ku en puun diyà te kandan is menge Israilihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Midtuman ni Moises wey ni Aaron is insuǥù kandan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ne 80 en is penuiǥen ni Moises ne si Aaron, ne 83 is penuiǥen din hein mibpekidlalag sikandan te hadì te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Migkeǥiyan te Nengazen si Moises wey si Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Emun egkeǥiyan kew te hadì te Ehipto te peehè kew te singyal, ne keǥiyi nu Moises si Aaron te, ‘Itimbag nu is tuked nu ziyà te etuvangan te hadì ne ebaluy haazà he uled.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ne midhendiyà si Moises wey si Aaron te hadì ne mibeelan dan is insuǥù kandan te Nengazen. Intimbag ni Aaron sikan is tuked din diyà te etuvangan te hadì wey te menge upisyal zin, ne mibaluy he uled haazà is tuked. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ne zutun mibpesuǥuan te hadì is menge uluwanen he etew wey is menge selemengkiru ziyà te Ehipto ne nehimu zan daan is iring dutun pinaaǥi te kegkeselemengkiru zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Is kada sevaha kandan, midtimbag te tuked din ne haazà nememaluy he uled. Iyan, mibakal zuen te tuked ni Aaron sikan is kandan he menge tuked. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Iyan, wazà haazà med-uteng diyà te ǥehinawa te hadì ne wazè din pemineǥa si Moises wey si Aaron sumalà is daan he impetizaan kandan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ne migkaǥi is Nengazen diyà te ki Moises te, “Mezesen is gehinawa te hadì he kenà edtuǥut he mekeǥenat is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Umbe, hendiyè ka te hadì keeselem te meselem emun edhendiyà sikandin te Wahig he Nilo. Ne zutun ka pekidhinguma kandin te veyvey te wahig, ne uwita nu sikan is tuked nu he mibaluy he uled. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ne keǥiyi nu sikandin te, ‘Midsuǥù a te Nengazen he iyan Megbevayà te menge Hebriyuhanen, su ebpekeǥiyan ke zin he: Tuǥuti nu en is menge etew ku te kegenat su wey zan mekaazap kedì diyà te sibsivayan. Iyan, taman en guntaan ne wazè ka mebpezumazuma. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Siak, is Nengazen, egkaǥi a he pinaaǥi te edhimuwen ku, egketuenan nu he iyan a Nengazen. Pinaaǥi kayi he tuked, idlagkut ku heini ziyà te wahig he Nilo ne ebaluy he lengesa is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ne zutun ebpemematey is menge isdà kayi te Nilo wey ebmemahu heini is wahig ne kenè en egkehimu he ed-inumen te menge Ehiptohanen.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ne migkeǥiyan si Moises te Nengazen te, “Keǥiyi nu si Aaron te, ‘Kuwaa nu is tuked nu ne ivayew nu ziyà te menge wahig kayi te Ehipto: dezekelà he wahig he edtudà, beuǥan, kanal, wey menge wahig he mibpeneng, wey ziyà te langun he punduwà te wahig.’ Ne is langun dutun ebaluy he lengesa. Iyan heini egkeulaula ziyà te Ehipto. Minsan is wahig he ziyà te menge teleǥuey he kayu etawa vatu ne egkehimu he lengesa.” ");
INSERT INTO mbbOT_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ne midtuman ni Moises wey ni Aaron is insuǥù kandan te Nengazen. Imbayew ni Aaron sikan is tuked din diyà te etuvangan te hadì te Ehipto wey te menge upisyal zin, ne inlagkut din diyà te Wahig he Nilo, ne zutun mid-amin mebaluy he lengesa haazà is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nemematey is menge isdà dutun ne mibmemahù haazà is wahig, ne kenè en egkehimu he ed-inumen te menge Ehiptohanen. Minsan hendei ziyà te Ehipto ne zuen wahig he mibaluy he lengesa. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Piru is Ehiptohanen he menge selemengkiru nekehimu zaan sikandan te iring dutun pinaaǥi te kegkeselemengkiru zan, ne haazà is neulaula wazà med-uteng diyà te ǥehinawa te hadì, ne wazà sikandin mebpemineg ki Moises wey ki Aaron, su iyan haazà migkaǥi te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Midlikù haazà is hadì diyà te turuǥan din ne wazè din en itaǥù diyà te ǥehinawa zin haazà is neulaula. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ne is menge Ehiptohanen nemengalut sikandan diyà te uvey te Wahig he Nilo su para zuen dan egkekuwaan te ed-inumen dan su kenè en man egkehimu he ed-inumen is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ne hein pitu en he andew puun duen te kebpeveluya te Nengazen te Wahig he Nilo he lengesa pinaaǥi ki Aaron, ");
INSERT INTO mbbOT_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ne migkeǥiyan te Nengazen si Moises te, “Hendiyè ka te hadì te Ehipto ne keǥiyi nu sikandin te, ‘Iyan heini lalag te Nengazen diyà te kenikew: Tuǥuti nu is menge etew ku te kegenat su wey zan mekaazap kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ne emun kenè nu sikandan edtuǥutan, ebpigedahan ku sikiyu is menge Ehiptohanen kayi te tivuuk he Ehipto pinaaǥi te menge vakbak. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Utew edsubra is kebmahabet te menge vakbak diyà te Wahig he Nilo ne edseled dan diyà te turuǥan nu, diyà te ruǥu nu wey minsan diyà te hizeǥaan nu. Edseled dan daan diyà te menge valey te menge upisyal nu wey te ginsekupan nu, ragkes en is menge avu wey menge lugar he ebmesahan te herina. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Edlingketawan ka te menge bakbak wey is menge etew nu wey elin is menge upisyal nu.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ne zutun migkaǥi is Nengazen diyà te ki Moises te, “Keǥiyi nu si Aaron he beyawa zin is belad din he zuen tuked he ibpetezù diyà te menge dezekelà he wahig he edtudà, beuǥan, kanal, wey menge wahig he mibpeneng, ne egaun is menge vakbak kayi te tivuuk he tanà he Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ne imbayew ni Aaron is belad din he ibpetezù diyà te zivavew te menge wahig diyà te Ehipto, ne zutun migaun is utew midtaman he mahabet he menge vakbak ne giranap dan diyà te tivuuk he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ne sikan is menge selemengkiru nehimu zan daan is iring dutun su ingkepeǥaun dan daan is menge vakbak puun te menge wahig diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ne mibpesuǥuan te hadì te Ehipto si Moises wey si Aaron ne migkeǥiyan din te, “Ampù kew ziyà te Nengazen he iawè din heini is menge vakbak kayi te kediey wey te menge etew ku, ne edtuǥutan ku te kegenat is menge zuma niw su wey zan mepemuhat is Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ne migkaǥi si Moises te, “Iyan ke en telaan ke keenu ku sikew id-ampù duma te menge upisyal nu wey te tivuuk he gin-etawan nu, su wey maawà is nenggaun he menge vakbak diyà te keniyu wey ziyà te menge valey niw. Iyan dà egkesamà he menge vakbak is diyà te Wahig he Nilo.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ne midtavak haazà is hadì te, “Keeselem iampù a kenikew.” Ne midtavak si Moises te, “Uya, edtumanen ku heeyan is nekaǥi nu, su wey nu metueni he wazà ebpekerepeng te Nengazen he iyan Megbevayè dey. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ed-awà is langun he menge vakbak diyà te keniyu ne iyan dà egkesamà is diyà te Wahig he Nilo.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ne hein mid-ewaan en ni Moises wey ni Aaron kes hadì, ne mibpengemuyù si Moises diyà te Nengazen he iawè din sikan is menge vakbak he midsuǥù din diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ne mibeelan te Nengazen is inhangyù ni Moises. Nemematey is menge vakbak diyà te menge valey, diyà te menge lama, wey menge vevesukà. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ne miburunburun heini te menge Ehiptohanen ne metikang is tambù dan ne mibmemahù is tivuuk he Ehipto tenged dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Iyan, hein naahà duen te hadì he naawè en sikan is menge vakbak, ne impemezesen din en maan is gehinawa zin, ne wazà sikandin mebpemineg ki Moises wey ki Aaron, sumalà te nekaǥi te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ne migkaǥi is Nengazen diyà te ki Moises te, “Keǥiyi nu si Aaron te ilagkut nu is tuked nu ziyà te tanà, ne egkehimu he rengit is eliyavuk te tanà te tivuuk he Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ne mibeelan dan heini, ne hein inlagkut ni Aaron diyà te tanà sikan is tuked din, ne mibaluy he menge rengit is eliyavuk diyà te tivuuk he tanà he Ehipto. Ne midhurunan te menge rengit is menge etew wey menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ne hein iyan migezam mebaal te menge rengit sikan is menge selemengkiru pinaaǥi te kegkeselemengkiru zan, ne wazà sikandan mekehimu. Ne zutun midhurun is menge rengit diyà te menge etew wey menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ne migkaǥi sikan is menge selemengkiru ziyà te hadì te, “Baal heini te Megbevayà!” Piru mezesen gihapun is gehinawa zuen te hadì, ne wazà sikandin mebpezumazuma ki Moises wey ki Aaron, su iyan heini migkaǥi te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ne migkaǥi is Nengazen diyà te ki Moises te, “Sayu ka enew keeselem ne veyai nu kes hadì te kedhendiyà din te wahig. Ne keǥiyi nu sikandin he iyan heini migkaǥi ku: ‘Tuǥuti nu is menge etew ku te kegenat su wey zan mekaazap kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ne emun kenè nu sikandan edtuǥutan, ebpengelinteuwan ku he ebpekeuma keniyan te kenikew is ebmelinguwan he menge dezeizey he keranapranap he edhurun diyà te kenikew wey ziyà te menge upisyal nu wey te menge keet-etawan nu. Egkengepenù te menge dezeisey he keranapranap is menge valey niw, ne is tanà ne egketembunan kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Iyan, emun egkehitavù en haazà ne kenà mulà egkehitavù diyà te tanà he Goshen, he iyan ed-ubpaan te menge etew ku; kenà mulà edhendiyà te kandan is menge dezeizey he keranapranap he ebpezumdumahà, su para metueni niw he siak, is Nengazen, dutun a he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Edhimuwen ku is kebpekeviza te kediey he menge etew wey is kenikew he menge etew. Ne heini is singyal egkehitavù keeselem.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mid-ulaula iyan heini te Nengazen. Midselezan te mezakel he menge dezeisey he menge keranapranap is turuǥan te hadì wey is baley te menge perezumala zin, ne is tivuuk he tanà te Ehipto ne nezeetan tenged kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ne mibpesuǥuan te hadì si Moises wey si Aaron ne ke sikandin diyà te kandan te, “Genat kew en, pemuhata niw is Megbevayà, piru kayi kew zà te seled te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Iyan, midtavak si Moises te, “Kenà heeyan hustu, su is menge pemuhat he ibpemuhat dey te Nengazen he Megbevayè dey, ne utew igkelimezangi te menge Ehiptohanen. Ne emun igkeremerik dan is ibpemuhat dey, ne ebpenulengen key zan te vatu. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Umbe, kinahanglan he edtumanen dey is insuǥù kenami te Nengazen he iyan Megbevayè dey he ibpehipanew key zin pehendiyà te sibsivayan seled te tetelu he andew ne human dey sikandin ebpemuhata.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ne migkaǥi is hadì te, “Edtuǥutan ku sikiyu te kedhendiyà te sibsivayan su wey niw mepemuhat is Nengazen he Megbevayè niw, piru kinahanglan he kenè kew edhendiyà te utew meziyù. Ne iampù e en keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Midtavak si Moises te, “Ǥuntaan ke ed-ewaan ku en sikew, id-ampù ku en sikew ziyà te Nengazen, ne keeselem ed-awà is menge zezeizey he keranapranap diyà te keniyu te langun. Iyan dà is, kinahanglan he kenè key en kenikew ed-umanan edlimbungi pinaaǥi te kenè nu kebpeǥenata kenami emun egenat key en su wey zey mepemuhat is Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ne zutun mid-ewaan ni Moises haazà is hadì ne mid-ampù diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ne intuǥut te Nengazen is mibuyù ni Moises. Mid-awà is menge zezeizey he keranapranap diyà te langun he menge Ehiptohanen, ne wazà minsan sevaha he nesamà. ");
INSERT INTO mbbOT_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ne zutun he timpu impemezesen en maan duen te hadì is gehinawa zin he kenè din edtuǥutan he mekeǥenat haazà is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ne migkeǥiyan te Nengazen si Moises te, “Hendiyè ka te hadì te Ehipto ne keǥiyi sikandin te, ‘Iyan heini migkaǥi te Nengazen, is Megbevayà te menge Hebriyuhanen: Tuǥuti nu is menge etew ku te kegenat su wey zan mekaazap kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ne emun kenè nu pa sikandan edtuǥutan he mekeǥenat, ");
INSERT INTO mbbOT_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ne zuen meveǥat he ibpigada ku he iyan is kebpematey te menge uyaǥen nu ziyà te vevesukà–ebpematey is menge kudè niw, menge asnu niw, menge kemilyu niw, menge vaka niw, menge kerehidu niw, wey menge kambing niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Iyan, ibpebiza ku is menge uyaǥen te menge Israilihanen wey is menge uyaǥen te menge Ehiptohanen, su wazà mulà ebpatey he uyaǥen te Israilihanen.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Midtelaan te Nengazen is timpu, ke sikandin te, “Keeselem ku heini ed-ul-ulaha kayi he tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ne hein sunud en he andew mibeelan en te Nengazen haazà: mid-amin mebpematey is langun he uyaǥen te menge Ehiptohanen. Piru wazà mulà mepetayi te minsan sevaha is uyaǥen te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ne zuen impesusi te hadì te Ehipto he menge etew ke zuen be nemematey te uyaǥen te menge Israilihanen. Piru minsan ke netuenan din en he tutuu heini, iyan, wazà mahalin is gehinawa zin, ne wazè din gihapun tuǥuti te kegenat is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ne migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, “Kuwa kew te tigsengekemkem he avu ziyà te repuǥà ne haazà ibpesimburà ki Moises diyà te hewhewanan dutun te egkeventayan sikandin te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ne egkehimu haazà he eliyavuk ne haazà ebpekeeneb te tivuuk he Ehipto, ne pinaaǥi zutun ebpenlevaǥan te menge levag he ednanà is menge etew wey menge ayam kayi he tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Umbe, migkuwa sikandan te avu ziyà te repuǥà ne midhitindeg sikandan diyà te etuvangan te hadì. Insimburà haazà ni Moises diyà te hewhewanan, ne zutun mibpenlevaǥan te menge levag he ednanà is menge etew wey menge ayam. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ne wazè en mekepeǥiewǥiew ziyà te ki Moises sikan is menge selemengkiru su mibpenlevaǥan en daan sikandan iring te langun he menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ne haazà he singyal, midhimu te Nengazen he kenà gihapun med-uteng diyà te ǥehinawa zutun te hadì. Umbe wazè din gihapun pemineǥa si Moises wey si Aaron, su iyan haazà migkaǥi he zaan te Nengazen diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Migkaǥi is Nengazen diyà te ki Moises te, “Selemselem ka enew keeselem ne etuvanga nu is hadì, ne ke sikew ziyà te kandin te, ‘Iyan heini migkaǥi te Nengazen he iyan Megbevayà te menge Hebriyuhanen diyà te kenikew: Tuǥuti nu te kegenat is menge etew ku su wey zan mekaazap kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ne emun kenè nu sikandan edtuǥutan, ne ibpeiseg ku en is keveǥat te menge pigada ku kenikew, ragkes is menge upisyal nu wey is tivuuk he gin-etawan nu su wey nu metueni he wazà ebpekerepeng kedì kayi te tivuuk he kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ne minsan dengan ke mid-amin ku sikiyu limasa is menge Ehiptohanen pinaaǥi te zaru, ne egkehimu ku ne wazè ke en pezem guntaan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Iyan, intuǥut ku he meuyag-uyag ka para kayi he ketuyu-an: su wey nu maahà is gehem ku ne wey a mevantug kayi te tivuuk he kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Piru kemulu nu egkuntedaha is menge etew ku, wey kenè nu sikandan edtuǥutan te kegenat. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Umbe keeselem, te iyan ded heini he uras, ibpeuzan ku te ǥiyew he utew gerabi, he wazè pa keenu meseǥazi puun te kegketukud te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Umbe, kinahanglan he segugunè ka suǥù he ipemeseled is langun he menge uyaǥen nu wey is langun he menge uripen nu he ziyà te vevesukà, su is langun he ziyà te ǥawas, etew man etawa uyaǥen, ne ebpematey emun egkeuluǥan te ǥiyew.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ne tenged te nekaǥi te Nengazen, nengahandek is duma he menge upisyal te hadì te Ehipto, umbe inggaanggaan dan ipemeseled is menge uripen dan wey is menge uyaǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Piru sikan is duma he wazà medseǥipà dutun te migkaǥi te Nengazen; ne ziyè dà mulà te gawas is kandan he menge uripen wey menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","(Ne hein iyan en timpu te kedtumana te Nengazen duen te lalag din) migkeǥiyan din si Moises te, “Ivayew nu en is tuked nu pehendiyà te zivavew su wey mengeulug is giyew kayi te tivuuk he Ehipto su wey meuluǥi is menge etew, menge uyaǥen, wey is langun he menge pinemula.” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Umbe, hein imbayew ni Moises sikan is tuked din diyà te zivavew, impepemeransì te Nengazen, impeuzan te giyew, wey impepengilat. Is menge uzan he ǥiyew he impeuzan te Nengazen diyà te tanà he Ehipto, ");
INSERT INTO mbbOT_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","iyan utew gerabi puun te kegkehimuwa te Ehipto he nasyun. Ne zutun te ebpenggiyew, edtulung en daan ebpengilat. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Nekeeneb diyà te Ehipto is giyew ne nekezezaat te menge etew wey menge uyaǥen he ziyà te ǥawas, ragkes is langun he menge pinemula wey menge kayu. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Iyan dà wazà duen giyew is tanà he Goshen he zutun ed-ubpà is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ne mibpesuǥuan te hadì si Moises wey si Aaron. Ne ke sikandin diyà te kandan te, “Guntaan netuenan ku en he nekesalà a; netuenan ku he ebpekevenar is Nengazen ne iyan a nesayep wey is menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Iampù niw ziyà te Nengazen he ipeengked din en heini is gerabi he veransì wey giyew. Ne human ku en sikiyu edtuǥuti te kedhipanew; kenè kew en ereg he ed-ubpè pa kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ne midtavak si Moises te, “Kengkuwan te kebpekeǥawas ku kayi te inged, ibayew ku is belad ku su ed-ampù e en diyà te Nengazen. Ne ed-engked is menge veransì ne egkaawà is giyew, su wey nu metueni he gaked te Nengazen heini is kelibutan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Iyan, netuenan ku en he sikew wey is menge upisyal nu, ne kenè kew pa ǥihapun egkahandek te Nengazen he Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Nezeetan is menge pinemula zan he flax wey barli su zutun he timpu, nelutuan en is menge barli ne nengevukad en is menge flax. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ne is menge trigu wey is sintinu wazà mulà mezeeti su nehuziyan.) ");
INSERT INTO mbbOT_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ne mid-ewaan ni Moises haazà is hadì, ne migawas sikandin dutun te inged. Imbayew zin is menge velad din te ked-ampù diyà te Nengazen; ne mid-engked is beransì, is kebpenggiyew, wey is uzan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ne hein naahà dutun te hadì he mid-engked en is uzan, is giyew, wey veransì, ne mid-uman en maan sikandin mebpekesalà. Impemezesen din wey te menge upisyal zin is gehinawa zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ne tenged te kezesen te gehinawa zin ne wazè din ipeǥenat is menge Israilihanen, sumalà te nekaǥi te Nengazen pinaaǥi ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ne migkeǥiyan te Nengazen si Moises te, “Hendiyè ka te hadì te Ehipto, su ebpekezesenen ku is gehinawa zin wey is gehinawa te menge upisyal zin, su wey ku ikepedayun ikepaahà diyà te kandan is menge singyal he ebeelan ku, ");
INSERT INTO mbbOT_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","su wey niw metudtul ziyà te menge anak niw wey menge apù niw is paaǥi te kedsiluti ku te menge Ehiptohanen wey is paaǥi te kebpaahà ku kandan te menge singyal he mibeelan ku, su wey niw metueni he iyan a Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ne midhendiyà si Moises wey si Aaron te hadì ne migkeǥiyan dan sikandin te, “Iyan heini migkaǥi te Nengazen he iyan Megbevayà te menge Hebriyuhanen, ‘Sengemenu kun is keluǥayad te kebpelavew nu ziyà te etuvangan ku? Tuǥuti nu te kegenat is menge etew ku su wey zan mekaazap kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ne emun kenè nu edtuǥutan te kegenat is menge etew ku, ibpeseǥazan ku keeselem te menge etew nu kayi te Ehipto is pigada pinaaǥi te terapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ne tenged te utew subra is kahabet dan, ne kenà ebpekelepew is tanà. Ne iyan heini ebpekaamin duen te zeisey he nesamà keniyu hein nenggiyew, ne idragkes dan is langun he kayu ziyà te menge pemuleey niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ne egkepenù te terapan is turuǥan nu, wey is menge valey te menge upisyal nu wey is menge valey te langun he Ehiptohanen. Ne wazè pa heeyan keenu meseǥazi te menge kepuun niw puun te ked-ubpè dan kayi he tanà taman en guntaan.’ ” Ne zutun miberiyung si Moises ne mid-ewaan din is hadì te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ne migkaǥi sikan is menge upisyal te hadì diyà te kandin te, “Ebpekesigudu en ebpekeveǥey kenitew te kezeetan heeyan he etew, umbe deyzey ke edtuǥutan nu en sikandan te kegenat su wey zan maazap is Nengazen he Megbevayè dan. Su isipa nu man, nezeetan en heini is Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Umbe, impelikù dutun te hadì si Moises wey si Aaron, ne migkaǥi haazà is hadì diyà te kandan te, “Egkehimu en he egenat kew te ked-azap te Nengazen he Megbevayè niw, piru id-insè ku keniyu ke hentei keniyu is eduma te egenat?” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Midtavak si Moises te, “Egenat key langun: batà wey meǥurang. Edumahan dey is menge anak dey wey menge uyaǥen dey, su edsilibra key te pista para te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ne migkaǥi haazà is hadì te, “Dumahi kew te Nengazen; iyan, kenà a edtuǥut, su emun idtuǥut ku he edumahan niw is menge pemilya niw ne siguradu zuen mezaat he ed-ul-ulahan niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kenà a edtuǥut! Iyan dà is menge maama ibpehipanew para mekaazap te Nengazen, emun iyan heeyan egkesuatan niw.” Ne zutun, impaawà si Moises wey si Aaron dutun te etuvangan te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ne migkaǥi is Nengazen diyà te ki Moises te, “Bentanga nu is tuked nu keniyan te tanà he Ehipto su wey mekeuma is menge terapan, ne egkeenen dan is menge pinemula he wazà mezeeti zuen te ǥiyew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Umbe, mibantang ni Moises diyà te tanà he Ehipto sikan is tuked din, ne zutun te tivuuk he andew wey tivuuk he kezukileman, impepengeramag te Nengazen dutun he tanà te keramag he ebpuun diyà te edsilaan. Ne kegkemeselem, nekeuwit en te terapan haazà is keramag ");
INSERT INTO mbbOT_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","he utew gerabi, ne midhurapun heini ziyà te tivuuk he Ehipto. Wazè pa iring dutun he kebpendezaat te terapan puun te nehuna he timpu wey minsan te huziyan he timpu. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Midhurunan dan is tivuuk he Ehipto ne henduen be te mibmeitem is tanà. Mid-amin dan keena sikan is wazà mezeeti zuen te ǥiyew. Migkaan dan is minsan hengkey he midtuvù diyà te menge pemuleey wey is menge veǥas te kayu. Umbe wazè en nesamà he pinemula ziyà te tivuuk he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ne tenged dutun migègaanan pesuǥui te hadì si Moises wey si Aaron, ne ke sikandin diyà te kandan te, “Nekesalà a ziyà te Nengazen he iyan Megbevayè niw wey ziyà daan te keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Umbe, peseyluwa ad maan keniyu tenged te salè ku te minsan kesevaha zà, ne ampù kew ziyà te Nengazen he Megbevayè niw he iawè din heini is ebpekepatey he pigada.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ne mid-awà dutun si Moises te hadì, ne mid-ampù diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ne zutun impepengeramag te Nengazen te mevandes he keramag he ebpuun diyà te edsenlepan, ne impenlayap dutun sikan is terapan ne ziyà meuwit te Zaǥat he Meriǥà. Ne wazè en terapan he nesamà diyà te tivuuk he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Iyan, midhimu gihapun te Nengazen he mebmezesen is gehinawa te hadì te Ehipto, ne wazè din tuǥuti te kegenat is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ne migkeǥiyan te Nengazen si Moises te, “Ivayew nu is belad nu pehendiyà te zivavew su wey utew mibmerusirem diyà te tivuuk he Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ne imbayew ni Moises is belad din pehendiyà te zivavew, ne utew mibmerusirem diyà te tivuuk he Ehipto seled te tetelu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ne zutun, wazà minsan sevaha he nekehimu he egawas diyà te ed-ubpaan din seled te tetelu he andew su kenà ebpekaahà. Piru merayag mulà is diyà te lugar he ed-ubpaan te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ne mibpesuǥuan te hadì si Moises ne migkeǥiyan din te, “Genat kew en! Ezapa niw en is Nengazen, su elin ku en ibpezuma keniyu is menge pemilya niw, iyan dà itaǥak niw is menge uyaǥen niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Piru midtavak si Moises te, “Kinahanglan he ed-uwiten dey is menge uyaǥen dey su wey zey mepemuhat te menge pemuhat is Nengazen he Megbevayè dey, ragkes en is menge pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ed-uwiten dey is langun he uyaǥen dey; kinahanglan he wazà minsan sevaha he egkesamà. Su wazè dey pa metueni ke hengkey he kelasi te uyaǥen is ibpepemuhat te Nengazen kenami. Emun diyè key en ne human dey egketueni.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Iyan, midhimu gihapun te Nengazen he mebmezesen is gehinawa te hadì te Ehipto, ne wazè din sikandan tuǥuti te kegenat. ");
INSERT INTO mbbOT_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Migkeǥiyan duen te hadì si Moises te, “Awè ka kayi te etuvangan ku! Ne kenè ke en peuman paahà kedì! Su ebpehimetayan ku en sikew emun ed-uman ke pa ebpekid-etuvang kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ne midtavak si Moises te, “Uya, kenà ad ed-uman ed-etuvang kenikew su iyan heeyan egkesuatan nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ne migkaǥi zutun is Nengazen diyà te ki Moises te, “Duen pa sevaha he pigada he ebpeseǥazan ku te hadì wey te zuma he menge Ehiptohanen. Ne emun egkeseǥazan dan en haazà, ne human kew en edtuǥuti te hadì te kegenat puun kayi te Ehipto ne zutun kenè en kinahanglan he edhangyù kew ziyà te kandin su iyan en sikandin edsegseg keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Keǥiyi nu is menge Israilihanen, maama wey vahi, he mebuyù sikandan te menge elahas he pelata wey menge elahas he vulawan diyà te menge siringan dan he Ehiptohanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Su midhimu te Nengazen is menge Ehiptohanen he mebmahagkap is gehinawa zan diyà te menge Israilihanen, ne si Moises daan, dekelà is kedtehuza kandin te menge upisyal te hadì te Ehipto wey te zuma he menge Ehiptohanen.) ");
INSERT INTO mbbOT_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ne zutun migkaǥi en maan si Moises diyà te hadì, “Iyan heini migkaǥi te Nengazen: ‘Kengkuwan te liwazà is kezukileman edhipenawen ku is tivuuk he Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ne zutun he timpu ebpematey is kada pengenayan he maama kayi te Ehipto, puun te penganey he anak te hadì he iyan pezem ebpekeilis kandin pehendiyà te penganey he anak duen te uripen he vahi he pereǥaling wey is langun he penganey he anak te menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Egkezineg kayi te tivuuk he Ehipto is mezaǥing he sineǥawan. Iyan heeyan kinemezeetan he egkehitavù kayi te Ehipto he wazè pa keenu meseǥazi ne kenè en egkeuman egkeseǥazi. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Piru ziyà te menge Israilihanen mulà duen kelinew ne wazà minsan gevu te asu he egkezineg.’ Ne pinaaǥi keniyan egketuenan niw he impebiza te Nengazen is menge Ehiptohanen wey menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ne is langun kayi te menge upisyal nu edhendiyà te kedì, ne edluhud dan diyà te etuvangan ku is egkaǥi te, ‘Genat ke en wey is langun he edsunud kenikew!’ Ne emun egkeuleule en heini ne egenat e en.” Ne zutun nepauk si Moises ne mid-ewaan din haazà is hadì. ");
INSERT INTO mbbOT_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Daan he migkaǥi is Nengazen diyà te ki Moises te, “Kenè ka ebpemineǥen te hadì su para ikepeehè ku kayi te Ehipto is mezakel he menge vaal ku he egkengein-inuwan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Nemetmetahan te hadì te Ehipto is kebpaahà ni Moises wey ni Aaron duen te langun he egkengein-inuwan, iyan, midhimu te Nengazen is gehinawa zin he mezesen he kenà edtuǥut he mekeǥenat is menge Israilihanen puun te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ne migkaǥi is Nengazen diyà te ki Moises wey ki Aaron diyà te Ehipto te, ");
INSERT INTO mbbOT_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Heini is bulan guntaan iyan egkehuna he vulan te tuig para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Keǥiyi niw is tivuuk he keet-etawan te Israel he ziyà te ikesepulù he andew kayi he vulan kinahanglan he megkuwa is kada pemilya te nati he kerehidu etawa kambing para te pemilya zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ne emun egkeerangan te senge pemilya he kenè dan egkaamin te egkaan is sengetiman he kerehidu, mebpetelewizè dan dutun te avey zin. Edtelazen dan heini sumalà te kezakel zan wey sumalà te egkekaan te kada etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Iyan niw pilia is menge meemahan he uyaǥen niw he senge-tuig pa is keǥurang din wey wazè din sazir, egkehimu ke kerehidu, ne egkehimu zaan emun kambing. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Elimahi niw haazà taman te ike-14 he andew kayi he vulan, su sikiyu is tivuuk he keet-etawan te Israel, edlepaan niw haazà dutun he timpu emun ebpengirum-irum en. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ne kuwa kew te lengesa kayi ne izazas niw haazà diyà te ǥawas he ziyà te pesikilizà te marku te gemawan wey egkezivavew te marku zutun te ǥemawan te menge valey niw he zutun niw egkeena is edlepaan niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Dutun he kezukileman, egkeenen niw is usa he tinuug duma te memepait he utanen wey supas he wazè din tapey. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kenè kew kaan te usa he mehilew etawa sinevawan, kekenà, tuuǥa niw heini is tivuuk duma is ulu, paa wey is seled te ǥetek dutun te usa. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kinahanglan he ed-eminen niw haazà egkeena te kenè pa ebmeselem, ne emun duen niw egkesamà te egkeume en is meselem kinahanglan he edtutungen niw haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Dutun te kegkeena niw kayi, kinahanglan he naandam kew en te kedhipanew. Sesendalyas kew ne ǥewezi niw is tuked niw, ne ǥaanggaan kew is egkaan. Iyan haazà timpu te Pista te Kedlavey te Belinsuǥuen he edsilibrahan niw te kebeǥey te zengeg kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Su zutun daan he kezukileman edhipenawen ku is tivuuk he Ehipto ne ebpenhimetayan ku is langun he menge pengenayan he menge maama te menge Ehiptohanen, meetew se meuyaǥen. Ne edsilutan ku is langun he menge ed-ezapen kayi te Ehipto. Su iyan a Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ne haazà is lengesa, ne iyan tuus te menge valey he zutun kew is menge Israilihanen ed-ubpà. Ne emun egkeehè ku haazà is lengesa ne edlevayan ku zà sikiyu. Ne wazà mulà kezeetan he egkehitavù keniyu kayi te kebpigedahi ku te menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ne heini he andew, ne tentenuzi niw heini minsan keenu. Silibraha niw heini kada tuig he iyan pista te kebeǥayi niw kedì te zengeg. Heini he sulunuzen, ne kinahanglan he edtumanen niw taman te peleebuten he menge lapis te kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ne iyan heini ibpeulaula ku keniyu: Kinahanglan he kenè niw edtepayan is supas he egkeenen niw seled te pitu he andew. Umbe kinahanglan he id-awè niw is tapey ziyà te menge valey niw zutun te egkehuna he andew. Su is minsan hentei keniyu he egkaan te midtepayan puun dutun te egkehuna he andew pehendiyà te ikepitu he andew ne ed-isipen sikandin he kenà ragkes te kevuwazan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Dutun te egkehuna he andew tiǥum kew te ked-azap kedì ne umana niw heini ul-ulaha zutun te ikepitu he andew. Kinahanglan he wazà duma he terebahu niw seled dutun te pitu he andew, kekenà, iyan dà is kebaal te egkekaan te uman sevaha keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Silibraha niw is Pista te Supas he Wazè din Tapey, su wey niw kenà melipati haazà is andew te kebpeǥewasa ku keniyu te menge tribu ni Israel puun diyà te Ehipto. Ne iyan suǥù ku is: Kinahanglan he ibpezume en diyà te egketulung egkelapislapis he kevuwazan niw is kedsilibraha kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Puun kew te kedsilibra kayi zutun te mezukilem te ike-14 he andew te egkehuna he vulan taman te mezukilem dutun te ike-21 he andew, ne kenè niw tepayi is supas he egkeenen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Seled te pitu he andew kinahanglan he wazà tapey ziyà te menge valey niw. Is minsan hentei he egkaan te midtepayan kenè en sikandin ed-isipen he ragkes te kevuwazan ni Israel, tutuu man sikandin he kevuwazan ni Israel wey ke kenà. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Dutun he timpu kenè kew kaan te edtepayan. Minsan hendei kew ed-ubpà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ne impetawag ni Moises is langun he ebpemendumala te Israel ne migkeǥiyan din te, “Pen-ulì kew en ne keǥiyi niw is langun he menge pemilya niw, he megkuwa zan te nati he kerehidu etawa kambing ne lepaa zan haazà para te kedsilibra te Pista te Kedlavey te Belinsuǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ipetiǥis niw haazà is lengesa ziyà te yahung. Ne kuwa kew te subpang te hisup ne ipevudseng niw haazà diyà te lengesa ne izazas niw ziyà te zivavew wey pesikilizà he marku te menge ǥemawan niw. Ne wazà edliǥawang keniyu ziyà te valey niw taman te egkepawà. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Su edhipenawen te Nengazen is Ehipto te kebpenhimatey te kinekekayan he menge anak he maama te menge Ehiptohanen. Piru emun egkaahà te Nengazen is lengesa ziyà te zivavew wey pesikilizà he marku te ǥemawan, ne edlevayan din dà is baley niw ne kenè din edtuǥutan is ebpendezaat te kedseled diyà te menge valey niw te kebpenhimatey te kinekekayan he anak niw he maama. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Tumana niw heini he sulunuzen wey te menge kevuwazan niw taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Emun ebpekeseled kew en duen te tanà he impenaad te Nengazen he ibeǥey zin keniyu pedeyuna niw is ked-ul-ulaha niw kayi he tulumanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ne emun ed-insà is menge anak niw ke hengkey is kehuluǥan duen te tulumanen, ");
INSERT INTO mbbOT_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","keǥiyi niw sikandan te, ‘Pista heini te Kedlavey te Belinsuǥuen te Nengazen he edsilibrahan para te kebeǥey te zengeg te Nengazen, su midlevayan din dà is menge valey tew te menge Israilihanen diyà te Ehipto hein kebpenhimetayi zin te menge Ehiptohanen.’ ” Ne hein nekepasad dutun he edlalag si Moises, ne midluhud is menge Israilihanen ne mid-azap dan is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ne midtuman dan is insuǥù te Nengazen ki Moises wey ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ne hein liwazè en is kezukileman, midhimetayan en te Nengazen is langun he penganey he menge anak he maama diyà te Ehipto, puun te penganey he anak te hadì, he iyan pezem ebpekeilis kandin te kedhadì, pehendiyà te penganey te menge pinirisu ziyà te pirisuwan wey is langun he penganey te menge uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ne zutun he kezukileman mid-enew is hadì wey is langun he menge upisyal zin wey is langun he menge Ehiptohanen. Ne zutun nezineg dan is utew mezaǥing he sineǥawan diyà te Ehipto, su kada valey zan ne zuen duen mibpatey. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Dutun he kezukileman, mibpesuǥuan te hadì si Moises wey si Aaron ne ke sikandin diyà te kandan te, “Sigi, genat kew en! Ewai niw en heini is nasyun ku. Genat kew en wey niw maazap is Nengazen, su iyan heeyan edtulungan niw edhengyua. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Elin niw en tundana is menge uyaǥen niw su iyan heeyan migkaǥi niw. Ne hengyui niw is Megbevayà he kehizuwi e zin!” ");
INSERT INTO mbbOT_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Dutun he timpu edeǥusuwen en te menge Ehiptohanen is menge Israilihanen te ked-awà diyà te kandan. Su ke sikandan te, “Egkaamin key en ebpematey emun kenè kew pa egenat!” ");
INSERT INTO mbbOT_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ne tenged dutun impenaǥù dan diyà te menge teleǥuey zan is herina he mibmasa zan he wazè pa tepayi. Mibpenenges dan te manggad ne mibpeniang dan te egenat. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Midtuman te menge Israilihanen is mibpeveelan kandan ni Moises su mibuyù dan diyà te menge Ehiptohanen te menge elahas he pelata, menge elahas he vulawan, wey menge ebistiyen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Midhimu te Nengazen he mebmeupiya is gehinawa te menge Ehiptohanen diyà te menge Israilihanen umbe imbeǥey zan is mibuyù te menge Israilihanen; pinaaǥi zutun nepenevanan dan is menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Midhipanew is menge Israilihanen puun te Rameses pehendiyà te Sucot. Ne 600,000 is kahabet te menge maama zutun te nemenhipanew ne zuen pa menge vahi wey menge vatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ne liyu kandan duen pa mahabet he menge etew he nemenduma kandan he kenà Israilihanen ne elin pa midtundan dan is menge uyaǥen dan he utew mahabet. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pinaaǥi zuen te uwiten dan he minasa he herina he wazè en metepayi, nekevaal sikandan te supas he wazè din tapey. Wazà haazà metepayi is minasa zan su geina te egkezeǥusu sikandan su edsegseǥen en sikandan te menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Is keluǥayad te ked-ubpà te menge Israilihanen diyà te Ehipto, ne 430 he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ne netapus haazà is 430 he tuig, ne iyan en andew te ked-awà dutun te menge etew te Nengazen diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Dutun te tivuuk he kezukileman te kegenat te menge Israilihanen puun te Ehipto, henduen be te wazà medlipezeng is Nengazen te kebantey kandan. Umbe zutun daan he kezukileman ne kenà edlipezeng is menge Israilihanen su ebeǥayan dan te zengeg is Nengazen. Kinahanglan he ed-ul-ulahan dan heini taman te peleebuten he lapis te menge kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, “Iyan heini menge sulunuzen mehitenged te Pista te Kedlavey te Belinsuǥuen: “Dutun te kedsilibra, kenè niw ipekaan is lumelengyawà. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Is uripen he egkepemasa niw, egkehimu he egkaan dutun emun midsirkunsidar niw en, ");
INSERT INTO mbbOT_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","piru is midteǥaad dà med-ubpà diyà te keniyu wey is menge sinuhulan niw zà ne kenè niw ipekaan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Diyè dà haazà egkeenà te seled te valey he zutun heini endama. Ne haazà is usa kinahanglan he wazà minsan deisey zutun he ed-uwiten diyà te ǥawas. Ne kenè niw zaan bedtìa wey kenè niw rupeta is minsan hengkey he tulan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kinahanglan he edsilibrahan heini te tivuuk he keet-etawan te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Is kenà Hebriyuhanen he ebpekesahug diyà te keniyu he egkesuat he edsilibra te Pista te Kedlavey te Belinsuǥuen su wey meveǥayi te zengeg is Nengazen, kinahanglan he ipesirkunsidar zin is langun he menge maama he sakup te pemilya zin. Ne human sikandin egkehimu he edtampu su kuwinta, egkehimu en sikandin he Hebriyuhanen. Kenà egkehimu he ebpeketampu zutun is minsan hentei he maama he wazà mesirkunsidar. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Is belaud he para keniyu te menge Israilihanen ne iyan ded belaud he para te kenà menge Israilihanen he mid-ubpà duma keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Midtuman te langun he menge Israilihanen is insuǥù te Nengazen diyà te ki Moises wey ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dutun he andew impeǥawas te Nengazen puun diyà te Ehipto is menge tribu te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ipehinungud niw kedì is kada penganey he maama te menge anak niw wey is kada meemahan he egkehuna he anak te menge uyaǥen niw su migaked ku en heini.” ");
INSERT INTO mbbOT_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ne migkeǥiyan ni Moises is menge etew te, “Tentenuzi niw heini he andew is andew te kebpeǥewasa keniyu ziyà te Ehipto, he zutun kew mengeuripen, ne tenged te kebpeǥewasa zin keniyu zutun pinaaǥi te mekeǥeǥehem he velad din. Kenè kew kaan te edtepayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tentenuzi niw heini he andew zutun te vulan he Abib, he iyan kes andew te kebpeǥewasa keniyu ziyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Is tanà te menge Canaanhen, menge Hitihanen, menge Amorihanen, menge Hivihanen wey menge Jebusihanen, iyan kes tanà he impenangdù te Nengazen diyà te menge kepuun niw he ibeǥey zin keniyu, su heini he tanà, ne meupiya wey uuzaran. Ne emun ibpeseled kew en te Nengazen dutun he tanà, tumana niw heini he sulunuzen kayi he vulan te egkehuna he vulan te tuig: ");
INSERT INTO mbbOT_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Iyan keena niw seled te pitu he andew is supas he wazè din tapey ne zutun te ikepitu he andew tukud kew te pista he para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Iyan dà keena niw is supas he kenà edtepayan seled dutun te pitu he andew. Dutun he timpu, kinahanglan he wazà tapey ziyà te menge valey niw wey ziyà te minsan hendei ziyà te ǥawas. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Dutun he andew keǥiyi niw is menge anak niw he iyan id-ul-ulaha niw zutun is tenged te kedtentenuzi niw te mid-ulaula te Nengazen para keniyu hein migawas kew puun te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Heini he pista, igkepetug-iring te patik diyà te menge velad niw etawa vuked niw he ebpetanudtanud keniyu he kinahanglan he edtudtulen niw is insuǥù te Nengazen su impeǥawas kew zin diyà te Ehipto pinaaǥi te ǥehem din. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Umbe, tumana niw heini kada egkeuma is kedtumana zuen te kada tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Emun diyè kew en te tanà te menge Canaanhen su ibeǥey en te Nengazen haazà diyà te keniyu sumalà is impenangdù din diyà te menge kepuun niw, ");
INSERT INTO mbbOT_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","iveǥey niw ziyà te Nengazen is kada penganey he maama etawa meemahan he uyaǥen. Su ǥaked sikandan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ne tenged kayi egkehimu he edlekaten niw ziyà te Nengazen is asnu niw he pengenayan pinaaǥi te kebpemuhat diyà te kandin te nati he kerehidu. Ne emun kenè niw en edlekaten, kinahanglan he edhimetayan niw pinaaǥi te kebunggua zuen. Egkehimu zaan he edlekaten niw ziyà te Nengazen is kada penganey he maama zuen te menge anak niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Dutun te huziyan he timpu, emun ed-insà is menge anak niw ke hengkey is ibpesavut dutun, ne ke sikiyu te, ‘Impeǥawas kiw te Nengazen puun diyà te Ehipto su midlibri kiw zin te kegkeuripena kenitew pinaaǥi te kegemita zin te ǥehem din. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Su hein kenè kiw edtuǥutan te hadì te kegenat, midhimetayan te Nengazen is langun he penganey he menge anak he maama diyà te Ehipto, wey minsan is meemahan he menge penganey te menge uyaǥen dan. Umbe, ibpemuhat tew ziyà te Nengazen is menge meemahan he penganey he menge uyaǥen tew ne ebelukasan tew is penganey he menge anak tew he maama.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Heini he tulumanen, iring te patik diyà te velad wey vuked he kenà egkelipatan su layun egkaahà su pinaaǥi kayi kenà egkelipatan is kebpeǥewasa kenitew te Nengazen puun diyà te Ehipto pinaaǥi te kegamit din te ǥehem din.” ");
INSERT INTO mbbOT_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Hein impeǥenat en te hadì is menge Israilihanen, wazà sikandan ipevayà te Megbevayà te zalan he ziyà ebpekevayà te ed-ubpaan te menge Filistihanen minsan pa te iyan haazà mepantek su migkaǥi is Megbevayà te, “Is menge Israilihanen, emun ebpekepekidtebek dan te menge Filistihanen, ne kela ke mahalin is isip dan ne edlikù dan diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ne tenged kayi, ziyà sikandan ipevayà te Megbevayà te ibayà he ibpehendiyà te Zaǥat he Meriǥà he ziyà ebpekevayà te sibsivayan minsan pa te mekived haazà he zalan. Dutun te kedhipanew te menge Israilihanen puun diyà te Ehipto neǥumeenan sikandan para te kebpekidtebek. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mid-uwit ni Moises is menge tulan ni Jose su geina te impepenangdù ni Jose is menge suled din su ke sikandin te, “Kenà duwazuwa he edtevangan kew te Megbevayà, ne emun ed-awè kew en kayi te Ehipto kinahanglan he ed-uwiten niw is menge tulan ku.” ");
INSERT INTO mbbOT_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Hein mid-awè en is menge Israilihanen diyà te Sucot, ne ziyà sikandan megkampu te Etam, he kilid te sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Emun maandew zutun te kedhipanew zan egiyahan sikandan te Nengazen. Ebpetelihuna kandan sikandin pinaaǥi te mekepal he ǥapun he egkeiring te tukud diyà te egkehunaan dan; ne emun mezukilem, ne pinaaǥi maan te regreg he egkeiring te tukud diyà te egkehunaan dan. Ne iyan haazà ebpeketeyew kandan umbe ebpekehimu sikandan he edhipanew te maandew wey mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Emun maandew kenà ed-awà diyà te egkehunaan dan sikan is mekepal he ǥapun he iring te tukud, ne emun mezukilem kenà ed-awà diyà te egkehunaan dan sikan is regreg he iring te tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ne migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Keǥiyi nu is menge Israilihanen he medlikù dan, ne ziyè dan megkampu te uvey te Pi Hahirot, diyà te mid-elangan te Migdol wey Zaǥat he Meriǥà. Uvey heini te zaǥat ne egkaatbang din is Baal Zefon. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Umbe edhimuwen niw heini su para meisip te hadì he egkengetazintazin kew ne kenè kew en ebpekeǥawas kayi te sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ne edhimuwen ku he mebmezesen is gehinawa te hadì su wey kew zin mezal-as. Piru edèdeetan ku sikandin wey is menge sundaru zin. Ne pinaaǥi kayi egkeveǥayan a te zengeg, ne egketuenan te menge Ehiptohanen he iyan a kes Nengazen.” Umbe, mid-ulaula heini te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ne hein netudtulan sikan is hadì he mibpelaǥuy is menge Israilihanen, nahalin is isip din wey is isip te menge upisyal zin mehitenged te kegenat te menge Israilihanen. Ke sikandan te, “Nesayep kiw su midtuǥutan tew is menge Israilihanen te kegenat ne ǥuntaan kenè en sikandan ebpekepenilbi kenitew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Umbe, impaandam dutun te hadì is menge kerwahi zin, ne miduma zin is menge sundaru zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ne 600 he utew memeupiya he kerwahi is migamit dan, ne ǥawas dutun duen pa zuma he menge kerwahi ziyà te Ehipto he migamit dan ne zuen netendek he menge egalen dutun te menge sundaru ziyà te kada kerwahi. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mibpengelinteuwan te Nengazen he ibpemezesen din is gehinawa te hadì te Ehipto, umbe, midal-as din is menge Israilihanen he migenat he mezeeǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Is menge Ehiptohanen he miduma te kedal-as iyan is menge sundaru te hadì duma is menge pereuntud din te kudà wey menge kerwahi. Ne ziyè dan meseuti is menge Israilihanen te kampu zan he kilid te Zaǥat he Meriǥà wey uvey te Pi Hahirot, he atbang te Baal Zefon. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ne hein ebpekeuvey en haazà is hadì wey is menge sundaru zin, midsirap is menge Israilihanen ne neehè dan is menge Ehiptohanen he edal-as kandan. Ne nahandek sikandan ne nekevuyù sikandan te tavang diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ne migkeǥiyan dan si Moises te, “Maan is kayi key pa kenikew zumaha te sibsivayan para mebpatey? Wazè en be penlevengà diyà te Ehipto? Maan is impaawè key pa kenikew ziyà te Ehipto? ");
INSERT INTO mbbOT_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Minsan pa te migkeǥiyan dey en sikew hein diyè kiw pa te Ehipto te, bey-ani key en kenikew is ebpenilbi te menge Ehiptohanen su meupiya pa is kebpenilbi kandan kenà is kebpatey ziyà te sibsivayan!” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ne midtavak si Moises te, “Kenè kew mahandek. Pekelig-en kew ne egkeehè niw is paaǥi te Nengazen te kedlibriya zin keniyu ǥuntaan he andew. Su heini is menge Ehiptohanen he egkeehè niw ǥuntaan, ne kenè niw en sikandan egkeuman egkaahà. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Su iyan is Nengazen ebpekidtebek para keniyu. Ne kenè en kinahanglan he iyan kew ebpekidtebek.” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ne nengemuyù si Moises diyà te Nengazen ne migkeǥiyan sikandin te Nengazen te, “Hustu ke en he edhangyù. Keǥiyi nu is menge Israilihanen he medhipanew zan en. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ivayew nu is tuked nu ziyà te zivavew keniyan te zaǥat su wey meluwisi is egkezalandalan he tanà diyà te zizalem keniyan te zaǥat su para zutun ebayà is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ibpemezesen ku is gehinawa te menge Ehiptohanen su para del-asa kew zan. Piru edèdeetan ku is hadì wey is menge sundaru zin, wey is menge pereuntud din te kudà wey menge kerwahi. Ne pinaaǥi kayi egkevantug a. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ne emun egkezèdeetan ku en sikandan, ne egketuenan te menge Ehiptohanen he iyan a Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ne zutun is belinsuǥuen te Megbevayà he ziyà edhipanew te egkesineruwan te menge Israilihanen, mid-awà, ne ziyà medliling te egkeiniyuǥan dan. Ne sikan is mekepal he ǥapun he iring te tukud, mid-awà daan su midliling daan diyà te egkeiniyuǥan dan, ");
INSERT INTO mbbOT_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ne mibpetug-elang te menge Ehiptohanen wey te menge Israilihanen. Ne seled te tivuuk he kezukileman nekeveǥey te kerusirem diyà te menge Ehiptohanen haazà is gapun he iring te tukud, iyan, nekeveǥey mulà te kerayag diyà te menge Israilihanen. Ne tenged dutun, tekew en midlavey is kezukileman ne wazà mekeuvey is menge Ehiptohanen diyà te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ne migketeng ni Moises is belad din diyà te zivavew zutun te zaǥat, ne zutun te tivuuk he kezukileman impehiyup te Nengazen haazà is daǥat te mevandes he keramag he ebpuun diyà te edsilaan ne zutun nevahin is daǥat ne neluwisan is nezalandalan he tanà diyà te zizalem dutun te zaǥat. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ne zutun mebayà is menge Israilihanen, te memaza he ibayà, ne ziyà te egkekewanan dan wey egkeǥivang dan is wahig he neiring te elavet. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ne midal-as sikandan te menge Ehiptohanen. Midal-as kandan is langun he menge kudà te hadì he eguyud te kerwahi, wey is duma he menge sundaru zin he ebpemen-untud te kudà. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ne hein meǥaan en egkepawà dutun he kezukileman nememantew is Nengazen puun duen te mekepal he ǥapun wey regreg he iring te tukud, mibpantew zin is menge sundaru he Ehiptohanen ne mibpengelintuwan din he mengeliveg sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Mibpengelinteuwan din he kenà metileng is menge ligid te menge kerwahi zan su para medlised sikandan he ebpepelelaǥuy zutun. Ke sikandan te, “Ebpeleǥuyan tew is menge Israilihanen su iyan is Nengazen ebpekidtebek kenitew para kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hein nekelayun en is menge Israilihanen, migkaǥi is Nengazen diyà te ki Moises te, “Ketenga nu is belad nu ziyà te zivavew keniyan te zaǥat su wey mekedlikuey heeyan is daǥat su wey mengelened is menge Ehiptohanen, wey mengelened heeyan is menge kerwahi zan wey heeyan is menge pereuntud te kudà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Umbe, migketeng ni Moises is belad din diyà te zivavew zutun te zaǥat, ne zutun te meselem nekedlikuey haazà is daǥat. Ne ebpemelaǥuy pezem is menge Ehiptohanen piru midlened sikandan te Nengazen dutun te zaǥat. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nengelened is langun he menge sundaru te hadì te Ehipto he edal-as te menge Israilihanen ragkes en is menge pereuntud te kudà wey menge kerwahi. Wazà minsan sevaha he nesamà kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Piru is menge Israilihanen nekevayà mulà sikandan dutun te zaǥat su zuen dan med-ikul te neluwisan he nezalandalan he tanà, ne ziyà te egkekewanan dan wey egkeǥivang dan is wahig he iring te elavat. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Dutun he andew midlibri te Nengazen is menge Israilihanen te mezaat he ebeelan pezem kandan te menge Ehiptohanen, ne naahà te menge Israilihanen diyà te veyvey is nemekehidhizeǥà he nemematey. ");
INSERT INTO mbbOT_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ne hein naahà te menge Israilihanen is dekelà he ǥehem te Nengazen he impeehè din pinaaǥi te mid-ulaula zin, ne neteǥuan sikandan te kedtahud te Nengazen wey te kedsarig diyà te kandin wey ziyà te ki Moises he suluǥuen din. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Migkanta ni Moises wey is duma he menge Israilihanen diyà te Nengazen heini he kentahan: “Egkentahan ku is Nengazen, su mezeeǥen sikandin. Insinumag din diyà te zaǥat is menge kudà wey is ebpemen-untud duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Is Nengazen iyan ebeǥey kedì te zesen, wey iyan sikandin egkekanta ku. Iyan sikandin menluluwas ku. Iyan sikandin Megbevayè ku, ne edeliǥen ku sikandin. Megbevayà sikandin te menge kepuun ku, ne ebentuǥen ku sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Beǥani is Nengazen; Nengazen is ngazan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Midlened din diyà te zaǥat is menge kerwahi wey is menge sundaru te hadì te Ehipto. Nengelened diyà te Zaǥat he Meriǥà sikan is egkengeseriǥan he menge upisyal te hadì. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nengelened sikandan te mezalem he wahig; iring sikandan te vatu he inteledted diyà te mezalem. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Utew lavew is gehem nu Nengazen; pinaaǥi kayi midruntek nu is menge kuntada. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tenged te kegkemekeǥeǥehem nu, midèdeetan nu is edsukul kenikew. Neregreg is ebpeketutung he pauk nu; iring sikandan te reǥami he nehimu he igmuk. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pinaaǥi zà te kedhiyup nu neked-untud is wahig diyà te zaǥat ne neluwisan is tanà, ne haazà is wahig melig-en is kebpekehitindeg din he neiring te zezuwa he elavat; ne mibadtik haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mibpegalbu is kuntada tew, ke sikandin te, ‘Edel-asen ku sikandan ne edekepen ku; ebehinen ku is ketiǥeyunan dan ne ebpurungan ku heini ebpemulpulusi. Edhulevuten ku is ispada ku ne edèdeetan ku sikandan.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Piru senge pedhiyup nu zà ne nengelened sikandan te zaǥat. Neiring sikandan te timeǥà he inteledted diyà te mezalem. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wazà ed-ezapen te menge etew he ebpekerepeng kenikew, Nengazen. Wazà ebpekerepeng kenikew te kegkewaǥas nu wey kegkemekeǥeǥehem. Iyan ke zà Megbevayà he mibaal te egkein-inuwan he menge vaal! ");
INSERT INTO mbbOT_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Pinaaǥi te ǥehem nu mid-eveleng te tanà is menge kuntada zey. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tenged te hizu nu he ebpedayun, mibpenguluwan nu is menge etew he midlibri nu. Pinaaǥi te zesen nu, egiyahan nu sikandan pehendiyà te segradu he ubpeey nu. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Egkezineg heini te zuma he menge nasyun ne egkerkeren sikandan te kegkahandek. Utew egkeherati is menge Filistihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Is menge pengulu te Edom wey Moab, egkeheratan utew te kegkahandek, ne is pengulu ziyà te Canaan, ne edliyasen te kegkahandek. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","“Uya, utew sikandan egkulbai. Pinaaǥi te ǥehem nu ebpeketireneb sikandan iring te vatu, taman te nekesaǥad en is menge etew he midlibri nu. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ed-uwiten nu is menge etew nu ziyà te tanè nu, wey ibpeubpè nu sikandan diyà te vuntud he migaked nu– kes lugar he mibeelan nu he ed-ubpaan nu, Nengazen, kes baley nu he iyan ka mismu mibaal. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Edhadì ka, Nengazen te wazà pidtemanan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Midlened te Nengazen is menge kudà te hadì te Ehipto wey is menge kerwahi wey is menge pereuntud te kudà dutun te kebpekerapes te menge Israilihanen duen te memaza he tanà duen te teliwazà te zaǥat. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Si Miriam is etevey ni Aaron he ebpeneuven te Megbevayà, migkuwa sikandin te tamburin, ne iyan sikandin midhuna te menge vahi te kedtukar te tamburin ne nemenayew sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ne migkentahan ni Miriam sikandan te heini he kanta: “Kentahi niw is Nengazen, su utew sikandin mezeeǥen. Insinumag din diyà te zaǥat is menge kudà wey is nemen-untud kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ne puun dutun te Zaǥat he Meriǥà, miduma ni Moises is menge Israilihanen pehendiyà te sibsivayan he Shur. Ne seled te tetelu he andew is kedhipanew zan dutun te sibsivayan ne wazà wahig he neturedu zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Hein nekeuma sikandan diyà te Mara, duen dutun wahig, piru wazà sikandan mekeinum su mepait haazà is wahig. (Ne iyan haazà hinungdan te kegngezani zutun te Mara su iyan ibpesavut te Mara is mepait.) ");
INSERT INTO mbbOT_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ne mibegulbul is menge Israilihanen diyà te ki Moises he ke sikandan te, “Hengkey is egkeinum tew?” ");
INSERT INTO mbbOT_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ne nengemuyù si Moises diyà te Nengazen, ne zuen riag he impaahà kandin te Nengazen. Intimbag ni Moises haazà dutun te wahig ne mibmeemis haazà is wahig. Ne zutun te Mara migezaman sikandan te Nengazen ne zutun din daan iveǥey is sulunuzen wey suǥù din kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ke sikandin te, “Emun ebpurungan niw ebpemineǥa is lalag ku te Nengazen he Megbevayè niw, wey emun iyan niw ebeelan is mid-isip ku he hustu, wey emun daan kenè niw ebey-anan is menge sulunuzen wey menge suǥù ku, kekenà, ebpezumdumahan niw, ne kenè ku sikiyu ebpeeǥiyan te minsan hengkey he zaru he impaaǥi ku ziyà te Ehipto, su iyan a is Nengazen ebawì keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ne hein mid-uman dan medhipanew nekeuma zan diyà te Elim, ne zuen mulà dutun 12 he menge serebseb wey 70 he kayu he palma, ne migkampu sikandan dutun te uvey te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Puun te Elim, ne midhipanew is tivuuk he keet-etawan te Israel taman te nekeuma zan diyà te sibsivayan te Sin, he nekepetug-elang te Elim wey Sinai. Nekeuma zan diyà hein ike-15 he andew zuen te ikezuwa he vulan te tuig puun te ked-awè dan diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Diyà te sibsivayan midriklamu ziyà te ki Moises wey ki Aaron haazà is langun he menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ke sikandan te, “Deyzey pa ke ziyè key zà himetayi te Nengazen hein diyè key pa te Ehipto. Diyà, ne ebayèbayè key te minsan hengkey he egkekaan dey. Piru ǥuntaan, mid-uwit key kayi keniyu te sibsivayan wey key mengeumes.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ne migkaǥi is Nengazen diyà te ki Moises te, “Pemineg ka! Ibpeuzan ku te egkekaan he ebpuun diyà te langit para keniyu. Kada andew ne mebpengamì is menge Israilihanen te egkekaan dan he para zà te haazè dà he andew. Pinaaǥi kayi egezaman ku sikandan ke ebeelan dan be is ibpemeveelan ku kandan wey ke kenà. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Keǥiyi nu sikandan he dubliya zan is edtiǥumen dan he egkekaan te ikeenem he andew te kada simana.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Umbe, migkeǥiyan ni Moises wey ni Aaron is langun he menge Israilihanen te, “Kengkuwan te mezukilem, egktuenan niw he iyan is Nengazen mibpeǥawas keniyu puun diyà te Ehipto, ");
INSERT INTO mbbOT_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ne zutun te meselem egkeehè niw is mekeǥeǥehem he kebpekiduma te Nengazen. Su nezineg din en is menge riklamu niw. Hentei key is edriklemuwan niw? Is tutuu, is Nengazen, iyan edriklemuwan niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ne migkaǥi pa si Moises te, “Ebeǥayan kew te Nengazen te usa he egkekaan niw emun mezukilem wey emun meselem egkeveyangan kew te supas su nezineg din is kebegulbul niw ziyà te kandin. Ne egkesavut niw human he kenè key iyan mibegulbulan niw, kekenà, iyan is Nengazen. Hentei key ves is ebegulbulan niw?” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ne migkeǥiyan ni Moises si Aaron te, “Keǥiyi nu is tivuuk he keet-etawan te Israel he medhitindeg dan diyà te etuvangan te Nengazen su nezineg din is menge riklamu zan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ne zutun te kedlelaǥi ni Aaron te tivuuk he keet-etawan, midtengteng sikandan diyà te sibsivayan ne netik-ew zan maahà dutun is mekeǥeǥehem he kebpekiduma te Nengazen diyà te ǥapun. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nezineg ku is menge riklamu te menge Israilihanen. Keǥiyi nu sikandan te kada mezukilem ne ebpekekaan dan te usa ne kada meselem ne egkeveyangan sikandan te supas. Ne zutun egketuenan niw he iyan a is Nengazen Megbevayè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ne hein merusrusirem en, nenlepew is utew mahabet he menge piyuǥù diyà te migkempuwan dan ne samè dà kenà meketambun dutun te kampu zan. Ne hein meselem en, nengahames te zehemug is tanà dutun te migkempuwan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ne hein nemezahan en haazà is dehemug, duen neehè dan diyà te sibsivayan he memenipis he utew meputì. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ne wazè dan metueni ke hengkey haazà, umbe mibpein-inseey sikandan, ke “Hengkey heini?” Ne migkeǥiyan sikandan ni Moises te, “Iyan heini supas he imbeǥey te Nengazen diyà te kenyu he para egkekaan niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Migkaǥi is Nengazen he is kada sevaha keniyu ne medtiǥum sumalà te egkinehenglanen din: senge-ǥantang kada andew is para te sevaha he etew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Umbe nenguwa is menge Israilihanen dutun he keenen; is duma, mezakel is netiǥum dan ne is duma, ne zeisey zà. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ne hein migantang dan heini, is kada sevaha ne neketiǥum te tig senge-ǥantang. Is neketiǥum te zekelà ne wazà medsubra, ne is neketiǥum te zeisey ne wazà megkurang. Netengkaan dà is nekuwa te uman sevaha. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ne migkeǥiyan sikandan ni Moises te, “Kinahanglan he wazà medteǥana kayi para te sunud he andew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Iyan, is duma kandan ne wazà mebpezumazuma ki Moises, su midteǥenahan dan is sunud he andew. Piru midtagkey heini ne nerangug. Umbe nepeukan dan ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kada meselem ne ebpenguwa is uman sevaha kandan sumalà te egkinehenglanen din. Ne emun ebmeinit en is andew, egkengereney sikan is egkesamè dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hein ikeenem he andew, midtakep dan is migkuwa zan–menge zezuwa he ǥantang is para te sevaha he etew. Umbe midhendiyà is menge pengulu te ki Moises ne nenginginsè dan ke maan is midtakep. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ne migkaǥi si Moises diyà te kandan te, “Midsuǥù is Nengazen he kinahanglan he medhimeley kew keeselem su iyan Andew te Kedhimeley, sevaha he segradu he andew para te Nengazen. Umbe hilutua niw is egkesuatan niw te edhilutù; sevawi niw is egkesuatan niw te edsavew. Ne is egkesamà, ne iteǥana niw para keeselem.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Umbe inteǥana zan is nesamè dan para te sunud he andew su iyan man ibpeulaula kandan ni Moises, ne haazà wazà mulà merangug wey wazà daan tegkayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Dutun migkaǥi si Moises diyà te kandan te, “Keena niw heeyan guntaan he andew. Wazà guntaan egkengeulug he keenen su iyan heini Andew te Kedhimeley he insuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Penguwa kew kayi he keenen seled te heenem he andew, piru te ikepitu he andew ne himeley kew. Heeyan he andew ne wazà ebpekepenguwa te egkekaan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Piru zuen ded gihapun migawas dutun te ikepitu he andew su ebpenguwa zutun he keenen, piru wazà neehè dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ne migkaǥi is Nengazen diyà te ki Moises te, “Sengemenu keluǥayad is kedsupaka kayi te menge etew te menge suǥù ku wey menge penurù ku? ");
INSERT INTO mbbOT_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tentenuzi niw he mibeǥayan ku sikiyu te Andew te Kedhimeley, umbe kada ikeenem he andew ne edubliyen ku is menge egkekaan niw para te zezuwa he andew. Kinahanglan he is kada sevaha, ne med-ubpà diyà te seled te valey zin emun ikepitu he andew. Wazà medliǥawang te kebpenguwa te egkeenen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Umbe, midhimeley haazà is menge etew zutun te ikepitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Migngezanan haazà te menge Israilihanen he ‘manna’. Iring heini te zeisey he lisu ne meputì, ne meemis iring te menipis he menge supas he midsevukan te teneb. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Migkaǥi si Moises te, “Iyan heini suǥù te Nengazen: Taǥù kew te senge-ǥantang he ‘manna’, para te peleebuten he egkelapislapis he menge kevuwazan, para meehè dan is keenen he imbeǥey ku keniyu ziyà te sibsivayan hein impeǥawas ku sikiyu puun diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ne migkeǥiyan ni Moises si Aaron te, “Kuwa ka te umuy ne teǥui nu te senge-ǥantang he ‘manna.’ Ne isavuk nu heini ziyà te etuvangan te Nengazen para te peleebuten he menge lapis te kevuwazan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ne midtuman ni Aaron haazà is insuǥù te Nengazen ki Moises. Midtaǥù si Aaron te ‘manna’ ziyà te Kavan te Kebpekid-uyun su para egketipiǥan heini. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Migkaan is menge Israilihanen te ‘manna’ seled te 40 he tuig, taman te nekeuma zan diyà te tanà he ed-ubpaan dan he iyan is Canaan. ");
INSERT INTO mbbOT_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Kada andew ebpumpun is kada sevaha kandan te senge-ǥantang he ‘manna’.) ");
INSERT INTO mbbOT_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sumalà te suǥù te Nengazen, mid-awà is tivuuk he keet-etawan te Israel ziyà te sibsivayan he Sin ne midlaus dan te kedhipanew zan. Neketulung en sikandan mekahalinhalin taman te nekeuma zan diyà te sevaha he lugar. Ne ziyè dan megkampu te Refidim, piru wazà wahig he egkeinum diyà. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Umbe midtebek dan si Moises ke sikandan te, “Beǥayi key te wahig he egkeinum dey.” Ne midtavak si Moises te, “Maan is edtebeken a keniyu? Maan is egezaman niw is Nengazen?” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Piru egkengemezahan utew haazà is menge etew zutun, umbe mibpedayun is kedriklamu zan diyà te ki Moises. Ke sikandan te, “Maan is impeǥawas key pa kenikew ziyà te Ehipto? Ebpematey key zè bes te kegkemezahi kayi duma te menge anak dey wey menge uyaǥen dey.” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ne zutun mibuyù te tavang si Moises diyà te Nengazen, “He Nengazen, hengkey is ebeelan ku kayi te menge etew? Samè dà kenè e zan penulenga te vatu!” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Midtavak is Nengazen diyà te ki Moises te, “Kuwaa nu is tuked nu he inlagkut nu te Wahig he Nilo, ne huna ka te menge etew. Dumaha nu is duma he menge ebmeǥurangen te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Edtaǥazan ku sikew ziyà te vatu ziyà te Horeb. Emun dutun ke en, legkuta nu haazà is batu, ne edtudà puun dutun is wahig su wey zuen egkeinum keniyan te menge etew.” Ne mid-ulaula ni Moises haazà dutun te etuvangan te menge edumala te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ne haazà he lugar migngezanan, ni Moises te Masa wey Meriba, su geina te zutun sikandin tebeka te menge Israilihanen wey migezaman dan is Nengazen pinaaǥi te kegkaǥi te, “Midumahan kiw ve te Nengazen etawa wazà?” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Midsurung te menge Amalikanhen is menge Israilihanen hein diyè dan pa te Refidim. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ne migkaǥi si Moises diyà te ki Josue te, “Pilì ka te menge sakup tew kayi he ebpekidtebek keniyan te menge Amalikanhen. Ne keeselem edhitindeg a ziyà te vuvungan is egkulang duen te tuked te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Umbe, mibpekidtebek ensi Josue te menge Amalikanhen sumalà te insuǥù kandan ni Moises hein kemulu pa si Moises, si Aaron, wey si Hur edtekezeg diyà te vuvungan. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ne zutun te imbayew ni Moises is menge velad din, nekezaag is menge Israilihanen, iyan, emun ibpezizalem din is menge velad din, ne iyan ebpekezaag is menge Amalikanhen. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ne hein neuǥet en ne neveley en is menge velad ni Moises. Umbe migkuwa si Aaron wey si Hur te vatu ne zutun dan ipepinuu si Moises. Ne mibpeziveluyà si Aaron wey si Hur is egawed te menge velad ni Moises taman te kedsanlep te andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Umbe nezaag eni Josue is menge Amalikanhen. ");
INSERT INTO mbbOT_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ne migkaǥi is Nengazen diyà te ki Moises te, “Isurat nu heini zuen te libru para kenà heini melipati ne ipehibelu nu heini ki Josue: Edezeetan ku is menge Amalikanhen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ne mibaal si Moises te pemuhatà he migngezanan din te, “Iyan Bendirè ku te Kezeeǥan is Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ke sikandin te, “Tenged te impaahà te menge Amalikanhen is kedsukul zan te Nengazen, ne kenà ed-engkezan te Nengazen te edtebek is menge Amalikanhen taman te taman.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Si Jetro, sikan is memumuhat diyà te Midian he enuǥang ni Moises, netudtulan sikandin te langun he mid-ulaula te Megbevayà diyà te ki Moises wey ziyà te menge etew zin he menge kevuwazan ni Israel. Nezineg din ke mibmenumenu te Nengazen is kebpeǥewasa zin te menge Israilihanen puun te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Hein aney, impeulì ni Moises is esawa zin he si Sipora wey sikan is dezuwa he anak dan he menge maama ziyà te ki Jetro he enuǥang din. Is ngazan te sevaha he anak dan iyan si Gershom, su ǥeina te in-anak sikandin te timpu te kegkelumelengyawà ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ne is sevaha pa, migngezanan din te Eliezer su geina te iyan edtavang kandin is Megbevayà he ed-ezapen te kepuun din; ne iyan midlibri kandin wey kenà sikandin mepatey te hadì te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ne midhendiyà si Jetro, wey is esawa ni Moises he si Sipora wey sikan is dezuwa he anak dan te kampu eni Moises diyà te sibsivayan he uvey te vuntud te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Daan he mibpeuwitan ni Jetro si Moises te lalag he edhenduen te, “Siak is enuǥang nu he si Jetro, ebpekeuma a ziyan, ne zuma ku is esawa nu wey is dezuwa he anak nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ne tenged kayi midsinuǥung ni Moises is enuǥang din diyà te ǥawas ne midluhud sikandin diyà te etuvangan te enuǥang din wey midhezekan din daan. Ne mibpeinseey sikandan mehitenged te kebpekesavuk te uman sevaha kandan, ne zutun midseled dan diyà te tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ne zutun midtultul ni Moises diyà te enuǥang din is minsan hengkey he mid-ulaula te Nengazen diyà te hadì te Ehipto, wey ziyà te zuma pa he menge Ehiptohanen he para te keupiyaanan te menge Israilihanen. Midtudtul zin is langun he menge mereǥen he nengeseǥazan dan diyà te imbayè dan wey is menge vaal te Nengazen te kedlibri kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ne ingkelipey ni Jetro is langun he meupiya he menge paaǥi te Nengazen te kedlibriya zin te menge Israilihanen para kenà mekezezaat kandan is menge Ehiptohanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ke sikandin te, “Idalig tew te Nengazen is kedlibriya zin keniyu ziyà te ǥehem te menge Ehiptohanen wey te hadì dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Guntaan, netuenan ku en he utew lavew he gemhanan is Nengazen kenà te langun he ed-ezapen, su midlibri zin is menge Israilihanen te kedèdaaǥa kandan te menge Ehiptohanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ne si Jetro he enuǥang ni Moises, nemuhat diyà te Megbevayà te pemuhat he edtutungen wey zuma he menge ibpemuhat diyà te Megbevayà. Ne zutun te kemulu zin en ebeeli haazà, ne nekeuma si Aaron wey is langun he menge edumala te Israel. Ne migkaan dan duma ki Jetro zutun te etuvangan te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ne zutun te sunud he andew, mibpinuu si Moises is ebpenhusey wey edsambag te menge etew, ne nehepunan is kedliǥuyi kandin te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ne hein naahà ni Jetro is langun he mibeelan ni Moises dutun te menge etew, migkeǥiyan din si Moises te, “Maan is ebeelan nu heini kayi te menge etew? Maan is sebsevaha nu is ebaal kayi? Edlinya is menge etew kayi te etuvangan nu puun pa te meselem taman en te ebmerusrusirem en.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ne midtavak si Moises te, “Geina te ed-uvey sikandan kayi te kediey su id-insè dan ke hengkey is egkesutan te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ne emun duen menge kesevaan dan, idangep dan kayi te kediey, ne edhusayen ku sikandan ke hentei kandan is ebpekevenar. Ne ibpenurù ku kandan is menge suǥù wey menge sulunuzen he ibpesunud te Megbevayà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ne migkaǥi si Jetro te, “Kenà meupiya heeyan is paaǥi nu te kedhimuwa nu kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mibeelan nu is kegkereǥeni nu wey kayi te menge etew. Utew mereǥen heini ke iyan ke zà. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Pemineǥa a kenikew ǥuntaan su edsembaǥan ku sikew, ne verakat he zumahi ka te Megbevayà. Leusa nu is ked-ul-ulaha nu te ked-uvey ziyà te Megbevayà para te menge etew. Izangep nu ziyà te kandin is kesevaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ipelaus nu is kebpenurù nu kandan te menge suǥù wey menge sulunuzen he ibpesunud te Megbevayà. Penurua nu sikandan te paaǥi te kebpengungubpaan wey minsan hengkey he ebeelan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Iyan, pilì ka te metau he menge etew he ebpekeuǥup kenikew te kebpenhusey nu. Kinahanglan he metau sikandan he edhusey, edtahud te Megbevayà, egkeseriǥan, ne kenà edawat te sipsip. Himuwa sikandan he menge zatù te menge grupu te menge etew he tig-1,000, tig-100, tig-50 wey tig-10. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ebpenilbi sikandan he menhuhusey te langun he timpu. Iyan sikandan ebpenhusey te minsan hengkey he melemu zà he menge samuk, iyan, is mereǥen he menge samuk, ne ziyè dan idangep te kenikew. Ne heini he paaǥi, ebmahagkap is menge vaal nu te kedtavang kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Netuenan ku he iyan heini egkesuatan te Megbevayà he ebeelan nu; emun ed-ul-ulahan nu heini ne kenè ka egkereǥenan. Ne heini he menge etew. Ne zutun, melinawen is kebpekeulì kayi te menge etew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ne mibpezumdumahan ni Moises haazà is sambag te enuǥang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mibpilì sikandin te menge Israilihanen te menge etew he uluwanen he edhusey, ne midhimu zin sikandan he menge upisyal te grupu te menge etew he tig-1,000, tig-100, tig-50, wey tig-10. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nenilbi sikandan te menge etew he iyan menge zatù te langun he timpu. Iyan sikandan edhusey te menge melemu zà he menge samuk, iyan, is menge mereǥen he menge samuk ne idangep dan diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ne impeulì ni Moises is enuǥang din diyà te nasyun din. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Mid-awà is menge Israilihanen diyà te Refidim ne midhendiyè dan te sibsivayan he Sinai. Diyà sikandan megkampu te egkesineruwan te vuntud. Iketelu haazà he vulan te ked-awè dan diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ne midtekezeg si Moises diyà te vuntud su ebpekidhinguma te Megbevayà. Mid-umew sikandin te Nengazen he edhenduen te, “Iyan heini keǥiya nu ziyà te menge Israilihanen he kevuwazan ni Jacob: ");
INSERT INTO mbbOT_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Neehè niw is mibeelan ku ziyà te menge Ehiptohanen, wey ke mibmenumenu ku sikiyu te ked-uwita ku keniyu zini te kediey, iring te ked-uwit te kulaǥu te menge pispis din he ebpengelangan din te menge pakpak din. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Emun ebpurung kew ebpezumazuma kedì wey edsunud kew te kebpekid-uyun ku keniyu, ebpilien ku sikiyu kayi te langun he menge nasyun he egkehimu he menge pinilì he menge etew ku. Kedì is tivuuk he kelibutan, ");
INSERT INTO mbbOT_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","piru egkehimu kew he ǥaked ku he pinilì he menge etew, ne egkehimu kew he ginhedian he ebpenilbi kediey pinaaǥi te kegkememumuhat niw.’ Iyan heini keǥiya nu ziyà te menge Israilihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ne tenged dutun midtupang si Moises he ebpuun diyà te vuntud ne midtawag din is menge edumala zutun te menge Israilihanen ne midtudtulan din sikandan dutun te migkaǥi kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mid-uyun haazà is langun he menge Israilihanen te migkaǥi kandan ni Moises ne ke sikandan te, “Edtumanen dey is langun he insuǥù kenami te Nengazen.” Ne midtudtul ni Moises diyà te Nengazen is tavak te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Migkaǥi is Nengazen diyà te ki Moises, “Edhendiyà a te kenikew pinaaǥi te mekepal he ǥapun su wey mezineg keniyan te menge etew is kebpekidlalag ku kenikew. Ne zutun ebpekesarig sikandan layun kenikew.” Hein neipus ni Moises te egkaǥi ziyà te Nengazen is menge tavak te menge etew, ");
INSERT INTO mbbOT_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","migkaǥi pa is Nengazen diyà te kandin te, “Hendiyè ka te kandan ne keǥiyi nu sikandan he mebpekelumpiyu sikandan guntaan wey keeselem. Kinahanglan he pemìpii zan is menge visti zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Sigureduwa nu he andam sikandan dutun te iketelu he andew, su zutun he andew, siak is Nengazen, ebulus a kayi te Buntud he Sinai ne egkaahà a te langun he etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Teltali niw is peliǥuy kayi te vuntud te edtemanan te menge etew. Keǥiyi nu sikandan he kenè dan medtekezeg etawa med-uvey zutun te lugtenaan dutun te vuntud. Is minsan hentei he ed-uvey kayi te vuntud ne edhimetayan, ");
INSERT INTO mbbOT_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","etew man etawa uyaǥen. Edhimetayan pinaaǥi te kedtuleng te vatu etawa kebpanà; ne wazà kayi egawed. Egkehimu he edtekezeg is menge etew kayi te vuntud emun egkezineg is meluǥayad he kebpezeǥinga te vudyung.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ne zutun midtupang si Moises puun dutun te vuntud ne midsuǥù din is menge etew he mebpekelumpiyu. Ne mibpemìpian dutun te menge etew is menge visti zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Migkeǥiyan ni Moises sikandan te, “Pengandam kew para te meketelu ǥuntaan; kenè niw en dèpa hileveti is esawa niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ne hein meselem dutun te iyan en iketelu he andew, nemeransì wey egkeserasab is kilat, ne zuen mekepal he ǥapun he nekeselikuvung dutun te vuntud, ne egkezineg dutun is utew mezaǥing he vudyung. Ne tenged kayi, migkerker te kegkahandek is langun he menge etew ziyà te kampu zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ne miduma ni Moises haazà is menge etew ziyà te gawas te kampu su ebpekidhinguma zan te Megbevayà, ne ziyà sikandan medhitindeg te lugtenaan duen te vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ne neselikuvungan te evel haazà is Buntud he Sinai su mibulus is Nengazen dutun pinaaǥi te hapuy. Midlipuwak is evel zutun he iring te evel te utew zekelà he rapug, ne nehuyung haazà is tivuuk he vuntud, ");
INSERT INTO mbbOT_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ne mid-iseg is daǥing dutun te vudyung. Mibpekidlalag si Moises te Megbevayà ne nezineg dan daan is laǥeng te Megbevayà pinaaǥi te mezesen he ruǥung. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mibulus is Nengazen dutun te puntur te Buntud he Sinai, ne zutun migkeǥiyan din si Moises he medtekezeg dutun te puntur te Buntud. Umbe midtekezeg si Moises ");
INSERT INTO mbbOT_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ne migkeǥiyan sikandin te Nengazen te, “Tupangi nu is menge etew ne petizeeni nu sikandan he kenè dan medrapas duen te taltal zuen te nekepeliǥuy zuen te vuntud su ed-ahaan ku. Su emun ebeelan dan heini, mahabet kandan is ebpatey. ");
INSERT INTO mbbOT_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Minsan is menge memumuhat he layun ed-uvey kayi te kediey kinahanglan he mebpekelumpiyu sikandan te keugelingen dan su emun kenà, ne edsilutan ku sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ne migkaǥi si Moises diyà te Nengazen te, “Kenà ebpekehimu is menge etew te kedtekezeg kayi te vuntud su mibpetizeenan key man kenikew he isipa zey he utew segradu he lugar heini is buntud, ne mibpeteltalan nu kenami is ebpekeliǥuy kayi he kenè dey edrepasen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ne midtavak is Nengazen te, “Tupang ka ne veyai nu si Aaron ne zumaha nu kayi. Piru sikan is menge memumuhat wey is kezekelan, ne kenè nu mulà ipehengkayi te kediey. Su emun edteǥel zan edhengkayi, ne edsilutan ku sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Umbe, midtupangan ni Moises ne migkeǥiyan din is menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ne migkaǥi is Megbevayà, ");
INSERT INTO mbbOT_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Iyan a Nengazen he Megbevayè niw, iyan a mibpeǥawas keniyu ziyà te Ehipto he zutun kew uripena. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kenè kew med-azap te zuma he ed-ezapen gawas kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kenè kew mebaal te ed-ezapen he ledawan te minsan hengkey he ziyà te langit, wey minsan hengkey he kayi te tanà, wey ziyà te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kenè kew mebpenilbi wey med-azap kayi; su siak, is Nengazen, iyan a Megbevayè niw, ne kenà a egkesuat he zuen pa zuma he ed-ezapen niw. Edsilutan ku is menge nekesalà kedì, apil en is menge kevuwazan dan taman te iketelu wey ikeepat he lapis te kevuwazan dan he midselikwey kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Piru ibpeehè ku is keupiya ku ziyà te mahabet he lapis te kevuwazan he ebmahal kedì wey edtuman te menge suǥù ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Kenè niw ǥemita is ngazan ku te wazè din pulus, su siak is Nengazen he Megbevayè niw, edsilut te minsan hentei he egamit te ngazan ku te wazè din pulus. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Tumana niw is ebpeveelan ku zutun te Andew te Kedhimeley, ne isipa niw haazà he segradu he andew para kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Terebahu kew seled te heenem he andew, ");
INSERT INTO mbbOT_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","iyan, is ikepitu he andew he iyan Andew te Kedhimeley ne isipa niw he para heeyan kediey, kes Nengazen he Megbevayè niw. Dutun he andew ne kenè kew medterebahu te minsan hengkey. Kinahanglan daan he kenà medterebahu is menge anak niw, menge suluǥuen niw, wey minsan is kenà menge Israilihanen he mid-ubpà diyà te inged niw. Kenè niw zaan iterebahu is menge ayam niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Su seled te heenem he andew is kebeeli ku te langit, tanà, daǥat, wey te langun he menge seled dutun, ne midhimeley a hein ikepitu en he andew. Ne mibpenubtuvazan ku haazà is Andew te Kedhimeley ne midhimu ku he segradu he andew para kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Tehuza niw is amey niw wey iney niw, su para luǥeyazi kew te untung ne egkeuǥet is ked-ubpè niw zutun te tanà he ibeǥey ku keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kenè kew mebunù. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kenè kew mebpengumpadi. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kenè kew mebpenakew. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kenè kew medtarùtarù diyà te hukmanan te kedezaat te zuma niw he etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kenè niw meimahi is baley te zuma niw, etawa esawa te zuma, menge suluǥuen, menge uyaǥen dan, wey minsan hengkey he ǥaked dan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ne hein nezineg duen te menge etew is beransì, wey zaǥing te vudyung, wey hein neehè dan is egkeserasab he kilat, wey evel zutun te vuntud, migkerker sikandan te kegkahandek dan, ne mibpekeziyù sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ne migkeǥiyan dan si Moises te, “Ebpemineg key minsan iyan ke zà ebpekidlalag kenami ne kenè nu en iyan ipepekidlalag kenami is Megbevayà su kela ke mebpemematey key.” ");
INSERT INTO mbbOT_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ne migkeǥiyan sikandan ni Moises te, “Kenè kew mahandek su ibpeehè dà keniyu te Megbevayà is mekahandekhandek he ǥehem din su wey kew meteǥui te zekelà he kedtahud kandin, su para kenè kew mekesalà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Wazà med-awà is menge etew zuen te nepunduwan dan, ne si Moises mulà mid-uvey zuen te mekepal he ǥapun he zutun is Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ne migkeǥiyan te Nengazen si Moises te, “Keǥiya nu ziyà te menge Israilihanen heini is lalag ku ziyà te kandan he edhenduen: Neehè niw is kebpekidlalag ku keniyu puun diyà te langit. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kenè kew mebaal te ledawan he ed-ezapen niw zaan iring te ked-ezapa niw kedì, kenè kew mebaal te ledawan he pelata wey ledawan he vulawan he ed-ezapen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Baal kew te tanà he pemuhatà he iyan ebpemuhatan niw kediey, ne zutun niw ipemuhat is menge kerehidu niw, menge kambing, wey menge vaka he pemuhat he edtutungen wey pemuhat he para te meupiya he kedepità. Ne veeli niw heini ziyà te lugar he mibpilì ku he zutun a ed-ezapa, ne edhendutun a is ebpenuvadtuvad keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Emun ebaal kew te pemuhatà he vatu para kediey ne kenè niw heini vesbasi, su emun egemitan niw heini te gelemiten he para ibasbas, ne kenè en heini ereg he egemiten para te kebpemuhata kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ne kenè kew pemenahik dutun te pemuhatà pinaaǥi te heǥezan su wey kenà mesiniling is id-eelesè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Migkaǥi is Nengazen diyà te ki Moises, “Iyan heini menge sulunuzen he ibpetuman nu te menge Israilihanen: ");
INSERT INTO mbbOT_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Emun duen ebpemasa te uripen he Hebriyuhanen, kinahanglan he seled dà te heenem he tuig is kebpesilbiya zin dutun diyà te kandin. Ne zutun te ikepitu he tuig, kinahanglan he ed-engkezan din en te ed-uripen, ne kenè en ibpevayad te minsan hengkey. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Emun wazè din esawa zutun te timpu te kegkeuripena kandin ne zutun en sikandin mekepengesawa te uripen en sikandin, ne iyan dà sikandin ebpekeǥawas te kegkeuripen dutun te ikepitu he tuig. Iyan, emun duen din en esawa zutun te kegkeuripena kandin, ne ebpekeǥawas haazà is esawa zin duma kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ne emun impepengesawa sikandin te egalen din dutun te timpu he kemulu en sikandin uripen, ne is bahi wey is menge vatà, ne egketaǥak dan dutun te egalen dan, umbe iyan dà ebpekeǥawas te kegkeuripen haazà is maama. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Iyan, emun egkaǥi haazà is maama te, ‘Kenà a egawas te kegkeuripena kedì su mahal ziyà te ǥehinawa ku is egalen ku, esawa ku wey is menge anak ku.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Emun iyan haazà, kinahanglan he ed-uwiten sikandin dutun te egalen din diyà te menge zatù. Ne ed-uwiten sikandin diyà te marku te ǥemawan ne ebusluwen is telinga zin. Ne egkehimu sikandin he uripen dutun te egalen din taman te kemetayen din.” ");
INSERT INTO mbbOT_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ne emun ibpeuripen te maama is anak din he vahi pinaaǥi te kebelegyaa zin dutun, ne kenà iring te paaǥi te kebpekeǥawas te maama he uripen is paaǥi te kandin he kebpekeǥawas te kegkeuripen su kenà mulà sikandin ebpekeǥawas dutun te ikepitu he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ne emun kenà sikandin ebpekepenunuat dutun te egalen din he teǥiuripen kandin, kinahanglan he velukasi sikandin te pemilya zin. Iyan, wazè en ketenged dutun te egalen te kebelegyà dutun te vahi ziyà te menge lumelengyawà su iyan haazà is egalen midsupak te kuntrata. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ne emun ibpeesawa te egalen is uripen din he vahi te anak din he maama, kinahanglan he kenè din en ed-isipen he uripen haazà is bahi, kekenà, isipa zin en he anak din. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ne emun eduwayan sikandin dutun te esawa zin, kinahanglan he kenà egkahalin is ked-elimahi zin dutun te kakey he esawa zin pinaaǥi te keenen, pemisti, wey kedhuliza kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ne emun kenè din heini igkeveǥey zutun te kakey he esawa zin is tetelu he kelasi, ne ebpekeǥawas en haazà is bahi te kegkeuripena kandin ne kenè ne kinahanglan he ebayad sikandin te selapì. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Sikan is ebpekepatey te zuma zin he etew, kinahanglan daan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Iyan, emun wazè din tivevaa is kegkepetaya zin dutun, kekenà, nevèbeelan is kegkehitevua zutun su tenged te imbanglis ku, ne egkehimu sikandin he ebpelaǥuy ziyà te lugar he idteǥana ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Iyan, emun duen edhimatey te zuma zin he etew pinaaǥi te akal, ne minsan diyè pa sikandin mebpelaǥuy te pemuhatà para kediey, iawè niw zutun ne himetayi niw ziyà te gawas. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Is minsan hentei he ebuǥel etawa ebpalì te amey zin etawa iney zin, kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Is minsan hentei keniyu he egebpà te sengeeetew su ibelegyè din, ne minsan wazè din pa haazà ikevelegyà dutun te kegkezekepi kandin, kinahanglan he edhimetayen sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Is minsan hentei keniyu he edrawak te amey zin etawa iney zin, kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Emun duen ebpetebekà, ne is sevaha egkepelian etawa egkeruuǥan pinaaǥi te vatu etawa pinaaǥi te sumbag, iyan, kenà sikandin ebpatey, kekenà, kenè dà sikandin ebpekehimu he edterebahu seled te egkepipira he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Ne emun ebpekeenew en wey ebpekehipanew en minsan pa ke edtutuked dà, ne iyan dà silut duen te etew he nekevaal zuen is: ebpeveyazan kandin is menge timpu te kegkeetresadu zutun te sevaha, ne etimana zin taman te egkepurung haazà egkeulii. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Emun duen ebpukpuk te uripen din he maama etawa vahi ne edsilutan sikandin emun ibpatey zutun te uripen haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Iyan, emun kenà ibpatey zutun te uripen haazà is kebpukpuka kandin ne ebpekeenew heini, kenà edsilutan haazà is egalen su ǥaked din man haazà is uripen. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Emun duen maama he ebpetebekà he tenged dutun duen meǥingey he egkesazir he tenged dutun egketeǥel is kebpekaanak din iyan, kenè ded utew ebpekezezaat kandin haazà, ne haazà is nekesazir kandin kinahanglan he ibpevayad sumalà is ibpevayad te teǥiesawa zuen te vahi he ebpezumdumahan te menge zatù. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Iyan, emun grabi is kegkesazir zin ne iyan heini kukuman he ikula niw: Is ebpekepatey edhimetayan daan. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Is ebpekezezaat te mata te zuma zin edezeetan daan is kandin he mata, is ebpekesepù te ngipen te zuma zin edsepuan daan, is ebpekezezaat te velad te zuma zin edezeetan daan is kandin he velad, is ebpekezezaat te paa te zuma zin edezeetan daan is kandin he paa. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Sikan is edtutung te zuma zin, ne edtutungen daan. Sikan is ebpalì te zuma zin, ne ebpelian daan. Ne sikan is ebuǥel te zuma zin, ebuǥelen daan. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Emun duen ebpekezezaat te mata te uripen din he maama etawa vahi, ne iyan bayad dutun is: ebpekeǥawas haazà is uripen te kegkeuripena kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ne emun duen ebpekesepù te ngipen te uripen din, ne iyan ded bayad dutun is ebpekeǥawas haazà is uripen te kegkeuripena kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Emun duen baka he ebpekesungey te maama etawa vahi ne ebpatey haazà is egkesungey, kinahanglan he edhimetayan haazà is baka pinaaǥi te kebpenulenga zuen te vatu, ne kenà haazà egkeenen. Ne kenà edsilutan is teǥiǥaked dutun te vaka. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Iyan, emun daan he vetasan dutun te vaka is kebpemenungey ne nepetizeenan en is teǥiǥaked duen, iyan, mibpesagdan din dà, ne emun ebpekepatey haazà is baka te maama etawa vahi, kinahanglan he edhimetayan haazà is baka wey is teǥiǥaked duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Iyan, emun ebpevayad dà is menge kezumahan dutun te nepatey, ne kenè ne edhimetayan haazà is teǥiǥaked piru kinahanglan he ebeyazan din is ibpevayad kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Iyan ded heini velaud emun batà he maama etawa vahi is ebpatey te kegkesungayi kandin te vaka. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ne emun iyan ebpatey te kegkesungayi kandin te vaka is uripen he maama etawa vahi kinahanglan he ebayad is teǥiǥaked dutun te vaka ziyà te teǥiuripen dutun te 30 he vuuk he pelata, ne edhimetayan haazà is baka pinaaǥi te kebpenulenga zuen te vatu. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Emun duen edluwisen din is tambun te vudsi etawa ebangbang sikandin, ne kenè din edtembunan ne egkeulug dutun is baka etawa asnu, ");
INSERT INTO mbbOT_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kinahanglan he ebeyazan duen te teǥiǥaked te vudsi haazà is ayam he neulug, ne kandin en haazà is minatey he uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ne emun duen etew he ebpekepatey is baka zin te vaka te zuma zin, ne ivelegyè dan haazà is uuyag ne liwezaa zan te ebahin is halin dutun. Liwezaa zan daan te ebahin haazà is minatey he uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Iyan, emun daan he vetasan dutun te vaka is kebpemenungey ne mibpesagdan duen te teǥiǥaked, kinahanglan he edliwanan din haazà ne kandin en sikan is minatey. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Emun duen edtakew te vaka etawa kerehidu he edlepaan din etawa ibelegyè din, ne is sevaha he vaka ebpeliwanan kandin te lelima he vaka, ne is sevaha he kerehidu ebpeliwanan kandin te heepat he kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Emun mezukilem, ke zuen tekawen he egkabra te elavat su wey mekeseled ne zutun nepatey sikandin, ne kenà salà dutun te nekepatey is kegkepetaya zin duen te tekawen. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Iyan, emun maandew is kegkehitevua zutun ne zuen televaken dutun te nekepatey. “Kinahanglan he ibpevayad is tekawen, ne emun wazè din igkevayad ne ivelegyà sikandin su wey iyan ikevayad te tinakew zin is bali zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Emun egkesepenan diyà te kandin is tinakew zin he vaka, etawa asnu, etawa kerehidu, he uuyag pa haazà, kinahanglan he edtekepen is ibpevayad kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Emun duen uyaǥen te sevaha he etew he impaawè din ne neketabtab te pinemula te zuma, kinahanglan he ebeyazan din te pinekemeupiya he neraǥun din diyà te vevesukè din etawa pemuleey zin te paras. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Emun egketuvù is hapuy he edelandap diyà te meribpesen ne ebpekevinsul te menge inemung etawa wazè pa meǥarab, emun kenà ne sengeereduwan en, ne kinahanglan he ibpevayad sikan is midtuvù te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Emun duen ibpetipiǥan din is selapì din etawa mahal he menge azen din te sengeeetew, ne emun egketakew haazà puun dutun te impetipig ne ibpevayad te edtekepen is midtakew zutun emun egkezekepan. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Iyan, emun kenà egkezekepan sikan is tekawen ne sikan is impetipig, kinahanglan he ed-etuvang diyà te menge zatù su wey metueni ke migkuwa zin etawa wazà, is mibpetipiǥan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Is minsan hengkey he kesevaan mehitenged te kebpeeǥawà te azen iring te vaka, asnu, kerehidu, manggad, etawa minsan hengkey he netazin he zuma he azen he egkeeǥewaayan, ne iyan is menge zatù edhusey zutun. Ne sikan is egkeǥiyen dutun te menge zatù he iyan egkevenaran, ne ibpevayad te edtekepen is bali zuen te tekew zin en egekeza. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Emun ebpeelimahan din te zuma zin is asnu zin, baka zin, kerehidu zin, etawa zuma he kelasi te uyaǥen, ne emun ebpatey haazà, etawa egkeseziran, etawa egketazin, iyan, wazà netau ke maan, ");
INSERT INTO mbbOT_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ne egkehusey sikandan pinaaǥi te kedsesapà duen te impeelima ziyà te etuvangan te Nengazen he wazè din hanew ke maan is netazin haazà is mibpeelimahan kandin. Ne kinahanglan he edtuu zutun sikan is teǥiǥaked ne haazà is impeelima ne kenè en ibpevayad. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Iyan, emun midtakew haazà is uyaǥen, kinahanglan he ibpevayad sikan is mid-elima zuen. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ne emun mideesan te leew he langgam, kinahanglan he ed-uwiten duen te mid-elima is samà dutun, su wey maahà, su iyan haazà tuus he tutuu he nekeizan te leew he langgam. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ne emun duen edsambey te uyaǥen te zuma zin, ne haazà is uyaǥen egkesazir etawa ebpatey te wazà dutun sikan is teǥiǥaked, kinahanglan he ebayad haazà is midsambey. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Iyan, emun dutun sikan is teǥiǥaked ne kenà ibpevayad haazà is midsambey. Emun mibpilitiyan haazà is uyaǥen ne sikan is impiliti zuen iyan en kuwinta vayad. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Emun edlimbungan te maama is raǥa he wazè pa mekeǥuni ne edhilivetan din haazà, kinahanglan he ibeǥey zin diyà te lukes dutun te vahì is bayad te salè din, ne human ibpeesawa kandin haazà is bahi. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ne emun kenà ibpeesawa te amey zutun te vahi haazà is anak din kinahanglan gihapun he ibpevayad haazà is maama te sungguzanan he para te raǥa. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Himetayi niw is minsan hentei he veyilan. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Is minsan hentei he edtambid te ayam kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Is minsan hentei he kenè din iyan ebpemuhaten is Nengazen su iyan din ebpemuhaten is duma he ed-ezapen, kinahanglan he ebpurungan edèdeeti. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kenè niw luplupiǥa is lumelengyawà; kenè niw pesipelahi su nehimu kew zaan he lumelengyawà diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kenè niw dèdaaǥa is balu he vahi etawa ilu he vatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Emun ebeelan niw heini, ne ebpengemuyù sikandan kayi te kedì ne siguradu ebpemineǥen ku is pengemuyù dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Egkepeukan ku sikiyu emun edèdaaǥen niw is balu etawa ilu ne ebpengelinteuwan ku he mepatey kew te ǥumaan su wey mevalu is menge esawa niw, ne wey meilu is menge anak niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Emun ibpesambey niw te selapì is minsan hentei he etew ku he pubri, kenè niw pursintuwi iringi te ebeelan te zuma he ebpemesambey te selapì. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Emun idsandà te zuma niw is samput din, ne iulì niw ziyà te kandin te kenè pa edsanlep is andew, ");
INSERT INTO mbbOT_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","su iyan dà haazà idtambun din te lawa zin emun edlipezeng sikandin. Iulì niw su emun ebpengemuyù sikandin kayi te kediey ebpemineǥen ku sikandin su hihizuwen a. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kenè niw sumpelita is Megbevayà wey kenè niw rewaki is ebpengulu keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Kenè niw lipati is kebeǥey te halad kayi te kedì he ebpuun te neraǥun niw, menge vinu, wey menge lana. “Ipehinungud niw kedì is penganey he anak niw he menge maama. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ne iring ded kayi is ul-ulaha niw ziyà te menge vaka niw wey menge kerehidu niw. Is penganey he menge anak dan he meemahan, seled dà te pitu he andew is kebpezumaha niw zuen diyà te iney zin ne iveǥey niw en kediey zutun te ikewalu he andew pinaaǥi te kebpemuhata niw zuen. ");
INSERT INTO mbbOT_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Iyan kew menge etew he pinilì ku, umbe, kenè kew megkaan te usa te minsan hengkey he uyaǥen he midhimetayan te zumezaas he menge langgam. Isamak niw heini te menge asu. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kenè kew mebpenudtul te menge tarù. Kenè niw uǥupi is mezaat he etew pinaaǥi te kedtarùtarù. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kenè kew med-iring te kezekelan dutun te kebaal zan te mezaat. Emun duen idseysey niw ziyà te hukmanan, kenè niw tembuni is hustu minsan supak is kezekelan dutun te kegkaǥi niw te hustu. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kenè niw depiǥi is pubri ziyà te hukmanan tenged te hizu niw kandin dutun te kasu zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Emun egkeehè niw is baka etawa asnu te kuntada niw he nekaawà, kuwaa niw ne ihated niw ziyà te kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Emun egkeehè niw is asnu he edtundanen te ebpekigkuntada keniyu he egkelilid tenged te karga zin, kenè niw và dà seǥazi, kekenà, uǥupi niw sikandin wey mekehitindeg haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kenè niw limbungi ziyà te hukmanan is egkaayuayu. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kenè kew medsumbung te tarù he sumbung. Kenè niw hukumi te kemetayen is etew he kenà ereg he edhimetayan, etawa etew he wazà mekesalà, su edsilutan ku is minsan hentei he ebaal kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Kenè kew medawat te sipsip, su is sipsip iyan ebpekepelakap te etew su minsan netuenan din en is tutuu, edtuisen din gihapun is menge lalag te metazeng he etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kenè niw lupiǥi is lumelengyawà, su netuenan niw is kebpekesavuk te lumelengyawà su nehimu kew zaan he lumelengyawà diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Seled te heenem he tuig pemulai niw is menge tanè niw su wey kew sebpeta. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Piru zutun te ikepitu he tuig ipehimeley niw is tanè niw pinaaǥi te kenè niw zuen kedterebehuwa. Ne emun duen dutun ebpenuvù he egkekaan, ne haazà egkehimu he keenen te menge zuma niw he pubri, ne is egkesamè dan egkehimu he keenen te menge leew he langgam. Ne iringa niw zed daan kayi is pemuleey niw te paras wey pemuleey te ulibu niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Terebahu kew seled te heenem he andew, piru himeley kew emun ikepitu en he andew, su para mekehimeley zaan is menge vaka niw wey menge asnu niw, ragkes is menge uripen niw he neetew ziyà te keniyu, wey is kenà menge Israilihanen he zuma niw he meǥinged. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Purungi niw tumana heini is langun he migkaǥi ku keniyu. Kenè kew ampù diyà te zuma he menge ed-ezapen, ne kenè niw hisguti is ngazan dan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Seled te senge-tuig ketetelu kew medsilibra te pista he para te kebeǥey kedì te zengeg. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Silibraha niw is Pista te Supas he Wazè din Tapey. Seled te pitu he andew iyan niw keena is supas he kenà edtepayan, sumalà is insuǥù ku en keniyu. Ne netendek he timpu is ked-ul-ulaha niw kayi su ziyè dà te vulan he Abib, su iyan haazà bulan te timpu te ked-awè niw ziyà te Ehipto. Dutun he timpu kinahanglan he med-uwit te halad is kada sevaha keniyu kayi te kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Silibraha niw zaan is Pista te Kedraǥun pinaaǥi te kedhelaza niw kayi te kediey te egkehuna he menge sebpet niw ziyà te menge bevesukè niw. Ne elin daan silibriha niw is Pista te Tevas emun egkezerengdeng niw en is menge sebpet niw zutun te kegketapus te tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ne medtampu is menge maama keniyu te kada kegkaamur niw seled kayi te tetelu he pista su kinahanglan he ed-ezapen e zan is Nengazen he Egalen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Kenè niw ipemuhat kayi te kedì is lengesa he egkelepikan te minsan hengkey he edtepayan. Is tavà te uyaǥen he ibpemuhat niw kedì te pista, ne kenè niw itaǥak taman te meselem, kekenà, emina niw tutunga. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Uwita niw ziyà te valey te Nengazen he Megbevayè niw is kinemeupiyahan duen te egkehuna he egkeraǥun niw ziyà te tanè niw. “Kenè niw hilutua is nati he kambing te ǥatas te iney zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Edsuǥuen ku is belinsuǥuen ku he medhuna keniyu wey kew zin meventayi ziyà te ibayè niw, ne wey kew zin mezuma ziyà te lugar he mid-andam ku para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pemineǥa niw sikandin ne tumana niw is egkeǥiyen din. Kenè kew sukul kandin. Su is langun he ebeelan din, ebeelan din pinaaǥi te ngazan ku ne kenè din ebpekewezaan is menge salè niw, etawa kenè kew zin ebpeseyluwen te menge salè niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Emun ebpurungan niw ebpemineǥa is menge lalag din diyà te keniyu, ne edtumanen niw is langun he egkeǥiyen ku ziyà te keniyu, iyan a egkehimu he kuntada te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Edhuna ziyà te ibayè niw is belinsuǥuen ku ne edumahan kew zin diyà te tanà te menge Amorihanen, menge Hitihanen, menge Pirisihanen, menge Canaanhen, menge Hivihanen wey menge Jebusihanen, ne iyan a ebpuew kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kenè niw ezapa wey silbiyi is kandan he ebpen-ezapen, ne kenè niw iringi is menge vaal zan. Purungi niw zèdeeti is menge ed-ezapen dan wey is menge vatu he tedeman dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Iyan a keniyu ezapa is Nengazen he Megbevayè niw, ne edtuvazan ku sikiyu te keenen wey wahig. Ne id-awè ku is daru ziyà te keniyu, ");
INSERT INTO mbbOT_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ne zutun te tanè niw wazà keniyu egkerenranan etawa kenà ebpekaanak. Ne ebpengelinteuwan ku he luǥeyazi kew te untung. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Epelihendeken ku wey edliveǥen ku is menge kuntada niw he zutun te egkesineruwan niw ne ebpemekepelaǥuy zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ebpehurunan ku te petiyukan is menge Hivihanen, menge Canaanhen, wey menge Hitihanen su wey mesegseg sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Iyan, kenè ku sikandan edsegseǥen seled dà te senge-tuig su emun egkediritsuwan egkeewai te etew heeyan is tanà, ne ed-ubpaan te mahabet he menge leew he langgam ne iyan egkehimu he prublima niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ednenenayan ku sikandan te edsegseg su para meiseg kew pa mevuwad su wey niw meeneb haazà is tanà. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Is egketemanan te tanà he ibpaangken ku keniyu ne ebpuun diyà te Zaǥat he Meriǥà pehendiyà te Zaǥat he Mediteraneo, wey ebpuun te disirtu pehendiyà te Wahig he Eufrates. Ebpengelinteuwan ku he mezaag niw is menge etew he ed-ubpà keniyan he tanà su wey niw sikandan mesegseg. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kenè kew pekid-uyun kandan wey te menge ed-ezapen dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kenè niw sikandan ipeubpà diyà te tanè niw, su iyan sikandan ibpekesalè niw kayi te kediey. Su emun ed-azap kew te menge ed-ezapen dan, ne iring heini te penuǥes he ebpekeutel keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ne migkeǥiyan te Nengazen si Moises te, “Tekezeg ka kayi te kediey ne zumaha nu si Aaron, si Nadab, si Abihu, is 70 he ebpemendumala te Israel. Ne ezapa e zan kayi, iyan, diyè dan dà te meziyù. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Iyan ke zà egkehimu he ed-uvey kediey, ne is menge zuma nu kinahanglan he kenè dan mulà med-uvey. Ne is kezekelan keniyu kinahanglan he wazà edtekezeg kayi te vuntud duma kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ne hein nekelikù sikandin diyà te menge etew migkaǥi zin kandan is langun he menge lalag wey menge velaud te Nengazen, ne mibperedredseey sikandan is edtavak te, “Ebeelan dey is minsan hengkey he nekaǥi te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ne insurat ni Moises is langun he nekaǥi te Nengazen. Ne hein nepawà midselemselem sikandin med-enew ne mibaal sikandin te pemuhatà diyà te nevunsuzan duen te vuntud ne impelastar zin is 12 he tedeman he vatu he iyan ibpesavut dutun is 12 he tribu te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ne midsuǥù din te kebpemuhat is duma zan he vetan-en he menge maama, ne nemuhat sikandan te pemuhat he edtutungen, wey nemuhat daan sikandan te menge tudu he vaka he pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ne midliwazà ni Moises is lengesa, is liwazà in-ahuk din diyà te menge yahung ne is sevaha he liwazà impirik din duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ne migkuwa zin sikan is Libru te Kebpekid-uyun te Megbevayà ne mibasa zin diyà te etuvangan te menge etew. Ne midtavak sikandan te, “Ebeelan dey is minsan hengkey he nekaǥi te Nengazen; ebpezumdumahan dey sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ne migkuwa si Moises te lengesa ne haazà impirik din diyà te menge etew he ke sikandin te, “Heini is lengesa iyan lig-en wey tuus te paaǥi te kebpekid-uyun te Nengazen diyà te keniyu kayi te kebeǥayi zin keniyu te langun he menge suǥù.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ne midtekezeg diyà te vuntud si Moises, si Aaron, si Nadab, wey si Abihu, wey sikan is 70 he ebpemendumala te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ne neehè dan is Megbevayà te Israel, he ziyà mekehitindeg te iring te saag he sapiru he henduen te mehiǥawan he langit. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Iyan, minsan pa te neehè dan is Megbevayà ne wazè din sikandan himetayi. Migkaan pa ganì sikandan wey mid-inum diyà te etuvangan te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ne migkeǥiyan en maan si Moises te Nengazen te, “Laus ke pa tekezeg kayi te kediey ne taǥad ka kayi, su ibeǥey ku ziyà te kenikew is melumpipì he menge vatu he midsuratan te menge suǥù ku wey menge penurù he egkesunud keniyan te menge etew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ne zutun midlaus medtekezeg si Moises diyà te vuntud te Megbevayà duma si Josue he suluǥuen din. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Hein wazè pa sikandan megenat ne migkaǥi si Moises diyà te menge edumala te, “Taǥad kew taman te ebpekelikù key kayi te keniyu. Ne emun duen menge kesevaan niw ne iyan niw ipehusey si Aaron wey si Hur su kayi mulà sikandan te keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ne zutun te kebpekeuma eni Moises diyà te puntur zutun te vuntud, ne haazà is buntud netembunan te ǥapun, ");
INSERT INTO mbbOT_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ne mibulus is Nengazen dutun te Buntud he Sinai. Ne seled te heenem he andew netembunan te ǥapun haazà is buntud, ne hein ikepitu en he andew mid-umew si Moises te Nengazen puun duen te ǥapun. ");
INSERT INTO mbbOT_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","18","Ne zutun te kedlaus kedtekezeg ni Moises duen te vuntud, nekeseled sikandin duen te ǥapun. Ne zutun sikandin te vuntud seled te 40 he andew wey 40 he kezukileman. Ne is kezekelan mulà te menge Israilihanen, ne iyan kandan he ked-ahaa te mekeǥeǥehem he kebpekiduma te Nengazen duen te puntur te vuntud is iring te edriyubriyub he hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Keǥiyi nu is menge Israilihanen te uwiti e zan te menge halad. Ne iyan ka zawat dutun te idhalad dan kayi te kediey he ebpuun diyà te keputian te atey zan is kebeǥaya zan duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Iyan heini menge halad he egkuwaan nu ziyà te kandan: vulawan, pelata, brunsi, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","welin he meitem is kaavuavu zin, merudtem wey kanggan, linu, wey bulvul te kambing he hinavel, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","lundis te meemahan he kerehidu he midtinà te meriǥà, meupiya he kelasi he lundis, kayu he ekasya, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lana te ulibu para te sulù, menge pehemut he para te lana he idlana wey para te mehemut he veyewà, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","wey vatu he uniks wey zuma pa he mahalen he menge vatu he para ibpemikit duen te ipud wey zuen te teleǥuey ziyà te kumeng kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ipevaal nu sikandan te tulda he zutun a ed-ezapa, ne edlumun a ziyà te kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Is kebeeli zutun te Tulda he Ed-ezapan wey is langun he menge gelemiten dutun, kinahanglan he iyan egkesunud sikan is mudilu he ibpeehè ku kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Pevaal ka te Kavan, iyan niw veeli is kayu he ekasya, ne haazà, 45 he vaney is kelayat din, 27 he vaney is keluag din, ne 27 he vaney is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ne ed-epizan te lunsey he vulawan is diyà te seled wey is diyà te gawas te kavan wey ebpeliǥuyan te ribiti he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Pevaal ka te heepat he mibpen-iring te rintì he vulawan, ne haazà diyà ibpikit te heepat he paa zutun te kavan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Pevaal ka zaan te menge tival he kayu he ekasya ne haazà ed-epizan te vulawan, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ne id-ahuk haazà is tival zuen te menge mibpen-iring te rintì duen te kada kilid te Kavan para metival zan haazà is Kavan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ne haazà is menge tival kinahanglan he kenè en ed-ew-ewaan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ne itaǥù niw zutun te Kavan is dezuwa he melumpipì he vatu he ibeǥey ku ziyà te kenikew he zutun idsurat is menge Kesuǥuan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Peveeli nu heini he Kavan te lunsey he vulawan he tangeb, he 45 he vaney is kelayat din wey 27 he vaney is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Ne pesalsal ka te vulawan ne haazà, ebeelan he zezuwa he ledawan te velinsuǥuen he kirubin. Ne ziyà haazà ibpelastar te pesiziveluyà he egkepengkusan duen te tangeb su para teleubpu zà sikan is menge kirubin wey haazà is tangeb. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kinahanglan he is menge pakpak duen te menge kirubin ne egkevekar ziyà te zivavew zuen te tangeb su para ebpekelambung duen. Ibpedsineru haazà is dezuwa he kirubin ne zutun sikandan ibpetengteng te tangeb. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ne itaǥù nu zutun te Kavan is midlumpipì he menge vatu he edsuratan te menge Kesuǥuan ku he ibeǥey ku kenikew, ne tengevi nu haazà is kavan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ne ebpekidhinguma a kenikew zutun te mid-elangan duen te dezuwa he kirubin he ziyà te zivavew zuen te Kavan, ne ibeǥey ku kenikew is langun he menge velaud ku para te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Pevaal ka te lemisahan he ekasya, he 36 he vaney is keluǥayad din, ne 18 he vaney is keluag din wey 27 he vaney is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ne peepizi nu haazà te lunsey he vulawan wey peribitiyi nu te vulawan is peliǥuy zutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sevuki niw te senipa is ebpekeliǥuy ziyà te zivavew zutun te lemisahan he heepat he vaney is keluag din ne haazà is ibpekaplè niw lituwi niw pekeplai ziyà te zivavew zin te vulawan he ribiti zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ne vaal kew te heepat he mibpen-iring te rintì he vulawan ne ipikit niw haazà diyà te heepat he tukud te lemisahan, ");
INSERT INTO mbbOT_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ne ebpemekeuvey is kebpikita zuen diyà te ibpekaplà he senipa ziyà te zivavew su iyan haazà ed-ehukan te menge tival he idtival zutun te lemisahan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Baal kew te menge tival he kayu he ekasya, ne epizi niw te vulawan ne iyan haazà itival niw zutun te lemisahan. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Baal kew zaan te lunsey he vulawan he menge pinggan, menge tasa, menge umuy, wey menge yehung. Ne haazà, iyan ebpen-ehukan te menge pemuhat he inumen. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kinahanglan he pirmeninti is supas dutun te lemisahan he ibpemuhat kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Pevaal ka zaan te selevukà te sulù he lunsey he vulawan is menge paa zin, lawa zin, wey is dayandayan dutun he menge vulak, he is duma zuen wazè pa mebekar ne is duma mibekar en. Haazà is dayandayan idredsè dà is kebpurmaha kayi zuen te kebpurmaha te selevukà te menge sulù su teleubpu zà heini. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Haazà is selevukà te sulù, duen din heenem he subpang, tigtetelu is diyà te kada kilid kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Is kada subpang dutun, duen din tetelu he zayandayan he menge vulak he mid-iring te vulak he almindru, he is duma, memetivurun pa, ne is duma nememekar en. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ne is lawa zutun te selevukà te sulù, ne zuen dutun heepat he zayandayan he ed-iringen te vulak he almindru he wazè pa mebekar wey mibekar en. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Duen sevaha he vulak diyà te zizalem te kada paris te subpang. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Haazà is menge zayandayan wey menge subpang, idredsè dà is kebpurmaha zuen te kebeeli zuen te lewahan te selevukà te sulù. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ne pevaal ka te pitu he sulù he idsavuk niw zuen te selevukà te sulù, ne ziyè niw haazà ipelastar is selevukà te lugar he egketeyawan is diyà te egkesineruwan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kinahanglan he lunsey he vulawan is menge lipit wey is menge selevukà te igmuk. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Menge 35 he kilu he lunsey he vulawan is egkeǥamit niw te kebaal te selevukà te sulù wey te langun he menge gelemiten kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kinahanglan he edsungkad is kebeeli niw kayi zuen te mudilu he impeehè ku kenikew kayi te vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ipeveeli nu is Tulda he Ed-ezapan. Is egemiten te kebeeli kayi, ne sepulù he lukut he linu he eburdahan te welin he meitem is kaavuavu, merudtem wey kanggan. Ne pepurungi nu heini peburdahi te zagwey te menge kirubin. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Iped-iiring niw is kezekelà te kada sevaha, 42 he ǥiek is kelayat din ne heenem he ǥiek is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Is kada lelima zutun te sepulù he kurtina ne ibpedliliib niw te edtahì (ne haazà is sepulù egkehimu zà he zezuwa). ");
INSERT INTO mbbOT_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ne peveeli nu te mibpen-iring te sising is manggad he meitem is kaavuavu zin is diyà te kada kilid te ikezuwa he apid duen te sevaha zutun te impikit he menge tila; ");
INSERT INTO mbbOT_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","kinahanglan he 50 he iring te sising is diyà te kada kilid ne ibped-aatbang haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ne mebaal zan te 50 he kaw-it he vulawan su wey mekedliliib sikan is menge mibpen-iring te menge sising duen te zezuwa he impebpikit he menge tila. Pinaaǥi kayi ne egkeveelan is Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ne pevaal ka zaan te tambun duen te Tulda. Ne egemiten is 11 he lukut he manggad he vulvul te kambing ");
INSERT INTO mbbOT_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ne iped-iiring niw is keluag wey kelayat dutun te 11 he manggad, kinahanglan he 45 he ǥiek is kelayat din ne heenem he ǥiek is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ipedliliib niw is lelima zutun, ne sikan is heenem, ipedliliib niw ǥihapun. Ne is ikeenem he manggad, ne edlumpien diyà te egkesineruwan duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kinahanglan he zuen 50 he mibpen-iring te sising is kilid duen te id-apid te mibpebpikit he menge tila, ");
INSERT INTO mbbOT_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ne kinahanglan he ebperisan haazà is menge ebpen-iringen te sising te 50 he kaw-it he brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Edteyuntunen diyà te egkeiniyuǥan duen te tulda is ketengà te manggad he ebpekesubra. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ne edteyuntunen daan diyà te kada kilid is senge-ǥiek wey tengà he manggad he subra te idtambun duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Is divavew zuen te tambun te tulda, pezivevawi niw te lundis te meemahan he kerehidu he edtinaan te meriǥà, ne umani niw pa pezivevawi te meupiya he kelasi te lundis. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Is kayu he egkeǥamit niw he menge tabla zuen te Tulda he ed-ezapan, iyan is; metulid he marku he ekasya. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Is kada sevaha zutun, ne 15 he ǥiek is keluǥayad din ne zezuwa he ǥiek is keluag din, ");
INSERT INTO mbbOT_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ne egkurtiyan niw is kada sevaha zutun su wey mekedhuhulmahà emun ibpenaud niw en. Kinahanglan he wazà minsan sevaha he kenè niw egkurtiyan. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Is 20 he tabla kayi, ziyà egemita te egkezivavà he vahin duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Baal kew te 40 he untuzà he pelata he ibpesungkad duen te menge tabla, zezuwa he untuzà is ibpesungkad diyà te kada sevaha he tabla he ziyà ibperenged te kinurtiyan he vahin dutun te tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ne 20 he tabla is egemiten para te egkezizaya he vahin te Tulda, ");
INSERT INTO mbbOT_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","wey sungkad te 40 he menge peuntuzà he pelata–dezuwa he peuntuzà is diyà te kada tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ne heenem he tabla is egkeǥamit diyà te kilid he zapit te edsenlepan, ");
INSERT INTO mbbOT_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ne zezuwa he tabla is egkeǥamit diyà te kada suyuk diyà te kilid ");
INSERT INTO mbbOT_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ne haazà ibpegkepleey puun te zizalem pehendiyà te zivavew he iyan ebpekeveǥey te purma zutun te suyuk. Ne pudu ed-iringa kayi is dezuwa he tabla ziyà te menge suyuk. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Umbe, zuen walu he menge tabla he para ziyà te menge suyuk wey 16 he menge peuntuzà he pelata su is kada tabla, egkinahanglan te zezuwa he peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Pevaal ka zaan te menge marku he kayu he ekasya he para te elavat, lelima is para te egkezizaya he vahin duen te Tulda, ");
INSERT INTO mbbOT_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lelima zaan is para te egkezivavà he vahin, wey lelima pa he para te zapit te edsenlepan he egkeiniyuǥan he vahin duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ne sikan is marku he ibpeteliwazà, kinahanglan he ebpekepangkus duen te Tulda he ed-ezapan, ne ziyà haazà idtaud te teliwazà he pid-elangan duen te menge tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Epizi niw te vulawan sikan is menge tabla ne vaal kew te mibpen-iring te rintì he vulawan he ibpenaud dutun te menge tabla he iyan edlugluǥan te menge marku. Ne elin daan epizi niw te vulawan sikan is menge marku. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Kinahanglan he edsungkad duen te mudilu he impeehè ku kenikew kayi te vuntud is kedtukuza niw zuen te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Baal kew te kurtina he linu he miburdahan te welin he meitem is kaavuavu, merudtem wey kanggan. Ne eburdahan heini te mekempet he zagwey te menge kirubin. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ne isanggat niw ziyà te menge kaw-it he vulawan he idtaud diyà te heepat he tukud he ekasya he ed-epizan te vulawan he ziyà ibpehitindeg te heepat he untuzà he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Isanggat niw haazà is kurtina ziyà te kaw-it ne isavuk niw ziyà te zivaluy zutun te kurtina sikan is Kavan te Kebpekid-uyun ku keniyu. Pinaaǥi zutun te kurtina egkevahin is seled te Segradu he Lugar wey is Utew Segradu he Lugar. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Sikan is Kavan te Kebpekid-uyun ku keniyu, kinahanglan he ziyà idsavuk te Utew Segradu he Lugar ne kinahanglan he edtembunan duen te tambun din. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ne isavuk niw sikan is lemisahan diyà te gawas te kurtina, diyè niw isavuk te zapit te zizaya he zutun te seled te Tulda. Ne id-atbang niw zutun te lemisahan sikan is selevukà te sulù su ziyè niw mulà idsavuk te egkezivavà he vahin dutun te seled te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Pevaal ka zaan te sevaha pa he kurtina, he para te ǥemawan dutun te Tulda he Ed-ezapan. Is kurtina kinahanglan he linu he eburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan. Kinahanglan he meupiya is kegkeburdahi kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ne para kayi he kurtina, baal kew te lelima he tukud he ekasya he ed-epizan te vulawan, ne itaud niw ziyà te kada sevaha zutun is kaw-it he vulawan. Ne vaal kew zaan te lelima he brunsi he ebpehitindeǥan dutun te menge tukud.” ");
INSERT INTO mbbOT_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Migkaǥi is Nengazen diyà te ki Moises te, “Baal kew te kuwedradu he pemuhatà he kayu he ekasya. Pitu wey tengà he ǥiek is kelayat din ne pitu zaan wey tengà he ǥiek is keluag din, ne heepat wey tengà he ǥiek is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ne veeli niw te sungeysungey is heepat he suyuk dutun, he idredsè dà is kebeeli zuen te kebeeli zutun te pemuhatà. Kinahanglan he ed-epizan te brunsi haazà is pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Is langun he menge gelemiten dutun te pemuhatà ne brunsi, he iyan is: menge selevukà te avu, menge pala, menge yahung, menge dezekelà he tinidur he para te usa, wey is menge selevukà te vaǥa. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Baal kew zaan te tuuǥà he brunsi he para zutun te pemuhatà, ne pikiti niw te menge brunsi he mibpen-iring te rintì is kada suyuk dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ne isavuk niw heini ziyà te untuzè din he ziyà te tengàtengà he vahin te seled duen te pemuhatà puun te zivavew. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Baal kew te tival he ekasya he para zutun te pemuhatà, ne epizi niw haazà te brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ne haazà is menge tival zuen niw idluglug te mibpen-iring te rintì he ziyà te pesikilizà dutun te pemuhatà su iyan haazà idtival zutun te pemuhatà emun ed-uwiten. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kinahanglan he kahun is beeli niw he pemuhatà. Ne iyan niw iringi sikan is impeehè ku kenikew kayi te vuntud.” ");
INSERT INTO mbbOT_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kinahanglan he zuen lama zutun te Tulda he Ed-ezapan, elaza niw haazà pinaaǥi te kegkurtinahi zuen te linu. Is keluǥayad te kurtina he impelingut diyà te zivavà he kilid ne 150 he ǥiek. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ibpikit heini he kurtina ziyà te 20 he tukud he brunsi he ziyà ipehitindeg te 20 daan he ebpeuntuzan duen he brunsi. Is ebpemikitan duen te menge kurtina, ne iyan is menge kaw-it he pelata he impikit diyà te menge kebilya he pelata ziyà te menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Is kurtina he ziyà dapit te zizaya ne 150 daan he ǥiek is keleyatan din. Ibpikit daan heini ziyà te 20 he tukud he brunsi he ziyà ipehitindeg te 20 he ebpeuntuzan duen he brunsi. Is ebpikitan duen te menge kurtina ne iyan is menge kaw-it he pelata he ibpemikit diyà te menge kebilya he pelata ziyà te tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Is kurtina he ziyà dapit te edsenlepan he kilid, 75 he ǥiek is keluǥayad din, ne ibpikit heini ziyà te sepulù he tukud he impehulma ziyà te sepulù daan he menge peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Is dapit te edsilaan he kilid duen te lama 75 zaan he ǥiek is keluǥayad din. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ne zuen kayi ǥemawan he ed-elangan daan te kurtina is kilid din. Is kurtina ziyà te egkekewanan, 22 he ǥiek is keluǥayad din, ne ibpikit heini ziyà te tetelu he tukud he ibpemehulma ziyà te tetelu zaan he menge peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Is kurtina ziyà te egkeǥivang, 22 wey tengà he ǥiek is keluǥayad din, ne idtaud heini ziyà te tetelu he tukud he ibpehulma ziyà te tetelu he peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ne haazà is gemawan, kinahanglan he egkurtinahan te 30 he ǥiek is keluǥayad din he linu he eburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan ne ebpurungan heini eburdahi. Ne idtaud haazà is kurtina ziyà te heepat he menge tukud he ibpehulma ziyà te heepat he peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Is langun he menge tukud he ebpekeliǥuy zutun te lama kinahanglan he zuen dutun menge kaw-it wey menge kebilya he pelata, wey zuen menge pundasyun he brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","“Umbe, haazà is lama, zuen din keleyatan he 150 he ǥiek wey 75 he ǥiek he keluaǥan. Ebpeliǥuyan heini te kurtina he linu he is kelayat din, pitu wey tengà he ǥiek. Is menge tukud kayi, ibpehulma ziyà te menge peuntuzà he brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kinahanglan he pudu brunsi is langun he menge idhiman duen te Tulda he Ed-ezapan ragkes is langun he menge palpal he ibanting dutun te tulda wey is menge kurtina ziyà te lama kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Suǥua nu is menge Israilihanen he uwiti ke zan te lunsey he lana te mibevayu he ulibu he idtubil te menge sulù dutun te Tulda su para layun mekesiǥa. ");
INSERT INTO mbbOT_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Is selevukà te sulù, kinahanglan he idsavuk diyà te ǥawas te kurtina he ebpeketambun duen te Kavan te Kebpekid-uyun. Si Aaron wey is menge kevuwazan din iyan ed-etiman duen te menge sulù duen te Tulda he Edtelevukaayan. Ibpesiǥa zan heini ziyà te etuvangan ku meselem wey mezukilem. Heini he menge sulunuzen ereg he edtumanen te menge Israilihanen taman te huziyan he menge lapis te menge kevuwazan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ipeviza nu puun te zuma he menge etew is suled nu he si Aaron wey sikan is menge anak din he ensi Nadab, Abihu, Eleazar, wey Itamar, su edhimuwen ku sikandan he menge memumuhat he ebpenilbi kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Peveeli nu is suled nu he si Aaron te menge visti he segradu he ebpekeveǥey kandin te zengeg. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Keǥiyi nu sikan is menge maama he mibeǥayan ku te ketau te kebpemaal te visti he veeli zan si Aaron te menge visti, su wey niw sikandin ikepeveyveyai kedì su edhimuwen ku sikandin he memumuhat he edsilbi kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ne iyan heini menge visti he ebeelan para kandin: is teleǥuey ziyà te kumeng, ipud, pendivavew he visti, pendizalem he visti he binurdahan, tengkulu, wey vagkes. Kinahanglan he ebaal zan te menge visti he para ki Aaron wey para te menge anak din he maama, su para mekepenilbi sikandan kedì pinaaǥi te kebpemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Is egkeǥamit iyan is: linu he eburdahan te vulawan he tanur, wey welin he meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Is ipud, kinahanglan he iyan ebeelan is linu he utew meupiya, wey tanur he vulawan wey welin he tanur he meitem is kavuavu zin, merudtem wey kanggan. Kinahanglan he meupiya is kegkeburdahi kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Heini he visti, dezuwa he vahin; is diyà te peka wey is diyà te sineruwan, ne ebpekedsumpul heini ziyà te idtedted diyà te pemenayen. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Is bakes kayi, linu zaan he miburdahan te vulawan he tanur wey welin he meitem is kaavuavu zin, merudtem, wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Ne kuwa kew te zezuwa he vatu he uniks ne id-ukir niw zutun is sepulù wey dezuwa he menge ngazan te menge anak ni Jacob, ");
INSERT INTO mbbOT_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ne ibpedsusunud pinaaǥi te penuiǥen dan, heenem he ngazan is diyà te kada vatu. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Is ked-ukira te menge ngazan duen te sepulù wey dezuwa he menge ngazan te menge anak ni Israel duen te dezuwa he vatu kinahanglan he utew ebpurpurungi ne ibpezivavew ziyà te selevukà he vulawan haazà is menge vatu. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ne ibpikit heini zuen te menge tedted diyà te pemenayen duen te ipud. Iyan teǥialung kayi is sepulù wey zezuwa he tribu te Israel. Pinaaǥi kayi edtiangen ni Aaron is menge ngazan dan diyà te etuvangan ku, ne siak is Nengazen, layun ku sikandan egketenuzi is menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Is menge selevukà he vulawan ");
INSERT INTO mbbOT_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","pesevuki nu te zezuwa he rantey he lunsey he vulawan su wey ikepikit heini zuen te pemenayen duen te visti. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Pevaal kew te teleǥuey ziyà te kumeng he egemiten te kebpesavut te egkesuatan te Nengazen. Kinahanglan daan he utew metau is ebaal zuen, he utew meupiya is kegkeveeli kayi, ne is tila kayi ne kinahanglan he iring te tila he egemiten te kebaal te ipud: linu he miburdahan te vulawan he tanur wey welin he meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Heini is teleǥuey ziyà te kumeng edubliyen is kedlumpìa zuen ne kuwedradu heini; siyam he vaney is keleyatan din wey keluaǥan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ne ibpikit dutun is heepat he linya te menge mahal he vatu. Is nehuna he linya, rubi, tupas, wey biril; ");
INSERT INTO mbbOT_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","is ikezuwa he linya, imirald, sapiru, wey diyemanti; ");
INSERT INTO mbbOT_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","is iketelu he linya, hasintu, agata wey amatista; ");
INSERT INTO mbbOT_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ne ikeepat he linya, krisulitu, uniks, wey haspir. Ibpemezivavew heini ziyà te selevukà he vulawan he para te ebpezivevawan duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Is kada sevaha zuen te sepulù wey dezuwa he menge vatu, ne id-ukir zutun is sevaha zaan he ngazan te sevaha he anak ni Jacob, su iyan haazà edriprisintar te sepulù wey dezuwa he ebpuunan te menge kevuwazan ni Israel. Is ked-ukira zutun ne iring te ked-ukir te para ibmarka. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Baal kew zaan te rantey he lunsey he vulawan he para zuen te teleǥuey ziyà te kumeng. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ne vaal kew zaan te zezuwa he mibpen-iring te sising he vulawan, ne ipikit niw haazà diyà te egkezapit te zivavew he menge suyuk duen te teleǥuey ziyà te kumeng. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ne ihiket niw zutun te zezuwa he rantey he vulawan duen te iring te sising. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ne is divaluy he purù dan, ne zuen niw ihiket te zezuwa he selevukà he zuen idsanggat te menge tedted diyà te pemenayen duen te ipud. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ne uman kew vaal te zezuwa he mibpen-iring te sising he vulawan ne ziyè niw ipikit te egkezapit diyà te zizalem he dezuwa he suyuk duen te teleǥuey ziyà te kumeng he sikan is egkezapit duen he mid-epizan kayi he ipud. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ne uman kew pa vaal te zezuwa he ebpen-iringen te sising he vulawan ne ipikit niw haazà diyà te kilid duen te ipud wey zivavew te imbakes duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ne sikan is dezuwa he iring te menge sising he zuen ipikit te egkezizalem he menge suyuk duen te teleǥuey ziyà te kumeng, teuzi niw te hiket he meitem is kaavuavu zin ne ihiket niw zuen te zezuwa he iring te menge sising he zuen ipikit te pesikilizà he zapit te egkesineruwan duen te ipud su para meviǥer is kebpekesavuk din diyà te egkezivavew te vakes. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Dutun te kedseled ni Aaron duen te Segradu he Lugar, ne idtaud din haazà is teleǥuey ziyà te kumeng he mideyzeyanan te mahal he menge vatu he in-ukir zuen is menge ngazan te menge tribu te Israel su para siak is Nengazen, ne layun ku sikandan egketenuzi is menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ne idtaǥù daan dutun te teleǥuey ziyà te kumeng is dezuwa he vatu he veveraan he egngezanan te Urim wey Thumim, su para egkeuwit ni Aaron emun ebpekid-etuvang sikandin kedì te Waǥas he Nengazen. Dutun he menge timpu te ked-etuvang din kedì, kinahanglan he layun din idtaud sikan is teleǥuey ziyà te kumeng, su wey zin metueni is egkesuatan ku para te menge kevuwazan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Is pendivavew he visti he iyan egkeepizan duen te ipud he manggad he meitem is kaavuavu zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Is budsi zutun he iyan sikan is egkeehukan te lieg, kinahanglan he edteuzan te epuru is peliǥuy su wey kenà mevindas. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Is peliǥuy he sidsid dutun te visti kinahanglan he ibpeliǥuy te eburda zutun is ed-iringen te menge veǥas te kayu he pumigranata, he welin he meitem is kaavuavu zin, merudtem wey kanggan he ebpemelvel-etan te menge seriyew he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ibivisti ni Aaron haazà is pendivavew he visti zutun te kedseled din duen te Segradu he Lugar su ebpenilbi ziyà te etuvangan ku, su wey mezineg is daǥing te menge seriyew emun edseled etawa egawas si Aaron dutun te Segradu he Lugar. Emun ebeelan din heini ne kenà sikandin ebpatey. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Baal kew te midalya he lunsey he vulawan he ed-iringen te pelatu ne iukir niw zutun is menge lalag he: ‘Pehinungud te Nengazen.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","38","Ihiket niw heini ziyà te etuvangan duen te tengkulu ni Aaron pinaaǥi te hiket he meitem is kaavuavu zin, su wey maahà heini ziyà te vuked din. Ne ebpaahà heini he ed-uwiten ni Aaron is minsan hengkey he salà he nehimu te menge Israilihanen dutun te kebpemuhata zan te Nengazen. Kinahanglan he layun heini idtaud ni Aaron diyà te vuked din su wey zin mepenunuat is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Linu is hevela niw he pendizalem he visti ni Aaron ne linu zaan is beeli niw he tengkulu zin, wey vakes din he kinahanglan he egkepurungan heini te eburda. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Beeli niw zaan te menge visti, menge vakes, wey menge tengkulu sikan is menge anak ni Aaron he menge maama, su ebpekeveǥey kandan te zengeg. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Bistiyi nu kayi is suled nu he si Aaron wey sikan is menge anak din he maama. Ne ebpetiǥisan sikandan te lana tuus te kegkehimuwa kandan he memumuhat. Ne ipehinungud nu sikandan kediey su wey sikandan mekepenilbi kedì pinaaǥi te kebpemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Peveeli niw zaan sikandan te pendizalem he visti he ebpeketambun te pid-etawan dan. Is keluǥayad kayi, ne puun te hawak taman te vuel, su wey zan kenà mevikangi. ");
INSERT INTO mbbOT_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Emun edseled si Aaron wey sikan is menge anak din duen te Tulda he Edtelevukaayan, etawa ed-uvey zan duen te pemuhatà diyà te Segradu he Lugar su ebpemuhat sikandan, kinahanglan he egemiten dan heini su edhimetayan ku sikandan emun ibpeǥawaǥawa zan is pid-etawan dan. Heini he sulunuzen pehendiyè en te egkelapislapis he kevuwazan ni Aaron is kedtumana zan kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Iyan heini ul-ulaha nu te kebpehinunguza nu ki Aaron wey te menge anak din he menge maama su wey zan mekepenilbi kedì pinaaǥi te kegkememumuhat dan. Kuwa ka te sevaha he turiti he vaka wey zezuwa he meemahan he kerehidu he wazè dan sazir. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Kuwa ka te kinemeupiyahan he herina te trigu, ne veeli nu he supas, iyan, kenè nu tepayi; baal ka zaan te mamun he ed-emutan te lana he ulibu, ne vaal ke zaan te kenà mulà ed-emutan te lana, is duma zutun ebpekenipisen nu ne edezasan nu te lana. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Itaǥù nu haazà diyà te vaskit ne ipemuhat nu kayi te kedì duma te kebpemuhata nu zuen te sevaha he turiti he vaka wey zezuwa he meemahan he kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Dumaha nu si Aaron wey sikan is menge anak din he maama ziyà te idselang pehendiyà te Tulda he Edtelevukaayan, ne ipepemeziǥù nu sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ne vistiyi nu si Aaron te menge visti te memumuhat he iyan sikan is; bisti he kemisidintru wey sikan is ipud he iyan kes ispisyal he visti te memumuhat, sikan is teleǥuey ziyà te kumeng, wey sikan is meupiya is kegkeveeli zin he vakes duen te ipud. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tengkuluwi nu sikandin ne ipikit nu zutun sikan is midalya he vulawan he tuus he impehinungud sikandin he para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kuwa ka te lana he para zà te idlana te ebpilien ku, ne ilana nu ziyà te ulu ni Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ne ipehinungud nu zaan sikan is menge anak din he maama, ne vistiyi nu sikandan te pendizalem he visti, ");
INSERT INTO mbbOT_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","tengkulu, wey vakes. Egkehimu sikandan he memumuhat taman te taman. Iyan heini paaǥi te kedhimuwa nu ki Aaron he memumuhat wey sikan is menge anak din. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Uwita nu sikan is turiti he vaka ziyà te etuvangan te Tulda he Edtelevukaayan, ne keǥiyi nu si Aaron wey sikan is menge anak din he izampè dan is palad dan diyà te ulu zutun te vaka. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ne lepaa nu haazà is baka ziyà te etuvangan te Nengazen diyà te gemawan dutun te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ne kuwa ka te lengesa zutun te vaka ne ipalis nu zuen te menge sungeysungey te menge suyuk duen te pemuhatà. Ne sikan is egkesamà he lengesa ivusbus nu zuen te untuzà dutun te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ne kuwaa nu is langun he tavà diyà te seled te ǥetek, ne kuwaa nu is deisey he vahin te atey, wey sikan is menge vuwà ragkes is menge tavà kayi, ne tutunga nu zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ne sikan is sapù duen te vaka, lundis din, wey bituka zin, ne ziyè nu tutunga te gawas te kampu. Heini he pemuhat, pemuhat para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Egkepasad haazà, iyan nu en maan kuwaa sikan is sevaha zuen te zezuwa he meemahan he menge kerehidu, ne keǥiyi nu si Aaron wey sikan is menge anak din he izampè dan is palad dan diyà te ulu zuen te kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Lepaa nu haazà, ne uwita nu is lengesa zin, ne ipirik nu zuen te pesikilizà duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Sepùa nu haazà is kerehidu; ne lùlui nu is bituka wey is duma he ebpemeketaǥù diyà te zizalem din ne sikan is menge paa, em-emura nu ragkes duen te ulu wey zuma he vahin. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ne tutunga nu haazà duen te pemuhatà su pemuhat haazà he edtutungen para kedì. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ne kuwaa nu en daan sikan is nesamà duen te zezuwa he meemahan he kerehidu, ne idampà ni Aaron wey te menge anak din diyà te ulu zutun is palad dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ne himetayi nu haazà, ne kuwa ka te lengesa zutun ne izazas nu ziyà te kewanan he telinga ni Aaron wey kewanan he telinga zuen te menge anak din he maama, wey kewanan he tindezekelà te menge velad wey paa zan. Ne piriki nu te lengesa sikan is peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ne kuwa ka te lengesa he zutun te pemuhatà, ne isahug nu heini te lana he para idlana ne ipirik nu haazà diyà te ki Aaron wey ziyà te menge visti zin, ipirik nu zaan duen te menge anak din, wey ziyà te menge visti zan. Dutun, si Aaron wey sikan is menge anak din he maama wey is menge visti zan, igkepehinungud en kayi te kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Kuwaa nu is menge tavà duen te kerehidu, sikan is melambù he ikug din, sikan is menge tavà diyà te seled te ǥetek, sikan is deisey he vahin te atey, wey sikan is menge vuwà ragkes is menge tavà kayi, wey sikan is kewanan he vuvun. Iyan heini is kerehidu pemuhat para te kedhimuwa te memumuhat he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kuwa ka te supas duen te baskit he wazà tepayi he iyan sikan is supas he impemuhat kayi te kediey. Ipedsesangì nu is klasi te supas he egkuwaan nu, kuwa ka te sevaha he mamun he mid-emutan te lana he ulibu, wey sevaha he pan he wazà emuti te lana, wey senge-elad duen te menipis he supas. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ne peǥewezi nu haazà is langun ki Aaron, wey te menge anak din he maama, ne ivayew zan haazà kayi te etuvangan ku su pemuhat haazà he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ne kuwaa nu haazà is menge supas diyà te menge velad dan, ne tutunga nu zutun te pemuhatà duma te pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ne kuwaa nu is kumeng duen te kerehidu ne ivayew nu haazà kayi te etuvangan ku su pemuhat haazà kayi te kediey he ibayew. Iyan heini kenikew he vahin duen te kerehidu he pemuhat he para te kedhimuwa ki Aaron he memumuhat wey te menge anak din. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ipehinungud nu kayi te kedì is menge vahin duen te kerehidu he pemuhat para te kedhimuwa ki Aaron he memumuhat wey te menge anak din, ragkes en kayi is kumeng wey buvun he imbayew kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Kenà egkahalin is paaǥi ku he iyan heini: Emun ebpemuhat is menge etew ku te menge pemuhat he para te meupiya he kedepità, ne sikan is kumeng wey buvun duen te ayam he ibpemuhat kinahanglan he ibeǥey ziyà te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Emun ebpatey en si Aaron, sikan is menge visti zin te kegkememumuhat din kinahanglan he ibeǥey ziyà te kevuwazan din he ebpekeilis kandin te lavew he mememuhat su para igkevivisti zan haazà emun ed-urdinahan sikandan pinaaǥi te kedlenahi kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Is kevuwazan ni Aaron he ebpekeilis kandin te lavew he memumuhat he edseled te Tulda he Edtelevukaayan su ebpenilbi kedì dutun te Segradu he Lugar, kinahanglan he ibivisti zin haazà is menge visti seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kuwaa nu sikan is usa he kerehidu he neǥamit te kedhimuwa ki Aaron wey zuen te menge anak din he memumuhat, ne hilutua nu ziyà te segradu he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ne zutun dan haazà egkeena zuma zuen te supas duen te baskit te gemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Iyan dà sikandan egkehimu he egkaan dutun te usa wey supas he impemuhat para mevelukasi is menge salè dan dutun te kedhimuwa kandan he memumuhat. Wazà duma he egkehimu he egkaan kayi zuma kandan su segradu heini he keenen. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ne emun egkeume en is meselem, ke zuen pa kenà egkekaan duen te usa etawa supas kinahanglan he edtutungen haazà; kenà haazà egkeenen su segradu haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Tumana nu heini is insuǥù ku kenikew mehitenged te kedhimuwa ki Aaron he memumuhat wey te menge anak din. Himuwa nu is ked-urdina kandan seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kada andew zutun, kinahanglan he pemuhat ka te turiti he vaka he pemuhat he para idlumpiyu, su wey melumpiyuwi sikan is pemuhatà. Ne lenahi nu haazà is pemuhatà su wey ikepehinungud heini. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ul-ulaha nu heini kada andew zutun te pitu he andew. Ne egkepurung egkehimu he segradu haazà is pemuhatà, ne ereg he idsivey para te Nengazen is ebpekezegkit dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Kada andew kinahanglan he ibpemuhat nu zutun te pemuhatà is dezuwa he nati he kerehidu he tigsenge-tuig is keǥurang dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Sevaha te meselem ne sevaha te mahapun. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Dutun te kebpemuhata nu zuen te kerehidu te meselem, ne pemuhat ka te zezuwa he kilu he meupiya he kelasi he herina. Sehuǥi nu heini te senge litru he lana te veǥas te mibevayu he ulibu. Pemuhat ka zaan te senge litru he vinu he pemuhat he inumen. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ne sikan is nati he kerehidu he ibpemuhat emun mahapun, iyan ded duma zin sikan is duma zuen te ibpemuhat emun meselem, wey iring daan duen kengezekelà. Is kehemut kayi he pemuhat te pemuhat he pinaaǥi te hapuy ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Iyan heini pemuhat he edtutungen, kinahanglan he andew-andew is ked-ul-ulaha niw kayi he pemuhat taman te sunud he menge lapis te kevuwazan. Ipemuhat niw heini kediey zutun te gemawan te Tulda he Edtelevukaayan, su zutun a ebpekidhinguma keniyu wey ebpekidlalag. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Dutun ku edhingumaa is menge kevuwazan ni Israel, ne pinaaǥi te mekeǥeǥehem he kebpekiduma ku egkehimu he segradu haazà he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Edhimuwen ku he segradu sikan is Tulda he Edtelevukaayan wey sikan is pemuhatà dutun, ne edhimuwen ku si Aaron wey is menge anak din he maama, he selakew keniyu su iyan mulà kandan he vaal is kebpemuhata kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Edlumun a keniyu te menge kevuwazan ni Israel ne egkehimu a he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ne egketuenan niw he iyan a is Nengazen he Megbevayè niw, mibpeǥawas keniyu ziyà te Ehipto su para mekelumun a ziyà te keniyu. Iyan a is Nengazen Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Baal kew te pemuhatà he kayu he ekasya he para tutungà te veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ne haazà, kinahanglan he kuwedradu he 18 he vaney is kelayat din ne 18 zaan he vaney is keluag din, ne 36 he vaney is ketikang din. Ne kinahanglan he zuen kayi menge sungeysungey ziyà te menge suyuk din he idredsè dà is kebpurmaha zuen te kebeeli zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Epizi niw te lunsey he vulawan is dapit te zivavew kayi, is heepat he kilid kayi, wey sikan is menge sungeysungey ziyà te menge suyuk. Ne rebitiyi niw te vulawan is peliǥuy kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ne vaal kew te zezuwa he ebpen-iringen te rintì he vulawan he para idtaud diyà te zizalem duen te ribiti ziyà te pesiziveluyà duen te pemuhatà, he para edteuzan te menge tival he idtival kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kayu he ekasya is beeli niw he menge tival ne epizi niw haazà te vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Isavuk niw heini he pemuhatà diyà te gawas duen te egkurtinahan te kurtina he ibitey ziyà te egkesineruwan duen te Kavan te Kebpekid-uyun ku keniyu. Ne zutun a he lugar ebpekidhinguma keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Kada meselem emun ed-etimanen ni Aaron sikan is menge sulù, kinahanglan he edtutung sikandin dutun he pemuhatà te mehemut he veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ne emun edtemteman din sikan is sulù ke egkesakep en, kinahanglan gihapun he edtutung sikandin te veyewà. Ne heini is kebpemuhata kedì pinaaǥi te kedtutung te veyewà, kinahanglan he kada andew is kebeeli zuen pehendiyè en te huziyan he menge lapis te kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kayi he pemuhatà, kenè kew mebpemuhat te selakew he veyewà, kenè niw heini pemuhati te minsan hengkey he pemuhat he edtutungen, etawa pemuhat he gasa, etawa pemuhat he inumen. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kesevaha te kada tuig, kinahanglan he edlumpiyuwan ni Aaron sikan is pemuhatà pinaaǥi te kebpelisi te lengesa zuen te menge sungeysungey te menge suyuk kayi. Haazà is lengesa he ibpalis, ne lengesa zuen te pemuhat he para idlumpiyu. Kinahanglan he kenè en ed-engkezan is kebeeli kayi kada tuig pehendiyè en te huziyan he lapis te menge kevuwazan; mid-isip ku heini he segradu utew he pemuhatà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ne migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Emun edsinsusen nu is menge kevuwazan ni Israel, kinahanglan he ebeyazan te kada sevaha he maama kayi te kediey is untung din su para wazà mezaat he egkehitavù diyà te kandin dutun te kedsinsus. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Is kada sevaha he maama he egkeragkes dutun te sinsus, kinahanglan he ebayad te heenem he gramu he pelata he edsungkad diyà te timbangan te pelata te menge memumuhat. Kinahanglan he ebayad is kada sevaha keniyu, su halad niw heini kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Is langun he menge maama he 20 he tuig is penuiǥen din, pehendiyè en te metikang ne iyan sikandan ebeǥey kayi te kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Is sepian, kinahanglan he kenà subra is ibayad din, ne is pubri kinahanglan he kenà kurang is ibayad din. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gemita niw heini he selapì para te ked-etiman duen te Tulda he Edtelevukaayan. Iyan heini lugbak para te untung niw, su wey ku kenà melemlemuwi is ked-ipat keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Baal kew te brunsi he bisin he brunsi zaan is selevukè din. Ne ziyè niw isavuk te tengàtengà te pid-elangan te Tulda he Edtelevukaayan wey zuen te pemuhatà, ne tegui niw haazà te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ne haazà is wahig dutun, iyan egemiten ni Aaron wey te menge anak din he maama te kedlùlù te menge velad dan wey menge paa zan, ");
INSERT INTO mbbOT_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","te kenè pa sikandan edseled te Tulda he Edtelevukaayan, wey kenè pa sikandan ed-uvey zuen te pemuhatà te kebpemuhat pinaaǥi te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Kinahanglan he edlùluan dan is menge velad dan wey menge paa zan su wey zan kenà mebpatey. Heini he sulunuzen, kinahanglan he edtumanen ni Aaron wey te menge kevuwazan din taman te huziyan he lapis te menge kevuwazan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kuwa ka te kinemeupiyahan he pehemut: Heenem he kilu he wahig he mira, tetelu he kilu te mehemut he sinamun, wey tetelu zaan he kilu te mehemut he calamus, ");
INSERT INTO mbbOT_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","wey heenem he kilu he kasia (kinahanglan he iyan idtimbang sikan is timbangan te menge memumuhat) ne ed-umanan haazà te senge litru wey tengà he lana te ulibu; ");
INSERT INTO mbbOT_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","pinaaǥi kayi beeli niw is segradu he lana he utew mehemut he para te idlana. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Ne gemita niw heini te kedlana te Tulda he Edtelevukaayan, wey zuen te Kavan te Kebpekid-uyun ku keniyu, wey zuen te lemisahan wey is langun he kehimanan din wey zuen te ibpehitindeg he sulù wey is langun he menge himan din, wey zuen te pemuhatà te edtutungen he veyewà, wey zuen te pemuhatà te menge pemuhat he edtutungen wey te menge gelemiten din, is bisin wey is selevukè din. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ipehinungud nu kediey heini is langun, ne zutun, egkepurung egkehimu he segradu heini is langun ne tenged dutun, ereg he idsivey para te Nengazen is ebpekezegkit duen. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ne lenahi niw zutun te lana si Aaron wey sikan is menge anak din he maama he tuus te ibpeveyveyaan niw sikandan kediey su wey zan mekepenilbi kedì pinaaǥi te kebpemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kegiyi nu is menge Israilihanen te, ‘Heini is lana, iyan segradu he lana te Nengazen he pehendiyè en te egkalapislapis he kevuwazan is kegemita zuen,’ ");
INSERT INTO mbbOT_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Kinahanglan he kenà heini idlana ziyà te etew zà duen, ne kinahanglan daan he kenè niw ed-iringan is kebeeli kayi he lana emun ebaal kew te lana he selakew en is egemitan niw zuen, su para kenà mevaleyvaley, su segradu heini he lana, ne kinahanglan he ebeǥayan niw te keveǥat is kegkesegradu zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Is minsan hentei keniyu he ebaal te iring kayi he lana he ibpenlana zin etawa idlana zin te zuma he etew zà duen su kenà memumuhat, ne kenè niw en sikandin isipa he zuma niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ne migkaǥi en maan is Nengazen diyà te ki Moises te, “Kuwa kew te ibped-iiring is kezekelè din he menge pehemut he iyan heini: istakti, uniks, galbanum, wey lunsey he veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Pinaaǥi te kebpedsesehuǥa kayi, baal kew te veyewà he utew mehemut. Timusi niw haazà, ne egkelunsey wey egkehimu he segradu haaza is beyewà. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bekbeka niw is duma kayi taman te egkepurung egkepurbus, ne isawed niw ziyà te etuvangan duen te Kavan te Kebpekid-uyun he zuen te Tulda he Edtelevukaayan, he zutun a ebpekidhinguma kenikew. Kinahanglan he ed-isipen nu heini he utew segradu. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ne kenè kew mebaal te veyewà he para keniyu he iring din su iring te mibpenggamit kayi is ebpenggemiten niw te kebaal. Haazà he veyewà isipa niw he segradu he azen he impehinungud kayi te kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ke zuen minsan hentei keniyu he ebaal te iring dutun he veyewà su ebeelan din he pehemut din, ne kenè niw en sikandin isipa he zuma niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ne migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Pemineg ka! Mibpilì ku si Bezalel, is anak he maama ni Uri he apù ni Hur he sakup te tribu ni Juda. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ne ed-ulinan ku sikandin pinaaǥi te ǥehem ku, ne ebeǥayan ku te ketau wey ebilidad te kebaal te minsan hengkey he vuluhaten. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ebeǥayan ku sikandin te ketau te kebaal te mekempet he menge vutang he vulawan, pelata, wey brunsi, ");
INSERT INTO mbbOT_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","te kebpurma te mahalen he menge vatu he ibpemikit, kegkurti te kayu, wey kebaal te zuma he edeyzeyanan he terebahu. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ne nepilì ku zaan he edterebahu duma kandin si Oholiab he anak he maama ni Ahisamac te ebpuun diyà te tribu ni Dan. Ne ebeǥayan ku zaan te ebilidad is langun he menge pandey su para mehimu zan is minsan hengkey he idsuǥù ku he ebeelan he iyan is: ");
INSERT INTO mbbOT_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tulda he Edtelevukaayan, Kavan te Kebpekid-uyun ku keniyu wey is tangeb din, is langun he menge gelemiten duen te Tulda– ");
INSERT INTO mbbOT_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","sikan is lemisahan wey menge gelemiten kayi, sikan is selevukà te sulù he lunsey he vulawan wey is langun he himan kayi, sikan is pemuhatà he tutungà te veyewà, ");
INSERT INTO mbbOT_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sikan is pemuhatà te edtutungen he menge pemuhat, wey is langun he menge gelemiten kayi, sikan is bisin wey te selevukè din, ");
INSERT INTO mbbOT_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","sikan is mekempet he menge visti te memumuhat he para egemiten ni Aaron wey zuen te menge anak din he maama emun ebpemuhat dan, ");
INSERT INTO mbbOT_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","sikan is lana he idlana wey sikan is mehemut he veyewà he para zuen te Segradu he Lugar. Kinahanglan he ebpekepurung ebpekesungkad te insuǥù ku is kebeeli kayi te langun.” ");
INSERT INTO mbbOT_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Midsuǥù si Moises te Nengazen ");
INSERT INTO mbbOT_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","he keǥiyi zin is menge Israilihanen: “Kinahanglan he edtumanen niw is menge ebpeveelan ku zutun te Andew te Kedhimeley, su iyan heini taman te taman he tuus diyà te pid-elangan tew he ebpetanudtanud keniyu he siak is Nengazen midhimu ku sikiyu he menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kinahanglan he edtumanen niw is menge ebpeveelan ku zutun te Andew te Kedhimeley, su segradu heini he andew. Is minsan hentei he kenà edsunud te ibpetuman ku mehitenged keniyan he andew, kinahanglan he edhimetayan. Is minsan hentei he edterebahu keniyan he andew, ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Seled te heenem he andew is kedterebahu niw, piru te ikepitu he andew, ne himeley kew. Su heini he andew ne segradu para kedì, is minsan hentei keniyu he edterebahu kayi he andew ne kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","17","Umbe sikiyu is menge Israilihanen, kinahanglan he tumana niw is ibpetuman ku keniyu te Andew te Kedhimeley taman te huziyan he lapis te menge kevuwazan. Su iyan heini pirmeninti he tuus te ebpedayun he kebpekid-uyun ku keniyu. Su seled te heenem he andew mibeelan ku is langit wey is kelibutan, ne te ikepitu he andew ne midhimeley a.” ");
INSERT INTO mbbOT_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ne hein nekepasad is Nengazen he ebpekidlalag ki Moises diyà te puntur te Buntud he Sinai, imbeǥey zin diyà te ki Moises is dezuwa he midlumpipì he vatu he zutun isurat te Megbevayà is menge velaud din. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ne hein neseǥipà te menge etew he neuǥet en he wazà meketupang si Moises diyà te kandan, ne mid-amur-amur zan diyà te ki Aaron, ke sikandan te, “Kela ke zuen en mezaat he neulaula zuen te etew he si Moises he nengulu kenitew te kegawas diyà te Ehipto; umbe veeli key te ed-ezapen he ebpekepengulu kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ne migkaǥi si Aaron diyà te kandan te, “Pemul-uta niw is bulawan he menge eritis he in-eeritis te menge esawa niw wey menge anak niw, ne uwita niw kayi te kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ne mibpemul-ut dutun te menge etew is menge eritis dan, ne mid-uwit dan diyà te ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ne migkuwa haazà ni Aaron ne midtunew zin diyà te hulmahan he mid-iring te vaka umbe neveelan haazà he ledawan he vaka. Ne migkaǥi haazà is menge Israilihanen te, “Iyan heini ed-ezapen tew he nengulu kenitew te kegawas diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ne hein naahà ni Aaron he utew haazà ingkesuat te menge etew ne mibpevaal sikandin te pemuhatà diyà te etuvangan dutun te vulawan he vaka, ne migkaǥi sikandin te, “Keeselem duen pista he para te kebeǥey te zengeg diyà te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Umbe, hein meselem en, ne mid-enew is menge etew ne nemuhat dan te pemuhat he edtutungen wey pemuhat he para te meupiya he kedepità. Ne mibpemengaan wey mibpemenginum sikandan, ne mibeelan dan is egkesuatan dan te ebaal te kedlipeylipey te kedsimbaha zan dutun te ed-ezapen dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ne migkeǥiyan si Moises te Nengazen te, “Gègaani nu tupangi sikan is menge etew he mibpenguluwan nu te kegawas diyà te Ehipto su nekevaal zan te mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wazè en meuǥet ne wazè en sikandan med-ikul ziyà te zalan he ibpeikul ku kandan; midtunew zan te vulawan ne mibeelan dan he ed-ezapen he vaka, ne mid-azap dan haazà wey mibpemuhat dan. Ne egkeǥiyen dan te iyan haazà ed-ezapen dan he nengulu kandan te kegawas diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ne migkaǥi pa is Nengazen diyà te ki Moises te, “Utew mesinupaken heeyan he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ne ǥuntaan bey-ani e en kenikew su nepeukan ku en sikandan ne edèdeetan ku en sikandan. Ne iyan ke zà wey is menge kevuwazan nu edhimuwen ku he ventuǥan he nasyun.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Iyan, midhangyù si Moises diyà te Nengazen he iyan Megbevayè din he ke sikandin te, “He Nengazen, maan is utew nu egkepeuki is menge etew nu he impeǥawas nu ziyà te Ehipto pinaaǥi te zekelà he ǥehem nu? ");
INSERT INTO mbbOT_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Emun egeraan nu is menge etew nu kenè be ebpekekaǥi is menge Ehiptohanen te iyan nu zà impeǥewasa kandan diyà te Ehipto su egeraan nu sikandan kayi te vuntud su wey maawà sikandan kayi te kelibutan? Umbe deyzey ke id-awè nu is pauk nu kandan; deyzey ke edhelinen nu is isip nu ne kenè nu zed sikandan edèdeetan. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Tentunuzi nu is menge suluǥuen nu he si Abraham, si Isaac wey si Jacob; tentenuzi nu is meheǥet he penangdù nu ziyà te kandan he ibeǥey nu kandan is utew mahabet he kevuwazan su ebpekeiring te kahabet te menge vituen diyà te zivavew, ne id-amin nu ibeǥey zutun te menge kevuwazan dan is tanà he ingkepenaad nu he ibeǥey ziyà te kandan, ne egkepengevilin dan haazà te taman te taman.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ne tenged kayi wazè ded leusi te Nengazen te edezaat is menge etew zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ne midtupang si Moises puun dutun te vuntud is ed-uwit duen te zezuwa he melumpipì he vatu he midsuratan te Kesuǥuan is pesiziveluyà. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Baal te Megbevayà haazà is midlumpipì he menge vatu, ne iyan en daan sikandin midsurat te menge velaud din dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ne hein ebpekeuvey zan en, nekezineg si Josue te utew meǥurub he menge etew, ne ke sikandin diyà te ki Moises te, “Egkezineg ku is henduen te keǥurub te tebek diyà te kampu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ne migkaǥi si Moises te, “Heeyan he keǥurub, kenà uruhuyan te ebpekezaag ne kenà daan erang te egkezaag, kekenà, keǥurub te ebpemenganta.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ne hein utew en si Moises ebpekeuvey zuen te kampu, neehè din en sikan is ed-ezapen he ledawan he tudu he vaka wey is menge etew he ebpemenayew, ne zutun utew sikandin nererengiti. Ne intimbag din duen te lugtenaan te vuntud sikan is uwiten din he memelumpipì he vatu ne nengetevì haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ne migkuwa zin sikan is ed-ezapen he ledawan he vaka ne mibinsulan din. Ne hein nepasad dutun ne mibpurung din bekbeka ne insimburè din haazà diyà te wahig, ne impeinum din te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ne migkaǥi sikandin diyà te ki Aaron te, “Hengkey is mibeelan kayi te menge etew ziyà te kenikew? Su maan is midtuǥutan nu sikandan te kebaal te zekelà he salà?” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ne midtavak si Aaron te, “Kenà a kenikew mepeuki su netuenan nu en man he heini is menge etew, susuaten he ebaal te mezaat. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Migkaǥi zan kayi te kedì te, ‘Kela ke zuen en mezaat he nehitavù duen te etew he si Moises he iyan mibpeǥawas kenami ziyà te Ehipto; umbe veeli key te ed-ezapen dey he ebpekepengulu kenami.’ ");
INSERT INTO mbbOT_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ne impeuwit ku kandan kayi te kedì is menge zayandayan dan he vulawan, ne sikan is duen dan, mibpemul-ut dan, ne imbeǥey zan kedì ne midtunew ku haazà diyà te hapuy ne pinaaǥi zutun nehimu is ledawan te tudu he vaka.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Naahà ni Moises he wazè en dewaya ni Aaron is menge etew he subre en is kedlipeylipey zan. Ne tenged dutun ed-eengitan sikandan te menge kuntada zan diyà te peliǥuy. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Umbe, midhitindeg sikandin diyà te pultahan duen te kampu zan, ne midhabet megkaǥi te, “Is minsan hentei keniyu he ebpesakup mulà te Nengazen, medhengkayi te kediey!” Ne midhendiyà te kandin is langun he menge Levihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ne migkeǥiyan din sikandan te, “Is Nengazen he Megbevayà te Israel, edsuǥuen kew zin is langun te kedseluniket te menge ispada niw, ne ke và dà kegkamet ne remrembanga niw heini is kampu, ne himetayi niw is lalung he menge etew, minsan menge suled niw, menge emiǥu niw, wey menge siringan niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ne mibpezumazuma zutun is menge Levihanen ne nekepatey zan te 3,000 he menge maama zutun he andew. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Migkaǥi si Moises diyà te menge Levihanen te, “Guntaan he andew insivey kew te Nengazen he menge memumuhat din, su mibpenhimetayan niw minsan is menge anak niw wey menge suled niw. Umbe edtuvazan kew zin guntaan he andew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ne hein sunud he andew, migkeǥiyan ni Moises sikan is menge etew te, “Nekevaal kew te zekelà he salà. Piru edtekezeg a ǥuntaan kayi te vuvungan, diyà te Nengazen, su kela ke pezumdumahi zin ded is hangyù ku he peseyluwa kew zin te salè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ne midlikù si Moises diyà te Nengazen, ne migkeǥiyan din is Nengazen te, “Nekevaal te zekelà he salà sikan is menge etew. Mibaal zan te ed-ezapen dan he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ne edhengyuan ku sikew he peseyluwa nu sikandan dutun te salè dan; ne emun kenè nu en sikandan ebpeseyluwen, ne penasa nu en daan is kedì he ngazan duen te libru he zutun nu ilista is menge ngazan te menge etew nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ne midtavak is Nengazen te, “Iyan ku id-awà duen te libru ku is menge ngazan duen te nekesalà kayi te kediey. ");
INSERT INTO mbbOT_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ne ǥenat ke en, ne zumaha nu sikan is menge etew ziyà te lugar he migkaǥi ku kenikew. Tentenuzi nu he iyan egiya keniyu is belinsuǥuen ku, iyan, egkeuma ǥihapun is timpu te kedsiluti ku keniyan te menge etew tenged te salè dan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Umbe, impaaǥi te Nengazen is bangkit diyà te kandan, su geina te mid-azap dan sikan is bulawan he ed-ezapen he mibeelan ni Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ne migkeǥiyan en maan te Nengazen si Moises te, “Awè ke en kayi he lugar, ne zumaha nu sikan is menge etew he impeǥawas nu puun te Ehipto, ne hendiyè kew en te tanà he insaad ku he ibeǥey ku ziyà te ki Abraham, ki Isaac wey ki Jacob wey ziyà te menge kevuwazan dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ne edsuǥuen ku is belinsuǥuen ku te keǥiya keniyu, ne edsegseǥen ku puun dutun te tanà is menge Canaanhen, menge Amorihanen, menge Hitihanen, menge Pirisihanen, menge Hivihanen, wey menge Jebusihanen. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Haazà he tanà, ne meupiya wey selebpeten egkeerubasa he ebpuunan te edtudà he ǥatas wey teneb. Piru kenà a mulà eduma keniyu su geina te utew kew mesinupaken ne kela ke kenà a meketigker ne egkezeetan kew kediey te kenè kew pa ebpekeuma.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ne hein nezineg haazà duen te menge etew is mesakit he lalag, midlalew sikandan ne wazè dan en medsun-ud te menge elahas. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Su geina te mibpekeǥiyan sikandan te Nengazen ki Moises te, “Utew kew mesinupaken he menge etew ne emun eduma a keniyu te minsan meǥaan dà ne egkezezeetan ku en sikiyu tenged te kenè ku kebpekaantus. Ne pemul-uta niw is menge elahas niw ne iyan e en metau ke hengkey is ebeelan ku ziyà te keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Umbe, mibpemul-ut te menge Israilihanen is menge elahas dan dutun te ziyè dan te Buntud he Horeb. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Minsan ebpekahalin is kampu te menge Israilihanen ne idhalin en daan ni Moises sikan is Tulda ziyà te kenà utew uvey te kampu. Ne iyan ngazan dutun is “Tulda he Edtelevukaayan.” Is minsan hentei kandan he egkesuat he metueni zin is egkesuatan te Nengazen ne edhendutun te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ne emun edhendutun si Moises te Tulda ne ebpemenlawang sikan is menge etew ziyà te menge tulda zan su ebentayan dan si Moises taman te kebpekeseled din dutun te Tulda he ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ne emun diyè en si Moises te seled ne ebpekevavà sikan is mekepal he ǥapun he iring te tukud, ne ziyà ebpundu te ǥemawan duen te Tulda ne ebpekidlalag is Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Emun egkeehè en duen te menge etew ziyà te ǥemawan duen te Tulda he ed-ezapan sikan is mekepal he ǥapun he iring te tukud, ne ebpemenhitindeg sikandan is ed-azap te Nengazen diyà te gemawan te kandan he menge tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ed-etuvangen en te Nengazen si Moises emun edlelaǥan din; iring sikandin te etew he ebpekidlalag te emiǥu zin. Ne ed-ulì si Moises diyà te kampu. Ne sikan mulà is menguhed he maama he timbang din he iyan si Josue he anak ni Nun, ne kenà mulà ed-awà duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Migkaǥi si Moises diyà te Nengazen te, “Layun a kenikew egkeǥiyi he ebpenguluwan ku heini is menge etew te kedhendiyà te tanà he ibeǥey nu kandan, iyan, wazà a kenikew keǥiyi ke hentei is ibpezuma nu kedì. Migkaǥi nu zaan he nepurung a kenikew mekilala wey igkesuat a kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Emun tutuu he nekepenunuat a kenikew, penurua a te menge paaǥi nu su para mekilala ku sikew su wey med-iseg pa is kebpekepenunuat ku kenikew. Tentenuzi nu he menge etew nu heini is menge kevuwazan ni Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ne migkaǥi is Nengazen te, “Edumahan ku sikew, wey ibpehimeley ku sikew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Migkaǥi si Moises te, “Emun kenè ka eduma kenami, deyzey ke kayi key zà kenikew ibpeubpà. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Is kedumahi nu kenami iyan igketueni te zuma he menge etew he nekepenunuat kenikew is menge etew wey siaken. Is kebpekiduma nu kenami iyan ibpekeviza zey te zuma he menge etew kayi te tanà.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ne migkaǥi is Nengazen diyà te ki Moises te, “Ebeelan ku is hangyù nu kediey, su nepurung ku sikew mekilala, wey nekepenunuat ka kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ne ke si Moises te, “Edhangyù a ziyà te kenikew he, ipeehè nu kedì is mekeǥeǥehem he kebpekiduma nu kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ne midtavak is Nengazen te, “Ibpeehè ku kenikew is langun he keupiya ku ne egkeǥiyen ku ziyà te kenikew is mahal he ngazan ku he Nengazen. Siak is Nengazen egkehizuwan ku wey igkeǥaǥew ku is menge pinilì ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kenè ku ibpaahà kenikew is kebuvuked ku su ebpatey is ebpekaahà kedì, ");
INSERT INTO mbbOT_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","iyan, duen lugar he uvey ku he zuen duen batu ne egkehimu ke zutun ka te vatu edhitindeg. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ne emun edsaǥad dutun is anlag he iyan tuus he zutun a, ne id-ahuk ku sikew ziyà te veka zutun te vatu ne id-eles ku sikew su edempaan ku haazà is beka taman te ebpekelavey ad. ");
INSERT INTO mbbOT_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ne id-awè ku zutun is belad ku, ne egkeehè nu is peka ku piru kenè nu mulà egkaahà is kebuvuked ku.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ne migkeǥiyan te Nengazen si Moises te, “Basbas ka te zezuwa he vatu he edlumpipien iring duen te nehuna he imbeǥey ku kenikew, ne idsurat ku zutun is menge lalag he iyan ded sikan is menge lalag he insurat ku zuen te nehuna he melumpipì he menge vatu he migevè nu. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pengandam ka keeselem ke meselem, ne tekezeg ka ziyà te Buntud he Sinai su wey ki meked-uma ziyà te puntur. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kinahanglan he wazà eduma kenikew, kinahanglan daan he wazà minsan sevaha he edhendiyà te minsan hendei keniyan te vuntud, wey minsan is menge kerehidu niw wey menge vaka niw kinahanglan he wazà kandan ebpekepenabtab diyà te lugtenaan keniyan te vuntud.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ne mibasbas si Moises te zezuwa he midlumpipì he vatu he iring duen te nehuna, ne zutun te sunud he andew midselemselem sikandin medtekezeg diyà te Buntud he Sinai is ed-uwit dutun, su iyan haazà insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ne mibulus is Nengazen, ne egkaahà is gapun he zutun sikandin ne midhitindeg sikandin dutun te vuntud duma ki Moises, ne migkaǥi zin is mahal he ngazan din he Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ne midsaǥad is Nengazen diyà te etuvangan din ne mibpekezaǥing sikandin is egkaǥi te, “Siak is Nengazen, Megbevayà a he veliǥeǥawen wey hihizuwen, ne kenà a melemu he egkepauk, ne ibpeehè ku is dekelà he kebmahal ku wey kebmetinumanen ku. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ibpeehè ku is kebmahala ku te mahabet he menge etew, ne ebpeseyluwen ku is kezaat dan, kerepasan dan, wey menge salè dan. Piru edsilutan ku is mekesesalà, ragkes is menge kevuwazan dan taman te iketelu wey ikeepat he lapis te kevuwazan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ne segugunà si Moises midluhud diyà te tanà is ed-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ne ke sikandin te, “Nengazen, ke tutuu he nekepenunuat a kenikew, ne edhengyuan ku sikew he zumahi key kenikew. Utew mesinupaken haazà is menge etew piru peseyluwa nu is mezaat he menge ulaula zey wey menge salè dey, ne zewata key kenikew he menge etew nu.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Migkaǥi is Nengazen diyà te ki Moises te, “Ebaal a guntaan te paaǥi te kebpekid-uyun ku keniyu te menge Israilihanen. Ebeelan ku ziyà te etuvangan te langun he menge zuma nu is egkein-inuwan he menge vaal he wazè ku pa meveeli ziyà te minsan hendei he nasyun kayi te kelibutan. Egketuenan te menge etew kayi te peliǥuy is mekeǥeǥehem he menge vaal ku te Nengazen para kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tumana nu is menge suǥù he ibeǥey ku kenikew ǥuntaan he andew. Emun edlaus kew en, edsegseǥen ku is menge Amorihanen, menge Canaanhen, menge Hitihanen, menge Pirisihanen, menge Hivihanen wey menge Jebusihanen puun duen te tanà he insaad ku keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kenè ka mebpekid-uyun diyà te menge etew he ebpemen-ubpà diyà te tanà he ebeyaan niw, su ebpekekaid keniyu is kebpekid-uyun niw kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Umbe, pemengkaǥa niw is menge pemuhatè dan, penrupeta niw is tedeman dan he menge vatu, wey penempeza niw is menge tukud dan he simbulu te vahi he ed-ezapen dan he si Ashera. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kenè kew med-azap te zuma he ed-ezapen, su siak is Nengazen, utew a egkeepes emun duen duma he ed-ezapen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kenè kew mebpekid-uyun diyà te menge etew he ebpemen-ubpà diyà te tanà he ebeyaan niw, su emun ed-ezapen dan wey ebpemuhaten dan is menge ed-ezapen dan, ne egkehimu he edhinggaten kew zan te keduma kandan, ne egketintal kew te kegkaan te keenen he impemuhat dan diyà te menge ed-ezapen dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ne egkehimu zaan he ebpemengesawa ziyà te kandan is menge anak niw he maama, ne tenged dutun egkehimu he ed-azap dan te menge ed-ezapen dutun te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kenè kew mebaal te menge ed-ezapen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Tumana niw is Pista te Supas he Wazè din Tapey sumalà is kedsuǥua ku kayi ziyà te keniyu. Emun bulan te Abib ne kaan kew te Supas he Wazè din Tapey seled te pitu he andew, su iyan haazà bulan te ked-awè niw ziyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Kediey he ǥaked is kinekekayan he anak niw he maama, wey is meemahan he penganey te menge uyaǥen niw. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Egkehimu he edlekaten niw is penganey te menge asnu niw pinaaǥi te kebpemuhata niw kayi te kedì te nati he kerehidu. Iyan, emun kenè niw edlekaten, kinahanglan he edhimetayan niw haazà is asnu pinaaǥi te kebunggua niw zuen. Kinahanglan daan he edlekaten niw is penganey he menge anak niw he maama. “Kinahanglan he wazà mebpekid-etuvang kedì he wazè din igkahalad. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Terebahu kew seled te heenem he andew, iyan, dutun te ikepitu he andew ne himeley kew, minsan timpu te kebpengeradu wey tiraǥun. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Silibraha niw is Pista te Kedraǥun pinaaǥi te ked-uwit kayi te kediey te egkehuna he sebpet te trigu niw, wey silibraha niw zaan is Pista te Tevas emun egketapus en is tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Is langun he menge maama keniyu, kinahanglan he edtampu kayi te tetelu he pista kada tuig pinaaǥi te ked-azap kedì te Nengazen, he iyan Megbevayè niw te menge kevuwazan ni Israel. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Edsegseǥen ku is menge etew puun te tanà he ibeǥey ku keniyu, ne ebpekeluaǥen ku is tanè niw. Wazà edsurung etawa ed-aǥew te nasyun niw zutun te timpu te kedhengkayi niw te kediey te Nengazen he Megbevayè niw, pinaaǥi te kedtampu niw zutun te tetelu he pista kada tuig. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kenè niw ipemuhat kayi te kedì is lengesa he egkelepikan te minsan hengkey he edtepayan. Kinahanglan he wazà egkesamà taman te meselem duen te edlepaan niw emun Pista te Kedlavey te Belinsuǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Uwita niw ziyà te valey te Nengazen he Megbevayè niw is kinemeupiyahan duen te egkehuna he egkeraǥun niw ziyà te tanè niw. “Kenè niw hilutua is nati he kambing te ǥatas te iney zin.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Migkeǥiyan si Moises te Nengazen te, “Isurat nu heini he menge lalag su iyan heini paaǥi te kebpekid-uyun ku kenikew wey te tivuuk he menge Israilihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ne zutun si Moises seled te kepatan he andew wey kezukileman, ne wazè en sikandin mekekaan wey mekeinum. Ne insurat din diyà te midlumpipì he menge vatu sikan is menge lalag te Nengazen mehitenged te kebpekid-uyun din kandan he iyan sikan is Sepulù he menge Belaud. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Midtupang si Moises puun duen te Buntud he Sinai he ed-uwit duen te zezuwa he melumpipì he vatu he midsuratan te Kesuǥuan. Nenganlag is dagwey zin su geina te nekidlalag sikandin te Nengazen, iyan, wazè din haazà metueni. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ne naahà ni Aaron wey zuen te langun he menge etew is kebpenganlag te zagwey ni Moises hein midtengtengan dan sikandin, ne nahandek sikandan he ed-uvey ziyà te kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Piru mid-umew sikandan ni Moises, umbe mid-uvey si Aaron wey sikan is menge pengulu te menge keet-etawan te Israel, ne mibpekidlalag si Moises kandan. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ne hein nepasad haazà, mid-uvey ziyà te kandin is langun he menge Israilihanen. Ne impenurù din diyà te kandan sikan is langun he menge velaud he imbeǥey te Nengazen diyà te kandin diyà te Buntud he Sinai. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ne emun ebpekepasad en si Moises he ebpekidlalag kandan edtembunan din is dagwey zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Piru emun edseled si Moises diyà te Tulda he Edtelevukaayan su ebpekidlalag te Nengazen, id-awè din is tambun te zagwey zin taman te ebpekeǥas sikandin dutun te Tulda. Ne emun ebpekeǥawas en sikandin, ne egkeǥiyen din diyà te menge Israilihanen is minsan hengkey he ibpekaǥi te Nengazen kandin, ");
INSERT INTO mbbOT_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ne egkaahà te menge Israilihanen is kebpenganlag te zagwey zin. Ne edtembunan din heini taman te edlikù sikandin diyà te Tulda su ebpekidlalag en maan sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Midtiǥum ni Moises is tivuuk he keet-etawan te Israel ne migkeǥiyan din sikandan te, “Iyan heini ibpeulaula te Nengazen keniyu: ");
INSERT INTO mbbOT_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Seled te heenem he andew, beeli niw is menge terebahu niw, piru zutun te ikepitu he andew ne himeley kew, su iyan heini andew he segradu ne para heini te Nengazen. Is minsan hentei he edterebahu te haazà he andew kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Umbe kenè kew medterebahu, minsan is kedtetavun diyà te menge ed-ubpaan niw te kedsusuba te haazà he andew.” ");
INSERT INTO mbbOT_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Migkeǥiyan ni Moises is tivuuk he keet-etawan te Israel te, “Iyan heini insuǥù te Nengazen he veeli niw: ");
INSERT INTO mbbOT_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Halad kew ziyà te Nengazen puun te menge azen niw. Egkehimu he edhalad kew te vulawan, pelata, brunsi, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","welin he meitem is kaavuavu zin, merudtem wey kanggan, linu, manggad he vulvul te kambing, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","lundis te meemahan he kerehidu he midtinà te meriǥà, meupiya he kelasi he lundis, kayu he ekasya, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana para idtubil te sulù, menge pehemut para te lana he idlana wey is para zuen te mehemut he veyewà, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","wey vatu he uniks wey zuma pa he mahalen he menge vatu he para ibpikit duen te ipud wey zuen te teleǥuey ziyà te kumeng kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Is langun keniyu he zuen ketau te kebaal, ne medhengkayi ne veeli zan is minsan hengkey he insuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Beeli zan is Tulda he Ed-ezapan, is menge tambun dutun, is menge edsenggatan, is menge elavat he tabla, menge marku, menge tukud dutun, wey is menge pundasyun. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Elin daan is Kavan te Kebpekid-uyun te Nengazen, is menge tival zuen, is tangeb din wey is kurtina he id-alang duen, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","is lemisahan wey is menge tival kayi wey is langun he gelemiten duen; is supas he ibpemuhat diyà te etuvangan te Megbevayà; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","is selevukà te sulù wey is menge gelemiten duen; is menge sulù duma is lana he idtubil zuen; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","is pemuhatà he edtutungan te veyewà wey is menge tival kayi; is lana he idlana; is mehemut he veyewà; is kurtina zuen te Tulda he Ed-ezapan; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","is pemuhatà te pemuhat he edtutungen, tuuǥà he brunsi, is menge tival wey is langun he gelemiten kayi; is bisin he brunsi wey is selevukè din; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","is menge kurtina he ibpeliǥuy te lama wey is menge tukud din wey is menge pundasyun; is kurtina ziyà te pultahan te lama; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","is menge palpal wey is menge vanting he para zuen te Tulda he Ed-ezapan wey te lama kayi, ");
INSERT INTO mbbOT_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","wey is mekempet wey segradu he menge visti he para te memumuhat he si Aaron wey te menge anak din he maama he ibivisti zan emun ebpemuhat dan duen te Segradu he Lugar.” ");
INSERT INTO mbbOT_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ne mid-awà is tivuuk he keet-etawan te Israel diyà te etuvangan ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ne is kada sevaha kandan he egkesuat he edhalad, mid-uwit din is idhalad din diyà te Nengazen, he para te ibaal zuen te Tulda he Edtelevukaayan wey te langun he gelemiten kayi, wey is langun he egkinehenglanen para meveeli is menge visti te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Is langun he egkesuat he edhalad, maama wey vahi, mid-uwit te menge mahalen he menge lipit, menge eritis, menge rintì, wey nekedseselekawà he klasi te menge elahas he vulawan. Mid-uwit dan is menge vulawan dan su impemuhat dan he pemuhat he ibayew ziyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Duen midhalad te welin he meitem is kaavuavu zin, merudtem wey kanggan, linu, manggad he vulvul te kambing, lundis te meemahan he kerehidu he midtinà te meriǥà, wey meupiya he kelasi he lundis. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Is duma, mid-uwit te pelata etawa brunsi, wey menge tabla he ekasya he inhalad dan diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Is menge vahi he uluwanen he ebpenhavel, mid-uwit dan te welin he meitem is kaavuavu zin, merudtem wey kanggan, wey linu. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ne is menge vahi he metau he edhavel te vulvul te kambing, ne meupiya is gehinawa zan te kedhavel kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mibeǥey zaan sikan is menge pengulu zan te menge vatu he uniks wey zuma he mahalen he menge vatu he ibpikit duen te visti he ipud, wey zuen te teleǥuey ziyà te kumeng. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Duen daan imbeǥey zan he menge penaket wey lana te ulibu he para te idtubil zuen te menge sulù, wey lana he para te idlana, wey is para zuen te mehemut he veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Is langun he menge Israilihanen, maama wey vahi he egkesuat he ebeǥey, mid-uwit dan te idhalad dan diyà te Nengazen he ebpuun te keputian te atey zan is kebeǥaya zan duen; ne para haazà te langun he ebpeveelan te Nengazen kandan he impekaǥi zin ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Migkeǥiyan ni Moises is menge Israilihanen te, “Mibpilì te Nengazen si Bezalel, is anak he maama ni Uri he apù ni Hur he sakup te tribu ni Juda. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ebpeulinan din sikandin te Mulin-ulin din ne ebeǥayan din te ketau wey ebilidad te kebaal te minsan hengkey he vuluhaten– ");
INSERT INTO mbbOT_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ebeǥayan ku sikandin te ketau te kebaal te mekempet he menge vutang he vulawan, pelata, wey brunsi; ");
INSERT INTO mbbOT_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","te kebpurma te mahalen he menge vatu he ibpemikit, kegkurti te kayu, wey kebaal te zuma he edeyzeyanan he terebahu. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Imbeǥey te Nengazen diyà te kandin wey ziyà te ki Oholiab he anak he maama ni Ahisamac he nesakup te tribu ni Dan, is ketau te kebpetueni te zuma te netuenan dan pinaaǥi te kebpenurù dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Imbeǥey zin diyà te kandan is ketau te kebaal te langun he kelasi te terebahu: iring te kebpandey te vatu, kebaal te menge zayandayan, wey kedhavel te manggad, keburda te linu, welin he meitem is kaavuavu zin, merudtem wey kanggan. Egkehimu zan is langun he kelasi te terebahu, wey utew sikandan metau he ebaal. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Si Bezalel, si Oholiab, wey is duma pa he mibeǥayan te Nengazen te ketau wey ebilidad te kebaal te nekedseselekawà he vuluhaten iyan midterebahu te kebeeli zuen te Tulda sumalà te insuǥù te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Umbe, impetawag ni Moises si Bezalel, si Oholiab wey is duma pa he mibeǥayan te Nengazen te ketau wey ebilidad te kebaal te nekedseselekawà he vuluhaten, wey utew egkesuat he edtavang te kedterebahu. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ne imbeǥey ni Moises diyà te kandan is langun duen te inhalad te menge Israilihanen he para te kedtukuza zuen te Tulda. Ne kada meselem dutun ed-uwit is menge Israilihanen diyà te ki Moises te idhalad dan. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Umbe, mid-ewaan dèpa te menge terebahanti zuen te Tulda is terebahu zan ne midhendiyè dan te ki Moises is egkaǥi te, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Midsubre en is imbeǥey te menge etew te egkinehenglanen te kebeeli te ebpeveelan te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ne tenged dutun mibpekeǥiyan ni Moises is menge etew zuen te tivuuk he kampu he med-engked dan en he ed-amut te para te kebeeli zuen te Tulda he Ed-ezapan, umbe wazè en human med-uwit diyà te kandin te menge halad sikan is menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Su sikan is ingkeveǥey zan en midsubre en te egkinehenglanen para te kedhimesaza te terebahu. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Is langun he memetau he ebpemenerebahu, ne iyan impevaal zan duen te Tulda he Ed-ezapan. Iyan migamit dan te kebaal zan dutun is sepulù he lukut he linu he miburdahan te welin he meiten is kaavuavu zin, merudtem wey kanggan. Ne nepurungan meburdahi heini te zagwey te menge kirubin. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Imped-iiring dan is kezekelà te kada sevaha, 42 he ǥiek is kelayat din ne heenem he ǥiek is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ne impebpipikit dan is kada lelima he kurtina (umbe nehimu zà haazà he zezuwa he tiglima). ");
INSERT INTO mbbOT_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ne mibeelan dan te ebpen-iringen te sising is manggad he meitem is kaavuavu zin is diyà te kada kilid duen te ikezuwa he apid te sevaha zutun te impikit he menge tila. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Tig-50 he mibpen-iring te sising is intaud dan diyà te kada kilid ne impedsineruwà haazà. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ne mibaal zan te 50 he kaw-it he vulawan su wey mekedliliib sikan is menge mibpen-iring te menge sising duen te zezuwa he impebpikit he menge tila. Pinaaǥi kayi ne neveelan is Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ne mibaal zaan sikandan te tambun duen te Tulda. Ne iyan migamit dan is 11 he lukut he manggad he vulvul te kambing. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Is kada manggad ne 45 he ǥiek is keluǥayad ne heenem he ǥiek is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ne impebpipikit dan te edtahi haazà is lelima he tila, ne iring ded duen te nesamà he heenem. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ne midteuzan dan te 50 he mibpen-iring te sising is kilid duen te in-apid te mibpebpikit he menge tila, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ne impedliib dan pinaaǥi te 50 he kaw-it he brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ne mid-uman pa sikandan mebaal te zezuwa he tambun, is sevaha, lundis te meemahan he kerehidu he midtinà te meriǥà, ne is ikezuwa meupiya he kelasi te lundis. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ne mibaal sikandan te id-elavat dutun te Tulda. Is migamit dan ne tabla he ekasya. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Is kada sevaha zutun, ne 15 he ǥiek is keluǥayad din ne dezuwa he ǥiek is keluag din, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ne migkurtiyan haazà is kada purù dutun te tabla su wey mekesumpul heini duen te sevaha pa he tabla. Iring kayi is mibeelan dan te kada tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Is 20 kayi he menge tabla, ne in-elavat dan diyà te egkezivavà he parti zuen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Heini he menge tabla ne impehulma zan duen te 40 he peuntuzà he pelata–su zezuwa he peuntuzà te kada tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Is dapit te zizaya he parti zuen te Tulda ne mid-elevatan dan te 20 he tabla, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","wey impehulma zaan duen te 40 he menge peuntuzà he pelata–dezuwa he peuntuzà is kada tabla. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Is dapit te edsenlepan he vahin dutun te Tolda, he iya is divaluy kayi, mid-elevaatan dan te heenem he tabla, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","wey tig-dezuwa he tabla he para ziyà te kada suyuk. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Heini he menge tabla zutun te suyuk ne melig-en is kebpedsumpula zutun te zizalem ne egkeheǥet heini ziyà te divavew pinaaǥi zutun te mid-iring te sising. Iring kayi is mibeelandan dutun te zezuwa he tabla dutun te suyuk. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Umbe, zuen walu he menge tabla he para ziyà te menge suyuk wey 16 he menge peuntuzà he pelata kada tabla, egkinahanglan te zezuwa he peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ne mibaal sikandan te menge marku he kayu he ekasya he para te elavat, lelima is para te egkezizaya he vahin duen te Tulda, ");
INSERT INTO mbbOT_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lelima zaan is para te egkezivavà he vahin, wey lelima pa he para te zapit te edsenlepan he egkeiniyuǥan he vahin duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ne is ibelavag he ibpeteliwazà, duen te elavat ne intaud dan puun te kilid dutun te Tulda he Ed-ezapan pehendiyà te zivaluy he elavat. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mid-epizan dan te vulawan sikan is menge tabla, ne mibaal sikandan te mibpen-iring te rintì he vulawan he impenaud duen te menge tabla he iyan midlugluǥan duen te menge velavag he mid-epizan daan te vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ne mibaal sikandan te kurtina he linu, ne miburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan, ne mibpurungan burdahi te zagwey te kirubin. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ne ziyè dan haazà ipikit te mibeelan dan he heepat he menge tukud he ekasya he mibpen-epizan te vulawan wey midteuzan daan te vulawan he menge kaw-it. Ne ziyà haazà ipehulma is menge tukud te menge peuntuzà he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ne sikan is gemawan duen te Tulda he Ed-ezapan, mibeelan dan te kurtina he linu he miburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan. Ne utew heini mibpurungi burdahi. ");
INSERT INTO mbbOT_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Mibaal zaan sikandan te lelima he tukud he zuen duen menge kaw-it, ne impikit dan dutun sikan is kurtina. Heini he menge tukud, mid-epizan te vulawan ragkes is menge in-ulu zuen wey menge kebilya, ne impehulma heini ziyà te lelima he peuntuzà he brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ne mibeelan eni Bezalel is Kavan te Kebpekid-uyun he kayu he ekasya, ne haazà, 45 he vaney is keluǥayad din, 27 he vaney is keluag din, ne 27 he vaney is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ne mid-epizan dan te lunsey he vulawan is diyà te seled wey is diyà te gawas kayi, ne midribitiyan dan te vulawan is diyà te menge kilid kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ne mibaal sikandin te heepat he mibpen-iring te rintì he vulawan, ne impikit heini zuen te heepat he paa kayi. Tig-dezuwa is diyà te pesikilizà kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ne mibaal zaan sikandan te menge tival he kayu he ekasya he mid-epizan dan te vulawan. Tig-dezuwa is diyà te kada kilid. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ne in-ahuk dan haazà is tival zuen te menge mibpen-iring te rintì duen te kada kilid te Kavan para metival zan haazà is Kavan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ne mibaal zaan sikandan te Kavan he lunsey he vulawan he 45 he vaney is kelayat din wey 27 he vaney is keluag din. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Ne mibaal sikandan te zezuwa he ledawan he kirubin he vulawan duen te kada puru te tangeb duen te Kavan. In-ubpu zà heini te kebeeli zuen te tangeb te Kavan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nevekar is menge pakpak duen te menge kirubin diyà te zivavew zuen te tangeb su wey zan melembungi heini. Impedsineruwà haazà is dezuwa he zutun ipetengteng te tangeb. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ne mibaal zaan sikandan te lemisahan he ekasya, he 36 he vaney is keluǥayad din, ne 18 he vaney is keluag din wey 27 he vaney is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ne mid-epizan dan haazà te lunsey he vulawan wey midribitiyan dan daan te vulawan is peliǥuy zutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ne midsenipahan dan is ebpekeliǥuy ziyà te zivavew zutun te lemisahan te heepat he vaney is keluag din, ne is divavew zutun te insenipa zan, midribitiyan dan te vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ne mibaal sikandan te heepat he mibpen-iring te rintì he vulawan, ne impikit dan heini zuen te heepat he tukud te lemisahan ");
INSERT INTO mbbOT_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","uvey te senipa. Kayi zan idtaud sikan is tival he idtival zuen te lemisahan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Heini he menge tival, ekasya he mid-epizan te vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ne mibaal sikandan te lunsey he vulawan he menge gelemiten dutun te lemisahan he iyan is: menge pinggan, menge tasa, menge yehung, wey menge tivud he egemiten para te menge pemuhat he inumen. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Mibaal zan daan te selevukà te sulù he lunsey he vulawan is paa zin, lawa zin, wey is dayandayan dutun he menge vulak, he is duma zuen wazè pa mebekar ne is duma mibekar en. Haazà is dayandayan idredsè dà is kebpurmaha kayi zuen te kebpurmaha te selevukà te menge sulù su teleubpu zà heini. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Haazà is selevukà te sulù, duen din heenem he subpang; tigtetelu is diyà te kada kilid kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Is kada subpang dutun, duen din tetelu he zayandayan he menge vulak he mid-iring te vulak he almindru, he is duma, memetivurun pa, ne is duma nememekar en. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ne is lawa zutun te selevukà te sulù, ne zuen dutun heepat he zayandayan he mid-iring te vulak he almindru he wazè pa mebekar wey mibekar en. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Duen sevaha he vulak diyà te zizalem te kada paris te subpang. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Haazà is menge zayandayan wey menge subpang, inredsè dà is kebpurmaha zuen te kebeeli zuen te lewahan te selevukà te sulù. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Mibaal zaan sikandan te pitu he sulù, menge lipit kayi, wey menge idtaya te egkeepus he pebilu zuen te sulù. Heini is langun lunsey he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Menge 35 he kilu he lunsey he vulawan is neǥamit te kebeeli zuen te selevukà te sulù wey te langun he menge gelemiten kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Mibaal zaan sikandan te pemuhatà he kayu he ekasya he para tutungà te veyewà. Kuwedradu heini; 18 he vaney is keluǥayad din wey keluaǥan din, 36 he vaney is ketikang din. Duen kayi menge sungeysungey ziyà te suyuk din he inredsè dà is kebpurmaha zuen te kebeeli kayi te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Mid-epizan dan te lunsey he vulawan is dapit te zivavew kayi, is heepat he kilid kayi, wey sikan is menge sungeysungey ziyà te menge suyuk, ne midribitiyan dan te vulawan is peliǥuy kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Midteuzan dan te zezuwa he mibpen-iring te rintì he vulawan is dizalem duen te ribiti ziyà te pesiziveluyà duen te pemuhatà, he para edteuzan te menge tival he idtival kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Haazà is mibeelan he tival, kayu he ekasya he mid-epizan te vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Mibaal zaan sikandin te segradu he lana he para te idlana wey lunsey he veyewà he utew mehemut. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Mibaal zaan sikandan te kuwedradu he pemuhatà te pemuhat he edtutungen. Iyan migamit dan is kayu he ekasya. Pitu wey tengà he ǥiek is kelayat din ne pitu zaan wey tengà he ǥiek is keluag din, ne heepat wey tengà he ǥiek is ketikang din. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mibeelan dan heini te menge sungeysungey ziyà te heepat he suyuk kayi, he inredsè dà is kebpurmaha kayi te kebeeli zuen te pemuhatà. Mid-epizan dan heini is pemuhatà te brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Is langun he menge gelemiten dutun te pemuhatà ne brunsi, he iyan is: menge selevukà te avu, menge pala, menge yahung, menge zezekelà he tinidur he para te usa, wey is menge selevukà te vaǥa. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mibaal zaan sikandan te tuuǥà he brunsi he para zutun te pemuhatà, ne midsevukan dan te untuzà diyà te seled dutun te pemuhatà, ne ziyà haazà te liwezaan puun te zivavew. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Mibaal zaan sikandan te heepat he mibpen-iring te rintì he brunsi ne impikit dan heini ziyà te heepat he suyuk dutun te tuuǥà he brunsi. Heini is mibpen-iring te rintì ne iyan edteuzan te menge tival he idtival zutun te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Is menge tival he mibeelan, kayu he ekasya he mid-epizan te brunsi. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Intaud dan sikan is menge tival zuen te mibpen-iring te rintì he ziyà te kada kilid dutun te pemuhatà su para mevinting heini. Tabla is mibeelan dan he pemuhatà he mibpuwang is seled din. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ne mibaal sikandan te brunsi he bisin wey te untuzà kayi he brunsi zed. Is menge brunsi he migamit te kebeeli kayi, ne ebpuun diyà te brunsi he peǥelungan te menge vahi he nemenilbi ziyà te gemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Mibeelan dan te lama sikan is Tulda, ne mibpeliǥuyan dan heini te kurtina he linu. Is keluǥayad te kurtina he impelingut diyà te zivavà he kilid ne 150 he ǥiek. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Impikit dan heini he kurtina ziyà te 20 he tukud he brunsi he ziyà ipehulma te 20 daan he peuntuzà he brunsi. Is mibpikitan dan dutun te kurtina, iyan is menge kaw-it he pelata he nekepikit diyà te menge kebilya he pelata zuen te menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Is kurtina he ziyà te zizaya he kilid 150 daan he ǥiek is keluǥayad din, ne impikit heini ziyà te 20 he tukud he brunsi he impehulma ziyà te 20 he peuntuzà he brunsi. Is mibpikitan dutun te kurtina iyan is menge kaw-it he pelata he nekepikit diyà te menge kebilya he pelata zuen te menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Is kurtina he ziyà dapit te edsenlepan he kilid, 75 he ǥiek is keluǥayad din, ne impikit heini ziyà te sepulù he tukud he impehulma ziyà te sepulù daan he menge peuntuzà. Is mibpikitan dutun te kurtina, iyan is menge kaw-it he pelata he nekepikit diyà te menge kebilya he pelata zuen te menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Is dapit te edsilaan he kilid duen te lama 75 zaan he ǥiek is keluǥayad din. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ne zuen kayi ǥemawan he ed-elangan daan te kurtina is kilid din. Is kurtina ziyà te egkekewanan, 22 he ǥiek is keluǥayad din, ne ibpikit heini ziyà te tetelu he tukud he ibpemehulma ziyà te tetelu zaan he menge peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Is kurtina ziyà te egkeǥivang, 22 wey tengà he ǥiek is keluǥayad din, ne intaud heini ziyà te tetelu he tukud he impehulma ziyà te tetelu he peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Pudu linu he manggad is kurtina he impeliǥuy zuen te lama. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Is menge pundasyun te menge tukud, brunsi, ne is menge kaw-it wey menge kebilya kayi, ne pelata. Is menge in-ulu te menge tukud, mid-epizan te pelata. Is langun he menge tukud dutun te peliǥuy te lama, ne zuen daan menge kebilya he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Is kurtina ziyà te pultahan dutun te lama, ne manggad he linu he miburdahan te meitem is kaavuavu zin, merudtem wey kanggan. Ne utew heini mibpurungan te eburda. Is keluǥayad kayi, 30 he ǥiek, ne is ketikang din, pitu wey tengà he ǥiek, iring te ketikang te menge kurtina ziyà te peliǥuy zuen te lama. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Heini he kurtina, impikit diyà te heepat he tukud he impehulma ziyà te heepat daan he brunsi he peuntuzà. Is menge kaw-it wey menge kebilya zutun te menge tukud, ne pelata, wey mid-epizan te pelata is menge in-ulu zutun te tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Lunsey he brunsi is menge palpal te menge vanting dutun te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Iyan heini menge himan he neǥamit te kebpehitindeǥa zuen te Tulda he Ed-ezapan he zutun itaǥù sikan is Kesuǥuan. Heini is menge himan, inlista te menge kevuwazan ni Levi sumalà te suǥù ni Moises. Heini he vuluhaten, iyan midumala zuen si Itamar he anak ni Aaron he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Is midumala te kebenguna zuen te Tulda he Ed-ezapan, iyan si Bezalel he anak ni Uri he apù ni Hur, he ebpuun diyà te tribu ni Juda. Mibeelan din is langun he insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Is umuuǥup din, iyan si Oholiab he anak ni Ahisamac, he ebpuun diyà te tribu ni Dan. Metau sikandin he edterebahu wey metau he ebpurma te meupiya he ed-ahaan, wey eburda te linu te meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Is keveǥat te langun he vulawan he inhalad para egemiten te kebeeli zuen te Tulda he Ed-ezapan, menge 1,000 he kilu ziyà te timbangan te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Is keveǥat te langun he pelata he netiǥum, ne menge 3,520 he kilu ziyà te timbangan te menge memumuhat. Iyan mibeǥey kayi is menge etew he nelista te sinsus. Is kada sevaha kandan mibeǥey te heenem he gramu ziyà te timbangan te menge memumuhat. Duen 603,550 he etew he is keǥurang dan 20 he tuig pehendiyà te metikang is nelista te sinsus. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Is 3,500 he kilu he pelata, migamit haazà te kebaal te 100 he menge peuntuzà duen te Tulda wey menge kurtina. Nekesavuk te tig-35 he kilu is kada peuntuzà. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Is nesamà he 20 he kilu he pelata, mibeelan he menge kaw-it wey menge kebilya zuen te menge tukud, wey in-apid te menge in-ulu te menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Is keveǥat te brunsi he inhalad diyà te Nengazen, menge 2,500 he kilu. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Migamit heini te kebaal te menge pundasyun te menge tukud duen te menge gemawan te Tulda he Edtelevukaayan. Is duma zutun, migamit te kebaal te pemuhatà he brunsi wey te menge tuuǥà kayi, wey te langun he gelemiten dutun te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Iyan ded haazà migamit dan te kebaal te menge pundasyun te menge tukud duen te alad, wey zuen te gemawan dutun te lama wey te langun he menge palpal zuen te Tulda he Ed-ezapan wey menge palpal ziyà te alad. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Midtahì ensi Bezalel te segradu he menge visti he para te menge memumuhat sumalà te insuǥù te Nengazen ki Moises. Is manggad he migamit dan welin he meitem is kaavuavu zin, merudtem wey kanggan. Iyan daan heini klasi te manggad he migamit dan hein mibeelan dan te visti si Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Midtahì dan daan te ipud. Is manggad he migamit dan linu he miburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Mibaal sikandan te tanur he vulawan pinaaǥi te kedlumpipia zan duen te vulawan wey kebpenebtevasa zuen he mibpekenipis. Ne imburda zan heini te linu duma te welin he meitem is kaavuavu zin, merudtem wey kanggan. Utew meupiya is kegkeburdaha kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Dezuwa he vahin heini he visti, is peka wey sineruwan, ne impedsumpul heini ziyà te tedted din diyà te pemenayen. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Is bakes kayi, linu zaan he miburdahan te vulawan he tanur wey welin he meitem is kaavuavu zin, merudtem, wey kanggan. Mibeelan dan heini sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Intaud dan is menge vatu he uniks diyà te selevukà he vulawan. Ne in-ukir zan dutun is menge ngazan te menge anak he maama ni Jacob. Iring heini te ked-ukir te para ibmarka. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ne impikit dan haazà duen te menge tedted diyà te pemenayen duen te ipud su tedeman haazà he menge vatu para te menge tribu te Israel. Mibeelan dan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Mibaal zaan sikandan te teleǥuey ziyà te kumeng, ne utew meupiya is kegkeveeli kayi. Is manggad he migamit para kayi, ne iring ded duen te migamit dan te kebaal te visti he ipud: linu he miburdahan te vulawan he tanur wey welin he meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Heini is teleǥuey ziyà te kumeng midubli is kedlumpìa zuen ne kuwedradu heini; siyam he vaney is keleyatan din wey keluaǥan din. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ne midteuzan dan heini te heepat he linya te mahalen he menge vatu. Is nehuna he linya, rubi, tupas, wey biril; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","is ikezuwa he linya, imirald, sapiru, wey diyemanti; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","is iketelu he linya, hasintu, agata, wey amatista; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ne ikeepat he linya, krisulitu, uniks, wey haspir. Ne impikit dan heini ziyà te selevukà he vulawan. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Is kada sevaha zuen te sepulù wey dezuwa he menge vatu, ne in-ukir zutun is sevaha zaan he ngazan te sevaha he anak ni Jacob, su iyan haazà edriprisintar te sepulù wey zezuwa he ebpuunan te menge kevuwazan ni Israel. Is ked-ukira zutun ne iring te ked-ukir te para ibmarka. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Midteuzan dan daan te rantey he lunsey he vulawan sikan is teleǥuey ziyà te kumeng. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Mibaal zaan sikandan te dezuwa he selevukà he vulawan wey zezuwa he mibpen-iring te sising he vulawan, ne impikit dan heini is dezuwa he mibpen-iring te sising diyà te zivavew he menge suyuk duen te teleǥuey ziyà te kumeng. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ne inhiket dan sikan is dezuwa he rantey he vulawan duen te zezuwa he iring te sising he zutun te apid te kumeng he teleǥuey, ");
INSERT INTO mbbOT_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ne sikan is dezuwa he purù duen te rantey, ne impikit dan diyà te selevukà he zuen idsanggat te menge tedted diyà te pemenayen duen te ipud. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Mibaal zaan sikandan te zezuwa pa he mibpen-iring te sising he vulawan. Ne impikit dan heini zuen te egkeiniyuǥan duen te zizalem he menge suyuk duen te teleǥuey ziyà te kumeng, he id-apid duen te ipud. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ne mibaal pa sikandan te zezuwa pa he mibpen-iring te sising he vulawan, ne impikit dan heini zuen te ipud diyà te zivavew te vakes kayi. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ne impedhiketè dan pinaaǥi te meitem is kaavuavu zin he hiket sikan is dapit te zizalem he iring te sising duen te apid te kumeng he teleǥuey wey sikan is mibpen-iring te sising duen te ipud. Pinaaǥi kayi ebpekepurung ebpekepikit sikan is apid te kumeng he teleǥuey zuen te ipud. Mibeelan dan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Mibaal zaan sikandan te visti he pendivavew he visti te memumuhat. Heini he visti ed-epizan duen te ipud. Is manggad he migamit dan te kedtahì kayi welin he lunsey he meitem is kaavuavu zin. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Heini he visti duen din liab he mid-epuruwan su wey kenà mevindas. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mibpemikitan dan is peliǥuy te sidsid kayi he visti te mibpen-iring te prutas he pumigranata, he iyan mibeelan is linu he miburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Mibel-etan dan sikan is menge zayandayan te menge seriyew he lunsey he vulawan. Heini he visti ibivisti ni Aaron emun ebpenilbi sikandin te Nengazen. Mibeelan dan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Mibaal zan daan te menge pendizalem he visti he para ki Aaron wey para zuen te menge anak din he maama; iyan migamit dan is manggad he linu. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Iyan ded daan haazà klasi te manggad he migamit dan te kebaal te menge tengkulu, menge kalù wey menge pendizalem he visti. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Is menge vakes, linu zaan he miburdahan te welin he meitem is kaavuavu zin, merudtem wey kanggan. Ne utew heini mibpurungi te eburda. Midhimu zan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Mibaal sikandan te midalya he lunsey he vulawan ne mibpe-ukiran dan heini te iring te ked-ukir te para te ibmarka. Ne iyan heini lalag he in-ukir zuen: “Insivey para te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ne impikit dan heini ziyà te egkesineruwan te tengkulu ni Aaron pinaaǥi te meitem is kaavuavu zin he hiket. Mibeelan dan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nepasad is langun he terebahu zuen te Tulda he Ed-zapan, he egngezanan daan he Tulda he Edtelevukaayan. Mibeelan te menge Israilihanen is langun he insuǥù te Nengazen diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ne impeehè dan diyà te ki Moises haazà is Tulda he Ed-ezapan wey is langun he menge gelemiten dutun: is menge kaw-it, menge elavat, menge marku, menge tukud, menge pundasyun, ");
INSERT INTO mbbOT_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","is tambun he lundis te meemahan he kerehidu he midtinà te meriǥà, is tambun he meupiya he kelasi he lundis, is menge kurtina; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","is Kavan te Kebpekid-uyun wey is tambun din wey is menge tival kayi; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","is lemisahan wey is langun he gelemiten kayi, wey is supas he ibpemuhat diyà te etuvangan te Megbevayà; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","is lunsey he vulawan he selevukà te menge sulù, is ebpekelinya kayi he menge sulù, wey menge gelemiten dutun; wey is lana he idtubil te sulù; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","is bulawan he pemuhatà; is lana he para te idlana; is mehemut he veyewà; is kurtina he para te gemawan duen te Tulda; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","is brunsi he pemuhatà wey is tuuǥà he brunsi kayi, is menge tival zuen, wey is langun he menge gelemiten kayi; is bisin wey te selevukè din; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","is menge kurtina he ibpeliǥuy zuen te lama wey is menge tukud kayi wey menge pundasyun; is kurtina te pultahan dutun te lama; is menge hiket wey menge palpal para te kurtina te lama; is langun he gelemiten dutun te Tulda he Ed-ezapan, he migngezanan daan te Tulda he Edtelevukaayan; ");
INSERT INTO mbbOT_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","wey is mekempet wey segradu he menge visti he para te memumuhat he si Aaron wey te menge anak din he menge maama, he ibivisti zan emun ebpemuhat dan duen te Segradu he Lugar. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Mibeelan te menge Israilihanen is langun he terebahu he insuǥù te Nengazen diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ne mibpurungan susiya ni Moises is minsan hengkey zutun, ne neehè din he sungkad is kegkeveeli te langun dutun te insuǥù te Nengazen. Umbe mibpenubtuvazan sikandan ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ne migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Dutun te egkehuna he andew te egkehuna he vulan te tuig, ne ipelastar niw en heeyan is Tulda he Ed-ezapan, he egngezanan daan he Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Iseled niw zutun sikan is Kavan te Kebpekid-uyun, ne elangi niw te kurtina. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Iseled niw sikan is lemisahan ne isavuk niw zutun sikan is menge gelemiten kayi. Ne elin niw iseled sikan is selevukà te sulù ne isavuk niw zutun sikan is menge sulù. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Isavuk niw sikan is pemuhatà he vulawan he edtutungan te veyewà diyà te etuvangan duen te Kavan te Kebpekid-uyun, ne itaud niw is kurtina ziyà te gemawan duen te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Isavuk niw ziyà te etuvangan duen te Tulda he Ed-ezapan sikan is pemuhatà te edtutungen he pemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ne isavuk niw sikan is bisin, diyà te pid-elangan duen te Tulda wey zuen te pemuhatà, ne teǥui niw haazà te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ipenaud niw sikan is ibpeliǥuy zuen te Tulda he menge kurtina, ragkes sikan is kurtina zuen te gemawan te lama. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ne ipehinungud niw kayi te kediey sikan is Tulda wey is langun he gelemiten duen pinaaǥi te kedlenahi niw zuen te segradu he lana, ne egkehimu haazà he segradu. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Edheplasan daan haazà is pemuhatà te pemuhat he edtutungen wey is langun he menge gelemiten kayi pinaaǥi te kebpehinunguza kayi te kedì, ne egkehimu heini he segradu. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ne ipehinungud niw zaan sikan is bisin wey is selevukè din, te iyan gihapun he paaǥi. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ne zumaha nu si Aaron wey sikan is menge anak din he maama ziyà te ǥemawan duen te Tulda he Edtelevukaayan ne ipepemeziǥù nu sikandan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ne sun-uzi nu si Aaron duen te menge visti te memumuhat, ne lenahi nu sikandin su iyan heini paaǥi te kebpehinunguza kandin kayi te kedì, su wey mekepenilbi sikandin kediey pinaaǥi te kebpemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dumaha nu zaan sikan is menge anak din he maama, ne ipesun-ud kandan is pendizalem he visti zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ne lenahi nu sikandan iring te kedlanahi nu te amey zan, su para mekepenilbi sikandan kediey pinaaǥi te kebpemuhat pehendiyè en te huziyan he menge lapis te kevuwazan.” ");
INSERT INTO mbbOT_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ne mibeelan ni Moises haazà is langun he insuǥù te Nengazen kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Umbe, midtukud is Tulda he Ed-ezapan dutun te nehuna he andew te nehuna he vulan dutun te ikezuwa he tuig te kegkeliwas te ked-awè dan diyà te Ehipto. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Iyan heini kedtukuza ni Moises duen te Tulda: Intaud din is menge pundasyun kayi, is menge elavat, wey menge marku te elavat, wey menge tukud. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ne mibekar zin sikan is Tulda, ne impetaud din is menge elavat he manggad wey is tambun he iyan atep duen. Mibeelan din heini is langun sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ne intaǥù din duen te Kavan sikan is melumpipì he vatu he midsuratan te Kesuǥuan, ne in-ahuk din duen te menge mibpen-iring te rintì duen te Kavan sikan is menge tival, ne midtembunan din heini. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ne inseled din sikan is Kavan duen te Tulda he Ed-ezapan, ne intaud din sikan is kurtina su wey mezilungi haazà is Kavan te Kebpekid-uyun. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ne impelastar zin is lemisahan diyà te seled dutun te Tulda, ziyà te egkezizaya he kilid, he ziyà te ǥawas duen te kurtina. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ne insavuk din dutun te lemisahan sikan is supas he ibpemuhat diyà te etuvangan te Nengazen. Mibeelan din heini is langun sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Impelastar zin daan sikan is selevukà te sulù diyà te seled duen te Tulda, diyà te egkesineruwan duen te lemisahan he zapit te egkezivavà. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ne insavuk din sikan is menge sulù diyà te etuvangan te Nengazen. Mibeelan din heini is langun sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Inseled din duen te Tulda sikan is bulawan he pemuhatà, ne ziyè din ipelastar te etuvangan duen te kurtina, ");
INSERT INTO mbbOT_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ne midtutung din dutun is mehemut he veyewà, su iyan haazà insuǥù te Nengazen. Mibeelan din heini is langun sumalà te insuǥù te Nengazen kandin. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Intaud din daan sikan is kurtina ziyà te gemawan duen te Tulda, ");
INSERT INTO mbbOT_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ne impelastar zin diyà te uvey te ǥemawan sikan is pemuhatà te pemuhat he edtutungen. Ne nemuhat sikandin dutun te menge pemuhat he edtutungen, wey menge pemuhat he gasa. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ne insavuk din sikan is bisin diyà te pid-elangan duen te Tulda wey zuen te pemuhatà ne midteǥuan din haazà te wahig he ibpenlùlù. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ne si Moises, si Aaron wey sikan is menge anak din he maama ebpenlùluan dan is menge velad dan, wey menge paa zan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ebpenlùlù dan emun edseled dan dutun te Tulda etawa edhenduen dan te pemuhatà. Mibeelan dan heini is langun sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ne impelastar ni Moises sikan is menge kurtina zuen te lama, he ebpekeliǥuy zuen te Tulda, wey zuen te pemuhatà, ragkes sikan is kurtina te gemawan dutun te lama. Ne nepasad ni Moises is langun he vuluhaten. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ne hein nepasad heini is langun netembunan te ǥapun sikan is Tulda he Edtelevukaayan he tuus te zutun is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ne tenged dutun kenà si Moises ebpekeseled dutun te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ne emun ebpeketikang sikan is gapun diyà te zivavew zuen te Tulda ne egenat heini, ne egenat daan is menge Israilihanen puun te kampu zan. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Emun kenà ed-awà duen te Tulda sikan is gapun, ne kenè dan daan edhalin. ");
INSERT INTO mbbOT_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sikan is gapun he simbulu he zutun is Nengazen he kenà ed-awà diyà te zivavew zuen te Tulda emun maandew, ne emun mezukilem duen dutun hapuy he ǥapun su para maahà heini te langun he Israilihanen dutun te kedhipanew zan.");
INSERT INTO mbbOT_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","2","Midtawag te Nengazen si Moises ne midlelaǥan din diyà te Tulda he Edtelevukaayan. Midsuǥù din si Moises te kegkaǥi kayi ziyà te menge Israilihanen: Emun duen keniyu ebpemuhat te uyaǥen diyà te Nengazen, ne mebpemuhat sikandin te vaka, kerehidu, etawa kambing. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Emun baka is ibpemuhat din he iyan pemuhat he edtutungen, kinahanglan he meemahan heini he wazè din sazir, ne ipemuhat din heini ziyà te ǥemawan te Tulda he Edtelevukaayan, su para zewata sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Izampè din is belad din diyà te ulu zuen te vaka he ibpemuhat din, ne edewaten heini te Nengazen su wey melibri sikandin puun te menge salè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ne lepaa zin haazà he uyaǥen diyà te etuvangan te Nengazen. Ne is lengesa kayi ibpirik te menge memumuhat he menge kevuwazan ni Aaron peliǥuy zuen te pemuhatà he ziyà te ǥemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ne enisi zin haazà is uyaǥen wey sepùa. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kegkepasad dutun, medtetavun is menge memumuhat he menge kevuwazan ni Aaron diyà te pemuhatà ne tevuni zan haazà te menge kayu he ibpurung ibpenavuk. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ne isavuk dan duen te hapuy sikan is mibpenggetad dan he vahin duen te uyaǥen, ragkes is ulu wey is menge tavà. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kinahanglan he lùlui duen te nemuhat is menge vahin he ziyà te seled te ǥetek wey is menge paa zuen te vaka. Ne kegkepasad, iyan en is memumuhat edtutung kayi te langun diyà te pemuhatà, iyan heini pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Emun kerehidu etawa kambing is ibpemuhat te etew he iyan pemuhat he edtutungen, kinahanglan he meemahan heini he wazè din sazir. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Lepaa zin heini ziyà te etuvangan te Nengazen diyà te egkezizaya te pemuhatà. Ne is lengesa kayi ibpirik te menge memumuhat he menge kevuwazan ni Aaron diyà te peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Emun egkepenggetad en heini zuen te nemuhat, ibpelastar heini te memumuhat diyà te hapuy, ragkes is ulu wey is menge tavà. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kinahanglan he lùlui zuen te nemuhat is menge vahin he ziyà te seled te ǥetek wey is menge paa kayi. Ne iyan en haazà is memumuhat edtutung dutun te langun diyà te pemuhatà te pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Emun tagbis is ibpemuhat te etew he iyan pemuhat he edtutungen, kinahanglan he merepatik heini etawa limuken. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ed-uwiten heini te memumuhat diyà te pemuhatà. Egurivizen din is lieg kayi taman te egketamped, ne ibpetiǥis din is lengesa duen te kilid te pemuhatà. Ne edtutungen din is ulu kayi ziyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ne kegkepasad dutun, id-awè din is evenan ragkes is taǥù din he kinaan kayi ne idtimbag din diyà te zapit te edsilaan duen te pemuhatà he zutun idsavuk is avu. ");
INSERT INTO mbbOT_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Baasa zin haazà is tagbis pinaaǥi te keguyud te menge pakpak kayi he kenè din daan ebpitasen. Ne tutunga zin haazà is tagbis diyà te pemuhatà he iyan en pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen! ");
INSERT INTO mbbOT_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Emun duen ebpemuhat te pemuhat he para gasa te Nengazen, ne ǥemita zin is kineupiyahan he kelasi te herina, ne sehuǥi zin heini te lana wey veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Uwita zin heini ziyà te menge memumuhat he menge kevuwazan ni Aaron. Ne edterinan te memumuhat haazà te sengekemkem he herina he midsehuǥan te lana, wey ragkes is langun he veyewà he insahug kayi he midtarin din, ne edtutungen din diyà te pemuhatà. Edtutungen din heini he paaǥi te kedtentenuzi te Nengazen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Is egkesamà dutun te herina, ne ǥaked ni Aaron wey te menge kevuwazan din, ne utew heini segradu su zuma heini zuen te pemuhat pinaaǥi te hapuy he impemuhat diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Emun duen ebpemuhat te supas he midhilutù diyà te evuwan he pemuhat he para gasa, kinahanglan he iyan egemiten din is kineupiyahan he kelasi te herina he wazà tepayi. Egkehimu he ibpemuhat is mekepal he supas he midsehuǥan te lana etawa menipis he supas he midezasan te lana. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Emun is ibpemuhat he supas ne ziyà hilutua te mevavew he hilutuey, kinahanglan he iyan egemiten is kineupiyahan he kelasi te herina he edsehuǥan te lana, piru kenà edtepayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ebpenevien heini ne ed-itisan te lana. Pemuhat heini he para gasa. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Emun diyà edhilutua te karà is supas he ibpemuhat, kinahanglan daan he iyan egemiten is kineupiyahan he kelasi te herina ne edsehuǥan daan heini te lana. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Uwita heini he menge pemuhat diyà te memumuhat su wey zin ikepemuhat diyà te Nengazen duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Edterinan heini te memumuhat, ne haazà is tinarin din edtutungen din diyà te pemuhatà he paaǥi te kedtentenuzi te Nengazen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ne is samà dutun te pemuhat, ne ǥaked en ni Aaron wey te menge kevuwazan din, ne utew heini segradu su zuma heini zuen te pemuhat pinaaǥi te hapuy he impemuhat diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Is langun he pemuhat he para gasa he ibpemuhat diyà te Nengazen kinahanglan he wazè din tapey, su kenè kew engayan he edtutung te tapey etawa teneb dutun te kebpemuhata niw te Nengazen te pemuhat pinaaǥi te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Egkehimu ke ibpemuhat niw is tapey etawa teneb he iring te kebpemuhata niw te egkehuna he sebpet niw, piru kenà heini ereg he edtutungen diyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Timusi niw is langun he menge pemuhat niw he para gasa, su is timus, simbulu te wazà pidtemanan he kebpekid-uyun niw te Megbevayà. Timusi niw is langun he menge pemuhat niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Emun ibpemuhat niw is egkehuna he sebpet niw he iyan gasa he ibeǥey niw ziyà te Nengazen, pemuhat kew te ginaling he menge trigu he midsandag. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Sehuǥi niw heini te lana wey veyewà. Pemuhat heini he para gasa. ");
INSERT INTO mbbOT_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Edtutungen te memumuhat is duma zuen te ginaling he midsehuǥan te lana, wey is langun he veyewà he insahug duen te ginaling he para te kedtentenuzi te Nengazen. Pemuhat heini pinaaǥi te hapuy para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Emun duen ebpemuhat te vaka he meemahan etawa vehiyan he pemuhat he para te meupiya he kedepità, kinahanglan he iyan din ibpemuhat diyà te etuvangan te Nengazen is wazè din sazir. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Izampè din is belad din diyà te ulu zutun te vaka, ne ziyè din heini lepaa te ǥemawan te Tulda he Edtelevukaayan. Is lengesa kayi, ne ibpirik te menge memumuhat he menge kevuwazan ni Aaron diyà te peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Puun dutun te ibpemuhat, ne edtarin is memumuhat te ibpemuhat din diyà te Nengazen he pemuhat pinaaǥi te hapuy. Egkuwaan din is langun he tavà diyà te seled te ǥetek kayi, ");
INSERT INTO mbbOT_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","is menge vuwà ragkes is menge tavà kayi, wey is deisey he vahin te atey kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ne edtutungen heini is langun kayi te menge memumuhat diyà te pemuhatà apil zuen te pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Emun kerehidu etawa kambing is ibpemuhat din he para te meupiya he kedepità, meemahan man heini etawa vehiyan, ne kinahanglan he wazè din sazir. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Emun kerehidu is ibpemuhat din diyà te Nengazen, ");
INSERT INTO mbbOT_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","izampè din is belad din diyà te ulu zutun te kerehidu ne lepaa zin haazà diyà te etuvangan te Tulda he Edtelevukaayan. Ne is lengesa kayi, ibpirik te menge memumuhat he menge kevuwazan ni Aaron diyà te peliǥuy te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Puun dutun te ibpemuhat, ne edtarin is memumuhat te ibpemuhat din diyà te Nengazen he pemuhat pinaaǥi te hapuy. Egkuwaan din is menge tavà kayi, is tivuuk he melambù he ikug he midlempek tempeza, is langun he tavà diyà te seled te ǥetek, ");
INSERT INTO mbbOT_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","is menge vuwà ragkes is menge tavà kayi, wey is deisey he vahin te atey. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Edtutungen heini is langun te memumuhat diyà te pemuhatà he pemuhat he keenen. Pemuhat heini pinaaǥi te hapuy para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Emun kambing is ibpemuhat din diyà te Nengazen, ");
INSERT INTO mbbOT_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","izampè din is belad din diyà te ulu zutun te kambing ne lepaa zin haazà diyà te etuvangan te Tulda he Edtelevukaayan. Ne is lengesa kayi, ibpirik te menge memumuhat he menge kevuwazan ni Aaron diyà te peliǥuy te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Puun dutun te ibpemuhat, ne edtarin is memumuhat te ibpemuhat din diyà te Nengazen he pemuhat pinaaǥi te hapuy. Egkuwaan din is langun he tavà diyà te seled te ǥetek, ");
INSERT INTO mbbOT_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","is menge vuwà ragkes is menge tavà kayi, wey is deisey he vahin te atey. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Heini is langun, edtutungen te memumuhat diyà te pemuhatà he pemuhat he keenen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. Is langun he tavà diyà te seled kayi, ne ǥaked te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Kenè kew kaan te tavà etawa lengesa. Kinahanglan he heini he velaud edtumanen niw taman te huziyan he lapis te menge kevuwazan, minsan hendei kew ed-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","2","Midsuǥù daan te Nengazen si Moises he keǥiyi zin is menge Israilihanen he is minsan hentei he nekesupak te suǥù he wazè din tivevaa, ne iyan heini ereg he ebeelan din: ");
INSERT INTO mbbOT_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Emun ebpekesalà is lavew he memumuhat he wazè din tivevaa, ne tenged dutun egkezelahig is menge etew, mebpemuhat sikandin diyà te Nengazen te turiti he vaka he wazè din sazir he pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Uwita zin haazà is baka ziyà te ǥemawan te Tulda he Edtelevukaayan. Izampè din is belad din diyà te ulu zutun te vaka ne lepaa zin haazà diyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ne egkuwa is lavew he memumuhat te lengesa zutun te vaka ne ed-uwiten din haazà diyà te seled te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Idtiyuk din is tezù din dutun te lengesa, ne is duma zutun ibpirik din te kepipitu ziyà te egkesineruwan duen te kurtina he ingkurtina te Utew Segradu he Lugar he ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ne ebpelisan din te lengesa sikan is menge sungeysungey te menge suyuk duen te pemuhatà he tutungà te veyewà diyà te seled te Tulda he zutun is Nengazen. Ne sikan is egkesamà he lengesa zuen te vaka ne id-itis din diyà te dizalem duen te pemuhatà he pemuhat he edtutungen. Heini he pemuhatà ne ziyà te uvey te ǥemawan te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ne egkuwaan din is langun he tavà diyà te seled te ǥetek duen te vaka, ");
INSERT INTO mbbOT_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","is menge vuwà ragkes is menge tavà kayi, wey is deisey he vahin te atey. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(Iyan daan heini ebeelan diyà te ibpemuhat he uyaǥen he pemuhat he para te meupiya he kedepità.) Edtutungen heini is langun te memumuhat diyà te pemuhatà he pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Piru is egkesamà he zuma te impemuhat he uyaǥen iring te lundis, sapù, ulu, menge paa, wey is diyà te seled te ǥetek ragkes en is bituka kayi, ne uwita zin heini ziyà te ǥawas te kampu ne tutunga zin diyà te egkeregreg he kayu, diyà te lugar he midtuuwan he lumpiyu, kes lugar he timbaǥà te avu. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Emun ebpekerapas te suǥù te Nengazen is tivuuk he keet-etawan te Israel he wazè dan tivevaa, nekesalè dan gihapun minsan pa is kezekelan kandan wazà mesayud mehitenged kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ne emun egketuenan dan en he nekesalè bes sikandan, is tivuuk he keet-etawan mebpemuhat te turiti he vaka su pemuhat he para idlumpiyu. Uwita zan heini is baka ziyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ne idampà te menge pengulu te menge Israilihanen diyà te ulu zutun te vaka is menge velad dan ne lepaa zan heini ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ne megkuwa is lavew he memumuhat te lengesa zutun te vaka ne uwita zin diyà te seled te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Itiyuk din is tezù din duen te lengesa, ne ipirik din heini te kepipitu ziyà te kurtina he ingkurtina zuen te Utew Segradu he Lugar, he zutun is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ne pelisi zin te lengesa sikan is menge sungeysungey te menge suyuk duen te pemuhatà diyà te seled te Tulda he zutun is Nengazen. Ne is egkesamà he lengesa ne iitis din diyà te zizalem duen te pemuhatà he pemuhat he edtutungen. Heini he pemuhatà, ne ziyà te uvey te ǥemawan duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","21","Ne veeli zin daan kayi he vaka is iring te mibeelan din duen te vaka he pemuhat he para idlumpiyu: Kuwaa zin is langun he tavà duen te vaka, ne tutunga zin diyà te pemuhatà, ne tutunga zin mulà sikan is baka ziyà te ǥawas te kampu. Ne pinaaǥi te kebeeli kayi te lavew he memumuhat, ne egkevelukasan is menge Israilihanen puun te menge salè dan, ne ebpeseyluwen sikandan te Nengazen. Iyan heini pemuhat he para idlumpiyu te tivuuk he menge etew te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Emun ebpekerapas te suǥù te Nengazen he Megbevayè din is sevaha he egalen, piru wazè din heini tivevaa, nekesalà gihapun sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ne emun egketuenan din en he nekesalè bes sikandin, ne mebpemuhat sikandin te meemahan he kambing he wazè din sazir. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Pemuhat heini he idlumpiyu kandin. Izampè din is belad din diyà te ulu zutun te kambing, ne lepaa zin haazà diyà te etuvangan te Nengazen, diyà te lugar he lepeey zaan te menge pemuhat he uyaǥen he iyan pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ne itiyuk te memumuhat is tezù din duen te lengesa te kambing, ne ipalis din haazà duen te menge sungeysungey te menge suyuk duen te pemuhatà te pemuhat he edtutungen. Is egkesamà he lengesa, iitis din diyà te dizalem duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ne tutunga zin is langun he tavà diyà te pemuhatà iring ded te ebeelan duen te tavà te ibpemuhat he uyaǥen he pemuhat he para te meupiya he kedepità. Pinaaǥi te kebeeli kayi te memumuhat, egkevelukasan is etew puun te salè din, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Emun is sevaha keniyu nekerapas te suǥù te Nengazen he wazè din tivevaa, nekesalà gihapun sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Emun egketuenan din en he nekesalè bes sikandin, ne mebpemuhat sikandin te vehiyan he kambing he wazè din sazir he para te salà he neveelan din. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Izampè din is belad din dutun te ulu zuen te pemuhat he para idlumpiyu, ne lepaa zin heini ziyà te Tulda, zuen te lugar he lepeey te menge uyaǥen he iyan pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ne itiyuk te memumuhat is tezù din diyà te lengesa zuen te kambing, ne ipalis din haazà diyà te menge sungeysungey te menge suyuk duen te pemuhatà he pemuhat he edtutungen. Ne is egkesamà he lengesa ne iitis din diyà te zizalem duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ne kuwaa zin is langun he tavà duen te kambing iring te ebeelan duen te pemuhat he uyaǥen he pemuhat he para te meupiya he kedepità. Ne kegkepasad dutun, tutunga zin is tavà diyà te pemuhatà he mehemut he pemuhat he ebpekepenunuat te Nengazen. Ne pinaaǥi kayi te ebeelan te memumuhat, egkevelukasan is etew puun te menge salè din, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Emun kerehidu is ibpemuhat te etew para melumpiyuwi sikandin, kinahanglan he vehiyan heini he wazè din sazir. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Izampè din is belad din diyà te ulu zutun te kerehidu ne lepaa zin heini ziyà te Tulda, zuen te lugar he lepeey te menge uyaǥen he iyan pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ne idtiyuk te memumuhat is belad din diyà te lengesa zuen te kerehidu, ne ipalis din heini ziyà te menge sungeysungey te menge suyuk te pemuhatà te pemuhat he edtutungen. Is egkesamà he lengesa id-itis diyà te dizalem duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ne kuwaa zin is langun he tavà duen te kerehidu iring te ebeelan duen te pemuhat he kerehidu he pemuhat he para te meupiya he kedepità. Ne kegkepasad dutun, tutunga zin is tavà diyà te pemuhatà duma te zuma he menge pemuhat pinaaǥi te hapuy para te Nengazen. Pinaaǥi kayi te ebeelan te memumuhat, egkevelukasan is etew puun te salè din, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Emun is sevaha he etew kenà egkaǥi ziyà te hukmanan mehitenged te neehè din etawa netuenan din, ne zuen din televaken. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Emun duen nekeǥawed te minsan hengkey he mid-isip he meremerik, he iring te minatey he meremerik he menge langgam, nekesalà sikandin wey neremerikan sikandin minsan wazè din metueni he nekeǥawed sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Emun nekeǥawed sikandin te meremerik he vutang te etew he wazè din metueni he igkehimu ves kandin he meremerik is kegkeveeli zin dutun, ebpekesalà sikandin dutun te timpu te kegketueni zin kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Emun ebpenangdù is sevaha he etew he kenè din ed-is-isipen ke meupiya ve haazà wey ke mezaat is impenangdù din he ebeelan din, ne haazà nekepehimu kandin he meremerik, ne ebpekesalà sikandin emun egkepurung din en egkeisip-isip is mibeelan din. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Emun ebpekesalà is etew te minsan hendei keniyan he menge vaal, kinahanglan he egkeǥiyen din heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ne veyazi zin haazà is salà he neveelan din pinaaǥi te kebpemuhat din diyà te Nengazen te sevaha he vehiyan he kerehidu etawa kambing he pemuhat he para idlumpiyu. Iyan is memumuhat ebpemuhat kayi para mevelukasi sikandin te salè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ne emun kenà sikandin ebpekeveleveg he ebpemuhat te kerehidu, mebpemuhat dà sikandin te zezuwa he merepatik etawa zezuwa he limuken he vayad te salè din: is sevaha pemuhat he para idlumpiyu ne is sevaha ne pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Uwita zin heini ziyà te memumuhat ne idhuna ibpemuhat duen te memumuhat sikan is pemuhat he para idlumpiyu. Egurivizen te memumuhat is lieg kayi, piru kenè din ebpitasen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ne ibpirik din is duma he lengesa kayi ziyà te kilid te pemuhatà, ne is egkesamà he lengesa, ne ibpirik din diyà te zizalem te pemuhatà. Iyan heini pemuhat he ebpekelumpiyu te etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ne ibpemuhat daan duen te memumuhat sikan is sevaha pa he pemuhat he edtutungen, sumalà te paaǥi te kebpemuhata kayi. Pinaaǥi te kebeeli kayi te memumuhat, egkevelukasan is etew puun te salè din, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Piru emun kenè pa sikandin ebpekevaug te zezuwa he merepatik etawa zezuwa he limuken, ne mebpemuhat dà sikandin te zezuwa he kilu he meupiya he kelasi he herina. Kinahanglan he kenè din heini edsehuǥan te lana wey veyewà su pemuhat heini he idlumpiyu, ne kenà heini pemuhat he para gasa. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ne uwita zin heini ziyà te memumuhat ne edtarin dutun is memumuhat te sengekemkem he paaǥi te ketentenuzi te Nengazen. Ne haazà is tinarin din, ne edtutungen din diyà te pemuhatà duma te zuma he menge pemuhat diyà te Nengazen he pinaaǥi te hapuy. Pemuhat heini he para te idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Pinaaǥi te kebeeli kayi te memumuhat egkevelukasan is etew te minsan hendei zutun he menge salà he neveelan din, ne ebpeseyluwen sikandin te Nengazen. Is egkesamà dutun te pemuhat he herina gaked en te memumuhat, iring te ebeelan duen te pemuhat he para gasa. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Insuǥù pa heini te Nengazen ki Moises: ");
INSERT INTO mbbOT_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Emun ebpekesupak is sevaha he etew tenged te wazè din ikeveǥey is butang he para pezem te Nengazen, minsan wazè din heini tivevaa, kinahanglan he ebpemuhat sikandin te meemahan he kerehidu he wazè din sazir he vayad te salè din. Is bali te kerehidu ibpesikad diyà te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. Heini he pemuhat, ne bayad te salà. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ne ǥawas dutun te kerehidu, kinahanglan he ebeyazan din sikan is wazè din ikeveǥey te Nengazen, ne umani zin pa te 20 pursintu is bali zutun te wazè din ikeveǥey. Ne iveǥey zin haazà is langun diyà te memumuhat he iyan ebpemuhat duen te kerehidu para mevelukasi sikandin te salè din, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Emun nekerapas te suǥù te Nengazen is sevaha he etew he wazè din metueni, nekesalà sikandin, ne zuen din televaken diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","19","Kinahanglan he ed-uwit sikandin diyà te memumuhat te meemahan he kerehidu he wazè din sazir, he ibpemuhat din he vayad te salè din. Ne kinahanglan he is bali kayi ibpesikad diyà te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. Ne pinaaǥi te kebpemuhata kayi te memumuhat, egkevelukasan is etew puun te salè he neveelan din he wazà tivevaa, ne ebpeseyluwen sikandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Iyan heini migkaǥi te Nengazen diyà te ki Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","mehitenged te etew he nekerapas te egkesuatan te Nengazen pinaaǥi te kedlimbung te iring din he etew mehitenged te vutang he mibpetipiǥan kandin etawa intaǥak diyà te kandin, etawa kedtakew kayi he vutang, etawa kebpenapì, ");
INSERT INTO mbbOT_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","etawa midtarùtarù mehitenged te vutang he netazin he migkaǥi zin he wazè din maahà, etawa nengulivet te tarù he wazè din meveeli is minsan hendei kayi he menge salà. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Emun egketuenan he tutuu he nekesalà sikandin, kinahanglan he id-ulì din is tinakew zin, etawa nekuwa zin pinaaǥi te limbung, etawa menge azen he intaǥak etawa mibpetipiǥan kandin, etawa menge azen he netazin he neehè din, ");
INSERT INTO mbbOT_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","etawa minsan hengkey he menge azen he impengulivet din he wazà diyà te kandin, piru is tutuu, ziyè bes te kandin. Kinahanglan he iulì din heini ziyà te teǥiǥaked he wazà meterini, ne umani zin pa te 20 pursintu is bali kayi. Iveǥey zin heini ziyà te teǥiǥaked dutun te andew te kebpemuhat din te pemuhat he vayad te salè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Med-uwit sikandin diyà te memumuhat te meemahan he kerehidu he wazè din sazir, ne ipemuhat din heini ziyà te Nengazen he vayad te salè din. Ne kinahanglan he is bali te kerehidu ne pelata he ibpesikad is keveǥat din diyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Pinaaǥi kayi te ebeelan te memumuhat diyà te etuvangan te Nengazen, ne egkevelukasan is etew te salè din, ne ebpeseyluwen sikandin te Nengazen te salà he neveelan din. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","9","Midsuǥù te Nengazen si Moises he keǥiyi zin si Aaron wey sikan is menge anak din he menge maama, kayi he menge sulunuzen mehitenged te pemuhat he edtutungen: Heini he pemuhat kinahanglan he idtaǥak diyà te pemuhatà taman te egkepawà he kenà ed-ewaan te hapuy haazà is pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Idsun-ud te memumuhat is pendivavew he visti zin he linu, wey is pendizalem he visti he linu he ebpeketambun te pid-etawan din, ne egkuwaan din is igmuk kayi he pemuhat, ne idsavuk din diyà te kilid te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ne kegkepasad kayi, med-ilis sikandin te visti zin, ne uwita zin haazà is igmuk diyà te ǥawas te kampu, ziyà te lugar he ed-isipen he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kinahanglan he kenà ed-ewaan te hapuy haazà is pemuhata; kenà heini ed-evukan. Kada meselem ne edtevunan heini te memumuhat, ne ibpurung din idsavuk dutun te hapuy is pemuhat he edtutungen. Iragkes din daan te edtutung is menge tavà te uyaǥen he pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kinahanglan he kenà ed-ewaan te hapuy haazà is pemuhatà; kenà heini ed-evukan. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Iyan heini menge sulunuzen mehitenged te pemuhat he para gasa: Is menge memumuhat he menge kevuwazan ni Aaron iyan ed-uwit kayi he pemuhat diyà te etuvangan te Nengazen diyà te egkesineruwan duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Edterinan te memumuhat te sengekemkem heini is pemuhat he herina he zuen duen lana, ne edtutungen din haazà is tinarin din diyà te pemuhatà ragkes is langun he veyewà he insahug dutun te herina. Edtutungen din heini he paaǥi te kedtentenuzi te Nengazen, is kehemut kayi he pemuhat ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Is egkesamà he herina, ne edhilutuen ne egkeenen ni Aaron wey te menge memumuhat he menge kevuwazan din. Piru hilutua zan heini he wazè din tapey, ne keena zan diyà te lama te Tulda he Edtelevukaayan, he segradu he lugar. Imbeǥey heini kandan te Nengazen he kandan he vahin duen te menge pemuhat he pinaaǥi te hapuy. Is pemuhat he para gasa utew heini segradu iring te pemuhat he para idlumpiyu wey te pemuhat he vayad te salà. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Is langun he maama he menge kevuwazan ni Aaron egkehimu he egkeenen dan is bahin dan dutun te menge pemuhat pinaaǥi te hapuy. Para zà heini kandan taman te peleebuten he menge kevuwazan wey kenà heini egkeengked taman te taman. Is ebpekezegkit kayi he menge pemuhat, egkeipiktuwan te kegkesegradu kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Iyan heini migkaǥi te Nengazen diyà te ki Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","mehitenged te pemuhat he para te Nengazen he ibpemuhat ni Aaron dutun te andew te kedhimuwa kandin he lavew he memumuhat, he kinahanglan he ed-ul-ulahan daan te menge kevuwazan din he ebpekeilis kandin: Mebpemuhat sikandin te zezuwa he kilu he meupiya he kelasi he herina. Pemuhat heini he para te kebeǥey te zengeg diyà te Nengazen, he layun heini ebeeli taman te taman. Is liwazà kayi ne ipemuhat din ke meselem ne is liwazà wey ke mahapun. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Heini he herina edsehuǥan te lana ne edhilutuen diyà te mevavew he hilutuey. Emun egkelutù en, ebpenevien ne ibpemuhat diyà te Nengazen he iyan pemuhat he para gasa. Is kehemut kayi he pemuhat ebpekepenunuat kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ne kinahanglan he edtutungen heini langun, su heini he pemuhat, ne para te Nengazen, ne ed-ul-ulahan heini taman te taman. Kinahanglan he ed-ul-ulahan heini te kevuwazan ni Aaron he iyan ebpekeilis kandin he egkehimu he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Is langun he menge pemuhat he para gasa zutun te memumuhat kinahanglan he pudu edtutunga; kenà heini egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Midsuǥù en maan te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","he egkeǥiyan si Aaron wey sikan is menge anak din he maama kayi he menge sulunuzen: Is pemuhat he para idlumpiyu, kinahanglan he edlepaan diyà te etuvangan te Nengazen diyà te lugar he lepeey te pemuhat he edtutungen. Is pemuhat he para idlumpiyu, utew heini segradu he pemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Is memumuhat he ebpemuhat kayi, kinahanglan he megkaan kayi ziyà te lama te Tulda he Edtelevukaayan, kes segradu he lugar. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Is minsan hentei he ebpekesamsam kayi egkeipiktuwan te kegkesegradu kayi. Ne is bisti he egkepesikan te lengesa kayi he pemuhat kinahanglan he ebpìpian diyà te segradu he lugar zuen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kinahanglan he edtevien is diniyun he edhilutuan keniyan he pemuhat. Piru emun diyà heini hilutua te kuzen, kinahanglan he egkeǥisan heini he kuzen ne edlùluan te wahig. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Egkehimu he egkaan kayi he pemuhat is langun he maama ziyà te pemilya te menge memumuhat. Utew heini segradu he pemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Piru emun ed-uwiten is lengesa kayi he pemuhat diyà te Segradu he Lugar zuen te seled te Tulda, su wey mepesaylu is salà te sevaha he etew, ne kenà egkeenen heini he pemuhat, kekenà, edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Iyan heini menge sulunuzen mehitenged te pemuhat he vayad te salà. Segradu utew heini he pemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Is pemuhat he vayad te salà edlepaan diyà te lepeey te pemuhat he edtutungen. Ne is lengesa kayi ibpirik diyà te peliǥuy te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Pudu ibpemuhat is tavà kayi: is melambù he ikug, is menge tavà diyà te seled te getek, ");
INSERT INTO mbbOT_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","is menge vuwà ragkes is menge tavà kayi, wey is deisey he vahin te atey. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Heini is langun edtutungen te memumuhat diyà te pemuhatà he pemuhat pinaaǥi te hapuy para te Nengazen. Pemuhat heini he vayad te salà. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ebpekekaan te egkesamà kayi he pemuhat is langun he maama ziyà te pemilya te menge memumuhat, piru kinahanglan he ziyè dan heini egkeena te segradu he lugar, su utew heini segradu. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ebpeked-iring dà is sulunuzen mehitenged te pemuhat he para idlumpiyu wey te pemuhat he vayad te salà: is usa kayi he menge pemuhat gaked en te memumuhat he nemuhat kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Is lundis te uyaǥen he pemuhat he edtutungen ne ǥaked daan te memumuhat he nemuhat duen. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Iring daan te langun he menge pemuhat he para gasa, he midhilutù diyà te evuwan etawa karà etawa mevavew he hilutuey, ne ǥaked en daan heini te memumuhat he nemuhat duen. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Is langun he menge pemuhat he para gasa, he midsehuǥan te lana etawa wazà, ne ǥaked en daan te menge kevuwazan ni Aaron ne purungi zan heini bevehina. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Iyan heini menge sulunuzen mehitenged te pemuhat he para te meupiya he kedepità te Nengazen: ");
INSERT INTO mbbOT_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Emun ebpemuhat is etew te pemuhat para te meupiya he kedepità su ebpeselematan din is Nengazen, ne perisi zin heini te supas. Med-uwit sikandin te supas he wazè din tapey iring te supas he mekepal he midsehuǥan te lana, supas he menipis he midezasan te lana, wey supas he iyan mibeelan is meupiya he kelasi te herina he midsehuǥan te lana. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ne gawas keniyan, med-uwit daan sikandin te supas he zuen din tapey. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Mebpemuhat sikandin te tigselimbaha ziyà te kada kelasi kayi he supas he gasa ziyà te Nengazen. Ne ǥaked en heini te memumuhat he mibpemirik te lengesa he pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Is usa te uyaǥen he pemuhat he para te kebpeselamat diyà te Nengazen, kinahanglan he egkeenen te nemuhat wey te pemilya zin wey te menge memumuhat dutun dà te andew te kebpemuhata kayi; kinahanglan he wazà egkesamà kayi zutun te sunud he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Emun is pemuhat din para te meupiya he kedepità he ibpemuhat din he para te kedtuman te penaad etawa pemuhat he keugelingen din he suat, is usa kayi egkeenen dutun dà he andew te kebpemuhata zuen. Iyan, emun duen pa egkesamà he usa, egkehimu heini he egkeenen dutun te sunud he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ne emun duen pa maan egkesamà he usa taman te iketelu he andew, kinahanglan en he edtutungen heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Emun duen egkaan duen te usa zutun te iketelu he andew, ne haazà he pemuhat kenà edewaten te Nengazen ne wazà pulus te kebpemuhata zuen. Ed-isipen heini he utew mezaat ne zuen televaken te minsan hentei he egkaan kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Emun ebpekezegkit is usa ziyà te minsan hengkey he mid-isip he meremerik, ne kenè ne heini ereg he egkeenen, ne edtutungen en heini. Is minsan hentei he ed-isipen he lumpiyu, egkehimu he egkaan kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Piru is minsan hentei he ed-isipen he meremerik he egkaan kayi te usa he para te Nengazen, ne heeyan he etew kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Emun duen ebpezegkit dutun te minsan hengkey he ed-isipen he meremerik, iring te meremerik he menge vutang te etew, etawa meremerik he langgam, etawa minsan hengkey he meremerik, ne egkaan sikandin te usa kayi he pemuhat he para te Nengazen, ne heeyan he etew kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","he keǥiya zin heini ziyà te menge Israilihanen: Kenè kew kaan te tavà te vaka, kerehidu, etawa kambing. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Is tavà te langgam he ebpatey zà etawa nepatey te zuma he langgam egkehimu he egemiten niw ziyà te minsan hengkey he egemitan niw zuen, piru kenè niw keena. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Is minsan hentei he egkaan te tavà he egkehimu he ibpemuhat diyà te Nengazen he pemuhat pinaaǥi te hapuy, ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Minsan hendei kew ed-ubpà, ne kenè kew megkaan te lengesa te langgam ragkes en is lengesa te tagbis. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Is minsan hentei he egkaan te lengesa, ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mid-uman medsuǥù is Nengazen ki Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","he keǥiya zin heini ziyà te menge Israilihanen: Is minsan hentei he ebpemuhat te pemuhat he para te meupiya he kedepità, kinahanglan he mebeǥey sikandin te vahin kayi he pemuhat diyà te Nengazen he iyan ebpekezawat duen is menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Heini he pemuhat, ne uwita zuen te ebpemuhat diyà te pemuhatà. Uwita zin is tavà wey is kumeng duen te uyaǥen, ne ivayew zin sikan is kumeng diyà te etuvangan te Nengazen su pemuhat he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Edtutungen duen te memumuhat sikan is tavà diyà te pemuhatà, piru sikan is kumeng, ne ǥaked en ni Aaron wey te menge kevuwazan din he menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","Is kewanan he vuvun duen te uyaǥen ne ibeǥey ziyà te memumuhat he nemuhat te lengesa wey tavà kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ibeǥey te Nengazen is kumeng wey is buvun te pemuhat niw ziyà te menge memumuhat he si Aaron wey is menge kevuwazan din. Iyan heini vahin he edewaten dan diyà te keniyu taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Iyan haazà bahin te menge pemuhat pinaaǥi te hapuy he para te Nengazen, he ibahin diyà te ki Aaron wey te menge kevuwazan din dutun te andew te kebpehinunguza kandan, su wey zan mekepenilbi te Nengazen pinaaǥi te kegkememumuhat dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Dutun he andew te kedhimuwa te menge memumuhat he menge memumuhat, midsuǥù te Nengazen is menge Israilihanen he iveǥey zan haazà he vahin he para te menge memumuhat, para kandan haazà taman te taman, ne tumana zan heini wey te peleebuten he kevuwazan dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Iyan haazà menge sulunuzen mehitenged te pemuhat he edtutungen, pemuhat he para gasa, pemuhat he para idlumpiyu, pemuhat he vayad te salà, pemuhat he para te kedhimuwa te memumuhat he memumuhat, wey pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Menge sulunuzen heini he imbeǥey te Nengazen diyà te ki Moises diyà te sibsivayan he ziyà te Buntud he Sinai, hein midsuǥù din is menge Israilihanen te kebpemuhat diyà te kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","“Ipehendiyè nu si Aaron wey sikan is menge anak din he maama te ǥemawan te Tulda he Edtelevukaayan, ne tiǥuma nu ziyà is langun he menge Israilihanen. Ipeuwit nu is menge visti he para te menge memumuhat, is lana he para te idlana, is tudu he vaka he pemuhat he para idlumpiyu, is dezuwa he meemahan he menge kerehidu, wey is revan he midteǥuan te menge supas he wazè din tapey.” ");
INSERT INTO mbbOT_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Midtuman ni Moises is insuǥù kandin te Nengazen, ne midtiǥum is menge Israilihanen diyà te ǥemawan duen te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ne migkeǥiyan sikandan ni Moises he heini is ebeelan din, insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Miduma zin diyà te teliwazà si Aaron wey is menge anak din, ne impepemeziǥù din sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ne impesul-ub din ki Aaron is bisti te lavew he memumuhat: is pendizalem he visti, is bakes, is pendivavew he visti, wey is ipud he mibpikitan te vakes he mibpurpurungan is kedhevela zuen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ne impeseluub daan ni Moises diyà te ki Aaron is teleǥuey ziyà te kumeng, ne intaǥù din dutun is Urim wey Thumim. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ne impesuup din diyà te ulu ni Aaron is tengkulu, ne impikit din diyà te sineruwan dutun te tengkulu is bulawan he simbulu he mibpilì si Aaron he para te Nengazen. Mibeelan ni Moises heini is langun sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ne migkuwa ni Moises is lana, ne mibpirikan din sikan is Tulda he Ed-ezapan wey is langun he netaǥù kayi. Su idhalad haazà he menge vutang diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Kepipitu zin piriki te lana sikan is pemuhatà wey is langun he ǥelemiten dutun te pemuhatà, ne iring din ded daan is bisin wey is selevukà kayi. Mibeelan din heini su inhalad din heini he menge azen diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ne mibpetiǥisan din te lana is ulu ni Aaron he paaǥi te kebpehinunguza kandin diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ne miduma zin diyà te teliwazà is menge anak ni Aaron he menge maama, ne mibistiyan din sikandan te visti he para te memumuhat wey mibekesan heini. Midsul-uvan daan sikandan te menge kalù. Mibeelan heini ni Moises sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ne kegkepasad dutun, impekuwa ni Moises is tudu he vaka he pemuhat he para idlumpiyu. Ne indampà ni Aaron wey te menge anak din is menge velad dan diyà te ulu zuen te vaka. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Midlapà ni Moises haazà is baka ne migkuwa sikandin te lengesa kayi. Intiyuk din is tezù din duen te lengesa, ne mibpelisan din sikan is menge sungeysungey te menge suyuk te pemuhatà he iyan kedlumpiyuwi kayi. Ne in-itis dutun is nesamà he lengesa diyà te zizalem duen te pemuhatà. Iyan heini paaǥi te kebpehinunguza zin duen te pemuhatà diyà te Nengazen, su para mehimu heini he ereg he ebpekelibri te mekesesalà. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Migkuwa zaan ni Moises is langun he tavà diyà te seled te ǥetek duen te uyaǥen, is deisey he vahin te atey, is menge vuwà ragkes is menge tavà kayi, ne midtutung din heini is langun diyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Is nengesamà he vahin duen te vaka iring te sapù, lundis, wey menge vituka, midtutung din diyà te ǥawas te kampu. Mibeelan heini ni Moises sumalà is insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kegkepasad dutun, impekuwa ni Moises sikan is meemahan he kerehidu he pemuhat he edtutungen. Ne indampà ni Aaron wey te menge anak din is menge velad dan diyà te ulu zuen te kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Midlapà ni Moises haazà is kerehidu, ne impirik din is lengesa kayi ziyà te peliǥuy te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Midsapù din haazà is uyaǥen, ne midtutung din is ulu, is tavà, wey is duma he menge parti kayi. Midlùluan din is menge vahin he ziyà te seled te ǥetek wey is menge paa. Ne midtutung din diyà te pemuhatà is langun he parti zutun te uyaǥen he pemuhat he edtutungen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. Mibeelan heini ni Moises sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ne impekuwa zaan ni Moises sikan is ikezuwa he meemahan he kerehidu. Heini he kerehidu pemuhat he para te kedhimuwa te memumuhat he memumuhat. Indampà ni Aaron wey te menge anak din is menge velad dan diyà te ulu zuen te kerehidu. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ne midlapà ni Moises haazà is kerehidu, ne migkuwa sikandin te lengesa kayi, ne impalis din diyà te zizalem he vahin te kewanan he telinga ni Aaron, diyà te kewanan he tindezekelà te velad din, wey ziyà te kewanan he tindezekelà te paa zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ne miduma zaan ni Moises diyà te teliwazà is menge anak ni Aaron he maama, ne mibpelisan din daan te lengesa is dizalem he vahin te kewanan he telinga zan, is tindezekelà te kewanan he velad dan, wey is tindezekelà te kewanan he menge paa zan, ne impirik din sikan is lengesa ziyà te peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Migkuwa zin is menge tavà, is melambù he ikug, is langun he tavà diyà te seled te ǥetek, is deisey he vahin te atey, is menge vuwà ragkes is menge tavà kayi, wey is kewanan he vuvun. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","27","Ne migkuwa si Moises te tigselimbaha ziyà te kada kelasi te menge supas he wazè din tapey he intaǥù diyà te revan, ne impemuhat din diyà te Nengazen. Is migkuwa zin supas he mekepal he wazè din tapey, supas he midsehuǥan te lana, wey supas he menipis. Impetepayè din heini ki Aaron wey te menge anak din ragkes is langun he menge tavà wey sikan is kewanan he vuvun te kerehidu, ne imbayew zin heini ziyà te Nengazen su pemuhat heini he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ne kegkepasad te kebeyawa kayi, migkuwa heini ni Moises diyà te kandan ne midtutung din diyà te pemuhatà duma zuen te pemuhat he edtutungen. Pemuhat heini he para te kedhimuwa te memumuhat he memumuhat. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Migkuwa zaan ni Moises is kumeng duen te kerehidu, ne imbayew zin diyà te Nengazen su pemuhat heini he ibayew. Iyan heini ki Moises he vahin duen te kerehidu he pemuhat he para te kedhimuwa te memumuhat he memumuhat. Ne mibeelan ni Moises heini is langun sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ne migkuwa si Moises te lana he para te idlana wey lengesa he zuen te pemuhatà ne mibpirikan din si Aaron wey kes menge anak ni Aaron wey is menge visti zan. Pinaaǥi kayi impehinungud din sikandan wey is menge visti zan diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ne migkeǥiyan ni Moises si Aaron wey is menge anak ni Aaron te, “Lutua niw ziyà te ǥemawan te Tulda he Edtelevukaayan sikan is usa, ne sumalà te insuǥù keniyu ne keena niw heini zutun duma zuen te supas he intaǥù te revan he pemuhat para te kedhimuwa te memumuhat he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ne tutunga niw is egkesamà he usa wey supas. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kenè kew awà dutun seled te pitu he andew, taman te egkepasad is kedhimuwa keniyu he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Iyan is Nengazen midsuǥù kenitew te kebaal kayi te ebeelan tew ǥuntaan, su para mevelukasi kew puun te menge salè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kinahanglan he kenè kew med-awà kayi te maandew wey mezukilem seled te pitu he andew, ne veeli niw is ebpeveelan te Nengazen su wey kew kenà mebpatey, su iyan heini migkaǥi te Nengazen kayi te kedì he ibpeveelan keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Umbe, midtuman ni Aaron wey te menge anak din is langun he insuǥù te Nengazen pinaaǥi ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hein ikewalu he andew he iyan kegkepasad te kedhimuwa ki Aaron he memumuhat, impetawag ni Moises si Aaron wey sikan is menge anak din he maama, wey is menge edumala te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Migkeǥiyan ni Moises si Aaron te, “Kuwa ka te sevaha he turiti he vaka wey sevaha he meemahan he kerehidu he pudu wazè din sazir, ne ipemuhat nu ziyà te Nengazen. Is baka, pemuhat he para idlumpiyu, ne is kerehidu, pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ne keǥiyi nu is menge Israilihanen he megkuwa zan te meemahan he kambing he pemuhat he para idlumpiyu. Wey megkuwa zan daan te vaka wey kerehidu he pudu tig senge-tuig pa is keǥurang he wazè din sazir he pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Megkuwa zaan sikandan te vaka wey meemahan he kerehidu he pemuhat dan para te meupiya he kebpekidepità. Ipemuhat dan heini zuma zuen te pemuhat he para gasa he midsehuǥan te lana, su ǥuntaan he andew ibpaahà te Nengazen is kebpekiduma zin keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Umbe, mid-uwit dan diyà te egkesineruwan duen te Tulda he Edtelevukaayan is langun he insuǥù kandan ni Moises he uwita zan. Mid-amur-amur zan is langun diyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Migkaǥi si Moises diyà te kandan te, “Midsuǥù kew te Nengazen te kebaal kayi te kebpemuhat su wey zin ikepezayag diyà te keniyu is gehem din.” ");
INSERT INTO mbbOT_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ne migkeǥiyan din si Aaron te, “Uvey ka ziyà te pemuhatà ne ipemuhat nu is pemuhat he para idlumpiyu wey is pemuhat he edtutungen su wey ka mevelukasi wey is pemilya nu puun te menge salè niw. Ne sumalà te insuǥù te Nengazen, ipemuhat nu zaan is pemuhat te menge etew su wey zan mevelukasi puun te menge salè dan.” ");
INSERT INTO mbbOT_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Umbe, mid-uvey si Aaron duen te pemuhatà ne midlapè din sikan is turiti he vaka he pemuhat he para idlumpiyu kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Is lengesa kayi mid-uwit te menge anak din diyà te kandin, ne intiyuk din is tezù din dutun te lengesa, ne impirik din heini ziyà te menge sungeysungey te menge suyuk duen te pemuhatà. Is nesamà he lengesa in-itis din diyà te zizalem duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Midtutung din diyà te pemuhatà is menge tavà, is menge vuwà, wey is deisey he vahin te atey, sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Is usa wey is lundis kayi midtutung din diyà te ǥawas te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ne midlapà daan ni Aaron sikan is uyaǥen he pemuhat he edtutungen. Is lengesa kayi, mid-uwit te menge anak din diyà te kandin, ne in-itis din heini ziyà te peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Mid-uwit dan daan diyà te kandin sikan is sinapù he uyaǥen ragkes is ulu kayi, ne midtutung din heini ziyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Midlùluan din is menge parti he ziyà te seled te ǥetek wey is menge paa, ne midtutung din diyà te pemuhatà duma te zuma he parti zuen te uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ne kegkepasad dutun mid-uwit din is menge pemuhat te menge etew. Midlapè din sikan is kambing, ne impemuhat din para melumpiyuwi is menge etew iring duen te mibeelan din diyà te pemuhat he para melumpiyuwi sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ne mid-uwit din daan sikan is uyaǥen he pemuhat he edtutungen diyà te teliwazà, ne impemuhat din heini sumalà te paaǥi te kebpemuhata kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Mid-uwit din daan is pemuhat he gasa ziyà te teliwazà. Midtarin sikandin dutun te sengekemkem, ne midtutung din diyà te pemuhatà he in-uman duen te pemuhat he edtutungen kada meselem. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Midlapà daan ni Aaron sikan is baka wey sikan is meemahan he kerehidu he para te menge etew he pemuhat he para te meupiya he kedepità. Is lengesa kayi mid-uwit te menge anak din diyà te kandin, ne impirikpirik din heini ziyà te peliǥuy zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Is menge tavà kayi he menge uyaǥen, is melambù he ikug, is menge tavà diyà te seled te ǥetek, is menge vuwà, wey is deisek he menge parti te menge atey, ");
INSERT INTO mbbOT_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","in-untud te menge anak ni Aaron diyà te menge kumeng duen te menge uyaǥen. Ne midtutung ni Aaron sikan is menge tavà diyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Sumalà te insuǥù ni Moises, imbayew ni Aaron is menge kumeng wey is kewanan he menge vuvun duen te menge uyaǥen su pemuhat haazà he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ne hein nepasad ni Aaron haazà is langun, imbayew zin is menge velad din dutun te ked-ampù din para te menge etew. Ne mibpenaug sikandin puun duen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","24","Ne midseled si Moises wey si Aaron duen te Tulda he Edtelevukaayan. Ne hein migawas sikandan, mibpenubtuvazan dan is menge etew. Ne impezayag te Nengazen is gehem din diyà te menge etew pinaaǥi te kebpevulus te hapuy he mid-amin medtutung te menge pemuhat diyà te pemuhatà. Ne hein naahà heini te menge etew, nemengulahì dan tenged te kegkelipey, ne midluhud dan te ked-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ne si Nadab wey si Abihu, he menge anak ni Aaron, migkuwa is kada sevaha kandan te teleǥuey te veyewà. Ne midsevukan dan heini te vaǥa wey veyewà ne impemuhat dan diyà te Nengazen. Piru heini is mibeelan dan ne kenè iyan insuǥù te Nengazen, su is hapuy he migamit dan kenà dait he egemiten. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Umbe, impevulus te Nengazen is hapuy he midtutung kandan taman te minatey zan diyà te etuvangan te Nengazen dutun te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ne migkeǥiyan ni Moises si Aaron te, “Iyan heini ibpesavut te Nengazen hein migkaǥi sikandin te, ‘Kinahanglan he egkilelaan te menge memumuhat is kegkewaǥas ku, wey kinahanglan he ebeǥayan a te zengeg te langun he menge etew ku.’ ” Wazà meketavak si Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ne impetawag ni Moises si Mishael wey si Elsafan, he menge anak he maama ni Uziel te anggam ni Aaron, ne migkeǥiyan din sikandan te, “Hendini kew, kuwaa niw is minatey he menge kezuzumahi niw keniyan te Tulda ne uwita niw ziyà te ǥawas te kampu.” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Umbe, migkuwa zan haazà is nemematey, piru ziyè dà sikandan megawed te visti, ne mid-uwit dan diyà te ǥawas te kampu sumalà te insuǥù ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ne migkaǥi si Moises diyà te ki Aaron wey ziyà te menge anak din he si Eleazar wey si Itamar te, “Kenè niw vey-ani he egkeǥuseng is bulvul niw etawa ebindasen niw is menge kumbalè niw te kebpekilala he idlalew niw is minatey. Emun ebeelan niw heeyan, ne ebpatey kew ne egkepeukan te Nengazen is langun he menge Israilihanen. Is langun he menge etew te Israel he menge kezuzumahi niw, ne iyan mulà sikandan medlalew para keniyan te zezuwa he midtutung te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kenè kew zèpa awà kayi te ǥemawan te Tulda. Emun ebeelan niw heini ne ebpatey kew, su mibpilì kew te Nengazen he mehimu kew he menge memumuhat pinaaǥi te kedlenahi keniyu te lana.” Ne midtuman dan haazà is migkaǥi ni Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Migkeǥiyan te Nengazen si Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Sikew wey is menge anak nu ne kenè kew ereg he edseled diyà te Tulda emun ebpekeinum kew te vinu etawa minsan hengkey he inumen he ebpekelangut. Emun ebeelan niw heini ne ebpatey kew. Kinahanglan he edtumanen niw heini taman te huziyan he lapis te menge kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ereg he egketuenan niw ke hengkey is para te Nengazen wey para te langun, is lumpiyu wey meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ne kinahanglan he ebpenuruen niw is iring niw he menge Israilihanen te langun he sulunuzen he imbeǥey ku keniyu pinaaǥi ki Moises.” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Migkaǥi si Moises diyà te ki Aaron wey ziyà te zezuwa he anak ni Aaron he nesamà he iyan si Eleazar wey si Itamar, “Kuwaa niw is pemuhat he para gasa he nesamà duen te menge pemuhat pinaaǥi te hapuy he ibpemuhat para te Nengazen. Lutua niw heini ne kenà edtepayan ne keena niw ziyà te avey te pemuhatà su utew heini segradu he pemuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Diyè niw zà heini keena te segradu he lugar su iyan heini keniyu he vahin puun te menge pemuhat pinaaǥi te hapuy. Iyan heini insuǥù te Nengazen kediey.” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“Is imbayew he kumeng wey vuvun te uyaǥen he impemuhat diyà te Nengazen he egkehimu he ǥaked te menge memumuhat, ne keena nu zuma te tivuuk he pemilya nu. Keena niw heini ziyà te minsan hendei he lugar he ed-isipen tew he lumpiyu. Imbeǥey heini keniyu he vahin niw puun te menge pemuhat te menge Israilihanen he para te meupiya he kebpekidepità. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Emun ebpemuhat is menge Israilihanen, ne ipemuhat dan is kumeng wey is buvun te uyaǥen ragkes is menge tavà he ibpemuhat dan he pemuhat pinaaǥi te hapuy. Ne is kumeng wey is buvun ne ivayew zan diyà te etuvangan te Nengazen he pemuhat he ibayew. Iyan heini vahin nu wey te menge anak nu taman te taman, sumalà te insuǥù te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Hein midsusi si Moises mehitenged te kambing he pemuhat he para idlumpiyu, neehè din he pudu en haazà netutung. Umbe utew zin nepeuki si Eleazar wey si Itamar, ne midsumayan din sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ke sikandin te, “Maan is wazè niw keena ziyà te segradu he lugar sikan is pemuhat he para idlumpiyu? Heini he pemuhat utew segradu, ne imbeǥey heini te Nengazen keniyu su wey mevelukasi is menge etew puun te menge salè dan diyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Su is lengesa kayi wazà meuwit diyà te Segradu he Lugar, migkaan niw pezem heini ziyà te Tulda, sumalà te insuǥù ku keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Midtavak ni Aaron si Moises te, “Wazè pa meuǥet nemuhat is menge anak ku te pemuhat he para idlumpiyu kandan wey pemuhat he edtutungen, piru minatey sikandan is dezuwa. Ne tenged keniyan he hitavù igkelipey ve vuwa te Nengazen emun migkaan ku is usa zuen te pemuhat he para idlumpiyu te heini he andew?” ");
INSERT INTO mbbOT_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nevenaran si Moises te tavak ni Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","3","Midsuǥù te Nengazen si Moises wey si Aaron he keǥiya zan heini ziyà te menge Israilihanen: Egkehimu he egkeenen niw is minsan hengkey he langgam he neuyag kayi te tanà he netevì is sulu zan wey ed-umanan dan edsepaa is kinaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","8","Piru kenè niw keena is menge langgam he ed-uman edsepà te kinaan dan he wazà metevì is sulu zan, iring te kemilyu, badir, wey rabit. Kenè niw zaan keena is bavuy, su minsan netevì is sulu zin, piru kenà kayi ed-umanan edsepaa is kinaan din. Isipa niw he meremerik heini he menge langgam. Kenè kew kaan te usa kayi wey kenè kew gawed te minatey kandan. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","12","Egkehimu he egkeenen niw is minsan hengkey he neuyag diyà te wahig he zuen din kapey wey hun-ap. Piru kenè niw keena is wazè din kapey wey hun-ap, wey kenè niw zaan gewezi is minatey kandan. Isipa niw he meremerik heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Kenè niw keena is menge tagbis iring te kulaǥu, uwak, menge tagbis he edaas te lawa te etew etawa langgam, dapay, ekang, kalamun, menge tagbis he ebpendawi te isdà, tulabung, dugwak, wey kaveg. Isipa niw he meremerik heini he menge tagbis. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","23","Egkehimu he egkeenen niw is menge dezeizey he keranapranap he edlayang wey ebpenanap he zuen dan menge paa he ibpekeladsik dan iring te terapan, sengug, wey pelaǥà. Piru kenè niw keena is duma pa he menge keranapranap he edlayang wey ebpenanap. Isipa niw he meremerik heini he menge keranapranap. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Kenè kew ǥawed te minatey he menge langgam he wazà metevì is sulu zan wey kenà ed-uman edsepà te kinaan dan. Kenè kew zaan gawed te minatey he menge langgam he heepat is menge paa zan he igkahis dan is menge sulu zan. Isipa niw he meremerik heini he menge langgam. Is minsan hentei he ebpekesamsam te minatey kandan, kinahanglan he ebpìpian din is bisti zin, ne ed-isipen pa sikandin he meremerik taman te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","31","Isipa niw he meremerik is menge langgam he ebpenanap iring te rumat, laku, pelesakà, telètà, pelaas, buaya, ivid, wey menge kemilyun. Is minsan hentei he ebpekesamsam te minatey kandan ed-isipen he meremerik taman te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Is minsan hengkey he egkeuluǥan te ebpatey kandan egkehimu he meremerik, kayu man heini he mibeelan he azen, manggad, panit, etawa saku. Ne minsan hengkey is egemitan kayi kinahanglan he edlùluan te wahig, piru ed-isipen pa heini he meremerik taman te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Emun egkeuluǥan is umuy te minatey kandan, is langun he taǥù kayi egkehimu he meremerik, ne kinahanglan he egevaan heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Is minsan hengkey he keenen he intereb diyà te wahig he taǥù dutun te umuy egkehimu he meremerik. Ne egkehimu zaan he meremerik is minsan hengkey he kelasi te inumen he zutun te seled te umuy. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Minsan hengkey he egkeuluǥan te minatey kandan egkehimu he meremerik. Emun iyan egkeuluǥan is evuwan etawa kuzen, isipa niw heini he meremerik ne kinahanglan heini he edrupeten. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Is serebseb etawa vudsi he punduwà te wahig he egkeuluǥan te minatey kandan kenè mulà egkehimu he meremerik, piru is edsamsam dutun te minatey he langgam egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kenà daan egkehimu he meremerik is minsan hengkey he venì he ibpemula he egkeuluǥan dutun. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Piru emun iyan egkeuluǥan is benì he nehuluman te wahig, ne heini he venì egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Emun ebpatey is langgam he egkehimu he egkeenen, is minsan hentei he ebpekesamsam kayi ed-isipen he meremerik taman te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Is minsan hentei he egkuwa etawa egkaan te lawa kayi, kinahanglan he ebpìpian din is bisti zin, piru ed-isipen pa sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","Kenè niw keena is minsan hengkey he keranapranap he ebpenanap su meremerik heini: is minsan hengkey he edula etawa ebpenanap he heepat is paa etawa mahabet is menge paa. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","44","Kenè niw remeriki is keugelingen niw pinaaǥi te kegkaan te minsan hendei kayi he menge langgam, su iyan a, is Nengazen, Megbevayè niw. Umbe iviza niw is keugelingen niw para kediey, ne mebpekesegradu kew su waǥas a. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Iyan a Nengazen he mibpeǥawas keniyu puun te Ehipto su wey a mehimu he Megbevayè niw. Umbe mebpekesegradu kew su waǥas a. ");
INSERT INTO mbbOT_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Pinaaǥi kayi he sulunuzen te mehitenged te langun he kelasi te menge langgam, ");
INSERT INTO mbbOT_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","egketuenan niw ke hendei kandan is lumpiyu wey is meremerik, is egkehimu he egkeenen wey is kenà egkehimu he egkeenen. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","he keǥiya zin heini ziyà te menge Israilihanen: Emun ed-anak is bahi te maama, ed-isipen sikandin he meremerik seled te pitu he andew, iring daan ke edlengesahan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Dutun te ikewalu he andew edsirkunsidaren is anak din. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ne tenged te kebpedayun kegawas te lengesa zin, ne medtaǥad pa sikandin te 33 he andew ne human sikandin ed-isipa he lumpiyu. Kenà sikandin egkehimu he edsamsam te minsan hengkey he azen he para te Nengazen ne kenà sikandin egkehimu he edhendiyà te Tulda he Edtelevukaayan taman te ebpekelavey is menge andew te kegkehimuwa kandin he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Emun bahi is anak din, ed-isipen sikandin he meremerik seled te 14 he andew, ne emun edlengesahan daan sikandin tenged te ebpedayun he kegawas te lengesa zin, medtaǥad pa sikandin te 66 he andew ne human sikandin ed-isipa he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Emun egkeume en is menge andew te kegkehimuwa kandin he lumpiyu puun te kegkehimuwa kandin he meremerik tenged te ked-anak din te maama etawa bahi, ne med-uwit sikandin diyà te memumuhat diyà te ǥemawan te Tulda he Edtelevukaayan te kerehidu he senge-tuig is keǥurang din he pemuhat he edtutungen, wey sevaha he limuken etawa merapatik he pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","Ibpemuhat heini te memumuhat diyà te etuvangan te Nengazen para maawà is keremerik dutun te vahi puun te kedlengesahi kandin, ne egkehimu en sikandin he lumpiyu. Emun kenà sikandin ebpekeveleveg he ebeǥey te kerehidu med-uwit dà sikandin te zezuwa he merepatik etawa zezuwa he limuken. Is sevaha, pemuhat he edtutungen ne is sevaha pa, pemuhat he para idlumpiyu. Pinaaǥi kayi te ebeelan te memumuhat, egkaawà is kegkehimuwa kandin he meremerik ne egkehimu en sikandin he lumpiyu. Iyan heini menge sulunuzen mehitenged te vahi he ed-anak. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mibeǥey is Nengazen kayi he menge sulunuzen diyà te ki Moises wey ki Aaron: ");
INSERT INTO mbbOT_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Emun is lundis te sevaha he etew edlevag etawa ebuketur etawa ebmeputìputì, he egkehimu ke edekelà he zaru te lundis, edumahan heini he etew ziyà te ki Aaron he memumuhat etawa sevaha zuen te menge memumuhat he kevuwazan ni Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ne ed-ahaan te memumuhat is bahin te lundis he midtuvuan dutun, emun midlevag haazà is lundis, wey mibmemeputì is bulvul zuen, tutuu he zuen din daru te lundis. Ne segugunà egkeǥiya zuen te memumuhat diyà te menge etew he meremerik haazà is etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Iyan, emun haazà is mibmeputìputì diyà te lundis din ne kenà tuus te zaru te lundis wey wazà mebmeputì is bulvul zutun, ne idsivey sikandin dutun te memumuhat puun te menge etew seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ne zutun te ikepitu he andew ed-umanan edsusiya zuen te memumuhat is lundis duen te etew. Ne emun is egkeehè din iyan ded gihapun su wazà heini medelandap, id-uman sikandin idsivey zutun te memumuhat puun te menge etew seled te selakew en he pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ne ziyà te ikepitu en maan he andew, ed-umanan sikandin edsusiya zuen te memumuhat. Ne emun midtulak en haazà is diyà te lundis din ne wazà medelandap, ne egkeǥiyen duen te memumuhat diyà te menge etew he lumpiyu haazà is etew su zeisey zà he levag is diyà te lundis din. Ne kegkepasad dutun pìpii zutun te etew is bisti zin, ne ed-isipen en sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Iyan, emun edelandap is ebpemuketur ziyà te lundis din dutun te nesusi en sikandin te memumuhat ne ingkepeseyuzan en he lumpiyu sikandin, kinahanglan he ebpeuman sikandin ebpesusi te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ne emun tutuu he midelandap haazà is dezeisey he menge levag, ne egkeǥiyan dutun te memumuhat diyà te menge etew he meremerik haazà is etew su zuen din daru te lundis. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Is minsan hentei he zuen tuus te zaru te lundis diyà te kandin kinahanglan he edumahan diyà te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Emun egkesusi te memumuhat he ebmemeputìputì is levag he iyan hinungdan te kebmemeputì te menge vulvul zuen, ne egkeehè en is sapù, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ne grabi heini he zaru. Ne ebpesayud is memumuhat he meremerik haazà is etew. Kenè en kinahanglan he idsivey pa sikandin para mepeniizi su keladu en he meremerik sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Emun iyan ked-ahà zuen te memumuhat he nekeeneb en diyà te lawa zuen te etew haazà is daru, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kinahanglan he ed-umanan sikandin ebpurungi edsusiya zuen te memumuhat. Ne emun tutuu he nekeeneb en diyà te tivuuk he lawa zuen te etew sikan is daru he tenged dutun mibmeputì pudu is tivuuk he lundis din ebpesayud haazà is memumuhat he lumpiyu haazà is etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","15","Iyan, emun egkesusi zuen te memumuhat he nenggawas en is sapù, ebpesayud sikandin he meremerik haazà is etew su zuen din daru ziyà te lundis. Heini is migawas he sapù ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Iyan, emun egkeulian su midtulak en, mebpeuman sikandin mebpesusi te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ne emun tutuu he midtulak en ebpesayud haazà is memumuhat he lumpiyu haazà is etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Emun duen etew he zuen din levag he neulian, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","iyan, duen en maan mid-uman mebuketur zutun te neulian he malù meputìputì etawa meriǥàriǥà, kinahanglan he ibpesusi zin heini te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ne emun edlevag haazà is mibuketur zutun te lundis ne tuus heeyan te zaru te lundis ne ebmemeputì daan is menge vulvul kayi, ne ebpesayud is memumuhat he meremerik haazà he etew, su zuen din daru te lundis he mibpuunà pinaaǥi te levag. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Iyan, emun egkesusi te memumuhat he kenà haazà tuus te zaru te lundis wey wazà daan mebmeputì is bulvul kayi, ne henduen te edtulak en, idsivey sikandin dutun te memumuhat puun te menge etew seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Emun edelandap heini ziyà te zuma he vahin te lundis, ebpesayud is memumuhat he meremerik haazà he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Iyan, emun wazà heini medelandap, tulak dà heini te levag, ne ebpesayud is memumuhat he lumpiyu en haazà he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Emun netutung is sevaha he etew ne mibmeputìputì haazà etawa mibmeriǥàriǥà, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kinahanglan he ibpesusi heini te memumuhat. Ne emun tuus heini te zaru te lundis wey mibmeputì is menge vulvul kayi, ne zuen din daru te lundis he mibpuun pinaaǥi te kegketutung. Ne ebpesayud is memumuhat he meremerik haazà he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Iyan, emun nesusi te memumuhat he kenà haazà tuus te zaru te lundis wey wazà daan mebmeputì is menge vulvul zutun, ne henduen te midtulak en, idsivey sikandin te memumuhat puun te menge etew seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ne ikepitu he andew ed-umanan sikandin edsusiya te memumuhat. Ne emun midelandap heini ziyà te zuma he vahin te lundis, ebpesayud haazà is memumuhat he meremerik haazà is etew, su zuen din daru te lundis. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Iyan, emun wazà heini medelandap su midtulak en, ne levag dà heini tenged te kegketutung. Ne ebpesayud is memumuhat he lumpiyu haazà is etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Emun duen keriskis diyà te ulu etawa vakà te sevaha he etew, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kinahanglan he ibpesusi zin heini te memumuhat. Emun tuus heini te zaru te lundis wey mibmekelawag is menge vulvul etawa sumpà kayi wey mibmenipis, ebpesayud is memumuhat he meremerik haazà he etew, su zuen mezeǥes he zaru te lundis din he midtuvù diyà te ulu etawa vakà. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Iyan, emun egkesusi te memumuhat he haazà is keriskis kenà tuus te zaru te lundis piru wazà meitem he vulvul etawa sumpà kayi, idsivey sikandin duen te memumuhat puun te menge etew seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ne ikepitu he andew, ed-umanan edsusiya te memumuhat haazà is mezeǥes. Ne emun wazà heini medelandap wey kena tuus te zaru te lundis, wey wazà mebmekelawag is menge vulvul etawa sumpà kayi, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kinahanglan he ebpevangul sikandin wey ebpemarbas piru kenè din iragkes sikan is duen duen mezeǥes. Ne id-uman sikandin idsivey te memumuhat seled te selakew en he pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Dutun te ikepitu he andew, ed-umanan edsusiya zuen te memumuhat sikan is mezeǥes. Ne emun wazà heini medelandap wey kenà tuus te zaru te lundis, ebpesayud haazà is memumuhat he lumpiyu haazà is etew. Ne ebpìpian dutun te etew is bisti zin, ne ed-isipen sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Iyan, emun midelandap haazà is mezeǥes diyà te lundis din dutun te ingkepetuenan en duen te memumuhat he lumpiyu haazà he etew, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ed-umanan sikandin edsusiya zutun te memumuhat. Ne emun tutuu he midelandap haazà is mezeǥes diyà te lundis din, ne kenè en kinahanglan he edsusiyen pa zuen te memumuhat ke zuen be vulvul etawa sumpà he mibmekelawag su keladu en he meremerik sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Iyan, emun egkesusi zuen te memumuhat he wazà heini medelandap ne zuen en meitem he vulvul etawa sumpà he midtuvù, neulian en heini. Ne ebpesayud haazà is memumuhat he lumpiyu haazà is etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Emun duen ebmeputìputì diyà te lundis te etew, ");
INSERT INTO mbbOT_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kinahanglan he ibpesusi heini te memumuhat. Iyan, emun haazà is mibmeputìputì ne kenà utew egketuusan is keputì din, mezeǥes dà heini he migawas diyà te lundis. Haazà he etew ed-isipen he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Emun is etew neupew zapit te vuked etawa dapit te purù, lumpiyu sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","44","Iyan, emun duen ebmeriǥàriǥà he levag dutun te upew zin, kinahanglan he ibpesusi zin heini te memumuhat. Ne emun haazà is meriǥàriǥà he levag henduen te zaru te lundis he egkaahà diyà te lawa, ebpesayud is memumuhat he meremerik haazà he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Is etew he zuen din daru te lundis kinahanglan he mebivisti te vindas he visti, kenà mebpenuwat te vulvul zin, ne tembuni zin is dizalem he vahin te zagwey zin ne mebensag sikandin te, “Meremerik a! Meremerik a!” ");
INSERT INTO mbbOT_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ed-isipen sikandin he meremerik dutun te ziyè pa te kandin sikan is daru. Ne kinahanglan he ziyà sikandin med-ubpà te ǥawas te kampu he sebsevaha zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","50","Emun midhab-ung is manggad he welin etawa linu etawa minsan hengkey he azen he lundis is mibeelan, kinahanglan he ibpesusi heini te memumuhat. Ne emun egkesusi en te memumuhat, isivey zin heini seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","Dutun te ikepitu he andew ed-umanan heini edsusiya te memumuhat. Ne emun midelandap haazà is hab-ung ne ed-isipen heini he meremerik, ne kinahanglan he ebinsulan heini su ed-iseg pa haazà is hab-ung. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Iyan, emun egkesusi te memumuhat he wazà medelandap haazà is hab-ung ");
INSERT INTO mbbOT_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ne medsuǥù sikandin he ebpìpian etawa edlùluan haazà is manggad etawa lundis, wey idsivey pa seled te selakew en he pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ne kegketapus dutun ne ed-umanan heini edsusiya te memumuhat. Ne emun wazà medheva haazà is hab-ung, ed-isipen heini he meremerik minsan wazà medelandap haazà is hab-ung. Umbe kinahanglan he ebinsulan heini minsan divaluy zà is midhab-ung. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Iyan, emun egkesusi zuen te memumuhat he midheva haazà is hab-ung, ne iawè din sikan is bahin he nepikitan te hab-ung duen te manggad etawa lundis. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Iyan, emun edlikù haazà is hab-ung ne edelandap, kinahanglan he ebinsulan en haazà is manggad etawa lundis. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ne emun egkaawà haazà is hab-ung dutun te nepìpian en haazà is manggad etawa lundis ne ed-umanan heini ebpìpii ne egkehimu en heini he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Iyan heini menge sulunuzen para metueni ke lumpiyu etawa meremerik is midhab-ung he manggad he welin etawa linu etawa minsan hengkey he azen he lundis is mibeelan he midhab-ung. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","2","Iyan heini menge sulunuzen he migkaǥi te Nengazen diyà te ki Moises he mehitenged te kedlumpiyuwi te etew he neulian te zaru zin te lundis: Emun igkepetuenan en diyà te memumuhat is mehitenged te zaru te sevaha he etew, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","egawas is memumuhat diyà te kampu ne edsusiyen din is lawa zuen te etew. Ke neulian en be heini te zaru zin te lundis, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ebpekuwa haazà is memumuhat te zezuwa he tagbis he lumpiyu he uuyag, sengetamped he kayu he sidru, merudtem he hulibis, wey senge verakes he hisupu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ne ibpehimetayan duen te memumuhat sikan is sevaha he tagbis diyà te zivavew te diniyun he midteǥuan te wahig he ebpuun diyà te serebseb. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ne egkuwaan din sikan is sevaha pa he uuyag he tagbis, kes kayu he sidru, kes merudtem he hulibis wey kes hisupu, ne ibpevudseng din haazà is langun duen te wahig he zuen duen lengesa te tagbis he midhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ne haazà is wahig he zuen duen lengesa ne ibpirik din te kepipitu ziyà te etew he neulian te zaru zin te lundis, ne kegkepasad ibpeseyuzan din he lumpiyu en haazà is etew. Ne ibpaawà dutun te memumuhat sikan is uuyag he tagbis. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Piru te kenè pa ibpetuenan he lumpiyu en sikandin, kinahanglan he pìpii zin dèpa is bisti zin, kiskisi zin is langun he vulvul zin wey berehibu, ne mebpemeziǥù sikandin. Ne egkehimu en sikandin he edseled diyà te kampu piru kenà sikandin med-ubpà diyà te tulda zin seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ne zutun te ikepitu he andew umani zin kiskisi is langun he vulvul zin wey berehibu, pìpii zin is bisti zin, wey mebpemeziǥù sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Dutun te ikewalu he andew, kinahanglan he med-uwit sikandin te zezuwa he meemahan he kerehidu wey sevaha he vehiyan he kerehidu he senge-tuig is keǥurang he wazè din sazir. Med-uwit daan sikandin te heenem he kilu he meupiya he kelasi he herina he midsehuǥan te lana he pemuhat he para gasa. Wey med-uwit pa sikandin te senge vasu he lana. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ne ed-uwiten dutun te memumuhat haazà is etew wey kes pemuhat din diyà te etuvangan te Nengazen diyà dapit te gemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ne egkuwaan duen te memumuhat sikan is sevaha he meemahan he kerehidu wey sikan is senge vasu he lana, ne ibpemuhat din heini he pemuhat he vayad te salà. Ne ibpeketikang din heini ziyà te etuvangan te Nengazen su pemuhat heini he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Edlepaan din haazà is kerehidu ziyà te segradu he lugar, ziyà te lepeey te pemuhat he para idlumpiyu wey te pemuhat he edtutungen. Heini is pemuhat he kerehidu, utew segradu, ne para zà heini te menge memumuhat, he iring te pemuhat he idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Egkuwa haazà is memumuhat te zeisey he lengesa zuen te kerehidu he impemuhat ne ibpelis din heini ziyà te kewanan he telinga zuen te etew, wey is tindezekelà te kewanan he velad din wey paa. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Idtepayà daan te memumuhat is givang he palad din te zeisey he lana, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ne idtiyuk din is tezù te kewanan he velad din kayi te lana ne ibpirik din heini te kepipitu ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ne sikan is egkesamà dutun te lana ziyà te palad din, ne idazas din daan dutun te etew zuen te mibpendezasan din te lengesa; izazas din heini ziyà te kewanan he telinga zuen te etew, wey te tindezekelà te kewanan he velad din wey paa. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","20","Ne is egkesamè pa zuen te lana ziyà te palad duen te memumuhat, ne izazas duen te etew ziyà te ulu zin. Ne ibpemuhat dutun te memumuhat sikan is pemuhat he para idlumpiyu. Ne kegkepasad, edlepaan duen te memumuhat sikan is pemuhat he edtutungen ne ibpemuhat din heini ziyà te pemuhatà duma zuen te pemuhat he para gasa. Ne pinaaǥi kayi te ebeelan te memumuhat diyà te etuvangan te Nengazen, egkaawà is keremerik dutun te etew ne egkehimu en sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Iyan, emun pubri haazà is etew ne kenè din egkeveleveg is kebpemuhat kayi he menge pemuhat, ne med-uwit dà sikandin te sevaha he meemahan he kerehidu he ibpemuhat din he pemuhat he vayad te salà. Ivayew zin heini he pemuhat para te Nengazen para mepesaylu sikandin te menge salè din. Med-uwit daan sikandin te zezuwa he kilu he meupiya he kelasi he herina he midsehuǥan te lana he pemuhat he para gasa. Wey med-uwit pa sikandin te senge vasu he lana. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ne sumalà te egkehimu zin med-uwit sikandin te zezuwa he merepatik etawa zezuwa he limuken; is sevaha, pemuhat he para idlumpiyu kandin ne is sevaha pa, pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Dutun te ikewalu he andew uwita zin heini is langun he pemuhat diyà te memumuhat diyà te ǥemawan te Tulda he Edtelevukaayan, diyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Egkuwaan duen te memumuhat sikan is kerehidu he pemuhat he vayad te salà wey sikan is senge vasu he lana ne ivayew zin heini ziyà te etuvangan te Nengazen su pemuhat heini he ibayew. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ne edlepaan din haazà is kerehidu ne egkuwa sikandin te lengesa kayi ne ibpalis din diyà te kewanan he telinga zuen te etew he edlumpiyuwan wey ziyà te tindezekelà te kewanan he velad din wey paa zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ne idtepayà dutun te memumuhat is givang he palad din te lana, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ne pinaaǥi te kewanan he tezù din, ne ibpirik din haazà is lana te kepipitu ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Is duma he lana ziyà te palad din, idazas din dutun te etew ziyà te midezasan din en te lengesa. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","31","Is egkesamà duen te lana ziyà te palad te memumuhat, idazas din diyà te ulu zutun te etew. Ne ibpemuhat dutun te memumuhat sikan is dezuwa he merepatik etawa zezuwa he limuken; is sevaha pemuhat he para idlumpiyu ne is sevaha pa para pemuhat he edtutungen. Ipemuhat din daan is pemuhat he para gasa. Pinaaǥi kayi te ebeelan te memumuhat diyà te etuvangan te Nengazen, egkaawà is keremerik te etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Iyan heini menge sulunuzen mehitenged te kedlumpiyuwi te etew he zuen din daru te lundis emun kenà sikandin ebpekeveleveg te egkinehenglanen he pemuhat para te idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Iyan heini migkaǥi te Nengazen diyà te ki Moises wey ki Aaron ");
INSERT INTO mbbOT_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","mehitenged te ebeelan dan emun duen ibpetuvù te Nengazen he hab-ung diyà te menge valey zan emun diyè dan en te Canaan, kes lugar he imbeǥey te Nengazen kandan wey zan maangken: ");
INSERT INTO mbbOT_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Emun is teǥiǥaked te valey ebpekeseǥipà he zuen henduen be te hab-ung diyà te valey zin, kinahanglan he keǥiya zin haazà diyà te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ne emun kenè pa edseled is memumuhat dutun te valey te kedsusi ke zuen be zutun hab-ung, medsuǥù sikandin he iǥawas is langun he vutang diyà te seled, su para kenà heini meragkes te ed-isipen he meremerik. Ne kegkepasad, human pa edseled dutun te valey is memumuhat ");
INSERT INTO mbbOT_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ne edsusiyen din ke hab-ung be is diyà te elavat. Ne emun egkeehè din he meilem-ilem etawa meriǥàriǥà is ebuketur zutun te elavat, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","egawas sikandin dutun he valey ne ebpelekevan din heini seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ne ikepitu he andew ed-umanan din edsusiya heini. Ne emun edelandap haazà is hab-ung diyà te zuma he vahin te elavat, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ne ibpaawè din is menge vahin te elavat he zuen duen hab-ung ne ibpetimbag din heini ziyà te ǥawas te inged, diyà te lugar he edtimbaǥan te ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ne ebpekeǥisan din is langun he elavat diyà te seled dutun te valey ne is langun he kinaǥis ibpetimbag din diyà te gawas te inged, diyà te lugar he edtimbaǥan te ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ne ebpekuwa sikandin te para idliwan dutun te elavat he mibpen-awà. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Iyan, emun kegkepasad dutun ed-umanan pa edheb-unga haazà is baley, ");
INSERT INTO mbbOT_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ne ed-umanan heini ebeyai te memumuhat su wey zin mesusi. Ne emun midelandap is hab-ung, ne ed-isipen en he meremerik haazà is baley, su heini he kelasi te hab-ung ne ebpenhalin. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Umbe, iperundus din heini he valey ne is menge pengawid kayi, idtimbag diyà te ǥawas te inged, he timbaǥà te ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Is minsan hentei he midseled dutun he valey hein midlekevan pa ne ed-isipen he meremerik taman te kebmerusirem. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Is minsan hentei he edlipezeng etawa egkaan diyà te seled kayi he valey kinahanglan he ebpìpian din is bisti zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Iyan, emun egkesusi zuen te memumuhat he wazè en umana heb-unga haazà is baley hein neliwanan en te elavat sikan is midhab-ung he elavat, ne ebpesayud haazà is memumuhat he lumpiyu haazà he valey su wazè en heb-unga. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ne para isipe en haazà he lumpiyu en he valey, egkuwa is memumuhat te zezuwa he tagbis, kayu he sidru, merudtem he hulibis, wey hisupu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Edhimetayan din is sevaha he tagbis diyà te zivavew te ziniyun he midteǥuan te wahig he ebpuun diyà te serebseb. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ne egkuwaan din sikan is kayu he sidru, is merudtem he hulibis, is hisupu, wey sikan is uuyag he tagbis, ne ibpevudseng din heini is langun duen te wahig he zuen duen lengesa te tagbis he midhimetayan. Ne haazà is wahig he zuen duen lengesa, ne ibpirik din te kepipitu zuen te valey. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Umbe, pinaaǥi zuen te lengesa te tagbis, te wahig he ebpuun diyà te serebseb, te uuyag he tagbis, te kayu he sidru, te hisupu, wey merudtem he hulibis, egkelumpiyuwan duen te memumuhat haazà is baley. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ne ibpaawè din sikan is uuyag he tagbis diyà te ǥawas te inged. Pinaaǥi kayi te ebeelan te memumuhat, egkaawà is kegkeremeriki te valey ne egkehimu en heini he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","57","Iyan heeyan menge sulunuzen mehitenged te menge zaru te lundis he edeǥes, etawa edlevag, etawa ebmemeriǥà, etawa ebmeputìputì, ne mehitenged te hab-ung te visti wey valey. Ne pinaaǥi kayi he sulunuzen egketuenan niw ke hengkey is lumpiyu wey ke hengkey is meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Midsuǥù te Nengazen si Moises wey si Aaron ");
INSERT INTO mbbOT_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","he keǥiya zan heini ziyà te menge Israilihanen: Emun duen egawas diyà te sudiyà te maama tenged te zaru zin, heeyan is egawas ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Mebpedayun se kenà is kedtiǥis kayi ed-isipen gihapun sikandin he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Is minsan hengkey he egkehizeǥaan din etawa egkepinuuwan din egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","7","Ne is minsan hentei he ebpekesamsam kandin etawa ebpekesamsam te midhizeǥaan din etawa mibpinuuwan din, kinahanglan he ebpìpian din is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Is minsan hentei he egkeilevan kayi he etew, kinahanglan he ebpìpian din is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","10","Is minsan hengkey he egkepinuuwan wey egkeuntuzan din emun ed-untud sikandin te kudà, egkehimu haazà he meremerik. Is ebpekesamsam wey ebpekevitbit kayi, kinahanglan he ebpìpian din is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Is minsan hentei he egkesamsam kayi he etew te wazà mekepenlùlù te menge velad din, kinahanglan he ebpìpian din is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Is diniyun he egkesamsam kayi he etew kinahanglan he egevaan, ne is minsan hengkey he kayu he mibeelan he azen he egkesamsam kayi he etew kinahanglan he edlùluan. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","15","Ne emun egkeulian en heini he etew zutun te zaru zin, ipelavey zin dèpa is pitu he andew. Ne pìpii zin is bisti zin wey mebpemeziǥù te wahig he ebpuun diyà te serebseb. Dutun te ikewalu he andew kinahanglan he med-uwit sikandin te zezuwa he merepatik etawa dezuwa he limuken diyà te etuvangan te Nengazen diyà te gemawan te Tulda he Edtelevukaayan. Ne iveǥey zin haazà diyà te memumuhat he iyan ebpemuhat dutun. Is sevaha, ne pemuhat he para idlumpiyu ne is sevaha pa, para pemuhat he edtutungen. Pinaaǥi kayi te ebeelan te memumuhat diyà te etuvangan te Nengazen, egkaawà is keremerik keniyan he etew tenged te migawas diyà te sudiyè din, ne egkehimu en sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Emun is maama egewasan te similya zin, kinahanglan he mebpemeziǥù sikandin, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Is minsan hengkey he manggad etawa lundis he mibeelan he azen he egketiǥisan te similya zutun, kinahanglan he ebpìpian, piru ed-isipen pa ǥihapun heini he meremerik te taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Emun ebpehilevetà is maama wey vahi ne egewasan is maama te similya, kinahanglan he mebpemeziǥù sikandan is dezuwa, piru ed-isipen pa ǥihapun sikandan he meremerik taman te mahapun. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Emun edlelengesa is bahi, ed-isipen sikandin he meremerik seled te pitu he andew, ne is minsan hentei he edsamsam kandin ed-isipen daan he meremerik taman te mahapun. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Is minsan hengkey he egkehizeǥaan wey egkepinuuwan dutun te vahi he midlelengesa, egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Is minsan hentei he ebpekesamsam te midhizeǥaan din etawa mibpinuuwan din kinahanglan he pìpii zin is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Emun ebpekidhilavet is maama te vahi he midlelengesa, ed-isipen daan haazà is maama he meremerik seled te pitu he andew, ne is minsan hengkey he egkehizeǥaan din egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Emun edlengesahan is bahi he edrapas te egkepipira he andew etawa edlengesahan pa sikandin te kenà timpu te kedlelengesa zin, ed-isipen gihapun sikandin he meremerik, iring din ded daan emun ke wazè pa haazà maawà. Ed-isipen sikandin he meremerik emun kemulu pa edlengesahi. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Is minsan hengkey he egkehizeǥaan din dutun te edlengesahan sikandin etawa egkepinuuwan din egkehimu he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ne is minsan hentei he ebpekesamsam kayi egkehimu he meremerik. Kinahanglan he pìpii zin is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","29","Emun ed-engked is lengesa zutun te vahi, ipelavey zin dèpa is pitu he andew. Dutun te ikewalu he andew kinahanglan he med-uwit sikandin te zezuwa he merepatik etawa zezuwa he limuken diyà te memumuhat diyà te gemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ne ibpemuhat te memumuhat is sevaha kayi he para idlumpiyu ne is sevaha pa para pemuhat he edtutungen. Pinaaǥi kayi te ebeelan te memumuhat diyà te etuvangan te Nengazen, egkaawà is keremerik dutun te vahi ne egkehimu en sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Migkeǥiyan te Nengazen si Moises wey si Aaron he kinahanglan he ebpekeventayan te menge Israilihanen is mehitenged te igkehimuwa kandan he meremerik, su wey zan kenà mebpatey emun edseled sikandan diyà te tulda te Nengazen he ziyà te teliwazà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","Iyan heeyan menge sulunuzen mehitenged te maama he egewasan te similya etawa zuen egawas diyà te sudiyè din tenged te zaru zin, wey mehitenged te vahi he edlengesahan etawa edsubra te egkepipira he andew is kedlengesahi zin etawa edlengesahan te kenè pa timpu zin, wey mehitenged te maama he ebpekidhilavet te vahi he ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","2","Hein minatey en sikan is dezuwa he anak ni Aaron he menge maama dutun te kebpemuhata zan te Nengazen, migkaǥi is Nengazen diyà te ki Moises te, “Keǥiyi nu is suled nu he si Aaron he kenà sikandin medseled dutun te Utew Segradu he Lugar, dutun te liyu te kurtina, te minsan hengkey he uras he egkesuat sikandin. Su emun ed-ul-ulahan din heini ne ebpatey sikandin. Su kayi he lugar ibpeehè ku is kebpekiduma ku pinaaǥi te ǥapun dutun te renged te tangeb te Kavan te Kebpekid-uyun.” ");
INSERT INTO mbbOT_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Iyan heini insuǥù te Nengazen he veeli ni Aaron dutun te andew he edseled sikandin diyà te Utew Segradu he Lugar: Med-uwit sikandan te turiti he vaka he pemuhat he para idlumpiyu wey meemahan he kerehidu he pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kinahanglan he mebpemeziǥù sikandin ne isul-ub din is bisti he para te lavew he memumuhat he pudu linu: is pendizalem he visti he ebpeketambun te pid-etawan din, is pendivavew he visti, is bakes, wey is tengkulu. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mebeǥey kandin te zezuwa he meemahan he menge kambing is keet-etawan te Israel he pemuhat he para idlumpiyu wey sevaha he meemahan he kerehidu he pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ibpemuhat ni Aaron haazà is turiti he vaka he pemuhat he para idlumpiyu para mehimu sikandin he lumpiyu wey is menge pemilya zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ne egkuwaan din haazà is dezuwa he kambing ne ed-uwiten din daan diyà te etuvangan te Nengazen, diyà te ǥemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ne edripa sikandin ke hendei zapit dutun te zezuwa he kambing is para te Nengazen wey is para ki Azazel. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Is kambing he egkeripahan he para te Nengazen, ne pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Piru is kambing he egkeripahan he para ki Azazel, ibpemuhat din heini he uuyag diyà te Nengazen ne ibpaawè din heini ziyà te sibsivayan, su wey melibri is menge etew puun te menge salè dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Edlepaan ni Aaron sikan is turiti he vaka he pemuhat he para idlumpiyu kandin wey te menge pemilya zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ne egkuwa sikandin te selevukà te veyewà ne ebpenuen din heini te vaǥa he ebpuun diyà te pemuhatà he ziyà te seled te tulda. Ne egkuwa zaan sikandin te zezuwa he kemkem he mehemut he pinu he veyewà, ne ed-uwiten din heini ziyà te Utew Segradu he Lugar. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ne ziyà te etuvangan te Nengazen, idsavuk din haazà is beyewà duen te hapuy, ne is evel kayi ebpekeeneb duen te tambun te Kavan te Kebpekid-uyun, umbe kenà sikandin ebpatey. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Egkuwa sikandin te lengesa zuen te vaka ne edhitindeg sikandin diyà te egkesineruwan duen te Kavan te Kebpekid-uyun te Nengazen he edsinaru ziyà te edsilaan. Ne pinaaǥi te tezù din ebpirikan din te kepipitu sikan is tambun kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Edlepaan din daan sikan is kambing he pemuhat he para idlumpiyu te menge etew. Ed-uwiten din is lengesa kayi ziyà te Utew Segradu he Lugar ne ibpirik din duen te tambun te Kavan te Kebpekid-uyun, iring duen te mibeelan din duen te lengesa te vaka. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Pinaaǥi kayi te ebeelan ni Aaron, egkelumpiyuwan is Utew Segradu he Lugar te kegkeremeriki zuen tenged te keremerik te menge Israilihanen wey tenged te menge salà dan wey menge kedsupak dan. Ebeelan din daan heini ziyà te zuma he vahin duen te tulda su ziyà man heini mekepelastar te teliwazà te kampu zan te menge meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kinahanglan he wazà etew he ebpundu ziyà te Tulda zutun te uras te kedseled ni Aaron diyà te Utew Segradu he Lugar taman te egawas sikandin. Emun egkepasad din en te ebaal is tulumanen para melumpiyuwi sikandin, is pemilya zin, wey is tivuuk he keet-etawan te Israel, ");
INSERT INTO mbbOT_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","egawas sikandin duen te Utew Segradu he Lugar ne edhendiyà te pemuhatà he ziyà te ǥemawan te tulda. Ne egkuwa sikandin duen te lengesa zuen te vaka wey kambing he impemuhat ne ibpalis din duen te menge sungeysungey te menge suyuk duen te pemuhatà su wey melumpiyuwi heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ne pinaaǥi te tezù din ibpirik din te kepipitu zutun te pemuhatà is duma he lengesa te kebpemuhat kayi ziyà te Nengazen wey te ked-ewaa te keremerik te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ne emun egkepasad en ni Aaron te edlumpiyu sikan is Utew Segradu he Lugar wey is duma he parti zuen te tulda ragkes en is pemuhatà, ne ed-uwiten din diyà te teliwazà sikan is uuyag he kambing. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ne idampè din is dezuwa he velad din diyà te ulu zuen te kambing ne idtug-an din is langun he menge salà wey kedsupak te menge Israilihanen. Pinaaǥi kayi ebpekahalin is menge salè dan diyà te ulu zutun te kambing. Ne ibpepaawà ni Aaron haazà is kambing diyà te sibsivayan te etew he midseriǥan te kebaal kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Umbe, ed-uwiten dutun te kambing is langun he salà te menge Israilihanen diyà te sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ne edseled si Aaron dutun te tulda ne edluwasen din is bisti zin he visti te lavew he memumuhat he imbivisti zin hein wazè pa sikandin medseled diyà te Utew Segradu he Lugar, ne idtaǥak din heini zutun te tulda. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ne ebpemeziǥù sikandin diyà te sevaha he segradu he lugar zutun te Tulda ne kegkepasad ebivisti sikandin te urdinaryu. Ne egawas sikandin ne ibpemuhat din sikan is dezuwa he pemuhat he edtutungen para mevelukasi sikandin wey is menge Israilihanen te menge salè dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Edtutungen din daan diyà te pemuhatà is menge tavà dutun te pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Sikan is etew he insarig kandin is kebpaawà duen te kambing he para ki Azazel kinahanglan he ebpìpian din dèpa is bisti zin wey mebpemeziǥù te kenè pa sikandin edlikù diyà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kinahanglan he ed-uwiten diyà te ǥawas te kampu wey edtutungen is nesamà duen te vaka wey kambing he migkuwaan te lengesa he mid-uwit diyà te Utew Segradu he Lugar he inlumpiyu kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Is etew he edtutung kayi kinahanglan he ebpìpian din dèpa is bisti zin wey mebpemeziǥù te kenè pa sikandin edlikù diyà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","31","Iyan heini menge sulunuzen he ebeelan te menge Israilihanen wey te kenà menge Israilihanen he mid-ubpà duma kandan, ne tumana zan heini taman te taman. Dutun te ikesepulù he andew te ikepitu he vulan kinahanglan he mebpuasa zan ne kenè dan medterebahu, iring te Andew te Kedhimeley. Su iyan heeyan andew he ebeelan is tulumanen te kebelukas kandan puun te menge salè dan su wey zan mehimu he lumpiyu ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Is memumuhat he mibpilì wey mid-urdinahan he iyan ebpekeilis te amey zin te kegkelavew he memumuhat iyan ebaal zutun he tulumanen. Ivivisti zin is bisti te lavew he memumuhat, ");
INSERT INTO mbbOT_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ne veeli zin is tulumanen te kedlumpiyu zuen te Utew Segradu he Lugar, ziyà te zuma pa he vahin dutun te Tulda ragkes en is pemuhatà, is menge memumuhat, wey is menge etew te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Kinahanglan he edtumanen dan heini he sulunuzen taman te taman. Ne veeli zan heini kesevaha kada tuig. Ne midtuman heini ni Moises sumalà te insuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","he keǥiya zin heini ki Aaron wey te maama he menge anak din wey te langun he menge Israilihanen: ");
INSERT INTO mbbOT_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Is minsan hentei keniyu he ebpemuhat te vaka, kerehidu etawa kambing diyà te zuma he lugar, ");
INSERT INTO mbbOT_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","5","ne kenà diyà te Tulda he Ed-ezapan (egngezanan daan he Tulda he Edtelevukaayan), ne iring ded te nekevunù sikandin te etew, umbe kenè niw sikandin isipa he zuma niw. Midhimu heini he kebpemuhat su para ziyè niw veeli is kebpemuhat te ǥemawan te Tulda ne kenà diyà te zuma he lugar. Umbe is ibpemuhat niw he pemuhat he para gasa iveǥey niw ziyà te memumuhat he iyan ebpemuhat kayi ziyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ibpirik te memumuhat is lengesa te uyaǥen diyà te pemuhatà he pemuhatà he para te Nengazen, he ziyà te ǥemawan te Tulda. Ne edtutungen din is menge tavà dutun te uyaǥen ne is kehemut kayi ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Umbe, kenè kew en ereg he ebpemuhat diyà te ed-ezapen he henduen be te kambing, su ebpekepeziyù heeyan keniyu ziyà te Nengazen. Kinahanglan he tumana niw heini taman te huziyan he lapis te menge kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Timan-i niw heini, sikiyu is menge Israilihanen wey is kenà menge Israilihanen he mid-ubpà duma keniyu: Is minsan hentei he ebpemuhat te minsan hengkey he pemuhat diyà te zuma he lugar ");
INSERT INTO mbbOT_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ne kenà diyà te ǥemawan te tulda, ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Is minsan hentei he egkaan te lengesa egkeepesan te Nengazen ne kenè niw en sikandin isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Su is untung te linimbag ne ziyà te lengesa zin, ne insuǥù te Nengazen he gemita niw heini para mevelukasi kew puun te menge salè niw, su is lengesa he iyan mibeǥey te untung, iyan ebpekevelukas te etew puun te menge salà. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Iyan heini hinungdan ke maan is kenè kew ereg he egkaan te lengesa. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Is minsan hentei keniyu te menge Israilihanen wey te kenà menge Israilihanen he mid-ubpà duma keniyu he ed-utel te langgam etawa tagbis he egkehimu he egkeenen, kinahanglan he ibpetiǥis din is lengesa kayi ne tembuni zin te tanà, ");
INSERT INTO mbbOT_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","su is untung te linimbag ne ziyà te lengesa zin. Umbe migkeǥiyan kew te Nengazen he kenè niw keena is lengesa te minsan hengkey he linimbag; ne is minsan hentei he egkaan kayi ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Is minsan hentei keniyu te menge Israilihanen wey kenà menge Israilihanen he mid-ubpà duma keniyu he egkaan te langgam he minatey zà etawa midhimetayan te zuma he langgam, kinahanglan he pìpii zin is bisti zin wey mebpemeziǥù, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Emun kenè din ebpìpian is bisti zin wey kenà ebpemeziǥù, ne zuen din televaken. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","he keǥiya zin heini ziyà te menge Israilihanen: Iyan a Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kinahanglan he kenè niw veeli is menge ebeelan te menge etew ziyà te Ehipto he zutun kew med-ubpà dengan, wey is menge ebeelan te menge etew ziyà te Canaan, he zutun ku sikiyu ed-uwita. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","Kinahanglan he edtumanen niw is menge suǥù ku wey menge sulunuzen su is etew he edtuman kayi ebpekaangken te meupiya he ked-ubpà. Siak is Nengazen he Megbevayè niw, midsuǥù ku sikiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Wazà minsan hentei keniyu he mebpekidhilavet te megeget he kezuzumahi zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","8","Kenè nu peel-elezi is amey nu pinaaǥi te kebpekidhilavet te iney nu etawa zuma pa he esawa zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Kenè ka mebpekidhilavet te etevey nu, minsan etevey nu zà sikandin diyà te amey nu etawa iney nu, midekelè man sikandin duma keniyu wey ke wazà. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Kenè ka mebpekidhilavet te apù nu he vahi, su ebpekeveǥey heini kenikew te keelezan. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Kenè ka mebpekidhilavet te anak he vahi te amey nu ziyà te zuma he esawa zin, su suled nu zaan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Kenè ka mebpekidhilavet te ayè nu, suled man te amey nu etawa iney nu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Kenè nu peel-elezi is suled he maama te amey nu pinaaǥi te kebpekidhilavet te esawa zin, su ayè nu zaan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Kenè ka mebpekidhilavet te ambey nu su esawa sikandin te anak nu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Kenè ka mebpekidhilavet te ipag nu su ebpekeveǥey heini te keelezan te suled nu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kenè ka mebpekidhilavet te anak etawa apù he vahi te vahi he mibpekidhilavet ka kandin dutun te nehuna he timpu, su kela ke anak nu etawa apù nu haazà, ne mahawag heeyan he vaal. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kenè nu esewaa is ipag nu zutun te uuyag pa is esawa nu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Kenè ka mebpekidhilavet te vahi he edlengesahan su meremerik sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kenè ka mebpekidhilavet te esawa te zuma, su emun ebeelan nu heini ed-isipen ka he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kenè nu iveǥey is minsan hentei te menge anak nu su wey ikepemuhat diyà te ed-ezapen he si Molec, su ebpekeveǥey heeyan kedì te Megbevayè nu te keelezan. Iyan a sikan is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kenè ka mebpekidhilavet te iring nu he maama su mekeeled-eled heeyan. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kenè ka mebpekidhilavet te uyaǥen su utew heeyan mahawag, wey minsan is bahi ne kenè din iveǥey is lawa zin para mehileveti te uyaǥen. Su sevaha heini he kedsuwey te hustu ne ed-isipen ka he meremerik emun ebeelan nu heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Kenè niw remeriki is keugelingen niw pinaaǥi te kebaal te minsan hendei kayi he vaal, su iyan heini ingkeremeriki te menge etew he edsegseǥen ku puun te tanà he para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","28","Ne minsan ganì heeyan he tanà neremerikan tenged te ebeelan dan, umbe impaaǥi ku keniyan he tanà is menge kezeetan su wey pinaaǥi zutun mekeawè dan keniyan. Piru sikiyu is menge meǥinged he Israilihanen wey is kenà menge Israilihanen he mid-ubpà duma keniyu, kenè niw veeli heeyan is mahawag he menge vaal, kekenà, tumana niw is menge sulunuzen he ibpesunud ku wey menge suǥù. Su emun edremerikan niw heeyan is tanà pinaaǥi te kebaal niw keniyan he menge vaal, ibpaawè kew zaan keniyan he tanà iring te menge etew he nehuna keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Is minsan hentei he ebaal keniyan te utew mezaat he menge vaal ne kenè niw en sikandin isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Umbe, tumana niw is ebpeveelan ku keniyu ne kenè niw iringi is utew mezaat he menge ebeelan te menge etew he nehuna keniyu, su wey niw kenà meremeriki is keugelingen niw tenged kayi. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","he keǥiya zin heini ziyà te tivuuk he keet-etawan te Israel: Pengungubpaan kew he segradu su waǥas a is Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kinahanglan he edtehuzen niw is iney niw wey amey niw, wey kinahanglan he tumana niw is ebpeveelan ku keniyu zutun te Andew te Kedhimeley. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Kenè kew med-azap te zuma he menge ed-ezapen wey kenè kew mebaal te ledawan te zuma he ed-ezapen. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Emun ebpemuhat kew te pemuhat para mehimu he meupiya is kebpekidepitè niw kedì, ipemuhat niw heini te paaǥi he egkezawat ku heini para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Keena niw is usa kayi zutun te andew te kebpemuhat niw etawa sunud he andew. Piru emun duen egkesamà he usa taman te iketelu he andew kinahanglan he edtutungen heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Emun egkeenen niw heini te iketelu he andew ne kenè ku heini edewaten su utew mezaat heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Is minsan hentei he egkaan kayi ne zuen din televaken su ebpendezeisayen din is para kediey, umbe haazà he etew kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Emun edraǥun kew ne kenè niw emina te edraǥun is diyà te kilid te pemuleey niw, ne kenè niw en likui pekirerawa is nengesamà. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Iring ded dutun is beeli niw ziyà te pemuleey niw te paras, kenè niw en likui wey kuwaa is nengeulug. Teǥaka niw en heeyan para te menge pubri wey te menge lumelengyawà. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Kenè kew mebpenakew, medtarùtarù, etawa medlimbung te iring niw he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kenè kew penangdù te tarù he egemiten niw is ngazan ku, su emun ebeelan niw heeyan ne ebpeel-elezan a keniyu. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Kenè niw limbungi wey tekawi is iring niw he etew. Kenè niw lenglengani te edsuhul is etew he impeterebahu niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kenè niw keǥiyi te mezaat is bengel, wey kenè kew medsavuk te egkesipà diyà te ibayà te lakap. Tumana niw heini su ibpekilala niw is kedtehuza niw kedì. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Kinahanglan he meketezenganen wey hustu is kedhukum niw ziyà te hukmanan; kinahanglan he wazè niw ibpelavi, sepian etawa pubri. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Kenè kew ituk te zuma niw he etew. Kenè kew vaal te minsan hengkey he ebpekezezaat te untung din. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Kenè niw dumuti is duma niw he etew. Dewaya niw sikandin emun nekesalà sikandin su para wazè niw televaken. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kenè kew penimales etawa dumut te zuma niw he etew, kekenà, mahala niw sikandin iring te kebmahala niw te keugelingen niw. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Tumana niw is menge sulunuzen he ibpesunud ku. Kenè niw pepeniwelayi is sevaha he uyaǥen te selakew en he kelasi te uyaǥen. Kenè kew pemula te zezuwa he kelasi te venì diyà te sevaha zà he pemuleey. Kenè kew sul-ub te sevaha he visti he zezuwa he kelasi te manggad. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Emun is sevaha he maama ebpekidhilavet te sevaha he uripen he vahi he ed-esewaan en te sengememaama, piru heini is bahi wazè pa mevelukasi te kegkeuripena kandin etawa wazè pa meveǥayi te vayàbayà, kinahanglan he edsilutan sikandan. Piru kenà sikandan edhimetayan su kenè pe man ebpekevayàbayà haazà is bahi. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","22","Kinahanglan he med-uwit sikan is maama te meemahan he kerehidu ziyà te ǥemawan te Tulda he Edtelevukaayan he vayad te salè din. Pinaaǥi te kebpemuhata te memumuhat dutun te kerehidu ziyà te etuvangan ku, egkevelukasan haazà is maama te salè din ne ebpeseyluwen ku sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Emun ebpekeuma kew en diyà te tanà he ibeǥey ku keniyu, kenè niw keena is beǥas te kayu he ibpemula niw zutun te egkehuna he tetelu he tuig. Isipa niw heini he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Dutun te ikeepat he tuig, is langun he veǥas kayi ihalad niw kayi te kedì he idalig kedì, umbe kenè niw zaan heini keena. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Piru te ikelima he tuig ne ebpekekaan kew en te menge veǥas kayi. Ne emun edtumanen niw heini he sulunuzen, utew meveǥas is menge kayu niw. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Kenè kew kaan te usa he zuen din pa lengesa. Kenè niw veeli is ebeelan te menge kineegmanen etawa veyilan. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Emun idlalew niw is minatey kenè niw tempezi is bulvul niw ziyà te kada tengkilizan te ulu niw etawa sumpè niw, ");
INSERT INTO mbbOT_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","wey kenè niw zaan pelii is lawa niw. Wey kenè kew zaan mebpepatik. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Kenè niw peel-elezi is menge anak niw he vahi pinaaǥi te kebpeǥesa niw kandan te kebelegyà te zengeg dan, su ebpekeiniyat heini, ne utew ebmahabet diyà te lugar niw is ed-ulaula kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Tumana niw is ebpeveelan ku keniyu zutun te Andew te Kedhimeley, ne tehuza niw is lugar he zutun a keniyu ed-ezapa. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Kenè kew zangep diyà te menge veyilan he ebpekidlalag te gimukud te nemematey en, su emun ebeelan niw heini ed-isipen kew he meremerik. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tehuza niw is menge meǥurang, wey tehuza a zaan keniyu is Megbevayè niw. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kenè niw temudmuzi is kenà menge Israilihanen he ed-ubpà duma keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Irerepengan niw sikandan, wey mahala niw sikandan iring te kebmahala niw te keugelingen niw, su umuuliey kew zaan dengan diyà te Ehipto. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Kenè kew limbung diyà te kedtimbang niw, kedtakes niw, etawa kedsukud niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","37","Gemita niw is hustu he timbangan, tekesà, wey sukud. Iyan a kes Nengazen he Megbevayè niw he mibpeǥawas keniyu ziyà te Ehipto. Tumana niw is langun he menge sulunuzen he ibpesunud ku wey menge suǥù ku. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","he keǥiya zin heini ziyà te menge Israilihanen: Is minsan hentei keniyu te menge Israilihanen etawa kenà menge Israilihanen he mid-ubpà duma keniyu he ebpemuhat te anak din diyà te ed-ezapen he si Molec, kinahanglan he penulenga niw te vatu taman te kebpatey zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","4","Egkeepesan ku heeyan he etew ne kenè niw en isipa he zuma niw, su zutun te kebpemuhata zin te anak din diyà te ki Molec, midremerikan din is lugar he zutun a keniyu ed-ezapa ne mibpendezeisey zin is ngazan ku. Emun ebey-anan niw zà haazà he etew, ");
INSERT INTO mbbOT_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","iyan a mismu egkuntra kandin wey te pemilya zin wey te langun he edsunud kandin te kebpemuhat diyà te ki Molec. Kenè ku sikandan ed-isipen he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Egkeepesan ku zaan is etew he edangep wey edsunud te menge veyilan he ebpekidlalag te ǥimukud te nemematey en. Kenè ku sikandan ed-isipen he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ihalad niw is keugelingen niw para kediey wey pengungubpaan kew he segradu, su iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Tumana niw is menge sulunuzen he ibpesunud ku, su iyan a is Nengazen midsivey keniyu para kedì. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Is minsan hentei he edrewakan din is amey zin etawa iney zin kinahanglan he edhimetayan. Iyan dà sikandin egkevasul zutun te kedhimetayi kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Emun ebpekidhilavet is maama te esawa te zuma, ne sikandin wey kes bahi kinahanglan he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Emun ebpekidhilavet is maama te sevaha te menge esawa te amey zin, mibpeel-elezan din is amey zin. Ne sikandan is dezuwa zutun te vahi kinahanglan he edhimetayan. Iyan dà sikandan egkevasul zutun te kemetayen dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Emun is amey ebpekidhilavet te ambey zin, ne sikandan is dezuwa kinahanglan he edhimetayan. Su mezaat is mibeelan dan. Iyan dà sikandan egkevasul zutun te kemetayen dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Emun is maama ebpekidhilavet te iring din he maama, ne sikandan is dezuwa kinahanglan he edhimetayan su utew mezaat is mibeelan dan. Diyè dà te kandan igkevasul is kemetayen dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Emun ed-esewaan te maama is iney wey anak, kinahanglan he ebinsulan sikandan is tetelu, su mezaat is mibeelan dan. Kenà ereg he ebpedayun heini he kelelalung diyà te keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","Emun duen maama etawa vahi he ebpekidhilavet te uyaǥen, kinahanglan he edhimetayan sikandin wey haazà is uyaǥen. Diyè dà te kandan igkevasul is kemetayen dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Emun is maama ebpengesawa wey ebpekidhilavet te etevey zin, minsan ke suled din dà heini ziyà te amey etawa iney, mibpeel-elezan din haazà is suled din ne zuen din televaken. Ne ǥeina te mekeeled-eled haazà is mibeelan dan te zezuwa, ne kenè niw en sikandan isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Emun is maama ebpekidhilavet te vahi he midlengesahan, ne nemineg haazà is bahi, ne kenè niw en sikandan isipa is dezuwa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Emun is maama ebpekidhilavet te ayè din, mibpeel-elezan din haazà is ayè din. Ne sikandan is dezuwa ne zuen dan televaken dutun te mibeelan dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Emun is maama ebpekidhilavet te esawa te anggam din, mibpeel-elezan din is anggam din. Sikandan is dezuwa ne zuen dan televaken, ne ebpatey zà sikandan he wazè dan anak. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Emun is maama ebpengesawa te esawa te suled din he uuyag pa, mibpeel-elezan din is suled din. Ne ǥeina te meremerik is mibeelan dan, ne tekew en sikandan ebpatey he wazè dan anak. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Tumana niw is langun he menge sulunuzen he ibpesunud ku wey is menge suǥù ku su wey ku sikiyu kenà ipaawà diyà te tanà he ed-uwitan ku keniyu he egkeubpaan niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Is menge etew he ibpaawè ku zutun he tanà iyan mibaal keniyan he kelelalung, ne tenged kayi igkelimezangi ku sikandan. Umbe kenè niw iringi is ebeelan dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ne sumalà te nekaǥi ku keniyu egkaangken niw is tanè dan. Ibeǥey ku keniyu heini is meupiya wey selebpeten he tanà su wey niw maangken. Iyan a kes Nengazen he Megbevayè niw he midhimu keniyu he segradu puun te zuma he menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kinahanglan he egketuenan niw ke hengkey is lumpiyu wey meremerik he menge langgam ragkes en is menge tagbis. Kenè niw remeriki is keugelingen niw pinaaǥi te kegkaan te meremerik he menge langgam. Ne sumalà te migkaǥi ku keniyu, isipa niw heini he meremerik, ");
INSERT INTO mbbOT_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","pengungubpaan kew he segradu su siak is Nengazen, waǥas a. Ne midhimu ku sikiyu he segradu puun te zuma he menge nasyun su wey kew mehimu he kediey. ");
INSERT INTO mbbOT_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Emun duen keniyu veyilan he ebpekidlalag te ǥimukud te nemematey en, kinahanglan he ebpenulengen sikandin te vatu taman te ebpatey. Ne iyan dà sikandin egkevasul zutun te kemetayen din. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Midsuǥù te Nengazen si Moises he keǥiya zin heini ziyà te menge memumuhat he kevuwazan ni Aaron: Kenè niw remeriki is keugelingen niw pinaaǥi te kedtampu te kedlevenga te iring niw he Israilihanen, ");
INSERT INTO mbbOT_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","gawas ke is ebpatey utew niw en megeget iring te iney niw, amey niw, anak niw, suled niw he maama, ");
INSERT INTO mbbOT_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","etawa etevey niw he wazè din pa esawa, ne midsarig pa keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kenè niw zaan remeriki is keugelingen niw pinaaǥi te kedtampu te kedlevenga te kezuzumahi te esawa niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Emun edlalew kew tenged te minatey, ne kenè niw kiskisi is minsan hendei he vahin te ulu niw, kenè niw tempezi is sumpè niw, wey kenè niw pelii is lawa niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kinahanglan he idhalad niw is keugelingen niw para kediey te Megbevayè niw, wey kenè niw pendezeisaya is ngazan ku. Beeli niw heini su iyan kew man ebpemuhat te menge pemuhat pinaaǥi te hapuy, he iyan keenen ku. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kinahanglan he kenè kew mebpengesawa te vahi he meremerik su ebelegyà te zengeg din, etawa vahi he midsuwayan te esawa zin, su insivey kew para kediey. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kinahanglan he segradu is ked-isipa keniyu te zuma niw he menge Israilihanen su iyan kew ebpemuhat te menge pemuhat kayi te kediey, te Nengazen, he waǥas, ne edhimuwen ku is menge etew ku he wazà igkesewayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Emun duen niw anak he vahi he ebpeelimungew keniyu tenged te kebelegyè din te zengeg din, ne tenged dutun ed-isipen sikandin he meremerik, kinahanglan he ebinsulan sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Emun egkeseeng is lavew he memumuhat tenged te minatey, kinahanglan he kenè din gusenga is bulvul zin wey kenè din bindasa is bisti zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kinahanglan he edsenggilahan din is kebpekesamsam te minatey, minsan pa ke amey zin etawa iney zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ne ǥeina te inhalad sikandin kayi te kedì he lavew he memumuhat pinaaǥi te kedlenahi kandin, kenà sikandin ereg he ed-awà diyà te Tulda he Edtelevukaayan te kedtampu te kedleveng, su emun ebeelan din heini ne egkeremerikan sikan is tulda. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","14","Is ed-esewaan te lavew he memumuhat kinahanglan he wazè pa mekeremaǥi wey iring din he Israilihanen. Kenà sikandin mebpengesawa te valu etawa vahi he midsuwayan te esawa zin, etawa vahi he meremerik su ebelegyà te zengeg din. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pinaaǥi te kedtumana kayi te memumuhat kenà ed-isipen he meremerik is menge anak din. Iyan a is Nengazen midsivey kandin para mehimu he lavew he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","he keǥiya zin heini ziyà te ki Aaron: Wazà minsan hentei te menge kevuwazan nu he taman te huziyan he lapis te menge kevuwazan he ebpekepenilbi pinaaǥi te kegkememumuhat emun duen sazir te lawa zin. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kenà egkehimu is lakap, pigket, duen sazir te kebuvuked din, duen sazir ziyà te lawa zin, ");
INSERT INTO mbbOT_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nelepuan is paa zin etawa velad, ");
INSERT INTO mbbOT_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","bekut, inanu, duen din daru ziyà te mata etawa lundis, etawa kenà ebpekaanak. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","23","Umbe, emun duen sazir te kevuwazan ni Aaron, ne kenà egkehimu he ebpemuhat kayi te kedì te menge pemuhat pinaaǥi te hapuy, he iyan keenen ku. Wey kenà daan egkehimu ke edseled sikandin diyà te Segradu he Lugar wey ed-uvey zuen te pemuhatà su egkeremerikan is Tulda ku. Piru egkehimu ke egkaan sikandin te menge keenen he vahin te menge memumuhat duen te segradu he pemuhat wey zuen te utew segradu he pemuhat. Iyan a is Nengazen midsivey keniyu para kedì. ");
INSERT INTO mbbOT_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Umbe, migkaǥi heini is langun ni Moises diyà te ki Aaron wey ziyà te menge kevuwazan din he menge maama, wey ziyà te langun he menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","he keǥiya zin heini ziyà te ki Aaron wey ziyà te maama he menge kevuwazan din: Kenè niw pendezeisaya is waǥas he ngazan ku, umbe tehuza niw is menge pemuhat he ibpemuhat te menge Israilihanen kayi te kedì. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Emun duen keniyu ǥuntaan etawa menge kevuwazan niw taman te huziyan he lapis te menge kevuwazan he edsamsam te pemuhat kayi te kedì, dutun te meremerik sikandin, kenè en egkehimu he ebpekepenilbi pinaaǥi te kegkememumuhat din. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","7","Wazà minsan hentei keniyu he egkehimu he egkaan te pemuhat, emun duen din daru te lundis, etawa zuen egawas diyà te sudiyè din tenged te zaru zin, etawa nekesamsam te azen he nehimu he meremerik su nekeseǥahid te minatey, etawa migewasan te similya, etawa nekesamsam te langgam, etawa etew he ed-isipen he meremerik. Wey zà sikandin egkehimu he egkaan te menge pemuhat emun ebpekepemeziǥù sikandin, piru medtaǥad pa sikandin taman te mahapun, dutun te edsanlep en is andew, ne egkehimu en human he egkaan sikandin te menge pemuhat he iyan keuyaǥan din su memumuhat man sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kinahanglan he kenè kew megkaan te minsan hengkey he usa te langgam he minatey zà etawa midhimetayan te zuma he langgam. Su emun ebeelan niw heini ed-isipen kew he meremerik. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Sikiyu is menge memumuhat, tumana niw is ibpetuman ku keniyu. Kinahanglan he edtumanen niw heini su wey kew kenà mekepenavak wey mebpatey. Iyan a is Nengazen midsivey keniyu para kedì. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Iyan kew zà wey is pemilya niw, egkehimu he egkaan duen te vahin te menge pemuhat he para te menge memumuhat. Kenà egkehimu he egkaan kayi is meǥeliyug niw etawa sinuhulan niw he terebahanti. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Piru egkehimu ke egkaan kayi is uripen he mibpemasa niw etawa in-anak diyà te keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kenà daan ebpekekaan kayi is anak te memumuhat he neesawa te kenà memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Iyan, emun nevalu sikandin etawa nekedsuwey zan te esawa zin he wazè dan anak, ne midlikù med-ubpà duma te amey zin, ne ebpekekaan sikandin te keenen he egkezawat te amey zin dutun te kegkememumuhat din. Purungi niw tentenuzi he iyan kew zà is menge memumuhat wey is pemilya niw ebpekekaan te vahin te menge pemuhat he para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Iyan, emun duen etew he kenà sakup te pemilya niw he ebpekekaan kayi he wazè din tivevaa, kinahanglan he edliwanan din heini ziyà te keniyu ne umani zin pa te 20 pursintu is bali kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Sikiyu is menge memumuhat, kenè niw pendezeisaya is menge pemuhat te menge Israilihanen kayi te kedì, ");
INSERT INTO mbbOT_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","su wey kew kenà mekesalà dutun te kegkeena niw kayi ne wazè niw televaken. Iyan a is Nengazen midsivey keniyu su wey kew mehimu he kedì. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","he keǥiya zin heini ziyà te ki Aaron wey ziyà te maama he menge anak din, diyà te iring dan he menge Israilihanen, wey ragkes is kenà menge Israilihanen he mid-ubpà duma kandan: Emun is pemuhat he edtutungen iyan ibpemuhat niw he pemuhat para te kedtuman te sevaha he penaad etawa pemuhat he keugelingen he suat, ");
INSERT INTO mbbOT_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kinahanglan he meemahan he vaka, kerehidu, etawa kambing ne kinahanglan he wazè dan sazir su wey ku zewata heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kenè kew mebpemuhat te zuen din sazir su kenè ku heini edewaten. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Emun is pemuhat he para te meupiya he kedepità ibpemuhat niw kediey he kedtuman te penaad etawa pemuhat he keugelingen he suat, kinahanglan he vaka heini etawa kerehidu etawa kambing he wazè sazir su edewaten ku heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kenè kew mebpemuhat kayi te kedì te uyaǥen he lakap, lepù, pelien, etawa zuen din daru te lundis. Kenè niw heini ipemuhat kedì dutun te pemuhatà te pemuhat he pinaaǥi te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Egkehimu he ibpemuhat niw he pemuhat he keugelingen he suat is baka etawa kerehidu he kenà hustu is kegkeveeli te sevaha he vahin te lawa zin, piru kenà heini egkehimu he ibpemuhat he pemuhat he kedtuman te penaad. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kenè kew mebpemuhat kayi te kedì te uyaǥen he nepelian is tayak din etawa migkapun. Kenè niw heini veeli ziyà te lugar niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ne kenè kew zaan mebpemasa te iring keniyan he kelasi te uyaǥen diyà te menge lumelengyawà te ibpemuhat niw kayi te kedì, su kenè ku heeyan edewaten. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Is beǥu he in-anak he vaka, kerehidu etawa kambing, kinahanglan he kenè idsuwey te iney zin seled te pitu he andew. Piru emun midlavey en te pitu he andew egkehimu en heini he ibpemuhat niw kayi te kedì he pemuhat pinaaǥi te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Emun ebpemuhat kew te vaka etawa kerehidu, ne kenè niw iredsà kandan is nati zan dutun te iyan ded he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Emun ebpemuhaten a keniyu te pemuhat he para kebpeselamat kedì, sunuza niw is hustu he paaǥi te kebpemuhata kayi su para zewata ku heini. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ne kinahanglan he keena niw en dutun mismu te andew te kebpemuhata zuen ne kenè niw semai taman te edsunud he meselem. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Tumana niw is menge suǥù ku. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kenè niw pendezeisaya is waǥas he ngazan ku, ne kilelaa a keniyu he waǥas. Iyan a is Nengazen midsivey keniyu su wey kew mehimu he menge etew ku, ");
INSERT INTO mbbOT_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","wey mibpeǥawas a keniyu puun te Ehipto su wey a mehimu he Megbevayè niw. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","he keǥiya zin heini ziyà te menge Israilihanen, is mehitenged te ispisyal he menge timpu he zutun medtiǥum dan te ked-azap te Nengazen: ");
INSERT INTO mbbOT_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Duen heenem he andew te kedterebahu niw, piru himeley kew ziyà te ikepitu he andew su iyan heeyan Andew te Kedhimeley. Kenè kew terebahu keniyan he andew, kekena, tiǥum kew para te ked-azap, su andew heeyan he ebeǥayan niw te zengeg is Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Is Pista te Kedlavey te Belinsuǥuen wey is Pista te Supas he Wazè din Tapey, menge ispisyal heini he menge timpu he edtiǥum is menge Israilihanen te ked-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Is Pista te Kedlavey te Belinsuǥuen, mezukilem is kedhimuwa zuen diyà te ike-14 he andew te egkehuna he vulan te tuig. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ne ike-15 he andew zutun he vulan, ebpuun daan is Pista te Supas he Wazè din Tapey. Pitu he andew heini he pista, ne zutun he menge andew kinahanglan he iyan egkeenen niw is supas he wazè din tapey. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Dutun te egkehuna he andew kayi te pista, ne kenè kew medterebahu, kekenà, tiǥum kew te ked-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Seled te pitu he andew pemuhatà niw is Nengazen te pemuhat pinaaǥi te hapuy. Ne zutun te ikepitu he andew ne kenè kew en maan terebahu, kekenà, tiǥum kew te ked-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","11","Emun diyè kew en te tanà he ibeǥey te Nengazen keniyu, ipemuhat niw ziyà te kandin is egkehuna he vinagkes niw he menge pungu te kada kedraǥun niw. Uwita niw heini ziyà te memumuhat dutun te sunud he andew te Andew te Kedhimeley, ne ibayew heini te memumuhat diyà te etuvangan te Nengazen su wey kew zewata te Nengazen pinaaǥi kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Dutun daan he andew, pemuhat kew ziyà te Nengazen te kerehidu he senge-tuig is keǥurang din he wazè din sazir he pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Lepiki niw heini te pemuhat he para gasa he heepat he kilu he meupiya he kelasi te herina he midsehuǥan te lana, wey senge litru he vinu he pemuhat he inumen. Pemuhat heini he pinaaǥi te hapuy, is kehemut kayi ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Emun wazè niw pa heini ikepemuhat, ne kenè kew pa megkaan te minsan hengkey he kelasi te keenen he zuma te beǥu he midraǥun niw, mehilew man heini etawa sinandag etawa midlutù he supas. Heini he sulunuzen, kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan niw, minsan hendei kew ed-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","17","Kedlavey zutun te pitu he simana he iyan kebpuun te andew zutun te kedhelaza niw zuen te menge vinagkes he pungu, tiǥum kew ne pemuhat kew uman te pemuhat he para gasa puun dutun te menge pungu he veǥu pa he ineǥani niw. Ul-ulaha niw heini zutun te ike-50 he andew, he iyan kes andew te kegkeiwas te ikepitu he Andew te Kedhimeley. Is idhalad niw, ne zezuwa he supas he mibeelan he ziyà ebpuun te heepat he kilu te meupiya he kelasi te herina, he zuen din tapey. Ipemuhat niw heini he pemuhat he ibayew he ebpuun te nehuna he neraǥun niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Perisi niw heini te pitu he meemahan he kerehidu, he tig senge-tuig is keǥurang, sevaha he turiti he vaka, wey zezuwa he meemahan he kerehidu, he wazè dan menge sazir. Ipemuhat niw heini he pemuhat he edtutungen duma te pemuhat he para gasa duma zuen te pemuhat he inumen. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ne pemuhat kew zaan te sevaha he meemahan he kambing he pemuhat he para idlumpiyu, wey zezuwa he kerehidu he tig senge-tuig is keǥurang dan he para te meupiya he kebpekidepità diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ne ibayew te memumuhat diyà te etuvangan te Nengazen sikan is dezuwa he kerehidu wey is pemuhat he zuma te nehuna he neraǥun. Segradu heini he menge pemuhat diyà te Nengazen ne vahin heini te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Dutun he andew kenè kew medterebahu, kekenà, tiǥum kew te ked-azap te Nengazen. Heini he sulunuzen, ne kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan niw, minsan hendei kew ed-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Emun edraǥun kew ne kenè niw emina te edraǥun is diyà te kilid te pemuleey niw, ne kenè niw en likui wey pekirerawa. Teǥaka niw en heeyan he para te menge pubri wey menge langyew he kenà menge Israilihanen. Iyan heini suǥù te Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Dutun te egkehuna he andew te ikepitu he vulan te tuig, himeley kew para te kedtentenuzi niw te Nengazen. Emun egkezineg niw is kebpezaǥing te menge trumpita, ne tiǥum kew te ked-azap kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kenè kew terebahu zutun he andew, kekenà, pemuhata niw is Nengazen te pemuhat pinaaǥi te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","28","Dutun te ikesepulù he andew kayi te ikepitu he vulan, iyan kes Andew te Kebelukas. Kenè kew terebahu keniyan he andew, kekenà, tiǥum kew te ked-azap te Nengazen. Puasa kew wey pemuhata niw sikandin te pemuhat pinaaǥi te hapuy. Su keniyan he andew ebeelan is tulumanen te kebelukasi keniyu tenged te menge salè niw diyà te etuvangan te Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Is kenà ebpuasa zutun he andew ne kenè niw en isipa he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Edhimetayan te Nengazen is minsan hentei he edterebahu keniyan he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","32","Umbe, himeley kew wey puasa kew puun te kedsanlep te andew te ikesiyew he andew te haazà he vulan taman te sunud he kedsanlep te andew. Kinahanglan he tumana niw heini he sulunuzen taman te huziyan he lapis te peleebuten he menge kevuwazan niw, minsan hendei kew ed-ubpà. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Dutun te ike-15 he andew te ikepitu he vulan ebpuunan is Pista te Kebaal te menge Lawig, ne silibraha niw heini seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Dutun te egkehuna he andew kenè kew terebahu, kekenà, tiǥum kew te ked-azap te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Seled te pitu he andew ebpemuhat kew ziyà te Nengazen te pemuhat pinaaǥi te hapuy. Ne ikewalu he andew kenè kew en maan terebahu, kekenà, tiǥum kew en maan te ked-azap te Nengazen, ne pemuhata niw sikandin. Ketepusan heini he andew te kedtiǥum niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Iyan heini ispisyal he menge timpu he zutun edtiǥum kew te ked-azap te Nengazen wey kebpemuhat te menge pemuhat pinaaǥi te hapuy. Kinahanglan he uwit kew te menge pemuhat he edtutungen, pemuhat he para gasa, pemuhat he para te meupiya he kedepità, wey menge pemuhat he inumen, he kinahanglan he ibpemuhat niw zutun te netendek he timpu te kebpemuhata kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Silibraha niw heini is ispisyal he menge timpu he ebpekeuman te Andew te Kedhimeley he ebeelan niw kada simana. Wey ipemuhat niw heini he menge pemuhat he ebpekeuman te menge gasa niw, menge pemuhat he para te kedtuman te menge penaad niw, wey menge pemuhat he kineugelingen he suat he ibpemuhat niw ziyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Emun mehitenged te Pista te Kebaal te menge Lawig, ne silibraha niw heini he para te kebeǥey te zengeg diyà te Nengazen puun te ike-15 he andew te ikepitu he vulan, dutun te tevas. Silibraha niw heini seled te pitu he andew; kenè kew medterebahu zutun te egkehuna he andew wey ikewalu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Dutun te egkehuna he andew kuwa kew te kineupiyahan he menge veǥas te menge kayu, menge zahun te palma, menge subpang te merapung he menge kayu, wey dezeisey he kayu ziyà te pangpang, ne medlipey kew ziyà te etuvangan te Nengazen he Megbevayè niw seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","43","Silibraha niw heini he pista ziyà te ikepitu he vulan kada tuig para te kebeǥey te zengeg diyà te Nengazen. Seled te pitu he andew, ubpè kew ziyà te menge lawig su wey metueni te menge kevuwazan niw he impeubpà te Nengazen he Megbevayè niw is menge kepuun niw ziyà te menge lawig hein impeǥawas din sikandan puun te Ehipto. Heini he sulunuzen, ne kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Iyan haazà sikan is ispisyal he menge timpu te ked-ezap te Nengazen he impetuenan ni Moises te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","4","Midsuǥù te Nengazen si Moises he ipetuman din heini te menge Israilihanen: Uwiti niw te lunsey he lana te mibevayu he ulibu is menge sulù diyà te ǥawas te ruǥu he zutun is selevukà te Kavan te Kebpekid-uyun dutun te Tulda he Edtelevukaayan, su para kenà meengked is kedsiǥa kayi ziyà te etuvangan te Nengazen. Emun ebmerusirem en, edtemteman heini ni Aaron ne ibpesiǥa taman te egkepawà. Edsigureduwen din he pirmeninti is kedsiǥa te menge sulù diyà te impehitindeg he selevukà duen he lunsey he vulawan. Heini he sulunuzen, kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Baal kew te 12 he vuuk he supas, he is kada sevaha mibeelan puun te heepat he kilu he meupiya he kelasi te herina. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Isavuk niw heini ziyà te lemisahan he lunsey he vulawan he ziyà te etuvangan te Nengazen. Ilinya niw heini te zezuwa he linya he tig-enem he supas is diyà te kada linya. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ne sevuki niw te lunsey he veyewà is avey te kada linya. Haazà is beyewà, iyan egkehimu he pemuhat he para te kedtentenuzi te Nengazen. Edtutungen heini he iyan pemuhat pinaaǥi te hapuy he ilis duen te menge supas. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kinahanglan he layun idsavuk heini is menge supas diyà te etuvangan te Nengazen kada Andew te Kedhimeley. Ketengdanan niw heini te menge Israilihanen taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Heini he menge supas, ne para ki Aaron wey te menge kevuwazan din. Egkeenen dan heini ziyà te segradu he lugar zutun te Tulda, tenged te utew heini segradu he vahin te menge pemuhat. Ne para heini kandan taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Duen sevaha he etew he is amey zin Ehiptohanen ne is iney zin Israilihanen. (Is ngazan te iney zin iyan si Shelomit, he anak ni Dibri te ebpuun diyà te tribu ni Dan.) Nekidtebek heini he etew te sevaha he Israilihanen diyà te kampu, ne midsumpalit din is ngazan te Nengazen. Umbe mid-uwit dan haazà diyà te ki Moises, ");
INSERT INTO mbbOT_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ne mibpirisu zan haazà taman te egketuenan dan ke hengkey is egkesuatan te Nengazen mehitenged dutun he etew. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ne migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Uwita niw ziyà te ǥawas te kampu sikan is etew he midsumpalit kedì. Is langun he nekezineg te kedsumpalit din ne izampè dan is belad dan diyà te ulu zin he tuus te zuen din televaken, ne kegkepasad ne ebpenulengen sikandin te vatu te tivuuk he menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Ne keǥiyi nu is menge Israilihanen he minsan hentei kandan wey is kenà menge Israilihanen he mid-ubpà duma kandan he edsumpalit kediey wey ebpendezeisey te ngazan ku, ne zuen din televaken. Kinahanglan he ebpenulengen sikandin te vatu te tivuuk he kezekelan taman te ebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Is minsan hentei he ebpekepatey te etew, kinahanglan he edhimetayan daan. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Is etew he ebpekepatey te uyaǥen te zuma kinahanglan he ed-ilisan din haazà. Uuyag daan is iliwan din su uuyag man sikan is midhimetayan din. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","20","Emun ebpekevaal te mezaat is sevaha he etew ziyà te iring din he etew ne ebeelan daan diyà te kandin is iring te mibeelan din: Emun midlepuan din is sengeeetew ne edlepuan daan sikandin, emun midluǥit din is mata te zuma ne edluǥiten daan is kandin he mata, emun midsepuan din te ngipen is duma ne edsepuan daan sikandin te ngipen. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Is minsan hentei he ebpekepatey te uyaǥen kinahanglan he ed-ilisan din heini, piru is ebpekepatey te etew ne kinahanglan he edhimetayan daan. ");
INSERT INTO mbbOT_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Heini he velaud ne para keniyu te langun, he tutuu he Israilihanen etawa kenà. Iyan a kes Nengazen he Megbevayè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Hein nepasad ni Moises heini te egkaǥi ziyà te menge Israilihanen ne mid-uwit dan sikan is etew he midsumpalit din is Megbevayà diyà te ǥawas te kampu ne mibpenuleng dan te vatu, sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Hein diyè en si Moises te Buntud he Sinai, midsuǥù sikandin te Nengazen ");
INSERT INTO mbbOT_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","he keǥiya zin heini ziyà te menge Israilihanen: Emun ebpekeuma kew en duen te tanà he ibeǥey ku keniyu, kenè niw pemulai is tanà te kada ikepitu he tuig su wey a keniyu meveǥayi te zengeg. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","4","Seled te heenem he tuig ne ebpekepemula kew wey ebpekeraǥun. Piru te ikepitu he tuig ne kinahanglan he ibpehimeley niw is tanà. Kenè niw pemulai is menge vevesukè niw ne kenè niw zaan penempezi te menge subpang is menge paras niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ne kenè niw zaan reǥuna wey kenè niw ivelegyà is menge pungu etawa menge veǥas te menge pinemula he nenuvù dà. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Piru egkehimu heini he egkeenen niw zuma te menge suluǥuen niw, menge terebahanti niw, wey te kenà menge Israilihanen he mid-ubpà duma keniyu, ");
INSERT INTO mbbOT_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","te menge uyaǥen niw, wey te leew he menge langgam he zutun te tanè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","9","Dutun te kada ike-49 he tuig, te ikesepulù he andew te ikepitu he vulan he iyan kes Andew te Kebelukas te menge etew tenged te menge salè dan, ipezaǥing niw is menge vudyung diyà te tivuuk he lugar niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pekeveǥata niw is ike-50 he tuig, su timpu heini te kebeǥey te vayàbayà diyà te menge uripen su wey zan mekelikù en diyà te pemilya zan wey te ked-ulì diyà te teǥiǥaked te menge azen he ingkevelegyè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","12","Kayi he Tuig te Kebeǥey te Bayàbayà wey Ked-ulì, kenè kew pemula wey kenè kew zaan raǥun; kenè kew penrupù te menge veǥas te ulì, piru egkehimu he ebpenguwa kew para te egkeenen niw. Segradu heini he tuig para keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Kayi he tuig is azen he imbelegyà diyà te keniyu iulì niw ziyà te mibelegyà duen. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Umbe, emun ebelegyè kew etawa ebpemasa kew te tanà te zuma niw he meǥinged, kenè kew pelimlimbungà. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kinahanglan he is bali te tanà ibasi ziyà te nesamà he menge tuig he zutun ebpekeraǥun pa is nemasa su kenè pa egkeuma is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì te menge azen. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Emun mahabet pa is menge tuig ne human egkeuma is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì ne mahala niw is bali te tanà, iyan, emun hapit en egkeuma haazà ne veretuwa niw zà. Su is tutuu, kenà tanà is ebpemesahan, kekenà, iyan is kahabet te egkeraǥun puun dutun te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kenè kew mebpelimlimbungà, kekenà, tehuza a keniyu, is Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","19","Tumana niw is menge sulunuzen he ibpesunud ku wey menge suǥù su wey kew mekepengungubpaan he melinawen dutun te tanà he ed-ubpaan niw ne kenè kew egkeewaan te keenen tenged te kezekelà te menge abut niw puun te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kenè kew meseeng ke hengkey is egkekaan niw zutun te ikepitu he tuig he kenè kew ebpekepemula wey ebpekeraǥun. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Su edtuvazan ku is tanè niw zutun te ikeenem he tuig para zekelà is egkeraǥun puun duen ne ebpekesustinir te tetelu he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ne zutun te kebpemula niw te ikewalu he tuig, ne kemulu niw pa egkeena is neraǥun niw zutun te ikeenem he tuig, ne zekelè pa is keenen niw taman te tiraǥun te ikesiyam he tuig. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Kenè kew pekid-uyun he kenè niw en ibpahawì te minsan keenu is tanà he imbelegyà diyà te keniyu su heini he tanà kediey; ebpeubpaan ku zà wey ebpeseupan ku zà heini keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Umbe, ituǥut niw he mahawì te teǥiǥaked is tanè din puun keniyu. Beeli niw heini ziyà te langun he tanà he nepemasa niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Emun nepubri is duma niw he Israilihanen, he tenged dutun ingkevelegyè din is tanè din, is megeget he kezuzumahi zin iyan medlekat dutun. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Piru emun wazè din kezuzumahi he edlekat dutun para kandin, egkehimu ǥihapun he egkahawì din heini emun nekaamuy en sikandin te pelata he idlekat kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Emun egkehitavù heini, ne veyazi zin is nekepemasa te tanè din te vali he ibasi te kahabet te kedraǥun puun dutun te tanà taman te egkeuma is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì te azen, he egkehimu en he egkahawì din is tanè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Iyan, emun kenè pa ereg is idlekat din, ne kenè din pa haazà egkekuwa puun te nemasa taman te kegkeuma te Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. Dutun he tuig egkahawì din en is tanè din he wazà bayad. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Emun is sevaha he etew ebelegyà te valey zin he ziyà te inged he neliǥuy te verengbeng, egkehimu pa ke edlekaten din heini seled te senge-tuig, puun te timpu te kebelegyè din. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Piru emun kenè din heini egkelekat seled te senge-tuig, ne haazà he valey egkehimu en he ǥaked te nekepemasa zuen wey te menge kevuwazan din taman te taman. Kenè en heini egkahawì te teǥiǥaked dutun te Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Piru is menge valey ziyà te zezeisey he menge inged he wazè din berengbeng iring heini te vevesukà, he egkehimu he edlekaten wey egkahawì dutun te tuig te Kebeǥey te Bayàbayà wey Ked-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Is menge kevuwazan ni Levi egkehimu he edlekat minsan keenu te menge valey zan he ziyà te menge inged he ǥaked dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Emun kenè dan heini egkelekat, id-ulì heini ziyà te kandan dutun te Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. Su is baley ziyà te menge inged dan kandan he vahin puun te zuma zan he menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Piru is menge penebtavà he uvey te menge inged dan kinahanglan he kenà ibelegyà, su kandan haazà he azen taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Emun nepubri is duma niw he Israilihanen ne kenè en sikandin ebpekegaga he edsupurtar te keugelingen din, tevangi niw sikandin iring te kedtavang niw te langyew etawa meǥeliyug, su wey meuyag-uyag sikandin duma keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Ipesambey niw sikandin te selapì he kenà ibpetuvù, wey velegyai niw te keenen he kenè kew en egenansya, su wey sikandin meuyag-uyag. Beeli niw heeyan he paaǥi te kebpekilala te kedtehuza niw kedì te Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Iyan a kes Nengazen he Megbevayè niw he mibpeǥawas keniyu puun te Ehipto su wey ku ikeveǥey keniyu is tanà te Canaan ne wey a mehimu he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Emun nepubri is duma niw he Israilihanen, he tenged dutun ingkevelegyè din diyà te keniyu is keugelingen din pinaaǥi te kebpeuripen, kenè niw sikandin ibpeterebahu he iring te uripen. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Isipa niw sikandin he sevaha he sinuhulan he terebahanti etawa meǥeliyug he mid-ubpè dà duma keniyu. Edterebahu sikandin diyà te keniyu taman te egkeuma is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dutun he tuig ebpekevayèbayè en sikandin wey is menge anak din, ne ebpekelikù en sikandan diyà te menge kezuzumahi zan ne egkeuman dan en maan egkaangken is menge azen te menge kepuun dan. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Menge uripen ku sikiyu is menge Israilihanen he impeǥawas ku puun te Ehipto. Umbe kenè niw ivelegyà is keugelingen niw pinaaǥi te kebpeuripen. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kenè niw dèdaaǥa is iring niw he Israilihanen he mibpeuripen keniyu. Beeli niw heeyan te kebpekilala he edtehuzen a keniyu is Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Emun egkesuat kew he zuen niw menge uripen, ne pemasa kew ziyà te menge nasyun diyà te peliǥuy niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Egkehimu zaan ke ziyè kew ebpemasa te emurè niw te inged he kenà menge Israilihanen he mid-ubpà duma keniyu etawa ziyà te sakup te pemilya zan he neetew ziyà te keniyu he lugar. Is menge uripen he egkepemasa niw ziyà te kandan egkehimu en he azen niw, ");
INSERT INTO mbbOT_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ne egkehimu ke ibpepengevilin niw te menge anak niw, ebpekepenilbi sikandan kandan seled te tivuuk he untung dan. Piru kenè niw dèdaaǥa is iring niw he Israilihanen he nehimu he uripen niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Emun imbelegyà te sevaha he pubri he Israilihanen is keugelingen din pinaaǥi te kebpeuripen te emurù niw te inged he sepian he kenà Israilihanen etawa kezuzumahi zutun te kenè Israilihanen, ");
INSERT INTO mbbOT_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ne heeyan he Israilihanen egkehimu pa he edlekaten. Egkehimu sikandin he edlekaten te suled din, ");
INSERT INTO mbbOT_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","anggam din, id-aǥew zin, etawa minsan hentei he megeget he kezuzumahi zin. Egkehimu zaan ke iyan mismu sikandin edlekat te keugelingen din emun ebpekevaug sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","52","Is ereg he ebeelan din, ne belensiya zin duma te nekepemasa kandin ke pira en he tuig is kebpenilbi zin wey pira is ereg he ibayad kayi emun ebeyazan sikandin te iring te edhimuwen diyà te sevaha he sinuhulan he terebahanti. Ne itarin din dutun te kentidad is imbayad kandin dutun te kebpemesaha kandin he uripen. (Haazà he kentidad ibasi ziyà te kahabet te menge tuig puun te kebpemesaha kandin taman te Tuig te Kebeǥey te Bayàbayà wey Ked-ulì.) Ne ke pira is egkesamà, ne iyan haazà ebeyazan din para mevelukasi sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kinahanglan he ed-isipen sikandin te nemasa kandin he sevaha he sinuhulan he terebahanti ne kenè din dèdaaǥa. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Emun kenà sikandin egkelekat te iring kayi he paaǥi, egkelibri ǥihapun sikandin wey is menge anak din dutun te Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Umbe, wazà keniyu egkeuripen taman te taman, su menge uripen ku sikiyu, sikiyu is imbpeǥawas ku puun te Ehipto. Iyan a kes Nengazen he Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Kenè kew mebaal te menge ed-ezapen iring te ledawan, tedeman he vatu, etawa mibpurma he vatu, he ed-ezapen niw, su iyan a is Nengazen Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Tumana niw is ebpeveelan ku keniyu zutun te Andew te Kedhimeley wey tehuza niw is lugar he zutun a keniyu ed-ezapa. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Emun edtumanen niw is menge sulunuzen he ibpesunud ku wey menge suǥù ku, ");
INSERT INTO mbbOT_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ebpeuzanan ku sikiyu zutun te hustu he timpu su wey mebeǥey te sebpet is tanà ne ebpekepemeǥas is menge kayu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Egkehimu he utew zekelà is sebpet niw ne minsan is timpu te kegunas niw te menge pungu ebpekeuma pa taman te kebpenrupù te beǥas te menge paras, ne is timpu te kebpenrupù niw te beǥas te paras ebpekeuma pa te timpu te kebpemula niw. Umbe ebpekevayèbayè kew te kegkaan niw ne ebpekepengungubpaan kew pa he melinawen diyà te lugar niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Edhimuwen ku he melinew is lugar niw, umbe ebpekelipezeng kew he wazè niw igkahandek. Edsegseǥen ku is dumezaas he menge langgam, wey wazà menge kuntada he edsurung keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Iyan kew edsurung te menge kuntada niw ne ebpenhimetayan niw sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Is 5 keniyu ebpekezaag te 100 ne is 100 keniyu ebpekezaag te 10,000. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ed-eturen ku sikiyu ne ebeǥayan ku te mahabet he menge kevuwazan su wey ku metuman is kebpekid-uyun ku keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Tenged te kezekelà te menge abut niw, kenè niw pa egkaamin te egkaan is egkehuna he menge abut niw, ne igkaawà niw zà heini ziyà te midteǥuan niw zuen su ed-ilisan niw te veǥu he sebpet. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ed-ubpà a zuma keniyu ne kenè ku sikiyu idselikwey. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Eduma a keniyu ne iyan a egkehimu he Megbevayè niw ne ebpedayun is kegkehimu niw he menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Iyan a kes Nengazen he Megbevayè niw he mibpeǥawas keniyu puun te Ehipto su wey kew kenè en meuripen te menge Ehiptohanen. Mibeǥayan ku en sikiyu te vayàbayà umbe wazè en ereg he igkeeled niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","15","Piru emun kenè kew ebpemineg kedì etawa kenè kew edtuman te langun he menge suǥù ku wey menge sulunuzen, ne tenged kayi egkesupak niw is kebpekid-uyun ku keniyu, ");
INSERT INTO mbbOT_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","iyan heini ebeelan ku keniyu: Egketeranta kew te kegkahandek su ebpeeǥiyan ku sikiyu te menge zaru he kenà egkeulian wey dateng he ebpekezezaat te menge mata niw wey menge lawa niw. Ebpemula kew ne kenà heini ebpulus diyà te keniyu su edsurungen kew te menge kuntada niw ne egkeenen dan is menge abut niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Egkuntedahan ku sikiyu para mezaag kew te menge kuntada niw ne iyan sikandan edumala keniyu. Tenged te kegketeranta niw ne ebpelaǥuy kew minsan wazà edal-as keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ne emun kenè kew pa ebpemineg kediey, ne edsilutan ku sikiyu te kepipitu edtekepa. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Edhimuwen ku he kenà medlampus is gehem he ibpahambug niw; ne kenè ku sikiyu ebpeuzanan, umbe ebpurung ebadtik is menge tanè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Egkehimu he wazà pulus te menge kedhaǥù niw, su is menge tanè niw, kenà ebeǥey te sebpet ne is menge kayu niw ne kenà ebpemeǥas. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Emun ebpedayun kew pa ǥihapun he edsupak kediey su kenè kew ebpemineg kediey, ed-umanan ku pa te kepipitu en maan egketakep he silut keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Edsuǥuen ku ziyà te keniyu is dumezaas he menge langgam ne ebpenhimetayan dan is menge anak niw wey menge uyaǥen niw, ne tenged kayi zeisey zà is egkesamà keniyu he henduen be te wazè en edhiphipanew ziyà te menge zalan niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ne emun kenè kew pa ǥihapun ebpemineg kediey, su ebpedayun kew hinuun te kedsupak kedì, ");
INSERT INTO mbbOT_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","iyan a mismu egkuntra keniyu ne ebpurungan ku sikiyu edsiluti. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ibpesurung ku sikiyu te menge kuntada niw he iyan silut niw tenged te kedsupak niw te kebpekid-uyun ku keniyu. Minsan med-eles kew pa ziyà te inged niw ebpeeǥiyan ku ǥihapun sikiyu te menge kemeresayan, ne tenged dutun egkepeǥes kew he ebpezizalem te gehem te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Egkurang is keenen niw, umbe sevaha zà he evuwan is egemiten te sepulù he vahi te kedlutù te supas, ne ebevehinen dan pa heini para keniyu. Uya, ebpekekaan kew piru kenè kew egkahantey. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ne emun kenè kew pa ǥihapun ebpemineg kediey su ebpedayun kew hinuun te kedsupak kedì, ");
INSERT INTO mbbOT_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ne tenged te pauk ku egkuntrahan ku sikiyu ne edsilutan ku sikiyu te pitu pa maan he takep. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ebpeeǥiyan ku sikiyu te vitil ne egkepeǥes kew he egkaan te keugelingen niw he menge anak. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Edrundusen ku is menge simbahan niw ziyà te metikang he menge lugar ragkes is menge pemuhatà he tutungà te veyewà. Ne idtimbag ku sikiyu is ebpematey ziyà te zivavew te kenà egeǥehinawa he menge ed-ezapen, ne idselikwey ku sikiyu. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ebengkaǥen ku is menge inged niw wey menge simbahan niw, ne kenà ebpekepenunuat kedì is hemut te menge pemuhat niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ebengkaǥen ku is lugar niw ne egkeinuinu zà is menge kuntada niw he edsakup kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ebpeeǥiyan ku sikiyu te tebek he edezaat te tanè niw ragkes en is menge inged kayi, ne ibpeyapat ku sikiyu ziyà te zuma he menge nasyun, ne egkehimu he mekevulungbulung is tanè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Dutun te menge vihag kew ziyà te lugar te menge kuntada niw ne egkevengkag is lugar niw, ne ebpekehimeley is tanè niw. Su zutun te ed-ubpè kew pa zutun te tanè niw ne wazè niw heini ipehimeley minsan dutun te tuig te kebpehimelaya te tanà. Piru zutun he timpu human en heini ebpekehimeley zutun te wazè en kayi ed-ubpa. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","Sikiyu is egkengesamà te tebek he ed-uwiten te menge kuntada niw ziyà te kandan he menge lugar, edterenteduwen ku, ne minsan daǥing dà te menge zahun he egkeremaǥen ebpemelaǥuy kew en he henduen be te edel-asen te edhimatey keniyu, minsan wazà edal-as keniyu. Ne ebpekedsusukung kew is egkengepiley. Umbe kenè kew ebpekesukul te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ebpematey kew ziyà te lugar te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Is egkesamà keniyu ednaneynaney ebpematey tenged te menge salè niw wey te menge salà te menge kepuun niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","Tenged te kedluivi wey kedsupaka niw kediey egkuntedahan ku sikiyu ne ibpevihag ku pehendiyà te lugar te menge kuntada niw. Iyan, emun ed-engkezan niw is menge salè niw wey menge salà te menge kepuun niw wey ed-engkezan niw en is ke bmesinupaken niw, wey edewaten niw is silut tenged te menge salè niw, ");
INSERT INTO mbbOT_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","edtumanen ku is kebpekid-uyun ku te menge kepuun niw he si Abraham, si Isaac, wey si Jacob ne idlikù ku sikiyu ziyà te tanè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Piru kinahanglan he ibpaawè ku zèpa sikiyu puun te tanè niw he iyan bayad niw te menge salè niw, tenged te kedselikwaya niw te menge suǥù ku wey menge sulunuzen he ibpesunud ku. Ne ebpekehimeley is tanà dutun te egkeewaan niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Piru minsan edsilutan ku sikiyu, ne kenè ku sikiyu idselikwey ziyà te lugar te menge kuntada niw; kenè ku sikiyu edezeetan he wazè en egkesamà keniyu. Ne kenà egkehimu he id-awè ku is kebpekid-uyun ku keniyu, su iyan a is Nengazen Megbevayè niw. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Edtumanen ku ziyà te keniyu is kebpekid-uyun ku te menge kepuun niw he impeǥawas ku puun te Ehipto su impeehè ku ziyà te menge nasyun is gehem ku. Mibeelan ku heini ziyà te menge kepuun niw su para siak is Nengazen mehimu he Megbevayè dan. Iyan a kes Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Iyan heeyan sikan is nekedseselekawà he menge suǥù wey menge sulunuzen he imbeǥey te Nengazen diyà te menge Israilihanen diyà te Buntud he Sinai pinaaǥi ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","he keǥiya zin heini ziyà te menge Israilihanen: Emun is sevaha he etew inhalad diyà te Nengazen su ingkepenaad he idhalad, heeyan he penaad ");
INSERT INTO mbbOT_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","emun ebeyazan is bali zin te ziyà ibasi is keveǥat din te timbangan he egemiten te menge memumuhat: is ebpenuiǥen te senge vulan pehendiyà te heepat he tuig maama: 5 he vuuk he pelata bahi: 3 he vuuk he pelata is ebpenuiǥen te 5 he tuig pehendiyà te 19 maama: 20 he vuuk he pelata bahi, 10 he vuuk he pelata is ebpenuiǥen te 20 he tuig pehendiyà te 59 maama: 50 he vuuk he pelata bahi: 30 he vuuk he pelata is ebpenuiǥen te 60 he tuig pehendiyà te metikang maama: 15 he vuuk he pelata bahi: 10 he vuuk he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Emun pubri is nekepenaad ne kenà sikandin ebpekevaug he ebayad dutun he kentidad, ne uwita zin diyà te memumuhat sikan is etew he impenaad din he idhalad din diyà te Nengazen, ne iyan egkaǥi haazà is memumuhat te vali he egkevaug dutun te etew te ebayad. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Emun iyan impenaad din is uyaǥen he egkehimu he ibpemuhat diyà te Nengazen, heeyan he uyaǥen egkehimu en he gaked te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kinahanglan he kenè din en heini liwai te selakew en he uyaǥen, minsan pa ke edhuna he meupiya is idliwà etawa edliwaan. Emun ebeelan din heini ne sikan is uyaǥen he impenaad din wey sikan is uyaǥen he idliwè din ne pudu egkehimu he ǥaked te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Emun iyan impenaad din is meremerik he uyaǥen he kenà egkehimu he ibpemuhat diyà te Nengazen, ne uwita zin diyà te memumuhat haazà is uyaǥen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ne edsusiyen heini zutun te memumuhat ke meupiya ve wey ke kenà, ne ebeliyan din heini te vali he kenè en egkahalinhalin. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Emun edhewien dutun te teǥiǥaked haazà is uyaǥen kinahanglan he ebeyazan din haazà is prisyu te uyaǥen ne umani zin pa te 20 pursintu is bali kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Emun inhalad te etew is baley zin diyà te Nengazen, ne edsusiyen te memumuhat haazà is baley ke meupiya pe be wey ke kenè en, ne ebeliyan din heini te vali he kenè en egkahalinhalin. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Emun edhewien te teǥiǥaked haazà is baley, kinahanglan he ebeyazan din is prisyu zutun te valey ne umani zin pa te 20 pursintu is bali kayi. Ne idlikù diyà te kandin haazà is baley. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Emun inhalad te etew ziyà te Nengazen is bahin te tanè din he nepengevilin din puun te menge kepuun din, ebeliyan heini te memumuhat te vali he ibpesikad te kezekelà te venì he igkepemula zutun te tanà: is kada egkepemulaan te liwazà te saku he venì ne iyan bali zin is 20 he vuuk he pelata. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Emun inhalad din is bevesukè din dutun te sikan pa meipus is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì, is bali kayi ne iyan ded. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Iyan emun neuǥet en is kegkeliwas dutun he tuig ne human din heini ihalad, ebeliyan heini te memumuhat te vali he mevavà dutun, sumalà te kahabet te menge tuig he nesamà he egkeume en maan is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Emun edhewien te teǥiǥaked haazà is bevesukè din, kinahanglan he ebeyazan din is bali kayi te vevesukà ne umani zin pa te 20 pursintu haazà is bali kayi. Ne id-uli diyà te kandin haazà is bevesukà. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Iyan, emun ibelegyè din haazà is bevesukà dutun te wazè din pa melekat, ne kenè din en haazà egkahawì. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ne emun egkeume en maan is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì, ne ǥaked en heini te Nengazen ne kenè en heini egkahawì, egkehimu en heini he azen te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Emun inhalad te etew is bevesukà he nepemasa zin, ");
INSERT INTO mbbOT_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ne ebeliyan heini te memumuhat te vali he ibasi ziyà te kahabet te menge tuig he human egkeuma is Tuig te Kebeǥey te Bayàbayà wey Ked-ulì. Kinahanglan he segugunà heini edlekata. Is bayad he idlekat din kayi gaked en te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Dutun he Tuig te Kebeǥey te Bayàbayà wey Ked-ulì, haazà he tanà id-ulì diyà te teǥiǥaked he mibelegyà duen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Is langun he prisyu te menge inhalad diyà te Nengazen kinahanglan he ziyà ibpesikad te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Is egkehuna he anak te uyaǥen ne ǥaked te Nengazen, umbe kenè en heini kinahanglan he idhalad diyà te kandin su zaan he kandin. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Emun meremerik haazà he uyaǥen, ne egkehimu he edlekaten te teǥiǥaked. Beyazi zin is bali zutun te uyaǥen ne umani zin pa haazà is bali zin te 20 pursintu. Ne emun kenè din heini edlekaten ne ibelegyà heini te menge memumuhat sumalà te imbali kayi. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Kenà egkehimu he ibelegyà etawa edlekaten is minsan hengkey he azen he kenè en duwazuwa is kedhelaza zuen diyà te Nengazen, etew man etawa uyaǥen etawa tanà he nepengevilin. Gaked en heini he Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Is etew he kenà duwazuwa is kedhelaza zuen diyà te Nengazen kenà egkehimu he edhewien. Kinahanglan heini he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Is ikesepulù he vahin te langun he menge sebpet, ne ǥaked te Nengazen ");
INSERT INTO mbbOT_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","emun edhewien te etew is ikesepulù he vahin te sebpet, kinahanglan he ebeyazan din is bali kayi ne umani zin pa haazà is bali te 20 pursintu. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Emun ebilang kew te vaka niw, kerehidu niw, etawa kambing niw, is ikesepulù kayi iveǥey niw ziyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Kinahanglan he kenè niw heini pilia etawa liwai. Emun edliwaan niw heini, ne haazà is uyaǥen he edliwaan niw wey haazà is idliwè niw, ne pudu egkehimu he ǥaked te Nengazen ne kenè en heini egkehimu he edhewien. ");
INSERT INTO mbbOT_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Iyan heeyan menge suǥù he imbeǥey te Nengazen ki Moises diyà te Buntud he Sinai he para te menge Israilihanen.");
INSERT INTO mbbOT_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Hein nehuna he andew te ikezuwa he vulan, dutun te ikezuwa he tuig te ked-awà te menge Israilihanen diyà te Ehipto, migkaǥi is Nengazen diyà te ki Moises diyà te Tulda he Edtelevukaayan he ziyà te sibsivayan he Sinai te, ");
INSERT INTO mbbOT_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Sinsusa niw is kada kezuzumahi wey pemilya te tivuuk he keet-etawan te Israel. Ilista niw is menge ngazan te langun he menge maama ");
INSERT INTO mbbOT_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","4","he ebpenuiǥen te 20 he tuig pehendiyà te metikang he egkehimu en he edsunderuwen. Iyan kew ki Aaron dumala te kedsinsus ne peuǥup kew te pengulu te kada tribu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Iyan heini menge pengulu te kada tribu he ebpekeuǥup keniyu: Ngazan te Tribu; Ngazan te Pengulu Reuben; Elizur he anak ni Shedeur Simeon; Shelumiel he anak ni Zurishadai Juda; Nashon he anak ni Aminadab Isacar; Netanel he anak ni Zuar Zebulun; Eliab he anak ni Helon Efraim he anak ni Jose; Elishama he anak ni Amihud Manase he anak ni Jose; Gamaliel he anak ni Pedazur Benjamin; Abidan he anak ni Gideoni Dan; Ahiezer he anak ni Amishadai Asher; Pagiel he anak ni Ocran Gad; Eliasaf he anak ni Deuel Naftali; Ahira he anak ni Enan ");
INSERT INTO mbbOT_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Iyan haazà sikandan menge pengulu ziyà te menge tribu he nengepilì puun te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Ne impetiǥum ni Moises wey ni Aaron duma kayi te menge pengulu is langun he menge Israilihanen dutun mismu he andew. Impenlista zan is langun he menge maama he ebpenuiǥen te 20 pehendiyà te metikang sumalà te kada kezuzumahi wey is menge pemilya zutun. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Mibeelan ni Moises heini is kebpenlista ziyà te sibsivayan he Sinai, su iyan haazà insuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Iyan heini kezakel te menge maama he 20 he tuig is keǥurang dan pehendiyà te metikang he egkehimu en he edsunderuwen, he ingkelista ziyà te kada tribu wey pemilya: Ngazan te Tribu; Kahabet Reuben (kes kinekekayan he anak ni Jacob); 46,500 Simeon; 59,300 Gad; 45,650 Juda; 74,600 Isacar; 54,400 Zebulun; 57,400 Efraim (he anak ni Jose); 40,500 Manase (he anak ni Jose); 32,200 Benjamin; 35,400 Dan; 62,700 Asher; 41,500 Naftali; 53,400 ");
INSERT INTO mbbOT_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","45","Iyan haazà kezakel te menge maama he nevilang ni Moises wey ni Aaron wey te 12 he menge pengulu te menge Israilihanen. Is kada sevaha kandan ingkelista ziyà te listahan te tribu zan wey pemilya zan. Ebpenuiǥen sikandan te 20 pehendiyà te metikang he egkehimu en he edsunderuwen. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Is kinetivuukan te kezakel zan, 603,550 sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Wazà iragkes kayi is menge kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Su migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kenè niw iragkes te edsinsus is tribu ni Levi duma te zuma he menge Israilihanen he ebpenirbisyu emun timpu te tebek. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kekenà, iveǥey kandan he ketengdanan is kedumala zuen te Tulda he Ed-ezapan he zutun itaǥù sikan is Kesuǥuan, wey is langun he ǥelemiten kayi. Iyan sikandan ed-uwit dutun te Tulda wey te langun he ǥelemiten kayi. Kinahanglan he ed-etimanen dan heini, ne kinahanglan he ziyè dan megkampu te ebpekeliǥuy kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Emun idhalin haazà is Tulda, iyan sikandan ebaal kayi, ne emun ed-umanan ebenguna heini, ne iyan dan gihapun ebangun kayi. Ne is minsan hentei he kenà kevuwazan ni Levi he ebaal kayi he vuluhaten, ne edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Kinahanglan he ebpeem-emurà te egkempuwan is kada tribu te menge Israilihanen, ne mebpehitindeg te bendira is kada tribu. ");
INSERT INTO mbbOT_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Piru is menge kevuwazan ni Levi, kinahanglan he ziyà megkampu te ebpekeliǥuy zuen te Tulda he midteǥuan te Kesuǥuan, su wey ku kenà mepeuki is menge etew te Israel. Ketengdanan te menge kevuwazan ni Levi is ked-atur zuen te Tulda.” ");
INSERT INTO mbbOT_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mibeelan heini is langun te menge Israilihanen sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Migkeǥiyan te Nengazen si Moises wey si Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ipekampu niw is kada tribu te Israel ziyà te zizalem te bendira te kada tribu zan. Ne ziyà ibpelastar sikan is Tulda he Edtelevukaayan te teliwazè dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","Is tribu ni Juda, Isacar, wey ni Zebulun diyà megkampu te zapit te edsilaan, diyà te dizalem te bendira te kada tribu zan. Iyan heini ngazan te menge pengulu zan wey kahabet te menge sakup dan: Tribu; Pengulu; Kahabet Juda; Nashon he anak ni Aminadab; 74,600 Isacar; Netanel he anak ni Zuar; 54,400 Zebulun; Eliab he anak ni Helon; 57,400 ");
INSERT INTO mbbOT_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ne 186,400 langun is kehabet kayi he grupu he ebpenguluwan te tribu ni Juda. Iyan heini sikandan grupu he edhuna emun edhipanew is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Is tribu ni Reuben, ni Simeon, wey ni Gad, ne ziyà megkampu te zapit te zivavà, diyà te zizalem te bendira te kada tribu zan. Iyan heini menge ngazan te menge pengulu zan wey kahabet te menge sakup dan: Tribu; Pengulu; Kahabet Reuben; Elizur he anak ni Shedeur; 46,500 Simeon; Shelumiel he anak ni Zurishadai; 59,300 Gad; Eliasaf he anak ni Deuel; 45,650 ");
INSERT INTO mbbOT_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ne 151,450 langun is kahabet kayi he grupu he ebpenguluwan te tribu ni Reuben. Iyan sikandan edtinundug te grupu ni Juda emun edhipanew is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Is edtinundug kandan iyan is tribu ni Levi he ed-uwit duen te Tulda he Edtelevukaayan. Is langun he tribu kinahanglan he ebpetuntunduǥà emun edhipanew sikandan, iring te kebplastar zan emun ke egkampu zan, he ziyà te dizalem te bendira he neketukid te kada tribu zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Is tribu ni Efraim, Manase, wey ni Benjamin, ne ziyà megkampu te zapit te edsenlepan, diyà te zizalem te bendira te kada tribu zan. Iyan heini menge ngazan te menge pengulu zan wey kahabet te menge sakup dan: Tribu; Pengulu; Kahabet Efraim; Elishama he anak ni Amiud; 40,500 Manase; Gamaliel he anak ni Pedazur; 32,200 Benjamin; Abidan he anak ni Gideoni; 35,400 ");
INSERT INTO mbbOT_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ne 108,100 langun is kahabet kayi he grupu he ebpenguluwan te tribu ni Efraim. Edtundug sikandan te tribu ni Levi emun edhipanew is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Is tribu ni Dan, ni Asher, wey ni Naftali ne ziyà megkampu te zapit te zizaya, ziyà te zizalem te bendira te kada tribu zan. Iyan heini menge ngazan te menge pengulu zan wey kahabet te menge sakup dan: Tribu; Pengulu; Kahabet Dan; Ahiezer he anak ni Amishadai; 62,700 Asher; Pagiel he anak ni Ocran; 41,500 Naftali; Ahira he anak ni Enan; 53,400 ");
INSERT INTO mbbOT_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ne 157,600 langun is kahabet kayi he grupu he ebpenguluwan te tribu ni Dan. Iyan sikandan diyà te kinehuziyanan emun edhipanew is menge Israilihanen. Edhipanew zan diyà te zizalem te bendira zan he neketukid te kada tribu zan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Is kinetivuukan he kahabet te menge Israilihanen he ingkelista ziyà te kada tribu, 603,550 langun. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ne wazà kayi meragkes is menge kevuwazan ni Levi, su wazà sikandan iragkes te ebilang sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Midsunud te menge Israilihanen is langun he insuǥù te Nengazen ki Moises: is kada tribu migkampu wey midhipanew he zizalem te kada bendira te tribu zan he neketukid te kada tribu wey pemilya zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iyan heini keguǥuza mehitenged te menge kevuwazan ni Aaron wey ni Moises he ingkesurat hein timpu te kebpekidlalag te Nengazen ki Moises diyà te Buntud he Sinai. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Is menge anak ni Aaron iyan ensi Nadab, Abihu, Eleazar, wey si Itamar. Iyan kakey si Nadab. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mibpilì wey mid-urdinahan sikandan wey zan mekepenilbi pinaaǥi te kegkememumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Piru si Nadab wey si Abihu, minatey ziyà te etuvangan te Nengazen hein migamit dan te hapuy he kenà iyan sikan is hapuy he para te kebpemuhata te Nengazen hein diyè dan te sibsivayan he Sinai. Minatey sikandan he wazè dan menge anak, umbe iyan dà si Eleazar wey si Itamar nenilbi pinaaǥi te kegkememumuhat dutun te kaazen pa te amey zan he si Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ipetawag nu is tribu ni Levi ne zumaha nu ziyà te ki Aaron he memumuhat su wey zan mekeuǥup kandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ebpenilbi zan ki Aaron wey te langun he menge etew te Israel pinaaǥi te kebaal te menge vuluhaten diyà te Tulda he Ed-ezapan he egngezanan daan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Iyan daan sikandan ed-atur te langun he menge gelemiten duen te Tulda he Edtelevukaayan, ne ebpenilbi zan dutun te Tulda para te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ebpeveyveyaan ki Aaron wey ziyà te menge anak din he maama is menge kevuwazan ni Levi su wey metevangi sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Iyan, himuwa nu he memumuhat si Aaron wey is menge anak din. Is minsan hentei he ebaal te vuluhaten te memumuhat diyà te Tulda he Ed-ezapan he kenà kevuwazan ni Levi ne ereg he edhimetayan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Migkaǥi pa is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Mibpilì ku is menge kevuwazan ni Levi he liwan te menge kinekekayan he anak he menge maama te menge Israilihanen. Kediey is kada kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Su kediey man is langun he kinekekayan he maama kayi te Israel. Hein mibpenhimetayan ku is langun he kinekekayan he maama ziyà te Ehipto, ne intapid ku en he para kedì is langun he kinekekayan he maama kayi te Israel, etew etawa uyaǥen. Umbe ǥaked ku sikandan. Iyan a kes Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Migkeǥiyan te Nengazen si Moises diyà te sibsivayan he Sinai te, ");
INSERT INTO mbbOT_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bilanga nu is menge kevuwazan ni Levi he menge maama sumalà te pemilya zan. Bilanga nu is senge vulan is keǥurang din pehendiyà te metikang.” ");
INSERT INTO mbbOT_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Umbe, mibilang sikandan ni Moises sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Iyan heini menge anak ni Levi: si Gershon, si Kohat, wey si Merari. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Is menge anak ni Gershon iyan si Libni wey si Shimei. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Is menge anak ni Kohat iyan ensi Amram, Izhar, Hebron, wey Uziel. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Is menge anak ni Merari iyan ensi Mali wey Mushi. Iyan sikandan menge kevuwazan ni Levi he inlista sumalà te menge pemilya zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Is menge kevuwazan ni Gershon iyan kes menge pemilya he ebpuun diyà te ki Libni wey ki Shimei. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Is kahabet te menge maama kandan he is keǥurang dan senge vulan pehendiyà te metikang ne 7,500. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Is lugar he egkempuwan dan ne ziyà dapit te egkeiniyuǥan duen te Tulda he Ed-ezapan, he ziyà te zapit te edsenlepan duen te tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Is pengulu zan iyan si Eliasaf he anak ni Lael. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Iyan sikandan midseriǥan te ked-atur te menge gelemiten duen te Tulda he Edtelevukaayan he iyan heini: menge tambun, is kurtina te gemawan te Tulda, ");
INSERT INTO mbbOT_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","is menge kurtina ziyà te lama he impeliǥuy zuen te Tulda wey pemuhatà, ragkes en is kurtina te pultahan duen te lama, wey is menge hiket kayi. Kandan he ketengdanan is langun he vuluhaten he para kayi he menge gelemiten. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Is menge kevuwazan ni Kohat iyan sikan is menge pemilya eni Amram, Izhar, Hebron, wey Uziel. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Is kahabet te menge maama kandan he is keǥurang dan senge vulan pehendiyà te metikang ne 8,600. Insarig daan kandan is ked-atur zuen te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Is lugar he egkempuwan dan ne ziyà dapit te zivavà duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ne iyan pengulu zan si Elizafan he anak ni Uziel. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Iyan sikandan daan midseriǥan te ked-atur te menge himan duen te Tulda he Edtelevukaayan he iyan is: Kavan te Kebpekid-uyun, lemisahan, selevukà te sulù, menge pemuhatà, menge gelemiten he egemiten te menge memumuhat emun ebaal zan te vuluhaten dan, wey zuen te kurtina ziyà te seled te Tulda. Kandan he ketengdanan is langun he vuluhaten he egkeǥemitan kayi he menge gelemiten. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Is pengulu te menge kevuwazan ni Levi iyan si Eleazar he anak ni Aaron he memumuhat. Iyan sikandin mibpilì he edumala zuen te menge etew he insarig kandan is ked-atur zuen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Is menge kevuwazan ni Merari iyan is menge pemilya he ebpuun diyà te ki Mali wey ki Mushi. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Is kahabet te menge maama kandan he is keǥurang dan senge vulan pehendiyà te metikang ne 6,200. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Is pengulu zan iyan si Zuriel he anak ni Abihail. Is lugar he egkempuwan dan ne ziyà te egkezizaya zuen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Iyan sikandan midseriǥan te ked-atur te tabla he elavat duen te Tulda, menge marku, menge tukud, wey menge pundasyun kayi. Kandan he ketengdanan is langun he menge vuluhaten he egkeǥemitan kayi he menge gelemiten. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Iyan daan sikandan midseriǥan te ked-atur te menge tukud diyà te ǥawas duen te lama wey te menge pundasyun kayi, menge palpal wey menge hiket kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Si Moises wey si Aaron wey is menge anak din, ne ziyè dan megkampu zapit te egkesineruwan duen te Tulda he Edtelevukaayan he zapit te edsilaan. Iyan sikandan midseriǥan te kedumala te menge vuluhaten duen te Tulda he para te menge Israilihanen. Is minsan hentei he ebaal te vuluhaten te memumuhat dutun te Tulda he kenà kevuwazan ni Levi ereg he edhimetayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Is kahabet te langun he menge maama he kevuwazan ni Levi he is keǥurang dan senge vulan pehendiyà te metikang ne 22,000. Si Moises wey si Aaron is mibilang kandan sumalà te insuǥù te Nengazen kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Migkaǥi is Nengazen diyà te ki Moises te, “Bilanga nu wey ilista is menge ngazan te langun he kinekekayan he menge anak he maama te menge Israilihanen he is keǥurang dan senge vulan pehendiyà te metikang. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ipehinungud niw kayi te kedì is menge kevuwazan ni Levi he ilis te langun he kinekekayan he maama he menge anak te menge Israilihanen. Ipehinungud niw zaan kayi te kedì is menge uyaǥen te menge kevuwazan ni Levi he ilis te langun he kinekekayan he menge uyaǥen te menge Israilihanen. Iyan a Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","43","Umbe, mibilang ni Moises is langun he kinekekayan he menge maama he menge anak te menge Israilihanen he is keǥurang dan senge vulan pehendiyà te metikang, sumalà te insuǥù te Nengazen kandin. Is kahabet dan nekeuma te 22,273. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","45","Migkaǥi pa is Nengazen diyà te ki Moises te, “Ipehinungud niw kayi te kedì is menge kevuwazan ni Levi he ilis te langun he kinekekayan he menge anak he maama te menge Israilihanen. Ipehinungud niw zaan is menge uyaǥen te menge kevuwazan ni Levi he ilis te kinekekayan he menge uyaǥen te menge Israilihanen. Kediey is menge kevuwazan ni Levi. Iyan a Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Geina te midsubra te 273 is kinekekayan he maama he menge anak te menge Israilihanen kenà te menge kevuwazan ni Levi, kinahanglan he edlekaten sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ne para melekat sikandan, kinahanglan he ebeyazan is kada sevaha kandan te lelima he vuuk he pelata he ibpesikad diyà te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ne ibeǥey nu haazà diyà te ki Aaron wey te menge anak din is selapì he idlekat te nenubra he menge kinekekayan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Umbe, migkulikta ni Moises is selapì he idlekat te menge kinekekayan he menge anak te menge Israilihanen he midsubra te kahabet te menge kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Is nekulikta zin 1,365 he vuuk he pelata, he impesikad diyà te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ne imbeǥey zin heini ziyà te ki Aaron wey ziyà te menge anak ni Aaron he menge maama sumalà te insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Migkeǥiyan te Nengazen si Moises wey si Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Sinsusa niw is menge kevuwazan ni Kohat he sakup te tribu ni Levi; sinsusa is kada kezuzumahi wey is menge pemilya zutun. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Bilanga niw is langun he maama he is penuiǥen dan 30 pehendiyà te 50 he tuig, he ebpekehimu he ebpenilbi ziyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Is buluhaten te menge kevuwazan ni Kohat diyà te Tulda he Edtelevukaayan iyan is ked-atur te utew segradu he menge vutang. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Emun ed-awè kew zutun te kampu niw, kinahanglan he edseled si Aaron wey is menge anak din duen te Tulda ne egkuwaan dan is kurtina ziyà te seled, ne idtambun dan heini zuen te Kavan te Kebpekid-uyun. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ne kegkepasad dutun, ed-umanan dan pa heini edtembuni te meupiya he kelasi he lundis wey manggad he meitem is kaavuavu zin, ne idtaud dan is menge tival kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Tembuni zan daan te manggad he meitem is kaavuavu zin is lemisahan he selevukà te supas he ibpemuhat diyà te etuvangan te Megbevayà, ne isavuk dan dutun te lemisahan is menge pinggan, menge tasa, menge yahung, menge tivud he teleǥuey te pemuhat he inumen, wey menge supas he layun dutun te lemisahan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ne kegkepasad dutun edtembunan dan heini te manggad he kanggan, ne ed-umanan dan pa heini edtembuni te meupiya he kelasi he lundis, ne idtaud dan is menge tival kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Is selevukà te sulù edtengesen dan te manggad he meitem is kaavuavu zin ragkes en is menge sulù dutun, menge lipit, menge taya te igmuk te pebilu te sulù, wey menge tivud he teleǥuey te lana he idtubil te sulù. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Edtengesen dan heini is langun te meupiya he kelasi he lundis, ne ibpikit dan duen te tival. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Tembuni zan daan te manggad he meitem is kaavuavu zin sikan is pemuhatà he vulawan ne edtembunan dan pa heini te meupiya he kelasi he lundis, ne itaud dan is menge tival para kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Is duma pa he menge gelemiten he egemiten te kebpenilbi zutun te Tulda, edtengesen daan te manggad he meitem is kaavuavu zin wey te meupiya he kelasi he lundis, ne ibpikit heini zuen te tival. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Kinahanglan he id-awè dan is avu zuen te pemuhatà, ne edtembunan heini is pemuhatà te manggad he merudtem. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ne isavuk dan kayi te pemuhatà is langun he ǥelemiten para kayi: is menge selevukà te vaǥa, is dezekelà he menge tinidur he para te usa, is menge pala, wey is menge yehung. Ne tembuni zan heini te meupiya he kelasi he lundis, ne itaud dan is menge tival kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Emun egkepasad en ni Aaron wey te menge anak din te edtambun sikan is Tulda he Edtelevukaayan wey is langun he menge gelemiten kayi, ne edtivalen heini te menge kevuwazan ni Kohat dutun te timpu te ked-awè niw puun te kampu niw. Piru kinahanglan he kenè dan semsama heini is segradu he menge vutang su wey zan kenà mebpatey. “Iyan haazà sikan is menge gelemiten duen te Tulda he Edtelevukaayan he ed-uwiten te menge kevuwazan ni Kohat. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Si Eleazar he anak ni Aaron he memumuhat, kandin he ketengdanan is bahin duen te lana he para te menge sulù, menge veyewà, kada andew he pemuhat he para gasa, wey is lana he para te idlana. Iyan sikandin edumala te vuluhaten para zutun te tivuuk he Tulda wey te langun he menge gelemiten kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kenè niw pesegdana he mepuew is kevuwazan ni Kohat puun te menge Levihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Iyan heini veeli niw para kenà sikandan mebpematey emun ed-uvey sikandan duen te utew segradu he menge vutang: Kinahanglan he eduma kandan si Aaron wey is menge anak din emun edseled dan duen te Tulda ne egkeǥiyen diyà te kandan ke hengkey is ereg he ebeelan dan wey kinahanglan he ed-uwiten dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Su emun kenà sikandan edumahan, kenè dan medseled te ked-ahà te segradu he menge vutang minsan meǥaan dà, su wey zan kenà mebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Sinsusa nu zaan is menge kevuwazan ni Gershon sumalà te pemilya zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bilanga nu zaan is langun he maama kandan he is penuiǥen dan 30 pehendiyà te 50 he tuig, he ebpekehimu te kebaal te menge vuluhaten diyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Is buluhaten te menge kevuwazan ni Gershon iyan is ked-uwit kayi he menge vutang: ");
INSERT INTO mbbOT_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","menge kurtina zuen te Tulda he Ed-ezapan, (egngezanan daan te Tulda he Edtelevukaayan), is langun he menge tambun he para idtambun kayi, wey is menge kurtina te ǥemawan, ");
INSERT INTO mbbOT_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","is menge kurtina zuen te lama he nekepeliǥuy zuen te Tulda wey pemuhatà, is kurtina ziyà te ǥemawan te lama, is menge hiket, wey is langun he ǥelemiten he egemiten te kebpenilbi zutun te Tulda. Kandan he vaal is langun he vuluhaten he egkeǥemitan kayi he menge gelemiten. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Si Aaron wey is menge anak din iyan edumala te menge kevuwazan ni Gershon mehitenged te vuluhaten dan, ed-uwit daan sikandan te menge gelemiten etawa ebaal te zuma he menge vuluhaten. Iyan kew ki Aaron kaǥi ke hengkey is ed-uwiten dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Iyan heeyan menge vuluhaten te menge kevuwazan ni Gershon diyà te Tulda he Edtelevukaayan. Dizalem sikandan te kedumala ni Itamar he anak ni Aaron he memumuhat.” ");
INSERT INTO mbbOT_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Sinsusa nu zaan is menge kevuwazan ni Merari; sinsusa is kada kezuzumahi wey is menge pemilya zutun. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Bilanga nu is langun he menge maama he is penuiǥen dan 30 pehendiyà te 50 he tuig, he ebpekehimu te vuluhaten diyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iyan heini vuluhaten dan diyà te Tulda he Edtelevukaayan: iyan sikandan ed-uwit te menge tabla he elavat duen te tulda, menge marku kayi, menge tukud, wey menge pundasyun. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Iyan daan sikandan ed-uwit te menge tukud he edteuzan te menge kurtina he ibpeliǥuy zuen te Tulda, wey menge pundasyun kayi, menge palpal wey menge hiket. Kandan he vaal is langun he menge vuluhaten he egkeǥemitan kayi he menge gelemiten. Iyan kew ki Aaron kaǥi ziyà te kada sevaha kandan ke hengkey is kinahanglan he ed-uwiten dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Iyan heeyan menge vuluhaten te menge kevuwazan ni Merari ziyà te Tulda he Edtelevukaayan. Dizalem sikandan te kedumala ni Itamar he anak ni Aaron he memumuhat.” ");
INSERT INTO mbbOT_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Tenged te kedtuman te insuǥù te Nengazen, midsinsus eni Moises, Aaron, wey te menge pengulu te Israel is menge kevuwazan ni Kohat, ni Gershon, wey ni Merari; midsinsus is kada kezuzumahi wey is menge pemilya zutun. Inlista zan is langun he menge maama kandan he is penuiǥen dan 30 pehendiyà te 50 he tuig he ebpekehimu te menge vuluhaten diyà te Tulda he Edtelevukaayan, ne iyan heini kahabet dan: Pemilya; Kahabet Kohat; 2,750 Gershon; 2,630 Merari; 3,200 Is tivuuk he kahabet dan, 8,580 langun. ");
INSERT INTO mbbOT_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Umbe, sumalà te insuǥù te Nengazen ki Moises, mibilang sikandan ne mibeǥayan te vuluhaten is kada sevaha kandan wey migkeǥiyan ke hengkey is ed-uwiten din. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mendui nu is menge Israilihanen he ibpeǥawas diyà te kampu is minsan hentei he zuen melimezang he zaru te lundis din, etawa zuen egawas diyà te sudiyè din tenged te zaru, etawa nehimu he meremerik su nekeǥawed te minatey. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Maama etawa vahi ne ipeǥawas niw sikandan su wey zan kenà meremeriki is kampu zan, he iyan ed-ubpaan ku duma keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Umbe, impeǥawas te menge Israilihanen haazà he menge etew ziyà te kampu su iyan haazà insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Keǥiyi nu is menge Israilihanen he emun duen maama etawa vahi he nekesupak te egkesuatan te Nengazen pinaaǥi te kebaal te mezaat diyà te iring din he etew, heeyan he etew nekesalà. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kinahanglan he idtug-an din is salà he neveelan din, ne veyazi zin te hustu he vayad is azen he migkuwa zin etawa midezeetan din, ne haazà is hustu he vayad din ne umani zin pa te 20 pursintu is bali zutun. Iveǥey zin heini is langun diyà te etew he neselaan din. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Piru ke minatey en haazà is etew he neveelan te mezaat, ne wazà daan megeget he kezuzumahi zin he iyan edawat kayi he vayad, ne haazà is bayad gaked en te Nengazen, ne kinahanglan he ibeǥey haazà diyà te memumuhat duma te kerehidu he ibpemuhat dutun te memumuhat su para mepesaylu is salà dutun he etew. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Is langun he segradu he menge gasa he ed-uwiten te menge Israilihanen diyà te memumuhat, gaked en te memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Uya, gaked en te memumuhat haazà is segradu he menge pemuhat.” ");
INSERT INTO mbbOT_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mid-uman pa megkaǥi is Nengazen te, ");
INSERT INTO mbbOT_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Keǥiya nu heini ziyà te menge Israilihanen: Penenglitan ke zuen bahi he mibpekigkumpadi. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Mibpehilavet sikandin te kumpadi zin he wazà metueni te esawa zin. Wazà netau te meremerik he vaal zin, su wazà nekaahà kandin te aktu. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","15","Emun edhaled is esawa zin he tutuu he zuen mibeelan din he mezaat, etawa ebpengelikud is maama piru wazà mezaat he mibeelan duen te vahi, kinahanglan he ed-uwiten sikandin duen te maama ziyà te memumuhat ne kinahanglan he ed-uwit haazà is maama te pemuhat he para te esawa zin he zezuwa he kilu he herina he barli, ne kinahanglan he kenè din heini edsehuǥan te lana etawa veyewà su pemuhat heini he gasa he ibpemuhat din tenged te kebpengelikuzi zin te esawa zin. Pemuhat heini para metueni ke nekesalè be is esawa zin etawa wazà. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Edumahan dutun te memumuhat haazà is bahi ziyà te etuvangan ku. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ne ed-itis te wahig he mid-isip he segradu ziyà te ziniyun haazà is memumuhat, ne edsevukan din haazà te eliyavuk he ebpuun diyà te saag duen te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ibpehitindeg dutun te memumuhat haazà is bahi ziyà te etuvangan ku, ibpeperuvey te memumuhat haazà is bahi ne ibpetepayà kandin sikan is pemuhat he gasa he para metueni ke nekesalè be sikandin wey ke wazà. Pemuhat heini te esawa zin te kebpengelikuzi zin kandin. Ne kegkepasad dutun, egewazan dutun te memumuhat sikan is midteǥuan te wahig he mepait he ed-uwit te rawak. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ne ibpepenangdù din haazà is bahi ke mibpekigkumpadi ve sikandin etawa wazà, ne egkaǥi sikandin te, ‘Emun wazè nu remeriki is keugelingen nu pinaaǥi te kebpehilavet te sengememaama, kenè ka ed-utengan te rawak he ed-uwiten kayi te mepait he wahig. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Iyan, emun midremerikan nu is keugelingen nu pinaaǥi te kebpehilavet te maama he kenè nu esawa, ");
INSERT INTO mbbOT_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ebpenangdù a he egkehimu ka he mezaat he petug-iringan tenged te rawak te Nengazen dutun te timpu he kenè ke en ebpekaanak. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Berakat he heini is wahig he ed-uwit te rawak, edreneb diyà te lawa nu su wey ka kenè en mekaanak.’ Ne edtavak haazà is bahi te, ‘Uya, uyun a keniyan.’ ");
INSERT INTO mbbOT_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Ne kegkekapasad dutun, idsurat duen te memumuhat heini he menge rawak diyà te para te edsuratan ne ebpenasen din pinaaǥi te kedtereva kayi zuen te wahig he mepait he intaǥù diyà te ziniyun. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ne ibpeinum din dutun te vahi haazà is mepait he wahig he ed-uwit te rawak, su para mekaantus sikandin te utew merasey he egkeuwit dutun emun tutuu he nekesalà sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ne egkuwaan duen te memumuhat puun te velad dutun te vahi sikan is pemuhat he para gasa he pemuhat para te kebpengelikud te esawa zin, ne ibayew heini zutun te memumuhat diyà te etuvangan ku, ne ed-uwiten din diyà te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Egkuwa haazà is memumuhat te sengekemkem dutun te pemuhat he para metueni ke nekesalè be haazà is bahi etawa wazà, ne edtutungen din duen te pemuhatà. Ne kegkepasad dutun human din ibpeinum duen te vahi sikan is wahig. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Emun tutuu he midremerikan din is keugelingen din pinaaǥi te kedluivi zin te esawa zin, ne haazà is wahig he neinum din, ebpekeuwit diyà te kandin te rawak he utew zin igkerasey. Kenè en sikandin ebpekaanak, ne egkehimu sikandin he petug-iring te etew he edrewakan te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Iyan, emun wazè din remeriki is keugelingen din, kenà sikandin ed-utengan kayi ne ebpekaanak sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Iyan heini kesuǥuan bahin te maama he ebpengelikuzan din is esawa zin. Emun is bahi midremerikan din is keugelingen din pinaaǥi te kedluivi zin te esawa zin, ");
INSERT INTO mbbOT_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","etawa edhaled is maama te esawa zin, ne tenged dutun kinahanglan he ibpehitindeg te memumuhat is bahi ziyà te etuvangan ku ne ebeelan diyà te kandin heini he menge kesuǥuan. ");
INSERT INTO mbbOT_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Is maama wazè din televaken, piru is bahi zuen din televaken emun nekesalà sikandin, ne egkerasey sikandin tenged te salè din.” ");
INSERT INTO mbbOT_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Keǥiya nu ziyà te menge Israilihanen he emun duen bahi etawa maama he edhimu te ispisyal he penaad he ibpehinungud din is keugelingen din kayi te kedì pinaaǥi te kedhimuwa zin kayi he Nazareo, ");
INSERT INTO mbbOT_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kinahanglan he kenà sikandin med-inum te vinu he paras wey te zuma pa he ebpekelangut he menge inumen. Kenà daan sikandin megamit te sukà he paras, wey te sukà he iyan mibeelan is duma pa he ebpekelangut he inumen. Ne kenà sikandin med-inum te wahig te paras wey kenà megkaan te wazà genguwa etawa migangu he paras. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dutun te Nazareo sikandin, kinahanglan he kenà sikandin megkaan te minsan hengkey he ebpuun diyà te paras, minsan lisu zin etawa luwit din. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Kenè din daan petempezi is bulvul zin dutun te wazè din pa mepasad is penaad din te kebpenilbi te Nengazen. Kinahanglan he idsivey sikandin he para te Nengazen taman te egkepasad is timpu te penaad din, ne vey-ani zin en ke ebmelayat is bulvul zin. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Dutun te wazè din pa mepasad is penaad din te kebpenilbi te Nengazen, kinahanglan he kenà sikandin med-uvey te minatey, ");
INSERT INTO mbbOT_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","minsan amey zin, iney zin, etawa suled din. Kenè din remeriki is keugelingen din tenged kandan, su is bulvul zin simbulu te kebpehinunguza zin te untung din diyà te Megbevayà. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Umbe, zutun te tivuuk he timpu te kebpehinunguza zin te untung din, insivey sikandin he para te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Emun duen edtik-ew ebpatey ziyà te avey zin, he tenged dutun neremerikan sikan is bulvul zin he simbulu te kebpehinungud din te keugelingen din diyà te Nengazen, kinahanglan he medtaǥad sikandin te pitu he andew, ne zutun mebpevangul sikandin. Is ikepitu he andew, iyan kes andew te kebpekelumpiyuwa zin te keugelingen din. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ne emun ikewalu en he andew, kinahanglan he med-uwit sikandin te zezuwa he merepatik etawa limuken diyà te memumuhat diyà te ǥemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Is sevaha, ibpemuhat te memumuhat he pemuhat he para idlumpiyu ne is sevaha pa, pemuhat he edtutungen. Ne pinaaǥi kayi egkevelukasan sikandin tenged te salè din te kebpekeǥawed te minatey. Dutun mismu he andew, iuman din ipehinungud is keugelingen din ne ipeuman din ipemelayat is bulvul zin. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Sikan is nehuna he menge andew te kebpenilbi zin te Megbevayà, kenè en idtarin te keluǥayad te timpu he impenaad din, su neremerikan man sikandin tenged te kebpekeǥawed te minatey. Kinahanglan he iuman din ipehinungud is keugelingen din ne med-uman mebpuun taman te egkepasad din is penaad din. Kinahanglan daan he ed-uwit sikandin te meemahan he kerehidu he ibpemuhat para te vayad te salè din. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Iyan heini ebeelan diyà te kandin emun egkepasad en is penaad din he kedhimuwa zin te keugelingen din he Nazareo: Kinahanglan he ibpehendiyà sikandin te ǥemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Dutun ebpemuhat sikandin diyà te Nengazen te menge uyaǥen he wazè dan sazir he iyan is: sevaha he meemahan he kerehidu he senge-tuig is keǥurang din he pemuhat he edtutungen, sevaha he vehiyan he kerehidu he senge-tuig gihapun is keǥurang din he pemuhat para idlumpiyu, wey sevaha he meǥurang en he meemahan he kerehidu he pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ne liyu zutun, mebpemuhat daan sikandin te menge pemuhat he para gasa, pemuhat he inumen, wey senge vaskit he supas he wazè din tapey he iyan ebeelan is meupiya he kelasi te herina. Is duma he supas, ne ebpekekepalen ne edsehuǥan te lana ne is duma pa ebpekenipisen he edezasan te lana. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Iyan is memumuhat ebpemuhat kayi ziyà te etuvangan te Nengazen: Ibpemuhat din is pemuhat he para idlumpiyu wey is pemuhat he edtutungen. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ne ibpemuhat din daan is meemahan he kerehidu he pemuhat he para te meupiya he kedepità duma zuen te senge vaskit he supas he wazè din tapey. Ne ibpemuhat din daan sikan is menge pemuhat he para gasa wey is pemuhat he inumen. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Ne kegkepasad dutun, mebpevangul haazà is Nazareo he simbulu te kebpehinunguza zin te untung din diyà te Nengazen, diyà te ǥemawan te Tulda he Edtelevukaayan. Ne vinsuli zin is bulvul zin te hapuy he tutungà te pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ne idsavuk duen te memumuhat diyà te palad duen te Nazareo is pemenayen he vahin duen te sinevawan he kerehidu wey sikan is menipis wey mekepal he menge supas he wazè din tapey puun duen te vaskit. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ne egkuwaan duen te memumuhat haazà ne ibayew zin diyà te etuvangan te Nengazen su pemuhat haazà he ibayew. Segradu heini he vahin te pemuhat, ne ǥaked en heini te memumuhat, ragkes is kumeng wey vuvun duen te kerehidu he imbayew zaan diyà te Nengazen. Ne kegkepasad kayi egkehimu en he ed-inum te vinu haazà is Nazareo. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Iyan heini sulunuzen he para te sevaha he Nazareo. Piru emun edsaad is sevaha he Nazareo he ebpemuhat sikandin diyà te Nengazen he ebpesubrahan din is ibpetuman kandin he penaad he egkehimu he Nazareo, kinahanglan he edtumanen din heini.” ");
INSERT INTO mbbOT_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Keǥiyi nu si Aaron wey is menge anak din he maama te iyan heini keǥiya zan emun ebpenubtuvazan dan is menge Israilihanen: ");
INSERT INTO mbbOT_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Berakat he tuvazi kew te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Berakat he ipaahà te Nengazen is keupiya zin wey hizu zin keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Berakat he purungi kew te Nengazen ne veǥayi kew zin te meupiya he kebpekesavuk.’ ");
INSERT INTO mbbOT_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Pinaaǥi kayi igkepehayag dan diyà te menge Israilihanen ke hentei a, ne edtuvazan ku sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Hein ingkepelastar en ni Moises sikan is Tulda he Ed-ezapan, mibpirikan din heini te lana, ne impehinungud din ragkes en is langun he menge gelemiten kayi. Iyan daan heini mibeelan din duen te tulda he iring ded te mibeelan din duen te pemuhatà wey is langun he ǥelemiten kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ne mid-uwit te menge halad diyà te Nengazen is menge pengulu te Israel, he iyan kes menge pengulu te kada tribu he insarig kandan is kedsinsus. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Mid-uwit dan diyà te etuvangan te Nengazen te heenem he kerumata wey 12 he vaka, sevaha he kerumata is mid-uwit te kada zezuwa he pengulu, ne sevaha he vaka is mid-uwit te kada sevaha kandan. Mid-uwit dan haazà diyà te egkesineruwan duen te Tulda he Ed-ezapan. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Dewata nu is halad dan su egemiten heini para te menge vuluhaten diyà te Tulda he Edtelevukaayan. Iveǥey nu heini ziyà te menge kevuwazan ni Levi sumalà te egkinehenglanen duen te neketukid kandan he vuluhaten.” ");
INSERT INTO mbbOT_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Umbe, midawat ni Moises haazà is menge kerumata wey menge vaka ne imbeǥey zin diyà te menge kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Imbeǥey zin is dezuwa he kerumata wey heepat he vaka ziyà te menge kevuwazan ni Gershon he para te vuluhaten dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Imbeǥey zin is heepat he kerumata wey walu he vaka ziyà te menge kevuwazan ni Merari he para te vuluhaten dan. Iyan heini sikandan is langun ebpenguluwan ni Itamar he anak ni Aaron he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Piru wazà mulà beǥayi ni Moises te kerumata etawa vaka is menge kevuwazan ni Kohat su iyan sikandan midseriǥan te kedtiang duen te segradu he menge vutang duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Is menge pengulu, mid-uwit daan te kandan he menge halad he para te kebpehinunguza zuen te pemuhatà emun ibpehinungud en heini. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Migkeǥiyan te Nengazen si Moises te, “Kinahanglan he kada andew, zuen sevaha he pengulu he ed-uwit te halad din he para te kebpehinunguza zuen te pemuhatà.” ");
INSERT INTO mbbOT_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Iyan heini sikandan mid-uwit te menge halad: Dutun te nehuna he andew, iyan si Nashon he anak ni Aminadab, he pengulu te tribu ni Juda. Dutun te ikezuwa he andew, iyan si Netanel he anak ni Zuar, he pengulu te tribu ni Isacar. Dutun te iketelu he andew, iyan si Eliab he anak ni Helon, he pengulu te tribu ni Zebulun. Dutun te ikeepat he andew, iyan si Elizur he anak ni Shedeur, he pengulu te tribu ni Reuben. Dutun te ikelima he andew, iyan si Shelumiel he anak ni Zurishadai, he pengulu te tribu ni Simeon. Dutun te ikeenem he andew, iyan si Eliasaf he anak ni Deuel, he pengulu te tribu ni Gad. Dutun te ikepitu he andew, iyan si Elishama he anak ni Amihud, he pengulu te tribu ni Efraim. Dutun te ikewalu he andew, iyan si Gamaliel he anak ni Pedazur, he pengulu te tribu ni Manase. Dutun te ikesiyam he andew, iyan si Abidan he anak ni Gideoni, he pengulu te tribu ni Benjamin. Dutun te ikesepulù he andew, iyan si Ahiezer he anak ni Amishadai, he pengulu te tribu ni Dan. Dutun te ike-11 he andew, iyan si Pagiel he anak ni Ocran, he pengulu te tribu ni Asher. Dutun te ike-12 he andew, iyan si Ahira he anak ni Enan, he pengulu te tribu ni Naftali. Is kada sevaha kandan mid-uwit kayi he menge halad: sevaha he pelata he bendihadu he sengekilu wey tengà is keveǥat din wey sevaha he pelata he yahung he 800 he gramu is keveǥat din diyà te timbangan he egemiten te menge memumuhat. Is kada sevaha kayi nepenù te meupiya he kelasi te herina he midsehuǥan te lana ne halad heini he pemuhat he para gasa. Mid-uwit daan is kada sevaha kandan te vulawan he 120 he gramu is keveǥat din he nepenù te veyewà, sevaha he turiti he vaka, sevaha he meemahan he kerehidu he meǥurang en, wey sevaha he meemahan he kerehidu he senge-tuig pa is keǥurang din he pemuhat he edtutungen, sevaha he meemahan he kambing he pemuhat he para idlumpiyu, dezuwa he tudu he vaka, lelima he meemahan he kerehidu he meǥurang en, lelima he meemahan he kambing, wey lelima he meemahan he kerehidu he senge-tuig pa is keǥurang dan he pemuhat he para te meupiya he kedepità. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Iyan heini sikan is langun he menge halad duen te 12 he pengulu te menge Israilihanen he para te kebpehinunguza zuen te pemuhatà: 12 he pelata he menge bendihadu, 12 he pelata he menge yehung, wey 12 he vulawan he menge tasa. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Is kada sevaha zuen te pelata he bendihadu, sengekilu wey tengà is keveǥat din, ne is kada sevaha zuen te pelata he yehung, 800 he gramu is keveǥat din. Is keveǥat kayi te langun nekeuma te 28 he kilu ziyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Sikan is 12 he tasa he vulawan he nepenù te veyewà, duen keveǥat te kada sevaha zutun he 120 he gramu ziyà te timbangan he egemiten te menge memumuhat. Is keveǥat kayi te langun nekeuma te 1,440 he gramu. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Is menge uyaǥen he imbeǥey he para te pemuhat he edtutungen, 12 he turiti he vaka, 12 he meemahan he menge kerehidu he meǥurang en, wey 12 he menge kerehidu he tig senge-tuig is keǥurang dan, ragkes is menge pemuhat he para gasa. Is pemuhat he para idlumpiyu: 12 he meemahan he menge kambing. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Is menge uyaǥen he pemuhat he para te meupiya he kedepità: 24 he tudu he vaka, 60 he meemahan he menge kerehidu he meǥurang en, 60 he meemahan he menge kambing, wey 60 he meemahan he menge kerehidu he tig senge-tuig pa is keǥurang dan. Iyan heini kes langun he menge pemuhat he para te kebpehinunguza zuen te pemuhatà. ");
INSERT INTO mbbOT_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Emun edseled si Moises duen te Tulda he Edtelevukaayan su ebpekidlalag te Nengazen, egkezineg din is laǥeng he ebpekidlalag kandin puun duen te mid-elangan te zezuwa he ledawan te kirubin, he zuen te zivavew te tambun te Kavan te Kebpekid-uyun. Dutun ebpekidlalag is Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Keǥiyi nu si Aaron he emun ibpelastar zin en is pitu he sulù, kinahanglan he ziyè din heini ipelastar te egkeenlaǥan te kerayag din is diyà te egkesineruwan te selevukà kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Umbe, mibeelan haazà ni Aaron: impelastar zin haazà is menge sulù diyà te lugar he egkeenlaǥan te kerayag din is egkesineruwan te selevukà kayi, sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bulawan haazà is tivuuk he selevukà te menge sulù puun te zizalem pehendiyà te zivavew su iyan haazà kebeeli zuen he impaahà te Nengazen diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Isivey nu is menge kevuwazan ni Levi puun te zuma he menge Israilihanen ne lumpiyuwi nu sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Iyan heini veeli nu te kedlumpiyu kandan: Piriki nu sikandan te wahig he ǥelemiten te kedlumpiyu ne pekiskisi nu is tivuuk he lawa zan wey pepìpii nu is menge visti zan. Ne kegkepesad dutun ed-isipen en sikandan he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ne ipeuwit nu sikandan te turiti he vaka wey pemuhat he para gasa he meupiya he kelasi te herina he midsehuǥan te lana. Ipeuwit nu zaan sikandan te sevaha pa he turiti he vaka he pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","“Ne kegkepasad dutun, tiǥuma nu is tivuuk he keet-etawan te Israel ne ipehinungud niw is menge kevuwazan ni Levi ziyà te egkesineruwan duen te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Dumaha nu is menge kevuwazan ni Levi ziyà te etuvangan ku ne ipezampè nu te menge Israilihanen is menge ulu te menge kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Si Aaron is ebpehinungud kandan diyà te etuvangan ku he ispisyal he halad puun te menge Israilihanen, su wey zan mekepenilbi kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Ne idampà te menge kevuwazan ni Levi is menge velad dan diyà te ulu zuen te zezuwa he turiti he vaka he para kedì. Is sevaha zutun, pemuhat he para idlumpiyu, ne is sevaha pa, pemuhat he edtutungen, su wey zan mevelukasi te menge salè dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ne ipehitindeg sikandan diyà te etuvangan ni Aaron wey te menge anak din he menge maama ne ipehinungud sikandan he ispisyal he halad para kediey. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Pinaaǥi kayi igkesivey nu is menge kevuwazan ni Levi puun te zuma he menge Israilihanen ne egkehimu en sikandan he menge ǥaked ku. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Emun egkepasad nu en te edlumpiyu wey ebpehinungud kayi te kedì he ispisyal he halad is menge kevuwazan ni Levi, ne ebpekepenilbi en sikandan diyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Iyan sikandan menge Israilihanen he insivey para zà kediey he ilis te langun he kinekekayan he menge anak te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Su kediey is langun he kinekekayan he menge maama te menge Israilihanen, etew man etawa uyaǥen. Hein mibpenhimetayan ku is langun he kinekekayan he menge anak he maama te menge Ehiptohanen, insivey ku en he para kediey is langun he menge anak he maama te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ne migkuwa ku is menge kevuwazan ni Levi he ilis te langun he kinekekayan he menge maama te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Diyà te langun he menge Israilihanen, iyan is menge kevuwazan ni Levi mibpilì ku he ebpekeuǥup ki Aaron wey te menge anak din. Ebpenilbi sikandan diyà te Tulda he Edtelevukaayan para te menge Israilihanen, ne iyan sikandan ebaal te menge tulumanen he para mevelukasi is salà te menge Israilihanen, su para wazà kezeetan he egkehitavù kandan emun ed-uvey zan duen te Tulda he Edtelevukaayan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Umbe, mibeelan eni Moises, Aaron, wey te tivuuk he keet-etawan te Israel is insuǥù te Nengazen ki Moises he ebeelan diyà te menge kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Midlumpiyuwan te menge kevuwazan ni Levi is keugelingen dan, wey mibpìpian dan is menge visti zan. Ne impehinungud sikandan ni Aaron diyà te etuvangan te Nengazen he ispisyal he halad, ne mibeelan ni Aaron is tulumanen he para mevelukasi is menge salè dan, wey para meisip en sikandan he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ne kegkepasad dutun, nenilbi en is menge kevuwazan ni Levi ziyà te Tulda he Edtelevukaayan he zizalem te kedumala ni Aaron wey te menge anak din. Mibeelan dan diyà te menge kevuwazan ni Levi is insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Iyan heini menge sulunuzen para te menge kevuwazan ni Levi: Ebpuun ebpenilbi is menge kevuwazan ni Levi ziyà te Tulda he Edtelevukaayan emun 25 en is penuiǥen dan, ");
INSERT INTO mbbOT_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ne ed-engked dan he ebpenilbi emun 50 en is penuiǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Egkehimu pa sikandan he ed-uǥup te menge zuma zan he menge Levihanen pinaaǥi te kebantey zuen te Tulda, piru kenè dan en mebaal te menge vuluhaten dutun te Tulda. Iyan heeyan menge ketengdanan te menge kevuwazan ni Levi he ipetuman nu kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Hein nehuna he vulan te ikezuwa he tuig puun te kegawas te menge Israilihanen diyà te Ehipto, migkeǥiyan te Nengazen si Moises diyà te sibsivayan he Sinai te, ");
INSERT INTO mbbOT_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ibpesilibra te menge Israilihanen is Pista te Kedlavey te Belinsuǥuen dutun te timpu he midtelaan. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ebpuunan niw heini emun egkesakep en dutun te ike-14 he andew kayì he vulan. Kinahanglan he ed-ikulen niw is langun he sulunuzen mehitenged kayi he pista.” ");
INSERT INTO mbbOT_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Umbe, migkeǥiyan ni Moises is menge Israilihanen bahin te kedsilibra te Pista te Kedlavey te Belinsuǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Mibeelan dan is kedsilibra zutun diyà te sibsivayan he Sinai hein mibpuun is ike-14 he andew te egkehuna he vulan. Mibeelan heini te langun he menge Israilihanen sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Piru zuen duma kandan he wazà meketampu zutun te pista, su geina te zutun he andew nehimu sikandan he meremerik su nekeǥawed dan te minatey. Umbe zutun he andew midhendiyà sikandan te ki Moises wey ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ne ke sikandan te, “Nehimu key he meremerik su nekeǥawed key te minatey, piru maan is indawey kenami is kedsilibra kayì he pista wey kebpemuhat te menge pemuhat diyà te Nengazen duma te zuma he menge Israilihanen kayi te midtelaan he timpu?” ");
INSERT INTO mbbOT_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Midtavak sikandan ni Moises te, “Taǥad kew zà dèpa taman te egketuenan ku ke hengkey is idsuǥù te Nengazen kediey mehitenged keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Keǥiyi nu is menge Israilihanen he minsan hentei kandan guntaan wey is huziyan he menge kevuwazan dan he egkehimu he meremerik su nekeǥawed te minatey etawa ziyà sikandin te hipenawan dutun te timpu te kedsilibra, ebpekehimu ǥihapun he edsilibra te Pista te Kedlavey te Belinsuǥuen. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Silibraha zan heini emun edlavey en is senge vulan, puun te ike-14 he andew te ikezuwa he vulan. Keena zan is kerehidu wey supas he wazè din tapey wey mepait he menge pinemula. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Kinahanglan he egkaamin heini te kenè pa egkepawà, wey kenè dan daan bedtìa is tulan duen te kerehidu. Emun edsilibra zan te Pista te Kedlavey te Belinsuǥuen kinahanglan he ed-ikulen dan is menge sulunuzen mehitenged kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Piru is etew he lumpiyu wey wazà medhipanew ziyà te meziyù he wazà medsilibra te Pista te Kedlavey te Belinsuǥuen, heeyan he etew kinahanglan he kenè en egkilelaan he zuma niw, su wazà sikandin mebpemuhat te pemuhat he para te Nengazen dutun te midtelaan he timpu. Heeyan he etew egkerasey tenged te salè din. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Emun duen kenà Israilihanen he mid-amur ziyà te inged niw he egkesuat he edsilibra te Pista te Kedlavey te Belinsuǥuen, kinahanglan he edsilibrahan din heini he ed-ikul zuen te langun he menge sulunuzen mehitenged kayi. Neked-iring dà is menge sulunuzen he para te menge Israilihanen wey te kenà menge Israilihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Hein andew te kebenguna zuen te Tulda he Ed-ezapan he zutun itaǥù sikan is Kesuǥuan, neliǥuy heini te ǥapun. Puun te mezukilem taman te meselem, heini he ǥapun henduen be te hapuy he ed-anlag. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Iyan heini layun egkehitavù–emun maandew ebpekeliǥuy heini zuen te tulda ne emun mezukilem ed-anlag heini iring te hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ne emun ebpeketikang sikan is gapun diyà te zivavew zuen te Tulda ne egenat heini, ne egenat daan is menge Israilihanen, ne ke hendei ebpundu haazà is gapun ne zutun dan daan egkampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Umbe, midhipanew wey migkampu is menge Israilihanen sumalà te insuǥù kandan te Nengazen. Kenè dan edhipanew emun dutun pa te zivavew te tulda sikan is gapun. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Minsan meluǥayad he timpu is kenà ked-awà duen te ǥapun diyà te zivavew zuen te Tulda, ne kenà sikandan egenat; edtaǥad sikandan te idsuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Duen timpu he egkepipira zà he andew is kenà ked-awà duen te ǥapun diyà te zivavew zuen te tulda ne egkepipira zà daan he andew is kenè dan kebpekeǥenat. Ne edhipanew en maan sikandan sumalà te idsuǥù te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Usahay sengekezukileman dà is kenà ked-awà duen te ǥapun, ne sunud he andew ne ebpeketikang en heini, ne egenat en daan is menge Israilihanen. Maandew etawa mezukilem egenat is menge Israilihanen basta ebpezivavew haazà is gapun. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Emun kenà ed-awà haazà is gapun diyà te zivavew zuen te tulda seled te zezuwa he andew etawa senge vulan etawa senge tuig, kenà daan ed-awà is menge Israilihanen diyà te kampu zan, iyan, emun ebpezivavew haazà is gapun ne segugunè dan egenat. ");
INSERT INTO mbbOT_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Umbe, egkampu wey egenat is menge Israilihanen sumalà te idsuǥù te Nengazen. Ne midtuman dan is menge suǥù te Nengazen he migkaǥi zin diyà te ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Pevaal ka te zezuwa he trumpita he pelata ne ǥemita nu heini te kedtiǥuma te menge etew wey kebpaandam kandan te kedhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Emun ibpedredsà te ebpezaǥing haazà is dezuwa he trumpita ne edtiǥum is langun he menge etew ziyà te ǥemawan duen te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Emun sevaha zà is ibpezaǥing, ne iyan dà is menge pengulu te kada tribu is edtiǥum diyà te etuvangan nu. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Emun ibpezaǥing haazà is trumpita te para te kebpaandam te menge etew te kedhipanew, is tribu he ziyà megkampu te zapit te edsilaan duen te Tulda ne iyan medhuna medhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ne emun ikezuwa he kebpezeǥinga zuen te trumpita, ne iyan en maan megenat is tribu he egkezivavà duen te Tulda. Is kebpezeǥinga kayi iyan tuus te kebpeǥenata kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Piru selakew is kebpezeǥinga zuen te trumpita emun ibpetiǥum sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Iyan dà is menge kevuwazan ni Aaron he menge memumuhat mebpezaǥing duen te menge trumpita. Heini he sulunuzen, kinahanglan he edtumanen niw wey te menge kevuwazan niw taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Emun diyè kew en te tanè niw, ne ebpekidtebek kew te menge kuntada niw he edrasey keniyu, ipezaǥing niw is menge trumpita su para siak is Nengazen he Megbevayè niw, egketenuzan ku sikiyu ne edlibriyen ku sikiyu te kedezaat te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Emun timpu te kedlipey niw zutun te kedsilibra niw te menge pista te netendek he timpu te kebeeli zuen, ragkes en is Pista te Kebpuun te Hayag–pezaǥing niw is menge trumpita emun ebpemuhat kew te menge pemuhat he edtutungen wey pemuhat he para te meupiya he kedepità. Heini he menge trumpita ebpetanudtanud kediey te Megbevayè niw te kebpekid-uyun ku keniyu. Iyan a Nengazen he Megbevayè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Hein ike-20 he andew te ikezuwa he vulan, te ikezuwa he tuig puun te kegawas te menge Israilihanen diyà te Ehipto, midhendiyà te zivavew sikan is gapun duen te Tulda he Ed-ezapan he zutun itaǥù sikan is Kesuǥuan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ne midhipanew is menge Israilihanen puun te sibsivayan he Sinai ne edhalinhalin te menge lugar, taman te mibpundu sikan is gapun diyà te sibsivayan he Paran. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Iyan heini nehuna he timpu te kedhipanew zan, he sumalà te suǥù te Nengazen pinaaǥi ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Is grupu he midhuna he uwiten dan is bendira zan iyan is grupu he ebpenguluwan te tribu ni Juda. Is pengulu zan iyan si Nashon he anak ni Aminadab. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Is tribu ni Isacar mibpenguluwan ni Netanel he anak ni Zuar. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ne is tribu ni Zebulun mibpenguluwan ni Eliab he anak ni Helon. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hein netines en sikan is Tulda he Ed-ezapan, midtival en heini te menge kevuwazan ni Gershon wey menge kevuwazan ni Merari. Ne midtinundug sikandan medhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ne is midtinundug kandan he ed-uwit te bendira zan iyan is grupu he ebpenguluwan te tribu ni Reuben. Is pengulu zan iyan si Elizur he anak ni Shedeur. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Is tribu ni Simeon mibpenguluwan ni Shelumiel he anak ni Zurishadai. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ne is tribu ni Gad mibpenguluwan ni Eliasaf he anak ni Deuel. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ne midtinundug kandan is menge kevuwazan ni Kohat he ed-uwit te segradu he menge gelemiten duen te Tulda he Ed-ezapan. Kinahanglan he igkepelastar en sikan is Tulda te kenè pa sikandan ebpekeuma ziyà te lugar he egkempuwan dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ne is midtinundug kandan he ed-uwit te bendira zan iyan is grupu he ebpenguluwan te tribu ni Efraim. Is pengulu zan iyan si Elishama he anak ni Amihud. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Is tribu ni Manase mibpenguluwan ni Gamaliel he anak ni Pedazur. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ne is tribu ni Benjamin mibpenguluwan ni Abidan he anak ni Gideoni. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Is kinehuziyanan he midhipanew he ed-uwit te bendira zan iyan is grupu he ebpenguluwan te tribu ni Dan. Iyan sikandan nehimu he vantey ziyà te egkeiniyuǥan he para te langun he grupu. Is pengulu zan iyan si Ahiezer he anak ni Amishadai. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Is tribu ni Asher mibpenguluwan ni Pagiel he anak ni Ocran. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ne is tribu ni Naftali mibpenguluwan ni Ahira he anak ni Enan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Iyan heeyan kebpekedezepità te menge grupu te menge tribu te Israel dutun te kedhipanew zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ne migkaǥi si Moises diyà te ki Hobab he uyang din he anak ni Reuel he Midianhen te, “Edhendiyè key en te lugar he migkaǥi te Nengazen he ibeǥey zin kenami. Umbe zuma ka kenami ne kenè dey sikew ebey-anan, su midsaad is Nengazen he edtuvazan din is Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Piru midtavak si Hobab te, “Kenà a. Edlikù a kayi te kediey he lugar wey ziyà te menge emurè ku te inged.” ");
INSERT INTO mbbOT_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Migkaǥi si Moises te, “Emun egkehimu ne kenè key kenikew ewai. Iyan ka netau ke hendei is meupiya he egkempuwan dey ziyà te sibsivayan. Iyan ka giya kenami. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Emun eduma ka kenami ebehinan dey sikew te langun he keupiyaanan he ibeǥey te Nengazen kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Umbe, mid-awà sikandan puun te vuntud te Nengazen ne midhipanew sikandan seled te tetelu he andew. Layun diyà te egkehunaan dan sikan is Kavan te Kebpekid-uyun su wey zan meturedu is lugar he egkehimelayan dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Emun maandew, ziyà sikan is gapun te Nengazen te zivavew zan te edhipanew. ");
INSERT INTO mbbOT_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kada ed-uwita sikan is Kavan te Kebpekid-uyun, egkaǥi si Moises te, “Sigi en, Nengazen, gurigawa nu en is menge kuntada nu. Berakat he mebpemelaǥuy sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ne kada idsavuk sikan is Kavan te Kebpekid-uyun, egkaǥi si Moises te, “Nengazen, likù ke en kayi, te utew mezakel he menge etew te Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ne midriklamu is menge Israilihanen mehitenged te kelised dan. Kegkezineǥa kayi te Nengazen, nepauk sikandin ne midretem din is hapuy he nekevinsul te nepipira he vahin te peliǥuy te kampu zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tenged kayi mibuyù te penavang is menge Israilihanen diyà te ki Moises, ne mid-ampù si Moises diyà te Nengazen, ne neevukan haazà is hapuy. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Umbe, migngezanan dan haazà is lugar te Tabera, su midretem is Nengazen te hapuy ziyà te kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Dutun he timpu, is grupu te kenà menge Israilihanen he nemenduma te menge Israilihanen midriklamu su egkesuat dan he egkaan te zuma he kelasi te menge keenen, ne is menge Israilihanen midriklamu zaan he ke sikandan te, “Deyzey pezem ke ebpekekaan kiw te usa. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Hein diyè kiw pa te Ehipto ebpekekaan kiw te isdà he wazè din bayad wey menge timun, menge milun, menge sibuyas, wey menge ahus. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Piru kayi kenè kiw egenahan he egkaan su pudu zà ‘manna’ is keenen tew.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Is ‘manna’ henduen be te dezeisey he menge lisu ne meputì heini. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ebpengemien heini te menge Israilihanen diyà te tanà kada meselem, ne egelingen dan, ne emun kenà, ne ebeveyuwen dan. Edhilutuen dan heini ziyà te ziniyun ne ebeelan dan he menipis he supas. Is taam kayi iring te taam te pan he midlutù te lana he ulibu. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ebpekelapik heini te kebpeketanà te menge zehemug dutun te kampu emun mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nezineg ni Moises he edriklamu is kada pemilya ziyà te ǥemawan te menge tulda zan. Umbe utew sikandan nepeuki te Nengazen, ne neselekawan daan si Moises tenged kayi te mibeelan dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mid-insà sikandin diyà te Nengazen te, “Maan is mibeǥayan a kenikew is suluǥuen nu te zekelà he prublima? Hengkey is neveelan ku he wazè nu ikesuat he iyan imbeǥayi nu kediey te prublima kayi te menge etew? ");
INSERT INTO mbbOT_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Menge anak ku ve sikandan? Iyan e ve mid-anak kandan? Maan is egkeǥiyan a kenikew he ed-eturen ku sikandan iring te ked-atur te perevantey te vatà he edsepipiyen din wey ibpesusu zin. Ne ibpezuma nu sikandan kedì diyà te tanà he insaad nu ziyà te menge kepuun dan? ");
INSERT INTO mbbOT_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Hendei a egkuwa te usa he para kayi he menge etew? Edtulung dan edriklamu kayi te kedì he veǥayi ku sikandan te usa he egkekaan dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Kenè ku egkehimu is ked-atur kandan te langun emun iyan e zà. Utew heini meveǥat para kediey. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Emun iyan heini ebeelan nu kediey ne himetayi ad nasì kenikew ǥuntaan. Emun nekepenunuat a kenikew, ne kenà a kenikew vey-ani he egkerasey!” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Umbe, migkaǥi is Nengazen diyà te ki Moises te, “Tiǥuma nu is 70 he menge edumala te menge Israilihanen he nekilala nu he nengulu te menge etew, ne ipehendiyè nu sikandan te Tulda he Edtelevukaayan ne ipehitindeg nu sikandan dutun duma kenikew. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ebulus a ne ebpekidlalag a kenikew zutun, ne ibeǥey ku kandan is duma he keǥehem he imbeǥey ku kenikew su wey zan mekeuǥup kenikew te kedumala te menge etew su para zuen nu zuma te kedumala kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ne keǥiyi nu is menge etew he mebpekelumpiyu sikandan, su keeselem duen en egkekaan dan he usa. Keǥiya nu heini ziyà te kandan: ‘Siak is Nengazen, nezineg ku sikiyu he edriklamu su egkesuat kew he egkaan te usa. Ne migkaǥi kew pa he meupiya pa is kebpekesavuk niw ziyà te Ehipto kenà guntaan. Umbe ebeǥayan ku sikiyu te usa keeselem su wey kew mekekaan te usa. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ne is kebpekekaan niw kayi, ne kenè dà seled te senga andew, etawa zezuwa he andew, etawa lelima, etawa sepulù, etawa 20 he andew, ");
INSERT INTO mbbOT_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","kekena, senge vulan, taman te igkeutè niw heini su edsemuwen kew en. Su inselikwey a keniyu is nekiduma keniyu, ne midriklamu kew kayi te kedì he ke sikiyu te, deyzey pa ke wazè kew en med-awà diyà te Ehipto.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Piru migkaǥi si Moises te, “600,000 langun is menge etew he zuma ku, ne ǥuntaan migkaǥi ka he ebeǥayan nu sikandan te usa he egkekaan dan seled te senge vulan? ");
INSERT INTO mbbOT_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Minsan edlepaan dey pa is langun he menge kerehidu wey menge vaka etawa edhingutelen dey is langun he isdà diyà te zaǥat ne kenè pa ereg kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Migkaǥi is Nengazen diyà te ki Moises te, “Duen be edtemanan te ǥehem ku? Egkeehè nu ǥuntaan ke egkeulaula ve is migkaǥi ku etawa kenà.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Umbe, migenat si Moises ne migkeǥiyan din is menge etew zuen te migkaǥi kandin te Nengazen. Midtiǥum din sikan is 70 he menge perezumala ne impehitindeg din diyà te peliǥuy zuen te tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ne mibulus is Nengazen pinaaǥi te ǥapun ne nekidlalag ki Moises. Ne imbeǥey zin duen te 70 he menge perezumala is duma he keǥehem. Ne hein diyè en haazà te kandan ne nenagnà sikandan, piru wazè en haazà meuman-uman. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Duen dezuwa zuen te 70 he menge perezumala he wazà med-awà diyà te kampu ne wazè dan medhendiyà te tulda he iyan si Eldad wey si Medad. Piru nekaangken gihapun sikandan te keǥehem ne ebpemenagnà daan sikandan dutun te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ne zuen betan-en he maama he mibpelelaǥuy pehendiyà te ki Moises he ke sikandin te, si Eldad wey si Medad ne nenagnà diyà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ne si Josue he anak ni Nun, he nehimu he timbang ni Moises puun te vetan-en pa sikandin, migkaǥi ziyà te ki Moises te, “Datù, ipeengked nu sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Piru midtavak si Moises te, “Ingkeipeng nu ve he ebpekezezaat heini te kegkepengulu ku? Emun iyan e zà ebpekevayàbayà, egkesuat a he pudu veǥayi te keǥehem te Nengazen is menge etew zin su para pudu zan mekepenagnà iring te menge ebpeneuven.” ");
INSERT INTO mbbOT_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ne kegkepasad dutun midlikù si Moises wey haazà is menge perezumala te menge Israilihanen diyà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ne zutun impepengeramag te Nengazen te ebpekeuwit te menge piyuǥù puun te zaǥat. Ne nemenlayang dan diyà te peliǥuy te kampu he tetelu he ǥiek is ketikang dan puun te tanà, ne nepipira he kilumitru is keluǥayad wey keluag te tanà he nezebpakan dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Umbe, zutun te tivuuk he andew nengapul is menge etew taman te mezukilem wey taman en te sunud he andew. Ne wazà mebminus te nengkelibu he kilu is nekuwa te kada sevaha kandan, ne impengagkag dan haazà diyà te peliǥuy te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Iyan, wazè dan pa haazà maamin ne utew en sikandan nepeuki te Nengazen, ne mibpeeǥiyan din sikandan te kezeetan. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Umbe, migngezanan haazà he lugar te Kibrot Hataava su zutun ipenleveng is menge etew he seseveleken te usa. ");
INSERT INTO mbbOT_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Puun dutun midhipanew is menge Israilihanen pehendiyà te Hazerot ne zutun dan megkampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Hein diyè dan te Hazerot, midsawey ni Miriam wey ni Aaron si Moises su ǥeina te nengesawa sikandin te Kushanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ke sikandan te, “Pinaaǥi zè be ki Moises is kebpekidlalag te Nengazen? Kenè be ebpekidlalag daan sikandin pinaaǥi kenami.” Piru nezineg haazà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Si Moises iyan etew he kenà mepelevawen te langun he menge etew te tivuuk he kelibutan.) ");
INSERT INTO mbbOT_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Umbe, migkeǥiyan te Nengazen si Moises, si Aaron, wey si Miriam te, “Gawas kew is tetelu keniyan te kampu ne hendiyè kew te Tulda he Edtelevukaayan.” Umbe migawas sikandan is tetelu ne midhendiyè dan te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ne mibulus is Nengazen pinaaǥi te ǥapun he henduen be te tukud ne midhitindeg diyà te ǥemawan duen te Tulda he Edtelevukaayan ne mid-umew zin si Aaron wey si Miriam. Ne hein mid-uvey haazà is dezuwa, ");
INSERT INTO mbbOT_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","migkaǥi is Nengazen te, “Pemineǥa niw heini: Emun duen ku ebpeneuven diyà te keniyu, ne ebpekidlalag a kandin pinaaǥi te ibpelewasan ku wey ibpeteǥeinep ku. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Piru kenà iring keniyan emun iyan ku edlelaǥan is suluǥuen ku he si Moises, he egkeseriǥan he pengulu te menge etew ku. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Emun ebpekidlalag a kandin, ne iring te ebpeetuvangè key su keladu is kebpekidlalag ku. Ne iring ded te neehè e zin. Piru minsan pa te iyan haazà wazè kew mahandek he egkaǥi te mezaat he ebpekesuǥat diyà te suluǥuen ku he si Moises?” ");
INSERT INTO mbbOT_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Utew sikandan nepeuki te Nengazen ne mid-awà sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Hein mid-awè en haazà is gapun diyà te zivavew zuen te Tulda, ne segugunà midtuvùi te zaru te lundis si Miriam, ne utew mibmeputì is lundis din. Ne hein naahà haazà ni Aaron, ");
INSERT INTO mbbOT_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","migkeǥiyan din si Moises te, “Datù, kenè key kenikew ipaantus tenged te salà he tinulebung is kegkeveeli zey zuen. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kenè nu ituǥut he egkeiring si Miriam te vatà he neranran he is ketengà te lawa zin neredak en.” ");
INSERT INTO mbbOT_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Umbe, mibpehizuhizu si Moises te Nengazen he ke sikandin te, “He Megbevayè ku, edhangyù a ziyà te kenikew he bewii nu si Miriam.” ");
INSERT INTO mbbOT_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Midtavak te Nengazen si Moises te, “Kenè be ke ed-ilevan sikandin te amey zin diyà te zagwey zin tenged te kedsewaya zin kandin, ed-entusen din is keelezan seled te pitu he andew? Umbe ipeǥawas sikandin keniyan te kampu seled te pitu he andew, ne emun egkepasad haazà is pitu he andew ne egkehimu en he edlikù sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Umbe, impeǥawas si Miriam puun te kampu seled te pitu he andew. Ne haazà is menge etew wazà medlaus te hipanew zan taman te nekelikù si Miriam diyà te kampu. ");
INSERT INTO mbbOT_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ne liwas dutun mid-awè dan diyà te Hazerot ne ziyè dan megkampu te sibsivayan he Paran. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Suǥù ka te menge etew he ibpepeniid diyà te Canaan he iyan kes tanà he ibeǥey ku keniyu te menge Israilihanen. Suǥù ka te tigselimbaha he pengulu puun te kada tribu te Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Umbe, midtuman ni Moises haazà is insuǥù te Nengazen kandin. Impehendiyè din te Canaan is menge pengulu te menge Israilihanen puun diyà te sibsivayan he Paran. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Iyan heini menge tribu wey menge ngazan te menge pengulu: Tribu; Pengulu Reuben; Shamua he anak ni Zacur Simeon; Shafat he anak ni Hori Juda; Caleb he anak ni Jefune Isacar; Igal he anak ni Jose Efraim; Hoshea he anak ni Nun Benjamin; Palti he anak ni Rafu Zebulun; Gadiel he anak ni Sodi Manase he anak ni Jose; Gadi he anak ni Susi Dan; Amiel he anak ni Gemali Asher; Shetur he anak ni Micael Naftali; Nabi he anak ni Bofsi Gad; Geuel he anak ni Maki ");
INSERT INTO mbbOT_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Iyan sikandan menge etew he midsuǥù ni Moises te kebpeniid diyà te Canaan. (Mid-ilisan ni Moises is ngazan ni Hoshea he anak ni Nun te Josue.) ");
INSERT INTO mbbOT_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Hein wazè pa sikandan ipeǥenat ni Moises su wey zan mekepeniid diyà te Canaan, migkeǥiyan din sikandan te, “Hipanew kew pehendiyà te zizaya ne hendiyè kew te Negev. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Susiya niw ke hengkey is purma te tanà, wey is menge etew zuen ke memezesen be etawa memeluya, mezakel ve sikandan etawa deisey zà. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Susiya niw ke hengkey he kelasi te tanà is ed-ubpaan dan, meupiya ve etawa kenà. Susiya niw is menge inged dan ke miberengbengan be etawa wazà. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Susiya niw ke egkeveluyan be is tanè dan etawa kenà, wey ke zuen be zuen menge kayu etawa wazà. Ne peninguhaa niw he mekeuwit kew te menge prutas dutun te kedlikù niw zini.” (Timpu haazà te kegkengelutui te paras.) ");
INSERT INTO mbbOT_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Umbe, midhipanew sikandan ne midsusi zan haazà is tanà puun te sibsivayan he Zin pehendiyà te Rehob he uvey te Lebo Hamat. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Mibpuun sikandan diyà te Negev taman te nekeuma zan diyà te Hebron, he zutun ed-ubpà si Ahiman, si Sheshai, wey si Talmai, he menge kevuwazan ni Anak. (Heini is Hebron pitu en he tuig is kebenguna zuen human pa mevangun is Zoan diyà te Ehipto). ");
INSERT INTO mbbOT_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ne hein nekeuma zan diyà te zal-ug he Eshcol, midtamped sikandan te sengerupung he paras, ne utew heini meveǥat umbe midtival haazà te zezuwa he etew. Mid-uwit daan sikandan te menge prutas he pumigranata wey higus. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Haazà he zal-ug migngezanan he Eshcol, tenged duen te sengerupung te paras he midtamped te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ne hein nepasad is 40 he andew te kebpeniid dan dutun te tanà, midlikù sikandan ");
INSERT INTO mbbOT_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","diyà te ki Moises, ki Aaron, wey ziyà te tivuuk he keet-etawan te Israel ziyà te Kadesh he ziyà te sibsivayan he Paran. Migkaǥi zan diyà te langun he menge etew zutun is neehè dan, ne impeehè dan is uwiten dan he menge prutas. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Migkeǥiyan dan si Moises te, “Midhendiyè key te lugar he impesusi nu kenami, meupiya heini wey selebpeten he tanà. Heini zed is nekuwa zey he menge prutas. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Piru mekeǥeǥehem is menge etew he ed-ubpà duen, ne utew zezekelà is menge inged dan he nengeliǥuy te verengbeng. Neehè dey pa ganì is menge kevuwazan ni Anak. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Is menge Amalikanhen diyà ed-ubpà te Negev; is menge Hitihanen, menge Jebusihanen, wey is menge Amorihanen diyà ed-ubpà te menge vuvungan; ne is menge Canaanhen diyà ed-ubpà te veyvey te zaǥat wey veyvey te Wahig he Jordan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ne impehenek ni Caleb is menge etew ziyà te etuvangan ni Moises, ne ke sikandin te, “Egenat kiw en guntaan ne ed-eǥawen tew haazà is tanà, su siguradu he egkaaǥew tew heini.” ");
INSERT INTO mbbOT_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Piru migkaǥi sikan is menge etew he zuma ni Caleb te neniid te, “Kenè kiw ebpekehimu he edsurung kandan su edhuna sikandan he melig-en kenitew.” ");
INSERT INTO mbbOT_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ne midtudtulan dan is menge Israilihanen te mekesuǥeysuǥey mehitenged duen te tanà he midsusi zan. Iyan heini migkaǥi zan, “Kenà meupiya is tanà he midsusi zey, su ebpekekaid te menge meǥinged duen, ne liyu keniyan, is menge etew he neehè dey zutun ne utew memelangkew. ");
INSERT INTO mbbOT_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Duen dey pe man ganì naahà he menge eregasi he menge kevuwazan ni Anak. Henduen dà te menge pelaǥà is ked-isipa zey te keugelingen dey emun idhindeg kandan, ne iyan daan heeyan ked-isipa zan kenami.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Dutun mismu he kezukileman nemenineǥew is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Mibegulbul sikandan diyà te ki Moises wey ki Aaron. Ke sikandan te, “Deyzey pa ke nemematey kiw en diyà te Ehipto etawa kayi te sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Maan is ed-uwiten kiw pa te Nengazen dutun he tanà? Para zè be mebpematey kiw te tebek wey ebihaǥen is menge esawa tew wey menge anak tew? Deyzey pa vuwa ke edlikù kiw ziyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ne mibpelelelaǥè dan he ke sikandan te, “Deyzey pa ke ebpilì kiw te ebpekepengulu kenitew ne edlikù kiw ziyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ne si Moises wey si Aaron midluhud diyà te etuvangan te tivuuk he keet-etawan te Israel he netiǥum dutun. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ne si Josue he anak ni Nun wey si Caleb he anak ni Jefune, mibindas dan is bisti zan tenged te kegkeseeng dan. Heini sikandan is dezuwa, miduma te kebpeniid duen te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Migkeǥiyan dan is menge Israilihanen te, “Utew meupiya sikan is tanà he mibeyaan dey. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Emun nekepenunuat kiw te Nengazen, egiyahan kiw zin te kedhendutun te tanà he meupiya wey selebpeten, ne ibeǥey zin kenitew. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kenè niw zà supaka is Nengazen. Ne kenè kew mahandek te menge etew zutun su egkezaag tew sikandan. Wazà edtavang kandan, ne sikitew mulà, edtevangan kiw te Nengazen. Umbe kenè kew mahandek kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ne zutun, ebpenulengen en pezem sikandan te vatu te menge zuma zan he Israilihanen, piru midtik-ew mebpaahà diyà te zivavew zuen te Tulda he Edtelevukaayan is mekeǥeǥehem he kebpekiduma te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Migkaǥi is Nengazen diyà te ki Moises te, “Keenu ves buwa ed-engked heini is menge etew te kedselikwey kedì? Keenu zan buwa ed-engkezi is kenè dan kedtuuwi kedì minsan neehè dan is egkengein-inuwan he mibeelan ku ziyà te kandan? ");
INSERT INTO mbbOT_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ibpaaǥi ku ziyà te kandan is kezeetan, ne edezeetan ku sikandan, piru edhimuwen ku mulà sikew he sevaha he nasyun, he edhuna pa kandan he mekeǥeǥehem wey melig-en.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ne migkeǥiyan ni Moises is Nengazen te, “Hengkey is egkekaǥi te menge Ehiptohanen emun egketudtulan sikandan mehitenged kayi? Kenè be netuenan dan he pinaaǥi te ǥehem nu migkuwa nu is menge Israilihanen puun diyà te kandan? ");
INSERT INTO mbbOT_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Emun edèdeetan nu heini is menge etew nu, edtudtulen dan heini ziyà te menge meǥinged te Canaan. Ne heini is menge Canaanhen, nezineg dan en daan he iyan ka is Nengazen nekiduma te menge Israilihanen he mibpaahà pinaaǥi te ǥapun he egiya kandan. Edhuna ka kandan emun maandew pinaaǥi te ǥapun he henduen te tukud, ne emun mezukilem pinaaǥi te hapuy he henduen daan te tukud. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ne emun egeraan nu heini he menge etew te kesevaha zà, is menge etew ziyà te menge nasyun he nekezineg te kegkevantug nu egkaǥi te, ");
INSERT INTO mbbOT_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Wazà mekehimu is Nengazen he ed-uwit te menge Israilihanen diyà te tanà he insaad din kandan, umbe mibpenhimetayan din en sikandan diyà te sibsivayan.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Umbe, ǥuntaan edhangyù a ziyà te kenikew, Nengazen, berakat he ipeehè nu is gehem nu sumalà te lalag nu he ");
INSERT INTO mbbOT_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","veliǥeǥawen ka wey kenè ka melemu he egkepauk, wey mepineseyluwen ka te menge salà wey kedrapas te etew. Piru edsilutan nu is menge mekesesalà, taman te iketelu wey ikeepat he lapis te kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tenged te zekelà he gaǥew nu, edhangyù a he peseyluwa nu is salà kayi te menge etew iring te kebpeseyluwa nu kandan puun pa te kegawas dan diyà te Ehipto.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Midtavak is Nengazen te, “Ebpeseyluwen ku sikandan sumalà te midhangyù nu. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Piru ebpenangdù a, is uuyag he Nengazen, he mintras nekepenù te tivuuk he kelibutan is mekeǥeǥehem he kebpekiduma ku, tutuu zaan he ");
INSERT INTO mbbOT_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","wazà minsan sevaha kandan he ebpekeseled diyà te tanà he insaad ku ziyà te menge kepuun dan. Su minsan neehè dan is mekeǥeǥehem he kebpekiduma ku kandan wey egkengein-inuwan he mibeelan ku ziyà te Ehipto wey ziyà te sibsivayan, layun e zan gihapun egezami wey wazè dan mebpezumazuma kedì. Umbe sikan is menge midselikwey kedì, ne kenà ebpekeseled keniyan he tanà. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Piru nekeviza mulà kandan is suluǥuen ku he si Caleb su mibpezumazuma mulà kedì te ebpuun diyà te gehinawa zin, umbe ibpeseled ku mulà duen te tanà he mibeeyaan din, ne ebpekeubpà daan is menge kevuwazan din dutun he tanà. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ne ǥuntaan, kenè kew en laus su zuen menge Canaanhen wey menge Amalikanhen he ebpen-ubpà diyà te menge suǥud, kekenà, likù kew en nasì keeselem diyà te sibisivayan he ziyà te zalan pehendiyà te Zaǥat he Meriǥà.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Keenu en buwa ed-engked he edriklamu kuntra kedì heini is lalung he menge etew? Nezineg ku is menge riklamu kayi te menge Israilihanen he menge riklemedur. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Umbe, keǥiya niw heini ziyà te kandan: ‘Siak is uuyag he Nengazen, ebpenangdù a he ebeelan ku ziyà te keniyu is migkaǥi niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ebpematey kew kayi te sibsivayan. Su mibegulbulan a keniyu, wazà minsan sevaha keniyu he ebpenuiǥen te 20 pehendiyà te metikang, ");
INSERT INTO mbbOT_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","he ebpekeseled duen te tanà he impenangdù ku he ibeǥey keniyu, gawas ki Caleb he anak ni Jefune wey ki Josue he anak ni Nun. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ne sikan mulà is menge anak niw he egkeǥiyen niw he ebihaǥen, ne ed-uwiten ku sikandan duen te tanà he mid-engkezan niw ne egkaangken dan heini. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Piru sikiyu ebpematey kew kayi te sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Is menge anak niw, egkeiring te ed-elima te kerehidu he ebpekeriǥuriǥu kayi te sibsivayan seled te 40 he tuig. Ne tenged kayi egkerasey sikandan tenged te keniyu he kedluib kediey taman te ebpematey kew is langun. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ne geina te 40 he andew is kebpeniizi te menge meniniid duen te tanà, ne ebpekaantus kew zaan te 40 he tuig tenged te menge salè niw, wey niw metueni ke hengkey is ebeelan ku ke egkepeukan ku is ebpekigkuntada kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Iyan a is Nengazen migkaǥi kayi, ne kenà ebperis is kebeeli ku te nekaǥi ku he ebeelan ku kayi te mezaat he menge etew he nesevaha he egkuntada kedì. Ebpematey sikandan is langun kayi te sibsivayan.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Ne zutun, sikan is menge etew he midsuǥù ni Moises te kebpeniid he nenudtul te mezaat mehitenged duen te tanà he iyan nehimu he hinungdan te kebegulbul te menge Israilihanen, ne nematey te zaru ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Duen te 12 he menge meniniid ne iyan dà wazà mebpatey, si Josue he anak ni Nun wey si Caleb he anak ni Jefune. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ne hein midtudtul haazà ni Moises diyà te langun he menge Israilihanen, neseeng sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ne hein sunud he andew midsayu sikandan med-enew su edtekezeg sikandan diyà te menge vuvungan te Canaan. Ke sikandan te, “Netuenan dey he nekesalè key, ne ǥuntaan andam key en he edhendiyà te lugar he insaad te Nengazen!” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Piru migkaǥi si Moises te, “Maan is edsupaken niw en maan guntaan is insuǥù te Nengazen he medlikù kew zèpa ziyà te sibsivayan? Kenè kew ebmezeeǥen! ");
INSERT INTO mbbOT_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kenè kew ǥenat, su is Nengazen wazà mebpekiduma keniyu, ne egkezaag kew te menge kuntada niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Emun ebpekidtebek keniyu is menge Canaanhen wey menge Amalikanhen ne ebpemematey kew; kenà ebpekiduma is Nengazen keniyu su inselikwey niw sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Piru midhendiyà gihapun sikandan te menge vuvungan te Canaan minsan kenè dan duma si Moises wey sikan is Kavan te Kebpekid-uyun te Nengazen kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ne midsurung kandan is menge Amalikanhen wey menge Canaanhen he meǥinged dutun te menge vuvungan, ne nezaag sikandan, ne midal-as sikandan taman te Horma. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","he keǥiya zin heini ziyà te menge Israilihanen: “Emun diyè kew en te tanà he ibeǥey ku keniyu he egkeubpaan niw, ");
INSERT INTO mbbOT_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ne pemuhat kew te para kediey te menge ibpemuhat he ebpuun te menge uyaǥen niw. Pemuhat kew te menge pemuhat he edtutungen, menge pemuhat para te kedtuman te menge penaad, menge pemuhat he kineugelingen he suat, etawa menge pemuhat para te kedsilibra te menge pista. Is kehemut kayi te menge pemuhat he pinaaǥi te hapuy ne ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Is ebpemuhat te nati he kerehidu he pemuhat he edtutungen para kedì ne mebpemuhat daan te pemuhat he para gasa. Heini he pemuhat is para gasa kinahanglan he zezuwa he kilu he meupiya he kelasi he herina he edsehuǥan te senge litru he lana. Ne edlepikan heini te pemuhat he inumen he senge litru he vinu. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Emun meǥurang en he kerehidu is ibpemuhat niw, lepiki niw heini te pemuhat he para gasa he heepat he kilu he meupiya he kelasi he herina he edsehuǥan te senge litru wey tengà he lana. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ne edlepikan daan heini te pemuhat he inumen he senge litru wey tengà he vinu. Is kehemut kayi he pemuhat ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Is ebpemuhat te turiti he vaka he pemuhat he edtutungen etawa pemuhat para te kedtuman te penaad, etawa pemuhat he para te meupiya he kedepità, ");
INSERT INTO mbbOT_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","kinahanglan he mebpemuhat daan sikandin te pemuhat he para gasa he heenem he kilu he meupiya he kelasi te herina he edsehuǥan te zezuwa he litru he lana. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Edlepikan pa heini te pemuhat he inumen he zezuwa he litru he vinu. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Iyan heeyan beeli niw emun ebpemuhat kew te tudu he vaka etawa meǥurang en he meemahan he kerehidu etawa nati he kerehidu etawa kambing. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Beeli niw heeyan diyà te kada sevaha he uyaǥen he ibpemuhat niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Is langun he tutuu he Israilihanen he ebpemuhat te menge pemuhat pinaaǥi te hapuy he mehemut he pemuhat he ebpekepenunuat kedì, kinahanglan he edsunud keniyan he menge sulunuzen. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ne is kenà menge Israilihanen he ed-ubpà duma keniyu, pirmeninti etawa kenà, he egkesuat he ebpemuhat te pemuhat pinaaǥi te hapuy he mehemut he pemuhat he ebpekepenunuat kedì, kinahanglan he edsunud dan daan keniyan he menge sulunuzen. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Sikiyu is menge Israilihanen wey kenà menge Israilihanen he mid-ubpà duma keniyu ne neked-iring dà kayi te etuvangan ku, ne neked-iring dà he kesuǥuan is edtumanen niw. Heini he sulunuzen kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Uya, neked-iring dà he menge suǥù wey menge sulunuzen is kinahanglan he edtumanen niw te menge Israilihanen wey is kenà menge Israilihanen he mid-ubpà duma keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Midsuǥù pa te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","he keǥiya zin heini ziyà te menge Israilihanen: “Emun diyè kew en te tanà he ibeǥey ku keniyu, ");
INSERT INTO mbbOT_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ebpekekaan kew te sebpet kayi. Piru kinahanglan he edtapid kew zutun te para ibpemuhat niw kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pemuhat kew te supas he iyan ebeelan niw is herina he egkehuna he ǥinaling niw, iring te ebeelan niw ziyà te egkehuna he sebpet te trigu niw he ebpuun te gunasà. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Heini is pemuhat he ebpuun diyà te egkehuna he ginaling niw he herina, ne ipemuhat niw kayi te kedì taman te huziyan he lapis te menge kevuwazan niw taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“Ne penenglitan, sikiyu is menge keet-etawan, nekerapas kew he wazè niw tivevaa zuen te sevaha te menge suǥù he imbeǥey ku ki Moises. (Ne heini he menge suǥù imbeǥey ku keniyu pinaaǥi ki Moises kinahanglan he edtumanen niw heini puun te andew te kebeǥaya ku kayi taman te taman.) ");
INSERT INTO mbbOT_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Ne emun wazè niw tivevaa is kedrapas niw kayi, su wazè niw metueni he nekerapas kew, sikiyu wey is langun he keet-etawan mebpemuhat kew te sevaha he turiti he vaka he iyan pemuhat he edtutungen hein netuenan niw he nekesalè kew. Pemuhat heini he ebpekepenunuat kedì is kehemut din. Ilapik niw kayi is egkinehenglanen he pemuhat he para gasa wey pemuhat he inumen, wey sevaha he meemahan he kambing he pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ibpemuhat heini te memumuhat para mevelukasi is langun keniyu tenged te salè dan. Ebpeseyluwen ku sikandan su wazè dan man haazà tivevaa, wey mid-uwit man daan sikandan te pemuhat pinaaǥi te hapuy wey pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Uya, ebpeseyluwen ku is tivuuk he keet-etawan te Israel, ragkes is kenà menge Israilihanen he emurè dan te inged, su neuwit-uwit is langun dutun te salà he wazà tivevaa. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Ne emun sevaha zà he etew is nekesalà te wazà tivevaa, ne med-uwit sikandin te sevaha he vehiyan he kambing he senge-tuig is keǥurang din he pemuhat he para idlumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ibpemuhat heini te memumuhat diyà te etuvangan ku su para mevelukasi haazà he etew tenged te salè din he wazè din tivevaa ne ebpeseyluwen ku sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Neked-iring dà is sulunuzen he para zuen te nekesalà he wazè din tivevaa, Israilihanen man etawa kenà Israilihanen he emurè niw te inged. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Piru sikan is midtivevà is kebaal zin te salà, Israilihanen man etawa kenà, ne midsumpalit e zin. Ne kinahanglan he kenè en sikandin egkilelaan he zuma niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Su inselikwey zin is lalag ku wey midsupak din is suǥù ku. Kenè niw sikandin kilelaa he sakup niw. Ne televaken din is salè din.” ");
INSERT INTO mbbOT_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Hein diyà te sibsivayan is menge Israilihanen, duen etew he neehè dan he nengayu zutun te Andew te Kedhimeley. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Miduma sikandin duen te menge etew he nekaahà kandin diyà te ki Moises wey ki Aaron wey ziyà te kezekelan. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ne mibpirisu zan sikandin su wazè dan pa mekesiguru ke hengkey is ereg he ebeelan dan kandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ne migkaǥi is Nengazen diyà te ki Moises te, “Kinahanglan he edhimetayan haazà he etew, ibpetuleng sikandin te vatu te langun, diyà te ǥawas te kampu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Umbe, mid-uwit sikandin te menge etew pehendiyà te ǥawas te kampu ne mibpenuleng dan te vatu taman te minatey, sumalà te insuǥù te Nengazen ki Moises. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","he keǥiya zin heini ziyà te menge Israilihanen: “Teuzi niw te egkengevitey is sidsid te visti niw ne teuzi niw te hiket he meitem is kaavuavu zin. Kinahanglan he ed-ul-ulahan niw heini wey te huziyan he lapis te menge kevuwazan niw taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Heini is egkengevitey, ebpetanudtanud keniyu te langun he menge suǥù ku su wey niw tumana heini ne kenà iyan is keniyu zà he egkesuatan te ebaal. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Pinaaǥi kayi te egkengevitey edtentenuzan niw is kedtuman te langun he menge suǥù ku, ne egkehimu kew he ǥaked ku. ");
INSERT INTO mbbOT_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Iyan a is Nengazen he Megbevayè niw mibpeǥawas keniyu ziyà te Ehipto su wey a mehimu he Megbevayè niw. Uya, iyan a Nengazen he Megbevayè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Dutun he timpu, nekidsukulà ki Moises si Kora he anak ni Izhar, te anak ni Kohat te anak ni Levi. Duma zin te nekidsukulà si Datan wey si Abiram he menge anak ni Eliab, wey si On he anak ni Pelet he pudu kevuwazan ni Reuben. Duen pa zuma zan he 250 he menge Israilihanen he menge maama he nekilala wey mibpilì he menge pengulu te Israel puun te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Midsevaha sikandan medhendiyà te ki Moises wey ki Aaron, he ke sikandan te, “Subre en heini is ebeelan niw kenami! Maan is ibpelavew niw is keugelingen niw kayi te mahabet he menge etew te Nengazen he mibpilì man pezem te Nengazen is tivuuk he menge Israilihanen he ebpenilbi kandin ne ebpekiduma zaan sikandin kayi?” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kegkezineǥa ni Moises kayi, midluhud sikandin is nengemuyù diyà te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","6","Ne migkeǥiyan din si Kora wey is langun he sumusunud kandin te, “Keeselem ke meselem ibpezayag te Nengazen ke hentei is tutuu he mibpilì din he ebpenilbi kandin pinaaǥi te kegkememumuhat, su ibpeuvey zin diyà te etuvangan din is mibpilì din. Umbe iyan heini veeli niw keeselem: Kuwa kew te teleǥuey te menge veyewà, ");
INSERT INTO mbbOT_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ne sevuki niw heini te vaǥa wey beyewà, ne uwita niw ziyà te etuvangan te Nengazen. Ne egkeehè tew ke hentei is mibpilì te Nengazen he ebpenilbi kandin. Iyan kew is menge Levihanen, mibpesubra te ebeelan niw!” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Migkaǥi pa si Moises diyà te ki Kora te, “Pemineg kew kayi is menge Levihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kenè pe be ereg para keniyu he ziyà te tivuuk he keet-etawan te Israel iyan kew mibpilì te Megbevayà te Israel he ebpekeuvey ziyà te etuvangan din pinaaǥi te kebpenilbi niw ziyà te Tulda zin wey kebpenilbi niw te kezekelan? ");
INSERT INTO mbbOT_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Mibpilì kew zin he ebpenilbi kandin, ne ǥuntaan egkesuat kew pa he egkehimu he memumuhat? ");
INSERT INTO mbbOT_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Sikew wey is menge sumusunud kenikew, nekidsukulà te Nengazen ne kenà diyà te ki Aaron.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ne kegkepasad dutun, impetawag ni Moises si Datan wey si Abiram, he menge anak ni Eliab. Piru migkaǥi sikandan te, “Kenè key edhendiyan! ");
INSERT INTO mbbOT_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kenè pe be ereg is kegkuwaa nu kenami ziyà te Ehipto he meupiya wey uuzaran is tanà duen su wey key kenikew mehimetayi kayi te sibsivayan? Ne ǥuntaan egkesuat ke pa he edhadìhadì kenami. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ne liyu keniyan, wazè key kenikew dumaha ziyà te tanà he meupiya wey selebpeten wey wazè key kenikew veǥayi te menge vevesukà etawa pemuleey te paras he egkaangken dey. Ne ǥuntaan, egkesuat ke pa he edtuntu kenami? Kenè key edhendiyan te kenikew!” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ne utew nepauk si Moises ne ke sikandin diyà te Nengazen te, “Kenè nu zewata is menge pemuhat dan. Wazà a mekesalà diyà te minsan hentei kandan; wazà minsan sevaha he asnu he migkuwa ku ziyà te kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Migkeǥiyan ni Moises si Kora te, “Keeselem, sikew wey is menge sumusunud nu, hendiyè kew te etuvangan te Nengazen diyà te Tulda he Edtelevukaayan, su edhendiyà daan si Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Is kada sevaha zuen te 250 he menge sumusunud nu, ipeuwit nu te teleǥuey te veyewà ne peteǥui nu kandan te veyewà, he para te ibpemuhat diyà te Nengazen. Ne sikiyu ki Aaron, uwit kew zaan te tigselimbaha he teleǥuey te veyewà.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Umbe, migkuwa is kada sevaha kandan te keugelingen din he teleǥuey ne midteǥuan din haazà te veyewà wey vaǥa, ne midhitindeg sikandan duma ki Moises wey ki Aaron diyà te gemawan te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ne hein netiǥum en ni Kora is menge sumusunud kandin diyà te etuvangan ni Moises wey ni Aaron, diyà te ǥemawan te Tulda he Edtelevukaayan, mibpeehè en te langun he etew zutun is mekeǥeǥehem he kebpekiduma te Nengazen kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Migkeǥiyan te Nengazen si Moises wey si Aaron, ");
INSERT INTO mbbOT_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Pekeziyù kew kayi te menge etew su ebpenhimetayan ku sikandan guntaan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Piru midluhud si Moises wey si Aaron he ke sikandan te, “He Megbevayà he ebpuunan te untung te langun he menge etew, edelehiǥen nu ve te pauk nu is langun he etew kayi te sevaha zè man is nekesalà?” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Keǥiyi nu is menge etew he mebpekeziyù dan diyà te menge tulda keniyan te tetelu he si Kora, si Datan, wey si Abiram.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ne mibeyaan ni Moises si Datan wey si Abiram, ne midtinundug kandin is menge perezumala te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ne migkeǥiyan din is menge etew te, “Pekeziyù kew ziyà te menge tulda keniyan te lalung he menge etew! Kenè kew ǥawed te minsan hengkey he ǥaked dan, su emun ebeelan niw heini ne edèdeetan kew tenged te langun he menge salè dan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Umbe, mibpekeziyù is menge etew puun dutun te menge tulda ni Kora, ni Datan, wey ni Abiram. Ne migawas si Datan wey si Abiram ne midhitindeg dan diyà te ǥemawan te menge tulda zan duma te menge esawa zan wey menge anak dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Migkeǥiyan ni Moises is menge etew te, “Pinaaǥi kayi egketuenan niw he iyan midsuǥù kedì is Nengazen te kebaal kayi he menge vaal, ne kenà kediey zà he suat! ");
INSERT INTO mbbOT_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Emun netural he kemetayen is ibpatey kayi he menge etew, ne wazè e ves suǥua te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Iyan, emun edhimu is Nengazen te egkein-inuwan, ne ebeka is tanà he ed-eveleng kandan he uuyag duma te langun he menge azen dan pehendiyà te kelibutan te menge minatey, ne egketuenan niw he heini he menge etew inselikwey zan is Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ne hein nekepasad si Moises he egkaǥi, mibeka is tanà he nehitindeǥan ni Datan wey ni Abiram. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ne mid-eveleng sikandan duma is pemilya zan te tanà, duma is langun he menge sumusunud ki Kora wey is langun he azen dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Uuyag sikandan is langun he mid-eveleng te tanà duma is langun he azen dan. Nekedlikuey is tanà ne nahanew sikandan puun te kezekelan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Is langun he menge Israilihanen he nekeliǥuy kandan mibpekeziyù hein nezineg dan is kulehian duen te menge etew, su neisip dan he kela ke elin sikandan evelenga te tanà. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ne mibpengelinteuwan te Nengazen he medtuvù is hapuy ne neepur sikan is 250 he menge sumusunud ni Kora he nemuhat te veyewà. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Migkeǥiyan te Nengazen si Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Keǥiyi nu si Eleazar he memumuhat, he anak ni Aaron, he kuwaa zin sikan is menge teleǥuey te veyewà duen te nemematey te kegketutung, su segradu heini he menge teleǥuey. Keǥiyi nu zaan sikandin he ipeyapat din diyà te meziyù sikan is menge vaǥa ");
INSERT INTO mbbOT_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","zuen te menge teleǥuey he ebpuun duen te menge etew he nemematey tenged te menge salè dan. Ne ipelumpipì nu kandin sikan is menge teleǥuey ne ipekaple din haazà duen te pemuhatà su inhalad heini kayi te kediey ne nehimu heini he segradu. Ne heini he pekaplà duen te pemuhatà ne egkehimu he petizaan te menge Israilihanen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","Ne tenged dutun te insuǥù te Nengazen pinaaǥi ki Moises, mibpenguwa ni Eleazar he memumuhat sikan is brunsi he menge teleǥuey te veyewà he uwiten duen te nengevinsulan, ne midlumpipì din heini su ibpekaple din duen te pemuhatà. Ne sevaha heini he petizaan te menge Israilihanen, he wazà minsan sevaha kandan he midtuǥutan te ked-uvey ziyà te pemuhatà te kedtutung te veyewà para te Nengazen gawas te menge kevuwazan ni Aaron, ne emun ebeelan dan heini egkeiring dan ki Kora wey te menge sumusunud kandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ne sunud he andew, midriklamu en maan is tivuuk he keet-etawan te Israel ziyà te ki Moises wey ki Aaron. Ke sikandan te, “Mibpenhimetayan niw is menge etew te Nengazen.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Dutun te kedtiǥum dan su ibpetuenan dan ki Moises wey ki Aaron is menge riklamu zan, midsinaru zan diyà te Tulda he Edtelevukaayan ne neehè dan he netembunan heini te ǥapun ne impaahà te Nengazen is mekeǥeǥehem he kebpekiduma zin. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ne midhendiyà si Moises wey si Aaron te egkesineruwan duen te Tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ne migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Pekeziyù kew keniyan te menge etew su segugunè ku sikandan edèdeeti.” Ne midluhud sikandan is dezuwa. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ne migkeǥiyan ni Moises si Aaron te, “Kuwaa nu is teleǥuey nu te veyewà ne teǥui nu te veyewà wey vaǥa he ebpuun diyà te pemuhatà. Ne gaanggaan ka hendiyà te menge etew ne veeli nu is tulumanen su wey zan mevelukasi te menge salè dan, su nepauk en is Nengazen ne ebpuun en is limas.” ");
INSERT INTO mbbOT_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ne midtuman ni Aaron haazà is insuǥù ni Moises, ne mibpelelaǥuy sikandin pehendiyà te teliwazà te menge etew. Mibpuun en is kedlimasa zutun te menge etew, piru impemuhat gihapun ni Aaron sikan is beyewà su wey mevelukasi haazà is menge etew tenged te menge salè dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Midhitindeg sikandin diyà te pid-elangan te nemematey wey menge uuyag ne neengked is kebpematey zan. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Piru 14,700 is nemematey tenged dutun he kezeetan kenà ragkes is nemematey tenged ki Kora. ");
INSERT INTO mbbOT_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ne midlikù si Aaron diyà te ki Moises duen te ǥemawan te Tulda he Edtelevukaayan su neengked en sikan is kezeetan. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Keǥiyi nu is menge Israilihanen he mebeǥey te tuked diyà te kenikew is kada pengulu te tribu. Ne pesurati heini te kada ngazan dan. 12 langun he tuked. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Diyà te tuked te tribu ni Levi, ne idsurat dutun is ngazan ni Aaron su kinahanglan he zuen sevaha he tuked te kada pengulu te tribu. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ne ziyà heini idsavuk is langun te Tulda he Edtelevukaayan, diyà te egkesineruwan duen te Kavan te Kebpekid-uyun he zutun a ebpekidhinguma keniyu ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ne zutun ebpeneringsing is tuked te etew he ebpilien ku he ebpenilbi kedì pinaaǥi te kegkememumuhat ne pinaaǥi kayi egkeengked en is kedriklamu te menge Israilihanen ki Aaron wey kenikew.” ");
INSERT INTO mbbOT_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Umbe, migkeǥiyan ni Moises is menge Israilihanen, ne is kada pengulu mibeǥey kandin te tuked. 12 langun he tuked, ne in-amut dutun is ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Insavuk ni Moises haazà is langun he tuked diyà te etuvangan te Nengazen diyà te Tulda he midsevukan te Kesuǥuan. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ne hein nepawà, midseled si Moises duen te Tulda he midsevukan te Kesuǥuan. Ne neehè din is tuked ni Aaron he midriprisintar te tribu ni Levi, ne kenè dà te neneringsing heini, kekena, midtuvù, nengevukad, wey nemeǥas te almindru. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ne inggawas ni Moises is langun he tuked ne impeehè din te langun he menge Israilihanen. Mid-ehè dan heini, ne migkuwa te kada pengulu te tribu is kandin he tuked. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ne migkaǥi is Nengazen diyà te ki Moises te, “Ilikù nu heeyan is tuked ni Aaron diyà te etuvangan duen te Kavan te Kebpekid-uyun ku su para mehimu heini he petizaan diyà te menge mesinupaken he ebpematey sikandan emun kenè dan ed-engked he edriklamu kayi te kedì.” ");
INSERT INTO mbbOT_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Midtuman ni Moises is insuǥù kandin te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Migkaǥi is menge Israilihanen diyà te ki Moises te, “Emun iyan heeyan ne ebpematey key en bes is langun! ");
INSERT INTO mbbOT_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Su ebpatey man is minsan ed-uvey zà diyà te Tulda te Nengazen. Ne ebpatey key ves is langun pinaaǥi kayi!” ");
INSERT INTO mbbOT_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Migkeǥiyan te Nengazen si Aaron te, “Sikew wey is menge anak nu he maama wey is menge kezuzumahi nu he ebpuun diyà te tribu ni Levi, keniyu he televaken is salà he egkeveelan niw zutun te kebpenilbi niw ziyà te Tulda he Edtelevukaayan. Piru iyan ke zà wey is menge anak nu is ebpekepenavak te salà he egkeveelan niw zutun te kegkememumuhat niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Emun ebpenilbi ka wey is menge anak nu ziyà te Tulda he midsevukan te Kesuǥuan, ipeuǥup niw is menge kezuzumahi niw he ebpuun diyà te tribu ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Edterabahu sikandan he zizalem te kedumala nu, ne veeli zan is langun he vuluhaten duen te Tulda, piru kinahanglan he kenà sikandan medhilavet te segradu he menge gelemiten duen te Tulda etawa pemuhatà, su emun ebeelan dan haazà ne ebpemematey zan ne ragkes kew pa. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Edtavang sikandan kenikew, ne kandan he ketengdanan is ked-atur zuen te Tulda he Edtelevukaayan wey is kebaal te langun he vuluhaten kayi. Piru kinahanglan he wazà minsan hentei he ed-uǥup keniyu he kenà kevuwazan ni Levi. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Ne kenikew he ketengdanan wey te menge anak nu is ked-atur zuen te Segradu he Lugar wey te pemuhatà, para kenè ku en meumani mepeuki is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Iyan a mismu mibpilì te menge zuma nu he menge kevuwazan ni Levi puun te menge Israilihanen su wey zan mekeuǥup kenikew. Impehinungud sikandan kayi te kediey su wey zan mekepenilbi ziyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Piru iyan ke zà wey is menge anak nu ebpekepenilbi pinaaǥi te kegkememumuhat, su iyan kew zà ebpekevaal te vuluhaten diyà te pemuhatà wey ziyà te Utew Segradu he Lugar. Gasa ku keniyu is kegkememumuhat niw. Is minsan hentei he ebaal kayi he kenà memumuhat ne edhimetayan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ne migkaǥi is Nengazen diyà te ki Aaron te, “Iyan a mismu mibpilì kenikew para iyan ka mekezumala te vuluhaten para te segradu he menge pemuhat he ibpemuhat te menge Israilihanen kayi te kediey. Ibeǥey ku heini kenikew wey ziyà te menge anak nu he keniyu he vahin guntaan wey taman te taman. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Duen niw vahin duen te segradu he menge pemuhat he kenà edtutungen, he ibpemuhat te menge etew kayi te kedì he segradu he menge pemuhat. Ragkes en kayi is menge pemuhat he para gasa, pemuhat he para idlumpiyu, wey pemuhat he vayad te salà. Iyan heini vahin niw te menge anak nu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Keena niw heini ziyà te utew mahal he lugar. Iyan dà is menge maama ebpekekaan kayi ne isipa niw heini he segradu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Is duma he pemuhat te menge Israilihanen he ibayew ziyà te pemuhatà, ne para zaan keniyu. Imbeǥey ku heini kenikew wey te menge kevuwazan nu he keniyu he vahin taman te taman. Ebpekekaan kayi is minsan hentei ziyà te pemilya nu he ed-isipen he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Imbeǥey ku zaan keniyu is meupiya he menge sebpet he idhalad te menge Israilihanen he ebpuun te egkehuna he sebpet dan: lana te ulibu, binu, wey trigu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Uya, egkehimu he keniyu is langun he menge sebpet dan he idhalad dan kayi te kedì he ebpuun diyà egkehuna he egkeraǥun dan diyà te tanè dan. Ebpekekaan kayi is minsan hentei ziyà te pemilya nu he ed-isipen he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Is langun he menge vutang te menge Israilihanen he ebpuun te keputian te atey is kebeǥaya zuen kayi te kedì, ne egkehimu he keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Is langun he kinekekayan he anak he maama, etew man etawa uyaǥen, he idhalad kayi te kediey ne keniyu zaan. Piru kinahanglan he ibpelekat niw is menge kinekekayan he menge anak he maama wey is menge kinekekayan he menge uyaǥen he ed-isipen he meremerik. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ipelekat niw heini emun senge vulan en is keǥurang dan, ne kinahanglan he ipelekat niw heini te lelima he vuuk he pelata, he ibpesikad diyà te keveǥat te pelata ziyà te timbangan he egemiten te menge memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Piru kenè niw mulà ipelekat is kinekekayan he tudu he vaka, kerehidu, etawa kambing su kediey en haazà. Lepaa niw heini ne ipirik niw is lengesa kayi ziyà te pemuhatà ne tutunga niw is menge tavà he pemuhat pinaaǥi te hapuy. Is kehemut kayi he pemuhat te pinaaǥi te hapuy ne ebpekepenunuat kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Keniyu is usa kayi, iring te kumeng wey kewanan he vuvun te pemuhat he ibayew he keniyu zaan. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Uya, ibeǥey ku keniyu heini is langun he menge segradu he pemuhat he ibayew te menge Israilihanen kayi te kedì. Para heini kenikew wey te menge kevuwazan nu he iyan keniyu he vahin taman te taman. Iyan heini kebpekid-uyun ku kenikew wey te menge kevuwazan nu he kenà egkahalin taman te taman.” ");
INSERT INTO mbbOT_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Migkaǥi pa is Nengazen diyà te ki Aaron te, “Sikiyu is menge memumuhat, wazè niw egkepengevilin he tanà te Israel, su iyan a mismu ebeǥey te menge kinehenglanen niw. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Ne sikan is menge Levihanen, ebeyazan ku sikandan te kebpenilbi zan diyà te Tulda. Ibeǥey ku kandan is langun he ikepulù he ibeǥey te menge Israilihanen he kandan he egkepengevilin. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Puun guntaan wazè en menge Israilihanen he ebpekeuvey zuen te Tulda he Edtelevukaayan gawas te menge memumuhat wey menge Levihanen, su emun ed-uvey sikandan, televaken dan is salè dan ne ebpatey sikandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Is menge Levihanen, kandan he ketengdanan is menge vuluhaten diyà te Tulda he Edtelevukaayan, ne televaken dan is egkehimu zan he salà kayi te vuluhaten dan. Heini he sulunuzen kinahanglan he tumana niw taman te huziyan he lapis te menge kevuwazan. Is menge Levihanen ne wazà egkepengevilin dan he tanà te Israel. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Hinuun, ibeǥey ku kandan he kandan he vahin is menge ikepulù he ibeǥey te menge Israilihanen he halad dan kayi te kediey. Umbe migkaǥi a he is menge Levihanen wazà egkepengevilin dan he tanà te Israel.” ");
INSERT INTO mbbOT_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Midsuǥù te Nengazen si Moises ");
INSERT INTO mbbOT_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","he keǥiya zin heini ziyà te menge Levihanen: “Emun egkezawat niw puun te menge Israilihanen is ikepulù he ibeǥey ku keniyu he iyan bahin niw, kinahanglan he veǥey kew zaan te ikepulù niw puun dutun te ikepulù, ne ihalad niw haazà kayi te kedì. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ne ed-isipen ku heini he halad niw he ebpuun te menge sebpet, he iring te midhalad kew te trigu he ebpuun diyà te ǥunasà etawa vinu he ebpuun diyà te keresà te paras. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Pinaaǥi kayi ebpekeveǥey kew zaan te halad kayi te kedì puun te langun he ikepulù he egkezawat niw ziyà te menge Israilihanen. Ne is kediey he vahin he iyan is ikepulù te ikepulù he egkezawat niw ne iveǥey niw ziyà te ki Aaron he memumuhat. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kinahanglan he iyan niw ivahin kedì is kineupiyahan he vahin he ibeǥey keniyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Emun igkahalad niw en is kineupiyahan he vahin, ed-isipen ku heini he halad niw he ebpuun diyà te ǥunasà etawa keresà te paras. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Egkehimu he egkeenen niw wey te pemilya niw is keniyu he vahin diyà te minsan hendei, su suhul niw heeyan tenged te kebpenilbi niw ziyà te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kenè kew ebpekesalà emun egkeenen niw heini emun ingkahalad niw en is kineupiyahan he vahin kayi ziyà te Nengazen. Umbe siguruwa niw he kenè niw egkependezeisek is segradu he menge halad te menge Israilihanen pinaaǥi te kegkeena niw te vahin niw te wazè niw pa ikeveǥey is kediey he vahin, su wey kew kenà mebpatey.” ");
INSERT INTO mbbOT_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Migkeǥiyan te Nengazen si Moises wey si Aaron te, ");
INSERT INTO mbbOT_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Heini pa is sulunuzen he egkesuatan ku he tumana niw: Keǥiyi niw is menge Israilihanen he uwiti kew zan te sevaha he behiyan he vaka he meriǥà he wazè din sazir he wazè pa keenu meǥamit te ked-eradu. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Iveǥey niw haazà diyà te ki Eleazar he memumuhat, ne ed-uwiten heini ziyà te gawas te kampu ne edlepaan diyà te etuvangan din. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ne egkuwa si Eleazar te lengesa kayi pinaaǥi te tezù din, ne ibpirik din haazà te kepipitu ziyà te egkesineruwan duen te Tulda he Edtelevukaayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ne zutun te edtengteng si Eleazar ne edtutungen heini is senge vuuk he vaka: is lundis, is sapù, is lengesa, wey is menge vituka. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ne egkuwa si Eleazar te tamped te kayu he sidru, sengerupung te pinemula he isupu, wey meriǥà he hiket ne idtimbag heini is langun dutun te ebinsulan he vaka. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ne kegkepasad dutun kinahanglan he ebpìpian ni Eleazar he memumuhat is bisti zin, ne mebpemeziǥù sikandin. Ne kegkepasad egkehimu en sikandin he edseled diyà te kampu, piru ed-isipen pa ǥihapun sikandin he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Is etew he mibinsul zuen te vaka, kinahanglan he ebpìpian din daan is bisti zin wey ebpemeziǥù ne ed-isipen daan sikandin he meremerik taman te mezukilem. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Is etew he ed-isipen he lumpiyu iyan megkuwa te igmuk duen te vaka, ne isavuk din haazà diyà te lugar he ed-isipen he lumpiyu, he ziyà te gawas te kampu. Ne edtipiǥan heini zutun su egemiten te menge Israilihanen he idsahug te wahig he egemiten te kebpenlumpiyu. Ebeelan heini he tulumanen su para maawà is salà. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Is etew he egkuwa te igmuk duen te vaka, kinahanglan daan he ebpìpian din is bisti zin, ne ed-isipen daan sikandin he meremerik taman te egkesakep. Heini he sulunuzen kinahanglan he edtumanen niw te menge Israilihanen wey te kenà menge Israilihanen he zuma niw he meǥinged taman te taman.” ");
INSERT INTO mbbOT_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Is minsan hentei he ebpekeǥawed te minatey, ed-isipen he meremerik seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Kinahanglan he edlumpiyuwan din is keugelingen din duen te wahig he egemiten te kebpenlumpiyu te iketelu wey ikepitu he andew, ne zutun ed-isipen en sikandin he lumpiyu. Iyan, emun kenà sikandin ebpekelumpiyu te iketelu wey ikepitu he andew, kenà sikandin ed-isipen he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Is minsan hentei he ebpekeǥawed te minatey he kenè din edlumpiyuwan is keugelingen din ne midremerikan din is Tulda te Nengazen. Kinahanglan he haazà he etew, kenà ed-isipen he sakup niw. Ne tenged te wazà sikandin mepiriki zuen te wahig he egemiten te kebpenlumpiyu, kenà egkaawà is kegkeremeriki kandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Iyan heini sulunuzen he edsunuzen emun duen ebpatey ziyà te sevaha he tulda: Is minsan hentei he edseled dutun te tulda etawa zutun en he zaan te tulda he mibpetayan, ed-isipen he meremerik seled te pitu he andew. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ed-isipen daan he meremerik is minsan hengkey he teleǥuey he wazè din tangeb he ziyà te seled te tulda. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ed-isipen daan he meremerik seled te pitu he andew is minsan hentei he ziyà te gawas te kampu he nekeǥawed te etew he minatey pinaaǥi te ispada etawa netural he kemetayen. Iring din daan is nekesamsam te tulan te etew he minatey etawa leveng. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ne para maawà is kegkeremeriki, idtaǥù diyà te teleǥuey is igmuk te vaka he ibpemuhat para te idlumpiyu, ne edwehiǥan heini. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ne is etew he ed-isipen he lumpiyu, ne megkuwa te senge rupung he isupu, ne ibpevudseng din heini zuen te wahig ne ipirik din diyà te tulda he mibpetayan wey ziyà te langun he gelemiten kayi, wey is menge etew zutun te tulda. Ebpirikan daan is etew he nekesamsam te tulan te minatey he etew, leveng, etawa minatey he etew he nevunù etawa minatey te netural he kemetayen. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Dutun te iketelu wey ikepitu he andew, ebpirikan te etew he ed-isipen he lumpiyu is etew he mid-isip he meremerik. Ne emun ikepitu he andew, haazà is etew he midlumpiyuwan kinahanglan he ebpemìpì te visti zin wey ebpemeziǥù, ne zutun te kegkesakep ed-isipen en sikandin he lumpiyu. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Iyan, emun kenà ebpenlumpiyu is etew he meremerik, ne kinahanglan he kenà sikandin ed-isipen he zuma niw su midremerikan din is Tulda te Nengazen. Su wazà sikandin mepiriki te wahig he egemiten te kedlumpiyu, meremerik sikandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Heini he sulunuzen kinahanglan he edtumanen taman te taman. “Is etew he ebpirik te wahig he gelemiten te kedlumpiyu kinahanglan daan he ebpemìpì te visti zin, wey is minsan hentei he nekesamsam duen te wahig he gelemiten te kebpenlumpiyu ed-isipen he meremerik taman te egkesakep. ");
INSERT INTO mbbOT_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Is minsan hentei etawa minsan hengkey he egkesamsam te etew he meremerik, ne ebmeremerik daan taman te egkesakep.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hein nehuna he vulan nekeuma is tivuuk he keet-etawan te Israel ziyà te sibsivayan he Zin, ne migkampu zan diyà te Kadesh. Dutun mebpatey si Miriam wey zutun daan ileveng. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Wazà wahig dutun he lugar, umbe midsevehe en maan is menge etew te kebpekigkuntada ki Moises wey ki Aaron. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Mibasul zan si Moises; ne ke sikandan te, “Deyzey pa ke minatey key en duma te menge zuma zey zengan he nemematey ziyà te etuvangan te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Maan is miduma key kenikew is menge etew te Nengazen kayi te sibsivayan su wey key mebpatey zuma te menge uyaǥen dey. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Maan is impeǥawas key pa kenikew ziyà te Ehipto ne kayi key kenikew dumaha te wazè din pulus he lugar he wazà duen minsan trigu, higus, paras, etawa pumigranata? Ne wazè pa wahig he egkeinum!” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Umbe, mid-awà si Moises wey si Aaron diyà te menge etew, ne midhendiyè dan te gemawan te Tulda he Edtelevukaayan, ne midluhud dan is ebpengemuyù. Ne mibpaahà kandan is mekeǥeǥehem he kebpekiduma te Nengazen. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Migkaǥi is Nengazen diyà te ki Moises te, ");
INSERT INTO mbbOT_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kuwaa nu sikan is tuked nu ne tiǥuma niw zuen te suled nu he si Aaron is langun he menge etew. Ne zutun te edtengteng dan, ne keǥiyi nu is batu he mebeǥey te wahig, ne edtudà is wahig su wey niw meveǥayi te wahig is menge etew su wey zan mekeinum duma te menge uyaǥen dan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Umbe, migkuwa ni Moises sikan is tuked puun te etuvangan te Nengazen, diyà te Kavan te Kebpekid-uyun kandan he ziyà te seled te tulda sumalà te insuǥù te Nengazen kandin. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ne hein nekuwa zin en, midtiǥum dan ki Aaron is langun he menge etew ziyà te egkesineruwan te vatu, ne migkeǥiyan sikandan ni Moises te, “Pemineg kew is menge mesinukulen, kinahanglan be he ebeǥayan dey sikiyu te wahig puun kayi te vatu?” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ne imbayew ni Moises sikan is tuked din ne midlagkut din te kezezuwa sikan is batu, ne midlepew zutun is wahig, ne mid-inum is menge etew wey is menge uyaǥen dan. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Piru migkaǥi is Nengazen diyà te ki Moises wey ki Aaron te, “Tenged te wazè kew medsarig kedì pinaaǥi te kebpaahà te kegkewaǥas ku ziyà te etuvangan te menge Israilihanen, kenè kew iyan ebpekepengulu te keduma kayi te menge etew pehendiyà te tanà he ibeǥey ku kandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Haazà he lugar migngezanan te serebseb te Meriba su mibpekidlalis is menge Israilihanen te Nengazen kayi he lugar, wey kayi zaan ipaahà te Nengazen kandan is kegkewaǥas din. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Hein diyè pa te Kadesh is menge Israilihanen, impehendiyà ni Moises is menge menunudtulè din te hadì diyà te Edom. Iyan heini impetudtul ni Moises kandan, “Heini he lalag ebpuun diyà te menge kezuzumahi nu he menge etew te Israel: Netuenan nu is langun he kemeresayan he neeǥiyan dey. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Is menge kepuun dey midhendiyà te Ehipto, ne neuǥet is ked-ubpè dey ziyà. Impaantus key wey is menge kepuun dey te menge Ehiptohanen, ");
INSERT INTO mbbOT_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","piru mibuyù key te tavang diyà te Nengazen ne mibpemineg key zin, ne midsuǥù sikandin te velinsuǥuen he mibpeǥawas kenami ziyà te Ehipto. “Guntaan kayi key te Kadesh he inged he uvey te tanè nu. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Emun egkehimu ne ituǥut nu kenami is kebayà diyà te tanè nu. Kenè key ebayà diyà te menge bevesukè nu etawa pemuleey nu te paras wey kenè key ed-inum diyà te teheb. Diyè key zà ed-ikul te zekelà he beyeey ne kenè key en ebpenuweysuwey taman te ebpekeǥawas key puun te tanè nu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Piru iyan heini tavak te hadì te Edom: “Kenà egkehimu ke ebayè kew kayi te kenami. Emun ebayè kew, edsurungen dey sikiyu ne ebpenhimetayan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Midtavak is menge Israilihanen te, “Diyè key zà ed-ikul te dekelà he zalan; ne emun ebpekeinum key wey is menge uyaǥen dey te wahig niw, ne ebeyazan dey heini. Iyan dà tuyù dey is kebayà diyà te tanè niw, ne wazè en duma.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mid-uman medtavak is hadì te Edom: “Kenè kew iyan bayà kayi.” Ne midtiǥum duen te hadì te Edom is gemhanan wey melig-en he menge sundaru su ebpekidtebek dan te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ne geina te kenà ebpeveyaan te menge tig-Edom is tanè dan, ne midsuwey en nasì is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mid-awà is tivuuk he keet-etawan te Israel diyà te Kadesh ne midhendiyè dan te Buntud he Hor. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Diyà te Buntud he Hor, he uvey te netemanan te Edom, migkeǥiyan te Nengazen si Moises wey si Aaron, ");
INSERT INTO mbbOT_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“He Aaron, neume en is timpu he idtampu ke en diyà te menge kezuzumahi nu he nemematey en. Kenè ka ebpekeseled diyà te tanà he ibeǥey ku te menge Israilihanen su midsupak kew ki Moises te suǥù ku hein diyè kew te serebseb te Meriba. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Guntaan, Moises, dumaha nu si Aaron wey is anak din he si Eleazar ziyà te Buntud he Hor. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ne luwasa nu ziyà te ki Aaron is bisti zin te kegkememumuhat ne ipevivisti heini te anak din he si Eleazar, su ebpatey si Aaron dutun te vuntud.” ");
INSERT INTO mbbOT_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Midtuman ni Moises is insuǥù kandin te Nengazen. Midtekezeg dan diyà te Buntud he Hor zutun te edtengteng is kezekelan. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ne midluwas ni Moises is bisti ni Aaron ne impeseluub din ki Eleazar. Ne minatey si Aaron diyà te puntur te vuntud. Ne midtupang si Moises wey si Eleazar zutun te vuntud. ");
INSERT INTO mbbOT_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ne hein netuenan te langun kandan he minatey en si Aaron, inlalew zan sikandin seled te 30 he andew. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Dutun he timpu is Canaanhen he hadì diyà te Arad he ed-ubpà diyà te Negev, netudtulan he ebpekeuma is menge Israilihanen he ziyà mebayà te zalan diyà te Atarim. Umbe midsurung din sikandan ne mibihag din is duma kandan. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ne nenangdù is menge Israilihanen diyà te Nengazen he ke sikandan te, “Emun ebpeveyveyaan nu kenami heini he menge etew, ibeǥey zey zaan diyà te kenikew is tivuuk he inged dan pinaaǥi te kedezeeti zey kayi.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mibpemineg te Nengazen is pengemuyù te menge Israilihanen ne impezaag din kandan is menge Canaanhen. Ne midèdeetan dan is langun he menge Canaanhen dutun ragkes en is menge inged dan, umbe migngezanan haazà he lugar te Horma. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Puun te Buntud he Hor, midhipanew is menge Israilihanen he ziyà med-ikul te zalan he ibpenhendiyà te Zaǥat he Meriǥà, he ebpekeelingkus te tanà he Edom. Piru mibperuvas is menge etew zutun te hipanew zan, ");
INSERT INTO mbbOT_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","umbe, midriklamu sikandan diyà te Megbevayà wey ziyà te ki Moises. Ke sikandan te, “Maan is impeǥawas key pa kenikew ziyà te Ehipto su wey key kayi mebpematey te sibsivayan? Wazà keenen wey wahig kayi! Neperahan key en kayi te mesemu he ‘manna’.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Umbe, mibpeuwitan sikandan te Nengazen te edhereg he menge uled ne mibpengaǥat sikandan, ne mahabet kandan is minatey. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Midhendiyà is menge etew te ki Moises ne ke sikandan te, “Nekesalè key su mezaat is menge lalag dey mehitenged te Nengazen wey kenikew. Iampù nu te Nengazen he iawè din diyà te kenami heini is menge uled.” Umbe mid-ampù si Moises para te menge etew. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Migkaǥi is Nengazen diyà te ki Moises te, “Kuwa ka te brunsi, ne veeli nu he ledawan te edhereg he uled, ne kuwa ka te idtukud nu zuen ne itaud nu ziyà te purù. Is minsan hentei he nekaǥat te uled ne edtengteng dà dutun te uled he brunsi ne egkeuyag sikandin.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Umbe, mibaal si Moises te uled he brunsi ne intaud din diyà te purù duen te intukud din. Ne is minsan hentei he nekeǥatan te uled, midtengteng dà dutun te uled he brunsi ne neuyag. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Midlaus medhipanew is menge Israilihanen, ne migkampu sikandan diyà te Obot. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ne puun te Obot, midhipanew sikandan ne migkampu zan diyà te Iye Abarim, diyà te sibsivayan he zapit te edsilaan he atbang te Moab. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ne puun dutun midhipanew sikandan ne migkampu zan diyà te zal-ug he Zered. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ne puun te Zered midlaus sikandan medhipanew ne migkampu zan diyà te uvey te veyvey te zal-ug he Arnon, he ziyà te sibsivayan he uvey te tanà te menge Amorihanen. Is Arnon iyan dulunà te tanà te menge Moabitanhen wey menge Amorihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Iyan heeyan hinungdan ke maan is ingkesurat diyà te Libru te Guǥud te Kebpekidtebek te Nengazen is inged diyà te Waheb he sakup te Sufa, is menge zal-ug ragkes en is Arnon, ");
INSERT INTO mbbOT_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","wey is alug te menge zal-ug he ebpeketemu ziyà te inged he Ar he ziyà te dulunà te Moab. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Puun diyà te Arnon midhendiyà is menge Israilihanen te Beer, kes teheb he zutun megkaǥi is Nengazen diyà te ki Moises te, “Tiǥuma nu is menge etew su ebeǥayan ku sikandan te wahig.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ne zutun kentaha te menge Israilihanen heini he kentahan: “Ebpedayun ebeǥey te wahig heini he teheb! Egkanta kiw mehitenged kayi he teheb ");
INSERT INTO mbbOT_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","he impekalut te menge pengulu wey dungganen he menge etew pinaaǥi te keǥehem dan.” Ne puun dutun he sibsivayan midhendiyè dan te Matana; ");
INSERT INTO mbbOT_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ne puun te Matana midhendiyè dan te Nahaliel; ne puun te Nahaliel midhendiyè dan te Bamot; ");
INSERT INTO mbbOT_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ne puun te Bamot midhendiyè dan te suǥud-suǥud te Moab, dutun he lugar emun diyè ki te puntur te Pisga edkepantew ta is sibsivayan. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ne midsuǥù is menge Israilihanen te menge menunudtulà diyà te ki Sihon he hadì te menge Amorihanen. Iyan heini tudtul he uwiten dan: ");
INSERT INTO mbbOT_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Emun egkehimu, ituǥut nu kenami is kebayà diyà te tanè niw. Kenè key ebayà diyà te menge bevesukè niw etawa pemuleey niw te paras wey kenè key ed-inum diyà te menge teheb niw. Ed-ikul key zà diyà te zekelà he zalan taman te ebpekeǥawas key te tanè niw.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Piru wazà mebpezumazuma si Sihon he ebayà is menge Israilihanen diyà te tanè din. Midtiǥum din hinuun is langun he menge sundaru zin ne midhendiyè dan te sibsivayan su edsurungen dan is menge Israilihanen. Hein nekeuma zan diyà te Jahaz, midtebek dan is menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Piru migerà sikandan te menge Israilihanen, ne mid-aǥew te menge Israilihanen is tanè dan puun te wahig he Arnon pehendiyà te Wahig he Jabok. Piru taman dà sikandan te dulunà te tanà te menge Amunihanen, su melig-en is berengbeng dutun te dulunà. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Umbe, naaǥew te menge Israilihanen is langun he dezekelà he inged te menge Amorihanen ne mid-ubpaan dan haazà, ragkes is Heshbon wey is langun he dezeisey he inged he sakup kayi. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Dengan, heini is Heshbon iyan lavew he inged ni Sihon te hadì te menge Amorihanen. Nezaag din dengan is sevaha he hadì te Moab ne mid-aǥew zin is langun he tanà duen te hadì taman te Arnon. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","28","Umbe, iyan heini erubasa te memetau he egkaǥi, ke sikandan te, “Agpas kew hendiyà te Heshbon, he inged ni Sihon, ne umana niw heini benguna. Dengan is menge sundaru ziyà te Heshbon, nenurung he henduen be te edriyubriyub he hapuy he nekevinsul te inged he Ar he sakup te Moab wey te metikang he menge lugar ziyà te Arnon. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mekehizuhizu kew is menge tig-Moab! Nezeetan kew is ed-azap te ed-ezapen he si Kemosh. Sikiyu is menge anak din, mibey-anan din en he mevihag ni Sihon te hadì te menge Amorihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Piru guntaan nezeetan dey en is menge Amorihanen. Nezeetan en is inged he Heshbon, ragkes is Dibon, Nofa, wey Medeba.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Umbe, mid-ubpà is menge Israilihanen diyà te tanà te menge Amorihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ne liwas dutun midsuǥù si Moises te menge meniniid diyà te Jazer, ne mid-aǥew zan daan heini wey is dezeisey he menge inged he sakup din. Midsegseg dan is menge Amorihanen he ed-ubpà dutun. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ne liwas dutun, midhendiyè dan en maan te Bashan. Piru midsurung sikandan ni Hadì Og he hadì te Bashan wey te langun he menge sundaru zin hein diyè dan pa te Edrei. ");
INSERT INTO mbbOT_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Migkaǥi is Nengazen diyà te ki Moises te, “Kenè nu kehendeki si Og su ibeǥey ku sikandin kenikew, ragkes is tivuuk he gin-etawan din wey menge tanè din. Beeli nu ziyà te kandin is mibeelan nu ziyà te ki Sihon te hadì te menge Amorihanen, he midhadì diyà te Heshbon.” ");
INSERT INTO mbbOT_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Umbe, midhimetayan te menge Israilihanen si Og, ragkes is menge anak din wey is langun he menge etew zin, ne wazà nesamà kandan. Ne liwas dutun, mid-angken te menge Israilihanen is tanà he nesakup te midhedian ni Og. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Midlaus medhipanew is menge Israilihanen taman te nekeuma zan diyà te suǥud te Moab. Ne migkampu zan diyà te zapit te edsilaan te Jordan, he etuvangan te Jerico. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ne netuenan te hadì diyà te Moab he si Balak he anak ni Zipor, is langun he mibeelan te menge Israilihanen diyà te menge Amorihanen, ");
INSERT INTO mbbOT_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ne nahandek sikandin wey is menge Moabitanhen tenged te kahabet te menge Israilihanen. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Migkaǥi is menge Moabitanhen diyà te menge perezumala ziyà te Midian te, “Ed-eminen kiw kayi te mahabet he menge etew he henduen be te vaka he ed-eminen dan edtebtava is menge sagbet.” Umbe, si Balak he anak ni Zipor, he iyan hadì diyà te Moab dutun he timpu, ");
INSERT INTO mbbOT_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","mibpesuǥuan din te menge menunudtulà si Balaam he anak ni Beor he meǥinged diyà te Petor he iyan tanà he mid-enakan kandin, he uvey te wahig he Eufrates. Iyan heini menge lalag ni Balak: “Duen menge etew he ebpuun diyà te Ehipto, utew sikandan mahabet ne kayi zan med-ubpà te uvey zey. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Umbe hendini ka ǥuntaan ne rewaki nu heini he menge etew, su edhuna sikandan he gemhanan kenami. Su kela ke mezaag ku zed sikandan ne egkesegseg ku puun kayi te tanè ku. Su netuenan ku he egketuman is ibpenuvadtuvad nu wey is idrawak nu te minsan hentei.” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Umbe, migenat is menge perezumala ziyà te Moab wey Midian he uwiten dan is ibayad ki Baalam. Midtudtulan dan heini te migkaǥi ni Balak. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ne migkaǥi si Balaam diyà te kandan te, “Kayi kew zà hizeǥà guntaan he kezukileman, ne egkeǥiyen ku ziyà te keniyu keeselem is egkeǥiyen te Nengazen kayi te kedì.” Umbe ziyà medhizeǥà haazà is menge pengulu te Moab. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ne mid-insà is Megbevayà diyà te ki Balaam, “Hentei heini is duma nu he menge etew?” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Midtavak ni Balaam is Megbevayà te, “Menge menunudtulà sikandan he midsuǥù ni Balak he hadì te Moab, he anak ni Zipor. Iyan heini menge lalag din: ");
INSERT INTO mbbOT_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Duen menge etew he ebpuun diyà te Ehipto he utew mezakel. Umbe hendini ka ǥuntaan ne rewaki nu sikandan para kedì. Su kela ke mezaag ku zed sikandan ne egkesegseg ku pehendiyà te meziyù.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Piru migkeǥiyan te Megbevayà si Balaam te, “Kenè ka zuma kandan. Ne kenè nu rewaki haazà is menge etew he egkeǥiyen dan, su midtuvazan ku sikandan.” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ked-enew ni Balaam hein meselem, migkeǥiyan din sikan is menge pengulu ni Balak te, “Ulì kew en nasì diyà te nasyun niw su kenà edtuǥut is Nengazen ke eduma a keniyu.” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Umbe, midlikù haaza is menge pengulu te Moab diyà te ki Balak he ke sikandan te, “Wazà meduma kenami si Balaam.” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ne mid-uman medsuǥù si Balak te edhuna pa he mahabet he menge pengulu wey edhuna pa he dungganen duen te nehuna he midsuǥù din. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Midhendiyè dan te ki Balaam he ke sikandan te, “Iyan heini migkaǥi ni Balak he anak ni Zipor: ‘Kenè nu mehimuwa he zuen ebpekevelavag kenikew te kedhendini. ");
INSERT INTO mbbOT_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Edsuhulan ku sikew wey ebeelan ku is minsan hengkey he egkeǥiyan nu. Pekelalaglalag ka ne hendini ke en ne rewaki nu heini he menge etew para kediey.’ ” ");
INSERT INTO mbbOT_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Piru midtavak sikandan ni Balaam t